﻿USE sofia;
DROP TABLE IF EXISTS sofia.ctu76_vpl;
CREATE TABLE ctu76_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ctu76_vpl WRITE;
INSERT INTO ctu76_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiñʌch i c'aba'ob i yumob ti ñoj oniyix jini Jesucristo. Jesucristo i jiñʌjlel David. David i jiñʌjlel Abraham. ");
INSERT INTO ctu76_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham jiñʌch i tyat Isaac. Isaac i tyat Jacob. Jacob i tyat Judá yic'ot i yermañujob Judá. ");
INSERT INTO ctu76_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá jiñʌch i tyat Fares yic'ot Zara. I ña'ob ili cha'tiquil jiñʌch Tamar. Fares i tyat Esrom. Esrom jiñʌch i tyat Aram. ");
INSERT INTO ctu76_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram jiñʌch i tyat Aminadab. Aminadab i tyat Naasón. Naasón i tyat Salmón. ");
INSERT INTO ctu76_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón i tyat Booz. I ña' Booz jiñʌch Rahab. Booz i tyat Obed. I ña' Obed jiñʌch Rut. Obed jiñʌch i tyat Isaí. ");
INSERT INTO ctu76_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí jiñʌch i tyat jini ñuc bʌ yumʌl David bʌ i c'aba'. Jini ñuc bʌ yumʌl David jiñʌch i tyat Salomón. I ña' Salomón jiñʌch i meba' 'ixic Urías tsa' bʌ pʌjyi cha'an i yijñam David. ");
INSERT INTO ctu76_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón jiñʌch i tyat Roboam. Roboam i tyat Abías. Abías i tyat Asa. ");
INSERT INTO ctu76_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa jiñʌch i tyat Josafat. Josafat i tyat Joram. Joram i tyat Uzías. ");
INSERT INTO ctu76_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías jiñʌch i tyat Jotam. Jotam i tyat Acaz. Acaz i tyat Ezequías. ");
INSERT INTO ctu76_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías jiñʌch i tyat Manasés. Manasés i tyat Amón. Amón i tyat Josías. ");
INSERT INTO ctu76_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías jiñʌch i tyat Jeconías yic'ot i yermañujob Jeconías. Jiñʌch che' ti yorojlel che' ñac ti' wersa pʌyʌyob majlel ti cʌchol pejtyelel israelob ya' ti colem pañimil Babilonia bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Che' ñac ya'ix añob ya' ti Babilonia ti ch'ocʌ i yalobil Jeconías. Salatiel bʌ i c'aba' i yalobil Jeconías. Salatiel jiñʌch i tyat Zorobabel. ");
INSERT INTO ctu76_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel jiñʌch i tyat Abiud. Abiud i tyat Eliaquim. Eliaquim i tyat Azor. ");
INSERT INTO ctu76_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor jiñʌch i tyat Sadoc. Sadoc i tyat Aquim. Aquim i tyat Eliud. ");
INSERT INTO ctu76_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud jiñʌch i tyat Eleazar. Eleazar i tyat Matán. Matán i tyat Jacob. ");
INSERT INTO ctu76_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob jiñʌch i tyat José. José jiñʌch i ñoxi'al María. María jiñʌch i ña' Jesús mu' bʌ i pejcʌntyel ti Cristo, jini tsa' bʌ yajcʌnti ti Dios cha'an i yumin quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Che' jini, c'ʌlʌ che' ñac bʌ an Abraham c'ʌlʌ che' ñac bʌ an David añob catorcejlel i yumob ti ñoj oniyix, c'ʌlʌ che' ñac bʌ an David c'ʌlʌ ti yorojlel che' ñac ti pʌjyiyob majlel ti cʌchol israelob ti pañimil Babilonia añob catorcejlel i yumob ti ñoj oniyix, c'ʌlʌ ti pʌjyiyob majlel ti Babilonia c'ʌlʌ ti ch'ocʌ Cristo añob catorcejlel i yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiñʌch bajche' ti ujti che' ñac ti ch'ocʌ Jesucristo. C'ajtibilix i cha'an José jini María i ña' Jesús. Che' max tyo ti' tyajayob i bʌ cʌñʌtyʌbilix i yalobil María, jiñʌch i cha'an Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ñoj tyoj i pusic'al José i ñoxi'al María. Mach yom i yʌc' ti quisiñil. Jin cha'an ti queji i ña'tyan mux quejel i cha' bajñel mucul cʌye'. ");
INSERT INTO ctu76_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Che' ñac chʌncol tyo i bajñel ña'tyan jini, ti ñajal José ti yilʌ juntiquil ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan. Ti' sube: José, i jiñʌjlelet bʌ David, mach yom a bʌc'ñan a pʌye' María cha'an a wijñam como jini cʌñʌtyʌbil bʌ i cha'an jiñʌch i cha'an Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mi quejel i ch'oc an alo' bʌ i yalobil. Mi quejel a wotsʌben i c'aba' JESÚS, como jini mi quejel i loc'sʌbeñob i mul i cha'año' bʌ. Che' ti subenti José ti jini ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pejtyel iliyi ti lu' ujti cha'an mi ts'ʌctiyel tsa' bʌ i wʌ alʌ lac Yum che' ñac ti' c'ʌñʌ i ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Juntiquil yoque xc'alʌl tyo bʌ mi quejel i cʌñʌtyan i yalobil. Mi quejel i ch'oc an alo' bʌ i yalobil. Mi quejel i yotsʌbeñob i c'aba' Emanuel. Che' ti yʌlʌ jini tsa' bʌ i xiq'ui yʌle' Dios. I sujmlel jini Emanuel yom i yʌle' ti lac t'an: Dios la quic'ot. Chʌ'ʌch an i sujmlel. ");
INSERT INTO ctu76_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Che' ñac ti p'ixi José, ti' cha'le bajche' ti subenti ti ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan. Ti' pʌyʌ María cha'an i yijñam. ");
INSERT INTO ctu76_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero tsa' jax tyo i cʌñʌtyʌ María jintyo ti ch'ocʌ jini ñaxan bʌ i yalobil. Ti' yotsʌbe i c'aba' JESÚS. ");
INSERT INTO ctu76_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Che' ñac ti ch'ocʌ Jesús ti Belén ya' ti pañimil Judea bʌ i c'aba', che' ñac ti yorojlel an i ye'tyel ti ñuc bʌ yumʌl jini Herodes, ti tyʌliyob ti Jerusalén winicob mu' bʌ i wen ña'tyañob i sujmlel tyac cha'an mi' q'uelob ec' tyac. Ya' ch'oyolob ti paso' q'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chʌncol i yʌlob: ¿Baqui an jini mu' bʌ quejel i cha'len ñuc bʌ yumʌl i cha'an bʌ israelob tsa' bʌ ch'ocʌ? Ti lojon quilʌ ya' ti paso' q'uin jump'ej ec' mu' bʌ i tsictisan. Ti tyʌliyon lojon cha'an lojon c ch'ujutisan. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Che' ñac ti yubi ili t'an Herodes ti wen queji ti pensal yic'ot ti pejtyelelob año' bʌ ti Jerusalén je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ti' xiq'uiyob tyʌlel ti pejtyelel jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob. Ti' c'ajtibeyob baqui mi quejel i ch'oc an jini Cristo, tsa' bʌ yajcʌnti ti Dios cha'an i yumin quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jiñob ti' subeyob: Ya' ti Belén, ya' ti pañimil Judea bʌ i c'aba'. Como jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix ti' tyaja ti t'an Belén che' ñac ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Más ñuc mi quejel i q'uejlel Belén ya' ti pañimil Judá bʌ i c'aba' che' bajche' ba'ical bʌ yambʌ lum, como ya' ti Belén mi quejel i loq'uel juntiquil ñuc bʌ yumʌl. Jini mi quejel i cʌñʌtyʌbeñoñob israelob jini c cha'año' bʌ. Che' ti yʌlʌ Dios ti' ti' jini tsa' bʌ i xiq'ui yʌle' ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Che' jini, Herodes ti' mucu pʌyʌyob tyʌlel jini mu' bʌ i wen ña'tyañob i sujmlel tyac cha'an mi' q'uelob ec' tyac. Ti' wen c'ajtibeyob baqui bʌ mero ora ti ñaxan tsictiyi jini ec'. ");
INSERT INTO ctu76_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Che' ñac jini Herodes ti' ña'tyʌ isujm, ti' xiq'uiyob majlel ya' ti Belén. Ti' subeyob: Cucula. Sajcan jini alʌl. Che' tsa'ix la' tyaja, yom mi la' subeñon cha'an mic majlel c ch'ujutisan je'el. Che' ti lolon alʌ Herodes. ");
INSERT INTO ctu76_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Che' ñac ti yubiyob i t'an jini ñuc bʌ yumʌl, ti majliyob. Jini ec' tsa' bʌ yilʌyob ya' ti paso' q'uin ti' pʌsbeyob majlel bij c'ʌlʌ ti c'oti ti' chañelel ya' ba'an jini alʌl. Ya' ti' cʌyʌ i xʌmbal jini ec'. ");
INSERT INTO ctu76_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Che' ñac ti yilʌyob ba' ti pʌs'entiyob ti ec', wen c'ajacñayob i yoj ti yubiyob jini ch'oyolob bʌ ti paso' q'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Che' ñac ti ochiyob ya' ti mal otyot ya' ti' tyajayob jini alʌl yic'ot María i ña'. Ti ñocleyob ti lum. Ti' ch'ujutisʌyob alʌl. Ti' jamʌyob i caja tyac. Ti yʌq'ueyob i majtyan tyac, oro, yic'ot pom yic'ot yowocña bʌ pimel i wentyʌlel perfume mirra bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Che' jini, ti' ñajleyob cha'an mach yom mi cha' sujtyelob ya' ba'an Herodes. Ti cha' sujtiyob majlel ti' lumal ti yambʌ bij. ");
INSERT INTO ctu76_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Che' ñac majlemobix jini winicob mu' bʌ i wen ña'tyañob i sujmlel tyac cha'an mi' q'uelob ec' tyac, ti ñajal jini José ti' q'uele juntiquil ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan. Jini ti' sube José: Tyejchen. Pʌyʌx majlel jini alʌl yic'ot i ña'. Pʌyʌ majlel ti puts'el c'ʌlʌ ti Egipto. Cʌylen ya'ya'i jintyo mic cha' subeñet. Como Herodes mi quejel i sʌclan jini alʌl cha'an i tsʌnsan. Che' ti subenti José. ");
INSERT INTO ctu76_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Che' jini, ti tyejchi José. Ti ac'bʌlel ti' pʌyʌ majlel jini alʌl yic'ot i ña'. Ya' ti majliyob ti Egipto. ");
INSERT INTO ctu76_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ya' ti poj chumleyob jintyo ti sajti Herodes. Pejtyel iliyi ti lu' ujti cha'an mi ts'ʌctiyel tsa' bʌ i yʌlʌ lac Yum che' ñac ti' c'ʌñʌ i ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Ti yʌlʌ: Ya' ti Egipto tic pʌyʌ loq'uel calobil. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jini Herodes ti' wen mich'ʌ che' ñac ti' ña'tyʌ cha'an mach cha' tyalob jini tsa' bʌ subenti i wen sʌclan jini alʌl. Ti' ña'tyʌ cha'an ti lotinti. Che' jini ti yʌc'ʌ mandar cha'an ya' ti Belén yic'ot ti pejtyelel ajchumtyʌl tyac ti joytyʌlel mi' tsʌnsañob ti pejtyelelob jini saj alob am bʌ cha'p'ej i jabilel yic'ot más i saj tyac. Ti' pensali jayp'ej i jabilel Jesús cha'an bajche' ti yʌlʌyob jini winicob mu' bʌ i wen ña'tyan i sujmlel tyac cha'an mi' q'uelob ec' tyac che' ñac ti' ñaxan subeyob Herodes. ");
INSERT INTO ctu76_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chʌ'ʌch ti ts'ʌctiyi ñoj cabʌl i ch'ʌjyemlel quixtyañu che' bajche' ti' wʌ ts'ijbu juntiquil tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, Jeremías bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Jini ti yʌlʌ: Ya' ti Ramá ti ubinti c'am bʌ uq'uel, cabʌl uq'uel yic'ot wo'ocña bʌ uq'uel; chʌncox i yuc'tyañob i yalobilob jini israelo' bʌ x'ixicob. Ma'an majch ch'ujbi i lajmisʌben i ch'ʌjyemlel, como sajtyemobix i yalobilob. Che' ti' wʌ ts'ijbu jini tsa' bʌ i xiq'ui yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pero che' ñac sajtyemix Herodes, juntiquil ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan ti' pejcʌ José ti ñajal ya' ba' chumul ya' ti Egipto. Ti' sube: ");
INSERT INTO ctu76_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tyejchen. Pʌyʌ majlel jini alʌl yic'ot i ña'. Cha' cucux ya' ti i lumal Israel. Como tsa'ix sajtiyob jini tsa' bʌ i jop'oyob i tsʌnsan jini alʌl. Che' ti subenti José. ");
INSERT INTO ctu76_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ti p'ixi José. Ti' pʌyʌ majlel jini alʌl yic'ot i ña' che' bajche' ti subenti. Ti c'otiyob ya' ti i lumal Israel. ");
INSERT INTO ctu76_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero José ti yubi t'an cha'an chʌncox ti yumʌl jini Arquelao ya' ti pañimil Judea, como jini ti' ch'ʌmbe i ye'tyel i tyat. Herodes i tyat jini Arquelao. Jin cha'an ti' bʌc'ñʌ majlel José ya'i. Ti' cha'le yambʌ ñajal José. Ti subenti ti ñajal cha'an mi majlel ya' ti Galilea bʌ i c'aba' bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Che' ñac ti c'otiyob ya' ti Galilea ti majliyob ti chumtyʌl ti jump'ej saj lum Nazaret bʌ i c'aba'. Pejtyel iliyi ti lu' ujti cha'an mi ts'ʌctiyel tsa' bʌ i wʌ alʌyob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, como ti yʌlʌyob cha'an mi quejel i pejcʌntyel Jesús ti nazareno. ");
INSERT INTO ctu76_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti jim bʌ ora che' ñac ya' tyo an ti Nazaret Jesús, jini Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja' ti c'oti ti subt'an ya' ti tyʌquin bʌ joch lum ya' ti Judea bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ti yʌlʌ: Q'uextyan la' pensal, cʌyʌx la' mul como lʌc'ʌlix i tyʌlel jini tsa' bʌ chojqui tyʌlel ti Dios, jini mu' bʌ i cha'len yumʌl ya' ti panchan. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jini Juan, jiñʌch tsa' bʌ i tyaja ti t'an tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, Isaías bʌ i c'aba'. Ti' ts'ijbu: Ti ubinti i t'an juntiquil mu' bʌ ti c'am bʌ t'an ya' ti tyʌquin bʌ joch lum. Mi yʌl: Tyoj isʌbenla majlel i bijlel lac Yum. Pʌtbenla majlel tyoj bʌ i bijlel. Che' ti yʌlʌ Dios. Che' ts'ijbubil i cha'an Isaías. ");
INSERT INTO ctu76_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jini Juan melel i pislel ti i tsutsel bʌ camello yic'ot pʌchij bʌ i cinturón. Mi' c'uxe' che' bʌ bajche' colem xtyopi' yilal yic'ot ya'lel chab. ");
INSERT INTO ctu76_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Cabʌl ti c'otiyob ba'an Juan cha'an mi yubiñob t'an. Ti c'otiyob tyʌlemo' bʌ ti Jerusalén yic'ot ti pejtyelel año' bʌ ti pañimil Judea bʌ i c'aba' yic'ot ti c'otiyob tyʌlemo' bʌ ti ajchumtyʌl tyac ya' lʌc'ʌl jini colem ja' Jordán bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Che' ñac ti' subuyob i mul, Juan ti yʌc'ʌyob ti ch'ʌm ja' ya' ti Jordán. ");
INSERT INTO ctu76_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pero che' ñac jini Juan ti yilʌ cha'an chʌncol i tyʌlelob cabʌl fariseojob yic'ot saduceojob cha'an mi yʌq'uentyelob ch'ʌm ja' ti' subeyob: Jatyetla lajaletla bajche' lucum tyac yom bʌ i puts'tyan c'ajc. ¿Majchqui ti' subeyetla cha'an mi la' puts'tyan jini ñoj tsʌts bʌ xot'mulil mach bʌ jal mi quejel i tsictiyel? ");
INSERT INTO ctu76_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ajñenla ti wen cha'an mi tsictiyel tsa'ix la' q'uextyʌ la' pensal, tsa'ix la' cʌyʌ la' mul. ");
INSERT INTO ctu76_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mach yom la' lolon ña'tyan cha'an mach'an chʌ bʌ mi mejlel i tyumbeñetla. Joñonla i jiñʌjlelonla Abraham, che'etla. Mach yom mi la' bajñel lo'lon la' bʌ. Como mic subeñetla Dios ch'ujbi i pʌntisan ti jiñʌjlel Abraham jini tyun tyac mi yom. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jatyetla che' bajche' tye' tyac mach'ʌ ba'an mi yʌc' i wut. Pero wale i yorojlelix mi sejq'uel i wi' tye' tyac ti hacha. Mi mach'an ti yʌc'ʌ wen bʌ i wut jini tye' mi quejel i lu' sejq'uel jubel. Mi quejel i pulel ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Melel, joñon mi cʌq'uen ch'ʌm ja' ti ja' cha'an i señʌjlel ti' q'uextyʌ i pensal ti' cʌyʌ i mul quixtyañu. Pero más p'ʌtyʌl bajche'on jini mu' tyo bʌ quejel i tyʌlel. Jini mi quejel i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ i Ch'ujlel Dios yic'ot c'ajc yubil. Ma'ix ñucon cha'an mi jinic mi cotsan c bʌ ti ajtroñel jach bʌ i cha'an yubil cha'an mic loc'sʌben i zapatos, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Añʌch i wejlʌjib cha'an i wejlan loq'uel i sujl trigo. Mi quejel i much'quin jini trigo ti i yotyotlel cha'an mi' cʌñʌtyan, pero mi quejel i pule' i sujl ti c'ajc mach'ʌ yujil yajpel. Che' ti yʌlʌ Juan. Chʌ'ʌch ti' cha'le lajoñel Juan cha'an i sujl trigo. ");
INSERT INTO ctu76_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Che' jini ti loq'ui Jesús ti Galilea. Ti c'oti ya' ba'an Juan ya' ti Jordán bʌ ja' cha'an mi' ch'ʌme' ja' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan ti' jop'o i tiq'ue' Jesús. Ti' sube: Jini yom bʌ, jiñʌch cha'an jatyet ma' wʌq'ueñon ch'ʌm ja'. ¿Chucoch ma' tyʌlel ba'añon cha'an ma' ch'ʌme' ja'? Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús ti' jac'ʌ: Pero wale, yom ma' wʌq'ueñon ch'ʌm ja'. Como chʌ'ʌch yom cha'an mi lac cha'len pejtyelel bajche' mi' xic'onla Dios, che'en. Che' jini Juan ti' jac'ʌ i yʌq'uen ch'ʌm ja' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Che' ñac ti ujti i ch'ʌme' ja', Jesús ti loq'ui ti ja'. Che' jini, ti wa' jajmi ya' ti panchan. Jesús ti yilʌ Ch'ujul bʌ i Ch'ujlel Dios chʌncox i jubel tyʌlel ti chañelel i jol. Che' yilal bajche' x'ujcutsu'. ");
INSERT INTO ctu76_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Che' jini ti yubiyob ajt'an ya' bʌ loq'uem ti panchan. Ti yʌlʌ: Jiñʌch calobil p'untyʌbil bʌ c cha'an. Tijicñayon cha'an bajche' mi' cha'len. Che' ti yʌlʌ jini ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ti ujti jini, jini Ch'ujul bʌ i Ch'ujlel Dios ti wa' pʌyʌ majlel Jesús ya' ti tyʌquin bʌ joch lum cha'an mi' jop' i yotsʌben i mul Jesús jini xiba. ");
INSERT INTO ctu76_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ti ñumi cuarenta q'uin cuarenta ac'bʌlel mach'an chʌ bʌ ti' saj c'uxu Jesús. Che' jini ti yubi wi'ñal. ");
INSERT INTO ctu76_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Che' jini, ti c'oti i lʌq'ue' Jesús jini xiba. Ti' sube: Mi melelʌch i yalobilet Dios, suben ili tyun tyac cha'an mi' pʌntiyel ti waj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero Jesús ti' jac'ʌ: Ti Ts'ijbubil bʌ i T'an Dios mi yʌl: Mach ti waj jach cuxul quixtyañu pero cuxul je'el cha'an ti pejtyelel t'an tsa' bʌ i yʌlʌ Dios. Che' ti jac'ʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Che' jini, xiba ti' pʌyʌ majlel Jesús ya' ti Jerusalén mu' bʌ i pejcʌntyel ti ch'ujul bʌ lum. Ti' pʌyʌ letsel ti' pam jini chan bʌ templo. ");
INSERT INTO ctu76_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Che' jini, xiba ti' sube: Mi melelʌch i yalobilet Dios choco jubel a bʌ c'ʌlʌ ti lum, como ti Ts'ijbubil bʌ i T'an Dios mi yʌle': Dios mi quejel i xiq'ue' tyʌlel ajtroñelob i cha'an ch'oyolo' bʌ ti panchan cha'an i cʌñʌtyañet. Mi quejel i chuquetyob ti i c'ʌb cha'an mach'an ma' low a woc ti tyun. Che' ts'ijbubil, che' ti yʌlʌ xiba. ");
INSERT INTO ctu76_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús ti' jac'ʌ: Mi yʌl je'el ti Ts'ijbubil bʌ i T'an Dios: Mach yom a jop' a wil pusic'len la' Yum la' Dios. Che' ts'ijbubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Che' jini, xiba ti' pʌyʌ majlel Jesús ya' ti chan bʌ wits. Ya' ti' lu' pʌsʌ Jesús ba' lu' tsiquil pejtyelel pañimil tyac am bʌ ti mulawil yic'ot ti pejtyelel i c'otyajlel. ");
INSERT INTO ctu76_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xiba ti' sube Jesús: Mux c lu' aq'ueñet ti pejtyelel jini chʌncol bʌ a q'uel mi mux a ñocchocon a bʌ tic t'ejl a ch'ujutisañon. Che' ti subenti Jesús ti xiba. ");
INSERT INTO ctu76_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Che' jini Jesús ti' sube: Satanás, loq'uen wʌ' tic t'ejl. Ti Ts'ijbubil bʌ i T'an Dios mi yʌl: Ch'ujutisan la' Yum la' Dios. Jin jach ma' yumin. Che' ti' jac'ʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Che' jini xiba ti loq'ui majlel ya' ba'an. Ajtroñelob i cha'an Dios ch'oyol bʌ ti panchan ti tyʌliyob i yʌq'uen Jesús chʌ bʌ yom i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Che' ñac ti yubi Jesús an ti cʌchol Juan, ti majli ti pañimil Galilea bʌ i c'aba'. Ya'an lum Nazaret bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero mach'an ti jale ya'i. Ñumel jach ti ñumi ya' ti Nazaret. C'ʌlʌ ti majli ti chumtyʌl ti jump'ej lum Capernaum bʌ i c'aba' ya' ti t'ejl colem joyol bʌ ja' ya' ba' tyʌc'ʌl Zabulón yic'ot Neftalí bʌ i c'aba' bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chʌ'ʌch ti ujti cha'an mi' ts'ʌctiyel tsa' bʌ i yʌlʌ jini tsa' bʌ i xiq'ui yʌle' Dios Isaías bʌ i c'aba'. Jini ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Quixtyañujob ya' bʌ chumulob ti pañimil tyac Zabulón yic'ot Neftalí bʌ i c'aba', yic'ot ya' ti' ti' colem ja', yic'ot ya' ti junxej Jordán ja', yic'ot jini año' bʌ ti Galilea, i lumal jini mach bʌ israelo' bʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ili quixtyañujob ti' chumleyob ti ic'jowan bʌ pañimil yubil. Pero wale tsa'ix yilʌyob colem bʌ i sʌclel pañimil. Ili quixtyañujob che' bajche' sajtyemob yubil, como mach'an ti' ña'tyʌyob bajche' yom i yajñelob. Pero wale tsa'ix yilʌyob i sʌclel pañimil. Che' ti yʌlʌ jini tsa' bʌ i xiq'ui yʌle' Dios Isaías bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Che' jini, ti jim bʌ ora Jesús ti queji ti subt'an. Ti yʌlʌ: Q'uextyan la' pensal. Cʌyʌx la' mul como lʌc'ʌlix i yorojlel mi quejel ti yumintyel Dios wʌ' ba' añetla. Che' ti' cha'le subt'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Che' ñac chʌncol ti xʌmbal majlel Jesús ya' ti' ti' colem joyol bʌ ja' Galilea bʌ i c'aba', ti yilʌ cha'tiquil winicob. I yijts'iñob i bʌ. Jiñʌch Simón yic'ot Andrés. Simón an i cha'chajplel bʌ i c'aba' Pedro. Ijts'iñʌl jini Andrés. Chʌncol i chocob ochel i chimol chʌy ti colem ja' como ajchuc chʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Che' jini, Jesús ti' subeyob: La', tsʌcleñon majlel. Che' bajche' ti la' sajcʌbe chʌy mi quejel cʌq'ueñetla la' sajcʌben quixtyañujob cha'an mi quejel i ch'ujbiñoñob c t'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ti wa' cʌyʌyob i chimol chʌy Simón yic'ot Andrés. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ti' ts'itya' cha' xʌñʌ majlel. Ti yilʌyob yambʌ cha'tiquil i yijts'iñob i bʌ, jiñʌch Jacobo i yalobil Zebedeo yic'ot i yijts'in Juan bʌ i c'aba'. Ya' añob ti barco yic'otyob i tyat. Chʌncol i lʌwob i chimol chʌy. Jesús ti' pʌyʌyob cha'an i tsʌclen majlel. ");
INSERT INTO ctu76_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ti' wa' cʌyʌyob i barco yic'ot i tyat. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús ti ñumi majlel ti pejtyelel Galilea. Ti ochi ti i templo israelob ti jujump'ej lum ba' ti ñumi. Ti' cʌntisʌyob ti jini wen t'an cha'an bajche' chʌncol ti yumintyel Dios. Ti' lajmisʌ pejtyelel chʌ bʌ tyac ti c'am'an mu' bʌ yubiñob quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ti pejtyelel pañimil Siria bʌ i c'aba' ti' pam pujqui i t'ʌñʌlel bajche' chʌncol i cha'len Jesús. Ti' pʌyʌyob tyʌlel ti pejtyelel chʌncol bʌ i yubiñob chʌ bʌ tyac bʌ wocol ti' bʌc'tyal yic'ot xc'am'añob yic'ot chʌncol bʌ i yubin chʌ bʌ c'ux tyac yic'ot tyʌc'lʌbilo' bʌ ti xiba yic'ot mu' bʌ i yubin jits'cuyel yic'ot mach'ʌ ba'an i c'ʌjnibal i yoc i c'ʌb. Jesús ti' lu' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ti' tsʌcleyob majlel Jesús yonlel quixtyañu tyʌlemo' bʌ ti Galilea yic'ot ti diez lum tyac Decápolis bʌ i c'aba', yic'ot ya' ti Jerusalén, yic'ot ya' bʌ tyʌlemob ti pañimil Judea yic'ot tyʌlemo' bʌ ya' ti junxej Jordán bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Che' ñac ti yilʌ Jesús ya'an quixtyañujob ti letsi ya' ti wits. Ya' ti buchle ya'i. Che' ya' buchul Jesús, ti' joyoyob i bʌ ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ti queji ti cʌntisa Jesús. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tijicñayob jini mu' bʌ i ña'tyañob cha'an mach'an i bajñel wenlel i pusic'al como jiñob mi quejel i yajñel ba' mi' cha'len yumʌl Dios ya' ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tijicñayob jini ch'ʌjyemo' bʌ como mi quejel i ñuc isʌbentyelob i pusic'al ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tijicñayob jini mu' bʌ i ju'san i bʌ como mi quejel i yʌq'uentyelob ti pejtyelel wen tyac bʌ i cha'an bʌ mulawil bajche' ti wʌ alʌ Dios mi quejel i yʌq'uentyelob. ");
INSERT INTO ctu76_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tijicñayob jini año' bʌ i wi'ñal yubil cha'an wersa yom ajnic ti tyoj bajche' yom Dios, como Dios mi quejel i cotyan cha'an mi yajñel ti tyoj. ");
INSERT INTO ctu76_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tijicñayob jini mu' bʌ i p'untyañob i pi'ʌlob cha'an yom i cotyañob, como mi quejel i p'untyʌntyelob ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tijicñayob jini sʌco' bʌ i pusic'al como mi quejel i q'uelob Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tijicñayob jini mu' bʌ i ñʌch'tisʌbeñob i pusic'al quixtyañujob cha'an mi lajmelob ti periyal, como Dios mi quejel i pejcañob ti i yalobil jini mu' bʌ i lajmisan periyal. ");
INSERT INTO ctu76_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tijicñayob jini chʌncol bʌ i lolon tyʌc'lʌntyelob ti i pi'ʌlob cha'an ti caj mi yajñelob ti tyoj, como mi quejel i yʌq'uentyelob i yajñel ba' mi' cha'len yumʌl Dios ya' ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Yom tijicñayetla che' mi la' lolon al'entyel, che' mi la' ts'a'lentyel, che' an cabʌl lolon jop't'an ti la' tyojlel cha'an ti caj ti la' ch'ujbiyon. ");
INSERT INTO ctu76_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mi chʌ'ʌch mi yujtyel, yom c'ajacña la' woj. La' ñʌch'lec la' pusic'al como mi quejel la' wʌq'uentyel ñuc bʌ la' majtyan ya' ti panchan. Chʌ'ʌch je'el ti tyʌc'lʌntiyob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesús ti' bej cha'le cʌntisʌ. Ti yʌlʌ: Jatyetla i yʌts'miletla mulawil yubil. Como cha'an ti la' caj an tsa' bʌ uts isʌbentiyob. Pero mi ti jili i tsajel mach'an chʌ bʌ i c'ʌñʌ i cha' tsaj isʌntyel jini ats'am. Mach'an sajlic i c'ʌjnibal. Che' jach mi chojquel ya' ba' mi' pejchic'tyec' quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Jatyetla i sʌcleletla mulawil yubil. Como che' bajche' colem bʌ lum ya' ti pam bujtyʌl mach ch'ujbi mʌctyʌntyel pero bej tsiquilʌch. Lajal bajche' jini yom bej tsiquil i yutslel la' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Che' mi tsujq'uel cas mach'an mi yʌjq'uel ti yebal jump'ej caja. Pero mi yʌjq'uel ti joc'lib cha'an mi lu' tsictiyel i c'ʌc'al ba'an pejtyelel año' bʌ ti otyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Che' je'el jatyetla yom mi la' pʌse' an i sʌclel la' pusic'al cha'an mi' q'uel quixtyañujob. Che' jini che' mi yilañob jini wen bʌ la' cha'libal mi quejel i subob i ñuclel lac Tyat am bʌ ti panchan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Mach yom la' lolon ch'ujbin cha'an ti tyʌliyon c lajmisan i mandar Moisés mi jinic i cʌntisa jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Mach'an ti tyʌliyon c lajmisan. Pero ti tyʌliyon cha'an mic ts'ʌctisan tsa' bʌ ñaxan alʌ Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Como melelʌch mic subeñetla. C'ʌlʌ che' an tyo panchan yic'ot mulawil, mach'an mi quejel i yajpel mi jump'ejlic letra mi jump'ejlic punto ti jini mandar tsa' bʌ ts'ijbunti ti ñoj oniyix jintyo mi ts'ʌctiyel ti pejtyelel bajche' ti wʌ ajli. ");
INSERT INTO ctu76_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jin cha'an, majchical jach mi' ñusan ba'ical bʌ mandar aunque mach ñuc bʌ mandar mi' lolon ña'tyan yic'ot mi ti cʌntisʌ yambʌ quixtyañujob cha'an mi' ñusan jini mandar je'el, mi quejel i q'uejlel che' bajche' ma'ix i c'ʌjnibal bʌ quixtyañu ya' ti panchan ba' mu' ti yumʌl Dios. Pero jini mu' bʌ i ch'ujbiñob jini mandar tyac yic'ot mi' cʌntisan quixtyañujob i ch'ujbiñob mi quejel i q'uejlel ti ñuc ya' ti panchan ba' mu' ti yumʌl Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Como mic subeñetla: Mi mach'an mi la' wajñel ti más tyoj che' bajche' mi yajñelob jini junmujch' ajcʌntisajob cha'an i mandar israelob mi jinic quixtyañu fariseojo' bʌ i c'aba' mach'an mi quejel la' wʌq'uentyel la' wochel ya' ti panchan ba' mu' ti yumʌl Dios. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Tsa'ix la' wubi bajche' ti subentiyob la' yumob ti ñoj oniyix: Mach la' cha'len tsʌnsa. Majchical mu' bʌ i cha'len tsʌnsa, wersa mi quejel i mel i bʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero joñon mic subeñetla: Majchical jach mi' lolon mich'q'uel i pi'ʌl wersa mi quejel i mel i bʌ. Jini mu' bʌ i wajlen juntiquil i pi'ʌl mi quejel i mel i bʌ ba'an año' bʌ ye'tyel. Jini mu' bʌ i suben i pi'ʌl ti sojquem i jol cha'an ti caj mich' yic'ot mi quejel i chojquel ochel ti xot'mulil ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Che' chʌncol a majlel a wʌq'uen i majtyan Dios ya' ti yajnib ba' mi pulbentyel i majtyan Dios mi ti c'ajtiyi a cha'an mi an chʌ bʌ ti mulil ti a cha'le ti' contra juntiquil a pi'ʌl mi lolon ubin, ");
INSERT INTO ctu76_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","poj cʌyʌ jini i majtyan Dios ya' ti t'ejl i yajnib ba' mi pulbentyel i majtyan Dios. Cucu. Ñaxan pejcan a wermañu cha'an mi lajmel jini contra. Che' jini ch'ujbi a cha' sujtyel ya' ba' ti a cʌyʌ i majtyan Dios cha'an ma' wʌq'uen Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mi an majch mi' contrajiñet, yom i pʌyet majlel cha'an mi la' mel la' bʌ ba'an am bʌ i ye'tyel yom mi la' wa' pejcan ti ora cha'an mi' cha' uts an a wic'ot che' añet tyo la ti bij, che' max tyo c'otyetla ba'an jini am bʌ i ye'tyel. Como jini am bʌ i ye'tyel mi quejel i yʌq'uet ti' c'ʌb policía. Jini policía mi quejel i yotsañet ti cʌchol. ");
INSERT INTO ctu76_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Melel mic subeñet che' ya'ix añet ti cʌchol ma' mi quejel a cha' loq'uel jintyo ma' lu' tyoj a mul. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Tsa'ix la' wubi tsa' bʌ ajli ti ñoj oniyix: Mach a pejcʌben i yijñam a pi'ʌl. Che' ti ajli. ");
INSERT INTO ctu76_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero joñon mic subeñetla: Mi an majch mi' q'uele' x'ixic cha'an ti' bajñel i pusic'al mi' ña'tyan cha'an wersa yom i pejcan, tsa'ix i cha'le tsuculel yic'ot ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mi chʌncol i yʌq'ueñet a wotsan a mul a ñoj bʌ a wut loc'san ti ora. Choco loq'uel. Más wen mi ti a sʌtyʌ jump'ej a wut che' bajche' mi ts'ʌcʌl a bʌc'tyal ti chojquiyet ochel ti xot'mulil ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mi chʌncol i yʌq'ueñet a wotsan a mul a ñoj bʌ a c'ʌb wa' tsepe loq'uel. Choco ti ñajt. Más wen che' xmol c'ʌbet che' mi ts'ʌcʌl a bʌc'tyal ti chojquiyet ochel ti xot'mulil ti c'ajc. Chʌ'ʌch ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Yic'ot je'el ti ajli ti ñoj oniyix: Majchical mi' cʌye' i yijñam yom i yʌq'uen i juñilel cha'an tsiquil cʌyʌlix i cha'an. Che' ti ajli ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero joñon mic subeñetla: Mi juntiquil winic mi' cʌye' i yijñam cha'an i pʌye' yambʌ i yijñam, che' mach cha'anic ti' cha'le i tsuculel yic'ot yambʌ winic jini i yijñam, che' jach chʌncol i yʌq'uen i cha'len i tsuculel. Jini mu' bʌ i pʌye' cʌyʌl bʌ x'ixic mi' cha'len i tsuculel je'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tsa'ix la' wubi bajche' ti subentiyob la' yumob ti ñoj oniyix: Mi ti a tyajbe i c'aba' Dios cha'an a wa'chocon a t'an mach yom ma' saj ñusan a cha'len ti pejtyelel tsa' bʌ a wʌlʌ. Chʌ'ʌch ti subentiyob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero joñon mic subeñetla: Mach yom la' lolon tyaje' ti t'an chʌ bʌ tyac jach cha'an i wa'chocontyel la' t'an. Mach yom la' tyaje' ti t'an panchan como jiñʌch i buchlib Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mach yom la' tyaje' ti t'an mulawil como i yumʌch mulawil Dios. Mach yom la' tyaje' ti t'an Jerusalén cha'an i wa'chocontyel a t'an como mu' ti yumʌl Dios ya' ti Jerusalén. Che' bajche' chʌncox a tyaj ti t'an i c'aba' Dios yubil, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mach yom la' tyaje' ti t'an la' jol cha'an i wa'chocontyel la' t'an. Como mach ch'ujbi la' sʌc isan la' wiq'uisan mi junt'umic. ");
INSERT INTO ctu76_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jin jach mi la' wʌl chʌ'ʌchi mi chʌ'ʌchi, mi mach che'iqui mach che'iqui, che'etla. Mi ti la' más alʌ yambʌ t'an cha'an i wa'chocontyel la' t'an tyʌlem ti xiba, che' jini. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Tsa'ix la' wubi tsa' bʌ ajli ti ñoj oniyix: Mi an majch mi' tyomben i wut juntiquil i pi'ʌl wersa mi tyombentyel i cha'an je'el. Mi an majch mi' c'ocben i yej juntiquil i pi'ʌl, wersa mi c'ocbentyel i cha'an je'el. Chʌ'ʌch ti ajli ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero joñon mic subeñetla: Mach yom la' q'uextyan i simaronlel jini mu' bʌ i ts'a'q'uelet. Pero jiñʌch bajche' yom: Mi an majch mi' jats'et ti junwej a choj, aq'uen i jats'et ti yambʌ junwej je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Mi an majch mi' contrajiñet, mi yom i yʌq'uet ti melol cha'an i wersa ch'ʌme' a bujc, aq'uen i ch'ʌme' a bujc yic'ot a tsuts bujc je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mi an majch mi' wersa xiq'uet ti cuchejel jump'ej legua, cucu a wic'ot cha'p'ej legua. ");
INSERT INTO ctu76_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Majchical jach mi niq'ui c'ajtibeñet, aq'uen. Che' an chʌ bʌ mi' c'ajtibeñet ti majan, aq'uen i majñan. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Tsa'ix la' wubi tsa' bʌ ajli ti ñoj oniyix. Ti ajli: P'untyan uts bʌ a wic'ot. Ts'a'q'uel a contra. Chʌ'ʌch ti ajli ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero joñon mic subeñetla: P'untyan la' contrajob. Aq'ueñob i yutslel la' t'an mu' bʌ i tyajetla ti mach'ʌ wen bʌ t'an. Cha'liben wen bʌ mu' bʌ i ts'a'leñetla. Pejcʌbenla Dios ti oración mu' bʌ i tyʌc'lañetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Mi chʌ'ʌch mi la' cha'len, tsiquil che' jini, cha'an i yalobiletla Dios am bʌ ti panchan. Como Dios mi yʌq'uen i pasel q'uin cha'an i wenlel simaroño' bʌ lajal che' bajche' cha'an utso' bʌ. Lajal mi yʌq'uen i ñumel ja'al ba'an utso' bʌ yic'ot simaroño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pero mi jin jach mi la' p'untyan mu' bʌ i p'untyañetla ¿wen ba ma' q'uejlel ti Dios ma' lolon al? Mach'an. Como jinic tyo jini xlot bʌ xch'ʌm tyojoñel mi' p'untyañob jini utso' bʌ yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Mi jin jach uts mi la' pejcan utso' bʌ la' wic'ot ¿chutyoqui wenlel chʌncol la' cha'len ma' lolon al? como jinic tyo jini mach'ʌ ba'an mi' ch'ujbin Dios mi' uts pejcañob utso' bʌ yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jin cha'an yom ts'ʌcʌl i yutslel la' pusic'al che' bajche' ts'ʌcʌl i yutslel i pusic'al lac Tyat am bʌ ti panchan. Chʌ'ʌch ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Q'uele la' bʌ cha'an mach'an mi la' cha'len wen bʌ la' cha'libal ti wut jach la' pi'ʌlob cha'an jach la' wom i q'ueletla ti wen. Como mi chʌ'ʌch mi la' cha'len ma' mi quejel i yʌq'ueñetla i tyojol la' cha'libal lac Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Jin cha'an che' ma' cotyan p'ump'uño' bʌ mach yom ma' sub a bʌ ba'an quixtyañujob cha'an i lu' ubiñob bajche' chʌncol a cha'len. Como chʌ'ʌch mi' lolon cha'leñob cha'chajpo' bʌ i pensal che' mi' cotyañob jini mu' bʌ i tyajob ya' ti i templo israelob yic'ot ya' ti bij tyac. Chʌ'ʌch mi' cha'leñob cha'an mi yʌjlel ti wen ti' tyojlel quixtyañujob. Pero melel mic subeñetla cha'an che' jach yom i yʌc'ob i bʌ ti q'uejlel ti wen ba'an quixtyañujob mach'an chʌ bʌ mi quejel i yʌq'uentyel ti Dios cha'an i tyojol yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero jatyetla che' mi la' wʌq'uen chʌ bʌ mi la' wʌq'uen cha'an i cotyʌntyel p'ump'uño' bʌ, aq'ueñob che' ma' majch mi yilan chʌ bʌ ti a cha'le, mi jinic más uts bʌ a wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Che' mi la' cotyañob p'ump'uño' bʌ, mucu aq'ueñob jini mu' bʌ a wʌq'ueñob. Che' jini, lac Tyat am bʌ ti panchan chʌncol bʌ i lu' q'uel chʌ bʌ mi' mucu cha'len quixtyañujob mi quejel i yʌq'ueñetla i tyojol la' cha'libal. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Che' mi la' cha'len oración mach yom la' cha'len bajche' cha'chajpo' bʌ i pensal. Como jini mi' mulan i cha'leñob oración che' wa'alob ti i templo israelob yic'ot ti xujc tyac calle cha'an jach mi q'uejlelob ti quixtyañujob. Pero melel mic subeñetla cha'an chʌ'ʌch mi yʌc'ob i bʌ ti q'uejlel ti wen ba'an quixtyañujob tsa'ix aq'uentiyob i tyojol yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero jatyetla, che' mi la' cha'len oración, ochen ti mal a wotyot. Ñup'u i ti' a wotyot. Pejcan lac Tyat am bʌ ti panchan como ya'ix an a wic'ot ti a pusic'al. Lac Tyat am bʌ ti panchan chʌncol bʌ i lu' q'uel chʌ bʌ mi' mucu cha'len quixtyañujob mi quejel i yʌq'ueñetla i tyojol la' cha'libal, yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Che' mi la' cha'len oración, mach yom la' chʌc tyaj lajal bʌ t'an cha'an jach mi la' bajñel tyam'isan la' woración che' bajche' mi' lolon cha'leñob jini mach'ʌ ba'an mi' ch'ujbiñob Dios. Como mi' lolon ña'tyañob mi yubintyel i yoración cha'an cabʌl i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pero mach che'ic yom la' cha'len. Como jini lac Tyat am bʌ ti panchan yujil isujm chʌ bʌ yes yom la' cha'an che' max tyo la' c'ajtiben. ");
INSERT INTO ctu76_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jin cha'an chʌ'ʌch yom mi la' cha'len oración. Yom mi la' wʌl: C Tyat lojon, ya' bʌ añet ti panchan, la' ch'ujutisʌntiquet. ");
INSERT INTO ctu76_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","La' yumintiquet. La' mejlic chʌ bʌ a wom wʌ' ti mulawil, che' bajche' mi mejlel chʌ bʌ a wom ya' ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aq'ueñon lojon c waj i c'ʌjnibal bʌ lojon c cha'an ti ili bʌ q'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ñusʌbeñon lojon c mul che' bajche' mi lojon c ñusʌbeñob i mul lojon c pi'ʌlob je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Cʌñʌtyañon lojon cha'an mach cac' lojon c pʌyol ti mulil, coloyon lojon ti i p'ʌtyʌlel jini mach'ʌ wen. Como a cha'añʌch a yumintyel yic'ot a p'ʌtyʌlel yic'ot a ñuclel ti pejtyelel ora. Amén. ");
INSERT INTO ctu76_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Como che' mi la' ñusʌbeñob i mul la' pi'ʌlob, lac Tyat am bʌ ti panchan mi quejel i ñusʌbeñetla la' mul je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero mi mach'an mi la' ñusʌbeñob i mul la' pi'ʌlob, mach'an mi quejel i ñusʌbeñetla la' mul lac Tyat am bʌ ti panchan. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Che' mi la' poj ch'ajban ti pejtyelel mu' bʌ la' c'ux, mu' bʌ la' jap cha'an la' wom la' p'untyan Dios, mach yom la' pʌs ti ch'ʌjyem i ñi' la' wut che' bajche' mi' cha'leñob jini cha'chajpo' bʌ i pensal. Como mi' pʌsob ch'ʌjyem bʌ i ñi' i wut cha'an jach yom i tsictisʌbeñob quixtyañu cha'an muc'ob ti ch'ajb. Pero melel mic subeñetla che' jach mi' cha'leñob cha'an mi' pʌsob i bʌ ti wen ti quixtyañujob. Che' jini, tsa'ix aq'uentiyob i tyojol yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero jatyetla, che' mi la' poj cha'len ch'ajb, mach yom la' pʌs la' bʌ che' bajche' ch'ʌjyemetla. Pero poco la' wut, xiban la' jol, ");
INSERT INTO ctu76_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","cha'an mach'an mi' ña'tyan quixtyañujob cha'an muq'uet ti ch'ajb. Jin jach lac Tyat am bʌ ti panchan mi quejel i ña'tyan, como ya'ix an a wic'ot ti a pusic'al. Mi quejel i yʌq'ueñet a tyojol yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mach yom la' much'quin cabʌl chʌ bʌ an la' cha'an wʌ' ti mulawil. Como an mu' bʌ quejel ti joch'. An mu' bʌ quejel ti tsuculiyel. An mu' bʌ quejel i yochel ajxujch' i xujch'ibeñetla. ");
INSERT INTO ctu76_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Yom bʌ yi, much'quin la' ricojlel ya' ti panchan ba' ma' mi joch'iñel, ba' ma' mi tsuculiyel, ba' ma' mi yochel ajxujch' i xujch'ibeñetla. ");
INSERT INTO ctu76_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Como jini mu' bʌ a q'uel ti más ñuc, mi jini am bʌ ti panchan mi jini am bʌ ti mulawil, jiñʌch jini mu' bʌ a bej pensalin. ");
INSERT INTO ctu76_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Che' wen la' wut mi la' wen q'uele' i sʌclel mulawil. Che' bajche' jini, che' wen la' pusic'al cha'an ti la' ch'ujbi i t'an Dios, mux la' ña'tyan bajche' yom mi la' wajñel ti wen ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero mi ma' mi la' saj ch'ujbin i t'an Dios cha'an mi la' ña'tyan bajche' yom mi la' wajñel, añet tyo la ti ic't'ojñal yubil. Ñoj ic'jowan jini ic't'ojñal. Wocol añetla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mach'an ajtroñel ch'ujbi bʌ i yumin cha'tiquil i yum wʌ' ti mulawil. Mi quejel i ts'a'q'uel juntiquil. Mi quejel i p'untyan jini yambʌ. Xuc'ul mi' cha'liben i troñel juntiquil. Mi' lu' ñusʌben i t'an jini yambʌ. Chʌ'ʌch an lac pusic'al je'el. Mach ch'ujbi la' yumin Dios che' chʌncol la' yumin tyaq'uin. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Mic subeñetla mach yom la' lolon cabʌl pensalin chʌ bʌ mi quejel la' c'uxe', la' jape', mi cha'an la' pislel mu' bʌ quejel la' xoje'. Dios ti yʌq'ueyetla cha'an cuxul mi la' wajñel. Che' jini, ¿mach'a ba'an mi quejel i yʌq'ueñetla i bʌl la' ñʌc je'el? Muc'ʌch. Dios ti yʌq'ueyetla la' bʌc'tyal. ¿Mach'a ba'an mi quejel i yʌq'ueñetla la' pislel mi la' wʌl? Muc'ʌch. ");
INSERT INTO ctu76_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ña'tyanla jini xma'tye'mut mu' bʌ ti wejlel ti chan. Mach'an mi' cha'len pac'. Mach'an mi' cha'len c'ajbal. Ma' mi yotsan i buc'bal ti' yotyotlel cha'an mi' cʌñʌtyan ti jal. Pero lac Tyat am bʌ ti panchan mi yʌq'ueñob chʌ bʌ yes yom i buc'ob. Más ñuc mi' q'uelonla Dios che' bajche' xma'tye'mut. ");
INSERT INTO ctu76_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Am ba mi junticlec ch'ujbi bʌ i colel xinil metro aunque mi' bej cha'len cabʌl pensal cha'an wersa yom chan'ac? Mach'an. ");
INSERT INTO ctu76_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Chucoch mi la' lolon cha'len cabʌl pensal cha'an la' pislel? Ña'tyanla bajche' mi colel nich' pimel ti ma'tye'el. Ma' mi' cha'len toñel. Mach'an mi' jale' i pislel. ");
INSERT INTO ctu76_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero mic subeñetla: Mi jinic jini yumʌl ñoj cabʌl bʌ i ricojlel Salomón bʌ i c'aba' mach i tyaja i c'otyajlel jini ñoj wen bʌ i pislel che' bajche' nich' pimel tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jiñʌch Dios mi yʌq'uen i c'otyajlel pimel tyac mu' bʌ i colel wale iliyi pero ijc'ʌl jach mi' pulelob ti yajnib c'ajc. Pero Dios mi' más pensalin i yʌq'ueñetla chʌ bʌ yom la' cha'an che' bajche' mi' pensalin pimel tyac. Pero ts'itya' jach chʌncol la' ch'ujbin Dios che' bej an cabʌl la' pensal cha'an i bʌl la' ñʌc' yic'ot la' pislel. ");
INSERT INTO ctu76_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jin cha'an mach yom la' cha'len cabʌl pensal. Mach yom la' wʌle': ¿Chuquiyes mi quejel laj c'uxe'? ¿Chuquiyes mi quejel la cape'? ¿Chuquiyes mi quejel lac xoje'? che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Como quixtyañujob wʌ' ti mulawil che' jach mi' bej pensalin chʌ bʌ yes mi' c'ux, chʌ bʌ yes mi' xoj. Pero jatyetla mach che'ic yom mi la' cha'len. Como añʌch la' Tyat am bʌ ti panchan yujil isujm pejtyel chʌ bʌ yes yom la' cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Bej pensalinla chʌ bʌ yom Dios. Che' jini mi quejel la' wʌq'uentyel pejtyelel chʌ bʌ tyac yom cha'añetla. ");
INSERT INTO ctu76_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mach yom la' lolon cha'len cabʌl pensal cha'an jini mu' tyo bʌ quejel i yujtyel ijc'ʌl. Como ti jujump'ej q'uin an wocol tyac mu' bʌ lac wersa cuch. Jasʌl jach mi la' ña'tyan bajche' mi la' cuche' la' wocol ti jin jach bʌ q'uin. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mach yom la' lolon al mi an i mul juntiquil che' max tyo ti yoque tsictyay mi an o mi mach'an. Che' jini ma'an mi yʌl Dios añʌch la' mul je'el cha'an ti caj a t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Lajalʌch bajche' mi la' lolon ale' an i mul la' pi'ʌlob, chʌ'ʌch je'el mi quejel i yʌletla an la' mul. ");
INSERT INTO ctu76_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Bajche'qui isujm che' ch'ujbi a wilan i ts'ubil tye' ti' wut a wermañu che' mach'an ma' pensalin mi an colem xujc'u' tye' ti a wut, yubil? ");
INSERT INTO ctu76_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Che' an xujc'u' tye' ti a wut yubil, ¿bajche'qui ch'ujbi a suben a wermañu: Aq'ueñon c loc'sʌbeñet i ts'ubil tye' ti a wut? che'et. ");
INSERT INTO ctu76_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Cha'chajp la' pensal. Jini yom bʌ yi, ma' ñaxan loc'san jini colem xujc'u' tye' am bʌ ti a wut, yubil. Che' jini, ch'ujbi a wen q'uel cha'an ma' loc'sʌben i ts'ubil tye' am bʌ ti' wut a wermañu. Chʌ'ʌch ti' cha'le cʌntisa Jesús cha'an jini más an bʌ i mul mu' bʌ i lolon ale' an i mul i pi'ʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mach yom la' wʌq'uen ts'i' chʌ bʌ ch'ujul. Che' mich' jini ts'i' mi' c'uxetla. Mach yom mi la' wʌq'uen chityam chʌ bʌ ñoj lets bʌ i tyojol. Como che' jach mi' tyejq'ue' ti lum. Che' bajche' jini, mach yom la' suben i t'an Dios mu' bʌ laj q'uel ti ch'ujul jini mu' bʌ i junyajlel wajlen i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Bej c'ajtibenla Dios chʌ bʌ yom la' cha'an. Mi quejel i yʌq'ueñetla. Bej sʌclanla. Mi quejel la' tyaje'. C'ajtibenla Dios, che' bajche' chʌncol la' jats'e' i ti' otyot yubil. Mi quejel i jambeñetla. ");
INSERT INTO ctu76_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Como jini mu' bʌ i c'ajtin mi quejel i yʌq'uentyel. Jini mu' bʌ i sʌclan mi quejel i tyaje'. Jini mu' bʌ i jats'e' i ti' otyot mi quejel i jambentyel. ");
INSERT INTO ctu76_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Am ba juntiquiletla tyatyʌlet bʌ la mu' bʌ quejel la' wʌq'uen la' walobil tyun che' mi c'ajtin waj? ");
INSERT INTO ctu76_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Mu' ba quejel la' wʌq'uen lucum che' mi' c'ajtin chʌy? ");
INSERT INTO ctu76_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Che' jini, jatyetla, aunque simaroñetla, a wujila la' wʌq'uen la' walobil wen tyac bʌ. Lac Tyat am bʌ ti panchan más tyo mi quejel i yʌq'uen wen tyac bʌ jini mu' bʌ i c'ajtin. ");
INSERT INTO ctu76_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Bele' cha'libenla wen bʌ la' pi'ʌlob che' bajche' mi la' mulan i cha'libeñetla je'el. Como jiñʌch mu' bʌ i xic'onla lac cha'len i mandar Moisés yic'ot tsa' bʌ i ts'ijbuyob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Che' wʌ' tyo añetla ti mulawil cha'lenla xʌmbal ti bij saj bʌ i ti' yubil. Colem i pochtyʌlel, ñuc i ti' jini bij ba' mi' majlelob ti xot'mulil. An cabʌl mu' bʌ i yochelob ya'i. ");
INSERT INTO ctu76_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero saj i ti' jini saj bʌ bij ba' mi yochelob mu' bʌ i yʌq'uentyelob tsiji' bʌ i cuxtyʌlel. Mach'an cabʌl mu' bʌ i yochelob ya'i. ");
INSERT INTO ctu76_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Cʌñʌtyan la' bʌ cha'an jini xlot bʌ ajcʌntisajob mu' bʌ i lolon alob cha'an i t'añʌch Dios chʌncol i puc majlel. Mi' lolon pʌsob i bʌ che' bajche' ñoj uts bʌ tiñʌme' mi' lolon cha'len, pero ti' pusic'al an i simaronlel che' bajche' ñoj simaron bʌ ma'tye'lel ts'i' yubil. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pero ch'ujbi la' cʌn jini quixtyañujob chʌ bʌ mi' cha'leñob che' bajche' mi la' cʌñe' tye' ti i wut. Como mach'an mi la' tyuq'ue' i wut ts'ujsub ba' ch'ix jach mi colel, mi higo bʌ i wut tye' ba' ts'ujsub jach mi colel. ");
INSERT INTO ctu76_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jini wen bʌ tye' mi yʌc' wen bʌ i wut. Jini mach'ʌ wen bʌ tye' mi yʌc' mach'ʌ wen bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jini wen bʌ tye' mach ch'ujbi i yʌq'ue' mach'ʌ wen bʌ i wut. Jini mach'ʌ wen bʌ tye' mach ch'ujbi i yʌq'ue' wen bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pejtyelel tye' tyac mach'ʌ ba'an mi yʌc' wen bʌ i wut mi sejq'uel. Mi pulel ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Che' bajche' mi la' cʌñe' tye' ti i wut, che' je'el mi la' cʌñe' xlot bʌ ajcʌntisa cha'an ti' cha'libal. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ti' bej cha'le cʌntisa Jesús. Ti yʌlʌ: Mach ti pejtyelelob mu' bʌ i pejcañon ti i yum mi quejel i yochel ti panchan ba' mi' cha'len yumʌl Dios. Jin jach mu' bʌ i cha'leñob bajche' yom i pusic'al c Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Che' mi quejel i c'otyel i yorojlel melojel ya' ba'an Dios ti panchan cabʌlob mi quejel i subeñob: C Yum, joñon lojon ti lojon c subu majlel a t'an. Ti lojon j c'ʌñʌ a c'aba' cha'an ti lojon c choco loq'uel xiba ti' pusic'al quixtyañujob yic'ot ti a c'aba' ti lojon c pʌsʌ cabʌl ñuc tyac bʌ a p'ʌtyʌlel. Chʌ'ʌch cabʌl mi quejel i yʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Che' jini, mi quejel c subeñob: Mach'an ba' bʌ ora tij cʌñʌyetla. Mach c cha'añeticla. Loq'uenla wʌ' ba'añon ti pejtyeletla tsa' bʌ la' cha'le mach'ʌ wen. Chʌ'ʌch mi quej c subeñob, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Jini mu' bʌ i yubin c t'an, mu' bʌ i ch'ujbin bajche' mi cʌle' jiñʌch che' bajche' juntiquil winic am bʌ i ña'tyʌbal mu' bʌ mele' i yotyot. Pero ñaxan tyam mi' pique' lum cha'an mi' tyaje' tyun ba' mi' wa'chocon i ts'ajquil i ye'bal otyot. ");
INSERT INTO ctu76_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ti tyʌli ja'al. Ti wen tyam'ʌ ja'. P'ʌtyʌl bʌ ic' ti' wen jats'ʌ i yotyot. Pero mach'an ti bujchi como tsʌts chucul ti tyun. ");
INSERT INTO ctu76_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero jini mu' bʌ i yubin c t'an pero mach'an mi' ch'ujbin mu' bʌ i subentyel, jiñʌch che' bajche' juntiquil winic mach'ʌ ba'an i ña'tyʌbal mu' bʌ i mele' i yotyot ti pam ji'. Mach'an tyam bʌ i ts'ajquil i yebal otyot. ");
INSERT INTO ctu76_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ti tyʌli ja'al. Ti wen tyam'ʌ ja'. Ti ñumi p'ʌtyʌl bʌ ic'. Ti bujchi i yotyot. Ñoj p'ump'un bajche' ti jili i yotyot. Chʌ'ʌch ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Che' ñac ti ujti i sube' Jesús jini t'an, tyoj bʌc'ñʌjel ti yubiyob quixtyañujob cha'an i cʌntisa. ");
INSERT INTO ctu76_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesús mach'an ti' cʌntisʌyob bajche' yambʌ ajcʌntisajob. Como tsiquil an i p'ʌtyʌlel i t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Che' ñac Jesús ti jubi tyʌlel ya' ti wits, yonlel quixtyañu ti' tsʌcleyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Che' jini juntiquil c'am bʌ winic ti' lʌc'ʌ Jesús. Lepra bʌ i c'aba' i c'am'an. An chʌ bʌ yes pasem ti i pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Ti' ñocle ya' ti yebal yoc Jesús. Ti' sube: Mi a wom, ch'ujbiyʌch a lajmisañon, che' ti subenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Che' jini, Jesús ti tyʌlʌ jini c'am bʌ. Ti yʌlʌ: Comʌch. La' lajmiquet. Che' ti subenti jini c'am bʌ. Che' ñac ti ujti i yʌle' Jesús, ti ora jach ti lajmi. C'oq'uix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Che' jini, Jesús ti' sube: Q'uele a bʌ cha'an mach'an majch ma' saj suben. Cucu, pʌsʌ a bʌ ba'an cura. Ya'i ma' wʌq'uen i majtyan Dios che' bajche' ti yʌlʌ Moisés ti mandar cha'an mi yilañob ti pejtyelelob cha'an tsa'ix lajmiyet. Che' ti subenti jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ti c'oti Jesús ya' ti jump'ej lum Capernaum bʌ i c'aba'. Ya' ti c'oti ba'an Jesús juntiquil am bʌ ye'tyel ti capitán cha'an cien soldado i cha'an bʌ romanojob. Ti' wersa c'ajtibe Jesús ti wocol t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ti yʌlʌ: C Yum, ya' ti cotyot an juntiquil ñoj c'am bʌ ajtoñel c cha'an. An ti wʌyib. Mach ch'ujbi i nijcʌntyel i yoc i c'ʌb. Ñoj cabʌl chʌncol i yubin wocol. Che' ti yʌlʌ jini capitán. ");
INSERT INTO ctu76_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús ti yʌlʌ: Muc'ʌch c majlel c lajmisan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jini capitán ti' jac'ʌ: C Yum, ma'ix c ñuclel cha'an ma' wochel ti cotyot. Che' jach ma' wʌc' a t'an cha'an mi lajmel. Che' jini mux i lajmel jini ajtoñel c cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Como joñon je'el mic xijq'uel ti yambʌ más ñuc bʌ ye'tyel. Joñon je'el mic xiq'ue' soldadojob. Che' mic suben juntiquil: Cucux, cho'on. Mi majlel. Mic suben yambʌ: La', cho'on. Mi tyʌlel. Che' mic suben ajtoñel: Cha'len jini, cho'on. Mi' cha'len. Che' ti yʌlʌ jini capitán. ");
INSERT INTO ctu76_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Che' ñac ti yubi Jesús i t'an jini capitán ñoj tijicña ti yubi. Jesús ti' sube quixtyañujob chʌncol bʌ i tsʌclen majlel: Melel mic subeñetla, mach'an ba' tic tyaja ba'an pejtyelel c pi'ʌlob israelob juntiquil mu' bʌ i wen ch'ujbiñon bajche' ili capitán, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mic subeñetla ya' bʌ loq'uemob ti paso' q'uin yic'ot ba' mi p'ʌjquel q'uin mi quejel i tyʌlelob cabʌl mach'ʌ israelob mu' bʌ i buchtyʌlob ti uch'el yic'ot Abraham, yic'ot Isaac yic'ot Jacob ya' ti panchan ba' mi' cha'len yumʌl Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero jini israelob tsa' bʌ subentiyob i t'an Dios mach'ʌ ba'an ti' ch'ujbiyob mi quejel i chojquelob majlel ya' ba' ic'jowan, ba' mi quejelob ti uq'uel yic'ot tsʌts mi quejel i c'uxob i yej. Che' ti' sube quixtyañujob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Che' jini Jesús ti' sube jini capitán: Cucux ti a wotyot. Cha'an ti a ch'ujbiyon tsa'ix lajmi ajtroñel a cha'an. Che' ti yʌlʌ Jesús. Ti jin jach bʌ ora ti wa' lajmi jini ajtroñel. ");
INSERT INTO ctu76_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús ti majli ti yotyot Pedro. Ya' ti yilʌ i nij'aña' Pedro. Mi wen ubin c'ajc. An ti wʌyib. ");
INSERT INTO ctu76_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús ti' tyʌlbe i c'ʌb. Ti wa' lajmi c'ajc. Che' jini ti tyejchi. Ti' melbeyob i yuch'el. ");
INSERT INTO ctu76_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Che' yomox ic'an ti pʌjyiyob tyʌlel ya' ba'an Jesús cabʌl tyʌc'lʌbilo' bʌ ti xiba. Mach'an chʌ bʌ yambʌ ti c'ʌjni, ti' t'an jach, Jesús ti' wa' choco loq'uel xibajob. Ti' lu' lajmisʌbeyob i c'am'an quixtyañujob chʌ bʌ tyac jach bʌ c'am'an yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chʌ'ʌch ti ujti cha'an mi ts'ʌctiyel tsa' bʌ i wʌ alʌ juntiquil tsa' bʌ xiq'ui yʌle' Dios Isaías bʌ i c'aba'. Ti' tyaja ti t'an Jesús. Ti yʌlʌ: Ti' cotyʌyonla laj cuche' lac wocol tyac. Ti' choco loq'uel laj c'am'an tyac. Chʌ'ʌch ti wʌ alʌ Isaías ti ñoj oniyix che' max tyo ajn ti mulawil Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Che' ñac ti yilʌ Jesús joyol ti cabʌl quixtyañujob ti' xiq'uiyob ajcʌnt'añob i cha'an cha'an mi' c'axelob ti junxejlel colem joyol bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Juntiquil ajcʌntisa cha'an i mandar israelob ti' lʌc'ʌ Jesús. Ti yʌlʌ: Maestro, com c tsʌcleñet majlel ba'ical jach ma' majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús ti' sube: Xwax an i met. Xma'tye'mut an i c'u'. Pero Joñon i Pi'ʌlon Quixtyañujob mach'an c bajñel ajñib ba' mic tyots'tyʌl. Chʌ'ʌch ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Che' jini, juntiquil ajcʌnt'an i cha'an Jesús ti' sube: C Yum, aq'ueñon c pijtyan jintyo mi sajtyel c tyat cha'an mic ñaxan ch'ujñan. Che' jini, mux c tsʌclañet majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús ti' sube: La'. Tsʌcleñon majlel. Mu' tyo i ch'ujñan a tyat ya' bʌ mi sajtyel jini sajtyemo' bʌ yubil. Che' ti yʌlʌ Jesús. Como chʌ'ʌch bajche' sajtyemo' bʌ yubil jini mach'ʌ ba'an mi' ch'ujbiñob Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Che' jini ti ochi Jesús ti barco. Ti ochiyob je'el ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Che' jini ti queji toñel bʌ ic' ya' ti colem joyol bʌ ja'. Jini ic' ti queji i wets' ochel ja' ti malil barco jintyo yomox bujt'el ti ja'. Pero wʌyʌl Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Che' jini, jini ajcʌnt'añob ti queji i p'ixtisañob Jesús. Ti' subeyob: C Yum, muq'uix quejel lac sujp'el ochel ti mal ja', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús ti' subeyob: ¿Chucoch muq'uetla ti bʌq'uen? Ts'itya' jach chʌncol la' ch'ujbiñon. Che' ti yʌlʌ Jesús. Che' jini ti tyejchi. Ti' tiq'ui ic' yic'ot wits'law bʌ ja'. Ti wa' lajmi. Wen ñʌch'ʌlix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tyoj bʌc'ñʌjel ajcʌnt'añob i cha'an Jesús. Ti' c'ajtibeyob i bʌ, ¿majchqui wale jini winic mu' bʌ i ch'ujbibentyel i t'an ti ic' yic'ot ti ja'? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús yic'ot ajcʌnt'añob i cha'an ti' c'axiyob majlel ti junxej colem joyol bʌ ja'. Ya' ti c'otiyob ya' ti i lumal ajgadarenojob. Che' jini, cha'tiquil winicob ti loq'uiyob ya' ti ch'ujñʌjibʌl. Ti' lʌc'ʌyob Jesús. Tyʌc'lʌbilo' bʌ ti xiba ti cha'ticlelob. Ñoj simaroñob. Pejtyel quixtyañujob mi' bʌc'ñañob ñumel ya' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Che' ñac ti yilʌyob Jesús ti quejiyob ti oñel jini xibajob am bʌ ti' pusic'al jini cha'tiquilob. Ti yʌlʌyob: ¿Chuquiyes a wom a wic'otyon lojon, Jesús, jatyet i Yalobilet bʌ Dios? ¿Tsa'ix ba tyʌliyet a wʌ tyʌc'lañon lojon che' max tyo c'ot i yorojlel ma' chocon lojon ochel ti xot'mulil? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ya' chʌncol ti buc'bal yonlel chityam ya' lʌc'ʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jini xibajob ti' wersa c'ajtibe Jesús: Mi mux a chocon lojon loq'uel ti' pusic'al ili quixtyañujob, aq'ueñon lojon cochel ti chityam, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús ti' subeyob: Cucux. Ochen, che'en. Che' jini, jini xibajob ti loq'uiyob ti' pusic'al winicob. Ti ochiyob ti' pusic'al chityam. Che' jini, jini chityam ti lu' jubiyob majlel ti ajñel ya' ti queptyʌl. Ti' chocoyob ochel i bʌ ti malil colem joyol bʌ ja'. Ya' ti lu' jic'tyʌyob ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Che' ñac ti yilʌ ajcʌñʌtya chityam chʌ bʌ ti ujti ti' bʌc'ñʌyob. Ti majliyob ti ajñel. Che' ñac ti c'oti'yob ya' ti lum ti' lu' subu pejtyel bajche' ti ujti jini chityam yic'ot bajche' ti ujti jini winicob tsa' bʌ loq'ui xiba ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Che' jini, ti pejtyelel quixtyañujob ya' bʌ añob ti Gadara ti lu' majliyob ya' ba'an Jesús. Che' ñac ti' q'ueleyob ti' subeyob cha'an mi loq'uel majlel ya' ba' añob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús ti ochi ti barco. Ti c'axi ti junxej colem joyol bʌ ja'. Ya' ti c'oti ti i lumal. ");
INSERT INTO ctu76_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ya' ti c'oti quixtyañujob tsa' bʌ i q'uecheyob tyʌlel juntiquil winic mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb. Tyots'ol ti yab ti' q'uecheyob tyʌlel. Che' ñac Jesús ti yilʌ cha'an ti' ch'ujbi jini quixtyañujob cha'an an i p'ʌtyʌlel i lajmisan jini c'am bʌ, ti' sube jini mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb: Pi'ʌl, tijicñisan a pusic'al. Ñusʌbilix a mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Che' jini, ya'an cha'tiquil uxtiquil ajcʌntisajob cha'an i mandar israelob. Ti queji i pensaliñob ti' pusic'al: Jini winic chʌncol jach i cuye' i bʌ ti Dios. Che' ti' pensaliyob ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero yujil isujm Jesús chʌ bʌ chʌncol i bajñel pensaliñob ti' pusic'al. Jin cha'an ti' subeyob: ¿Chucoch muq'uetla ti simaron bʌ pensal? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Baqui bʌ más wocol mic suben mi la' wʌl? ¿Más wocol ba mic suben ñusʌbilix a mul o más wocol ba mic suben, tyejchenix, cha'lenix xʌmbal? cho'on, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wale mi quej c pʌs'eñetla cha'an an c p'ʌtyʌlel cha'an mic ñusʌbeñob i mul año' bʌ ti mulawil, Joñon i Pi'ʌlon bʌ Quixtyañujob. Che' jini, ti' sube mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb: Mic subeñet, tyejchen. Ch'ʌmʌx majlel a wab. Cucux ti a wotyot. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jini tsa' bʌ lajmisʌnti yoc i c'ʌb ti tyejchi. Ti majli ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Che' ñac ti yilʌ quixtyañujob chʌ bʌ ti ujti, ti quejiyob ti bʌq'uen. Ti' subeyob i ñuclel Dios como tsiquil tsa'ix aq'uenti quixtyañu i p'ʌtyʌlel Dios cha'an mi' lajmisan quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Che' jini, ti loq'ui majlel Jesús ya'i. Ti yilʌ juntiquil xch'ʌm tyojoñel Mateo bʌ i c'aba'. Ya' buchul ba' mi' cha'leñob tyojoñel. Jesús ti' sube: Tsʌcleñon majlel, che'en. Che' jini Mateo ti tyejchi. Ti' tsʌcle majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ti ujti che' Jesús yic'ot ajcʌnt'añob i cha'an ti majliyob ti uch'el ya' ti yotyot Mateo. Ya'an je'el cabʌl xlot bʌ xch'ʌm tyojoñelob yic'ot yambʌ quixtyañujob añob i mul. Motin muc'ob ti uch'el. ");
INSERT INTO ctu76_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Che' ñac jini fariseojob ti' q'ueleyob ti' c'ajtibeyob ajcʌnt'añob i cha'an Jesús: ¿Bajche'qui isujm che' mi' pi'leñob ti uch'el la' maestro jini xlot bʌ xch'ʌm tyojoñelob yic'ot yambʌ xmulilob? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús ti yubi bajche' ti subenti ajcʌnt'añob i cha'an. Jin cha'an ti' sube jini fariseojob: Jini c'oc'ob bʌ mach c'ʌjnibal mi ts'ʌcʌntyel, jin jach jini c'am'o' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cucuxla. Pensalinla i sujmlel ili t'an ti' Ts'ijbubil bʌ i T'an Dios ba' mi yʌle': Jini com bʌ, jiñʌch cha'an mi la' p'untyan la' pi'ʌlob cha'an la' wom la' cotyañob. Más wen mij q'uele' che' bajche' mi la' wʌq'ueñon pulem bʌ c majtyan. Che' ts'ijbubil ti' t'an Dios. Che' ti yʌlʌ Jesús. Mach'an ti tyʌliyon c pʌye' mu' bʌ i lolon ale' ma'ix i mul. Pero ti tyʌliyon c pʌye' quixtyañujob año' bʌ i mul cha'an mi' q'uextyan i pensal i cʌye' i mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jini ajcʌnt'añob i cha'an Juan tsa' bʌ yʌc'ʌ ch'ʌm ja' ti tyʌliyob ya' ba'an Jesús. Ti' c'ajtibe: ¿Bajche'qui isujm cha'an joñon lojon yic'ot fariseojob mi lojon cabʌl c cha'len ch'ajb cha'an mu' bʌ lojon j c'ux, mu' bʌ lojon cap pero mach'an ba' bʌ ora mi cha'leñob ch'ajb ajcʌnt'añob a cha'an? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús ti' subeyob: ¿Mu' ba i cha'leñob ch'ajb cha'an mu' bʌ i c'uxob, mu' bʌ i japob pʌyʌlo' bʌ ti q'uiñejel ñujpuñel che' ya' tyo an yic'otyob ajñujpuñel, ma' wʌl? Mach'an. Pero tyal tyo i yorojlel mi pʌjyel loq'uel ajñujpuñel ti tyojel quixtyañujob. Che' jini mi quejel i ch'ajbañob i bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ti' cha'le yambʌ lajoñel Jesús. Ti yʌlʌ: Mach'an majch mi' c'ʌñe' ts'iji' bʌ pisil cha'an mi lʌjwe' tsuculix bʌ i pislel. Muc' jach i cha' tsijlel loq'uel jini tsijib tyo bʌ che' mi' com'an. Che' jini más colemix mi loq'uel i tsijlemal. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ti' cha'le yambʌ lajoñel. Ti yʌlʌ: Mach yom cojlic ochel ti tsucul bʌ pʌjchij bʌ yajnib che' chʌncol tyo i mejlel vino bʌ lembal. Como jini vino bʌ lembal mi yʌc' ti tyojmel tsucul bʌ pʌchij bʌ yajnib. Mi tyojmel yajnib. Che' jini mi bejquel. Jin cha'an yom mi yotsañob tsiji' bʌ vino ti tsiji' bʌ yajnib. Che' jini mi cʌñʌtyʌntyel vino yic'ot yajnib je'el cha'an mach jilic. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Che' ñac mu' tyo ti t'an Jesús cha'an jini ujtyel bʌ yʌle', ya' ti c'oti juntiquil ñuc bʌ i ye'tyel ti templo israelob. Ti ñocle ti yebal yoc Jesús. Ti yʌlʌ: Ujtyel tyo i sajtyel quixicp'eñal. Pero muq'uic a tyʌlel a wʌc' a c'ʌb ti' pam i bʌc'tyal, mu' tyo i cha' cuxtiyel. Che' ti yʌlʌ jini ñuc bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Che' jini, Jesús yic'ot ajcʌnt'añob i cha'an ti loq'uiyob majlel yic'ot jini ñuc bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Che' ñac an ti bij Jesús ya' ti tyʌli juntiquil c'am bʌ x'ixic. C'ʌlʌ doce años ma' ti lajmi ti loq'uel i ch'ich'el. Ti tyʌli jini x'ixic ya' ti' pat Jesús. Ti' tyʌlbe i yoc i bujc Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Como jini x'ixic ti' bajñel pensali: Mi jinic jach mij c'otyel c tyʌlben i pislel Jesús mux c lajmel. Che' ti' pensali. ");
INSERT INTO ctu76_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús ti' sutqui i bʌ. Ti' q'uele jini x'ixic. Ti' sube: Tijicñisan a pusic'al, calobil. Tsa'ix lajmiyet cha'an ti a ch'ujbi mi quejel a lajmel mi ti a tyʌlʌ c bujc. Jin jach bʌ ora ti wa' lajmi jini x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Che' ñac ti c'oti Jesús ya' ti yotyot ñuc bʌ ye'tyel ti templo israelob, ti yilʌ ya'an ajnijca músicajob. Chajpʌbilob cha'an i majlelob yic'otyob i ch'ujñan ch'ujlelʌl. Mu' ti ñoj c'am bʌ uq'uel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús ti' subeyob: Loq'uenla wʌ'i. Mach'an sajtyem ili xc'alʌl. Wʌyʌl jach. Che' ti yʌlʌ Jesús. Jini quixtyañujob ti' wajleyob Jesús como yujil isujm cha'an sajtyemix xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero Jesús ti' xiq'uiyob loq'uel. Che' jini ti ochi ya' ba'an xc'alʌl. Ti' chucbe i c'ʌb. Ti cha' cuxtiyi. Ti tyejchi jini xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ti pujqui majlel t'an ti pejtyelel pañimil ya'i cha'an jini tsa' bʌ tsictiyi. ");
INSERT INTO ctu76_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Che' ti loq'ui Jesús ya'i ti' tsʌcleyob majlel cha'tiquil muts'ulo' bʌ i wut. C'am ti quejiyob ti t'an. Ti yʌlʌyob: Jesús, i jiñʌjlelet bʌ David, chocolet bʌ tyʌlel ti Dios, q'ueleyon lojon ti p'ump'un cha'an a cotyañon lojon. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Che' ñac ti ochi Jesús ti otyot ti lʌc'ʌyob jini muts'ulo' bʌ i wut. Jesús ti' c'ajtibeyob: ¿Mu' ba la' ch'ujbin cha'an ch'ujbi c cha'libeñetla jini? Che' ti yʌlʌ Jesús. Ti' jac'ʌyob: Muc'ʌch, c Yum, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Che' jini Jesús ti' tyʌlbeyob i wut. Ti yʌlʌ: La' lajmiquetla che' bajche' ti la' ch'ujbi. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ti c'oti i wut ti' cha'ticlelob. Che' jini Jesús ti' wersa subeyob: Ma' mi la' saj suben quixtyañujob bajche' tic lajmisʌbeyetla la' wut. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero ujtyel tyo i loq'uel ya' ba'an Jesús, ti quejiyob i wa' puque' majlel t'an ti pejtyelel pañimil bajche' ti lajmisʌntiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Che' ñac chʌncol tyo i loq'uelob jini tsa' bʌ lajmisʌbentiyob i wut, ti c'oti ba'an Jesús cha'tiquil uxtiquil chʌncol bʌ i pʌye' tyʌlel juntiquil x'uma' am bʌ i xibʌjlel ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ora jach ti queji ti t'an jini x'uma' che' ñac Jesús ti' chocbe loq'uel i xibʌjlel ti' pusic'al. Tyoj bʌc'ñʌjel ti yubi quixtyañujob. Ti yʌlʌyob: Mach'an ba' bʌ ora ti niq'ui ujti ñuc bʌ ba'an lac pi'ʌlob israelob bajche' ujtyel la quilan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero jini fariseojob ti yʌlʌyob: Ili winic mi' choque' loq'uel xibajob ti' p'ʌtyʌlel jach i yajaw xiba. Che' ti lolon alʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús ti ñumi majlel ti pejtyelel lum tyac yic'ot ti ajchumtyʌl tyac. Ya' ti ochi ti jujump'ej i templo israelob cha'an i cʌntisañob jini wen t'an bajche' chʌncol ti yumintyel Dios am bʌ ti panchan. Ti' lajmisʌbeyob ba'ic jach bʌ c'am'an yic'ot wocol tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Che' ñac ti yilʌ Jesús bajche' mi' much'quiñob i bʌ quixtyañujob ba'ical jach ti ñumi majlel ti cʌntisa, ti' wen p'untyʌyob cha'an yom i cotyañob ti' wocol. Wen p'ump'uñob bajche' ti' ñusʌyob q'uin. Ch'ʌjyemob. C'uñob ti' bʌc'tyal. Ti yilʌyob che' bajche' tiñʌme'ob mach'ʌ ba'an ajcʌñʌtya i cha'an. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ti' sube ajcʌnt'añob i cha'an: Melel an cabʌl c'ajbal pero mach'an cabʌl xc'ajbalob, che'en. Jiñʌch yom i yʌl che' bajche' an cabʌl yom bʌ i cotyʌntyel, cha'an jach ma'ix cabʌl ajsubt'añob. ");
INSERT INTO ctu76_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Jin cha'an c'ajtibenla Dios como jiñʌch i yum c'ajbal cha'an i choque' majlel ajtroñelob ti c'ajbal. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús ti' pʌyʌ tyʌlel doce ajcʌnt'añob i cha'an. Ti yʌq'ueyob i p'ʌtyʌlel cha'an mi' chocob loq'uel xibajob yic'ot cha'an mi' lajmisañob ba'ical bʌ c'am'an tyac yic'ot wocol tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jiñobʌch i c'aba' jini docejob tsa' bʌ otsʌntiyob ti yajcʌbilo' bʌ ajsubt'añob ñumel. Ñaxan Simón mu' bʌ i pejcʌntyel je'el ti Pedro, yic'ot Andrés i yijts'in Pedro, Jacobo yic'ot Juan i yalobilob Zebedeo. ");
INSERT INTO ctu76_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo jini xch'ʌm tyojoñel, Jacobo i yalobil Alfeo yic'ot Lebeo mu' bʌ i pejcʌntyel je'el ti Tadeo. ");
INSERT INTO ctu76_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón ch'oyol bʌ ba'an junmujch'o' cananistajo' bʌ i c'aba', yic'ot Judas Iscariote mu' bʌ quejel i yʌc' Jesús ti' c'ʌb i contra. ");
INSERT INTO ctu76_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ti' xiq'ui majlel ti subt'an jini docejob. Ti' subeyob: Mach yom la' majlel ba'an mach'ʌ israelob. Ma' mi la' wochel ti i lum tyac ya' ti pañimil Samaria bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Pero yom mi la' majlel ya' ba'an israelob como jiñʌch che' bʌ bajche' tiñʌme' tsa' bʌ sʌtyʌ i bijlel como max tyo i ch'ujbiyob i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Subula majlel t'an cha'an lʌc'ʌlix i yorojlel mi quejel i yumintyel Dios am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Lajmisan c'am'o' bʌ. Tyejchisan sajtyemo' bʌ. Lajmisan am bʌ chʌ bʌ pasem ti' pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Choco loq'uel xibajob am bʌ ti' pusic'al quixtyañujob. Ti a majtyan jach ti aq'uentiyetla ili la' p'ʌtyʌlel. Ma' mi la' c'ajtin la' tyojol che' mi la' c'ʌñe'. ");
INSERT INTO ctu76_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mach yom la' ch'ʌm majlel tyaq'uin, mi oro mi plata mi cobre bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mach yom la' ch'ʌm majlel la' morral mi yanic bʌ la' bujc mi yanic bʌ la' zapatos mi la' ñʌ'tye'ic. Como jini mu' bʌ i cha'len toñel yom i yʌq'uentyel i yuch'el cha'an i tyojol yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Che' mi la' c'otyel ti lum mi ti ajchumtyʌl yom mi la' sʌclan juntiquil mu' bʌ i q'uejlel ti ñuc. Mi la' c'ajtiben mi mux i yʌq'ueñetla la' wajñel ti yotyot. Ya' mi la' wajñel jintyo mi la' cha' loq'uel majlel. ");
INSERT INTO ctu76_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Che' mi la' wochel ti jump'ej otyot mi la' wʌq'uen saludos. Mi la' wʌle': La' tyʌlic i ñʌch'tyʌlel i pusic'al ili año' bʌ ti ili otyot, che'etla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Mi ti' q'ueleyet ti wen jini am bʌ ti otyot, mux i ch'ʌme' i yutslel a t'an. Mi ma'ix mi' q'uelet ti wen mach i cha'añobix i yutslel a t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mi ma'ix mi' q'uelet ti wen mi mach yom i yubin a t'an ya' ti jump'ej lum mi ti jump'ej otyot, loq'uen, che' jini. Chijcunla loq'uel i ts'ubejñal la' woc cha'an mi' ña'tyañob mach wen bajche' mi' cha'leñob. ");
INSERT INTO ctu76_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melel mic subeñetla che' ti yorojlel melojel más wocol mi quejel i yʌjq'uelob ti xot'mulil jini mach'ʌ yom i yubin la' t'an che' bajche' jini año' bʌ ti lum tyac Sodoma yic'ot Gomorra bʌ i c'aba' ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesús ti' sube ajcʌnt'añob i cha'an: Wale chʌncol c choquetla majlel ti subt'an ya' ba'an simaron bʌ quixtyañujob. Bʌbʌq'uen mi quejel la' wubin. Mic choquetla majlel ti subt'an che' bajche' tiñʌme'etla joyol bʌ ti colem bajlʌm yubil. Wen pensalin bajche' yom mi la' wajñel. Yom bej listojetla che' bajche' lucum. Yom bej utsetla che' bajche' xmucuy. ");
INSERT INTO ctu76_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cʌñʌtyan la' bʌ. Mi quejel la' wʌjq'uel ti' wenta ñuc bʌ ye'tyel. Mi quejel i jats'etla ti pʌchij ya' ti templo tyac israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Mi quejel la' pʌjyel majlel jinic tyo ya' ti tyojlel ñuco' bʌ ye'tyel yic'ot ñuc bʌ yumʌlob cha'an tij caj joñon. Che' ya' añetla ch'ujbi la' sube' c t'an ti' tyojlelob yic'ot ya' ti' tyojlel mach'ʌ israelob je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Che' mi' pʌyetla majlel ya' ba' año' bʌ i ye'tyel mach yom la' ñaxan pensalin chʌ bʌ mi quejel la' wʌl mi jinic bajche' mi quej la' subeñob como jini Ch'ujul bʌ i Ch'ujlel Dios mi quejel i yʌq'ueñetla la' wʌle' che' mi c'otyel i yorojlel la' cha'len t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mach jatyeticla muq'uetla ti t'an yubil como jini Ch'ujul bʌ i Ch'ujlel Dios lac Tyat mi quejel i c'ʌñe' la' ti' cha'an yʌq'uetla ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Jini mach'ʌ ba'an mi' ch'ujbiñon mi quejel i lolon jop'beñob i mul i yijts'iñob mu' bʌ i ch'ujbiñon cha'an mi yʌc'ob ti tsʌnsʌntyel. Winicob am bʌ i yalobil mu' bʌ i ch'ujbiñon mi quejel i cha'len t'an ti' contra cha'an mi yʌc' ti tsʌnsʌntyel. Mi quejel i yujtyel je'el cha'an alp'eñalob mi quejel i ts'a'q'uelob i tyat i ña' mu' bʌ i ch'ujbiñon. An mu' bʌ quejel i yʌc'ob ti sajtyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ti pejtyelelob mi quejel i ts'a'q'ueletla cha'an ti caj chʌncol la' tsʌcleñon. Pero jini mu' bʌ i cuche' ti wen i ts'a'q'uelol chʌ bʌyic jach bʌ i tyʌc'lʌntyel mi quejel i cotyʌntyel cha'an mi yajñel ti yumintyel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Che' mi' tyʌc'lañetla ya' ti jump'ej lum, puts'tyañla majlel ti yambʌ. Melel mic subeñetla, ma'ix mi quejel la' ñumel majlel ya' ti pejtyelel i lum tyac israelob jintyo mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Mach'an más ñuc juntiquil ajcʌnt'an bajche' i maestro. Mach'an más ñuc ajtroñel bajche' i yum. ");
INSERT INTO ctu76_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jasʌl jach mi yajñel ajcʌnt'an che' bajche' i maestro. Jasʌl jach mi yajñel jini ajtroñel che' bajche' i yum. Che' mi ts'a'q'uelon, che' mi' pejcañon ti Beelzebú i yajaw xiba, más tyo mi quejel i ts'a'q'ueletla jatyetla mu' bʌ la' tsʌcleñon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jin cha'an mach yom mi la' bʌc'ñan quixtyañu chʌncol bʌ i tyʌc'lañetla como ma'ix chʌ bʌ mucul wale iliyi mach'ʌ ba'an mi quejel i tsictisʌntyel. Ma'ix chʌ bʌ mucul mach'ʌ ba'an mi quejel i lu' ña'tyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jini chʌncol bʌ c subeñetla che' lac bajñel jach, yom la' puc majlel ba'an pejtyel quixtyañujob. Jini chʌncol bʌ c mucul subeñetla yom la' sub ti c'am bʌ t'an ti pejtyelel lum tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mach yom la' lolon bʌc'ñan quixtyañu mu' bʌ i tsʌnsañetla pero mach ch'ujbi i tsʌnsan la' ch'ujlel. Jini yom bʌ la' bʌc'ñan jiñʌch jini am bʌ i p'ʌtyʌlel i yʌq'uetla ti sajtyel, yic'ot añʌch je'el i p'ʌtyʌlel i choquet majlel ti xot'mulil ti c'ajc ba' mi' ñusan wocol i bʌc'tyal yic'ot i ch'ujlel. Jin jach yom la' bʌc'ñan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mi chojñel cha'cojt saj xma'tye'mut ti junwejch tyaq'uin, pero ma'ix mi juncojtic mi chʌmel mi ma'ix mi yʌc' i t'an lac Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jinic tyo i tsutsel la col tsa'ix i lu' tsiqui Dios ti jujunt'ujm. ");
INSERT INTO ctu76_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mach yom la' cha'len bʌq'uen, che' jini. Como más an la' c'ʌjnibal che' bajche' cabʌl saj xma'tye'mut. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jesús ti yʌlʌ: Joñon mi quejel c tsictisan ti' tyojlel c Tyat am bʌ ti panchan cha'an mij cʌñob pejtyelelob mu' bʌ i tsictisan ti tyojlel quixtyañujob mi chʌncol i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero jini mu' bʌ i yʌle' ti' tyojlel quixtyañujob mach'ʌ ba'an mi' cʌñon, joñon je'el mi quejel cʌle' ti' tyojlel c Tyat am bʌ ti panchan cha'an mach c cha'añob je'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesús ti yʌlʌ je'el: Mach yom la' lolon al ti tyʌliyon cha'an mi cʌc'ob ti ajñel ti ñʌch'ʌl wʌ' bʌ añob ti mulawil. Ma' ti tyʌliyon cha'an mic ñʌch'chocoñob pero cha'an jach mi cʌq'ueñob i contrajiñob i bʌ cha'an ti caj mi' ch'ujbiñoñob. ");
INSERT INTO ctu76_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ti tyʌliyon cʌq'uen jini mach'ʌ ba'an mi' ch'ujbiñon i contrajiñob jini mu' bʌ i ch'ujbiñon. Winic mi' contrajin i tyat, i yixic'al mi' contrajin i ña', i yʌ'lib mi' contrajin i nij'aña'. ");
INSERT INTO ctu76_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jini mu' bʌ i ch'ujbiñon an i contrajintyel ti i pi'ʌlob ya' ti yotyot mach'ʌ ba'an mi' ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jini mu' bʌ i más p'untyan i tyat o i ña' che' bajche' mi' p'untyañon mach ch'ujbi i yajñel tic cha'an. Jini mu' bʌ i más p'untyan alo' bʌ i yalobil mi xc'alʌl bʌ i yalobil che' bajche' mi' p'untyañon, mach ch'ujbi i yajñel tic cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jini mach bʌ yom i yʌc' i bʌ ti tsʌnsʌntyel cha'an ti caj mi' tsʌcleñon, mach ch'ujbi i yajñel tic cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jini yom bʌ i bajñel lolon cʌñʌtyan i bʌ mi quejel i sʌtye' i cuxtyʌlel mach'ʌ yujil jilel. Pero jini mu' bʌ i yʌc' i bʌ cha'añon aunque mi sajtyel cha'an tij caj mi quejel i yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesús ti yʌlʌ je'el: Jini mu' bʌ i pʌyetla ochel ti yotyot mi' pʌyon ochel yubil. Jini mu' bʌ i pʌyon ochel mi' pʌy ochel je'el jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jini mu' bʌ i pʌye' ochel ti yotyot juntiquil tsa' bʌ i xiq'ui yʌle' Dios cha'an mi' ña'tyan mi' cha'len t'an bajche' ti xijq'ui ti Dios junlajal mi quejel i yʌq'uentyel i tyojol ti Dios che' bajche' mi yʌq'uentyel jini tsa' bʌ i xiq'ui yʌle' Dios. Jini mu' bʌ i pʌye' ochel ti yotyot juntiquil mu' bʌ i cha'len mu' bʌ i mulan Dios cha'an mi' ña'tyan cha'an chʌ'ʌch mi' cha'len, junlajal mi quejel i yʌq'uentyel i tyojol ti Dios che' bajche' mi yʌq'uentyel mu' bʌ i cha'len mu' bʌ i mulan Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Majchical jach mu' bʌ i yʌq'uen chʌ bʌ yom i cha'an aunque juntsimajic jachix tsʌwan bʌ ja' cha'an mi' ña'tyan ajcʌnt'an c cha'an aunque ma'ix mi q'uejlel ti ñuc ti quixtyañujob mi quejel i yʌq'uentyel i tyojol ti Dios. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Che' ñac bʌ ujtyel i cʌntisañob jini doce ajcʌnt'añob i cha'an, Jesús ti loq'ui ya'i. Ti ñumi majlel cha'an mi' cha'len cʌntisa yic'ot subt'an ti lʌc'ʌl tyac bʌ lum ya' ti jini pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","An ti cʌchol Juan. Pero ya' ti queji yubin chʌ bʌ muc' Cristo. Che' jini ti' choco majlel cha'tiquil uxtiquil ajcʌnt'añob i cha'an ba'an Jesús cha'an an chʌ bʌ yom i c'ajtiben. ");
INSERT INTO ctu76_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ti c'otiyob. Ti' c'ajtibeyob Jesús: ¿Jatyet ba Cristojet jini yajcʌbilet bʌ i cha'an Dios mu' bʌ quejel i tyʌlel o yom tyo mi lojon c bej pijtyan yambʌ? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús ti' jac'beyob ajcʌnt'añob i cha'an Juan. Cucula. Suben Juan chʌncol bʌ la' wilan, chʌncol bʌ la' wubin. ");
INSERT INTO ctu76_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Suben bajche' chʌncol i cha' c'otyel i wut jini muts'ulo' bʌ i wut, bajche' chʌncol ti cha' xʌmbal mach'ʌ ba'an i c'ʌjnibal yoc ti yambʌ ora, yic'ot cha'an tsa'ix lajmiyob jini am bʌ chʌ bʌ yes pasem ti' pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal, yic'ot bajche' mi cha' ubin t'an xcojco' bʌ, yic'ot an mi cha' cuxtiyel sajtyemo' bʌ, yic'ot mi subentyel t'an cha'an i cotyʌntyel jini p'ump'uño' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","C'ajacña i yoj mi yubin jini mu' bʌ i ch'ujbin ajcotyayajon i cha'an ti pejtyelel i pusic'al. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Che' ñac ti cha' sujtiyob ba'an Juan jini ajcʌnt'añob i cha'an, Jesús ti queji i suben quixtyañujob cha'an jini Juan. Ti yʌlʌ: ¿Chuquiyes tsajni la' q'uele' ya' ti tyʌquin bʌ joch lum? ¿Tsajni ba la' q'uele' juntiquil c'un bʌ quixtyañu bajche' c'un sʌyan bʌ jalʌl mu' bʌ i nijcʌyel ti ic'? ");
INSERT INTO ctu76_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mi mach jiniqui, ¿chuquiyes tsajni la' q'uele' che' jini? ¿Tsajni ba la' q'uele' winic xojol bʌ i cha'an c'otyajax bʌ i pislel? La' wujil isujm jini am bʌ c'otyajax bʌ i pislel añob ti yotyot ñuco' bʌ yumʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Chuquiyes tsajni la' q'uele', che' jini? ¿Juntiquil ba tsa' bʌ i xiq'ui yʌle' Dios? Melelʌch pero yoque más ñuc Juan bajche' yaño' bʌ tsa' bʌ i xiq'ui yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jiñʌch Juan tsa' bʌ tyajle ti t'an ti Ts'ijbubil bʌ i T'an Dios ba' mi yʌl: Mic ñaxan xiq'ue' majlel cajsubt'an cha'an i chajpʌbeñet a bijlel. Chʌ'ʌch an ti Ts'ijbubil bʌ i T'an Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melel mic subeñetla, ti pejtyelel quixtyañujob am bʌ ti mulawil c'ʌlʌ ti ñoj oniyix, c'ʌlʌ wale iliyi, mach'an yambʌ lajal ñuc bajche' Juan tsa' bʌ yʌc'ʌ ch'ʌm ja'. Pero jini mach'ʌ ba'an sajlic i ñuclel bʌ quixtyañu mu' bʌ i yumin Dios am bʌ ti panchan, más ñuc bajche' Juan mi quejel i yajñel. Che' ti yʌlʌ Jesús. Chʌ'ʌch an yubil como ti jim bʌ ora max tyo sajt Jesús che' ñac bʌ jini. ");
INSERT INTO ctu76_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ti' bej cha'le t'an Jesús. Ti yʌlʌ: C'ʌlʌ che' ñac ti queji i yʌc' ch'ʌm ja' Juan c'ʌlʌ wale iliyi, an cabʌl yom bʌ i wersa yumiñob Dios. Che' bajche' mi' ñet'ob i bʌ i tsʌcleñon cha'an wersa yom i tyajob wen tyac bʌ mu' bʌ i yʌq'uentyelob wʌ' ba' chʌncol i pʌs i p'ʌtyʌlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","C'ʌlʌ jintyo ti tyʌli Juan ti pejtyelelob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix yic'ot jini i mandar Moisés ti lu' wʌ alʌyob cha'an tyal i yorojlel mi quejel i cha'len yumʌl Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Mi mux a ch'ujbin mu' bʌ c subeñetla, jini Juan jiñʌch Elías yubil tsa' bʌ ajli cha'an añʌch cha'an tyʌlic. ");
INSERT INTO ctu76_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalin la. ");
INSERT INTO ctu76_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Jesús ti yʌlʌ: ¿Chuquiyes yic'ot mi quejel c laje' ili quixtyañujob am bʌ ili ora? Ili quixtyañujob chʌ'ʌch añob bajche' alp'eñalob yubil buchulob ti alas ti parque. Ti oñel mi' subeñob i pi'ʌlob ti alas: ");
INSERT INTO ctu76_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Chʌncol lojon c lolon wuse' jalʌl pero ma' mi la' cha'len son. Mi lojon c cha'len ch'ʌjyem bʌ c'ay pero ma' mi la' cha'len uq'uel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ti tyʌli Juan mu' bʌ i yʌc' ch'ʌm ja'. Mach'an mi cabʌl cha'len wen bʌ uch'el. Mach'an mi jape' i ya'lel ts'usub. Mi la' lolon ale' an i xibʌjlel. ");
INSERT INTO ctu76_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Che' jini ti tyʌliyon, i Pi'ʌlon bʌ Quixtyañujob. Mic cha'len wen bʌ we'el uch'el, pero mi la' wʌlon ti xwo'lelon yic'ot cha'an mic niq'ui jape'. I pi'ʌlon ti xʌmbal xmulilob yic'ot xlot bʌ xch'ʌm tyojoñelob che' mi la' wʌl. Pero che' yoque ochemob bʌ ti' t'an Dios bʌ quixtyañu, Dios mi yʌq'ueñob i ña'tyan bajche' yom i yajñelob. Che' jini mi' tsictiyel tyʌlem i ña'tyʌbal ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Che' jini Jesús ti queji i tic'ob. Ti queji i tsʌtsʌ pejcañob quixtyañujob ya' ti lum tyac ya' ba' ti' pʌsʌ cabʌl ñuc tyac bʌ i p'ʌtyʌlel como mach'an ti q'uextyʌyob i pensal i cʌyob i mul. ");
INSERT INTO ctu76_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ti' subeyob: P'ump'uñetla añet bʌ la ya' ti lum Corazín bʌ i c'aba'. P'ump'uñetla añet bʌ la ya' ti lum Betsaida bʌ i c'aba', cha'an mi quejel la' wubin wocol. Tsa'ic pʌs'entiyob ti ñoj oniyix ya' bʌ añob ti Tiro yic'ot Sidón ñuc tyac bʌ c p'ʌtyʌlel tsa' bʌ c cha'le wʌ' ba'añetla tsa'ix i q'uextyʌyob i pusic'al, tsa'ix i cʌyʌyob i mul. Tsa'ix i xojoyob i'ic' bʌ i pislel. Tsa'ix i mujluyob i bʌ ti tyan cha'an i señʌjlel i ch'ʌjyemlel cha'an i mul. ");
INSERT INTO ctu76_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero mic subeñetla, che' ti yorojlel melojel mi quejel la' más aq'uentyel la' ñusan más wocol bʌ xot'mulil bajche' ti' ñusʌyob jini año' bʌ ti Tiro yic'ot Sidón. ");
INSERT INTO ctu76_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ixcu jatyetla ya' ti lum Capernaum bʌ i c'aba', ¿mu' ba la' lolon ña'tyan cha'an mi quejel la' q'uejlel ti ñuc ti pejtyelel año' bʌ ti mulawil? Mach'an. Muc' jach la' chojquel ya' ba' mi majlel i ñusañob wocol cha'an ti caj i mul. Como tsa'ic pʌs'entiyob ti ñoj oniyix ya' bʌ añob ti lum Sodoma bʌ i c'aba' jini ñuc tyac bʌ c p'ʌtyʌlel tsa' bʌ c cha'le wʌ' ba'añetla jini lum tsa' tyo jale i wentyʌlel c'ʌlʌ wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero mic subeñetla, che' ti yorojlel melojel mi quejel la' wʌq'uentyel la' ñusan más wocol bʌ xot' mulil bajche' ti aq'uentiyob i ñusañob wocol año' bʌ ti Sodoma i c'aba' bʌ lum. ");
INSERT INTO ctu76_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti jim bʌ ora Jesús ti yʌlʌ: Mic subet a ñuclel c Tyat. I yumet panchan yic'ot mulawil. Ti a mucbeyob i sujmlel ili a t'an cha'an machic i ch'ʌmbeñob isujm a t'an año' bʌ i ña'tyʌbal yic'ot mu' bʌ i wen ch'ʌmben isujm chʌ bʌ tyac i cha'an jach bʌ mulawil, pero ti a wʌq'ue i ch'ʌmbeñob i sujmlel a t'an jini mu' bʌ i yajñel bajche' alʌl mach'ʌ ba'an mi' q'uelob i bʌ ti ñuc. ");
INSERT INTO ctu76_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chʌ'ʌch wen c Tyat, como chʌ'ʌch yom a pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","C Tyat ti panchan tsa'ix i lu' ac'on tic wenta ti pejtyelel chʌ bʌ an tyac. Che' je'el mach'an majch mi' cʌn c Tyat, jin jach joñon. Mi' cʌn c Tyat je'el majchical jach mi yʌq'uentyel i cʌñe' cha'an ti joñon i Yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","La' ba'añon ti pejtyeleletla am bʌ al bʌ la' cuch yubil. Mi cʌq'ueñetla la' c'aj la' woj. ");
INSERT INTO ctu76_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","La' lac motin cuch la' cuch. Cʌñʌ chʌ bʌ mic cʌntisañet como utson. Pec mic mel c bʌ. Mi quejel la' tyaje' la' c'aj oj cha'an la' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mach'an wocol la' cuch che' mi lac motin cuche' jini la' cuch yubil. Mi cʌq'ueñetla la' cuche' sejb bʌ. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Junyajlel che' i q'uinilel c'aj oj ti ñumi Jesús ti mal trigojol yic'ot ajcʌnt'añob i cha'an. Añob i wi'ñal jini ajcʌnt'añob. Che' jini ti queji i tyuc'ob trigo che' bʌ bajche' arroz yilal. Ti' c'uxuyob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Che' ñac ti yilʌ jini fariseojob chʌ bʌ muc' ajcʌnt'añob i cha'an Jesús, ti' subeyob Jesús: Q'uele ajcʌnt'añob a cha'an chʌncol i cha'leñob toñel tic'bil bʌ che' ti q'uinilel c'aj oj. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero Jesús ti' subeyob: ¿Mach'a ba'an ti la' q'uele ya' ti jun bajche' ti' cha'le David ti ñoj oniyix che' ñac ti yubi wi'ñal David yic'ot i pi'ʌlob? ");
INSERT INTO ctu76_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ti ochi ya' ti yotyot Dios. Ti' ch'ʌmʌ waj tsa' bʌ ajq'ui ti mesa tsa' bʌ i yʌc'ʌyob cha'an i majtyan Dios. Ti' c'uxu David. Ti yʌq'ue i pi'ʌlob je'el. Pero tic'bil cha'an ma' majch mi' c'uxe' jini waj. Jin jach curajob mi' c'uxob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Mach'a ba'an ti la' q'uele bajche' ts'ijbubil ti i mandar Moisés cha'an jini curajob ma' muc'ob ti c'aj oj? Mi' cha'leñob toñel ti templo che' ti yorojlel c'aj oj. Pero ma'an majch mi yʌlob cha'an xmulilob cha'an ti caj. ");
INSERT INTO ctu76_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero mic subeñetla wʌ' añon más ñucon bajche' jini templo. ");
INSERT INTO ctu76_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mach'an ti la' ch'ʌmbe isujm jini Ts'ijbubil bʌ i T'an Dios ba' mi yʌle': Jini com bʌ yi jiñʌch cha'an mi la' p'untyan la' pi'ʌlob cha'an la' wom la' cotyañob. Más wen mij q'uele' jini, che' bajche' che' mi la' wʌq'ueñon pulem bʌ c majtyan. Chʌ'ʌch ts'ijbubil ti' t'an Dios, che'en. Mi tsa'ic la' ch'ʌmbe i sujmlel ili t'an mach'an ti la' lolon subu i mul quixtyañujob che' mach'an i mulob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jesús ti' subeyob je'el. Joñoñʌch i Pi'ʌlon bʌ Quixtyañujob. An tic wenta cʌle' chʌ bʌ yom ujtic ti q'uinilel c'aj oj. Che' ti yʌlʌ Jesús che' cu i yʌc'bal. ");
INSERT INTO ctu76_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Che' jini Jesús ti loq'ui majlel ya'i. Ti ochi ti i templo israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ya'an juntiquil winic tyʌquin bʌ junts'ijt i c'ʌb. Ya'an quixtyañujob yom bʌ i jop'beñob i mul Jesús. Jin cha'an ti' c'ajtibeyob: ¿Yom ba lajmisʌntyel juntiquil xc'am'an ti q'uinilel c'aj oj, o mach yom? Che' ti' c'ajtibeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús ti' jac'beyob: Mi an tsa' bʌ yajli juncojt la' tiñʌme' ti pozo, ¿mach'a ba'an mi la' majlel la' wa' loc'san ti ora aunque i q'uinilelic c'aj oj? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero yoque más an i c'ʌjnibal quixtyañu che' bajche' tiñʌme'. Che' jini ma' tiq'uil cha'an i cha'lentyel wen bʌ che' ti q'uinilel c'aj oj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Che' jini Jesús ti' sube jini winic tyʌquin bʌ i c'ʌb: Sʌts'ʌ a c'ʌb, che'en. Che' ñac ti' sʌts'ʌ i c'ʌb ti wa' lajmi. Lajal wen ti cʌyle bajche' yambʌ i c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ti loq'uiyob majlel jini fariseojob. Ti queji i motin pensaliñob bajche' ch'ujbi i yʌc' ti tsʌnsʌntyel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Che' ñac ti' ña'tyʌ Jesús chʌ bʌ chʌncol i pensaliñob ti loq'ui majlel. Yonlel quixtyañu ti' tsʌcleyob majlel. Jesús ti' lajmisʌ ti pejtyelel xc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesús ti' tiq'uiyob cha'an mach'an mi yʌc'ob ti cʌjñel. ");
INSERT INTO ctu76_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chʌ'ʌch ti ujti cha'an mi' ts'ʌctiyel tsa' bʌ wʌ alʌ Dios ti ñoj oniyix che' ti' c'ʌmbe i ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios Isaías bʌ i c'aba'. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jiñʌch ili ajtroñel c cha'an tsa' bʌ c yajcʌ. Mic wen p'untyan. Ñoj wen mij q'uele'. Mi quej c bujt'isan i pusic'al ti Ch'ujul bʌ c Ch'ujlel. Mi quejel i suben mach'ʌ israelob cha'an bajche' mi quejel yʌc'ob ti tyoj bʌ melojel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma' mi quejel ti periyal. Ma' mi quejel ti c'am bʌ t'an cha'an i yʌc' i bʌ ti cʌjñel. Ma' mi quejel i yubintyel c'am bʌ i t'an ti calle tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Jini mi quejel i cuche' ti wen i c'unlel quixtyañujob. Mi quejel i p'ʌtyʌlisañob jintyo mi tyʌlel i yorojlel i cha'len tyoj bʌ melojel. ");
INSERT INTO ctu76_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ti pejtyelel mach'ʌ israelob mi quejel i ña'tyañob cha'an jiñʌch jini mu' bʌ i cotyan quixtyañujob. Chʌ'ʌch an ti Ts'ijbubil bʌ i T'an Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ti' pʌyʌyob tyʌlel ba'an Jesús juntiquil x'uma' yic'ot muts'ul i wut bʌ quixtyañu am bʌ i xiba ti' pusic'al. Che' ñac Jesús ti' lajmisʌ jini x'uma' yic'ot muts'ul i wut ti wa' queji ti t'an. Ti c'oti i wut. ");
INSERT INTO ctu76_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tyoj bʌc'ñʌjel quixtyañujob. Ti queji i c'ajtibeñob i bʌ: ¿Jim ba i jiñʌjlel David mu' bʌ choc tyʌlel Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero che' ñac jini fariseojob ti yubiyob chʌ bʌ chʌncol i pensaliñob ti yʌlʌyob: Ili winic mi' choque' loq'uel xibajob ti' p'ʌtyʌlel jach i yajaw xiba mu' bʌ i pejcʌntyel ti Beelzebú. Che' ti lolon alʌyob fariseojob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús ti' ña'tyʌ chʌ bʌ chʌncol i pensaliñob ti' pusic'al. Ti' subeyob: Mi ti queji i t'oxob i bʌ año' bʌ ti wenta ba'ic jach bʌ yumʌl, mi ti queji i periyaliñob i bʌ mi quejel i lajmisʌntyel i ye'tyel. Ma'ix mi quejel i jalejel jump'ej lum mi jump'ej otyot ba' mi' t'oxob i bʌ ti periyal. ");
INSERT INTO ctu76_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chʌ'ʌch Satanás je'el mach ch'ujbi i bajñel choc loq'uel i bʌ. Mi ti queji i periyalin i bʌ mi quejel i jilel i p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Mi ti i p'ʌtyʌlel Beelzebú mic choque' loq'uel xibajob mi la' wʌl, ¿baqui mi' tyaje' i p'ʌtyʌlel la' pi'ʌlob i choque' loq'uel xibajob, mi la' wʌl? Jin cha'an la' pi'ʌlob mi quejel i tsictisan la' ñajayel. ");
INSERT INTO ctu76_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Joñon bʌ yi ti' p'ʌtyʌlel Dios mic choque' loq'uel xibajob. Jin cha'an tsiquil chʌncol i pʌs i p'ʌtyʌlel Dios wʌ' ba' añetla. ");
INSERT INTO ctu76_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Bajche' ch'ujbi i yochel juntiquil ti yotyot p'ʌtyʌl bʌ winic i chilben loq'uel chʌ bʌ an i cha'an mi ma' ti' ñaxan cʌchʌ jini p'ʌtyʌl bʌ winic? Jin jach mi ti ñaxan cʌchʌ ch'ujbi i chilben chʌ bʌ an i cha'an. Chʌ'ʌch ti yʌlʌ ti lajoñel Jesús cha'an jini xiba che' bajche' p'ʌtyʌl bʌ winic. ");
INSERT INTO ctu76_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jini mach bʌ yom i q'uelon, mi' contrajiñon. Jini mach'ʌ ba'an mi' cha'len toñel quic'ot chʌncol jach i jisʌbeñon c toñel, yubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jin cha'an mic subeñetla, ch'ujbiyʌch i lu' ñusʌbentyelob pejtyelel i mul quixtyañujob yic'ot pejtyelel mach'ʌ wen bʌ i t'an mu' bʌ i cha'len ti' contra i pi'ʌlob. Jin jach mach ñusʌbil i mul jini mu' bʌ i cha'len t'an ti' contra Ch'ujul bʌ i Ch'ujlel Dios che' mi yʌl cha'an ti' p'ʌtyʌlel xiba ti' cha'le jini tsa' bʌ i cha'le Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ch'ujbi i ñusʌbentyel i mul majchical jach mi' cha'len t'an tij contra Joñon i Pi'ʌlon bʌ Quixtyañujob pero jini mu' bʌ i cha'len mach'ʌ wen bʌ t'an ti' contra Ch'ujul bʌ i Ch'ujlel Dios mach ñusʌbil i mul mi ti ili bʌ q'uin tyac wale iliyi mi ti tyal tyo bʌ ora. ");
INSERT INTO ctu76_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Mi wen jini tye' mi yʌc' wen bʌ i wut. Mi mach wen jini tye' mi yʌq'ue' mach'ʌ wen bʌ i wut. Mi cʌjñel tye' cha'an bajche' an i wut. ");
INSERT INTO ctu76_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jatyetla lajaletla bajche' lucum tyac am bʌ venenojlel ti' ti'. ¿Bajche'qui ch'ujbi la' cha'len wen bʌ t'an che' ñoj simaroñetla? Mach ch'ujbi. Como chʌ bʌ jach mi' but' ti i pusic'al quixtyañu mi tsictiyel ti i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jini wen bʌ quixtyañu mi yʌle' wen bʌ t'an cha'an jini wen am bʌ ti' pusic'al. Jini mach'ʌ wen bʌ quixtyañu mi yʌle' mach'ʌ wen bʌ t'an cha'an jini mach'ʌ wen bʌ am bʌ ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero mic subeñetla, che' ti yorojlel melojel jujuntiquil mi quejel i yʌq'uentyel i mel i bʌ cha'an jujump'al lolom jach bʌ t'an tsa' bʌ loq'ui ti' ti'. ");
INSERT INTO ctu76_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Jiñʌch bajche' ti la' cha'le t'an, chʌ'ʌch mi quejel i tsictisʌntyel la' mul. Mi weñʌch la' t'an, mi quejel la' sujbel ti tyoj. Mi mach wen la' t'an mi quejel la' sujbel ti xmulil. ");
INSERT INTO ctu76_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Che' jini ti c'oti ba'an Jesús cha'tiquil uxtiquil fariseo yic'ot yambʌ ajcʌntisajob cha'an i mandar israelob. Ti yʌlʌyob: Maestro, com lojon j q'uele' i señʌjlel ñuc tyac bʌ a p'ʌtyʌlel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús ti' jac'ʌ: Jini simaron bʌ quixtyañujob mach'ʌ yom i ch'ujbin Dios mi' c'ajtibeñob cha'an yomob i pʌs'entyel i señʌjlel ñuc tyac bʌ c p'ʌtyʌlel. Pero jini jach mi quejel i pʌs'entyelob bajche' ti ajni cha'an seña ti ñoj oniyix juntiquil tsa' bʌ xiq'ui yʌle' Dios Jonás bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Como che' bajche' Jonás ti' ñusʌ uxp'ej q'uin, uxp'ej ac'bʌlel ti' mal i ñʌc' colem chʌy, Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel c ñusan uxp'ej q'uin, uxp'ej ac'bʌlel ti mal lum. ");
INSERT INTO ctu76_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jini tsa' bʌ chumleyob ya' ti Nínive, i lumal Jonás, mi quejel i wa'tyʌl ti yorojlel melojel ti' tyojlel Dios che' mi' melob i bʌ quixtyañujob año' bʌ wale iliyi. Mi quejel i subob la' mul. Como jini año' bʌ ti Nínive ti' q'uextyʌyob i pensal, ti' cʌyʌyob i mul che' ñac Jonás ti' subeyob i t'an Dios. Ti' ch'ujbiyob. Pero joñon wʌ' añon, más ñucon che' bajche' Jonás pero ma'ix mi' ch'ujbibeñon c t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Je'el jini x'ixic bʌ yumʌl ya' ti sur mi quejel wa'tyʌl ti yorojlel melojel ti tyojlel Dios. Che' mi' melob i bʌ jini quixtyañujob año' bʌ wale mi quejel i subob i mul. Como jini x'ixic ch'oyol bʌ ti más ñajt bʌ pañimil ti tyʌli cha'an i ñʌch'tyan i ña'tyʌbal jini yumʌl Salomón bʌ i c'aba'. Pero más ñucon bajche' Salomón cha'an jach mach'an mi la' ch'ujbiñon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Che' mi loq'uel xiba ti' pusic'al quixtyañu mi' cha'len xʌmbal jini xiba ti tyʌquin bʌ lum tyac. Mi' bej sajcan majlel ba' mi' cha' ochel cha'an i c'aje' i yoj. Che' mach'an mi' tyaje' yambʌ yajnib, mi' pensalin: ");
INSERT INTO ctu76_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Mi quejel c cha' majlel ti cajnib ba' ti loq'uiyon, che'en. Che' mi cha' c'otyel xiba mi' tyaje' jini quixtyañu ba' ti loq'ui. Che' bajche' jocholix bʌ otyot mi yilan i pusic'al jini quixtyañu. Wen misubil, tyoj isʌbil yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Che' jini mi majlel jini xiba i pʌy tyʌlel yambʌ siete xibajob más simaroño' bʌ. Mi lu' ochel ti chumtyʌl ti' pusic'al jini quixtyañu. Ti wi'il más p'ump'um mi quejel i yajñel jini quixtyañu che' bajche' ti ñaxan. Chʌ'ʌch lajal bajche' jini mi quejel i yujtyel yic'ot jini simaroño' bʌ quixtyañujob año' bʌ wale iliyi. Mi quejel i más asiyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús chʌncol tyo i cʌntisan quixtyañujob che' ñac ya' ti c'oti i ña' yic'ot i yijts'iñob. Ya' añob ti pañimil. Yomob i pejcan Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","An majch ti' sube Jesús: Ya'an ti pañimil a ña' yic'ot a wijts'iñob. Yom i pejcañetyob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús ti' sube jini tsa' bʌ tyʌli i pʌye': ¿Majchqui jini c ña' yic'ot quijts'iñob mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Che' jini ti' sut q'uele jini chʌncol bʌ i cʌmbeñob i t'an. Ti yʌlʌ: Jiñob c ña'ob, quijts'iñob yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Como majchical jach mu' bʌ i cha'len bajche' yom i pusic'al c Tyat am bʌ ti panchan jiñʌch quijts'in, jiñʌch c ña' yubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Junyaj Jesús ti loq'ui majlel ti yotyot. Ti majli ti buchtyʌl ya' ti' ti' colem joyol bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ya' ti' much'quiyob i bʌ i yonlel quixtyañu. Che' jini ti ochi ti buchtyʌl Jesús ti mal jump'ej barco ya' ti ja'. Ya' ti lu' cʌyleyob ti' ti' ja' jini quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Che' jini Jesús ti' cʌntisʌyob ti cabʌl lajoñel tyac. Ti' subeyob: Ti loq'ui majlel juntiquil winic ti p'ujp'uya pac'. ");
INSERT INTO ctu76_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Che' ñac ti' p'ujp'u majlel jini pac' ti yajli ts'itya' ya' ti bij. Ti tyʌliyob xma'tye'mut. Ti lu' buc'u jini tsa' bʌ p'ajti ti bij. ");
INSERT INTO ctu76_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ts'itya' yambʌ ti yajli ti pam xajolel ba' mach'an tyam i lumil. Saj ora jach ti pasi che' cu mach'an tyam i lumil. ");
INSERT INTO ctu76_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Che' ti pasi q'uin, ti puli ti q'uin. Cha'an ma'ix tyam ochem i wi' ti tyʌqui. ");
INSERT INTO ctu76_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ts'itya' yambʌ ti p'ajti ti mal ch'ixol. Ti wen coli ch'ixol. Ti ye'bali jini pac. ");
INSERT INTO ctu76_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero yambʌ pac' ti yajli ba' wen bʌ lum. Che' ñac ti coli ti yʌc'ʌ wen bʌ i wut. An tsa' bʌ yʌc'ʌ cien i wut, yambʌ sesenta, yambʌ treinta. ");
INSERT INTO ctu76_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalin la. ");
INSERT INTO ctu76_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Che' jini ajcʌnt'añob i cha'an Jesús ti' lʌc'ʌyob Jesús. Ti' c'ajtibeyob: ¿Chucoch chʌncol a pejcan quixtyañu ti lajoñel tyac? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús ti' jac'ʌ: Dios ti yʌq'ueyetla la' ch'ʌm'en isujm jini max bʌ tyo ba'an tsictiyem ti yambʌ ora bajche' mi' cha'len yumʌl Dios. Pero jini yaño' bʌ mach ch'ujbi i ch'ʌmben isujm. ");
INSERT INTO ctu76_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jini mu' bʌ i ch'ʌmben i sujmlel i t'an Dios, mi quejel i yʌq'uentyel ti Dios i más ch'ʌmben isujm. Pero jini mach'ʌ yom yubin c t'an mi quejel i chilbentyel loq'uel ti' pusic'al jini ts'itya' tyac tsa' bʌ i cʌñʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jin cha'an mic pejcañob ti lajoñel tyac. Mi yilañob chʌ bʌ mic cha'len pero che' bajche' ma'ix mi c'otyelob i wut yubil mi' cha'len. Mi yubiñob c t'an pero ma'ix mi' ch'ʌmbeñob isujm, che' bajche' ma'ix chʌ bʌ ti yubiyob mi' cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cha'an bajche' mi yajñelob quixtyañujob mi' ts'ʌctiyel i t'an tsa' bʌ wʌ alʌ Dios che' ñac ti' c'ʌmbe i ti' juntiquil tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix Isaías bʌ i c'aba'. Ti yʌlʌ: Melelʌch mi quejel la' wubin t'an, pero ma'ix mi quejel la' ch'ʌmben isujm. Melelʌch mi quejel la' wilan pañimil, pero che' bajche' ma'ix mi c'otyel la' wut yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Che' bajche' tsʌtsob i pusic'al ili quixtyañu che' mach yom i ch'ʌmbeñob i sujmlel ili t'an. Che' bajche' ti' mʌcʌyob i chiquin cha'an ma'ix mi yubin t'an. Che' bajche' tsa'ix i muts'uyob i wut cha'an ma'ix mi yilan chʌ bʌ mi yilan. Ma'ix mi yubin chʌ bʌ mi yubin como che' bajche' mach yom i ch'ʌmben i sujmlel c t'an. Mach yom i q'uextyan i pusic'al i cʌye' i mul cha'an mic ñusʌbeñob i mul. Che' ti yʌlʌ Dios ti i ti' jini Isaías. ");
INSERT INTO ctu76_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero jatyetla, c'ajacña la' woj como tsa'ix la' ch'ʌmbe isujm jini chʌncol bʌ la' wilan, jini chʌncol bʌ la' wubin. ");
INSERT INTO ctu76_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Como mic subeñetla cabʌl jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix yic'ot cabʌlob wen bʌ quixtyañujob ti ñoj oniyix yomob i q'uelob jini chʌncol bʌ la' wilan. Pero mach'an ti yilʌyob. Yom i yubiñob jini chʌncol bʌ la' wubin, pero mach'an ti yubiyob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jesús ti' cha'le t'an. Ti yʌlʌ: Jiñʌch i sujmlel jini lajoñel cha'an pac'. ");
INSERT INTO ctu76_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Jini mu' bʌ i yubin jini t'an bajche' mi quejel i cha'len yumʌl Dios, pero ma'ix mi yochel ti' pusic'al cha'an mi' ch'ʌmbeñob isujm, ti lajoñel, jiñobʌch bajche' jini pac' tsa' bʌ p'ajti ti bij. Mi tyʌlel xiba mi' loc'san jini t'an tsa' bʌ pʌjq'ui ti' pusic'alob yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ti lajoñel, jini pac' tsa' bʌ p'ajti ba'an xajolel tyac, jiñʌch quixtyañujob che' mi yubiñob i t'an Dios ñoj yomajax i ch'ujbiñob, ");
INSERT INTO ctu76_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero cha'an ma' tyam an i wi' ti i pusic'al yubil, che' mi yubin wocol o che' mi yʌl'entyel cha'an ti caj ti' ch'ujbi jini i t'an Dios yom i wa' cʌye'. ");
INSERT INTO ctu76_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jini pac' tsa' bʌ p'ajti ti mal ch'ixol jiñʌch che' bajche' jini mu' bʌ i yubin i t'an Dios pero mi' bej pensalin i cha'an jach bʌ mulawil. Bej yom yambʌ chʌ bʌ an i cha'an. Pejtyelel yambʌ i pensal mi' yebalin jini t'an yubil, cha'an ma' mi yʌc' i wut. ");
INSERT INTO ctu76_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero jini pac' tsa' bʌ pʌjq'ui ti wen bʌ lum, ti lajoñel, jiñʌch quixtyañu mu' bʌ i wen ubin i t'an Dios, mu' bʌ i ch'ʌmben isujm, mu' bʌ i cabʌl cha'leñob bajche' yom i cha'leñob che' mi' wen ch'ujbiñob i t'an Dios. Mi' wen ac'ob i wut yubil. Mi yoc'an i wut ti cien, ti sesenta, ti treinta. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús ti' subeyob yambʌ lajoñel. Ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios che' bajche' juntiquil winic tsa' bʌ p'ujp'u wen bʌ pac' ya' ti lum. ");
INSERT INTO ctu76_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero che' lu' wʌyʌlob ti tyʌli juntiquil mu' bʌ i contrajin i yum jini lum. Ti' mucul pʌc'ʌ mach'ʌ wen bʌ pimel ya' ba'an wen bʌ pac'. Ti cha' majli. ");
INSERT INTO ctu76_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ti pasi wen bʌ pac'. Ti queji i yʌc' i wut. Che' jini ti tsictiyi ya'an je'el cabʌl mach'ʌ wen bʌ pimel. ");
INSERT INTO ctu76_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Che' jini, jini ajtoñelob i cha'an bʌ i yum jini lum ti majliyob ya' ba'an i yum. Ti' subeyob: C yum, mi weñʌch jini pac' tsa' bʌ pʌjq'ui ya' ti a lum, ¿baqui tyʌlem jini mach'ʌ wen bʌ pimel? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I yum ti' jac'ʌ: Jiñʌch i cha'libal juntiquil ajcontra, che'en. Che' jini, jini ajtroñelob ti' c'ajtibe: ¿A wom ba mi lojon c boque' loq'uel pejtyelel jini mach'ʌ wen bʌ pimel? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero i yum jini lum ti yʌlʌ: Mach yom, che'en. Como mi ti la' boco loq'uel jini mach'ʌ wen bʌ pimel bʌbʌq'uen mi la' boque' loq'uel yic'ot jini wen bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","La' ajnic cha'an lajal mi colel jintyo i yorojlel c'ajbal. Che' jini, mux c xiq'ue' jini ajc'ajbalob cha'an mi' ñaxan tsepe mach'ʌ wen bʌ pimel, cha'an mi' set cʌche' cha'an mi' pule'. Che' mi yujtyel jini, mux i c'aje' wen bʌ cha'an mi yotsañob ti yotyotlel ba' mi lotye'. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús ti' subeyob yambʌ lajoñel je'el. Ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios yic'ot i bʌc' mostaza tsa' bʌ i p'ujp'u juntiquil winic ti i lum. ");
INSERT INTO ctu76_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Jiñʌch yoque más i saj bʌ bʌc' che' bajche' pejtyelel chʌ bʌ tyac jach bʌ pac'. Pero che' mi colel, más colem mi majlel che' bajche' chʌ bʌ jach bʌ pimel. Colem mi colel jintyo chanix bajche' juntyejc tye' yubil. Ya' mi' mele' i c'u' xma'tye'mut ti i c'ʌb tyac. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús ti' subeyob yambʌ lajoñel. Ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios bajche' levadura mu' bʌ i yʌc' i wos i bʌ caxlan waj mu' bʌ i xʌc'tyun juntiquil x'ixic ti uxp'is harina mu' bʌ i c'ʌñob i mel caxlan waj. Jini mi yʌc' i lu' sijt'el caxlan waj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Puro ti lajoñel jach ti' cʌntisʌ quixtyañujob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chʌ'ʌch ti ujti cha'an mi ts'ʌctiyel tsa' bʌ wʌ alʌ Dios ti ñoj oniyix che' ñac ti' c'ʌmbe i ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios. Ti yʌlʌ: Ti lajoñel tyac mi quej c cha'len cʌntisa. Mi quej c subeñob mach'ʌ ba'an tsiquil i sujmlel tyac c'ʌlʌ che' ñac ti' mele mulawil Dios. Che' ti wʌ alʌ juntiquil tsa' bʌ i xiq'ui yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Che' jini, Jesús ti ujti i pejcan quixtyañujob. Ti ochi ti otyot. Che' jini, ti tyʌli ajcʌnt'añob i cha'an. Ti yʌlʌyob: Subeñon lojon i sujmlel jini lajoñel cha'an jini mach'ʌ wen bʌ pimel tsa' bʌ pʌjq'ui ya' ba'an jini wen bʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús ti' subeyob: Ti lajoñel jini tsa' bʌ i pʌc'ʌ wen bʌ pac' jiñʌch Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jini lum ba' ti pʌjq'ui, jiñʌch mulawil. Ti lajoñel jini wen bʌ pac' jiñʌch jini mu' bʌ i yumin Dios, jini mach'ʌ wen bʌ pimel jiñʌch jini añob bʌ ti i p'ʌtyʌlel xiba. ");
INSERT INTO ctu76_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ti lajoñel jini tsa' bʌ i pʌc'ʌ mach'ʌ wen bʌ pimel, jiñʌch xiba i bajñel. Ti lajoñel jini i yorojlel c'ajbal jiñʌch che' i yorojlel mi quejel i jilel mulawil. Ti lajoñel jini tsa' bʌ i cha'leyob c'ajbal jiñʌch jini ajtoñelob i cha'an Dios ch'oyolo' bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Che' bajche' ti' much'quiyob mach'ʌ wen bʌ pimel cha'an i pule' chʌ'ʌch mi quejel i yujtyel je'el cha'an mach'ʌ wen bʌ quixtyañu che' ti yorojlel mi quejel i jilel mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel c xiq'ue' majlel ajtoñelob i cha'an Dios ch'oyolo' bʌ ti panchan cha'an mi' c'aje' i wentyʌlel ti pejtyelel quixtyañujob tsa' bʌ yʌq'ue i yotsañob i mul i pi'ʌlob yic'ot mu' bʌ i cha'len mach'ʌ wen. ");
INSERT INTO ctu76_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mi quejel i chocob ochel ti yajnib c'ajc ba' mi quejel i cha'leñob uq'uel yic'ot tsʌts mi quejel i c'uxob i yej. ");
INSERT INTO ctu76_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero jini mu' bʌ i cha'leñob bajche' mi' xiq'ue' Dios mi quejel i yajñel ba' mu' ti yumʌl Dios wʌ' ti mulawil. Mi quejel i ts'ʌjyel bajche' q'uin. Jini yom i yʌle' mi quejel i q'uejlel ti tyoj. Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalin la. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesús ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios yic'ot yonlel tyaq'uin tsa' bʌ mujqui ti jamilol. Juntiquil winic ti' tyaja. Ya' ti cha' mucu ya' ba' ti' tyaja. Wen c'ajacña i yoj ti majli i choñe' ti pejtyelel chʌ bʌ an i cha'an cha'an i mʌñe' jini jamilol ba' mucul jini yonlel tyaq'uin. Jiñʌch yom i yʌle' che' mi lac yumin Dios, jini mu' bʌ i yʌq'ueñonla Dios más an i c'ʌjnibal bajche' pejtyelel am bʌ lac cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesús ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios yic'ot juntiquil ajmʌn lets bʌ i tyojol bʌ tyun perla bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Che' mi' tyaje' jump'ej ñoj lets bʌ i tyojol, mi majlel i choñe' pejtyelel chʌ bʌ an i cha'an cha'an i mʌñe' jini ñoj lets bʌ i tyojol bʌ tyun. ");
INSERT INTO ctu76_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ch'ujbi lac laje' i yumintyel Dios yic'ot jump'ej chimol chʌy tsa' bʌ chojqui ochel ti ja'. Ti ochi cabʌl chʌy ti chajp ti chajp. ");
INSERT INTO ctu76_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Che' but'ul chimol chʌy, jini ajchuc chʌyob mi' tyujc'añob loq'uel ti ja'. Ya' mi buchtyʌlob ti' ti' ja'. Mi yajcan loq'uel chʌy. Mi yotsan wen bʌ chʌy ti chiquib. Mi' chocob mach'ʌ wen bʌ chʌy. ");
INSERT INTO ctu76_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chʌ'ʌch mi quejel i yujtyel che' ti yujtibal mulawil. Mi quejel i tyʌlelob ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan. Partejʌch mi quejel i yajcan loq'uel simaron bʌ quixtyañujob ya' ba'an jini tyoj bʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mi quejel i chocob ochel simaron bʌ quixtyañujob ti c'ajc ba' mi quejel ti uq'uel yic'ot ba' mi quejel ti tsʌts c'uxob i yej. ");
INSERT INTO ctu76_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Che' jini, Jesús ti' c'ajtibeyob ajcʌnt'añob i cha'an: ¿Tsa'ix ba la' ch'ʌmbe isujm ti pejtyelel jini tsa' bʌ cʌlʌ? che'en. Ti' jac'ʌyob: Tsa'ix cu, c Yum, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Che' jini, Jesús ti' subeyob: Che' juntiquil ajcʌntisa cha'an i mandar israelob mi quejel i ch'ʌmben isujm jini c t'an cha'an bajche' mi quejel i cha'len yumʌl Dios lajalʌch bajche' juntiquil i yum otyot am bʌ cabʌl chʌ bʌ an i cha'an, tsijib tyo bʌ yic'ot oniyix tyac bʌ. Como yujil i yajcan i c'ʌñe' am bʌ i c'ʌjnibal ti jini oniyix bʌ yic'ot tsiji' bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Che' ñac ti ujti Jesús i subeñob ili lajoñel tyac ti loq'ui majlel ya'i. ");
INSERT INTO ctu76_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ya' ti c'oti ti' lumal ba' ti coli Jesús. Ti queji ti cʌntisa ti i templo israelob ya' ti i lumal. Tyoj bʌc'ñʌjel ti yubi quixtyañujob. Ti yʌlʌyob: ¿Baqui ti' niq'ui tyaja i ña'tyʌbal bajche' jini? che'ob. ¿Bajche'qui mi' tyaje' i p'ʌtyʌlel i pʌs'e ñuc tyac bʌ i p'ʌtyʌlel? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Jiñʌch i yalobil ajmel buchlibʌl. María i c'aba' i ña'. Jiñʌch i yʌscun Jacobo, José, Simón yic'ot Judas, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Yic'ot xc'alʌl bʌ i yijts'iñob Jesús wʌ' añob la quic'ot. ¿Baqui ti' cʌñʌ i cha'len bajche' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jin cha'an mach yomob i yubiñob mi ñuc Jesús. Pero Jesús ti' subeyob: Mi q'uejlel ti ñuc tsa' bʌ i xiq'ui yʌle' Dios. Jin jach jini año' bʌ ti yoque i lumal yic'ot jini año' bʌ ti yotyot, ma' mi' q'uele' ti ñuc. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jesús mach'an ti' pʌsʌ cabʌl ñuc tyac bʌ i p'ʌtyʌlel ya' ti' lumal como ma' ti' ch'ujbiyob cha'an an i p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti jim bʌ ora ñuc bʌ yumʌl Herodes ya' ti pañimil Galilea ti yubi t'an cha'an chʌ bʌ chʌncol i cha'len Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jini Herodes ti' subeyob jini ya' bʌ añob yic'ot: Jiñʌch jini Juan tsa' bʌ yʌc'ʌ ch'ʌm ja'. Tsa'ix tyejchi loq'uel ba'an sajtyemo' bʌ. Jini cha'an mi tsictiyel i p'ʌtyʌlel i pʌse' ñuc tyac bʌ i p'ʌtyʌlel. Che' ti yʌlʌ Herodes. Como chʌ'ʌch ti lolon pensali Herodes como ti yʌc'ʌ ti tsʌnsʌntyel jini Juan. ");
INSERT INTO ctu76_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Como jini Herodes ti yʌc'ʌ ti chucol jini Juan. Cʌchʌl i c'ʌb ti cadena ti yotsʌyob ti cʌchol. Chʌ'ʌch ti' cha'le cha'an ti caj jini Herodías, i yijñam Felipe. Jini Felipe jiñʌch i yijts'in Herodes. ");
INSERT INTO ctu76_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Como jini Juan ti' sube Herodes: Mach yom che' ma' pʌyben i yijñam a wijts'in, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jini Herodes yom i yʌc' ti tsʌnsʌntyel Juan pero ti' bʌc'ñʌ quixtyañujob como ti' pensaliyob cha'an jini Juan jiñʌch juntiquil tsa' bʌ i xiq'ui yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero che' ñac ti ts'ʌctiyi i q'uinilel i jabilel Herodes, ti tyʌli i yixic'al Herodías cha'an i bajñel cha'len son ya' ti tyojlel i wut pʌyʌlo' bʌ ti q'uinijel. Ñoj wen ti yilʌ Herodes jini son. ");
INSERT INTO ctu76_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jini Herodes ti' wa'choco i t'an cha'an wersa mi quejel i yʌq'uen jini xc'alʌl chʌ bʌ jach yes mi' c'ajtin. ");
INSERT INTO ctu76_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jini xc'alʌl ti majli i c'ajtiben i ña' chʌ bʌ yom i c'ajtiben jini Herodes. Che' jini ti cha' majli ya' ba'an Herodes. Ti' sube: Com ma' pit aq'ueñon ti colem ch'ejew i jol jini Juan mu' bʌ i yʌc' ch'ʌm ja', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ñoj ch'ʌjyem ti queji i yubin jini Herodes pero cha'an ti' wa'choco i t'an ti' tyojlel jini pʌyʌlob bʌ ti q'uinijel ti' xiq'ui ti aq'uentyel jini xc'alʌl jini tsa' bʌ i c'ajti. ");
INSERT INTO ctu76_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Che' jini ti' xiq'ui majlel juntiquil cha'an mi' tyuc' tsepben loq'uel i jol Juan ya' ti cʌchonibʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ti jumuc' ti' pit ch'ʌmʌ tyʌlel i jol ti mal ch'ejew. Ti yʌq'ue jini xc'alʌl. Ti majli i yʌq'uen i ña'. ");
INSERT INTO ctu76_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Che' jini, ti tyʌliyob jini ajcʌnt'añob i cha'an Juan. Ti' ch'ʌmʌyob majlel i bʌc'tyal. Ti' ch'ujñʌyob. Che' jini ti majliyob i subeñob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Che' ñac ti subenti Jesús bajche' ti tsʌnsʌnti Juan, ti ochi ti barco cha'an mi bajñel majlel ya' ba' jochol jini lum. Pero ti' ña'tyʌyob quixtyañujob ba' ti majli. Che' jini ti loq'uiyob ti lum tyac. Ti yoc ti' tsʌcleyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Che' ñac ti loq'ui Jesús ti barco ti yilʌ ya'an yonlelob quixtyañu. Ti' p'untyʌyob cha'an yom i cotyañob. Ti' lajmisʌ jini xc'am'añob tsa' bʌ i pʌyʌyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Che' iq'uix quejel ti tyʌliyob ba'an Jesús jini ajcʌnt'añob i cha'an. Ti' subeyob: Chʌncox i p'ʌjquel q'uin. Mach'an chʌ bʌ yes an wʌ'i. Subeñob majlel quixtyañujob cha'an mi majlelob ya' ti lʌc'ʌl bʌ saj lum tyac cha'an i mʌñob chʌ bʌ mi' c'uxob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús ti' subeyob: Ma' chʌ bʌ och mi majlelob. Jatyetla yom mi la' wʌq'ueñob chʌ bʌ mi' c'uxob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ti' jac'ʌyob: An jo'q'uej jach lojon c waj yic'ot cha'cojt chʌy, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús ti' subeyob: Ch'ʌmʌla tyʌlel wʌ' ba'añon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Che' jini ti' subeyob quixtyañujob cha'an mi buchtyʌlob ti jam. Che' jini Jesús ti' ch'ʌmʌ jini jo'q'uej waj yic'ot cha'cojt chʌy. Ti' q'uele letsel ti panchan. Ti' sube Dios wocox i yʌlʌ. Che' jini ti' xet'e jini waj. Ti yʌq'ueyob jini ajcʌnt'añob i cha'an. Ti' lu' pucbeyob ti pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ti' lu' c'uxuyob. Tsa'ix ñaj'ʌyob. Che' jini, che' ti ujtiyob ti uch'el ti' lotyoyob doce chiquib i colojbal i xejt'il tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Che' bajche' jo'p'ej mil winicob ti' c'uxuyob jini waj yic'ot chʌy. An x'ixicob yic'ot alp'eñalob je'el pero ma'an ti' tsiquiyob jaytiquilob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesús ti' subeyob ochel ti barco jini ajcʌnt'añob i cha'an, cha'an mi' ñaxan c'axelob ti junxej colem joyol bʌ ja'. Jesús tsa' tyo cʌyle cha'an mi' subeñob majlel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Che' ti ujti i subeñob sujtyel ti letsi majlel Jesús ya' ti wits cha'an mi' bajñel cha'len oración. C'ʌlʌ ti ochi ac'bʌlel i bajñel ya'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ya'an jini barco ti xinil ja'. An toñel bʌ ic'. Chʌncol i wets' ochel ja' ti barco jini ic'. ");
INSERT INTO ctu76_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Che' yomox sʌc'an ti tyʌli Jesús ya' ba'añob. Chʌncol ti xʌmbal tyʌlel ti pam ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Che' ñac ti yilʌyob chʌncol ti xʌmbal Jesús ti' pam ja', tyoj bʌc'ñʌjel ti yilʌyob jini ajcʌnt'añob i cha'an. Ti quejiyob ti oñel cha'añob i bʌq'uen. Ti yʌlʌyob: Q'uele ya'an i wʌy quixtyañu. Che' ti lolon alʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesús ti' pejcʌyob. Ti' subeyob: La' lajmic la' bʌq'uen. Joñoñʌch. Mach la' bʌc'ñañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Che' jini, Pedro ti' sube: C Yum, mi jatyetyʌch aq'ueñon c tyʌlel ya' ba'añet ti pam ja', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús ti' sube: La', che'en. Che' jini Pedro ti loq'ui ti barco. Ti queji ti xʌmbal majlel ti pam ja' cha'an mi majlel ya' ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero che' ñac ti yubi ñoj toñel bʌ ic' ti queji ti bʌq'uen Pedro. Ti queji i sujp'ejl majlel ti mal ja'. Ti c'am bʌ oñel ti yʌlʌ: C Yum, cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ti saj ora jach Jesús ti' chucbe i c'ʌb. Ti yʌlʌ: Ts'itya' jach chʌncol a ch'ujbiñon. ¿Chucoch ma'an ma' ch'ujbiñon ti jump'ej jach a pusic'al? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Che' ñac ti cha' ochi ti barco Jesús yic'ot Pedro ti wa' ñʌch'le jini toñel bʌ ic'. ");
INSERT INTO ctu76_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jini añob bʌ ti barco ti' ñocchocoyob i bʌ ti yebal yoc Jesús. Ti yʌlʌyob: Melel jatyet i Yalobiletyʌch Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesús yic'ot ajcʌnt'añob i cha'an ti c'axiyob ti jini colem joyol bʌ ja'. Ti c'otiyob ya' ti pañimil Genesaret bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Che' ñac jini ya' bʌ chumulob ya'i ti' ña'tyʌyob cha'an ya'an Jesús, ti' pucuyob majlel t'an ya' ti pejtyel pañimil. Ti' pʌyʌyob tyʌlel ba'an Jesús pejtyelel xc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ti' c'ajtibeyob Jesús ti wocol t'an cha'an mi yʌq'uen i tyʌlben i yoquic jachix i bujc cha'an mi lajmel. Ti lu' lajmiyob ti pejtyelelob tsa' bʌ tyʌlbe i bujc. ");
INSERT INTO ctu76_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Cha'tiquil uxtiquil ajcʌntisa cha'an i mandar israelob yic'ot fariseojob ch'oyolo' bʌ ti Jerusalén ti tyʌliyob ya' ba'an Jesús. Ti yʌlʌyob: ");
INSERT INTO ctu76_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Chucoch mi' ñusañob t'an jini ajcʌnt'añob a cha'an? Ma' mi' pocob i c'ʌb che' mi quejel ti uch'el che' bajche' mi xijq'uelob cha'an jini tsa' bʌ i ch'ujbiyob lac yumob ti ñoj oniyix. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús ti' jac'ʌ: Ixcu jatyetla, ¿chucoch mi la' ñusan i xic'ojel Dios cha'an jach la' wom la' ch'ujbin t'an cha'an bajche' ti' bajñel xiq'uiyob i bʌ i cha'len lac yumob ti ñoj oniyix? ");
INSERT INTO ctu76_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Como Dios ti yʌlʌ: Ac'ʌ ti ñuc la' tyat la' ña'. Jini mu' bʌ i yʌl'en i tyat i ña', la' sajtic. Che' an ti mandar. ");
INSERT INTO ctu76_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero jatyetla, weñʌch mi la' lolon ale' che' an winic mu' bʌ i suben i tyat i ña': Mach ch'ujbi j cotyañetla como ti pejtyelel chʌ bʌ jach an c cha'an tsa'ix cʌq'ue Dios, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mi la' wʌle' cha'an majchical jach mi yʌl che' bajche' jini mach wersa mi' cotyan i tyat i ña', che'etla. Mi la' cha'len che' bajche' ma'ix i c'ʌjnibal i xic'ojel Dios cha'an jach la' wom la' jac'ben bajche' ti' bajñel xiq'uiyob i bʌ lac yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Cha'chajp la' pensal. Weñʌch bajche' ti' tyajayetla ti t'an Isaías, jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Dios ti' c'ʌmbe i ti'. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ti i ti' jach mi' q'uelon ti ñuc ili quixtyañujob. Pero ma' mi' ch'ujbiñon ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ma'ix i c'ʌjnibal mi' lolon cha'len che' bajche' chʌncox i ch'ujutisañon, como mi' cʌntisan i xic'ojel jach quixtyañu. Che' ti yʌlʌ Dios ti i ti' Isaías, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Che' jini Jesús ti' cha' pʌyʌyob tyʌlel jini quixtyañujob. Ti' subeyob. Ñʌch'tyañla. Wen ch'ʌmbenla isujm. ");
INSERT INTO ctu76_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jini mu' bʌ i yochel ti i ti' quixtyañujob mach'an mi' bibi'tisañob. Mi' bibi'tisan quixtyañujob mu' bʌ i loq'uel ti' pusic'al. Jiñʌch mach'ʌ yom i yilan Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Che' jini, jini ajcʌnt'añob i cha'an ti' lʌc'ʌyob Jesús. Ti' subeyob: ¿A wujil ba che' ti wen mich'ʌ fariseojob che' ñac ti yubiyob tsa' bʌ a wʌlʌ? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús ti' jac'ʌ: Chʌ bʌ jach bʌ cʌntisa mach'ʌ tyʌlem ya' ba'an c Tyat ti panchan mi quejel i jilel. ");
INSERT INTO ctu76_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","La' ajnic. Muts'ulob i wut jini chʌncol bʌ i pʌs'en bij yambʌ muts'ulo' bʌ i wut, yubil. Che' jini che' juntiquil muts'ul bʌ i wut mi' pʌs'en bij yambʌ muts'ul bʌ i wut, ti cha'ticlelob mi yajlelob ochel ti jowol bʌ lum. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Che' jini, Pedro ti' sube Jesús: Subeñon lojon i sujmlel jini lajoñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús ti' jac'ʌ: ¿Mach'a ba'an ti la' ña'tyʌ i sujmlel jatyetla je'el? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Mach'a ba'an mi la' ña'tyan cha'an chʌ bʌ jach mi yochel ti lac ti' ti lac ñʌc' jach mi majlel? Che' jach mi ñumel ti lac ñʌc'. ");
INSERT INTO ctu76_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero tyʌlem ti i pusic'al mu' bʌ i loq'uel ti i ti' quixtyañu. Jiñʌch mu' bʌ i bibi'tisan quixtyañu. Jiñʌch jini mach'ʌ yom i yilan Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Como ti' pusic'al quixtyañu mi loq'uel mach'ʌ wen bʌ i pensal, yic'ot tsʌnsa, yic'ot che' mi' pejcan yambʌ x'ixic, yic'ot che' mi' cha'len i tontojlel quixtyañu, yic'ot xujch', yic'ot lot, yic'ot jop't'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jiñʌch mu' bʌ i bibi'tisan quixtyañujob, jiñʌch mach'ʌ yom i yilan Dios. Ma' mi' bibi'tisan quixtyañu che' mi' cha'len uch'el che' ma' mi' pocob i c'ʌb bajche' ti' bajñel xiq'uiyob i bʌ i cha'len lac yumob ti ñoj oniyix. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús ti loq'ui majlel. Ti majli ya' ti lum tyac Tiro yic'ot Sidón bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ya' an juntiquil x'ixic ch'oyol bʌ ti pañimil Canaán pero ya' chumul ya' ti lum ba' ti c'oti Jesús. Ti tyʌli ya' ba'an Jesús. Ti c'am bʌ t'an ti yʌlʌ: C Yum, i jiñʌjlelet bʌ David tsa' bʌ i choco tyʌlel Dios, p'untyañon cha'an ma' cotyañon, che'en. Ñoj wocol chʌncol i ñusan quixic'al cha'an an xiba ti' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús ma' ti' saj jac'be i t'an jini x'ixic. Che' jini, ajcʌnt'añob i cha'an Jesús ti' sube Jesús: Suben cha'an sujtic jini x'ixic como ti c'am bʌ t'an chʌncol i tsʌcleñonla majlel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Che' jini ti yʌlʌ Jesús: Dios ti' chocoyon tyʌlel cha'an mij cotyan jini israelob jach bʌ max tyo bʌ ba'an mi' ch'ujbiben i t'an, como jiñʌch che' bajche' tiñʌme' tsa' bʌ sʌtyʌ i bijlel yubil, che'en. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero jini x'ixic ti bej tyʌli i lʌq'ue' Jesús. Ti' ñocchoco i bʌ ti yebal i yoc. Ti yʌlʌ: C Yum, cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús ti' sube: Mach yom mi chilbentyel i waj alp'eñalob cha'an jach mi chocbentyel yal ts'i' yubil, che'en. Chʌ'ʌch ti yʌlʌ Jesús cha'an ñaxan yom cotyʌnticob israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero jini x'ixic ti' jac'ʌ: Melelʌch bajche' ma' wʌl, c Yum. Pero jini i yal ts'i' am bʌ ti ye' mesa mi' c'uxe' i xejt'il waj mu' bʌ i p'ʌtsañob alp'eñalob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesús ti' sube jini x'ixic: X'ixic, ti jump'ej a pusic'al tsa'ix a ch'ujbi cha'an ch'ujbi c cha'len bajche' ma' c'ajtibeñon. La' aq'uentiquet che' bajche' a wom, che'en. Ti saj ora jach ti lajmi i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús ti loq'ui majlel. Ti ñumi majlel ya' ti' ti' colem joyol bʌ ja' Galilea bʌ i c'aba'. Ya' ti letsi ti wits. Ti buchle. ");
INSERT INTO ctu76_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Cabʌl quixtyañujob ti c'oti ya' ba'an Jesús. Ti' pʌyʌyob tyʌlel mach'ʌ ba'an i c'ʌjnibal i yoc yic'ot muts'ulob i wut, yic'ot x'uma'ob, yic'ot mach'ʌ ts'ʌcʌl yoc i c'ʌb, yic'ot cabʌl yaño' bʌ. Ti' pʌyʌyob tyʌlel ti yebal yoc Jesús. Ti' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tyoj bʌc'ñʌjel ti yubi quixtyañujob che' ñac ti yilʌ bajche' ti lajmisʌntiyob. Como x'uma'ob ti cha' quejiyob ti t'an. Cha' wenix i yoc i c'ʌb jini mach'ʌ ts'ʌcʌl yoc i c'ʌb. Ti cha' queji ti xʌmbal jini mach'ʌ ba'an i c'ʌjnibal i yoc. Ti cha' c'oti i wut jini muts'ulo' bʌ i wut. Ti queji i subob i ñuclel Dios mu' bʌ i ch'ujutisañob israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Che' jini Jesús ti' pʌyʌ tyʌlel jini ajcʌnt'añob i cha'an. Ti yʌlʌ: P'ump'un mij q'uelob quixtyañujob como c'ʌlʌ uxp'ej q'uin wʌ' añob la quic'ot. Ma' chʌ bʌ ti' c'uxuyob. Mach com xic'ob sujtyel ti yotyot che' wi'ñayobix ame mi c'un'añob ti bij. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Che' jini, ajcʌnt'añob i cha'an ti yʌlʌ: ¿Bajche'qui ch'ujbi c lojon tyaje' waj wʌ' ti joch lum cha'an ñaj'acob ñoj cabʌl quixtyañu? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús ti' c'ajtibeyob: ¿Jayq'uej waj an la' cha'an? che'en. Ti yʌlʌyob: An siete yic'ot an cha'cojt uxcojt saj chʌy, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Che' jini Jesús ti' subeyob quixtyañujob cha'an mi buchtyʌlob ti lum. ");
INSERT INTO ctu76_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Che' jini ti' ch'ʌmʌ jini waj yic'ot chʌy. Ti' sube Dios wocox i yʌlʌ. Che' jini ti' xet'e. Ti' ac'ʌyob ajcʌnt'añob i cha'an. Ti' lu' pucbeyob majlel ba'an pejtyelel quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ti' lu' c'uxuyob. Ti lu' ñaj'ʌyob. Che' jini, che' ti ujtiyob ti uch'el ti' lotyoyob siete colem chiquib but'ul i colojbal xejt'il tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cuatro mil winicob tsa' bʌ i c'uxu jini waj yic'ot chʌy. An x'ixicob yic'ot alp'eñalob je'el pero ma' ti' tsiquiyob jaytiquil. ");
INSERT INTO ctu76_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesús ti' subeyob sujtyel quixtyañujob. Che' jini ti majli ti barco ti pañimil Magdala bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Cha'tiquil uxtiquil fariseo yic'ot saduceojob ti majliyob ya' ba'an Jesús cha'an jach yom i yil pusic'leñob cha'an yom i contrajiñob ti t'an. Jin cha'an ti' subeyob cha'an yom i pʌs'entyelob i p'ʌtyʌlel tyʌlem bʌ ba'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesús ti' subeyob: Che' ti och an q'uin mi la' wʌle': Utsil ijc'ʌl como chʌchʌc ya' ti chan, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Yic'ot ti sʌc'an mi la' wʌl: Tyal ja'al wale como chʌchʌc ya' ti chan yic'ot an tyocal, che'etla. Cha'chajp la' pensal. Mi la' ña'tyan mi tyal ja'al o mi utsil quejel, pero mach'an mi la' ña'tyan chʌ bʌ yes chʌncol i yujtyel wʌ' ti mulawil aunque mi la' q'uel chʌ bʌ tyac chʌncol c cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jini simaron bʌ quixtyañujob mach'ʌ yom i ch'ujbin Dios mi' c'ajtibeñob cha'an yomob i pʌs'entyel i señʌjlel c p'ʌtyʌlel. Pero jini jach mi quejel i pʌs'entyelob bajche' ti ajni cha'an jump'ej seña ti ñoj oniyix juntiquil tsa' bʌ i xiq'ui yʌle' Dios Jonás bʌ i c'aba'. Che' ti yʌlʌ Jesús. Ma'an chʌ bʌ yambʌ ti yʌlʌyob fariseojob yic'ot saduceojob. Ti sujti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Che' ñac ti' c'axiyob ti colem joyol bʌ ja', mach'an c'ajal i cha'an i ch'ʌmob majlel waj jini ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Che' jini, Jesús ti' subeyob: Tsajibiletla yom. Cʌñʌtyan la' bʌ cha'an jini levadura mu' bʌ i yʌq'uen i wos i bʌ caxlan waj i cha'an bʌ fariseojob yic'ot saduceojob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ti queji i pejcañob i bʌ jini ajcʌnt'añob i cha'an Jesús. Ti yʌlʌyob: Chʌ'ʌch chʌncol i yʌle' cha'an mach'an ti lac ch'ʌmʌ tyʌlel lac caxlan waj, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús ti' ña'tyʌ chʌ bʌ chʌncol i yʌlob. Ti' subeyob: ¿Chucoch chʌncox la' lolon al che' mach'an la' caxlan waj? Max tyo ba'an chʌncol la' ch'ujbiñon ti jump'ej la' pusic'al cha'an an c p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mach'a ba'an c'ajal la' cha'an jini joq'uej waj tsa' bʌ c xet'beyob cha'an i c'uxob cinco mil winicob? ¿Mach'a ba'an c'ajal la' cha'an jayp'ej chiquib tsa' bʌ la' lotyo i colojbal i xejt'il tyac? ");
INSERT INTO ctu76_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Mach'a ba'an c'ajal la' cha'an jini siete waj tsa' bʌ c xet'beyob cha'an i c'uxob cuatro mil winicob? ¿Mach'a ba'an c'ajal la' cha'an jayp'ej chiquib ti la' lotyo i colojbal i xejt'il tyac? ");
INSERT INTO ctu76_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chucoch mach'an ti la' ch'ʌmbe isujm cha'an mach caxlan wajic chʌncol c tyaje' ti t'an che' mic subeñetla cha'an mi la' cʌñʌtyan la' bʌ cha'an levadura mu' bʌ i yʌq'uen i wos i bʌ jini caxlan waj i cha'an bʌ fariseojob yic'ot saduceojob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Che' jini, ti' ch'ʌmbeyob isujm cha'an ti' subeyob cha'an i cʌñʌtyañob i bʌ cha'an i cʌntisa fariseojob yic'ot saduceojob, mach cha'anic levadura mu' bʌ i yʌq'uen i wos i bʌ caxlan waj. ");
INSERT INTO ctu76_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Che' ñac ti c'oti Jesús lʌc'ʌl ti lum Cesarea Filipo bʌ i c'aba' ti' c'ajtibe ajcʌnt'añob i cha'an: ¿Chuqui mi yʌl quixtyañujob? ¿Majchonqui bʌ i Pi'ʌl Quixtyañujob mi yʌlob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ti yʌlʌyob: Cha'tiquil uxtiquil mi yʌlob jatyet Juañet tsa bʌ i yʌc'ʌ ch'ʌm ja', che'ob. Yaño' bʌ mi yʌlob Elíasjet, che'ob. Yic'ot yaño' bʌ mi yʌlob Jeremíasjet o mi yambʌ tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, che'ob. Che' ti' jac'ʌ ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Che' jini, Jesús ti' c'ajtibeyob: Jixcu jatyetla, ¿majchonqui mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Che' jini ti' jac'ʌ Pedro: Jatyet jini yajcʌbil bʌ i cha'an cuxul bʌ Dios mu' bʌ a pejcʌntyel ti Cristo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Che' jini ti yʌlʌ Jesús: Tijicña a pusic'al Simón, i yalobilet bʌ Jonás como mi junticlec quixtyañu ti yʌq'ueyet a ña'tyan bajche' jini. Pero jini c Tyat am bʌ ti panchan ti yʌq'uet a ña'tyan majchonqui, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mic subeñet cha'an a c'aba' Pedro yom i yʌl tyun. Mach'ʌ ba'an majch ch'ujbi i nijcan colem bʌ tyun, chʌ'ʌch bajche' jini ma' majch ch'ujbi i nijcʌbeñet a pusic'al cha'an ma' cʌy a ch'ujbiñon. Mach'an mi quejel i jotyob jini yom bʌ i yʌc'ob ti sajtyel mu' tyo bʌ quejel i yoque ch'ujbiñon ti tyal tyo bʌ ora. ");
INSERT INTO ctu76_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi quej cʌq'ueñet a we'tyel cha'an jini mu' bʌ i yochelob ya' ba' mu' ti yumʌl Dios. Jini mu' bʌ a wʌq'uen a t'an cha'an mi' cha'len quixtyañu ch'ujbi i cha'len. Chʌ'ʌch Dios je'el mi yʌc' i t'an i cha'len. Mi mach'an ma' wʌq'uen a t'an cha'an ch'ujbi i cha'len, mach ch'ujbi i cha'len, che' jini. Chʌ'ʌch Dios je'el mach'an mi yʌc' i t'an i cha'len. Che' ti subenti Pedro ti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Che' jini Jesús ti' wersa tiq'ui ajcʌnt'añob i cha'an cha'an mach'an mi' subeñob mi junticlec cha'an jiñʌch Cristo, jini yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ti jim bʌ ora Jesús ti queji i wen suben ajcʌnt'añob i cha'an chʌ bʌ yes mi quejel i yujtyel tyac. Ti' wʌ subeyob cha'an wersa mi majlel ya' ti Jerusalén. Cha'an ya'i jini xñoxob año' bʌ i ye'tyel yic'ot ñuco' bʌ curajob yic'ot ajcʌntisajob cha'an mandar i cha'an israelob mi quejel i yʌq'uen i ñusan cabʌl wocol. Mi quejel i tsʌnsʌntyel pero ti yuxp'ejlel q'uin mi quejel i cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Che' ti wʌ subeyob. ");
INSERT INTO ctu76_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Che' jini, Pedro ti' bajñel pʌyʌ majlel Jesús ti jumpat. Ti queji i tiq'ue'. Ti yʌlʌ: C Yum, la' i p'untyañet Dios. Mach che'ic mi quejel a wujtyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús ti' sutqui i bʌ i q'uel Pedro. Ti' sube: Loq'uen wʌ' ba' añon como chʌncol a ña'tyan che' bajche' mi' ña'tyan Satanás. Chʌncol a jop' a mʌctyʌbeñon c cha'len chʌ bʌ yom i pusic'al Dios. Mach'an ma' ña'tyan bajche' yom Dios, jin jach bajche' mi' mulan quixtyañujob. Che' ti subenti Pedro. ");
INSERT INTO ctu76_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Che' jini Jesús ti' sube ajcʌnt'añob i cha'an: Mi an majch yom i tsʌcleñon, la' i cʌy mu' bʌ i bajñel mulan i niq'ui cha'len. La' i ñusan wocol ti jujump'ej q'uin cha'an ti caj chʌncol i ch'ujbiñon. Aunque mi sajtyel tij caj, la' i tsʌcleñon majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jini yom bʌ i lolon bajñel cʌñʌtyan i bʌ mi quejel i sʌtye' i cuxtyʌlel mach'ʌ yujil jilel. Pero jini mu' bʌ i yʌc' i bʌ cha'añon mi quejel i cotyʌntyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Chutyoqui i c'ʌjnibal i cha'an quixtyañu mi' lolon ganarin pejtyel chʌ bʌ tyac am bʌ ti ili mulawil mi mach'an ti' tyaja i cuxtyʌlel mach'ʌ yujil jilel? Como mach'an bajche' ch'ujbi i saj mʌñe' i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Como Joñon i Pi'ʌlon bʌ Quixtyañujob mic majlel ti panchan. Che' jini mi quejel c cha' tyʌlel ti' ñuclel c Tyat am bʌ ti panchan yic'ot ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan. Ti jim bʌ ora mi quejel cʌq'uen jujuntiquil i tyojol i cha'libal yubil mi weñʌch o mi mach wen, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Melel mic subeñetla, wʌ' añob mach'ʌ ba'an mi quejel i sajtyelob jintyo mi yilañoñob, Joñon i Pi'ʌlon bʌ Quixtyañu, che' mic cha' tyʌlel c cha'len yumʌl. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Che' ñac ti ñumi wʌcp'ej q'uin Jesús ti' pʌyʌyob majlel Pedro yic'ot Jacobo yic'ot i yijts'in Jacobo, Juan bʌ i c'aba'. Ti' pʌyʌyob majlel ti chan bʌ wits. ");
INSERT INTO ctu76_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Che' ñac ya' añob ti yʌjni i ñi' i wut Jesús ti yilʌyob. Lemlaw ti majli i ñi' i wut lajal bajche' q'uin. Wen sʌsʌc ti majli i pislel lajal bajche' i sʌclel pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti ora jach ti yilʌyob ya'an Moisés yic'ot Elías. Chʌncolob ti t'an yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Che' jini, Pedro ti' sube Jesús: C Yum, c'otyajax che' wʌ' añonla wʌ'wʌ'i. La' c mele' lojon uxp'ej lechi'pat. Jump'ej a cha'an, jump'ej i cha'an Moisés yic'ot jump'ej i cha'an Elías. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Che' mu' tyo ti t'an Pedro, ti tyʌli jump'ej lemlaw bʌ tyocal tsa' bʌ mosoyob. Che' jini ti yubiyob ajt'an ya' ti mal tyocal tsa' bʌ yʌlʌ: Jiñʌch p'untyʌbil bʌ calobil. Ñoj uts'at mij q'uel. Ñʌch'tyʌbenla i t'an. Che' ti yʌlʌ jini ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Che' ñac ti yubiyob ajt'an jini ajcʌnt'añob i cha'an Jesús ti' ñocchocoyob i bʌ ti lum. Bʌbʌq'uen ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Che' jini Jesús ti majli ya' ba'añob. Ti' tyʌlbeyob i quejlop. Ti' subeyob: Tyejchenla. Mach la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Che' ñac ti' q'ueleyob ti suttyʌlel, ma'ix tsiquil yaño' bʌ. Jin jachix Jesús ya'an. ");
INSERT INTO ctu76_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Che' ñac chʌncol i jubelob tyʌlel ti wits Jesús ti' tiq'uiyob. Ti' subeyob: Ma'an majch mi la' saj suben jini tsa' bʌ la' wilʌ jintyo mic tyejchel loq'uel ba'an sajtyemo' bʌ, Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Che' jini, ajcʌnt'añob i cha'an Jesús ti' c'ajtibe: ¿Chuquiyes i sujmlel che' mi yʌlob jini ajcʌntisajob cha'an mandar i cha'an israelob cha'an ñaxan wersa mi tyʌlel Elías? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús ti' jac'beyob: Melelʌch ñaxan mi tyʌlel Elías cha'an mi' tyoj'isan pejtyelel chʌ bʌ an. Ti wi'il mi tyʌlel jini mu' bʌ i choc tyʌlel Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero mic subeñetla cha'an tsajni Elías pero ma'an majch ti' ña'tyʌ mi jiñʌchi. Ti' lu' tyʌc'lʌyob. Ti' tsʌnsʌyob. Chʌ'ʌch joñon je'el i Pi'ʌlon bʌ Quixtyañujob mi quejel quilan wocol ti' c'ʌbob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Che' jini, ajcʌnt'añob i cha'an Jesús ti' ch'ʌmbeyob isujm cha'an jini tsa' bʌ i yʌlʌ Jesús cha'an Elías jiñʌch Juan tsa' bʌ yʌc'ʌ ch'ʌm ja' chʌncol bʌ i tyaj ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ti c'otiyob Jesús yic'ot ajcʌnt'añob i cha'an ya' ba'an quixtyañujob. Che' jini juntiquil winic ti tyʌli ya' ba'an Jesús. Ti ñocle ti yebal yoc Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ti yʌlʌ: C Yum, p'untyan cha'an a wom a cotyan jini alo' bʌ calobil. An q'uinil mi yʌq'uen jits'cuyel. Ñoj cabʌl mi' ñusan wocol. Cabʌl mi yajlel ochel ti c'ajc. Cabʌl mi yajlel ochel ti ja', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tic pʌyʌ tyʌlel wʌ' ba'an ajcʌnt'añob a cha'an cha'an mi' lajmisan, pero mach'an ti mejliyob. Che' ti yʌlʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Che' jini Jesús ti yʌlʌ: Max tyo ba'an majch mi' ch'ujbin wʌ' bʌ an ti mulawil, yubil. ¿Jayp'ej tyo q'uin wersa yom wʌ' añon quic'otyetla? ¿Jayp'ej tyo q'uin ch'ujbi j cuchbeñetla i tsʌtslel la' pusic'al? Pʌyʌ tyʌlel a walobil wʌ' ba'añon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Che' jini Jesús ti' tiq'ui jini xiba. Ti' choco loq'uel ti' pusic'al alob. Ti saj ora jach ti lajmi jini alob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Che' jini, ajcʌnt'añob i cha'an ti' bajñel pejcʌyob Jesús. Ti yʌlʌyob: ¿Chucoch mach'an ti mejli lojon c choque' loq'uel jini xiba? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús ti yʌlʌ: Cha'an mach'an mi la' ch'ujbin ti jump'ej jach la' pusic'al. Como melel mic subeñetla: Mi muq'uic la' ch'ujbiñon ti jump'ej la' pusic'al aunque ya' ts'itya' jach che' bajche' yoque ts'intyʌl i bʌc' mostaza, ch'ujbi la' suben jini wits cha'an i ch'uye' loq'uel i bʌ wʌ'i cha'an mi majlel ti ochel ti colem ja'. Che' jini ya' mi majlel jini wits. Muq'uic la' ch'ujbin ti jump'ej jach la' pusic'al mach'an chʌ bʌ mach'ʌ ch'ujbi la' cha'len, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero jini xiba tsa' bʌ tyʌc'lʌ jini alob, jin jach ti oración yic'ot ti ch'ajb ch'ujbi i chojquel loq'uel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Che' motin muc'ob ti xʌmbal majlel Jesús yic'ot ajcʌnt'añob i cha'an ya' ti pañimil Galilea bʌ i c'aba' ti queji i subeñob: Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti' c'ʌb quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mi quejel i tsʌnsañoñob. Che' tsa'ix tsʌnsʌntiyon, ti yuxp'ejlel q'uin mi quejel c cha' loq'uel ba'an sajtyemo' bʌ. Che' ti yʌlʌ Jesús. Wen ch'ʌjyem ti yubiyob jini ajcʌnt'añob i cha'an, cha'an jini tsa' bʌ yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Che' ñac Jesús yic'ot ajcʌnt'añob i cha'an ti c'otiyob ya' ti lum Capernaum bʌ i c'aba', jini xch'ʌm tyojoñel cha'an templo ti majliyob i pejcan jini Pedro. Ti yʌlʌ: Ixcu jini la' maestro, ¿mach'a ba'an mi' tyoje' tyojoñel cha'an templo? Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro ti' jac'ʌ: Mu' cu i tyoje', che'en. Che' jini, che' ñac ti ochi Pedro ti otyot che' max tyo ba'an chʌ bʌ ti yʌlʌ, Jesús ti queji i yʌle': ¿Bajche' ma' pensalin, Simón? ¿Majchqui mi yʌq'ueñob tyojoñel jini yumʌlob wʌ' ti mulawil? ¿Jim ba jini año' bʌ ti yotyot? ¿Jim ba yaño' bʌ? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro ti' jac'ʌ: Jini yaño' bʌ, che'en. Jesús ti yʌlʌ: Che' jini, mach i wenta i wersa tyoje' jini am bʌ ti yotyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero cha'an ma'an majch mi' mich'q'uelet ti caj mach'an ti a tyojo, cucu ya' ti colem joyol bʌ ja'. Choco ochel a mʌscap. Jini ñaxan bʌ chʌy mu' bʌ i chuque' a mʌscap, loc'san. Che' ma' cawben i ti' ya' mi quejel a tyaje' junwejch tyaq'uin jasʌl bʌ cha'an ma' tyoje' a tyojoñel yic'ot c cha'an. Ch'ʌmʌ majlel jini tyaq'uin. Tyojo jini tyojoñel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti jin jach bʌ ora jini ajcʌnt'añob i cha'an Jesús ti tyʌli ya' ba'an. Ti yʌlʌ: ¿Majchqui mi q'uejlel ti más ñuc ya' ba' mu' ti yumʌl Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Che' jini Jesús ti' pʌyʌ tyʌlel juntiquil alʌl. Ti yʌc'ʌ ti wa'tyʌl ya' ti xinilob. ");
INSERT INTO ctu76_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ti yʌlʌ: Melelʌch mic subeñetla, mi mach'an mi la' q'uextyan la' pensal cha'an mi la' ju'san la' bʌ che' bajche' alp'eñalob mach ch'ujbi i yumin Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Como jini mu' bʌ q'uejlel ti más ñuc ya' ba' mi' cha'len yumʌl Dios, jiñʌch tsa' bʌ q'uextyʌ i pensal cha'an i ju'san i bʌ cha'an mi yajñel che' bajche' ili alʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jini mu' bʌ i pʌye' ochel juntiquil alʌl che' bajche' jini cha'an mi' ña'tyañon, chʌncox i pʌyon ochel yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Majchical jach mi yʌq'uen i yotsan i mul juntiquil i saj bʌ mu' bʌ i ch'ujbiñon más wen tsʌ'ic cʌjchi ti bic' yic'ot jump'ej ña'tyun cha'an chojquic ochel ti tyam bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wocol ajñel ti mulawil como bej an quixtyañu mu' bʌ i yʌq'uen i yotsañob i mul yaño' bʌ. Pero p'ump'um che' bajche' mi quejel i ñusan wocol jini tsa' bʌ yʌq'ue i yotsan i mul yambʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Mi ti a wotsʌ a mul cha'an ti caj a c'ʌb mi a woc, wa' tsepe loq'uel. Choco ti ñajt. Más wen che' xmol c'ʌbet, xmol oquet ma' tyaj a cuxtyʌlel mach'ʌ yujil jilel che' bajche' mi an cha'ts'ijt a cʌb, cha'ts'ijt a woc ti chojquiyet ochel ti c'ajc mach'ʌ ba'an mi yajpel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Mi ti a wotsʌ a mul ti caj a wut, wa' loc'san. Más wen ma' tyaje' a cuxtyʌlel mach'ʌ yujil jilel che' jump'ej jach a wut che' bajche' mi an cha'p'ej a wut ti chojquiyet ochel ti xot'mulil ti c'ajc, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Mach yom la' q'uel che' bajche' ma'ix i c'ʌjnibal mi junticlec alp'eñal chʌncol bʌ i ch'ujbiñon. Como chʌncol ti cʌñʌtyʌntyel ti ajtroñelob i cha'an bʌ Dios bele' ya' bʌ an ti panchan ya' ba'an c Tyat. ");
INSERT INTO ctu76_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Como Joñon i Pi'ʌl bʌ Quixtyañujob ti tyʌliyon wʌ' ti mulawil cha'an mi cotyan xmulilob. ");
INSERT INTO ctu76_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Bajche' mi la' pensalin? Mi an juntiquil an bʌ cien tiñʌme' pero ti' sʌtyʌ i bijlel juncojt, ¿mach'a ba'an mi quejel i poj cʌye' jini noventa y nueve ya' ti wits cha'an mi majlel i sʌclan jini tsa' bʌ i sʌtyʌ i bijlel? ");
INSERT INTO ctu76_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mi ti' tyaja, melel más tijicña mi yubin cha'an jini juncojt tsa' bʌ i cha' tyaja bajche' jini noventa y nueve mach'ʌ ba'an ti' sʌtyʌ i bijlel. ");
INSERT INTO ctu76_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Che' bajche' lac Tyat am bʌ ti panchan mach yom mi' sʌt i bʌ mi junticlec jini saj alp'eñal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Mi ti' cha'le mulil ti a contra a wermañu, cucu bajñel suben i mul. Mi ti jac'bet a t'an weñʌch mi yujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero mi mach yom i jac'beñet, pʌyʌ majlel juntiquil mi cha'tiquil yaño' bʌ a wic'ot cha'an cha'tiquil mi uxtiquil mi' ña'tyañob jujump'al t'an tsa' bʌ ajli. ");
INSERT INTO ctu76_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mi mach yom i jac'beñob, subeñob ochemo' bʌ ti' t'an Dios. Mi mach yom i jac'beñob jini ochemo' bʌ, la' ajnic che' jini. Yom la' q'uele' che' bajche' ma'ix ochem ti' t'an Dios jini winic, o che' bajche' juntiquil xmulil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Mic subeñetla, jatyetla ajtroñeletla i cha'an Dios wʌ' ti mulawil. Jini mu' bʌ la' wʌq'uen i cha'len quixtyañu wʌ' ti mulawil ch'ujbi i cha'leñob. Chʌ'ʌch Dios je'el mi yʌq'uen i cha'len. Chʌ bʌ jach mach'ʌ ba'an mi la' wʌq'uen i cha'len wʌ' ti mulawil mach yom i cha'len. Chʌ'ʌch Dios je'el mach'an mi yʌq'uen i cha'len, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mic subeñetla je'el. Mi añetla cha'tiquil wʌ' ti mulawil mu' bʌ la' lajal pensalin chʌ bʌ yom mi la' c'ajtiben Dios ti oración, mi quejel la' wʌq'uentyel ti c Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Como ba'ical jach mi' much'quiñob i bʌ cha'tiquil mi uxtiquil mu' bʌ i ch'ujbiñon, yʌ'ʌch añon quic'otyob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Che' jini ti tyʌli Pedro ya' ba'an Jesús. Ti yʌlʌ: C Yum, ¿jayyajlel yom c ñusʌben i mul quermañu che' an chʌ bʌ yes mi' cha'len tij contra? ¿Yom ba c'ʌlʌ siete yajlel mic ñusʌben i mul? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús ti' sube: Mic subeñet, mach jasʌl che' siete yajlel jach. Pero yom c'ʌlʌ setenta yajlel siete, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesús ti' subeyob yambʌ lajoñel. Ti yʌlʌ: Ch'ujbi lac laje' i yumintyel Dios bajche' juntiquil yumʌl tsa' bʌ queji i ña'tyan cha'an mi' wersa tyojob i bet jini ajtroñelob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ti queji i pʌyob tyʌlel jini año' bʌ i bet. Che' jini ti' pʌyʌ tyʌlel juntiquil yajtroñel ñoj on bʌ i bet. Ti mil ti mil pesos an i bet. ");
INSERT INTO ctu76_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero mach'an i tyaq'uin cha'an i tyoje'. Jin cha'an i yum ti' xiq'ui ti chojñel jini winic cha'an mi yajñel ti lolom ajtroñel yic'ot i yijñam yic'ot i yalobilob yic'ot ti pejtyelel chʌ bʌ an i cha'an cha'an i q'uexol i bet. ");
INSERT INTO ctu76_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Che' jini, jini yajtroñel ti ñocle ya' ti yebal yoc i yum. Ti wocol t'an ti yʌlʌ: C yum, pijtyan tyo. Mu' tyo c tyojbeñet ti pejtyelel c bet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jini i yum ti' q'uele ti p'ump'un cha'an yom i cotyan. Ti' ñusʌbe i bet. Ti' colo. ");
INSERT INTO ctu76_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero che' ñac jini tsa' bʌ ñusʌbenti i bet ti loq'ui majlel ya' ba'an i yum, ti ora jach ti' tyaja juntiquil i pi'ʌl ti toñel ts'itya' jach bʌ i bet yic'ot. Ti' chucu ti' bic'. Ti queji i yʌts'e'. Ti yʌlʌ: Tyojbeñon a bet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Che' jini, jini ts'itya' jach bʌ i bet bʌ ajtroñel ti ñocle ya' ti yebal i yoc jini i pi'ʌl ti toñel. Ti wocol t'an ti yʌlʌ: Pijtyan tyo. Mu' tyo c tyojbeñet ti pejtyelel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero jini ajtroñel mach yom i jac'ben i t'an i pi'ʌl ti toñel. Ti yotsʌ ti cʌchol jintyo mi' lu' tyoje' i bet. ");
INSERT INTO ctu76_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Che' ñac jini yambʌ ajtroñelob ti yilʌ chʌ bʌ ti ujti, ch'ʌjyem ti yubiyob cha'an jini i pi'ʌl tsa' bʌ otsʌnti ti cʌchol yic'ot ti queji i mich'q'uelob jini yambʌ. Ti majli i subeñob i yum pejtyelel chʌ bʌ ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Che' jini, i yum ti' cha' pʌyʌ tyʌlel jini tsa' bʌ ñusʌbe i bet. Ti' sube: Simaroñet bʌ ajtroñel. Tic lu' ñusʌbeyet a bet cha'an ti wocol t'an ti a c'ajtibon. ");
INSERT INTO ctu76_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pero jatyet je'el yom a q'uel ti p'ump'un a pi'ʌl ti toñel cha'an ma' ñusʌben i bet che' bajche' tij q'ueleyet ti p'ump'un che' tic ñusʌbet a bet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ti wen mich'ʌ jini i yum. Jin cha'an ti' xiq'ui ti otsʌntyel ti cʌchol jini i yajtroñel jintyo mi' lu' tyoj i bet. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Che' ñac ti ujti i subeñob jini lajoñel Jesús ti yʌlʌ: Jini c Tyat am bʌ ti panchan, chʌ'ʌch mi quejel i cha'leñetla je'el ti jujuntiquil mi mach'an mi la' ñusʌben i mul la' wermañu ti jump'ej la' pusic'al. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Che' ñac ti ujti Jesús i subeñob ili t'an ti loq'ui majlel ti Galilea. Ti majli ya' ti pañimil Judea bʌ i c'aba' ya' ti junxejlel ja' Jordán bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Cabʌl quixtyañu ti' tsʌcleyob majlel. Ya'i ti' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Che' jini cha'tiquil uxtiquil fariseo ti tyʌli ba'an Jesús cha'an jach yom i yilpusic'len Jesús cha'an yom i contrajiñob ti t'an. Jin cha'an ti' c'ajtibeyob: ¿Ch'ujbi ba i cʌy i yijñam winic che' mi yʌq'uentyel i juñilel cha'an tsiquil cʌyʌlix i cha'an cha'an che' jach yom? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús ti' jac'ʌ: ¿Mach'a ba'an ti la' q'uele ti Ts'ijbubil bʌ i T'an Dios cha'an jini tsa' bʌ i mele quixtyañujob ti' mele winic yic'ot x'ixic? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ya' mi yʌle' je'el: Jin cha'an jini winic mi' cʌy i tyat i ña' cha'an mi yajñel yic'ot i yijñam. Che' bajche' juntiquil jach bʌ quixtyañu mi yajñel. ");
INSERT INTO ctu76_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Che' bajche' mach bej cha'tiquilob pero juntiquil jach bʌ quixtyañu yubil. Jin cha'an mach yom i cha' t'oxe' winic jini tsa' bʌ i much'qui Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jini fariseojob ti' sube Jesús: Mi chʌ'ʌch yom, ¿chucoch che' jini ti' xiq'uiyob Moisés winicob cha'an i melben i juñilel ba' mi yʌl cʌyʌlix x'ixic? Che' jini ch'ujbiyix i cʌye', che' ti yʌlʌ Moisés, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús ti' sube: Cha'an tsʌts la' pusic'al jin cha'an ti yʌq'ueyetla Moisés jini t'an cha'an ch'ujbiyic i cʌye' i yijñam winic che' mi yʌq'uen i juñilel. Pero mach che'iqui ti tyejchibal mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pero joñon mic subeñetla mi juntiquil winic mi' cʌy i yijñam cha'an i pʌye' yambʌ x'ixic che' mach cha'anic ti' cha'le i tsuculel yic'ot yambʌ winic jini i yijñam, che' jach chʌncol i cha'len i tsuculel jini winic. Yic'ot majchical jach mi' pʌye' cʌyʌl bʌ x'ixic mi' cha'len i tsuculel je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Che' jini, jini ajcʌnt'añob i cha'an ti queji i subeñob Jesús. Mi chʌ'ʌch wersa yom i yajñel winic yic'ot i yijñam c'o'ojl más wen mach'an mi' pʌye' i yijñam winic, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús ti' jac'ʌ: Mach ti pejtyelel ch'ujbi i yajñel ti i bajñelil. Jini jach jini mu' bʌ yʌq'uentyelob ti Dios i yajñel ti i bajñelil. ");
INSERT INTO ctu76_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","An ti chajp ti chajp chʌ bʌ och mach'an mi' pʌyob i yijñam winicob. An winic mach'ʌ ba'an ts'ʌcʌl i bʌc'tyal ti ch'ocʌyob. An yaño' bʌ ti tsepbentiyob i bʌc'tyal. An yaño' bʌ cha'an yʌlol jach i cha'an mach yom i pʌy i yijñam cha'an mach'an chʌ bʌ mi' mʌctyʌben cha'an ti caj mi yumin Dios am bʌ ti panchan. Jin cha'an majchical jach mach yom i pʌye' i yijñam cha'an ti caj i troñel Dios, weñʌch mi bajñel ajñel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Che' jini, quixtyañujob ti' pʌyʌyob tyʌlel alp'eñalob ya' ba'an Jesús cha'an mi yʌc' i c'ʌb ti' pam i jol yic'ot cha'an mi' tyajob ti oración jini alp'eñalob. Pero jini ajcʌnt'añob i cha'an Jesús ti queji i tic'ob jini tsa' bʌ i pʌyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús ti' subeyob jini ajcʌnt'añob i cha'an: Ac'ʌla tyʌlel ba'añon jini alp'eñalob. Mach la' tic'ob. Como jini mu' bʌ i yumiñob Dios mi yajñel bajche' alp'eñalob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ti yʌc'ʌ i c'ʌb ti' pam i jol alp'eñalob. Che' jini ti loq'ui majlel Jesús ya'i. ");
INSERT INTO ctu76_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Juntiquil colem alob ti majli i pejcan Jesús. Ti yʌlʌ: Weñet bʌ maestro, ¿chuquiyes wen bʌ yom c cha'len cha'an c tyaje' j cuxtyʌlel mach'ʌ yujil jilel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús ti' sube: ¿Chucoch ma pejcañon ti weñon? An jach juntiquil wen bʌ, jiñʌch Dios. Pero mi a wom a tyaje' a cuxtyʌlel mach'ʌ yujil jilel, jac'ben jini mandar tyac, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jini alob ti yʌlʌ: ¿Baqui bʌ mandar tyac? che'en. Jesús ti' sube: Mach a cha'len tsʌnsa, mach a pejcan yambʌ x'ixic, mach a cha'len xujch', mach a jop'ben i mul a pi'ʌl, ");
INSERT INTO ctu76_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ac'ʌ ti ñuc a tyat a ña', p'untyan a pi'ʌlob ti chumtyʌl che' bajche' ma' bajñel p'untyan a bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jini alob ti yʌlʌ: Tsa'ʌch c lu' ch'ujbi ti pejtyelel jini c'ʌlʌ che' ñac alʌlon tyo, che'en. ¿Chutyoqui yambʌ yom c cha'len? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús ti' sube: Mi a wom ts'ʌcʌl bʌ i yutslel a pusic'al, cucu, choño chʌ bʌ yes an a cha'an, aq'ueñob jini p'ump'uño' bʌ. Mi chʌ'ʌch ma' cha'len, mi quejel a wʌq'uentyel cabʌl chʌ bʌ an a cha'an ya' ti panchan. Che' jini, la'. Tsʌcleñon majlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero che' ñac ti yubi ili t'an, ñoj ch'ʌjyem ti cha' sujti jini alob como an cabʌl chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Che' jini Jesús ti' sube ajcʌnt'añob i cha'an: Melel mic subeñetla, ñoj wocol mi yochelob ti yumintyel Dios am bʌ ti panchan jini ricojo' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mic cha' ale': Más wocol mi yochel rico bʌ quixtyañu ti yumintyel Dios bajche' mi ñumel juncojt colem animal camello bʌ i c'aba' ti i ch'ub junts'ijt acuxan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Che' ñac ti yubiyob ili t'an, tyoj bʌc'ñʌjelob jini ajcʌnt'añob i cha'an Jesús. Ti queji i c'ajtibeñob i bʌ: ¿Majchqui ch'ujbi i tyaje' i cotyʌntyel, che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús ti' ch'uj q'ueleyob. Ti' sube: Winicob mach ch'ujbi i cha'leñob. Pero Dios, mach'an mach bʌ ch'ujbi i cha'len, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pedro ti' sube Jesús: C Yum, joñon lojon tsa'ix c lu' cʌyʌ lojon ti pejtyelel chʌ bʌ an lojon c cha'an cha'an lojon c tsʌcleñet majlel. ¿Chuqui mi quejel lojon cʌq'uentyel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús ti yʌlʌ: Melel mic subeñetla, che' ti jim bʌ ora che' mi quejel i tsijibtisʌntyel pejtyel chʌ bʌ an, che' ya' buchulon Joñon i Pi'ʌlon bʌ Quixtyañujob ya' tic buchlib cha'an tsiquil c ñuclel, che' jini jatyetla tsa' bʌ la' tsʌcleyon mi quejel la' cha'len buchtyʌl je'el ya' ti doce la' buchlib tyac cha'an mi la' melob jini docemujch'ob i jiñʌjlel Israel. ");
INSERT INTO ctu76_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ti pejtyelel tsa' bʌ i cʌyʌyob i yotyot, mi yʌscuñob, mi i chichob, mi yijts'iñob, mi i tyat, mi i ña', mi yijñam, mi yalobilob, mi i lumal cha'an ti caj mi yumiñon, mi quejel i yʌq'uentyel yambʌ cien i ñumenlel che' bajche' tsa' bʌ i cʌyʌ. Yic'ot je'el ti tyal tyo bʌ ora mi quejel i yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero cabʌl mach'ʌ ba'an mi q'uejlel ti ñuc wʌ' ti mulawil wale mi quejel i q'uejlel ti ñuc ya' ti panchan. Cabʌl mu' bʌ i q'uejlel ti ñuc wale, mach'an mi quejel i q'uejlel ti ñuc che' mi' cha'len yumʌl Dios, che' mi quejel i lu' tsijibtisʌntyel pejtyelel chʌ bʌ an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús ti' subeyob yambʌ lajoñel. Ti yʌlʌ: Ch'ujbi lac laje' bajche' mi' cha'len yumʌl Dios yic'ot bajche' mi' cha'len yumʌl juntiquil i yum ts'ujsubol. Ti wen sʌc'an ti majli i sʌclan ajtroñelob cha'an i tyuc'ob ts'ujsub. ");
INSERT INTO ctu76_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ti' lajayob i t'an cha'an mi' tyojob jump'ej tyaq'uin denario bʌ i c'aba' ti jujump'ej q'uin. Che' jini ti' chocoyob majlel ti toñel ti ts'ujsubol. ");
INSERT INTO ctu76_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Che' bajche' ti las nueve ti cha' majli i yum ts'ujsubol ya' ba' mi' much'quiñob i bʌ winicob mach'ʌ ba'añob i toñel. Ya' ti c'oti i tyaj cha'tiquil uxtiquil mach'ʌ ba'an i toñel. ");
INSERT INTO ctu76_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ti' subeyob: Cucula je'el ti tyuc' ts'ujsub. Mux c tyojetla bajche' yom cha'an la' toñel, che'en. Ti majliyob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jini i yum ti cha' majli i suben yambʌ mach'ʌ ba'añobix i toñel ti xinq'uinil yic'ot ti las tres ti och an q'uin. Lajal ti' subeyob bajche' ti subenti jini tsa' bʌ i xiq'ui majlel ti toñel ti las nueve. ");
INSERT INTO ctu76_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yic'ot ti las cinco ti och an q'uin ti cha' majli ya' ba' mi' much'quiñob i bʌ jini mach'ʌ ba'añob i toñel. Ya' ti c'oti i tyaj yambʌ cha'tiquil uxtiquil mach'ʌ ba'añob i troñel. Ti' subeyob: ¿Chucoch wʌ tyo wa'aletla c'ʌlʌ mi ñumel q'uin? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ti' jac'ʌyob: Cha'an ma' majch ti' subeyon lojon toñel, che'ob. Che' jini, jini i yum ts'ujsubol ti' subeyob: Cucula je'el ti toñel ya' tic ts'ujsubol. Muq'uix c tyojetla bajche' yom cha'an la' troñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Che' iq'uixi i yum ts'ujsubol ti' sube jini ajcʌñʌtya troñel: Pʌyʌla tyʌlel jini ajtroñelob. Aq'ueñobix i tyojol. Ma' ñaxan tyoje' jini wi'ilix bʌ ti c'otiyob. Ti wi'il ma' tyoje' jini ñaxan bʌ ti c'otiyob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Che' jini, ti tyʌliyob jini tsa' bʌ quejiyob ti troñel ti las cinco ti och an q'uin. Ti aq'uentiyob jujuntiquil jump'ej denario, jiñʌch i tyojol jump'ej q'uin toñel. ");
INSERT INTO ctu76_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ti wi'il tyo che' ñac ti tyʌliyob i ch'ʌm i tyojol jini tsa' bʌ ñaxan quejiyob ti troñel c'ʌlʌ ti sʌc'ʌ, ti' lolon ña'tyʌyob cha'an más on mi quejel i yʌq'uentyelob. Pero ti aq'uentiyob jujump'ej denario i tyojol ti jujuntiquil je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Che' ñac ti' ch'ʌmʌyob i tyojol ti quejiyob i mich'an. Ti queji i tyaje' ti t'an jini i yum ts'ujsubol. ");
INSERT INTO ctu76_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ti yʌlʌyob: Jini wi'ilobix ti juli ti' cha'leyob troñel jump'ej jach ora. Junlajal ti a wʌq'ueyob i tyojol che' bajche' ti a tyojoyon lojon tsa' bʌ lojon c cha'le wersa bʌ toñel. Ti lojon j cuchu ticwal c'ʌlʌ ti ñumi q'uin, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jini i yum ts'ujsubol ti' sube juntiquil: C pi'ʌl, mach'an chʌ bʌ tic cha'le ti a contra. ¿Mach'a ba'an ti lac laja lac t'an cha'an mi cʌq'ueñet jump'ej denario cha'an jump'ej q'uin toñel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ch'ʌmʌ a tyojol. Cucux. Com c tyoje' jini wi'ilix bʌ ti c'otiyob lajal bajche' mic tyojetla. ");
INSERT INTO ctu76_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Mach'a ch'ujbi c cha'len chʌ bʌ jach com yic'ot c bajñel tyaq'uin? ¿Jim ba jini wen bʌ tsa' bʌ c cha'le ti' tyejchbe i mich'lel la' pusic'al yic'ot la' pi'ʌlob ti troñel cha'an jach la' wom chʌ bʌ niq'ui an i cha'an? Che' ti yʌlʌ i yum ts'ujsubol. ");
INSERT INTO ctu76_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesús ti yʌlʌ: Che' bajche' jini, an mach'ʌ ba'an mi q'uejlel ti ñuc wʌ' ti mulawil mi quejel i q'uejlel ti ñuc ya' ba' mu' ti yumʌl Dios. An jini mu' bʌ i q'uejlel ti ñuc wʌ' ti mulawil mach'an mi quejel i q'uejlel ti ñuc ya' ba' mu' ti yumʌl Dios. Como an cabʌl pʌyʌlo' bʌ cha'an mi yochel ya' ba' mu' ti yumʌl Dios, pero mach'an cabʌlob yajcʌbilo' bʌ ti Dios cha'an mi yochelob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Che' ñac mu' ti xʌmbal majlel Jesús ti bijlel Jerusalén an chʌ bʌ ti queji i bajñel subeñob ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ti yʌlʌ: Che' bajche' mi la' wilan chʌncol lac letsel majlel ya' ti Jerusalén. Ya'i Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti' c'ʌb ñuco' bʌ curajob yic'ot jini yambʌ ajcʌntisajob cha'an i mandar israelob. Mi quejel i meloñob cha'an i yʌc'on ti sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mi quejel i yʌc'on ti' c'ʌb jini mach'ʌ israelo' bʌ quixtyañujob cha'an i wajleñoñob, cha'an i jats'oñob, cha'an i yʌc'on ti sajtyel ti cruz. Pero ti yuxp'ejlel q'uin mi quejel c tyejchel loq'uel ya' ba'an sajtyemo' bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Che' jini, i yijñam Zebedeo ti c'oti ba'an Jesús yic'ot cha'tiquil i yalobilob, jiñʌch Jacobo yic'ot Juan. Ti ñocle ti yebal yoc Jesús cha'an an chʌ bʌ yom i c'ajtiben. ");
INSERT INTO ctu76_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús ti yʌlʌ: ¿Chuquiyes a wom? che'en. Jini i ña' Jacobo yic'ot Juan ti' jac'ʌ: Ac'ʌ a t'an cha'an mi buchtyʌlob jini cha'tiquil calobilob juntiquil ti a ñoj, juntiquil ti a ts'ej che' mi quejel a cha'len yumʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús ti' subeyob: Mach'an mi la' ña'tyan chʌ bʌ yes chʌncol la' c'ajtin. ¿Ch'ujbi ba la' ñusan jini wocol mu' bʌ quejel c ñusan? como ñoj cʌlʌx bʌ wocol mi quejel c ñusan, che'en. Ti' jac'ʌyob: Ch'ujbiyʌch, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús ti' subeyob: Melelʌch mi quejel la' ñusan ñoj cʌlʌx bʌ wocol mu' bʌ c ñusan. Pero mach c wenta cʌle' majchqui mi quejel i buchtyʌl tic ñoj yic'ot tic ts'ej. Ya'i mi quejel i buchtyʌlob jini tsa' bʌ chajpʌntiyob tic Tyat am bʌ ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Che' ñac ti yubiyob ili t'an jini yaño' bʌ diez ti queji i mich'q'uelob Jacobo yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús ti' pʌyʌyob tyʌlel jini docejob. Ti' subeyob: La' wujil bajche' mi' pʌsob i bʌ ti ñuc jini yumʌlob wʌ' ti mulawil. Yic'ot jini am bʌ i ye'tyel ti' tyojlel más ñuc bʌ yumʌlob, ñoj tsʌts mi' xic'ob quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero jatyetla mach che'ic yom mi la' cha'len. Pero jini yom bʌ ajñel ti ñuc ti la' tyojlel la' i cha'len cotyaj ti tyojlel i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pero majchical jach yom ajñel ti jini más ñuc bʌ yom i yotsan i bʌ che' bajche' lolom ajtroñel jach la' cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chʌ'ʌch joñon je'el i Pi'ʌlon bʌ Quixtyañujob ma' ti tyʌliyon ti mulawil cha'an mic tyaj j cotyʌntyel ti quixtyañujob. Pero ti tyʌliyon cha'an mij cotyañob, cha'an mi cʌc' c bʌ ti sajtyel cha'an i loq'uib ti mulil cabʌlob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Che' ñac chʌncol i loq'uelob majlel ya' ti lum Jericó bʌ i c'aba', cabʌl quixtyañu ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ya'an cha'tiquil muts'ul bʌ i wut buchulob ti i ti' bij. Che' ñac ti subentiyob cha'an chʌncol i ñumel majlel Jesús ti quejiyob ti c'am bʌ t'an. Ti yʌlʌyob: C Yum, i jiñʌjlelet bʌ David tsa' bʌ i choco tyʌlel Dios, p'untyañon lojon cha'an ma' cotyañon lojon, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jini quixtyañujob ti' tiq'uiyob cha'an mi' lajmelob ti t'an. Pero más c'am ti quejiyob ti t'an. Ti yʌlʌyob: C Yum, i jiñʌjlelet bʌ David tsa' bʌ i choco tyʌlel Dios, p'untyañon lojon cha'an ma' cotyañon lojon, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Che' jini Jesús ti' cʌyʌ xʌmbal. Ti' pʌyʌ tyʌlel jini muts'ulo' bʌ i wut. Ti' c'ajtibeyob: ¿Chuquiyes a wom mic melbeñetla? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ti' jac'ʌyob: C Yum, com lojon cha'an mi c'otyel lojon c wut, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Che' jini, Jesús ti' p'untyʌyob. Ti' tyʌlbeyob i wut. Ti jin jach bʌ ora ti wa' c'oti i wut. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Che' ñac lʌc'ʌlix añob ti Jerusalén ya' ti c'otiyob ti lum Betfagé bʌ i c'aba' ya' ti lʌc'ʌlel wits Olivajol bʌ i c'aba'. Che' jini Jesús ti' xiq'ui majlel cha'tiquil ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ti' subeyob jini cha'tiquil: Cucula ya' ti jini lum ya' ti' tyojel la' wut. Ya'i mi quejel la' tyaje' cot cʌchʌl juncojt burra. Ya'an yic'ot i yal. Tiquila. Pʌyʌla tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi an majch chʌ bʌ mi' subeñetla cha'an chʌncol la' tique' yom la' subeñob: Yom i c'ʌñe' lojon c yum. Mu' tyo lojon c wa' cha' pʌye' tyʌlel, che'etla, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Chʌ'ʌch ti ujti cha'an mi ts'ʌctiyel jini tsa' bʌ ajli ti Dios ti ñoj oniyix che' ñac ti' c'ʌñʌ i ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ma' subeñob jini quixtyañujob ya' ti lum Sión bʌ i c'aba': Q'uelela chʌncol i tyʌlel wʌ' ba' añetla ñuc bʌ yumʌl la' cha'an. Pec' mi' mel i bʌ. C'ʌchʌl ti burro mi tyʌlel. Jiñʌch saj burro, i yal jini yujil bʌ cuchejel. Che' mi yʌle' ti Ts'ijbubil bʌ i T'an Dios, che'en Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Che' jini, jini ajcʌnt'añob i cha'an Jesús ti majliyob. Ti' cha'leyob bajche' ti subentiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ti' pʌyʌyob tyʌlel jini ña' burra yic'ot i yal ya' ba'an Jesús. Ti' tyasibeyob i pat i yal burro ti i pislelob. Jesús ti' c'ʌchtyʌ majlel jini burro. ");
INSERT INTO ctu76_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ya'an cabʌl quixtyañu. Ti' tyʌsbeyob majlel i pislelob ya' ti bij. Yaño' bʌ ti' tsepeyob jubel i c'ʌb tyac tye'. Ti' lin ac'ʌyob majlel yopol tye' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jini ñaxaño' bʌ majlelob bʌ quixtyañujob yic'ot jini chʌncol bʌ i tyʌlelob ti' pat Jesús c'am ti' cha'leyob t'an. Ti yʌlʌyob: La' sujbic a ñuclel i jiñʌjlelet bʌ ñuc bʌ yumʌl David. Tijicñayet jatyet chʌncol bʌ a tyʌlel cha'an che' yom lac Yum Dios. La' sujbic i ñuclel Dios. Che' ti yʌlʌyob ti c'am bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Che' ñac ti ochi ti Jerusalén Jesús, lu' muc'ob ti t'an quixtyañujob. Lu' yom i q'uelob. Cabʌlob ti queji i yʌlob: ¿Majchqui jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","An tsa' bʌ i jac'ʌyob: Jiñʌch Jesús, juntiquil tsa' bʌ i xiq'ui yʌle' Dios, ch'oyol bʌ ti Nazaret ya' ti pañimil Galilea bʌ i c'aba', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Che' jini, Jesús ti ochi ya' ti templo ba' mi' ch'ujutisañob Dios. Ya' ti pat templo an cabʌl mu' bʌ i mʌn mu' bʌ i chon animal tyac. Ti' lu' chocoyob loq'uel. Ti' ch'a' chocbeyob i mesa tyac jini ajq'uex tyaq'uiñob yic'ot i buchlib tyac jini mu' bʌ i choñob x'ujcutsu'. ");
INSERT INTO ctu76_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ti' subeyob: Ya' ti Ts'ijbubil bʌ i T'an Dios mi yʌle': Jini cotyot mi quejel i pejcʌntyel ti yotyotlel oración, che'en. Pero jatyetla tsa'ix la' sutqui ti yotyotlel ajxujch'ob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ti c'otyiyob jini muts'ulo' bʌ i wut yic'ot jini mach'ʌ ba'an i c'ʌjnibal i yoc i c'ʌb ya' ba'an Jesús ya' ti templo. Jesús ti' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob, ti quejiyob ti mich'an che' ñac ti yilʌ i señʌjlel ñuc tyac bʌ i p'ʌtyʌlel Jesús yic'ot che' ñac ti yubiyob i t'an alp'eñalob ya' ti templo che' ti c'am bʌ t'an ti yʌlʌyob: La' sujbic a ñuclel, i jiñʌjlelet bʌ ñuc bʌ yumʌl David tsa' bʌ i choco tyʌlel Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ti' c'ajtibeyob Jesús: ¿Chʌncol ba a wubin chʌ bʌ chʌncol i yʌlob alp'eñalob? che'ob. Jesús ti' jac'ʌ: Chʌncol cubin. ¿Mach'a ba'an ti la' q'uele ti Ts'ijbubil bʌ i T'an Dios ba' mi' wʌ tyaje' ti t'an bajche' mi' sub i ñuclel Dios alp'eñalob. Mi yʌle': Tsa'ix cʌq'ue cha'an jinic tyo saj alp'eñalob yic'ot jini mu' tyo bʌ ti chu' mi' sub i ñuclel Dios. Chʌ'ʌch ts'ijbubil ti' t'an Dios, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Che' jini Jesús ti' cʌyʌyob. Ti loq'ui majlel ti Jerusalén. Ti majli ya' ti saj lum Betania bʌ i c'aba' ba' ti' ñusʌ ac'bʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ti yijc'ʌlel che' ñac chʌncol i sujtyel majlel ti Jerusalén, Jesús ti yubi wi'ñal. ");
INSERT INTO ctu76_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ya' ti i ti' bij ti yilʌ juntyejc tye' higuera bʌ i c'aba'. Pero che' ñac ti' lʌc'ʌ jini tye' mach'an ti saj tyajbe i wut. I yopol jach an. Che' jini Jesús ti' sube cha'an ma'ix ba' bʌ ora mi quejel i cha' ac' i wut. Ti jini jach bʌ ora ti wa' queji i tyʌquin jini tye'. ");
INSERT INTO ctu76_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tyoj bʌc'ñʌjel ajcʌnt'añob i cha'an che' ñac ti yilʌ bajche' ti ujti. Ti' c'ajtibeyob Jesús: ¿Bajche'qui isujm che' saj ora jach ti tyʌqui jini tye'? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús ti' subeyob: Melel mic subeñetla mi muc'ʌch la' ch'ujbin ti jump'ej jach la' pusic'al cha'an chʌ'ʌch mi quejel i yujtyel, mi ma'an cha'p'ej la' pensal, mach jinic jach ch'ujbi la' cha'len bajche' ti la' wilʌ ti ujti yic'ot jini tye', pero ch'ujbi la' suben jini wits je'el cha'an i ch'uye' loq'uel i bʌ wʌ'wʌ'i, cha'an mi majlel ti ochel ya' ti colem ja'. Mi muq'uic la' ch'ujbin chʌ'ʌch mi quejel i yujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Mi muq'uic la' ch'ujbin ti jump'ej la' pusic'al mi quejel la' wʌq'uentyel chʌ bʌ jach yes mi la' c'ajtin ti oración. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ti ochi ti templo Jesús. Che' mu' tyo ti cʌntisa ya' ti c'otiyob jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel cha'an israelob. Ti yʌlʌyob: ¿Baqui tyʌlem a we'tyel cha'an ma' niq'ui cha'len jini mu' ba a cha'len? ¿Majchqui ti yʌq'uet ili a we'tyel cha'an ma' niq'ui mele'? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús ti' jac'ʌ: Joñon je'el an chʌ bʌ com j c'ajtibeñetla. Mi ti la' jac'ʌ, che' jini mi quejel c subeñetla baqui tyʌlem que'tyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Majchqui ti' xiq'ui jini Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja'? ¿Jim ba Dios o jim ba quixtyañujob? Che' ti yʌlʌ Jesús. Che' jini ti queji i bajñel subeñob i bʌ: ¿Bajche'qui yom mi lac jaq'ue'? Mi ti la cʌlʌ Dios ti xiq'ui mi quejel i cha' c'ajtibeñonla, ¿chucoch mach'an ti la' ch'ujbi? Che' mi quejel i yʌle', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Pero mi ti la cʌlʌ winicob ti' xiq'ui, cho'onla, mux lac bʌc'ñan quixtyañujob como mi' lu' ña'tyañob jini Juan jiñʌch juntiquil tsa' bʌ i xiq'ui yʌle' Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Che' jini ti' subeyob Jesús: Mach cujil lojon isujm majchqui ti' xiq'ui cha'an i yʌq'ue' ch'ʌm ja' jini Juan, che'ob. Che' jini Jesús ti' subeyob: Chʌ'ʌch joñon je'el, mach'an mic subeñetla baqui ch'oyol i p'ʌtyʌlel c t'an cha'an mic cha'len ili tyac. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús ti' bej cha'le t'an. Ti yʌlʌ: ¿Bajche' mi la' pensalin jini mu' bʌ c subeñetla? An juntiquil winic an cha'tiquil alo' bʌ i yalobilob. Ti' sube juntiquil: Calobil, cucu ya' ti toñel tic ts'ujsubol che' mi ñumel ili q'uin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pero jini alob ti' jac'ʌ: Mach com c majlel, che'en. Pero ti wi'il ti' q'uextyʌ i pensal. Ti majli ti toñel bajche' ti subenti. ");
INSERT INTO ctu76_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ti ñumi ts'itya' ora jini winic ti majli ya' ba'an yambʌ i yalobil. Ti' xiq'ui majlel ti toñel je'el. Jini cha'ticlel bʌ i yalobil ti' jac'ʌ: Muc'ʌch quejel c majlel, c tyat, che'en. Pero mach'an ti majli. ");
INSERT INTO ctu76_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Che' jini, ti jini cha'tiquil bʌ, ¿majchqui ti yoque cha'le bajche' yom i tyat? ¿Jim ba jini ñaxan bʌ? ¿Jim ba jini wi'ilix bʌ? che'en Jesús. Ti' jac'ʌyob: Jini ñaxan bʌ, che'ob. Che' jini Jesús ti' subeyob: Melel mic subeñetla cha'an jini xlot bʌ xch'ʌm tyojoñel yic'ot x'ixicob mu' bʌ i choñob i bʌ mi quejel i yumiñob Dios che' mach'an mi la' yumin Dios jatyetla. ");
INSERT INTO ctu76_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Como jini Juan tsa' bʌ yʌc'ʌ ch'ʌm ja' ti tyʌli i cʌntisañetla bajche' yom mi la' wajñel ti tyoj. Pero mach'an ti la' ch'ujbi cha'an melel i t'an. Pero jini xlot bʌ xch'ʌm tyojoñelob yic'ot x'ixicob mu' bʌ i choñob i bʌ ti' ch'ujbiyob. Pero jatyetla aunque ti la' wilʌ bajche' ti' q'uextyʌyob i pensal, mach'an ti la' q'uextyʌ la' pensal la' cʌye' la' mul cha'an la' ch'ujbin i t'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús ti' subeyob: Ñʌch'tyanla jini yambʌ lajoñel. An juntiquil i yum otyot ti yʌc'ʌ ti pʌc'ol jumpejt ts'ujsubol. Ti' joy corrajli. Ti' chajpʌ i yajñib ba' mi' pets'beñob loq'uel i ya'lel. Ti' ts'ʌpʌ chan bʌ i q'ueloñib, jiñʌch chan bʌ wa'lib cha'an i q'uintyan pañimil. Ti yʌc'ʌ ti majñʌntyel jini jumpejt ts'ujsubol. Che' jini ti majli ti ñajt bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Che' ti yorojlel i tyuc'ob ts'ujsub ti' choco majlel i yajtoñel ya' ba'an jini ajcʌñʌtya ts'ujsubol cha'an mi' t'ox ch'ʌmben i wut bajche' ti wʌ alʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero jini ajcʌñʌtya ts'ujsubol ti' chucuyob jini ajtoñelob. Ti' jats'ʌ juntiquil, ti' tsʌnsʌ yambʌ, ti' julu ti tyun yambʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jini i yum ts'ujsubol ti' cha' choco majlel yambʌ ajtroñelob. Pero más onix ti' choco majlel che' bajche' ti ñaxan. Pero jini ajcʌñʌtya ts'ujsubol lajal ti' tyʌc'lʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ti wi'il ti' xiq'ui majlel i yalobil como ti' pensali: Muc'ʌch i wersa q'uelob ti ñuc calobil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero che' ñac jini ajcʌñʌtya ts'ujsubol ti yilʌyob jini i yalobil i yum ts'ujsubol ti' subuyob i bʌ: Jiñʌch mu' bʌ i quejel i yochel ti yum jini ts'ujsubol. La' lac tsʌnsan. Che' jini mi quejel lac ch'ʌme' ili ts'ujsubol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Chʌ'ʌch ti' chucuyob. Ti' loc'sʌyob ti ts'ujsubol. Ti' tsʌnsʌyob. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Che' jini Jesús ti' c'ajtibeyob jini ñuc bʌ curajob yic'ot jini xñoxob año' bʌ i ye'tyel ba'an israelob: ¿Che' mi tyʌlel jini i yum ts'ujsubol chuquiyes mi quejel i tyumben jini ajcʌñʌtya ts'ujsubol mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ti' jac'ʌyob: Mi quejel i tsʌnsañob jini simaron bʌ ajcʌñʌtya ts'ujsubol. Ma'ix mi quejel i saj p'untyʌntyel. Che' jini mi quejel i yʌq'uen jini ts'ujsubol ti majñʌntyel yaño' bʌ ajcʌñʌtya ts'ujsubol mu' bʌ quejel i t'ox aq'uen i wut che' ti yorojlel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesús ti' subeyob: ¿Mach'a ba'an ti la' q'uele jini Ts'ijbubil bʌ i T'an Dios? An ba' mi yʌl: Jini tyun tsa' bʌ i chocoyob jini ajmel tyun bʌ otyot ti ochi ti' wentyʌlel oy ti xujc' otyot. Jiñʌch i cha'libal lac Yum. Tyoj bʌc'ñʌjel mi laj q'uele' jini tsa' bʌ i cha'le. Chʌ'ʌch an ti Ts'ijbubil bʌ i T'an Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jesús ti' bej pejcʌyob jini ñuc bʌ curajob yic'ot jini xñoxob ano' bʌ ye'tyel. Ti' subeyob: Jin cha'an mic subeñetla: Ma' mi quejel la' bej aq'uentyel la' cʌñʌtyan i t'an Dios jatyetla israelet bʌ la. Pero mi quejel i yʌq'uentyelob jini mu' bʌ i ch'ujbiben bajche' ts'ijbubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yic'ot cha'an jini tyun ujtyel bʌ cʌle', majchical jach mi yajlel ti pam jini tyun mi quejel i bic'tiyel. Pero mi jini tyun mi yajlel ti pam quixtyañu mi quejel i juch'e' bajche' ts'ubejn. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Che' ñac ti yubiyob jini lajoñel tyac, jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ti' ña'tyʌyob cha'an chʌncol i tyajtyʌlob ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Yomob i chuc Jesús cha'an mi yotsan ti cʌchol pero ti' bʌc'ñʌyob ame mi mich'añob quixtyañujob. Como jini quixtyañujob ti' ña'tyʌyob cha'an Jesús jiñʌch juntiquil tsa' bʌ xiq'ui yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ti queji i suben quixtyañujob yambʌ lajoñel. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ch'ujbi lac laje' i yumintyel Dios yic'ot juntiquil ñuc bʌ yumʌl tsa' bʌ i mele i q'uiñejel ñujpuñel cha'an alo' bʌ i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ti' xiq'ui majlel ajtroñelob i cha'an cha'an mi majlel i pʌyob tyʌlel pejtyelel tsa' bʌ wʌ subeyob tyʌlel. Pero mach yomobix tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Che' jini ti' xiq'ui majlel yambʌ ajtroñelob. Ti yʌlʌ: Subeñob jini tsa' bʌ wʌ subentiyob tyʌlel cha'an tsa'ix c chajpʌ uch'el. Tsa'ix c xiq'ui ti tsʌnsʌntyel tyat wacax yic'ot jujp'em bʌ alʌq'uil. Lu' chajpʌbilix. Yom tyʌlicob cha'an mi lac mele' i q'uiñejel ñujpuñel, che'etla ma' subeñob, che'en jini ñuc bʌ yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero mach'an ti' jac'ʌyob jini tsa' bʌ wʌ subentiyob. Juntiquil ti majli ya' ti' chol, yambʌ ti majli ti choñoñel. ");
INSERT INTO ctu76_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yaño' bʌ ti' chucuyob jini ajtroñelob tsa' bʌ xiq'ui majlel jini ñuc bʌ yumʌl. Ti' wen tyʌc'lʌyob jinic tyo ti' tsʌnsʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Che' jini, ti wen mich'ʌ jini ñuc bʌ yumʌl. Ti' xiq'ui majlel soldadojob cha'an i tsʌnsañob jini ajtsʌnsajob yic'ot cha'an i pulbeñob i lum. ");
INSERT INTO ctu76_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Che' jini, jini ñuc bʌ yumʌl ti' sube jini ajtroñelob: Lu' chajpʌbil i q'uiñejel ñujpuñel pero mach saj weñob cha'an mi tyʌlelob jini wʌ subebilobix bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cucu ya' ti colem bij tyac. Subenla tyʌlel majchical jach mi la' tyaj ya' ti bij, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jini ajtroñelob ti majliyob ya' ti colem bij tyac. Ti' pʌyʌyob majlel ti' q'uiñejel ñujpuñel ti pejtyelelob tsa' bʌ i tyajayob, mi simaroño' bʌ mi utso' bʌ. Chʌ'ʌch ti lu' bujt'i i yotyot jini ñuc bʌ yumʌl chʌncol bʌ i mele' q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Che' jini ti ochi ñuc bʌ yumʌl i q'uel jini pʌyʌlob bʌ ti q'uin. Ti' q'uele ya' an juntiquil winic mach'ʌ ba'an xojol bʌ i bujc che' bajche' i tyʌlel ti' xojoyob che' yorojlel q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ti' sube: Pi'ʌl, ¿bajche'qui isujm ti ochiyet wʌ'i che' mach'an xojol a cha'an a bujc che' bajche' i tyʌlel mi' xojob che' chʌncol q'uiñejel? che'en. Pero mach'an ti' jac'ʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Che' jini, jini ñuc bʌ yumʌl ti' sube yajtroñelob chʌncol bʌ i ñusan waj ya' ti mesa tyac: Cʌchʌla ti yoc ti' c'ʌb. Chocola ya' ba' ic'jowan, ba' mi quejel ti uq'uel yic'ot tsʌts mi quejel i c'uxob i yej cha'an ti' c'uxel, che'en. Chʌ'ʌch ti yʌlʌ ti lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ti yʌlʌ je'el: Che' bajche' an cabʌl pʌyʌlo' bʌ cha'an mi yochelob ya' ba' mu' ti yumʌl Dios pero mach'an cabʌl yajcʌbilob ti Dios cha'an mi yochelob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ti majli fariseojob. Ti' lajayob i t'an cha'an i jop' i yʌq'uen i yʌle' Jesús chʌ bʌ jach bʌ t'an ch'ujbi bʌ i contrajiñob cha'an i yʌc' ti melol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Che' jini, jini fariseojob ti' choco majlel cha'tiquil uxtiquil i pi'ʌlob yic'ot cha'tiquil uxtiquil loq'uemo' bʌ ti junmujch' quixtyañu herodianojo' bʌ i c'aba' cha'an mi motin majlelob i pejcan Jesús. Ti' subeyob: Maestro, cujil lojon isujm cha'an melelʌch chʌ bʌ ma' wʌle' yic'ot tyojʌch ma' cʌntisan quixtyañu i t'an Dios ti ñoj melel bʌ t'an. Ma' majch ma' bʌc'ñan. Junlajal jach ma' q'uel winicob mi an i ye'tyel mi ma'an i ye'tyel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jin cha'an subeñon lojon: ¿Bajche' ma' wʌl? ¿Yom ba mi la cʌq'uen tyojoñel ñoj ñuc bʌ yumʌl, o mach yom? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús yujil isujm cha'an yom jach i jop'ben i mul. Ti' subeyob: Cha'chajp la' pensal. ¿Chucoch mi la' jop' la' wʌc'on ti melojel? ");
INSERT INTO ctu76_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Pʌs'eñon jini tyaq'uin mu' bʌ la' c'ʌn la' tyoje' tyojoñel, che'en. Che' jini ti' ch'ʌmʌ tyʌlel junwejch tyaq'uin denario bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Che' ñac ti' q'uele Jesús jini tyaq'uin ti' c'ajtibeyob: ¿Majchqui i loc'om wʌ' bʌ an ti tyaq'uin? ¿Majchqui i c'aba' wʌ' ts'ijbubil? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ti' jac'ʌyob: I cha'an jini ñoj ñuc bʌ yumʌl, che'ob. Che' jini Jesús ti' subeyob: Aq'uenla ñoj ñuc bʌ yumʌl i cha'an bʌ yumʌl, aq'uenla Dios i cha'an bʌ Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Che' ñac ti yubi bajche' ti' jac'ʌ Jesús, tyoj bʌc'ñʌjel ti yubiyob. Ma' chʌ bʌ yambʌ ti yʌlʌyob. Ti cha' sujtiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti jin jach bʌ q'uin ti c'otiyob cha'tiquil uxtiquil saduceo ya' ba'an Jesús. Jiñʌch mu' bʌ i yʌlob cha'an mach'an mi lac cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Ti' subeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, Moisés ti' cʌybeyonla ts'ijbubil bʌ mandar cha'an bajche' mi' cha'len mi ti sajti juntiquil winic mi ti bajñel cʌyle i yijñam che' max tyo ba'an i yalobil. Ti yʌlʌ yom i wersa pʌyben i yijñam i yʌscun jini ijts'iñʌl bʌ cha'an i yalobil mi' tyejchben i jiñʌjlel jini tsa' bʌ sajti. Che' ti yʌlʌ Moisés, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Che' jini, wʌ' ba'añonla an siete winicob yoque i yijts'iñob i bʌ. Ti' pʌyʌ i yijñam jini ascuñʌl bʌ. Ti sajti. Cha'an ma' ti' cʌyʌ yalobil, jini ijts'iñʌl bʌ ti' pʌybe i yijñam i yʌscun. ");
INSERT INTO ctu76_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chʌ'ʌch ti lu' ujti. Ti sajti jini cha'ticlel bʌ yic'ot uxticlel c'ʌlʌ jintyo ti sajti sietyejlel hermano. ");
INSERT INTO ctu76_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ti wi'il che' tsa'ix sajti ti sietejlel ti sajti je'el jini x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Che' jini, ti yorojlel i cha' tyejchelob jini sajtyemo' bʌ, ¿majchqui i ñoxi'al jini x'ixic mi a wʌl como ti sietejlelob ti' pʌyʌyob cha'an i yijñam? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús ti' subeyob: An la' ñajayel tyac como mach'an mi la' ch'ʌmben isujm jini Ts'ijbubil bʌ i T'an Dios, mi i p'ʌtyʌlelic Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Como che' mi' cha' tyejchelob loq'uel ba'an sajtyemo' bʌ, ma'ix mi' pʌyob i yijñamob, ma'ix mi' sijintyelob je'el. Mi quejel i yajñelob che' bajche' mi yajñel ajtroñelob i cha'an Dios ya' bʌ añob ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jiñʌch i sujmlel cha'an melelʌch mi cha' tyejchel sajtyemo' bʌ. ¿Mach'a ba'an q'uelel la' cha'an tsa' bʌ i sube Dios lac pi'ʌlob israelo' bʌ? Dios ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Joñon i Dioson Abraham, i Dioson Isaac, i Dioson Jacob, che'en. Dios mach i Diosic sajtyemo' bʌ. I Diosʌch jini cuxulo' bʌ. Che' ti yʌlʌ Jesús. Como aunque sajtyem i bʌc'tyal pero cuxul i ch'ujlel. ");
INSERT INTO ctu76_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Che' ñac ti yubiyob bajche' ti' jac'ʌ Jesús, tyoj bʌc'ñʌjelob quixtyañu cha'an i cʌntisa. ");
INSERT INTO ctu76_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Che' ñac jini fariseojob ti yubi bajche' ti' ñʌch'choco Jesús jini saduceojob, ti' much'quiyob i bʌ cha'an i pensalin chʌ bʌ mi' cha'leñob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Juntiquil ajcʌntisa cha'an mandar ti queji i pejcan Jesús cha'an jach yom i yilpusic'len cha'an yom i contrajin ti' t'an. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ¿baqui bʌ más ñuc ti pejtyelel mandar tyac? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús ti' jac'ʌ: P'untyan la' Yum la' Dios ti pejtyelel la' pusic'al, ti pejtyelel la' ch'ujlel yic'ot ti pejtyelel la' ña'tyʌbal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jiñʌch jini más ñuc bʌ mandar. ");
INSERT INTO ctu76_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Lʌc'ʌl lajal bʌ yic'ot cha'p'ejlel mandar. Mi yʌl: P'untyan a pi'ʌlob ti chumtyʌl lajal bajche' mi a bajñel p'untyan la' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Cha'an ti jini cha'p'ej mandar ti mejli ti pejtyelel i mandar tyac Moisés yic'ot i cʌntisa tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Che' ñac ya' tyo much'quibilob fariseojob Jesús ti' c'ajtibeyob: ");
INSERT INTO ctu76_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Bajche' mi la' wʌle' jatyetla? ¿Majchqui jini Cristo? che'en. Ti' jac'ʌyob: Cristo i jiñʌjlelʌch David, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Che' jini Jesús ti' subeyob: ¿Bajche' isujm che' Ch'ujul bʌ i Ch'ujlel Dios ti yʌq'ue i yʌle' David Cristo ti yumʌl i cha'an? Como David ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Jini lac Yum ti' sube jini c Yum: Buchi tic ñoj cha'an tsiquilʌch a ñuclel jintyo mic cʌq'ueñet cha'an a jisʌben i p'ʌtyʌlel a contrajob. Che' ti subenti Cristo ti Dios che' ti' tyaja ti t'an jini David. ");
INSERT INTO ctu76_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Che' jini Jesús ti' c'ajtibeyob: ¿Bajche' isujm cha'an jini yajcʌbil bʌ i cha'an Dios i jiñʌjlel David che' je'el yumʌl i cha'an? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma' majch ti mejli i cha' jac'ben i t'an Jesús. Ti jim bʌ q'uin ti tyejchi i bʌc'ñañob i jop' i cha' c'ajtibeñob Jesús yan tyac bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Che' jini Jesús ti' sube quixtyañujob yic'ot ajcʌnt'añob i cha'an: ");
INSERT INTO ctu76_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Jini ajcʌntisajob cha'an i mandar israelob yic'ot jini fariseojob wen yujilob pejtyelel i sujmlel ts'ijbubil ti i mandar Moisés. ");
INSERT INTO ctu76_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Yom mi la' jac'ben i t'an. Yom mi la' cha'len bajche' mi' subeñetla cha'an jini mandar tyac. Pero mach yom la' lolon cha'len bajche' mi la' wilan mi' cha'leñob. Como mi' bajñel ñusan i cha'len bajche' mi' cʌntisañetla la' cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ma'an majch ch'ujbi i lu' ts'ʌctisan ti pejtyelel bajche' mi' cʌntisañob quixtyañujob i yajñelob. Como ti' lolon oc' isʌ jini mandar tsa' bʌ yʌq'ue Moisés. Che' bajche' chʌncol i yʌq'uen i cuche' ñoj al bʌ i cuch quixtyañujob yubil. Pero i bajñelob mach'an mi' saj cotyañob i cuche' tsa' bʌ i bajñel oc'ʌsʌyob mi yic'ot junts'ijtic i yal c'ʌb mi' cotyañob, yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ti pejtyelel chʌ bʌ jach mi' cha'leñob che' jach mi' cha'len cha'an mi' q'uejlel ti wen ti quixtyañujob. Jini fariseojob yic'ot ajcʌntisajob mi' cʌchob ti' pam yic'ot ti c'ʌb ts'itya' colem bʌ jun ba' ts'ijbubil i t'an Dios. Más on i ch'ʌjlil i yoc i bujc che' bajche' i tyʌlel mi' xojob yambʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mi' mulañob jini más wen tyac bʌ buchlibʌl ya' ti q'uiñejel tyac. Yic'ot ti i templo israelob yom i buchtyʌl ya' ba' mi buchtyʌl jini quixtyañujob mu' bʌ i q'uejlel ti ñuc. ");
INSERT INTO ctu76_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yomob cha'an quixtyañujob mi' saludaliñob ti calle tyac che' bajche' mi an i ñuclel. Che' ti' tyaja ti t'an fariseojob yic'ot ajcʌntisajob cha'an mandar i cha'an israelob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero jatyetla, mach yom mi la' chan isan la' bʌ cha'an mi la' wʌq'uen quixtyañujob i pejcañetla ti maestro. Como ti la' pejtyel la' wermañujob la' bʌ. An juntiquil jach la' maestrojon. ");
INSERT INTO ctu76_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mach la' pejcan ti la' tyat yambʌ winicob wʌ' ti mulawil. Como an juntiquil jach bʌ la' tyat, jiñʌch jini am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yic'ot mach la' wʌq'uen quixtyañujob i pejcañetla ti i yum, como an juntiquil jach la' yumon, Cristojon yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Jini mu' bʌ i q'uejlel ti más ñuc ya' ti' tyojlel Dios, jiñʌch jini mu' bʌ i cha'len cotyaj ti tyojlel i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Como majchical jach mi' lolon pʌt i bʌ ti ñuc mi quejel i ju'sʌntyel. Pero jini pec'o' bʌ i pusic'al mi quejel i q'uejlel ti ñuc. ");
INSERT INTO ctu76_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Como che' bajche' mi la' cʌntisan quixtyañujob chʌncol la' mʌctyʌbeñob i yumiñob Dios. Jatyetla je'el ma'ix mi la' yumin Dios yic'ot ma'ix mi la' wʌc'ob i yumiñob Dios jini yomo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Como mi la' lolon chilbeñob i yotyot tyac xmeba' ixicob cha'an bajche' mi la' lotiñob. Mi la' lolon mele' tyam bʌ oración cha'an mi la' mʌctyʌbeñob quixtyañujob i ña'tyan bajche' mi la' cha'len. Cha'an chʌ'ʌch mi la' cha'len más tyo wocol mi quejel la' wʌq'uentyel la' xot'e la' mul. ");
INSERT INTO ctu76_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Mi la' majlel ti ñajt tyac bʌ pañimil. Mi la' c'axel ti junxejlel colem ja' cha'an la' sajcan juntiquil mu' bʌ la' wʌq'uen i q'uextyan i pusic'al cha'an bajche' mi' ch'ujbin Dios cha'an mi' ch'ujbin bajche' mi la' lolon cʌntisañob. Pero che' tsa'ix i sutqui i bʌ quixtyañu cha'an ti la' caj, más leco bajche'etla mi quejel i yajñelob. Ti pejtyeleletla mi quejel la' ñusan wocol ti xot'mulil ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla ajcʌntisajetla, como che' bajche' muts'ul la' wut bʌ ajpʌs bijetla yubil. Mi la' lolon ale' mi an majch mi' tyaje' ti t'an templo cha'an mi' wa'chocon i t'an, mach wersa mi' cha'len jini tsa' bʌ yʌlʌ. Pero mi ti' tyaja ti t'an jini oro am bʌ ti templo wersa mi' cha'len chʌ bʌ yes ti yʌlʌ, lolon che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mach'an mi la' ña'tyan. Muts'ul la' wut. ¿Baqui bʌ más ñuc mi la' wʌl? ¿Jim ba jini oro? ¿Mach'a ba jini templo ba' mi' tyaj i c'ʌjnibal oro cha'an Dios? ");
INSERT INTO ctu76_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yic'ot je'el mi la' wʌle': Mi an majch mi' tyaje' ti t'an i yajñib i majtyan Dios cha'an mi' wa'chocon i t'an, mach wersa mi' cha'len jini tsa' bʌ yʌlʌ. Pero mi ti' tyaja ti t'an i majtyan Dios am bʌ ti yajnib i majtyan Dios, mi la' wʌle' cha'an wersa mi' cha'len jini tsa' bʌ yʌlʌ, lolon che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Mach'an mi la' ña'tyan. Muts'ul la' wut. ¿Baqui bʌ más ñuc? ¿Jim ba i majtyan Dios o mach'a ba i yajnib i majtyan Dios ba' mi' tyaj i c'ʌjnibal i majtyan Dios? ");
INSERT INTO ctu76_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Como jini mu' bʌ i tyaje' ti t'an i yajnib i majtyan Dios cha'an mi' wa'chocon i t'an, mach jinic jach jini i yajnib i majtyan Dios mi' tyaje' ti t'an pero mi' tyaj ti t'an je'el ti pejtyelel chʌ bʌ tyac an ti pam i yajnib. ");
INSERT INTO ctu76_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jini mu' bʌ i tyaj ti t'an templo cha'an i wa'chocon i t'an mach jinic jach jini templo mi' tyaje' ti t'an pero mi' tyaj ti t'an Dios je'el mu' bʌ i yajñel ya' ti templo. ");
INSERT INTO ctu76_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yic'ot je'el mu' bʌ i tyaje' ti t'an jini panchan cha'an mi' wa'chocon i t'an mach jinic jach panchan mi' tyaj ti t'an pero mi' tyaje' ti t'an je'el jini ñuc bʌ i buchlib Dios yic'ot jini am bʌ ti' buchlib. ");
INSERT INTO ctu76_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Mi la' wʌq'uen Dios junchajp loq'uem bʌ ti diez tyac jini pimel tyac menta bʌ i c'aba' yic'ot anís yic'ot comino. Pero mach'an mi la' jac' la' cha'len jini más ñuc bʌ cʌntisa ts'ijbubil bʌ ti mandar tyac. Jini más ñuc bʌ jiñʌch jini tyoj bʌ melojel, yic'ot p'untyaya cha'an la' wom la' cotyan la' pi'ʌlob yic'ot i xuc'tyʌlel la' pusic'al ti' tyojlel Dios. Yom mi la' wʌq'uen jujunchajp loq'uem ti diez tyac ofrenda pero yom mi la' cha'len jini yambʌ wen tyac bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Muts'ul la' wut bʌ ajpʌs bij yubil. Cha'an mach'an mi la' ña'tyan i sujmlel jini chʌncol bʌ la' cʌntisan mi la' pʌse' che' bajche' ñoj ñuc jini mach'ʌ ba'an ñoj ñuc i sujmlel tyac. Pero mi la' lolon ñusan la' cʌntisan jini ñoj ñuc bʌ i sujmlel tyac. Che' bajche' muq'uic la' chic loq'uel jini us yubil ti jini mu' bʌ la' jape', pero mi la' buq'ue más colem bʌ animal camello bʌ i c'aba' yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","P'ump'uñetla cha'an bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Ti q'uelol che' bajche' wen bʌ quixtyañujet bʌ la, pero ti la' pusic'al bele' la' wom xujch' yic'ot mi la' niq'ui mulan chʌ bʌ an i cha'an la' pi'ʌlob. Che'ʌch bajche' mi la' wen poque' i pat vaso yic'ot ch'ejew pero ya' ti mal but'ul ti xujch' yic'ot yambʌ mach'ʌ wen bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Muts'ul la' wut bʌ fariseojet bʌ la yubil. Jini yom bʌ jiñʌch cha'an mi la' ñaxan sʌc isan la' pusic'al. Che' jini sʌquetixla ti mal yic'ot ti q'uelol. Che' bajche' mi la' ñaxan poc i mal vaso yic'ot ch'ejew yubil. Che' jini sʌquix ti mal yic'ot ti pat. ");
INSERT INTO ctu76_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","P'ump'uñetla che' bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Como lajaletla che' bajche' tyun bʌ i yotyotlel tyac ch'ujlelʌl. C'otyajax sʌsʌc cha'an boñolix ti tyan, pero ya' ti mal bibajax cha'an but'ul ti bʌquel tyac yic'ot chʌ bʌ jach pʌc'benix. ");
INSERT INTO ctu76_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Chʌ'ʌch añetla yubil. Tyoj mi la' pʌs la' bʌ ti' wut quixtyañujob. Pero but'ul la' pusic'al ti lot yic'ot simaronlel. ");
INSERT INTO ctu76_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","P'ump'uñet bʌ la cha'an bajche' mi quejel la' ñusan wocol jatyetla fariseojet bʌ la yic'ot ajcʌntisajet bʌ la cha'an mandar. Cha'chajp la' pensal. Mi la' mele' tyun bʌ i yotyotlel ti pam ba' ti mujqui ch'ujlelʌl cha'an la' c'ajtisan jini tsa' bʌ i xiq'ue yʌle' Dios ti ñoj oniyix. Mi la' ch'ʌle' i crusil i wentyʌlel ya' ba' ti ch'ujñʌntiyob jini quixtyañujob tsa' bʌ ajniyob ti tyoj ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Mi la' wʌle': Mi wʌ'ic añon lojon wʌ' ti mulawil che' wʌ' ti ajniyob jini lac yumob ti ñoj oniyix ma'an ti lojon cotyʌyob i tsʌnsan jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, lolon che'etla. ");
INSERT INTO ctu76_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero cha'an chʌ'ʌch mi la' wʌle' chʌncox la' wʌc' ti tsictiyel cha'an i jiñʌjleletla jini tsa' bʌ i tsʌnsʌyob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ts'ʌctisan, che' jini, jini tsa' bʌ tyejchi i cha'len jini la' yumob ti ñoj oniyix. Chʌ'ʌch ti subeyob cha'an Jesús ti' wʌ ña'tyʌ cha'an mi quejel i tsʌnsʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Jesús ti yʌlʌ je'el: Jatyetla lajaletla bajche' lucum tyac. ¿Bajche' mi quejel la' puts'tyan xot'mulil ti c'ajc mi la' wʌl? Mach saj ch'ujbi. ");
INSERT INTO ctu76_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mi quej c xiq'ue' tyʌlel wʌ' ba' añetla jini mu' bʌ i xiq'ue' yʌle' Dios, yic'ot winicob am bʌ cabʌl i ña'tyʌbal yic'ot ajcʌntisajob. Pero an mu' bʌ quejel la' tsʌnsañob. An mu' bʌ quejel la' joc'tyʌl ti cruz cha'an la' tsʌnsañob. An mu bʌ quejel la' jats' ti pʌchi ya' ti templo tyac. An mu' bʌ quejel la' wen tyʌc'lan. Che' mi majlelob ti yambʌ lum ya' mi quejel la' majlel la' tsʌclañob majlel cha'an la' bej tyʌc'lañob. ");
INSERT INTO ctu76_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jin cha'an Dios mi quejel i yotsan ti la' wenta che' bajche' mi ti la' tsʌnsʌyob yubil ti pejtyelelob jini tyoj bʌ quixtyañujob tsa' bʌ tsʌnsʌntiyob c'ʌlʌ ti tsʌnsʌnti jini tyoj bʌ Abel ti ñoj oniyix, c'ʌlʌ ti tsʌnsʌnti Zacarías i yalobil bʌ Berequías tsa' bʌ tsʌnsʌyob ya' ti jajp templo ya' ti t'ejl ba' ti puluyob i majtyan Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Melelʌch mic subeñetla cha'an ti caj pejtyelel jini tsa' bʌ ujti c'ʌlʌ ti ñoj oniyix mi quejel i yʌq'uentyel i xot'e' che' bajche' mi i mulobʌch ili quixtyañujob año' bʌ ti mulawil wale iliyi. Che' ti' yʌlʌ Jesús como mi quejel i tsʌnsañob. ");
INSERT INTO ctu76_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jatyetla añet bʌ la ti Jerusalén mu' bʌ la' tsʌnsan jini tsa' bʌ i xiq'ui yʌle' Dios, mu' bʌ la' jule' ti tyun jintyo ti tsʌnsʌnti jini ajsubt'añob tsa' bʌ i choco tyʌlel Dios. Jayyajlel com c much'quiñetla yubil che' bajche' ña' mut mi luts i yal. Pero mach la' wom. ");
INSERT INTO ctu76_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Q'uele a wilan la' colem templo mi quejel i joch cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma'ix mi quejel la' cha' ilañon jintyo ti yorojlel mi quejel la' wʌl: La' sujbic a ñuclel jatyet mu' bʌ a tyʌlel cha'an che' yom Dios. Chʌ'ʌch mi quejel la' wʌle'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús ti loq'ui ti templo. Ti queji i majlel. Ya' ti c'oti ajcʌnt'añob i cha'an. Ti queji i pʌsben Jesús i c'otyajlel jini templo. ");
INSERT INTO ctu76_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero Jesús ti yʌlʌ: Q'uele bajche' yilal. Pero melel mic subeñetla ma'ix mi quejel i saj cʌytyʌl mi jump'ejlic tyun ti pam yambʌ. Mi quejel i lu' jisʌntyel. Che' ti wʌ alʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ti majliyob ti jump'ej wits Olivajol bʌ i c'aba'. Che' ñac ya' buchul Jesús ti c'otiyob ajcʌnt'añob i cha'an, cha'an i bajñel pejcan. Ti yʌlʌyob: Com a subeñon lojon jalajqui mi quejel i ts'ʌctiyel pejtyelel jini. ¿Chuqui ti seña mi quejel i pʌstyʌl che' i yorojlel mi quejel a cha' tyʌlel, che' i yorojlel mi quejel i jilel mulawil? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Che' jini, Jesús ti' subeyob: Yom wen xuc'uletla cha'an ma' majch ch'ujbi i lotiñetla. ");
INSERT INTO ctu76_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Como cabʌlob mi quejel i tyʌlelob mu' bʌ i quejel i c'ʌmbeñon j c'aba'. Mi quejel i lolon alob: Joñon Cristojon, yajcʌbilon bʌ i cha'an Dios, che'ob mi quejel i yʌlob. Cabʌl mi quejel i lotintyelob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Mi quejel la' wubin ti alol an guerra wʌ'i mi ya'i mi ba'ical. Pero mach yom mi la' cha'len bʌq'uen. Chʌ'ʌch mi quejel i wersa yujtyel. Pero max tyo jinic i yujtibal mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Junmujch' quixtyañu mi quejel i contrajin yambʌ junmujch'. Yumʌlob yic'ot año' bʌ ti' wenta mi quejel i cha'len guerra ti i contra yambʌ yumʌl. Ti cabʌl pañimil tyac mi quejel wi'ñal yic'ot c'am'an tyac yic'ot yujquel lum tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pejtyelel iliyi i tyejchibal jax tyo wocol mu' bʌ quejel i ñusañob quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Che' jini mi quejel i chuquetla cha'an i yʌq'uetla ti tyʌc'lʌntyel. Mi quejel i tsʌnsañetla. Ti pejtyelelob año' bʌ ti mulawil mi quejel i ts'a'q'ueletla cha'an tij caj. ");
INSERT INTO ctu76_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti jim bʌ ora cabʌl mi quejel i cʌy i ch'ujbiñon. Mi quejel i ts'a'q'uelob yic'ot mi quejel i yʌc'ob ti' c'ʌb i contrajob jini yaño' bʌ mach'ʌ ba'an ti' cʌyʌ i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Mi quejel i tyʌlel cabʌl xlotyob mu' bʌ i lolon yʌlob cha'an xiq'uilob tyʌlel i cha'an Dios. Cabʌlob mi quejel i lolon ch'ujbiñob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mi quejel i ñoj oc'an simaronlel. Cha'an ti caj i simaronlel, cabʌl mi quejel i cʌyob i p'untyañob i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero majchical jach bej xuc'ul mi' cuche' i wocol c'ʌlʌ ti yujtibal wocol tyac mi quejel i cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Mi quejel i sujbel ti pejtyelel pañimil tyac jini wen bʌ t'an cha'an i yumintyel Dios cha'an mi lu' ubiñob ti pejtyelel quixtyañujob. Che' jini mi quejel i tyʌlel i yorojlel mi jilel mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Mi quejel la' wilan mi yujtyel bajche' ti wʌ alʌ tsa' bʌ xiq'ui yʌle' Dios Daniel bʌ i c'aba'. Ti' ts'ijbu cha'an mi quejel la' wilan jini ñoj bibajax bʌ mu' bʌ i jisan cabʌl chʌ bʌ yes tyac ya'ix wa'al ya' ba' mach yom ochic ti ch'ujul bʌ ajnibʌl ti colem templo ya' ti Jerusalén. Jini mu' bʌ i q'uele' ili jun yom i ch'ʌmben isujm che' mi yilan bajche' jini, cha'an jiñʌch jini tsa' bʌ wʌ ajli. ");
INSERT INTO ctu76_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Che' jini, jini año' bʌ ti Judea che' mi' q'uele' bajche' mi yujtyel yom puts'icob majlel ti wits. ");
INSERT INTO ctu76_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ti jim bʌ ora jini am bʌ ti' pat i yotyot mach yom jalec cha'an i yochel i ch'ʌme' loq'uel chʌ bʌ an i cha'an ti i yotyot. ");
INSERT INTO ctu76_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jini am bʌ ti cholel mach yom cha' sujtic ti yotyot mi cha'anic i loc'san i pislel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ñoj p'ump'uñob che' bajche' mi quejel i ñusañob wocol jini x'ixicob cʌñʌtyʌbil tyo bʌ i cha'an i yalobil yic'ot jini chʌncol tyo bʌ i tsu'san i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","C'ajtibenla Dios ti oración cha'an mach ti yorojlel tsʌñal mi la' wersa majlel ti puts'el, mi ti i q'uiñelel c'aj oj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ñoj wocol mi quejel i yujtyel ti ili bʌ q'uin tyac. Más wocol che' bajche' ti pejtyelel wocol tyac c'ʌlʌ ti tyejchibal mulawil c'ʌlʌ ti yujtibal mulawil. Mach'an ba' bʌ ora lajal bʌ wocol mi quejel i ñumel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mi mach'an mi' com isan ili q'uin tyac Dios, mach'an majch i cuchu. Pero mi quejel i com isʌntyel cha'an ti caj mi' p'untyan Dios jini tsa' bʌ i wʌ yajcʌ cha'an i yajñel ti i cha'añʌch. ");
INSERT INTO ctu76_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Che' jini mi an majch mi' subeñetla: Q'uele wʌ' an wʌ'i jini Cristo, yajcʌbil bʌ i cha'an Dios, che'en, o yambʌ mi yʌle': Q'uele ya'an jini yajcʌbil bʌ i cha'an Dios ya'i, che'en, mach yom mi la' ch'ujbin. ");
INSERT INTO ctu76_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Como mi quejel i tyʌlel cabʌl xlotyob mu' bʌ i lolon subob i bʌ ti Cristo, jini yajcʌbil bʌ i cha'an Dios. An mu' bʌ i lolon yʌlob cha'an xiq'uilob tyʌlel i cha'an Dios. Mi quejel i pʌsob seña tyac yic'ot ñuc tyac bʌ i p'ʌtyʌlel cha'an yom i lotiñob mi jinic yajcʌbilo' bʌ i cha'an Dios mi ti mejliyob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pero tsa'ix c wʌ subetla bajche' mi quejel i yujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jin cha'an mi ti' subeyetla: Q'uele ya'an Cristo ya' ti tyʌquin bʌ joch lum, che'ob, mach yom majliquetla. O mi ti subeyetla: Q'uele wʌ'an Cristo ti mali ili otyot, che'ob, mach yom la' ch'ujbin. ");
INSERT INTO ctu76_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Como che' lajal bajche' mi tsictiyel i c'ʌc'al chajc c'ʌlʌ ya' ba' mi' pasel q'uin c'ʌlʌ ya' ba' mi' p'ʌjquel q'uin chʌ'ʌch je'el mi quejel c tsictiyel ti' wut pejtyelel quixtyañujob che' mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ba'ical jach an chʌ bʌ chʌmen ya' mi quejel i much'quiñob i bʌ xtya'jol. Che' ti yʌlʌ Jesús. Ti lajoñel yom i yʌle' che' but'ul mulawil ti i simaronlel quixtyañujob Jesús mi quejel i tyʌlel i melob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Che' ti jin jach bʌ ora che' ñumeñix i yorojlel wocol mu' bʌ i wersa ñumel, mi quejel i yic'an jini q'uin. Mach'an mi quejel i lejmel i c'ʌc'al uw. Mi quejel i yajlel tyac jubel ec'. Jinic tyo chʌ bʌ an ti chan mi quejel i nijcʌyel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Che' jini ya' ti chan mi quejel i yilañob seña che' mic tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. Ti pejtyelelob año' bʌ ti mulawil mi quejel i lu' cha'leñob uq'uel. Mi quejel i yilañoñob Joñon i Pi'ʌlon bʌ Quixtyañujob che' mi quejel c tyʌlel ti tyocal tic p'ʌtyʌlel yic'ot ti ñoj c'otyajax bʌ c ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ti c'am bʌ i t'an trompeta mu' bʌ i yuctisʌntyel mi quejel c xic' tyʌlel ajtroñelob i cha'an bʌ Dios ch'oyolo' bʌ ti panchan. Mi quejel i much'quiñob jini yajcʌbilo' bʌ i cha'an Dios ti chʌnwejlel mulawil c'ʌlʌ ba'ical jach añob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Cʌñʌla jini lajoñel cha'an jini higuera tye'. Che' an i buts, che' chʌncol ch'oquiñejel i yopol che' jini mi la' ña'tyan lʌc'ʌlix i yorojlel q'uin tyunil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Che' je'el che' mi la' q'uel chʌncol i yujtyel tyac iliyi, lʌc'ʌlix i yorojlel mi quejel c cha' tyʌlel. Mero más lʌc'ʌlix mach tyalon, yubil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Melel mic subeñetla mi quejel i yujtyel tyac ti pejtyelel iliyi che' max tyo ti sajtiyob ili quixtyañujob año' bʌ ti ili ora. ");
INSERT INTO ctu76_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mi quejel i sʌc jilel majlel ti pejtyelel jini chan yic'ot mulawil, pero c t'an mach saj jil. ");
INSERT INTO ctu76_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mach'an majch yujil baqui bʌ q'uin o baqui bʌ ora mi quejel i yujtyel jini, mi ajtroñelobic i cha'an Dios ch'oyolo' bʌ ti panchan. Jini jach c Tyat am bʌ ti panchan yujil isujm. Mi jinic joñon i yalobilon mach cujil isujm. ");
INSERT INTO ctu76_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Che' lajal che' bajche' ti ujti che' ñac wʌ' an ti mulawil Noé bʌ i c'aba' chʌ'ʌch je'el mi quejel i yujtyel ti yorojlel che' mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Che' ñac wʌ' an ti mulawil Noé, che' max tyo ti tyʌli jini but' ja', quixtyañujob ti' cha'leyob uch'el, ti' cha'leyob ñujpuñel, ti' sijiyob i yalobilob c'ʌlʌ ti jim bʌ q'uin che' ñac ti ochi Noé ti barco bʌ otyot. ");
INSERT INTO ctu76_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mach'an ti' ña'tyʌyob mi an chʌ bʌ yes mi quejel i yujtyel jintyo ti tyʌli but' ja'. Ti lu' jiliyob. Chʌ'ʌch bajche' jini mi quejel i yujtyel che' mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ti jim bʌ ora añob cha'tiquil winic ti jumpejt cholel. Juntiquil mi quejel i pʌjyel majlel. Yambʌ mi quejel i cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cha'tiquil x'ixicob chʌncolob ti motin juch'bal. Juntiquil mi quejel i pʌjyel majlel. Yambʌ mi quejel i cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Yom bej chajpʌbiletla como mach'an mi la' ña'tyan baqui bʌ ora mi quejel i cha' tyʌlel la' Yum. ");
INSERT INTO ctu76_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ña'tyanla jini. Mi tsa'ic i ña'tyʌ i yum otyot bajche' ora ti ac'bʌlel mi quejel i c'otyel ajxuch', p'ixilʌch che' jini cha'an ma'an mi yʌc' ochel ti yotyot i ch'ʌme' chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jini cha'an yom bej chajpʌbiletla. Como che' ma'ix chʌncol la' saj pensalin cha'an mi quej c tyʌlel, Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel c tyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesús ti' cha'le lajoñel bʌ t'an. Ti yʌlʌ: Mic subeñetla majchqui jini xuc'ul bʌ ajcʌñʌtya troñel mu' bʌ i wen ña'tyan bajche' mi' cha'len i troñel i yum. I yum mi' cʌye' ti' wenta ti pejtyelel am bʌ ti yotyot cha'an i lu' aq'ueñob i yuch'el ti yorojlel. ");
INSERT INTO ctu76_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","C'ajacña i yoj jini ajcʌñʌtya troñel che' mi quejel i c'otyel i yum i q'uele' ts'ʌcʌl chʌncol i cha'len jini tsa' bʌ subenti i cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Melel mic subeñetla: I yum mi quejel i yotsan ti' wenta jini xuc'ul bʌ ajcʌñʌtya troñel ti pejtyelel chʌ bʌ tyac yes an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero mi simaron jini ajcʌñʌtya troñel, mi ti queji i bajñel pensalin cha'an mach wa' c'ot i yum, ");
INSERT INTO ctu76_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","mi ti queji i jats'ob jini yambʌ ajtroñelob i pi'ʌlob ti troñel, mi ti queji ti uch'el yic'ot ti jap lembal yic'ot xq'uixñijelob, ");
INSERT INTO ctu76_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","che' jini mi quejel i c'otyel i yum ti jump'ej q'uin che' ma'an chʌncol i saj pijtyan i c'otyel, che' ti yorojlel che' mach yʌxʌl i yoj. ");
INSERT INTO ctu76_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mi quejel i yʌq'uen i ñusan jini más wocol bʌ xot'mulil. Che' jini mi quejel i choque' loq'uel cha'an ya' mi yajñel yic'ot jini cha'chajpo' bʌ i pensal. Ya'i mi quejelob ti uq'uel yic'ot tsʌts mi quejel i c'uxob i yej. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ch'ujbi lac laje' i yumintyel Dios yic'ot diez xc'alʌlob tsa' bʌ ch'ʌmʌyob majlel i cas. Ti majliyob ti i q'uiñejel ñujpuñel cha'an i tyajtyʌl tyʌlel ajñujpuñel. ");
INSERT INTO ctu76_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco ma' ti' ñoj wen chajpʌyob i bʌ. Jini yambʌ cinco ti' wen chajpʌyob i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jini mach'ʌ ba'an ti' ñoj wen chajpʌyob i bʌ ti' ch'ʌmʌyob majlel i cas pero ma' ti' ch'ʌmʌyob majlel yambʌ i ya'lel i cas cha'an i cha' but'ob i pat cas. ");
INSERT INTO ctu76_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero jini tsa' bʌ wen chajpʌyob i bʌ ti' ch'ʌmʌyob majlel i pat cas yic'ot yambʌ i ya'lel cas. ");
INSERT INTO ctu76_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Cha'an ma' ti se' c'oti ajñujpuñel wersa yomob wʌyel jini xc'alʌlob. Che' jini ti lu' ochiyob i wʌyel. ");
INSERT INTO ctu76_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Che' jini ti xin ac'bʌlel ti queji i yubiñob c'am bʌ ajt'an. Ti yʌlʌ: Tyalix jini ajñujpuñel. Con lac tyajob tyʌlel. Che' ti yʌlʌ jini ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Che' jini, jini xc'alʌlob ti lu' tyejchiyob i ts'ʌbob i cas. ");
INSERT INTO ctu76_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Che' jini, jini mach'ʌ ba'an wen chajpʌbilob ti' subeyob jini chajpʌbilo' bʌ: Aq'ueñon lojon i sajlic i ya'lel a cas como chʌncox i yʌjpel lojon j c'ajc, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero jini xc'alʌlob wen chajpʌbilo' bʌ ti' jac'ʌyob: Mach ch'ujbi. Como mach jasʌl lojon c cha'an mi ti lojon cʌq'uetla. Yom bʌ yi, mi la' majlel la' mʌn la' cha'an ya' ba' mi' chojñel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero che' ñac bʌ majlemob i mʌn cas, ti c'oti ajñujpuñel. Jini wen chajpʌbilob cinco xc'alʌlob ti ochiyob ti q'uiñejel cha'an ñujpuñel. Che' jini ti ñujp'i i ti' otyot. ");
INSERT INTO ctu76_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Che' ti c'otiyob jini yambʌ cinco xc'alʌlob tsajniyo' bʌ ti mʌn cas ti yʌlʌyob: C yum, jambeñon lojon i ti' otyot, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero jini ajñujpuñel ti' jac'ʌ: Melel, mach j cʌñʌyetla, che'en. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Che' jini, ti yʌlʌ Jesús: Jin cha'an yom bej chajpʌbiletla como ma'an mi la' saj ña'tyan baqui bʌ q'uin baqui bʌ ora mi quejel c cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesús ti yʌlʌ ti lajoñel: Ch'ujbi lac laje' i yumintyel Dios bajche' juntiquil winic mu' bʌ quejel i majlel ti jula' ti ñajt bʌ pañimil. Che' jini ti' pʌyʌ tyʌlel i yajtroñelob cha'an mi yʌq'uen ti' wenta i tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ti jujuntiquil ti aq'uentiyob che' bajche' añob i c'ʌjnibal. An juntiquil tsa' bʌ yʌq'ue che' bajche' jop'ej mil pesos. Yambʌ ti yʌq'ue che' bajche' cha'p'ej mil, yambʌ ti yʌq'ue jump'ej mil. Che' jini ti majli ti xʌmbal ti ñajt jini i yum. ");
INSERT INTO ctu76_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jini juntiquil yajtoñel tsa' bʌ yʌq'ue jo'p'ej mil pesos ti' c'ʌñʌ ti toñel jini tyaq'uin. Ti' ganari yambʌ jop'ej mil pesos. ");
INSERT INTO ctu76_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Junlajal ti' cha'le jini tsa' bʌ yʌq'ue cha'p'ej mil. Ti' c'ʌñʌ ti toñel jini tyaq'uin. Ti' ganari yambʌ cha'p'ej mil pesos. ");
INSERT INTO ctu76_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero jini yambʌ tsa' bʌ aq'uenti jump'ej mil tsa' jach i mucu jini tyaq'uin ti mal lum. ");
INSERT INTO ctu76_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","On q'uin ti majli. Ti cha' c'oti jini i yum. Ti' pʌyʌ tyʌlel i yajtoñelob i subob i bʌ bajche' ti' cha'leyob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ñaxan ti c'oti jini tsa' bʌ aq'uenti jo'p'ej mil pesos. Ti yʌq'ue i yum yambʌ jo'p'ej mil pesos. Ti yʌlʌ: Ti a wʌc'on jo'p'ej mil. Umba'an yambʌ jo'p'ej mil pesos tsa' bʌ c ganari, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jini i yum ti' sube: Weñʌch bajche' ti a cha'le. Wen xuc'ulet bʌ ajtoñel c cha'an. Cha'an xuc'ulet ti a cha'le toñel yic'ot ts'itya' tyaq'uin, más i yonlel mi quej cʌq'ueñet ti a wenta. Ochen. Tijicnisan a bʌ a wic'otyon. Che' ti yʌlʌ i yum. ");
INSERT INTO ctu76_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Che' jini ti c'oti yambʌ yajtoñel tsa' bʌ aq'uenti cha'p'ej mil pesos. Ti' sube i yum: C yum, ti a wʌc'on cha'p'ej mil. Umba'an yambʌ cha'p'ej mil tsa' bʌ c ganari, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jini i yum ti' sube: Weñʌch bajche' ti a cha'le. Wen xuc'ulet bʌ ajtoñel c cha'an. Cha'an xuc'ulet ti a cha'le toñel yic'ot ts'itya' tyaq'uin, más i yonlel mi quej cʌq'ueñet ti a wenta. Ochen. Tijicnisan a bʌ a wic'otyon. Che' ti yʌlʌ jini i yum. ");
INSERT INTO ctu76_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Che' ñac ti c'oti i sub i bʌ ba'an i yum jini yajtoñel tsa' bʌ aq'uenti jump'ej mil pesos ti yʌlʌ: Tsa'ix c wʌ ña'tyʌ tsʌts a pusic'al bʌ winic mu' bʌ a mulan a bele' ch'ʌme' mach'ʌ yoque a cha'an. Ma' ch'ʌm mach'ʌ ba'an ti a ganari. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jin cha'an tic bʌc'ñʌ c'ʌñe' jini a tyaq'uin tsa' bʌ a wʌc'on. Tsa' jach c mucu ti mal lum. Pero umba'an a cha'an bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pero jini i yum ti' jac'ʌ: Mach weñet bʌ ajtoñel. Ti' a lolon ña'tyʌ cha'an mic ch'ʌm mach'ʌ ba'an tic ganari. ");
INSERT INTO ctu76_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jin cha'an tsa'ic a wotsʌ ti banco c tyaq'uin cha'an mic ch'ʌmben i jol cha'an i yoq'uijib cha'an mic más ganarin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Che' jini ti' subeyob jini ya' bʌ añob: Chilbenixla jini jump'ej mil peso. Aq'uenla jini tsa' bʌ aq'uenti diez mil pesos, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Como jini am bʌ i cha'an mi quejel i más aq'uentyel. Mi quejel i colojbʌyel. Pero jini mach'ʌ ba'an i cha'an mi quejel i chilbentyel jinic tyo ts'itya' jach bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iliyi mach'ʌ ba'an i c'ʌjnibal bʌ quixtyañu, chucula. Chocola majlel ba' ic'jowan ba' mi quejel i cha'len c'am bʌ uq'uel, ba' mi quejel i c'uxe' i yej, che'en. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesús ti' bej cha'le t'an. Ti yʌlʌ: Che' mic tyʌlel cha'an mic cha'len yumʌl Joñon i Pi'ʌlon bʌ Quixtyañujob, tic joytyʌlel mi quejel i tyʌlel quic'ot ti pejtyelel ajtoñelob c cha'an ch'oyolo' bʌ ti panchan. Ya' mi quejel c tyʌlel ti buchtyʌl ti c'otyajax bʌ c buchlib. ");
INSERT INTO ctu76_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ya' tic tyojlel mi quejel i much'quiñob i bʌ ti pejtyelel quixtyañujob tyʌlemo' bʌ ti pejtyelel mulawil. Mi quejel c t'ox ac' ti cha'mujch' che' bajche' juntiquil ajcʌñʌtya tiñʌme' mi t'ox ac' tiñʌme' ti junwejl yic'ot chibu ya' ti yambʌ junwejl. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ya' mi quejel cʌc' jini tiñʌme' yubi tic ñoj yic'ot jini chibu bʌ yubi tic ts'ej. ");
INSERT INTO ctu76_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Che' jini joñon ñuc bʌ yumʌlon mi quejel c suben quixtyañujob año' bʌ tic ñoj: La'ixla jatyetla tsa'ix bʌ aq'uentiyetla i yutslel i t'an c Tyat. Ochenla ba' mi quejel c cha'len yumʌl. Tsa'ix chajpʌbentiyetla cha'an la' wajñel ya'i c'ʌlʌ ñoj oniyix che' ñac ti' mele Dios ili mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Como che' ñac ti cubi wi'ñal ti la' wʌc'on cuch'el. Che' ñac tyʌquin c ti' ti la' wʌc'on chʌ bʌ ti capʌ. Che' ñac ya' añon ba' ma' majch ti' cʌñʌyon ti la' pʌyʌyon ochel ti la' wotyot. ");
INSERT INTO ctu76_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Che' ñac ma'ix c pislel ti la' wʌc'on. Che' ñac c'am'on ti la' jula'ayon. Che' ñac añon ti cʌchol ti tyʌli la' q'uelon la' cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Che' jini, jini tyoj bʌ i pusic'al bʌ quixtyañujob mi quejel i yʌlob: C Yum, ¿baqui ora ti lojon quilʌyet che' wi'ñayet che' ti lojon cʌq'ueyet a wuch'el? ¿Baqui ora ti lojon quilʌyet che' an a tyʌquin ti' che' ti lojon cʌq'ueyet chʌ bʌ ti a japʌ? ");
INSERT INTO ctu76_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Baqui ora ti lojon quilʌyet che' ma'an majch ti cʌñʌyet che' ti lojon cʌq'ueyet ochel ti lojon cotyot o che' mach'an a pislel ti lojon cʌq'ueyet? ");
INSERT INTO ctu76_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Baqui bʌ ora ti lojon quilʌyet che' c'amet o che' añet ti cʌchol che' tsajniyon lojon j q'uelet cha'an lojon j cotyañet? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Che' jini, joñon ñuc bʌ yumʌlon mi quejel c subeñob: Melel mic subeñetla, che' chʌ bʌ jach yes ti la' cha'le cha'an la' cotyan juntiquil tsa' bʌ i ch'ujbiyon aunque ma' ti q'uejli ti ñuc, ti la' cotyʌyon yubil che' ti la' cotyʌ jini quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Che' jini, joñon ñuc bʌ yumʌlon mi quejel c subeñob jini año' bʌ tic ts'ej: Loq'uenla wʌ' ba'añon, jatyetla chojquemetla loq'uel ti Dios. Cucuxla ya' ti c'ajc mach'ʌ ba'an mi yajpel chajpʌbil cha'an xiba yic'ot yajtroñelob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Che' ñac ti cubi wi'ñal, mach'an ti la' wʌc'on cuch'el. Che' ñac ti cubi tyʌquin ti' mach'an ti la' wʌc'on chʌ bʌ mi cap. ");
INSERT INTO ctu76_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Che' ñac ya' añon ba' ma'an majch i cʌñʌyon, mach'an ti la' pʌyʌyon ochel ti la' wotyot. Che' ñac mach'an c pislel, ma'an chʌ bʌ ti la' wʌc'on. Che' ñac c'am'on, che' ñac añon ti cʌchol mach'an tsajniyetla la' jula'añon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Che' jini, mi quejel i yʌlob: ¿Baqui ora ti lojon quilʌyet che' wi'ñayet yic'ot che' tyʌquin a ti', mi che' ya' añet ba' ma'an majch ti' cʌñʌyet, mi che' ma'ix a pislel, mi che' c'amet, mi che' añet ti cʌchol che' mach'an ti lojon j cotyʌyet? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Che' jini, joñon ñuc bʌ yumʌlon, mi quejel c subeñob: Melel mic subeñetla, che' mach'an ti la' cotyʌ juntiquil jini wʌ' bʌ an mach'ʌ ba'an mi q'uejlel ti ñuc, mach'an ti la' cotyʌyon yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Che' jini, jini mach'ʌ ba'an ti' cotyʌyob i pi'ʌlob mi quejel i majlelob ti xot'mulil mach'ʌ ba'an mi saj jilel. Jini tyoj bʌ i pusic'al bʌ quixtyañujob mi quejel i majlelob ba' mi yʌq'uentyelob i cuxtyʌlel mach'ʌ yujil jilel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Che' ñac ti ujti Jesús i sube' pejtyelel ili t'an, ti' subeyob jini ajcʌnt'añob i cha'an: ");
INSERT INTO ctu76_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","La' wujil uxi i q'uinilel pascua. Jiñʌch i q'uinilel che' ti' c'ajtisʌyob israelob bajche' ti loq'uiyob ti pañimil Egipto bʌ i c'aba' ti ñoj oniyix. Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti' c'ʌb jini mu' bʌ i tsʌnsañon ti cruz, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti jim bʌ ora jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob yic'ot xñoxob año' bʌ i ye'tyel cha'an israelob ti' much'quiyob i bʌ ya' ti' pat i colem otyot Caifás. Ñoj ñuc bʌ cura jini Caifás. ");
INSERT INTO ctu76_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ya'i ti' pejcʌyob i bʌ cha'an i sajcan bajche' mi' chucob Jesús cha'an ti lot bʌ t'an cha'an i tsʌnsañob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero ti yʌlʌyob: Mach yom lac chuc che' chʌncol q'uiñejel ame nijquicob quixtyañu, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya'an Jesús ti lum Betania bʌ i c'aba' ti yotyot Simón jini tsa' bʌ pejcʌnti ti Leproso, jiñʌch yom yʌle' juntiquil am bʌ chʌ bʌ yes pasem ti' pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. ");
INSERT INTO ctu76_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Buchul Jesús ya' ti mesa. Ti c'oti jintiquil x'ixic am bʌ i cha'an jump'ej yajñib melel ti wen bʌ tyun alabastro bʌ i c'aba'. But'ul yajnib ti ñoj lets bʌ i tyojol bʌ yowocña bʌ aceite. Ti' mulbe ti' jol Jesús jini yowocña bʌ aceite. ");
INSERT INTO ctu76_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Che' ñac jini ajcʌnt'añob i cha'an Jesús ti yilʌyob chʌ bʌ ti' cha'le jini x'ixic, ti mich'ʌyob. Ti queji yʌlob: ¿Chuquiyes i c'ʌjnibal ti' lolon jisʌ jini yowocña bʌ aceite? ");
INSERT INTO ctu76_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Mi tsa'ic chojni cha'an i cotyan p'ump'uño' bʌ como ñoj lets i tyojol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús ti yubi chʌ bʌ ti yʌlʌyob. Ti' subeyob: ¿Chucoch mi la' tique' jini x'ixic? Ñoj wen jini tsa' bʌ i cha'libeyon. ");
INSERT INTO ctu76_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Jini p'ump'uño' bʌ wʌ' bele' an la' wic'ot ti bele' q'uin. Pero joñon mach'an bele' q'uin wʌ' añon la' wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Como jini tsa' bʌ cha'libon jini x'ixic che' ti' mulu c bʌc'tyal ti yowocña bʌ aceite ti' cha'le cha'an i chajpʌbeñon c ch'ujñʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Melel mic subeñetla, ba'ical jach mi sujbel ili wen bʌ t'an c'ʌlʌ ti pejtyelel mulawil, mi quejel i yʌjlel bajche' ti' cha'le jini x'ixic cha'an mi ña'tyʌntyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Che' jini juntiquil i docejlel ajcʌnt'añob, Judas Iscariote bʌ i c'aba', ti majli i pejcan ñuc bʌ curajob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ti' subeyob: ¿Jayp'ej peso mi quejel la' wʌq'ueñon mi ti cʌc'ʌ ti la' c'ʌb Jesús? che'en. Che' jini ti yʌq'ueyob treinta sʌsʌc tyaq'uin. Jini treinta sʌsʌc tyaq'uin jiñʌch che' bajche' i tyojol 120 q'uin toñel. ");
INSERT INTO ctu76_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Che' jini, Judas ti queji i wa' sajcan bajche' mi yʌq'ue' ti chucol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ti tyejchibal q'uiñejel che' mi' c'uxob caxlan waj mach'ʌ ba'an yic'ot levadura mu' bʌ yʌq'uen i wos i bʌ, ti cot'iyob ya' ba'an Jesús jini ajcʌnt'añob i cha'an. Ti yʌlʌyob: ¿Baqui a wom mi lojon c chajpan cha'an ma' cha'len uch'el che' ti q'uiñelel pascua? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús ti' subeyob: Cucula ya' ti lum. Yom la' wochel ya' ti yotyot juntiquil winic. Subenla: Lac Maestro mi yʌl: Lʌc'ʌlix i yorojlel mi quej c sajtyel. Ya' ti a wotyot com c ñusan pascua bʌ quiñejel quic'ot ajcʌnt'añob c cha'an, che'etla mi la' suben, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jini ajcʌnt'añob ti' cha'leyob bajche' ti subentiyob. Ya' ti' chajpʌyob uch'el cha'an pascua bʌ q'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Che' iq'uix quejel ya' buchul Jesús ti mesa yic'ot jini doce ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Che' muc'ob ti uch'el ti' subeyob: Melel mic subeñetla juntiquiletla mi quejel a wʌc'on ti' c'ʌb j contrajob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Che' jini, ñoj ch'ʌjyem ti queji yubiyob. Quepecña ti queji i c'ajtibeñob: C Yum, ¿joñon ba? che' tyacob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús ti' subeyob: Jini mu' bʌ i ts'aje' i caxlan waj ti jin jach bʌ ch'ejew quic'ot, jiñʌch mu' bʌ i yʌc'on ti' c'ʌb j contra. ");
INSERT INTO ctu76_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel c sajtyel bajche' mi yʌl ti Ts'ijbubil bʌ i T'an Dios. Pero ñoj wocol mi quejel i ñusan jini mu' bʌ i yʌc'on ti' c'ʌb j contrajob. Más wen mach'ic ti ch'ocʌ jini winic. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Che' jini, Judas, jini mu' bʌ i yʌc' Jesús ti' c'ʌb i contra, ti' sube: Maestro, ¿joñon ba? che'en. Jesús ti yʌlʌ: Jatyetyʌch, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Che' ñac muc'ob ti uch'el Jesús ti' ch'ʌmʌ caxlan waj. Ti' sube Dios wocox i yʌlʌ. Ti' xet'e jini caxlan waj. Ti yʌq'ueyob ajcʌnt'añob i cha'an. Ti' subeyob: C'uxula. Jiñʌch c bʌc'tyal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Che' jini ti' ch'ʌmʌ vaso ti' c'ʌb. Ti' sube Dios wocox i yʌlʌ. Che' jini ti' ñusʌ vaso i ya'lel uva ya' ba'añob cha'an jujuntiquil mi jape' ts'itya'. Ti yʌlʌ: Ti jujuntiquiletla japʌla jini am bʌ ti vaso, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Como jiñʌch c ch'ich'el. Jiñʌch i señʌjlel tsiji' bʌ trato bʌ t'an mu' bʌ i wa'chocontyel cha'an tic ch'ich'el mu' bʌ quejel c beque' cha'an i ñusʌntyelob i mul cabʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero mic subeñetla mach'an mi quejel c cha' jape' i ya'lel uva jintyo ti jim bʌ q'uin che' mi lac motin jape' jini tsiji' bʌ ya' ba' mu' ti yumʌl c Tyat ya' ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Che' ñac ti ujti i c'ʌyob jump'ej c'ay ti loq'uiyob majlel ya' ba' ti' cha'leyob uch'el cha'an mi majlelob ya' ti wits Olivajol bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jesús ti' sube: Ti pejtyeletla mi quejel la' quisniñon ti ili bʌ ac'bʌlel come mi yʌl ti Ts'ijbubil bʌ i T'an Dios: Mi quejel c tsʌnsan jini ajcʌñʌtya tiñʌme'. Che' jini mi quejel i pam pujquelob tiñʌme'. Chʌ'ʌch wʌ ts'ijbubil che' Jesús. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ti wi'il che' mic tyejchel loq'uel ba'an sajtyemo' bʌ mi quejel c majlel c pijtyañetla ya' ti Galilea. Che' ti wʌ alʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pedro ti yʌlʌ: Aunque mi' lu' quisniñetyob ti pejtyelel yaño' bʌ pero joñon ma' mi quej c quisniñet. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Che' jini Jesús ti' sube: Melel mic subeñet, ti ili bʌ ac'bʌlel che' max tyo i cha'le uq'uel tyat mut, uxyajlel mi quejel a wʌle' mach a cʌñʌyon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro ti yʌlʌ: Aunque mic sajtyel quic'otyet, mach'an mi quejel cʌl mi mach j cʌñʌyet, che'en. Lajal ti' lu' yʌlʌyob ti pejtyelel ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesús yic'ot ajcʌnt'añob i cha'an ti majliyob ya' ti jumpejt lum Getsemaní bʌ i c'aba' ba' pʌc'ʌl tye' tyac. Che' ti c'otiyob ti' subeyob: Buchi'la wʌ'wʌ'i che' mic majlel c cha'len oración, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Che' jini Jesús ti' pʌyʌ majlel Pedro yic'ot cha'tiquil i yalobil Zebedeo, jiñʌch Jacobo yic'ot Juan. Ts'itya' ñajt ti bej majliyob. Che' jini, ñoj ch'ʌjyem ti queji yubin Jesús. Ñoj c'uxucña i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jesús ti' subeyob: Che' bajche' comox sajtyel ti i ch'ʌjyemlel c pusic'al mi cubin. Pijtyanla wʌ'wʌ'i. Yom ch'uj p'ixiletla la' wic'otyon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tsa' tyo i cha'le xʌmbal che' ñajtyel majlel. Ti' ñuc choco i bʌ ti lum cha'an i cha'len oración. Ti oración ti yʌlʌ: C Tyat, mi chʌ'ʌch wen ma' wubin, cotyañon cha'an mach'an mic wersa sajtyel. Pero mele mach jinic bajche' com joñon, pero mele bajche' a wom. Che' ti yʌlʌ ti oración Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Che' jini ya' ti sujti Jesús ya' ba' ti cʌyle jini uxtiquil ajcʌnt'añob i cha'an. Wʌyʌlobix ti' tyajayob. Ti' sube Pedro: ¿Mach'a ba'an ti mejli la' tic' la' wʌyel la' wic'otyon, mi jump'ejlic ora? ");
INSERT INTO ctu76_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tiq'uila la' wʌyel. Cha'lenla oración cha'an mach'an mi la' yajlel ti mulil. Ti la' pusic'al la' wom la' cha'len wen bʌ pero wocol mi la' mele' como quixtyañujetla, che'en Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ti cha'yajlel ti majli Jesús i cha'len oración. Ti yʌlʌ: C Tyat, mi mach wen ma' wubin ti a pusic'al cha'an ma' loc'sañon c ñusan jini ñoj wocol bʌ, la' mejlic bajche' yom a pusic'al che' jini, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Che' jini, ti cha' sujti Jesús ya' ba'an jini uxtiquil ajcʌnt'añob i cha'an. Cha' wʌyʌlob ti' tyajayob. Bej yom i muts'ob i wut cha'an wersa yomob wʌyel. ");
INSERT INTO ctu76_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ya' ti' cʌyʌyob. Ti cha' bej majli i cha'len oración ti uxyajlel. Ti' cha' alʌ jin jach bʌ t'an che' bajche' ujtyel yʌle'. ");
INSERT INTO ctu76_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Che' jini ti cha' sujti ya' ba'an ajcʌnt'añob i cha'an. Ti' subeyob: ¿Wʌyʌlet tyo ba la? ¿Muq'uet tyo ba la ti bej c'aj oj? Tsa'ix c'oti i yorojlel che' Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti' c'ʌb xmulilob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tyejchenla. Coxla. Lʌc'ʌlix i tyʌlel jini mu' bʌ i yʌc'on ti' c'ʌb j contrajob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Mu' tyo ti t'an Jesús che' ñac ti c'oti Judas jiñʌch juntiquil i pi'ʌl jini yambʌ oncejob. Ti c'oti yic'ot i yonlel año' bʌ i machit tyac yic'ot an tyacob bʌ i tye'. Xiq'uilob tyʌlel ti ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jini Judas, jini mu' bʌ i yʌc' Jesús ti' c'ʌb i contra, ti' wʌ subeyob bajche' mi quejel i pʌs'eñob baqui bʌ jini Jesús. Ti yʌlʌ: Jini mu' bʌ c ñup, jiñʌch jini chʌncol bʌ la' sʌclan. Chucula, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Che' jini Judas ti tyʌli ya' ba'an Jesús. Ti yʌlʌ: Buenas noches, maestro, che'en. Che' jini, ti' ñupu. ");
INSERT INTO ctu76_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús ti' sube Judas: Pi'ʌl, ¿chucoch ti tyʌliyet? Che' jini ti saj ora jach ti tyʌliyob mu' bʌ i chucob Jesús. Ti' chucuyob. Ti' cʌchʌyob cha'an mi' pʌyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Che' chʌncol i chucob Jesús juntiquil ya' bʌ an yic'ot ti' bots'o i machit. Ti' tsepbe loq'uel i chiquin yajtroñel ñuc bʌ cura i cha'an bʌ israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús ti' sube: Cha' otsan a machit ti yotyot como jini mu' bʌ i cha'len periyal ti machit mi quejel i sajtyel ti machit. ");
INSERT INTO ctu76_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Mach'a ba'an mi la' ña'tyan cha'an mi tij c'ajtibe c Tyat am bʌ ti panchan mux i chocbeñon tyʌlel ti saj ora jach más ti docemujch' ajtroñelob i cha'an ch'oyolo' bʌ ti panchan cha'an i wa' cotyañon? ");
INSERT INTO ctu76_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero mi chʌ'ic mij c'ajtin, ¿bajche' mi quejel i ts'ʌctiyel jini Ts'ijbubil bʌ i T'an Dios? como ya' mi yʌle' mux i wersa ujtyel bajche' chʌncol cujtyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Che' jini Jesús ti' subeyob jini tsa' bʌ tyʌliyob i chuc: ¿Tsa'ix ba tyʌliyetla a wic'ot la' machit la' tye' che' bajche' ajxujch'on? Ti jujump'ej q'uin buchulon ti cʌntisa ya' ba' añetla ti templo pero mach'an ti la' saj chucuyon. ");
INSERT INTO ctu76_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero chʌ'ʌch chʌncol i yujtyel wale iliyi cha'an mi' ts'ʌctiyel Ts'ijbubil bʌ i T'an Dios tsa' bʌ wʌ alʌ jini tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix. Che' ti yʌlʌ Jesús. Che' jini, ti pejtyelel ajcʌnt'añob i cha'an Jesús ti puts'iyob. I bajñel ti cʌyle Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jini tsa' bʌ i chucuyob Jesús ti' pʌyʌyob majlel ya' ba'an Caifás jini ñoj ñuc bʌ cura. Ya' much'quibilob ajcʌntisa cha'an i mandar israelob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedro ti' ñajtyʌ tsʌcle majlel Jesús. C'ʌlʌ ti c'oti ya' ti pat i yotyot jini ñoj ñuc bʌ cura. Ya' ti ochi ti buchtyʌl yic'ot policíajob como yom i yilan bajche' mi quejel i yujtyel yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob yic'ot am bʌ i ye'tyel ti comite Junta Suprema bʌ i c'aba' ti' sʌclʌyob mu' bʌ i cha'len jop't'an ti' contra Jesús cha'an i yʌcob ti sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero mach'an ti' tyajayob. Aunque cabʌlob ti' jop'oyob t'an ti' contra Jesús, mach lajal ti loq'uiyob i t'an. Ti wi'il ti c'oti yambʌ cha'tiquilob cha'an mi' jop'beñob i mul Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ti yʌlʌyob: Jini winic ti yʌlʌ: Ch'ujbi quisan jini templo i cha'an bʌ Dios. Ti uxp'ej q'uin mic cha' wa'chocon. Che' ti yʌlʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Che' jini ti wa'le ñuc bʌ cura. Ti' sube Jesús: ¿Mach'a ba'an chʌ bʌ ma' jaq'ue? ¿Chuquiyes i sujmlel jini chʌncol bʌ i yʌlob ti a contra? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús mach'an ti' saj jac'ʌ. Che' jini, jini ñuc bʌ cura ti' sube: Mic subeñet: Wa'chocon a t'an ti i c'aba' cuxul bʌ Dios cha'an chʌncol a subeñon lojon ñoj melel bʌ t'an. ¿Jatyet ba yajcʌbilet bʌ i cha'an Dios? ¿I yalobilet ba Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús ti yʌlʌ: Joñoñʌch. Mic subeñetla je'el mi quejel a wilañon Joñon i Pi'ʌlon bʌ Quixtyañujob ya' buchulon ti i ñoj Dios mach'ʌ ba'an i p'isol i p'ʌtyʌlel. Mi quejel la' wilañon che' mi quejel c tyʌlel ya' ti mal tyocal ya' ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Che' jini ti' tsili i pislel jini ñuc bʌ cura cha'an i señʌjlel cha'an ti ñoj mich'ʌ. Ti yʌlʌ: Jini winic ti' cha'le bibajax bʌ t'an ti' contra Dios cha'an chʌncol jach i cuy i bʌ ti Dios. ¿Chuquiyes i c'ʌjnibal mi lac sʌclan yambʌ mu' bʌ i yʌle' tsa' bʌ i yilʌ tsa' bʌ i cha'le Jesús? Como tsa'ix la' wubi bajche' ti' cuyu i bʌ ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Bajche' mi la' pensalin? ¿Chʌ bʌ yom lac cha'len? che'en. Ti yʌlʌyob: Añʌch i mul. Yom ajq'uel ti sajtyel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Che' jini ti' tyujbʌyob i ñi' i wut Jesús. Ti' jats'ʌyob. Yaño' bʌ ti' jats'ʌyob ti i choj. ");
INSERT INTO ctu76_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ti yʌlʌyob: Mi jatyetyʌch jini yajcʌbil bʌ i cha'an Dios, subeñon lojon majchqui ti' jats'ʌyet, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Che' chʌncol i melob Jesús, ya' buchul Pedro ti' pat i yotyot Caifás. Ya' ti lʌc'ʌl c'oti juntiquil xc'alʌl bʌ ajtroñel. Ti yʌlʌ: Jatyet je'el ti a pi'le ti xʌmbal ñumel Jesús ch'oyol bʌ ti Galilea, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ya' ti' tyojlelob ti pejtyelelob Pedro ti yʌlʌ cha'an mach chʌ'ic. Mach'an mic ña'tyan chʌ bʌ chʌncol a wʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Che' ñac chʌncol i loq'uel majlel ti pat otyot Pedro, yambʌ xc'alʌl bʌ ajtroñel ti yilʌ Pedro. Ti' subeyob ya' bʌ añob: Jini winic je'el ti' pi'le ti xʌmbal ñumel Jesús ch'oyol bʌ ti Nazaret, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro ti cha' alʌ cha'an mach chʌ'ic. Ti' tyaja ti t'an Dios cha'an mi' wa'chocon i t'an. Ti yʌlʌ: Mach j cʌñʌ jini winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Che' ti ts'itya' ñumi ora jini ya' bʌ añob yic'ot ti lʌc'ʌl c'otiyob. Ti' subeyob: Melelʌch jatyet je'el i pi'ʌlet jini winicob como tsiquil jinic tyo bajche' ma' cha'len t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Che' jini Pedro ti' t'ojti'i i bʌ yic'ot ti' wersa cha' wa'choco i t'an. Ti yʌlʌ: Melelʌch c t'an, Dios mi' q'uelon. Mach j cʌñʌ jini winic, che'en. Ti jin jach bʌ ora ti' cha'le uq'uel tyat mut. ");
INSERT INTO ctu76_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Che' jini ti' c'ajtiyi i cha'an Pedro jini tsa' bʌ yʌlʌ Jesús che' ñac ti' sube: Che' max tyo i cha'len uq'uel tyat mut uxyajlel mi quejel a wʌl mach a cʌñʌyon, che'en. Che' jini Pedro ti loq'ui majlel. Ti wen queji ti uq'uel. ");
INSERT INTO ctu76_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Che' ti sʌc'ʌ ti pejtyelel ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob ti' lajayob i t'an bajche' mi mejlel i yʌc' ti sajtyel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Cʌchʌl ti' pʌyʌyob majlel. Ti yʌc'ʌyob ti' wenta ñuc bʌ yumʌl Poncio Pilato bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Che' ñac jini Judas, jini tsa' bʌ yʌc'ʌ Jesús ti' c'ʌb i contrajob, ti yilʌ cha'an mi quejel i yʌc'ob ti sajtyel Jesús, ñoj ch'ʌjyem ti queji yubin. Ti' q'uextyʌ i pensal cha'an jini tsa' bʌ i cha'le. Ti' jop'o i sutquibeñob jini treinta sʌsʌc tyaq'uin tsa' bʌ i yʌq'ue ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ti' subeyob: Tic tyaja c mul cha'an ti cʌc'ʌ ti sajtyel juntiquil mach'ʌ ba'an i mul, che'en. Pero ti' jac'ʌyob: ¿Chucoch lojon c cha'an ma' wʌl? A bajñel a wenta jach a bʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Che' jini, Judas ti' choco jini tyaq'uin ti lum ya' ti' mal templo. Ti loq'ui majlel. Ti' jich' cʌchʌ i bʌ. Ti sajti. ");
INSERT INTO ctu76_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jini ñuc bʌ curajob ti' lotyoyob jini tyaq'uin. Ti yʌlʌyob: Mach wen mi la cotsan ti yajnib ofrenda como jiñʌch i tyojol winic cha'an ti ajq'ui ti sajtyel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ti wi'il ti' lajayob i t'an cha'an i c'ʌñe' jini tyaq'uin cha'an i mʌñe' lum ba' ch'ujbi i ch'ujñʌntyel ñumel jach bʌ muc' bʌ quixtyañujob tsa' bʌ sajti ya' ba'añob. Mi pejcʌntyel jini lum ti Campo del Alfarero. Jini yom i yʌl i lum ajmel p'ejt. ");
INSERT INTO ctu76_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pero c'ʌlʌ wale iliyi mi pejcantyel jini lum ti lum mʌñʌl bʌ ti tyaq'uin i tyojol winic. ");
INSERT INTO ctu76_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chʌ'ʌch ti ts'ʌctiyi i t'an jini tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix Jeremías bʌ i c'aba'. Ti yʌlʌ: Ti' cha' ch'ʌmʌyob jini treinta sʌsʌc tyaq'uin, jiñʌch i tyojol tsa' bʌ i wʌ alʌyob israelob mu' bʌ i yʌc'ob cha'an i tyojol juntiquil winic. ");
INSERT INTO ctu76_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ti' c'ʌñʌyob cha'an i mʌn lum mu' bʌ i pejcʌntyel ti' lum ajmel p'ejt, che' bajche' ti' subeyon lac Yum. Che' ti yʌlʌ Jeremías. ");
INSERT INTO ctu76_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ti pʌjyi majlel Jesús ti i tyojlel Pilato. Ti' c'ajtibe Jesús: ¿Jatyet ba ñuc bʌ yumʌlet i cha'an israelob? che'en. Jesús ti' jac'ʌ: Melelʌch bajche' ma' wʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Che' ñac jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob ti' jop'beyob i mul Jesús, mach'an chʌ bʌ yes ti' saj jac'ʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Che' jini, ti yʌlʌ Pilato: ¿Mach'a ba'an ma' wubin pejtyel chʌ bʌ yes chʌncol i yʌlob ti a contra? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ch'uj ñʌch'ʌl Jesús. Ma' chʌ bʌ ti yʌlʌ. Tyoj bʌc'ñʌjel ti queji yubin jini ñuc bʌ yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","I tyʌlelʌch che' ti yorojlel i q'uiñelel pascua jini ñuc bʌ yumʌl mi yʌc' ti colel juntiquil cʌchʌl bʌ winic. Mi yʌq'uen quixtyañujob i yajcan majchqui mi cojlel. ");
INSERT INTO ctu76_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ya' cʌchʌl juntiquil Barrabás bʌ i c'aba'. Wen cʌñʌl cha'an ti i simaronlel. ");
INSERT INTO ctu76_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Che' ya' much'quibilob quixtyañu Pilato ti' c'ajtibeyob: ¿Majchqui la' wom mij colbeñetla? ¿Jim ba Barrabás o jim ba Jesús mu' bʌ i pejcʌntyel ti Cristo jini yajcʌbil bʌ i cha'an Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Chʌ'ʌch ti yʌlʌ jini Pilato como yujil isujm tsa' jach i yʌc'ʌyob Jesús ti' c'ʌb cha'an ti' mich' q'ueleyob Jesús jini ñuc bʌ curajob cha'an i ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Che' ñac ya' tyo buchul Pilato ya' ba' mi' cha'len melojel i yijñam ti' choco tyʌlel t'an. Ti yʌlʌ: Mach yom chʌ bʌ ma' tyumben jini tyoj bʌ winic como sajmʌl tic ñajal an chʌ bʌ bʌbʌq'uen bʌ ti quilʌ cha'an ti caj jini winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob ti' wersa xiq'uiyob quixtyañujob cha'an i c'ajtin i cole' Barrabás, cha'an mi yʌjq'uel ti tsʌnsʌntyel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jini ñuc bʌ yumʌl ti' cha' c'ajtibeyob quixtyañujob: Ti jini cha'tiquil, ¿majchqui la' wom mi cʌc' ti colel? che'en. Ti' jac'ʌyob: Barrabás, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato ti' subeyob: ¿Chuquiyes la' wom mic tyumben jini Jesús mu' bʌ i pejcʌntyel ti Cristo? che'en. Ti' lu' jac'ʌyob: La' tsʌnsʌntic ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Che' jini, Pilato ti' subeyob: ¿Chucoch? ¿Chuqui ti simaronlel ti' cha'le? che'en. Pero ti cha' quejiyob ti c'am bʌ t'an. Ti yʌlʌyob: La' tsʌnsʌntic ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato ti' ña'tyʌ ma' chʌ bʌ yambʌ ch'ujbi i cha'len como ti utsi quejiyob ti más c'am bʌ t'an. Che' jini Pilato ti' xiq'ui juntiquil i ch'ʌmben tyʌlel ja'. Ti' poco i c'ʌb ti' tyojlel pejtyelel quixtyañu. Ti yʌlʌ: Mach c wentajic mi ti la' tsʌnsʌ jini winic mach'ʌ ba'an i mul. Ch'ʌmʌla ti la' bajñel wenta, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Quixtyañujob ti' lu' jac'ʌyob: An ti lojon c wenta yic'ot i wenta lojon c jiñʌjlel cha'an mi sajtyel jini winic, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Che' jini Pilato ti yʌc'ʌ ti colel Barrabás. Ti' xiq'ui ti jats'ol Jesús ti pʌchij am bʌ yic'ot tsucu tyaq'uin. Ti yʌc'ʌ ti c'ʌb soldadojob cha'an i tsʌnsañob ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Che' jini i soldadojob ñoj ñuc bʌ yumʌl ti' pʌyʌyob majlel Jesús ya' ti pat i yotyot. Ya' ti' much'quiyob i bʌ junmujch' soldadojob. Ya'an Jesús ti xiñil. ");
INSERT INTO ctu76_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ti' jochbeyob i pislel Jesús. Ti' xojbeyob chʌchʌc bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ti yʌq'ueyob i corona ti' jol jalʌl bʌ ti ch'ix yic'ot i tye'el jam ti ñoj bʌ i c'ʌb. Che' jini ti lolon ñocleyob ti yebal yoc Jesús che' bajche' ñuc i ye'tyel ti' p'isiyob. Ti' wen wajleyob. Ti yʌlʌyob: Ñoj ñuquet bʌ Yumʌl i cha'an israelob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ti' tyujbʌyob. Ti' chucuyob i tye'el jam am bʌ ti i c'ʌb. Ti' c'ʌñʌ i jats'beyob i jol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Che' ti ujti i wen wajleñob ti' cha' jochbeyob jini chʌchʌc bʌ pislel. Ti' cha' xojbeyob i pislel. Che' jini ti' pʌyʌyob majlel cha'an i tsʌnsan ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Che' chʌncol i pʌyob majlel Jesús ya' ti bij cha'an i tsʌnsañob ti cruz, ya' ti' tyajayob juntiquil winic Simón bʌ i c'aba' ch'oyol bʌ ti Cirene. Ti' xiq'uiyob cha'an i q'uechben majlel i cruzil Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ya' ti c'otiyob ti jump'ej bujtyʌl Gólgota bʌ i c'aba'. An i sujmlel i c'aba' mi yʌl ti lac t'an, che' yilal bajche' i bʌquel jolʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ti' jop'o i yʌq'ueñob Jesús i jape' vino xʌc'tyʌbil yic'ot ts'ac hiel bʌ i c'aba' cha'an i lʌmben ñoj wocol bʌ mu' bʌ quejel yubin che' mi sajtyel ti cruz. Che' ñac Jesús ti' mits'ti'i, mach'an ti' japʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Che' ñac ti ujti i joc'chocoñob ti cruz Jesús, jini soldadojob ti' pucbeyob i bʌ i pislel. Ti' cha'leyob yajcaya cha'an i ña'tyañob majchqui i cha'an mi majlel. Chʌ'ʌch ti' ts'ʌctiyi i t'an tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix. Ti wʌ alʌ: Mi quejel i cha'leñob yajcaya cha'an i pucbeñob i bʌ c pislel. Che' ti' tyaja ti t'an Jesús jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ya' ti buchleyob soldadojob cha'an i q'uelob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ya' ts'ijbubil t'an ti cruz ti chañelel i jol chuquiyes i mul. Ti yʌlʌ: Jiñʌch Jesús ñuc bʌ Yumʌl i cha'an israelob. Chʌ'ʌch ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ya' ti' joc'chocoyob cha'tiquil ajxujch'ob je'el. Juntiquil ti' ñoj Jesús, juntiquil ti' ts'ej. ");
INSERT INTO ctu76_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jini tsa' bʌ ñumiyob ti' wajleyob. Ti' pʌnts'uyob i jol. ");
INSERT INTO ctu76_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ti yʌlʌyob: Jatyet mu' bʌ a jeme' templo, mu' bʌ a cha' wa'chocon ti uxp'ej q'uin, cotyan a bʌ. Mi i yalobilet Dios, juben ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chʌ'ʌch je'el jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob, yic'ot fariseojob, yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob ti' lu' wajleyob. Ti' subuyob i bʌ: ");
INSERT INTO ctu76_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Jini ti' cotyʌyob yaño' bʌ pero i bajñel mach mejl i cotyan i bʌ. Jiñʌch ñuc bʌ Yumʌl cha'an israelob mi yʌl. Mi jiñʌch, la' jubic ti cruz. Che' jini mux lac ch'ujbin je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jini ti' subeyonla cha'an i yalobilʌch Dios. Ti yʌlʌ cha'an Dios mi' bej cotyan, che'en. Mi chʌ'ʌchi, la' i cotyan wale iliyi mi yom, che'ob. Chʌ'ʌch ti' lolon wajleyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jinic tyo jini ajxujch'ob ya' bʌ joc'olob ti cruz yic'ot ti' wajleyob je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Che' jini ti ic'ʌ pejtyelel mulawil c'ʌlʌ xinq'uinil c'ʌlʌ ti och an q'uin ti las tres. ");
INSERT INTO ctu76_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Che' yomox tyaj och an q'uin, wen c'am ti' cha'le t'an Jesús. Ti yʌlʌ: Elí, Elí, ¿lama sabactani? che'en. Mi yʌl ti lac t'an: C Dios, c Dios, ¿chucoch ti a cʌyʌyon? Che' mi yʌle' ti lac t'an. ");
INSERT INTO ctu76_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Che' ñac ti yubiyob cha'tiquil uxtiquil ya' bʌ añob, ti yʌlʌyob: Ubinla, chʌncox i pʌye' tyʌlel Elías, jini tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Juntiquil jini ya' bʌ añob ti wa' majli ti ajñel cha'an i ch'ʌm tyʌlel chʌyo'ja'. Ti' ts'aja ti paj bʌ vino. Che' jini ti' cʌchʌ ti ni' tye. Ti letsi ba'an Jesús cha'an i ts'u'e'. ");
INSERT INTO ctu76_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero jini yaño' bʌ ti yʌlʌyob: La' ajnic. La' lac pijtyan la quilan mi tyal Elías cha'an i cotyan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wen c'am ti' cha' cha'le t'an Jesús. Che' jini ti sajti. ");
INSERT INTO ctu76_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti jin jach bʌ ora jini colem bʌ pisil joc'ol bʌ ti templo ti tsijli ti xinil c'ʌlʌ ti chan c'ʌlʌ ti yebal. Ti ñumi yujquel lum. Ti jejmi colem tyun tyac. ");
INSERT INTO ctu76_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ti jajmi muconibʌl tyac ba' ch'ujñʌbil sajtyemo' bʌ. Cabʌl ti cha' cuxtiyi i bʌc'tyal tsa' bʌ sajtiyob tsa' bʌ ch'ujbiyob Dios che' max tyo ti sajtiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ti loq'uiyob majlel ba' ch'ujñʌbil che' ñac ti tyejchi loq'uel ba'an sajtyemo' bʌ Jesús. Ti majliyob ya' ti Jerusalén mu' bʌ i pejcʌntyel ti ch'ujul bʌ lum, ba' cabʌl ti' q'ueleyob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ya' wa'alob cha'an i q'uelob Jesús jini soldadojob yic'ot i capitán soldadojob. Cha'an ti' q'ueleyob yujquel lum yic'ot pejtyel chʌ bʌ ti ujti che' ti sajti Jesús ti wen quejiyob ti bʌq'uen. Ti yʌlʌyob: Melelʌch i Yalobil Dios jini winic, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ya'an cabʌl x'ixic chʌncol bʌ i ñajtyʌ q'uelob chʌ bʌ mi yujtyel. C'ʌlʌ Galilea ti' tsʌcleyob tyʌlel Jesús. Ti' we'sʌyob. Ti' cotyʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ya'an yic'otyob je'el jini María ch'oyol bʌ ti Magdala yic'ot María i ña' Jacobo yic'ot José yic'ot yambʌ x'ixic i ña' i yalobilob Zebedeo. ");
INSERT INTO ctu76_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Che' iq'uix quejel ti c'oti juntiquil rico bʌ winic ch'oyol bʌ ti Arimatea, José bʌ i c'aba'. Jini ti' tsʌcle majlel Jesús je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jini ti majli ya' ba'an Pilato cha'an i c'ajtiben i bʌc'tyal Jesús. Pilato ti' xiq'ui soldadojob cha'an i yʌq'ue'. ");
INSERT INTO ctu76_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José ti' ju'sʌ Jesús ti cruz. Ti' bʌc'ʌ ti sʌc bʌ bʌjq'uil. ");
INSERT INTO ctu76_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ti' ch'ujñʌ ya' ti tsiji' bʌ muconibʌl piq'uil bʌ ti mal colem tyun. I bajñel i cha'an José jini muconibʌl. Max tyo ba'an majch ti ch'ujñʌnti ya'i. Che' jini ti' ñolq'ui majlel colem tyun cha'an i mʌjquil i ti' ba' ti ch'ujñʌnti. Che' jini ti majli José. ");
INSERT INTO ctu76_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ya'añob María ch'oyol bʌ ti Magdala yic'ot jini yambʌ María buchulob ya' ti tyojel muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ti yijc'ʌlel che' tsa'ix ñumi i q'uinilel che' i tyʌlel ti lu' chajpʌyob chʌ bʌ yes jach mi quejel i c'ʌñob che' ti q'uinilel c'aj oj, jini ñuc bʌ curajob yic'ot fariseojob ti majliyob i pejcañob Pilato. ");
INSERT INTO ctu76_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ti yʌlʌyob: Ñuc bʌ yumʌlet, chʌncol lojon c cha' c'ajtisan chʌ bʌ ti yʌlʌ jini ajlot bʌ winic che' ñac cuxul tyo. Ti yʌlʌ che' mi ñumel uxp'ej q'uin mi quejel i tyejchel loq'uel ba'an sajtyemo' bʌ. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jin cha'an com lojon ma' xiq'ue' majlel soldadojob cha'an c'ʌlʌ uxp'ej q'uin mi' wen cʌñʌtyañob i muconibʌl Jesús ame majlicob ajcʌnt'añob i cha'an ti ac'bʌlel i xujch'iñob loq'uel i bʌc'tyal. Che' jini ti wi'il mi quejel i subeñob quixtyañujob cha'an ti tyejchi loq'uel ba'an sajtyemo' bʌ. Che' jini más tyo leco mi majlel jini lot che' bajche' ti ñaxan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato ti' subeyob: Umba'an soldadojob bajche' ti la' c'ajti. Cucula. Wen cʌñʌtyanla jini muconibʌl bajche' jach la' wom, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ti majliyob. Ti' wen ñup'uyob i ti' muconibʌl cha'an ñoj tsiquil mi an majch mi' tyʌle'. Che' jini, ya' ti' cʌyʌyob jini soldadojob cha'an i cʌñʌtyan je'el. ");
INSERT INTO ctu76_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tsa'ix ñumi i q'uinilel c'aj oj. Ti yijc'ʌlel jiñʌch jini ñaxan bʌ q'uin ti semana, che' yomox sʌc'an jini María ch'oyol bʌ ti Magdala yic'ot jini yambʌ María ti majli i q'uelob muconibʌl ba' ti ch'ujñʌnti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ti saj ora jach ti ñumi ñoj toñel bʌ i yujquel lum. Juntiquil ajtoñel i cha'an lac Yum ch'oyol bʌ ti panchan ti jubi tyʌlel wʌ ti mulawil. Ti c'oti ya' ba' ti ch'ujñʌnti Jesús. Ti' loc'sʌ jini wechel bʌ colem tyun tsa' bʌ mʌcʌ i ti' muconibʌl. Ya' ti buchle ti' pam colem tyun. ");
INSERT INTO ctu76_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jini ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan ñoj lemlaw ti q'uelol che' bajche' i c'ʌc'al chajc. Ñoj sʌsʌc i pislel che' bajche' i ña'al tsʌñal. ");
INSERT INTO ctu76_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tsiltsilña ti bʌq'uen jini soldadojob che' ñac ti yilʌyob jini ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan. Ti poj sajtiyob ti bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jini ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan ti' subeyob jini x'ixicob: Mach la' cha'len bʌq'uen. Cujil isujm chʌncol la' sʌclan Jesús tsa' bʌ tsʌnsʌnti ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pero ma'ix wʌ'an. Tsa'ix tyejchi loq'uel ba'an sajtyemo' bʌ bajche' ti wʌ alʌ. La'. Q'uelela ba' ti' sʌts' chocoyob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Cucula ti saj ora jach. Subenla ajcʌnt'añob i cha'an: Jini tsa' bʌ sajti ti cha' tyejchi loq'uel ba'an sajtyemo' bʌ. Mi quejel i majlel ti Galilea i pijtyañetla. Ya'i mi quejel la' cha' q'uele', che'etla. Jini tsa' bʌ c subeyetla jiñʌch bajche' yom la' subeñob, che'en. Che' ti subentiyob jini x'ixicob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Che' jini ti wa' majliyob x'ixicob. Añob i bʌq'uen pero c'ajacñayob i yoj je'el. Ajñel ti majli i suben ajcʌnt'añob i cha'an Jesús jini t'an tsa' bʌ subentiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Che' ñac añob ti bij ti saj ora jach ti' tsictiyi Jesús yic'otyob. Jesús ti yʌq'ueyob saludos. Che' jini, jini x'ixicob ti' lʌc'ʌyob Jesús. Ti ñocleyob ti yebal yoc Jesús. Ti' ch'ujutisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús ti' subeyob: Mach yom la' cha'len bʌq'uen. Cucula. Suben quermañujob cha'an yom i majlelob ya' ti Galilea. Ya'i mi quejel i q'ueloñob, che'etla mi la' subeñob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Che' chʌncol tyo i majlel x'ixicob ya' ti majliyob ti lum Jerusalén cha'tiquil uxtiquil jini soldadojob año' bʌ ti' wenta i cʌñʌtyan muconibʌl cha'an i lu' subeñob jini ñuc bʌ curajob ti pejtyelel chʌ bʌ yes ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jini ñuc bʌ curajob ti majliyob ba'an xñoxob año' bʌ i ye'tyel ba'an israelob cha'an i lajob i t'an cha'an chʌ bʌ yes yom i cha'leñob. Che' jini ti yʌq'ueyob soldadojob i yonlel tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ti' subeyob: Yom la' wʌle' ti ac'bʌlel che' wʌyʌletla ti c'oti ajcʌnt'añob i cha'an Jesús. Ti' xujch'ibeyob loq'uel i bʌc'tyal Jesús, che'etla. Che' yom la' wʌle', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mi ti yubi ili t'an jini ñuc bʌ yumʌl mux lojon c majlel c wen pejcan cha'an mach'an chʌ bʌ yes mi' tyumbeñetla, che'ob. Che' ti subenti soldadojob ti jini ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel ba'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Che' jini, jini soldadojob ti' ch'ʌmʌyob tyaq'uin. Ti majliyob i yʌle' bajche' ti subentiyob. C'ʌlʌ wale iliyi an chʌ'ʌch bʌ mi yʌlob jini israelo' bʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Che' jini, jini oncejob ajcʌnt'añob i cha'an Jesús ti majliyob ti Galilea. Ti letsiyob ti wits bajche' ti wʌ subentiyob. ");
INSERT INTO ctu76_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Che' ñac ti' q'ueleyob Jesús ti' ch'ujutisʌyob aunque cha'tiquil uxtiquil mach'an ti yoque ña'tyʌyob mi Jesúsʌch. ");
INSERT INTO ctu76_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús ti' lʌc'ʌyob: Ti' subeyob: Tsa'ix aq'uentiyon tic wenta pejtyelel chʌ bʌ yes an ti panchan yic'ot ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cucuxla ti pejtyelel pañimil tyac. Cʌntisañob ti pejtyelel quixtyañujob cha'an mi' q'uextyañob i pusic'al i tsʌcleñoñob majlel. Aq'uenla ch'ʌm ja' ti' c'aba' lac Tyat, ti' c'aba' i Yalobil, ti' c'aba' Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cʌntisañob cha'an i jac' pejtyelel chʌ bʌ tyac tic xiq'uetla la' cha'len. Ña'tyanla cha'an mi quejel cajñel la' wic'ot ti bele' ora c'ʌlʌ jintyo mi jilel mulawil. Che' ti yʌlʌ Jesús. Amén.");
INSERT INTO ctu76_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jiñʌch i tyejchibal jini wen bʌ t'an mu' bʌ i yʌc' ti cʌjñel Jesucristo i Yalobil Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jini tsa' bʌ i xiq'ui i yʌle' Dios, Isaías bʌ i c'aba' ti' wʌ ts'ujbu: Mic ñaxan xic' majlel cajsubt'an cha'an i chajpʌbeñet a bijlel. ");
INSERT INTO ctu76_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ti ubinti i t'an juntiquil mu' bʌ ti c'am bʌ t'an ya' ti tyʌquin bʌ joch lum. Mi yʌl: Tyoj isanla majlel i bijlel lac Yum. Pʌtbenla majlel tyoj bʌ i bijlel. Che' ti yʌlʌ Dios. Che' ts'ijbubil i cha'an Isaías. ");
INSERT INTO ctu76_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Che' jini, chʌ'ʌch ti queji ti troñel Juan ya' ti tyʌquin bʌ joch lum bajche' ti wʌ ajli. Ya' ti queji i subeñob cha'an yom i q'uextyan i pensal i cʌy i mul yic'ot i ch'ʌme' ja' cha'an mi ñusʌbentyelob i mul. ");
INSERT INTO ctu76_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ti lu' tyʌliyob ba'an Juan ch'oyolo' bʌ ti pañimil Judea bʌ i c'aba' yic'ot ti lum Jerusalén bʌ i c'aba' cha'an i ñʌch'tyʌbeñob i t'an. Che' ñac ti' subuyob i mul, Juan ti yʌq'ueyob ch'ʌm ja' ya' ti colem ja' Jordán bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","I pislel Juan melel ti' tsutsel camello yic'ot pʌchij bʌ i cinturón. Mu' bʌ i c'uxe' che' bʌ bajche' colem xtyopi' yilal yic'ot ya'lel chab. ");
INSERT INTO ctu76_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ti' subu t'an. Ti yʌlʌ: Tyal tyo tic pat juntiquil más p'ʌtyʌl bʌ bajche'on. Mach saj jasʌl c ñuclel mi cubin cha'an mic wutstyʌl c tic'ben i ch'ajñel i zapatos. ");
INSERT INTO ctu76_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Joñon mi cʌq'uetla ti ch'ʌm ja'. Tyal tyo mu' bʌ i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ i Ch'ujlel Dios. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ti jim bʌ ora ti tyʌli Jesús ya' bʌ loq'uem tyʌlel ti lum Nazaret bʌ i c'aba' ya' ti Galilea. Ti' ch'ʌmʌ ja' Jesús ti' c'ʌb Juan ya' ti Jordán ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Che' ti loq'ui ti ja' ti yilʌ Jesús ti jajmi ya' ti panchan. Ti jubi tyʌlei ti Jesús che' bajche' juncojt x'ujcutsu' yilal. Jiñʌch jini Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ti ubinti t'an loq'uem bʌ ti panchan tsa' bʌ yʌlʌ: Calobiletyʌch. Mic p'untyañet. C'ajacña coj cha'an ti jatyet. Che' ti subenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jini Ch'ujul bʌ i Ch'ujlel Dios ti' wa' pʌyʌ majlel Jesús ti tyʌquin bʌ joch lum. ");
INSERT INTO ctu76_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","I bajñel ya'an Jesús yic'ot matye'lel animal. Cuarenta quin ti jale ya'i. Satanás ti' jop'o i yʌsan ti mulil. Ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan ti tyʌli i cotyan Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Che' tsa'ix cʌjchi Juan ti cha' majli Jesús ya' ti Galilea. Chʌncol i sube' ñumel wen bʌ t'an cha'an i yumintyel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ti yʌlʌ: Tsa'ix ts'ʌctiyi i yorojlel. Lʌc'ʌlix i yorojlel mi quejel i yumintyel Dios. Q'uextyan la' pensal, cʌyʌ la' mul. Ch'ujbinla jini wen bʌ t'an cha'an la' cotyʌntyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Che' ñac chʌncol ti xʌmbal majlel Jesús ya' ti ti' colem joyol bʌ ja' Galilea bʌ i c'aba' ti yilʌ Simón yic'ot i yijts'in Andrés. Chʌncol i chocoyob ochel i chimol chʌy ya' ti colem ja' como ajchuc chʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús ti' subeyob: La', tsʌcleñon majlel. Che' bajche' ti la' sajcʌ chʌy mi quej cʌq'ueñetla la' sajcan quixtyañujob cha'an mi quej i ch'ujbiñob c t'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ti' wa' cʌyʌyob i chimol chʌy Simón yic'ot Andrés. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tsa' tyo i ts'itya' cha'le xʌmbal majlel. Ti queji i yilan Jacobo i yalobil Zebedeo yic'ot yijts'in Juan bʌ i c'aba'. Chʌncol i lʌwob i chimol chʌy ya' ti mal barco. ");
INSERT INTO ctu76_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Che' jini, ti' pʌyʌyob. Ti' cʌyʌyob i tyat Zebedeo bʌ i c'aba' yic'ot i barco yic'ot i yaj toñelob. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ti majliyob ti lum Capernaum bʌ i c'aba'. Ti i q'uinilel c'aj oj Jesús ti' cha'le cʌntisa ti i templo israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tyoj bʌc'ñʌjel ti yilʌyob quixtyañujob bajche' ti' cha'le cʌntisʌ Jesús como tsiquil añʌch i p'ʌtyʌlel i t'an. Mach chʌ'ic muc' ti cʌntisʌ bajche' ajcʌntisajob cha'an i mandar israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ya'an juntiquil winic ti' templo israelob tyʌc'lʌbil bʌ ti xiba. Ti oñel ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","¿Chucoch ma' tyʌlel wʌ' ba'añon lojon, Jesús ch'oyolet bʌ ti Nazaret? ¿Tsa' ba tyʌliyet a jisañon lojon? Much j cʌñet majchetqui. Cujil isujm jatyet jini ch'ujulet bʌ i cha'an Dios. Che' ti yʌlʌ jini xiba. ");
INSERT INTO ctu76_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús ti' tiq'ui jini xiba. Ti yʌlʌ: Lajmen ti t'an. Loq'uenix wʌ' ti ili winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jini xiba ti yʌc'ʌ ti jits'cuyel jini winic. Ti' cha'le c'am bʌ oñel. Che' jini ti loq'ui xiba ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tyoj bʌc'ñʌjelob ti yilʌ quixtyañujob. Ti queji i c'ajtibeñob i bʌ: ¿Chuquiyes ti t'an iliyi? ¿Chuqui ti tsiji' bʌ cʌntisa? che'ob. An I p'ʌtyʌlei i t'an jini winic, como jinic tyo mi' xiq'ue' xibajob. Mux i jac'ben i t'an je'el, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ti wa' pujqui i t'ʌñʌlel i cʌntisʌ Jesús ti' pettyʌlel Galilea. ");
INSERT INTO ctu76_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Che' ti loq'ui Jesús ti' templo israelob ti majli ti yotyot Simón yic'ot Andrés tyʌp'ʌl yic'ot Jacobo yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ya'an i nij'aña' Simón. Wen muc' ti c'ajc. Tyots'ol ti wʌyib. Ti' wa' subeyob Jesús cha'an c'am. ");
INSERT INTO ctu76_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Che' jini, Jesús ti majli i chucben i c'ʌb cha'an i tyejche'. Tsa'ix wa' lajmi ti c'ajc. Ti queji i we'sañob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Che' ti p'ʌjqui q'uin, ac'bʌlelix quejel ti queji i pʌyob majlel ya' ba'an Jesús pejtyel c'amo' tyac bʌ yic'ot tyʌc'lʌbilo' bʌ ti xiba. ");
INSERT INTO ctu76_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pejtyel quixtyañu ti' much'quiyob i bʌ ya' ti ti' otyot. ");
INSERT INTO ctu76_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ti' lajmisʌ cabʌl c'amo' bʌ an leco tyac bʌ i c'am'an. Ti' choco loq'uel cabʌl xibajob. Pero mach'an ti yʌc'ʌyob ti t'an como tsa'ix i cʌñʌyob majchqui Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Che' jal tyo mach sʌc'a ti tyejchi Jesús. Ti bajñel loq'ui majlel ti lum cha'an mi' cha'len oración. ");
INSERT INTO ctu76_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón yic'ot i pi'ʌlob ti majli i sʌclañob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ya' ti' tyajayob. Ti' subeyob: Pejtyel mi' pijtyañetyob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero Jesús ti' subeyob: Conla ti yambʌ lum, ya' ti lʌc'ʌl tyac cha'an mic cha'len subt'an je'el. Jin cha'an ti tyʌliyon, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ti ñumi ti subt'an ti' templo tyac israelob ya' ti' pettyʌlel Galilea. Ti' choco loq'uel cabʌl xibajob. ");
INSERT INTO ctu76_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ti' lʌc'ʌ Jesús juntiquil am bʌ chʌ bʌ yes pasem ti' pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Ti ñocle ti yebal yoc Jesús cha'an mi' c'ajtiben. Ti' sube: Mi a wom ch'ujbiyʌch a lajmisañon, che' ti subenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús ti' p'untyʌ cha'an yom i cotyan. Ti' tyʌlʌ. Ti yʌlʌ: Comʌch. La lajmiquet, che' yʌlol jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Saj ora ti lajmi. Wenix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús ti' sube cha'an majlic jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ti' wen sube: Q'uele ma' majch ma' saj suben. Cucu, pʌs'en a bʌ cura. Ya'i ma' wʌq'uen i majtyan Dios che' bajche' ti yʌlʌ Moisés ti mandar cha'an mi yilañob tsʌ'ʌch lajmiyet. Che' jini, mi' tsictiyel ti wutyob cha'an tsa'ix lajmiyet, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero jini winic ti majli. Ti queji i yʌle' ñumel tsa' bʌ ujti. Jin cha'an ma'ix ti mejli ti ochel Jesús ya' ti lum tyac che' mi' q'uelob. Ti ajni ya' ba' mach'an quixtyañu. Ti tyʌliyob ba'an Jesús tyʌlemo' bʌ ti pejtyel yambʌ lum tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jesús ti cha' ochi ya' ti Capernaum. Ti queji i yubiñob quixtyañu che' ya'an ti otyot. ");
INSERT INTO ctu76_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ti queji i wa' much'quiñob i bʌ. Ma' ti lu' ochiyob mi jinic tyo ti' ti' otyot. Che' jini, Jesús ti queji i subeñob i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Che' jini, chʌntiquil winic ti' pʌyʌyob tyʌlel ya' ba'an Jesús juntiquil winic mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ma' ti mejliyob ti ochel yic'otyob ti' mal como cʌlʌx an quixtyañu. Pamacña i jol jini otyot. Ti letsiyob i loc'sʌbeñob i xʌñil jini otyot cha'an tyocol ba' mi yotsañob jini c'am bʌ. Che' jini, ti' ju'sʌbeyob i yab jini c'am bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Che' ti yilʌ Jesús chʌncol i ch'ujbin ti' pusic'al, ti queji ti t'an. Ti' sube jini c'am bʌ: Calobil, ñusʌbilix a mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ya' buchul cha'tiquil uxtiquil ajcʌntisajob cha'an i mandar israelob. Chʌncol i yʌlob ti' pusic'al: ");
INSERT INTO ctu76_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Chucoch che' mu' ti t'an ili winic? Chʌncol jach i cuy i bʌ ti Dios. Ma'an majch ch'ujbi i ñusʌbeñonla lac mul, sólo jin jach Dios che'ob ti' pusic'al jini ajcʌntisajob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero Jesús ti' ña'tyʌ chʌ bʌ yes chʌncol yʌlob ti' pusic'al. Ti' subeyob: ¿Chucoch che' chʌncoletla ti t'an ti la' pusic'al bajche' jini? ");
INSERT INTO ctu76_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Baqui bʌ más wocol mic suben mi la' wʌl jini c'am bʌ? ¿Más wocol ba mic suben ñusʌbilix a mul? ¿Más wocol ba mic suben, tyejchenix, ch'ʌmʌx majlel a wab, cha'lenix xʌmbal? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʌ'ʌch mi la' wilan añʌch c p'ʌtyʌlel cha'an mic ñusʌbeñob i mul año' bʌ ti mulawil Joñon i Pi'ʌlon Quixtyañujob, che' ti yʌlʌ Jesús. Jesús ti' sube jini winic mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb: ");
INSERT INTO ctu76_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Mic subeñet: Tyejchen, ch'ʌmʌx majlel a wab, cucux ti a wotyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ti wa' tyejchi. Ti' ch'ʌmʌ majlel i yab. Ti loq'ui ya' ba'añob. Che' jini, tsijc' che'ob i pusic'al quixtyañujob. Ti' subeyob i ñuclel Dios. Ti yʌlʌyob: Ma' ba' la quila che' bajche' iliyi, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús ti cha' majli ti' ti' colem joyol bʌ ja'. Che' ñac ti' much'quiyob i bʌ ba'an Jesús ti pejtyelel quixtyañujob, ti' cʌntisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Che' ñac ti ñumi Jesús ti yilʌ ya' an winic Leví bʌ i c'aba' i yalobil Alfeo. Buchul ti ye'tyel i ch'ʌm tyojoñel. Jesús ti' sube: Tsʌcleñon majlel, che'en. Che' jini ti tyejchi. Ti' tsʌcle majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ti' cha'le uch'el Jesús ti yotyot Leví. Ya' buchulob je'el yic'ot Jesús yic'ot ajcʌnt'añob i cha'an cabʌl año' bʌ ye'tyel cha'an i ch'ʌmol tyojoñel yic'ot yambʌ xmulilob. Como cabʌl tsa' bʌ i tsʌcleyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jini ajcʌntisajob cha'an i mandar israelob yic'ot fariseojob ti yilʌyob chʌncol ti we'el Jesús yic'otyob tsa' bʌ i lolon alʌyob más año' bʌ i mul yic'ot xch'ʌm tyojoñelob. Che' jini, ti queji i subeñob ajcʌnt'añob i cha'an Jesús: ¿Bajche'qui isujm che' mi' pi'len ti we'el xch'ʌmob tyojoñel yic'ot yambʌ xmulilob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Che' ñac ti yubi Jesús, ti' subeyob: Jini c'oc'o' bʌ mach i c'ʌjnibal ts'ʌcʌntyel, jin jach c'amo' bʌ yom ts'ʌcʌntyel. Mach'an ti tyʌliyon c pʌyob jini mu' bʌ i lolon alob mach'an i mul. Ti tyʌliyon c pʌyob jini mu' bʌ i ña'tyan an i mul. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ti' cha'leyob ch'ajb cha'an mu' bʌ i c'uxob jini tsa' bʌ i cʌmbeyob i t'an Juan yic'ot fariseojob. Junyaj che' muc'ob ti ch'ajb cha'tiquil uxtiquil ti tyʌliyob ba'an Jesús. Ti' c'ajtibeyob: ¿Chucoch mi' cha'leñob ch'ajb jini tsa' bʌ i cʌmbeyob i t'an Juan yic'ot tsa' bʌ i cʌmbeyob i t'an fariseojob pero mach'an mi' cha'leñob ch'ajb jini ajcʌnt'añob a cha'an? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús ti' jac'ʌ: ¿Mu' ba i cha'leñob ch'ajb cha'an mu' bʌ i c'uxob, mu' bʌ i japob jini mu' bʌ i tyʌlelob i q'uel q'uiñejel che' mi yujtyel ñujpuñel che' ya' tyo an yic'otyob ajñujpuñel? Mach'an mi' poj cʌyob uch'el che' ya' tyo an ajñujpuñel. ");
INSERT INTO ctu76_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero tyal tyo i yorojlel mi' pʌjyel loq'uel ajñujpuñel ti' tyojlel quixtyañujob. Che' jini, mi quejel i ch'ajbañob i bʌ ti yan tyo bʌ q'uin, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ti yambʌ lajoñel ti yʌlʌ: Mach yom c'ʌjñel tsiji' bʌ pisil cha'an i lʌjwe' tsuculix bʌ i pislel. Muc' jach i cha' tsijlel loq'uel jini tsijib tyo bʌ che' mi com'an. Che' jini más colemix mi loq'uel i tsijlemal. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ti yambʌ lajoñel ti yʌlʌ: Mach yom cojlic ochel ti tsucul pʌchij bʌ yajnib vino che' chʌncol tyo i mejlel jini vino bʌ lembal. Como jini vino mi yʌc' ti tyojmel jini tsucul pʌchij bʌ yajnib. Che' jini, mi bejquel. Mi' tyojmel yajnib. Mi yotsañob tsijib vino ti tsijib tyo bʌ yajnib. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ti jump'ej i q'uinilel c'aj oj ti ñumi majlel Jesús ti' mal trigojol yic'ot ajcʌnt'añob i cha'an. Jini ajcʌnt'añob ti' tyuc'uyob i wut jini trigo che' bʌ bajche' arroz yilal che' ti ñumiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Che' jini, fariseojob ti queji i subeñob Jesús: ¿Chucoch mi' cha'len tiq'uil bʌ che' ti q'uinilel c'aj oj? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesús ti' jac'beyob: ¿Mach'a ba'an ti la' q'uele ya' ti jun bajche' ti' cha'le David ti ñoj oniyix che' ñac ti yubiyob wi'ñal David yic'ot i pi'ʌlob? ");
INSERT INTO ctu76_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Che' ñac ñuc bʌ cura i cha'an israelob jini Abiatar bʌ i c'aba', David ti ochi ti' templo Dios. Ti' c'uxu jini waj tsa' bʌ ajq'ui ti mesa tsa' bʌ i yʌq'ueyob ti' majtyan Dios. Tiq'uil cha'an ma' majch mi' c'uxe' jini waj, jin jach am bʌ i ye'tyel ti' templo Dios mi' c'uxe'. David ti' c'uxu. Ti yʌq'ue i pi'ʌlob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Che' je'el ti' subeyob: Cha'añobʌch i wenlel quixtyañujob ti ajq'ui i q'uinilel c'aj oj. Mach'an ti ajq'ui quixtyañujob ti mulawil cha'an i más ac'ob ti ñuc i q'uinilel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jin cha'an joñoñʌch i Pi'ʌlon Quixtyañujob an tic wenta cʌle' chʌ bʌ yom ujtic ti i q'uinilel c'aj oj. Che' ti yʌlʌ Jesús como i yʌc'bal. ");
INSERT INTO ctu76_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ti cha' ochi Jesús ti' templo israelob. Ya'an juntiquil winic tyʌquin bʌ junts'ijt i c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jini quixtyañujob yom i jop'beñob i mul Jesús. Jin cha'an ti queji i wen q'uelob mi muc'ʌch i lajmisan che' ti q'uinilel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Che' jini, Jesús ti' sube jini winic tyʌquin bʌ i c'ʌb: La' ti wa'tyʌl ti' tyojel lojon c wut, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Che' jini, ti queji i subeñob jini yaño' bʌ: ¿Baqui bʌ yom lac cha'len ti q'uinilel c'aj oj? ¿Yom ba wen mi lac cha'len o mach wen? ¿Yom ba mi laj cotyan juntiquil cha'an mach sajtic, o yom lac tsʌnsan? Che' ti yʌlʌ Jesús. Ch'uj ñʌch'ʌl ti cʌyleyob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús mich' ti yilʌ jini ya' bʌ jomolob. Ñoj ch'ʌjyem ti yubi como ti' ña'tyʌ tsʌtsob i pusic'al. Ti' sube jini winic: Sʌts'ʌ a c'ʌb, che'en. Che' jini, ti' sʌts'ʌ i c'ʌb. Wenix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jini fariseojob ti loq'uiyob majlel. Ti' much'quiyob i bʌ yic'ot yambʌ junmujch' herodianojob bʌ i c'aba'. Ti queji i motin ña'tyañob bajche' ch'ujbi i tsʌnsañob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Che' jini, Jesús ti loq'ui majlel. Ti majli ti' ti' colem joyol bʌ ja' yic'ot ajcʌnt'añob i cha'an. Cabʌl quixtyañu ya' bʌ chumulob ti Galilea ti' tsʌcleyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Che' ñac ti yubiyob ñuc tyac bʌ chʌncol i cha'len Jesús cabʌl ti tyʌliyob i q'uele'. Ti tyʌliyob ya' bʌ loq'uemob ti pañimil Judea bʌ i c'aba', ti lum Jerusalén bʌ i c'aba', ti pañimil Idumea bʌ i c'aba', ti junxej ja' Jordán bʌ i c'aba' yic'ot ti yalo' lum tyac ya' ti' t'ejl lum Tiro yic'ot Sidón bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Che' jini, Jesús ti' sube ajcʌnt'añob i cha'an cha'an i cʌybentyel jump'ej barco ba' mi quejel i yochel como cabʌl quixtyañu mi' pets'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Como Jesús ti' lajmisʌ cabʌlob. Jin cha'an pejtyel año' bʌ i c'am'an yomob i wersa jajp'iñob ochel i bʌ ba'an Jesús cha'an yomob i tyʌle'. ");
INSERT INTO ctu76_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Che' ñac ti yilʌyob Jesús, jini tyʌc'lʌbilo' bʌ ti xiba ti ñocleyob ti' t'ejl. Ti c'am bʌ t'an ti yʌlʌyob: Jatyet i Yalobilet bʌ Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús tsʌts ti' tiq'ui jini xibajob cha'an mach yom i yubin Jesús che' xibajob mi yʌc' ti cʌjñel. ");
INSERT INTO ctu76_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ti wi'il Jesús ti letsi majlel ti wits. Ti' pʌyʌ jini yom bʌ i yajcan cha'an majlic yic'ot. Ti tyʌliyob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ti yajcʌ doce winicob cha'an i pi'leñob ti xʌmbal cha'an i wa'chocoñob ti ye'tyel cha'an mi majlelob ti subt'an. ");
INSERT INTO ctu76_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ti yʌq'ueyob i p'ʌtyʌlel cha'an mi' lajmisan xc'am'añob yic'ot cha'an mi' chocob loq'uel xibajob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jiñobʌch i c'aba' jini docejob: Simón jini cha'chajp bʌ i c'aba' Pedro bʌ mi yʌjlel je'el. ");
INSERT INTO ctu76_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo i yalobil Zebedeo yic'ot Juan i yijts'in Jacobo tsa' bʌ i yotsʌbeyob i yʌlas c'aba' Boanerges, i sujmlel ti lac t'an che' bajche' i t'an chajc bʌ winic, ");
INSERT INTO ctu76_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","yic'ot Andrés yic'ot Felipe yic'ot Bartolomé yic'ot Mateo yic'ot Tomás yic'ot Jacobo i yalobil Alfeo, yic'ot Tadeo yic'ot Simón ch'oyol bʌ ba'an junmujch' cananistajob bʌ i c'aba', ");
INSERT INTO ctu76_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yic'ot Judas Iscariote, jini mu' bʌ quejel i yʌc' ti cʌchol Jesús. Wi'il ti ochiyob ti jump'ej otyot Jesús yic'ot ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ti' cha' much'quiyob i bʌ yonlel quixtyañujob mi jinic tyo ma'ix ti mejliyob ti uch'el Jesús yic'ot jini docejob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Che' ñac ti yubiyob i pi'ʌlob Jesús ti tyʌliyob cha'an i pʌyob loq'uel cha'an i cotyan como ti yʌlʌyob: Sojquemix i jol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jini ajcʌntisajob cha'an i mandar israelob ch'oyolo' bʌ ti Jerusalén ti lolon alʌyob: An i yajaw xiba mu' bʌ i pejcʌntyel ti Beelzebú bʌ i c'aba' ti' pusic'al Jesús, che'ob. Ti' p'ʌtyʌlel jach Beelzebú mi' choc loq'uel xibajob. Che' ti lon alʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jin cha'an Jesús ti' pʌyʌ tyʌlel jini quixtyañujob. Ti' cʌntisʌyob ti lajoñel tyac. Ti yʌlʌ: ¿Ch'ujbi ba i bajñel choc loq'uel i bʌ Satanás? Mach ch'ujbi. ");
INSERT INTO ctu76_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Mi ti queji i t'oxob i bʌ año' bʌ ti' wenta juntiquil yumʌl mi ti queji i periyalin i bʌ mi quejel i lajmisʌntyel i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mi ti quejiyob ti periyal año' bʌ ti jump'ej otyot, mach jaleyob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chʌ'ʌch Satanás je'el mach ch'ujbi i bajñel choc loq'uel i bʌ. Mi tsa'qui queji i periyalin i bʌ mach jale. Mi quejel i jilel i p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ma' majch ch'ujbi i yochel ti yotyot p'ʌtyʌl bʌ winic i chilben chʌ bʌ an i cha'an. Jin jach mi ti' ñaxan cʌchʌ, ch'ujbi i yochel i chilben chʌ bʌ an i cha'an ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Melel mic subeñetla, ch'ujbiyʌch i lu' ñusʌbentyelob pejtyel i mul quixtyañu yic'ot pejtyel mach'ʌ wen bʌ t'an mu' bʌ i cha'len ti' contra i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero mi an majch mi' cha'len leco bʌ t'an ti' contra Ch'ujul bʌ i Ch'ujlel Dios, che' mi yʌl cha'an ti' p'ʌtyʌlel xiba ti' cha'le jini tsa' bʌ i cha'le Ch'ujul bʌ i Ch'ujlel Dios mach ch'ujbi i ñusʌbentyel i mul. Ti bele' q'uin añʌch i mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Chʌ'ʌch ti yʌlʌ Jesús cha'an ti lolon alʌyob an xiba yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ti jumuc'lel ti c'oti i ña' yic'ot i yijts'iñob Jesús. Ya' ti cʌyleyob ti pañimil. Ti' xiq'uiyob ti pʌyol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Quixtyañujob ya' bʌ buchulob ti' suttyʌlel Jesús ti' subeyob: Ya' añob ti pañimil a ña' yic'ot a wijts'iñob. Chʌncol i sʌclañetyob. Che' ti subenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús ti' jac'beyob: ¿Majchqui jini c ña', quijts'iñob mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ti' lu' sut q'uele jini ya' bʌ buchulob. Ti yʌlʌ: Q'uelela ilayi c ña'etla, quijts'iñetla yubil. ");
INSERT INTO ctu76_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Como majchical jach mu' bʌ i cha'len bajche' yom i pusic'al Dios, jiñʌch quijts'in, jiñʌch c ña' yubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ti cha' queji ti cʌntisa Jesús ya' ti' ti' colem joyol bʌ ja'. Yonlel quixtyañu ti' much'quiyob i bʌ ya' ba'an Jesús. Cha'an yonlel quixtyañu Jesús ti ochi ti buchtyʌl ti barco am bʌ ti ja'. Pejtyel quixtyañu ti cʌyleyob ya' ti' ti' ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ti' cʌntisʌyob ti cabʌl lajoñel tyac. Ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ubinla. Ti loq'ui majlel juntiquil winic ti p'ujp'ujya pac'. ");
INSERT INTO ctu76_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Che' ñac ti' p'ujp'uj majlel jini pac' ti yajli ts'itya' ya' ti bij. Ti tyʌliyob xma'tye'mut. Ti' lu' buc'u tsa' bʌ p'ajti ti bij. ");
INSERT INTO ctu76_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yambʌ ti yajli ti pam xajolel ba' ma' tyam i lumil. Saj ora ti pasi, che' cu mach'an tyam i lumil. ");
INSERT INTO ctu76_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Che' ti pasi q'uin i ticwʌlel q'uin ti yubi. Ti tyʌqui che' cu mach'an tyam ochem i wi'. ");
INSERT INTO ctu76_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yambʌ ti p'ajti cʌytyʌl ti mal ch'ixol. Che' ti wen coli jini ch'ixol ti' yebajli jini pac'. Mach'an ti yʌc'ʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yambʌ ti yajli ba' wen bʌ lum. Ti pasi. Tsʌ'ʌch coli. Tsʌ'ʌch wen yʌc'ʌ i wut. Jujump'ej i bʌc' ti yʌc'ʌ treinta i wut, yambʌ sesenta, yambʌ cien. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ti yʌlʌ: Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalinla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Che' ñac ti bajñel cʌyleyob, ti queji i c'ajtibeñob Jesús i sujmlel jini lajoñel tyac jini ya' bʌ jomolob, yic'ot jini mu' bʌ i pejcʌntyelob ti docejob. ");
INSERT INTO ctu76_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús ti' subeyob: Ti aq'uentiyetla la' ch'ʌmben i sujmlel bajche' mi' cha'len yumʌl Dios mach'ʌ bʌ an tsictiyem ti yambʌ ora. Pero jini mach'ʌ ba'an ochemob mi cʌntisʌntyelob ti lajoñel tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Che' mic subeñob aunque mi' ch'uj ilañob pero che' bajche' ma' mi' c'otyelob i wut mi' cha'len. Aunque mi yubin c t'an pero ma'ix mi' ch'ʌmbeñob isujm. Che' bajche' ma' chʌ bʌ ti yubiyob mi' cha'len ame i cʌyobic i mul ame ñusʌbenticob i mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ti' c'ajtibeyob: ¿Mach'a ba'an mi la' ch'ʌmben isujm jini lajoñel? ¿Bajche'qui mi quej la' ch'ʌmben isujm pejtyel yambʌ lajoñel che' jini? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Jini tsa' bʌ majli ti p'ujp'uya pac' ti lajoñel jiñʌch che' an majch mi' cha'len subt'an. ");
INSERT INTO ctu76_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jini tsa' bʌ p'ajti ti bij jiñʌch bajche' quixtyañu mu' bʌ i subentyelob jini wen bʌ t'an. Che' ubibilob i cha'an jini t'an, mi' wa' tyʌlel Satanás. Mi' loc'sʌben ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chʌ'ʌch je'el tsa' bʌ yajli ti xajolel. Che' mi yubiñob jini wen bʌ t'an ñoj yomajax i ch'ujbiñob. ");
INSERT INTO ctu76_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mach'an i wi' ti' pusic'al. Jin cha'an ma' mi jalejel. Pero che' mi ts'itya' ubin wocol o che' mi yʌl'entyel cha'an ti' ch'ujbi jini wen bʌ t'an, mi cha' ñajʌyel ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jini yambʌ pac' tsa' bʌ p'ujp'uyi ti mal ch'ixol jiñʌch che' bajche' mu' bʌ i yubiñob jini wen bʌ t'an, ");
INSERT INTO ctu76_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero mi' bej pensalin i cha'an jach bʌ mulawil. Yic'ot tijicña mi lolon yubin che' an cabʌl chʌ bʌ an i cha'an, yic'ot bej niq'ui yom tyo cabʌl yan tyac bʌ. Pejtyel jini mi' yebajlin jini wen bʌ t'an cha'an ma' mi yʌc' i wut. ");
INSERT INTO ctu76_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jini p'ujp'ubil bʌ ti wen bʌ lum, jiñobʌch che' bajche' mu' bʌ i wen ubiñob jini t'an. Mi' wen ch'ujbiñob. Mi' wen ac'ob i wut. An mu' bʌ i yʌc' i wut ti treinta, ti sesenta, o ti cien. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús ti' subeyob yambʌ t'an. Ti yʌlʌ: ¿Mu' ba la' ts'ʌbe' pat cas cha'an la' ñup' ti chiquib o mi la' wʌc' ti yebal wʌyibʌl? Mach'an. Mi la' joc'chocon ti' joc'lib cha'an mi tsictiyel i c'ʌc'al. ");
INSERT INTO ctu76_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Mach'an chʌ bʌ mucul tyac mach'ʌ ba'an mi wi'il tsictiyel. Pejtyel mach'ʌ ba'an tsictisʌbil muc'ʌch i quejel i lu' tsictisʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalinla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús ti' subeyob yambʌ t'an. Ti yʌlʌ: Wen ña'tyanla mu' bʌ la' wubin. Chʌ'ʌch yonlel bajche' mi la' wʌq'uen la' pi'ʌlob, chʌ'ʌch yonlel mi quejel i yʌq'ueñetla Dios. Más on mi quej la' wʌq'uentyel jatyetla mu' bʌ la' wubin ili t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jini mu' bʌ i ch'ʌmben i sujmlel i t'an Dios, mi quejel i yʌq'uentyel ti Dios i más ch'ʌmben isujm. Pero jini mach'ʌ yom yubin c t'an mi quejel i chilbentyel loq'uel ti' pusic'al jini ts'itya' tyac tsa' bʌ i cʌñʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús ti yʌlʌ: Ti lajoñel chʌ'ʌch an i yumintyel Dios bajche' winic tsa' bʌ i p'ujp'uj pac' ti lum. ");
INSERT INTO ctu76_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Che' jini mi wʌyel, mi cha' p'ixel. Chʌ'ʌch mi ñusan q'uin yic'ot ac'bʌlel. Jini pʌc'ʌlix bʌ ti bots'ʌ, ti coli. Jini winic mach'an mi' ña'tyan bajche' chʌncol i colel majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jiñʌch jini lum mi yʌc' ti colel pʌc'ʌbʌl. Ñaxan mi pasel i yopol. Che' jini mi colel i tye'el, wi'ilix mi yʌc' t'uñul bʌ i wut ya' ti nich. ");
INSERT INTO ctu76_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Che' c'ʌnix i wut, jini winic mi majlel i c'aje' como i yorojlelix i lojtyel. Che' ti' cha'le cʌntisa Jesús cha'an i yumintyel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús ti' subu yambʌ t'an je'el. Ti yʌlʌ: ¿Chuquiyes yic'ot mi lac laje' i yumintyel Dios? ¿Bajche'qui yom lac laje'? ");
INSERT INTO ctu76_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ch'ujbi lac laje' yic'ot i bʌc' mostaza. Che' mi p'ujp'untyel ti lum, jiñʌch más i saj bʌ bajche' pejtyel i bʌc' pimel. ");
INSERT INTO ctu76_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Che' p'ujp'ubilix, más colem mi colel bajche' yan tyac bʌ pimel c'uxbil tyac bʌ i yopol. Colem mi yʌc' i xʌc' tyac. Ch'ujbi i mel i c'u' xma'tye'mut ya' ti' c'ʌb. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chʌ'ʌch bajche' iliyi, Jesús ti' subeyob t'an ti cabʌl lajoñel tyac, i p'isol jach bajche' ti mejli i ña'tyañob. ");
INSERT INTO ctu76_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Puro ti lajoñel jach ti' cʌntisʌyob quixtyañujob. Che' i bajñel jach ya' añob yic'ot ajcʌnt'añob i cha'an ti' wen tsictisʌbeyob i sujmlel. ");
INSERT INTO ctu76_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ti jim bʌ q'uin ti ic'an ti queji i subeñob ajcʌnt'añob i cha'an: La' c'axiconla ti junwej ja', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jesús ti' subeyob majlel jini quixtyañujob. Che' jini, jini ajcʌnt'añob i cha'an ti' wa' pʌyʌyob majlel Jesús ti barco. Ti majli yic'otyob yambʌ yalo' barco tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Che' jini ti queji toñel bʌ ic' ya' ti ja'. Ti queji i wets' ochel ja' ya' ti' mal barco jini ic' jintyo yomox bujt'el ti ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wʌyʌl Jesús. Tyots'ol ti' c'ʌnjol ya' ti' xujc barco. Ti queji i p'ixtisañob. Ti quejiyob i subeñob: Maestro, ¿bajche'qui a wʌlʌ mi ti jiliyonla? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Che' jini ti tyejchi Jesús. Ti queji i tiq'ue' jini ic'. Ti' sube jini ja': Ch'ʌbix, ñʌch'lejen, che' ti' sube. Ti wa' lajmi ic'. Ñoj ñʌch'ʌlix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús ti' sube ajcʌnt'añob i cha'an: ¿Chucoch muq'uetla ti bʌq'uen? ¿Chucoch ma' mi la' ch'ujbin? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wen chʌncolob ti bʌq'uen. Ti queji i subeñob i bʌ: ¿Majchqui wale jini che' mi ch'ujbiben i t'an jinic tyo ic' yic'ot ja'? Che' ti yʌlʌyob jini ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ti ñumiyob majlel ti junwej ja'. Ti c'otiyob ti lum Gadara bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Che' ñac ti loq'ui ti barco Jesús, juntiquil winic tyʌc'lʌbil ti xiba ti loq'ui ya' ti ch'ujñʌjibʌl. ");
INSERT INTO ctu76_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jini winic ya' jachix chumul ti ch'ujnijibʌl. Ma' majch ch'ujbi i cʌche'. Mi yic'otic cadena ch'ujbi i cʌchob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Cabʌl ti' jop'o i cʌchob ti cadena ti yoc ti' c'ʌb. Tsʌ'ʌch i tyuc'u jini am bʌ ti c'ʌb, ti' tyop'o jini am bʌ ti yoc. Mach'an majch ch'ujbi i yutsbin. ");
INSERT INTO ctu76_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti bele' q'uin ti q'uinil ti ac'bʌlel mu' ti oñel ñumel ti wits yic'ot ya' ba' mi yujtyel mucoñel. Mi' low i bʌ ti tyun. ");
INSERT INTO ctu76_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Che' ti' ñajtyʌ ilʌ Jesús ti tyʌli ti ajñel. Ti c'oti ti ñoctyʌl ti' tyojlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","C'am ti queji i pejcan. Ti yʌlʌ: ¿Chuqui a wom awic'otyon Jesús, jatyet i Yalobilet jini ñoj ñuc bʌ Dios? Mic wersa c'ajtibeñet ti Dios cha'an mach a tyʌc'lañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chʌ'ʌch ti yʌlʌ como poj ujtyel i suben Jesús jini xiba: Xiba, loq'uen wʌ' ti' pusic'al ili winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús ti' c'ajtibe: ¿Chuquiyes a c'aba' che' yic'ot? Jini xiba ti' jac'ʌ: Legión j c'aba' joñon como yonlelon lojon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chʌncol i wersa c'ajtiben Jesús cha'an mach i choc loq'uel ya' ti' lumal gadarenojob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ya' ti yebal wits chʌncol ti buc'bal yonlel chityam. ");
INSERT INTO ctu76_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jini xibajob ti' c'ajtibe Jesús: Xiq'uiyon lojon majlel ya' ba'an chityam. Ac'ʌyon lojon ochel ti chityam, che' ti yʌlʌ jini xibajob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Che' jini, Jesús tsʌ'ʌch i yʌc'ʌ yochel. Ti wa' loq'uiyob jini xibajob ti ili winic. Ti wa' ochiyob ti chityam. I yonlelob jini chityam. Che' bajche' dos mil ya' añob. Che' jini ti jubiyob majlel ti ajñel ti queptyʌl. Ti' chocoyob ochel i bʌ ti mal ja'. Che' jini ya' ti' jic'tyʌyob ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jini tsa' bʌ i cʌñʌtyʌ chityam ti puts'iyob. Ti queji i yʌlob ñumel ya' ti lum, yic'ot ya' ti otyotyel tyac. Che' jini, jini quixtyañujob ti majli i q'uelob chuqui ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Che' ñac ti c'otyiyob ya' ba'an Jesús ti yilʌyob jini tsa' bʌ tyʌc'lʌnti ti xibajob ch'uj buchul, anix i pislel, tyojix i pusic'al. Ti wen quejiyob ti bʌq'uen quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jini tsa' bʌ i yilʌyob ti queji i cha' alob bajche' ti tyoj'ʌ jini tsa' bʌ tyʌc'lʌnti ti xibajob yic'ot bajche' ti ujti jini chityam. ");
INSERT INTO ctu76_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Che' jini ti queji i wersa subeñob Jesús cha'an loq'uiquix majlel ya' ti' lum. ");
INSERT INTO ctu76_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Che' ñac ti ochi ti mali barco Jesús, jini tsa' bʌ tyʌc'lʌnti ti xibajob ti' sube Jesús mi mux i yʌq'uen i majlel yic'ot je'el. ");
INSERT INTO ctu76_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesús mach'an ti yʌq'ue i majlel. Pero ti' sube: Cucux ti a wotyot ya' ba'an a pi'ʌlob. Subeñob pejtyel bajche' ti cha'libeyet ñuc tyac bʌ a Yum Dios yic'ot bajche' ti' p'untyʌyet. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ti majli jini winic. Ti queji i puc majlel t'an ya' ti lum tyac Decápolis bʌ i c'aba'. Ti queji i sube' pejtyel bajche' ti cotyʌnti ti Jesús. Tsijc' che'ob i pusic'al ti pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Che' ñac ti cha' c'axi tyʌlel ti barco Jesús ya' ti junwej ja' ti wen c'otiyob quixtyañu. Ti cʌyle Jesús ya' ti' ti' ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ti tyʌli juntiquil ñuc bʌ ye'tyel ti' templo israelob Jairo bʌ i c'aba'. Che' ñac ti yilʌ Jesús ti wa' ñocle ti yebal yoc. ");
INSERT INTO ctu76_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ti queji i wersa suben: Jini xc'alʌl bʌ calobil yomox sajtyel. La'. Ac'ʌ a c'ʌb ti' pam i bʌc'tyal cha'an c'oc'ac. Che' ti yʌlʌ Jairo. ");
INSERT INTO ctu76_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús ti majli yic'ot. Che' jini ti' tsʌcleyob majlel yonlel quixtyañu. Motin much'ch'uc'ñayob majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ya'an yic'otyob juntiquil c'am bʌ x'ixic. C'ʌlʌ doce años ma' mi lajmel ti loq'uel i ch'ich'el. ");
INSERT INTO ctu76_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Cabʌl ti' jop'o i ts'ʌcan yujilo' bʌ ts'acojel. Ti' lu' jili pejtyel chʌ bʌ an i cha'an cha'an i c'ʌn i tyoje' i ts'ʌcʌntyel. Mach'an ti saj lajmi. Ti más nijli. ");
INSERT INTO ctu76_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ti queji i yubin bajche' chʌncol i cha'len Jesús. Che' jini ti tyʌli ti' pat Jesús ya' ba' much'quibil quixtyañujob. Ti' tyʌlbe i pislel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ti' bajñel ña'tyʌ: Mi jin jach i pislel mic tyʌlben, jasʌl mic lajmel. Che' ti' ña'tyʌ jini c'am bʌ x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ti wa' lajmi ti loq'uel i ch'ich'el. Ti yubi lajmenix i bʌc'tyal. ");
INSERT INTO ctu76_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ti' wa' ña'tyʌ Jesús cha'an ti c'ʌjni i p'ʌtyʌlel cha'an i lajmisan c'am bʌ. Ti' wa' sutqui i bʌ ya' ba' jomol quixtyañujob. Ti yʌlʌ: ¿Majchqui ti' tyʌlbon c pislel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Che' jini, ajcʌnt'añob i cha'an ti' sube: Ma' wilan cabʌl wʌ' añonla. Cabʌl mi' pets'etyob. ¿Chucoch mi a c'ajtin majchqui tsa' bʌ i tyʌlʌyet? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús ti' sut q'uele majchqui tsa' bʌ i tyʌlbe i pislel. ");
INSERT INTO ctu76_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jini x'ixic tsitsiña ti bʌq'uen. Tsa'ix i ña'tyʌ chʌ bʌ ti yubi ti' bʌc'tyal. Ti ñocle ti yebal yoc Jesús. Ti' lu' tsictisʌ chʌ bʌ yes ti yubi. ");
INSERT INTO ctu76_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús ti' sube: Calobil, ti lajmiyet cha'an ti a ch'ujbiyon ti a pusic'al. Cucux ti ñʌch'tyʌlel a pusic'al. C'oq'uet mi quejel a cʌytyʌl. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Che' chʌncol tyo ti t'an Jesús ti tyʌli ch'oyol bʌ ti yotyot am bʌ ye'tyel ti' templo israelob. Ti' subeyob i tyat jini xc'alʌl: Sajtyemix a walobil. ¿Chutyoquiyoch ma' chʌc mʌctyʌben i q'uin jini Maestro? Che' yʌlol Jairo. ");
INSERT INTO ctu76_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús che' bajche' mach'an ti yubi chʌncol bʌ i yʌlob ti' cha'le. Ti' sube jini am bʌ ye'tyel ti templo: Mach a cha'len bʌq'uen. Ch'ujbiñon ti a pusic'al, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Che' jini, jin jach Pedro yic'ot Jacobo yic'ot Juan i yijts'in Jacobo ti yʌc'ʌ majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ya' ti c'otiyob ti yotyot am bʌ ye'tyel ti' templo israelob. Ti wa'le i q'uele' ya' ba' ju'upojolob quixtyañu. Muc'ob ti uq'uel, ti oñel. ");
INSERT INTO ctu76_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ti ochi Jesús. Ti' c'ajtibeyob: ¿Chucoch ju'upojoletla? ¿Chucoch muq'uetla ti uq'uel? Mach'an sajtyem. Wʌyʌl jach ili xc'alʌl. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Che' jini ti' wajleyob. Jesús ti' xiq'uiyob cha'an i loq'uelob ti pañimil. Che' jini ti ochi ti yambʌ saj mal ya' ba'an jini xc'alʌl. Ti' pʌyʌyob ochel i tyat i ña' jini xc'alʌl yic'ot jini tsa' bʌ i pʌyʌ majlel uxtiquil i pi'ʌlob ti xʌmbal. ");
INSERT INTO ctu76_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ti' chucbe i c'ʌb jini xc'alʌl. Ti' sube ti' t'an: Talita cumi. I sujmlel ti lac t'an: Xc'alʌl, mic subeñet, tyejchenix. Che' ti' sube. ");
INSERT INTO ctu76_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ti wa' tyejchi. Ti queji ti xʌmbal. An doce años i cha'an. Tyoj bʌc'ñʌjel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús ti' wen tiq'uiyob cha'an mach quejic i subeñob yaño' bʌ. Ti' subeyob cha'an i we'sañob jini xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús ti loq'ui ya'i. Ti cha' sujti majlel ti' lumal ba' ti coli. Jini ajcʌnt'añob i cha'an ti majliyob yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Che' ti' q'uinilel c'aj oj ti queji ti cʌntisa ya' ti i templo israelob. Yonlel quixtyañu tsa' bʌ yubibeyob i cʌntisa tsijc' che'ob i pusic'al. Ti yʌlʌyob: ¿Bajche'qui mi' niq'ui ña'tyan jini? ¿Majchqui ti yʌq'ue cha'an ch'ujbiyic i niq'ui ña'tyan? ¿Bajche'qui mi' tyaj i p'ʌtyʌlel cha'an i niq'ui pʌse' ñuc tyac bʌ i p'ʌtyʌlel? ");
INSERT INTO ctu76_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Jiñʌch jini xmel buchlibʌl. Jiñʌch i yalobil María i yʌscun Jacobo yic'ot José yic'ot Judas yic'ot Simón. Jiñʌch i yʌscun jini xc'alʌlob wʌ' bʌ an la quic'ot. Che' ti yʌlʌyob. Jin cha'an ma' ti' ch'ujbiyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús ti' subeyob: Jini mu' bʌ i xiq'ue' yʌle' Dios ma' mi q'uejlel ti ñuc ti' lumal ya' ba'an i pi'ʌlob, ya' ti yotyot. Ti yan tyac jach bʌ lum mi q'uejlel ti ñuc. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mach'an ti mejli i pʌse' mi jump'ejlic ñuc bʌ i p'ʌtyʌlel Jesús ya'i. Jin jach ti' tyʌlbeyob i bʌc'tyal cha'tiquil uxtiquil c'amo' bʌ. Ti' c'oq'uisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ch'ʌjyem ti yubi Jesús cha'an mach'an ti' ch'ujbibeyob mi melel i t'an. Che' jini ti ñumi majlel ti cʌntisa ti yan tyac bʌ lum ya' ti' t'ejl tyac i lumal. ");
INSERT INTO ctu76_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús ti' pʌyʌ jini doce ajcʌnt'añob i cha'an. Cha'cha'tiquil ti' xiq'ui majlel. Ti yʌq'ueyob i p'ʌtyʌlel cha'an i choc tyacob loq'uel xibajob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ti' subeyob cha'an mach'ic i niq'ui ch'ʌmob majlel ya' ti bij. Jin jach mi' ch'ʌmob majlel i ñʌ' tye'. Mach yom i ch'ʌmob majlel i morral mi wajobic, mi tyaq'uiñobic. ");
INSERT INTO ctu76_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yom mi' lʌpob i cacti'. Cacti' yom i yʌle' pats'. Jump'och jach i bujc yom i lʌpob. Mach yom cha'p'ojch. Che' ti' subeyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ti cha' queji ti t'an Jesús. Ti' subeyob: Che' mi la' wochel ti jump'ej otyot ya' mi la' wajñel jintyo mi la' cha' loq'uel majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ya' ba' ma' mi yotsañetla ti yotyot ba' mach yom i yubibeñetyob la' t'an mi la' wa' cha' loq'uel majlel. Che' mi la' loq'uel majlel mi la' chijcun loq'uel i ts'ujbeñal la' woc cha'an i ña'tyañob mach wen bajche' mi' melob. Melel mic subeñetla, che' ti yorojlel melojel más wocol mi quej i yubiñob jini mach'ʌ ba'an ti yotsʌyetla che' bajche' ya' bʌ añob ti Sodoma yic'ot ti Gomorra. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Che' jini ti majliyob i sub ñumel t'an jini docejob cha'an i q'uextyan i pensal i cʌy i mul quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ti' chocoyob loq'uel cabʌl xibajob je'el. Ti yulbeyob aceite cabʌl c'am'o' bʌ. Ti' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jini ñuc bʌ yumʌl Herodes bʌ i c'aba' ti yubi chʌ bʌ ti' cha'le Jesús, como pejtyelel ti' wen cʌmbeyob bajche' ti' cha'le. Jin cha'an Herodes ti lolon alʌ: Jiñʌch jini Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja' ti cha' tyejchi loq'uel ya' ba'an sajtyemo' bʌ. Jin cha'an mi tsictiyel i p'ʌtyʌlel ti toñel, che' ti lolon alʌ Herodes. ");
INSERT INTO ctu76_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yaño' bʌ ti yʌlʌyob: Jiñʌch Elías juntiquil tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix, che'ob. Yaño' bʌ ti yʌlʌyob: Jiñʌch juntiquil mu' bʌ xiq'ue' yʌle' Dios che' bajche' juntiquil tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Che' ñac ti yubi Herodes chʌ bʌ ti' cha'le Jesús ti queji yʌle': Tic xiq'ui ti tsepol loq'uel i jol jini Juan pero wale ti' cha' tyejchi loq'uel ya' ba'an sajtyemo' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ti caj Herodías, Herodes ti yotsʌ ti cʌchol Juan. Ti' cʌchʌ yic'ot cadena ya' ti cʌchonibʌl. Jini Herodías i yijñam i yijts'in Herodes, Felipe bʌ i c'aba'. Pero Herodes ti' chilbe i yijñam i yijts'in. ");
INSERT INTO ctu76_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Che' jini, Juan ti' sube Herodes: Mach wen che' ma' pʌyben i yijñam a wijts'in, che' ti' sube. ");
INSERT INTO ctu76_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ts'a' ti yubi Herodías. Yom i yʌc' ti tsʌnsʌntyel Juan pero mach ch'ujbi i tsʌnsan, ");
INSERT INTO ctu76_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","como Herodes ti' bʌc'ñʌ Juan. Ti' ña'tyʌ wen mi' cha'len Juan. Juan ti yoque ac'ʌ i bʌ ti Dios. Jin cha'an ti' wen cʌñʌtyʌ cha'an ma' chʌ bʌ mi tyumbentyel ti Herodías. Che' mi yubiben i t'an Juan, Herodes ma' ti' ña'tyʌ chuqui ti yʌlʌ pero ti' mula i ñʌch'tyʌben. ");
INSERT INTO ctu76_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodías ti' tyajbe i yorojlel i ña'tyan bajche' mi quej i yʌc' ti tsʌnsʌntyel Juan che' mi' ts'ʌctiyel i q'uinilel i jabilel Herodes. Herodes ti' pʌyʌ tyʌlel ti q'uiñejel ñuco' bʌ i ye'tyel yic'ot capitañob yic'ot wen ricojo' bʌ ya' ti Galilea. ");
INSERT INTO ctu76_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ti tyʌli i yixic'al Herodías. Ti' bajñel cha'le son. C'ajacña i yoj Herodes yic'ot jini ya' bʌ añob. Herodes ti' sube jini xc'alʌl: C'ajtibeñon jiñʌch chʌ bʌ a wom mi cʌq'ueñet, che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ti' wa'choco i t'an Herodes cha'an wersa mi quej i yʌq'en jini xc'alʌl chʌ bʌyic jach yes mi' c'ajtin mi jinic tyo mi ti t'ox ch'ʌmʌ pañimil mu' bʌ ye'tyelin Herodes. ");
INSERT INTO ctu76_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jini xc'alʌl ti majli ba'an i ña'. Ti' c'ajtibe: ¿Chuquiyes yom j c'ajtin wale? Che' ti yʌlʌ. I ña' ti' jac'ʌ: C'ajtiben i jol Juan, jini mu' bʌ i yʌc' ch'ʌm ja'. Che' ti' sube. ");
INSERT INTO ctu76_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jini xc'alʌl ti wa' majli ba'an Herodes. Ti' sube: Com ma' pit aq'ueñon ti ora jach ti colem ch'ejew i jol Juan mu' bʌ i yʌc' ch'ʌm ja', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wen ch'ʌjyem ti yubi Herodes pero mi' quisnin i ñusʌben i t'an ili xc'alʌl como ti' wa'choco i t'an ti' tyojlel pʌyʌlo' bʌ ti q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ti' wa' xiq'ui majlel juntiquil soldado cha'an i ch'ʌme' tyʌlel i jol Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Che' jini ti majli. Ti' tyuc' tsepbe loq'uel i jol Juan ya' ti mal cʌchonibʌl. Ti' pit ch'ʌmʌ tyʌlel ti ch'ejew. Ti yʌq'ue jini xc'alʌl. Che' jini, ti majli i yʌq'uen i ña'. ");
INSERT INTO ctu76_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Che' ñac ti yubiyob jini tsa' bʌ i cʌmbeyob i t'an Juan ti tyʌli i ch'ʌm'eñob majlel i bʌc'tyal. Che' jini ti' mucuyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ti' cha' much'quiyob i bʌ ba'an Jesús jini yajcʌbilo' bʌ ajsubt'añob ñumel. Ti' subeyob Jesús pejtyel tsa' bʌ i cha'leyob yic'ot tsa' bʌ i cʌntisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús ti' subeyob: Conla ya' ba' jochol lum cha'an la' ts'itya' c'aj la' woj, che'en. Como chʌncol i bele' tyʌlel i majlel quixtyañujob jinic tyo mach ujtyob i cha'an uch'el. ");
INSERT INTO ctu76_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Che' jini ti majliyob ti barco. Ti bajñel c'otiyob ya' ba' jochol lum. ");
INSERT INTO ctu76_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Cabʌl ti yilʌyob che' ñac ti majliyob. Ti' ña'tyʌyob Jesúsʌch. Ti majliyob ti ajñel ch'oyolob tyac bʌ ti pejtyel lum. Ñaxan ti c'otiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Che' ñac ti loq'ui Jesús ti barco ti yilʌ ya'an yonlel quixtyañu. Ti' p'untyʌyob cha'an yom i cotyañob como chʌ'ʌch añob che' bajche' tiñʌme' mach'ʌ ba'an majch mi' cʌñʌtyan. Che' jini, an cʌbʌl chʌ bʌ ti queji i cʌntisañob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Che' iq'uix quejel ti tyʌliyob ba'an Jesús ajcʌnt'añob i cha'an. Ti' subeyob Jesús: Iq'uix quejel. Ma' majch chumul wʌ'wʌ'i. ");
INSERT INTO ctu76_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Subeñob majlel cha'an mi majlelob ya' ti otyotyel yic'ot ya' ti lʌc'ʌl tyac bʌ lum cha'an i mʌñob chʌ bʌ mi' c'uxob como ma' chʌ bʌ añob i cha'an, cha'an i c'uxob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús ti' subeyob: Jatyetla yom mi la' wʌq'uen chʌ bʌ mi' c'uxob, che'en. Jini ajcʌnt'añob ti' jac'ʌyob: ¿Yom ba majlicon lojon quisan doscientos denarios c mʌñe' lojon waj cha'an i c'uxob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús ti' c'ajtibeyob: ¿Jayq'uejqui waj an la' cha'an? Cucu, q'uelela, che'en. Che' ñac ti queji i ña'tyañob ti' subeyob Jesús: Añʌch jo'q'uej waj yic'ot cha'cojt chʌy, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Che' jini, Jesús ti' sube quixtyañujob cha'an mi' buchtyʌlob ti jujunmujch' ya' ti yʌyʌx bʌ jam. ");
INSERT INTO ctu76_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ti jujunmujch' ti buchleyob ti cien tyac yic'ot cincuenta tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Che' jini Jesús ti' ch'ʌmʌ jini jo'q'uej waj yic'ot cha'cojt chʌy. Ti' q'uele letsel ti panchan. Ti' sube Dios wocox i yʌlʌ. Ti' xet'e jini waj. Ti yʌq'ueyob ajcʌnt'añob i cha'an cha'an i lu' pucbeñob quixtyañujob. Yic'ot cha'cojt chʌy ti' lu' xet'beyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ti' lu' c'uxuyob ti pejtyelelob. Ti lu' ñaj'ʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tsa' tyo i lotyoyob doce chiquib i colojbal i xejt'il waj yic'ot chʌy. ");
INSERT INTO ctu76_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil winicob tsa' bʌ i c'uxuyob jini waj yic'ot chʌy. ");
INSERT INTO ctu76_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús ti' wa' subeyob ochel ti barco jini ajcʌnt'añob i cha'an, cha'an mi ñaxan majlelob ti junxej ja' ya' ti lum Betsaida bʌ i c'aba'. Jesús tsa' tyo cʌyle cha'an i subeñob sujtyel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Che' ñac ujtyel i subeñob sujtyel ti letsi majlel Jesús ya' ti wits i cha'len oración. ");
INSERT INTO ctu76_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Che' ñac ti ochi ac'bʌlel ya' añob ti barco ti xinil ja' ajcʌnt'añob i cha'an. Ya' bajñel an Jesús ti wits. ");
INSERT INTO ctu76_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesús ti yilʌ cha'an wocol chʌncol i nijcañob majlel barco jini ajcʌnt'añob como chʌncol i chojquel ti ic'. Che' yomox sʌc'an ti tyʌli Jesús ya' ba'añob. Chʌncox ti xʌmbal tyʌlel ti' pam ja'. Che' bajche' mi quej i pits' ñumel Jesús ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Che' ñac ti yilʌyob chʌncol ti xʌmbal ti' pam ja' ti' lolon ña'tyʌyob i wʌy jach quixtyañu ya' majlel ti yilʌyob. Ti quejiyob ti oñel. ");
INSERT INTO ctu76_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Como ti pejtyelelob ti yilʌ. Ti wen quejiyob ti bʌq'uen. Che' jini Jesús ti queji i pejcañob. Ti' subeyob: Lajmenla ti bʌq'uen. Joñoñʌch. Mach la' bʌc'ñañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ti ochi ti barco ya' ba' añob. Ti ñʌch'le jini ic'. Tsijc' che'ob i pusic'al, tyoj bʌc'ñʌjelob. ");
INSERT INTO ctu76_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Como mach'an ti' ña'tyʌyob bajche' i sujmlel cha'an jini waj che' ti' we'sʌyob cinco milob como tsʌtsob i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Che' tsa'ix c'axiyob ti junxej colem joyol bʌ ja' ti c'otiyob ti lomtyʌl Genesaret bʌ i c'aba'. Ya' ti' ti' ja' ti' cʌchʌyob cʌytyʌl barco. ");
INSERT INTO ctu76_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Che' ñac ti loq'uiyob ti barco jini quixtyañujob ti' wa' cʌñʌyob Jesús ");
INSERT INTO ctu76_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ajñel ti tyʌliyob ba'an Jesús tyʌlemo' bʌ ti pejtyel lum tyac. Ti' ch'uyuyob tyʌlel xc'am'añob tyots'olo' bʌ ba'ic jach ti yubiyob ya'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ya' ba' ti ochi majlel Jesús ti ba'ic jach bʌ lum yic'ot ti yalo' lum tyac yic'ot ti otyotyel tyacob ti' pʌyʌyob majlel xc'am'añob ya' ti calle tyac. Ti' wersa c'ajtibeyob i tyʌlbeñob mi jinic jachix i yoc i pislel Jesús. Jini tsa' bʌ i tyʌlbeyob ti lajmiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jini fariseojob yic'ot cha'tiquil uxtiquil yambʌ ajcʌntisajob ya' bʌ tyʌlemob ti Jerusalén ti' much'quiyob i bʌ ya' ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jini ti yilʌyob che' ma' ti' pocoyob i c'ʌb che' ti quejiyob ti we'el cha'tiquil uxtiquil ajcʌnt'añob i cha'an Jesús bajche' mi xijq'uelob cha'an tsa' bʌ i ch'ujbiyob ti ñoj oniyix. Jin cha'an ti' tyajayob ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(I tyʌlel jini fariseojob yic'ot pejtyel yaño' bʌ israelob mi' wen pocob i c'ʌb. Che' ma' jal mi' pocob i c'ʌb mach'an mi' we'ejelob, cha'an i ch'ujbibeñob i t'an tyac i yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Che' mi sujtyelob ti mʌñoñel mi ma' mi' pocob i c'ʌb ti caj bajche' mi' ch'ujbiñob ma' mi we'ejelob. Ti' bej cʌñʌyob majlel cabʌl i t'an tyac i yumob ti ñoj oniyix cha'an wen mi' ch'ujbibeñob jini t'an cha'an bajche' yom pocol jini we'ib tyac yic'ot i p'ejt tyac yic'ot i yajnib tyac melel tyac bʌ ti tsucu tyaq'uin yic'ot wʌyibʌl tyac.) ");
INSERT INTO ctu76_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jin cha'an jini fariseojob yic'ot ajcʌntisajob cha'an i mandar israelob ti' c'ajtibeyob Jesús: ¿Chucoch ma' mi' ch'ujbiñob i t'an tyac lac yumob ti ñoj oniyix jini ajcʌnt'añob a cha'an? Ma' mi' pocob i c'ʌb che' mi we'ejelob bajche' ti xijq'uiyonla, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús ti' jac'beyob: Melelʌch i t'an Isaías tsa' bʌ i ts'ijbu ti ñoj oniyix cha'an bajche' mi la' wajñel. Cha'chajp la' pensal. Isaías ti' ts'ijbu: Jini quixtyañujob ti' ti'ob jach mi' ch'ujbiñon pero i pusic'al ñajt an tic tyojlel. ");
INSERT INTO ctu76_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma' i c'ʌjnibal che' bajche' mi' ch'ujutisañon che' muc'ob ti cʌntisa ti' t'an jach winicob. Che' ti' ts'ijbu Isaías. ");
INSERT INTO ctu76_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Como jatyetla mi la' cʌy i xic'ojel Dios cha'an la' ch'ujbiben i t'an oño't'anix bʌ quixtyañujob cha'an bajche' mi la' poc la' p'ejt tyac yic'ot la' wuch'ib tyac yic'ot chʌ bʌ mi la' niq'ui cha'len tyac. Che' ti' subeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ti' subeyob je'el: Melelʌch, che' jach bajche' alas jach i t'an Dios mi la' cha'len, cha'an jach la' wom la' ch'ujbiben i t'an tyac la' yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Como Moisés ti yʌlʌ: Ac'ʌ ti ñuc la' tyat la' ña'. Jini mu' bʌ i yʌl'en i tyat i ña' la' sajtic. Che' an ti mandar Moisés. ");
INSERT INTO ctu76_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero jatyetla weñʌch mi la' lolon ale' che' an winic mu' bʌ i suben i tyat i ña': Mach ch'ujbix j cotyañetla como ti pejtyelel chʌ bʌ jach an c cha'an jiñʌch Corbán che'etla. (Corbán yom i yʌl i majtyan Dios tsa' bʌ i yʌq'ue.) ");
INSERT INTO ctu76_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mi chʌ'ʌch mi yʌl bajche' jini, che' jini mach wersa mi' cotyan i tyat i ña' mi la' wʌl. ");
INSERT INTO ctu76_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Che' mi la' cha'len bajche' jini, ma' i c'ʌjnibal i xic'ojel Dios mi la' cha'len cha'an jach i subal la' yumob ti ñoj oniyix. Jiñʌch mi la' cha' c'ʌn la' cʌntisan la' walobilob. Chʌ'ʌch mi la' bej oc' isan chʌ bʌ tyac bajche' iliyi. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús ti' cha' pʌyʌyob tyʌlel quixtyañujob. Ti' subeyob: Lu' ñʌch'tyanla ti la' pejtyelel. Ña'tyanla. ");
INSERT INTO ctu76_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jini an tyac bʌ ti mulawil mach'an mi' bibi'tisañob quixtyañujob che' mi yochel ti' ñʌc'. Mi' bibi'tisañob quixtyañu mu' bʌ i loq'uel ti' pusic'al. Jiñʌch jini mach'ʌ yom i yilan Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalinla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Che' ñac ti loq'ui Jesús ya' ba'an quixtyañujob ti ochi ti otyot. Che' jini, ajcʌnt'añob i cha'an ti queji i c'ajtibeñob chuqui i sujmlel jini lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús ti' subeyob: ¿Mach'a ba'an mi la' ña'tyan jatyetla je'el? ¿Mach'a ba'an mi la' ch'ʌmben isujm jini mu' bʌ i yochel ti mal quixtyañu mach'an mi' bibi'tisañob? Ma'an bajche' yilal mi yilan Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Como mach ya'ic ti' pusic'al mi yochel, ti' ñʌc' jach mi majlel. Muc' jach i ñumel, che' ti' yʌlʌ Jesús. Chʌ'ʌch ti' cʌntisʌyob pejtyelel i bʌl lac ñʌc' lu' weñʌch. ");
INSERT INTO ctu76_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesús ti' subeyob je'el: Jini mu' bʌ i loq'uel ti' pusic'al quixtyañujob jiñʌch mu' bʌ i bibi'tisañob, jiñʌch mach bʌ yom i yilan Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Como loq'uem ti' pusic'al quixtyañujob mi tyʌlel bibajax bʌ i pensal, yic'ot che' an i tontojlel yic'ot che' mi' pejcan yambʌ winic yambʌ x'ixic, yic'ot tsʌnsa, ");
INSERT INTO ctu76_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yic'ot xujch', yic'ot che' mi' mich'q'uel chʌ bʌ an i cha'an i pi'ʌl ti chumtyʌl, yic'ot simaronlel, yic'ot lot, yic'ot che' bibajax mi' cha'len, yic'ot che' bajñel jin jach yom chʌ bʌ niq'ui an i cha'an, yic'ot jop't'an yic'ot che' yom i chan isan i bʌ yic'ot ma'ix tyoj mi yajñel. ");
INSERT INTO ctu76_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ya' jach lu' loq'uem ti' pusic'al quixtyañujob pejtyel jini mach bʌ wen. Jiñʌch mu' bʌ i bibi'tisañob quixtyañujob, jiñʌch mach bʌ yom i yilan Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús ti loq'ui majlel. Ti majli c'ʌlʌl ti lʌc'ʌlel jini lum tyac Tiro yic'ot Sidón bʌ i c'aba'. Ya' ti ochi ti jump'ej otyot. Jesús mach yom ubintic che' ya' an. Pero mach'an ti mejli ti mucul ajñel. ");
INSERT INTO ctu76_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ya'an juntiquil x'ixic tsa' bʌ wa' ubi che' ya'an Jesús. An juntiquil xc'alʌl bʌ i yalobil tyʌc'lʌbil bʌ ti xiba. Che' ñac ti yubi che' ya'an Jesús ti wa' tyʌli ba'an Jesús. Ti ñocle ti yebal yoc. ");
INSERT INTO ctu76_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ch'oyol ti yambʌ pañimil Sirofenicia bʌ i c'aba'. Ti tyʌli i c'ajtiben Jesús cha'an i choc loq'uel jini xiba' am bʌ ti' pusic'al yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesús ti' sube: La' ñaxan we'icob alp'eñalob. Como mach yom lac chilben i waj alp'eñal cha'an jach lac choquen yal ts'i', che'en. Chʌ'ʌch ti yʌlʌ cha'an ñaxan yom cotyʌnticob israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jini x'ixic ti' jac'ʌ: Melelʌch bajche' ma' wʌl, c Yum. Pero jini i yal ts'i' am bʌ ti yebal mesa mi' c'uxe' i xejt'i waj mu' bʌ i p'ʌtsañob alp'eñalob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús ti' jac'ʌ: Cha'an weñʌch bajche' ti a jac'ʌ, cucux. Tsa'ix loq'ui xiba ti' pusic'al a walobil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Che' ñac ti c'oti jini x'ixic ti yotyot ti' tyaja yalobil tyots'ol ti wʌyib como loq'uemix jini xiba. ");
INSERT INTO ctu76_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús ti cha' loq'ui majlel ya' ti lʌc'ʌlel lum Tiro bʌ i c'aba'. Ti ñumi majlel ti Sidón yic'ot ti lum tyac Decápolis bʌ i c'aba'. C'ʌlʌ ti c'oti ya' ti colem joyol bʌ ja' Galilea bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ti' pʌyʌyob tyʌlel ba'an Jesús juntiquil xcojc. Wocol mi' cha'len t'an je'el. Ti' c'ajtibeyob Jesús cha'an yʌc' i c'ʌb ti jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús ti' cha' pʌyʌ majlel jini winic ya' ba' jochol. Ti yotsʌbe i yal c'ʌb ti' chiquin. Ti' tyujbʌ. Ti' tyʌlbe yac' jini xcojc. ");
INSERT INTO ctu76_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ti' q'uele letsel ti panchan Jesús. C'am ti' japʌ ic'. Ti' sube jini xcojc: Efata, che'en. Yom yʌl ti lac t'an: La' jajmic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ti wa' jajmi i chiquin jini winic. Ti tyoj'ʌ yac'. Tyojix ti queji ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús ti' wen tiq'ui jini tsa' bʌ i pʌyʌ tyʌlel jini xcojc cha'an machic i subeñob mi juntiquilic. Che' ñac ti' subeyob Jesús cha'an mach i yʌlob, che' jini ti bej queji i yutsi pucob majlel t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Cabʌl tsijc' che'ob bʌ i pusic'al quixtyañu. Ti yʌlʌyob: Ñoj wen pejtyel chʌ bʌ yes mi' cha'len. Wen yujil i yʌq'uen i yubin t'an xcojcob, yujil i yʌq'uen i cha'len t'an x'uma'ob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti yambʌ q'uin ti' much'quiyob i bʌ yonlel quixtyañu. Mach'an chʌ bʌ an cha'an i c'uxob. Che' jini Jesús ti' pʌyʌyob tyʌlel ajcʌnt'añob i cha'an. Ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","P'ump'un mij q'uel ili quixytañujob cha'an com j cotyañob. Uxp'elix q'uin wʌ'an quic'otyob. Ma'ix chʌ bʌ ti' c'uxuyob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Mi tic chocoyob majlel ti yotyot che' wi'ñayobix, c'o'ojl mi quejel i c'un añob ti bij. An ñajt bʌ ch'oyolob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jini ajcʌnt'añob ti' jac'ʌyob: ¿Baqui ch'ujbi lac tyaje' waj cha'an i c'uxob wʌ' ba' jochol lum? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús ti' jac'beyob: ¿Jayq'uejqui waj an la' cha'an? che'en. Ti' jac'ʌyob: Siete, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Che' jini ti' lu' xiq'uiyob buchtyʌl ti lum pejtyel jini quixtyañu. Ti' ch'ʌmʌ jini siete waj. Ti' sube wocox i yʌlʌ Dios. Che' jini, ti queji i xet'e tyac. Ti queji i yʌq'uen jini ajcʌnt'añob cha'an i pucbeñob i bʌ. Ti queji i pucbeñob quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","An i cha'añob je'el cha'cojt uxcojt biq'uit bʌ chʌy. Che' jini ti' cha'le oración Jesús. Ti' subeyob ajcʌnt'añob i cha'an cha'an i pucbeñob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ti lu' we'iyob. Ti lu' ñaj'ʌyob. Che' jini ti' lotyoyob siete ñuqui chiquib but'ul tyac i colojbal i xejt'il tyac chʌy yic'ot waj. ");
INSERT INTO ctu76_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Lʌc'ʌl cuatro mil jini tsa' bʌ i c'uxuyob waj yic'ot chʌy. Che' jini Jesús ti' subeyob i lu' sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ti ochiyob ti barco Jesús yic'ot ajcʌnt'añob i cha'an. Ti majliyob ti lʌc'ʌlel saj lum Dalmanuta bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ti tyʌliyob junmujch' fariseojob bʌ i c'aba'. Ti queji i contrajibeñob i t'an Jesús. Yom pʌs'enticob i p'ʌtyʌlel Jesús tyʌlem bʌ ti panchan cha'an mi' q'uelob mi melelʌch bajche' mi' cha'len Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús c'am ti' japʌ ic' cha'an mach yom yubin. Ti yʌlʌ: ¿Chucoch mi' c'ajtin i q'uelbeñoñob c p'ʌtyʌlel wʌ' bʌ añob ti mulawil? Melel mic subeñetla mach'an mi quej la' pʌs'entyel c p'ʌtyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús ti' cʌyʌyob jini quixtyañujob. Ti cha' ochi ti barco. Ti majli ti junxej ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ti ñajayi i cha'an i ch'ʌmob majlel chʌ bʌ yes mi' c'uxob jini ajcʌnt'añob i cha'an Jesús. Jump'ej jach caxlan waj ya'an yic'otyob ti barco. ");
INSERT INTO ctu76_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Che' jini Jesús ti' wersa subeyob: Tsajibiletla yom. Cʌñʌtyan la' bʌ cha'an jini levadura mu' bʌ yʌq'uen i wos i bʌ caxlan waj i cha'an bʌ fariseojob yic'ot i cha'an bʌ Herodes. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ti queji i motin pejcañob i bʌ ajcʌnt'añob i cha'an Jesús. Ti yʌlʌyob: Chʌ'ʌch chʌncol i yʌle' cha'an mach'an ti lac ch'ʌmʌ tyʌlel laj caxlan waj, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús ti' ña'tyʌ chuqui ti yʌlʌyob. Ti' subeyob: ¿Chucoch mi la' lolon ale' che' mach'an la' caxlan waj? ¿Mach'a ba'an mi la' ch'ʌmben isujm? ¿Mach'a ba'an mi la' ña'tyan che' mi la' wubin jini lajoñel? ¿Tsʌts tyo ba la' pusic'al? ");
INSERT INTO ctu76_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Lolon an la' wut. ¿Mach'a ba'an mi la' wilan pañimil? Lolon an la' chiquin. ¿Mach'a ba'an mi la' wubin? ¿Mach'a ba'an c'ajal la' cha'an chʌ bʌ ti ujti? ");
INSERT INTO ctu76_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Che' ñac tic xet'beyob jo'q'uej waj jini cinco mil quixtyañu, ¿jayp'ejqui chiquib ti la' lotyo i colojbal i xejt'il tyac? che' Jesús. Jini ajcʌnt'añob ti' jac'ʌyob: Doce, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús ti queji i cha' ale': Che' ñac an siete waj cha'an cuatro mil quixtyañu, ¿jayp'ejqui ñuqui chiquib ti la' lotyo i colojbal i xejt'il tyac? che'en. Ti' jac'ʌyob: Siete, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús ti' subeyob: ¿Max tyo ba'an mi la' ch'ʌmben isujm? che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ya' ti c'otiyob ti lum Betsaida bʌ i c'aba'. Ti' pʌyʌyob tyʌlel juntiquil muts'ul bʌ i wut ya' ba'an Jesús. Ti' subeyob Jesús cha'an i tyʌle'. ");
INSERT INTO ctu76_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús ti' chucbe i c'ʌb jini muts'ul bʌ i wut. Ti' pʌyʌ loq'uel ya' ti lum. Ti' bombe i ya'lel i ti' ti i wut. Ti yʌc'ʌ i c'ʌb ti' wut jini muts'ul bʌ i wut. Ti' c'ajtibe: ¿Am ba chʌ bʌ ma' wilan? Che' ti' c'ajtibe jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ti queji i yilan pañimil jini winic. Ti yʌlʌ: Mi quilan winicob. Pero che' bajche' tye' mi quilan muc' bʌ ti xʌmbal. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús ti' cha' ac'ʌ i c'ʌb ti' wut jini muts'ul bʌ i wut. Ti lajmi i wut. Ti' ch'uj q'uele pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesús ti' xiq'ui majlel ti yotyot. Ti' sube: Mach ochet ti lum. Ma' majch ma' saj suben ya' ti lum. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ti loq'ui majlel Jesús yic'ot ajcʌnt'añob i cha'an. Ti majliyob ya' ti saj tyac bʌ lum ya' ti Cesarea Filipo bʌ i c'aba'. Che' ñac ya' tyo añob ti bij Jesús ti' c'ajtibeyob: ¿Majchonqui mi yʌl quixtyañujob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ti' jac'ʌyob: Mi yʌlob jatyet Juan tsa' bʌ yʌc'ʌ ch'ʌm ja'. An mu' bʌ yʌlob Elíaset. Yaño' bʌ mi yʌlob jatyet juntiquil tsa' bʌ i xiq'ui yʌle' Dios. Che' ti yʌlʌyob jini ajcʌnt'añob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús ti' c'ajtibeyob: Ixcu jatyetla, ¿majchonqui mi la' wʌl? che'en. Pedro ti' jac'be: Jatyet jini yajcʌbil bʌ i cha'an Dios mu' bʌ i pejcʌntyel ti Cristo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús ti' wersa tiq'uiyob cha'an mach'an majch mi' subeñob. ");
INSERT INTO ctu76_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús ti queji i cʌntisañob añʌch cha'an i wersa ñusan wocol. Ti yʌlʌ: Joñon i Pi'ʌlon Quixtyañujob mi quejel i mich' q'uelon xñoxob año' bʌ ye'tyel yic'ot ñuc bʌ curajob i cha'an israelob yic'ot ajcʌntisajob cha'an i mandar israelob, che'en. Ti' subeyob mi quejel i tsʌnsʌntyel yic'ot mi quejel i cha' tyejchel loq'uel ba'an sajtyemo' bʌ ti yuxp'ejlelel q'uin. ");
INSERT INTO ctu76_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ñoj tsiquilʌch bajche' ti' subeyob. Pedro ti' bajñel pʌyʌ majlel Jesús ti jumpat. Ti queji i tiq'ue'. ");
INSERT INTO ctu76_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús ti' sutqui i bʌ i q'uel jini ajcʌnt'añob. Ti queji i tiq'ue' Pedro. Ti yʌlʌ: Loq'uen wʌ' bʌ' añon como chʌncol a ña'tyan che' bajche' mi' ña'tyan Satanás. Mach'an ma' ña'tyan bajche' yom Dios, jin jach bajche' mi' mulan quixtyañujob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús ti' cha' pʌyʌyob tyʌlel jini much'quibilo' bʌ quixtyañu yic'ot ajcʌnt'añob i cha'an. Ti' subeyob: Mi an majch yom i tsʌcleñon majlel la' i cʌye' mu' bʌ i bajñel niq'ui cha'len. La' i ñusan wocol aunque mi sajtyel ti cruz ti caj mi' tsʌcleñon majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jini yom bʌ i bajñel cʌñʌtyan i bʌ mi quejel i sʌt'e i cuxtyʌlel mach'ʌ yujil jilel. Jini mu' bʌ i yʌc' i bʌ cha'añon, cha'an jini wen bʌ t'an mi quejel i cʌñʌtyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Anic winic mu' bʌ i lu' ganarin pejtyelel am bʌ ti mulawil, ¿chutyoqui i c'ʌjnibal i cha'an mi mach'an ti tyaja i cuxtyʌlel mach'ʌ yujil jilel? ");
INSERT INTO ctu76_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Como ma'an bajche' ch'ujbi i saj mʌñe' i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mi an majch mi' quisniñon yic'ot che' mi' quisnibeñon ili c t'an wʌ' ti mulawil ba'an jini mu' bʌ i cʌyob Dios yic'ot jini año' bʌ i mul, che' jini mi quej j quisnin je'el ili quixtyañujob Joñon i Pi'ʌlon Quixtyañujob ya' bʌ mic tyʌlel ti' ñuclel c Tyat yic'ot ch'ujul bʌ ajtroñelob i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús ti' subeyob: Melel mic subeñetla, cha'tiquil uxtiquil wʌ' bʌ añob mach'an mi quej i sajtyelob jintyo mi' ñaxan ilañob che' mi quej i yumintyel Dios ti' p'ʌtyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Che' ñac ti ñumi wʌcp'ej q'uin, Jesús ti' pʌyʌyob majlel Pedro yic'ot Jacobo yic'ot Juan. Ti' bajñel pʌyʌyob majlel ti chan bʌ wits. Ti yʌjni Jesús ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Lemlaw ti majli i pislel, ñoj sʌsʌc bajche i ña'al tsʌñal. Mach'an majch ti mulawil ch'ujbi bʌ i sʌc isan i pislel bajche' ti majli i pislel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ya' ti yilʌyob Elías yic'ot Moisés. Chʌncolob ti t'an yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro ti' sube Jesús: Maestro, c'otyajax che' wʌ' añonla wʌ'wʌ'i. Wʌ' yom c mel lojon uxp'ej lechi'pat, jump'ej a cha'an, jump'ej i cha'an Moisés yic'ot jump'ej i cha'an Elías. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma' mi' ña'tyan chʌ bʌ yom yʌle' che' cu wen chʌncolob ti bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ti wa' tyʌli tyocal tsa' bʌ mosoyob. Ya' ti malil tyocal ti yubiyob ajt'an. Ti yʌlʌ: Jiñʌch p'untyʌbil bʌ calobil. Ñʌch'tyʌbenla i t'an. Che' ti yʌlʌ jini ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Che' jini ti' wa' q'ueleyob ti suttyʌlel jini uxtiquil ajcʌnt'añob i cha'an Jesús. Ma' majch tsiquil ya' ba'añob. Jin jach Jesús ya'an. ");
INSERT INTO ctu76_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Che' ñac chʌncol i jubelob tyʌlel ti wits, Jesús ti' tiq'uiyob. Ti' subeyob: Mach'an majch mi la' saj suben jini tsa' bʌ la' wilʌ jintyo mic cha' tyejchel loq'uel ba'an sajtyemo' bʌ, Joñon i Pi'ʌlon Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jin cha'an mach'an ti' saj tsictisʌyob yaño' bʌ. Ti' c'ajtibeyob i bʌ chuquiyes i sujmlel che' mi cha' tyejchel loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ti' c'ajtibeyob Jesús: ¿Chuquiyes i sujmlel che' mi yʌlob jini ajcʌntisajob cha'an i mandar israelob cha'an wersa mi tyʌlel Elías? che'ob. Che' ti' c'ajtibeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús ti' subeyob: Melelʌch che' ñaxan mi tyʌlel Elías cha'an mi' tyoj isan pejtyel chʌ bʌ an. ¿Chuqui mi yʌl Ts'ijbubil bʌ i T'an Dios cha'an Joñon i Pi'ʌlon bʌ Quixtyañujob? Mi yʌl cha'an mi quejel c ñusan cabʌl wocol yic'ot mi quejel c mich' q'uejlel. ");
INSERT INTO ctu76_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mic subeñet, tsa'ix tyʌli Elías. Ti' tyʌc'lʌyob jini quixtyañujob jin jach bajche yomob chʌ'ʌch bajche' wʌ ts'ijbubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Che' ñac Jesús yic'ot uxtiquil ajcʌnt'añob ti c'otiyob ba'an jini yambʌ ajcʌnt'añob i cha'an Jesús, ti yilʌyob ya' suttyʌlob yonlel quixtyañu ti' joytyʌlelob. Ya' añob je'el ajcʌntisajob cha'an i mandar israelob chʌncol i cʌlʌx pejcañob i bʌ yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Che' ñac ti yilʌyob Jesús tsijc' che' i pusic'alob ti pejtyelel jini quixtyañu. Ti majliyob ti ajñel i pejcañob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús ti' c'ajtibeyob: ¿Chuqui ti t'an muq'uetla la' wic'otyob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Juntiquil ya' bʌ an ti' jac'ʌ: Maestro, tic pʌyʌ tyʌlel juntiquil calobil wʌ' ba'añet. Ti sujti ti x'uma' cha'an tyʌc'lʌbil ti xiba, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Che' mi' tyʌc'lan mi' choc jubel i bʌ ti lum, mi' loq'uel i lojc i ti', mi' c'ux i yej. Chʌncox i bej más c'un an. Tic subeyob ajcʌnt'añob a cha'an cha'an i chocob loq'uel jini xiba pero mach'an ti mejliyob. Che' ti yʌlʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús ti' jac'beyob: Max tyo ba'an majch mi' ch'ujbin wʌ' bʌ'an ti mulawil yubil. ¿Jayp'ej tyoqui q'uin wʌ' añon quic'otyetla? ¿Jayp'ej tyoqui q'uin ch'ujbi j cuchbeñetla i tsʌtslel la' pusic'al? Pʌyʌla tyʌlel wʌ' ba'añon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ti' pʌyʌyob tyʌlel jini alob ya' ba'an Jesús. Che' ñac ti yilʌ Jesús, jini xiba ti wa' yʌc'ʌ ti jits'cuyel jini alob. Ti yajli ti lum, ti' pajch'i i bʌ. Ti loq'ui i lojc i ti'. ");
INSERT INTO ctu76_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús ti' c'ajtibe i tyat: ¿Jalixqui i quejel che' bajche' iliyi? che'en. Jini winic ti' jac'ʌ: C'ʌlʌ che' ñac alʌl tyo ti queji. ");
INSERT INTO ctu76_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Jini xiba cabʌl mi' choc ochel ti' c'ajc yic'ot ti ja' cha'an yom i tsʌnsan. Mi an bajche' ch'ujbi a cha'len, p'untyañon lojon, cotyañon lojon. Che' ti yʌlʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús ti' sube: Cha'an jini mu' bʌ i ch'ujbin, lu' mejlʌch i melbentyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","I tyat jini alob ti c'am bʌ t'an ti queji i wa' ale': Chʌncox ch'ujbiñet. Cotyañon cha'an mic más ch'ujbiñet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Che' ñac ti yilʌ Jesús chʌncol i wa' much'quiñob i bʌ yonlel quixtyañu ti' tiq'ui jini xiba. Ti yʌlʌ: Mic subeñet x'uma'et bʌ xiba xcojquet bʌ xiba loq'uen wʌ' ti alob. Mach cha' sujtiquet ochel wʌ' ti' pusic'al. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ti queji ti oñel jini xiba. Ti cha' yʌc'ʌ ti jits'cuyel jini alob. Ti loq'ui. Che' bajche' sajtyemix ti cʌyle jini alob. Jin cha'an ti queji i yʌlob: Sajtyemix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús ti' chucbe i c'ʌb cha'an tyejchic. Jini alob ti wa' wa'le. ");
INSERT INTO ctu76_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Che' ñac ti ochi ti otyot Jesús, jini ajcʌnt'añob i cha'an ti' bajñel c'ajtibeyob: ¿Chucoch ma' ti mejli lojon c choc loq'uel jini xiba? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús ti' jac'beyob: Mach ch'ujbi i chojquel loq'uel jini xiba. Jin jach ti oración yic'ot ti ch'ajb ch'ujbi chocol loq'uel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Che' ñac ti loq'uiyob ya'ya'i ti ñumiyob majlel ti Galilea. Jesús mach yom ubintic che' ya'an. ");
INSERT INTO ctu76_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Como chʌncol i cʌntisañob ajcʌnt'añob i cha'an. Ti' subeyob: Joñon i Pi'ʌlon Quixtyañujob mi quej cʌjq'uel ti' c'ʌb quixtyañujob. Mi quejel i tsʌnsañoñob. Che' tsa'ix tsʌnsʌntiyon, ti yuxp'ejlel q'uin mi quejel c cha' cuxtiyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero jini ajcʌnt'añob mach'an ti' ña'tyʌbeyob chuqui ti yʌlʌ. Ti' bʌc'ñʌ i c'ajtibeñob Jesús chʌ bʌ yes i sujmlel. ");
INSERT INTO ctu76_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ti c'otiyob ti lum Capernaum bʌ i c'aba'. Che' ñac ya' añob ti otyot, Jesús ti' c'ajtibeyob. ¿Chuquiyes chʌncol la' cʌlʌx ale' ya' ti bij? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jini ajcʌnt'añob ti ñʌch'leyob como che' ñac ya' tyo añob ti' bij ti cʌlʌx pejcʌyob i bʌ. Chʌncol i c'ajtibeñob i bʌ majchqui más ñuc mi quej i q'uejlel. ");
INSERT INTO ctu76_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Che' jini, ti buchle Jesús. Ti' pʌyʌyob tyʌlel ti docejlel. Ti' subeyob: Jini yom bʌ ajñel ti ñuc ti la' tyojlel la' i más ju'san i bʌ bajche' ti pejtyel jini yaño' bʌ. La' i cha'len cotyaj ti' tyojlel i pi'ʌlob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Che' jini Jesús ti' pʌyʌ tyʌlel juntiquil alʌl. Ti' wa'choco ya' ti' xinilob. Ti' meq'ue. Ti queji i subeñob. ");
INSERT INTO ctu76_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Jini mu' bʌ i pʌy ochel juntiquil alʌl cha'an i ña'tyañon chʌncol i pʌyon ochel yubi. Jini mu' bʌ i pʌyon ochel mach joñon jach mi' pʌyon. Chʌncol i pʌy ochel je'el jini tsa' bʌ i chocoyon tyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Che' jini, Juan ti' sube Jesús: Maestro, ti quilʌ lojon juntiquil winic mu' bʌ i choc loq'uel xibajob ti a c'aba' bʌ mi' c'ʌn. Tic tiq'ui lojon como ma' mi' tsʌcleñonla ti xʌmbal, che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesús ti' sube: Mach la' tiq'ue'. Ma' majch mu' bʌ i c'ʌn j c'aba' cha'an i pʌs ñuc bʌ i p'ʌtyʌlel mi quej i yotsan i bʌ tij contra. ");
INSERT INTO ctu76_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jini mach'ʌ ba'an mi' contrajiñonla chʌncox i cotyañonla. ");
INSERT INTO ctu76_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jini mu' bʌ i yʌq'ueñetla chʌ bʌ yom la' cha'an aunque juntsimajic jachix ja' cha'an chʌncox i ña'tyan mi ajcʌnt'añetla i cha'an bʌ Cristo, melel mi quej i yʌq'uentyel i tyojol. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Majchical jach mi yʌq'uen yotsan i mul juntiquil i saj bʌ mu' bʌ i ch'ujbiñon más wen tsʌ'iquix cʌjchi ti' bic' yic'ot jump'ej ña'tyun cha'an chojquic ochel ti tyam bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mi ti a wotsʌ a mul ti caj a c'ʌb, wa' tsepe loq'uel. Más wen che' xmol c'ʌbet ma' tyaj a cuxtyʌlel mach'ʌ yujil jilel. Mach jinic cha'ts'ijt a c'ʌb ma' majlel ti c'ajc mach'ʌ ch'ujbi yajpic, ");
INSERT INTO ctu76_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ba' mach'an mi chʌmel i motso'lel, ba' mach'an mi saj yʌjpel i c'ʌc'al. ");
INSERT INTO ctu76_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mi ti a wotsʌ a mul ti caj a woc, wa' tsepe loq'uel. Más wen che' xmol oquet ma' tyaj a cuxtyʌlel mach'ʌ yujil jilel. Mach jinic cha'ts'ijt a woc ma' majlel ti c'ajc mach'ʌ ch'ujbi yajpic, ");
INSERT INTO ctu76_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ba' mach'an mi chʌmel i motso'lel, ba' mach'an mi saj yʌjpel i c'ʌc'al. ");
INSERT INTO ctu76_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mi ti a wotsʌ a mul ti caj a wut wa' loc'san. Más wen che' jump'ej jach a wut ma' wochel ti yumintyel Dios. Mach jinic cha'p'ej a wut ma' majlel ti c'ajc ");
INSERT INTO ctu76_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ba' mach'an mi chʌmel i motso'lel, ba' mach'an mi saj yʌjpel i c'ʌc'al. ");
INSERT INTO ctu76_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Como ti ñoj oniyix c'ʌlʌ wale pejtyel tsʌnsʌbil bʌ i majtyan Dios mi' lu' chajpʌntyel ti ats'am. Wale iliyi ti pejtyelel mi quej i chajpʌntyel ti c'ajc yubil cha'an tyoj'ac. ");
INSERT INTO ctu76_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Weñʌch jini ats'am. Pero mi ti jili i tsajel mach'an chʌ bʌ i c'ʌñʌ i cha' tsaj isʌntyel jini ats'am. Yom an la' wʌts'mil yubil cha'an mi la' cotyan yaño' bʌ cha'an mach asiyicob. Tyem ñʌch'ʌl mi la' wajñel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús ti loq'ui majlel ti Capernaum. Ya' ti c'oti ti pañimil Judea bʌ i c'aba' ya' ti junxejlel Jordán ja'. Ya' ti' cha' much'quiyob i bʌ quixtyañu. Jesús ti' cʌntisʌyob bajche' i tyʌlel mi' cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Che' jini ti tyʌliyob ba'an Jesús cha'tiquil uxtiquil fariseojob cha'an i jop' i yotsʌbeñob i mul Jesús. Jin cha'an ti' c'ajtibeyob Jesús mi weñʌch mi' cʌy i yijñam winic. ");
INSERT INTO ctu76_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús ti' jac'beyob: ¿Chuqui ti' subetla Moisés ti mandar? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jini fariseojob ti yʌlʌyob: Moisés ti yʌq'ue winicob i melben i juñilel ba' mi yʌl cʌyʌlix i yijñam. Che' jini ch'ujbix i cʌye'. Che' ti yʌlʌ Moisés, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús ti' cha' jac'beyob: Pero cha'an tsʌts la' pusic'al chʌ'ʌch ti' ts'ijbubeyetla Moisés. ");
INSERT INTO ctu76_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero ti tyejchibal che' ñac ti' mele mulawil Dios, ti' mele winic yic'ot x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Jin cha'an winic mi' cʌy i tyat i ña' cha'an ajnic yic'ot i yijñam. ");
INSERT INTO ctu76_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Juntiquil jach mi majlelob yubil jini cha'tiquil. Jin cha'an mach cha'tiquilobix. Juntiquil jachix yubil. ");
INSERT INTO ctu76_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jin cha'an mach yom i cha' t'oxe' winic tsa' bʌ i much'qui Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Che' ya'añob ti otyot, jini ajcʌnt'añob ti' cha' c'ajtibeyob Jesús chuquiyes isujm ili t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús ti' subeyob: Jini mu' bʌ i cʌye' i yijñam mu' bʌ i cha' tyaje' yambʌ yijñam, chʌncol jach i cha'len i tsuculel ti' contra jini ñaxan bʌ yijñam. ");
INSERT INTO ctu76_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Che' je'el, mi ti' cʌyʌ i ñoxi'al jini x'ixic, mi ti' tyaja yambʌ i ñoxi'al, mi' cha'len i tsuculel je'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Che' jini, quixtyañujob ti' pʌyʌyob tyʌlel alp'eñalob ba'an Jesús cha'an Jesús mi' tyʌl jini alp'eñalob. Pero ajcʌnt'añob ti queji i tic' jini tsa' bʌ i pʌyʌyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús ma'an ti' saj mulʌ che' ñac ti' q'uele. Ti' subeyob: La' tyʌlicob ba'añon jini alp'eñalob. Mach la' tic'ob como i cha'añobʌch che'ob bʌ bajche' alp'eñal mi yajñel ti yumintyel Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ubinla bajche' mic subeñetla. Jini yom bʌ i yochel ti yumintyel Dios la' i mel i bʌ bajche' juntiquil alʌl. Machqui ba'an mach ch'ujbi ochic. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Che' jini, ti' meq'ue jini alp'eñalob. Jesús ti yʌc'ʌ i c'ʌb ti' pam i jolob jini alp'eñalob. Ti yʌq'ueyob i yutslel i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús ti queji ti cha' xʌmbal majlel ti bij. Ti tyʌli ti ajñel juntiquil colem alob. Ti ñocle ti' t'ejl Jesús. Ti' sube: Weñet bʌ maestro, ¿chuqui yom c cha'len cha'an c tyaje' j cuxtyʌlel mach'ʌ yujil jilel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús ti' sube: ¿Chucoch mi a wʌle' mi weñon? An juntiquil jach wen bʌ, jiñʌch Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","A wujilʌch isujm jini mandar tyac: Mach la' pejcan yambʌ x'ixic, mach la' cha'len tsʌnsa, mach la' cha'len xujch', mach la' jop'en i mul la' pi'ʌl, mach la' lo'lon la' pi'ʌl, ac'ʌ ti ñuc la' tyat, la' ña'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jini alob ti yʌlʌ: Maestro, tsʌ'ʌch c lu' ch'ujbi ti pejtyelel c'ʌlʌ che' ñac alʌlon tyo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ti' ch'uj q'uele jini alob. Ti' p'untyʌ. Ti' sube: Yom tyo a cha'len yambʌ junchajp. Cucu, lu' choño pejtyel chʌ bʌ yes an a cha'an. Aq'ueñob p'ump'uño' bʌ. Mi chʌ'ʌch ma' cha'len mi quej a wʌq'uentyel cabʌl chʌ bʌ an a cha'an ti panchan. La', aunque ma' tsʌnsʌntyel tij caj. Tsʌcleñon majlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Che' ñac ti yubi jini alob i t'an Jesús, tyoj bʌc'ñʌjel ti yubi. Ñoj ch'ʌjyem ti cha' sujti majlel como an cabʌl chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús ti' q'uele ti' suttyʌlel. Ti' sube ajcʌnt'añob i cha'an: Ñoj wocol mi yochel ti yumintyel Dios jini añob bʌ cabʌl chʌ bʌ an i cha'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Che' ñac ti yubiyob jini t'an, tyoj bʌc'ñʌjelob jini ajcʌnt'añob. Jesús ti i cha' subeyob: Calobilob, ñoj wocol mi yochel ti yumintyel Dios jini mu' bʌ i p'untyan chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Más wocol mi yochel rico bʌ quixtyañu ti yumintyel Dios bajche' mi ñumel juncojt colem animal camello bʌ i c'aba' ti' ch'ub junts'ijt acuxan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ti utsi quejiyob ti bʌq'uen. Ti' subeyob i bʌ: ¿Majchqui ch'ujbi i tyaj i cotyʌntyel, che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús ti queji i ch'uj q'uelob. Ti' subeyob: Winicob mach ch'ujbi i cha'leñob. Pero Dios bʌ yi ch'ujbiyʌch i cha'len. Como Dios bʌ yi ch'ujbiyʌch i lu' cha'len chʌ bʌ yes yom, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro ti queji i suben: Pero joñon lojon tsa'ix c lu' cʌyʌ lojon pejtyelel chʌ bʌ an lojon c cha'an. Chʌncolix lojon c tsʌcleñet majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús ti' jac'be: Melel mic subeñetla, che' majchical jach mi' cʌye' i yotot, mi yʌscuñob, mi i chichob, mi yijts'iñob, mi i tyat, mi i ña', mi yijñam, mi yalobil, mi i lum, cha'an ti caj i tsʌcleñon cha'an ti caj ili wen bʌ t'an cha'an la' cotyʌntyel, ");
INSERT INTO ctu76_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mi quejel i tyaje' más i yoñlel bʌ. Ñumen ti cien mi quejel i tyaje' yubil wʌ' ti mulawil i yotyot, i yʌscuñob, i chichob, i yijts'iñob, i ña'ob, i yalobilob, i lum tyac. Aunque mi quejel i tyʌc'lʌntyel. Ti tyal tyo bʌ ora mi quej i tyaj i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Cabʌl ñuco' bʌ ti mulawil ti wi'il mach'an mi quejel i q'uejlel ti ñuc. Cabʌl jini mach'ʌ ñuc wʌ' ti mulawil, ti wi'il mi quej i yajñel ti ñuc. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Añob ti bij cha'an i letselob majlel ti Jerusalén. Jesús ñaxan ti majli. Pensaltic ti yubiyob ajcʌnt'añob i cha'an. Chʌncolob jach i bʌq'uen tsʌcleñob jini quixtyañujob tsa' bʌ i tsʌcleyob majlel. Jesús ti' cha' bajñel pʌyʌyob tyʌlel ti' docejlel. Ti queji i subeñob chʌ bʌ mi quejel i tyumbentyel. ");
INSERT INTO ctu76_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ti yʌlʌ: Q'uele la' wilan, chʌncox lac letsel majlel ti Jerusalén. Ya'i Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti' c'ʌb jini ñuco' bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob. Mi quejel i yʌc'on ti tsʌnsʌntyel. Mi quejel i yʌc'oñob ti' c'ʌb mach'ʌ israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Mi quejel i wajleñoñob, mi quejel i jats'oñob ti pʌchij mi quejel i tyujbañoñob, mi quejel i tsʌnsañoñob. Pero ti yuxp'ejlel q'uin mi quejel c cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Che' jini, ti' lʌc'ʌyob Jesús Jacobo yic'ot Juan i yalobilob Zebedeo. Ti yʌlʌyob: Maestro, comʌch a wʌq'ueñon lojon mu' bʌ quejel lojon j c'ajtibeñet, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesús ti' subeyob: ¿Chuquiyes la' wom mic melbeñetla? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ti' jac'ʌyob: Com motin buchlecon lojon juntiquil ti a ñoj yic'ot juntiquil ti a ts'ej che' ya' añet ti a ñuclel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús ti' cha' jac'ʌ: Mach'an mi la' ña'tyan chʌ bʌ yes chʌncol la' c'ajtin. ¿Ch'ujbi ba la' ñusan jini wocol mu' bʌ quej c ñusan? Como ñoj cʌlʌx wocol bajche' mi quej c ñusan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ti' jac'ʌyob: Ch'ujbiyʌch, che'ob. Jesús ti' subeyob: Melelʌch mi quejel la' ñusan jini wocol mu' bʌ quej c ñusan. Ñoj cʌlʌx mi quejel la' ñusan. ");
INSERT INTO ctu76_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero mach c wenta cʌle' majchqui mi quejel i buchtyʌl tic ñoj yic'ot tic ts'ej. Ya' mi buchtyʌlob jini tsa' bʌ chajpʌbentiyob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Che' ñac ti yubiyob, jini yaño' bʌ diez ti queji i mich'q'uelob Jacobo yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Che' jini Jesús ti' pʌyʌyob tyʌlel jini docejob. Ti' subeyob: La' wujil bajche' mi' pʌsob i bʌ ti ñuc yumʌlo' bʌ wʌ' ti mulawil. Ñoj tsʌts mi' xic' quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero jatyetla mach chʌ'ic yom la' cha'len. Pero jini yom bʌ ajñel ti ñuc ti la' tyojlel, la' i cha'len cotyaj ti' tyojlel i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jini más ñuc bʌ yom ajñel ti la' tyojlel, yom i yotsan i bʌ che' bajche' lolon ajtroñel jach la' cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mach'an ti tyʌliyon i Pi'ʌlon bʌ Quixtyañujob cha'an cha'libenticon c troñel ti quixtyañujob. Pero ti tyʌliyon j cotyañob. Ti tyʌliyon cʌc' c bʌ ti sajtyel cha'an i tyojol i loq'uib cabʌlob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ya' ti c'otiyob ti Jericó. Che' ñac ti loq'ui majlel ya' ti Jericó Jesús yic'ot ajcʌnt'añob i cha'an, yic'ot cabʌl quixtyañu, ya' ti' tyajayob ti bij juntiquil muts'ul bʌ i wut Bartimeo bʌ i c'aba'. Yalobil Timeo. Buchul ti bij i c'ajtin majtyan tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Che' ñac ti yubi lʌc'ʌl i tyʌlel Jesús ch'oyol bʌ ti Nazaret, c'am ti queji ti t'an. Ti yʌlʌ: Jesús, i jiñʌjlelet bʌ David tsa' bʌ i choco tyʌlel Dios, p'untyañon cha'an a cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Cabʌl ti queji i tic'ob cha'an lajmic ti t'an. Más c'am ti queji ti t'an. Ti yʌlʌ: I jiñʌjlelet bʌ David tsa' bʌ i choco tyʌlel Dios, p'untyañon cha'an a cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús ti' poj cʌyʌ xʌmbal. Ti yʌlʌ: Pʌyʌla tyʌlel, che'en. Ti' pʌyʌyob jini muts'ul bʌ i wut. Ti queji i subeñob: Tijicñisan a pusic'al. Tyejchen. Chʌncox i pʌyet, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Che' jini ti' wel choco cʌytyʌl i mosil. Ti wa' tyejchi. Ti c'oti ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús ti' sube: ¿Chuquiyes a wom mic melbeñet? che'en. Jini muts'ul bʌ i wut ti' jac'ʌ: Maestro, com j q'uele' pañimil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús ti' sube: Cucux, tsa'ix cotyʌntiyet cha'an ti a ch'ujbiyon ti a pusic'al, che'en. Ti queji i wa' ilan pañimil. Ti' tsʌcle majlel Jesús ti bij. ");
INSERT INTO ctu76_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Che' ñac lʌc'ʌlix añob ti Jerusalén, ya' ti lum tyac Betfagé yic'ot Betania bʌ i c'aba', ya' ti lʌc'ʌlel wits Olivajol bʌ i c'aba', Jesús ti' xiq'uiyob majlel cha'tiquil ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jesús ti' subeyob: Cucula ya' ti jump'ej saj lum ya' bʌ'an ti la' tyojel. Ya' ti' ti' lum che' ochel muq'uetla ya' cot cʌchʌl mi quej la' tyaj juncojt tsijib burro. Max tyo ba'an majch ti c'ʌchtyʌ. Tiquila. Pʌyʌla tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Anqui majch ti' subetla: ¿Chucoch che' mi la' cha'len bajche' jini? che'qui ti' subetla. Subenla: Yom i c'ʌñe' lojon c Yum, che' mi la' suben. Saj ora mi quej i choque' tyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Che' jini ti majliyob. Ya' ti' tyajayob jini burro ya' cot cʌchʌl ti' ti' otyot ya' ti calle. Ti' tiquiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jini ya' bʌ wa'alob ti queji i yʌlob: ¿Chuqui muq'uetla? ¿Chucoch mi a tique'la jini burro? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Che' jini, ti' jac'ʌyob bajche' ti wʌ alʌ Jesús. Che' jini tsʌ'ʌch yʌc'ʌyob i pʌye' majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ti' pʌyʌyob majlel jini burro ya' ba'an Jesús. Ti' tyasibeyob i pat jini burro ti' pislelob. Jesús ti' c'ʌchtyʌ majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cabʌlob ti' tyʌsʌyob majlel i pislel ya' ti bij. Yaño' bʌ ti' lin ac'ʌyob majlel yopol tye' ti bij tsa' bʌ i seq'ueyob ya'i. ");
INSERT INTO ctu76_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jini ñaxaño' bʌ majlel yic'ot wi'ipat bʌ majlel c'am bʌ t'an chʌncolob majlel. Chʌncol yʌlob: La' sujbic i ñuclel Dios. Tijicñayet jatyet mu' bʌ a tyʌlel cha'an che' yom lac yum Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tijicñayob jini mu' bʌ i yumiñob Dios che' bajche' ti wʌ subenti lac yum David ti ñoj oniyix. La' sujbic i ñuclel Dios. Che' ti yʌlʌyob jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ya' ti ochi Jesús ti Jerusalén, ya' ti pat templo. Ti' lu' yojch'o ochel ti' mali. Che' yomox ic'an ya' ti majli ti Betania bʌ i c'aba' yic'ot ti docejlelob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ti yijc'ʌlel che' ñac ti loq'uiyob ya' ti Betania anix i wi'ñal Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ti' ñajtyʌ ilʌ juntyejc tye' higuera bʌ i c'aba'. Ti majli i q'uele' mi an i wut. Che' ñac ti c'oti, i yopol jach ti' tyajbe. Como max tyo i yorojlel i wut. ");
INSERT INTO ctu76_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Che' jini, Jesús ti' sube cha'an ma'ix majch mi quej i saj c'uxben i wut ti bele' q'uin. Jini ajcʌnt'añob ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Che' jini ti c'otiyob ti Jerusalén. Che' ñac ti c'oti ti pat templo Jesús ti queji i chocob loq'uel mu' bʌ i chon mu' bʌ i mʌn ya'i. Ti' ch'a' chocbeyob i mesa tyac ajq'uex tyaq'uiñob, yic'ot i buchlib tyac chʌncolo' bʌ i choñob x'ujcutsu'. ");
INSERT INTO ctu76_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesús ti' tiq'uiyob cha'an mach i ch'ʌmob majlel i cuch ya' ti' pat templo. ");
INSERT INTO ctu76_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ti queji i cʌntisañob. Ti yʌlʌ: Ya' ti Ts'ijbubil bʌ i T'an Dios mi yʌle': Jini cotyot mi pejcʌntyel ti i yotyotlel oración cha'an pejtyelel quixtyañujob. Pero jatyetla tsa'ix la' sutqui ti yotyotlel ajxujch'ob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Che' jini ti yubiyob jini ñuco' bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob. Ti' sʌclʌyob bajche' ch'ujbi i tsʌnsañob como chʌncol i bʌc'ñan como ti pejtyel quixtyañu tsijc' che'ob i pusic'al cha'an i cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Che' yomox ic'an tsa'ix loq'ui majlel ti lum Jesús yic'ot ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ti sʌc'an ti yijc'ʌlel ti cha' ñumiyob ya' ba'an jini higuera bʌ tye'. Ti yilʌyob yoque tyʌquinix ti pejtyelel yic'ot i wi'. ");
INSERT INTO ctu76_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ti c'ajtiyi i cha'an Pedro. Ti yʌlʌ: Maestro, q'uele, ñoj tyʌquinix ili tye' tsa' bʌ a t'ojti'i, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús ti' jac'ʌ: Ch'ujbinla Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Melel bajche' mic subeñetla. Majchical jach mi' suben ili wits cha'an i ch'uye' loq'uel i bʌ cha'an ochic ti colem joyol bʌ ja', mi muc'ʌch i ch'ujbin ti jump'ej i pusic'al chʌ'ʌch mi quej i yujtyel. Mi ma'an cha'p'ej i pensal, chʌ'ʌch mi quejel yujtyel bajche' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jin cha'an mic subeñetla pejtyel chʌ bʌ mi la' c'ajtin ti oración, ch'ujbinla ti la' pusic'al mi muq'uix quej la' wʌq'uentyel. Che' jini melelʌch mi quejel la' wʌq'uentyel tsa' bʌ la' c'ajti. ");
INSERT INTO ctu76_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Che' muq'uetla ti oración, mi an majch ma' contrajin, ñusʌbenla i mul, che' jini mi quej i ñusʌbeñetla la' mul la' Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Como che' mach'an mi la' ñusʌben la' bʌ la' mul, che' jini, mach'an mi' ñusʌbeñetla la' mul la' Tyat am bʌ ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ya' ti cha' c'otiyob ti Jerusalén. Chʌncol ti xʌmbal ti pat templo Jesús. Ti queji i lʌc'ob Jesús jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob yic'ot xñoxob año' bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ti' c'ajtibeyob Jesús: ¿Baqui tyʌlem a we'tyel che' mi a niq'ui cha'len jini mu' bʌ a cha'len? ¿Majchqui ti yʌq'uet ili a we'tyel cha'an mi a niq'ui cha'len? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús ti' jac'beyob: Añʌch com bʌ j c'ajtibeñetla je'el. Mi ti la' jac'ʌ mi quejel c subeñetla baqui tyʌlem que'tyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Majchqui ti' xiq'ui jini Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja'? ¿Jim ba Dios o jim ba winicob? Jac'ʌla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jiñob ti queji i bajñel subeñob i bʌ. Ti yʌlʌyob: Mi ti la cʌlʌ tyʌlem ti panchan mi quejel i cha' c'ajtibeñonla, ¿chucoch ma'an ti la' ch'ujbibe? ");
INSERT INTO ctu76_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ch'ujbi ba la cʌle' tyʌlem ti winicob? Como ti' bʌc'ñʌyob quixtyañujob como ti' ña'tyʌyob cha'an ti pejtyelel quixtyañu ti' ch'ujbiyob cha'an Dios ti' xiq'ui yʌle' jini Juan. ");
INSERT INTO ctu76_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jin cha'an ti' subeyob Jesús: Mach cujil lojon, che'ob. Jesús ti' subeyob: Chʌ'ʌch joñon mach'an mic subeñetla baqui tyʌlem que'tyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús ti queji i pejcañob ti lajoñel tyac. Ti yʌlʌ: An juntiquil winic tsa' bʌ pʌc'ʌ ts'ujsub. Ti' joy corrajli. Ti' chajpʌ i yajnib ba' mi' pets'beñob loq'uel i ya'lel. Ti' ts'ʌpʌ chan bʌ i wa'lib cha'an i q'uintyan pañimil. Che' jini ti yʌc'ʌ ti' majñʌntyel ajcʌñʌtya ts'ujsubob. Ti majli ti ñajt bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Che' ti yorojlel i tyuc'ob ts'ujsub ti' xiq'ui majlel i yajtoñel ya' ba'an ajcʌñʌtya ts'ujsubol cha'an i t'ox ch'ʌmben i wut. ");
INSERT INTO ctu76_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero jini ajcʌñʌtya ts'ujsubol ti' chucuyob. Ti' jats'ʌyob. Ma' chʌ bʌ ti yʌq'ueyob. Ti' cha' xiq'uiyob sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Che' jini i yum ts'ujsubol ti' cha' xiq'ui majlel yambʌ ajtoñel. Che' jini ya' ti yʌc'beyob ti tyun. Ti' lowbeyob i jol. Ti' wen wajleyob che' ñac ti yajnisʌ sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Che' jini i yum ti cha' xiq'ui majlel yambʌ. Jini ti' tsʌnsʌyob. Che' je'el ti' xiq'ui majlel cabʌl yaño' bʌ. An tsa' bʌ i jats'ʌyob. An tsa' bʌ i tsʌnsʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ya' tyo ti cʌyle ti yotyot i yum ts'ujsubol juntiquil yalobil p'untyʌbil bʌ i cha'an. Che' jini, ti' xiq'ui majlel jini i yalobil ya' ba'añob. Ti' ña'tyʌ: Muq'uix i wersa q'uelob ti ñuc calobil. Che' ti' lolon pensali. ");
INSERT INTO ctu76_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Che' jini, jini ajcʌñʌtya ts'ujsubol ti' subeyob i bʌ: Jiñʌch mu' bʌ i quejel i yochel ti' yum ili ts'ujsubol. La' lac tsʌnsan. Che' jini, mi quej lac ch'ʌme' ili ts'ujsubol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Che' jini, ti' chucuyob. Ti' tsʌnsʌyob. Ti' jʌp chocoyob loq'uel i bʌc'tyal ya' ti ts'ujsubol. ");
INSERT INTO ctu76_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Che' jini Jesús ti' c'ajtibeyob: ¿Chuquiyes mi quej i cha'len mi la' wʌl i yum ts'ujsubol? che'en. Mi quejel i tyʌlel i tsʌnsañob jini ajcʌñʌtya ts'ujsubol. Mi quejel i yʌq'ueñob ili ts'ujsubol ti' wenta yaño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Mach'a ba'an ba' ti la' q'uele jini Ts'ijbubil bʌ i T'an Dios? Mi yʌl: Jini tyun tsa' bʌ i chocoyob ajmel tyuni otyot ti ochi ti' wentyʌlel oy ti' xujc' otyot. ");
INSERT INTO ctu76_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Jiñʌch i cha'libal lac Yum. Tyoj bʌc'ñʌjel mi laj q'uele' jini tsa' bʌ i cha'le. Che' ts'ijbubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob, yic'ot xñoxob año' bʌ i ye'tyel, ti queji i ña'tyañob bajche' ch'ujbi i chucob Jesús como ti' ña'tyʌyob añʌch isujmlel ili lajoñel ti' contrajob. Pero cha'an ti' bʌc'ñʌyob quixtyañu ti' cʌyʌyob Jesús. Ti majliyob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Che' jini ti' chocoyob majlel cha'tiquil uxtiquil fariseojob yic'ot junmujch' herodianojob cha'an mi' ñʌch'tyʌbeñob i t'an Jesús cha'an mi' jop'beñob i mul. ");
INSERT INTO ctu76_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Che' ti c'otiyob ti yʌlʌyob: Maestro, cujil lojon isujm cha'an melelʌch chʌ bʌ ma' wʌle'. Ma'an ma' pensalin chʌ bʌ jach mi yʌlob. Junlajal jach ma' q'uel winicob mi an i ye'tyel mi ma'an i ye'tyel. Junsujm jach ma' cha'len cʌntisa cha'an i bijlel Dios. Jin cha'an com j c'ajtibeñet: ¿Bajche' ma' wʌle? ¿Yom ba mi la cʌq'uen tyojoñel ñoj ñuc bʌ yumʌl o mach yom? ¿Yom ba mi lac tyoj o mach yom? Che' ti' c'ajtibenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús ti' ña'tyʌ cha'chajp i pensal jini ya' bʌ añob. Jin cha'an ti' subeyob: ¿Chucoch mi la' sʌclʌbeñon c mul? Ch'ʌmbeñon tyʌlel junwejch tyaq'uin cha'an j q'uele'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Che' jini ti' ch'ʌmʌyob tyʌlel tyaq'uin. Jesús ti' subeyob: ¿Majchqui i loc'om wʌ' bʌ an ti tyaq'uin? ¿Majchqui i c'aba' wʌ' ts'ijbubil? che'en. Ti' jac'ʌyob: I cha'an jini ñoj ñuc bʌ yumʌl, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesús ti' subeyob: Che' jini, aq'uenla ñoj ñuc bʌ yumʌl i cha'an bʌ yumʌl. Aq'uenla Dios i cha'an bʌ Dios, che'en. Tyoj bʌc'ñʌjelob che' ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ti' lʌc'ʌyob Jesús cha'tiquil uxtiquil saduceojob. Jiñʌch mu' bʌ i yʌlob cha'an mach'an mi lac cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Ti' c'ajtibeyob Jesús: ");
INSERT INTO ctu76_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, Moisés ti yʌq'ueyonla mandar chʌ bʌ yom i cha'len mi ti sajti juntiquil winic mi ti' bajñel cʌyʌ yijñam che' max tyo ba'an yalobil. Ti yʌlʌ yom i wersa pʌyben yijñam yʌscun jini ijts'iñʌl bʌ cha'an mi' tyejchben i jiñʌjlel jini tsa' bʌ sajti. Che' ti yʌlʌ Moisés, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Che' jini, an siete winicob yoque yijts'iñob i bʌ. Ti' pʌyʌ yijñam jini ascuñʌl bʌ. Ti sajti che' max tyo ba'an i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Che' jini, i cha'ticlel bʌ yijts'in ti' pʌybe i yijñam i yʌscun. Ti sajti je'el che' max tyo ba'an i yalobil. Chʌ'ʌch je'el ti yuxticlel. ");
INSERT INTO ctu76_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ti lu' sajtiyob c'ʌlʌ ti' sietejlelob. Ma'an ti' cʌyʌ i yalobil mi junticlec. Che' jini ti sajti jini x'ixic je'el. ");
INSERT INTO ctu76_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Che' ti yorojlel mi cha' tyejchelob jini sajtyemo' bʌ, ¿majchqui i ñoxi'al jini x'ixic ma' wʌl? Como ti' sietejlelob ti' pʌyʌyob cha'an i yijñam. Che' ti yʌlʌyob saduceojob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús ti' subeyob: Mi la' wotsan la' ñajayel tyac como mach'an mi la' ch'ʌm'en isujm Ts'ijbubil bʌ i T'an Dios mi i p'ʌtyʌlelic Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Como che' mi' cha' tyejchelob loq'uel ba'an sajtyemo' bʌ, ma'ix mi' pʌyob i yijñam, ma'ix mi sijintyelob je'el. Mi quejel i yajñelob che' bajche' mi yajñel ajtroñelob i cha'an Dios am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Cha'an i sujmlel bajche' mi cha' tyejchel sajtyemo' bʌ, ¿mach'a ba'an q'uelel la' cha'an ya' ti' jun tsa' bʌ i ts'ijbu Moisés ba' Dios ti' pejcʌ Moisés che' loq'uem i t'an Dios ti pimel mu' bʌ ti lejmel? Ti yʌlʌ: Joñon i Dioson Abraham, i Dioson Isaac, i Dioson Jacob. Che' ti yʌlʌ Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Tsiquil che' jini, Dios bʌ yi i Diosʌch cuxulo' bʌ. Aunque sajtyem i bʌc'tyal pero cuxul i ch'ujlel. Jin cha'an an cabʌl la' ñajayel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ti c'oti ba'an Jesús juntiquil ajcʌntisa cha'an i mandar israelob tsa' bʌ yubi che' ñac muc'ob ti t'an. C'otyajax ti yubi bajche' ti' jac'ʌ Jesús. Ti' c'ajtibe: ¿Baqui bʌ más ñuc ti pejtyelel jini mandar tyac? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús ti' jac'ʌ: Jini más ñuc bʌ mandar jiñʌch mu' bʌ yʌle': Ñʌch'tyanla israelet bʌ la. Jini lac Yum, lac Dios, jiñʌch juntiquil jach bʌ lac Yum. ");
INSERT INTO ctu76_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","P'untyan la' Yum la' Dios ti pejtyelel la' pusic'al, ti pejtyelel la' ch'ujlel, ti pejtyelel la' ña'tyʌbal yic'ot ti pejtyelel la' p'ʌtyʌlel. Jiñʌch jini más ñuc bʌ mandar. ");
INSERT INTO ctu76_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Lʌc'ʌl lajal bʌ yic'ot i cha'p'ejlel bʌ mandar ba' mi yʌl: P'untyan a pi'ʌlob ti chumtyʌl lajal bajche' mi a bajñel p'untyan a bʌ. Che' mi yʌle' jini mandar tyac. Mach'an yambʌ mandar más ñuc bʌ bajche' iliyi. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Che' jini, jini ajcʌntisa ti' sube Jesús: Ñoj melel, Maestro. Melelʌch bajche' ma' wʌle' che' juntiquil jach jini Dios, mach'an yambʌ Dios. ");
INSERT INTO ctu76_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Melelʌch, che' mi lac p'untyan Dios ti pejtyelel lac pusic'al, ti pejtyelel lac ña'tyʌbal, ti pejtyelel lac ch'ujlel, ti pejtyelel lac p'ʌtyʌlel yic'ot che' mi lac p'untyan lac pi'ʌl ti chumtyʌl lajal bajche' mi lac bajñel p'untyan lac bʌ, melelʌch más wen bajche' pejtyelel ba'ic jach bʌ i majtyan Dios. Che' ti yʌlʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Che' ñac ti yubi Jesús che' weñʌch mu' ti t'an jini winic ti queji i suben: Ts'itya' jachix ma' ma' ñoj ña'tyan, cha'an ma' wochel ti yumintyel Dios, che'en. Che' jini mach'anix majch ti queji i cha' c'ajtiben tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Che' ñac muc' ti cʌntisa Jesús ya' ti pat templo ti queji i yʌle': ¿Bajche'qui isujm che' mi yʌlob ajcʌntisa cha'an i mandar israelob mi i jiñʌjlel David jini Cristo jini yajcʌbil bʌ i cha'an Dios? ");
INSERT INTO ctu76_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Como ti' p'ʌtyʌlel Ch'ujul bʌ i Ch'ujlel Dios David ti yʌlʌ: Jini lac Yum ti' sube jini c Yum: Buchi' tic ñoj cha'an tsiquilʌch a ñuclel, jintyo mi cʌq'ueñet cha'an a jisʌben i p'ʌtyʌlel a contrajob. Che' ti wʌ subenti Jesús ti Dios, che' David. ");
INSERT INTO ctu76_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Bajche'qui ch'ujbi che' i jiñʌjlelon David jini Cristo che' David ti yʌlʌ Cristo ti Yum? Che' ti yʌlʌ Jesús. Jini much'quibilo' bʌ quixtyañu c'ajacñayob i yoj che' ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Che' ñac muc' ti cʌntisa Jesús ti yʌlʌ: Cʌñʌtyan la' bʌ cha'an ajcʌntisajob cha'an i mandar israelob mu' bʌ i mulañob i wen ch'ʌlob i bʌ che' mi majlelob ti xʌmbal. Mi' mulañob che' cabʌl mi' pejcʌntyelob ya' ti calle tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Mi' mulañob más wen tyac bʌ buchlibʌl ya' ti templo tyac israelob yic'ot jini más wen bʌ buchlibʌl ti q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mi' chilbeñob i lum jini meba' ixicob. Mi' melob tyam bʌ oración cha'an wen mi yilʌntyel. Jiñobʌch más bʌbʌq'uen bʌ mi quej i yʌq'uentyel i xot'ob i mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ya' buchul Jesús ti' tyojel ba' mi yotsañob ofrenda. Chʌncol i yilan che' mi yotsañob tyaq'uin ti yajnib. Cabʌl ricojob bʌ ti yʌc'ʌyob i yonlel tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ya' ti c'oti juntiquil meba' ixic mach'ʌ ba'an chʌ bʌ an i cha'an. Ti yotsʌ cha'wejch tyaq'uin. Jini cha'wejch tyaquin lajalʌch bajche' diez centavos. ");
INSERT INTO ctu76_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesús ti' pʌyʌ ajcʌnt'añob i cha'an. Ti' subeyob: Melel mic subeñetla, ili p'ump'um bʌ meba' ixic más on ti yotsʌ ya' ti yajnib ofrenda bajche' ti pejtyelel jini yaño' bʌ yubil. ");
INSERT INTO ctu76_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Como jini yaño' bʌ, an tyo yonlel chʌ bʌ an i cha'an ti cʌyle. Jini x'ixic ma'ix chʌ bʌ an i cha'an ti cʌyle. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Che' ñac ti loq'ui Jesús ya' ti pat colem templo i cha'an israelob juntiquil ajcʌnt'an i cha'an ti queji i suben: Maestro, q'uele c'otya tyacjax ili tyun. Ñoj wen melel ili templo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús ti' c'ajtibe: ¿Chʌncol ba a q'uele' che' ñoj wen melel tyac ili otyot? Pero mach'an mi quejel i saj cʌytyʌl mi jump'ejlic tyun ti' pam yambʌ. Mi quejel i lu' jejmel jubel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Che' jini ti majliyob ti wits Olivajol bʌ i c'aba' ya' ti' tyojel jini templo. Che' ñac ya' buchul Jesús yic'ot Pedro, Jacobo, Juan yic'ot Andrés ti queji i bajñel c'ajtibeñob tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Subeñon lojon, ¿jalajqui mi quej i yujtyel pejtyel jini? ¿Chuqui ti seña mi quejel che' mi lu' ts'ʌctiyel pejtyel jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús ti' subeyob: Yom wen xuc'uletla cha'an mach'an majch ch'ujbi i lotiñetla. ");
INSERT INTO ctu76_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Cabʌl mi quej i tyʌlelob mu' bʌ i quejel i c'ʌmbeñon j c'aba'. Mi quejel i yʌlob: Joñon Cristojon yajcʌbilon bʌ i cha'an Dios, che'ob. Cabʌl mi quejel i lotintyelob. ");
INSERT INTO ctu76_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Che' mi quej la' wubin an cabʌl guerra yic'ot cabʌl t'an tyac cha'an guerra, mach quejiquetla ti bʌq'uen. Chʌ'ʌch mi quej i wersa yujtyel pero max tyo me jinic i yujtibal mulawil. ");
INSERT INTO ctu76_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Mi quejelob ti guerra jump'ej pañimil yic'ot yambʌ pañimil. Yumʌlob yic'ot año' bʌ ti' wenta mi quejel i cha'len guerra ti' contra yambʌ yumʌl. Mi quejel yujquel tyac lum ti cabʌl pañimil tyac. Mi quejel wi'ñal yic'ot wocol. Jiñʌch i tyejchibal jax tyo wocol mu' bʌ quej i ñusan quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Cʌñʌtyan la' bʌ. Mi quejel la' wʌjq'uel ti' c'ʌb ñuc bʌ ye'tyel. Mi quej i jats'etla ya' ti templo tyac israelob. Mi quejel la' pʌjyel majlel ya' ti' tyojlel año' bʌ i ye'tyel yic'ot ñuc bʌ yumʌlob cha'an tij caj joñon, cha'an mi la' subon ti' tyojlelob. ");
INSERT INTO ctu76_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Che' max tyo i yujtibal añʌch cha'an subentic quixtyañujob jini wen bʌ t'an cha'an laj cotyʌntyel ti pejtyel pañimil tyac. ");
INSERT INTO ctu76_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Che' mi' pʌyetyob majlel ba'an año' bʌ i ye'tyel mach la' ñaxan pensalin chʌ bʌ mi quej la' subeñob. Subenla jini mu' bʌ i yʌq'ueñetla a sube' Dios ti jim bʌ ora. Che' jini mach jatyeticla muq'uet bʌ la ti t'an pero jiñʌch Ch'ujul bʌ i Ch'ujlel Dios muc' ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Jini i yijts'iñob i bʌ mi quejel i yʌc'ob i bʌ ti' c'ʌb jini yom bʌ i tsʌnsañob. Winic mi quejel i yʌq'ue' ti tsʌnsʌntyel i yalobil. I yalobilob mi quejel i contrajiñob i tyat i ña'. Mi quej i yʌc'ob ti tsʌnsʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ti pejtyelelob mi quejel i mich'q'ueletla cha'an ti caj chʌncol la' tsʌcleñon. Che' jini, jini mu' bʌ i cuche' i wocol c'ʌlʌl ti jilibal mi quejel i cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Mi quejel la' wilan mi yujtyel bajche' ti wʌ alʌ tsa' bʌ xijq'ui yʌle' Daniel bʌ i c'aba'. Ti' ts'ijbu cha'an mi quejel la' wilan jini ñoj bibajax bʌ mu' bʌ i jisan cabʌl chʌ bʌ yes tyac ya'ix wa'al ya' ba' mach yom ochic. Jini mu' bʌ i q'uele' ili jun yom i ch'ʌmben isujm che' mi yilan bajche' ti wʌ ajli. Che' jini, jini año' bʌ ti Judea che' mi' q'uele' bajche' mi yujtyel yom puts'icob majlel ti wits. ");
INSERT INTO ctu76_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ti jim bʌ ora jini am bʌ ti' pat i yotyot mach yom jalec cha'an i yochel i ch'ʌme' loq'uel chʌ bʌ an i cha'an ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jini mu' bʌ i majlel ti' cholel mach yom cha' sujtic ti yotyot mi cha'anic i loc'san i pislel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ñoj p'ump'uñob che' bajche' mi quejel i ñusañob wocol jini cʌñʌtyʌbil tyo bʌ i cha'an i yalobil, yic'ot chʌncol tyo bʌ i tsu'san i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cha'lenla oración cha'an mach ti yorojlel tsʌñal mi la' wersa majlel ti puts'el. ");
INSERT INTO ctu76_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ñoj wocol mi quejel ili q'uin tyac. Más wocol bajche' pejtyel wocol tyac bʌ c'ʌlʌl ti' tyejchibal ili mulawil tsa' bʌ i mele Dios c'ʌlʌ wale iliyi. Mach'an ba' bʌ ora mi quejel i ñumel lajal bʌ wocol. ");
INSERT INTO ctu76_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mi mach'an mi' com'isan Dios ili q'uin tyac, mach'an majch mi' cuche'. Pero mi quej i com'isan ili q'uin tyac cha'an ti caj mi' p'untyan Dios jini tsa' bʌ i wʌ yajcʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Che' jini mi an majch mi' subeñetla: Q'uele wʌ'an wʌ'i jini Cristo yajcʌbil bʌ i cha'an Dios, che'en, o yambʌ mi yʌl: Cucu, q'uelela ya'an Cristo, jini yajcʌbil bʌ i cha'an Dios ya'ya'i, che'en. Mach yom la' ch'ujbin. ");
INSERT INTO ctu76_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Como cabʌl mi quejel i lolon subob i bʌ ti Cristo yic'ot mi quej i lolon yʌlob xiq'uil tyʌlel i cha'an Dios. Mi quej i pʌsob tyac i señʌjlel yic'ot ñuc tyac bʌ i p'ʌtyʌlel cha'an yom i lotiñob jinic tyo yajcʌbilo' bʌ i cha'an Dios mi ti mejliyob. ");
INSERT INTO ctu76_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero jatyetla yom tsajibiletla. Joñon tic wʌ subetla pejtyelel jini. Che' ti wʌ alʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jim bʌ ora che' ujtyemix ili wocol tyac bʌ mi quejel i yic'an q'uin. Mach'an mi quej i lejmel i c'ʌc'al uw. ");
INSERT INTO ctu76_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mi quejel i yajlel tyac jubel ec' am bʌ ti chan yic'ot pejtyel chʌ bʌ an ti chan mi quejel i nijcʌyel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mi quejel i yilañoñob Joñon i Pi'ʌlon bʌ Quixtyañujob che' mi quejel c tyʌlel ti tyocal tic p'ʌtyʌlel yic'ot c ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Che' mic tyʌlel mi quejel c choc tyʌlel ajtroñelob c cha'an ch'oyol bʌ ti panchan. Mi quejel i much'quiñob jini yajcʌbilo' bʌ i cha'an Dios ti chʌnwejlel mulawil c'ʌlʌl ti junxejlel mulawil c'ʌlʌl ti ñajtlel chan. ");
INSERT INTO ctu76_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Cʌñʌla jini lajoñel cha'an higuera bʌ i c'aba' bʌ tye'. Che' an i buts che' chʌncol i ch'ojquijñel i yopol, che' jini mi la' ña'tyan lʌc'ʌlix i yorojlel q'uin tyunil. ");
INSERT INTO ctu76_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Che' je'el, che' mi la' q'uele' chʌncol i yujtyel tyac iliyi, mi la' ña'tyan lʌc'ʌlix i yorojlel mi quej c cha' tyʌlel. Mero más lʌc'ʌlix mach tyalon, yubil. ");
INSERT INTO ctu76_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Melel mic subeñetla mi quejel i yujtyel tyac ti pejtyelel iliyi che' max tyo ti sajtiyob ili quixtyañujob wʌ' tyo bʌ añob ti ili ora. ");
INSERT INTO ctu76_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mi quejel i sʌc jilel majlel chan yic'ot mulawil pero c t'an mach saj jil. Mux i lu' ts'ʌctiyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mach'an majch yujil baqui bʌ q'uin o baqui bʌ ora mi yujtyel jini, mi ajtroñelobic ya' ti panchan, mi jinic joñon i Yalobilon mach cujil isujm. Jin jach c Tyat am bʌ ti panchan yujil isujm. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jin cha'an yom yʌxʌl la' woj. Wen ña'tyanla. Cha'lenla oración. Como mach'an mi la' ña'tyan baqui bʌ ora mi quej i c'otyel yorojlel. ");
INSERT INTO ctu76_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chʌ'ʌch mi quejel i yujtyel bajche' juntiquil winic tsa' bʌ majli ti ñajt bʌ lum. Che' ñac ti loq'ui ti yotyot ti lu' aq'ue ti' wenta ajtroñelob i cha'an. Jujuntiquil ti yʌq'ueyob i toñel. Ti' sube juntiquil cha'an i wen cʌñʌtyʌben i ti' i yotyot. ");
INSERT INTO ctu76_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yom yʌxʌl la' woj como mach la' wujil baqui bʌ ora mi quejel i tyʌlel i yum otyot mi ti pat xinq'uinil o mi ti xin ac'bʌlel o mi ti jun uq'uel mut, o mi ti sʌc an. ");
INSERT INTO ctu76_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Yom yʌxʌl la' woj ame wa' tyʌlic che' wʌyʌletla. ");
INSERT INTO ctu76_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Jini mu' bʌ c subeñetla mic subeñob ti pejtyelelob. Yom wen yʌxʌl la' woj. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","An tyo yom cha'p'ej q'uin i q'uiñejel pascua che' mi' c'uxob caxlan waj mach'ʌ ba'an yic'ot levadura mu' bʌ yʌq'uen i wos i bʌ. Jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob chʌncol i sajcañob bajche' mi' chucob Jesús cha'an ti lot bʌ t'an cha'an i tsʌnsañob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero ti yʌlʌyob: Mach yom che' chʌncol q'uiñejel, ame nijquicob quixtyañu, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ya'an Jesús ti lum Betania bʌ i c'aba' ti yotyot Simón jini tsa' bʌ pejcʌnti ti Leproso, jiñʌch yom yʌle' juntiquil am bʌ chʌ bʌ yes pasem ti' pʌchʌlel tsa' bʌ yʌc'ʌ i pʌc'misʌben majlel i bʌc'tyal. Ya'an ti' t'ejl mesa Jesús. Ti tyʌli juntiquil x'ixic yic'ot yowocña bʌ aceite nardo bʌ i c'aba' ñoj lets bʌ i tyojol. Melel i yajnib ti tyun alabastro bʌ i c'aba'. Ti' xut'be i bic' i yajnib jini yowocña bʌ aceite. Ti' mulbe ti' jol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Cha'tiquil uxtiquil ya' bʌ añob ti mich'ʌyob. Ti yʌlʌyob: ¿Chucoch ti lolon yʌsi jini yowocña bʌ aceite? ");
INSERT INTO ctu76_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ñumen ti trescientos denarios i tyojol. Yom tsa'ic chojni cha'an i yʌq'ueñob jini p'ump'uño' bʌ yi, che'ob. Ti' mich'q'ueleyob jini x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús ti' subeyob: Chʌch ajni. ¿Chucoch mi la' tyʌc'lan? Ñoj wen ti' cha'libon ili x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Jini p'ump'uño' bʌ wʌch bele' an la' wic'ot ti bele' q'uin. Ba' bʌ ora la' wom mi mejlel la' cotyañob. Pero joñon mach'an bele' q'uin wʌ' añon quic'otyetla. ");
INSERT INTO ctu76_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jini x'ixic ti' mele ch'ujbi bʌ i mele'. Ti' ñaxan wʌ muluyon tic bʌc'tyal cha'an i chajpʌbeñon c ch'ujñʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Melel mic subeñetla, ba'ical jach mi' sujbel ili wen t'an cha'an la' cotyʌntyel, mi quejel i yʌjlel bajche' ti' cha'le jini x'ixic cha'an mi ña'tyʌntyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Che' jini, Judas Iscariote, juntiquil jini docejlelob ti majli ya' ba'an ñuc bʌ curajob cha'an i lajob i t'an cha'an bajche' ch'ujbi i yʌc' Jesús ti' c'ʌb i contra. ");
INSERT INTO ctu76_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Wen c'ajacñayob i yoj che' ñac ti yubiyob. Ti yʌc'ʌyob i t'an cha'an mi yʌc'ob tyaq'uin. Che' jini Judas ti queji i sʌclan bajche' mi yʌc' ti cʌchol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ti tyejchibal q'uiñejel che' mi' c'uxob caxlan waj mach'ʌ ba'an yic'ot i levadura mu' bʌ yʌq'uen i wos i bʌ, che' mi' tsʌnsañob tiñʌme' cha'an pascua bʌ q'uin, jini ajcʌnt'añob i cha'an Jesús ti queji i c'ajtiben: ¿Baqui a wom mi lojon c majlel c chajpʌbeñet cha'an ma' cha'len we'el che' ti q'uiñejel pascua? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Che' jini ti' xiq'ui majlel cha'tiquil ajcʌnt'añob i cha'an. Ti' subeyob: Cucula ya' ti lum. Mi quej la' tyaj juntiquil winic chʌncol bʌ i q'ueche' majlel jump'ej uc'un ja'. Tsʌclenla majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ya' ba' mi yochel subenla i yum otyot: Jini Maestro mi yʌl: ¿Baqui an jini saj mal cha'an we'icon quic'ot ajcʌnt'añob c cha'an che' ti pascua bʌ q'uiñejel? che'etla mi la' suben. ");
INSERT INTO ctu76_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Che' jini mi quejel i pʌs'eñetla jump'ej saj mal ya' ti cha'lajmlel otyot, colem chajpʌbilix i mal. Ya'i mi la' chajpan mu' bʌ quejel laj c'uxe'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ti majliyob jini ajcʌnt'añob. Ya' ti c'otiyob ti lum. Ti' tyajayob che' bajche' ti wʌ alʌ Jesús. Ti' chajpʌyob ili uch'el cha'an pascua. ");
INSERT INTO ctu76_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Che' iq'uix quejel ti tyʌli Jesús yic'ot doce ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Che' ñac chʌncolob ti we'el ya' ti mesa, ti queji i yʌle' Jesús: Melel mic subeñetla, an juntiquil wʌ' bʌ chʌncol ti we'el quic'ot mi quejel i yʌc'on ti cʌchol. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ñoj ch'ʌjyem ti queji yubiñob. Ti queji i c'ajtibeñob Jesús. ¿Joñon ba ti? Yambʌ ti yʌlʌ: ¿Joñon ba ti? che' tyacob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús ti' subeyob: Juntiquil wʌ' bʌ an la quic'ot mu' bʌ i ts'aje' i waj ti ch'ejew quic'ot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mi quejel c sajtyel Joñon i Pi'ʌlon bʌ Quixtyañujob che' bajche' wʌ ts'ijbubil. Pero ñoj wocol mi quejel i yubin jini mu' bʌ i yʌc'on ti cʌchol. Más wen machic ba'an ti ch'ocʌ ili winic. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Che' ñac muc'ob ti we'el Jesús ti' ch'ʌmʌ waj. Ti' cha'le oración. Ti' xet'e. Ti yʌq'ueyob. Ti yʌlʌ: C'uxula. Jiñʌch c bʌc'tyal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Che' jini ti' ch'ʌmʌ jump'ej but'ul bʌ vaso, ti' sube wocox i yʌlʌ Dios. Ti yʌq'ueyob. Che' jini ti pejtyelel ti' motin japʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús ti' subeyob: Jiñʌch c ch'ich'el mu' bʌ quejel c bejquel cha'an cabʌlob cha'an tsiquil mi quejel tsijib trato bʌ t'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melel mic subeñetla, mach'anix mi quej c cha' jape' jini ya'lel uva jintyo mi cape' ya' ba' lu' tsijib tyac ya' ba' mu' ti yumʌl Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Che' ti ujti i c'ʌyob jump'ej c'ay ti loq'uiyob majlel ti wits Olivajol bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesús ti' sube ajcʌnt'añob i cha'an: Ti la' pejtyelel mi quejel la' quisniñon ti ili bʌ ac'bʌlel como ti Ts'ijbubil bʌ i T'an Dios mi yʌl: Mi quej c tsʌnsan jini ajcʌñʌtya tiñʌme'. Che' jini mi quej i pam pujquelob tiñʌme'ob. Chʌ'ʌch wʌ ts'ijbubil, che' Jesús. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ti wi'il che' mi quejel c cha' tyejchel loq'uel ba'an sajtyemo' bʌ mi quej c majlel c pijtyañetla ya' ti Galilea. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pero Pedro ti' sube: Aunque ti pejtyelel mi' quisniñetyob pero mach joñonic. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús ti' jac'be: Melel mic subeñet, wale ti ili bʌ ac'bʌlel che' max tyo i cha'le cha' uq'uel tyat mut, jatyet uxyajlel mi quejel a wʌle' mach a cʌñʌyon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro ti' wersa cha' alʌ: Aunque an cha'an sajticon quic'otyet, mach'an mi quej j cʌl mach cʌñʌyet, che'en. Che' ti yʌlʌyob ti pejtyelelob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ya' ti c'otiyob ba'an jumpejt lum Getsemaní bʌ i c'aba' ba'an pʌc'ʌl bʌ tye' tyac. Jesús ti queji i subeñob ajcʌnt'añob i cha'an: Buchi'la wʌ'i che' mic majlel c cha'len oración, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ti' pʌyʌ majlel Pedro yic'ot Jacobo yic'ot Juan. Ñoj ch'ʌjyem ti queji i yubin Jesús. Ñoj c'uxucña i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ti' subeyob: Ñoj ch'ʌjyem c pusic'al. Comox sajtyel tic ch'ʌjyemlel. Wʌ' mi la' cʌytyʌl wʌ'i. Yom ch'uj p'ixiletla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tsa' tyo i cha'le xʌmbal che' lactyʌl majlel. Ti' ñuc choco i bʌ ti oración. Ti' c'ajtibe Dios cha'an mach'an mi c'otyel i yorojlel i cʌlʌx ñusan wocol mi ti mejli i tijq'uel. ");
INSERT INTO ctu76_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ti yʌlʌ: C Tyat, lu' ch'ujbiyʌch a mele'. Mach a wʌc'on cochel ti ili wocol. Pero mele jiñʌch bajche' a wom mach jinic bajche' com joñon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ti cha' c'oti ba'an ajcʌnt'añob i cha'an. Wʌyʌlobix ti' tyajayob. Ti' sube Pedro: Simón, ¿wʌyʌletix ba? ¿Mach'a ba'an ti mejli a tic' a wʌyel mi jump'ejlic ora? ");
INSERT INTO ctu76_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tiq'uila la' wʌyel. Cha'lenla oración cha'an mach'an mi la' yajlel ti mulil. Ti la' pusic'al la' wom la' mel chʌ bʌ wen pero wocol mi la' cha'len como quixtyañujetla. ");
INSERT INTO ctu76_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ti cha' majli. Lajal ti' cha'le oración. ");
INSERT INTO ctu76_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ti cha' c'oti ya' ba'añob. Cha' wʌyʌlobix ti' cha' tyajayob como bej yom i muts'ob i wut. Mach'an ti saj mejli i jac'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ti yuxyajlelel ti cha' c'oti ba'añob. Ti' subeyob: Wʌyenixla, c'ajax la' woj. Ya jaxʌl. Tsa'ix c'oti i yorojlel cha'an la' wilan Joñon i Pi'ʌlon bʌ Quixtyañujob muq'uix quejel cʌjq'uel ti' c'ʌb xmulilob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tyejchenla. Cox lac tyaj tyʌlel. Lʌc'ʌlix an jini mu' bʌ quej i yʌc'on ti cʌchol, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Che' chʌncol tyo ti t'an Jesús, ti c'oti Judas, jiñʌch juntiquil i docejlelob. Ti tyʌli yic'ot i yonlel am bʌ i machit tyac yic'ot an tyaco' bʌ i tye'. Ya' loq'uemob tyʌlel ya' ba'an jini ñuc bʌ curajob yic'ot ba'an ajcʌntisajob cha'an i mandar israelob yic'ot ba'añob xñoxob año' bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jini Judas tsa' bʌ i yʌc'ʌ Jesús ti cʌchol ti' ñaxan subeyob i bʌ bajche' mi quejel i pʌsbeñob baqui bʌ jini Jesús. Ti yʌlʌ: Jini mu' bʌ c ñup, jiñʌch jini chʌncol bʌ la' sʌclan. Chucula. Wen cʌchʌl mi la' pʌy majlel. Che' ti yʌlʌ Judas. ");
INSERT INTO ctu76_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Che' ñac ti c'oti ti' wa' lʌc'ʌ Jesús. Ti' sube: Maestro, che'en. Che' jini ti' ñupu. ");
INSERT INTO ctu76_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ti' chucuyob. Ti' cʌchʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Juntiquil ya' bʌ an yic'ot ti' bots'o i machit. Ti' tsepbe loq'uel i chiquin yajtoñel ñoj ñuc bʌ cura. ");
INSERT INTO ctu76_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús ti' sube: ¿Tsa'ix ba tyʌliyetla a wic'ot la' machit yic'ot la' tye' cha'an mi la' cʌchon che' bajche' ajxujch'on? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ti jujump'ej q'uin ya' añon quic'otyetla ti cʌntisa ya' ti templo. Mach'an ti la' saj chucuyon. Pero chʌ'ʌch chʌncol i yujtyel wale iliyi cha'an mi ts'ʌctiyel Ts'ijbubil bʌ i T'an Dios. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ti pejtyelelob ajcʌnt'añob ti' cʌyʌyob Jesús. Ti puts'iyob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ya'an juntiquil alob bʌc'ʌl bʌ ti wewel pisil. Chʌncol i tsʌclen majlel Jesús. Ti' jop'o i chucob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Che' jini ti' colo jini wewel pisil. Chacalix ti' cotyʌ i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ya' ti' pʌyʌyob majlel Jesús ya' ba'an jini ñoj ñuc bʌ cura. Che' jini, ti' lu' much'quiyob i bʌ pejtyelel yambʌ ñuc bʌ curajob yic'ot xñoxob año' bʌ i ye'tyel yic'ot ajcʌntisa cha'an i mandar israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro ti' ñajtyʌ tsʌcle majlel Jesús. C'ʌlʌl ti c'oti ya' ti pam i yotyot ñoj ñuc bʌ cura. Ya' ti buchle yic'ot policíajob. Chʌncolob ti q'uix. ");
INSERT INTO ctu76_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jini ñuc bʌ curajob yic'ot pejtyelel año' bʌ ye'tyel ti comité Junta Suprema bʌ i c'aba' ti' sajcʌyob mu' bʌ i cha'leñob jop't'an ti' contra Jesús cha'an i yʌc'ob ti sajtyel. Pero mach'an ti' tyajayob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Cabʌl ti' jop'oyob t'an ti' contra Jesús pero mach'an lajal ti loq'uiyob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ti wa'leyob cha'tiquil uxtiquil cha'an i jop'eñob i mul Jesús. Ti yʌlʌyob: ");
INSERT INTO ctu76_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ti lojon cubi ti yʌlʌ Jesús: Mi quejel quisan jini templo melel bʌ ti c'ʌbʌl. Ti yuxp'ejlelel q'uin mi quej c cha' wa'chocon yambʌ mach'ʌ ti c'ʌbʌl ti mejli, che'en, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero jini tsa' bʌ yʌlʌyob mach'an junlajal ti loq'uiyob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Che' jini, ti wa'le ti' tyojlelob jini ñoj ñuc bʌ cura cha'an i c'ajtiben Jesús: ¿Mach'a ba'an chʌ bʌ ma' jaq'ue'? ¿Chuquiyes i sujmlel chʌncol bʌ i yʌlob ti a contra? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús ch'uj ñʌch'ʌl ti cʌyle, mach'an ti' saj jac'ʌ. Jini ñoj ñuc bʌ cura ti' cha' c'ajtibe: ¿Jatyet ba Cristojet, jini yajcʌbilet bʌ i cha'an Dios? ¿Yalobilet ba jini ñoj uts'at bʌ Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús ti' jac'ʌ: Joñoñʌch, che'en. Mi quejel la' wilan Joñon i Pi'ʌlon bʌ Quixtyañujob ya' buchul ti i ñoj jini p'ʌtyʌl bʌ Dios. Mi quej la' wilan che' mi quejel c tyʌlel ya' ti mal tyocal ya' ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Che' jini, ti' tsili i pislel jini ñoj ñuc bʌ cura como chʌncol jach i cuye' i bʌ ti Dios Jesús ti' lolon ña'tyʌ. Ti yʌlʌ: ¿Chuquiyes i c'ʌjnibal mi lac sʌclan yambʌ t'an? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tsa'ix la' wubi chʌncol i cha'len bibajax bʌ t'an ti' contra Dios. ¿Bajche' la' wʌle'? che'en. Che' jini ti lu' yʌc'ʌyob i t'an cha'an yom tsʌnsʌntic, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jini ya' bʌ añob ti queji i tyujbañob Jesús. Ti' mʌcbeyob i wut. Ti' tyum jajts'iyob. Ti' subeyob: Subeñon lojon majchqui ti' jats'ʌyet, che'ob. Jini policíajob ti' lec' jajts'ʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ya'an Pedro ti' pat i yotyot jini ñuc bʌ cura. Ti tyʌli juntiquil xc'alʌl bʌ yajtoñel jini ñuc bʌ cura. ");
INSERT INTO ctu76_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Che' ñac ti yilʌ Pedro ya' chʌncol ti q'uix, ti' ch'uj q'uele, ti' sube: Jatyet je'el ti a pi'le ti xʌmbal Jesús ch'oyol bʌ ti Nazaret, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro ti yʌlʌ mach chʌ'ic. Ti yʌlʌ: Mach j cʌñʌ. Mach'an mic ña'tyan chʌ bʌ ma' wʌle', che'en. Ti loq'ui majlel ti corredor. Che' jini ti' cha'le jun uq'uel tyat mut. ");
INSERT INTO ctu76_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jini xc'alʌl ti' cha' q'uele Pedro. Ti queji i suben jini ya' bʌ añob: Iliyi jiñʌch juntiquil i pi'ʌlob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro ti cha' alʌ mach melelic. Che' jini ti jumuc'lel ti' cha' subeyob Pedro jini ya' bʌ añob: Melelʌch, jatyet i pi'ʌlet che' cu ya' tyʌlemet ti Galilea je'el como tsiquilʌch je'el bajche' muq'uet ti t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Che' jini Pedro ti queji ti al'iya. Ti yʌlʌ: Melelʌch c t'an, Dios mi' q'uelon. Mach j cʌñʌ ili winic chʌncol bʌ la' wʌle', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ti wa' queji ti uq'uel tyat mut. Che' jini ti c'ajtiyi i cha'an Pedro tsa' bʌ i wʌ alʌ Jesús che' ñac ti' sube: Che' max tyo i cha'le cha' uq'uel tyat mut uxyajlelel mi quejel a wʌle' mach a cʌñʌyon, che'en. Che' ti' wʌ sube. Che' jini che' ti' ña'tyʌ Pedro ti wen queji ti uq'uel. ");
INSERT INTO ctu76_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Che' ñac ti sʌc'ʌ, ti' much'quiyob i bʌ ñuc bʌ curajob yic'ot xñoxob año' bʌ ye'tyel ti Junta Suprema. Ti' xiq'uiyob ti cʌchol majlel Jesús. Ti yotsʌbeyob ti' wenta juntiquil yumʌl Pilato bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jini Pilato ti' c'ajtibe Jesús: ¿Jatyet ba ñuc bʌ yumʌl i cha'an israelob? che'en. Jesús ti' jac'ʌ: Melelʌch bajche' ma' wʌle', che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jini curajob cabʌl ti' jop'beyob i mul Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jini Pilato ti' cha' c'ajtibe: ¿Mach'a ba'an chʌ bʌ ma' jaq'ue'? Ubin cabʌl chʌ bʌ tyac mi yʌlob ti a contra, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús mach'an ti' saj jac'ʌ. Pilato mach yujil isujm chʌ bʌ och ma' ti' saj jac'ʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","I tyʌlelʌch che' i yorojlel q'uiñejel pascua Pilato mi yʌq'ue' ti cojlel juntiquil cʌchʌl bʌ, majchical jach mu' bʌ i c'ajtin jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ya'an ti cʌchonibʌl yic'ot stsʌnsajob tsa' bʌ i contrajiyob gobierno, juntiquil Barrabás bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ti tyʌli quixtyañujob i c'ajtiben Pilato i cha'len bajche' i tyʌlel mi' cha'len. ");
INSERT INTO ctu76_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato ti' c'ajtibeyob: ¿La' wom ba mic colbeñetla jini mu' bʌ la' wʌl ti ñuc bʌ yumʌl i cha'an israelob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Como Pilato yujil isujm tsa' jach i yʌc'ʌyob Jesús ti' c'ʌb cha'an jach ti' mich'leyob jini ñuc bʌ curajob cha'an i ñuclel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero jini ñuc bʌ curajob ti' wersa xiq'ui quixtyañujob cha'an mi c'ajtiben Barrabás cha'an mi cojlel. ");
INSERT INTO ctu76_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato ti' cha' subeyob: ¿Che' jini chuqui la' wom c tyumben iliyi mu' bʌ la' wʌl ti ñuc bʌ yumʌl cha'an israelob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","C'am ti' cha' alʌyob: La' tsʌnsʌntic ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato ti' subeyob: ¿Chucoch? ¿Chuquiyes ti simaronlel ti' cha'le? che'en. Ti cha' quejiyob ti c'am bʌ t'an: La' tsʌnsʌntic ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato yom i cha'len bajche' mi' mulan quixtyañujob. Jin cha'an tsʌ'ʌch i yʌc'ʌ ti colel Barrabás. Che' ti ujti i yʌc' ti jats'ol Jesús ti pʌchij ti yʌq'ueyob ti' c'ʌb soldadojob cha'an i tsʌnsañob ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jini soldadojob ya' ti' pʌyʌyob majlel Jesús ti' pat i yotyot ñuc bʌ yumʌl. Ti' pʌyʌyob tyʌlel ti junmujch'lelob jini soldadojob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ti' xojbeyob ic'puc'an bʌ i pislel Jesús che' bajche' ti' xojoyob ñuc bʌ yumʌlob ti ñoj oniyix. Ti yʌq'ueyob i corona ti' jol jalʌl bʌ ti ch'ix. ");
INSERT INTO ctu76_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jini soldadojob ti queji i wajleñob. C'am ti yʌlʌyob: Ñoj ñuquet bʌ Yumʌl i cha'an israelob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ti' jats'beyob i jol ti i tye'el jam. Ti' tyujbʌyob. Ti ñocleyob che' bajche' colem i ye'tyel ti' p'isiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Che' ti ujti i wen wajleñob ti' cha' jochbeyob pislel ic'puc'an bʌ i ts'ijbal. Ti' cha' xojbeyob i pislel. Ti' pʌyʌyob majlel cha'an i tsʌnsañob ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ti' tsʌtsʌ subeyob juntiquil ya' bʌ an ya'i cha'an i q'ueche' majlel i cruzil Jesús. Jiñʌch Simón bʌ i c'aba', ya' ch'oyol ti yambʌ pañimil Cirene bʌ i c'aba', c'otyel muc' ti matye'el. Jiñʌch i tyat Alejandro yic'ot Rufo. ");
INSERT INTO ctu76_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ya' ti' pʌyʌyob majlel Jesús ti jump'ej bujtyʌl Gólgota bʌ i c'aba'. An i sujmlel i c'aba' mi yʌl ti lac t'an, che' yilal bajche' i bʌquel jolʌl. ");
INSERT INTO ctu76_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ti' jop'o i yʌq'ueñob Jesús i jape' vino xʌc'tyʌbil yic'ot ts'ac mirra bʌ i c'aba'. Pero mach'an ti' japʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ya' ti' joc'chocoyob ti cruz. Ti' pucbeyob i bʌ i pislel. Ti' cha'leyob yajcaya cha'an i ña'tyañob majchqui i cha'añob mi majlel. ");
INSERT INTO ctu76_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ti las nueve ti sʌc'an ti joc'chocoyob ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ya' ts'ijbubil ti chañelel i jol chuquiyes i mul. Ti yʌlʌ: Jiñʌch ñuc bʌ yumʌl i cha'an israelob, che' ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ya' ti' joc'chocoyob cha'tiquil ajxujch'ob yic'ot. Juntiquil an ti' ñoj Jesús, juntiquil an ti' ts'ej. ");
INSERT INTO ctu76_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Che' jini, ti ts'ʌctiyi Ts'ijbubil bʌ i T'an Dios ba' mi yʌle': Ti tsijqui yic'otyob jini simaroño' bʌ. Che' wʌ ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jini ya' bʌ ti ñumiyob ti' wajleyob. Ti' pʌnts'ʌyob i jol. Ti yʌlʌyob: Aja che'i, jini mu' bʌ i jeme' templo mu' bʌ i cha' wa'chocon ti uxp'ej jach q'uin: ");
INSERT INTO ctu76_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Cotyan a bʌ. Juben ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chʌ'ʌch je'el jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an i mandar israelob ti' wajleyob. Ti' subeyob i bʌ: Jini ti' cotyʌ yaño' bʌ pero i bajñel mach mejl i cotyan i bʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mi jiñʌch Cristo jini yajcʌbil bʌ, mi jiñʌch ñuc bʌ yumʌl i cha'an israelob, la' jubic ti cruz wale iliyi, che' jini mux lac ch'ujbin. Che' ti yʌlʌyob. Jinic tyo jini ya' bʌ joc'olob ti cruz ti' wajleyob Jesús je'el. ");
INSERT INTO ctu76_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ti xinq'uinil ti ic'ʌ mulawil c'ʌlʌl ti och an q'uin ti las tres. ");
INSERT INTO ctu76_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Che' ti och an q'uin Jesús wen c'am ti' cha'le t'an. Ti yʌlʌ: Eloi, Eloi, ¿lama sabactani? che'en. Mi yʌl ti lac t'an: C Dios, c Dios, ¿chucoch ti a cʌyʌyon? che' mi yʌl ti lac t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Che' ñac ti yubiyob cha'tiquil uxtiquil ya' bʌ wa'alob ti yʌlʌyob: Ubinla, chʌncox i pʌye' tyʌlel Elías tsa' bʌ xiq'ui i yʌle' Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Juntiquil ti majli ti ajnel cha'an i yotsan vinagre ya' ti chʌyo' ja'. Ti' cʌchʌ ti ñi' tyam bʌ tye'. Ti yʌq'ue Jesús cha'an i tsu'e'. Ti yʌlʌ: Pijtyanla. La' la quilan mi tyal Elías cha'an i ju'san ti cruz, che'en. ");
INSERT INTO ctu76_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wen c'am ti' cha'le t'an. Che' jini ti sajti. ");
INSERT INTO ctu76_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jini colem pisil joc'ol bʌ ti templo ti tsijli ti xinil c'ʌlʌl ti chan c'ʌlʌl ti yebal. ");
INSERT INTO ctu76_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ya' wa'al ti' tyojel i wut Jesús juntiquil capitán am bʌ ti' wenta cien soldadojob i cha'an romanojob. Che' ñac ti yubi bajche' ti' cha'le c'am bʌ t'an Jesús yic'ot ti yilʌ bajche' ti sajti Jesús, ti yʌlʌ: Melelʌch ili winic i Yalobilʌch Dios. Che' ti yʌlʌ jini capitán. ");
INSERT INTO ctu76_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ya' añob je'el cha'tiquil uxtiquil x'ixicob chʌncol i ñajtyʌ q'uelob chʌ bʌ mi yujtyel. Ya'an María ch'oyol bʌ ti Magdala yic'ot María i ña' Jacobo mu' bʌ i pejcʌntyel ti ijts'iñʌl bʌ; jiñʌch i ña' José yic'ot Salomé. ");
INSERT INTO ctu76_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Che' ñac ya' tyo añob ti Galilea jini x'ixicob, ti' tsʌcleyob majlel Jesús. Ti' we'sʌyob. Ya' añob je'el yambʌ cabʌl x'ixicob tsa' bʌ i tsʌcleyob tyʌlel Jesús c'ʌlʌ ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tsa'ix p'ʌjqui q'uin, i q'uinilel bʌ che' mi' chajpañob chʌ bʌ yes jach mi quejel i c'ʌñob che' ti yijc'ʌlel che' ti q'uinilel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ti tyʌli José ch'oyol bʌ ti lum Arimatea bʌ i c'aba'. Jiñʌch juntiquil am bʌ ñuc bʌ ye'tyel ti comité Junta Suprema bʌ i c'aba'. Jini José chʌncol i pijtyan i yumintyel Dios je'el. Ti' ch'ejlisʌ i bʌ cha'an i majlel ba'an Pilato i c'ajtiben i bʌc'tyal Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tsijc' che' i pusic'al Pilato che' ñac ti yubi sajtyemix Jesús. Ti' pʌyʌ tyʌlel i capitán soldadojob cha'an i c'ajtiben mi melelʌch. ");
INSERT INTO ctu76_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jini capitán ti yʌlʌ cha'an melelʌch. Che' jini, Pilato ti yʌq'ue i ch'ʌme' majlel i bʌc'tyal Jesús jini José. ");
INSERT INTO ctu76_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Che' jini José ti' mʌñʌ jump'ojch i bʌjq'uil. Ti' ju'sʌ Jesús ya' ti cruz. Ti' bʌc'ʌ ti bʌjq'uil. Ya' ti' ch'ujñʌ ya' ti muconibʌl melel bʌ ti malil colem tyun. Che' jini, ti ñolq'ui majlel wechel bʌ colem tyun cha'an i mʌjquil i ti' muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jini María ch'oyol bʌ ti Magdala yic'ot María i ña' José ti' q'ueleyob ba' ti ch'ujñʌnti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Che' ñac ti ñumi i yorojlel c'aj oj jini María ch'oyol bʌ ti Magdala yic'ot María i ña' Jacobo yic'ot Salomé ti' mʌñʌyob yowocña bʌ pimel perfume i wentyʌlel cha'an mi majlelob i yʌc'ob ti' bʌc'tyal Jesús tsa' bʌ sajti. I tyʌlelʌch che' ti' cha'leyob muquejel israelob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Che' ti wen sʌc'an ti ñaxan bʌ q'uin ti semana ti majliyob ti muconibʌl. Chʌncol i pasel q'uin ti c'otiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Che' ñac ya' tyo añob ti bij chʌncol i subeñob i bʌ: ¿Majchqui mi quejel i loc'sʌbeñonla jini wechel bʌ colem tyun ya' bʌ an ti' ti' muconibʌl? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ti queji i yilañob tsa'ix loc'sʌnti jini tyun. Yoque colem jini tyun. ");
INSERT INTO ctu76_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ti ochiyob ya' ti mali ba' ch'ujñʌbil Jesús. Ti yilayob ya' buchul juntiquil alob ya' ti' ñoj. Xojol i cha'an pʌl bʌ i bujc, yoque sʌsʌc bʌ. Tyoj bʌc'ñʌjelob ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jini alob ti' subeyob: Mach la' cha'len bʌq'uen. Chʌncol la' sʌclan Jesús ch'oyol bʌ ti Nazaret jini tsa' bʌ i tsʌnsʌyob ti cruz. Tsa'ix cha' tyejchi. Mach'anix wʌ' ani. Q'uelela wʌ'i ba' ti' sʌts' chocoyob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cucula. Suben ajcʌnt'añob i cha'an Jesús yic'ot Pedro. Ya' mi quej i ñaxan majlel Jesús i pijtyañetla ya' ti Galilea. Ya' mi quej la' wilan chʌ'ʌch bajche' ti' subetla wajali, che' ti yʌlʌ jini alob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Che' jini ti loq'uiyob ti ajñel ya' ti muconibʌl. Tsitsiñayob ti bʌq'uen. Mach'an majch ti' subeyob como muc'ob ti wen bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Che' ñac ti cha' tyejchi loq'uel ba'an sajtyemo' bʌ Jesús ti ñaxan bʌ q'uin ti semana che' yomox sʌc'an, ñaxan ti yilʌ María ch'oyol bʌ ti Magdala. Jiñʌch tsa' bʌ i chocbe loq'uel Jesús siete xibajob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jini María ch'oyol bʌ ti Magdala ti majli i subeñob jini tsa' bʌ i tsʌcleyob ti xʌmbal Jesús. Ch'ʌjyemob. Chʌncolob ti uq'uel jini tsa' bʌ i tsʌcleyob Jesús, ti c'oti i tyajob María. ");
INSERT INTO ctu76_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Che' ñac ti yubiyob tsa'ix cha' cuxtiyi Jesús, che' ñac tsa'ix i yilʌ María ch'oyol bʌ ti Magdala mach'an ti' ch'ujbiyob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ti wi'il Jesús ti tsictiyi ya' ti bij che' ñac chʌncol i majlelob cha'tiquilob. Mero yʌñʌlix i wut ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jini cha'tiquil ti cha' sujti i subeñob yaño' bʌ i pi'ʌlob. Chʌ'ʌch je'el mach'an ti' ch'ujbibeyob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wi'il tyo ti' pʌsʌ i bʌ Jesús ba'an jini oncejob. Ya' chʌncolob ti we'el. Ti' wen subeyob chʌ bʌ och mach'an ti ch'ujbiyob. Tsʌtsob i pusic'al como mach'an ti' ch'ujbiyob mi melel i t'an jini tsa' bʌ i yilʌyob che' ti cha' tyejchi loq'uel Jesús ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ti' subeyob: Cucula ti' pejtyelel mulawil. Subenla ti pejtyelel quixtyañujob jini wen bʌ t'an cha'an la' cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jini mu' bʌ i ch'ujbin, mu' bʌ i ch'ʌm ja' mi quejel i cotyʌntyel. Pero jini mach bʌ ba'an mi' ch'ujbin wʌ alʌlix mi quejel i majlel i xot' i mul. ");
INSERT INTO ctu76_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mi quej i tsictiyel ñuc bʌ c p'ʌyʌlel ti' tyojlel mu' bʌ i ch'ujbiñon. Jini mu' bʌ i c'ʌn j c'aba' mi quejel i chocob loq'uel xibajob. Mi quejel i cha'leñob t'an ti yan tyac bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mi ti' chucuyob lucum ti' c'ʌb, mi ti' japʌyob am bʌ i venenojlel mach'an chʌ bʌ mi quejel i tyumbentyel. Mi quejel i yʌc'ob i c'ʌb ti' pam i bʌc'tyal jini ajc'am'añob, che' jini mi lajmelob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Che' ti ujti i pejcan ajcʌnt'añob i cha'an, tsa'ix pʌjyi letsel lac Yum Jesús ti panchan. Ya' ti buchle ti' ñoj Dios cha'an tsiquil añʌch i ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Che' jini, ti loq'uiyob majlel ya'i. Ti' subuyob jini wen bʌ t'an cha'an laj cotyʌntyel ti pejtyelel lum tyac. Lac Yum ti' tyem cha'le toñel yic'otyob ti i Ch'ujlel. Ti' pʌsʌ melelʌch ili t'an che' ñac ti' tsictisʌ ñuc bʌ i p'ʌtyʌlel Jesús yic'otyob. Amén.");
INSERT INTO ctu76_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lucas mi yʌle': P'untyʌbilet bʌ Teófilo, cabʌl quixtyañujob tsa'ix queji i ts'ijbun ti jun jini tsa' bʌ ts'ʌctiyi wʌ' ba' añonla. ");
INSERT INTO ctu76_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Lajal ti' ts'ijbuyob bajche' ti cʌntisʌntiyonla ti jini tsa' bʌ i yilʌyob tsa' bʌ ujti c'ʌlʌ ti tyejchibal yic'ot tsa' bʌ i yʌlʌyob ti i subt'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ñaxan tic wen j c'ajtibeyob pejtyelel bajche' ti ujti c'ʌlʌ ti tyejchibal. Tic pensali weñʌch belecña mic ts'ijbuben chʌ bʌ ti ujti ");
INSERT INTO ctu76_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","cha'an ma' wen ña'tyan isujmʌch tsa' bʌ i cʌntisʌyetyob. ");
INSERT INTO ctu76_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Che' ñac chʌncol tyo i cha'len ye'tyel ti yumʌl Herodes ya' ti Judea an juntiquil cura i cha'an israelob Zacarías bʌ i c'aba'. Jini Zacarías ti lajal bʌ ora ti' cha'le troñel ti cura yic'ot junmujch' curajob mu' bʌ i pejcʌntyel ti Abías. I yijñam Zacarías i c'aba' Elisabet. Jini Elisabet ya' tyʌlem ti jiñʌjlelob cura je'el i c'aba' bʌ Aarón. ");
INSERT INTO ctu76_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tyoj añob ti' q'uele Dios jini Zacarías yic'ot Elisabet. Ti' wen jac'ʌyob i tyumbintyel yic'ot i xic'ol lac Yum. Mach ch'ujbi i yʌlob an i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero ma'añobix i yalobilob como i tyʌlelʌch ma'an yalobil jini Elisabet yic'ot je'el lajal wen ñoxobix ti cha'ticlelob. ");
INSERT INTO ctu76_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Junyaj che' añʌch ti' wenta jini junmujch' curajob mu' bʌ i cha'len troñel yic'ot Zacarías, ");
INSERT INTO ctu76_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ti c'oti yorojlel ti yajcʌnti Zacarías, che' bajche' i tyʌlel mi yajcʌntyelob cha'an ochic ti i templo lac Yum cha'an i pule' pom. ");
INSERT INTO ctu76_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Che' chʌncox i pulel pom ya' ti' templo pejteyelel quixtyañujob chʌncol ti oración ya' ti' pat templo. ");
INSERT INTO ctu76_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ya'i, ti tsictiyi yajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan ti tyojlel Zacarías. Ya' wa'al ti ts'ejtyʌlel i yajñib ba' mi' pulob pom. ");
INSERT INTO ctu76_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Che' ñac ti yilʌ jini ajtroñel i cha'an lac Yum ch'oyol bʌ ti panchan mach'an ti' ña'tyʌ Zacarías chʌ bʌ yom i cha'len. Wen an i bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero jini ajtronel i cha'an Dios ch'oyol bʌ ti panchan ti yʌlʌ: Zacarías mach yom a cha'len bʌq'uen. Como Dios tsa'ix i yubibet a woración. Mi quejel i ch'oc an yalobil a wijñam Elisabet. Mi quejel a wotsʌben i c'aba' Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wen c'ajacña a woj mi quejel a wubin. Cabʌl tijicñayob mi quejel i yubiñob che' mi ch'oc an a walobil. ");
INSERT INTO ctu76_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Como mi quejel i q'uejel ti ñuc ti' wut Dios. Ma'ix mi quejel i jape' vino melel ti ts'ujsub mi lembalic. Mi quejel i bujt'el i pusic'al ti Ch'ujul bʌ i Ch'ujlel Dios che' max tyo ch'oca. ");
INSERT INTO ctu76_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cha'an ti i troñel jini a walobil mi quejel i sutquin i bʌ cabʌl israelob cha'an i t'un majlel lac Yum Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jini Juan mi quejel i ñaxan ñumel ti subt'an. Ti wi'il mi quejel ti troñel lac Yum. An i ch'ejlel yic'ot i p'ʌtyʌlel ti subt'an Juan che' bajche' i cha'an Elías cha'an mi yʌc' i yajñelob ti junchajb i pensalob tyatyʌlob yic'ot yalobilob. Jini ñun t'año' bʌ mi quejel i ña'tyañob i jac'ben t'an. Che' jini mi' chajpʌbeñob i pusic'al quixtyañujob cha'an i ch'ujbiñob lac Yum. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías ti' c'ajtibe jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan: ¿Bajche'qui ch'ujbi c ña'tyan mi yoque melel jini tsa' bʌ a subon? Jin che' ñoxonix. Xñejep'ix quijñam je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ti' jac'ʌ: Joñon Gabrielon. Mic cha'liben i troñel Dios ya' ti' tyojlel. Ti chojquiyon tyʌlel cha'an c subeñet wen bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero cha'an mach'an ti a ch'ujbi tsa' bʌ c subet mi quejel a wa' sujtyel ti x'uma'. Ma'ix mi quejel a cha'len t'an c'ʌlʌl jintyo mi' ch'oc an alo' bʌ a walobil. Jiñʌch mi quejel i ts'ʌctiyel che' ti yorojlel. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Che' chʌncol tyo i pejcʌntyel Zacarías ti ajtroñel i cha'an Dios ch'oyol bʌ ti panchan jini quixtyañujob ya' wa'alob ti pat templo chʌncol i pijtyañob Zacarías cha'an mi loq'uel tyʌlel. Tyoj bʌc'ñʌjelob ti yubiyob cha'an chʌncol i wen jalijel Zacarías ya' ti mal templo. ");
INSERT INTO ctu76_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Che' ñac ti loq'ui tyʌlel Zacarías ya' ti templo mach ch'ujbi i cha'len t'an. Che' jini ti queji i ña'tyañob jini quixtyañujob an chʌ bʌ ti yilʌ Zacarías che' bajche' ti' ñajal ya' ti mal templo. Cha'an ma'an ti loq'ui i t'an ti' pʌs'eyob i c'ʌb cha'an che' bajche' ti' c'ʌb jach ti' cha'le t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Che' ñac ti ts'ʌctiyi jini q'uin tyac che' ti' cha'le che' bajche' i tyʌlel mi' cha'leñob troñel ti cura ya' ti templo, Zacarías ti cha' sujti ti yotytot. ");
INSERT INTO ctu76_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Che' jini, Elisabet ti queji i cʌñʌtyan i yalobil. Mach'an ti loq'ui ti yotyot jop'ej uw. Ti' ña'tyʌ Elisabet: ");
INSERT INTO ctu76_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wale tsa'ix i yʌc'on calobil lac Yum cha'an ma'ix mi' bej q'uelon ti ma'ix i c'ʌjnibal bʌ x'ixic quixtyañujob. Chʌ'ʌch ti' ña'tyʌ Elisabet. ");
INSERT INTO ctu76_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ti wʌcp'ejlel bʌ uw Dios ti' choco majlel ya' ti lum Nazaret bʌ i c'aba' ti Galilea bʌ pañimil juntiquil ajtronel i cha'an ch'oyol bʌ ti panchan Gabriel bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ti c'oti Gabriel ya'i cha'an i suben juntiquil yoque xc'alʌl tyo bʌ María bʌ i c'aba'. Jini xc'alʌl c'ajtibilix i cha'an juntiquil winic José bʌ i c'aba'. Jini José tyʌlem ti i jiñʌjlel juntiquil ñuc bʌ yumʌl David bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ti ochi ya' ba'an María. Ti' sube: Mi cʌq'ueñet saludos. An i yutslel Dios a wic'ot. Lac Yum wʌch'an a wic'ot. Más mi yʌq'ueñet Dios i yutslel i t'an bajche' pejtyelel yambʌ x'ixicob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero che' ñac María ti yilʌ jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan tsijc' che' i pusic'al. Ti' bajnel pensali ti' pusic'al chʌ bʌ yes i sujmlel tsa' bʌ subenti che' ñac ti yubibe i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Che' jini, ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ti' sube: María, mach yom a cha'len bʌq'uen. Weñʌch mi' q'uelet Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wale mi quejel a cʌñʌtyan a walobil. Mi quejel i ch'oc an alo' bʌ a walobil. Mi quejel a wotsʌben i c'aba' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Mi quejel i yajñel ti ñuc. Mi quejel i pejcʌntyel ti Yalobil Dios mach'ʌ ba'an i p'isol i ñuclel. Dios lac Yum mi quejel i yotsan ti yumʌl che' bajche' i yum David ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Pejtyel loq'uemo' bʌ ti' tyojlel Israel mi quejel i yumiñob ti bele' ora. Ma'ix ba' bʌ ora mi quejel i lajmel i cha'len yumʌl. Che' ti yʌlʌ jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Che' jini María ti' c'ajtibe jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan: ¿Bajche'qui ch'ujbi i yujtyel bajche' chʌncol a wale'? Como max tyo ba'an tyaja c cha'an winic. Che' ti yʌlʌ María. ");
INSERT INTO ctu76_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ti' jac'ʌ: Jini Ch'ujul bʌ i Ch'ujlel Dios mi quejel i tyʌlel ba'anet. Mi quejel i moset ti i p'ʌtyʌlel Dios mach'ʌ ba'an i p'isol i ñuclel. Jin cha'an jini alob mu' bʌ quejel i ch'oc an i cha'añʌch Dios. Mi quejel i yʌlob ti' Yalobil Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Che' je'el, Elisabet bʌ a pi'ʌl aunque ñejep'ix pero chʌncox i cʌñʌtyan alo' bʌ i yalobil je'el. Anix wʌcp'ej uw chʌncol i cʌñʌtyan i yalobil tsa' bʌ pejcʌnti ti i tyʌlelʌch ma'an yalobil bʌ x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios mach'an mach'ʌ ba'an ch'ujbi i mele'. Lu' ch'ujbiyʌch i mele'. Che' ti yʌlʌ jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Che' jini María ti yʌlʌ: Lʌch'añoni ajtroñelon i cha'an lac Yum. La' i melbeñon bajche' ti a subon, che'en. Che' jini ti loq'ui majlel ya' ba'an María jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Che' tsa'ix ñumi cha'p'ej uxp'ej q'uin, ti ora jach ti majli María ti jump'ej lum ya' ti wits ti Judea bʌ pañimil i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ti ochi María ti' yotyot Zacarías. Ti yʌq'ue saludo Elisabet. ");
INSERT INTO ctu76_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Che' ñac Elisabet ti yubi i saludo María, ti' nijcʌ i bʌ yalobil Elisabet max tyo ba'an ch'ocʌjem. ");
INSERT INTO ctu76_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ti bujt'i ti Ch'ujul bʌ i Ch'ujlel Dios i pusic'al Elisabet. Che' jini, cha'an c'ajacña yoj ti c'am bʌ t'an ti queji ti t'an Elisabet. Ti yʌlʌ: Dios ti más aq'ueyet i yutslel i t'an bajche' pejtyelel yaño' bʌ x'ixicob. Tsa'ix i más yʌq'ue i yutslel i t'an jini alʌl chʌncol bʌ a cʌñʌtyan. ");
INSERT INTO ctu76_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Añʌch c ñuclel yubil cha'an tyʌlic i ña' c Yum i jula' añon. ");
INSERT INTO ctu76_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ora jach ti' nijcʌ i bʌ jini alʌl max tyo bʌ ch'oca che' ñac ti cubi a saludo. ");
INSERT INTO ctu76_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ñoj c'ajacña a woj ma' wubin cha'an chʌncol a ch'ujbin i t'an lac Yum. Como mi quejel i ts'ʌctiyel bajche' ti yʌlʌ lac Yum. Che' ti yʌlʌ Elisabet ti subenti María. ");
INSERT INTO ctu76_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Che' jini María ti yʌlʌ: Ti pejtyelel c pusic'al mic sube' i ñuclel lac Yum. ");
INSERT INTO ctu76_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Tijicña c pusic'al cha'an ti Dios Ajcotyaya lac cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Como Dios ti' c'ajtisʌyon p'ump'uñon bʌ ajtroñel i cha'an. C'ʌlʌ bele' ora quixtyañujob mi quejel i yʌlon ti c'ajacña bʌ coj bʌ x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Como Dios jini am bʌ i p'ʌtyʌlel ti' melbeyon chʌ bʌ ñuc. Ch'ujulʌch i c'aba' Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios mi' bele' p'untyan cha'an yom i cotyan jini mu' bʌ i q'uelob ti ñuc Dios mu' bʌ i bʌc'ñan cha'an chʌncox i q'uelob ti ñuc Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsa'ix i cha'le p'ʌtyʌl bʌ i cha'libal Dios. Tsa'ix i pucuyob majlel jini mu' bʌ i lolon chan isañob i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jini mu' bʌ i q'uelob i bʌ ti p'ʌtyʌlo' bʌ mi quejel i ju'sʌntyel. Jini mu' bʌ i ju'san i bʌ mi quejel i chan isʌntyel ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dios mi yʌq'ueñob i ñaj'añob jini am bʌ i wi'ñal. Mi yʌq'uen i jilel chʌ bʌ an i cha'an jini am bʌ cabʌl chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios ti' cotyʌ israelob jini ajtroñelob i cha'an bʌ. Mach'an ti' cʌyʌ i p'untyañob. ");
INSERT INTO ctu76_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dios ti' bele' p'untyʌyob chʌ'ʌch bajche' ti wʌ ac'ʌ i t'an lac yumob ti ñoj oniyix. Jiñʌch Abraham yic'ot jiñʌjlel i cha'año' bʌ Abraham. Che' ti yʌlʌ María. ");
INSERT INTO ctu76_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ya' ti cʌyle María yic'ot Elisabet che' bajche' uxp'ej uw. Che' jini, ti cha' sujti ti yotyot María. ");
INSERT INTO ctu76_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti c'oti yorojlel cha'an mi ch'oc an i yalobil Elisabet. Ti ch'ocʌ alo' bʌ yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","I pi'ʌlob ti chumtyʌl Elisabet yic'ot i pi'ʌlob ti c'otiyob i suben cha'an tijicña mi yubin je'el che' ñac ti yubiyob cha'an Dios ti' p'untyʌ Elisabet cha'an ti yʌq'ue ti ch'oc an i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Che' ocho días i ch'oc an i yalobil, ti c'otiyob i tsepben i pʌchʌlel jini alʌl che' bajche' i tyʌlel mi' cha'leñob israelob. I pi'ʌlob yom i yotsʌbeñob i c'aba' Zacarías jini alʌl che' bajche' i c'aba' i tyat. ");
INSERT INTO ctu76_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero i ña' ti' jac'ʌ: Mach yom i yochel i c'aba' ti Zacarías pero wersa yom mi yochel i c'aba' ti Juan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","I pi'ʌlob ti' jac'ʌyob: ¿Chucoch jini? Ma'an a pi'ʌlob jim bʌ i c'aba', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Che' jini ti' pejcʌyob ti' c'ʌb i wentyʌlel. Ti' pʌsʌyob ti' c'ʌb i tyat bajche' yom i yotsʌben i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","I tyat alʌl ti' c'ajti jun cha'an i ts'ijbuben i jac'bal. Ti' ts'ijbu: Jiñʌch Juan i c'aba', che' ti' ts'ijbu. Lu' tyoj bʌc'ñʌjelob ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ti mismo jini jach bʌ ora ti cha' queji ti t'an Zacarías. Ti queji i sube' i ñuclel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Che' jini pejtyelel i pi'ʌlob ti chumtyʌl tyoj bʌc'ñʌjelob ti yubiyob. Ti pejtyelel pañimil ya' ti wits tyac ti Judea ti ajli chʌ bʌ ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pejtyelel tsa' bʌ i yubiyob ti' pensaliyob. Ti' c'ajtibeyob i bʌ i pi'ʌlob: ¿Chuqui mi quejel i cha'len jini alob che' ñuquix? che'ob. Como melelʌch Dios ti' tsictisʌbeyob an i yutslel Dios yic'ot jini alʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","But'ul i pusic'al ti Ch'ujul bʌ i Ch'ujlel Dios jini Zacarías i tyat alʌl. Ti queji i yʌle' t'an tsa' bʌ aq'uenti ti Dios. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","La' lac sube' i ñuclel lac Yum i Dios israelon bʌ la como ti tyʌli i cotyañonla i cha'añon bʌ la. ");
INSERT INTO ctu76_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mux quejel i yʌq'ueñonla p'ʌtyʌl bʌ Ajcotyaya lac cha'an loq'uem bʌ ti jiñʌjlel David ajtroñel i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Chʌ'ʌch ti' wʌ subeyob Dios jini i cha'an bʌ tsa' bʌ i xiq'ui Dios c'ʌlʌ ti ñoj oniyix cha'an i subeñob lac yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tsa'ix i wʌ alʌ Dios cha'an mi quejel i cotyañonla loq'uel ti' p'ʌtyʌlel laj contrajob pejtyelel jini mu' bʌ i ts'a'q'uelonla. ");
INSERT INTO ctu76_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Dios ti' wʌ sube lac yumob ti ñoj oniyix mi quejel i p'untyañob cha'an yom i cotyañob. Mach'an mi quejel i ñajʌyel i cha'an Dios i t'an tsa' bʌ i wa'choco ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Jiñʌch jini tsa' bʌ i wʌ alʌ Dios che' ñac ti' xuc'choco i t'an yic'ot lac yumob ti oño'tan Abraham bʌ i c'aba' cha'an jini mu' bʌ quejel i yʌq'ueñonla. ");
INSERT INTO ctu76_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ti yʌlʌ: Mi quejel i loc'onla ti' p'ʌtyʌlel laj contrajob cha'an ma'ix lac bʌq'uen mi lac melben i troñel Dios ");
INSERT INTO ctu76_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","cha'an tyojʌch añonla yic'ot i cha'añonixla Dios c'ʌlʌ che' cuxulon tyo la wʌ' ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Zacarías ti bej alʌ: Jixcu jatyet, alʌl calobilet, mi quejel a pejcʌntyel ti mu' bʌ i xiq'ue' a wʌle' Dios, jiñʌch jini Dios mach'ʌ ba'an i p'isol i ñuclel. Como mi quejel a chajpʌben i bijlel lac Yum yubil mu' tyo bʌ quejel i tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mi quejel a wʌq'ueñob i ch'ʌmeñob isujm i cha'año' bʌ israelob cha'an añʌch i cotyʌntyel yic'ot cha'an mi yubiñob añʌch i ñusʌntyel i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Zacarías ti bej alʌ: Como lac Dios ti' wen p'untyʌyonla israelon bʌ la. Ti' q'uele ti p'ump'un cha'an yom i cotyañob. Ti loq'ui tyʌlel ti panchan wʌ' ba' añonla cha'an lac tyaje' laj cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Cha'an i yʌq'ueñob i q'uele' i sʌclel yubil jini chumulo' bʌ ti ic't'ojñal chʌncol bʌ i sajtyelob yubil yic'ot cha'an i pʌs'eñonla bajche' ch'ujbi la cajñel ti ñʌch'ʌl. Che' ti yʌlʌ Zacarías. ");
INSERT INTO ctu76_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ti bej coli majlel jini Juan. Ti' xuc'choco i pusic'al ti lac Yum. Che' jini ti ajni ti tyʌquin bʌ joch lum c'ʌlʌ jintyo ti queji i cha'liben i troñel lac Yum ya' ba'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti jim bʌ ora jini ñuc bʌ yumʌl Augusto bʌ i c'aba' ti' xiq'uiyob quixtyañujob cha'an mi lu' majlel i yotsañob i c'aba' ti jun. ");
INSERT INTO ctu76_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jini ñaxan bʌ tsic quixtyañu ti ujti che' ñac yumʌl jini Cirenio ya' ti Siria bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ti pejtyelel quixtañu an cha'an lu' majlicob ti yoque i lumal bʌ cha'an mi yotsañob i c'aba' ti jun. ");
INSERT INTO ctu76_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jin cha'an ti loq'ui majlel José ya' ti lum Nazaret bʌ i c'aba' ya' ti Galilea bʌ pañimil cha'an mi majlel ti lum Belén bʌ i c'aba' ya' ti Juda bʌ pañimil ba' ti ch'ocʌ David ti ñoj oniyix. Como José i jiñʌjlel David. ");
INSERT INTO ctu76_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José ti majli i yotsan i c'aba' yic'ot María tsa'ix bʌ i c'ajti. Chʌncol i cʌñʌtyan yalobil jini María. ");
INSERT INTO ctu76_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Che' jini che' ya' añob ti Belén, ti c'oti yorojlel cha'an mi quej i ch'oc an yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ti ch'ocʌ ñaxan bʌ yalobil i cha'an María. Alob. Ti' bʌc'ʌ ti bʌjq'uil. Ti tyots' choco ti buq'uijib alʌq'uil. Como mach'an ba' ti' tyajayob ba' mi yochelob ti wʌyel. ");
INSERT INTO ctu76_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ya' ti jump'ej jamilol lʌc'ʌl ya' ti Belén an ajcʌñʌtya tiñʌme'. Mi' cʌñʌtyan i tiñʌme' ti ac'bʌlel. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ti ora jach ti c'oti juntiquil ajtoñel i cha'an Dios ch'oyol bʌ ti panchan ya' ba'añob. Sʌcjaman ti sutyʌlel ya' ba'añob cha'an ti' ñuclel lac Yum. Ti' wen bʌc'ñʌyob jini ajcʌñʌtya tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero jini ajtoñel i cha'an Dios ch'oyol bʌ ti panchan ti' subeyob: Mach yom mi la' cha'len bʌq'uen. Como mic ch'ʌmbeñetla tyʌlel wen bʌ t'an mu' bʌ i yʌq'uen c'ajacña bʌ i yoj pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Como sajmʌl ti ch'ocʌ cha'añetla ya' ti lumal i cha'an bʌ David Ajcotyaya la' cha'an. Jiñʌch CRISTO lac Yum. ");
INSERT INTO ctu76_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jiñʌch i tsictisʌntyel cha'an mi quej la' cʌñe'. Mi quej la' c'otyel la' tyaj jini ch'oc alʌl bʌc'ʌl ti bʌjq'uil. Tyots'ol ti buq'uijib alʌq'uil. Che' ti yʌlʌ ajtoñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Che' jini, ti saj ora jach ti tsictiyi ba'an ajtoñel i cha'an Dios cabʌl yambʌ ajtoñelob i cha'an Dios ch'oyol bʌ ti panchan tsa' bʌ i subeyob i wenlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ti yʌlʌyob: Wen ñuc Dios am bʌ ti panchan. La' ñʌch'lec jini mu' bʌ i mele' chʌ bʌ mi' mulan Dios wʌ' ti mulawil. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ti cha' sujtiyob majlel ti panchan jini ajtoñelob i cha'an Dios. Che' jini, jini ajcʌñʌtya tiñʌme' ti queji i subeñob i bʌ: Coxla. La' lac majlel ti Belén cha'an la quilan chʌ bʌ ti ujti yic'ot chʌ bʌ ti' subeyonla lac Yum. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ora jach ti wa' majliyob. Ti c'oti i tyajob María yic'ot José yic'ot ch'oc alʌl tyots'ol bʌ ti buq'uijib alʌq'uil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Che' ñac ti yilʌyob jini ch'oc alʌl ti queji i subeñob yaño' bʌ je'el chʌ bʌ yes ti subentiyob ti jini ajtoñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tyoj bʌc'ñʌjel ti yubiyob ti pejtyelel tsa' bʌ i yubibeyob i t'an jini ajcʌñʌtya tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María ti' bajñel ña'tyʌ ti' pusic'al pejtyelel jini tsa' bʌ ujti. Ti' bej pensali i sujmlel ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ti cha' sujtiyob jini ajcʌñʌtya tiñʌme'. Ti' bej subeyob ti pejtyelelob cha'an ñucʌch Dios cha'an jini tsa' bʌ subentiyob yic'ot tsa' bʌ i yilʌyob. Como chʌ'ʌch ti ujti bajche' ti subentiyob ti ajtoñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Che' tsa'ix ts'ʌctiyi ocho o waxʌc q'uin i cha'an Jesús ti' tsepeyob i pʌchʌlel che' bajche' i tyʌlel mi' cha'leñob israelob. Ti yotsʌbeyob i c'aba' Jesús. Jiñʌch i c'aba' tsa' bʌ wʌ subenti María ti ajtoñel i cha'an Dios ch'oyol bʌ ti panchan che' max tyo ba'an ti' cʌñʌtyʌ yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Che' ñac ti ts'ʌctiyi i yorojlel cha'an mi' wen cʌñʌtyan i bʌ María che' bajche' ti xijq'uiyob ti Moisés ti ñoj oniyix, ti' pʌyʌyob majlel ya' ti templo jini alʌl ya' ti lum Jerusalén bʌ i c'aba' cha'an mi yʌq'uen Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Chʌ'ʌch ti' cha'leyob cha'an ts'ijbubil ti' t'an lac Yum ti ñoj oniyix ba' mi yʌle': Pejtyelel yʌx alʌl bʌ alob mu' bʌ i ch'oc an i cha'añʌch lac Yum. Chʌ'ʌch ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ti majli ya' ti templo cha'an i yʌq'ueñob lac Yum Dios tsʌnsʌbil bʌ i majtyan che' bajche' i tyʌlel ti' cha'leyob che' bajche' mi yʌle' ti mandar i cha'an lac Yum ti ñoj oniyix. Mi yʌl: Aq'uen Dios cha'cojt xmucuy o mi cha'cojt x'ujcutsu', che' yom mi yʌq'uentyel lac Yum. Che' ts'ijbubil ti mandar lac Yum ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ti jim bʌ ora ya' chumul ti Jerusalén juntiquil winic Simeón bʌ i c'aba'. Uts i pusic'al. Ti' bele' ch'ujutisʌ Dios. Ti' bej pijtyʌ cha'an i tyaje' i librejlel i pi'ʌlob jini israelo' bʌ. An Ch'ujul bʌ i Ch'ujlel Dios ti' pusic'al Simeón. ");
INSERT INTO ctu76_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ti subenti Simeón ti Ch'ujul bʌ i Ch'ujlel Dios mach'an mi quej i sajtyel jintyo ba' bʌ ora tsa'ix i yilʌ Cristo jini yajcʌbil bʌ mu' bʌ quej i choque' tyʌlel lac Yum. ");
INSERT INTO ctu76_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jini winic ti majli ti jini ñuc bʌ i templo israelob. Jini Ch'ujul bʌ i Ch'ujlel Dios ti' nijcʌbe i pusic'al i majlel. Che' ñac ti c'oti i ña' i tyat alʌl Jesús ti c'otiyob ti templo cha'an i mele' bajche' xiq'uilob cha'an jini oniyix bʌ mandar. ");
INSERT INTO ctu76_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón ti' meq'ue jini alʌl. Ti' subu i ñuclel Dios. Ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","C Yum, wale ch'ujbi c sajtel ti ñʌch'tyʌlel c pusic'al como tsa'ix a ts'ʌctisʌ a t'an tsa' bʌ a wʌ subeyon ajtoñelon bʌ a cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tsa'ix quilʌ tic wut Ajcotyaya lojon c cha'an ");
INSERT INTO ctu76_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","tsa' bʌ a wʌc'ʌ ti tsictiyel ti' tyojlel pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jini Ajcotyaya jiñʌch i sʌclel yubil mu' bʌ quej i pʌstyʌl ba'an jini mach'ʌ israelo' bʌ cha'an mi quej i ña'tyañob. Cha'an ti caj jini alʌl mi quej i yʌq'uentyel i ñuclel a cha'año' bʌ israelob. Che' ti' sube Dios Simeón. ");
INSERT INTO ctu76_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tyoj bʌc'ñʌjelob ti yubiyob José yic'ot María i ña' Jesús che' ti yubiyob jini tsa' bʌ i yʌlʌ Simeón cha'an jini mu' tyo bʌ quejel i cha'len jini ch'oc alʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Che' jini Simeón ti' subeyob cha'an tijicña mi quej yajñelob. Pero ti' sube jini María i ña' bʌ Jesús: Q'uele awilan cabʌl israelo' bʌ mi quej i yajlel yubil cha'an ti caj ma'an mi' yʌc' ti ñuc ili alʌl. Yic'ot cabʌl mi quejel i wa'chocontyel che' mi' yʌc'ob ti ñuc. Cabʌlob mach'ʌ ba'an mi quej i yʌc'ob ti ñuc mi quej i cha'leñob t'an ti' contra jini mu' bʌ quejel i pʌse' a walobil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Che' jini, ti caj i melbal mi quejel i tsictiyel chʌ bʌ mi' bajñel pensaliñob ti' pusic'al ti jujuntiquil. Ñoj ch'ʌjyem mi quej a wubin ti a pusic'al pejtyelel i contrajintyel. C'ux mi quej a wubin ti a pusic'al. Che' ti subenti María ti Simeón. ");
INSERT INTO ctu76_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ya'an je'el juntiquil x'ixic mu' bʌ yʌle' chʌ bʌ mi xiq'ue' yʌle' Dios i c'aba' Ana. I yalobil Fanuel loq'uem ti junmujch' quixtyañujob i jiñʌjlel Aser. Wen ñejep'ix. Ti' tyaja i ñoxi'al che' ñac wen xc'alʌl tyo. Che' anix siete jabil i tyajbal i ñoxi'al ti sajti i ñoxi'al. ");
INSERT INTO ctu76_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Pero c'ʌlʌl meba'ix ochenta y cuatro jabil. Mach'an ti' cʌyʌ templo. Ti' bej cha'libe i toñel lac Yum ti ch'ajb yic'ot ti oración ti q'uinil ti ac'bʌlel. Ti' poj cʌyʌ tyac we'el uch'el. ");
INSERT INTO ctu76_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ti jini jach bʌ ora ti ochi Ana ya' ba'añob. Ñaxan ti' sube Dios wocox i yʌlʌ. Che' jini ti queji i suben ti pejtyelel jini mu' bʌ i pijtyañob cha'an mi' tyajob i librejlel año' bʌ ti Jerusalén cha'an jini alʌl Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jini José yic'ot María ti lu' ujti i cha'leñob bajche' mi xijq'uelob ti mandar i cha'an lac Yum tsa' bʌ i ts'ijbu Moisés ti ñoj oniyix. Che' jini ti cha' sujtiyob ya' ti lumal Nazaret bʌ i c'aba' ya' ti Galilea bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jini alob Jesús ti bej coli majlel. Ti más p'ʌtyʌliyi majlel. Ti más ocʌ i ña'tyʌbal. Wen an i yutslel Dios yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","I tyat i ña' Jesús ti jajabil ti majliyob ti Jerusalén cha'an i q'uiñejel pascua bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Che' ñac añʌch doce jabil i cha'an Jesús, ti lu' majliyob ti Jerusalén che' bajche' i tyʌlel mi' bej cha'leñob. Ti majli Jesús yic'otyob je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ti cha' lu' sujtiyob yaño' bʌ che' ñac ti ujti q'uin pero Jesús ti bajñel cʌyle ti Jerusalén. Mach'an ti' ña'tyʌ i ña' yic'ot José mi ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ti' lolon ña'tyʌyob lajal chʌncol i sujtyel Jesús je'el yic'ot i pi'ʌlob ti xʌmbal. Jump'ej q'uin ti' cha'leyob xʌmbal. Che' jini ti queji i wen sʌclan Jesús ya' ba'an i pi'ʌlo' bʌ yic'ot cʌñʌlo' bʌ i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mach'anix ti' tyajayob. Che' jini ti cha' sujtiyob majlel c'ʌlʌl ti Jerusalén cha'an i sʌclan Jesús ya'ya'i. ");
INSERT INTO ctu76_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Che' ñac ñumenix uxp'ej q'uin ti' cha' tyajayob Jesús ya' ti templo. Ya' buchul ba'an ajcʌntisajob tsa' bʌ i cʌntisʌyob jini mandar tsa' bʌ i sube Moisés. Jesús ti' ñʌch'tyʌ. Ti' c'ajtibeyob tyac je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tyoj bʌc'ñʌjel ti yubiyob ti pejtyelelob tsa' bʌ i yubibeyob i t'an Jesús cha'an bajche' ti' jac'beyob yic'ot cha'an wen yujil. ");
INSERT INTO ctu76_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tsijc' che'ob i pusic'al che' ñac ti yilʌyob Jesús i ña' i tyat. I ña' ti' sube: Calobil, ¿chucoch ti a cha'le che' bajche' jini? A tyat quic'ot ti lojon c wen cha'le pensal che' chʌncol lojon c sʌclañet. Che' ti yʌlʌ María. ");
INSERT INTO ctu76_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Che' jini Jesús ti' subeyob: ¿Chucoch ti la' sʌclʌyon? ¿Mach'a ba'an la' wujil isujm an cha'an mic cha'liben i toñel c Tyat? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero mach'an ti' ch'ʌmbeyob i sujmlel chʌ bʌ ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Che' jini Jesús ti sujti ti Nazaret yic'otyob. Ti' bej jac'beyob i t'an. I ña' ti' lu' lotyo ti i pusic'al pejtyelel tsa' bʌ i cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús ti' bej más ña'tyʌ majlel yic'ot ti bej más coli majlel. Dios ti' bej más q'uele ti más wen yic'ot chʌ'ʌch je'el pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Che' añʌch quince jabil ti' cha'le yumʌl jini ñuc bʌ yumʌl Tiberio bʌ i c'aba', Poncio Pilato ti' cha'le yumʌl ya' ti Judea bʌ pañimil. Herodes ti' cha'le yumʌl ya' ti Galilea bʌ pañimil. I yijts'in Felipe ti' cha'le yumʌl ti Iturea yic'ot Traconite bʌ pañimil. Lisanias ti' cha'le yumʌl ti Abilinia bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ti jim bʌ ora an ti ye'tyel jini ñoj ñuco' bʌ cura i cha'an bʌ israelob Anás yic'ot Caifás. Ti jim bʌ ora Dios ti' nijcʌbe i pusic'al Juan i yalobil Zacarías cha'an i cha'len subt'an ya' ti tyʌquin bʌ joch lum. ");
INSERT INTO ctu76_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juan ti ñumi majlel ti subt'an ya' lʌc'ʌl ti rio Jordán ya' ti pejtyelel pañimil tyac ti cha'wejlel jini río Jordán bʌ i c'aba'. Ti' sube quixtyañujob cha'an yom mi' q'uextyan i pensal i cʌyob i mul cha'an mi ñusʌbentyelob i mul. Yom i ch'ʌmob ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ti ts'ʌctiyi bajche' ti yʌlʌ jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix Isaías bʌ i c'aba'. Ts'ijbuil: Ti ubinti i t'an juntiquil chʌncol bʌ ti c'am bʌ t'an ya' ti tyʌquin bʌ joch lum. Mi yʌle': Tyoj isʌbenla majlel i bijlel lac Yum. Pʌtbenla majlel tyoj bʌ i bijlel. ");
INSERT INTO ctu76_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yom bujt'untic pejtyel lomtyʌl. Yom jembentic pejtyel wits yic'ot bujtyʌl tyac. Yom tyoj mi majlel jini xotyol bʌ bij. Yom pamacña mi majlel jini tselelbolol bʌ bij. ");
INSERT INTO ctu76_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ti pejtyelel año' bʌ ti mulawil mi quej i yilan bajche' mi' cha'len cotyaya Dios. Che' ti yʌlʌ Isaías. Chʌ'ʌch ti wʌ tyajle ti t'an Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ti c'otiyob cabʌl quixtyañu cha'an i ch'ʌmob ja' ti' c'ʌb Juan. Juan ti' subeyob: Lajaletla che'etla bajche' lucum yom bʌ i puts'tyan c'ajc. ¿Majchqui ti' subeyetla cha'an mi la' puts'tyan jini ñoj tsʌts bʌ xot'mulil mu' bʌ quej i yujtyel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ñaxan yom mi tsictiyel ti la' cha'liya cha'an yoque melelʌch tsa'ix la' q'uextyʌ la' pensal la' cʌye' la' mul. Wi'il mi la' ch'ʌme' ja'. Mach yom mi la' lolon ña'tyan wen añetla cha'an jach i jiñʌjleletla Abraham jini lac yum ti ñoj oniyix. Mach jasʌl che' i pi'ʌletla Abraham. Como mic subeñetla, Dios ch'ujbi i pʌntisan ili tyun tyac ti' jiñʌjlelob Abraham mi yom. ");
INSERT INTO ctu76_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Che' bajche' ya'ix an hacha ti yebal tye' yubil. Pejtyelel tye' tyac mach'ʌ ba'an mi yʌc' wen bʌ i wut mi quejel i sejq'uel jubel c'ʌlʌl ya' ti wi'. Mi quej i pule' ti c'ajc. Che' ti yʌlʌ Juan ti lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Che' jini quixtyañujob ti queji i subeñob Juan: ¿Chuqui yom mi lojon c cha'len, che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan ti' jac'beyob: Jini am bʌ i cha'an cha'pojch' i bujc yom i yʌq'uen jumpojch' jini mach'ʌ ba'an i cha'an. Jini am bʌ i cha'an i yuch'el yom i yʌq'uen jini mach'ʌ ba'an chʌ bʌ mi' c'uxe'. Che' ti' jac'ʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ti c'oti je'el cha'tiquil uxtiquil xch'ʌm tyojoñelob cha'an mi' ch'ʌmob ja'. Ti' subeyob Juan: Maestro, ¿chuqui yom mi lojon c cha'len? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan ti' subeyob: Mach yom mi la' más on c'ajtin tyojoñel bajche' mi la' xijq'uel ti yumʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Che' je'el ti c'oti cha'tiquil uxtiquil soldadojob. Ti' c'ajtibeyob Juan je'el: Jixcu joñon lojon, ¿chuqui yom mi lojon c cha'len? che'ob. Ti' jac'beyob Juan: Mach yom mi la' chilben i cha'an yambʌ, mi cha'anic tsʌts bʌ la' t'an mi cha'anic mi la' jop'ben i mul. Yom tijicñayetla yic'ot i tyojol la' toñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Jini quixtyañujob chʌncol i pijtyañob jini yajcʌbil bʌ i cha'an Dios mu' bʌ quejel i tyʌlel. Che' jini, ti queji i pensaliñob mi jin Cristo jini Juan jini yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero Juan ti' lu' subeyob: Melel joñon mi cʌq'uetla ti ch'ʌm ja' pero tyal más p'ʌtyʌl bʌ mu' bʌ i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ i Ch'ujlel Dios yic'ot c'ajc yubil. Más an i ñuclel bajche'on. Ma'ix ñucon mi cha'anic mic tic'ben i zapatos. ");
INSERT INTO ctu76_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Añʌch i wejlʌjib cha'an i wejlan loq'uel i sujl trigo yubil. Mi quejel i muchq'uin jini trigo ti i yotyotlel pero mi quejel i pule' i sujl ti c'ajc mach'ʌ yujil yajpel. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Chʌ'ʌch ti' subeyob quixtyañujob jini wen bʌ t'an yic'ot ti' xiq'uiyob i cha'len wen tyac bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Che' je'el Juan ti' tiq'ui gobernador Herodes bʌ i c'aba' como ti' ch'ʌmbe yijñam i yijts'in Felipe yic'ot ti' tiq'ui cha'an yan tyac mach'ʌ wen tsa' bʌ i cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes mach'an ti' ch'ujbibe. Tsa' jach i cha'le yambʌ mach'ʌ wen. Ti yotsʌ ti cʌchol jini Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Che' max tyo cʌjch Juan ti yʌc'ʌ ti ch'ʌm ja' cabʌl quixtyañu. Juan ti yʌc'ʌ ti ch'ʌm ja' Jesús je'el. Che' chʌncox ti oración Jesús ti jajmi panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jini Ch'ujul bʌ i Ch'ujlel Dios ti jubi tyʌlel che' bajche' x'ujcutsu' yilal. Ti jubi ti Jesús. Tsiquil ti i wutyob. Ti ubinti t'an loq'uem ti panchan tsa' bʌ yʌlʌ: Calobiletyʌch. Mic p'untyañet. C'ajacña coj cha'an ti jatyet. Che' ti yʌlʌ ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Che' bajche' treinta jabil an i cha'an Jesús che' ñac ti queji i cha'len i toñel. Jesús i yalobil José ti' pensaliyob quixtyañujob. José i yalobil jini Elí. ");
INSERT INTO ctu76_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí yalobil Matat. Matat yalobil Leví. Leví yalobil Melqui. Melqui yalobil Jana. Jana yalobil yambʌ José. ");
INSERT INTO ctu76_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José yalobil Matatías. Matatías yalobil Amós. Amós yalobil Nahum. Nahum yalobil Esli. Esli yalobil Nagai. ");
INSERT INTO ctu76_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai yalobil Maat. Maat yalobil yambʌ Matatías. Matatías yalobil Semei. Semei yalobil yambʌ José. José yalobil yambʌ Judá. ");
INSERT INTO ctu76_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá yalobil Joana. Joana yalobil Resa. Resa yalobil Zorobabel. Zorababel yalobil Salatiel. Salatiel yalobil Neri. ");
INSERT INTO ctu76_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri yalobil Melqui. Melqui yalobil Adi. Adi yalobil Cosam. Cosam yalobil Elmodam. Elmodam yalobil Er. ");
INSERT INTO ctu76_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er yalobil Josué. Josué yalobil Eliezer. Eliezer yalobil Jorim. Jorim yalobil yambʌ Matat. ");
INSERT INTO ctu76_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat yalobil yambʌ Leví. Leví yalobil Simeón. Simeón yalobil yambʌ Judá. Judá yalobil yambʌ José. José yalobil Jonán. Jonán yalobil Eliaquim. ");
INSERT INTO ctu76_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim yalobil Melea. Melea yalobil Mainán. Mainán yalobil Matata. Matata yalobil Natán. ");
INSERT INTO ctu76_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán yalobil David. David yalobil Isaí. Isaí yalobil Obed. Obed yalobil Booz. Booz yalobil Salmón. Salmón yalobil Naasón. ");
INSERT INTO ctu76_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón yalobil Aminadab. Aminadab yalobil Aram. Aram yalobil Esrom. Esrom yalobil Fares. Fares yalobil yambʌ Judá. ");
INSERT INTO ctu76_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá yalobil Jacob. Jacob yalobil Isaac. Isaac yalobil Abraham. Abraham yalobil Taré. Taré yalobil Nacor. ");
INSERT INTO ctu76_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor yalobil Serug. Serug yalobil Ragau. Ragau yalobil Peleg. Peleg yalobil Heber. Heber yalobil Sala. ");
INSERT INTO ctu76_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala i yalobil Cainán. Cainán yalobil Arfaxad. Arfaxad yalobil Sem. Sem yalobil Noé. Noé yalobil Lamec. ");
INSERT INTO ctu76_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec i yalobil Matusalén. Matusalén i yalobil jini Enoc. Enoc i yalobil Jared. Jared i yalobil Mahalaleel. Mahalaleel i yalobil yambʌ Cainán. ");
INSERT INTO ctu76_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán i yalobil Enós. Enós i yalobil Set. Set i yalobil Adán. Adán i yalobil Dios como Dios ti yʌc'ʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","But'ul i pusic'al Jesús ti Ch'ujul bʌ i Ch'ujlel. Ti loq'ui majlel ya' ti río Jordan. Ch'ujul bʌ i Ch'ujlel ti' pʌyʌ majlel ti tyʌquin bʌ joch lum. ");
INSERT INTO ctu76_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya'i ti' ñusʌ cuarenta q'uin. Jini xiba ti' jop'o i yotsʌben i mul. Mach'an chʌ bʌ ti' c'uxu Jesús c'ʌlʌ cuarenta q'uin. Ti wi'il ti yubi wi'ñal. ");
INSERT INTO ctu76_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Che' jini, xiba ti' sube Jesús: Mi melel yalobilet Dios suben jini tyun cha'an mi pʌntyʌyel ti waj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús ti' jac'ʌ: Ts'ijbubil bʌ i T'an Dios mi yʌl: Mach ti waj jach cuxul quixtyañu pero cuxul je'el cha'an ti pejtyelel t'an tsa' bʌ i yʌlʌ Dios, che' ts'ijbubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Che' jini, Jesús ti pʌjyi majlel ti xiba ti chan bʌ wits. Ti' lu' pʌs'e' Jesús ti ora jach pejtyelel pañimil tyac am bʌ ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Xiba ti' sube: Mi quej c lu' cʌq'ueñet pejtyelel i p'ʌtyʌlel yic'ot i ñuclel jini yumʌlob wʌ' ti pañimil tyac. Como c cha'añʌch ti pejtyelel. Ti aq'uentiyon. Ch'ujbi cʌq'uen majchical com cʌq'uen, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mi ti a ñocchoco a bʌ tic tyojlel cha'an a ch'ujutisañon, lu' a cha'añʌch mi cʌq'ueñet, che' ti yʌlʌ xiba. ");
INSERT INTO ctu76_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús ti' jac'ʌ: Satanás, loq'uen wʌ' tic tyojlel, che' cu ti Ts'ijbubil bʌ i T'an Dios mi yʌl: Ch'ujutisan la' Yum la' Dios. Jin jach yom ma' yumin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Che' jini, xiba ti' pʌyʌ majlel Jesús ti lum Jerusalén bʌ i c'aba'. Ti' wa'choco ya' ti pam templo. Ti subenti Jesús: Mi melel i yalobilet Dios choco jubel a bʌ c'ʌlʌl ya' ti lum. ");
INSERT INTO ctu76_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Como jini Ts'ijbubil bʌ i T'an Dios mi yʌl: Dios mi quejel i xiq'ue' tyʌlel ajtroñelob i cha'an ch'oyolo' bʌ ti panchan cha'an i cʌñʌtyañetyob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mi quejel i chuquetyob ti i c'ʌb cha'an mach'an ma' low a woc ti tyum. Che' ti yʌlʌ xiba. ");
INSERT INTO ctu76_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús ti' jac'ʌ: Mi yʌl je'el ti Ts'ijbubil bʌ i T'an Dios: Mach yom a jop' a wilpusic'len la' Yum la' Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jini xiba mach'an ti' tyaja yambʌ bajche' yom cha'an i yotsan i mul Jesús. Che' jini ti' cha' cʌyʌ Jesús cha'p'ej uxp'ej q'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús ti cha' sujti majlel ti Galilea bʌ pañimil. But'ul i pusic'al ti' p'ʌtyʌlel Ch'ujul bʌ i Ch'ujlel Dios. Cabʌl ti' pucuyob majlel t'an cha'an Jesús ya' ti lum ti' joytyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ti' bej cʌntisʌyob ti i templo israelob ti jujump'ej lum tyac. Ti pejtyelel ti' subuyob i ñuclel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Che' jini, Jesús tsajni ti Nazaret jini lum ya' ba' ti coli. Ti q'uinilel c'aj oj ti ochi ti i templo israelob che' bajche' i tyʌlel ti' cha'le. Ti wa'le Jesús cha'an i q'uele' Ts'ijbubil bʌ i T'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ti yʌq'ueyob Jesús jini jun tsa' bʌ ts'ijbu jini tsa' bʌ i xiq'ui yʌle' Dios Isaías bʌ i c'aba'. Che' ñac ti' jamʌ jini bʌlʌl bʌ jun ti' tyaja ba' mi yʌle' chʌ'ʌch bajche' iliyi: ");
INSERT INTO ctu76_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","I Ch'ujlel lac Yum an quic'ot como tsa'ix i yajcʌyon cha'an mic suben wen bʌ t'an p'ump'uño' bʌ. Ti xijq'uiyon c lajmisan jini ch'ʌjyem bʌ i pusic'al. Ti aq'uentiyon c subeñob t'an cha'an i tyajob i librejlel jini cʌchʌlo' bʌ yubil cha'an mi c'otyel i wut jini muts'ulo' bʌ i wut cha'an mi lajmel i tyʌc'lʌntyel jini tyʌc'lʌbilo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ti aq'uentiyon c sube' i yorojlel wale che' mi pʌstyʌl i yutslel lac Yum. Chʌ'ʌch ti' q'uele ba' ti wʌ tyajlel ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Che' jini ti' ñup'u jini jun Jesús. Ti' cha' aq'ue jini am bʌ ti' wenta ya' ti i templo israelob. Ti buchle Jesús. Ti pejtyelelob chʌncol i bej q'uelob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Che' jini ti queji ti t'an Jesús. Ti yʌlʌ: Wale iliyi chʌncox i ts'ʌctiyel wʌ' ti la' tyojlel tsa' bʌ ujti j q'uele' bʌ t'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ti pejtyelelob weñʌch ti' tyajayob ti t'an Jesús. Tyoj bʌc'ñʌjelob cha'an ti c'otyajax bʌ t'an tsa' bʌ subentiyob ti Jesús. Ti' c'ajtibeyob i bʌ: ¿Mach ba jin i yalobil José? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús ti' subeyob: Cujil isujm mi quejel la' subeñon jini albil bʌ t'an i cha'añob ba' mi yʌl: Ajts'ʌcaya, ts'ʌcan a bʌ. Mi quejel la' subeñon je'el: Jini tsa' bʌ lojon cubi ti a cha'le ñuc bʌ ya' ti Capernaum, mele je'el wʌ' ti a lumal. Che' mi quejel la' subeñon, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Che' jini Jesús ti' bej subeyob. Ti yʌlʌ: Melel mic subeñetla, ma'ix mi junticlec mu' bʌ i xiq'ue' i yʌle' Dios mu' bʌ i q'uejlel ti wen ti i lumal bʌ ti i pi'ʌlo' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mic subeñetla, melel ya'an cabʌl meba' x'ixicob ya' ti lumal israelob che' cuxul jini Elías tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix che' ma'ix ti ñumi ja'al uxp'ej jab tyʌlel i xiñil jabil. An cabʌl wi'ñal ti jim bʌ ora ti pejtyelel jini pañimil. ");
INSERT INTO ctu76_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero mach'an ti chojqui majlel Elías ba'an mi junticlec meba' x'ixic ya' bʌ añob ti lumal israelob cha'an i cotyañob. Ya' jach ti chojqui majlel ya' ba'an juntiquil meba' x'ixic chumul ya' ti Sarepta lʌc'ʌl ti lum Sidón. ");
INSERT INTO ctu76_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Che' je'el che' ñac cuxul tyo Eliseo tsa' bʌ i xiq'ui i yʌle' Dios an cabʌlob jini am bʌ chʌ bʌ yes pasem ti' pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Pero ma'an ti lajmisʌnti mi junticlec. Jini jach ti lajmisʌnti juntiquil Naamán bʌ i c'aba' ch'oyol bʌ ti Siria bʌ pañimil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Che' ñac ti yubiyob i t'an Jesús ti wen mich'ʌyob ti pejtyelelob ya' bʌ añob ti i templo israelob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ti wa'leyob. Ti' pʌyʌyob loq'uel Jesús ti lum. Ti' pʌyʌyob majlel ya' ti bujtyʌl cha'an yom i xit chocob jubel ya' ti lomtyʌl como wa'chocobil lum ti pam wits. ");
INSERT INTO ctu76_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús ti ñumi ti xinil ba'añob. Ti majli. ");
INSERT INTO ctu76_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Che' jini, Jesús ti majli ti Capernaum jump'ej lum ya' ti Galilea bʌ pañimil. Ya'i ti' cha'le cʌntisa ya' ti i templo israelob ti q'uinilel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tyoj bʌc'ñʌjelob ti yubiyob cha'an bajche' ti' cha'le cʌntisa como an i p'ʌtyʌlel i t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ya'an juntiquil winic ti i templo israelob tyʌc'lʌbil bʌ ti xiba. Ti' cha'le oñel jini xiba. Ti oñel ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Cucux. ¿Chucoch ma' tyʌlel ba'añon lojon, Jesús ch'oyolet bʌ ti Nazaret? ¿Tsa' ba tyʌliyet a jisañon lojon? Much j cʌñet majchetqui. Cujil isujm jatyet jini ch'ujulet bʌ i cha'an Dios, che' ti yʌlʌ jini xiba. ");
INSERT INTO ctu76_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús ti' tiq'ui jini xiba. Ti yʌlʌ: Lajmenix ti t'an. Loq'uen wʌ' ti winic. Che' ti yʌlʌ Jesús. Che' jini, jini xiba ti' choco jubel ti lum jini winic ti' tyojelob. Ti loq'ui jini xiba. Mach'an ti saj lojwi jini winic. ");
INSERT INTO ctu76_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tyoj bʌc'ñʌjelob ti yilʌyob quixtyañujob. Ti' subeyob i bʌ: ¿Chuqui ti t'an iliyi? An i p'ʌtyʌlel i t'an. Mi' cha'len xic' ti cabʌl i p'ʌtyʌlel i t'an. Mi' xic' loq'uel xibajob. Mi wa' loq'uelob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ti wa' lu' pujqui t'an cha'an Jesús ya' ti joytyʌlelob cha'an ti caj jini tsa' bʌ i cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Che' jini Jesús ti loq'ui majlel ya' ti i templo israelob. Ti ochi majlel ti yotyot Simón. C'am i nij'aña' Simón. Mi' wen ubin c'ajc. Ti' subeyob cha'an i lajmisʌben. ");
INSERT INTO ctu76_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús ti tinle i q'uel jini x'ixic, ti' tiq'ui jini c'ajc. Ti wa' lajmi ti c'ajc. Ora jach ti tyechi jini x'ixic. Ti queji i we'sañob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Che' ñac ti p'ʌjqui q'uin, ti queji i pʌyob majlel ba'an Jesús pejtyelel año' bʌ chʌ bʌ yes jach bʌ i c'am'an. Jesús ti yʌc'ʌ i c'ʌb ti jujuntiquil. Chʌ'ʌch ti' lajmisʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ti loq'ui je'el xibajob ti' pusic'al cabʌl xc'am'añob. Ti' cha'leyob oñel. Ti yʌlʌyob: I Yalobiletyʌch Dios, che'ob. Pero Jesús ti' tiq'ui jini xibajob. Mach'an ti yʌc'ʌyob ti t'an che' cu yujil isujm Cristojʌch jini yajcʌbil bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Che' ti cha' sʌc'ʌ ti loq'ui majlel Jesús ya' ti lum cha'an mi poj bajñel ajñel. Pero quixtyañujob ti' sajcʌyob. Ti c'otiyob ya' ba'an Jesús. Ti' jop'o i jalitisan ya'i cha'an mach'an mi majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús ti' subeyob: Añʌch cha'an majlicon ti yambʌ lum tyac je'el cha'an c subeñob t'an cha'an bajche' mi' cha'len yumʌl Dios como jini cha'an ti' chocoyon tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Che' jini, ti ñumi majlel Jesús ti subt'an ti i templo tyac israelob ya' ti Galilea bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Junyaj che' ya'an Jesús ti ti' colem joyol bʌ ja' Genesaret bʌ i c'aba' ti c'oti wen cabʌl quixtyañu. Jinic tyo ti wen jajp'iyob ochel i bʌ che' cu yomob i ñʌch'tyʌbeñob i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús ti yilʌ cha'p'ej jucub ya' ti i ti' jini colem joyol bʌ ja'. Tsa'ix loq'uiyob ajchuc chʌyob ti i jucub como chʌncox i wutsob i chim. ");
INSERT INTO ctu76_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús ti ochi ti jump'ej jucub i cha'an bʌ Simón. Ti' sube cha'an mi' ts'itya nijcan majlel jucub cha'an mero i cʌyob i bʌ. Che' jini Jesús ti buchle ti jucub. Ti queji i cʌntisan quixtyañujob che' ya'an ti jucub. Quixtyañujob añob ti ti' ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Che' ñac ti ujti ti cʌntisa Jesús ti' sube Simón: Nijcan majlel jucub ya' ba' tyam bʌ ja'. Choco ochel la' chim ya' ya'i cha'an la' chuque' chʌy, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón ti' jac'ʌ: Maestro, ti lojon c cha'le troñel c'ʌlʌ ti ñumi ac'bʌlel pero ma'ix chʌ bʌ ti lojon c tyaja. Pero cha'an ti a xiq'uiyon lojon mux c choque' ochel c chim, che' ti yʌlʌ Simón. ");
INSERT INTO ctu76_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Che' ñac ti' chocoyob ochel i chim ti' chucuyob yonlel chʌy jintyo ti queji i tyujquel jini chimol chʌy. ");
INSERT INTO ctu76_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Che' jini ti' pʌs'eyob ti' c'ʌb i pi'ʌlob ti troñel ti yambʌ jucub cha'an mi c'otyel i cotyañob. Ti c'otiyob. Ti' but'uyob cha'p'ej jucub ti chʌy. Yomox sujp'el ti ja' jini jucub. ");
INSERT INTO ctu76_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Che' ñac ti yilʌ Simón Pedro bajche' ti ujti ti' ñocchoco i bʌ ti yebal yoc Jesús. Ti yʌlʌ: Loq'uen tic tyojlel c Yum como xmulilon, che' Pedro. ");
INSERT INTO ctu76_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Como tyoj bʌc'ñʌjel Pedro yic'ot ti pejtyelel ya' bʌ añob yic'otyob cha'an wen yonlel chʌy tsa' bʌ i chucuyob. ");
INSERT INTO ctu76_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Che' je'el Jacobo yic'ot Juan i yalobilob Zabedeo i pi'ʌlob ti troñel jini Simón tyoj bʌc'ñʌjel je'el. Pero Jesús ti' sube Simón: Mach yom a cha'len bʌq'uen. Wale jach mi cotsañet cha'an a sajcʌbeñon quixtyañu mu' bʌ i quejel i ch'ujbiñon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Che' jini che' tsa'ix c'oti yic'ot i jucub ti ti' lum ti' lu' cʌyʌyob chʌ bʌ an i cha'an. Ti' tsʌcleyob majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Che' ñac ya'an Jesús ti jump'ej lum ti c'oti juntiquil winic am bʌ chʌ bʌ yes pasem ti pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Che' ñac ti yilʌ Jesús ti' pʌcchoco i bʌ ti yebal yoc Jesús. Ti' c'ajti: C Yum, mi a wom ch'ujbiyʌch a lajmisañon. Che' ti subenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Che' jini Jesús ti' tyʌlbe i c'ʌb che' chʌncol i yʌle': Comʌch. Mic lajmisañet, che' yʌlol jini winic. Che' chʌncol tyo ti t'an Jesús ti wa' lajmi jini pasem bʌ ti pʌchʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Che' jini Jesús ti' xiq'ui cha'an ma'an majch mi' suben mi junticlec. Ti' sube: Cucux, che' jach ma' majlel a pʌs'en a bʌ cura. Ya'i ma' wʌq'uen i majtyan Dios chʌ'ʌch bajche' ti yʌlʌ Moisés ti mandar cha'an mi yilañob tsʌ'ʌch lajmiyet. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ti bej más ajli cha'an i ñuclel Jesús. Cabʌl quixtyañujob ti' much'quiyob i bʌ cha'an i yubibeñob i t'an yic'ot cha'an i lajmisʌbentyel i c'am'an. ");
INSERT INTO ctu76_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús ti bajñel majli ba' mach'an quixtyañujob. Ya'i ti' mele oración. ");
INSERT INTO ctu76_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Junyaj che' chʌncol ti cʌntisa Jesús ya' buchulob cha'tiquil uxtiquil fariseojob yic'ot ajcʌntisajob cha'an i mandar israelob. Ch'oyolob ti pejtyelel saj lum tyac ti pañimil Galilea bʌ i c'aba' yic'ot loq'uem ti Judea bʌ pañimil yic'ot ti Jerusalén bʌ lum. Ti tsictiyi an i p'ʌtyʌlel Dios yic'ot Jesús che' ti' lajmisʌ ajc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Che' jini ti c'oti cha'tiquil uxtiquil winicob. Ti' cuchuyob tyʌlel ti ab juntiquil winic mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb. Yom i yotsañob ti otyot ya' ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mach'an ti' tyaja bajche' mi yotsañob cha'an cʌlʌx an quixtyañu. Che' jini ti letsiyob ti pam jini otyot. Ti' loc'sʌbeyob i xʌñil como pamacña i jol jini otyot. Ya'an ti ab jini quixtyañu ti' ju'sʌbeyob ya' ti mal otyot. Ti c'oti ti xiñil ya' ba' wa'al Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Che' ti yilʌ chʌncol i ch'ujbiñob ti' pusic'al, ti queji ti t'an Jesús. Ti' sube jini xc'am'an: Pi'ʌl, ñusʌbilix a mul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Che' jini, ajcʌntisajob cha'an i mandar israelob yic'ot jini junmujch' fariseojob ti queji i pensaliñob: ¿Majchqui jini winic chʌncol jach bʌ i cuye' i bʌ ti Dios ti i t'an? Ma'an majch ch'ujbi i ñusan mulil. Jini jach Dios, che'ob ti i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús yujil isujm chʌ bʌ chʌncol i bajñel alob ti i pusic'al. Ti' subeyob: ¿Chucoch chʌ'ʌch mi la' wʌle' ti la' pusic'al? ");
INSERT INTO ctu76_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Baqui bʌ más wocol mic suben mi la' wʌl? ¿Wocol ba mic suben ñusʌbilix a mul? ¿Wocol ba mic suben tyejchenix, cha'lenix xʌmbal? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wʌ'ʌch mi la' wilan añʌch c p'ʌtyʌlel cha'an mic ñusʌbeñob i mul jini wʌ' bʌ añob ti mulawil Joñon i Pi'ʌlon Quixtyañujob, che' ti yʌlʌ Jesús. Che' jini ti' sube jini winic mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb: Mic subeñet, tyejchen. Ch'ʌmʌx majlel a wab. Cucux ti a wotyot, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ti ora jach jini mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb ti wa' tyejchi ya' ti' tyojlelob. Ti' ch'ʌmʌ majlel i yab. Ti sujti majlel ti yotyot. Chʌncol i sub i ñuclel lac Yum. ");
INSERT INTO ctu76_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ti pejtyelel tyoj bʌc'ñʌjelob ti yilʌyob quixtyañu. Ti yʌlʌyob ñucʌch Dios. Añob cabʌl i bʌq'uen. Ti yʌlʌyob: Sajmʌl ti la quilʌ tyoj bʌc'ñʌjelonla yubil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ti wi'il ti loq'ui majlel Jesús ya'ya'i. Ti yilʌ juntiquil xch'ʌm tyojoñel Leví bʌ i c'aba'. Ya' buchul ba' mi' cha'leñob tyojoñel. Jesús ti' sube: Tsʌcleñon majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Che' jini Leví ti tyejchi. Ti' lu' cʌyʌ chʌ bʌ an i cha'an. Ti' tsʌcle majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Che' jini Leví ti' mele colem q'uin ti i yotyot cha'an Jesús. Ya'añob je'el cabʌl año' bʌ i ye'tyel cha'an i ch'ʌmob tyojoñel yic'ot yaño' bʌ. Ya' buchulob ti mesa yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero jini fariseojob yic'ot ajcʌntisajob cha'an i mandar israelob ti queji i tyajob ti t'an jini ajcʌnt'añob i cha'an Jesús. Ti' subeyob: ¿Chucoch mi la' cha'len uch'el la' wic'ot mu' bʌ i ch'ʌmob tyojoñel yic'ot yambʌ xmulilob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús ti' subeyob: Mach i c'ʌjnibal ts'ʌcʌntyel jini c'oc'o' bʌ. Jini jach jini c'amo' bʌ yom ts'ʌcʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma'an ti tyʌliyon c pʌyob jini mu' bʌ i lolon alob mach'ʌ ba'an i mul. Ti tyʌliyon c pʌyob jini mu' bʌ i ñatyan i mul cha'an i q'uextyan i pensal i cʌyob i mul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","An quixtyañujob chʌncol bʌ i poj cʌyob uch'el cha'an ti caj tsa' bʌ i ch'ujbiyob. Jini ti queji i c'ajtibeñob Jesús: ¿Chucoch cabʌl mi' cʌñʌtyañob i bʌ yic'ot cabʌl mi' cha'leñob oración jini mu' bʌ i cʌmbeñob i t'an Juan yic'otyob mu' bʌ i cʌmbeñob i t'an fariseojob? Pero jini ajcʌnt'añob a cha'an mi' bele' cha'leñob uch'el. Che' ti' c'ajtibeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús ti' jac'ʌ: ¿Mu' ba i cha'leñob ch'ajb jini mu' bʌ i tyʌlelob i q'uelob che' an q'uiñejel che' mi yujtyel ñujpuñel che' ya' tyo an yic'otyob ili ajñujpuñel? Mach'an mi' poj cʌyob uch'el che' ya' tyo an jini ajñujpuñel. ");
INSERT INTO ctu76_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero tyal tyo i yorojlel mi pʌjyel loq'uel ajñujpuñel ti' tyojel quixtyañujob. Che' jini mi quejel i ch'ajbañob i bʌ ti yan tyo bʌ q'uin, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Che' je'el ti yʌlʌ yambʌ lajoñel: Ma'an majch mi tsile' loq'uel ts'itya' pisil am bʌ ti tsiji' bʌ i pislel cha'an i lʌwe' i tsucul pislel. Mi chʌ'ʌch mi' cha'len mi yʌc' ti jilel jini tsiji' bʌ i pislel yic'ot je'el mach wen mi yajñel jini tsiji' bʌ yic'ot tsucul bʌ i pislel como mi quejel i com'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Che' je'el mach yom cojlic ochel ti tsucul pʌchij bʌ yajnib vino che' chʌncol tyo i mejlel jini vino bʌ lembal. Como jini vino bʌ lembʌl mi yʌc' ti tyojmel jini tsucul pʌchij bʌ yajnib. Che' jini mi bejquel jini vino. Mi tyojmel yajnib. ");
INSERT INTO ctu76_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jin cha'an yom mi yotsañob tsijib vino ti tsijib tyo bʌ yajnib. Che' jini mi cʌñʌtyʌntyel vino che' yic'ot yajnib je'el cha'an mach jilic, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ma'an majch yom i jape' tsijib vino mi tsa'ix i ñaxan japʌ wajalix bʌ mejli bʌ vino como mi yʌle' más sumuc jini wajalix bʌ, che'ob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jump'ej i q'uinilel c'aj oj ti ñumi majlel Jesús ti mal trigojol yic'ot jini chʌncol bʌ i cʌmbeñob i t'an. Jini ajcʌnt'añob i cha'an ti' tyuc'uyob i wut jini trigo che' bʌ bajche' arroz yilal che' chʌncol i ñumel majlel ya' ti trigojol. Ti' c'oc'be i wut ti i c'ʌb. Ti' c'uxuyob jini trigo. ");
INSERT INTO ctu76_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Che' jini cha'tiquil uxtiquil fariseojob ti queji i c'ajtibeñob jini ajcʌnt'añob i cha'an Jesús: ¿Chucoch mi la' cha'len tic'bil bʌ che' ti q'uinilel c'aj oj? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús ti' jac'beyob: ¿Mach'a ba'an ti la' q'uele ya' ti jun bajche' ti' cha'le David ti ñoj oniyix che' ñac ti yubiyob wi'ñal David yic'ot i pi'ʌlob? ");
INSERT INTO ctu76_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ti ochi ya' ti yotyot Dios David. Ti' ch'ʌmʌ waj tsa' bʌ ajq'ui ti mesa tsa' bʌ i yʌc'ʌyob cha'an i majtyan Dios. Ti' c'uxu David. Ti yʌq'ue i pi'ʌlob je'el. Pero tic'bil cha'an ma'an majch mi' c'uxe' jini waj. Jin jach curajob mi' c'uxob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ti' subeyob je'el: Joñoñʌch i Pi'ʌlon Quixtyañujob. An tic wenta cʌle' chʌ bʌ yom ujtic ti q'uinilel c'aj oj che' ti yʌlʌ Jesús che' cu i yʌc'bal. ");
INSERT INTO ctu76_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ti yambʌ i q'uinilel c'aj oj ti ochi Jesús ti i templo israelob. Ti queji ti cʌntisa. Ya'an juntiquil winic tyʌquin ñoj bʌ i c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jini ajcʌntisajob i cha'an israelob yic'ot fariseojob ti' wen q'ueleyob Jesús mi muc'ʌch i lajmisan che' ti q'uinilel c'aj oj cha'an yomob i jop'ben i mul Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús yujil isujm chʌ bʌ ti' pensaliyob ti' pusic'al. Che' jini ti' sube jini winic tyʌquin bʌ i c'ʌb: Tyejchen. La' ti wa'tyʌl wʌ' ti' tyojel lojon c wut, che'en. Jini winic tsʌ'ʌch tyejchi. Ti wa'le ti' tyojelob. ");
INSERT INTO ctu76_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Che' jini Jesús ti' sube jini yaño' bʌ. Mi quej j c'ajtibeñetla junchajb: ¿Baqui bʌ yom lac mele' ti q'uinilel c'aj oj? ¿Wen ba yom mi lac cha'len o mach wen yom mi lac cha'len? ¿Yom ba mi laj cotyan juntiquil cha'an mach sajtic, o mach yom mi laj cotyan? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Che' jini Jesús ti' lu' q'uele pejtyelel ya' bʌ añob ti joytyʌlel. Ti' sube jini winic: Sʌts'ʌ a c'ʌb, che' Jesús. Che' jini, jini winic ti' sʌts'ʌ i c'ʌb. Ti wa' lajmi. ");
INSERT INTO ctu76_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero jini yaño' bʌ ti wen mich'ʌyob. Ti queji i c'ajtibeñob i bʌ chʌ bʌ mi quejel i tyumbeñob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti jim bʌ q'uin tyac ti majli Jesús ti wits cha'an i cha'len oración. C'ʌlʌ ti ñumi ac'bʌlel ti' pejcʌ Dios ti oración. ");
INSERT INTO ctu76_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Che' ti sʌc'ʌ, Jesús ti' pʌyʌ tyʌlel jini ajcʌnt'añob i cha'an. Ti yajcʌ loq'uel docejob tsa' bʌ i pejcʌ je'el ti yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jiñob i c'aba'ob tsa' bʌ i yajcʌ Jesús: Simón tsa' bʌ yotsʌbe i cha'chajplel i c'aba' Pedro, Andrés i yijts'in Simón; Jacobo yic'ot Juan, Felipe yic'ot Bartolomé, ");
INSERT INTO ctu76_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo yic'ot Tomás, Jacobo i yalobil Alfeo; Simón ch'oyol bʌ ba'an junmujch' cananista bʌ i c'aba'; ");
INSERT INTO ctu76_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas i yijts'in Jacobo yic'ot Judas Iscariote jini tsa' bʌ i yʌc'ʌ ti cʌchol Jesús ti yan tyo bʌ ora. ");
INSERT INTO ctu76_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús ti jubi tyʌlel ti wits yic'ot ajcʌnt'añob i cha'an. Ya' ti cʌyle yic'otyob ya' ti joctyʌl. Ya'an cabʌl quixtyañu tsa' bʌ c'otiyob ch'oyolob ti pejtyelel pañimil Judea bʌ i c'aba' yic'ot Jerusalén bʌ lum yic'ot lum Tiro yic'ot Sidón ya' bʌ an ti' ti' colem ja'. Ti c'otiyob cha'an i yubibeñob i t'an Jesús yic'ot cha'an mi lajmisʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jini tyʌc'lʌbilo' bʌ ti xibajob ti lajmisʌntiyob je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ti pejtyelel quixtyañujob yom i tyʌlob Jesús como cha'an ti i p'ʌtyʌlel ti' lajmisʌyob ti pejtyelelob. ");
INSERT INTO ctu76_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Che' jini Jesús ti' q'uele jini ajcʌnt'añob i cha'an. Ti' subeyob: Tijicñayetla mach'ʌ ba'an chʌ bʌ yes an la' cha'an como mi' cha'len yumʌl Dios ti la' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tijicñayetla am bʌ la' wi'ñal wale iliyi como mi quejel la' ñaj'an. Tijicñayetla mu' bʌ la' cha'len uq'uel cha'an ch'ʌjyemlel como mu' tyo quejel la' cha'le tse'ñal. ");
INSERT INTO ctu76_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tijicñayetla che' mi' mich'q'ueletla quixtyañujob che' mi' choquetla loq'uel ti i tyojlelob, che' mi la' wʌl'entyel, che' mi' p'ajetla, che' bajche' mi mach weñetla cha'an tij caj Joñon i Pi'ʌlon Quixtyañujob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wen tijicñisan la' bʌ ti jim bʌ ora. La' ñuc'ac la' pusic'al como mi quejel la' wʌq'uentyel ñuc bʌ la' majtyan ya' ti panchan. Che' je'el ti ñoj oniyix ti tyʌc'lʌyob jini tsa' bʌ i xiq'ui i yʌle' Dios i yumob jini quixtyañujob wʌ' bʌ'an wale. ");
INSERT INTO ctu76_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero p'ump'uñetla am bʌ cabʌl chʌ bʌ an la' cha'an como tsa'ix la' wʌ ubin c'ajacña bʌ la' woj. ");
INSERT INTO ctu76_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","P'ump'uñetla ñajetix bʌ la wale che' an cabʌl chʌ bʌ yes an la' cha'an como mi quejel la' wubin wi'ñal. P'ump'uñetla muq'uet bʌ la ti tse'ñal cha'an wen añetla mi la' lolon ubin wale. Mi quejel la' cha'len uq'uel cha'an ti la' ch'ʌjyemlel. ");
INSERT INTO ctu76_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","P'ump'uñetla che' pejtyelel quixtyañujob mi' tyajetla ti wen bʌ t'an. Chʌ'ʌch ti' lolon tyajbeyob ti wen bʌ t'an je'el jini xlot tsa' bʌ lolon alʌ ti xijq'ui i yʌle' Dios jini i yumob ti ñoj oniyix. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesús ti bej alʌ: Pero jatyetla mu' bʌ la' ñʌch'tyañon, mic subeñetla: P'untyan la' contrajob. Cha'liben wen bʌ jini mu' bʌ i ts'a'leñetla. ");
INSERT INTO ctu76_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Subenla wen bʌ mu' bʌ i ch'ʌquetla. Pejcʌbenla Dios ti oración jini mu' bʌ i tyʌc'lañetla. ");
INSERT INTO ctu76_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mi an majch mi' jats'et ti jump'ej a choj, aq'uen i cha' jats'et ti junwejl a choj je'el. Mi an majch wersa yom i ch'ʌme' a tsuts bujc aq'uen i ch'ʌme' a bujc je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Majchical mi' c'ajtibeñet, aq'uen. Jini mu' bʌ i wersa ch'ʌme' chʌ bʌ an a cha'an mach a pensalin a cha' suben i sutquibeñet. ");
INSERT INTO ctu76_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Che' bajche' a wom a melbentyel wen bʌ chʌ'ʌch yom a melben yambʌ a pi'ʌl je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mi chʌncol jach la' p'untyan jini mu' bʌ i p'untyañetla, ¿wen ba mi la' cha'len, ma' wʌl? Como chʌ'ʌch mi' p'untyañob i pi'ʌlob jini mach'ʌ ba'an ochemob. Che' jini lajal jach mi la' cha'len p'untyaya bajche' mi' p'untyan i bʌ simaroño' bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mi chʌncol jach la' cha'libenla wen bʌ jini mu' bʌ i cha'libeñetla wen bʌ je'el, ¿wen ba mi la' cha'len, che' jini? Mach'an, como chʌ'ʌch mi' cha'len xmulilob je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mi chʌncol jach la' wʌc' ti q'uex jini ch'ujbi bʌ i cha' aq'ueñetla, ¿wen ba mi la' cha'len? Como lajalet jach la yic'ot simaroño' bʌ, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero jatyetla wersa yom mi la' p'untyan la' contrajob. Yom mi la' cha'liben wen bʌ. Yom mi la' wʌq'uen chʌ bʌ mi' c'ajtibeñetla ti q'uex che' mach'an mi la' pijtyan i jol. Mi quejel la' wʌq'uentyel cabʌl la' tyojol yubil. Mi quejel la' wajñel ti yalobil Dios mach'ʌ ba'an i p'isol i ñuclel. Como uts Dios je'el yic'ot jini mach'ʌ ba'an wocox i yʌlʌyob ti' pusic'al yic'ot simaroño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","P'untyanla la' pi'ʌlob che' bajche' mi' p'untyañetla la' Tyat am bʌ ti panchan je'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesús ti bej alʌ: Mach yom la' lolon al mi an i mul che' max tyo ti yoque tsictyay mi an o mi mach'an. Che' jini, ma'an mi yʌl Dios mi añʌch la' mul. Mach yom mi la' lolon al ti xmulil yaño' bʌ che' max tyo tsictyay. Che' jini mach'an mi yʌl Dios mi xmuliletla. Ñusʌbeñob i mul. Che' jini Dios mi' ñusʌbeñetla la' mul je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Aq'uenla yañob' bʌ. Dios mi quej i yʌq'ueñetla je'el. Dios mi quej i yʌq'ueñetla wen bʌ i p'isol che' bajche' mi tsʌts tejnibil cha'an chejpʌbil chʌncol ti wejtyʌyel mi quejel i yʌq'ueñetyob. Como che' bajche' mi la' p'isben quixtyañujob chʌ'ʌch mi quejel la' wʌq'uentyel je'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ti' sube ili lajoñel: ¿Ch'ujbi ba i pʌs'en majlel bij muts'ul bʌ i wut yambʌ muts'ul bʌ i wut? Mach'an. Mu' jach i yajlel ti cha'ticlel ti jowol bʌ lum. ");
INSERT INTO ctu76_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ma'an ajcʌnt'an mu' bʌ i más cʌñe' bajche' mi cʌntisʌntyel ti ajcʌntisa. Pero an ajcʌnt'an mu' bʌ i tyaje' i ña'tyʌbal ajcʌntisa i cha'an che' tsa'ix ujti i cʌñe'. ");
INSERT INTO ctu76_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Bajche'qui isujm che' ch'ujbi a wilan i ts'ubil tye' ti wut a wermañu che' mach'an ma' pensalin mi an colem xujc'u' tye' ti a wut yubil? ");
INSERT INTO ctu76_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Bajche'qui ch'ujbi a suben a wermañu: Quermañu, aq'ueñon loc'sʌbeñet jini ts'ubil tye' am bʌ ti a wut, che'et, che' mach'an ma' pensalin mi an colem xujc'u tye' ti a wut? Cha'chajb a pensal. Ñaxan loc'san jini colem xujc'u tye' am bʌ ti a wut. Che' jini ch'ujbi a más q'uele' cha'an a loc'sʌben i ts'ubil tye' am bʌ ti i wut a wermañu yubil. Che' ti' cha'le cʌntisa Jesús cha'an jini más on bʌ i mul mu' bʌ i lolon ale' an i mul i pi'ʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ma'ix wen bʌ tye' mu' bʌ i yʌc' mach'ʌ wen bʌ i wut. Jini mach'ʌ wen bʌ tye' mach ch'ujbi i yʌc' wen bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Mi cʌjñel jujuntyejc tye' cha'an ti i wut. Mach'an mi lac tyuc' higo bʌ wut tye' ti ts'ʌbabol. Che' je'el ma'ix mi lac tyuq'ue' ts'ujsub ti ch'ixol. ");
INSERT INTO ctu76_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jini wen bʌ quixtyañu mi yʌle' wen bʌ t'an cha'an wen bʌ am bʌ ti' pusic'al. Jini mach'ʌ wen bʌ quixtyañu mi yʌle' mach'ʌ wen cha'an mach wen am bʌ ti' pusic'al. Como chʌ bʌ jach mi' but'e' i pusic'al quixtyañu mi tsictiyel ti i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesús ti' bej cha'le cʌntisʌ. Ti yʌlʌ: ¿Chucoch mi la' lolon subeñon: C Yum, che'etla, pero mach'an mi la' jac' mu' bʌ c subeñetla? ");
INSERT INTO ctu76_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mi quejel c subeñetla bajche' an jini mu' bʌ i tyʌlel ba'añon, mu' bʌ i yubibeñon c t'an mu' bʌ i ch'ujbiben c t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Lajalʌch bajche' juntiquil winic tsa' bʌ i mele i yotyot. Pero ñaxan tyam ti' piqui lum cha'an mi' tyaje' tyun ba' mi' wa'chocon i ts'ajquil i yebal yotyot. Che' ñac ti wen tyʌm'ʌ ja' c'ʌlʌ ti ochi ti ma'tye'el. Wen tsʌts ti' jats'ʌ otyot jini ja' pero mach'an ti nijcʌyi otyot como tsʌts ti ts'uyle ti' pam tyun. ");
INSERT INTO ctu76_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero jini mu' bʌ i yubibeñon c t'an pero mach'an mi' ch'ujbibeñon mu' bʌ c tyumbin lajal bajche' winic tsa' bʌ i mele i yotyot ti pam jach lum. Mach'an tyam bʌ i ts'ajquil i yebal otyot. Che' ñac ti wen tyʌm'ʌ ja' wen tsʌts ti' jats'ʌ otyot jini ja'. Ti ora ti lu' jejmi jini otyot. Che' ti yʌlʌ Jesús ti lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Che' ñac ti ujti i suben quixtyañujob pejtyelel ili t'an tyac, Jesús ti majli ya' ti lum Capernaum bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ya'an juntiquil am bʌ ye'tyel ti capitán cha'an cien soldadojob i cha'an romanojob. An ajtroñel i cha'an jini capitán tsa' bʌ i wen p'untyʌ. Wen c'am. Yomox sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Che' ñac ti yubi jini capitán mi ya'an Jesús, ti' xiq'ui majlel cha'tiquil uxtiquil xñoxob año' bʌ i ye'tyel cha'an israelob cha'an i c'ajtiben Jesús cha'an i c'otyel i lajmisan ajtroñel i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ti c'otiyob ba'an Jesús. Ti queji i wen suben. C'ʌjnibalʌch a cotyan i capitán soldadojob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Como mi' p'untyañon lojon. I bajñel ti yʌc'ʌ ti' melol lojon c templo, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Che' jini ti queji i majlel Jesús yic'otyob. Pero che' lʌc'ʌlix i c'otyel ti yotyot, jini capitán ti xiq'ui majlel juntiquil i pi'ʌlob ya' ba'an Jesús cha'an i suben: C Yum, mach a tyʌc'lan a bʌ como ma'ix c ñuclel cha'an ma' wochel ti cotyot, che'en. Chʌ'ʌch ti' ju'sʌ i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ti yʌlʌ je'el jini capitán: Mi joñonic ti tyʌliyon ba'añet c bajñel pero tic choco tyʌlel yambʌ i subeñet. Jin jach yom ma' wʌc' a t'an cha'an mi lajmel ajtroñel c cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Como joñon je'el mic xijq'uel ti yambʌ más ñuc bʌ i ye'tyel. Che' je'el mic xiq'ue' soldadojob. Che' mic suben juntiquil: Cucux, cho'on, mi majlel. Mic suben yambʌ: La', cho'on, mi tyʌlel. Che' mic suben ajtroñel: Cha'len jini, cho'on, mi' cha'len. Che' ti yʌlʌ jini capitán. ");
INSERT INTO ctu76_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Che' ñac ti yubi Jesús ñoj tijicña ti yubibe i t'an jini capitán. Ti sutqui i bʌ i q'uele' jini quixtyañujob chʌncol bʌ i tsʌclen majlel. Ti' subeyob: Melel, mach'an ba' tic tyaja mi ba'anic c pi'ʌlob jini israelo' bʌ juntiquil mu' bʌ i wen ch'ujbin bajche' ili winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Che' ñac ti cha' c'otiyob ti otyot jini tsa' bʌ chojquiyob majlel ba'an Jesús ti' tyajayob cha' c'oq'uix jini ajtroñel tsa' bʌ c'am'ʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti wi'il Jesús ti majli ti jump'ej lum Naín bʌ i c'aba'. Ti pi'le majlel ajcʌnt'añob i cha'an yic'ot cabʌl quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Che' ñac lʌc'ʌlix i c'otyelob ti jini lum ti queji i yilan chʌncol i pʌyob majlel ch'ujlelʌl cha'an i ch'ujñañob. Jin jach bʌ i yalobil juntiquil meba' 'ixic. Cabʌl quixtyañu chʌncol i pi'leñob majlel ti xʌmbal. ");
INSERT INTO ctu76_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Che' ñac lac Yum ti yilʌ ti' p'untyʌ jini meba' x'ixic. Ti' sube: Mach yom ma' cha'len uq'uel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Che' jini Jesús ti c'oti ya' ba'añob. Ti' tyʌlbe i cajonlel ch'ujlelʌl. Ti' cʌyʌ i xʌmbal jini chʌncol bʌ i q'uechob majlel. Jesús ti' sube jini tsa'ix bʌ sajti: Alob, mic subeñet: Tyejchen, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Che' jini tsa' bʌ sajti ti buchle. Ti queji ti t'an. Jesús ti yʌlʌ: Umba'an a walobil. Che' ti' sube i ña. ");
INSERT INTO ctu76_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Che' ñac ti yilʌyob ti lu' quejiyob ti bʌq'uen. Ti queji i subeñob i ñuclel Dios. Ti yʌlʌyob: Wʌ'ʌch an la quic'ot ñuc bʌ quixtyañu tsa' bʌ i xiq'ui i yʌle' Dios. Ti yʌlʌyob je'el: Tsa'ix tyʌli Dios i cotyan i cha'año' bʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya' ti Judea bʌ pañimil yic'ot ti joytyʌlel ti pujqui t'an cha'an chʌ bʌ ti' cha'le Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jini ajcʌnt'añob i cha'an Juan ti' lu' subeyob pejtyelel tsa' bʌ ujti tsa' bʌ i cha'le Jesús. Che' jini, Juan ti' pʌyʌ tyʌlel cha'tiquil ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ti' choco majlel cha'tiquil ba'an Jesús cha'an i c'ajtiben mi melelʌch Cristo jini yajcʌbil bʌ mu' bʌ quejel i tyʌlel o mi yom tyo i bej pijtyan yambʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jini tsa' bʌ i choco majlel Juan ti c'otiyob ba'an Jesús. Ti' subeyob: Jini Juan mu' bʌ i yʌc'ob ti ch'ʌm ja' quixtyañujob ti' chocoyon lojon tyʌlel cha'an mi lojon j c'ajtibeñet: ¿Jatyet ba jini Cristo jini yajcʌbil bʌ mu' bʌ quejel i tyʌlel o yom tyo mi lojon c bej pijtyan yambʌ? che'en. Che' mi' c'ajtin Juan che' ti yʌlʌ ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ti jin jach bʌ ora che' ti c'otiyob jini cha'tiquil chocol bʌ tyʌlel ti Juan, Jesús chʌncol i lajmisan cabʌl quixtyañu am bʌ i c'am'an yic'ot tyʌc'lʌbilo' bʌ ti xiba. Ti' lajmisʌbeyob je'el i wut cabʌl muts'ulo' bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesús ti' jac'beyob jini ajcʌnt'añob i cha'an Juan: Cucuxla. Subenla Juan jini tsa' bʌ la' wilʌ, tsa' bʌ la' wubi. Suben bajche' chʌncol i cha' c'otyel i wut muts'ulo' bʌ i wut. Chʌncol ti cha' xʌmbal jini mach'ʌ ba'an i c'ʌjnibal yoc ti yambʌ ora. Lajmeñobix jini am bʌ chʌ bʌ pasem ti pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Mi cha' ubin t'an jini xcojcob. An mu' bʌ i cha' cuxtiyel tsa' bʌ sajti. Mi subentyel t'an cha'an i cotyʌntyel jini p'ump'uño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","C'ajacña i yoj mi yubin jini mach'ʌ ba'an mi' cʌye' i bej ch'ujbiñon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Che' ñac ti cha' sujtiyob ba'an Juan tsa' bʌ chojqui majlel ba'an Jesús, Jesús ti queji i suben quixtyañujob cha'an jini Juan. Ti yʌlʌ: ¿Chuqui tsajni la' q'uele' ya' ti tyʌquin bʌ joch lum? ¿Tsajni ba la' q'uele' juntiquil c'un bʌ bajche' c'un sʌyan bʌ jalʌl mu' bʌ i nijcʌyel ti ic'? ");
INSERT INTO ctu76_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mi mach jiniqui, ¿chuqui tsajni la' q'uele' che' jini? ¿Tsajni ba la' q'uele' winic xojol i cha'an c'otyajax bʌ i pislel? La' wujil isujm jini am bʌ wen c'otyajax bʌ i pislel yic'ot mu' bʌ yajñel ti ricojlel, ya' añob ti yotyot ñuc bʌ yumʌlob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Chuqui tsajni la' q'uele', che' jini? ¿Juntiquil ba tsa' bʌ i xiq'ui i yʌle' Dios? Melelʌch, pero más ñuc jini Juan bajche' yaño' bʌ tsa' bʌ i xiq'ui i yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jini Juan jiñʌch tsa' bʌ ña'tyʌnti ti t'an ti Ts'ijbubil bʌ i T'an Dios ba' Dios mi yʌle' cha'an jini ajsubt'an. Mi yʌle': Mic xiq'ue' majlel cajsubt'an mu' bʌ i ñaxan chajpʌbeñet a bijlel, che'en. Che' ti wʌ ña'tyʌnti Juan ti Ts'ijbubil bʌ i T'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Mic subeñetla ti pejtyelel jini tsa' bʌ i xiq'ui i yʌle' Dios mach'an más ñuc bʌ bajche' Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja'. Pero jini mach'ʌ ba'an sajlic i ñuclel mu' bʌ i yumin Dios más ñuc bajche' jini Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ti pejtyelel quixtyañu yic'ot am bʌ ye'tyel ti ch'ʌm tyojoñel ti yubiyob i t'an Jesús. Ti' ch'ʌmʌyob ja' ti i c'ʌb Juan. Ti' ña'tyʌyob ti' pusic'al tyojʌch bajche' ti' cha'le Dios che' ti subentiyob bajche' yom i cʌyob i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero jini fariseojob yic'ot jini ajcʌntisa i cha'an israelob mach'ʌ ba'an ti yʌc'ʌyob i bʌ i ch'ʌm ja' ti i c'ʌb Juan ti' p'ajayob jini yom bʌ i yʌq'ueñob Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Lac Yum ti yʌlʌ: ¿Chuqui yic'ot mi quejel c laje' ili quixtyañujob am bʌ ti ili oraji? ¿Bajche' yilalob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ili quixtyañujob chʌ'ʌch añob bajche' alp'eñalob buchulob ti alas ti parque. Ti oñel mi' subeñob i pi'ʌlob ti alas: Chʌncol lojon c lolon wuse' jalʌl pero ma'ix mi la' cha'len son. Mi lojon c lolon cha'len ch'ʌjyem bʌ c'ay pero ma'ix mi la' cha'len uq'uel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Como ti tyʌli jini Juan mu' bʌ i yʌc' ch'ʌm ja'. Mach'an mi' cabʌl cha'len wen bʌ uch'el. Mach'an mi' jape' vino i ya'lel ts'ujsub. Mi la' lolon wale' an i xibʌjlel. ");
INSERT INTO ctu76_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Che' jini ti tyʌliyon i Pi'ʌlon bʌ Quixtyañujob. Mic cha'len wen bʌ we'el uch'el. Mi la' wʌl xwo'lelon yic'ot cha'an mic niq'ui jape'. I pi'ʌlon ti xʌmbal xmulilob yic'ot xlot bʌ xch'ʌm tyojoñelob che' mi la' wʌle'. Che' ti yʌlʌ Jesús ti subenti fariseojob yic'ot ajcʌntisajob. ");
INSERT INTO ctu76_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero Dios mi' tsictisan i ña'tyʌbal ti jini año' bʌ i ña'tyʌbal. ");
INSERT INTO ctu76_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Juntiquil fariseo bʌ winic ti' pʌyʌ majlel Jesús ti uch'el ti yotyot. Ti majli Jesús. Ya'i ti buchle ti mesa cha'an mi' cha'len uch'el. ");
INSERT INTO ctu76_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Che' jini ti c'oti juntiquil x'ixic tsa' bʌ cha'le mulil yic'ot winic. Chumul jini x'ixic ti jin jach bʌ lum. Che' ñac ti queji i yubin ya'an Jesús ti yotyot fariseo, ti c'oti jini x'ixic je'el. Ti' ch'ʌmʌ majlel jump'ej frasco melel ti wen bʌ tyun alabastro bʌ i c'aba'. But'ul ti yowocña bʌ aceite. ");
INSERT INTO ctu76_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ti c'oti lʌc'ʌl ti yoc Jesús. Chʌncol ti uq'uel. Ti queji i mul'en i yoc ti ya'lel i wut. Che' jini ti queji i tyʌquisʌben ti tsutsel i jol. Ti' ñupbe i yoc. Ti yulbe i yoc ti jini yowocña bʌ aceite. ");
INSERT INTO ctu76_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Che' ñac ti yilʌ jini fariseo tsa' bʌ i pʌyʌ ochel Jesús ti yotyot ti' pensali: Tsa'ic i xiq'ui i yʌle' Dios jini Jesús tsʌ'ʌch i wʌ ña'tyʌ Jesús majchqui jini x'ixic como mach wen bʌ x'ixic jini, che' ti lolon pensali ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Che' jini Jesús ti' sube jini fariseo bʌ winic: Simón, an chʌ bʌ com c subeñet, che'en. Jini fariseo ti' jac'ʌ: Subeñon, Maestro, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús ti' sube: An cha'tiquil winic año' bʌ i bet ba'an juntiquil mu' bʌ i yʌc' tyaq'uin ti q'uex. Juntiquil an i bet che' bajche' i tyojol mi yʌq'uentyel i tyojol quinientos q'uin toñel. Jini yambʌ an i bet che' bajche' i tyojol mi yʌq'uentyel i tyojol cincuenta q'uin toñel. ");
INSERT INTO ctu76_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero cha'an mach ch'ujbi i tyojob ti' yʌpbeyob i bet ti cha'ticlelob. Wale subeyon: ¿Majchqui jini cha'tiquilob mi quejel i más p'untyan jini tsa' bʌ i yʌpbeyob i bet, ma' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón ti' jac'ʌ: C'o'ojl jini tsa' bʌ yʌpbenti más on bʌ i bet, che'en. Jesús ti' jac'ʌ: Jiñʌchi, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Che' jini, che' chʌncol i q'uele' jini x'ixic Jesús ti' sube Simón: ¿Mu' ba a q'uele' ili x'ixiqui? Ti ochiyon ti a wotyot. Mach'an ti a wʌq'ueyon ja' cha'an c poque' loq'uel i ts'ujbejñal coc. Pero ili x'ixic ti' pocbeyon coc ti i ya'lel i wut. Ti' sujcubeyon coc ti i tsutsel i jol. ");
INSERT INTO ctu76_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Mach'an ti a ñupuyon che' bajche' costumbre bʌ saludo mi lac cha'len pero ili x'ixic mach'an ti' cʌyʌ i ñupbeñon coc c'ʌlʌ ti ochiyon ti a wotyot. ");
INSERT INTO ctu76_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Mach'an ti a yulbon aceite tic jol che' bajche' costumbre pero ili x'ixic ti yulbe yowocña bʌ aceite ti coc. ");
INSERT INTO ctu76_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jin cha'an mic subeñet: Ti cabʌl p'untyaya chʌncol bʌ i cha'len mi tsictiyel tsa'ix cabʌl ñusʌbenti i mul. Pero jini i saj jach bʌ i mul mu' bʌ i ñusʌbentyel, i saj jach mi' cha'len p'untyaya je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Che' jini ti' sube jini x'ixic: Ñusʌbilix a mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jini pʌybilo' bʌ ti uch'el ya' bʌ buchulob yic'ot Jesús ti queji i subeñob i bʌ: ¿Majchqui jini quixtyañu mu' bʌ i ñusan mulil? Che' ti yʌlʌyob ya' bʌ an yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús ti' sube jini x'ixic: Tsa'ix cotyʌntiyet cha'an ti a ch'ujbiyon. Cucux ti i ñʌch'tyʌlel a pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Che' jini Jesús ti ñumi majlel ti cabʌl lum yic'ot saj lum tyac. Ti' subeyob jini wen bʌ t'an cha'an bajche' mi' cha'len yumʌl Dios. Jini doce yajcʌbilo' bʌ ajsubt'añob ñumel ti majli yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ti' tsʌcleyob majlel Jesús je'el cha'tiquil uxtiquil x'ixicob tsa' bʌ lajmisʌntiyob tyʌc'lʌbilo' bʌ ti xiba yic'ot xc'am'an tyac. Ya'an yic'otyob je'el María mu' bʌ i pejcʌntyel ti Magdalena cha'an ch'oyol ti Magdala. Jiñʌch tsa' bʌ loc'sʌbenti siete xibajob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ya'an yic'ot Jesús je'el jini Juana i yijñam bʌ Chuza. Jini Chuza an ti' wenta cha'an i q'uel ajtroñelob ya' ti yotyot ñuc bʌ yumʌl Herodes bʌ i c'aba'. Ti' tsʌcle majlel Jesús je'el Susana yic'ot cabʌl yambʌ x'ixicob tsa' bʌ i cotyʌyob Jesús cha'an ti chʌ bʌ yes yom i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cabʌl quixtyañu ti loq'uiyob majlel ti lum tyac cha'an yom i q'uelob Jesús. Che' tsa'ix i much'quiyob i bʌ cabʌl quixtyañu, Jesús ti queji i pejcañob ti lajoñel tyac. Ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Ti loq'ui majlel juntiquil winic ti p'ujp'ujya pac'. Che' ñac ti' p'ujp'u majlel jini pac' ti yajli ts'itya' ya' ti bij. Ti' pejchic' tyeq'uiyob jini pac' ti bij. Jini xma'tye'mut ti' buc'uyob jini pac'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yambʌ ts'itya' ti yajli ti pam xajolel. Che' ñac ti pasi jini pac' ti wa' tyʌqui como mach'an ach' i lumil. ");
INSERT INTO ctu76_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yambʌ ts'itya' ti p'ajti ti mal ch'ixol. Che' ti coli ti yebali jini tsa' bʌ pasi yic'ot jini pac'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pero yambʌ pac' ti yajli ba' wen bʌ lum. Che' ñac ti coli ti yʌc'ʌ wen bʌ i wut. Jujump'ej i bʌc' ti yʌc'ʌ jintyo cien i wut. Che' ti ujti i yʌle' jini lajoñel Jesús ti yʌlʌ ti c'am bʌ t'an: Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalinla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Che' jini, jini ajcʌnt'añob i cha'an Jesús ti queji i c'ajtiben i sujmlel jini lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús ti' subeyob: Dios ti yʌq'uetla la' ch'ʌm'en isujm jini max tyo bʌ ba'an tsictiyem ti yambʌ ora bajche' mi' cha'len yumʌl Dios. Pero jini mach'ʌ ba'an ochem mij cʌntisañob ti lajoñel tyac cha'an che' mic subeñob che' bajche' ma'ix mi yilañob mi' cha'len. Aunque mi yubiñob c t'an mach'an mi' ch'ʌm'eñob isujm. ");
INSERT INTO ctu76_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jiñʌch yom i yʌle' jini lajoñel: Lajalʌch bajche' i t'an Dios jini pac'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Jini pac' tsa' bʌ p'ajti ti bij jiñʌch che' bajche' mu' bʌ i yubiñob i t'an Dios. Pero mi tyʌlel xiba. Mi' loc'sʌbeñob jini t'an Dios am bʌ ti' pusic'al cha'an mach'an mi' ch'ujbin, cha'an mach'an mi cotyʌntyelob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ti lajoñel jini pac' tsa' bʌ p'ajti ti xajolel jiñʌch che' bajche' jini mu' bʌ i yubin i t'an Dios. Mi' wen mulan. Pero mach'an tyam i wi' ti i pusic'al yubil. Mi' poj ch'ujbin pero che' mi yubin wocol mi cha' actyan. ");
INSERT INTO ctu76_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ti lajoñel jini pac' tsa' bʌ p'ajti ti mal ch'ixol jiñʌch che' bajche' mu' bʌ i yubin i t'an Dios. Mach'ʌ ba'an mi' cʌy i pensalin i cha'an jach bʌ mulawil yic'ot jin jach che' an pejtyelel chʌ bʌ an i cha'an yic'ot chʌ bʌ jach mi' mulan i cha'len. Mi' yebalin jini t'an yubil cha'an mach yʌq'uic i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero jini pac' tsa' bʌ p'ajti ti wen bʌ lum, jiñʌch che' bajche' mu' bʌ i wen yubiñob i t'an Dios. Weñʌch i pusic'al. Mi' mulan i ñʌch'tyan jini t'an. Mi' ch'ujbin jini t'an. Xuc'ulob mi yajñel. Jiñʌch mi' wen ac' i wut yubil. ");
INSERT INTO ctu76_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Mach'an majch mi' ts'ʌbe' pat cas cha'an mi' ñup' ti chʌ bʌ yes o cha'an mi yʌc' ti yebal wʌyibʌl. Pero mi' joc'chocon ti chan cha'an mi tsictiyel i c'ʌc'al jini mu' bʌ ochel. ");
INSERT INTO ctu76_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Mach'an chʌ bʌ mucul tyac mi quejel yajñel mach'ʌ ba'an mi quejel i tsictiyel. Mach'an mach bʌ tsictyay. Lu' muc'ʌch i tsictiyel. ");
INSERT INTO ctu76_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wen xuc'uletla che' mi la' ñʌch'tyan i t'an Dios. Como jini am bʌ i cha'an mi quejel tyo i bej yʌq'uentyel. Pero jini mach'ʌ ba'an i cha'an mu' tyo i chilbentyel mu' bʌ i lolon pensalin i cha'añʌch. Che' ti yʌlʌ Jesús ti lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Che' jini ti c'oti i ña' Jesús yic'ot i yijts'iñob ya' ba'an Jesús. Pero mach ch'ujbi i lʌq'ue' Jesús como an cabʌl quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","An majch ti' sube Jesús: Ya' añob ti pañimil a ña' a wijts'iñob. Yom i q'ueletyob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesús ti' subeyob: Jini mu' bʌ i yubiñob i t'an Dios, jini mu' bʌ i ch'ujbiben jiñobʌch c ña' yubil, quijts'iñob, yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Junyaj che' ti ochi ti barco Jesús yic'ot ajcʌnt'añob i cha'an, Jesús ti' subeyob: La' c'axiconla majlel ti junwej ja', che'en. Che' jini ti majliyob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Che' chʌncolix i c'axelob ti ja' ti wʌyi Jesús. Ti queji wen toñel bʌ ic' ya' ti colem joyol bʌ ja'. Che' jini ti queji i bujt'el jini barco ti ja' jintyo bʌbʌq'uen mi sujp'el ochel ti mal ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Che' jini ti queji i p'ixtisañob Jesús. Ti' subeyob: Maestro, muq'uix quejel lac sujp'el ochel ti mal ja', che'ob. Che' jini Jesús ti tyechi. Ti' tiq'ui jini ic' yic'ot jini wits'law bʌ ja'. Che' jini ti lajmi. Ñoj ñʌch'ʌlix ti cʌyle. ");
INSERT INTO ctu76_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Che' jini Jesús ti' sube ajcʌnt'añob i cha'an: ¿Mach'a ba'an mi la' ch'ujbin? Pero wen chʌncolob ti bʌq'uen. Tyoj bʌc'ñʌjel ti yubiyob. Ti' c'ajtibeyob i bʌ: ¿Majchqui wale jini winic mu' bʌ i ñʌch'tisan jini ic' yic'ot ja'? Mi ch'ujbibentyel i t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Che' jini ti c'otiyob ti' lum Gadara bʌ i c'aba' ya' bʌ an ti junxej colem joyol bʌ ja' Galilea bʌ i c'aba'. An ti tyojel jini ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Che' ñac ti loq'ui ti barco Jesús, ti c'oti juntiquil winic loq'uem bʌ ya' ti lum tyʌc'lʌbil bʌ ti xiba. Anix cabʌl ora ti tyʌc'lʌnti ti xibajob. Ma'ix mi' xoje' i pislel. Ma'ix mi chumtyʌl ti yotyot. Ya' chumul jachix ti ch'ujnijibʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Che' ñac ti yilʌ Jesús ti' ñocchoco i bʌ ti yebal i yoc Jesús. Jini xiba ti yʌc'ʌ ti c'am bʌ t'an ti oñel. Ti yʌlʌ: ¿Chuquiyes a wom a wic'otyon Jesús jatyet i Yalobilet bʌ Dios mach'ʌ ba'an i p'isol i ñuclel? Mic c'ajtibeñet ti wocol t'an cha'an mach a tyʌc'lañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Como chʌ'ʌch ti yʌlʌ cha'an poj ujtyel i suben jini xiba cha'an mi loq'uel ti' pusic'al jini winic. Como cabʌl chucul i cha'an jini xiba. Jini quixtyañujob ti' lolon cʌchʌyob ti i yoc ti' c'ʌb ti cadena cha'an i cʌñʌtyan jini winic. Pero jini cadena tyac ti' tyuc'u. Jini xiba ti' wersa xiq'ui majlel ti puts'el ti tyʌquin bʌ joch lum. ");
INSERT INTO ctu76_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús ti' c'ajtibe: ¿Chuquiyes a c'aba'? che' yic'ot. Jini ti' jac'ʌ: J c'aba' Legión, che'en. Chʌ'ʌch ti' jac'ʌ como yonlelob jini xibajob am bʌ yic'ot jini winic. ");
INSERT INTO ctu76_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jini xibajob ti' c'ajtibeyob Jesús cha'an mach xijq'uicob ochel ya' ti ch'en mach'ʌ lac tyajben i yebal i cha'an bʌ xibajob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ya'an cabʌl chityam chʌncol bʌ ti buc'bal ya' ti wits. Jini xibajob ti' wersa c'ajtibeyob Jesús cha'an i yʌq'uen ochel ti chityam. Jesús tsʌ'ʌch i yʌq'ue cha'an mi yochelob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Che' jini, jini xibajob ti loq'uiyob ti i pusic'al winic. Ti ochiyob ti chityam. Che' jini, jini chityam ti majliyob ti ajñel jubel ya' ti queptyʌl. Ti' chocoyob ochel i bʌ ti mal colem joyol bʌ ja'. Ya'i ti' jic'tyʌyob ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Che' ñac ti yilʌ jini ajcʌñʌtya chityam chʌ bʌ ti ujti, ti majliyob ti ajñel ti bʌq'uen. Ti yʌlʌyob ñumel ya' ti lum yic'ot ti otyotyel tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Che' jini, jini quixtyañujob ti loq'uiyob majlel i q'uelob chʌ bʌ ti ujti. Che' ñac ti c'otiyob ya' ba'an Jesús ya' ti' tyajayob jini winic loq'uemix bʌ i cha'an jini xibajob ti' pusic'al. Ya' buchul ya' ti yebal i yoc Jesús. Xojolix i pislel. Tyojix i pusic'al. Ti wen quejiyob ti bʌq'uen jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jini tsa' bʌ yilʌyob ti' cha' subeyob bajche' ti lajmisʌnti che' ñac tyʌc'lʌbil ti xibajob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jin cha'an ti pejtyelel quixtyañu ya' bʌ añob ti Gadara ti queji i wersa c'ajtiben Jesús cha'an mi loq'uel majlel Jesús ya' ba'añob. Como wen añob i bʌq'uen. Che' jini Jesús ti ochi ti barco, ti cha' majli. ");
INSERT INTO ctu76_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jini winic tyʌc'lʌbil bʌ ti xiba tsa' bʌ lajmisʌnti ti' wersa c'ajtibe Jesús cha'an mi majlel yic'ot. Pero Jesús ti' wersa sube cha'an mi cʌytyʌl. Ti' sube: ");
INSERT INTO ctu76_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Sujtyen ti a wotyot. Yom ma' lu' subeñob chʌ bʌ ñuc tyac ti' cha'lebeyet Dios, che' ti yʌlʌ Jesús. Ti majli jini winic. Che' jini tsʌ'ʌch queji i lu' subeñob ti pejtyelelob bajche' ti cotyʌnti ti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Che' ñac ti' cha' c'axi tyʌlel Jesús ti junwej colem joyol bʌ ja' tijicña ti yubiyob jini quixtyañujob cha'an ti cha' c'oti Jesús. Como ti pejtyelelob chʌncol i pijtyañob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Che' jini ti c'oti juntiquil winic Jairo bʌ i c'aba'. An i ye'tyel ya' ti jump'ej templo i cha'an israelob. Ti' nocchoco i bʌ ti yebal yoc Jesús. Ti queji i c'ajtiben Jesús cha'an mi majlel ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Como an cojach bʌ i yixicp'eñal. Doce jabil i cha'an. Yomox sajtyel. Che' chʌncol i majlel Jesús ya' ti i yotyot ti' tsʌcleyob majlel cabʌl quixtyañu. Mux i pets'ob majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ya'an yic'otyob yonlel quixtyañu juntiquil x'ixic. Anix doce jab i quejel ti loq'uel i ch'ich'el. Mach'an mi lajmel ti loq'uel. Ti lu' jili pejtyelel chʌ bʌ an i cha'an i c'ʌn i tyoje' i ts'ʌcʌntyel ba'an yujilo' bʌ ts'acojel. Pero ma'an ti mejli i lajmisañob. ");
INSERT INTO ctu76_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ti' lʌc'ʌ Jesús ya' ti pat jini x'ixic. Ti' tyʌlbe i yoc i pislel. Ti jini jach bʌ ora ti wa' lajmi ti loq'uel i ch'ich'el. ");
INSERT INTO ctu76_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Che' jini Jesús ti' c'ajtibe: ¿Majchqui ti' tyʌlʌyon? che'en. Pero ti pejtyelel ti yʌlʌ: Mach'an majch ti' tyʌlʌyet, che'ob. Che' jini Pedro yic'ot i pi'ʌlob ti yʌlʌyob: Maestro, jini quixtyañujob mi' pets'etyob. ¿Chucoch ma' c'ajtin: ¿Majchqui ti tyʌlʌyon? che'et. ");
INSERT INTO ctu76_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús ti yʌlʌ: An majch ti' tyʌlʌyon como cujil isujm tic lajmisʌ juntiquil tic p'ʌtyʌlel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Che' ñac ti' ña'tyʌ jini x'ixic tsa'ʌch tsictiyi chʌ bʌ ti ujti, tsitsiña ti c'oti ya' ba'an Jesús. Ti' ñocchoco i bʌ ya' ti yebal i yoc Jesús. Ti' lu' subu ti tyojel quixtyañujob chʌ bʌ och ti' tyʌlʌ Jesús yic'ot bajche' ti wa' lajmi ti ora jach. ");
INSERT INTO ctu76_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Che' jini Jesús ti' sube: Calobil, ti lajmiyet cha'an ti a ch'ujbiyon ti a pusic'al. Cucux ti ñʌch'tyʌlel a pusic'al, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chʌncol tyo ti t'an Jesús che' ñac ti c'oti juntiquil ch'oyol bʌ ya' ti yotyot Jairo jini am bʌ i ye'tyel ti i templo israelob. Ti subenti Jairo: Tsa'ix sajti a walobil. Mach a bej mʌctyʌben q'uin jini Maestro, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero che' ñac ti yubi Jesús jini t'an. Ti' sube: Mach a cha'len bʌq'uen. Jin jach ma' ch'ujbiñon ti a pusic'al. Mi quejel i lajmel a walobil, che' yʌlol Jairo. ");
INSERT INTO ctu76_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Che' ñac ti c'oti Jesús ya' ti i yotyot Jairo jin jach ti yʌq'ueyob ochel Pedro yic'ot Jacobo yic'ot Juan yic'ot i tyat i ña' jini xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pejtyelel ya' bʌ añob chʌncolob ti uq'uel. Chʌncol i tyajbeñob i c'aba' xc'alʌl ti uq'uel como sajtyemix. Pero Jesús ti' subeyob: Mach yom mi la' cha'len uq'uel. Mach'an sajtyem ili xc'alʌl. Wʌyʌl jach, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero ti' wajleyob Jesús. Como yujilob isujm sajtyemix jini xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Che' jini Jesús ti' chucbe i c'ʌb jini xc'alʌl. Ti' sube ti c'am bʌ t'an: Xc'alʌl, tyejchenix, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ti cha' cuxtiyi jini xc'alʌl. Ti wa' tyejchi. Jesús ti' subeyob cha'an i yʌq'ueñob i yuch'el jini xc'alʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tyoj bʌc'ñʌjelob i tyat i ña' xc'alʌl. Pero Jesús ti' subeyob cha'an ma'an majch mi' saj subeñob jini tsa' bʌ ujti. ");
INSERT INTO ctu76_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús ti' pʌyʌ tyʌlel ti docejlel ajcʌnt'añob i cha'an. Ti yʌq'ueyob i p'ʌtyʌlel cha'an mi' choc tyacob loq'uel chʌ bʌ tyac bʌ xibajob yic'ot cha'an i lajmisan c'am'an tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ti' xiq'ui i subeñob t'an cha'an bajche' mi' cha'len yumʌl Dios. Ti' subeyob je'el cha'an mi' lajmisañob ajc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesús ti' subeyob: Mach yom chʌ bʌ mi la' ch'ʌme' majlel cha'an ya' ti bij, mi ñʌ'tye'ic, mi la' morralic, mi la' wajic, mi la' tyaq'uinic. Mach yom mi la' ch'ʌme' majlel yambʌ la' bujc, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ti ba'ic jach bʌ otyot mi la' c'otyel ya' mi la' wʌyel jintyo che' mi la' cha' tyejchel majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ya' ti jini lum ba' mach yom i yotsañetla, loq'uenla majlel ya' ti jini lum. Chijcunla loq'uel i ts'ubejñal la' woc cha'an mi' ña'tyañob mach wen bajche' mi' cha'leñob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ti loq'uiyob majlel jini docejob. Ti ñumiyob majlel ti pejtyel saj lum tyac. Ti' subeyob t'an cha'an laj cotyʌntyel. Ti' lajmisʌyob ajc'am'añob ti pejtyelel lum tyac ba' ti ñumiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jini yumʌl Herodes bʌ i c'aba' ti yubi chʌ bʌ ti' cha'le Jesús. Mach yujil isujm Herodes chʌ bʌ yom i pensalin cha'an Jesús. Como an tsa' bʌ i yʌlʌyob ti cha' tyejchi loq'uel Juan ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","An yaño' bʌ tsa' bʌ i yʌlʌyob cha'an Jesús: Jiñʌch Elías. Tsa'ix cha' tyʌli Elías tsa' bʌ i xiq'ui i yʌle' Dios, che'ob. Yaño' bʌ ti yʌlʌyob: Tsa'ix cha' tyejchi loq'uel ba'an sajtyemo' bʌ juntiquil tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes ti yʌlʌ: Joñon ti cʌc'ʌ ti tsepol loq'uel i jol jini Juan. ¿Majchqui che' jini, mu' bʌ i cha'len ñuc tyac bʌ i troñel mi cubin? che'en. Herodes bej yom i q'uele' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Che' ñac ti cha' c'oti ba'an Jesús jini yajcʌbilo' bʌ ajsubt'añob ñumel ti' subeyob Jesús chʌ bʌ tyac ti' cha'leyob. Che' jini Jesús ti' pʌyʌyob majlel ya' ti tyʌquin bʌ joch lum lʌc'ʌl ti lum Betsaida bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero che' ñac ti' ña'tyʌyob quixtyañujob baqui ti majliyob, ti' tsʌcleyob majlel. Jesús ti' pʌyʌyob ba'an. Ti' subeyob t'an cha'an bajche' mi' cha'len yumʌl Dios. Ti' lajmisʌ ajc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Che' iq'uix quejel ti c'oti jini doce yajcʌbil bʌ ajsubt'añob ñumel ba'an Jesús. Ti' subeyob Jesús: Subeñob majlel quixtyañujob cha'an mi majlel ti c'aj oj yic'ot cha'an mi majlel i sʌclan chʌ bʌ mi' c'uxob ya' ti saj lum tyac yic'ot ba' mi' tyajob ti lʌc'ʌl. Como wʌ'i mach'an chʌ bʌ yes an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús ti' subeyob: Jatyetla, yom mi la' wʌq'uen chʌ bʌ mi' c'uxob, che'en. Ti' jac'ʌyob: An jach jo'q'uej lojon c waj yic'ot cha'cojt chʌy. Jin jach mi muq'uic lojon c majlel c mʌmbeñob waj cha'an pejtyelel ili quixtyañujob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Como añʌch che' bajche' cinco mil winicob. Pero Jesús ti' sube ajcʌnt'añob i cha'an: Subeñob buchtyʌl ti jujunmujch' ti cincuenta tyac, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chʌ'ʌch ti' cha'leyob bajche' ti subentiyob. Ti pejtyelel ti buchleyob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Che' jini Jesús ti' ch'ʌmʌ jini jo'q'uej waj yic'ot jini cha'cojt chʌy. Ti' q'uele letsel ti panchan. Ti' sube Dios wocox i yʌlʌ. Che' jini ti' xet'e jini waj. Ti yʌq'ueyob jini ajcʌnt'añob i cha'an cha'an mi' lu' pucbeñob ti pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ti' lu' c'uxuyob ti pejtyelel. Tsa'ix ñaj'ʌyob. Tsa' tyo i lotyoyob doce chiquib i colobal i xejt'il tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Junyaj che' lʌc'ʌl an ajcʌnt'añob i cha'an che' chʌncol ti oración Jesús ti bajñel, Jesús ti queji i c'ajtibeñob: ¿Majchonqui mi yʌlob quixtyañujob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ti' jac'ʌyob: An jini chʌncol bʌ i yʌlob: Juañet tsa' bʌ i yʌc'ʌ ch'ʌm ja', che'ob. Yaño' bʌ mi yʌlob: Elíaset, che'ob. Yaño' bʌ mi yʌlob jatyet juntiquil tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix tsa' bʌ cha' tyejchi loq'uel ba'an sajtyemo' bʌ, che'ob. Che' ti' jac'ʌyob ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Che' jini Jesús ti' c'ajtibeyob: Jixcu jatyetla, ¿majchonqui mi la' wʌle'? che'en. Pedro ti' sube: Jatyet yajcʌbilet bʌ i cha'an Dios mu' bʌ i pejcʌntyel ti Cristo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús ti' wersa tiq'uiyob cha'an mach'an majch mi' subeñob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesús ti' subeyob: Wersa mi quejel c ñusan wocol Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. Ti yʌlʌ je'el cha'an wersa mi quejel i mich'q'uejlel cha'an xñoxob año' bʌ i ye'tyel yic'ot ñuco' bʌ curajob i cha'an israelob yic'ot jini ajcʌntisajob i cha'an oniyix bʌ mandar. Mi quejel i tsʌnsʌntyel pero ti yuxp'ejlel q'uin mi quejel i tyejchel loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ti wi'il Jesús ti' subeyob: Mi an majch yom i tsʌcleñon la' i cʌye' mu' bʌ i bajñel mulan i niq'ui cha'len. La' i ñusan wocol ti jujump'ej q'uin cha'an ti caj chʌncol i ch'ujbiñon aunque mi wersa sajtyel. La' i tsʌcleñon majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Como jini yom bʌ i bajñel lolon cʌñʌtyan i bʌ mi quejel i sʌt'e i cuxtyʌlel mach'ʌ yujil jilel pero jini mu' bʌ i yʌc' i bʌ cha'añon mi quejel i cʌñʌtyʌntyel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Chutyoqui i c'ʌjnibal i cha'an quixtyañu mi' lolon ganarin pejtyelel am bʌ ti ili mulawil pero mi mach'an ti' tyaja i cuxtyʌlel mach'ʌ yujil jilel? ");
INSERT INTO ctu76_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mi an majch mi' quisniñon yic'ot che' mi' quisnibeñon ili c t'an, joñon je'el i Pi'ʌlon bʌ Quixtyañujob mi quej c quisnin ili quixtyañu ya' bʌ mic tyʌlel ti i ñuclel c Tyat yic'ot ch'ujul bʌ ajtroñelob i cha'an Dios ch'oyol bʌ ti panchan cha'an c cha'len yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mic subeñetla, melel wʌ' añob mach'ʌ ba'an mi quejel i sajtyelob jintyo mi' ñaxan ilañob che' mi' cha'len yumʌl Dios, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Che' tsa'ix ñumi che' bajche' ocho q'uin i yʌlbal pejtyelel jini t'an, ti letsi majlel Jesús ti jump'ej wits cha'an mi' cha'len oración. Ti' pʌyʌ majlel Pedro, Jacobo yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Che' chʌncol ti oración Jesús, ti yʌjni i ñi' i wut Jesús ti yilʌyob. Ñoj sʌsʌc i pisil. Lemlaw ti majli. ");
INSERT INTO ctu76_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Che' jini ti tsictiyi cha'tiquil winic. Chʌncolob ti t'an yic'ot Jesús. Jiñʌch Moisés yic'ot Elías jini cha'tiquil. ");
INSERT INTO ctu76_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ti tsictiyi ti sutyʌlel jini uxtiquilob wen c'otyajax lemlaw. Chʌncolob ti t'an bajche' mi quejel i sajtyel Jesús ya' ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Aunque wen yom wʌyel Pedro yic'ot i pi'ʌlob, p'ixilob ti cʌyleyob. Ti yilʌyob lemlaw bʌ i c'ʌc'al Jesús. Ti yilʌ je'el jini cha'tiquil ya' bʌ an yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Che' ñac ñajtix i majlelob ba'an Jesús jini winicob, Pedro ti yʌlʌ: Maestro, wen c'otyajax wʌ' añonla wʌ'wʌ'i. La' c mele' lojon uxp'ej lechi'pat. Jump'ej a cha'an. Jump'ej i cha'an Moisés yic'ot jump'ej i cha'an Elías. Che' ti yʌlʌ Pedro. Pero mach yoque yujil isujm Pedro chʌ bʌ chʌncol i yʌle'. ");
INSERT INTO ctu76_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Che' chʌncol tyo ti t'an Pedro ti wa' tyʌli tyocal tsa' bʌ i mosoyob. Añob i bʌq'uen cha'an añob ti mal tyocal. ");
INSERT INTO ctu76_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Che' jini ti yubiyob ajt'an ya' ti mal tyocal tsa' bʌ i yʌlʌ: Jiñʌch p'untyʌbil bʌ calobil. Ñʌch'tyʌbenla i t'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Che' ñac ti ujti jini ajt'an ti yilʌyob i bajñel jach ya'an Jesús. Ñʌch'ʌl ti cʌyleyob ajcʌnt'añob i cha'an Jesús. Mach'an majch ti' subeyob jini tsa' bʌ i yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ti yijc'ʌlel che' ñac ti jubiyob tyʌlel ti wits cabʌl quixtyañu ti majliyob i tyaje' tyʌlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Che' jini, juntiquil winic ya' bʌ an yic'otyob ti yʌlʌ ti c'am bʌ t'an: Maestro, awocolic q'uelbeñon calobil como cojach bʌ calobil. ");
INSERT INTO ctu76_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jini xiba mi' chuque'. Mi yʌq'uen i cha'len oñel. Mi yʌq'uen ti jits'cuyel. Mi loq'uel i lojc i ti'. Jini xiba mi' tyʌc'lan. Mach yom i cha' cʌye'. ");
INSERT INTO ctu76_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Tic wersa c'ajtibeyob jini mu' bʌ i cʌmbeñetyob a t'an cha'an mi' choque' loq'uel pero mach'an ti mejli i chocob loq'uel, che' ti yʌlʌ jini winic. ");
INSERT INTO ctu76_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús ti' subeyob jini quixtyañujob ya' bʌ añob: Max tyo ba'an majch wʌ' bʌ an ti mulawil mi' ch'ujbiñon yubil cha'an tyʌlemon ti Dios. Max tyo wen mi' cha'len. ¿Jayp'ej tyoqui q'uin wersa yom wʌ' añon quic'otyetla? ¿Jayp'ej tyoqui q'uin ch'ujbi j cuchbeñetla i tsʌtslel la' pusic'al? Pʌyʌ tyʌlel a walobil wʌ' ba'añon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Che' ñac ti' lʌc'ʌ Jesús jini alob, jini xiba ti' choco jubel ti lum. Ti yʌc'ʌ ti cha' jits'cuyel. Pero Jesús ti' tiq'ui jini xiba. Ti' lajmisʌ jini alob. Ti' cha' sube i pʌy i tyat. ");
INSERT INTO ctu76_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Che' ñac lu' tsijc' che'ob i pusic'al ti pejtyelel cha'an bajche' ti' cha'le lajmisaya Jesús, ti' sube ajcʌnt'añob i cha'an: ");
INSERT INTO ctu76_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Wen ñʌch'tyanla iliyi: Mach yom ñajayic la' cha'an. Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel cʌjq'uel ti i c'ʌb winicob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero jini ajcʌn'tañob i cha'an mach'an ti' ña'tyʌyob chʌ bʌ chʌncol i yʌle'. Mach'an ti aq'uenti i ña'tyañob. Ti' bʌc'ñʌyob i c'ajtibeñob Jesús chʌ bʌ yes i sujmlel jini tsa' bʌ i yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Che' jini, jini ajcʌnt'añob i cha'an Jesús ti queji i cʌlʌx pejcañob i bʌ cha'an majchqui más ñuc mi quejel i q'uejlel. ");
INSERT INTO ctu76_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesús yujil isujm chʌ bʌ chʌncol i pensaliñob. Che' jini ti' pʌyʌ tyʌlel ti i t'ejl juntiquil alob ya' ba'an. ");
INSERT INTO ctu76_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jesús ti' subeyob: Jini mu' bʌ i pʌye' ochel alʌ cha'an mi' ña'tyañon chʌncox i pʌyon ochel yubil. Jini mu' bʌ i pʌyon ochel chʌncol i pʌy ochel je'el jini tsa' bʌ i chocoyon tyʌlel, che' ti yʌlʌ Jesús. Jini mu' bʌ i más ju'san i bʌ ti la' tyojlel jiñʌch más am bʌ i ñuclel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan ti yʌlʌ: Maestro, ti lojon quilʌ juntiquil winic mu' bʌ i choque' loq'uel xibajob. A c'aba' mi' c'ʌn. Ti lojon c tiq'ui como mach'an mi' tsʌcleñonla ti xʌmbal, che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús ti' sube: Mach la' tiq'ue'. Jini mach'ʌ ba'an mi' contrajiñonla chʌncox i cotyañonla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Che' lʌc'ʌlix i yorojlel che' mi quejel i pʌjyel letsel ti panchan Jesús ti jump'ej jach i pusic'al ti queji i majlel ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús ti' choco majlel winicob che' max tyo ti c'oti Jesús ti jump'ej saj lum ya' ti pañimil Samaria bʌ i c'aba' cha'an mi' sajcʌbeñob ba' mi quejel ti jijlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero jini año' bʌ ti Samaria mach yom i pʌyob ochel Jesús como tsiquil majlel muc' Jesús ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Che' ñac ti' ña'tyʌ Jacobo yic'ot Juan jini ajcʌnt'año' bʌ i cha'an Jesús cha'an mach'an ti' pʌyʌyob ochel Jesús jini año' bʌ ti Samaria ti yʌlʌyob: C Yum, ¿awom ba mic xiq'ue' lojon cha'an mi jubel c'ajc ti chan cha'an mi jilelob che' bajche' ti' cha'le Elías tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Che' jini Jesús ti' ch'uj q'ueleyob. Ti' tiq'uiyob. Ti' subeyob: Mach'an mi la' ña'tyan bajche' añetla ti la' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Como Joñon i Pi'ʌlon bʌ Quixtyañujob mach'an ti tyʌliyon cha'an quisan quixtyañujob pero ti tyʌliyon cha'an j cotyañob, che'en. Che' jini ti majliyob ti yambʌ saj lum. ");
INSERT INTO ctu76_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Che' chʌncol ti xʌmbal majlel ya' ti bij ya'an juntiquil winic tsa' bʌ i sube Jesús: C Yum, com c tsʌcleñet majlel ba'ic jach ma' majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús ti' jac'ʌ: An i met xwax. An i c'u' xma'tye'mut. Pero ma'ix c bajñel ajnib ba' mic tyots'tyʌl Joñon i Pi'ʌlon bʌ Quixtyañujob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús ti' sube juntiquil yambʌ: Tsʌcleñon majlel, che'en. Pero ti' jac'ʌ: C Yum, la' tyo c ñaxan pijtyan jintyo ba' bʌ ora mic ch'ujñan c tyat, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús ti' jac'ʌ: La' i ch'ujñan sajtyemo' bʌ jini mach'ʌ ba'an mi' ña'tyañob. Pero cucux ti subt'an. Subu majlel jini t'an cha'an bajche' mi' cha'len yumʌl Dios, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Che' jini yambʌ ti queji i suben Jesús: C Yum, com c tsʌcleñet majlel. Pero la' tyo c ñaxan majlel c sub c bʌ ba'an c pi'ʌlob ti cotyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús ti' sube: Jini mu' bʌ i lolon otsan i c'ʌb ti pic'o' lum cha'an i tyop'e' majlel lum yubil pero ti wi'il mi' cha' bej q'uele' ti i pat ma'ix i c'ʌjnibal cha'an i cha'liben i troñel Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Che' ñac ujtyem i yʌl tyac iliyi lac Yum ti yajcʌ yambʌ setentajob. Ti' xiq'uiyob majlel ti pejtyelel jini lum tyac yic'ot ajchumtyʌl tyac ba' mi quejel i c'otyel Jesús je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jesús ti' subeyob jini ajcʌnt'añob i cha'an: Melelʌch an cabʌl c'ajbal yubil pero ma'ix cabʌl ajtroñel, che'en. Che' ti yʌlʌ ti lajoñel che' an cabʌl yom bʌ i cotyʌntyel. Pero ma'ix cabʌl ajsubt'añob. Jesús ti yʌlʌ: Jin cha'an c'ajtibenla i Yum c'ajbal cha'an i choque' majlel ajtroñelob ti c'ajbal, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jesús ti yʌlʌ: Cucucla. Mic choquetla majlel ti subt'an che' bajche' ovejajetla joyol bʌ ti simaron bʌ animal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mach yom mi la' ch'ʌme' majlel mi la' morralic, mi yajnibic la' tyaq'uin, mi yanic bʌ la' zapatos. Mach yom mi junticlec cabʌl jalijel la' wʌq'uen saludo tyac ti bij. ");
INSERT INTO ctu76_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Che' mi la' wochel ti jump'ej otyot mi la' wʌq'uen saludos. Mi la' wʌle': La' tyʌlic i ñʌch'tyʌlel i pusic'al ili añob ti ili otyot, che'etla, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jesús ti yʌlʌ: Mi ya'an quixtyañu yom bʌ i q'ueletla mi quejel i tyaje' i ñʌch'tyʌlel i pusic'al. Pero mi mach yom i yubin la' t'an ma'ix mi yʌq'uentyel i ñʌch'tyʌlel i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cʌylenla ya' ti otyot. C'uxula, japʌla chʌ bʌ jach yes mi la' pʌs'entyel. Jini ajtroñel añʌch cha'an i yʌq'uentyel i yuch'el cha'an i tyojol yubil. Mach yom mi la' c'axel ti yambʌ otyot cha'an jijliquetla. ");
INSERT INTO ctu76_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Che' mi la' c'otyel ti jump'ej lum ba' mi' pʌyetla ochel, c'uxula chʌ bʌ mi yʌq'ueñetla. ");
INSERT INTO ctu76_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Lajmisanla jini ajc'am'añob ya' bʌ añob ti jini lum. Subenla: I yorojlelix wale che' yom i cha'len yumʌl Dios wʌ' ba' añetla, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero mi ti c'otiyetla ti jump'ej lum ba' mach yom i q'ueletla loq'uenla ya' ti calle. Subenla: ");
INSERT INTO ctu76_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Jinic tyo i lumil lojon coc i cha'an ili lum mic chijcun lojon loq'uel cha'an mi la' ña'tyan mach wen bajche' ti la' cha'le. Pero ña'tyanla yomox i cha'len yumʌl Dios wʌ' ba'añetla, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mic subeñetla che' ti yorojlel melojel más wocol mi quejel i yʌjq'uel ti xot'mulil ili quixtyañujob che' bajche' jini año' bʌ ti lum Sodoma bʌ i c'aba', che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","P'ump'uñetla ya' añet bʌ la ya' ti lum Corazín bʌ i c'aba'. P'ump'uñetla ya' añet bʌ la ya' ti lum Betsaida bʌ i c'aba' cha'an wocol mi quejel la' wubin. Tsa'ic pʌs'entiyob ti ñoj oniyix ya' bʌ añob ti lum Tiro yic'ot Sidón jini ñuc bʌ c p'ʌtyʌlel tsa' bʌ c cha'le wʌ' ba' añetla tsa'ix i q'uextyʌyob i pusic'al i cʌyob i mul. Tsa'ix i xojoyob i'ic' bʌ pislel. Tsa'ix i mujluyob i bʌ ti tyan cha'an i señʌjlel i ch'ʌjyemlel cha'an i mul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero ti i yorojlel melojel mi quejel la' más aq'uentyel más wocol bʌ xot'mulil bajche' ti' ñusʌyob jini año' bʌ ti Tiro yic'ot Sidón. ");
INSERT INTO ctu76_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Jixcu añet bʌ la ti lum Capernaum bʌ i c'aba' chʌncol la' lolon ña'tyan mi quejel la' q'uejlel ti ñuc c'ʌlʌ ti chan. Mi quejel la' majlel ba' mi majlel i ñusan wocol cha'an ti caj i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jini mu' bʌ i ñʌch'tyʌbeñetla la' t'an mi ñʌch'tyʌbeñon c t'an je'el. Jini mu' bʌ i p'ajetla, mi' p'ajon je'el. Jini mu' bʌ i p'ajon, mi' p'aje' Dios tsa' bʌ i chocoyon tyʌlel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tijicñayob ti cha' c'otiyob ba'an Jesús jini setenta ajsubt'añob. Ti yʌlʌyob: C Yum, cha'an ti caj a c'aba' jinic tyo xibajob ti' ch'ujbibeyon lojon c t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús ti yʌlʌ: Chʌ'ʌchi. Ti quilʌ bajche' ti yajli Satanás che' bajche' i c'ʌc'al chajc. ");
INSERT INTO ctu76_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tsa'ix cʌq'ueyetla la' p'ʌtyʌlel cha'an la' pets' tyeq'ue' lucum yic'ot tya' chʌb yic'ot cha'an mi la' jotben i p'ʌtyʌlel laj contra. Mach'an chʌ bʌ mi quejel i tyumbeñetla. ");
INSERT INTO ctu76_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero mach jin jach yom c'ajacña la' woj cha'an mi' ch'ujbibeñetla la' t'an jini xibajob pero yom c'ajacña la' woj je'el cha'an ts'ijbubil la' c'aba' ya' ti panchan, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ti jim bʌ ora wen c'ajacña yoj ti yubi Jesús cha'an ti Ch'ujul bʌ i Ch'ujlel Dios. Ti yʌlʌ: Mic subeñet a ñuclel c Tyat, i yumet panchan yic'ot mulawil como ti a wʌq'ue i ch'ʌm'eñob i sujmlel jini mu' bʌ yajñel bajche' alʌl mach'ʌ ba'an mi' q'uel i bʌ ti ñuc. Pero mach'an ti a wʌq'ue i ch'ʌm'en i sujmlel jini am bʌ cabʌl i ña'tyʌbal i cha'an jach bʌ mulawil yic'ot wen yujilo' bʌ mi' lolon ña'tyañob. Chʌ'ʌch wen, c Tyat, como chʌ'ʌch yom a pusic'al. Che' ti' cha'le oración Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesús ti yʌlʌ: Tsa'ix lu' aq'uentiyon tic wenta tic Tyat pejtyelel chʌ bʌ tyac an. Ma'an majch mi' yoque cʌñon mi i Yalobilon Dios. Jini jach i bajñel Dios mi' yoque cʌñon cha'an i Yalobiloñʌch. Mach'an majch mi' cʌñe' majchqui jini c Tyat, joñon c bajñel jach mij cʌñe' c Tyat yic'ot pejtyelel com bʌ cʌq'uen i cʌñe', che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Che' jini ti' q'uele jini ajcʌnt'añob i cha'an. Che' jini ti bajñel subeyob: C'ajacñayob i yoj jini mu' bʌ yoque ilañob jini mu' bʌ la' wilan. ");
INSERT INTO ctu76_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Como mic subeñetla cabʌl jini tsa' bʌ i xiq'ui i yʌle' Dios yic'ot yumʌlob ti ñoj oniyix yomob i q'uelob jini chʌncol bʌ la' wilan. Pero mach'an ti yilʌyob. Yom i yubiñob jini chʌncol bʌ la' wubin pero mach'an ti yubiyob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Che' jini juntiquil ajcʌntisa cha'an mandar i cha'an israelob ti majli i pejcan Jesús cha'an i yilpusic'len Jesús. Ti' c'ajtibe: Maestro, ¿chuqui yom mic cha'len cha'an mic tyaje' j cuxtyʌlel mach'ʌ yujil jilel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús ti' jac'ʌ: ¿Bajche' ts'ijbubil ti' mandar Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jini ajcʌntisa cha'an i mandar israelob ti' jac'ʌ: P'untyan la' Yum jini la' Dios ti pejtyelel la' pusic'al, yic'ot ti pejtyelel la' ch'ujlel yic'ot ti pejtyelel la' p'ʌtyʌlel yic'ot ti pejtyelel la' ña'tyʌbal. P'untyan la' pi'ʌlob che' lajal bajche' mi la' bajñel p'untyan la' bʌ. Che' ti' jac'ʌ jini ajcʌntisa. ");
INSERT INTO ctu76_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Che' jini Jesús ti' sube: Weñʌch bajche' ti a jac'ʌ. Mi chʌ'ʌch ma' cha'len mi quejel a tyaje' a cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero jini ajcʌntisa cha'an mandar yom weñʌch mi yubintyel ti Jesús cha'an jini tsa' bʌ i lolon c'ajtibe. Jin cha'an ti' sube Jesús: ¿Majchqui jini c pi'ʌlob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Che' jini Jesús ti' sube ti lajoñel: An juntiquil israel bʌ winic tsa' bʌ loq'ui majlel ti Jerusalén cha'an i jubel majlel ti Jericó. Ti chujqui ti ajxujch'ob. Ti' lu' chilbeyob chʌ bʌ an i cha'an. Jinic tyo i pislel ti' chilbeyob. Ti' lowoyob. Ti majliyob jini ajxujch'ob. Yomox sajtyel ti' cʌyʌyob jini winic ya' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Che' jini ti queji i ñumel majlel juntiquil cura i cha'an israelob ya' ti bij. Pero che' ñac ti yilʌ jini lojwen bʌ ti ñumi majlel ti junxej bij. ");
INSERT INTO ctu76_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Che' je'el ti ñumi juntiquil levita mu' bʌ i cotyan curajob ti troñel ti i colem templo israelob ti ñoj oniyix. Che' ñac ti c'oti ba'an jini lojwen bʌ ti bij tsa' jach ñumi ti junxej bij je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero juntiquil winic ch'oyol ti Samaria ya' majlel je'el ya' ti bij. Che' ñac ti yilʌ jini lojwen bʌ ti' wen p'untyʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Che' jini ti' lʌc'ʌ jini lojwen bʌ. Ti' ts'ʌcʌbe i lojwel tyac ti aceite yic'ot vino. Ti' tyep'e i lojwel tyac. Che' jini ti' c'ʌchchoco. Ti' pʌyʌ majlel ba' mi c'aj i yoj. Ya' ti' cʌñʌtyʌ ya'ya'i. ");
INSERT INTO ctu76_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ti yijc'ʌlel che' muq'uix quejel i majlel jini winic ch'oyol bʌ ti Samaria ti' loc'sʌ cha'wejch i tyaq'uin. Ti yʌq'ue i yum jini otyot. Ti' sube: Cʌñʌtyʌbeñon ili winic. Mi más yom tyo i tyojol mu' tyo c cha' tyojbeñet che' mic cha' tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús ti yʌlʌ: ¿Bajche' ma' wʌl, che' jini, majchqui ili uxtiquil tsa' bʌ i pʌsʌ i bʌ ti i pi'ʌl tsa' bʌ tyʌc'lenti ti ajxujch'ob? che' ti' c'ajtibe Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jini ajcʌntisa cha'an i mandar cha'an israelob ti yʌlʌ: Jini tsa' bʌ i cha'le p'untyaya, che'en. Che' jini Jesús ti' sube: Cucux, chʌ'ʌch ma' cha'len p'untyaya je'el. Che' ti subenti. ");
INSERT INTO ctu76_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ti bej majli ti bij. Ti c'oti ti jump'ej saj lum. Ya'an juntiquil x'ixic Marta bʌ i c'aba' tsa' bʌ i pʌyʌ ochel ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","An i yijts'in Marta, María bʌ i c'aba'. María ti buchle ti yebal yoc Jesús cha'an i ñʌch'tyʌben i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero an cabʌl i pensal Marta cha'an i troñel ti yotyot. Ti tyʌli ba'an Jesús. Ti yʌlʌ: C Yum, ¿mach'a ba'an ma' q'uele' bajche' mi' bajñel cʌyon tic troñel quijts'in? Suben cha'an i cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús ti' jac'ʌ: Marta, an cabʌl a pensal cha'an jach a troñel. ");
INSERT INTO ctu76_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","An jach junchajb más c'ʌjnibal bʌ. María ti yajcʌ jini más wen bʌ. Mach'an mi quejel i chilbentyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Junyajlel che' ujtyel i cha'len oración Jesús juntiquil ajcʌnt'an i cha'an ti' sube: C Yum, cʌntisañon lojon ti oración che' bajche' Juan ti' cʌntisʌ ti oración ajcʌnt'añob i cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús ti' subeyob: Che' mi la' pejcan Dios subenla: C Tyat lojon ya' bʌ añet ti panchan, la' ch'ujutisʌntiquet. La' yumintiquet. La' mejlic chʌ bʌ a wom wʌ' ti mulawil che' bajche' mi mejlel chʌ bʌ a wom ya' ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Aq'ueñon lojon c waj wale jasʌl bʌ ili q'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ñusʌbeñon lojon c mul como mi lojon c ñusʌben i mul lojon c pi'ʌlob je'el. Cʌñʌtyañon lojon cha'an mach cac' lojon c pʌyol ti mulil, coloyon lojon ti i p'ʌtyʌlel jini mach bʌ wen. Che' ti' cʌntisayob Jesús ti oración. ");
INSERT INTO ctu76_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús ti' subeyob je'el. La' lac poj al: An juntiquil la' pi'ʌl mu' bʌ i c'otyel ti xin ac'bʌlel ti la' wotyot. Mi yʌle': Pi'ʌl, poj aq'ueñon ti q'uex uxq'uej waj. ");
INSERT INTO ctu76_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Como ujtyel i julel ti cotyot cʌñʌl bʌ c pi'ʌl. Pero ma'an chʌ bʌ mi cʌq'uen i c'uxe', che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mi lac poj al: Jini am bʌ ti mal otyot mi quejel i jaq'ue': Mach com a tyʌc'lañon. Ñup'ulix i ti' cotyot. Wʌyʌl quic'ot calobilob. Mach ch'ujbi c tyejchel cʌq'ueñet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mic subeñetla aunque mach yom tyejchel i yʌq'uen waj cha'an ti caj i pi'ʌlʌch pero muc'ʌch i wersa tyejchel i yʌq'uen cha'an mach i chʌc pejcan. Mi quejel i lu' yʌq'uen bajche' c'amel yom. ");
INSERT INTO ctu76_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jin cha'an mic subeñetla: Bej c'ajtibenla Dios chʌ bʌ yom la' cha'an. Mi quejel i yʌq'ueñetla. Bej sʌclanla. Mi quejel la' tyaje'. Bej pejcanla Dios. Mi quejel la' jam'entyel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Como jini mu' bʌ i c'ajtin mi quejel i yʌq'uentyel. Jini mu' bʌ i sʌclan mi quejel i tyaje'. Jini mu' bʌ i pejcan Dios che' bajche' mi i yum otyot mi quejel i jam'entyel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Am ba juntiquiletla tyatyʌlet bʌ la mu' bʌ quejel la' wʌq'uen la' walobil tyun che' mi i c'ajtin waj? ¿Mu' ba quejel la' wʌq'uen lucum che' mi' c'ajtin chʌy? ");
INSERT INTO ctu76_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O mu' ba la' wʌq'uen la' walobil tya'chʌb mi ti' c'ajti tyumut? ");
INSERT INTO ctu76_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Aunque simaroñetla pero la' wujil la' wʌq'uen la' walobil wen tyac bʌ. Más tyo la' Tyat am bʌ ti panchan más yujil i yʌq'uen Ch'ujul bʌ i Ch'ujlel jini mu' bʌ i c'ajtin. ");
INSERT INTO ctu76_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús ti' choco loq'uel xiba ti juntiquil winic tsa' bʌ yʌc'ʌ ti uma'iyel xiba. Che' ñac tsa'ix chojqui loq'uel jini xiba ti cha' queji ti t'an jini winic. Tyoj bʌc'ñʌjel ti yilʌ jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero an jini tsa' bʌ i yʌlʌyob: Ili winic mi' choque' loq'uel xibajob ti' p'ʌtyʌlel jach i yajaw xiba mu' bʌ i pejcʌntyel ti Beelzebú. Che' ti lolon alʌyob jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yaño' bʌ cha'an yom i yilpusic'len Jesús ti' lolon c'ajtibeyob cha'an mi' pʌse' Jesús i señʌjlel i p'ʌtyʌlel loq'uem ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús ti' ña'tyʌ chʌ bʌ chʌncol i pensaliñob ti' pusic'al. Ti' subeyob: Mi ti queji i t'oxob i bʌ año' bʌ ti wenta ba'ic jach bʌ yumʌl mi ti queji i periyaliñob i bʌ mi quej i lajmisʌntyel ye'tyel yumʌl. Mi ti queji i periyaliñob i bʌ año' bʌ ti jump'ej otyot mi' t'oxob i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Chʌ'ʌch je'el Satanás mi ti bajñel periyaliyob i bʌ ¿bajche'qui ch'ujbi i yajñel ti p'ʌtyʌl mi la' wʌl? Chʌ'ʌch chʌncol cʌle' cha'an chʌncol la' lolon ale' ti' p'ʌtyʌlel Beelzebú mic choque' loq'uel xibajob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jesús ti yʌlʌ je'el: Mi ti' p'ʌtyʌlel xiba mic choque' loq'uel xibajob mi la' wʌl, ¿baqui mi' tyaje' i p'ʌtyʌlel la' pi'ʌlob i choque' loq'uel xibajob, mi la' wʌl? Jin cha'an la' pi'ʌlob mi quejel i tsictisan la' ñajʌyel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero cha'an ti' p'ʌtyʌlel Dios mic choque' loq'uel xibajob. Jin cha'an tsiquil chʌncol ti yumintyel Dios wʌ' ba' añetla. ");
INSERT INTO ctu76_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Che' mi' wen cʌñʌtyan i yotyot juntiquil p'ʌtyʌl bʌ am bʌ i julonib mach'an mi tyʌc'lʌbentyel chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero mi ti tyʌli juntiquil winic más p'ʌtyʌl bʌ mi ti' chucu i yum otyot muc'ʌch i lu' chilben i julonib tyac tsa' bʌ i lolon pensali i c'ʌn i cotyan i bʌ. Mi chilbentyel chʌ bʌ an i cha'an. Mi lu' puque' jini tsa' bʌ i ch'ʌmʌ, che'en. Chʌ'ʌch ti laja Jesús i p'ʌtyʌlel ti' contra Satanás. ");
INSERT INTO ctu76_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jini mach bʌ yom i q'uelon mi' contrajiñon. Jini mach'ʌ ba'an mi' cha'len troñel quic'ot chʌncol jach i pucxibeñon c troñel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: Che' mi loq'uel xiba ti' pusic'al quixtyañu mi' cha'len xʌmbal ti tyʌquin lum tyac. Mi' bej sajcan majlel ba' mi' cha' ochel cha'an i c'aje' i yoj. Che' mach'an mi' tyaje' yambʌ yajnib mi' pensalin: Mi quejel c cha' majlel ti cajnib ba' ti loq'uiyon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Che' mi cha' c'otyel xiba mi' tyaje' jini quixtyañu ba' ti loq'ui. Che' bajche' wen misubil bʌ otyot i pusic'al. Jocholix. Tyojix an yilal jini quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Che' jini mi majlel jini xiba i pʌye' tyʌlel yambʌ siete xibajob más simaron bʌ. Mi lu' ochel ti chumtyʌl ti' pusic'al jini quixtyañu. Ti wi'il más p'ump'um mi quejel i yajñel jini quixtyañu bajche' ti ñaxan. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Che' chʌncol tyo i yʌle' tyac ili t'an Jesús ya' ba'an junmujch' quixtyañujob ya'an juntiquil x'ixic tsa' bʌ queji ti c'am bʌ t'an. Ti yʌlʌ: C'ajcaña i yoj jini x'ixic tsa' bʌ i cʌñʌtyʌyet che' max tyo ti ch'ocʌyet yic'ot tsa' bʌ i tsu'sʌyet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús ti' sube: Pero más c'ajacñayob i yoj jini mu' bʌ i ñʌch'tyʌbeñob i t'an Dios mu' bʌ i ch'ujbiben i t'an, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti' much'quiyob i bʌ quixtyañujob ya' ba'an Jesús. Jesús ti queji i pejcañob. Ti' subeyob: Jini quixtyañujob año' bʌ wale tsʌtsob i pusic'al. Mi' lolon c'ajtin i q'uelob i señʌjlel c p'ʌtyʌlel; pero mach'an mi quejel i pʌs'entyel yambʌ seña. Jini jach mi pʌs'entyel seña che' bajche' ti' pʌsʌ Jonás tsa' bʌ i xiq'ui i yʌle' Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Che' bajche' ti ajni Jonás ti jump'ej seña ba'an jini quixtyañujob año' bʌ ti Nínive ti ñoj oniyix cha'an bajche' ti ujti yic'ot Jonás. Chʌ'ʌch je'el Joñon i Pi'ʌlon Quixtyañujob mi quejel cajñel ti jump'ej seña ba'an ili quixtyañujob año' bʌ wale cha'an bajche' mi quejel cujtyel je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ti yorojlel melojel ti' tyojlel Dios mi quejel i melob i bʌ quixtyañujob año' bʌ wale. Jini x'ixic bʌ yumʌl ya' ti Sur mi quejel i tsictisan añobʌch i mul. Como jini x'ixic ti tyʌli ti wen ñajt bʌ pañimil cha'an i ñʌch'tyan i ña'tyʌbal jini yumʌl Salomón bʌ i c'aba'. Ti' ch'ujbi. Pero más ñucon bajche' Salomón. Pero ma'ix mi' cʌyob i mul quixtyañujob año' bʌ wale. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jini tsa' bʌ chumleyob ti Nínive mi quejel ti wa'tyʌl ti yorojlel melojel ti' tyojlel Dios che' mi' melob i bʌ quixtyañujob año' bʌ wale iliyi. Mi quejel i subob i mul. Como jini año' bʌ ti Nínive ti' q'uextyʌyob i pensal i cʌyob i mul che' ñac Jonás ti' subeyob i t'an Dios. Ti' ch'ujbibeyob. Pero wʌ' añon más ñucon bajche' Jonás pero ma'ix mi' cʌyob i mul ili quixtyañujob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Mach'an majch mi' ts'ʌpe' cas cha'an jach i muque' ba' mach tsiquil i c'ʌc'al. Mach'an mi yʌc' ti yebal caja pero mi' joc'chocon ti chan cha'an tsiquil i c'ʌc'al jini mu' bʌ ochel ti otyot. ");
INSERT INTO ctu76_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jini mu' bʌ i ch'ʌm'en isujm mu' bʌ j cʌntisan chʌ'ʌch an bajche' am bʌ wen bʌ i wut yubil. Weñʌch mi yajñel como weñʌch i wut cha'an i q'uele' i sʌclel. Pero jini mach'ʌ wen i wut mi yajñel ti ic't'ojñal che' bajche' mach'an mi yilan i sʌclel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Xuc'ulet cha'an a wajñel ti uts a wic'ot Dios como mi mach utset a wic'ot Dios, che' bajche' chʌncol a wajñel ti ic't'ojñal yubil. ");
INSERT INTO ctu76_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mi chʌncol la' wen ch'ʌm'en isujm jini j cʌntisa mi mach i sajlic i yic'lel la' pusic'al chʌncol la' wajñel ti sʌclel che' bajche' mi chʌncol la' wajñel ti i sʌclel cas, yubil. ");
INSERT INTO ctu76_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Che' ñac ti ujti ti t'an Jesús juntiquil israel mu' bʌ i pejcʌntyel ti fariseo cha'an bajche' mi' ch'ujbin, ti' pʌyʌ Jesús ti uch'el ti yotyot. Ti ochi Jesús ti yotyot. Ti buchle ya' ba'an mesa. ");
INSERT INTO ctu76_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tyoj bʌc'ñʌjel ti yilʌ jini fariseo che' ñac ti yilʌ mach'an ti' ñaxan wen poco i c'ʌb Jesús che' bajche' mi' cha'leñob israelob che' mi quejel i cha'leñob uch'el cha'an ti caj bajche' mi' lolon ch'ujbiñob. ");
INSERT INTO ctu76_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero lac Yum ti yʌlʌ: Fariseojet bʌ la mi la' wen poque' i pat vaso yic'ot ch'ejew cha'an ti caj bajche' mi la' lolon ch'ujbin. Pero la' pusic'al but'ul ti mach'ʌ wen tyac cha'an ti caj la' xujch' yic'ot cha'an ti la' simaronlel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mach'an mi la' ña'tyan. ¿Mach'a ba'an mi la' ña'tyan jini tsa' i mele i bʌc'tyal quixtyañu ti' mele je'el i pusic'al? ");
INSERT INTO ctu76_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pero yom mi la' ts'itya' aq'uen p'ump'uño' bʌ ti chʌ bʌ an la' cha'an. Che' jini sʌc cha'añetla pejtyelel chʌ bʌ tyac an. ");
INSERT INTO ctu76_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","P'ump'uñetla fariseojet bʌ la che' bajche' mi quejel la' ñusan wocol. Mi la' aq'uen Dios jujunchajp loq'uem bʌ ti diez jini pimel menta bʌ i c'aba' yic'ot ruda yic'ot yan tyac bʌ pimel. Pero mach'an mi la' cha'len tyoj bʌ melojel. Mach'an mi la' p'untyan Dios. Yom mi la' wʌq'uen jujunchajp loq'uem bʌ ti diez tyac ofrenda pero yom mi la' cha'len chʌ bʌ wen je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","P'ump'uñetla fariseojet bʌ la che' bajche' mi quejel la' ñusan wocol. Mi la' mulan la' yajcan buchlibʌl ba' mi buchtyʌl año' bʌ i ye'tyel cha'an mi' q'ueletla ti ñuc ti templo tyac i cha'an israelob. La' wom mi la' saludalintyel ti calle tyac che' bajche' mi an la' ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","P'ump'uñetla ajcʌntisajet bʌ la cha'an mandar yic'ot fariseojet bʌ la che' bajche' wocol mi quejel la' ñusan. Cha'chajp la' pensal. Che' jini ma'ix mi' pensalin quixtyañujob bajche' yoque añetla. Chʌ'ʌch añetla bajche' muconibʌl yubil mach'ʌ ba'an tsiquil tyac. Quixtyañujob mi ñumel ti pam como mach'an mi' ña'tyan mi ya'an, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Che' jini juntiquil ajcʌntisa cha'an mandar ti yʌlʌ: Maestro, che' ma' wʌle' che' bajche' jini ma' tyajon lojon ti t'an je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús ti' sube: P'ump'uñetla ajcʌntisajet bʌ la cha'an mandar je'el che' bajche mi quejel la' ñusan wocol. Como mi la' lolon oc isan jini mandar tsa' bʌ i yʌq'uetla Moisés che' bajche' chʌncol la' wʌq'uen i cuche' ñoj on bʌ i cuch quixtyañu yubil mach'ʌ ch'ujbi i cuche'. Pero la' bajñel mach la' wom la' tyʌle' jini cuchul mi ti la' yal c'ʌbic yubil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","P'ump'uñetla che' bajche' mi quej la' ñusan wocol como mi la' lolon melben tyun bʌ i yotyotlel ti pam ba' ti mujqui ch'ujlelʌl cha'an la' c'ajtisan jini tsa' bʌ i xiq'ui i yʌle' Dios tsa' bʌ i tsʌnsʌyob la' yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chʌncol la' wʌc' ti tsictiyel lajal la' pensal la' wic'ot la' yumob ti ñoj oniyix. Como ti' tsʌnsʌyob jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix, jatyetla mi la' lolon melben i yotyot ti' pam ba' ti mujqui ch'ujlelʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jin cha'an Dios ti i ña'tyʌbal ti yʌlʌ: Mi quejel c choque' majlel jini mu' bʌ c xiq'ue' i yʌle' yic'ot ajsubt'añob ñumel tsa' bʌ c yajcʌ. An mu' bʌ quejel i tsʌnsʌntyel. Yambʌ mi quejel i tyʌc'lʌntyel. Che' ti wʌ alʌ Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jin cha'an Dios mi yʌq'uen ti i wenta ili quixtyañujob año' bʌ wale iliyi cha'an i xot'e' i mul pejtyelel jini tsa' bʌ xijq'uiyob i yʌle' cha'an Dios tsa' bʌ tsʌnsʌntiyob c'ʌlʌ ti mejli mulawil. ");
INSERT INTO ctu76_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","C'ʌlʌ ti tsʌnsʌnti Abel ti ñaxan bʌ ajtsʌnsa c'ʌlʌ ti tsʌnsʌnti Zacarías tsa' bʌ i tsʌnsʌyob ya' ti xiñil jini yajnib ba' ti' puluyob i majtyan Dios yic'ot jini colem templo mi lu' otsʌntyel ti i wenta che' bajche' mi i mulʌch jini quixtyañujob wʌ' bʌ año' wale iliyi cha'an i xot'e'. ");
INSERT INTO ctu76_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","P'ump'uñetla ajcʌntisajet bʌ la cha'an mandar. Che' bajche' mi quejel la' ñusan wocol cha'an bajche' ti la' lolon cʌntisʌyob. Ti la' mʌctyʌbeyob jini yom bʌ i ña'tyañob. Jixcu jatyetla la' bajñel mach la' wom la' yoque ch'ʌm'en isujm cha'an la' cotyʌntyel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Che' ñac Jesús ti yʌlʌ ili t'an tyac jini ajcʌntisa cha'an mandar yic'ot fariseojob ti' wen mich'q'ueleyob Jesús. Ti queji i wen tyʌc'lan Jesús ti cabʌl c'ajtibal tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ti' wen ñʌch'tyʌyob i t'an cha'an jach yomob i jop'ben i mul Jesús cha'an i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Che' chʌncol tyo ti t'an Jesús ti queji i much'quiñob i bʌ ti mil tyac quixtyañujob jintyo mux i pepets tyec'ob i yocob. Jesús ti queji i ñaxan suben jini ajcʌnt'añob i cha'an: Wen cʌñʌtyan la' bʌ cha'an i cha'chajplel bʌ i pensal jini fariseojob mu' bʌ i lolon pʌs i bʌ ti wen pero mach weñobic. Jiñʌch che' bajche' levadura mu' bʌ i yʌq'uen i wos i bʌ caxlan waj. ");
INSERT INTO ctu76_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Como ma'ix chʌ bʌ mucul bʌ wale iliyi mach'ʌ ba'an mi quejel i tsictiyel. Mach'an chʌ bʌ mucul mach'ʌ ba'an mi quejel i lu' ña'tyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jin cha'an pejtyelel tsa' bʌ la' subu ti mucul mi quejel i jamʌl sujbel che' bajche' mi ti q'uinil. Jini tsa' bʌ la' mucu subu la' bʌ che' ñup'ul i ti' otyot yubil mi quejel i jamʌl sujbel ti pejtyelel otyot tyac che' bajche' mi ti pam otyotyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Mic subeñetla p'untyʌbilet bʌ c pi'ʌlob. Mach yom la' lolon bʌc'ñan jini mu' bʌ i tsʌnsañetla pero ma'ix chʌ bʌ ch'ujbi i más tyumbeñetla. ");
INSERT INTO ctu76_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero mic subeñetla jini yom bʌ la' bʌc'ñan. Bʌc'ñanla am bʌ i p'ʌtyʌlel i yʌq'uetla ti sajtyel. Pero añʌch i p'ʌtyʌlel je'el i choque' majlel quixtyañu ti xot'e' mulil ti c'ajc. Jiñʌch jini yom bʌ mi la' bʌc'ñan. ");
INSERT INTO ctu76_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Mach'a ba'an mi chojñel jo'cojt saj xma'tye'mut ti cha'wejch tyaq'uin? Pero ma'an mi ñajʌyel i cha'an Dios mi juncojtic. ");
INSERT INTO ctu76_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Como jinic tyo tsijquil i cha'an Dios jujunt'ujm i tsutsel la col. Mach yom la' cha'len bʌq'uen che' jini. Como más an la' c'ʌjnibal bajche' cabʌl saj xma'tye'mut. ");
INSERT INTO ctu76_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Che' je'el mic subeñetla: Joñon i Pi'ʌlon Quixtyañujob mi quejel c tsictisan ti' tyojlel ajtroñel i cha'an Dios ch'oyolo' bʌ ti panchan mij cʌñe' pejtyelelob mu' bʌ i tsictisan ti' tyojlel quixtyañujob mi chʌncol i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero jini mu' bʌ i yʌl ti' tyojlel quixtyañujob cha'an mach i cʌñon, joñon je'el mi quejel cʌle' ti' tyojlel ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan mach'an mij cʌñe'. ");
INSERT INTO ctu76_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ch'ujbi i ñusʌbentyel i mul majchical jach mi' cha'len t'an tij contra Joñon i Pi'ʌlon bʌ Quixtyañujob. Pero mach ñusʌnti i mul jini mu' bʌ i cha'len mach'ʌ wen bʌ t'an ti' contra Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Che' mi quejel i pʌyetla majlel ti melojel ti templo i cha'an bʌ israelob mi ti tyojlel juez o mi ba'an am bʌ ye'tyel mach yom mi la' pensalin bajche' mi quejel la' jaq'ue' mi chʌ bʌ mi quejel la' wʌle'. ");
INSERT INTO ctu76_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Como jini Ch'ujul bʌ i Chujlel Dios mi quejel i cʌntisañetla chʌ bʌ mi quejel la' wʌle' che' mi c'otyel i yorojlel la' cha'len t'an. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Juntiquil ya' bʌ an ti' t'ejl Jesús ti' sube: Maestro, suben cʌscun cha'an mi' t'oxbeñon jini tsa' bʌ i cʌybon lojon c tyat. ");
INSERT INTO ctu76_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús ti' sube: Pero ubin ma'ix que'tyel cha'an c t'oxbeñet chʌ bʌ an la' cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ti yʌlʌ je'el: Bej q'uele la' bʌ cha'an mach'an mi la' mich'q'uel chʌ bʌ an i cha'an la' pi'ʌl. Como mach'an cuxul quixtyañu cha'an ti cabʌl chʌ bʌ an i cha'an, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Che' jini Jesús ti' subeyob ili lajoñel: An juntiquil winic am bʌ cabʌl chʌ bʌ an i cha'an. Pejtyelel chʌ bʌ yes ti' pʌc'ʌ, ti wen yʌc'ʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Che' jini, jini winic ti queji i bajñel pensalin: ¿Chuqui mi quejel c cha'len? Mach jasʌl i yajnib ba' mic lotye' i wut c pʌc'ʌb, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ti' pensali: Cujil chʌ bʌ mi quejel c cha'len. Mi quejel cheje' jubel i yajnib chʌ bʌ an c cha'an. Mi quejel c mele' más colem bʌ. Ya'i mi quejel c lu' lotye' i wut c pʌc'ʌb tyac yic'ot pejtyelel chʌ bʌ yes an c cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Che' jini, mi quejel i bajñel pensalin: An cabʌl chʌ bʌ lotyol c cha'an wale iliyi. Jasʌl cha'an j c'ʌn cabʌl jabil. Mi quejel c wen c'aj coj. Mi quejel c wen cha'len uch'el. Mi quejel c wen tijicnisan c bʌ. Che' ti' bajñel pensali ti' pusic'al jini winic. ");
INSERT INTO ctu76_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios ti' sube jini winic: Pero ubin. Mach'an ma' ña'tyan. Wale iliyi bʌ ac'bʌlel mi quejel a sajtyel. Ixcu tsa' bʌ a lotyo, ¿majchqui i cha'an mi quejel i majlel? Che' ti' sube Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Chʌ'ʌch mi yujtyel mu' bʌ i niq'ui lotye' cha'an bʌ i bajñel cha'an. Pero p'ump'unjax ti' tyojlel Dios como mach'an mi' pensalin chʌ bʌ mi' mulan Dios. Chʌ'ʌch ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ti wi'il Jesús ti' sube ajcʌnt'añob i cha'an: Mic subeñetla mach yom mi la' lolon cabʌl pensalin chʌ bʌ mi quejel la' c'uxe' cha'an bej cuxul mi la' wajñel. Mach yom mi la' lolon cabʌl pensalin la' pislel mu' bʌ quejel la' xoje'. ");
INSERT INTO ctu76_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Dios ti yʌq'ueyetla cha'an cuxul mi la' wajñel. ¿Mach'a ba'an mi yʌq'uetla i bʌl la' ñʌc' mi la' wʌl je'el? Dios ti yʌq'ueyetla la' bʌc'tyal, ¿mach'a ba'an mi quejel i yʌq'ueñetla la' pislel je'el, mi la' wʌl? ");
INSERT INTO ctu76_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ña'tyanla jini xma'tye'mut bajche' an. Mach'an mi' cha'len pac'. Mach'an mi' cha'len c'ajbal. Ma'ix i yotyotlel ba' mi lotye' i buc'bal. Pero Dios mi' bej aq'uen i buc'bal. Más an tyo la' c'ʌjnibal bajche' jini xma'tye'mut. ");
INSERT INTO ctu76_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿An ba majch ya' ba' añetla mu' bʌ i colel i xinil metro cha'an ti caj cabʌl pensal mi la' wʌl? ");
INSERT INTO ctu76_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mi mach ch'ujbi la' bej colel xinil metro cha'an ti cabʌl pensal, ¿chucoch mi la' lolon cha'len cabʌl pensal cha'an yan tyac bʌ? ");
INSERT INTO ctu76_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ña'tyanla bajche' mi colel jini nich' pimel tyac. Mach an mi' cha'len troñel. Mach'an mi' jale' i pislel. Pero mic subeñetla mi jinic jini yumʌl Salomón am bʌ cabʌl i ricojlel ma'ix ñoj c'otyajax i pislel bajche' i c'otyajlel jini nich' pimel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Como Dios mi yʌq'uen i c'otyajlel jini pimel mu' bʌ ti colel wale iliyi pero ijc'ʌl jach mi' pulelob ti yajnib c'ajc. Más mi' pensaliñetla Dios bajche' jini pimel. Pero ts'itya' jach mi la' ch'ujbin Dios che' an tyo cabʌl la' pensal. ");
INSERT INTO ctu76_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jin cha'an mach yom mi la' lolon cabʌl pensalin bajche' mi quejel la' tyaje' chʌ bʌ mi quejel la' c'uxe' chʌ bʌ mi quejel la' jape'. ");
INSERT INTO ctu76_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Como jini quixtyañu i cha'an jach mulawil mi' lolon cabʌl niq'ui pensalin che' bajche' jini. Pero jatyetla añʌch la' Tyat ti panchan mu' bʌ i lu' ña'tyan chʌ bʌ yom la' cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Más i c'ʌjnibal mi la' pensalin chʌ bʌ yom Dios. Che' jini mi quejel la' wʌq'uentyel pejtyelel chʌ bʌ tyac yom cha'añetla. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","C ovejajet bʌ la mach yom mi la' lolon cha'len bʌq'uen. Ma'ix cabʌletla pero Dios mi yʌq'ueñetla la' ajñel la' wic'ot ba' mi quej i cha'len yumʌl cha'an chʌ'ʌch mi mulan i cha'len Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Choñola chʌ bʌ yes an la' cha'an, cha'an la' cotyan mach'ʌ ba'an i cha'añob. Che' jini chʌncol la' chajpan i yajnib chʌ bʌ an la' cha'an mach'ʌ ba'an mi tsuculiyel. Añʌch la' ricojlel yubil mach'ʌ yujil jilel ti panchan ba' mach och ajxujch' i xujch'ibeñetla la' cha'an. Mach'an mi yochel animal mu' bʌ i jisan chʌ bʌ yes lotyol ya'i. ");
INSERT INTO ctu76_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jini la' cha'an mu' bʌ la' más q'uele' ti ñuc jiñʌch mu' bʌ la' bej pensalin. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesús ti' bej cha'le t'an. Ti yʌlʌ: Yom chajpʌbiletla yic'ot yom ts'ʌbʌl la' cas, yubil. ");
INSERT INTO ctu76_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yom añetla che' bajche' ajtroñelob chʌncol bʌ i wen pijtyan cha'an i julel i yum tsa' bʌ maji ti q'uiñejel cha'an ñujpuñel cha'an i wa' jamben i ti' otyot che' mi c'otyel che' mi' sub i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","C'ajacña i yoj jini ajtroñelob che' p'ixil tyo mi c'otyel i yum. Mic subeñetla melelʌch jini i yum mi quejel i chajpan i bʌ cha'an i cha'len troñel. Mi quejel i subeñob buchtyʌl jini ajtroñelob cha'an i yʌq'ueñob i cha'len uch'el. ");
INSERT INTO ctu76_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Aunque mi c'otyel ti xin ac'bʌlel mi ti sʌc'an pero c'ajacña i yoj jini ajtroñelob mi ti tyajle che' bej p'ixil tyo i pijtyan i yum. ");
INSERT INTO ctu76_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ña'tyanla jini. Mi ti pensali i yum jump'ej otyot bajche' ora mi quejel i c'otyel ajxujch' bej p'ixil c'ʌlʌ mi c'otyel ajxujch'. Mach'an mi yʌc' ochel i xujch'iben majlel chʌ bʌ yes an i cha'an. Che' ti yʌlʌ Jesús ti lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Yom bej chajpʌbiletla je'el como mi quejel c tyʌlel Joñon i Pi'ʌlon Quixtyañujob che' mach'an mi la' pensalin la' pijtyañon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Che' jini Pedro ti' c'ajtibe Jesús: C Yum, ¿tsa' ba a wʌlʌ jini lajoñel cha'añon jach lojon o cha'an ti pejtyelel quixtyañujob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Lac Yum ti' sube: ¿Majchqui jini xuc'ul bʌ ajcʌñʌtyaya troñelob mu' bʌ i ña'tyan bajche' mi' cha'len i troñel i yum? I yum mi' cʌye' ti i wenta pejtyelel am bʌ ti yotyot cha'an i lu' aq'ueñob i yuch'el ti i yorojlel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","C'ajacña i yoj jini ajcʌñʌtyaya troñel che' mi quejel i c'otyel i yum i q'uele' ts'ʌcʌl chʌncol i cha'len jini tsa' bʌ subenti i cha'len. ");
INSERT INTO ctu76_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Melel mic subeñetla: I yum mi quejel i yotsan ti' wenta jini xuc'ul bʌ ajcʌñʌtyaya troñel ti pejtyelel chʌ bʌ yes an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero mi ti' lolon pensali jini ajcʌñʌtyaya troñel max tyo ba'an mi quejel i wa' c'otyel i yum mi quejel i tyech i jats' yic'ot i niq'ui suben yambʌ ajtroñelob yic'ot x'ixicob. Mi quejel i wen bajñel cha'len uch'el. Mi quejel ti q'uixnijel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Che' jini i yum mi quejel i cha' c'otyel che' mach'an mi' saj pensalin i pijtyan i yum. Más tsʌts mi quejel i yʌq'uen i xot'e' i mul. Mi quejel i yʌq'uen i yajñel yic'ot jini mach'ʌ ba'an mi' ch'ujbiñob. ");
INSERT INTO ctu76_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Más mi quejel i yʌq'uentyel i xot'e' i mul jini ajtroñel yujil bʌ isujm chʌ bʌ yom i yum pero mach'an ti' chajpʌbe. Mach'an ti' ch'ujbibe i t'an. Wen cabʌl mi quejel i yʌc'bentyel. ");
INSERT INTO ctu76_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero jini ajtroñel mach'ʌ yujil isujm chʌ bʌ yom i yum aunque mach wen mi' cha'len pero ma'ix wen cabʌl mi quejel i yʌc'bentyel. Jini cabʌl bʌ chʌ bʌ mi yʌq'uentyel ti i wenta, cabʌl chʌ bʌ an ti i wenta cha'an mi' c'ʌñe' ti wen. Jini cabʌl bʌ chʌ bʌ mi poj aq'uentyel cha'an mi' cʌñʌtyan más an ti' wenta cha'an mi' cʌñʌtyan ti wen. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesús ti yʌlʌ: Ti tyʌliyon cha'an tij caj mi quejel i ñusan wocol che' bajche' mi ti ts'ʌbʌ c'ajc yubil wʌ' ti mulawil. Comʌch muq'uiquix i wa' lejmel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ti yʌlʌ je'el: Ñoj wocol mi quejel c ñusan. Chʌ'ʌch mi quejel c ñusan c'ʌlʌ jintyo mi yujtyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Mu' ba la' lolon ña'tyan ti tyʌliyon cha'an mi yajñelob ti ñʌch'ʌl jini wʌ' bʌ añob ti mulawil? Mach'an. Ti tyʌliyon cha'an mi' t'oxob i bʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Como wale iliyi mi quejel i t'oxob i bʌ quixtyañu ti jump'ej otyot. Mi an jo'tiquil ti jump'ej otyot, uxtiquil mi' contrajin cha'tiquil yic'ot cha'tiquil mi' contrajin uxtiquil. ");
INSERT INTO ctu76_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tyatyʌl mi quejel i contrajin alo' bʌ i yalobil. I yalobil mi quejel i contrajin i tyat. I ña' mi' contrajin i yixic'al. I yixic'al mi' contrajin i ña'. I nij'aña' mi' contrajin i yʌ'lib. I yʌ'lib mi' contrajin i nij'aña'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús ti' sube quixtyañujob je'el: Che' mi la' wilan mi tyejchel tyʌlel tyocal ba' mi p'ʌjquel q'uin mi la' wʌl: Tyalix ja'al, che'etla. Chʌ'ʌch mi yujtyel che' bajche' mi la' ña'tyan. ");
INSERT INTO ctu76_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Che' mi tyʌlel ic' ti sur mi quejel ticwal, che'etla. Chʌ'ʌch mi yujtyel bajche' mi la' wʌle'. ");
INSERT INTO ctu76_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Cha'chajp la' pensal. Mi la' ña'tyan che' mi quejel ja'al yic'ot ticwal pero mach'an mi la' ña'tyan chʌ bʌ yes mi quejel i yujtyel wʌ' ti mulawil aunque mi la' q'uel seña tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Chucoch mach'an mi la' bajñel ña'tyan chʌ bʌ yom mi la' cha'len? ");
INSERT INTO ctu76_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mi an majch mi quejel i pʌyet cha'an ma' majlel ba'an am bʌ ye'tyel jop'ox a lajmisan periyal che' max tyo ti c'otiyetla ba'an am bʌ ye'tyel cha'an mach'an mi' wersa bej pʌyet majlel ti melojel. Como mi ti c'otiyet ba'an am bʌ i ye'tyel mi quejel i yʌq'ueñet ti' wenta policía. Jini policía mi yotsañet ti cʌchol. ");
INSERT INTO ctu76_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mic subeñet ma'ix mi quejel a cha' loq'uel jintyo tsa'ix a lu' ts'ʌctisʌ a tyoj a mul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti jim bʌ ora ti c'oti cha'tiquil uxtiquil ya' ba'an Jesús. Ti' subeyob Jesús bajche' jini yumʌl Pilato bʌ i c'aba' ti yʌc'ʌ ti tsʌnsʌntyel winicob ya' ti pañimil Galilea bʌ i c'aba'. Pilato ti yʌc'ʌ ti xʌc'tyuntyel i ch'ich'el jini quixtyañujob yic'ot i ch'ich'el animal tyac tsa' bʌ i tsʌnsʌyob cha'an i majtyan Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús ti' subeyob: ¿Chʌncol ba la' lolon pensalin chʌ'ʌch ti' tyʌc'lʌntiyob jini winicob loq'uem bʌ ti Galilea cha'an más an i mul bajche' yaño' bʌ ti lumal? ");
INSERT INTO ctu76_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Mic subeñetla: Mach che'iqui pero mi mach'an mi la' q'uextyan la' pensal la' cʌye' la' mul mi quejel la' jilel je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O mu' ba la' lolon pensalin más añob i mul jini dieciocho tsa' bʌ jiliyob che' ñac ti yajli jini chan bʌ ts'ajc ya' ti Siloé bajche' jini yaño' bʌ chumulo' bʌ ti Jerusalén? ");
INSERT INTO ctu76_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Mic subeñetla: Mach che'iqui. Mi mach'an mi la' q'uextyan la' pensal la' cʌye' la' mul, ti pejtyeleletla mi quejel la' jilel je'el, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús ti' subeyob ili lajoñel: An juntiquil winic am bʌ i higuera tye' tsa' bʌ i pʌc'ʌ ya' ti i lum. Ti majli i q'uel mi an i wut. Pero mach'an ti' tyajbe i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Che' jini ti' sube jini ajtroñel i cha'an chʌncol bʌ i cʌñʌtyʌben i lum. Q'uele awilan uxp'ej jab chʌncol c bebebijin. Pero mach'an mic saj tyajben i wut. Seq'ue, ¿chucoch tyo mi' bej lolon mʌctyan lum? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero jini ajtroñel i cha'an ti' sube: C yum, la' tyo colic jump'ej tyo jab. Mu' tyo c wen joy picben i yebal. Mi quejel cotsan i tya' alʌq'uil cha'an i yʌc' i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","C'o'ojl mu' tyo quejel i yʌc' i wut, che' jini. Pero mi mach'an mi yʌc' i wut mu' tyo c seq'ue' jubel, che' ti yʌlʌ jini ajtroñel. ");
INSERT INTO ctu76_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ti jump'ej i q'uinilel c'aj oj Jesús ti' cha'le cʌntisa ti i templo israelob. ");
INSERT INTO ctu76_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ya'an juntiquil x'ixic. Anix bʌ dieciocho jabil i quejel ti c'am'an. Tyʌc'lʌbil ti xiba. Xiba ti yʌc'ʌ ti cotcot xʌmbal. Mach ch'ujbi i saj tyoj isan i bʌ jini x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Che' ñac Jesús ti yilʌ, ti' pʌyʌ tyʌlel. Ti' sube: X'ixic, lajmeñetix ti a c'am'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Che' jini Jesús ti yʌc'ʌ i c'ʌb ti jini x'ixic. Ti jim bʌ ora ti' wa' tyoj isʌ i bʌ. Ti queji i suben i ñuclel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero i yum i templo israelob ti mich'ʌ como Jesús ti' lajmisʌ ti q'uinilel c'aj oj. Ti' sube quixtyañujob: An wʌcp'ej q'uin cha'an lac cha'len troñel. Yom la' tyʌlel ti joch q'uin tyac cha'an mi la' lajmel. Mach yom ti i q'uinilel c'aj oj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Che' jini lac Yum ti' jac'be: Cha'chajp la' pensal. ¿An ba majch mach'ʌ ba'an mi tile' i tyat wacax o mi i burro cha'an i yʌq'uen ja' che' ti q'uinilel c'aj oj? ");
INSERT INTO ctu76_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Jixcu ili x'ixic i jiñʌjlel bʌ Abraham cʌchʌl yubil ti i p'ʌtyʌlel xiba jini Satanás c'ʌlʌ dieciocho jabil. ¿Mach ba yom mic tique' yubil che' ti yorojlel c'aj oj ma' wʌl? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Che' ñac ti yʌlʌ Jesús jini, pejtyelel i contrajob quisintic ti yubiyob. Pero ti pejtyelel yambʌ quixtyañujob c'ajacña i yoj ti yubiyob che' ñac ti yilʌ chʌ bʌ ñuc tyac ti' cha'le Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Che' jini, Jesús ti yʌlʌ: ¿Bajche' yilal i yumintyel Dios? ¿Bajche' ch'ujbi lac laje' i yumintyel Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ch'ujbi lac laje' i yumintyel Dios bajche' i bʌc' mostaza tsa' bʌ i p'ujp'u juntiquil winic ti i lum. Colem mi colel jintyo chanix bajche' juntyejc tye' yubil. Ya' mi' mel i c'u' xma'tye'mut ya' ti' c'ʌb tyac. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús ti yʌlʌ je'el: ¿Chuquiyes yic'ot mic laje' i yumintyel Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ch'ujbi lac laje' i yumintyel Dios bajche' levadura mu' bʌ i yʌq'uen i wos i bʌ caxlan waj mu' bʌ i xʌc'tyun juntiquil x'ixic ti uxp'is harina mu' bʌ i c'ʌñob i mel caxlan waj. Jini mi yʌc' i lu' wose' i bʌ caxlan waj, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús ti bej majli cha'an mi c'otyel ti Jerusalén. Ti' cha'le cʌntisa ya' ti lum tyac yic'ot saj xchumtyʌl tyac ba' ti ñumi majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","An majch ti' c'ajtibe Jesús: C Yum, ¿cha'tiquil uxtiquil jach ba mu' bʌ quejel i cotyʌntyel? che'en. Jesús ti' jac'be: ");
INSERT INTO ctu76_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Jop'ox la' wochel ti jini saj bʌ i ti' otyot yubil como mic subeñetla cabʌl yom ochel ti tyal tyo bʌ ora pero mach ch'ujbi. ");
INSERT INTO ctu76_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Che' mi tyejchel i yum otyot mi quej i ñupe' i ti' otyot. Jatyetla añet bʌ la ti pañimil mi quej la' jats'e' i ti' otyot. Mi quej la' wʌle': C Yum, jambeñon lojon i ti' a wotyot. Pero mi quej la' subentyel: Mach cujil isujm baqui ch'oyoletla jatyetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Che' jini mi quejel la' wʌle': Tic cha'le lojon uch'el a wic'ot. Ti a cʌntisʌyon lojon ti bij tyac. Che' mi quejel la' wʌle', ");
INSERT INTO ctu76_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","pero jini mi quejel i jac'beñetla: Tsa'ix cʌlʌ mach j cʌñʌ baqui ch'oyoletla. Loq'uenixla pejtyeletla mach'ʌ wen ti la' cha'le. Che' mi quejel i jaq'ue'. ");
INSERT INTO ctu76_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ya'i mi quejel la' cha'len uq'uel yic'ot tsʌts mi quejel la' c'uxe' la' wej che' mi la' q'uele' ya' ba' mi' cha'len yumʌl Dios ya'an Abraham, Isaac, Jacob yic'ot ti pejtyelel jini tsa' bʌ i xiq'ui i yʌle' Dios. Pero jatyetla mach'an ti otsʌntiyetla. ");
INSERT INTO ctu76_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Como mi quejel i c'otyel quixtyañujob ch'oyolo' bʌ ti paso' q'uin yic'ot ba' mi p'ʌjquel q'uin yic'ot ti norte yic'ot ti sur. Mi quejel i buchtyʌl ti uch'el ya' ba' mi' cha'len yumʌl Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Che' jini an jini mu' bʌ i q'uejlel ti mach'ʌ ñuc wale iliyi mi quejel i q'uejlel ti ñuc yic'ot an jini mu' bʌ i q'uejlel ti ñuc wale mi quejel i q'uejlel ti mach'ʌ ñuc ba' mi' cha'len yumʌl Dios. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti jim bʌ q'uin ti c'oti cha'tiquil uxtiquil israelob mu' bʌ i pejcʌntyel ti fariseojob cha'an ti caj bajche' mi' ch'ujbin. Ti' subeyob Jesús: Loq'uen wʌ'wʌ'i como Herodes yom i tsʌnsañet, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero Jesús ti' jac'beyob: Cucu suben jini simaron bʌ yumʌl: Q'uele awilan, wale iliyi yic'ot ijc'ʌl mic choque' loq'uel xibajob. Mic lajmisan xc'am'an. Uxi tyo mic jolontisan c troñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero wersa mic bej majlel wale iliyi, ijc'ʌl, cha'bi, jinto mij c'otyel ti Jerusalén como mach ch'ujbi i tsʌnsʌntyel jini tsa' bʌ i xiq'ui i yʌle' Dios ti yambʌ lum. Jin jach ti Jerusalén mi tsʌnsʌntyel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jatyetla añet bʌ la ti Jerusalén mu' bʌ la' tsʌnsan jini tsa' bʌ i xiq'ui i yʌle' Dios mu' bʌ la' jul ti tyun jintyo mi la' tsʌnsan jini ajsubt'an tsa' bʌ i choco tyʌlel Dios. Jayyajlel com c much'quiñetla yubil che' bajche' ña' mut mi luts i yal. Pero mach la' wom. ");
INSERT INTO ctu76_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Q'uele awilan la' colem templo mi quejel i joch cʌytyʌl. Ma'ix mi quejel la' cha' ilañon jintyo ti yorojlel mi quejel la' wʌle': Tijicñayet jatyet Yumʌlet mu' bʌ a tyʌlel cha'an che' yom Dios. Chʌ'ʌch mi quejel la' wʌle', che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ti jump'ej i q'uinilel c'aj oj ti ochi ti uch'el Jesús ya' ti yotyot juntiquil am bʌ i ye'tyel cha'an fariseojob. Jini yambʌ fariseojob chʌncox i chʌc chijtyan bajche' mi' cha'len Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ya'an je'el ti i tyojel Jesús juntiquil c'am bʌ winic si't'il bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Che' jini, Jesús ti' c'ajtibe jini ajcʌntisajob i cha'an israelob yic'ot jini fariseojob: ¿Yom ba mi lajmisʌntyel juntiquil xc'am'an che' ti q'uinilel c'aj oj o mach yom? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Che' jini, ñʌch'ʌl ti cʌyleyob. Che' jini Jesús ti yʌc'ʌ i c'ʌb ti xc'am'an. Ti' lajmisʌ. Ti' xiq'ui majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Che' jini Jesús ti' sube jini fariseojob: Pero jatyetla, anic la' burro mi la' tyat wacax tsa' bʌ yajli ochel ti pozo, ¿mach'a ba'an mi quejel la' wa' loc'san ti ora jach aunque i q'uinilelʌch c'aj oj? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero jini fariseojob mach'an ti mejli i saj jac'beñob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Che' ñac Jesús ti' q'uele jini pʌyʌlo' bʌ ti q'uiñejel chʌncol i yajcan jini más wen bʌ buchlibʌl. Ti' subeyob ili t'an: ");
INSERT INTO ctu76_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Mi an juntiquil mi' pʌyet ti q'uiñejel cha'an ñujpuñel, mach yom ma' buchtyʌl ti más wen bʌ buchlibʌl ame mi c'otyel yambʌ pʌyʌl bʌ mu' bʌ i q'uejlel ti más ñuc bajche'et. ");
INSERT INTO ctu76_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ame jini tsa' bʌ i pʌyʌyetla mi tyʌlel i subeñet: La' buchlec jini yambʌ winic wʌ' ba' buchulet, che'en. Che' jini, quisintic mi quejel a wubin cha'an ma' majlel ti buchtyʌl ti mach'ʌ lajal wen bʌ buchlibʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pero che' pʌyʌlet ti q'uiñejel yom ma' majlel ti buchtyʌl ya' ba'an jini mach'ʌ lajal wen bʌ buchlibʌl. Che' jini, che' mi c'otyel jini tsa' bʌ i pʌyʌyet mi quejel i subeñet: Pi'ʌl, yom wʌ' ma' tyʌlel ti jini más wen bʌ buchlibʌl, che'en. Che' jini, ñuc mi quejel i q'uelet ti pejtyelel yaño' bʌ pʌyʌlo' bʌ ya' bʌ buchulob ti q'uin a wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Como majchical jach mi' lolon chan isan i bʌ mi quejel i ju'sʌntyel. Pero jini jubem bʌ i pusic'al mi quejel i q'uejlel ti ñuc. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús ti' pejcʌ jini winic tsa' bʌ i pʌyʌ ti uch'el. Ti' sube: Che' ma' pʌy ti uch'el ti q'uinil o mi ti ic'an mach yom jin jach ma' bej pʌye' jini utso' bʌ a wic'ot, mi a wijts'iñob a wʌscuñob, mi a pi'ʌlob, mi jini ricojo' bʌ lʌc'ʌlo' bʌ ti chumtyʌl. Como jini mi' cha' pʌyet cha'an mi' q'uextyʌbeñet jini tsa' bʌ a cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero che' ma' mele' q'uiñejel, ma' pʌye' jini mach'ʌ ba'an chʌ bʌ an i cha'añob, jini mach bʌ weñob i c'ʌb i yoc, jini mach bʌ wen mi' cha'len xʌmbal yic'ot jini muts'ulo' bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","C'ajacña a woj mi quejel a wubin mi chʌ'ʌch ma' cha'len. Como jini mach ch'ujbi i cha' q'uextyʌbeñetyob. Pero cha'an wen ti a cha'le mi quejel a q'uextyʌbentyel ya' ti panchan che' mi quejel i tyejchel loq'uel ba'an sajtyemo' bʌ jini tsa' bʌ i cha'le wen bʌ che' ñac cuxulob tyo. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Che' ñac juntiquil ya' bʌ an ti q'uiñejel yic'ot Jesús ti yubi tsa' bʌ ujti i yʌle' Jesús ti yʌlʌ: C'ajacña i yoj jini mu' bʌ i ochel ti q'uiñejel ya' ba' mu' ti yumʌl Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Che' jini Jesús ti yʌlʌ: Juntiquil winic ti queji i mele' colem bʌ q'uiñejel. Ti' pʌyʌ cabʌl quixtyañujob cha'an mi c'otyelob. ");
INSERT INTO ctu76_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Che' ti c'oti mero i yorojlel q'uiñejel ti' xiq'ui majlel juntiquil ajtroñel i cha'an, cha'an mi majlel i suben pejtyelel jini pʌyʌlo' bʌ: La'ixla. Lu' listojix cha'an q'uiñejel, che' ti subentiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero ti jujuntiquil jini pʌyʌlo' bʌ ti queji i yʌle' chʌ bʌ och mach ch'ujbi i majlel. Jini ñaxan bʌ tsa' bʌ i pejcʌ ti yʌlʌ: A wocolic ñusʌbeñon. Ujtyel c mʌñe' jumpejt lum. Wersa mic majlel j q'uele'. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yambʌ ti yʌlʌ: A wocolic ñusʌbeñon. Tsa'ix c mʌñʌ diez tyat wacax. Chʌncol c majlel j q'uel mi yujil troñel. Che' ti yʌlʌ jini cha'ticlel. ");
INSERT INTO ctu76_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Yambʌ ti yʌlʌ: Ujtyel c ñujpuñel. Jin cha'an mach ch'ujbi c majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I yajtroñel jini winic chʌncol bʌ i mele' q'uiñejel ti sujti i suben i yum bajche' ti' lu' jac'ʌyob. Che' jini ti mich'ʌ i yum. Ti' sube i yajtroñel: Cucu ti ora jach ya' ti lum yic'ot ti pejtyelel calle tyac. Wʌ' ma' pʌy tyʌlel jini mach'ʌ ba'an chʌ bʌ an i cha'añob yic'ot mach weñob i c'ʌb yic'ot jini mach'ʌ wen mi' cha'len xʌmbal yic'ot muts'ulo' bʌ i wut. Che' ti yʌlʌ jini xmel q'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Che' ñac ujtyem i mele' bajche' ti subenti, jini ajtroñel ti cha' sujti ya' ba'an i yum. Ti yʌlʌ: C yum, tsa'ix c lu' cha'le bajche' ti a xiq'uiyon. Pero max tyo but'ul a wotyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Che' jini i yum otyot ti' cha' xiq'ui jini ajtroñel i cha'an. Cucu ya' ti bij tyac yic'ot ti mucu bij tyac. Ma' wersa subeñob quixtyañujob cha'an mi yochelob cha'an mi bujt'el cotyot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Como mic subeñet mi junticlec jini tsa' bʌ c ñaxan pʌyʌ mi quejel i saj c'uxe' jini tsa' bʌ c chajpʌ. Che' ti yʌlʌ i yum q'uiñejel, che' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Cabʌl quixtyañu ti' tsʌcleyob majlel Jesús. Che' jini ti' sutqui i bʌ cha'an i pejcañob. Ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Jini mu' bʌ i tsʌcleñon majlel yom i más p'untyañon che' bajche' mi' p'untyan i tyat mi i ña', mi i yijñam mi i yalobilob, mi i yʌscuñob, mi i chichob mi i yijts'iñob. Yom i más p'untyañon che' bajche' mi' bajñel p'untyan i bʌ. Mi mach che'ic mi' p'untyañon mach ch'ujbi i yochel ti ajcʌnt'an c cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jini mach bʌ yom i tsʌcleñon aunque mi tsʌnsʌntyel cha'añon mach ch'ujbi i yochel ti ajcʌnt'an c cha'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pero mi an juntiquil mu' bʌ la' pensalin la' mele' colem bʌ la' wotyot, ¿mach ba ñaxan mi la' wen pensalin mi an ba' ma' tyaje' pejtyelel chʌ bʌ yes yom cha'an mi mejlel i yujtyel troñel? ");
INSERT INTO ctu76_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ame che' ujtyem la' mele' i c'ʌclib i yebal otyot, ma'ix mi la' tyaje' chʌ bʌ yes yom cha'an mi yujtyel la' mele'. Che' jini pejtyelelob mu' bʌ i q'uele' mi wajleñetyob. ");
INSERT INTO ctu76_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Mi quej i yʌlob: Jini winic ti queji i mele' colem bʌ i yotyot pero mach'an ti mejli i jolontisan. Chʌ'ʌch mi quejel i yʌlob. ");
INSERT INTO ctu76_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Che' je'el mi an juntiquil rey mu' bʌ i majlel ti guerra ti' contra yambʌ rey, ¿mach ba mux i wʌ pensalin mi jasʌl diez mil i soldado cha'an mi' ganarin i contra mu' bʌ i tyʌlel yic'ot veinte mil soldado? ");
INSERT INTO ctu76_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mi mach ch'ujbi i ganarin mi yubin, che' ñajt tyo an jini yambʌ rey mux i wʌ choque' majlel winicob cha'an mi' wersa c'ajtiben cha'an lajmic contrajiya. ");
INSERT INTO ctu76_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Che' bajche' jini, majchical jach ya' ba' añetla mach bʌ yom i cʌye' i wen p'untyan chʌ bʌ an i cha'an mach ch'ujbi i yochel ti ajcʌnt'an c cha'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","C'ʌjnibal ats'am. Pero mi ti jili i tsajel ma'ix bajche' ch'ujbi i cha' tsaj'isʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Che' ma'ix i tsajel ats'am, jilemix i c'ʌjñibal. Mach saj wenix mi cha'anic lac lum mi cha'anic mi lac xʌc'tyun yic'ot jini mu' bʌ laj c'ʌn cha'an wen'ac lac lum. Che' jach mi chojquel. Jini yom bʌ i ch'ʌmben isujm ili t'an, pensalinla. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ti pejtyelelob jini xch'ʌm tyojoñelob yic'ot jini mu' bʌ i q'uejlel ti xmulilob ti queji i lʌc'ob Jesús cha'an mi' ñʌchtyʌben i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jin cha'an jini fariseojob yic'ot ajcʌntisajob cha'an israelob ti queji i tyaje' ti t'an Jesús. Ti yʌlʌyob: Ili winic mi' pʌye' ochel xmulilob. Mi' cha'len uch'el yic'otyob. Che' ti queji i yʌlob. ");
INSERT INTO ctu76_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Che' jini Jesús ti' subeyob ti lajoñel bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ti yʌlʌ: La' lac poj al che' bajche' jini. An juntiquiletla an la' cha'an cien tiñʌme'. Pero ti' sʌtyʌ i bʌ juncojt. ¿Chuqui mi quejel a wa' cha'len che' jini? ¿Mach ba ba'an ma' cʌye' jini noventa y nueve ya' ti jamilol cha'an majliquet a sʌclan jini tsa' bʌ sʌtyʌ i bijlel jintyo ma' tyaje'? ");
INSERT INTO ctu76_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Che' ma' tyaje' ma' q'ueche' tyʌlel ti a quejlop. C'ajacña a woj ma' wubin, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Che' ma' c'otyel ti a wotyot ma' pʌye' tyʌlel ti pejtyelel utso' bʌ a wic'ot yic'ot jini lʌc'ʌlo' bʌ ti chumtyʌl. Ma' subeñob: Yom lu' c'ajacña la coj como tic tyaja c tiñʌme' tsa' bʌ i sʌtyʌ i bijlel. Che' ti yʌlʌ Jesús ti lajoñel bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ti yʌlʌ je'el: Mic subeñetla cha'an más c'ajacñayob i yoj mi quejel i yubiñob jini año' bʌ ti panchan che' an juntiquil xmulil mu' bʌ i q'uextyan i pensal i cʌye' i mul che' bajche' che' an noventa y nueve tyojo' bʌ quixtyañujob mach'ʌ ba'an ti yotsʌyob i mul. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ti yambʌ lajoñel bʌ t'an Jesús ti yʌlʌ: La' lac poj al: An juntiquil x'ixic am bʌ diez plata bʌ tyaq'uin. Ti' sʌtyʌ jump'ej. ¿Mach'a ba'an mi quejel i tsuq'ue' cas, mi' wen misun i yotyot? Mi' chʌc bej sʌclan c'ʌlʌ jintyo mi' tyaje'. ");
INSERT INTO ctu76_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Che' mi' tyaje' mi' pʌye' tyʌlel jini utso' bʌ yic'ot, yic'ot lʌc'ʌlo' bʌ ti chumtyʌl. Mi' subeñob: Yom lu' c'ajacña la coj como tsa'ix c tyaja c tyaq'uin tsa' bʌ c sʌtyʌ. Che' mi quejel i yʌle' jini x'ixic. Che' ti' cha'le lajoñel bʌ t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ti yʌlʌ je'el: Mic subeñetla cha'an chʌ'ʌch mi quejel i yubin c'ajacña bʌ i yoj jini ajtroñelob i cha'an Dios ch'oyol bʌ ti panchan che' mi' q'uextyan i pensal i cʌye' i mul juntiquil xmulil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús ti yʌlʌ je'el: An juntiquil winic an cha'tiquil alo' bʌ i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jini ijts'iñʌl bʌ ti' sube i tyat: C tyat, t'oxbeñon pejtyelel chʌ bʌ an a cha'an bajche' c'amel mi' tyajon, che'en. Che' jini i tyat ti' t'ox yʌq'ueyob chʌ bʌ an i cha'an bajche' c'amel mi' tyajob ti jujuntiquil. ");
INSERT INTO ctu76_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Che' ti ñumi cha'p'ej uxp'ej q'uin jini ijts'iñʌl bʌ ti' lu' choño chʌ bʌ an i cha'an. Che' jini yic'ot pejtyelel i tyaq'uin ti majli ti ñajt bʌ pañimil ba' ti lu' c'ʌñʌ ti pejtyelel tyaq'uin cha'an bibajax bajche' ti' cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero che' tsa'ix lu' jili ti pejtyelel i tyaq'uin, ti queji ti sʌjlel ti pejtyelel chʌ bʌ jach mi' c'uxob quixtyañujob ya' ti jini pañimil. Che' jini, jini alob ti queji i yubin wi'ñal. ");
INSERT INTO ctu76_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Che' jini ti majli i sʌclan toñel ya' ba'an juntiquil winic. Jini ti' xiq'ui majlel ti jamilol cha'an i cʌñʌtyʌben i chityam. ");
INSERT INTO ctu76_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Cha'an ñoj wi'ñal ti yubi yom i c'uxe' jini che' bʌ bajche' bits' yilal mu' bʌ i yʌq'uen i c'uxe' chityam. Pero ma'an majch mi' ts'in aq'uen. ");
INSERT INTO ctu76_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Che' jini ti queji i pensalin: Ya' ba'an c tyat an cabʌl i yajtoñelob. Wen mi yʌq'uentyel i yuch'el. Ma'ix mi jilel i yuch'el pero wʌ'i chʌncol c sajtyel ti wi'ñal. ");
INSERT INTO ctu76_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi quejel c cha' sujtyel ba'an c tyat. Mi quejel c suben: C tyat, tsa'ix c cha'le mulil ti' tyojlel Dios yic'ot ti a tyojlel. ");
INSERT INTO ctu76_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mach bej weñon cha'an ma' pejcañon ti a walobil. Otsañon che' bajche' a wajtoñel jach. Chʌ'ʌch ti' pensali jini alob. ");
INSERT INTO ctu76_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Che' jini ti loq'ui majlel cha'an mi cha' c'otyel ti yotyot i tyat. Pero i tyat ti' q'uele che' ñajt tyo i tyʌlel. Ti' wen p'untyʌ. Ti majli ti ajñel i tyaj tyʌlel. Ti' wa' meq'ue. Ti' ñupu. ");
INSERT INTO ctu76_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Che' jini, jini alob ti' sube i tyat: C tyat, tsa'ix c cha'le mulil ti' tyojlel Dios yic'ot ti a tyojlel. Mach bej weñon cha'an ma' pejcañon ti a walobil. Che' ti yʌlʌ jini alob. ");
INSERT INTO ctu76_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero i tyat ti' sube i yajtoñelob: Ch'ʌmʌ tyʌlel ti saj ora jach jini más wen bʌ pislel. Wa' xojbenla i pislel. Aq'uenla i sortija. Aq'uenla i zapatos, che'en. Sortija yom i yʌle' mʌpc'a'. ");
INSERT INTO ctu76_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Pʌyʌla tyʌlel jini sejel bʌ wacax jini jujp'em bʌ. Tsʌnsanla, mi quejel lac cha'len uch'el. Mi quejel lac mele' q'uiñejel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Como jini calobil che' bajche' sajtyemix pero tsa'ix cha' cuxtiyi yubil. Che' bajche' ti' sʌtyʌ i bijlel pero tsa'ix lac cha' tyaja. Che' ti yʌlʌ i tyat jini alob. Ti' wen quejiyob ti q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Che' ñac ti c'oti ti yotyot i tyat jini ijts'iñʌl ya' tyo an ti cholel jini ascuñʌl bʌ. Che' ñac chʌncox i sujtyel ti toñel che' lʌc'ʌlix i c'otyel ti yotyot ti yubi i t'an música yic'ot son. ");
INSERT INTO ctu76_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Che' jini ti' pʌyʌ juntiquil ajtroñel ya' bʌ'an. Ti' c'ajtibe: ¿Chuqui muc'ob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jini ajtroñel ti yʌlʌ: Tsa'ix juli jini a wijts'in. A tyat ti' xiq'ui ti tsʌnsʌntyel jini sejel wacax jini jujp'em bʌ. Como c'oc' ti cha' juli a wijts'in, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero jini ascuñʌl ti mich'ʌ. Pero cha'an mach yom i yochel ti yotyot i tyat ti majli i wersa suben cha'an mi yochel majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero jini ascuñʌl bʌ ti yʌlʌ: A wujil jayp'ej jab tic wen cha'libeyet a troñel. Mach'an ba' bʌ ora tic saj ñusʌbeyet a t'an. Pero mach'an ti a wʌc'on mi juncojtic saj chibu cha'an mic mele' q'uiñejel yic'ot jini amigojo' bʌ c cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero wale cha'an ti cha' c'oti jini a walobil tsa' bʌ lu' c'ʌñʌ a tyaq'uin ti pejtyelel mach'ʌ wen tsa'ix a wa' tsʌnsʌbe sejel wacax jini jujp'em bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Che' jini i tyat ti' sube: Pero calobil, bele' wʌch an quic'otyet. Ti pejtyelel chʌ bʌ an c cha'an lu' a cha'añʌch je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero wale yomʌch lac mele' q'uiñejel. Yom c'ajaña la coj. Como jini a wijts'in che' bajche' sajtyemix pero ti cha' cuxtiyi yubil. Che' bajche' ti' sʌtyʌ i bijlel pero tsa'ix lac cha' tyaja. Che' ti yʌlʌ i tyat. ");
INSERT INTO ctu76_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús ti' sube jini ajcʌnt'añob i cha'an: An juntiquil wen rico bʌ winic. An i yajchoñoñel cha'an i cha'liben ganar. Yambʌ quixtyañujob ti c'otiyob ya' ba'an jini rico bʌ. Ti' sube jini i yajchoñoñel chʌncox i lolon jisʌben chʌ bʌ an i cha'an i yum. ");
INSERT INTO ctu76_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Che' jini, jini rico bʌ winic ti' pʌyʌ jini i yajchoñoñel. Ti yʌlʌ: ¿Chuquiyes i sujmlel iliyi chʌncol bʌ i subeñoñob? Subeñon bajche' ti a c'ʌñʌ ti pejtyelel chʌ bʌ tyac ti cʌq'ueyet ti a wenta. Ma'ix mi quejel c bej aq'ueñet a cha'len troñel. Che' ti subenti. ");
INSERT INTO ctu76_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Che' jini, jini ajchoñoñel ti wen queji ti pensal: ¿Chuquiyes mi quejel c cha'len wale mi ti' chilbon c troñel jini c yum? Ma'ix c wersa cha'an mic cha'len tsʌts bʌ troñel. Mic quisnin j c'ajtin majtyan tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Cujil isujm chʌ bʌ yes mi quejel c cha'len cha'an añʌch amigojob c cha'an mu' bʌ i pʌyon ochel ti yotyot che' tsa'ix i chilbon c troñel c yum, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Che' jini ti queji i pʌye' ti jujuntiquil ti pejtyelel año' bʌ i bet yic'ot jini rico bʌ. Ti' c'ajtibe jini ñaxan bʌ: ¿Jayp'ejqui a bet a wic'ot? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jini ñaxan bʌ ti' jac'ʌ: Añʌch c bet cien colem yajnib lew, che'en. Che' jini, jini yajchoñoñel ti' sube: Umba'an i junilel a bet. Buchi', ti saj ora jach yom ma' cha' ts'ijbun yambʌ jun cha'an cincuenta jach mi yʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Che' jini, jini yajchoñoñel ti' c'ajtibe yambʌ quixtyañu. Ixcu jatyet, ¿jayp'ejqui a bet? che'en. Jini ti' jac'ʌ: Añʌch c bet trigo joc'al p'is, che'en. Jini yajchoñoñel ti yʌlʌ: Umba'an i junilel a bet. Wa' ts'ijbun yambʌ cha'an ochenta p'is jach. Che' ti subenti. ");
INSERT INTO ctu76_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jini rico bʌ winic ti' subu i ñuclel jini i yajchoñoñel cha'an wen yujil bajche' mi' cha'len. I tyʌlelʌch quixtyañujob mach bʌ ba'an mi' ch'ujbin Dios mi' más ña'tyan bajche' mi' cha'libeñob i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesús ti yʌlʌ je'el: Mic subeñetla yom mi la' c'ʌñe' chʌ bʌ an a cha'an cha'an i cotyʌntyel yaño' bʌ wʌ' ti mulawil. Mi quejel i uts an a wic'ot quixtyañu. Che' jini che' jilemix ti pejtyelel a ricojlel che' mi la' c'otyel ya' ti panchan mi quejel a wʌq'uentyel a tyojol yubil cha'an jini wen bʌ tsa' bʌ a cha'le. ");
INSERT INTO ctu76_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jini mu' bʌ i c'ʌñe' ti xuc'ul i saj jach am bʌ ti' wenta xuc'ul je'el mi quejel i c'ʌñe' che' an cabʌl ti i wenta. Jini mach'ʌ ba'an mi' c'ʌñe' ti xuc'ul ts'itya' tyac jach am bʌ ti i wenta ma'ix mi quejel i c'ʌñe' ti xuc'ul anic cabʌl ti i wenta. ");
INSERT INTO ctu76_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Mi ma'ix xuc'ulet ti c'ʌñol ti troñel Dios jini am bʌ ti mulawil am bʌ ti a wenta mach'an mi quejel a wʌq'uentyel ti a wenta la' cha'len jini yoque melel bʌ, jiñʌch i troñel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mi ma'ix xuc'ulet ti c'ʌñol chʌ bʌ yes i cha'an yambʌ quixtyañu am bʌ ti a wenta, che' jini mach'an mi yʌq'ueñetla Dios jini ñoj wen bʌ cha'an i yajñel ti yoque a cha'an bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mach'an ajtroñel ch'ujbi bʌ i yumin cha'tiquil i yum wʌ' ti mulawil. Mi quejel i mich'q'uel juntiquil, mi quejel i p'untyan jini yambʌ. Xuc'ul mi' cha'liben i troñel juntiquil, mi' lu' ñusʌben i t'an jini yambʌ. Chʌ'ʌch an lac pusic'al je'el. Mach ch'ujbi la' yumin Dios che' chʌncol la' yumin tyaq'uin, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","I tyʌlel jini fariseojob ti' wen mulʌ tyaq'uin. Chʌncox i lu' yubiñob bajche' chʌncol i yʌle' Jesús. Che' jini, ti' wajleyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Che' jini Jesús ti' subeyob: Jatyetla chʌncox la' lolon pʌs la' bʌ ti i tyojlel quixtyañujob che' bajche' mi weñetla. Pero Dios mi' lu' cʌn la' pusic'al. Dios mi' ts'a'q'uel jini mu' bʌ i lolon q'uejlel ti ñuc ti quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","C'ʌlʌ jintyo ti tyʌli Juan jin jach ti sujbi i mandar Moisés yic'ot i t'an jini tsa' bʌ i xiq'ui yʌle' Dios. Pero che' ti jim bʌ ora che' ñac ti tyʌli Juan ti queji i sujbel jini wen bʌ t'an cha'an bajche' mi' cha'len yumʌl Dios. Ti pejtyelel quixtyañujob mu' bʌ i yochel mi' cha'leñob wersa cha'an ochicob ti jini tsiji' bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ch'ujbi i sʌc jilel majlel pejtyelel mulawil yic'ot chan pero mach ch'ujbi i saj jilel i c'ʌjnibal mi jump'ejlic saj t'an ti i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jesús ti yʌlʌ mi ti' cʌyʌ i yijñam juntiquil winic cha'an i cha' tyaje' yambʌ yijñam chʌncol jach i cha'len i tsuculel jini winic. Jini mu' bʌ i pʌye' cʌyʌl bʌ x'ixic mi' cha'len i tsuculel je'el. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesús ti' bej cha'le cʌntisa. Ti yʌlʌ: An juntiquil rico bʌ winic am bʌ cabʌl chʌ bʌ an i cha'an. Ti' bej xojo wen bʌ i pislel. C'otyajax i pislel. Ti' cha'le colem bʌ q'uiñejel ti jujump'ej q'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","An je'el juntiquil p'ump'um bʌ winic Lázaro bʌ i c'aba'. Cabʌl chʌ bʌ pasem ti pʌchʌlel. Ti buchle ya' ti lum ya' ti ti' yotyot jini rico bʌ winic. ");
INSERT INTO ctu76_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jini p'ump'un bʌ winic yom i c'uxe' mu' bʌ i p'ajtyel ti mesa che' mu' ti uch'el jini rico bʌ winic. Jinic tyo ts'i' ti tyʌli i lemben jini pasem bʌ ti pʌchʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ti sajti jini p'ump'um bʌ winic. Ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan ti' pʌyʌyob majlel ya' ti paraíso ya' ba'an Abraham. Ti sajti je'el jini rico bʌ. Ti ch'ujñʌnti. ");
INSERT INTO ctu76_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Che' ñac chʌncol i yilan wocol jini wen rico bʌ winic ya' ba' mi majlel jini sajtyemo' bʌ ti' letsʌ i wut. Ti' ñajtyʌ q'uele Abraham yic'ot Lázaro ya' an yic'ot je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Che' jini ti' cha'le oñel: C tyat Abraham, q'ueleyon ti p'ump'un cha'an ma' cotyañon. Xiq'ui jini Lázaro cha'an mi' ts'aje' i yal c'ʌb ti ja' cha'an tyʌlic i tsʌn isʌbeñon cac' como ñoj wocol chʌncol c ñusan wʌ' ti c'ajc, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham ti' sube: Calobil, ña'tyan ñoj wen añet che' ñac cuxulet tyo. Lázaro ti yilʌ wocol. Wale iliyi mi ñuc isʌntyel i pusic'al. Jatyet ma' wilan wocol. ");
INSERT INTO ctu76_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Che' je'el an colem jajp ch'en mu' bʌ i t'oxonla. Aniqui majch yom c'otyel ya' ba' añet mach ch'ujbi. Mach ch'ujbi c'axic wʌ'wʌ'i jini ya' bʌ añob ya' ya'i je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Che' jini, jini rico bʌ winic ti yʌlʌ: Mic wersa c'ajtibeñet c tyat, Abraham, cha'an a xiq'ue' majlel Lázaro ya' ti yotyot c tyat. ");
INSERT INTO ctu76_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ya'an jo'tiquil quijts'iñob. La' i subeñob cha'an mach'an mi tyʌlel i ñusan wocol je'el wʌ' ba'añon. Che' ti yʌlʌ jini wen rico bʌ winic. ");
INSERT INTO ctu76_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham ti yʌlʌ: Añob i jun tsa' bʌ i ts'ijbu Moisés yic'ot tsa' bʌ xiq'ui yʌle' Dios ti ñoj oniyix. La' i ch'ujbiben i t'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jini wen rico bʌ winic ti' jac'ʌ: Chʌ'ʌchi, c tyat Abraham, pero muq'uic i majlel ya' ba' añob juntiquil loq'uem bʌ ba'an sajtyemo' bʌ mi quejel i q'uextyañob i pusic'al i cʌyob i mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham ti' sube: Mi mach yomob i ch'ujbiben i t'an Moisés yic'ot i t'an tsa' bʌ i xiq'ui i yʌle' Dios mach'an mi quejel i ch'ujbin i t'an juntiquil aunque ti tyechi loq'uel ba'an sajtyemo' bʌ mi c'otyel i subeñob i t'an Dios, che' Abraham ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús ti' sube ajcʌnt'añob i cha'an: Bej añʌch quixtyañu mu' bʌ i yʌq'uen i yotsañob i mul yaño' bʌ. Pero p'ump'un che' bajche' mi quej i ñusan wocol jini quixtyañu mu' bʌ i yʌq'uen i yotsan i mul yambʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más wen tsʌ'ic cʌjchi ti' bic' yic'ot jump'ej ña'tyun cha'an chojquic ochel ti ja' jini mu' bʌ i yʌq'uen i yotsan i mul juntiquil saj bʌ chʌncol bʌ i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Q'uele la' bʌ. Mi ti' cha'le mulil a pi'ʌl ti a tyojlel, yom ma' tiq'ue'. Mi ti' q'uextyʌ i pensal i cʌye' i mul, yom ma' ñusʌben i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Aunque c'ʌlʌl siete veces mi' cha'len mulil ti a tyojlel ti jump'ej q'uin, mi ti jujunyaj mi tyʌlel ba'añet i sub i bʌ i c'ajtibeñet ma' ñusʌben i mul, chʌ'ʌch yom ma' ñusʌben i mul, che' jini. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jini yajcʌbilo' bʌ ajsubt'añob ñumel ti' subeyob lac Yum: C Yum, cotyañon lojon cha'an más xuc'ul mi lojon c ch'ujbin. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Che' jini Jesús ti' subeyob: Mi ti la' ch'ujbiyon chʌ'cach ts'intyʌl bajche' i bʌc' mostaza i wentyʌlel, ch'ujbi la' suben ili sicómoro bʌ tye': La' bojquiquet. La' pʌjquiquet ya' ti colem ja', che'etla. Mi quejel i ch'ujbibeñetla la' t'an ili tye', che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Mi an juntiquil an ajtroñel i cha'an, mi ti juli ti troñel ti pic lum o mi ti' cʌñʌtyʌ animal mach'an mi quejel la' wa' suben: Ochen, buchi' cha'len uch'el, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mach che'iqui. Pero mi quejel la' ñaxan suben: Chajpʌbeñon i bʌl c ñʌc'. Chajpan a bʌ a wʌq'ueñon cuch'el. Ti wi'il ch'ujbi a cha'len uch'el je'el, che'etla. ");
INSERT INTO ctu76_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Mu' ba i subentyel wocox i yʌlʌ che' tsa'ix i ch'ujbibeyet a t'an? Mach'an, como jiñʌch i troñel. ");
INSERT INTO ctu76_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Chʌ'ʌch je'el jatyetla. Che' mi yujtyel la' lu' mele' chʌ bʌ mi' xiq'uetla a cha'len Dios yom mi la' wʌle': Ma'ix c ñuclel, ajtroñelon jach. Tsa' jach c cha'le am bʌ tic wenta cha'an mic cha'len. Che' yom mi la' wʌle'. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Che' chʌncol tyo i bej majlel cha'an mi c'otyel ti Jerusalén, Jesús ti ñumi ya' ti xinil pañimil Samaria yic'ot Galilea bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Che' chʌncol i c'otyel Jesús ti jump'ej saj lum ti' tyajayob ti bij diez winicob año' bʌ i c'am'an lu' pasem bʌ ti pʌchʌlel mu' bʌ i pʌc'misʌben majlel i bʌc'tyal. Pero ñajt ti wa'leyob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ti' c'am bʌ t'an ti yʌlʌyob: Jesús, Maestro, q'ueleyon ti p'ump'un cha'an a cotyañon lojon, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Che' ñac ti yilʌ Jesús, ti' subeyob: Cucuxla, pʌsʌ la' bʌ ya' ba'an cura, che'en. Che' chʌncol tyo i majlelob ti wa' lajmiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Che' jini juntiquil tsa' bʌ i yilʌ lajmenix ti cha' sujti ya' ba'an Jesús. Ti c'am bʌ t'an ti' sube i ñuclel Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ti' pʌc' choco i bʌ ya' ba'an Jesús c'ʌlʌ ti' tyaja lum i ñi' i wut cha'an i suben wocox i yʌlʌ. Ch'oyol ti Samaria jini winic. ");
INSERT INTO ctu76_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Che' jini Jesús ti yʌlʌ: ¿Mach'a ba'an diez ti lajmisʌnti? ¿Baqui an jini yambʌ nueve? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jin jach ba jini ñajt bʌ ch'oyol bʌ winic ti cha' sujti tyʌlel cha'an i sube' i ñuclel Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Che' jini Jesús ti' sube jini winic. Tyejchen. Cucux. Tsa'ix lajmiyet cha'an ti a ch'ujbiyon ti a pusic'al. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jini fariseojob ti' c'ajtibeyob Jesús baqui bʌ ora mi quejel i cha'len yumʌl Dios. Jesús ti' subeyob: Mach tsiquil ti la' wut mi quejel i cha'len yumʌl Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mach'an mi quejel i yʌle': Wʌ'an wʌ'wʌ'i o mi ya'an ya'ya'i. Como chʌncol ti yumʌl Dios wʌ' ba' añetla, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Che' jini Jesús ti' sube ajcʌnt'añob i cha'an: Tyal i yorojlel che' la' wom la' wersa q'uelon i Pi'ʌlon bʌ Quixtyañujob aunque jump'ej jach q'uin. Pero mach'an mi quejel la' wa' ilañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mi quejel la' subentyel: Wʌ'an wʌ'wʌ'i o mi ya'an ya'ya'i, che'ob. Pero mach yom mi la' lolon majlel la' q'uele'. Mach yom mi la' lolon tsʌclen majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Como che' bajche' ñoj tsiquil mi lejmel i c'ʌc'al chajc c'ʌlʌ ti junwejl chan c'ʌlʌ ti yambʌ junwejl chʌ'ʌch wen tsiquil che' mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob che' ti jini q'uin che' mic cha' tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero ñaxan wersa mic wen ñusan wocol yic'ot mi quejel i mich'q'ueloñob quixtyañujob año' bʌ wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Che' lajal bajche' ti ujti che' ñac wʌ'an ti mulawil Noé bʌ i c'aba', chʌ'ʌch je'el mi quejel i yujtyel ti yorojlel che' mic cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ti' cha'leyob uch'el. Ti' pʌyʌyob i yijñamob. Ti' sijiñob yalobilob c'ʌlʌ jintyo ti ochi Noé ti barco bʌ otyot. Ti queji but' ja'. Ti lu' jiliyob ti ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chʌ'ʌch je'el ti ujti che' ñac wʌ'an ti mulawil jini winic Lot bʌ i c'aba'. Ti' cha'leyob uch'el. Ti' cha'leyob mʌñoñel choñoñel. Ti' cha'leyob pac'. Ti' meleyob i yotyot tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero che' ñac ti loq'ui majlel Lot ti jini lum Sodoma bʌ i c'aba' ti yajli c'ajc yic'ot azufre ti chan. Ti lu' tsʌnsʌntiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Chʌ'ʌch mi quejel i yujtyel je'el che' mi quejel c tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ti jim bʌ q'uin mi an majch ya'an ti pam pamacña bʌ i jol otyot mach yom jubic cha'an i ch'ʌme' loq'uel chʌ bʌ an i cha'an. Mi an majch an ti cholel mach yom i cha' sujtyel ti yotyot cha'an i ch'ʌme' loq'uel chʌ bʌ an i cha'an ya' ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","C'ajtisanla bajche' ti ujti yic'ot yijñam Lot bajche' ti wa' aq'uenti i xote' i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jini yom bʌ i cha'len chʌ bʌ bajñel yom i pusic'al cha'an chʌncol i bajñel p'untyan i bʌ mi quejel i sʌt i bʌ. Jini mach'ʌ ba'an mi' bajñel p'untyan i bʌ mu' bʌ i yʌc' i bʌ cha'an i mele' chʌ bʌ yom Dios mi quejel i cʌñʌtyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mic subeñetla: Ti jim bʌ ac'bʌlel che' mic cha' tyʌlel an cha'tiquil ti jump'ej wʌyibʌl. Juntiquil mi quejel i pʌjyel majlel. Yambʌ mi quejel i cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ti jim bʌ ora an cha'tiquil x'ixicob chʌncol bʌ i motin cha'leñob juch'bal. Juntiquil mi quejel i pʌjyel majlel. Yambʌ mi quejel i cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Cha'tiquil winicob añob ti jump'ej cholel. Juntiquil mi quejel i pʌjyel majlel. Yambʌ mi quejel i cʌytyʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Che' ñac ti yubiyob jini t'an ti' c'ajtibeyob: C Yum, ¿baqui ora mi quejel i yujtyel jini? che'ob. Jesús ti' jac'beyob: Ya' ba'an bʌc'tyalʌl ya'i mi quejel i much'quiñob i bʌ xtya'jol. Che' ti' cha'le lajoñel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús ti' subeyob ajcʌnt'añob i cha'an jump'ej lajoñel cha'an i cʌntisañob cha'an yom i chʌc cha'leñob oración. Mach yom lujb'acob ti oración. ");
INSERT INTO ctu76_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ti' subeyob: An ti jump'ej lum juntiquil juez mach'ʌ ba'an ti' bʌc'ñʌ Dios yic'ot mach'an ti' q'uele ti ñuc quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ya'an je'el ti jini jach bʌ lum juntiquil meba' 'ixic tsa' bʌ bele' majli ba'an jini juez cha'an i c'ajtin i cotyʌntyel cha'an i mele' jini chʌncol bʌ i contrajin. ");
INSERT INTO ctu76_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ti ñumi cabʌl ora che' mach yom i cotyan jini meba' 'ixic jini juez. Pero ti wi'il ti queji i pensalin: Aunque mach'an mic bʌc'ñan Dios aunque mach'an mic q'uel ti ñuc quixtyañujob, ");
INSERT INTO ctu76_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero cha'an mach'an mi' bej tyʌc'lañon jini meba' 'ixic mi quejel j cotyan cha'an mach'an mi bej tyʌlel yic'ot mach'an mic bo'yel, che' ti yʌlʌ jini juez. ");
INSERT INTO ctu76_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Lac Yum ti yʌlʌ: Jiñʌch tsa' bʌ i yʌlʌ jini simaron bʌ juez. ");
INSERT INTO ctu76_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Mach'a ba'an mi quejel i más cotyan Dios jini yajcʌbilo' bʌ i cha'an mu' bʌ i pejcan Dios ti q'uinil ti ac'bʌlel? ¿Jal tyo ba mi quejel i pijtyan Dios i cotyañob? ");
INSERT INTO ctu76_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mic subeñetla: Dios mi quejel i wa' cotyañob i cha'añob. Pero che' mi quejel c cha' tyʌlel Joñon i Pi'ʌlon bʌ Quixtyañujob, ¿mu' tyo ba c tyaje' jini mu' bʌ i bej ch'ujbiñon? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús ti' subeyob yambʌ lajoñel cha'an jini tsa' bʌ i lolon q'uele i bʌ ti wen bʌ quixtyañu pero ti mich'q'uele yaño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jesús ti yʌlʌ: Cha'tiquil winicob ti majliyob ti oración ti colem templo. Juntiquil fariseo bʌ. Jini yambʌ juntiquil xch'ʌm tyojoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jini fariseo bʌ winic ti wa'le ya' ti templo. Ti oración ti yʌlʌ: Dios, mic subeñet wocox a wʌlʌ como mach che'ic añon bajche' yaño' bʌ mu' bʌ i cha'leñob xujch', simaronlel yic'ot mu' bʌ i pejcan yambʌ x'ixic mi añonic bajche' ili xch'ʌm tyojoñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Cha'yajlel ti jujump'ej semana mic ch'ajban mu' bʌ j c'ux mu' bʌ cap. Mi cʌq'ueñet jump'ej loq'uem bʌ ti diez tyac mu' bʌ c ganarin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero jini xch'ʌm tyojoñel ñajti wa'al mach'ʌ ba'an ti letsʌ i wut ti chan pero ti' jats'ʌ i tyajn. Ti yʌlʌ: Dios, p'untyañon, xmulilon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Mic subeñetla: Jini xch'ʌm tyojoñel ti q'uejli ti tyoj ti Dios che' ñac ti sujti majlel ti yotyot. Pero mach che'ic jini fariseo. Como jini mu' bʌ i pʌt i bʌ ti ñuc mi quejel i ju'sʌntyel. Pero jini mu' bʌ i ju'san i bʌ mi quejel i ñuc isʌntyel. Che' ti' cha'le cʌntisʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Quixtyañujob ti' pʌyʌyob majlel je'el alp'eñalob ya' ba'an Jesús cha'an mi yʌc' i c'ʌb ti' pam i bʌc'tyal. Pero che' ñac ti yilʌ jini ajcʌnt'añob i cha'an Jesús ti queji i tic'ob jini tsa' bʌ i pʌyʌyob tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús ti' pʌyʌ ajcʌnt'añob i cha'an. Ti' subeyob: La' tyʌlicob ba' añon jini alp'eñalob. Mach la' tic'ob como jiñobʌch mu' bʌ i yumin Dios mi yajñel bajche' iliyi, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ubinla bajche' mic subeñetla: Jini yom bʌ i yochel ti yumintyel Dios la' i mel i bʌ bajche' juntiquil alʌl. Jini mach'ʌ ba'an mi' cha'len bajche' jini mach ch'ujbi ochic, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Juntiquil am bʌ i ye'tyel ti' c'ajtibe Jesús: Weñet bʌ Maestro, ¿chuqui yom c cha'len cha'an c tyaje' j cuxtyʌlel mach'ʌ yujil jilel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús ti' sube: ¿Chucoch mi a wʌle' mi weñon? An jach juntiquil wen bʌ jiñʌch Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","A wujil jini mandar tyac: Mach a pejcan yambʌ x'ixic. Mach a cha'len tsʌnsa. Mach a cha'len xujch'. Mach a jop'en i mul a pi'ʌl. Ac'ʌ ti ñuc a tyat, a ña', che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jini winic ti' sube Jesús: Tsa'ʌch c lu' ch'ujbi c'ʌlʌ che' ñac alʌlon tyo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Che' ñac ti yubi Jesús i t'an ti' sube: An tyo yom a mele' yambʌ junchajp. Lu' choño pejtyelel chʌ bʌ yes an a cha'an. Aq'ueñob jini p'ump'uño' bʌ. Mi chʌ'ʌch ma' cha'len mi quejel a tyaje' cabʌl chʌ bʌ an a cha'an ya' ti panchan. Che' jini, la', tsʌcleñon majlel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero che' ñac ti yubi ili t'an jini winic wen ch'ʌjyem ti yubi como an cabʌl chʌ bʌ an i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Che' ñac ti yilʌ Jesús che' ch'ʌjyem jini winic ti yʌlʌ: Wen wocol mi yochel ti yumintyel Dios jini rico bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más wocol mi yochel jini rico bʌ quixtyañu ba' mi' cha'len yumʌl Dios bajche' mi ñumel juncojt colem animal camello bʌ i c'aba' ti i ch'ub junts'ijt acuxan, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Che' jini, jini tsa' bʌ yubiyob i t'an Jesús ti yʌlʌyob: ¿Majchqui ch'ujbi i tyaje' i cotyʌntyel, che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús ti' subeyob: Winicob mach ch'ujbi i cha'leñob. Pero Dios ch'ujbiyʌch i lu' cha'len. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro ti' sube Jesús: Joñon lojon tsa'ix c lu' cʌyʌ lojon ti pejtyelel chʌ bʌ an lojon c cha'an cha'an lojon c tsʌcleñet majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Che' jini, Jesús ti' jac'beyob: Melel mic subeñetla, che' an majch mi' cʌye' i yotyot, mi i tyat i ña', mi i yʌscuñob, i chichob, mi yijts'iñob, mi yijñam, mi i yalobilob cha'an ti caj mi yumin Dios ");
INSERT INTO ctu76_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","más ñumen tyo mi quejel i yʌq'uentyel wʌ' ti ili mulawil, che' bajche' tsa' bʌ i cʌyʌ. Ti tyal tyo bʌ ora mi yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús ti' bajñel pʌyʌ majlel jini doce ajcʌnt'añob i cha'an: Ti' subeyob: Wale mi quejel lac majlel ti Jerusalén ba' mi quejel i lu' ts'ʌctisʌntyel tsa' bʌ wʌ alʌyob jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix. Ti' wʌ ts'ijbuyob bajche' mi quej cujtyel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mi quejel cʌjq'uel ti i c'ʌb jini mach'ʌ israelob. Mi quejel i wajleñoñob. Mi quejel i p'ajoñob. Mi quejel i tyujbañoñob. ");
INSERT INTO ctu76_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mi quejel i jats'oñob. Ti wi'il mi quejel i tsʌnsañoñob. Pero ti yuxp'ejlel q'uin mi quejel c cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero mach'an ti' ch'ʌmbeyob isujm chʌ bʌ yes chʌncol i yʌle' Jesús. Mach'an ti' saj ña'tyʌyob chʌ bʌ ti' tyaja ti i t'an Jesús. Como che' bajche' mach ch'ujbi i ch'ʌm'eñob isujm. ");
INSERT INTO ctu76_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Che' ñac muq'uix i quejel i c'otyel Jesús ti lum Jericó bʌ i c'aba' ya' ti' tyaja juntiquil muts'ul bʌ i wut. Ya' buchul ya' ti bij. Chʌncol i c'ajtin majtyan tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Che' ñac ti yubi jini muts'ul bʌ i wut chʌncol i ñumel cabʌl quixtyañu ti' c'ajtibeyob chʌ bʌ chʌncol i yujtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ti' subeyob cha'an chʌncol i ñumel Jesús ch'oyol bʌ ti Nazaret. ");
INSERT INTO ctu76_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Che' jini ti' cha'le c'am bʌ t'an jini muts'ul bʌ i wut: Jesús i jiñʌjlelet bʌ David, p'untyañon cha'an ma' cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jini chʌncol bʌ i ñaxan ñumelob ti' tiq'uiyob jini muts'ul bʌ i wut cha'an mi lajmel ti t'an. Pero más c'am ti queji ti t'an. I jiñʌjlelet bʌ David, p'untyañon cha'an ma' cotyañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Che' jini ti' cʌyʌ xʌmbal Jesús. Ti' xiq'uiyob cha'an i pʌye' tyʌlel jini muts'ul bʌ i wut. Che' ñac lʌc'ʌl i c'otyel, Jesús ti' c'ajtibe: ");
INSERT INTO ctu76_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Chuquiyes a wom mic melbeñet? Che' ti yʌlʌ Jesús. Jini muts'ul bʌ i wut ti' jac'ʌ: C Yum, com j q'uele' pañimil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús ti' sube: Q'uele pañimil. Ti lajmiyet cha'an ti a ch'ujbi cha'an an c p'ʌtyʌlel cha'an mic lajmisañet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ti jin jach bʌ ora ti wa' c'oti i wut jini winic. Ti' tsʌcle majlel Jesús. Ti' subu i ñuclel Dios. Ti pejtyelel quixtyañujob tsa' bʌ i yilʌyob jini ti' subeyob i ñuclel Dios je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Che' jini, ti ochi majlel Jesús ti lum Jericó bʌ i c'aba'. Ti bej ñumi majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ya'an juntiquil rico bʌ winic Zaqueo i c'aba'. An i ye'tyel cha'an ch'ʌm tyojoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jini Zaqueo yom i q'uele' Jesús cha'an i cʌñe'. Pero mach ch'ujbi i yilan como ya'an cabʌl quixtyañu. Pec' jach jini Zaqueo. ");
INSERT INTO ctu76_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Che' jini, ajñel ti majli Zaqueo. Ti letsi ti juntyejc tye' sicómoro bʌ i c'aba' cha'an i q'uele' Jesús como mi quejel i ñumel Jesús ya' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Che' ñac Jesús ti ñumi ya' ba'an jini tye' ti' q'uele letsel. Ti yilʌ Zaqueo. Ti' sube: Zaqueo, juben ti ora como wale iliyi an cha'an poj ajnicon ti a wotyot, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Che' jini, Zaqueo ti wa' jubi. C'ajacña yoj ti' pʌyʌ majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Che' ñac ti yilʌyob ti pejtyelelob ti queji i tyajob ti t'an Jesús. Ti yʌlʌyob: Tsa'ix majli ti jijlel Jesús ya' ti yotyot juntiquil xmulil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Che' jini ti wa'le Zaqueo ba'an lac Yum. Ti' sube: Q'uele awilan, c Yum, mi quejel cʌq'uen p'ump'uño' bʌ t'oxol ti pejtyelel chʌ bʌ an c cha'an. Mi tic lolon chilbe i cha'an quixtyañu mi quejel c cha' sutquiben chʌnyaj i ñumeñal, che' ti yʌlʌ Zaqueo. ");
INSERT INTO ctu76_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús ti' sube: Wale iliyi tsa'ix cotyʌnti jini am bʌ ti ili otyot. Como loq'uemet je'el ti jiñʌjlel Abraham. ");
INSERT INTO ctu76_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Jin cha'an ti tyʌliyon Joñon i Pi'ʌlon bʌ Quixtyañujob cha'an c sʌclan cha'an j cotyan xmulilob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Che' chʌncol tyo i ñʌch'tyañob i t'an Jesús quixtyañujob che' chʌncol i yʌle' ili tyac ti' subeyob yambʌ lajoñel. Como lʌc'ʌlix añob ti Jerusalén. Ti' pensali quixtyañujob cha'an i yorojlelix i cha'len yumʌl Dios ya' ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Che' jini Jesús ti' subeyob: An juntiquil winic mu' bʌ i q'uejlel ti ñuc. Ti majli i yʌq'uentyel i ye'tyel ti yumʌl. Che' jini mi quejel i cha' julel. ");
INSERT INTO ctu76_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Che' ñac max tyo maj, ti' ñaxan pʌyʌ diez ajtroñelob i cha'an. Ti yʌq'ue ti i wenta ti jujuntiquil junwejch tyaq'uin wen lets bʌ i tyojol. Ti' subeyob: Cha'lenla ganar yic'ot ili tyaq'uin jintyo mic cha' tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero jini quixtyañujob ti i lumal ti' mich'q'ueleyob jini winic mu' bʌ quejel i yʌq'uentyel i ye'tyel. Ti wi'il ti' chocoyob majlel t'an ya' ba' mi quejel i yʌq'uentyel i ye'tyel. Ti yʌlʌyob: Mach com lojon ochic ili winic ti yumʌl lojon c cha'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero ti aq'uenti i ye'tyel. Ti cha' sujti majlel ti i lumal. Che' ñac ti cha' c'oti ti' xiq'ui ti pʌyol jini ajtroñelob i cha'an tsa' bʌ aq'uentiyob tyaq'uin cha'an i yubin bajche' yonlel ti ganari ti jujuntiquil. ");
INSERT INTO ctu76_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jini ñaxan bʌ ti c'oti. Ti' sube i yum: C Yum, tij ganari yambʌ diez ti a tyaq'uin, che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jini yumʌl ti' jac'ʌ: Weñʌch bajche' ti a cha'le. Wen bʌ ajtroñelet cha'an xuc'ulet ti a cha'le ti jini saj jach bʌ tsa' bʌ cʌq'uet. Wale mi quejel cotsañet cha'an a wentajin diez lum, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ti c'oti yambʌ. Ti yʌlʌ: C yum, tij ganari yambʌ jo'wejch ti a tyaq'uin, che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jini ajtroñel je'el ti subenti: Wale mi quejel cotsañet cha'an a wentajin jo'p'ej lum, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Che' jini yambʌ ti c'oti ba'an i yum. Ti' sube: C yum, umba'an a tyaq'uin. Tic lotyo ti jump'och cajchilʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tic bʌc'ñʌyet como bʌc'ñʌbilet bʌ quixtyañu. Ma' ch'ʌme' mach bʌ ba'an a cha'an. Ma' wʌc' ti c'ajol mach bʌ ba'an ti a pʌc'ʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Che' jini, jini yumʌl ti' sube: Simaron bʌ ajtroñelet cha'an ti mismo jiñʌch a bajñel t'an mi quejel c melet, che'en. Mi wʌ awujil isujm bʌc'ñʌbilon bʌ quixtyañu, ma' wʌ ña'tyan mic ch'ʌme' mach'ʌ ba'an c cha'an, mij c'aje' mach'ʌ ba'an tic pʌc'ʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Chucoch, mach'an ti a wʌc'ʌ c tyaq'uin ba' mi' cha'len ganar cha'an mic ch'ʌme' c tyaq'uin yic'ot i jol che' mic cha' julel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jini yumʌl ti' subeyob jini ya' bʌ añob: Ch'ʌm'en jini tyaq'uin. Aq'uen jini am bʌ diez i cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ti' cha' subeyob i yum: C yum, pero añʌch diez i tyaq'uin, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jini yumʌl ti' jac'ʌ: Mic subeñetla jini am bʌ i cha'an mi yʌq'uentyel yambʌ. Pero jini mach'ʌ ba'an i cha'an mi lu' chilbentyel jini i saj jach bʌ i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pʌyʌla tyʌlel jini j contra mach'ʌ yom i q'uele' che' yumʌlon. Tsʌnsañob wʌ' ba'añon, che'en, che' ti yʌlʌ jini yumʌl. Che' ti' cha'le cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Che' ti ujti i yʌle' ili t'an Jesús, ti bej majli ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Che' lʌc'ʌl mach c'ot ti lum tyac Betfagé yic'ot Betania bʌ i c'aba' lʌc'ʌl ya' ti wits Olivajol bʌ i c'aba' Jesús ti' choco majlel cha'tiquil ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Jesús ti' subeyob jini cha'tiquil: Cucuxla ya' ti saj lum ya' bʌ an lʌc'ʌl. Che' mi la' c'otyel ti ti' lum mi quejel la' tyaje' cot cʌchʌl juncojt ts'ijib burro. Tiquila. Pʌyʌla tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Mi an majch mi' subeñetla: ¿Chucoch mi la' tique'? che'qui. Subenla: Yom i c'ʌñe' lojon c Yum, che' yom mi la' suben, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jini ajcʌnt'añob i cha'an Jesús ti majliyob. Ya' ti' tyajayob bajche' ti' wʌ subeyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Che' ñac chʌncol i ticob jini burro i yum burro ti' c'ajtibeyob: ¿Chucoch mi la' tique'? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jini ajcʌnt'añob ti' jac'ʌyob: Yom i c'ʌñe' lojon c Yum, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ti' pʌyʌyob majlel jini burro ya' ba'an Jesús. Ti' tyasibeyob i pat ti i pislelob. Ti' c'ʌchchocoyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Che' ya' c'ʌchʌl majlel Jesús ti' tyʌsʌyob majlel i pislel ya' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Che' chʌncol i lʌq'ue' majlel ya' ti ye' wits Olivajol bʌ i c'aba' ti pejtyelel chʌncol bʌ i ch'ujbiñob chʌncol bʌ i tsʌcleñob majlel Jesús ti yʌlʌyob ti c'am bʌ t'an cha'an c'ajacña i yoj. Ti' subeyob i ñuclel Dios cha'an pejtyelel jini ñuc tyac bʌ i p'ʌtyʌlel tsa' bʌ i pʌsʌ Jesús tsa' bʌ i yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ti yʌlʌyob: Tijicñayet jatyet Yumʌlet bʌ mu' bʌ a tyʌlel cha'an che' yom lac Yum Dios. La' ñʌch'lec i pusic'al ya' bʌ añob ti panchan. La' sujbic i ñuclel Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Che' jini ya'an fariseojob je'el. Ti yʌlʌyob: Maestro, tiq'ui jini chʌncol bʌ i tsʌcleñet majlel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús ti' jac'beyob: Mic subeñetla, mi ti ñʌch'leyob ili quixtyañujob mi quejelob ti oñel jini tyun tyac, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Che' ñac lʌc'ʌlix an ti Jerusalén che' ñac ti yilʌ Jesús jini lum ti yuc'tyʌ jini año' bʌ ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ti yʌlʌ Jesús: Tsa'iqui la' ch'ʌmbe isujm mi jim bʌ q'uin iliyi bajche' ch'ujbi la' tyaje' i ñʌch'tyʌlel la' pusic'al. Pero wale ma'ix mi quejel la' saj aq'uentyel la' ña'tyan. ");
INSERT INTO ctu76_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Como tyal wocol tyac bʌ q'uin che' mi quejel i joy mejlel i ts'ajquil a lum cha'an ti la' contrajob cha'an mach ch'ujbi la' loq'uel majlel. Mi quejel i joy mʌctyañetla. Mi quejel i cha'len guerra ti la' contra. ");
INSERT INTO ctu76_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mi quejel i jisʌntyel la' lum. Mi quejel i tsʌnsʌntyel pejtyelel ajchumtyʌl. Ma'ix mi cʌytyʌl jump'ej tyun ti pam yambʌ tyun. Como mach'an ti la' ña'tyʌ che' ñac yom i cotyañetla Dios, che' ti wʌ alʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Che' jini ti c'oti Jesús ti pat templo. Ti queji i chocob loq'uel jini mu' bʌ i chon mu' bʌ i mʌn. ");
INSERT INTO ctu76_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Jesús ti' subeyob: Ti Ts'ijbubil bʌ i T'an Dios mi yʌle': Jini cotyot i yotyotlel oración, che'en. Pero jatyetla tsa'ix la' sutqui ti yotyotlel ajxujch'ob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ti bele' q'uin ti' cha'le cʌntisa Jesús ya' ti templo pero jini ñuco' bʌ cura i cha'an bʌ israelob yic'ot jini ajcʌntisajob cha'an i mandar, yic'ot je'el jini año' bʌ i ye'tyel ti lum ti' sʌclʌyob bajche' ch'ujbi i tsʌnsañob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mach'an ti' tyajayob bajche' ch'ujbi i tsʌnsañob como jini yambʌ quixtyañujob mi' wen ñʌch'tyʌbeñob i t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Junyajlel che' ñac ti' cʌntisʌ quixtyañujob Jesús ya' ti pat templo ti' subeyob jini t'an cha'an laj cotyʌntyel. Che' jini, ti c'oti ñuco' bʌ curajob i cha'an bʌ israelob yic'ot ajcʌntisajob cha'an i mandar yic'ot xñoxob año' bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ti' c'ajtibeyob Jesús: ¿Baqui tyʌlem a we'tyel cha'an ma' niq'ui cha'len jini mu' bʌ a cha'len? ¿Majchqui ti yʌq'uet ili a we'tyel cha'an ma' niq'ui mele'? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Che' jini, Jesús ti' subeyob: Joñon je'el an chʌ bʌ com j c'ajtibeñetla. Subeñon: ");
INSERT INTO ctu76_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Majchqui ti' xiq'ui Juan tsa' bʌ i yʌc'ʌ ch'ʌm ja', Dios ba o quixtyañujob? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero ti queji i bajñel subeñob i bʌ. ¿Chuqui yom la cʌle'? Mi ti la cʌlʌ Dios ti' xiq'ui cho'onla, mi quejel i cha' c'ajtibeñonla: ¿Chucoch mach'an ti lac ch'ujbibe? Che' mi quej i yʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mi ti la cʌlʌ winicob ti' xiq'ui, mi cho'onla, pejtyelel quixtyañu mi quejel i julonla ti tyun jintyo mi lac sajtyel. Como mi lu' ña'tyañob Dios ti' xiq'ui tyʌlel jini Juan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jin cha'an ti' subeyob Jesús: Mach cujil lojon isujm majchqui ti' xiq'ui cha'an i yʌq'ue' ch'ʌm ja' jini Juan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Che' jini, Jesús ti' subeyob: Chʌ'ʌch joñon je'el mach c subetla ba' ch'oyol i p'ʌtyʌlel c t'an cha'an c cha'len tyac iliyi. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ti wi'il Jesús ti queji i pejcan quixtyañujob. Ti' subeyob jini lajoñel: An juntiquil winic ti' pʌc'ʌ ts'ujsubol. Ti wi'il ti yʌq'ueyob ti majñʌntyel ti ajcʌñʌtya ts'ujsubol. Ti majli ti yambʌ pañimil. Ya' ti wen jale. ");
INSERT INTO ctu76_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Che' ñac i yorojlel i tyuc'ob ts'ujsub ti' choco majlel i yajtroñel ya' ba'an ajcʌñʌtya ts'ujsubol cha'an mi' t'ox ch'ʌm'en i wut bajche' ti wʌ alʌyob. Pero jini ajcʌñʌtya ts'ujsubol ti' jats'ʌyob. Che' jach ti' tyojo chocoyob sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Che' jini, i yum jini ts'ujsubol ti' cha' choco majlel yambʌ i yajtroñel. Pero chʌ'ʌch je'el ti' wajleyob. Ti' jats'ʌyob. Ti' cha' tyojo chocoyob sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Che' jini i yum ts'ujsubol ti' cha' choco majlel yambʌ i yajtroñel. Pero jini ajcʌñʌtya ts'ujsub ti' lowoyob je'el. Ti' chocoyob loq'uel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Che' jini, i yum ts'ujsubol ti yʌlʌ: ¿Chuquiyes yom c cha'len? Mi quejel c choque' majlel calobil mu' bʌ c wen p'untyan. Che' mi yilañob mi quejel i q'uelob ti ñuc, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero che' ñac ti yilʌyob jini i yalobil i yum ts'ujsubol, jini ajtroñelob ti' subeyob i bʌ: Jiñʌch mu' bʌ i quejel i yochel ti' yum ili ts'ujsubol. La' lac tsʌnsan. Che' jini mi quejel lac ch'ʌme' ili ts'ujsubol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Che' jini ti' loc'sʌyob ya' ti ts'ujsubol. Ti' tsʌnsʌyob. Che' jini, Jesús ti' c'ajtibeyob: ¿Chuquiyes mi quejel i cha'len i yum ts'ujsubol yic'otyob jini ajcʌñʌtya ts'ujsub? ");
INSERT INTO ctu76_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Mi quejel i tyʌlel, mi quejel i tsʌnsañob ili ajcʌñʌtya ts'ujsub. Mi quejel i yʌq'uen ts'ujsubol ti' wenta yaño' bʌ. Che' ti yubiyob ili t'an, ti yʌlʌyob: Mach che'ic yom Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús ti' ch'uj q'ueleyob. Ti yʌlʌ: ¿Chuqui yom i yʌle' jini Ts'ijbubil bʌ i t'an Dios, che' jini? Mi yʌle': Jini tyun tsa' bʌ i chocoyob ajmel tyun bʌ otyot ti ochi che' bajche' i yoyel ti i xujc otyot. ");
INSERT INTO ctu76_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Majchical jach mi yajlel ti pam jini tyun mi quejel i bic'tiyel yubil. Pero mi ti yajli jini tyun ti' pam quixtyañu mi quejel i jujch'e' bajche' ts'ubejn yubil. Che' ti yʌlʌ Jesús ti lajoñel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jini ñuco' bʌ curajob i cha'an israelob yic'ot ajcʌntisajob cha'an i mandar yom i chucob Jesús ti jim bʌ ora como yujilob isujm Jesús ti' tyajayob ti lajoñel bʌ t'an. Pero mi i bʌc'ñan jini quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jin cha'an ti' chocoyob majlel ajñʌch'tya t'an ya' ba'an Jesús. Ti' lolon pʌsʌyob i bʌ ti wen bʌ quixtyañu cha'an mi' tyajbeñob i mul Jesús ti i t'an cha'an mi yʌc'ob ti i c'ʌb jini am bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jin cha'an ti' c'ajtibeyob Jesús: Maestro, cujil lojon isujm ma' wʌle' ma' cʌntisan wen bʌ. Mach juntiquilic jach ma' más p'untyan. Ma' cʌntisan ti melel bʌ t'an i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Subeñon lojon: ¿Yom ba mi la cʌq'uen tyojoñel ñuc bʌ yumʌl o mach yom? che' ti c'ajtibenti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús yujil isujm cha'an jach yom i jop'ben i mul. Che' jini, ti' subeyob: ¿Chucoch mi la' sʌclʌbeñon c mul? ");
INSERT INTO ctu76_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Pʌs'eñon junwejch tyaq'uin. ¿Majchqui i loc'om wʌ' bʌ an ti tyaq'uin? ¿Majchqui i c'aba' wʌ' bʌ ts'ijbubil? Che' ti yʌlʌ Jesús. Ti' jac'ʌyob: I cha'an yumʌl, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Che' jini, ti' jac'ʌ Jesús: Aq'uenla ñuc bʌ yumʌl jini yom bʌ aq'uentic. Aq'uenla Dios jini yom bʌ aq'uentic Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mach'an ti mejli i tyajben i mul Jesús ti' tyojlel quixtyañujob. Pero tyoj bʌc'ñʌjelob che' ti yubiyob. Ti ñʌch'leyob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ti wi'il ti c'oti cha'tiquil uxtiquil saduceojob ba'an Jesús. Jiñʌch mu' bʌ i yʌlob mach'an mi lac cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Ti' c'ajtibeyob Jesús: ");
INSERT INTO ctu76_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Maestro, Moisés ti' cʌybeyonla ts'ijbubil bʌ mandar cha'an bajche' mi' cha'len mi ti sajti juntiquil winic mi ti bajñel cʌyle i yijñam che' max tyo ba'an i yalobil. Ti yʌlʌ yom mi' wersa pʌyben i yijñam i yʌscun jini ijts'iñʌl bʌ cha'an anic i yalobil cha'an i tyejch'en i jiñʌjlel jini tsa' bʌ sajti, che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Che' jini, an siete winicob yoque i yijts'iñob i bʌ. Ti' pʌyʌ i yijñam jini ascuñʌl bʌ. Ti sajti che' max tyo ba'an i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Che' jini i cha'ticlel i yijts'in ti' pʌybe i yijñam yʌscun. Jini winic ti sajti je'el che' ñac max tyo ba'an i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Che' jini i uxticlel bʌ i yijts'in ti' pʌybe i yijñam i yʌscun. Chʌ'ʌch je'el c'ʌlʌ ti sietejlelob. Mach'an mi junticlec i yalobil, ti sajtiyob ti' sietejlel jini winicob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Che' jini, ti sajti jini x'ixic je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Che' ti yorojlel mi cha' tyejchelob jini sajtyemo' bʌ, ¿majchqui i ñoxi'al jini x'ixic ma' wʌl? como ti' sietejlelob ti' pʌyʌyob cha'an i yijñam, che' ti yʌlʌyob jini saduceojob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Che' jini Jesús ti' jac'beyob: Wʌ' ti mulawil mi' pʌyob i bʌ winicob x'ixicob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero jini mu' bʌ q'uejel ti wen cha'an xuc'ul mi yajñel ti tyal tyo bʌ ora mi quejel i tyejchelob loq'uel ba'an sajtyemo' bʌ. Ya'i mach'an mi quejel i tyajob i bʌ. Mach'an mi' sijiñob i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Como mach ch'ujbi i cha' sajtyel. Mi quejel i yajñel bajche' ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan. Cha'an ti tyejchiyob loq'uel ba'an sajtyemo' bʌ mi yajñelob ti i yalobil Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jinic tyo Moisés i bajñel mi yʌq'ueñonla lac ch'ʌm'en isujm cha'an mi cha' tyejchel loq'uel sajtyemo' bʌ cha'an ti jini t'an cha'an jini pimel tsa' bʌ i yilʌ ti lejmi mach'ʌ ba'an ti jili. Ya'i ti jini t'an mi' tsictisan lac Yum i Dios Abraham, i Dios Isaac, yic'ot i Dios Jacob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pero Dios mach i Diosic jini sajtyemo' bʌ. I Dios cuxulo' bʌ aunque sajtyem i bʌc'tyal pero cuxul i ch'ujlel. Lu' cuxulob mi yilan Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Che' jini, cha'tiquil uxtiquil ajcʌntisajob cha'an i mandar israelob ti' subeyob Jesús: Maestro, weñʌch bajche' ti a jac'ʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma'an majch ti' cha' jop'o i c'ajtiben Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús ti' subeyob: ¿Bajche'qui isujm che' mi yʌlob mi i jiñʌjlel David jini Cristo jini yajcʌbil bʌ i cha'an Dios? ");
INSERT INTO ctu76_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Como David i bajñel ti yʌlʌ ti jun Salmos bʌ i c'aba': Jini lac Yum ti' sube jini c yum: Buchi' tic ñoj ");
INSERT INTO ctu76_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jintyo mi cʌq'ueñet a jisan i p'ʌtyʌlel a contrajob. Che' ti wʌ subenti Jesús ti Dios ti Salmos. ");
INSERT INTO ctu76_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Bajche'qui ch'ujbi che' i jiñʌjlelon David jini Cristo che' David ti yʌlʌ Cristo ti' yum? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ti pejtyelel quixtyañujob ti' ñʌch'tyʌbeyob i t'an Jesús che' ñac Jesús ti' subeyob ajcʌnt'añob i cha'an: ");
INSERT INTO ctu76_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Cʌñʌtyan la' bʌ cha'an jini ajcʌntisajob cha'an mandar como mi' mulañob i wen ch'ʌlob i bʌ ti tyam bʌ i pislel che' mi majlelob ti xʌmbal. Mi' mulañob che' cabʌl mi pejcʌntyel ya' ti xinil lum. Mi yajcan jini más wen bʌ tyac buchlibʌl ya' ti i templo israelob yic'ot más wen bʌ buchlibʌl ti q'uiñejel. ");
INSERT INTO ctu76_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Che' je'el mi' chilbeñob i lum jini meba' 'ixicob. Mi' melob tyam tyac bʌ oración cha'an wen mi yilʌntyel. Jiñʌch más bʌbʌq'uen bʌ mi quejel i yʌq'uentyelob i xot'ob i mul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús ti yilʌ bajche' ti yotsʌyob tyaq'uin jini ricojo' bʌ ya' ti yajnib ofrenda ya' ti colem templo. ");
INSERT INTO ctu76_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ti yilʌ je'el juntiquil meba' 'ixic mach'ʌ ba'an chʌ bʌ an i cha'an. Ti yotsʌ cha'wejch tyaq'uin i saj jach bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesús ti yʌlʌ: Ubinla mic subeñetla, ili p'ump'un bʌ meba' 'ixic más on ti yotsʌ yubil bajche' ti pejtyelel jini yaño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Como jini yaño' bʌ yoñel chʌ bʌ an i cha'an ti cʌyle. Pero jini x'ixic ma'ix chʌ bʌ an i cha'an ti cʌyle cha'an chʌ bʌ yom, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Cha'tiquil uxtiquil ti quejiyob ti t'an cha'an jini colem templo i cha'an bʌ israelob. Ti yʌlʌyob cha'an c'otyajax yic'ot cha'an c'otyajax jini tyun tyac yic'ot cha'an i majtyan tsa' bʌ ajq'ui tyac cha'an i ch'ʌjlil. Che' jini Jesús ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tyal i yorojlel mi quejel i jisʌntyel ti pejtyelel iliyi chʌncol bʌ la' wilan wale iliyi. Ma'ix mi quejel i saj cʌytyʌl mi jump'ejlic tyun ti pam yambʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Che' jini ti' c'ajtibeyob Jesús: Maestro, ¿jalajqui mi quejel i yujtyel pejtyelel jijini? ¿Chuquiyes i señʌjlel che' mi quejel i lu' ts'ʌctiyel pejtyelel jijini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús ti' subeyob: Yom wen xuc'uletla cha'an mach'an majch ch'ujbi i lotiñetla. Como mi quejelob i tyʌlel mu' bʌ quejel i c'ʌmbeñon j c'aba'. Mi quejel i yʌlob: Joñon Cristojon, che'en. Wale iliyi lʌc'ʌlix mach tyal Cristo, che'en. Pero ma' mi la' lolon tsʌcleñob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Che' mi la' wubin an cabʌl guerra yic'ot contrajiya mach yom mi la' cha'len bʌq'uen. Como chʌ'ʌch mi quejel i lu' yujtyel iliyi pero max tyo jinic i yujtibal mulawil. ");
INSERT INTO ctu76_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Che' jini ti bej alʌ Jesús: Junmujch' quixtyañu mi quejel i contrajin yambʌ junmujch' quixtyañujob. Yumʌlob yic'ot año' bʌ ti i wenta mi quejel i cha'len guerra ti i contra yambʌ yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mi quejel ñoj bʌq'uentic bʌ yujquel lum tyac. Mi quejel wi'ñal yic'ot c'am'an tyac ti cabʌl pañimil tyac. Mi quejel i yilan bʌq'uentic bʌ seña tyac ti chan yic'ot yan tyac bʌ ñuc bʌ seña tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero ñaxan tyo che' max tyo mi lu' yujtyel tyac ili mi quejel i chuquetla. Mi quejel i tyʌc'lañetla. Mi quejel i pʌyetla ti melojel ti i templo israelob. Mi quejel la' cʌjchel. Mi quejel i pʌyetla majlel ba'an ñuc bʌ yumʌlob yic'ot yambʌ ñuco' bʌ i ye'tyel cha'an tij caj. ");
INSERT INTO ctu76_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Mi quejel la' wʌc'on ti wen cʌjñel cha'an ti ili la' wocol tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Wʌ ña'tyanla cha'an ma'ix mi quejel la' chajpan bajche' mi quejel la' jaq'ue' cha'an la' cotyan la' bʌ che' ti i yorojlel melojel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Como mi quejel cʌq'ueñetla t'an yic'ot la' ña'tyʌbal bajche' ch'ujbi la' jaq'ue'. Mi jinic la' contrajob mach mej i jac'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pero mi quejel la' wʌjq'uel ti i c'ʌb la' contra. Jinic tyo la' tyat la' ña', la' wʌscuñob, la' chichob, la' wijts'iñob, la' pi'ʌlob yic'ot cʌñʌlo' bʌ la' cha'an mi yʌq'uetla ti i c'ʌb la' contrajob. An juntiquil cha'tiquiletla mi quejel la' tsʌnsʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pejtyelel quixtyañu mi quejel i ts'a'leñetla cha'an tij caj. ");
INSERT INTO ctu76_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ma'ix mi quejel i sajtyel mi junt'umic i tsutsel la' jol. ");
INSERT INTO ctu76_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mi bej xuc'uletla che' mi la' ñusan wocol mi quejel la' cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Che' mi quejel la' wilan joyol ti soldadojob jini lum Jerusalén bʌ i c'aba', ña'tyanla, che' jini, ma'ix jal mi quejel i jisʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Che' jini, jini año' bʌ ti pañimil Judea bʌ i c'aba' yom puts'ic majlel ti wits. Jini año' bʌ ti lum Jerusalén bʌ i c'aba' yom loq'uicob majlel. Jini mach'ʌ ba'an añob ti lum mach yom i cha' sujtyel majlel ti lum. ");
INSERT INTO ctu76_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Como tyal wen wocol tyac bʌ q'uin tyac cha'an ti caj i mul quixtyañujob. Mi quejel i ts'ʌctiyel pejtyelel jini ts'ijbubil tyac bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","P'ump'uñob bajche' mi quejel i ñusan wocol jini x'ixicob chʌncol tyo bʌ i cʌñʌtyan i yalobil yic'ot chʌncol tyo bʌ i tsu'sañob i yalobil. Como mi quejel wen wocol bʌ wʌ' ti mulawil cha'an ti mich'lel Dios mi quejel i yʌq'uentyel i xot'ob i mul. ");
INSERT INTO ctu76_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Juntiquil cha'tiquil mi quejel i tsʌnsʌntyelob ti guerra, yaño' bʌ mi quejel i pʌyob majlel ti cʌchol ti yambʌ pañimil tyac. Jini ñajt bʌ tyʌlemob mi quejel i ch'ʌmben ti i wenta jini lum Jerusalén bʌ i c'aba' c'ʌlʌ jintyo mi ts'ʌctiyel i yorojlel i cha'leñob jijini. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Che' jini mi quejel i tsictiyel i seña tyac ti q'uin, ti uw yic'ot ti ec' tyac. Wʌ' ti mulawil quixtyañujob mi quejel i lolon cha'len cabʌl pensal yic'ot mi' cha'len bʌq'uen cha'an wen bʌbʌq'uen bʌ pujucña bʌ ti colem ja' yic'ot cha'an jini wits'law bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jini quixtyañujob mi quejel i sajtyel ti bʌq'uen che' mi' pensalin chʌ bʌ mi quejel i yujtyel. Mi jinic tyo chan mi quejel i ñijcʌyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Che' jini mi quejel i yilan mic tyʌlel Joñon i Pi'ʌlon Quixtyañujob ti tyocal tic p'ʌtyʌlel yic'ot ti ñoj c'otyajax bʌ c ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Che' mi quejel i yujtyel pejtyel ili, tijicnisan la' bʌ. Ñuc isan la' pusic'al como lʌc'ʌlix i yorojlel la' cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Che' je'el ti' subeyob ti lajoñel: Ña'tyanla jini higuera bʌ tye' o mi ba'ic jach bʌ yambʌ tye'. ");
INSERT INTO ctu76_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Che' mi la' wilan mi ch'oc an i yopol tye' mi la' wʌ ña'tyan lʌc'ʌlix i yorojlel q'uin tyunil. ");
INSERT INTO ctu76_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Che' je'el che' mi la' wilan chʌncolix i lu' ujtyel tyac iliyi ña'tyanla lʌc'ʌlix i yorojlel i cha' tyʌlel lac Yum i cha'len yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Melel mic subeñetla mi quejel i yujtyel tyac ti pejtyelel iliyi che' max tyo ti sajtiyob ili quixtyañujob am bʌ ili ora. ");
INSERT INTO ctu76_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Mi quejl i sʌc jilel majlel jini chani yic'ot mulawil pero c t'an bʌ mach saj jil, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Xuc'uletla cha'an mach'an mi la' wʌc' ti tsʌts' an la' pusic'al cha'an ti caj la' wo' yic'ot cha'an ti caj la' q'uixñejel yic'ot cabʌl pensal cha'an cabʌl chʌ bʌ tyac an ti mulawil. Ame mi wa' c'otyel i yorojlel che' mach an mi la' saj pensalin. ");
INSERT INTO ctu76_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Che' ora jach mi tyʌlel jim bʌ q'uin i tyaje' pejtyelel quixtyañu ti petyelel mulawil che' bajche' mi wa' ñujp'el yac che' mach'an mi ña'tyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yom chajpʌbiletla. Yom mi la' chʌc cha'len oración ti pejtyelel ora cha'an mi mejlel la' puts'tyan pejtyelel jini wocol tyac bʌ mu' bʌ quejel i yujtyel. Yic'ot cha'an mi la' c'otyel tic tyojlel Joñon i Pi'ʌlon Quixtyañujob, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ti q'uinil ti' cha'le cʌntisa Jesús ti templo. Ti ac'bʌlel ti majli i ñusan ac'bʌlel ya' ti wits Olivajol bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ti wen sʌc'an tyac ti jujump'ej q'uin ti c'oti pejtyelel quixtyañujob ti templo cha'an i ñʌch'tyʌben i t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lʌc'ʌlix i yorojlel i q'uinilel pascua bʌ i c'aba' che' mi' c'uxob caxlan waj mach'ʌ ba'an mi yʌq'uen i wos i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jini ñuc bʌ curajob i cha'an israelob yic'ot ajcʌntisajob i cha'an i mandar israelob chʌncol i pejcañob i bʌ cha'an mi' sʌclan bajche' mi quejel i tsʌnsan Jesús. Como mi' bʌc'ñan quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Che' jini, Satanás ti ochi ti' pusic'al Judas mu' bʌ i pejcʌntyel ti Iscariote. Jiñʌch i pi'ʌlob jini yambʌ oncejob yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ti majli Judas ba'an ñuc bʌ curajob i cha'an israelob yic'ot ba'an am bʌ i ye'tyel ti colem templo i cha'an israelob. Ti' pejcʌyob cha'an bajche' ch'ujbi i yʌc' ti cʌchol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","C'ajacñayob i yoj che' ñac ti yubiyob i t'an Judas. Ti yʌc'ʌyob i t'an cha'an mi yʌq'ueñob tyaq'uin jini Judas. ");
INSERT INTO ctu76_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ti yʌc'ʌ i t'an cha'an i yʌq'ueñob ti i c'ʌb jini año' bʌ i ye'tyel. Ti queji i sʌclan bajche' mi yʌc' ti chucol Jesús che' mach'an tsiquil cabʌl quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ti c'oti i yorojlel i q'uiñejel che' mi' c'uxob jini caxlan waj mach'ʌ ba'an yic'ot levadura che' mi' wersa tsʌnsañob tiñʌme' che' ti pascua. ");
INSERT INTO ctu76_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús ti' xiq'ui majlel Pedro yic'ot Juan. Ti' subeyob: Cucula. Chajpan la cuch'el cha'an q'uin pascua, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ti' jac'ʌyob: ¿Baqui awom mi lojon c chajpan la cuch'el? che' ti' yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús ti' jac'ʌ: Che' ochel muq'uetla ti lum mi quejel la' tyaje' juntiquil winic chʌncol bʌ i q'ueche' majlel jump'ej uc'un ja'. Tsʌclenla majlel jintyo mi la' c'otyel ti yotyot ba' mi quejel i yochel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ya'i mi la' suben i yum otyot: Jini lojon c Maestro mi yʌl: ¿Baqui an jini saj mal ba' ch'ujbi lojon cuch'el quic'otyob ajcʌnt'año' bʌ c cha'an? che'etla, mi la' suben. ");
INSERT INTO ctu76_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Che' jini mi quejl i pʌsbeñetla saj mal ya' ti cha'lajmlel otyot. Colem, chajpʌbil i mal. Ya'i yom la' chajpan mu' bʌ quejel laj c'uxe, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ti majliyob jini ajcʌnt'añob. Ti' tyajayob che' bajche' ti yʌlʌ Jesús. Ti' chajpʌyob uch'el cha'an pascua. ");
INSERT INTO ctu76_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Che' ti c'oti i yorojlel, Jesús yic'ot jini yajcʌbil bʌ ajsubt'añob ñumel ti c'oti. Ti buchleyob ya' ti mesa. ");
INSERT INTO ctu76_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Che' jini Jesús ti' subeyob: Ti pejtyelel c pusic'al wersa com j c'ux jini uch'el cha'an pascua la' wic'ot che' max tyo mic sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Como mic subeñetla mach'an mi quejel c cha' c'ux jini uch'el cha'an pascua la' wic'ot jintyo ba' bʌ ora mi yujtyel ba' mi' cha'len yumʌl Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Che' jini ti' ch'ʌmʌ vaso ti i c'ʌb. Ti' sube Dios wocox i yʌlʌ. Ti' subeyob ajcʌnt'añob i cha'an: Japʌla iliyi. Aq'uen la' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Como mic subeñetla mach'anix mi quejel c cha' jape' i ya'lel uva jintyo ti tyal bʌ ora che' mi' cha'len yumʌl Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ti wi'il ti' ch'ʌmʌ waj. Ti' cha'le oración. Che' jini ti' xet'e. Ti yʌq'ueyob. Ti yʌlʌ: Jiñʌch c bʌc'tyal mu' bʌ quejel cʌc' cha'añetla. C'ajtisañon che' mi la' cha'len jini uch'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chʌ'ʌch ti' cha'le je'el yic'ot jini vaso che' ujtyel i cha'leñob uch'el. Jesús ti' subeyob: Ili am bʌ ti vaso jiñʌch i seña tsijib trato bʌ t'an mu' bʌ i wa'chocontyel cha'an tic ch'ich'el mu' bʌ quejel c beque' cha'añetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero wale iliyi wʌ'an i c'ʌb ti pam mesa quic'ot mu' bʌ i quejel i yʌc'on ti cʌchol. ");
INSERT INTO ctu76_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Joñon i Pi'ʌlon Quixtyañujob wersa mic sajtyel che' bajche' wʌ ña'tyʌbil. Pero p'ump'un che' bajche' mi quej i ñusan wocol jini quixtyañu mu' bʌ quejel i yʌc'on ti cʌchol. Wen wocol mi quejel i yubin. ");
INSERT INTO ctu76_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Che' jini ti queji i c'ajtibeñob i bʌ majchqui jini mu' bʌ quejel i yʌc' ti cʌchol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ti wi'il jini ajcʌnt'añob ti queji i cʌlʌx pejcañob i bʌ cha'an majchqui mi quejel i q'uejlel ti más ñuc. ");
INSERT INTO ctu76_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús ti' subeyob: Jini ñuc bʌ yumʌlob ti pañimil mi' cha'len yumʌl che' bajche' mi wen ñuc. Jini am bʌ i ye'tyel mi pejcʌntyel ti wen bʌ ajcʌñʌtyayajob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero jatyetla mach che'ic yom mi la' cha'len. Pero jini más ñuc bʌ ti la' tyojel yom i mele' che' bajche' más alob tyo. Jini mu' bʌ ti xic' yom i cha'len che' bajche' yajtroñel jach. ");
INSERT INTO ctu76_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Jesús ti bej yʌlʌ: ¿Majchqui jini más ñuc bʌ yubil, jim ba jini buchul bʌ ti mesa ti uch'el o jim ba jini ajtroñel mu' bʌ i ñusan waj? ¿Mach ba más ñuc jini buchul bʌ ti uch'el? Pero wʌ' añon ti la' tyojel che' bajche' ajtroñelon la' cha'an, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Jatyetla ti bej ajniyetla quic'ot tic wocol. ");
INSERT INTO ctu76_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jin cha'an mi cʌq'ueñetla la' cha'len yumʌl che' bajche' c Tyat je'el ti yʌc'on c cha'len yumʌl ");
INSERT INTO ctu76_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","cha'an mi la' cha'len uch'el tic mesa ya' ba' mic cha'len yumʌl. Mi quejel la' buchtyʌl ti ñuc bʌ buchlibʌl cha'an la' mele' jini docemojt i jiñʌjlel Israel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Lac Yum ti yʌlʌ je'el: Simón, ubin tsa'ix i c'ajtibon cha'an cʌq'uetla ti i c'ʌb Satanás cha'an i nijcʌbeñetla la' pusic'al che' bajche' mi chijcuntyel trigo cha'an mi loq'uel i sujl. ");
INSERT INTO ctu76_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero tsa'ix c tyajayet ti oración cha'an mach'an mi quejel a cʌy a ch'ujbiñon. Jixcu che' tsa'ix a cha' tyoj isʌ a bʌ, cotyan a wermañujob cha'an i p'ʌtyʌliyel. Che' ti subenti Simón. ");
INSERT INTO ctu76_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón ti' sube: C Yum, chajpʌbilonix cha'an mic majlel quic'otyet ti cʌchol aunque mic sajtyel quic'otyet, che' ti yʌlʌ Simón. ");
INSERT INTO ctu76_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús ti' sube: Pedro, mic subeñet wale che' max tyo cha'le uq'uel tyat mut uxyaj mi quejel a wʌle' mach a cʌñʌyon, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Che' jini Jesús ti' c'ajtibeyob: Che' ñac tic xiq'uiyetla majlel ti subt'an che' ñac mach'an ti la' ch'ʌmʌ majlel la' morral mi yajnibic la' tyaq'uin mi yanic bʌ la' zapatos, ¿an tyo ba chʌ bʌ yom la' cha'an ti la' wubi? che' ti yʌlʌ Jesús. Ti' jac'ʌyob: Ma'ix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Che' jini Jesús ti' subeyob: Pero wale iliyi mi an la' morral, ch'ʌmʌxla majlel yic'ot i yajnib la' tyaq'uin. Yic'ot jini mach'ʌ ba'an i machit, la' i choñe' i bujc cha'an i mʌñe' junts'ijt i machit. ");
INSERT INTO ctu76_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Como mic subeñetla: Mi wersa quejel i ts'ʌctiyel jini wʌ Ts'ijbubil bʌ i T'an Dios ba' mi' tyajon ti t'an. Mi yʌl: Mi quejel i tsijquel yic'ot simaroño' bʌ, che' mi yʌl. Como pejtyelel ts'ijbubuil bʌ cha'añon mi quejel i wersa ts'ʌctiyel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Che' jini ti yʌlʌyob: C Yum, umba'an cha'ts'ijt machit, che'ob. Jesús ti' jac'ʌ: Jasʌlix jini, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Che' jini Jesús ti loq'ui majlel. Ti majli ti wits Olivajol bʌ i c'aba' che' bajche' i tyʌlel mi' cha'len. Jini ajcʌnt'añob i cha'an ti' tsʌcleyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Che' ñac ti c'oti ya'i Jesús ti' subeyob: Pejcanla Dios ti oración cha'an mach'an mi la' yajlel ti mulil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Che' jini, Jesús ti bej majli che' ñajtyʌl bajche' mi chojquel jump'ej tyun. Ti ñocle cha'an i cha'len oración. ");
INSERT INTO ctu76_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ti oración Jesús ti yʌlʌ: C Tyat, mach a wʌc'on ti ochel ti ili wocol mu' bʌ quejel c ñusan. Pero mele mach jinic bajche' com joñon pero mele bajche' awom, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Che' jini ti tsictiyi juntiquil ajtroñel i cha'an Dios ch'oyol bʌ ti panchan cha'an i yʌq'uen i p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Che' chʌncox i wen yilan wocol Jesús más wersa ti' pejcʌ Dios ti oración. Ti loq'ui i bul'ich che' bajche' ch'ich' mi' t'uyt'uy yajlel ti lum. ");
INSERT INTO ctu76_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Che' ñac ti tyejchi ti oración, ti cha' majli ba'an ajcʌnt'añob i cha'an. Wʌyʌlobix ti' tyaja cha'an i ch'ʌjyemlelob i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Che' jini Jesús ti' subeyob: ¿Chucoch muq'uetla ti wʌyel? Tyejchenla. Cha'lenla oración cha'an mach'an mi la' yajlel ti mulil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Che' chʌncol tyo ti t'an Jesús ti c'oti cabʌl quixtyañu. Ñaxan tyʌlel Judas. Judas jiñʌch i pi'ʌl jini yambʌ once ajcʌnt'añob i cha'an Jesús. Ti' lʌc'ʌ Jesús cha'an i ñupe'. ");
INSERT INTO ctu76_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Che' jini Jesús ti' sube: Judas, ¿mu' ba' a wʌc'on ti' c'ʌbob, Joñon i Pi'ʌlon bʌ Quixtyañujob cha'an ma' ñupon? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jini ya' bʌ añob yic'ot Jesús che' ñac ti' ña'tyʌyob chʌ bʌ chʌncol i yujtyel, ti' c'ajtibeyob Jesús: C Yum, ¿mu' ba lojon j c'ʌmben machit? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Juntiquil ajcʌnt'an i cha'an Jesús ti' lowo ajtroñel i cha'an jini ñoj ñuc bʌ cura i cha'an israelob. Ti' tsepbe loq'uel i ñoj bʌ chiquin. ");
INSERT INTO ctu76_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús ti yʌlʌ: La' ajnic. Cʌyʌxla, che'en. Che' jini Jesús ti' tyʌlbe i chiquin jini ajtroñel. Ti lajmi. ");
INSERT INTO ctu76_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Che' jini Jesús ti' subeyob jini ñuc bʌ curajob i cha'an israelob yic'ot jini año' bʌ i ye'tyel ti i templo israelob yic'ot xñoxob año' bʌ i ye'tyel tsa' bʌ c'oti i chucob majlel Jesús: ¿Tsa'ix ba tyʌliyetla awic'ot la' machit la' tye' che' bajche' ajxuch'on? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Che' ñac ya' añon quic'otyetla ya' ti templo ti jujump'ej q'uin mach'an ti la' saj chucuyon. Pero wale iliyi jiñʌch i yorojlel ti la' yajcʌ. I yorojlelix mi tsictiyel i p'ʌtyʌlel jini am bʌ ti ic'jowan bʌ pañimil, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Che' jini ti' cʌchʌyob Jesús. Ti' pʌyʌyob majlel ti yotyot jini ñoj ñuc bʌ cura i cha'an israelob. Pedro ti' ñajtyʌ tsʌcle majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ya'i ti' ts'ʌbʌyob c'ajc ti pat otyot. Ya' joy buchulob. Pedro ti buchle yic'otyob je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Che' jini juntiquil ajtroñel bʌ x'ixic ti yilʌ ya' buchul Pedro je'el. Ti' ch'uj q'uele. Ti yʌlʌ: Ili winic jiñʌch juntiquil i pi'ʌlob Jesús je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedro ti yʌlʌ mach jiniqui. Ti yʌlʌ: Pero ubin, x'ixic, mach j cʌñʌ jini winiqui, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Che' jini ti ñajtyʌ jumuc' yambʌ ti yilʌ. Ti' sube Pedro: Jatyet je'el i pi'ʌlet jini winic, che'en. Pero Pedro ti yʌlʌ: Ubin, mach joñonic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Che' jini, ti ñumi jump'ej ora yambʌ ti yilʌ. Ti' sube: Melel, ili winic i pi'ʌlobʌch Jesús como loq'uem ti Galilea je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Che' jini Pedro ti yʌlʌ: Ubin, mach cujil isujm chʌ bʌ yes chʌncol a wʌle', che'en. Ti jim bʌ ora che' chʌncol tyo ti t'an Pedro, ti' wa' cha'le uq'uel tyat mut. ");
INSERT INTO ctu76_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Lac Yum ti' sutqui i bʌ i q'uel Pedro. Pedro ti' c'ajtiyi i cha'an tsa' bʌ i yʌlʌ Jesús che' ñac ti' sube: Che' max tyo i cha'le uq'uel tyat mut uxyajlel mi quejel a wʌl mach a cʌñʌyon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Che' jini Pedro ti loq'ui majlel. Ti wen queji ti uq'uel. ");
INSERT INTO ctu76_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jini winicob tsa' bʌ i cʌñʌtyʌyob Jesús ti' wajleyob. Ti' jats'ʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ti' mʌcbeyob i wut. Ti' tyum jajts'iyob. Ti' subeyob: Subeñon lojon majchqui ti' jats'ʌyet, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","An tyo cabʌl yan tyac tsa' bʌ i yʌlʌyob cha'an i wajleñob. ");
INSERT INTO ctu76_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Che' sʌquix ti' much'quiyob i bʌ jini xñoxob año' bʌ i ye'tyel cha'an israelob, jini ñuc bʌ curajob yic'ot ajcʌntisajob cha'an mandar. Ti' pʌyʌyob majlel Jesús ya' ba'an ñuco' bʌ i ye'tyel ti Comité Junta Suprema bʌ i c'aba' mu' bʌ i cha'len melojel. Ya'i ti' c'ajtibeyob: ");
INSERT INTO ctu76_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Subeñon lojon mi jatyetyʌch jini Cristo yajcʌbil bʌ i cha'an Dios. Jesús ti' jac'ʌ: Mi tic subeyetla mi chʌ'ʌchi, mach'an mi quejel la' ch'ujbin cha'an melel c t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mi an chʌ bʌ tij c'ajtibeyetla mach'an mi quejel la' jac'beñon. Ma'ix mi quejel la' colon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero wale c'ʌlʌ ti bele' ora Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel c buchtyʌl ti' ñoj jini Dios mach'ʌ ba'an i p'isol i p'ʌtyʌlel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Che' jini, ti' lu' c'ajtibeyob Jesús: ¿Jatyet ba i Yalobil Dios, che' jini? che'ob. Jesús ti' jac'beyob: Joñoñʌch che' bajche' ti la' wʌlʌ, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Che' jini ti yʌlʌyob: ¿Chutyoqui c'ʌjnibal yambʌ testigo? Joñonla lac bajñel tsa'ix la cubi ti lac chiquin tsa' bʌ i yʌlʌ ti ti', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Che' jini, ti lu' tyejchiyob jini año' bʌ i ye'tyel. Ti' pʌyʌyob majlel Jesús ya' ti i tyojel Pilato. ");
INSERT INTO ctu76_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ya'i ti queji i jop'eñob i mul Jesús. Ti yʌlʌyob: Ili winiqui tsa'ix c tyaja lojon che' chʌncol i lolon cʌntisañob lojon c pi'ʌlob ti i contra jini yumʌl. Mi yʌl mach yom mi lojon c cha'len tyojoñel ti i tyojlel jini ñuc bʌ yumʌl am bʌ ti Roma. Che' je'el mi yʌle' jiñʌch Cristo jini yajcʌbil bʌ i cha'an Dios yic'ot ñuc bʌ yumʌl. Che' mi yʌle', che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Che' jini Pilato ti' c'ajtibe Jesús: ¿Jatyet ba ñuc bʌ yumʌl i cha'an israelob? che'en. Jesús ti' jac'ʌ: Melelʌch bajche' ma' wʌle', che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Che' jini Pilato ti' sube jini ñuc bʌ curajob i cha'an israelob yic'ot yaño' bʌ quixtyañujob: Mach'an mic tyajben i mul ili winiqui, che' ti yʌlʌ Pilato. ");
INSERT INTO ctu76_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero más c'am ti queji i yʌlob: Chʌncox i cʌntisañob pejtyelel quixtyañujob ti i contra jini ñuc bʌ yumʌl lac cha'an cha'an ti i cʌntisa. Ya' ti tyechi i cʌntisa ya' ti Galilea. Wale c'ʌlʌ wʌ'i mi' bej cha'len cʌntisa. ");
INSERT INTO ctu76_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Che' ñac ti yubi Pilato chʌncol i tyajob ti t'an Galilea ti' c'ajtibe mi ya' ch'oyol ti Galilea Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Che' ñac ti yʌlʌyob ya' ch'oyol ti Galilea Jesús, Pilato ti' choco majlel Jesús ya' ti tyojlel Herodes. Jiñʌch yumʌl ya' ti Galilea como ya'an Herodes ti Jerusalén ti jim bʌ ora je'el. ");
INSERT INTO ctu76_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","C'ajacña i yoj Herodes che' ñac ti yilʌ Jesús como wajalix yom i q'uele' Jesús. Como tsa'ix i yubi ti' tyajayob ti t'an Jesús. Yomox i q'uel ti yubi che' mi quejel i pʌs'e' ñuc bʌ i p'ʌtyʌlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Cabʌl chʌ bʌ ti' c'ajtibe Jesús, pero Jesús mach'an chʌ bʌ ti' jac'ʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ya' añob je'el jini ñuc bʌ curajob i cha'an israelob yic'ot jini ajcʌntisajob cha'an mandar. Ti' wersa jop'beyob i mul Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Che' jini Herodes yic'ot i soldadojob ti' lolon q'uele che' bajche' ma'ix chʌ bʌ i c'ʌjnibal Jesús ti' cha'leyob. Cha'an yom i wajleñob ti' xojbeyob Jesús wen c'otyajax bʌ i pislel che' bajche' ñuc bʌ yumʌl ti' cha'leyob. Ti wi'il Herodes ti' cha' choco sujtyel Jesús ya' ba'an Pilato. ");
INSERT INTO ctu76_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ti jini jach bʌ q'uin Pilato yic'ot Herodes ti queji i cha' utsbiñob i bʌ como ti yambʌ ora ti' ts'a'q'ueleyob i bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Che' jini Pilato ti' cha' much'quiyob jini ñuc bʌ curajob i cha'an israelob yic'ot año' bʌ i ye'tyel yic'ot yambʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pilato ti' subeyob: Ti la' pʌyʌ tyʌlel jini winic. Ti la' lolon subeyon chʌncol i cʌntisan quixtyañujob ti i contra jini ñuc bʌ yumʌl. Pero tsa'ix c wen c'ajtibe wʌ' ba' añetla chʌ bʌ tyac ti' cha'le. Q'uele awilan, ma' mic saj tyajben i mul che' bajche' chʌncol la' wʌle'. ");
INSERT INTO ctu76_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mi jinic Herodes je'el ma'ix ti' tyajbe i mul Jesús. Tsa'ix i cha' choco sujtyel. Q'uele awilan, ma'ix chʌ bʌ och yom ajq'uic ti sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Mi quejel cʌc' ti jajts'ol. Ti wi'il mi quejel j cole', che' ti yʌlʌ Pilato. ");
INSERT INTO ctu76_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","I tyʌlelʌch che' ti i yorojlel pascua bʌ q'uin Pilato mi' cole' juntiquil quixtyañujob cʌchʌl bʌ cha'an chʌ'ʌch mi' mulan quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero ti motin quejiyob ti oñel. La' sajtic ili winic. Colox Barrabás, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ti cʌjchi jini Barrabás cha'an ti' nijcʌ quixtyañujob ti' contra gobierno ti jini lum. Che' je'el ti' cha'le tsʌnsa. ");
INSERT INTO ctu76_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato ti' cha' pejcʌyob jini quixtyañujob como yom i cole' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero más ti quejiyob ti oñel. Ti yʌlʌyob: La' tsʌnsʌntic ti cruz, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ti uxyajlel Pilato ti yʌlʌ: Pero, ¿chuqui ti simaronlel ti' cha'le? Mach'an tic tyajbe i mul cha'an mi tsʌnsʌntyel. Mu' jach cʌc' ti jajts'ol. Mi quejel j cole', che' ti yʌlʌ Pilato. ");
INSERT INTO ctu76_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero jini quixtyañujob ti quejiyob ti oñel cha'an i wersa c'ajtibeñob cha'an mi tsʌnsʌntyel ti cruz Jesús. Chʌ'ʌch je'el ti' cha'leyob oñel jini ñuc bʌ curajob. Jin cha'an ti aq'uentiyob bajche' yomob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato ti yʌc'ʌ i t'an cha'an mi yujtyel bajche' ti' c'ajtibeyob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Che' jini ti yʌc'ʌ ti cojlel jini winic tsa' bʌ i c'ajtiyob cha'an mi cojlel am bʌ ti cʌchol cha'an ti' ñijcʌyob ti i contra ñuc bʌ yumʌl yic'ot tsa' bʌ i cha'le tsʌnsa. Ti yʌc'ʌ Jesús ti i c'ʌb winicob cha'an mi' melob bajche' yomob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Che' ñac chʌncol i pʌyob majlel Jesús ya' ti bij cha'an i joc'chocoñob ti cruz ti' tyajayob juntiquil winic Simón bʌ i c'aba' ch'oyol bʌ ti Sirene. C'otyel muc' ti ma'tye'el. Ti' xiq'uiyob cha'an i q'uechben majlel ti wi'il pat jini cruz. ");
INSERT INTO ctu76_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Cabʌl quixtyañujob ti' tsʌcleyob majlel. Cabʌl x'ixicob chʌncolob ti uq'uel yic'ot oñel cha'an ti i ch'ʌjyemlel. ");
INSERT INTO ctu76_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús ti' q'ueleyob. Ti' subeyob: X'ixicob añet bʌ la ti Jerusalén mach yom mi la' wuc'tyañon. Pero yom mi la' wuc'tyan la' bʌ yic'ot la' walobilob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Como tyal i yorojlel che' mi quejel i yʌlob: C'ajacña i yoj jini mach'ʌ ba'an ti' cha'le albʌl yic'ot mach'ʌ ba'an ti' tsu'sʌyob i yalobil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Che' jini quixtyañujob mi quejel i suben jini wits: Yajlen wʌ' ba'añon lojon. Mi quejel i suben bujtʌl tyac: Mujluñon lojon, che' mi quejel i yʌlob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Mi chʌ'ʌch mi' tyʌc'lañon joñon mach'ʌ ba'an c mul, ¿chuqui mi quejel la' wic'ot che' xmuliletla? Wen wocol mi quejel la' ñusan, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ti' pʌyʌyob majlel je'el cha'tiquil xñusa mandar yic'ot Jesús cha'an i tsʌnsañob yic'ot Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Che' ñac ti c'otiyob ti bujtyʌl Bʌquel Jolʌl bʌ i c'aba' ti' joc'chocoyob Jesús ti cruz yic'ot je'el jini cha'tiquil xñusa mandar. Juntiquil an ti i ñoj Jesús. Yambʌ ti i ts'ej. ");
INSERT INTO ctu76_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Che' ñac chʌncol tyo i joc'chocon Jesús ti cruz, Jesús ti yʌlʌ: C Tyat, ñusʌbeñob i mul como mach yujilob isujm chʌ bʌ muc'ob. Jini soldadojob ti' cha'leyob yajcaya cha'an i ña'tyañob majchqui mi quejel i ganarin i pislel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ya'an quixtyañujob chʌncol i q'uelob. Jinic tyo año' bʌ i ye'tyel ti' wajleyob. Ti yʌlʌyob: Ti' cotyʌ yaño' bʌ. Wale iliyi la' i cotyan i bʌ mi melelʌch Cristo jini yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jini soldadojob je'el ti' wajleyob che' chʌncol i lʌque' Jesús cha'an i jop' i yʌq'uen paj bʌ vino. ");
INSERT INTO ctu76_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ti' subeyob Jesús: Mi ñuc bʌ Yumʌlet i cha'an israelob, cotyan a bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ya' ts'ijbubil t'an ti chañelel i jol Jesús ti t'an griego, ti latín yic'ot ti i t'an hebreo. Mi yʌl: Jiñʌch ñuc bʌ Yumʌl i cha'an israelob, che' ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Juntiquil ya' bʌ joc'ol ti cruz ti' wajle je'el. Ti yʌlʌ: Mi Cristojet cotyan a bʌ. Cotyañon lojon je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero jini yambʌ ya' bʌ joc'ol yic'ot ti' tiq'ui i pi'ʌl. Ti yʌlʌ: ¿Mach'a ba'an ma' bʌc'ñan Dios lajal chʌncox a sajtyel ti cruz? ");
INSERT INTO ctu76_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Como joñonla añʌch lac mul. Chʌncol lac xot'e' lac mul che' bajche' yom. Pero ili winic ma'ix chʌ bʌ mach wen ti' cha'le, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Che' jini ti' sube Jesús: Jesús, c'ajtisañon che' ma' c'otyel ba' mi quejel a cha'len yumʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús ti' jac'be: Ubin, mic subeñet wale jach mi quejel a c'otyel quic'ot ti paraíso, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Che' bajche' xinq'uinil. Che' jini ti ic'ʌ pejtyelel mulawil c'ʌlʌ ti och an q'uin ti las tres. ");
INSERT INTO ctu76_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ti mʌjqui q'uin. Jini colem pisil joc'ol bʌ ti templo ti tsijli ti xinil. ");
INSERT INTO ctu76_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Che' jini Jesús wen c'am ti' cha'le t'an: C Tyat, mi cʌq'ueñet c ch'ujlel ti a wenta, che'en. Che' ti ujti i yʌle' jini, ti sajti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Che' ñac jini capitán am bʌ ti i wenta cien soldadojob i cha'an romanojob ti yilʌ chʌ bʌ ti ujti ti' subu i ñuclel Dios. Ti yʌlʌ: Melel ma'ix i mul jini winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pejtyelel quixtyañu ya' bʌ añob tsa' bʌ i yilʌyob chʌ bʌ ti ujti ti' jats'ʌyob i tyajn cha'an i ch'ʌjyemlel. ");
INSERT INTO ctu76_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero ya' ñajti wa'alob ti pejtyelel jini cʌñʌlo' bʌ i cha'an Jesús yic'ot jini x'ixicob tsa' bʌ i tsʌcleyob majlel c'ʌlʌ ya' ti Galilea. Chʌncol i q'uelob chʌ bʌ chʌncol i yujtyel. ");
INSERT INTO ctu76_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","An juntiquil winic José bʌ i c'aba'. Ch'oyol ti lum Arimatea bʌ i c'aba' ya' ti Judea bʌ pañimil. Weñʌch jini winic. Tyojʌch i pusic'al. An i ye'tyel ti Comité Junta Suprema bʌ i c'aba' i cha'an bʌ israelob. ");
INSERT INTO ctu76_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jini José chʌncol i pijtyan i yorojlel mi quejel i yumintyel Dios. Pero che' ñac ti yʌc'ʌyob i t'an jini yambʌ cha'an i yʌc'ob ti sajtyel Jesús jini José mach'an ti yʌc'ʌ i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Che' jini, ti majli ya' ba'an Pilato cha'an i c'ajtiben i bʌc'tyal Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Che' ujtye i ju'san ti cruz Jesús ti' bʌc'ʌ ti wen bʌ bʌjquil. Ti' ch'ujñʌ ya' ti muconibʌl melel bʌ ti malil colem tyun. Max tyo ba'an majch ti ch'ujñʌnti ya'i. ");
INSERT INTO ctu76_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jiñʌch i q'uinilel che' mi' chajpañob chʌ bʌ jach mi quej i c'ʌñob che' ti q'uinilel c'aj oj ti yijc'ʌlel. Yomox quejel i yorojlel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jini x'ixicob ch'oyolo' bʌ ti Galilea bʌ pañimil tsa' bʌ i c'ʌlʌ tsʌcle majlel Jesús ti majli i q'uele' ba' ti ch'ujñʌnti Jesús. Ti' wen q'uele bajche' ti' sʌts chocoyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Che' ñac ti cha' sujtiyob ti yotyot ti queji i chajpañob yowocña bʌ pimel i wentyʌlel perfume yic'ot yambʌ ts'ac. Che' jini ti' c'ajayob i yoj ti q'uinilel c'aj oj che' bajche' mi tyumbintyel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jini ñaxan bʌ q'uin ti semana che' wen sʌc'an tyo jini x'ixicob ti cha' majliyob ba' ti ch'ujñʌnti Jesús. Ti' ch'ʌmʌyob majlel jini perfume tsa' bʌ i chajpʌyob. Yambʌ x'ixicob ti' pi'leyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Che' ñac ti c'otiyob ti' q'ueleyob loc'sʌbil jini wechel bʌ tyun i mʌjquil muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ti ochiyob. Pero mach'an ti' tyajayob i bʌc'tyal lac Yum Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tyoj bʌc'ñʌjel ti yilʌyob. Mach yujil isujm chʌ bʌ yom i cha'len che' ñac ti yilʌyob wa'alob ti t'ejlob cha'tiquil winic. Lemlaw i pislel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ñucul jubel i ñi' i wut como ñoj añob i bʌq'uen jini x'ixicob. Jini winicob lemlaw bʌ i pislel ti' subeyob: ¿Chucoch chʌncol la' sʌclan jini cuxul bʌ ba'an sajtyemo' bʌ? ");
INSERT INTO ctu76_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma'ix wʌ'an como tsa'ix tyejchi loq'uel ba'an sajtyemo' bʌ. Cha' c'ajtisan bajche' ti' wʌ subetla che' ya' tyo an ti Galilea la' wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ti' wʌ subetla Jesús jini i Pi'ʌl bʌ Quixtyañujob wersa mi quejel i yʌjq'uel ti i c'ʌb xmulil cha'an wersa mi quejel i joc'chocontyel ti cruz yic'ot cha'an ti yuxp'ejlel q'uin mi quejel i cha' tyejchel loq'uel ba'an sajtyemo' bʌ, che'en, ti yʌlʌ jini winicob lemlaw bʌ i pislel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Che' jini ti cha' c'ajtiyi i cha'an jini t'an tsa' bʌ i wʌ alʌ Jesús che' ñac ya' tyo an yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Che' ñac tsa'ix sujtiyob jini x'ixicob ba' ti' mucuyob Jesús ti' lu' subeyob jini once yajcʌbilo' bʌ ajsubt'añob ñumel yic'ot yaño' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jiñobʌch María ch'oyol bʌ ti Magdala, Juana, María i ña' bʌ Jacobo yic'ot yambʌ x'ixicob tsa' bʌ i subeyob jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero che' bajche' mach'an i sujmlel bʌ t'an ti yubiyob jini yajcʌbilo' bʌ ajsubt'añob ñumel tsa' bʌ subentiyob. Mach'an ti' ch'ujbiyob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedro ti loq'ui majlel ti ajñel. Ti majli ti muconibʌl. Che' ñac ti' q'uele i mal ti yilʌbe i bʌjq'uil Jesús. Bajñel an. Ti cha' sujti Pedro ti yotyot. Tyoj bʌc'ñʌjel ti yubi cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctu76_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti jin jach bʌ q'uin ti majli cha'tiquil ajcʌnt'añob i cha'an Jesús ti jump'ej lum Emaús bʌ i c'aba'. Che' bajche' once kilómetros i ñajtlel ya' ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chʌncolob ti t'an. Chʌncol i lu' alob tsa' bʌ ujti che' chʌncolob ti xʌmbal majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Che' ñac chʌncolob ti t'an che' chʌncol i wen subeñob i bʌ pejtyelel bajche' ti ujti, ti c'oti Jesús ya' ba'añob. Ti queji ti xʌmbal yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero aunque ti yilʌyob Jesús che' bajche' an chʌ bʌ ti' mʌctyʌbeyob i ña'tyan majchqui jini mu' bʌ ti xʌmbal yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Che' jini, Jesús ti' c'ajtibeyob: ¿Chuquiyes chʌncol la' tyaje' ti t'an che' chʌncoletla ti xʌmbal majlel? ¿Chucoch ch'ʌjyemetla? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jini juntiquil Cleofas bʌ i c'aba' ti' jac'ʌ: Pejtyelel año' bʌ ti mulawil lu' yujil isujm chʌ bʌ ti ujti ya' ti Jerusalén ti jini q'uin tyac tsa' bʌ ñumi. ¿A bajñel jatyet jach añet ti Jerusalén mach'ʌ ba'an ti a wubi jini t'an? che' ti yʌlʌ Cleofas. ");
INSERT INTO ctu76_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Che' jini Jesús ti' subeyob: ¿Chuqui ti ujti? che'en. Ti' subeyob: Jini Jesús ch'oyol bʌ ti Nazaret juntiquil tsa' bʌ i xiq'ui i yʌle' Dios ti' pʌsʌ i p'ʌtyʌlel ti jini tsa' bʌ i cha'le yic'ot ti i t'an ti' tyojel Dios yic'ot ba'an pejtyelel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jini ñuc bʌ curajob yic'ot jini yumʌlob lac cha'an ti yʌc'ʌyob i t'an cha'an sajtic yic'ot cha'an joc'lec ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti lojon c pijtyʌ jiñʌch mu' bʌ quejel i cotyañonla israelon bʌ la cha'an loc'sañonla ti p'ʌtyʌlel laj contra. Wale mach cojic jach jini pero wale yuxp'ejlelix bʌ q'uin ti sajti ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Che' je'el an cha'tiquil uxtiquil x'ixicob c pi'ʌlob ti bʌc'tisʌyon lojon como ti sʌc'an tsajniyob ti muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Mach'an ti' tyajayob i bʌc'tyal Jesús. Ti c'oti i subeñon lojon cha'an ti yilʌyob ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan tsa' bʌ i subeyob cha' cuxulix Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ti wi'il cha'tiquil uxtiquil lojon c pi'ʌlob tsajniyob ti muconibʌl. Ti yilʌyob chʌ'ʌch bajche' ti yʌlʌyob jini x'ixicob. Pero mach'an ti yilʌyob Jesús. Che' ti' subeyob Jesús jini chʌncol bʌ ti xʌmbal yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Che' jini Jesús ti' subeyob: Ma' mi la' saj ch'ʌm'en isujm jini tsa' bʌ i yʌlʌ jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Mach'a ba'an ñaxan wersa mi quejel i yilan wocol Cristo jini yajcʌbil bʌ che' max tyo cha' aq'uenti i ñuclel? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Che' jini Jesús ti queji i suben i sujmlel ba' mi tyajtyʌl ti t'an ti Ts'ijbubil bʌ i T'an Dios c'ʌlʌ ya' ti jun tyac tsa' bʌ i ts'ijbu jini tsa' bʌ i xiq'uiyob i yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Che' ñac ti c'oti ti lum ba' chʌncol i majlel, Jesús ti' cha'le che' bajche' mu' tyo quejel i bej majlel. ");
INSERT INTO ctu76_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero jini cha'tiquil ti' wersa sube cʌytyʌl Jesús yic'otyob. Ti yʌlʌyob: Cʌylen quic'ot lojon como yomox yic'an. Che' jini Jesús ti ochi ti jijlel yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Che' ñac buchul yic'otyob ba'an mesa ti' ch'ʌmʌ waj ti i c'ʌb Jesús. Ti' sube Dios wocox i yʌlʌ. Ti' xet'e. Ti yʌq'ueyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ti jim bʌ ora ti aq'uentiyob i ña'tyan. Ti queji i cʌñe' Jesúsʌch. Pero che' jini ti sʌc sajti ti i wutyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ti' subeyob i bʌ: ¿Mach ba ñoj wen ti la cubi ti lac pusic'al che' ñac ti tyʌli la quic'ot ti bij che' chʌncol i pejcañonla, che' chʌncol i subeñonla i sujmlel jini Ts'ijbubil bʌ i T'an Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Che' jini mach'an ti' más pijtyʌyob. Ti queji i wa' cha' sujtyel majlel ti Jerusalén. Ya'i ti' tyajayob jini once yajcʌbilo' bʌ ajsubt'añob tsa' bʌ i much'quiyob i bʌ yic'ot yambʌ i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ti' subenti jini cha'tiquil: Melelʌch che' tsa'ix cha' tyejchi loq'uel lac Yum ba'an sajtyemo' bʌ. Tsa'ix i yilʌ Simón, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Che' jini, jini cha'tiquil ti' subeyob chʌ bʌ ti ujti ya' ti bij yic'ot bajche' ti' cʌñʌyob Jesús che' ñac ti' xet'beyob waj. ");
INSERT INTO ctu76_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chʌncol tyo ti t'an. Choncol i yʌlob chʌ bʌ ti ujti che' ñac Jesús ti c'oti ya' ti xinil ya' ba'añob. Ti yʌq'ueyob saludo. Ti' subeyob: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tyoj bʌc'ñʌjelob ti yubiyob. Wen añob i bʌq'uen. Ti' lolon ña'tyʌyob i ch'ujlel jach quixtyañu ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús ti' subeyob: ¿Chucoch muq'uetla ti bʌq'uen? ¿Chucoch chʌncoletla ti pensal ti la' pusic'al? ");
INSERT INTO ctu76_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Q'uele j c'ʌb, q'uele coc. Joñoñʌch. Tyʌlʌyon. Q'ueleyon como ma'ix i bʌc'tyal i bʌquel i ch'ujlel jach bʌ quixtyañu che' bajche' chʌncol la' q'uelon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Che' ñac chʌncol i yʌle' jini, Jesús ti' pʌs'eyob yoc i c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero che' max tyo ba'an ti' wa' ch'ujbiyob jini ajcʌnt'añob i cha'an cha'an wen c'ajacña i yoj ti yubiyob yic'ot cha'an tyoj bʌc'ñʌjel ti yubiyob, Jesús ti' subeyob: ¿Am ba chʌ bʌ mi laj c'ux wʌ'wʌ'i? che'en. ");
INSERT INTO ctu76_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Che' jini ti yʌq'ueyob Jesús i c'ux pojpobil bʌ chʌy yic'ot chab. ");
INSERT INTO ctu76_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús ti' ch'ʌmʌ. Ti' c'uxu ti' tyojlelob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Che' jini Jesús ti' subeyob: Jini tsa'ix bʌ ts'ʌctiyi jiñʌch tsa' bʌ c subeyetla che' ñac wʌ' tyo añon quic'otyetla. Wersa yom mi ts'ʌctiyel jini ts'ijbubil bʌ cha'añon ti mandar Moisés yic'ot ti jun tsa' bʌ i ts'ijbuyob jini tsa' bʌ i xiq'uiyob i yʌle' Dios yic'ot ti Salmo tyac. ");
INSERT INTO ctu76_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Che' jini, ti yʌq'ueyob i ch'ʌm'eñob i sujmlel Ts'ijbubil bʌ i T'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ti' subeyob: Chʌ'ʌch ts'ijbubil. Jin cha'an wersa mi sajtyel Cristo jini yajcʌbil bʌ. Wersa je'el mi tyejchel loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ti i c'aba' Cristo mi wersa quejel i sub majlel t'an ba'an jujunmujch' quixtyañujob. Mi quejel i subob ñaxan wʌ' ti Jerusalén. Mi subentyel cha'an yom i q'uextyan i pensal i cʌyob i mul cha'an mi ñusʌbentyel i mul. Chʌ'ʌch ts'ijbubil ti ñoj oniyix. Che' ti' tyaja i bʌ ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jatyetla mi quejel la' wʌle' chʌ bʌ tyac ti la' wilʌ cha'añon. ");
INSERT INTO ctu76_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Q'uele awilan, mi quejel c chocbeñetla tyʌlel jini tsa' bʌ i wʌ alʌ c Tyat mi quejel i yʌq'ueñetla. Pero cʌylenla wʌ' ti Jerusalén jintyo mi la' wʌq'uentyel jini la' p'ʌtyʌlel ch'oyol bʌ ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Che' jini, Jesús ti' pʌyʌyob loq'uel majlel ti Jerusalén jini ajcʌnt'añob i cha'an c'ʌlʌ ya' ti' Betania bʌ lum. Ti' letsʌ i c'ʌb. Ti yʌq'ueyob i yutslel i t'an. ");
INSERT INTO ctu76_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Che' chʌncol tyo i yʌq'ueñob i yutslel i t'an ti cʌyʌyob. Ti pʌjyi letsel ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ti' ch'ujutisʌyob Jesús. Che' jini, ti sujtiyob majlel ti Jerusalén. Wen c'ajacña i yoj ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bej ya' añob ti templo cha'an i sub i ñuclel Dios. Amén.");
INSERT INTO ctu76_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","C'ʌlʌ ti tyejchibal an juntiquil mu' bʌ i tsictisan bajche' an Dios. An yic'ot Dios. Diosʌch. ");
INSERT INTO ctu76_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","C'ʌlʌ ti tyejchibal an yic'ot Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cha'an ti jini mu' bʌ i tsictisan bajche' an Dios ti mejli pejtyel chʌ bʌ an. Mach'an chʌ bʌ yes tyac melel mach bʌ ba'an ti mejli cha'an ti jini mu' bʌ i tsictisan bajche' an Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","An i cuxtyʌlel jini mu' bʌ i tsictisan bajche' an Dios cha'an mi yʌq'uen quixtyañujob i cuxtyʌlel je'el. Jini juntiquil jiñʌch i sʌclel mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ili i sʌclel mi yʌc' i c'ʌc'al ti ic'jowan bʌ mulawil. Pero jini i yic'jowanlel mulawil mach ch'ujbi i yʌpe' i sʌclel. ");
INSERT INTO ctu76_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Dios ti' choco tyʌlel juntiquil winic Juan bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ti tyʌli cha'an i yʌc' ti cʌjñel i sʌclel mulawil cha'an mi' lu' ch'ujbiñob cha'an ti' t'an tsa' bʌ i yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mach i sʌclelic mulawil jini Juan. Tsa' jach chojqui tyʌlel cha'an i yʌc' ti cʌjñel i sʌclel mulawil jini yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ti wi'il tyo ti tyʌli ti mulawil jini yajcʌbil bʌ i cha'an Dios. Jiñʌch i sʌclel mulawil tsa' bʌ tyʌli cha'an mi' pʌs'en i sʌclel ti jujuntiquil quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jini mu' bʌ i tsictisan bajche' an Dios, ti ajni wʌ' ti mulawil. Jini mulawil i melbalʌch. Pero jini año' bʌ ti mulawil mach'an ti' cʌñʌyob mi jin ti' mele ili mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ti tyʌli wʌ' ti' lumal pero i pi'ʌlob mach yom i q'uelob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero an yom bʌ i q'uelob. Ti' ch'ujbiyob cha'an jiñʌch i Yalobil Dios. Ti pejtyelel mu' bʌ i ch'ujbin ti aq'uentiyob ti jujuntiquil i yajñel ti' yalobilob Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jini tsa' bʌ i ch'ujbiyob cha'an yajcʌbil i cha'an Dios jini tsa' bʌ tyʌli, ti cha' ch'ocʌyob yubil mach cha'anic ti i tyat i ña' mi cha'anic che' yom quixtyañu mi cha'anic che' ti' wʌ ña'tyʌ winicob pero ti cha' ch'ocʌyob yubil cha'an che' yom Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jini mu' bʌ i tsictisan bajche' an Dios ti' ch'ʌmʌ i bʌc'tyal. Ti poj ajni wʌ' ti mulawil wʌ' ba'añon lojon. But'ul i pusic'al ti i yutslel. Ñoj melelʌch i t'an. Ti lojon quilʌ i ñuclel, i ñuclel cojach bʌ i Yalobil tyʌlem ya' ba'an i Tyat ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan ti yʌc'ʌ ti cʌjñel jini yajcʌbil bʌ i cha'an Dios. Ti yʌlʌ ti c'am bʌ subt'an: Jiñʌch jini tsa' bʌ c tyaja tic t'an che' ñac ti cʌlʌ: Jini mu' bʌ i tyʌlel tic pat más an i ñuclel como an ti ñaxan c'ʌlʌ ti tyejchibal mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ti lac pejtyelel mu' bʌ lac ch'ujbin ti aq'uentiyonla loq'uem bʌ ti ñuc bʌ i yutslel. Jiñʌch i yutslel mu' bʌ i bej más aq'ueñonla. ");
INSERT INTO ctu76_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ti ñoj oniyix ti aq'uentiyob jini mandar i cha'an Dios ti Moisés. Ti aq'uentiyonla i yutslel yic'ot jini ñoj melel bʌ i t'an Dios ti Jesucristo. ");
INSERT INTO ctu76_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mach'an ba' bʌ ora an majch ti yilʌ Dios. Pero jin jach ti yilʌ cojach bʌ i Yalobil ya' bʌ an yic'ot i Tyat. Tsa'ix i pʌs'eyonla bajche' an Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jini i pi'ʌlob israelob año' bʌ ye'tyel ya' ti Jerusalén ti' chocoyob majlel curajob i cha'añob yic'ot levitajob mu' bʌ i cotyan curajob cha'an i c'ajtiben Juan: ¿Majchetqui? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ti' subu i bʌ ti wen tsiquil bʌ t'an. Mach'an ti' mucu Juan: Mach Cristojonic jini yajcʌbil bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Che' jini, ti' cha' c'ajtibe: ¿Majchetqui che' jini? ¿Jatyet ba Elíaset, jini tsa' bʌ i xiq'ui i yʌle' Dios? che'ob. Juan ti' subeyob: Mach joñonic, che'en. Che' jini, ti' cha' c'ajtibeyob: ¿Jatyet ba jini mu' bʌ quej i xiq'ue' i yʌle' Dios? che'ob. Juan ti' jac'ʌ: Mach joñonic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Che' jini, ti' subeyob: ¿Majchetqui, che' jini? Subu a bʌ cha'an mic cha' suben tsa' bʌ i xiq'uiyon lojon tyʌlel. ¿Chuqui yom mi lojon c subeñob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan ti' jac'ʌ: Joñon muc'on bʌ ti c'am bʌ subt'an ti tyʌquin bʌ joch lum: Pʌtbenla majlel tyoj bʌ i bijlel lac Yum, cho'on. Che'ʌch mic subeñob che' bajche' ti' tyajayon ti t'an tsa' bʌ i xiq'ui i yʌle' Dios Isaías bʌ i c'aba' ti ñoj oniyix. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jini tsa' bʌ i pejcʌyob Juan jiñʌch tsa' chojqui majlel ti fariseojob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Che' jini, ti' c'ajtibeyob: Mi mach Cristojetic jini yacʌbil bʌ i cha'an Dios mi Elíasetic mi jinic tsa' bʌ i xiq'ui i yʌle' Dios, ¿chucoch ma' wʌc' ti ch'ʌm ja' quixtyañujob che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan ti' jac'ʌ: Joñon mi cʌc' ch'ʌm ja' ti ja' pero wʌ' ba' añonla an juntiquil mach bʌ ba'an mi la' cʌñe'. ");
INSERT INTO ctu76_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tyal tyo tic pat más ñuc bʌ. Joñon mach saj jasʌl c ñuclel mi cubin cha'an mic ticben i ch'ajñal i zapatos. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jiñʌch ti ujti ya' ti lum Betábara bʌ i c'aba' ya' ti jumpatlel colem ja' Jordán bʌ i c'aba'. Jiñʌch jini ja' ba' ti yʌc'ʌ ch'ʌm ja' Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ti yijc'ʌlel Juan ti yilʌ Jesús che' chʌncol i lʌq'ue' tyʌlel. Juan ti' tyaja ti t'an Jesús. Ti yʌlʌ: Q'uelela jiñʌch mu' bʌ i pejcʌntyel ti i Tiñʌme' Dios como mi quejel i ñusʌben i mul quixtyañujob, che'en. Como i tyʌlel mi tsʌnsʌntyel tiñʌme' yom bʌ yʌle' oveja ti ñoj oniyix cha'an i ñusʌbentyelob i mul. ");
INSERT INTO ctu76_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jiñʌch jini tsa' bʌ c tyaja ti t'an che' ñac ti cʌlʌ: Tyal tyo tic pat más ñuc bʌ bajche' joñon como an c'ʌlʌ ti tyejchibal mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ti ñaxan max tyo tij cʌñʌ pero ti tyʌliyon cʌc' ch'ʌm ja' cha'an mi cʌc' ti cʌjñel ti' tyojlel israelob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan ti yʌlʌ je'el: Ti quilʌ ti jubi tyʌlel ti panchan Ch'ujul bʌ i Ch'ujlel Dios che' bajche' x'ujcuts'u' yilal. Ti cʌyle ti' jol. ");
INSERT INTO ctu76_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Max tyo tij cʌñʌ mi jiñʌch tsa' bʌ i choco tyʌlel Dios. Pero Dios tsa' bʌ i xiq'uiyon cʌc' ch'ʌm ja' ti' subon: Che' ma' wilan ya' jubel Ch'ujul bʌ i Ch'ujlel Dios, ti jini winic ba' mi cʌytyʌl ti' jol jiñʌch mu' bʌ quejel i yʌq'ueñetla la' ch'ʌm Ch'ujul bʌ i Ch'ujlel Dios, che'en. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wale tsa'ix quilʌ. Jin cha'an mic subeñetla tsa' bʌ quilʌ cha'an jiñʌch i Yalobil Dios. Che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ti yijc'ʌlel cha' ya'an Juan ti' ti' ja' yic'ot cha'tiquil ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Che' ñac ti yilʌ Juan chʌncol i ñumel Jesús, ti yʌlʌ: Q'uelela jiñʌch i Tiñʌme' Dios yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Cha'tiquil ajcʌnt'añob i cha'an Juan ti yubi tsa' bʌ i yʌlʌ Juan. Ti queji i tsʌclen majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Che' jini, Jesús ti' q'uele i pat. Ti' sube jini cha'tiquil chʌncol bʌ i tsʌclen: ¿Chuqui chʌncol la' sajcan? che'en. Ti' jac'ʌyob: Maestro, ¿baqui chumulet? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús ti' jac'ʌ: Conla, q'uele, che'en. Che' jini ti majliyob yic'ot. Ti' q'ueleyob baqui chumul. Ya' ti cʌyleyob yic'ot Jesús cha'an ochix q'uin. ");
INSERT INTO ctu76_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Juntiquil tsa' bʌ i yubi i t'an Juan jiñʌch Andrés. Ti queji i tsʌclen Jesús. Jini Andrés i yijts'in Simón Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jini Andrés ñaxan ti majli i pʌy i yʌscun Simón bʌ i c'aba'. Ti' sube: Ti lojon c tyaja jini Mesías, che'en. Mesías yom i yʌl ti lac t'an Cristo yajcʌbil bʌ i cha'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wi'il tyo Andrés ti' pʌyʌ majlel Simón ya' ba'an Jesús. Che' ñac ti yilʌ Jesús ti' sube: Jatyet Simón, i yalobilet Jonás. Pero mi quejel a pejcʌntyel ti Cefas, che'en. Cefas yom i yʌl ti lac t'an Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ti yijc'ʌlel yom majlel Jesús ya' ti pañimil Galilea bʌ i c'aba'. Ti' tyaja Felipe. Ti' sube: Tsʌcleñon majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Loq'uem ti lum Betsaida bʌ i c'aba' jini Felipe. Ya' chumul je'el jini Andrés yic'ot Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Che' jini, Felipe ti majli i sajcan Natanael. Ti' sube: Ti lojon quilʌ jini winic tsa' bʌ i ña'tyʌ Moisés che' ti' wʌ ts'ijbu jini mandar ti ñoj oniyix yic'ot tsa' bʌ i xiq'ui i yʌle' Dios. Jiñʌch jini Jesús i yalobil bʌ José ch'oyol ti lum Nazaret bʌ i c'aba', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ti yʌlʌ Natanael: ¿Am ba chʌ bʌ wen ch'oyol bʌ ti Nazaret? che'en. Felipe ti' jac'ʌ: La', q'uele, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Che' ñac ti yilʌ Jesús chʌncol i lʌq'ue' tyʌlel jini Natanael ti' tyaja ti t'an Natanael. Ti yʌlʌ: Q'uele awilan, wʌ' mi tyʌlel juntiquil yoque israel bʌ mach bʌ ba'an mi' cha'len lot. Che' ti subenti Natanael ti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Che' jini, Natanael ti' jac'be: ¿Bajche'qui ti a cʌñʌyon? che'en. Jesús ti' sube: Ti quilʌyet che' ñac max tyo i pʌyʌyet Felipe che' ñac ya' tyo buchulet ti ye' tye' higuera bʌ i c'aba', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Che' jini, Natanael ti' sube: Maestro, i yalobilet bʌ Dios. Ñuquet bʌ yumʌl i cha'an israelob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús ti' jac'ʌ: ¿Mu' jach ba a ch'ujbiñon cha'an jach tic subeyet ti quilʌyet ti ye' higuera bʌ tye'? Mi quejel a wilan más ñuc tyac bajche' iliyi, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús ti yʌlʌ je'el: Melel mic subeñet: Mi quej la' q'uele' che' bajche' jamʌl jini panchan. Mi quej la' q'uele' ajtroñel i cha'an Dios ch'oyol bʌ ti panchan mi letsel mi jubel tic tyojlel Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ti yuxp'ejlel q'uin ti ujti ñujpuñel ya' ti jump'ej lum Caná bʌ i c'aba' ya' ti pañimil Galilea bʌ i c'aba'. Ya'an i ña' Jesús je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ti pʌjyi Jesús je'el yic'ot ajcʌnt'añob i cha'an cha'an mi majlel ba' chʌncol yujtyel ñujpuñel. ");
INSERT INTO ctu76_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Che' ñac ti jili i ya'lel ts'ujsub i ña' Jesús ti' sube: Tsa'ix jili i ya'lel ts'ujsub, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero Jesús ti' jac'ʌ: X'ixic, ¿chucoch ma' subeñon jini? che'en. Max tyo yorojlel c pʌs c ñuclel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero i ña' ti' subeyob jini mu' bʌ i ñusan i ya'lel ts'ujsub: Lu' jac'ʌla chʌ bʌ jach mi' subeñetla la' cha'len, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ya'an wʌcp'ej i yajnib ja' melel bʌ ti tyun. Mi yochel che' bajche' ochenta o cien litros ja' ti jujump'ej i yajnib. Israelob mi' c'ʌñob cha'an pocoñel cha'an bajche' mi' ch'ujbiñob. ");
INSERT INTO ctu76_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús ti' sube mu' bʌ i ñusan i ya'lel ts'ujsub: Lu' but'ula ti ja' ili yajnib ja' tyac, che'en. Ti' lu' but'uyob jintyo ti pajmi. ");
INSERT INTO ctu76_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Che' jini, Jesús ti' subeyob: Wale luchula ts'itya'. Ch'ʌmʌla majlel ba'an jini mu' bʌ ti xic'oñel cha'an q'uin, che'en. Chʌ'ʌch ti' cha'leyob. ");
INSERT INTO ctu76_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jini mu' bʌ ti xic'oñel cha'an q'uin ti' japʌ che' ts'intyʌl jini ja' tsa' bʌ pʌntiyi ti i ya'lel ts'ujsub. Pero mach'an ti' ña'tyʌ baqui tyʌlem. Jin jach mu' bʌ i ñusan i ya'lel ts'ujsub ti' ña'tyʌyob bajche' ti mejli como jiñobʌch ti' luchuyob jini ja'. Che' jini, jini mu' bʌ ti xic'oñel cha'an q'uin ti' pʌyʌ tyʌlel jini winic mu' bʌ ti ñujpuñel. ");
INSERT INTO ctu76_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ti' sube: I tyʌlelʌch ñaxan mi luchbentyel jini más wen bʌ i ya'lel ts'ujsub. Che' tsa'ix i japʌyob mi pʌs'entyel jini mach bʌ ñoj wen. Pero jatyet ti a lotyo jini más wen bʌ cha'an mi yʌq'uentyel ti wi'il. ");
INSERT INTO ctu76_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Che' ti pʌntiyi jini ja' ti ya'lel ts'ujsub jiñʌch ba' ti' ñaxan pʌsʌ ñuc bʌ i p'ʌtyʌlel Jesús. Ti' pʌsʌ i ñuclel ya' ti Caná ti Galilea. Jini ajcʌnt'añob i cha'an ti' ch'ujbiyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Che' ñac ti ujti jini q'uiñejel ti majli Jesús ti lum Capernaum bʌ i c'aba'. I ña' yic'ot i yijts'iñob yic'ot ajcʌnt'añob i cha'an Jesús ti majli yic'otyob. Ti' ñusʌyob cha'p'ej uxp'ej q'uin ya'i. ");
INSERT INTO ctu76_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Che' ñac lʌc'ʌlix i yorojlel pascua bʌ q'uin i cha'an bʌ israelob ti majli Jesús ya' ti lum Jerusalén bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ya'i ti' pat colem templo Jesús ti' tyajayob jini mu' bʌ i chon tyat wacax, tiñʌme' yom bʌ i yʌle' oveja yic'ot x'ujcutsu'. Ya'an je'el buchulo' bʌ ti mesa cha'an i q'uexben i tyaq'uin quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Che' ñac ti yilʌ Jesús chʌ bʌ muc'ob ti templo, ti' jalʌ pʌchi. Ti' chocoyob loq'uel ti pejtyelelob. Ti' choco loq'uel tiñʌme' yic'ot tyat wacax je'el. Ti' lu' chocbeyob i mesa tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús ti' subeyob jini ajchon x'ujcutsu': Loc'sanla pejtyelel chʌ bʌ yes an la' cha'an. Mach yom la' cha'len choñoñel wʌ' ti yotyot c Tyat am bʌ ti panchan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Che' jini, ajcʌnt'añob i cha'an ti cha' c'ajtiyi i cha'añob Ts'ijbubil bʌ i T'an Dios ba' mi yʌl: Mach com j q'uel jini mu' bʌ i cha'leñob bajche' jini como mij q'uel ti ñuc ili a wotyot, che'en. Che' ti' cha' pensaliyob jini ajcʌnt'añob i cha'an Jesús bajche' wʌ ts'ijbubil ti ñoj oniyix cha'an bajche' ti' cha'le Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Che' jini, jini israelob ti' c'ajtibeyob Jesús: ¿Chuqui ti i señʌjlel a p'ʌtyʌlel ma' pʌs'eñon lojon cha'an mi tsictiyel mi a wenta a cha'len che' bajche' jini? che' yʌlol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús ti' jac'ʌ: Jisanla iliyi templo. Ti yuxp'ejlel q'uin mi quej c cha' wa'chocon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Che' jini, jini israelob ti' subeyob: Ti cuarenta y seis años ti mejli jini templo. ¿Bajche'qui isujm che' ma' wʌl ti uxp'ej q'uin jach mi quej a cha' wa'chocon? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero jini templo tsa' bʌ i tyaja ti t'an Jesús jiñʌch i bʌc'tyal. ");
INSERT INTO ctu76_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jin cha'an che' ti cha' tyejchi loq'uel Jesús ba'an sajtyemo' bʌ, ajcʌnt'añob i cha'an ti cha' c'ajtiyi i cha'an bajche' ti ñaxan alʌ Jesús che' max tyo ti sajti. Che' jini ti' ch'ujbiyob cha'an melel jini t'an tsa' bʌ i wʌ subeyob Jesús yic'ot je'el ti' ch'ujbiyob Ts'ijbubil bʌ i T'an Dios ba' mi tyajtyʌl ti t'an cha'an jiñʌch mu' bʌ i chojquel tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Che' ñac ya'an ti Jerusalén Jesús ti yorojlel pascua bʌ q'uin, cabʌl ti' ch'ujbiyob Jesús. Ti' ch'ujbiyob che' ñac ti yilʌ ñuc tyac i p'ʌtyʌlel tsa' bʌ i pʌsʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús yujil isujm cha'an ili quixtyañujob mach'an ti' ch'ujbiyob ti pejtyelel i pusic'al como ti' lu' ña'tyʌ chʌ bʌ an ti' pusic'al quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach c'ʌñʌ i subentyel Jesús chuqui an ti' pusic'al quixtyañu como mi' bajñel ña'tyan chuqui an ti' pusic'alob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","An juntiquil fariseo bʌ winic Nicodemo bʌ i c'aba'. Jini juntiquil i yumob israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo ti c'oti ba'an Jesús ti ac'bʌlel. Ti' sube Jesús: Maestro, cujilix lojon isujm cha'an tyʌlemetyʌch ti Dios bajche' ajcʌntisajet. Como mach'an majch ch'ujbi i pʌs ñuc tyac bʌ i p'ʌtyʌlel mu' bʌ a cha'len mi mach'an Dios yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús ti' sube Nicodemo: Melel mic subeñet, jini mach bʌ ba'an mi' cha' ch'oc an mach ch'ujbi i yumin Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo ti' sube: ¿Bajche'qui ch'ujbi i cha' ch'oc an winic che' winiquix? ¿Ch'ujbi ba i cha' ajñel ti i ña' cha'an mi cha' ch'oc an? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús ti yʌlʌ: Melel mic subeñet: Jini mach bʌ ba'an mi ch'oc an cha'an ti ja' yic'ot cha'an ti Ch'ujul bʌ i Ch'ujlel Dios mach ch'ujbi i yumin Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Che' mi lac ch'oc an wʌ' ti mulawil mi la cʌq'uentyel lac bʌc'tyal. Che' mi ch'oc an quixtyañu ti Ch'ujul bʌ i Ch'ujlel Dios mi yʌq'uentyel tsiji' bʌ i cuxtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mach yom tyoj bʌc'ñʌjel ma' wubin cha'an jini c t'an tsa' bʌ c subet. Wersa yom la' cha' ch'oc an, bajche' tic subet. ");
INSERT INTO ctu76_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Jiñʌch che' bajche' jini ic' mi ñumel ba'ic jach mi ñumel. Mi la' wubin ic' pero mach a wujil isujm baqui mi tyʌlel baqui mi majlel. Chʌ'ʌch bajche' jini ch'oc ejemo' bʌ ti Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo ti' c'ajtibe Jesús: ¿Bajche'qui ch'ujbi yujtyel jini? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús ti' jac'ʌ: Jatyet maestrojet i cha'an lac pi'ʌlob israelob. ¿Mach'a ba'an ma' ña'tyan jini? che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Melel mic subeñet, mi lojon c cha'len t'an cha'an chʌ bʌ tyac ti lojon quilʌ. Mach'an mi la' ch'ujbin cha'an melel lojon c t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tsa'ix c subeyetla i sujmlel jini am bʌ ti panchan che' ñac mic laje' yic'ot wʌ' bʌ an ti mulawil. Mi mach'an mi la' ch'ujbin che' mic subeñetla chʌ bʌ yes wʌ'an ti mulawil, ¿bajche'qui mi quej la' ch'ujbin che' mic subeñetla chʌ bʌ an ti panchan? ");
INSERT INTO ctu76_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mach'an majch ti letsi majlel ti panchan, jin jach jini tsa' bʌ jubi tyʌlel ti panchan. Jin jach Joñon i Pi'ʌlon bʌ Quixtyañujob. Ya' añon ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Che' bajche' Moisés ti' joc'choco lucum ti tye' ti tyʌquin bʌ joch lum che' je'el mi quej c wersa letsʌntyel Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Cha'an majchical jach mi' ch'ujbin cha'an Ajcotyayajon i cha'an mach'an mi sajtyel cha'an ti bele' ora. Mi' tyaj i cuxtyʌlel mach'ʌ yujil jilel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Como chʌ'ʌch ti' wen p'untyʌ Dios jini año' bʌ ti mulawil. Ti yʌc'ʌ cojach bʌ i Yalobil. Majchical jach mu' bʌ i ch'ujbin ti i pusic'al i Yalobil Dios mach'an mi sajtyel. Mi' tyaj i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Como Dios mach'an ti' choco tyʌlel i Yalobil ti mulawil cha'an mi yotsan ti xot'mulil año' bʌ ti mulawil. Ti' choco tyʌlel cha'an mi' tyajob i cotyʌntyel ti Yalobil Dios jini año' bʌ ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jini mu' bʌ i ch'ujbin cha'an ajcotyaya i cha'an i Yalobil Dios mach'an mi yochel ti xot'mulil. Jini mach bʌ ba'an mi' ch'ujbin wʌ alʌlix mi quej i xot' i mul como mach'an ti' ch'ujbi jini cojach bʌ Yalobil Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jini mach'ʌ ba'an mi' ch'ujbin wʌ alʌlix mi quej i xot' i mul. Come ti tyʌli i sʌclel mulawil. Quixtyañujob ti' mulʌ ic't'ojñal bʌ mulawil. Mach'an ti' mulʌ i sʌclel mulawil come simaron mi' cha'leñob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Como pejtyel majchical mi' cha'len simaronlel mi' ts'a'q'uel i sʌclel mulawil. Mach'an mi' lʌq'ue' i sʌclel mulawil ame tsictiyic simaronlel muc'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jini mu' bʌ i cha'len chʌ bʌ yes wen tyac bʌ mi' lʌc' i sʌclel mulawil cha'an mi tsictiyel mu' bʌ i cha'len como mi' cha'len ti' p'ʌtyʌlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Che' ñac ti ujti ti t'an, ti majli Jesús yic'ot ajcʌnt'añob i cha'an ya' ti pañimil Judea bʌ i c'aba'. Ya' ti jale yic'otyob. Ti yʌc'ʌ ch'ʌm ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan je'el chʌncol i yʌc' ti ch'ʌm ja' ya' ti ja' Enón bʌ i c'aba' lʌc'ʌl ti lum Salim bʌ i c'aba' como ya' an cabʌl ja'. Ti c'oti quixtyañujob. Ti' ch'ʌmʌyob ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ti ujti ili che' ñac max tyo och ti cʌchol Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ti queji i subeñob i bʌ israelob yic'ot ajcʌnt'añob i cha'an Juan cha'an bajche' yom i pocob i bʌ yic'ot yambʌ pocoñel tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ti c'otiyob ba'an Juan. Ti' subeyob: Maestro, chʌncol i yʌc' ti ch'ʌm ja' jini am bʌ ti junxej ja' Jordán bʌ i c'aba'. Pejtyelel quixtyañu mi' t'uñob majlel tsa' bʌ a wʌc'ʌ ti ña'tyʌntyel che' ñac ti a cha'le subt'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan ti' jac'ʌ: Mach'an mi' tyaje' i ñuclel quixtyañujob, jin jach jini mu' bʌ i yʌq'uentyel i ñuclel ch'oyol bʌ ba'an Dios ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jatyetla tsa'ix la' wubi c t'an. La' wujil tic subu mach Cristojonic, jini yajcʌbil bʌ. Tsa' jach ñaxan chojquiyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jini yajcʌbil bʌ che' bajche' ajñujpuñel tsa' bʌ i tyaja i yijñam. I pi'ʌl mu' bʌ i majlel i yotsan ajñujpuñel, mu' bʌ i majlel i yubiben i t'an wen c'ajacña i yoj cha'an i t'an ajñujpuñel. Joñon, cho'on, bajche' jini i pi'ʌl mu' bʌ majlel i yotsan ajñujpuñel yubi. Jin cha'an ts'ʌcʌlix c'ajacña bʌ coj. ");
INSERT INTO ctu76_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wersa mi' ñuc isʌntyel Cristo, wersa mic ju' sʌntyel, che' ti yʌlʌ Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jini ch'oyol bʌ ti panchan, i yumʌch pejtyelel chʌ bʌ an. Jini ch'oyol bʌ ti mulawil, i cha'añʌch mulawil, mu' jach i ña'tyañob chʌ bʌ yes an ti mulawil. Jini ch'oyol bʌ ti panchan i yumʌch ti pejtyelelob. ");
INSERT INTO ctu76_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jini ch'oyol ti panchan mi' sub chʌ bʌ yes ti yilʌ yic'ot chʌ bʌ ti yubi. Mach'an majch mi' ch'ujbin cha'an melel mu' bʌ i yʌle'. ");
INSERT INTO ctu76_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero mi an majch mi' ch'ujbin mu' bʌ i yʌle' jini ch'oyol bʌ ti panchan mi' yʌl cha'an yoque melelʌch i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Como jini tsa' bʌ chojqui tyʌlel cha'an Dios, mi' sube' i t'an Dios. Dios mach'an i p'isol bajche' mi yʌc' Ch'ujul bʌ i Ch'ujlel. ");
INSERT INTO ctu76_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Lac Tyat mi' p'untyan i Yalobil. Tsa'ix i yʌq'ue ti' wenta i Yalobil pejtyelel chʌ bʌ an tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jini mu' bʌ i ch'ujbin cha'an Ajcotyaya i cha'an i Yalobil Dios, anix i cha'an i cuxtyʌlel mach'ʌ yujil jilel. Jini mach bʌ ba'an mi' ch'ujbin i Yalobil Dios, mach ch'ujbi i yʌq'uentyel i cuxtyʌlel. Mi yajñel ti' mich'lel Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jini fariseojob ti queji i yubin cha'an más on chʌncol bʌ i tsʌclentyel Jesús bajche' jini mu' bʌ i tsʌclen Juan. Yic'ot más mi yʌc' ch'ʌm ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aunque mach'an ti yʌc'ʌ ch'ʌm ja' Jesús pero jini ajcʌnt'añob i cha'an ti yʌc'ʌyob ch'ʌm ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Cha'an yujil isujm Jesús bajche' ti' pensaliyob jini fariseojob, ti loq'ui majlel Jesús ya' ti Judea cha'an mi cha' sujtyel ti pañimil Galilea bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wersa mi ñumel Jesús ti pañimil Samaria bʌ i c'aba' che' sujtyelix muc'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Che' jini ti c'oti ti jump'ej lum Sicar bʌ i c'aba' ya' bʌ an ti Samaria. Ti lʌc'ʌlel Sicar an jumpejt lum i cha'an bʌ Jacob ti ñoj oniyix. Jini lum jiñʌch tsa' bʌ i yʌq'ue José bʌ i c'aba' bʌ yalobil Jacob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ya'an jump'ej pozo mu' bʌ i pejcʌntyel ti i cha'an Jacob como jin ti' piqui ti ñoj oniyix. Cha'an wen lujb Jesús ti xʌmbal ti buchle ya' ti' ti' pozo. Yomox i tyaj xinq'uinil. ");
INSERT INTO ctu76_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ti majli ajcʌnt'añob i cha'an Jesús ya' ti lum cha'an i mʌn chʌ bʌ mi' c'uxob. Che' jini, ti c'oti juntiquil x'ixic ya' bʌ chumul ti Samaria ti luch ja'. Jesús ti' sube: Aq'ueñon ts'itya' ja' cha'an cape', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Che' jini, jini x'ixic am bʌ ti Samaria ti' sube Jesús: ¿Bajche' isujm che' jatyet israelet ma' c'ajtibeñon ja' che' x'ixicon tyʌlemon ti Samaria? che'en. (Como i tyʌlel jini israelob ma' mi' pejcañob i bʌ yic'ot jini año' bʌ ti pañimil Samaria.) ");
INSERT INTO ctu76_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Che' jini, Jesús ti' jac'ʌ: Muq'uic a ña'tyan chʌ bʌ yom i yʌq'ueñetla Dios, muq'uic a ña'tyan majchonqui chʌncol bʌ j c'ajtibeñet ja', jatyetyʌch mi quejel a c'ajtibeñon ja'. Che' jini joñon mi quejel cʌq'ueñet jini ja' mu' bʌ yʌq'ueñet a cuxtyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jini x'ixic ti' sube: C yum, mi anic chʌ bʌ a c'ʌñʌ a luch loq'uel jini ja'. Aro jini pozoji tyam. ¿Baqui ma' tyajbeñon ja' mu' bʌ i yʌq'ueñon j cuxtyʌlel, ma' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lac yumob ti ñoj oniyix ti' cʌybeyonla ili i pozo ba' ti' japʌ ja' yic'ot pejtyelel i yalobilob yic'ot i yʌlac' je'el. ¿Más ñuquet ba bajche' Jacob? Che' ti yʌlʌ jini x'ixic. ");
INSERT INTO ctu76_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús ti' jac'ʌ: Ti pejtyelel mu' bʌ i jape' ili ja' mi cha' quejel i tyʌquin i ti'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero jini mu' bʌ i jape' jini ja' mu' bʌ cʌq'ueñob ma'ix ba' bʌ ora mi quejel i cha' tyʌquin i ti' yubil. Como jini ja' mu' bʌ cʌq'uen mi yajñel che' bajche' i loq'uib ja' ti' pusic'al cha'an bele' ora cha'an mi yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Che' jini, jini x'ixic ti' sube: Aq'ueñon jini ja' cha'an machic ba'an ba' bʌ ora mic cha' ubin tyʌquin ti', cha'an ma'ix mic bej cha' tyʌlel ti luch ja' wʌ' ti ili pozo, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús ti' sube: Cucu, pʌyʌ tyʌlel a ñoxi'al. Che' jini, ma' cha' tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jini x'ixic ti' jac'ʌ: Ma'an c ñoxi'al, che'en. Che' jini, Jesús ti' sube: Melelʌch che' ma' wʌl ma'ix a ñoxi'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Como tsa'ix ajni a wic'ot jo'tiquil a ñoxi'al. Jini a wic'ot bʌ wale iliyi mach a ñoxi'alic. Tsiquil melelʌch bajche' ti a wʌlʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Che' ñac jini x'ixic ti yubi i t'an, ti' sube Jesús: Wale mic ña'tyan jatyet juntiquil tsa' bʌ i xiq'ui a wʌle' Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lojon c yumob ti ñoj oniyix jini samaritanojob ti' ch'ujutisʌyob Dios wʌ' ti ili wits. Pero jatyetla, israelet bʌ la mi la' wʌl ya' ti Jerusalén yom lac ch'ujutisan Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús ti' sube jini x'ixic: Ch'ujbin c t'an cha'an tyal i yorojlel mi quejel la' ch'ujutisan c Tyat ti panchan che' mach cʌñʌ la' tyʌlel mi wʌ'ic ti ili wits mi ya'ic mi la' majlel ti Jerusalén cha'an la' ch'ujutisan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jatyetla samaritanojet bʌ la, mach'an mi la' ña'tyan chʌ bʌ mi la' ch'ujutisan. Pero joñon lojon israelon bʌ lojon mi lojon c ña'tyan. Como tyal i cotyʌntyel pejtyelel quixtyañujob ba'an israelob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero cha'an ti tyʌliyon, tyal i yorojlel mi quejel i ch'ujutisan c Tyat ti' pusic'alob che' mach'an chʌ bʌ an che' mi yoque ch'ujutisan c Tyat am bʌ ti panchan cha'an chʌ'ʌch yom mi ch'ujutisʌntyel ti jini mu' bʌ i ch'ujutisan c Tyat, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Como Dios mach'an tsiquil como ti' ch'ujlel jach an. Jini yom bʌ i ch'ujutisan Dios yom i yoque ch'ujutisan ti i pusic'al che' mach'an chʌ bʌ mi' q'uele', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jini x'ixic ti' sube: Cujil isujm mi quejel i tyʌlel Mesías mu' bʌ i pejcʌntyel ti Cristo. Che' mi tyʌlel mi quejel i lu' tsictisʌbeñonla i sujmlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús ti' sube: Joñoñʌch jini Mesías chʌncolon bʌ ti t'an a wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti jim bʌ ora ti cha' c'oti ajcʌnt'añob i cha'an. Tyoj bʌc'ñʌjel ti yubiyob cha'an ti yilʌyob muc' ti t'an Jesús yic'ot juntiquil x'ixic ch'oyol bʌ ti Samaria. Pero mach'an majch ti' c'ajtibe chʌ bʌ yom o chuqui chʌncol i yʌlob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Che' jini, jini x'ixic ti' cʌyʌ i yuc'un. Ti majli ti lum ba' ti' sube quixtyañujob: ");
INSERT INTO ctu76_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","La'la. Q'uelela juntiquil winic tsa' bʌ i lu' subon ti pejtyelel chʌ bʌ tyac tic cha'le. ¿Mach'a jinic jini Cristo mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Che' jini, ti loq'uiyob majlel ti lum. Ti majliyob ya' ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Che' max tyo ti c'oti jini quixtyañujob ajcʌnt'añob i cha'an ti' subeyob Jesús: Maestro, cha'len uch'el, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Jesús ti' subeyob: An chʌ bʌ mij c'ux mach bʌ ba'an mi la' ña'tyan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jini ajcʌnt'añob i cha'an ti' c'ajtibeyob i bʌ: ¿Am ba majch ti' ch'ʌmbe tyʌlel chʌ bʌ mi' c'uxe'? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús ti' subeyob: Che' bajche' cuch'el che' mic cha'len chʌ bʌ yom jini tsa' bʌ i chocoyon tyʌlel yic'ot che' mic jolontisan i toñel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jatyetla mi la' wʌl: Cʌyʌ tyo chʌmp'ej uw cha'an c'ajbal, che'etla. Pero joñon mic subeñetla: Q'uelela jini cholel. C'ʌnix. I yorojlelix c'ajbal yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jini mu' bʌ ti c'ajbal mi' ch'ʌm i tyojol ti' wut mu' bʌ i tyuc'ob. I wut mi quejel i yajñel ti bele' ora. Jini mu' bʌ ti pac' yic'ot jini mu' bʌ ti c'ajbal lajal c'ajacña i yoj mi yubin, che'en. Como ti' laja jini c'ajbal che' bajche' quixtyañu mu' bʌ quejel i ch'ujbin Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Melelʌch jini albil bʌ t'an mu' bʌ i yʌl: Juntiquil mi' cha'len pac'. Yañʌch bʌ mi' cha'len c'ajbal. Che' mi yʌle' albil bʌ t'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Joñon tic chocoyetla majlel ti c'ajbal yubil ba' mach'an ti la' cha'le pac'. Yaño' bʌ ti' cha'le toñel pero jatyetla mi la' cha'len c'ajbal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Cabʌl jini año' bʌ ti lum Sicar ya' ti Samaria ti' ch'ujbiyob Jesús cha'an ti caj jini tsa' bʌ i sube jini x'ixic che' ñac ti yʌlʌ: Ti' subon pejtyelel chʌ bʌ tyac tic cha'le, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Che' ñac ti c'oti jini samaritanojob ti' c'ajtibeyob cha'an mi jalejel yic'otyob. Jesús ti jale cha'p'ej q'uin. ");
INSERT INTO ctu76_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Cabʌl yaño' bʌ ti' ch'ujbiyob Jesús je'el che' ñac ti yubibeyob i t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Che' jini, ti' subeyob jini x'ixic: Wale mi lojon c ch'ujbin. Mach cha'anic jach a t'an como tsa'ix lojon cubi i t'an Jesús je'el. Cujil lojon isujm cha'an melel jiñʌch Cristo jini Ajcotyaya i cha'an pejtyelel año' bʌ ti mulawil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Che' tsa'ix ñumi cha'p'ej q'uin Jesús ti loq'ui majlel ti Samaria. Ti bej majli ti pañimil Galilea bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Como Jesús ti wʌ alʌ cha'an ma'ix mi q'uejlel ti ñuc ti i lumal jini mu' bʌ i xiq'ue' i yʌle' Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Che' ñac ti c'oti ti Galilea weñʌch ti yilʌyob Jesús ya'i como an jini tsajniyobix bʌ je'el ti pascua bʌ q'uin ti Jerusalén. Tsa'ix i lu' ilʌyob pejtyelel tsa' bʌ i cha'le Jesús ya'i. ");
INSERT INTO ctu76_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Che' jini, Jesús ti sujti ti Caná ya' ti Galilea ba' ti pʌntisʌ ti i ya'lel ts'ujsub jini ja'i. Ya'i an juntiquil ñuc bʌ ajtroñel i cha'an yumʌl. C'am i yalobil ya' ti lum Capernaum bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Che' ñac ti yubi jini ñuc bʌ ajtroñel i cha'an yumʌl cha'an tsa'ix cha' loq'ui tyʌlel Jesús ti Judea ti cha' c'oti ti Galilea. Ti majli i q'uel Jesús cha'an i c'ajtin cha'an mi majlel ti yotyot cha'an mi' lajmisan alo' bʌ i yalobil yomox bʌ sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Che' jini, Jesús ti' sube: Jatyetla mach'an mi la' ch'ujbiñon che' ma' mi la' wilan i señʌjlel c p'ʌtyʌlel mi ma' mi la' pʌs'entyel ñuc tyac bʌ c p'ʌtyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero jini ñuc bʌ ajtroñel ti yʌlʌ: La' ti ora, ame sajtic calobil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Che' jini, Jesús ti' sube: Sujtyen ti a wotyot. Mi quejel i lajmel a walobil. Ti' ch'ujbi cha'an melel i t'an Jesús jini winic. Ti sujti majlel ti yotyot. ");
INSERT INTO ctu76_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Che' yomox c'otyel ti i yotyot, jini ajtoñelob i cha'an ti majli i tyaj tyʌlel. Ti' subeyob: Cuxul a walobil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Che' jini, ti' c'ajtibeyob bajche'qui ora ti queji i lajmel. Ti' subeyob: Ac'bi ti lajmi ti c'ajc che' ts'itya' ñumenix xinq'uinil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Che' jini, i tyat jini ajc'am'an ti queji i ña'tyan jiñʌch bʌ ora che' Jesús ti' sube: Mi quejel i lajmel a walobil, che'en. Jini winic yic'ot ti pejtyelel am bʌ ti i yotyot ti queji i ch'ujbiñob cha'an Ajcotyaya i cha'añob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiñʌch i cha'yajlelel ti' pʌsʌ ñuc tyac bʌ i p'ʌtyʌlel Jesús ya' ti Galilea. Jiñʌch ti' cha'le Jesús ti Galilea che' cha' sujtyemix tyʌlel ti Judea. ");
INSERT INTO ctu76_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ti wi'il ti' meleyob jump'ej q'uiñejel jini israelob. Jesús ti cha' sujti ti Jerusalén. ");
INSERT INTO ctu76_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ya' ti ts'ajc tsa' bʌ i c'ʌñʌ i joy mʌcob Jerusalén an jump'ej i ti' i c'aba' Ovejajob. Ya'an jump'ej colem bʌ i yajnib ja' Betesda bʌ i c'aba'. An jo'p'ej i corredor tyac ti' joytyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ya' tsol tyots'olob cabʌl ajc'am'añob; muts'ulo' bʌ i wut yic'ot mach bʌ wen tyacob i yoc yic'ot mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb. Ti lu' pijtyʌyob cha'an mi ñijcʌntyel ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Como an jach i yorojlel mi jubel ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. Mi jubel tyʌlel cha'an i nijcan jini ja'. Jini mu' bʌ i ñaxan ochel che' tsa'ix nijcʌnti ja' ti lajmisʌnti chʌ bʌ jach tyac ti chʌmel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ya'an je'el juntiquil winic am bʌ i c'am'an c'ʌlʌ treinta y ocho años. ");
INSERT INTO ctu76_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Che' ñac ti yilʌ Jesús ya' tyots'ol ti' ña'tyʌ anix cabʌl jabilel ya' tyots'ol. Ti' sube jini ajc'am'an: ¿A wom ba lajmiquet? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jini ajc'am'an ti' jac'ʌ: Mach'an majch mi yotsañon ti ja' che' mi nijcʌntyel jini ja'. Jujunyaj che' com ochel an majch yambʌ mi ñaxan ochel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús ti' sube: Tyejchen. Lotyox a pojp. Cha'lenix xʌmbal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ti jin jach bʌ ora ti lajmisʌnti jini winic. Ti' lotyo i pojp. Ti queji ti xʌmbal. Pero i yorojlel c'aj oj i cha'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jini israelob ti' sube tsa' bʌ lajmisʌnti: I yorojlelix c'aj oj. Tiq'uil cha'an a ch'ʌme' majlel a pojp, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jini winic ti' jac'ʌ: Jini tsa' bʌ i lajmisʌyon ti' subon: Lotyox a pojp. Cha'lenix xʌmbal. Che' ti' subon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Che' jini, ti' c'ajtibeyob jini tsa' bʌ lajmisʌnti: ¿Majchqui jini tsa' bʌ i subet: Lotyox a pojp, cha'lenix xʌmbal? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero mach'an ti' ña'tyʌ jini winic majchqui jini tsa' bʌ i lajmisʌ como an ñoj cabʌl quixtyañu. Jesús ti loq'ui majlel ti xinilob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ti wi'il Jesús ti' tyaja jini winic ti templo. Ti' sube: Q'uele awilan, wale lajmeñetix. Mach yom ma' cha' cha'len mulil ame an chʌ bʌ yes más tsʌts bʌ wocol mi quejel a wʌq'uentyel a ñusan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jini winic ti majli i suben israelob cha'an jiñʌch Jesús tsa' bʌ i lajmisʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jin cha'an israelob ti' tyʌc'lʌyob Jesús. Ti queji i pensalin i tsʌnsañob Jesús cha'an jach ti' cha'le lajmisaya ti yorojlel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús ti' subeyob: C'ʌlʌ wale iliyi c Tyat ti panchan mi' cha'len wen bʌ toñel. Joñon je'el mic cha'len wen bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jin cha'an más yomox i tsʌnsañob Jesús jini israelob. Como mach jinic jach ti' cha'le lajmisaya ti yorojlel c'aj oj, pero cha'an ti caj je'el ti' laja i bʌ yic'ot Dios. Como ti yʌlʌ i Tyatyʌch Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Che' jini, Jesús ti' subeyob: Melel mic subeñetla: Joñon i Yalobilon Dios. Mach'an chʌ bʌ ch'ujbi c cha'len tic bajñelil. Jin jach mu' bʌ quilan i cha'len c Tyat mic cha'len je'el. Ti pejtyelel chʌ bʌ jach mi' cha'len c Tyat ti panchan mic cha'len je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Como c Tyat ti panchan mi' p'untyañon. Mi' pʌs'eñon ti pejtyelel chʌ bʌ jach mi' cha'len. Mu' tyo quejel c pʌs'eñetla más ñuc tyac bʌ. Tyoj bʌc'ñʌjelet bʌ la mi quej la' wubin. ");
INSERT INTO ctu76_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Como che' bajche' c Tyat ti panchan mi' tyech loq'uel quixtyañujob ba'an sajtyemo' bʌ chʌ'ʌch bajche' mi yʌq'uen i cha' cuxtiyel chʌ'ʌch joñon je'el i Yalobilon mi cʌc' ti cuxtiyel majchical jach com bʌ cʌq'uen i cuxtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","C Tyat ti panchan tsa'ix i yʌq'ueyon tic wenta cha'an mic cha'len melojel. Ma'ix majch mi' mele'. Cha'an ti pejtyelel quixtyañujob mi lajal q'uelon ti ñuc bajche' mi' q'uelob ti ñuc c Tyat ti panchan. Jini mach'ʌ ba'an mi' q'uelon ti ñuc ma'ix mi' q'uel ti ñuc c Tyat je'el tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Melel mic subeñetla: Jini mu' bʌ i yoque ñʌch'tyan c t'an yic'ot mu' bʌ i ch'ujbin Dios tsa' bʌ i chocoyon tyʌlel anix i cha'an i cuxtyʌlel mach'ʌ yujil jilel. Ma'ix mi yʌq'uentyel i xot'e' mulil como tsa'ix aq'uenti i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Melel mic subeñetla: Cha'an ti tyʌliyon, tyal i yorojlel che' mi quejel i yubin c t'an i Yalobilon Dios jini sajtyemo' bʌ. Jini mu' bʌ i jac'beñon c t'an mi yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Como c Tyat an i p'ʌtyʌlel cha'an mi yʌq'uen quixtyañujob i cuxtyʌlel mach'ʌ yujil jilel. Che' je'el tsa'ix i yʌc'on i p'ʌtyʌlel como i Yalobilon cha'an cʌq'uen i cuxtyʌlel quixtyañu mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tsa'ix i yʌc'on tic wenta c cha'len melojel cha'an Joñon i Pi'ʌlon bʌ Quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mach yom tyoj bʌc'ñʌjeletla mi la' wubin como tyal i yorojlel jini sajtyemo' bʌ mi quejel i yubibeñon c t'an Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Mi quejel i loq'uel tyʌlel ba' ch'ujñʌbilob. Jini tsa' bʌ i cha'le wen bʌ mi quejel i cuxtiyel cha'an ti bele' ora. Pero jini tsa' bʌ i cha'leyob mach'ʌ wen mi quejel i tyejchel loq'uel cha'an i xot'e' i mul. ");
INSERT INTO ctu76_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Mach'an chʌ bʌ ch'ujbi c cha'len cha'an jach com tic bajñel c pusic'al. Mic cha'len melojel jiñʌch bajche' mic subentyel tic Tyat. Tyojʌch mic cha'len melojel como mic cha'len bajche' yom c Tyat ti panchan tsa' bʌ i chocoyon tyʌlel. Ma'ix mic cha'len bajche' bajñel com tic pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Mi tic bajñel subu cha'an chocolon tyʌlel, mach yom ch'ujbinticon. ");
INSERT INTO ctu76_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero an yambʌ mu' bʌ i sub cha'an chocolon tyʌlel. C'ʌjnibalʌch mi ch'ujbintyel i t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jatyetla ti' la' choco majlel winicob ba'an Juan cha'an la' c'ajtiben majchqui jini Juan. Jini ti yʌc'ʌyon ti cʌjñel cha'an chocolon tyʌlel ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero mach wersa i yʌc'on ti cʌjñel quixtyañu. Chʌncol jach c subeñetla cha'an melelʌch i t'an Juan cha'an ch'ujbi la' tyaj la' cotyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jini Juan che' bajche' ts'ʌbʌl bʌ pat cas mu' bʌ i wen pʌs i c'ʌc'al. Jatyetla poj tijicñayetla che' ñac ti la' ñʌch'tyʌ chʌ bʌ ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero an chʌ bʌ más ñuc tyac bʌ bajche' i t'an Juan mu' bʌ i yʌc' ti cʌjñel majchonqui. Jini ñuc tyac bʌ c p'ʌtyʌlel mi yʌc'on ti cʌjñel cha'an chocolon tyʌlel ti Dios. Jini mi' tsictisan cha'an c Tyat ti panchan ti' chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Che' je'el aunque mach'an ba' bʌ ora ti la' wubibe i t'an c Tyat mach'an ba' bʌ ora ti la' wilʌ. Pero c Tyat ti panchan tsa' bʌ i chocoyon tyʌlel mi yʌc'on ti cʌjñel cha'an chocolon tyʌlel i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero mach'an ti la' ñoj ch'ujbi cha'an melel i t'an jini tsa' bʌ i yʌc'ʌyon ti cʌjñel cha'an chocolon tyʌlel ti Dios. Como ma' ti la' ch'ujbiyon tsa' bʌ chojquiyon tyʌlel tic Tyat ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jatyetla mi la' wen q'uele' jini Ts'ijbubil bʌ i T'an Dios cha'an la' wom la' tyaj la' cuxtyʌlel mach'ʌ yujil jilel. Pero jiñʌch jini Ts'ijbubil bʌ i T'an Dios mi yʌc'on ti cʌjñel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jatyetla mach la' wom la' ch'ujbin cha'an chocolon tyʌlel cha'an mi la' wʌq'uentyel la' cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ma' mic sajcan i sujbel c ñuclel ti quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero mij cʌñetla. Cujil isujm cha'an mach'an mi la' p'untyan Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","C Tyat ti panchan ti' chocoyon tyʌlel pero mach'an mi la' ch'ujbiñon. Pero mi an majch mi bajñel tyʌlel mi quejel la' lolon ch'ujbin. ");
INSERT INTO ctu76_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Bajche'qui ch'ujbi la' ch'ujbiñon che' mi la' bej sajcan la' ñuclel ti' tyojlel la' pi'ʌlob? Pero ma'ix mi la' jop' la' tyaj la' ñuclel ti' tyojlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mach yom mi la' lolon pensalin cha'an joñon mi quejel c sub la' mul ti' tyojlel c Tyat ti panchan. Pero añʌch juntiquil mu' bʌ i sub la' mul. Jiñʌch Moisés mu' bʌ la' ch'ujbin cha'an melel i t'an mi la' lolon al. ");
INSERT INTO ctu76_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Como mi muq'uic la' ch'ujbin cha'an melel i t'an Moisés mi la' ch'ujbin je'el cha'an Dios ti' chocoyon tyʌlel. Como Moisés ti' ts'ijbu cha'añon. ");
INSERT INTO ctu76_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero mi ma' mi la' ch'ujbin cha'an melel jini tsa' bʌ i ts'ijbu Moisés ti ñoj oniyix, ¿bajche'qui mi quejel la' ch'ujbin cha'an melel jini mu' bʌ c subeñetla? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ti wi'il Jesús ti majli ti junxej colem joyol bʌ ja' Galilea bʌ i c'aba'. Cha'chajplel bʌ i c'aba' jini ja' Tiberias. ");
INSERT INTO ctu76_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Cabʌl quixtyañu ti' tsʌcleyob majlel Jesús como tsa'ix i yilʌyob ti' pʌsʌ ñuc tyac bʌ i p'ʌtyʌlel che' ñac ti' lajmisʌ ajc'am'añob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Che' jini, Jesús ti letsi ti jump'ej bujtyʌl. Ya'i ti buchle yic'ot ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Lʌc'ʌlix i yorojlel pascua bʌ q'uin i cha'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Che' ñac ti yilʌ Jesús ñoj cabʌl quixtyañu chʌncol i tsʌcleñob ti' sube Felipe: ¿Baqui mi quejel lac mʌñe' waj cha'an pejtyelel ili quixtyañujob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Chʌ'ʌch ti yʌlʌ Jesús cha'an jach mi' tsictisan bajche' mi quejel i jaq'ue' Felipe. Come Jesús wʌ yujil isujm chʌ bʌ yes mi quejel i cha'len. ");
INSERT INTO ctu76_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Che' jini, Felipe ti' jac'ʌ: Mach jastyay mi ti laj c'ʌñʌ doscientos denarios cha'an mi lac mʌmbeñob waj cha'an i c'uxob ya' ts'itya' jach ti jujuntiquil, che'en. Doscientos denarios i tyojol doscientos días toñel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Che' jini, Andrés, juntiquil ajcʌnt'an i cha'an Jesús i yijts'in Simón Pedro ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Umba'an juntiquil alob am bʌ joq'uej i waj melel bʌ ti cebada. An cha'cojt i chʌy je'el. ¿Pero chʌ bʌ yes i c'ʌjnibal jini che' ñoj cabʌl quixtyañu? Che' ti yʌlʌ Andrés. ");
INSERT INTO ctu76_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Che' jini, Jesús ti' subeyob: Subenla ti pejtyelel cha'an mi buchtyʌlob, che'en. Ya'an cabʌl jam. Che' bajche' jo'p'ej mil winicob ti buchleyob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Che' jini, Jesús ti' ch'ʌmʌ jini waj. Ti' sube Dios wocox i yʌlʌ. Ti yʌq'ue ajcʌnt'añob i cha'an. Ti' pucbeyob ti pejtyelel ya' bʌ buchulob. Chʌ'ʌch ti' pucbeyob je'el jini chʌy. Ti aq'uentiyob che' bajche' c'amel yom i c'uxob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Che' ñac tsa'ix ñaj'ʌyob, Jesús ti' sube ajcʌnt'añob i cha'an: Lotyola ti pejtyelel i xejt'il tyac waj tsa' bʌ colojbʌyi cha'an ma' mi lolon jilel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ti' lotyoyob jini tsa' bʌ colojbʌyi. Ti' but'uyob doce chiquib i xejt'il tyac jini cebada bʌ waj. ");
INSERT INTO ctu76_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Che' jini, che' ñac ti yilʌ jini quixtyañujob jini ñuc bʌ i p'ʌtyʌlel tsa' bʌ i pʌsʌ Jesús, ti yʌlʌyob: Melelʌch jiñʌch juntiquil ñuc bʌ tsa' bʌ i xiq'ui i yʌle' Dios wersa bʌ yom mi tyʌlel ti mulawil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero Jesús yujil isujm cha'an wersa yom i yotsañob ti ñuc bʌ yumʌl i cha'añob. Jin cha'an ti cha' bajñel majli ti chan bʌ wits. ");
INSERT INTO ctu76_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Che' bʌ ac'bʌlelix jini ajcʌnt'añob i cha'an Jesús ti jubi majlel ti' ti' colem joyol bʌ ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ti ochiyob ti barco. Ti queji i c'axelob ti jini colem joyol bʌ ja' cha'an mi majlel ti lum Capernaum bʌ i c'aba'. Iq'uix. Pero Jesús max tyo ti jubi tyʌlel ti bujtyʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ti queji ti ñumel p'ʌtyʌl bʌ ic'. Ti queji i wen letsel jini ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Che' ñac tsa'ix i bej ñijcʌyob majlel barco che' bajche' jump'ej legua, ti yilʌyob Jesús chʌncol i lʌq'ue' tyʌlel barco. Chʌncol ti xʌmbal tyʌlel ti' pam ja'. Ti' cha'leyob bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero Jesús ti' subeyob: Joñoñʌch. Mach yom la' cha'len bʌq'uen, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Che' jini, c'ajacña i yoj ti queji i yubiñob. Ti' pʌyʌyob ochel Jesús ti barco. Ora jach ti c'otiyob ti' ti' ja' ba' yomob majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ti yijc'ʌlel ti queji i ña'tyañob quixtyañujob tsa' bʌ cʌyle ti junxej colem joyol bʌ ja' cha'an tsa'ix majliyob ajcʌnt'añob i cha'an Jesús ti jini cojach bʌ barco ya' bʌ an. Ti' ña'tyʌyob ma'ix ti sujti Jesús yic'otyob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero ti jumuc' ti c'oti yambʌ barco tyac ya' ti lum Tiberias bʌ i c'aba' lʌc'ʌl ba' ti' c'uxuyob jini waj che' ñac lac Yum ti' sube Dios wocox i yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Che' ñac jini quixtyañujob ti queji i ña'tyan mach bej ya'ic an Jesús mi ajcʌnt'añobic i cha'an je'el, ti ochiyob ti barco tyac. Ti majliyob ti Capernaum cha'an i sajcañob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Che' ñac ti c'oti ti junxej colem joyol bʌ ja' jini quixtyañujob ti' tyajayob Jesús. Ti' c'ajtibeyob: Maestro, ¿bajche'qui ora ti juliyet? ");
INSERT INTO ctu76_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero Jesús ti' subeyob: Melel mic subeñetla: Mi la' sajcañon cha'an jach ti la' c'uxu jini waj jintyo ti ñaj'ʌyetla. Mach'an mi la' sajcañon cha'an ti caj ti la' ch'ʌme' isujm jini ñuc bʌ c p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mach yom mi jin jach mi la' cha'len toñel cha'an la' tyaj waj mu' jach bʌ i jilel. Pero yom mi la' cha'len wersa je'el cha'an la' tyaje' mu' bʌ i jalijel mu' bʌ i yʌq'ueñetla la' cuxtyʌlel mach'ʌ yujil jilel. Jiñʌch jini waj mu' bʌ cʌq'ueñetla Joñon i Pi'ʌlon bʌ Quixtyañujob como Dios c Tyat tsa'ix i yʌc'on tic wenta cha'an cʌq'ueñob i cuxtyʌlel mach'ʌ yujil jilel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Che' jini, ti' c'ajtibeyob Jesús: ¿Chʌ bʌ ti toñel yom mi lojon c cha'len cha'an mi lojon c cha'len jini yom bʌ Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús ti' jac'ʌ: Jini yom bʌ Dios jiñʌch cha'an mi la' ch'ujbiñon tsa' bʌ chojquiyon tyʌlel ti Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Che' jini, jini quixtyañujob ti' c'ajtibe Jesús: ¿Chuqui ti seña ch'ujbi a pʌs'eñon lojon cha'an mi lojon quilan cha'an mi lojon j ch'ujbin cha'an melel a t'an? ¿Chuqui ti ñuc tyac bʌ a p'ʌtyʌlel ma' pʌs? ");
INSERT INTO ctu76_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lac yumob ti ñoj oniyix ti' c'uxuyob maná ya' ti tyʌquin bʌ joch lum che' bajche' mi yʌle' ti Ts'ijbubil bʌ i T'an Dios: Dios ti yʌq'ueyob uch'el tyʌlem bʌ ti panchan. Che' ts'ijbubil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús ti' jac'ʌ: Melel mic subeñetla: Mach jinic Moisés ti yʌq'ueyob uch'el tyʌlem bʌ ti panchan. C Tyatyʌch tsa' bʌ i choco tyʌlel jini uch'el. Jiñʌch mu' bʌ i yʌq'ueñetla jini isujm bʌ uch'el tyʌlem bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Como jini uch'el yubil mu' bʌ i yʌq'ueñetla Dios jiñʌch juntiquil tsa' bʌ jubi tyʌlel ti panchan. Jiñʌch mi yʌq'ueñob tsiji' bʌ i cuxtyʌlel jini año' bʌ ti mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Che' jini, ti' subeyob Jesús: C Yum, bej aq'ueñon lojon jini uch'el che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús ti' subeyob: Joñon jini uch'el mu' bʌ yʌq'ueñetla la' cuxtyʌlel mach'ʌ yujil jilel. Jini mu' bʌ i yochel tic cha'an ma'ix ba' bʌ ora mi quejel i yubin wi'ñal yubil. Jini mu' bʌ ch'ujbiñon cha'an melel c t'an ma'ix ba' bʌ ora mi quejel i yubin tyʌquin ti' yubil. ");
INSERT INTO ctu76_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero che' bajche' tic subeyetla mach'an mi la' ch'ujbiñon aunque ti la' wilʌyon. ");
INSERT INTO ctu76_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ti pejtyelel mu' bʌ i yʌq'ueñon c Tyat mi yochel tic cha'an. Jini mu' bʌ i yochel tic cha'an ma' mic cha' choc sujtyel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Como ma' ti jubiyon tyʌlel ti panchan cha'an mic cha'len chʌ bʌ bajñel com. Pero ti tyʌliyon cha'an c cha'len chʌ bʌ yom jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jini yom bʌ c Tyat ti panchan tsa' bʌ i chocoyon tyʌlel jiñʌch cha'an ma' mic sʌt mi junticlec jini tsa' bʌ i yʌq'ueyon. Pero yom cha'an mic tyechob loq'uel ba'an sajtyemo' bʌ che' mic cha' tyʌlel ti cojix bʌ q'uin. ");
INSERT INTO ctu76_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Jini yom bʌ tsa' bʌ i chocoyon tyʌlel jiñʌch cha'an ti pejtyelel mu' bʌ i ña'tyan cha'an i Yalobilon Dios, mu' bʌ i ch'ujbin cha'an melel c t'an mi yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. Dios yom cha'an mic cha' tyechisan loq'uel ba'an sajtyemo' bʌ che' mic cha' tyʌlel ti cojix bʌ q'uin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jin cha'an jini israelob año' bʌ ye'tyel ti queji i tyajob ti mach'ʌ wen bʌ t'an Jesús cha'an ti caj ti yʌlʌ: Che' joñon uch'elʌlon tsa' bʌ jubi tyʌlel ti panchan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ti yʌlʌyob: ¿Mach'a jinic jini Jesús i yalobil José? Mi laj cʌmben i tyat, i ña'. ¿Bajche'qui isujm che' mi yʌl i bʌ ti jubi tyʌlel ti panchan? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Che' jini, Jesús ti' subeyob: Cʌyʌ la' tyajon ti mach'ʌ wen bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma' majch ch'ujbi i yochel tic cha'an mi ma' mi ñaxan nijcʌbentyel i pusic'al cha'an tic Tyat tsa' bʌ i chocoyon tyʌlel. Joñon mi quejel c tyech loq'uel ba'an sajtyemo' bʌ ti cojix bʌ q'uin. ");
INSERT INTO ctu76_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ti jun tyac tsa' bʌ i ts'ijbuyob jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix mi yʌle': Mi quejel i lu' cʌntisʌntyel ti Dios, che'ob. Ti pejtyelel mu' bʌ i ñʌch'tyʌben i t'an c Tyat mu' bʌ i cʌntisʌntyel tic Tyat mi quejel i yochel tic cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma' majch ti yilʌ c Tyat. Joñon jach tsa' bʌ quilʌ como yʌ'ʌch tyʌlemon ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Melel mic subeñetla: Jini mu' bʌ i ch'ujbiñon anix i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Joñon uch'elʌlon mu' bʌ cʌq'ueñob i cuxtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aunque la' yumob ti ñoj oniyix ti' c'uxuyob jini uch'el tyʌlem bʌ ti panchan maná bʌ i c'aba' ya' ti tyʌquin bʌ joch lum pero ti pejtyelel ti sajtiyob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero jini uch'el tsa' bʌ jubi tyʌlel ti panchan chʌncol bʌ cʌl, jini mu' i c'ux jini uch'el ma'ix mi quejel i sajtyelob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Joñoñʌch jini cuxul bʌ uch'el tsa' bʌ jubi tyʌlel ti panchan. Jini mu' bʌ i c'ux ili uch'el mi quejel i yajñel ti bele' ora. Jini uch'el mu' bʌ cʌq'ueñob jiñʌch c bʌc'tyal. Mi cʌc' c bʌc'tyal cha'an bele' cuxul mi yajñel jini año' bʌ ti mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jini israelob año' bʌ ye'tyel ti queji i tyajob ti' t'an. Ti yʌlʌyob: ¿Bajche'qui ch'ujbi i yʌq'ueñonla laj c'ux i bʌc'tyal? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jin cha'an Jesús ti' subeyob: Melel mic subeñetla mi ma' mi la' c'ux c bʌc'tyal Joñon i Pi'ʌlon bʌ Quixtyañujob, mi ma' mi la' jap c ch'ich'el ma'ix la' cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jini mu' bʌ i c'ux c bʌc'tyal mu' bʌ i jap c ch'ich'el anix i cuxtyʌlel mach'ʌ yujil jilel. Joñon mic tyechisan loq'uel ba'an sajtyemo' bʌ ti jini cojix bʌ q'uin che' mic cha' tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Como jini c bʌc'tyal mi' lajmisan wi'ñal. Jinic ch'ich'el mi' lajmisan tyʌquin ti' yubil. ");
INSERT INTO ctu76_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jini mu' bʌ i c'ux c bʌc'tyal, mu' bʌ i jap c ch'ich'el mi yajñel quic'ot. Joñon mi cajñel quic'ot je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","An i cuxtyʌlel c Tyat tsa' bʌ i chocoyon tyʌlel. Cuxul mi cajñel cha'an tic Tyat. Chʌ'ʌch je'el, jini mu' bʌ i c'ux c bʌc'tyal cuxul mi yajñel cha'an ti joñon. ");
INSERT INTO ctu76_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jini mu' bʌ i c'ux chʌncol bʌ cʌl tsa' bʌ jubi tyʌlel ti panchan mach lajal yic'ot tsa' bʌ i c'uxuyob la' yumob ti ñoj oniyix maná bʌ i c'aba' pero ti lu' sajtiyob. Jini mu' bʌ i c'ux mu' bʌ cʌl, bej cuxul mi yajñel ti bele' ora. Joñoñʌch jini uch'el. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ti' cʌntisʌyob ili tyac ya' ba' much'quibilob ti templo i cha'an israelob ya' ti lum Capernaum bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Che' ñac ti yubiyob jini cʌntisa cabʌl tsa' bʌ tsʌcleyob Jesús ti yʌlʌyob: Leco iliyi cʌntisa. ¿Majchqui yom i bej ñʌch'tyan? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yujil isujm Jesús cha'an chʌncolob ti t'an ti caj jini tsa' bʌ i yʌlʌ. Ti' c'ajtibeyob: ¿Tyoj bʌc'ñʌjelet ba la cha'an ti caj ili c t'an? ");
INSERT INTO ctu76_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Chuqui mi quejel la' wʌl muq'uic la' wilan mic letsel majlel ti panchan Joñon i Pi'ʌlon bʌ Quixtyañujob ba' añon ti ñaxan? ");
INSERT INTO ctu76_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jini Ch'ujul bʌ c Ch'ujlel mi yʌq'ueñob i cuxtyʌlel mach'ʌ yujil jilel. Che' i bajñel c bʌc'tyal jach ma'ix mi yʌq'ueñob i cuxtyʌlel. Jini t'an tsa' bʌ c subeyetla i cha'añʌch Ch'ujul bʌ c Ch'ujlel. Jini t'an mi yʌq'ueñob i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero an cha'tiquil uxtiquil mach'ʌ ba'an mi' ch'ujbin cha'an ch'ujbi cʌq'ueñetla la' cuxtyʌlel, che'en. Como Jesús yujil isujm majchqui jini mach'ʌ ba'an ti' ch'ujbi. Yujil isujm majchqui jini mu' bʌ quejel i yʌc' ti' c'ʌb i contra. ");
INSERT INTO ctu76_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesús ti yʌlʌ: Jin cha'an tic subeyetla ma' majch ch'ujbi i yochel tic cha'an mi ma' mi ñijcʌbentyel i pusic'al tic Tyat ti panchan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti jim bʌ ora cabʌl tsa' bʌ i tsʌcleyob Jesús ti' cʌyʌyob. Mach'an ti' bej tsʌcleyob ti xʌmbal. ");
INSERT INTO ctu76_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Che' jini, Jesús ti' c'ajtibe jini doce ajcʌnt'añob i cha'an: ¿La' wom ba la' cʌyon je'el? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pero Simón Pedro ti' jac'ʌ: C Yum, ¿majchqui ch'ujbi lojon c tsʌclen? Jatyet a bajñel ma' subeñon lojon t'an cha'an mi lojon c tyaje' j cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ti lojon c ch'ujbi cha'an ch'ujbi a wʌq'ueñon lojon j cuxtyʌlel. Cujil lojon isujm jatyet jini yajcʌbilet bʌ i Yalobil jini cuxul bʌ Dios, che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús ti' jac'ʌ: ¿Mach'a doce tic yajcʌyetla? Pero juntiquil i cha'an xiba. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Che' ñac ti yʌlʌ Jesús che' bajche' jini, ti' tyaja ti t'an Judas Iscariote, i yalobil bʌ Simón. Como jini Judas mi quejel i yʌc' Jesús ti' c'ʌb i contra aunque i pi'ʌl jini yambʌ once ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ti wi'il Jesús ti ajni ya' ti pañimil Galilea bʌ i c'aba'. Mach yom i bej cha'len xʌmbal ya' ti pañimil Judea. Come an i pi'ʌlob israelob año' bʌ ye'tyel yom bʌ i tsʌnsañob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lʌc'ʌlix i yorojlel q'uin i cha'an israelob che' mi' melob lejchi' pat tyac cha'an i c'ajtisañob bajche' ti ajniyob ti tyʌquin bʌ joch lum che' ñac ti loq'uiyob tyʌlel ti Egipto ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","I yijts'iñob Jesús ti' sube: Cucu ti q'uiñejel ya' ti pañimil Judea cha'an jini mu' bʌ i tsʌcleñetyob ya' bʌ añob ya'i mi' q'uelob je'el chʌ bʌ ma' cha'len. Mach yom a cʌytyʌl wʌ'wʌ'i. ");
INSERT INTO ctu76_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mi an majch yom i yʌc' i bʌ ti cʌjñel mach chʌ'ic jach mi' mucu ñiq'ui pʌs ñuc tyac bʌ i p'ʌtyʌlel. Che' mi chʌncolʌch a pʌs ñuc tyac bʌ a p'ʌtyʌlel yom a pʌs ti' tyojlel cabʌl quixtyañu. Che' ti yʌlʌ i yijts'iñob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chʌ'ʌch ti yʌlʌyob como mi jinic i yijts'iñob ti' ch'ujbiyob cha'an yajcʌbil i cha'an Dios Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Che' jini, Jesús ti' subeyob: Max tyo c'ot i yorojlel cha'an mic majlel ya'i. Pero cha'an bʌ jatyetla bajche'ical ora lu' weñʌch cha'an mi la' majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Jini año' bʌ ti mulawil mach'an mi' ts'a'q'ueletla. Pero joñon bʌ yi mi' ts'a'q'ueloñob como mic tsictisan cha'an mu' bʌ i cha'leñob mulilʌch. ");
INSERT INTO ctu76_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cucuxla ti q'uin. Max tyo ba'an mi quejel c majlel. Como max tyo ts'ʌctyay i yorojlel c majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Che' ñac ti ujti i suben i yijts'iñob, Jesús tsa' tyo cʌyle ti Galilea. ");
INSERT INTO ctu76_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pero che' ñac tsa'ix ujti i majlel i yijts'iñob Jesús, ti majli Jesús je'el ti q'uiñejel. Pero che' jach ti mucu majli. Ma' ti' pʌsʌ i bʌ ti' tyojlel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jini israelob año' bʌ i ye'tyel ti' sajcʌyob Jesús ya' ti q'uiñejel. Ti yʌlʌyob: ¿Baqui an jini winic wale iliyi? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Cabʌl ya' bʌ añob ti q'uiñejel ti' tyajayob ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero ma' majch ti yʌlʌ ti c'am bʌ t'an como ti' bʌc'ñʌ israelob año' bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","I xiñilix q'uiñejel cha'an lejchi' pat che' ñac ti ochi Jesús ti templo. Como c'ʌlʌ ocho q'uin ti' meleyob q'uiñejel ti jajabil. Ti queji ti cʌntisa Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tyoj bʌc'ñʌjelob ti yubi jini israelob. Ti yʌlʌyob: ¿Bajche'qui isujm che' cabʌl chʌ bʌ yes yujil ili winic che' ma'ix ti' chajpʌ i bʌ cha'an mi yochel ti ajcʌntisa ti Ts'ijbubil bʌ i T'an Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús ti' jac'ʌ: J cʌntisa mach c bajñel ña'tyʌbal. I cha'añʌch jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mi an majch yom i cha'liben yom bʌ Dios, mi quejel i ña'tyan mi tyʌlem ti Dios jini j cʌntisa mu' bʌ cʌle' o mic bajñel ña'tyʌbal jach. ");
INSERT INTO ctu76_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jini mu' bʌ i bajñel sub i t'an yom jach i sujbel ti ñuc ti quixtyañujob. Pero jini yom bʌ i yʌc' ti tsictiyel i ñuclel Dios tsa' bʌ i choco tyʌlel mi' sube' melel bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Mach'a ba an ti yʌq'uetla mandar Moisés pero mi junticleticla mi la' jac'ben i mandar? ¿Chucoch la' wom la' tsʌnsañon? Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Cha'an ti caj che' ti yʌlʌ Jesús jini quixtyañujob ti' jac'ʌ: An xiba a wic'ot. ¿Majchqui yom i tsʌnsañet? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús ti' subeyob: Cha'an ti caj junchajb tsa' bʌ c cha'le ti q'uiñelel c'aj oj, ti la' pejtyel tyoj bʌc'ñʌjeletla ti la' wilʌ. Ti mich'ʌyetla. ");
INSERT INTO ctu76_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero Moisés ti' xiq'uiyetla jini i tyʌlel bʌ mi la' cha'len tsep pʌchʌlel bʌ i c'aba'. (Pero mach jinic Moisés ti' tyechbeyetla, jiñʌch la' yumob tyo ti ñoj oniyix ti tyechbeyetla.) Jin cha'an mi la' poj aq'uen tsep pʌchʌlel ch'oc alʌl bʌ alob aunque ti yorojlel c'aj oj. ");
INSERT INTO ctu76_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Cha'an la' ts'ʌctisan i mandar Moisés weñʌch mi la' poj aq'uen tsep pʌchʌlel ch'oc alʌl bʌ alob aunque ti yorojlel c'aj oj. ¿Pero chucoch mi la' mich'q'uelon cha'an ti caj tic lajmisʌ juntiquil winic che' ti yorojlel c'aj oj? ");
INSERT INTO ctu76_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mach yom la' wa' alʌ mi an i mul quixtyañu mi max tyo tyictyay mi an i mul. Yom la' wen pensalin bajche' yom cha'an la' cha'len tyoj bʌ melojel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Che' jini, an ya' bʌ chumulob ti Jerusalén ti queji i c'ajtin: ¿Mach ba jinic ili winic mu' bʌ i sajcañob cha'an i tsʌnsañob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Q'uele awilan ya' chʌncol ti cʌntisa ti cantyʌlel lac wut. Pero mach'an majch mi' niq'ui suben. ¿Jin cu jini año' bʌ i ye'tyel mu' ba i yoque ch'ujbin mi jiñʌch Cristo yajcʌbil bʌ i cha'an Dios jini winic? ");
INSERT INTO ctu76_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero joñonla mi lac ña'tyan baqui tyʌlem ili winic. Pero che' ya' bʌ mi tyʌlel jini yajcʌbil bʌ i cha'an Dios ma' majch yujil isujm baqui tyʌlem. Che' ti' lolon tyajayob ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Che' ñac ti yubi Jesús ili t'an che' mu' ti cʌntisa ti templo ti yʌlʌ ti c'am bʌ t'an: Mi la' cʌñon. La' wujil baqui tyʌlemon mi la' lolon ña'tyan. Ma' ti tyʌliyon cha'an jach bajñel com tyʌlel. Pero ti tyʌliyon cha'an ti' chocoyon tyʌlel juntiquil melelʌch bʌ i t'an. Mach la' cʌñʌ jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Joñon mij cʌñe' como tyʌlemon ya' ba'an. Jini ti' chocoyon tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Che' jini, yom i chucob Jesús cha'an i cʌchob. Pero mach'an ti' chucuyob como max tyo ts'ʌctyay yorojlel cha'an mi quejel i chucob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero cabʌl ti' ch'ujbiyob Jesús. Ti yʌlʌyob: Che' mi tyʌlel jini yajcʌbil bʌ i cha'an Dios, ¿mu' ba i pʌs más ñuc bʌ i p'ʌtyʌlel bajche' ili winic? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jini fariseojob ti yubiyob chʌ bʌ ti yʌlʌ quixtyañujob cha'an Jesús. Che' jini, jini fariseojob yic'ot ñuc bʌ curajob i cha'an israelob ti' chocoyob majlel policía i cha'an i templojob cha'an i chucob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Che' jini, ti yʌlʌ Jesús: Ma'ix jal wʌ'añon quic'otyetla. Ti wi'il mi quejel c cha' sujtyel ba'an tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jatyetla mi quejel la' sajcañon pero mach'anix mi quejel la' tyajon. Como mach ch'ujbi la' majlel ba' mi quejel c majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Che' jini, jini israelob ti queji i c'ajtibeñob i bʌ: ¿Baqui mi quejel i majlel ba' mach ch'ujbi lac tyaje'? ¿Mu' ba ti quejel i majlel ba'an israelob ya' bʌ puculob ba'an jini griegojob cha'an i cʌntisañob jini mach bʌ israelobic? Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Chuqui i sujmlel che' mi yʌl: Mi quejel la' sajcañon pero mach'an mi quejel la' tyajon como mach ch'ujbi la' majlel ba' mi quejel cajñel? che'en. Che' ti' cha' tyajayob ti t'an jini tsa' bʌ ujti i yʌle' Jesús jini israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ti yujtibal q'uiñejel ti q'uejli ti más ñuc. Ti jim bʌ q'uin ti wa'le Jesús. Ti yʌlʌ ti c'am bʌ t'an: Mi an majch an i tyʌquin ti' la' tyʌlic ba'añon. La' i jape' ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ti Ts'ijbubil bʌ i T'an Dios mi yʌle': Jini mu' bʌ i ch'ujbiñon che' bajche' mi quejel i loq'uel cuxul bʌ ja' ti' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cha'an ti yʌlʌ cuxul bʌ ja' chʌ'ʌch ti' tsictisʌ Jesús cha'an mi quejel i yʌq'uentyel Ch'ujul bʌ i Ch'ujlel jini mu' bʌ i ch'ujbin cha'an Ajcotyaya i cha'an Jesús. Como max tyo tyʌlemic Ch'ujul bʌ i Ch'ujlel Dios ti jim bʌ ora como max tyo ti tsictiyi i ñuclel Jesús como max tyo sajt, max tyo lets majlel ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Che' ñac ti yubibeyob i t'an Jesús cha'tiquil uxtiquil quixtyañu ya' bʌ an yic'otyob ti yʌlʌyob: Melel ili winic jiñʌch jini ñuc bʌ mu' bʌ i tyʌlel mu' bʌ i xiq'ue' i yʌle' Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yaño' bʌ ti yʌlʌyob: Jiñʌch Cristo, yajcʌbil bʌ i cha'an Dios, che'ob. Pero yaño' bʌ ti yʌlʌyob: ¿Loq'uem ba ti Galilea mi tyʌlel jini yajcʌbil bʌ i cha'an Dios? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Como Ts'ijbubil bʌ i T'an Dios mi yʌl jini Cristo an cha'an loq'uem ti i jiñʌjlel David jini ñuc bʌ yumʌl ti ñoj oniyix. Añʌch cha'an ya' ch'oyol ti lum Belén bʌ i c'aba' mismo jin jach bʌ lum ba' ch'oyol David mi quejel i tyʌlel jini yajcʌbil bʌ i cha'an Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Che' jini, cha'chajp ti' cha'leyob t'an quixtyañujob cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","An yom bʌ i cʌchob Jesús pero mach'an majch ti' chucu. ");
INSERT INTO ctu76_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jini policíajob cha'an i templo israelob ti cha' c'oti ya' ba'an fariseojob yic'ot ba'an ñuc bʌ curajob. Ti' c'ajtibentiyob: ¿Chucoch ma' ti la' pʌyʌ tyʌlel Jesús? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jini policía ti' jac'ʌyob: Mach'an ba' bʌ ora an majch ti' cha'le t'an bajche' muc' ti t'an ili winic, che' ti' jac'ʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Che' jini, jini fariseojob ti' subeyob: ¿Tsa' ba la' wʌc'ʌ la' bʌ ti lotintyel je'el? ");
INSERT INTO ctu76_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Am ba junticlec am bʌ i ye'tyel lac cha'an o mi junticlec fariseojob tsa' bʌ i ch'ujbi? ");
INSERT INTO ctu76_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero jini quixtyañujob mach'ʌ ba'an mi' cʌñob mandar lac cha'an mi' ch'ujbiñob. Mu' tyo quejel i xot'e' i mul, che' ti lolon alʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jini Nicodemo tsajni bʌ i pejcan Jesús ti ac'bʌlel jiñʌch juntiquil fariseo bʌ je'el ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Jini mandar mi yʌl: Mach ch'ujbi lac wʌ sub mi an i mul quixtyañu che' max tyo ubibil i t'an jini winic, che' max tyo ña'tyʌbil chʌ bʌ ti' cha'le. Che' ti' subeyob bajche' ts'ijbubil ti mandar Moisés. Che' ti yʌlʌ Nicodemo. ");
INSERT INTO ctu76_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Che' jini, ti' jac'ʌyob: ¿Ch'oyolet ba ti Galilea je'el? Wen q'uele Ts'ijbubil bʌ i T'an Dios. Mi quejel a ña'tyan cha'an mi junticlec ch'oyol bʌ ti Galilea tsa' bʌ i xiq'ui i yʌle' Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Che' jini, ti jujuntiquil ti sujti ti i yotyot. ");
INSERT INTO ctu76_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Jesús ti majli ti wits Olivajol bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ti yijc'ʌlel ti sʌc'an ti cha' majli ti templo. Ti pejtyelel quixtyañu ti' lʌc'ʌyob. Ti buchle Jesús. Ti queji i cʌntisañob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Che' jini, ajcʌntisajob cha'an mandar i cha'an israelob yic'ot fariseojob ti' pʌyʌ tyʌlel ba'an Jesús juntiquil x'ixic tsa' bʌ i tyajayob chʌncol i cha'len i tsuculel yic'ot winic. Ti' pʌyʌ tyʌlel ti xinil ya' ba' añob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ti' subeyob Jesús: Maestro, ti tyajle ili x'ixic chʌncox i cha'len i tsuculel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ti mandar tsa' bʌ i yʌc'onla Moisés mi' subeñonla lac tsʌnsan ti tyun mu' bʌ i cha'len i tsuculel. Jixcu jatyet, ¿chuqui ma' wʌl? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Che' ti yʌlʌyob cha'an jach yom i yilan bajche' yʌlʌ mi quejel i jac' Jesús cha'an yom i tyajben i mul. Pero Jesús ti wutsle ti lum. Ti queji i ts'ijbun lum ti' yal c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero che' ti queji i bej c'ajtibeñob Jesús, che' jini, ti wa'le. Ti' subeyob: Majchical jach mach'ʌ ba'an i mul la' i ñaxan jul ti tyun ili x'ixic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ti cha' wutsle Jesús. Ti' bej ts'ijbu lum. ");
INSERT INTO ctu76_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pero che' ñac ti yubiyob i t'an Jesús ti queji i bajñel ña'tyañob i mul. Belecña ti queji i loq'uelob majlel. Ñaxan ti loq'ui más ñoxobix bʌ. Che' ñac ti ujti i lu' loq'uelob ti bajñel cʌyle Jesús yic'ot jini x'ixic am bʌ i mul. ");
INSERT INTO ctu76_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Che' jini, Jesús ti wa'le. Mach'anix majch ya'an ti yilʌ. Jini jachix ya'an jini x'ixic. Jin cha'an ti' sube: X'ixic, ¿baqui an tsa' bʌ i subuyob a mul? ¿Mach'a ba'an ti' juluyetyob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jini x'ixic ti' jac'ʌ: C Yum, mach'anix. Mi junticlec ti' juluyon, che'en. Che' jini, Jesús ti queji i suben: Chʌ'ʌch joñon je'el ma'ix mi cʌq'ueñet a xot' a mul. Cucux. Mach yom a cha' cha'len mulil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ti' cha' sube quixtyañujob: Joñon i sʌclelon mulawil. Jini mu' bʌ i tsʌcleñon anix i sʌclel mu' bʌ i yʌq'uen tsiji' bʌ i cuxtyʌlel. Ma' ba' bʌ ora mi' cha' cha'len xʌmbal ti ic'jowan bʌ pañimil yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Che' jini, fariseojob ti' sube Jesús: Jatyet bʌ yi, chʌncol jach a bajñel sub a bʌ ti chocol tyʌlel ti Dios. Ma'ix i c'ʌjnibal jini, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús ti' jac'ʌ: Mu' bʌ cʌl añʌch i c'ʌjnibal aunque mic bajñel sub c bʌ como joñon cujil isujm ba' ch'oyolon. Cujil baqui mi quejel c cha' majlel. Pero jatyetla mach la' wujil isujm baqui tyʌlemon mi jinic baqui mi quejel c majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Jatyetla mi la' cha'len melojel che' bajche' mi' cha'len pejtyel quixtyañu che' bajche' yilal mi la' pensalin. Pero joñon ma' majch mic mele' wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero muq'uic c cha'len melojel, tyojʌch bʌ melojel mic cha'len como mach c bajñel mic cha'len melojel. Pero c Tyat ti panchan tsa' bʌ i chocoyon tyʌlel mi' motin cha'len melojel quic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ts'ijbubil ti mandar tyac la' cha'an mi yʌl mi an cha'tiquil tsa' bʌ i yilʌ, yom ch'ujbintic i t'an, che' ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Chʌ'ʌch je'el, mic cha'len t'an cha'an c sub c bʌ majchonqui. C Tyat mi' sub cha'an ti' chocoyon tyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ti' c'ajtibeyob che' jini: ¿Baqui an a Tyat? che'ob. Jesús ti' jac'ʌ: Ma' mi la' cʌn majchonqui mi jinic majchqui jini c Tyat. Mi ti la' cʌñʌyon mi la' cʌn c Tyat je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús ti yʌlʌ tyac ili che' ñac ti' cha'le cʌntisa ya' ti colem templo i cha'an israelob ya' ba'an i yajnib tyac ba' mi yotsañob tyaq'uin. Pero mach'an majch ti' chucu como max tyo ts'ʌctyay i yorojlel i wocol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ti' cha' subeyob: Mi quejel c majlel. Mi quej la' sajcañon pero mi quej la' sajtyel ti la' mul. Como ya' ba' mi quej c majlel mach ch'ujbi majliquetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Che' jini, an israelob tsa' bʌ i subeyob i bʌ: ¿Mu' ba ti quejel i tsʌnsan i bʌ? ¿Jin ba cha'an mi yʌl mach ch'ujbi lac majlel ba' mi quejel i majlel? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Che' jini, Jesús ti' subeyob: La' lumalʌch ili mulawil. Joñon an c lumal ti panchan. La' wajnib ili mulawil pero joñon mach cajnibic ili mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jin cha'an tic subeyetla mi quejel la' sajtyel che' añet tyo la ti la' mul. Como mach'an mi la' ch'ujbiñon che' mic subeñetla majchonqui. Jin cha'an mi quejel la' sajtyel che' añet tyo la ti la' mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Che' jini, jini israelob ti' c'ajtibeyob: ¿Majchetqui che' jini? che'ob. Jesús ti' jac'ʌ: C'ʌlʌ ti tyejchibal tic subeyetla majchonqui, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","An tyo cabʌl chʌ bʌ com cʌl cha'añetla cha'an mic tsictisan mach'ʌ wen bʌ la' cha'libal. Pero jini tsa' bʌ i chocoyon tyʌlel melelʌch i t'an. Jini mu' bʌ c subeñetla ti cubi ti yʌlʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero mach'an ti' ch'ʌmbeyob isujm tsa' bʌ i subeyob cha'an i Tyat ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jin cha'an Jesús ti' subeyob: Che' mi quejel la' letsañon ti cruz Joñon i Pi'ʌlon bʌ Quixtyañujob mi quejel la' cʌñon cha'an joñoñʌch jini yajcʌbil bʌ i cha'an Dios. Mi quejel la' ch'ʌm'en isujm mach'anix mic cha'len chʌ bʌ yes bajñel com. Jin jach mic sube' tsa' bʌ i cʌntisʌyon c Tyat ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Como tsa' bʌ i chocoyon tyʌlel wʌ'an quic'ot. Mach'an ti' bajñel cʌyʌyon como mic bele' cha'len mu' bʌ i mulan c Tyat ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cabʌlob ti' ch'ujbi cha'an jiñʌch yajcʌbil bʌ i cha'an Dios Jesús che' ñac ti' subu jini t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Che' jini, Jesús ti' sube jini israelob tsa' bʌ i ch'ujbiyob: Mi xuc'ul mi la' bej ch'ujbin majlel tsa' bʌ c subeyetla mi quejel la' wajñel ti yoque ajcʌnt'an c cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Mi quejel la' cʌñe' che' melel jini t'an. Jini melel bʌ t'an mi quejel i yʌq'uetla ti cojlel, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Che' jini, ti' jac'ʌyob: I jiñʌjlelon lojon Abraham. Mach'an ba' bʌ ora ti ajniyon lojon ti lolon ajtroñel jach. ¿Chucoch ma' wʌl mi quejel cʌjq'uel lojon ti cojlel? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús ti' subeyob: Melel mic subeñetla, ti pejtyelel quixtyañu mu' bʌ i cha'len mulil chuculob ti mulil che' bajche' lolon ajtroñelob jach i cha'an mulil. ");
INSERT INTO ctu76_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mach ti bele' ora mi yajñel ti yotyot i yum jini lolon ajtroñel jach bʌ. Pero jini yalobilʌch bʌ mi yajñel ti' yalobil i tyat ti bele' ora, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jin cha'an mi ti cojliyetla ti' Yalobil bʌ Dios yoque cojlemetla, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cujil isujm i jiñʌjleletla Abraham pero la' wom la' tsʌnsañon como mach'an mi la' ch'ujbin mu' bʌ c subeñetla. ");
INSERT INTO ctu76_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Joñon mic subeñetla tsa' bʌ i pʌs'on c Tyat. Jatyetla mi la' cha'len tsa' bʌ i subetla la' tyat, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jini israelob ti' jac'ʌyob: Lojon c tyat Abraham, che'ob. Pero Jesús ti' subeyob: Mi yoque melelʌch i jiñʌjleletyʌchla Abraham mi la' cha'len che' bajche' ti' cha'le Abraham. ");
INSERT INTO ctu76_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero cha'an tic subeyetla melel bʌ t'an tsa' bʌ i cʌntisʌyon Dios, la' wom la' tsʌnsañon. Mach che'ic ti' cha'le Abraham. ");
INSERT INTO ctu76_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mi' la' cha'len lajal bʌ bajche' mi' cha'len la' tyat. Che' ti yʌlʌ Jesús. Che' jini, ti' jac'ʌyob: Mach i yalobilon lojon quixtyañujob cha'an jach ti i tsuculel. An juntiquil jach lojon c tyat, jiñʌch Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús ti' subeyob: La' tyatic Dios mi la' p'untyañon. Como loq'uemon tyʌlel ya' ba'an Dios. Mach'an ti tyʌliyon cha'an jach bajñel com c tyʌlel pero Dios ti' chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chuqui och mach ch'ujbi la' ch'ʌm'en isujm mu' bʌ cʌle'? Cha'an jach mach la' wom la' wubin c t'an, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","La' tyat jiñʌch xiba. I cha'añetla xiba. La' wom la' cha'len jini yom bʌ xiba. Ajtsʌnsajʌch jini xiba c'ʌlʌ ti tyejchibal. Mach'an ba' yʌlʌ melel bʌ t'an. Ajlotiyajʌch. Mach'an melel bʌ ti' pusic'al. Jiñʌch mu' bʌ i tyeche' pejtyelel lot bʌ t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero cha'an chʌncol c subeñetla melel bʌ t'an mach'an mi la' ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Am ba juntiquiletla ch'ujbi bʌ la' sub mi an c mul? Mic subeñetla melel bʌ t'an. ¿Chucoch mach'an mi la' ch'ujbiñon? ");
INSERT INTO ctu76_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jini i cha'año' bʌ Dios mi' mulan i yubiben i t'an Dios. Pero mach i cha'añetla Dios. Jin cha'an mach la' wom la' ubin i t'an. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Che' jini, israelob ti' subeyob Jesús: An chʌ bʌ och ti lojon cʌlʌ ch'oyolet ti pañimil Samaria bʌ i c'aba' como an xiba ti a pusic'al, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús ti' jac'ʌ: Mach'an xiba tic pusic'al. Jini mu' bʌ c cha'len mi' tsictisan i ñuclel c Tyat. Jatyetla mach'an mi la' q'uelon ti ñuc. ");
INSERT INTO ctu76_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mach'an tic sajcʌ c bajñel ñuclel pero an juntiquil yom bʌ cha'an q'uejlicon ti ñuc. Jini mi quej i mele' jini mu' bʌ i ts'a'leñon. ");
INSERT INTO ctu76_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Melel mic subeñetla jini mu' bʌ i jac' mu' bʌ cʌl, mach'an mi quejel i sajtyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Che jini, israelob tsa' bʌ i contrajiyob Jesús, ti' jac'ʌyob: Wale cujil lojon isujm an xiba ti a pusic'al. Abraham yic'ot pejtyelel tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix ti lu' sajtiyob. Pero jatyet ma' wʌl: Jini mu' bʌ i jac' mu' bʌ cʌl mach'an mi quejel i sajtyel, che'et ti a wʌlʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Más ñuquet ba bajche' lac yum Abraham ma' lolon al? Ti sajti yic'ot je'el jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix. ¿Majchetqui ma' wʌl? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús ti' jac'ʌ: Mi c bajñel jach mic sub c ñuclel ma'ix i c'ʌjnibal. Pero jini mu' bʌ i tsictisʌbeñon c ñuclel jiñʌch c Tyat ti panchan. Jiñʌch mu' bʌ la' sub ti la' Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pero mach'an mi la' cʌñe' c Tyat. Muq'uic cʌl mach j cʌñʌ, lajal ajlotyon bajche'etla. Pero melelʌch joñon mij cʌñe' c Tyat. Mic jac'ben i t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","C'ajacña i yoj Abraham la' yum ti ñoj oniyix cha'an mi quejel i yilañon. Yujil isujm Abraham mi quejel c tyʌlel. Che'ʌch bajche' tsa'ix i yilʌyon. C'ajacña i yoj ti yubi. ");
INSERT INTO ctu76_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Che' jini, israelob ti' subeyob Jesús: Max tyo ba'an cincuenta a jabilel. ¿Tsa'ix ba a wilʌ Abraham, ma' wʌl? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús ti' jac'ʌ: Melel mic subeñetla che' ñac max tyo i ch'ocʌ Abraham, añoñʌch, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Che' jini, ti' lotyoyob tyun cha'an i julob Jesús. Pero ti' mujcu i bʌ. Ti loq'ui majlel ti templo ti xiñilob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Che' chʌncol i ñumel majlel Jesús ti yilʌ juntiquil winic muts'ul bʌ i wut c'ʌlʌ che' ñac ti ch'ocʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jini ajcʌnt'añob i cha'an Jesús ti' c'ajtibe: Maestro, ¿chucoch muts'ul i wut ti ch'ocʌ ili winic? ¿Cha'an ba ti i mul i tyat i ña' o cha'an ba ti i bajñel i mul? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús ti' subeyob: Mach cha'anic ti caj i mul mi cha'anic ti caj i mul i tyat i ña'. Pero i tyʌlelʌch muts'ul i wut ti ch'ocʌ cha'an mi tsictiyel chʌ bʌ ch'ujbi i cha'len Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Che' q'uinil tyo muc' tyo c wersa cha'liben i toñel jini tsa' bʌ i chocoyon tyʌlel. Como tyal ac'bʌlel yubil che' ma'an majch ch'ujbi i cha'len toñel. ");
INSERT INTO ctu76_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Che' wʌ' tyo añon ti mulawil che' bajche' i sʌclelon cha'an jini año' bʌ ti mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Che' ti ujti i yʌle' jini t'an, Jesús ti' tyujbʌ lum. Ti' mele oc'ol yic'ot i tyujb. Ti yulbe ti' wut jini muts'ul bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jesús ti' sube: Cucu, poco a wut ti ja' Siloé bʌ i c'aba', che'en. Jini Siloé yom i yʌle' chocol bʌ majlel. Ti majli jini muts'ul bʌ i wut. Ti' poco i wut. Ti cha' sujti tyʌlel. Ch'ujbiyix i q'uele' pañimil. ");
INSERT INTO ctu76_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Che' jini, i pi'ʌlob lʌc'ʌl bʌ chumul yic'ot tsa' bʌ i yilʌyob che' ñac muts'ul tyo i wut ti yʌlʌyob: ¿Mach'a jinic tsa' bʌ i c'ajti tyaq'uin ba' buchul? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","An tsa' bʌ i yʌlʌyob: Jiñʌch jini, che'ob. Yaño' bʌ ti yʌlʌyob: Mach jiniqui pero chʌ'ʌch yilal, che'ob. Pero jini winic i bajñel ti yʌlʌ: Joñoñʌch, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Che' jini, ti' c'ajtibeyob: ¿Bajche'qui isujm che' muq'uix a wilan pañimil wale iliyi? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jini winic ti' jac'ʌ: Jini winic Jesús bʌ i c'aba' ti' mele oc'ol. Ti yulu oc'ol tic wut. Che' jini, ti' subon: Cucu ya' ti ja' Siloé bʌ i c'aba'. Poco a wut, che' ti subon. Tsajniyon. Che' ujtyemix c poque' c wut ch'ujbix quilan pañimil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Che' jini, ti' c'ajtibeyob: ¿Baqui an jini winic wale iliyi? che'ob. Jini winic ti' jac'ʌ: Mach cujilic baqui an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Che' jini, ti' pʌyʌyob majlel jini tsa' bʌ jajmi i wut ti' tyojlel fariseojob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pero i q'uinilel c'aj oj che' ñac Jesús ti' mele oc'ol, che' ñac ti jajmi i wut jini muts'ul bʌ i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jin cha'an fariseojob ti' cha' c'ajtibeyob je'el bajche' ti c'oti i wut. Jini winic ti' subeyob: Ti' yulbon oc'ol tic wut. Tic poco c wut. Wale ch'ujbix j q'uele' pañimil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Che' jini, cha'tiquil uxtiquil fariseo ti yʌlʌyob: Mach'an chocol tyʌlel ti Dios jini winic tsa' bʌ i jambe i wut como ma' mi' q'uel ti ñuc i q'uinilel c'aj oj, che'ob. Pero yaño' bʌ ti yʌlʌyob: ¿Bajche'qui isujm che' ch'ujbi i pʌs ñuc tyac bʌ i p'ʌtyʌlel Jesús mi xmulil? che'ob. Cha'chajp ti' cha'leyob t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ti' cha' c'ajtibeyob jini tsa' bʌ jajmi i wut: Jixcu jatyet, ¿majchqui ma' wʌl jini winic tsa' bʌ jambeyet a wut? che'ob. Ti' jac'ʌ: Mi cʌl jiñʌch juntiquil tsa' bʌ i xiq'ui i yʌle' Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero jini israelob mach yom i ch'ujbin mi jiñʌch jini muts'ul bʌ i wut ti yambʌ ora chʌncol bʌ i q'uel pañimil wale iliyi jintyo ti' pʌyʌyob tyʌlel i tyat i ña' jini tsa' bʌ jambenti i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ti' c'ajtibeyob: ¿Jim ba la' walobil iliyi muts'ul bʌ i wut ti ch'ocʌ? ¿Bajche'qui ti queji i q'uele' pañimil, che' jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I tyat i ña' ti' jac'ʌyob: Cujil lojon isujm jiñʌch lojon calobil muts'ul bʌ i wut ti ch'ocʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero mach cujil lojon isujm bajche' ti queji i yilan pañimil. Mach cujil lojon isujm majchqui ti' jambe i wut. C'ajtibenla. Winiquix. Ch'ujbi i bajñel sub, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chʌ'ʌch ti' jac'ʌyob i tyat i ña' como añob i bʌq'uen. Como tsa'ix i lajayob i t'an israelob año' bʌ ye'tyel cha'an mi quejel i junyajlel choc loq'uel ti i templojob majchical jach mi quejel i sub mi jiñʌch yajcʌbil bʌ i cha'an Dios jini Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jin cha'an i tyat i ña' ti yʌlʌyob: C'ajtibenla. Winiquix, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Che' jini, israelob año' bʌ ye'tyel ti' cha' pʌyʌ jini tsa' bʌ jambenti i wut. Ti' subeyob: Subu ti melel bʌ a t'an como Dios mi' q'uelonla. Como cujil lojon isujm xmulilʌch jini Jesús, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Che' jini, ti' jac'ʌ tsa' bʌ jambenti i wut: Mach cujil isujm mi xmulil. Pero cujil isujm muts'ul c wut ti yambʌ ora. Wale iliyi mi quilan pañimil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ti' cha' c'ajtibeyob: ¿Chuqui ti' tyumbet? ¿Bajche'qui ti' cha'le cha'an ma' wilan pañimil? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ti' jac'ʌ jini winic: Tsa'ix c subeyetla. Mach'an ti la' ch'ujbi c t'an. ¿Chucoch la' wom mic cha' subeñetla? ¿La' wom ba la' tsʌclen je'el? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Che' jini, ti' wajleyob. Ti' subeyob jini tsa' bʌ jambenti i wut: Jatyet ma' tsʌclen jini winic pero joñon lojon mi lojon c tsʌclen Moisés. ");
INSERT INTO ctu76_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Lojon cujil isujm Dios ti' pejcʌ Moisés. Pero ili winic mach cujil lojon isujm baqui ch'oyol, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jini tsa' bʌ jambenti i wut ti' jac'ʌ: ¿Bajche'qui isujm jini? Mach'an mi la' ña'tyan baqui ch'oyol. Pero ti yʌq'ueyon j q'uele' pañimil. ");
INSERT INTO ctu76_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","La cujil isujm Dios mach'an mi' jac'ben i t'an xmulil. Jin jach mi jac'bentyel jini mu' bʌ i ch'ujutisan Dios mu' bʌ i mele' chʌ bʌ yom Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mach'an ba' bʌ ora ti ubinti mi ti jambenti i wut i tyʌlel bʌ muts'ul i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Machic ti tyʌli ti Dios jini winic mach ch'ujbi i pʌs ñuc tyac bʌ i p'ʌtyʌlel. Che' ti' yʌlʌ jini tsa' bʌ jambenti i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Che' jini, ti subenti: Jatyet an a mul ti ch'ocʌyet. ¿Mu' ba a cʌntisañon lojon je'el, ma' wʌl? che'ob. Ti' chocoyob loq'uel ti junyajlel ti i templo. ");
INSERT INTO ctu76_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús yujil isujm che' ti' chocoyob loq'uel ti' templojob jini tsa' bʌ jambe i wut. Jesús ti c'oti i tyaje'. Ti' sube: ¿Mu' ba a ch'ujbin i Yalobil Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jini winic ti' jac'ʌ: C Yum, subeñon majchqui cha'an mic ch'ujbin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús ti' jac'ʌ: Tsa'ix a wilʌ. Joñoñʌch i Yalobilon Dios mu' bʌ a pejcañon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Che' jini, jini tsa' bʌ jambenti i wut ti' ñocle ti yebal yoc Jesús. Ti' ch'ujutisʌ. Ti' sube: C Yum, mic ch'ujbiñet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ti wi'il Jesús ti yʌlʌ: Ti tyʌliyon ti mulawil cha'an mi tsictiyel i mul quixtyañujob cha'an mi jambentyel i wut jini muts'ulo' bʌ i wut. Cha'an jini mu' bʌ i q'uelob pañimil mi' ña'tyan, mi yajñel che' bajche' mutsulo' bʌ i wut, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Che' jini, cha'tiquil uxtiquil fariseo ya' bʌ añob yic'ot Jesús che' ñac ti yubiyob ili t'an ti' c'ajtibeyob: ¿Muts'ul ba lojon c wut je'el ma' wʌl? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús ti' jac'ʌ: Muts'ulic la' wut ma'ix la' mul. Pero cha'an mi la' lolon al mi la' wilan pañimil an tyo la' mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Melel mic subeñetla: Jini mach'ʌ ba'an mi yochel ti ti' i corral tiñʌme' pero mi che' jach mi mucu c'axel ochel ti pam ts'ajquil, ajxujch'ʌch yic'ot mu' bʌ i wersa chilben i cha'an bʌ yambʌ. Jini tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero jini mu' bʌ i yochel ti ti' jiñʌch ajcʌñʌtya tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jini ajcʌñʌtya ti' corral mi' jamben i ti' cha'an mi yochel jini ajcʌñʌtya tiñʌme'. Jini tiñʌme' mi' cʌmben i t'an ajcʌñʌtya tiñʌme'. Mi' pejcan tiñʌme'ob ti i c'aba' tyac. Mi' pʌye' loq'uel ti corral. ");
INSERT INTO ctu76_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Che' tsa'ix i pʌyʌ loq'uel tiñʌme' ti i corral ñaxan mi majlel ajcʌñʌtya tiñʌme'. Jini tiñʌme' mi' tsʌclen majlel como mi' cʌmben i t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero mach'an mi' tsʌclen majlel yambʌ winic mach'ʌ ba'an mi' cʌmben i t'an. Mi' puts'ejel majlel como mach i cʌñʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús ti' subeyob jini lajoñel pero mach'an ti' ch'ʌmbeyob isujm tsa' bʌ i subeyob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús ti' cha' subeyob: Melel mic subeñetla: Joñon i ti'on corral ba' mi yochel majlel tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Jini tsa' bʌ ñaxan tyʌliyob ajxujch'obʌch yic'ot mu' bʌ i wersa chilben i cha'an yambʌ. Pero jini tiñʌme'ob mach'an ti' tsʌcleyob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Joñon che' bajche' i ti'on corral. Jini mu' bʌ i yochel ba'añon mi quejel i cotyʌntyel. Jini mu' bʌ cotyʌntyel chʌ'ʌch bajche' juncojt tiñʌme' mu' bʌ i yochel mu' bʌ i loq'uel ti corral. Mi' tyaje' i buc'bal. ");
INSERT INTO ctu76_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Muc' jach i tyʌlel ajxujch' cha'an i xujch'in, cha'an i tsʌnsañob, cha'an i jisañob. Pero joñon ti tyʌliyon cha'an mi' tyajob i cuxtyʌlel cha'an ñoj weñʌch mi yajñel. ");
INSERT INTO ctu76_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Joñon wen bʌ ajcʌñʌtya tiñʌme'. Jini wen bʌ ajcʌñʌtya tiñʌme' mi yʌc' i bʌ ti sajtyel cha'an tiñʌme'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero jini mu' bʌ ti toñel ti cʌñʌtya tiñʌme' cha'an jach mi tyojtyʌl mi puts'ejel che' mi yilan simaron bʌ animal. Mi' cʌye' jini tiñʌme' como mach yoque ajcʌñʌtya tiñʌme'ic. Mach i cha'an jini tiñʌme'. Jini simaron bʌ animal mi' chuc jini tiñʌme'. Mi pam pujquel tiñʌme', che' jini. ");
INSERT INTO ctu76_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jini ajcʌñʌtya tiñʌme' mi puts'ijel como muc' jach ti toñel cha'an mi tyojtyʌl. Mach'an mi' p'untyan tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Joñon jini wen bʌ ajcʌñʌtya tiñʌme'. Chʌ'ʌch bajche' c Tyat ti panchan mi' cʌñon mij cʌñe' c Tyat. Chʌ'ʌch je'el mij cʌñe' c tiñʌme'. Mi' cʌñoñob je'el. Mi cʌc' c bʌ ti sajtyel cha'an jini tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Añʌch yambʌ tiñʌme' je'el max tyo bʌ ochem ti jini corral. Wersa mic pʌyob tyʌlel je'el. Mi quejel i jac'beñon c t'an. Mi quejel i yajñel ti junmujch' ba'an juntiquil jach ajcʌñʌtya tiñʌme'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jin cha'an c Tyat ti panchan mi' p'untyañon. Como mi cʌc' c bʌ ti sajtyel cha'an mic cha' tyejchel loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mach'an majch ch'ujbi i tsʌnsañon mi mach che'ic com. Pero mic bajñel ac' c bʌ ti sajtyel cha'an chʌ'ʌch bajñel com. Añʌch c bajñel p'ʌtyʌlel cha'an mi cʌc' c bʌ ti sajtyel. Añʌch c bajñel p'ʌtyʌlel cha'an mic cha' tyejchel loq'uel ba'an sajtyemo' bʌ. Chʌ'ʌch ti aq'uentiyon c cha'len tic Tyat ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Che' ñac ti yubiyob ili t'an tyac cha'chajp ti quejiyob ti t'an jini israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Cabʌl ti yʌlʌyob: ¿Chucoch mi la' chʌc ch'ujbin i t'an? An xiba ti' pusic'al. Mach'an mi' ña'tyan pañimil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero yaño' bʌ ti yʌlʌyob: Mach che'ic mi' cha'len t'an winic am bʌ xiba ti' pusic'al che' bajche' jini. ¿Ch'ujbi ba i jamben i wut muts'ul bʌ i wut am bʌ xiba ti' pusic'al? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ti' meleyob i c'ajtisʌntyel q'uiñejel templo mu' bʌ i melob ti jajabil ya' ti Jerusalén. I yorojlelix tsʌñal. ");
INSERT INTO ctu76_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ti' cha'le xʌmbal ya' ti templo ya' ti corredor Salomón bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jini israelob ti' joy mʌctyʌyob Jesús. Ti' subeyob: ¿Jayp'ej tyo ora ma' wʌc'on lojon ti pensal? Mi Cristojetyʌch, jini yajcʌbil bʌ, subeñon lojon ti tsiquil bʌ t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús ti' jac'ʌ: Tsa'ix c subeyetla. Mach'an ti la' ch'ujbiyon. Jini mu' bʌ c cha'len tsa' bʌ i yʌc'on c cha'len c Tyat ti panchan mi yʌc'on ti cʌjñel. ");
INSERT INTO ctu76_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero jatyetla, mach'an mi la' ch'ujbiñon. Como mach c tiñʌme'etla chʌ'ʌch bajche' tic wʌ subetla. ");
INSERT INTO ctu76_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","C tiñʌme'ob mi' cʌmbeñon c t'an. Mij cʌñob. Mi' tsʌcleñoñob majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi cʌq'uen i cuxtyʌlel mach'ʌ yujil jilel. Mach'an ba' bʌ ora mi quejel i sajtyel. Mach'an majch mi quejel i chilben loq'uel tij c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mach'an majch más ñuc bajche' c Tyat tsa' bʌ i yʌc'on. Mach'an majch ch'ujbi i loc'ben ti i c'ʌb c Tyat jini c tiñʌme'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Joñon juntiquilon jach quic'ot c Tyat. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Che' jini, israelob mu' bʌ i contrajiñob ti' cha' lotyoyob tyun cha'an i julob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesús ti' subeyob: Cabʌl wen tyac bʌ tic cha'le wʌ' ba' añetla cha'an ti i p'ʌtyʌlel c Tyat ti panchan. ¿Jin cha'an baqui bʌ ti caj tsa' bʌ c cha'le che' mi quejel la' julon? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jini israelob ti' jac'ʌyob: Mach'an mi quej lojon c julet cha'an ti caj wen bʌ tsa' bʌ a cha'le pero cha'an ma' cuy a bʌ ti Dios. Aunque winiquet jach pero chʌncol a cuy a bʌ ti Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Che' jini, Jesús ti' subeyob: Ti mandar la' cha'an ts'ijbubil cha'an Dios ti' sube jini año' bʌ ye'tyel: Jatyetla diosetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ti ajli ti diosob jini año' bʌ ye'tyel ti ñoj oniyix cha'an ti caj ti' cʌntisʌyob i pi'ʌlob bajche' ts'ijbubil ti' t'an Dios. Che' ti subentiyob ti Dios jini año' bʌ ye'tyel ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Dios ti yajcʌyon. Ti' chocoyon tyʌlel wʌ' ti mulawil. ¿Bajche'qui ch'ujbi la' wʌle' mi muc' jach cuye' c bʌ ti Dios che' ti cʌlʌ i Yalobilon Dios? ");
INSERT INTO ctu76_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Mi mach'an mic cha'len muc' bʌ i cha'len tyac c Tyat ti panchan, mach yom la' ch'ujbin cha'an ti' chocoyon tyʌlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero che' mic cha'len ñuc tyac bʌ aunque mach la' wom la' ch'ujbin mu' bʌ c subeñetla, pero ch'ujbin cha'an Dios ti yʌc'on c p'ʌtyʌlel cha'an jini ñuc tyac bʌ tsa' bʌ c cha'le cha'an mi la' junyajlel ñoj ña'tyan c Tyat an ti joñon yic'ot joñon añon tic Tyat, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Cha' yomob i cʌchob Jesús jini israelob año' bʌ ye'tyel pero Jesús ti puts'i loq'uel ya' ba'añob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús ti sujti ti junxejlel colem ja' Jordán bʌ i c'aba'. Ti cʌyle ya' ba' ti ñaxan ac'ʌ ch'ʌm ja' Juan. ");
INSERT INTO ctu76_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Cabʌl quixtyañu ti majli ba'an Jesús. Ti yʌlʌyob: Aunque mach'an ti' pʌsʌ ñuc tyac bʌ i p'ʌtyʌlel jini Juan pero melelʌch pejtyelel i t'an tsa' bʌ i yʌlʌ cha'an ili winic, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Cabʌlob ti' ch'ujbi cha'an yajcʌbil i cha'an Dios jini Jesús ya'ya'i. ");
INSERT INTO ctu76_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","An juntiquil c'am bʌ winic Lázaro bʌ i c'aba'. Ya' an ti lum Betania bʌ i c'aba' ya' ba' chumul je'el María yic'ot Marta i chich bʌ María. ");
INSERT INTO ctu76_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","María i yijts'in Lázaro jini c'am bʌ. Jiñʌch jini María jiñʌch tsa' bʌ i yulbe aceite bʌ perfume ti i yoc lac Yum tsa' bʌ i sujcube ti' tsutsel i jol i yoc. ");
INSERT INTO ctu76_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Che' jini, jini cha'tiquil i yijts'in Lázaro ti' chocoyob majlel t'an ba'an Jesús cha'an i suben: C Yum, c'am jini mu' bʌ a p'untyan, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Che' ñac ti yubibe i t'an, ti yʌlʌ Jesús: Iliyi i c'am'an mach cha'anic yoque sajtyel pero cha'an mi tsictiyel i ñuclel Dios. Ti ili c'am'an mi tsictiyel c ñuclel je'el i Yalobilon bʌ Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Aunque Jesús ti' wen p'untyʌ Marta yic'ot i yijts'in yic'ot Lázaro pero che' ñac ti subenti Jesús cha'an c'am Lázaro tsa' tyo cʌyle cha'p'ej q'uin ya' ba' ti chojqui ti pʌyol. ");
INSERT INTO ctu76_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ti wi'il ti' sube ajcʌnt'añob i cha'an: Cha' coxla ti pañimil Judea bʌ i c'aba', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Che' jini, ajcʌnt'añob i cha'an ti' sube: Maestro, max tyo jaliji yom i juletyob ti tyun jini israelob mu' bʌ i contrajiñet cha'an i tsʌnsañet. ¿A wom ba cha' majlel ya'i? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús ti' subeyob ti jump'ej lajoñel cha'an an tyo i yorojlel cha'an mejlic i cha'len troñel Jesús. Ti yʌlʌ: ¿Mach'a melel an doce ora ti jump'ej q'uin? Jini mu' bʌ i cha'len xʌmbal ti q'uinil mach'an mi yajlel como mi yilan i sʌclel mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero jini mu' bʌ i cha'len xʌmbal ti ac'bʌlel mi' jats' i yoc como mach'an i sʌclel mu' bʌ i pʌsben i bijlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Che' ñac ti ujti i yʌle' jini t'an, Jesús ti' subeyob: Wʌyʌlix lac pi'ʌl Lázaro. Pero mi quej c majlel c p'ixtisan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Che' jini, jini ajcʌnt'añob i cha'an ti' subeyob: C Yum, mi wʌyʌl yom yʌl cha'an mi quejel i lajmel, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús yom i yʌle' cha'an sajtyemix Lázaro. Jini ajcʌnt'añob i cha'an ti' lolon ña'tyʌ chʌncol yʌl cha'an i yoque wʌyel jach. ");
INSERT INTO ctu76_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Che' jini, Jesús ti' sube ti wen tsiquil bʌ t'an: Sajtyemix Lázaro. ");
INSERT INTO ctu76_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Tijicñayon cha'an mach'an ya' añon como más wen cha'añetla cha'an mi la' ch'ujbiñon. Pero con laj q'uele', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Che' jini, Tomás mu' bʌ i pejcʌntyel ti Lut ti i pi'ʌlob, ti' sube jini yambʌ ajcʌnt'añob i cha'an Jesús: Conla je'el cha'an motin sajticonla yic'ot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Che' ñac ti c'otiyob ti yubiyob cha'an añix chʌmp'ej q'uin i ch'ujñʌntyel Lázaro. ");
INSERT INTO ctu76_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Lʌc'ʌlix Betania ti Jerusalén che' bajche' jump'ej legua i ñajtlel. ");
INSERT INTO ctu76_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Cabʌl israelob ti majli i jula'an Marta yic'ot María cha'an i ñuc isʌbeñob i pusic'al cha'an ti sajti i yʌscun. ");
INSERT INTO ctu76_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Che' ñac ti' ña'tyʌ Marta cha'an ya'ix c'otyel Jesús ti loq'ui ti yotyot cha'an i tyaj tyʌlel Jesús. Pero María ti cʌyle ti mal otyot. ");
INSERT INTO ctu76_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta ti' sube Jesús: C Yum, wʌ'ic añet mach'an ti sajti cʌscun, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero cujil isujm wale iliyi, Dios mi lu' aq'ueñet mu' bʌ a c'ajtiben, che yʌlol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús ti' sube: A wʌscun mi quej i cha' cuxtiyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta ti' sube: Muc'ʌch. Cujil isujm mi quejel i cha' cuxtiyel che' ti yorojlel mi cha' tyejchel loq'uel ba'an sajtyemo' bʌ ti jini cojix bʌ q'uin, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Che' jini, Jesús ti' sube: Joñon ajtyech ch'ujlelʌlon. Mi cʌq'uen tsiji' bʌ i cuxtyʌlel. Jini mu' bʌ i ch'ujbiñon aunque ti sajti, mi quejel i cha' cuxtiyel. ");
INSERT INTO ctu76_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ti pejtyelel cuxulob tyo bʌ wale iliyi mu' bʌ i yochel tic cha'an, ma'ix mi quejel i sajtyel cha'an ti bele' ora. ¿Mu' ba a ch'ujbin jini? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta ti' jac'ʌ: Muc'ʌch c ch'ujbin, c Yum. Mic ch'ujbin cha'an jatyet Cristo jini Yalobilet Dios am bʌ cha'an tyʌlic wʌ' ti mulawil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Che' ñac ti ujti i yʌle' jini t'an, Marta ti majli i pʌye' tyʌlel i yijts'in María bʌ i c'aba'. Ti' mucul sube: Wʌ'an lac Maestro. Mi' pʌyet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ti ora jach che' ti yubi jini t'an María ti wa' tyechi ba' buchul. Ti majli ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Max tyo och tyʌlel ti lum Jesús. Ya' tyo an ba' ti' ñaxan tyaja Marta. ");
INSERT INTO ctu76_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Che' ñac ti yilʌ israelob ya' bʌ añob ti i yotyot cha'an i ñuc isʌbeñob i pusic'al, che' ti wa' tyejchi María, ti ora jach ti loq'ui majlel, ti' tsʌcleyob majlel. Ti' ña'tyʌyob mi quej i majlel ti uq'uel ba' ti ch'ujñʌnti Lázaro. ");
INSERT INTO ctu76_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Che' jini, che' ti c'oti María ya' ba'an Jesús ti ñocle ti yebal yoc Jesús. Ti' sube: C Yum, wʌ'ic añet mach'an ti sajti cʌscun, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Che' ñac Jesús ti yilʌ muc' ti uq'uel María, yic'ot jini israelob ya' bʌ an yic'ot, wen ch'ʌjyem ti yubi. Wen c'ux ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jesús ti' c'ajtibeyob: ¿Baqui ti la' ch'ujñʌ? che'en. Ti' subeyob: La'. Q'uele, che'ob. Ya' ti c'otiyob ya' ba' ch'ujñʌbil Lázaro. ");
INSERT INTO ctu76_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús ti' cha'le uq'uel. ");
INSERT INTO ctu76_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Che' jini, jini israelob ti yʌlʌyob: Q'uele, wen cabʌl ti' p'untyʌ, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero an yambʌ tsa' bʌ yʌlʌyob: Jini Jesús ti yʌq'ue i q'uele' pañimil muts'ulo' bʌ i wut. Wʌ'ic an Jesús, añʌch tyo ti caj bajche' ti' cha'le Jesús cha'an mach'an mi sajtyel jini Lázaro, che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús cha' wen c'ux ti' pusic'al. Ti lʌc'ʌ ba' ch'ujñʌbil. An muconibʌl melel bʌ ti mal tyun. An jump'ej wechel bʌ colem tyun i mʌjquil. ");
INSERT INTO ctu76_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús ti' subeyob: Loc'sanla jini tyun. Marta, i yijts'in jini tsa' bʌ sajti ti yʌlʌ: C Yum, tyuwix como anix chʌmp'ej q'uin i sajtyel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero Jesús ti' sube: ¿Mach'a ba'an tic subet mi mux a ch'ujbiñon mi quej a q'uele' i ñuclel Dios? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Che' jini, ti' loc'sʌyob jini tyun. Jesús ti' q'uele letsel ti panchan. Ti yʌlʌ: C Tyat, mic subeñet wocox a wʌlʌ como tsa'ix a wubibon c t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Cujil isujm ma' bele' ubibeñon c t'an, pero mi cʌle' cha'an ti caj jini wʌ' bʌ añob tic joytyʌlel cha'an mi' ch'ujbin cha'an jatyet ti a chocoyon tyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Che' ñac ti ujti i yʌle' jini, ti c'am bʌ t'an ti yʌlʌ: Lázaro, loq'uen ya'i, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ti loq'ui jini tsa' bʌ sajti. Bʌc'ʌl tyo i yoc i c'ʌb ti pisil. Mosol tyo i ñi' i wut ti pisil. Jesús ti' subeyob: Tiquila cha'an ch'ujbi i cha'len xʌmbal. Lax cha' majlic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Che' ti yilʌyob chʌ bʌ ti' cha'le Jesús, cabʌl jini israelob tsa' bʌ i pi'leyob ti xʌmbal María, ti' ch'ujbibeyob cha'an yajcʌbil i cha'an Dios jini Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero an yaño' bʌ tsa' bʌ majliyob i suben fariseojob tsa' bʌ i cha'le Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Che' jini, jini fariseojob yic'ot jini ñuc bʌ curajob ti' much'quiyob i bʌ yic'ot año' bʌ ye'tyel ti Comité Junta Suprema bʌ i c'aba'. Ti yʌlʌyob: ¿Chuqui yom lac tyumben? Ili winic mi' pʌse' cabʌl ñuc tyac bʌ i p'ʌtyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Mi mach'an chʌ bʌ mi lac tyumben, ti pejtyelelob mi quejel i ch'ujbiñob. Jini romanojob año' bʌ ye'tyel mi quejel i tyʌlel. Mi quejel i jisan lac templo yic'ot lac lumal. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero juntiquil ñoj ñuc bʌ cura ti jim bʌ jabil, Caifás bʌ i c'aba' ti yʌlʌ: Mach'an chʌ bʌ mi la' ña'tyan. ");
INSERT INTO ctu76_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Mach'an mi la' ña'tyan más wen cha'añonla muq'uic i sajtyel juntiquil winic cha'añonla cha'an mach'an mi tsʌnsʌntyel ti pejtyelel quixtyañu ti lac lumal, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero mach'an ti bajñel yʌlʌ iliyi Caifás cha'an ti' bajñel i pensal. Pero cha'an ñoj ñuc bʌ cura ti jim bʌ jabil ñijcʌbil ti Dios i wʌ ale' cha'an Jesús mi quejel i sajtyel cha'an ti pejtyelel israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mach cha'anic jach jini israelob mi sajtyel Jesús pero cha'an mi quejel i yajñel ti junmujch' jach ti pejtyelel i yalobilob Dios ba'ic jach pujquemob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Che' jini, ti jim bʌ q'uin ti queji i bej ña'tyan bajche' mi quejel i tsʌnsan Jesús jini año' bʌ i ye'tyel ba'an israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jin cha'an Jesús mach'an ti' bej ñoj pʌsʌ i bʌ ya' ba'an israelob año' bʌ i ye'tyel. Pero ti loq'ui majlel ti pañimil Judea. Ti majli Jesús lʌc'ʌl ti tyʌquin bʌ joch lum Efraín bʌ i c'aba'. Ya'i ti cʌyle yic'ot ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Lʌc'ʌlix i q'uiñejel cha'an pascua bʌ q'uin i cha'an bʌ israelob. Cabʌl quixtyañujob ti ñaxan majli i chajpañob i bʌ che' max tyo i yorojlel q'uin che' bajche' i tyʌlel mi' pocob i bʌ cha'an bajche' ti' ch'ujbiyob. ");
INSERT INTO ctu76_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chʌncol i sajcañob Jesús. Che' ya' añob ti' pat colem templo ti' c'ajtibeyob i bʌ: ¿Bajche' mi la' ña'tyan? ¿Tyal ba ti ti q'uin o mach tyal? che'ob. Che' ti' tyajayob ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jini fariseojob yic'ot jini ñuc bʌ curajob ti' wʌ subeyob quixtyañujob mi an majch yujil baqui an Jesús yom mi' subeñob cha'an mi' cʌchob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Che' an tyo yom wʌcp'ej q'uin che' mi quejel jini pascua bʌ q'uin i cha'an bʌ israelob ti majli Jesús ti Betania ba' chumul Lázaro. Jiñi Lázaro jiñʌch tsa' bʌ i tyejchisʌ loq'uel Jesús ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ya'i ti' melbeyob i yuch'el Jesús. Marta ti' we'sʌyob. Ya'an Lázaro ti mesa ti uch'el yic'ot Jesús yic'ot yaño' bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Che' jini María ti' ch'ʌmʌ tyʌlel ba'an Jesús che' bajche' xiñol litro aceite bʌ perfume nardo bʌ i c'aba'. Wen lets i tyojol. Ti' yulbe i yoc Jesús. Ti wi'il ti' sujcube i yoc ti' tsutsel i jol. Ti pujqui i yujts'il perfume ti pejtyelel i mal i yotyot. ");
INSERT INTO ctu76_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Che' jini Judas Iscariote i yalobil bʌ Simón juntiquil ajcʌnt'an i cha'an Jesús mu' bʌ quej i yʌc' ti cʌchol Jesús che' ñac jini ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Chucoch mach'an ti chojni jini perfume cha'an trescientos denarios cha'an mi la cʌq'uen jini p'ump'uño' bʌ? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pero mach'an ti' pensali p'ump'uño' bʌ jini Judas. Tsa' jach i yʌlʌ cha'an ajxujch' jini Judas. An ti' wenta i cʌñʌtyan tyaq'uin motin i cha'añob. Ti' xujch'i loq'uel ti jini am bʌ ti' wenta. ");
INSERT INTO ctu76_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Che' jini Jesús ti yʌlʌ: Mach la' tiq'ue' jini María. Lotyol i cha'an jini perfume cha'an i chajpʌntyel c mujquel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ti bele' q'uin wʌ'an la' wic'ot jini p'ump'uño' bʌ. Pero joñon mach'an bele' q'uin wʌ'añon quic'otyetla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cabʌl israelob ti yubiyob cha'an ya'an Jesús ti Betania. Ti majliyob ya'i mach cha'an jach yom i q'uel Jesús pero cha'an yomob i q'uel Lázaro je'el tsa' bʌ tyejchisʌ loq'uel Jesús ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Che' jini, jini ñuc bʌ curajob ti' lajayob i t'an cha'an yom i tsʌnsañob Lázaro je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Como ti caj Lázaro cabʌl israelob ti' cʌyʌyob i tsʌcleñob majlel jini curajob cha'an i ch'ujbiñob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Cabʌl quixtyañu ti majli ti Jerusalén cha'an i melob pascua bʌ q'uin i cha'an israelob. Ti yijc'ʌlel ti yubiyob cha'an mi quejel i c'otyel Jesús ti lum je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Che' jini, ti' tyuc'uyob i yopol tyac ch'ip. Ti loq'uiyob majlel ti Jerusalén cha'an i tyaj tyʌlel Jesús. Ti c'am bʌ t'an ti yʌlʌyob. La' sujbic i ñuclel Dios. Tijicñayet jatyet chʌncol bʌ a tyʌlel cha'an che' yom Dios. Tijicñayet i yumet israelob, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ti' tyaja juncojt burro. Ti' c'ʌchtyʌ che' bajche' ts'ijbubil ti Ts'ijbubil bʌ i T'an Dios: ");
INSERT INTO ctu76_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mach yom mi la' cha'len bʌq'uen añet bʌ la ti lum Sión bʌ i c'aba'; Q'uele ñuc bʌ yumʌl la' cha'an. C'ʌchʌl ti pat yal burro. Che' ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ti ñaxan max tyo ti' ch'ʌmʌyob isujm jini ajcʌnt'añob i cha'an Jesús tsa' bʌ ujti. Pero ti wi'il tyo che' ñac ti tsictiyi i ñuclel Jesús che' ti letsi majlel ti panchan ti' cha' c'ajtiyiyob i cha'an bajche' wʌ ts'ijbubil ti' t'an Dios ti ñoj oniyix cha'an Jesús cha'an mi quejel i c'ʌchtyan i yal burro. ");
INSERT INTO ctu76_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jini quixtyañujob tsa' bʌ i yilʌyob che' ñac Jesús ti' pejcʌ Lázaro ya' ti muconibʌl che' ñac ti' tyejchisʌ loq'uel ba'an sajtyemo' bʌ, ti queji i lu' cha' alob tsa' bʌ i yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jin cha'an ti majliyob i tyaj tyʌlel Jesús che' ñac ti ochi majlel Jesús ti Jerusalén cha'an ubibil i cha'an jini ñuc tyac bʌ i p'ʌtyʌlel tsa' bʌ i pʌsʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Che' jini, jini fariseojob ti' subeyob i bʌ: Q'uele awilan, ma' chʌ bʌ ch'ujbi lac cha'len. Ti pejtyelel quixtyañu mi' tsʌcleñob majlel Jesús, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","An je'el quixtyañujob mach bʌ israelob tyʌlem bʌ ti pañimil Grecia bʌ i c'aba', ti c'otiyob je'el ti Jerusalén cha'an i ch'ujutisan Dios che' ti yorojlel q'uin. ");
INSERT INTO ctu76_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Jini griegojob ti majliyob ba'an Felipe ch'oyol bʌ ti lum Betsaida am bʌ ti pañimil Galilea bʌ i c'aba'. Ti' subeyob: Com lojon j q'uele' Jesús, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe ti majli i suben Andrés. Jini cha'tiquil ti majliyob i suben Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Che' jini, Jesús ti' subeyob: Wale i yorojlelix mi quejel i tsictiyel c ñuclel, Joñon i Pi'ʌlon bʌ Quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Melel mic subeñetla: Mi mach'an mi yochel ti lum jump'ej i bʌc' trigo o chʌ bʌ jach yes bʌ pac', mi mach'an mi mujquel, che' jach an. Pero mi ti mujqui, mi pasel. Mi yʌc' cabʌl i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jini mu' bʌ i lolon bajñel p'untyan i bʌ cha'an machic i ñusan wocol mi quejel i sʌt i bʌ. Pero jini mu' bʌ i yʌc' i bʌ che' bajche' mi' p'aje' i bʌ yubil cha'an tij caj, mi cʌñʌtyʌntyel cha'an mi yʌq'uentyel i cuxtyʌlel mach'ʌ yujil jilel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mi an majch yom i cha'libeñon c toñel, yom i tsʌcleñon. Ya' ba' añon ya' mi quejel i yajñel je'el. Jini mu' bʌ i cha'libeñon c toñel mi quejel i q'uejlel ti ñuc tic Tyat ti panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesús ti yʌlʌ: Wale ch'ʌjyemon. ¿Chuqui yom mi cʌle? ¿Yom ba mi cʌl: C Tyat, cotyañon loq'uel ti jini wocol mu' bʌ quejel c ñusan? Mach'an, como jini cha'an ti tyʌliyon. ");
INSERT INTO ctu76_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C Tyat, cotyañon cha'an c pʌse' a ñuclel. Che' jini ti ubinti t'an loq'uem bʌ tyʌlel ti panchan tsa' bʌ yʌlʌ: Tsa'ix c pʌsʌ c ñuclel mu' tyo c cha' pʌse', che' ti ubinti ajt'an. ");
INSERT INTO ctu76_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jini quixtyañujob ya' bʌ añob tsa' bʌ i yubi ajt'an ti yʌlʌyob: I t'an chajc, che'ob. Yaño' bʌ ti yʌlʌyob: Juntiquil ajtoñel i cha'an Dios ch'oyol ti panchan ti' cha'le t'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Che' jini, Jesús ti' subeyob: Mach bajñel cha'añon ti ajli t'an pero ti ajli cha'añetla je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wale i yorojlel mi yujtyel melojel cha'an jini año' bʌ ti mulawil. I yorojlel mi chojquel loq'uel jini xiba mu' bʌ ti xic' wʌ' ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Che' mic letsʌntyel ti chañelel lum mi quejel i ñijcʌbentyel i pusic'al pejtyelel quixtyañu mu' bʌ quejel i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Chʌ'ʌch ti wʌ alʌ Jesús cha'an mi' tsictisan bajche' mi quejel i sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Quixtyañujob ti' jac'ʌyob: Tsa'ix lojon cubi ti juñilel i cha'an mandar cha'an jini yajcʌbil bʌ i cha'an Dios mi yajñel ti bele' ora. ¿Bajche'qui isujm che' ma' wʌl i Pi'ʌl Quixtyañujob wersa mi letsʌntyel? ¿Majchqui jini i Pi'ʌl Quixtyañujob? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús ti' sube: Wʌ' tyo añon la' wic'ot che' bajche' i sʌclelon mulawil. Pero ma'ix bej jal wʌ' añon. Tsʌcleñon che' tsiquil tyo yubil como tyalix yic'an. Jini mu' bʌ i yajñel ba' iq'uix mach'an mi yilan ba' mi majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Che' wʌ' tyo añon la' wic'ot i sʌclelon bʌ mulawil, ch'ujbiñon cha'an mi la' wajñel ti quixtyañu i cha'añet bʌ la i sʌclel. Che' ti' cha'le lajoñel Jesús che' ti' tyaja i bʌ ti t'an. Che' ti ujti i yʌle' tyac ili ti majli. Mach'an ti' ña'tyʌyob baqui ti majli. ");
INSERT INTO ctu76_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Aunque Jesús ti' pʌsʌ cabʌl ñuc tyac bʌ i p'ʌtyʌlel ya' ba'añob, mach'an ti' ch'ujbiyob cha'an yajcʌbil i cha'an Dios jini Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chʌ'ʌch ti ujti como wersa mi ts'ʌctiyel jini t'an tsa' bʌ i wʌ alʌ jini tsa' bʌ i xiq'ui i yʌle' Dios ti ñoj oniyix Isaías bʌ i c'aba'. Ti yʌlʌ: C Yum, mach'an majch ti' ch'ujbi cha'an melel c t'an tsa' bʌ c subeyob. Mach'an majch ti' ña'tyʌ che' ñac lac Yum ti' pʌsʌ i p'ʌtyʌlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Cha'an mach ch'ujbi i ch'ujbin cha'an melel i t'an Isaías ti' wʌ ts'ijbu je'el ti ñoj oniyix: ");
INSERT INTO ctu76_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios ti yʌq'ue i yajñel ti muts'ulo' bʌ i wut yic'ot ti tsʌtso' bʌ i pusic'al yubil cha'an machic i ch'ujbin chʌ bʌ ti subenti, cha'an machic i q'uele' pañimil yubil che' ñac ti pʌs'enti ñuc tyac bʌ, cha'an machic i sutquin i bʌ i ch'ujbiñon cha'an mic lajmisañob. Che' ti wʌ alʌ Isaías ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Chʌ'ʌch ti yʌlʌ Isaías cha'an ti wʌ yilʌ i ñuclel Jesús. Ti' wʌ tyaja ti t'an Jesús ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero cabʌl israelob ti' ch'ujbiyob cha'an jiñʌch yajcʌbil i cha'an Dios jini Jesús. Jinic tyo an cha'tiquil uxtiquil año' bʌ i ye'tyel ti' ch'ujbiyob je'el. Pero mach'an ti' tsictisʌyob como ti' bʌc'ñʌyob jini fariseojob cha'an mach'an mi chojquel loq'uel ti i templo i cha'an bʌ israelob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Como más ti' mulʌyob i subentyel i ñuclel ti quixtyañujob bajche' i subentyel i ñuclel ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús ti yʌlʌ ti c'am bʌ t'an: Jini mu' bʌ i ch'ujbin cha'an chocolon tyʌlel ti Dios mach i bajñel jach mi' ch'ujbiñon, pero mi' ch'ujbin je'el c Tyat ti panchan tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jini mu' bʌ i yilañon mi yilan je'el jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ti tyʌliyon cha'an joñon i sʌclelon mulawil. Jini mu' bʌ i ch'ujbiñon mach'an mi bej ajñel ti ic'jowan bʌ pañimil. ");
INSERT INTO ctu76_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero mi an majch mi yubin c t'an pero mi mach'an mi ch'ujbiñon mach joñonic mi cʌq'uen i xot' i mul como mach'an ti tyʌliyon ti mulawil cha'an cʌq'uen i xot' i mul pero cha'an mij cotyañob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jini mach'ʌ ba'an mi' ch'ujbin cha'an yajcʌbilon i cha'an Dios mach'ʌ ba'an mi' ch'ujbin c t'an mi yʌq'uentyel i xot' i mul ti yorojlel melojel. Jinic t'an tsa' bʌ c subetla mi quejel yʌq'uen i tsictiyel i mul quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Como mach'an mic sub c bajñel ña'tyʌbal pero c Tyat tsa' bʌ i chocoyon tyʌlel ti' xiq'uiyon chʌ bʌ yom cʌle', chʌ bʌ yom mij cʌntisan quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jini mu' bʌ c subeñetla jiñʌch tsa' bʌ i subon c Tyat c subeñetla. Cujil isujm jini i t'an c Tyat mi yʌq'uen quixtyañujob i cuxtyʌlel mach'ʌ yujil jilel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cʌyʌl tyo jump'ej q'uin cha'an i tyaj i q'uinilel jini pascua bʌ q'uin i cha'an israelob. Yujil isujm Jesús cha'an i yorojlelix i cʌye' ili mulawil cha'an mi cha' majlel ba'an i Tyat ti panchan. Jesús ti' wen p'untyʌ i cha'añob wʌ' bʌ añob ti mulawil. Mi quejel i pʌs'eñob jini más ñuc bʌ i señʌjlel cha'an ti' p'untyʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jini xiba tsa'ix ujti i nijcʌben i pusic'al Judas Iscariote i yalobil bʌ Simón cha'an i ña'tyan i yʌc' ti cʌchol Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús yujil isujm ti tyʌli ti Dios. Yujil isujm je'el mi quejel i cha' majlel ba'an Dios. Yujil isujm tsa'ix aq'uenti i p'ʌtyʌlel ti i Tyat cha'an i mele' chʌ bʌ yes yom mi' mele'. ");
INSERT INTO ctu76_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesús ti tyechi ba' buchul ti mesa. Ti' jocho pʌl bʌ i bujc. Ti' cʌchʌ tyam bʌ sujquic'ʌbʌl ti xinil. ");
INSERT INTO ctu76_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ti' jebe ja' ti poc'. Ti queji i pocben i yoc jujuntiquil ajcʌnt'añob i cha'an. Ti' sujcubeyob i yoc ti sujquic'ʌbʌl cʌchʌl bʌ ti xinil. ");
INSERT INTO ctu76_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Che' bʌ yom i pocben i yoc Simón Pedro ti queji i yʌle': C Yum, ¿mu' ba quejel a pocbeñon coc? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús ti' jac'ʌ: Max tyo ba'an ma' ch'ʌmben isujm chʌ bʌ muc'on. Pero mu' tyo quejel a ña'tyan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero Pedro ti' sube: Mach'an ba' bʌ ora mi quejel a pocbeñon coc, che'en. Jesús ti' jac'ʌ: Mi mach'an mic pocbeñet a woc mach c cha'añetic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro ti' sube: C Yum, mach jinic jach coc, pero ma' pocbeñon j c'ʌb col je'el, che' jini, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero Jesús ti' sube: Jini ujtye bʌ i cha'leñob ts'ʌmel yom jach pocbentyel i yoc cha'an cha' sʌquix mi yajñel. Sʌc isʌbiletla aunque mach ti pejtyeletla sʌc isʌbiletla, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ti yʌlʌ cha'an mach sʌc isʌbilob ti pejtyelelob, como yujil isujm majchqui jini mu' bʌ quej i yʌc ti cʌchol. ");
INSERT INTO ctu76_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Che' ti ujti i pocbeyob i yoc ti' cha' xojo pʌl bʌ i bujc. Ti cha' buchle ba'an mesa. Ti' subeyob: ¿Mu' ba la' ch'ʌmben isujm chʌ bʌ tic cha'le? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Jatyetla mi la' pejcañon ti la' Maestro, la' Yumon. Melelʌch como chʌ'ʌch añon. ");
INSERT INTO ctu76_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mi joñon la' Maestro, la' Yumon tic pocbeyetla la' woc, jatyetla je'el yom la' pocben la' bʌ la' woc. ");
INSERT INTO ctu76_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Tic cha'le pʌsoñel cha'an mi la' cha'len che' bajche' tic cha'le. ");
INSERT INTO ctu76_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Melel mic subeñetla, mach'an ajtoñel más an bʌ i ñuclel bajche'on i yumon. Mach'an más ñuc jini chocol bʌ majlel bajche'on jini tsa' bʌ c chocoyetla majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Che' la' wujil isujm chʌ bʌ tic subetla c'ajacña la' woj mi chʌ'ʌch mi quejel la' cha'len. ");
INSERT INTO ctu76_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Mach ti la' pejtyel mic subeñetla. Cujil isujm majchqui jini tsa' bʌ c yajcʌ. Pero wersa yom c ts'ʌctisan jini Ts'ijbubil bʌ i T'an Dios ba' mi yʌle': Jini mu' bʌ ti uch'el quic'ot ti' contrajiyon, che' ts'ijbubul, che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mic wʌ subeñetla cha'an che' mi yujtyel bajche' ti cʌlʌ mi la' ña'tyan majchonqui. ");
INSERT INTO ctu76_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Melel mic subeñetla, jini mu' bʌ i pʌy ochel jini mu' bʌ c choc majlel mi' pʌyon ochel yubil. Jini mu' i pʌyon mi' pʌy ochel Dios tsa' bʌ i chocoyon tyʌlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Che' ujtye i yʌle' tyac ili Jesús, wen ch'ʌjyem ti queji i yubin. Ti wen tsiquil bʌ t'an ti' subeyob: Melel mic subeñetla juntiquiletla mi quejel la' wʌc'on ti' c'ʌb j contrajob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jini ajcʌnt'añob i cha'an ti queji i q'uelob i bʌ. Pero mach'an ti' ña'tyʌyob majchqui chʌncol bʌ i tyaje' ti t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Juntiquil ajcʌnt'añob i cha'an Jesús tsa' bʌ wen p'untyʌnti ti Jesús ti' cha'le uch'el ya' ti' t'ejl Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro ti' pʌsʌ ti' c'ʌb cha'an yom i c'ajtiben Jesús majchqui jini mu' bʌ quejel i yʌc' ti c'ʌb i contra. ");
INSERT INTO ctu76_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Che' jini, ti' más lʌc'ʌ Jesús cha'an i c'ajtiben: C Yum, ¿majchqui jini chʌncol bʌ a tyaj ti t'an? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús ti' jac'be: Mi quejel c ts'aje' ts'itya' caxlan waj. Jini mu' bʌ cʌq'uen, jiñʌch jini, che'en. Che' jini, ti' ts'aja ts'itya' caxlan waj. Ti yʌq'ue Judas Iscariote i yalobil bʌ Simón. ");
INSERT INTO ctu76_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Che' ti' ch'ʌmʌ jini caxlan waj Judas, ti ora ti ochi Satanás ti' pusic'al. Che' jini, Jesús ti' sube: Ora jach ma' cha'len jini mu' bʌ quej a cha'len, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero mach'an majch ya' bʌ chʌncol ti uch'el ti' ch'ʌm'eyob isujm chucoch che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Cha'an an ti' wenta Judas jini tyaq'uin motin i cha'año' bʌ, an jini tsa' bʌ lolon pensaliyob Jesús ti' sube cha'an an chʌ bʌ yom i mʌn cha'an q'uiñejel o cha'an mi' cotyan p'ump'uño' bʌ. Che' ti' lolon pensaliyob. ");
INSERT INTO ctu76_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Che' ñac ti ujti i c'uxe' jini caxlan waj tsa' bʌ aq'uenti, Judas ti loq'ui majlel. Ac'bʌlelix. ");
INSERT INTO ctu76_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Che' tsa'ix loq'ui Judas, Jesús ti' subeyob: Wale an chʌ bʌ mi quej c tyumbentyel mu' bʌ i tsictisan c ñuclel Joñon i Pi'ʌlon bʌ Quixtyañujob. I ñuclel Dios mi tsictiyel ti joñon. ");
INSERT INTO ctu76_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Che' bajche' Joñon i Pi'ʌlon Quixtyañujob mic tsictisan i ñuclel Dios, chʌ'ʌch Dios mi' tsictisan i ñuclel i Yalobil. Ora jach mi quej i tsictisan. ");
INSERT INTO ctu76_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Calobilet bʌ la, mach bej cabʌl ora wʌ' añon la' wic'ot. Mi quej la' sajcañon. Pero chʌ'ʌch bajche' tic subeyob jini israelob año' bʌ i ye'tyel chʌ'ʌch mic wʌ subeñetla je'el wale: Mach ch'ujbi la' majlel ya' ba' mi quej c majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mi cʌq'ueñetla tsiji' bʌ mandar cha'an la' p'untyan la' bʌ. Chʌ'ʌch bajche' tic p'untyʌyetla chʌ'ʌch yom la' p'untyan la' bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mi ti la' p'untyʌ la' bʌ ti pejtyelel quixtyañu mi quejel i ña'tyan ajcʌnt'añetla c cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro ti' c'ajtibe Jesús: C Yum, ¿baqui mi quej a majlel? che'en. Jesús ti' jac'be: Ya' ba' mic majlel mach ch'ujbi la' tsʌcleñon majlel wale iliyi. Pero mu' tyo quej a tsʌcleñon majlel ti tyal tyo bʌ ora, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Che' jini, Pedro ti' sube: C Yum, ¿chucoch mach ch'ujbi c tsʌcleñet majlel wale iliyi ba' ma' majlel? Chajpʌbilon cʌc' c bʌ ti sajtyel cha'añet, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús ti' jac'ʌ: ¿Chajpʌbilet ba cha'an a wʌc' a bʌ ti sajtyel cha'añon, ma' wʌl? Melel mic subeñet: Che' max tyo i cha'le uq'uel tyat mut, uxyajl mi quej a wʌl mach a cʌñʌyon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesús ti yʌlʌ: Mach la' cha'len bʌq'uen ti la' pusic'al. Mi la' ch'ujbin Dios. Ch'ujbiñon je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ti yotyot c Tyat an cabʌl chumlibʌl. Machic ba'an cabʌl chumlibʌl tsa'ix c wʌ subetla i wentyʌlel mi machic ba'an, como mi quejel c majlel c chajpʌbeñetla la' wajnib. ");
INSERT INTO ctu76_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Che' mi yujtyel c chajpʌbeñetla la' wajnib, mic cha' tyʌlel c pʌyetla majlel ba'añon, cha'an ya' ba'añon ya' añetla je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","La' wujil isujm baqui mic majlel. Cʌñʌl la' cha'an i bijlel panchan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás ti yʌlʌ: C Yum, mach cujil lojon isujm baqui ma' majlel. ¿Bajche'qui ch'ujbi lojon j cʌn jini bij? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús ti' sube: Joñoñʌch jini bij yom bʌ la' t'un majlel. Mic subeñetla melel bʌ t'an yom bʌ la' ch'ujbin. Mi cʌq'ueñetla la' cuxtyʌlel mach'ʌ yujil jilel. Mach'an majch mi c'otyel ba'an c Tyat. Jini jach am bʌ tic wenta. ");
INSERT INTO ctu76_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Mi ti la' cʌñʌyon ti la' cʌñʌ c Tyat je'el. Wale cʌñʌlix la' cha'an c Tyat. Tsa'ix la' q'uele yubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe ti' sube: C Yum, pʌsbeñon lojon a Tyat. Jasʌl mi ti a pʌsʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús ti' sube: Wajalix wʌ' añon quic'otyetla. ¿Max tyo ba a chʌc cʌñʌyon, Felipe? Jini tsa'ix bʌ i yilʌyon, tsa'ix i yilʌ c Tyat je'el yubil. ¿Chuqui i wentyʌlel a cha'an che' pʌsbeñon lojon a Tyat? che'et. ");
INSERT INTO ctu76_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Mach'a ba'an ma' ch'ujbin añon tic Tyat, c Tyat an ti joñon? Jini t'an mu' bʌ c subeñetla mach'an mic sub tic bajñelil. C Tyat mu' bʌ i yajñel ti joñon, mi' cha'len ili toñel tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ch'ujbin cha'an añon tic Tyat, c Tyat an ti joñon. Mi mach'an mi la' ch'ujbin ili c t'an cha'an tic subeyetla o machqui, jinic jachix ca la' ch'ujbin jini ñuc tyac bʌ tsa' bʌ c pʌsʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Melel mic subeñetla jini mu' bʌ i yochel tic cha'an, mi quejel i pʌs ñuc tyac bʌ p'ʌtyʌlel je'el mu' bʌ c pʌs. Más ñuc bajche' tic pʌsʌ mi quejel i pʌs como mux quejel c cha' majlel ba'an c Tyat c bajñel. ");
INSERT INTO ctu76_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pejtyel chʌ bʌ tyac mi la' c'ajtiben c Tyat cha'an che' com, joñon mi quejel c cha'len cha'an mi tsictiyel i ñuclel c Tyat ti i Yalobilon. ");
INSERT INTO ctu76_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Muc'ʌch cʌq'ueñetla chʌ bʌ tyac jach yes mi la' c'ajtin tij c'aba', cha'an che'ʌch com. ");
INSERT INTO ctu76_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Mi ti la' p'untyʌyon yom la' jac'beñon c mandar. ");
INSERT INTO ctu76_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Joñon mi quej j c'ajtiben c Tyat. Jini mi quej i yʌq'ueñetla yambʌ mu' bʌ i yʌq'ueñetla la' ña'tyʌbal, mu' bʌ i ñuc isʌbeñetla la' pusic'al, cha'an mi yajñel la' wic'ot ti bele' ora. ");
INSERT INTO ctu76_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jiñʌch Ch'ujul bʌ c Ch'ujlel mu' bʌ i pʌs i sujmlel Dios. Jini i cha'año' bʌ mulawil mach ch'ujbi i yʌq'uentyelob Ch'ujul bʌ c Ch'ujlel como mach ch'ujbi i q'uejlel. Mach ch'ujbi i cʌñob je'el. Jatyetla mi la' cʌn, como mi yajñel la' wic'ot. Mi quejel i bele' ajñel ti la' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mach'an mi quej j cʌyetla ti meba'. Cha' tyalon ba' añetla. ");
INSERT INTO ctu76_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jumuc' jach mach'an mi quej i chʌc q'ueloñob jini año' bʌ ti mulawil. Jatyetla mi quej la' q'uelon. Cha'an cuxulon, mi quej la' tyaj la' cuxtyʌlel je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ti jin jach bʌ q'uin mi quej la' ña'tyan añon tic Tyat. Añetla ti joñon. Añon ti jatyetla. ");
INSERT INTO ctu76_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jini mu' bʌ i ña'tyan c xic'ojel, mu' bʌ i jac' c xic'ojel mi' tsictisan cha'an yoque melel mi' p'untyañon. C Tyat mi quejel i p'untyan jini mu' bʌ i p'untyañon. Jonon mi quej c p'untyan je'el. Mi quej cʌq'ueñetla la' wen cʌñon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yañʌch bʌ Judas, mach jinic jini Judas Iscariote, ti' sube: C Yum, ¿chucoch mi quej a wʌq'ueñon lojon c wen cʌñet, che' mach'an ma' wʌq'ueñob i cʌñet jini i cha'año' bʌ mulawil? che' ti yʌlʌ Judas. ");
INSERT INTO ctu76_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús ti' sube: Jini mu' bʌ i p'untyañon, mi' jac' chʌ bʌ mi cʌl. C Tyat ti panchan mi quej i p'untyan. Che' jini c Tyat yic'ot joñon mi quej c tyʌlel lojon ti chumtyʌl quic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jini mach bʌ ba'an mi' p'untyañon mach'an mi' jac' mu' bʌ cʌl. Jini t'an tsa' bʌ la' wubi mach c bajñel cha'an. I cha'añʌch c Tyat je'el tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Tic subeyetla jini t'an che' wʌ' tyo añon la' wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","C Tyat mi quej i choc tyʌlel Ch'ujul bʌ c Ch'ujlel tij q'uexol. Jiñʌch mu' bʌ i yʌq'ueñetla la' ña'tyʌbal, mu' bʌ i ñuc isʌbeñetla la' pusic'al. Jini mi quej i cʌntisañetla pejtyelel chʌ bʌ an tyac. Mi quejel i yʌq'ueñetla la' c'ajtisan pejtyelel chʌ bʌ tyac tic subetla. ");
INSERT INTO ctu76_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mij cʌybeñetla i ñʌch'tyʌlel la' pusic'al. Mi cʌq'ueñetla i ñʌch'tyʌlel c pusic'al. Mach che'ic mi cʌq'ueñetla bajche' mi yʌc'ob i cha'año' bʌ mulawil. Mach la' cha'len pensal. Mach la' cha'len bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Tsa'ix la' wubi cʌl: Mi quej c majlel. Mi quej c cha' tyʌlel wʌ' ba' añetla. Mi melel mi la' p'untyañon tsa'ix tijicñʌyi la' pusic'al cha'an tic subeyetla mic majlel ba'an c Tyat. Como c Tyat más ñuc bajche' joñon. Tijicñayetla che' jini cha'an tijicñayon. ");
INSERT INTO ctu76_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wale tsa'ix c subetla che' max tyo ujt cha'an che' mi yujtyel ch'ujbi la' más ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mach'an mi quej c putyun cha'len t'an quic'otyetla como tyal jini mu' bʌ i cha'liben i toñel xiba. Jini xiba muc' ti xic'ojel wʌ' ti mulawil. Pero mach'anix i p'ʌtyʌlel tij contra. ");
INSERT INTO ctu76_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Chʌ'ʌch yom ujtic cha'an wʌ' bʌ añob ti mulawil mi' ña'tyan mic p'untyan c Tyat. Mic cha'len bajche' ti' xiq'uiyon. Tyejchenla. Coñixla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesús ti yʌlʌ: Joñon che' bajche' i yʌq'uilon ts'ujsub. C Tyat che' bajche' jini mu' bʌ i cʌñʌtyan ts'ujsub. ");
INSERT INTO ctu76_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","C Tyat mi' tsepe' loq'uel ba'ical bʌ i c'ʌb tyac yubil mach bʌ ba'an mi yʌc' i wut. Pero mi' ts'itya' tsep loq'uel jini i c'ʌb tyac mu' bʌ i yʌc' i wut cha'an i más ac' i wut. ");
INSERT INTO ctu76_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Quejcʌbiletla yubil cha'an ti jini t'an tsa' bʌ c subeyetla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ajñenla quic'ot cha'an joñon mi cajñel la' wic'ot. I c'ʌb tyac i yʌq'uil ts'ujsub mach ch'ujbi i yʌc' i wut che' i bajñel jach mi yajñel mi ma'an ts'uyul ti yʌq'uil. Che'ʌch je'el jatyetla mach ch'ujbi la' bajñel cha'len wen bʌ che' mach'an mi la' wajñel la' wic'otyon. ");
INSERT INTO ctu76_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Joñon i yʌq'uilon ts'ujsub yubil. Jatyetla j c'ʌbetla. Jini mu' bʌ i yajñel quic'ot mi cajñel yic'ot mi yʌq'uentyel i tsictiyel cabʌl wen bʌ mi' cha'len. Mach'an chʌ bʌ ch'ujbi la' bajñel cha'len ti la' bajñelil mi mach'an mi la' wajñel quic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jini mach bʌ ba'an mi bej ajñel quic'ot mi quejel i chojquel. Mi quejel i tyʌquin yubil. Che' bajche' mi' much'quintyel ti pejtyelel tyʌquin bʌ ba'ical bʌ i c'ʌb tyac cha'an mi pulel ti c'ajc. ");
INSERT INTO ctu76_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mi mux la' bej ajñel quic'ot mi mach'an mi ñajayel ti la' pusic'al jini j cʌntisa, c'ajtinla chʌ bʌ tyac jach la' wom mi quejel la' wʌq'uentyel. ");
INSERT INTO ctu76_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi tsictiyel i ñuclel c Tyat ti panchan che' mi la' cabʌl cha'len wen bʌ. Mi la' pʌse' cha'an yoque ajcʌnt'añetla c cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mic p'untyañetla che'ʌch bajche' c Tyat mi' p'untyañon. Bej ajñenla tic p'untyaya, che' jini. ");
INSERT INTO ctu76_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Che' mi la' jac' c mandar tyac mi quejel lac bej p'untyan lac bʌ. Che' je'el, mic jac'ben i mandar c Tyat ti panchan. Mi lojon c bej p'untyan lojon c bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Tic lu' subetla iliyi cha'an c'ajacña la' woj cha'an ti joñon yic'ot cha'an mi ts'ʌctiyel c'ajacña bʌ la' woj. ");
INSERT INTO ctu76_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jinic mandar chʌncol bʌ c subeyetla jiñʌch cha'an yom la' p'untyan la' bʌ che' bajche' mic p'untyañetla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mach'an más ñuc bʌ p'untyaya bajche' jini mu' bʌ i cha'len mu' bʌ i yʌc' i bʌ ti sajtyel cha'an ti caj mi' p'untyan jini uts bʌ yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jatyetla utsetla quic'ot mi ti la' cha'le chʌ bʌ tyac mic subeñetla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mach'an mic bej pejcañetla ti ajtoñelob jach como mach'an mi' ña'tyan ajtoñel jach bʌ chʌ bʌ mi quejel i cha'len i yum. Pero mic pejcañetla ti utsetla quic'otyon como ti pejtyelel tsa' bʌ i subeyon c Tyat ti panchan tic subetla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mach'an ti la' yajcʌyon. Pero joñon tic yajcʌyetla cha'an cabʌl wen bʌ mi la' cha'len. Yic'ot cha'an mi bej tsictiyel cabʌl wen bʌ mi la' cha'len. Jin cha'an mi la' c'ajtiben c Tyat cha'an mi quejel i yʌq'ueñetla chʌ bʌ jach mi la' c'ajtiben. ");
INSERT INTO ctu76_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jiñʌch mu' bʌ c xiq'uetla la' cha'len: cha'an la' p'untyan la' bʌ. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesús ti yʌlʌ: Che' mi' mich'q'ueletla jini año' bʌ ti mulawil, ña'tyanla cha'an ñaxan ti' mich'q'ueleyoñob. ");
INSERT INTO ctu76_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Mi i cha'añetla jini año' bʌ ti mulawil mi' p'untyañetla je'el bajche' mi' p'untyan i pi'ʌlob. Pero tic yajcʌyetla loq'uel ba'an i cha'año' bʌ mulawil. Jin cha'an jini i cha'año' bʌ mulawil mi' mich'q'ueletla. ");
INSERT INTO ctu76_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","C'ajtisanla jini tsa' bʌ c subeyetla: Ajtoñeletla mach'an más an la' ñuclel bajche'on la' yumon. Tsa'ix i tyʌc'lʌyoñob. Mi quejel i tyʌc'lañetla je'el. Jini tsa' bʌ i jac'bon c t'an mi quejel i jac'beñetla la' t'an je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero mi quejel i tyʌc'lañetla cha'an tij caj cha'an mach i cʌñʌ jini tsa' bʌ i chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Machic ti tyʌliyon cha'an c subeñob ma'añob i mul. Pero wale mach ch'ujbi i yʌle' ma'añob i mul. ");
INSERT INTO ctu76_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jini mu' bʌ i mich'q'uelon mi' mich'q'uel c Tyat ti panchan je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Machic ti yilʌyob che' ñac tic pʌsʌ ñuc tyac bʌ c p'ʌtyʌlel mach'an i mul. Pero wale tsa'ix i yilʌyob c p'ʌtyʌlel pero mi' mich'q'ueloñob yic'ot c Tyat ti panchan je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Chʌ'ʌch ti ujti cha'an mi' ts'ʌctisan jini Ts'ijbubil bʌ i T'an Dios ba' ts'ijbubil: Ti' mich'q'ueleyoñob che' ma'ix chʌ bʌ och. Che'ʌch wʌ ts'ijbubil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mi quejel c choc tyʌlel ya' bʌ loq'uem ba'an c Tyat ti panchan jini Ch'ujul bʌ c Ch'ujlel. Pero ya' bʌ mi tyʌlel mi quej i cotyañetla. Mi quejel i ñuc isʌbeñetla la' pusic'al. Mi quejel i pʌsbeñetla i sujmlel c T'an. Mi quejel i yʌc'on ti cʌjñel. ");
INSERT INTO ctu76_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jatyetla je'el mi la' wʌc'on ti cʌjñel como ti ajniyetla quic'ot c'ʌlʌ ti tyeche c toñel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Tic wʌ subeyetla tyac ili cha'an mach'an mi la' cʌy la' ch'ujbin che' mi quejel la' wocol. ");
INSERT INTO ctu76_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Mi quej la' chojquel loq'uel ti la' templo tyac. Jinic tyo tyal i yorojlel mi quej i lolon ña'tyan mi' cha'liben i toñel Dios che' mi' tsʌnsañetla. ");
INSERT INTO ctu76_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chʌ'ʌch mi quejl i tyʌc'lañetla como mach'an ti' cʌñʌ c Tyat ti panchan mi jinic ti' cʌñʌyoñob je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mic wʌ subeñetla ili tyac cha'an che' mi quejel la' ñusan wocol mi la' c'ajtisan jini tsa' bʌ c wʌ subetla. Che' ti yʌlʌ Jesús. Max tyo c subetla ti tyejchibal c toñel como wʌ' tyo añon la' wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero wale mi quejel c majlel ya' ba'an jini tsa' bʌ i chocoyon tyʌlel. Mach'an mi junticlec mi la' c'ajtibeñon baqui mic majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero wen ch'ʌjyemetla cha'an tic t'an tsa' bʌ c subetla. ");
INSERT INTO ctu76_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero melel c t'an. Más wen cha'añetla che' mic majlel. Como mi mach'an mic majlel mach tyal cha'an mi yajñel la' wic'ot jini Ch'ujul bʌ c Ch'ujlel mu' bʌ quej i yʌq'ueñetla la' ña'tyʌbal. Mi quej i ñuc isʌbeñetla la' pusic'al. Pero che' mic majlel mic choque' tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Che' mi tyʌlel Ch'ujul bʌ c Ch'ujlel mi quej i tsictisʌben i mul quixtyañujob. Mi quejel i tsictisʌbeñob bajche' yom i yajñel. Mi quejel i tsictisan cha'an Dios mi quej i cha'len melojel che' mi' melob ti jujuntiquilob. ");
INSERT INTO ctu76_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jini Ch'ujul bʌ c Ch'ujlel mi quej i tsictisan cha'an xmulilob como mach'an mi' ch'ujbiñoñob. ");
INSERT INTO ctu76_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mi quejel i yʌq'uen i ña'tyañob bajche' yom i yajñelob ti tyoj como mic majlel ba'an c Tyat ti panchan. Jatyetla mach'anix mi quej la' bej q'uelon. ");
INSERT INTO ctu76_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jini Ch'ujul bʌ c Ch'ujlel mi quej i yʌq'uen i ña'tyañob cha'an Dios mi' cha'len melojel como wʌ alʌlix cha'an mi quej i xot' i mul ti tyal tyo bʌ ora jini xiba mu' bʌ ti xic'ojel wʌ' ti mulawil. Yic'ot mi quej i xot' i mul jini año' bʌ ti' wenta xiba. ");
INSERT INTO ctu76_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","An tyo cabʌl chʌ bʌ com c subeñetla pero max tyo ch'ujbi la' lu' ch'ʌmben isujm wale. ");
INSERT INTO ctu76_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Che' mi tyʌlel Ch'ujul bʌ c Ch'ujlel mu' bʌ i pʌs'e' i sujmlel mi quejel i cʌntisañetla ti pejtyelel i sujmlel. Como mach'an mi' cha'len bajñel t'an. Jini jach mi yʌl tsa' bʌ subenti. Mi quejel i yʌq'ueñetla la' ch'ʌmben i sujmlel mu' tyo bʌ quej i yujtyel tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jini Ch'ujul bʌ c Ch'ujlel mi quejel i sub c ñuclel como mi quej i yʌq'ueñetla la' cʌñe' c ña'tyʌbal. ");
INSERT INTO ctu76_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ti pejtyelel i ña'tyʌbal c Tyat ti panchan c ña'tyʌbal je'el. Jin cha'an ti cʌlʌ ti pejtyʌlel lojon c ña'tyʌbal mi cʌq'uen i subeñetla jini Ch'ujul bʌ c Ch'ujlel cha'an la' ña'tyan. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jesús ti yʌlʌ: Ma'ix jal mi quej la' bej q'uelon. Pero ti wi'il tyo ts'itya' mi quej la' cha' q'uelon. Mi quejel c majlel ya' ba'an c Tyat ti panchan, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Che' jini, cha'tiquil uxtiquil ajcʌnt'añob i cha'an ti' subeyob i bʌ: ¿Chuqui i sujmlel chʌncol bʌ i yʌl? Mi' subeñonla cha'an ma'ix jal mi quej lac bej q'uele'. Pero ts'itya' wi'il mi quejel lac cha' q'uele'. Mi quej i majlel ya' ba'an i Tyat. ");
INSERT INTO ctu76_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Chʌ bʌ yom i yʌle' che' ma'ix jal? Mach cujila chʌ bʌ chʌncol i yʌle', che'ob. Che' ti cha' tyajayob ti t'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús yujil isujm cha'an yom i c'ajtibeñob i sujmlel. Jesús ti' subeyob: Tic subetla ma'ix jal mi quej la' bej q'uelon. Ti wi'il tyo ts'itya' mi quej la' cha' q'uelon. ¿Jim ba cha'an mi la' c'ajtiben la' bʌ i sujmlel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Melel mic subeñetla, mi quej la' cha'len uq'uel. Ch'ʌjyem mi quej la' wubin. Pero jini quixtyañujob mach bʌ ba'an mi' ch'ujbiñon tijicña mi quejel i yubiñob. Aunque ch'ʌjyem mi quej la' wubin pero ti wi'il cha' c'ajacña la' woj mi quej la' cha' ubin. ");
INSERT INTO ctu76_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Che' mu' ti bajq'uel x'ixic ch'ʌjyem mi yubin cha'an i yorojlel i wocol. Pero che' tsa'ix ch'ocʌ i yalobil ma'ix mi' bej pensalin i wocol como c'ajacña i yoj cha'an tsa'ix ch'ocʌ i yalobil. ");
INSERT INTO ctu76_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Chʌ'ʌch jatyetla je'el wale iliyi ch'ʌjyem mi la' wubin, pero mi quej c cha' q'ueletla. Che' jini, ñoj c'ajacña la' woj. Mach bʌ ba'an majch ch'ujbi i cha' chilbeñetla c'ajacña bʌ la' woj. ");
INSERT INTO ctu76_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti jim bʌ q'uin mach c'ʌñʌ la' c'ajtibeñon chʌ bʌ la' wom. Melel mic subeñetla, c Tyat ti panchan mi quej i yʌq'ueñetla ti pejtyel chʌ bʌ mi la' c'ajtin cha'an tsa'ix la' ch'ujbiyon. ");
INSERT INTO ctu76_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","C'ʌlʌ wale iliyi ma'ix chʌ bʌ ti la' c'ajtibe Dios cha'an ti la' ch'ujbiyon. C'ajtinla. Mi quej la' wʌq'uentyel cha'an ñoj c'ajacña la' woj mi la' wubin. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús ti yʌlʌ: Tic subetla ili tyac ti lajoñel. Pero tyal i yorojlel ma'ix mic bej subeñetla ti lajoñel tyac. Che' jini, mi quej c subeñetla ti wen tsiquil bʌ t'an bajche' an c Tyat ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti jim bʌ ora mi la' bajñel c'ajtiben c Tyat chʌ bʌ la' wom cha'an ti la' ch'ujbiyon. Mach ñaxan joñonic mic suben c Tyat cha'añetla. ");
INSERT INTO ctu76_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Como c Tyat mi' p'untyañetla. Mi' p'untyañetla como mi la' p'untyañon. Mi la' ch'ujbin cha'an ti tyʌliyon ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ti loq'uiyon tyʌlel ti' tyojlel c Tyat ti panchan. Ti tyʌliyon wʌ' ti mulawil. Pero wale mi quej c cha' cʌye' ili mulawil. Mux quej c cha' majlel ya' ba'an c Tyat, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Che' jini, ajcʌnt'añob i cha'an ti' subeyob: Wale wen tsiquil bʌ t'an chʌncol a subeñon lojon che' ma'ix ma' cha' subeñon lojon ti lajoñel tyac. ");
INSERT INTO ctu76_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Wale cujil lojon isujm lu' a wujil isujm. Mach c'ʌñʌ majch mi' ñaxan c'ajtibeñet como wʌ a wujil isujm i c'ajtibal. Jin cha'an cujil lojon isujm tyʌlemet ti Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús ti' jac'beyob: ¿Mu' ba la' ch'ujbin cha'an tyʌlemon ti Dios? ");
INSERT INTO ctu76_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wale i yorojlelix mi quej la' pujquel. Mi quej la' cha' sujtyel ti la' wotyot ti jujuntiquiletla. Mi quej la' bajñel cʌyon. Pero mach c bajñelic añon como wʌch an c Tyat quic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chʌ'ʌch mic wʌ subeñetla cha'an ñʌch'ʌl la' pusic'al cha'an tij caj. Wʌ' ti mulawil wersa mi la' ñusan wocol. Pero mach yom la' cha'len bʌq'uen como tsa'ix c ganar j contrajob wʌ' ti mulawil. Añon la' wic'ot, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Che' ñac ti ujti i yʌle' ili tyac Jesús ti' q'uele letsel ti panchan. Ti oración ti yʌlʌ: C Tyat, i yorojlelix wale che' mi quejel a tsictisan c ñuclel a walobilon cha'an je'el a walobilon mic pʌse' a ñuclel je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ti a wʌc'on tic wenta pejtyel quixtyañu cha'an mi cʌq'uen i cuxtyʌlel mach'ʌ yujil jilel pejtyel tsa' bʌ a wʌc'on. ");
INSERT INTO ctu76_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jiñʌch i cuxtyʌlel mach'ʌ yujil jilel che' mi' cʌñetyob ti ñoj melel bʌ Dioset jini cojach bʌ Dios yic'ot joñon Jesucristojon tsa' bʌ a choco tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Tic tsictisʌ a ñuclel wʌ' ti mulawil. Tsa'ix c ts'ʌctisʌ jini toñel tsa' bʌ a xic'on c cha'len. ");
INSERT INTO ctu76_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Wale c Tyat, pʌsʌ c ñuclel ti a tyojlel che' bajche' i tyʌlel an c ñuclel quic'otyet c'ʌlʌ che' ñac max tyo ba'an mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Tic tsictisʌbet ti i tyojlel jini tsa' bʌ a yajcʌ loq'uel ti i cha'año' bʌ mulawil cha'an a wʌq'ueñon tic wenta. A cha'añobʌch. Ti a wʌc'on tic wenta. Ti' ch'ujbibeyetyob a t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Wale yujilobix isujm ti pejtyelel tsa' bʌ c cha'le tyʌlem ti jatyet. ");
INSERT INTO ctu76_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Tsa'ix c subeyob pejtyelel a cʌntisa tsa' bʌ a subon. Ti' ch'ujbiyob. Yujilobix isujm melelʌch loq'uemon ti a tyojlel ti tyʌliyon ti mulawil. Ti' ch'ujbiyob cha'an ti a chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mij c'ajtibeñet i wenlel. Mach'an mij c'ajtibeñet cha'an mach'ʌ ba'an ti' ch'ujbiyetyob pero mij c'ajtibeñet cha'an tsa' bʌ a wʌc'on tic wenta como a cha'añobʌch. ");
INSERT INTO ctu76_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ti pejtyelelob lac cha'añobʌch. Mi' tsictisʌbeñoñob c ñuclel. ");
INSERT INTO ctu76_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ma' mi quejel j cʌytyʌl wʌ' ti mulawil. Pero jini lac cha'añob tsa' bʌ i ch'ujbiyonla wʌ' tyo mi cʌytyʌlob. Joñon mic majlel cha'an mi cajñel a wic'otyon. Ch'ujul bʌ c Tyat, cʌñʌtyañob ti a p'ʌtyʌlel jini tsa' bʌ a wʌc'on tic wenta cha'an ajnic ti junsujm jach bʌ i pensal bajche' jatyet quic'ot mi la cajñel ti junsujm lac pensal. ");
INSERT INTO ctu76_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Che' wʌ' añon ti mulawil yic'otyob tij cʌñʌtyʌyob ti a p'ʌtyʌlel tsa' bʌ a wʌc'on tic wenta. Tij cʌñʌtyʌyob. Mach'an ti' sʌtyʌ i bʌ mi junticlec. Jini jach tsa' bʌ i wʌ ña'tyʌnti mu' bʌ i sʌt i bʌ cha'an mi ts'ʌctiyel bajche' wʌ ts'ijbubil ti Ts'ijbubil bʌ a T'an. ");
INSERT INTO ctu76_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Wale mi quejel c cha' tyʌlel ya' ba'añet. Pero mij c'ajtibeñet ili tyac che' wʌ' tyo añon ti mulawil cha'an wen c'ajacña i yoj mi yajñelob che' bajche' c'ajacña coj. ");
INSERT INTO ctu76_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tsa'ix c subeyob a t'an pero jini i cha'año' bʌ mulawil ti' mich'q'ueleyob. Como mach i cha'añob mulawil che' bajche' mach i cha'añon mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mach'an mic subeñet cha'an a loc'sañob ti mulawil pero mic subeñet cha'an ma' cʌñʌtyan ti i p'ʌtyʌlel xiba. ");
INSERT INTO ctu76_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Chʌ'ʌch bajche' mach i cha'añon mulawil chʌ'ʌch je'el mach i cha'añob mulawil jini chʌncol bʌ i ch'ujbiñon. ");
INSERT INTO ctu76_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ñijcʌben i pusic'al cha'an ti melel bʌ a t'an cha'an mi yʌq'ueñetyob i bʌ cha'an ti a cha'an mi yajñelob. Melel a t'an. ");
INSERT INTO ctu76_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Che' bajche' ti a chocoyon tyʌlel wʌ' ti mulawil chʌ'ʌch je'el mic chocob majlel ya' ba'an jini max tyo bʌ ba'an mi' ch'ujbiñetyob. ");
INSERT INTO ctu76_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mi cʌq'ueñet c bʌ cha'an mic sajtyel cha'an ti caj jini chʌncol bʌ i ch'ujbiñoñob. Chʌ'ʌch je'el mi yʌq'ueñetyob i bʌ je'el ti pejtyelel i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pero mach jinic jach i bajñel i cha'an mij c'ajtibeñet i wenlel jini chʌncol bʌ i ch'ujbiñon wale iliyi, pero mij c'ajtibeñet je'el cha'an jini mu' tyo bʌ quejel i ch'ujbiñon che' mi yubiñob i t'an jini chʌncol bʌ i ch'ujbiñon wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mij c'ajtibeñet cha'an mi quejel i yajñel ti junsujm i pensal che' bajche' mi la cajñel ti junsujm. Jatyet añet ti joñon. Joñon añon ti jatyet. Che' bajche' mij c'ajtibeñet cha'an jini lac cha'año' bʌ mi yajñel ti junsujm i pensal cha'an ti laj caj cha'an jini mach'ʌ ba'an mi' ch'ujbin mi quejel i ña'tyan ti a chocoyon tyʌlel ti mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ti cʌq'ueyob i ñuclel che' bajche' ti a wʌc'on c ñuclel cha'an mi motin ajñel ti junsujm i pensal chʌ'ʌch bajche' joñon quic'otyet mi la cajñel ti junsujm lac pensal. ");
INSERT INTO ctu76_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Joñon, yic'ot jatyet yic'ot jini lac cha'año' bʌ junsujm jach lac pensal como añon ti jini mu' bʌ i ch'ujbiñon. Jatyet añet ti joñon. Ti cʌq'ueyob i ñuclel che' bajche' ti a wʌc'on c ñuclel cha'an jini año' bʌ ti mulawil mi quejl i ña'tyan ti a chocoyon tyʌlel cha'an je'el mi' ña'tyan lajal ma' p'untyañob lac cha'año' bʌ che' bajche' ma' p'untyañon. ");
INSERT INTO ctu76_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","C Tyat, tsa'ix a wʌc'on tic wenta tsa' bʌ i ch'ujbiyon. Com ya' añob ba' mi quej cajñel cha'an i yilan c ñuclel tsa' bʌ a wʌc'on. Como ti a p'untyʌyon. Ti a wʌc'on c ñuclel che' ñac max tyo mejl mulawil. ");
INSERT INTO ctu76_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tyoj bʌ c Tyat, i cha'an jach bʌ mulawil mach'an mi' cʌñetyob. Pero joñon bʌ yi j cʌñʌyetyʌch. Jini mu' bʌ i ch'ujbiñon yujilobix isujm ti a chocoyon tyʌlel. ");
INSERT INTO ctu76_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tsa'ix c tsictisʌbeyob bajche' añet. Mu' tyo c bej tsictisʌbeñob bajche' añet cha'an i ña'tyan bajche' ma' p'untyañon. Yic'ot mi cajñel ti' pusic'alob. Che' jini, mi quej i p'untyañob i bʌ. Che' ti' cha'le oración Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Che' ñac ti ujti i yʌle' ili t'an tyac, Jesús yic'ot ajcʌnt'añob i cha'an ti loq'uiyob majlel ya'i. Ti' c'axiyob ti junxej pa' Cedrón bʌ i c'aba'. Ya'an jumpejt pʌc'ʌbʌl. Ya' ti ochiyob. ");
INSERT INTO ctu76_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, jini mu' bʌ yʌc' Jesús ti' c'ʌb i contrajob ti' cʌñʌ jini pʌc'ʌbʌl je'el. Como ya'i cabʌl ti' much'quiyob i bʌ Jesús yic'ot ajcʌnt'añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ya' ti c'oti Judas. Ti' pʌyʌ c'otyel junmujch' soldadojob yic'ot cha'tiquil uxtiquil policía am bʌ ye'tyel i cʌñʌtyan templo i cha'ano' bʌ israelob tsa' bʌ xijq'ui majlel ti ñuc bʌ curajob i cha'an bʌ israelob yic'ot fariseojob. Ti' ch'ʌmʌyob majlel i machit tyac yic'ot c'ajc yic'ot ts'ʌbʌl bʌ tyaj. ");
INSERT INTO ctu76_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero Jesús ti' wʌ ña'tyʌ ti pejtyelel chʌ bʌ tyac mi quejel i ñusan. Jin cha'an ti majli i tyajob tyʌlel. Ti' c'ajtibeyob: ¿Majchqui chʌncol la' sajcan? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ti' jac'ʌyob: Jesús, ch'oyol bʌ ti Nazaret, che'ob. Jesús ti yʌlʌ: Joñoñʌch, che'en. Ya'an yic'otyob Judas mu' bʌ i yʌc' ti' c'ʌb i contrajob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Che' ñac Jesús ti' subeyob: Joñoñʌch, che'en, ti ch'a' yajliyob ti lum. ");
INSERT INTO ctu76_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Che' jini Jesús ti' cha' c'ajtibeyob: ¿Majchqui chʌncol la' sajcan? che'en. Ti yʌlʌyob: Jesús ch'oyol bʌ ti Nazaret, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Che' jini, Jesús ti' subeyob: Tsa'ix c subetla cha'an joñoñʌch. Mi chʌncol la' sajcañon, la' sujticob jini ajcʌnt'añob c cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chʌ'ʌch ti ujti cha'an mi ts'ʌctiyel tsa' bʌ wʌ alʌ Jesús: Tsa' bʌ yʌc'on c Tyat ti panchan, mach'an tic sʌtyʌ, mi junticlec. Che' ti wʌ alʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Che' jini, Simón Pedro ti' bots'o i machit. Ti' tsepbe loq'uel i ñoj bʌ i chiquin juntiquil ajtroñel i cha'an ñoj ñuc bʌ cura. Malco i c'aba' jini ajtroñel. ");
INSERT INTO ctu76_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero Jesús ti' sube Pedro: Cha' otsan a machit ti yotyot. Bajche' ma' wʌl: ¿Mach ba ba'an an cha'an c ñusan wocol mu' bʌ i yʌq'ueñon c ñusan c Tyat ma' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Che' jini, jini soldadojob yic'ot i capitán soldadojob yic'ot policíajob tsa' bʌ xijq'uiyob tyʌlel ti' chucuyob Jesús. Ti' cʌchʌyob. ");
INSERT INTO ctu76_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Che' jini, ti' pʌyʌyob majlel Jesús ti yotyot Anás, jiñʌch i ñij'atyat Caifás. Ti jim bʌ jabil an i ye'tyel Caifás ti ñoj ñuc bʌ cura. ");
INSERT INTO ctu76_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jiñʌch jini Caifás tsa' bʌ wʌ subeyob jini israelob año' bʌ ye'tyel: Más wen muq'uic i sajtyel juntiquil cha'an ti laj q'uexol ti lac pejtyelel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Juan yic'ot Simón Pedro ti' tsʌcle majlel Jesús. Jini ñoj ñuc bʌ cura ti' cʌñʌ Juan, jin cha'an ti yʌc'ʌ i majlel c'ʌlʌ ya' ti corredor ba' ti pʌjyi majlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedro ti cʌyle ya' ti lʌc'ʌl ti' otyot. Ya' cha' tsajni Juan. Ti' pejcʌ jini xc'alʌl tsa' bʌ cʌñʌtyʌ i ti' otyot. Che' jini, ti yʌc'ʌ ti ochel Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jini xc'alʌl ti' sube Pedro: Jixcu jatyet, ¿mach ba ajcʌnt'añet i cha'an jini winic mu' bʌ i pejcʌntyel ti Jesús je'el? che'en. Pedro ti' jac'ʌ: Mach'an. Mach joñonic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jini ajtroñelob yic'ot policíajob ti i ñutsuyob c'ajc como an tsʌñal. Ya' wa'alob ti q'uix. Ya' wa'al Pedro yic'otyob. Mu' ti q'uix je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jini ñoj ñuc bʌ cura ti queji i c'ajtiben Jesús majchqui jini ajcʌnt'añob i cha'an yic'ot chʌ bʌ ti cʌntisa muc'. ");
INSERT INTO ctu76_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús ti' sube: Jini tsa' bʌ cʌlʌ, jamʌl ti cʌlʌ ba' ch'ujbi i yubin ti pejtyelelob. Tic bele' cha'le cʌntisʌ ti ba'ical bʌ saj templo tyac ba' mi' much'quiñob i bʌ quixtyañujob yic'ot je'el ti ñuc bʌ templo ba' mi lu' much'quiñob i bʌ pejtyelel israelob. Mach'an chʌ bʌ yes tic saj mucul alʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Chucoch ma' c'ajtibeñon chʌ bʌ yes tij cʌntisʌyob? Yom a c'ajtibeñob tsa' bʌ yubiyob. La' i subeñetyob chʌ bʌ ti cʌlʌ. Yujilob isujm. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Che' ñac Jesús ti ujti i yʌle' ili t'an, juntiquil policía i cha'an bʌ templo ya' wa'al ti' t'ejl ti' jats'ʌ Jesús ti' choj. ¿Chʌ'ʌch ba yom a jac'ben i t'an jini ñoj ñuc bʌ cura ma' lolon ubin? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús ti' sube jini policía: Mi an mach'ʌ wen ti cʌlʌ, subeñon chʌ bʌ mach wen ti cʌlʌ. Pero mi weñʌch ti cʌlʌ, ¿chucoch ti a jats'ʌyon? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Che' jini, Anás ti' choco majlel Jesús ya' ba'an Caifás jini ñoj ñuc bʌ cura. Cʌchʌl ti majli Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ya' tyo wa'al Pedro ba'an c'ajc. Mu' tyo ti q'uix. Jini ya' bʌ wa'alob yic'ot ti yʌlʌyob: ¿Mach ba jatyet je'el ajcʌnt'an i cha'an jini winic mu' bʌ i pejcʌntyel ti Jesús? che'ob. Pedro ti' jac'ʌ: Mach'an. Mach joñoñic, che' Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Che' jini, juntiquil ajtoñel i cha'an ñoj ñuc bʌ cura, i pi'ʌl jini tsa' bʌ tsejpi loq'uel i chiquin ti Pedro ti yʌlʌ: ¿Mach'a jatyet tsa' bʌ quilʌyet ya' ti pʌc'ʌbʌl a wic'ot Jesús je'el? ");
INSERT INTO ctu76_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro ti cha' alʌ cha'an mach che'iqui. Ti jin jach bʌ ora ti' wa' cha'le uq'uel tyat mut. ");
INSERT INTO ctu76_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Che' yomox sʌc' an ti' pʌyʌyob loq'uel Jesús ya' ti yotyot Caifás. Ti' pʌyʌyob majlel ti yotyot ñuc bʌ yumʌl Pilato bʌ i c'aba'. Pero jini israelob mach'an ti ochiyob ti mal ba' ti pʌjyi ochel Jesús. Como tiq'uil cha'an bajche' mi' bajñel tyumbiñob i bʌ cha'an mi yochel ba'an jini mach'ʌ israelob che' ti yorojlel i q'uinilel pascua. Tiq'uil, che' jini, i c'uxob jini mu' bʌ i chajpʌntyel cha'an i q'uinilel pascua. ");
INSERT INTO ctu76_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jin cha'an Pilato ti loq'ui i pejcañob. Ti' subeyob: ¿Chuquiyes i mul jini winic mi la' wʌl? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ti' jac'ʌyob: Machic ba'an i mul jini winic mach'an ti lojon cʌc'ʌ ti a c'ʌb, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Che' jini, Pilato ti' subeyob: Pʌyʌla majlel. Melela che' bajche' ts'ijbubil ti la' mandar la' bajñel, che'en. Pero jini israelob ti yʌlʌyob: Tiq'uil cha'an joñon lojon israelon bʌ lojon mi lojon cʌc' ti sajtyel quixtyañu, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Chʌ'ʌch ti ts'ʌctiyi tsa' bʌ wʌ alʌ Jesús bajche' mi quejel i sajtyel. ");
INSERT INTO ctu76_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato ti cha' ochi ti mal yotyot ba' mi ujtyel melojel. Ti' pʌyʌ tyʌlel Jesús. Ti' c'ajtibe: ¿Jatyet ba ñuc bʌ Yumʌlet i cha'an israelob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús ti yʌlʌ: ¿Chʌncol a bajñel al tyʌlem bʌ ti a pusic'al o am ba majch ti' subeyet cha'an chʌ'ʌchi? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato ti yʌlʌ: ¿Joñon israelon ba ma' lolon al? Jiñʌch a pi'ʌlob israelo' bʌ yic'ot ñuc bʌ curajob tsa' bʌ yʌc'ʌyetyob tij c'ʌb. ¿Chuquiyes ti a cha'le ti' contrajob? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús ti' sube Pilato: Mach wʌ'ic ti mulawil mic cha'len que'tyel. Mi wʌ'iqui, ti' cha'leyob wersa ajcʌnt'añob c cha'an i wentyʌlel cha'an machic ajq'uicon ti' c'ʌb israelob año' bʌ i ye'tyel. Pero mach wʌ'ic mic cha'len yumʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Che' jini, Pilato ti yʌlʌ: ¿Melel ba yumʌlet, che' jini? Jesús ti yʌlʌ: Melelʌch bajche' ti a wʌlʌ. Yumʌlon. Ti ch'ocʌyon cha'an mic tyʌlel wʌ' ti mulawil cha'an mic subeñob quixtyañujob melel bʌ t'an mu' bʌ yʌc' ti cʌjñel i sujmlel Dios. Jini mu' bʌ i jac' jini melel bʌ t'an mi' ñʌch'tyan chʌ bʌ mic subeñob. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato ti yʌlʌ: ¿Chuquiyes che' melel bʌ t'an? che'en. Che' ñac ujtye i yʌl ili t'an, Pilato ti cha' loq'ui i pejcan israelob. Ti' subeyob: Mach'an mic saj tyajben i mul ili winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","I tyʌlel che' ti yorojlel pascua bʌ q'uin mi cʌc' ti colel juntiquil ajcʌchol, majchical jach mi la' c'ajtibeñon. ¿La' wom ba la mi cojlel jini ñuc bʌ Yumʌl la' cha'an israelet bʌ la? Che' ti yʌlʌ Pilato. ");
INSERT INTO ctu76_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Che' jini ti lu' cha' quejiyob ti c'am bʌ t'an. Mach jiniqui. La' cojlic Barrabás, che'ob. Ajxujch' jini Barrabás. ");
INSERT INTO ctu76_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Che' jini Pilato ti' xiq'ui ti jats'ol Jesús ti pʌchij am bʌ tsucul tyaq'uin yic'ot. ");
INSERT INTO ctu76_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soldadojob ti yʌq'ueyob corona ti' jol jalʌl bʌ ti ch'ix. Ti' xojbeyob ic'puc'an bʌ i pislel. ");
INSERT INTO ctu76_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Che' jini, ti' lʌc'ʌyob Jesús. Ti' wajleyob. Ti yʌlʌyob: Ñoj ñuquet bʌ Yumʌl i cha'an israelob, che'ob. Che' jini ti' jats'ʌyob ti' c'ʌb. ");
INSERT INTO ctu76_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Che' jini Pilato ti cha' loq'ui i pejcan israelob. Ti' subeyob: Q'uelela. Mic pʌy tyʌlel Jesús wʌ' ba' añetla cha'an mi la' wen ña'tyan mach'an tic saj tyajbe i mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Che' jini ti loq'ui tyʌlel Jesús. Xojol i cha'an corona ti' jol jalʌl bʌ ti ch'ix. Xojol i cha'an ic'puc'an bʌ i pislel. Pilato ti' subeyob: Umba'an jini winic, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Che' ñac jini ñuc bʌ curajob yic'ot policíajob ti' q'ueleyob Jesús ti quejiyob ti c'am bʌ t'an. Ti yʌlʌyob: La' tsʌnsʌntic ti cruz, la' tsʌnsʌntic ti cruz, che'ob. Pilato ti' subeyob: Pʌyʌla majlel jatyetla. Tsʌnsanla ti cruz jatyetla. Como joñon mach'an mic saj tyajben i mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero jini israelob ti yʌlʌyob: Añʌch lojon c mandar ba' mi yʌl wersa yom tsʌnsʌntic como ti' cuyu i bʌ ti i Yalobil Dios, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Che' ñac ti yubi Pilato ili t'an, más ti' bʌc'ñʌ i yʌc' ti tsʌnsʌntyel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Che' jini, Pilato ti cha' ochi ti mal ba' mi' cha'len melojel. Ti' c'ajtibe Jesús: ¿Baqui ch'oyolet? che'en. Pero Jesús ch'uj ñʌch'ʌl. Ma' chʌ bʌ ti saj alʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilato ti' sube: ¿Mach'a ba'an mi quejel a jac'beñon c t'an? ¿Mach ba a wujil añʌch c p'ʌtyʌlel cha'an cʌq'uet ti sajtyel ti cruz yic'ot añʌch c p'ʌtyʌlel je'el cha'an cʌq'uet ti cojlel? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús ti yʌlʌ: Machic Dios ti yʌq'ueyet a p'ʌtyʌlel mach'an chʌ bʌ ch'ujbi a saj tyumbeñon. Jin cha'an más on i mul jini año' bʌ i ye'tyel cha'an israelob tsa' bʌ yʌc'ʌyon ti a c'ʌb. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ti jin jach bʌ ora Pilato ti queji i wen sajcan bajche' ch'ujbi i yʌc' ti cojlel Jesús. Pero israelob ti queji i yʌlob ti c'am bʌ t'an: Mi ti a wʌc'ʌ ti cojlel jini winic, mach'an mi quejel a wajñel ti uts yic'ot ñoj ñuc bʌ yumʌl. Como majchical jach mi sub i bʌ ti ñuc bʌ yumʌl mi' pʌs i bʌ ti' contra ñoj ñuc bʌ yumʌl, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Che' ñac ti yubi Pilato ili t'an ti majli ba' mi buchtyʌl che' mi' cha'len melojel. Ya' ba' buchul, ti t'an hebreojob mi pejcʌntyel ti Gabata. Ti lac t'an yom i yʌl ajnibʌl pech melel bʌ ti tyun tyac. Ti' xiq'ui tyʌlel Jesús jini Pilato. ");
INSERT INTO ctu76_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Xinq'uinilix. An tyo jump'ej q'uin mi quejel i q'uinilel pascua. Che' jini Pilato ti' sube israelob. Lax an ñuc bʌ Yumʌl la' cha'an, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ti c'am bʌ t'an ti yʌlʌyob: La' sajtic, la' sajtic. La' tsʌnsʌntic ti cruz, che'ob. Pilato ti' subeyob: ¿Yom ba cʌc' ti sajtyel ti cruz ñuc bʌ Yumʌl la' cha'an mi la' wʌl? che'en. Pero jini ñuc bʌ curajob ti yʌlʌyob: Mach'an yambʌ ñuc bʌ yumʌl lojon c cha'an. Jin jach César, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Che' jini, Pilato ti yʌc'ʌ Jesús ti c'ʌb cha'an i tsʌnsañob ti cruz. Ti' pʌyʌyob majlel. ");
INSERT INTO ctu76_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ti loq'ui majlel Jesús q'uechel majlel i cruzil ti bujtyʌl La Calavera bʌ i c'aba'. Ti i t'an hebreojob mi yʌl Gólgota. An i sujmlel i c'aba' mi yʌle' ti lac t'an che' yilal bajche' bʌquel jolʌl. Q'uechel i cha'an i cruzil ti majli. ");
INSERT INTO ctu76_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ya' ti' joc'chocoyob ti cruz Jesús yic'ot yambʌ cha'tiquil winic, juntiquil ti jujunwejl. Jesús an ti xinil. ");
INSERT INTO ctu76_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato ti' xiq'ui ti ts'ijbuntyel t'an ti' chañelel i jol Jesús ya' ti cruz. Mi yʌl ili t'an: Jesús ch'oyol bʌ ti Nazaret, ñuc bʌ Yumʌl i cha'an israelob. Chʌ'ʌch ts'ijbubil ya' ti chañelel i jol. ");
INSERT INTO ctu76_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cabʌl israelob ti' q'ueleyob chʌ bʌ ts'ijbubil como lʌc'ʌl Jerusalén ba' ti' joc'chocoyob ti cruz yic'ot ts'ijbubil t'an ti uxchajp t'an tyac, ti' t'an hebreojob yic'ot ti griego yic'ot ti latín. ");
INSERT INTO ctu76_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jin cha'an ñuc bʌ curajob i cha'an bʌ israelob ti majliyob i suben Pilato: Mach a ts'ijbun: Ñuc bʌ Yumʌl i cha'an israelob. Che' yom a ts'ijbun: Ti' subu i bʌ ti ñuc bʌ Yumʌl i cha'an israelob, che'et, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero Pilato ti' subeyob: Jini tsa'ix bʌ c ts'ijbu, chʌ'ʌch mi cʌytyʌl, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Che' ñac ti ujti i joc'chocon Jesús ti cruz jini soldadojob ti' t'oxoyob i pislel. Ti chʌnticlelob junlajal ti' tyajayob. Che' jini, ti' q'ueleyob pʌl bʌ i bujc mach bʌ ba'an ts'isil. Joy jalʌl jach ti pejtyelel. ");
INSERT INTO ctu76_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Che' jini ti' subeyob i bʌ: Mach lac tsil. Más i c'ʌjnibal mi lac cha'len yajcaya cha'an mi laj q'uel majchqui mi' ch'ʌm, che'ob. Chʌ'ʌch ti ts'ʌctiyi Ts'ijbubil bʌ i T'an Dios ba' mi yʌl: Ti' pucuyob i bʌ c pislel cha'an ti yajcaya. Che' ts'ijbubil. Chʌ'ʌch ti' cha'le soldadojob. ");
INSERT INTO ctu76_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ya' ti lʌc'ʌlel i cruzil Jesús ya'an i ña' yic'ot i yijts'in i ña', yic'ot María i yijñam Cleofas yic'ot María ch'oyol bʌ ti Magdala. ");
INSERT INTO ctu76_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús ti' q'uele i ña' yic'ot jini ajcʌnt'an mu' bʌ i wen p'untyʌntyel ya' wa'al ti i t'ejl i ña'. Che' jini Jesús ti' sube i ña': X'ixic, jini ya' bʌ wa'al ti a t'ejl la' ajnic che' bajche' a walobil, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Che' jini ti' sube jini juntiquil ajcʌnt'an i cha'an: Cʌñʌtyan c ña' che' bajche' mi a ña', che'en. Ti jin jach bʌ q'uin ti' pʌyʌ ochel i ña' Jesús ti yotyot jini ajcʌnt'an. ");
INSERT INTO ctu76_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Che' ti ujti i yʌle' bajche' jini, Jesús ti' ña'tyʌ tsa'ix ts'ʌctiyi pejtyelel chʌ bʌ yom tyac. Cha'an mi ts'ʌctiyel bajche' wʌ ts'ijbubil ti' t'an Dios, Jesús ti yʌlʌ: Tyʌquin c ti', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ya'an jump'ej uc'un but'ul ti paj bʌ vino. Che' jini juntiquil ti' ts'aja chʌyo' ja' ti vino. Ti' cʌchʌ ti i c'ʌb tye' hisopo bʌ i c'aba'. Ti letsʌ ti ti' Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesús ti' ts'u'u jini paj bʌ vino. Che' jini ti yʌlʌ: Tsa'ix lu' ts'ʌctiyi tsa' bʌ tyʌliyon c cha'len, che'en. Ti tinle. Ti sajti. ");
INSERT INTO ctu76_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ijc'ʌl tyo i q'uinilel pascua che' ñac ti sajti Jesús. Jini pascua ñoj ñuc bʌ i q'uinilel c'aj oj i cha'an israelob. Mach yomob che' ya' tyo añob ti cruz jini uxtiquil che' ti q'uin. Jin cha'an ti' c'ajtibeyob Pilato cha'an i xic' soldadojob i xulben i tseñec' ti yuxticlelob cha'an sajtic ti más ora jach yic'ot cha'an mi' ch'ʌmob majlel ch'ujlelʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Che' jini, soldadojob ti' xulbeyob i tseñec' jini winic am bʌ ti ñaxan bʌ cruz yic'ot je'el jini am bʌ ti junwejl ba'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero che' ñac ti c'otiyob ya' ba'an Jesús ti yilʌyob che' sajtyemix. Jin cha'an mach'an ti' xulbeyob i tseñec'. ");
INSERT INTO ctu76_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero aunque sajtyemix Jesús, juntiquil soldado ti' jeq'ue ti yebal i ch'i'lat Jesús ti lanza. Ti wa' loq'ui i ch'ich'el yic'ot ja'. ");
INSERT INTO ctu76_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Joñon chʌncol bʌ c cha' sub jini tsa' bʌ c yoque ilʌ. Melelʌch c t'an. Cujil isujm ñoj melel bʌ t'an chʌncol bʌ c subeñetla. Chʌncol c subeñetla cha'an la' ch'ujbin je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Chʌ'ʌch ti ujti tyac cha'an mi ts'ʌctiyel Ts'ijbubil bʌ i T'an Dios ba' mi yʌl: Mach'an mi quejel i xulbeñob mi junts'ijtic i bʌquel. Che' wʌ ts'ijbubil. ");
INSERT INTO ctu76_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","An yambʌ t'an ti Ts'ijbubil bʌ i T'an Dios je'el ba' mi yʌl: Mi quejel i cha' q'uelob jini tsa' bʌ i jeq'ueyob. Che' wʌ ts'ijbubil ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Che' ñac sajtyemix Jesús, jini José ch'oyol bʌ ti Arimatea ti majli ba'an Pilato cha'an i c'ajtiben loq'uel i bʌc'tyal Jesús cha'an i ch'ujñan. Pilato ti yʌc'ʌ i t'an. Che' jini José ti majli i ch'ʌm i bʌc'tyal Jesús. Jini José jiñʌch juntiquil tsa' bʌ i tsʌcle Jesús je'el pero ti mucul jach cha'an ti caj i bʌc'ñan i pi'ʌlob israelo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti c'oti Nicodemo je'el ya' ba' ti sajti Jesús. Jiñʌch jini tsa' bʌ ñaxan c'oti i pejcan Jesús ti ac'bʌlel. Ti' ch'ʌmʌ tyʌlel che' bajche' treinta kilos chʌbʌcña bʌ pimel tyac mirra bʌ i c'aba'. Xʌc'tyubil yic'ot yambʌ pimel áloes bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José yic'ot Nicodemo ti' ju'sʌbe i bʌc'tyal Jesús. Ti' bʌc'ʌyob ti bʌjq'uil xʌc'tyʌbilix yic'ot chʌbʌcña bʌ pimel tyac. I tyʌlel mi' cha'leñob israelob cha'an i chajpañob ch'ujlelʌl cha'an i ch'ujñan. ");
INSERT INTO ctu76_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ya' ba' ti' tsʌnsʌyob Jesús ti cruz ya'an jumpejt pʌc'ʌbʌl. Ya' ti pʌc'ʌbʌl ya'an jump'ej tsiji' bʌ i muconibʌl piquil bʌ ti mal colem tyun. Max tyo ba'an majch ti ch'ujñʌnti ya'i. ");
INSERT INTO ctu76_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Quejel tyo muc' i q'uinilel c'aj oj cha'an israelob. Jin cha'an José yic'ot Nicodemo ti' ch'ujñʌ i bʌc'tyal Jesús ya' ti mal muconibʌl como lʌc'ʌl an. ");
INSERT INTO ctu76_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Che' ic' tyo ti ñaxan bʌ q'uin ti semana María ch'oyol bʌ ti Magdala ti majli ti muconibʌl. Ti yilʌ loc'sʌbilix jini tyun i mʌjquil i ti' muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Che' jini ti majli ti ajñel ba'an Simón Pedro yic'ot yambʌ ajcʌnt'an i cha'an Jesús mu' bʌ i wen p'untyʌntyel ti Jesús. María ti' subeyob: Tsa'ix i ch'ʌmʌyob majlel i bʌc'tyal Jesús lac Yum ya' ti muconibʌl. Mach cujila baqui ti yʌc'ʌyob. Che' ti yʌlʌ María. ");
INSERT INTO ctu76_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Che' jini Pedro yic'ot yambʌ ajcʌnt'an i cha'an Jesús ti loq'uiyob majlel. Ti majliyob ti muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jini cha'tiquilob ti majliyob ti motin ajñel pero jini yambʌ más ajñel ti majli. Ñaxan ti c'oti ya' ti muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ti cotle i yojch'on ti malil. Ti yilʌ ya'an i bʌjq'uil Jesús pero mach'an ti ochi ti mal. ");
INSERT INTO ctu76_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ti jumuc'lel ti c'oti Simón Pedro. Ti ochi ti mali muconibʌl. Ti yilʌbe i bʌjq'uil Jesús je'el ya' ti' cʌyʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ti yila ya'an i mosil i jol Jesús. Bʌlʌl. Parte an. Pʌquilʌbil. ");
INSERT INTO ctu76_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Che' jini ti ochi je'el jini yambʌ ajcʌnt'an tsa' bʌ ñaxan c'oti ti muconibʌl. Ti yilʌbe i bʌjq'uil. Ti' ch'ujbi cha'an tsa'ix tyejchi loq'uel Jesús ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Como max tyo i ch'ʌm'eyob isujm jini Ts'ijbubil bʌ i T'an Dios cha'an mi quejel i tyejchel loq'uel Jesús ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Che' jini, ti sujtiyob ti yotyot jini cha'tiquil ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero María ti cʌyle ya' ti pat muconibʌl. Che' chʌncol ti uq'uel ti cotle i q'uele' i mal muconibʌl. ");
INSERT INTO ctu76_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","María ti yilʌ cha'tiquil ajtoñel i cha'an Dios ch'oyol bʌ ti panchan. Xojol i cha'an sʌsʌc bʌ i pislel. Buchulob ya' ba' ti' sʌts'choconti Jesús. Juntiquil an ti' tyojel i jol. Yambʌ juntiquil an ti' tyojel ba'an i yoc. ");
INSERT INTO ctu76_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jini ajtroñelob i cha'an Dios ch'oyolo' bʌ ti panchan ti' c'ajtibe María: ¿Chucoch muq'uet ti uq'uel? che'ob. María ti' jac'ʌ: ¿Chucoch ti la' pʌyʌ majlel jini c Yum? Mach cujil isujm baqui ti la' wʌc'ʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ujtyel jach tyo i yʌlbal ti' sutqui i bʌ. Ti' q'uele ya'an Jesús. Pero mach'an ti' ña'tyʌ mi Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Che' jini Jesús ti' sube: ¿Chucoch muq'uet ti uq'uel? ¿Majchqui ma' sʌclan? che'en. María ti' lolon pensali jiñʌch ajcʌñʌtya pʌc'ʌbʌl. Ti' sube: Mi jatyet ti a ch'ʌmʌ majlel i bʌc'tyal, subeñon baqui ti a wʌc'ʌ cha'an mic ch'ʌme' majlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Che' jini Jesús ti' sube: María, che'en. Ti' sutqui i bʌ i suben ti hebreo t'an: Raboni, che'en. Yom i yʌle' Maestro. ");
INSERT INTO ctu76_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús ti' sube: Mach yom a tyʌlon como max tyo letson ya' ba'an c Tyat, pero suben quermañujob cha'an mi quej c letsel ya' ba'an c Tyat, la' Tyat je'el, c Dios, la' Dios je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Che' jini María ch'oyol bʌ ti Magdala ti majli i suben ajcʌnt'añob i cha'an Jesús cha'an tsa'ix i yilʌ lac Yum yic'ot ti' subeyob tsa' bʌ subenti je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ti jin jach bʌ q'uin ti ñaxan bʌ q'uin ti semana much'quibilob ajcʌnt'añob i cha'an Jesús ti ic'an. Ñup'ul i ti' otyot tyac cha'an i bʌc'ñan israelob año' bʌ i ye'tyel. Ti ochi Jesús ya' ti xinil ba'añob. Ti yʌq'ueyob saludo. Ti yʌlʌ: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Che' ñac Jesús ti ujti i yʌle' jini, ti' pʌs'eyob i c'ʌb yic'ot i ch'i'lat. C'ajacña i yoj ti yubiyob ajcʌnt'añob i cha'an che' ñac ti yilʌyob cha'an lac yumʌch. ");
INSERT INTO ctu76_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesús ti' cha' subeyob: La' ñʌch'lec la' pusic'al. Como c Tyat ti panchan ti' chocoyon tyʌlel. Chʌ'ʌch mic choquetla majlel je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Che' jini, ti' wujtyʌyob. Ti' subeyob: Ch'ʌmʌla Ch'ujul bʌ c Ch'ujlel, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jesús ti' subeyob: Che' mi la' ñusʌben i mul juntiquil quixtyañu ñusʌbilix i mul. Mi mach'an mi la' ñusʌben i mul an tyo ti' mul, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero Tomás, jiñʌch juntiquil i docejlel ajcʌnt'añob i cha'an Jesús mu' bʌ i pejcʌntyel ti Lut mach'an ya'an che' ñac ti c'oti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ti wi'il yambʌ ajcʌnt'añob i cha'an Jesús ti' subeyob Tomás: Ti lojon quilʌ lac Yum, che'ob. Pero Tomás ti' subeyob: Mi mach'an mi quilʌben i lojweñal ti lawux am bʌ ti' c'ʌb, mi mach'an mi cotsan c yal c'ʌb ti lojweñal ti' ch'i'lat mach mic ch'ujbin mi tsa'ix tyejchi loq'uel ba'an sajtyemo' bʌ, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Che' ti ñumi ocho q'uin ti cha' much'quiyob i bʌ ajcʌnt'añob i cha'an Jesús. Jim bʌ ora ya'an Tomás je'el. Che' jini, aunque ñup'ul i ti' tyac otyot ti ochi Jesús. Ti wa'le ti xiñilob. Ti yʌq'ueyob saludo. Ti' subeyob: La' ñʌch'lec la' pusic'al, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Che' jini, ti' sube Tomás: Otsan a yal c'ʌb tij c'ʌb ba' lojwem. Q'uele j c'ʌb. Choco tyʌlel a c'ʌb. Otsan wʌ' tic ch'i'lat. Mach yom bej cha'chajb a pusic'al. Ch'ujbiñon joñʌñʌch. Che' ti subenti Tomás. ");
INSERT INTO ctu76_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Che' jini, Tomás ti' jac'ʌ: C Yum, c Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús ti' sube: Tomás, wale ma' ch'ujbiñon cha'an ti a wilʌyon. Tijicñayob jini mu' bʌ i ch'ujbiñoñob che' max tyo ti yilʌyon. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tsa' tyo i pʌsʌ cabʌl yan tyac bʌ ñuc tyac bʌ i p'ʌtyʌlel Jesús ti' tyojlel ajcʌnt'añob i cha'an mach'ʌ ba'an ts'ijbubil ti ili jun. ");
INSERT INTO ctu76_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ti ts'ijbunti tyac ili cha'an la' ch'ujbin cha'an jiñʌch yajcʌbil bʌ i cha'an Dios jini Jesús yic'ot cha'an i Yalobilʌch Dios. Cha'an che' mi la' ch'ujbin Jesús añix la' cuxtyʌlel mu' bʌ i yʌq'ueñonla. ");
INSERT INTO ctu76_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ti ñumi cha'p'ej uxp'ejl q'uin. Che' jini, Jesús ti cha' tsictiyi ti' tyojlel ajcʌnt'añob i cha'an ya' ti' ti' jini colem joyol bʌ ja' Tiberias bʌ i c'aba'. Chʌ'ʌch ti ujti bajche' iliyi: ");
INSERT INTO ctu76_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ya' motin añob Simón Pedro yic'ot Tomás mu' bʌ i pejcʌntyel ti Lut yic'ot Natanael ch'oyol bʌ ti Caná ya' ti Galilea yic'ot i yalobilob Zebedeo yic'ot yambʌ cha'tiquil ajcʌnt'añob i cha'an Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro ti' subeyob: Mi quejel c majlel ti chuc chʌy, che'en. I pi'ʌlob ti' jac'ʌyob: Much lojon c majlel je'el, che'ob. Ti majliyob. Ti ochiyob ti jump'ej jucub. Ya' ti' ñusʌyob jump'ej ac'bʌlel ti jucub. Pero mach'an ti' saj chucuyob chʌy. ");
INSERT INTO ctu76_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Che' ñac yomox sʌc'an ti yilʌyob ya' wa'al Jesús ya' ti' ti' colem joyol bʌ ja'. Pero ajcʌnt'añob i cha'an mach'an ti' ña'tyʌyob mi jiñʌch Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Che' jini Jesús ti' subeyob: Pi'ʌlob, ¿mach'a ba'an ti la' chucu chʌy? che'en. Ti' jac'ʌyob: Mach'an, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Che' jini Jesús ti' subeyob: Chocola ochel la' chimol chʌy ti' ñoj jucub. Mi quejel la' chuque' chʌy, che'en. Chʌ'ʌch ti' cha'leyob. Che' jini mach'an ti mejli i chucob loq'uel i chimol chʌy ti ja' cha'an ti caj i yonlel chʌy tsa' bʌ i chucuyob. ");
INSERT INTO ctu76_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Che' jini, jini ajcʌnt'an i cha'an Jesús tsa' bʌ wen p'untyʌnti ti Jesús ti' sube Pedro: Jiñʌch lac Yum, che'en. Che' ñac Simón Pedro ti yubibe i t'an cha'an lac Yumʌch ti' wa' cha' xojo i bujc (como jocholix i cha'an). Ti' choco ochel i bʌ ti ja'. Ti queji ti ñuxejel. ");
INSERT INTO ctu76_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jini yambʌ ajcʌnt'añob i cha'an Jesús ti c'oti ti' ti' ja' ti jucub como an jach che' bajche' cien metro i ñajtlel. Ti' tyujc'ʌyob tyʌlel jini chimol chʌy but'ul bʌ ti chʌy. ");
INSERT INTO ctu76_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Che' ñac ti c'oti ti' ti' ja' ti' q'ueleyob ñutsulix c'ajc. Ya'an chʌy ti' pam c'ajc. Chʌncol i ticwisan waj je'el. ");
INSERT INTO ctu76_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús ti' subeyob: Ch'ʌmʌla tyʌlel cha'cojt uxcojt chʌy tsa' bʌ ujti la' chuque', che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro ti ochi ti jucub. Ti' tyujc'ʌ tyʌlel c'ʌlʌ ti' ti' lum jini chimol chʌy but'ul bʌ ti colem chʌy. An ciento cincuenta y tres chʌy. Aunque wen on jini chʌy mach'an ti tyujq'ui jini chimol chʌy. ");
INSERT INTO ctu76_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Che' jini Jesús ti' subeyob: La'ixla ti uch'el, che'en. Mach'an majch ti' c'ajtibe majchqui jini Jesús como lu' yujilob isujm ajcʌnt'añob i cha'an Jesús cha'an lac Yumʌch. ");
INSERT INTO ctu76_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Che' jini Jesús ti' lʌc'ʌ c'ajc ba'añob. Ti' ch'ʌmʌ waj ti' c'ʌb. Ti' pucbeyob. Chʌ'ʌch je'el ti' cha'le yic'ot chʌy. ");
INSERT INTO ctu76_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jiñʌch i yuxyajlel Jesús ti' pʌsʌ i bʌ ba'an ajcʌnt'añob i cha'an che' tsa'ix tyejchi loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Che' ti ujtiyob ti uch'el, Jesús ti' c'ajtibe Simón Pedro: Simón i yalobil Jonás, ¿más ba ma' p'untyañon bajche' ili yaño' bʌ? che'en. Pedro ti' jac'ʌ: Muc'ʌch, c Yum. A wujil isujm mic p'untyañet, che'en. Jesús ti' sube: Aq'uen i buc'bal c saj tiñʌme'ob che' jini, che'en. Tiñʌme' yom i yʌle' oveja. ");
INSERT INTO ctu76_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús ti' cha' c'ajtibe: Simón i yalobil Jonás, ¿mu' ba a wen p'untyañon? che'en. Pedro ti' jac'ʌ: Muc'ʌch c Yum. A wujil isujm mic p'untyañet, che'en. Jesús ti' sube: Aq'uen i buc'bal c tiñʌme'ob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ti uxyajlel Jesús ti' c'ajtibe: Simón i yalobil Jonás, ¿mu' ba a p'untyañon? che'en. Ch'ʌjyem ti yubi Pedro che' uxyajlel ti' cha' c'ajtibe mi mux i p'untyan Jesús. Ti' sube: C Yum, lu' a wujil isujm. A wujil isujm mic p'untyañet, che'en. Jesús ti' sube: Aq'uen i buc'bal c tiñʌme'ob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Melel mic subeñet che' ñac max tyo ba'an cabʌl a jabilel ti a bajñel xojo a pislel. Tsajniyet ba'ic jach a wom majlel cha'an ti a bajñel xiq'ui a bʌ. Pero che' ñoxetix mi quejel a sʌts' a c'ʌb cha'an yambʌ mi' pʌyet majlel ba' mach a wom majlel. Che' yʌlol Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Che' ti yʌlʌ Jesús cha'an i tsictisan bajche' mi quejel i sajtyel Pedro yic'ot cha'an bajche' mi quejel i tsictisan i ñuclel Dios. Che' jini, Jesús ti' sube: Bej tsʌcleñon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Mu' ti xʌmbal Pedro yic'ot Jesús. Pedro ti' sutqui i bʌ. Ti yilʌ ajcʌnt'an i cha'an Jesús mu' bʌ i wen p'untyʌntyel ti Jesús chʌncol i tsʌcleñob. Jiñʌch ya' bʌ buchul ti' t'ejl Jesús che' ñac ti motin uch'iyob tsa' bʌ i c'ajtibe Jesús: C Yum, ¿majchqui jini mu' bʌ i yʌq'uet ti cʌchol? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Che' ñac ti yilʌ Pedro jini mu' bʌ i p'untyʌntyel ti Jesús, Pedro ti' c'ajtibe Jesús: C Yum, ¿jixcu jini, chʌ bʌ mi quejel i tyumbentyel jini? che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús ti' jac'ʌ: Comic bej cuxul mi yajñel jintyo mic cha' tyʌlel mach a wenta. Jatyet yom a bej tsʌcleñon, che'en. Che' yʌlol Pedro. ");
INSERT INTO ctu76_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Che' jini ti queji i yʌlob jini hermañujob mach'an mi quejel i sajtyel jini Juan. Pero Jesús mach'an ti yʌlʌ cha'an mach'an mi quejel i sajtyel. Tsa' jach i yʌlʌ: Comic bej cuxul mi yajñel jintyo mic cha' tyʌlel mach a wenta, che'en. ");
INSERT INTO ctu76_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Joñon ajcʌnt'añon i cha'an Jesús tsa' bʌ quilʌ tyac tsa' bʌ c ts'ijbu. Cujil melel tsa' bʌ c ts'ijbu. Joñon jini tsa' bʌ p'untyʌntiyon ti Jesús. ");
INSERT INTO ctu76_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","An tyo cabʌl tsa' bʌ i cha'le Jesús mach bʌ ba'an ti ts'ijbunti ti jun. Muq'uic i lu' ts'ijbuntyel ti jujunchajp i cha'libal Jesús, ñoj cabʌl jun mi yoc'an jintyo mach'an ba' och wʌ' ti mulawil yubil. Amén.");
INSERT INTO ctu76_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","P'untyʌbilet bʌ Teófilo. Ti yambʌ jun tsa' bʌ c ñaxan ts'ijbubet tic ts'ijbubet pejtyel tsa' bʌ i mele Jesús. Tic ts'ijbubet je'el pejtyel tsa' bʌ i cʌntisʌ c'ʌlʌl ti tyejchibal, ");
INSERT INTO ctu76_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","c'ʌlʌl jintyo ti pʌjyi letsel ti panchan. Che' ñac max tyo lets ti panchan, Jesús ti yajcʌ jini mu' bʌ i choque' majlel ti subt'an. Ti Ch'ujul bʌ i Ch'ujlel ti' cʌntisʌ yajcʌbilo' bʌ ajsubt'añob ñumel. Ti' cʌntisʌ pejtyel bajche' yom mi' cha'leñob troñel. ");
INSERT INTO ctu76_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Che' ñac ti ujti yʌc' i bʌ ti sajtyel Jesús ti' cha' pʌsʌ i bʌ ti yoque i cuxtyʌlel ti' tyojlelob tsa' bʌ i ñaxan yajcʌyob. C'ʌlʌl ti ñumi cuarenta q'uin ti' chʌc pʌsʌ i bʌ cha'an tsiquil melelʌch cha' cuxulix. Ti' subeyob cabʌl t'an cha'an i yumintyel Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Che' ya' tyo an Jesús yic'otyob jini yajcʌbilo' bʌ ajsubt'añob ñumel ti' wʌ subeyob cha'an mach yom loq'uicob majlel ti jini lum Jerusalén bʌ i c'aba'. Ti' subeyob: Pijtyanla wʌ'wʌ'i jintyo mi ts'ʌctiyel tsa' bʌ yʌlʌ c Tyat. Como mi quej i choc tyʌlel jini Ch'ujul bʌ i Ch'ujlel che' bajche' tic subetla. ");
INSERT INTO ctu76_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Wajali Juan ti yʌc'ʌ ch'ʌm ja'. Pero ma'ix jal wale Dios mi quej i yʌq'ueñetla Ch'ujul bʌ i Ch'ujlel. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Che' cha' much'quibilob jini yajcʌbilo' bʌ ajsubt'añob ñumel ti' c'ajtibeyob Jesús: C Yum, ¿jalajqui mi quej a wotsan ti ye'tyel juntiquil israel bʌ cha'an ti' q'uexol mach bʌ israel? che' ti' c'ajtibeyob. ");
INSERT INTO ctu76_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús ti' jac'ʌ: Mach la' wenta la' ña'tyan baqui bʌ ora baqui bʌ q'uin mi quej i cha' aq'uentyel. Jiñʌch i bajñel yujil isujm c Tyat am bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Che' mi yochel ti la' pusic'al Ch'ujul bʌ i Ch'ujlel Dios mi quej i yʌq'ueñetla la' p'ʌtyʌlel. Mi quej la' loq'uel majlel la' sube' j c'aba wʌ' ti Jerusalén yic'ot ti pejtyel pañimil tyac Judea bʌ i c'aba' yic'ot Samaria bʌ i c'aba'. C'ʌlʌl mi quej la' majlel ti más ñajt tyac bʌ pañimil. Che' ti yʌlʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Che' ñac ti ujti i lu' subeñob tsa'ix pʌjyi letsel Jesús ti panchan. Jini yajcʌbilo' bʌ ajsubt'añob ñumel chʌncol tyo i chʌc q'uelob Jesús che' ñac ti letsi ti panchan. Ti tyʌli tyocal tsa' bʌ mʌcʌ. Mach'anix ti' bej ilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Chʌncol tyo i ch'uj q'uelob ti chan ba' chʌncol i letsel majlel Jesús. Che' jini ti queji i q'uelob ya' wa'al cha'tiquil winic ti' t'ejlob. Ñoj sʌsʌc i pislel. ");
INSERT INTO ctu76_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ti yʌlʌyob: Winicob ch'oyolet bʌ la ti pañimil Galilea bʌ i c'aba', ¿chucoch wʌ' tyo chʌc wa'aletla a q'uele' chan? Jini Jesús tsa' bʌ pʌjyi letsel ti panchan wʌ' ba' añetla mi quejel i cha' tyʌlel chʌ'ʌch bajche' ti la' wilʌ ti majli ti panchan. Chʌ'ʌch ti subentiyob. ");
INSERT INTO ctu76_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ya' añob ti jump'ej wits Olivajol bʌ i c'aba' che' ti ujti pejtyel jini. Ti cha' sujtiyob majlel ti Jerusalén. Mach'an ñajt. Che' bajche' jump'ej jach kilómetro i ñajtlel. ");
INSERT INTO ctu76_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Che' ñac ti c'otiyob ti Jerusalén ti ochiyob ti otyot. Ti letsiyob ti yambʌ junlajm ba' ti poj ajniyob Pedro yic'ot Jacobo. Ya'an Juan je'el yic'ot Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo i yalobil bʌ Alfeo. Ya'an je'el Simón ch'oyol bʌ ba'an junmujch'o' bʌ cananistajo' bʌ i c'aba', yic'ot Judas i yijts'in Jacobo. ");
INSERT INTO ctu76_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ti jump'ejlob i pusic'al ti chʌc much'quiyob i bʌ ti oración yic'ot i yijts'iñob Jesús yic'ot María i ña' Jesús yic'ot yaño' bʌ x'ixicob je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ti jim bʌ q'uin ti' much'quiyob i bʌ che' bajche' ciento veintejob tsa' bʌ i ch'ujbiyob Jesús. Ti wa'le Pedro ti xiñilob. ");
INSERT INTO ctu76_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Ti yʌlʌ: Hermañujob, ti ñoj oniyix jini David ti' ts'ijbu bajche' ti subenti ti Ch'ujul bʌ i Ch'ujlel Dios. Como ti wʌ alʌ mi quej i pʌse' majlel bij Judas cha'an i chucob Jesús. Che' jini tsʌ'ʌch ts'ʌctiyi Ts'ijbubil bʌ i T'an Dios. Chʌ'ʌch ti ujti bajche' ti wʌ alʌ mi quej i cha'len jini Judas. ");
INSERT INTO ctu76_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Como Judas ti ajni la quic'ot. Ti aq'uenti ti' wenta ili troñel je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero Judas ti' mʌñʌ jumpejt lum yubil, como ti c'ʌjni i tyojol tsa' bʌ aq'uenti cha'an jini tsa' bʌ i niq'ui cha'le. Ti wi'il ti' bajñel yʌts'ʌ i bʌ ti lia. Ti puc' yajli. Ti tyojmi. Ti loq'ui pejtyel i soy tya'. ");
INSERT INTO ctu76_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Che' jini ti pam ubiyob ti pejtyelel ya' bʌ chumulob ti Jerusalén. Jin cha'an ti yotsʌbeyob i c'aba' ili jumpejt lum ti Acéldama. Yom i yʌle' i lum ch'ich'. ");
INSERT INTO ctu76_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Como ti jun Salmos bʌ i c'aba' mi yʌle': La' joch cʌylec i yotyot. Mach chumlec yambʌ ya'i. Mi yʌl je'el: La' i ch'ʌm'en i toñel yambʌ. Chʌ'ʌch ts'ijbubil ti jun Salmos bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Wʌ'an winicob tsa' bʌ i cha'leyob xʌmbal la quic'ot ti bele' q'uin che' ñac wʌ' tyo an ti mulawil Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","An tsa' bʌ i yilʌyob bajche' ti ajni Jesús c'ʌlʌ che' nac ti' ch'ʌmʌ ja' ti' c'ʌb Juan. An la quic'ot c'ʌlʌ jintyo ti pʌjyi letsel Jesús ti panchan. Yom yajcʌntic juntiquil mu' bʌ i tyem sub la quic'ot bajche' ti cha' tyejchi loq'uel Jesús ba'an sajtyemo' bʌ. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Che' jini ti yajcʌyob cha'tiquil winic. Juntiquil José bʌ i c'aba'. Mi' subeñob je'el ti Justo. Mi' subeñob je'el ti Barsabás jini José. Jini yambʌ winic Matías bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Che' jini ti' cha'leyob oración. Ti yʌlʌyob: C Yum, lu' a wujilʌch isujm am bʌ ti' pusic'al winicob. Pʌs'eñon lojon baqui bʌ ti ili cha'tiquil a wom a yajcan. ");
INSERT INTO ctu76_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Cha'an mi' ch'ʌm'en i troñel ti subt'an tsa' bʌ i cʌyʌ Judas che' ti' tyaja i mul. Como che' ñac ti sajti ti majli ya' ba' mi majlel mach'ʌ ba'an mi' ch'ujbin i t'an Dios. Chʌ'ʌch ti' cha'leyob oración. ");
INSERT INTO ctu76_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Che' jini ti' cha'leyob yajcaya cha'an i yajcʌntyel i q'uexol Judas. Matías ti ochi ti' q'uexol. Ti ajni yic'ot jini once yajcʌbilo' bʌ ajsubt'añob ñumel. Lajal ti' cha'leyob troñel. ");
INSERT INTO ctu76_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ya' lu' much'quibilob pejtyel ochemo' bʌ ti' t'an Dios ti jump'ej otyot che' ti c'oti i yorojlel jini q'uin Pentecostés bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ora jach ti queji i yubiñob ju'ucña che' bajche' p'ʌtyʌl bʌ ic' ch'oyol bʌ ti panchan. Ti bujt'i i yejts'al pejtyel jini otyot ba' buchulob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Che' jini ti tsictiyi che' bajche' lemlemña bʌ c'ajc. Ti wa'le ti jol ti jujuntiquilob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Che' jini ti jujuntiquil ti bujt'iyob ti Ch'ujul bʌ i Ch'ujlel Dios. Ti quejiyob ti t'an ti yan tyac bʌ t'an che' bajche' ti yʌc'ʌyob ti t'an jini Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ti mismo jim bʌ ora ya' añob ti Jerusalén israelo' bʌ loq'uemo' bʌ ti pejtyel pañimil tyac. Mi' bele' c'ajtisañob Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Che' ñac ti yubiyob ili ju'ucña bʌ t'an ti jojmiyob majlel i q'uelob. Mach'an ti' ña'tyʌyob chuqui yom i yʌle' como ti jujuntiquil ti yubiyob chʌncol ti subt'an ti yoque i t'añob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Tyoj bʌc'ñʌjel ti yubiyob. Ti yʌlʌyob: Ch'oyolob ti Galilea ti pejtyel ili winicob chʌncolo' bʌ ti t'an ");
INSERT INTO ctu76_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Bajche'qui isujm, che' jini, mi lac lu' ubin chʌncolob ti t'an ti yoque lac t'an bʌ yi? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Lamital ch'oyolon bʌ la ti pañimil Partia bʌ i c'aba' yic'ot ya' ti Media, yic'ot ya' ti Elam, yic'ot ya' ti Mesopotamia, yic'ot ya' ti Judea, yic'ot ya' ti Capadocia yic'ot ya' ti Ponto, yic'ot ya' ti pañimil Asia bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","An ch'oyolon bʌ la je'el ya' ti Frigia yic'ot Panfilia, yic'ot ya' ti Egipto yic'ot ti pañimil tyac ya' ti Africa ti lʌc'ʌlel yambʌ pañimil Cirene bʌ i c'aba'. An je'el ch'oyolo' bʌ ti Roma poj wʌ'an ti jula' je'el. Lamital ch'oyolo' bʌ ti Roma yoque israelob. Lamital ti sutquiyob i bʌ cha'an i ch'ujbiñob che' bajche' mi' ch'ujbiñob israelo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","An je'el ch'oyolo' bʌ ya' ti Creta yic'ot ya' ti Arabia. Lu' ch'oyolo' bʌ ti Galilea jini chʌncox i subob i ñuclel Dios pero mi lac lu' ubin ti jujunchajp bʌ lac t'an, che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Tyoj bʌc'ñʌjelob che' ñac ti yubiyob. Mach'an ti' ch'ʌmbeyob isujm jini chʌncol bʌ i yujtyel. Ti c'ajtibeyob i bʌ: ¿Bajche'qui i sujmlel jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero yaño' bʌ yi ti' wajleyob. Q'uixiñob. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Che' jini Pedro ti wa'le ti subt'an ti xinil jini yambʌ oncejob yajcʌbilo' bʌ ajsubt'añob ñumel. C'am ti queji ti t'an. Ti yʌlʌ: Pi'ʌlob, ch'oyolet bʌ la ti Judea yic'ot pejtyel wʌ' bʌ chumuletla ti Jerusalén, wen ñʌch'tyanla chʌ bʌ mi quej c subeñetla. Ch'ujbinla jini. ");
INSERT INTO ctu76_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mach'an q'uixiñon lojon bajche' mi la' lolon ña'tyan como a las nueve jach tyo ti sʌc'an, che'en. Como ma'an ba' bʌ ora mi q'uixñañob israelob ti sʌc'an. ");
INSERT INTO ctu76_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pero jini chʌncol bʌ yujtyel jiñʌch tsa' bʌ i wʌ alʌ jini tsa' bʌ i xiq'ui yʌle' Dios, Joel bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Jini Joel ti yʌlʌ: Ti yujtibal bʌ q'uin tyac Dios mi yʌl: Mi quej cʌq'ueñob Ch'ujul bʌ c Ch'ujlel pejtyel quixtyañujob. La' walobilob mi quej i wʌ alob jini mu' bʌ c mel. Jini alo' bʌ winicob mi quejel i q'uel che' bajche' ti ñajal cha'an jini mu' tyo bʌ quej yujtyel. Mux c pejcan ñoxobix bʌ ti ñajal tyac. ");
INSERT INTO ctu76_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ti mismo jim bʌ oraji mi quej cʌq'uen jini winic bʌ yic'ot jini x'ixic bʌ ajtroñelob c cha'an jini c Ch'ujlel. Mi quej i subob c t'an. ");
INSERT INTO ctu76_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ya' ti chan mi quej c wen pʌs ñuc bʌ c melbal yic'ot wʌ' ti mulawil bʌbʌq'uen bʌ señʌjlel c p'ʌtyʌlel: jiñʌch ch'ich', c'ajc, yic'ot buts'. ");
INSERT INTO ctu76_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mi quej yic'an q'uin. Chʌchʌc che' bajche' ch'ich' mi majlel uw che' max tyo ñoj c'ot i q'uinilel i tyʌlel la' Yum. Jini q'uinilel i tyʌlel la' Yum ñoj bʌbʌq'uen bʌ q'uin. ");
INSERT INTO ctu76_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Che' jini, majchical jach mu' bʌ i pejcan la' Yum ti' c'aba' mi quej i cotyʌntyel. Chʌ'ʌch ti yʌlʌ Dios ti ti' Joel, che' bajche' ti cha' alʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Pedro ti yʌlʌ je'el: Jatyetla israelet bʌ la, ñʌch'tyanla mu' bʌ c subeñetla. Dios ti' wen pʌsʌ ti la' tyojlel cha'an añʌch i p'ʌtyʌlel jini Jesús ch'oyol bʌ ti Nazaret. Como jiñʌch i p'ʌtyʌlel Dios ti tsictiyi ti Jesús ti la' tyojlel che' ñac ti' c'oq'uisʌ xc'am'añob. Ti' cha' cuxtisʌ sajtyemo' bʌ yic'ot yan tyac bʌ i melbal che' bajche' la' wujil isujm. ");
INSERT INTO ctu76_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero che' ñac ti aq'uentiyetla Jesús ti la' p'ʌtyʌlel che' bajche' ti' wʌ ña'tyʌ Dios, jatyetla ti la' chucu. Ti la' wʌc'ʌ ti' c'ʌb jini simaroño' bʌ tsa' bʌ i tsʌnsʌyob ti cruz. ");
INSERT INTO ctu76_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios ti cha' tyeche loq'uel ba'an sajtyemo' bʌ como mach ch'ujbi cʌylec ti yajnib sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Como jini ñuc bʌ yumʌl ti ñoj oniyix David bʌ i c'aba' ti' tyaja ti t'an Jesús. Ti yʌlʌ: Mic bele' q'uel c Yum ti' tyojel c wut. Como bele' wʌ' an quic'ot. Ma' mi quej c saj pensalin. ");
INSERT INTO ctu76_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jin cha'an ñoj tijicña ti cubi. Tijicñayon tic cha'le t'an. Che' mi ch'ujñʌntyel c bʌc'tyal mu' tyo i pijtyan i cha' tyejchel loq'uel ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Che' cu mach ya'ic mi quej a cʌy c ch'ujlel ti yajnib sajtyemo' bʌ. Mach'an mi quej a wʌc' ti pʌc'mʌl c bʌc'tyal como joñon a walobilon. ");
INSERT INTO ctu76_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mux a cha' aq'ueñon j cuxtyʌlel. Che' wʌ' añet quic'ot c'ajacñajax coj mi cubin. Chʌ'ʌch ti' tyaja ti t'an Jesús jini David. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro ti yʌlʌ je'el: Pi'ʌlob, lu' cʌñʌl la' cha'an ti sajti David jini lac yum ti ñoj oniyix. Ti' ch'ujñʌyob. C'ʌlʌl wale iliyi an ti lac lumal i yajnib ba' ti ch'ujñʌnti. ");
INSERT INTO ctu76_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jini David jiñʌch juntiquil tsa' bʌ i xiq'ui yʌle' Dios. Ti' ña'tyʌ i sujmlel tsa' bʌ i yʌlʌ Dios cha'an loq'uem ti' jiñʌjlel mi quej i tyʌlel Cristo jini mu' bʌ i ch'ʌm'en ñoj ñuc bʌ ye'tyel David. ");
INSERT INTO ctu76_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ti' wʌ ña'tyʌ mu' bʌ quej yujtyel. Ti' wʌ ña'tyʌ bajche' mi quej i cha' tyejchel loq'uel ba'an sajtyemo' bʌ Cristo che' ñac ti yʌlʌ cha'an mach ya'ic mi quej i cʌy i Ch'ujlel ti yajnib sajtyemo' bʌ. Mach'an mi quejel i yʌc' ti pʌc'mʌl i bʌc'tyal. Chʌ'ʌch ti' wʌ tyaja ti t'an Cristo jini David che' max tyo tyʌlem ti mulawil Cristo. ");
INSERT INTO ctu76_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios ti cha' tyeche loq'uel Jesús ba'an sajtyemo' bʌ. Ti lojon quilʌ, joñon lojon. ");
INSERT INTO ctu76_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ti pʌjyi letsel Jesús ti panchan ya' ti' ñoj Dios cha'an tsiquil añʌch i ñuclel Jesús. Ti aq'uenti ti i Tyat Ch'ujul bʌ i Ch'ujlel che' bajche' ti wʌ subenti. Jin cha'an ya' tyʌlem ti Jesús pejtyel chʌncol bʌ la' wubin, chʌncol bʌ la' wilan wale iliyi, che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Como mach jinic David tsa' bʌ letsi ti panchan pero David ti yʌlʌ: Jini lac Yum Dios ti' sube c Yum, buchi' ilayi tic ñoj jintyo mi cʌq'ueñet a ganarin a contrajob. Chʌ'ʌch ti yʌlʌ David, che'en Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yom i lu' ch'ʌm'eñob isujm pejtyel israelob. Ñoj melelʌch jiñʌch jini Jesús tsa' bʌ la' tsʌnsʌ ti cruz. Dios chʌncol i pʌs ñoj melel lac Yumʌch jini Jesús. Jiñʌch jini Cristo. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Che' ñac ti yubiyob ili t'ani, quisintic ti yubiyob. Ti' c'ajtibeyob Pedro yic'ot yambʌ yajcʌbilo' bʌ ajsubt'añob ñumel: Pi'ʌlob, ¿chuqui yom mi lojon c cha'len? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro ti' jac'beyob: Cʌyʌx la' mul. Ch'ʌmʌla ja' cha'an tsiquil ti la' ch'ujbi Jesús. Che' jini mi quej la' ñusʌbentyel la' mul. Che' jini Dios mi quej i yʌq'ueñetla Ch'ujul bʌ i Ch'ujlel. ");
INSERT INTO ctu76_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pejtyel tsa' bʌ i yʌlʌ Dios la' cha'añʌch yic'ot i cha'an la' walobilob. Ti ajq'ui jini t'an cha'añetla yic'ot cha'an la' walobilob yic'ot i cha'an jini ñajt bʌ añob. I cha'an majchical jach mu' bʌ i nijcʌbentyel i pusic'al ti lac Yum Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ti ili t'an tyac yic'ot yan tyac bʌ t'an Pedro ti' wen xiq'uiyob. Ti' subeyob: Ch'ujbinla cha'an mi la' tyaj la' cotyʌntyel, cha'an ma' mi la' lolon ñusan wocol che' bajche' mi quej i ñusañob pejtyel simaroño' bʌ. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Che' jini pejtyelelob tsa' bʌ i ch'ujbi ili t'an ti' ch'ʌmʌyob ja'. Che' jini ti jim bʌ q'uin ti oc'ʌ hermañujob che' bajche' tres mil quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ti' ñusʌyob cabʌl q'uin yic'ot jini yajcʌbilo' bʌ ajsubt'añob ñumel cha'an i cʌntisʌntyelob. Che' jini ti' wen xuc'chocoyob i pusic'al. Tyem tijicñayob. Ti' motin japʌyob i ya'lel uva, ti' motin c'uxuyob waj che' bajche' ti' xiq'uiyob Jesús i melob. Cabʌl ti' cha'leyob oración. ");
INSERT INTO ctu76_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tyoj bʌc'ñajel ti lu' yubiyob quixtyañujob. Ti' wen tsictiyi i p'ʌtyʌlel Dios yic'ot jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Junlajalob i pensal jini tsa' bʌ i ch'ujbiyob Jesús. Tyem i cha'añob pejtyel chʌ bʌ añob i cha'an. ");
INSERT INTO ctu76_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ti' choñoyob chʌ bʌ an i cha'an yic'ot i lum tyac cha'an ti' tyem c'ʌmbeyob i tyojol cha'an chʌ bʌ yes i c'ʌjnibal i cha'añob. ");
INSERT INTO ctu76_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ti jujump'ej q'uin ti' much'quiyob i bʌ ti templo. Ti tyem uch'iyob ti yotyotyob tyac. Tyem tijicñayob. Jump'ejlob jach i pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ti' subuyob i ñuclel Dios. Ti q'uejliyob ti ñuc ti yambʌ quixtyañujob. Ti jujump'ej q'uin Dios ti más oq'uisʌ jini tsa' bʌ i ch'ujbibeyob i t'an. ");
INSERT INTO ctu76_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ti och an q'uin Pedro yic'ot Juan ti tyem letsiyob majlel ti i colem templo israelob ya' ti Jerusalén. Como i yorojlelʌch oración. ");
INSERT INTO ctu76_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ya'an juntiquil winic mach'ʌ mejl ti xʌmbal c'ʌlʌ che' ñac ti ch'ocʌ. Bele' q'uin mi' pʌyob majlel ti ti' templo cha'an mi' c'ajtibeñob majtyan tyaq'uin jini mu' bʌ i yochelob ti templo. I c'aba' ili i ti' templo Hermosa. ");
INSERT INTO ctu76_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Che' ñac ti yilʌ ochel muc'ob ti templo Pedro yic'ot Juan ti' c'ajtibeyob majtyan tyaq'uin. ");
INSERT INTO ctu76_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Che' jini Pedro yic'ot Juan ti' ch'uj q'ueleyob jini c'am bʌ yi. Pedro ti yʌlʌ: Q'ueleyon lojon, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Che' jini ti' ch'uj q'ueleyob como ti' ña'tyʌ mi quej yʌq'uentyel i majtyan. ");
INSERT INTO ctu76_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedro ti' sube: Mach'an c tyaq'uin pero añʌch bajche' mij cotyañet, che'en. Cha'an ti' p'ʌtyʌlel Jesús ch'oyol bʌ ti Nazaret, wa'i. Cha'len xʌmbal. Che' yʌlol jini c'am bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Che' jini Pedro ti' chucu ti' ñoj. Ti' ch'uyu tyejchel. Ti wa' p'ʌtyʌliyi i bic' yoc yic'ot ti pejtyelel yoc. ");
INSERT INTO ctu76_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Che' jini, ti tijp'i tyejchel. Ti queji ti xʌmbal. Ti ochi ti templo yic'otyob. Mu' ti xʌmbal. Mu' ti tijp'el. Chʌncox i sub i ñuclel Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pejtyel quixtyañu ya' ba'añob ti yilʌyob chʌncox ti xʌmbal. Chʌncolix i sube' i ñuclel Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ti' lu' cʌñʌyob jiñʌch jini tsa' bʌ buchle i c'ajtin i majtyan tyaq'uin ya' ti ti' templo Hermosa bʌ i c'aba'. Tsijc' che'ob i pusic'al. Tyoj bʌc'ñʌjelob cha'an bajche' ti lajmi ili winiqui. ");
INSERT INTO ctu76_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Chʌncol tyo i tyul mec'ob Pedro yic'ot Juan ili winiqui tsa' bʌ lajmisʌnti yoc. Ya' ti majliyob ti jump'ej i lejch' yotyot Salomón bʌ i c'aba'. Ti wa' ajñel much'quiyob i bʌ pejtyel winicob ya' ba'añob. Tyoj bʌc'ñʌjelob che' ti yilʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Che' ñac ti yilʌ chʌncox i much'quiñob i bʌ, Pedro ti' subeyob: Winicob i jiñʌjlet bʌ la Israel, ¿chucoch tyoj bʌc'ñʌjeletla che' mi la' wilan jini tsa' bʌ ujti? ¿Chucoch mi la' ch'uj q'uelon lojon che' bajche' ti lojon c p'ʌtyʌlel ti lojon c lajmisʌ iliyi winiqui o mi ti lojon c wenlel che' muq'uix ti xʌmbal ili winiqui? ");
INSERT INTO ctu76_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Pero mach jinic ti lojon c wenlel. Jini Dios mu' bʌ lojon c ch'ujbin, tsa' bʌ i ch'ujbiyob je'el Abraham, Isaac, yic'ot Jacob, lac yumob ti ñoj oniyix, ti' wen pʌsʌ i ñuclel Jesús. Che' cu jini Jesús tsa' bʌ la' wʌq'ue i mel i bʌ ba'an Pilato, jiñʌch i yalobil Dios. Pero che' ñac Pilato ti' lolon jop'o i cole' ma'an ti la' wʌc'ʌ ti cojlel. ");
INSERT INTO ctu76_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ch'ujulʌch jini Jesús. Ma' sajlic i mul. Pero ma'an ti la' wʌc'ʌ ti cojlel. Tsa' jach la' c'ajti cha'an mi' colbeñetla juntiquil ajtsʌnsa. ");
INSERT INTO ctu76_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Che' jini ti la' tsʌnsʌ jini mu' bʌ i yʌq'ueñonla laj cuxtyʌlel. Jiñʌch jini tsa' bʌ i tyeche loq'uel Dios ba'an sajtyemo' bʌ. Chʌncol lojon c sube' cha'an Dios ti tyeche loq'uel como ti lojon quilʌ joñon lojon. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pero q'uele la' wilan tsiquilʌch an i p'ʌtyʌlel i c'aba' Jesús. Ti lajmisʌnti ili winiqui cha'an ti lojon c ch'ujbi ti lojon c pusic'al, ti lojon j c'ʌñʌ i p'ʌtyʌlel Jesús. Che' jini chʌ'ʌch ti ujti bajche' chʌncol la' wilan cha'an ti caj i p'ʌtyʌlel Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pi'ʌlob, cujilʌch isujm jatyetla yic'ot año' bʌ ye'tyel mach'an ti la' ña'tyʌ chʌ bʌ muq'uetla che' ñac ti la' tsʌnsʌ Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero Dios ti yʌc'ʌ ti ts'ʌctiyel i t'añob jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Como jini ti wʌ alʌyob cha'an mi quejel i ñusan wocol Cristo. ");
INSERT INTO ctu76_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jin cha'an pensalin la' mul. Cʌyʌx la' mul cha'an ñusʌbentic la' mul. Che' jini Dios mi quej i ñʌch'chocon la' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mi quej i cha' choc tyʌlel Jesús. Jiñʌch jini Cristo tsa' bʌ wʌ yajcʌnti ti Dios cha'añetla. ");
INSERT INTO ctu76_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesús mi quej i cʌytyʌl ya' ti panchan jintyo mi c'otyel i yorojlel che' Dios mi quej i lu' tsijibtisan pejtyel chʌ bʌ an tyac. Chʌ'ʌch ti wʌ alʌ Dios ti ti' jini tsa' bʌ i xiq'ui yʌle' ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés ti' sube lac yumob ti ñoj oniyix: Lac Yum Dios mi quejel i yajcan juntiquil mu' bʌ i xiq'ue' yʌle' Dios loq'uem ya' ba' añetla. Juntiquil la' pi'ʌl chʌ'ʌch bajche' ti yajcʌyon. Ch'ujbinla pejtyel chʌ bʌ jach mi' subeñetla. ");
INSERT INTO ctu76_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Como majchical jach mach'an mi' ch'ujbin i t'an mi quejel i chojquel loq'uel ba'an lac pi'ʌlob israelob. Mi quejel i jisʌntyel. Che' ti yʌlʌ Moisés ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Chʌ'ʌch je'el ti' cha'le t'an pejtyel yaño' bʌ tsa' bʌ i xiq'ui yʌle' Dios. Che' ti yʌlʌ Samuel yic'ot pejtyel yaño' bʌ wi'ilix bʌ ti tyʌliyob. Ti lu' cha'leyob t'an cha'an jini chʌncol bʌ yujtyel wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","La' cha'añʌch wale iliyi pejtyel tsa' bʌ i wʌ lu' alʌ Dios ti ñoj oniyix tsa' bʌ yʌlʌ ti ti' jini tsa' bʌ i xiq'ui yʌle' Dios. Cha'an la' wenlel Dios ti' mele trato yic'ot lac yum ti ñoj oniyix Abraham bʌ i c'aba'. Dios ti yʌq'ue i t'an Abraham. Ti yʌlʌ: Ya' loq'uem ti a jiñʌjlel mi quejel i tyʌlel juntiquil mu' bʌ i cotyan pejtyel año' bʌ ti mulawil. Che' ti subenti Abraham ti Dios, che' Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Che' jini, che' ñac Dios ti tyeche loq'uel Jesús ba'an sajtyemo' bʌ, ñaxan ti' xiq'ui tyʌlel wʌ' ba' añetla cha'an mi yʌq'ueñetla la' wenlel cha'an mi la' cʌy la' mul ti jujuntiquiletla. Che' ti' cha'le t'an Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Chʌncol tyo i pejcañob quixtyañujob Pedro yic'ot Juan che' ñac ti tyʌliyob curajob i cha'an bʌ israelob yic'ot i yumob policía i cha'an bʌ templo ya' ti Jerusalén yic'ot jumujch' winicob saduceojo' bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ti' mich'q'ueleyob Pedro yic'ot Juan como chʌncox i cʌntisañob quixtyañujob. Chʌncox i subeñob cha'an Jesús ti tyejchi loq'uel ba'an sajtyemo' bʌ. Chʌncol i yʌlob cha'an tsiquilʌch, che' jini, mi quej i tyejchelob yaño' bʌ ba'an sajtyemo' bʌ je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ti' chucuyob. Ti yotsʌyob ti cʌchol jintyo ti yijc'ʌlel. Mach ch'ujbi i wa' yʌc'ob ti melojel como iq'uix quejel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero cabʌl tsa' bʌ yubiyob i t'an jini yajcʌbilo' bʌ ajsubt'añob ñumel ti' ch'ujbiyob. Che' jini ti oc'ʌyob jintyo anix lʌc'ʌl jop'ej mil che' winicob jach ti tsijquiyob. ");
INSERT INTO ctu76_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ti yijc'ʌlel ti' much'quiyob i bʌ ya' ti Jerusalén jini israelob año' bʌ ñuc bʌ ye'tyel, yic'ot xñoxo' bʌ año' bʌ ye'tyel yic'ot ajcʌntisajob cha'an i mandar Moisés. ");
INSERT INTO ctu76_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ya'an je'el ñoj ñuc bʌ cura Anás bʌ i c'aba' yic'ot Caifás je'el, yic'ot Juan, Alejandro yic'ot pejtyelel i pi'ʌlob jini ñoj ñuc bʌ cura. ");
INSERT INTO ctu76_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jiñob ti' xiq'uiyob i pʌy tyʌlel Juan yic'ot Pedro ya' ba'añob. Ti' c'ajtibeyob: ¿Majchiqui ti yʌq'uetla ti la' wenta cha'an mi la' cha'len che' bajche' chʌncol la' niq'ui cha'len? ¿Baqui ti la' tyaja i p'ʌtyʌlel lajmisaya? Che' ti' c'ajtibeyob. ");
INSERT INTO ctu76_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jini Ch'ujul bʌ i Ch'ujlel Dios am bʌ ti' pusic'al Pedro ti yʌq'ue i jaq'ue'. Ti yʌlʌ: Jatyetla, yumʌlet bʌ la, jatyetla, xñoxet bʌ la am bʌ la' we'tyel wʌ' ti lac lumal. ");
INSERT INTO ctu76_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Chʌncol la' c'ajtibeñon lojon bajche' ti ujti, bajche' ti lajmisʌnti ili mach bʌ mejl i nijcan i yoc. ");
INSERT INTO ctu76_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Mux c subeñetla che' jini, cha'an mi' lu' ña'tyan pejtyel israelob. Ili winiqui wʌ' ba'an wʌ'i ti lajmisʌnti cha'an ti caj ti lojon j c'ʌñʌ i p'ʌtyʌlel Jesucristo ch'oyol bʌ ti Nazaret. Jiñʌch jini tsa' bʌ la' tsʌnsʌ ti cruz, tsa' bʌ i tyeche loq'uel Dios ba'an sajtyemo' bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jiñʌch jini Jesús tsa' bʌ i tyaja ti t'an ts'ijbubil bʌ i t'an Dios ba' mi yʌle': Jiñʌch jini wen bʌ tyun yubil tsa' bʌ la' wa'choco xmel tyun bʌ otyotyetla. Pero jini tyun ti ochi bajche' oy ti xujc' otyot. ");
INSERT INTO ctu76_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mach'an yambʌ ba' ch'ujbi lac tyaj laj cotyʌntyel. Dios ma' ti yʌc'onla yambʌ ti pejtyelel mulawil ba' mi lac tyaje' laj cotyʌntyel. Cojach ti Jesús. Che' ti yʌlʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jini am bʌ ye'tyel ti yilʌyob wen ch'ejl ti' cha'leyob t'an Pedro yic'ot Juan. Tyoj bʌc'ñʌjel ti yubiyob como yujilob isujm mach'an ti cabʌl ochiyob ti q'uel jun mi añobic ye'tyel. Ti' ña'tyʌyob che' i pi'ʌlobʌch ti xʌmbal Jesús che' ñac wʌ' tyo an ti mulawil Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mach'an chʌ bʌ ch'ujbi i yʌlob ti' contra Pedro yic'ot Juan como ya' wa'al yic'otyob jini tsa' bʌ c'oq'uisʌnti. ");
INSERT INTO ctu76_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ti' xiq'uiyob loq'uel ba'añob. Ti queji i bajñel pejcañob i bʌ jini año' bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ti yʌlʌyob: ¿Chuquiyes mi quejel lac tyumben ili winicob? Tisquilʌch tsa'ix i pʌsʌyob ñuc bʌ i p'ʌtyʌlel. Lu' yujilob isujm ili wʌ' bʌ chumulob ti Jerusalén. Mach ch'ujbi la cʌl mi lot. ");
INSERT INTO ctu76_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero cha'an mach chʌc p'ojlic ili t'an ba'an quixtyañujob, la' lac wen tic'ob cha'an ma' mi' chʌc subeñob t'an cha'an jini Jesús. Che' ti yʌlʌyob año' bʌ i ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Che' jini ti' cha' pʌyʌyob tyʌlel Pedro yic'ot Juan. Ti' wen tiq'uiyob cha'an ma'an mi' chʌc cha'len subt'an mi cʌntisa cha'an jini Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedro yic'ot Juan ti' jac'beyob: ¿Bajche'qui yom mi lojon c cha'len mi la' wʌl? ¿Yom ba mi lojon cac'ben i t'an Dios o mi lojon cac'beñet la' t'an jatyetla? ");
INSERT INTO ctu76_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Mach ch'ujbi lojon cʌy c sub jini tsa' bʌ lojon quilʌ, tsa' bʌ lojon cubi. Che' ti' jac'ʌyob Pedro yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jini ñuc bʌ curajob i cha'an israelob yic'ot xñoxob am bʌ ye'tyel ti' tiq'uiyob. Ti' coloyob. Ma'an chʌ bʌ ti tyumbeyob cha'an chʌncox i bʌc'ñañob quixtyañujob como jiñob chʌncox i q'uelob ti ñuc Pedro yic'ot Juan. Ti pejtyelel quixtyañu chʌncox i subob i ñuclel Dios cha'an jini tsa' bʌ ujti. ");
INSERT INTO ctu76_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jini winic tsa' bʌ lajmisʌnti ñumenix ti cuarenta i jabilel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Che' ñac ti cojliyob Pedro yic'ot Juan ti sujtiyob majlel ya' ba'an ochemo' bʌ ti' t'an Dios. Ti' subeyob pejtyel tsa' bʌ subentiyob ti ñuc bʌ curajob yic'ot jini yaño' bʌ año' bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Che' ñac jini ochemo' bʌ ti' t'an Dios ti yubiyob pejtyel bajche' ti ujti, ti jump'ejlob jach i pusic'al ti' cha'leyob oración. Ti yʌlʌyob: C Yum, jatyet Dioset. Ti a mele chan yic'ot mulawil. Ti a mele colem ja' tyac yic'ot pejtyel yan tyac bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","C Yum, jatyet ti Ch'ujul bʌ a Ch'ujlel ti a cha'le t'an ti' ti' David jini ajtroñel a cha'an, jini lojon c yum ti ñoj oniyix. Ti yʌlʌ: Lu' mich'ob pejtyel jini mach bʌ israelobic. Chʌncol i chʌc lolon pensaliñob jini mach'ʌ ba'an i c'ʌjnibal. ");
INSERT INTO ctu76_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Jini yumʌlob ti mulawil yic'ot ñuco' bʌ ye'tyel ti' much'quiyob i bʌ cha'an mi' contrajiñob Dios yic'ot Cristo jini yajcʌbil bʌ i cha'an Dios. Che' ti' tyajayob ti t'an ti oración ts'ijbubil bʌ i t'an Dios bajche' ti yʌlʌ David ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ti oración ti bej alʌyob: Ñoj melelʌch wʌ' ti ili bʌ lum ti' much'quiyob i bʌ Herodes yic'ot Poncio Pilato yic'ot israelo' bʌ yic'ot jini mach bʌ israelob. Ti' lu' much'quiyob i bʌ ti' contra Jesús jini ch'ujul bʌ a walobil, jiñʌch jini tsa' bʌ a yajcʌ cha'an lojon cajcotyayaj. ");
INSERT INTO ctu76_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Che' jini chʌ'ʌch ti lu' ts'ʌctiyi pejtyel tsa' bʌ a wʌ alʌ mi quej i wersa ujtyel. ");
INSERT INTO ctu76_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wale, C Yum, q'uele bajche' chʌncox i jop' i bʌc'tisañon lojon. Pero ajtroñelon lojon a cha'an, c Yum. Cotyañon lojon cha'an wen ch'ejl mi lojon c sub a wen t'an. ");
INSERT INTO ctu76_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Pʌsʌ a p'ʌtyʌlel cha'an lajmicob xc'am'añob. Pʌsʌ ñuc tyac bʌ a p'ʌtyʌlel cha'an ti' p'ʌtyʌlel Jesús jini ch'ujul bʌ a walobil. Chʌ'ʌch ti' cha'leyob oración jini ochemo' bʌ ti' t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Che' ñac ti ujtiyob ti oración ti' nijcʌ Dios jini otyot ba' much'quibilob. Ti bujt'iyob i pusic'al jujuntiquil ti Ch'ujul bʌ i Ch'ujlel Dios. Ch'ejl ti' bej subuyob i t'an Dios. Ma' sajlicob i bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jump'ej jach i pusic'al, jump'ej jach i pensal pejtyel jini ochemo' bʌ ti' t'an Dios. Ma'an majch ti yʌlʌ mi i bajñel i cha'an chʌ bʌ an i cha'an. Tyem i cha'añobʌch ti pejtyelelob. ");
INSERT INTO ctu76_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Dios ti bej yʌq'ueyob cabʌl i p'ʌtyʌlel ti subt'an jini yajcʌbilo' bʌ ajsubt'añob ñumel. Ti' chʌc subuyob cha'an ti tyejchi loq'uel Jesús ba'an sajtyemo' bʌ. Ti pejtyelel tsa' bʌ i ch'ujbiyob ti' pusic'al i t'an Dios ti aq'uentiyob i yutslel i pusic'al Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ma'an majch mach'ʌ ba'an chʌ bʌ an i cha'an, como jini am bʌ i lum, am bʌ yotyot ti' choñoyob. Ti' ch'ʌmʌ tyʌlel i tyojol. Ti yʌq'ue yajcʌbilo' bʌ ajsubt'añob ñumel. Ti' t'oxbeyob cha'an jasʌl chʌ bʌ an i cha'an jini ochemo' bʌ ti' t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ya'an yic'otyob juntiquil winic ch'oyol bʌ ti jump'ej saj lum joyol bʌ ti ja' Chipre bʌ i c'aba'. José i c'aba' jini winic. I jiñʌjlel Levita jini José. Jini yajcʌbilo' bʌ ajsubt'añob ñumel mi' pejcan José ti Bernabé. I sujmlel i c'aba' ti lac t'an mi yʌl jini mu' bʌ i cha' tijicnisʌbeñonla lac pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jini José ti' choño i lum. Ti' ch'ʌmbeyob tyʌlel i tyojol. Ti yʌq'ue ti' wenta yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ya'an yic'otyob je'el yambʌ winic Ananías bʌ i c'aba' yic'ot yijñam Safira bʌ i c'aba'. Ti' choño i lum. ");
INSERT INTO ctu76_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Che' jini Ananías ti' t'ox lotyo lamital jini i tyojol i lum. Ti' ch'ʌmʌ majlel lamital. Ti yʌq'ue yajcʌbilo' bʌ ajsubt'añob ñumel che' bajche' ti pejtyelel ti' lolon mele. I yijñam yujilix isujm bache' ti' cha'le i ñoxi'al. ");
INSERT INTO ctu76_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Che' jini, Pedro ti yʌlʌ: Ananías, ¿bajche'qui isujm ti ochi Satanás ti a pusic'al cha'an ma' jop' a lotin Ch'ujul bʌ i Ch'ujlel Dios? ¿Chucoch ti a t'ox mucu i tyojol a lum? ");
INSERT INTO ctu76_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Mach ba a cha'anic che' ya' tyo an a lumi? Che' je'el che' tsa'ix a choño, ¿mach ba a cha'añʌch i tyojol? ¿Chucoch ti a lolon cha'le lot che' bajche' jini? Mach winicob tsa' bʌ a loti. Jiñʌch Dios ti a loti, che' Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Che' ñac ti yubi ili t'an, Ananías ti yajli ti lum. Ti wa' sajti. Pejtyel jini tsa' bʌ yubiyob bajche' ti ujti ti wen quejiyob ti bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Che' jini ti tyʌliyob cha'tiquil uxtiquil alo' bʌ winicob. Ti' bʌc'ʌyob ti pisil. Ti' q'uecheyob majlel cha'an mi' ch'ujñañob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ti ñumi che' bajche' uxp'ej ora. Ti ochi yijñam Ananías. Max tyo ti yubi bajche' ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro ti' c'ajtibe: ¿Subeñon mi melelʌch ti la' choño la' lum, mi chʌ'ʌch i tyojol bajche' ti la' wʌlʌ? che'en. Jini x'ixic ti' jac'ʌ: Chʌ'ʌchi, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Che' jini, Pedro ti' cha' sube: ¿Chucoch ti la' laja la' t'an cha'an mi la' jop' la' lotin Ch'ujul bʌ i Ch'ujlel lac Yum? Q'uele awilan, ya' añob ti pañimil tsajni bʌ i ch'ujñañob a ñoxi'al. Wale mi quej i pʌyetyob majlel je'el, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Che' jini ti wa' sajti. Ti yajli ti yebal yoc Pedro. Che' ñac ti ochiyob jini alo' bʌ winicob sajtyemix ti' tyajayob. Ti' q'uecheyob majlel. Ti' ch'ujñʌyob ya' ti' t'ejl i ñoxi'al. ");
INSERT INTO ctu76_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tyoj bʌc'ñʌjelob ti yubiyob pejtyel ochemo' bʌ ti' t'an Dios yic'ot yaño' bʌ tsa' bʌ yubiyob bajche' ti ujti. ");
INSERT INTO ctu76_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Dios ti' pʌsʌ i p'ʌtyʌlel ba'an quixtyañujob ti' c'ʌbob yajcʌbilo' bʌ ajsubt'añob ñumel. Pejtyel ochemo' bʌ ti' t'an Dios mi' lu' much'quiñob i bʌ ti lejch' yotyot Salomón bʌ i c'aba' ya' ti ti' jini colem templo. ");
INSERT INTO ctu76_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jini mach'ʌ ba'an ochemo' bʌ ti' t'an Dios ti' q'uele ti ñuc jini ochemo' bʌ ti' t'an Dios pero ti bʌc'ñʌ i yochelob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","I yonlel winicob x'ixicob ti' ch'ujbiyob Jesús ti' pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Lamital quixtyañu ti' pʌyʌ majlel c'amo' bʌ i pi'ʌlob ti bij ba' mi ñumel Pedro. Ya' ti' tyots' cʌyʌyob ti wʌyib cha'an jasʌl jach i yʌxñal Pedro mi tyajtyʌlob cha'an lajmicob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Che' je'el ti c'oti cabʌlob ya' bʌ chumulob ti saj lum tyac ya' ti' joytyʌlel Jerusalén. Ti' pʌyʌyob tyʌlel xc'amo' bʌ yic'ot tyʌc'lʌbilo' bʌ ti xiba cha'an mi lajmel. Ti lu' lajmisʌntiyob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jini ñuc bʌ cura yic'ot i pi'ʌlob ti troñel saduceojo' bʌ i c'aba' ti queji i ts'a'q'uel jini yajcʌbilo' bʌ ajsubt'añob ñumel como cabʌl quixtyañujob chʌncol i ch'ujbiben i t'an Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ti' chucuyob. Ti yotsʌyob ti cʌchonibʌl. ");
INSERT INTO ctu76_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ti ac'bʌlel jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ti' jambeyob i ti' cʌchonibʌl. Ti' pʌyʌyob loq'uel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Ti' subeyob: Cha' cucuxla ya' ti templo. Yom mi la' suben pejtyel quixtyañujob jini t'an bajche' mi lac tyaj laj cuxtyʌlel ti Cristo. Che' ti yʌlʌ jini ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ti' cha'leyob bajche' ti subentiyob. Ti sʌc'an ti cha' ochiyob ti templo. Ti quejiyob ti cʌntisa. Che' jini, ti jini mismo bʌ ora jini ñuc bʌ cura yic'ot i pi'ʌlob ti toñel ti' pʌyʌyob tyʌlel pejtyel am bʌ ye'tyel ti Junta Suprema. Jiñʌch jini xñoxob am bʌ ye'tyel cha'an israelob. Che' jini ti' choco majlel policíajob ya' ti cʌchonibʌl cha'an i pʌy tyʌlel jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Che' ñac ti c'otiyob ti cʌchonibʌl jocholix ti' tyajayob. Ma'ix ya'añob. Ti cha' sujtiyob ba' much'quibilob am bʌ ye'tyel. Ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Wen ñup'ul ti lojon c tyaja cʌchonibʌl. Ya' añob ajcʌñʌtya cʌchonibʌl wa'al ti ti' pero che' ñac ti lojon camʌ i ti', ma'ix majch an ti malil, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Che' ñac ti yubiyob ili t'an jini ñuc bʌ cura yic'ot saduceojob yic'ot ñuc bʌ policía i cha'an bʌ templo ti queji i wen pensaliñob: ¿Bajche'qui mi quej i yujtyel pejtyel jini? che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Che' ñac chʌncolob tyo ti pensal ti c'oti juntiquil tsa' bʌ subeyob: Ubinla, ya' añob ti templo jini winicob tsa' bʌ la' wotsʌ ti cʌchol. Chʌncox i cʌntisañob quixtyañujob, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jini ñuc bʌ policía yic'ot i winicob ti majli ya' ti templo cha'an i pʌyob tyʌlel. Pero mach'an chʌ bʌ ti' tyumbeyob jini yajcʌbilo' bʌ ajsubt'añob ñumel. Xuc'ul jach ti' pʌyʌyob loq'uel como jini policíajob ti' bʌc'ñʌyob jujlel ti tyun ti jini yambʌ quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Che' ñac ti c'oti yic'otyob ti' pʌyʌyob ochel ya' ba'an año' bʌ ye'tyel. Jini ñuc bʌ cura ti' subeyob: ");
INSERT INTO ctu76_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Joñon lojon tic wen tiq'uiyetla ti tsʌts bʌ t'an cha'an mach la' chʌc cha'len cʌntisa cha'an ili winiqui. Pero ¿bajche'qui ti la' cha'le wale? Q'uele awilan, chʌncol la' pam pujquel la' cʌntisa ti pejtyel Jerusalén. La' wom jach la' pajtyañon lojon che' joñon lojon ti cʌc'ʌ ti tsʌnsʌntyel jini Jesús. Che' ti yʌlʌ jini ñuc bʌ cura. ");
INSERT INTO ctu76_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Che' jini Pedro yic'ot yambʌ yajcʌbilo' bʌ ajsubt'añob ñumel ti' jac'ʌyob: An ti lojon c wenta mi lojon jac'ben i xic'ojel Dios aunque mi lojon c ñusʌben i xic'ojel winicob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Jatyetla ti la' tsʌnsʌ Jesús che' ñac ti la' joc'choco ti cruz. Pero Dios ti tyeche loq'uel ba'an sajtyemo' bʌ. Jiñʌch jini mismo Dios tsa' bʌ i ch'ujbiyob ti' pusic'al lac yumob ti ñoj oniyix je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios ti' pʌyʌ letsel Jesús ya' ti' ñoj cha'an tsiquil añʌch i ñuclel Jesús. Ti otsʌnti ti ñuc bʌ ye'tyel yic'ot ti ajcotyayaj. Añʌch, che' jini, bajche' ch'ujbi i pensaliñob i mul cha'an i cʌyob i mul israelob yic'ot cha'an mi ñusʌbentyelob i mul. ");
INSERT INTO ctu76_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Cujilʌch lojon isujm chuqui chʌncol lojon cʌle'. Chʌ'ʌch mi yʌle' je'el Ch'ujul bʌ i Ch'ujlel Dios tsa' bʌ aq'uenti majchical jach mi' ch'ujbin Dios. Che' ti yʌlʌyob jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Che' ñac ti yubiyob ili t'an jini año' bʌ ye'tyel ti wen mich'ʌyob. Yom i tsʌnsañob jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ya'an juntiquil fariseo, Gamaliel bʌ i c'aba'. Jini Gamaliel lu' yujil isujm jini oñiyix bʌ i xic'ojel Dios. Pejtyel quixtyañu ti' q'ueleyob ti ñuc jini Gamaliel. Jini ti wa'le. Ti' subeyob cha'an mi' poj pʌy loq'uel jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Gamaliel ti' subeyob jini año' bʌ ye'tyel: Pi'ʌlob, ña'tyanla chʌ bʌ mi quej la' tyumbeñob ili winicob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","C'ajal la' cha'an max tyo jaliji juntiquil winic Teudas bʌ i c'aba' ti' lolon subu i bʌ ti ñuc. Che' jini ti queji i tsʌcleñob che' bajche' cuatrocientos winicob. Pero ti tsʌnsʌnti jini Teudas. Ti lu' puts'iyob jini winicob. Ti cha' lajmi jini t'an. ");
INSERT INTO ctu76_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ti wi'il che' ti yorojlel censo ti tyʌli yambʌ winic loq'uem bʌ ti Galilea Judas bʌ i c'aba'. Cabʌl winicob ti' tsʌcleyob majlel jini Judas. Pero ti' tsʌnsʌyob je'el. Ti lu' puts'iyob i winicob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jin cha'an mic subeñetla, la' ajnic ili winicob. Mach la' wotsan la' bʌ. Mi tyʌlem jach ti bajñel i pusic'alob ili t'an, che' jach mi quej i lajmel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero mi tyʌlem ti Dios mach ch'ujbi la' jisan. Ña'tyanla ame chʌncol la' contrajin Dios. Che' ti yʌlʌ jini Gamaliel. ");
INSERT INTO ctu76_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jini am bʌ ye'tyel ti' ch'ujbibeyob i t'an Gamaliel. Ti' cha' pʌyʌyob ochel jini yajcʌbilo' bʌ ajsubt'añob ñumel. Ti' jats'ʌyob ti chij. Ti' cha' tiq'uiyob cha'an mach'an mi' chʌc cha'leñob t'an cha'an Jesús. Che' jini ti' coloyob. ");
INSERT INTO ctu76_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jini yajcʌbilo' bʌ ajsubt'añob ñumel ti loq'uiyob majlel ba'an jini am bʌ ye'tyel. C'ajacñayob i yoj cha'an Dios ti yʌq'ueyob i ñusan wocol cha'an ti caj Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma' ti' cʌyʌyob mi jump'ejlic q'uin i sub ñumel jini wen bʌ t'an cha'an Jesús, jiñʌch Cristo yajcʌbil bʌ i cha'an Dios. Ti' subuyob ti jini colem templo ya' ti Jerusalén yic'ot ti otyotyel tyac. ");
INSERT INTO ctu76_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti wen oc'ʌyob jini ochemo' bʌ ti' t'an Dios. Che' jini lamital jini mu' ti t'an ti t'añob griegojob ti queji i mich'q'uelob jini mu' bʌ ti t'an ti t'añob hebreojob. Jini griegojo' bʌ ti queji i yʌle' cha'an jini meba' ixicob i cha'añob mach junlajal chʌncol i yʌq'uentyel i bʌlob i ñʌc' ti jujump'ej q'uin che' bajche' hebreojo' bʌ meba' ixicob. ");
INSERT INTO ctu76_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jini doce yajcʌbilo' bʌ ajsubt'añob ñumel ti' xiq'uiyob cha'an i much'quiñob i bʌ pejtyel ochemo' bʌ ti' t'an Dios. Ti' subeyob: Mach wen cha'an mi lojon c poj cʌy lojon c subt'an cha'an mi lojon c puc waj, che'ob. ");
INSERT INTO ctu76_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jin cha'an, pi'ʌlob, yom mi la' yajcan wʌ bʌ loq'uem ti lac tyojlel siete winicob mu' bʌ lojon cʌq'uen ti' wenta ili toñel. Yom mi la' yajcan but'ulo' bʌ i pusic'al ti Ch'ujul bʌ i Ch'ujlel Dios, jini mu' bʌ q'uejlel ti ñuc ti yaño' bʌ. Yom je'el jini mu' bʌ i ña'tyañob bajche' yom i melob. ");
INSERT INTO ctu76_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Joñon lojon mux c bej cha'len lojon oración yic'ot subt'an. Che' ti yʌlʌyob jini yajcʌbilo' bʌ ajsubt'añob ñumel. ");
INSERT INTO ctu76_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Weñʌch ti yubiyob ti pejtyelelob. Ti' yajcʌyob Esteban tsa' bʌ i ch'ujbi Jesús ti pejtyel i pusic'al. But'ul i pusic'al Esteban ti Ch'ujul bʌ i Ch'ujlel Dios. Ti yajcʌyob je'el Felipe, Prócoro, Nicanor, Timón, Parmenas yic'ot Nicolás. Ti wajali mach bʌ israelic jini Nicolás, pero ti wi'il ti' sutqui i bʌ ti israel bʌ quixtyañu. Ti wi'il, ti yubi i t'an Dios. Ti' ch'ujbi Jesús ti' pusic'al. Ti ochi ti' t'an Dios. Jini Nicolás ch'oyol ti lum Antioquía bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Che' ñac pejtyel ochemo' bʌ ti' t'an Dios ti ujti i yajcañob jini sietejob, ti' pʌyʌyob tyʌlel ba'an yajcʌbilo' bʌ ajsubt'añob ñumel. Jini docejob ti yʌq'ueyob i c'ʌb ti' pam i jolob. Ti' cha'leyob oración. ");
INSERT INTO ctu76_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ti wen pujqui i t'an Dios. Ti wen oc'ʌyob ochemo' bʌ ti' t'an Dios ya' ti Jerusalén. Jinic tyo i yonlel curajob ti ochiyob ti' t'an Dios je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dios ti' wen yʌq'ue i yutslel i pusic'al jini Esteban. Jiñʌch juntiquil tsa' bʌ aq'uentiyob ti' wenta i pucob waj. Dios ti' wen yʌq'ue i p'ʌtyʌlel cha'an mi' pʌs ñuc bʌ i p'ʌtyʌlel ti' tyojlel quixtyañujob. ");
INSERT INTO ctu76_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Che' jini, winicob mu' bʌ i yajñelob ti' templo israelob Esclavos Libertados bʌ i c'aba' ti wen queji i cʌlʌx pejcañob i bʌ yic'ot Esteban. Ti' lajayob i t'an yic'ot winicob ch'oyolo' bʌ ti Cirene, ti Alejandría, ti Cilicia yic'ot ya' ti colem pañimil Asia bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mach ch'ujbi i ganariñob ti t'an jini yaño' bʌ como Ch'ujul bʌ i Ch'ujlel Dios ti yʌq'ue Esteban bajche' mi' jaq'ue' t'an. ");
INSERT INTO ctu76_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jini yaño' bʌ ti yʌq'ueyob tyaq'uin winicob mu' bʌ i cha'leñob lot, mu' bʌ i lolon yʌle' ti yubiyob che' ñac Esteban ti' cha'le bibajax bʌ t'an ti' contra Moisés jini lac yum ti ñoj oniyix yic'ot ti' contra Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Che' bajche' jini, ti' nijcʌyob ti' contra Esteban jini quixtyañujob yic'ot xñoxob am bʌ ye'tyel, yic'ot ajcʌntisajob mu' bʌ i cha'len cʌntisa bajche' mi' ch'ujbiñob israelob. Che' jini ti' chucuyob Esteban. Ti' pʌyʌyob ochel ba'an ñuco' bʌ ye'tyel ti Junta Suprema bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Che' jini ti' sʌclʌyob yambʌ winicob mu' bʌ i cha'leñob lot, mu' bʌ i lolon jop'beñob i mul je'el. Ti yʌlʌyob: Ili winiqui chonox i chʌc wajlen jini templo yic'ot i mandar Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tsa'ix lojon cubi ti yʌlʌ Esteban cha'an Jesús ch'oyol bʌ ti Nazaret mi quej i jisan ili templo yic'ot mi quejel i q'uex pejtyel tsa' bʌ i xiq'uiyonla lac mele' Moisés. Che' ti' lolon cha'leyob jop't'an. ");
INSERT INTO ctu76_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Che' jini, jini año' bʌ i ye'tyel yic'ot pejtyel ya' bʌ buchulob lajal ti yilʌyob i ñi' i wut Esteban che' bajche' juntiquil ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Che' jini ti' c'ajtibe Esteban jini ñuc bʌ cura: ¿Ñoj melel ba pejtyel chʌncol bʌ yʌlob? Che' ti' c'ajtibe. ");
INSERT INTO ctu76_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban ti' jac'ʌ: Pi'ʌlob, cʌscuñalob. Ñʌch'tyanla. Jini Dios am bʌ i ñuclel ti' pʌsʌ i bʌ ba'an lac yum Abraham ti ñoj oniyix che' ñac ya' tyo an Abraham ti Mesopotamia bʌ i c'aba bʌ pañimil, che' ñac max tyo maj ti chumtyʌl ya' ti Harán. ");
INSERT INTO ctu76_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Dios ti' sube Abraham: Cʌyʌx a lumal yic'ot a pi'ʌlob. Cucux ya' ti yambʌ pañimil ba' mic pʌs'eñet, che' ti subenti Abraham ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Che' jini, ti loq'ui majlel Abraham ba'an caldeojob. Ti majli ti chumtyʌl ya' ti Harán. Ti wi'il che' ñac ti sajti i tyat Abraham, Dios ti' pʌyʌ tyʌlel wʌ'wʌ'i ti ili lum ba' chumulonla wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero Dios mach'an ti yʌq'ue i lum Abraham wʌ'i, mi i sajlic. Pero Dios ti yʌc'ʌ i t'an cha'an mi quejel i yʌq'uentyel lum. Ti yʌlʌ che' sajtyemix Abraham jini i yalobilob mi quej i yʌq'uentyel jini lum wʌ'wʌ'i. Chʌ'ʌch ti subenti Abraham aunque max tyo ba'an i yalobil che' ñac ti subenti. ");
INSERT INTO ctu76_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Che' je'el Dios ti' sube Abraham cha'an i jiñʌjlelob mi quej i chumtyʌlob ti yambʌ pañimil mach bʌ i lumalobic. Mi quej i yotsʌntyelob ti mosojintyel ba' mi quej i chʌc ñusan wocol c'ʌlʌl cuatrocientos jab. ");
INSERT INTO ctu76_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero Dios ti' sube je'el jini Abraham: Pero joñon mi quej cʌq'ueñob i xot' i mul jini mu' bʌ i yotsañob ti mosojintyel a jiñʌjlelob. Ti wi'il mi quej i loq'uelob tyʌlel. Wʌ'i mi quej i ch'ujutisañoñob. Che' ti yʌlʌ Dios che' ñac ti' pejcʌ Abraham. ");
INSERT INTO ctu76_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Che' jini Dios ti' mele trato yic'ot Abraham. Ti xijq'ui Abraham i tsepben i pʌchʌlel alo' bʌ i jiñʌjlel cha'an tsiquil ti yotsʌyob i bʌ ti trato. Jin cha'an che' ñac ti ch'ocʌ i yalobil Abraham, Isaac bʌ i c'aba', Abraham ti' tsepbe i pʌchʌlel che' an jax tyo i cha'an ocho q'uin. Che' ñac winiquix Isaac chʌ'ʌch ti' tsepbe i pʌchʌlel je'el i yalobil Jacob bʌ i c'aba'. Chʌ'ʌch je'el che' winiquix Jacob ti' tsepbe i pʌchʌlel i yalobilob. An doce alo' bʌ i yalobilob jini Jacob. Jiñʌch i tyat jini doce mujch' winicob i jiñʌjlelob Israel. ");
INSERT INTO ctu76_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Lac yumob ti ñoj oniyix jiñʌch i yalobilob Jacob. Jiñobʌch tsa' bʌ i lolon queji i ts'a'q'uelob José bʌ i c'aba' bʌ i yijts'in. Ti' choñoyob winicob tsa' bʌ i pʌyʌyob majlel ti yambʌ pañimil Egipto bʌ i c'aba'. Pero Dios mach'an ti' cʌyʌ José. ");
INSERT INTO ctu76_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Dios ti' wen cotyʌ José che' ñac ti' ñusʌ wocol. Ti' loc'sʌ ti wocol. Dios ti yʌq'ue i ña'tyʌbal. Jini ñuc bʌ yumʌl ti Egipto, Faraón bʌ i c'aba', ti queji i q'uel ti ñuc José. Ti yotsʌ ti ñuc bʌ ye'tyel cha'an pejtyel Egipto yic'ot cha'an pejtyel i yotyot Faraón. ");
INSERT INTO ctu76_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Che' jini ya' ti pañimil tyac Egipto yic'ot Canaán bʌ i c'aba' pejtyelob ti queji i wen ñusañob wi'ñal. Ti queji i wen ñusañob wocol lac yumob ti ñoj oniyix. Mach'añobix i bʌl i ñʌc'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Che' jini ti yubi Jacob che' an tyo lotyol bʌ i cha'añob i bʌl i ñʌc' ya' ti Egipto. Jin cha'an ti' choco majlel i yalobilob cha'an i q'uele'. Jiñʌch che' ñac cojax tyo bʌ ti majliyob. Jini i yalobilob Jacob jiñʌch lac yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ti cha'yajlelel ti majliyob i yʌscuñob, José ti yʌc'ʌ i bʌ ti cʌjñel ti' tyojlelob. Jini ñuc bʌ yumʌl ya' ti Egipto ti queji i ña'tyan majchqui jini i pi'ʌlob José. ");
INSERT INTO ctu76_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Che' jini José ti' xiq'ui i yʌscuñob cha'an i pʌyob tyʌlel i tyat yic'ot pejtyelelob yambʌ i pi'ʌlob. An setenta y cinco che' ti pejtyelelob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jiñʌch bajche' ti ujti cha'an ya' ti majli ti chumtyʌl ti Egipto jini Jacob. Che' ñumenix cabʌl jabil ya'i ti sajti Jacob. Ti wi'il ti sajtiyob i yalobilob je'el. Jiñʌch lac yumob je'el ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Che' ñac ti ñumi cabʌl jabil ti c'axtisʌbentiyob i bʌquel ya' ti lum Siquem bʌ i c'aba'. Ya' ti' ch'ujniyob ti muconibʌl piquil bʌ ti mal tyun tsa' bʌ i wʌ mʌñʌ Abraham ba'an i yalobil juntiquil winic ya' ti Siquem, Hamor bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Bej muc' ti t'an Esteban. Ti yʌlʌ: Ya' ti Egipto ti bej oc'ʌyob lac yumob ti ñoj oniyix. Wen p'ojlemix jini lac yumob ti ñoj oniyix che' ñac ti c'oti i yorojlel Dios mi quej i ts'ʌctisan i t'an tsa' bʌ i wʌ sube Abraham ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Che' jini ti ochi ti ye'tyel yambʌ ñuc bʌ yumʌl. Ma' ti' cʌñʌ José jini ñuc bʌ yumʌl como yoque wajalix ti sajti José che' ñac ti' ch'ʌmʌ ye'tyel jini tsiji' bʌ yumʌl. ");
INSERT INTO ctu76_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jini ñuc bʌ yumʌl ti' wen loti lac yumob ti ñoj oniyix. Cabʌl ti' tyʌc'lʌyob. Ti yʌq'ueyob i wersa cʌyob alo' bʌ i yalobilob ujtyel bʌ i ch'oc an cha'an mi sajtyelob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti ch'ocʌ jini Moisés che' ñac chʌncol tyo i ñusañob cabʌl i tyʌc'lentyel lac yumob ti ñoj oniyix. C'ʌlʌl uxp'ej uw i tyat i ña' ti' cʌñʌtyʌyob Moisés ya' ti yotyot. Dios ti' q'uele ti wen jini ch'oc alʌl Moisés. ");
INSERT INTO ctu76_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Che' ñac ti c'oti i yorojlel che' mach ch'ujbi i chʌc mucu cʌñʌtyan, ti' wersa cʌyʌyob ti sajtyel jini Moisés. Pero jini xc'alʌl bʌ i yalobil ñuc bʌ yumʌl ya' ti Egipto ti' tyaja Moisés che' ñac alʌ tyo. Ti' lotyo. Ti' cosʌ. Ti' pʌyʌ cha'an i yalobilʌch. ");
INSERT INTO ctu76_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jin cha'an ti cʌntisʌnti Moisés ti pejtyel i ña'tyʌbal egiptojob. An i wersajlel i t'an yic'ot i cha'libal. ");
INSERT INTO ctu76_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ti' bej cha'le t'an Esteban. Ti yʌlʌ: Che' ñac ti' tyaja cuarenta i jabilel, Moisés ti' pensali ti' pusic'al yom majlel i jula'an i pi'ʌlob, jiñʌch israelo' bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Che' ñac ya'ani ti yilʌ juntiquil egipto chʌncox i tyʌc'lan israel bʌ winic. Moisés ti yotsʌ i bʌ yic'ot jini israel bʌ cha'an mi' cotyan i pi'ʌl. Ti' tsʌnsʌ jini egipto bʌ. ");
INSERT INTO ctu76_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés ti' lolon ña'tyʌ ti' pusic'al mux i ch'ʌm'eñob isujm i pi'ʌlob. Mux i ña'tyañob cha'an Dios ti' choco majlel Moisés cha'an mi' cotyan, cha'an mi' loc'san ti' c'ʌb i contrajob. Chʌ'ʌch ti' lolon ña'tyʌ Moisés. Pero mach'an ti' ch'ʌmbeyob isujm jini i pi'ʌlob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ti yijc'ʌlel Moisés ti' tyaja cha'tiquil israelob chʌncolo' bʌ ti periyal. Yom i lʌmben i mich'lel. Ti' tiq'uiyob. Ti yʌlʌ: Jatyetla yoque la' pi'ʌlob la' bʌ, ¿chucoch chʌncol la' ts'a'q'uel la' bʌ? che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jini chʌncol bʌ i mich'q'uel i pi'ʌl ti' xit choco Moisés. Ti yʌlʌ: ¿Majchqui ti yʌq'uet ti a wenta cha'an ma' wotsan a bʌ ti yumʌl yic'ot ti melojel cha'añon lojon? ");
INSERT INTO ctu76_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿A wom ba a tsʌnsañon je'el che' bajche' ti a tsʌnsʌ jini egipcio ac'bi? Che' ti' c'ajtibe jini juntiquil. ");
INSERT INTO ctu76_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Che' ñac ti yubi ili t'an, Moisés ti puts'i majlel ti yambʌ pañimil Madián bʌ i c'aba'. Ya' ti chumle che' bajche' ñumel jach muc'. Ya'i ti ch'ocʌ cha'tiquil alo' bʌ yalobilob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ti ñumi cuarenta jab. Che' jini, jump'ej q'uin ya' ti tyʌquin bʌ joch lum lʌc'ʌl ti wits Sinaí bʌ i c'aba' Moisés ti' q'uele mu' ti lejmel juntyejc pimel. Ya' ti c'ʌc'al pimel ti tsictiyi juntiquil ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. ");
INSERT INTO ctu76_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tyoj bʌc'ñʌjel Moisés che' ti yilʌ jini ajtroñel i cha'an Dios. Che' ñac ti' lʌc'ʌ cha'an mi más q'uele' ti yubibe i t'an lac Yum ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Joñon i Dioson Abraham, Isaac yic'ot Jacob, a yumob ti ñoj oniyix. Che' ti yʌlʌ jini ajt'an. Tsitsiña ti queji ti bʌq'uen Moisés. Mach yom i cha' q'uel jini pimel ti caj i bʌq'uen. ");
INSERT INTO ctu76_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jini lac Yum ti' sube. Jocho a zapatos cha'an tsiquil chʌncol a q'uelon ti ñuc como wʌ' mic pejcañet. ");
INSERT INTO ctu76_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tsa'ix j quilʌ bajche' chʌncol i ñusañob wocol jini quixtyañujob c cha'an ya' ti Egipto. Tsa'ix cubibeyob i yuq'uel. Tsa'ix jubiyon tyʌlel cha'an c loc'sañob ti tyʌc'lʌntyel chʌncol bʌ i ñusañob ba'an egipciojob. Cucux che' jini. Mi quej c choquet majlel ya' ti Egipto. Che' ti subenti Moisés ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Dios ti yajcʌ Moisés cha'an i cotyan i pi'ʌlob. Ti pejcʌnti ti ajtroñel i cha'an Dios ch'oyol bʌ ti panchan che' ñac ti yilʌ pimel chʌncol bʌ ti lejmel. Che' jini Dios ti' choco tyʌlel Moisés cha'an mi yochel ti ñuc bʌ ye'tyel ti' tyojlelob i pi'ʌlob cha'an i loc'sañob ti wocol lac yumob ti ñoj oniyix. Chʌ'ʌch ti' mele Dios aunque mach'an ti q'uejli ti ñuc Moisés che' ñac ti subenti: Majchqui ti yʌq'uet ti a wenta cha'an ma' wotsan a bʌ ti yumʌl yic'ot ti melojel cha'añon lojon? ");
INSERT INTO ctu76_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jiñʌch jini Moisés tsa' bʌ i pʌyʌyob loq'uel ti Egipto lac yumob ti ñoj oniyix. Ya'i ti' pʌsʌ ñuc tyac bʌ i p'ʌtyʌlel tyʌlem bʌ ti Dios. Ti' pʌsʌ ñuc tyac bʌ i p'ʌtyʌlel je'el ya' ti colem ja' Chʌchʌc Ja' bʌ i c'aba' yic'ot je'el ya' ti tyʌquin bʌ joch lum. Chʌ'ʌch ti' cha'le c'ʌlʌl cuarenta jab. ");
INSERT INTO ctu76_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jiñʌch jini Moisés tsa' bʌ yʌlʌ: Dios mi quej i yajcan juntiquil israel bʌ winic che' bajche'etla mu' bʌ i yotsan ti juntiquil mu' bʌ i xiq'ue' yʌle' Dios. Che' bajche' ti yajcʌyon Dios mi quej i yajcan jini yambʌ. Yom mi la' ch'ujbin i t'an. Chʌ'ʌch ti' subeyob jini israelo' bʌ jini Moisés. ");
INSERT INTO ctu76_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jiñʌch jini Moisés tsa' bʌ ajni yic'ot lac yumob ti ñoj oniyix che' ya'añob ti tyʌquin bʌ joch lum. Jiñʌch jini Moisés je'el tsa' bʌ pejcʌnti ti juntiquil ajtroñel i cha'an Dios ch'oyol bʌ ti panchan ya' ti jini wits Sinaí bʌ i c'aba' che' ya' much'quibilob lac yumob ti ñoj oniyix. Ti aq'uenti Moisés jini mandar tyac cha'an laj cuxtyʌlel. Jiñʌch jini mu' bʌ laj cubin c'ʌlʌl wale iliyi. ");
INSERT INTO ctu76_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pero jini lac yumob ti ñoj oniyix mach yom i jac'beñob i t'an Moisés. Che' jach ti' ts'a'leyob. Yomob cha' sujtyel ti Egipto. ");
INSERT INTO ctu76_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Che' ñac ma'an poj ya'an Moisés pejtyel quixtyañujob ti' xiq'uiyob juntiquil cura i cha'añob, Aarón bʌ i c'aba'. Ti yʌlʌyob: Com ma' melbeñon lojon dios tyac mu' bʌ lojon q'uech majlel ti lac wut como mach cujila chuqui ti tyumbenti jini Moisés tsa' bʌ i pʌyʌyonla loq'uel ti Egipto. Che' ti yʌlʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Jin cha'an Aarón ti' mele i loc'om saj wacax. Ti' tsʌnsʌyob alʌq'uil cha'an pulem bʌ i majtyan jini i dios. C'ajacñayob i yoj cha'an jini dios tsa' bʌ mejli ti c'ʌbʌl. ");
INSERT INTO ctu76_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Che' jini Dios ti loq'ui majlel ti' tyojlelob. Ti' cʌyʌyob cha'an i ch'ujutisañob ec' tyac am bʌ ti chan. Ti' meleyob che' bajche' ti ts'ijbunti ti jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Jini ti' ts'ijbu: Ixcu jatyetla israelet bʌ la, mach joñonic tsa' bʌ la' tsʌnsʌbeñon alʌq'uil tyac cha'an pulem bʌ c majtyan che' ñac muq'uetla ti xʌmbal ti tyʌquin bʌ joch lum c'ʌlʌl cuarenta jab. ");
INSERT INTO ctu76_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pero ti la' q'uechbe majlel jini pisil bʌ yotyotlel jini la' dios Moloc bʌ i c'aba'. Tsa'ix la' ch'ujutisʌyob jini i yec' jini la' dios Renfán bʌ i c'aba'. Che' jach ti la' ch'ujutisʌyob jini dios tyac melel bʌ ti la' c'ʌb. Jin cha'an mi quej choquetla loq'uel ti la' lumal. Mi quej la' majlel c'ʌlʌl ya' ti junxejlel yambʌ pañimil Babilonia bʌ i c'aba'. Chʌ'ʌch ts'ijbubil ti junilel jini tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Che' ti yʌlʌ jini Esteban. ");
INSERT INTO ctu76_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Bej mu' ti t'an jini Esteban: Ti yʌlʌ: Che' ñac muc'ob tyo ti xʌmbal ya' ti tyʌquin bʌ joch lum lac yumob ti ñoj oniyix, an i cha'añob carpa bʌ otyot ba' mi' ch'ujutisañob Dios. Ti' meleyob carpa bʌ otyot che' bajche' ti' xiq'ui Dios, che' bajche' ti pʌs'enti Moisés ti Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Che' ñac ti sajti Moisés ti wa'choconti Josué ti' q'uexol. Jini ti' pʌyʌyob ochel lac yumob ti ñoj oniyix ti tsiji' bʌ lum tsa' bʌ i wʌ alʌ Dios mi quej i yʌq'uentyelob. Che' ñac ti c'otiyob an i yum jini lum, pero Dios ti' chocoyob loq'uel jini i yum cha'an ochic lac yumob ti ñoj oniyix. An yic'otyob carpa bʌ otyot ba' mi' ch'ujutisañob Dios. C'ʌlʌl chʌ'ʌch an yic'otyob cabʌl jabil, c'ʌlʌl jintyo ti' ch'ʌmʌ ye'tyel ñuc bʌ yumʌl David bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios ti' q'uele ti wen jin ñuc bʌ yumʌl David bʌ i c'aba'. Jini yom i melben i templo Dios ba' mi quej i tyʌlel ti chumtyʌl. Jiñʌch jini Dios tsa' bʌ i ch'ujbi je'el juntiquil i yumob David, Jacob bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero Dios mach'an ti yʌq'ue i mele'. Salomón tyo ti' melbe i templo Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero jini Dios mach'ʌ ba'an i p'isol i ñuclel mach'an mi tyʌlel ti chumtyʌl ti chumlibʌl melel bʌ ti c'ʌbʌl. Dios ti' cha'le t'an ti ti' juntiquil tsa' bʌ i xiq'ui yʌle' Dios. Jini ti yʌlʌ: ");
INSERT INTO ctu76_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jini panchan che' bajche' c buchlib. Jini mulawil che' bajche' saj banca ba' mi cʌc' coc. ¿Bajche' ch'ujbi chumlecon ti templo melel bʌ ti quixtyañujob? Mach ch'ujbi. ¿Bac an ajnibʌl ba' ch'ujbi c'aj coj? Mach'an ba'. ");
INSERT INTO ctu76_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Joñoñʌch tsa' bʌ c mele pejtyel jini. Che' ti yʌlʌ Dios. Chʌ'ʌch ts'ijbubil ti i junilel tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Bej mu' ti t'an jini Esteban ya' ba'añob jini año' bʌ ye'tyel. Ti yʌlʌ: Pero jatyetla, wen tsʌts la' pusic'al. Lajal la' pusic'al, la' chiquin che' bajche' jini mach'ʌ ba'an mi' ch'ujbin Dios. Chʌncox la' chʌc contrajin Ch'ujul bʌ i Ch'ujlel Dios. Lajaletla che' bajche' la' yumob ti ñoj oniyix. ");
INSERT INTO ctu76_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jini la' yumob ti ñoj oniyix ti' lu' tyʌc'lʌ tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix. Ti' tsʌnsʌyob jiñobʌch tsa' bʌ i tyajayob ti t'an jini yoque tyoj bʌ mu' tyo bʌ i tyʌlel ti yʌlʌyob. Wale tsa'ix tyʌli, pero jatyetla ti la' wʌc'ʌ ti' c'ʌb ñuc bʌ ye'tyel. Ti la' wʌc'ʌ ti tsʌnsʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tsa'ix aq'uentiyetla i mandar Dios ti ajtroñel i cha'an Dios loq'uem bʌ ti panchan, pero mach'an mi la' ch'ujbin. Che ti yʌlʌ Esteban che' ñac ti' cha'le t'an ya' ba'añob jini año' bʌ ye'tyel. ");
INSERT INTO ctu76_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jini much'quibilo' bʌ am bʌ ye'tyel ti wen mich'ʌyob che' ñac ti yubiyob i t'an Esteban. Uch'ʌcñayob i yej cha'an i mich'lelob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","But'ul i pusic'al Esteban ti Ch'ujul bʌ i Ch'ujlel Dios. Ti' ch'uj q'uele letsel ti panchan. Ti' q'uele i ñuclel Dios yic'ot Jesús ya' wa'al ti' ñoj Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Esteban ti yʌlʌ: Q'uelela. Mij q'uel ya' ti jajmi ya' ti panchan. Ya' wa'al ti' ñoj Dios jini i Pi'ʌl Quixtyañu. ");
INSERT INTO ctu76_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Che' jini, ti' mʌcʌyob i chiquin ti' c'ʌb. Ti' cha'leyob c'am bʌ oñel cha'an mich'ob. Ti' jojmi chucob. ");
INSERT INTO ctu76_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ti' pʌyʌyob loq'uel ya' ti ti' lum. Jini tsa' bʌ yubiyob i t'an Esteban ti' wel chocoyob i bujc ti yeba yoc juntiquil colem alob Saulo bʌ i c'aba' cha'an mi' cʌñʌtyʌbeñob. Che' jini ti' juluyob ti tyun jini Esteban. ");
INSERT INTO ctu76_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Esteban ti' cha'le oración che' ñac chʌncolob tyo i julob. Ti yʌlʌ: C Yum Jesús, ch'ʌmbeñon c ch'ujlel. Che' ti yʌlʌ ti oración Esteban. ");
INSERT INTO ctu76_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ti ñocle ti lum Esteban. Ti c'am bʌ t'an ti yʌlʌ: C Yum, mach a wʌq'uen i xot' i mul ili quixtyañujob, che'en. Che' ñac ti ujti i yʌle' ti sajti. ");
INSERT INTO ctu76_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Weñʌch ti yubi Saulo che' ñac ti' tsʌnsʌyob Esteban. Ti jini jach bʌ q'uin ti queji i cabʌl tyʌc'lʌntyel pejtyel ochemo' bʌ ti' t'an Dios ya' ti Jerusalén. Jin jach yajcʌbilo' bʌ ajsubt'añob ñumel ti cʌyleyob ya'ya'i. Pejtyel yaño' bʌ ochemo' bʌ ti' t'an Dios ti puts'iyob loq'uel. C'ʌlʌl ti puts'iyob ti pañimil Judea bʌ i c'aba' yic'ot ti pañimil Samaria bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Cha'tiquil uxtiquil winicob chʌc c'ajalob i cha'an Dios ti' ch'ujñiyob Esteban. Ti wen uq'uiyob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero Saulo ti' bej tyʌc'lʌyob jini ochemo' bʌ ti' t'an Dios. Ti ochi ti otyotyel tyac. Ti' chucuyob. Ti yotsʌyob ti cʌchol winicob yic'ot x'ixicob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pero jini tsa' bʌ puts'iyob loq'uel ti Jerusalén ti' subuyob ñumel i t'an Dios ba'ical jach ti majliyob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Juntiquil tsa' bʌ puts'i Felipe bʌ i c'aba' ti majli ti pañimil Samaria bʌ i c'aba'. Ya'i ti queji i wen subeñob cha'an Cristo. ");
INSERT INTO ctu76_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ya'i ti' much'quiyob i bʌ cabʌl quixtyañujob. Ti' lu' wen ñʌch'tyʌyob pejtyel i t'an Felipe. Ti' q'ueleyob je'el ñuc tyac bʌ i p'ʌtyʌlel Dios tsa' bʌ pʌs'enti ti' cha'libal Felipe. ");
INSERT INTO ctu76_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Cabʌl tyʌc'lʌbilo' bʌ ti xiba ti lajmisʌntiyob. Ti' cha'le c'am bʌ oñel jini xibajob che' ti loq'ui ti' pusic'al c'amo' bʌ. Cabʌl mach'ʌ ba'an i c'ʌjnibal yoc i c'ʌb ti lajmisʌnti je'el. ");
INSERT INTO ctu76_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Wen c'ajacñayob i yoj pejtyel quixtyañu ya' ti lum cha'an ti caj chʌ bʌ ti yilʌyob, yic'ot chʌ bʌ ti yubiyob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero ya'an juntiquil winic Simón bʌ i c'aba'. Wen yujil wujt jini Simón. Cabʌl ti' loti año' bʌ ti Samaria. Ti' wen chan isʌ i bʌ ti' tyojlelob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pejtyel quixtyañujob ti' lu' ñʌch'tyʌbeyob i t'an jini Simón jini año' ye'tyel yic'ot je'el jini mach'ʌ ba'an i ña'tyʌbal. Añʌch ñuc bʌ i p'ʌtyʌlel Dios yic'ot, ti' lolon ña'tyʌyob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Chʌ'ʌch ti' ch'ujbibeyob i t'an Simón como c'ʌlʌl wajali tyoj bʌc'ñʌjel ti yubiyob cha'an ti wujtyʌntyel. ");
INSERT INTO ctu76_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe ti' wen sube pejtyel quixtyañujob cha'an i yumintyel Dios yic'ot cha'an Jesucristo. Cabʌl winicob x'ixicob ti' ch'ʌmʌyob ja' che' ñac ti' ch'ujbiyob ili t'an ti' pusical. ");
INSERT INTO ctu76_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jinic tyo jini Simón ti' ch'ujbi je'el. Ti' ch'ʌmʌ ja'. Ti queji i pi'len ti xʌmbal Felipe. Tyoj bʌc'ñʌjel ti yubi je'el che' ñac ti yilʌ ñuc tyac bʌ i p'ʌtyʌlel Dios tsa' bʌ pʌs'enti ti Felipe. ");
INSERT INTO ctu76_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Che' jini, che' ñac ti yubiyob jini yajcʌbilo' bʌ ajsubt'añob ñumel ya' ti Jerusalén cha'an ti' ch'ujbiyob i t'an Dios ya' ba'añob ti Samaria ti' chocoyob majlel Pedro yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Che' ñac ti c'otiyob ti Samaria ti' tyajayob ti oración jini ochemo' bʌ ti' t'an Dios ya'ya'i cha'an mi yʌq'uentyelob Ch'ujul bʌ i Ch'ujlel Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Como max tyo ba'an ti aq'uentiyob Ch'ujul bʌ i Ch'ujlel Dios jini año' bʌ ti Samaria. Che' jax tyo ti' ch'ʌmʌyob ja' cha'an tsiquil ti' ch'ujbiyob Jesús. ");
INSERT INTO ctu76_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Che' jini Pedro yic'ot Juan ti yʌq'ueyob i c'ʌb ti' pam i jol jini ochemo' bʌ ti' t'an Dios. Che' jini, ti aq'uentiyob Ch'ujul bʌ i Ch'ujlel Dios. Ti ochi ti' pusic'alob. ");
INSERT INTO ctu76_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jini Simón ti yilʌ che' ti aq'uentiyob Ch'ujul bʌ i Ch'ujlel Dios che' ñac yajcʌbilo' bʌ ajsubt'añob ñumel ti yʌc'ʌyob i c'ʌb ti' pam i jol jini ochemo' bʌ ti' t'an Dios. Jin cha'an Simón ti' jop'o i yʌq'uen tyaq'uin Pedro yic'ot Juan. ");
INSERT INTO ctu76_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ti' subeyob: Aq'ueñon je'el jini a p'ʌtyʌlel cha'an che' mi cʌc' j c'ʌb ti' pam i jol majchical jach, mi quej i yʌq'uentyel Ch'ujul bʌ i Ch'ujlel Dios je'el. Che' ti lolon alʌ Simón. ");
INSERT INTO ctu76_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro ti' sube: Jatyet yic'ot a tyaq'uin mi quej i jilel como ma' lolon ña'tyan ch'ujbi a mʌn jini ñuc bʌ i majtyan Dios. ");
INSERT INTO ctu76_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Mach ch'ujbi a wotsan a bʌ ti ili toñel. Mach a cha'anic como mach tyoj a pusic'al ti' tyojlel Dios, che'en. ");
INSERT INTO ctu76_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Cʌyʌx leco bʌ a pensal. C'ajtiben Dios ti wocol t'an mi mux i ñusʌbeñet tsa' bʌ a ña'tyʌ ti a pusic'al. ");
INSERT INTO ctu76_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Che' bajche' cʌchʌlet ti a simaronlel mij q'uelet. Che' bajche' but'ul a pusic'al ti i mulʌntyel lojon c p'ʌtyʌlel ti Dios. Che' ti yʌlʌ Pedro. ");
INSERT INTO ctu76_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Che' jini Simón ti yʌlʌ: Pejcʌbeñon Dios cha'an mach saj ujtic bajche' ti a wʌlʌ. Che' ti yʌlʌ Simón. ");
INSERT INTO ctu76_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Che' jini, Pedro yic'ot Juan ti' wen subuyob i t'an Dios. Cabʌl ti' subeyob bajche' ti' mele Jesús tsa' bʌ i lu' ilʌyob. Che' jini, ti queji i cha' sujtyelob majlel ti Jerusalén. Ti' subuyob i t'an Dios ya' ti cabʌl saj lum tyac ya' ti bij. ");
INSERT INTO ctu76_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Che' jini, che' ñac sujtyemobix Pedro yic'ot Juan, Dios ti' choco tyʌlel ya' ba'an Felipe juntiquil ajtroñel i cha'an Dios ch'oyol bʌ ti panchan. Jini ti' sube Felipe: Tyejchen. Cucu ya' ti sur ti bijlel Jerusalén mu' bʌ i jubel majlel ya' ti Gaza. Jiñʌch jini bij mu' bʌ i ñumel ti tyʌquin bʌ joch lum. Che' ti subenti Felipe. ");
INSERT INTO ctu76_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe ti tyejchi. Ti loq'ui majlel. Ya' ti bij ti' tyaja juntiquil winic ch'oyol bʌ ti yambʌ colem pañimil Etiopía bʌ i c'aba'. Eunuco jini winic. An ñuc bʌ ye'tyel cha'an mi' cʌñʌtyan pejtyel i tyaq'uin x'ixic bʌ yumʌl ti Etiopía, Candace bʌ i c'aba'. Tsajni ti Jerusalén cha'an i ch'ujutisan Dios jini winic. ");
INSERT INTO ctu76_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Buchul ti c'otyajax bʌ carreta. Chʌncox i sujtyel majlel ti' lumal. Chʌncox i q'uel tsa' bʌ ts'ijbu juntiquil tsa' bʌ i xiq'ui yʌle' Dios ti ñoj oniyix Isaías bʌ i c'aba'. ");
INSERT INTO ctu76_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jini Ch'ujul bʌ i Ch'ujlel Dios ti' sube Felipe: Yom ma' lʌq'ue' jini carreta. Tyemel ma' majlel a wic'ot. ");
INSERT INTO ctu76_vpl VALUES ("AC8_30","074_8_30","ACT","8","