﻿USE sofia;
DROP TABLE IF EXISTS sofia.ctpNT_vpl;
CREATE TABLE ctpNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ctpNT_vpl WRITE;
INSERT INTO ctpNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nde ndaꞌaǎn sa ñaꞌan nin nchga nten nu ngwa ayman ꞌin Jesucristo, chaꞌ nten taꞌa ayman David lka yu. Kwiꞌ ngwañaꞌan lka yu nten taꞌa ayman Abraham, ni siya sꞌni ꞌa mdiꞌin yu kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ayman Abraham kanꞌ ngwa sti Isaac; loꞌo ayman Isaac kanꞌ ngwa sti Jacob; loꞌo ayman Jacob kanꞌ ngwa sti Juda loꞌo nchga taꞌa ngula yu; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","loꞌo ayman Juda kanꞌ ngwa sti Fares loꞌo Zara, loꞌo Tamar ngwa naan jyaꞌan neꞌ kanꞌ bra kanꞌ. Loꞌo ayman Fares kanꞌ ngwa sti Esrom; loꞌo ayman Esrom kanꞌ ngwa sti Aram; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","loꞌo ayman Aram kanꞌ ngwa sti Aminadab; loꞌo ayman Aminadab kanꞌ ngwa sti Naasón; loꞌo ayman Naasón kanꞌ ngwa sti Salmón; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","loꞌo ayman Salmón kanꞌ ngwa sti Booz, loꞌo Rahab ngwa naan jyaꞌan Booz kanꞌ bra kanꞌ. Loꞌo ayman Booz kanꞌ ngwa sti Obed, loꞌo Rut ngwa naan jyaꞌan Obed kanꞌ bra kanꞌ. Loꞌo ayman Obed kanꞌ ngwa sti Isaí; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","loꞌo ayman Isaí kanꞌ ngwa sti ree David; loꞌo ayman ree David ngwa sti Salomón, loꞌo jyaꞌan Salomón kanꞌ ngwa nu kunaꞌan nu ngwa kwilyoꞌo ayman Urías ti kulo la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Loꞌo ayman Salomón kanꞌ ngwa sti Roboam; loꞌo ayman Roboam kanꞌ ngwa sti Abías; loꞌo ayman Abías kanꞌ ngwa sti Asa; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","loꞌo ayman Asa kanꞌ ngwa sti Josafat; loꞌo ayman Josafat kanꞌ ngwa sti Joram; loꞌo ayman Joram kanꞌ ngwa sti Uzías; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","loꞌo ayman Uzías kanꞌ ngwa sti Jotam; loꞌo ayman Jotam kanꞌ ngwa sti Acaz; loꞌo ayman Acaz kanꞌ ngwa sti Ezequías; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","loꞌo ayman Ezequías kanꞌ ngwa sti Manasés; loꞌo ayman Manasés kanꞌ ngwa sti Amón; loꞌo ayman Amón kanꞌ ngwa sti Josías; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","loꞌo ayman Josías kanꞌ ngwa sti Jeconías loꞌo taꞌa ngula yu bra kanꞌ. Kanꞌ ndyaa loꞌo neꞌ Babilonia ꞌin neꞌ Israel presu la kichen tyi neꞌ tijyuꞌ; niꞌ ñaꞌan chkwan ꞌin neꞌ Babilonia ndyaa kaꞌan ꞌa neꞌ Israel bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nde kichen tijyuꞌ kanꞌ ngula Salatiel sñiꞌ ayman Jeconías kanꞌ bra kanꞌ; loꞌo ayman Salatiel kanꞌ ngwa sti Zorobabel; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","loꞌo ayman Zorobabel kanꞌ ngwa sti Abiud; loꞌo ayman Abiud kanꞌ ngwa sti Eliaquim; loꞌo ayman Eliaquim kanꞌ ngwa sti Azor; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","loꞌo ayman Azor kanꞌ ngwa sti Sadoc; loꞌo ayman Sadoc kanꞌ ngwa sti Aquim; loꞌo ayman Aquim kanꞌ ngwa sti Eliud; ");
INSERT INTO ctpNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","loꞌo ayman Eliud kanꞌ ngwa sti Eleazar; loꞌo ayman Eleazar kanꞌ ngwa sti Matán; loꞌo ayman Matán kanꞌ ngwa sti Jacob. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Loꞌo sñiꞌ ayman Jacob ni, kanꞌ ngwa Se nu ngwa kwilyoꞌo Liya jyaꞌan Jesús bra kanꞌ. Kwiꞌ ngwañaꞌan, Krixtu naan Jesús kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ngwañaꞌan naan ayman kanꞌ, tii lkwa ta nten wa mdijin neꞌ xa nu ti luꞌu Abraham sa ñaꞌan bra nu ngula ayman David. Loꞌo xka tyii lkwa ta nten mdijin neꞌ xa nu ti luꞌu ayman David, sa ñaꞌan bra nu yaa loꞌo neꞌ xka laꞌa tsuꞌ ꞌin neꞌ Israel nde kichen tyi neꞌ, msuꞌwa neꞌ kanꞌ ꞌin neꞌ Israel niꞌ ñaꞌan chkwan nde kichen Babilonia bra kanꞌ. Loꞌo mdijin xka tyii lkwa ta nten, kanꞌ ngula nu lka Krixtu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nde ndaꞌaǎn sa ñaꞌan ngwa bra nu ngula Jesucristo. Wa mskanꞌ chaꞌ ꞌin Liya kanꞌ, chaꞌ kaja kwilyoꞌo loꞌo Se nu lka sñiꞌ Jacob kanꞌ. Ja ya tyiꞌin Liya seꞌen ndiꞌin Se loꞌo mgii tiꞌ Liya kanꞌ, chaꞌ wa nsuꞌwi sñiꞌ; kanꞌ lka tñan nu wa yꞌni Tyiꞌi Ndiose ykwiꞌ, chaꞌ ngwa tnan Liya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Se kanꞌ ni, tꞌnan tiꞌ yu ꞌin Liya, chañi chaꞌ nsuꞌwi tiye yu ꞌin nu kunaꞌan kanꞌ. Bra wa ynan yu chaꞌ kanꞌ, ja ngwa tiꞌ yu ta yu chaꞌ jyuꞌu ꞌin Liya, ni siya ja kaja kwilyoꞌo yu loꞌo siꞌya sñiꞌ, mdaꞌan chaꞌ tiye yu; tyii chaꞌ ꞌin yu loꞌo ngwañaꞌan ti, nka tiye yu, chaꞌ ja ngwa tiꞌ yu xtya yu kiꞌya ꞌin nu kunaꞌan kanꞌ tuꞌ naꞌan tñan. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bra nu mdaꞌan chaꞌ tiye yu, ni chaꞌ ngwa ngwañaꞌan, bra kanꞌ mdoꞌo tukwa ska angajle seꞌen ndiꞌin yu, ykwiꞌ sla yu bra kanꞌ. Ykwiꞌ angajle kanꞌ loꞌo yu: ―Se ―ndukwin angajle kanꞌ ꞌin yu―, neꞌ taꞌa ayman David lka nuꞌwin ―ndukwin―. Ja kutseen kaja kwilyoꞌoo loꞌo Liya, chaꞌ kan Liya tyiꞌin naꞌan tyii. Siꞌi tñan kuxi yꞌni Liya siyaꞌ ti, tñan nu yꞌni Tyiꞌi Ndiose lka chaꞌ tyiꞌin sñiꞌ Liya ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bra nu kala sñiꞌ nu kunaꞌan kanꞌ, kuwiꞌ kiꞌyu kala ꞌin. Loꞌo xa nu tyijin nin kuwiꞌ kanꞌ, bra kanꞌ ka naan kuwiꞌ Jesús. Loꞌo Jesús ni, kanꞌ lka nu kulaa ꞌin nten chalyuu nu ndiꞌin chaꞌ ꞌin loꞌo Ndiose, chaꞌ ka katin kiꞌya nu ndukwi neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kwiꞌ ngwañaꞌan ngwa chaꞌ kanꞌ, sa ñaꞌan nu wa ykwiꞌ Ndiose loꞌo nten nu ngwa ti sꞌni sa ñaꞌan ka chaꞌ kanꞌ. Sꞌni kanꞌ ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten, ngwaꞌan neꞌ chaꞌ kanꞌ lo kityi. Loꞌo nde lka chaꞌ nu ngwaꞌan neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ka tnan ska nu kunaꞌan kuneꞌ nu ti ji xuꞌwi kiꞌyu ꞌin, loꞌo bra kanꞌ tyiꞌin ska kuwiꞌ kiꞌyu ꞌin; Emanuel chkwiꞌ neꞌ ꞌin kuwiꞌ kanꞌ. Ngwañaꞌan ndukwa chaꞌ lo kityi, kanꞌ chaꞌ ngwañaꞌan ngwa ꞌin Liya bra kanꞌ. Nu nchkwiꞌ neꞌ Emanuel ni, nde lka chaꞌ kanꞌ chaꞌtñan: Suꞌwa ndiꞌin Ndiose loꞌoan. ");
INSERT INTO ctpNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bra nu mxaa tiꞌ Se, mdoꞌo yu ndyaa yu seꞌen ndiꞌin Liya chaꞌ kaja kwilyoꞌo yu loꞌo, sa ñaꞌan nu wa ykwiꞌ angajle kanꞌ loꞌo yu. Bra kanꞌ mdiyan loꞌo yu ꞌin Liya naꞌan tyi yu, ");
INSERT INTO ctpNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","loꞌo ja yijaꞌ yu loꞌo sa ñaꞌan bra nu wa ngula sñiꞌ. Bra wa ngula kuwiꞌ, bra kanꞌ ngwa naan yu Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ti kwiꞌ bra nu ngula Jesús nde kichen Belén, ska yu kula nu naan Herodes ngwa ndloo la ꞌin nasiyun kanꞌ. La lo yuu ꞌin Judea, la kanꞌ ndiꞌin kichen Belén kanꞌ. Loꞌo mdiyan chinꞌ nten nu tiya ꞌa nde Judea kanꞌ; mdoꞌo neꞌ tiya kanꞌ nde kichen tijyuꞌ, nde seꞌen ndyoꞌo tukwa kwichaa, mdiyan neꞌ kichen Jerusalén bra kanꞌ. Ykwiꞌ neꞌ tiya kanꞌ loꞌo nten nu ndyukwa taꞌa neꞌ tuwiin: ");
INSERT INTO ctpNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","―¿La nde yaꞌ ndiꞌin kuwiꞌ nu ngula nu ngwa xkanꞌ ti a? ―ndukwin neꞌ―. Ree ꞌwan neꞌ judío lka kuwiꞌ kanꞌ ―ndukwin neꞌ―. Wa naꞌan ba kwii kulasiin tlyu nu tka ndukwi ti niꞌ kwan chaꞌ ꞌin kuwiꞌ kanꞌ, kanꞌ chaꞌ mdiyan ba nde re chaꞌ kuꞌni tnun ba ꞌin kuwiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Loꞌo ree Herodes ni, ytsen ꞌa yu bra nu ynan yu chaꞌ nu ykwiꞌ neꞌ tiya kanꞌ, chaꞌ kuꞌni tnun neꞌ ꞌin xka ree, mskeꞌ tiꞌ yu. Kwiꞌ ngwañaꞌan nchga neꞌ kichen Jerusalén, ytsen ꞌa neꞌ sa ñaꞌan kuꞌni ree Herodes bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Loꞌo kanꞌ msiꞌya ree Herodes kanꞌ ꞌin nchga sti joꞌo nu lka ndloo la, loꞌo ꞌin mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa, chaꞌ kan neꞌ seꞌen ndiꞌin yu. Mnichaꞌ ree kanꞌ ꞌin neꞌ bra kanꞌ: ―¿Ja jlyo tiꞌ wan la nde nchkwiꞌ kityi chaꞌ kala Krixtu a? ―ndukwin ree ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","―Kala Ni nde kichen Belén nde lo yuu ꞌin Judea re ―ndukwin neꞌ ꞌin ree―. Nde ndiya chaꞌ nu ndukwa lo kityi ꞌin Ndiose: ");
INSERT INTO ctpNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Kichen xuwe ti lka Belén nu ndiya seꞌen ndlo Judea tñan, ndukwin Ndiose. Kichen tyi ska nten nu tnun ꞌa chaꞌ ka ꞌin, ka kichen kanꞌ, ni siya kichen xuwe ti lka ni, ndukwin Ni. Ka yu kiꞌyu kanꞌ ska nu tyuun loo la ti, loꞌo ñaꞌansiin yu ꞌin neꞌ Israel ꞌñaǎn. Ngwañaꞌan ndukwa chaꞌ lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bra wa ynan ree Herodes chaꞌ kanꞌ, bra kanꞌ mnan ti msiꞌya yu ꞌin neꞌ tiya kanꞌ, chaꞌ kan neꞌ seꞌen ndiꞌin yu chaꞌ chkwiꞌ yu loꞌo neꞌ. Mnichaꞌ ree ꞌin neꞌ kanꞌ bra kanꞌ, sa ñaꞌan bra naꞌan neꞌ mdoꞌo tukwa kwii kulasiin kanꞌ nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Bra wa ytsaꞌ neꞌ chaꞌ kanꞌ ꞌin ree, bra kanꞌ ykwiꞌ ree loꞌo neꞌ chaꞌ tsaa neꞌ nde kichen Belén. ―Yaa lya wan ―ndukwin ree ꞌin neꞌ tiya kanꞌ―, yaa naꞌan wan nde ndukwa naꞌan tyi sti kuwiꞌ kanꞌ ―ndukwin―. Bra nu tyija naꞌan kanꞌ ꞌwan, bra kanꞌ tyaan wan seꞌen ndiꞌiǐn xiyaꞌ chaꞌ ka biyaꞌ tiǎnꞌ la nde yaꞌ ndiya kuwiꞌ kanꞌ. Loꞌoǔn tsaꞌaǎn kuꞌni tnuǔn ꞌin kuwiꞌ kanꞌ, lka tiyeěn. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mdoꞌo neꞌ ndyaa neꞌ bra wa ynan neꞌ chaꞌ nu ykwiꞌ ree loꞌo neꞌ bra kanꞌ. Xiyaꞌ naꞌan neꞌ kwii kulasiin kanꞌ laja nu ndyaa neꞌ tuwiin chaꞌ tsaa neꞌ nde kichen Belén, ti kwiꞌ kwii tlyu nu naꞌan neꞌ ti kulo nde seꞌen ndyoꞌo tukwa kwichaa. Ngwaꞌu kwii kulasiin kanꞌ ꞌin neꞌ la nde ndukwa naꞌan seꞌen ndiꞌin kuwiꞌ, ndyaa tukwi kwii tlyu kanꞌ seꞌen ndukwa naꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Suꞌwe ꞌa ngwa tiye neꞌ chaꞌ naꞌan neꞌ kwii kulasiin kanꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yten neꞌ niꞌ ñaꞌan kanꞌ bra kanꞌ, naꞌan neꞌ kuwiꞌ loꞌo Liya jyaꞌan kuwiꞌ. Bra ti mduun xtyinꞌ neꞌ tiya kanꞌ seꞌen nskwa kuwiꞌ chaꞌ kuꞌni tnun neꞌ ꞌin. Loꞌo mxtiꞌ neꞌ yuꞌwa ꞌin neꞌ chaꞌ ta neꞌ lomstan ꞌin kuwiꞌ kanꞌ; mda neꞌ oro ꞌin kuwiꞌ kanꞌ, mda neꞌ ynan nu kaꞌan ꞌa ngaꞌan, loꞌo mda neꞌ mirra nu lka sete xi tyiꞌi ꞌin kuwiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bra nu ndyaa yijaꞌ neꞌ, ykwiꞌ sla neꞌ bra kanꞌ; ykwiꞌ Ndiose loꞌo neꞌ chaꞌ ja tsaa ꞌa neꞌ seꞌen ndiꞌin ree Herodes kanꞌ xiyaꞌ, chaꞌ kwiñi ꞌa yu. Kanꞌ chaꞌ msñi neꞌ xka tuwiin chaꞌ ndyaan neꞌ kichen tyi neꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Bra nu wa mdoꞌo neꞌ tiya kanꞌ ndyaa neꞌ kichen tyi neꞌ, bra kanꞌ ykwiꞌ sla Se. Mdoꞌo tukwa ska angajle laja sla yu, ykwiꞌ loꞌo yu bra kanꞌ: ―Xaa tiiꞌ ―ndukwin angajle kanꞌ ꞌin Se―. Tyituun, xnaan lyaa ―ndukwin―, tsaa loꞌoo ꞌin jyaꞌan kuwiꞌ tijyuꞌ la lo yuu ꞌin Egipto. Tyiꞌin wan nde kwa sa ñaꞌan bra nu katsaǎnꞌ ꞌiin chaꞌ ka tyaan wan nde nasiyun re xiyaꞌ. Tlá ꞌa ree Herodes kanꞌ; wa kan ti yu kichen re chaꞌ kunaan yu ꞌin kuwiꞌ ꞌwan, chaꞌ kujwi yu ꞌin kuwiꞌ ꞌwan, nchka tiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Bra ti mxaa tiꞌ Se, ndyaa loꞌo ꞌin kuwiꞌ loꞌo jyaꞌan kuwiꞌ xa nu ti tla; ndyaa neꞌ nde Egipto bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nganun neꞌ la kanꞌ sa ñaꞌan bra nu ngujwi Herodes, nu ree tlá kanꞌ. Loꞌo nde lka ti kwiꞌ chaꞌ nu wa ykwiꞌ ayman kula loꞌo nten chabiyaꞌ ꞌin Ndiose nu ngwa sꞌni: “Siꞌyaǎn ꞌin Sñiěnꞌ chaꞌ tyoꞌo lo yuu nu kwenta ꞌin Egipto, chaꞌ tyaan yu kichen tyi yu xiyaꞌ” ndukwin Ndiose nu nka Xꞌnaan. Kanꞌ chaꞌ ngwañaꞌan ngwa ꞌin neꞌ bra kanꞌ, chaꞌ ndyaa neꞌ nde Egipto. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Loꞌo ree Herodes kanꞌ ni, msinꞌ ꞌa tiꞌ yu bra nu mgii tiꞌ yu chaꞌ ja mdijin ꞌa neꞌ tiya kanꞌ xiyaꞌ seꞌen ndiꞌin yu. Ngulo ree kanꞌ tñan ꞌin msu ꞌin yu bra kanꞌ, chaꞌ tsaa neꞌ kujwi neꞌ ꞌin nchga kuwiꞌ kiꞌyu nu nsuꞌwi kichen Belén, nchga kuwiꞌ nu ja ya tyii snan yijan; kwiꞌ kujwi neꞌ ꞌin nchga kuwiꞌ kiꞌyu nu ndiꞌin kichen xuwe kwiꞌ seꞌen ti. Wa jlyo tiꞌ ree chaꞌ kuwiꞌ kanꞌ ja ya tyii snan yijan, chaꞌ wa ytsaꞌ neꞌ tiya kanꞌ chaꞌ sa kwa bra naꞌan neꞌ kwii kulasiin kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ti kwiꞌ ti chaꞌ ykwiꞌ ayman Jeremías nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose nu ngwa sꞌni. Nde ndiya chaꞌ ngwaꞌan yu lo kityi: ");
INSERT INTO ctpNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Lye ꞌa ngiꞌni xiꞌin nten kichen Rama; msiꞌya ꞌa neꞌ, nganan ꞌa neꞌ, chaꞌ ngujwi sñiꞌ Raquel. Nganan ꞌa nu kunaꞌan kanꞌ, chaꞌ wa ngujwi sñiꞌ neꞌ. Loꞌo ja tukwin ꞌa ngwa kuꞌni chaꞌ ka tiin chaꞌ nganan nu kunaꞌan kanꞌ. Ngwañaꞌan lka chaꞌ ngwaꞌan yu kanꞌ lo kityi sꞌni, ni siya ja ya ka chaꞌ kanꞌ nu ti luꞌu ayman kanꞌ. Kanꞌ chaꞌ ngwañaꞌan ngwa ꞌin neꞌ Belén, nganan ꞌa neꞌ chaꞌ ngujwi sñiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Chunꞌ ndiꞌin la, ngujwi ree Herodes kanꞌ bra kanꞌ. Kanꞌ mdoꞌo tukwa ska angajle seꞌen ndiꞌin Se laja sla yu, chaꞌ ti ndiꞌin Se lo yuu ꞌin Egipto: ");
INSERT INTO ctpNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Xaa tiiꞌ ―ndukwin angajle ꞌin yu―, tyituun lya wan, chaꞌ tyaa wan loꞌo kuwiꞌ loꞌo jyaꞌan kuwiꞌ nde nasiyun Israel xiyaꞌ ―ndukwin―, chaꞌ wa ngujwi yu tlá nu ngwa tiꞌ kujwi ꞌin kuwiꞌ nu ngwa xkanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Bra kanꞌ mdyituun Se, ndyaa loꞌo kuwiꞌ loꞌo jyaꞌan kuwiꞌ ngala neꞌ nde nasiyun Israel xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kanꞌ ynan yu chaꞌ sñiꞌ ayman Herodes ngulo tñan nde Judea, ti kwiꞌ sñiꞌ yu nu naan Arquelao lka yu kanꞌ; kanꞌ chaꞌ ytsen chinꞌ Se bra kanꞌ. Xiyaꞌ ykwiꞌ sla yu sa ñaꞌan kuꞌni yu, kanꞌ chaꞌ ndyaa neꞌ nde lo yuu ꞌin Galilea, ");
INSERT INTO ctpNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ngala neꞌ kichen Nazaret bra kanꞌ. Ti kwiꞌ ti chaꞌ ykwiꞌ ayman nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose nu ngwa sꞌni, bra nu ykwiꞌ neꞌ chaꞌ neꞌ Nazaret ka nu lka Krixtu. Ngwañaꞌan ykwiꞌ ayman kanꞌ nu ngwa sꞌni, kanꞌ chaꞌ ngwañaꞌan yꞌni neꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wa mdiya yaꞌ mdyisnan Xuwa ngwaꞌu yu ꞌin nten nu mdaꞌan seꞌen ndiꞌin yu ska ti yu niꞌ kixinꞌ; mdukwatya yu ꞌin neꞌ bra kanꞌ. Ti kwiꞌ lo yuu ꞌin Judea ndiꞌin yu; wtyi ꞌa yuu seꞌen ndiꞌin Xuwa kanꞌ, ndiꞌin ꞌa kee, loꞌo ja tukwin ndiꞌin nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","―Ka jyuꞌu tiꞌ wan ―ndukwin Xuwa ꞌin neꞌ―, kulaa yaꞌ wan chaꞌ kuxi nu ngiꞌni wan ―ndukwin yu―. Wa tyisnan ti chaꞌ ka Ndiose ndloo la niꞌ kasiya ꞌin nten chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Loꞌo Xuwa, lka yu ska nten nu wa ykwiꞌ ayman kula Isaías sꞌni chaꞌ ꞌin. Nde ndiya chaꞌ nu ngwaꞌan yu kula lo kityi: Kwen xiꞌya ska nten niꞌ kixinꞌ: “Slaa lya wan ska tuwiin seꞌen kan nu nka Xꞌnaan, xñi suꞌwe wan tuwiin seꞌen tyijin yu” ndukwin nten kanꞌ. Ngwañaꞌan ngwaꞌan ayman kanꞌ chaꞌ ꞌin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Loꞌo Xuwa kanꞌ ni, lkuꞌ yu ska teꞌ kichanꞌ camello, loꞌo nchkanꞌ kijin siꞌ yu; nchku yu skuꞌ loꞌo kwiñaꞌ kwitun. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Loꞌo bra kanꞌ ndyoꞌ tiꞌin kaꞌan nten seꞌen ndiꞌin yu; mdiyan neꞌ kichen Jerusalén nde kwa, loꞌo neꞌ nchga kichen xuwe nu kwenta ꞌin Judea kanꞌ, loꞌo neꞌ nu ndiꞌin kwiꞌ seꞌen ti tuꞌwa chku Jordán, taꞌa neꞌ mdiyan neꞌ seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mdukwatya Xuwa ꞌin neꞌ kanꞌ lo tyiꞌa chku Jordán bra kanꞌ, mdukwatya yu ꞌin nchga nten nu nchkwiꞌ chaꞌ ngwa jyuꞌu tiꞌ ꞌin chaꞌ kuxi nu ngiꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ngwa ska tsan naꞌan Xuwa ꞌin tyun neꞌ fariseo loꞌo neꞌ saduceo bra kanꞌ; kti ꞌa ngiꞌni neꞌ kanꞌ loꞌo Ndiose, nxkeꞌ tiꞌ neꞌ, lye ꞌa ngiꞌni siyeꞌ neꞌ loꞌo taꞌa nten neꞌ. Loꞌo chinꞌ neꞌ kanꞌ mdiyan neꞌ chaꞌ tukwatya Xuwa ꞌin neꞌ, loꞌo ja ndiya tiꞌ Xuwa chaꞌ ngwañaꞌan ngiꞌni neꞌ kanꞌ. ―Sa ñaꞌan lka kunan tlá, kwiꞌ ngwañaꞌan lka wan ―ndukwin Xuwa ꞌin neꞌ kanꞌ―. ¿Ta wa mxitsen neꞌ ꞌwan sikwa a? ¿Ti ka nu ndukwin ra ꞌwan chaꞌ lyaa wan ꞌin nu tiꞌí nu ndijyan xa nu tyii chalyuu a? ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Suꞌwe sikwa, kwaꞌu wan ꞌwa si chañi chaꞌ wa ngulaa yaꞌ wan chaꞌ kuxi nu ndiꞌin ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ja xkeꞌ ꞌa tiꞌ wan chaꞌ ka suꞌwe ꞌwan tloo Ndiose si xkwiꞌ ndyuꞌwi tiꞌ wan ꞌin ayman kula ꞌwan, ñaꞌan tiꞌ ayman kula Abraham kanꞌ. Ja talo Ndiose ꞌin chaꞌ kuxi nu ngiꞌni wan siyaꞌ ti, ni siya nten taꞌa ayman Abraham lka wan, nchkwiꞌ wan. Nan kwiñi wan. Si nchka tiꞌ Ndiose, ka ꞌin Ni kwiñan Ni xka ta nten loꞌo kee ndiꞌin tuꞌwa chku re, chaꞌ ka neꞌ taꞌa ayman Abraham; ka ꞌin Ni si nchka tiꞌ Ni. Loꞌo ja tukwa Ndiose chaꞌ ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sa ñaꞌan nduun ska nten loꞌo chkwan yka ꞌin yu chaꞌ suwi yu lo yka kwiñii ꞌin yu, ngwañaꞌan lka Ndiose; siꞌyu yu kanꞌ ꞌin nchga yka nu ja nda nan suꞌwe, chaꞌ tikin yu ꞌin ran lo kiiꞌ, kwiꞌ ngwañaꞌan ta Ndiose nu tiꞌí ꞌin nten nu ja xlyaa kulaa yaꞌ chaꞌ kuxi nu ngiꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Loꞌoǔn ni, ndukwatyaǎn ꞌwan loꞌo tyiꞌa chku re, si chañi chaꞌ wa ngwa jyuꞌu tiꞌ wan ꞌin kiꞌya nu ndukwi wan; loꞌo wa kan ti xka nu tnun la chaꞌ nchka ꞌin ke naꞌ. Loꞌoǔn, kuꞌni tnuǔn ꞌin yu kanꞌ; suꞌwe ꞌa ka tiyeěn, ni siya xtiǐnꞌ tiǎn ti ndukwa snan yu kanꞌ. Loꞌo yu kanꞌ ni, ja tukwatya yu ꞌin nten loꞌo tyiꞌa ti; kuꞌni yu chaꞌ kanun Tyiꞌi Ndiose niꞌ kasiya ꞌin nten xa nu tukwatya yu ꞌin neꞌ. Kwiꞌ ngwañaꞌan, kuꞌni luwi yu kasiya ꞌin neꞌ loꞌo xaa ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Sa ñaꞌan ngiꞌni nten bra nu nxoꞌ tiꞌin neꞌ nskwaꞌ niꞌ juꞌwa, loꞌo nxoꞌ neꞌ lkaꞌ tlaꞌ xka seꞌen chaꞌ skin ran lo kiiꞌ, ngwañaꞌan suwi Ndiose ꞌin nten, xa nu suꞌwa Ni ꞌin nten xaꞌan chaꞌ skin lo kiiꞌ seꞌen ja tsaa tii ꞌa chaꞌ nchkin. Ngwañaꞌan ngwaꞌu Xuwa ꞌin nten nu ndyaꞌan seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ti mdiꞌin Xuwa tuꞌwa chku Jordán, bra kanꞌ mdoꞌo Jesús lo yuu ꞌin Galilea mdiyan seꞌen ndiꞌin Xuwa, chaꞌ loꞌo Jesús nchka tiꞌ chaꞌ tukwatya Xuwa ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Loꞌo ngwa tiꞌ Xuwa chaꞌ ja tukwatya yu ꞌin Jesús. ―Ja suꞌwe tukwatyaǎn ꞌiin. Suꞌwe la nuꞌwin tukwatyaa ꞌñaǎn ―ndukwin Xuwa ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Suꞌwe tukwatyaa ꞌñaǎn ni ―ndukwin Jesús ꞌin Xuwa―, chaꞌ ngwañaꞌan suꞌwe kuꞌnian nchga tñan nu nchka tiꞌ Ndiose chaꞌ kuꞌnian. Bra nu ynan Xuwa chaꞌ nu ykwiꞌ Jesús loꞌo yu, mdukwatya yu ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Xa wa ngwa chaꞌ kanꞌ, mdoꞌo Jesús lo tyiꞌa, kanꞌ ngalaa nde niꞌ kwan. Loꞌo bra kanꞌ naꞌan Jesús chaꞌ ngwiꞌya Tyiꞌi Ndiose chunꞌ yu; sa ñaꞌan ndiꞌya ska kiñi cha kuun lo yuu, ngwañaꞌan ngwiꞌya Tyiꞌi Ndiose chunꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ynen ykwiꞌ Ndiose nde seꞌen ndiꞌin Ni nde niꞌ kwan bra kanꞌ. Nde ñaꞌan ndukwin Ni: ―Nu nde lka Sñiěnꞌ ―ndukwin Ni―. Ndiya ꞌa tiǎnꞌ ꞌin yu, chaꞌ suꞌwe ꞌa nsuꞌwi tiyeěn ñaꞌaǎn ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Loꞌo bra kanꞌ ndyaa loꞌo Tyiꞌi Ndiose ꞌin Jesús niꞌ kixinꞌ seꞌen wtyi ꞌa yuu, seꞌen ja ndiꞌin nten, chaꞌ tyukwa taꞌa yu loꞌo kuneꞌ xaꞌan nde kanꞌ. Ngwa tiꞌ yu kanꞌ tyijin lyo ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tuꞌwa tsan tuꞌwa tla ja yku Jesús siyaꞌ ti, ngiteꞌ ꞌa tiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Loꞌo bra kanꞌ mdoꞌo tukwa kuneꞌ xaꞌan kanꞌ, chaꞌ kwiñi lyoꞌo ꞌin Jesús: ―Si chañi chaꞌ lkaa ska ti nu lka Sñiꞌ Ndiose ―ndukwin kuneꞌ xaꞌan ꞌin Jesús―, xñii ska kee re sikwa, chaꞌ kwiñaan tyaja loꞌo ran chaꞌ kuan. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mxkwen Jesús ꞌin kuneꞌ xaꞌan bra kanꞌ: ―Ndukwa ska chaꞌ lo kityi ꞌin Ndiose ―ndukwin Jesús ꞌin yu―. Nde ñaꞌan nchkwiꞌ chaꞌ kanꞌ: “Siꞌi nan kuꞌu nten chalyuu chaꞌ nchku neꞌ tyaja ti; xa nu kunan neꞌ nchga chaꞌ nu nchkwiꞌ Ndiose, kanꞌ chañi chaꞌ tyiꞌin suꞌwe neꞌ.” Ngwañaꞌan nchkwiꞌ chaꞌ nu ndukwa lo kityi. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Loꞌo bra kanꞌ ndyaa loꞌo kuneꞌ xaꞌan ꞌin Jesús nde kichen Jerusalén, ti kwiꞌ kichen nu ndiya ꞌa tiꞌ Ndiose; mchkwen neꞌ ndyaa neꞌ la ke laa tnun ꞌin kichen kanꞌ, kwan ꞌa mduun neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","―¿Ta chañi chaꞌ nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose a? ―ndukwin kuneꞌ xaꞌan ꞌin Jesús―. Suꞌwe si xtyuu loo lo yuu sikwa, chaꞌ ndukwa ska chaꞌ lo kityi ꞌin Ndiose nu nchkwiꞌ: Kulo Ndiose tñan ꞌin angajle ꞌin Ni chaꞌ ñaꞌansiin ꞌiin, ndukwin kityi. Kwiꞌ ngwañaꞌan ndukwa xka chaꞌ: Loꞌo yaꞌ ti angajle ꞌin Ni xituun ꞌiin, chaꞌ ja ka tiꞌí kiyaaꞌ seꞌen tyukwa kee kiyaaꞌ. Ngwañaꞌan ndukwa chaꞌ lo kityi ―ndukwin kuneꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mxkwen Jesús ꞌin kuneꞌ xaꞌan bra kanꞌ: ―Kwiꞌ ngwañaꞌan, ndukwa xka chaꞌ lo kityi ꞌin Ndiose: “Ja kwiñi lyoꞌo wan ꞌin Ndiose nu lka Xꞌnan wan” ndukwin kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Bra nu mdyii ykwiꞌ neꞌ, xiyaꞌ ndyaa loꞌo kuneꞌ xaꞌan ꞌin Jesús ska lo kiꞌya nu kwan ꞌa. Ngwaꞌu kuneꞌ xaꞌan nchga nasiyun ñaꞌaan chalyuu ꞌin Jesús bra kanꞌ, chaꞌ suꞌwe ꞌa ñaꞌan chalyuu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ykwiꞌ biyaꞌ kuneꞌ xaꞌan kanꞌ loꞌo Jesús xiyaꞌ bra kanꞌ: ―Taǎn chabiyaꞌ kaa ndloo la ꞌin nchga chalyuu nu ñaꞌaan nde kwa ―ndukwin kuneꞌ xaꞌan ꞌin Jesús―, ska ti si tyuun xtyiinꞌ tloǔn, si kuꞌnii tnun ꞌñaǎn, kaa ndloo la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Loꞌo mxkwen Jesús ꞌin kuneꞌ xaꞌan bra kanꞌ: ―Tyoꞌo tsuuꞌ seꞌen ndiꞌiǐn, Satanás ―ndukwin Jesús―. Yaa lyaa, chunꞌ ndukwa ska chaꞌ lo kityi ꞌin Ndiose nu nchkwiꞌ: “Ska ti Ndiose nu lka Xꞌnan wan kuꞌni tnun wan ꞌin Ni, siyaꞌ ti kunan wan chaꞌ nu nchkwiꞌ Ndiose xa nu ndiꞌin wan lo chalyuu” ndukwin kityi. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Mdoꞌo kuneꞌ xaꞌan ndyaa bra kanꞌ. Kanꞌ mdoꞌo tukwa angajle chaꞌ tayaꞌ ꞌin Jesús, chaꞌ talo la yu ti chinꞌ seꞌen ndiꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa, chaꞌ wa ynan yu chaꞌ wa msñi neꞌ ꞌin Xuwa; wa ndyaa loꞌo neꞌ ꞌin Xuwa kanꞌ niꞌ ñaꞌan chkwan. Bra kanꞌ ndyaan Jesús nde lo yuu ꞌin Galilea xiyaꞌ, ndyaan yu kichen Nazaret. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Loꞌo ja nganun yu kichen Nazaret kanꞌ; mxaꞌan yu seꞌen ndiꞌin yu, ndyaa yu kichen Capernaum tuꞌwa tiyuꞌ. Ndiꞌin kichen kanꞌ laja lo yuu ꞌin Zabulón loꞌo yuu ꞌin Neftalí. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ti kwiꞌ ti chaꞌ mdaꞌan ayman kula Isaías nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose nu ngwa sꞌni: ");
INSERT INTO ctpNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Yuu nu ndiꞌin kwenta ꞌin Zabulón loꞌo yuu nu kwenta ꞌin Neftalí nde xka laꞌa tsuꞌ chku Jordán, tyijian lo yuu kanꞌ, kalaan tuꞌwa tujoꞌo bra kanꞌ; kanꞌ lka yuu ꞌin Galilea, seꞌen ndiꞌin nten nu ja lka judío. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Wa yten ska xaa tlyu niꞌ kasiya ꞌin neꞌ kanꞌ; nu ngwa xkanꞌ xiꞌin ꞌa tiꞌ neꞌ, ntsen neꞌ si kaja neꞌ, lye ꞌa ngwa tla niꞌ kasiya ꞌin neꞌ kanꞌ bra kanꞌ, siꞌya chaꞌ kuxi. Bra ni wa ndiꞌin xaa niꞌ kasiya ꞌin neꞌ kanꞌ, wa kaja ti chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ. Ngwañaꞌan ykwiꞌ ayman kanꞌ, kanꞌ chaꞌ lo yuu kanꞌ mdiꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Loꞌo mdyisnan ykwiꞌ Jesús loꞌo neꞌ nu ndaꞌan seꞌen ndiꞌin yu bra kanꞌ: ―Ka jyuꞌu tiꞌ wan ―ndukwin Jesús ꞌin neꞌ―, kulaa yaꞌ wan nchga chaꞌ kuxi nu ngiꞌni wan, chaꞌ wa tiya ti bra chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","La xka tsan ndaꞌan Jesús tuꞌwa tiyuꞌ Galilea kanꞌ, naꞌan yu ꞌin Simón loꞌo Ndre taꞌa ngula Simón bra kanꞌ, nduguun neꞌ katan lo tyiꞌa chaꞌ xñi neꞌ kula, chaꞌ kanꞌ lka tñan nu ngiꞌni neꞌ kanꞌ nchga tsan. Ti kwiꞌ Simón kanꞌ lka nu mstya Jesús xka nin chaꞌ ka naan yu Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Loꞌo bra kanꞌ ykwiꞌ Jesús loꞌo taꞌa tyukwaa yu kiꞌyu kanꞌ: ―Tsaa wan loꞌoǔn ni ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Sa ñaꞌan mjwi kula ꞌwan xa nu mdaꞌan wan kuta kula, ngwañaꞌan kaja xka tñan ꞌwan ni chabiyaꞌ ꞌñaǎn; kwaꞌuǔn ꞌwan sa ñaꞌan nu tsaa naan wan ꞌin nten chalyuu re nu ja ya kunan chaꞌ suꞌwe, chaꞌ ka neꞌ nten ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bra ti mxnun tiꞌin neꞌ katan ꞌin neꞌ, ndyaa ñaꞌan neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nde loo la chinꞌ naꞌan Jesús ꞌin Santiago sñiꞌ Zebedeo loꞌo Xuwa taꞌa ngula yu; ndukwa neꞌ niꞌ yka naꞌan xuwe ꞌin neꞌ loꞌo sti neꞌ, nxuꞌwa neꞌ katan ꞌin neꞌ bra kanꞌ. Kanꞌ msiꞌya Jesús ꞌin neꞌ kanꞌ, chaꞌ tsaa neꞌ loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bra ti mxnun tiꞌin neꞌ yka naꞌan ꞌin neꞌ loꞌo sti neꞌ, ndyaa neꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ndyaa neꞌ nchga kichen nde lo yuu ꞌin Galilea loꞌo Jesús bra kanꞌ. Nchga kichen seꞌen mdaꞌan yu ngwaꞌu yu ꞌin nten niꞌ lyaa ꞌin neꞌ judío; ykwiꞌ yu loꞌo neꞌ sa ñaꞌan lka chaꞌ suꞌwe ꞌin Ndiose, chaꞌ wa ndla ti ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ. Kwiꞌ ngwañaꞌan, yꞌni yu joꞌó ꞌin nchga nu tiꞌí, nchga kicha nu ndiꞌin ꞌin neꞌ yꞌni Jesús chaꞌ nchkaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bra kanꞌ ynen chaꞌ ꞌin Jesús nchga kichen nde lo yuu ꞌin Siria; kanꞌ chaꞌ mdiyan loꞌo neꞌ ꞌin nchga nu tiꞌí seꞌen ndiꞌin yu, chaꞌ kuꞌni yu joꞌó ꞌin neꞌ. Ndijyan loꞌo neꞌ ꞌin nu tiꞌí, loꞌo nu nsuꞌwi kicha ꞌin; loꞌo nu nsuꞌwi kwiꞌin kuxi ꞌin, loꞌo nu nꞌni lyoꞌo kwiꞌin ꞌin, loꞌo nu nchkunꞌ ñaꞌaan tyukwin nsuꞌwi, loꞌo nu mtyi ska laꞌa yaꞌ, yꞌni Jesús chaꞌ nchkaa nchga nu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kanꞌ chaꞌ kaꞌan ꞌa nten mdoꞌo ñaꞌan ꞌin Jesús, loꞌo neꞌ Galilea, loꞌo neꞌ nchga kichen nde Decápolis, loꞌo neꞌ kichen Jerusalén, loꞌo neꞌ xka la kichen nde lo yuu ꞌin Judea, loꞌo neꞌ kichen xka laꞌa tsuꞌ chku Jordán. Kaꞌan ꞌa kichen mdoꞌo neꞌ ndyaa ñaꞌan neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Naꞌan Jesús chaꞌ kaꞌan ꞌa nten ndijyan seꞌen ndiꞌin yu, kanꞌ chaꞌ mskwen yu ndyaa la yu nde siꞌ kiꞌya, ndyaa tukwa yu chinꞌ nde kanꞌ. Loꞌo ndyoꞌ tiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu nde seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Mdyisnan Jesús ngwaꞌu yu ꞌin neꞌ kanꞌ bra kanꞌ. Nde lka chaꞌ nu ykwiꞌ yu loꞌo neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ka suꞌwe nka tiye nten si jlyo tiꞌ neꞌ chaꞌ ja ka ꞌin neꞌ kuꞌni neꞌ ska chaꞌ suꞌwe, si ja loꞌo Ndiose ―ndukwin Jesús―. Ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten ni siya xiꞌin tiꞌ neꞌ ni, siꞌya kiꞌya nu ndiꞌin ꞌin neꞌ; kuꞌni Ndiose chaꞌ ka suꞌwe ka tiye neꞌ kanꞌ chunꞌ ndiꞌin la. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu ja nchka tiꞌ tyijin lyo ꞌin taꞌa nten, chaꞌ nde seꞌen ndiꞌin Ndiose ndiya chaꞌ suꞌwe nu ta Ni ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu xlyaa kuꞌni nchga chaꞌ suꞌwe, nchga chaꞌ nu ñi; tayaꞌ Ndiose ꞌin nten kanꞌ, chaꞌ ka kuꞌni neꞌ nchga tñan nu nchka tiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu nchka tꞌnan tiꞌ ꞌin taꞌa nten, chaꞌ ngwañaꞌan chka tꞌnan tiꞌ Ndiose ꞌin neꞌ kanꞌ chunꞌ ndiꞌin la. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu luwi kasiya ꞌin, chaꞌ wa lka nda Ndiose chabiyaꞌ ꞌin neꞌ kanꞌ, chaꞌ ñaꞌan neꞌ ꞌin ykwiꞌ Ni nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu ndayaꞌ ꞌin taꞌa nten chaꞌ ka tiin chaꞌ ꞌin neꞌ loꞌo nu nxuun loꞌo neꞌ. “Sñiěnꞌ” nchkwin Ndiose ꞌin nten nu ngiꞌni chaꞌ kiꞌya tlaꞌ tiye neꞌ loꞌo taꞌa nten neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye nten nu talo tyiꞌin loꞌo taꞌa nten neꞌ, ni siya naꞌan tiꞌí nten kanꞌ ꞌin neꞌ, chunꞌ ngiꞌni neꞌ chaꞌ suꞌwe chaꞌ ꞌin Ndiose. Ka suꞌwe nka tiye neꞌ, chaꞌ ngwañaꞌan Ndiose lka ndloo la niꞌ kasiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Kwiꞌ ngwañaꞌan, ka suꞌwe nka tiye wan ni siya xtyi lyoꞌo neꞌ ꞌwan chunꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn, ni siya kuꞌni liyeꞌ tiꞌ neꞌ ꞌwan, ni siya kwiñi lyoꞌo neꞌ ꞌwan, ni siya chkwiꞌ ꞌa neꞌ kwentu ꞌwan siꞌya chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ka suꞌwe nka tiye wan bra kanꞌ, suꞌwe ꞌa tyiꞌin wan chaꞌ wa lka ndiꞌin ska chaꞌ suꞌwe nu tlyu chinꞌ nu ta Ndiose ꞌin nchga wan nde seꞌen ndiꞌin Ni. Kwiꞌ ngwañaꞌan ngwa tiꞌí ꞌa tiꞌ ayman sꞌni ꞌin ayman nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Sa ñaꞌan nu nnanjoꞌo ꞌa tejeꞌ ꞌñaan chaꞌ tiyenꞌ ran, chaꞌ kuꞌni xunꞌ ran skwa, ngwañaꞌan lka wan lo chalyuu; nnanjoꞌo ꞌa wan ꞌin Ndiose chaꞌ kuꞌni wan tñan ꞌin Ni. Si wa mnuꞌun tejeꞌ ꞌñaan, ja ka ꞌa kunanjoꞌo ran ꞌñaan bra kanꞌ; suꞌwe la si xkwaan ꞌin tejeꞌ kanꞌ tuꞌwa tuwiin seꞌen ndijin nten bra kanꞌ. Ja nꞌni chaꞌ ni siya lyoꞌo suꞌwa nten chunꞌ tejeꞌ mnuꞌun kanꞌ. Sa ñaꞌan ngiꞌni nten loꞌo tejeꞌ mnuꞌun kanꞌ, ngwañaꞌan ngiꞌni Ndiose loꞌo nten nu ja nnan chaꞌ nchkwiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Sa ñaꞌan lka ska xaa, ngwañaꞌan lka wan, chaꞌ ka kwaꞌu wan tuwiin ꞌin Ndiose ꞌin nchga nten chalyuu. Ska kichen nu ndiꞌin lo kiꞌya ni, ja ka tyiꞌin kanꞌ mnan ti; ñaꞌan nchga nten ꞌin kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kwiꞌ ngwañaꞌan, bra nu mxkin neꞌ ska kiiꞌ kityee, ja suꞌwa kutsiꞌ neꞌ ꞌin kiiꞌ kanꞌ niꞌ kajun bra kanꞌ; kwan xtya neꞌ kityee kanꞌ, chaꞌ kiꞌni xaa ñaꞌaan niꞌ ñaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kwiꞌ ngwañaꞌan ꞌwan ni, kuꞌni wan chaꞌ ka wan xaa nu kwaꞌu tuwiin ꞌin nten, xkwiꞌ chaꞌ suꞌwe kuꞌni wan chaꞌ ñaꞌan nchga nten ñaꞌaan chaꞌ suꞌwe nu ngiꞌni wan, chaꞌ lka wan sñiꞌ Ndiose. Bra kanꞌ tyaa yuꞌwi tiꞌ neꞌ ꞌin Stian Ndiose, kuꞌni tnun neꞌ ꞌin Ni nu ndiꞌin niꞌ kwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Ja tyaꞌan chaꞌ tiye wan chaꞌ ndijyaǎn lo chalyuu re chaꞌ kuꞌni tyiǐn chaꞌ kula ꞌñaan; ni siya nchga chaꞌ nu ykwiꞌ Ndiose loꞌo ayman Moisés, ni siya nchga chaꞌ nu ngwaꞌan ayman nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose nu ngwa sꞌni, ja kuꞌni tyiǐn chaꞌ kanꞌ. Wa ndijyaǎn chaꞌ nu kwaꞌuǔn ñi ꞌin nten sa ñaꞌan lka nchga chaꞌ nu ndukwa lo kityi kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Chañi chaꞌ nchkwiǐnꞌ loꞌo wan ni, chaꞌ ja ska chaꞌ nu ngwaꞌan ayman sꞌni chaꞌ ꞌin Ndiose, ja ka kuꞌni tyii nten chaꞌ kanꞌ sa ñaꞌan bra nu tsaa tii chalyuu; chañi chaꞌ ka nchga chaꞌ nu ndukwa lo kityi ꞌin Ndiose nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Kanꞌ chaꞌ ni, ja ta Ndiose seꞌen tyiꞌin nten loꞌo Ni, xa nu ja tukwa neꞌ nchga tñan nu ngulo Ndiose ꞌin neꞌ chaꞌ kuꞌni neꞌ, xa nu loꞌo kwaꞌu neꞌ ꞌin taꞌa nten neꞌ chaꞌ ja ndiꞌin chaꞌ tukwa neꞌ tñan kanꞌ. Ta Ndiose seꞌen tyiꞌin nten loꞌo Ni xa nu tukwa neꞌ nchga chaꞌ nu nchkwiꞌ Ni, xa nu loꞌo kwaꞌu neꞌ tñan kanꞌ ꞌin taꞌa nten neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nde ndiya chaꞌ nu chkwiǐnꞌ loꞌo wan ni: Chaꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌwan, ndiꞌin chaꞌ ka suꞌwe la tñan nu kuꞌni wan, siꞌi sa ñaꞌan nu ngiꞌni neꞌ kti kwa, neꞌ fariseo kwa loꞌo mstru nu nduꞌu chaꞌ joꞌo kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Wa ynan wan sa ñaꞌan nu ngulo Ndiose tñan ꞌin ayman nu ngwa sꞌni. Nchkwiꞌ Ni chaꞌ re: “Ja kujwi wan ꞌin taꞌa nten wan” ndukwin Ndiose. “Bra nu kujwi neꞌ ꞌin taꞌa nten neꞌ, ndiꞌin chaꞌ tsaa neꞌ niꞌ ñaꞌan chkwan chaꞌ kuꞌni biyaꞌ wse ꞌin neꞌ bra kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Loꞌo ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan: Ni siya naꞌan tiꞌí ti neꞌ ꞌin taꞌa nten neꞌ, ndiꞌin chaꞌ tyijin neꞌ nu tiꞌí bra kanꞌ; ni siya chkwiꞌ neꞌ ska chaꞌ kuxi ꞌin taꞌa nten neꞌ, bra kanꞌ ndiꞌin chaꞌ tsaa neꞌ nde seꞌen ndukwa nu lka ndloo la nde kichen Jerusalén, chaꞌ ka biyaꞌ chaꞌ ꞌin neꞌ nde kwa bra kanꞌ. Kwiꞌ ngwañaꞌan, bra nu msinꞌ ꞌa tiꞌ neꞌ nchkwiꞌ neꞌ loꞌo taꞌa nten neꞌ: ¡Tintu ꞌa nuꞌwin!, ja chan tsaa neꞌ kanꞌ lo jwlyaa, seꞌen ja tsaa tii ꞌa chaꞌ nchkin kiiꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Kwiꞌ ngwañaꞌan, si tyaa yuꞌwi tiꞌ wan chaꞌ ndiya chaꞌ wsuun ꞌin ska nten loꞌo wan, bra nu wa tsaa ti wan niꞌ lyaa chaꞌ ta wan lomstan ꞌin Ndiose, ");
INSERT INTO ctpNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kanꞌ suꞌwe la xitukwi wan tyaan wan loꞌo lomstan ꞌwan tuꞌ naꞌan tyi wan xiyaꞌ, tsaa wan jñan wan chaꞌ tlyu tiꞌ ꞌin taꞌa wan ti kulo bra kanꞌ. Xiyaꞌ tsaa yꞌya wan lomstan kanꞌ, tsaa loꞌo wan ꞌin ran niꞌ lyaa xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Nde lka sa ñaꞌan kuꞌni wan bra nu ndiya nten nu xtya kiꞌya ꞌwan tuꞌ naꞌan tñan: bra ti kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa wan kanꞌ, nu ti ji tiya wan seꞌen ndukwa yu wsiya chaꞌ kuꞌni biyaꞌ neꞌ chaꞌ wsuun kanꞌ. Kuxi la chaꞌ si ka tlá ꞌa yu wsiya, kanꞌ xiꞌya yu ꞌin neꞌ policía chaꞌ suꞌwa neꞌ ꞌwan niꞌ ñaꞌan chkwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chañi nchkwiǐnꞌ loꞌo wan, chaꞌ keeꞌ ꞌa tyoꞌo luwi wan tloo nten kanꞌ, chaꞌ ndiꞌin chaꞌ ta wan nchga tñi siyaꞌ ti nu jñan yu wsiya ꞌwan chaꞌ tyoꞌo wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Wa ynan wan sa ñaꞌan tñan ngulo Ndiose ꞌin ayman taꞌaan sꞌni. Nchkwiꞌ Ni chaꞌ re: “Ja kuꞌni wan chaꞌ kuxi loꞌo kwilyoꞌo xka nten” ndukwin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Loꞌo ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan: Ni siya ñaꞌan kwiꞌya ska yu kiꞌyu ꞌin ska nu kunaꞌan, loꞌo bra kanꞌ xitukwi tiꞌ yu ꞌin nu kunaꞌan kanꞌ, suꞌwa ndiꞌin chaꞌ kanꞌ loꞌo yu sa ñaꞌan si wa lka yꞌni yu ska chaꞌ nu kuxi loꞌo nu kunaꞌan kanꞌ, ni siya tiye ti yu nsuꞌwi chaꞌ kuxi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Bra nu ndiya ska chaꞌ kuxi nu ñaꞌan wan loꞌo kiloo wan, loꞌo ndiya ꞌa tiꞌ wan chaꞌ kuxi kanꞌ, ndiꞌin chaꞌ kulaa yaꞌ wan chaꞌ kuxi kanꞌ bra ti. Ñaꞌan tiꞌ si kulo wan ska laꞌa kiloo wan, kanun kwityiinꞌ wan bra kanꞌ, ja tyukwi wan bra kanꞌ; ngwañaꞌan ka kasiya ꞌwan ni, ka luwi kasiya ꞌwan si kulaa yaꞌ wan chaꞌ kuxi kanꞌ, ni siya xiꞌin tiꞌ wan ti chinꞌ. Chunꞌ ndiꞌin la ja tsaa wan lo jwlyaa siꞌya chaꞌ kuxi kanꞌ ꞌwan, seꞌen lye nchkin kiiꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Bra nu ndiya ska chaꞌ kuxi nu ngiꞌni wan loꞌo yaꞌ wan, loꞌo ndiya ꞌa tiꞌ wan chaꞌ kuxi kanꞌ, ndiꞌin chaꞌ kulo chunꞌ wan chaꞌ kuxi kanꞌ bra ti. Ñaꞌan tiꞌ si siꞌyu wan ska laꞌa skun wan, kanun chkuꞌ yaꞌ wan bra kanꞌ, ja tyukwi wan bra kanꞌ; ngwañaꞌan ka kasiya ꞌwan ni, ka luwi kasiya ꞌwan si kulaa yaꞌ wan chaꞌ kuxi kanꞌ, ni siya xiꞌin tiꞌ wan ti chinꞌ. Chunꞌ ndiꞌin la ja tsaa wan lo jwlyaa siꞌya chaꞌ kuxi kanꞌ ꞌwan, seꞌen lye nchkin kiiꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nde ndiya xka chaꞌ nu ykwiꞌ ayman sꞌni: “Bra nu nchkwiꞌ ska yu kiꞌyu loꞌo kwilyoꞌo yu chaꞌ tyaa seꞌen ndiꞌin sti loꞌo jyaꞌan xiyaꞌ, chunꞌ nchka tiꞌ yu kulaa tiꞌin yu ꞌin kwilyoꞌo yu, kanꞌ ndiꞌin chaꞌ kulo yu ska kityi chaꞌ ꞌin nu kunaꞌan kanꞌ bra kanꞌ. Kityi kanꞌ katsaꞌ chaꞌ ja lka ꞌa nu kunaꞌan kanꞌ kwilyoꞌo yu ni.” ");
INSERT INTO ctpNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Loꞌo ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan: Chaꞌ kuxi ngiꞌni ska yu kiꞌyu loꞌo kwilyoꞌo yu bra nu kulaa tiꞌin yu ꞌin kwilyoꞌo yu, loꞌo ja ndukwi nu kunaꞌan kanꞌ kiꞌya. Chunꞌ ndiꞌin bra nu kaja kwilyoꞌo nu kunaꞌan kanꞌ loꞌo xka nten, ngiꞌni yu kanꞌ chaꞌ ndukwi nu ngwa kunaꞌan ꞌin yu kiꞌya bra kanꞌ. Kwiꞌ ngwañaꞌan, loꞌo xka nten kanꞌ ndukwi kiꞌya, chaꞌ kwilyoꞌo xka yu kiꞌyu kanꞌ lka nu kunaꞌan kanꞌ, ni siya tlyu la kiꞌya ndukwi yu kiꞌyu kanꞌ nu ngwa kwilyoꞌo ti kulo. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Xka chaꞌ ni, wa ynan wan sa ñaꞌan tñan nu ngulo Ndiose ꞌin ayman sꞌni. Nchkwiꞌ Ni chaꞌ re: “Ja suꞌwe chkwiꞌ wan loꞌo Ndiose chaꞌ kuꞌni wan ska tñan, loꞌo chaꞌ kwiñi nchkwiꞌ wan. Ndiꞌin chaꞌ kuꞌni ji wan sa ñaꞌan nu ndukwin wan ꞌin Ndiose chaꞌ kuꞌni wan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ni ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan: Ja suꞌwe siyaꞌ ti skanꞌ wan ska chaꞌ loꞌo nten chaꞌ nchkwiꞌ wan ska chaꞌ nu tnun ꞌa; ni siya chkwiꞌ wan chaꞌ ꞌin nchga nan nu nsuꞌwi niꞌ kwan, ja skanꞌ wan chaꞌ loꞌo nten ngwañaꞌan, chaꞌ la kanꞌ ndiꞌin Ndiose ykwiꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni siya chkwiꞌ wan chaꞌ ꞌin nan nu nsuꞌwi lo chalyuu re, ja chkwiꞌ wan chaꞌ nu tnun ꞌa ngwañaꞌan, chaꞌ chaꞌ ꞌin Ndiose lka chalyuu re; ni siya chkwiꞌ wan chaꞌ ꞌin kichen Jerusalén, ja chkwiꞌ wan chaꞌ nu tnun ꞌa ngwañaꞌan, chaꞌ la kanꞌ lka Ndiose ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ti kwiꞌ ti chaꞌ, ja skanꞌ wan chaꞌ loꞌo nten bra nu nchkwiꞌ wan chaꞌ ꞌin ke wan ti ykwiꞌ ti wan, chaꞌ ska ti Ndiose ngwiñan Ni ꞌwan, loꞌo ja ka ꞌwan kuꞌni wan chaꞌ ka kichanꞌ ke wan, ni siya kichanꞌ ngata, ni siya kichanꞌ ngaten. Ja suꞌwe nka tiye Ndiose siyaꞌ ti chaꞌ chkwiꞌ wan ska chaꞌ laja ti bra nu skanꞌ tsaa wan chaꞌ loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sa kanꞌ ti chaꞌ chkwiꞌ wan “Chañi”, si chaꞌ nu ñi lka; kwiꞌ ngwañaꞌan chkwiꞌ wan “Siꞌi”, si chaꞌ kwiñi lka. Nchga la chaꞌ nu chkwiꞌ wan xa nu nchkwiꞌ wan ska chaꞌ tnun, chaꞌ ꞌin kuneꞌ xaꞌan lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Loꞌo wa ynan wan chaꞌ re nu ykwiꞌ ayman sꞌni: “Ska nten xaꞌan ni, bra nu mchu yu kiloo taꞌa yu, ndiꞌin chaꞌ kulo neꞌ wsiya kiloo ykwiꞌ yu chaꞌ ka tiin kiꞌya ꞌin yu bra kanꞌ. Kwiꞌ ngwañaꞌan, bra nu mstun yu ska liꞌya taꞌa yu, bra kanꞌ ndiꞌin chaꞌ kulo neꞌ wsiya liꞌya ykwiꞌ yu, chaꞌ ka tiin kiꞌya nu ndukwi yu.” Ngwañaꞌan ykwiꞌ neꞌ nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Loꞌo ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan, chaꞌ ja xuun taꞌa wan loꞌo nten nu yꞌni chaꞌ kuxi loꞌo wan. Bra nu jwiꞌin neꞌ ndukunꞌ neꞌ tloo wan laꞌa seꞌen kwin, ta wan chabiyaꞌ jwiꞌin neꞌ ndukunꞌ xka laꞌa tloo wan bra kanꞌ, si nchka tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Bra nu nchka tiꞌ ska nten xaꞌan kulaa ykanꞌ ꞌwan, bra ti ta wan ran ꞌin yu bra kanꞌ; loꞌo ta wan chinꞌ xka la teꞌ ꞌin yu, chaꞌ kanun suꞌwe ka tiye yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kwiꞌ ngwañaꞌan, ska yu nu lka ndloo la, si kulo yu tñan ꞌwan chaꞌ tsaa loꞌo wan yuꞌwa ꞌin yu ska seꞌen, bra ti tsaa loꞌo wan yuꞌwa kanꞌ ꞌin yu; suꞌwe ti ka tiye wan tsaa loꞌo wan ꞌin ran la tijyuꞌ la chinꞌ, si ngwañaꞌan nchka tiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Bra nu jñan ska nten ya ñaꞌan ti nan ꞌwan, ta wan nan kanꞌ ꞌin yu; kwiꞌ ngwañaꞌan, si jñan neꞌ ska nan jñiꞌ ti ꞌwan, suꞌwe ti chkwiꞌ wan loꞌo neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Wa ynan wan chaꞌ re nu ykwiꞌ ayman sꞌni: “Suꞌwe kuꞌni wan loꞌo taꞌa wan, loꞌo ñaꞌan tiꞌí wan ꞌin nten nu nxuun loꞌo wan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Loꞌo ni, kaꞌan la chaꞌ chkwiǐnꞌ loꞌo wan: Suꞌwe ꞌa xuꞌwi tiye wan ñaꞌan wan ꞌin nu tiꞌí tiꞌ ꞌwan; kwiꞌ ngwañaꞌan, suꞌwe chkwiꞌ wan loꞌo nten nu suꞌwa kwentu ꞌwan, suꞌwe kuꞌni wan loꞌo nten nu liyeꞌ tiꞌ ꞌwan; chkwiꞌ wan loꞌo Ndiose chaꞌ ꞌin neꞌ kanꞌ, ni siya naꞌan tiꞌí neꞌ ꞌwan, ni siya nxtyi lyoꞌo neꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ka xuꞌwi lyo nten ꞌwan chaꞌ lka wan sñiꞌ Ndiose nu ndiꞌin niꞌ kwan bra kanꞌ. Suꞌwa nda Ndiose xaa kwan loꞌo seꞌen ndiꞌin nten kuxi, loꞌo seꞌen ndiꞌin nten suꞌwe; suꞌwa nda Ndiose tyoo kiꞌya seꞌen ndiꞌin nten suꞌwe loꞌo seꞌen ndiꞌin nten xaꞌan. Kanꞌ chaꞌ suꞌwe la bra nu suꞌwa kuꞌni wan chaꞌ suꞌwe loꞌo nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ti kwiꞌ ti chaꞌ, ja suꞌwe si xkwiꞌ suꞌwe nsuꞌwi tiye wan loꞌo nten taꞌa suꞌwe ndiꞌin wan. Siꞌi nan suꞌwe la kunan Ndiose chaꞌ nchkwiꞌ wan si ngwañaꞌan ngiꞌni wan, chaꞌ kwiꞌ ngwañaꞌan ngiꞌni ya ñaꞌan ti nten; ni siya nten suꞌwe, ni siya nten xaꞌan, loꞌo neꞌ nu ndlo tñi ꞌwan chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ, nchga nten kanꞌ ngiꞌni suꞌwe neꞌ loꞌo taꞌa suꞌwe ndiꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Bra nu chkwiꞌ suꞌwe wan ska ti loꞌo taꞌa suꞌwe nsuꞌwi wan, ja suꞌwe kanꞌ, chaꞌ kwiꞌ ngwañaꞌan ngiꞌni nchga nten; loꞌo nten nu ja ndiꞌin chaꞌ ꞌin loꞌo Ndiose, loꞌo nten kanꞌ nchkwiꞌ suꞌwe loꞌo taꞌa suꞌwe ndiꞌin neꞌ. Ti kaꞌan la chaꞌ suꞌwe kuꞌni wan, nchka tiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Stian Ndiose nu ndiꞌin nde niꞌ kwan ni, xkwiꞌ chaꞌ suꞌwe, xkwiꞌ chaꞌ nu ñi, xkwiꞌ chaꞌ nu luwi ngiꞌni Ni. Sa ñaꞌan ngiꞌni Ndiose, ngwañaꞌan ndiꞌin chaꞌ kuꞌni wan xkwiꞌ chaꞌ suꞌwe loꞌo nchga nten, si chañi chaꞌ sñiꞌ Ndiose lka wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Nde ndiya xka chaꞌ chkwiǐnꞌ loꞌo wan ni: Ja ta wan ska xuꞌwe ꞌin neꞌ tiꞌi bra nu ñaꞌan xka ta nten ꞌwan. Ja ndiꞌin chaꞌ ñaꞌan nten sa ñaꞌan chaꞌ suꞌwe nu ngiꞌni wan chaꞌ ꞌin Ndiose. Ja ta Stian Ndiose ska chaꞌ suꞌwe ꞌwan nde seꞌen ndiꞌin Ni, xa nu ñaꞌan xka la nten ꞌwan chaꞌ ngiꞌni wan chaꞌ suꞌwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Bra nu tayaꞌ wan ꞌin neꞌ tiꞌi, ja ndiꞌin chaꞌ katsaꞌ wan chaꞌ kanꞌ ꞌin xka la nten. Ja kuꞌni wan sa ñaꞌan nu ngiꞌni nten nu tukwa chaꞌ nsuꞌwi tiye neꞌ, nu nchka ꞌa tiꞌ chaꞌ ñaꞌan xka la nten ꞌin neꞌ; bra nu tayaꞌ neꞌ kanꞌ ꞌin neꞌ tiꞌi, ni siya niꞌ lyaa ꞌin neꞌ judío taꞌaan, ni siya tuꞌwa tuwiin ti, ska ti chaꞌ nchka tiꞌ neꞌ kanꞌ, chaꞌ suꞌwe ꞌa chkwiꞌ nten chaꞌ ꞌin neꞌ, ti ykwiꞌ ti neꞌ. Ja kuꞌni wan ngwañaꞌan. Chañi chaꞌ nchkwiǐnꞌ loꞌo wan: Nchga chaꞌ suꞌwe nu kaja ꞌin neꞌ kanꞌ nde loo la seꞌen ndiꞌin Ndiose, wa lka mjwi chaꞌ kanꞌ ꞌin neꞌ kanꞌ, chaꞌ wa naꞌan xka la nten ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Loꞌo ꞌwan ni, bra nu ta wan ska xuꞌwe ꞌin neꞌ tiꞌi, ta wan ran mnan ti, chaꞌ ja ka biyaꞌ tiꞌ xka la nten; ni siya neꞌ taꞌa wan, ja ka biyaꞌ tiꞌ neꞌ sa ñaꞌan tñan ngiꞌni wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ska ti Stian Ndiose, ka biyaꞌ tiꞌ Ni sa ñaꞌan chaꞌ suꞌwe nu ngiꞌni wan mnan ti, loꞌo bra kanꞌ ta Ndiose chaꞌ suꞌwe nu tlyu chinꞌ ꞌwan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Xka chaꞌ ni: Bra nu chkwiꞌ wan loꞌo Ndiose, ja kuꞌni wan sa ñaꞌan nu ngiꞌni nten nu tukwa chaꞌ nsuꞌwi tiye. Nduun neꞌ kwiñi kanꞌ seꞌen ndiꞌin nten niꞌ lyaa ꞌin neꞌ judío taꞌaan, chaꞌ nchka tiꞌ neꞌ chkwiꞌ neꞌ loꞌo Ndiose bra nu ñaꞌan nten ꞌin neꞌ; ti kwiꞌ ti chaꞌ, nduun neꞌ jluꞌwe tuwiin chaꞌ chkwiꞌ neꞌ loꞌo Ndiose. Chañi chaꞌ nchkwiǐnꞌ loꞌo wan: Nchga chaꞌ suꞌwe nu kaja ꞌin neꞌ kanꞌ nde loo la seꞌen ndiꞌin Ndiose, wa lka mjwi chaꞌ kanꞌ ꞌin neꞌ lo chalyuu ni, chaꞌ wa naꞌan nten chalyuu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Loꞌo ꞌwan ni, bra nu chkwiꞌ wan loꞌo Ndiose, tsaa wan ska seꞌen nu ka tyiꞌin wan ska ti wan. Nu ndiꞌin wan niꞌ ñaꞌan bra kanꞌ, tukunꞌ wan tunaꞌan, chaꞌ ngwañaꞌan kuꞌni tnun wan ska ti wan ꞌin Stian Ndiose bra kanꞌ; ndiꞌin Ni ti kwiꞌ seꞌen ndiꞌin wan, ni siya ja ndiꞌin xka la nten seꞌen ndiꞌin wan. Ska ti Stian Ndiose nchka biyaꞌ tiꞌ Ni sa ñaꞌan chaꞌ suꞌwe nu ngiꞌni wan ska ti wan, kanꞌ nu ta chaꞌ suꞌwe ꞌwan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Bra nu chkwiꞌ wan loꞌo Ndiose, ja chkwiꞌ wan ti kwiꞌ ti chaꞌ kaꞌan ꞌa yaꞌ, loꞌo ja chkwiꞌ wan kaꞌan ꞌa chaꞌ nu ja nchka biyaꞌ tiꞌ wan ti ykwiꞌ ti wan, sa ñaꞌan nu ngiꞌni nten nu ja ndiꞌin chaꞌ ꞌin loꞌo Ndiose siyaꞌ ti. Nxkeꞌ tiꞌ neꞌ kanꞌ, chaꞌ suꞌwe la kunanjoꞌo chaꞌ kanꞌ ꞌin neꞌ bra nu kaꞌan ꞌa chaꞌ chkwiꞌ neꞌ, ngwañaꞌan lka tiye neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ja chkwiꞌ wan ngwañaꞌan loꞌo Ndiose, chaꞌ jlyo tiꞌ Stian Ndiose nchga chaꞌ nu lyiji ꞌwan, ni siya ja ya jñan wan chaꞌ kanꞌ ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nde lka sa ñaꞌan nu suꞌwe la chkwiꞌ wan loꞌo Ndiose sikwa: Ndiose Sti ba nu ndiꞌin nde niꞌ kwan, ska ti nuꞌwin ngiꞌni tnun nten chalyuu ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kan nuꞌwin lo chalyuu re chaꞌ ka ndloo la ꞌwa. Kuꞌnii chaꞌ ka nchga chaꞌ nu nchka tiiꞌ chaꞌ ka lo chalyuu re; sa ñaꞌan nu ngiꞌnii nde seꞌen ndiꞌiin nde niꞌ kwan, ngwañaꞌan ka lo yuu re bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Taa nan ku ba tsan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa ꞌin nchga chaꞌ kuxi nu yꞌni ba, chaꞌ ngwañaꞌan wa yꞌni ba chaꞌ tlyu tiꞌ ꞌin xka la nten nu yꞌni chaꞌ kuxi loꞌo ba. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ja taa chabiyaꞌ chaꞌ jwakii chaꞌ kuxi ꞌwa, kuloo ꞌwa yaꞌ kuneꞌ xaꞌan bra kanꞌ. Nuꞌwin ndloo tñan nchga chaꞌ; nchga chabiyaꞌ nu nsuꞌwi lo chalyuu, nchga chabiyaꞌ nu nsuꞌwi nde niꞌ kwan, nuꞌwin ndiya nchga chabiyaꞌ kanꞌ ꞌiin. Ja tsaa tii ꞌa chaꞌ tlyu la ti nuꞌwin. Ngwañaꞌan ka chaꞌ. Ngwañaꞌan chkwiꞌ wan loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Bra nu kuꞌni wan chaꞌ tlyu tiꞌ ꞌin xka la nten nu wa yꞌni chaꞌ kuxi loꞌo wan, loꞌo Stian nu ndiꞌin nde niꞌ kwan, kuꞌni Ni chaꞌ tlyu tiꞌ ꞌwan bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","bra nu ja kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa nten wan, loꞌo Stian Ndiose, ja kuꞌni Ni chaꞌ tlyu tiꞌ ꞌwan ꞌin kiꞌya nu ndiꞌin ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Xka chaꞌ ni: Bra nu tiya tsan ꞌwan chaꞌ ja ku wan chunꞌ ngiꞌni tnun wan ꞌin Ndiose, ja suꞌwe si xkwiꞌ chaꞌ xiꞌin tiye wan, sa ñaꞌan ngiꞌni nten nu tukwa chaꞌ nsuꞌwi tiye. Nchka tiꞌ neꞌ kanꞌ, chaꞌ ñaꞌan nten ꞌin neꞌ chaꞌ xkwiꞌ ngiꞌni kti neꞌ, chunꞌ ja nchku neꞌ tsan kanꞌ. Chañi chaꞌ nchkwiǐnꞌ loꞌo wan: Wa lka mjwi chaꞌ ꞌin neꞌ, sa kwa ti chaꞌ suꞌwe nu ta Ndiose ꞌin neꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ꞌWan ni, bra nu tiya ska tsan nu kuꞌni kuꞌnan wan chaꞌ suꞌwe la kuꞌni tnun wan ꞌin Ndiose, jyaꞌan wan tloo wan, taꞌan wan chku ke wan bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chaꞌ ja ka biyaꞌ tiꞌ xka la nten chaꞌ ja yku wan tsan kanꞌ. Ska ti Stian Ndiose nchka biyaꞌ tiꞌ Ni sa ñaꞌan chaꞌ suꞌwe nu ngiꞌni wan ska ti wan. Loꞌo bra kanꞌ xnun Ni chaꞌ suꞌwe nu kaja ꞌwan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Xka chaꞌ ni: Ja xoꞌ tiꞌin wan kaꞌan ꞌa chaꞌ suꞌwe chaꞌ ꞌwan ti ykwiꞌ ti wan xa nu ndiꞌin wan lo chalyuu re. Ndla ti ñuꞌun chaꞌ suꞌwe kanꞌ ngwa ti ñaꞌan; ndiya bra nchku tñaꞌ ꞌin ran, ta nchku kusunꞌ ꞌin ran, kuꞌni ñuꞌun iꞌ ꞌin ran bra kanꞌ. Kwiꞌ ngwañaꞌan, kuꞌni neꞌ kunan chaꞌ suꞌwe nu nsuꞌwi ꞌwan, kanaꞌ chaꞌ kanꞌ ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Suꞌwe la chaꞌ ta Ndiose chaꞌ suꞌwe nu tnun chinꞌ ꞌwan nde seꞌen ndiꞌin Ni; ja ku tñaꞌ chaꞌ suꞌwe kanꞌ, ja ka ñuꞌun ran, loꞌo ja ka kuꞌni neꞌ kunan chaꞌ suꞌwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nganun kasiya ꞌwan nde seꞌen ndiya ska chaꞌ nu nchka la ti tiꞌ wan, ni siya ska chaꞌ suꞌwe nu xoꞌ tiꞌin wan lo chalyuu, ni siya ska chaꞌ suꞌwe nu ndiꞌin chaꞌ kaja ꞌwan nde seꞌen ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Kiloan ni, kanꞌ lka nu nda xaa ꞌñaan tyukwi ñaꞌaan. Xa nu ti suꞌwe ti kiloan, ka ñaꞌaan nchga lo tñan nu ti ndiya chaꞌ kuꞌnian, ka kuꞌnian xkwiꞌ chaꞌ suꞌwe bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Xa nu tiꞌí kiloan, ja ka kuꞌnian tñan, chaꞌ ja ndyukwi ꞌa xaa ꞌñaan bra kanꞌ. Kwiꞌ ngwañaꞌan ka niꞌ kasiya ꞌwan, bra nu ja ndyukwi xaa ꞌwan chunꞌ ndiꞌin chaꞌ kuxi ꞌwan, ¡siyaꞌ ti ja ka ꞌa xuꞌwi xaa niꞌ kasiya ꞌwan bra kanꞌ! Tla ꞌa kanun tyukwi ñaꞌaan wan loꞌo kasiya ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ja ska nten ka xuꞌwi tukwa xꞌnan neꞌ ska bra ti. Ja ka kunan wan chaꞌ nchkwiꞌ Ndiose bra nu lye ꞌa ndaꞌan chaꞌ tiye wan chaꞌ ꞌin tñi. Si ngwañaꞌan ngiꞌni wan, wa lka nsuꞌwi tukwa xꞌnan wan bra kanꞌ. Ja chan ñaꞌan tiꞌí wan ꞌin ska xꞌnan wan, loꞌo ka suꞌwe tiye wan ñaꞌan wan ꞌin xka xꞌnan wan bra kanꞌ. Kwiꞌ ngwañaꞌan, kunan suꞌwe wan chaꞌ nchkwiꞌ nu ngwa xꞌnan wan ti kulo kanꞌ, loꞌo kanun kuxi wan loꞌo xka bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Nduwe ꞌa tiꞌ Ndiose ꞌwan, kanꞌ chaꞌ ja ndiꞌin chaꞌ tyaꞌan ꞌa chaꞌ tiye wan sa ñaꞌan ka kuꞌu wan lo chalyuu, nan ka ku wan, nan ka koꞌo wan seꞌen ndiꞌin wan. Ja tyaꞌan ꞌa chaꞌ tiye wan la nde kaja steꞌ wan. Yaꞌ la ni chaꞌ luꞌuun tian, ni siya ja kaꞌan ꞌa nan kuan; yaꞌ la ni chaꞌ suꞌwe ti tyukwi ñaꞌaan, ni siya ja suꞌwe ꞌa steanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tyaꞌan chinꞌ chaꞌ tiye wan sa ñaꞌan nchka ꞌin kiñi nu ndukwi kwan: ja ntya iꞌ nskwaꞌ, ja nxtun iꞌ tya, ja nñan iꞌ juꞌwa seꞌen xoꞌ tiꞌin iꞌ nan ku iꞌ; Stian Ndiose nu ndiꞌin nde niꞌ kwan, nda Ni nan ku iꞌ ngwa ti ñaꞌan. Loꞌo ꞌwan ni, ¿ta chinꞌ la nsuꞌwi lyo wan ke ska kiñi seꞌen ndiꞌin Ndiose a? ¡Siꞌi! Kaꞌan la nsuꞌwi lyo wan chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Loꞌo xka chaꞌ ꞌwan, ja ka kaluu la wan sa jluꞌwe metro kwan la, ni siya kaꞌan ꞌa chaꞌ tyaꞌan tiye wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Kwiꞌ ngwañaꞌan steꞌ wan, ¿ni chaꞌ ndyaꞌan ꞌa chaꞌ tiye wan chaꞌ ꞌin ran? Tyaꞌan chinꞌ chaꞌ tiye wan xa nu ñaꞌan wan keé nu ndukwa laja kixinꞌ kwa. Suꞌwe ti ngaluu ran, ja ngiꞌni ran tñan, ja nchka ꞌin ran kwiñan teꞌ kuꞌ ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ayman Salomón nu ngwa ree kuliyaꞌ ꞌa nu ngwa sꞌni ni, suꞌwe ꞌa ñaꞌan steꞌ yu kula kanꞌ; loꞌo ja suꞌwa ñaꞌan steꞌ yu loꞌo keé kwa, chaꞌ suꞌwe la ñaꞌan keé kwa siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Suꞌwe ꞌa ngwiñan Ndiose keé kwa, chaꞌ nda Ni ska lo chaꞌ ndiꞌya ꞌin keé kanꞌ, ni siya ska ti tsan talo keé kwa, kanꞌ nchkin ran ndiꞌin bra; kwiꞌ ngwañaꞌan, ta Ndiose teꞌ kuꞌ wan, ni siya chinꞌ ꞌa ndyaa ñaꞌan tiꞌ wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kanꞌ chaꞌ ja ndiꞌin chaꞌ tyaꞌan ꞌa chaꞌ tiye wan sa ñaꞌan chaꞌ kuxi nu tyukwa wan nde loo la. Ja chkwiꞌ lye wan: “¿La nde kaja nan ku ba a?” Ja chkwiꞌ wan: “¿La nde kaja tyiꞌa koꞌo ba a?” Ja chkwiꞌ wan: “¿La nde kaja steꞌ ba a?” ");
INSERT INTO ctpNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kwiꞌ ngwañaꞌan ndaꞌan ꞌa chaꞌ tiye nten nu ja ndyaa ñaꞌan tiꞌ ꞌin Ndiose. Jlyo tiꞌ Stian Ndiose nu ndiꞌin nde niꞌ kwan chaꞌ lyiji chaꞌ kanꞌ ꞌwan, ");
INSERT INTO ctpNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","kanꞌ chaꞌ siꞌi chaꞌ kanꞌ tsaa naan wan. Suꞌwe la si ta wan chabiyaꞌ ꞌin Ndiose chaꞌ ka Ni ndloo niꞌ kasiya ꞌwan, suꞌwe la si kuꞌni wan nchga chaꞌ nu nchka tiꞌ Ndiose chaꞌ kuꞌni wan lo chalyuu re; bra kanꞌ ta Ni nchga nan nu lyiji chinꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kwiꞌ ngwañaꞌan, ja ndiꞌin chaꞌ tyaꞌan chaꞌ tiye wan chaꞌ ꞌin sa ñaꞌan nu ka ꞌwan la tyaa. Xka tsan lka kanꞌ. Ska ti ꞌin tsan ni tyaꞌan chinꞌ chaꞌ tiye wan sa ñaꞌan kuꞌni wan chaꞌ tyijin lyo wan ꞌin chaꞌ kuxi nu tyukwa wan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Xka chaꞌ ni: Ja xtya wan kiꞌya ꞌin taꞌa nten wan, chaꞌ ja chan xtya Ndiose kiꞌya ꞌwan xa nu kuꞌni wan ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sa ñaꞌan nchkwiꞌ wan chaꞌ kuxi ꞌin xka taꞌa nten wan bra nu msinꞌ tiꞌ wan, kwiꞌ ngwañaꞌan kuꞌni biyaꞌ Ndiose ꞌwan. Sa ñaꞌan biyaꞌ nu nchkwiꞌ wan ꞌin taꞌa nten wan, ti kwiꞌ biyaꞌ kanꞌ kuꞌni Ndiose loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ni chaꞌ ndla ꞌa nchkwiꞌ wan ꞌin ska chaꞌ kuxi nu nsuꞌwi ꞌin xka taꞌa nten wan? Ñaꞌan tiꞌ si lka ran ska yuu kata ti nu wa yten kiloo neꞌ. Ja nduwe tiꞌ wan chaꞌ tnun ꞌa chaꞌ kuxi nu ngiꞌni ykwiꞌ wan, sa ñaꞌan si lka ran ska mti tnun nu nsuꞌwi kiloo wan, ti ykwiꞌ ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ni chaꞌ lka tnun ꞌa tiye wan chaꞌ chkwiꞌ wan chaꞌ re loꞌo nten kanꞌ: “Taa chabiyaꞌ kuloǔn yuu nu nsuꞌwi kiloo” a? Ngwañaꞌan nchkwiꞌ wan loꞌo nten kanꞌ, loꞌo ja ñaꞌan wan mti nu nsuꞌwi kiloo ykwiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Neꞌ kwiñi lka wan! Kulo la tyoꞌo mti tnun nu nsuꞌwi kiloo ykwiꞌ wan, bra kanꞌ ka ñaꞌan suꞌwe wan chaꞌ kulo wan yuu kata nu nsuꞌwi kiloo taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Chaꞌ suꞌwe nu ykwiꞌ Ndiose ni, ja suꞌwe si tsaa chkwiꞌ wan chaꞌ suꞌwe kanꞌ loꞌo nten xaꞌan nu ja nchka tiꞌ kunan chaꞌ kanꞌ siyaꞌ ti, chaꞌ ñaꞌan tiꞌ xneꞌ, ngwañaꞌan nchka tiꞌ nten kanꞌ. Ta wan chaꞌ kasinꞌ tiꞌ ꞌin neꞌ xaꞌan kanꞌ, ka liyeꞌ tiꞌ neꞌ ꞌwan bra kanꞌ. Kwiꞌ ngwañaꞌan, ja suꞌwe xtya wan ska kee xaa nu kaꞌan ꞌa nsuꞌwi lyo ꞌwan seꞌen ndiꞌin kuweꞌ, chaꞌ bra ti lyoꞌo suꞌwa iꞌ ꞌin nan suꞌwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xka chaꞌ ni: Jñan wan ska chaꞌ ꞌin Ndiose, loꞌo ta Ni chaꞌ kanꞌ ꞌwan bra kanꞌ; tsaa naan wan ꞌin Ndiose, loꞌo tyija lyo Ni ꞌwan bra kanꞌ; tyukwi ti tiye wan chkwiꞌ wan loꞌo Ndiose, kunan Ni chaꞌ nu chkwiꞌ wan loꞌo Ni bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Nchga nten nu jñan ska chaꞌ ꞌin Ndiose, kaja chaꞌ kanꞌ ꞌin neꞌ bra kanꞌ; nchga nten nu tsaa naan ꞌin Ndiose, tyija lyo Ni ꞌin neꞌ bra kanꞌ; kwiꞌ ngwañaꞌan, nchga nten nu tyukwi ti tiye neꞌ chkwiꞌ neꞌ loꞌo Ndiose, kunan Ni chaꞌ nu chkwiꞌ neꞌ loꞌo Ni bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’Ja ska wan ta wan ska kee ku sñiꞌ wan bra nu jñan nu xuwe jaxlya ku. ¿Ta ta wan kee ku a? ");
INSERT INTO ctpNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ja nsuꞌwi nten nu ta ska kunan ku sñiꞌ bra nu jñan nu xuwe kula ku. ¿Ta kuꞌni wan ngwañaꞌan a? ");
INSERT INTO ctpNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kanꞌ chaꞌ sikwa, chaꞌ nu jlyo tiꞌ wan sa ñaꞌan ta wan nan suꞌwe ꞌin sñiꞌ wan, ni siya xaꞌan tiye wan, kwiꞌ ngwañaꞌan jlyo la tiꞌ Stian Ndiose nu ndiꞌin nde niꞌ kwan sa ñaꞌan nu ta Ni nan suꞌwe ꞌin nten nu njñan ska chaꞌ ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ndiꞌin chaꞌ kuꞌni wan chaꞌ suꞌwe loꞌo xka la nten si nchka tiꞌ wan chaꞌ suꞌwe ti kuꞌni neꞌ loꞌo wan. Ti kwiꞌ tñan kanꞌ ngulo Ndiose lo kityi nu ngwaꞌan ayman Moisés, ti kwiꞌ ti chaꞌ ngwaꞌan xka la ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; ska ñaꞌan ndyoꞌo ti chaꞌ nu ykwiꞌ nchga neꞌ kanꞌ lo kityi. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Xka chaꞌ ni: Ndiꞌin chaꞌ tyijin wan tu loꞌoo luꞌwi ti. Tnun ꞌa tu loꞌoo, kwiꞌ xiin ꞌa tuwiin seꞌen tsaa neꞌ lo jwlyaa. Suꞌwe ꞌa ñaꞌan tuwiin kanꞌ, nxkeꞌ tiꞌ neꞌ, kanꞌ chaꞌ kaꞌan ꞌa nten ndaꞌan tuwiin kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Luꞌwi ꞌa tu loꞌoo, lti ti tuwiin seꞌen tsaa neꞌ nu mjwi chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ; chinꞌ ti nten ndyija lyo tuwiin kanꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Xka chaꞌ ni: Chaꞌ tiya ti tiꞌ wan kuꞌni wan loꞌo nten nu kwiñi, nu nchkwiꞌ chaꞌ chabiyaꞌ ꞌin Ndiose nduꞌu neꞌ ꞌwan, nchkwiꞌ neꞌ. Ska ꞌni suꞌwe lka slyaꞌ, ja tlá iꞌ; loꞌo neꞌ kwiñi kanꞌ, nchka tiꞌ neꞌ kwiñi lyoꞌo neꞌ ꞌwan chaꞌ nten suꞌwe lka neꞌ, chaꞌ lka neꞌ ñaꞌan tiꞌ slyaꞌ. Suꞌwe ꞌa ngiꞌni neꞌ loꞌo wan, loꞌo nde niꞌ kasiya ꞌin neꞌ kanꞌ, xaꞌan ꞌa neꞌ. Kwiñi ꞌa neꞌ kanꞌ. Ja lka neꞌ kanꞌ ñaꞌan tiꞌ slyaꞌ; ñaꞌan tiꞌ nguoꞌo nu tlá ꞌa, ngwañaꞌan lka neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka xuꞌwi lyo wan ꞌin neꞌ kwiñi kanꞌ xa nu ñaꞌan wan sa ñaꞌan tñan ngiꞌni neꞌ, ni siya chaꞌ suꞌwe, ni siya chaꞌ kuxi ngiꞌni neꞌ. Ja ndyoꞌo mta chi kutun ꞌin kicheꞌ styaꞌ, loꞌo ja nda yka kicheꞌ nan xi kuan. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lo nchga yka kwiñi ndyoꞌo nan nu kunanjoꞌo ꞌñaan; yka nu tlá ni, ja ka kuan nan nu ndyoꞌo lo ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ja tyoꞌo nan nu ja suꞌwe nchku ꞌin ska yka kwiñii; ngwañaꞌan ska yka nu tlá, ja suꞌwe nan nu ndyoꞌo lo ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Siꞌyu neꞌ yka nu tlá kanꞌ, chaꞌ ja ka kunanjoꞌo ran ꞌñaan; tikin neꞌ yka kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nchka biyaꞌ tiꞌ wan sa ñaꞌan lka ska yka bra nu ñaꞌan wan nan nu ndyoꞌo lo ran; kwiꞌ ngwañaꞌan, ka biyaꞌ tiꞌ wan si kwiñi neꞌ kanꞌ bra nu ñaꞌan wan sa ñaꞌan tñan nu ngiꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Nsuꞌwi ꞌa nten nu nchkwiꞌ loꞌoǔn: “Xꞌnaǎn, Xꞌnaǎn” ndukwin neꞌ ꞌñaǎn; siꞌi nchga neꞌ kanꞌ nu sten seꞌen lka Ndiose ndloo la. Nten nu kunan chaꞌ nu nchkwiꞌ Stiǐn nu ndiꞌin nde niꞌ kwan, sa kanꞌ ti nten lka nu sten seꞌen nu lka Ndiose ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bra nu tiya bra chaꞌ kuꞌni biyaꞌ Ni ꞌin nchga nten chalyuu, bra kanꞌ tyoꞌo tukwa kaꞌan nten nu chkwiꞌ loꞌoǔn: “Xꞌnaǎn, Xꞌnaǎn” nchkwin neꞌ ꞌñaǎn, “loꞌo ba re, wa ykwiꞌ ba loꞌo nten chabiyaꞌ ꞌiin. Chabiyaꞌ ꞌiin wa ngulo ba ꞌin kwiꞌin kuxi nu msñi ꞌin nten, loꞌo wa yꞌni ba xka la chaꞌ tnun chabiyaꞌ ꞌiin” nchkwin neꞌ kanꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Loꞌo bra kanꞌ nde lka chaꞌ nu ndiꞌin chaꞌ xkweěn ꞌin neꞌ kanꞌ: “Ja nsuꞌwi lyoǔn ꞌwan siyaꞌ ti. ¡Yaa lya wan chaꞌ neꞌ xaꞌan lka wan!” ");
INSERT INTO ctpNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Nchga nten nu kunan suꞌwe chaꞌ nu nchkwiǐnꞌ re, nchga nten nu tukwa chaꞌ nu nchkwiǐnꞌ, lka neꞌ kanꞌ sa ñaꞌan lka ska nten nu ngiꞌni suꞌwe kwenta xa nu ti ji kwiñan yu naꞌan ꞌin yu. Kanꞌ mñan yu kanꞌ naꞌan ꞌin yu chunꞌ ska kee jaaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Loꞌo kanꞌ ngwiꞌya ꞌa tyoo, sa ñaꞌan yaꞌ nu ndiya tyiꞌa yuu la kiyaꞌ naꞌan nu ndukwa chunꞌ kee kanꞌ. Kwiꞌ lye ꞌa ngwa kwiꞌin, loꞌo ja mlyuu naꞌan kanꞌ, chaꞌ suꞌwe ꞌa seꞌen ndukwa ran chunꞌ kee kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kwiꞌ ngwañaꞌan, nchga nten nu kunan chaꞌ nu nchkwiǐnꞌ loꞌo neꞌ, loꞌo ja tukwa ꞌa neꞌ chaꞌ kanꞌ, lka neꞌ kanꞌ ñaꞌan tiꞌ ska nten tintu nu ja yꞌni suꞌwe kwenta bra nu ngwiñan yu naꞌan ꞌin yu lo ysiin ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ngwiꞌya ꞌa tyoo bra kanꞌ, sa ñaꞌan yaꞌ mxlyuu tyiꞌa yuu ꞌin naꞌan kanꞌ, loꞌo lye ꞌa ngwa kwiꞌin. Ja mdalo naꞌan kanꞌ bra kanꞌ, mlyuu ran bra kanꞌ. ¡Mdyii ran nguꞌun ran bra kanꞌ! Loꞌo nten nu ja xlyaa kunan chaꞌ nu nchkwiǐn, ¡tyii chaꞌ ꞌin neꞌ kanꞌ siyaꞌ ti! ");
INSERT INTO ctpNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Bra wa mdyii ngwaꞌu Jesús nchga chaꞌ re ꞌin neꞌ, yuwe ꞌa tiꞌ nten kaꞌan kanꞌ ni ñaꞌan chaꞌ nduꞌu yu ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mskeꞌ tiꞌ neꞌ chaꞌ tnun ꞌa chabiyaꞌ nsuꞌwi ꞌin yu xa nu nchkwiꞌ yu loꞌo neꞌ, ja ngiꞌni yu sa ñaꞌan ngiꞌni mstru nu nduꞌu chaꞌ joꞌo ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ngwiꞌya Jesús lo kiꞌya kanꞌ bra kanꞌ. Kaꞌan ꞌa nten ndaꞌan ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Loꞌo bra kanꞌ mdoꞌo tukwa ska yu tiꞌí seꞌen ndiꞌin Jesús. Mduun xtyinꞌ yu seꞌen ndiꞌin Jesús, chaꞌ nchka tiꞌ yu jñan yu ꞌin Jesús chaꞌ kuꞌni joꞌó ꞌin yu, chaꞌ nu msñi kicha mtsuꞌ kunaꞌ yu kanꞌ. ―Xꞌnaǎn ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús―, kuꞌnii joꞌó ꞌñaǎn. Jlyo tiǎnꞌ chaꞌ nchka ꞌiin kuꞌnii chaꞌ ka luwi kunaǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kanꞌ mstya yaꞌ Jesús chunꞌ yu tiꞌí kanꞌ, mstya yaꞌ seꞌen mtsuꞌ kunaꞌ yu. ―Kuꞌniǐn joꞌó ꞌiin ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ―. Kanun luwi kunaaꞌ ni ―ndukwin bra kanꞌ. Bra ti nchkaa yu tiꞌí kanꞌ, ngwa luwi kunaꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Xiyaꞌ ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Yaa lyaa seꞌen ndiꞌin sti joꞌo ―ndukwin―. Nde kwa taa lomstan nu ykwiꞌ ayman Moisés chaꞌ taan ꞌin Ndiose bra nu nchkaan ꞌin ska kicha nu nsuꞌwi ꞌñaan. Ja katsaaꞌ ꞌin xka la nten. Ka biyaꞌ tiꞌ nten chaꞌ wa nchkaa, bra nu kunan neꞌ chaꞌ wa msñi sti joꞌo lomstan nu ndaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Loꞌo mdiyan Jesús tuꞌwa kichen Capernaum bra kanꞌ. Kichen kanꞌ ndyukwa taꞌa yu loꞌo ska capitán ꞌin sndaru romano, kwiꞌ nu mjñan ꞌin Jesús chaꞌ kuꞌni joꞌó ꞌin ska nu tiꞌí: ");
INSERT INTO ctpNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Xꞌnaǎn ―ndukwin capitán kanꞌ ꞌin Jesús―, tiꞌí ꞌa msu ꞌñaǎn. Nan nskwa ti yu naꞌan tyiǐn chaꞌ nchkunꞌ ñaꞌaan tyukwin nsuꞌwi ꞌin yu, tiꞌí ꞌa yu kwa ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Tsaꞌaǎn. Kuꞌniǐn chaꞌ chkaa yu ―ndukwin Jesús ꞌin yu capitán kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bra ti mxkwen capitán ꞌin Jesús bra kanꞌ: ―Xꞌnaǎn ―ndukwin capitán ꞌin Jesús―, ja suꞌwe tsaa nde naꞌan tyiǐn, chaꞌ siꞌi nten suꞌwe lkaǎn. Sa kanꞌ ti chaꞌ nchka tiǎnꞌ, chaꞌ kuloo tñan chaꞌ katin kicha ꞌin yu; jlyo tiǎnꞌ chaꞌ chkaa msu ꞌñaǎn bra kanꞌ, ni siya tijyuꞌ ti tyuun chkwiiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Xꞌnan sndaru lkaǎn, naꞌ lkaǎn ndloo ꞌin ska siyentu sndaru; kwiꞌ ngwañaꞌan, ndiya nu lka ndloo la ꞌñaǎn. Si kuloǔn tñan re ꞌin ska sndaru ꞌñaǎn: “Yaa lyaa”, bra ti tsaa yu, chaꞌ nchka tiǎnꞌ chaꞌ tsaa yu. Ngwañaꞌan si chkwiǐnꞌ loꞌo xka yu: “Kaan nde re”, bra ti kan yu seꞌen ndiꞌiǐn bra kanꞌ. Ngwañaꞌan si kuloǔn tñan ꞌin msu ꞌñaǎn: “Kuꞌnii tñan re ꞌñaǎn”, chkwiǐnꞌ loꞌo yu, bra ti kuꞌni yu tñan kanꞌ ꞌñaǎn ―ndukwin capitán ꞌin Jesús―. Kanꞌ chaꞌ ni, jlyo tiǎnꞌ chaꞌ ka ꞌiin kuloo tñan chaꞌ katin kicha kanꞌ ꞌin msu kanꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nduwe ꞌa tiꞌ Jesús bra nu ynan chaꞌ nu ykwiꞌ capitán kanꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo nchga nten nu ndaꞌan ñaꞌan ꞌin: ―Chañi ꞌa chaꞌ nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús ꞌin neꞌ―. Ja ya ñaꞌaǎn ska nten nu suꞌwe la ndyaa ñaꞌan tiꞌ ꞌin Ndiose, sa ñaꞌan nu ndyaa ñaꞌan tiꞌ capitán re; ñaꞌaan nasiyun Israel re, ja nsuꞌwi nten nu ndyaa ñaꞌan tiꞌ ꞌin Ndiose ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chañi chaꞌ nde loo la kala kaꞌan ꞌa nten tijyuꞌ, loꞌo nten lo yuu nde seꞌen ndyoꞌo tukwa kwichaa, loꞌo nten lo yuu nde seꞌen ndyaa kwichaa, tsaa neꞌ chaꞌ tyukwa neꞌ tuꞌwa msaa seꞌen lka Ndiose ndloo niꞌ kwan; suꞌwa ti tyitukwa neꞌ tuꞌwa msaa kanꞌ loꞌo ayman Abraham loꞌo ayman Isaac loꞌo ayman Jacob. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kwiꞌ ngwañaꞌan, ndiya xka ta nten nu lka sñiꞌ Ndiose, ndukwin neꞌ, loꞌo ja kala ꞌa neꞌ kanꞌ seꞌen ndiꞌin Ndiose. Kulo Ndiose tñan ꞌin angajle ꞌin Ni chaꞌ tsaa xkwaan ꞌin neꞌ kanꞌ nde seꞌen ndiꞌin tla; kanan ꞌa neꞌ kanꞌ la kanꞌ, kasinꞌ ꞌa tiꞌ neꞌ sa ñaꞌan yaꞌ ku liꞌya neꞌ chaꞌ msinꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Xiyaꞌ ykwiꞌ Jesús loꞌo capitán bra kanꞌ: ―Yaa lyaa naꞌan tyii sikwa ―ndukwin Jesús―. Wa ndyaa ñaꞌan tiiꞌ ꞌñaǎn, kanꞌ chaꞌ nchkaa yu ni; ngwa tiin kicha kanꞌ ꞌin yu ―ndukwin Jesús ꞌin capitán. Ti kwiꞌ bra kanꞌ nchkaa msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Chunꞌ ndiꞌin la ndyaa Jesús nde naꞌan tyi Tyu. Loꞌo naꞌan Jesús chaꞌ nskwa ti jyaꞌan laa Tyu lo kiꞌyan, chaꞌ lye ꞌa nsuꞌwi tikeeꞌ ꞌin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Mstya yaꞌ Jesús chunꞌ yaꞌ neꞌ kula kanꞌ. Bra ti mdoꞌo tikeeꞌ ꞌin; mdyituun neꞌ kula kanꞌ bra kanꞌ, yꞌni kuwe tiꞌ chaꞌ keeꞌ chinꞌ nan ku Jesús loꞌo taꞌa ndaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bra wa msiin, mdiyan kaꞌan ꞌa nten seꞌen ndiꞌin Jesús, mdiyan loꞌo neꞌ ꞌin neꞌ kicha nu nsuꞌwi kwiꞌin kuxi ꞌin bra kanꞌ. Kanꞌ ngulo Jesús tñan ꞌin kwiꞌin kuxi kanꞌ, chaꞌ tyoꞌo tsuꞌ ran ꞌin neꞌ tiꞌí kanꞌ; nchkaa neꞌ kanꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan, yꞌni Jesús joꞌó ꞌin nchga neꞌ tiꞌí nu mdiyan seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ngwañaꞌan ngwa, chaꞌ mdoꞌo tukwa ti kwiꞌ ti chaꞌ nu ngwaꞌan ayman Isaías lo kityi nu ngwa sꞌni. Nde lka chaꞌ nu nchkwiꞌ kityi kanꞌ: “Wa jlyo tiꞌ Ndiose nchga seꞌen tiꞌí ꞌñaan, jlyo tiꞌ Ni sa ñaꞌan kicha nu nsuꞌwi ꞌñaan kwenta skaan; yꞌni tyii Ndiose nchga kicha kanꞌ, nchkaan bra kanꞌ.” Ngwañaꞌan ndukwa chaꞌ lo kityi, kanꞌ chaꞌ ngiꞌni Jesús joꞌó ꞌin nten nu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ngwa xka tsan naꞌan Jesús chaꞌ kaꞌan ꞌa nten ndaꞌan seꞌen ndiꞌin yu, kanꞌ chaꞌ ngulo yu tñan ꞌin taꞌa ndaꞌan yu chaꞌ tsaa loꞌo neꞌ ꞌin yu niꞌ yka naꞌan la xka laꞌa tsuꞌ tiyuꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","La wa tsaa ti neꞌ, bra kanꞌ mdiyan ska mstru nu nduꞌu chaꞌ joꞌo chaꞌ chkwiꞌ loꞌo Jesús: ―Mstru ―ndukwin mstru kanꞌ ꞌin Jesús―, loꞌoǔn nchka tiǎnꞌ tyaꞌaǎn loꞌoo nchga seꞌen tsaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Mxkwen Jesús ꞌin mstru kanꞌ bra kanꞌ: ―Nu lka kutaꞌ ni, niꞌ tukee ꞌin iꞌ xuꞌwi iꞌ; kwiꞌ ngwañaꞌan kiñi xuwe, ndiya seꞌen xkwa iꞌ. Loꞌo naꞌ ni, wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn lo chalyuu re chaꞌ kaǎn nten, loꞌo ja ndiya seꞌen kajaǎnꞌ, ja ndiya seꞌen tyukwaǎn xitñaǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Loꞌo kanꞌ ykwiꞌ xka yu kiꞌyu nu mdaꞌan loꞌo Jesús: ―Yu kula ―ndukwin yu ꞌin Jesús―, taa chinꞌ chabiyaꞌ ꞌñaǎn chaꞌ nu tyaꞌaǎn tuꞌwa naꞌan tyiǐn, tyaꞌaǎn chaꞌ kuꞌniǐn kwentaǎn ꞌin stiǐn sa ñaꞌan yaꞌ kaja stiǐn, chaꞌ tsaa ytsiǐnꞌ ꞌin stiǐn kulo ndukwa. Tsaꞌaǎn loꞌoo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kanꞌ mxkwen Jesús ꞌin yu: ―Suꞌwe la kaan ñaꞌaan ꞌñaǎn bra ti ―ndukwin Jesús ꞌin yu―. Ti ndiya chinꞌ xka la nten taꞌa wan nu ka kutsiꞌ ꞌin nten ꞌiin nu wa ngujwi. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Chunꞌ ndiꞌin la yten Jesús niꞌ yka naꞌan xuwe loꞌo neꞌ nu ngiꞌni xaꞌan ꞌin yu, mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kanꞌ lye ꞌa ngwa kwiꞌin, lye ꞌa ngatsa tyiꞌa lo tiyuꞌ, wa sten ti yka naꞌan kanꞌ niꞌ tyiꞌa siꞌya kulooꞌ. Lajaꞌ Jesús nsuꞌwi niꞌ yka naꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Mlyo neꞌ sla Jesús bra kanꞌ: ―¡Yu kula! ―ndukwin neꞌ ꞌin Jesús―, ¡kulaa lyaa ꞌwa seꞌen kuxi re! Wa sten ti yka naꞌan re niꞌ tyiꞌa, loꞌo kajaan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Loꞌo mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―¿Ni chaꞌ ngitsen ꞌa wan? ―ndukwin ꞌin neꞌ―. ¡Chinꞌ ꞌa ndyuꞌwi tiꞌ wan ꞌin Ndiose, chunꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌin Ni chaꞌ ka kulaa Ni ꞌñaan! Kanꞌ mdyituun Jesús, ykwiꞌ loꞌo kwiꞌin loꞌo kulooꞌ chaꞌ ka tiin ran; bra ti ngwa tiin ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yuwe ꞌa tiꞌ neꞌ kanꞌ bra kanꞌ, chunꞌ ngwa tiin kulooꞌ loꞌo kwiꞌin siyaꞌ ti. ―¿Ti lka ra yu kula re? ―ndukwin neꞌ ꞌin taꞌa neꞌ―. Ynan kulooꞌ chaꞌ nu ykwiꞌ yu, kwiꞌ ngwañaꞌan ynan kwiꞌin chaꞌ nu ykwiꞌ yu kula re loꞌo ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chunꞌ ndiꞌin la mdiꞌin neꞌ la xka laꞌa tsuꞌ tiyuꞌ nde lo yuu ꞌin neꞌ Gadara. Kanꞌ ndyukwa taꞌa Jesús loꞌo tukwa yu tiꞌí; nsuꞌwi kwiꞌin xaꞌan ꞌin taꞌa tyukwaa neꞌ kanꞌ, kanꞌ chaꞌ tlá ꞌa yu tiꞌí kanꞌ. Ndiꞌin neꞌ niꞌ lyoꞌoo ꞌin jyoꞌo, loꞌo ja nda neꞌ chabiyaꞌ tyijin xka la nten tuwiin kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Loꞌo yꞌni kwiꞌin xaꞌan kanꞌ, chaꞌ kwen ꞌa nxiꞌya yu tiꞌí kanꞌ: ―Jesús, ¿ni chaꞌ ndaꞌaan seꞌen ndiꞌin ba? ―ndukwin yu tiꞌí kanꞌ―. Nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose. ¿Ta taa nu tiꞌí ꞌwa, nchka tiiꞌ a? Ja ya tiya bra tiyan nu tiꞌí ꞌwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nde kwa la chinꞌ ndiꞌin ska ta kaꞌan ꞌa kuweꞌ, ndaꞌan naan iꞌ nan ku iꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Loꞌo yꞌni kwiꞌin xaꞌan kanꞌ, chaꞌ mjñan yu tiꞌí chabiyaꞌ ꞌin Jesús chaꞌ ꞌin kwiꞌin kanꞌ: ―Jlyo tiꞌ ba chaꞌ nchka tiiꞌ kuloo kwiꞌin nu nsuꞌwi ꞌwa, chaꞌ kuꞌni joꞌó ꞌwa ―ndukwin neꞌ kanꞌ ꞌin Jesús―. Kanꞌ chaꞌ taa chinꞌ chabiyaꞌ ꞌin kwiꞌin chaꞌ tsaa ran xuꞌwi ran ꞌin kuweꞌ nu ndaꞌan kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kanꞌ nu mda Jesús chabiyaꞌ ꞌin kwiꞌin kanꞌ: ―Yaa lya wan ―ndukwin Jesús ꞌin kwiꞌin kanꞌ. Bra ti mdoꞌo tsuꞌ kwiꞌin xaꞌan ꞌin taꞌa tyukwaa yu tiꞌí kanꞌ, ndyaa kwiꞌin kanꞌ msñi ꞌin kuweꞌ bra kanꞌ. Msnan nchga kuweꞌ kanꞌ, mdiyuu iꞌ ska tuꞌ kwaꞌan kwan tuꞌwa tiyuꞌ yten iꞌ niꞌ tyiꞌa, ngujwi nchga kuweꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bra nu naꞌan neꞌ nu nsuꞌwi kwan ꞌin kuweꞌ kanꞌ sa ñaꞌan nu ngwa ꞌin iꞌ, ytsen ꞌa neꞌ bra kanꞌ. Msnan neꞌ nde lo kichen chaꞌ katsaꞌ neꞌ ꞌin taꞌa kichen tyi neꞌ sa ñaꞌan nu ngwa ꞌin yu tiꞌí nu yuꞌwi kwiꞌin xaꞌan ꞌin, kwiꞌ ytsaꞌ neꞌ ꞌin neꞌ sa ñaꞌan nu ngwa ꞌin kuweꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Bra wa ynan neꞌ kichen chaꞌ kanꞌ, mdoꞌo neꞌ ndyaa neꞌ seꞌen ndiꞌin Jesús. Bra nu ndyukwa taꞌa neꞌ loꞌo Jesús, bra kanꞌ lye ꞌa mjñan neꞌ kanꞌ ꞌin yu chaꞌ ja kanun ꞌa yu lo yuu ꞌin kichen tyi neꞌ; tyaa yu xka seꞌen, nchka tiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Chunꞌ ndiꞌin la xiyaꞌ yten Jesús niꞌ yka naꞌan, chaꞌ tyijin yu lo tiyuꞌ tyaan yu kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Bra nu ngala yu kichen kanꞌ, bra kanꞌ mdiyan loꞌo nten ꞌin ska nu tiꞌí nu nchkunꞌ ñaꞌaan tyukwin yu; ndijyan neꞌ seꞌen ndiꞌin Jesús chaꞌ kuꞌni yu joꞌó ꞌin yu tiꞌí kanꞌ. Nsu yu tiꞌí kanꞌ ska niꞌ katan. Jlyo tiꞌ Jesús chaꞌ ndyaa ñaꞌan tiꞌ neꞌ kanꞌ ꞌin, kanꞌ chaꞌ ykwiꞌ yu loꞌo yu tiꞌí kanꞌ: ―Chkaa suꞌwee, sñiěnꞌ ―ndukwin Jesús ꞌin yu tiꞌí―. Wa yꞌniǐn chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndukwii. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Loꞌo ni, mdaꞌan ꞌa chaꞌ tiye mstru nu nduꞌu chaꞌ joꞌo nu nduun kwiꞌ seꞌen ti: “Chaꞌ kuxi nchkwiꞌ yu kiꞌyu re chaꞌ ꞌin Ndiose” mskeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Loꞌo mgii tiꞌ Jesús nchga loo chaꞌ nu ndaꞌan tiye neꞌ kanꞌ. ―¿Ni chaꞌ kuxi ꞌa ndaꞌan chaꞌ tiye wan loꞌoǔn ni? ―ndukwin Jesús ꞌin mstru kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ja ndiya tiꞌ wan chaꞌ nu ykwiǐnꞌ loꞌo yu tiꞌí re: “Wa yꞌniǐn chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndukwii.” ¿Ta chkwiǐnꞌ loꞌo yu tiꞌí: “Tyituun, tyoꞌoo taꞌaan ni” suꞌwe la sikwa a? ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ndiꞌin chaꞌ ka biyaꞌ tiꞌ wan chaꞌ nda Ndiose chabiyaꞌ ꞌñaǎn chaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndukwi nten chalyuu, chaꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Ka biyaꞌ tiꞌ wan bra nu ñaꞌan wan chaꞌ chkaa yu tiꞌí re. Bra kanꞌ xiyaꞌ ykwiꞌ Jesús loꞌo yu tiꞌí kanꞌ: ―Tyituun ―ndukwin Jesús ꞌin yu―, chkwaan katan ꞌiin, chaꞌ tyaa loꞌoo ꞌin ran nde naꞌan tyii. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Bra ti mdyituun yu tiꞌí kanꞌ, ndyaa yu naꞌan tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kaꞌan ꞌa nten naꞌan chaꞌ kanꞌ, ytsen ꞌa neꞌ bra kanꞌ. Yꞌni tnun neꞌ ꞌin Ndiose bra kanꞌ, chaꞌ wa nda Ni chabiyaꞌ ꞌin nten chalyuu chaꞌ kuꞌni chaꞌ tnun ngwañaꞌan, mskeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mdoꞌo Jesús ndyaa, loꞌo wa tyijin ti yu tuꞌwa naꞌan seꞌen ndukwa Mateo nu ndlo tñi ꞌin neꞌ chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ. Ykwiꞌ Jesús loꞌo Mateo kanꞌ bra kanꞌ: ―Tyoꞌoo ñaꞌaan ꞌñaǎn ―ndukwin Jesús ꞌin yu. Bra ti mdyituun Mateo, ngulaa tiꞌin yu tñan ꞌin yu, ndyaa ñaꞌan yu ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Chunꞌ ndiꞌin la mdiꞌin Jesús naꞌan tyi Mateo, ndukwa yu tuꞌwa msaa chaꞌ nchku yu bra kanꞌ. Loꞌo mdiyan kaꞌan ꞌa nten seꞌen ndiꞌin Mateo chaꞌ ku neꞌ loꞌo yu. Ndiꞌin neꞌ taꞌa ngiꞌni tñan loꞌo Mateo, loꞌo xka ta nten nu ndukwin neꞌ kichen ꞌin chaꞌ ja suꞌwe nten kanꞌ, loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús; suꞌwa ti nchku nchga neꞌ kanꞌ loꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Naꞌan neꞌ fariseo chaꞌ ndukwa Jesús nchku yu loꞌo neꞌ kanꞌ, kanꞌ chaꞌ bra ti ykwiꞌ neꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―¿Ni chaꞌ suꞌwa ti nchku xꞌnan wan loꞌo nten nu ja suꞌwe kwa, loꞌo nten nu lka msu ꞌin neꞌ xka laꞌa tsuꞌ, kwiꞌ nu ndaꞌan ndlo kaꞌan ꞌa tñi kwiñi ti ꞌin neꞌ taꞌa kichen tyian? ―ndukwin neꞌ fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ynan Jesús chaꞌ nu nchkwiꞌ neꞌ kanꞌ loꞌo taꞌa nchku yu, kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ fariseo bra kanꞌ: ―Nten nu ja tiꞌí ni, ja ndiꞌin chaꞌ ka joꞌó ꞌin ―ndukwin Jesús ꞌin neꞌ―. Nu tiꞌí ndiꞌin chaꞌ ka joꞌó ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yaa lya wan kunan suꞌwe wan chaꞌ re nu ngwaꞌan ayman lo kityi sꞌni: “Nchka la tiǎnꞌ chaꞌ chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan, ndukwin Ndiose. Kanꞌ nu suꞌwe la, ni siya ja ta wan kaꞌan ꞌa lomstan ꞌñaǎn; kwiꞌ ngwañaꞌan, ja ndiꞌin chaꞌ ta wan ꞌni skunꞌ wan chaꞌ ka lomstan ꞌñaǎn.” Ngwañaꞌan ndukwa chaꞌ lo kityi. Loꞌo naꞌ ni, ja ndijyaǎn lo chalyuu chaꞌ chkwiǐnꞌ loꞌo nten nu suꞌwe ꞌa ti ykwiꞌ ti, nxkeꞌ tiꞌ neꞌ; wa ndijyaǎn lo chalyuu chaꞌ chkwiǐnꞌ loꞌo nten nu jlyo tiꞌ chaꞌ ndiya chaꞌ kuxi tiye neꞌ, chaꞌ ka jyuꞌu tiꞌ neꞌ bra kanꞌ. Kulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Chunꞌ ndiꞌin la mdiyan xka ta nten seꞌen ndiꞌin Jesús, kwiꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Xuwa nu ndukwatya ꞌin neꞌ lka nten kanꞌ. Ykwiꞌ neꞌ kanꞌ loꞌo Jesús bra kanꞌ: ―Ndiya tsan nu ngiꞌni kuꞌnan bare ―ndukwin neꞌ―, kwiꞌ ndiya tsan nu ngiꞌni kuꞌnan neꞌ fariseo. Bare ngiꞌni kti ba tsan kanꞌ, loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin, loꞌo ykwiiꞌ, nchga tsan nchku wan. ¿Ni chaꞌ nchku wan ya ñaꞌan ti tsan bra nu ngiꞌni kuꞌnan bare? ");
INSERT INTO ctpNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Bra nu kaja kwilyoꞌo nten, nchku neꞌ nu ndaꞌan loꞌo yu kiꞌyu; ja xiꞌin tiꞌ neꞌ tsan nu ndiꞌin neꞌ loꞌo nu kiꞌyu nu mjwi kwilyoꞌo kanꞌ ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Bra nu tiya tsan chaꞌ tyaa loꞌo nten ꞌin yu kiꞌyu kanꞌ, kuꞌni kuꞌnan neꞌ nu taꞌa suꞌwe nsuꞌwi yu kiꞌyu kanꞌ, chaꞌ ka xiꞌin tiꞌ neꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan, suꞌwe nka tiye taꞌa suꞌwe nsuꞌwiǐn ni, loꞌo ka xiꞌin tiꞌ neꞌ chunꞌ ndiꞌin la ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Xka chaꞌ chkwiǐnꞌ loꞌo wan: Ja tukwin kuꞌni xuꞌwe ska teꞌ kusun ꞌin neꞌ loꞌo sa yuꞌwe teꞌ tiji, chaꞌ bra nu wa ngaten teꞌ kanꞌ, ndyiꞌiin teꞌ tiji kanꞌ; katiꞌ seꞌen nchkwan teꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ti kwiꞌ ti chaꞌ, ja xuꞌwi neꞌ xalyu nu tka mdoꞌo ti niꞌ chkaꞌ kula. Bra nu suꞌwa neꞌ ꞌin ran niꞌ chkaꞌ kula, ndla ti katsu siꞌ chkaꞌ kanꞌ; tyii chkaꞌ kanꞌ lyaꞌa bra kanꞌ, tyii xalyu kalu bra kanꞌ. Niꞌ chkaꞌ tiji xuꞌwi xalyu nu tka mdoꞌo ti; ngwañaꞌan talo taꞌa tyukwaa nan, loꞌo xalyu loꞌo chkaꞌ bra kanꞌ. (Ngwañaꞌan ngwaꞌu Jesús ꞌin neꞌ chaꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ ja suꞌwe xtiyaaꞌ neꞌ chaꞌ kwi nu nduꞌu yu chaꞌ ꞌin Ndiose loꞌo chaꞌ kula nu mxnun ayman kula chaꞌ kuꞌni neꞌ.) ");
INSERT INTO ctpNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Bra nu ti nchkwiꞌ Jesús loꞌo neꞌ, kanꞌ mdiyan ska neꞌ judío nu lka ndloo la; mduun xtyinꞌ yu kula tloo Jesús, chaꞌ jñan ska chaꞌ tlyu tiꞌ ꞌin yu bra kanꞌ: ―Tka ngujwi ti ska nu kunaꞌan lyuꞌ ti, sñiěnꞌ ―ndukwin yu kula kanꞌ ꞌin Jesús―. ¿Ja tsaa chinꞌ seꞌen ndiꞌiǐn chaꞌ xtyaa yaaꞌ chunꞌ nu lyuꞌ ti kanꞌ a? ―ndukwin―. Jlyo tiǎnꞌ chaꞌ ka ꞌiin kuꞌnii chaꞌ tyuꞌu nu lyuꞌ ti kanꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kanꞌ chaꞌ mdoꞌo Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa neꞌ loꞌo yu kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tuwiin seꞌen ndyaa neꞌ ndyukwa ska nu kunaꞌan tiꞌí ꞌin Jesús, mdiyan nde chunꞌ yu chaꞌ kalaꞌ kiyaꞌ steꞌ yu; wa tii tyukwa yijan tiꞌí nu kunaꞌan kanꞌ, chaꞌ ngalu tnen neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","“Nu kalaǎnꞌ tiǎn steꞌ Jesús, bra kanꞌ chkaǎn.” Ngwañaꞌan mdaꞌan chaꞌ tiye neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kanꞌ mxituun Jesús, naꞌan ꞌin nu kunaꞌan kanꞌ: ―Kuꞌnii xuꞌwee tiyee, sñiěnꞌ ―ndukwin Jesús―. Ndyaa ñaꞌan tiiꞌ ꞌñaǎn, kanꞌ chaꞌ nchkaa ni. Loꞌo bra ti nchkaa neꞌ kula kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Chunꞌ ndiꞌin la ndiya Jesús naꞌan tyi nu lka ndloo la kanꞌ, naꞌan yu chaꞌ wa mdiyan neꞌ muska nde kwa chaꞌ nskwa angajle; nganan ꞌa nten ndiꞌin naꞌan tyi yu kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Tyaa wan suꞌwe la ―ndukwin―. Nan lajaꞌ ti nu lyuꞌ re, siꞌi nan ngujwi re. Mstyi lyoꞌo ꞌa neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ngulo Jesús ꞌin neꞌ chaꞌ kaja seꞌen sten ykwiꞌ yu niꞌ ñaꞌan seꞌen nskwa nu lyuꞌ ti nu ngujwi kanꞌ. Loꞌo msñi yu yaꞌ nu lyuꞌ ti kanꞌ, mxituun yu nu lyuꞌ ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ngwañaꞌan ngwa chaꞌ nganen chaꞌ kanꞌ nchga kichen seꞌen ndiꞌin nten la kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chunꞌ ndiꞌin la mdoꞌo Jesús niꞌ ñaꞌan kanꞌ ndyaa yu, kanꞌ mdaꞌan ñaꞌan tukwa yu kwityiinꞌ ꞌin yu. Msiꞌya yu ꞌin Jesús bra kanꞌ: ―¡Chka tꞌnan tiiꞌ ꞌwa, yu kula! Nuꞌwin lkaa nten taꞌa ayman David ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Bra wa mdiyan Jesús niꞌ ñaꞌan, loꞌo yu kwityiinꞌ kanꞌ mdiyan neꞌ seꞌen ndiꞌin yu. Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―¿Ta ndyaa ñaꞌan tiꞌ wan chaꞌ ka ꞌñaǎn kuꞌniǐn chaꞌ chkaa wan a? ―ndukwin yu ꞌin neꞌ. ―Ndyaa ñaꞌan tiꞌ ba ꞌiin, yu kula ―ndukwin yu kwityiinꞌ kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kanꞌ ylaꞌ Jesús kiloo taꞌa tyukwaa yu kwityiinꞌ kanꞌ. ―Chkaa wan sikwa. Ngwañaꞌan ka ꞌwan chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn ―ndukwin Jesús ꞌin yu kwityiinꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bra ti nchkaa kiloo neꞌ, ñaꞌan suꞌwe neꞌ bra kanꞌ. Kwiꞌ lye ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ja siyaꞌ katsaꞌ wan chaꞌ re ꞌin nten, chaꞌ ja ka biyaꞌ tiꞌ neꞌ ni ñaꞌan ngwa chaꞌ nchkaa kiloo wan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ, loꞌo ytsaꞌ neꞌ ꞌin nchga nten sa ñaꞌan ngwa chaꞌ tnun nu yꞌni Jesús loꞌo neꞌ; kanꞌ chaꞌ nganen chaꞌ kanꞌ ñaꞌaan lo yuu kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti kwiꞌ bra nu wa tyoꞌo ti neꞌ kanꞌ tyaa neꞌ, bra kanꞌ mdiyan xka ta nten, yan loꞌo neꞌ ꞌin ska yu kuꞌun; nan kuꞌun yu siꞌya kwiꞌin kuxi nu nsuꞌwi ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bra nu ngulo Jesús kwiꞌin kuxi ꞌin yu tiꞌí kanꞌ, ngwa ykwiꞌ yu tiꞌí bra kanꞌ, ni siya tsan ti kuꞌun yu. Yuwe ꞌa tiꞌ nchga nten nu mduun nde kwa bra kanꞌ. ―Ja ya ñaꞌaan ska chaꞌ tnun ngwañaꞌan ―ndukwin neꞌ ꞌin taꞌa neꞌ―. Ja nsuꞌwi nten tyukwi ñaꞌaan nasiyun Israel re nu ka kuꞌni joꞌó ngwañaꞌan ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Xka ñaꞌan ykwiꞌ neꞌ fariseo kanꞌ: ―Nan ndlo Jesús kwa ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin nten loꞌo chabiyaꞌ ꞌin xꞌnan kuneꞌ xaꞌan, kanꞌ chaꞌ nchka ꞌin yu kuꞌni yu ngwañaꞌan ―ndukwin neꞌ fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Chunꞌ ndiꞌin la ndyaa Jesús nchga kichen xuwe, nchga kichen tnun, chaꞌ kwaꞌu yu ꞌin neꞌ niꞌ lyaa ꞌin neꞌ judío. Kaꞌan ꞌa chaꞌ ykwiꞌ Jesús loꞌo nten ni ñaꞌan ka suꞌwe chaꞌ, xa nu ka Ndiose ndloo niꞌ kasiya ꞌin neꞌ. Loꞌo yꞌni yu joꞌó ꞌin nchga nu tiꞌí loꞌo nchga nten nu naꞌan ꞌa tiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ngwa tꞌnan ꞌa tiꞌ Jesús ꞌin kaꞌan ꞌa nten nu ndaꞌan ñaꞌan ꞌin yu, chaꞌ ja nchka ꞌin neꞌ kanꞌ; ja jlyo ꞌa tiꞌ neꞌ kanꞌ ni ñaꞌan nu tyiꞌin suꞌwe la neꞌ. Sa ñaꞌan ngiꞌni slyaꞌ nu ja nsuꞌwi nu ñaꞌansiin ꞌin iꞌ, ngwañaꞌan ngiꞌni nten kaꞌan kanꞌ, mskeꞌ tiꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ytsaꞌ yu ska chaꞌ ꞌin neꞌ chaꞌ ꞌin nten kaꞌan kanꞌ. Ykwiꞌ yu chaꞌ ja ya kunan suꞌwe nten kanꞌ chaꞌ ꞌin Ndiose, chaꞌ ñaꞌan tiꞌ ska jyan nu suꞌwe ꞌa ngutsi chaꞌ wa ndla ti kuꞌni neꞌ kwa ꞌin ran, ngwañaꞌan lka nten kanꞌ. ―Chañi chaꞌ nsuꞌwi ꞌa tñan re chaꞌ chkwianꞌ loꞌo nten chaꞌ sten neꞌ chaꞌ ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Loꞌo chinꞌ ti nten ndiya nu ka kuꞌni tñan re. ");
INSERT INTO ctpNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kanꞌ chaꞌ chkwiꞌ wan loꞌo Stiǐn nu lka Xꞌnan tñan re, chaꞌ ti ta la Ni tyun nten nu ka kuꞌni tñan re. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Chunꞌ ndiꞌin la msiꞌya Jesús ꞌin tii tyukwa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kan neꞌ seꞌen ndiꞌin yu. Mda yu chabiyaꞌ ꞌin neꞌ kanꞌ, chaꞌ tsaa neꞌ lo tñan ꞌin yu, chaꞌ kulo neꞌ kwiꞌin kuxi nu nsuꞌwi ꞌin nten; loꞌo mda yu chabiyaꞌ chaꞌ kuꞌni neꞌ chaꞌ chkaa nchga nu tiꞌí, nchga nu nsuꞌwi kicha. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nde ndaꞌaǎn nin taꞌa tii tyukwa neꞌ nu ngulo suwi Jesús: kulo ngulo suwi yu ꞌin Simón, nu mstya Jesús xka nin chaꞌ ka naan yu Tyu, loꞌo Ndre taꞌa ngula Simón kanꞌ; kanꞌ ngulo suwi yu ꞌin Santiago, loꞌo Xuwa taꞌa ngula Santiago, nu lka sñiꞌ Zebedeo; ");
INSERT INTO ctpNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","loꞌo ngulo suwi yu ꞌin Lpe, loꞌo Bartolomé, loꞌo Toma, loꞌo Mateo nu ngulo tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ ti kulo; loꞌo ngulo suwi yu ꞌin Santiago sñiꞌ Alfeo, loꞌo Tadeo; ");
INSERT INTO ctpNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ngulo suwi yu ꞌin Simón nu ngwa neꞌ cananista, loꞌo Juda Iscariote nu kujwiꞌ xuꞌwa ꞌin Jesús ꞌin nten kuxi nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ngulo Jesús tñan re ꞌin tii tyukwa neꞌ kanꞌ: ―Ja tsaa wan tuwiin nde xka laꞌa tsuꞌ seꞌen ndiꞌin nten nu ja ndiꞌin chaꞌ ꞌin loꞌo Ndiose siyaꞌ ti, loꞌo ja tsaa wan kichen tyi neꞌ Samaria ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ska ti seꞌen ndiꞌin neꞌ Israel taꞌa kichen tyi wan tsaa wan, chaꞌ tꞌnan ꞌa neꞌ kanꞌ; sa ñaꞌan ngiꞌni slyaꞌ nu wa mnaꞌ, ngwañaꞌan ngiꞌni neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Katsaꞌ wan ꞌin nten nchga kichen chaꞌ wa tiya ti bra chaꞌ ka Ndiose ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Kuꞌni wan chaꞌ chkaa neꞌ tiꞌí, kuꞌni wan chaꞌ tyuꞌu neꞌ xiyaꞌ bra nu wa ngujwi neꞌ; kuꞌni wan joꞌó ꞌin neꞌ nu ngatsuꞌ kunaꞌ, chaꞌ ka luwi kunaꞌ neꞌ tiꞌí kanꞌ xiyaꞌ; kulo wan kwiꞌin kuxi nu nsuꞌwi ꞌin nten. Ja msñiǐn tñi chaꞌ ndaǎn chabiyaꞌ ꞌwan chaꞌ kuꞌni wan joꞌó ꞌin neꞌ tiꞌí, kanꞌ chaꞌ ja xñi wan tñi chaꞌ kuꞌni wan joꞌó ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Ja loꞌo tñi kwiꞌya wan tsaa wan, ni siya tñi oro, ni siya tñi plata, ni siya tñi xuwe; ");
INSERT INTO ctpNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ja loꞌo kisu tyaja kwiꞌya wan tsaa wan. Kwiꞌ ngwañaꞌan, ja kwiꞌya loꞌo wan xka ykanꞌ, ja loꞌo xka snan wan, ja loꞌo yka skan kwiꞌya wan tsaa wan. Tloo ti wan tsaa wan. Bra nu ndayaꞌ wan ꞌin nten, ndiꞌin chaꞌ xku neꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Bra nu kala wan ska kichen, ni siya kichen tnun, ni siya kichen xuwe ti, bra kanꞌ tsaa naan wan ꞌin ska nten nu suꞌwe nka tiye ñaꞌan ꞌwan. Seꞌen ndiꞌin yu kanꞌ tyiꞌin wan sa ñaꞌan bra nu tyoꞌo wan tsaa wan xka kichen. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Bra nu sten wan tu naꞌan tyi yu, jñan wan ꞌin Ndiose chaꞌ tiin ti tyiꞌin neꞌ kwa tyi. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si chañi chaꞌ nchka tiꞌ neꞌ nu ndiꞌin niꞌ ñaꞌan kanꞌ kunan la neꞌ chaꞌ ꞌin Ndiose, kanꞌ kuꞌni Ndiose chaꞌ tiin ti tyiꞌin neꞌ kanꞌ bra kanꞌ; si kwiñi lyoꞌo ti neꞌ ꞌwan chaꞌ nchka tiꞌ neꞌ kunan neꞌ, ja jñan wan xuꞌwe ꞌin Ndiose chaꞌ ꞌin neꞌ kanꞌ. Ja chkwiꞌ ꞌa wan chaꞌ ꞌin Ndiose loꞌo neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Bra nu ja nchka tiꞌ nten chaꞌ kanun wan seꞌen ndiꞌin neꞌ, nu ja xlyaa neꞌ kunan neꞌ chaꞌ nu nduꞌu wan ꞌin neꞌ, kulaa yaꞌ wan ꞌin neꞌ kanꞌ, xnun wan ꞌin kichen kanꞌ bra kanꞌ; kwiꞌ ngwañaꞌan, skwin wan kiyaꞌ wan chaꞌ tyoꞌo yuu nu nsuꞌwi snan wan bra nu tyoꞌo wan kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Chañi chaꞌ nchkwiǐnꞌ loꞌo wan, chaꞌ xa nu tiya tsan nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten, bra kanꞌ lye ꞌa ta Ndiose nu tiꞌí ꞌin neꞌ kichen seꞌen ja xlyaa neꞌ kunan neꞌ chaꞌ nu kwaꞌu wan ꞌin neꞌ. Tsan kanꞌ ka suꞌwe la chaꞌ ꞌin neꞌ xaꞌan nu mdiꞌin kichen Sodoma, nu mdiꞌin kichen Gomorra nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Kunan suꞌwe wan chaꞌ nchkwiǐnꞌ: Suꞌwaǎn ꞌwan chaꞌ tsaa wan xka kichen ñaꞌan tiꞌ si lka wan slyaꞌ nu ndaꞌan laja nguoꞌo tlá; kanꞌ chaꞌ, chaꞌ tiya ti tiꞌ tyiꞌin wan laja nten, sa ñaꞌan ndaꞌan kunan nu tiya ꞌa tiꞌ. Suꞌwe ti tyiꞌin wan, ja kuꞌni tlá wan ꞌin nten siyaꞌ ti. Ka wan ñaꞌan tiꞌ kiñi cha kuun, chaꞌ msu ꞌa iꞌ, ja tlá iꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ndii ti tiꞌ wan tyiꞌin wan laja nten; ja chan tsaa loꞌo neꞌ ꞌwan seꞌen ndukwa neꞌ wsiya, ni siya ja yꞌni tlá wan ꞌin nten. Kwiꞌ jwiꞌin neꞌ ꞌwan niꞌ lyaa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ndiya nten nu tsaa loꞌo ꞌwan seꞌen ndiꞌin neꞌ nu lka ndloo la chaꞌ tiꞌí ti tiꞌ neꞌ ꞌwan, loꞌo tsaa loꞌo neꞌ ꞌwan tloo ykwiꞌ ree. Xa nu ta neꞌ nu tiꞌí ꞌwan chunꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn, kaja chinꞌ bra ꞌwan chaꞌ chkwiꞌ wan chinꞌ chaꞌ ꞌñaǎn loꞌo neꞌ kanꞌ, loꞌo neꞌ xka laꞌa tsuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Xa nu tsaa loꞌo neꞌ ꞌwan seꞌen ndukwa neꞌ wsiya, ja tyaꞌan chaꞌ tiye wan sa ñaꞌan chaꞌ nu chkwiꞌ wan loꞌo neꞌ kanꞌ, sa ñaꞌan ka xkwen wan ꞌin neꞌ kanꞌ. Kuꞌni Ndiose chaꞌ kiꞌya chaꞌ tiya ke wan chaꞌ chkwiꞌ wan loꞌo neꞌ kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","chaꞌ siꞌi chaꞌ ꞌwan ti nu chkwiꞌ wan bra kanꞌ; chaꞌ ꞌin Tyiꞌi Ndiose nu lka Stian, kanꞌ ka chaꞌ nu chkwiꞌ wan loꞌo neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ndii ti tiꞌ wan tyiꞌin wan lo chalyuu sikwa, chaꞌ loꞌo taꞌa ngula wan tsaa loꞌo ꞌwan chaꞌ kwiñi ti xtya kiꞌya ꞌwan tloo nten kuxi kanꞌ. Loꞌo sti wan kujwiꞌ xuꞌwa ꞌwan. Loꞌo ti kwiꞌ sñiꞌ wan, kujwiꞌ xuꞌwa ꞌwan tloo nten kuxi kanꞌ; kujwi neꞌ ꞌwan, nka tiye neꞌ kuneꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kwiꞌ ngwañaꞌan kuꞌni liyeꞌ tiꞌ nchga nten ꞌwan chunꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn. Nten nu talo chaꞌ tyijin nchga chaꞌ kuxi kanꞌ, suꞌwe ti tyoꞌo neꞌ kanꞌ, kaja chalyuu kwi nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Suꞌwe la xnan wan xka kichen xa nu lye ꞌa ngiꞌni liyeꞌ tiꞌ neꞌ ꞌwan. Chañi chaꞌ nchkwiǐnꞌ loꞌo wan ni: Ja ya chkwiꞌ wan chaꞌ ꞌñaǎn loꞌo neꞌ Israel nchga kichen tyi neꞌ bra nu kaǎn lo chalyuu xiyaꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Nten nu lka mstru ꞌin neꞌ, kanꞌ lka nu jlyo la tiꞌ; ja jlyo tiꞌ neꞌ kuneꞌ nu tka ngiꞌni xaꞌan ti nchga chaꞌ. Kwiꞌ ngwañaꞌan nten nu lka xꞌnan msu, kanꞌ lka ndloo la ꞌin neꞌ; siꞌi msu nu lka ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ska ti biyaꞌ tyijin neꞌ kuneꞌ kanꞌ nu tiꞌí bra kanꞌ, sa ñaꞌan nu nchka ꞌin mstru ꞌin neꞌ; ska ti biyaꞌ ka tñan tukwi ꞌin msu kanꞌ bra kanꞌ, sa ñaꞌan nu nchka ꞌin xꞌnan neꞌ. Wa ykwiꞌ neꞌ chaꞌ lkaǎn Beelzebú, kwiꞌ nu lka xꞌnan kuneꞌ xaꞌan, kanꞌ chaꞌ ka biyaꞌ tiꞌ wan chaꞌ tiꞌí ꞌa chkwiꞌ neꞌ ꞌwan nu ndiꞌin chaꞌ ꞌwan loꞌoǔn, chaꞌ naꞌ lkaǎn Xꞌnan wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Kanꞌ chaꞌ ykwiǐnꞌ chaꞌ ja kutsen wan ꞌin nten chalyuu ti. Nchga chaꞌ nu ngiꞌni neꞌ mnan ti, tyija lyo chaꞌ kanꞌ ꞌin nten nde loo la; nchga chaꞌ ꞌin neꞌ nu nsuꞌwi kutsiꞌ ti ꞌin nten, ka biyaꞌ tiꞌ nten chaꞌ kanꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nchga chaꞌ nu nchkwiǐnꞌ loꞌo wan seꞌen ndiꞌin wan ska ti wan, chkwiꞌ wan chaꞌ kanꞌ loꞌo nchga nten nde loo la; kwiꞌ ngwañaꞌan, skaa chaꞌ nu nduꞌuǔn ꞌwan mnan ti, kwen chkwiꞌ wan chaꞌ kanꞌ loꞌo nchga neꞌ kichen. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ja kutsen wan ꞌin neꞌ nu kujwi ꞌwan lo chalyuu re, chaꞌ ja nchka ꞌin neꞌ kujwi neꞌ ꞌin kasiya ꞌwan; suꞌwe la kutsen wan ꞌin Ndiose nu kuꞌni biyaꞌ ꞌwan nde loo la. Chañi chaꞌ kutsen wan ꞌin Ndiose, kwiꞌ nu kuꞌni chaꞌ tyii chaꞌ ꞌwan si tsaa wan nde jwlyaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Wa jlyo tiꞌ wan chaꞌ xꞌnan ꞌa ngaꞌan kiñi xuwe nu ndujwiꞌ nten, tukwa kiñi xuwe kaja ꞌwan ska ti tñi. Ti kwiꞌ Stiǐn nu lka ndloo la ti, nchga chaꞌ jlyo tiꞌ Ni; ni siya ska ti kiñi xuwe kaja iꞌ, wa jlyo tiꞌ Ni chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kwiꞌ ngwañaꞌan, wa nkwa Ndiose nchga kichanꞌ ke wan, jlyo tiꞌ Ni ni nkwa kichanꞌ ndukwa ke skaa wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Loꞌo ꞌwan ni, kaꞌan la nsuꞌwi lyo wan nde seꞌen ndiꞌin Ndiose; ni siya kaꞌan ꞌa kiñi xuwe, ja suꞌwa nsuꞌwi lyo iꞌ loꞌo wan. Kanꞌ chaꞌ ja ndiꞌin chaꞌ kutsen wan ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Loꞌo xka chaꞌ ni: Nchga nten nu ndiꞌin chaꞌ ꞌin loꞌoǔn, nu nchkwiꞌ chaꞌ ꞌñaǎn loꞌo nten, naꞌ chkwiǐnꞌ loꞌo Stiǐn Ndiose nu ndiꞌin nde niꞌ kwan chaꞌ taꞌa suꞌwe nsuꞌwiǐn lka nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Loꞌo nchga nten nu nchkwiꞌ loꞌo taꞌa nten chaꞌ ja ndiꞌin chaꞌ ꞌin loꞌoǔn, naꞌ chkwiǐnꞌ loꞌo Stiǐn nu ndiꞌin nde niꞌ kwan chaꞌ siꞌi taꞌa suꞌwe nsuꞌwiǐn lka nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ja xkeꞌ tiꞌ wan chaꞌ tiin ti tyiꞌin nten chalyuu chaꞌ ꞌñaǎn, chaꞌ wa ndijyaǎn. Ja ka ngwañaꞌan. Lye la xuun taꞌa neꞌ chaꞌ ꞌñaǎn; ");
INSERT INTO ctpNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","xuun ska nten loꞌo sti yu chaꞌ ꞌñaǎn, xuun ska nu kunaꞌan loꞌo jyaꞌan chaꞌ ꞌñaǎn, xuun sñiꞌ xiin neꞌ loꞌo jyaꞌan laa neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Xuun taꞌa neꞌ ngwañaꞌan sa ñaꞌan bra ka kontra ꞌin neꞌ nchga taꞌa ndiꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Suꞌwe ꞌa chaꞌ chka tꞌnan tiꞌ nten ꞌin sti neꞌ, ꞌin jyaꞌan neꞌ; loꞌo si chinꞌ la nka tiye neꞌ kanꞌ loꞌoǔn, ja ka tyaꞌan neꞌ kanꞌ loꞌoǔn bra kanꞌ. Kwiꞌ ngwañaꞌan, suꞌwe chaꞌ chka tꞌnan tiꞌ nten ꞌin sñiꞌ neꞌ, ni siya kiꞌyu, ni siya kunaꞌan; loꞌo si chinꞌ la nka tiye neꞌ kanꞌ loꞌoǔn, ja ka tyaꞌan neꞌ kanꞌ loꞌoǔn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja ka chkwiꞌ nten chaꞌ naꞌ lkaǎn Xꞌnan neꞌ, bra nu ja nchka tiꞌ neꞌ kanꞌ tyaꞌan neꞌ loꞌoǔn tuwiin nu kwaꞌuǔn ꞌin neꞌ chaꞌ tsaa neꞌ. Ndiꞌin chaꞌ xñi neꞌ tuwiin kanꞌ, ni siya kujwi xka la nten ꞌin neꞌ kanꞌ chunꞌ msñi neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ja kaja chalyuu kwi nu ja tsaa tii ꞌa ꞌin neꞌ nu lye la nka tiye neꞌ ꞌin neꞌ ti ykwiꞌ ti neꞌ, kwiꞌ nu ja nda ꞌa bra chaꞌ kujwi nten ꞌin neꞌ chaꞌ ꞌñaǎn. Loꞌo kaja chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ si kujwi nten ꞌin neꞌ chunꞌ msñi neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Xka chaꞌ ni: Xa nu ta nten seꞌen tyiꞌin wan naꞌan tyi neꞌ, suꞌwa lka chaꞌ kanꞌ sa ñaꞌan si wa nda neꞌ seꞌen tyiꞌiǐn naꞌan tyi neꞌ. Kwiꞌ ngwañaꞌan, xa nu ta neꞌ seꞌen tyiꞌiǐn loꞌo neꞌ, suꞌwa lka chaꞌ kanꞌ sa ñaꞌan si wa nda neꞌ seꞌen tyiꞌin Ndiose loꞌo neꞌ, chaꞌ ti kwiꞌ Ndiose lka nu wa msuꞌwa ꞌñaǎn ndijyaǎn nde re. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Loꞌo xa nu ta neꞌ seꞌen tyiꞌin ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo neꞌ, chaꞌ ndyaꞌan nten kanꞌ lo tñan ꞌin Ndiose, suꞌwe ꞌa ka ꞌin neꞌ nde loo la. Kanꞌ kaja ska chaꞌ suꞌwe nu ta Ndiose ꞌin neꞌ kanꞌ; suꞌwa ti ka ꞌin neꞌ kanꞌ loꞌo nten nu nchkwiꞌ chaꞌ ꞌin Ndiose bra kanꞌ. Kwiꞌ ngwañaꞌan, bra nu ta neꞌ seꞌen tyiꞌin ska nten nu suꞌwe ꞌa tiye chunꞌ ndukwa yu chaꞌ nchkwiꞌ Ndiose, suꞌwa ka ꞌin neꞌ kanꞌ loꞌo nten nu suꞌwe ꞌa tiye kanꞌ, chaꞌ ta Ndiose ska chaꞌ suꞌwe ꞌin neꞌ kanꞌ nde seꞌen ndiꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Kwiꞌ ngwañaꞌan, bra nu ta neꞌ ska skaꞌ tyiꞌa koꞌo neꞌ kuneꞌ re chunꞌ ngiꞌni xaꞌan neꞌ chaꞌ ꞌñaǎn, chañi chaꞌ ta Ndiose ska chaꞌ suꞌwe ꞌin neꞌ kanꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Bra nu mdyii ngwaꞌu Jesús chaꞌ kanꞌ ꞌin tii tyukwa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu, kanꞌ mdoꞌo yu ndyaa yu chaꞌ chkwiꞌ yu loꞌo neꞌ tyun kichen nu ndiꞌin kwiꞌ seꞌen ti; ngwaꞌu yu ꞌin neꞌ kichen kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti nsuꞌwi Xuwa kanꞌ niꞌ ñaꞌan chkwan, wa ynan yu chaꞌ ꞌin nchga tñan nu ngiꞌni Jesús nu nka Krixtu; kanꞌ chaꞌ ngulo Xuwa tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ tsaa neꞌ kanꞌ seꞌen ndiꞌin Jesús, ");
INSERT INTO ctpNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chaꞌ kunichaꞌ neꞌ kanꞌ chaꞌ re ꞌin Jesús chaꞌ ꞌin Xuwa: ―¿Ta chañi chaꞌ nuꞌwin lkaa ti kwiꞌ nu wa kan ti a? ―ndukwin neꞌ kanꞌ ꞌin Jesús bra kanꞌ―. ¿Ta kan la xka nu ka Krixtu ykwiꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Yaa wan katsaꞌ wan ꞌin Xuwa nchga loo chaꞌ nu ynan wan seꞌen ndiꞌiǐn, nchga chaꞌ nu naꞌan wan seꞌen ndiꞌiǐn ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Katsaꞌ wan ꞌin yu sa ñaꞌan ngiꞌniǐn chaꞌ nchkaa kiloo nten nu ngwa kwityiinꞌ, chaꞌ ndaꞌan nten nu ngwa tiꞌí kiyaꞌ, chaꞌ ngwa luwi kunaꞌ nten nu mtsuꞌ kunaꞌ, chaꞌ nu nnan nten nu ngwa kuꞌun tu nskan, chaꞌ ndyuꞌu nten xiyaꞌ bra nu wa ngujwi neꞌ, chaꞌ nchka biyaꞌ tiꞌ nu tiꞌi sa ñaꞌan nu kulaa Ndiose ꞌin nten chalyuu ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Suꞌwe ꞌa ka tiye nten nu ti ndyaa ñaꞌan tiꞌ ꞌñaǎn, kwiꞌ nu ja kulaa yaꞌ ꞌñaǎn chunꞌ nchka jyuꞌu tiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Bra wa ndyaa neꞌ kanꞌ, mdyisnan Jesús ykwiꞌ yu chaꞌ ꞌin Xuwa kanꞌ loꞌo nten kaꞌan nu ndiꞌin loꞌo yu nde kwa: ―Bra nu yaa wan niꞌ kixinꞌ seꞌen mdiꞌin Xuwa, ¿ni sa ñaꞌan lka yu, mskeꞌ tiꞌ wan, xa wa naꞌan wan ꞌin yu nde kwa a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. ¿Ta mskeꞌ tiꞌ wan chaꞌ ngwa yu ñaꞌan tiꞌ ska yka kii nu mxkii tuun kwiꞌin ꞌin a? ¿Ta ngwañaꞌan mskeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Ni chaꞌ lka yaa naꞌan wan ꞌin yu nde kwa sikwa? ¿Ta mskeꞌ tiꞌ wan chaꞌ ngwa yu ñaꞌan tiꞌ ska yu kiꞌyu nu siyeꞌ ꞌa a? ¿Ta kanꞌ chaꞌ yaa naꞌan wan ꞌin yu a? Nten nu suꞌwe ñaꞌan steꞌ, kanꞌ ndiꞌin seꞌen ndiꞌin neꞌ kuliyaꞌ nu lka ree. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ja chan nxkeꞌ tiꞌ wan chaꞌ lka Xuwa ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. Chañi chaꞌ ngwañaꞌan lka yu, loꞌo ti tlyu la tñan mjwi ꞌin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nde ndiya chaꞌ nu ngwaꞌan ayman kula sꞌni chaꞌ ꞌin tñan nu kuꞌni Xuwa: Kuloǔn tñan ꞌin ska msu ꞌñaǎn chaꞌ tsaa yu nde loo la ꞌiin, chaꞌ slaa yu tuwiin seꞌen tsaa, ndukwin Ndiose ꞌin Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Chañi chaꞌ nchkwiǐnꞌ loꞌo wan chaꞌ ꞌin Xuwa nu ndukwatya ꞌin nten: Ja ya kala ska nten chalyuu nu kuꞌni tñan nu tnun la, sa ñaꞌan lka tñan nu mjwi ꞌin Xuwa kanꞌ. Naꞌ wa ndijyaǎn chaꞌ kaǎn ndloo la niꞌ kasiya ꞌin nten; loꞌo ni, nchga nten nu sten chaꞌ ꞌñaǎn, tlyu la chaꞌ nsuꞌwi ꞌin neꞌ kanꞌ ke Xuwa, ni siya tiꞌi neꞌ, ni siya kuneꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Ti bra nu yan Xuwa kanꞌ ti kulo, loꞌo bra ni, kaꞌan ꞌa chaꞌ nchkwiꞌ nten, chaꞌ nsuꞌwi ꞌa nten nu nchka tiꞌ chaꞌ ka Ndiose ndloo ꞌin neꞌ. Kwiꞌ ngwañaꞌan, nsuꞌwi ꞌa nten nu lye ꞌa ngiꞌni jwersa chaꞌ kala neꞌ seꞌen ndiꞌin Ndiose, ykwiꞌ ti neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nchga chaꞌ nu ngwaꞌan ayman Moisés lo kityi, sa ñaꞌan lka tñan nu ngulo Ndiose ꞌin nten, kwiꞌ nchga chaꞌ ꞌin Ndiose nu ykwiꞌ ayman kula ꞌñaan loꞌo nten sꞌni, suꞌwa ykwiꞌ ayman kanꞌ sa ñaꞌan ka chaꞌ bra nu tyisnan ka Ndiose ndloo niꞌ kasiya ꞌin nten. Loꞌo ni, wa mdiyan Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ti kwiꞌ yu kanꞌ lka ñaꞌan tiꞌ Elías nu ngwa sꞌni, nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. Wa sꞌni ndukwa chaꞌ tyaan Elías kanꞌ xiyaꞌ, si xlyaa wan xñi wan chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ re loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Ja suꞌwe siyaꞌ ti sa ñaꞌan ngiꞌni nten chalyuu bra nu ni. Ngiꞌni neꞌ sa ñaꞌan ngiꞌni nu xuwe nu ndaꞌan ndiꞌin jya ti jluꞌwe kichen, nu ndaja tiꞌ ꞌin taꞌa ndiꞌin jya neꞌ, chunꞌ ja nchka ꞌa tiꞌ neꞌ tyiꞌin jya neꞌ loꞌo taꞌa neꞌ. Kanꞌ chaꞌ nxiꞌya neꞌ ꞌin taꞌa neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“¿Ni chaꞌ ja xlyaa wan kula kiyaꞌ wan? Nan ngala ba jiin loꞌo kuwi kii chaꞌ ꞌwan” ndukwin nu xuwe ꞌin taꞌa ndiꞌin jya. “¿Ni chaꞌ ja xlyaa wan ka xiꞌin tiꞌ wan loꞌo ba? Nan ngala ba jiin xiꞌin, nan nganan ba ndiꞌin ba.” Ti kwiꞌ ngwañaꞌan ngiꞌni wan lo chalyuu re ni, chunꞌ xkwiꞌ ndaja tiꞌ wan; ja suꞌwe lka tiye wan siyaꞌ ti ñaꞌan wan ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bra nu yan Xuwa kanꞌ ni, ja yku yu loꞌo wan, ja yiꞌo yu xalyu loꞌo wan. Kanꞌ nchkwiꞌ wan chaꞌ ꞌin yu: “Nsuꞌwi kwiꞌin xaꞌan ꞌin yu, kanꞌ chaꞌ ngiꞌni yu ngwañaꞌan” ndukwin wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chunꞌ ndiꞌin la mdiyaǎn nu wa msuꞌwa Ndiose ꞌñaǎn chaꞌ kaǎn nten. Nchkuǔn nchga lo nan loꞌo wan, ndiꞌyoǔn nchga lo nan loꞌo wan, loꞌo nchkwiꞌ wan chaꞌ ꞌñaǎn: “¡Ñaꞌan wan sa ñaꞌan ngiꞌni yu kwa! Nchku ꞌa yu kwa, loꞌo kuꞌwi ꞌa yu” ndukwin wan ꞌin taꞌa wan. “Ja suꞌwe yu kwa chaꞌ taꞌa suꞌwe yu loꞌo neꞌ nu ndlo kaꞌan tñi chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ. Loꞌo xka la nten kuxi lka taꞌa suꞌwe nsuꞌwi yu” ndukwin wan ꞌñaǎn. Kwiꞌ nchkwiꞌ wan chaꞌ ja suꞌwe chaꞌ nu nchkwiǐnꞌ, nxkeꞌ tiꞌ wan. Suꞌwe sikwa, ka biyaꞌ tiꞌ wan nde loo la chaꞌ nu ñi ꞌa nchkwiꞌ nten chaꞌ ndaꞌaǎn chabiyaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Lye ꞌa ykwiꞌ Jesús chaꞌ ꞌin neꞌ kichen seꞌen taꞌa ti ndaꞌan yu, chaꞌ kaꞌan ꞌa chaꞌ tnun wa yꞌni yu seꞌen ndiꞌin neꞌ kichen kanꞌ, loꞌo ja mjyuꞌu tiꞌ neꞌ ꞌin chaꞌ kuxi nu ndiꞌin niꞌ kasiya ꞌin neꞌ; ja ngulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Tꞌnan ꞌa wan neꞌ kichen Corazín! ―ndukwin Jesús―. ¡Tꞌnan ꞌa wan neꞌ kichen Betsaida! ―ndukwin―. Kaꞌan ꞌa chaꞌ tnun wa naꞌan wan, loꞌo ja mjyuꞌu tiꞌ wan siyaꞌ ti ꞌin chaꞌ kuxi nu ngiꞌni wan, ja ngulaa yaꞌ wan chaꞌ kanꞌ. Kwiꞌ ngwañaꞌan ti sꞌni, xaꞌan ꞌa neꞌ kichen Tiro loꞌo neꞌ kichen Sidón, neꞌ xka laꞌa tsuꞌ ngwa neꞌ kanꞌ. Loꞌo ja mjwi ñaꞌan ka jyuꞌu tiꞌ neꞌ kanꞌ ꞌin chaꞌ kuxi nu wa yꞌni neꞌ. Ja ngulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ, chunꞌ ja ya ñaꞌan neꞌ kanꞌ chaꞌ tnun sa ñaꞌan nu naꞌan wan, ꞌwan neꞌ Israel; kanꞌ chaꞌ ja ngwa xiꞌin tiꞌ neꞌ kanꞌ, kanꞌ chaꞌ ja ykuꞌ neꞌ teꞌ ngata, ja msuꞌwa neꞌ jii ke neꞌ sa ñaꞌan nu ngiꞌni nten seꞌen nskwa ayman. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ñi katsaǎnꞌ ꞌwan, chaꞌ ka suꞌwe la chaꞌ ꞌin ayman neꞌ Tiro loꞌo ayman neꞌ Sidón, loꞌo lye la kaja nu tiꞌí ꞌwan bra nu tiya tsan tnun chaꞌ kuꞌni biyaꞌ Ndiose ꞌin nten chalyuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Loꞌo ꞌwan, neꞌ Capernaum ni, ¿ta suꞌwe la kichen tyi wan, nxkeꞌ tiꞌ wan a? ¿Ta lka kichen tyi wan ndloo la ꞌin xka la kichen, nxkeꞌ tiꞌ wan a? Nde loo la ñuꞌun siyaꞌ ti kichen tyi wan, loꞌo ykwiꞌ wan tyaa wan nde lo jwlyaa bra kanꞌ. Kaꞌan ꞌa chaꞌ tnun yꞌniǐn seꞌen ndiꞌin wan, loꞌo ja yaa ñaꞌan tiꞌ wan ꞌñaǎn siyaꞌ ti. Kwiꞌ ngwañaꞌan nu ngwa sꞌni, xaꞌan ꞌa ngwa neꞌ kichen Sodoma; loꞌo ja naꞌan ayman kanꞌ chaꞌ tnun sa ñaꞌan nu wa naꞌan wan, ꞌwan neꞌ Capernaum. Si wa naꞌan neꞌ chaꞌ kanꞌ, ja chan wa mjyuꞌu tiꞌ neꞌ ꞌin chaꞌ kuxi nu wa yꞌni neꞌ bra kanꞌ, wa ngulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ; ja chan ti ndukwa kichen tyi neꞌ kanꞌ sa bra ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ñi katsaǎnꞌ ꞌwan, chaꞌ ka suꞌwe la chaꞌ ꞌin ayman neꞌ Sodoma kanꞌ, loꞌo lye la kaja nu tiꞌí ꞌwan tsan tlyu nu kuꞌni biyaꞌ Ndiose ꞌin nten chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Chunꞌ ndiꞌin la ykwiꞌ Jesús loꞌo Ndiose Sti yu: ―Kuꞌni tnuǔn ꞌiin, Stiǐn; nuꞌwin lkaa Xꞌnan ba, loꞌo nde niꞌ kwan, loꞌo lo chalyuu ―ndukwin Jesús ꞌin Ndiose―. Ngwa xuꞌwe ꞌiin chaꞌ wa yꞌnii chaꞌ ngwa biyaꞌ tiꞌ nten nu ja jlyo suꞌwe tiꞌ nu ngwa sꞌni la. Xka ta nten nu tiya la tiꞌ, loꞌo nten nu nchka ꞌa ꞌin, loꞌo nten nu jlyo ꞌa tiꞌ nchga chaꞌ ꞌiin, nxkeꞌ tiꞌ neꞌ, loꞌo neꞌ kanꞌ ja nchka biyaꞌ la tiꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Chañi chaꞌ ngwañaꞌan nchka tiꞌ nuꞌwin, chaꞌ ka biyaꞌ tiꞌ nten nu ja jlyo tiꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ti ngwaꞌu la Jesús ꞌin neꞌ bra kanꞌ: ―Nchga chabiyaꞌ ꞌin Stiǐn Ndiose nganun ꞌñaǎn. Ja tukwin jlyo tiꞌ sa ñaꞌan lka chaꞌ nu nsuꞌwi niꞌ kasiya ꞌñaǎn, chaꞌ naꞌ lkaǎn ska ti nu lka Sñiꞌ Ndiose; ska ti Stiǐn Ndiose jlyo tiꞌ Ni sa ñaꞌan lka chaꞌ nu nsuꞌwi niꞌ kasiya ꞌñaǎn. Kwiꞌ ngwañaꞌan, ja tukwin jlyo tiꞌ sa ñaꞌan chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin Stiǐn; skaǎn tiǎn nu lkaǎn Sñiꞌ Ni jlyo tiǎnꞌ, loꞌo kwaꞌuǔn chaꞌ kanꞌ ꞌin nten nu kuloǔn suwiǐn ꞌin chaꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nchga wan nu ja talo wan chaꞌ tiꞌin ꞌa tñan nsuꞌwi ꞌwan lo chalyuu, nxkeꞌ tiꞌ wan, kan wan tyiꞌin chaꞌ ꞌwan loꞌoǔn ni. Taǎn chabiyaꞌ chaꞌ tiin ti tyiꞌin wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xñi wan tñan nu taǎn ꞌwan, kwiꞌ kuꞌni xaꞌan wan nchga chaꞌ ꞌñaǎn bra kanꞌ. Chka tꞌnan ꞌa tiǎnꞌ ꞌwan, taloǔn ꞌaǎn ꞌwan; loꞌo tiin ti tyiꞌin wan chaꞌ wa yꞌni tyiǐn nchga chaꞌ kuxi nu nsuꞌwi niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chaꞌ suꞌwe lka chaꞌ nu kuꞌni xaꞌan wan ꞌñaǎn; ja tukwi chaꞌ kanꞌ, sa ti tñan nu taǎn ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wa ndiya tsan taꞌa nu nxitñaꞌ neꞌ judío, loꞌo ndyaa Jesús seꞌen ndiya jyan trigu ꞌin neꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Ngiteꞌ tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ, kanꞌ chaꞌ mstun neꞌ chinꞌ juun trigu chaꞌ ku neꞌ mta ꞌin ran ñaꞌan yaꞌa ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Naꞌan neꞌ fariseo chaꞌ ngiꞌni neꞌ ngwañaꞌan, ykwiꞌ neꞌ fariseo kanꞌ loꞌo Jesús bra kanꞌ: ―¿Ja jlyo tiꞌ wan chaꞌ ja ndiya chabiyaꞌ kuꞌnian tñan ni, chaꞌ tsan nu nxitñaanꞌ lka a? ―ndukwin neꞌ fariseo ꞌin Jesús―. Neꞌ kwa nu ngiꞌni xaꞌan chaꞌ ꞌiin ni, ¿ni chaꞌ lka ngiꞌni neꞌ tñan kanꞌ ni sikwa? ");
INSERT INTO ctpNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mxkwen Jesús ꞌin neꞌ fariseo bra kanꞌ: ―¿Ja ya chkwiꞌ wan lo kityi ꞌin Ndiose seꞌen nu ndukwa chaꞌ sa ñaꞌan nu yꞌni ayman David sꞌni a? ―ndukwin Jesús ꞌin neꞌ―. Ngwa ska tsan ngiteꞌ ꞌa tiꞌ yu, loꞌo ngiteꞌ ꞌa tiꞌ nchga taꞌa ndaꞌan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Jlyo tiꞌ yu chaꞌ nskwa jaxlya nu lka lomstan ꞌin Ndiose lo msaa niꞌ ñaꞌan nu lka kwenta ꞌin Ndiose nde kwa. Kanꞌ chaꞌ ndyaa neꞌ niꞌ ñaꞌan kanꞌ, yku neꞌ jaxlya kanꞌ, ni siya ja ndiya chabiyaꞌ ku ya ñaꞌan ti nten ꞌin ran; ska ti nten nu nka sti joꞌo ndiya chabiyaꞌ ku neꞌ jaxlya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Loꞌo ndiya xka chaꞌ nu ngwaꞌan ayman Moisés lo kityi, chaꞌ sti joꞌo ni, ja nxitñaꞌ neꞌ niꞌ lyaa tnun xa nu ndiya tsan nu nxitñaꞌ nten; nsuꞌwi tñan nu ngiꞌni sti joꞌo kanꞌ. Ti kwiꞌ ti chaꞌ, ja ndiꞌin kiꞌya ꞌin neꞌ kanꞌ chaꞌ ꞌin Ndiose, chaꞌ ngiꞌni neꞌ tñan kanꞌ―ndukwin Jesús ꞌin neꞌ fariseo kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Chañi chaꞌ naꞌ nu ndijyaǎn re, tnun la ti chaꞌ ꞌñaǎn ke laa tnun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ja nduwe tiꞌ wan sa ñaꞌan lka chaꞌ re nu ndukwa lo kityi kula: “Nchka tiǎnꞌ chaꞌ chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan” ndukwin Ndiose, “kanꞌ tñan nu ndloo la chaꞌ kuꞌni wan. Ja nchka tiǎnꞌ chaꞌ ta wan kaꞌan ꞌa lomstan ꞌñaǎn; ni siya skunꞌ wan, ja ndiꞌin chaꞌ ta wan ꞌñaǎn.” Si chañi chaꞌ ngwa biyaꞌ tiꞌ wan sa ñaꞌan nchkwiꞌ chaꞌ kanꞌ nu ndukwa lo kityi, ja xtya ꞌa wan kiꞌya ꞌin nten chaꞌ kwiñi ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Loꞌo ndiya xka chaꞌ nu chkwiǐnꞌ loꞌo wan, chaꞌ naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, naꞌ lkaǎn ndloo la, ni siya tsan nu nxitñaꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Chunꞌ ndiꞌin la mdoꞌo Jesús, ndyaa yu xka kichen, yten yu niꞌ lyaa ꞌin neꞌ judío nde kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naꞌan yu chaꞌ ndiꞌin ska yu kiꞌyu nu tiꞌí yaꞌ, chaꞌ wa nchkunꞌ tyukwin ska laꞌa yaꞌ yu. Loꞌo mnichaꞌ neꞌ judío kanꞌ ꞌin Jesús bra kanꞌ: ―¿Ta ndiya chabiyaꞌ ꞌñaan chaꞌ kuꞌnian joꞌó ꞌin nu tiꞌí tsan taꞌa a?, xa nu ndiꞌin chaꞌ xitñaanꞌ ―ndukwin neꞌ ꞌin Jesús. Nchka ꞌa tiꞌ neꞌ kanꞌ xtya neꞌ kiꞌya ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kanꞌ mxkwen yu ꞌin neꞌ: ―¿Ta ja tlyo wan ꞌin ska slyaꞌ ꞌwan xa wa mdiyuu iꞌ ska niꞌ tiyuu a? ―ndukwin Jesús ꞌin neꞌ―. Ja chan tlyo wan ꞌin iꞌ, ni siya tsan taꞌa lka bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Loꞌo taꞌa nten wan ni, ndloo la chaꞌ ꞌin neꞌ ke ꞌin ska slyaꞌ, kanꞌ chaꞌ ndiya chabiyaꞌ ꞌñaǎn tayaǎnꞌ ꞌin nten, ni siya tsan nu kti ꞌa ꞌñaan, nu ja ndiya chabiyaꞌ chaꞌ kuꞌnian xka lo tñan. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ykwiꞌ Jesús loꞌo yu tiꞌí kanꞌ: ―Xñii yaaꞌ ―ndukwin Jesús ꞌin yu kanꞌ. Mxñi yu tiꞌí kanꞌ yaꞌ yu bra kanꞌ. Bra ti nchkaa yaꞌ yu, suꞌwa ngwa taꞌa tyukwaa laꞌa yaꞌ yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Msinꞌ ꞌa tiꞌ neꞌ fariseo kanꞌ ꞌin Jesús bra kanꞌ. Mdoꞌo neꞌ, ndyaa neꞌ, ngwa tiꞌ neꞌ kaja ñaꞌan kujwi neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Loꞌo Jesús ni, ngwa biyaꞌ tiꞌ yu nchga chaꞌ kuxi nu ndaꞌan chaꞌ tiye neꞌ fariseo, kanꞌ chaꞌ mdoꞌo yu ndyaa yu xka seꞌen. Kaꞌan ꞌa nten mdoꞌo ñaꞌan ꞌin yu, loꞌo yꞌni yu chaꞌ nchkaa nchga nu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kanꞌ ngulo yu tñan ꞌin neꞌ nu ngwa tiꞌí kanꞌ, chaꞌ ja katsaꞌ neꞌ ti lka nu yꞌni chaꞌ nchkaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ti sꞌni ytsaꞌ Ndiose ska chaꞌ ꞌin ayman Isaías chaꞌ ꞌin Krixtu. Nde ndukwa chaꞌ kanꞌ lo kityi: ");
INSERT INTO ctpNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nde ndiya msu ꞌñaǎn nu wa ngulo suwiǐn ꞌin, ndukwin Ndiose. Ndiya ꞌa tiǎnꞌ ꞌin yu, loꞌo suꞌwe ꞌa nka tiyeěn ñaꞌaǎn ꞌin yu kanꞌ. Kuꞌniǐn chaꞌ kiꞌya Tyiꞌiǐn ykwiǐnꞌ chunꞌ yu, chaꞌ chkwiꞌ yu loꞌo nchga nten, loꞌo nten nu ja lka judío. Kwaꞌu yu ꞌin neꞌ sa ñaꞌan nu ñi ꞌa ngiꞌniǐn biyaǎnꞌ ꞌin nten chalyuu, ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ja xuun taꞌa yu, loꞌo ja xiꞌya yu kwen; ja kanen tyiꞌi yu laja tuwiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Suꞌwa yaꞌ yu ꞌin nten chaꞌ sten la neꞌ chaꞌ ꞌñaǎn, ni siya lka neꞌ ñaꞌan tiꞌ ska yka kii nu wa katsa ti, chaꞌ naꞌan ꞌa tiꞌ neꞌ kanꞌ; ni siya lka neꞌ ñaꞌan tiꞌ ska kiiꞌ nu wa tyuwiꞌ ti, nxkeꞌ tiꞌ neꞌ, chaꞌ wa tyii ti chaꞌ suꞌwe nu nsuꞌwi tiye neꞌ kanꞌ. Ngwañaꞌan tyijin lyo chaꞌ nu ñi kanꞌ ꞌin chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndiꞌin ta nten ñaꞌaan chalyuu chaꞌ wa kan ti yu kanꞌ. Ngwañaꞌan ndukwa chaꞌ ꞌin Krixtu lo kityi kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Chunꞌ ndiꞌin la mdiyan neꞌ loꞌo ska yu tiꞌí seꞌen ndiꞌin Jesús; wa nsuꞌwi kwiꞌin xaꞌan ꞌin yu, kanꞌ chaꞌ ja nchka ꞌa chkwiꞌ yu, loꞌo kwityiinꞌ yu. Bra ti yꞌni Jesús joꞌó ꞌin yu tiꞌí kanꞌ, chaꞌ xiyaꞌ nchkwiꞌ yu, xiyaꞌ mda Jesús xaa kiloo yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nduwe ꞌa tiꞌ nchga nten nu naꞌan chaꞌ kanꞌ bra kanꞌ. ―¿Ta ti kwiꞌ yu taꞌa ayman David kanꞌ lka yu kiꞌyu re a? ―ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bra wa ynan neꞌ fariseo chaꞌ kanꞌ, xka chaꞌ ykwiꞌ neꞌ chaꞌ ꞌin Jesús: ―Ska ti chabiyaꞌ ꞌin Beelzebú nu nka xꞌnan nchga lo kwiꞌin kuxi, kanꞌ lka chaꞌ nu nchka ꞌin yu kiꞌyu re kulo yu kwiꞌin kuxi nu nsuꞌwi ꞌin nten ―ndukwin neꞌ fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mgii tiꞌ Jesús sa ñaꞌan chaꞌ kuxi ndaꞌan chaꞌ tiye neꞌ, kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ bra kanꞌ: ―Si xuun ꞌa neꞌ nu lka ndloo la ska nasiyun, suꞌwe taꞌa nten nasiyun kanꞌ, tyii chaꞌ ꞌin neꞌ kanꞌ wa ñaꞌan ti bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. Kwiꞌ ngwañaꞌan, si lye ꞌa xuun taꞌa neꞌ ska kichen, tyii chaꞌ ꞌin neꞌ kanꞌ wa ñaꞌan ti; ni siya xuun taꞌa neꞌ nu ndiꞌin ska naꞌan ti, ti kwiꞌ ti chaꞌ ka, tyii chaꞌ ꞌin neꞌ kanꞌ loꞌo taꞌa neꞌ, tyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kwiꞌ ngwañaꞌan, ja talo Satanás si xuun loꞌo msu ꞌin; tyii chaꞌ ꞌin kuneꞌ xaꞌan kanꞌ ndla ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","¿Ta chañi nchkwiꞌ wan sikwa, xa nu nchkwiꞌ wan chaꞌ chabiyaꞌ ꞌin Beelzebú ndloǔn ꞌin kwiꞌin kuxi a? Ja ñi nchkwiꞌ wan siyaꞌ ti, chaꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌwan, ndlo neꞌ ꞌin kwiꞌin kuxi chabiyaꞌ ꞌin Ndiose, ndukwin neꞌ. Chunꞌ nu ngiꞌni neꞌ kanꞌ ngwañaꞌan ka biyaꞌ tiꞌ wan sikwa, si chañi chaꞌ nchkwiꞌ wan, si chaꞌ kwiñi ti nchkwiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Chabiyaꞌ ꞌin Tyiꞌi Ndiose ndloǔn ꞌin kwiꞌin kuxi, kanꞌ chaꞌ ka ka biyaꞌ tiꞌ wan chaꞌ wa mdyisnan chaꞌ lka Ndiose ndloo niꞌ kasiya ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ska yu tlá ni, ja kaja ñaꞌan sten xka nten naꞌan tyi yu chaꞌ kuꞌni kunan yuꞌwa ꞌin yu; siyaꞌ ti si skanꞌ neꞌ ꞌin yu tlá nu lka xꞌnan naꞌan kanꞌ kulo ndukwa, kanꞌ ka kuꞌni neꞌ kunan nan nu nsuꞌwi ꞌin yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Nten nu ja xlyaa xñi chaꞌ ꞌñaǎn, nan nsuun neꞌ kanꞌ loꞌoǔn, ngwañaꞌan lka chaꞌ kanꞌ. Kwiꞌ ngwañaꞌan nten nu ja ndayaꞌ ꞌñaǎn, ja nda neꞌ chabiyaꞌ ꞌin taꞌa nten neꞌ chaꞌ sten neꞌ tuwiin ꞌñaǎn sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Kanꞌ chaꞌ katsaǎnꞌ ꞌwan ni, chaꞌ ka kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nten nchga kiꞌya nu ndukwi neꞌ, ni siya kuxi ꞌa nchkwiꞌ neꞌ ꞌin Ndiose; siyaꞌ ti bra nu nchkwiꞌ neꞌ chaꞌ kuxi ꞌin tñan nu ngiꞌni Tyiꞌi Ndiose, kanꞌ ja kuꞌni ꞌa Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nten nu nchkwiꞌ chaꞌ kuxi ꞌñaǎn nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten; siyaꞌ ti bra nu chkwiꞌ neꞌ chaꞌ kuxi ꞌin tñan nu ngiꞌni Tyiꞌi Ndiose, kanꞌ ja kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ nchga tsan nu tyiꞌin neꞌ lo chalyuu, nchga bra nde loo la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Ska yka suꞌwe ni, ta ran nan kuan bra kanꞌ; yka nu ja suꞌwe ni, ja ta ran nan kuan bra kanꞌ. Jlyo tianꞌ si suꞌwe yka bra nu ñaꞌaan nan nu ndoꞌo lo ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nu ꞌwan, ¡ñaꞌan tiꞌ kunan tlá, ngwañaꞌan lka wan! Ja nchka chkwiꞌ wan chaꞌ suꞌwe chaꞌ nsuꞌwi ꞌa chaꞌ kuxi tiye wan; sa ñaꞌan chaꞌ nu nsuꞌwi tiye skaan, ngwañaꞌan ndyoꞌo chaꞌ nu nchkwianꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nchga nten nu suꞌwe tiye ni, suꞌwe ꞌa nchkwiꞌ neꞌ kanꞌ; loꞌo nchga nten nu kuxi ka tiye, kuxi ti nchkwiꞌ neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Katsaǎnꞌ ska chaꞌ ꞌwan ni: Bra nu tiya tsan nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten, bra kanꞌ ndiꞌin chaꞌ katsaꞌ ji neꞌ ti ykwiꞌ ti neꞌ nchga chaꞌ kuxi nu wa ykwiꞌ neꞌ lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ndiꞌya Ndiose kwenta ꞌin nchga chaꞌ nu wa ykwiꞌ wan lo chalyuu; katsaꞌ Ni ꞌwan si ndiꞌin kiꞌya ꞌwan loꞌo Ni, kwiꞌ katsaꞌ Ni ꞌwan si ja ndiꞌin kiꞌya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Chunꞌ ndiꞌin la ndiꞌin chinꞌ mstru nu nduꞌu chaꞌ joꞌo, ndiꞌin neꞌ fariseo, nchkwiꞌ neꞌ loꞌo Jesús: ―Mstru ―ndukwin neꞌ kanꞌ ꞌin Jesús bra kanꞌ―, kuꞌnii ska chaꞌ tnun chaꞌ ñaꞌan kwiꞌya ba ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Xaꞌan ꞌa taꞌa wan, chaꞌ xkwiꞌ njñan wan ꞌñaǎn chaꞌ kuꞌniǐn ska chaꞌ tnun chaꞌ ñaꞌan kwiꞌya wan ꞌin ran; lka wan nten nu ja ndyaa ñaꞌan tiꞌ ꞌin Ndiose siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ―. Ja ska chaꞌ tnun kuꞌniǐn ngwañaꞌan. Ndiꞌin chaꞌ tyaa yuꞌwi tiꞌ wan nan lka ngwa ꞌin ayman Jona nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo neꞌ Nínive nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa ñaꞌan nganun Jona kanꞌ niꞌ kula tnun kanꞌ snan tsan loꞌo snan tla, ngwañaꞌan naꞌ, nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, kanuǔn niꞌ yuu snan tsan loꞌo snan tla xa wa ngujwiǐn. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bra nu tiya tsan nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten, xtya ayman neꞌ Nínive kiꞌya ꞌwan nu ndiꞌin wan lo chalyuu ni bra kanꞌ. Katsaꞌ ayman kanꞌ nchga chaꞌ nu wa ynan neꞌ, xa nu ykwiꞌ ayman Jona loꞌo neꞌ nu ngwa sꞌni, loꞌo bra kanꞌ mjyuꞌu tiꞌ neꞌ ꞌin nchga chaꞌ kuxi nu yꞌni neꞌ; ngulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ chunꞌ wa yten neꞌ chaꞌ ꞌin Ndiose. Loꞌo ja suꞌwa chaꞌ nu ngwaꞌu ayman Jona kanꞌ ꞌin neꞌ sꞌni loꞌo chaꞌ nu nduꞌuǔn ꞌwan ni; tlyu la chaꞌ ꞌin Ndiose lka nu nduꞌuǔn ꞌwan ni, loꞌo ja nnan ꞌa wan chaꞌ re siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Loꞌo ayman reina nu ngwa ndloo la ꞌin neꞌ nde Sur, tyituun nu kunaꞌan kanꞌ tloo Ndiose tsan nu kuꞌni biyaꞌ Ni ꞌin nten chalyuu. Xtya nu kunaꞌan kanꞌ kiꞌya ꞌwan nu ndiꞌin wan lo chalyuu ni bra kanꞌ. Chkwiꞌ neꞌ kula kanꞌ sa ñaꞌan ngwa bra nu yaa seꞌen mdiꞌin ayman ree Salomón. Tijyuꞌ ꞌa kichen tyi reina kanꞌ; wa ynan neꞌ kula chaꞌ tiya ꞌa Salomón kanꞌ, chaꞌ suꞌwe ꞌa chaꞌ tiya nu nchkwiꞌ yu. Kanꞌ chaꞌ yaa neꞌ kula kanꞌ seꞌen mdiꞌin ree chaꞌ kunan ni sa ñaꞌan chaꞌ tiya nu nsuꞌwi ꞌin yu kula kanꞌ. Loꞌo chinꞌ la chaꞌ ngwaꞌu ayman Salomón ke chaꞌ nu nduꞌuǔn ꞌwan ni; tnun la chaꞌ ꞌin Ndiose lka nu nduꞌuǔn ꞌwan ni, loꞌo ja nnan wan siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Bra nu kulaa yaꞌ kwiꞌin kuxi ꞌin ska nten, tyaꞌan yuꞌwi kwiꞌin kanꞌ niꞌ kixinꞌ tijyuꞌ bra kanꞌ, seꞌen ja ndiꞌin nten; tsaa kwiꞌin kuxi kanꞌ tsaa naan seꞌen xitñaꞌ chinꞌ. Bra nu ja kaja seꞌen xitñaꞌ kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","bra kanꞌ chkwiꞌ kwiꞌin kuxi kanꞌ: “Tyaꞌaǎn xiyaꞌ seꞌen mdiꞌiǐn ti kulo.” Ngwañaꞌan xkeꞌ tiꞌ kwiꞌin kuxi kanꞌ. Bra nu kala kwiꞌin kuxi kanꞌ seꞌen ndiꞌin neꞌ kanꞌ, bra ti ñaꞌan kwiꞌin chaꞌ ti ndiꞌin laja ti kasiya ꞌin nten seꞌen mdiꞌin nu ngwa xkanꞌ; ja ya chkaa nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Bra ti tsaa kwiꞌin xiyaꞌ, tsaa naan ꞌin xa kati kwiꞌin nu xaꞌan la, chaꞌ suꞌwa ti xuꞌwi nchga kwiꞌin ꞌin nten kanꞌ, chaꞌ kaja seꞌen tyiꞌin kwiꞌin kanꞌ loꞌo nten, nchka tiꞌ kwiꞌin kanꞌ. Ka kuxi la chaꞌ ꞌin nten kanꞌ bra kanꞌ, chaꞌ kaꞌan la kwiꞌin nsuꞌwi ꞌin neꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan kuxi ꞌa ka chaꞌ ꞌin nten nu ndiꞌin lo chalyuu ni, chaꞌ xaꞌan ꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ti nchkwiꞌ la Jesús loꞌo nten, loꞌo mdiyan jyaꞌan loꞌo taꞌa Jesús, mduun neꞌ chunꞌ naꞌan seꞌen ndiꞌin yu chaꞌ nchka tiꞌ neꞌ chkwiꞌ neꞌ loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ytsaꞌ ska nten ꞌin Jesús bra kanꞌ: ―Jyaꞌaan loꞌo taꞌaa, nduun neꞌ chunꞌ naꞌan re ―ndukwin ꞌin Jesús―. Nchka tiꞌ neꞌ chkwiꞌ neꞌ loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mxkwen Jesús ꞌin yu kiꞌyu kanꞌ bra kanꞌ: ―¿Ti ka nu chañi lka jyaꞌaǎn a? ―ndukwin Jesús ꞌin neꞌ―. ¿Ti ka nu chañi lka taꞌaǎn a? ");
INSERT INTO ctpNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Kanꞌ nguaꞌu yaꞌ yu ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Neꞌ re ni, suꞌwa ndloo ꞌa neꞌ re ꞌñaǎn sa ñaꞌan ndloo ꞌa jyaꞌaǎn ꞌñaǎn, sa ñaꞌan ndloo ꞌa taꞌaǎn ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Taꞌaǎn lka nchga nten nu ngiꞌni sa ñaꞌan nu nchka tiꞌ Stiǐn Ndiose nu ndiꞌin niꞌ kwan; nten kanꞌ lka sa ñaꞌan lka jyaꞌaǎn, sa ñaꞌan lka taꞌaǎn, ni siya kiꞌyu neꞌ, ni siya kunaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ti kwiꞌ tsan kanꞌ mdoꞌo Jesús naꞌan kanꞌ, ndyaa yu tuꞌwa tiyuꞌ, ndukwa yu chinꞌ nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Loꞌo ndyoꞌ tiꞌin kaꞌan ꞌa Nten seꞌen ndiꞌin Jesús, kanꞌ chaꞌ yten yu niꞌ yka naꞌan xuwe, mdukwa yu chinꞌ bra kanꞌ; nganun nten kaꞌan kanꞌ tuꞌwa tyiꞌa ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kanꞌ nguaꞌu Jesús tyun chaꞌ tiya ꞌin neꞌ, chaꞌ kuꞌni xaꞌan la neꞌ chaꞌ ꞌin Ndiose. Nde ndiya chaꞌ nu ykwiꞌ yu: ―Ngwa ska tsan ndyaa ska nten kata mta trigu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Bra nu msnen yu mta kanꞌ, mdiyuu chinꞌ ran lo yuu tla tuꞌwa tuwiin; bra ti yan kiñi, mdyii mta kanꞌ yku iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Loꞌo ngalu chinꞌ mta kanꞌ seꞌen lti ti tuꞌwa yuu nskwa chunꞌ kee, ndla ꞌa mtsu mta kanꞌ. Chaꞌ nu chinꞌ ꞌa yuu nskwa chunꞌ kee kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","kanꞌ chaꞌ ja msñi suꞌwe suun ran lo kee kanꞌ, ja ngwa kaluu suꞌwe ran. Mdyii kala kanꞌ nganaan ran, chaꞌ tikeeꞌ ꞌa kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Loꞌo ngalu chinꞌ mta kanꞌ laja ti kicheꞌ; bra ti nguluu ti kicheꞌ kanꞌ xiyaꞌ, loꞌo ja mda ꞌa ran chabiyaꞌ kaluu kala trigu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Loꞌo ngalu chinꞌ mta kanꞌ lo yuu suꞌwe, seꞌen nu suꞌwe ꞌa nguluu kala; loꞌo kaꞌan ꞌa mta mdoꞌo lo juun kala kanꞌ bra kanꞌ, kwenta ska siyentu mta mdoꞌo ska lo juun, kwenta snan yla mta mdoꞌo xka lo juun, kwenta kala tyii mta mdoꞌo xka lo juun. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, si chañi chaꞌ nchka tiꞌ wan kunan wan chaꞌ suꞌwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chunꞌ ndiꞌin la mdiyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin yu. Mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿Ni chaꞌ lka ytsaaꞌ chaꞌ kanꞌ ꞌin neꞌ kwa? Sa ñaꞌan lka si nchkwiꞌ neꞌ ska kwentu, ngwañaꞌan lka chaꞌ kanꞌ ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Wa mda Ndiose chabiyaꞌ ꞌwan chaꞌ ka biyaꞌ tiꞌ wan ska chaꞌ nu yuꞌwi kutsiꞌ ꞌin ayman sꞌni, sa ñaꞌan ka xa nu ka Ndiose ndloo la niꞌ kasiya ꞌin nten. Nten nu ja msñi chaꞌ ꞌin Ndiose ni, ja kiꞌya neꞌ kwenta bra nu kunan neꞌ ska chaꞌ nu nchkwiǐnꞌ; tukwi ꞌa chaꞌ kanꞌ, xkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Nten nu ndyaa ñaꞌan tiꞌ chaꞌ nu ynan neꞌ ꞌin Ndiose, ti kwaꞌu la Ndiose chaꞌ ꞌin neꞌ kanꞌ, chaꞌ ngwañaꞌan suꞌwe la sten neꞌ chaꞌ ꞌin Ndiose; nten nu ja ndyaa ñaꞌan tiꞌ chaꞌ kanꞌ, neꞌ nu ja xlyaa kunan chaꞌ kanꞌ, kuꞌni Ndiose chaꞌ ja ka ꞌin neꞌ sten neꞌ chaꞌ ꞌin Ndiose siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kanꞌ chaꞌ nchkwiǐnꞌ chaꞌ kanꞌ loꞌo nten. Ni siya ñaꞌan neꞌ, ja kiꞌya neꞌ kwenta sa ñaꞌan lka chaꞌ nu ñi kanꞌ; ni siya kunan neꞌ, ja ka biyaꞌ tiꞌ neꞌ sa ñaꞌan lka chaꞌ kanꞌ, chunꞌ ja nnan suꞌwe neꞌ chaꞌ nchkwiǐnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Bra nu ñaꞌaan ꞌin neꞌ kanꞌ, ka biyaꞌ tianꞌ chaꞌ chañi ꞌa chaꞌ ꞌin Ndiose nu ngwaꞌan ayman Isaías nu ngwa sꞌni. Nde lka sa ñaꞌan nchkwiꞌ chaꞌ kanꞌ: Ja chan kunan wan chaꞌ kanꞌ, loꞌo ja ka biyaꞌ tiꞌ wan sa ñaꞌan chaꞌ nu wa ynan wan, ndukwin Ndiose. Ja chan ñaꞌan wan chaꞌ kanꞌ, loꞌo ja kiꞌya wan kwenta siyaꞌ ti nan lka nu wa naꞌan wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ja xlyaa neꞌ tukwa neꞌ chaꞌ nchkwiǐnꞌ, chunꞌ xaꞌan ꞌa tiye neꞌ taꞌa wan. Ja xlyaa neꞌ kunan neꞌ chaꞌ nchkwiǐnꞌ, chunꞌ ja nnan suꞌwe neꞌ taꞌa wan. Ja nchka tiꞌ neꞌ kiꞌya neꞌ kwenta, chunꞌ ja nchka ꞌin neꞌ ñaꞌan suꞌwe neꞌ. Ja xlyaa neꞌ kulaa yaꞌ neꞌ chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, kanꞌ chaꞌ ja nda neꞌ chabiyaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin neꞌ ꞌin chaꞌ kuxi kanꞌ, ndukwin Ndiose. Ngwañaꞌan ndukwa chaꞌ lo kityi ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Suꞌwe nka tiye wan chaꞌ ti ndukwa laa kiloo wan, ti ndukwa laa tu nskan wan, chaꞌ ka kiꞌya suꞌwe wan kwenta ꞌin ska chaꞌ nu nchkwiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ kaꞌan ꞌa nten nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, loꞌo kaꞌan ꞌa nten nu suꞌwe ngwa tiye neꞌ ñaꞌan neꞌ ꞌin Ndiose sꞌni, wa mta ꞌa neꞌ kanꞌ ꞌin chaꞌ nu ñaꞌan wan ni, chaꞌ ñaꞌan neꞌ chaꞌ kanꞌ; wa mta ꞌa neꞌ ꞌin chaꞌ nu nganan wan ni, chaꞌ kunan neꞌ chaꞌ kanꞌ. Loꞌo ja ya ñaꞌan neꞌ chaꞌ kanꞌ, ja ya kunan neꞌ chaꞌ kanꞌ siyaꞌ ti, bra nu ngujwi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Nde chkwiǐnꞌ sa ñaꞌan lka chaꞌ tiya nu ꞌin nten nu yta mta trigu kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Bra nu kunan nten sa ñaꞌan ka chaꞌ nu lka Ndiose ndloo niꞌ kasiya ꞌin nten, loꞌo ja nchka biyaꞌ tiꞌ neꞌ kanꞌ sa ñaꞌan lka chaꞌ kanꞌ, bra ti kuꞌni kuneꞌ xaꞌan tñan chaꞌ katin chaꞌ suꞌwe kanꞌ, chaꞌ ja xñi ꞌa neꞌ kanꞌ chaꞌ suꞌwe kanꞌ. Ñaꞌan tiꞌ mta trigu nu mdiyuu tuꞌwa tuwiin, ngwañaꞌan lka nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Loꞌo mta nu ngalu lo yuu ti ti tuꞌwa nu nskwa chunꞌ kee ni, ñaꞌan tiꞌ mta kanꞌ, ngwañaꞌan lka nten nu suꞌwe ꞌa nka tiye neꞌ bra nu ynan neꞌ chaꞌ suꞌwe ꞌin Ndiose ti kulo. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Chunꞌ ndiꞌin la, bra nu mdyisnan xka ta nten nchka tiꞌí tiꞌ ꞌin neꞌ kanꞌ, ni siya xtyi lyoꞌo nten ꞌin neꞌ kanꞌ siꞌya chaꞌ suꞌwe nu wa ynan neꞌ kanꞌ, ja talo ꞌa neꞌ bra kanꞌ. Ñaꞌan tiꞌ mta nu ja msñi suꞌwe suun, mta nu mtsu lo yuu ti ti tuꞌwa nu nskwa chunꞌ kee kanꞌ, ja mdaloo kala kanꞌ, bra ti nganaan ran, ngwañaꞌan lka neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Mta nu ngalu lo yuu seꞌen nsuꞌwi ti kicheꞌ ni, ñaꞌan tiꞌ mta kanꞌ, ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe kanꞌ, loꞌo ndaꞌan ꞌa chaꞌ tiye neꞌ kanꞌ sa ñaꞌan ka ꞌin neꞌ lo chalyuu, chaꞌ nchka ꞌa tiꞌ neꞌ ka kuliyaꞌ neꞌ. Kanꞌ chaꞌ ja nchka ꞌin Ndiose kuꞌni Ni ska tñan suꞌwe niꞌ kasiya ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Loꞌo mta nu ngalu lo yuu suꞌwe ni, ñaꞌan tiꞌ mta kanꞌ, ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe kanꞌ, loꞌo nchka biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ; xkwiꞌ ngiꞌni neꞌ sa ñaꞌan nchkwiꞌ chaꞌ kanꞌ. Chunꞌ ndiꞌin la suꞌwe ꞌa ka chaꞌ nu xuꞌwi niꞌ kasiya ꞌin neꞌ kanꞌ, chaꞌ ñaꞌan tiꞌ yuu suꞌwe kanꞌ, ngwañaꞌan lka kasiya ꞌin neꞌ kanꞌ. Nsuꞌwi juun trigu nu ndoꞌo ska siyentu mta lo ran, loꞌo nsuꞌwi juun nu ndoꞌo snan yla mta lo ran, loꞌo nsuꞌwi juun nu ndoꞌo kalatyii mta lo ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chunꞌ ndiꞌin la ngwaꞌu Jesús xka chaꞌ tiya ꞌin neꞌ: ―Chkwiǐnꞌ xka chaꞌ loꞌo wan, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka xa nu lka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús ꞌin neꞌ―. Sa ñaꞌan lka ska nten nu yta xkwiꞌ mta suꞌwe lo jyan trigu ꞌin yu, ngwañaꞌan lka Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Xa wa tla, yijaꞌ xꞌnan jyan kanꞌ. Bra nu lajaꞌ ti yu, bra kanꞌ yan nu nka kontra ꞌin yu, msnen mta kixinꞌ laja jyan trigu ꞌin yu kanꞌ. Bra wa mdyii msnen mta kixinꞌ, ndyaa nu nka kontra ꞌin yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Suꞌwa ti mtsu taꞌa tyukwaa loo mta, loꞌo mta trigu, loꞌo mta kixinꞌ kanꞌ; suꞌwe ꞌa nguluu kala kanꞌ bra kanꞌ. Chunꞌ ndiꞌin la naꞌan neꞌ chaꞌ siꞌi xkwiꞌ mta suꞌwe nu wa yta yu kanꞌ nu mtsu; ñaꞌaan lo jyan kanꞌ mxtiyaaꞌ ndukwa trigu loꞌo kixinꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kanꞌ chaꞌ bra ti ndyaa msu seꞌen ndiꞌin xꞌnan jyan kanꞌ, ndyaa ytsaꞌ neꞌ ꞌin yu sa ñaꞌan nan ngwa: “Yu kula” ndukwin neꞌ ꞌin xꞌnan tñan kanꞌ, “¿ta siꞌi xkwiꞌ mta suꞌwe ytaa lo yuu kwa a? ¿Ni chaꞌ lka ndukwa ꞌa xka kixinꞌ laja kala ni?” ");
INSERT INTO ctpNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kanꞌ mxkwen xꞌnan jyan ꞌin msu kanꞌ bra kanꞌ: “Ti kwiꞌ nu nka kontra ꞌñaǎn yꞌni ñuꞌun ꞌin kala kwa ꞌñaǎn sikwa” ndukwin xꞌnan jyan ꞌin neꞌ. “¿Ta nchka tiiꞌ chaꞌ tsaa ba xkwaan ba kixinꞌ kwa a?, yu kula” ndukwin msu ꞌin xꞌnan jyan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ja suꞌwe ngwañaꞌan” ndukwin xꞌnan jyan ꞌin neꞌ. “¿Ni sa ñaꞌan ka si loꞌo kala trigu xkwaan wan bra kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Suꞌwe la kataan chinꞌ chaꞌ kaluu ran taꞌa tyukwaa ran, sa ñaꞌan bra nu katsi trigu kanꞌ. Bra kanꞌ kuloǔn tñan ꞌin neꞌ chaꞌ tsaa neꞌ siꞌyu neꞌ kixinꞌ ti kulo, chaꞌ skanꞌ neꞌ ꞌin ran kwenta ynin ti ran, chaꞌ skin ran lo kiiꞌ; kuꞌni neꞌ kwa bra kanꞌ, siꞌyu neꞌ nchga trigu chaꞌ xoꞌ tiꞌin neꞌ ꞌin ran niꞌ juꞌwa.” ");
INSERT INTO ctpNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Kwiꞌ ngwañaꞌan ngwaꞌu Jesús xka chaꞌ tiya, ñaꞌan tiꞌ ska nkwin ti: ―Xka chaꞌ chkwiǐnꞌ loꞌo wan, sa ñaꞌan ka xa nu lka Ndiose ndloo la niꞌ kasiya ꞌin nten ―ndukwin Jesús ꞌin neꞌ―. Sa ñaꞌan lka ska mta xuwe ꞌa nu yta ska nten niꞌ lyoꞌoo ꞌin yu, ngwañaꞌan ka chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Xuwe ꞌa mta kanꞌ, loꞌo tnun ꞌa yka kanꞌ xa nu nguluu ran, sa ñaꞌan bra nu kan kiñi chaꞌ kwiñan iꞌ seꞌen xkwa iꞌ laja stanꞌ yka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Kwiꞌ ngwañaꞌan ngwaꞌu Jesús xka chaꞌ tiya ꞌin neꞌ: ―Xka chaꞌ chkwiǐnꞌ loꞌo wan, sa ñaꞌan ka bra nu lka Ndiose ndloo la niꞌ kasiya ꞌin nten ―ndukwin Jesús ꞌin neꞌ―. Ñaꞌan tiꞌ ska nguluꞌ jyaꞌan skwan, nu xñi ska nu kunaꞌan chaꞌ suꞌwa ꞌin ran lo snan skaꞌ kata jaxlya; xtiyaaꞌ ꞌin ran bra kanꞌ, chaꞌ sa tlyu ti skwen nchga skwan kanꞌ, ngwañaꞌan ka tñan ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ngwañaꞌan ngwaꞌu Jesús ꞌin nten kaꞌan nu ndiꞌin nde kwa, chaꞌ xkwiꞌ loꞌo chaꞌ tiya nu ñaꞌan tiꞌ nkwin ykwiꞌ Jesús loꞌo nten bra kanꞌ; ja ska chaꞌ nduꞌu yu ꞌin nten si ja loꞌo chaꞌ tiya nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kanꞌ lka ska chaꞌ ꞌin Ndiose nu wa ykwiꞌ ska ayman loꞌo nten nu ngwa sꞌni. Nde ndiya chaꞌ kanꞌ: Loꞌo chaꞌ tiya ti chkwiǐnꞌ loꞌo nten chaꞌ kwaꞌuǔn ska chaꞌ ꞌin neꞌ, ndukwin Ndiose. Chkwiǐnꞌ ꞌin ska chaꞌ nu nsuꞌwi kutsiꞌ, ti nu mñaǎn chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Chunꞌ ndiꞌin la mxnun Jesús ꞌin nten kaꞌan kanꞌ, ndyaa yu niꞌ ñaꞌan kanꞌ. Kanꞌ ndijyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu seꞌen ndiꞌin yu, mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―Yu kula, kwaꞌuu ꞌwa sa ñaꞌan lka chaꞌ nu ngwaꞌuu ꞌwa tsan, chaꞌ ꞌin kixinꞌ nu ndukwa lo jyan ꞌin neꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","―Suꞌwe ―ndukwin Jesús ꞌin neꞌ―. Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, xa nu nduꞌuǔn ꞌin nten ni, sa ñaꞌan lka si kataǎn mta suꞌwe lo jyan ꞌñaǎn, ngwañaꞌan ngiꞌniǐn. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Loꞌo nu lka jyan ꞌñaǎn ni, kanꞌ lka tyukwi ñaꞌaan chalyuu; loꞌo kala trigu nu nguluu la seꞌen ndukwa mta suꞌwe kanꞌ, ngwañaꞌan lka nten nu nda chabiyaꞌ chaꞌ ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ. Loꞌo kixinꞌ kanꞌ ni, ngwañaꞌan lka nten nu ndiꞌin chaꞌ ꞌin loꞌo kuneꞌ xaꞌan, ");
INSERT INTO ctpNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","chaꞌ ti kwiꞌ kuneꞌ xaꞌan lka nu nxuun loꞌoǔn, loꞌo kanꞌ lka nu msnen mta kixinꞌ kanꞌ lo jyan ꞌñaǎn. Tsan nu tyisnan siꞌyu neꞌ jyan ni, kanꞌ lka tsan nu tlyu ꞌa bra nu tsaa tii chalyuu; loꞌo nten nu siꞌyu kixinꞌ lo jyan kanꞌ ni, kanꞌ lka angajle ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sa ñaꞌan lka bra nu xoꞌ tiꞌin neꞌ kixinꞌ chaꞌ skin ran, ngwañaꞌan ka ꞌin nten kuxi bra nu tyii chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tsan kanꞌ, naꞌ nu wa ndijyaǎn chaꞌ kaǎn nten, suꞌwaǎn ꞌin angajle ꞌñaǎn chaꞌ xoꞌ tiꞌin ꞌin nchga nten nu ngwaꞌu ꞌin taꞌa nten chaꞌ kuꞌni neꞌ chaꞌ kuxi; tyoꞌ tiꞌin nchga nten nu kuxi ka tiye kanꞌ, chaꞌ ja ndiꞌin chabiyaꞌ kanun neꞌ kanꞌ seꞌen lka Stiǐn Ndiose ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bra kanꞌ xkwan angajle ꞌin neꞌ kanꞌ lo kiiꞌ tnun; kunan ꞌa neꞌ kanꞌ bra kanꞌ, kasinꞌ ꞌa tiꞌ neꞌ sa ñaꞌan yaꞌ nu ku liꞌya neꞌ chunꞌ msinꞌ tiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kanun nchga nten nu luwi kasiya ꞌin seꞌen lka Stiǐn Ndiose ndloo; sa ñaꞌan luwi xaa kwichaa, ngwañaꞌan ka luwi ꞌa tloo neꞌ kanꞌ, chunꞌ ngwa luwi kasiya ꞌin neꞌ siyaꞌ ti kwenta ꞌin Ndiose bra kanꞌ. Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan, si chañi chaꞌ nchka tiꞌ wan kunan wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Xka chaꞌ chkwiǐnꞌ loꞌo wan, sa ñaꞌan ka xa nu lka Ndiose ndloo niꞌ kasiya ꞌin nten; ñaꞌan tiꞌ ska yuꞌwa nu kaꞌan ꞌa ngaꞌan, ngwañaꞌan lka chaꞌ kanꞌ. Wa nsuꞌwi kutsiꞌ yuꞌwa nu kaꞌan ngaꞌan kanꞌ niꞌ yuu ska niꞌ lyoꞌoo ꞌin neꞌ. Chunꞌ ndiꞌin la, wa ndyija ꞌin xka nten seꞌen nsuꞌwi kutsiꞌ yuꞌwa kanꞌ. Suꞌwe ꞌa ngwa tiye yu bra kanꞌ; kanꞌ chaꞌ bra ti mdukunꞌ yu yuu lo seꞌen nsuꞌwi kutsiꞌ yuꞌwa kanꞌ xiyaꞌ, mdoꞌo yu ndyaa yu lo kichen chaꞌ kujwiꞌ yu nchga nan nu nsuꞌwi ꞌin yu. Ngwañaꞌan mjwi tñi ꞌin yu, msiꞌi yu loꞌoo kanꞌ seꞌen nsuꞌwi kutsiꞌ yuꞌwa nu kaꞌan ngaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Loꞌo xka chaꞌ chkwiǐnꞌ loꞌo wan ni, sa ñaꞌan ka xa nu lka Ndiose ndloo la niꞌ kasiya ꞌin nten. Lka kanꞌ sa ñaꞌan lka si ndaꞌan naan ꞌa ska nten ꞌin kee ngaten nu suꞌwe ꞌa, kwiꞌ nu lka kee perla. Jlyo tiꞌ yu nan lka nu ndyaa naan yu, kanꞌ chaꞌ keeꞌ ndaꞌan naan yu ꞌin kee ngaten nu suꞌwe kanꞌ, chaꞌ xiꞌi yu ꞌin ran, nka tiye yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Chunꞌ ndiꞌin la ndyija ska kee ngaten nu kaꞌan ꞌa ngaꞌan ꞌin yu kanꞌ; bra ti yjwiꞌ yu nchga nan nu nsuꞌwi ꞌin yu, chaꞌ xiꞌi yu ska ti kee ngaten kanꞌ, chaꞌ ja nsuꞌwi ꞌa nan suꞌwe la xiꞌi yu, mskeꞌ tiꞌ yu. (Wa ngwaꞌu Jesús taꞌa tyukwaa chaꞌ tiya kanꞌ ꞌin neꞌ, chaꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ ska ti chaꞌ ndloo la ꞌñaan, chaꞌ tyija lyo ꞌñaan chalyuu kwi seꞌen lka Ndiose ndloo niꞌ kasiya ꞌñaan.) ");
INSERT INTO ctpNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","―Loꞌo xka chaꞌ chkwiǐnꞌ loꞌo wan ni, sa ñaꞌan ka xa nu lka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús―. Sa ñaꞌan lka ska katan tnun nu nduguun nten lo tyiꞌa tujoꞌo chaꞌ xñi kula, chaꞌ kanun nchga loo kula niꞌ katan kanꞌ, ngwañaꞌan lka chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chunꞌ ndiꞌin la jwakii neꞌ ꞌin katan msaꞌan kanꞌ, chaꞌ tyoꞌo ran tuꞌwa tyiꞌa. Nde kwa tyiꞌin neꞌ chinꞌ chaꞌ kulo suwi neꞌ nchga kula nu suꞌwe ti; suꞌwa neꞌ kula suꞌwe ti kanꞌ niꞌ xkuwi, xkwan neꞌ kula nu ja suꞌwe bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwiꞌ ngwañaꞌan ka tsan tnun bra nu tsaa tii chalyuu. Kanꞌ kan angajle chaꞌ suꞌwe taꞌa angajle ꞌin nchga nten, chaꞌ ja suꞌwa tyiꞌin neꞌ nu xaꞌan tiye loꞌo neꞌ nu luwi tiye. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Xkwan angajle ꞌin nten xaꞌan lo kiiꞌ tnun; kunan ꞌa neꞌ kanꞌ bra kanꞌ, kasinꞌ ꞌa tiꞌ neꞌ sa ñaꞌan bra nu ku liꞌya neꞌ chaꞌ msinꞌ tiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","’¿Ngwa biyaꞌ tiꞌ wan nchga chaꞌ nu tka ngwaꞌuǔn tiǎn ꞌwan ni a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ―Ngwa biyaꞌ tiꞌ ba ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kanꞌ ngwaꞌu Jesús xka chaꞌ ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Ska mstru nu nduꞌu chaꞌ joꞌo ni, xa wa msñi yu chaꞌ ꞌñaǎn, xa wa yꞌni xaꞌan yu sa ñaꞌan ka bra nu lka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús―, lka yu kanꞌ sa ñaꞌan lka ska nu kuliyaꞌ nu nsuꞌwi ꞌa chaꞌ suꞌwe nu ndiꞌin niꞌ ñaꞌan tyi yu, ngwañaꞌan lka mstru kanꞌ. Loꞌo ni, nsuꞌwi ꞌa chaꞌ suꞌwe nu ka kwaꞌu yu ꞌin nten, ni siya chaꞌ nu kula, ni siya chaꞌ nu kwi. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Bra nu mdyii ngwaꞌu Jesús nchga chaꞌ kanꞌ ꞌin neꞌ, mdoꞌo yu ndyaa yu xka seꞌen. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chunꞌ ndiꞌin la mdiyan yu kichen tyi jyaꞌan yu, yten yu niꞌ lyaa ꞌin neꞌ kwa, ngwaꞌu yu chinꞌ ꞌin nten nu ndiꞌin niꞌ lyaa kanꞌ bra kanꞌ. Yuwe ꞌa tiꞌ neꞌ ñaꞌan neꞌ ꞌin yu bra kanꞌ: ―¿La nde yaꞌ yꞌni xaꞌan yu kiꞌyu re nchga chaꞌ nu nchkwiꞌ yu? ―ndukwin neꞌ ꞌin taꞌa neꞌ―. ¿Ni sa ñaꞌan ngwa ꞌin yu chaꞌ nchka ꞌin yu ngiꞌni yu chaꞌ tnun? ");
INSERT INTO ctpNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nan sñiꞌ neꞌ kwityi kaꞌ ti lka yu re. Loꞌo Liya lka jyaꞌan yu; loꞌo Santiago, loꞌo Se, loꞌo Simón, loꞌo Juda, neꞌ kanꞌ lka taꞌa yu re. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Loꞌo nu kunaꞌan taꞌa yu ni, ti ndiꞌin neꞌ kichen re. ¿La nde yaꞌ yꞌni xaꞌan yu chaꞌ kanꞌ sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ngwañaꞌan ngwa chaꞌ chen nka tiye neꞌ ñaꞌan neꞌ ꞌin Jesús, kanꞌ chaꞌ ykwiꞌ Jesús loꞌo neꞌ xiyaꞌ bra kanꞌ: ―Nchga seꞌen ngiꞌni tnun neꞌ ꞌin ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ―ndukwin Jesús ꞌin neꞌ―. Ska ti kichen tyi yu, ja nnan neꞌ chaꞌ nu nchkwiꞌ yu siyaꞌ ti; loꞌo taꞌa yu, ja ndukwa ꞌa neꞌ chaꞌ nu nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chinꞌ ti chaꞌ tnun yꞌni Jesús kichen kanꞌ. Ja yaa ñaꞌan tiꞌ neꞌ ꞌin yu siyaꞌ ti, kanꞌ chaꞌ ja yꞌni yu kaꞌan la chaꞌ tnun nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kwiꞌ ñaꞌan bra ynan Herodes chaꞌ ꞌin Jesús, ti kwiꞌ Herodes nu ngwa ndloo la ꞌin neꞌ Galilea. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Kanꞌ chaꞌ ykwiꞌ yu kula kanꞌ loꞌo msu ꞌin yu: ―Ti kwiꞌ ayman Xuwa nu ndukwatya ꞌin neꞌ, ti kwiꞌ kanꞌ lka nu kiꞌyu kanꞌ ―ndukwin Herodes―. Wa ngujwi yu, loꞌo ndyuꞌu yu xiyaꞌ, nxkeꞌ tiǎnꞌ, kanꞌ chaꞌ nchka ꞌin yu kuꞌni yu chaꞌ tnun nu ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ntsen Herodes ni, chaꞌ wa msñi yu ꞌin Xuwa kanꞌ nu ngwa xkanꞌ, mskanꞌ yu ꞌin Xuwa msuꞌwa yu ꞌin yu niꞌ ñaꞌan chkwan. Yꞌni yu kula chaꞌ kuxi kanꞌ siꞌya Herodías kwilyoꞌo Felipe taꞌa yu kula kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","chaꞌ bra nu ti luꞌu Xuwa wa ykwiꞌ yu chaꞌ re loꞌo Herodes kanꞌ: ―Ja ndiya chabiyaꞌ tyiꞌiin loꞌo kwilyoꞌo taꞌaa ―ndukwin Xuwa ꞌin Herodes bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nu ngwa bra kanꞌ ngwa tiꞌ Herodes kujwi ꞌin Xuwa, loꞌo ytsen yu ꞌin neꞌ kichen, chaꞌ ndyaa ñaꞌan tiꞌ neꞌ chaꞌ wa ykwiꞌ Xuwa chaꞌ ꞌin Ndiose loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bra nu ngwiꞌya taꞌa nin Herodes, yꞌni yu ska taꞌa bra kanꞌ. Kaꞌan nten ndyoꞌ tiꞌin seꞌen ndiꞌin yu, kanꞌ mdiyan nu kunaꞌan sñiꞌ Herodías, yla kiyaꞌ tloo Herodes. Mdiya ꞌa tiꞌ yu kula kanꞌ ꞌin nu kunaꞌan kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kanꞌ chaꞌ mskanꞌ yu ska chaꞌ loꞌo, chaꞌ ta yu nchga nan nu jñan nu kunaꞌan kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tiꞌí ꞌa tiꞌ Herodías jyaꞌan nu kunaꞌan kuneꞌ ꞌin Xuwa, ngwa tiꞌ kujwi ꞌin Xuwa, kanꞌ chaꞌ ytsaꞌ ꞌin sñiꞌ ni ñaꞌan nan nu jñan ꞌin Herodes bra kanꞌ. ―Ke Xuwa nu ndukwatya ꞌin nten, nchka tiǎnꞌ ―ndukwin nu kunaꞌan kuneꞌ kanꞌ ꞌin Herodes bra kanꞌ―. Kan loꞌo neꞌ ꞌin ke yu ska niꞌ siꞌyuu ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ngwa xiꞌin chinꞌ tiꞌ Herodes nu lka ndloo kanꞌ bra kanꞌ; wa mskanꞌ yu chaꞌ kanꞌ tloo nchga nten nu ndaꞌan taꞌa kanꞌ, kanꞌ chaꞌ ngulo yu tñan ꞌin sndaru chaꞌ kuꞌni neꞌ sa ñaꞌan nu ndukwin nu kunaꞌan kuneꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kanꞌ chaꞌ yaa sndaru, yaa mdijin kuꞌ neꞌ ke Xuwa niꞌ ñaꞌan chkwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mstya neꞌ ke jyoꞌo niꞌ siꞌyuu, mdiyan loꞌo neꞌ siꞌyuu kanꞌ bra kanꞌ, mda neꞌ ran ꞌin nu kunaꞌan kuneꞌ kanꞌ bra kanꞌ. Mdoꞌo nu kunaꞌan kanꞌ ndyaa, ndyaa loꞌo siꞌyuu kanꞌ seꞌen ndiꞌin jyaꞌan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Chunꞌ ndiꞌin la mdiyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Xuwa, ngwiꞌya neꞌ ꞌin ayman kanꞌ, chaꞌ tsaa loꞌo neꞌ ꞌin yu chaꞌ katsiꞌ yu. Xa wa mtsiꞌ neꞌ ꞌin yu, ndyaa ytsaꞌ neꞌ ꞌin Jesús sa ñaꞌan ngwa chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Bra wa ynan Jesús sa ñaꞌan nu ngwa ꞌin ayman Xuwa, yten yu ska ti yu niꞌ yka naꞌan chaꞌ tsaa yu xka tuꞌwa tiyuꞌ; ngwa tiꞌ yu tsaa yu ska seꞌen niꞌ kixinꞌ, seꞌen ja ndiꞌin nten. Bra ti ngwa biyaꞌ tiꞌ kaꞌan nten chaꞌ ndyaa yu nde kanꞌ, kanꞌ chaꞌ bra ti mdoꞌo ñaꞌan neꞌ ꞌin yu, kiyaꞌ ti neꞌ ndijyan neꞌ tuꞌwa tiyuꞌ. Loꞌo neꞌ tyun kichen mdiyan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bra wa mdiya yka naꞌan kanꞌ seꞌen ndyaa yu tuꞌwa tiyuꞌ kanꞌ, mdoꞌo Jesús; naꞌan yu chaꞌ wa ndiꞌin kaꞌan ꞌa nten nde kwa bra kanꞌ. Nchka tꞌnan ꞌa tiꞌ yu ꞌin nchga nten kanꞌ, kanꞌ chaꞌ yꞌni yu chaꞌ nchkaa nchga neꞌ tiꞌí nu ndaꞌan loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tyukwi tsan mdiꞌin neꞌ. Bra wa msiin ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús loꞌo yu: ―Niꞌ kixinꞌ ꞌa ndiꞌian re. Ja tukwin ndiꞌin kwiꞌ seꞌen ti nde ―ndukwin neꞌ ꞌin Jesús―. Kwiꞌ ngwañaꞌan msiin ꞌa ni. Suꞌwe la kuloo tñan ꞌin nten kaꞌan kwa chaꞌ tsaa neꞌ nchga kichen nu ndiꞌin lo yuu kwa, chaꞌ xiꞌi neꞌ nan ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","―ꞌWan, ta wan nan ku neꞌ nde ti ―ndukwin Jesús―. Ja ndiꞌin chaꞌ tyaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yuwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan kanꞌ bra kanꞌ: ―Kaꞌyu ti jaxlya tejeꞌ ndiya ꞌñaan nde, yu kula ―ndukwin neꞌ ꞌin Jesús―, loꞌo ndiya tukwa ti kula. Sa kanꞌ ti nan. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ykwiꞌ Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Kan loꞌo wan ꞌin ran nde re ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Loꞌo kanꞌ ngulo Jesús tñan ꞌin nten kaꞌan, chaꞌ tyukwa neꞌ chinꞌ lo kii. Kwiꞌ msñi yu kaꞌyu jaxlya tejeꞌ kanꞌ loꞌo tukwa kula kanꞌ; mxinaꞌan yu niꞌ kwan bra kanꞌ, ndya yu xuꞌwe ꞌin Ndiose. Kanꞌ mdyisnan yu msuꞌwe yu jaxlya loꞌo kula kanꞌ, mda yu kwenta yuꞌwe ran ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kutsaa neꞌ ran ꞌin nten kaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ngwañaꞌan ngwa chaꞌ yku nchga nten kanꞌ, sa ñaꞌan yaꞌ nu ngulaꞌ tiꞌ neꞌ. Mxoꞌ tiꞌin yu kuneꞌ nchga yuꞌwe nu nganun bra kanꞌ, msaꞌan tii tyukwa xkuwi loꞌo yuꞌwe jaxlya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kaꞌyu mi nu kiꞌyu yku seꞌen ndiꞌin Jesús tsan kanꞌ, loꞌo xka kwenta nu kunaꞌan loꞌo nu xuwe ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Chunꞌ ndiꞌin la ngulo Jesús tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ sten neꞌ niꞌ yka naꞌan chaꞌ tsaa neꞌ xka laꞌa tsuꞌ tiyuꞌ kanꞌ; nde loo la tsaa neꞌ ti ykwiꞌ ti neꞌ, loꞌo kanun yu ska ti yu chaꞌ slaaꞌ yu ꞌin nten kaꞌan kanꞌ, ngwa tiye yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bra wa ndyaa nchga nten kanꞌ, ndyaa Jesús lo kiꞌya chaꞌ chkwiꞌ loꞌo Ndiose seꞌen ndiꞌin yu ska ti yu bra kanꞌ. Bra wa tsaa ti kwichaa, ti ndiꞌin Jesús ska ti lo kiꞌya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ti kwiꞌ ti bra kanꞌ tijyuꞌ ndaꞌan yka naꞌan kanꞌ lo tiyuꞌ. Keeꞌ ti ndyaꞌan yka naꞌan lo tyiꞌa siꞌya kwiꞌin, chaꞌ lye ꞌa nskwa kwiꞌin, lye ꞌa ngutsa tyiꞌa lo tiyuꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wa kiꞌya ti xaa, kanꞌ ndijyan Jesús ndaꞌan lo tyiꞌa ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Bra nu naꞌan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ ndaꞌan yu lo tyiꞌa ti, ytsen ꞌa neꞌ bra kanꞌ. ―¡Wa ndijyan ska ayman! ―ndukwin neꞌ. Msiꞌya ꞌa neꞌ chaꞌ ytsen neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bra ti ykwiꞌ Jesús loꞌo neꞌ: ―¡Kuꞌni tnun tiye wan! ―ndukwin Jesús ꞌin neꞌ―. Naꞌ lkaǎn, ¡ja kutsen ꞌa wan! ");
INSERT INTO ctpNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Mxkwen Tyu ꞌin yu bra kanꞌ: ―¿Ta chañi chaꞌ nuꞌwin lkaa a?, yu kula ―ndukwin Tyu ꞌin Jesús―. Si chañi chaꞌ nuꞌwin lkaa, kuloo tñan ꞌñaǎn sikwa, chaꞌ loꞌoǔn tyaꞌaǎn lo tyiꞌa chaꞌ kalaǎn seꞌen ndiꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","―Kaan nde re ―ndukwin Jesús ꞌin Tyu bra kanꞌ. Bra ti mdoꞌo Tyu niꞌ yka naꞌan, mdaꞌan yu lo tyiꞌa chaꞌ kala yu seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bra nu nduwe tiꞌ yu chaꞌ lye ꞌa nxkwa kwiꞌin, ytsen ꞌa yu bra kanꞌ, mdyisnan mdiyuu yu niꞌ tyiꞌa bra kanꞌ. Kwen msiꞌya yu ꞌin Jesús: ―Xꞌnaǎn ―ndukwin Tyu ꞌin yu―, ¡kuloo lyaa ꞌñaǎn niꞌ tyiꞌa re! ");
INSERT INTO ctpNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Bra ti msñi Jesús yaꞌ Tyu. ―Chinꞌ ti bra mdaloo chaꞌ ndyaa ñaꞌan tiiꞌ ꞌñaǎn ―ndukwin Jesús ꞌin Tyu ―. ¿Ni chaꞌ ja nchka ꞌiin tsaa ñaꞌan suꞌwe tiiꞌ ꞌñaǎn a? ");
INSERT INTO ctpNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Loꞌo bra kanꞌ mdiyan loꞌo Jesús ꞌin Tyu seꞌen ndukwi yka naꞌan lo tyiꞌa, yten neꞌ niꞌ ran bra kanꞌ; bra ti ngwa tiin kwiꞌin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kanꞌ chaꞌ yꞌni tnun neꞌ nu ndiꞌin niꞌ yka naꞌan kanꞌ ꞌin Jesús, mduun xtyinꞌ neꞌ tloo yu bra kanꞌ. ―Chañi chaꞌ nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mdiyan neꞌ xka laꞌa tsuꞌ tiyuꞌ kanꞌ, mdiya neꞌ nde Genesaret bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Bra nu ndyija lyo ꞌin neꞌ ngwa tyi kwa chaꞌ ndiꞌin Jesús, bra ti msuꞌwa neꞌ chaꞌ ndyaa nchga kichen kwiꞌ seꞌen ti, chaꞌ ka biyaꞌ tiꞌ neꞌ kanꞌ chaꞌ wa mdiya Jesús. Kanꞌ chaꞌ mdiyan loꞌo neꞌ ꞌin nchga neꞌ tiꞌí seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mjñan neꞌ chabiyaꞌ ꞌin yu ni siya kalaꞌ ti neꞌ tiꞌí kanꞌ kiyaꞌ steꞌ yu. Loꞌo bra ti nchkaa neꞌ tiꞌí kanꞌ bra kanꞌ, chunꞌ wa ylaꞌ neꞌ steꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Chunꞌ ndiꞌin la mdiyan ska ta neꞌ tnun nchka seꞌen ndiꞌin Jesús. Neꞌ kichen Jerusalén lka neꞌ kanꞌ, neꞌ fariseo loꞌo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa lka neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Ni chaꞌ ja suꞌwe ngiꞌni neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin? ―ndukwin neꞌ kanꞌ ꞌin Jesús―. Ja suꞌwa ngiꞌni neꞌ kwa loꞌo chaꞌ nu wa ykwiꞌ ayman kula loꞌoan nu ngwa sꞌni, chaꞌ katen suꞌwe yaanꞌ bra nu tiya yaꞌ kuan. Loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin ni, ja ngiꞌni neꞌ ngwañaꞌan ―ndukwin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mxkwen Jesús ꞌin neꞌ tnun nchka kanꞌ bra kanꞌ: ―Loꞌo ꞌwan ni ―ndukwin Jesús ꞌin neꞌ―, ¿ni chaꞌ lka chinꞌ la chaꞌ nka tiye wan ꞌin tñan nu ngulo Ndiose ꞌñaan?, loꞌo lye la nduwe tiꞌ wan ꞌin nchga loo tñan xuwe nu ngulo ayman kula ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wa ykwiꞌ Ndiose loꞌoan: “Tukwa wan tñan nu nchkwiꞌ sti jyaꞌan wan” ndukwin Ni. “Kwiꞌ ngwañaꞌan, si chkwiꞌ wan chaꞌ kuxi ꞌin sti jyaꞌan wan, ndiꞌin chaꞌ kujwi neꞌ ꞌwan bra kanꞌ” ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ꞌWan ni, xka loo chaꞌ nchkwiꞌ wan. Nduꞌu wan ꞌin nten chaꞌ suꞌwe ꞌa lka si chkwiꞌ wan chaꞌ re loꞌo sti, jyaꞌan wan: “Wa mdaǎn nchga nan nu nsuꞌwi ꞌñaǎn chaꞌ tyiꞌin ran kwenta ꞌin Ndiose, kanꞌ chaꞌ ja ka ꞌñaǎn tayaǎnꞌ ꞌwan ni.” ");
INSERT INTO ctpNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ngwañaꞌan lka chaꞌ kuxi nu nduꞌu wan ꞌin nten, chaꞌ ja kuꞌni tnun neꞌ ꞌin sti, jyaꞌan neꞌ; ngwañaꞌan nchkwiꞌ wan, loꞌo xka ñaꞌan ngulo Ndiose tñan ꞌñaan. Ja suꞌwe chaꞌ nu ykwiꞌ Ndiose loꞌoan, nxkeꞌ tiꞌ wan; suꞌwe la chaꞌ nu ykwiꞌ ayman taꞌa wan loꞌoan, nxkeꞌ tiꞌ wan chaꞌ ꞌwan ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Kwiñi ꞌa wan, chaꞌ tukwa chaꞌ nsuꞌwi tiye wan! Chañi chaꞌ nu ykwiꞌ ayman Isaías chaꞌ ꞌwan nu ngwa sꞌni. Nde lka chaꞌ nu ngwaꞌan ayman kula kanꞌ lo kityi: ");
INSERT INTO ctpNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ngiꞌni tnun neꞌ re ꞌñaǎn ska chaꞌ nchkwiꞌ ti neꞌ, ndukwin Ndiose, loꞌo ja tyukwi ti tiye neꞌ ngiꞌni tnun neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nan kwiñi ꞌa neꞌ re, chaꞌ nchkwiꞌ neꞌ chaꞌ ngiꞌni tnun neꞌ ꞌñaǎn. Nduꞌu neꞌ chaꞌ nu nchkwiꞌ nten chalyuu ti ꞌin taꞌa nten neꞌ, ni siya nchkwiꞌ neꞌ chaꞌ nduꞌu neꞌ chaꞌ ꞌñaǎn ꞌin taꞌa neꞌ. Ngwañaꞌan ndukwa chaꞌ nu ngwaꞌan ayman Isaías kanꞌ chabiyaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kanꞌ msiꞌya Jesús ꞌin nten kaꞌan nu ndiꞌin nde kwa chaꞌ kan neꞌ kwiꞌ seꞌen la chinꞌ, chaꞌ chkwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Kunan suꞌwe wan ―ndukwin Jesús ꞌin neꞌ―, chaꞌ ka biyaꞌ suꞌwe tiꞌ wan ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Siꞌi ska nan nu nchku ti nten nu ngiꞌni chaꞌ ka kuxi ka tiye neꞌ; nchga chaꞌ nu nchkwiꞌ nten ni, siꞌya chaꞌ kanꞌ ka biyaꞌ tianꞌ chaꞌ mnuꞌun tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Bra wa msiin la mdiyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús kwiꞌ seꞌen ndiꞌin yu. ―Ja mdiya tiꞌ neꞌ fariseo kanꞌ, xa ynan neꞌ chaꞌ nu ykwiiꞌ ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","―Stiǐn Ndiose nu ndiꞌin nde niꞌ kwan, xkwan Ni nchga kixinꞌ nu siꞌi nan kwiñii nu yta Ni, chaꞌ ja suꞌwe kixinꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kwiꞌ ngwañaꞌan, ja suꞌwe neꞌ fariseo kanꞌ chaꞌ ꞌin Ndiose, kanꞌ chaꞌ ndiꞌin chaꞌ tyoꞌo tsuꞌ wan ꞌin neꞌ kanꞌ, chaꞌ ñaꞌan tiꞌ nu kwityiinꞌ, ngwañaꞌan lka neꞌ fariseo kanꞌ ―ndukwin Jesús―. Si kwaꞌu ska nu kwityiinꞌ tuwiin ꞌin xka yu taꞌa kwityiinꞌ ti yu, tiyuu taꞌa tyukwaa neꞌ kanꞌ ska tuꞌwa yuu bra kanꞌ, chaꞌ tyukwaa neꞌ kanꞌ ja ngwa ñaꞌan neꞌ tuwiin seꞌen ndijyan neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ykwiꞌ Tyu loꞌo Jesús bra kanꞌ: ―Kwaꞌuu ꞌwa sa ñaꞌan lka chaꞌ tiya nu tka ykwiiꞌ ti chaꞌ ꞌin nan nchku neꞌ ―ndukwin―. Ja nchka biyaꞌ tiꞌ ba. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","―¿Loꞌo ꞌwan, ja ngwa biyaꞌ tiꞌ wan chaꞌ kanꞌ a? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ja ya kiꞌya wan kwenta a? Nchga nan nu sten tuꞌwa nten ni, tyijin nan kanꞌ niꞌ neꞌ. Bra nu tsaa neꞌ liyaꞌ, tyii ji chaꞌ ꞌin ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kwiꞌ ngwañaꞌan ska chaꞌ nu nchkwiꞌ nten ni, suꞌwa lka ran loꞌo chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin neꞌ. Nchka biyaꞌ tiꞌ nchga nten bra nu wa mnuꞌun tiye ska nten, siꞌya chaꞌ nu nchkwiꞌ yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Niꞌ kasiya ꞌin nten ni, la kanꞌ ndukwa suun nchga chaꞌ kuxi: ni siya kujwi neꞌ ꞌin taꞌa nten neꞌ, ni siya tyiꞌin chaꞌ ꞌin neꞌ loꞌo kwilyoꞌo xka nten, ni siya kuꞌni neꞌ chaꞌ kuxi loꞌo xka nten, ni siya kuꞌni neꞌ kunan nan nu ndiya ꞌin taꞌa nten neꞌ, ni siya chkwiꞌ neꞌ chaꞌ kwiñi ꞌin taꞌa nten neꞌ, ni siya chkwiꞌ neꞌ kwentu ꞌin taꞌa nten neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Bra nu ndiya chaꞌ kuxi niꞌ kasiya ꞌin neꞌ, kanꞌ lka nu ngiꞌni ñuꞌun tiye neꞌ; loꞌo bra nu kuan ska nan ni, ni siya ja ya katen suꞌwe yaanꞌ, ja ska chaꞌ kuꞌni kanꞌ ꞌin kasiya ꞌñaan, chaꞌ ja ka kuxi tiyean ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa nde lo yuu ꞌin kichen Tiro, loꞌo lo yuu ꞌin kichen Sidón; loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa neꞌ loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ngwa ska tsan mdiyan ska nu kunaꞌan ngwa tyi seꞌen ndiꞌin Jesús, msiꞌya ꞌa nu kunaꞌan kanꞌ ꞌin Jesús bra kanꞌ: ―¡Chka tꞌnan tiiꞌ ꞌñaǎn, Xꞌnaǎn! ―ndukwin nu kunaꞌan kanꞌ ꞌin Jesús―. Nuꞌwin lkaa ti kwiꞌ nu lka taꞌa ayman David, kanꞌ chaꞌ kuꞌnii ska chaꞌ suꞌwe loꞌoǔn. Tiꞌí ꞌa sñiěnꞌ, nxlyuu ꞌa kwiꞌin ꞌin sñiěnꞌ lyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ja mxkwen ꞌa Jesús ꞌin nu kunaꞌan kanꞌ, kanꞌ chaꞌ ndyaa ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús loꞌo yu: ―Kuloo tñan ꞌin nu kunaꞌan re chaꞌ tyaa xka seꞌen ―ndukwin neꞌ ꞌin Jesús―, chaꞌ ndaꞌan nganan ñaꞌan ꞌa ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","―Wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn lo chalyuu chaꞌ ska ti loꞌo neꞌ Israel chkwiǐnꞌ ―ndukwin Jesús bra kanꞌ―, chaꞌ sa ñaꞌan ngiꞌni slyaꞌ nu wa mnaꞌ, ngwañaꞌan ngiꞌni nten kanꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Loꞌo kwiꞌ seꞌen la mdiyan nu kunaꞌan kanꞌ bra kanꞌ, mduun xtyinꞌ tloo Jesús. ―¡Xꞌnaǎn! ―ndukwin ꞌin Jesús―, ¡tayaaꞌ ꞌwa! ");
INSERT INTO ctpNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kanꞌ mxkwen Jesús ꞌin nu kunaꞌan kanꞌ bra kanꞌ: ―Ja suꞌwe si xñi neꞌ tyaja nu nchku sñiꞌ neꞌ chaꞌ ta neꞌ ku xneꞌ ti ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","―Chañi chaꞌ nu nchkwiiꞌ, Xꞌnaǎn ―ndukwin nu kunaꞌan kanꞌ―, loꞌo ndiya chabiyaꞌ ꞌin xneꞌ chaꞌ ku iꞌ kata tyija ti nu ngalu tuꞌwa msaa laja nu nchku xꞌnan iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","―Chañi chaꞌ ndyaa ñaꞌan tiiꞌ ꞌñaǎn ―ndukwin Jesús ꞌin―. Ka chaꞌ nu nchka tiiꞌ sikwa ―ndukwin. Bra ti nchkaa sñiꞌ nu kunaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa yu tuꞌwa tiyuꞌ Galilea kanꞌ. Mdaꞌan yu chinꞌ tuꞌwa tiyuꞌ kanꞌ, mskwen yu siꞌ kiꞌya chaꞌ tyukwa yu chinꞌ nde kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kaꞌan ꞌa nten mdiyan seꞌen ndiꞌin yu bra kanꞌ; mdaꞌan loꞌo neꞌ ꞌin kaꞌan ꞌa neꞌ tiꞌí, loꞌo neꞌ nu tiꞌí kiyaꞌ, loꞌo neꞌ kwityiinꞌ, loꞌo neꞌ kuꞌun, loꞌo neꞌ nu chkuꞌ yaꞌ, nu chkuꞌ kiyaꞌ, nchga lo neꞌ tiꞌí. Mstya neꞌ ꞌin neꞌ tiꞌí kanꞌ lyuu tloo Jesús, loꞌo yꞌni Jesús chaꞌ nchkaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yuwe ꞌa tiꞌ nten kaꞌan kanꞌ xa nu naꞌan neꞌ chaꞌ xiyaꞌ nchkwiꞌ nu ngwa kuꞌun, xiyaꞌ ngwa tyukwi yaꞌ nu chkuꞌ yaꞌ, xiyaꞌ ndaꞌan nu ngwa tiꞌí kiyaꞌ, xiyaꞌ chkanꞌ xaa nu ngwa kwityiinꞌ. Lye ꞌa yꞌni tnun neꞌ ꞌin Ndiose nu nka Xꞌnan neꞌ Israel, chunꞌ nchkaa nchga neꞌ tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Loꞌo msiꞌya Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kan neꞌ seꞌen ndiꞌin yu. Ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Tꞌnan ꞌa tiǎnꞌ ꞌin nten kaꞌan kwa ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Wa snan tsan mdaꞌan neꞌ loꞌoǔn ni, loꞌo ja ndiya ꞌa nan ku neꞌ. Ja suꞌwe kuloǔn tñan ꞌin neꞌ kwa chaꞌ tyaa neꞌ ñaꞌan ngiteꞌ ti tiꞌ neꞌ, chaꞌ ja talo neꞌ tuwiin ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kanꞌ ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu: ―¿La nde yaꞌ kaja nan ku neꞌ ꞌñaan a? Niꞌ kixinꞌ ꞌa ndiꞌian re, seꞌen ja ndiꞌin nten ―ndukwin neꞌ ꞌin Jesús―. Kwiꞌ kaꞌan ꞌa nten ndaꞌan loꞌoan re. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","―¿Ni sa nkwa ra jaxlya ndiya ꞌwan? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ. ―Kati ti jaxlya tejeꞌ loꞌo ꞌwa ―ndukwin neꞌ ꞌin yu―, loꞌo ndiya chinꞌ kula xuwe ti ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Loꞌo ngulo Jesús tñan ꞌin nten kaꞌan chaꞌ tyukwa neꞌ lyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kanꞌ msñi Jesús kati jaxlya kanꞌ loꞌo kula kanꞌ, ndya yu xuꞌwe ꞌin Ndiose chaꞌ ꞌin nan ku neꞌ kanꞌ. Msuꞌwe yu jaxlya loꞌo kula kanꞌ, mda yu kwenta yuꞌwe ran ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kutsaa neꞌ ran ꞌin nten kaꞌan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Loꞌo yku nchga nten jaxlya kanꞌ sa ñaꞌan yaꞌ nu ngulaꞌ tiꞌ neꞌ. Bra nu mxoꞌ tiꞌin yu kuneꞌ nchga yuꞌwe nu nganun seꞌen yku neꞌ kanꞌ, wa msaꞌan kati xkuwi loꞌo yuꞌwe kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jakwa mi yu kiꞌyu yku jaxlya tsan kanꞌ, loꞌo xka kwenta nu kunaꞌan loꞌo nu xuwe ti; nchga nten kanꞌ yku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Bra wa mdyii yku neꞌ, mslaaꞌ Jesús ꞌin nten kaꞌan kanꞌ, chaꞌ tyaa neꞌ naꞌan tyi neꞌ. Kanꞌ yten Jesús niꞌ yka naꞌan xuwe ti, mdoꞌo yu ndyaa yu nde lo yuu Magdala loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Loꞌo mdiyan ska ta neꞌ fariseo loꞌo neꞌ saduceo seꞌen ndiꞌin Jesús, chaꞌ chkwiꞌ biyaꞌ neꞌ loꞌo yu, si ka kuxi la chaꞌ ꞌin yu, nka tiye neꞌ. Nchkwiꞌ neꞌ loꞌo Jesús chaꞌ kwaꞌu ska chaꞌ tnun ꞌin neꞌ, ska chaꞌ tnun nu tyoꞌo tukwa niꞌ kwan chabiyaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Nu ꞌwan ni, ndiya tsan nchkwiꞌ wan chaꞌ re bra wa tsaa ti kwichaa: “Luwi kwan ka la tyaa, chaꞌ lye ꞌa ngaꞌa niꞌ kwan ni” ndukwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kwiꞌ ndiya xka tsan nchkwiꞌ wan nde tlya, xa nu ñaꞌan wan niꞌ kwan: “Kiꞌya tyoo ni, chaꞌ ndla ti xaa” ndukwin wan. ¡Kwiñi ꞌa wan! Nchka biyaꞌ tiꞌ wan ska nan nu ñaꞌan wan niꞌ kwan, wa nsuꞌwi lyo wan chaꞌ kanꞌ, loꞌo ja ndii ꞌa tiꞌ wan siyaꞌ ti nan ka nu ka ꞌwan lo chalyuu re ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nan xaꞌan ꞌa tiye wan loꞌo taꞌa wan, chaꞌ xkwiꞌ nchka tiꞌ wan chaꞌ kuꞌniǐn ska chaꞌ tnun chaꞌ ñaꞌan kwiꞌya wan ꞌin ran; lka wan nten nu ja ndyaa ñaꞌan tiꞌ ꞌin Ndiose siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ―. Loꞌo ja kuꞌniǐn chaꞌ tnun ngwañaꞌan. Ndiꞌin chaꞌ tyaa yuꞌwi tiꞌ wan nan lka nu ngwa ꞌin ayman Jona nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. Ja ykwiꞌ ꞌa Jesús loꞌo neꞌ kanꞌ, mdoꞌo yu ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ti kwiꞌ tsan kanꞌ, wa mdijin neꞌ lo tiyuꞌ loꞌo yka naꞌan. Mdoꞌo neꞌ xka laꞌa tsuꞌ, loꞌo ndyuꞌwi tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús chaꞌ wa mjlyaa tiꞌ neꞌ kwiꞌya neꞌ jaxlya tejeꞌ chaꞌ ku neꞌ tuwiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Kanꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Chaꞌ tiya ti tiꞌ wan tyiꞌin wan ―ndukwin Jesús ꞌin neꞌ―. Kiꞌya wan kwenta ni sa ñaꞌan ngiꞌni skwan tiyeꞌ nu nda neꞌ fariseo loꞌo neꞌ saduceo ꞌwan ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo taꞌa neꞌ bra kanꞌ: ―Chaꞌ ja ngwiꞌyaan jaxlya tejeꞌ ndaꞌaan, kanꞌ chaꞌ nchkwiꞌ yu kula kwa loꞌoan, chaꞌ ꞌin skwan tiyeꞌ kanꞌ ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jlyo tiꞌ Jesús chaꞌ ja ngwa biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ. ―¿Ni chaꞌ nduwe tiꞌ wan chaꞌ ja loꞌo jaxlya tejeꞌ ꞌwan ndijyan wan? ―ndukwin yu ꞌin neꞌ―. Chinꞌ ti chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ta chañi chaꞌ ja ya ka biyaꞌ tiꞌ wan a? ¿Ja nsuꞌwi tiꞌ wan chaꞌ ngwa kaꞌyu ti jaxlya tejeꞌ nu yku kaꞌyu mi nten nu ngwa xkanꞌ a? Tyun xkuwi msaꞌan loꞌo yuꞌwe jaxlya nu nganun xa wa mdyii yku neꞌ tsan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ti kwiꞌ ti chaꞌ, kati jaxlya tejeꞌ yku jakwa mi nten kanꞌ, kwiꞌ tyun xkuwi msaꞌan loꞌo yuꞌwe jaxlya nu nganun xa wa yku neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Ni chaꞌ lka ja ndiꞌya wan kwenta? Ja nchkwiǐnꞌ chaꞌ ꞌin jaxlya nu nchku nten bra nu nchkwiǐnꞌ chaꞌ ꞌin skwan tiyeꞌ. Kanꞌ chaꞌ katsaǎnꞌ ꞌwan xiyaꞌ ni: Kiꞌya wan kwenta ni sa ñaꞌan ngiꞌni skwan tiyeꞌ nu nda neꞌ fariseo loꞌo neꞌ saduceo ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ngwa biyaꞌ tiꞌ neꞌ bra kanꞌ, chaꞌ nchkwiꞌ Jesús chaꞌ ꞌin nchga chaꞌ kuxi nu nduꞌu neꞌ fariseo loꞌo neꞌ saduceo ꞌin nten, chaꞌ ja suꞌwe xñi neꞌ chaꞌ kanꞌ; siꞌi chaꞌ ꞌin skwan tiyeꞌ nu ndyuꞌwi lo jaxlya ngwa tiꞌ Jesús chkwiꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Xa wa mdiya neꞌ laja yuu nu kwenta ꞌin kichen Cesarea de Filipo, mnichaꞌ Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―¿Ni ñaꞌan nchkwiꞌ ra nten chaꞌ ꞌñaǎn a? ¿Ta naꞌ lkaǎn ti kwiꞌ nu wa msuꞌwa Ndiose ndijyan chaꞌ ka nten a? ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","―Ndiya nten nu nchkwiꞌ chaꞌ nuꞌwin lkaa ayman Xuwa nu mdukwatya ꞌin nten nu ngwa xkanꞌ ―ndukwin neꞌ ꞌin Jesús―. Loꞌo ndiya nten nu nchkwiꞌ chaꞌ ayman Elías lkaa. Loꞌo ndiya nten nu nchkwiꞌ chaꞌ ayman Jeremías lkaa. Loꞌo ndiya nten nu nchkwiꞌ chaꞌ wa ndyuꞌu xka ayman xiyaꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; ti kwiꞌ kanꞌ lka nuꞌwin, ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Xiyaꞌ mnichaꞌ Jesús ꞌin neꞌ kanꞌ: ―Loꞌo ꞌwan ni, ¿ti ka nu lkaǎn, nxkeꞌ tiꞌ wan? ");
INSERT INTO ctpNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Bra ti mxkwen Tyu Simón ꞌin Jesús bra kanꞌ: ―Krixtu lka nuꞌwin. Sñiꞌ Ndiose nu luꞌu lkaa nuꞌwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","―Suꞌwe nka tiye nuꞌwin Simón, sñiꞌ Jona ―ndukwin Jesús ꞌin yu bra kanꞌ―. Siꞌi nten chalyuu ti nu ngwaꞌu chaꞌ kanꞌ ꞌiin; Stiǐn Ndiose nu ndiꞌin nde niꞌ kwan, kanꞌ nu ytsaꞌ chaꞌ kanꞌ ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tyu naan, kanꞌ chaꞌ nuꞌwin kaa sa ñaꞌan lka ska kee nu nsu kiyaꞌ naꞌan. Chañi ꞌa chaꞌ nu ykwiiꞌ tsan; kanꞌ lka suun chaꞌ ꞌin nten ꞌñaǎn, chaꞌ tsaa ꞌa nganun chaꞌ nu ykwiiꞌ ngwañaꞌan. Ja ka ꞌin kuneꞌ xaꞌan tyijin lyo ꞌin nten ꞌñaǎn; loꞌo kwiꞌin kuxi, loꞌo ayman, loꞌo nten, ja tukwin ka ꞌin tyijin lyo ꞌin nten ꞌñaǎn, ni siya kaja nten ꞌñaǎn siꞌya chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Taǎn nchga chabiyaꞌ ꞌñaǎn ꞌiin, chaꞌ ka sten nten ꞌñaǎn nde seꞌen lka Ndiose ndloo la. Xa nu ja kuꞌnii chaꞌ tlyu tiꞌ ꞌin nten ꞌin ska chaꞌ kuxi nu yꞌni neꞌ kanꞌ, kwiꞌ ngwañaꞌan ja kuꞌni Stiǐn Ndiose chaꞌ tlyu tiꞌ ꞌin nten kanꞌ nde loo la; xa nu kuꞌnii chaꞌ tlyu tiꞌ ꞌin nten, kwiꞌ ngwañaꞌan kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Loꞌo ngulo Jesús tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ ja katsaꞌ ꞌa neꞌ ꞌin nten chaꞌ ti kwiꞌ Krixtu lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Loꞌo mdyisnan Jesús ngwaꞌu yu ꞌin neꞌ chaꞌ ndiꞌin chaꞌ tsaa yu kichen Jerusalén. Kichen kanꞌ ta neꞌ kula ꞌin neꞌ judío nu tiꞌí ꞌin yu. Kwiꞌ sti joꞌo nu lka ndloo la, loꞌo mstru nu nduꞌu chaꞌ joꞌo, nchga neꞌ kula kanꞌ ta neꞌ nu tiꞌí ꞌin yu sa ñaꞌan bra nu kujwi neꞌ ꞌin yu. Loꞌo tyuꞌu yu xiyaꞌ la mdaꞌa snan tsan, ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Loꞌo msñi Tyu yaꞌ Jesús chaꞌ chkwiꞌ yu loꞌo: ―Ja kulaa yaꞌ Ndiose ꞌiin chaꞌ ka ngwañaꞌan, Xꞌnaǎn ―ndukwin Tyu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Bra ti mxinaꞌan Jesús tloo Tyu bra kanꞌ. ―¡Tyoꞌo tsuuꞌ, Satanás! ¡Ja chkwiiꞌ loꞌoǔn ngwañaꞌan, chaꞌ siꞌi ran! ―ndukwin Jesús ꞌin yu―. Ja nka tiye nuꞌwin sa ñaꞌan nka tiye Ndiose, sa ñaꞌan nka tiye nten chalyuu ti nka tiye nuꞌwin ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Loꞌo ngwaꞌu la Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Bra nu ndiya nten nu chañi chaꞌ nchka tiꞌ tyaꞌan loꞌoǔn ―ndukwin―, ndiꞌin chaꞌ kulaa yaꞌ neꞌ kanꞌ ꞌin nchga nan nu nchka la tiꞌ neꞌ, chaꞌ tyaꞌan neꞌ loꞌoǔn nchga tsan, ni siya kujwi nten ꞌin neꞌ kanꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kanaꞌ kasiya ꞌin nten nu xkwiꞌ ndaꞌan ꞌa chaꞌ tiye neꞌ ni ñaꞌan ka suꞌwe la chaꞌ ꞌin neꞌ, ti ykwiꞌ ti neꞌ; loꞌo kaja chalyuu ꞌin neꞌ seꞌen ndiꞌin Ndiose bra nu xlyaa neꞌ tyaꞌan neꞌ loꞌoǔn, ni siya kujwi nten ꞌin neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ja ska chaꞌ suꞌwe kanun ꞌin nten bra nu kaja neꞌ, ni siya yꞌni ꞌa neꞌ kanan lo chalyuu; loꞌo kanaꞌ kasiya ꞌin neꞌ bra kanꞌ, chaꞌ ja ka ta nten liyaꞌ chaꞌ kaja kasiya ꞌin neꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Chañi chaꞌ bra nu kaǎn xiyaꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, suꞌwa ti kaǎn loꞌo nchga angajle; ka nduwi ꞌa tyukwi ñaꞌaǎn loꞌo xaa ꞌin Stiǐn Ndiose bra kanꞌ. Tsan kanꞌ taǎn siyaꞌ nten kwenta tñan nu wa yꞌni skaa neꞌ xa nu yan neꞌ lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Chañi chaꞌ nchkwiǐnꞌ loꞌo wan ni, chaꞌ ndiya nten nu ti nduun loꞌoǔn lo chalyuu re ni, nu ti ji kaja neꞌ, kanꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ wa mdyisnan chaꞌ lkaǎn ndloo niꞌ kasiya ꞌin nten, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Xa wa mdaꞌa skwa tsan, bra kanꞌ ndyaa loꞌo Jesús ꞌin Tyu loꞌo Santiago loꞌo Xuwa taꞌa ngula Santiago kanꞌ; jakwa yu kanꞌ ndyaa yu lo kiꞌya kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Xa nu ti naꞌan neꞌ kanꞌ ꞌin Jesús, wa mxaꞌan tyukwi ñaꞌaan bra kanꞌ. Luwi ꞌa ñaꞌan tloo yu; sa ñaꞌan luwi xaa kwichaa, ngwañaꞌan ñaꞌan yu bra kanꞌ. Ñaꞌan tiꞌ ska xaa nu ngaten ꞌa, ngwañaꞌan ngaten ꞌa ñaꞌan steꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ti kwiꞌ bra kanꞌ mdoꞌo tukwa ayman Moisés loꞌo ayman Elías, nduun neꞌ nchkwiꞌ neꞌ loꞌo Jesús. Loꞌo taꞌa ndaꞌan Jesús ni, naꞌan neꞌ ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Kwiꞌ ykwiꞌ Tyu loꞌo Jesús bra kanꞌ: ―Xꞌnaǎn ―ndukwin Tyu ꞌin yu―, ¡suꞌwe ꞌa chaꞌ loꞌo bare ndiꞌin ba! ―ndukwin―. ¿Ta suꞌwe nchka tiiꞌ si kwiñan ba snan naꞌan xuwe ti a? Ska ka seꞌen tyiꞌin ykwiiꞌ, xka ka seꞌen tyiꞌin yu kula Moisés, xka ka seꞌen tyiꞌin yu kula Elías. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bra nu ykwiꞌ Tyu mdoꞌo tukwa ska ko nu ngaten ꞌa, nu nduwi ꞌa, nu ndyuꞌwi ñaꞌaan seꞌen nduun neꞌ. Ynen ykwiꞌ ska nten bra kanꞌ. Bra ti ngwa biyaꞌ tiꞌ neꞌ kanꞌ, chaꞌ nchkwiꞌ Ndiose loꞌo neꞌ laja ko kanꞌ: ―Yu re lka yu Sñiěnꞌ, ndiya ꞌa tiǎnꞌ ꞌin yu ―ndukwin Ni―. Suꞌwe ꞌa nka tiyeěn naꞌaǎn ꞌin yu. Kunan suꞌwe wan nchga chaꞌ nu chkwiꞌ Sñiěnꞌ re loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Bra wa ynan neꞌ nu ngiꞌni xaꞌan kanꞌ, chaꞌ nu ykwiꞌ Ndiose chaꞌ ꞌin Jesús, mlyuu neꞌ kanꞌ lyuu bra kanꞌ, chaꞌ ytsen ꞌa neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Loꞌo mstya yaꞌ Jesús chunꞌ neꞌ bra kanꞌ. ―Tyituun wan ―ndukwin Jesús ꞌin neꞌ―, ja kutsen ꞌa wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kanꞌ naꞌan taꞌa snan neꞌ nu ngiꞌni xaꞌan kanꞌ seꞌen mduun ayman kanꞌ tsan la, naꞌan neꞌ chaꞌ ja tukwin ꞌa nduun; xka ti Jesús nduun bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bra nu ngwiꞌya neꞌ siꞌ kiꞌya kanꞌ, ngulo Jesús tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Ja katsaꞌ ꞌa wan ꞌin nten ni sa ñaꞌan nan nu wa naꞌan wan lo kiꞌya kwa tsan ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Sa ñaꞌan bra nu kajaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, sa ñaꞌan bra nu ndyuꞌuǔn xiyaꞌ, kanꞌ ka katsaꞌ wan chaꞌ kanꞌ ꞌin nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿Ni sa ñaꞌan ndyoꞌo chaꞌ nu nchkwiꞌ kityi kula sikwa? Nchkwiꞌ ran chaꞌ ti kulo la ndiꞌin chaꞌ kan ayman Elías lo chalyuu xiyaꞌ ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","―Chañi chaꞌ kan Elías kulo, chaꞌ kuꞌni xuꞌwe yu ꞌin nchga lo nan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Chañi katsaǎnꞌ ꞌwan chaꞌ wa lka yan nu lka Elías lo chalyuu nu ngwa xkanꞌ ti; loꞌo ja yuꞌwi lyo neꞌ ꞌin yu, kanꞌ chaꞌ yꞌni neꞌ chaꞌ kuxi loꞌo yu. Kwiꞌ ngwañaꞌan ta neꞌ nu tiꞌí ꞌñaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ngwañaꞌan ngwa biyaꞌ tiꞌ neꞌ chaꞌ ꞌin ayman Xuwa nu ndukwatya ꞌin nten lka chaꞌ nu tka ykwiꞌ ti Jesús loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bra wa ngwiꞌya neꞌ siꞌ kiꞌya kanꞌ, xiyaꞌ mdiyan neꞌ seꞌen ndiꞌin nten kaꞌan kanꞌ, loꞌo nchga taꞌa ngiꞌni xaꞌan neꞌ chaꞌ ꞌin Jesús. Bra ti mdiyan ska yu kiꞌyu, mduun xtyinꞌ yu tloo Jesús, ykwiꞌ yu kanꞌ loꞌo Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Chka tꞌnan tiiꞌ ꞌin sñiěnꞌ, yu kula ―ndukwin yu kanꞌ ꞌin Jesús―. Tiꞌí ꞌa sñiěnꞌ chaꞌ taꞌa ti nxlyuu kwiꞌin kuxi ꞌin yu; ngiꞌni kwiꞌin kanꞌ chaꞌ bra ti ndlyuu yu lo kiiꞌ, taꞌa ti nxtyuu ꞌin yu lo tyiꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yiꞌaǎn loꞌoǔn ꞌin yu tiꞌí re seꞌen ndiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin, loꞌo ja ngwa ꞌin neꞌ kuꞌni neꞌ chaꞌ chkaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","―¡Ja ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose siyaꞌ ti! ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¡Kuxi ꞌa kasiya ꞌwan! Ja suꞌwe kanuǔn seꞌen ndiꞌin wan, ja taloǔn ꞌwan siyaꞌ ti. Kan loꞌo wan ꞌin yu tiꞌí kwa seꞌen ndiꞌiǐn ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kanꞌ ngulo Jesús tñan ꞌin kwiꞌin kuxi, chaꞌ tyoꞌo tsuꞌ siyaꞌ ti ꞌin yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Chunꞌ ndiꞌin la chinꞌ mnichaꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin neꞌ, ti ykwiꞌ ti neꞌ: ―¿Ni chaꞌ ja ngwa ꞌwa kulo ba ꞌin kwiꞌin kuxi kanꞌ sikwa? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Chinꞌ ti yaꞌ ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose, kanꞌ chaꞌ ja ngwa ꞌwan ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Chañi chaꞌ re nu nchkwiǐnꞌ loꞌo wan: Ñaꞌan tiꞌ ska mta yka nu xuwe ꞌa, ni siya ngwañaꞌan ti tsaa ñaꞌan tiꞌ wan ꞌin Stiǐn Ndiose, bra kanꞌ ka chkwiꞌ wan loꞌo kiꞌya kwan kwa: “Tyoꞌo tsuuꞌ, tyaa xka seꞌen nde kwa la” nchkwin wan ꞌin ran, loꞌo kunan kiꞌya kanꞌ chaꞌ nu chkwiꞌ wan loꞌo ran. Kanꞌ tyoꞌo tsuꞌ kiꞌya kanꞌ, tsaa xka seꞌen bra kanꞌ. Ja ndiya tñan nu ja ka kuꞌni wan bra nu chañi ka chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Kwiꞌ ngwañaꞌan, bra nu kulo wan ꞌin kwiꞌin kuxi kanꞌ, ja ka kulo wan ꞌin kwiꞌin kanꞌ si ja suwi wan chinꞌ ꞌwan, ti ykwiꞌ ti wan; suꞌwe si ja ku wan tyaja bra nu chkwiꞌ wan loꞌo Ndiose chaꞌ ꞌin neꞌ nu tiꞌí ngwañaꞌan. Ngwañaꞌan kuꞌni wan sa ñaꞌan yaꞌ nu tyoꞌo kwiꞌin kanꞌ tyaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Chunꞌ ndiꞌin la, ti ndyaa neꞌ ti chinꞌ nde lo yuu ꞌin Galilea, Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Laja nu ndyaa neꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ndiya ska nten nu kujwiꞌ xuꞌwa ꞌñaǎn ꞌin neꞌ wsiya chaꞌ ta neꞌ nu tiꞌí ꞌñaǎn, ni siya wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kujwi neꞌ kanꞌ ꞌñaǎn bra kanꞌ, kwiꞌ tyuꞌuǔn xiyaꞌ la taꞌa snan tsan bra kanꞌ. Loꞌo ngwa xiꞌin ꞌa tiꞌ neꞌ bra nu wa ynan neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wa tsan chinꞌ ndyaan neꞌ kichen Capernaum, mdiyan neꞌ nu lka tñan niꞌ lyaa seꞌen ndiꞌin Tyu; nxoꞌ tiꞌin neꞌ kanꞌ tñi chaꞌ ꞌin laa tnun nu ndukwa Jerusalén. Ykwiꞌ neꞌ kanꞌ loꞌo Tyu bra kanꞌ: ―Nu nka mstru ꞌwan ni, ¿ta loꞌo yu nda yu tñi niꞌ lyaa kanꞌ a? ―ndukwin neꞌ ꞌin Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","―Nda yu ―ndukwin Tyu ꞌin neꞌ bra kanꞌ. Bra nu ngula Tyu tu naꞌan xiyaꞌ, ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Simón, ¿ni sa ñaꞌan nxkeꞌ tiiꞌ a? ―ndukwin Jesús ꞌin Tyu―. ¿Ti ka lka nu nda tñi ꞌin neꞌ nu ndloo tñi kanꞌ? ¿Ta ndlo neꞌ tñi ꞌin sñiꞌ neꞌ, nxkeꞌ tiiꞌ a? ¿Ta siꞌi ꞌin xka nten ndlo neꞌ tñi a? ");
INSERT INTO ctpNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","―Ndlo neꞌ kanꞌ tñi ꞌin xka ta nten, ja ndlo neꞌ ran ꞌin sñiꞌ neꞌ ―ndukwin Tyu bra kanꞌ. ―Chañi chaꞌ ꞌiin. Ja loꞌo sñiꞌ neꞌ nda liyaꞌ ꞌin chaꞌ kanꞌ sikwa ―ndukwin Jesús ꞌin Tyu―. ");
INSERT INTO ctpNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Loꞌo ni, ja nchka tiǎnꞌ chaꞌ kasinꞌ tiꞌ neꞌ kanꞌ ꞌñaǎn, neꞌ nu lka ndloo la niꞌ lyaa tnun kanꞌ, kanꞌ chaꞌ yaa lyaa tuꞌwa tiyuꞌ chaꞌ kuun chkwan xñi kula lo tyiꞌa, chaꞌ xñii ska kula. Kwiꞌ xñii lyaa kula nu kaja ꞌiin kulo la, slaa tuꞌwa kula kanꞌ, chaꞌ kuloo tñi nu nsuꞌwi tuꞌwa iꞌ; kala tñi kanꞌ chaꞌ taa tñi ꞌin neꞌ kanꞌ chaꞌ ꞌiin, kwiꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti kwiꞌ bra kanꞌ mdiyan nchga neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin yu, chaꞌ chkwiꞌ neꞌ loꞌo yu: ―¿Ti ka lka nu ndloo la chaꞌ ꞌin seꞌen lka Ndiose ndloo? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Kanꞌ msiꞌya Jesús ꞌin ska nu xuwe ti chaꞌ kan seꞌen ndiꞌin yu bra kanꞌ, chaꞌ tyituun nu xuwe ti tloo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","―Chañi chaꞌ nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús ꞌin neꞌ―, chaꞌ ja ka sten wan chaꞌ ꞌin Ndiose chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌwan bra nu ja ya xaꞌan chaꞌ tiye wan; ndiꞌin chaꞌ ka tiye wan sa ñaꞌan lka tiye nu xuwe ti re, chaꞌ ja ngiꞌni siyeꞌ nu xuwe. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ska nten nu lka sa ñaꞌan lka nu xuwe ti re, ska nten nu ja ya ka siyeꞌ tiye, nu ja nchka tiꞌ tyijin lyo ꞌin taꞌa nten chaꞌ ka ykwiꞌ yu ska nten tnun, kanꞌ lka nu ndloo la chaꞌ ꞌñaǎn seꞌen lka Ndiose ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Bra nu tayaꞌ wan ꞌin ska nten ñaꞌan tiꞌ nu xuwe ti re, chunꞌ msñi suꞌwe wan chaꞌ ꞌñaǎn, kwiꞌ ngwañaꞌan nan ndayaꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Si ndiya nten nu ndatsaa ꞌin taꞌa nten chaꞌ kuꞌni chaꞌ kuxi, ni siya ndatsaa nten kanꞌ ꞌin nu xuwe ti re chaꞌ kuꞌni chaꞌ kuxi, suꞌwe la chkanꞌ ska kichi tnun ynin nten kuxi kanꞌ, loꞌo kanꞌ xtyuu neꞌ ꞌin neꞌ kanꞌ lo tyiꞌa tujoꞌo chaꞌ tyii ji chaꞌ ꞌin neꞌ bra kanꞌ. Suꞌwe la si kaja nten nu ngwañaꞌan ngiꞌni, chaꞌ ja tatsaa ꞌa neꞌ ꞌin xka la nu xuwe ti chaꞌ kuꞌni chaꞌ kuxi ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Tꞌnan ꞌa nten chalyuu re! Nsuꞌwi ꞌa chaꞌ kuxi nu ngiꞌni ñuꞌun tiye nten. Nchga bra ndiya chaꞌ kuxi ngwañaꞌan lo chalyuu, loꞌo tnun ꞌa chaꞌ ngiꞌni nten nu ndatsaa ꞌin taꞌa nten chaꞌ kuꞌni chaꞌ kuxi; tlyu ꞌa nu tiꞌí kaja ꞌin neꞌ kanꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Ndiꞌin chaꞌ kulaa yaꞌ wan siyaꞌ ti nchga chaꞌ kuxi nu ndiya la tiꞌ wan, ni siya ndloo ꞌa chaꞌ kuxi kanꞌ ꞌwan ñaꞌan tiꞌ ska laꞌa yaꞌ wan, ñaꞌan tiꞌ ska laꞌa kiyaꞌ wan. Suꞌwe la si tyisnan chalyuu nu ja tsaa tii ꞌa ꞌwan, ni siya ja loꞌo chaꞌ kuxi kanꞌ nu ndiya la tiꞌ wan, loꞌo kanꞌ ja tsaa ꞌa wan lo kiiꞌ nu ja tsaa tii ꞌa chaꞌ nchkin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ti kwiꞌ ti chaꞌ, bra nu ndiya la tiꞌ wan ska chaꞌ kuxi nu ñaꞌan wan, ndiꞌin chaꞌ kulaa yaꞌ wan chaꞌ kanꞌ siyaꞌ ti, sa ñaꞌan lka si kulo wan ska laꞌa kiloo wan lka chaꞌ kanꞌ, chaꞌ ja kuꞌni ꞌa wan chaꞌ kuxi kanꞌ siyaꞌ ti. Suꞌwe la si tyisnan chalyuu nu ja tsaa tii ꞌa ꞌwan, ni siya ja loꞌo chaꞌ kuxi kanꞌ nu ndiya la tiꞌ wan, loꞌo kanꞌ ja tsaa ꞌa wan lo kiiꞌ nu ja tsaa tii ꞌa chaꞌ nchkin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Ja suꞌwe xa nu ja kuwe tiꞌ wan ꞌin ska nten ꞌñaǎn, ñaꞌan tiꞌ ska nu xuwe ti re. Chañi chaꞌ nchkwiǐnꞌ loꞌo wan, chaꞌ ndiya angajle seꞌen ndiꞌin Ndiose nu ndiꞌin kwan ꞌin nchga nu xuwe ti kanꞌ; nchga bra nsuꞌwi chabiyaꞌ chkwiꞌ angajle kanꞌ loꞌo Stiǐn Ndiose chaꞌ ꞌin nu xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wa ndijyaǎn lo chalyuu chabiyaꞌ ꞌin Ndiose chaꞌ kaǎn nten, chaꞌ kulaǎn ꞌin nten chalyuu nu wa mnaꞌ kasiya ꞌin siꞌya chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Ni sa ñaꞌan xkeꞌ tiꞌ wan ni a? Wa nsuꞌwi ska siyentu slyaꞌ ꞌin ska nten, loꞌo mdiya ska tsan mnaꞌ ska ti slyaꞌ ꞌin yu. ¿Ni sa ñaꞌan kuꞌni yu bra kanꞌ a? Nde ñaꞌan kuꞌni yu, nxkeꞌ tiǎnꞌ: Xnun yu ꞌin ñaꞌaan ta slyaꞌ kaꞌan kanꞌ siꞌ kiꞌya seꞌen suꞌwe ti ndiꞌin iꞌ, chaꞌ tsaa yu tsaa naan yu ꞌin slyaꞌ nu mnaꞌ ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bra nu tyija lyo slyaꞌ kanꞌ ꞌin yu, ka suꞌwe ꞌa ka tiye yu bra kanꞌ, chaꞌ xiyaꞌ ñaꞌan yu ska ti slyaꞌ nu wa mnaꞌ ꞌin yu; loꞌo ja ndiꞌin chaꞌ tyaꞌan chaꞌ tiye yu chaꞌ ꞌin xa jyakwa yla nsuꞌwi tiꞌyun lkwa slyaꞌ nu nganun suꞌwe ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Sa ñaꞌan nu ngiꞌni xꞌnan slyaꞌ kanꞌ, chaꞌ ja kanaꞌ ska slyaꞌ ꞌin yu, ngwañaꞌan ngiꞌni Sti wan Ndiose nu ndiꞌin nde niꞌ kwan, chunꞌ ja nchka tiꞌ Ni chaꞌ kanaꞌ kasiya ꞌin ska nten siꞌya chaꞌ kuxi nu ndiꞌin ꞌin neꞌ. Ja nchka tiꞌ Ndiose chaꞌ tyii chaꞌ ꞌin ska nten, ni siya xuwe ꞌa neꞌ kanꞌ, nxkeꞌ tiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Bra nu ndiya ska nten taꞌa wan nu wa yꞌni ska chaꞌ kuxi loꞌo wan, bra kanꞌ tsaa wan seꞌen ndiꞌin yu taꞌa wan kanꞌ, chaꞌ mnan ti katsaꞌ wan ꞌin yu kanꞌ sa ñaꞌan lka chaꞌ kuxi nu yꞌni yu loꞌo wan. Suꞌwe ꞌa bra kanꞌ si xlyaa yu taꞌa wan kanꞌ kunan yu chaꞌ nu chkwiꞌ wan loꞌo yu. Ka xiꞌin tiꞌ yu bra kanꞌ, siꞌya chaꞌ kuxi kanꞌ nu wa yꞌni yu, chka suꞌwe chaꞌ ꞌwan loꞌo yu taꞌa wan kanꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ni siya ja xlyaa yu taꞌa wan kanꞌ kunan yu chaꞌ nu nchkwiꞌ wan loꞌo yu, suꞌwe la si tsaa wan seꞌen ndiꞌin yu kanꞌ xiyaꞌ; loꞌo xka la neꞌ taꞌa wan tsaa wan bra kanꞌ, chaꞌ loꞌo neꞌ kanꞌ kunan neꞌ chaꞌ nu chkwiꞌ taꞌa tyukwaa wan, chaꞌ ka neꞌ kanꞌ testigo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si ja xlyaa ꞌa yu taꞌa wan kanꞌ kunan yu chaꞌ nchkwiꞌ tukwa snan wan bra kanꞌ, ndiꞌin chaꞌ katsaꞌ wan chaꞌ kanꞌ ꞌin ñaꞌaan ta nten ꞌwan, nu suꞌwa ngiꞌni tnun wan ꞌin Ndiose. Ti kwiꞌ ti chaꞌ, si ja xlyaa yu taꞌa wan kanꞌ kunan yu chaꞌ nu nchkwiꞌ ñaꞌaan ta taꞌa wan loꞌo yu bra kanꞌ, ja chka suꞌwe chaꞌ ꞌwan loꞌo yu kanꞌ sikwa. Ñaꞌan tiꞌ ska nten nu ja ndiꞌin chaꞌ ꞌin loꞌo Ndiose siyaꞌ ti, ngwañaꞌan ka yu kanꞌ loꞌo wan; sa ñaꞌan ngiꞌni wan loꞌo ska msu ꞌin neꞌ xka laꞌa tsuꞌ nu kwiñi ti ndlo kaꞌan ꞌa tñi ꞌwan, ngwañaꞌan kuꞌni wan loꞌo yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Chañi chaꞌ nu nchkwiǐnꞌ re, chaꞌ xa nu ja kuꞌni wan chaꞌ tlyu tiꞌ ꞌin nten ꞌin ska chaꞌ kuxi nu yꞌni neꞌ kanꞌ, kwiꞌ ngwañaꞌan ja kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ nde loo la. Loꞌo bra nu kuꞌni wan chaꞌ tlyu tiꞌ ꞌin nten, kwiꞌ ngwañaꞌan kuꞌni Stiǐn Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Xiyaꞌ katsaǎnꞌ ꞌwan chaꞌ chañi chaꞌ kuꞌni Stiǐn nu ndiꞌin nde niꞌ kwan nchga chaꞌ nu jñan wan ꞌin Ni, xa nu suꞌwa chaꞌ nsuꞌwi tiye wan, ni siya tukwa ti wan ndiꞌin wan nchkwiꞌ wan loꞌo Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Loꞌoǔn ndiꞌiǐn loꞌo wan nchga seꞌen nu ndyoꞌ tiꞌin tukwa snan ti wan chabiyaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Loꞌo ndijyan Tyu kwiꞌ seꞌen la chaꞌ kunichaꞌ yu ꞌin Jesús: ―Xꞌnaǎn ―ndukwin ꞌin Jesús―, ¿ni lkwa yaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin yu taꞌaǎn xa wa yꞌni yu ska chaꞌ kuxi loꞌoǔn? ―ndukwin―. ¿Ta suꞌwe kati yaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin yu a? ");
INSERT INTO ctpNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Mxkwen Jesús ꞌin Tyu bra kanꞌ: ―Ja chkwiǐnꞌ chaꞌ kati ti yaꞌ ―ndukwin Jesús―. Suꞌwe kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa wan ni siya snan yla nsuꞌwi tiꞌyun tyukwa yaꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Chkwiǐnꞌ xka chaꞌ loꞌo wan, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka bra nu lka Ndiose ndloo niꞌ kasiya ꞌin nten: Chkwiǐnꞌ chaꞌ ꞌin ska ree nu ngwa tiꞌ kuꞌni tyii tneꞌ nu ndukwi msu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nu mdyisnan ti ree kuꞌni yu ngwañaꞌan, bra ti mdoꞌo tukwa neꞌ seꞌen ndiꞌin ree kanꞌ, mdiyan loꞌo neꞌ ꞌin ska msu nu ndukwi tyun ꞌa miyun pxu ꞌin ree kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ja la nsuꞌwi tñi ꞌin msu kanꞌ, chaꞌ tya yu tneꞌ kanꞌ ꞌin xꞌnan yu; kanꞌ chaꞌ ngulo xꞌnan yu tñan chaꞌ kujwiꞌ neꞌ ꞌin msu kanꞌ, loꞌo kwilyoꞌo yu, loꞌo taꞌa sñiꞌ yu, loꞌo nchga nan nu nsuꞌwi ꞌin yu ka kiyaꞌ chaꞌ tya yu tñi nu ndukwi yu ꞌin xꞌnan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ytsen ꞌa msu kanꞌ bra kanꞌ, mlyuu yu lyuu tloo xꞌnan yu. Mduun xtyinꞌ yu tloo xꞌnan yu chaꞌ jñan la yu chinꞌ bra ꞌin xꞌnan yu bra kanꞌ: “Xꞌnaǎn” ndukwin msu kanꞌ ꞌin ree, “taloo chinꞌ ꞌñaǎn. Taa la chinꞌ bra ꞌñaǎn chaꞌ tyaǎn nchga tñi nu ndukwiǐn ꞌiin tyaa wcha la.” ");
INSERT INTO ctpNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ngwa tꞌnan tiꞌ ree kanꞌ ꞌin yu bra kanꞌ, yꞌni chaꞌ tlyu tiꞌ ꞌin yu ꞌin tneꞌ ndukwi yu. “Wa mdyii tneꞌ ꞌiin ni. Ja ndukwii ꞌa ꞌñaǎn ni” ndukwin xꞌnan yu ꞌin yu. Mdoꞌo msu kanꞌ ndyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tuwiin seꞌen ndyaa yu, mdyukwa taꞌa yu loꞌo taꞌa msu yu nu ndukwi chinꞌ ti tñi ꞌin yu bra kanꞌ. Bra ti msñi yu ynin taꞌa yu, tlá ꞌa yu ꞌin taꞌa msu yu. “¿Ni bra tyaa tñi nu ndukwii ꞌñaǎn?” ndukwin yu ꞌin taꞌa msu yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Loꞌo nu ndukwi chinꞌ ti tñi kanꞌ ni, mduun xtyinꞌ yu tloo msu tlá kanꞌ, mjñan chinꞌ chaꞌ tlyu tiꞌ ꞌin yu tlá kanꞌ, chaꞌ chka tꞌnan tiꞌ ꞌin yu: “Taloo chinꞌ ꞌñaǎn” ndukwin yu ꞌin yu tlá kanꞌ. “Taa la chinꞌ bra ꞌñaǎn chaꞌ tyaǎn nchga tñi nu ndukwiǐn ꞌiin tyaa wcha la.” ");
INSERT INTO ctpNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Loꞌo msu tlá kanꞌ ni, ja ngwa tꞌnan tiꞌ yu ꞌin taꞌa msu yu siyaꞌ ti; bra ti mstya yu kiꞌya ꞌin taꞌa msu yu la tu naꞌan tñan, chaꞌ suꞌwa neꞌ ꞌin msu kanꞌ niꞌ ñaꞌan chkwan sa ñaꞌan yaꞌ nu tya yu tñi nu ndukwi yu ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bra wa naꞌan nchga taꞌa msu yu sa ñaꞌan chaꞌ kuxi nu yꞌni yu tlá kanꞌ, xiꞌin ꞌa tiꞌ neꞌ chaꞌ ꞌin msu nu nsuꞌwi niꞌ ñaꞌan chkwan kanꞌ bra kanꞌ. Kanꞌ chaꞌ ndyaa neꞌ seꞌen ndiꞌin ree kanꞌ, ytsaꞌ neꞌ nchga chaꞌ kanꞌ ꞌin xꞌnan neꞌ, sa ñaꞌan nu ngwa ꞌin taꞌa msu neꞌ nu ndukwi tñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Bra ti msiꞌya ree ꞌin msu tlá kanꞌ, chaꞌ kan yu xiyaꞌ tloo ree kanꞌ. “¡Xaꞌan ꞌa tiye, nuꞌwin!” ndukwin ree ꞌin yu tlá kanꞌ. “Wa mjñaan chaꞌ tlyu tiꞌ ꞌñaǎn, kwiꞌ yꞌniǐn chaꞌ tlyu tiꞌ ꞌiin nu ngwa xkanꞌ ti, ni siya kaꞌan ꞌa tñi ndukwii ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Loꞌo ni, ¿ni chaꞌ ja ngwa tꞌnan tiiꞌ ꞌin taꞌa msu wan nu ndukwi chinꞌ ti tñi ꞌiin, sa ñaꞌan nu ngwa tꞌnan tiǎnꞌ ꞌiin?” ");
INSERT INTO ctpNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Msinꞌ ꞌa tiꞌ ree ꞌin msu tlá kanꞌ bra kanꞌ, ngulo tñan chaꞌ xñi policía ꞌin yu, chaꞌ suꞌwa neꞌ ꞌin yu niꞌ ñaꞌan chkwan, chaꞌ ta neꞌ nu tiꞌí ꞌin yu sa ñaꞌan yaꞌ nu tya msu tlá kanꞌ nchga tñi nu ndukwi yu ꞌin ree kanꞌ. Kanꞌ lka chaꞌ ꞌin ree loꞌo msu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Sa ñaꞌan yꞌni ree kanꞌ loꞌo msu tlá ꞌin ―ndukwin Jesús ꞌin neꞌ―, ngwañaꞌan kuꞌni Stiǐn nu ndiꞌin nde niꞌ kwan loꞌo nchga wan, bra nu ja tyukwi ti tiye wan kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Bra wa mdyii ykwiꞌ Jesús chaꞌ kanꞌ loꞌo neꞌ, mdoꞌo yu seꞌen ndiꞌin yu lo yuu ꞌin Galilea, ndyaa yu nde lo yuu ꞌin Judea. Mdijin Jesús chku Jordán, ");
INSERT INTO ctpNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","loꞌo kaꞌan ꞌa nten ndaꞌan ñaꞌan ꞌin yu chaꞌ kuꞌni yu joꞌó ꞌin nchga nu tiꞌí nu ndijyan loꞌo neꞌ. Kwiꞌ yꞌni Jesús joꞌó ꞌin nu tiꞌí kanꞌ, nchkaa neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Loꞌo kanꞌ mdiyan chinꞌ neꞌ fariseo seꞌen ndiꞌin Jesús chaꞌ chkwiꞌ biyaꞌ neꞌ loꞌo yu, si tyija ska chaꞌ kuxi ꞌin yu ꞌin neꞌ siꞌya ska chaꞌ nu nchkwiꞌ ti yu, nchka tiꞌ neꞌ. ―¿Ta ndiya chabiyaꞌ chaꞌ kulaa tiꞌin ska nten ꞌin kwilyoꞌo yu siyaꞌ ti, si ja nchka ꞌa tiꞌ yu ꞌin kwilyoꞌo yu a? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","―¿Ta ja ya chkwiꞌ wan lo kityi chaꞌ ꞌin Ndiose a? ―mxkwen Jesús ꞌin neꞌ kanꞌ―. “Ti kulo mñan Ni nten, ska yu kiꞌyu loꞌo ska nu kunaꞌan” ngwañaꞌan ndukwa chaꞌ lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Loꞌo ykwiꞌ Ndiose chaꞌ re: “Kanꞌ chaꞌ tyoꞌo tsuꞌ ska yu kiꞌyu seꞌen ndiꞌin sti yu, seꞌen ndiꞌin jyaꞌan yu, chaꞌ kaja kwilyoꞌo yu loꞌo ska nu kunaꞌan, chaꞌ ka neꞌ ska ti neꞌ taꞌa tyukwaa neꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Siꞌi tukwa nten lka neꞌ bra kanꞌ; sa ñaꞌan si lka neꞌ ska ti nten, ngwañaꞌan lka chaꞌ ꞌin neꞌ bra kanꞌ. Kanꞌ chaꞌ ja suꞌwe kulaa tiꞌin neꞌ ꞌin kwilyoꞌo neꞌ, chaꞌ wa mda Ndiose chabiyaꞌ chaꞌ nchka kwilyoꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xiyaꞌ mnichaꞌ neꞌ fariseo ꞌin Jesús: ―¿Ni chaꞌ lka mda ayman Moisés chabiyaꞌ re ꞌñaan sikwa? Ka kulo yu kiꞌyu ska kityi chaꞌ kulaa tiꞌin yu ꞌin kwilyoꞌo yu, ndukwin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Xiyaꞌ mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Ja nnan wan chaꞌ nchkwiꞌ Ndiose siyaꞌ ti, kanꞌ chaꞌ mda ayman Moisés chabiyaꞌ ꞌwan chaꞌ kulaa tiꞌin wan ꞌin kwilyoꞌo wan loꞌo ska kityi ti ―ndukwin Jesús ꞌin neꞌ―. Siꞌi ngwañaꞌan ngwa tiꞌ Ndiose ti bra nu mñan Ni chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Naꞌ chkwiǐnꞌ chaꞌ re loꞌo wan ni: Bra nu kulaa tiꞌin ska nten ꞌin kwilyoꞌo chaꞌ kaja kwilyoꞌo loꞌo xka nu kunaꞌan, kuꞌni yu chaꞌ kuxi loꞌo kwilyoꞌo yu bra kanꞌ. Ska ti xa wa yten yuꞌwi kwilyoꞌo yu loꞌo xka yu kiꞌyu, ñi ka chaꞌ kulaa tiꞌin yu ꞌin nu kunaꞌan kanꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan loꞌo nu kunaꞌan nu wa ngulaa tiꞌin ꞌin kwilyoꞌo kanꞌ, si xiyaꞌ kaja kwilyoꞌo loꞌo xka nten, chaꞌ kuxi kuꞌni neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Loꞌo ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús loꞌo yu bra kanꞌ: ―Suꞌwe la ni siya ja kaja kwilyoꞌoan siyaꞌ ti, si ngwañaꞌan ka chaꞌ ꞌin ska yu kiꞌyu loꞌo kwilyoꞌo yu ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","―Ndiya ꞌa nu kiꞌyu nu ja talo yu chaꞌ tyiꞌin yu ska ti yu ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ―. Ska ti si kulo Ndiose tñan ꞌin ska nten chaꞌ ja kaja kwilyoꞌo, bra kanꞌ ka talo yu chaꞌ ja kalaꞌ yu ꞌin ska nu kunaꞌan siyaꞌ ti, bra nu tayaꞌ Ndiose ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ndiya tyun lo chaꞌ nu ngiꞌni chaꞌ ja nchka kaja kwilyoꞌo ska yu kiꞌyu: ndiya nu kiꞌyu nu kicha yu ti bra nu ngula yu; kwiꞌ ndiya chinꞌ nu kiꞌyu nu ja nchka ꞌin yu chunꞌ wa yꞌni ñuꞌun nten ꞌin yu kanꞌ; kwiꞌ ndiya chinꞌ nu kiꞌyu nu wa ngulo suwi Ndiose ꞌin yu chaꞌ kuꞌni yu tñan ꞌin Ni, kanꞌ chaꞌ suꞌwe la chaꞌ ja kaja kwilyoꞌo yu kanꞌ bra kanꞌ, chaꞌ ska ti Ndiose ka ndloo ꞌin yu bra kanꞌ, nskeꞌ tiꞌ yu. Ska yu kiꞌyu nu ngwañaꞌan ni, ndiꞌya yu kwenta ti ykwiꞌ ti yu si ka ꞌin yu tyiꞌin yu ska ti yu; suꞌwe si talo yu kanꞌ tyiꞌin yu ska ti yu sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ngwa ska tsan mdiyan loꞌo neꞌ ꞌin tyun nu xuwe ti seꞌen ndiꞌin Jesús. Ngwa tiꞌ neꞌ chaꞌ xtya yaꞌ Jesús ke nu xuwe ti kanꞌ, chaꞌ chkwiꞌ yu loꞌo Ndiose chaꞌ ꞌin nu xuwe kanꞌ. Loꞌo yꞌni tlá neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bra ti ykwiꞌ Jesús loꞌo yu kuneꞌ kanꞌ: ―Ta wan chabiyaꞌ ꞌin nu xuwe ti chaꞌ kan neꞌ seꞌen ndiꞌiǐn ―ndukwin Jesús ꞌin yu kanꞌ―. Ja tukunꞌ ꞌa wan chaꞌ ꞌin nu xuwe, chaꞌ ja kan neꞌ. Sa ñaꞌan lka bra nu ndyaa ñaꞌan tiꞌ nu xuwe ꞌin sti neꞌ, ngwañaꞌan ndiꞌin chaꞌ tsaa ñaꞌan tiꞌ nten ꞌin Ndiose chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Mstya yaꞌ Jesús ke nu xuwe kanꞌ bra kanꞌ, mdoꞌo yu ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ngwa ska tsan mdiyan ska nu kiꞌyu kuneꞌ seꞌen ndiꞌin Jesús. ―Mstru, nuꞌwin suꞌwe ꞌa ngiꞌnii nchga tsan ―ndukwin yu ꞌin Jesús―. Kuꞌnii chaꞌ suꞌwe katsaaꞌ ꞌñaǎn, ¿ni sa ñaꞌan chaꞌ suꞌwe kuꞌniǐn chaꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌñaǎn? ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―¿Ni chaꞌ nchkwiiꞌ chaꞌ suꞌwe ꞌa ngiꞌniǐn? ―ndukwin Jesús ꞌin yu kanꞌ―. Ska ti Ndiose nu chañi chaꞌ suꞌwe ꞌa ngiꞌni. Kunaan nchga tñan nu ngulo Ndiose ꞌin nten, si nchka tiiꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","―¿Ni sa ñaꞌan tñan lka kanꞌ? ―ndukwin yu kuneꞌ kanꞌ ꞌin yu. Loꞌo ngwaꞌu la Jesús chinꞌ chaꞌ ꞌin yu kanꞌ bra kanꞌ: ―Ja kujwi wan ꞌin taꞌa nten wan; ja sten yuꞌwi wan loꞌo kwilyoꞌo xka nten; ja kuꞌni wan kunan chaꞌ suꞌwe nu nsuꞌwi ꞌin taꞌa nten wan; ja chkwiꞌ wan kwentu ꞌin taꞌa nten wan; ");
INSERT INTO ctpNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kwiꞌ ngwañaꞌan, kuꞌni tnun wan ꞌin sti jyaꞌan wan; chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan, sa ñaꞌan lka bra nu nchka tꞌnan tiꞌ wan ꞌwan, ti ykwiꞌ ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mxkwen yu kuneꞌ ꞌin Jesús bra kanꞌ: ―Ti kuneěnꞌ wa ndukwaǎn nchga tñan kanꞌ nchga tsan ―ndukwin yu kuneꞌ kanꞌ ꞌin Jesús―. ¿Ta ndiya la chaꞌ nu ti ji kuꞌniǐn sikwa a? ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","―¿Ta chañi chaꞌ nchka tiiꞌ chaꞌ ka luwi kasiya ꞌiin a? ¿Ta nchka tiiꞌ kaja chalyuu kwi nu ja tsaa tii ꞌa ꞌiin a? ―ndukwin Jesús ꞌin yu kuneꞌ kanꞌ―. Si chañi chaꞌ nu nchkwiiꞌ, yaa lyaa kujwiiꞌ nchga chaꞌ suꞌwe nu nsuꞌwi ꞌiin; tyoꞌo tñi chaꞌ taa ꞌin nu tiꞌi bra kanꞌ. Loꞌo ta Ndiose chaꞌ suꞌwe ꞌiin seꞌen ndiꞌin Ni nde loo la. Bra wa yꞌnii chaꞌ kanꞌ, kaan seꞌen ndiꞌiǐn chaꞌ tyaꞌaan loꞌoǔn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bra wa ynan yu kuneꞌ kanꞌ chaꞌ nu ykwiꞌ Jesús loꞌo yu, mdoꞌo yu ndyaa yu bra kanꞌ; xiꞌin ꞌa tiꞌ yu chaꞌ ykwiꞌ Jesús chaꞌ kanꞌ, chunꞌ kuliyaꞌ ꞌa yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Loꞌo ykwiꞌ Jesús chaꞌ re loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin―, tukwi ꞌa lka chaꞌ, chaꞌ sten ska neꞌ kuliyaꞌ chaꞌ ꞌin Ndiose, chaꞌ ka Ni ndloo la niꞌ kasiya ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sa la tñan tyijin ska ꞌni kiyaꞌ kuxa, ni siya ska ꞌni tnun ñaꞌan tiꞌ ska camello; sa la chaꞌ kanꞌ, loꞌo tukwi la kala ska neꞌ kuliyaꞌ seꞌen lka Ndiose ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yuwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu xa nu ynan neꞌ chaꞌ kanꞌ. ―¿Ti ka lka nu ka tyoꞌo tsuꞌ ꞌin chaꞌ kuxi nu nsuꞌwi chalyuu chaꞌ kala seꞌen ndiꞌin Ndiose sikwa? ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","―Kanꞌ lka ska tñan nu ja nchka kuꞌni ska nten chalyuu; Ndiose ni, kanꞌ nu nchka kuꞌni chaꞌ kala nten seꞌen ndiꞌin Ni ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ykwiꞌ Tyu loꞌo Jesús bra kanꞌ: ―Loꞌo bare ni, wa ngulaa tiꞌin ba nchga nan nu nsuꞌwi ꞌwa chaꞌ tyaꞌan ba loꞌo nuꞌwin, sa ñaꞌan yaꞌ nu ndukwiin chaꞌ kuꞌni ba ―ndukwin Tyu ꞌin Jesús―. ¿Nan ka kaja ꞌwa nde loo la bra kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús ꞌin neꞌ―, bra nu ka chalyuu kwi kanꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, kanꞌ tyitukwaǎn seꞌen suꞌwe la ti la kwa, chaꞌ kuꞌni biyaǎnꞌ ꞌin nchga nten chalyuu bra kanꞌ. Loꞌo ꞌwan nu ndaꞌan wan loꞌoǔn, tyukwa wan lo tii tyukwa yka xlya tnun nu suꞌwe ꞌa, chaꞌ kuꞌni biyaꞌ wan ꞌin taꞌa nten wan, nu lka tii tyukwa ta neꞌ Israel kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kwiꞌ ngwañaꞌan nchga nten nu ndiꞌin chaꞌ tsaa tijyuꞌ chaꞌ kuꞌni neꞌ tñan ꞌñaǎn, nu loꞌo kulaa tiꞌin neꞌ nchga nan nu nsuꞌwi ꞌin neꞌ chaꞌ kuꞌni neꞌ tñan kanꞌ, ja kulaa yaǎnꞌ ꞌin neꞌ kanꞌ ngwañaꞌan ti; ni siya xnun neꞌ naꞌan tyi neꞌ, ni siya taꞌa ngula neꞌ, ni siya sti neꞌ, ni siya jyaꞌan neꞌ, ni siya sñiꞌ neꞌ, ni siya yuu nu nsuꞌwi ꞌin neꞌ, ni siya xnun neꞌ nchga chaꞌ kanꞌ, kaja chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ nde loo la. Kwiꞌ kaja kaꞌan la chaꞌ kanꞌ ꞌin neꞌ kanꞌ xiyaꞌ, sa ñaꞌan nan nu mnaꞌ ꞌin neꞌ kanꞌ, nxkeꞌ tiꞌ neꞌ, ngwañaꞌan nan nu kaja ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Loꞌo tyun nten nu tyoꞌo tukwa xa wa tyii ti chaꞌ, kanꞌ lka nu ka nde loo la bra kanꞌ; loꞌo tyun nten nu mdoꞌo tukwa ti kulo, kanꞌ lka nu kanun nde chunꞌ la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Xka chaꞌ tiya chkwiǐnꞌ loꞌo wan ni, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka xa nu lka Ndiose ndloo niꞌ kasiya ꞌin nten. Wa mdiya ska xꞌnan msu. Ngwa ska tsan nde tlya mdoꞌo yu ndyaa yu lo kiyaꞌ chaꞌ tsaa naan yu msu, si xlyaa neꞌ kuꞌni neꞌ tñan niꞌ lyoꞌoo ꞌin yu seꞌen yta yu yka chi kutun. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ta yu siyaꞌ msu sa ñaꞌan nu nda ti neꞌ ska tsan bra kanꞌ, ndukwin xꞌnan msu kanꞌ ꞌin neꞌ; suꞌwe ꞌa mskeꞌ tiꞌ neꞌ nu ka msu, si kaja sa kwa liyaꞌ ꞌin neꞌ. Mdoꞌo neꞌ kanꞌ ndyaa neꞌ tñan niꞌ lyoꞌoo ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bra wa mdyii snan bra nsuꞌwi neꞌ tñan, kanꞌ ndyaa xꞌnan msu kanꞌ lo kiyaꞌ xiyaꞌ. Nde kwa naꞌan yu xka ta nten, nduun ti neꞌ chaꞌ ja ya kaja tñan ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Kwiꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ bra kanꞌ: “Yaa lya wan, kuꞌni wan tñan niꞌ lyoꞌoo ꞌñaǎn. Suꞌwa kuꞌni wan tñan loꞌo msu ꞌñaǎn, chaꞌ nde kwa nsuꞌwi neꞌ ngiꞌni neꞌ tñan ꞌñaǎn. Taǎn liyaꞌ suꞌwe ꞌwan bra kanꞌ” ndukwin yu. Bra ti ndyaa neꞌ tñan ꞌin xꞌnan msu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Loꞌo xiyaꞌ ndyaa xꞌnan msu kanꞌ lo kiyaꞌ la ndiꞌya kwan la, xiyaꞌ naꞌan yu chinꞌ nten, nan nduun ti neꞌ. Ti kwiꞌ ti chaꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ bra kanꞌ. Loꞌo bra wa snan siin, kwiꞌ ngwañaꞌan ngwa xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","La wa msiin la, ti nduun la chinꞌ nten lo kiyaꞌ kanꞌ. Kwiꞌ ykwiꞌ xꞌnan msu loꞌo neꞌ bra kanꞌ: “¿Ni chaꞌ lka nduun ti wan nde re tyukwi tsan?” ndukwin yu ꞌin nten kanꞌ. “¿Ja nsuꞌwi tñan ꞌwan sikwa a?” ");
INSERT INTO ctpNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ja ndiya ꞌa nten nu nchka tiꞌ msu tsan ni” ndukwin neꞌ ꞌin yu. “Yaa lya wan kuꞌni wan chinꞌ tñan niꞌ lyoꞌoo ꞌñaǎn sikwa” ndukwin xꞌnan msu kanꞌ ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Bra wa tsaa ti kwichaa ykwiꞌ xꞌnan tñan loꞌo nu lka ndloo la ꞌin msu ꞌin yu: “La ni xiꞌyaa ꞌin nchga msu chaꞌ taa siyaꞌ neꞌ” ndukwin yu. “Ti kulo la taa siyaꞌ msu nu tka mdiyan ti; bra nu wa tyii ti, taa siyaꞌ msu nu mdiyan ti tlya la bra kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mdiyan msu nu tka mdyisnan ti ngiꞌni tñan seꞌen ndiꞌin yu, mda yu siyaꞌ neꞌ sa ñaꞌan si wa yuꞌwi neꞌ tñan tyukwi tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nde chunꞌ la mdiyan msu nu mdyisnan ngiꞌni tñan ti tlya la seꞌen ndiꞌin yu. Mskeꞌ tiꞌ msu kanꞌ chaꞌ kaꞌan la tñi kaja siyaꞌ neꞌ bra kanꞌ, loꞌo suꞌwa ti mjwi siyaꞌ nchga msu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Msinꞌ ꞌa tiꞌ msu nu mdyisnan ngiꞌni tñan ti tlya la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Tyukwi tsan yꞌni ba tñan ꞌiin” ndukwin msu kanꞌ ꞌin xꞌnan neꞌ. “Tikeeꞌ ꞌa kwan ndiꞌya kwan, loꞌo ti yꞌni ba tñan ꞌiin bra kanꞌ. Loꞌo ni, suꞌwa mjwi siyaꞌ ba, nchga taꞌa ngiꞌni ba tñan, ni siya ska bra ti yꞌni neꞌ kwa tñan ꞌiin” ndukwin msu nu mdyisnan ngiꞌni tñan nde tlya la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Loꞌo mxkwen xꞌnan tñan ꞌin msu nu msinꞌ tiꞌ bra kanꞌ: “Siꞌi chaꞌ kuxi nu ngiꞌniǐn loꞌo wan. ¿Ta siꞌi wa mskaǎnꞌ chaꞌ loꞌo wan tsan sa kwa liyaꞌ taǎn ꞌwan a? Kwiꞌ sa kwa tñi siyaꞌ skaa wan mdaǎn ꞌwan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xñi wan siyaꞌ wan, chaꞌ tyaa wan sikwa. Ja ndiꞌin chaꞌ kasinꞌ tiꞌ wan ꞌñaǎn. Naꞌ nchka tiǎnꞌ chaꞌ ka suꞌwa siyaꞌ wan loꞌo xka ta msu nu chinꞌ ti bra yꞌni tñan; suꞌwe ꞌa sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nsuꞌwi chabiyaꞌ ꞌñaǎn kuꞌniǐn sa ñaꞌan nu nchka tiǎnꞌ kuꞌniǐn loꞌo tñi ꞌñaǎn. ¿Ta chañi a? ¿Ni chaꞌ lka tiꞌí tiꞌ wan ꞌñaǎn sikwa? Suꞌwe liyaꞌ mdaǎn ꞌin nchga msu ꞌñaǎn” ndukwin xꞌnan msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Loꞌo ni, nten nu tyoꞌo tukwa xa wa tyii ti chaꞌ, kanꞌ lka nu ka nde loo la; loꞌo nten nu mdoꞌo tukwa ti kulo, kanꞌ lka nu kanun nde chunꞌ la ―ndukwin Jesús―. Wa mniěn ꞌin kaꞌan ꞌa nten chaꞌ kunan suꞌwe neꞌ sa ñaꞌan chaꞌ nu nduꞌuǔn ꞌin neꞌ, loꞌo wa lka ti nten ngulo suwiǐn ꞌin chaꞌ ka neꞌ nten ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Bra nu mdaꞌan neꞌ tuwiin chaꞌ tsaa neꞌ kichen Jerusalén, mdoꞌo tsuꞌ Jesús chinꞌ tuꞌwa tuwiin loꞌo tii tyukwa yu kuneꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ chkwiꞌ yu chinꞌ loꞌo yu kanꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Jlyo tiꞌ wan chaꞌ wa skwen tian tuwiin nde lo kiꞌya ni, chaꞌ wa tsaan tian Jerusalén ―ndukwin Jesús ꞌin yu kanꞌ―. Loꞌo naꞌ, ni siya wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, xñi neꞌ kwa ꞌñaǎn chaꞌ tsaa loꞌo neꞌ ꞌñaǎn tloo sti joꞌo nu lka ndloo la, tloo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa. Kuꞌni biyaꞌ neꞌ kanꞌ ꞌñaǎn bra kanꞌ; chkwiꞌ neꞌ chaꞌ ndiꞌin kiꞌya ꞌñaǎn, chaꞌ ndiꞌin chaꞌ kajaǎn siꞌya kiꞌya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kwiꞌ tsaa loꞌo neꞌ ꞌñaǎn tloo neꞌ xka laꞌa tsuꞌ nu lka ndloo la, chaꞌ xtyi lyoꞌo neꞌ ꞌñaǎn bra kanꞌ. Kwiꞌ ngwañaꞌan, jwiꞌin neꞌ ꞌñaǎn loꞌo ti su, jwiꞌin kaꞌan neꞌ ꞌñaǎn lo wsi chaꞌ kujwi neꞌ ꞌñaǎn bra kanꞌ. Loꞌo la taꞌa snan tsan kanꞌ, tyuꞌuǔn xiyaꞌ bra kanꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Chunꞌ ndiꞌin la mdiyan jyaꞌan Santiago loꞌo Xuwa seꞌen ndiꞌin Jesús. Zebedeo lka sti taꞌa tyukwaa yu kiꞌyu kanꞌ. Suꞌwa ti mdiyan nu kunaꞌan kanꞌ loꞌo taꞌa tyukwaa sñiꞌ, mduun xtyinꞌ tloo Jesús bra kanꞌ, chaꞌ jñan ska chaꞌ suꞌwe ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kanꞌ mnichaꞌ Jesús ꞌin nu kunaꞌan kanꞌ: ―¿Nan lka nchka tiꞌ wan a? ―ndukwin Jesús. ―Kuꞌnii chaꞌ suꞌwe taa chabiyaꞌ chaꞌ suꞌwa ti tyukwa sñiěnꞌ re loꞌoo, seꞌen ka nuꞌwin ndloo la ti nde loo la ―ndukwin nu kunaꞌan kanꞌ―. Kuloo tñan chaꞌ tyukwa ska yu laꞌa seꞌen kwin ꞌiin, xka yu kanꞌ tyukwa yu laꞌa seꞌen ka ꞌiin ―ndukwin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Loꞌo ykwiꞌ Jesús loꞌo taꞌa tyukwaa yu kiꞌyu kanꞌ bra kanꞌ: ―Ja nchka biyaꞌ tiꞌ wan sa ñaꞌan lka chaꞌ nu njñan wan ꞌñaǎn ni ―ndukwin Jesús ꞌin neꞌ―. Sa ñaꞌan ka si ta neꞌ ska rmiyu tlyaaꞌ ꞌa chaꞌ koꞌoǔn, ngwañaꞌan ka nu tiꞌí nu ta neꞌ ꞌñaǎn. ¿Ta talo wan si ta neꞌ nu tiꞌí ꞌwan sa ñaꞌan nu ndiꞌin chaꞌ ta neꞌ nu tiꞌí ꞌñaǎn, bra nu kujwi neꞌ ꞌñaǎn a? ―Talo ba ―ndukwin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","―Chañi chaꞌ loꞌo wan koꞌo wan rmiyu tlyaaꞌ kanꞌ nu ndiꞌin chaꞌ koꞌoǔn, kwiꞌ tyijin wan nu tiꞌí sa ñaꞌan nu tyijiǐn nu tiꞌí ―ndukwin Jesús ꞌin neꞌ―. Loꞌo ni, ja ndiya chabiyaꞌ ꞌñaǎn chaꞌ taǎn ska seꞌen nde siǐnꞌ seꞌen tyukwa wan nde loo la, chaꞌ wa lka ngulo suwi Stiǐn Ndiose ꞌin nten nu tyukwa nde siǐnꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Bra wa ynan nu xa tyii yu taꞌa ngiꞌni xaꞌan chaꞌ ꞌin Jesús, chen ꞌa ngwa tiye yu ñaꞌan yu ꞌin Santiago loꞌo taꞌa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kanꞌ msiꞌya Jesús ꞌin nchga yu kuneꞌ kanꞌ, chaꞌ tyoꞌ tiꞌin tloo yu. ―Jlyo tiꞌ wan chaꞌ nu lka ndloo la ꞌin neꞌ xka laꞌa tsuꞌ ni, tlá ꞌa neꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. Lye ꞌa ndlo neꞌ nu lka ndloo la kanꞌ tñan ꞌin taꞌa kichen tyi neꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","loꞌo ꞌwan, ja ndiꞌin chaꞌ kuꞌni wan ngwañaꞌan. Nchga lo tñan nu ka tayaꞌ wan ꞌin taꞌa nten wan, kanꞌ tñan ndiꞌin chaꞌ kuꞌni wan, xa nu nchka tiꞌ wan chaꞌ ka wan ndloo la ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kwiꞌ ngwañaꞌan, xa nu nchka tiꞌ wan chaꞌ ka wan ndloo la ꞌin yu taꞌa wan, ndiꞌin chaꞌ kuꞌni wan sa ñaꞌan si lka wan msu ꞌin taꞌa nten wan, ni siya ja loꞌo liyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ja ndijyaǎn lo chalyuu chaꞌ kaja msu ꞌñaǎn; ykwiǐnꞌ kaǎn msu ꞌin nten, kanꞌ chaꞌ ndijyaǎn. Wa ndijyaǎn chaꞌ kajaǎn chaꞌ tyii kiꞌya nu ndiꞌin ꞌin nten, chaꞌ kulaǎn ꞌin kaꞌan ꞌa nten bra kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wa mdijin neꞌ kichen Jericó. Wa tyoꞌo ti neꞌ tyaa neꞌ bra kanꞌ, loꞌo kaꞌan ꞌa nten mdoꞌo ñaꞌan ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tuꞌwa tuwiin seꞌen tyijin neꞌ ndukwa tukwa yu kwityiinꞌ; wa ynan yu kwityiinꞌ kanꞌ chaꞌ ti kwiꞌ Jesús ndijin tuwiin kwa, kanꞌ chaꞌ kwen msiꞌya neꞌ ꞌin yu: ―¡Xꞌnan ba, chkaa tꞌnan tiiꞌ ꞌwa! Jlyo tiꞌ ba chaꞌ ti kwiꞌ nu lka taꞌa ayman David lkaa ―ndukwin yu kwityiinꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ja mdiya tiꞌ nten kaꞌan kanꞌ, chaꞌ lye ꞌa msiꞌya yu kwityiinꞌ ꞌin Jesús. ―Mnan ti wan ―ndukwin neꞌ ꞌin yu kwityiinꞌ kanꞌ. Ja ynan yu kwityiinꞌ, kwen la msiꞌya yu bra kanꞌ: ―Xꞌnan ba ―ndukwin yu―, nuꞌwin lkaa ti kwiꞌ yu nu lka taꞌa ayman David ―ndukwin yu kwityiinꞌ kanꞌ ꞌin Jesús―, ¡chkaa tꞌnan tiiꞌ ꞌwa! ");
INSERT INTO ctpNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Loꞌo bra kanꞌ yaa tuun Jesús, msiꞌya ꞌin tyukwaa yu kwityiinꞌ kanꞌ, chaꞌ kan neꞌ seꞌen ndiꞌin yu. ―¿Ni nan ka nchka tiꞌ wan chaꞌ kuꞌniǐn loꞌo wan a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","―Xꞌnan ba ―ndukwin neꞌ kanꞌ ꞌin yu―, nchka tiꞌ ba chaꞌ suꞌwaa suꞌwe xaa kiloo ba chaꞌ ka ñaꞌan ba. ");
INSERT INTO ctpNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tꞌnan ꞌa tiꞌ Jesús ꞌin neꞌ kanꞌ. Mstya xñii yaꞌ yu chunꞌ kiloo neꞌ kanꞌ bra kanꞌ; bra ti ngalaa xaa kiloo neꞌ, ngwa ñaꞌan neꞌ bra kanꞌ. Mdoꞌo neꞌ kanꞌ ndyaa neꞌ bra kanꞌ, mdaꞌan ñaꞌan neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wa kala ti Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kichen Jerusalén. Wa tyijin ti neꞌ ska kichen xuwe ti seꞌen naan Betfagé, siꞌ kiꞌya Olivos ndiꞌin kichen kanꞌ. Ngulo Jesús tñan ꞌin tukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","―Yaa wan lo kichen kwa ―ndukwin yu―. Ndla ti tyija ska buru nu nduun nchkanꞌ ꞌwan; nduun iꞌ loꞌo sñiꞌ iꞌ. Xtiꞌ wan ꞌin iꞌ chaꞌ kan loꞌo wan ꞌin iꞌ nde re. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si kunichaꞌ neꞌ kichen kwa ꞌwan: “¿Ni sa ñaꞌan tñan kuꞌni wan loꞌo buru kwa?”, katsaꞌ wan chaꞌ re ꞌin neꞌ bra kanꞌ: “Ndiya tñan kuꞌni buru re chaꞌ ꞌin ti kwiꞌ nu nka Xꞌnaan.” Bra ti ta neꞌ chabiyaꞌ ꞌwan chaꞌ kan loꞌo wan ꞌin iꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, sa ñaꞌan nu ngwaꞌan neꞌ chaꞌ re lo kityi, ngwañaꞌan nchka chaꞌ ni: ");
INSERT INTO ctpNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Katsaꞌ wan ꞌin neꞌ kichen Sión: “Ñaꞌan kwiꞌya wan chinꞌ nde re, chaꞌ wa ndijyan nu ka ndloo la ꞌwan. Ja tlá yu kula kanꞌ, chunꞌ buru ti ndukwa yu. Ska buru kuneꞌ lka iꞌ, sñiꞌ ꞌni nu ndiꞌya yuꞌwa lka buru kuneꞌ kanꞌ.” Ngwañaꞌan nchkwiꞌ lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kanꞌ ndyaa tyukwaa neꞌ kanꞌ lo kichen bra kanꞌ, sa ñaꞌan nu ngulo Jesús tñan ꞌin neꞌ chaꞌ tsaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ndijyan loꞌo neꞌ ꞌin buru kanꞌ loꞌo sñiꞌ iꞌ. Kanꞌ mstya neꞌ steꞌ neꞌ chunꞌ buru chaꞌ tyukwa Jesús. Loꞌo ndyaa tukwa Jesús chunꞌ iꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kwiꞌ ngwañaꞌan, kaꞌan ꞌa nten nu ndiꞌin la kanꞌ mslaa tiꞌin neꞌ steꞌ neꞌ, mstya neꞌ ꞌin ran tuwiin chaꞌ ka suꞌwe tuwiin seꞌen ndijyan Jesús ndukwa chunꞌ buru kanꞌ. Xka ta nten msiꞌyu stanꞌ yka chaꞌ xtya neꞌ tuwiin seꞌen ndijyan yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Loꞌo nchga nten msiꞌya ꞌa neꞌ chaꞌ suꞌwe ꞌa nka tiye neꞌ, loꞌo neꞌ nu ndyaa nde loo la, loꞌo neꞌ nu ndijyan nde chunꞌ la, suꞌwe ꞌa nka tiye nchga neꞌ kanꞌ. ―¡Kuꞌni tnun ba ꞌiin! Nuꞌwin lkaa ti kwiꞌ taꞌa ayman ree David nu ndiꞌin chaꞌ kan ―ndukwin neꞌ ꞌin Jesús―. ¡Suꞌwe ꞌa kuꞌni Ndiose loꞌoo chaꞌ ndijyaan chabiyaꞌ ꞌin Ni nu nka Xꞌnaan! ¡Kuꞌni tnuan ꞌin Ndiose ni! ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kanꞌ mdiyan neꞌ kanꞌ loꞌo Jesús tuꞌwa kichen Jerusalén, yten neꞌ tuloꞌoo kichen kanꞌ. Loꞌo yuwe ꞌa tiꞌ neꞌ kichen kanꞌ bra kanꞌ. Kwen ꞌa msiꞌya neꞌ loꞌo taꞌa neꞌ: ―¿Ti ka nu lka ndijyan re a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mxkwen nten kaꞌan kanꞌ ꞌin neꞌ kichen bra kanꞌ: ―Jesús Nazaret lka yu re. Nde lo yuu ꞌin Galilea ndukwa kichen tyi yu. Kwiꞌ nchkwiꞌ yu chaꞌ ꞌin Ndiose loꞌo nten ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chunꞌ ndiꞌin la mdiyan Jesús tu laa tnun seꞌen ngiꞌni tnun nten ꞌin Ndiose. Yten yu ndyaa yu niꞌ lyaa kanꞌ, ngulo yu ꞌin nchga nten nde liyaꞌ bra kanꞌ, neꞌ nu ndujwiꞌ yuꞌwa niꞌ lyaa kanꞌ loꞌo nchga nten nu ndiꞌin nsiꞌi yuꞌwa kanꞌ. Kanꞌ mxlyuu Jesús msaa seꞌen nxaꞌan neꞌ tñi ꞌin nten, mxlyuu yu yka seꞌen ndukwa neꞌ nu ndujwiꞌ kiñi cha kuun. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","―Chkwiǐnꞌ chaꞌ nu ndukwa lo kityi ꞌin Ndiose, chaꞌ ꞌin laa re ―ndukwin Jesús bra kanꞌ―: “Seꞌen nu ka chkwiꞌ nchga nten loꞌo Ndiose lka naꞌan re, ngwañaꞌan chkwiꞌ neꞌ chaꞌ ꞌin naꞌan tyiǐn, ndukwin Ndiose.” Loꞌo ꞌwan, wa yꞌni wan chaꞌ naꞌan tyi neꞌ nu ngiꞌni kunan lka naꞌan re ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Loꞌo mdiyan chinꞌ nu kwityiinꞌ seꞌen ndiꞌin Jesús niꞌ lyaa tnun kanꞌ, kwiꞌ mdiyan nten nu tiꞌí kiyaꞌ; yꞌni Jesús chaꞌ nchkaa nu tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Naꞌan sti joꞌo nu lka ndloo chaꞌ tnun nu yꞌni Jesús bra kanꞌ; loꞌo mstru nu nduꞌu chaꞌ joꞌo kanꞌ, naꞌan neꞌ sa ñaꞌan ngwa chaꞌ nchkaa nu tiꞌí kanꞌ. Loꞌo naꞌan neꞌ kanꞌ, chaꞌ ndiꞌin tyun nu xuwe ti, nu kwen ꞌa nchkwiꞌ xa ngiꞌni tnun neꞌ ꞌin Jesús: ―¡Kuꞌni tnun ba ꞌiin! Nuꞌwin lkaa ti kwiiꞌ nu lka taꞌa ayman ree David nu ndiꞌin chaꞌ kan ―ndukwin nu xuwe kanꞌ. Msinꞌ ꞌa tiꞌ neꞌ nu lka ndloo kanꞌ bra kanꞌ, bra nu ynan neꞌ tnun nchka kanꞌ sa ñaꞌan chaꞌ nu nchkwiꞌ nu xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Bra ti ykwiꞌ neꞌ tnun nchka kanꞌ loꞌo Jesús: ―¿Ta ja nnaan chaꞌ kwiñi nu nchkwiꞌ nu xuwe ti re chaꞌ ꞌiin a? ―ndukwin neꞌ kanꞌ ꞌin Jesús. ―Wa ynaǎn ―ndukwin Jesús bra kanꞌ―. Loꞌo siꞌi chaꞌ kwiñi nchkwiꞌ nu xuwe re. ¿Ja ya chkwiꞌ wan lo kityi seꞌen ndukwa chaꞌ re a?: Ngala tuꞌwa kuwiꞌ, ngala tuꞌwa nu xuwe kuneꞌ; chañi chaꞌ ngiꞌni tnun neꞌ kanꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mdoꞌo Jesús ndyaa yu ska kichen xuwe nu naan Betania. La kanꞌ yijaꞌ yu tla bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","La xka tsan mxitukwi Jesús ndyaan kichen tlyu kanꞌ, ngiteꞌ tiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kanꞌ naꞌan yu ska yka kwiñii nu nduun tuꞌwa tuwiin. Ndyaa naꞌan yu ꞌin yka kanꞌ si kaja nan ku yu lo ran, loꞌo ja nsuꞌwi nan lo ran, xkwiꞌ lkaꞌ ti nsuꞌwi lo ran. Ykwiꞌ Jesús chaꞌ ꞌin yka bra kanꞌ: ―Ja tyoꞌo ꞌa nan lo yka kwa xka yijan ―ndukwin yu. Bra ti mtyi yka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yuwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―¿Nan lka ngwa ꞌin yka kwiñii kwa a? Mtyi ran siyaꞌ ti ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin yu―. Bra nu chañi chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose, loꞌo ja lka tukwa chaꞌ nsuꞌwi tiye wan nchkwiꞌ wan loꞌo Ni, loꞌo ꞌwan, ka ꞌwan kuꞌni wan ska chaꞌ tnun ngwañaꞌan. Siꞌi chaꞌ kityi ska yka ti chkwiꞌ wan loꞌo Ndiose bra kanꞌ, loꞌo ka chkwiꞌ wan chaꞌ re loꞌo kiꞌya kwa: “Tyoꞌo tsuuꞌ, yaa tukwaa lo tyiꞌa tujoꞌo” nchkwin wan ꞌin kiꞌya kwa. Loꞌo tyoꞌo tsuꞌ kiꞌya kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nchga lo chaꞌ nu jñan wan ꞌin Ndiose, bra nu chañi chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌin Ni, kaja chaꞌ kanꞌ ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Bra nu mdiyan neꞌ kichen tlyu kanꞌ xiyaꞌ, bra kanꞌ yten Jesús ndyaa yu niꞌ lyaa tnun kanꞌ; nduꞌu yu ꞌin nten xiyaꞌ. Loꞌo sti joꞌo nu lka ndloo, loꞌo xka ta neꞌ kula nu lka ndloo, naꞌan neꞌ ꞌin Jesús bra kanꞌ. Bra ti ndyaa neꞌ kanꞌ seꞌen ndiꞌin yu chaꞌ kunichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿Ti ka lka nu nda ra chabiyaꞌ ꞌiin chaꞌ kuꞌnii sa ñaꞌan tñan nu ngiꞌnii ni? ―ndukwin neꞌ nu lka ndloo kanꞌ ꞌin Jesús―. ¿La nde yaꞌ mjwi chabiyaꞌ kwa ꞌiin? ―ndukwin neꞌ kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","―Loꞌoǔn kunichaǎnꞌ ska chaꞌ ꞌwan sikwa, ni sa ñaꞌan xkwen wan ꞌñaǎn bra kanꞌ ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Si ka ꞌwan xkwen wan ꞌñaǎn, loꞌoǔn xkweěn ꞌwan bra kanꞌ; katsaǎnꞌ ñiǐn ꞌwan ti ka lka nu nda chabiyaꞌ ꞌñaǎn, chaꞌ kuꞌniǐn sa ñaꞌan nu ngiꞌniǐn nde re ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¡Suꞌwe sikwa! Bra nu ti ndukwatya Xuwa ꞌin nten, ¿ta chabiyaꞌ ꞌin Ndiose ngwa kanꞌ a? ¿Ta chabiyaꞌ ꞌin nten chalyuu ti ngwa kanꞌ a? Mnan ti ykwiꞌ neꞌ nu lka ndloo kanꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―¿Ni sa ñaꞌan xkwean ra ꞌin yu re? Si xkwean: “Chabiyaꞌ ꞌin Ndiose mdukwatya Xuwa kanꞌ ꞌin nten”, ja suꞌwe chaꞌ kanꞌ, chaꞌ bra ti chkwiꞌ yu chaꞌ re ꞌñaan: “¿Ni chaꞌ ja msñi wan chaꞌ nu ykwiꞌ Xuwa sikwa?” ");
INSERT INTO ctpNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Loꞌo si xkwean: “Chabiyaꞌ ꞌin nten ti mdukwatya Xuwa kanꞌ ꞌin nten”, ti kwiꞌ ti chaꞌ, ja suꞌwe chaꞌ kanꞌ, chaꞌ nchga neꞌ kichen re ndyaa ñaꞌan tiꞌ neꞌ chaꞌ chañi chaꞌ ykwiꞌ Xuwa kanꞌ xkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. Loꞌo ntsean ꞌin neꞌ kichen re. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kanꞌ chaꞌ mxkwen neꞌ kanꞌ ꞌin Jesús: ―Ja jlyo tiꞌ ba ―ndukwin neꞌ. ―Suꞌwe sikwa ―ndukwin Jesús ꞌin neꞌ―. Loꞌoǔn, ja katsaǎnꞌ ꞌwan ti ka lka nu nda chabiyaꞌ ꞌñaǎn chaꞌ kuꞌniǐn sa ñaꞌan nu ngiꞌniǐn bra ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ti ngwaꞌu la Jesús chinꞌ chaꞌ ꞌin neꞌ bra kanꞌ: ―Chkwiǐnꞌ ska chaꞌ tiya re loꞌo wan, chaꞌ xkwen wan ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ―. Wa ndiꞌin ska yu kula nu ndiꞌin tukwa yu kiꞌyu sñiꞌ yu. Kanꞌ ykwiꞌ yu kula kanꞌ loꞌo sñiꞌ yu nu kula la: “Sñiěnꞌ” ndukwin yu, “yaa kuꞌnii tñan niꞌ lyoꞌoo ꞌñaǎn ni, seꞌen ndukwa yka kwiñii ꞌñaǎn.” ");
INSERT INTO ctpNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“¡Ja tsaꞌaǎn!” ndukwin sñiꞌ yu bra kanꞌ. Chunꞌ ndiꞌin la ngwa jyuꞌu tiꞌ yu kuneꞌ chaꞌ ja mdukwa yu tñan ꞌin sti yu, kanꞌ chaꞌ mdoꞌo yu ndyaa yu tñan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Loꞌo ti kwiꞌ tñan kanꞌ ngulo sti yu ꞌin xka sñiꞌ. “Tsaꞌaǎn, ja kuwe tiiꞌ” ndukwin yu kuneꞌ la kanꞌ ꞌin sti yu, loꞌo chaꞌ kwiñi ykwiꞌ yu, chunꞌ ja yaa yu tñan ꞌin sti yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Ni sa ñaꞌan xkeꞌ tiꞌ wan ni? Taꞌa tyukwaa yu kuneꞌ kanꞌ ni, ¿ti lka ska nu yꞌni tñan nu ngulo sti ꞌin a? ―Sñiꞌ yu nu kula la, kanꞌ nu yꞌni tñan kanꞌ ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ―Chañi chaꞌ ꞌwan ―ndukwin Jesús ꞌin neꞌ―. Loꞌo chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ndiya neꞌ kuxi, ñaꞌan tiꞌ msu ꞌin neꞌ xka laꞌa tsuꞌ nu kwiñi ti ndlo kaꞌan ꞌa tñi ꞌin nten, ndiya neꞌ kanꞌ nu ndla la sten chaꞌ ꞌin Ndiose, chaꞌ ka Ni ndloo la niꞌ kasiya ꞌin neꞌ; kwiꞌ ndiya nu kunaꞌan calle ti nu ndla la sten chaꞌ ꞌin Ndiose, chaꞌ ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ. Loꞌo ꞌwan ni, tiyaꞌ la kala wan seꞌen ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Bra nu yan ayman Xuwa kanꞌ, xkwiꞌ chaꞌ nu ñi ykwiꞌ yu loꞌo wan. Ñi ꞌa yꞌni yu, loꞌo ja msñi wan kwenta chaꞌ nu ykwiꞌ yu loꞌo wan. Loꞌo neꞌ kuxi kanꞌ nu kaꞌan tñi ndlo ꞌin nten ni, wa ynan neꞌ chaꞌ nu ykwiꞌ Xuwa kanꞌ loꞌo neꞌ bra kanꞌ; kwiꞌ ngwañaꞌan nu kunaꞌan calle kanꞌ, ynan neꞌ chaꞌ nu ykwiꞌ Xuwa. Loꞌo ꞌwan, wa naꞌan wan sa ñaꞌan nu ndyaa ñaꞌan tiꞌ neꞌ nu kuxi tiye kanꞌ chaꞌ nu ngwaꞌu Xuwa, loꞌo ja ngwa jyuꞌu tiꞌ wan ꞌin kiꞌya nu ndiꞌin ꞌwan, chunꞌ chaꞌ ja msñi wan chaꞌ nu ykwiꞌ Xuwa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Nde chkwiǐnꞌ xka chaꞌ tiya loꞌo wan, ñaꞌan tiꞌ ska nkwin: Ndiya ska nu kuliyaꞌ, yta yu kaꞌan ꞌa yka kwiñii. Msuꞌwa yu ska loꞌoo chunꞌ yka kanꞌ bra kanꞌ. Loꞌo mñan yu ska tu tiyuu niꞌ kee seꞌen lyoꞌo sta neꞌ mta chi kutun, chaꞌ kulo neꞌ tyiꞌa xi nu nsuꞌwi niꞌ ran. Loꞌo mñan yu ska naꞌan seꞌen kuꞌni neꞌ kwan tñan kanꞌ bra kanꞌ. ’Loꞌo mda xꞌnan yuu kanꞌ mjñan xka ta nten bra kanꞌ, chaꞌ kuꞌni neꞌ tñan niꞌ lyoꞌoo ꞌin yu, chunꞌ nsuꞌwi ska tñan tsaa yu tijyuꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chunꞌ ndiꞌin la, wa tiya ti bra xtun neꞌ mta chi kutun kanꞌ, loꞌo tijyuꞌ ndiꞌin xꞌnan loꞌoo kanꞌ. Kanꞌ ngulo yu tñan ꞌin ska ta msu ꞌin yu chaꞌ tsaa neꞌ seꞌen ngiꞌni neꞌ tñan niꞌ lyoꞌoo ꞌin yu bra kanꞌ, chaꞌ tsaa yꞌya msu kanꞌ chinꞌ nan nu ndiꞌin chaꞌ kanun ꞌin xꞌnan loꞌoo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bra nu naꞌan neꞌ nu ngiꞌni tñan kanꞌ chaꞌ ndijyan msu kanꞌ, bra ti msñi neꞌ ꞌin msu; mjiꞌin neꞌ ꞌin ska, yjwi neꞌ ꞌin xka, mguun kee neꞌ ꞌin xka. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chunꞌ ndiꞌin la msuꞌwa xꞌnan loꞌoo ꞌin xka ta msu kaꞌan la bra kanꞌ, chaꞌ tsaa neꞌ seꞌen ngiꞌni neꞌ tñan kanꞌ. Bra nu naꞌan neꞌ chaꞌ ndijyan msu kanꞌ, kwiꞌ ngwañaꞌan yꞌni neꞌ loꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Loꞌo kanꞌ msuꞌwa xꞌnan loꞌoo kanꞌ ꞌin sñiꞌ yu, ndyaa seꞌen ngiꞌni neꞌ tñan kanꞌ. “Ja chan tukwa neꞌ kanꞌ chaꞌ nchkwiꞌ sñiěnꞌ” nka tiye xꞌnan loꞌoo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Xa wa naꞌan neꞌ kanꞌ ꞌin sñiꞌ yu, bra kanꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ: “Sñiꞌ xꞌnan loꞌoo ndijyan ni” ndukwin neꞌ ꞌin taꞌa neꞌ. “Nu kwa ka xꞌnan yka kwiñii re nde loo la, kanꞌ chaꞌ suꞌwe la si kujwian ꞌin yu, chaꞌ kanun loꞌoo re ꞌñaan” ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kanꞌ chaꞌ msñi neꞌ ꞌin sñiꞌ yu kanꞌ, ndyaa loꞌo neꞌ ꞌin sñiꞌ yu chunꞌ loꞌoo, yjwi neꞌ ꞌin sñiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’¿Nan lka kuꞌni xꞌnan loꞌoo loꞌo yu xaꞌan nu ngiꞌni tñan niꞌ lyoꞌoo ꞌin yu, bra nu tyaan yu xiyaꞌ, xkeꞌ tiꞌ wan a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","―Ndla ti kujwi xꞌnan loꞌoo kanꞌ ꞌin nchga yu xaꞌan kanꞌ ―ndukwin neꞌ ꞌin Jesús―. Loꞌo ta yu loꞌoo kanꞌ jñan xka ta nten chaꞌ kuꞌni neꞌ tñan lo yuu kanꞌ. Tsaa naan xꞌnan loꞌoo ꞌin nten suꞌwe nu xlyaa tya chinꞌ yuꞌwa ꞌin yu, liyaꞌ ꞌin yuu kanꞌ; tya neꞌ yuꞌwa nchga yijan bra nu ndiya bra xtun neꞌ mta chi kutun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ nu lka ndloo kanꞌ bra kanꞌ: ―¿Ja ya chkwiꞌ wan lo kityi ꞌin Ndiose a? Nde lka chaꞌ kanꞌ: Ti kwiꞌ kee tnun nu mxkwan nten nu mñan naꞌan ti kulo, chaꞌ ja suꞌwe kee kanꞌ, mskeꞌ tiꞌ neꞌ, wa mjwi tñan kuꞌni kee kanꞌ ni; nduun ran seꞌen nka ndloo la ꞌin naꞌan ꞌin Ndiose. Ndiose yꞌni chaꞌ ngwañaꞌan ngwa chaꞌ tnun kanꞌ, kanꞌ chaꞌ nduwe ꞌa tianꞌ. Ngwañaꞌan nchkwiꞌ kityi; ");
INSERT INTO ctpNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","kanꞌ chaꞌ katsaǎnꞌ ñi ꞌwan ni, chaꞌ ja ta ꞌa Ndiose chabiyaꞌ sten wan chaꞌ ꞌin Ni, chaꞌ ka Ni ndloo la niꞌ kasiya ꞌwan. Ta Ni chabiyaꞌ kala xka ta nten seꞌen ndiꞌin Ni, nten nu suꞌwe nka tiye chaꞌ kuꞌni tñan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Loꞌo chaꞌ ꞌin kee tnun kanꞌ ni, naꞌ lkaǎn ñaꞌan tiꞌ kee tnun kanꞌ; sa ñaꞌan nu yꞌni neꞌ nu mñan naꞌan loꞌo kee tnun kanꞌ, ngwañaꞌan ngiꞌni wan loꞌoǔn. Loꞌo nten nu nchka tiꞌ tukunꞌ chaꞌ ꞌñaǎn, ja ka suꞌwe chaꞌ ꞌin neꞌ kanꞌ bra kanꞌ; bra nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten chalyuu, ska yaꞌ ti tyii chaꞌ ꞌin nten nu ja xlyaa xñi chaꞌ ꞌñaǎn tyukwi nu yan neꞌ lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sti joꞌo nu lka ndloo loꞌo neꞌ fariseo ni, bra nu ynan neꞌ chaꞌ nu tka ykwiꞌ ti Jesús loꞌo neꞌ, mskeꞌ tiꞌ neꞌ chaꞌ ykwiꞌ kaꞌan Jesús ꞌin neꞌ bra nu ykwiꞌ yu chaꞌ ꞌin neꞌ xaꞌan nu yꞌni tñan niꞌ lyoꞌoo ꞌin xꞌnan yuu kanꞌ, kwiꞌ chaꞌ ꞌin kee nu mxkwan neꞌ nu mñan naꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lye ꞌa nka tiye neꞌ nu tnun nchka kanꞌ xñi neꞌ ꞌin Jesús, chaꞌ kujwi neꞌ ꞌin yu, ngwa tiꞌ neꞌ. Loꞌo ja ngwa ꞌin neꞌ, chaꞌ ntsen neꞌ ꞌin nten kaꞌan kanꞌ, chaꞌ kaꞌan ꞌa nten ndyaa ñaꞌan tiꞌ chaꞌ ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose lka Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Loꞌo ykwiꞌ Jesús xka chaꞌ tiya loꞌo neꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Chkwiǐnꞌ xka chaꞌ loꞌo wan chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan lka bra nu ka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús bra kanꞌ―. Ngwa ska tsan ngwa taꞌa mjwi kwilyoꞌo sñiꞌ ree. Yꞌni ree taꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ngulo ree tñan ꞌin msu ꞌin chaꞌ tsaa neꞌ, tsaa ykwiꞌ neꞌ loꞌo nchga nten nu ndiꞌin suꞌwe chaꞌ ꞌin loꞌo ree, chaꞌ wa mdiya tsan nu ka taꞌa kanꞌ; loꞌo ja mslyaa neꞌ kanꞌ kan seꞌen ndiꞌin ree tsan nu ngwa taꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Xiyaꞌ ngulo ree tñan ꞌin msu ꞌin, chaꞌ tsaa msu seꞌen ndiꞌin neꞌ kanꞌ xiyaꞌ: “Chkwiꞌ wan loꞌo nchga nten kwa, chaꞌ wa lka yꞌni xuꞌweěn skwa chaꞌ ku neꞌ; wa yjwiǐn kuta loꞌo xkeru. Wa mdiya yaꞌ ku tlya neꞌ ni, si kuꞌni neꞌ chaꞌ suꞌwe kan neꞌ taꞌa re bra ti, chaꞌ wa mjwi kwilyoꞌo sñiěnꞌ” ndukwin ree ꞌin msu ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ja yan ꞌa nten kanꞌ, chunꞌ ja yuwe ꞌa tiꞌ neꞌ chaꞌ mjwi kwilyoꞌo sñiꞌ ree kanꞌ. Ndiya neꞌ kanꞌ nu ndyaa tñan niꞌ kixinꞌ, ndiya xka ta neꞌ kanꞌ nu ndyaa yjwiꞌ yuꞌwa ꞌin neꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","loꞌo xka ta neꞌ kanꞌ ni, msñi neꞌ ꞌin msu kanꞌ, mjiꞌin neꞌ ꞌin msu kanꞌ sa ñaꞌan yaꞌ nu yjwi neꞌ ꞌin msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Xa wa ynan ree kanꞌ tñan nu yꞌni neꞌ loꞌo msu ꞌin, msinꞌ ꞌa tiꞌ ree kanꞌ ꞌin nten xaꞌan kanꞌ. Ngulo ree tñan ꞌin sndaru ꞌin chaꞌ kujwi neꞌ ꞌin nchga neꞌ xaꞌan kanꞌ bra kanꞌ, chaꞌ xkin sndaru kichen tyi neꞌ xaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Loꞌo ykwiꞌ ree loꞌo msu ꞌin xiyaꞌ: “Wa yꞌniǐn xuꞌweěn skwa chaꞌ ka taꞌa mjwi kwilyoꞌo sñiěnꞌ” ndukwin ree kanꞌ, “loꞌo nten nu wa ykwiǐnꞌ loꞌo tsan chaꞌ kan neꞌ taꞌa seꞌen ndiꞌiǐn, ja mslyaa neꞌ kan neꞌ, kanꞌ chaꞌ ja ku ꞌa neꞌ kanꞌ siyaꞌ ti skwa suꞌwe nu nsuꞌwi ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Suꞌwe la yaa lya wan nde tuwiin tlyu ni; chkwiꞌ wan loꞌo ya ñaꞌan ti nten nu ñaꞌan wan nde tuwiin kwa, chaꞌ kan neꞌ taꞌa nde seꞌen ndiꞌiǐn.” ");
INSERT INTO ctpNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kanꞌ chaꞌ mdoꞌo msu kanꞌ ndyaa neꞌ tuꞌwa tuwiin; ykwiꞌ neꞌ loꞌo nchga nten nu ndyukwa taꞌa neꞌ loꞌo, ni siya nten suꞌwe, ni siya nten kuxi. Ndyoꞌ tiꞌin nchga nten kanꞌ seꞌen ndiꞌin ree sa ñaꞌan yaꞌ nu msaꞌan naꞌan ꞌin ree bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Chunꞌ ndiꞌin la mdiyan ree kanꞌ, yten niꞌ ñaꞌan chaꞌ chkwiꞌ loꞌo nchga nten nu ndiꞌin naꞌan kanꞌ. Kanꞌ naꞌan ree chaꞌ ndiꞌin ska yu kiꞌyu nu ja lkuꞌ teꞌ suꞌwe chaꞌ taꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kwiꞌ mnichaꞌ ree ꞌin yu kiꞌyu kanꞌ bra kanꞌ: “Che” ndukwin ree, “¿ni chaꞌ yteen niꞌ ñaꞌan re ni siya ja lkuuꞌ teꞌ suꞌwe nu wa mdaǎn ꞌiin chaꞌ taꞌa?” Ja mjwi ñaꞌan xkwen yu kiꞌyu kanꞌ ꞌin ree bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","kanꞌ chaꞌ ngulo ree kanꞌ tñan ꞌin msu ꞌin: “Xñi wan ꞌin yu kiꞌyu re, skanꞌ lya wan yaꞌ yu, skanꞌ lya wan kiyaꞌ yu. Loꞌo xkwan wan ꞌin yu re lo jwlyaa seꞌen tla ꞌa, seꞌen nsiꞌya ꞌa neꞌ ndiꞌin neꞌ, seꞌen lye ꞌa nchku liꞌya neꞌ chaꞌ msinꞌ ꞌa tiꞌ neꞌ” ndukwin ree kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Loꞌo Ndiose ni, wa mnin Ni ꞌin kaꞌan ꞌa nten chaꞌ kunan suꞌwe neꞌ nchga chaꞌ nu nchkwiꞌ Ni, loꞌo wa lka ti nten nu ndlo suwi Ni chaꞌ ka neꞌ nten ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Loꞌo mdoꞌo neꞌ fariseo ndyaa neꞌ chaꞌ ka suꞌwa chaꞌ ꞌin neꞌ loꞌo taꞌa neꞌ, sa ñaꞌan nu ka kwiñi lyoꞌo neꞌ ꞌin Jesús chaꞌ chkwiꞌ yu ska chaꞌ kuxi. Ka xtya neꞌ kiꞌya ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ngulo neꞌ kanꞌ tñan ꞌin chinꞌ yu kuneꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin neꞌ fariseo bra kanꞌ, chaꞌ chkwiꞌ biyaꞌ yu kuneꞌ kanꞌ loꞌo Jesús, nka tiye neꞌ. Mdaꞌan yu kuneꞌ kanꞌ loꞌo xka ta nten nu chaꞌ ꞌin ree Herodes, ndyaa yu seꞌen ndiꞌin Jesús. ―Mstru ―ndukwin yu kuneꞌ kanꞌ ꞌin Jesús bra kanꞌ―, jlyo tiꞌ bare chaꞌ ñi ꞌa ngiꞌnii; ti kwiꞌ chaꞌ nu ñi nu nchkwiꞌ Ndiose, kanꞌ lka chaꞌ nu nduꞌuu ꞌin nten. Loꞌo ja nduwe tiiꞌ sa ñaꞌan nnen chaꞌ nu nchkwiꞌ nten ꞌiin; ska ti biyaꞌ ngiꞌnii loꞌo nchga nten, ni siya neꞌ tiꞌi, ni siya neꞌ nu tnun nchka. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa, katsaaꞌ ñi ꞌwa: Tñi nu ndlo ree tlyu nu ndiꞌin xka laꞌa tsuꞌ kanꞌ ni, ¿ta suꞌwe si taan tñi kanꞌ ꞌin yu a? ");
INSERT INTO ctpNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ngwa biyaꞌ tiꞌ Jesús sa ñaꞌan chaꞌ kuxi ndaꞌan tiye neꞌ kanꞌ, kanꞌ chaꞌ mxkwen yu ꞌin neꞌ: ―Kwiñi ꞌa wan ni. ¿Ni chaꞌ lka nchkwiꞌ biyaꞌ wan loꞌoǔn a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kwaꞌu wan ska tñi ꞌñaǎn, ti kwiꞌ taꞌa tñi plata nu ndaan ꞌin neꞌ nu ndlo tñi kanꞌ. Bra kanꞌ mdiyan loꞌo neꞌ ska tñi plata kanꞌ seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","―¿Ti lka nkwin ngaꞌan chunꞌ tñi re? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿Ti lka ra nu ndukwa nin re? ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","―Nin ree tlyu nu ndiꞌin xka laꞌa tsuꞌ, kanꞌ ngaꞌan chunꞌ tñi kwa ―ndukwin neꞌ bra kanꞌ. ―Suꞌwe ―ndukwin Jesús bra kanꞌ―, ta wan tñi nu ndiꞌin chaꞌ ta wan ꞌin ree tlyu kanꞌ sikwa; kwiꞌ ngwañaꞌan, ta wan ꞌin Ndiose nchga nan nu ndiꞌin chaꞌ ta wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Yuwe ꞌa tiꞌ neꞌ kanꞌ bra kanꞌ, chaꞌ nchka ꞌa ꞌin Jesús nchkwen ꞌin neꞌ. Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ti kwiꞌ tsan kanꞌ mdiyan chinꞌ neꞌ saduceo seꞌen ndiꞌin Jesús, kanꞌ lka ska ta nten nu nchkwiꞌ chaꞌ ja tyuꞌu ꞌa nten xiyaꞌ xa wa ngujwi neꞌ. Mnichaꞌ neꞌ kanꞌ chaꞌ re ꞌin Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Mstru ―ndukwin neꞌ kanꞌ ꞌin yu―, nu ngwa sꞌni ytsaꞌ ayman Moisés ska chaꞌ ꞌñaan chaꞌ ꞌin taꞌa ngula neꞌ. Bra wa ngujwi ska yu kiꞌyu, si wa mjwi kwilyoꞌo yu loꞌo ti ji tyiꞌin sñiꞌ yu, bra kanꞌ ndiya tñan ꞌin taꞌa ngula yu nu ndiꞌin ska ti, chaꞌ kaja kwilyoꞌo yu loꞌo nu kunaꞌan nu ngwa kwilyoꞌo ayman taꞌa yu. Loꞌo chkwiꞌ neꞌ ꞌin sñiꞌ nu kala kulo chaꞌ sñiꞌ yu kiꞌyu nu wa ngujwi kanꞌ lka kuwiꞌ kanꞌ, chaꞌ ja kanaꞌ nin yu nu wa ngujwi kanꞌ bra kanꞌ. Ngwañaꞌan ykwiꞌ Moisés nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Loꞌo ni, chkwiꞌ ba sa ñaꞌan ngwa ska yaꞌ: Taꞌa kichen tyi ba wa mdiꞌin kati yu kiꞌyu taꞌa ngula. Loꞌo mjwi kwilyoꞌo nu ngula kulo kanꞌ, ndla ꞌa ngujwi yu bra kanꞌ, loꞌo ja ya xuꞌwi sñiꞌ yu loꞌo kwilyoꞌo yu. Kanꞌ nganun nu kunaꞌan kanꞌ kwenta ꞌin taꞌa ngula yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kanꞌ mjwi kwilyoꞌo nu kunaꞌan kanꞌ xiyaꞌ. Kwiꞌ ngwañaꞌan, ndla ti ngujwi xka yu kiꞌyu taꞌa ngula ayman kanꞌ. Kwiꞌ ngwañaꞌan ngwa ꞌin taꞌa kati yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Bra wa mdyii chaꞌ, ngujwi nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Loꞌo ni, bra nu tyuꞌu nchga ayman xiyaꞌ, ¿ti ka nu ka kwilyoꞌo nu kunaꞌan kanꞌ?, chaꞌ taꞌa kati taꞌa ngula neꞌ mjwi kwilyoꞌo neꞌ loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Ja ska chaꞌ jlyo tiꞌ wan, ja ya ka biyaꞌ tiꞌ wan chaꞌ nu nchkwiꞌ kityi ꞌin Ndiose; ja nchka biyaꞌ tiꞌ wan chaꞌ nchka ꞌa ꞌin Ndiose kuꞌni Ni nchga chaꞌ tnun nu nchka tiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bra nu tyuꞌu nchga ayman xiyaꞌ, ja ndiꞌin chaꞌ kaja kwilyoꞌo neꞌ bra kanꞌ; tyiꞌin neꞌ sa ñaꞌan ndiꞌin angajle seꞌen ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chañi chaꞌ ndiꞌin chaꞌ tyuꞌu nchga ayman xiyaꞌ. ¿Ja ya chkwiꞌ wan lo kityi seꞌen nchkwiꞌ Ndiose loꞌo wan a? Nde ndiya chaꞌ nu nchkwiꞌ kityi kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ndiose nu lka Xꞌnan Abraham lkaǎn” ndukwin Ni, “Ndiose nu lka Xꞌnan Isaac lkaǎn, loꞌo ti kwiꞌ Ndiose nu lka Xꞌnan Jacob lkaǎn” ndukwin Ni. Ja ndukwin kityi chaꞌ wa ngwa Ndiose Xꞌnan neꞌ kanꞌ bra nu mdiꞌin ti jyoꞌo kanꞌ lo chalyuu; ti nka Ndiose Xꞌnan neꞌ kanꞌ ni, kwiꞌ ngwañaꞌan ti nka Ndiose Xꞌnan nchga nten nu luꞌu. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Bra wa ynan nten kaꞌan nu ndiꞌin nde kwa chaꞌ nu nduꞌu Jesús, yuwe ꞌa tiꞌ neꞌ ꞌin chaꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Xa wa ynan neꞌ fariseo chaꞌ ja ngwa ꞌin neꞌ saduceo kanꞌ kwiñilyoꞌo ꞌin Jesús, bra ti ndyoꞌ tiꞌin nchga neꞌ fariseo kanꞌ seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Loꞌo ndiꞌin ska neꞌ fariseo nu jlyo ꞌa tiꞌ nchga chaꞌ ꞌin Ndiose nu ngwaꞌan ayman Moisés. Mnichaꞌ yu ꞌin Jesús chaꞌ chkwiꞌ biyaꞌ yu loꞌo bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Mstru ―ndukwin yu kanꞌ ꞌin Jesús―, ¿ni sa ñaꞌan lka chaꞌ nu ndloo la ꞌñaan chaꞌ kuꞌnian, chaꞌ nu ykwiꞌ Ndiose loꞌo ayman Moisés nu ngwa sꞌni? ");
INSERT INTO ctpNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Mxkwen Jesús ꞌin yu kanꞌ bra kanꞌ: ―“Ndiꞌin chaꞌ tyukwi ti tiye wan tyiꞌin chaꞌ ꞌwan loꞌo Ndiose nu lka Xꞌnan wan; ndiꞌin chaꞌ ka luwi kasiya ꞌwan, kwiꞌ tyiꞌin chaꞌ ꞌwan loꞌo Ni loꞌo nchga chaꞌ tiya nu ndiꞌin ke wan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kanꞌ lka chaꞌ nu ndloo la ꞌñaan loꞌo Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Loꞌo ndiya xka chaꞌ nu ndloo ꞌa ꞌñaan: “Ndiꞌin chaꞌ chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan, sa ñaꞌan lka bra nu nchka tꞌnan tiꞌ wan ꞌwan, ti ykwiꞌ ti wan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tyukwaa chaꞌ re lka suun nchga chaꞌ nu ngwaꞌan ayman Moisés chabiyaꞌ ꞌin Ndiose, nchga chaꞌ re lka suun nchga chaꞌ ꞌin Ndiose nu ykwiꞌ neꞌ loꞌo nten nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Bra nu ti ndyoꞌ tiꞌin nchga neꞌ fariseo kanꞌ seꞌen ndiꞌin Jesús, mnichaꞌ yu ska chaꞌ ꞌin neꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Ni sa ñaꞌan nxkeꞌ tiꞌ wan chaꞌ ꞌin Krixtu nu ndiꞌin chaꞌ kan? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿Ti lka nu ngwa ayman ꞌin Krixtu, nxkeꞌ tiꞌ wan a? ―Nten taꞌa ayman ree David ka nu kanꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mnichaꞌ Jesús ꞌin neꞌ kanꞌ xiyaꞌ bra kanꞌ: ―¿Ni sa ñaꞌan lka chaꞌ re, xkeꞌ tiꞌ wan a?, chaꞌ nu wa ykwiꞌ ayman David chaꞌ Xꞌnan yu lka Krixtu kanꞌ. Wa ngwaꞌu Tyiꞌi Ndiose chaꞌ kanꞌ ꞌin David, kanꞌ chaꞌ mjlyo tiꞌ ree kanꞌ. Nde lka chaꞌ nu ykwiꞌ ree kanꞌ ―ndukwin Jesús: ");
INSERT INTO ctpNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ndiose nu nka Xꞌnaan ykwiꞌ chaꞌ re loꞌo Krixtu nu nka Xꞌnaǎn: “Tyukwaa chinꞌ nde laꞌa seꞌen kwin ꞌñaǎn, sa ñaꞌan yaꞌ nu kuꞌni tyiǐn chaꞌ ꞌin nchga nu tiꞌí tiꞌ ꞌiin, chaꞌ nuꞌwin kaa ndloo ꞌin nchga lo chaꞌ” ndukwin Ni ꞌin Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Xꞌnaǎn, ykwiꞌ ayman David ꞌin Krixtu. ¿Ta sa kanꞌ ti nten taꞌa ayman David ka Krixtu, xkeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ja tukwin ngwa jlyo tiꞌ xkwen la ꞌin Jesús bra kanꞌ. Chunꞌ ndiꞌin la, ja mnichaꞌ ꞌa neꞌ ꞌin yu, chaꞌ ntsen neꞌ ꞌin yu, sa ñaꞌan nu xkwen Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Loꞌo ykwiꞌ Jesús loꞌo nten kaꞌan nu ndiꞌin seꞌen ndiꞌin yu, loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Neꞌ fariseo kanꞌ, loꞌo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa, jlyo tiꞌ neꞌ kanꞌ nchga chaꞌ nu ngwaꞌan ayman Moisés lo kityi. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kanꞌ chaꞌ ndiꞌin chaꞌ kunan suꞌwe wan chaꞌ nu nduꞌu neꞌ kanꞌ ꞌwan, ndiꞌin chaꞌ tukwa wan nchga chaꞌ nu ndukwa lo kityi nu nduꞌu neꞌ kanꞌ; ska ti chaꞌ, ja kuꞌni wan sa ñaꞌan nu ngiꞌni neꞌ kanꞌ, chunꞌ ja la ndukwa neꞌ chaꞌ kanꞌ ni siya suꞌwe ꞌa nduꞌu neꞌ chaꞌ joꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Loꞌo neꞌ fariseo kanꞌ, ndlo neꞌ tñan ꞌin taꞌa nten neꞌ chaꞌ tnun ꞌa yuꞌwa kwiꞌya neꞌ. Tiꞌin ꞌa yuꞌwa nxtya neꞌ fariseo kanꞌ skun nten, loꞌo ja ndlyaꞌ neꞌ yuꞌwa kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nchga chaꞌ nu ngiꞌni neꞌ kanꞌ, ngiꞌni neꞌ ꞌin ran chaꞌ ñaꞌan nten ꞌin neꞌ; kanꞌ chaꞌ nskanꞌ neꞌ kanꞌ kityi chaꞌ ꞌin Ndiose ke neꞌ, kwiꞌ skun neꞌ, chaꞌ nchka tiꞌ neꞌ chaꞌ chkwiꞌ nten chaꞌ ꞌin neꞌ chaꞌ kti ꞌa ngiꞌni neꞌ. Kwiꞌ nxiin neꞌ kanꞌ piyun nu tnun ꞌa su, chaꞌ ñaꞌan nten ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Bra nu ndaꞌan neꞌ kanꞌ ska taꞌa, xkwiꞌ nan nchka tiꞌ neꞌ tyukwa neꞌ seꞌen suꞌwe la ñaꞌan. Loꞌo niꞌ lyaa, ti kwiꞌ ti chaꞌ, nchka tiꞌ neꞌ kanꞌ tyukwa neꞌ seꞌen nu suꞌwe la ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kwiꞌ ngwañaꞌan, bra nu tyukwa taꞌa nten loꞌo neꞌ kanꞌ tuwiin, ndiya tiꞌ neꞌ fariseo chaꞌ suꞌwe ti chkwiꞌ nten loꞌo neꞌ, chaꞌ kuꞌni tnun nten ꞌin neꞌ; nchka tiꞌ neꞌ chaꞌ chkwiꞌ nten chaꞌ ꞌin neꞌ, chaꞌ mstru lka neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’ꞌWan ni, ja suꞌwe si chkwiꞌ nten ꞌwan chaꞌ mstru lka wan; suꞌwe la si ska ti chaꞌ nka tiye wan loꞌo taꞌa nten wan, chaꞌ ska ti mstru nsuꞌwi ꞌwan, kanꞌ lka Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kwiꞌ ngwañaꞌan, ja ndiꞌin chaꞌ chkwiꞌ wan chaꞌ sti wan lka ska nten chalyuu ti, chaꞌ ska ti Ndiose nu ndiꞌin nde niꞌ kwan, kanꞌ lka Sti wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Loꞌo ja ta wan chabiyaꞌ ꞌin nten chaꞌ chkwiꞌ neꞌ chaꞌ ꞌwan chaꞌ xꞌnan neꞌ nka wan, chaꞌ ska ti Krixtu nka Xꞌnan wan nu chañi. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndiꞌin chaꞌ kuꞌni wan ñaꞌaan tñan nu kulo taꞌa nten wan ꞌwan, si chañi chaꞌ ndloo la chaꞌ ꞌwan ke taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nten nu nchka tiꞌ chaꞌ ka tnun la, ti ykwiꞌ ti, ke taꞌa nten, ndiꞌin chaꞌ ka jyuꞌu tiꞌ neꞌ nde loo la; loꞌo nten nu ja siyeꞌ loꞌo taꞌa nten, nu ja nchka tiꞌ tyijin lyo ꞌin taꞌa nten, kanꞌ lka nu chañi chaꞌ ka tnun la chaꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ ndaꞌan tiye wan! Nan ndukunꞌ ti wan tuwiin ꞌin nten, chaꞌ ja ka sten neꞌ chaꞌ ꞌin Ndiose, chaꞌ ja ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ. ꞌWan ti ykwiꞌ ti wan, ja xlyaa wan sten wan chaꞌ kanꞌ, loꞌo ja nda wan chabiyaꞌ chaꞌ sten xka la nten chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ngwañaꞌan ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ ndaꞌan tiye wan! Ndlaa wan naꞌan tyi nu kunaꞌan tiꞌi, loꞌo chan nchkwiꞌ wan loꞌo Ndiose seꞌen ndiꞌin nten chaꞌ ñaꞌan nten ꞌwan bra kanꞌ. Ja ka biyaꞌ tiꞌ xka la nten ñaꞌaan chaꞌ kuxi nu nsuꞌwi niꞌ kasiya ꞌwan bra kanꞌ, nxkeꞌ tiꞌ wan. Kanꞌ chaꞌ lye ꞌa ta Ndiose nu tiꞌí ꞌwan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ nka tiye wan! Tijyuꞌ ꞌa ndaꞌan wan tuwiin nde xka chalyuu, kwiꞌ tuwiin ndijin wan tujoꞌo, chaꞌ tsaa naan wan ꞌin nten; tsaa naan wan ni siya ska ti nten nu xlyaa kulaa yaꞌ ꞌin xka la joꞌo nu ngiꞌni tnun yu ꞌin, chaꞌ xñi yu chaꞌ nu kwaꞌu wan ꞌin yu. Loꞌo chaꞌ nu kwaꞌu wan ꞌin yu kuꞌni wan chaꞌ lye la ka yu sñiꞌ kuneꞌ xaꞌan ke ꞌwan, ꞌwan nu ndiꞌin chaꞌ tsaa wan lo jwlyaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Tꞌnan ꞌa ꞌwan! Nan wa nchka tiꞌ wan kwaꞌu wan ꞌin xka la nten, loꞌo kwityiinꞌ ꞌa wan, chaꞌ ja la ndiꞌya wan kwenta. Ndiya yaꞌ nchkwiꞌ wan: “Bra nu skanꞌ nten ska chaꞌ ꞌin neꞌ loꞌo kulo naan neꞌ ꞌin laa tnun re, chaꞌ kuꞌni ji neꞌ ska tñan, ja ska chaꞌ lka ran” nchkwiꞌ wan. “Loꞌo bra nu skanꞌ neꞌ ska chaꞌ loꞌo taꞌa nten neꞌ, loꞌo kulo naan neꞌ ꞌin nan oro nu nsuꞌwi niꞌ lyaa chaꞌ kuꞌni neꞌ tñan kanꞌ, kanꞌ ndiꞌin chaꞌ kuꞌni ji neꞌ nchga tñan nu ykwiꞌ neꞌ” ndukwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Mnaꞌ chaꞌ tiya ꞌwan, kwityiinꞌ ꞌa wan! ¿Ni nan lka nu ndloo la chaꞌ ꞌin, nxkeꞌ tiꞌ wan? ¿Ta tlyu la chaꞌ ꞌin nan oro nu nsuꞌwi niꞌ lyaa kanꞌ a? ¿O ta tlyu la chaꞌ ꞌin laa tnun seꞌen nsuꞌwi nan oro kanꞌ, nxkeꞌ tiꞌ wan a? Ska ñaꞌan ti lka tyukwaa chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Loꞌo ndiya yaꞌ nchkwiꞌ wan xka chaꞌ re: “Bra nu skanꞌ nten ska chaꞌ loꞌo taꞌa nten neꞌ, loꞌo kulo naan neꞌ ꞌin msaa nu nduun niꞌ lyaa re, chaꞌ kuꞌni ji neꞌ ska tñan, ja ska chaꞌ lka ran” ndukwin wan. “Loꞌo bra nu skanꞌ neꞌ chaꞌ loꞌo taꞌa nten neꞌ, loꞌo kulo naan neꞌ ꞌin lomstan nu nxtya neꞌ lo msaa kanꞌ, chaꞌ kuꞌni neꞌ ska tñan, kanꞌ ndiꞌin chaꞌ kuꞌni ji neꞌ nchga tñan kanꞌ” ndukwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Chañi chaꞌ kwityiinꞌ wan! ¿Ni nan lka nu ndloo la chaꞌ ꞌin, nxkeꞌ tiꞌ wan? ¿Ta tlyu la chaꞌ ꞌin lomstan kanꞌ a? ¿O ta tlyu la chaꞌ ꞌin msaa seꞌen ndukwa lomstan kanꞌ, nxkeꞌ tiꞌ wan a? Ska ñaꞌan ti lka tyukwaa chaꞌ kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","kanꞌ chaꞌ bra nu skanꞌ neꞌ ska chaꞌ chabiyaꞌ ꞌin msaa kanꞌ, suꞌwa nskanꞌ neꞌ chaꞌ chabiyaꞌ ꞌin nan nu ndukwa lo msaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ti kwiꞌ ti chaꞌ, bra nu skanꞌ neꞌ ska chaꞌ chabiyaꞌ ꞌin laa tnun re, suꞌwa nskanꞌ neꞌ chaꞌ chabiyaꞌ ꞌin Ndiose, chaꞌ loꞌo niꞌ lyaa kanꞌ ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bra nu skanꞌ neꞌ ska chaꞌ chabiyaꞌ ꞌin ska nan nu ndiꞌin nde niꞌ kwan, suꞌwa nskanꞌ neꞌ chaꞌ kanꞌ chabiyaꞌ ꞌin seꞌen tlyu seꞌen ndiꞌin Ndiose, ti kwiꞌ chabiyaꞌ ꞌin Ndiose lka chaꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ nsuꞌwi tiye wan! Kti ꞌa ngiꞌni wan tloo Ndiose loꞌo nchga nan xuwe ti nu nsuꞌwi ꞌwan; bra nu nsuꞌwi tii lkaꞌ kanunꞌ xlya ꞌwan ni, bra ti nda wan ska ꞌin Ndiose bra kanꞌ, ta nxin, ta mta komino, kwiꞌ ngwañaꞌan ngiꞌni wan. Loꞌo chaꞌ nu ngwaꞌu Stian Ndiose, nu ndloo la ꞌwan chaꞌ kuꞌni wan, ja la nduwe tiꞌ wan chaꞌ kanꞌ. Wa ykwiꞌ Ndiose chaꞌ kuꞌni biyaꞌ ñi wan ꞌin nten, chaꞌ chka tꞌnan tiꞌ wan ꞌin nten, chaꞌ tsaa ñaꞌan suꞌwe tiꞌ wan ꞌin Ni; loꞌo ja nnan wan chaꞌ kanꞌ. Ndiꞌin chaꞌ tukwa wan chaꞌ nu ndloo la kanꞌ, ni siya ti kuꞌni wan chaꞌ suꞌwe sa ñaꞌan nu ngiꞌni ti wan bra nu nda wan lomstan xuwe ti kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nchka tiꞌ wan kwaꞌu wan chaꞌ ꞌin Ndiose ꞌin xka la nten; loꞌo kwityiinꞌ wan, chaꞌ nchkunꞌ ke wan ꞌin nchga chaꞌ nu ñi kanꞌ. Sa ñaꞌan lka si nsuwi wan tyiꞌa chaꞌ koꞌo wan, chaꞌ ja koꞌo wan ꞌni xuwe nu nsuꞌwi lo tyiꞌa kanꞌ, loꞌo ja ngiꞌni wan kwenta ni siya wa yiꞌo wan ska ꞌni tnun, ñaꞌan tiꞌ ska camello ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ nsuꞌwi tiye wan! Suꞌwe ꞌa njyaꞌan wan tloo wan, njyaꞌan wan chunꞌ wan, ñaꞌan tiꞌ ngaten ska sa, ngaten ska kaꞌnan; loꞌo niꞌ kasiya ꞌwan xkwiꞌ chaꞌ kuxi nsuꞌwi, chaꞌ nchka tiꞌ wan kulaa wan nan nu nsuꞌwi ꞌin xka la nten, chaꞌ nxitukwi tiꞌ wan nan nsuꞌwi ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Nan kwityiinꞌ wan, ꞌwan neꞌ fariseo! Kulo kuꞌni luwi wan niꞌ kasiya ꞌwan, ti ykwiꞌ ti wan, chaꞌ kanun luwi tyukwi ñaꞌaan wan bra kanꞌ, ñaꞌan tiꞌ ska sa, ska kaꞌnan nu wa ngaten ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ngwañaꞌan ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ nka tiye wan! Ñaꞌan tiꞌ ska kwaa nu ngwa tkanꞌ chaꞌ yꞌni ngaten neꞌ ꞌin ran, chaꞌ ka suꞌwe ꞌa ñaꞌan kwaa kanꞌ bra kanꞌ, ngwañaꞌan lka wan. Xkwiꞌ tijyan ayman nsuꞌwi niꞌ kwaa kanꞌ, xkwiꞌ nan tukun tyiꞌi nsuꞌwi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kwiꞌ ngwañaꞌan ꞌwan ni, suꞌwe ꞌa ñaꞌan chunꞌ wan, ñi ꞌa ngiꞌni wan, nxkeꞌ tiꞌ nten; loꞌo bra nu ñaꞌan Ndiose niꞌ wan, tukwa chaꞌ nka tiye wan, kuxi ꞌa chaꞌ nu nsuꞌwi niꞌ kasiya ꞌwan, nxkeꞌ tiꞌ Ndiose bra kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Tꞌnan ꞌa ꞌwan mstru nu nduꞌu chaꞌ joꞌo, loꞌo ꞌwan neꞌ fariseo, chaꞌ tukwa chaꞌ nka tiye wan! Suꞌwe ꞌa ñaꞌan naꞌan xuwe nu nñan wan chunꞌ kwaa seꞌen mtsiꞌ ayman nu wa yan ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, loꞌo suꞌwe ꞌa ngiꞌni tkanꞌ wan kwaa seꞌen mtsiꞌ ayman nu suꞌwe tiye nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Kuxi ꞌa yꞌni ayman ꞌwa nu ngwa sꞌni” ndukwin wan. “Si wa ndiꞌin ba lo chalyuu nu ngwa bra kanꞌ, ja loꞌo ba kujwi ba ꞌin neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten kanꞌ” ndukwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jlyo tiꞌ wan chaꞌ lka wan ti kwiꞌ taꞌa nten loꞌo ayman ꞌwan nu wa yjwi ꞌin neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; loꞌo ti kuxi tiye wan ni, sa ñaꞌan nu kuxi tiye ayman ꞌwan nu ngwa sꞌni bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Suꞌwe sikwa! ¡Ti kuꞌni la wan chaꞌ kuxi nu yꞌni ayman ꞌwan nu ngwa sꞌni! ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ñaꞌan tiꞌ kunan, ngwañaꞌan nchka tiꞌ wan! Sa ꞌa ngiꞌni wan chaꞌ kuxi. ¿Ta nxkeꞌ tiꞌ wan chaꞌ kulaa Ndiose ꞌwan, chaꞌ ja kaja nu tiꞌí ꞌwan lo jwlyaa a? Ja ka ꞌwan ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kanꞌ chaꞌ ti suꞌwaǎn ꞌin nten ꞌñaǎn chaꞌ tsaa seꞌen ndiꞌin wan, nten nu nchkwiꞌ chaꞌ ꞌñaǎn, nten nu jlyo tiꞌ chaꞌ ꞌñaǎn, loꞌo mstru nu kuꞌni tñan ꞌñaǎn. Jlyo tiǎnꞌ chaꞌ xaꞌan ꞌa wan; kujwi wan ꞌin chinꞌ nten kanꞌ, jwiꞌin kaꞌan wan ꞌin chinꞌ neꞌ kanꞌ lo wsi, xka ta neꞌ kanꞌ jwiꞌin wan loꞌo ti su niꞌ lyaa ꞌwan. Kuxi ꞌa kuꞌni wan loꞌo neꞌ kanꞌ, sa ñaꞌan yaꞌ nu kulo wan ꞌin neꞌ kanꞌ, chaꞌ ja la kanun neꞌ kichen tyi wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kanꞌ chaꞌ sikwa, kanun kiꞌya ꞌwan siꞌya ayman ꞌwan nu wa yjwi ꞌin kaꞌan ꞌa nten nu ykwiꞌ chaꞌ nu ñi nu ngwa ti sꞌni, ti bra nu ngujwi Abel ti kulo la, sa ñaꞌan yaꞌ nu ngujwi Zacarías sñiꞌ Berequías. Ayman Zacarías ni, wa yjwi neꞌ ꞌin yu seꞌen nduun yu niꞌ lyaa, tuꞌwa msaa seꞌen nchkin lomstan, bra nu wa tsaa ti yu niꞌ ñaꞌan seꞌen kti ꞌa chaꞌ ꞌin Ndiose. Suꞌwa lka chaꞌ sa ñaꞌan lka si wa yjwi wan ꞌin ayman kanꞌ, chunꞌ ti kwiꞌ ti chaꞌ kuxi kanꞌ nka tiye wan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ja ya kaja wan xa nu tlyu ꞌa chaꞌ kuxi ka ꞌwan, neꞌ nasiyun re, siꞌya kiꞌya tnun nu ndukwi wan ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Tꞌnan ꞌa wan neꞌ Jerusalén! ¡Tukwi ꞌa chaꞌ nsuꞌwi ꞌwan! Ti sꞌni ꞌa ndujwi wan ꞌin nten nu ndyaꞌan tñan ꞌin Ndiose, njyiꞌin wan kee ꞌin neꞌ nu nchkwiꞌ chaꞌ ꞌin Ni. Tyun ꞌa yaꞌ ngwa tiǎnꞌ ñaꞌansiǐn ꞌwan chaꞌ ja ka kuxi ꞌwan. Ñaꞌan tiꞌ ska kwitu nu nxoꞌ tiꞌin ꞌin sñiꞌ niꞌ jluꞌwe, ngwañaꞌan ngwa tiǎnꞌ kuꞌniǐn loꞌo wan; loꞌo ja la nda wan chabiyaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kanꞌ chaꞌ xiꞌin ꞌa kanun kichen tyi wan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ja ñaꞌan ꞌa wan ꞌñaǎn sa ñaꞌan yaꞌ nu chkwiꞌ wan chaꞌ re ꞌñaǎn: “Suꞌwe ꞌa ngiꞌni Ndiose loꞌo nten nu ndijyan chabiyaꞌ ꞌin ti kwiꞌ Ni nu nka Xꞌnaan” nchkwin wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Chunꞌ ndiꞌin la mdoꞌo Jesús chunꞌ laa tnun kanꞌ; wa tyaa ti yu, lye ꞌa ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu chaꞌ ꞌin laa tnun kanꞌ, chaꞌ suꞌwe ꞌa ñaꞌan nchga naꞌan nu kwenta ꞌin laa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Ñaꞌan suꞌwe wan nchga chaꞌ nu nsuꞌwi laa tnun re ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ tyii laa re katin ran loꞌo ja ska ꞌa kee nu nsuꞌwi siꞌ laa re kanun ran chunꞌ taꞌa ran. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Loꞌo kanꞌ ndyaa neꞌ lo kiꞌya nu naan Olivos bra kanꞌ. Nde kwa ndyaa tukwa Jesús. Mnan ti ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu bra kanꞌ, mnichaꞌ neꞌ ꞌin yu: ―Katsaaꞌ ꞌwa, ¿ni ñaꞌan bra ka chaꞌ kuxi kanꞌ ꞌin laa tnun re? Kwiꞌ ngwañaꞌan, ¿ni sa ñaꞌan ka chaꞌ bra nu tyaan xiyaꞌ, xa nu tyii chalyuu? ―ndukwin neꞌ kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ti ngwaꞌu la Jesús ꞌin neꞌ bra kanꞌ: ―Ndii ti tiꞌ wan tyiꞌin wan, kiꞌya wan kwenta chaꞌ ja tukwin kwiñi lyoꞌo ꞌwan ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Nde loo la kan tyun nten kwiñi nu chkwiꞌ chaꞌ chabiyaꞌ ꞌñaǎn ndijyan neꞌ. “Krixtu lkaǎn” nchkwin neꞌ kanꞌ ꞌwan, chaꞌ kwiñi lyoꞌo neꞌ ꞌin kaꞌan ꞌa nten nu tsaa ñaꞌan tiꞌ chaꞌ nu chkwiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kanꞌ kanen chaꞌ nxuun neꞌ nasiyun re loꞌo neꞌ xka nasiyun, kwiꞌ ngwañaꞌan kaja chaꞌ ꞌwan chaꞌ nxuun neꞌ nasiyun tijyuꞌ. Ja kutsen wan bra kanꞌ. Ndiꞌin chaꞌ ka ngwañaꞌan, xa nu ti ji tyii chalyuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Xuun taꞌa nten re loꞌo neꞌ xka laꞌa tsuꞌ, kwiꞌ ngwañaꞌan xuun taꞌa nten ska kichen tnun loꞌo neꞌ xka kichen tnun. Kanꞌ ka jwiꞌñan ꞌin neꞌ, kan kicha nu xñi ꞌin nchga nten, kwiꞌ lye ꞌa kiñan chalyuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nchga chaꞌ kanꞌ ka bra nu tyisnan ti ta Ndiose nu tiꞌí ꞌin nten chalyuu, siꞌi chaꞌ wa mdyii chalyuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Bra nu tyisnan chaꞌ kuxi kanꞌ ni, xñi neꞌ ꞌwan chaꞌ ta neꞌ nu tiꞌí ꞌwan; chka tiꞌ neꞌ kujwi neꞌ ꞌwan, chaꞌ ndiya neꞌ ñaꞌaan chalyuu nu ka tiꞌí tiꞌ ꞌwan chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kanꞌ chaꞌ tyun neꞌ taꞌa wan ka ndaja tiꞌ neꞌ loꞌoǔn, ja talo ꞌa neꞌ chaꞌ ndyaa ñaꞌan tiꞌ neꞌ chaꞌ ꞌñaǎn bra kanꞌ. Kwiꞌ ngwañaꞌan, ndiya neꞌ taꞌa wan nu kujwiꞌ xuꞌwa neꞌ ꞌin taꞌa wan yaꞌ neꞌ xaꞌan, kwiꞌ ndiya nu ka tiꞌí tiꞌ ꞌin taꞌa wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kwiꞌ ngwañaꞌan, tyoꞌo tukwa kaꞌan neꞌ kwiñi, nu chkwiꞌ chaꞌ ꞌin Ndiose, nchkwin neꞌ. Kwiñi lyoꞌo neꞌ kanꞌ ꞌin tyun neꞌ taꞌa wan, nu lka wan nten ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kaꞌan ꞌa chaꞌ kuxi ka, nu kuꞌni chaꞌ ja chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Loꞌo ja kuwe tiꞌ wan, nchga wan nu talo wan chan ꞌin chaꞌ kuxi kanꞌ, kulaǎn ꞌwan bra kanꞌ, xa nu wa tyii chalyuu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ndiꞌin chaꞌ kwaꞌu wan chaꞌ ꞌñaǎn ꞌin nten, nchga chaꞌ suꞌwe nu nchkwiǐnꞌ, sa ñaꞌan ka bra nu lka Ndiose ndloo niꞌ kasiya ꞌin nten; ndiꞌin chaꞌ chkwiꞌ wan chaꞌ kanꞌ loꞌo nten ñaꞌaan chalyuu, chaꞌ ka biyaꞌ tiꞌ neꞌ nchga nasiyun chaꞌ kanꞌ. Kanꞌ tyii chalyuu bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ayman Daniel nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ti sꞌni, wa ykwiꞌ yu chaꞌ ꞌin ska nkwin nu kuxi ꞌa, ska nan nu kuꞌni ñuꞌun ꞌin nchga nan nu luwi. ―Ka biyaꞌ tiꞌ wan chaꞌ kanꞌ, bra nu chkwiꞌ wan lo kityi re―. Bra nu ñaꞌan wan chaꞌ nduun nkwin nu kuxi kanꞌ nde seꞌen kti ꞌa niꞌ lyaa tnun kanꞌ ―ndukwin Jesús―, ");
INSERT INTO ctpNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ka biyaꞌ tiꞌ wan bra kanꞌ chaꞌ suꞌwe la si xnan nchga wan nu ndiꞌin lo yuu ꞌin Judea re, xnan lya wan chaꞌ xuꞌwi kutsiꞌ wan lo kiꞌya. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nten nu nduun ke naꞌan ꞌin neꞌ tsan kanꞌ, ja laa ꞌa neꞌ sten neꞌ niꞌ ñaꞌan chaꞌ kulo neꞌ suꞌwa neꞌ; ndiꞌin chaꞌ kiꞌya neꞌ kanꞌ lyuu ndla, chaꞌ xnan neꞌ bra ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kwiꞌ ngwañaꞌan nten nu ndiꞌin niꞌ kixinꞌ ni, ja laa ꞌa neꞌ xitukwi neꞌ tyaan neꞌ naꞌan tyi neꞌ, chaꞌ tyaan yꞌya neꞌ teꞌ kichanꞌ ꞌin neꞌ; ndiꞌin chaꞌ xnan neꞌ ndla bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Tꞌnan ꞌa nu kunaꞌan tnan bra nu tiya tsan kanꞌ! ¡Tꞌnan ꞌa nu kunaꞌan nu nsuꞌwi kuwiꞌ kuneꞌ nu ti ngatiꞌ ꞌin bra kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Suꞌwe la jñan wan chaꞌ ꞌin Ndiose, chaꞌ ja ndiꞌin chaꞌ xnan wan bra nu tiya tsan nu ka tlyaꞌ; kwiꞌ jñan wan chaꞌ ꞌin Ni chaꞌ ja ndiꞌin chaꞌ xnan wan tsan taꞌa nu nxitñaꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bra nu ndiꞌin chaꞌ xnan wan ni, kanꞌ lye ꞌa tyijin nten chalyuu nu tiꞌí. Ja ya tyijin nten nu tiꞌí ngwañaꞌan, ti bra nu ngwiñan Ndiose chalyuu sa bra ni; loꞌo ngwañaꞌan, ja tyijin ꞌa nten nu tiꞌí ngwañaꞌan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wa ykwiꞌ Ndiose chaꞌ chinꞌ ti tsan tyijin neꞌ nu tiꞌí ngwañaꞌan; si chan talo tyempu kuxi kanꞌ, ja ska ꞌa nten chalyuu tyoꞌo laa neꞌ bra kanꞌ. Loꞌo kuꞌni Ni chaꞌ chinꞌ ti tsan talo tyempu kuxi kanꞌ, chaꞌ chka tꞌnan ꞌa tiꞌ Ndiose ñaꞌan Ni ꞌin nten ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Xa nu tiya bra kanꞌ, si chkwiꞌ nten: “Ñaꞌan wan nde re, nde wa ngala Krixtu”, ja kunan wan chaꞌ kwiñi nu nchkwiꞌ neꞌ kanꞌ. Ti kwiꞌ ti chaꞌ, si ndiya nten nu chkwiꞌ chaꞌ re: “Wa ngala Krixtu kichen kwa”, ja kunan ꞌa wan bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","chaꞌ Krixtu kwiñi ka yu kanꞌ. Kwiꞌ ngwañaꞌan, tyoꞌo tukwa neꞌ kwiñi nu chkwiꞌ chabiyaꞌ ꞌin Ndiose, nchkwin neꞌ; kwiñi ti kuꞌni neꞌ kanꞌ chaꞌ tnun chaꞌ kuwe ꞌa tiꞌ nten. Loꞌo kuꞌni neꞌ kwiñi kanꞌ ngwañaꞌan, chaꞌ nchka tiꞌ neꞌ kuꞌni neꞌ kanan ꞌwan loꞌo ꞌin nchga nten nu wa ngulo suwi Ndiose ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wa ytsaǎnꞌ chaꞌ kanꞌ ꞌwan ni, xa nu ti ji ti ka chaꞌ kuxi kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","chaꞌ ja tukwa ꞌa wan chaꞌ ꞌin neꞌ si chkwiꞌ neꞌ chaꞌ re loꞌo wan: “Tsaan seꞌen ndiꞌin Krixtu, chaꞌ ndiꞌin yu niꞌ kixinꞌ kwa ni.” Ja tsaa wan loꞌo neꞌ bra kanꞌ. Loꞌo ja kunan wan si chkwiꞌ neꞌ chaꞌ re loꞌo wan: “Mnan ti ndiꞌin yu niꞌ ñaꞌan kwa ni.” Ja xñi wan chaꞌ nu chkwiꞌ neꞌ kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Sa ñaꞌan lka nxtyi xaa ndyuwi ñaꞌaan niꞌ kwan, chaꞌ ñaꞌan nchga nten ꞌin ran, ngwañaꞌan ka xa nu tiyaǎn xiyaꞌ, naꞌ nu wa msuꞌwa Stiǐn ꞌñaǎn chaꞌ ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kunan wan chaꞌ re: La seꞌen ndiꞌin nan tukun, la kanꞌ kiꞌya laxu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Xa nu wa mdyii tsan nu ndiꞌin chaꞌ ka nu tiꞌí ꞌin neꞌ, bra ti ka tla lo kwichaa, kwiꞌ ngwañaꞌan ja ka xaa lo koꞌ bra kanꞌ. Kalu kwii kulasiin nu ndukwi niꞌ kwan la lyuu; kwiꞌ ngwañaꞌan, kiñan nchga nan nu nsuꞌwi niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tyoꞌo tukwa biyaꞌ nu xtyaǎn niꞌ kwan bra kanꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Lye ꞌa ka xiꞌin tiꞌ nchga nten chalyuu nu ndiꞌin nchga kichen, kunan neꞌ bra kanꞌ. Loꞌoǔn nu wa ndijyaǎn chaꞌ kaǎn nten ni, ñaꞌan neꞌ ꞌñaǎn chaꞌ ndijyaǎn laja koo nu ngaten ꞌa; tnun ꞌa chaꞌ ka bra kanꞌ, chaꞌ loꞌo nchga chabiyaꞌ ꞌñaǎn kaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bra nu lye kanen kuwi, bra kanꞌ kuloǔn tñan ꞌin kaꞌan ꞌa angajle ꞌñaǎn chaꞌ tsaa xoꞌ tiꞌin ꞌin nchga nten nu wa ngulo suwi Ndiose ꞌin; tyoꞌo neꞌ kanꞌ la seꞌen ndiꞌin nten ñaꞌaan chalyuu kan neꞌ tloo Ni bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ndiya ska chaꞌ nu ka kuꞌni xaꞌaan, bra nu ñaꞌaan ska yka, ni siya yka nstin, ni siya xka la yka kwiñii. Bra nu tyisnan tyukwa nstin, bra kanꞌ tyoꞌo tukwa kuten yka kanꞌ; jlyo tianꞌ chaꞌ wa ndla ti kiꞌya tyoo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kwiꞌ ngwañaꞌan, bra nu ñaꞌan wan tyoꞌo tukwa nchga nan nu ykwiǐnꞌ loꞌo wan tsan, bra kanꞌ ka biyaꞌ tiꞌ wan chaꞌ wa ndla ti tyii chaꞌ re. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ ja ya kaja nchga nten nu nsuꞌwi chalyuu ni, bra nu ka chaꞌ nu wa ykwiǐnꞌ tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tyii nchga nan nu nsuꞌwi niꞌ kwan, tyii chalyuu re, loꞌo ja tyii siyaꞌ ti chaꞌ nu nchkwiǐnꞌ re, chaꞌ xkwiꞌ chañi lka chaꞌ nchkwiǐnꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Tsan kanꞌ, ja tukwin ka jlyo tiꞌ ni tsan ka, ni bra ka kanꞌ; ja jlyo tiꞌ angajle, kwiꞌ naꞌ nu lkaǎn ska ti nu lka Sñiꞌ Ndiose, ja jlyo tiǎnꞌ. Ska ti Stiǐn Ndiose jlyo tiꞌ Ni chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Sa ñaꞌan ngwa bra nu mdiꞌin ayman Noé chalyuu ti sꞌni, ngwañaꞌan ka tsan nu kaǎn naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten; ja ka biyaꞌ tiꞌ nten ni tsan ka chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Sa ñaꞌan ngwa chaꞌ ꞌin Noé kanꞌ bra nu ja ya kiꞌya tyoo tlyaa, ngwañaꞌan ka tsan kanꞌ. Sa ñaꞌan nu yꞌni nten chalyuu sꞌni: yꞌni neꞌ taꞌa, yku neꞌ, yiꞌo neꞌ, mjwi kwilyoꞌo neꞌ; ja ska chaꞌ yuwe tiꞌ neꞌ siyaꞌ ti, sa ñaꞌan bra nu yten Noé kanꞌ niꞌ yka naꞌan ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ja mgii ꞌa tiꞌ neꞌ bra nu mdyisnan ngwiꞌya tyoo tlyaa. Loꞌo mdyii chaꞌ ꞌin nchga neꞌ kanꞌ, chaꞌ ja ynan neꞌ chaꞌ nu ykwiꞌ Ndiose. Kwiꞌ ngwañaꞌan ka tsan nu kaǎn naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn chaꞌ ndijyaǎn chaꞌ kaǎn nten, ja kii ꞌa tiꞌ neꞌ ni tsan ka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tsan kanꞌ, bra nu ndaꞌan tukwa nten niꞌ kixinꞌ chaꞌ kuꞌni tñan, bra kanꞌ tyaa loꞌo angajle ꞌin ska yu kanꞌ, kanun xka yu bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","kwiꞌ ngwañaꞌan tsan kanꞌ, bra nu ndiꞌin tukwa nu kunaꞌan ska ti niꞌ ñaꞌan chaꞌ koo neꞌ, bra kanꞌ tyaa loꞌo angajle ꞌin ska ti neꞌ, kanun xka neꞌ bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Kanꞌ chaꞌ ndii ti tiꞌ wan tyiꞌin wan, chaꞌ ja jlyo tiꞌ wan siyaꞌ ti ni tsan ka nu kan ti kwiꞌ nu nka Xꞌnan wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ñaꞌan tiꞌ ska xꞌnan naꞌan, si wa ngii tiꞌ yu ni bra ngwa tla kan nten nu kuꞌni kunan naꞌan tyi yu, ja chan ndii ti tiꞌ yu ndiꞌin yu naꞌan tyi yu bra kanꞌ, chaꞌ ja ta yu chabiyaꞌ sten nu kuꞌni kunan kanꞌ niꞌ ñaꞌan tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kanꞌ chaꞌ nchga tsan ndiꞌin chaꞌ ndii ti tiꞌ wan tyiꞌin wan lo chalyuu, chaꞌ ja chan bra ti tyoꞌo tukwaǎn kaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ¿Ni sa ñaꞌan kuꞌni wan si ja ndiꞌin wan ndii ti tiꞌ wan bra kanꞌ? ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Ta ndiya nten ꞌwan nu tyukwi ti tiye nchka tiꞌ kuꞌni tñan ꞌñaǎn a? Nde lka chaꞌ nu kuꞌni wan sikwa: Ska msu nu suꞌwe ni, ta xꞌnan yu tñan ꞌin yu chaꞌ ka yu ndloo niꞌ ñaꞌan ꞌin xꞌnan yu; kulo xꞌnan yu tñan ꞌin yu chaꞌ xku yu ꞌin nchga nten nu ndiꞌin niꞌ ñaꞌan kanꞌ, ni siya ja ndiꞌin xꞌnan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Suꞌwe ꞌa ka tiye msu kanꞌ bra nu kan xꞌnan yu xiyaꞌ, si chañi chaꞌ ti ngiꞌni yu tñan nu wa ngulo xꞌnan yu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ tlyu la tñan ta xꞌnan yu ꞌin msu kanꞌ, chaꞌ ka yu ndloo ꞌin nchga tñan nu nsuꞌwi ꞌin xꞌnan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ska msu nu ndaja tiꞌ ni, nsuꞌwi tñan nu ngulo xꞌnan yu ꞌin yu, loꞌo ja nduwe tiꞌ yu. “Ja kan ndla xꞌnaǎn” nxkeꞌ tiꞌ yu, kanꞌ chaꞌ bra ti kiꞌya ska chaꞌ kuxi ke yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kanꞌ tyisnan yu kuꞌni yu chaꞌ chen ñaꞌan, kuꞌni tlá yu ꞌin taꞌa msu yu; tsaa yku yu, tsaa yiꞌo yu loꞌo taꞌa kuꞌwi yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Loꞌo kanꞌ kan xꞌnan msu xaꞌan kanꞌ ska tsan nu ja ndii tiꞌ yu kanꞌ, chaꞌ ja jlyo tiꞌ msu kanꞌ sa ñaꞌan bra tyoꞌo tukwa xꞌnan yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Lye ꞌa ta xꞌnan yu nu tiꞌí ꞌin yu kanꞌ bra kanꞌ, sa ñaꞌan yaꞌ nu kaja yu. Kulo xꞌnan yu tñan ꞌin yu, chaꞌ tsaa yu lo jwlyaa seꞌen ja tyii chaꞌ tyijin neꞌ nu tiꞌí. Lye ꞌa xiꞌya neꞌ, kwiꞌ lye ꞌa ku liꞌya neꞌ chaꞌ kasinꞌ tiꞌ neꞌ. Suꞌwa ti tsaa yu loꞌo neꞌ kwiñi nu tukwa chaꞌ nka tiye ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Chkwiǐnꞌ ska chaꞌ tiya loꞌo wan chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka bra nu ka Ndiose ndloo niꞌ kasiya ꞌin nten: Ndiya tii nu kunaꞌan kuneꞌ, ndyaa neꞌ naꞌan tyi ska nu kunaꞌan nu ka kuxiin ꞌin nten. Nsuꞌwi candil ꞌin taꞌa tii neꞌ, chaꞌ ndiꞌin ta neꞌ ꞌin nu kaja kwilyoꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ja ska chaꞌ nduwe tiꞌ kiꞌyu nu kunaꞌan kanꞌ, loꞌo xa tiꞌyu nu kunaꞌan kanꞌ, suꞌwe ꞌa chaꞌ ndaꞌan tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nu kunaꞌan nu ja nduwe tiꞌ kanꞌ ni, ja loꞌo sete chaꞌ xuꞌwi niꞌ candil ndiꞌya neꞌ ndaꞌan neꞌ, chaꞌ ta la xaa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Loꞌo xa tiꞌyu nu kunaꞌan nu suꞌwe ti ndaꞌan chaꞌ tiye kanꞌ, loꞌo candil ꞌin neꞌ ndaꞌan neꞌ, loꞌo seꞌen nsuꞌwi sete ꞌin neꞌ ndaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chan ꞌa mdiꞌin ta neꞌ ꞌin nu kiꞌyu nu ka kwilyoꞌo neꞌ; ngwiꞌya sla neꞌ, yijaꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jluꞌwe tla siyaꞌ ti ynen msiꞌya ska nten: “Wa ndijyan yu nu ka kwilyoꞌo kuxiin re ni” ndukwin. “Tyoꞌo lya wan nde chunꞌ naꞌan chaꞌ tsaa wan tuwiin loo yu, chaꞌ tyaan loꞌo wan ꞌin yu niꞌ ñaꞌan re.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Bra ti mxaa tiꞌ nchga nu kunaꞌan kanꞌ bra kanꞌ, msiꞌyu neꞌ juun nu ndukwa lo candil ꞌin neꞌ, loꞌo wa suꞌwa ti neꞌ xka ta sete niꞌ candil kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bra kanꞌ ndyuꞌwi tiꞌ nu kunaꞌan nu ja nduwe tiꞌ kanꞌ ꞌin sete ꞌin. ¿La nde kaja sete ni a? Bra kanꞌ mjñan neꞌ sete ꞌin taꞌa neꞌ: “Ta wan chinꞌ sete ꞌwa, chaꞌ wa tyuwiꞌ ti candil ꞌwa” ndukwin neꞌ nu ja nduwe tiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Sete nu ndiꞌya wa, ja tyoꞌo skwa chaꞌ xuꞌwi niꞌ candil ꞌñaan taꞌaan” ndukwin nu kunaꞌan nu suꞌwe ndaꞌan chaꞌ tiye kanꞌ. “Suꞌwe la yaa lya wan tiyenta chaꞌ xiꞌi wan ti chinꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bra nu ndyaa nu kunaꞌan nu ja nduwe tiꞌ kanꞌ xiꞌi la neꞌ ti chinꞌ sete, bra kanꞌ mdiyan yu nu kaja kwilyoꞌo kanꞌ. Nu kunaꞌan nu wa lka yꞌni xuꞌwe candil ꞌin neꞌ, ndyaa neꞌ niꞌ ñaꞌan tyi kuxiin loꞌo yu nu ka kwilyoꞌo kanꞌ, chaꞌ ku neꞌ seꞌen ndiꞌin; bra ti nchkunꞌ tunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Chunꞌ ndiꞌin la chinꞌ mdiyan nu kunaꞌan nu ja nduwe tiꞌ kanꞌ. “¡Wa mdiyan bare ni!” ndukwin neꞌ. “¡Slaa lya wan tunaꞌan chaꞌ sten ba seꞌen ndiꞌin wan kwa!” ndukwin neꞌ ꞌin yu nu kaja kwilyoꞌo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bra kanꞌ mxkwen yu ꞌin nu kunaꞌan nu ja nduwe tiꞌ kanꞌ: “Ja nsuꞌwi lyoǔn ꞌwan siyaꞌ ti, ja jlyo tiǎnꞌ ti ka nu lka wan” ndukwin yu nu ka kwilyoꞌo kanꞌ ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ti ykwiꞌ la Jesús ti chinꞌ loꞌo neꞌ bra kanꞌ: ―Kanꞌ chaꞌ ndii ti tiꞌ wan tyiꞌin wan nchga bra, chaꞌ ja jlyo tiꞌ wan ni tsan, ni bra kaǎn xiyaꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Loꞌo ni, chkwiǐnꞌ ska chaꞌ tiya loꞌo wan, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka bra nu ka Ndiose ndloo niꞌ kasiya ꞌin nten: Ndiya ska yu kuliyaꞌ, loꞌo wa tsaa ti yu tijyuꞌ, kanꞌ chaꞌ msiꞌya yu ꞌin nchga msu ꞌin yu, chaꞌ kan neꞌ seꞌen ndiꞌin yu. Kanꞌ mxnun xꞌnan neꞌ chinꞌ tñi ꞌin nchga msu bra kanꞌ, chaꞌ kuꞌni neꞌ tñan loꞌo tñi chaꞌ ꞌin yu kuliyaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Loꞌo kanꞌ mda yu kuliyaꞌ kanꞌ kiꞌyu mi tñi plata ꞌin msu nu mdiyan kulo, kwiꞌ mda yu tukwa mi ꞌin xka msu, kwiꞌ mda yu xka mi ti ꞌin xka msu kanꞌ, chaꞌ jlyo tiꞌ xꞌnan neꞌ ti ka msu nu ka la ꞌin kuꞌni tñan loꞌo tñi kanꞌ. Chunꞌ ndiꞌin la mdoꞌo xꞌnan neꞌ, ndyaa tijyuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bra ti ndyaa msu nu nsuꞌwi kiꞌyu mi tñi plata ꞌin, ngwiꞌya yu yuꞌwa loꞌo tñi kanꞌ. Bra wa yjwiꞌ yu yuꞌwa kanꞌ, yꞌni yu kanan xa tiꞌyu mi tñi plata ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kwiꞌ ngwañaꞌan yꞌni xka msu nu nsuꞌwi tukwa mi tñi plata ꞌin, yꞌni yu kanan tyukwa mi tñi plata. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Msu nu nsuꞌwi ska mi ti tñi plata ꞌin yu, ngulu yu ska tiyuu, loꞌo niꞌ yuu kanꞌ msuꞌwa kutsiꞌ yu tñi ꞌin xꞌnan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Xꞌni yaa xꞌnan msu kanꞌ, chunꞌ ndiꞌin la ngala yu naꞌan tyi yu xiyaꞌ. Msiꞌya yu ꞌin nchga msu ꞌin yu bra kanꞌ, chaꞌ tyan neꞌ seꞌen ndiꞌin yu, chaꞌ ka biyaꞌ tiꞌ xꞌnan neꞌ sa ñaꞌan tñan yꞌni neꞌ loꞌo tñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kulo mdiyan msu nu mda xꞌnan kiꞌyu mi tñi plata ꞌin. “Xꞌnaǎn” ndukwin msu kanꞌ, “mdaa kiꞌyu mi tñi ꞌñaǎn, loꞌo ni, wa mjwi xa tiꞌyu mi tñi ꞌñaǎn, chaꞌ wa yꞌniǐn tñan loꞌo tñi kanꞌ ꞌiin.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Suꞌwe ꞌa tñan nu yꞌnii” ndukwin xꞌnan msu kanꞌ ꞌin yu. “Ska msu suꞌwe lkaa, chaꞌ suꞌwe ꞌa ndukwaa chaꞌ ꞌñaǎn. Ska tñan xuwe ti mdaǎn ꞌiin nu ngwa xkanꞌ; nu ka nde loo la taǎn xka tñan nu tlyu la chaꞌ kuꞌnii. Suꞌwa ti tyiꞌiin seꞌen ndiꞌiǐn, chaꞌ suꞌwa ti ka suꞌwe tiyee loꞌoǔn” ndukwin xꞌnan msu kanꞌ ꞌin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chunꞌ ndiꞌin la mdiyan xka msu nu mda xꞌnan tukwa mi tñi plata ꞌin. “Xꞌnaǎn” ndukwin msu kanꞌ, “mdaa tukwa mi tñi plata ꞌñaǎn, loꞌo ni, wa mjwi tyukwa mi tñi ꞌñaǎn chaꞌ yꞌniǐn tñan loꞌo tñi kanꞌ ꞌiin.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Suꞌwe ꞌa tñan nu yꞌnii” ndukwin xꞌnan msu kanꞌ ꞌin. “Ska tñan xuwe ti mdaǎn ꞌiin nu ngwa xkanꞌ; nu ka nde loo la taǎn xka tñan nu tlyu la chaꞌ kuꞌnii. Suꞌwa ti tyiꞌiin seꞌen ndiꞌiǐn, chaꞌ suꞌwa ti ka suꞌwe tiyee loꞌoǔn” ndukwin xꞌnan yu ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chunꞌ ndiꞌin la mdiyan xka msu nu mda xꞌnan ska mi ti tñi ꞌin. “Xꞌnaǎn” ndukwin msu kanꞌ, “jlyo tiǎnꞌ chaꞌ nten tiji ꞌa lkaa, chaꞌ ndoꞌo tya ꞌiin seꞌen yꞌni xka la nten tñan kanꞌ; ngwañaꞌan nskwaꞌ nu nskwaꞌ xka la nten, kanꞌ lka nu kaja ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kanꞌ chaꞌ ytseěn ꞌiin. Kanꞌ yiꞌaǎn msuꞌwaǎn kutsiǐnꞌ tñi ꞌiin niꞌ yuu. Nde lka tñi ꞌiin sikwa.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Msinꞌ tiꞌ xꞌnan msu kanꞌ ꞌin yu bra kanꞌ. “Ska msu xaꞌan lkaa” ndukwin xꞌnan msu kanꞌ ꞌin yu. “Ndajaa ꞌaa” ndukwin. “Wa jlyo tiiꞌ chaꞌ nxoꞌ kiǐn tya, ni siya ja ytaǎn nskwaꞌ kanꞌ, ni siya siꞌi naꞌ nu yꞌniǐn tñan kanꞌ, ndukwin nuꞌwin. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Ni chaꞌ ja mdaa tñi ꞌñaǎn ꞌin xka nten sikwa, chaꞌ kuꞌni neꞌ tñan loꞌo ran? Chunꞌ ndiꞌin la tyaꞌan sñiꞌ tñi kanꞌ ꞌñaǎn, chaꞌ tyaa ꞌñaǎn xa nu kalaǎn xiyaꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ykwiꞌ xꞌnan msu kanꞌ loꞌo xka ta msu bra kanꞌ: “Suꞌwe la xñi wan ska mi nsuꞌwi yaꞌ yu re, ta wan ꞌin msu nu nsuꞌwi tii mi ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngwañaꞌan lka loꞌo nten nu wa nsuꞌwi chinꞌ chaꞌ ꞌin, ti taǎn kaꞌan la ꞌin nten kanꞌ si ngiꞌni neꞌ tñan loꞌo chaꞌ kanꞌ, chaꞌ kaꞌan la chaꞌ suꞌwe xuꞌwi ꞌin neꞌ kanꞌ; loꞌo nten nu chinꞌ ꞌa chaꞌ nsuꞌwi ꞌin, si ja xlyaa neꞌ kuꞌni neꞌ tñan loꞌo chaꞌ kanꞌ, kulaǎn jiǐn ti chaꞌ nu ti nsuꞌwi ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Loꞌo ni, tsaa loꞌo wan ꞌin msu xaꞌan re, chaꞌ xkwan wan ꞌin yu re lo jwlyaa, seꞌen lye ꞌa nxiꞌya neꞌ, loꞌo lye ꞌa nchku liꞌya neꞌ chaꞌ msinꞌ tiꞌ neꞌ, chaꞌ lye ꞌa ndijin neꞌ nu tiꞌí nde kwa.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, kaǎn xiyaꞌ nde loo la chaꞌ kaǎn ndloǔn la ti ꞌin nchga nten. Suꞌwa ti kaǎn loꞌo nchga angajle ꞌñaǎn, kanꞌ tyukwaǎn seꞌen tlyu la ti, ska seꞌen luwi ꞌa. Nde kwa kuꞌni biyaǎnꞌ ꞌin nchga nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ska seꞌen ti tyoꞌ tiꞌin nchga nten ñaꞌaan chalyuu tloǔn bra kanꞌ, chaꞌ kuꞌni biyaǎnꞌ ꞌin neꞌ. Bra kanꞌ suꞌweěn ꞌin nten tukwa seꞌen, sa ñaꞌan nu ngiꞌni nten nu ñaꞌansiin ꞌin slyaꞌ, kwiꞌ ngwañaꞌan kuꞌniǐn; ska laꞌa tyiꞌin ska ta slyaꞌ ꞌin neꞌ, xka laꞌa tyiꞌin xka ta chivu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ngwañaꞌan kuꞌniǐn, chaꞌ laꞌa seꞌen kwin ꞌñaǎn tyiꞌin nchga nten ꞌñaǎn, ñaꞌan tiꞌ ndiꞌin slyaꞌ kanꞌ; laꞌa seꞌen kaa seꞌen tyukwaǎn, la kanꞌ tyiꞌin nchga nu ja lka nten ꞌñaǎn, ñaꞌan tiꞌ ndiꞌin chivu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Bra nu kaǎn ndloǔn la ti, chkwiǐnꞌ loꞌo nchga nten nu ndiꞌin laꞌa seꞌen kwin ꞌñaǎn: “Kan wan nde seꞌen ndiꞌin Ndiose nu lka ndloo la ti, nchga wan nu suꞌwe ꞌa nka tiye Stiǐn Ndiose ñaꞌan Ni ꞌwan, chaꞌ wa yꞌni xuꞌwe Ni seꞌen tyiꞌin wan seꞌen ndiꞌin ykwiꞌ Ni, ti bra nu mñan Ni chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ꞌWan ni, wa mda wan nan ykuǔn chaꞌ mteꞌ tiǎnꞌ mdiꞌiǐn lo chalyuu; xa ngwityi tiǎnꞌ, mda wan tyiꞌa yiꞌoǔn bra kanꞌ. Ja yuꞌwi lyo wan ꞌñaǎn, loꞌo mda wan naꞌan tyi wan mdiꞌiǐn bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","chaꞌ ja yuꞌwi steěnꞌ bra nu mdiꞌiǐn lo chalyuu, mda wan teꞌ ykuǔnꞌ bra kanꞌ. Bra nu ngwa tiꞌíǐn lo chalyuu, yaa naꞌan wan ꞌñaǎn bra kanꞌ, mdayaꞌ wan ꞌñaǎn; kwiꞌ bra nu mstiǐn niꞌ ñaꞌan chkwan, ja ytsen wan yaa wan seꞌen yuꞌwiǐn bra kanꞌ.” Ngwañaꞌan chkwiǐnꞌ bra nu kaǎn ndloǔn la ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Xkwen neꞌ nu luwi kanꞌ ꞌñaǎn: “Xꞌnaan, ¿ni ñaꞌan bra naꞌan ba ꞌiin chaꞌ mteꞌ tiiꞌ a? ¿Ni ñaꞌan bra mxku ba ꞌiin a? ¿Ni ñaꞌan bra mda ba tyiꞌa yiꞌoo chaꞌ ngwityi tiiꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ni ñaꞌan bra mda ba seꞌen mdiꞌiin xa nu ja yuꞌwi lyo ba ꞌiin a? ¿Ni ñaꞌan bra mda ba teꞌ ykuuꞌ bra nu mdaꞌaan tiꞌyu tii a? ");
INSERT INTO ctpNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ni ñaꞌan bra yaa naꞌan ba ꞌiin xa nu ngwa tiꞌií a? ¿Ni ñaꞌan bra yaa naꞌan ba ꞌiin xa nu yuꞌwii niꞌ ñaꞌan chkwan a? Ja jlyo tiꞌ ba, Xꞌnaan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Loꞌo naꞌ nu lkaǎn ndloo la ti, chkwiǐnꞌ xiyaꞌ loꞌo neꞌ kanꞌ: “Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ bra nu mdayaꞌ wan ꞌin ska neꞌ taꞌaǎn nu ndiꞌin chaꞌ ꞌin loꞌoǔn, ni siya tiꞌi ꞌa neꞌ taꞌaǎn, kanꞌ ngwa ñaꞌan tiꞌ si mdayaꞌ wan ꞌñaǎn” ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Loꞌo chkwiǐnꞌ loꞌo xka ta nten nu tyiꞌin laꞌa seꞌen kaa ꞌñaǎn: “Tyaa lya wan, ꞌwan nu ja nsuꞌwi seꞌen tyiꞌin wan seꞌen ndiꞌin Ndiose. Yaa lya wan seꞌen nu ja ndyuwiꞌ ꞌa kiiꞌ, chaꞌ suꞌwa ti tyiꞌin wan loꞌo nu lka xꞌnan kuneꞌ xaꞌan loꞌo nchga nu ngiꞌni tñan ꞌin, nchga kwiꞌin kuxi; siꞌya kuneꞌ xaꞌan kanꞌ mxuꞌu Ndiose kiiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ꞌWan ni, ja mda ꞌa wan nan kuǔn bra nu mteꞌ tiǎnꞌ mdiꞌiǐn lo chalyuu; ja mda ꞌa wan tyiꞌa koꞌoǔn bra nu ngwityi tiǎnꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","loꞌo ja mda wan seꞌen mdiꞌin wan tyiꞌiǐn bra kanꞌ, chaꞌ nu ja yuꞌwi lyo wan ꞌñaǎn; ja mda wan teꞌ kuǔn xa nu mdaꞌaǎn tiꞌyuǔn tiǎn; ja yaa naꞌan wan ꞌñaǎn bra nu ngwa tiꞌiǐn, loꞌo ja yaa naꞌan wan ꞌñaǎn xa nu yuꞌwiǐn niꞌ ñaꞌan chkwan.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Xkwen neꞌ kuxi kanꞌ ꞌñaǎn bra kanꞌ: “Xꞌnaan” chkwiꞌ neꞌ kanꞌ, “¿ni ñaꞌan bra naꞌan ba ꞌiin chaꞌ mteꞌ tiiꞌ a? Bra nu ngwityi tiiꞌ, xa nu mdaꞌaan tiꞌyuu tiiꞌ, bra nu ngwa tiꞌií, xa nu yuꞌwii niꞌ ñaꞌan chkwan, ¿ni ñaꞌan bra ja mdayaꞌ ba ꞌiin a? Ja jlyo tiꞌ ba chaꞌ kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Loꞌoǔn chaꞌ kaǎn ndloo la ti, chkwiǐnꞌ loꞌo neꞌ xaꞌan kanꞌ xiyaꞌ bra kanꞌ: “Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ja mdayaꞌ wan ꞌin ska nu tiꞌi nu ndiꞌin chaꞌ ꞌin loꞌoǔn, kanꞌ chaꞌ nchkwiǐnꞌ loꞌo wan chaꞌ ja ska yaꞌ mdayaꞌ wan ꞌñaǎn.” ");
INSERT INTO ctpNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndiꞌin chaꞌ tyaa neꞌ kanꞌ lo jwlyaa seꞌen nu ja tyii ꞌa chaꞌ tyijin neꞌ nu tiꞌí bra kanꞌ; loꞌo neꞌ nu luwi ni, kaja chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Bra wa mdyii ykwiꞌ Jesús nchga chaꞌ kanꞌ, ykwiꞌ yu chinꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Jlyo tiꞌ wan chaꞌ tyukwa ti tsan ti ji chaꞌ ka taꞌa siin pascua. Tsan kanꞌ xñi neꞌ xaꞌan ꞌñaǎn nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Tsaa loꞌo neꞌ ꞌñaǎn chaꞌ kujwi neꞌ ꞌñaǎn lo wsi bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ti kwiꞌ ti bra nu nchkwiꞌ Jesús, bra kanꞌ ndyoꞌ tiꞌin tyun sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo ꞌin nten, loꞌo yu kula ꞌin neꞌ judío; ndyoꞌ tiꞌin neꞌ seꞌen ndiꞌin Caifás nu ngwa xꞌnan nchga sti joꞌo kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Kanꞌ yꞌni suꞌwa neꞌ chaꞌ ꞌin neꞌ loꞌo taꞌa neꞌ sa ñaꞌan kuꞌni neꞌ chaꞌ xñi mnan ti neꞌ ꞌin Jesús, chaꞌ kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","―Ja suꞌwe xñian ꞌin yu tsan taꞌa ―ndukwin neꞌ kanꞌ―. Kasinꞌ ꞌa tiꞌ nchga nten nu ndiꞌin tsan taꞌa, tlyu ꞌa chaꞌ wsuun ka bra kanꞌ ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ngwa ska tsan mdiꞌin Jesús kichen Betania, naꞌan tyi Simón nu yuꞌwi kicha ngatsuꞌ kunaꞌ ꞌin mdiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kanꞌ mdiyan ska nu kunaꞌan seꞌen ndiꞌin Jesús nu mdaꞌan loꞌo ska teꞌén lyuꞌ ti nu ndyaꞌ loꞌo kee alabastro; msaꞌan teꞌén lyuꞌ ti kanꞌ nsuꞌwi tyiꞌa xi tyiꞌi nu kaꞌan ngaꞌan. Loꞌo mslu tukwa nu kunaꞌan kanꞌ tyiꞌa xi tyiꞌi lo jlyuꞌwe Jesús seꞌen ndukwa yu tuꞌwa msaa. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Bra nu naꞌan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu sa ñaꞌan nu yꞌni nu kunaꞌan kanꞌ, msinꞌ ꞌa tiꞌ neꞌ ꞌin nu kunaꞌan kanꞌ bra kanꞌ. ―¿Ni chaꞌ mslu ji nu kunaꞌan kwa tyiꞌa xi tyiꞌi kanꞌ chunꞌ yu? ―ndukwin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kaꞌan ꞌa ngaꞌan tyiꞌa xi tyiꞌi kwa. ¿Ni chaꞌ ja yjwiꞌ neꞌ ꞌin ran chaꞌ kaja tñi ta neꞌ ꞌin neꞌ tiꞌi? ―ndukwin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Bra nu mgii tiꞌ Jesús chaꞌ nu ndaꞌan tiye neꞌ kanꞌ, ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―¿Ni chaꞌ msinꞌ tiꞌ wan ꞌin nu kunaꞌan re? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―. Ska chaꞌ suꞌwe ꞌa yꞌni nu kunaꞌan re loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nchga tsan ndiꞌin neꞌ tiꞌi loꞌo wan lo chalyuu chaꞌ tayaꞌ wan ꞌin neꞌ, loꞌo naꞌ ni, wa tyii ti tsan nu ndiꞌiǐn loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wa mslu nu kunaꞌan re tyiꞌa xi tyiꞌi chuǔnꞌ bra nu wa ndla ti kajaǎn, chaꞌ kuꞌni xuꞌwe tyukwi ñaꞌaǎn chaꞌ katsiǐnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ nchga seꞌen nu kanen chaꞌ ꞌñaǎn ñaꞌaan chalyuu, bra kanꞌ kunan neꞌ nchga chaꞌ nu yꞌni nu kunaꞌan re ni, chaꞌ tyuꞌwi tiꞌ neꞌ chaꞌ suꞌwe ꞌa tñan nu yꞌni nu kunaꞌan re tsan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Loꞌo Juda Iscariote ni, taꞌa ndaꞌan nu tii xka yu nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, mdoꞌo yu ndyaa yu seꞌen ndiꞌin sti joꞌo nu lka ndloo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","―¿Ni nkwa tñi ta wan liyaꞌ ꞌñaǎn si kwaꞌuǔn tuwiin ꞌwan, chaꞌ tsaa sñi wan ꞌin Jesús kanꞌ a? ―ndukwin Juda ꞌin sti joꞌo kanꞌ. Mda neꞌ kalatyii tñi plata ꞌin Juda bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ti bra kanꞌ mdaꞌan naan yu sa ñaꞌan ka tayaꞌ yu ꞌin neꞌ kanꞌ, ni ñaꞌan bra ka ꞌin yu kwaꞌu mnan ti yu tuwiin ꞌin neꞌ, chaꞌ tsaa neꞌ seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bra nu ngwa tsan ykwiꞌ taꞌa xa nu nchku neꞌ jaxlya nu ja yuꞌwi skwan tiyeꞌ, kanꞌ mdiyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin yu. Mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿La nde yaꞌ nchka tiiꞌ chaꞌ kuꞌni xuꞌwe ba nan kuun siin chaꞌ ꞌin taꞌa pascua re? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","―Tsaa wan lo kichen seꞌen ndiꞌin taꞌa suꞌwe nsuꞌwiǐn kanꞌ. Chkwiꞌ wan chaꞌ re loꞌo yu: “Ndukwin mstru ꞌñaan chaꞌ wa ndla ti tiya bra ꞌin yu. Loꞌo ni, nchka tiꞌ ti kwiꞌ yu kula kanꞌ ku siin taꞌa pascua naꞌan tyii loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu.” ");
INSERT INTO ctpNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mdoꞌo neꞌ nu ngiꞌni xaꞌan kanꞌ ndyaa neꞌ lo kichen, yꞌni neꞌ nchga tñan nu wa ngulo Jesús ꞌin neꞌ; yꞌni xuꞌwe neꞌ nchga nan nu kunanjoꞌo ꞌin neꞌ chaꞌ ku siin neꞌ taꞌa pascua. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Xa wa msiin, bra kanꞌ mdiyan Jesús naꞌan kanꞌ. Nde kwa mdukwa yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu tuꞌwa msaa, yku siin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mdyisnan ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ndiya ska yu taꞌa wan nu kuꞌni trisiyun ꞌñaǎn yaꞌ neꞌ xaꞌan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xiꞌin ꞌa tiꞌ neꞌ bra nu ynan neꞌ chaꞌ kanꞌ. Bra ti mdyisnan neꞌ mnichaꞌ neꞌ ꞌin Jesús: ―Xꞌnaǎn, ¿ta naꞌ nu tyaǎn ꞌiin yaꞌ neꞌ xaꞌan a? ―ndukwin ska yu ꞌin Jesús. ―¿Ta naꞌ a? ―ndukwin xka yu bra kanꞌ. Loꞌo ngwañaꞌan ndukwin xka ta neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Ndiꞌin ska yu taꞌa nchkuan siin ni, nu ska ti niꞌ kaꞌnan nchkuǔn loꞌo yu, kanꞌ lka nu kuꞌni trisiyun ꞌñaǎn loꞌo neꞌ xaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Sa ñaꞌan nu ndukwa chaꞌ lo kityi ꞌin Ndiose, ngwañaꞌan ndiꞌin chaꞌ ka ꞌñaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ¡Tꞌnan ꞌa nten nu tya ꞌñaǎn yaꞌ neꞌ xaꞌan! Suꞌwe la ka ꞌin yu ni siya ja ngula yu chalyuu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Loꞌo Juda nu kuꞌni chaꞌ kuxi kanꞌ, loꞌo yu kanꞌ mnichaꞌ yu ꞌin Jesús bra kanꞌ: ―Mstru ―ndukwin Juda kanꞌ ꞌin Jesús―, ¿ta naꞌ lkaǎn nu tyaǎn ꞌiin yaꞌ neꞌ xaꞌan a? ―Kwiiꞌ ―ndukwin Jesús ꞌin Juda bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Laja nu nchku neꞌ, bra kanꞌ msñi Jesús ska jaxlya, ndya xuꞌwe ꞌin Ndiose, msuꞌwe jaxlya kanꞌ. Mda yu yuꞌwe jaxlya kanꞌ ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ―Ku wan jaxlya re, chaꞌ ñaꞌan tiꞌ kunaǎnꞌ, ngwañaꞌan lka re ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chunꞌ ndiꞌin la msñi Jesús ska basu mñun, ndya xuꞌwe ꞌin Ndiose. Kanꞌ mda yu basu mñun kanꞌ ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ―Nchga wan koꞌo wan mñun re ―ndukwin Jesús―, ");
INSERT INTO ctpNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","chaꞌ ñaꞌan tiꞌ tneěn, ngwañaꞌan lka re. Lka re ska chaꞌ nu kwaꞌu ñi ꞌwan chaꞌ xiyaꞌ skanꞌ Ndiose chaꞌ loꞌo nten chalyuu, xa nu kalu tneěn lo wsi. Ngwañaꞌan kulaa Ndiose ꞌin kaꞌan ꞌa taꞌa nten wan, bra nu kuꞌni Ni chaꞌ tlyu tiꞌ ꞌwan kiꞌya nu ndukwi wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ ja koꞌoǔn ꞌa mñun ni, sa ñaꞌan yaꞌ nu tiya tsan kanꞌ nu koꞌoǔn ꞌin ran suꞌwa loꞌo wan seꞌen ndiꞌin Stiǐn Ndiose nu lka ndloo la ti. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Bra nu yla tuꞌwa neꞌ ska kantu ꞌin Ndiose, bra kanꞌ mdoꞌo neꞌ ndyaa neꞌ lo kiꞌya Olivos. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ka jyuꞌu tiꞌ nchga wan ñaꞌan wan ꞌñaǎn tla ndaꞌa. Kanꞌ ka sa ñaꞌan ndukwa chaꞌ lo kityi ꞌin Ndiose nu ngwa sꞌni. Nde lka chaꞌ kanꞌ: “Bra nu kujwiǐn ꞌin nu ñaꞌansiin ꞌin slyaꞌ, xnan nchga slyaꞌ kanꞌ, tyaa iꞌ bra kanꞌ” ndukwin kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Loꞌo naꞌ, bra nu tyuꞌuǔn xiyaꞌ, bra kanꞌ tsaꞌaǎn Galilea kulo ndukwa la. Tsaa naan wan ꞌñaǎn nde kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ykwiꞌ Tyu loꞌo Jesús bra kanꞌ: ―Ja kulaa yaǎnꞌ ꞌiin siyaꞌ ti ―ndukwin Tyu bra kanꞌ―. Ni siya nchga neꞌ xnan neꞌ ꞌiin, naꞌ ni, ja xnaǎn ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mxkwen Jesús ꞌin Tyu bra kanꞌ: ―Chañi katsaǎnꞌ ꞌiin ni ―ndukwin yu―, chaꞌ bra nu ti ji xiꞌya la kweꞌe tla ndaꞌa, snan yaꞌ chkwiiꞌ loꞌo nten chaꞌ ja nsuꞌwi lyoo ꞌñaǎn; jlyo tiǎnꞌ chaꞌ ngwañaꞌan chkwiiꞌ loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Xiyaꞌ ykwiꞌ Tyu bra kanꞌ: ―Ni siya suꞌwa kajaǎn loꞌoo, ja chkwiǐnꞌ loꞌo nten chaꞌ ja nsuꞌwi lyoǔn ꞌiin ―ndukwin Tyu bra kanꞌ. Kwiꞌ ngwañaꞌan mxkwen nchga neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Chunꞌ ndiꞌin la mdiyan Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, yten neꞌ ska niꞌ lyoꞌoo seꞌen naan Getsemaní, nu ndiꞌin tuꞌwa kichen. ―Tyukwa wan chinꞌ nde kwa ti ―ndukwin Jesús ꞌin neꞌ kanꞌ―, bra nu tsaꞌaǎn nde kwa la chinꞌ chaꞌ chkwiǐnꞌ loꞌo Stiǐn Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ti ndyaa la Jesús ti chinꞌ seꞌen loꞌo Tyu loꞌo taꞌa tyukwaa sñiꞌ Zebedeo bra kanꞌ. Ngwa xiꞌin ꞌa tiꞌ Jesús siꞌya chaꞌ tnun nu wa tyukwa ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Loꞌo ykwiꞌ Jesús loꞌo taꞌa snan neꞌ kanꞌ: ―Niꞌ kasiya ꞌñaǎn nsuꞌwi ska chaꞌ xiꞌin nu tlyu ꞌa. Ja taloǔn chaꞌ xiꞌin ꞌa tiǎnꞌ. Kanun wan nde ti, ndii ti tiꞌ wan tyiꞌin wan loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ti ndyaa la yu chinꞌ nde kwa bra kanꞌ. Mdyisti yu nde tloo yu chaꞌ xiꞌin ꞌa tiꞌ yu. Ykwiꞌ yu loꞌo Ndiose, nde lka chaꞌ nu ykwiꞌ yu bra kanꞌ: ―Stiǐn, ¿ta ja nsuꞌwi ꞌa xka ñaꞌan nu kuꞌniǐn tñan tnun re ꞌiin a?, chaꞌ ja tyijiǐn ꞌaǎn nu tiꞌí siꞌya chaꞌ tnun re ―ndukwin Jesús ꞌin Ndiose Sti yu―. Ska ti chaꞌ nchka tiǎnꞌ kuꞌniǐn ñaꞌaan tñan nu kuloo ꞌñaǎn. Siꞌi naꞌ kuloǔn tñan. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Chunꞌ ndiꞌin la mxitukwi yu ndyaa yu seꞌen ndiꞌin taꞌa snan neꞌ kanꞌ. Lajaꞌ ꞌa neꞌ bra kanꞌ. Loꞌo ykwiꞌ Jesús loꞌo Tyu kanꞌ: ―¿Ta ja nchka tyiꞌin wan ndii ti tiiꞌ wan loꞌoǔn ni siya ska bra ti a? ―ndukwin Jesús ꞌin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","¡Ndii ti tiꞌ wan tyiꞌin wan ni sikwa! Chkwiꞌ wan loꞌo Ndiose chaꞌ ja kuꞌni kuneꞌ xaꞌan kanan ꞌwan. Jlyo tiǎnꞌ chaꞌ tyukwi ti tiye wan nchka tiꞌ wan kuꞌni wan tñan re ꞌñaǎn. Loꞌo ja ndalo wan, kanꞌ chaꞌ ndla ꞌa yijaꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xiyaꞌ ndyaa Jesús bra kanꞌ, chaꞌ chkwiꞌ yu loꞌo Ndiose: ―Stiǐn ―ndukwin yu―, chaꞌ ja ndiya xka ñaꞌan kuꞌniǐn tñan ꞌiin, suꞌwe la tyijiǐn nu tiꞌí sikwa, chaꞌ nchka tiǎnꞌ kuꞌniǐn nchga tñan nu ndloo ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Xiyaꞌ mxitukwi yu ndyaa yu seꞌen ndiꞌin neꞌ kanꞌ bra kanꞌ; loꞌo naꞌan yu ꞌin neꞌ chaꞌ lajaꞌ neꞌ xiyaꞌ, chaꞌ lye ꞌa yuꞌwi sla neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Mxnun yu ꞌin neꞌ bra kanꞌ, ndyaa yu chaꞌ chkwiꞌ yu loꞌo Ndiose xiyaꞌ. Ti kwiꞌ chaꞌ nu ykwiꞌ yu ti tsan, ti kwiꞌ chaꞌ kanꞌ ykwiꞌ yu xiyaꞌ; wa mdaꞌa snan yaꞌ ykwiꞌ yu loꞌo Ndiose nu lka Sti yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Chunꞌ ndiꞌin la mxitukwi yu ndyaa yu xiyaꞌ seꞌen ndiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ―¿Ti lajaꞌ wan a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. ¿Ja ya tyoꞌo sla wan a? Xaa tiꞌ wan ni, chaꞌ wa mdiya bra nu xñi neꞌ xaꞌan ꞌñaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tyituun wan chaꞌ tyaan, chaꞌ wa mdiyan yu nu ta ꞌñaǎn yaꞌ neꞌ xaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Bra nu ykwiꞌ Jesús chaꞌ kanꞌ, bra ti mdiyan Juda seꞌen ndiꞌin neꞌ. Ti kwiꞌ taꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús ngwa Juda kanꞌ. Loꞌo kaꞌan ꞌa nten mdiyan loꞌo yu, nu ndiya xtyi wsuun ꞌin, nu ndiya yka ꞌin; mdiyan neꞌ xaꞌan kanꞌ tñan nu ngulo sti joꞌo nu lka ndloo, ti kwiꞌ tñan nu ngulo nchga yu kula nu lka ndloo, mdiyan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Loꞌo Juda ni, kanꞌ lka nu wa ta ti ꞌin Jesús yaꞌ neꞌ xaꞌan kanꞌ. Nde lka chaꞌ nu wa ytsaꞌ Juda ꞌin neꞌ ti tsan: ―Ska ti yu nu xñiǐn siꞌ taꞌa ba loꞌo, kanꞌ yu xñi wan. Ngwañaꞌan ykwiꞌ Juda loꞌo neꞌ ti tsan, ");
INSERT INTO ctpNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","kanꞌ chaꞌ ndyaa yu kanꞌ seꞌen ndiꞌin Jesús chaꞌ xñi siꞌ taꞌa yu loꞌo. ―¿Ni rsun ndaa ni, Mstru? ―ndukwin Juda ꞌin Jesús. Msñi Juda siꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Loꞌo ykwiꞌ Jesús loꞌo Juda bra kanꞌ: ―Taꞌa suꞌwe nsuꞌwiǐn ngwa nuꞌwin ti xkanꞌ ―ndukwin Jesús―. ¿Ni tñan ndijyaan re ni a? Loꞌo msñi neꞌ xaꞌan kanꞌ ꞌin Jesús, chaꞌ tyaa loꞌo neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Loꞌo ska nten nu mdaꞌan loꞌo Jesús, bra ti ngulo yu xtyi wsuun ꞌin yu, mdijin kuꞌ yu jin nxkan msu ꞌin xꞌnan sti joꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Bra ti ngulo Jesús tñan ꞌin yu kanꞌ: ―Tyukwan xtyi wsuun kwa ꞌiin ―ndukwin ꞌin yu kanꞌ―. Nchga nten nu nxuun loꞌo xtyi, kwiꞌ ngwañaꞌan kaja neꞌ kanꞌ loꞌo xtyi. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ja jlyo tiiꞌ a? Bra nu jñaǎn ꞌin Stiǐn, bra ti kulo Stiǐn tñan chaꞌ kan tii tyukwa ta angajle ꞌin Ni, chaꞌ tayaꞌ neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Loꞌo ja nchka tiꞌ ba ngwañaꞌan. Ndiꞌin chaꞌ ka ñaꞌaan chaꞌ nu ndukwa lo kityi kula ꞌin Stiǐn Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Loꞌo ykwiꞌ Jesús loꞌo ñaꞌaan ta nten xaꞌan nu ndijyan chaꞌ xñi ꞌin yu: ―¿Ni chaꞌ ndijyan wan loꞌo xtyi wsuun ꞌwan, loꞌo yka ꞌwan, chaꞌ xñi wan ꞌñaǎn a? ―ndukwin Jesús ꞌin neꞌ―. ¿Ta neꞌ nu yꞌni kunan lkaǎn, xkeꞌ tiꞌ wan a? Tyun ꞌa tsan mdiꞌiǐn niꞌ lyaa tnun ꞌwan, ngwaꞌuǔn chaꞌ ꞌin Ndiose ꞌin nten, loꞌo ja msñi wan ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sa ñaꞌan nu ngwaꞌan neꞌ lo kityi nu ngwa sꞌni, neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten, ngwañaꞌan ngiꞌni wan loꞌoǔn ni. Kanꞌ mdoꞌo nchga neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, msnan neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Chunꞌ ndiꞌin la mdiyan loꞌo neꞌ xaꞌan kanꞌ ꞌin Jesús tloo Caifás, xꞌnan sti joꞌo. Tuꞌ naꞌan tyi yu kanꞌ wa ndyoꞌ tiꞌin nchga mstru nu nduꞌu chaꞌ joꞌo loꞌo nchga yu kula nu lka ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Loꞌo Tyu kanꞌ ni, tijyuꞌ ti ndaꞌan ñaꞌan yu chunꞌ neꞌ nu msñi ꞌin Jesús, sa ñaꞌan yaꞌ nu mdiyan neꞌ tu loꞌoo ꞌin xꞌnan sti joꞌo kanꞌ. Kwiꞌ yten Tyu niꞌ lyoꞌoo kanꞌ, suꞌwa ti ndukwa yu loꞌo neꞌ policía, chaꞌ nchka tiꞌ yu ñaꞌan yu sa ñaꞌan kuꞌni lyoꞌo neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nchga neꞌ wsiya, loꞌo nchga sti joꞌo nu lka ndloo, loꞌo nchga yu kula kanꞌ, ndyaa naan neꞌ sa ñaꞌan ka xtya neꞌ kiꞌya ꞌin Jesús, chaꞌ nchka ꞌa tiꞌ neꞌ kujwi neꞌ ꞌin yu, loꞌo ja mjwi ꞌa nten nu kujwiꞌ xuꞌwa ꞌin yu yaꞌ neꞌ nu lka ndloo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ja mjwi ñaꞌan kuꞌni neꞌ. Kaꞌan ꞌa nu kwiñi yan seꞌen ndiꞌin neꞌ nu lka ndloo kanꞌ, chaꞌ xtya neꞌ kiꞌya ꞌin Jesús; loꞌo ja suꞌwa chaꞌ nchkwiꞌ yu kwiñi kanꞌ. Xa wa tyii ti chaꞌ bra kanꞌ, mdiyan tukwa nu kwiñi nu ykwiꞌ chaꞌ re: ");
INSERT INTO ctpNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","―Nde lka chaꞌ nu ykwiꞌ nu kiꞌyu kwa: “Ka ꞌñaǎn kuꞌni tyiǐn laa tnun re ꞌin Ndiose, loꞌo ka ꞌñaǎn kwiñaǎn ꞌin ran xiyaꞌ; chunꞌ snan tsan ti tyii tyaꞌ laa ꞌñaǎn” ndukwin Jesús kwa ―ngwañaꞌan ndukwin nu kwiñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Mdyituun xꞌnan sti joꞌo bra kanꞌ, ykwiꞌ yu loꞌo Jesús: ―¿Ni chaꞌ mstya neꞌ re kiꞌya ꞌiin? ―ndukwin sti joꞌo kanꞌ―. ¿Ni chaꞌ ja xkween ꞌin ska chaꞌ nchkwiꞌ ba? ");
INSERT INTO ctpNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ja ska chaꞌ mxkwen Jesús ꞌin sti joꞌo. Chunꞌ ndiꞌin la ngulo sti joꞌo kanꞌ tñan ꞌin yu: ―Chabiyaꞌ ꞌin Ndiose nu luꞌu ndloǔn tñan re ꞌiin ni: Katsaaꞌ lyaa ꞌwa si chañi chaꞌ Krixtu lka nuꞌwin, si lkaa ska ti nu lka Sñiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","―Kwiǐnꞌ lkaǎn, sa ñaꞌan nu ndukwiin chaꞌ lkaǎn ―ndukwin Jesús bra kanꞌ―. Loꞌo xka chaꞌ katsaǎnꞌ ꞌwan ni, chaꞌ nde loo la ñaꞌan wan ꞌñaǎn xa nu tyukwaǎn laꞌa seꞌen kwin seꞌen ndukwa Stiǐn Ndiose, nu nchka ꞌin nchga tñan, naꞌ nu wa msuꞌwa Ni ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Loꞌo ñaꞌan wan xa nu kaǎn xiyaꞌ laja ko bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Loꞌo xꞌnan sti joꞌo kanꞌ ni, ti ykwiꞌ ti yu msaaꞌ yu steꞌ yu bra kanꞌ, chaꞌ msinꞌ ꞌa tiꞌ yu. ―Kwiñi ꞌa yu re, chaꞌ kuxi nchkwiꞌ yu re ꞌin Ndiose ―ndukwin sti joꞌo kanꞌ ꞌin ñaꞌaan ta neꞌ nu lka ndloo bra kanꞌ―. Ja ndiꞌin chaꞌ xtya xka nten kiꞌya ꞌin yu re, chaꞌ wa ynaan chaꞌ tnun ꞌa chaꞌ kuxi ykwiꞌ yu re, xa nu ndukwin yu chaꞌ Sñiꞌ Ndiose lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ni sa ñaꞌan nka tiye wan ni a? Bra ti mxkwen neꞌ ꞌin xꞌnan sti joꞌo kanꞌ: ―Ndiꞌin chaꞌ kaja yu ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chunꞌ ndiꞌin la msuꞌwa sneꞌ neꞌ tloo Jesús; mjiꞌin neꞌ ꞌin yu. Loꞌo xka ta neꞌ, kanꞌ ykwanꞌ tloo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Loꞌo ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―Nuꞌwin ndukwiin chaꞌ Krixtu lkaa, kwiꞌ ndukwiin chaꞌ Ndiose msuꞌwa ꞌiin ndijyaan chalyuu. Suꞌwe sikwa. Katsaaꞌ ñi ꞌwa: ¿Ni sa ñaꞌan naan yu nu mykwanꞌ ꞌiin a? Si chañi chaꞌ ndii tiiꞌ ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Loꞌo Tyu kanꞌ ni, chunꞌ naꞌan ti mdukwa yu kanꞌ. Kanꞌ mdiyan ska nu kunaꞌan msu ꞌin sti joꞌo seꞌen ndukwa yu. ―Loꞌo nuꞌwin ndaꞌaan suꞌwa ti loꞌo Jesús, neꞌ Galilea kwa ―ndukwin nu kunaꞌan kanꞌ ꞌin Tyu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Loꞌo kwen mxkwen Tyu ꞌin nu kunaꞌan kanꞌ, chaꞌ kunan nchga nten bra kanꞌ: ―Ja nchka biyaꞌ tiǎnꞌ chaꞌ nu nchkwiiꞌ ―ndukwin Tyu ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bra ti mdoꞌo tsuꞌ Tyu mdyituun yu kwiꞌ seꞌen ti tuloꞌoo kanꞌ. Chunꞌ ndiꞌin la naꞌan xka nu kunaꞌan nu lka msu ꞌin sti joꞌo, ykwiꞌ loꞌo nten nu nduun kwiꞌ seꞌen ti: ―Suꞌwa ti ndaꞌan nu kiꞌyu re loꞌo Jesús Nazaret kwa ―ndukwin nu kunaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Xiyaꞌ ykwiꞌ Tyu xka chaꞌ kwiñi, chaꞌ siꞌi kanꞌ lka yu: ―Ja siyaꞌ yuꞌwi lyoǔn ꞌin nu kiꞌyu kwa ―ndukwin Tyu ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chunꞌ ndiꞌin la chinꞌ mdiyan xka ta nten nu nduun nde kwa ti chaꞌ chkwiꞌ neꞌ loꞌo Tyu bra kanꞌ: ―Chañi chaꞌ taꞌa ndaꞌan nu kiꞌyu kwa lkaa ―ndukwin neꞌ ꞌin yu―, chaꞌ suꞌwa ti nnen chaꞌ nu nchkwiiꞌ loꞌo taꞌa kichen tyi yu kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Lye ꞌa ykwiꞌ Tyu xiyaꞌ bra kanꞌ, chaꞌ ta Ndiose nu tiꞌí ꞌin yu si chaꞌ kwiñi lka nu nchkwiꞌ yu. ―Ja siyaꞌ yuꞌwi lyoǔn ꞌin nu kiꞌyu kwa ―ndukwin Tyu ꞌin neꞌ. Bra ti msiꞌya la kweꞌe bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kanꞌ ndyaa yuꞌwi tiꞌ Tyu chaꞌ nu ykwiꞌ Jesús loꞌo yu ti tsan: “Bra nu ti ji ti xiꞌya la kweꞌe tla ni, snan yaꞌ chkwiiꞌ loꞌo nten chaꞌ ja nsuꞌwi lyoo ꞌñaǎn.” Ngwañaꞌan ndukwin Jesús ꞌin yu ti tsan la, kanꞌ chaꞌ mdoꞌo yu ndyaa yu bra kanꞌ; nganan ꞌa yu ndyaa yu chaꞌ xiꞌin ꞌa tiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bra nu ngwiꞌya xaa xka tsan, xiyaꞌ ndyoꞌ tiꞌin nchga sti joꞌo nulka ndloo loꞌo nchga yu kula ꞌin neꞌ judío, chaꞌ ka suꞌwa chaꞌ ꞌin neꞌ loꞌo taꞌa neꞌ, sa ñaꞌan ka kujwi neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mskanꞌ neꞌ ꞌin Jesús bra kanꞌ, ndyaa loꞌo neꞌ ꞌin tloo Poncio Pilato, nu ngwa gobernador romano. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Loꞌo Juda nu yꞌni trisiyun ꞌin Jesús yaꞌ neꞌ xaꞌan kanꞌ, naꞌan yu chaꞌ wa kujwi ti neꞌ ꞌin Jesús; ngwa xiꞌin ꞌa tiꞌ yu bra kanꞌ. Bra ti ndya yu kalatyii tñi plata kanꞌ ꞌin yu nu lka ndloo kanꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―Ndiꞌin kiꞌya ꞌñaǎn ―ndukwin Juda kanꞌ ꞌin yu nu lka ndloo―, chaꞌ wa yjwiǐnꞌ ska nten luwi ꞌwan, chaꞌ kujwi wan ꞌin ―ndukwin. Mxkwen yu nu lka ndloo kanꞌ ꞌin Juda bra kanꞌ: ―Siꞌi chaꞌ ꞌwa lka chaꞌ kanꞌ ―ndukwin neꞌ nu lka ndloo―. Si ndiꞌin kiꞌya ꞌiin, chaꞌ ꞌiin lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Kanꞌ chaꞌ mslu Juda tñi plata kanꞌ niꞌ lyaa tnun tloo yu nu lka ndloo kanꞌ, mdoꞌo yu ndyaa yu bra kanꞌ. Loꞌo Juda kanꞌ, ti ykwiꞌ ti yu yjwi yu ꞌin yu; mskanꞌ yu ti su ynin yu, loꞌo nguun yu ti su lo yka, mskanꞌ tukwi yu ꞌin yu, ti ykwiꞌ ti yu. Kanꞌ mxtyuu loo yu lyuu, ngujwi yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Msñi sti joꞌo nu lka ndloo tñi kanꞌ bra kanꞌ. ―¿Ni sa ñaꞌan kuꞌnian sikwa a? ―ndukwin sti joꞌo ꞌin taꞌa neꞌ―. Ja ndiya chabiyaꞌ xtyaan tñi re loꞌo lomstan nu wa mda nten ꞌin Ndiose niꞌ lyaa re, chaꞌ tñi nu mjwi ꞌin yu chaꞌ yꞌni yu trisiyun ꞌin ska nten lka tñi re ―ndukwin sti joꞌo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Loꞌo ngwa suꞌwa chaꞌ ꞌin neꞌ loꞌo taꞌa neꞌ, chaꞌ xiꞌi neꞌ ska loꞌoo ꞌin nten loꞌo tñi kanꞌ, seꞌen mñan neꞌ katunꞌ nu ngwa sꞌni; kaja seꞌen niꞌ lyoꞌoo kanꞌ katsiꞌ ayman ꞌin neꞌ xka laꞌa tsuꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Kanꞌ chaꞌ nchkwiꞌ neꞌ chaꞌ ꞌin yuu kanꞌ ni: Niꞌ lyoꞌoo seꞌen ngalu tnen nten, ngwañaꞌan naan yuu kanꞌ ꞌin neꞌ sa bra ni. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ayman Jeremías nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, wa ngwaꞌan yu chaꞌ re chaꞌ ꞌin tñi plata kanꞌ lo kityi, ska chaꞌ nu ka nde loo la: “Kalatyii tñi plata (sa kwa nsuꞌwi lyo ska nten, ndukwin neꞌ Israel taꞌaan). ");
INSERT INTO ctpNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Loꞌo msñi neꞌ tñi kanꞌ, msiꞌi neꞌ ska loꞌoo ꞌin nten nu mñan katunꞌ nu ngwa sꞌni. Kanꞌ ngwa tñan nu ngulo Ni ꞌñaǎn, Ndiose nu nka Xꞌnaan” ndukwin Jeremías. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Chunꞌ ndiꞌin la mdiyan loꞌo neꞌ ꞌin Jesús tloo nu nka gobernador kanꞌ, mnichaꞌ nu lka ndloo kanꞌ ꞌin Jesús bra kanꞌ: ―¿Ti kwiiꞌ lkaa ree ꞌin neꞌ judío a? ―ndukwin nu lka ndloo ꞌin Jesús. ―Ti kwiǐnꞌ lkaǎn ti kwiꞌ sa ñaꞌan nu ndukwiin chaꞌ lkaǎn ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Loꞌo tyun sti joꞌo nu lka ndloo loꞌo yu kula kanꞌ, mstya neꞌ kiꞌya ꞌin Jesús; ja mxkwen ꞌa Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Chunꞌ ndiꞌin la xiyaꞌ ykwiꞌ Pilato loꞌo Jesús bra kanꞌ: ―¿Ta ja ynaan chaꞌ kuxi nu nchkwiꞌ neꞌ kwa ꞌiin a? ―ndukwin nu lka ndloo kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ja mxkwen ꞌa Jesús ꞌin neꞌ; ja ska chaꞌ ykwiꞌ yu, kanꞌ chaꞌ nduwe ꞌa tiꞌ Pilato kanꞌ naꞌan yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nchga yijan bra nu nchka taꞌa kanꞌ, ndlaa nu nka gobernador ꞌin ska presu, ti kwiꞌ presu nu jñan neꞌ judío ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsan kanꞌ, ndiꞌin ska yu kiꞌyu nu naan Barrabás niꞌ ñaꞌan chkwan, ska nten nu ndukwi ꞌa kiꞌya ngwa yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Loꞌo kaꞌan ꞌa neꞌ judío ni, ndyoꞌ tiꞌin neꞌ tuꞌ naꞌan ꞌin gobierno, loꞌo mnichaꞌ Pilato ꞌin neꞌ bra kanꞌ: ―¿Ti lka nchka tiꞌ wan chaꞌ kulaǎn ni a? ¿Ta suꞌwe la lyaa Barrabás a? ¿O ta suꞌwe la lyaa Jesús nu nchkwiꞌ wan chaꞌ lka Krixtu a? ―ndukwin Pilato ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jlyo tiꞌ Pilato, chaꞌ tiꞌí ꞌa tiꞌ neꞌ nu lka ndloo kanꞌ ñaꞌan neꞌ ꞌin Jesús, kanꞌ chaꞌ msuꞌwa neꞌ kanꞌ ꞌin yu niꞌ ñaꞌan chkwan. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ti nduun nten kaꞌan kanꞌ seꞌen ndiꞌin Pilato, loꞌo ti ndukwa Pilato kanꞌ lo yka xlya tnun seꞌen ngiꞌni biyaꞌ yu chaꞌ ꞌin nten. Kanꞌ mdiyan ska msu seꞌen ndukwa yu, ytsaꞌ msu chaꞌ re nu wa ykwiꞌ kwilyoꞌo Pilato: “Ja ska chaꞌ kuꞌnii loꞌo yu kiꞌyu kwa, nten suꞌwe lka yu kwa” ndukwin nu kunaꞌan kanꞌ ꞌin Pilato. “Tyukwi tla lye ꞌa mdaꞌan chaꞌ tiyeěn chaꞌ ꞌin yu kwa. Wa ykwiꞌ slaǎn chaꞌ ꞌin yu kwa.” ");
INSERT INTO ctpNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Nchga sti joꞌo nu lka ndloo loꞌo yu kula kanꞌ, wa ykwiꞌ neꞌ loꞌo nten kaꞌan kanꞌ, chaꞌ jñan neꞌ chabiyaꞌ ꞌin Pilato chaꞌ kulaa yu ꞌin Barrabás nu ndiꞌin niꞌ ñaꞌan chkwan kanꞌ, loꞌo kujwi Pilato ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Chunꞌ ndiꞌin la mnichaꞌ gobernador kanꞌ ꞌin neꞌ kanꞌ xiyaꞌ: ―¿Ti ka kulaǎn sikwa a? ―ndukwin Pilato ꞌin neꞌ. ―ꞌIn Barrabás ―ndukwin nten kaꞌan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","―¿Ni ñaꞌan kuꞌniǐn loꞌo Jesús nu nchkwiꞌ wan chaꞌ nka Krixtu sikwa a? ―ndukwin Pilato bra kanꞌ. ―¡Jwiꞌin kaꞌan wan ꞌin yu lo wsi! ―ndukwin nchga nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","―¿Ni chaꞌ lka nchka tiꞌ wan chaꞌ kujwiǐn ꞌin yu re? ―ndukwin Pilato bra kanꞌ―. ¿Ni kiꞌya ndukwi yu a? Kwen ꞌa msiꞌya loꞌo neꞌ ꞌin Pilato bra kanꞌ: ―¡Jwiꞌin kaꞌan wan ꞌin yu lo wsi! ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bra nu naꞌan Pilato chaꞌ tlá ꞌa ngiꞌni tloo neꞌ, chaꞌ msinꞌ ꞌa tiꞌ neꞌ, jlyo tiꞌ yu chaꞌ ja xlyaa ꞌa neꞌ kunan neꞌ chaꞌ nchkwiꞌ yu loꞌo neꞌ bra kanꞌ. Kanꞌ chaꞌ ngulo yu tñan ꞌin ska msu chaꞌ kan loꞌo msu kanꞌ ska siꞌyuu tyiꞌa. Mnaꞌ yu tloo nchga nten bra kanꞌ. ―Luwi kanun yaǎnꞌ ―ndukwin yu―, chaꞌ siꞌi chaꞌ ꞌñaǎn kaja yu nu ja ska kiꞌya ndukwi re ―ndukwin Pilato ꞌin neꞌ―. Chaꞌ ꞌwan lka chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","―Suꞌwe ―ndukwin nchga nten kanꞌ―. Ni siya kanun kiꞌya chunꞌ ba, nchga ba loꞌo sñiꞌ ba, ndiꞌin chaꞌ kaja yu re. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Loꞌo ngulaa Pilato ꞌin Barrabás kanꞌ, mjiꞌin neꞌ ꞌin Jesús loꞌo ti su. Kwiꞌ ngulo Pilato tñan ꞌin neꞌ sndaru chaꞌ tsaa loꞌo neꞌ ꞌin Jesús bra kanꞌ, chaꞌ jwiꞌin kaꞌan neꞌ ꞌin yu lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Loꞌo sndaru nu nduun kwan seꞌen ndiꞌin gobernador kanꞌ, msñi neꞌ ꞌin Jesús bra kanꞌ, ndyaa loꞌo neꞌ ꞌin yu niꞌ ñaꞌan ꞌin gobierno; ytsaꞌ neꞌ ꞌin nchga sndaru nu ndiꞌin niꞌ ñaꞌan kanꞌ, chaꞌ tyoꞌ tiꞌin neꞌ seꞌen nduun Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Loꞌo ngulo neꞌ steꞌ Jesús, mxkuꞌ neꞌ ska teꞌ ngaꞌa ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kanꞌ mxkwan neꞌ ti kicheꞌ chaꞌ ka ska sneꞌ; mstya neꞌ sneꞌ kanꞌ ke Jesús, kwiꞌ mstya neꞌ ska kii yaꞌ laꞌa seꞌen kwin. Mduun xtyinꞌ neꞌ tloo Jesús bra kanꞌ, chaꞌ xtyi lyoꞌo liyeꞌ tiꞌ neꞌ ꞌin yu; kanꞌ chaꞌ yꞌni neꞌ ngwañaꞌan, sa ñaꞌan si lka yu ska ree lo chalyuu. ―¡Ngiꞌni tnun ba ꞌiin! ¡Nuꞌwin lkaa ree ꞌin neꞌ judío! ―ndukwin sndaru ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Loꞌo msuꞌwa sneꞌ neꞌ tloo Jesús; msñi neꞌ kii kanꞌ, mjiꞌin neꞌ ke Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Bra wa mdyii mstyi lyoꞌo liyeꞌ tiꞌ neꞌ ꞌin yu, bra kanꞌ ngulo neꞌ teꞌ ngaꞌa kanꞌ, xiyaꞌ mxkuꞌ neꞌ nu lka steꞌ ka yu. Mdoꞌo sndaru bra kanꞌ, ndyaa loꞌo neꞌ ꞌin Jesús tuꞌwa kichen chaꞌ jwiꞌin kaꞌan neꞌ ꞌin yu lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tuwiin seꞌen ndyaa neꞌ, ndyukwa taꞌa neꞌ loꞌo ska yu kiꞌyu nu naan Simón bra kanꞌ; neꞌ Cirene lka yu kanꞌ. Kanꞌ ngulo sndaru tñan ꞌin Simón kanꞌ, chaꞌ kwiꞌya yu wsi nu ndiꞌya Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Loꞌo mdiya neꞌ ska lo nten nu naan Gólgota. Nde lka Gólgota chaꞌtñan ꞌñaan: Kiꞌya seꞌen ndiya tijyan ke jyoꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kwiꞌ mda neꞌ mñun mxtiyaaꞌ loꞌo ska tyiꞌa lyaaꞌ chaꞌ koꞌo Jesús; xa nu yiꞌo biyaꞌ yu ꞌin ran, ja mslyaa ꞌa yu koꞌo yu mñun kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Xa wa mstya neꞌ ꞌin yu lo wsi loꞌo klavu, mdiꞌin jya sndaru chaꞌ yaa kanan taꞌa yu ti ka nu kuꞌni kanan steꞌ Jesús bra kanꞌ. Ti kwiꞌ chaꞌ ngwa chaꞌ nu wa ngwaꞌan ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni: “Mtsa neꞌ steěnꞌ loꞌo taꞌa neꞌ laja mdiꞌin jya neꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ti kwiꞌ sndaru kanꞌ mdiꞌin kwan kiyaꞌ wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Mstya neꞌ letra ke wsi nu nchkwiꞌ sa ñaꞌan kiꞌya ndiꞌin ꞌin Jesús: “Yu re lka yu Jesús, ree ꞌin neꞌ judío.” Ngwañaꞌan ngwa letra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ti kwiꞌ tsan kanꞌ mstya neꞌ ꞌin tukwa nten nu wa yꞌni kunan lo tyukwa wsi seꞌen nduun wsi ꞌin Jesús; ska ndukwi laꞌa seꞌen kwin ꞌin Jesús, loꞌo xka ndukwi laꞌa seꞌen kaa ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Loꞌo kaꞌan ꞌa nten mdijin seꞌen nduun wsi kanꞌ, mxtyi lyoꞌo neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Yu re lka nu kuꞌni tyii ꞌin laa tnun ꞌñaan, ndukwin yu; loꞌo ndukwin yu chaꞌ kwiñan yu xka chunꞌ snan tsan ti. Kulaa ꞌin ti ykwiiꞌ ti sikwa ―ndukwin neꞌ kanꞌ ꞌin Jesús―. Si chañi chaꞌ nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose, kiꞌyaa lyaa lo wsi kwa sikwa ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Loꞌo sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo, loꞌo yu kula ꞌin neꞌ judío, nchga neꞌ ndaꞌan naꞌan kwiꞌya neꞌ ꞌin Jesús seꞌen ndukwi yu lo wsi, chaꞌ xtyi lyoꞌo neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ngulaa yu ꞌin xka ta nten; loꞌo ja nchka ꞌin yu kulaa yu ꞌin yu, ti ykwiꞌ ti yu ―ndukwin neꞌ nu lka ndloo kanꞌ―. Ree ꞌin neꞌ Israel lka yu, ndukwin yu. Suꞌwe la si kiꞌya yu lo wsi kwa ni, chaꞌ tsaa ñaꞌan tianꞌ ꞌin yu bra kanꞌ ―ndukwin neꞌ kanꞌ ꞌin taꞌa neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ndiꞌin ta yu ꞌin Ndiose chaꞌ tayaꞌ Ni ꞌin yu, ndukwin yu; suꞌwe la si kulaa Ndiose ꞌin yu ni, si chañi chaꞌ suꞌwe ꞌa nka tiye Ndiose ñaꞌan ꞌin yu, chaꞌ “Sñiꞌ Ndiose lkaǎn” ndukwin yu re. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Loꞌo yu nu yꞌni kunan, taꞌa mstya neꞌ ꞌin yu lo wsi, loꞌo yu kanꞌ mstyi lyoꞌo yu ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Chunꞌ ndiꞌin la ngwa tla chalyuu snan bra; ti ndiꞌya kwan mdyisnan chaꞌ kanꞌ, sa bra wa snan siin mdyii chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ti kwiꞌ bra wa snan siin, kanꞌ kwen ꞌa msiꞌya Jesús: ―Elí, Elí, ¿lama sabactani? ―ndukwin yu. Nde lka chaꞌ kanꞌ chaꞌtñan: Ndiose Stiǐn, Ndiose Stiǐn, ¿ni chaꞌ lka ngulaa yaaꞌ ꞌñaǎn ni? ");
INSERT INTO ctpNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Bra wa ynan nten nu nduun kwiꞌ seꞌen ti, ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―Msiꞌya yu re ꞌin ayman Elías ―ndukwin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Bra ti msnan ska nten ndyaa yꞌya ska kiche, nguchaꞌ yu ꞌin ran loꞌo mñun tiyeꞌ. Loꞌo mskanꞌ yu ꞌin ran lo yka tukwin chaꞌ xtya yu ꞌin ran tuꞌwa Jesús chaꞌ koꞌo yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Loꞌo xka ta nten ndukwin: ―Kataan si chañi chaꞌ kan ayman Elías chaꞌ kulaa ꞌin yu ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Chunꞌ ndiꞌin la, kwen ꞌa msiꞌya Jesús xiyaꞌ; mdoꞌo kasiya ꞌin yu, ngujwi yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti kwiꞌ ti bra mdaaꞌ teꞌ tlyu nu ndukwi loo joꞌo niꞌ lyaa tnun. Nde tukwin ran mdaaꞌ ran; sa kuꞌ ti mdaaꞌ ran, sa la lyuu ndiꞌin ran. Loꞌo tyun kee tnun ngwaꞌa ran, chunꞌ lye ꞌa mñan chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Kwiꞌ ngwañaꞌan, ngalaa kwaa seꞌen mtsiꞌ ayman, loꞌo tyun ayman nu mdiꞌin chaꞌ ꞌin loꞌo Ndiose nu ngwa sꞌni, ndyuꞌu ayman kanꞌ xiyaꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","mdoꞌo neꞌ niꞌ kwaa bra kanꞌ. Chunꞌ ndiꞌin la, xa wa ndyuꞌu Jesús xiyaꞌ, ndyaa neꞌ kanꞌ lo kichen Jerusalén, kichen nu ndiya la tiꞌ Ndiose. Loꞌo tyun nten naꞌan ꞌin neꞌ nu ngwa ayman kanꞌ, chaꞌ wa ndyuꞌu neꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Loꞌo sndaru nu ndiꞌin kwan ꞌin Jesús, loꞌo capitán ꞌin sndaru kanꞌ, yuwe ꞌa tiꞌ neꞌ bra kanꞌ; lye ꞌa ytsen neꞌ xa nu naꞌan neꞌ sa ñaꞌan ngwa chaꞌ kanꞌ, sa ñaꞌan ngwa xa nu lye ꞌa mñan chalyuu. ―Chañi chaꞌ ska ti nu lka Sñiꞌ Ndiose lka ayman re ―ndukwin sndaru kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tyukwi bra nu ngwa chaꞌ kanꞌ, tijyuꞌ ti mduun tyun nu kunaꞌan. Neꞌ taꞌa mdaꞌan Jesús ngwa neꞌ kanꞌ; wa mdoꞌo neꞌ Galilea loꞌo yu chaꞌ mdayaꞌ neꞌ ꞌin yu. Mduun ti nu kunaꞌan kanꞌ, naꞌan kwiꞌya neꞌ ndukwi Jesús lo wsi; ");
INSERT INTO ctpNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","loꞌo Liya Magdalena, loꞌo Liya jyaꞌan Santiago jyaꞌan Se, loꞌo nu lka jyaꞌan sñiꞌ Zebedeo, naꞌan taꞌa neꞌ kanꞌ sa ñaꞌan ngwa ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bra wa msiin la mdiyan ska yu kuliyaꞌ nu naan Se, ska neꞌ kichen Arimatea lka yu. Loꞌo Se kanꞌ yꞌni xaꞌan yu chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ti tsan la wa yaa yu seꞌen ndiꞌin Pilato, mjñan yu chabiyaꞌ chaꞌ tsaa loꞌo yu ꞌin ayman Jesús chaꞌ katsiꞌ. Mda Pilato chabiyaꞌ ꞌin yu bra kanꞌ, ngulo Pilato tñan ꞌin sndaru chaꞌ ta neꞌ ayman kanꞌ ꞌin Se. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Kanꞌ mxiin Se ska teꞌ luwi chunꞌ ayman kanꞌ, ndyaa loꞌo yu ꞌin ayman kanꞌ chaꞌ katsiꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Mtsiꞌ yu ꞌin ayman kanꞌ niꞌ ska tukee nu tka ngulu ti neꞌ siꞌ yuu, chaꞌ ka kwaa seꞌen katsiꞌ ti kwiꞌ Se bra nu kaja yu, mskeꞌ tiꞌ yu. Mdukunꞌ Se tuꞌwa kwaa loꞌo ska kee tlyu, mdoꞌo yu ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Loꞌo Liya Magdalena loꞌo xka Liya, ndukwa neꞌ kwiꞌ seꞌen ti tuꞌwa kwaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Wa ngwa xka tsan ni, wa mdyii yꞌni neꞌ judío tñan ꞌin neꞌ, chaꞌ kuꞌni xuꞌwe neꞌ taꞌa seꞌen nxitñaꞌ neꞌ. Kanꞌ ndyoꞌ tiꞌin nchga sti joꞌo nu lka ndloo loꞌo neꞌ fariseo kanꞌ seꞌen ndiꞌin Pilato bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ykwiꞌ neꞌ loꞌo Pilato bra kanꞌ: ―Yu kula ―ndukwin neꞌ ꞌin Pilato―, nsuꞌwi tiꞌ bare chaꞌ nu ykwiꞌ yu kwiñi kanꞌ xa nu ti luꞌu yu: “Xa mdaꞌa snan tsan, bra kanꞌ tyuꞌuǔn xiyaꞌ” ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kanꞌ chaꞌ suꞌwe la si kulo wan tñan chaꞌ kuꞌni sndaru kwan tuꞌwa kwaa kanꞌ snan tsan, chaꞌ ja ta ꞌa chabiyaꞌ ꞌin neꞌ nu yꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ ja tsaa ꞌa neꞌ kanꞌ kuꞌni neꞌ kunan ꞌin ayman kanꞌ. Ja kaja ñaꞌan chkwiꞌ neꞌ chaꞌ kwiñi chaꞌ wa ndyuꞌu ayman kanꞌ xiyaꞌ bra kanꞌ. Wa msñi nten chaꞌ kwiñi nu ykwiꞌ ayman kanꞌ nu ngwa xkanꞌ; loꞌo ni, si tsaa ñaꞌan tiꞌ nten chaꞌ wa ndyuꞌu ayman kanꞌ xiyaꞌ, tlyu la chaꞌ kwiñi ka si xñi neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Loꞌo mxkwen Pilato ꞌin neꞌ nu lka ndloo kanꞌ bra kanꞌ: ―Ndiya sndaru ꞌwan ―ndukwin Pilato―. Yaa lya wan loꞌo sndaru kanꞌ, chaꞌ tukunꞌ suꞌwe wan tuꞌwa kwaa kanꞌ sa ñaꞌan nu nchka tiꞌ wan, ti ykwiꞌ ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Mdoꞌo neꞌ nu lka ndloo bra kanꞌ, ndyaa neꞌ loꞌo ska ta sndaru ꞌin neꞌ, mdukunꞌ tsaa neꞌ tuꞌwa kwaa kanꞌ loꞌo ska lo kiñaꞌ tla nu yuꞌwi sello ꞌin neꞌ, chaꞌ ja kulo ꞌa nten kee tlyu nu nchkunꞌ tuꞌwa kwaa kanꞌ. Loꞌo ngulo neꞌ tñan ꞌin sndaru kanꞌ, chaꞌ kuꞌni yu kwan tuꞌwa kwaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Xa wa mdyii tsan nu nxitñaꞌ neꞌ, wa kiꞌya ti xaa tsan kulo ꞌin smnan, bra kanꞌ ndyaa Liya Magdalena loꞌo xka Liya kanꞌ, chunꞌ nchka tiꞌ neꞌ ñaꞌan neꞌ seꞌen ngatsiꞌ ayman Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Lye ꞌa mñan chalyuu bra kanꞌ, chaꞌ ngwiꞌya ska angajle ꞌin nu nka Xꞌnaan nu ndiꞌin nde niꞌ kwan, ngwiꞌya lo yuu tuꞌwa kwaa kanꞌ. Kwiꞌ ngulo angajle kanꞌ kee tlyu nu ngwaꞌan tuꞌwa kwaa, ndyaa tukwa chunꞌ kee kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ñaꞌan tiꞌ xaa ndyuwi, ngwañaꞌan ñaꞌan xaa tloo angajle kanꞌ, kwiꞌ lye ꞌa ngaten steꞌ angajle kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Bra nu naꞌan sndaru ꞌin angajle kanꞌ, ytsen ꞌa yu, mchkwan ꞌa yu bra kanꞌ; mlyuu yu lyuu sa ñaꞌan ka si wa ngujwi yu, ngwañaꞌan msu yu chaꞌ ytsen ꞌa yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ykwiꞌ angajle loꞌo nu kunaꞌan kanꞌ bra kanꞌ: ―Ja kutsen wan ―ndukwin ꞌin nu kunaꞌan―. Jlyo tiǎnꞌ chaꞌ ndaꞌan naan wan ꞌin Jesús nu ngujwi lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ja ndiꞌin yu kanꞌ nde re chaꞌ wa ndyuꞌu yu xiyaꞌ, sa ñaꞌan nu ykwiꞌ yu loꞌo wan nu ngwa xkanꞌ. Kan wan, kan naꞌan wan seꞌen yuꞌwi ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Bra wa naꞌan wan, tyaa ytsaꞌ wan chaꞌ re ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kanꞌ: “Ja nsuꞌwi ꞌa ayman kanꞌ niꞌ kwaa re, chaꞌ wa ndyuꞌu yu xiyaꞌ; wa tsaa ti yu Galilea kulo ndukwa la ꞌwan, la kanꞌ ñaꞌan wan ꞌin yu”. Sa kwa ti chaꞌ ndiꞌin chaꞌ katsaǎnꞌ ꞌwan ―ndukwin angajle ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Bra ti mdoꞌo nu kunaꞌan kanꞌ tuꞌwa kwaa, ndyaa neꞌ. Loꞌo suꞌwe ꞌa ngwa tiye neꞌ, ni siya ytsen neꞌ chinꞌ. Msnan neꞌ, ndyaa ytsaꞌ neꞌ ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tuwiin ndyukwa taꞌa Jesús loꞌo nu kunaꞌan kanꞌ, ykwiꞌ yu loꞌo neꞌ. Bra ti mduun xtyinꞌ nu kunaꞌan kanꞌ seꞌen nduun Jesús, msñi neꞌ kiyaꞌ yu, yꞌni tnun neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","―Ja kutsen wan ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―. Tyaa ytsaꞌ lya wan ꞌin taꞌaǎn chaꞌ ndiꞌin chaꞌ tsaꞌaǎn Galilea, la kanꞌ tyukwa taꞌaǎn loꞌo neꞌ. Ngwañaꞌan chkwiꞌ wan loꞌo neꞌ kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Bra nu ndyaa nu kunaꞌan kanꞌ, loꞌo ndyaa sndaru nu mdiꞌin kwan tuꞌwa kwaa kanꞌ; ndyaa neꞌ lo kichen, ndyaa ytsaꞌ neꞌ ꞌin sti joꞌo nu lka ndloo nchga chaꞌ nu ngwa tuꞌwa kwaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Bra ti ndyoꞌ tiꞌin nchga sti joꞌo nu lka ndloo loꞌo nchga yu kula ꞌin neꞌ judío, chaꞌ skanꞌ chaꞌ loꞌo taꞌa neꞌ, sa ñaꞌan chaꞌ chkwiꞌ neꞌ loꞌo nchga nten. Kwiꞌ mda neꞌ nu lka ndloo kanꞌ kaꞌan ꞌa tñi ꞌin sndaru bra kanꞌ, chaꞌ ja chkwiꞌ neꞌ chaꞌ nu ngwa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Nde ñaꞌan chkwiꞌ wan loꞌo nten: “Bra nu yijaꞌ ba tla, bra kanꞌ yan neꞌ nu yꞌni xaꞌan chaꞌ ꞌin ayman Jesús kanꞌ, ngulo mnan neꞌ ꞌin ayman kanꞌ.” Ngwañaꞌan chkwiꞌ wan loꞌo nten ―ndukwin neꞌ nu lka ndloo kanꞌ ꞌin sndaru―. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Loꞌo si kunan gobernador nu lka ndloo ꞌñaan chaꞌ re, bra ti chkwiꞌ ba loꞌo yu chaꞌ ja ta ꞌa yu nu tiꞌí ꞌwan bra kanꞌ. Ngwañaꞌan ykwiꞌ neꞌ nu lka ndloo kanꞌ loꞌo sndaru. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Msñi sndaru tñi bra kanꞌ; mdoꞌo neꞌ ndyaa neꞌ chaꞌ chkwiꞌ neꞌ loꞌo nten sa ñaꞌan tñan nu ndiꞌin chaꞌ chkwiꞌ neꞌ. Kanꞌ chaꞌ sa bra ni, ti ndyaa ñaꞌan tiꞌ neꞌ judío chaꞌ ngwañaꞌan ngwa ꞌin ayman Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Chunꞌ ndiꞌin la mdoꞌo tii xka neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, ndyaa neꞌ nde lo yuu ꞌin Galilea; ndyoꞌ tiꞌin neꞌ lo kiꞌya seꞌen ndukwin Jesús chaꞌ tyukwa taꞌa neꞌ loꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Bra nu naꞌan neꞌ ꞌin Jesús chaꞌ ndijyan yu seꞌen ndiꞌin neꞌ, bra kanꞌ yꞌni tnun neꞌ ꞌin yu, ni siya ndiꞌin chinꞌ taꞌa neꞌ nu ja ya tsaa ñaꞌan suꞌwe tiꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Mdiyan Jesús kwiꞌ seꞌen la, ykwiꞌ loꞌo neꞌ bra kanꞌ: ―Wa mda Stiǐn Ndiose nchga chabiyaꞌ ꞌñaǎn chaꞌ lkaǎn ndloo ꞌin nchga nan, ni siya nchga nan nu nsuꞌwi seꞌen ndiꞌin Ni nde niꞌ kwan, ni siya nchga nan nu nsuꞌwi lo chalyuu ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yaa wan nchga kichen lo chalyuu chaꞌ kuꞌni xaꞌan nchga nten chaꞌ ꞌñaǎn. Kwiꞌ tukwatya wan ꞌin neꞌ chabiyaꞌ ꞌin Stiǐn Ndiose, ngwañaꞌan chabiyaꞌ nu ndiꞌin ꞌñaǎn chaꞌ lkaǎn Sñiꞌ Ni, kwiꞌ ngwañaꞌan chabiyaꞌ ꞌin Tyiꞌi Ndiose tukwatya wan ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Kwaꞌu wan ꞌin neꞌ kanꞌ, chaꞌ kuꞌni neꞌ nchga tñan nu wa ngwaꞌuǔn ꞌwan. Loꞌo tyuꞌwi tiꞌ wan chaꞌ nu ykwiǐnꞌ loꞌo wan, chaꞌ naꞌ lkaǎn nu tyiꞌiǐn loꞌo wan nchga tsan sa ñaꞌan yaꞌ nu tsaa tii chalyuu. Sa kwa ti chaꞌ ykwiꞌ Jesús.");
INSERT INTO ctpNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nde ndaꞌaǎn chaꞌ nu lka suun chaꞌ suꞌwe ꞌin Jesucristo, ska ti nu lka Sñiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ayman Isaías, nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose nu ngwa sꞌni, ngwaꞌan yu lo kityi sa ñaꞌan nu ka tyisnan chaꞌ re. Nde lka chaꞌ nu ngwaꞌan yu kanꞌ: Kuloǔn tñan ꞌin ska nten nu ka skan ꞌñaǎn, ndukwin Ndiose ꞌin Krixtu, chaꞌ tsaa yu kulo ndukwa la. Kanꞌ lka nu slaa tuwiin seꞌen tsaa, ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kwen xiꞌya yu niꞌ kixinꞌ. Nde lka chaꞌ nu chkwiꞌ yu loꞌo nten: “Slaa lya wan ska tuwiin seꞌen kan nu lka Xꞌnaan; xñi suꞌwe wan tuwiin seꞌen tyijin ykwiꞌ”. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Sa ñaꞌan chaꞌ nu ngwaꞌan Isaías kanꞌ, ngwañaꞌan ndyoꞌo tukwa Xuwa niꞌ kixinꞌ seꞌen ja ndiꞌin nten. Kanꞌ ykwiꞌ yu loꞌo nten chaꞌ ka jyuꞌu tiꞌ neꞌ ꞌin nchga chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, chaꞌ kulaa yaꞌ neꞌ chaꞌ kuxi kanꞌ, chaꞌ ngwañaꞌan kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ. Bra kanꞌ tukwatya Xuwa ꞌin neꞌ kanꞌ, ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin Xuwa kanꞌ; ndijyan neꞌ kichen xuwe ti nu ndiꞌin lo yuu ꞌin Judea, loꞌo ndijyan neꞌ Jerusalén nu lka kichen tnun kanꞌ seꞌen ndiꞌin yu. Nten nu mjyuꞌu ꞌa tiꞌ ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, mjñan neꞌ ꞌin Ndiose chaꞌ kuꞌni tyii Ni chaꞌ kuxi kanꞌ, loꞌo mdukwatya Xuwa ꞌin neꞌ kanꞌ lo tyiꞌa chku Jordán bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Loꞌo Xuwa kanꞌ, lkuꞌ yu ska teꞌ kichanꞌ camello, loꞌo nchkanꞌ kijin siꞌ yu. Nchku yu skuꞌ loꞌo kwiñaꞌ kwitun. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nde lka chaꞌ nu ykwiꞌ yu loꞌo nten kanꞌ: ―Ndiya ska nten nu wa kan ti; wa msuꞌwa yu ꞌñaǎn chaꞌ ndijyaǎn ndla la, ni siya yu kanꞌ lka ndloo la ―ndukwin Xuwa ꞌin neꞌ―. Loꞌoǔn, kuꞌniǐn tnuǔn ꞌin yu kanꞌ; suꞌwe ꞌa ka tiyeěn ni siya xtiǐnꞌ ti nu ndukwa snan yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Loꞌo tyiꞌa ti ndukwatyaǎn ꞌwan; yu kanꞌ ni, ja tukwatya ꞌa yu ꞌin nten loꞌo tyiꞌa ti, kuꞌni yu chaꞌ kanun Tyiꞌi Ndiose niꞌ kasiya ꞌin neꞌ chaꞌ ka luwi neꞌ siyaꞌ ti, bra nu tukwatya yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Xka tsan la tiyaꞌ la chinꞌ, mdoꞌo Jesús kichen Nazaret nde lo yuu ꞌin Galilea, ndyaa yu seꞌen ndiꞌin Xuwa nde tuꞌwa chku Jordán. Bra kanꞌ mdukwatya Xuwa ꞌin Jesús lo tyiꞌa chku kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Bra wa tyoꞌo ti Jesús lo tyiꞌa, bra kanꞌ naꞌan yu chaꞌ wa ngalaa tuwiin nde niꞌ kwan. Bra kanꞌ ngwiꞌya Tyiꞌi Ndiose seꞌen nduun Jesús; sa ñaꞌan ndukwi ska kiñi cha kuun, ngwañaꞌan ngwiꞌya Tyiꞌi Ndiose chunꞌ Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Loꞌo ynen ykwiꞌ Ndiose seꞌen ndiꞌin Ni nde niꞌ kwan bra kanꞌ. Nde lka chaꞌ nu ykwiꞌ Ni: ―Ska ti nu lka Sñiěnꞌ lka yu re, loꞌo suꞌwe ꞌa lka tiyeěn ñaꞌaǎn ꞌin yu ―ndukwin Ndiose chaꞌ ꞌin Jesús. ―Ndiya ꞌa tiǎnꞌ ꞌin yu ―ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Loꞌo bra ti ndyaa loꞌo Tyiꞌi Ndiose ꞌin Jesús niꞌ kixinꞌ seꞌen ja ndiꞌin nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tuꞌwa tsan ngunun Jesús ska ti yu niꞌ kixinꞌ bra kanꞌ, mdiꞌin yu loꞌo ꞌni tlá niꞌ kixinꞌ. Kanꞌ mdiyan Satanás seꞌen ndiꞌin yu, ngwa tiꞌ kwiñi lyoꞌo ꞌin Jesús si kuꞌni yu chaꞌ kuxi. Xa wa mdyii chaꞌ kanꞌ, mdiyan angajle seꞌen ndiꞌin Jesús chaꞌ tayaꞌ ꞌin yu, chaꞌ talo yu la chinꞌ seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Chunꞌ ndiꞌin la msuꞌwa neꞌ ꞌin Xuwa niꞌ ñaꞌan chkwan. Bra kanꞌ yan Jesús nde lo yuu ꞌin Galilea, ngwaꞌu yu ꞌin neꞌ sa ñaꞌan lka chaꞌ suꞌwe ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","―Wa ndiya bra chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús―. Ka jyuꞌu tiꞌ wan ꞌin nchga chaꞌ kuxi nu ndiꞌin ꞌwan; kulaa yaꞌ wan chaꞌ kuxi kanꞌ, chaꞌ ka xñi wan chaꞌ suꞌwe ꞌin Ndiose nu kulaa ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ngwa ska tsan nu mdaꞌan Jesús tuꞌwa tiyuꞌ Galilea. Bra kanꞌ naꞌan yu ꞌin Simón, loꞌo Ndre taꞌa ngula Simón; mdaꞌan neꞌ kuta kula loꞌo katan, chaꞌ kanꞌ lka tñan nu ngiꞌni neꞌ kanꞌ nchga tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ykwiꞌ Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Tsaa wan loꞌoǔn ―ndukwin Jesús ꞌin neꞌ―. Xka tñan kwaꞌuǔn ꞌwan ni, chaꞌ tsaa naan wan ꞌin nten chalyuu nu mnaꞌ kasiya ꞌin siꞌya chaꞌ kuxi nu ngiꞌni neꞌ, chaꞌ ka neꞌ kanꞌ nten ꞌñaǎn ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ynan neꞌ, loꞌo bra ti mxnun neꞌ katan ꞌin neꞌ, mdoꞌo neꞌ mdaꞌan neꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chunꞌ ndiꞌin la chinꞌ mdijin Jesús, naꞌan yu taꞌa tyukwaa sñiꞌ Zebedeo nu naan Santiago loꞌo Xuwa. Mdiꞌin neꞌ niꞌ yka naꞌan xuwe ti, ngiꞌni xuꞌwe neꞌ katan ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Loꞌo msiꞌya Jesús ꞌin neꞌ chaꞌ tsaa neꞌ loꞌo yu bra kanꞌ. Bra ti mxnun neꞌ ꞌin Zebedeo sti neꞌ, nganun yu kula kanꞌ loꞌo msu ꞌin neꞌ loꞌo yka naꞌan xuwe ti. Mdoꞌo taꞌa tyukwaa sñiꞌ yu kula kanꞌ ndyaa neꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Chunꞌ ndiꞌin la ngala taꞌa neꞌ kichen Capernaum. Xa nu ngwa tsan taꞌa nu nxitñaꞌ neꞌ judío, bra kanꞌ ndyaa Jesús niꞌ lyaa ꞌin neꞌ chaꞌ kwaꞌu yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Bra nu ynan neꞌ, yuwe ꞌa tiꞌ neꞌ sa ñaꞌan lka chaꞌ nu ngwaꞌu Jesús ꞌin neꞌ. Mskeꞌ tiꞌ neꞌ chaꞌ tlyu ꞌa chabiyaꞌ nsuꞌwi ꞌin yu, chaꞌ siꞌi sa ñaꞌan nchkwiꞌ mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa nchkwiꞌ yu loꞌo nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ti kwiꞌ niꞌ lyaa kanꞌ mdiꞌin ska yu kiꞌyu nu nsuꞌwi kwiꞌin kuxi ꞌin. Msiꞌya ꞌa yu ꞌin Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿Ni sa ñaꞌan chaꞌ nchka tiiꞌ chkwiiꞌ loꞌoǔn?, Jesús Nazaret ―ndukwin yu tiꞌí kanꞌ―. ¿Ta wa nchka tiiꞌ kuꞌnii tyii chaꞌ ꞌñaǎn a? ―ndukwin―. Nsuꞌwi lyoǔn ꞌiin. Xkwiꞌ luwi lka nuꞌwin, loꞌo Ndiose msuꞌwa ꞌiin chaꞌ ndijyaan lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Loꞌo ja mda ꞌa Jesús chabiyaꞌ ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin yu tiꞌí kanꞌ, ngulo yu ꞌin kwiꞌin kuxi kanꞌ chaꞌ tyaa siyaꞌ ti bra kanꞌ. ―¡Ja chkwiiꞌ ꞌa! ―ndukwin Jesús ꞌin kwiꞌin kanꞌ―. ¡Ja kuꞌnii ꞌa chaꞌ kuxi loꞌo yu re! ");
INSERT INTO ctpNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Bra ti mxlyuu kwiꞌin kuxi kanꞌ ꞌin yu tiꞌí. Kwen msiꞌya yu xa mdoꞌo kwiꞌin kanꞌ, ndyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ytsen ꞌa nchga nten bra kanꞌ. Ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―¿Ni sa ñaꞌan lka chaꞌ re a? ―ndukwin neꞌ―. ¿Ta xka chaꞌ kwi nduꞌu yu kwa ꞌin nten a? ―ndukwin neꞌ―. Nchka ꞌin yu kwa kulo yu tñan ꞌin kwiꞌin kuxi, loꞌo ndukwa kwiꞌin kanꞌ chaꞌ nchkwiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Bra ti nganen chaꞌ ꞌin Jesús nchga kichen nde lo yuu ꞌin Galilea bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Chunꞌ ndiꞌin la mdoꞌo Jesús niꞌ lyaa kanꞌ loꞌo Santiago loꞌo Xuwa, ndyaa neꞌ la naꞌan tyi Simón loꞌo Ndre. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Loꞌo ytsaꞌ neꞌ ꞌin Jesús chaꞌ tiꞌí ꞌa jyaꞌan laa Simón bra kanꞌ; tlyu ꞌa tikeeꞌ nsuꞌwi ꞌin neꞌ kula kanꞌ, nskwa ti lo kiꞌyan. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kanꞌ ndyaa Jesús seꞌen ndiꞌin nu tiꞌí kanꞌ, msñi yu yaꞌ chaꞌ tayaꞌ yu ꞌin tyituun. Bra ti mdoꞌo tikeeꞌ ꞌin neꞌ kula kanꞌ, mdyisnan yꞌni kuwe tiꞌ chaꞌ kaja chinꞌ nan ku neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wa msiin ꞌa bra kanꞌ, loꞌo bra wa ndyaa kwichaa, yan loꞌo nten ꞌin nchga neꞌ tiꞌí seꞌen ndiꞌin Jesús, loꞌo nten nu msñi kwiꞌin kuxi ꞌin, loꞌo nten nu nsuꞌwi xka lo kicha ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nchga nten kichen kanꞌ, wa ndyoꞌ tiꞌin neꞌ tuꞌ naꞌan tyi Simón bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yꞌni Jesús joꞌó ꞌin neꞌ kanꞌ, ni siya kaꞌan lo kicha nsuꞌwi ꞌin neꞌ; loꞌo nten nu msñi kwiꞌin kuxi ꞌin, nchkaa neꞌ chunꞌ ngulo Jesús kwiꞌin kanꞌ. Ja mda ꞌa Jesús chabiyaꞌ chkwiꞌ kwiꞌin kuxi kanꞌ, chunꞌ wa nsuꞌwi lyo kwiꞌin kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ja ya kiꞌya xaa la xka tsan, bra kanꞌ mdyituun Jesús, mdoꞌo yu ndyaa yu chinꞌ nde niꞌ kixinꞌ seꞌen tiin ndiꞌin chalyuu, chaꞌ chkwiꞌ yu loꞌo Ndiose nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón loꞌo xka taꞌa ndaꞌan yu, ndyaa neꞌ ndyaa naan neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Xa wa mdyija lyo Jesús ꞌin neꞌ, bra kanꞌ ndukwin neꞌ ꞌin yu: ―Ndyaa naan ꞌa neꞌ ꞌiin ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","―Ni siya ndyaa naan neꞌ ꞌñaǎn nde re, ti ndiꞌin chaꞌ tsaꞌaǎn nchga kichen ―ndukwin Jesús ꞌin neꞌ―. Loꞌo ꞌin neꞌ xka kichen ndiꞌin chaꞌ kwaꞌuǔn chaꞌ suꞌwe nu ꞌñaǎn ―ndukwin yu―. Kanꞌ tñan ndiꞌin chaꞌ kuꞌniǐn lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Kanꞌ chaꞌ mdoꞌo neꞌ ndyaa neꞌ loꞌo yu bra kanꞌ. Nchga kichen seꞌen mdaꞌan Jesús nde Galilea kanꞌ, ndyaa yu niꞌ lyaa ꞌin neꞌ, chaꞌ kwaꞌu yu ꞌin nten. Loꞌo ngulo yu kwiꞌin kuxi nu msñi ꞌin neꞌ, chaꞌ chkaa neꞌ tiꞌí nu nsuꞌwi kwiꞌin ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Loꞌo ngwa ska tsan mdiyan ska nu tiꞌí seꞌen ndiꞌin Jesús, ska yu nu ngutsuꞌ kunaꞌ siꞌya kicha nu msñi ꞌin yu. Bra kanꞌ mduun xtyinꞌ yu tiꞌí kanꞌ seꞌen ndiꞌin Jesús, ykwiꞌ yu loꞌo: ―Si nchka tiꞌ wan chaꞌ chkaǎn, jlyo tiǎnꞌ chaꞌ ka ꞌwan kuꞌni wan chaꞌ chkaǎn ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ngwa tꞌnan tiꞌ Jesús ꞌin yu tiꞌí kanꞌ bra kanꞌ, mlaꞌ yu kunaꞌ yu tiꞌí kanꞌ seꞌen ngutsuꞌ. ―Xlyaǎn, kuꞌniǐn joꞌó ꞌiin ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ―. Kanun luwi kunaaꞌ ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Bra ti nchkaa seꞌen ngutsuꞌ kunaꞌ yu; ngwa luwi kunaꞌ yu, chaꞌ wa mdyii kicha kanꞌ ꞌin yu siyaꞌ ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Bra nu mslaaꞌ Jesús loꞌo yu kanꞌ, bra kanꞌ lye ꞌa ykwiꞌ loꞌo yu nu ngwa tiꞌí kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ja katsaaꞌ ꞌa ꞌin nten chaꞌ naꞌ yꞌniǐn joꞌó ꞌiin ―ndukwin Jesús ꞌin yu nu ngwa tiꞌí kanꞌ―. Yaa lyaa seꞌen ndiꞌin sti joꞌo chaꞌ taa lomstan ꞌin Ndiose nu yꞌni chaꞌ nchkaa. Taa lomstan, sa kwa lomstan nu ykwiꞌ ayman Moisés sꞌni chaꞌ taan ꞌin Ndiose bra nu ngwa luwi kunaanꞌ. Ngwañaꞌan ka biyaꞌ tiꞌ nchga nten chaꞌ wa nchkaa, bra nu ñaꞌan neꞌ chaꞌ xñi sti joꞌo lomstan nu taa. ");
INSERT INTO ctpNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ja ynan suꞌwe yu nu ngwa tiꞌí kanꞌ. Mdoꞌo yu ndyaa yu ykwiꞌ yu loꞌo nchga nten sa ñaꞌan ngwa chaꞌ nchkaa yu, kanꞌ chaꞌ ja ngwa ꞌa ꞌin Jesús tyoꞌo taꞌan lo kichen; nganun yu niꞌ kixinꞌ ti seꞌen ja ndiꞌin nten. Loꞌo kaꞌan ꞌa nten mdaꞌan seꞌen ndiꞌin yu, ni siya tijyuꞌ kichen tyi neꞌ, mdoꞌo neꞌ ndyaa neꞌ seꞌen ndiꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wa mdijin chinꞌ tsan mxitukwi Jesús ndyaa nde kichen Capernaum kanꞌ xiyaꞌ. Bra ti nganen chaꞌ ñaꞌaan kichen chaꞌ wa ngala yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kanꞌ kaꞌan ꞌa nten mdyoꞌ tiꞌin seꞌen ndiꞌin yu; ja ngalaa ꞌa niꞌ ñaꞌan seꞌen tyiꞌin neꞌ, kwiꞌ ngwañaꞌan tsaa ꞌa ndiꞌin nten chunꞌ naꞌan. Loꞌo ngwaꞌu Jesús chaꞌ suꞌwe ꞌin Ndiose ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Loꞌo mdiyan jakwa nten bra kanꞌ, ngwiꞌya neꞌ ska yu tiꞌí nu nchkunꞌ ñaꞌaan tyukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ja ngwa tiyan neꞌ seꞌen ndiꞌin Jesús loꞌo yu tiꞌí kanꞌ, chaꞌ tsaa ꞌa ndiꞌin nten; kanꞌ chaꞌ mskwen neꞌ ke naꞌan loꞌo yu tiꞌí kanꞌ. Lkwa ke naꞌan kanꞌ, loꞌo mslaa neꞌ ke naꞌan seꞌen ndiꞌin Jesús chaꞌ sten katan seꞌen nskwa yu tiꞌí bra kanꞌ. Kanꞌ mbiꞌya neꞌ ꞌin katan nde seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Bra nu naꞌan Jesús chaꞌ ndyaa ñaꞌan ꞌa tiꞌ neꞌ kwa ꞌin yu, bra kanꞌ ykwiꞌ yu loꞌo yu tiꞌí kanꞌ: ―Wa yꞌniǐn chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndiꞌin ꞌiin, sñiěnꞌ ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Loꞌo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa nu mdiꞌin niꞌ ñaꞌan kanꞌ, yuwe ꞌa tiꞌ neꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ni chaꞌ ykwiꞌ yu re ngwañaꞌan?” mskeꞌ tiꞌ neꞌ kanꞌ. “Ska ti Ndiose ka kuꞌni Ni chaꞌ tlyu tiꞌ ꞌin nten nu ndukwi kiꞌya. Ska kiꞌya tnun lka chaꞌ ykwiꞌ yu kiꞌyu re chaꞌ kuꞌni tyii yu kiꞌya nu ndiꞌin ꞌin ska nten chalyuu, chaꞌ ja tukwin nchka ꞌin kuꞌni tyii kiꞌya nu ndiꞌin ꞌin nten.” ");
INSERT INTO ctpNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ngwiꞌya Jesús kwenta sa ñaꞌan lka chaꞌ nu ndaꞌan tiye neꞌ, kanꞌ chaꞌ ykwiꞌ yu loꞌo mstru kanꞌ bra kanꞌ: ―¿Ni sa ñaꞌan chaꞌ kuxi ndaꞌan chaꞌ tiye wan seꞌen ndiꞌin wan a? ―ndukwin Jesús ꞌin mstru kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ja ndiya tiꞌ wan chaꞌ nu wa mxkweěn ꞌin yu tiꞌí re: “Wa yꞌniǐn chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndukwii.” ¿Ta suꞌwe la chkwiǐnꞌ xka chaꞌ re loꞌo yu tiꞌí sikwa a?: “Tyituun, tyaa loꞌo katan ꞌiin naꞌan tyii” ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Suꞌwe sikwa. Nchka tiǎnꞌ chaꞌ ka biyaꞌ tiꞌ wan chaꞌ ndiya chabiyaꞌ ꞌñaǎn chaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin nten chalyuu nu ndukwi kiꞌya; ndiya chabiyaꞌ ꞌñaǎn, chunꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn lo chalyuu chaꞌ kaǎn nten. Ka biyaꞌ tiꞌ wan bra nu ñaꞌan wan chaꞌ chkaa yu tiꞌí re ni ―ndukwin Jesús. Loꞌo xiyaꞌ ykwiꞌ yu loꞌo yu tiꞌí bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Kuloǔn tñan ꞌiin ni ―ndukwin Jesús ꞌin yu―. Tyituun, tsaa loꞌo katan ꞌiin naꞌan tyii. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Bra ti mdyituun nu tiꞌí kanꞌ, msñi katan ꞌin, mdoꞌo ndyaa bra kanꞌ. Naꞌan nchga nten chaꞌ mdoꞌo nu ngwa tiꞌí kanꞌ ndyaa loꞌo katan ꞌin. Loꞌo yuwe ꞌa tiꞌ neꞌ bra kanꞌ, yꞌni tnun neꞌ ꞌin Ndiose chaꞌ ngwa chaꞌ tnun kanꞌ: ―Ja ska yaꞌ ñaꞌan ba ska chaꞌ tnun sa ñaꞌan nu yꞌni yu ni ―ndukwin neꞌ ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa yu nde tuꞌwa tiyuꞌ kanꞌ xiyaꞌ. Loꞌo mdyoꞌ tiꞌin kaꞌan nten seꞌen ndiꞌin yu bra kanꞌ, kanꞌ chaꞌ xiyaꞌ ngwaꞌu yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Laja nu mdaꞌan Jesús lo kichen, mdijin yu ska naꞌan seꞌen ndiya Leví sñiꞌ Alfeo bra kanꞌ; ndukwa yu ndlo yu tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ nu lka ndloo la. ―Tsaa loꞌoǔn ―ndukwin Jesús ꞌin Leví kanꞌ. Bra ti mdyituun Leví, mdyisnan yu ndaꞌan yu loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Chunꞌ ndiꞌin la ndyaa yku Jesús naꞌan tyi Leví kanꞌ. Suꞌwa nchku yu loꞌo tyun nten kuxi, loꞌo tyun neꞌ taꞌa ngiꞌni Leví tñan nu kaꞌan ꞌa tñi ndlo ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ kanꞌ; kaꞌan ꞌa neꞌ kanꞌ nchka tiꞌ neꞌ kunan neꞌ chaꞌ nu nchkwiꞌ Jesús. Mdiꞌin Jesús niꞌ ñaꞌan kanꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ nu nduꞌu yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Loꞌo mdiyan chinꞌ neꞌ fariseo bra kanꞌ, loꞌo mstru nu nduꞌu chaꞌ joꞌo taꞌa ndaꞌan yu fariseo kanꞌ. Kti ꞌa chaꞌ ꞌin neꞌ, nxkeꞌ tiꞌ neꞌ; lye ꞌa ngiꞌni siyeꞌ neꞌ kanꞌ ꞌin nten. Naꞌan neꞌ kanꞌ ti ka nu lka ndiꞌin nchku loꞌo Jesús niꞌ ñaꞌan kanꞌ, loꞌo ja ndiya tiꞌ neꞌ chaꞌ kanꞌ. Kanꞌ chaꞌ bra ti ykwiꞌ neꞌ loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús: ―¿Ni chaꞌ nchku xꞌnan wan loꞌo nten kuxi kwa? Loꞌo msu ꞌin neꞌ xka laꞌa tsuꞌ nu kaꞌan ꞌa tñi ndlo ꞌñaan re ndiꞌin loꞌo yu nde kwa ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Chaꞌ wa ynan Jesús chaꞌ nu ykwiꞌ neꞌ nu tnun nchka kanꞌ, kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Ja ndiꞌin chaꞌ ka joꞌó ꞌin nten nu suꞌwe ti ―ndukwin Jesús ꞌin neꞌ―, ka joꞌó ꞌin neꞌ tiꞌí ―ndukwin yu―. Loꞌoǔn ni, ja ndijyaǎn lo chalyuu chaꞌ kwaꞌuǔn chaꞌ suꞌwe ꞌin Ndiose ꞌin nten nu nxkeꞌ tiꞌ chaꞌ nten suꞌwe lka neꞌ; nan wa ndijyaǎn chaꞌ kwaꞌuǔn chaꞌ suꞌwe kanꞌ ꞌin nten nu jlyo tiꞌ chaꞌ ndiꞌin kiꞌya ꞌin neꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wa mdiya ska tsan kti ꞌin neꞌ nu yꞌni xaꞌan chaꞌ ꞌin Xuwa loꞌo ꞌin neꞌ fariseo, nu kti ꞌa chaꞌ ꞌin neꞌ. Ja nchku neꞌ tyaja tsan kti kanꞌ. Loꞌo mdiyan chinꞌ nten seꞌen ndiꞌin Jesús, ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―Ja nchku ꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Xuwa tsan ni. Kwiꞌ ngwañaꞌan neꞌ fariseo, ja nchku neꞌ ni ―ndukwin neꞌ―. Loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin ni, nchku neꞌ. ¿Ni chaꞌ ja suꞌwa ngiꞌni nten ꞌiin loꞌo neꞌ fariseo kanꞌ? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Bra nu kaja kwilyoꞌo nten, loꞌo nten nu ndaꞌan loꞌo nu kiꞌyu kuxiin nchku neꞌ; ja ndiꞌin chaꞌ tyiꞌin kuꞌnan ꞌin neꞌ tsan nu ndiꞌin neꞌ loꞌo kuxiin ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Suꞌwe ꞌa nka tiye neꞌ ndiꞌin neꞌ loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bra nu tiya tsan nu tyaa loꞌo nten ꞌin nu kiꞌyu kuxiin, bra kanꞌ tyiꞌin kuꞌnan ꞌin neꞌ taꞌa suꞌwe nsuꞌwi kuxiin, chaꞌ xiꞌin tiꞌ neꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan, suꞌwe ꞌa nka tiye taꞌa suꞌweěn nsuꞌwiǐn ni, ni siya ka xiꞌin tiꞌ neꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Xka chaꞌ ni, nten nu nxkwan teꞌ, nu kuꞌni xuꞌwe teꞌ kusun, ja xuꞌwi neꞌ sa yuꞌwe teꞌ tiji lo ska teꞌ kusun, chaꞌ ngatiꞌ la teꞌ tiji; bra ti tyiꞌiin ran, tyaaꞌ seꞌen nchkwan ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ti kwiꞌ ti chaꞌ, ja suꞌwa neꞌ xalyu nu tka mdoꞌo ti niꞌ chkaꞌ kula. Si suꞌwa neꞌ ꞌin ran niꞌ chkaꞌ kula, ndla ti katsu siꞌ chkaꞌ kanꞌ; tyii chkaꞌ kwaꞌa bra kanꞌ, tyii xalyu kalu bra kanꞌ. Niꞌ chkaꞌ tiji xuꞌwi xalyu nu tka mdoꞌo ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wa mdiya ska tsan taꞌa nu nxitñaꞌ neꞌ judío. Tsan kanꞌ mdijin Jesús seꞌen ndiya jyan trigu ꞌin neꞌ, ndyaa yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ nu nduꞌu yu. Loꞌo mxtun neꞌ nu ngiꞌni xaꞌan kanꞌ chinꞌ mta trigu chaꞌ ku neꞌ seꞌen ndaꞌan neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Loꞌo naꞌan neꞌ fariseo sa ñaꞌan nu yꞌni neꞌ kanꞌ. Bra ti ykwiꞌ neꞌ fariseo kanꞌ loꞌo Jesús: ―Tsan taꞌa, tsan nxitñaanꞌ lka ni ―ndukwin neꞌ fariseo ꞌin Jesús―. Tsan kti lka. ¿Ni chaꞌ ngiꞌni neꞌ kanꞌ tñan nu ja nsuꞌwi chabiyaꞌ kuꞌnian tsan ni? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―¿Ja ya ñaꞌan wan lo kityi ꞌin Ndiose seꞌen ngwaꞌan neꞌ sa ñaꞌan nu yꞌni ayman David a? Wa mdiya ska tsan ngiteꞌ ꞌa tiꞌ yu, loꞌo ngiteꞌ ꞌa tiꞌ taꞌa ndaꞌan yu ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ngwa ayman Abiatar ndloo la ꞌin nchga sti joꞌo bra kanꞌ, loꞌo bra kanꞌ yten ayman David kanꞌ niꞌ ñaꞌan nu kti ꞌa ꞌin Ndiose nde kwa, msñi yu jaxlya nu lka lomstan ꞌin Ndiose, nu ndukwa lo msaa kti nde kwa; yku neꞌ jaxlya kanꞌ, ni siya ska ti sti joꞌo nsuꞌwi chabiyaꞌ ku ran ―ndukwin Jesús ꞌin neꞌ fariseo kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","’Ja ngwa tiꞌ Ndiose ta Ni nu tiꞌí ꞌñaan chunꞌ nu ykwiꞌ Ni chaꞌ ka ska tsan nu xitñaanꞌ; suꞌwe la tyiꞌian xa nu kaja ska tsan nu xitñaanꞌ, ngwa tiye Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Loꞌo ngwañaꞌan, nsuꞌwi chabiyaꞌ ꞌñaǎn chaꞌ lkaǎn ndloǔn ꞌin tsan nu nxitñaꞌ neꞌ, chaꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Xiyaꞌ ndyaa Jesús niꞌ lyaa la kanꞌ tsan nu nxitñaꞌ neꞌ, loꞌo mdiꞌin ska yu tiꞌí nu nchkunꞌ ska laꞌa tsuꞌ yaꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Naꞌan kwiꞌya ꞌa nten nu kti chaꞌ ꞌin, neꞌ fariseo kanꞌ, naꞌan ꞌa neꞌ ꞌin Jesús si kuꞌni yu joꞌó ꞌin yu tiꞌí kanꞌ, ni siya tsan taꞌa nu nxitñaꞌ neꞌ judío ngwa. Ngwa tiꞌ neꞌ nu tnun nchka kanꞌ tyija lyo kiꞌya chaꞌ xtya neꞌ chunꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Kanꞌ ykwiꞌ Jesús loꞌo yu tiꞌí kanꞌ: ―Kaan, tyuun tukwii tloo bare ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Bra kanꞌ mnichaꞌ Jesús ꞌin nchga nten kanꞌ: ―¿Ta nsuꞌwi chabiyaꞌ ꞌñaan kuꞌnian ska chaꞌ suꞌwe tsan nu nxitñaꞌ nten a? ―ndukwin yu ꞌin neꞌ―. ¿Ta suꞌwe la si kuꞌnian ska chaꞌ kuxi tsan kanꞌ a? ―ndukwin yu―. ¿Ta ja suꞌwe kuꞌnian joꞌó ꞌin nten bra kanꞌ, nxkeꞌ tiꞌ wan a? ¿Ta suꞌwe la si taan chabiyaꞌ kaja neꞌ tiꞌí tsan kanꞌ sikwa a? ―ndukwin Jesús. Ja mjwi la chaꞌ xkwen neꞌ nu tnun nchka kanꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Msinꞌ tiꞌ Jesús ñaꞌan yu ꞌin neꞌ kanꞌ, kwiꞌ ngwa xiꞌin chinꞌ tiꞌ yu chaꞌ ja xlyaa neꞌ kiꞌya neꞌ kwenta ꞌin chaꞌ nu nduꞌu yu ꞌin nten. Ykwiꞌ yu loꞌo yu tiꞌí bra kanꞌ: ―Tukwii lyaa yaaꞌ ―ndukwin Jesús ꞌin yu. Mdukwi ñi yu yaꞌ yu bra kanꞌ, loꞌo bra ti nchkaa yaꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Bra nu mdoꞌo neꞌ fariseo niꞌ lyaa kanꞌ bra kanꞌ, ndyaa ykwiꞌ neꞌ loꞌo xka ta nten nu ꞌin ree Herodes; ykwiꞌ neꞌ sa ñaꞌan ka kuꞌni neꞌ chaꞌ kujwi neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Loꞌo ndyaa Jesús tuꞌwa tiyuꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. Kaꞌan ꞌa neꞌ Galilea ndyaa ñaꞌan neꞌ ꞌin yu chaꞌ kunan neꞌ chaꞌ nu nduꞌu yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Loꞌo nten nu ndiꞌin kichen tijyuꞌ wa ynan neꞌ sa ñaꞌan chaꞌ tnun nu yꞌni Jesús. Kanꞌ chaꞌ loꞌo neꞌ tijyuꞌ mdiyan neꞌ chaꞌ ñaꞌan kwiꞌya neꞌ ꞌin yu; mdiyan neꞌ Judea, loꞌo neꞌ Jerusalén, loꞌo neꞌ Idumea, loꞌo neꞌ xka laꞌa tsuꞌ chku Jordán, loꞌo neꞌ Sidón, loꞌo neꞌ Tiro. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Naꞌan Jesús chaꞌ kaꞌan ꞌa nten mdiyan seꞌen ndiꞌin yu. Kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kan loꞌo neꞌ ska yka naꞌan xuwe seꞌen nchka tiꞌ yu tyukwa yu, chaꞌ ja tukwa naꞌan neꞌ ꞌin yu seꞌen nduun yu tuꞌwa tyiꞌa, chaꞌ kaꞌan ꞌa nten ndiꞌin nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jlyo tiꞌ neꞌ chaꞌ wa yꞌni yu joꞌó ꞌin kaꞌan ꞌa neꞌ tiꞌí, kanꞌ chaꞌ tsaa ꞌa ndiꞌin neꞌ tiꞌí seꞌen ndiꞌin yu; wa nchka ꞌa tiꞌ neꞌ ni siya kalaꞌ ti neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nu tiꞌí nu msñi kwiꞌin kuxi ꞌin ni, bra nu naꞌan neꞌ kanꞌ ꞌin Jesús, bra kanꞌ mduun xtyinꞌ neꞌ tloo yu. Kwen msiꞌya neꞌ siꞌya kwiꞌin kuxi, chaꞌ nsuꞌwi lyo kwiꞌin kanꞌ ꞌin Jesús: ―¡Nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose ykwiꞌ! ―ndukwin nu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bra ti ngulo Jesús tñan ꞌin kwiꞌin kuxi chaꞌ ja katsaꞌ ꞌa neꞌ ꞌin xka la nten ti ka nu lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa mskwen yu siꞌ kiꞌya. Kanꞌ msiꞌya yu ꞌin tyun nten chaꞌ kan neꞌ seꞌen ndiꞌin, loꞌo ndyaa neꞌ kanꞌ seꞌen ndiꞌin yu bra kanꞌ. Laja neꞌ kanꞌ ngulo suwi Jesús ꞌin nten nu kuꞌni tñan ꞌin yu; ");
INSERT INTO ctpNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ngulo suwi yu ꞌin tii tyukwa nten kanꞌ, chaꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌin yu. Kanꞌ lka nten nu xuꞌwa yu chaꞌ tsaa seꞌen ndiꞌin nten tyun kichen tijyuꞌ la nde loo la, chaꞌ kwaꞌu neꞌ chaꞌ suꞌwe ꞌin Ndiose ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mda Jesús chabiyaꞌ ꞌin tii tyukwa neꞌ kanꞌ, chaꞌ kuꞌni neꞌ joꞌó ꞌin nu tiꞌí, loꞌo kulo neꞌ kwiꞌin kuxi nu wa msñi ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nde ndukwa nin taꞌa tii tyukwa yu kiꞌyu nu ngulo suwi Jesús ꞌin: Simón nu mstya Jesús xka nin chaꞌ ka naan yu Tyu, kanꞌ lka ska; ");
INSERT INTO ctpNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","kwiꞌ ngulo suwi yu ꞌin taꞌa tyukwaa sñiꞌ Zebedeo, nu naan Santiago loꞌo Xuwa, loꞌo ykwiꞌ Jesús chaꞌ sñiꞌ tiꞌyu lka neꞌ (ngwañaꞌan ndyoꞌo chaꞌ Boanerges chaꞌ nchkwiꞌ neꞌ kanꞌ); ");
INSERT INTO ctpNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","loꞌo ngulo suwi yu ꞌin Ndre, loꞌo Lpe, loꞌo Bartolomé, loꞌo Mateo, loꞌo Toma, loꞌo xka Santiago sñiꞌ Alfeo, loꞌo Tadeo, loꞌo xka Simón nu ndiꞌin chaꞌ ꞌin yu loꞌo xka ta nten nu lka cananista; ");
INSERT INTO ctpNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","loꞌo ngulo suwi yu ꞌin Juda Iscariote nu yꞌni trisiyun ꞌin Jesús loꞌo nten xaꞌan chunꞌ ndiꞌin la siꞌya tñi. Chunꞌ ndiꞌin la ngala Jesús naꞌan tyi ska nten loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Xiyaꞌ mdyoꞌ tiꞌin nten kichen seꞌen ndiꞌin Jesús bra kanꞌ. Chaꞌ kaꞌan ꞌa nten ndiꞌin, ja mjwi bra chaꞌ ku yu loꞌo taꞌa ndaꞌan yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Xa nu ynan taꞌa Jesús chaꞌ kanꞌ, mdaꞌan ꞌa chaꞌ tiye neꞌ bra kanꞌ. Bra ti mdoꞌo neꞌ ndyaa neꞌ seꞌen ndiꞌin Jesús, chaꞌ ndiya nten nu ndukwin chaꞌ wa mnaꞌ chaꞌ tiya ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Loꞌo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa tnun nde Jerusalén, mdiyan neꞌ nde kwa. Ykwiꞌ mstru kanꞌ loꞌo nten: ―Wa msñi Beelzebú xꞌnan nchga lo kwiꞌin kuxi ꞌin Jesús kwa ―ndukwin mstru kanꞌ―, kanꞌ chaꞌ loꞌo chabiyaꞌ ꞌin kuneꞌ xaꞌan kanꞌ nchka ꞌin yu kulo yu kwiꞌin kuxi nu msñi ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Kanꞌ msiꞌya Jesús ꞌin mstru kanꞌ, chaꞌ kan neꞌ seꞌen ndiꞌin yu; ykwiꞌ yu ska chaꞌ loꞌo neꞌ bra kanꞌ: ―¿Ta ka kulo Satanás ꞌin ti ykwiꞌ ti a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ja ka. Bra ti tyii chaꞌ ꞌin ska kichen ngwañaꞌan ti, bra nu xkwiꞌ nsuun ska ta neꞌ wsiya loꞌo xka ta neꞌ wsiya. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kwiꞌ ngwañaꞌan, loꞌo neꞌ taꞌa ndiꞌin ska niꞌ ñaꞌan ti, bra nu xkwiꞌ nsuun neꞌ, tyuꞌwe taꞌa neꞌ tyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kanꞌ chaꞌ ja talo Satanás si xuun taꞌa Satanás loꞌo msu ꞌin, tyii chaꞌ ꞌin kuneꞌ xaꞌan ndla ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ska nten ngula ni, ja kaja sa ñaꞌan nu sten xka nten naꞌan tyi yu chaꞌ kuꞌni neꞌ kunan yuꞌwa ꞌin yu. Ska ti si skanꞌ neꞌ ꞌin xꞌnan naꞌan ti kulo, ka kuꞌni neꞌ kunan nan nu nsuꞌwi ꞌin yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ nchka ꞌin nten chalyuu jñan chaꞌ tlyu tiꞌ ꞌin Ndiose Stiǐn chaꞌ ꞌin ya ñaꞌan ti kiꞌya nu ndiꞌin ꞌin neꞌ, ni siya chaꞌ kuxi nu yꞌni neꞌ, ni siya chaꞌ kuxi nu ykwiꞌ neꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ska ti nten nu chkwiꞌ chaꞌ kuxi ꞌin tñan nu ngiꞌni Tyiꞌi Ndiose, ja kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nten kanꞌ. Ja kuꞌni tyii Ni kiꞌya nu ndiꞌin ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ngwañaꞌan ykwiꞌ Jesús loꞌo neꞌ siꞌya chaꞌ nu ndukwin neꞌ, chaꞌ wa msñi kwiꞌin kuxi ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Loꞌo kanꞌ mdiyan jyaꞌan Jesús loꞌo taꞌa yu tuꞌ naꞌan seꞌen ndiꞌin yu. Chunꞌ naꞌan ti nganun neꞌ. Kanꞌ msuꞌwa neꞌ ꞌin nten nu ndyaa ytsaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Loꞌo tsaa ꞌa ndukwa nten kwiꞌ seꞌen ndiꞌin Jesús. Ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―Nduun jyaꞌaan loꞌo taꞌaa chunꞌ naꞌan kwa ―ndukwin neꞌ ꞌin Jesús―. Nchka tiꞌ neꞌ chkwiꞌ neꞌ loꞌoo ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","―¿Ti ka nu chañi chaꞌ lka jyaꞌaǎn? ¿Ti ka nu chañi chaꞌ lka taꞌaǎn? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Loꞌo naꞌan Jesús ꞌin neꞌ nu ndukwa kwiꞌ seꞌen ndiꞌin yu bra kanꞌ, ykwiꞌ yu loꞌo nten kaꞌan kanꞌ xiyaꞌ: ―Nten re ni, ska ñaꞌan ndiꞌin ti neꞌ ꞌñaǎn, sa ñaꞌan nu ndiꞌin jyaꞌaǎn ꞌñaǎn, sa ñaꞌan nu ndiꞌin taꞌaǎn ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Loꞌo ngwañaꞌan nchga nten nu ndukwa chaꞌ nu nchkwiꞌ Ndiose, nu ngiꞌni sa ñaꞌan nu nchka tiꞌ Ndiose chaꞌ kuꞌni neꞌ, ngiꞌni neꞌ kanꞌ ñaꞌan tiꞌ si lka neꞌ jyaꞌaǎn, ñaꞌan tiꞌ si lka neꞌ taꞌaǎn, ni siya kiꞌyu neꞌ, ni siya kunaꞌan neꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xiyaꞌ mdyisnan Jesús ngwaꞌu yu ꞌin nten tuꞌwa tiyuꞌ kanꞌ. Wa mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin yu bra kanꞌ; loꞌo ja mdoꞌo skwa yuu seꞌen nduun yu, kanꞌ chaꞌ yten yu ska niꞌ yka naꞌan xuwe nu ndukwi tuꞌwa tyiꞌa ti. Niꞌ yka naꞌan kanꞌ ndyaa tukwa Jesús, loꞌo kaꞌan la nten nganun lo yuu wtyi tuꞌwa tiyuꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kanꞌ kaꞌan ꞌa chaꞌ ykwiꞌ Jesús loꞌo neꞌ, chaꞌ kuꞌni xaꞌan neꞌ nchga chaꞌ nu ngwa tiꞌ yu kwaꞌu yu ꞌin neꞌ. Nde lka ska chaꞌ nu ykwiꞌ yu loꞌo neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Kunan suꞌwe wan chaꞌ re ―ndukwin Jesús ꞌin neꞌ―. Wa mdiya ska tsan ndyaa ska nten kata mta trigu. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Mskwin yu mta ꞌin yu, loꞌo ngalu chinꞌ mta kanꞌ lo yuu tla tuꞌwa tuwiin. Bra ti yan kiñi, mdyii mta kanꞌ yku iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Loꞌo ngalu la chinꞌ mta seꞌen chinꞌ ꞌa yuu ndukwa chunꞌ kee. Ndla ti mtsu mta kanꞌ; loꞌo chinꞌ ti yuu nchkunꞌ chunꞌ ran, ");
INSERT INTO ctpNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","kanꞌ chaꞌ ja msñi suꞌwe ran chunꞌ kee kanꞌ, ja ngwa kaluu suꞌwe ran. Mdyii kala kanꞌ nganaan ran, chaꞌ tikeeꞌ ꞌa kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kwiꞌ xka seꞌen ngalu chinꞌ mta lo yuu seꞌen nsuꞌwi yka kicheꞌ. Ndla la nguluu yka kicheꞌ kanꞌ; ja mda chabiyaꞌ kaluu suꞌwe kala trigu, kanꞌ chaꞌ ja mdoꞌo mta lo ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Loꞌo ngalu chinꞌ mta lo yuu suꞌwe. Suꞌwe mtsu mta kanꞌ; suꞌwe ꞌa nguluu kala, suꞌwe ꞌa mdoꞌo mta lo juun kanꞌ bra kanꞌ. Wa yuꞌwi juun nu mda kalatyii mta ska ti juun, loꞌo yuꞌwi juun nu mda snan yla mta lo ran, loꞌo yuꞌwi juun nu mda ska siyentu mta ska ti lo juun. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","’Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, si chañi chaꞌ xlyaa wan kunan wan chaꞌ suꞌwe kanꞌ ―ndukwin Jesús ꞌin nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Chunꞌ ndiꞌin la wa mdoꞌo nten kanꞌ ndyaa neꞌ sa tlyu ti. Mdiyan tii tyukwa nten nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin yu bra kanꞌ, loꞌo mdiyan xka la taꞌa suꞌwe nsuꞌwi neꞌ ti kwiꞌ seꞌen kanꞌ. Kanꞌ mnichaꞌ neꞌ kanꞌ ꞌin Jesús: ―¿Ni sa ñaꞌan ndyoꞌo chaꞌ tiya nu ykwiiꞌ tsan? ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","―ꞌWan, wa nda Ndiose chabiyaꞌ ꞌwan chaꞌ ka biyaꞌ tiꞌ wan ska chaꞌ nu nsuꞌwi nchkunꞌ ti, chaꞌ nu ka xa nu ka Ndiose ndloo la niꞌ kasiya ꞌin nten ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Xka ta nten nu ja yten chaꞌ ꞌin Ndiose ni, ja kiꞌya neꞌ kwenta bra nu kunan neꞌ ska chaꞌ nu nchkwiǐnꞌ; tukwi ꞌa chaꞌ kanꞌ, nxkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kanꞌ chaꞌ nchkwiǐnꞌ chaꞌ kutsiꞌ ti loꞌo neꞌ, chaꞌ ñaꞌan neꞌ ni siya ja kiꞌya neꞌ kwenta sa ñaꞌan ndyoꞌo chaꞌ kanꞌ, chaꞌ kunan neꞌ ni siya ja ka biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ. Jlyo tiǎnꞌ chaꞌ ja xlyaa neꞌ kulaa yaꞌ neꞌ chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, kanꞌ chaꞌ ja nchka ꞌñaǎn kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin neꞌ ꞌin kiꞌya nu ndiꞌin ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","’¿Ja ngwa biyaꞌ tiꞌ wan sa ñaꞌan ndyoꞌo chaꞌ kutsiꞌ kanꞌ a? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―. ¿Ni sa ñaꞌan ka kiꞌya wan kwenta ꞌin xka la chaꞌ sikwa?, si ja nnan wan chaꞌ nu nchkwiǐnꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ñaꞌan tiꞌ yu nu yta mta trigu kanꞌ, ngwañaꞌan lka nten nu nchkwiꞌ chaꞌ suꞌwe ꞌin Ndiose loꞌo xka ta nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ñaꞌan tiꞌ mta nu ngalu lo yuu tla tuꞌwa tuwiin, loꞌo mdyii mta yku kiñi bra kanꞌ, ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe ꞌin Ndiose, loꞌo ja ynan suꞌwe neꞌ bra kanꞌ. Ñaꞌan tiꞌ yuu tla kanꞌ, ngwañaꞌan lka kasiya ꞌin nten chalyuu. Sa ñaꞌan lka xa wa mdyii yku kiñi mta nu ndiya tuꞌwa tuwiin, ngwañaꞌan kan Satanás chaꞌ kuꞌni tyii chaꞌ suꞌwe kanꞌ, chaꞌ ja tyuꞌwi ꞌa tiꞌ neꞌ chaꞌ suꞌwe kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Loꞌo mta nu ngalu lo yuu lti ti tuꞌwa nu ndiya chunꞌ kee ni, kanꞌ lka ñaꞌan tiꞌ nten nu kulo ndukwa la suꞌwe ꞌa nka tiye neꞌ xa wa ynan neꞌ chaꞌ suꞌwe ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Chunꞌ ndiꞌin la, bra nu kuꞌni tiꞌí tiꞌ xka ta nten ꞌin neꞌ kanꞌ chunꞌ nu wa ynan neꞌ chaꞌ suꞌwe nu nchkwiǐnꞌ, bra nu xtyi lyoꞌo nten ꞌin neꞌ kanꞌ, ja talo ꞌa neꞌ kanꞌ bra kanꞌ. Lka neꞌ kanꞌ ñaꞌan tiꞌ mta nu ja msñi suꞌwe suun ran chunꞌ kee, chaꞌ lti ti tuꞌwa yuu nu ndukwa chunꞌ kee kanꞌ, loꞌo ja mdalo kala kanꞌ, nganaan ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mta nu ngalu lo yuu laja yka kicheꞌ ni, kanꞌ lka ñaꞌan tiꞌ nten nu ynan chaꞌ suꞌwe kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","loꞌo kaꞌan ꞌa chaꞌ ndaꞌan tiye neꞌ sa ñaꞌan kuꞌni neꞌ chaꞌ ka kuliyaꞌ neꞌ bra kanꞌ. Ndaꞌan naan ꞌa neꞌ sa ñaꞌan ka kaja kaꞌan ꞌa chaꞌ suꞌwe nu nsuꞌwi chalyuu re ꞌin neꞌ, chaꞌ ka suꞌwa neꞌ loꞌo nten nu tnun la nchka; kanꞌ chaꞌ ja nchka kanun chaꞌ suꞌwe niꞌ kasiya ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Loꞌo seꞌen ngalu mta lo yuu suꞌwe ni, mtsu mta kanꞌ, suꞌwe ꞌa nguluu kala, mdoꞌo ꞌa mta lo ran bra kanꞌ; ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe kanꞌ, loꞌo suꞌwe ꞌa ynan neꞌ chaꞌ kanꞌ. Sa kalatyii yaꞌ, sa kwa chaꞌ suꞌwe kuꞌni neꞌ kanꞌ xa wa ynan neꞌ chaꞌ ꞌin Ndiose, ta snan yla yaꞌ chaꞌ suꞌwe kuꞌni neꞌ, ta ska siyentu yaꞌ chaꞌ suꞌwe kuꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Loꞌo ngwaꞌu Jesús xka chaꞌ ꞌin neꞌ kanꞌ: ―Bra nu xtyaan xaa niꞌ ñaꞌan xa tla, ¿ta tukuanꞌ lo xaa kanꞌ a? ¿O ta xtyaan xaa kanꞌ niꞌ kiꞌyan a? ―ndukwin Jesús ꞌin neꞌ―. Ja kuꞌnian ngwañaꞌan ―ndukwin yu―. Kwan chinꞌ xtyaan xaa chaꞌ xuꞌwi xaa ran ñaꞌaan niꞌ ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ndiꞌin chaꞌ tyoꞌo lo xaa nchga nan nu nsuꞌwi kutsiꞌ ꞌin nten ni; ja ska chaꞌ nu nsuꞌwi mnan ti ni, nu ja tyija lyo ꞌin nten nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan sikwa, si chañi chaꞌ xlyaa wan kunan wan chaꞌ suꞌwe re. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ti ngwaꞌu la chinꞌ Jesús ꞌin neꞌ bra kanꞌ: ―Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús―. Sa ñaꞌan nu ngiꞌni wan loꞌo xka la nten, kwiꞌ ngwañaꞌan kuꞌni Ndiose loꞌo wan bra kanꞌ. Xa nu kunan suꞌwe wan chaꞌ ꞌñaǎn, kwiꞌ ngwañaꞌan ti kaja la kaꞌan chaꞌ suꞌwe nu xuꞌwi niꞌ kasiya ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Loꞌo nten nu ndyaa ñaꞌan tiꞌ ꞌñaǎn, nu ngiꞌni xaꞌan chaꞌ kanꞌ ni, ti chkwiꞌ la Ndiose chaꞌ suꞌwe loꞌo neꞌ kanꞌ; nten nu ja ndyaa ñaꞌan tiꞌ ꞌñaǎn, nu ja nchka tiꞌ kuꞌni xaꞌan neꞌ chaꞌ nu nchkwiǐnꞌ, kuꞌni Ndiose chaꞌ ja ka ꞌin neꞌ kanꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌin Ndiose siyaꞌ ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Loꞌo ngwaꞌu Jesús xka chaꞌ ꞌin neꞌ bra kanꞌ: ―Chkwiǐnꞌ ska chaꞌ tiya loꞌo wan chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka xa nu ka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús ꞌin neꞌ―. Ntya nten nskwaꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ndijyaꞌ neꞌ tla; nu ndiꞌya xaa xka tsan ndyaa tukwi neꞌ. Ngwañaꞌan ndijin neꞌ tyun tsan loꞌo tyun tla. Laja bra kanꞌ nchu mta kanꞌ, ndijyan ngaluu ran bra kanꞌ. Ja jlyo tiꞌ neꞌ sa ñaꞌan ndijyan ngaluu mta kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ngwañaꞌan nchka ꞌin ska mta nu kataan. Ti kwiꞌ yuu seꞌen ytaan mta, kanꞌ lka nu ta jwersa ꞌin ran chaꞌ kaluu ran. Kulo ndukwa tyukwa kala kuneꞌ, bra kanꞌ tyoꞌo tukwa katsunꞌ, chunꞌ ndiꞌin la kaja tya ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Xa wa wtyi tya, bra kanꞌ tsaa kusaaꞌ neꞌ tya chaꞌ ka kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Loꞌo ngwaꞌu Jesús xka chaꞌ ꞌin neꞌ kanꞌ bra kanꞌ: ―Xka chaꞌ chkwiǐnꞌ loꞌo wan ni, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka xa nu ka Ndiose ndloo niꞌ kasiya ꞌin nten ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ka kanꞌ ñaꞌan tiꞌ ska lo mta nu xuwe ꞌa nu ntya nten. Mta kanꞌ lka mta nu xuwe la ti ñaꞌaan chalyuu, chaꞌ ja nsuꞌwi xka mta nu xuwe la. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bra nu kata neꞌ mta kanꞌ, ndla ti katsu ran, kaluu yka chaꞌ ka ran ska yka tnun bra kanꞌ. Loꞌo kiꞌya kiñi laja stanꞌ yka kanꞌ, tyukwa tñaꞌ iꞌ seꞌen tlaꞌ laja lkaꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ngwañaꞌan ngwaꞌu Jesús chaꞌ ꞌin nten; ykwiꞌ yu chinꞌ chaꞌ tiya, ykwiꞌ yu chaꞌ kutsiꞌ loꞌo neꞌ, chaꞌ kwaꞌu yu chaꞌ ꞌin Ndiose ꞌin neꞌ, sa ñaꞌan yaꞌ nu kiꞌya suꞌwe neꞌ kwenta sa ñaꞌan lka chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Xkwiꞌ loꞌo chaꞌ kutsiꞌ ti ngwaꞌu Jesús chaꞌ ꞌin nten kaꞌan, ni siya ja ngwiꞌya suꞌwe neꞌ kwenta sa ñaꞌan ndyoꞌo chaꞌ kanꞌ; chunꞌ ndiꞌin la ngwaꞌu suꞌwe la yu nchga chaꞌ kanꞌ ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ ka biyaꞌ la tiꞌ neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wa msiin ꞌa tsan kanꞌ, wa ndyaa kwichaa, bra kanꞌ ykwiꞌ Jesús chinꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Tyijian tyaan nde xka laꞌa tsuꞌ tiyuꞌ re ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Loꞌo ngulaa tiꞌin neꞌ ꞌin nten kaꞌan nu ndiꞌin nde kwa bra kanꞌ, yten taꞌa ndaꞌan Jesús niꞌ yka naꞌan seꞌen ndiya yu, seꞌen ngwaꞌu yu chaꞌ ꞌin nten kaꞌan kanꞌ ti tsan la. Mdoꞌo neꞌ ndyaa neꞌ, loꞌo xka la yka naꞌan ndyaa suꞌwa ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Loꞌo lye ꞌa mskwa kwiꞌin bra kanꞌ, lye ꞌa ngutsa tyiꞌa lo tiyuꞌ, sa yaꞌ nu yten ꞌa tyiꞌa kulooꞌ niꞌ yka naꞌan; wa xaꞌan ti yka naꞌan kanꞌ nsuꞌwi tyiꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Lajaꞌ ti Jesús mskwa yu tu seꞌen yka naꞌan, mskwa ke yu lo ska teꞌ kuti ti. Mlyo neꞌ slaa yu bra kanꞌ: ―¡Yu kula! ―ndukwin neꞌ ꞌin Jesús―. ¡Xaa tiiꞌ! ¿Ta ja nduwe tiiꞌ chaꞌ wa kaja tian a? ―ndukwin neꞌ―. Wa katin ti yka naꞌan re niꞌ tyiꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Bra kanꞌ mdyituun Jesús, ngulo yu tñan ꞌin kwiꞌin, ykwiꞌ yu loꞌo kwiꞌin chaꞌ ja ka kulooꞌ lo tyiꞌa tiyuꞌ kanꞌ. ―¡Ka tiin lo tyiꞌa re! ―ndukwin yu. Bra ti ngwa tiin kwiꞌin, ngwa tiin kulooꞌ; tiin ti nganun tiyuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―¿Ni chaꞌ ntsen ꞌa wan? ―ndukwin Jesús ꞌin neꞌ―. ¿Ni chaꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose chaꞌ ka ꞌin Ni kuꞌni Ni ngwañaꞌan? ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yuwe ꞌa tiꞌ neꞌ ñaꞌan neꞌ ꞌin Jesús bra kanꞌ: ―¿Ti ka nu lka yu kiꞌyu re? ―ndukwin neꞌ ꞌin taꞌa neꞌ―, chaꞌ loꞌo kwiꞌin ndukwa chaꞌ nu ykwiꞌ yu loꞌo ran, loꞌo tyiꞌa tiyuꞌ ynan chaꞌ kanꞌ ―ndukwin neꞌ ꞌin taꞌa ndaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chunꞌ ndiꞌin la mdiyan neꞌ xka laꞌa tsuꞌ tiyuꞌ kanꞌ, nde lo yuu ꞌin Gadara. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wa tyoꞌo ti Jesús niꞌ yka naꞌan, bra kanꞌ mdoꞌo tukwa ska yu tiꞌí nu msñi kwiꞌin xaꞌan ꞌin. Ndiꞌin yu tiꞌí kanꞌ niꞌ lyoꞌoo jyoꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Seꞌen mtsiꞌ ayman ti ndiꞌin yu tiꞌí kanꞌ, chaꞌ ja ngwa ꞌin nten skanꞌ ꞌin yu; ni loꞌo chkwan, ja ngwa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wa tyun yaꞌ mskanꞌ neꞌ ꞌin yu tiꞌí kanꞌ loꞌo karenan; nchkanꞌ kiyaꞌ yu, nchkanꞌ yaꞌ yu, loꞌo bra ti mdijin kuꞌ yu chkwan kanꞌ, ngutin karenan, nganun yuꞌwe ti chkwan nu nchkanꞌ yu tiꞌí kanꞌ. Ja ska nten ngwa ꞌin kulo tñan ꞌin yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Loꞌo nde tsan loꞌo nde tla ndaꞌan yu nxiꞌya yu niꞌ lyoꞌoo jyoꞌo, ndaꞌan yuꞌwi ti yu lo kiꞌya, loꞌo ykwiꞌ ti yu, yꞌni kuxi yu ꞌin yu loꞌo kee. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Loꞌo ni, tijyuꞌ ti mduun yu tiꞌí kanꞌ naꞌan yu ꞌin Jesús. Bra ti msnan yu, mduun xtyinꞌ yu tloo Jesús, chaꞌ kuꞌni tnun yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Kwen msiꞌya yu tiꞌí kanꞌ ꞌin Jesús bra kanꞌ: ―¿Ni sa ñaꞌan tñan nchka tiꞌ wan ꞌñaǎn a? ―mnichaꞌ yu tiꞌí ꞌin Jesús bra kanꞌ―. ꞌWan lka wan Jesús, ska ti wan nu lka wan Sñiꞌ Ndiose, kwiꞌ Ndiose nu ndloo la ti ―ndukwin―. Chabiyaꞌ ꞌin Ndiose, ja ta wan nu tiꞌí ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ti tsan la wa ngulo Jesús tñan ꞌin kwiꞌin xaꞌan kanꞌ, chaꞌ tyoꞌo tsuꞌ ꞌin yu tiꞌí kanꞌ, kanꞌ chaꞌ tꞌnan ykwiꞌ yu loꞌo Jesús chaꞌ ja ta nu tiꞌí ꞌin yu bra kanꞌ. ―Tyoꞌo lya wan, tyaa wan siyaꞌ ti ―ndukwin Jesús ꞌin kwiꞌin xaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kanꞌ mnichaꞌ Jesús ꞌin yu tiꞌí kanꞌ: ―¿Ni sa ñaꞌan naan nuꞌwin? ―ndukwin Jesús ꞌin yu. ―Kaꞌan ꞌa loo ñaꞌan naǎnꞌ ―ndukwin yu tiꞌí―, chaꞌ kaꞌan ꞌa kwiꞌin xaꞌan wa msñi ꞌñaǎn ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Loꞌo mjñan ꞌa yu tiꞌí kanꞌ, chaꞌ ja kuꞌni ꞌa Jesús joꞌó ꞌin yu, chaꞌ ja kulo ꞌa Jesús tñan ꞌin kwiꞌin xaꞌan, chaꞌ tyoꞌo ran ꞌin yu, chunꞌ ja nchka tiꞌ kwiꞌin xaꞌan kanꞌ tsaa xka chalyuu tijyuꞌ la. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Loꞌo ndiꞌin ska ta tnun kuweꞌ nchku kixinꞌ siꞌ kiꞌya kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kanꞌ chaꞌ mjñan yu tiꞌí kanꞌ ꞌin Jesús chaꞌ ꞌin kwiꞌin xaꞌan nu msñi ꞌin yu: ―Ta wan chabiyaꞌ tsaa kwiꞌin chaꞌ xñi ꞌin kuweꞌ kwa ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Loꞌo mda Jesús chabiyaꞌ ꞌin nchga kwiꞌin xaꞌan kanꞌ. Kanꞌ mdoꞌo kwiꞌin ndyaa, msñi ꞌin kuweꞌ bra kanꞌ. Ndiꞌin tukwa mi kuweꞌ, loꞌo msñi kwiꞌin kanꞌ ꞌin nchga iꞌ. Msnan iꞌ siꞌ yuu bra kanꞌ, mdiyuu taꞌa iꞌ niꞌ tyiꞌa tiyuꞌ; ngutin iꞌ niꞌ tyiꞌa, ngujwi nchga kuweꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Loꞌo yuwe ꞌa tiꞌ neꞌ nu naꞌansiin ꞌin kuweꞌ kanꞌ bra kanꞌ, msnan neꞌ nde kichen chaꞌ katsaꞌ neꞌ ꞌin nchga nten kichen loꞌo nten ndiꞌin kwiꞌ seꞌen ti sa ñaꞌan ngwa kanꞌ. Bra ti mdoꞌo nten ndijyan neꞌ chaꞌ ñaꞌan neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bra nu mdiyan neꞌ seꞌen ndiꞌin Jesús, bra kanꞌ naꞌan neꞌ ꞌin nu kiꞌyu nu ngwa tiꞌí kanꞌ; naꞌan neꞌ chaꞌ tiin ti ndukwa yu kiꞌyu kanꞌ, lkuꞌ yu steꞌ yu, chaꞌ wa nchkaa yu. Ja nxlyuu ꞌa kwiꞌin xaꞌan kanꞌ ꞌin yu. Ytsen ꞌa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ytsaꞌ ꞌa neꞌ nu naꞌansiin ꞌin kuweꞌ kanꞌ sa ñaꞌan ngwa ꞌin yu tiꞌí, chaꞌ sa tlyu ti mdoꞌo kwiꞌin xaꞌan kanꞌ ꞌin yu ndyaa bra kanꞌ, msñi ꞌin nchga kuweꞌ nu ndiꞌin kanꞌ; mdyii chaꞌ ꞌin kuweꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Bra wa ynan nten kichen chaꞌ kanꞌ, bra kanꞌ tꞌnan ykwiꞌ neꞌ loꞌo Jesús chaꞌ tyoꞌo tsuꞌ yu tyaa yu xka seꞌen nu tijyuꞌ la. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nu wa sten ti Jesús niꞌ yka naꞌan xuwe chaꞌ tyaa yu, bra kanꞌ ykwiꞌ nu ngwa tiꞌí kanꞌ loꞌo Jesús; mjñan yu chabiyaꞌ ꞌin Jesús chaꞌ tsaa yu loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Loꞌo ja mda Jesús chabiyaꞌ ꞌin yu bra kanꞌ. ―Xitukwii tyaa naꞌan tyii xiyaꞌ ―ndukwin Jesús ꞌin yu―. Katsaaꞌ ꞌin nchga neꞌ taꞌaa sa ñaꞌan ngwa chaꞌ tnun nu yꞌni Ndiose nu nka Xꞌnaan loꞌoo, ti kwiꞌ Ni yꞌni Ni chaꞌ nchkaa, chaꞌ wa ngwa tꞌnan ꞌa tiꞌ Ni ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kanꞌ mdoꞌo ndyaa yu kiꞌyu kanꞌ nchga kichen nde Decápolis, ytsaꞌ yu nchga loo chaꞌ ꞌin neꞌ, sa ñaꞌan nu yꞌni Jesús loꞌo yu. Yuwe ꞌa tiꞌ nchga nten nu ndiꞌin nde kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Loꞌo xiyaꞌ yan Jesús niꞌ yka naꞌan nde tsuꞌ tiyuꞌ re. Xiyaꞌ mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin Jesús tuꞌwa tiyuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kanꞌ mdiyan ska yu kiꞌyu nu lka yu tñan niꞌ lyaa kwa. Jairo naan yu kula kanꞌ. Mduun xtyinꞌ yu kula kanꞌ tloo Jesús, mdukwi ndlyuu ke yu la lyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tꞌnan ꞌa ykwiꞌ yu loꞌo Jesús bra kanꞌ: ―Wa kaja ti sñiěnꞌ ―ndukwin yu ꞌin Jesús―. Kuꞌni wan chaꞌ suꞌwe tsaa wan nde seꞌen nskwa nu kunaꞌan xuwe kanꞌ ꞌñaǎn, chaꞌ kuꞌni wan joꞌó ꞌin, xtya yaꞌ wan chunꞌ nu xuwe chaꞌ kuꞌu. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Loꞌo ndyaa Jesús loꞌo yu bra kanꞌ, loꞌo kaꞌan nten ndyaa loꞌo neꞌ, tsaa ꞌa ndiꞌin nten tuwiin seꞌen ndaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Loꞌo ska nu kunaꞌan tiꞌí mdaꞌan laja nten kaꞌan kanꞌ. Wa tii tyukwa yijan nsuꞌwi kicha nu kunaꞌan kanꞌ, chaꞌ ngalu ꞌa tnen. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Wa mdyii nchga loo joꞌó yꞌni neꞌ ꞌin nu tiꞌí kanꞌ, loꞌo ja ngwa ꞌin neꞌ kuꞌni chkaa neꞌ ꞌin. Mdyii tñi ꞌin nu kunaꞌan kanꞌ, mdyii nchga loo chaꞌ suꞌwe nu nsuꞌwi ꞌin siꞌya rmiyu, loꞌo lye la tiꞌí bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wa ynan nu kunaꞌan tiꞌí kanꞌ chinꞌ chaꞌ ꞌin Jesús, kanꞌ chaꞌ yan laja nten nde chunꞌ seꞌen nduun Jesús. Ylaꞌ nu kunaꞌan kanꞌ steꞌ Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Bra nu kalaǎnꞌ tiǎn steꞌ Jesús re, chkaǎn bra kanꞌ” mskeꞌ tiꞌ nu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Bra ti nchkunꞌ chaꞌ ngalu tnen, siyaꞌ ti mgii tiꞌ nu kunaꞌan chaꞌ wa nchkaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Loꞌo bra ti mgii tiꞌ Jesús chaꞌ wa yꞌni yu joꞌó ꞌin ska nten, ni siya ja ya ñaꞌan yu ꞌin nu tiꞌí kanꞌ. Kanꞌ chaꞌ mxinaꞌan yu nde chunꞌ yu ꞌin nten kaꞌan nu ndaꞌan loꞌo yu. ―¿Ti ka lka nu wa ylaꞌ steěnꞌ a? ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Yuwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ―Tsaa ꞌa ndiꞌin nten re seꞌen ndaꞌaan ―ndukwin neꞌ kanꞌ ꞌin Jesús―. ¿Ni chaꞌ mnichaaꞌ ꞌin neꞌ, “ti ka lka nu ylaꞌ ꞌñaǎn?” ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kanꞌ naꞌan ꞌa Jesús ꞌin nchga nten chaꞌ ka biyaꞌ tiꞌ yu ti ka lka nu ylaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Loꞌo yan nu kunaꞌan kanꞌ, mduun xtyinꞌ tloo yu bra kanꞌ. Nchkwaan ꞌa kanꞌ, chaꞌ ntsen ꞌa, loꞌo jlyo tiꞌ chaꞌ wa nchkaa. Bra kanꞌ ytsaꞌ ñi ꞌin Jesús sa ñaꞌan ngwa ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","―Suꞌwe ꞌa ndyaa ñaꞌan tiiꞌ ꞌñaǎn, sñiěnꞌ ―ndukwin Jesús ꞌin―, kanꞌ chaꞌ nchkaa. Tiin ti tyiꞌin tiyee ni. Suꞌwe ti tyaa ni, ñi katsaǎnꞌ ꞌiin chaꞌ ja xñi ꞌa kicha kanꞌ ꞌiin la xiyaꞌ la. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Bra nu ti nchkwiꞌ Jesús loꞌo nu kunaꞌan kanꞌ, bra kanꞌ mdiyan ska msu ꞌin Jairo, yu kula nu lka tñan niꞌ lyaa kanꞌ, mdyukwa taꞌa loꞌo neꞌ. Ykwiꞌ msu kanꞌ loꞌo Jairo chaꞌ ꞌin nu xuwe tiꞌí: ―Wa ngujwi sñiꞌ wan, yu kula ―ndukwin msu ꞌin xꞌnan―. Ja ndiꞌin chaꞌ chkwiꞌ la wan loꞌo mstru re. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Loꞌo Jesús, ynan yu chaꞌ nu ykwiꞌ msu kanꞌ, loꞌo ja mdukwa Jesús ꞌin ran bra kanꞌ. ―Ja kutseen ―ndukwin Jesús ꞌin yu kula nu lka tñan niꞌ lyaa kanꞌ―. Sa kanꞌ ti chaꞌ, kuꞌnii chaꞌ tsaa ñaꞌan tiiꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Loꞌo ja mda ꞌa Jesús chabiyaꞌ ꞌin nten chaꞌ tsaa neꞌ loꞌo yu; ska ti Tyu, loꞌo Santiago, loꞌo Xuwa taꞌa Santiago, mda yu chabiyaꞌ tsaa neꞌ loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kanꞌ mdiyan neꞌ tuꞌ naꞌan tyi yu nu lka tñan niꞌ lyaa kanꞌ. Wa kaꞌan ꞌa nten mdyoꞌ tiꞌin nde kwa, nganan ꞌa neꞌ ndiꞌin neꞌ. Lye ꞌa ngwa chaꞌ wa ngujwi nu xuwe ti kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yten Jesús niꞌ ñaꞌan bra kanꞌ. ―¿Ni chaꞌ lka nganan ꞌa wan ndiꞌin wan? ―ndukwin Jesús ꞌin neꞌ―. ¿Ni chaꞌ lka chaꞌ kaꞌan ꞌa chaꞌ ndaꞌan tiye wan? Ja ngujwi nu xuwe tiꞌí re, nan lajaꞌ ti nskwa ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Loꞌo mstyi lyoꞌo ꞌa neꞌ ꞌin yu bra kanꞌ. Kanꞌ chaꞌ ngulo Jesús ꞌin nchga nten nu ndiꞌin nxiꞌya neꞌ; nganun yu loꞌo sti loꞌo jyaꞌan nu xuwe tiꞌí, loꞌo taꞌa snan yu taꞌa ndaꞌan Jesús, ndyaa neꞌ kanꞌ seꞌen ndiꞌin nu xuwe. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Bra kanꞌ msñi Jesús yaꞌ nu xuwe kanꞌ: ―Talita, kumi ―ndukwin Jesús ꞌin, chaꞌ nu nchkwiꞌ neꞌ kanꞌ. Nde lka sa ñaꞌan ndyoꞌo chaꞌ kanꞌ: ―Maan, kuloǔn tñan ꞌiin ni, chaꞌ tyituun. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Bra ti mdyituun nu kunaꞌan xuwe nu ngujwi kanꞌ, mdyisnan ndaꞌan bra kanꞌ. Tii tyukwa ti yijan nsuꞌwi nu xuwe ti kanꞌ. Yuwe ꞌa tiꞌ neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Loꞌo lye ykwiꞌ Jesús loꞌo neꞌ kanꞌ, chaꞌ ja katsaꞌ neꞌ ꞌin xka la nten sa ñaꞌan ngwa chaꞌ nchkaa nu xuwe kanꞌ. Bra kanꞌ ngulo yu tñan ꞌin neꞌ chaꞌ ta chinꞌ nan ku nu xuwe ti kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nde loo la mdoꞌo Jesús ndyaa yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa neꞌ kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Loꞌo ndyaa Jesús niꞌ lyaa kichen kanꞌ tsan nu nxitñaꞌ neꞌ, tsan taꞌa kanꞌ. Nde kwa ngwaꞌu yu ꞌin nten bra kanꞌ. Yuwe ꞌa tiꞌ neꞌ nu ndiꞌin niꞌ lyaa kanꞌ bra nu ynan neꞌ chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ. ―¿La nde yaꞌ yꞌni xaꞌan yu re nchga chaꞌ nu nchkwiꞌ yu? ―ndukwin neꞌ―. ¿Ni sa ñaꞌan ngwa chaꞌ ndiꞌya suꞌwe yu kwenta ꞌin chaꞌ kanꞌ? ¿Ta ndii ꞌa tiꞌ yu a? ―ndukwin neꞌ―. ¿Ni chaꞌ nchka ꞌin yu kuꞌni yu chaꞌ tnun? ―ndukwin neꞌ ꞌin taꞌa neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kwityi kaꞌ ti lka yu re ―ndukwin neꞌ―. Ti kwiꞌ sñiꞌ Liya lka yu re; taꞌa Santiago, taꞌa Se, taꞌa Juda, taꞌa Simón lka yu re, loꞌo nde kichen tyian ndiꞌin neꞌ kunaꞌan taꞌa yu re ―ndukwin neꞌ ꞌin taꞌa kichen tyi neꞌ. Chen ngwa tiye neꞌ ñaꞌan neꞌ ꞌin Jesús bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","kanꞌ chaꞌ ykwiꞌ Jesús loꞌo neꞌ xiyaꞌ: ―Nchga nten xka kichen ni, kuꞌni tnun neꞌ ꞌin ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo neꞌ ―ndukwin Jesús ꞌin nten kanꞌ―. Neꞌ taꞌa kichen tyi ti yu ni, kanꞌ nu ja xlyaa kunan chaꞌ nu nchkwiꞌ yu siyaꞌ ti ―ndukwin Jesús―. Nchga taꞌa yu, kwiꞌ neꞌ taꞌa ndiꞌin yu, ja kunan neꞌ chaꞌ nu nchkwiꞌ yu ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ngwañaꞌan ngwa chaꞌ ja ngwa kuꞌni Jesús chaꞌ tnun seꞌen ndiꞌin neꞌ kanꞌ, chaꞌ ja ndyaa ñaꞌan tiꞌ neꞌ ꞌin yu; yꞌni yu chaꞌ nchkaa ska tukwa ti neꞌ tiꞌí xa nu mstya yaꞌ ti yu chunꞌ neꞌ, sa kanꞌ ti chaꞌ tnun yꞌni yu kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Yuwe ꞌa tiꞌ Jesús chaꞌ ja ndyaa ñaꞌan tiꞌ neꞌ kanꞌ ꞌin siyaꞌ ti. Kanꞌ ti mdaꞌan la yu la xka kichen xuwe ti nu ndiꞌin kwiꞌ seꞌen ti, ngwaꞌu yu ꞌin nten la kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Chunꞌ ndiꞌin la msiꞌya Jesús ꞌin tii tyukwa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ chkwiꞌ yu loꞌo neꞌ bra kanꞌ. Ngulo yu tñan ꞌin neꞌ kanꞌ, chaꞌ tyoꞌo neꞌ tsaa neꞌ kwenta tukwa ti neꞌ; suꞌwa ti tsaa tukwa neꞌ ska kichen. Loꞌo mda Jesús chabiyaꞌ ꞌin neꞌ chaꞌ kulo neꞌ ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ykwiꞌ Jesús loꞌo neꞌ chaꞌ ja loꞌo suꞌwa neꞌ kiꞌya neꞌ tsaa neꞌ. Tsaa neꞌ loꞌo ska yka skan ti; ja loꞌo kwijin, ja loꞌo tyaja, ja loꞌo tñi tsaa neꞌ, ndukwin Jesús. Tloo ti neꞌ tsaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xuꞌwi snan neꞌ, kuꞌ neꞌ ykanꞌ, ni siya ja loꞌo xka ykuꞌ steꞌ neꞌ tsaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","―Nu ta neꞌ naꞌan seꞌen kajaꞌ wan seꞌen ndiꞌin neꞌ ―ndukwin Jesús ꞌin neꞌ kanꞌ―, nde kwa kanun wan bra kanꞌ, sa ñaꞌan bra nu tyoꞌo wan tsaa wan xka kichen. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Si nsuꞌwi ska kichen seꞌen ja xlyaa nten ta neꞌ seꞌen kanun wan, kichen nu ja xlyaa neꞌ kunan neꞌ chaꞌ nu chkwiꞌ wan loꞌo neꞌ, bra ti tyoꞌo wan kichen kanꞌ, tyaa lya wan bra kanꞌ. Tuꞌwa kichen kanꞌ skwin wan kiyaꞌ wan chaꞌ kulo yuu nsuꞌwi snan wan, chaꞌ ngwañaꞌan ka biyaꞌ tiꞌ neꞌ chaꞌ kuxi ꞌa tñan nu yꞌni neꞌ loꞌo wan. Ngwañaꞌan ykwiꞌ Jesús loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kanꞌ mdoꞌo neꞌ ndyaa neꞌ nde tyun kichen. Ykwiꞌ neꞌ loꞌo nten kichen kanꞌ, chaꞌ ka jyuꞌu tiꞌ neꞌ kichen ꞌin nchga chaꞌ kuxi nu ngiꞌni neꞌ, chaꞌ kulaa yaꞌ neꞌ ꞌin chaꞌ kuxi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Loꞌo ngulo neꞌ nu ngiꞌni xaꞌan kanꞌ kwiꞌin kuxi nu msñi ꞌin tyun nten, loꞌo mgoꞌo neꞌ sete xi tyiꞌi chunꞌ xka ta neꞌ tiꞌí bra nu yꞌni neꞌ joꞌó ꞌin neꞌ tiꞌí kanꞌ; nchkaa neꞌ tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Loꞌo wa ynan ree Herodes ꞌin chaꞌ tnun nu wa yꞌni Jesús bra kanꞌ; nchga kichen ynen chaꞌ kanꞌ, chaꞌ skaa chaꞌ ykwiꞌ skaa nten ꞌin Jesús. Nde lka chaꞌ nu mskeꞌ tiꞌ ree kanꞌ: ―Ayman Xuwa nu mdukwatya ꞌin nten nu ngwa sꞌni, kanꞌ lka Jesús re ―ndukwin Herodes kanꞌ―. Wa yjwiǐn ꞌin Xuwa kanꞌ, loꞌo ni, wa ndyuꞌu yu xiyaꞌ, kanꞌ chaꞌ nchka ꞌin kuꞌni chaꞌ tnun nu ngwañaꞌan ―ndukwin ree. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","―Siꞌi nu kanꞌ ―ndukwin xka ta nten―. Ayman Elías lka yu kiꞌyu re. ―Siꞌi ngwañaꞌan ―ndukwin xka ta nten―. Ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose lka yu re, ñaꞌan tiꞌ ayman nu mdiꞌin sꞌni, nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Xa wa ynan Herodes chaꞌ nu ykwiꞌ nten chaꞌ ꞌin Jesús, xiyaꞌ ykwiꞌ ree kanꞌ: ―Wa ndyuꞌu ayman Xuwa xiyaꞌ ―ndukwin―. Naꞌ nguloǔn tñan ꞌin nten, loꞌo mdijin kuꞌ neꞌ ke Xuwa kanꞌ bra kanꞌ; ja chan ayman Xuwa lka yu kiꞌyu re ―ndukwin ree Herodes. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Nu ngwa sꞌni la, wa ngulo ree Herodes kanꞌ tñan ꞌin msu ꞌin, kanꞌ chaꞌ yaa neꞌ msñi neꞌ ꞌin Xuwa kanꞌ, yaa loꞌo neꞌ ꞌin yu niꞌ ñaꞌan chkwan. Yꞌni ree chaꞌ kuxi kanꞌ siꞌya Herodías nu ngwa kwilyoꞌo Lpe taꞌa Herodes, chaꞌ wa msnan loꞌo Herodes ꞌin nu kunaꞌan kanꞌ, chaꞌ kaja kwilyoꞌo loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","―Ja nsuꞌwi chabiyaꞌ tyiꞌiin loꞌo kwilyoꞌo taꞌaa ―ndukwin Xuwa ꞌin ree Herodes ti bra kanꞌ. Kanꞌ chaꞌ msuꞌwa ree ꞌin Xuwa niꞌ ñaꞌan chkwan, chaꞌ wa ykwiꞌ yu ngwañaꞌan loꞌo ree kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Msinꞌ ꞌa tiꞌ Herodías chunꞌ chaꞌ nu ykwiꞌ Xuwa, kujwi ꞌin yu ngwa tiꞌ nu kunaꞌan kanꞌ. Loꞌo ja mjwi ñaꞌan kujwi ꞌin yu bra ti, ");
INSERT INTO ctpNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","chaꞌ ntsen ree Herodes ꞌin Xuwa. Jlyo tiꞌ ree chaꞌ ñi ꞌa chaꞌ nu yꞌni Xuwa, chaꞌ luwi ꞌa tiye Xuwa, loꞌo ja ndiꞌin chaꞌ kuxi ꞌin yu; kanꞌ chaꞌ wa naꞌansiin ree ꞌin yu chaꞌ ja kuꞌni nu kunaꞌan kanꞌ chaꞌ kuxi loꞌo yu. Ndiya tiꞌ ree Herodes kunan chaꞌ nu ngwaꞌu Xuwa, ni siya ja ngwa biyaꞌ suꞌwe tiꞌ ree chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Suꞌwe ꞌa ngwa tiye Herodías xa nu ngwa tsan ngula ykwiꞌ ree Herodes bra kanꞌ. Tsan kanꞌ yꞌni ree taꞌa, loꞌo tyun nten nu tnun nchka yku neꞌ seꞌen ndiꞌin ree bra kanꞌ. Loꞌo nten nu ndloo la ꞌin ree kanꞌ, loꞌo xꞌnan sndaru ꞌin ree, loꞌo neꞌ kuliyaꞌ nde Galilea kanꞌ, nchga nten nu tnun nchka kanꞌ, ndyaa yku neꞌ seꞌen ndiꞌin ree tsan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Bra kanꞌ mdiyan ska nu kunaꞌan kuneꞌ sñiꞌ Herodías, ngula kiyaꞌ nu kunaꞌan kanꞌ seꞌen ndiꞌin neꞌ taꞌa. Tsaa ꞌa tiꞌ ree Herodes bra kanꞌ, loꞌo ngwañaꞌan ndiya ꞌa tiꞌ neꞌ nu nchku seꞌen ndiꞌin ree naꞌan neꞌ ꞌin nu kunaꞌan kuneꞌ kanꞌ, chaꞌ ngula kiyaꞌ. Ykwiꞌ ree loꞌo nu kunaꞌan kuneꞌ kanꞌ bra kanꞌ: ―Katsaaꞌ ꞌñaǎn ni, ñaꞌaan chaꞌ suꞌwe nu nchka tiiꞌ kaja ꞌiin ―ndukwin ree ꞌin―. Taǎn chaꞌ suꞌwe kanꞌ ꞌiin ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta Ndiose nu tiꞌí ꞌñaǎn si ja taǎn nchga nan nu jñaan ꞌñaǎn ni, ni siya sa jluꞌwe yuu nu kwenta ꞌñaǎn, taǎn ꞌiin ―ndukwin ree ꞌin nu kunaꞌan kuneꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kanꞌ mdoꞌo nu kunaꞌan kuneꞌ kanꞌ, ndyaa seꞌen ndiꞌin jyaꞌan. ―¿Nan ka nu jñaǎn ꞌin ree a? ―ndukwin ꞌin jyaꞌan bra kanꞌ. ―Jñaan ke Xuwa nu ndukwatya ꞌin nten ―ndukwin jyaꞌan ꞌin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bra ti ndyaa nu kunaꞌan kuneꞌ kanꞌ tloo ree xiyaꞌ, chaꞌ jñan chaꞌ kanꞌ ꞌin ree: ―Ke Xuwa nu ndukwatya ꞌin nten nchka tiǎnꞌ kaja ꞌñaǎn ―ndukwin nu kunaꞌan kanꞌ―. Nu ni ti nchka tiǎnꞌ ke yu kanꞌ ska niꞌ siꞌyuu ―ndukwin ꞌin ree. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ni siya xiꞌin ꞌa tiꞌ ree bra kanꞌ, ja ngwa ꞌin yu tukunꞌ chaꞌ ꞌin nu kunaꞌan kanꞌ. Ja ngwa ꞌin yu, chaꞌ tloo neꞌ taꞌa nchku yu wa mskanꞌ ree chaꞌ kanꞌ, chaꞌ ta nchga nan nu jñan nu kunaꞌan kuneꞌ kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Bra ti ngulo ree tñan ꞌin ska sndaru ꞌin yu nu nduun kwan, chaꞌ tsaa ꞌya sndaru ke Xuwa. Kanꞌ mdoꞌo sndaru ndyaa niꞌ ñaꞌan chkwan, mdijin kuꞌ yu ke Xuwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ndyaan loꞌo sndaru ꞌin ran niꞌ siꞌyuu bra kanꞌ, loꞌo mda ran ꞌin nu kunaꞌan kuneꞌ kanꞌ. Ndyaa loꞌo nu kunaꞌan kanꞌ ꞌin ran seꞌen ndiꞌin jyaꞌan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Sa ñaꞌan ngwa bra kanꞌ, bra nu ynan nten nu yꞌni xaꞌan chaꞌ ꞌin Xuwa chaꞌ nskwa ayman kanꞌ, bra ti ndyaa neꞌ nde seꞌen nskwa yu. Bra kanꞌ ndyaa neꞌ mtsiꞌ neꞌ ꞌin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Chunꞌ ndiꞌin la chinꞌ, xiyaꞌ ndyaan neꞌ taꞌa ndaꞌan Jesús seꞌen ndiꞌin yu, ti kwiꞌ nten nu yaa ykwiꞌ loꞌo neꞌ xka kichen chaꞌ ꞌin Jesús. Ytsaꞌ neꞌ ꞌin yu nchga tñan nu wa yꞌni neꞌ, sa ñaꞌan nu ngwaꞌu neꞌ ꞌin nten la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ykwiꞌ Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Tsaan chinꞌ xka seꞌen, seꞌen tyiꞌian ti ykwiinꞌ tian, chaꞌ xitñaꞌ wan chinꞌ ―ndukwin Jesús ꞌin tii tyukwa neꞌ kanꞌ. Ngwañaꞌan ykwiꞌ Jesús loꞌo neꞌ kanꞌ, chaꞌ kaꞌan ꞌa nten nsuꞌwi seꞌen ndiꞌin neꞌ, loꞌo ja yuꞌwi bra ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Mdoꞌo neꞌ ndyaa neꞌ niꞌ yka naꞌan xuwe ti bra kanꞌ, chaꞌ tsaa neꞌ la seꞌen ja nsuꞌwi nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Loꞌo tyun nten naꞌan la seꞌen ndyaa neꞌ. Yuꞌwi lyo nten kanꞌ ꞌin neꞌ, loꞌo bra ti ynen chaꞌ tyun kichen la nde yaꞌ ndyaa neꞌ. Kanꞌ chaꞌ msnan nten kichen kanꞌ ndyaa neꞌ tuꞌwa tiyuꞌ, sa bra nu kulo ndukwa mdiyan neꞌ kanꞌ seꞌen ndyaa Jesús loꞌo taꞌa ndaꞌan yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Bra wa mdiyan yka naꞌan xuwe ti tuꞌwa tiyuꞌ, mdoꞌo Jesús naꞌan yu chaꞌ kaꞌan ꞌa nten ndiꞌin nde kwa. Tꞌnan ꞌa tiꞌ Jesús ñaꞌan yu ꞌin nten kaꞌan kanꞌ bra kanꞌ; mskeꞌ tiꞌ yu chaꞌ ñaꞌan tiꞌ slyaꞌ nu ja nsuꞌwi nten nu ñaꞌansiin ꞌin iꞌ, ngwañaꞌan ngwa nten kaꞌan kanꞌ. Kanꞌ chaꞌ chan ngwaꞌu yu kaꞌan ꞌa chaꞌ ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Bra nu wa ngwa msiin, bra kanꞌ ndijyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu tloo yu chaꞌ chkwiꞌ neꞌ loꞌo yu: ―Niꞌ kixinꞌ lka re ―ndukwin neꞌ―, loꞌo msiin ꞌa ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Suꞌwe la si kuloo tñan ꞌin nten kaꞌan re chaꞌ tyaa neꞌ nde kichen kwiꞌ seꞌen ti, chaꞌ xiꞌi neꞌ nan ku neꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","―ꞌWan, ta wan nan ku neꞌ re ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ―¿Ta tyoꞌo skwa tukwa siyentu tñi plata xiꞌi ba jaxlya tejeꞌ ku neꞌ re a?, yu kula ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","―¿Ni sa nkwa jaxlya tejeꞌ nsuꞌwi ꞌwan nde re a? ―ndukwin Jesús―. Lkwa wan chinꞌ ꞌin ran ―ndukwin ꞌin neꞌ. Mdaꞌan naan neꞌ si loꞌo chinꞌ nan ku ndaꞌan nten kanꞌ, loꞌo xiyaꞌ ykwiꞌ neꞌ loꞌo Jesús bra kanꞌ: ―Kiꞌyu ti jaxlya tejeꞌ loꞌo tukwa ti kula loꞌo ꞌin neꞌ nde ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Loꞌo ngulo Jesús tñan ꞌin nchga nten kanꞌ, chaꞌ tyan neꞌ tyukwa neꞌ lo kii xuwe kwenta ta ti neꞌ bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","kwenta ska siyentu nten ska ta, kwenta tuꞌwatyii nten xka ta, ngwañaꞌan mdukwa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kanꞌ msñi Jesús ꞌin kiꞌyu jaxlya tejeꞌ loꞌo tukwa kula kanꞌ, naꞌan yu nde kwan chaꞌ tya yu xuꞌwe ꞌin Ndiose chaꞌ ꞌin jaxlya loꞌo kula kanꞌ. Msuꞌwe yu jaxlya bra kanꞌ, mda yu yuꞌwe jaxlya ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ kutsaa neꞌ ran ꞌin nten kaꞌan kanꞌ; kwiꞌ ngwañaꞌan msuꞌwe yu kula kanꞌ chaꞌ ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ngwañaꞌan ngwa chaꞌ yku nchga nten kanꞌ, ngulaꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Bra nu mdyii yku neꞌ, mxoꞌ tiꞌin neꞌ nchga yuꞌwe nu ngunun, loꞌo yuꞌwe jaxlya loꞌo yuꞌwe kula; mxaꞌan tii tyukwa xkuwi loꞌo yuꞌwe kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngwañaꞌan ngwa chaꞌ kiꞌyu mi yu kiꞌyu yku jaxlya loꞌo kula nu ngwa tsan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Bra ti ngulo Jesús tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ sten neꞌ niꞌ yka naꞌan xuwe ti, chaꞌ tsaa neꞌ nde loo la seꞌen tsaa yu la xka laꞌa tsuꞌ tiyuꞌ, nde kichen Betsaida. Kanun Jesús chaꞌ slaaꞌ loꞌo nten kaꞌan kanꞌ, chaꞌ tyaa neꞌ tuꞌ naꞌan tyi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nu wa mslaaꞌ loꞌo neꞌ, mdoꞌo Jesús ndyaa xka ti yu nde siꞌ kiꞌya chaꞌ chkwiꞌ yu loꞌo Ndiose Sti yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bra wa ndyaa kwichaa ndiꞌin neꞌ nu ngiꞌni xaꞌan tijyuꞌ lo tyiꞌa niꞌ yka naꞌan xuwe ti, nganun Jesús xka ti lo yuu wtyi tuꞌwa tiyuꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Naꞌan Jesús chaꞌ lye ꞌa ngiꞌni neꞌ tñan chaꞌ tyaꞌan yka naꞌan kanꞌ lo tyiꞌa, chaꞌ ngula ꞌa nxkwa kwiꞌin lo tyiꞌa. Wa kiꞌya ti xaa, bra kanꞌ mdiyan Jesús ndaꞌan lo tyiꞌa ti, wa tyijin ti yu seꞌen ndiꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bra kanꞌ naꞌan neꞌ ꞌin yu ndaꞌan yu lo tyiꞌa. Msiꞌya ꞌa neꞌ bra kanꞌ, chaꞌ lka yu ska ayman, mskeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Naꞌan taꞌa neꞌ ꞌin yu, loꞌo ytsen ꞌa neꞌ bra kanꞌ. Bra ti ytsaꞌ Jesús ꞌin neꞌ: ―¡Kuꞌni tnun tiye wan, naꞌ lkaǎn! ―ndukwin yu―. ¡Ja kutsen wan! ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Bra kanꞌ yten Jesús niꞌ yka naꞌan loꞌo neꞌ, bra ti ngwa tiin kwiꞌin kanꞌ bra kanꞌ. Yuwe ꞌa tiꞌ neꞌ bra kanꞌ, mdaꞌan ꞌa chaꞌ tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Loꞌo ja ngwiꞌya neꞌ kwenta siyaꞌ ti sa ñaꞌan ngwa chaꞌ mdaꞌan Jesús lo tyiꞌa. Ti kwiꞌ ti chaꞌ, ja ngwa biyaꞌ tiꞌ neꞌ sa ñaꞌan nu yꞌni Jesús bra nu msuꞌwe yu jaxlya kanꞌ. Nan wa nchkunꞌ ke neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Chunꞌ ndiꞌin la mdiyan yka naꞌan kanꞌ xka laꞌa tsuꞌ tiyuꞌ loꞌo neꞌ, nde lo yuu ꞌin Genesaret mdiyan neꞌ bra kanꞌ. Mskanꞌ neꞌ ꞌin yka naꞌan kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","mdoꞌo neꞌ bra kanꞌ. Bra ti yuꞌwi lyo nten nu kwa tyi kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Msnan neꞌ ndyaa neꞌ seꞌen ndiꞌin neꞌ tiꞌí ꞌin neꞌ, chaꞌ kan loꞌo neꞌ ꞌin neꞌ tiꞌí kanꞌ seꞌen ndiꞌin Jesús; neꞌ kichen kwiꞌ seꞌen ti, neꞌ kichen nu tijyuꞌ la chinꞌ, ngwiꞌya loꞌo neꞌ ꞌin nu tiꞌí ndijyan. Niꞌ katan, o ta lo jaaꞌ ti ndijyan ꞌya neꞌ ꞌin nu tiꞌí seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Tyun kichen seꞌen ndyaa Jesús, loꞌo kichen tnun, loꞌo kichen xuwe ti, loꞌo seꞌen ndiya neꞌ niꞌ kixinꞌ, nchga seꞌen ndaꞌan yu ndijyan loꞌo neꞌ ꞌin nu tiꞌí ꞌin neꞌ. Mjñan neꞌ chabiyaꞌ ꞌin Jesús chaꞌ kalaꞌ ti nu tiꞌí ni siya kiyaꞌ steꞌ ti yu. Loꞌo nchga nu tiꞌí nu ylaꞌ steꞌ Jesús ni, bra ti nchkaa neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ngwa ska tsan mdiyan ska ta neꞌ fariseo, mdaꞌan neꞌ loꞌo chinꞌ mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa nde kichen Jerusalén. Mdiyan neꞌ nde seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yuwe ꞌa tiꞌ neꞌ kanꞌ, chaꞌ ndiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús nu nchku tyaja ni siya ja ya mnaꞌ neꞌ sa ñaꞌan nu nduꞌu mstru chaꞌ joꞌo ꞌin neꞌ chaꞌ kuꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Neꞌ fariseo, loꞌo nchga neꞌ judío, ja ka ku neꞌ si ja ya mnaꞌ suꞌwe neꞌ sa ñaꞌan nu ndukwa chaꞌ lo kityi kula sꞌni chaꞌ kuꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Xa nu ndaꞌan neꞌ lo kiyaꞌ chaꞌ xiꞌi neꞌ ska nan ku neꞌ, ndijyan loꞌo neꞌ ꞌin ran niꞌ ñaꞌan, ja nsuꞌwi chabiyaꞌ ku neꞌ ꞌin ran bra kanꞌ, si ja ya kuꞌni luwi neꞌ ꞌin tyukwi ñaꞌan neꞌ. Kaꞌan ꞌa tñan kti ti wa ngwaꞌu ayman kula ꞌin neꞌ judío chaꞌ kuꞌni neꞌ; sa ñaꞌan nu katen sa ꞌin neꞌ, sa ñaꞌan nu katen styu, sa ñaꞌan nu katen katunꞌ chkwan, sa ñaꞌan nu katen kaꞌnan, chaꞌ ka luwi ska nan chaꞌ ꞌin Ndiose, nxkeꞌ tiꞌ neꞌ.) ");
INSERT INTO ctpNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kanꞌ chaꞌ mnichaꞌ neꞌ ꞌin Jesús bra kanꞌ, neꞌ fariseo kanꞌ loꞌo mstru nu nduꞌu chaꞌ joꞌo kanꞌ: ―¿Ni chaꞌ lka ja suꞌwe ngiꞌni neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin? ―ndukwin neꞌ ꞌin yu―. Ja ndukwa neꞌ kwa tñan nu wa ngwaꞌu ayman kula ꞌñaan nu ngwa sꞌni, chaꞌ ja mnaꞌ suꞌwe neꞌ bra nu ku neꞌ tyaja ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Chañi ꞌa chaꞌ nu ykwiꞌ ayman Isaías ꞌwan nu ngwa sꞌni, chaꞌ nten nu tukwa chaꞌ nsuꞌwi tiye lka wan. Wa ngwaꞌan yu kula kanꞌ chaꞌ re lo kityi ꞌin Ndiose: Ngiꞌni tnun nten re ꞌñaǎn chaꞌ nchkwiꞌ ti neꞌ, ndukwin Ndiose, siꞌi tyukwi ti tiye neꞌ ngiꞌni tnun neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kwiñi ꞌa nchkwiꞌ neꞌ re chaꞌ ngiꞌni tnun neꞌ ꞌñaǎn, loꞌo nduꞌu neꞌ chaꞌ nu nchkwiꞌ nten ti ꞌin taꞌa neꞌ, ni siya ndukwin neꞌ chaꞌ nduꞌu neꞌ chaꞌ ꞌñaǎn ꞌin taꞌa neꞌ, ndukwin Ndiose. Ngwañaꞌan ndukwa chaꞌ lo kityi. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ja nduwe tiꞌ wan sa ñaꞌan tñan nu ngulo Ndiose ꞌin nten chalyuu; tñan nu ngwaꞌu ayman kula ꞌñaan, kanꞌ ti tñan ndukwa wan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ti ykwiꞌ la Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Wa ngulaa yaꞌ wan tñan nu ngulo Ndiose ꞌñaan, loꞌo ni, ndloo la chaꞌ ꞌwan, chaꞌ tukwa wan nchga chaꞌ nu ngwaꞌu ayman kula ꞌñaan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","¿Ja nsuꞌwi tiꞌ wan chaꞌ nu ykwiꞌ ayman Moisés loꞌo nten chabiyaꞌ ꞌin Ndiose sꞌni a? “Tukwa wan chaꞌ nu nchkwiꞌ sti wan, chaꞌ nu nchkwiꞌ jyaꞌan wan” ndukwin. “Si chkwiꞌ wan chaꞌ kuxi ꞌin sti jyaꞌan wan, ndiꞌin chaꞌ kujwi neꞌ ꞌwan bra kanꞌ” ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Loꞌo kuxi ꞌa chaꞌ nu nchkwiꞌ wan. Nduꞌu wan ꞌin nten chaꞌ chaꞌ suꞌwe lka xa nu chkwiꞌ ska nten chaꞌ re loꞌo sti loꞌo jyaꞌan: “Ja ka ꞌa ꞌñaǎn tayaǎnꞌ ꞌwan, chaꞌ nan Corbán lka nchga nan nu nsuꞌwi ꞌñaǎn.” (Corbán lka ska chaꞌ ꞌin neꞌ kanꞌ nu nchkwiꞌ chaꞌ ska nan nu wa mda neꞌ xuꞌwe ꞌin Ndiose.) ");
INSERT INTO ctpNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Loꞌo ja nda wan chabiyaꞌ chaꞌ tayaꞌ nten kanꞌ ꞌin sti ꞌin jyaꞌan neꞌ bra kanꞌ ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ja suꞌwe chaꞌ nduꞌu wan ꞌin nten ngwañaꞌan. Ja ndukwa wan tñan nu ngulo Ndiose ꞌñaan, bra nu ngwañaꞌan nduꞌu wan ꞌin neꞌ; lye la ndukwa wan chaꞌ nu ytsaꞌ ayman kula ꞌwan ꞌin wan. Loꞌo ti kaꞌan la chaꞌ kuxi ngiꞌni wan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Xiyaꞌ msiꞌya Jesús ꞌin nten kaꞌan chaꞌ kan neꞌ seꞌen ndiꞌin yu bra kanꞌ. ―Nchga wan kunan suꞌwe wan nchga chaꞌ nu kwaꞌuǔn ꞌwan ni, chaꞌ ka biyaꞌ tiꞌ wan ska chaꞌ ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ja ndiya nan nchku nten nu kuꞌni chaꞌ ka kuxi tiye neꞌ ―ndukwin yu―. Nu nchkwiꞌ neꞌ ska chaꞌ, nu ngiꞌni neꞌ ska tñan, ngwañaꞌan ka biyaꞌ tianꞌ si kuxi nka tiye neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Taꞌa wan kunan suꞌwe wan chaꞌ kanꞌ ni, si nchka tiꞌ wan ―ndukwin Jesús ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Chunꞌ ndiꞌin la, yaa Jesús niꞌ ñaꞌan. Nganun nten kaꞌan kanꞌ chunꞌ naꞌan ti. Kanꞌ mnichaꞌ nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu, sa ñaꞌan lka chaꞌ nu wa ngwaꞌu yu ꞌin neꞌ tsan ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","―¿Loꞌo ꞌwan, ja ngwa biyaꞌ tiꞌ wan chaꞌ kanꞌ a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿Ja jlyo tiꞌ wan chaꞌ siꞌi nan nu kuan nu kuꞌni chaꞌ ka kuxi tiyean a? Ja ka ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bra nu kuan ska nan, bra kanꞌ sten nan kanꞌ tu tuꞌwaan, ka tiꞌin ran kanꞌ nde nianꞌ bra kanꞌ; xa nu tsaan liyaꞌ, tyii ji chaꞌ ꞌin ran bra kanꞌ ―ndukwin Jesús. Ngwañaꞌan ykwiꞌ Jesús chaꞌ ka biyaꞌ tianꞌ chaꞌ suꞌwe kuan nchga nan nu nchku nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ti ngwaꞌu la Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Chaꞌ nu wa ykwiꞌ ska nten, chaꞌ nu wa yꞌni ska nten, chunꞌ chaꞌ kanꞌ ka biyaꞌ tianꞌ bra nu nsuꞌwi chaꞌ kuxi niꞌ kasiya ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bra nu chañi chaꞌ nsuꞌwi chaꞌ kuxi niꞌ kasiya ꞌin nten, kaꞌan ꞌa chaꞌ kuxi kuꞌni neꞌ kanꞌ bra kanꞌ: xuꞌwi chaꞌ ꞌin neꞌ loꞌo kwilyoꞌo xka nten, kuꞌni neꞌ chaꞌ chen ñaꞌan loꞌo xka nten, kujwi neꞌ ꞌin taꞌa neꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","kuꞌni neꞌ kunan chaꞌ nu nsuꞌwi ꞌin taꞌa nten neꞌ, xitukwi tiꞌ neꞌ ꞌin ska nan nu nsuꞌwi ꞌin xka nten, ka tiꞌí tiꞌ neꞌ ꞌin taꞌa nten neꞌ, tukwa chaꞌ ka tiye neꞌ, xaꞌan ꞌa kuꞌni neꞌ, ka liyeꞌ tiꞌ neꞌ, kwentu ꞌa ka neꞌ, siyeꞌ ꞌa chkwiꞌ neꞌ, loꞌo ja ska chaꞌ kuwe tiꞌ neꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nchga chaꞌ kuxi kanꞌ wa nsuꞌwi tiye nten, kanꞌ chaꞌ ndiya tiꞌ neꞌ kuꞌni neꞌ chaꞌ kuxi kanꞌ. Kanꞌ lka chaꞌ kuxi nu ngiꞌni nten chalyuu chaꞌ ja luwi kasiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa tijyuꞌ nde lo yuu ꞌin kichen Sidón loꞌo kichen Tiro bra kanꞌ. Ngwa tiꞌ yu chaꞌ kanun yu ska niꞌ ñaꞌan mnan ti nde kwa; loꞌo ja ngwa ꞌin yu, chaꞌ bra ti mjwi rsun ꞌin neꞌ kichen chaꞌ ndiꞌin yu kwiꞌ seꞌen ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Loꞌo mjwi rsun kanꞌ ꞌin ska nu kunaꞌan nu ndiꞌin kichen kanꞌ, kanꞌ chaꞌ mdiyan seꞌen ndiꞌin yu. Wa msñi ska kwiꞌin kuxi ꞌin ska nu kunaꞌan xuwe sñiꞌ nu kunaꞌan kanꞌ; kanꞌ chaꞌ mduun xtyinꞌ jyaꞌan nu xuwe ti tloo Jesús, ");
INSERT INTO ctpNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","mjñan chaꞌ tlyu tiꞌ ꞌin yu, chaꞌ kulo yu kwiꞌin kuxi nu nsuꞌwi ꞌin sñiꞌ, nka tiye. Chaꞌ ꞌin neꞌ griego nchkwiꞌ nu kunaꞌan kanꞌ, chaꞌ neꞌ xka laꞌa tsuꞌ lka, neꞌ sirofenicia. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","―Ti kulo nda neꞌ nan ku sñiꞌ neꞌ ―ndukwin Jesús―. Ja suꞌwe si xñi neꞌ tyaja nu nchku sñiꞌ neꞌ chaꞌ ta neꞌ ꞌin xneꞌ ti ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","―Chañi chaꞌ ꞌiin ―ndukwin nu kunaꞌan―, loꞌo nsuꞌwi chabiyaꞌ ku xneꞌ kata tyaja nu ngalu niꞌ msaa laja nu nchku nu xuwe ―ndukwin ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","―Suꞌwe ꞌa chaꞌ nchkwiiꞌ ―ndukwin Jesús―. Suꞌwe ti tyaa naꞌan tyii, chaꞌ wa nchkaa sñiiꞌ ni ―ndukwin yu ꞌin nu kunaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Mdoꞌo nu kunaꞌan kanꞌ ndyaa bra kanꞌ, ngala naꞌan tyi seꞌen nskwa sñiꞌ lo kiꞌyan. Bra kanꞌ naꞌan nu kunaꞌan chaꞌ wa nchkaa sñiꞌ, ja nsuꞌwi ꞌa kwiꞌin kuxi ꞌin ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mdoꞌo Jesús kichen Tiro bra kanꞌ, mdijin yu kichen Sidón, mdijin yu nde Decápolis, ti kwiꞌ lo yuu nu kwenta ꞌin tii kichen. Bra kanꞌ mxitukwi yu ndyaan yu tuꞌwa tiyuꞌ Galilea xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Loꞌo mdiyan chinꞌ nten seꞌen ndiꞌin Jesús bra kanꞌ, ndijyan loꞌo neꞌ ꞌin ska yu kuꞌun. Kuꞌun tu nskan yu, kwiꞌ ngwañaꞌan ja ngwa chkwiꞌ suꞌwe yu. Kanꞌ ykwiꞌ neꞌ loꞌo Jesús chaꞌ xtya yaꞌ yu ke yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Loꞌo ndyaa loꞌo Jesús ꞌin yu tiꞌí kanꞌ ska seꞌen nu ja ñaꞌan nten, ni siya kwiꞌ seꞌen ti. Bra kanꞌ yojoꞌ xñii yaꞌ Jesús tu nskan yu tiꞌí kanꞌ, loꞌo mdoꞌo tyiꞌa nu ndyoꞌo tuꞌwa yu lo xñii yaꞌ yu, mstya ran loo ltseꞌ yu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kanꞌ naꞌan Jesús nde niꞌ kwan, lye ꞌa ynen ndyaan tyiꞌi yu bra kanꞌ. ―¡Efata! ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ bra kanꞌ. Kanꞌ nu nchka tiꞌ chkwiꞌ: ¡Kalaa tu nskaan! ");
INSERT INTO ctpNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Bra ti ngalaa tu nskan yu tiꞌí kanꞌ; ynan suꞌwe yu, ngwa suꞌwe ltseꞌ yu chaꞌ suꞌwe ti ykwiꞌ yu loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kanꞌ ngulo Jesús tñan ꞌin neꞌ kanꞌ, chaꞌ ja katsaꞌ neꞌ ꞌin nten sa ñaꞌan ngwa ꞌin yu tiꞌí kanꞌ; loꞌo ja ynan neꞌ, lye la ynen chaꞌ kanꞌ, ni siya lye ngulo Jesús tñan ꞌin neꞌ chaꞌ ja katsaꞌ ꞌa neꞌ ꞌin taꞌa nten neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yuwe ꞌa tiꞌ nten bra nu ynan neꞌ sa ñaꞌan ngwa chaꞌ kanꞌ. ―Suꞌwe ꞌa ngiꞌni yu kanꞌ ―ndukwin neꞌ―, loꞌo ꞌin neꞌ nu kuꞌun tu nskan, nchka ꞌin yu kuꞌni yu chaꞌ nchkaa neꞌ; loꞌo neꞌ nu kuꞌun tuꞌwa, nchkwiꞌ neꞌ xiyaꞌ chabiyaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chunꞌ ndiꞌin la chinꞌ, xiyaꞌ mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin Jesús. Wa tsan ndiꞌin neꞌ, kanꞌ chaꞌ ja nsuꞌwi ꞌa nan ku neꞌ bra kanꞌ. Loꞌo ykwiꞌ Jesús loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Tꞌnan ꞌa tiǎnꞌ ꞌin nten kaꞌan re ―ndukwin―, chaꞌ snan tsan wa mdaꞌan neꞌ loꞌoǔn. Loꞌo ja nsuꞌwi siyaꞌ ti nan ku neꞌ ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Kanꞌ chaꞌ ja suꞌwe kuloǔn tñan ꞌin neꞌ chaꞌ tyaa neꞌ, chaꞌ ndijin jwiꞌñan neꞌ ndaꞌan neꞌ; ja talo ꞌa neꞌ tuwiin tyaa neꞌ naꞌan tyi neꞌ, chaꞌ ndiꞌin chinꞌ nten re nu tijyuꞌ ꞌa ndijyan neꞌ ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","―¿Ni sa ñaꞌan kuꞌni ba seꞌen tijyuꞌ re a? ―ndukwin neꞌ kanꞌ bra kanꞌ―. Ja tukwin ndiꞌin nde re. Ja kaja sa ñaꞌan nu taan nan ku neꞌ re ―ndukwin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","―¿Ni nkwa jaxlya nsuꞌwi ꞌwan a? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ. ―Kati ti jaxlya tejeꞌ loꞌo ꞌwa ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Bra kanꞌ ngulo Jesús tñan ꞌin nten kaꞌan kanꞌ, chaꞌ tyukwa neꞌ lyuu. Msñi yu kati jaxlya tejeꞌ kanꞌ, ndya yu xuꞌwe ꞌin Ndiose chaꞌ ndiya nan ku neꞌ. Bra kanꞌ msuꞌwe yu jaxlya kanꞌ, mda yu yuꞌwe jaxlya ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kutsaa neꞌ ran ꞌin nten kaꞌan kanꞌ, chaꞌ ku neꞌ ran. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Loꞌo chinꞌ kula xuwe nsuꞌwi ꞌin neꞌ; kanꞌ chaꞌ bra nu nkwan Jesús ꞌin kula kanꞌ, ngulo yu tñan chaꞌ loꞌo kutsaa neꞌ yuꞌwe kula kanꞌ ꞌin nten kaꞌan kanꞌ, chaꞌ ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Yku nchga nten kanꞌ, loꞌo mlaꞌ ꞌa tiꞌ neꞌ bra kanꞌ. Kanꞌ mxoꞌ tiꞌin neꞌ nchga yuꞌwe jaxlya loꞌo kula taꞌa nu ngunun seꞌen yku neꞌ, msaꞌan kati xkuwi loꞌo yuꞌwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ti kwiꞌ tsan kanꞌ wa yku jakwa mi nten. Mslaaꞌ Jesús loꞌo nten kaꞌan kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","bra kanꞌ yten yu niꞌ yka naꞌan xuwe loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa yu loꞌo neꞌ nde ska seꞌen naan Dalmanuta. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Chunꞌ ndiꞌin la mdoꞌo tukwa chinꞌ neꞌ fariseo seꞌen ndiꞌin Jesús. Ngwa tiꞌ neꞌ tyijin lyo neꞌ ꞌin Jesús loꞌo ska chaꞌ tukwi, kanꞌ chaꞌ mjñan neꞌ ꞌin yu chaꞌ kuꞌni yu ska chaꞌ tnun chabiyaꞌ ꞌin Ndiose nu ndiꞌin nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Lye ꞌa ynen mda yu tyiꞌi yu, mxkwen yu ꞌin neꞌ bra kanꞌ: ―¿Ni chaꞌ nchka ra tiꞌ nten chalyuu re chaꞌ kuꞌniǐn ska chaꞌ tnun chabiyaꞌ ꞌin Ndiose? Chañi chaꞌ nchkwiǐnꞌ loꞌo wan, chaꞌ ja ta ꞌa Ndiose chabiyaꞌ ñaꞌan kwiꞌya wan ska chaꞌ tnun ngwañaꞌan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Loꞌo ngulaa tiꞌin yu ꞌin neꞌ fariseo kanꞌ bra kanꞌ. Xiyaꞌ yten yu niꞌ yka naꞌan xuwe ti loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kanꞌ, mdijin neꞌ lo tiyuꞌ, mdoꞌo neꞌ xka laꞌa tsuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, mjlyaa tiꞌ neꞌ chaꞌ tsaa loꞌo neꞌ nan ku neꞌ tsan kanꞌ; ska ti jaxlya tejeꞌ loꞌo ꞌin neꞌ niꞌ yka naꞌan xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Bra kanꞌ ngwaꞌu Jesús ska chaꞌ ꞌin neꞌ: ―Ndii ti tiꞌ wan tyiꞌin wan ―ndukwin yu―, kiꞌya wan kwenta sa ñaꞌan ngiꞌni chaꞌ nu nchkwiꞌ neꞌ fariseo loꞌo neꞌ nu ndaꞌan chabiyaꞌ ꞌin ree Herodes. Ñaꞌan tiꞌ skwan tiyeꞌ, ngwañaꞌan ngiꞌni chaꞌ nu nchkwiꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Mnan ti ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo taꞌa neꞌ bra kanꞌ: ―Chunꞌ ja loꞌo jaxlya tejeꞌ ꞌñaan ndyaꞌaan, kanꞌ chaꞌ ykwiꞌ yu chaꞌ ꞌin skwan tiyeꞌ loꞌoan ―ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mgii tiꞌ Jesús chaꞌ ja ngwa biyaꞌ tiꞌ neꞌ kanꞌ. ―¿Ni chaꞌ lka nduwe tiꞌ wan chaꞌ ja nsuꞌwi nan ku wan? ―ndukwin yu ꞌin neꞌ kanꞌ bra kanꞌ―. ¿Ja jlyo tiꞌ wan a? ¿Ta ja nchka biyaꞌ tiꞌ wan a? ¿O ta nchkunꞌ ke wan a? ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nsuꞌwi kiloo wan, loꞌo ja nchka ñaꞌan wan. Ndukwa tu nskan wan, loꞌo ja nchka kunan wan. ¿Ta ja ndyuꞌwi ꞌa tiꞌ wan siyaꞌ ti a? ");
INSERT INTO ctpNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Bra nu msuꞌweěn kiꞌyu jaxlya tejeꞌ nu yku kiꞌyu mi nten kanꞌ, ¿ni sa ñaꞌan nkwa xkuwi nsuꞌwi nu msaꞌan loꞌo yuꞌwe jaxlya nu wa mxoꞌ tiꞌin wan bra kanꞌ? ―ndukwin Jesús ꞌin neꞌ. ―Tii tyukwa xkuwi ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Kwiꞌ ngwañaꞌan bra nu msuꞌweěn kati jaxlya tejeꞌ nu yku jakwa mi nten kanꞌ, ¿ni sa ñaꞌan nkwa xkuwi nsuꞌwi nu msaꞌan loꞌo yuꞌwe jaxlya nu wa mxoꞌ tiꞌin wan bra kanꞌ? ―ndukwin yu ꞌin neꞌ. ―Kati xkuwi ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","―¿Ja ya ka biyaꞌ tiꞌ wan sikwa a? ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Chunꞌ ndiꞌin la mdiyan neꞌ nde kichen Betsaida. Bra ti mdiyan loꞌo neꞌ kichen ꞌin ska yu kwityiinꞌ seꞌen ndiꞌin Jesús. Mjñan ꞌa neꞌ ꞌin yu chaꞌ xtya yaꞌ yu ke yu tiꞌí, ngwa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kanꞌ chaꞌ msñi Jesús yaꞌ yu kwityiinꞌ kanꞌ, ndyaa loꞌo yu ꞌin yu nde tuꞌwa kichen. Loꞌo msuꞌwa Jesús chinꞌ tyiꞌa nu ndyoꞌo tuꞌwa yu kiloo yu tiꞌí bra kanꞌ, mstya yaꞌ yu kiloo yu kwityiinꞌ kanꞌ bra kanꞌ. ―¿Ta ka ñaꞌaan ska nan ni a? ―ndukwin Jesús ꞌin yu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Naꞌan kwiꞌya yu tiꞌí chinꞌ kwiꞌ seꞌen ti bra kanꞌ. ―Nchka ñaꞌaǎn chinꞌ ti ―ndukwin yu tiꞌí―. Sa ndijin ti chkanꞌ ñaꞌaǎn chinꞌ, ñaꞌan tiꞌ yka ñaꞌan nten, loꞌo ndaꞌan ran ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Xiyaꞌ mstya yaꞌ Jesús kiloo yu tiꞌí kanꞌ. Bra ti nchkaa kiloo yu bra kanꞌ, ngwa ñaꞌan suꞌwe yu ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kanꞌ ngulo Jesús tñan ꞌin yu chaꞌ tyaa yu naꞌan tyi yu: ―Ja tsaa ꞌaa lo kichen ni, ja katsaaꞌ ꞌin nten nan lka nu ngwa ꞌiin ―ndukwin Jesús ꞌin yu nu ngwa tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa neꞌ tyun kichen xuwe ti nde lo yuu ꞌin Cesarea de Filipo. Laja nu ndaꞌan neꞌ tuwiin, mnichaꞌ Jesús ꞌin neꞌ bra kanꞌ: ―Nu nchkwiꞌ nten chaꞌ ꞌñaǎn ni, ¿ti ka nu lkaǎn, nxkeꞌ tiꞌ neꞌ? ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","―Nsuꞌwi nten nu nchkwiꞌ chaꞌ ayman Xuwa nu mdukwatya ꞌin nten nu ngwa sꞌni lkaa ―ndukwin neꞌ―. Xka ta nten ni, nchkwiꞌ neꞌ chaꞌ ayman Elías lkaa; loꞌo xka ta nten ni, nchkwiꞌ neꞌ chaꞌ ska ayman nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose sꞌni lkaa. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","―Loꞌo ꞌwan ni ―ndukwin Jesús―, ¿ti ka nu lkaǎn, nxkeꞌ tiꞌ wan? ―ndukwin yu ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Bra ti mxkwen Tyu ꞌin yu bra kanꞌ: ―Krixtu lka nuꞌwin ―ndukwin Tyu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Loꞌo ngulo Jesús tñan ꞌin neꞌ bra kanꞌ, chaꞌ ja katsaꞌ neꞌ chaꞌ kanꞌ ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Loꞌo kanꞌ mdyisnan Jesús ngwaꞌu la yu ꞌin neꞌ: ―Ndiose msuꞌwa ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, loꞌo ndiꞌin chaꞌ tyijiǐn kaꞌan ꞌa nu tiꞌí ―ndukwin Jesús ꞌin neꞌ―. Nde loo la chkwiꞌ ꞌa neꞌ kwentu ꞌñaǎn; loꞌo neꞌ kula, loꞌo sti joꞌo nu lka ndloo la, loꞌo mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa, nchga neꞌ kanꞌ chkwiꞌ neꞌ chaꞌ nu kwiñi lkaǎn. Kujwi neꞌ ꞌñaǎn bra kanꞌ; loꞌo bra wa mdaꞌa snan tsan, bra kanꞌ tyuꞌuǔn xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ñi ngwaꞌu Jesús chaꞌ kanꞌ ꞌin nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu; kanꞌ chaꞌ msñi Tyu yaꞌ Jesús bra kanꞌ, ngwa tiꞌ Tyu tukunꞌ chaꞌ ꞌin yu, chaꞌ ja chkwiꞌ ꞌa yu ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Loꞌo mxitukwi Jesús seꞌen nduun bra kanꞌ, naꞌan yu ꞌin taꞌa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdukunꞌ yu chaꞌ nu ykwiꞌ Tyu siyaꞌ ti bra kanꞌ. ―¡Tyoꞌo tsuꞌ ꞌñaǎn, Satanás! ―ndukwin yu ꞌin Tyu―. ¡Ja tukunꞌ loo chaꞌ ꞌñaǎn! Siꞌi sa ñaꞌan nu nchka tiꞌ Ndiose nka tiye nuꞌwin ni, sa ñaꞌan nu ndaꞌan chaꞌ tiye nten chalyuu ti nka tiyee ni ―ndukwin Jesús ꞌin Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kanꞌ msiꞌya Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, loꞌo ꞌin nten kaꞌan nu mdoꞌo ñaꞌan ꞌin yu, msiꞌya yu ꞌin neꞌ chaꞌ kan neꞌ seꞌen ndiꞌin yu. Ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Nten nu tyukwi ti tiye nchka tiꞌ tyaꞌan loꞌoǔn ―ndukwin yu ꞌin neꞌ―, ndiꞌin chaꞌ xnun neꞌ kanꞌ nchga chaꞌ nu nsuꞌwi ꞌa tiye neꞌ, chaꞌ tyaꞌan neꞌ loꞌoǔn nchga tsan, ni siya kujwi nten ꞌin neꞌ kanꞌ chunꞌ ndyaa ñaꞌan tiꞌ neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kanaꞌ chalyuu ꞌin neꞌ si xkwiꞌ ndaꞌan chaꞌ tiye neꞌ sa ñaꞌan ka kuꞌni neꞌ chaꞌ tyuꞌu neꞌ, ti ykwiꞌ ti neꞌ; loꞌo kaja chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ, si xlyaa neꞌ tsaa neꞌ loꞌoǔn, ni siya kujwi nten ꞌin neꞌ chaꞌ ꞌñaǎn, chunꞌ ntsaꞌ neꞌ chaꞌ suꞌwe ꞌñaǎn ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Loꞌo nten nu xkwiꞌ ndaꞌan chaꞌ tiye ꞌin ti ykwiꞌ ti, ja kanun ꞌa chaꞌ suꞌwe ꞌin neꞌ kanꞌ, ni siya wa yꞌni ꞌa neꞌ kanan bra nu mdiꞌin neꞌ lo chalyuu; nu kaja neꞌ kanꞌ ni, kanaꞌ nchga chaꞌ suꞌwe nu nsuꞌwi ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ja nchka ta nten liyaꞌ chaꞌ tyuꞌu la neꞌ lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ka jyuꞌu tiǎnꞌ bra nu ñaꞌaǎn ꞌin ska nten chalyuu nu jyuꞌu tiꞌ ꞌñaǎn, ni siya jyuꞌu tiꞌ yu ꞌin chaꞌ suꞌwe nu nchkwiǐnꞌ. Chaꞌ nchka jyuꞌu tiꞌ neꞌ kanꞌ ꞌñaǎn tloo neꞌ xaꞌan lo chalyuu ni, tloo neꞌ nu chen ñaꞌan ngiꞌni lo chalyuu re, loꞌo naꞌ, ka jyuꞌu tiǎnꞌ ꞌin neꞌ kanꞌ bra nu kaǎn lo chalyuu xiyaꞌ nde loo la. Lye ꞌa ñaꞌan xaa bra nu kaǎn xiyaꞌ chabiyaꞌ ꞌin Stiǐn. Kaǎn loꞌo angajle nu kti ꞌa tiꞌ, chaꞌ luwi siyaꞌ ti angajle kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ti ngwaꞌu la Jesús ꞌin neꞌ bra kanꞌ: ―Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌo wan ni ―ndukwin yu―, chaꞌ ndiya nten chalyuu nu ti ndiꞌin loꞌoǔn ni siya ni ti, nu ti ji kaja neꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ wa mdyisnan chaꞌ ka Ndiose ndloo la niꞌ kasiya ꞌin nten chalyuu. Tlyu ꞌa chabiyaꞌ nsuꞌwi ꞌin Ndiose chaꞌ ka Ni ndloo la ꞌin nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Xa wa mdaꞌa skwa tsan, mdoꞌo Jesús ndyaa bra kanꞌ; loꞌo Tyu, loꞌo Santiago, loꞌo Xuwa ndyaa loꞌo yu. Jakwa ti neꞌ kanꞌ ndyaa neꞌ lo kiꞌya kwan, ja loꞌo xka nten ndyaa neꞌ. La kanꞌ, laja nu naꞌan neꞌ ꞌin Jesús, wa mxaꞌan tyukwi ñaꞌaan yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Naꞌan neꞌ chaꞌ luwi ꞌa steꞌ Jesús, ngaten ꞌa ñaꞌan ran. Ja nchka ꞌin ska nten chalyuu jyaꞌan teꞌ ngwañaꞌan, ni siya jlyo ꞌa tiꞌ neꞌ sa ñaꞌan katen teꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Laja nu naꞌan neꞌ kanꞌ, mdoꞌo tukwa ayman Elías loꞌo ayman Moisés, mduun ayman kanꞌ nchkwiꞌ neꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bra kanꞌ ykwiꞌ Tyu loꞌo Jesús: ―Mstru ―ndukwin―, ¡suꞌwe ꞌa chaꞌ ndiꞌin ba loꞌoo nde re! Taa chabiyaꞌ kwiñan ba snan teꞌ naꞌan, ska ka seꞌen tyiꞌin ykwiꞌ nuꞌwin, xka ka seꞌen tyiꞌin niMoisés, xka ka seꞌen tyiꞌin niElías ―ndukwin Tyu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ytsen ꞌa Tyu loꞌo taꞌa ndaꞌan yu, kanꞌ chaꞌ ja jlyo ꞌa tiꞌ yu sa ñaꞌan ngwa chaꞌ nu ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Loꞌo mdoꞌo tukwa ska koo nu yuꞌwi nchga seꞌen nduun neꞌ bra kanꞌ, kwiꞌ ynen laja koo kanꞌ nchkwiꞌ Ndiose loꞌo neꞌ: ―Ti kwiꞌ yu re lka ska ti nu lka Sñiěnꞌ ―ndukwin Ndiose―, ndiya ꞌa tiǎnꞌ ꞌin yu re. Kunan suꞌwe wan ꞌin yu re bra nu chkwiꞌ yu loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Bra ti naꞌan neꞌ seꞌen mduun ayman kanꞌ nu ngwa tsan, naꞌan neꞌ chaꞌ ja ndiꞌin ꞌa neꞌ kanꞌ ni; siyaꞌ ti nduun snan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús loꞌo ti kwiꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kanꞌ mdoꞌo neꞌ ndijyan neꞌ, ngwiꞌya neꞌ siꞌ kiꞌya kanꞌ. Loꞌo ngulo Jesús tñan ꞌin neꞌ chaꞌ ja katsaꞌ neꞌ ꞌin xka la nten sa ñaꞌan ngwa chaꞌ nu wa naꞌan neꞌ lo kiꞌya kanꞌ. ―Bra nu kajaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, loꞌo tyuꞌuǔn xiyaꞌ, bra kanꞌ ka katsaꞌ wan chaꞌ kanꞌ ꞌin nten ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ynan neꞌ chaꞌ nu ykwiꞌ Jesús. Nduwe ꞌa tiꞌ neꞌ xa nu ykwiꞌ yu chaꞌ ndiꞌin chaꞌ tyuꞌu yu xiyaꞌ xa wa ngujwi yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Bra kanꞌ mnichaꞌ neꞌ kanꞌ ꞌin Jesús: ―Mstru nu nduꞌu chaꞌ joꞌo kanꞌ ni, ¿ni sa ñaꞌan ndyoꞌo chaꞌ nu nchkwiꞌ mstru kanꞌ a? Ndukwin neꞌ chaꞌ kulo ndukwa la ndiꞌin chaꞌ kan ayman Elías lo chalyuu re xiyaꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","―Chañi, ndiꞌin chaꞌ kan ayman Elías kulo, chaꞌ kuꞌni xuꞌwe ꞌin nchga nan ―ndukwin Jesús―. Katsaǎnꞌ ñi ꞌwan ni, chaꞌ wa lka mdiyan ayman Elías kanꞌ lo chalyuu re. Loꞌo wa yꞌni neꞌ loꞌo yu sa ñaꞌan nu ndukwa lo kityi kula chaꞌ ka ꞌin yu bra kanꞌ ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Kwiꞌ ngwañaꞌan, wa ndukwa chaꞌ ꞌñaǎn lo kityi ꞌin Ndiose, chaꞌ ndiꞌin chaꞌ tyijiǐn nu tiꞌí ni siya wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, loꞌo ndiꞌin chaꞌ chkwiꞌ neꞌ chaꞌ kuxi ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Kanꞌ mdiyan neꞌ seꞌen ndiꞌin taꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús xiyaꞌ. Wa mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin neꞌ, loꞌo mduun chinꞌ mstru nu nduꞌu chaꞌ joꞌo loꞌo neꞌ, msuun mstru kanꞌ loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yuwe ꞌa tiꞌ nten kaꞌan kanꞌ bra nu naꞌan neꞌ chaꞌ ndijyan Jesús. Msnan neꞌ seꞌen ndiꞌin yu chaꞌ chkwiꞌ neꞌ loꞌo yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","―¿Ni sa ñaꞌan chaꞌ nchkwiꞌ wan loꞌo neꞌ kwa a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Bra ti mdyisnan ykwiꞌ ska nten nu nduun laja nten kaꞌan kanꞌ: ―Mstru ―ndukwin ꞌin Jesús―, nan wa yan loꞌoǔn ꞌin sñiěnꞌ tloo nuꞌwin. Nan kuꞌun yu siꞌya kwiꞌin kuxi nu nsuꞌwi ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nchga seꞌen nxlyuu kwiꞌin kuxi kanꞌ ꞌin yu ndiyuu yu bra kanꞌ, ndyoꞌo ngoꞌ tuꞌwa yu; lye nchku liꞌya yu, loꞌo nchkunꞌ tyukwin tyukwi ñaꞌan yu. Wa mjñaǎn ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin si xlyaa neꞌ kulo neꞌ ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin yu tiꞌí re, loꞌo ja ngwa ꞌin neꞌ ―ndukwin sti yu tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","―Ja ndyaa ñaꞌan tiꞌ wan ꞌñaǎn siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¡Kuxi ꞌa kasiya ꞌwan! ¡Ja suꞌwe kanuǔn seꞌen ndiꞌin wan, chunꞌ ja taloǔn ꞌwan siyaꞌ ti! Kan loꞌo wan ꞌin yu tiꞌí kwa tloǔn ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Kanꞌ yan loꞌo neꞌ ꞌin yu tiꞌí tloo Jesús. Bra nu naꞌan kwiꞌin kuxi kanꞌ ꞌin Jesús, bra ti mxlyuu ꞌin yu tiꞌí kanꞌ; mlyuu yu lo yuu, mlyuu kiꞌin yu, ndukwa ngoꞌ tuꞌwa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Mnichaꞌ Jesús ꞌin sti yu tiꞌí bra kanꞌ: ―¿Ni ñaꞌan bra mdyisnan tiꞌí yu a? ―ndukwin Jesús. ―Ti kuneꞌ yu, ti bra kanꞌ msñi kicha kanꞌ ꞌin yu ―ndukwin sti yu tiꞌí kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tyun ꞌa yaꞌ wa mxlyuu ran ꞌin yu lo kiiꞌ, mstyuu ran ꞌin yu lo tyiꞌa, chaꞌ ngwa tiꞌ kwiꞌin kujwi ꞌin yu. Chka tꞌnan chinꞌ tiiꞌ ꞌwa, kuꞌnii ska chaꞌ suꞌwe ꞌwa, kuꞌnii joꞌó ꞌin yu si nchka ꞌiin ―ndukwin sti yu tiꞌí kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","―¿Ni chaꞌ lka ndukwiin ꞌñaǎn ngwañaꞌan “si nchka ꞌñaǎn?” ―ndukwin Jesús ꞌin yu―. Nchga lo tñan nchka ꞌin ska nten nu ndyaa ñaꞌan tiꞌ ꞌin Ndiose ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bra ti ykwiꞌ sti yu tiꞌí kanꞌ bra kanꞌ: ―¡Wa ndyaa ñaꞌan tiǎnꞌ ꞌiin! ―ndukwin―, tayaaꞌ ꞌñaǎn chaꞌ xñiǐn suꞌwe la chaꞌ ꞌiin bra nu ja ya tsaa ñaꞌan suꞌweěn tiǎnꞌ ꞌiin, nxkeꞌ tiǎnꞌ ―ndukwin yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Loꞌo naꞌan Jesús chaꞌ kaꞌan la nten wa tyoꞌ tiꞌin ti seꞌen ndiꞌin yu bra kanꞌ, kanꞌ chaꞌ ngulo yu tñan ꞌin kwiꞌin kuxi kanꞌ: ―Kwiꞌin kuxi ni, ti kwiiꞌ lkaa nu yꞌni kuꞌun ꞌin yu tiꞌí re ―ndukwin Jesús―. Kuloǔn tñan ꞌiin chaꞌ tyoꞌoo ꞌin yu kuneꞌ re, chaꞌ ja xlyuu ꞌa ꞌin yu siyaꞌ ti ―ndukwin Jesús ꞌin kwiꞌin kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Loꞌo yꞌni kwiꞌin chaꞌ kwen msiꞌya yu tiꞌí, xiyaꞌ lye ꞌa mxlyuu ran ꞌin yu bra nu mdoꞌo ran ꞌin yu bra kanꞌ. Mlyuu yu tiꞌí kanꞌ, msu yu lyuu, mdsoꞌo ꞌin yu. Wa kaꞌan ꞌa nten naꞌan chaꞌ kanꞌ. ―Wa ngujwi yu ni ―ndukwin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kanꞌ msñi Jesús yaꞌ yu tiꞌí kanꞌ, mxituun Jesús ꞌin yu. Mdyituun yu tiꞌí kanꞌ, chaꞌ nchkaa yu bra ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Chunꞌ ndiꞌin la, bra nu ndyaa Jesús niꞌ ñaꞌan, ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu mnan ti seꞌen ndiꞌin neꞌ ykwiꞌ ti neꞌ bra kanꞌ: ―¿Ni chaꞌ ja ngwa ꞌwa kulo ba ꞌin kwiꞌin nu msñi ꞌin yu tiꞌí kanꞌ? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","―Ska lo ti kwiꞌin kuxi lka kanꞌ ―ndukwin Jesús―, ja nchka ꞌwan kulo wan ꞌin ska kwiꞌin ngwañaꞌan. Ska ti si jñan wan chabiyaꞌ ꞌin Ndiose chaꞌ ka, bra nu ngiꞌni wan kuꞌnan. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Chunꞌ ndiꞌin la mdoꞌo Jesús kichen kanꞌ, ndyaa yu loꞌo taꞌa ndyaꞌan yu, mdijin neꞌ tyun kichen lo yuu ꞌin Galilea kanꞌ. Ja ngwa tiꞌ Jesús chaꞌ kanen chaꞌ ꞌin yu laja kichen kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","chaꞌ ngwa tiꞌ yu kwaꞌu la yu ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu laja nu ndaꞌan ti neꞌ tuwiin. ―Nsuꞌwi ska nten nu kuꞌni trisiyun ꞌñaǎn ꞌin neꞌ wsiya chaꞌ kuꞌni neꞌ chaꞌ kuxi loꞌoǔn, ni siya wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ―ndukwin Jesús ꞌin neꞌ―. Kujwi neꞌ kanꞌ ꞌñaǎn bra kanꞌ. Xa wa mdaꞌa snan tsan chaꞌ nu wa yjwi neꞌ ꞌñaǎn, bra kanꞌ tyuꞌuǔn xiyaꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ja ngwiꞌya neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kwenta sa ñaꞌan lka chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ; loꞌo ja mnichaꞌ neꞌ ꞌin yu sa ñaꞌan ndyoꞌo chaꞌ kanꞌ, chaꞌ ntsen neꞌ chkwiꞌ neꞌ loꞌo yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Chunꞌ ndiꞌin la ngula neꞌ nde kichen Capernaum, yten neꞌ niꞌ ñaꞌan. Loꞌo mnichaꞌ Jesús ꞌin neꞌ bra kanꞌ: ―¿Ni sa ñaꞌan ngwa chaꞌ nu ykwiꞌ wan loꞌo taꞌa wan tuwiin tsan? ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ja xlyaa neꞌ katsaꞌ neꞌ ꞌin yu ni ñaꞌan ngwa chaꞌ nu wa ykwiꞌ neꞌ loꞌo taꞌa neꞌ tuwiin, chaꞌ mjyuꞌu tiꞌ neꞌ, chunꞌ wa mxkwen neꞌ chaꞌ ꞌin taꞌa neꞌ ti ka nu lka ndloo la chaꞌ ꞌin ska taꞌa ndaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kanꞌ mdyitukwa Jesús, xiyaꞌ ykwiꞌ yu loꞌo tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Nten nu nchka tiꞌ chaꞌ ka ndloo la ꞌin taꞌa neꞌ, ndiꞌin chaꞌ kuꞌni neꞌ kanꞌ nchga tñan xuwe ti chaꞌ tayaꞌ neꞌ ꞌin taꞌa neꞌ, sa ñaꞌan ngiꞌni ska msu tñan ꞌin xꞌnan yu ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Loꞌo msiꞌya Jesús ꞌin ska nu xuwe chaꞌ xituun yu ꞌin nu xuwe kanꞌ tloo neꞌ bra kanꞌ. Laja nu ndukwa skun Jesús ꞌin nu xuwe kanꞌ, ykwiꞌ yu loꞌo neꞌ xiyaꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Bra nu tayaꞌ wan ꞌin ska nten sa ñaꞌan lka nu xuwe re chaꞌ ꞌñaǎn, ti kwiꞌ ti chaꞌ nan ndayaꞌ wan ꞌñaǎn, ngwañaꞌan ndyoꞌo chaꞌ ―ndukwin Jesús―. Loꞌo bra nu kuꞌni wan tñan ꞌñaǎn, kwiꞌ ngwañaꞌan ngiꞌni wan tñan ꞌin Ndiose nu wa msuꞌwa ꞌñaǎn chaꞌ ndijyaǎn lo chalyuu ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","―Mstru ―ndukwin Xuwa ꞌin Jesús―, wa naꞌan ba ꞌin xka nten nu ndlo ꞌin kwiꞌin kuxi nu msñi ꞌin nten. Ngiꞌni yu tñan kanꞌ chabiyaꞌ ꞌiin, ndukwin yu ꞌwa, ni siya ja ngiꞌni xaꞌan yu loꞌo ba. Kanꞌ chaꞌ ngwa tiꞌ ba chkwiꞌ ba loꞌo yu, chaꞌ ja kulo ꞌa yu ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin nten ―ndukwin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","―Ja chkwiꞌ wan loꞌo yu ngwañaꞌan ―ndukwin Jesús ꞌin Xuwa―. Nten nu wa yꞌni ska chaꞌ tnun chabiyaꞌ ꞌñaǎn, ja ka chkwiꞌ nten kanꞌ chaꞌ kuxi ꞌñaǎn nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Suꞌwa nka tiye nten loꞌoan si siꞌi nan nsuun neꞌ loꞌoan. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni: Si ta ska nten ni siya ska sa ti tyiꞌa koꞌo wan chaꞌ nten ꞌin Krixtu lka wan, nde loo la kaja chaꞌ suꞌwe ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Ja suꞌwe chaꞌ kwaꞌu ska nten tuwiin kuxi ꞌin nten nu ndyaa ñaꞌan tiꞌ ꞌñaǎn sa ñaꞌan nu ndyaa ñaꞌan tiꞌ ska nu xuwe ꞌin sti ―ndukwin Jesús―. Suꞌwe la si chkanꞌ ska kee kichi tnun ynin yu kuxi kanꞌ, loꞌo xkwan nten ꞌin yu lo tyiꞌa tujoꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ndiꞌin chaꞌ kulaa yaꞌ wan siyaꞌ ti ska chaꞌ kuxi nu ndiya ꞌa tiꞌ wan, ni siya ndloo ꞌa chaꞌ kanꞌ ꞌwan, nxkeꞌ tiꞌ wan, ñaꞌan tiꞌ ska laꞌa tsuꞌ yaꞌ wan. Suꞌwe la tyisnan chalyuu nu ja tsaa tii ꞌa ꞌwan, ni siya ja loꞌo chaꞌ kuxi kanꞌ nu ndloo ꞌa ꞌwan, chaꞌ ja kala wan seꞌen kuxi ꞌa nde lo jwlyaa bra kanꞌ. Ja tyii chaꞌ chkin kiiꞌ la kanꞌ, sa kuꞌ ti chkin. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ja tyii chaꞌ ku kunuꞌ kunaꞌ nten la kanꞌ, ja tyii chaꞌ chkin kiiꞌ kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ti kwiꞌ ti chaꞌ, ndiya ꞌa tiꞌ wan ska chaꞌ kuxi nu ngiꞌni wan, nu ndloo ꞌa ꞌwan, nxkeꞌ tiꞌ wan, ñaꞌan tiꞌ ska laꞌa tsuꞌ kiyaꞌ wan; kanꞌ chaꞌ ndiꞌin chaꞌ kulaa yaꞌ wan siyaꞌ ti ꞌin ran. Suꞌwe la tyisnan chalyuu nu ja tsaa tii ꞌa ꞌwan siyaꞌ ti, ni siya ja loꞌo chaꞌ kuxi kanꞌ, chaꞌ ja kala wan seꞌen kuxi ꞌa nde lo jwlyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ja tyii chaꞌ ku kunuꞌ kunaꞌ nten la kanꞌ, ja tyii chaꞌ chkin kiiꞌ kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ti kwiꞌ ti chaꞌ, ndiya ꞌa tiꞌ wan ska chaꞌ kuxi nu ñaꞌan wan, kanꞌ chaꞌ ndiꞌin chaꞌ kulaa yaꞌ wan ꞌin chaꞌ kuxi kanꞌ siyaꞌ ti, sa ñaꞌan si nan kulo wan ꞌin kiloo ykwiꞌ wan. Suꞌwe la tyisnan Ndiose kulo Ni tñan niꞌ kasiya ꞌwan, ni siya ja loꞌo chaꞌ kuxi kanꞌ nu ndloo ꞌa ꞌwan, chaꞌ ja kala wan seꞌen kuxi ꞌa nde lo jwlyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ja tyii chaꞌ ku kunuꞌ kunaꞌ nten la kanꞌ, ja tyii chaꞌ chkin kiiꞌ kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Xñi Ndiose nchga lomstan nu tyukwi ti tiye nten xtya neꞌ chaꞌ chkin chaꞌ ꞌin Ndiose. Loꞌo chinꞌ tejeꞌ xtya neꞌ lomstan kanꞌ. Kwiꞌ ngwañaꞌan, xñi Ndiose chaꞌ ꞌin nchga nten nu talo bra nu tyukwa neꞌ nu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Suꞌwe ꞌa tejeꞌ, nnanjoꞌo ꞌa ran ꞌñaan; ska ti si tyii chaꞌ tiyenꞌ ꞌin ran, bra kanꞌ ja kunanjoꞌo ꞌa ꞌñaan, chaꞌ ja ka tiyenꞌ ꞌa ran xiyaꞌ. Loꞌo nchga wan ni, ñaꞌan tiꞌ tejeꞌ lka wan xa nu ndiꞌin wan lo chalyuu; sa ñaꞌan suꞌwe ꞌa tñan ngiꞌni tejeꞌ lo ska nan kuan, ngwañaꞌan suꞌwe ꞌa tñan kuꞌni wan laja nten chalyuu bra nu suꞌwe ti tyiꞌin wan loꞌo taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Loꞌo mdoꞌo Jesús kichen Capernaum bra kanꞌ, ndyaa yu tijyuꞌ nde lo yuu ꞌin Judea. Mdijin yu ndyaa yu xka laꞌa tsuꞌ chku Jordán bra kanꞌ. La kanꞌ mdyoꞌ tiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin yu. Ngwaꞌu Jesús ꞌin neꞌ bra kanꞌ, sa ñaꞌan nu nduꞌu yu ꞌin nten nchga kichen seꞌen ndaꞌan yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Loꞌo mdiyan chinꞌ neꞌ fariseo seꞌen ndiꞌin yu, chaꞌ ngwa tiꞌ neꞌ kanꞌ chaꞌ ka kuxi chaꞌ ꞌin Jesús. Kanꞌ mnichaꞌ neꞌ ꞌin yu: ―¿Ta nda chaꞌ kula nu nsuꞌwi ꞌñaan chabiyaꞌ ꞌñaan chaꞌ kulaa tiꞌin ska nten ꞌin kwilyoꞌo yu a? ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―¿Ni sa ñaꞌan tñan ngulo ayman Moisés ꞌwan nu ngwa sꞌni? ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","―Nda ayman Moisés chabiyaꞌ ꞌin yu kiꞌyu taꞌaan chaꞌ kulo kityi chaꞌ kulaa tiꞌin yu ꞌin kwilyoꞌo yu siyaꞌ ti. Xa wa mdoꞌo kityi ꞌin ska yu kiꞌyu, wa mdyii chaꞌ kwilyoꞌo yu siyaꞌ ti bra kanꞌ; ja lka nu kunaꞌan kanꞌ kwilyoꞌo yu bra kanꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Siꞌya wan ngwaꞌan ayman Moisés chaꞌ kanꞌ, chaꞌ ja nnan wan siyaꞌ ti chaꞌ ꞌin Ndiose ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bra nu mdyisnan ndukwa kiyaꞌ chalyuu, xa nu ngwiñan Ndiose nchga lo nan, ja ngwa tiꞌ Ndiose chaꞌ ka ngwañaꞌan. “Ngwiñan Ndiose nten; ngwiñan Ni ska yu kiꞌyu loꞌo ngwiñan Ni ska nu kunaꞌan” ndukwin kityi kula ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Kanꞌ chaꞌ bra nu kaja kwilyoꞌo ska yu kiꞌyu, tyoꞌo tsuꞌ yu naꞌan tyi sti yu loꞌo jyaꞌan yu, chaꞌ tyiꞌin yu loꞌo kwilyoꞌo yu bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","chaꞌ ka neꞌ sa ñaꞌan lka ska ti nten bra kanꞌ.” Ja lka neꞌ tukwa nten bra kanꞌ, chaꞌ wa lka neꞌ ñaꞌan tiꞌ si ska ti nten lka neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kanꞌ chaꞌ ja suꞌwe kulaa tiꞌin yu ꞌin kwilyoꞌo yu, chaꞌ wa mda Ndiose chaꞌ kwilyoꞌo ꞌin neꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Bra wa mdiyan Jesús niꞌ ñaꞌan xiyaꞌ, bra kanꞌ mnichaꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu ni ñaꞌan lka chaꞌ nu tka ytsaꞌ ti yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Xa nu kulo ska nten kityi chaꞌ kulaa tiꞌin yu ꞌin kwilyoꞌo yu, chaꞌ kaja kwilyoꞌo yu loꞌo xka nu kunaꞌan bra kanꞌ, nka tiye yu, chaꞌ kuxi ngiꞌni yu loꞌo nu ngwa kwilyoꞌo yu bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ti kwiꞌ ti chaꞌ lka loꞌo ska nu kunaꞌan nu kulo kityi chaꞌ kulaa tiꞌin ꞌin kwilyoꞌo, chaꞌ kaja kwilyoꞌo loꞌo xka yu kiꞌyu bra kanꞌ, nka tiye, ti kwiꞌ ti chaꞌ kuxi ngiꞌni kanꞌ loꞌo nu ngwa kwilyoꞌo kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Loꞌo ngwa ska tsan mdiyan loꞌo neꞌ ꞌin tyun nu xuwe nde seꞌen ndiꞌin Jesús. Ngwa tiꞌ neꞌ chaꞌ xtya yaꞌ Jesús ke nu xuwe kanꞌ. Loꞌo yꞌni tlá ꞌa yu kuneꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús ꞌin neꞌ, chaꞌ ja kan loꞌo neꞌ ꞌin nu xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Bra nu naꞌan Jesús sa ñaꞌan nu ngiꞌni neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ja mdiya tiꞌ yu chaꞌ ngiꞌni neꞌ ngwañaꞌan: ―Ta wan chabiyaꞌ ꞌin nu xuwe chaꞌ kan neꞌ seꞌen ndiꞌiǐn ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Ja chkwiꞌ wan loꞌo nu xuwe kanꞌ chaꞌ ja kan neꞌ seꞌen ndiꞌiǐn. Sa ñaꞌan lka chaꞌ ndyaa ñaꞌan tiꞌ nu xuwe ꞌin sti neꞌ, kwiꞌ ngwañaꞌan ndiꞌin chaꞌ tsaa ñaꞌan tiꞌ nten ꞌin Ndiose, chaꞌ ka Ni ndloo niꞌ kasiya ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Chañi chaꞌ nu nchkwiǐnꞌ ―ndukwin―, chaꞌ ja ka sten nten chaꞌ ꞌin Ndiose chaꞌ ka Ni ndloo niꞌ kasiya ꞌin neꞌ si nu ja ya tsaa ñaꞌan tiꞌ neꞌ tyukwi ti tiye neꞌ ꞌin Ni, sa ñaꞌan nu ndyaa ñaꞌan tiꞌ nu xuwe tyukwi ti tiye neꞌ ꞌin sti neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Kanꞌ msñi Jesús ꞌin nu xuwe kanꞌ, nkwan yu ꞌin neꞌ bra nu mstya yaꞌ yu ke neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ti ndyaa la Jesús tuwiin, kanꞌ naꞌan yu nxnan ska yu kiꞌyu kuneꞌ ndijyan ñaꞌan ꞌin Jesús. Mduun xtyinꞌ yu kuneꞌ tloo Jesús bra kanꞌ. ―Mstru, suꞌwe ꞌa ngiꞌni wan nchga tsan ―ndukwin ꞌin Jesús―. Kuꞌni wan chaꞌ suꞌwe katsaꞌ wan ꞌñaǎn, ¿ni sa ñaꞌan kuꞌniǐn chaꞌ kaja chalyuu ꞌñaǎn nu ja tsaa tii ꞌa? ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","―¿Ni chaꞌ lka nxkeꞌ tiiꞌ chaꞌ nten suꞌwe lkaǎn? ―ndukwin Jesús ꞌin yu kuneꞌ bra kanꞌ―. Ska ti Ndiose lka nu chañi chaꞌ suꞌwe lka Ni ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","¿Ta jlyo ka tiiꞌ nchga tñan nu ngulo Ndiose ꞌin nten nu ngwa sꞌni?: “Ja xuꞌwi chaꞌ ꞌwan loꞌo xka la nten nu ja lka kwilyoꞌo wan; ja kujwi wan ꞌin taꞌa nten wan; ja kuꞌni wan kunan chaꞌ suꞌwe nu nsuꞌwi ꞌin taꞌa nten wan; ja chkwiꞌ wan kwentu ꞌin taꞌa nten wan; ja kwiñi lyoꞌo wan ꞌin taꞌa nten wan; kwiꞌ ngwañaꞌan, kuꞌni tnun wan ꞌin sti wan loꞌo jyaꞌan wan, kunan wan chaꞌ nu nchkwiꞌ neꞌ kanꞌ”. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","―Mstru ―ndukwin yu kuneꞌ kanꞌ bra kanꞌ―, ti kuneěnꞌ ndukwaǎn nchga tñan kanꞌ; ja mdyii chaꞌ ndukwaǎn chaꞌ kanꞌ nchga tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Suꞌwe nka tiye Jesús chaꞌ ykwiꞌ yu kiꞌyu kanꞌ ngwañaꞌan. Xiyaꞌ ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Ska ti tñan ti ji kuꞌnii ―ndukwin Jesús ꞌin yu―. Yaa lyaa kujwiiꞌ nchga chaꞌ suꞌwe nu nsuꞌwi ꞌiin, chaꞌ tyoꞌo tñi taa ꞌin neꞌ tiꞌi bra kanꞌ; kaꞌan la chaꞌ suꞌwe kaja ꞌiin chunꞌ ndiꞌin la nde seꞌen ndiꞌin Ndiose. Nde loo la tyaan xiyaꞌ seꞌen ndiꞌiǐn chaꞌ tyaꞌaan loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bra wa ynan yu kanꞌ nchga chaꞌ nu ykwiꞌ Jesús loꞌo, xka ñaꞌan ndaꞌan chaꞌ tiye yu bra kanꞌ; xiꞌin ꞌa tiꞌ yu, chaꞌ kuliyaꞌ ꞌa yu. Mdoꞌo yu ndyaa yu ngwañaꞌan ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mxitukwi Jesús naꞌan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ―¡Tukwi ꞌa ka chaꞌ kala ska nu kuliyaꞌ nde seꞌen lka Ndiose ndloo! ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nduwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ, chaꞌ ngwañaꞌan ykwiꞌ yu chaꞌ ꞌin neꞌ kuliyaꞌ. Kanꞌ chaꞌ xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ: ―ꞌWan, yu kuneꞌ ―ndukwin Jesús―, tukwi ꞌa ka chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin nten, xa nu lye ꞌa ndiya tiꞌ neꞌ nchga chaꞌ suꞌwe nu nsuꞌwi ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sa la tñan tyijin ska ꞌni kiyaꞌ kuxa, ni siya ska ꞌni tnun ñaꞌan tiꞌ ska camello. Sa la chaꞌ kanꞌ, loꞌo tukwi la sten ska nu kuliyaꞌ chaꞌ ꞌin Ndiose chaꞌ ka Ni ndloo niꞌ kasiya ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Bra wa ynan neꞌ chaꞌ kanꞌ, nduwe ꞌa tiꞌ neꞌ bra kanꞌ. ―¿Ti ka nu ka lyaa ꞌin nu kuxi nu nsuꞌwi chalyuu sikwa a? ¿Ti ka nu ka kala nde seꞌen ndiꞌin Ndiose? ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Naꞌan ꞌa Jesús ꞌin neꞌ bra kanꞌ, kwiꞌ ykwiꞌ yu loꞌo neꞌ xiyaꞌ: ―Kanꞌ lka ska chaꞌ nu ja nchka kuꞌni nten chalyuu. Ndiose ni, nchga tñan nchka ꞌin Ni, kanꞌ chaꞌ nchka kuꞌni Ni chaꞌ kala nten seꞌen ndiꞌin Ni ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ykwiꞌ Tyu loꞌo Jesús bra kanꞌ: ―Loꞌo bare ni, wa mxnun ba nchga nan nu nsuꞌwi ꞌwa chaꞌ tyaꞌan ba loꞌoo, sa ñaꞌan nu ndukwiin chaꞌ kuꞌni ba ―ndukwin Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús―, chaꞌ nchga nten nu ndiꞌin chaꞌ tsaa tijyuꞌ chaꞌ kuꞌni tñan ꞌñaǎn, nu ngwañaꞌan wa mxnun nchga nan nu nsuꞌwi ꞌin neꞌ chaꞌ ngiꞌni neꞌ tñan ꞌñaǎn, ja kulaa yaǎnꞌ ꞌin neꞌ kanꞌ ngwañaꞌan ti. Ni siya naꞌan tyi neꞌ, ni siya taꞌa ngula neꞌ, ni siya sti neꞌ, ni siya jyaꞌan neꞌ, ni siya kwilyoꞌo neꞌ, ni siya sñiꞌ neꞌ, ni siya yuu nu nsuꞌwi ꞌin neꞌ, kanun nchga chaꞌ kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","loꞌo ti kwiꞌ lo chalyuu re ni, xiyaꞌ kaja kaꞌan la chaꞌ nu mnaꞌ ꞌin neꞌ kanꞌ. Kaja seꞌen ka naꞌan tyi neꞌ, kaja nu ka taꞌa ngula neꞌ, kaja nu ka jyaꞌan neꞌ, kaja nu ka sñiꞌ neꞌ, kaja yuu seꞌen kuꞌni neꞌ tñan; ta Ndiose ska siyentu sa kwa chaꞌ kanꞌ nu kaja ꞌin neꞌ. Kwiꞌ ngwañaꞌan, tyijin neꞌ kanꞌ nu tiꞌí lo chalyuu re. Loꞌo nde loo la kaja chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nde loo la ka nten nu tyoꞌo tukwa bra wa tyii ti chaꞌ; nde chunꞌ la kanun nten nu mdoꞌo tukwa ti kulo la ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Xiyaꞌ mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ, ndyaa Jesús loꞌo neꞌ taꞌa ndaꞌan yu tuwiin tsaa neꞌ nde Jerusalén. Nde loo la mdaꞌan ykwiꞌ Jesús. Kaꞌan ꞌa chaꞌ mdaꞌan tiye neꞌ taꞌa ndaꞌan yu, kwiꞌ ngwañaꞌan xka ta nten nu mdaꞌan loꞌo neꞌ, ytsen ꞌa neꞌ. Kanꞌ ndyaa loꞌo Jesús ꞌin tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdoꞌo tsuꞌ neꞌ ska laꞌa tuwiin ti chaꞌ katsaꞌ Jesús ꞌin neꞌ kanꞌ sa ñaꞌan ka chaꞌ nu ka ꞌin yu nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Kunan suꞌwe wan ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―. Wa msñian tuwiin nde yꞌni, chaꞌ tsaan Jerusalén. Nde kwa xñi nten ꞌñaǎn, ni siya wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Tsaa loꞌo neꞌ ꞌñaǎn tloo sti joꞌo nu lka ndloo la, tloo mstru nu nduꞌu chaꞌ joꞌo. Kuꞌni biyaꞌ neꞌ kanꞌ ꞌñaǎn bra kanꞌ. Chkwiꞌ neꞌ chaꞌ ndiꞌin kiꞌya tnun ꞌñaǎn, loꞌo ndiꞌin chaꞌ kajaǎn siꞌya kiꞌya kanꞌ, chkwiꞌ neꞌ kanꞌ. Kanꞌ tsaa loꞌo neꞌ kanꞌ ꞌñaǎn tloo neꞌ xka laꞌa tsuꞌ nu lka ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Bra kanꞌ xtyi lyoꞌo neꞌ kanꞌ ꞌñaǎn, suꞌwa tyiꞌa nsuꞌwi tuꞌwa neꞌ loǔn, jwiꞌin neꞌ kanꞌ ꞌñaǎn loꞌo ti su. Bra kanꞌ jwiꞌin kaꞌan neꞌ kanꞌ ꞌñaǎn lo wsi chaꞌ kajaǎn. Loꞌo bra wa mdaꞌa snan tsan, bra kanꞌ tyuꞌuǔn xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Loꞌo mdiyan Santiago loꞌo Xuwa taꞌa yu seꞌen ndiꞌin Jesús bra kanꞌ. Sñiꞌ Zebedeo lka neꞌ kanꞌ. ―Mstru ―ndukwin neꞌ―, kuꞌnii chaꞌ tlyu tiiꞌ ꞌwa, ndiya ska xuꞌwe nu nchka tiꞌ ba jñan ba ꞌiin ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","―¿Nan lka nchka tiꞌ wan chaꞌ kuꞌniǐn chaꞌ ꞌwan a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","―Kuꞌnii chaꞌ suꞌwe taa chabiyaꞌ ꞌwa chaꞌ suꞌwa ti tyukwa ba loꞌoo nde seꞌen tlyu, seꞌen nu xaa ꞌa, seꞌen nu ka ndloo la nuꞌwin nde loo la ―ndukwin neꞌ kanꞌ―. Ska ba tyukwa ba laꞌa seꞌen kwin ꞌiin, xka ba tyukwa ba laꞌa seꞌen kaa ꞌiin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","―Ja jlyo tiꞌ wan sa ñaꞌan nan lka nu njñan wan ꞌñaǎn ni ―ndukwin Jesús ꞌin neꞌ―. ¿Ta nchka ꞌwan koꞌo wan nan tlyaaꞌ nu ndiꞌin chaꞌ koꞌoǔn a? ¿Ta talo wan bra nu ta neꞌ nu tiꞌí ꞌwan ñaꞌan tiꞌ nu tiꞌí nu ndiꞌin chaꞌ tyijiǐn xa nu kujwi neꞌ ꞌñaǎn a? ");
INSERT INTO ctpNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Nchka ꞌwa ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ―Chañi chaꞌ loꞌo wan ndiꞌin chaꞌ koꞌo wan nan tlyaaꞌ nu ndiꞌin chaꞌ koꞌoǔn ―ndukwin Jesús―. Chañi chaꞌ tyijin wan nu tiꞌí sa ñaꞌan nu ndiꞌin chaꞌ tyijiǐn nu tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Loꞌo ni, chaꞌ nu tyukwa wan laꞌa seꞌen kwin ꞌñaǎn, chaꞌ tyukwa wan laꞌa seꞌen kaa ꞌñaǎn, ja nsuꞌwi chabiyaꞌ ꞌñaǎn chaꞌ taǎn seꞌen tyukwa nten nde kwa. Wa lka ngulo suwi Ndiose Stiǐn ꞌin nten nu tyukwa nde siǐnꞌ bra kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Loꞌo xa tyii neꞌ nu mdaꞌan loꞌo Jesús, bra wa ynan neꞌ sa ñaꞌan chaꞌ nu mjñan Santiago loꞌo Xuwa ꞌin Jesús, chen ꞌa ngwa tiye neꞌ ñaꞌan neꞌ ꞌin taꞌa tyukwaa yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Kanꞌ chaꞌ ykwiꞌ Jesús loꞌo taꞌa neꞌ: ―Jlyo tiꞌ wan chaꞌ nten nu lka ndloo la ꞌin neꞌ xka laꞌa tsuꞌ, tlá ꞌa neꞌ kanꞌ ―ndukwin Jesús―. Lye ꞌa ndlo neꞌ kanꞌ tñan ꞌin neꞌ nde kichen tyi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Loꞌo ꞌwan ni, ja suꞌwe kuꞌni wan ngwañaꞌan. Nchga lo tñan nu ka tayaꞌ wan ꞌin taꞌa nten wan, kanꞌ tñan ndiꞌin chaꞌ kuꞌni wan, xa nu nchka tiꞌ wan chaꞌ ka wan ndloo ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kwiꞌ ngwañaꞌan, si xkeꞌ tiꞌ wan chaꞌ ndloo la chaꞌ ꞌwan ke neꞌ taꞌa wan, ndiꞌin chaꞌ kuꞌni wan loꞌo taꞌa nten wan ñaꞌan tiꞌ si lka wan ska msu ꞌin neꞌ ni siya ja loꞌo liyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ja ndijyaǎn lo chalyuu re chaꞌ kaja msu ꞌñaǎn; naꞌ kaǎn msu ꞌin nten, kanꞌ chaꞌ ndijyaǎn. Nan wa ndijyaǎn chaꞌ kajaǎn siꞌya kiꞌya nu ndiꞌin ꞌin nten, chaꞌ kulaǎn ꞌin kaꞌan ꞌa nten bra kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Chunꞌ ndiꞌin la mdiyan Jesús nde kichen Jericó loꞌo taꞌa ndaꞌan yu. Mdijin neꞌ jluꞌwe kichen kanꞌ. Bra wa tyaa ti Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ, loꞌo kaꞌan ꞌa nten ndyaa ñaꞌan ꞌin neꞌ. Ngwañaꞌan ngwa bra kanꞌ, tuꞌwa tuwiin mdukwa ska yu kwityiinꞌ nu naan Bartimeo, njñan yu lomstan ꞌin nten nu ndijin nde kwa. Sñiꞌ Timeo lka yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Bra nu mgii tiꞌ yu chaꞌ ndijyan Jesús Nazaret, kwen msiꞌya yu ꞌin Jesús bra kanꞌ: ―¡Yu kula Jesús! ¡Jlyo tiǎnꞌ chaꞌ nten ꞌin ayman David lka wan! ―ndukwin―. Kuꞌni wan chaꞌ suꞌwe chaꞌ chka tꞌnan tiꞌ wan ꞌñaǎn ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Tyun nten ngwa tiꞌ chkwiꞌ loꞌo yu tiꞌí kanꞌ, chaꞌ mnan ti tyukwa yu, ngwa tiꞌ neꞌ; loꞌo ja mslyaa yu tiꞌí kanꞌ, kwen la msiꞌya bra kanꞌ: ―¡Yu kula, nten ꞌin ayman David lka wan! ―ndukwin yu tiꞌí―, kuꞌni wan chaꞌ suꞌwe chaꞌ chka tꞌnan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Bra ti ndyaa tuun Jesús seꞌen ti bra kanꞌ. ―Chkwiꞌ wan loꞌo yu chaꞌ kan yu nde re ―ndukwin Jesús. Kanꞌ ndukwin neꞌ ꞌin yu kwityiinꞌ kanꞌ chaꞌ tsaa yu tloo Jesús. ―Kuꞌnii tnun tiyee ni ―ndukwin neꞌ ꞌin yu tiꞌí kanꞌ―. Tyituun, tyaa lyaa seꞌen ndiꞌin yu kula Jesús kwa ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bra ti ngulo yu tiꞌí kanꞌ teꞌ kichanꞌ ꞌin yu, mxnun seꞌen yu ꞌin ran. Mdyituun yu msnan yu ndyaa yu seꞌen ndiꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Loꞌo ykwiꞌ Jesús loꞌo yu: ―¿Ni sa ñaꞌan nan nchka tiiꞌ chaꞌ kuꞌniǐn loꞌoo? ―ndukwin Jesús ꞌin yu. ―Mstru ―ndukwin yu kwityiinꞌ―, kuꞌni wan joꞌó ꞌñaǎn, chaꞌ xiyaꞌ kalaa kiloǔn chaꞌ ñaꞌaǎn xiyaꞌ ―ndukwin yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","―Suꞌwe ―ndukwin Jesús ꞌin yu―. Tyaa lyaa naꞌan tyii ni. Ndyaa ñaꞌan tiiꞌ ꞌñaǎn, kanꞌ chaꞌ wa nchkaa kiloo. Bra ti ngwa suꞌwe kiloo yu kwityiinꞌ kanꞌ, naꞌan yu xiyaꞌ. Bra kanꞌ mdoꞌo ñaꞌan yu ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Chunꞌ ndiꞌin la mdiyan neꞌ kwiꞌ seꞌen ti tuꞌwa kichen Jerusalén, seꞌen ndiꞌin tukwa kichen xuwe ti siꞌ kiꞌya Olivos. Betfagé loꞌo Betania ngwa naan kichen xuwe kanꞌ. Bra kanꞌ ngulo Jesús tñan ꞌin tukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Yaa wan kichen xuwe ti nde kwa ―ndukwin ꞌin neꞌ―. Bra nu tiyan wan tuꞌwa kichen kanꞌ, bra ti ñaꞌan wan nduun ska buru nchkanꞌ nu ja ya tyukwa nten chunꞌ. Xtiꞌ wan ꞌin iꞌ, chaꞌ kan loꞌo wan ꞌin iꞌ nde re. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si ndiya nten nu chkwiꞌ loꞌo wan, ni chaꞌ lka ngiꞌni wan ngwañaꞌan, bra kanꞌ nde lka chaꞌ nu chkwiꞌ wan loꞌo neꞌ kanꞌ: “Ndiya tñan nu kuꞌni buru re chaꞌ ꞌin Xꞌnaan. Bra ti tyaan loꞌo ba ꞌin iꞌ xiyaꞌ” nchkwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mdoꞌo neꞌ ndyaa neꞌ kichen xuwe ti kanꞌ; ndyija buru ꞌin neꞌ seꞌen nduun tuꞌwa tuwiin, nchkanꞌ iꞌ tuꞌ naꞌan tyi ska nten. Bra nu mxtiꞌ neꞌ ꞌin iꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","bra kanꞌ ykwiꞌ ska nten nu nduun kwiꞌ seꞌen ti loꞌo neꞌ kanꞌ: ―¿Ni chaꞌ mxtiꞌ wan ꞌin buru kwa? ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ytsaꞌ neꞌ ꞌin yu kanꞌ nchga tñan nu ngulo Jesús ꞌin neꞌ chaꞌ chkwiꞌ neꞌ loꞌo. Bra kanꞌ mda yu chabiyaꞌ chaꞌ tsaa neꞌ loꞌo buru kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ndyaan loꞌo neꞌ ꞌin buru seꞌen ndiꞌin Jesús bra kanꞌ. Mstya neꞌ steꞌ neꞌ chunꞌ buru seꞌen tyukwa Jesús, kwiꞌ mdukwa Jesús chunꞌ iꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kwiꞌ ngwañaꞌan mstya nten steꞌ neꞌ tuwiin kanꞌ, loꞌo ndyaa nten msiꞌyu neꞌ stanꞌ yka chaꞌ xtya neꞌ lkaꞌ lyuu, chaꞌ ka suꞌwe ñaꞌan tuwiin seꞌen tyijin buru loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kanꞌ msiꞌya nten nu ndyaa nde loo Jesús, msiꞌya nten nu ndijyan nde chunꞌ; lye ꞌa yꞌni tnun neꞌ ꞌin Jesús: ―¡Kuꞌni tnuan ꞌin Ndiose! ―ndukwin neꞌ―. ¡Suꞌwe ti kuꞌni Ndiose loꞌo nu kiꞌyu re nu ndijyan chabiyaꞌ ꞌin nu nka Xꞌnaan! ¡Ni ti kuꞌni tnuan ꞌin Xꞌnaan! ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Suꞌwe ꞌa si kuꞌni tnuan ꞌin yu re, chaꞌ ndla ti ka Ndiose ndloo nde re. Kanꞌ nu ka ndloo sa ñaꞌan ngwa ayman David ndloo nu ngwa sꞌni ―ndukwin neꞌ―. ¡Ni ti kuꞌni tnun nchga nu ndiꞌin niꞌ kwan ꞌin Xꞌnaan! ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Loꞌo mdiyan neꞌ kanꞌ loꞌo Jesús tuꞌwa kichen Jerusalén, yten neꞌ tuloꞌoo kichen kanꞌ bra kanꞌ. Bra ti ndyaa naꞌan Jesús niꞌ lyaa tnun nde kwa bra kanꞌ. Naꞌan yu nchga lo nan nu ndukwa nde kwa, loꞌo mxitukwi yu ndyaa yu nde kichen Betania xiyaꞌ loꞌo tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ msiin ꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngwiꞌya xaa xka tsan, mdoꞌo neꞌ kichen Betania bra kanꞌ. Ngiteꞌ ꞌa tiꞌ Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Loꞌo naꞌan yu wa tijyuꞌ la chinꞌ nduun ska yka kityi nu nsuꞌwi lkaꞌ loo. Ndyaa naꞌan yu si nsuꞌwi mta loo ran; loꞌo lkaꞌ ti nsuꞌwi, ja nsuꞌwi mta loo ran siyaꞌ ti, chaꞌ ti ji tiya bra tyoꞌo mta loo yka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","―Ja ku ꞌa nten siyaꞌ ti mta nu tyoꞌo loo yka re ―ndukwin Jesús bra kanꞌ. Loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, ynan neꞌ chaꞌ nu ykwiꞌ yu chaꞌ ꞌin yka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Chunꞌ ndiꞌin la chinꞌ, mdiyan neꞌ kichen Jerusalén. Yten Jesús niꞌ lyaa tnun nde kwa bra kanꞌ, loꞌo mdyisnan yu ngulo yu ꞌin nten nu ndujwiꞌ yuꞌwa niꞌ lyaa kwa; loꞌo ꞌin nten nu ndiꞌya yuꞌwa kanꞌ, ngulo yu ꞌin neꞌ kanꞌ siyaꞌ ti. Loꞌo nten nu nxaꞌan tñi ꞌin neꞌ nde kwa, mxlyuu yu msaa ꞌin neꞌ kanꞌ, ngwañaꞌan mxlyuu yu yka ꞌin nten nu ndujwiꞌ kiñi cha kuun. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ja mda ꞌa Jesús chabiyaꞌ tyijin nten loꞌo yuꞌwa ꞌin neꞌ niꞌ lyaa tnun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kwa: ―Ndukwa ska chaꞌ lo kityi ꞌin Ndiose chaꞌ ꞌin laa re: “Ska naꞌan seꞌen chkwiꞌ nchga nten loꞌo Ndiose, ngwañaꞌan nchkwin nten chaꞌ ka naꞌan ꞌñaǎn re, ndukwin Ndiose.” Ngwañaꞌan ndukwa lo kityi ―ndukwin Jesús bra kanꞌ―, loꞌo ꞌwan ni, wa yꞌni wan chaꞌ naꞌan tyi nten nu ngiꞌni kunan lka naꞌan re ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ynan sti joꞌo nu lka ndloo la chaꞌ kanꞌ, loꞌo ynan mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa. Naꞌan neꞌ chaꞌ kaꞌan ꞌa nten nganan chaꞌ nu nduꞌu Jesús ꞌin neꞌ, kanꞌ chaꞌ ntsen neꞌ nu tnun nchka kanꞌ si ka tnun la chaꞌ ꞌin Jesús; ngwa tiꞌ neꞌ tnun kanꞌ, chaꞌ kaja suun ꞌin neꞌ chaꞌ ka kujwi neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bra nu ndyaa kwichaa, bra kanꞌ mdoꞌo Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa yu. Ja nganun ꞌa neꞌ kichen tnun kanꞌ tla. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ngwiꞌya xaa xka tsan, xiyaꞌ mdijin neꞌ kwiꞌ seꞌen nduun yka kityi kanꞌ bra kanꞌ. Wa ngwityi siyaꞌ ti yka kanꞌ, tyukwi ñaꞌan yka loꞌo kiyaꞌ yka ngwityi. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Loꞌo nsuꞌwi tiꞌ Tyu chaꞌ nu ykwiꞌ Jesús ꞌin yka kanꞌ ti kaa bra kanꞌ. ―Mstru, ñaꞌaan chinꞌ nde re ―ndukwin Tyu ꞌin Jesús―. Wa ngwityi ti kwiꞌ yka kityi seꞌen nu mstya nuꞌwin yuweꞌ chunꞌ ran. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","―Ndiꞌin chaꞌ tsaa ñaꞌan tiꞌ wan ꞌin Ndiose ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ si chkwiꞌ wan loꞌo kiꞌya kwa: “Tyoꞌo tsuuꞌ, yaa skwaa lo tyiꞌa tujoꞌo” nchkwin wan ꞌin kiꞌya, kwiꞌ ngwañaꞌan kuꞌni Ndiose loꞌo kiꞌya kanꞌ. Ngwañaꞌan ka, si chañi ꞌwan chaꞌ ndyaa ñaꞌan tiꞌ wan chaꞌ ka ska chaꞌ nu jñan wan ꞌin Ndiose; si ja tsaa ñaꞌan tiꞌ wan chaꞌ nu ykwiꞌ Ndiose, ja ka chaꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Kwiꞌ ngwañaꞌan, nchga lo chaꞌ nu jñan wan ꞌin Ndiose laja nu chkwiꞌ wan loꞌo Ni, chañi chaꞌ ta Ni chaꞌ kanꞌ ꞌwan, si chañi chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nchga yaꞌ nu nduun wan chaꞌ chkwiꞌ wan loꞌo Ndiose, ndiꞌin chaꞌ kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa nten wan, bra nu ndiya ska chaꞌ nu msuꞌwa neꞌ chaꞌ msinꞌ tiꞌ wan. Bra kanꞌ Ndiose Sti wan nu ndukwa nde niꞌ kwan, kwiꞌ nu kuꞌni chaꞌ tlyu tiꞌ ꞌwan ꞌin chaꞌ kuxi nu ndiꞌin ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ja kuꞌni Ndiose Sti wan chaꞌ tlyu tiꞌ ꞌwan ꞌin chaꞌ kuxi nu ndiꞌin ꞌwan, si ja loꞌo wan kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xiyaꞌ ndyaa neꞌ nde Jerusalén bra kanꞌ, yaa Jesús niꞌ lyaa tnun kwa. Loꞌo naꞌan sti joꞌo nu ndloo la ꞌin yu, loꞌo mstru nu nduꞌu chaꞌ joꞌo, loꞌo neꞌ kula nu nduun loo la ꞌin kichen, naꞌan neꞌ ꞌin yu seꞌen ndaꞌan yu niꞌ lyaa kanꞌ. Bra kanꞌ mdyoꞌ tiꞌin neꞌ kanꞌ seꞌen ndiꞌin yu chaꞌ chkwiꞌ neꞌ loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","―¿Ti ka nu lka nu nda chabiyaꞌ ꞌiin chaꞌ kuꞌnii tñan nu ngiꞌnii a? ―ndukwin neꞌ ꞌin Jesús―. ¿Ti ka nu ngulo tñan ꞌiin a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","―Loꞌo naꞌ, kunichaǎnꞌ ska chaꞌ ꞌwan ―ndukwin Jesús bra kanꞌ―. Xkwen ñi wan ꞌñaǎn, loꞌo katsaǎnꞌ ꞌwan ti ka nu nda chabiyaꞌ ꞌñaǎn bra kanꞌ ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ti ka nu ngulo tñan ꞌin ayman Xuwa chaꞌ tukwatya yu ꞌin nten a? ¿Ta Ndiose mda chabiyaꞌ ꞌin Xuwa kanꞌ a? ¿O ta nten chalyuu ti mda chabiyaꞌ ꞌin yu a? Katsaꞌ ñi wan ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kanꞌ mnan ti ykwiꞌ neꞌ nu tnun nchka kanꞌ loꞌo taꞌa neꞌ: ―Si chkwianꞌ chaꞌ Ndiose mda chabiyaꞌ ꞌin ayman Xuwa kanꞌ, bra kanꞌ xkwen yu ꞌwa: “¿Ni chaꞌ ja ynan wan chaꞌ nu ykwiꞌ yu sikwa?” ");
INSERT INTO ctpNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Ta suꞌwe la chkwianꞌ chaꞌ nten chalyuu ti ngulo tñan ꞌin Xuwa a? ―ndukwin neꞌ ꞌin taꞌa neꞌ. Nan wa ntsen neꞌ nu lka ndloo kanꞌ ꞌin nchga nten nu ndiꞌin kichen kanꞌ. Jlyo tiꞌ neꞌ nu tnun nchka kanꞌ chaꞌ nchga nten kanꞌ wa ndyaa ñaꞌan tiꞌ neꞌ chaꞌ ykwiꞌ ayman Xuwa chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","―Ja jlyo tiꞌ ba ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ―Suꞌwe sikwa ―ndukwin Jesús―. Kwiꞌ ngwañaꞌan naꞌ, ja katsaǎnꞌ ꞌwan ti ka nu lka nda chabiyaꞌ ꞌñaǎn chaꞌ kuꞌniǐn tñan re ―ndukwin yu ꞌin neꞌ nu tnun nchka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Kanꞌ mdyisnan Jesús ngwaꞌu ska chaꞌ tiya ꞌin neꞌ nu nduun kwiꞌ seꞌen ndiꞌin yu: ―Wa mdiya ska nten, yuꞌwi tyun yka chi kutun ꞌin yu nu wa yta yu. Ngwiñan yu ska loꞌoo chunꞌ yka kanꞌ. Bra kanꞌ ngulu yu ska tu tiyuu niꞌ kee seꞌen lyoꞌo sta neꞌ mta chi kutun, chaꞌ kulo neꞌ tyiꞌa xi nu nsuꞌwi niꞌ ran. Loꞌo ngwiñan yu ska naꞌan seꞌen kuꞌni neꞌ kwan ꞌin yka kanꞌ. ’Chunꞌ ndiꞌin la mda yu niꞌ lyoꞌoo seꞌen nduun yka kanꞌ mjñan xka ta nten, loꞌo sa tkanꞌ ti nan nu tyoꞌo lo yka kanꞌ kaja ꞌin yu bra kanꞌ. Kwiꞌ mdoꞌo yu ndyaa yu xka kichen tijyuꞌ la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Xa nu wa tiya koꞌ chaꞌ kuwin mta chi kutun, kanꞌ ngulo yu tñan ꞌin msu ꞌin yu chaꞌ tsaa seꞌen ndiꞌin nten kanꞌ, tsaa yꞌya msu chinꞌ nan nu ndiꞌin chaꞌ kanun ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bra ti msñi neꞌ nu ndiꞌin loo tñan kanꞌ ꞌin msu nu tka mdiyan ti, mjiꞌin neꞌ ꞌin msu kanꞌ; ja ska mta chi kutun mda neꞌ ku xꞌnan loꞌoo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Xiyaꞌ ngulo xꞌnan loꞌoo ꞌin xka msu chaꞌ tsaa naꞌan msu kanꞌ ꞌin yka kwiñii ꞌin yu. Xiyaꞌ yꞌni liyeꞌ tiꞌ neꞌ kanꞌ ꞌin msu nu mdiyan seꞌen ndiꞌin neꞌ. Mjiꞌin ndukunꞌ neꞌ ke msu kanꞌ, nguun neꞌ kee ꞌin msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Xiyaꞌ ngulo xꞌnan kanꞌ tñan ꞌin xka msu, loꞌo yjwi neꞌ ꞌin msu kanꞌ bra kanꞌ. Tyun msu msuꞌwa xꞌnan chaꞌ tsaa yꞌya neꞌ mta chi kutun kanꞌ, kwiꞌ yꞌni liyeꞌ ꞌa tiꞌ nten kanꞌ ꞌin taꞌa msu nu ndyaa seꞌen ndiꞌin neꞌ. Wa mdiya msu nu mjiꞌin ti neꞌ ꞌin, loꞌo mdiya nu yjwi neꞌ ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Xka ti nten nganun ꞌin xꞌnan loꞌoo kanꞌ, ti kwiꞌ lka sñiꞌ yu nu ndiya la tiꞌ yu. Loꞌo ngulo xꞌnan loꞌoo ꞌin sñiꞌ kanꞌ bra kanꞌ, chaꞌ tsaa naꞌan ꞌin nten nu tiꞌí tiꞌ kanꞌ. “Ja chan tukwa neꞌ chaꞌ nchkwiꞌ sñiěnꞌ” mskeꞌ tiꞌ xꞌnan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bra nu naꞌan nten tiꞌí tiꞌ kanꞌ ꞌin sñiꞌ xꞌnan loꞌoo kanꞌ, bra ti mdyisnan neꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ: “Yu kwa ka xꞌnan yka re nde loo la” ndukwin neꞌ ꞌin taꞌa neꞌ. “Suꞌwe la si taꞌaan kujwian ꞌin yu kwa bra ti, chaꞌ kanun yka re ꞌñaan bra kanꞌ” ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kanꞌ chaꞌ msñi neꞌ kanꞌ ꞌin sñiꞌ xꞌnan loꞌoo kanꞌ, yjwi neꞌ ꞌin yu; mxkwan neꞌ ꞌin ayman kanꞌ chunꞌ loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bra kanꞌ mnichaꞌ Jesús ꞌin nten nu wa ynan chaꞌ tiya kanꞌ: ―¿Ni sa ñaꞌan kuꞌni xꞌnan loꞌoo kanꞌ bra kanꞌ? ―ndukwin Jesús ꞌin neꞌ―. Ja chan kan ykwiꞌ xꞌnan loꞌoo kanꞌ nde seꞌen nduun yka ꞌin yu; bra ti kujwi yu ꞌin nchga nten tiꞌí tiꞌ kanꞌ, ta yu yka kwiñii kanꞌ jñan xka ta nten bra kanꞌ, chaꞌ kuꞌni neꞌ tñan nde kwa. Ngwañaꞌan kuꞌni xꞌnan loꞌoo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Ja ya chkwiꞌ wan lo kityi ꞌin Ndiose seꞌen ndukwa chaꞌ re a?: Ndiya ska kee nu mxkwan nten nu ngwiñan naꞌan ti kulo, chaꞌ ja suꞌwe ñaꞌan kee kanꞌ, mskeꞌ tiꞌ neꞌ; loꞌo ni, wa mjwi tñan nu kuꞌni kee kanꞌ, chunꞌ nduun ran seꞌen lka ndloo la chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nu lka Xꞌnaan, yꞌni Ni chaꞌ ngwañaꞌan ngwa chaꞌ kanꞌ, kanꞌ chaꞌ nduwe ꞌa tianꞌ ꞌin chaꞌ tnun kanꞌ. Ngwañaꞌan nchkwiꞌ kityi ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Loꞌo msinꞌ ꞌa tiꞌ neꞌ nu lka ndloo kanꞌ ꞌin Jesús bra kanꞌ, chaꞌ ngwa biyaꞌ tiꞌ neꞌ chaꞌ wa ykwiꞌ Jesús chaꞌ ꞌin ykwiꞌ neꞌ, laja nu ngwaꞌu yu chaꞌ tiya kanꞌ ꞌin nten. Xñi neꞌ kanꞌ ꞌin Jesús, ngwa tiꞌ neꞌ; loꞌo ja ngwa ꞌin neꞌ, chaꞌ ntsen neꞌ ꞌin nten kaꞌan kanꞌ. Kanꞌ chaꞌ mdoꞌo neꞌ nu tnun nchka kanꞌ, ndyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Chunꞌ ndiꞌin la msuꞌwa neꞌ nu tnun nchka kanꞌ tukwa snan neꞌ fariseo, kwiꞌ ngwañaꞌan msuꞌwa neꞌ la chinꞌ nten nu ꞌin ree Herodes, chaꞌ tsaa neꞌ seꞌen ndiꞌin Jesús. Wa ngulo neꞌ tñan ꞌin neꞌ chaꞌ kunaan neꞌ ska chaꞌ nu nchkwiꞌ yu, chaꞌ ka xtya neꞌ kiꞌya ꞌin yu siꞌya chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Bra wa mdiyan neꞌ kanꞌ seꞌen ndiꞌin yu, ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―Mstru ―ndukwin neꞌ ꞌin Jesús―, jlyo tiꞌ ba chaꞌ ñi ꞌa ngiꞌnii; ti kwiꞌ chaꞌ nu ñi nu wa ykwiꞌ Ndiose, kanꞌ lka chaꞌ nu nduꞌuu ꞌin nten. Ja nduwe tiiꞌ sa ñaꞌan lka chaꞌ nu chkwiꞌ nten chaꞌ ꞌiin. Ska ti biyaꞌ ñaꞌaan ꞌin nchga nten, ni siya neꞌ tiꞌi, ni siya neꞌ nu tnun nchka. Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa, ¿ta suꞌwe chaꞌ ndaan tñi nu ndlo neꞌ nu ngiꞌni tñan ꞌin ree tlyu nu ndiꞌin xka laꞌa tsuꞌ kanꞌ a? ―ndukwin neꞌ ꞌin Jesús―. ¿Ta nꞌni ꞌa chaꞌ taan tñi kanꞌ ꞌin neꞌ kwa a? ¿O ta suꞌwe la ni siya ja taan ꞌaan tñi kanꞌ siyaꞌ ti a? ");
INSERT INTO ctpNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mgii tiꞌ Jesús chaꞌ tukwa chaꞌ ndaꞌan tiye neꞌ kanꞌ. ―¿Ni chaꞌ nchkwiꞌ biyaꞌ wan ꞌñaǎn ngwañaꞌan? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Ta wan ska tñi plata ꞌñaǎn chaꞌ ñaꞌaan ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kanꞌ mda neꞌ ska tñi ꞌin yu, loꞌo mnichaꞌ Jesús ꞌin neꞌ bra kanꞌ: ―¿Ti ka nu lka nkwin nu ngaꞌan chunꞌ tñi re a? ¿Ni sa ñaꞌan nin yu nu ngwaꞌan chunꞌ tñi re a? ―ndukwin Jesús ꞌin neꞌ. ―Nin ree tlyu nu ndiꞌin xka laꞌa tsuꞌ, kanꞌ ngwaꞌan chunꞌ tñi kwa ―ndukwin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","―Suꞌwe ―ndukwin Jesús bra kanꞌ―, ta wan nchga nan nu ndiꞌin chaꞌ ta wan ꞌin ree tlyu kanꞌ sikwa; kwiꞌ ngwañaꞌan, taa wan ꞌin Ndiose nchga nan nu ndiꞌin chaꞌ taa wan ꞌin Ni. Yuwe ꞌa tiꞌ neꞌ chaꞌ nchka ꞌa ꞌin Jesús xitukwi chaꞌ loꞌo neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Chunꞌ ndiꞌin la mdiyan chinꞌ neꞌ saduceo seꞌen ndiꞌin Jesús; neꞌ kanꞌ ni, ja ndyaa ñaꞌan tiꞌ neꞌ chaꞌ ti tyuꞌu ayman xiyaꞌ. Mnichaꞌ neꞌ kanꞌ ꞌin Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Mstru ―ndukwin neꞌ kanꞌ―, wa sꞌni ngwaꞌan ayman Moisés ska chaꞌ lo kityi chaꞌ ꞌin taꞌa ngula nten. Xa wa ngujwi ska nten ni, si wa mjwi kwilyoꞌo yu loꞌo ja ya kaja sñiꞌ yu, bra kanꞌ ndiya tñan ꞌin taꞌa ngula yu nu ti ndiꞌin ska ti chaꞌ kaja kwilyoꞌo yu loꞌo nu kunaꞌan kwilyoꞌo ayman taꞌa yu. Kanꞌ chkwiꞌ neꞌ ꞌin sñiꞌ nu kala kulo ꞌin neꞌ chaꞌ sñiꞌ yu kiꞌyu nu wa ngujwi lka yu, chaꞌ ja kanaꞌ nin yu nu wa ngujwi kanꞌ. Ngwañaꞌan ykwiꞌ Moisés nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","¿Ni sa ñaꞌan ka chaꞌ ni a? Mdiya ska yaꞌ mdiꞌin kati yu kiꞌyu, xkwiꞌ taꞌa ngula neꞌ. Kanꞌ mjwi kwilyoꞌo nu kula la, loꞌo ndla ti ngujwi yu bra kanꞌ, loꞌo ja ya kaja sñiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Kwiꞌ ngwañaꞌan mjwi kwilyoꞌo nu kunaꞌan kanꞌ loꞌo xka yu taꞌa ngula ayman kanꞌ. Ti kwiꞌ ti chaꞌ ngwa, ngujwi nu kiꞌyu kanꞌ, loꞌo ja ya kaja sñiꞌ neꞌ. Xiyaꞌ mjwi kwilyoꞌo nu kunaꞌan kanꞌ loꞌo xka yu taꞌa ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kwiꞌ ngwañaꞌan ngwa chaꞌ loꞌo taꞌa kati yu kiꞌyu kanꞌ. Ja mjwi sñiꞌ neꞌ siyaꞌ ti. Xa wa mdyii chaꞌ, ngujwi nu kunaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bra nu tyuꞌu nchga ayman xiyaꞌ ni, ¿ti ka nu ka kwilyoꞌo nu kunaꞌan kanꞌ a?, chunꞌ taꞌa kati yu kiꞌyu kanꞌ wa mdiꞌin loꞌo nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","―Ja jlyo tiꞌ wan siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ kanꞌ―, chaꞌ ja nchka biyaꞌ tiꞌ wan sa ñaꞌan lka chaꞌ nu ndukwa lo kityi ꞌin Ndiose. Ja ndiꞌya wan kwenta sa ñaꞌan chaꞌ tnun ꞌa nu nchka ꞌin Ndiose kuꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Xa nu tyuꞌu nchga ayman xiyaꞌ, ja ndiꞌin chaꞌ kaja kwilyoꞌo nten bra kanꞌ, ja ta ꞌa neꞌ sñiꞌ neꞌ chaꞌ ka kuxiin nten. Sa ñaꞌan ndiꞌin angajle nde seꞌen ndiꞌin Ndiose, ngwañaꞌan tyiꞌin nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Ta ja ya tsaa ñaꞌan tiꞌ wan chaꞌ tyuꞌu ayman xiyaꞌ a? ¿Ta ja ya chkwiꞌ wan lo kityi nu ngwaꞌan ayman Moisés nu ngwa sꞌni a? Suꞌwe la si chkwiꞌ wan lo kityi kanꞌ sa ñaꞌan ndukwa chaꞌ ꞌin yka kicheꞌ kanꞌ, seꞌen nu ykwiꞌ Ndiose loꞌo Moisés: “Ndiose Xꞌnan Abraham lkaǎn” ndukwin Ni ꞌin Moisés, “kwiꞌ Ndiose Xꞌnan Isaac lkaǎn, kwiꞌ Ndiose Xꞌnan Jacob lkaǎn” ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ja ndukwin kityi kanꞌ chaꞌ nan wa ngwa Ndiose Xꞌnan ayman kanꞌ, chunꞌ ti lka Ndiose Xꞌnan neꞌ kanꞌ sa bra nu ni. Kwiꞌ ngwañaꞌan lka Ndiose Xꞌnan nchga nten luꞌu. Kanꞌ chaꞌ ndukwiǐn chaꞌ ja ngwa biyaꞌ tiꞌ wan siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ saduceo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Loꞌo mdiyan ska mstru nu nduꞌu chaꞌ joꞌo nde seꞌen ndiꞌin Jesús bra kanꞌ. Wa ynan mstru kanꞌ bra nu mxkwen neꞌ kanꞌ ꞌin Jesús, sa ñaꞌan ngwa chaꞌ suꞌwe ꞌa ykwiꞌ Jesús loꞌo neꞌ. Loꞌo mnichaꞌ mstru kanꞌ ꞌin Jesús bra kanꞌ: ―Taꞌa tñan nu ngulo Ndiose ꞌñaan chaꞌ kuꞌnian ni, ¿ni sa ñaꞌan tñan lka nu ndloo la ꞌñaan chaꞌ kuꞌnian a? ―ndukwin yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Bra kanꞌ mxkwen Jesús ꞌin mstru kanꞌ: ―Chaꞌ nu ndukwa kulo la, kanꞌ lka re: “ꞌWan neꞌ Israel, kunan suꞌwe wan ni: Ska ti Ndiose lka Xꞌnaan. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ndiꞌin chaꞌ tyukwi ti tiye wan tyiꞌin chaꞌ ꞌwan loꞌo Ndiose nu lka Xꞌnan wan; ndiꞌin chaꞌ ka luwi kasiya ꞌwan, kwiꞌ tyiꞌin chaꞌ ꞌwan loꞌo Ndiose loꞌo nchga chaꞌ tiya nu ndiꞌin ke wan, sa ñaꞌan yaꞌ nu ka ꞌwan tyiꞌin chaꞌ ꞌwan loꞌo Ni” ―ndukwin Jesús ꞌin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kwiꞌ ngwañaꞌan ndukwa xka chaꞌ: “Chka tꞌnan tiꞌ wan ꞌin taꞌa nten wan sa ñaꞌan ka bra nu nchka tꞌnan tiꞌ wan ꞌwan, ti ykwiꞌ ti wan.” Ja ndiya xka tñan nu ndloo la ꞌñaan chaꞌ kuꞌnian, ska lo ti tñan re ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","―Chaꞌ nu ñi nchkwiiꞌ, mstru ―ndukwin mstru kanꞌ ꞌin Jesús―, chañi chaꞌ nu nchkwiiꞌ chaꞌ ska ti Ndiose nu chañi chaꞌ lka Ni Xꞌnaan; ja ndiya xka nu lka xꞌnaan. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kwiꞌ ngwañaꞌan, tyukwi ti tiyean ndiꞌin chaꞌ tyiꞌin chaꞌ ꞌñaan loꞌo Ni loꞌo nchga chaꞌ tiya nu ndiꞌin kean, sa ñaꞌan yaꞌ nu ka tyiꞌin chaꞌ ꞌñaan loꞌo Ni; ndiꞌin chaꞌ kuꞌnian ngwañaꞌan. Loꞌo ndiꞌin chaꞌ chka tꞌnan tianꞌ ꞌin taꞌa nten nan, sa ñaꞌan ka bra nu nchka tꞌnan tianꞌ ꞌñaan ti ykwiinꞌ tian, suꞌwe ꞌa chaꞌ kanꞌ. Nu kuꞌnian tñan ngwañaꞌan, kaꞌan ꞌa chaꞌ suꞌwe ngiꞌnian bra kanꞌ. Chinꞌ la chaꞌ nu lka ꞌñaan chaꞌ tsaa loꞌoan lomstan nu ka ꞌin Ndiose, ni siya lomstan nchkin, ni siya ꞌni luꞌu nu kujwian nde niꞌ lyaa chaꞌ ka lomstan. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ngwa biyaꞌ suꞌwe tiꞌ yu kiꞌyu kanꞌ, mskeꞌ tiꞌ Jesús. ―Chinꞌ ti chaꞌ ti ji ꞌiin chaꞌ nu steen chaꞌ ꞌin Ndiose, chaꞌ ka Ni ndloo niꞌ kasiya ꞌiin ―ndukwin Jesús ꞌin mstru kanꞌ. Bra nu mdyii ykwiꞌ Jesús chaꞌ kanꞌ, ja ykwiꞌ ꞌa nten xka la chaꞌ loꞌo yu, chaꞌ ntsen chinꞌ neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ngwa ska yaꞌ mduun Jesús ngwaꞌu yu ꞌin nten niꞌ lyaa tnun kanꞌ, loꞌo mnichaꞌ yu ꞌin neꞌ bra kanꞌ: ―Nduꞌu mstru chaꞌ joꞌo chaꞌ ti kwiꞌ nten taꞌa ayman David ka Krixtu ―ndukwin Jesús ꞌin neꞌ―. ¿Ni chaꞌ nduꞌu mstru kanꞌ ngwañaꞌan? ");
INSERT INTO ctpNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ti kwiꞌ ayman David wa ykwiꞌ yu nu ngwa sꞌni chaꞌ Xꞌnan yu lka Krixtu. Wa ngwaꞌu Tyiꞌi Ndiose chaꞌ kanꞌ ꞌin David, kanꞌ chaꞌ ngwañaꞌan ngwaꞌan yu lo kityi: Ndiose nu lka Xꞌnaan ykwiꞌ loꞌo Krixtu nu lka Xꞌnaǎn: “Tyukwaa nde laꞌa seꞌen kwin ꞌñaǎn” ndukwin Ni, “sa ñaꞌan yaꞌ nu kuꞌni tyiǐn chaꞌ ꞌin nchga nu nxuun loꞌoo, chaꞌ kaa ndloo ꞌin nchga chaꞌ” ndukwin Ndiose nu lka Xꞌnaan ꞌin Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Xꞌnaǎn” ykwiꞌ ayman David chaꞌ ꞌin Krixtu ―ndukwin Jesús ꞌin neꞌ―. ¿Ni chaꞌ nduꞌu neꞌ chaꞌ nten ꞌin ayman David ka Krixtu sikwa? Kaꞌan ꞌa nten mduun nde kwa, loꞌo mdiya ꞌa tiꞌ neꞌ xa wa ynan neꞌ chaꞌ nu ngwaꞌu Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Loꞌo ti ngwaꞌu la Jesús ꞌin neꞌ bra kanꞌ: ―Ndii ti tiꞌ wan chaꞌ ja kwiñi lyoꞌo mstru nu nduꞌu chaꞌ joꞌo ꞌwan. Ndiya ꞌa tiꞌ neꞌ kanꞌ, chaꞌ tyijin lyo neꞌ ꞌin xka la nten ―ndukwin Jesús―. Lkuꞌ neꞌ kanꞌ teꞌ suꞌwe ñaꞌan nu tukwiin kuꞌ, chaꞌ nchka tiꞌ neꞌ chaꞌ lye ꞌa kuꞌni tnun xka la nten ꞌin neꞌ kanꞌ xa nu ndaꞌan neꞌ lo kiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ndiya tiꞌ mstru kanꞌ tyukwa lo yka xlya suꞌwe xa nu ndaꞌan neꞌ niꞌ lyaa, kwiꞌ ngwañaꞌan tyukwa neꞌ kanꞌ seꞌen suꞌwe la xa nu nchka taꞌa, ");
INSERT INTO ctpNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ni siya kulaa mstru kanꞌ naꞌan tyi neꞌ kunaꞌan nu nganun ska ti chaꞌ ngujwi kwilyoꞌo, loꞌo nchga nan nu nsuꞌwi ꞌin neꞌ kunaꞌan kanꞌ kulaa neꞌ. Chan nchkwiꞌ mstru kanꞌ loꞌo Ndiose; chaꞌ kwiñi ti ngiꞌni neꞌ ngwañaꞌan, ska ti chaꞌ ñaꞌan xka la nten ꞌin neꞌ, nchka tiꞌ neꞌ. Kanꞌ chaꞌ kaꞌan la nu tiꞌí tyijin mstru kanꞌ, bra nu tiya tsan chaꞌ kuꞌni biyaꞌ Ndiose ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ngwa ska tsan ndyaa tukwa Jesús chinꞌ niꞌ lyaa kanꞌ kwiꞌ seꞌen nduun kajun seꞌen nsuꞌwa neꞌ tñi chaꞌ ka lomstan. Naꞌan yu ꞌin kaꞌan ꞌa nten nu mdaꞌan msuꞌwa lomstan niꞌ kajun nde kwa. Mdiyan chinꞌ neꞌ kuliyaꞌ, loꞌo kaꞌan ꞌa tñi msuꞌwa neꞌ kuliyaꞌ kanꞌ niꞌ kajun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chunꞌ ndiꞌin la mdiyan ska nu kunaꞌan tiꞌi nu msuꞌwa tukwa ti tñi xuwe niꞌ kajun kanꞌ, kwiꞌ nu chinꞌ ꞌa nsuꞌwi lyo. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ kan neꞌ seꞌen ndiꞌin yu: ―Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús ꞌin neꞌ kanꞌ―, chaꞌ tlyu la lomstan mda nu kunaꞌan tiꞌi kwa ke nchga lomstan nu mda xka la nten nu ndaꞌan re. ");
INSERT INTO ctpNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Xka ta nten ni, mda neꞌ tñi nu nganun ti ꞌin neꞌ. Loꞌo nu kunaꞌan tiꞌi kwa mda nchga nan nu nsuꞌwi ti chinꞌ ꞌin; nchga nan nu ndiya ꞌin chaꞌ kaja chinꞌ nan ku, wa mda nu kunaꞌan kanꞌ ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Chunꞌ ndiꞌin la wa tyoꞌo ti Jesús niꞌ lyaa tnun kanꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ―Mstru ―ndukwin ska yu ꞌin Jesús―, ¡ñaꞌan kwiꞌyaa chinꞌ laa tnun re chaꞌ suꞌwe ꞌa ndyaꞌ! ¡Suꞌwe ꞌa ñaꞌan kee nu nsuꞌwi siꞌ naꞌan re! ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","―¿Ta wa naꞌan wan chaꞌ tnun ꞌa naꞌan kee re a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Nde loo la tiya ska tsan chaꞌ kuꞌni tyii siyaꞌ ti nten ꞌin naꞌan re, sa ñaꞌan bra nu ja ska kee kanun nu xñi kaꞌan chunꞌ taꞌa ran. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mdoꞌo neꞌ ndyaa neꞌ lo kiꞌya Olivos, ndyaa tukwa neꞌ chinꞌ seꞌen nchkanꞌ suꞌwe laa tnun kanꞌ bra kanꞌ. Mdaꞌan Jesús loꞌo Tyu loꞌo Santiago loꞌo Xuwa loꞌo Ndre, loꞌo mnan ti mnichaꞌ neꞌ kanꞌ ꞌin yu bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Katsaaꞌ ꞌwa, ¿ni bra ka nu kuꞌni tyii neꞌ ꞌin laa tnun kwa a? ―ndukwin neꞌ kanꞌ ꞌin Jesús―. ¿Ni sa ñaꞌan ka chaꞌ ka biyaꞌ tiꞌ ba chaꞌ wa ka ti chaꞌ kuxi kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ngwaꞌu la chinꞌ Jesús ꞌin neꞌ bra kanꞌ: ―Kiꞌya wan kwenta chaꞌ ja tukwin kwiñi lyoꞌo ꞌwan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Nde loo la kan kaꞌan nten nu chkwiꞌ chaꞌ kwiñi chaꞌ ꞌñaǎn. Chkwiꞌ neꞌ chaꞌ Krixtu lka neꞌ, ngwañaꞌan kwiñi lyoꞌo neꞌ kanꞌ ꞌin kaꞌan nten nu tsaa ñaꞌan tiꞌ chaꞌ kwiñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Bra kanꞌ kanen chaꞌ nxuun taꞌa nten nasiyun re loꞌo nten xka nasiyun, loꞌo kunan wan chaꞌ nxuun nten nasiyun tijyuꞌ la. Ja kutsen wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Xuun nten ska tsuꞌ loꞌo nten xka laꞌa tsuꞌ, kwiꞌ xuun nten ska kichen tnun loꞌo nten xka kichen tnun. Loꞌo tyun seꞌen kiñan chalyuu bra kanꞌ. Kwiꞌ ngwañaꞌan, nchga seꞌen kaja jwiꞌñan ꞌin neꞌ. Nchga chaꞌ kanꞌ ka bra nu wa tyisnan ti nu tiꞌí nu ka ꞌin nten chalyuu, siꞌi nan wa tyii ti chalyuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Loꞌo ꞌwan ni, ndii ti tiꞌ wan tyiꞌin wan bra kanꞌ ―ndukwin Jesús―. Xñi nten kuxi ꞌwan, xtya neꞌ kiꞌya ꞌwan tloo neꞌ wsiya; jwiꞌin neꞌ kanꞌ ꞌwan la niꞌ lyaa ꞌin neꞌ. Ndiꞌin chaꞌ tyituun wan tloo neꞌ gobierno, loꞌo tloo neꞌ nu lka ndloo; chkwiꞌ wan nchga chaꞌ suꞌwe nu ꞌñaǎn loꞌo neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ti ji tyii chalyuu bra kanꞌ, chaꞌ kulo ndiꞌin chaꞌ kanen chaꞌ suꞌwe ꞌñaǎn seꞌen ndiꞌin nchga nten ñaꞌaan chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ja kutsen wan bra nu xñi nten ꞌwan chaꞌ tsaa loꞌo neꞌ ꞌwan seꞌen ndiꞌin neꞌ wsiya, chaꞌ ka biyaꞌ ꞌwan tloo neꞌ kanꞌ; ja tyaꞌan ꞌa chaꞌ tiye wan sa ñaꞌan ka chaꞌ nu xkwen wan ꞌin neꞌ kanꞌ; ta Ndiose nchga chaꞌ nu ndiꞌin chaꞌ chkwiꞌ wan tsan kanꞌ. Siꞌi wan, ti ykwiꞌ ti wan, nu chkwiꞌ wan loꞌo neꞌ kanꞌ, chaꞌ loꞌo tyukwi chabiyaꞌ ꞌin Tyiꞌi Ndiose chkwiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kuxi ꞌa ka tsan bra kanꞌ; kujwiꞌ xuꞌwa neꞌ ꞌin taꞌa nten neꞌ chaꞌ kujwi nten ꞌin neꞌ, ngwañaꞌan kujwiꞌ xuꞌwa neꞌ ꞌin sñiꞌ neꞌ. Loꞌo neꞌ kuneꞌ ni, kasinꞌ tiꞌ neꞌ ꞌin sti neꞌ, ꞌin jyaꞌan neꞌ bra kanꞌ; ta neꞌ kuneꞌ kanꞌ ta sti neꞌ, o ta jyaꞌan neꞌ chaꞌ kujwi nten kuxi ꞌin neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lye ꞌa ka tiꞌí tiꞌ nchga nten ꞌwan chaꞌ nten ꞌñaǎn lka wan. Ja kuwe tiꞌ wan; nchga wan nu talo wan ꞌin chaꞌ kuxi kanꞌ sa bra nu tyii chalyuu, kulaa Ndiose ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Ndukwa ska chaꞌ lo kityi nu ngwaꞌan ayman Daniel nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; wa ngwaꞌan chaꞌ nde loo la ñaꞌan wan bra nu xituun neꞌ ska nan nu chen ꞌa ñaꞌan, nu kuꞌni ñuꞌun ꞌin nchga nan luwi. ―Ka biyaꞌ tiꞌ wan chaꞌ kanꞌ bra nu chkwiꞌ wan lo kityi re―. Bra nu ñaꞌan wan chaꞌ nduun nan chen ñaꞌan kanꞌ nde niꞌ lyaa tnun seꞌen ja nsuꞌwi chabiyaꞌ tyuun ran ―ndukwin Jesús―, bra kanꞌ ndiꞌin chaꞌ xnan nchga wan nu ndiꞌin lo yuu Judea, xnan wan chaꞌ xuꞌwi kutsiꞌ wan lo kiꞌya. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Xnan lya wan tsan kanꞌ. Si ngaꞌan ska nten ke naꞌan tyi yu tsan kanꞌ, ja kaja ꞌa bra chaꞌ tyaan yu nde niꞌ ñaꞌan, chaꞌ kulo yu yuꞌwa nu nsuꞌwi ꞌin yu; ndiꞌin chaꞌ kiꞌya yu lyuu bra ti chaꞌ xnan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kwiꞌ ngwañaꞌan, si ngaꞌan ska nten lo jyan tsan kanꞌ, ja kaja ꞌa bra xitukwi yu nde naꞌan tyi yu chaꞌ kiꞌya yu teꞌ kichanꞌ ꞌin yu, ndiꞌin chaꞌ xnan yu bra ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Tꞌnan ꞌa nu kunaꞌan tnan! Loꞌo nu kunaꞌan nu nsuꞌwi kuwiꞌ kuneꞌ nu ti ngatiꞌ, ¡tꞌnan ꞌa ka neꞌ kanꞌ bra nu tiya tsan kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Suꞌwe ti jñan wan chaꞌ ꞌin Ndiose chaꞌ ja ka tyempu tlyaꞌ bra nu ndiꞌin chaꞌ xnan wan, ");
INSERT INTO ctpNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","chaꞌ kaꞌan ꞌa nu tiꞌí tyijin wan tsan kanꞌ. Ja ya tyijin nten chalyuu nu tiꞌí ngwañaꞌan, ti bra nu ngwiñan Ndiose chalyuu. Loꞌo kwiꞌ tyempu nu ka nde loo la, ja tyijin ꞌa nten nu tiꞌí ngwañaꞌan xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wa ytsaꞌ nu lka Xꞌnaan ꞌñaan chaꞌ chinꞌ ti tsan ka bra nu tyijin neꞌ nu tiꞌí kanꞌ; chunꞌ nchka tꞌnan tiꞌ Ni ꞌwan nu lka wan nten ꞌin Ni, kanꞌ chaꞌ kuꞌni Ni chaꞌ chinꞌ ti bra talo tsan kuxi kanꞌ. Si chan talo tsan kuxi kanꞌ, ja ska nten chalyuu lyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Nde loo la ka bra nu katsaꞌ neꞌ kwiñi ꞌwan: “Kan naꞌan wan chinꞌ nde re, wa ngala Krixtu” nchkwin neꞌ kwiñi ꞌwan. “Yaa naꞌan wan nde kwa, wa ngala Krixtu kichen kwa” nchkwin xka nu kwiñi bra kanꞌ. Ja kunan wan chaꞌ nu chkwiꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Krixtu kwiñi ka neꞌ kanꞌ. Kwiꞌ ngwañaꞌan, kan la chinꞌ nten kwiñi nu chkwiꞌ chaꞌ ntsaꞌ neꞌ chaꞌ nu ykwiꞌ Ndiose loꞌo nten; chaꞌ kwiñi ti kuꞌni neꞌ kanꞌ chaꞌ tnun, chaꞌ kuwe ꞌa tiꞌ nten. Kuꞌni neꞌ kwiñi kanꞌ ngwañaꞌan, chaꞌ kwiñi lyoꞌo neꞌ ꞌwan, chaꞌ nchka tiꞌ neꞌ kwiñi lyoꞌo neꞌ ꞌin nchga nten nu wa ngulo suwi Ndiose chaꞌ ka neꞌ nten ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wa ytsaǎnꞌ chaꞌ kanꞌ ꞌwan ni, ni siya ti ji ka chaꞌ kuxi kanꞌ, chaꞌ kiꞌya wan kwenta sa ñaꞌan ka chaꞌ kanꞌ, chaꞌ ka ndii ti tiꞌ wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ti ngwaꞌu la Jesús chinꞌ chaꞌ ꞌin neꞌ bra kanꞌ: ―Bra nu mdyii mdijin nten nu tiꞌí kanꞌ ―ndukwin Jesús―, ka tla ñaꞌan xaa kwan bra kanꞌ, kwiꞌ ngwañaꞌan ja chkanꞌ xaa koꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kwii kulasiin nu ndukwi kwan kalu lyuu bra kanꞌ, loꞌo kiñan nchga nan nu nsuꞌwi niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Loꞌo naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ni, ñaꞌan nten ꞌñaǎn, chaꞌ tyaǎn xiyaꞌ laja koo nu nduwi ꞌa. Lye chinꞌ ñaꞌan ka bra kanꞌ, chaꞌ loꞌo nchga jwersa ꞌñaǎn tyaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Bra kanꞌ kuloǔn tñan ꞌin kaꞌan ꞌa angajle, chaꞌ tsaa angajle kanꞌ xoꞌ tiꞌin seꞌen ti nchga nten nu wa ngulo suwi Ndiose; tsaa angajle kanꞌ nchga seꞌen ndiꞌin nten kanꞌ ñaꞌaan chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ndiya ska chaꞌ nu ka kiꞌyaan kwenta si ñaꞌaan yka kityi, yka nstin. Xa nu tyisnan tyukwa kuten, kanꞌ kalu lkaꞌ, loꞌo ka biyaꞌ tianꞌ chaꞌ wa ndla ti kala niꞌ tyoo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kwiꞌ ngwañaꞌan, ka biyaꞌ tiꞌ wan chaꞌ wa tyii ti nchga chaꞌ, xa nu ñaꞌan wan chaꞌ wa ndoꞌo tukwa nchga chaꞌ nu wa ytsaǎnꞌ ꞌwan tsan; wa ka ti chaꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ nu ja ya tyii chaꞌ ꞌin nchga nten nu luꞌu lo chalyuu ni, bra kanꞌ ka nchga chaꞌ lo chalyuu sa ñaꞌan nu ytsaǎnꞌ ꞌwan tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tyii chaꞌ ꞌin nchga nan nu nsuꞌwi niꞌ kwan, tyii chaꞌ ꞌin nchga nan nu nsuꞌwi lo chalyuu, ni siya ja tyii siyaꞌ ti chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ xkwiꞌ chaꞌ nu ñi lka chaꞌ nu nchkwiǐnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Ja ska nten jlyo tiꞌ ni tsan ka chaꞌ kanꞌ, ni bra ka ran; ni siya angajle, ni siya naꞌ, skaǎn tiǎn nu lkaǎn Sñiꞌ Ndiose, ja jlyo tianꞌ. Ska ti Stian Ndiose, jlyo tiꞌ Ni ni tsan ka chaꞌ tnun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Ndii ti tiꞌ wan tyiꞌin wan sikwa. Ndla ti tiꞌ wan tyiꞌin wan bra nu kata wan ꞌin Ndiose, chaꞌ ja jlyo tiꞌ wan ni ñaꞌan bra kan Ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Sa ñaꞌan lka xa nu wa tsaa ti ska nten tijyuꞌ, bra wa tsaa ti yu, ta yu tñan ꞌin msu chaꞌ ñaꞌansiin neꞌ naꞌan tyi yu, ska tñan skaa msu kanꞌ; kwiꞌ kulo xꞌnan naꞌan kanꞌ tñan ꞌin yu kiꞌyu nu nduun kwan tuloꞌoo chaꞌ ka ndii ti tiꞌ yu nchga bra. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ngwañaꞌan ꞌwan ni, ndii ti tiꞌ wan tyiꞌin wan chaꞌ ja jlyo tiꞌ wan sa ñaꞌan bra tyaan Xꞌnan wan, ni siya nde msiin, ni siya jluꞌwe tla, ni siya bra nu msiꞌya la kweꞌe, ni siya wa ngwiꞌya xaa xka tsan. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ndii ti tiꞌ wan tyiꞌin wan sikwa, si siyaꞌ ka kala Xꞌnan wan, chaꞌ ja tyoꞌo tukwa yu laja bra nu lajaꞌ ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan, kwiꞌ ngwañaꞌan loꞌo nchga nten: Ndii ti tiꞌ wan tyiꞌin wan sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tyukwa tsan ti ji chaꞌ ka taꞌa pascua, taꞌa nu nchku neꞌ jaxlya tiji nu ja loꞌo skwan tiyeꞌ ndyaꞌ bra kanꞌ. Kanꞌ ndyaa naan sti joꞌo nu lka ndloo, ndyaa naan mstru nu nduꞌu chaꞌ joꞌo, ndyaa naan neꞌ sa ñaꞌan kuꞌni neꞌ chaꞌ ka xñi neꞌ ꞌin Jesús mnan ti, chaꞌ kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―Ja suꞌwe xñian ꞌin yu tsan nchka taꞌa ―ndukwin neꞌ―. Kasinꞌ ꞌa tiꞌ nchga nten nu ndiꞌin taꞌa si ngwañaꞌan kuꞌnian, tlyu ꞌa chaꞌ wsuun ka kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Loꞌo ndiꞌin Jesús naꞌan tyi Simón nu wa msñi kicha nu ngatsuꞌ kunaꞌ yu nu ngwa sꞌni la. Nde kichen Betania ndukwa tyi Simón kanꞌ. Bra nu ndukwa neꞌ tuꞌwa msaa nchku neꞌ, kanꞌ mdiyan ska nu kunaꞌan seꞌen ndiꞌin neꞌ, mdiyan loꞌo ska teꞌén lyuꞌ ti nu ndyaꞌ loꞌo kee alabastro. Wa msaꞌan teꞌén lyuꞌ ti loꞌo tyiꞌa xi tyiꞌi nu lka sete nardo; kaꞌan ꞌa ngaꞌan sete kanꞌ. Bra kanꞌ mcha nu kunaꞌan kanꞌ tuꞌwa teꞌén, mslu tyiꞌa xi tyiꞌi kanꞌ lo jlyuꞌwe Jesús seꞌen ndukwa yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kanꞌ chaꞌ msinꞌ tiꞌ chinꞌ nten taꞌa nchku neꞌ bra nu naꞌan neꞌ chaꞌ yꞌni nu kunaꞌan kanꞌ ngwañaꞌan: ―¿Ni chaꞌ mslu nu kunaꞌan sete kwa ngwañaꞌan ti? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","¿Ni chaꞌ ja yjwiꞌ ran chaꞌ kaja chinꞌ tñi chaꞌ ta ꞌin neꞌ tiꞌi? Wa mdijin snan siyentu tñi plata ngaꞌan sa kwa sete xi tyiꞌi kanꞌ ―ndukwin neꞌ ꞌin taꞌa neꞌ. Lye ꞌa mxichaꞌ neꞌ ꞌin nu kunaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","―Ja chkwiꞌ wan loꞌo nu kunaꞌan re chaꞌ ja kuꞌni ngwañaꞌan ―ndukwin Jesús ꞌin neꞌ―. Suꞌwe ꞌa tñan yꞌni nu kunaꞌan re chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nchga tsan ndiꞌin neꞌ tiꞌi loꞌo wan lo chalyuu re, kanꞌ chaꞌ ka kuꞌni wan chaꞌ suꞌwe loꞌo neꞌ tiꞌi sa ñaꞌan bra nu nchka tiꞌ wan; loꞌo naꞌ ni, wa tyii ti tsan nu tyiꞌiǐn loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wa yꞌni nu kunaꞌan re nchga chaꞌ sa ñaꞌan nu ngwa ꞌin. Nan wa yꞌni chaꞌ ka xi tyiꞌi tyukwi ñaꞌaǎn ni; ni siya ti ji kajaǎn, nde loo la yꞌni xuꞌwe nu kunaꞌan re ꞌñaǎn tyukwi ñaꞌaǎn chaꞌ kutsiꞌ neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ nchga seꞌen nu kanen chaꞌ ꞌñaǎn ñaꞌaan chalyuu, la kanꞌ kunan nten nchga chaꞌ nu wa yꞌni nu kunaꞌan re tsan ni, chaꞌ tyuꞌwi tiꞌ nten chaꞌ suꞌwe ꞌa tñan yꞌni nu kunaꞌan re. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Loꞌo Juda Iscariote ni, ti kwiꞌ taꞌa yu loꞌo nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús lka yu kanꞌ. Bra kanꞌ mdoꞌo Juda kanꞌ ndyaa yu seꞌen ndiꞌin sti joꞌo nu lka ndloo la, chaꞌ kujwiꞌ xuꞌwa yu ꞌin Jesús yaꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Suꞌwe ꞌa ngwa tiye neꞌ nu tnun nchka kanꞌ xa nu ynan neꞌ chaꞌ nu ykwiꞌ Juda loꞌo neꞌ, kanꞌ chaꞌ ykwiꞌ neꞌ tnun kanꞌ loꞌo yu chaꞌ ta neꞌ tñi ꞌin yu. Bra kanꞌ mdyisnan Juda ndyaa naan yu ni bra ka nu ta yu ꞌin Jesús yaꞌ neꞌ xaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nu ngwa tsan kulo ꞌin taꞌa nu nchku neꞌ jaxlya tiji nu ja loꞌo skwan tiyeꞌ ndyaꞌ kanꞌ, tsan kanꞌ ngwa taꞌa siin pascua, tsan nu ndujwi neꞌ slyaꞌ kuneꞌ chaꞌ ku neꞌ taꞌa. Bra kanꞌ mnichaꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús: ―¿La nde yaꞌ kuꞌni xuꞌwe ba chaꞌ ku siinan chaꞌ ꞌin taꞌa pascua a? ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Loꞌo ngulo Jesús tñan ꞌin tukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Yaa lya wan lo kichen tnun kwa ―ndukwin yu ꞌin neꞌ kanꞌ―. Nde kwa tyukwa taꞌa wan loꞌo ska yu kiꞌyu nu ndukwa ska teꞌen tyiꞌa skun yu. Tsaa ñaꞌan wan ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Seꞌen sten yu niꞌ ñaꞌan, chkwiꞌ wan loꞌo nu lka xꞌnan naꞌan kanꞌ: “Nde lka tñan nu ndukwin mstru ꞌñaan ꞌiin. Kuꞌnii chaꞌ suꞌwe katsaaꞌ ꞌñaǎn, ¿la nde yaꞌ kaja seꞌen nu kuǔn siinǎnꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌñaǎn, chaꞌ kuꞌni ba taꞌa pascua?” Ngwañaꞌan chkwiꞌ wan loꞌo nten nu nka tyi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Loꞌo kwaꞌu yu ska seꞌen tlyu ꞌwan bra kanꞌ, ska naꞌan nu ndiya xka pisu nde kwan nu wa lka ngwa suꞌwe, seꞌen ndiꞌin nchga nan nu kunanjoꞌo ꞌñaan bra kanꞌ. La kanꞌ kuꞌni xuꞌwe wan nan nu ku siinan ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kanꞌ chaꞌ mdoꞌo neꞌ ndyaa neꞌ lo kichen tnun kanꞌ, mdiyan neꞌ tuꞌwa naꞌan kanꞌ; sa ñaꞌan nu wa ndukwin Jesús ꞌin neꞌ, ngwañaꞌan ngwa chaꞌ kanꞌ. Kwiꞌ yꞌni xuꞌwe neꞌ nan nu ku siin neꞌ chaꞌ ꞌin taꞌa pascua bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Xa wa msiin, mdiyan Jesús loꞌo tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Laja nu ndiꞌin neꞌ nchku neꞌ, bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús―. Ndiya ska nten taꞌa wan nu suꞌwa ti nchku loꞌoǔn ni, nu wa kujwiꞌ xuꞌwa ti ꞌñaǎn yaꞌ nten xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xiꞌin chinꞌ tiꞌ neꞌ ndiꞌin neꞌ bra kanꞌ. Bra ti mdyisnan taꞌa neꞌ ykwiꞌ neꞌ loꞌo Jesús: ―¿Ta naꞌ nu taǎn ꞌiin yaꞌ nten xaꞌan a? ―ndukwin ska yu ꞌin Jesús. ―¿Ta naꞌ a? ―ndukwin xka yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","―Ska yu taꞌa tii tyukwa wan, kanꞌ lka nu kujwiꞌ xuꞌwa ꞌñaǎn yaꞌ nten xaꞌan ―ndukwin Jesús ꞌin neꞌ―. Ska yu taꞌa wan nu suꞌwa nchku loꞌoǔn ska ti niꞌ kaꞌnan skwa re ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Naꞌ ni, nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ka chaꞌ kuxi ꞌñaǎn sa ñaꞌan nu ndukwa chaꞌ ꞌñaǎn lo kityi ti ngwa sꞌni. Tꞌnan ꞌa nten nu ta ꞌñaǎn yaꞌ nten xaꞌan bra kanꞌ, suꞌwe la ngwa ꞌin yu ni siya ja yan yu lo chalyuu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ti nchku siin neꞌ bra nu msñi Jesús ska jaxlya, ndya yu xuꞌwe ꞌin Ndiose chaꞌ ꞌin jaxlya kanꞌ, msuꞌwe yu ꞌin ran, chaꞌ kutsaa yu ran ꞌin nten chaꞌ ku neꞌ. ―Ku wan jaxlya re ―ndukwin Jesús ꞌin neꞌ―. Nde lkaǎn, tyukwi ñaꞌaan ykwiǐnꞌ lka re. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Kanꞌ msñi Jesús ꞌin ska basu mñun, ndya yu xuꞌwe ꞌin Ndiose, mda yu mñun ꞌin neꞌ chaꞌ koꞌo neꞌ bra kanꞌ. Yiꞌo nchga neꞌ mñun kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","―Ñaꞌan tiꞌ tneěn, ngwañaꞌan ka mñun re ―ndukwin Jesús ꞌin neꞌ―. Xa nu kajaǎn lo wsi, kalu tneěn chaꞌ kaja sa ñaꞌan kuꞌni tyii Ndiose kiꞌya nu ndiꞌin ꞌin nchga nten chalyuu, chaꞌ ngwañaꞌan xkanꞌ Ni chaꞌ loꞌo nten xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ ja koꞌoǔn ꞌaǎn mñun xiyaꞌ ni, sa ñaꞌan bra nu tiya tsan kanꞌ nu koꞌoǔn mñun kwi loꞌo wan nde seꞌen ndiꞌin Ndiose ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Bra wa yla tuꞌwa neꞌ kantu ꞌin Ndiose, mdoꞌo neꞌ ndyaa neꞌ lo kiꞌya Olivos bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Xiyaꞌ ykwiꞌ Jesús loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Taꞌa wan ka jyuꞌu tiꞌ wan ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ―. Kulaa yaꞌ wan chinꞌ ꞌñaǎn ndiꞌa. Kanꞌ ka chaꞌ nu ndukwa lo kityi ꞌin Ndiose: “Kujwiǐn ꞌin nten nu naꞌansiin ꞌin slyaꞌ kanꞌ, loꞌo xnan nchga slyaꞌ tyaa iꞌ bra kanꞌ, ndukwin Ndiose.” Ngwañaꞌan nchkwiꞌ kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bra nu tyuꞌuǔn xiyaꞌ, tsaꞌaǎn Galilea nde loo la ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","―Ja chan nchga nten kulaa yaꞌ neꞌ ꞌiin; loꞌo naꞌ ni, ja kulaǎn tiꞌiǐn ꞌiin siyaꞌ ti ―ndukwin Tyu ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","―Chañi chaꞌ nu nchkwiǐnꞌ loꞌoo ―ndukwin Jesús ꞌin Tyu―. Ndiꞌa, snan yaꞌ chkwiꞌ nuꞌwin loꞌo nten chaꞌ ja nsuꞌwi lyoo ꞌñaǎn. Ngwañaꞌan chkwiiꞌ loꞌo nten xa nu ti ji xiꞌya la kweꞌe tukwa yaꞌ ndiꞌa, xa wa tla. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","―Ja chkwiǐnꞌ loꞌo nten chaꞌ ja nsuꞌwi lyoǔn ꞌiin ―ndukwin Tyu ꞌin Jesús―. Si kujwi nten ꞌiin, ni siya wa kujwi ti nten ꞌñaǎn, ja xkweěn ꞌin nten chaꞌ ja nsuꞌwi lyoǔn ꞌiin ―ndukwin Tyu ꞌin Jesús. Lye ꞌa ykwiꞌ Tyu, kwiꞌ ngwañaꞌan nchga neꞌ kwa, suꞌwa ti ykwiꞌ neꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Loꞌo ndyaa neꞌ ska niꞌ lyoꞌoo seꞌen nduun yka tlaꞌ, ska yuu nu ngwa naan Getsemaní bra kanꞌ. ―Tyukwa wan chinꞌ nde ti ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. Tsaꞌaǎn nde kwa la chinꞌ chaꞌ chkwiǐnꞌ loꞌo Ndiose Stiǐn ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ndyaa yu la chinꞌ bra kanꞌ, ndyaa yu loꞌo Tyu loꞌo Santiago loꞌo Xuwa. Kanꞌ lye ꞌa ngwa xiꞌin tiꞌ Jesús, mdaꞌan ꞌa chaꞌ tiye yu sa ñaꞌan ka chaꞌ kuxi nu ndiꞌin chaꞌ ka ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","―Xiꞌin ꞌa tiǎnꞌ ni ―ndukwin Jesús ꞌin neꞌ―, ja taloǔn siꞌya chaꞌ xiꞌin kanꞌ. Nde ti kanun wan, ndii ti tiꞌ wan tyiꞌin wan ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ti ndyaa Jesús la chinꞌ nde kwa la, mduun xtyinꞌ yu lo yuu ti, mjñan yu ꞌin Ndiose si kaja ñaꞌan nu ka ꞌin yu chaꞌ ja tyukwa yu chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―Stiǐn ―ndukwin Jesús ꞌin Ndiose―, nchga lo tñan nchka ꞌiin kuꞌnii. Kanꞌ chaꞌ ni, ja taa chabiyaꞌ tyukwaǎn chaꞌ kuxi re, si kaja xka ñaꞌan nu ka kuꞌniǐn tñan re ―ndukwin Jesús ꞌin Ndiose Sti yu―. Loꞌo siꞌi sa ñaꞌan nu nchka tiǎnꞌ chaꞌ ka; nuꞌwin kuꞌnii loꞌoǔn sa ñaꞌan nu nchka tiiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bra kanꞌ ndyaan Jesús xiyaꞌ seꞌen ndiꞌin snan nten kanꞌ, loꞌo lajaꞌ ti neꞌ kanꞌ bra kanꞌ. ―Simón ―ndukwin yu ꞌin Tyu―, ¿ta lajaaꞌ tii ni a? ―ndukwin―. ¿Ta ja nchka kaa ndii tiiꞌ chinꞌ, ni siya ska bra ti a? ");
INSERT INTO ctpNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndii ti tiꞌ wan tyiꞌin wan ni. Chkwiꞌ wan loꞌo Ndiose chaꞌ ja kuꞌni kuneꞌ xaꞌan kanan ꞌwan. Jlyo tiǎnꞌ chaꞌ tyukwi ti tiye wan xlyaa wan kuꞌni wan tñan re ꞌñaǎn; loꞌo ja ndalo wan, kanꞌ chaꞌ ndla ꞌa yijaꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Xiyaꞌ ndyaa Jesús la chinꞌ, ti kwiꞌ ti chaꞌ mjñan yu ꞌin Ndiose Sti yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kanꞌ ndyaan yu xiyaꞌ seꞌen ndiꞌin neꞌ kanꞌ, loꞌo xiyaꞌ lajaꞌ neꞌ kanꞌ, chaꞌ lye ꞌa yuꞌwi sla neꞌ. Ja jlyo ꞌa tiꞌ neꞌ sa ñaꞌan xkwen neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xiyaꞌ ndyaa Jesús bra kanꞌ. Kwiꞌ ngwañaꞌan snan yaꞌ ndyaan Jesús seꞌen ndiꞌin neꞌ. ―¿Ti lajaꞌ wan a? ¿Ti ndiꞌin tñaꞌ wan a? ―ndukwin Jesús ꞌin neꞌ―. Yaꞌ la ni sikwa, wa mdiya bra nu tyaa loꞌo neꞌ ꞌñaǎn nu wa msuꞌwa Ndiose ndijyaǎn chaꞌ kaǎn nten. Wa ta ti nten ꞌñaǎn yaꞌ nten xaꞌan ni. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tyituun wan tyaan ni, chaꞌ wa mdiyan yu nu wa yꞌni trisiyun ꞌñaǎn yaꞌ nten xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Laja bra nu ykwiꞌ Jesús, mdiyan Juda kanꞌ seꞌen ndiꞌin yu, ti kwiꞌ taꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu ngwa Juda kanꞌ. Kaꞌan ꞌa nten tlá mdaꞌan loꞌo Juda, nten nu wa ngulo neꞌ wsiya tñan ꞌin chaꞌ kan loꞌo ꞌin Jesús; loꞌo xtyi wsuun, loꞌo yka ndiꞌya neꞌ ndijyan neꞌ. Sti joꞌo nu lka ndloo la, loꞌo mstru nu nduꞌu chaꞌ joꞌo, loꞌo neꞌ kula ꞌin kichen, kanꞌ lka nu ngulo tñan ꞌin neꞌ tlá kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juda nu wa ta ti ꞌin Jesús yaꞌ nten xaꞌan kanꞌ, wa ykwiꞌ yu loꞌo neꞌ tlá kanꞌ nu ngwa tsan, ytsaꞌ yu sa ñaꞌan nu kuꞌni yu: ―Chkwichaǎnꞌ kijin skaꞌ yu kiꞌyu kanꞌ ―ndukwin Juda ꞌin neꞌ tlá―. Xñi lya wan ꞌin yu bra kanꞌ, yaa loꞌo lya wan ꞌin yu kanꞌ ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kanꞌ chaꞌ ndijyan Juda, bra ndyaa yu seꞌen nduun Jesús chaꞌ chkwichaꞌ yu skaꞌ Jesús: ―¿Nde ti nduun, mstru? ―ndukwin Juda ꞌin Jesús. Ykwichaꞌ Juda skaꞌ Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Bra ti msñi neꞌ tlá ꞌin Jesús, chaꞌ tyaa loꞌo neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Loꞌo ska nten taꞌa ndaꞌan Jesús mskwin yu xtyi ꞌin yu, msiꞌyu kuꞌ yu jin nxkan ska msu ꞌin sti joꞌo nu lka ndloo la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kanꞌ ykwiꞌ Jesús loꞌo neꞌ tlá kanꞌ: ―¿Ta loꞌo xtyi wsuun loꞌo yka ndiꞌya wan ndaꞌan wan chaꞌ xñi wan ꞌñaǎn a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿Ta ska nten nu yꞌni kunan lkaǎn sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tyun ꞌa tsan naꞌan wan ꞌñaǎn xa nu mdiꞌiǐn niꞌ lyaa tnun, ngwaꞌuǔn chaꞌ ꞌin Ndiose ꞌin nten nde kwa, loꞌo ja msñi wan ꞌñaǎn bra kanꞌ. Jlyo tiǎnꞌ sa ñaꞌan chaꞌ nchka ni, chunꞌ kwiꞌ ngwañaꞌan nchkwiꞌ kityi ꞌin Ndiose chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Bra kanꞌ ngulaa yaꞌ nchga taꞌa ndaꞌan Jesús ꞌin yu, msnan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Loꞌo ska yu kuneꞌ ti, nganun yu mdaꞌan ñaꞌan yu ꞌin nten nu ndyaa loꞌo ꞌin Jesús. Ska teꞌ ngaten ti mxiin chunꞌ yu kuneꞌ kanꞌ. Loꞌo xñi neꞌ tlá kanꞌ ꞌin yu kuneꞌ, ngwa tiꞌ neꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kanꞌ chaꞌ mxnun yu teꞌ ngaten kanꞌ yaꞌ neꞌ, msnan yu tiꞌyu ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndyaa loꞌo neꞌ ꞌin Jesús tloo xꞌnan sti joꞌo bra kanꞌ. Nde kwa mdyoꞌ tiꞌin nchga sti joꞌo nu lka ndloo la, loꞌo neꞌ kula, loꞌo mstru nu nduꞌu chaꞌ joꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tijyuꞌ ti mdaꞌan ñaꞌan Tyu chunꞌ neꞌ tlá kanꞌ, sa bra nu mdiyan neꞌ niꞌ lyoꞌoo ꞌin xꞌnan sti joꞌo. Bra kanꞌ ndyaa tukwa Tyu seꞌen ndiꞌin nten nu ndiꞌin kwan tunaꞌan kanꞌ. Ndukwa neꞌ tuꞌwa kiiꞌ chaꞌ katsun ti neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Loꞌo sti joꞌo nu lka ndloo la, loꞌo nchga neꞌ wsiya kanꞌ, ngwa tiꞌ neꞌ xtya neꞌ kiꞌya ꞌin Jesús chaꞌ ka kujwi neꞌ ꞌin yu, loꞌo ja mjwi ñaꞌan nu xtya neꞌ kiꞌya ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mdaꞌan ꞌa neꞌ kwiñi tloo neꞌ wsiya kanꞌ, chaꞌ xtya neꞌ kiꞌya ꞌin yu, loꞌo ja suꞌwa ykwiꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nu wa tyii ti chaꞌ, bra kanꞌ mdyituun la chinꞌ neꞌ kwiñi, ykwiꞌ neꞌ loꞌo neꞌ nu tnun nchka kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Wa ynan ba ska chaꞌ nu ykwiꞌ yu kiꞌyu re ―ndukwin ska neꞌ kwiñi kanꞌ―. Nde lka chaꞌ nu ykwiꞌ yu: “Kuꞌni tyiǐn ꞌin laa tnun re nu ngwiñan nten chalyuu ti. Chunꞌ snan tsan ti kuꞌniǐn chaꞌ tyaꞌ xka nu ja kwiñan nten chalyuu.” ");
INSERT INTO ctpNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Loꞌo ja suꞌwa ykwiꞌ neꞌ kwiñi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kanꞌ mdyituun sti joꞌo nu lka ndloo la tloo nchga neꞌ nu tnun nchka, mnichaꞌ yu ꞌin Jesús: ―¿Ta ja ndiya chaꞌ nu chkwiiꞌ loꞌo ba chaꞌ kulo luwi ꞌiin, ꞌin kiꞌya nu mstya neꞌ ꞌiin a? ―ndukwin sti joꞌo kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tiin ti mduun Jesús, ja ska chaꞌ siyaꞌ ti mxkwen yu ꞌin neꞌ. Kanꞌ chaꞌ xiyaꞌ mnichaꞌ sti joꞌo nu lka ndloo la ꞌin yu bra kanꞌ: ―¿Ta chañi chaꞌ Krixtu lkaa a? ―ndukwin―. ¿Ta ska ti nuꞌwin lkaa Sñiꞌ Ndiose nu ngiꞌni tnuan ꞌin a? ―ndukwin sti joꞌo kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","―Chañi chaꞌ nu ykwiꞌ wan, naꞌ lkaǎn nu kanꞌ ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Kwiꞌ ngwañaꞌan, nde loo la ñaꞌan wan ꞌñaǎn nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten; ñaꞌan wan ꞌñaǎn seꞌen tyukwaǎn laꞌa seꞌen kwin ꞌin Ndiose Stiǐn. Nchga tñan siyaꞌ ti nchka ꞌin Ndiose kuꞌni Ni. Loꞌo ñaꞌan wan ꞌñaǎn bra nu kaǎn xiyaꞌ laja koo nde niꞌ kwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Msinꞌ ꞌa tiꞌ sti joꞌo nu lka ndloo la bra kanꞌ, kanꞌ chaꞌ msaaꞌ steꞌ yu tloo neꞌ kanꞌ. ―Ja ndiꞌin chaꞌ xtya la xka nten kiꞌya ꞌin yu kiꞌyu re ―ndukwin sti joꞌo kanꞌ ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nan wa ynan wan chaꞌ tnun ꞌa chaꞌ kuxi nu ykwiꞌ yu re ꞌin Ndiose, bra nu ndukwin yu chaꞌ ska ti nu lka Sñiꞌ Ndiose lka yu. ¿Ni sa ñaꞌan chkwiꞌ wan ꞌin chaꞌ kanꞌ a? Nchga nten kanꞌ mxkwen neꞌ ꞌin nu lka ndloo la kanꞌ, chaꞌ ndiꞌin chaꞌ kaja Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Bra kanꞌ mdyisnan neꞌ ngiꞌni tiꞌí neꞌ ꞌin Jesús; msuꞌwa neꞌ tyiꞌa nu mdoꞌo tuꞌwa neꞌ kiloo yu, kwiꞌ ngwañaꞌan mjiꞌin neꞌ ꞌin yu xa nu nchkunꞌ kiloo yu loꞌo ska teꞌ. ―Loꞌo ni, chaꞌ kii tiꞌ nuꞌwin, ¡katsaaꞌ ꞌwa ti ka nu lka mjiꞌin ꞌiin! ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. Loꞌo neꞌ nu nduun kwan kanꞌ, mjiꞌin neꞌ ndukunꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ti ndukwa Tyu tuꞌ naꞌan tyi xꞌnan sti joꞌo, loꞌo mdiyan ska nu kunaꞌan nu ngiꞌni tñan ꞌin sti joꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Naꞌan nu kunaꞌan kanꞌ ꞌin Tyu seꞌen ndukwa yu tuꞌwa kiiꞌ, kanꞌ mxinaꞌan suꞌwe ꞌin yu xiyaꞌ. ―Loꞌo nuꞌwin ndaꞌan loꞌoo Jesús Nazaret kanꞌ ―ndukwin nu kunaꞌan kanꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","―Siꞌi naꞌ ―ndukwin Tyu―. Ja nsuꞌwi lyoǔn ꞌin yu. Ja nchka biyaꞌ tiǎnꞌ ni chaꞌ lka nchkwiiꞌ loꞌoǔn ―ndukwin Tyu ꞌin nu kunaꞌan kanꞌ. Bra kanꞌ mdoꞌo Tyu ndyaa tuꞌwa loꞌoo ti. Msiꞌya la kweꞌe bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naꞌan nu kunaꞌan kanꞌ ꞌin yu xiyaꞌ, kanꞌ chaꞌ mdyisnan nchkwiꞌ loꞌo neꞌ nu nduun kwiꞌ seꞌen ti: ―Loꞌo yu kiꞌyu kwa lka taꞌa ndaꞌan neꞌ kanꞌ ―ndukwin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Xiyaꞌ ykwiꞌ Tyu chaꞌ ja loꞌo yu ndaꞌan yu loꞌo Jesús. Chunꞌ ndiꞌin la chinꞌ ykwiꞌ nten nu nduun kwiꞌ seꞌen ti loꞌo Tyu: ―Chañi chaꞌ taꞌa ndaꞌan neꞌ kanꞌ lkaa ―ndukwin neꞌ―, chaꞌ loꞌoo lkaa neꞌ Galilea ―ndukwin neꞌ ꞌin Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bra kanꞌ mdyisnan Tyu nchkwiꞌ lye yu chaꞌ ta Ndiose nu tiꞌí ꞌin yu si chaꞌ kwiñi chkwiꞌ yu loꞌo neꞌ. ―Ja nsuꞌwi lyoǔn ꞌin yu kiꞌyu kwa nu nchkwiꞌ ꞌa wan chaꞌ ꞌin ―ndukwin Tyu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Bra ti msiꞌya la kweꞌe xiyaꞌ. Bra kanꞌ nsuꞌwi tiꞌ Tyu sa ñaꞌan chaꞌ nu wa ykwiꞌ Jesús loꞌo yu nu ngwa tsan: “Nde lka tñan nu kuꞌnii ndiꞌa, Tyu; snan yaꞌ chkwiiꞌ loꞌo nten chaꞌ ja nsuꞌwi lyoo ꞌñaǎn, xa nu ti ji xiꞌya la kweꞌe tukwa yaꞌ.” Kanꞌ chaꞌ nganan ꞌa Tyu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Xa nu ngwiꞌya xaa xka tsan, mdyoꞌ tiꞌin sti joꞌo nu lka ndloo, loꞌo neꞌ kula, loꞌo mstru nu nduꞌu chaꞌ joꞌo, mdiꞌin nchga neꞌ wsiya chaꞌ chkwiꞌ neꞌ loꞌo taꞌa neꞌ. Bra kanꞌ mskanꞌ neꞌ kanꞌ ꞌin Jesús, ndyaa loꞌo neꞌ ꞌin yu tloo Pilato nu ngwa gobernador romano chaꞌ ka biyaꞌ ꞌin yu. Mnichaꞌ Pilato ꞌin Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","―¿Ta nuꞌwin lkaa ree ꞌin neꞌ judío a? ― ―Kwiꞌ sa ñaꞌan nu ndukwiin, ti kwiǐnꞌ lkaǎn ―ndukwin Jesús ꞌin gobernador kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Kanꞌ mstya sti joꞌo nu lka ndloo kaꞌan kiꞌya ꞌin Jesús tloo Pilato kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Loꞌo xiyaꞌ ykwiꞌ Pilato loꞌo Jesús bra kanꞌ: ―¿Ja nchka ꞌiin xkween ꞌin neꞌ kwa a? ―ndukwin Pilato ꞌin yu―. Nan wa kaꞌan kiꞌya mstya neꞌ ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ja ykwiꞌ Jesús loꞌo neꞌ siyaꞌ ti. Yuwe ꞌa tiꞌ Pilato bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nchga yijan xa nu ndiya tsan taꞌa kanꞌ, ndlaa nu lka gobernador ska ti presu, sa ñaꞌan presu nu jñan neꞌ judío ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Loꞌo nsuꞌwi tyun nten niꞌ ñaꞌan chkwan yijan kanꞌ, neꞌ nu wa yjwi ꞌin neꞌ romano, neꞌ xka laꞌa tsuꞌ nu ngwa ndloo kanꞌ bra nu msuun neꞌ loꞌo. Ska presu kanꞌ lka Barrabás. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bra kanꞌ mdyoꞌ tiꞌin kaꞌan nten tloo Pilato, mjñan neꞌ ꞌin yu chaꞌ kulaa yu ꞌin ska presu sa ñaꞌan nu ngiꞌni yu nchga yijan. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","―¿Ta nchka tiꞌ wan chaꞌ kulaǎn ꞌin yu re nu lka ree ꞌwan, neꞌ judío a? ―mnichaꞌ Pilato ꞌin nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ykwiꞌ Pilato ngwañaꞌan chunꞌ mgii tiꞌ yu chaꞌ tiꞌí tiꞌ sti joꞌo nu lka ndloo ꞌin Jesús, kanꞌ chaꞌ mdiyan loꞌo neꞌ ꞌin Jesús tloo yu chaꞌ lka yu gobernador. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mjñan nten kaꞌan ꞌin Pilato chaꞌ kulaa yu ꞌin Barrabás, siꞌi ꞌin Jesús. Nan wa ykwiꞌ nten kaꞌan kanꞌ loꞌo Pilato chaꞌ kulaa ꞌin Barrabás, chunꞌ mdatsaa sti joꞌo nu lka ndloo ꞌin nten chaꞌ ngwañaꞌan jñan neꞌ chaꞌ ꞌin Pilato. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Xiyaꞌ mnichaꞌ Pilato ꞌin neꞌ bra kanꞌ: ―¿Ni sa ñaꞌan kuꞌniǐn loꞌo yu re, nu ykwiꞌ wan chaꞌ lka yu ree ꞌin neꞌ judío sikwa a? ―ndukwin Pilato ꞌin nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kwen msiꞌya loꞌo neꞌ ꞌin Pilato bra kanꞌ: ―¡Kujwi lya wan ꞌin yu kwa lo wsi! ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","―¿Ni chaꞌ nchka tiꞌ wan chaꞌ kujwiǐn ꞌin yu re? ―ndukwin Pilato ꞌin neꞌ―. ¿Ni ñaꞌan kiꞌya ndiꞌin ꞌin yu a? Lye la msiꞌya loꞌo neꞌ ꞌin Pilato bra kanꞌ: ―¡Kujwi lya wan ꞌin yu kwa lo wsi! ");
INSERT INTO ctpNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Kanꞌ chaꞌ ngulaa Pilato ꞌin Barrabás chaꞌ kiꞌya tlaꞌ chinꞌ tiye nten kaꞌan kanꞌ. Xa nu lye mjiꞌin sndaru ꞌin Jesús loꞌo ti su, bra kanꞌ ngulo Pilato tñan ꞌin sndaru chaꞌ tyaa loꞌo neꞌ ꞌin Jesús chaꞌ jwiꞌin kaꞌan neꞌ ꞌin yu lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Loꞌo ndyaa loꞌo sndaru ꞌin Jesús niꞌ ñaꞌan seꞌen ndukwa nten nu lka gobernador, mdyoꞌ tiꞌin nchga sndaru nu ndiꞌin nde kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kanꞌ mxkuꞌ neꞌ ska teꞌ kwaa ꞌin Jesús. Mxkii neꞌ lti kicheꞌ chunꞌ taꞌa chaꞌ ka ska sneꞌ, mstya neꞌ sneꞌ kicheꞌ kanꞌ ke Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Kwiꞌ yꞌni tnun neꞌ ꞌin yu chaꞌ kwiñi ti bra kanꞌ: ―¡Suꞌwe ti tyiꞌiin, nuꞌwin nu lkaa ree ꞌin neꞌ judío! ―ndukwin sndaru ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Loꞌo mdyisnan neꞌ mjiꞌin neꞌ yka ti ke Jesús bra kanꞌ. Lye msuꞌwa neꞌ tyiꞌa nu ndoꞌo tuꞌwa neꞌ loo yu. Kwiꞌ mduun xtyinꞌ neꞌ tloo yu, sa ñaꞌan si kuꞌni tnun neꞌ ꞌin yu, ni siya chaꞌ kwiñi ti. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Xa wa mdyii mstyi lyoꞌo sndaru ꞌin Jesús, ngulo neꞌ teꞌ kwaa kanꞌ ꞌin yu bra kanꞌ; xiyaꞌ mxkuꞌ neꞌ steꞌ yu bra kanꞌ, chaꞌ tsaa loꞌo neꞌ ꞌin yu seꞌen xtya neꞌ ꞌin yu lo wsi. Mdoꞌo neꞌ ndyaa loꞌo neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tuwiin seꞌen mdaꞌan neꞌ, bra kanꞌ mdukwa taꞌa sndaru ꞌin Simón, neꞌ Cirene; sti Alejandro loꞌo Rufo lka Simón kanꞌ. Ndyaan Simón yaa yu tñan niꞌ kixinꞌ, loꞌo ngulo sndaru tñan ꞌin yu chaꞌ kiꞌya yu wsi kanꞌ chaꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ndyaa loꞌo neꞌ ꞌin Jesús nde seꞌen nu naan Gólgota bra kanꞌ. Kiꞌya seꞌen ndiya tijyan ke ayman, ngwañaꞌan ndyoꞌo Gólgota chaꞌtñan. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nde kwa mda neꞌ mñun mxtiyaꞌ loꞌo mirra nu lka ska rmiyu yka chaꞌ koꞌo Jesús bra kanꞌ, loꞌo ja mslyaa yu koꞌo yu mñun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Bra kanꞌ mjiꞌin kaꞌan neꞌ ꞌin yu lo wsi, loꞌo kanꞌ mdiꞌin jya sndaru loꞌo taꞌa neꞌ, yꞌni neꞌ kanan loꞌo taꞌa neꞌ ti ka nu ka kaja steꞌ Jesús. Ngwañaꞌan ngwa chaꞌ mdyii mtsaa neꞌ steꞌ Jesús loꞌo taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ngwa bra wa kaa tlya mstya sndaru ꞌin Jesús lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ke wsi kanꞌ wa mdiya letra nu ytsaꞌ ni ñaꞌan kiꞌya mstya neꞌ ꞌin Jesús: “Nu nde lka ree ꞌin neꞌ judío” ndukwin letra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ti kwiꞌ tsan kanꞌ, mjiꞌin kaꞌan neꞌ ꞌin tukwa nten nu yꞌni kunan lo wsi kwiꞌ seꞌen ti loꞌo Jesús. Wsi ꞌin ska yu kunan, kanꞌ mduun laꞌa seꞌen kwin ꞌin Jesús, wsi ꞌin xka yu mduun laꞌa seꞌen kaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Sa ñaꞌan lka chaꞌ nu ngwaꞌan ayman sꞌni lo kityi ꞌin Ndiose, ngwañaꞌan ngwa: “Chkwiꞌ neꞌ chaꞌ lka yu taꞌa nten xaꞌan.” Ngwañaꞌan lka chaꞌ ndukwa lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mstyi lyoꞌo ꞌa neꞌ ꞌin Jesús xa nu mdijin neꞌ tuwiin, lye mxichaꞌ neꞌ ꞌin yu. ―¡Jaan! Nuꞌwin lkaa nu ykwiiꞌ chaꞌ kuꞌni tyii laa tnun kwa ―ndukwin neꞌ kanꞌ―, loꞌo ndukwiin chaꞌ kwiñaan ꞌin ran xiyaꞌ chunꞌ snan tsan ti, ¿mskeꞌ tiiꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kulaa ꞌiin, ti ykwiiꞌ ti sikwa; kiꞌyaa lyaa lo wsi kwa ni, si ka ꞌiin ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Loꞌo sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo, mstyi lyoꞌo neꞌ ꞌin Jesús. ―Ngulaa yu ꞌin xka ta nten ―ndukwin neꞌ nu tnun nchka kanꞌ ꞌin taꞌa neꞌ―, loꞌo ja nchka ꞌin yu kulaa ꞌin yu, ti ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Krixtu lka yu, ree ꞌin neꞌ Israel taꞌaan lka yu, ndukwin yu. Suꞌwe la si kiꞌya yu lo wsi, ti ykwiꞌ ti yu. Ñaꞌan kwiꞌyaan si ka ꞌin yu bra kanꞌ. Tsaa ñaꞌan tianꞌ ꞌin yu bra kanꞌ ―ndukwin neꞌ ꞌin taꞌa neꞌ. Kwiꞌ ngwañaꞌan yu kunan taꞌa ngaꞌan yu lo wsi, loꞌo neꞌ kanꞌ ykwiꞌ neꞌ chaꞌ kuxi ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Xa nu ndiꞌya kwan ngwa tla xaa ñaꞌaan chalyuu. Snan bra mdaloo chaꞌ tla xaa. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Loꞌo bra wa snan siin, bra kanꞌ kwen msiꞌya Jesús: ―Eloi, Eloi, ¿lama sabactani? ―ndukwin. Nde ñaꞌan ndyoꞌo chaꞌ kanꞌ chaꞌtñan: Ndiose ꞌñaǎn, Ndiose ꞌñaǎn, ¿ni chaꞌ ngulaa yaaꞌ ꞌñaǎn? ");
INSERT INTO ctpNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ynan chinꞌ nten nu nduun kwiꞌ seꞌen ti, loꞌo ja ngwa biyaꞌ tiꞌ neꞌ ni chaꞌ ngwa nu ykwiꞌ yu: ―Kunan suꞌwe wan, wa msiꞌya yu ꞌin ayman Elías ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kanꞌ msnan ska nten ndyaa ꞌya yu ska kiche; mchaꞌ yu ꞌin kiche kanꞌ loꞌo mñun tiyeꞌ bra kanꞌ, mskwen yu ꞌin ran kijin tuꞌwa Jesús loꞌo ska yka ti chaꞌ koꞌo Jesús, ngwa tiꞌ yu. ―Kataan chinꞌ ―ndukwin nten kanꞌ―, ñaꞌaan si kan ayman Elías chaꞌ tiꞌya ꞌin Jesús re lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Loꞌo kwen msiꞌya Jesús, ngujwi bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Bra ti mdaaꞌ teꞌ tnun nu ndukwi loo joꞌo niꞌ lyaa tnun kanꞌ. Nde kwan mdyisnan mdaaꞌ teꞌ kanꞌ sa ñaꞌan yaꞌ mdaaꞌ ran la lyuu. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Loꞌo capitán romano nu ngwa ndloo ꞌin sndaru nu nduun seꞌen ngaꞌan Jesús, wa naꞌan capitán kanꞌ sa ñaꞌan yꞌni Jesús bra nu ngujwi yu. ―Chañi chaꞌ Sñiꞌ Ndiose nu lka ndloo la ti lka ayman re ―ndukwin capitán kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","La kanꞌ tijyuꞌ ti mduun ska ta neꞌ kunaꞌan, ñaꞌan kwiꞌya neꞌ ꞌin Jesús; loꞌo Liya Magdalena, loꞌo xka Liya nu ngwa jyaꞌan Santiago nu kuneꞌ la, kwiꞌ jyaꞌan Se, loꞌo Salomé ndiꞌin nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Xa nu ti mdaꞌan Jesús nde Galilea, ti kwiꞌ taꞌa neꞌ kunaꞌan kanꞌ mdaꞌan loꞌo yu, mdayaꞌ neꞌ ꞌin yu. Kwiꞌ ngwañaꞌan, mdiꞌin tyun la neꞌ kunaꞌan nde kwa loꞌo neꞌ kanꞌ, neꞌ kunaꞌan nu taꞌa mdaꞌan Jesús mdiyan neꞌ kichen Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wa kiꞌya ti tla, ti kwiꞌ tsan taꞌa siin ngwa kanꞌ, loꞌo la xka tsan ka tsan nu xitñaꞌ neꞌ judío. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mdiya ska neꞌ wsiya nu naan Se, neꞌ kichen Arimatea ngwa yu kanꞌ, ska neꞌ kula nu tnun nchka ngwa yu. Loꞌo Se ndyaa ñaꞌan ꞌa tiꞌ yu chaꞌ wa tiya ti tsan chaꞌ ka Ndiose ndloo la; kanꞌ chaꞌ yꞌni ngula tiye yu, ndyaa yu tloo Pilato mjñan yu chabiyaꞌ kutsiꞌ yu ꞌin ayman Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yuwe ꞌa tiꞌ Pilato si chañi chaꞌ ngujwi Jesús ndla ti. Kanꞌ chaꞌ msiꞌya Pilato ꞌin capitán ꞌin sndaru nu nduun kwan kiyaꞌ wsi chaꞌ kan capitán kanꞌ tloo yu, chaꞌ katsaꞌ ñi ꞌin yu si chañi chaꞌ ngujwi Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Loꞌo ytsaꞌ capitán kanꞌ ꞌin Pilato chaꞌ chañi ngujwi ayman kanꞌ; kanꞌ chaꞌ mda Pilato chabiyaꞌ ꞌin Se chaꞌ tsaa loꞌo yu ꞌin ayman kanꞌ, chaꞌ katsiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Bra ti ngwiꞌya Se ska teꞌ suꞌwe ꞌa ñaꞌan; mdiꞌya yu kula ꞌin ayman kanꞌ, mxiin yu teꞌ kwi chunꞌ ayman. Bra kanꞌ ndyaa loꞌo yu ꞌin ayman ska tukee nu wa ngulu yu siꞌ yuu, mtsiꞌ yu ꞌin ayman Jesús niꞌ tukee kanꞌ. Bra kanꞌ mxlyuu yu ska kee tnun tuꞌwa tukee kanꞌ, tsaa mchkunꞌ neꞌ tuꞌwa kee kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Loꞌo Liya Magdalena, loꞌo Liya jyaꞌan Se, naꞌan neꞌ seꞌen mtsiꞌ yu ꞌin ayman Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Bra wa mdyii tsan nu nxitñaꞌ neꞌ judío, loꞌo Liya Magdalena loꞌo Liya jyaꞌan, Santiago loꞌo Salomé, ndyaa neꞌ msiꞌi neꞌ sete xi tyiꞌi. Kanꞌ ndyaa loꞌo neꞌ ꞌin sete kanꞌ, chaꞌ taꞌan ran ñaꞌaan chunꞌ ayman Jesús, ngwa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wa ngwiꞌya xaa xka tsan bra kanꞌ, tsan kulo ꞌin smnan. Bra nu ndyoꞌo tukwa kwichaa, bra ti mdoꞌo neꞌ kunaꞌan kanꞌ ndyaa neꞌ seꞌen nsu ayman Jesús tukee kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Laja nu mdaꞌan neꞌ tuwiin ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―¿Ti ka nu ka tayaꞌ ꞌñaan chaꞌ kulo tsuanꞌ kee tnun nu nchkunꞌ tuꞌwa tukee kanꞌ a? ―ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bra wa mdiyan neꞌ kwiꞌ seꞌen ti, naꞌan neꞌ tukee kanꞌ, chaꞌ wa mdoꞌo tsuꞌ kee tnun nu nchkunꞌ tuꞌwa tukee bra kanꞌ; ndukwa laa tuꞌwa tukee kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yten neꞌ niꞌ tukee, naꞌan neꞌ ska yu kiꞌyu kuneꞌ, mskeꞌ tiꞌ neꞌ; ngaten ꞌa teꞌ tyukwin nu nchkuꞌ yu kiꞌyu kanꞌ, ndukwa laꞌa seꞌen kwin seꞌen ysu ayman kanꞌ nu ngwa xkanꞌ. Yuwe ꞌa tiꞌ neꞌ kunaꞌan kanꞌ ñaꞌan neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","―Ja kutsen wan ―ndukwin yu kiꞌyu kanꞌ ꞌin neꞌ kunaꞌan kanꞌ―. Wa jlyo tiǎnꞌ chaꞌ ndaꞌan naan wan ꞌin Jesús Nazaret nu yjwi neꞌ lo wsi. Ja nsu ayman kanꞌ nde re, chaꞌ wa ndyuꞌu yu kanꞌ xiyaꞌ. Kan wan nde re, ñaꞌan wan chinꞌ seꞌen mstya neꞌ ꞌin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Bra kanꞌ yaa lya wan katsaꞌ wan chaꞌ re ꞌin Tyu loꞌo ꞌin ñaꞌaan ta neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: “Wa tsaa ti yu, ti ykwiꞌ ti yu, nde Galilea nde loo la ꞌwan; nde kwa tyukwa taꞌa wan ꞌin yu, sa ñaꞌan nu wa ndukwin yu ꞌwan nu ngwa xkanꞌ”. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Bra kanꞌ mdoꞌo neꞌ tukee msnan neꞌ ndyaa neꞌ. Lye ꞌa mchkwan neꞌ, chaꞌ ytsen ꞌa neꞌ. Ja ykwiꞌ ꞌa neꞌ loꞌo xka nten tuwiin chaꞌ ytsen ꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ti kwiꞌ tsan kulo ꞌin smnan ngwa, kanꞌ nu ndyuꞌu Jesús xiyaꞌ. Kulo mdoꞌo tukwa yu tloo Liya Magdalena. Ti sꞌni la yꞌni yu joꞌó ꞌin Liya kanꞌ, bra nu ngulo yu kati kwiꞌin kuxi nu msñi ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Bra nu naꞌan Liya ꞌin Jesús, bra ti mdoꞌo nu kunaꞌan kanꞌ ndyaan seꞌen ndiꞌin taꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ katsaꞌ ꞌin neꞌ nchga chaꞌ nu ngwa. Nganan ti neꞌ ndiꞌin neꞌ, chaꞌ xiꞌin ꞌa tiꞌ neꞌ chunꞌ ngujwi Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja ynan neꞌ chaꞌ nu ykwiꞌ Liya loꞌo neꞌ, chaꞌ ja yaa ñaꞌan tiꞌ neꞌ siyaꞌ ti chaꞌ wa naꞌan Liya ꞌin Jesús luꞌu. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chunꞌ ndiꞌin la chinꞌ, kanꞌ mdoꞌo tukwa Jesús xiyaꞌ, ngwaꞌu tloo yu ꞌin tukwa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Tuwiin seꞌen ndyaꞌan neꞌ niꞌ kixinꞌ, la kanꞌ ngwaꞌu tloo ykwiꞌ Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bra ti ndyaan neꞌ lo kichen, ytsaꞌ neꞌ chaꞌ kanꞌ ꞌin taꞌa ndaꞌan neꞌ; loꞌo ja ynan neꞌ chaꞌ nu ykwiꞌ tukwa nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nu ngwa msiin la chinꞌ, kanꞌ mdoꞌo tukwa Jesús seꞌen ndiꞌin tii xka nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu laja nu mdukwa neꞌ nchku neꞌ tuꞌwa msaa. Lye ykwiꞌ yu loꞌo neꞌ kanꞌ, ni chaꞌ lka ja ndyaa ñaꞌan suꞌwe tiꞌ neꞌ ꞌin yu, ni chaꞌ lka nchkunꞌ ke neꞌ. Loꞌo ykwiꞌ yu loꞌo neꞌ ni chaꞌ lka ja ynan neꞌ chaꞌ nu ykwiꞌ taꞌa tyukwaa neꞌ kanꞌ, bra nu ytsaꞌ neꞌ ꞌin neꞌ chaꞌ wa naꞌan neꞌ ꞌin yu kulo ndukwa bra nu tka ndyuꞌu ti yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","―Tsaa wan tyukwi ñaꞌaan lo chalyuu ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Katsaꞌ wan chaꞌ ꞌñaǎn ꞌin nchga nten. Chkwiꞌ wan loꞌo nten chaꞌ wa yꞌniǐn tñan lo wsi chaꞌ ka lyaa neꞌ ꞌin nchga chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xa nu sten nten chaꞌ ꞌñaǎn, tyukwatya neꞌ chabiyaꞌ ꞌñaǎn bra kanꞌ, tyoꞌo laa neꞌ kanꞌ ꞌin chaꞌ kuxi bra kanꞌ. Nten nu ja xlyaa sten chaꞌ ꞌñaǎn siyaꞌ ti, kanun kiꞌya ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nten nu sten chaꞌ ꞌñaǎn, kuꞌni neꞌ kanꞌ chaꞌ tnun chabiyaꞌ ꞌñaǎn, chaꞌ kuwe ꞌa tiꞌ xka la nten: kulo neꞌ kanꞌ ꞌin kwiꞌin kuxi nu msñi ꞌin nten; ka chkwiꞌ neꞌ kanꞌ chaꞌ nu nchkwiꞌ neꞌ xka kichen tijyuꞌ chabiyaꞌ ꞌñaǎn; ");
INSERT INTO ctpNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","xñi neꞌ kanꞌ ꞌin kunan tlá; si koꞌo neꞌ yan, ja ska chaꞌ kuxi ka ꞌin neꞌ kanꞌ bra kanꞌ; loꞌo ka xtya yaꞌ neꞌ kanꞌ chunꞌ nu tiꞌí kanꞌ, chaꞌ chkaa neꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bra wa mdyii ykwiꞌ Jesús nu lka Xꞌnaan, bra kanꞌ yꞌni Ndiose chaꞌ mchkwen yu ndyaa yu nde niꞌ kwan; ndyaa tukwa Jesús laꞌa seꞌen kwin ꞌin Ndiose la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Loꞌo mdoꞌo neꞌ nu wa yꞌni xaꞌan chaꞌ ꞌin Jesús ndyaa neꞌ bra kanꞌ, nchga kichen ykwiꞌ neꞌ chaꞌ ꞌin Ni loꞌo nten. Lye ꞌa mdayaꞌ Xꞌnaan ꞌin neꞌ, chaꞌ ngwa biyaꞌ suꞌwe tiꞌ nten nchga kichen seꞌen ndyaa neꞌ kanꞌ, chaꞌ chañi ꞌa chaꞌ ꞌin Ndiose nu ngwaꞌu neꞌ; ngwa biyaꞌ tiꞌ nten kichen kanꞌ xa nu naꞌan neꞌ chaꞌ tnun nu yꞌni neꞌ kanꞌ chabiyaꞌ ꞌin Ndiose. Ngwañaꞌan ka chaꞌ.");
INSERT INTO ctpNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wa kaꞌan nten ngwaꞌan lo kityi sa ñaꞌan nu ngwa nchga chaꞌ ꞌin Jesús nde seꞌen ndiꞌin ba, kityi historia lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Wa mdiya neꞌ nu ngwaꞌu chaꞌ kanꞌ ꞌñaan. Neꞌ kanꞌ, wa naꞌan neꞌ chaꞌ kanꞌ ti kulo, ti bra mdyisnan Jesús yꞌni yu tñan; loꞌo kanꞌ yaa neꞌ ykwiꞌ neꞌ chaꞌ ꞌin Jesús loꞌo nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kanꞌ chaꞌ loꞌo naꞌ, ndaꞌan naǎn ꞌaǎn sa ñaꞌan ngwa nchga chaꞌ nu mdijin ti bra mdyisnan chaꞌ kanꞌ. Suꞌwe nxkeꞌ tiǎnꞌ si loꞌo naꞌ kwaꞌaǎn nchga chaꞌ kanꞌ lo kityi, chaꞌ tsaa seꞌen ndiꞌin nuꞌwin, yu kula Teófilo, ");
INSERT INTO ctpNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chaꞌ ka biyaꞌ suꞌwe la tiiꞌ nchga chaꞌ nu ykwiꞌ neꞌ loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Bra nu ngwa ree Herodes tñan, chaꞌ lka yu ndloo ꞌin neꞌ Judea, bra kanꞌ mdiꞌin ska sti joꞌo nu naan Zacarías. Mdiꞌin Zacarías loꞌo ska ta sti joꞌo nu nduun tñan seꞌen mduun ayman Abías nu ngwa sꞌni. Elisabet naan kwilyoꞌo Zacarías, lka ti kwiꞌ nten taꞌa ayman Aarón nu ngwa sti joꞌo ti kulo la. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ñi ꞌa ngiꞌni taꞌa tyukwaa neꞌ kanꞌ chaꞌ ꞌin Ndiose, ndukwa neꞌ nchga tñan ꞌin Ndiose, ndukwa ꞌa neꞌ nchga chaꞌ nu wa ykwiꞌ Ndiose loꞌo nten nu ngwa sꞌni. Ja tukwin nchkwiꞌ chaꞌ kuxi ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ska ti chaꞌ ndiꞌin ꞌin neꞌ, ja ska sñiꞌ neꞌ nsuꞌwi. Ja mjwi sñiꞌ neꞌ kula Sabe, loꞌo ni, kula ꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wa mdiya smnan ꞌin ska ta sti joꞌo seꞌen ndiꞌin Zacarías, chaꞌ kuꞌni neꞌ tñan niꞌ lyaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nde ñaꞌan yꞌni sti joꞌo nu ngwa bra kanꞌ: nchga ta sti joꞌo kanꞌ ngulo suwi neꞌ ska taꞌa neꞌ, chaꞌ ska ti yu ka sten yu seꞌen kti la niꞌ lyaa tnun, chaꞌ tikin yu ynan lo msaa la kanꞌ bra kanꞌ. Loꞌo ni, nganun tñan kanꞌ ꞌin ykwiꞌ Zacarías. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Bra nu nchkin ynan kanꞌ niꞌ lyaa, bra kanꞌ ndyoꞌ tiꞌin neꞌ kichen nde liyaꞌ, nchkwiꞌ tꞌnan neꞌ loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Bra kanꞌ mdoꞌo tukwa angajle ꞌin ykwiꞌ nu lka Xꞌnaan tloo Zacarías niꞌ lyaa, naꞌan yu chaꞌ nduun angajle kanꞌ laꞌa seꞌen kwin, seꞌen ndukwa msaa kti ti, seꞌen nchkin ynan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Bra nu naꞌan Zacarías angajle kanꞌ, ja jlyo ꞌa tiꞌ yu sa ñaꞌan kuꞌni yu, chaꞌ ytsen ꞌa yu ꞌin angajle kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ykwiꞌ angajle kanꞌ loꞌo yu bra kanꞌ: ―Ja kutseen, Zacarías ―ndukwin―. Wa ynan Ndiose chaꞌ nu tꞌnan ꞌa nchkwiiꞌ loꞌo, kanꞌ chaꞌ kala ska sñiꞌ Sabe nu lka kwilyoꞌoo. Xuwa ka naan yu, ngwañaꞌan xtya wan nin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Suꞌwe ꞌa ka tiyee bra nu wa ngula kuwiꞌ kanꞌ. Kwiꞌ ngwañaꞌan, ka suꞌwe ꞌa ka tiye kaꞌan ꞌa nten bra nu ñaꞌan neꞌ kuwiꞌ kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","chaꞌ nu kanꞌ ka ska nten nu tnun nchka tloo Ndiose. Ja koꞌo Xuwa kanꞌ xalyu, ja ska loo xalyu koꞌo yu. Ti bra nu kala yu, bra kanꞌ kanun Tyiꞌi Ndiose niꞌ kasiya ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kuꞌni yu chaꞌ xiyaꞌ ka suꞌwe kasiya ꞌin kaꞌan ꞌa neꞌ Israel, chaꞌ xiyaꞌ kunan neꞌ chaꞌ nu nchkwiꞌ Ndiose Xꞌnan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ti kwiꞌ tyiꞌi nu mdiꞌin niꞌ kasiya ꞌin ayman Elías nu yaa loꞌo Ndiose ꞌin nu ngwa sꞌni, ti kwiꞌ tyiꞌi kanꞌ kaja ꞌin Xuwa ni. Chunꞌ ndiꞌin la kan Xuwa chkwiꞌ loꞌo nten chaꞌ kiꞌya tlaꞌ tiye nten, chaꞌ ja xuun ꞌa neꞌ loꞌo sñiꞌ neꞌ. Bra kanꞌ ka xaꞌan nchga chaꞌ nu nsuꞌwi tiye neꞌ, chaꞌ tukwa neꞌ nchga chaꞌ nu ñi. Loꞌo chkwiꞌ Xuwa loꞌo neꞌ chaꞌ kuꞌni xuꞌwe neꞌ tiye neꞌ, chaꞌ xlyaa neꞌ sten neꞌ chaꞌ ꞌin Ndiose. Bra kanꞌ kan ykwiꞌ Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Kanꞌ mnichaꞌ Zacarías ꞌin angajle bra kanꞌ: ―¿Sa ñaꞌan ka chaꞌ ka biyaꞌ tiǎnꞌ si chañi ka chaꞌ kanꞌ a? Kulaǎn ꞌaǎn, loꞌo kula ꞌa kwilyoꞌoǔn ―ndukwin Zacarías ꞌin angajle kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","―Gabriel naǎn ―ndukwin angajle ꞌin yu bra kanꞌ―. Nduun tiǎn nde seꞌen ndiꞌin Ndiose; kanꞌ lka nu msuꞌwa ꞌñaǎn ndijyaǎn chaꞌ chkwiǐnꞌ loꞌoo, chaꞌ kitsaǎnꞌ chaꞌ suꞌwe re ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kunaan suꞌwe chaꞌ nu chkwiǐnꞌ loꞌoo ni: Ka kuꞌuun ni, chaꞌ ja ka ꞌa chkwiiꞌ sa ñaꞌan bra nu kala kuwiꞌ kanꞌ ꞌwan; ngwañaꞌan ka ꞌiin siꞌya chaꞌ ja ndyaa ñaꞌan tiiꞌ ꞌñaǎn. Bra nu tiya tsan kanꞌ, bra kanꞌ ka biyaꞌ tiiꞌ chaꞌ chañi lka nchga chaꞌ nu ykwiǐnꞌ loꞌoo ―ndukwin angajle kanꞌ ꞌin Zacarías. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ti ndiꞌin neꞌ kichen tuꞌwa laa, chaꞌ ngita neꞌ ꞌin Zacarías sa ñaꞌan bra nu tyoꞌo yu chunꞌ naꞌan; kaꞌan ꞌa chaꞌ ndaꞌan tiye neꞌ ni chaꞌ chan ꞌa yuꞌwi Zacarías niꞌ lyaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Chunꞌ ndiꞌin la, bra wa mdoꞌo Zacarías nde liyaꞌ, bra kanꞌ ja ngwa ꞌa chkwiꞌ yu loꞌo neꞌ. Mskeꞌ tiꞌ neꞌ chaꞌ niꞌ lyaa ngwaꞌu loo ska xaa tlyu ꞌin yu, nu mdoꞌo yan seꞌen ndiꞌin Ndiose. Bra kanꞌ seꞌen ti mduun yu ngiꞌni yaꞌ yu ꞌin neꞌ, chaꞌ nganun kuꞌun yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Bra wa mdyii tsan nu yꞌni Zacarías tñan niꞌ lyaa, bra kanꞌ mdoꞌo yu ndyaa yu kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chunꞌ ndiꞌin la bra kanꞌ, mgii tiꞌ neꞌ kula Sabe kwilyoꞌo yu, chaꞌ nsuꞌwi sñiꞌ. Bra kanꞌ wa mdaꞌa kiꞌyu koꞌ nu xkwiꞌ niꞌ ñaꞌan ti nganun neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Mdaꞌan ꞌa chaꞌ tiye neꞌ kula kanꞌ: “Ndiose nu lka Xꞌnaan yꞌni chaꞌ tnun re ꞌñaǎn. Wa yꞌni Ni chaꞌ ja chkwiꞌ ꞌa nten chaꞌ kuxi ꞌñaǎn” ndukwin neꞌ kula Sabe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wa nsuꞌwi skwa koꞌ ndaꞌan neꞌ kula Sabe tnan, bra kanꞌ ngulo Ndiose tñan ꞌin ska angajle, chaꞌ tsaa nde kichen Nazaret, ska kichen nde lo yuu ꞌin Galilea. Angajle kanꞌ ni, ti kwiꞌ Gabriel lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Msuꞌwa Ndiose ꞌin angajle kanꞌ chaꞌ tsaa seꞌen ndiꞌin ska nu kunaꞌan kuneꞌ nu ja ya tyiꞌin loꞌo nten. Nan wa mjñi chaꞌ ꞌin nu kunaꞌan kanꞌ, chaꞌ kaja kwilyoꞌo loꞌo ska yu kiꞌyu nu naan Se; David lka nin ke yu kiꞌyu kanꞌ, ska ti ñaꞌan nin yu loꞌo ayman David nu yuꞌwi nu ngwa sꞌni. Liya naan nu kunaꞌan kuneꞌ kanꞌ, ti kwiꞌ taꞌa neꞌ kula Sabe kanꞌ lka Liya. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Wa mdiya angajle seꞌen ndiꞌin nu kunaꞌan kanꞌ, ykwiꞌ loꞌo bra kanꞌ: ―Ndiya ska chaꞌ nu suꞌwe ꞌa nu ndijyaǎn chkwiǐnꞌ loꞌoo ―ndukwin angajle kanꞌ ꞌin Liya―. ¡Suꞌwe ꞌa nka tiye Ndiose loꞌo nuꞌwin! ¡Suꞌwe ꞌa ndiꞌiin loꞌo Ni! ―ndukwin―. Kaꞌan ꞌa chaꞌ suꞌwe nda Ndiose ꞌiin, ja ngiꞌni Ni ngwañaꞌan loꞌo xka la nu kunaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wa naꞌan Liya ꞌin angajle kanꞌ. Bra kanꞌ ynan Liya chaꞌ nu ykwiꞌ, loꞌo nduwe ꞌa tiꞌ ni chaꞌ lka nchkwiꞌ angajle kanꞌ ngwañaꞌan. Ytsen ꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Xiyaꞌ ykwiꞌ angajle kanꞌ loꞌo nu kunaꞌan kuneꞌ kanꞌ bra kanꞌ: ―Liya ―ndukwin―, ja kutseen chaꞌ wa nda Ndiose ska chaꞌ suꞌwe ꞌiin ―ndukwin angajle kanꞌ ꞌin Liya―. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kaa tnaan, tyiꞌin ska sñiiꞌ; nuꞌwin xtyaa nin Jesús ꞌin kuwiꞌ nu tyiꞌin ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Kanꞌ nu ka ska nten nu tnun nchka. Chkwiꞌ neꞌ ꞌin yu chaꞌ Sñiꞌ Ndiose nu lka Xꞌnaan nu tlyu la ti ka yu. Ti kwiꞌ taꞌa tñan tlyu nu yꞌni ayman ree David taꞌa yu, nu yan lo chalyuu nu ngwa sꞌni, kanꞌ tñan lka nu ta ykwiꞌ nu lka Xꞌnaan ꞌin Jesús, ");
INSERT INTO ctpNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chaꞌ nchga tsan ja tyii chaꞌ ka yu ndloo ꞌin nchga nten Israel; ngwañaꞌan ja tyii chaꞌ kulo yu tñan ꞌin nchga nten chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Bra kanꞌ ykwiꞌ Liya loꞌo angajle kanꞌ: ―¿Ni sa ñaꞌan ka chaꞌ re sikwa a?, chaꞌ nu ja ya kaja kwilyoꞌoǔn ―ndukwin Liya ꞌin angajle kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Bra kanꞌ ytsaꞌ angajle ska chaꞌ ꞌin Liya: ―Ta Ndiose Tyiꞌi ykwiꞌ Ni chaꞌ tiyan seꞌen ndiꞌiin, chaꞌ xuꞌwi tyukwi ñaꞌaan; ska chaꞌ tnun nu kuꞌni Ndiose nu lka ndloo la ti ka chaꞌ kanꞌ. Bra nu kala sñiiꞌ, ska nten nu luwi ꞌa chaꞌ ꞌin Ndiose ka kuwiꞌ nu kala kanꞌ, ti kwiꞌ kanꞌ lka nu ka naan ykwiꞌ Sñiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Loꞌo xka chaꞌ chkwiǐnꞌ loꞌoo ―ndukwin angajle ꞌin Liya―, chaꞌ loꞌo neꞌ kula Sabe taꞌaa tyiꞌin ska sñiꞌ, loꞌo kula ꞌa neꞌ kula kanꞌ. Ti ngwa sꞌni la nchkwiꞌ nten chaꞌ ja ndiji sñiꞌ neꞌ kula siyaꞌ ti, loꞌo ni wa mdaꞌa skwa koꞌ ndaꞌan tnan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ja ska chaꞌ nu tukwi ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Bra kanꞌ ykwiꞌ Liya loꞌo angajle kanꞌ: ―Si ndukwin Ndiose chaꞌ ngwañaꞌan kala sñiěnꞌ, wa lka chaꞌ bra kanꞌ. Suꞌwe ꞌa nka tiyeěn kuꞌniǐn tñan ꞌin Ni, nchga tñan nu kulo Ndiose Xꞌnaan ꞌñaǎn ―ndukwin Liya. Loꞌo mdoꞌo angajle kanꞌ, ndyaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Bra kanꞌ mdoꞌo Liya ndyaa ndla ti nde ska kichen nu ndiꞌin laja kiꞌya Judea. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Bra kanꞌ mdiya Liya seꞌen ndukwa naꞌan tyi Zacarías, mdyisnan ykwiꞌ loꞌo neꞌ kula Sabe. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Bra nu ynan neꞌ kula kanꞌ chaꞌ nu ykwiꞌ Liya loꞌo, bra ti mgii tiꞌ chaꞌ mñan chinꞌ kuwiꞌ. Bra kanꞌ msaꞌan tiye neꞌ kula Sabe nsuꞌwi Tyiꞌi Ndiose, ");
INSERT INTO ctpNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","kanꞌ chaꞌ kwen ꞌa ykwiꞌ loꞌo Liya bra kanꞌ: ―Tnun ꞌa chaꞌ suꞌwe nu nda Ndiose ꞌiin ―ndukwin neꞌ kula kanꞌ ꞌin Liya―. Ja ya kuꞌni Ni ngwañaꞌan loꞌo xka la nu kunaꞌan. Loꞌo ngwañaꞌan, nchka ꞌa tiꞌ Ndiose ꞌin kuwiꞌ nu ndiꞌin ꞌiin ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Wa mdiyan jyaꞌan nu ka Xꞌnaǎn seꞌen ndiꞌiǐn, loꞌo nten ya ñaꞌan ti lkaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Chañi chaꞌ nu nchkwiǐnꞌ loꞌoo, chaꞌ mgii tiǎnꞌ chaꞌ wa mñan chinꞌ kuwiꞌ ꞌñaǎn, chaꞌ suꞌwe ngwa tiye kuwiꞌ bra nu ynaǎn chaꞌ nu ykwiiꞌ loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Suꞌwe ꞌa nka tiyee chaꞌ wa ndyaa ñaꞌan tiiꞌ chaꞌ ꞌin Ndiose, chaꞌ kuꞌni Ni nchga chaꞌ nu wa ykwiꞌ Ni loꞌoo. Ngwañaꞌan ndukwin neꞌ kula Sabe ꞌin Liya. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Bra kanꞌ yꞌni tnun Liya ꞌin Ndiose: Tyukwi ti tiyeěn kuꞌni tnuǔn ꞌin Ndiose nu lka Xꞌnaǎn, ndukwin Liya. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chka suꞌwe kasiya ꞌñaǎn chunꞌ ndlaa Ni ꞌñaǎn ꞌin nu kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Wa yꞌni kuwe ꞌa tiꞌ Ndiose ꞌñaǎn, chaꞌ lkaǎn msu ꞌin Ni, ni siya ska nten tiꞌi lkaǎn. Ni wa mdyisnan nchkwiꞌ nchga nten nu ndijyan lo chalyuu chaꞌ suꞌwe ꞌa nka tiyeěn; kwiꞌ ngwañaꞌan chkwiꞌ nten nu kan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tlyu ꞌa tñan nu ngiꞌni Ndiose, loꞌo tnun ꞌa chaꞌ nu ngiꞌni Ni loꞌoǔn; luwi ꞌa Ndiose, ndukwin Liya. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ja kulaa yaꞌ Ndiose ꞌin nten nu tukwa chaꞌ nu nchkwiꞌ Ni; nchga bra nu ti ndijyan nten lo chalyuu, chañi chaꞌ nchka tꞌnan tiꞌ Ndiose ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kaꞌan ꞌa chaꞌ tnun wa yꞌni Ndiose. Wa yꞌni tyii Ni chaꞌ ꞌin nten nu xkwiꞌ chaꞌ siyeꞌ ngiꞌni loꞌo taꞌa nten neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Suꞌwa ti ngiꞌni Ndiose loꞌo nchga nten. Nchga nten nu tnun nchkwiꞌ, nu lye ꞌa ngiꞌni siyeꞌ loꞌo taꞌa nten neꞌ, kanꞌ ngulaa tiꞌin Ndiose ꞌin neꞌ. Loꞌo nchga nten nu ndiꞌin nganen, nu ja tukwin ꞌa ngiꞌni kwenta ꞌin, tyiꞌin Ndiose loꞌo neꞌ kanꞌ chaꞌ xtya Ni ꞌin neꞌ seꞌen nu suꞌwe la ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wa yꞌni Ndiose chaꞌ kiꞌya tlaꞌ tiye nten nu lyiji ꞌa chaꞌ suꞌwe ꞌin, loꞌo wa ngulo Ni tñan chaꞌ ja kaja la chaꞌ kuliyaꞌ ꞌin neꞌ nu kuliyaꞌ ꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ndayaꞌ ꞌa Ndiose ꞌin nchga neꞌ Israel taꞌaan, chaꞌ lkaan msu ꞌin Ndiose; loꞌo suꞌwe ꞌa mskanꞌ Ni chaꞌ loꞌo ayman ꞌñaan nu yuꞌwi ti sꞌni. Ja mjlyaa tiꞌ Ndiose ꞌñaan, nten taꞌa ayman Abraham lkaan; xkwiꞌ nchka tꞌnan tiꞌ Ni ꞌin neꞌ taꞌaan. Loꞌo ñaꞌan ti nchka tꞌnan tiꞌ Ni ꞌñaan loꞌo sñianꞌ tyukwi bra nde loo la. Ngwañaꞌan ngwa bra nu yꞌni tnun Liya ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Snan koꞌ nganun Liya naꞌan tyi neꞌ kula Sabe, bra kanꞌ mdoꞌo ndyaa kichen tyi. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wa mdiya tsan nu kala sñiꞌ neꞌ kula Sabe. Kiꞌyu kuwiꞌ nu ngula ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xa wa ynan neꞌ chaꞌ ngula sñiꞌ neꞌ kula kanꞌ, suꞌwe ꞌa ngwa tiye nchga neꞌ taꞌa, loꞌo neꞌ nu ndiꞌin kwiꞌ seꞌen ti. Bra kanꞌ mdiyan neꞌ seꞌen ndiꞌin neꞌ kula kanꞌ, chaꞌ chkwiꞌ neꞌ loꞌo, chaꞌ suꞌwe ꞌa ngwa tꞌnan tiꞌ nu lka Xꞌnaan ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","La mdaꞌa snuꞌ tsan, bra kanꞌ yaa neꞌ naꞌan tyi neꞌ kula Sabe chaꞌ lkwan kuwiꞌ kanꞌ chaꞌ ꞌin neꞌ judío, chaꞌ msiꞌyu kijin yu. Wa xtya ti neꞌ nin kuwiꞌ kanꞌ, chaꞌ ka naan Zacarías, sa ñaꞌan naan sti. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Loꞌo bra kanꞌ ja mda jyaꞌan kuwiꞌ kanꞌ chabiyaꞌ chaꞌ ka naan sñiꞌ ngwañaꞌan: ―Siꞌi ngwañaꞌan ka naan yu ―ndukwin neꞌ kula kanꞌ ꞌin neꞌ―, Xuwa ka naan yu re. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","―Ja ndiya taꞌa wan nu naan ngwañaꞌan ―ndukwin taꞌa neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yꞌni yaꞌ neꞌ ꞌin sti kuwiꞌ bra kanꞌ, chaꞌ ñaꞌan ti ja nchka ꞌa chkwiꞌ yu kula kanꞌ. Mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿Sa ñaꞌan ka naan kuwiꞌ re, nchka tiiꞌ a? ―ndukwin neꞌ ꞌin yu kula. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Bra kanꞌ mjñan yu kula ska kaꞌ lyuꞌ ti chaꞌ lo kaꞌ kanꞌ kwaꞌan yu letra. Nde ndukwa chaꞌ nu ngwaꞌan yu kula kanꞌ bra kanꞌ: “Xuwa ka naan yu.” Nchga nten nu ndiꞌin kwiꞌ seꞌen ti, yuwe ꞌa tiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Bra ti ngwa ykwiꞌ Zacarías xiyaꞌ bra kanꞌ, mdyisnan yu yꞌni tnun yu ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yuwe ꞌa tiꞌ nchga nten taꞌa kichen tyi neꞌ bra kanꞌ; kwiꞌ ngwañaꞌan yuwe ꞌa tiꞌ nchga neꞌ kichen laja kiꞌya Judea kanꞌ, ytsaꞌ neꞌ ꞌin taꞌa neꞌ sa ñaꞌan nu ngwa chaꞌ ꞌin Zacarías. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Mdaꞌan ꞌa chaꞌ tiye nchga nten nu ynan chaꞌ kanꞌ: ―¿Sa ñaꞌan tñan ka ꞌin kuwiꞌ kanꞌ a? ―ndukwin neꞌ ꞌin taꞌa neꞌ. Chañi chaꞌ suꞌwe ꞌa ngiꞌni Ndiose loꞌo kuwiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wa msaꞌan tiye Zacarías nsuꞌwi Tyiꞌi Ndiose. Bra kanꞌ mdyisnan yu kula kanꞌ ykwiꞌ yu nchga chaꞌ nu wa ytsaꞌ Ndiose ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ndiꞌin chaꞌ kuꞌni tnuan ꞌin Ndiose nu lka Xꞌnaan, nu lka Ndiose ꞌñaan neꞌ Israel, ndukwin yu kula kanꞌ bra kanꞌ. Wa xiyaꞌ mdyisnan Ndiose ykwiꞌ Ni loꞌo neꞌ taꞌaan nu lkaan nten ꞌin Ni. Sa bra ni ngiꞌni Ni tñan chaꞌ kulaa Ni ꞌñaan ꞌin nchga chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tka msuꞌwa Ndiose ndijyan ska nu suꞌwe ꞌa chaꞌ nchka ꞌin, nu kulaa ꞌñaan ꞌin nchga chaꞌ kuxi nu ndiꞌin ꞌñaan; kanꞌ lka ska nten nu ti kwiꞌ taꞌa ayman David nu yꞌni tñan ꞌin Ndiose nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ti kwiꞌ ti chaꞌ ykwiꞌ Ni loꞌo neꞌ taꞌaan ti sꞌni la, chaꞌ wa ngwa tyun siyentu yijan nu ytsaꞌ Ni chaꞌ kanꞌ ꞌin ayman ꞌñaan, nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ndukwin ayman kanꞌ, chaꞌ kulo Ndiose ꞌñaan laja nten kuxi nu nxuun loꞌoan, loꞌo kulo Ni ꞌñaan laja nten nu tiꞌí tiꞌ ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nchka tꞌnan tiꞌ Ndiose ꞌñaan, loꞌo ꞌin ayman ꞌñaan; ja mjlyaa tiꞌ Ndiose chaꞌ nu wa mskanꞌ Ni loꞌo ayman taꞌaan nu ngwa sꞌni, ndukwin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Nde lka chaꞌ nu wa ykwiꞌ Ndiose loꞌo ayman Abraham, bra nu ngunun tsaa chaꞌ nu ykwiꞌ Ndiose loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ndukwin Ni chaꞌ kulo Ni ꞌñaan laja nten kuxi nu nxuun loꞌoan; ngwañaꞌan kuꞌni Ni chaꞌ ja kutsean tyukwi tyempu nu ndiꞌian ngiꞌnian tñan ꞌin Ndiose lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ta Ni chabiyaꞌ kanꞌ ꞌñaan si luwi tiyean, si nka tiyean tukwaan tñan ꞌin Ni, ndukwin yu kula Zacarías bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Loꞌo ni, sñiěnꞌ, ndukwin yu ꞌin kuwiꞌ kanꞌ, chkwiꞌ neꞌ chaꞌ nuꞌwin lkaa nu taa chaꞌ tiya ꞌin nten chaꞌ ꞌin Ndiose nu lka ndloo la. Tyaꞌaan kulo ndukwa la ꞌin ykwiꞌ nu ka Xꞌnaan, chaꞌ xñii suꞌwee tuwiin seꞌen nu kan ykwiꞌ Xꞌnaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nuiꞌwin kwaꞌuu ꞌin nten chaꞌ ꞌin Xꞌnaan; kuꞌnii chaꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin kiꞌya nu ndukwi neꞌ, chaꞌ ka tyoꞌo laa neꞌ ꞌin nchga chaꞌ kuxi bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Suꞌwe ꞌa nka tiye Ndiose ñaꞌan Ni ꞌñaan; nchka tꞌnan ꞌa tiꞌ Ndiose ꞌñaan, kanꞌ chaꞌ wa ta ti Ni ꞌin Krixtu chaꞌ kan seꞌen ndiꞌian. Kanꞌ lka ska xaa nu ja tsaa tii ꞌa, nu xuꞌwi niꞌ kasiya ꞌñaan, ñaꞌan tiꞌ xaa ndyuwi nu ngaꞌni seꞌen ndiꞌian bra nu tka ndijyan ti kwichaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Bra kanꞌ ta xaa kanꞌ xaa nu xuꞌwi niꞌ kasiya ꞌin nten nu ja ndyiji ꞌa sa ñaꞌan kuꞌni neꞌ, chaꞌ tla ꞌa niꞌ kasiya ꞌin neꞌ; ti luꞌu neꞌ kanꞌ, ni siya sa ñaꞌan lka ꞌin neꞌ si wa ngujwi neꞌ, siꞌya chaꞌ kuxi nu nsuꞌwi niꞌ kasiya ꞌin neꞌ. Kwaꞌu Krixtu ꞌñaan sa ñaꞌan kuꞌnian chaꞌ tyiꞌiin suꞌwean loꞌo taꞌa ntean. Wa mdyii chaꞌ nu ykwiꞌ Zacarías bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wa ndijyan ngaluu la Xuwa, kwiꞌ ngwañaꞌan wa ngwa ngula la tiye yu. Xkwiꞌ niꞌ kixinꞌ yuꞌwi yu tyukwi sa ñaꞌan bra nu nguluu yu, kanꞌ ngwaꞌu tloo yu ꞌin neꞌ Israel taꞌa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tyempu kanꞌ, nten nu lka ndloo la tyukwi ñaꞌaan chalyuu, kanꞌ nu ngwa emperador; Augusto naan yu. Bra kanꞌ ngulo yu tñan chaꞌ tyaꞌan nin neꞌ lo kityi sa ñaꞌan naan neꞌ nchga kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ja ya tyaꞌan nin neꞌ ngwañaꞌan nu ngwa sꞌni, kulo ni kwaꞌan neꞌ nin neꞌ lo kityi kanꞌ. Ti kwiꞌ tyempu lka Cirenio gobernador nde lo yuu ꞌin Siria, tñan ꞌin nu nka emperador kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Bra kanꞌ ndyaa nchga nten kichen tyi ayman ꞌin neꞌ, chaꞌ la kanꞌ ndukwa nin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Kichen Belén nde lo yuu ꞌin Judea, kanꞌ lka kichen tyi ayman David nu ngwa ayman kula ꞌin Se ti sꞌni, kanꞌ chaꞌ mdoꞌo Se kichen Nazaret seꞌen ndiꞌin yu, ndyaa yu nde kichen Belén. Suꞌwa ti ndyaa yu loꞌo Liya nu ka kwilyoꞌo yu, chaꞌ tyaꞌan nin neꞌ; wa kala ti sñiꞌ nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bra kanꞌ wa ndiya bra chaꞌ kala sñiꞌ nu kunaꞌan kanꞌ, bra nu ndiꞌin neꞌ kichen Belén kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kiꞌyu kuwiꞌ nu ngula ꞌin Liya kanꞌ, sñiꞌ kulo nu kunaꞌan kanꞌ lka kuwiꞌ kanꞌ. Suꞌwe mxiin jyaꞌan teꞌ chunꞌ kuwiꞌ kanꞌ, loꞌo kanꞌ mstya ꞌin kuwiꞌ niꞌ kanduwa seꞌen nchku ꞌni, chaꞌ ja mjwi naꞌan tyiꞌin neꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tuꞌwa kichen kanꞌ ndaꞌan neꞌ nu naꞌansiin ꞌin slyaꞌ ꞌin nten. Tla kanꞌ ndiꞌin neꞌ kwan ꞌin ska ta slyaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Bra kanꞌ mdoꞌo tukwa ska angajle seꞌen ndiꞌin neꞌ la kanꞌ; ngwañaꞌan mꞌni ska xaa tlyu seꞌen ndiꞌin neꞌ kanꞌ, xaa ꞌin Ndiose lka kanꞌ. Ytsen ꞌa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ykwiꞌ angajle kanꞌ loꞌo neꞌ: ―Ja kutsen wan ―ndukwin―. Wa ndijyaǎn re chaꞌ katsaǎnꞌ ska chaꞌ nu suꞌwe ꞌa ꞌwan ―ndukwin―. Suꞌwe ꞌa ka tiye nchga nten chunꞌ chaꞌ nu chkwiǐnꞌ loꞌo wan ―ndukwin angajle kanꞌ ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wa ndijyaǎn katsaǎnꞌ ꞌwan chaꞌ nu ni, wa ngula ska kuwiꞌ kichen tyi wan, chaꞌ ti kwiꞌ kichen tyi ayman David lka kanꞌ; kuwiꞌ kanꞌ lka nu kuꞌni tyii kiꞌya nu ndukwi wan. Kanꞌ lka Krixtu nu nka Xꞌnaan, nu wa msuꞌwa Ndiose ꞌin chaꞌ ndijyan lo chalyuu ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Si tyija ꞌwan seꞌen nskwa ska kuwiꞌ nu suꞌwe ꞌa mxiin teꞌ chunꞌ, nu nskwa niꞌ kanduwa seꞌen nchku ꞌni, bra kanꞌ ka biyaꞌ tiꞌ wan chaꞌ kanꞌ lka nu naan Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Bra wa mdyii ykwiꞌ angajle kanꞌ loꞌo neꞌ, bra kanꞌ nde niꞌ kwan mdoꞌo tukwa xka ta angajle nu kaꞌan la, nu mdoꞌo nde seꞌen ndiꞌin Ndiose; suꞌwe ꞌa ngiꞌni tnun angajle kanꞌ ꞌin Ndiose. Nchga angajle kanꞌ suꞌwe ꞌa nchkwiꞌ chaꞌ re loꞌo taꞌa bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Lye ꞌa kuꞌni tnuan ꞌin Ndiose, loꞌo nde niꞌ kwan seꞌen ndiꞌin Ni, loꞌo lo chalyuu! ¡Tlyu ꞌa chaꞌ ndiꞌin ꞌin Ni!, ndukwin angajle kanꞌ bra kanꞌ. Kuꞌni chaꞌ tiin ti tyiꞌin nten chalyuu chaꞌ nu ka biyaꞌ tiꞌ neꞌ chaꞌ suꞌwe ꞌa nka tiye Ndiose ñaꞌan Ni ꞌin nten, ndukwin angajle bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Mdoꞌo angajle kanꞌ ndyaa nde niꞌ kwan seꞌen ndiꞌin Ndiose. Loꞌo neꞌ nu ndiꞌin kwan ꞌin slyaꞌ kanꞌ, bra ti mdyisnan neꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―Tsaa naꞌaan nde Belén ―ndukwin neꞌ ꞌin taꞌa neꞌ bra kanꞌ―. Tsaa naꞌaan nan lka nu nchka kwa, ni chaꞌ lka nu wa ytsaꞌ Ndiose ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Bra ti ndyaa neꞌ bra kanꞌ; ndyija lyo Liya loꞌo Se ꞌin neꞌ, ndiꞌin neꞌ loꞌo ska kuwiꞌ nu nskwa niꞌ kanduwa seꞌen nchku ꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Bra wa naꞌan neꞌ ꞌin kuwiꞌ kanꞌ, bra kanꞌ ytsaꞌ neꞌ ꞌin neꞌ kanꞌ, nchga chaꞌ nu wa ykwiꞌ angajle kanꞌ loꞌo neꞌ chaꞌ ꞌin kuwiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bra nu ykwiꞌ neꞌ nu ndiꞌin kwan ꞌin slyaꞌ chaꞌ kanꞌ, bra kanꞌ mdaꞌan ꞌa chaꞌ tiye neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tiye ti Liya nganun chaꞌ kanꞌ, kaꞌan ꞌa chaꞌ mdaꞌan tiye chaꞌ ngwa ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Bra kanꞌ mdoꞌo neꞌ nu ndiꞌin kwan ꞌin slyaꞌ kanꞌ, ndyaa neꞌ; suꞌwe ꞌa yꞌni tnun neꞌ ꞌin Ndiose chaꞌ ꞌin nchga chaꞌ nu wa ynan neꞌ, chaꞌ ꞌin nchga chaꞌ nu wa naꞌan neꞌ. Chañi chaꞌ wa ngwa chaꞌ kanꞌ, nchga chaꞌ nu ykwiꞌ angajle loꞌo neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wa mdaꞌa snuꞌ tsan, bra kanꞌ ndukwan neꞌ ꞌin kuwiꞌ kuneꞌ kanꞌ chaꞌ ꞌin neꞌ judío. Bra kanꞌ mstya neꞌ nin, chaꞌ Jesús ka naan yu, ndukwin neꞌ, chaꞌ ngwañaꞌan wa ytsaꞌ angajle ꞌin Liya xa nu ti ji ka tnan. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Chunꞌ ndiꞌin la, bra wa mdyii mduun neꞌ tsan chaꞌ ꞌin nchga chaꞌ nu ngwaꞌan ayman Moisés lo kityi sꞌni chaꞌ ndlya ska kuwiꞌ, bra kanꞌ ndyaa loꞌo neꞌ ꞌin kuwiꞌ Jesús kanꞌ nde kichen Jerusalén chaꞌ tya neꞌ xuꞌwe ꞌin Ndiose chaꞌ ꞌin kuwiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ngwañaꞌan yꞌni neꞌ, sa ñaꞌan ndukwa chaꞌ lo kityi ꞌin Ndiose nu nka Xꞌnaan: “Kuwiꞌ kiꞌyu nu ngula kulo ꞌwan, ta wan ꞌin yu chaꞌ ka yu tñan ꞌin Ndiose” ndukwin kityi. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kanꞌ chaꞌ mdiyan neꞌ kanꞌ, chaꞌ xtya neꞌ lomstan nu nchkwiꞌ kityi kula kanꞌ. Lomstan kanꞌ lka tukwa kulye, o ta tukwa kiñi cha kun xuwe ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Bra kanꞌ nde kichen Jerusalén ndiꞌin ska yu kula nu naan Simeón; nten suꞌwe ꞌa lka yu, ndukwa ꞌa yu tñan ꞌin Ndiose. Ndaloo ꞌa yu ndiꞌin ta yu ꞌin ska nten nu tnun nchka, nu suꞌwa Ndiose ꞌin chaꞌ kan lo chalyuu, kanꞌ lka Krixtu nu kan chaꞌ kulaa ꞌin neꞌ Israel ꞌin nchga chaꞌ kuxi. Loꞌo ndiꞌin Tyiꞌi Ndiose loꞌo Simeón kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","wa yꞌni Ni chaꞌ ka biyaꞌ tiꞌ yu chaꞌ ja kaja yu sa bra nu tiya tsan nu ñaꞌan yu ꞌin nu ka Krixtu, nu suꞌwa Ndiose ꞌin chaꞌ kan lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tsan kanꞌ ytsaꞌ Tyiꞌi Ndiose ꞌin yu kula kanꞌ chaꞌ tsaa yu niꞌ lyaa tnun, kanꞌ chaꞌ ndyaa ñi yu seꞌen ndiya laa kanꞌ bra kanꞌ. Ndiꞌin yu niꞌ lyaa bra nu ngala Jesús loꞌo sti loꞌo jyaꞌan yu, ndijyan loꞌo neꞌ ꞌin kuwiꞌ kanꞌ, chaꞌ kuꞌni neꞌ loꞌo yu nchga chaꞌ kula nu ndiꞌin chaꞌ kuꞌni neꞌ niꞌ lyaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bra kanꞌ msñi Simeón ꞌin kuwiꞌ kanꞌ, mdyisnan yꞌni tnun yu ꞌin Ndiose chaꞌ ꞌin kuwiꞌ kanꞌ bra kanꞌ. Nde lka chaꞌ nu ykwiꞌ yu loꞌo Ndiose: ");
INSERT INTO ctpNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ndiose Xꞌnan ba, wa ndaa chabiyaꞌ chaꞌ kajaǎn suꞌwe ti, ndukwin yu ꞌin Ndiose. Wa mdyii yꞌniǐn tñan nu ndukwiin chaꞌ ka ꞌñaǎn, chaꞌ ngiꞌniǐn tñan ꞌiin, ndukwin yu kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Loꞌo kiloǔn ykwiǐnꞌ wa naꞌaǎn ꞌin ykwiꞌ nu kulaa ꞌin nten ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","loꞌo nten tyukwi ñaꞌaan chalyuu, ñaꞌan neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ka yu kanꞌ ska xaa tlyu nu xuꞌwi niꞌ kasiya ꞌin nten tyukwi ñaꞌaan chalyuu; ka yu kanꞌ ska chaꞌ suꞌwe nu tlyu ꞌa chaꞌ ꞌin nten ꞌin yu, nu lka neꞌ Israel kanꞌ. Ngwañaꞌan ykwiꞌ yu kula Simeón kanꞌ loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Bra kanꞌ yuwe ꞌa tiꞌ Se loꞌo jyaꞌan Jesús, bra nu ynan neꞌ chaꞌ nu ykwiꞌ Simeón kanꞌ loꞌo Ndiose, sa ñaꞌan nu ka ꞌin kuwiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Loꞌo kanꞌ ndukwan yu kula Simeón ꞌin neꞌ kanꞌ. Nde lka chaꞌ nu ykwiꞌ yu kula loꞌo Liya jyaꞌan Jesús bra kanꞌ: ―Kaꞌan ꞌa chaꞌ suꞌwe ka ꞌin neꞌ Israel loꞌo kuwiꞌ re ―ndukwin yu kula kanꞌ―, xuꞌwi ꞌa nten nu chen ka tiye neꞌ ñaꞌan neꞌ ꞌin yu, loꞌo xuꞌwi ꞌa nten nu kaja chalyuu kwi ꞌin neꞌ chunꞌ tñan nu kuꞌni kuwiꞌ re. Kulo tuun kuwiꞌ re nchga chaꞌ nu nsuꞌwi mnan niꞌ kasiya ꞌin nten; lka kuwiꞌ re ska chaꞌ tnun nu wa nda Ndiose ꞌin nten, ni siya ja xlyaa kaꞌan nten tukwa chaꞌ ꞌin yu ―ndukwin Simeón ꞌin Liya jyaꞌan kuwiꞌ kanꞌ―. Kwiꞌ ngwañaꞌan nuꞌwin ―ndukwin yu kula kanꞌ―, tiya ska bra nu ka xiꞌin tiiꞌ chaꞌ ja tukwa ꞌa neꞌ chaꞌ nu chkwiꞌ sñiiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ndiya ska nu kunaꞌan nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten, nu ndiꞌin niꞌ lyaa kanꞌ; Ana naan nu kunaꞌan kanꞌ, sñiꞌ Fanuel lka, ti kwiꞌ taꞌa nten ꞌin neꞌ Aser lka nu kunaꞌan kanꞌ. Kula ꞌa nu kunaꞌan kanꞌ ni. Ti kuneꞌ nu kunaꞌan kanꞌ bra nu mjwi kwilyoꞌo; kati ti yijan mdiꞌin loꞌo kwilyoꞌo, loꞌo kanꞌ ngujwi yu kiꞌyu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kanꞌ nganun ska ti tyukwi seꞌen ndiꞌin chalyuu, loꞌo ni, nsuꞌwi jakwa yla ndukwa jakwa yijan. Nchga tsan mdiꞌin niꞌ lyaa tnun kanꞌ, tsan loꞌo tla yꞌni tnun ꞌin Ndiose; ja yku tyaja bra nu ykwiꞌ loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Bra wa mdyii ykwiꞌ Simeón loꞌo jyaꞌan Jesús, ti kwiꞌ bra kanꞌ mdiyan Ana kanꞌ nde seꞌen ndiꞌin neꞌ loꞌo kuwiꞌ niꞌ lyaa, ti kwiꞌ Jesús lka kanꞌ. Ndya ꞌa neꞌ kula Ana xuꞌwe ꞌin Ndiose chaꞌ wa naꞌan ꞌin kuwiꞌ kanꞌ. Bra kanꞌ ykwiꞌ ꞌa loꞌo tyun neꞌ taꞌa kichen tyi, ngwañaꞌan loꞌo nchga neꞌ nu ndiꞌin ta ꞌin Krixtu sa bra nu tiya tsan nu kan yu chaꞌ kulaa yu ꞌin neꞌ Jerusalén yaꞌ neꞌ xka laꞌa tsuꞌ. Ykwiꞌ Ana loꞌo neꞌ kanꞌ, chaꞌ kuwiꞌ kanꞌ lka nu kulaa ji ꞌin nten ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ tloo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Xa wa mdyii yꞌni neꞌ nchga tñan nu ndiꞌin chaꞌ kuꞌni neꞌ, tñan nu ngulo ykwiꞌ Xꞌnaan ꞌin neꞌ judío nu ngwa sꞌni chaꞌ kuꞌni neꞌ, bra kanꞌ mxitukwi neꞌ ndyaa neꞌ nde lo yuu ꞌin Galilea; ngala neꞌ nde kichen Nazaret nu lka kichen tyi neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nde Nazaret kanꞌ nguluu kuwiꞌ kanꞌ; ngwa ngula la tiꞌ yu, wa nchka biyaꞌ la tiꞌ yu. Loꞌo Ndiose, suꞌwe ꞌa nka tiye Ni ñaꞌan Ni ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nchga yijan mdaꞌan neꞌ kula ꞌin Jesús nde kichen Jerusalén chaꞌ taꞌa, chaꞌ la kanꞌ yꞌni tnun neꞌ taꞌa pascua. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Bra nu yuꞌwi Jesús tii tyukwa yijan, yaa neꞌ taꞌa nde Jerusalén sa ñaꞌan nu yꞌni neꞌ nchga yijan. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Bra wa mdyii taꞌa, bra kanꞌ mxitukwi neꞌ ndyaa neꞌ nde kichen tyi neꞌ xiyaꞌ. Nganun xka ti Jesús nde kichen kanꞌ. Ja ngwa biyaꞌ tiꞌ jyaꞌan yu, ja jlyo tiꞌ ykwiꞌ Se chaꞌ nganun yu; ");
INSERT INTO ctpNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","mskeꞌ tiꞌ neꞌ chaꞌ ndyaan yu laja sa tlyu ti nten nu mdaꞌan tuwiin kanꞌ. Ngwañaꞌan mskeꞌ tiꞌ neꞌ, kanꞌ chaꞌ ti ndyaa la neꞌ tuwiin tyukwi tsan. Loꞌo kanꞌ mdaꞌan naan neꞌ ꞌin yu laja neꞌ taꞌa suꞌwe nsuꞌwi yu, laja neꞌ taꞌa yu. ¿La nde yaꞌ tyija yu ꞌin neꞌ bra kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ja ndyija yu ꞌin neꞌ siyaꞌ ti bra kanꞌ; kanꞌ chaꞌ mxitukwi neꞌ ndyaa neꞌ xiyaꞌ nde Jerusalén, ndyaa naan neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","La mdaꞌa snan tsan ndyija yu kanꞌ ꞌin neꞌ, ndiꞌin yu niꞌ lyaa. Ndukwa yu loꞌo mstru nu nduꞌu chaꞌ joꞌo ꞌin neꞌ. Nganan yu nchga chaꞌ nu nchkwiꞌ neꞌ, loꞌo tyun ꞌa chaꞌ nñichaꞌ yu ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nchga nten nu mdiꞌin nde kwa ti, nduwe ꞌa tiꞌ neꞌ bra nu ynan neꞌ nchga chaꞌ nu ykwiꞌ yu, nduwe ꞌa tiꞌ neꞌ chaꞌ nchka ꞌa ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Loꞌo neꞌ kula ꞌin yu, nduwe ꞌa tiꞌ neꞌ kanꞌ, chaꞌ naꞌan neꞌ ꞌin yu chaꞌ suꞌwa ti mdukwa yu loꞌo neꞌ nu tnun nchka. Bra kanꞌ ykwiꞌ jyaꞌan yu loꞌo yu: ―¿Ni chaꞌ ngiꞌnii ra ngwañaꞌan?, sñiěnꞌ ―ndukwin jyaꞌan yu―. Kaꞌan ꞌa chaꞌ mdaꞌan tiye ba loꞌo stii, la nde tsaan naan ba ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Bra kanꞌ ykwiꞌ Jesús loꞌo jyaꞌan yu: ―¿Ni chaꞌ ndaꞌan naan wan ꞌñaǎn a? ¿Ja jlyo tiꞌ wan chaꞌ ndiꞌin chaꞌ kuꞌniǐn tñan ꞌin Stiǐn a? ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ja ngwa biyaꞌ tiꞌ neꞌ siyaꞌ ti, ni chaꞌ lka nu ykwiꞌ Jesús loꞌo neꞌ ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Bra kanꞌ mdoꞌo yu ndyaa yu nde Nazaret xiyaꞌ loꞌo neꞌ kula ꞌin yu. Ñaꞌan ti ndukwa ꞌa yu chaꞌ nu nchkwiꞌ neꞌ kanꞌ. Suꞌwe ꞌa nganun nchga chaꞌ kanꞌ niꞌ kasiya ꞌin jyaꞌan yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Sa ñaꞌan nu ndijyan ngaluu Jesús, ngwañaꞌan ndijyan nchka biyaꞌ la tiꞌ yu. Suꞌwe ꞌa nka tiye Ndiose ñaꞌan Ni ꞌin yu; loꞌo nten chalyuu, suꞌwe ꞌa nchkwiꞌ neꞌ chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wa nsuꞌwi tiꞌyun yijan chaꞌ lka Tiberio emperador nu lka ndloo la ꞌin nten tyukwi ñaꞌaan chalyuu, Poncio Pilato lka ndloo nde lo yuu ꞌin Judea, tñan ꞌin Tiberio kanꞌ bra kanꞌ; loꞌo nu naan Herodes kanꞌ, lka yu ndloo lo yuu ꞌin Galilea tyempu kanꞌ; loꞌo Felipe, taꞌa ngula Herodes kanꞌ, lka yu ndloo lo yuu ꞌin Iturea loꞌo lo yuu ꞌin Traconite ti kwiꞌ tyempu kanꞌ; loꞌo xka nu naan Lisanias, lka yu ndloo lo yuu ꞌin Abilinia bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ti kwiꞌ bra kanꞌ lka Anás loꞌo Caifás xꞌnan sti joꞌo. Bra kanꞌ ykwiꞌ Ndiose loꞌo Xuwa sñiꞌ Zacarías seꞌen ndiꞌin yu niꞌ kixinꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","kanꞌ chaꞌ mdoꞌo Xuwa mdaꞌan yu nde lo ntenꞌ tyukwi ñaꞌaan tuꞌwa chku Jordán kanꞌ; ykwiꞌ ꞌa Xuwa loꞌo nchga nten nu mdyoꞌ tiꞌin seꞌen ndiꞌin yu, chaꞌ ka jyuꞌu tiꞌ neꞌ ꞌin kiꞌya nu ndiꞌin ꞌin neꞌ, chaꞌ kulaa yaꞌ neꞌ nchga chaꞌ kuxi kanꞌ. Bra kanꞌ ndukwatya Xuwa ꞌin neꞌ kanꞌ. Kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin neꞌ kanꞌ bra kanꞌ, ndukwin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wa lka chaꞌ kanꞌ, sa ñaꞌan lka chaꞌ nu ngwaꞌan ayman Isaías lo kityi; ayman kanꞌ lka nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. Nde lka chaꞌ nu ndukwa lo kityi kanꞌ: Kwen ꞌa nnen nxiꞌya ska nten niꞌ kixinꞌ: “Bra ti slaa wan ska tuwiin seꞌen kan ykwiꞌ nu nka Xꞌnaan” ndukwin nu nxiꞌya kanꞌ. “Xñii suꞌwe wan tuwiin seꞌen tyijin ykwiꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kuꞌni xaꞌan wan nchga tutkaꞌ, loꞌo kuꞌni wan chaꞌ katen nchga kiꞌya, nchga lo nten; xñii ñi wan nchga seꞌen nxitiꞌin tuwiin, loꞌo kuꞌni lkwa suꞌwe wan ñaꞌaan tuwiin” ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","“Ndla ti ñaꞌan neꞌ tyukwi ñaꞌaan chalyuu, chaꞌ ka kulaa Ndiose ꞌin nten ꞌin nchga chaꞌ kuxi.” Ngwañaꞌan ngwa chaꞌ ngwaꞌan ayman Isaías lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaꞌan nten mdiyan seꞌen nduun Xuwa chaꞌ tyukwatya neꞌ. Bra kanꞌ ykwiꞌ Xuwa loꞌo nten kaꞌan kanꞌ: ―¡Sa ñaꞌan ngiꞌni kunan tlá, ngwañaꞌan ngiꞌni wan! ―ndukwin Xuwa―. ¿Ta wa mdiya nten nu mxitsen ꞌwan ni a? ¿Sa bra ni nduwe tiꞌ wan chaꞌ ta Ndiose nu tiꞌí ꞌwan bra nu tyii chalyuu a? ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Suꞌwe sikwa, kwaꞌu wan ꞌwa si chañi chaꞌ wa ngulaa yaꞌ wan chaꞌ kuxi nu ndiꞌin ꞌwan; ja chkwiꞌ wan chaꞌ sñiꞌ Ndiose lka wan chunꞌ ndyoꞌo wan ꞌin ayman Abraham nu yuꞌwi ti sꞌni. Chaꞌ nu ñi chkwiǐnꞌ loꞌo wan ―ndukwin Xuwa―, chaꞌ ka ꞌin Ndiose kulo suwi Ni xka ta nten nu ka sñiꞌ Abraham, ja loꞌo wan, si nchka tiꞌ Ni; nxkeꞌ tiꞌ wan chaꞌ ja nsuꞌwi chaꞌ tiya ꞌin xka la nten kanꞌ, nxkeꞌ tiꞌ wan chaꞌ sa ñaꞌan lka kee re, ngwañaꞌan ti lka neꞌ kanꞌ ―ndukwin Xuwa ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sa ñaꞌan nduun ska nten loꞌo chkwan yka ꞌin yu chaꞌ kwaja yu lo yka kwiñii ꞌin yu, ngwañaꞌan ngiꞌni Ndiose. Siꞌyu yu kanꞌ nchga yka nu ja ndyoꞌo nan loo, chaꞌ tikin yu yka kanꞌ lo kiiꞌ; ngwañaꞌan ta Ndiose nu tiꞌí ꞌin nten nu ja xlyaa kulaa yaꞌ chaꞌ kuxi nu ndiꞌin ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Bra wa mdyii ynan neꞌ chaꞌ kanꞌ, bra kanꞌ mnichaꞌ neꞌ ꞌin Xuwa bra kanꞌ: ―¿Ni ñaꞌan tñan ka kuꞌni ba sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Bra kanꞌ ngwaꞌu Xuwa ꞌin neꞌ: ―Nde lka tñan nu kuꞌni wan ―ndukwin Xuwa―. Si nsuꞌwi tukwa ykanꞌ ꞌin ska wan, ta wan ska ꞌin ska nten tiꞌi nu ja nsuꞌwi ꞌin siyaꞌ ti; si nsuꞌwi nan nchku wan, bra kanꞌ suꞌwe wan chinꞌ chaꞌ ta wan ku nten nu ja nsuꞌwi ꞌa nan ku ―ndukwin Xuwa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Loꞌo yan chinꞌ neꞌ kuxi nu ndlo tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ, yan neꞌ chaꞌ tukwatya Xuwa ꞌin neꞌ. Bra kanꞌ mnichaꞌ neꞌ kanꞌ ꞌin Xuwa: ―¿Ni ñaꞌan tñan ka kuꞌni ba ni, mstru? ―ndukwin neꞌ kanꞌ ꞌin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","―Ja tyijin ꞌa wan biyaꞌ chaꞌ kulo wan tñi ꞌin nten ―ndukwin Xuwa ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Loꞌo chinꞌ neꞌ sndaru mdiyan neꞌ chaꞌ kunichaꞌ neꞌ ꞌin Xuwa bra kanꞌ: ―Loꞌo bare, ¿ni ñaꞌan tñan ka kuꞌni ba ni? ―ndukwin sndaru kanꞌ. ―Ja kulaa ꞌa wan nan nu nsuꞌwi ꞌin nten; ja xitsen ꞌa wan ꞌin neꞌ, ja suꞌwa ꞌa wan kiꞌya laja ti ꞌin neꞌ, chaꞌ kaja chaꞌ kanꞌ ꞌwan. Loꞌo bra kanꞌ ja chkwiꞌ ꞌa wan chaꞌ chinꞌ ti liyaꞌ ndiji ꞌwan ―ndukwin Xuwa ꞌin sndaru kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mdaꞌan ꞌa chaꞌ tiye neꞌ ndiꞌin neꞌ, chaꞌ mskeꞌ tiꞌ neꞌ chaꞌ Xuwa lka Krixtu nu wa kan ti lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bra kanꞌ ykwiꞌ Xuwa loꞌo nchga neꞌ nu ndiꞌin kanꞌ: ―Loꞌo tyiꞌa ti ndukwatyaǎn ꞌwan ―ndukwin Xuwa―. Loꞌo wa kan ti xka nten seꞌen ndiꞌin wan nu nchka la ꞌin ke naꞌ. Loꞌoǔn kuꞌni tnuǔn ꞌin yu kanꞌ. Suꞌwe ꞌa tñan kaja ꞌñaǎn, nxkeꞌ tiǎnꞌ, ni siya ti ndukwa snan yu kanꞌ xtiǐnꞌ. Loꞌo yu kanꞌ, ja ndukwatya yu ꞌin nten loꞌo tyiꞌa ti; xka ñaꞌan kuꞌni yu. Kuꞌni yu chaꞌ kanun Tyiꞌi Ndiose niꞌ kasiya ꞌin nten, bra nu tukwatya yu ꞌin neꞌ. Loꞌo kanꞌ kuꞌni luwi Ndiose ꞌin neꞌ kanꞌ loꞌo xaa ꞌin ykwiꞌ Ni, chaꞌ ngwañaꞌan ka suꞌwe ka tiye neꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Sa ñaꞌan ngiꞌni xꞌnan tya, ngwañaꞌan kuꞌni Ndiose; sa ñaꞌan nxoꞌ tiꞌin xꞌnan tya ꞌin nskwaꞌ, ndikin yu lkaꞌ tlaꞌ loꞌo mti, ngwañaꞌan suꞌwe taꞌa Ndiose ꞌin nten. Bra kanꞌ suꞌwa Ni ꞌin nten xaꞌan chaꞌ skin neꞌ lo kiiꞌ nu ja ka ꞌa tyuwiꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ngwañaꞌan kaꞌan ꞌa chaꞌ tiya ykwiꞌ Xuwa loꞌo nten, bra nu ykwiꞌ yu sa ñaꞌan chaꞌ suꞌwe nu kuꞌni Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Loꞌo kanꞌ mstya Xuwa kiꞌya ꞌin gobernador Herodes chaꞌ yꞌni yu kunan ꞌin Herodías kwilyoꞌo taꞌa yu nu naan Felipe. Loꞌo ti ndiꞌin xka la chaꞌ kuxi nu yꞌni yu kula Herodes kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bra kanꞌ ja mdukwa Herodes chaꞌ nu ykwiꞌ Xuwa loꞌo, kuxi la yꞌni yu, msuꞌwa yu ꞌin Xuwa niꞌ ñaꞌan chkwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Bra nu ti ji tsaa Xuwa kanꞌ niꞌ ñaꞌan chkwan, ti nduun yu tuꞌwa chku Jordán ndukwatya yu ꞌin kaꞌan ꞌa nten, bra kanꞌ mdiyan Jesús seꞌen ndiꞌin yu chaꞌ tukwatya Xuwa ꞌin yu. Laja nu ndukwatya yu ꞌin Jesús, bra kanꞌ ykwiꞌ Jesús loꞌo Ndiose, loꞌo ngalaa tuwiin niꞌ kwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ngwiꞌya Tyiꞌi Ndiose seꞌen ndiꞌin Jesús; sa ñaꞌan ndukwi ska kiñi cha kuun, ngwañaꞌan ngwiꞌya Tyiꞌi Ndiose lo jlyuꞌwe Jesús. Bra kanꞌ ynan neꞌ ykwiꞌ Ndiose nde niꞌ kwan: ―Sñiěnꞌ, suꞌwe ꞌa nka tiyeěn ñaꞌaǎn ꞌiin. Ndiya ꞌa tiǎnꞌ ꞌiin ―ndukwin Ndiose ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kalatyii yijan nsuꞌwi Jesús bra nu mdyisnan ngiꞌni yu tñan ꞌin Ndiose Sti yu. Mskeꞌ tiꞌ neꞌ chaꞌ Se ngwa sti yu, loꞌo sti Se ngwa ayman Elí; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","loꞌo sti Elí kanꞌ ngwa ayman Matat; Leví ngwa naan sti Matat kanꞌ; Melqui ngwa naan sti Leví kanꞌ; Janan ngwa naan sti Melqui kanꞌ; loꞌo xka Se ngwa sti Janan kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatías ngwa naan sti Se kanꞌ; Amós ngwa naan sti Matatías kanꞌ; Nahum ngwa naan sti Amós kanꞌ; Esli ngwa naan sti Nahum kanꞌ; Nagai ngwa naan sti Esli kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat ngwa naan sti Nagai kanꞌ; loꞌo xka nu naan Matatías ngwa sti Maat kanꞌ; Semei ngwa naan sti Matatías kanꞌ; loꞌo xka nu naan Se ngwa sti Semei kanꞌ; sñiꞌ Judá ngwa Se kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joanán ngwa naan sti Judá kanꞌ; Resa ngwa naan sti Joanán kanꞌ; Zorobabel ngwa naan sti Resa kanꞌ; Salatiel ngwa naan sti Zorobabel kanꞌ; Neri ngwa naan sti Salatiel kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","loꞌo xka nu naan Melqui ngwa sti Neri kanꞌ; Adi ngwa naan sti Melqui kanꞌ; Cosam ngwa naan sti Adi kanꞌ; Elmodam ngwa naan sti Cosam kanꞌ; Er ngwa naan sti Elmodam kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josué ngwa naan sti Er kanꞌ; Eliezer ngwa naan sti Josué kanꞌ; Jorim ngwa naan sti Eliezer kanꞌ; loꞌo xka Matat ngwa sti Jorim kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","loꞌo xka nu naan Leví ngwa sti Matat kanꞌ; Simeón ngwa naan sti Leví kanꞌ; loꞌo xka nu naan Judá ngwa sti Simeón kanꞌ; loꞌo xka nu naan Se ngwa sti Judá kanꞌ; Jonán ngwa naan sti Se kanꞌ; Eliaquim ngwa naan sti Jonán kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Melea ngwa naan sti Eliaquim kanꞌ; Mainán ngwa naan sti Melea kanꞌ; Matata ngwa naan sti Mainán kanꞌ; Natán ngwa naan sti Matata kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David ngwa naan sti Natán kanꞌ; Isaí ngwa naan sti David kanꞌ; Obed ngwa naan sti Isaí kanꞌ; Booz ngwa naan sti Obed kanꞌ; Salmón ngwa naan sti Booz kanꞌ; Naasón ngwa naan sti Salmón kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab ngwa naan sti Naasón kanꞌ; Aram ngwa naan sti Aminadab kanꞌ; Esrom ngwa naan sti Aram kanꞌ; Fares ngwa naan sti Esrom kanꞌ; loꞌo xka nu naan Judá ngwa sti Fares kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jacob ngwa naan sti Judá kanꞌ; Isaac ngwa naan sti Jacob kanꞌ; Abraham ngwa naan sti Isaac kanꞌ; loꞌo nu naan Taré ngwa sti Abraham kanꞌ; Nacor ngwa naan sti Taré kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serug ngwa naan sti Nacor kanꞌ; Ragau ngwa naan sti Serug kanꞌ; Peleg ngwa naan sti Ragau kanꞌ; Heber ngwa naan sti Peleg kanꞌ; Sala ngwa naan sti Heber kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Cainán ngwa naan sti Sala kanꞌ; Arfaxad ngwa naan sti Cainán kanꞌ; Sem ngwa naan sti Arfaxad kanꞌ; Noé ngwa naan sti Sem kanꞌ; Lamec ngwa naan sti Noé kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusalén ngwa naan sti Lamec kanꞌ; Enoc ngwa naan sti Matusalén kanꞌ; Jared ngwa naan sti Enoc kanꞌ; Mahalaleel ngwa naan sti Jared kanꞌ; loꞌo xka nu naan Cainán ngwa sti Mahalaleel kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enós ngwa naan sti Cainán kanꞌ; Set ngwa naan sti Enós kanꞌ; Adán ngwa naan sti Set kanꞌ; loꞌo ñi la chkwiǐnꞌ chaꞌ Ndiose lka sti ayman Adán kanꞌ, chaꞌ Ndiose lka nu wa mñan ꞌin Adán kanꞌ. Nchga nten nu ndukwa nin lo kityi re ni, ngwa neꞌ ayman ꞌin Jesucristo lo chalyuu nu ngwa ti sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Msaꞌan kasiya ꞌin Jesús nsuꞌwi Tyiꞌi Ndiose bra nu mdoꞌo Jesús tuꞌwa chku Jordán, ndyaa yu nde ska lo ntenꞌ wtyi seꞌen ja ndiꞌin nten, ");
INSERT INTO ctpNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","chaꞌ tuꞌwa tsan ndyaa loꞌo Tyiꞌi Ndiose ꞌin yu. La kanꞌ ykwiꞌ biyaꞌ kuneꞌ xaꞌan loꞌo Jesús. La mdaꞌa tuꞌwa tsan, ngiteꞌ ꞌa tiꞌ Jesús bra kanꞌ, chaꞌ ja ska nan yku yu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Loꞌo kanꞌ ykwiꞌ kuneꞌ xaꞌan kanꞌ loꞌo yu: ―Si chañi chaꞌ ska ti nuꞌwin lkaa nu nka Sñiꞌ Ndiose ―ndukwin kuneꞌ xaꞌan kanꞌ ꞌin yu―, kuꞌnii chaꞌ ka kee re ska jaxlya kuan sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Bra kanꞌ ykwiꞌ Jesús loꞌo: ―Lo kityi ꞌin Ndiose wa ngwaꞌan neꞌ chaꞌ re: “Siꞌi nan luꞌu nten chalyuu chaꞌ nchku neꞌ tyaja ti; xa nu kunan neꞌ nchga chaꞌ nu nchkwiꞌ Ndiose, bra kanꞌ chañi chaꞌ luꞌu neꞌ” ―ndukwin Jesús ꞌin kuneꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Bra kanꞌ ndyaa loꞌo kuneꞌ xaꞌan kanꞌ ꞌin yu ska lo kiꞌya kwan. Ska bra ti ngwaꞌu kuneꞌ xaꞌan tyukwi ñaꞌaan chalyuu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Bra kanꞌ ykwiꞌ kuneꞌ xaꞌan loꞌo yu xiyaꞌ: ―Taǎn chabiyaꞌ ꞌiin chaꞌ kaa ndloo ꞌin nchga chalyuu kwa ―ndukwin kuneꞌ xaꞌan bra kanꞌ―, chaꞌ kaja nchga nan nu nsuꞌwi kwa ꞌiin ―ndukwin―. Ndiya chabiyaꞌ kanꞌ ꞌñaǎn, kanꞌ chaꞌ taǎn chabiyaꞌ kanꞌ ꞌin nchga nten nu nchka tiǎnꞌ chaꞌ ka ndloo ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ska ti si tyuun xtyiinꞌ loǔn, si kuꞌni tnuun ꞌñaǎn, bra kanꞌ kaja chabiyaꞌ kanꞌ ꞌiin ―ndukwin kuneꞌ xaꞌan kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bra kanꞌ mxkwen Jesús ꞌin yu: ―Tyoꞌoo tsuuꞌ seꞌen ndiꞌiǐn, Satanás ―ndukwin―. Lo kityi ꞌin Ndiose wa ngwaꞌan neꞌ chaꞌ re: “Ska ti ꞌin Ndiose nu nka Xꞌnan wan kuꞌni tnun wan ꞌin Ni, ska ti chaꞌ ꞌin Ndiose ndiꞌin chaꞌ tukwa wan lo chalyuu.” Kanꞌ chaꞌ ja ndiꞌin chaꞌ tyuǔn xtyiǐnꞌ tloo nuꞌwin ―ndukwin Jesús ꞌin kuneꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Bra kanꞌ ndyaa loꞌo kuneꞌ xaꞌan ꞌin Jesús nde kichen Jerusalén, mskwen yu ꞌin Jesús ndyaa nde ke laa tnun kanꞌ. La kanꞌ xiyaꞌ ykwiꞌ kuneꞌ xaꞌan loꞌo yu: ―Si chañi chaꞌ ska ti nuꞌwin lkaa nu nka Sñiꞌ ykwiꞌ Ndiose ―ndukwin―, tyoꞌo kwan lyaa la ke laa re chaꞌ nu ꞌiin ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lo kityi ꞌin Ndiose wa ndukwa chaꞌ re: Kulo Ndiose tñan ꞌin angajle ꞌin Ni chaꞌ ñaꞌansiin ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Loꞌo yaꞌ ti xituun angajle kanꞌ ꞌiin bra kanꞌ, chaꞌ ja ka tiꞌí kiyaaꞌ yaꞌ nu tiyuu lo kee. Ngwañaꞌan lka chaꞌ nu ngwaꞌan neꞌ lo kityi ꞌin Ndiose ―ndukwin kuneꞌ xaꞌan ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bra kanꞌ xiyaꞌ mxkwen Jesús ꞌin kuneꞌ xaꞌan kanꞌ: ―Loꞌo wa ndukwa chaꞌ re lo kityi ꞌin Ndiose: “Ja kuꞌni wan chaꞌ tyijin lyo wan ꞌin Ndiose nu nka Xꞌnan wan” ndukwin kityi. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wa mdyii ykwiꞌ kuneꞌ xaꞌan kanꞌ loꞌo Jesús bra kanꞌ, loꞌo ja ngwa ꞌin kwiñi lyoꞌo ꞌin siyaꞌ ti. Bra ti mdoꞌo kuneꞌ xaꞌan kanꞌ ndyaa bra kanꞌ; chunꞌ ndiꞌin la kaja ñaꞌan nu kwiñi lyoꞌo yu ꞌin Jesús, mdaꞌan chaꞌ tiye kuneꞌ xaꞌan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Bra kanꞌ mxitukwi Jesús ndyaa nde lo yuu ꞌin Galilea xiyaꞌ. Tnun ꞌa chabiyaꞌ mda Tyiꞌi Ndiose ꞌin Jesús, loꞌo ynen nchkwiꞌ nten chaꞌ ꞌin yu tyukwi ñaꞌaan lo yuu kwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nchga kichen seꞌen mdaꞌan yu nguaꞌu yu ꞌin nten niꞌ lyaa ꞌin neꞌ judío, kanꞌ chaꞌ nchga nten suꞌwe ꞌa nchkwiꞌ neꞌ chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Bra kanꞌ ngala Jesús nde kichen Nazaret, seꞌen nguluu yu. Bra nu mdiya tsan nu nxitñaꞌ neꞌ judío, bra kanꞌ ndyaa yu niꞌ lyaa ꞌin neꞌ, chaꞌ xkwiꞌ ngwañaꞌan ngiꞌni yu tsan kanꞌ. Bra kanꞌ mdyituun Jesús chaꞌ chkwiꞌ yu lo kityi seꞌen ndukwa chaꞌ ꞌin Ndiose; ");
INSERT INTO ctpNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","kityi nu ngwaꞌan ayman Isaías, kanꞌ lka kityi nu mda neꞌ ꞌin Jesús chaꞌ chkwiꞌ yu lo. Bra kanꞌ mslaa Jesús kityi kanꞌ, ngunaan yu la nde ndukwa chaꞌ re: ");
INSERT INTO ctpNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Wa mkwan Ndiose nu nka Xꞌnaan ꞌñaǎn, ndukwin lo kityi kanꞌ. Wa ngwiꞌya Ndiose loǔn, wa ndiꞌin Tyiꞌi Ndiose loꞌoǔn, chaꞌ chkwiǐnꞌ chaꞌ suꞌwe loꞌo neꞌ tiꞌi. Wa msuꞌwa Ni ꞌñaǎn ndijyaǎn chaꞌ kuꞌni xuꞌweěn kasiya ꞌin nten chalyuu nu xiꞌin ꞌa tiꞌ, ndukwin lo kityi kanꞌ. Ndiꞌin chaꞌ chkwiǐnꞌ loꞌo nten nu lka presu ꞌin kuneꞌ xaꞌan; katsaǎnꞌ ꞌin neꞌ chaꞌ wa tyoꞌo ti neꞌ yaꞌ kuneꞌ xaꞌan kanꞌ. Taǎn xaa chaꞌ xuꞌwi niꞌ kasiya ꞌin nten chalyuu nu ja ya kunan chaꞌ ꞌin Ndiose, chaꞌ lka neꞌ sa ñaꞌan lka ska nu kwityiinꞌ. Bra nu ngiꞌni nten chaꞌ kuxi loꞌo neꞌ, bra kanꞌ taǎn chabiyaꞌ tyoꞌo laa neꞌ yaꞌ nu tiꞌí tiꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Wa ndijyaǎn tiǎn chaꞌ chkwiǐnꞌ loꞌo nten chalyuu, chaꞌ wa mdiya tyempu nu suꞌwe la nu nda Ndiose nu nka Xꞌnaan ꞌin neꞌ. Ngwañaꞌan ndukwa chaꞌ lo kityi seꞌen ykwiꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bra kanꞌ mdukunꞌ Jesús kityi kanꞌ, xiyaꞌ ndya yu kityi kanꞌ ꞌin xta nu ndiꞌin niꞌ lyaa kanꞌ, ndyaa tukwa Jesús xiyaꞌ bra kanꞌ. Loꞌo nchga nten nu ndiꞌin niꞌ lyaa kanꞌ, lye ꞌa ñaꞌan neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Bra kanꞌ mdyisnan Jesús ngwaꞌu yu ꞌin neꞌ: ―Loꞌo ni, wa mdoꞌo tukwa chaꞌ kanꞌ la seꞌen ndiꞌin wan, ti kwiꞌ chaꞌ nu wa ynan wan lo kityi re ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Yuwe ꞌa tiꞌ neꞌ ñaꞌan neꞌ ꞌin Jesús chaꞌ suꞌwe ꞌa nchkwiꞌ yu, mdiya ꞌa tiꞌ neꞌ chaꞌ nu ykwiꞌ yu loꞌo neꞌ. Kanꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ chaꞌ ꞌin yu bra kanꞌ: ―¿Ta siꞌi sñiꞌ Se lka yu re a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―Ja chan, chunꞌ ndiꞌin la chinꞌ chkwiꞌ wan chaꞌ re loꞌoǔn: “Si nchka ꞌiin kuꞌnii joꞌó ꞌin nten, kuꞌnii joꞌó ꞌiin, ti ykwiiꞌ ti sikwa.” Kwiꞌ ngwañaꞌan, ja chan chkwiꞌ wan loꞌoǔn: “Wa ynan ba chaꞌ ꞌin nchga chaꞌ tnun nu wa yꞌnii nde kichen Capernaum kanꞌ” nchkwin wan. “Kwiꞌ ngwañaꞌan kuꞌnii chaꞌ tnun kanꞌ nde kichen tyian sikwa, chaꞌ ñaꞌan kwiꞌya ba chinꞌ” nchkwin wan ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Katsaǎnꞌ ska chaꞌ nu ñi ꞌwan sikwa ―ndukwin Jesús―. Bra nu chkwiꞌ ska nten chaꞌ ꞌin Ndiose loꞌo neꞌ taꞌa kichen tyi yu, ja kunan neꞌ chaꞌ nu nchkwiꞌ yu, chaꞌ taꞌa kichen tyi ti neꞌ lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tyempu nu mdiꞌin ayman Elías lo chalyuu nu ngwa sꞌni ―ndukwin―, nsuꞌwi tiꞌ wan chaꞌ wa mdijin snan yijan ndukwa skwa koꞌ nu ja ngwiꞌya tyoo siyaꞌ ti; tlyu ꞌa jwiꞌñan ngwa tyukwi ñaꞌaan chalyuu bra kanꞌ. Mdiꞌin tyun ꞌa nu kunaꞌan nu nganun ska ti lo yuu re tyempu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bra kanꞌ msuꞌwa Ndiose ꞌin Elías chaꞌ tsaa yu seꞌen ndiꞌin ska nu kunaꞌan nu nganun ska ti nde kichen Sarepta, ska kichen tijyuꞌ la nde lo yuu ꞌin Sidón. Ja yaa Elías seꞌen ndiꞌin ska nu kunaꞌan tiꞌi taꞌa kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ti kwiꞌ ngwañaꞌan ngwa bra nu mdiꞌin ayman Eliseo. Ti kwiꞌ tyempu kanꞌ, mdiꞌin ꞌa neꞌ tiꞌí nu ngutsuꞌ kunaꞌ lo yuu re. Loꞌo kanꞌ ja ska neꞌ kanꞌ nchkaa neꞌ ꞌin kicha tnun kanꞌ; ska ti Naamán kanꞌ, ska ti yu kanꞌ wa nchkaa yu, loꞌo ska nten xka laꞌa tsuꞌ ngwa yu, chaꞌ wa mdoꞌo yu lo yuu ꞌin Siria ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Bra nu ynan neꞌ Nazaret chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ niꞌ lyaa kanꞌ, msinꞌ ꞌa tiꞌ neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kanꞌ mdyituun neꞌ ngulo neꞌ ꞌin Jesús niꞌ lyaa kanꞌ, mjwakii neꞌ ꞌin yu ndyaa loꞌo neꞌ ꞌin yu ska tuꞌwa yuu nu nsuꞌwi tuꞌwa kichen kanꞌ. Ngwa tiꞌ neꞌ chaꞌ xtyuu suꞌwa neꞌ ꞌin yu lo kwaꞌan, loꞌo ja ngwa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bra kanꞌ suꞌwe ti mdoꞌo Jesús yaꞌ neꞌ; mdijin yu laja seꞌen mduun neꞌ, ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wa ndiꞌin Jesús nde kichen Capernaum bra kanꞌ, ska kichen nu ndiꞌin lo yuu ꞌin Galilea kanꞌ. Tsan nu nxitñaꞌ neꞌ, bra kanꞌ mdyisnan Jesús ngwaꞌu yu ꞌin nten niꞌ lyaa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Yuwe ꞌa tiꞌ neꞌ bra nu ynan neꞌ chaꞌ suꞌwe nu ykwiꞌ Jesús loꞌo neꞌ. Mskeꞌ tiꞌ neꞌ chaꞌ tnun ꞌa chabiyaꞌ nsuꞌwi ꞌin yu chaꞌ nchkwiꞌ yu loꞌo neꞌ ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Niꞌ lyaa kanꞌ mdiya ska yu kiꞌyu nu msñi kwiꞌin kuxi ꞌin yu. Kwen ꞌa msiꞌya yu kicha kanꞌ ꞌin Jesús xa nu naꞌan yu chaꞌ ndijyan Jesús niꞌ lyaa: ");
INSERT INTO ctpNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿Ni sa ñaꞌan tñan kuꞌnii nde re, Jesús Nazaret? ―ndukwin yu tiꞌí kanꞌ―. ¿Ta wa nchka tiiꞌ chaꞌ kuꞌnii tyii ꞌñaǎn siyaꞌ ti a? Suꞌwe ꞌa nsuꞌwi lyoǔn ꞌiin, chaꞌ ykwiꞌ Ndiose nu luwi lkaa nu wa msuꞌwa Ni ꞌiin chaꞌ ndijyaan nde re. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ja mda ꞌa Jesús chabiyaꞌ chkwiꞌ yu tiꞌí bra kanꞌ; ngulo yu tñan ꞌin kwiꞌin kuxi kanꞌ, chaꞌ ja kuꞌni ꞌa chaꞌ kuxi loꞌo yu tiꞌí kanꞌ. ―Seen tyukwaa ―ndukwin Jesús―. Ja kuꞌnii ꞌa chaꞌ kuxi loꞌo yu re ni. Bra kanꞌ mxlyuu kwiꞌin kuxi kanꞌ ꞌin yu tiꞌí tloo nten kaꞌan kanꞌ. Loꞌo kanꞌ mdoꞌo kwiꞌin kuxi kanꞌ ndyaa, ja yꞌni ꞌa ran chaꞌ kuxi loꞌo yu tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Mdaꞌan ꞌa chaꞌ tiye nten bra kanꞌ, mdyisnan ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―¿La mjwi chaꞌ nu nchkwiꞌ Jesús kwa a? ―ndukwin neꞌ―. ¿Ni chaꞌ lka chaꞌ suꞌwe ꞌa mjwi chabiyaꞌ ꞌin yu kwa chaꞌ kulo yu tñan ꞌin kwiꞌin kuxi? Bra ti ynan kwiꞌin kuxi chaꞌ nu ykwiꞌ yu loꞌo ran, mdoꞌo kwiꞌin kuxi kanꞌ ndyaa bra kanꞌ ―ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Kanꞌ chaꞌ wa nganen chaꞌ kanꞌ tyukwi ñaꞌaan lo yuu la kanꞌ, nchkwiꞌ ꞌa neꞌ chaꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Bra kanꞌ mdoꞌo Jesús niꞌ lyaa, ndyaa yu nde naꞌan tyi Tyu. Tiꞌí ꞌa jyaꞌan laa Tyu Simón kanꞌ, chaꞌ lye ꞌa ndyuꞌwi tikeeꞌ ꞌin neꞌ kula kanꞌ. Tꞌnan ꞌa ykwiꞌ neꞌ loꞌo Jesús chaꞌ tsaa naꞌan chinꞌ ꞌin neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Mduun ti Jesús seꞌen nskwa neꞌ kula kanꞌ ñaꞌan ꞌa yu ꞌin neꞌ kula kanꞌ. Bra kanꞌ ykwiꞌ yu loꞌo tikeeꞌ kanꞌ, chaꞌ tyoꞌo ran ꞌin neꞌ kula kanꞌ. Bra ti mdyituun neꞌ kula jyaꞌan laa Simón, yꞌni kuwe tiꞌ chaꞌ kaja chinꞌ nan ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Xa wa ndyaa kwichaa, bra kanꞌ ndyaa loꞌo neꞌ ꞌin nchga taꞌa neꞌ nu tiꞌí ꞌa chaꞌ msñi tyun loo kicha ꞌin neꞌ, mdiya neꞌ seꞌen ndiꞌin Jesús. Bra kanꞌ mstya Jesús yaꞌ chunꞌ neꞌ tiꞌí kwenta ska ti neꞌ. Bra ti nchkaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Loꞌo mdoꞌo kwiꞌin kuxi ꞌin tyun neꞌ tiꞌí kanꞌ bra kanꞌ. Kwen ꞌa msiꞌya kwiꞌin kanꞌ bra nu mdoꞌo ꞌin neꞌ: ―Ska ti nuꞌwin lkaa Sñiꞌ Ndiose ―ndukwin kwiꞌin kanꞌ ꞌin Jesús. Bra kanꞌ ja mda ꞌa Jesús chabiyaꞌ chkwiꞌ kwiꞌin kuxi kanꞌ siyaꞌ ti. Wa yuꞌwi lyo kwiꞌin kanꞌ ꞌin Jesús, chaꞌ ti kwiꞌ Krixtu nu wa msuꞌwa Ndiose ꞌin ndijyan lo chalyuu lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wa ngwiꞌya xaa xka tsan, bra kanꞌ mdoꞌo Jesús ndyaa yu xka seꞌen, seꞌen tyaꞌan ska ti yu niꞌ kixinꞌ. Mdaꞌan naan ꞌa neꞌ ꞌin yu bra kanꞌ, sa yaꞌ mdyija yu ꞌin neꞌ. Ngwa tiꞌ neꞌ tatsaa neꞌ ꞌin Jesús chaꞌ ja tsaa ꞌa yu xka seꞌen. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Nchga kichen ndiꞌin chaꞌ chkwiǐnꞌ chaꞌ suꞌwe nu ꞌin Ndiose loꞌo nten, chaꞌ wa mdiya bra chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin nten chalyuu. Kanꞌ lka tñan nu wa nda Ndiose ꞌñaǎn ndijyaǎn chaꞌ chkwiǐnꞌ chaꞌ ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Loꞌo ti mdaꞌan la Jesús nchga niꞌ lyaa ꞌin neꞌ nde Galilea, ngwaꞌu yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ngwa ska tsan ndyaa Jesús tuꞌwa tiyuꞌ Genesaret. Tyun ꞌa nten mdaꞌan loꞌo yu. Loꞌo kanꞌ kaꞌan ꞌa nten mdiꞌin nde seꞌen mduun yu tuꞌwa tiyuꞌ kanꞌ, chaꞌ ngwa tiꞌ neꞌ kunan neꞌ chaꞌ nchkwiꞌ yu chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Wa naꞌan Jesús seꞌen ndukwi tukwa yka naꞌan xuwe ti tuꞌwa tiyuꞌ kanꞌ. Ja tukwin mdiꞌin niꞌ yka naꞌan xuwe kanꞌ siyaꞌ ti, kwiꞌ seꞌen ti mduun neꞌ kanꞌ njyaꞌan neꞌ katan ꞌin neꞌ, chaꞌ wa mdyii mdiꞌin neꞌ kuta. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Bra kanꞌ yten Jesús ska niꞌ yka naꞌan ꞌin Simón, ykwiꞌ loꞌo yu chaꞌ tukwa naꞌan yu ꞌin yka naꞌan chaꞌ tsaa la chinꞌ lo tyiꞌa. Ndyaa tukwa Jesús nde niꞌ yka naꞌan kanꞌ, bra kanꞌ mdyisnan yu nguaꞌu yu chaꞌ ꞌin Ndiose ꞌin nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Bra nu wa mdyii ngwaꞌu Jesús ꞌin neꞌ, bra kanꞌ ykwiꞌ yu loꞌo Simón: ―Yaa loꞌo wan yka naꞌan re nde seꞌen nu tlyaa la tyiꞌa. Kanꞌ kuun wan katan chaꞌ kaja kula ꞌwan ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bra kanꞌ mxkwen Simón ꞌin yu: ―Yu kula ―ndukwin―, tyukwi tla mdaꞌan ba lo tiyuꞌ nguun ba katan; ja ska nan mjwi ꞌwa siyaꞌ ti bra kanꞌ. Loꞌo ni, si ngwañaꞌan kuloo tñan ꞌwa, tsaa ba seꞌen ndukwiin chaꞌ kuun ba katan nde kwa ―ndukwin Simón bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Bra kanꞌ ngwañaꞌan yꞌni Simón loꞌo taꞌa yu, loꞌo kaꞌan ꞌa kula mjwi ꞌin neꞌ bra kanꞌ. Chaꞌ kaꞌan ꞌa kula yten niꞌ katan ꞌin neꞌ, kanꞌ chaꞌ mdaaꞌ chinꞌ katan ꞌin neꞌ bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","kanꞌ chaꞌ yꞌni yaꞌ neꞌ ꞌin taꞌa neꞌ nu ndiꞌin xka niꞌ yka naꞌan kanꞌ, chaꞌ kan neꞌ tayaꞌ neꞌ ꞌin neꞌ. Bra ti yan neꞌ bra kanꞌ, mjwakii neꞌ katan msaꞌan niꞌ nsuꞌwi kula, chaꞌ suꞌwa neꞌ ꞌin ran niꞌ yka naꞌan. Chinꞌ ti chaꞌ ja yten taꞌa tyukwaa yka naꞌan kanꞌ niꞌ tyiꞌa siꞌya chaꞌ teꞌen ꞌa kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Bra nu naꞌan Tyu Simón nchga kula kanꞌ, ngwa biyaꞌ tiꞌ yu chaꞌ Jesús lka nu wa yꞌni chaꞌ mjwi kula ꞌin neꞌ. Bra ti mduun xtyinꞌ yu tloo Jesús bra kanꞌ, ykwiꞌ yu loꞌo: ―Tyoꞌoo lyaa nde seꞌen ndiꞌiǐn, Xꞌnaǎn ―ndukwin Simón ꞌin Jesús―. Ndiꞌin ꞌa kiꞌya ꞌñaǎn chaꞌ nten chalyuu ti lkaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nduwe ꞌa tiꞌ Simón, loꞌo taꞌa ndaꞌan yu niꞌ yka naꞌan, nduwe ꞌa tiꞌ neꞌ, chaꞌ kaꞌan ꞌa kula nu tka msñi ti neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Loꞌo taꞌa tyukwaa yu sñiꞌ Zebedeo nu ndiꞌin xka niꞌ yka naꞌan kanꞌ, nu naan Santiago loꞌo nu naan Xuwa, loꞌo neꞌ kanꞌ ytsen ꞌa neꞌ; ti kwiꞌ taꞌa ndaꞌan Simón tñan lka neꞌ kanꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo Simón: ―Ja kutseen ―ndukwin―. Ti ngwa sꞌni la xkwiꞌ tñan kuta kula ti yꞌnii; loꞌo ni, taǎn xka tñan ꞌiin, chaꞌ tsaa naan ꞌin nten chalyuu nu mnaꞌ kasiya ꞌin siꞌya chaꞌ kuxi, chaꞌ ka neꞌ nten ꞌñaǎn ―ndukwin Jesús ꞌin Simón. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Bra nu mdiya yka naꞌan kanꞌ tuꞌwa tiyuꞌ xiyaꞌ, bra kanꞌ ngulaa tiꞌin neꞌ kanꞌ ꞌin yka naꞌan, mdoꞌo neꞌ ndyaa neꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Bra nu mdiꞌin Jesús ska kichen, bra kanꞌ mdiyan ska yu tiꞌí seꞌen ndiꞌin yu; lye ꞌa ngutsuꞌ kunaꞌ yu tiꞌí kanꞌ. Bra nu naꞌan yu ꞌin Jesús, bra ti mduun xtyinꞌ yu tloo Jesús, mꞌni tuꞌwa yu lo yuu. Tꞌnan ꞌa ykwiꞌ yu loꞌo Jesús bra kanꞌ: ―Si nchka tiiꞌ chaꞌ chkaǎn, jlyo tiǎnꞌ chaꞌ ka ꞌiin kuꞌnii chaꞌ chkaǎn ―ndukwin yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Bra kanꞌ mstya Jesús yaꞌ chunꞌ yu seꞌen ngutsuꞌ kunaꞌ yu: ―Nchka tiǎnꞌ ―ndukwin Jesús ꞌin yu―. Ka luwi tyukwi ñaꞌaan nuꞌwin ni. Laja nu nchkwiꞌ Jesús ngwañaꞌan, bra ti mdoꞌo tsuꞌ kicha nu ngutsuꞌ kunaꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Loꞌo kanꞌ ykwiꞌ Jesús loꞌo yu, chaꞌ ja katsaꞌ yu ꞌin nten sa ñaꞌan ngwa ꞌin yu: ―Yaa lyaa chkwiiꞌ loꞌo sti joꞌo nu ndiꞌin niꞌ lyaa ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ―. Nde kwa taa lomstan nu ndukwin ayman Moisés nu yuꞌwi ti sꞌni chaꞌ taan ꞌin Ndiose bra nu wa nchkaa seꞌen tiꞌí ꞌñaan. Ngwañaꞌan ka biyaꞌ tiꞌ nten bra nu chkwiꞌ sti joꞌo chaꞌ wa ngwa luwi tyukwi ñaꞌaan. Ja ska ꞌa kicha nsuꞌwi ꞌiin ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nchga tsan wa nganen la chaꞌ ꞌin Jesús bra kanꞌ, chaꞌ nchkwiꞌ ꞌa nten chaꞌ ꞌin. Kanꞌ chaꞌ kaꞌan ꞌa nten mdyoꞌ tiꞌin seꞌen ndiꞌin Jesús, chaꞌ kunan neꞌ nchga chaꞌ nu chkwiꞌ yu loꞌo neꞌ, chaꞌ kuꞌni yu chaꞌ chkaa nu tiꞌí ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bra kanꞌ mdoꞌo Jesús ndyaa yu niꞌ kixinꞌ, nde seꞌen ka tyiꞌin yu ska ti yu, chaꞌ chkwiꞌ yu loꞌo Ndiose Sti yu la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ngwa ska tsan nduꞌu Jesús chaꞌ ꞌin Ndiose ꞌin kaꞌan nten. Kichen tyi neꞌ kanꞌ lka nchga kichen xuwe ti nu ndiꞌin nde lo yuu ꞌin Galilea, nu ndiꞌin nde lo yuu ꞌin Judea, loꞌo neꞌ kichen Jerusalén ndiꞌin kanꞌ. Loꞌo ndiꞌin tyun neꞌ fariseo laja nten kanꞌ. (Kti ꞌa ngiꞌni neꞌ fariseo, nxkeꞌ tiꞌ neꞌ; lye ꞌa ngiꞌni siyeꞌ neꞌ loꞌo xka ta nten.) Loꞌo ndiꞌin tyun mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa. Wa mgii tiꞌ nchga nten nu ndiꞌin la kanꞌ, chaꞌ Ndiose lka nu nda chabiyaꞌ ꞌin Jesús chaꞌ ngiꞌni chkaa yu ꞌin neꞌ tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bra kanꞌ mdiyan loꞌo neꞌ ꞌin ska yu tiꞌí nu nsu niꞌ katan, chaꞌ wa nchkunꞌ ñaꞌaan tyukwin yu tiꞌí kanꞌ. Ngwa tiꞌ neꞌ chaꞌ sten neꞌ niꞌ ñaꞌan seꞌen ndiꞌin Jesús, chaꞌ tsaa loꞌo neꞌ ꞌin yu tiꞌí kanꞌ la seꞌen nduun Jesús, ñaꞌaan loꞌo katan ngwa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bra kanꞌ ja mjwi ñaꞌan nu sten neꞌ loꞌo yu tiꞌí kanꞌ niꞌ ñaꞌan, chaꞌ kaꞌan ꞌa nten ndiꞌin kanꞌ; kanꞌ chaꞌ mskwen neꞌ ꞌin yu nde ke naꞌan. Bra kanꞌ mslaa neꞌ chinꞌ ke naꞌan, chaꞌ ngwañaꞌan mjwi ñaꞌan mdiꞌya tiꞌin neꞌ ꞌin yu tiꞌí kanꞌ nde seꞌen nduun Jesús jluꞌwe la seꞌen ndiꞌin nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Bra ti ngwa biyaꞌ tiꞌ Jesús chaꞌ suꞌwe ꞌa ndyaa ñaꞌan tiꞌ neꞌ kanꞌ ꞌin yu, kanꞌ chaꞌ ykwiꞌ yu loꞌo yu tiꞌí kanꞌ: ―Yu kula ―ndukwin―, wa yꞌni Ndiose chaꞌ tlyu tiꞌ kiꞌya nu ndiꞌin ꞌiin ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Bra kanꞌ mdaꞌan ꞌa chaꞌ tiye mstru nu nduꞌu chaꞌ joꞌo kanꞌ loꞌo neꞌ fariseo: “¿Ti ka nu lka yu kiꞌyu re a? ¿Ni chaꞌ lka re a? Kuxi ꞌa nchkwiꞌ yu chaꞌ ꞌin Ndiose chaꞌ nchkwiꞌ yu ngwañaꞌan” mskeꞌ tiꞌ neꞌ. “Ja ka ꞌin ska nten chalyuu kuꞌni tyii kiꞌya sa ñaꞌan ngiꞌni yu re, ja ka kuꞌni nten chaꞌ tlyu tiꞌ kiꞌya nu ndiꞌin ꞌin nten; ska ti Ndiose ka kuꞌni tyii kiꞌya nu ndiꞌin ꞌin nten.” Ngwañaꞌan mdaꞌan chaꞌ tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","23","Wa jlyo tiꞌ Jesús sa ñaꞌan chaꞌ ndaꞌan tiye neꞌ. Bra kanꞌ mnichaꞌ yu ꞌin neꞌ kanꞌ: ―¿Ni chaꞌ ndaꞌan chaꞌ tiye wan ngwañaꞌan a? ¿Ta nxkeꞌ tiꞌ wan chaꞌ tukwi la lka si chkwiǐnꞌ loꞌo yu tiꞌí kwa chaꞌ kuꞌni Ndiose chaꞌ tlyu tiꞌ kiꞌya nu ndiꞌin ꞌin yu a? ¿Ta nxkeꞌ tiꞌ wan chaꞌ sa la ka chaꞌ chkwiǐnꞌ loꞌo yu tiꞌí: “Tyituun lyaa, tyaꞌaan” nxkeꞌ tiꞌ wan a? ¿Ni sa ñaꞌan tñan nu sa la kuꞌniǐn chaꞌ ꞌin yu kwa sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nchka tiǎnꞌ chaꞌ ka biyaꞌ tiꞌ wan chaꞌ wa nda Ndiose chabiyaꞌ ꞌñaǎn, chaꞌ kuꞌniǐn chaꞌ tlyu tiꞌ nchga kiꞌya nu ndiꞌin ꞌin nten laja nu ndiꞌiǐn lo chalyuu ―ndukwin Jesús―. Kanꞌ chaꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn lo chalyuu chaꞌ kaǎn nten. Bra kanꞌ xiyaꞌ ykwiꞌ Jesús loꞌo yu kiꞌyu nu nchkunꞌ ñaꞌaan tyukwin yu: ―Nde lka chaꞌ nu chkwiǐnꞌ loꞌoo ―ndukwin Jesús ꞌin yu―, tyituun lyaa chaꞌ tyaa naꞌan tyii; tyaa loꞌo katan seꞌen mstii tsan. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Bra ti mdyituun yu tiꞌí kanꞌ, laja nu naꞌan nchga nten kanꞌ ꞌin yu. Bra kanꞌ ndyaa loꞌo yu katan ꞌin yu. Suꞌwe ꞌa ngwa tiye yu xa nu mdoꞌo yu ndyaa yu, kanꞌ chaꞌ yꞌni tnun yu ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Yuwe ꞌa tiꞌ neꞌ ndiꞌin neꞌ. Bra kanꞌ nchga neꞌ kanꞌ yꞌni tnun neꞌ ꞌin Ndiose: ―Ja ya ñaꞌaan chaꞌ kuꞌni Ndiose ska chaꞌ tnun sa ñaꞌan nu yꞌni Jesús kwa ni ―ndukwin neꞌ ꞌin taꞌa neꞌ. Ngwañaꞌan ykwiꞌ neꞌ loꞌo taꞌa neꞌ chaꞌ ytsen ꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chunꞌ ndiꞌin la ndyaa Jesús chinꞌ ti lo kichen, bra kanꞌ naꞌan yu ꞌin ska nten nde seꞌen ndukwa yu ndlo yu tñi ꞌin nten; Leví naan yu kiꞌyu kanꞌ. Tñan lka yu chaꞌ kulo yu tñi ꞌin neꞌ kichen chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo yu: ―Kaan lyaa, tsaa loꞌoǔn ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Loꞌo ngulaa yaꞌ Leví tñan ꞌin yu chaꞌ tsaa yu loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chunꞌ ndiꞌin la, kanꞌ yꞌni Leví ska taꞌa tlyu nde naꞌan tyi yu, chaꞌ kuꞌni tnun yu ꞌin Jesús. Mdiyan tyun nten naꞌan tyi yu, loꞌo taꞌa ngiꞌni Leví tñan chaꞌ ndlo tñi ꞌin nten; loꞌo ti ndiꞌin la xka ta nten la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Bra kanꞌ mdyisnan neꞌ fariseo nu kti ꞌa ngiꞌni neꞌ, nxkeꞌ tiꞌ neꞌ, loꞌo mstru nu nduꞌu chaꞌ joꞌo kanꞌ, ykwiꞌ neꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús. ―¿Ni chaꞌ lka chaꞌ suꞌwa ti nchku wan loꞌo neꞌ kuxi kwa a? ¿Ni chaꞌ suꞌwa ti ndiꞌin wan loꞌo neꞌ kwa a? ―ndukwin neꞌ―. Msu ꞌin neꞌ xka laꞌa tsuꞌ lka neꞌ kwa. Kwiñi ꞌa neꞌ kwa chaꞌ ndlo neꞌ kaꞌan ꞌa tñi ꞌin nten. Loꞌo ti ndiꞌin la xka ta nten nu ngiꞌni ꞌa chaꞌ kuxi. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―Nten nu ngula tiꞌ ni, ja tsaa naan neꞌ kanꞌ ꞌin ska nu kuꞌni joꞌó ꞌin neꞌ; neꞌ tiꞌí lka nu ndaꞌan naan ꞌin ska nu kuꞌni joꞌó ꞌin neꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ngwañaꞌan naꞌ, ja ndijyaǎn chaꞌ tyaꞌan naǎn ꞌin nten nu nxkeꞌ tiꞌ chaꞌ ja ndiꞌin kiꞌya ꞌin; nan wa ndijyaǎn chaꞌ chkwiǐnꞌ loꞌo neꞌ kuxi, chaꞌ kulaa yaꞌ neꞌ kiꞌya nu ndiꞌin ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Bra kanꞌ mnichaꞌ neꞌ ꞌin Jesús: ―Loꞌo neꞌ nu ngiꞌni xaꞌan ꞌin Xuwa, loꞌo neꞌ nu ngiꞌni xaꞌan ꞌin neꞌ fariseo, ¿ni chaꞌ lye ꞌa nchkwiꞌ neꞌ kanꞌ loꞌo Ndiose? Kwiꞌ ngwañaꞌan, ja nchku neꞌ tsan nu nchkwiꞌ neꞌ loꞌo Ndiose. Loꞌo neꞌ nu ngiꞌni xaꞌan ꞌiin, xka ñaꞌan ngiꞌni neꞌ kanꞌ; xkwiꞌ suꞌwe ꞌa nchku neꞌ, xkwiꞌ suꞌwe ꞌa ndiꞌyo neꞌ ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Mxkwen Jesús chaꞌ re ꞌin neꞌ kanꞌ bra kanꞌ: ―Bra nu kaja kwilyoꞌo nten, nchku neꞌ nu ndaꞌan loꞌo kuxiin; ja ndiꞌin neꞌ ngiteꞌ tiꞌ neꞌ tsan kanꞌ, bra nu ndiꞌin neꞌ loꞌo kuxiin ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bra nu tiya tsan nu xñi neꞌ ꞌin nu kiꞌyu kuxiin chaꞌ tyaa loꞌo neꞌ ꞌin yu, bra kanꞌ ja ku ꞌa neꞌ taꞌa suꞌwe nsuꞌwi yu; ka xiꞌin tiꞌ neꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan, suꞌwe nka tiye taꞌa suꞌweěn ni, ni siya ka xiꞌin ꞌa tiꞌ neꞌ nde loo la bra kanꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Loꞌo kanꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ: ―Ja siꞌyu wan ska yuꞌwe teꞌ tiji ꞌwan chaꞌ xuꞌwa lo ska teꞌ kusun ꞌwan. Si ngwañaꞌan kuꞌni wan, ja kanun suꞌwe teꞌ tiji kanꞌ bra kanꞌ, tyiꞌiin ran tyaaꞌ seꞌen nchkwan teꞌ kanꞌ; loꞌo yuꞌwe teꞌ tiji kanꞌ, ja suꞌwa ñaꞌan loꞌo teꞌ kusun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Loꞌo xka chaꞌ ni ―ndukwin Jesús ꞌin neꞌ―, ja nsuꞌwa neꞌ xalyu nu tka mdoꞌo ti niꞌ chkaꞌ kula. Si suꞌwa neꞌ ꞌin ran niꞌ chkaꞌ kula, ndla ti katsu siꞌ chkaꞌ kanꞌ; lyaꞌa chkaꞌ kanꞌ, tyii xalyu kalu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Niꞌ chkaꞌ tiji xuꞌwi xalyu nu tka mdoꞌo ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Bra nu wa yiꞌo neꞌ xalyu nu wa kula, ja nchka ꞌa tiꞌ neꞌ koꞌo neꞌ xalyu nu tka mdoꞌo ti. “Xi la ndiꞌyo xalyu nu wa kula kanꞌ” nchkwin neꞌ. Ngwañaꞌan ngwa chaꞌ tiya nu ykwiꞌ Jesús loꞌo neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Bra nu ngwa ska tsan nu nxitñaꞌ neꞌ, bra kanꞌ mdaꞌan Jesús chinꞌ tuwiin loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdijin neꞌ seꞌen ndiꞌin jyan trigu ꞌin nten. Laja nu mdijin ti neꞌ, mcha neꞌ chinꞌ loo trigu. Bra kanꞌ mchu neꞌ ꞌin ran tuyaꞌ ti neꞌ chaꞌ kalu mta trigu kanꞌ; yku neꞌ chinꞌ mta ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Loꞌo kanꞌ mdiya chinꞌ neꞌ fariseo nu ndaꞌan ñaꞌan ꞌin neꞌ kanꞌ, nu lye ꞌa ykwiꞌ neꞌ loꞌo taꞌa ndaꞌan Jesús: ―¿Ni chaꞌ lka ngiꞌni wan tñan ngwañaꞌan, chaꞌ mcha wan loo trigu kwa a? ¿Ja jlyo tiꞌ wan chaꞌ tsan kti ꞌa lka ni a? Ja nsuꞌwi chabiyaꞌ ꞌñaan kuꞌnian tñan tsan nu kti ꞌa ―ndukwin neꞌ fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―¿Ja ya chkwiꞌ wan lo kityi ꞌin Ndiose seꞌen ndukwa chaꞌ sa ñaꞌan tñan nu yꞌni ayman David sꞌni a? ―ndukwin Jesús ꞌin neꞌ―. Ngwa ska tsan ngiteꞌ ꞌa tiꞌ yu, ngwañaꞌan ngiteꞌ ꞌa tiꞌ nchga neꞌ taꞌa ndaꞌan yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jlyo tiꞌ yu chaꞌ ndukwa jaxlya nu lka lomstan ꞌin Ndiose lo msaa niꞌ ñaꞌan teꞌ nu ndiꞌin chaꞌ ꞌin Ndiose. Kanꞌ chaꞌ yaa neꞌ niꞌ ñaꞌan kanꞌ; yku neꞌ jaxlya kanꞌ, ni siya ja nsuꞌwi chabiyaꞌ ku nchga nten ꞌin ran, ska ti sti joꞌo nsuꞌwi chabiyaꞌ ku jaxlya kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Bra kanꞌ xka chaꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Loꞌo naꞌ, wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ni, loꞌo naꞌ lkaǎn ndloo la ꞌin tsan nu nxitñaꞌ nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ngwa xka tsan taꞌa, tsan nu kti ꞌin neꞌ, bra kanꞌ mdiya Jesús niꞌ lyaa. La kanꞌ yaa tukwa yu, mdyisnan yu ngwaꞌu yu chaꞌ ꞌin Ndiose ꞌin nten bra kanꞌ. Niꞌ lyaa kanꞌ mdiꞌin ska nten nu ngwityi yaꞌ yu laꞌa seꞌen kwin ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Loꞌo mdiꞌin mstru nu nduꞌu chaꞌ joꞌo niꞌ lyaa kanꞌ, loꞌo neꞌ fariseo mdiꞌin loꞌo neꞌ. Taꞌa tyukwaa lo nten kanꞌ ñaꞌan kwiꞌya ꞌa neꞌ ꞌin Jesús, si kuꞌni ka joꞌó ꞌin yu tiꞌí kanꞌ tsan kti kanꞌ; ndaꞌan naan ꞌa neꞌ sa ñaꞌan ka xtya neꞌ kiꞌya ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bra ti ngwa biyaꞌ tiꞌ Jesús nchga chaꞌ nu mdaꞌan tiye neꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo yu nu nchkunꞌ yaꞌ kanꞌ: ―Tyituun lyaa, yaa tuun jluꞌwe laja neꞌ kwa ―ndukwin Jesús ꞌin yu tiꞌí kanꞌ. Bra kanꞌ mdyituun yu tiꞌí kanꞌ, ndyaa yu nde seꞌen ndukwin Jesús ꞌin yu chaꞌ tsaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Bra kanꞌ ykwiꞌ Jesús ska chaꞌ loꞌo nten nu mñi lyoꞌo ti chaꞌ ngiꞌni kti: ―¿Ni sa ñaꞌan tñan suꞌwe la chaꞌ kuꞌnian tsan kti sikwa a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿Ta ska chaꞌ suꞌwe kuꞌnian bra kanꞌ a? ¿O ta suꞌwe la kuꞌnian ska chaꞌ kuxi a?, xkeꞌ tiꞌ wan ―ndukwin―. ¿Ta suꞌwe la si kulaan ꞌin nten tsan kanꞌ, chaꞌ ja kaja neꞌ bra kanꞌ a? ¿O ta suꞌwe la, nxkeꞌ tiꞌ wan, taan chabiyaꞌ kaja nten bra kanꞌ a? ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Loꞌo kanꞌ naꞌan ꞌa Jesús ꞌin nchga nten nu nduun seꞌen ndiꞌin yu, ykwiꞌ yu loꞌo yu tiꞌí kanꞌ bra kanꞌ: ―Xñii yaaꞌ. Ngwañaꞌan yꞌni yu kanꞌ, bra ti nchkaa yaꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Loꞌo msinꞌ ꞌa tiꞌ neꞌ nu mñilyoꞌo ti chaꞌ ngiꞌni kti kanꞌ, mdyisnan neꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―¿Ni sa ñaꞌan kuꞌnian loꞌo yu kwa chaꞌ ja kuꞌni ꞌa yu ngwañaꞌan a? ―ndukwin neꞌ ꞌin taꞌa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Bra kanꞌ ndyaa Jesús xka ti yu ska lo kiꞌya chaꞌ chkwiꞌ yu loꞌo Ndiose Sti yu. Tyukwi tla nganun yu nchkwiꞌ yu loꞌo Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","La ngwiꞌya xaa xka tsan, bra kanꞌ msiꞌya yu ꞌin nten nu ndaꞌan loꞌo yu chaꞌ kan neꞌ seꞌen ndiꞌin yu. Bra kanꞌ ngulo suwi yu tii tyukwa neꞌ kanꞌ; mda yu chabiyaꞌ ꞌin neꞌ kanꞌ, chaꞌ tsaa neꞌ kwaꞌu neꞌ ꞌin nten tyun kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nde ndukwa nin neꞌ nu ngulo suwi Jesús bra kanꞌ: Simón, nu mstya Jesús xka nin yu chaꞌ Tyu ka naan yu, kanꞌ lka ska yu; loꞌo Ndre taꞌa ngula Simón, loꞌo Santiago, loꞌo Xuwa, loꞌo Lpe, loꞌo Bartolomé, ");
INSERT INTO ctpNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","loꞌo Mateo, loꞌo Toma, loꞌo xka Santiago sñiꞌ Alfeo, loꞌo xka Simón nu lka nten ꞌin ska ta neꞌ cananista, ");
INSERT INTO ctpNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","loꞌo Juda sñiꞌ Santiago, loꞌo Juda Iscariote nu kujwiꞌ xuꞌwa ꞌin Jesús yaꞌ neꞌ kuxi chunꞌ ndiꞌin la; ngwañaꞌan naan nten nu ngulo suwi Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Bra kanꞌ ngwiꞌya Jesús siꞌ kiꞌya kanꞌ loꞌo ñaꞌaan ta nten kanꞌ ꞌin yu, nganun yu ska lo ntenꞌ loꞌo tyun nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu kanꞌ. Loꞌo mdiya kaꞌan la nten seꞌen ndiꞌin Jesús, nten nu mdoꞌo lo yuu ꞌin Judea, loꞌo neꞌ kichen Jerusalén, loꞌo neꞌ kichen Tiro, loꞌo neꞌ kichen Sidón, kichen nu ndiya tuꞌwa tujoꞌo. Wa mdiyan neꞌ la kanꞌ, chaꞌ kunan neꞌ chaꞌ nu chkwiꞌ Jesús loꞌo neꞌ; loꞌo nchka tiꞌ neꞌ chaꞌ kuꞌni Jesús joꞌó ꞌin neꞌ tiꞌí nu ndiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Loꞌo nten nu msñi kwiꞌin kuxi ꞌin, loꞌo neꞌ kanꞌ nchka tiꞌ neꞌ chaꞌ chkaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nchga nten nu tiꞌí kanꞌ nchka tiꞌ neꞌ kalaꞌ neꞌ ꞌin Jesús, nchka tiꞌ neꞌ chaꞌ kuꞌni yu joꞌó ꞌin nchga nten nu tiꞌí kanꞌ. Chaꞌ tnun ꞌa chabiyaꞌ nda Ndiose ꞌin yu, kanꞌ chaꞌ nchga neꞌ tiꞌí kanꞌ nchkaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Naꞌan Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, bra kanꞌ mdyisnan yu nguaꞌu yu ꞌin neꞌ: ―Ka suꞌwe ka tiye wan nu tiꞌí ti ñaꞌan ndiꞌin lo chalyuu re ―ndukwin―. Ndiose lka nu ñaꞌansiin ꞌwan, chaꞌ kanꞌ nu nka Xꞌnan wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Kwiꞌ ngwañaꞌan, ka suꞌwe ka tiye wan nu lye ꞌa nchka tiꞌ wan kunan wan ska chaꞌ nu ñi, sa ñaꞌan lka si ngiteꞌ ꞌa tiꞌ wan ―ndukwin―. Chunꞌ ndiꞌin la, kalaꞌ tiꞌ wan bra kanꞌ. ’Kwiꞌ ngwañaꞌan, ka suꞌwe ka tiye wan nu xiꞌin tiꞌ ndiꞌin lo chalyuu re ni, chaꞌ chunꞌ ndiꞌin la ka suꞌwe ka tiye wan bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Kwiꞌ ngwañaꞌan, ka suꞌwe ka tiye wan ni siya tiꞌí tiꞌ neꞌ ñaꞌan neꞌ ꞌwan, ni siya kulo neꞌ ꞌwan seꞌen ndiꞌin wan, ni siya kuxi ꞌa chkwiꞌ neꞌ loꞌo wan, ni siya ja nchka ꞌa tiꞌ neꞌ chkwiꞌ neꞌ loꞌo wan, chunꞌ msñi wan chaꞌ ꞌñaǎn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ka suꞌwe ꞌa ka tiye wan bra kanꞌ, ni siya ta neꞌ nchga nu tiꞌí ꞌwan ngwañaꞌan. Ja kuwe tiꞌ wan, wa lka ndiꞌin ska chaꞌ suꞌwe nu wa tlyu chinꞌ nu ta Ndiose ꞌin skaa wan nde seꞌen ndiꞌin Ni ―ndukwin Jesús bra kanꞌ―. Kwiꞌ ngwañaꞌan ngwa ti sꞌni, chaꞌ tiꞌí ꞌa tiꞌ ayman kula ꞌin nten nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo neꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Tꞌnan ꞌa ꞌwan neꞌ kuliyaꞌ; suꞌwe ꞌa ngwa tiye wan nu ngwa sꞌni la; nu ka nde loo la, ja ka ꞌa suꞌwe ka tiye wan bra kanꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Kwiꞌ ngwañaꞌan, tꞌnan ꞌa ꞌwan nu suꞌwe ꞌa ngalaꞌ tiꞌ wan loꞌo chaꞌ suꞌwe nu nsuꞌwi lo chalyuu re ni, chaꞌ kaꞌan ꞌa chaꞌ ka nu lyiji ꞌwan nde loo la ―ndukwin Jesús―. ’Kwiꞌ ngwañaꞌan, tꞌnan ꞌa ꞌwan nu lye ꞌa xtyi lyoꞌo wan ꞌin taꞌa nten wan; chunꞌ ndiꞌin la loꞌo wan xiꞌya wan chaꞌ lye ꞌa ka xiꞌin tiꞌ wan bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Kwiꞌ ngwañaꞌan, tꞌnan ꞌa ꞌwan bra nu suꞌwe ꞌa chkwiꞌ nchga nten ꞌwan. Kwiꞌ ngwañaꞌan yꞌni ayman ꞌwan nu yuꞌwi sꞌni, chaꞌ suꞌwe ꞌa ykwiꞌ nten ꞌin neꞌ nu ykwiꞌ chaꞌ kwiñi ꞌin Ndiose loꞌo neꞌ; mdiya ꞌa tiꞌ neꞌ chaꞌ kwiñi kanꞌ. Ngwañaꞌan ngwaꞌu Jesús ꞌin nchga nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ti nchkwiꞌ la Jesús bra kanꞌ: ―Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan nu xlyaa wan kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ. Suꞌwe ti xuꞌwi tiye wan ñaꞌan wan ꞌin nten nu nxuun loꞌo wan, suꞌwe ti xuꞌwi tiye wan loꞌo nten nu tiꞌí tiꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kwiꞌ ngwañaꞌan, suꞌwe ti jñan wan chaꞌ suꞌwe ꞌin Ndiose chaꞌ ꞌin nten nu nsuꞌwa kiꞌya ꞌwan, loꞌo chkwiꞌ wan loꞌo Ndiose chaꞌ ꞌin nten nu nchkwiꞌ chaꞌ kuxi loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Bra nu jwiꞌin neꞌ ndukunꞌ ke wan, bra kanꞌ xitukwi wan ta wan xka laꞌa skaꞌ wan chaꞌ jwiꞌin neꞌ ndukunꞌ ꞌwan xiyaꞌ bra kanꞌ. Bra nu kulaa ska nten teꞌ tnun tuꞌwa nu nchkuꞌ wan, bra kanꞌ ta wan chabiyaꞌ ꞌin neꞌ chaꞌ loꞌo xkanꞌ wan kwiꞌya neꞌ tsaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ta wan ꞌin nten nchga nan nu jñan neꞌ ꞌwan; bra nu xñi neꞌ ska nan ꞌwan, ja jñan ꞌa wan ꞌin ran xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ndiꞌin chaꞌ kuꞌni wan chaꞌ suꞌwe loꞌo nten, si nchka tiꞌ wan chaꞌ suꞌwe ti kuꞌni nten loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Jlyo tiǎnꞌ chaꞌ suꞌwe nka tiye wan ñaꞌan wan ꞌin wa lka ti nten nu suꞌwe ti nka tiye ñaꞌan ꞌwan; loꞌo nten kuxi, wa jlyo tiꞌ neꞌ kuꞌni neꞌ sa ñaꞌan ngiꞌni wan. Loꞌo ni, Ndiose nchka tiꞌ chaꞌ ñaꞌan suꞌwe wan ꞌin nchga nten, siꞌi loꞌo taꞌa suꞌwe nsuꞌwi ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kwiꞌ ngwañaꞌan, ngiꞌni wan chaꞌ suꞌwe loꞌo nten nu wa yꞌni ska chaꞌ suꞌwe loꞌo wan; loꞌo nten kuxi, wa jlyo tiꞌ neꞌ kuꞌni neꞌ sa ñaꞌan ngiꞌni wan. Ndiose nchka tiꞌ chaꞌ kuꞌni wan chaꞌ suꞌwe loꞌo nchga nten, siꞌi loꞌo taꞌa suꞌwe nsuꞌwi ti wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nda wan ska nan jñan nten nu ndayaꞌ ti ꞌwan, ngwañaꞌan ngiꞌni wan. ¿Ta suꞌwe ꞌa ngiꞌni wan, xkeꞌ tiꞌ wan bra kanꞌ a? Loꞌo nten kuxi, kwiꞌ ngwañaꞌan ngiꞌni neꞌ loꞌo taꞌa neꞌ, si tayaꞌ ska taꞌa neꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kanꞌ chaꞌ ꞌwan ni, suꞌwe ti xuꞌwi tiye wan ñaꞌan wan ꞌin taꞌa kusuun wan, kuꞌni wan chaꞌ suꞌwe loꞌo neꞌ kanꞌ. Ta wan nan jñan neꞌ, ja kuwe tiꞌ wan si tya neꞌ xuꞌwe ꞌwan, si ja tya neꞌ ꞌwan. Tlyu ꞌa chaꞌ suꞌwe kaja ꞌwan nde seꞌen ndiꞌin Ndiose si suꞌwe nka tiye wan ñaꞌan wan ꞌin nchga nten, chaꞌ ngwañaꞌan ngiꞌni nten nu lka sñiꞌ Ndiose. Loꞌo Ndiose, nchka tꞌnan ꞌa tiꞌ Ni ꞌin nten, ni siya xaꞌan tiye neꞌ, ni siya ja ndya ꞌa neꞌ xuꞌwe ꞌin Ni; ");
INSERT INTO ctpNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","kanꞌ chaꞌ chka tꞌnan tiꞌ wan ꞌin nten sikwa, sa ñaꞌan nu nchka tꞌnan tiꞌ Ndiose Stian ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Ja chkwiꞌ wan ꞌin chaꞌ kuxi nu ngiꞌni taꞌa nten wan, chaꞌ bra kanꞌ ja ndiꞌin chaꞌ chkwiꞌ Ndiose ꞌin chaꞌ kuxi nu ngiꞌni wan. Ja ta wan nu tiꞌí ꞌin taꞌa nten wan, chaꞌ bra kanꞌ ja ndiꞌin chaꞌ ta Ndiose nu tiꞌí ꞌwan. Kuꞌni wan chaꞌ tlyu tiꞌ ꞌin taꞌa nten wan, chaꞌ bra kanꞌ kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ta wan chaꞌ suꞌwe ꞌin taꞌa nten wan, chaꞌ ngwañaꞌan ta Ndiose chaꞌ suꞌwe ꞌwan; suꞌwe ꞌa msaꞌan biyaꞌ chaꞌ suꞌwe nu suꞌwa Ndiose niꞌ kasiya ꞌwan bra kanꞌ. Sa ñaꞌan lka ska biyaꞌ mlya nu lye ꞌa msaꞌan, nu tsaa ꞌa nsuꞌwi nan niꞌ, chaꞌ wa nskwin neꞌ ꞌin ran chaꞌ kiꞌya tiꞌin la nan kanꞌ; ndukwa ꞌa tuꞌwa biyaꞌ kanꞌ, ngwañaꞌan lka chaꞌ suꞌwe nu suꞌwa Ndiose niꞌ kasiya ꞌwan. Sa ñaꞌan nu ngiꞌni wan loꞌo taꞌa nten wan, ngwañaꞌan kuꞌni Ndiose loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nde lka xka chaꞌ tiya nu ngwaꞌu Jesús ꞌin neꞌ bra kanꞌ: ―Ska yu kwityiinꞌ ni, ¿ta ka kwaꞌu yu tuwiin ꞌin taꞌa kwityiinꞌ yu a? Ja ka ꞌin yu. Kuxi ꞌa ka ꞌin yu bra kanꞌ; suꞌwa ti tiyuu taꞌa tyukwaa yu ska loo kwaꞌan bra kanꞌ, chaꞌ ja ska yu kanꞌ ñaꞌan yu tuwiin seꞌen ndyaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ska yu kuneꞌ nu tka ngiꞌni xaꞌan ti, ja ka tyijin lyo yu ꞌin mstru ꞌin yu; chinꞌ ti chaꞌ jlyo tiꞌ yu. Xa wa mdyii yꞌni xaꞌan yu, kanꞌ nu suꞌwa ti nchka ꞌin yu loꞌo mstru ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Ni chaꞌ ndla ꞌa nchkwiꞌ wan ꞌin ska chaꞌ kuxi nu yꞌni xka la nten taꞌa wan a?, ñaꞌan tiꞌ ska kata yuu nu yten kiloo yu. Loꞌo kanꞌ ja nduwe ꞌa tiꞌ wan chaꞌ tlyu ꞌa chaꞌ kuxi nu ngiꞌni ykwiꞌ wan, ñaꞌan tiꞌ ska si yka nu ndukunꞌ ñaꞌaan kiloo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ni chaꞌ lka tnun ꞌa tiye wan chaꞌ chkwiꞌ wan loꞌo taꞌa nten wan a?: “Taa chabiyaꞌ kuloǔn yuu nu nsuꞌwi kiloo” nchkwin wan ꞌin neꞌ, loꞌo kanꞌ ja ñaꞌan wan mti tnun nu nsuꞌwi kiloo ykwiꞌ wan. ¡Nan kwiñi ꞌa wan! Kulo ndukwa la ndiꞌin chaꞌ kulo wan mti tnun nu nsuꞌwi kiloo ykwiꞌ wan, bra kanꞌ ka ñaꞌan suꞌwe wan chaꞌ kulo wan kata yuu nu nsuꞌwi kiloo taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ska yka kwiñii ni, ta ran ska nan nu kunanjoꞌo ꞌñaan. Loꞌo ska yka nu kuxi, ja ta ꞌa ran ska nan nu ka kuan. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nchga yka nsuꞌwi lyo neꞌ ꞌin ran xa wa naꞌan neꞌ nan nu ndyoꞌo loo ran. Ja xtun neꞌ nan nu xi nchku ꞌin kicheꞌ yka; kwiꞌ ngwañaꞌan, ja xtun neꞌ siꞌyu chi kutun ꞌin kicheꞌ styaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nchga nten nu suꞌwe tiye, suꞌwe ꞌa nchkwiꞌ neꞌ kanꞌ; loꞌo nchga nten nu kuxi tiye, kuxi ti nchkwiꞌ neꞌ kanꞌ bra kanꞌ. Sa ñaꞌan chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin skaa nten, ngwañaꞌan nchkwiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ti ngwaꞌu la Jesús xka chaꞌ tiya ꞌin neꞌ bra kanꞌ: ―¿Ni chaꞌ nchkwiꞌ ꞌa wan ꞌñaǎn chaꞌ Xꞌnan wan lkaǎn a? Loꞌo ja ndukwa wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Chkwiǐnꞌ ska chaꞌ tiya loꞌo wan ni, sa ñaꞌan lka nten nu ndijyan seꞌen ndiꞌiǐn chaꞌ kunan neꞌ chaꞌ nchkwiǐnꞌ, loꞌo kanꞌ ndukwa neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Sa ñaꞌan lka ska yu kiꞌyu nu mñan naꞌan ꞌin yu, ngwañaꞌan lka nten kanꞌ. Suꞌwe ꞌa msuꞌwa yu kiꞌyu kanꞌ kee kiyaꞌ naꞌan ꞌin yu, chaꞌ chunꞌ kee siyaꞌ ti ndukwa kiyaꞌ naꞌan kanꞌ. Bra kanꞌ lye ꞌa ngwiꞌya tyoo, loꞌo tlyaa ꞌa tyiꞌa yuu mdijin kiyaꞌ naꞌan kanꞌ; wa lyuꞌwa ti naꞌan kanꞌ, loꞌo ja ngwa ꞌin tyiꞌa yuu kanꞌ xlyuu ꞌin ran, chaꞌ tsaa ꞌa nduun kiyaꞌ ran chunꞌ kee kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Loꞌo ndiya xka la nten nu nnan chaꞌ nu nchkwiǐnꞌ loꞌo, loꞌo ja ndukwa ꞌa neꞌ chaꞌ kanꞌ. Sa ñaꞌan lka xka yu kiꞌyu nu mñan naꞌan ꞌin yu lo ysiin ti, ngwañaꞌan lka nten kanꞌ. Ja kiꞌñi yuꞌwi kiyaꞌ naꞌan ꞌin yu kiꞌyu kanꞌ. Kanꞌ ngwiꞌya tyoo tlyaa, mdijin tyiꞌa yuu kiyaꞌ naꞌan kanꞌ. Bra kanꞌ mdyii ran nguꞌwa ran lo tyiꞌa yuu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bra wa mdyii ykwiꞌ Jesús loꞌo nten kanꞌ, bra kanꞌ mdoꞌo yu ndyaa yu nde kichen Capernaum. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","La kanꞌ ndiꞌin ska capitán nu lka ndloo ꞌin sndaru ꞌin neꞌ romano, neꞌ xka laꞌa tsuꞌ tujoꞌo lka neꞌ kanꞌ. Mdiya ska msu ꞌin yu nu ndiya ꞌa tiꞌ yu ꞌin. Loꞌo ni, tiꞌí ꞌa msu kanꞌ, wa kaja ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Xa wa ynan capitán kanꞌ kaꞌan ꞌa chaꞌ nu nchkwiꞌ nten chaꞌ ꞌin Jesús, bra kanꞌ ykwiꞌ yu loꞌo chinꞌ yu kula kichen kanꞌ, chaꞌ tsaa neꞌ chkwiꞌ neꞌ loꞌo Jesús chaꞌ kan yu kuꞌni yu joꞌó ꞌin msu nu tiꞌí kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. Bra nu mdiya neꞌ kanꞌ seꞌen ndiꞌin Jesús, bra kanꞌ mdyisnan neꞌ ykwiꞌ neꞌ loꞌo yu chaꞌ ꞌin capitán kanꞌ. ―Suꞌwe ꞌa nten lka capitán kanꞌ ―ndukwin neꞌ ꞌin Jesús―. Yu nu nsuꞌwi lyo ꞌa ꞌwa lka yu kanꞌ, kanꞌ chaꞌ suꞌwe ꞌa si kuꞌnii joꞌó ꞌin msu nu tiꞌí kanꞌ ꞌin yu ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Wa ndyaꞌan ꞌa tiꞌ ba chaꞌ ndiꞌin yu kula kanꞌ kichen tyi ba. Ti ykwiꞌ ti yu mda yu tñi chaꞌ tyaꞌ laa ꞌwa kichen tyi bare ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bra kanꞌ ndyaa Jesús loꞌo neꞌ kanꞌ. Ti ji kala neꞌ loꞌo Jesús seꞌen ndukwa naꞌan ꞌin capitán kanꞌ, bra kanꞌ msuꞌwa capitán ꞌin xka ta taꞌa suꞌwe yu chaꞌ tsaa neꞌ tyukwa taꞌa neꞌ loꞌo Jesús tuwiin seꞌen ndijyan yu: ―Nde ñaꞌan nchkwiꞌ capitán kanꞌ ―ndukwin neꞌ ꞌin Jesús bra kanꞌ―: “Ja kuwe tiiꞌ lye ꞌaa, yu kula” ndukwin, “ja nꞌni chaꞌ kan wan naꞌan tyiǐn” ndukwin capitán. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Kanꞌ chaꞌ ja loꞌoǔn ndaꞌaǎn bra nu yaa neꞌ yaa tiꞌin neꞌ ꞌiin tsan” ndukwin. “Sa kanꞌ ti tñan nchka tiǎnꞌ, si kuloo tñan, chkaa msu ꞌñaǎn kwa ñaꞌan ti.” Ngwañaꞌan ndukwin capitán kanꞌ, chaꞌ chkwiꞌ ba loꞌoo ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Loꞌo ndukwin yu chaꞌ re ꞌwa: “Loꞌo naꞌ ni” ndukwin yu, “ndiya xka nu ndlo tñan ꞌñaǎn; loꞌo naꞌ ndloǔn tñan ꞌin sndaru nu ndiꞌin ꞌñaǎn” ndukwin. “Tsaa neꞌ lo kichen ꞌñaǎn, si kuloǔn tñan ꞌin neꞌ chaꞌ tsaa neꞌ; kan neꞌ seꞌen ndiꞌiǐn, si siꞌyaǎn ꞌin neꞌ chaꞌ kan neꞌ; bra ti kuꞌni msu ꞌñaǎn ya ñaꞌan ti tñan nu kuloǔn ꞌin yu” ndukwin capitán kanꞌ. “Kanꞌ chaꞌ ni, jlyo tiǎnꞌ chaꞌ ka ꞌiin kuloo tñan chaꞌ chkaa yu tiꞌí kanꞌ ꞌñaǎn.” Sa kanꞌ ti chaꞌ nchka tiꞌ capitán chkwiꞌ loꞌoo ―ndukwin neꞌ taꞌa suꞌwe capitán kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Bra wa ynan Jesús chaꞌ nu ykwiꞌ neꞌ loꞌo, nduwe ꞌa tiꞌ yu. Bra kanꞌ mxitukwi Jesús seꞌen ndijyan tuwiin, ykwiꞌ yu loꞌo nten nu ndaꞌan loꞌo yu: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús―, chaꞌ ja ya ñaꞌaǎn ꞌin ska nten nu suꞌwe ꞌa ndyaa ñaꞌan tiꞌ ꞌin Ndiose sa ñaꞌan nu ndyaa ñaꞌan tiꞌ capitán kanꞌ. Tyukwi ñaꞌaan nasiyun Israel re, ja nsuꞌwi nten nu ndyaa ñaꞌan tiꞌ ꞌñaǎn ngwañaꞌan ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Loꞌo kanꞌ mxitukwi taꞌa suꞌwe nsuꞌwi capitán kanꞌ, ndyaa neꞌ seꞌen ndukwa naꞌan tyi yu kula kanꞌ. Bra kanꞌ naꞌan neꞌ chaꞌ wa nchkaa msu nu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chunꞌ ndiꞌin la ndyaa Jesús nde ska kichen seꞌen naan Naín; ndyaa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu, loꞌo kaꞌan ꞌa nten ndyaa loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wa ndiya neꞌ tuꞌwa kichen kanꞌ, bra kanꞌ naꞌan neꞌ chaꞌ ndyaa loꞌo neꞌ kichen kanꞌ ꞌin ska ayman chaꞌ wa katsiꞌ. Sñiꞌ ska nu kunaꞌan tiꞌi lka ayman kanꞌ; wa nganun nu kunaꞌan kanꞌ xka ti chaꞌ ngujwi sñiꞌ, chaꞌ ska ti sñiꞌ kiꞌyu nsuꞌwi nu kunaꞌan kanꞌ, loꞌo wa ngujwi yu ni. Tyun ꞌa neꞌ kichen kanꞌ mdaꞌan neꞌ loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bra nu naꞌan Jesús nu nka Xꞌnaan ꞌin ayman kanꞌ, ngwa tꞌnan ꞌa tiꞌ yu ꞌin nu kunaꞌan tiꞌi jyaꞌan ayman kanꞌ. Bra kanꞌ ykwiꞌ yu loꞌo: ―Ja kunaan ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Bra kanꞌ yaa Jesús seꞌen ndiꞌin neꞌ kanꞌ, mstya yaꞌ yu chunꞌ kaꞌ seꞌen nsuꞌwi ayman. Bra kanꞌ yaa tuun neꞌ nu ndiꞌya ꞌin ayman kanꞌ, ykwiꞌ Jesús loꞌo ayman kanꞌ: ―Yu kuneꞌ ―ndukwin―, ¡tukwii lyaa! ");
INSERT INTO ctpNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Bra ti mdyitukwa ayman kanꞌ, mdyisnan yu ykwiꞌ yu loꞌo neꞌ bra kanꞌ. Xiyaꞌ ndya Jesús ꞌin yu kuneꞌ kanꞌ ꞌin jyaꞌan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yuwe ꞌa tiꞌ nchga nten la kanꞌ, chaꞌ naꞌan neꞌ ꞌin yu nu ngujwi kanꞌ. Bra kanꞌ mdyisnan neꞌ yꞌni tnun neꞌ ꞌin Ndiose. ―Tnun ꞌa chaꞌ ndiꞌin ꞌin yu nu wa mdiyan seꞌen ndiꞌian ni ―ndukwin neꞌ―, kanꞌ lka nu nchkwiꞌ nchga chaꞌ ꞌin Ndiose loꞌoan. Ngwañaꞌan ndukwin neꞌ bra kanꞌ. Loꞌo xka chaꞌ ykwiꞌ neꞌ: ―Wa mdiyan Ndiose ni, chaꞌ tayaꞌ Ni ꞌin nten ꞌin Ni ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Wa lye ꞌa nganen nchga chaꞌ tnun nu yꞌni Jesús nde nchga kichen lo yuu ꞌin Judea; ngwañaꞌan tyun kichen nu ndiꞌin tijyuꞌ la nganen chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wa ynan Xuwa sa ñaꞌan chaꞌ nu ngwa nde kwa, chaꞌ yu kuneꞌ nu ndaꞌan loꞌo Xuwa, kanꞌ lka nu ytsaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Bra kanꞌ msiꞌya Xuwa ꞌin tukwa yu kuneꞌ taꞌa ndaꞌan yu kanꞌ. Ngulo yu tñan ꞌin neꞌ chaꞌ tsaa kunichaꞌ neꞌ ꞌin Jesús si chañi chaꞌ ykwiꞌ yu lka yu Krixtu, nten nu tnun nchka nu wa suꞌwa ti Ndiose chaꞌ kan lo chalyuu; o ta ti ndiꞌin chaꞌ kata la chinꞌ neꞌ sa ñaꞌan bra nu kan xka nten nu tnun la chaꞌ ndiꞌin ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Bra kanꞌ ndyaa nten ꞌin Xuwa seꞌen ndiꞌin Jesús, chaꞌ chkwiꞌ neꞌ loꞌo yu: ―Wa ngulo Xuwa nu ndukwatya ꞌin nten tñan ꞌwa chaꞌ ndijyan ba ―ndukwin neꞌ―, chaꞌ kunichaꞌ ba ꞌiin: ¿Ta chañi chaꞌ ti kwiꞌ Krixtu lka nuꞌwin a? ¿Ta nuꞌwin lka nten nu tnun nchka nu wa suꞌwa ti Ndiose chaꞌ kan lo chalyuu re a? ¿O ta ti ndiꞌin chaꞌ kata la ba ꞌin xka nten nu tnun la chaꞌ ndiꞌin ꞌin a? Nchka tiꞌ ba chaꞌ kaja chaꞌ nu ñi ꞌwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Bra nu ndiꞌin neꞌ kanꞌ seꞌen ndiꞌin Jesús, bra kanꞌ yꞌni Jesús joꞌó ꞌin tyun neꞌ tiꞌí. Mdiya neꞌ nu wa sꞌni msñi kicha ꞌin, loꞌo mdiya nu sa ndijin ti kicha ꞌin, loꞌo nu msñi kwiꞌin kuxi ꞌin; bra ti nchkaa neꞌ kanꞌ. Loꞌo neꞌ kwityiinꞌ, yꞌni Jesús chaꞌ ngalaa kiloo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Kanꞌ chaꞌ mxkwen Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―Yaa lya wan katsaꞌ wan ꞌin Xuwa kwa nchga chaꞌ nu wa naꞌan wan seꞌen ndiꞌiǐn, nchga chaꞌ nu wa ynan wan nde re. Katsaꞌ wan ꞌin yu chaꞌ xiyaꞌ ngalaa kiloo tyun nten nu ngwa kwityiinꞌ; bra kanꞌ suꞌwe ꞌa ndaꞌan neꞌ nu tiꞌí kiyaꞌ; kwiꞌ ngwañaꞌan, wa luwi kunaꞌ neꞌ nu ngutsuꞌ kunaꞌ; loꞌo ni, wa nnan suꞌwe neꞌ nu ngwa kuꞌun tunskan; loꞌo nten nu wa ngujwi, ndyuꞌu neꞌ xiyaꞌ; loꞌo neꞌ tiꞌi ni, nnan neꞌ chaꞌ suꞌwe nu nchkwiǐnꞌ loꞌo neꞌ sa ñaꞌan ndlaa Ndiose ꞌin nten ꞌin nchga chaꞌ kuxi. Ngwañaꞌan nchkwin wan ꞌin Xuwa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Si nu ja ka jyuꞌu tiꞌ wan ñaꞌan wan ꞌñaǎn, ka suꞌwe kasiya ꞌwan bra kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Bra kanꞌ mxitukwi neꞌ ndyaa neꞌ, nten nu wa mnin Xuwa ꞌin chaꞌ yan kanꞌ. Bra kanꞌ mdyisnan Jesús ykwiꞌ chaꞌ ꞌin Xuwa kanꞌ loꞌo nten nu nganun seꞌen ndiꞌin. ―¿Sa ñaꞌan nan nxkeꞌ tiꞌ wan a? Wa yaa naꞌan wan ꞌin Xuwa kanꞌ nu ngwa xkanꞌ nde niꞌ kixinꞌ seꞌen ja ndiꞌin nten ―ndukwin Jesús―. ¿Nxkeꞌ tiꞌ wan chaꞌ tukwa chaꞌ nka tiye yu bra nu nchkwiꞌ yu loꞌo nten a? Wa jlyo tiꞌ wan chaꞌ nchkii yka kii bra nu nchka kwiꞌin, nchkii taꞌa tyukwaa laꞌa. ¿Ta ngwañaꞌan mskeꞌ tiꞌ wan xa nu naꞌan wan ꞌin yu a? ");
INSERT INTO ctpNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Sa ñaꞌan nan mskeꞌ tiꞌ wan bra nu naꞌan wan ꞌin yu kanꞌ sikwa a? ¿Ta suꞌwe ꞌa steꞌ yu bra nu naꞌan wan ꞌin yu la kanꞌ a? Wa jlyo tiꞌ wan chaꞌ siꞌi niꞌ kixinꞌ ndiꞌin nten nu suꞌwe ꞌa steꞌ, siꞌi niꞌ kixinꞌ ndiꞌin nten nu nsuꞌwi ꞌa tñi ꞌin neꞌ chaꞌ kwiji neꞌ kwa ñaꞌan ti; naꞌan tyi neꞌ kuliyaꞌ nu lka ree, la kanꞌ ndiꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ja chan mgii tiꞌ wan chaꞌ lka Xuwa kanꞌ ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. Chañi chaꞌ lka yu ngwañaꞌan, loꞌo ni, tlyu la tñan mjwi ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nde lka chaꞌ nu ndukwa lo kityi kula chaꞌ ꞌin tñan nu nsuꞌwi ꞌin Xuwa kanꞌ: Kuloǔn tñan ꞌin ska msu ꞌñaǎn chaꞌ tsaa yu nde loo la ꞌiin seꞌen tsaa, chaꞌ tsaa yu slaa lya yu tuwiin seꞌen nu tsaa ykwiiꞌ, ndukwin Ndiose ꞌin Krixtu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ti nchkwiꞌ la Jesús loꞌo neꞌ bra kanꞌ: ―Chaꞌ nu ñi nchkwiǐnꞌ loꞌo wan chaꞌ ꞌin Xuwa nu ndukwatya ꞌin nten, chaꞌ ja ya xuꞌwi ska nten chalyuu nu tnun la tñan nchka ꞌin, sa ñaꞌan tñan nu lka Xuwa kanꞌ. Bra kanꞌ wa ndijyaǎn chaꞌ kaǎn ndloo niꞌ kasiya ꞌin nten. Loꞌo ni, nchga nten nu tsaa ñaꞌan tiꞌ ꞌñaǎn, tnun la chaꞌ nchka ꞌin neꞌ kanꞌ ke Xuwa, ni siya tiꞌi ti neꞌ, ni siya kuneꞌ ti neꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Bra kanꞌ nten nu wa yaa seꞌen ndiꞌin Xuwa chaꞌ tukwatya yu ꞌin neꞌ ti ngwa xkanꞌ la, bra wa ynan neꞌ chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ, bra kanꞌ yꞌni tnun nchga neꞌ kanꞌ ꞌin Ndiose, loꞌo neꞌ kuxi nu ndlo tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ, loꞌo xka ta nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kwi ngwañaꞌan, neꞌ fariseo loꞌo mstru nu nduꞌu chaꞌ joꞌo nu ja xlyaa chaꞌ tukwatya Xuwa ꞌin neꞌ nu ngwa bra kanꞌ, ja ngwiꞌya neꞌ kwenta ꞌin tñan nu ngiꞌni Ndiose chaꞌ nu ndayaꞌ Ni ꞌin nten. Bra kanꞌ xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","―Ja suꞌwe sa ñaꞌan nu ngiꞌni nten chalyuu ni ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Sa ñaꞌan ngiꞌni nu xuwe nu ndiꞌin jya ti jluꞌwe kichen, ngwañaꞌan ngiꞌni nten chalyuu ni. Nchka ndaja tiꞌ nu xuwe ñaꞌan ꞌin taꞌa ndiꞌin jya neꞌ, chaꞌ ja nchka ꞌa tiꞌ taꞌa neꞌ tyiꞌin jya neꞌ loꞌo neꞌ. Bra kanꞌ nxiꞌya nu xuwe ꞌin taꞌa ndiꞌin jya: “¿Ni chaꞌ lka ja xlyaa wan kula kiyaꞌ wan a? Nan ngala ba chinꞌ jiin loꞌo kuwi kii chaꞌ ꞌwan” ndukwin nu xuwe ꞌin taꞌa. “¿Ni chaꞌ lka ja xlyaa wan ka xiꞌin tiꞌ wan loꞌo ba a? Nan ngala ba jiin xiꞌin, nan nganan ba ndiꞌin ba” ndukwin nu xuwe ꞌin taꞌa ndiꞌin jya. Loꞌo ꞌwan ―ndukwin Jesús―, ti kwiꞌ ngwañaꞌan ngiꞌni wan, ꞌwan nu lka wan nten chalyuu ni; xkwiꞌ chaꞌ ndaja tiꞌ wan ꞌin taꞌa nten wan seꞌen ndiꞌin wan, chaꞌ ja suꞌwe nka tiye wan siyaꞌ ti ñaꞌan wan ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nde ndlyuu ti nchkwiꞌ wan ―ndukwin Jesús ꞌin neꞌ―. Bra nu yan Xuwa nu ndukwatya ꞌin nten chalyuu, ja yku yu loꞌo wan, ja yiꞌo yu xalyu loꞌo wan; bra kanꞌ ndukwin wan chaꞌ nsuꞌwi kwiꞌin xaꞌan ꞌin yu ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chunꞌ ndiꞌin la msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten; suꞌwa ti nchkuǔn loꞌo wan bra kanꞌ, suꞌwa ti ndiꞌiǐn loꞌo wan naꞌan tyi wan. Kanꞌ chaꞌ nchkwiꞌ wan ꞌñaǎn: “Ñaꞌaan sa ñaꞌan nu ngiꞌni yu kwa ni” ndukwin wan ꞌin taꞌa wan, “xkwiꞌ nan nchku ti yu kwa nchka tiꞌ yu, xkwiꞌ nan kuꞌwi ti yu ndaꞌan yu. Ja suꞌwe yu kwa chaꞌ lka yu taꞌa suꞌwe nsuꞌwi neꞌ kuxi nu ndlo tñi ꞌñaan, loꞌo xka ta neꞌ kuxi kanꞌ lka taꞌa suꞌwe nsuꞌwi yu” ndukwin wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ndukwin wan chaꞌ ja suꞌwe chaꞌ nu nchkwiǐnꞌ; kanꞌ chaꞌ nde loo la ka biyaꞌ tiꞌ wan chaꞌ nu chañi ꞌa lka chaꞌ nu nchkwiꞌ nten ꞌñaǎn, chaꞌ nu tñan ꞌin Ndiose ndijyaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Mdiya ska yu fariseo nu ykwiꞌ loꞌo Jesús chaꞌ tsaa ku tlyaa loꞌo yu naꞌan tyi yu. Loꞌo neꞌ fariseo kanꞌ ni, kti ꞌa ngiꞌni neꞌ, mskeꞌ tiꞌ neꞌ. Bra kanꞌ yaa Jesús seꞌen ndukwa naꞌan tyi yu, yaa tukwa yu tuꞌwa msaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ti kwiꞌ kichen kanꞌ mdiꞌin ska nu kunaꞌan nu kaꞌan ꞌa kiꞌyu nsuꞌwi ꞌin. Bra nu ngwa biyaꞌ tiꞌ nu kunaꞌan kanꞌ, chaꞌ wa mdiyan Jesús ku tlyaa seꞌen ndiꞌin yu fariseo kanꞌ, bra kanꞌ chaꞌ ꞌin ti nu kunaꞌan kanꞌ yaa seꞌen ndiꞌin Jesús; mdiyan loꞌo ska teꞌén lyuꞌ ti sete nu xi ꞌa tyiꞌi. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Yaa tukwa nu kunaꞌan kanꞌ lyuu kwiꞌ seꞌen ti seꞌen ndukwa kiyaꞌ Jesús bra kanꞌ. Nganan ꞌa nu kunaꞌan kanꞌ, ngalu tyiꞌa kiloo chunꞌ kiyaꞌ Jesús; bra kanꞌ msuweꞌ kichanꞌ ke kiyaꞌ yu chaꞌ xtyi kiyaꞌ yu. Ykwichaꞌ nu kunaꞌan kanꞌ kiyaꞌ Jesús bra kanꞌ, mdyii sete xi kanꞌ mslu chunꞌ kiyaꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Loꞌo yu fariseo nu wa ykwiꞌ loꞌo Jesús chaꞌ tsaa ku tlyaa seꞌen ndiꞌin yu, bra wa naꞌan yu ꞌin nu kunaꞌan kanꞌ, kanꞌ mdaꞌan chaꞌ tiye yu bra kanꞌ: “Ja chañi chaꞌ lka yu re ska nten nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. Si kwiꞌ kanꞌ lka yu, bra kanꞌ ja chan kiꞌya yu kwenta sa ñaꞌan lka nu kunaꞌan nu nxtya yaꞌ chunꞌ kiyaꞌ yu ni; ka biyaꞌ tiꞌ yu chaꞌ ska nu kunaꞌan nu chen ꞌa ñaꞌan ngiꞌni ndiꞌin lo chalyuu lka nu kunaꞌan kwa.” ");
INSERT INTO ctpNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Bra kanꞌ mdyisnan Jesús ykwiꞌ yu loꞌo yu fariseo kanꞌ: ―Simón, ndiya ska chaꞌ nu chkwiǐnꞌ loꞌoo ―ndukwin Jesús ꞌin yu. ―Katsaaꞌ lyaa ꞌñaǎn, yu kula ―ndukwin yu fariseo ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","―Mdiya tukwa nten nu ndukwi tneꞌ, chaꞌ mjñiꞌ neꞌ tñi ꞌin ska yu kuliyaꞌ ―ndukwin Jesús ꞌin yu fariseo kanꞌ―. Ska yu ndukwi yu kaꞌan ꞌa tñi ꞌin yu kuliyaꞌ kanꞌ, xka yu ndukwi yu chinꞌ la ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Taꞌa tyukwaa yu ja ngwa ꞌin yu tya yu tñi ꞌin yu kuliyaꞌ kanꞌ bra kanꞌ. Kanꞌ chaꞌ nchka tꞌnan tiꞌ yu kuliyaꞌ kanꞌ ꞌin taꞌa tyukwaa yu kanꞌ; yꞌni tyii yu kwenta ꞌin yu kanꞌ ngwañaꞌan ti. Katsaaꞌ lyaa ꞌñaǎn sikwa ―ndukwin Jesús ꞌin yu fariseo kanꞌ―, ¿ti ka lka nu suꞌwe la nka tiye ñaꞌan ꞌin yu kuliyaꞌ kanꞌ a? ¿Si ska yu, o ta xka yu a? ");
INSERT INTO ctpNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Bra kanꞌ mxkwen Simón ꞌin Jesús: ―Nu ndukwi kaꞌan la, kanꞌ lka; chunꞌ lye la yꞌni nu kuliyaꞌ kanꞌ chaꞌ tlyu tiꞌ ꞌin. Ngwañaꞌan lka kanꞌ ―ndukwin Simón. ―Chañi chaꞌ nchkwiiꞌ ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Naꞌan ꞌa Jesús seꞌen ndiꞌin nu kunaꞌan kanꞌ, bra kanꞌ xiyaꞌ ykwiꞌ yu loꞌo Simón kanꞌ: ―Kiꞌyaa chinꞌ kwenta sa ñaꞌan nu ngiꞌni nu kunaꞌan re ―ndukwin―. Bra nu mdiyaǎn niꞌ ñaꞌan re tsan, nuꞌwin ja mdaa tyiꞌa katen kiyaǎnꞌ; loꞌo ni, wa mjyaꞌan nu kunaꞌan re kiyaǎnꞌ loꞌo tyiꞌa kiloo, wa mxtyi nu kunaꞌan re kiyaǎnꞌ loꞌo kichanꞌ ke ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kwiꞌ ngwañaꞌan, nuꞌwin ja ykwichaaꞌ ꞌñaǎn bra nu mdiyaǎn niꞌ ñaꞌan re; loꞌo nu kunaꞌan re, ti bra mdiyaǎn niꞌ ñaꞌan re, ja ya tyii chkwichaꞌ kiyaǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ngwañaꞌan ja msluu sete keěn tsan; loꞌo ni, wa mslu nu kunaꞌan re sete xi chunꞌ kiyaǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nde lka chaꞌ nu katsaǎnꞌ ꞌiin ni, chaꞌ suꞌwe la nchka tꞌnan tiꞌ nu kunaꞌan re ꞌñaǎn, kanꞌ chaꞌ ka biyaꞌ tiiꞌ chaꞌ wa yꞌni tyii Ndiose kiꞌya nu ndukwi, ni siya kaꞌan ꞌa kiꞌya mdiꞌin ꞌin tloo Ndiose. Loꞌo nten nu ja ndiꞌin lye kiꞌya ꞌin chaꞌ kuꞌni tyii Ndiose ꞌin ran, chinꞌ la chaꞌ nduwe tiꞌ neꞌ kanꞌ ñaꞌan neꞌ ꞌin Ndiose ―ndukwin Jesús ꞌin Simón. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Bra kanꞌ ykwiꞌ Jesús loꞌo nu kunaꞌan kanꞌ: ―Wa yꞌni tyii Ndiose nchga kiꞌya nu mdiꞌin ꞌiin ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bra kanꞌ nten nu suꞌwa ti mdiyan loꞌo Jesús chaꞌ ku tlyaa neꞌ seꞌen ndiꞌin Simón, mdyisnan neꞌ kanꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―¿Ti ka nu lka yu kiꞌyu re a? ¿La nde mjwi chabiyaꞌ ꞌin yu chaꞌ kuꞌni tyii yu kiꞌya nu ndiꞌin ꞌin nten a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Loꞌo ykwiꞌ Jesús loꞌo nu kunaꞌan kanꞌ bra kanꞌ: ―Wa mdyii chaꞌ kuxi nu ndiꞌin ꞌiin chunꞌ ndyaa ñaꞌan tiiꞌ ꞌñaǎn. Tiin ti tyiꞌin niꞌ kasiya ꞌiin, tyaa lyaa ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chunꞌ ndiꞌin la, mdoꞌo Jesús ndyaa yu tyun kichen, loꞌo kichen tnun, loꞌo kichen xuwe ti. Ykwiꞌ ꞌa yu chaꞌ suꞌwe ꞌin Ndiose loꞌo neꞌ kichen kanꞌ; ykwiꞌ yu chaꞌ wa ndijyan Ndiose chaꞌ ka Ni ndloo niꞌ kasiya ꞌin nten. Suꞌwa mdaꞌan Jesús loꞌo tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Loꞌo tyun neꞌ kunaꞌan ndyaa loꞌo neꞌ kanꞌ; tiꞌí ꞌa ngwa neꞌ kunaꞌan kanꞌ nu ngwa sꞌni la, bra kanꞌ yꞌni Jesús chaꞌ nchkaa neꞌ, loꞌo wa ngulo yu kwiꞌin kuxi nu nsuꞌwi ꞌin neꞌ kanꞌ. Ndaꞌan ska nu kunaꞌan nu naan Liya Magdalena loꞌo neꞌ, wa mdoꞌo kati loo kwiꞌin kuxi ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Loꞌo kanꞌ Xnan naan xka nu ndaꞌan loꞌo neꞌ; kwilyoꞌo ska yu naan Chuza lka Xnan kanꞌ, ska yu nu lka ndloo chaꞌ ꞌin ree Herodes lka yu Chuza kanꞌ. Ngwañaꞌan Susana, loꞌo ti tyun la neꞌ kunaꞌan nu ndayaꞌ ꞌin Jesús loꞌo nan nu nsuꞌwi ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Bra kanꞌ kaꞌan ꞌa nten kichen kanꞌ mdoꞌo neꞌ ndyaa naꞌan neꞌ ꞌin Jesús. Bra wa mdyoꞌ tiꞌin nten kaꞌan kanꞌ sa tlyu ti, bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ. Nde lka chaꞌ nu ngwaꞌu yu ꞌin neꞌ kanꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Wa ndyaa ska nten kata mta trigu ꞌin yu. Katsaǎnꞌ ꞌwan sa ñaꞌan ngwa bra nu msnen yu mta kanꞌ: Ngalu chinꞌ mta kanꞌ tuwiin seꞌen ndijin nten, ngwoꞌo sta neꞌ mta kanꞌ bra kanꞌ, loꞌo yan kiñi yku ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xka ta mta kanꞌ ngalu seꞌen nu chinꞌ ꞌa yuu nskwa chunꞌ kee. Bra nu mtsu mta kanꞌ, ja ngwa kaluu suꞌwe kala kanꞌ, chunꞌ ja kiꞌñi yaa suun ran; mdyii kala kanꞌ ngwityi ran bra kanꞌ, chaꞌ ja mjwi seꞌen tsaa suun ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xka ta mta kanꞌ ngalu seꞌen mdukwa yka kicheꞌ nu ngwa xkanꞌ; bra kanꞌ bra ti ndyukwa kuten yka kicheꞌ kanꞌ xiyaꞌ, sa ñaꞌan yaꞌ nu ja mda ꞌa ran seꞌen kaluu kala trigu kanꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xka ta mta kanꞌ ngalu seꞌen nu suꞌwe ꞌa yuu; suꞌwe ꞌa ngaluu kala kanꞌ, kaꞌan ꞌa mta mdoꞌo lo juun ran bra kanꞌ. Seꞌen nu yta yu ska mlya ti mta trigu, kanꞌ nu suꞌwe ꞌa mdoꞌo; sa yaꞌ ska siyentu mlya mta mdoꞌo bra kanꞌ. Bra wa mdyii ykwiꞌ Jesús chaꞌ kanꞌ loꞌo neꞌ, bra kanꞌ kwen ꞌa ykwiꞌ yu: ―Kunan suꞌwe wan si chañi chaꞌ nchka tiꞌ wan kunan wan chaꞌ suꞌwe nu nchkwiǐnꞌ loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Bra kanꞌ mnichaꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús kanꞌ sa ñaꞌan ndyoꞌo chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―ꞌWan nu ndaꞌan wan loꞌoǔn, ndayaꞌ ꞌa Ndiose ꞌwan chaꞌ nchka biyaꞌ tiꞌ wan nchga chaꞌ nu yuꞌwi nchkunꞌ ti nu ngwa sꞌni; kanꞌ chaꞌ ka ꞌwan ka biyaꞌ tiꞌ wan sa ñaꞌan kulo Ndiose tñan ꞌin nten. Xka ta nten ni, xkwiꞌ chaꞌ kutsiꞌ ti nchkwiǐnꞌ loꞌo neꞌ bra nu chkwiǐnꞌ ska chaꞌ tiya loꞌo neꞌ, chaꞌ ngwañaꞌan ja ka biyaꞌ tiꞌ neꞌ, ni siya naꞌan neꞌ nu ngwa xkanꞌ; ja ska chaꞌ kanun ke neꞌ, ni siya wa ynan neꞌ nu ngwa xkanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Nde lka sa ñaꞌan ndyoꞌo chaꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ―. Sa ñaꞌan lka mta nu wa msnen yu kanꞌ, ngwañaꞌan lka chaꞌ suꞌwe nu nchkwiꞌ Ndiose loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sa ñaꞌan lka ska ta mta nu ngalu tuwiin kanꞌ, ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe kanꞌ nu ngwa xkanꞌ, loꞌo kanꞌ bra ti ndijyan kuneꞌ xaꞌan chaꞌ kuꞌni tyii chaꞌ suꞌwe nu nsuꞌwi niꞌ kasiya ꞌin neꞌ kanꞌ; ja ndyuꞌwi ꞌa tiꞌ neꞌ chaꞌ suꞌwe kanꞌ bra kanꞌ, ja nchka tyoꞌo laa neꞌ kanꞌ ꞌin chaꞌ kuxi ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sa ñaꞌan lka xka ta mta nu ngalu lo yuu seꞌen lti ti tuꞌwa yuu chunꞌ kee kanꞌ, ngwañaꞌan lka nten nu suꞌwe ꞌa nka tiye neꞌ bra nu ynan neꞌ chaꞌ suꞌwe kanꞌ ti kulo. Bra kanꞌ sa ñaꞌan lka kala xuwe kanꞌ, chaꞌ ja kiꞌñi yaa suun ran lo kee kanꞌ, ngwañaꞌan lka nten kanꞌ, chaꞌ chinꞌ ti bra ndalo neꞌ chaꞌ msñi neꞌ chaꞌ suꞌwe kanꞌ; bra nu ñaꞌan xka ta nten ꞌin neꞌ kanꞌ, ndla ti kulaa yaꞌ neꞌ chaꞌ suꞌwe kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sa ñaꞌan lka chaꞌ ꞌin mta nu ngalu laja yka kicheꞌ kanꞌ, ngwañaꞌan lka nten nu wa ynan chaꞌ suꞌwe kanꞌ nu ngwa xkanꞌ; loꞌo kanꞌ ndiꞌin ꞌa tñan ꞌin neꞌ, ndiꞌin ꞌa tñi ꞌin neꞌ, loꞌo nsuꞌwi ꞌa seꞌen kwiji neꞌ tñi chaꞌ ꞌin ti neꞌ; kanꞌ chaꞌ ja nchka kanun suꞌwe chaꞌ suꞌwe kanꞌ niꞌ kasiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sa ñaꞌan lka mta nu ngalu seꞌen nu suꞌwe ꞌa yuu kanꞌ, ngwañaꞌan lka nten nu tyukwi ti tiye neꞌ nnan neꞌ chaꞌ suꞌwe nu nchkwiꞌ Ndiose loꞌo neꞌ; xlyaa neꞌ tukwa neꞌ nchga chaꞌ nu nchkwiꞌ Ndiose loꞌo neꞌ. Ndalo neꞌ kanꞌ bra kanꞌ, ja ndaꞌan chunꞌ neꞌ chaꞌ wa msñi neꞌ chaꞌ kanꞌ. Loꞌo bra kanꞌ suꞌwe ꞌa chaꞌ nsuꞌwi niꞌ kasiya ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ja tukwin xtya xaa niꞌ ñaꞌan ꞌin, chaꞌ tukunꞌ neꞌ ꞌin xaa kanꞌ chunꞌ ndiꞌin la; ti kwiꞌ ti chaꞌ, ja xtya neꞌ ska xaa ska niꞌ kiꞌyan ti. Ja ngiꞌni neꞌ ngwañaꞌan. Nxtya neꞌ xaa ska seꞌen nu kwan, chaꞌ xuꞌwi xaa chaꞌ ka ñaꞌan neꞌ nchga nan nu ndiꞌin niꞌ ñaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nchga chaꞌ nu nsuꞌwi nchkunꞌ ꞌin nten ni, tyija lyo chaꞌ kanꞌ ꞌin neꞌ chunꞌ ndiꞌin la; nchga chaꞌ nu nsuꞌwi mnan ti ni, tyija chaꞌ kanꞌ ꞌin neꞌ chunꞌ ndiꞌin la, chaꞌ ka biyaꞌ tianꞌ chaꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Kanꞌ chaꞌ kunan suꞌwe wan sikwa. Nten nu ndyaa ñaꞌan tiꞌ chaꞌ nu ngiꞌni xaꞌan neꞌ chaꞌ ꞌin Ndiose ni, ti chkwiꞌ la Ndiose loꞌo neꞌ kanꞌ; loꞌo kanꞌ, nten nu ja ndyaa ñaꞌan tiꞌ chaꞌ kanꞌ, nu ja nchka tiꞌ kuꞌni xaꞌan chaꞌ kanꞌ, kuꞌni Ndiose chaꞌ ja ka ꞌin neꞌ kanꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌin Ndiose siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Bra kanꞌ mdiyan jyaꞌan Jesús, ndijyan loꞌo yu kiꞌyu taꞌa yu, mdiyan neꞌ seꞌen ndiꞌin yu bra kanꞌ. Ja ngwa kan neꞌ kwiꞌ seꞌen ndiꞌin yu, chaꞌ kaꞌan ꞌa nten ndiꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kanꞌ chaꞌ ndyaa rsun nde seꞌen nduun Jesús bra kanꞌ: ―Chunꞌ naꞌan nduun jyaꞌaan loꞌo taꞌaa. Nchka tiꞌ neꞌ chkwiꞌ neꞌ loꞌoo ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Bra kanꞌ mxkwen Jesús ꞌin neꞌ: ―Nten nu nnan chaꞌ nu nchkwiꞌ Ndiose loꞌo neꞌ, loꞌo ngiꞌni neꞌ kanꞌ nchga tñan nu ndlo Ni ꞌin neꞌ, sa ñaꞌan si lka neꞌ jyaꞌaǎn, sa ñaꞌan si lka neꞌ taꞌaǎn, ngwañaꞌan lka neꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ngwa ska tsan mdoꞌo Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa neꞌ tuꞌwa tiyuꞌ. Bra kanꞌ yten neꞌ ska niꞌ yka naꞌan xuwe ti ndyaa neꞌ. ―Tsaan xka laꞌa tsuꞌ tiyuꞌ re ―ndukwin Jesús ꞌin neꞌ. Ndyaa neꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Bra nu ti ndiꞌin neꞌ niꞌ yka naꞌan kanꞌ lo tyiꞌa, yuꞌwi ꞌa sla Jesús; bra ti yijaꞌ yu chinꞌ. Bra kanꞌ lye ꞌa mdyisnan kwiꞌin mskwa loo tiyuꞌ kanꞌ. Loꞌo lye ꞌa ngatsa kulooꞌ loo tyiꞌa tiyuꞌ bra kanꞌ, yten tyiꞌa niꞌ yka naꞌan kanꞌ, sa wa sten ti yka naꞌan kanꞌ niꞌ tyiꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Bra kanꞌ ndyaa mlyo neꞌ sla Jesús nde seꞌen nskwa yu lajaꞌ yu. Ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―¡Yu kula, yu kula! ―ndukwin neꞌ ꞌin yu―, ¡xaa tiiꞌ! ¡Wa sten ti yka naꞌan re niꞌ tyiꞌa, kajaan bra kanꞌ! Mdyituun Jesús bra kanꞌ, ngulo yu tñan ꞌin kwiꞌin loꞌo kulooꞌ kanꞌ. Bra ti ngwa tiin ran bra kanꞌ; ja mskwa ꞌa kwiꞌin, ja ngutsa ꞌa kulooꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―¿Ni chaꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌin Ndiose chaꞌ ka ꞌin Ni kuꞌni Ni ngwañaꞌan a? ―ndukwin Jesús ꞌin neꞌ kanꞌ. Ytsen ꞌa neꞌ kanꞌ, yuwe ꞌa tiꞌ neꞌ ñaꞌan neꞌ ꞌin Jesús bra kanꞌ. ―¿Ti ka nu lka yu re a? ―ndukwin neꞌ ꞌin taꞌa neꞌ―, chaꞌ ynan kwiꞌin, ynan kulooꞌ chaꞌ nu nchkwiꞌ yu ―ndukwin neꞌ ꞌin taꞌa ngiꞌni xaꞌan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Laꞌa tiyuꞌ nde re, lo yuu ꞌin neꞌ Galilea lka; bra kanꞌ xka laꞌa tsuꞌ tiyuꞌ, lo yuu ꞌin neꞌ Gadara lka kanꞌ. Bra kanꞌ ndyaa neꞌ niꞌ yka naꞌan xuwe ti kanꞌ, mdiya neꞌ lo yuu ꞌin neꞌ Gadara bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Bra wa mdoꞌo neꞌ niꞌ yka naꞌan kanꞌ, bra kanꞌ ndyukwa taꞌa Jesús loꞌo ska yu kiꞌyu neꞌ Gadara nu msñi kwiꞌin xaꞌan ꞌin yu. Wa sꞌni nsuꞌwi kwiꞌin kanꞌ ꞌin yu; ti bra kanꞌ ja nchkuꞌ yu steꞌ yu, ja ndyiꞌin yu niꞌ ñaꞌan. Ndaꞌan yuꞌwi ti yu, ndyaꞌan yijaꞌ yu niꞌ lyoꞌoo seꞌen ndyuꞌwi ayman. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Bra wa naꞌan yu ꞌin Jesús, bra kanꞌ kwen ꞌa msiꞌya yu, mlyuu yu tloo Jesús. ―¿Nan lka kuꞌnii loꞌoǔn a?, yu kula Jesús ―ndukwin yu tiꞌí kanꞌ―. Jlyo tiǎnꞌ chaꞌ lkaa Sñiꞌ Ndiose nu lka ndloo la ti. Kuꞌnii chaꞌ tlyu tiꞌ ꞌñaǎn, ja taa nu tiꞌí ꞌñaǎn ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ngwañaꞌan ykwiꞌ yu chaꞌ wa ngulo Jesús tñan ꞌin kwiꞌin xaꞌan kanꞌ, chaꞌ tyoꞌo kwiꞌin kanꞌ ꞌin yu. Ti ngwa sꞌni tyun yaꞌ mxlyuu kwiꞌin kanꞌ ꞌin yu; kanꞌ chaꞌ ndiꞌin nten kwan ꞌin yu, nchkanꞌ yaꞌ yu, nchkanꞌ kiyaꞌ yu loꞌo karenan chkwan. Loꞌo kanꞌ ja nduwe tiꞌ yu ꞌin karenan kanꞌ, bra ti nsiꞌyu kuꞌ yu chkwan kanꞌ. Kwiꞌ ngwañaꞌan, ndyaꞌan loꞌo kwiꞌin xaꞌan kanꞌ ꞌin yu, nxnan yu niꞌ kixinꞌ seꞌen ja ndiꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Bra nu ndyukwa taꞌa Jesús loꞌo yu tiꞌí kanꞌ, bra kanꞌ mnichaꞌ Jesús ꞌin yu: ―¿Ni sa ñaꞌan naan nuꞌwin a? ―ndukwin Jesús ꞌin yu. ―Kaꞌan ꞌa loo niǐn ―ndukwin yu tiꞌí kanꞌ ꞌin Jesús, chaꞌ kaꞌan ꞌa kwiꞌin xaꞌan yꞌni tiꞌí ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ntsen ꞌa kwiꞌin xaꞌan kanꞌ si kulo Jesús tñan ꞌin ran chaꞌ tyaa ran tuwiin seꞌen mdoꞌo ran nde niꞌ yuu. Kanꞌ chaꞌ yꞌni kwiꞌin chaꞌ mjñan yu tiꞌí kanꞌ ꞌin Jesús chaꞌ ja kulo yu tñan chaꞌ tyoꞌo kwiꞌin kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ti kwiꞌ tsan kanꞌ mdaꞌan ska ta tnun kuweꞌ siꞌ kiꞌya nu ndiꞌin kwiꞌ seꞌen ti kanꞌ. Bra kanꞌ mjñan yu tiꞌí kanꞌ chabiyaꞌ ꞌin Jesús chaꞌ kanun kwiꞌin xaꞌan kanꞌ loꞌo kuweꞌ. Mda Jesús chabiyaꞌ ꞌin kwiꞌin kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mdoꞌo kwiꞌin xaꞌan kanꞌ ꞌin yu tiꞌí kanꞌ, msñi ran ꞌin kuweꞌ bra kanꞌ. Bra ti msnan nchga kuweꞌ kanꞌ nde ska loo kwaꞌan kiꞌñi, mdiyuu iꞌ ndyaa iꞌ lo tyiꞌa tiyuꞌ; ngujwi iꞌ bra kanꞌ, chaꞌ yiꞌo iꞌ tyiꞌa tiyuꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bra wa naꞌan neꞌ chaꞌ kanꞌ, neꞌ nu mdaꞌan loꞌo kuweꞌ kanꞌ, msnan neꞌ ndyaa neꞌ bra kanꞌ. Ndyaa neꞌ nde kichen tyi neꞌ, ndyaa ytsaꞌ neꞌ chaꞌ kanꞌ ꞌin taꞌa kichen tyi neꞌ; loꞌo ytsaꞌ neꞌ ꞌin nchga nten nu ndiꞌin niꞌ kixinꞌ kwiꞌ seꞌen ti sa ñaꞌan ngwa chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bra kanꞌ mdoꞌo neꞌ kichen kanꞌ, mdiyan naꞌan neꞌ chinꞌ ꞌin yu kanꞌ, nan lka ngwa ꞌin yu. Bra wa mdiyan neꞌ seꞌen ndiꞌin Jesús, bra kanꞌ naꞌan neꞌ ꞌin yu kiꞌyu nu yuꞌwi kwiꞌin xaꞌan ꞌin, chaꞌ wa nchkaa yu; ndukuꞌ yu steꞌ yu, tiin ti ndukwa yu tloo Jesús. Ytsen ꞌa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Bra kanꞌ nten nu naꞌan bra nu ngulo Jesús kwiꞌin kanꞌ ꞌin yu, ytsaꞌ neꞌ kanꞌ ꞌin taꞌa neꞌ sa ñaꞌan ngwa chaꞌ nchkaa yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Bra kanꞌ lye ykwiꞌ nchga neꞌ kichen kanꞌ loꞌo Jesús chaꞌ tyoꞌo tsuꞌ yu, chaꞌ ja kanun ꞌa Jesús lo yuu kanꞌ; ytsen ꞌa neꞌ kichen kanꞌ. Kanꞌ chaꞌ mdoꞌo Jesús ndyaa yu niꞌ yka naꞌan xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Loꞌo yu kiꞌyu nu tka mdoꞌo ti kwiꞌin xaꞌan ꞌin, mjñan ꞌa yu ꞌin Jesús chaꞌ tsaa yu loꞌo Jesús niꞌ yka naꞌan bra kanꞌ; loꞌo ja mda Jesús chabiyaꞌ chaꞌ tsaa yu loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Yaa lyaa naꞌan tyii ―ndukwin Jesús ꞌin yu nu wa mꞌni kwiꞌin loꞌo kanꞌ―. Katsaaꞌ ꞌin nchga nten, nchga chaꞌ tnun nu wa yꞌni Ndiose loꞌoo. Ndyaa yu bra kanꞌ, ytsaꞌ yu chaꞌ kanꞌ ꞌin nchga nten taꞌa kichen tyi yu, nchga chaꞌ tnun nu wa yꞌni Jesús loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Bra kanꞌ mxitukwi Jesús ndyaan laꞌa tiyuꞌ nde re xiyaꞌ. Suꞌwe ꞌa ngwa tiye neꞌ kichen kanꞌ chaꞌ ngala yu xiyaꞌ; suꞌwe ꞌa ykwiꞌ neꞌ loꞌo yu, chaꞌ ngita ꞌa neꞌ ꞌin yu sa bra nu tyaan yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bra wa ngala Jesús, bra kanꞌ bra ti mdiyan ska yu kiꞌyu nu naan Jairo seꞌen ndiꞌin yu; yu kula lka yu kanꞌ, nu nduun loo la niꞌ lyaa lka yu kanꞌ. Mdiyan yu bra kanꞌ, mduun xtyinꞌ yu tloo Jesús, lye ꞌa mjñan yu kanꞌ chaꞌ tlyu tiꞌ ꞌin Jesús chaꞌ tsaa Jesús naꞌan tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ska ti sñiꞌ Jairo nsuꞌwi, ska nu kunaꞌan kuneꞌ nu nsuꞌwi tii tyukwa ti yijan. Loꞌo ni, tiꞌí ꞌa nu lyuꞌ kanꞌ, wa kaja ti. Kanꞌ chaꞌ ndyaa Jesús loꞌo yu kula kanꞌ, loꞌo kaꞌan ꞌa nten taꞌa ndaꞌan yu. Tkanꞌ ꞌa ndiꞌin nten tuwiin seꞌen ndyaa Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Laja nten kanꞌ ndyaa ska nu kunaꞌan nu tiꞌí ꞌa. Wa mdyii tii tyukwa yijan tiꞌí nu kunaꞌan kanꞌ, xkwiꞌ kicha nu ndiꞌya tnen nsuꞌwi ꞌin nu kunaꞌan kanꞌ. Wa mdyii tñi ꞌin nu kunaꞌan kanꞌ ngwiji, siyaꞌ neꞌ joꞌó, ja ska nten ngwa ꞌin kuꞌni joꞌó ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Loꞌo ni, yan nu kunaꞌan kanꞌ nde chunꞌ Jesús, ylaꞌ kiyaꞌ steꞌ yu; bra ti msiꞌyu kuꞌ chaꞌ ngalu tnen kanꞌ, bra ti nchkaa nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Bra kanꞌ mnichaꞌ Jesús ꞌin neꞌ nu mdaꞌan loꞌo: ―¿Ti ka nu ylaꞌ steěnꞌ a? ―ndukwin. Nchga nten ykwiꞌ chaꞌ ja tukwin ylaꞌ steꞌ Jesús. Kanꞌ chaꞌ loꞌo Tyu loꞌo xka ta taꞌa ndaꞌan yu, mxkwen neꞌ ꞌin Jesús bra kanꞌ: ―Yu kula ―ndukwin neꞌ―, nchga chuunꞌ tkanꞌ ꞌa ndiꞌin nten. Ni chaꞌ lka nchkwiiꞌ sikwa: “¿Ti ka nu ylaꞌ steěnꞌ a?” ");
INSERT INTO ctpNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bra kanꞌ xiyaꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―Chañi chaꞌ wa ylaꞌ ska nten ꞌñaǎn ―ndukwin―. Mgii tiǎnꞌ chaꞌ wa mdoꞌo chinꞌ chaꞌ tiya ꞌñaǎn chaꞌ wa yꞌniǐn joꞌó ꞌin ska nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Bra kanꞌ jlyo tiꞌ nu kunaꞌan kanꞌ, chaꞌ ngwa biyaꞌ tiꞌ Jesús chaꞌ kanꞌ, kanꞌ chaꞌ ytsaꞌ ꞌin yu; nchkwaan ti nu kunaꞌan kanꞌ ndijyan chaꞌ ytsen ꞌa. Bra kanꞌ mduun xtyinꞌ nu kunaꞌan kanꞌ tloo Jesús; tloo nchga nten nu nduun nde kwa ytsaꞌ ꞌin yu ni chaꞌ lka ylaꞌ steꞌ yu, loꞌo wa nchkaa bra ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Kanꞌ ykwiꞌ Jesús loꞌo nu kunaꞌan kanꞌ: ―Chaꞌ wa ndyaa ñaꞌan tiiꞌ chaꞌ ka ꞌin Ndiose kuꞌni chaꞌ tnun, kanꞌ chaꞌ wa nchkaa ni, sñiěnꞌ ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ―. Ja kuwe tiiꞌ, tyaa lyaa ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Laja nu nchkwiꞌ Jesús, bra kanꞌ mdiyan ska nten nu mdoꞌo naꞌan tyi Jairo, yu kula kanꞌ nu ka ndloo la niꞌ lyaa ꞌin neꞌ kanꞌ. Kwiꞌ yu kanꞌ mdiya ytsaꞌ yu ꞌin Jairo bra kanꞌ: ―Wa ngujwi sñiiꞌ, yu kula ―ndukwin yu―. Ja chkwiiꞌ ꞌa loꞌo yu kula kwa chaꞌ kan yu naꞌan tyii. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Loꞌo wa ynan Jesús chaꞌ nu ykwiꞌ yu loꞌo yu kula kanꞌ. ―Ja kutseen ―ndukwin Jesús―, ska ti si tsaa ñaꞌan tiiꞌ chaꞌ ka ꞌin Ndiose, bra kanꞌ ka suꞌwe sñiiꞌ ―ndukwin Jesús ꞌin Jairo. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Bra nu ngala neꞌ naꞌan tyi Jairo, bra kanꞌ ja mda Jesús chabiyaꞌ chaꞌ sten neꞌ sa tlyu ti loꞌo yu niꞌ ñaꞌan; wa lka ti nten sten loꞌo yu niꞌ ñaꞌan, ndukwin yu. ―Tyu, loꞌo Santiago, loꞌo Xuwa, loꞌo sti loꞌo jyaꞌan ti nu lyuꞌ kwa sten neꞌ niꞌ ñaꞌan re loꞌoǔn ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nganan ꞌa xka ta nten nu ndiꞌin chunꞌ naꞌan kanꞌ, chaꞌ wa ngujwi nu kunaꞌan lyuꞌ kanꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ja kunan wan ―ndukwin―. Siꞌi nan ngujwi nu lyuꞌ re, nan lajaꞌ ti re ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Mstyi lyoꞌo neꞌ ꞌin Jesús bra kanꞌ, chaꞌ jlyo tiꞌ neꞌ chaꞌ chañi chaꞌ wa ngujwi nu lyuꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Bra kanꞌ yten Jesús niꞌ ñaꞌan, msñi yu yaꞌ nu lyuꞌ kanꞌ, loꞌo kwen ꞌa ykwiꞌ yu loꞌo nu lyuꞌ bra kanꞌ: ―Tukwii lyaa, sñiěnꞌ ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Bra kanꞌ xiyaꞌ ngala tyiꞌi niꞌ kasiya ꞌin nu kunaꞌan lyuꞌ kanꞌ, bra ti mdyitukwi bra kanꞌ; ngulo Jesús tñan ꞌin neꞌ chaꞌ ta neꞌ nan ku nu lyuꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yuwe ꞌa tiꞌ neꞌ kula ꞌin nu lyuꞌ kanꞌ. Loꞌo kanꞌ ngulo Jesús tñan ꞌin neꞌ chaꞌ ja katsaꞌ neꞌ ꞌin xka la nten sa ñaꞌan ngwa chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Mxoꞌ tiꞌin Jesús ꞌin tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ ta yu chabiyaꞌ ꞌin neꞌ chaꞌ kulo neꞌ ꞌin nchga loo kwiꞌin kuxi nu msñi ꞌin nten, loꞌo kuꞌni neꞌ joꞌó ꞌin nchga loo kicha nu nsuꞌwi ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ngulo yu tñan ꞌin tii tyukwa neꞌ kanꞌ, chaꞌ kwaꞌu neꞌ chaꞌ suꞌwe ꞌin Ndiose ꞌin nten kichen seꞌen nu tsaa neꞌ, chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin nten; kwiꞌ ngwañaꞌan kuꞌni neꞌ chaꞌ chkaa neꞌ tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ja ska nan kwiꞌya wan tsaa wan tuwiin ―ndukwin yu ꞌin neꞌ―, ja loꞌo yka skan ꞌwan, ja loꞌo kwijin ꞌwan, ja loꞌo nan ku wan ꞌwan, ja loꞌo tñi ꞌwan, ja ska kanꞌ kwiꞌya wan tsaa wan ni. Ska ti xkanꞌ wan kwiꞌya wan tsaa wan, ja kwiꞌya wan xka la loo nan. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nchga naꞌan tyi neꞌ kichen seꞌen nu tiya wan ni, kanꞌ kanun wan sa ñaꞌan yaꞌ nu tyoꞌo wan kichen kanꞌ tyaa wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Si ndiya kichen seꞌen nu ja ndiya tiꞌ neꞌ chaꞌ nu nchkwiꞌ wan loꞌo neꞌ, seꞌen nu ja nchka tiꞌ neꞌ chaꞌ kanun wan seꞌen ndiꞌin neꞌ, bra ti tyoꞌo wan tsaa wan xka kichen. Skwin wan kiyaꞌ wan chaꞌ kalu yuu nu msñi snan wan bra nu tyoꞌo wan kichen kanꞌ; chunꞌ chaꞌ kanꞌ, ka biyaꞌ tiꞌ neꞌ kichen kanꞌ chaꞌ kuxi ꞌa tñan nu yꞌni neꞌ loꞌo wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ, mdaꞌan neꞌ nchga kichen xuwe ti. Bra kanꞌ ngwaꞌu neꞌ ꞌin neꞌ kichen kanꞌ sa ñaꞌan ndlaa Ndiose ꞌin nten ꞌin nu kuxi; loꞌo yꞌni neꞌ joꞌó ꞌin neꞌ tiꞌí nu ndiꞌin nchga kichen kanꞌ, loꞌo nchkaa neꞌ tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nu ngwa tyempu kanꞌ Herodes naan nu lka gobernador. Wa ynan yu chaꞌ ꞌin nchga tñan nu yꞌni Jesús, loꞌo kanꞌ, nduwe ꞌa tiꞌ yu: “¿Ti nten lka Jesús kanꞌ a?” Mdiya tyun nten nu nchkwiꞌ chaꞌ wa ndyuꞌu ayman Xuwa xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Loꞌo mdiya nten nu nchkwiꞌ chaꞌ xiyaꞌ ndyoꞌo tukwa ayman Elías nu yuꞌwi lo chalyuu nu ngwa sꞌni, nchkwiꞌ neꞌ chaꞌ ayman kanꞌ lka Jesús; kwiꞌ ngwañaꞌan, mdiya nten nu nchkwiꞌ chaꞌ xka ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni lka Jesús, chaꞌ wa ndyuꞌu ayman kanꞌ xiyaꞌ, ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Loꞌo ykwiꞌ Herodes bra kanꞌ: ―Ykwiǐnꞌ nguloǔn tñan chaꞌ mdijin kuꞌ neꞌ ke Xuwa. Loꞌo Jesús kanꞌ ni, kaꞌan ꞌa chaꞌ nganen nchkwiꞌ nten ꞌin yu, ¿ti ka nu lka yu sikwa a? Bra kanꞌ lye ꞌa ngwa tiꞌ Herodes chaꞌ ñaꞌan yu ꞌin ykwiꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Mxitukwi neꞌ taꞌa ndaꞌan Jesús ngala neꞌ seꞌen ndiꞌin yu xiyaꞌ, bra kanꞌ ytsaꞌ neꞌ ꞌin yu nchga tñan nu yꞌni neꞌ kichen seꞌen yaa neꞌ. Bra kanꞌ ndyaa loꞌo yu ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu ska seꞌen nu ja ndiꞌin nten, mskeꞌ tiꞌ yu, kwiꞌ seꞌen ti kichen Betsaida. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Loꞌo ngwa biyaꞌ tiꞌ xka ta nten kanꞌ nde seꞌen ndyaa Jesús, bra kanꞌ mdoꞌo ñaꞌan neꞌ ꞌin yu. Mdiyan neꞌ seꞌen ndiꞌin yu, bra kanꞌ nganun neꞌ chaꞌ kwaꞌu yu ꞌin neꞌ sa ñaꞌan ka chaꞌ nde loo la, bra nu ka Ndiose ndloo niꞌ kasiya ꞌin nten. Loꞌo mdiyan neꞌ tiꞌí chaꞌ ngwa tiꞌ neꞌ kuꞌni yu chaꞌ chkaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Bra nu wa ngwa msiin, bra kanꞌ mdyoꞌ tiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús seꞌen ndiꞌin yu chaꞌ chkwiꞌ neꞌ loꞌo yu: ―Chkwiiꞌ loꞌo neꞌ kwa chaꞌ tsaa naan neꞌ nan ku neꞌ, seꞌen kajaꞌ neꞌ tla nde kichen xuwe ti kwa ―ndukwin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. Seꞌen ndiꞌian re, ja nsuꞌwi nan ku neꞌ siyaꞌ ti ―ndukwin neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","―ꞌWan, ta wan nan ku nchga nten kaꞌan kwa ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ―Chinꞌ ꞌa nan nsuꞌwi ꞌware ―ndukwin neꞌ―. Kiꞌyu ti jaxlya tejeꞌ loꞌo tukwa ti kula loꞌo ꞌwa. Ska ti si tsaa naan ba skwa chaꞌ ku nchga neꞌ re ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kiꞌyu mi yu kiꞌyu ti mdiꞌin kanꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Chkwiꞌ wan loꞌo neꞌ kwa chaꞌ tyan neꞌ tyukwa neꞌ kwenta tuꞌwatyii neꞌ ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ngwañaꞌan yꞌni taꞌa tii tyukwa neꞌ kanꞌ loꞌo nten kaꞌan kanꞌ, bra ti ndyaa tukwa neꞌ lyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Bra kanꞌ nkwan Jesús ꞌin kiꞌyu jaxlya tejeꞌ kanꞌ loꞌo tukwa kula kanꞌ. Nde kwan naꞌan yu chaꞌ ndyaa yu xuꞌwe ꞌin Ndiose chaꞌ ꞌin nan ku neꞌ kanꞌ. Bra kanꞌ msuꞌwe yu jaxlya loꞌo kula kanꞌ, mda yu yuꞌwe kanꞌ ꞌin taꞌa ndaꞌan yu chaꞌ kutsaa neꞌ nan chaꞌ ku nten kaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nchga neꞌ kanꞌ yku neꞌ jaxlya loꞌo kula kanꞌ bra kanꞌ, ngulaꞌ tiꞌ nchga neꞌ kanꞌ. Chunꞌ ndiꞌin la msaꞌan tii tyukwa xkuwi nsuꞌwi yuꞌwe jaxlya loꞌo kula nu nganun yku neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ngwa ska tsan mdiꞌin Jesús ska ti yu nchkwiꞌ yu loꞌo Ndiose. Bra kanꞌ mdiyan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu nde seꞌen ndiꞌin yu. Mnichaꞌ Jesús ꞌin neꞌ kanꞌ bra kanꞌ: ―¿Ti ka nu lkaǎn, nchkwiꞌ neꞌ a? ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","―Ndiya nten nu nchkwiꞌ chaꞌ nuꞌwin lkaa ayman Xuwa nu mdukwatya ꞌin nten nu ngwa sꞌni ―ndukwin neꞌ ꞌin yu―, loꞌo ndiya nu nchkwiꞌ chaꞌ ayman Elías lkaa, loꞌo ndiya xka ta nu nchkwiꞌ chaꞌ nuꞌwin lkaa ska ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; sꞌni ꞌa ngujwi yu kanꞌ, loꞌo ni, ndyuꞌu yu kanꞌ xiyaꞌ, nchkwiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","―¿Loꞌo ꞌwan a? ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ―, ¿ti ka nu lkaǎn, nxkeꞌ tiꞌ wan a? Bra kanꞌ mxkwen Tyu ꞌin yu: ―Krixtu nu msuꞌwa Ndiose ꞌiin chaꞌ ndijyan lo chalyuu, kanꞌ lka nuꞌwin ―ndukwin Tyu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Lye ꞌa ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ ja katsaꞌ neꞌ chaꞌ kanꞌ ꞌin nten, chaꞌ Krixtu lka ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","―Naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ―ndukwin Jesús―, ndiꞌin chaꞌ lye ꞌa ta neꞌ nu tiꞌí ꞌñaǎn. Ti kwiꞌ ti chaꞌ, kulaa yaꞌ neꞌ wsiya ꞌñaǎn; loꞌo neꞌ nu lka ndloo la, loꞌo mstru nu nduꞌu chaꞌ joꞌo, kulaa yaꞌ neꞌ ꞌñaǎn. Ndiꞌin chaꞌ kujwi neꞌ ꞌñaǎn; loꞌo la taꞌa snan tsan, bra kanꞌ tyuꞌuǔn xiyaꞌ lo chalyuu. Tyoꞌoǔn niꞌ kwaa seꞌen nu suꞌwa neꞌ ꞌñaǎn chaꞌ katsiǐnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chunꞌ ndiꞌin la, bra kanꞌ ykwiꞌ Jesús loꞌo nchga nten: ―Si ndiya wan nu chañi chaꞌ nchka tiꞌ wan tsaa wan loꞌoǔn ―ndukwin yu―, ndiꞌin chaꞌ kulaa yaꞌ wan nchga chaꞌ nu nsuꞌwi ꞌa tiye wan, chaꞌ tyaꞌan wan loꞌoǔn nchga tsan, ni siya kujwi nten ꞌwan chaꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kanaꞌ wan chalyuu ꞌwan si lye la tyaꞌan chaꞌ tiye wan sa ñaꞌan ka suꞌwe la ꞌwan, ti ykwiꞌ ti wan. Loꞌo ni, si xlyaa wan xñi wan chaꞌ ꞌñaǎn, ni siya kujwi nten ꞌwan chaꞌ wa yten wan chaꞌ ꞌñaǎn, kaja chalyuu kwi ꞌwan nde seꞌen ndiꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ja ndyuꞌwi lyo siyaꞌ ti chaꞌ kuliyaꞌ nu nsuꞌwi ꞌwan, ni siya ñaꞌaan chalyuu kaja ꞌwan nde re, loꞌo kanaꞌ chaꞌ ꞌwan loꞌo Ndiose siꞌya chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si ka jyuꞌu tiꞌ wan ñaꞌan wan ꞌñaǎn, loꞌo naꞌ, ka jyuꞌu tiǎnꞌ ñaꞌaǎn ꞌwan bra kanꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. Ja nꞌni chaꞌ ni siya wjyuꞌu tiꞌ wan ꞌñaǎn, ni siya wjyuꞌu tiꞌ wan ꞌin chaꞌ suꞌwe nu nchkwiǐnꞌ tiǎn. Bra nu kaǎn xiyaꞌ chunꞌ ndiꞌin la chaꞌ kaǎn ndloo la ꞌin nten, bra kanꞌ ka jyuꞌu tiǎnꞌ ñaꞌaǎn ꞌwan. Luwi ꞌa xaa kaǎn loꞌoǔn bra kanꞌ chaꞌ xaa ꞌin Ndiose Stiǐn lka ran; suꞌwa ti kaǎn loꞌo nchga angajle, angajle nu luwi ꞌa siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ ndiya nten nu ndiꞌin loꞌoǔn lo chalyuu re ni, nu ja ya kaja neꞌ ka biyaꞌ tiꞌ neꞌ chaꞌ wa mdyisnan chaꞌ lka Ndiose ndloo lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bra wa mdaꞌa snuꞌ tsan nu ykwiꞌ Jesús chaꞌ kanꞌ, bra kanꞌ mchkwen yu ska lo kiꞌya chaꞌ chkwiꞌ yu loꞌo Ndiose; ndyaa loꞌo yu ꞌin Tyu loꞌo Santiago loꞌo Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Bra nu mduun Jesús nchkwiꞌ loꞌo Ndiose Sti yu, bra kanꞌ ska bra ti mxaꞌan tyukwi ñaꞌaan chunꞌ Jesús; sa ñaꞌan ska xaa nu ngaten ꞌa, ngwañaꞌan ngaten ꞌa ñaꞌan steꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Bra kanꞌ mdoꞌo tukwa tyukwa yu kiꞌyu nde seꞌen nduun Jesús, mduun ti neꞌ kanꞌ ykwiꞌ neꞌ loꞌo Jesús; ayman Moisés loꞌo ayman Elías nu yuꞌwi lo chalyuu sꞌni ngwa neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tyukwi ñaꞌaan seꞌen nduun neꞌ mjiꞌin ska xaa nu lye ꞌa ñaꞌan. Ykwiꞌ neꞌ loꞌo Jesús chaꞌ ꞌin nchga tñan nu wa mda Ndiose Sti yu chaꞌ kuꞌni yu chunꞌ ndiꞌin la, bra nu kaja yu nde kichen Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ni siya yuꞌwi ꞌa sla Tyu loꞌo taꞌa ndaꞌan yu, ti ndii tiꞌ neꞌ, kanꞌ chaꞌ naꞌan neꞌ nchga chaꞌ suꞌwe ꞌin Jesús, loꞌo taꞌa tyukwaa ayman nu suꞌwa mdiꞌin loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Bra wa tyaa ti taꞌa tyukwaa neꞌ kanꞌ, bra kanꞌ ykwiꞌ Tyu loꞌo Jesús: ―Xꞌnan ba ―ndukwin―, ¡suꞌwe ꞌa chaꞌ ndiꞌin ba nde! ¿Ta suꞌwe si kwiñan ba snan rmara a? Ska ka seꞌen tyiꞌin ykwiiꞌ, xka ran ka seꞌen tyiꞌin Moisés, loꞌo xka ran ka seꞌen tyiꞌin Elías ―ndukwin. Loꞌo Tyu ni, ja ngwa biyaꞌ tiꞌ yu sa ñaꞌan ndyoꞌo chaꞌ nu ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ti nchkwiꞌ yu, loꞌo kanꞌ mdiyan ska koo nu yuꞌwi ñaꞌaan seꞌen ndiꞌin neꞌ. Lye ꞌa ytsen neꞌ seꞌen ndiꞌin neꞌ laja koo kanꞌ, chaꞌ lye ꞌa ñaꞌan koo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Bra kanꞌ ynen tyiꞌi ska nten, bra ti ngwa biyaꞌ tiꞌ neꞌ chaꞌ Ndiose lka nu nchkwiꞌ laja koo kanꞌ: ―Ti kwiꞌ yu re lka Sñiěnꞌ; ndiya ꞌa tiǎnꞌ ꞌin yu ―ndukwin Ni―. Seen tyuun wan chaꞌ kunan wan nchga chaꞌ nu chkwiꞌ yu re loꞌo wan ―ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bra wa ynan neꞌ nchga chaꞌ nu wa ykwiꞌ Ndiose chaꞌ ꞌin Jesús, bra kanꞌ naꞌan neꞌ chaꞌ ska ti Jesús nduun kanꞌ. Mnan ti ndyaa tiꞌin neꞌ; ja ska chaꞌ ykwiꞌ neꞌ loꞌo xka la nten, sa ñaꞌan ngwa chaꞌ nu naꞌan neꞌ lo kiꞌya kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","La xka tsan bra wa ngwiꞌya neꞌ siꞌ kiꞌya kanꞌ, tyun ꞌa nten ndyaa ndyukwa taꞌa neꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mdiya ska yu kiꞌyu laja nten kaꞌan kanꞌ nu kwen ꞌa ykwiꞌ loꞌo Jesús: ―Mstru ―ndukwin yu ꞌin Jesús―, kuꞌnii chaꞌ suꞌwe tsaa naꞌaan chinꞌ ꞌin sñiěnꞌ, chunꞌ ska ti kanꞌ ndiya ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ndiya tsan nxlyuu kwiꞌin ꞌin yu, ngiꞌni kwiꞌin kanꞌ chaꞌ kwen ꞌa nxiꞌya yu bra kanꞌ; nxlyuu kwiꞌin kanꞌ ꞌin yu sa ñaꞌan yaꞌ ndyoꞌo ngoꞌ tuꞌwa yu. Kuxi ꞌa ngiꞌni kwiꞌin kanꞌ loꞌo yu, chaꞌ ja xlyaa kulaa ran ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kanꞌ chaꞌ tꞌnan ꞌa ykwiǐnꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin chaꞌ kulo neꞌ ꞌin kwiꞌin kuxi nu msñi ꞌin sñiěnꞌ, loꞌo ja ngwa ꞌin neꞌ kulo neꞌ ꞌin ran siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Bra kanꞌ mxkwen Jesús ꞌin yu tloo nchga nten nu mdiꞌin loꞌo yu: ―¡Ja ya tsaa ñaꞌan tiꞌ wan ꞌñaǎn siyaꞌ ti, ꞌwan nten chalyuu! ―ndukwin Jesús―, chaꞌ kuxi ꞌa kasiya ꞌwan. ¡Ja suꞌwe kanuǔn seꞌen ndiꞌin wan, ja taloǔn ꞌwan siyaꞌ ti! ―ndukwin Jesús ꞌin neꞌ―. Kaan loꞌoo ꞌin sñiiꞌ seꞌen ndiꞌiǐn ―ndukwin Jesús ꞌin sti yu tiꞌí kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Bra nu mdiyan yu tiꞌí kanꞌ seꞌen nduun Jesús, bra ti mxlyuu kwiꞌin kuxi kanꞌ ꞌin yu lyuu. Bra kanꞌ lye ꞌa mxlyuu kiꞌin kwiꞌin ꞌin yu. Bra kanꞌ ngulo Jesús tñan ꞌin kwiꞌin kuxi nu nsuꞌwi ꞌin yu chaꞌ tyoꞌo ran tyaa ran, nchkaa yu tiꞌí kanꞌ bra kanꞌ. Kanꞌ ykwiꞌ Jesús loꞌo sti yu tiꞌí kanꞌ chaꞌ tyan yꞌya ꞌin sñiꞌ, loꞌo kanꞌ ndya Jesús ꞌin yu nu yuꞌwi kwiꞌin kanꞌ ꞌin sti yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nchga nten nduwe ꞌa tiꞌ neꞌ chaꞌ naꞌan neꞌ chaꞌ tnun nu yꞌni Ndiose loꞌo yu. Nchga nten ndiya ꞌa tiꞌ ñaꞌan neꞌ chaꞌ tnun kanꞌ nu tka yꞌni ti Jesús. Xa nu ti nduwe ꞌa tiꞌ neꞌ ꞌin chaꞌ kanꞌ, ykwiꞌ Jesús loꞌo neꞌ nu ndaꞌan loꞌo yu: ");
INSERT INTO ctpNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Kunan suꞌwe wan chaꞌ nu chkwiǐnꞌ loꞌo wan, kiꞌya suꞌwe wan kwenta ni. Ndiya ska nten nu kujwiꞌ xuꞌwa ꞌñaǎn ꞌin neꞌ wsiya chaꞌ kuꞌni neꞌ chaꞌ kuxi loꞌoǔn, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ja ngwiꞌya neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu kwenta siyaꞌ ti, ja mjwi ñaꞌan ka biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ; ngwañaꞌan ytsen ꞌa neꞌ chaꞌ kunichaꞌ neꞌ ꞌin Jesús sa ñaꞌan ndyoꞌo chaꞌ nu ykwiꞌ yu loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Bra kanꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús kanꞌ, lye ꞌa ykwiꞌ luwe neꞌ loꞌo taꞌa neꞌ, ni ñaꞌan nu tyuun loo la ꞌin neꞌ nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Loꞌo Jesús, bra ti ngwa biyaꞌ tiꞌ nchga chaꞌ nu nka tiye neꞌ. Bra kanꞌ msñi yu yaꞌ ska nu lyuꞌ, mdiyan loꞌo yu ꞌin nu lyuꞌ kanꞌ seꞌen nduun neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Bra kanꞌ ykwiꞌ yu chaꞌ re loꞌo neꞌ: ―Bra nu tayaꞌ wan ꞌin ska nten chaꞌ ꞌñaǎn, ni siya ska nten ñaꞌan tiꞌ nu lyuꞌ re, kwiꞌ ngwañaꞌan ndayaꞌ wan ꞌñaǎn bra kanꞌ ―ndukwin Jesús―. Loꞌo nten nu tukwa tñan ꞌñaǎn, loꞌo tñan ꞌin Ndiose ndukwa neꞌ kanꞌ bra kanꞌ, chaꞌ Ndiose lka nu msuꞌwa ꞌñaǎn ndijyaǎn seꞌen ndiꞌin wan. Loꞌo yu taꞌa wan nu xlyaa ka nu kuneꞌ la ꞌin taꞌa wan, kanꞌ nu ka ndloo la ꞌwan chaꞌ ꞌñaǎn, nka tiyeěn. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Bra kanꞌ ykwiꞌ Xuwa loꞌo Jesús: ―Mstru ―ndukwin―, wa naꞌan ba chaꞌ nduun ska nten nu ndlo ꞌin kwiꞌin kuxi nu msñi ꞌin nten chabiyaꞌ ꞌiin, ndukwin yu. Kanꞌ chaꞌ ngwaꞌa loꞌo ba ꞌin yu kanꞌ, chaꞌ ja kuꞌni ꞌa yu ngwañaꞌan; ja mda ba chabiyaꞌ ꞌin yu, chaꞌ ja loꞌo yu kanꞌ ndaꞌan yu ngiꞌni xaꞌan yu loꞌo ba. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nde ñaꞌan mxkwen Jesús ꞌin Xuwa bra kanꞌ: ―Ja chkwiꞌ wan loꞌo yu chaꞌ ja kuꞌni yu ngwañaꞌan, chaꞌ ska nten nu ja nxuun loꞌoan, ja chan loꞌo yu ka tayaꞌ yu kanꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Bra wa tiya ti tsan chaꞌ tyaa Jesús nde niꞌ kwan, bra kanꞌ ngusñi yu tuwiin chaꞌ tyaa yu nde Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ngulo yu tñan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu chaꞌ tsaa neꞌ nde loo la ꞌin yu, chaꞌ tsaa chkwiꞌ neꞌ loꞌo neꞌ kichen xuwe ti seꞌen nu tyijin yu loꞌo neꞌ. Bra kanꞌ ndyaa neꞌ kanꞌ ska kichen xuwe ti nu ndukwa kwiꞌ seꞌen ti kichen Samaria; mdaꞌan naan neꞌ seꞌen tyiꞌin neꞌ tla kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bra kanꞌ ja mslyaa neꞌ kichen xuwe kanꞌ ta seꞌen kanun neꞌ tla, chaꞌ jlyo tiꞌ neꞌ kichen kanꞌ, chaꞌ wa tsaa ti neꞌ nde kichen Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Bra wa ynan Santiago loꞌo Xuwa taꞌa ndaꞌan Jesús chaꞌ kanꞌ, bra ti ykwiꞌ neꞌ kanꞌ loꞌo Jesús: ―Yu kula ―ndukwin neꞌ kanꞌ―, ¿ta ja nchka tiiꞌ chaꞌ jñan ba kiiꞌ nu tyoꞌo nde niꞌ kwan chaꞌ kaluu lyuu seꞌen ndiꞌin neꞌ kwa a? Kuꞌni tyii ran ꞌin neꞌ siyaꞌ ti, skin neꞌ bra kanꞌ. Ngwañaꞌan yꞌni ayman Elías sꞌni ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bra kanꞌ naꞌan ꞌa Jesús ꞌin neꞌ kanꞌ, ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Ja ndiꞌya wan kwenta siyaꞌ ti sa ñaꞌan ndyoꞌo chaꞌ nu nchkwiꞌ wan ―ndukwin Jesús―. Siꞌi Tyiꞌi Ndiose lka nu ngwaꞌu ꞌwan chaꞌ chkwiꞌ wan chaꞌ kuxi ngwañaꞌan; kuneꞌ xaꞌan lka nu ngwaꞌu ꞌwan chaꞌ chkwiꞌ wan ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ja msuꞌwa Ndiose Stiǐn ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, chaꞌ kuꞌniǐn tyiǐn ꞌin nten chalyuu; chaꞌ ka kulaa Ndiose ꞌin nten chalyuu ꞌin nchga chaꞌ kuxi, kanꞌ tñan ndijyaǎn chaꞌ kuꞌniǐn ―ndukwin Jesús. Bra kanꞌ mdoꞌo neꞌ yaa neꞌ xka kichen xuwe ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tuꞌwa tuwiin seꞌen ndyaa neꞌ naꞌan neꞌ ꞌin ska yu kiꞌyu. ―Yu kula ―ndukwin yu―, loꞌoǔn nchka tiǎnꞌ tsaꞌaǎn loꞌoo; la seꞌen tsaa, tsaꞌaǎn loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Bra kanꞌ mxkwen Jesús ꞌin yu kiꞌyu kanꞌ: ―Nu lka kutaꞌ ni, ndiya tukee ꞌin iꞌ seꞌen ndyuꞌwi iꞌ kajaꞌ iꞌ; loꞌo kiñi xuwe ti, nskwa seꞌen ndyuꞌwi iꞌ lo yka; loꞌoǔn ni, wa mdiyaǎn lo chalyuu chaꞌ kaǎn nten, loꞌo kanꞌ ja nsuꞌwi seꞌen xkwaǎn kajaǎnꞌ, ja ndiya seꞌen tyukwaǎn xitñaǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Bra kanꞌ ykwiꞌ Jesús loꞌo xka yu kiꞌyu: ―Kaan ñaꞌan lyaa ꞌñaǎn ―ndukwin. ―Yu kula ―ndukwin yu ꞌin Jesús bra kanꞌ―, kataa chinꞌ ꞌñaǎn chaꞌ ti kanuǔn la chinꞌ loꞌo stiǐn sa ñaꞌan yaꞌ nu kaja stiǐn, chaꞌ ñaꞌaǎn katsiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bra kanꞌ ykwiꞌ Jesús loꞌo yu: ―Ti ndiya la chinꞌ xka ta nten ꞌwan nu ka kutsiꞌ ꞌin nten nu wa ngujwi; nuꞌwin ni, ndiꞌin chaꞌ tsaa loꞌoǔn chaꞌ chkwiiꞌ chaꞌ suꞌwe ꞌin Ndiose loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Bra kanꞌ ykwiꞌ xka yu kiꞌyu loꞌo Jesús: ―Yu kula, loꞌoǔn nchka tiǎnꞌ tsaꞌaǎn loꞌoo ―ndukwin yu―, kataa chinꞌ ꞌñaǎn chaꞌ tyaꞌaǎn slaǎnꞌ loꞌo neꞌ taꞌaǎn nde naꞌan tyiǐn. ");
INSERT INTO ctpNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Bra kanꞌ mxkwen Jesús ꞌin yu kiꞌyu kanꞌ: ―Bra wa mdyisnan nten kuꞌni ska tñan, ja ka tyoꞌo suꞌwe tñan kanꞌ ꞌin neꞌ si tyaꞌan chunꞌ neꞌ ꞌin ran. Sa ñaꞌan lka nten nu ndaꞌa yuu, ja ka kwaꞌa suꞌwe neꞌ yuu si xkwiꞌ ñaꞌan neꞌ nde chunꞌ neꞌ; kwiꞌ ngwañaꞌan lka bra nu lka Ndiose ndloo niꞌ kasiya ꞌin nten chalyuu wan ni, ja ta Ni tñan kuꞌni wan chaꞌ ꞌin Ni si xkwiꞌ nchka tiꞌ wan tyaꞌan chunꞌ wan ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Chunꞌ ndiꞌin la, kanꞌ ngulo suwi Jesús ꞌin snan yla nsuꞌwi tii tyukwa neꞌ chaꞌ tsaa neꞌ nde loo la seꞌen tsaa yu; kwenta tukwa ti neꞌ tsaa neꞌ nchga seꞌen, nchga kichen seꞌen nchka tiꞌ Jesús tsaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Bra kanꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ: ―Chañi chaꞌ nsuꞌwi ꞌa tñan, chaꞌ chkwianꞌ loꞌo nten chaꞌ sten neꞌ chaꞌ ꞌin Ndiose ―ndukwin Jesús ꞌin neꞌ kanꞌ―, loꞌo chinꞌ ti nten nu ka ꞌin kuꞌni tñan kanꞌ; kanꞌ chaꞌ chkwiꞌ wan loꞌo Ndiose Stiǐn, nu nka Xꞌnan tñan kanꞌ, chaꞌ ti ta la Ni xka ta nten nu ka kuꞌni tñan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yaa lya wan sikwa. Seꞌen nu suꞌwaǎn ꞌwan chaꞌ tsaa wan, la kanꞌ tyiꞌin wan laja nten kuxi sa ñaꞌan si ndiꞌin slyaꞌ kuneꞌ laja woꞌo tlá; tyiꞌin Ndiose loꞌo wan chaꞌ ja ska ka ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ja kwiꞌya wan kwijin seꞌen xuꞌwi tñi, ni ska kwijin, ni kanan ꞌwan ja xuꞌwi kiyaꞌ wan. Ngwañaꞌan ja kanun wan tuwiin chan ꞌa, chaꞌ chkwiꞌ wan loꞌo nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Bra nu kala wan naꞌan tyi ska nten, bra kanꞌ nde ñaꞌan ndiꞌin chaꞌ chkwiꞌ wan loꞌo nten nu ndiꞌin niꞌ ñaꞌan kanꞌ: “Tiin ti tyiꞌin niꞌ kasiya ꞌwan nu ndiꞌin naꞌan re” nchkwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Bra kanꞌ si chañi chaꞌ nchka tiꞌ neꞌ nu ndiꞌin niꞌ ñaꞌan kanꞌ kunan la neꞌ chaꞌ ꞌin Ndiose, bra kanꞌ kuꞌni Ni chaꞌ tiin ti tyiꞌin niꞌ kasiya ꞌin neꞌ kanꞌ; loꞌo si ja nchka tiꞌ neꞌ kunan neꞌ chaꞌ kanꞌ, ja kuꞌni Ni chaꞌ suꞌwe loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kanun wan naꞌan tyi neꞌ nu suꞌwe nchkwiꞌ kanꞌ, ku wan koꞌo wan nchga nan nu nchku neꞌ kanꞌ; ska nten nu ngiꞌni tñan ni, ndiꞌin chabiyaꞌ ꞌin yu chaꞌ ku yu loꞌo nten. Ja tyaꞌan la wan ya ñaꞌan ti naꞌan tyi nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Bra nu tiyan wan ska kichen seꞌen nu suꞌwe ꞌa nchkwiꞌ nten loꞌo wan, ku wan nchga nan nu ta neꞌ ꞌwan, ");
INSERT INTO ctpNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kuꞌni wan joꞌó ꞌin neꞌ tiꞌí nu ndiꞌin kanꞌ. Loꞌo kanꞌ chkwiꞌ wan loꞌo neꞌ kanꞌ: “Bra ti ka Ndiose ndloo niꞌ kasiya ꞌwan.” ");
INSERT INTO ctpNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bra nu tiyan wan ska kichen seꞌen ja nchka tiꞌ neꞌ chaꞌ chkwiꞌ wan chaꞌ ꞌin Ndiose loꞌo neꞌ, bra ti tyoꞌo wan tuꞌwa kichen. Bra kanꞌ chkwiꞌ wan loꞌo neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Nskwin ba kiyaꞌ ba chaꞌ kalu yuu kichen tyi wan nu msñi kaꞌan kiyaꞌ ba; ngwañaꞌan ka biyaꞌ tiꞌ wan chaꞌ siꞌya chaꞌ kuxi kasiya ꞌwan, kanꞌ chaꞌ tyoꞌo ba kichen tyi wan tyaa ba. Loꞌo ꞌwan nten kuxi ni, ndiꞌin chaꞌ ka biyaꞌ tiꞌ wan chaꞌ nchka tiꞌ Ndiose chaꞌ bra ti ka Ni ndloo niꞌ kasiya ꞌwan”, ngwañaꞌan nchkwin wan ꞌin neꞌ kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nde lka chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ bra nu tsaa tii chalyuu re, bra kanꞌ kaꞌan la nu tiꞌí ka ꞌin neꞌ kichen kanꞌ; chinꞌ la nu tiꞌí ka ꞌin ayman kichen Sodoma nu kuxi ꞌa yꞌni nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Tꞌnan ꞌa wan, neꞌ kichen Corazín! Ngwañaꞌan, ¡tꞌnan ꞌa wan, neꞌ kichen Betsaida! Wa kaꞌan ꞌa chaꞌ tnun nu wa naꞌan wan, loꞌo kanꞌ ja mjyuꞌu tiꞌ wan siyaꞌ ti ꞌin chaꞌ kuxi nu ngiꞌni wan. Nu ngwa sꞌni, xaꞌan ꞌa neꞌ kichen Tiro, xaꞌan ꞌa neꞌ kichen Sidón; neꞌ xka laꞌa tsuꞌ ngwa neꞌ kanꞌ. Bra kanꞌ ja mjwi ñaꞌan ka jyuꞌu tiꞌ neꞌ kanꞌ ꞌin chaꞌ kuxi nu yꞌni neꞌ, chaꞌ ja ya ñaꞌan neꞌ kanꞌ ska chaꞌ tnun sa ñaꞌan nu wa naꞌan wan, neꞌ Israel; kanꞌ chaꞌ ja mxaꞌan neꞌ siyaꞌ ti chaꞌ kuxi nu yuꞌwi niꞌ kasiya ꞌin neꞌ, ja ykuꞌ ꞌa neꞌ teꞌ ngata, ja msuꞌwa neꞌ jii ke neꞌ sa ñaꞌan nu ngiꞌni neꞌ kanꞌ seꞌen nskwa ayman. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ñi katsaǎnꞌ ꞌwan chaꞌ ka suꞌwe la chaꞌ ꞌin ayman neꞌ kichen Tiro nu yuꞌwi nu ngwa sꞌni, ka suꞌwe la chaꞌ ꞌin ayman neꞌ kichen Sidón, bra nu tiya tsan tlyu chaꞌ kuꞌni biyaꞌ Ndiose ꞌin nten chalyuu; lye la ta Ndiose nu tiꞌí ꞌwan bra kanꞌ, chaꞌ ja ynan wan siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Loꞌo ni, ꞌwan neꞌ kichen Capernaum, nxkeꞌ tiꞌ wan chaꞌ ka suꞌwe la kichen tyi wan. ¿Ja ta Ndiose nu tiꞌí ꞌwan, nxkeꞌ tiꞌ wan a? Kulaa yaꞌ Ndiose ꞌwan chaꞌ tyaa wan nde lo jwlyaa siyaꞌ ti. Ti nchkwiꞌ la Jesús loꞌo snan yla nsuꞌwi tii tyukwa neꞌ kanꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","―Nten nu kunan suꞌwe chaꞌ nu chkwiꞌ wan loꞌo neꞌ, wa lka neꞌ sa ñaꞌan nchka tiꞌ si nganan suꞌwe neꞌ ska chaꞌ nu nchkwiǐnꞌ loꞌo neꞌ; bra kanꞌ nten nu kulo chunꞌ chaꞌ ꞌwan, wa lka neꞌ sa ñaꞌan nchka tiꞌ si ndlo chunꞌ neꞌ chaꞌ nu nchkwiǐnꞌ. Nten nu kulo chunꞌ chaꞌ nu nchkwiǐnꞌ, nan ndlo chunꞌ neꞌ chaꞌ ꞌin Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn; ngwañaꞌan ndyoꞌo chaꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ. Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Chunꞌ ndiꞌin la mxitukwi snan yla nsuꞌwi tii tyukwa neꞌ kanꞌ, ndyaan neꞌ xiyaꞌ seꞌen ndiꞌin Jesús. Suꞌwe ꞌa nsuꞌwi tiye neꞌ ndyaan neꞌ. ―Yu kula ―ndukwin neꞌ ꞌin Jesús―, loꞌo kwiꞌin kuxi ynan tñan nu ngulo ba ꞌin ran chabiyaꞌ ꞌiin ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Chañi chaꞌ ꞌwan. Loꞌoǔn naꞌaǎn ꞌin Satanás xa wa mdiyuu yu lyuu; sa ñaꞌan mdiyuu tiꞌyu lyuu, ngwañaꞌan mdiyuu yu. Wa ngulo Ndiose ꞌin kuneꞌ xaꞌan kanꞌ nde seꞌen tlyu seꞌen ndiꞌin Ndiose nde niꞌ kwan, mdiyuu yu sa la lyuu bra kanꞌ; kanꞌ chaꞌ ynan kwiꞌin kuxi kanꞌ chaꞌ nu ykwiꞌ wan loꞌo ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Loꞌo wa ndaǎn chabiyaꞌ ꞌwan chaꞌ xtya kiyaꞌ wan chunꞌ kunan tlá, loꞌo chunꞌ xeꞌen; chabiyaꞌ ꞌñaǎn tukunꞌ wan chaꞌ ꞌin kuneꞌ xaꞌan siyaꞌ ti. Kwiꞌ ngwañaꞌan, ja ka kuxi ꞌwan siyaꞌ ti, ja ska chaꞌ kuxi ñaꞌan wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Loꞌo ni, ja nꞌni chaꞌ ka suꞌwe nka tiye wan chaꞌ nu ynan ti kwiꞌin kuxi kanꞌ tñan nu ngulo wan ꞌin ran, suꞌwe la ka tiye wan chaꞌ wa ngwaꞌan Ndiose nin wan nde seꞌen ndiꞌin Ni nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ska bra ti kanꞌ suꞌwe ꞌa yuꞌwi tiye Jesús chaꞌ ndiꞌin Tyiꞌi Ndiose loꞌo yu. Kanꞌ chaꞌ ykwiꞌ Jesús loꞌo Ndiose Sti yu bra kanꞌ: ―Stiǐn, kuꞌni tnuǔn ꞌin nuꞌwin ni. Nuꞌwin lkaa Ndiose nu lka ndloo la ti nde niꞌ kwan, ngwañaꞌan nuꞌwin lkaa ndloo la lo chalyuu. Wa yuꞌwi kutsiꞌ ti chaꞌ kanꞌ, chaꞌ ꞌin nten nu ngwa ti sꞌni la, chaꞌ ja ngwa biyaꞌ tiꞌ siyaꞌ ti nten nu ngwa ꞌa ꞌin chaꞌ joꞌo; ngwa xuꞌwe ꞌiin chaꞌ sa bra ni, wa ngwaꞌuu suꞌwe chaꞌ kanꞌ ꞌin nten nu ja siyeꞌ, nten nu ja jlyo suꞌwe tiꞌ. Ngiꞌni tnuǔn ꞌiin chaꞌ ngwañaꞌan ngwa tiiꞌ chaꞌ ka ―ndukwin Jesús ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Bra kanꞌ ykwiꞌ yu loꞌo neꞌ nu mdiyan seꞌen ndiꞌin yu: ―Wa mda Stiǐn nchga nan ꞌñaǎn. Loꞌo ja tukwin jlyo tiꞌ chaꞌ lkaǎn Sñiꞌ Ndiose; ska ti ykwiꞌ Stiǐn, kanꞌ nu jlyo tiꞌ. Ja tukwin la jlyo tiꞌ ti ka nu lka Stiǐn; skaǎn tiǎnꞌ, jlyo tiǎnꞌ ti ka nu lka Stiǐn. Loꞌo ka jlyo tiꞌ xka ta nten, ñaꞌan nten nu xlyaǎn chaꞌ kwaꞌuǔn ꞌin neꞌ ti ka nu lka Stiǐn, loꞌo neꞌ kanꞌ ka biyaꞌ tiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Bra kanꞌ mxinaꞌan Jesús nde seꞌen nduun neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Ka suꞌwe ꞌa ka tiye nten nu ñaꞌan nchga chaꞌ tnun nu wa naꞌan wan ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan re, chaꞌ kaꞌan ꞌa nten nu ykwiꞌ loꞌo nten chaꞌ ꞌin Ndiose sꞌni la, loꞌo kaꞌan ꞌa ree nu ngwa ndloo sꞌni la, wa mdiꞌin ta ꞌa neꞌ kanꞌ, chaꞌ ñaꞌan neꞌ chaꞌ tnun nu wa naꞌan wan ni, loꞌo ja naꞌan neꞌ ꞌin ran nu ngwa sꞌni; wa mdiꞌin ta ꞌa neꞌ kanꞌ chaꞌ kunan neꞌ chaꞌ nu nganan wan ni, chaꞌ ngwa ꞌa tiꞌ neꞌ kunan neꞌ chaꞌ kanꞌ nu ngwa sꞌni. Ngujwi neꞌ bra kanꞌ, loꞌo ja naꞌan neꞌ chaꞌ kanꞌ, ja ynan neꞌ chaꞌ kanꞌ siyaꞌ ti ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Bra kanꞌ mdiyan ska mstru nu nduꞌu chaꞌ joꞌo chaꞌ chkwiꞌ biyaꞌ yu loꞌo Jesús. Bra kanꞌ mnichaꞌ yu ꞌin Jesús: ―Mstru ―ndukwin―, ¿ni sa ñaꞌan kuꞌniǐn chaꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌñaǎn? ");
INSERT INTO ctpNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Bra kanꞌ mxkwen Jesús ꞌin yu: ―¿Ni sa ñaꞌan tñan ngulo Ndiose ꞌñaan nu ndukwa lo kityi kula? ¿Ni sa ñaꞌan ndyoꞌo chaꞌ kanꞌ, nxkeꞌ tiiꞌ? ");
INSERT INTO ctpNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Bra kanꞌ ykwiꞌ mstru nu nduꞌu chaꞌ joꞌo kanꞌ: ―Nde ñaꞌan nchkwiꞌ chaꞌ kula kanꞌ ―ndukwin mstru kanꞌ―, chaꞌ tyukwi ti tiyean xuꞌwi chaꞌ ꞌñaan loꞌo Ndiose nu nka Xꞌnaan, loꞌo luwi ti kasiya ꞌñaan tukwaan chaꞌ nu nchkwiꞌ Ni, loꞌo kuꞌni tnuan ꞌin Ni loꞌo nchga chaꞌ tiya nu nda Ni ꞌñaan, sa ñaꞌan yaꞌ nu taloan tyiꞌin chaꞌ ꞌñaan loꞌo Ni. Kwiꞌ ngwañaꞌan, ndiꞌin chaꞌ chka tꞌnan tianꞌ ꞌin taꞌa ntean, sa ñaꞌan nu nchka tianꞌ chaꞌ chka tꞌnan tiꞌ xka la nten ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Bra kanꞌ ykwiꞌ Jesús loꞌo yu kanꞌ: ―Suꞌwe ꞌa chaꞌ nu mxkween ꞌñaǎn. Si ngwañaꞌan kuꞌnii, kaja chalyuu kwi kanꞌ ꞌiin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Loꞌo mstru nu nduꞌu chaꞌ joꞌo kanꞌ ni, ngwa tiꞌ yu chaꞌ tyoꞌo suꞌwe la chaꞌ nu wa ykwiꞌ yu, kanꞌ chaꞌ ndukwin yu ꞌin Jesús: ―¿Ti ka nu lka taꞌa nteěn sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Bra kanꞌ ngatsaꞌ Jesús chaꞌ tiya re ꞌin mstru kanꞌ, chaꞌ ka biyaꞌ tiꞌ yu: ―Mdoꞌo ska neꞌ taꞌa kichen tyian nde Jerusalén, ndyaa yu tuwiin nde ꞌya la, nde kichen Jericó. Loꞌo kanꞌ mdoꞌo tukwa tukwa snan nten nu ngiꞌni kunan, ngulaa neꞌ nchga nan nu loꞌo ꞌin yu; ngulo neꞌ steꞌ yu, bra kanꞌ tiꞌí ꞌa mjiꞌin neꞌ xaꞌan kanꞌ ꞌin yu sa ñaꞌan yaꞌ nu wa kaja ti yu. Bra kanꞌ ngulaa sti neꞌ ꞌin yu seꞌen nu mjiꞌin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chunꞌ ndiꞌin la mdijin ska sti joꞌo taꞌa kichen tyian ti kwiꞌ tuwiin kanꞌ. Bra wa naꞌan sti joꞌo kanꞌ ꞌin yu tiꞌí kanꞌ, bra kanꞌ ntan ti mdijin seꞌen ysu yu tiꞌí kanꞌ, ndyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Loꞌo kanꞌ mdiyan ska xta, ska neꞌ Leví, ti kwiꞌ tuwiin kanꞌ. Yaa naꞌan chinꞌ ꞌin yu tiꞌí kanꞌ; sa bra ti naꞌan ꞌin yu, mdijin xta ndyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ti kwiꞌ tuwiin kanꞌ ndaꞌan ska yu Samaria, ska neꞌ nu mdoꞌo xka lo yuu. Bra wa naꞌan ꞌin yu tiꞌí kanꞌ, bra ti nchka tꞌnan tiꞌ yu ꞌin yu tiꞌí kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ndyaa yu seꞌen ndiya yu tiꞌí kanꞌ, yꞌni yu joꞌó ꞌin nchga seꞌen tiꞌí ꞌin yu kanꞌ loꞌo sete loꞌo mñun. Bra kanꞌ mxiin yu teꞌ lo seꞌen tiꞌí ꞌin yu kanꞌ, mstya ꞌin yu tiꞌí kanꞌ chunꞌ buru ꞌin ykwiꞌ yu, ndyaa loꞌo ꞌin yu naꞌan tyi ska nten chaꞌ ñaꞌansiin neꞌ ꞌin yu tiꞌí kanꞌ nde kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","La xka tsan wa tyaa ti yu samaritano kanꞌ, bra kanꞌ ngulo yu tukwa tñi plata chaꞌ ta ꞌin neꞌ nu lka naꞌan tyi seꞌen ndiya yu tiꞌí kanꞌ. Kanꞌ nu ykwiꞌ yu loꞌo neꞌ nu lka naꞌan tyi kanꞌ: “Ñaꞌansiin wan ꞌin yu tiꞌí re. Si nu ti kwiji la tñi ꞌwan chaꞌ ꞌin yu re, bra ti katsaꞌ wan ꞌñaǎn xa nu jyaǎn seꞌen ndiꞌin wan xiyaꞌ; bra kanꞌ taǎn laǎn tñi ꞌwan” ndukwin yu samaritano kanꞌ. Bra wa mdyii ngwaꞌu Jesús chaꞌ tiya re ꞌin yu, bra kanꞌ mnichaꞌ yu ꞌin mstru kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","―Suꞌwe sikwa. Snan nten nu mdijin tuwiin seꞌen mdiꞌin yu tiꞌí kanꞌ ni, ¿ti ka nu mnaꞌansiin suꞌwe la ꞌin yu tiꞌí kanꞌ? ¿Ti ka nu chañi chaꞌ lka taꞌa nten ꞌin yu tiꞌí kanꞌ? ");
INSERT INTO ctpNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","―Nu nchka tꞌnan tiꞌ ꞌin yu tiꞌí kanꞌ ―ndukwin mstru nu nduꞌu chaꞌ joꞌo kanꞌ ꞌin Jesús. Bra kanꞌ ykwiꞌ Jesús loꞌo mstru kanꞌ: ―Yaa lyaa sikwa, kwiꞌ ngwañaꞌan kuꞌnii loꞌo taꞌa nteen. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Msñi Jesús tuwiin, ndyaa yu loꞌo taꞌa ndaꞌan yu. Loꞌo kanꞌ mdiyan neꞌ ska kichen xuwe ti seꞌen ndiꞌin ska nu kunaꞌan nu naan Marta. Suꞌwe ꞌa nka tiye Marta chaꞌ ndiya Jesús seꞌen ndiꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Loꞌo ndiya ska taꞌa ngula Marta nu naan Liya. Bra ti mdukwa Liya kanꞌ lyuu kwiꞌ seꞌen ti seꞌen ndukwa Jesús chaꞌ ngwa ꞌa tiꞌ kunan nchga chaꞌ nu nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bra kanꞌ Marta ni, kaꞌan ꞌa tñan sñan ndiꞌin chaꞌ kuꞌni. Kanꞌ nu ykwiꞌ loꞌo Jesús: ―Neꞌ kula ―ndukwin Marta ꞌin yu―, ¿ja nduwe tiiꞌ chaꞌ kaꞌan ꞌa tñan sñan mxnun Liya taꞌaǎn chaꞌ kuꞌniǐn xkaǎn tiǎn a? Kanꞌ chaꞌ suꞌwe la si chkwiiꞌ loꞌo nu kwa, chaꞌ kan tayaꞌ chinꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bra kanꞌ mxkwen Jesús ꞌin Marta: ―Marta, Marta, ndiꞌin ꞌa tñan ꞌiin ―ndukwin Jesús―. Kaꞌan ꞌa chaꞌ ndaꞌan tiyee chaꞌ ꞌin nchga tñan xuwe nu ndiꞌin ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Loꞌo ni, ti ndiya xka tñan nu suꞌwe la kuꞌnii, ska chaꞌ nu nꞌni la chaꞌ ꞌiin; kanꞌ lka chaꞌ nu nchka tiꞌ Liya kuꞌni ni. Ngiꞌni Liya ska tñan nu ndloo la, kanꞌ chaꞌ ja ndiꞌin chaꞌ kulaa xka nten tñan kanꞌ ꞌin Liya. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ngwa ska tsan ndiꞌin Jesús ngiꞌni tnun yu ꞌin Ndiose. Bra wa mdyii ykwiꞌ yu loꞌo Ndiose, bra kanꞌ ykwiꞌ ska yu nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu: ―Yu kula ―ndukwin―, kwaꞌuu ꞌwa sa ñaꞌan ka chkwiꞌ ba loꞌo Ndiose, sa ñaꞌan nu ngwaꞌu ayman Xuwa ꞌin neꞌ nu mdaꞌan loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Bra kanꞌ ngwaꞌu Jesús ꞌin neꞌ: ―Bra nu chkwiꞌ wan loꞌo Ndiose, nde ñaꞌan chkwiꞌ wan: Ndiose Sti ba nu ndiꞌin nde niꞌ kwan, ska ti nuꞌwin ngiꞌni tnun nten chalyuu ꞌiin. Kaan lo chalyuu re chaꞌ ka ndloo la ꞌwa. Nchka tiꞌ ba chaꞌ ka nchga chaꞌ nu nchka tiiꞌ chaꞌ ka lo chalyuu re, sa ñaꞌan nu nchka nde niꞌ kwan seꞌen ndiꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Taa nan ku ba kwenta ska tsan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa ꞌin nchga chaꞌ kuxi nu yꞌni ba, chaꞌ ngwañaꞌan wa yꞌni ba chaꞌ tlyu tiꞌ ꞌin xka la nten nu yꞌni chaꞌ kuxi loꞌo ba. Ja taa chabiyaꞌ chaꞌ jwakii nu kuxi ꞌwa, kulaa ꞌwa yaꞌ kuneꞌ xaꞌan bra kanꞌ. Ngwañaꞌan ngwaꞌu Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kanꞌ xiyaꞌ ngwaꞌu yu ꞌin neꞌ kanꞌ: ―Nde chkwiǐnꞌ ska chaꞌ loꞌo wan: Ska yu taꞌa wan mdiya ska taꞌa suꞌwe nsuꞌwi yu. Ska tla, xa wa ngwa jluꞌwe tla, ndyaa yu naꞌan tyi taꞌa suꞌwe nsuꞌwi yu chaꞌ chkwiꞌ yu loꞌo: “Che, taa snan tyaja jñan tiǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Tka ngala ti ska yu taꞌa suꞌwe nsuꞌwiǐn naꞌan tyiǐn, loꞌo ja nsuꞌwi siyaꞌ ti nan nu taǎn chaꞌ ku yu.” ");
INSERT INTO ctpNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Bra kanꞌ yu nu lka naꞌan tyi mxkwen ꞌin yu: “Ja nchka tiǎnꞌ chaꞌ chkwiiꞌ ya ñaꞌan ti loꞌoǔn. Wa nchkunꞌ tunaꞌan ꞌñaǎn. Loꞌo nu xuwe ꞌñaǎn wa nskwa lo kiꞌyan lajaꞌ loꞌoǔn. Ja ka tyaa tukwiǐn chaꞌ taǎn ran ꞌiin” ndukwin taꞌa suꞌwe nsuꞌwi yu ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Chañi lka chaꞌ nu katsaǎnꞌ ꞌwan ni ―ndukwin Jesús ꞌin neꞌ―. Ja mslyaa taꞌa suꞌwe nsuꞌwi yu tyaa tukwi chaꞌ ta tyaja ꞌin yu kanꞌ, ni siya taꞌa suꞌwe nsuꞌwi yu. Chunꞌ ndiꞌin la, ja chan xlyaa taꞌa suꞌwe nsuꞌwi yu ta tyaja kanꞌ ꞌin yu, chaꞌ ja nchka ꞌa tiꞌ yu chaꞌ ti xitukwi la yu ꞌin yu xiyaꞌ; kanꞌ chaꞌ tyaa tukwi taꞌa suꞌwe nsuꞌwi yu, ta nchga nan nu nchka tiꞌ yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Loꞌo ni, chkwiǐnꞌ chaꞌ re loꞌo wan: Bra nu jñan wan ska chaꞌ ꞌin Ndiose, ta Ni chaꞌ kanꞌ ꞌwan bra kanꞌ; loꞌo bra nu tsaa naan wan ꞌin Ndiose, tyija lyo Ni ꞌwan bra kanꞌ; si tyukwi ti tiye wan chkwiꞌ wan loꞌo Ndiose, kunan Ni chaꞌ nu chkwiꞌ wan loꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nchga nten nu jñan ska chaꞌ ꞌin Ndiose, kaja chaꞌ kanꞌ ꞌin neꞌ bra kanꞌ; kwiꞌ ngwañaꞌan, nchga nten nu tsaa naan ꞌin Ndiose, tyija lyo Ni ꞌin neꞌ bra kanꞌ; kwiꞌ ngwañaꞌan, nchga nten nu tyukwi ti tiye chkwiꞌ loꞌo Ndiose, kunan Ni chaꞌ nu chkwiꞌ neꞌ loꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’ꞌWan nten chalyuu nu nsuꞌwi nu xuwe ꞌwan, bra nu jñan sñiꞌ wan nan ku ꞌwan, ja ta wan ska nan kuxi ku sñiꞌ wan. Ñaꞌan tiꞌ si jñan neꞌ jaxlya ku neꞌ, ja ta wan ska kee ku neꞌ bra kanꞌ; si jñan neꞌ kula ku neꞌ, ja ta wan kunan ku neꞌ bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","si jñan neꞌ ska skuwe, ja ta wan ska xeꞌen ku neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Kanꞌ chaꞌ sikwa, si jlyo tiꞌ wan chaꞌ ta wan nan suꞌwe nu ku sñiꞌ wan, ni siya xaꞌan tiye wan, kwiꞌ ngwañaꞌan jlyo la tiꞌ Ndiose Sti wan nu ndiꞌin nde niꞌ kwan, loꞌo suꞌwe la ngiꞌni Ni. Chka tꞌnan tiꞌ Ndiose ꞌwan, ta Ni Tyiꞌi ykwiꞌ Ni nu kanun niꞌ kasiya ꞌwan bra nu jñan wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ndiya ska yu kiꞌyu nu kuꞌun chunꞌ chaꞌ wa msñi ska kwiꞌin kuxi ꞌin yu, loꞌo ngulo Jesús ꞌin kwiꞌin kuxi nu msñi ꞌin yu, ndyaa ran bra kanꞌ. Bra nu mdoꞌo kwiꞌin nu yuꞌwi ꞌin yu kuꞌun kanꞌ, ngwa chkwiꞌ yu bra kanꞌ. Yuwe ꞌa tiꞌ nten chaꞌ naꞌan neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Mdiya nu ykwiꞌ chaꞌ: ―Ndlo yu kwa ꞌin kwiꞌin kuxi ꞌin nten chabiyaꞌ ꞌin Beelzebú, nu nka xꞌnan nchga lo kwiꞌin kuxi ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Loꞌo kanꞌ ndiya nu ngwa tiꞌ ñaꞌan biyaꞌ ꞌin Jesús, kanꞌ nu mjñan ꞌin Jesús chaꞌ kuꞌni yu xka chaꞌ tnun chabiyaꞌ ꞌin Ndiose nu ndiꞌin nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Wa mgii tiꞌ Jesús nchga chaꞌ nu nka tiye neꞌ, kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Tsaa tii chaꞌ ꞌin nchga kichen seꞌen xkwiꞌ chaꞌ wsuun kuꞌni neꞌ loꞌo taꞌa neꞌ, bra nu ska ta neꞌ wsiya nxuun neꞌ loꞌo xka ta neꞌ wsiya. Kwiꞌ ngwañaꞌan loꞌo taꞌa ndiꞌin neꞌ ska ti niꞌ ñaꞌan, si ndiya chaꞌ wsuun ꞌin neꞌ loꞌo ska taꞌa ndiꞌin neꞌ, ja ka ꞌa tyiꞌin suꞌwe neꞌ ska ti niꞌ ñaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kanꞌ chaꞌ ja talo chaꞌ ꞌin Satanás si xuun taꞌa Satanás kanꞌ loꞌo msu ꞌin yu; tyii chaꞌ ꞌin kuneꞌ xaꞌan bra ti bra kanꞌ. Loꞌo naꞌ ni ―ndukwin Jesús―, wa ndukwin wan chaꞌ nguloǔn ꞌin kwiꞌin kuxi nu msñi ꞌin nten chabiyaꞌ ꞌin Beelzebú nu nka xꞌnan kwiꞌin kuxi kanꞌ, ngwañaꞌan nchkwiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","¿Ta chañi nchkwiꞌ wan chaꞌ chabiyaꞌ ꞌin Beelzebú ndloǔn ꞌin kwiꞌin kuxi a? Ja ñi nchkwiꞌ wan siyaꞌ ti, chaꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌwan ndlo neꞌ ꞌin kwiꞌin kuxi; chabiyaꞌ ꞌin Ndiose ndlo neꞌ kwiꞌin kanꞌ, ndukwin wan. Siꞌya tñan nu ngiꞌni neꞌ kanꞌ ka biyaꞌ tiꞌ wan si chaꞌ nu ñi nchkwiꞌ wan, o ta chaꞌ kwiñi ti nchkwiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Chabiyaꞌ ꞌin Ndiose ndloǔn ꞌin kwiꞌin kuxi nu wa msñi ꞌin nten, kanꞌ chaꞌ ka biyaꞌ tiꞌ wan chaꞌ wa ndiya tsan chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ñaꞌan tiꞌ ska nten nu tlá ꞌa, nduun yu kwan tuꞌwa naꞌan ꞌin yu. Wa lka nsu xtyi ꞌin yu kwiꞌ ti seꞌen nduun yu, chaꞌ ngwañaꞌan ja ska ka ꞌin yuꞌwa ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ska ti si tiyan xka ta nten nu xaꞌan la, kuꞌni neꞌ kanꞌ kanan ꞌin yu bra kanꞌ; kulaa neꞌ nchga chkwan nu nsuꞌwi ꞌin yu seꞌen nduun yu kwan, kuꞌni neꞌ kunan yuꞌwa ꞌin yu kanꞌ, chaꞌ kaja chinꞌ ꞌin nchga neꞌ bra kanꞌ. Loꞌo ykwiꞌ Jesús chaꞌ re bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","―Nten nu ja xlyaa xñi chaꞌ ꞌñaǎn, nan nxuun neꞌ kanꞌ loꞌoǔn bra kanꞌ, ngwañaꞌan ndyoꞌo chaꞌ kanꞌ. Loꞌo nten nu ja xlyaa tayaꞌ ꞌñaǎn, ngiꞌni neꞌ chaꞌ ja xñi taꞌa nten neꞌ chaꞌ ꞌñaǎn sikwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Bra nu ngulaa yaꞌ kwiꞌin kuxi ꞌin ska nten, bra kanꞌ tyaꞌan yuꞌwi kwiꞌin kanꞌ niꞌ kixinꞌ tijyuꞌ seꞌen ja ndiꞌin nten; tsaa kwiꞌin kuxi kanꞌ tsaa naan seꞌen xitñaꞌ chinꞌ. Bra nu ja kaja seꞌen xitñaꞌ kwiꞌin kanꞌ, bra kanꞌ chkwiꞌ ran: “Tyaꞌaǎn ni, xitukwiǐn tyaǎn xiyaꞌ nde seꞌen mdiꞌiǐn ti kulo.” ");
INSERT INTO ctpNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bra nu tiyan kwiꞌin kanꞌ seꞌen ndiꞌin yu kanꞌ xiyaꞌ, bra kanꞌ ñaꞌan ran chaꞌ ti ndiꞌin laja niꞌ kasiya ꞌin yu kanꞌ; ja ska chaꞌ suꞌwe msuꞌwa yu niꞌ kasiya ꞌin yu, ni siya mskeꞌ tiꞌ yu chaꞌ luwi ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Bra ti tsaa kwiꞌin kanꞌ xiyaꞌ, tsaa naan ran ꞌin xa kati kwiꞌin kuxi nu xaꞌan la, chaꞌ suꞌwa ti xñi nchga kwiꞌin kanꞌ ꞌin yu kanꞌ. Ka kuxi la chaꞌ ꞌin yu kanꞌ bra kanꞌ, chaꞌ kaꞌan la kwiꞌin msñi ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Bra wa mdyii ykwiꞌ Jesús ngwañaꞌan, bra kanꞌ ykwiꞌ ska nu kunaꞌan loꞌo Jesús. Laja nten kaꞌan kanꞌ nduun nu kunaꞌan kanꞌ nchkwiꞌ: ―¡Suꞌwe ꞌa nka tiye neꞌ kula jyaꞌaan nu yꞌni kala ꞌiin, nu mda ytiiꞌ! ―ndukwin nu kunaꞌan kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bra kanꞌ mxkwen Jesús ꞌin nu kunaꞌan kanꞌ: ―Siꞌi chaꞌ kanꞌ ―ndukwin―. ¡Suꞌwe la nka tiye nten nu kunan suꞌwe nchga chaꞌ nu nchkwiꞌ Ndiose loꞌo neꞌ, nchga nu ndukwa chaꞌ ꞌin Ni! ");
INSERT INTO ctpNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ti ndyoꞌ tiꞌin la neꞌ sa tlyu ti seꞌen ndiꞌin Jesús bra kanꞌ, xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Xaꞌan ꞌa nten chalyuu ni ―ndukwin Jesús―. Wa nchka tiꞌ neꞌ chaꞌ kuꞌniǐn ska chaꞌ tnun chabiyaꞌ ꞌin Ndiose, chaꞌ ñaꞌan kwiꞌya neꞌ ꞌin ran ñaꞌan tiꞌ ska chaꞌ wjya ti. Loꞌo ja kuꞌniǐn ngwañaꞌan. Ndiꞌin chaꞌ tyaa yuꞌwi tiꞌ wan sa ñaꞌan nu ngwa ꞌin ayman Jona nu yuꞌwi chalyuu nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tnun ꞌa chaꞌ yꞌni Ndiose loꞌo Jona kanꞌ tuwiin seꞌen ndyaa yu nde kichen Nínive chaꞌ chkwiꞌ yu chaꞌ ꞌin Ndiose loꞌo nten kanꞌ. Kwiꞌ ngwañaꞌan, tnun ꞌa chaꞌ kuꞌni Ndiose loꞌoǔn nu ndijyaǎn chaꞌ kaǎn nten ―ndukwin Jesús―, chaꞌ ka biyaꞌ tiꞌ nten chalyuu ni, chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Wa lka ndiꞌin nu tiꞌí ꞌwan nten chalyuu nde seꞌen ndiꞌin Ndiose bra wa mdyii chalyuu, siꞌya chaꞌ kuxi nu ngiꞌni wan; bra kanꞌ tyoꞌo tukwa ska ayman nu ngwa reina nu ngwa ndloo lo chalyuu nu ngwa sꞌni, chaꞌ xtya kiꞌya ꞌwan seꞌen ndiꞌin Ndiose. Bra kanꞌ chkwiꞌ neꞌ kula kanꞌ sa ñaꞌan ngwa bra nu yaa ykwiꞌ neꞌ kula kanꞌ loꞌo ayman ree Salomón. Tijyuꞌ ꞌa kichen tyi reina kanꞌ, bra kanꞌ wa ynan chaꞌ tiya ꞌa ree Salomón chaꞌ nchkwiꞌ yu loꞌo nten; kanꞌ chaꞌ mdiya reina seꞌen ndiꞌin ree kanꞌ bra kanꞌ, chaꞌ kunan chaꞌ tiya nu nchkwiꞌ ree kanꞌ. Loꞌo ꞌwan ni, ja xlyaa wan kunan wan chaꞌ ꞌin Ndiose. Tnun la tñan ngiꞌni Ndiose ni, chaꞌ ndiꞌiǐn lo chalyuu; chinꞌ la chaꞌ ngwa ꞌin ayman ree Salomón nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bra kanꞌ loꞌo neꞌ ayman kichen Nínive nu yuꞌwi sꞌni, xtya neꞌ kiꞌya ꞌwan tsan nu kuꞌni biyaꞌ Ndiose ꞌwan. Wa ynan neꞌ Nínive kanꞌ, nchga chaꞌ nu ykwiꞌ Jona loꞌo neꞌ chabiyaꞌ ꞌin Ndiose; mjyuꞌu tiꞌ neꞌ bra kanꞌ, ngulaa yaꞌ neꞌ nchga chaꞌ kuxi nu nsuꞌwi ꞌin neꞌ bra kanꞌ. Loꞌo ꞌwan, ja xlyaa wan kunan wan chaꞌ nu nchkwiǐnꞌ loꞌo wan. Tnun la tñan ngiꞌni Ndiose ni, chinꞌ la chaꞌ ngwa la nu yaa ayman Jona nde Nínive nu ngwa sꞌni kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ja tukwin kwaꞌan kiiꞌ ꞌin ska xaa chaꞌ suꞌwa kutsiꞌ neꞌ ꞌin ran chunꞌ ndiꞌin la. Ja suꞌwa kutsiꞌ neꞌ ꞌin ran ska niꞌ kajun; kwan xtya neꞌ xaa kanꞌ, chaꞌ ta ran xaa nchga seꞌen ndaꞌan neꞌ niꞌ ñaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Loꞌo ꞌwan ni, kiloo wan nda xaa ꞌwan, kanꞌ chaꞌ suꞌwe nchka ñaꞌan wan chalyuu. Bra nu ti suꞌwe nsuꞌwi xaa kiloo wan, bra kanꞌ ka ñaꞌan wan chaꞌ kuꞌni wan nchga loo tñan nu ndiꞌin chaꞌ kuꞌni wan, ka kuꞌni wan xkwiꞌ tñan suꞌwe. Si tiꞌí kiloo wan, ja ka chkanꞌ kiloo wan bra kanꞌ, chaꞌ tla ꞌa xaa kiloo wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndii ti tiꞌ wan sikwa; kiꞌya wan kwenta si chañi chaꞌ nsuꞌwi xaa luwi niꞌ kasiya ꞌwan, si ja nsuꞌwi chaꞌ kuxi niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Si luwi kasiya ꞌwan ni, ja ndiꞌin chaꞌ ꞌwan siyaꞌ ti loꞌo chaꞌ kuxi; xaa tiꞌ wan sikwa, sa ñaꞌan si suꞌwe ꞌa ngaꞌni ska xaa seꞌen ndiꞌin wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Bra nu mdyii ykwiꞌ Jesús, bra kanꞌ ykwiꞌ ska neꞌ fariseo loꞌo Jesús chaꞌ tsaa naꞌan tyi yu, chaꞌ ku tlyaa neꞌ. Kanꞌ chaꞌ ndyaa Jesús loꞌo yu, kanꞌ ndyaa tukwa yu tuꞌwa msaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yuwe ꞌa tiꞌ yu fariseo kanꞌ, bra nu naꞌan yu chaꞌ ja mnaꞌ Jesús sa ñaꞌan nu ngiꞌni neꞌ judío xa wa ku ti neꞌ tyaja. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Bra kanꞌ ykwiꞌ Xꞌnaan loꞌo yu fariseo kanꞌ: ―ꞌWan neꞌ fariseo ―ndukwin Jesús―, suꞌwe ꞌa ngiꞌni luwi tloo wan, ngiꞌni luwi chunꞌ wan, sa ñaꞌan lka nu ngaten ska sa, ngaten ska kaꞌnan. Loꞌo niꞌ kasiya ꞌwan, xkwiꞌ chaꞌ kuxi nsuꞌwi; nchka tiꞌ wan kulaa wan nan nu nsuꞌwi ꞌin xka ta nten, tiꞌí tiꞌ wan ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Tintu ꞌa ꞌwan. ¿Siꞌi ska ti Ndiose mñan Ni tyukwi ñaꞌaan, ni siya niꞌ kasiya ꞌñaan, ni siya nde chuanꞌ a? Wa mñan Ndiose yaanꞌ, loꞌo naꞌan Ni nchga chaꞌ nu nsuꞌwi niꞌ kasiya ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Si tyukwi ti tiye wan ta wan nchga chaꞌ suꞌwe nu nsuꞌwi ꞌwan chaꞌ tayaꞌ wan ꞌin neꞌ tiꞌi, bra kanꞌ tukwa Ndiose tñan nu ngiꞌni wan chaꞌ luwi kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Tꞌnan ꞌa ꞌwan, neꞌ fariseo! ―ndukwin Jesús―. Kti ꞌa ngiꞌni wan loꞌo Ndiose loꞌo nchga nan xuwe ti nu nsuꞌwi ꞌwan, loꞌo nchga nan nu nda wan lomstan ꞌin Ndiose niꞌ lyaa; sa yuꞌwe ti nchga kixinꞌ nu suꞌwe tyiꞌi, sa yuꞌwe nchga kixinꞌ nu nchka xiyan skwa, nda wan ꞌin ran ꞌin Ndiose bra nu tka msiꞌi ti wan ꞌin ran. Loꞌo kanꞌ ja ñi ngiꞌni biyaꞌ wan ꞌin nten; kwiꞌ ngwañaꞌan, ja suꞌwe nka tiye wan ñaꞌan wan ꞌin Ndiose siyaꞌ ti; kanꞌ lka tñan nu ndiꞌin chaꞌ kuꞌni wan ndla la, loꞌo ñaꞌan ti kuꞌni wan xka la tñan xuwe ti nu nsuꞌwi ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Tꞌnan ꞌa ꞌwan, neꞌ fariseo! Ndiya ꞌa tiꞌ wan tyukwa wan lo yka seꞌen suꞌwe la niꞌ lyaa, loꞌo ndiya ꞌa tiꞌ wan chaꞌ kuꞌni tnun nten ꞌwan bra nu nduun wan lo kiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Tꞌnan ꞌa ꞌwan, neꞌ fariseo!, loꞌo ꞌwan mstru nu nduꞌu chaꞌ joꞌo, chaꞌ lye ꞌa ngiꞌni kti wan tloo nten. Sa ñaꞌan lka ska kwaa nu ndiya niꞌ lyoꞌoo ꞌin ayman, seꞌen nu ja ska nan nchkunꞌ chunꞌ, ni siya kee ja nskwa; bra kanꞌ ndyoꞌo sta nten chunꞌ ran, chaꞌ ja jlyo tiꞌ neꞌ chaꞌ kwaa lka ran. Ngwañaꞌan lka wan, chaꞌ nu kwiñi lyoꞌo ti wan ꞌin nten nu ja ndii tiꞌ sa ñaꞌan lka wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Bra kanꞌ ykwiꞌ ska mstru nu nduꞌu chaꞌ joꞌo loꞌo Jesús: ―Mstru ―ndukwin―, bra nu ykwiiꞌ ngwañaꞌan, loꞌo ꞌware msuꞌwaa kiꞌya ꞌwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Mxkwen Jesús ꞌin yu kanꞌ bra kanꞌ: ―Loꞌo ꞌwan, mstru nu nduꞌu chaꞌ joꞌo, ¡tꞌnan ꞌa ꞌwan! Tiꞌin ꞌa tñan nu nda wan chaꞌ kuꞌni nten, sa ñaꞌan yaꞌ nu ja nchka ꞌa ꞌin neꞌ kuꞌni neꞌ tñan kanꞌ siyaꞌ ti. Loꞌo ꞌwan ni, ja ndayaꞌ wan ꞌin neꞌ; ni loꞌo ska loo xñii yaꞌ ti wan, ja ndayaꞌ wan ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Tꞌnan ꞌa ꞌwan!, chaꞌ suꞌwe ꞌa naꞌan nñan wan chunꞌ kwaa seꞌen nsu ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni; loꞌo kanꞌ, ti kwiꞌ neꞌ taꞌa wan lka ayman nu yjwi ꞌin ayman kanꞌ, ni siya suꞌwe ꞌa tiye ayman kanꞌ bra nu yuꞌwi neꞌ ti sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bra kanꞌ ka biyaꞌ tianꞌ chaꞌ ska ñaꞌan ti chaꞌ kuxi nka tiye wan loꞌo ayman taꞌa wan ti sꞌni; nan wa yjwi ayman kanꞌ ꞌin nten nu yꞌni tñan ꞌin Ndiose nu ngwa sꞌni, loꞌo ni, ꞌwan lka nu nñan naꞌan chunꞌ kwaa seꞌen nsu ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Nchga chaꞌ jlyo tiꞌ Ndiose, kanꞌ chaꞌ ykwiꞌ Ni chaꞌ re nu ngwa sꞌni: “Ti kuloǔn laǎn tñan ꞌin nten nu kan seꞌen ndiꞌin nten chalyuu, chaꞌ chkwiꞌ neꞌ kanꞌ chaꞌ nu ñi loꞌo neꞌ chaꞌ ꞌñaǎn. Loꞌo kanꞌ kujwi nten chalyuu ꞌin tyun neꞌ kanꞌ, ka tiꞌí tiꞌ nten ꞌin neꞌ kanꞌ” ndukwin kityi ꞌin Ndiose kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Bra kanꞌ ta Ndiose nu tiꞌí ꞌin nten nu ndiꞌin lo chalyuu re ni, chunꞌ chaꞌ yjwi neꞌ ꞌin nchga ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. Ti bra nu mñan Ndiose chalyuu ti kulo, ");
INSERT INTO ctpNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ti bra ngujwi ayman Abel, sa ñaꞌan yaꞌ nu ngujwi ayman Zacarías, yjwi ꞌa neꞌ ꞌin nten ꞌin Ndiose. Loꞌo Zacarías kanꞌ, jluꞌwe niꞌ lyaa mduun yu; ska laꞌa ndukwa msaa seꞌen nchkin lomstan, xka laꞌa nskwa naꞌan nu kti ꞌa chaꞌ ꞌin Ndiose, jluꞌwe la kanꞌ yjwi neꞌ ꞌin yu. Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ ta Ndiose nu tiꞌí ꞌwan nten chalyuu ni, siꞌya chaꞌ wa yjwi ayman taꞌa wan ꞌin neꞌ kanꞌ nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Tꞌnan ꞌa ꞌwan, mstru nu nduꞌu chaꞌ joꞌo! Wa ndyija lyo ꞌwan sa ñaꞌan nu kuꞌni xaꞌan wan nchga loo chaꞌ. Loꞌo kanꞌ ykwiꞌ wan, ja xlyaa wan kuꞌni xaꞌan wan chaꞌ nu nchkwiǐnꞌ chaꞌ ꞌin Ndiose Stiǐn; ngwañaꞌan ndukunꞌ wan chaꞌ ꞌin xka ta nten bra nu nchka tiꞌ neꞌ kuꞌni xaꞌan neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Bra wa mdyii ykwiꞌ Jesús chaꞌ kanꞌ, mdyisnan neꞌ msinꞌ tiꞌ neꞌ ꞌin Jesús, mstru nu nduꞌu chaꞌ joꞌo kanꞌ loꞌo neꞌ fariseo kanꞌ. Kuxi ꞌa ngwa tiye neꞌ kanꞌ, kanꞌ chaꞌ kaꞌan ꞌa chaꞌ tukwi mnichaꞌ neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ngwa ꞌa tiꞌ neꞌ kanꞌ chaꞌ chkwiꞌ tsaa yu ska chaꞌ nu kuxi, chaꞌ kaja ñaꞌan nu xtya neꞌ kiꞌya ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wa mdyoꞌ tiꞌin tyun ꞌa mi nten seꞌen ndiꞌin Jesús bra kanꞌ. Tkanꞌ ꞌa ndiꞌin neꞌ kanꞌ, sa ñaꞌan yaꞌ nu ndyoꞌo sta neꞌ kiyaꞌ taꞌa neꞌ. Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Chaꞌ tiya ti tiꞌ wan sa ñaꞌan tñan nu ngiꞌni neꞌ fariseo, neꞌ nu kti ꞌa ngiꞌni, nxkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Chunꞌ ndiꞌin la tyija lyo ꞌin nten nchga chaꞌ nu nsuꞌwi nchkunꞌ ti ni; chunꞌ ndiꞌin la kaja la ñaꞌan ka biyaꞌ tiꞌ nten nchga chaꞌ nu nchka mnan ti ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nchga chaꞌ nu wa ytsaꞌ wan ꞌin nten niꞌ ñaꞌan tyi neꞌ, nde loo la kunan nchga nten kichen chaꞌ kanꞌ; nchga chaꞌ nu wa ykwiꞌ mnan ti wan loꞌo nten, chaꞌ ngaꞌan yaꞌ naꞌan seꞌen ndiꞌin wan, nde loo la kwen ꞌa kanen xiꞌya neꞌ chaꞌ kanꞌ tyukwi ñaꞌaan lo kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Taꞌa suꞌween nsuꞌwiǐn lka wan, kanꞌ chaꞌ chkwiǐnꞌ chaꞌ re loꞌo wan, chaꞌ ja kutsen wan ꞌin nten chalyuu nu ka kujwi ꞌñaan, chaꞌ ja ka kuꞌni neꞌ kanꞌ xka la chaꞌ kuxi ꞌñaan chunꞌ ndiꞌin la, bra nu wa ngujwian. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Katsaǎnꞌ ꞌwan ni, ti ka nu chañi lka chaꞌ kutsen wan ꞌin: Ndiose ni, kutsen wan ꞌin Ni. Bra nu kiꞌya Ni kasiya ꞌin nten, bra kanꞌ ndiꞌin chabiyaꞌ ꞌin Ndiose chaꞌ kulo Ni tñan ꞌin kasiya ꞌin nten chaꞌ tsaa nde lo jwlyaa, si nchka tiꞌ Ni. Chaꞌ nu ñi nchkwiǐnꞌ loꞌo wan ni, suꞌwe la si kutsen wan ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Wa jlyo tiꞌ wan chaꞌ xꞌnan ꞌa ngaꞌan kiñi xuwe nu ndujwiꞌ nten, kiꞌyu kiñi xuwe kaja ꞌwan chunꞌ tukwa tñi xuwe ti; loꞌo Ndiose, ñaꞌansiin Ni ꞌin nchga ꞌni xuwe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ngwañaꞌan ꞌwan, ngiꞌni Ndiose kwenta ꞌin skaa wan, wa jlyo tiꞌ Ni ni lkwa kichanꞌ ke skaa wan; kanꞌ chaꞌ ja kutsen wan, chaꞌ kaꞌan ꞌa ndyuꞌwi lyo wan nde seꞌen ndiꞌin Ndiose. Ja suꞌwa siyaꞌ ti ndyuꞌwi lyo wan loꞌo kiñi xuwe, ni siya kaꞌan ꞌa kiñi xuwe lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nde lka chaꞌ nu nchkwiǐnꞌ loꞌo wan ni. Ja ka jyuꞌu tiꞌ wan chkwiꞌ wan tloo xka ta nten chalyuu chaꞌ lka wan nten ꞌñaǎn; loꞌo naꞌ nu ndijyaǎn chaꞌ kaǎn nten, ja ka jyuꞌu tiǎnꞌ chkwiǐnꞌ chaꞌ lka wan nten ꞌñaǎn. Ngwañaꞌan chkwiǐnꞌ nde seꞌen tyiꞌiǐn loꞌo angajle nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Si ndiya ska wan nu chkwiꞌ loꞌo xka nten chaꞌ ja ndiꞌin chaꞌ ꞌin yu loꞌoǔn siyaꞌ ti, loꞌo naꞌ, kwiꞌ ngwañaꞌan chkwiǐnꞌ chaꞌ ja nsuꞌwi lyoǔn ꞌin nten kanꞌ seꞌen ndiꞌin angajle nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nten nu chkwiꞌ chaꞌ kuxi ꞌñaǎn nu ndijyaǎn chaꞌ kaǎn nten; loꞌo nten nu chkwiꞌ chaꞌ kuxi ꞌin tñan nu ngiꞌni Tyiꞌi Ndiose, ja kuꞌni ꞌa Ni chaꞌ tlyu tiꞌ ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’ꞌWan nu lka wan nten ꞌñaǎn, ja kutsen wan bra nu chkwiꞌ biyaꞌ neꞌ loꞌo wan niꞌ lyaa, bra nu kuꞌni biyaꞌ neꞌ ꞌwan tloo nten nu lka tñan. Ja kuwe ꞌa tiꞌ wan sa ñaꞌan chaꞌ nu chkwiꞌ wan loꞌo neꞌ kanꞌ, chaꞌ ka kulaa neꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tyiꞌi Ndiose, kwaꞌu Ni ꞌwan sa ñaꞌan chaꞌ nu chkwiꞌ wan loꞌo neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mdiya ska yu kiꞌyu laja nten kaꞌan kanꞌ. Mdyisnan yu ykwiꞌ yu loꞌo Jesús bra kanꞌ: ―Yu kula ―ndukwin yu―, katsaaꞌ lyaa ꞌin yu taꞌaǎn chaꞌ suꞌwe yu chaꞌ kuliyaꞌ nu mxnun sti ba ꞌwa loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bra kanꞌ mxkwen Jesús ꞌin yu kanꞌ: ―Siꞌi tñan ꞌñaǎn lka, chaꞌ kuꞌni biyaǎnꞌ chaꞌ ꞌwan; siꞌi tñan ꞌñaǎn lka, chaꞌ suꞌweěn chaꞌ kuliyaꞌ nu ndiꞌin chaꞌ kaja ꞌin skaa wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Loꞌo kanꞌ ykwiꞌ Jesús xka chaꞌ loꞌo nten nu ndiꞌin loꞌo yu: ―Chaꞌ tiya ti tiꞌ wan tyiꞌin wan lo chalyuu. Ja xitukwi ꞌa tiꞌ wan nchga chaꞌ suꞌwe nu nsuꞌwi ꞌin nten bra nu ndiꞌin wan lo chalyuu; ja chañi chaꞌ tyiꞌin suꞌween laan lo chalyuu ni siya ndiꞌin ꞌa chaꞌ kuliyaꞌ, ni siya nsuꞌwi kaꞌan ꞌa nan ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Bra kanꞌ ykwiꞌ Jesús ska chaꞌ tiya loꞌo neꞌ: ―Ndiya ska yu kuliyaꞌ. Suꞌwe ꞌa yuu nu ndiya ꞌin yu, kaꞌan ꞌa tya mjwi ꞌin yu ska yijan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Loꞌo kanꞌ mdyisnan yu kuliyaꞌ kanꞌ, kaꞌan ꞌa chaꞌ mdaꞌan tiye yu: “¿Nan ka kuꞌniǐn ni a? Ja tyoꞌo skwa ꞌa seꞌen xuꞌwi tya ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nde tñan kuꞌniǐn sikwa, suꞌwe la kuꞌni tyiǐn nchga juꞌwa ꞌñaǎn chaꞌ tyaꞌ xka naꞌan nu tlyu la ti. La kanꞌ xuꞌwi tya ꞌñaǎn, loꞌo nchga lo yuꞌwa ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Loꞌo kanꞌ ka suꞌwe nka tiyeěn chkwiǐnꞌ: Suꞌwe ꞌa chalyuu mjwi ꞌñaǎn ni. Kaꞌan ꞌa chaꞌ suꞌwe wa ndiꞌin ꞌñaǎn, tyoꞌo skwa ran ꞌñaǎn tyun yijan. Loꞌo ni, tsaa ꞌa tiǎnꞌ tyiꞌiǐn lo chalyuu; nsuꞌwi ꞌa nan kuǔn ni, koꞌoǔn xalyu, tyaꞌaǎn paseya.” ");
INSERT INTO ctpNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bra kanꞌ ykwiꞌ Ndiose loꞌo yu: “Tintu ꞌa chaꞌ ndaꞌan tiyee. Tla ndiꞌa ti ndiꞌin chaꞌ kajaa” ndukwin Ndiose ꞌin yu kuliyaꞌ kanꞌ. “¿Ti ka nu kanun loꞌo nchga chaꞌ suꞌwe nu tka mxooꞌ seꞌen ti, nu mjwi ꞌiin ni a?” ndukwin Ndiose ꞌin yu kuliyaꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ngwañaꞌan ka ꞌin nten nu xkwiꞌ chaꞌ ka kuliyaꞌ ti ndaꞌan chaꞌ tiye, loꞌo ja nduwe tiꞌ neꞌ si ka neꞌ nten suꞌwe chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan ni: Ja kaꞌan ꞌa chaꞌ tyaꞌan tiye wan nan lka nu lyiji ꞌwan chaꞌ ku wan seꞌen ndiꞌin wan lo chalyuu, loꞌo ja tyaꞌan ꞌa chaꞌ tiye wan chaꞌ ꞌin steꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Suꞌwe la chaꞌ luꞌuun tian, ja nꞌni chaꞌ kuan kaꞌan ꞌa nan; suꞌwe la chaꞌ ndiꞌin tian, ja nꞌni chaꞌ kuanꞌ teꞌ nu suꞌwe ꞌa ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ñaꞌan wan chinꞌ sa ñaꞌan lka chaꞌ ꞌin ꞌni nu lka kwityanꞌ; ja ntya iꞌ nskwaꞌ, ja ngiꞌni iꞌ kwa, ja ndukwa naꞌan tyi iꞌ, ja nñan iꞌ juꞌwa seꞌen xuꞌwi nan ku iꞌ; ngwañaꞌan ti nda Ndiose nan ku iꞌ. Loꞌo ꞌwan ni, ¡kaꞌan la ndyuꞌwi lyo wan chaꞌ ꞌin Ndiose ke kwityanꞌ kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja ka kaluu la wan xa jluꞌwe metro kwan la, ni siya kaꞌan la chaꞌ tyaꞌan tiye wan; ");
INSERT INTO ctpNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","chinꞌ ti chaꞌ lka kanꞌ, loꞌo ja nchka ꞌwan kuꞌni wan ꞌin ran siyaꞌ ti. Kwiꞌ ngwañaꞌan, ja ndiꞌin chaꞌ lye ꞌa tyaꞌan chaꞌ tiye wan chaꞌ ꞌin ska chaꞌ nu wa tnun la. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Ñaꞌan wan chinꞌ ꞌin yka kee nu nsuꞌwi laja kixinꞌ kwa. Suꞌwe ꞌa ñaꞌan kee nu ndyukwa lo ran, ja ngiꞌni ran tñan, ja nchka ꞌin ran kwiñan teꞌ chaꞌ kuꞌ ran. Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ ꞌin ayman Salomón nu yuꞌwi ti sꞌni. Kuliyaꞌ ꞌa ngwa ayman kanꞌ, suꞌwe ꞌa ñaꞌan steꞌ yu; loꞌo ja suꞌwa ñaꞌan steꞌ yu loꞌo kee kwa, chaꞌ suꞌwe la ñaꞌan kee kwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kwiꞌ ngwañaꞌan lka chaꞌ ꞌin kii nu ndukwa niꞌ kixinꞌ kwa ni. Ngaluu kii kanꞌ suꞌwe ti; la xka tsan, ja chkanꞌ ꞌa kii kwa chaꞌ wa mkin ran. Ndiose ngiꞌni chaꞌ suꞌwe ꞌa ñaꞌan kii kanꞌ; kwiꞌ ngwañaꞌan ꞌwan, chañi chaꞌ ta Ndiose teꞌ kuꞌ wan, ni siya chinꞌ ti ndyaa ñaꞌan tiꞌ wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kanꞌ chaꞌ ni, ja kaꞌan ꞌa chaꞌ tyaꞌan tiye wan: “¿Nan ka kuan ni a? ¿Nan ka koꞌoan ni a?” Siꞌi xkwiꞌ tyaꞌan luwe wan chaꞌ tsaa naan wan nan ku wan, nan koꞌo wan, ");
INSERT INTO ctpNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","chaꞌ xkwiꞌ chaꞌ kanꞌ nduwe ꞌa tiꞌ ya ñaꞌan ti nten chalyuu. Nu ꞌwan ni, ja kuwe tiꞌ wan, jlyo tiꞌ Ndiose Sti wan sa ñaꞌan ka kaja nchga nan nu lyiji ꞌwan chaꞌ tyijin yuꞌwi ꞌwan lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Siꞌi xkwiꞌ chaꞌ ꞌwan, ti ykwiꞌ ti wan tyaꞌan chaꞌ tiye wan sikwa. Nde lka tñan nu ndiꞌin chaꞌ kuꞌni wan. Tukwa wan nchga chaꞌ nu nchkwiꞌ Ndiose, chaꞌ ka Ni ndloo niꞌ kasiya ꞌwan seꞌen ndiꞌin wan lo chalyuu; bra kanꞌ ta Ndiose nchga nan nu lyiji ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Ja kutsen wan. Nten ꞌñaǎn lka wan, ni siya chinꞌ ti neꞌ taꞌa wan nu lka wan nten ꞌin Ndiose; wa mjwi chalyuu suꞌwe ꞌwan chaꞌ Ndiose Stiǐn lka ndloo la ꞌwan, chaꞌ ngwañaꞌan nchka tiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ja kuwe tiꞌ wan, kujwiꞌ wan nan nu nsuꞌwi ꞌwan chaꞌ ta wan tñi ꞌin nten nu tiꞌi. Loꞌo kanꞌ ja ka kasun kwijin seꞌen nsuꞌwi tñi ꞌwan, ja ka tyii nan nu mstya seꞌen wan seꞌen ndiꞌin Ndiose nde niꞌ kwan; nde kanꞌ ja ka ꞌa kuꞌni neꞌ kunan tñi ꞌwan, ja ka ku kwisunꞌ ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wa lka ndiꞌin kasiya ꞌwan loꞌo nchga chaꞌ nu ndiya la tiꞌ wan, ni siya chaꞌ suꞌwe nu mxoꞌ tiꞌin wan chaꞌ ꞌwan ti lo chalyuu, ni siya chaꞌ suꞌwe nu mstya seꞌen Ndiose chaꞌ ꞌwan nde seꞌen ndiꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","’Ndii ti tiꞌ wan tyiꞌin wan lo chalyuu chaꞌ ka kuꞌni kuwe tiꞌ wan, sa ñaꞌan nu ngiꞌni msu nu ndiꞌin naꞌan ꞌin ska nten. Mdiya ska tla ndyaa xꞌnan naꞌan kanꞌ taꞌa seꞌen kaja kwilyoꞌo nten. Ti ndii tiꞌ msu kanꞌ, ti ndukuꞌ neꞌ steꞌ neꞌ, ñaꞌan ti nsuꞌwi xaa niꞌ ñaꞌan seꞌen nganun msu kanꞌ; ti ndii tiꞌ neꞌ chaꞌ ngita neꞌ ꞌin xꞌnan neꞌ, sa ñaꞌan bra nu kala xꞌnan neꞌ kanꞌ. Bra nu kala yu, jwiꞌin yaꞌ yu tunaꞌan nde liyaꞌ, bra ti slaa msu tunaꞌan ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Suꞌwe ꞌa ka ꞌin msu kanꞌ, si ti ndii tiꞌ neꞌ bra nu kala xꞌnan neꞌ chaꞌ kuꞌni lya neꞌ tñan nu kulo xꞌnan neꞌ. Chañi lka chaꞌ nu chkwiǐnꞌ loꞌo wan, chaꞌ nde ñaꞌan chkwiꞌ xꞌnan naꞌan kanꞌ loꞌo msu ꞌin yu: “Tyukwa lya wan tuꞌwa msaa re.” Bra kanꞌ kuꞌni kuwe tiꞌ ykwiꞌ xꞌnan neꞌ chaꞌ ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Suꞌwe ꞌa ka ꞌin neꞌ kanꞌ, chaꞌ ti ndii tiꞌ neꞌ, ni siya tla ꞌa kala ykwiꞌ xꞌnan neꞌ, ni siya tyijin jluꞌwe tla kala yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndiꞌya wan kwenta sa ñaꞌan nu kuꞌni ska xꞌnan naꞌan, si jlyo tiꞌ yu sa ñaꞌan bra tiya ska yu nu kuꞌni kunan niꞌ ñaꞌan; tyuun yu kwan tuꞌwa naꞌan, chaꞌ ja ta yu chabiyaꞌ kuꞌni neꞌ kunan nan nu nsuꞌwi niꞌ ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ngwañaꞌan ꞌwan ni, ndii ti tiꞌ wan tyiꞌin wan lo chalyuu; bra nu kaǎn xiyaꞌ, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ja chan kaǎn ska bra nu ja kii tiꞌ wan chaꞌ nu kaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","―Yu kula ―ndukwin Tyu ꞌin Jesús bra kanꞌ―, ¿ta loꞌo bare ti nchkwiiꞌ chaꞌ tiya kanꞌ a? ¿Ta ja suꞌwe la si kunan nchga nten chaꞌ kanꞌ, xkeꞌ tiiꞌ a? ―ndukwin Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bra kanꞌ mxkwen Jesús ꞌin yu: ―¿Ta nsuꞌwi wan nu tyukwi ti tiye wan xlyaa wan kuꞌni wan tñan ꞌñaǎn a? Nde lka tñan nu kuꞌni wan sikwa. Ska msu nu suꞌwe ni, ta xꞌnan yu tñan ꞌin yu chaꞌ ka yu ndloo la niꞌ ñaꞌan ꞌin xꞌnan yu; kulo xꞌnan yu tñan ꞌin yu chaꞌ xku yu ꞌin nchga nten nu ndiꞌin niꞌ ñaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ka suꞌwe ꞌa ka tiye msu kanꞌ bra nu kan xꞌnan yu xiyaꞌ, si chañi ka chaꞌ ngiꞌni yu tñan nu wa ngulo xꞌnan yu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Chaꞌ nu ñi nchkwiǐnꞌ loꞌo wan ni, chaꞌ tlyu la tñan ta xꞌnan yu ꞌin msu kanꞌ bra kanꞌ, sa ñaꞌan yaꞌ ka yu ndloo ꞌin nchga tñan ꞌin xꞌnan yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Loꞌo ska msu nu ja nduwe tiꞌ ꞌin tñan nu ngulo xꞌnan yu ꞌin yu, bra ti kiꞌya chaꞌ kuxi ke yu. Tiyaꞌ ꞌa kan xꞌnan yu, xkeꞌ tiꞌ yu. Bra kanꞌ tyisnan yu kanꞌ kuꞌni yu chaꞌ xaꞌan; kuꞌni tlá yu ꞌin taꞌa msu yu, ni siya neꞌ kunaꞌan, ni siya yu kiꞌyu. Kaꞌan ꞌa skwa ku yu, sa kuꞌ ti koꞌo yu xalyu, sa kuꞌ ti tyaꞌan yu kuꞌwi yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Loꞌo kanꞌ bra ti tyoꞌo tukwa xꞌnan yu ska tsan nu ja kii tiꞌ yu. Ja jlyo tiꞌ yu ni bra tyoꞌo tukwa ykwiꞌ xꞌnan yu xiyaꞌ, ti kwiꞌ ti chaꞌ ja ndyaa ñaꞌan tiꞌ yu si kala xꞌnan yu tsan kanꞌ. Bra kanꞌ lye ꞌa nu tiꞌí ta xꞌnan yu ꞌin yu nu xaꞌan kanꞌ. Suꞌwa ti tsaa yu nde lo jwlyaa chaꞌ kaja nu tiꞌí ꞌin yu loꞌo nten nu ja nnan chaꞌ ꞌin Ndiose siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Chaꞌ nu jlyo tiꞌ msu kanꞌ sa ñaꞌan tñan ngulo xꞌnan yu ꞌin yu, loꞌo kanꞌ ja yꞌni ndla yu tñan kanꞌ, ta xꞌnan yu nu tiꞌí ꞌin yu bra kanꞌ; tiꞌí ꞌa jwiꞌin xꞌnan yu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Xka la msu nu ja ngwa biyaꞌ tiꞌ sa ñaꞌan tñan ngulo xꞌnan yu ꞌin yu, chinꞌ la nu tiꞌí kaja ꞌin yu bra kanꞌ; siyaꞌ la chinꞌ jwiꞌin xꞌnan yu ꞌin yu, ni siya ndiꞌin chaꞌ lye ꞌa kaja nu tiꞌí ꞌin yu siꞌya tñan nu ja yꞌni yu kanꞌ. Bra nu xnun nten kaꞌan ꞌa tñan ꞌñaan, bra kanꞌ ndiꞌin chaꞌ kuꞌnian kaꞌan la tñan chaꞌ ꞌin neꞌ kanꞌ. Loꞌo Ndiose, si ta Ni tyun lo chaꞌ suꞌwe ꞌñaan, kwiꞌ ngwañaꞌan tyun lo tñan ndiꞌin chaꞌ kuꞌnian chaꞌ ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Wa ndijyaǎn lo chalyuu chaꞌ kwaꞌaǎn kiiꞌ seꞌen ndiꞌin nten, loꞌo ni, suꞌwe la nchka tiǎnꞌ si wa lka nchkin kiiꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wa tyisnan ti ska chaꞌ tnun, wa steěn tiǎn ska tñan, sa ñaꞌan lka si ndukwatya neꞌ ꞌñaǎn; kanꞌ chaꞌ ndaꞌan ꞌa chaꞌ tiyeěn ni, ¿ni sa ñaꞌan bra tsaa tii tñan kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ta xkwiꞌ tiin ti tyiꞌin nten chalyuu chaꞌ wa ndijyaǎn lo chalyuu, xkeꞌ tiꞌ wan a? Siꞌi. Ja nchka tyiꞌin neꞌ tiin ti, chaꞌ nu xkwiꞌ nxuun neꞌ nka tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nde lka chaꞌ nu ka ni, seꞌen ndiꞌin kaꞌyu nten ska naꞌan, bra kanꞌ tyisnan snan neꞌ kanꞌ nu ja msñi chaꞌ ꞌñaǎn, xuun neꞌ kanꞌ loꞌo tyukwa neꞌ nu msñi chaꞌ ꞌñaǎn; si ndiꞌin tukwa nten nu ja msñi chaꞌ ꞌñaǎn loꞌo snan nten nu msñi chaꞌ kanꞌ, ti kwiꞌ ti chaꞌ xuun neꞌ loꞌo taꞌa neꞌ chaꞌ wa yten neꞌ chaꞌ ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Xuun ska nten loꞌo sñiꞌ kiꞌyu yu, kwiꞌ ngwañaꞌan xuun ska yu kiꞌyu loꞌo sti yu; xuun ska neꞌ kula loꞌo nu kunaꞌan sñiꞌ, kwiꞌ ngwañaꞌan xuun ska nu kunaꞌan kuneꞌ loꞌo jyaꞌan; xuun ska neꞌ kula loꞌo sñiꞌ xiin neꞌ, kwiꞌ ngwañaꞌan xuun ska kuxiin loꞌo jyaꞌan laa chaꞌ wa yten neꞌ chaꞌ ꞌñaan ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Xiyaꞌ ykwiꞌ Jesús loꞌo nten nu ndiya seꞌen ndiꞌin yu: ―Loꞌo ꞌwan ni, ndiya bra nu ñaꞌan wan ndyoꞌo tukwa koo tnun nde seꞌen ndyaa kwichaa, kanꞌ chaꞌ nchkwiꞌ wan: “Tyoo kiꞌya ni.” Chañi chaꞌ ꞌwan, kiꞌya tyoo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Bra nu tyisnan xkwa kwiꞌin ndijyan nde jꞌni bra kanꞌ nchkwiꞌ wan: “Wa mdyisnan ka tikeeꞌ kwan ni.” Chañi chaꞌ ꞌwan, ngwañaꞌan ka bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Kwiñi ꞌa ꞌwan! Nchka biyaꞌ tiꞌ wan ska nan nu ñaꞌan wan nde niꞌ kwan; wa nsuꞌwi lyo wan chaꞌ kanꞌ. ¿Ni chaꞌ lka ja ndii ꞌa tiꞌ wan siyaꞌ ti nan ka nu nchka ꞌwan lo chalyuu re ni? ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Ni chaꞌ lka ja nchka ka tiin chaꞌ ꞌwan loꞌo taꞌa wan? ");
INSERT INTO ctpNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nde ñaꞌan kuꞌni wan suꞌwe la, bra nu tsaa loꞌo ska nten ꞌwan seꞌen ndiꞌin wsiya chaꞌ xtya yu kiꞌya ꞌwan: kuwe tiꞌ wan chaꞌ wjñi chaꞌ ꞌwan loꞌo yu laja nu ti ndaꞌan ti wan tuwiin. Si ja kuꞌni wan ngwañaꞌan, bra kanꞌ ta wsiya ꞌwan yaꞌ policía. Loꞌo neꞌ kanꞌ ni, suꞌwa neꞌ ꞌwan niꞌ ñaꞌan chkwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ ja tyoꞌo ꞌa wan siyaꞌ ti sa ñaꞌan yaꞌ nu ta wan nchga tñi nu jñan nten kanꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti kwiꞌ tyempu kanꞌ mdiyan chinꞌ nten seꞌen ndiꞌin Jesús. Ytsaꞌ neꞌ kanꞌ ꞌin yu bra kanꞌ, sa ñaꞌan ngwa bra nu tka yjwi ti gobernador Pilato ꞌin tyun neꞌ Galilea. Laja nu yꞌni kti neꞌ Galilea kanꞌ niꞌ lyaa, bra nu yjwi neꞌ ꞌni chaꞌ ka lomstan ꞌin Ndiose, bra kanꞌ mdiyan sndaru ꞌin Pilato, yjwi sndaru kanꞌ ꞌin neꞌ kanꞌ, ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―¿Ta siꞌya chaꞌ xaꞌan ꞌa neꞌ Galilea kwa, kanꞌ chaꞌ yjwi Pilato ꞌin neꞌ, nxkeꞌ tiꞌ wan a? Ja xaꞌan lye neꞌ kanꞌ. Nan yꞌni ti neꞌ sa ñaꞌan nu ngiꞌni taꞌa kichen tyi neꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","siꞌi nan kuxi la yꞌni neꞌ kanꞌ. Kwiꞌ ngwañaꞌan ꞌwan ni, si ja ka jyuꞌu tiꞌ wan ꞌin nchga chaꞌ kuxi nu ngiꞌni wan, chaꞌ kulaa yaꞌ wan chaꞌ kuxi kanꞌ, ti kwiꞌ ti chaꞌ, ndukwa chaꞌ kaja wan bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Loꞌo xka ta tiꞌyun xnan nten kanꞌ nu ngujwi nde tuꞌwa tyiꞌa Siloé chaꞌ mlyuu naꞌan kwan chunꞌ neꞌ bra kanꞌ. ¿Ta siꞌya chaꞌ xaꞌan ꞌa neꞌ kanꞌ, kanꞌ chaꞌ ngwa ꞌin neꞌ ngwañaꞌan, nxkeꞌ tiꞌ wan a? Ja xaꞌan lye neꞌ kanꞌ. Nan yꞌni ti neꞌ sa ñaꞌan tñan nu ngiꞌni taꞌa kichen tyi neꞌ nde Jerusalén, ");
INSERT INTO ctpNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","siꞌi nan kuxi la yꞌni neꞌ kanꞌ. Kwiꞌ ngwañaꞌan ꞌwan ni, si ja ka jyuꞌu tiꞌ wan ꞌin nchga chaꞌ kuxi nu ngiꞌni wan, chaꞌ kulaa yaꞌ wan chaꞌ kanꞌ, ti kwiꞌ ti chaꞌ, ndiꞌin chaꞌ kaja wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Bra kanꞌ ykwiꞌ Jesús chaꞌ tiya re loꞌo neꞌ: ―Mdiya ska nten nu nsuꞌwi ska yka kwiñii nu suꞌwe ꞌa ꞌin yu, ska yka nu nda mta nu xi ꞌa; ndukwa yka kanꞌ ska niꞌ lyoꞌoo seꞌen yta yu yka chi kutun. Chunꞌ ndiꞌin la ndyaa naꞌan yu ꞌin yka kwiñii kanꞌ si ndukwa nan ku loo. Ja ska nan ndukwa loo, ja ska nan mjwi ku yu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kanꞌ chaꞌ ykwiꞌ yu loꞌo nu ngiꞌni tñan niꞌ lyoꞌoo kanꞌ: “Wa mdaꞌa snan yijan ndyaꞌaǎn naꞌaǎn si tyoꞌo ka nan kuǔn lo yka re, loꞌo ja mjwi ran ꞌñaǎn siyaꞌ ti. Siꞌyuu lyaa ꞌin ran, kuloo ꞌin ran siyaꞌ ti, chaꞌ xuꞌwe ti ndukwa yka kwa lo yuu re; suꞌwe la si xka nan kataan lo yuu re” ndukwin xꞌnan yuu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bra kanꞌ mxkwen yu nu ngiꞌni tñan niꞌ lyoꞌoo kanꞌ ꞌin xꞌnan yu: “Xnuun ꞌin yka re xka yijan ti, yu kula” ndukwin yu. “Kuꞌni xuꞌweěn yuu nu ndiꞌin suun yka re, suꞌwaǎn kaꞌan ꞌa yuu suꞌwe suun ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ja chan si xlyaa la ran tyoꞌo nan loo ran bra kanꞌ; si ja tyoꞌo nan loo ran siyaꞌ ti, siꞌyuǔn ꞌin ran bra kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Mdiya ska tsan taꞌa mdiꞌin Jesús niꞌ lyaa nduꞌu yu ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Loꞌo nde kwa mdiꞌin ska nu kunaꞌan nu msñi kwiꞌin kuxi ꞌin. Siꞌya kwiꞌin kanꞌ ngwa tiꞌí nu kunaꞌan kanꞌ tiꞌyun xnan yijan; wa nchkunꞌ tyukwin chunꞌ, sa ñaꞌan yaꞌ nu ja ngwa ꞌa jñi ran siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Naꞌan Jesús ꞌin neꞌ kula kanꞌ, bra kanꞌ ykwiꞌ yu loꞌo: ―Wa nchkaa ni, ja ka tiꞌí ꞌa ꞌiin xiyaꞌ ―ndukwin yu ꞌin neꞌ kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Loꞌo kanꞌ mstya yaꞌ Jesús chunꞌ neꞌ kula kanꞌ. Bra ti mjñi tyukwin chunꞌ. Bra kanꞌ mdyisnan neꞌ kula nu ngwa tiꞌí kanꞌ ytsaꞌ ꞌin nten, chaꞌ tnun ꞌa chaꞌ yꞌni Ndiose loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Loꞌo ni, nten nu lka ndloo la niꞌ lyaa kanꞌ, msinꞌ ꞌa tiꞌ neꞌ kanꞌ ꞌin yu, chaꞌ wa yꞌni Jesús joꞌó ꞌin nten tsan taꞌa. ―Skwa tsan suꞌwe chaꞌ kuꞌnian tñan ―ndukwin nu lka ndloo la kanꞌ―, kanꞌ tsan suꞌwe chaꞌ kan wan chaꞌ ka joꞌó ꞌwan; ja kan ꞌa wan tsan taꞌa chaꞌ ka joꞌó ꞌwan bra kanꞌ ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","―Kwiñi ꞌa wan ―ndukwin Jesús ꞌin nu lka ndloo la niꞌ lyaa kanꞌ bra kanꞌ―. Nchga wan loꞌo taꞌa wan xtiꞌ wan kuta msu ꞌwan, buru ꞌwan, chaꞌ tsaa loꞌo wan ꞌin iꞌ chaꞌ koꞌo iꞌ tyiꞌa, tsan taꞌa ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Loꞌo nu kunaꞌan re, ti kwiꞌ taꞌa nten ꞌin ayman Abraham nu yuꞌwi ti sꞌni lka, wa tiꞌyun xnan yijan ndatsaa ꞌa Satanás ꞌin seꞌen ndiꞌin. ¿Ja suꞌwe la xkeꞌ tiꞌ wan si kulaan ꞌin neꞌ kula re tsan taꞌa a? ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Mjyuꞌu ꞌa tiꞌ neꞌ nu nka kontra ꞌin Jesús chaꞌ mxkwen yu chaꞌ ꞌin nu lka ndloo la kanꞌ ngwañaꞌan. Bra kanꞌ suꞌwe ꞌa ngwa tiye xka ta nten nu mduun la kanꞌ, chaꞌ naꞌan neꞌ nchga chaꞌ tnun nu yꞌni Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bra kanꞌ ngwaꞌu Jesús xka chaꞌ ꞌin nten: ―Xka chaꞌ chkwiǐnꞌ loꞌo wan ni, chaꞌ ka biyaꞌ tiꞌ wan sa ñaꞌan ka chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Lka chaꞌ kanꞌ ñaꞌan tiꞌ ska mta xiyan kwiꞌin nu xuwe ꞌa, nu ndyaa loꞌo ska nten chaꞌ kata yu ran niꞌ lyoꞌoo ꞌin yu. Loꞌo bra kanꞌ, bra wa ngalu la, ska yka nu wa tnun chinꞌ lka ran. Bra kanꞌ mdyisnan ngala kiñi chaꞌ kwiñan iꞌ seꞌen xkwa iꞌ laja stanꞌ yka kanꞌ, chaꞌ wa tnun chinꞌ yka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Bra kanꞌ ykwiꞌ Jesús xka chaꞌ tiya loꞌo neꞌ: ―Xka chaꞌ chkwiǐnꞌ loꞌo wan ni, sa ñaꞌan ka chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌwan ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ngwañaꞌan lka chaꞌ, sa ñaꞌan lka chinꞌ ti skwan tiyeꞌ nu msuꞌwa ska nu kunaꞌan loꞌo kata jaxlya chaꞌ ka jyaꞌan skwan jaxlya. Suꞌwe ꞌa mxtiyaꞌ ran, chaꞌ sa tlyu ti skwen skwan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tuwiin seꞌen ndyaa Jesús loꞌo neꞌ nde Jerusalén, mdijin neꞌ tyun kichen tnun seꞌen ndyaa neꞌ; loꞌo tyun kichen xuwe ndyaa neꞌ, chaꞌ chkwiꞌ yu chaꞌ ꞌin Ndiose loꞌo neꞌ kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Laja nu mdiꞌin Jesús ska kichen, mnichaꞌ ska nten ꞌin yu: ―Yu kula, ¿ta chinꞌ ti nten kulaa Ndiose ꞌin bra wa tyii ti chalyuu a? ―ndukwin. Mxkwen Jesús ꞌin yu bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Lti ti tunaꞌan seꞌen sten wan la kanꞌ, kanꞌ chaꞌ kuꞌni lya wan chaꞌ tyija tuwiin ꞌwan nu kala nde tunaꞌan kanꞌ. Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan, chaꞌ kaꞌan ꞌa nten ndiꞌin nu nchkwiꞌ chaꞌ wa sten ti neꞌ tunaꞌan kanꞌ, loꞌo ya ñaꞌan ti ngiꞌni neꞌ kanꞌ ndiꞌin neꞌ lo chalyuu, kanꞌ chaꞌ ja nchka tyija lyo ꞌin neꞌ siyaꞌ ti sa ñaꞌan ka nu sten neꞌ tunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Bra kanꞌ tyituun xꞌnan naꞌan kanꞌ, chaꞌ tukunꞌ yu tunaꞌan kanꞌ. Bra nu kala wan, bra kanꞌ tyisnan wan jwiꞌin yaꞌ wan tunaꞌan kanꞌ, chkwiꞌ wan loꞌo: “Slaa lyaa tunaꞌan, yu kula.” Bra kanꞌ chkwiꞌ yu loꞌo wan: “Ja jlyo tiǎnꞌ ni nten lka wan.” ");
INSERT INTO ctpNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Loꞌo kanꞌ xkwen wan ꞌin xꞌnan wan: “Yu kula, wa yku ba tyaja loꞌoo, wa yiꞌo ba tyiꞌa loꞌoo. Wa yaa ba ngwaꞌu ba chaꞌ ꞌiin ꞌin nchga nten taꞌa kichen tyi ba” nchkwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Xiyaꞌ chkwiꞌ yu loꞌo wan bra kanꞌ: “Ja nsuꞌwi lyoǔn siyaꞌ ti ni nten lka wan. Tyaa lya wan suꞌwe la; ja nchka tiǎnꞌ ñaꞌaǎn ꞌwan, chaꞌ nten kuxi lka wan.” ");
INSERT INTO ctpNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kunan ꞌa wan bra kanꞌ, ku liꞌya wan chaꞌ lye ꞌa kasinꞌ tiꞌ wan bra kanꞌ. Ka xiꞌin ꞌa tiꞌ wan bra nu ñaꞌan wan chaꞌ ndiꞌin kaꞌan ꞌa nten seꞌen ndiꞌin Ndiose bra nu tsaa tii chalyuu; loꞌo ayman Abraham, loꞌo ayman Isaac, loꞌo ayman Jacob, loꞌo nchga ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, ñaꞌan wan ꞌin neꞌ ndiꞌin neꞌ la kanꞌ. Loꞌo ꞌwan ni, kulaa yaꞌ Ndiose ꞌwan kanun wan nde liyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nchga kichen chalyuu nsuꞌwi nten nu kan ku nan nu ndiya lo msaa ꞌin Ndiose, bra nu ka Ndiose ndloo la bra nu tsaa tii chalyuu; nde seꞌen ndyoꞌo tukwa kwichaa tyoꞌo neꞌ kan neꞌ, ngwañaꞌan tyoꞌo neꞌ nde seꞌen ndyaa kwichaa, loꞌo laꞌa seꞌen tuꞌwa tyoꞌo neꞌ, loꞌo laꞌa seꞌen tikeeꞌ tyoꞌo neꞌ, kan nchga nten kanꞌ nde seꞌen tlyu seꞌen ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Loꞌo kanꞌ nde loo la tyiꞌin chinꞌ nten nu mdoꞌo tukwa bra nu wa tsaa tii ti chaꞌ; ngwañaꞌan nde chunꞌ la kanun chinꞌ nten nu mdoꞌo tukwa ti kulo la. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ti kwiꞌ ñaꞌan bra mdiyan chinꞌ neꞌ fariseo chaꞌ chkwiꞌ loꞌo Jesús: ―Tyaa lyaa ni ―ndukwin neꞌ ꞌin yu―. Tyoꞌoo seꞌen ndiꞌian re, yaa tyiꞌiin xka seꞌen, chaꞌ wa nchka tiꞌ ree Herodes kujwi ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ykwiꞌ Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Yaa katsaꞌ wan chaꞌ re ꞌin yu kula tlá kanꞌ: “Tsan ni loꞌo tsan tyaa, ti tyiꞌiǐn chinꞌ lo chalyuu re chaꞌ kuloǔn kwiꞌin kuxi nu msñi ꞌin nten, chaꞌ kuꞌniǐn chaꞌ chkaa xka la nten nu tiꞌí. La mdaꞌa snan tsan, bra kanꞌ tyii tñan nu mda Ndiose Stiǐn chaꞌ kuꞌniǐn.” Ngwañaꞌan nchkwin wan ꞌin yu kula kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tyaꞌaǎn ni. Ti kaꞌan chinꞌ tuwiin ti ji tsaꞌaǎn ni, ngwañaꞌan la tyaa, ngwañaꞌan nu mdaꞌa snan tsan. Ykwiꞌ wan jlyo tiꞌ wan chaꞌ nde kichen Jerusalén ndyiji nchga neꞌ nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ―ndukwin Jesús ꞌin neꞌ fariseo kanꞌ―. Kanꞌ chaꞌ tsaꞌaǎn nde kichen kwa chaꞌ kajaǎn, si ngwañaꞌan lkaǎn ska nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten, nxkeꞌ tiꞌ wan ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Tꞌnan ꞌa ꞌwan neꞌ Jerusalén, chaꞌ tukwi ꞌa chaꞌ nu ndiꞌin ꞌwan. Ti sꞌni yjwi wan ꞌin neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten, mguun wan kee ꞌin nten nu ngwa tñan ꞌin Ndiose. Tyun ꞌa bra ngwa tiǎnꞌ chaꞌ ñaꞌansiǐn ꞌwan, chaꞌ ja ka kuxi ꞌwan; ñaꞌan tiꞌ ska kwitu nu msoꞌ tiꞌin sñiꞌ niꞌ jluꞌwe iꞌ, ngwañaꞌan ngwa tiǎnꞌ kuꞌniǐn loꞌo wan, loꞌo ¡ja mda wan chabiyaꞌ ꞌñaǎn siyaꞌ ti! ");
INSERT INTO ctpNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kanꞌ chaꞌ kanun tiꞌin kichen tyi wan xkwiꞌ chaꞌ xiꞌin ti tiꞌ ni. Ja ñaꞌan ꞌa wan ꞌñaǎn sa ñaꞌan yaꞌ nu tiya bra nu chkwiꞌ wan chaꞌ ꞌñaǎn: “Suꞌwe ꞌa ngiꞌni Ndiose loꞌoan chaꞌ ꞌin yu nu ndijyan chabiyaꞌ ꞌin ykwiꞌ nu nka Xꞌnaan” nchkwin wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ska tsan nu nxitñaꞌ neꞌ yaa Jesús yku tlyaa yu naꞌan tyi xꞌnan neꞌ fariseo. Loꞌo xka ta neꞌ fariseo, naꞌan ꞌa neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nde tloo Jesús ndiya ska yu kiꞌyu nu msñi kicha kiin ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Bra kanꞌ mnichaꞌ Jesús ꞌin mstru nu nduꞌu chaꞌ joꞌo loꞌo neꞌ fariseo kanꞌ: ―¿Ta ndiꞌin chabiyaꞌ chaꞌ kuꞌnian joꞌó ꞌin ska nu tiꞌí tsan taꞌa, nxkeꞌ tiꞌ wan a? ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ¿O ta ja ndiꞌin chabiyaꞌ chaꞌ kuꞌnian joꞌó ꞌin neꞌ bra kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ja ykwiꞌ ꞌa neꞌ kanꞌ siyaꞌ ti. Bra kanꞌ msñi Jesús yaꞌ yu tiꞌí kanꞌ, yꞌni chaꞌ nchkaa yu. Loꞌo kanꞌ ykwiꞌ Jesús loꞌo yu kanꞌ: ―Tyaa lyaa naꞌan tyii ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ fariseo kanꞌ xiyaꞌ: ―¿Ni sa ñaꞌan nxkeꞌ tiꞌ wan a? ¿Ni sa ñaꞌan kuꞌni wan si tiyuu ska buru ꞌwan, si tiyuu ska kuta msu ꞌwan ska tu tiyuu tsan nu nxitñaꞌ neꞌ a? ¿Ta siꞌi bra ti tsaa wan kulo wan ꞌin iꞌ, ni siya tsan taꞌa nu tnun ꞌa lka a? ");
INSERT INTO ctpNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ja mjwi ꞌa ñaꞌan xkwen neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Bra kanꞌ naꞌan Jesús chaꞌ xkwiꞌ nxñi neꞌ fariseo kanꞌ yka xlya nu nduun seꞌen suꞌwe la nde ke msaa, chaꞌ tyukwa neꞌ. Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ kanꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Bra nu tsaa wan seꞌen kaja kwilyoꞌo nten, ja tyukwa wan seꞌen nu tlyu la, seꞌen ndyukwa neꞌ nu lka ndloo. ¿Ni sa ñaꞌan kuꞌni wan si tiyan xka nten nu wa tnun la nchka nde seꞌen ndukwa wan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chunꞌ ndiꞌin la, nten nu ngiꞌni taꞌa, nu wa ykwiꞌ loꞌo wan ti kulo la chaꞌ kan wan taꞌa, ja chan chkwiꞌ yu chaꞌ re loꞌo wan: “Ta wan seꞌen tyukwa yu kula re” nchkwin yu. Loꞌo kanꞌ ka jyuꞌu ꞌa tiꞌ wan, tsaa tukwa wan xka seꞌen nu ja nduun yka xlya, la kanꞌ tsaa tukwa wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Siꞌi xkwiꞌ nan tsaa naan wan seꞌen suꞌwe la chaꞌ tyukwa wan sikwa. Bra nu tsaa wan ska taꞌa, tsaa tukwa wan ska laꞌa ti seꞌen ndyukwa nten ya ñaꞌan ti. Loꞌo kanꞌ kan nu lka ndloo la ꞌin taꞌa chaꞌ chkwiꞌ yu loꞌo wan: “Yu kula” nchkwin yu ꞌwan, “Kan wan tyukwa wan chinꞌ seꞌen suꞌwe la nde re.” Ngwañaꞌan kuꞌni tnun la neꞌ ꞌin ykwiꞌ wan laja nten kaꞌan nu ndukwa tuꞌwa msaa kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nchga nten nu nchka tiꞌ chaꞌ ka tlyu la ykwiꞌ, kanꞌ lka nu ka jyuꞌu la tiꞌ chunꞌ ndiꞌin la; loꞌo nten nu chinꞌ ti chaꞌ nka tiye ykwiꞌ neꞌ, suꞌwa yaꞌ Ndiose ꞌin neꞌ kanꞌ, chaꞌ ka ngula la niꞌ kasiya ꞌin neꞌ chunꞌ ndiꞌin la. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Bra kanꞌ nde lka chaꞌ nu ykwiꞌ Jesús loꞌo yu kiꞌyu nu wa ykwiꞌ loꞌo chaꞌ kan taꞌa seꞌen ndiꞌin yu: ―Bra nu chkwiꞌ wan loꞌo nten chaꞌ kan neꞌ ku tlyaa neꞌ seꞌen ndiꞌin wan, siꞌi loꞌo taꞌa suꞌwe nsuꞌwi ti wan chkwiꞌ wan, siꞌi loꞌo taꞌa ngula ti wan chkwiꞌ wan, siꞌi loꞌo taꞌa tijyuꞌ ti wan chkwiꞌ wan, siꞌi loꞌo neꞌ kuliyaꞌ ti nu ndukwa naꞌan tyi kwiꞌ seꞌen ti chkwiꞌ wan bra kanꞌ. Suꞌwa ti kuꞌni neꞌ kanꞌ loꞌo wan chunꞌ ndiꞌin la, bra nu ngiꞌni neꞌ ska taꞌa; sa ñaꞌan nu yꞌni wan loꞌo neꞌ, ngwañaꞌan ti kuꞌni neꞌ kanꞌ loꞌo wan xiyaꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ꞌWan ni, siꞌi ngwañaꞌan kuꞌni wan bra nu kuꞌni wan ska taꞌa. Bra kanꞌ xoꞌ tiꞌin wan neꞌ tiꞌí, loꞌo neꞌ kicha, loꞌo neꞌ nu chkuꞌ kiyaꞌ, loꞌo neꞌ kwityiinꞌ chaꞌ ku neꞌ loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Bra kanꞌ suꞌwe ꞌa tyiꞌin wan lo chalyuu si ngwañaꞌan kuꞌni wan, chaꞌ nu kicha kanꞌ ni, ja kaja ñaꞌan tya neꞌ chaꞌ suꞌwe kanꞌ ꞌwan. Chunꞌ ndiꞌin la kaja chaꞌ suꞌwe ꞌwan, bra nu tyuꞌu wan xiyaꞌ loꞌo nchga ayman nu ngwa suꞌwe kasiya ꞌin neꞌ loꞌo Ndiose bra nu mdiꞌin neꞌ lo chalyuu nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ti ndiꞌin neꞌ tuꞌwa msaa, nganan neꞌ nchga chaꞌ nu nchkwiꞌ Jesús loꞌo neꞌ. Bra kanꞌ mxkwen ska neꞌ taꞌa ndukwa yu tuꞌwa msaa ꞌin Jesús: ―Suꞌwe ꞌa ka ꞌin nten nu ku skwa nde seꞌen lka Ndiose ndloo la ―ndukwin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Bra kanꞌ ykwiꞌ Jesús chaꞌ tiya re loꞌo yu, chaꞌ ka biyaꞌ tiꞌ neꞌ sa ñaꞌan ka ꞌin nten chalyuu bra nu kan Ndiose chaꞌ ka Ni ndloo la. ―Ndiya ska yu kiꞌyu yꞌni yu ska taꞌa, nda yu ska siin chaꞌ ku neꞌ ―ndukwin Jesús ꞌin neꞌ―. Wa ykwiꞌ yu loꞌo kaꞌan ꞌa nten chaꞌ tyiꞌin neꞌ taꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wa mdiya bra chaꞌ ka siin, bra kanꞌ ngulo yu tñan ꞌin msu ꞌin yu chaꞌ tsaa chkwiꞌ loꞌo neꞌ: “Wa lka ngwa suꞌwe skwa nu ka siin ꞌwan, ndukwin xꞌnan ba.” ");
INSERT INTO ctpNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bra kanꞌ nchga nten nu wa ykwiꞌ yu loꞌo chaꞌ kan neꞌ taꞌa, mdyisnan neꞌ mjñan neꞌ chaꞌ tlyu tiꞌ ꞌin yu. Nde lka chaꞌ nu ykwiꞌ ska yu kanꞌ: “Kuꞌnii chaꞌ tlyu tiꞌ ꞌñaǎn, ja ka ꞌñaǎn kaǎn seꞌen ndiꞌiin ni. Ndiꞌin chaꞌ tsaꞌaǎn tsaa naꞌaǎn ska yuu nu tka msiꞌiǐn tiǎn, kanꞌ chaꞌ nchka tiǎnꞌ chaꞌ kuꞌnii chaꞌ tlyu tiꞌ ꞌñaǎn.” ");
INSERT INTO ctpNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Loꞌo kanꞌ ykwiꞌ xka yu: “Tka msiꞌiǐn tiǎn kiꞌyu ta kuta msu; kanꞌ chaꞌ tsaꞌaǎn kuꞌni biyaǎnꞌ loꞌo iꞌ, si wa ka kuꞌni iꞌ tñan. Kuꞌnii chaꞌ tlyu tiꞌ ꞌñaǎn, ja ka ꞌñaǎn kaǎn seꞌen ndiꞌiin ni.” ");
INSERT INTO ctpNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Bra kanꞌ ykwiꞌ xka yu: “Tka mjwi ti kwilyoꞌoǔn, kanꞌ chaꞌ ja ka ꞌñaǎn kaǎn seꞌen ndiꞌiin ni.” ");
INSERT INTO ctpNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bra kanꞌ wa ngala msu seꞌen ndiꞌin xꞌnan yu xiyaꞌ, ytsaꞌ yu ꞌin xꞌnan yu nchga chaꞌ nu ndukwin neꞌ ꞌin yu. Lye ꞌa msinꞌ tiꞌ xꞌnan naꞌan kanꞌ bra kanꞌ. Loꞌo kanꞌ ykwiꞌ yu loꞌo msu kanꞌ: “Yaa lyaa lo kichen xiyaꞌ chaꞌ chkwiiꞌ loꞌo nten nu ndiꞌin lo kiyaꞌ kwa, chaꞌ kan neꞌ taꞌa seꞌen ndiꞌiǐn. Chkwiiꞌ loꞌo neꞌ tiꞌi, loꞌo nten nu tiꞌí, loꞌo neꞌ nu chkuꞌ kiyaꞌ, loꞌo neꞌ kwityiinꞌ, loꞌo nchga neꞌ kicha; bra kanꞌ kaan loꞌo ꞌin nchga neꞌ kanꞌ nde re” ndukwin xꞌnan msu kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chunꞌ ndiꞌin la ykwiꞌ msu kanꞌ loꞌo xꞌnan yu: “Yu kula” ndukwin, “wa yꞌniǐn nchga tñan nu nguloo ꞌñaǎn, loꞌo ñaꞌan ti laja la seꞌen tyiꞌin nten niꞌ ñaꞌan re.” ");
INSERT INTO ctpNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Bra kanꞌ ykwiꞌ xꞌnan msu loꞌo yu: “Yaa lyaa lo kichen xiyaꞌ, yaa ñaꞌaan tuwiin, suꞌwaa jwersa chaꞌ lye tatsaa ꞌin neꞌ chaꞌ kan neꞌ niꞌ ñaꞌan ꞌñaǎn, chaꞌ xaꞌan niꞌ ñaꞌan re ꞌñaǎn tyiꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan, chaꞌ ja ska nten nu ykwiꞌ yu loꞌo ti kulo la, ja ku ꞌa neꞌ kanꞌ siin re ꞌñaǎn siyaꞌ ti” ndukwin xꞌnan naꞌan kanꞌ. Wa mdyii chaꞌ tiya nu mda Jesús loꞌo neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Kaꞌan ꞌa nten ndaꞌan loꞌo Jesús, loꞌo kanꞌ ykwiꞌ yu loꞌo neꞌ xiyaꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―¿Ta nchka tiꞌ wan tyaꞌan wan loꞌoǔn a? Ja ka ꞌwan xñi wan chaꞌ ꞌñaǎn si lye la nka tiye wan ꞌin sti wan, ꞌin jyaꞌan wan, ꞌin kwilyoꞌo wan, ꞌin sñiꞌ wan, ꞌin taꞌa ngula wan, ni siya yu kiꞌyu ni siya neꞌ kunaꞌan; si lye la nsuꞌwi tiye wan ꞌwan chaꞌ ñaꞌansiin wan ꞌwan, ti ykwiꞌ ti wan, ja ka ꞌwan ka wan nten ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Si ja xlyaa wan xñi wan tuwiin nu kwaꞌuǔn ꞌwan, ja ka ꞌwan ka wan nten ꞌñaǎn bra kanꞌ; ndiꞌin chaꞌ xñi wan tuwiin kanꞌ, ni siya kujwi nten ꞌwan chunꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Si ndiya ska wan nu nchka tiꞌ wan kwiñan wan ska naꞌan tnun, ja chan ti kulo la kulo wan kwenta sa kwa tñi kunanjoꞌo ꞌwan chaꞌ tyii tyaꞌ naꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Si xtya wan kiyaꞌ naꞌan, loꞌo chunꞌ ndiꞌin la ja ka kuꞌni tyii wan naꞌan kanꞌ, nchga nten nu ñaꞌan tñan kanꞌ, xtyi lyoꞌo neꞌ ꞌwan bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Yu kwa ngwa tiꞌ yu kwiñan yu ska naꞌan tnun, loꞌo ja ngwa ꞌin yu kwiñan ji yu naꞌan kanꞌ” nchkwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Ñaꞌan tiꞌ ska ree nu nchka tiꞌ xuun loꞌo xka ree. Ti kulo, kulo yu kwenta chaꞌ ka biyaꞌ tiꞌ yu si tyoꞌo skwa tii mi sndaru ꞌin yu, chaꞌ tyijin lyo yu ꞌin xka ree nu loꞌo kala mi sndaru ꞌin ndijyan kusuun. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si jlyo tiꞌ ree kanꞌ chaꞌ ja ka ꞌin, bra nu ti tijyuꞌ ndijyan xka ree kanꞌ, bra ti suꞌwa yu ꞌin nten nu tsaa seꞌen ndijyan ree kanꞌ, chaꞌ chkwiꞌ neꞌ loꞌo yu, chaꞌ ja kuꞌni ꞌa neꞌ chaꞌ wsuun kanꞌ. Ngwañaꞌan kuꞌni ree kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kwiꞌ ngwañaꞌan nchga wan nu lye la nka tiye wan ꞌin nchga chaꞌ suꞌwe nu nsuꞌwi ꞌwan, nu ja xlyaa wan kulaa yaꞌ wan ꞌin chaꞌ kanꞌ, ja ka ꞌwan ka wan nten ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ni siya suꞌwe ꞌa tejeꞌ, bra nu tyii chaꞌ tiyenꞌ nu nsuꞌwi ꞌin ran, ja ka ꞌa kunanjoꞌo tejeꞌ kanꞌ ꞌin nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ja ska tñan suꞌwe ka kuꞌni ran, ja ka sluan ꞌin ran lyuu chaꞌ ka suꞌwe la yuu, ja ka xtiyaanꞌ ꞌin ran loꞌo yuu kata. Ndiꞌin chaꞌ xkwaan ꞌin ran ―ndukwin Jesús―. Kunan suꞌwe wan chaꞌ nu nchkwiǐnꞌ loꞌo wan, si xlyaa wan kunan wan ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nchga msu ꞌin neꞌ xka laꞌa tsuꞌ nu ndlo kaꞌan ꞌa tñi ꞌin nten, mdiyan neꞌ seꞌen ndiꞌin Jesús chaꞌ kunan neꞌ sa ñaꞌan chaꞌ nduꞌu yu; loꞌo xka ta neꞌ nu kuxi ngiꞌni, mdiyan neꞌ seꞌen ndiꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kanꞌ chaꞌ mdyisnan neꞌ fariseo, loꞌo mstru nu nduꞌu chaꞌ joꞌo, mxichaꞌ neꞌ ꞌin Jesús: ―Ndiya tiꞌ yu re ka suꞌwa chaꞌ ꞌin yu loꞌo neꞌ kwa nu ngiꞌni ꞌa chaꞌ kuxi. Suꞌwa ti nchku yu tyaja loꞌo neꞌ kuxi kwa ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Bra kanꞌ ngwaꞌu Jesús chaꞌ tiya re ꞌin neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―ꞌWan ni, si ndiya ska siyentu slyaꞌ ꞌwan, loꞌo kanaꞌ ska iꞌ ꞌwan bra kanꞌ ―ndukwin Jesús―, ¿ta ja xnun tiꞌin wan ꞌin kaꞌan la slyaꞌ kanꞌ, chaꞌ kanun iꞌ seꞌen suꞌwe ndiꞌin iꞌ niꞌ kixinꞌ kanꞌ a? Xnun wan ꞌin iꞌ chañi, chaꞌ nu tsaa naan wan ꞌin nu mnaꞌ kanꞌ ꞌwan sa ñaꞌan yaꞌ nu tyija iꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bra wa ndyija slyaꞌ kanꞌ ꞌwan, ka suꞌwe ꞌa ka tiye wan bra kanꞌ. Bra ti xtya wan ꞌin iꞌ skun wan, ");
INSERT INTO ctpNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","tyaan loꞌo wan ꞌin iꞌ tuꞌ naꞌan tyi wan. Bra nu wa ngala wan naꞌan tyi wan, bra kanꞌ xoꞌ tiꞌin wan ꞌin nchga taꞌa suꞌwe nsuꞌwi wan loꞌo nchga nten nu ndiꞌin kwiꞌ seꞌen ti seꞌen ndiꞌin wan, chaꞌ chkwiꞌ wan loꞌo neꞌ: “Ka suꞌwe ꞌa ka tiye wan loꞌo ba ni, chaꞌ wa ndyija slyaꞌ nu wa mnaꞌ ꞌwa.” ");
INSERT INTO ctpNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan: Ka suꞌwe ꞌa ka tiye Ndiose loꞌo nten ꞌin Ni nde seꞌen ndiꞌin Ni ―ndukwin Jesús ꞌin neꞌ fariseo bra kanꞌ―, chaꞌ wa ngwa jyuꞌu tiꞌ ni siya ska ti nten chalyuu ꞌin chaꞌ kuxi nu yꞌni neꞌ, chaꞌ ngulaa yaꞌ yu chaꞌ kuxi kanꞌ bra kanꞌ. Ja ndiꞌin chaꞌ tyaꞌan chaꞌ tiye Ndiose chaꞌ ꞌin xka jakwa yla nsuꞌwi tiꞌyun lkwa nten suꞌwe nu ja ndiꞌin chaꞌ kuxi ꞌin neꞌ, nxkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ngwaꞌu Jesús xka chaꞌ tiya ꞌin neꞌ bra kanꞌ: ―¿Ni sa ñaꞌan kuꞌni ska nu kunaꞌan nu nsuꞌwi tii tñi plata ꞌin a? Si kanaꞌ ska tñi plata kanꞌ ꞌin neꞌ, ¿ni sa ñaꞌan kuꞌni neꞌ bra kanꞌ a? Ja chan kwaꞌan nu kunaꞌan kanꞌ kiiꞌ chaꞌ xuꞌwi xaa chaꞌ ykwa suꞌwe neꞌ niꞌ ñaꞌan kanꞌ, sa ñaꞌan yaꞌ nu tyija tñi kanꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Bra nu wa ndyija tñi kanꞌ ꞌin neꞌ, bra kanꞌ xoꞌ tiꞌin nu kunaꞌan kanꞌ ꞌin nchga taꞌa suꞌwe nsuꞌwi neꞌ loꞌo nchga nten nu ndiꞌin kwiꞌ seꞌen ti, chaꞌ katsaꞌ ꞌin nchga neꞌ kanꞌ: “Ka suꞌwe ka tiye wan loꞌoǔn ni, chaꞌ wa ndyija tñi nu mnaꞌ kanꞌ ꞌñaǎn.” ");
INSERT INTO ctpNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Suꞌwe ꞌa ka tiye nu kunaꞌan kanꞌ, chaꞌ wa ndyija lyo tñi ꞌin neꞌ; kwiꞌ ngwañaꞌan ka seꞌen ndiꞌin Ndiose, ka suꞌwe ꞌa ka tiye Ndiose loꞌo nten ꞌin Ni nde niꞌ kwan, chaꞌ wa ngwa jyuꞌu tiꞌ ska ti nten chalyuu ꞌin chaꞌ kuxi nu yꞌni, ngulaa yaꞌ yu chaꞌ kuxi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ngwaꞌu Jesús xka chaꞌ tiya ꞌin neꞌ bra kanꞌ: ―Ndiya ska yu kula nu ndiya tukwa sñiꞌ kiꞌyu yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Loꞌo nu kuneꞌ ni, ykwiꞌ yu loꞌo sti yu: “Stiǐn” ndukwin, “tyaa lyaa nchga chaꞌ suꞌwe nu ndiꞌin chaꞌ kaja ꞌñaǎn.” Kanꞌ chaꞌ bra ti msuꞌwe sti yu nchga chaꞌ suꞌwe nu mdiꞌin ꞌin yu chaꞌ kaja ꞌin taꞌa tyukwaa sñiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xa wa mdijin chinꞌ ti tsan, bra kanꞌ yjwiꞌ yu kuneꞌ kanꞌ nchga chaꞌ suꞌwe nu wa mda sti yu ꞌin yu. Bra wa mjwi tñi kanꞌ ꞌin yu, mdoꞌo yu ndyaa yu tijyuꞌ loꞌo tñi kanꞌ bra kanꞌ. Nde xka laꞌa tsuꞌ seꞌen ndyaa yu, xkwiꞌ ya ñaꞌan ti ñaꞌan ngwiji yu tñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Xa wa mdyii tñi ꞌin yu, bra kanꞌ ngwa ska jwiꞌñan tlyu nde lo yuu seꞌen ndiꞌin yu; ja yuꞌwi ꞌa nan ku yu, lye ꞌa mteꞌ tiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ti kwiꞌ kichen seꞌen ndiꞌin yu kanꞌ mdyisnan yꞌni yu tñan ꞌin ska nten; ngulo yu kanꞌ tñan ꞌin yu chaꞌ tsaa yu niꞌ lyoꞌoo seꞌen ndiꞌin kuweꞌ ꞌin yu, chaꞌ ñaꞌansiin yu ꞌin kuweꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Loꞌo kanꞌ ngwa tiꞌ yu ku yu ndaꞌ nu nchku kuweꞌ kanꞌ si ka kalaꞌ chinꞌ tiꞌ yu loꞌo ran, chaꞌ ja tukwin nda nan ku yu, mteꞌ ꞌa tiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Chunꞌ ndiꞌin la nduwe suꞌwe tiꞌ yu: “¿Ni a? ¿Ni lkwa msu ndiꞌin naꞌan tyi stiǐn ngiꞌni tñan a? ¡Loꞌo ja ndyiji jwiꞌñan neꞌ kanꞌ, ti nganun la nan nchku neꞌ kanꞌ! ¡Loꞌo naꞌ ni, nde re ndiꞌiǐn ndijiǐn jwiꞌñan chaꞌ ja ndyiji nan kuǔn siyaꞌ ti! ");
INSERT INTO ctpNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Suꞌwe la tyaꞌaǎn nde naꞌan tyi stiǐn chaꞌ chkwiǐnꞌ loꞌo: Stiǐn, chkwiǐnꞌ loꞌo yu, wa kaꞌan ꞌa kiꞌya ndukwiǐn chaꞌ ꞌin Ndiose loꞌo chaꞌ ꞌiin, chaꞌ mdaꞌaǎn yuꞌwiǐn tiǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ja ndiꞌin ꞌa chaꞌ chkwiiꞌ chaꞌ sñiiꞌ lkaǎn; sa ñaꞌan nu ngiꞌnii loꞌo msu ꞌiin, kwiꞌ ngwañaꞌan kuꞌnii loꞌoǔn ni.” Ngwañaꞌan mdaꞌan chaꞌ tiye yu chaꞌ chkwiꞌ yu loꞌo sti yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Bra kanꞌ mdoꞌo yu ndyaan yu tuwiin nde naꞌan tyi sti yu. ’Ti tijyuꞌ ndyaan yu, naꞌan sti yu ꞌin yu bra kanꞌ. Bra ti ndyaa sti yu ndyukwa taꞌa yu loꞌo sñiꞌ yu; msñi siꞌ taꞌa yu loꞌo sñiꞌ yu bra kanꞌ, sti yu ykwichaꞌ ꞌin yu chaꞌ nchka tꞌnan ꞌa tiꞌ sti yu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Bra kanꞌ ykwiꞌ yu loꞌo sti yu: “Stiǐn” ndukwin yu, “wa kaꞌan ꞌa kiꞌya ndukwiǐn chaꞌ ꞌin Ndiose loꞌo chaꞌ ꞌiin. Ja ndiꞌin ꞌa chaꞌ chkwiiꞌ loꞌoǔn chaꞌ lkaǎn sñiiꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Bra kanꞌ ykwiꞌ yu kula kanꞌ loꞌo msu ꞌin yu: “Yaa lya wan kulo wan teꞌ nu suꞌwe la ñaꞌan chaꞌ xkuꞌ wan ꞌin yu re. Suꞌwa wan ska kwiiꞌ yaꞌ yu, suꞌwa wan ska ta kanan tiji kiyaꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Loꞌo kanꞌ tsaa ꞌya wan kuta kuneꞌ nu taan la chaꞌ kujwi wan chaꞌ kuan. ¡Kuꞌnian ska taꞌa! ");
INSERT INTO ctpNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mdaꞌan chaꞌ tiyeěn chaꞌ wa ngujwi sñiěnꞌ re, loꞌo ni, xiyaꞌ mdoꞌo tukwa yu; wa mnaꞌ yu, mskeꞌ tiǎnꞌ, loꞌo xiyaꞌ ngala yu nde re.” Bra ti mdyisnan yꞌni neꞌ ska taꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ngwañaꞌan ngwa chaꞌ bra nu mdoꞌo tukwa sñiꞌ nu wa kula la, ngala yu yaa yu tñan. Wa kala ti yu tuꞌ naꞌan tyi sti yu, bra kanꞌ ynan yu chaꞌ nganen muska, chaꞌ wa nchka taꞌa la ngala yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Bra kanꞌ msiꞌya yu ꞌin ska yu kuneꞌ, mnichaꞌ yu ꞌin msu kanꞌ: “¿Nan lka nchka nde kwa a?” ");
INSERT INTO ctpNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Bra kanꞌ mxkwen yu kuneꞌ ꞌin yu: “Yu taꞌaa nu mdaꞌan yuꞌwi ti, wa ngala yu kanꞌ ni” ndukwin yu kuneꞌ kanꞌ. “Kanꞌ chaꞌ ndukwin sti wan chaꞌ kujwi ba kuta kuneꞌ nu suꞌwe la ñaꞌan kanꞌ, chunꞌ nchka suꞌwe ꞌa nka tiye sti wan chaꞌ wa ngala yu suꞌwe ti.” ");
INSERT INTO ctpNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Msinꞌ ꞌa tiꞌ sñiꞌ nu kula la kanꞌ bra kanꞌ. Bra wa naꞌan sti yu chaꞌ ja xlyaa ꞌa yu sten yu niꞌ naꞌan, bra kanꞌ yaa ykwiꞌ sti yu loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bra kanꞌ ndukwin yu ꞌin sti yu: “Jlyo tiiꞌ ni wa nkwa yijan ndiꞌiǐn ngiꞌniǐn tñan ꞌiin, ja ska yaꞌ yꞌniǐn chaꞌ xaꞌan loꞌoo; nchga tñan nu nguloo ꞌñaǎn, yꞌniǐn kanꞌ. Loꞌo ni ska chivu xuwe ti ja mdaa ꞌñaǎn chaꞌ kuꞌniǐn taꞌa loꞌo taꞌa suꞌweěn nsuꞌwiǐn. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Loꞌo ni, xiyaꞌ ngala sñiiꞌ nu wa yꞌni tyii tñi ꞌiin, ngwiji ya ñaꞌan ti, chaꞌ lye ꞌa yuꞌwi nu kunaꞌan ꞌin yu. Chaꞌ ngala ti yu kanꞌ, bra ti yjwi wan kuta kuneꞌ nu taan la chaꞌ ka taꞌa ꞌin yu” ndukwin sñiꞌ nu wa kula la. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Bra kanꞌ ykwiꞌ yu kula sti yu loꞌo yu: “Chañi chaꞌ nchga tsan ndiꞌiin loꞌoǔn. Kwiꞌ ngwañaꞌan, nchga chaꞌ suꞌwe nu ndiya ꞌñaǎn, nan ꞌiin lka nchga nan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Loꞌo yu taꞌaa ni, ni siya lye ꞌa mdaꞌan yuꞌwi yu, suꞌwe chaꞌ ngiꞌnian ska taꞌa chaꞌ suꞌwe ti ngala yu ni. Mdaꞌan chaꞌ tiyeěn chaꞌ wa ngujwi yu, bra kanꞌ ndyoꞌo tukwa yu xiyaꞌ; wa mnaꞌ yu, mxkeꞌ tiǎnꞌ, bra kanꞌ ngala yu xiyaꞌ. Kanꞌ chaꞌ ngiꞌnian ska taꞌa ni, chaꞌ lka suꞌwe ꞌa nka tiyeěn ndiꞌiǐn.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Mdiya ska yu kuliyaꞌ, loꞌo yuꞌwi ska nten nu ndlo tñan ꞌin msu ꞌin yu kuliyaꞌ kanꞌ. Wa mdiya ska tsan ytsaꞌ neꞌ ꞌin yu kuliyaꞌ kanꞌ, chaꞌ wa tyii ti chaꞌ suꞌwe nu nsuꞌwi ꞌin yu, chaꞌ ya ñaꞌan ti ngwiji msu nu ndlo tñan kanꞌ chaꞌ suꞌwe nu ndiya ꞌin yu kuliyaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Bra kanꞌ msiꞌya xꞌnan ꞌin msu nu ndlo tñan kanꞌ, chaꞌ kunichaꞌ yu ꞌin msu kanꞌ: “¿Ni sa ñaꞌan ndyoꞌo chaꞌ nu nchkwiꞌ nten loꞌoǔn chaꞌ ꞌiin a?” ndukwin yu. “¿Ni ñaꞌan tñan wa yꞌnii chaꞌ nchkwiꞌ neꞌ loꞌoǔn ngwañaꞌan a? Tyaa kwenta ꞌñaǎn ni, katsaaꞌ lyaa ꞌñaǎn nchga tñan nu wa yꞌnii. Ja ka ꞌa ꞌiin ka ndloo la ꞌin msu ꞌñaǎn ni.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lye ꞌa mdaꞌan chaꞌ tiye msu nu ndlo tñan kanꞌ bra kanꞌ: “¿Nan lka kuꞌniǐn ni, si ja ta ꞌa xꞌnaǎn tñan nu kuꞌniǐn a? Ja jlyo ꞌa tiǎnꞌ sa ñaꞌan tñan kuꞌniǐn bra kanꞌ. Ja taloǔn kuꞌniǐn tñan niꞌ kixinꞌ; si tsaꞌaǎn lo kiyaꞌ chaꞌ jñaǎn lomstan, ka jyuꞌu ꞌa tiǎnꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Kanꞌ chaꞌ ni, wa jlyo tiǎnꞌ sa ñaꞌan nu kuꞌniǐn chaꞌ kaja seꞌen tyiꞌiǐn naꞌan tyi nten, si ja ta ꞌa xꞌnaǎn tñan nu kuꞌniǐn.” Kanꞌ lka chaꞌ nu mdaꞌan chaꞌ tiye msu kanꞌ, loꞌo kuxi ti tiye yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bra kanꞌ msiꞌya yu ꞌin nchga nten nu ndukwi tneꞌ ꞌin xꞌnan yu, mnichaꞌ yu ꞌin neꞌ bra kanꞌ: “¿Ni lkwa nan ndukwii ꞌin xꞌnaǎn a?” ndukwin yu ꞌin ska neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Ska mi litro sete ndukwiǐn ꞌin yu kwa” ndukwin neꞌ kanꞌ bra kanꞌ. Bra ti ndukwin msu nu ndlo tñan kanꞌ ꞌin neꞌ kanꞌ: “Nde ndiya kityi seꞌen nu ndukwa kwenta ꞌin tneꞌ nu ndukwii. Tyukwaa chinꞌ nde re chaꞌ kuꞌnii xka kityi, nu ndukwin chaꞌ kiꞌyu ti siyentu litro sete ndukwii ꞌin yu kula kanꞌ” ndukwin msu kanꞌ ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Bra kanꞌ mnichaꞌ yu ꞌin xka yu: “Nuꞌwin ni, ¿ni lkwa nan ndukwii ꞌin xꞌnaǎn a?” “Ska siyentu kwijin nskwaꞌ trigu” ndukwin yu kanꞌ bra kanꞌ. “Jaan” ndukwin yu, “nde ndiya kityi seꞌen nu ndukwa kwenta ꞌiin” ndukwin msu kanꞌ. “Tyukwaa chinꞌ nde re chaꞌ kuꞌnii xka kityi nu ndukwin chaꞌ jakwa yla ti kwijin, sa kanꞌ ti ndukwii ꞌin yu kula kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Chunꞌ ndiꞌin la ngwa biyaꞌ tiꞌ ykwiꞌ xꞌnan yu sa ñaꞌan tñan nu yꞌni yu. “Sa ꞌa yꞌni msu nu ndlo tñan kanꞌ ꞌñaǎn bra nu yꞌni yu tñan” ndukwin yu kula kuliyaꞌ kanꞌ. Ti nchkwiꞌ la Jesús loꞌo neꞌ kanꞌ bra kanꞌ: ―Loꞌo ꞌwan ni, nu nchka ꞌa tiꞌ wan tukwa wan nchga chaꞌ nu nchkwiꞌ Ndiose ―ndukwin― ka kuꞌni xaꞌan wan chinꞌ chaꞌ bra nu ñaꞌan wan sa ñaꞌan nu ngiꞌni xka ta nten chalyuu loꞌo taꞌa neꞌ, ni siya kuxi ti tiye neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan sikwa. Suꞌwe ti kuꞌni wan loꞌo nchga chaꞌ suꞌwe nu nsuꞌwi ꞌwan lo chalyuu re; tayaꞌ wan ꞌin xka la nten loꞌo chaꞌ suꞌwe nu nsuꞌwi ꞌwan sa ñaꞌan yaꞌ tsaa tii chalyuu ꞌwan, chaꞌ ngwañaꞌan kaja taꞌa suꞌwe nsuꞌwi ꞌwan lo chalyuu re. Loꞌo bra kanꞌ ta Ndiose seꞌen tyiꞌin wan nde seꞌen ndiꞌin Ni, xka chalyuu nu ja tsaa tii ꞌa kaja ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Nten nu suꞌwe ꞌa yꞌni ji ska tñan xuwe ti, ngwañaꞌan suꞌwe kuꞌni neꞌ ska tñan nu wa tlyu la; loꞌo nten nu kwiñi lyoꞌo ꞌin xꞌnan, laja nu ngiꞌni neꞌ ska tñan xuwe ti, ja chan ja ka kuꞌni neꞌ ska tñan nu wa tlyu la. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si ja nchka ñaꞌansiin wan ska chaꞌ suꞌwe nu nsuꞌwi ꞌwan lo chalyuu, ti kwiꞌ ti chaꞌ, ja ta Ndiose ska tñan suꞌwe la chaꞌ kuꞌni wan chaꞌ ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nchga chaꞌ suꞌwe nu nsuꞌwi ꞌwan lo chalyuu, nan wa nda Ndiose chaꞌ kanꞌ chaꞌ ñaꞌansiin wan ꞌin ran; si ja kuꞌni suꞌwe ti wan loꞌo chaꞌ kanꞌ, ¿ni sa ñaꞌan kuꞌni wan loꞌo chaꞌ suꞌwe nu nda Ndiose chaꞌ kanun niꞌ kasiya ꞌwan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ska msu ni, ja ka kuꞌni yu tñan ꞌin tukwa xꞌnan yu ska bra ti; kuꞌni yu tñan ꞌin ska ti xꞌnan yu ska yaꞌ ti. Ja chan ka tiꞌí tiꞌ yu ꞌin ska xꞌnan yu bra kanꞌ, loꞌo suꞌwe la chkwiꞌ yu loꞌo xka xꞌnan yu bra kanꞌ; ti kwiꞌ ti chaꞌ, suꞌwe la kuꞌni yu tñan ꞌin ska ti xꞌnan kanꞌ, loꞌo chinꞌ la tñan kuꞌni yu ꞌin xka xꞌnan bra kanꞌ. Ja ka xñian chaꞌ ꞌin Ndiose nu nka Xꞌnaan si ndiya ꞌa tianꞌ ꞌin tñi, chaꞌ sa ñaꞌan lka xka xꞌnaan, ngwañaꞌan lka tñi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Loꞌo neꞌ fariseo, chaꞌ nu ndiya ꞌa tiꞌ neꞌ kanꞌ tñi, kanꞌ chaꞌ bra wa ynan neꞌ chaꞌ nu nchkwiꞌ Jesús, mstyi lyoꞌo neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―ꞌWan ―ndukwin yu― suꞌwe ꞌa ngiꞌni wan chaꞌ ñaꞌan nten ꞌwan, loꞌo wa jlyo suꞌwe tiꞌ Ndiose nchga chaꞌ kuxi nu ndaꞌan chaꞌ tiye wan. Nten nu ngiꞌni tnun ꞌin ti ykwiꞌ ti, kulaa yaꞌ Ndiose ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Bra wa sꞌni, ndiꞌin chaꞌ kula ꞌin nten, ti kwiꞌ chaꞌ nu wa ykwiꞌ Ndiose loꞌo Moisés, loꞌo neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten sꞌni; bra nu yan Xuwa, ti bra kanꞌ mdyisnan nganen chaꞌ suꞌwe ꞌin Ndiose, chaꞌ ka Ndiose ndloo niꞌ kasiya ꞌin nten. Kaꞌan ꞌa nten nsuꞌwa neꞌ jwersa chaꞌ xñi neꞌ chaꞌ ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ja tlyu tñan tsaa tii nchga nan nu nsuꞌwi nde niꞌ kwan, kwiꞌ ngwañaꞌan, tsaa tii tyukwi ñaꞌaan lo chalyuu; loꞌo ja tsaa tii ꞌa nchga chaꞌ nu wa ykwiꞌ Ndiose loꞌo nten sꞌni, ni siya ska chaꞌ nu chinꞌ la. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ti nchkwiꞌ la Jesús loꞌo neꞌ bra kanꞌ: ―Bra nu ngulo ska nten kityi chaꞌ kulaa tiꞌin yu ꞌin kwilyoꞌo yu, chaꞌ xiyaꞌ kaja kwilyoꞌo yu loꞌo xka neꞌ kunaꞌan, chaꞌ kuxi ngiꞌni yu kanꞌ bra kanꞌ. Kwiꞌ ngwañaꞌan, si kaja kwilyoꞌo ska yu kiꞌyu loꞌo ska nu kunaꞌan nu wa ngulaa tiꞌin ꞌin kwilyoꞌo loꞌo kityi, ti kwiꞌ ti chaꞌ kuxi ngiꞌni yu kiꞌyu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Ndiya ska yu kuliyaꞌ, nu xkwiꞌ teꞌ kaꞌan ꞌa ngaꞌan, xkwiꞌ teꞌ suꞌwe ꞌa ñaꞌan nchkuꞌ yu. Lye ꞌa ngiꞌni yu la ndiꞌin yu lo chalyuu, nchga tsan nchka taꞌa naꞌan tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Loꞌo ndiya ska yu tiꞌi nu naan Lázaro, nu nsuꞌwi kitsuꞌ tyukwi ñaꞌaan yu. Tuꞌwa tunaꞌan seꞌen ndiꞌin yu kuliyaꞌ kanꞌ ndukwa Lázaro nchga tsan. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wa nchka tiꞌ yu tiꞌi kanꞌ ku yu ya ñaꞌan ti nan nu ngalu tuꞌwa msaa seꞌen nchku yu kuliyaꞌ kanꞌ bra kanꞌ. Loꞌo ndaꞌan xneꞌ seꞌen ndukwa yu tiꞌi kanꞌ, ndeꞌe iꞌ lo kitsuꞌ nu nsuꞌwi chunꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mdiya tsan ngujwi yu tiꞌi kanꞌ; loꞌo bra kanꞌ yaa loꞌo angajle ꞌin ayman kanꞌ seꞌen ndiꞌin ayman Abraham, nde seꞌen tlyu nu wa yꞌni xuꞌwe Ndiose ꞌin yu. Chunꞌ ndiꞌin la ngujwi yu kuliyaꞌ kanꞌ, mtsiꞌ neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Bra wa ndiya yu kuliyaꞌ kanꞌ seꞌen ndijin yu nu tiꞌí lo jwlyaa, bra kanꞌ mskwen yu ke yu naꞌan yu ꞌin ayman Abraham tijyuꞌ ti, naꞌan yu chaꞌ suꞌwa ti ndukwa ayman Lázaro loꞌo Abraham bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Kanꞌ msiꞌya yu kuliyaꞌ kanꞌ ꞌin Abraham: “Sti ba Abraham, chka tꞌnan tiꞌ ꞌñaǎn. Kuloo tñan ꞌin Lázaro kwa chaꞌ kan loꞌo yu chinꞌ tyiꞌa koꞌoǔn, chaꞌ kuchaꞌ yu chinꞌ tuꞌwaǎn loꞌo yaaꞌ yu chaꞌ tlaꞌ chinꞌ ltseěnꞌ, chunꞌ tikeeꞌ ꞌa nsuꞌwiǐn lo kiiꞌ re.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bra kanꞌ ndukwin ayman Abraham ꞌin yu: “Sñiěnꞌ” ndukwin, “suꞌwe ꞌa ngwa ꞌiin la mdiꞌiin lo chalyuu. Loꞌo Lázaro re ni, siꞌi ngwañaꞌan ngwa ꞌin yu, chaꞌ mdijin ꞌa yu nu tiꞌí xa mdiꞌin yu lo chalyuu. Kanꞌ chaꞌ kaja seꞌen tyiꞌin suꞌwe yu nde re ni; loꞌo nuꞌwin, ndiꞌin chaꞌ kaja nu tiꞌí ꞌiin ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ti nsuꞌwi la xka chaꞌ ꞌware nde seꞌen ndiꞌin ba, ndiya ska lo kwaꞌan nu tlyu ꞌa jluꞌwe la seꞌen ndiꞌin bare loꞌo wan; kanꞌ chaꞌ si ndiya neꞌ taꞌa ba nu nchka tiꞌ tsaa seꞌen ndiꞌin wan, ja ka ꞌin neꞌ tsaa neꞌ. Kwiꞌ ngwañaꞌan ꞌwan, nu ndiꞌin wan nde kwa, ja ka ꞌwan kan wan nde re.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Bra kanꞌ tꞌnan ꞌa ykwiꞌ yu kuliyaꞌ kanꞌ loꞌo: “Kuꞌnii ska chaꞌ suꞌwe loꞌoǔn, sti ba Abraham” ndukwin yu kuliyaꞌ kanꞌ. “Taa ꞌin Lázaro chaꞌ tsaa yu seꞌen ndiꞌin stiǐn, ");
INSERT INTO ctpNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwiꞌ seꞌen ndiꞌin xa kiꞌyu yu taꞌaǎn, chaꞌ chkwiꞌ yu loꞌo yu kwa, chaꞌ ja kan ꞌa yu seꞌen ndijiǐn nu tiꞌí nde re.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bra kanꞌ mxkwen Abraham ꞌin yu: “Wa jlyo tiꞌ neꞌ kanꞌ nchga chaꞌ nu ngwaꞌan ayman Moisés ti sꞌni; loꞌo xka la kityi ꞌin Ndiose seꞌen nu ngwaꞌan ayman nu ngwa sꞌni, ndiya kityi kanꞌ ꞌin yu taꞌaa. ¡Suꞌwe la si kunan suꞌwe neꞌ chaꞌ nu ndukwa lo kityi kanꞌ!” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Bra kanꞌ mxkwen yu kuliyaꞌ kanꞌ ꞌin Abraham: “Chañi ꞌiin, sti ba Abraham. Ja chan si tsaa ska ayman nde seꞌen ndiꞌin neꞌ kwa, bra ti kulaa yaꞌ neꞌ chaꞌ kuxi nu ngiꞌni neꞌ bra kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Xiyaꞌ ykwiꞌ ayman Abraham loꞌo yu kuliyaꞌ kanꞌ bra kanꞌ: “Chaꞌ nu ja xlyaa neꞌ kwa tukwa neꞌ tñan nu ngulo Moisés lo kityi, ti kwiꞌ ti chaꞌ ja nnan neꞌ chaꞌ nu ykwiꞌ ayman nu msuꞌwa Ndiose chaꞌ chkwiꞌ loꞌo nten nu ngwa sꞌni, kwiꞌ ngwañaꞌan, ja tukwa neꞌ xka la chaꞌ nu chkwiꞌ Ndiose loꞌo neꞌ, ni siya xiyaꞌ tyuꞌu ska ayman chaꞌ chkwiꞌ loꞌo neꞌ kwa.” ");
INSERT INTO ctpNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Xiyaꞌ ykwiꞌ Jesús loꞌo nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Nsuꞌwi ꞌa nten nu nchkwiꞌ loꞌoan chaꞌ kuꞌnian ska chaꞌ kuxi; loꞌo nten nu ndatsaa ꞌin taꞌa nten neꞌ chaꞌ kuꞌni chaꞌ kuxi loꞌo neꞌ, ¡tꞌnan ꞌa neꞌ kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Suꞌwe la si skanꞌ ska kee kichi ynen neꞌ kanꞌ, chaꞌ tsaa xkwan neꞌ ꞌin neꞌ lo tyiꞌa tujoꞌo; bra kanꞌ ja ka ꞌa tatsaa la neꞌ ꞌin nten ñaꞌan tiꞌ ska nu xuwe ti re. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Bra nu kuꞌni ska neꞌ taꞌa ndaꞌan wan chaꞌ kuxi loꞌo wan, bra kanꞌ chkwiꞌ wan loꞌo yu chaꞌ ja kuꞌni ꞌa yu chaꞌ kuxi kanꞌ loꞌo wan. Si kulaa yaꞌ yu chaꞌ kuxi kanꞌ, kuꞌni wan chaꞌ tlyu tiꞌ ꞌin yu bra kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ni siya kati yaꞌ ta yu chaꞌ msinꞌ tiꞌ ꞌwan ska tsan, loꞌo kati yaꞌ kan yu chkwiꞌ yu loꞌo wan: “Kuꞌni wan chaꞌ tlyu tiꞌ ꞌñaǎn, ja kuꞌniǐn ꞌaǎn chaꞌ nu kuxi loꞌo wan ni” nchkwin yu bra kanꞌ, ndiꞌin chaꞌ kuꞌni wan chaꞌ tlyu tiꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Bra kanꞌ ykwiꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús: ―Tayaaꞌ ꞌwa chaꞌ ka tsaa ñaꞌan la tiꞌ ba ꞌiin ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","―Jlyo tiꞌ wan chaꞌ ndiya mta kixinꞌ nu xuwe ꞌa ―ndukwin Jesús ꞌin neꞌ―. Sa ñaꞌan lka ska mta xuwe ti, ngwañaꞌan lka wan, chaꞌ ja nchka ꞌwan lye. Ja nꞌni chaꞌ, ni siya chinꞌ ti chaꞌ tsaa ñaꞌan tiꞌ wan ꞌin Ndiose Stiǐn, ka chkwiꞌ wan loꞌo yka kityi re: “Tyoꞌo tsuuꞌ nde seꞌen ndukwaa re, tsaa tukwaa nde lo tyiꞌa tujoꞌo kwa.” Loꞌo bra kanꞌ ñaꞌan wan chaꞌ kiꞌya yka kanꞌ kwenta chaꞌ nu ykwiꞌ wan loꞌo ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’¿Ni sa ñaꞌan nxkeꞌ tiꞌ wan ni a? ¿Ni sa ñaꞌan kuꞌni wan si ndiya ska msu ꞌwan nu wa yaa niꞌ kixinꞌ chaꞌ ndaꞌa yu yuu ꞌwan, ni siya yaa yu chaꞌ ñaꞌansiin yu ꞌin kuta ꞌwan a? Nde msiin nu tka ngala ti msu kanꞌ chaꞌ yaa yu tñan, ¿ta chkwiꞌ wan chaꞌ re loꞌo yu a?: “Kaan lyaa tyukwaa chinꞌ tuꞌwa msaa re chaꞌ kuꞌnii chinꞌ siin ni.” ");
INSERT INTO ctpNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ja nchkwiꞌ wan ngwañaꞌan loꞌo yu, nxkeꞌ tiǎnꞌ. Ja chan nde ñaꞌan chkwiꞌ wan loꞌo yu: “Kuꞌnii lyaa chaꞌ keeꞌ nan ka siin ku ba. Ti kulo ku ba koꞌo ba, bra kanꞌ kuu koꞌoo” nchkwin wan ꞌin msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Ta ndya wan xuꞌwe ꞌin msu kanꞌ, chaꞌ ngiꞌni yu tñan nu ngulo wan ꞌin yu a? Ja ngiꞌni xꞌnan msu ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sa ñaꞌan lka msu, ngwañaꞌan lka wan; bra wa yꞌni wan nchga tñan nu ngulo Ndiose ꞌwan, ndiꞌin chaꞌ chkwiꞌ wan bra kanꞌ: “Msu kuxi ti lka bare, chaꞌ tñan nu ndiꞌin chaꞌ kuꞌni ti ba, sa kanꞌ ti tñan yꞌni ba” nchkwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Msñi Jesús tuwiin ndyaa nde Jerusalén, bra kanꞌ mdijin neꞌ lo yuu ꞌin Galilea, ndyaa neꞌ nde lo yuu ꞌin Samaria. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Mdiya Jesús ska kichen xuwe, bra kanꞌ ndyukwa taꞌa yu loꞌo tii neꞌ tiꞌí nu wa ndijyan seꞌen ndiꞌin yu; kicha nu ngatsuꞌ kunaꞌ msñi ꞌin neꞌ kanꞌ. Ti tijyuꞌ ti nduun neꞌ seꞌen ndiꞌin Jesús, ");
INSERT INTO ctpNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kwen ꞌa ykwiꞌ neꞌ loꞌo yu bra kanꞌ: ―¡Yu kula Jesús! ―ndukwin neꞌ bra kanꞌ―, ¡chka tꞌnan tiiꞌ ꞌwa! ");
INSERT INTO ctpNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Xa wa naꞌan Jesús ꞌin neꞌ, bra kanꞌ ndukwin yu: ―Tyaa lya wan seꞌen ndiꞌin sti joꞌo chaꞌ ñaꞌan yu tyukwi ñaꞌan wan ―ndukwin Jesús ꞌin neꞌ tiꞌí kanꞌ. Mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. Seꞌen yaa neꞌ tuwiin, ndii tiꞌ neꞌ chaꞌ ngwa luwi kunaꞌ neꞌ xiyaꞌ; wa mdyii chaꞌ tiꞌí neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kanꞌ chaꞌ mxitukwi ska yu tiꞌí kanꞌ, kwen ꞌa ykwiꞌ yu chaꞌ yꞌni tnun yu ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Bra kanꞌ mduun xtyinꞌ yu seꞌen ndiꞌin Jesús, yaa sti yu mstya tloo yu lyuu chaꞌ ndya yu xuꞌwe ꞌin Jesús. Loꞌo neꞌ Samaria lka yu kanꞌ, neꞌ xka laꞌa tsuꞌ lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Bra kanꞌ ykwiꞌ Jesús loꞌo yu: ―¿Ta siꞌi tii neꞌ nu ngatsuꞌ kunaꞌ neꞌ nchkaa neꞌ tsan a? ¿La ngwa xa chkaa neꞌ kanꞌ ni a? ");
INSERT INTO ctpNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ska ti yu re nu siꞌi neꞌ Israel taꞌaan lka yu, kanꞌ lka nu mxitukwi chaꞌ kuꞌni tnun yu ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Bra kanꞌ ykwiꞌ Jesús loꞌo yu kiꞌyu kanꞌ: ―Tyituun lyaa, tyaa ni ―ndukwin―. Wa nchkaa ni, chaꞌ ndyaa ñaꞌan tiiꞌ chaꞌ nu ykwiǐnꞌ loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Loꞌo bra kanꞌ mnichaꞌ neꞌ fariseo ꞌin Jesús sa ñaꞌan bra nu kan Ndiose chaꞌ ka Ni ndloo la ꞌin nten. Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Siꞌi ska nan nu chkanꞌ ndijyan tijyuꞌ lka chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja ka chkwianꞌ chaꞌ re: “Nde ti nduun Ni”; ja ka chkwianꞌ: “Nde kwa ndukwa Ni.” Nan wa lka Ndiose ndloo niꞌ kasiya ꞌin nten bra ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu: ―Nde loo la tiya bra nu ka ꞌa tiꞌ wan ñaꞌan wan ꞌñaǎn, ni siya xka tsan ti tyiꞌiǐn loꞌo wan lo chalyuu ka tiꞌ wan, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten; loꞌo ja ka ꞌa ñaꞌan wan ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Chkwiꞌ neꞌ loꞌo wan chaꞌ ꞌñaǎn bra kanꞌ: “Nde ti nduun yu”; loꞌo chkwiꞌ neꞌ: “Nde kwa nduun yu.” Ja tsaa ñaꞌan tiꞌ wan ꞌin neꞌ kanꞌ, ja xñi wan chaꞌ kwiñi nu nchkwiꞌ neꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Suꞌwa ñaꞌan nchka tiꞌ bra nu ndyuwi tyukwi ñaꞌaan niꞌ kwan, ngwañaꞌan ka ꞌñaǎn bra nu tiya tsan chaꞌ ñaꞌan neꞌ ꞌñaǎn ndyaǎn xiyaꞌ, naꞌ nu wa mdiyaǎn chaꞌ lkaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ti kulo ndiꞌin chaꞌ kaꞌan ꞌa nu tiꞌí kaja ꞌñaǎn. Kwiꞌ ngwañaꞌan, neꞌ taꞌa kichen tyiǐn kulaa yaꞌ neꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Sa ñaꞌan ngwa ꞌin nten nu yuꞌwi lo chalyuu sꞌni, taꞌa suꞌwa neꞌ loꞌo ayman Noé kanꞌ, ngwañaꞌan ka ꞌin nten chalyuu bra nu tyaǎn xiyaꞌ, naꞌ nu wa mdiyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Taꞌa suꞌwa ayman Noé kanꞌ ni, yꞌni neꞌ taꞌa, yku neꞌ, yiꞌo neꞌ, mjwi kwilyoꞌo neꞌ; sa kanꞌ ti chaꞌ nka tiye neꞌ sa ñaꞌan bra nu mñan Noé kanꞌ yka naꞌan tnun. Bra kanꞌ yten yu niꞌ yka naꞌan kanꞌ loꞌo nchga nan nu nsuꞌwi ꞌin yu. Loꞌo bra kanꞌ lye ꞌa mduun tyoo, mdyii nten chalyuu ngujwi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ti kwiꞌ sa ñaꞌan ngwa ꞌin neꞌ kichen seꞌen mdiꞌin ayman Lot, ngwañaꞌan ka ꞌin nten chalyuu tsan kanꞌ. Nten taꞌa kichen tyi Lot ni, yku neꞌ, yiꞌo neꞌ, msiꞌi neꞌ yuꞌwa, yjwiꞌ neꞌ yuꞌwa, yta neꞌ jyan, mñan neꞌ naꞌan; sa kanꞌ ti tñan nu ndiya tiꞌ neꞌ yꞌni neꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","sa ñaꞌan bra nu ngulo Ndiose ꞌin Lot kanꞌ nde kichen Sodoma kanꞌ. Bra kanꞌ mslu Ndiose kiiꞌ loꞌo kata sufri nchkin lo yuu. Mdyii chaꞌ ꞌin nchga neꞌ Sodoma kanꞌ; taꞌa suꞌwa Lot ni, ngujwi nchga neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ngwañaꞌan ka tsan kanꞌ bra nu ñaꞌan neꞌ ꞌñaǎn ndyaǎn xiyaꞌ, naꞌ nu wa mdiyaǎn ska yaꞌ chaꞌ kaǎn nten; ja ka biyaꞌ tiꞌ neꞌ ni tsan ka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Bra nu tiya tsan kanꞌ, si ndiya nten nu nduun ke naꞌan tyi neꞌ, ja ka ꞌa ꞌin neꞌ kiꞌya neꞌ lyuu chaꞌ kulo neꞌ yuꞌwa nu ndiꞌin niꞌ ñaꞌan ꞌin neꞌ. Kwiꞌ ngwañaꞌan, si nsuꞌwi neꞌ niꞌ kixinꞌ, ja ka ꞌa ꞌin neꞌ xitukwi neꞌ tyaan neꞌ tuꞌ naꞌan tyi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tyaa yuꞌwi tiꞌ wan sa ñaꞌan nu ngwa ꞌin nu kunaꞌan ꞌin Lot bra kanꞌ; ngwa tiꞌ neꞌ xitukwi neꞌ tyaan nde kichen kanꞌ xiyaꞌ, bra kanꞌ yꞌni Ndiose chaꞌ nchka neꞌ ska kee. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ꞌWan ni, kanaꞌ chalyuu ꞌwan si xkwiꞌ ndaꞌan chaꞌ tiye wan sa ñaꞌan nu ka ꞌwan, ti ykwiꞌ ti wan; kaja chalyuu kwi ꞌwan si xlyaa wan tsaa ñaꞌan tiꞌ wan ꞌñaǎn, ni siya kujwi nten ꞌwan chunꞌ nu yten wan chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Katsaǎnꞌ ꞌwan sa ñaꞌan ka si kaǎn xa tla; si nskwa tukwa nten lajaꞌ ska ti lo kiꞌyan, kan yꞌya Ndiose ꞌin ska neꞌ, kanun skwa xka ti neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Kwiꞌ ngwañaꞌan ka si ndiya tukwa nu kunaꞌan suꞌwa ti ndiyoo neꞌ ska tsan, kan yꞌya Ndiose ꞌin ska neꞌ, kanun xka ti neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Kwiꞌ ngwañaꞌan ka si ndiya tukwa yu kiꞌyu lo tñan ꞌin neꞌ niꞌ kixinꞌ, tyaa loꞌo Ndiose ꞌin ska yu, kanun xka ti yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Bra wa ynan neꞌ chaꞌ kanꞌ, bra kanꞌ mnichaꞌ neꞌ ꞌin Jesús: ―¿La nde yaꞌ ka ngwañaꞌan, yu kula? ―ndukwin neꞌ. Bra kanꞌ mxkwen Jesús ꞌin neꞌ: ―La seꞌen ndiya ska nan tukun, la kanꞌ tyoꞌ tiꞌin laxu; ngwañaꞌan ka bra nu tyoꞌ tiꞌin nten xa wa mdyii chalyuu, kaja ꞌa nu tiꞌí ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ngwaꞌu Jesús ꞌin neꞌ chaꞌ taꞌa ti chkwiꞌ neꞌ loꞌo Ndiose, chaꞌ ja ka ndaja tiꞌ neꞌ siyaꞌ ti bra nu nchkwiꞌ neꞌ loꞌo Ndiose. Nde lka ska chaꞌ tiya nu ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","―Ska kichen ndiya ska wse nu ja ngiꞌni tnun ꞌin Ndiose, ja ska chaꞌ nduwe tiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ti kwiꞌ kichen kanꞌ ndiya ska nu kunaꞌan tiꞌi. Ndyaa naꞌan nu kunaꞌan kanꞌ ꞌin wse kanꞌ bra kanꞌ, chaꞌ ndiya chaꞌ kuxi nu ngiꞌni xka nten loꞌo; ngwa tiꞌ jñi suꞌwe chaꞌ ꞌin loꞌo taꞌa nxuun tloo wse. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tyun yaꞌ yaa nu kunaꞌan kanꞌ seꞌen ndiꞌin wse, loꞌo ja nduwe tiꞌ wse kanꞌ chaꞌ nu nchkwiꞌ nu kunaꞌan kanꞌ loꞌo yu. Chunꞌ ndiꞌin la mdaꞌan chaꞌ tiye wse kanꞌ: “Ni siya ja ndukwaǎn chaꞌ nu nchkwiꞌ Ndiose, kwiꞌ ngwañaꞌan ja nduwe tiǎnꞌ ska chaꞌ nu nchkwiꞌ nten chalyuu, ");
INSERT INTO ctpNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ja nꞌni chaꞌ kanꞌ, kuꞌniǐn biyaǎnꞌ chaꞌ ꞌin nu kunaꞌan tiꞌi re, chaꞌ ñaꞌan ti ndaꞌan nu kunaꞌan re nda chaꞌ msinꞌ tiꞌ ꞌñaǎn. Kanꞌ chaꞌ tayaǎnꞌ chinꞌ ꞌin nu kunaꞌan re” ndukwin wse kanꞌ, “kuꞌniǐn biyaǎnꞌ ꞌin kiꞌya re, chaꞌ ja kan ꞌa nu kunaꞌan re ta chaꞌ msinꞌ tiꞌ ꞌñaǎn xiyaꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ti nchkwiꞌ la Jesús loꞌo neꞌ bra kanꞌ: ―Ngwañaꞌan ykwiꞌ wse xaꞌan kanꞌ, bra kanꞌ mdayaꞌ yu ꞌin nu kunaꞌan kanꞌ, ni siya ja suꞌwe nka tiye yu ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Loꞌo Ndiose ni, suꞌwe ꞌa nsuꞌwi tiye Ndiose, bra ti tayaꞌ Ni ꞌin nten nu wa ngulo suwi Ni chaꞌ ka nten ꞌin Ni, chunꞌ lye ꞌa nchkwiꞌ neꞌ loꞌo Ni tsan loꞌo tla. ¿Ta tiyaꞌ ꞌa tayaꞌ Ndiose ꞌin neꞌ, nxkeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan, chaꞌ bra ti tayaꞌ Ndiose ꞌin neꞌ kanꞌ, kuꞌni Ni chaꞌ tiin ti tyiꞌin kasiya ꞌin neꞌ. Loꞌo naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, bra nu tiyaǎn xiyaꞌ, ¿ta ñaꞌan ti tyija lyo ꞌñaǎn nten nu ti ndyaa ñaꞌan tiꞌ ꞌin Ndiose Stiǐn a? ");
INSERT INTO ctpNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Nde lka xka chaꞌ tiya nu ykwiꞌ Jesús loꞌo nten, ska chaꞌ ꞌin neꞌ nu ngiꞌni siyeꞌ ꞌa tloo xka ta nten; xkwiꞌ chaꞌ nu ñi ngiꞌni neꞌ kanꞌ, nxkeꞌ tiꞌ neꞌ, loꞌo xkwiꞌ nxtyi lyoꞌo ti neꞌ kanꞌ ꞌin xka la nten. Nde lka chaꞌ nu ykwiꞌ Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Tukwa nten ndyaa niꞌ lyaa tnun chaꞌ chkwiꞌ neꞌ loꞌo Ndiose: Ska yu kanꞌ lka yu fariseo nu kti ꞌa chaꞌ ꞌin neꞌ, nxkeꞌ tiꞌ neꞌ, xka yu lka yu ska yu kuxi nu njñan tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Yu fariseo kanꞌ ni, nduun yu jluꞌwe laa, nde ñaꞌan ykwiꞌ yu loꞌo Ndiose bra kanꞌ: “Ndiose” ndukwin, “ngwa xuꞌwe ꞌiin chaꞌ ja ngiꞌniǐn sa ñaꞌan nu ngiꞌni xka la nten; xaꞌan ꞌa ngiꞌni neꞌ, ngiꞌni ꞌa neꞌ kunan, kuxi ꞌa ngiꞌni neꞌ loꞌo kwilyoꞌo xka nten. Naꞌ ni, ja ngiꞌniǐn ngwañaꞌan, ja ngiꞌniǐn sa ñaꞌan ngiꞌni yu kuxi kwa nu kwiñi ti njñan kaꞌan ꞌa tñi chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ nu lka ndloo la” ndukwin yu fariseo kanꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","“Tukwa yaꞌ ska smnan ja nchkuǔn tyaja chaꞌ ngiꞌniǐn tnuǔn ꞌiin. Loꞌo ndaǎn ꞌiin sa yuꞌwe nchga nan nu ngiꞌniǐn kanan ska smnan” ndukwin yu fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Loꞌo yu kiꞌyu nu njñan tñi chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ ni, tijyuꞌ ti mdyituun yu; ja ngwa tiye yu chaꞌ skwen kiloo yu chinꞌ, chaꞌ xiꞌin ꞌa tiꞌ yu mduun yu mjiꞌin ti yu ndukunꞌ tijyan tiye yu bra nu ykwiꞌ yu loꞌo Ndiose: “¡Chka tꞌnan tiiꞌ ꞌñaǎn, Ndiose Stiǐn, chaꞌ ndiꞌin ꞌa kiꞌya ꞌñaǎn!” ndukwin yu kiꞌyu kanꞌ. Sa kanꞌ ti chaꞌ ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Nde lka chaꞌ nu nchka tiǎnꞌ chkwiǐnꞌ loꞌo wan ―ndukwin Jesús ꞌin neꞌ―, chaꞌ yu kiꞌyu nu njñan tñi chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ, wa yꞌni tyii Ndiose kiꞌya nu ndiꞌin ꞌin yu kanꞌ; kanꞌ chaꞌ suꞌwe ngwa tiye yu mxitukwi yu ndyaa yu naꞌan tyi yu. Loꞌo ja ngwa ꞌin yu fariseo kanꞌ ngwañaꞌan, chaꞌ nten nu ngiꞌni tnun ꞌin ti ykwiꞌ ti, ndiꞌin chaꞌ ka jyuꞌu tiꞌ nten kanꞌ chunꞌ ndiꞌin la; loꞌo nten nu mjyuꞌu ꞌa tiꞌ siꞌya chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, chunꞌ ndiꞌin la ka suꞌwe la kasiya ꞌin neꞌ tloo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Bra kanꞌ ndijyan loꞌo nten ꞌin kaꞌan ꞌa nu xuwe chaꞌ xtya yaꞌ Jesús ke nu xuwe kanꞌ. Bra wa naꞌan neꞌ nu ngiꞌni xaꞌan kanꞌ ꞌin nten nu ndijyan loꞌo ꞌin nu xuwe kanꞌ, bra ti mdyisnan neꞌ kanꞌ yꞌni tlá neꞌ ꞌin nten nu ndijyan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bra kanꞌ msiꞌya Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ kan neꞌ seꞌen ndiꞌin yu. Bra kanꞌ ykwiꞌ yu loꞌo neꞌ: ―Ta wan chabiyaꞌ chaꞌ kan nu xuwe re seꞌen ndiꞌiǐn ―ndukwin―, chaꞌ ska nu xuwe ni, suꞌwe ꞌa nsñi chaꞌ suꞌwe ꞌin Ndiose niꞌ kasiya ꞌin, tyukwi ti tiye kanꞌ siyaꞌ ti. Ka kulo Ndiose tñan ꞌin nten nu tsaa ñaꞌan tiꞌ ꞌin Ndiose, sa ñaꞌan nu ndyaa ñaꞌan tiꞌ ska nu xuwe ꞌin sti. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chaꞌ nu ñi nchkwiǐnꞌ re loꞌo wan. Nten nu ja xñi chaꞌ suꞌwe ꞌin Ndiose sa ñaꞌan nu nsñi ska nu xuwe re chaꞌ nu nchkwiꞌ sti, ja ka ka Ndiose ndloo niꞌ kasiya ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nde kwa mduun ska nten tlyu nu lka ndloo ꞌin neꞌ judío. Bra kanꞌ mnichaꞌ yu kanꞌ ꞌin Jesús: ―Mstru, suꞌwe ꞌa ngiꞌnii nchga tsan ―ndukwin―. ¿Ni sa ñaꞌan kuꞌniǐn chaꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌñaǎn a? ―ndukwin yu kiꞌyu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Bra kanꞌ mxkwen Jesús ꞌin yu: ―¿Ni chaꞌ nxkeꞌ tiiꞌ chaꞌ suꞌwe ꞌa nten lkaǎn a? ―ndukwin Jesús ꞌin yu kanꞌ―. Ska ti Ndiose lka nu chañi chaꞌ suꞌwe. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wa jlyo tiiꞌ nchga tñan nu ngulo Ndiose ꞌin nten nu ngwa sꞌni, chaꞌ nde ñaꞌan nchkwiꞌ lo kityi: “Ja kuꞌni wan chaꞌ kuxi loꞌo kwilyoꞌo xka nten” ndukwin kityi kanꞌ. “Ja kujwi wan ꞌin taꞌa nten wan; ja kuꞌni wan kunan; ja chkwiꞌ wan kwentu ꞌin taꞌa nten wan; kuꞌni tlyu wan ꞌin sti wan loꞌo jyaꞌan wan, ngwañaꞌan tukwa wan chaꞌ nu nchkwiꞌ neꞌ kula ꞌwan loꞌo wan.” Ngwañaꞌan nchkwiꞌ chaꞌ kula nu mda Ndiose ꞌñaan nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","―Ti lyuǔnꞌ mdukwaǎn nchga chaꞌ kanꞌ ―ndukwin yu kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Bra wa ynan Jesús chaꞌ kanꞌ, bra kanꞌ ndukwin ꞌin yu: ―Xka ti chaꞌ ti ji kuꞌnii. Yaa kujwiiꞌ nchga chaꞌ suꞌwe nu nsuꞌwi ꞌiin, chaꞌ kaja tñi nu taa ꞌin nten nu tiꞌi; kaꞌan la chaꞌ suꞌwe kaja ꞌiin nde loo la nde seꞌen ndiꞌin Ndiose bra kanꞌ. Bra wa yꞌnii tñan kanꞌ, bra kanꞌ ka tyaꞌaan loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bra nu ynan yu kanꞌ chaꞌ nu ykwiꞌ Jesús, bra ti ngwa xiꞌin tiꞌ yu, chaꞌ kuliyaꞌ ꞌa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Naꞌan Jesús chaꞌ xiꞌin ꞌa tiꞌ yu, bra kanꞌ ykwiꞌ loꞌo neꞌ nu ndiꞌin kwiꞌ seꞌen ti: ―¡Tukwi ꞌa chaꞌ sten neꞌ kuliyaꞌ chaꞌ ꞌin Ndiose, chaꞌ ka Ndiose ndloo la niꞌ kasiya ꞌin neꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sa la tñan chaꞌ tyijin ska ꞌni kiyaꞌ kuxa, ni siya ska ꞌni tnun, ni siya sa ñaꞌan lka ska camello. Sa la chaꞌ kanꞌ; tukwi la tñan chaꞌ sten ska neꞌ kuliyaꞌ chaꞌ ꞌin Ndiose chaꞌ ka Ndiose ndloo la ꞌin yu ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Bra wa ynan neꞌ chaꞌ kanꞌ, mdaꞌan ꞌa chaꞌ tiye neꞌ: ―¿Ti ka nu ka tyoꞌo laa ꞌin chaꞌ kuxi nu nsuꞌwi chalyuu sikwa, chaꞌ kala yu seꞌen ndiꞌin Ndiose a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","―Ja ska nten chalyuu ka kuꞌni tñan kanꞌ; ska ti Ndiose, kanꞌ lka nu nchka kuꞌni chaꞌ kala nten seꞌen ndiꞌin ykwiꞌ Ni ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","―Yu kula ―ndukwin Tyu ꞌin Jesús―, wa ngulaa tiꞌin ba nchga nan nu nsuꞌwi ꞌwa chaꞌ tyaꞌan ba loꞌoo, sa ñaꞌan nu ndukwiin chaꞌ kuꞌni ba ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Bra kanꞌ mxkwen Jesús ꞌin yu: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ꞌin nten nu wa yaa tijyuꞌ chaꞌ kuꞌni tñan ꞌin Ndiose; ja siyaꞌ kulaa yaǎnꞌ ꞌin neꞌ kanꞌ ya ñaꞌan ti. Ndiya bra wa ngulaa tiꞌin neꞌ nchga chaꞌ suꞌwe nu ndiꞌin ꞌin neꞌ, chaꞌ nu ndyaa neꞌ tñan ꞌin Ndiose; loꞌo naꞌan tyi neꞌ, loꞌo kwilyoꞌo neꞌ, loꞌo sti neꞌ, loꞌo jyaꞌan neꞌ, loꞌo sñiꞌ neꞌ, ndiya bra ngulaa tiꞌin neꞌ nchga chaꞌ kanꞌ, chaꞌ nu ndyaa neꞌ tñan ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Loꞌo bra kanꞌ kaꞌan la chaꞌ suꞌwe kaja ꞌin neꞌ kanꞌ lo chalyuu ni, sa ñaꞌan chaꞌ nu mnaꞌ ꞌin neꞌ kanꞌ, mxkeꞌ tiꞌ neꞌ; chunꞌ ndiꞌin la kaja chalyuu nu ja tsaa tii ꞌa siyaꞌ ti ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Bra kanꞌ msiꞌya Jesús ꞌin tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, chaꞌ tyoꞌ tiꞌin neꞌ seꞌen ndiꞌin yu chaꞌ chkwiꞌ yu loꞌo neꞌ: ―Tsaan nde Jerusalén ni ―ndukwin yu―, seꞌen ka nchga tñan nu ndukwin ayman nu ykwiꞌ chaꞌ ꞌin Ndiose nu ngwa sꞌni; ngwaꞌan neꞌ chaꞌ kanꞌ lo kityi, nchga chaꞌ nu ka ꞌñaǎn, naꞌ nu ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wa ta ti neꞌ ꞌñaǎn ꞌin neꞌ xka laꞌa tsuꞌ chaꞌ xtyi lyoꞌo neꞌ ꞌñaǎn, chaꞌ chkwiꞌ neꞌ chaꞌ tiꞌí ꞌñaǎn, loꞌo suꞌwa tyiꞌa ndyoꞌo tuꞌwa neꞌ tloǔn. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ti kulo jwiꞌin neꞌ ꞌñaǎn loꞌo ti su, kujwi neꞌ ꞌñaǎn bra kanꞌ. Mdaꞌa snan tsan, tyuꞌuǔn xiyaꞌ bra kanꞌ; ja kanuǔn seꞌen ndiꞌin ayman. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nchga nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús kanꞌ, ja ngwa biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ; ja jlyo tiꞌ neꞌ ni chaꞌ ykwiꞌ yu ngwañaꞌan. Ska chaꞌ tukwi ngwa, ja ngwiꞌya neꞌ kwenta sa ñaꞌan ndyoꞌo chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wa mdiyan ti Jesús tuꞌwa kichen Jericó bra kanꞌ. La kanꞌ ndiya ska yu kwityiinꞌ tuꞌwa tuwiin, mjñan yu lomstan. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chaꞌ kaꞌan ꞌa nten ynan yu ndijyan tuwiin, kanꞌ chaꞌ mnichaꞌ yu kwityiinꞌ kanꞌ ꞌin xka nten: ―¿Nan ka nchka re ni a? ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Bra kanꞌ ytsaꞌ neꞌ ꞌin yu chaꞌ Jesús Nazaret kanꞌ ndijyan tuwiin kwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bra kanꞌ kwen ꞌa msiꞌya yu kwityiinꞌ kanꞌ ꞌin Jesús: ―Jesús, sñiꞌ David nu ngwa ayman stii nu yuꞌwi ti sꞌni ―ndukwin yu―, ¡chka tꞌnan tiiꞌ ꞌñaǎn ni! ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nten nu ndukwa loo la, kanꞌ msiꞌya loꞌo neꞌ ꞌin yu chaꞌ ka tiin yu chaꞌ nxiꞌya yu; loꞌo ja ynan yu, kwen la msiꞌya yu bra kanꞌ: ―Nuꞌwin, nu lkaa taꞌa nten ꞌin ayman David ―ndukwin yu―, ¡chka tꞌnan tiiꞌ ꞌñaǎn! ");
INSERT INTO ctpNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Bra kanꞌ ndyaa tuun Jesús chaꞌ chkwiꞌ loꞌo neꞌ chaꞌ kan loꞌo neꞌ ꞌin yu kwityiinꞌ kanꞌ seꞌen nduun yu. Bra nu mdiya yu kwityiinꞌ kanꞌ kwiꞌ seꞌen ti, bra kanꞌ mnichaꞌ Jesús ꞌin yu kwityiinꞌ kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Nan lka kuꞌniǐn loꞌoo, nchka tiiꞌ a? ―ndukwin Jesús ꞌin yu. ―Yu kula ―ndukwin yu―, nchka tiǎnꞌ chaꞌ kuꞌnii joꞌó ꞌin kiloǔn ―ndukwin yu kwityiinꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","―¡Chkaa kiloo sikwa! ―ndukwin Jesús ꞌin yu―. Chunꞌ chaꞌ ndyaa ñaꞌan tiiꞌ ꞌñaǎn, kanꞌ chaꞌ nchkaa kiloo ni ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Bra ti nchkaa kiloo yu kwityiinꞌ kanꞌ, ngwa naꞌan yu xiyaꞌ. Loꞌo bra kanꞌ mdoꞌo yu mdaꞌan yu loꞌo Jesús, ngiꞌni tnun yu ꞌin Ndiose. Loꞌo nchga nten nu naꞌan chaꞌ kanꞌ, loꞌo neꞌ kanꞌ yꞌni tnun neꞌ ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Bra kanꞌ mdaꞌan Jesús ndyaa yu jluꞌwe kichen Jericó kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","La kanꞌ ndiꞌin ska yu kuliyaꞌ nu naan Zaqueo, xꞌnan neꞌ nu mjñan kaꞌan tñi ꞌin nten chaꞌ ꞌin neꞌ xka laꞌa tsuꞌ lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Wa nchka tiꞌ yu xuꞌwi lyo yu ꞌin Jesús, loꞌo ja ngwa ñaꞌan yu ꞌin Jesús chaꞌ kaꞌan ꞌa nten ndiꞌin. Loꞌo Zaqueo ni, lyuꞌ ti kuꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Bra kanꞌ msnan yu ndyaa tuun yu nde loo seꞌen ndijyan neꞌ, mchkwen yu lo ska yka kityi tuwiin seꞌen ndiꞌin chaꞌ tyijin Jesús, chaꞌ mnan ti ñaꞌan yu ꞌin Jesús bra kanꞌ, nka tiye yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Xa nu ndijin ti Jesús, bra kanꞌ naꞌan Jesús nde kwan, ykwiꞌ loꞌo Zaqueo kanꞌ: ―Zaqueo ―ndukwin Jesús ꞌin yu―, kiꞌyaa lyaa lyuu, chaꞌ ndiꞌin chaꞌ tsaꞌaǎn naꞌan tyii ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Bra ti ngwiꞌya Zaqueo lyuu, chaꞌ ndiya ꞌa tiꞌ yu chaꞌ nu ykwiꞌ Jesús loꞌo yu; suꞌwe ꞌa nka tiye yu ta yu seꞌen tyiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Bra nu naꞌan nten chaꞌ ndyaa Jesús seꞌen ndiꞌin Zaqueo kanꞌ, nchga neꞌ lye ꞌa nchkwiꞌ neꞌ ni chaꞌ ndyaa Jesús niꞌ ñaꞌan tyi ska neꞌ kuxi, ska nten nu ndiꞌin ꞌa kiꞌya ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bra kanꞌ mdyituun Zaqueo chaꞌ chkwiꞌ loꞌo Jesús: ―Ñaꞌaan ꞌaan, yu kula ―ndukwin yu―. Taǎn sa jluꞌwe chaꞌ suꞌwe nu nsuꞌwi ꞌñaǎn ꞌin neꞌ tiꞌi. Si ti ndiꞌin nan nu yꞌniǐn kunaǎn chaꞌ wa mñi lyoꞌoǔn ꞌin neꞌ, tyaǎn nan kanꞌ ꞌin neꞌ, jakwa sa kwa tyija ꞌin neꞌ ―ndukwin Zaqueo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","―Loꞌo ni, wa ngulaa neꞌ nu ndiꞌin naꞌan re ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ ―ndukwin Jesús bra kanꞌ―, chaꞌ yu re ni, taꞌa nten ꞌin ayman Abraham nu yuꞌwi ti sꞌni lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten chaꞌ tyaꞌan naǎn ꞌin nten nu mnaꞌ kasiya ꞌin neꞌ siꞌya chaꞌ kuxi, chaꞌ ka kulaǎn ꞌin nten kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Laja nu ndiꞌin ti neꞌ nganan neꞌ chaꞌ nu nchkwiꞌ Jesús loꞌo neꞌ, bra kanꞌ ykwiꞌ yu chaꞌ tiya re loꞌo neꞌ. Wa ndla ti tiya neꞌ loꞌo Jesús tuꞌwa kichen Jerusalén, bra kanꞌ mskeꞌ tiꞌ neꞌ chaꞌ lka Jesús nu nka Krixtu, nten nu tnun nchka nu wa suꞌwa ti Ndiose chaꞌ kan lo chalyuu; mskeꞌ tiꞌ neꞌ chaꞌ wa mdiya ti kwiꞌ bra nu ka Ndiose ndloo ꞌin nten chunꞌ tñan nu ngiꞌni Krixtu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ: ―Ndiya ska yu kiꞌyu, ska nten suꞌwe. Wa tsaa ti yu tijyuꞌ nde xka kichen tnun la, chaꞌ ta neꞌ tñan ꞌin yu chaꞌ ka yu ndloo la ꞌin neꞌ taꞌa kichen tyi yu; bra nu wa mjwi tñan kanꞌ ꞌin yu, bra ti xitukwi yu tyaan yu xiyaꞌ, nka tiye yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Xa nu ti ji ti tsaa yu, bra kanꞌ msiꞌya yu ꞌin tii nten nu lka msu ꞌin yu, chaꞌ ta yu ska tñi ꞌin skaa neꞌ, ska tñi oro nu kaꞌan ꞌa ndyuꞌwi lyo. Bra kanꞌ ykwiꞌ yu loꞌo msu kanꞌ: “Kuꞌni wan tñan loꞌo tñi re tyukwi laja nu tsaꞌaǎn ni, sa ñaꞌan bra nu kalaǎn xiyaꞌ” ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Loꞌo nten taꞌa kichen tyi yu, ja suꞌwe nka tiye neꞌ ñaꞌan neꞌ ꞌin yu. Bra kanꞌ ngulo neꞌ kanꞌ tñan ꞌin xka ta nten chaꞌ tsaa ñaꞌan neꞌ ꞌin yu, chaꞌ chkwiꞌ neꞌ chaꞌ re loꞌo ree nu lka ndloo la ti kichen tijyuꞌ kanꞌ: “Ja nchka tiꞌ ba ꞌin yu kwa chaꞌ ka yu ndloo la ꞌwa kichen tyi ba” ndukwin neꞌ. Loꞌo ja nduwe tiꞌ ree nu lka ndloo la ti kanꞌ siyaꞌ ti, chaꞌ nu wa ykwiꞌ neꞌ ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kanꞌ chaꞌ bra nu ngala yu chaꞌ wa mjwi tñan chaꞌ lka yu ndloo la, ngala yu naꞌan tyi yu xiyaꞌ bra kanꞌ. Bra ti ngulo yu tñan chaꞌ kan neꞌ msu nu mda yu tñi ꞌin chaꞌ kuꞌni neꞌ tñan loꞌo ran, chaꞌ ka biyaꞌ tiꞌ yu sa ñaꞌan kanan yꞌni neꞌ loꞌo tñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ykwiꞌ msu nu ngala kulo kanꞌ loꞌo xꞌnan yu: “Tii sa ñaꞌan nu mda ꞌñaǎn yꞌniǐn kanan” ndukwin msu kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bra kanꞌ mxkwen ree ꞌin msu kanꞌ: “Suꞌwe ꞌa sikwa. Ska msu suꞌwe ꞌa lkaa. Ngwañaꞌan yꞌnii loꞌo ska tñan xuwe ti; kanꞌ chaꞌ taǎn chabiyaꞌ chaꞌ kaa ndloo la ꞌin tii kichen chabiyaꞌ ꞌñaǎn.” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ngala xka msu seꞌen ndiꞌin yu bra kanꞌ: “Yu kula” ndukwin yu, “kiꞌyu sa ñaꞌan nu mda ꞌñaǎn yꞌniǐn kanan” ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ti kwiꞌ ti chaꞌ ndukwin ree kanꞌ ꞌin: “Nuꞌwin kuloo tñan ꞌin kiꞌyu kichen chabiyaꞌ ꞌñaǎn sikwa” ndukwin ree kanꞌ ꞌin msu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Bra kanꞌ ngala xka msu kanꞌ: “Yu kula” ndukwin, “nde ndyaǎn loꞌoǔn tñi ꞌiin, chaꞌ suꞌwe msuꞌwa koꞌoǔn tñi kanꞌ ska niꞌ pañitu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ntseěn chinꞌ kuꞌniǐn tñan ꞌiin, chaꞌ ska kiꞌyu tiji lkaa. Nskwaꞌ nu nskwaꞌ xka ta nten, kanꞌ lka nu ndyiji ꞌiin; bra nu ngiꞌni wan kwa, xka ta nten lka nu ngiꞌni tñan kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bra kanꞌ ndukwin ree kanꞌ ꞌin yu: “Ndaja ꞌa nuꞌwin. Siꞌya chaꞌ ngwañaꞌan ndukwiin, kanꞌ chaꞌ xtyaǎn kiꞌya ꞌiin bra” ndukwin ree bra kanꞌ. “Jlyo tiiꞌ chaꞌ lkaǎn ska nten tiji, chaꞌ nskwaꞌ nu nskwaꞌ xka ta nten, kanꞌ lka nu kaja ꞌñaǎn; ngwañaꞌan ngiꞌniǐn kwa, loꞌo xka ta nten ngiꞌni tñan kanꞌ” ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","“¿Ni chaꞌ lka ja mdaa tñi ꞌñaǎn jñan xka la nten sikwa a? Chaꞌ nu bra nu ngalaǎn xiyaꞌ, wa ndyija tñi ꞌñaǎn bra kanꞌ. Loꞌo chinꞌ sñiꞌ tñi tyija ꞌñaǎn bra kanꞌ.” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Bra kanꞌ ykwiꞌ ree loꞌo neꞌ nu ndiꞌin kanꞌ: “Xñi wan tñi ꞌin yu re chaꞌ ta wan ꞌin msu suꞌwe nu wa nsuꞌwi tii tñi oro ꞌin.” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Yu kula” ndukwin neꞌ kanꞌ ꞌin ree kanꞌ bra kanꞌ, “nan wa nsuꞌwi tii tñi oro ꞌin yu kwa. ¿Ni chaꞌ ti kaja la xka tñi ꞌin yu a?” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mxkwen ree kanꞌ ꞌin neꞌ bra kanꞌ: “Ngwañaꞌan lka nten nu nsuꞌwi ska chaꞌ ꞌin, ti taǎn kaꞌan la chaꞌ ꞌin nten kanꞌ; loꞌo nten nu chinꞌ ti chaꞌ nsuꞌwi ꞌin, si ja nchka tiꞌ neꞌ kuꞌni neꞌ tñan loꞌo ran, kulaǎn ti chinꞌ ti chaꞌ nu nsuꞌwi ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Loꞌo ni, nten kanꞌ nu ja ngwa tiꞌ chaꞌ kaǎn ree ndloo ꞌin neꞌ, kwiꞌ nu msuun loꞌoǔn, tyaan loꞌo lya wan ꞌin neꞌ kanꞌ nde re, chaꞌ kujwi wan ꞌin neꞌ nde seꞌen ndiꞌiǐn.” ");
INSERT INTO ctpNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Bra wa ykwiꞌ Jesús chaꞌ kanꞌ, bra kanꞌ mdoꞌo yu ndyaa yu tuwiin ndyaa nde Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wa kala ti neꞌ tuꞌwa kichen Betfagé, ska laꞌa kichen kanꞌ nde siꞌ kiꞌya Olivos lka, bra kanꞌ ngulo Jesús tñan ꞌin tukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","―Yaa wan nde kichen xuwe kwa nu kwiꞌ seꞌen ti nchka. Bra nu tiya wan nde kwa, bra kanꞌ tyija ska buru kuneꞌ nu nduun nchkanꞌ ꞌwan, nu ja ya tyukwa nten chunꞌ siyaꞌ ti. Xtiꞌ wan ꞌin iꞌ chaꞌ tyaan loꞌo wan ꞌin iꞌ nde re. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si ndiya nu chkwiꞌ loꞌo wan: “¿Ni chaꞌ nxtiꞌ wan buru kwa a?”, bra kanꞌ xkwen wan ꞌin neꞌ kanꞌ: “Jesús nu lka Xꞌnan wan nchka tiꞌ ꞌin iꞌ”. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ndyaa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. Ti kwiꞌ sa ñaꞌan chaꞌ nu ndukwin Jesús, ngwañaꞌan ngwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Bra nu nduun neꞌ nxtiꞌ neꞌ buru kanꞌ, bra kanꞌ mnichaꞌ nu lka xꞌnan buru kanꞌ ꞌin neꞌ: ―¿Ni chaꞌ nxtiꞌ wan buru kwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Bra kanꞌ mxkwen neꞌ ꞌin nten kanꞌ: ―Ndiya tñan kunanjoꞌo iꞌ ꞌin Xꞌnaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ngala loꞌo neꞌ buru kanꞌ seꞌen nduun Jesús bra kanꞌ. Mstya neꞌ steꞌ neꞌ chunꞌ iꞌ, loꞌo bra kanꞌ mskwen neꞌ ꞌin Jesús chunꞌ iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Sa ñaꞌan nu ndyaa Jesús tuwiin, ngwañaꞌan mstya neꞌ teꞌ lo yuu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wa kiꞌya tiꞌin ti neꞌ siꞌ kiꞌya Olivos, bra kanꞌ bra ti mdyisnan neꞌ yꞌni tnun neꞌ ꞌin Ndiose, chaꞌ kaꞌan ꞌa chaꞌ tnun wa naꞌan neꞌ; kwen msiꞌya neꞌ chaꞌ suꞌwe ꞌa nka tiyeꞌ neꞌ bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","―¡Suꞌwe ꞌa ngiꞌni Ndiose chaꞌ ꞌin yu nu ndijyan re chabiyaꞌ ꞌin Ndiose nu nka Xꞌnaan, chaꞌ ka yu ndloo la ꞌñaan! ―ndukwin neꞌ―. ¡Tiin ti tyiꞌin nchga nan nu nsuꞌwi nde niꞌ kwan seꞌen ndiꞌin Ndiose! ¡Loꞌo ni, kuꞌni tnuan ꞌin Ni! ");
INSERT INTO ctpNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mdiya ska tukwa ti neꞌ fariseo laja nten kanꞌ nu ndukwin ꞌin Jesús bra kanꞌ: ―Mstru ―ndukwin neꞌ kanꞌ―, chkwiiꞌ loꞌo nten nu ndaꞌan loꞌoo, chaꞌ ja chkwiꞌ neꞌ ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Si ja chkwiꞌ ꞌa neꞌ re ni, xiꞌya nchga kee bra kanꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Bra nu wa ndijyan Jesús kwiꞌ seꞌen ti tuꞌwa kichen Jerusalén, ynan ꞌa yu chaꞌ naꞌan yu kichen kanꞌ. Bra kanꞌ ykwiꞌ yu loꞌo neꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","―Tsan ni ti, nu ti ndiꞌin wan chinꞌ lo chalyuu, si xlyaa wan kunan wan ska chaꞌ nu chkwiǐnꞌ loꞌo wan, suꞌwe ꞌa ka ꞌwan bra kanꞌ, suꞌwe ti tyiꞌin wan bra kanꞌ ―ndukwin Jesús―. Loꞌo ꞌwan, ja nchka ꞌa ka biyaꞌ tiꞌ wan chaꞌ re, chaꞌ wa nsuꞌwi kutsiꞌ ti chaꞌ re ꞌwan ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Chunꞌ ndiꞌin la tiya ska tsan nu kuxi ꞌa ꞌwan. Loꞌo bra kanꞌ xoꞌ tukwa nu nxuun loꞌo wan mondun yuu ñaꞌaan tuꞌwa kichen tyi wan. Bra kanꞌ suꞌwa loꞌoo neꞌ kanꞌ tuwiin tuꞌwa kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kuꞌni tyii neꞌ ꞌin kichen tyi wan, sa la lyuu siyaꞌ ti, kujwi neꞌ ꞌin taꞌa ndiꞌin wan; ja ska ꞌa kee kanun skwa ran chunꞌ taꞌa ran nde kichen tyi wan, chunꞌ nu ja xlyaa wan xuꞌwi lyo wan ꞌñaǎn bra nu ni, chaꞌ ndijyaǎn nu lkaǎn Sñiꞌ Ndiose nde seꞌen ndiꞌin wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Bra kanꞌ ndyaa Jesús lo kichen, yten yu niꞌ lyoꞌoo laa tnun. Bra kanꞌ mdyisnan yu ngulo yu ꞌin neꞌ nu ndujwiꞌ yuꞌwa loꞌo neꞌ nu msiꞌi yuꞌwa la kwa, ngulo yu ꞌin neꞌ chunꞌ laa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Wa ndukwa ska chaꞌ lo kityi ꞌin Ndiose chaꞌ ꞌin laa re ―ndukwin Jesús―: “Ska naꞌan seꞌen nu ka chkwiꞌ nchga nten loꞌoǔn, kanꞌ lka naꞌan ꞌñaǎn” ndukwin Ndiose. Ngwañaꞌan ndukwa chaꞌ lo kityi. Loꞌo ni, wa yꞌni wan chaꞌ naꞌan tyi neꞌ kunan lka naꞌan re ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nchga tsan mdaꞌan Jesús ngwaꞌu ꞌin neꞌ niꞌ lyaa kanꞌ. Loꞌo sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo, loꞌo neꞌ kula kichen, mdaꞌan naan neꞌ sa ñaꞌan ka xtya neꞌ kiꞌya ꞌin Jesús, chaꞌ ka kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ja ngwa kuꞌni neꞌ chaꞌ kuxi kanꞌ, chaꞌ wa kaꞌan ꞌa nten ndaꞌan loꞌo yu, chaꞌ ndiya ꞌa tiꞌ neꞌ nganan neꞌ chaꞌ nu nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ngwa ska tsan mdiyan Jesús niꞌ lyaa nduꞌu yu ꞌin nten; nchkwiꞌ yu chaꞌ ꞌin Ndiose, sa ñaꞌan nu kulaa Ni ꞌin nten. Bra kanꞌ mdiyan nchga sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo, loꞌo neꞌ kula kichen kanꞌ, mdiyan neꞌ seꞌen ndiꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Mnichaꞌ neꞌ kanꞌ ꞌin Jesús bra kanꞌ: ―Katsaaꞌ lyaa ꞌwa: ¿Ti ka nu mda chabiyaꞌ ꞌiin chaꞌ kuꞌnii tñan nu ngiꞌnii a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―Loꞌoǔn kunichaǎnꞌ ska chaꞌ ꞌwan, chaꞌ xkwen wan ꞌñaǎn: ");
INSERT INTO ctpNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ti ka nu mda chabiyaꞌ ꞌin ayman Xuwa chaꞌ mdukwatya yu ꞌin nten sikwa a? ¿Ta Ndiose a? ¿O ta nten chalyuu mda chabiyaꞌ ꞌin yu a? ");
INSERT INTO ctpNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Bra kanꞌ mdyisnan neꞌ ykwiꞌ luwe neꞌ loꞌo taꞌa neꞌ: ―¿Ni sa ñaꞌan chkwianꞌ ni a? ―ndukwin neꞌ ꞌin taꞌa neꞌ―. Si chkwianꞌ chaꞌ Ndiose mda chabiyaꞌ ꞌin Xuwa kanꞌ, bra kanꞌ xkwen yu kwa ꞌñaan chaꞌ: “¿Ni chaꞌ ja mdukwa wan chaꞌ nu ngwaꞌu yu sikwa a?” ");
INSERT INTO ctpNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Si chkwianꞌ chaꞌ nten chalyuu mda chabiyaꞌ ꞌin Xuwa kanꞌ, bra kanꞌ kujwi nchga nten nu ndiꞌin re ꞌñaan loꞌo kee, chaꞌ ska yu nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ngwa ayman Xuwa kanꞌ, nchkwiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Bra kanꞌ mxkwen neꞌ nu tnun nchka kanꞌ chaꞌ ja jlyo tiꞌ neꞌ ti ka nu lka mda chabiyaꞌ ꞌin ayman Xuwa kanꞌ, chaꞌ mdukwatya yu ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Ti kwiꞌ ti chaꞌ, ja katsaǎnꞌ ꞌwan ti ka nu lka mda chabiyaꞌ chaꞌ kuꞌniǐn tñan re ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Bra ti mdyisnan Jesús ykwiꞌ ska chaꞌ tiya loꞌo neꞌ nu nduun seꞌen ndiꞌin kanꞌ: ―Ndiya ska yu kiꞌyu nu yta tyun yka chi kutun ska niꞌ lyoꞌo ꞌin yu. Bra kanꞌ mda yu yuu seꞌen ngiꞌni yu tñan mjñan xka ta nten. Bra kanꞌ mdoꞌo yu ndyaa yu tijyuꞌ; xꞌni ꞌa ndyaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bra nu wa mdiya bra wa xtun neꞌ mta chi kutun kanꞌ, bra kanꞌ ngulo xꞌnan tñan kanꞌ tñan ꞌin ska msu ꞌin yu, chaꞌ tsaa chkwiꞌ loꞌo neꞌ nu ngiꞌni tñan niꞌ lyoꞌoo ꞌin yu, chaꞌ ta neꞌ sa tkanꞌ mta chi kutun nu ndiꞌin chaꞌ kaja ꞌin xꞌnan tñan kanꞌ. Loꞌo neꞌ kanꞌ ni, mjiꞌin neꞌ ꞌin msu kanꞌ, ngulo neꞌ ꞌin yu; mxitukwi yu ndyaan yu seꞌen ndiꞌin xꞌnan yu, loꞌo ja ska nan mda neꞌ ꞌin yu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bra kanꞌ msuꞌwa xꞌnan tñan kanꞌ xka msu ndyaa. Kwiꞌ ngwañaꞌan yꞌni neꞌ loꞌo xka msu kanꞌ; chen ñaꞌan ykwiꞌ neꞌ loꞌo yu, bra kanꞌ mjiꞌin neꞌ ꞌin yu, loꞌo ja ska nan mda neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Xiyaꞌ msuꞌwa xꞌnan tñan kanꞌ ꞌin xka msu ndyaa, chaꞌ jñan yu nan nu mdoꞌo lo tñan kanꞌ. Loꞌo yu kanꞌ, lye ꞌa ngwa tiꞌí tiꞌ neꞌ nu ngiꞌni tñan kanꞌ ꞌin yu, sa ñaꞌan yaꞌ nu ngulo neꞌ ꞌin yu nde chunꞌ loꞌoo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Loꞌo bra kanꞌ mdaꞌan chaꞌ tiye xꞌnan tñan kanꞌ: “¿Ni sa ñaꞌan kuꞌniǐn ni a? Nde ñaꞌan kuꞌniǐn: Suꞌwaǎn ꞌin sñiꞌ ykwiǐnꞌ nu ndiya ꞌa tiǎnꞌ, chaꞌ tsaa la kanꞌ. Ja chan xlyaa neꞌ tukwa neꞌ chaꞌ nu chkwiꞌ yu kanꞌ” ndukwin xꞌnan tñan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bra nu naꞌan nu ngiꞌni tñan niꞌ lyoꞌoo kanꞌ ꞌin yu kuneꞌ chaꞌ ndijyan yu, bra kanꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ: “Yu kwa lka nu nchka tiꞌ chaꞌ kwiꞌya loo tñan re. ¿Ni sa ñaꞌan kuꞌnian chaꞌ kujwian ꞌin yu chaꞌ kanun tñan re ꞌñaan?” ndukwin neꞌ kuxi kanꞌ ꞌin taꞌa neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Bra ti ngulo neꞌ ꞌin sñiꞌ xꞌnan tñan nde chunꞌ loꞌoo. Bra kanꞌ yjwi neꞌ ꞌin yu. Bra kanꞌ mnichaꞌ Jesús ꞌin neꞌ nu ynan chaꞌ kanꞌ: ―¿Ni sa ñaꞌan kuꞌni xꞌnan tñan kanꞌ loꞌo neꞌ kuxi kanꞌ, xkeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Kan ykwiꞌ xꞌnan tñan chaꞌ kujwi ꞌin neꞌ kuxi kanꞌ, bra kanꞌ ta tñan kanꞌ ꞌin xka ta nten chaꞌ kuꞌni neꞌ tñan loꞌo ran. Bra wa ynan neꞌ chaꞌ kanꞌ, bra kanꞌ ndukwin neꞌ: ―¡Ja kuꞌni Ndiose ngwañaꞌan! ");
INSERT INTO ctpNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Naꞌan ꞌa Jesús ꞌin neꞌ, bra kanꞌ ykwiꞌ yu loꞌo neꞌ xiyaꞌ: ―¿Ni chaꞌ nchkwiꞌ kityi kula ꞌin Ndiose chaꞌ re sikwa?: Ti kwiꞌ kee tnun nu mxkwan neꞌ nu nñan naꞌan chaꞌ ja suꞌwe ran, mskeꞌ tiꞌ neꞌ, wa mjwi tñan nu kuꞌni kee kanꞌ ni; nduun ran seꞌen nka ndloo la chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Naꞌ lkaǎn sa ñaꞌan lka kee tnun kanꞌ ―ndukwin Jesús―, chaꞌ sa ñaꞌan nu yꞌni neꞌ nu nñan naꞌan loꞌo kee kanꞌ, ngwañaꞌan ngiꞌni wan loꞌoǔn. Nten nu nchka tiꞌ tukunꞌ lo chaꞌ nu nchkwiǐnꞌ loꞌo nten chalyuu, ja suꞌwe tyiꞌin nten kanꞌ bra kanꞌ; bra nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten chalyuu, tyii chaꞌ siyaꞌ ti ꞌin neꞌ kanꞌ, chaꞌ ja xlyaa neꞌ xñi neꞌ chaꞌ ꞌñaǎn xa nu ti ndiꞌin neꞌ lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Loꞌo bra kanꞌ nchga sti joꞌo nu lka ndloo loꞌo neꞌ mstru nu nduꞌu chaꞌ joꞌo, ngwa tiꞌ neꞌ chaꞌ xñi neꞌ ꞌin Jesús chaꞌ tyaa loꞌo neꞌ ꞌin presu ti kwiꞌ bra kanꞌ; wa ngwa biyaꞌ tiꞌ neꞌ kanꞌ, chaꞌ nchkwiꞌ Jesús chaꞌ ꞌin ykwiꞌ neꞌ bra nu ykwiꞌ yu chaꞌ tiya kanꞌ. Loꞌo ntsen neꞌ chinꞌ ꞌin neꞌ kichen kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","kanꞌ chaꞌ mstya neꞌ ꞌin nten chaꞌ tyuun kwan ꞌin Jesús, chaꞌ kiꞌya neꞌ kwenta ni chaꞌ chkwiꞌ yu; mnan ti yꞌni neꞌ ngwañaꞌan, chaꞌ tyaꞌan chaꞌ tiye Jesús chaꞌ nten suꞌwe lka neꞌ. Nchka ꞌa tiꞌ neꞌ chaꞌ kunan neꞌ ska chaꞌ nu tyoꞌo tuꞌwa Jesús, chaꞌ bra kanꞌ ka xtya neꞌ kiꞌya ꞌin yu siꞌya chaꞌ kanꞌ. Bra kanꞌ tyaa loꞌo neꞌ ꞌin yu yaꞌ gobierno, chaꞌ kuꞌni biyaꞌ neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kanꞌ chaꞌ mnichaꞌ neꞌ kwiñi kanꞌ ꞌin Jesús bra kanꞌ: ―Mstru ―ndukwin neꞌ kwiñi kanꞌ―, jlyo tiꞌ ba chaꞌ xkwiꞌ chaꞌ nu ñi nchkwiiꞌ. Suꞌwe ꞌa ndyoꞌo nchga chaꞌ nu nduꞌuu. Siꞌi nan ndiya la tiiꞌ ꞌin ska ti nten; ni siya kuliyaꞌ neꞌ, ni siya nchka ꞌa ꞌin neꞌ, suꞌwa ti ngiꞌnii loꞌo nchga nten. Chañi chaꞌ nduꞌuu chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa, katsaaꞌ ñi ꞌwa: ¿Ta nsuꞌwi chabiyaꞌ ꞌñaan chaꞌ taan tñi nu njñan ree tlyu nu ndiꞌin xka laꞌa tsuꞌ a? ¿O ta suꞌwe la si ja taan tñi kanꞌ ꞌin ree kanꞌ a? ―ndukwin nten kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mgii ꞌa tiꞌ Jesús sa ñaꞌan chaꞌ kwiñi nu nka tiye neꞌ chaꞌ nu mnichaꞌ neꞌ ꞌin yu ngwañaꞌan. Bra kanꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ: ―¿Ni chaꞌ lka nchkwiꞌ biyaꞌ wan ngwañaꞌan loꞌoǔn a? ―ndukwin yu ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kwaꞌu wan ska tñi plata ꞌñaǎn. Bra kanꞌ ngwaꞌu neꞌ tñi plata kanꞌ ꞌin yu. ―¿Ti nkwin lka nu ngaꞌan loo tñi re a? ¿Ti lka nin nu ndukwa lo tñi re a? ―ndukwin Jesús ꞌin neꞌ kwiñi kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mxkwen neꞌ ꞌin yu bra kanꞌ: ―Nin ree tlyu nu ndiꞌin xka laꞌa tsuꞌ, kanꞌ ndukwa lo tñi kwa ―ndukwin neꞌ bra kanꞌ. ―Suꞌwe ―ndukwin Jesús bra kanꞌ―, ta wan nchga nan nu ndiꞌin chaꞌ ta wan ꞌin ree tlyu kanꞌ sikwa; kwiꞌ ngwañaꞌan, ta wan ꞌin Ndiose nchga nan nu ndiꞌin chaꞌ ta wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ja mjwi sa ñaꞌan nu xtya neꞌ kiꞌya ꞌin Jesús nde seꞌen ndiꞌin neꞌ kichen kanꞌ. Yuwe ꞌa tiꞌ neꞌ chunꞌ chaꞌ nu wa mxkwen yu ꞌin neꞌ kwiñi kanꞌ, kanꞌ chaꞌ ja ska ꞌa chaꞌ nchkwiꞌ neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Chunꞌ ndiꞌin la mdiyan xka ta neꞌ judío, mdiyan naꞌan neꞌ ꞌin Jesús. Neꞌ saduceo lka neꞌ kanꞌ, ndukwin neꞌ chaꞌ ja tyuꞌu ꞌa ayman xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Bra kanꞌ ykwiꞌ neꞌ loꞌo Jesús: ―Mstru ―ndukwin neꞌ―, nu ngwa sꞌni ngwaꞌan ayman Moisés ska chaꞌ lo kityi nu nganun ꞌñaan. Nde ñaꞌan nchkwiꞌ chaꞌ kanꞌ. Bra nu wa ngujwi ska yu kiꞌyu loꞌo nganun ska ti kwilyoꞌo yu, loꞌo ja ska sñiꞌ neꞌ ndiꞌin, bra kanꞌ ndiꞌin chaꞌ ꞌin taꞌa ngula yu nu ndiꞌin ska ti chaꞌ kaja kwilyoꞌo yu loꞌo nu kunaꞌan tiꞌi kanꞌ. Bra nu tyiꞌin sñiꞌ neꞌ, sñiꞌ taꞌa mla yu nu wa ngujwi, kanꞌ lka sñiꞌ nu tyiꞌin kulo, nchkwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nde lka ska chaꞌ nu ngwa. Mdiꞌin kati yu kiꞌyu taꞌa ngula yu. Mjwi kwilyoꞌo yu nu kula la, bra kanꞌ ngujwi yu loꞌo ja ya tyiꞌin sñiꞌ yu loꞌo nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Taꞌa ngula yu nu nchka tukwa mjwi kwilyoꞌo loꞌo nu kunaꞌan kanꞌ bra kanꞌ; ti kwiꞌ ti chaꞌ, ngujwi yu loꞌo ja ya tyiꞌin sñiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Loꞌo taꞌa ngula yu nu nchka snan, kanꞌ mjwi kwilyoꞌo loꞌo nu kunaꞌan kanꞌ; loꞌo nchga taꞌa mla yu kanꞌ, mjwi kwilyoꞌo loꞌo nu kunaꞌan kanꞌ. Ngujwi taꞌa kati yu kiꞌyu kanꞌ, ja ska sñiꞌ neꞌ nsuꞌwi loꞌo nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Mdyii chaꞌ bra kanꞌ, loꞌo nu kunaꞌan kanꞌ ngujwi bra kanꞌ ―ndukwin neꞌ ꞌin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Loꞌo ni, bra nu tyuꞌu nchga ayman kanꞌ xiyaꞌ, ¿ti ka nu chañi la chaꞌ ngwa kwilyoꞌo nu kunaꞌan kanꞌ a? Xa mdiꞌin nu kunaꞌan kanꞌ lo chalyuu, mjwi kwilyoꞌo loꞌo ska yu, loꞌo bra kanꞌ mjwi kwilyoꞌo loꞌo xka yu, sa ñaꞌan yaꞌ wa mjwi kwilyoꞌo loꞌo taꞌa kati neꞌ kanꞌ. ¿Ti ka nu chañi la chaꞌ ngwa kwilyoꞌo nu kunaꞌan kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Bra kanꞌ mxkwen Jesús ꞌin neꞌ kanꞌ: ―Lo chalyuu re, xkwiꞌ nan kaja kwilyoꞌo yu kiꞌyu loꞌo neꞌ kunaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bra kanꞌ nten nu kaja xka chalyuu kwi nu ja tsaa tii ꞌa ꞌin neꞌ seꞌen ndiꞌin Ndiose, bra nu tyuꞌu neꞌ kanꞌ xiyaꞌ, ja kaja ꞌa kwilyoꞌo neꞌ; ti kwiꞌ ti chaꞌ, ja ta ꞌa neꞌ ꞌin sñiꞌ neꞌ chaꞌ ka kwilyoꞌo, ");
INSERT INTO ctpNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","chaꞌ la kanꞌ ja ndiꞌin ꞌa chaꞌ kaja neꞌ siyaꞌ ti. Ka neꞌ kanꞌ sa ñaꞌan lka angajle, skan ꞌin Ndiose nu ndiꞌin seꞌen ndiꞌin Ni; ka neꞌ sñiꞌ Ndiose siyaꞌ ti, chaꞌ wa ndyuꞌu neꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ayman Moisés ytsaꞌ ꞌñaan chaꞌ chañi chaꞌ tyuꞌu nchga ayman xiyaꞌ. Lo kityi kanꞌ ngwaꞌan Moisés sa ñaꞌan ngwa la nu naꞌan yu yka xuwe ti, seꞌen nu mdyituun kiiꞌ tyukwi ñaꞌaan lo yka kanꞌ, loꞌo ja nchkin ran. Bra kanꞌ ynen ykwiꞌ Ndiose laja kiiꞌ kanꞌ, ndukwin Ni chaꞌ Xꞌnan ayman Abraham lka Ni, Xꞌnan ayman Isaac lka Ni, Xꞌnan ayman Jacob lka Ni. Ngwañaꞌan ndukwin Ndiose laja kiiꞌ kanꞌ, chaꞌ nten taꞌaan nu mdiꞌin lo chalyuu nu ngwa sꞌni ngwa ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ja ndukwin kityi kanꞌ, chaꞌ ngwa Ndiose Xꞌnan neꞌ kanꞌ; ndukwin chaꞌ ñaꞌan ti lka Ndiose Xꞌnan neꞌ kanꞌ bra nu ni; ngwañaꞌan ndyoꞌo chaꞌ kanꞌ. Kanꞌ chaꞌ loꞌo ꞌin nten luꞌu lka Ndiose ndloo la ꞌin, loꞌo nchka ꞌa tiꞌ Ni chaꞌ nchga nten chalyuu tyiꞌin chaꞌ ꞌin Ni ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bra kanꞌ ykwiꞌ ska tukwa ti mstru nu nduꞌu chaꞌ joꞌo kanꞌ loꞌo Jesús: ―Yu kula, suꞌwe ꞌa nchkwiiꞌ ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ytsen neꞌ bra kanꞌ. Ja yꞌni ꞌa tiye neꞌ chaꞌ chkwiꞌ neꞌ xka la chaꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Bra kanꞌ mnichaꞌ Jesús ꞌin neꞌ kanꞌ: ―¿Ni chaꞌ lka nchkwiꞌ nten chaꞌ ayman ree David nu yuꞌwi chalyuu sꞌni ka sti Krixtu? ");
INSERT INTO ctpNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ti kwiꞌ David mdaꞌan chaꞌ re lo kityi Salmos: Ndiose nu lka Xꞌnaan ndukwin ꞌin Krixtu nu lka Xꞌnaǎn: “Nuꞌwin tyukwaa nde laꞌa seꞌen kwin ꞌñaǎn, chaꞌ suꞌwa ti ka ndloo loꞌoǔn” ndukwin Ndiose, ");
INSERT INTO ctpNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","“sa ñaꞌan yaꞌ nu kuꞌni tyiǐn chaꞌ ꞌin nchga nten nu tiꞌí tiꞌ ꞌiin” ndukwin Ndiose ꞌin Krixtu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Xꞌnaǎn, lka chaꞌ nu ndukwin ykwiꞌ David ꞌin Krixtu. ¿Ni sa ñaꞌan ndyoꞌo chaꞌ nu nchkwiꞌ nten chaꞌ sñiꞌ steꞌ ti ayman David ka Krixtu sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Loꞌo bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Loꞌo nchga nten nu ndiꞌin nde kwa ynan suꞌwe neꞌ chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Chaꞌ tiya ꞌa tiꞌ tyiꞌin wan chaꞌ ja kwiñi lyoꞌo mstru nu nduꞌu chaꞌ joꞌo kwa ꞌwan. Ndiya ꞌa tiꞌ mstru kanꞌ, chaꞌ ka tlyu neꞌ; kanꞌ chaꞌ nchkuꞌ neꞌ teꞌ tukwin kuꞌ, teꞌ jwñun ni, chaꞌ lye ꞌa kuꞌni tnun nten ꞌin neꞌ bra nu tsaa neꞌ lo kiyaꞌ, ngwañaꞌan nchka tiꞌ mstru kanꞌ. Xkwiꞌ lo yka xlya nu suꞌwe la ñaꞌan ndyukwa neꞌ kanꞌ niꞌ lyaa ꞌin neꞌ, ndukwa neꞌ seꞌen suꞌwe la chaꞌ ndaꞌan neꞌ taꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Loꞌo ndlaa neꞌ kanꞌ naꞌan tyi nu kunaꞌan nu nganun ska ti. Nñilyoꞌo ti neꞌ kanꞌ ꞌin nten chaꞌ nten suꞌwe lka neꞌ kanꞌ; kanꞌ chaꞌ kaꞌan ꞌa chaꞌ joꞌo nchkwiꞌ neꞌ, chan ꞌa nchkwiꞌ neꞌ loꞌo Ndiose bra kanꞌ. Chaꞌ nu tukwa chaꞌ nsuꞌwi tiye neꞌ kanꞌ, kanꞌ chaꞌ kaꞌan la nu tiꞌí tyijin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Bra kanꞌ naꞌan Jesús ꞌin neꞌ kuliyaꞌ nu ndaꞌan niꞌ lyaa, chaꞌ msuꞌwa neꞌ tñi niꞌ kiñaꞌ seꞌen msuꞌwa neꞌ lomstan. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Loꞌo ngwañaꞌan naꞌan yu ꞌin ska nu kunaꞌan tiꞌi chaꞌ nganun ska ti, tukwa ti tñi xuwe msuꞌwa lomstan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Bra kanꞌ ykwiꞌ Jesús loꞌo taꞌa ndaꞌan yu: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ kaꞌan la nsuꞌwi lyo lomstan nu mda nu kunaꞌan tiꞌi kwa ke lomstan nu mda nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Neꞌ kuliyaꞌ kwa ni, mda neꞌ chinꞌ tñi nu wa ngunun ti ꞌin neꞌ; loꞌo nu kunaꞌan tiꞌi kwa ni, tiꞌi ꞌa, wa mda nchga nu nsuꞌwi ꞌin chaꞌ tyijin yuꞌwi ꞌin lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ti kwiꞌ bra kanꞌ mduun chinꞌ nten nu nchkwiꞌ chaꞌ ꞌin laa tnun kanꞌ, loꞌo nchkwiꞌ neꞌ chaꞌ ꞌin kee nu suꞌwe ꞌa ñaꞌan nu nsuꞌwi siꞌ laa kanꞌ; nchkwiꞌ neꞌ chaꞌ ꞌin nchga nan nu suꞌwe ꞌa ñaꞌan, nu wa mda neꞌ lomstan chaꞌ ka suꞌwe la ñaꞌan niꞌ lyaa kanꞌ. Bra kanꞌ ykwiꞌ Jesús chaꞌ ꞌin laa kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Tiya tsan nu tyii chaꞌ ꞌin nchga nan nu ñaꞌan wan re ni, katin ran, sa ñaꞌan yaꞌ nu ja ska ꞌa kee kanun skwa chunꞌ taꞌa ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bra kanꞌ mnichaꞌ neꞌ ꞌin Jesús: ―Mstru, ¿ni sa ñaꞌan bra ka chaꞌ kanꞌ a? ―ndukwin neꞌ ꞌin Jesús―. ¿Ni sa ñaꞌan ka chaꞌ ka biyaꞌ tiꞌ ba xa wa ka ti chaꞌ kuxi kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","―Kiꞌya wan kwenta ―ndukwin Jesús bra kanꞌ―, chaꞌ ja tukwin kwiñi lyoꞌo ꞌwan. Kaꞌan ꞌa nten kan nu chkwiꞌ chaꞌ ykwiꞌ neꞌ lka Krixtu: “Wa ndiya bra nu mdiyan Ni xiyaꞌ” nchkwin neꞌ kanꞌ. Ja xñi wan chaꞌ nu chkwiꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Bra nu kii tiꞌ wan chaꞌ wa mdiyan bra nu lye ꞌa nxuun nten, ni siya kichen tyi wan, ni siya tijyuꞌ la, ja kutsen wan bra kanꞌ. Ndiꞌin chaꞌ ka nchga chaꞌ kanꞌ ti kulo la, xa nu ti ji tiya bra tsaa tii chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Bra kanꞌ ti ngwaꞌu la Jesús ꞌin neꞌ: ―Xuun taꞌa nten ska laꞌa tsuꞌ loꞌo neꞌ xka laꞌa tsuꞌ, ngwañaꞌan xuun taꞌa nten ska kichen tnun loꞌo nten xka kichen tnun. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lye ꞌa kiñan chalyuu bra kanꞌ, lye ꞌa ka jwiꞌñan ꞌin neꞌ; lo nchga kichen kan kicha tnun nu xñi ꞌin nchga nten bra kanꞌ. Lye ꞌa ñaꞌan ka nde niꞌ kwan, lye ꞌa kutsen nten chalyuu chaꞌ ñaꞌan neꞌ nchga chaꞌ tnun nu ka nde niꞌ kwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’ꞌWan ni, xa nu ti ji ka chaꞌ kanꞌ, bra kanꞌ xñi neꞌ ꞌwan chaꞌ skanꞌ neꞌ ꞌwan, ta neꞌ nu tiꞌí ꞌwan, xtya neꞌ kiꞌya ꞌwan seꞌen ndyoꞌ tiꞌin neꞌ niꞌ lyaa; loꞌo suꞌwa neꞌ ꞌwan niꞌ ñaꞌan chkwan, tsaa loꞌo neꞌ ꞌwan tloo ree, tloo xka la nten nu lka ndloo la, chunꞌ msñi wan chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ni siya kuxi ꞌa ka chaꞌ kanꞌ, kaja bra ꞌwan chaꞌ chkwiꞌ wan chaꞌ ꞌñaǎn loꞌo nten bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ja kaꞌan ꞌa chaꞌ tyaꞌan chaꞌ tiye wan xa nu ti ji ka chaꞌ kanꞌ, sa ñaꞌan nu chkwiꞌ wan loꞌo neꞌ nu lka tñan chaꞌ ka tyoꞌo laa wan yaꞌ neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ti kwiꞌ bra kanꞌ kuꞌniǐn chaꞌ kiꞌya chaꞌ ke wan, chaꞌ ka jlyo tiꞌ wan sa ñaꞌan nu chkwiꞌ wan loꞌo neꞌ kanꞌ, chaꞌ ja kaja chaꞌ kuxi nu chkwiꞌ nu nxuun loꞌo wan ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ti kwiꞌ sti wan, ti kwiꞌ taꞌa ngula wan, loꞌo taꞌa wan nu wa tijyuꞌ la, loꞌo taꞌa suꞌwe nsuꞌwi wan, ti kwiꞌ neꞌ kanꞌ tsaa loꞌo neꞌ ꞌwan tloo neꞌ wsiya. Loꞌo tiya bra nu kujwi neꞌ ꞌwan bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","chaꞌ tyukwi ñaꞌaan chalyuu nsuꞌwi kaꞌan ꞌa nten nu ka tiꞌí tiꞌ ꞌwan chunꞌ ndyaa ñaꞌan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ja ska kichanꞌ ke wan kanaꞌ chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Bra wa mdaloo wan nchga chaꞌ kuxi kanꞌ, bra kanꞌ kaja chalyuu nu ja tsaa tii ꞌa ꞌwan bra wa mdyii nchga chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Bra nu ñaꞌan wan chaꞌ nsuꞌwa loꞌoo nu nxuun loꞌo wan ñaꞌaan tuꞌwa kichen Jerusalén re, bra kanꞌ ka biyaꞌ tiꞌ wan chaꞌ wa tsaa tii chaꞌ ꞌin kichen tyi wan re. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Loꞌo bra kanꞌ nchga wan, loꞌo nchga nten nu ti ndiꞌin lo yuu ꞌin Judea re, ndiꞌin chaꞌ xnan wan tyaa wan xuꞌwi kutsiꞌ wan nde lo kiꞌya; loꞌo nten nu ndiꞌin kichen Jerusalén re, ndiꞌin chaꞌ tyoꞌo tsuꞌ neꞌ kichen re; loꞌo neꞌ nu ndiꞌin niꞌ kixinꞌ, ja kaja ꞌa bra tyaan neꞌ nde kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tsan nu tyijin wan nu tiꞌí ka tsan kanꞌ, kwiꞌ tsan kanꞌ tyoꞌo tukwa nchga chaꞌ nu ndukwa lo kityi kula chaꞌ ka. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Tꞌnan ꞌa neꞌ kunaꞌan nu nsuꞌwi sñiꞌ tsan kanꞌ! Ngwañaꞌan, ¡tꞌnan ꞌa neꞌ kunaꞌan nu nsuꞌwi kuwiꞌ kuneꞌ nu ti ngatiꞌ!, chaꞌ lye ꞌa tyijin nten chalyuu nu tiꞌí; kuxi ꞌa nu tiꞌí nu tyijin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ndiya neꞌ nu kaja laja chaꞌ wsuun kanꞌ, loꞌo ndiya xka ta nten nu tyaa neꞌ presu tijyuꞌ, nchga lo yuu xka laꞌa tsuꞌ. Kuꞌni tyii neꞌ xka laꞌa tsuꞌ kanꞌ kichen Jerusalén re, sa ñaꞌan bra nu tyii yijan nu mjwi chabiyaꞌ ꞌin neꞌ kanꞌ, chaꞌ ka neꞌ ndloo nde re. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tyoꞌo tukwa chaꞌ tnun nu ñaꞌan neꞌ lo kwichaa, lo koꞌ, kwiꞌ ngwañaꞌan lo kwii kulasiin nu nsuꞌwi nde niꞌ kwan. Bra kanꞌ lye ꞌa sten chaꞌ chen ñaꞌan ke nten chalyuu; kutsen ꞌa neꞌ bra kanꞌ, chunꞌ lye ꞌa kanen ngatsa kulooꞌ lo tyiꞌa tujoꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ka naꞌan ꞌa tiꞌ nten, chaꞌ kutsen ꞌa neꞌ, laja nu ndiꞌin ta neꞌ si ti ka la chaꞌ kuxi kanꞌ; lye ꞌa kuwe tiꞌ neꞌ nan nka ka lo chalyuu. Loꞌo lye ꞌa kiñan nchga kwii kulasiin nu nsuꞌwi nde niꞌ kwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Bra kanꞌ ñaꞌan neꞌ ꞌñaǎn ykwiǐnꞌ, chaꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, ñaꞌan neꞌ ꞌñaǎn bra nu kaǎn xiyaꞌ laja koo nu luwi ꞌa. Tlyu ꞌa chabiyaꞌ kaja ꞌñaǎn bra nu kaǎn bra kanꞌ; kwiꞌ ngwañaꞌan, lye ꞌa xuꞌwi xaa seꞌen kaǎn bra kanꞌ, chaꞌ kaǎn ndloo la. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bra nu tyisnan nchga chaꞌ kanꞌ, ka ngula la tiꞌ kasiya ꞌwan, ka suꞌwe ka tiye wan xiyaꞌ, chunꞌ bra ti kulaǎn ꞌwan bra kanꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Loꞌo ngwaꞌu Jesús xka chaꞌ re ꞌin neꞌ bra kanꞌ: ―Ñaꞌan wan chinꞌ ꞌin nchga yka kityi, ñaꞌan wan chinꞌ ꞌin yka nstin; ");
INSERT INTO ctpNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","bra nu ñaꞌan wan chaꞌ wa ndukwa lkaꞌ yka kanꞌ, bra kanꞌ ka biyaꞌ tiꞌ wan chaꞌ wa ndla ti kala tyoo. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ti kwiꞌ ngwañaꞌan ka loꞌo nchga chaꞌ nu nchkwiǐnꞌ re, ka biyaꞌ tiꞌ wan chaꞌ wa kan ti Ndiose chaꞌ ka ndloo la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús―, ka nchga chaꞌ kanꞌ bra nu ja ya tyii chaꞌ ꞌin nten nu ndiꞌin lo chalyuu ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tyii chaꞌ ꞌin nchga nan nu nsuꞌwi nde niꞌ kwan, tyii chaꞌ ꞌin nchga nan nu nsuꞌwi lo yuu, loꞌo ja tyii chaꞌ nu wa ykwiǐnꞌ loꞌo wan; ndiꞌin chaꞌ ka nchga chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Kiꞌya wan kwenta ꞌwan, ti ykwiꞌ ti wan, chaꞌ tiya ti tiꞌ tyiꞌin wan bra nu tiya tsan kanꞌ; si kwiji ti wan chaꞌ suꞌwe ꞌwan ya ñaꞌan ti chaꞌ ndaꞌan yuꞌwi ti wan lo kichen, chaꞌ kuꞌwi ti wan, kwiꞌ ngwañaꞌan, si nsuꞌwi tyun ꞌa chaꞌ nu nduwe ꞌa tiꞌ wan lo chalyuu, ja ka tyiꞌin wan ndii ti tiꞌ wan bra kanꞌ. Sa ñaꞌan nchka tiꞌ ska soꞌo, ");
INSERT INTO ctpNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ngwañaꞌan kutsen nten bra nu tiya tsan kanꞌ, nchga seꞌen ndiꞌin nten tyukwi ñaꞌaan chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kanꞌ chaꞌ, chaꞌ tiya ti tiꞌ tyiꞌin wan lo chalyuu. Nchga bra chkwiꞌ wan loꞌo Ndiose chaꞌ tayaꞌ Ni ꞌwan, chaꞌ taloo wan bra nu ka chaꞌ kuxi kanꞌ lo chalyuu. Loꞌo bra kanꞌ kaja ñaꞌan kala wan seꞌen tyukwaǎn ykwiǐnꞌ seꞌen nu kuꞌni biyaǎnꞌ chaꞌ ꞌwan, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Bra nu tikeeꞌ kwan nchga tsan mdaꞌan Jesús nguaꞌu yu ꞌin nten niꞌ lyaa tnun nde kichen Jerusalén kanꞌ; nchga tla mdoꞌo yu ndyaa yu nde lo kiꞌya nu ndukwa kwiꞌ seꞌen ti, nu naan kiꞌya Olivos. ");
INSERT INTO ctpNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nchga tsan, tlya ꞌa mdaꞌan kaꞌan ꞌa nten niꞌ lyaa tnun kanꞌ, chaꞌ kunan neꞌ nchga chaꞌ nu nduꞌu Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wa tiya ti taꞌa bra nu nchku neꞌ judío ska lo jaxlya nu ja loꞌo skwan tiyeꞌ ndyaꞌ; taꞌa pascua, ngwañaꞌan naan taꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Loꞌo sti joꞌo nu lka ndloo loꞌo mstru nu nduꞌu chaꞌ joꞌo kanꞌ, mnan ti ndaꞌan naan neꞌ sa ñaꞌan ka kujwi neꞌ ꞌin Jesús. Mnan ti yꞌni neꞌ chaꞌ kanꞌ, chaꞌ ntsen neꞌ ꞌin neꞌ kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Bra kanꞌ ykwiꞌ kuneꞌ xaꞌan nu naan Satanás yten niꞌ kasiya ꞌin Juda Iscariote, ti kwiꞌ taꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús lka yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kanꞌ lka nu ndyaa seꞌen ndiꞌin sti joꞌo nu lka ndloo la loꞌo neꞌ nu lka tñan niꞌ lyaa. Bra kanꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ sa ñaꞌan nu kuꞌni yu chaꞌ ta yu ꞌin Jesús yaꞌ yu nu nduun kwan, chaꞌ tyaan loꞌo neꞌ ꞌin Jesús seꞌen ndiꞌin sti joꞌo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Suꞌwe ꞌa ngwa tiye sti joꞌo kanꞌ. Loꞌo bra kanꞌ ndukwin neꞌ kanꞌ ꞌin yu chaꞌ ta neꞌ tñi ꞌin yu; ");
INSERT INTO ctpNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","mskanꞌ yu chaꞌ loꞌo neꞌ, kanꞌ chaꞌ mdyisnan yu ngunaan yu sa ñaꞌan nu kuꞌni yu chaꞌ tyaan loꞌo yu ꞌin Jesús laja nu ja ndiꞌin nten kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Bra kanꞌ wa mdiya tsan taꞌa nu nchku neꞌ jaxlya tiji kanꞌ nu ja loꞌo skwan tiyeꞌ ndyaꞌ; ti kwiꞌ tsan kanꞌ ndiꞌin chaꞌ kujwi neꞌ slyaꞌ kuneꞌ chaꞌ ku neꞌ siin taꞌa pascua kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Bra kanꞌ ngulo Jesús tñan ꞌin Xuwa loꞌo Tyu: ―Yaa lya wan chaꞌ kuꞌni xuꞌwe wan siin nu kuan chaꞌ ꞌin taꞌa pascua re ―ndukwin yu ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Bra kanꞌ mnichaꞌ neꞌ kanꞌ ꞌin yu: ―¿La nde yaꞌ nchka tiiꞌ chaꞌ kuꞌni xuꞌwe ba siin kanꞌ a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Bra nu sten wan tuꞌwa kichen ni, bra kanꞌ tyukwa taꞌa wan loꞌo ska yu kiꞌyu nu ndukwa ska teꞌén tyiꞌa skun yu ―ndukwin Jesús―. Tsaa ñaꞌan wan ꞌin yu sa ñaꞌan yaꞌ nu kala wan ska tunaꞌan seꞌen sten yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Bra kanꞌ chkwiꞌ wan loꞌo neꞌ nu lka naꞌan tyi kanꞌ: “Nde lka chaꞌ nu ndukwin mstru chaꞌ jñan ba ꞌiin: ¿La nde yaꞌ ndukwa kwartu seꞌen kaǎn chaꞌ ku siinǎn loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌñaǎn, chaꞌ kuꞌni ba taꞌa pascua re a?” nchkwin wan ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Bra kanꞌ kwaꞌu yu ska kwartu ꞌwan, ska kwartu tlyu nde kwan la nu wa lka ngwa suꞌwe. La kanꞌ kuꞌni xuꞌwe wan siin kanꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Mdoꞌo neꞌ kanꞌ ndyaa neꞌ bra kanꞌ; sa ñaꞌan nu ndukwin Jesús ꞌin neꞌ chaꞌ ka, ngwañaꞌan ngwa chaꞌ kanꞌ. Bra kanꞌ yꞌni xuꞌwe neꞌ siin seꞌen nu kuꞌni neꞌ taꞌa pascua kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Bra wa mdiya bra chaꞌ ku siin neꞌ, ndyaa tukwa Jesús tuꞌwa msaa loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Loꞌo ykwiꞌ yu loꞌo neꞌ kanꞌ: ―¡Ti sꞌni nchka tiǎnꞌ chaꞌ ku siinǎn taꞌa pascua re loꞌo wan, bra nu ti ji kajaǎn! ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nchka tiǎnꞌ katsaǎnꞌ ꞌwan chaꞌ xiyaꞌ ti kuꞌniǐn taꞌa re loꞌo wan sa ñaꞌan bra nu tsaa tii chalyuu, loꞌo bra kanꞌ kuǎn ꞌin ran xiyaꞌ bra nu ka Ndiose ndloo la ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bra kanꞌ msñi Jesús ska basu mñun, ndyaa yu xuꞌwe ꞌin Ndiose bra kanꞌ. Nde lka chaꞌ nu ykwiꞌ yu loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Koꞌo wan mñun nu nsuꞌwi niꞌ basu re, kwiꞌ ngwañaꞌan ta wan mñun re koꞌo nchga neꞌ taꞌa wan ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Chañi chaꞌ nu katsaǎnꞌ ꞌwan, chaꞌ ja koꞌoǔn ꞌaǎn mñun loꞌo wan sa ñaꞌan bra nu ka Ndiose ndloo la ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Bra kanꞌ msñi Jesús ja xlya, ndyaa yu xuꞌwe ꞌin Ndiose, msuꞌwe yu jaxlya kanꞌ, chaꞌ ta yu ꞌin neꞌ. Bra kanꞌ ykwiꞌ yu loꞌo neꞌ: ―Nde lkaǎn, tyukwi ñaꞌaan ykwiǐnꞌ lka re. Nan wa nda Ndiose Stiǐn ꞌñaǎn chaꞌ kajaǎn chaꞌ ka suꞌwe chaꞌ ꞌwan. Tyaa yuꞌwi tiꞌ wan ꞌñaǎn bra nu ku wan jaxlya re. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ti kwiꞌ ngwañaꞌan yꞌni Jesús loꞌo basu kanꞌ bra wa mdyii yku neꞌ. ―Bra nu koꞌo wan mñun re tyaa yuꞌwi tiꞌ wan ꞌin chaꞌ kwi nu wa skanꞌ ti Ndiose loꞌo wan ―ndukwin Jesús bra kanꞌ―. Bra nu kajaǎn lo wsi, bra kanꞌ kalu tneěn chaꞌ ka suꞌwe chaꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Loꞌo ni, ndiya yu nu kujwiꞌ xuꞌwa ꞌñaǎn yaꞌ neꞌ xaꞌan; suꞌwa ti ndukwaǎn loꞌo yu kanꞌ tuꞌwa msaa re ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Loꞌo naꞌ nu wa ndijyaǎn chaꞌ kaǎn nten, ndiꞌin chaꞌ tsaꞌaǎn tuwiin seꞌen ndukwin Ndiose Stiǐn chaꞌ tsaꞌaǎn. Bra kanꞌ, ¡tꞌnan ꞌa yu nu wa yjwiꞌ xuꞌwa ꞌñaǎn yaꞌ neꞌ xaꞌan kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Bra kanꞌ mdyisnan neꞌ nchkwiꞌ neꞌ loꞌo taꞌa ndukwa neꞌ kanꞌ: ―¿Ti ka lka nu ta ꞌin mstru ꞌñaan yaꞌ neꞌ xaꞌan a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Bra ti mdyisnan neꞌ ngiꞌni siyeꞌ neꞌ loꞌo taꞌa ngiꞌni xaꞌan neꞌ, nchkwiꞌ neꞌ ti ka nu ka ndloo la ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Laja bra kanꞌ xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Nchga lo xꞌnan chalyuu, suꞌwe ꞌa ndlo neꞌ tñan ꞌin nten ꞌin neꞌ; nten nu suꞌwe ꞌa ngiꞌni lka nu lka ndloo kanꞌ, ngwañaꞌan nchkwiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ꞌWan ni, ja ndiꞌin chaꞌ kuꞌni wan ngwañaꞌan loꞌo taꞌa nten wan. Nde ka tñan nu kuꞌni wan suꞌwe la. Bra nu nchka tiꞌ wan chaꞌ ka ndloo la chaꞌ ꞌwan ke taꞌa nten wan, bra kanꞌ ndiꞌin chaꞌ kuꞌni wan sa ñaꞌan si lka wan nu xuwe la ꞌin neꞌ taꞌa wan ―ndukwin Jesús ꞌin neꞌ kanꞌ―. Ngwañaꞌan ꞌwan nu nchka tiꞌ wan kulo wan tñan ꞌin taꞌa nten wan, ndiꞌin chaꞌ kuꞌni wan tñan chaꞌ ꞌin nchga neꞌ taꞌa wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ti ka nu ngiꞌni la chaꞌ ꞌin sikwa a? ¿Nu ndukwa tuꞌwa msaa chaꞌ ku a? ¿O ta msu nu nxku ꞌin yu a? Chañi chaꞌ yu nu ndukwa tuꞌwa msaa, kanꞌ lka nu ngiꞌni la chaꞌ ꞌin, chaꞌ kanꞌ lka xꞌnan neꞌ. Naꞌ ni, sa ñaꞌan si lkaǎn ska msu ꞌwan, ngwañaꞌan ndiꞌiǐn laja wan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’ꞌWan ni, wa ndiꞌin wan loꞌoǔn nchga tsan nu ndiꞌiǐn ndijiǐn nu tiꞌí lo chalyuu re, ");
INSERT INTO ctpNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","kanꞌ chaꞌ taǎn ska tñan suꞌwe nu kuꞌni wan chaꞌ ka wan tñan loꞌoǔn; tñan kanꞌ ka sa ñaꞌan lka tñan nu nda Stiǐn ꞌñaǎn, chaꞌ kaǎn ndloo. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Loꞌo suꞌwa ti ku wan koꞌo wan loꞌoǔn bra kanꞌ; kwiꞌ suꞌwa ti tyukwa wan loꞌoǔn bra nu kuꞌni biyaǎnꞌ ꞌin nchga nten; loꞌo ngwañaꞌan kuꞌni biyaꞌ wan ꞌin taꞌa nten wan, nu tii tyukwa ta neꞌ Israel taꞌaan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Bra kanꞌ ykwiꞌ Jesús loꞌo Tyu Simón kanꞌ: ―Simón ―ndukwin―, sa ñaꞌan lka chaꞌ ꞌiin ni, ñaꞌan tiꞌ si wa mjñan Satanás chabiyaꞌ chaꞌ ta nu tiꞌí ꞌin nchga wan; wa nchka tiꞌ yu kuꞌni biyaꞌ yu ꞌwan, chaꞌ xitsen yu ꞌwan. Sa ñaꞌan lka xa nu nskwian mta trigu chaꞌ tyuwi ran, ngwañaꞌan kuꞌni yu loꞌo wan, nchka tiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bra kanꞌ wa mjñaǎn ꞌin Ndiose Stiǐn chaꞌ ꞌiin, Tyu, chaꞌ ja tsaa tii chaꞌ tsaa ñaꞌan tiiꞌ ꞌñaǎn. Bra wa mdijin chaꞌ kuxi kanꞌ ꞌiin, chaꞌ xiyaꞌ chkwiiꞌ chaꞌ ꞌñaǎn, bra kanꞌ ka tayaaꞌ ꞌin xka la taꞌa wan chaꞌ suꞌwe la xñi neꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","―Yu kula ―ndukwin Simón bra kanꞌ―, ja nꞌni chaꞌ ni siya tsaꞌaǎn loꞌoo niꞌ ñaꞌan chkwan, ni siya kajaǎn loꞌoo ―ndukwin yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","―Nde lka chaꞌ nu nchkwiǐnꞌ loꞌoo ni, Tyu ―ndukwin Jesús ꞌin yu―, chaꞌ bra nu ti ji xiꞌya la kwiꞌe tla ndaꞌa, bra kanꞌ snan yaꞌ chkwiiꞌ chaꞌ ja nsuꞌwi lyoo ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Bra kanꞌ mnichaꞌ Jesús ꞌin neꞌ: ―Bra nu nguloǔn tñan ꞌwan chaꞌ tsaa wan xka kichen nu ja loꞌo kwijin tñi ꞌwan, ja loꞌo xka kwijin, ja loꞌo kanan ꞌwan, ¿ta wa yuꞌwi nan nu lyiji ꞌwan bra kanꞌ a? ―Ja ska nan lyiji ꞌwa bra kanꞌ ―mxkwen neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Ngwañaꞌan ngwa bra kanꞌ, loꞌo ni, xka ñaꞌan ndiꞌin chaꞌ kuꞌni wan ni. ꞌWan nu nsuꞌwi kwijin tñi ꞌwan, loꞌo kanꞌ kwiꞌya wan tsaa wan, loꞌo xka kwijin; si ja nsuꞌwi xtyi wsuun ꞌwan, ndiꞌin chaꞌ kujwiꞌ wan steꞌ wan chaꞌ xiꞌi wan xtyi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nde lka chaꞌ nu nchkwiǐnꞌ loꞌo wan chaꞌ ndiꞌin chaꞌ tyoꞌo tukwa chaꞌ kuxi nu nchkwiꞌ kityi kula chaꞌ ka ꞌñaǎn. Ngwañaꞌan ndukwa chaꞌ: “Sa ñaꞌan nu ngiꞌni nten loꞌo neꞌ kuxi, ngwañaꞌan kuꞌni neꞌ loꞌo ykwiꞌ Krixtu.” Nchga chaꞌ nu ndiꞌin chaꞌ ka ꞌñaǎn, chañi chaꞌ ka chaꞌ kanꞌ ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Bra kanꞌ ndukwin neꞌ kanꞌ ꞌin yu: ―Yu kula, nde ndiya tukwa xtyi wsuun ―ndukwin neꞌ. ―Yaꞌ la sikwa ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Bra kanꞌ mdoꞌo Jesús ndyaa yu nde lo kiꞌya Olivos, sa ñaꞌan nu ngiꞌni ti yu. Loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdoꞌo ñaꞌan neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Bra nu mdiyan neꞌ la kanꞌ, bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ: ―Chkwiꞌ wan loꞌo Ndiose Stiǐn chaꞌ ja kwiñi lyoꞌo kuneꞌ xaꞌan ꞌwan ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bra kanꞌ mdoꞌo tsuꞌ Jesús nde seꞌen ndiꞌin neꞌ sa ñaꞌan yaꞌ nu tiya ska kee kuun neꞌ, la kanꞌ mduun xtyinꞌ Jesús chaꞌ chkwiꞌ yu loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Stiǐn ―ndukwin yu―, ¿ja nsuꞌwi chinꞌ xka ñaꞌan nu ka kuꞌniǐn tñan tnun re, chaꞌ ja kaja la nu tiꞌí ꞌñaǎn? ―ndukwin Jesús ꞌin Ndiose Sti yu―. Ni siya ngwañaꞌan, nchka tiǎnꞌ kuꞌniǐn nchga tñan sa ñaꞌan nu nchka tiiꞌ chaꞌ kuꞌniǐn. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Bra kanꞌ mdoꞌo tukwa ska angajle nu mdoꞌo nde seꞌen ndiꞌin Ndiose niꞌ kwan, chaꞌ kuꞌni chaꞌ talo la Jesús tñan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Xa nu lye ꞌa tiꞌí Jesús, bra kanꞌ lye la ykwiꞌ yu loꞌo Ndiose. Loꞌo lye ꞌa ngulo rta Jesús ñaꞌan mdsuꞌ lo yuu; sa ñaꞌan lka ska mdsuꞌ tnen ykwiꞌ, ngwañaꞌan ñaꞌan ran. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Mdyii ykwiꞌ Jesús loꞌo Ndiose Sti yu, bra kanꞌ mxitukwi yu ndyaan yu seꞌen ndiꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. Bra kanꞌ ndyija neꞌ ꞌin yu, ndiꞌin neꞌ lajaꞌ neꞌ chaꞌ ja mdalo ꞌa neꞌ, chaꞌ xiꞌin ꞌa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Bra kanꞌ ykwiꞌ yu loꞌo neꞌ: ―¿Ni chaꞌ lka ndiꞌin wan lajaꞌ wan ni? Tyituun lya wan chaꞌ chkwiꞌ wan loꞌo Ndiose, chaꞌ ja kwiñi lyoꞌo kuneꞌ xaꞌan ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ti nchkwiꞌ la Jesús loꞌo neꞌ kanꞌ, bra kanꞌ mdiyan kaꞌan ꞌa nten. Nu naan Juda kanꞌ, ska yu nsuꞌwi laja tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, ngwaꞌu yu tuwiin ꞌin nten kaꞌan kanꞌ. Yan yu seꞌen nduun Jesús chaꞌ chkwichaꞌ yu skaꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Bra kanꞌ ykwiꞌ Jesús loꞌo yu kanꞌ: ―Juda ―ndukwin―, ¿ta kujwiiꞌ xuꞌwa ꞌñaǎn yaꞌ neꞌ xaꞌan, kanꞌ chaꞌ nchkwichaaꞌ ꞌñaǎn a?, naꞌ nu wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Bra wa naꞌan neꞌ nu nduun loꞌo Jesús sa ñaꞌan ngwa chaꞌ kanꞌ, bra kanꞌ mnichaꞌ neꞌ ꞌin yu: ―Yu kula ―ndukwin neꞌ―, ¿ta kulaa ba ꞌiin loꞌo xtyi, chaꞌ ja kan ꞌa neꞌ kwa a? ");
INSERT INTO ctpNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bra kanꞌ mskwen ska taꞌa neꞌ kanꞌ xtyi ꞌin yu, msiꞌyu kuꞌ yu jin nxkan laꞌa seꞌen kwin ꞌin ska msu ꞌin xꞌnan sti joꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bra kanꞌ ndukwin Jesús ꞌin neꞌ: ―Yaꞌ la sa kwa ti. Kulaa sti wan xtyi ꞌwan. Bra kanꞌ ylaꞌ Jesús jin nxkan msu kanꞌ, xiyaꞌ ngwa suꞌwe jin nxkan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Bra ti ykwiꞌ Jesús loꞌo sti joꞌo nu lka ndloo, loꞌo neꞌ nu lka tñan niꞌ lyaa, ngwañaꞌan loꞌo nchga neꞌ kula kichen nu mdiyan chaꞌ tyaa loꞌo ꞌin yu: ―¿Ta nan mdiyan wan loꞌo xtyi ꞌwan, loꞌo yka ꞌwan, chaꞌ jwiꞌin yka wan ꞌñaǎn sa ñaꞌan nu njyiꞌin neꞌ ꞌin ska yu nu yꞌni kunan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nchga tsan mdiꞌiǐn loꞌo wan niꞌ lyaa tnun kanꞌ, ja siyaꞌ mskwen yaꞌ wan ꞌñaǎn bra kanꞌ. Loꞌo ni, wa mjwi chinꞌ tyempu ꞌwan chaꞌ kuꞌni wan chaꞌ kuxi re, chaꞌ wa mda kuneꞌ xaꞌan chabiyaꞌ ꞌwan; ti kwiꞌ kanꞌ lka nu ndlo la tñan ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Loꞌo msñi neꞌ ꞌin Jesús chaꞌ ka presu, ndyaa loꞌo neꞌ ꞌin nde tuꞌ naꞌan ꞌin xꞌnan sti joꞌo bra kanꞌ. Loꞌo Tyu ni, ndyaa ñaꞌan yu ꞌin neꞌ tijyuꞌ ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kanꞌ mxuꞌu tukwa neꞌ chinꞌ kiiꞌ jluꞌwe liyaꞌ naꞌan ꞌin sti joꞌo, mdyoꞌ tiꞌin neꞌ tuꞌwa kiiꞌ kanꞌ bra kanꞌ; loꞌo Tyu ndukwa yu laja neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Bra kanꞌ naꞌan ska nu kunaꞌan nu lka msu ꞌin sti joꞌo chaꞌ loꞌo Tyu ndukwa tuꞌwa kiiꞌ kanꞌ. Naꞌan kwiꞌya ꞌa nu kunaꞌan kanꞌ ꞌin yu, bra kanꞌ ykwiꞌ loꞌo neꞌ: ―Loꞌo yu kiꞌyu re ndaꞌan loꞌo Jesús kanꞌ ―ndukwin ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bra ti mxkwen Tyu ꞌin nu kunaꞌan kanꞌ: ―Neꞌ kula, ja nsuꞌwi lyoǔn ꞌin yu kwa ―ndukwin Tyu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chunꞌ ndiꞌin la chinꞌ naꞌan xka nten ꞌin yu. ―Loꞌo yu re lka yu taꞌa ndaꞌan neꞌ kwa ―ndukwin nten kanꞌ. ―Siꞌi naꞌ ―ndukwin yu―. Ja lkaǎn taꞌa ndaꞌan neꞌ kwa ―ndukwin Tyu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chunꞌ ndiꞌin la, bra kanꞌ ykwiꞌ xka nten loꞌo taꞌa ndaꞌan yu: ―Chañi chaꞌ loꞌo yu kiꞌyu re ndaꞌan loꞌo presu kwa, chaꞌ loꞌo yu re lka yu neꞌ Galilea ―ndukwin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","―Che ―ndukwin Tyu bra kanꞌ―, ja jlyo tiǎnꞌ ni chaꞌ lka nchkwiꞌ wan ngwañaꞌan. Ti kwiꞌ bra nu ti nduun Tyu nchkwiꞌ, bra kanꞌ msiꞌya ska la kwiꞌe. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Bra kanꞌ mxinaꞌan Jesús seꞌen nduun yu niꞌ ñaꞌan, chaꞌ ñaꞌan yu ꞌin Tyu. Bra ti ndyaa yuꞌwi tiꞌ Tyu chaꞌ nu wa ykwiꞌ Jesús loꞌo yu ti kulo la. Nde ñaꞌan ngwa chaꞌ kanꞌ: “Bra nu ti ji xiꞌya la kwiꞌe tla ndiꞌa, bra kanꞌ snan yaꞌ chkwiiꞌ chaꞌ ja nsuꞌwi lyoo ꞌñaǎn” ndukwin Jesús ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Bra kanꞌ mdoꞌo Tyu nde liyaꞌ, lye ꞌa ynan yu chaꞌ ngwa xiꞌin ꞌa tiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Loꞌo neꞌ nu nduun kwan ꞌin Jesús, mstyi lyoꞌo ꞌa neꞌ ꞌin Jesús, mjiꞌin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mskanꞌ neꞌ ska teꞌ tloo Jesús, mykwanꞌ neꞌ tloo yu. Bra kanꞌ ykwiꞌ neꞌ loꞌo yu: ―¿Ta jlyo ka tiiꞌ ni, ti ka nu yjwi ꞌiin a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ngwañaꞌan kaꞌan la chaꞌ chen ñaꞌan ykwiꞌ neꞌ kanꞌ loꞌo Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ngwiꞌya xaa, bra kanꞌ mdyoꞌ tiꞌin neꞌ kula ꞌin neꞌ judío, loꞌo sti joꞌo nu lka ndloo, loꞌo mstru nu nduꞌu chaꞌ joꞌo; ndyaa loꞌo neꞌ ꞌin Jesús tloo nchga neꞌ wsiya kanꞌ. La kanꞌ mdyisnan neꞌ mnichaꞌ neꞌ ꞌin yu: ");
INSERT INTO ctpNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Katsaaꞌ lya ꞌwa si lkaa Krixtu ―ndukwin neꞌ ꞌin yu. Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Ni siya kuniǐn ꞌwan ngwañaꞌan, ja tsaa ñaꞌan tiꞌ wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ni siya ndiya ska chaꞌ nu kunichaǎnꞌ ꞌwan, ja xkwen wan ꞌñaǎn. Wa jlyo tiǎnꞌ chaꞌ ja kulaa wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kanꞌ chaꞌ, chunꞌ ndiꞌin la naꞌ nu ndijyaǎn chaꞌ kaǎn nten, tyukwaǎn nde laꞌa seꞌen kwin ꞌin Ndiose nu nchka ꞌin nchga tñan. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Bra ti mnichaꞌ nchga neꞌ tnun ꞌin yu: ―¿Nuꞌwin lkaa Sñiꞌ ykwiꞌ Ndiose sikwa a? Bra kanꞌ mxkwen Jesús ꞌin neꞌ xiyaꞌ: ―Chañi chaꞌ nu ykwiꞌ wan, chaꞌ ndukwin wan chaꞌ kanꞌ nu lkaǎn ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","―Ja nchka tianꞌ kunaan xka nten nu jlyo la tiꞌ ―ndukwin neꞌ bra kanꞌ―. Taꞌaan wa ynaan chaꞌ nu ykwiꞌ yu re. Tuꞌwa ykwiꞌ yu re wa mdoꞌo chaꞌ kwiñi ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mdyituun nchga neꞌ wsiya bra kanꞌ, ndyaa loꞌo neꞌ ꞌin Jesús seꞌen ndiꞌin Pilato nu lka gobernador romano bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mdyisnan neꞌ mstya neꞌ kiꞌya ꞌin Jesús bra kanꞌ: ―Wa msñi ba ꞌin yu kiꞌyu re, chaꞌ ndatsaa ꞌa yu ꞌin neꞌ judío taꞌa kichen tyi ba. Ndukwin yu chaꞌ ja nsuꞌwi chabiyaꞌ ta ba tñi nu ndlo neꞌ nu lka tñan ꞌwan, neꞌ romano; loꞌo lye ꞌa nchkwiꞌ yu chaꞌ ykwiꞌ yu lka yu Krixtu, sa ñaꞌan si lka yu ree nu lka ndloo la ꞌwa ―ndukwin neꞌ ꞌin Pilato. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bra kanꞌ mnichaꞌ Pilato ꞌin Jesús: ―¿Ta nuꞌwin lkaa Ree ꞌin neꞌ judío a? ―ndukwin. Bra kanꞌ mxkwen Jesús ꞌin Pilato: ―Ti kwiꞌ sa ñaꞌan nu wa ykwiiꞌ, ti kwiꞌ kanꞌ lkaǎn ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bra kanꞌ ykwiꞌ Pilato loꞌo sti joꞌo nu lka ndloo loꞌo xka la nten nu ndaꞌan loꞌo yu: ―Ja ska chaꞌ kuxi ndyija ꞌñaǎn chaꞌ xtyaǎn kiꞌya ꞌin yu re ―ndukwin Pilato. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Loꞌo xiyaꞌ lye la ykwiꞌ neꞌ kanꞌ, kwen ꞌa msiꞌya loꞌo neꞌ ꞌin Pilato bra kanꞌ: ―Nda yu re chaꞌ msinꞌ tiꞌ ꞌin nchga nten nde Judea re siꞌya chaꞌ nu nduꞌu yu ꞌin neꞌ ―ndukwin neꞌ―. Nde Galilea mdyisnan yu re, loꞌo ni, loꞌo nde re nduꞌu yu chaꞌ kuxi kanꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Bra wa ynan Pilato chaꞌ kanꞌ, bra kanꞌ mnichaꞌ yu ꞌin neꞌ si nde Galilea mdoꞌo Jesús ndijyan. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","―Ti kwiꞌ ―ndukwin neꞌ. Bra kanꞌ ndyuꞌwi tiꞌ Pilato chaꞌ ndiꞌin Herodes kichen Jerusalén tsan kanꞌ. Loꞌo Herodes ni, lka yu ndloo ꞌin neꞌ Galilea; kanꞌ chaꞌ msuꞌwa Pilato ꞌin Jesús ndyaa seꞌen ndiꞌin Herodes kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Bra wa naꞌan Herodes ꞌin Jesús, suꞌwe ꞌa ngwa tiye yu bra kanꞌ, chaꞌ wa sꞌni ꞌa nchka tiꞌ yu ñaꞌan yu ꞌin Jesús. Wa ynan yu chaꞌ nchkwiꞌ nten chaꞌ ꞌin Jesús, loꞌo nchka ꞌa tiꞌ yu ñaꞌan yu ska chaꞌ tnun nu kuꞌni Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kaꞌan ꞌa chaꞌ mnichaꞌ yu ꞌin Jesús bra kanꞌ, loꞌo ja mxkwen ꞌa Jesús ꞌin yu siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Loꞌo ndiꞌin sti joꞌo nu lka ndloo loꞌo mstru nu nduꞌu chaꞌ joꞌo; mstya ꞌa neꞌ kanꞌ kiꞌya ꞌin Jesús, kaꞌan ꞌa chaꞌ kuxi ykwiꞌ neꞌ kanꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Bra kanꞌ lye ꞌa mda Herodes nu tiꞌí ꞌin Jesús; ngwañaꞌan sndaru ꞌin yu, kuxi ꞌa yꞌni neꞌ loꞌo. Mxkuꞌ neꞌ teꞌ suꞌwe ꞌa ñaꞌan ꞌin yu bra kanꞌ, chaꞌ kaja ñaꞌan nu xtyi lyoꞌo neꞌ ꞌin yu. Teꞌ nduwi ꞌa ñaꞌan lka ran, sa ñaꞌan ñaꞌan steꞌ ree mxkuꞌ neꞌ ꞌin yu. Bra kanꞌ msuꞌwa Herodes ꞌin Jesús ndyaa xiyaꞌ nde seꞌen ndiꞌin Pilato. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tsan kanꞌ ngwa suꞌwa chaꞌ ꞌin Herodes loꞌo Pilato xiyaꞌ; yuꞌwi ꞌa chaꞌ wsuun ꞌin neꞌ ti kulo la, loꞌo ni yꞌni xuꞌwe neꞌ chaꞌ ꞌin neꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bra kanꞌ mxoꞌ tiꞌin Pilato ꞌin nchga sti joꞌo nu lka ndloo, loꞌo nchga neꞌ wsiya, loꞌo nchga nten kichen. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Ti kwiꞌ ꞌwan mdiyan loꞌo wan ꞌin yu kiꞌyu re seꞌen ndiꞌiǐn, ndukwin wan chaꞌ lye ꞌa nskwen tikeeꞌ yu ꞌin taꞌa kichen tyi wan ―ndukwin yu ꞌin neꞌ―. Wa ykwiǐnꞌ loꞌo yu re tloo nchga wan; wa naꞌan wan chaꞌ ja ska kiꞌya ndyija ꞌin yu ꞌñaǎn, sa ñaꞌan kiꞌya nu mstya wan ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Kwiꞌ ngwañaꞌan Herodes, ja mjwi kiꞌya nu xtya yu kula kanꞌ ꞌin Jesús re, kanꞌ chaꞌ wa mda yu kula kanꞌ ꞌin yu ndyaan yu seꞌen ndiꞌiǐn xiyaꞌ. Ja ska chaꞌ kuxi yꞌni yu sikwa, kanꞌ chaꞌ ja ndiꞌin ꞌa chaꞌ kaja yu chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Taǎn chinꞌ nu tiꞌí ꞌin yu kulo ndukwa la, bra kanꞌ kulaǎn ꞌin yu ―ndukwin Pilato ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nchga yijan laja taꞌa pascua, bra kanꞌ ndlaa yu gobernador ꞌin ska ti presu ngwa ti ñaꞌan; ");
INSERT INTO ctpNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","kanꞌ chaꞌ mdyisnan nchga nten kichen, kwen ꞌa msiꞌya neꞌ suꞌwa ti, mjñan neꞌ xka presu ꞌin Pilato: ―¡Ja kulaa ꞌin yu kiꞌyu re! ―ndukwin neꞌ―. ¡Yaa loꞌoo ꞌin yu re! ¡Kulaa ꞌin Barrabás kanꞌ, chaꞌ tyoꞌo yu ngwa ti ñaꞌan! ");
INSERT INTO ctpNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nan wa msuꞌwa neꞌ ꞌin Barrabás kanꞌ niꞌ ñaꞌan chkwan siꞌya chaꞌ mdatsaa ꞌa yu ꞌin nten kichen chaꞌ xuun neꞌ loꞌo neꞌ xka laꞌa tsuꞌ nu lka ndloo. Bra kanꞌ yjwi ꞌa Barrabás ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ngwa tiꞌ Pilato kulaa ꞌin Jesús, kanꞌ chaꞌ xiyaꞌ ykwiꞌ yu loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kwen la mxkwen nten kaꞌan kanꞌ ꞌin Pilato bra kanꞌ: ―¡Jwiꞌin kaꞌaan lyaa ꞌin yu lo wsi chaꞌ kaja yu! ―ndukwin neꞌ―. ¡Jwiꞌin kaꞌaan lyaa ꞌin yu lo wsi! ―ndukwin nten kaꞌan kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Wa mdaꞌa snan yaꞌ ykwiꞌ Pilato loꞌo neꞌ bra kanꞌ: ―¿Ni sa ñaꞌan chaꞌ kuxi yꞌni yu re a? Ja ska chaꞌ kuxi ꞌin yu re ndyija ꞌñaǎn ―ndukwin Pilato―, kanꞌ chaꞌ ja nꞌni ꞌa chaꞌ kaja yu. Suꞌwe la si taǎn chinꞌ nu tiꞌí ꞌin yu, chunꞌ ndiꞌin la kulaǎn ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bra kanꞌ kwen la msiꞌya neꞌ mxkwen neꞌ ꞌin Pilato, chaꞌ jwiꞌin kaꞌan lya ꞌin Jesús lo wsi. Lye ꞌa ykwiꞌ nten kichen, loꞌo sti joꞌo nu lka ndloo ykwiꞌ ꞌa neꞌ, kanꞌ chaꞌ keeꞌ ꞌa mslyaa Pilato kuꞌni tñan nu ngwa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bra kanꞌ mda yu chabiyaꞌ chaꞌ ka chaꞌ nu mjñan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ngulaa yu ꞌin Barrabás nu yꞌni ꞌa chaꞌ wsuun, nu wa yjwi ꞌin nten, chaꞌ kanꞌ lka nu ngulo suwi nten kichen chaꞌ tyoꞌo ñaꞌan chkwan. Bra kanꞌ mda Pilato ꞌin Jesús ꞌin neꞌ chaꞌ kuꞌni neꞌ sa ñaꞌan nu nchka ti tiꞌ neꞌ kuꞌni neꞌ loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Bra kanꞌ ndyaa loꞌo sndaru ꞌin Jesús chaꞌ jwiꞌin kaꞌan neꞌ ꞌin yu lo wsi. Bra kanꞌ ndyukwa taꞌa sndaru loꞌo ska nten nu naan Simón, nu ndyaan yu yaa yu niꞌ kixinꞌ; neꞌ kichen Cirene lka yu kanꞌ. Kanꞌ ngulo sndaru tñan ꞌin yu chaꞌ kwiꞌya yu wsi nu mdiꞌya Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kaꞌan ꞌa nten ndyaa ñaꞌan neꞌ ꞌin Jesús. Kwiꞌ ngwañaꞌan, mdaꞌan kaꞌan ꞌa neꞌ kunaꞌan, nganaan ꞌa neꞌ; kwen ꞌa msiꞌya neꞌ chaꞌ xiꞌin ꞌa tiꞌ neꞌ chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bra kanꞌ naꞌan Jesús seꞌen nduun neꞌ kunaꞌan kanꞌ, ykwiꞌ yu loꞌo neꞌ kanꞌ: ―ꞌWan neꞌ kunaꞌan Jerusalén re, ja kunaan ꞌa wan chaꞌ ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ―. Suꞌwe la kunaan wan chaꞌ ꞌwan, ti ykwiꞌ ti wan, chaꞌ ꞌin sñiꞌ wan. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Wa tiya ti tsan kuxi ꞌwan, bra kanꞌ chkwiꞌ nten chaꞌ re: “Suꞌwe la ndiꞌin ska nu kunaꞌan nu ja ya tyiꞌin sñiꞌ, nu ja ya kuꞌni kala ska nten, nu ja ya ta katiꞌ ska nu xuwe” nchkwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Bra kanꞌ tyisnan nten xiꞌya: “Suꞌwe la si tiyu kiꞌya kwan chuanꞌ, skunꞌ mondun yuu chuanꞌ, chaꞌ tsaa tii chaꞌ ꞌñaan siyaꞌ ti.” Ngwañaꞌan chkwiꞌ neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñaꞌan wan sa ñaꞌan nu ngiꞌni neꞌ loꞌoǔn ni. ¿Ni sa ñaꞌan kuꞌni neꞌ loꞌo wan neꞌ judío bra kanꞌ sikwa? Suꞌwe ꞌa chaꞌ nu ndiꞌin ꞌñaǎn; sa ñaꞌan lka ska yka nu ngaꞌá ꞌa, ngwañaꞌan suꞌwe ndiꞌin tiyeěn loꞌo Ndiose Stiǐn. Loꞌo ꞌwan, ja suꞌwe chaꞌ nu nchka ꞌwan; wa ndla ti tyii chaꞌ ꞌwan ngwa ti ñaꞌan, chaꞌ sa ñaꞌan lka ska yka nkwi, ngwañaꞌan lka wan loꞌo taꞌa kichen tyi wan ―ndukwin Jesús ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Loꞌo ndyaa loꞌo neꞌ ꞌin xa tyukwa nten nu tnun ꞌa kiꞌya ndiꞌin ꞌin neꞌ, chaꞌ suꞌwa ti kujwi neꞌ ꞌin nten kanꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Bra nu mdiya neꞌ seꞌen naan La Calavera (kiꞌya seꞌen nskwa tijyan ke jyoꞌo), bra kanꞌ mjiꞌin kaꞌan neꞌ ꞌin Jesús lo wsi la kanꞌ. Kwiꞌ ngwañaꞌan, mjiꞌin kaꞌan neꞌ ꞌin taꞌa tyukwaa nten nu mdiꞌin kiꞌya tnun ꞌin; mjiꞌin kaꞌan neꞌ ꞌin ska yu kuxi kanꞌ lo xka yka wsi nu nduun laꞌa seꞌen kwin seꞌen ngaꞌan Jesús, bra kanꞌ mjiꞌin kaꞌan neꞌ ꞌin xka yu kuxi kanꞌ lo xka yka wsi nu nduun laꞌa seꞌen kaa. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Xa nu ti ndiꞌin sndaru nu mjiꞌin kaꞌan ꞌin neꞌ lo wsi, bra kanꞌ ykwiꞌ Jesús loꞌo Ndiose Sti yu: ―Stiǐn ―ndukwin yu―, kuꞌnii chaꞌ tlyu tiꞌ ꞌin neꞌ re, ja jlyo ꞌa tiꞌ neꞌ ni chaꞌ lka ngiꞌni neꞌ ngwañaꞌan. Bra kanꞌ ngutsaa sndaru kanꞌ steꞌ Jesús xa nu ndiꞌin jya ti neꞌ loꞌo taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Loꞌo mdiꞌin ꞌa nten nu ñaꞌan kwiꞌya ꞌin Jesús. Loꞌo neꞌ wsiya mstyi lyoꞌo neꞌ ꞌin Jesús bra kanꞌ. Nde ñaꞌan ykwiꞌ neꞌ loꞌo taꞌa neꞌ: ―Ngulaa yu ꞌin xka la nten nu ngwa xkanꞌ; loꞌo ni, ndiꞌin chaꞌ kulaa yu ꞌin yu, ti ykwiꞌ ti yu, si chañi chaꞌ lka yu Krixtu nu ngulo suwi Ndiose ꞌin ndijyan lo chalyuu re ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Loꞌo sndaru kanꞌ, mstyi lyoꞌo neꞌ ꞌin yu ndijyan neꞌ kwiꞌ seꞌen nduun wsi, mda neꞌ mñun tiyeꞌ chaꞌ koꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Bra kanꞌ ykwiꞌ neꞌ kanꞌ loꞌo yu: ―Kulaa ꞌiin ti ykwiiꞌ ti, si chañi lkaa Ree ꞌin neꞌ judío ―ndukwin sndaru kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wa ngaꞌan letra ke wsi seꞌen ngaꞌan Jesús nu nchkwiꞌ: “Yu re lka yu Ree nu lka ndloo la ꞌin neꞌ judío.” Snan lo chaꞌ nu nchkwiꞌ nten ngaꞌan chaꞌ kanꞌ: chaꞌ griego ngaꞌan, loꞌo chaꞌ latín ngaꞌan, loꞌo chaꞌ nu nchkwiꞌ neꞌ judío ngaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bra kanꞌ chen ñaꞌan ykwiꞌ ska yu kunan taꞌa ngaꞌan Jesús lo wsi kanꞌ: ―Si chañi chaꞌ Krixtu lkaa, kulaa ꞌiin ti ykwiiꞌ ti sikwa; loꞌo ꞌware, kulaa ꞌwa ―ndukwin yu ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bra kanꞌ mxkwen xka yu kunan ꞌin taꞌa yu: ―¿Ja ntseen ꞌin Ndiose sikwa a? Suꞌwa ti nu tiꞌí ndijian taꞌa snaan ni ―ndukwin yu ꞌin taꞌa kunan yu―. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ñi ꞌa ndiꞌin chaꞌ ta neꞌ nu tiꞌí ꞌñaan, chaꞌ kanꞌ ndiꞌin chaꞌ ka ꞌñaan siꞌya chaꞌ kuxi nu yꞌnian; loꞌo yu re, ja ska chaꞌ kuxi yꞌni yu re. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bra kanꞌ ykwiꞌ yu kanꞌ loꞌo Jesús: ―Yu kula Jesús ―ndukwin―, tyuꞌwi tiiꞌ ꞌñaǎn xa nu tyisnan chaꞌ kaa ndloo ―ndukwin yu kunan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Mxkwen Jesús ꞌin yu bra kanꞌ: ―Chañi chaꞌ nchkwiǐnꞌ loꞌoo ―ndukwin―, ti kwiꞌ tsan ni ka tyiꞌiin loꞌoǔn la seꞌen suꞌwe ꞌa, seꞌen ndiꞌin Ndiose nde niꞌ kwan ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ndiꞌya kwan ngwa, bra kanꞌ ngwa tla tyukwi ñaꞌaan chalyuu; ngwa tla sa ñaꞌan yaꞌ nu mdiya bra wa snan siin, ");
INSERT INTO ctpNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","loꞌo ngwa tla loo kwichaa bra kanꞌ. Teꞌ tlyu nu ndukwi niꞌ lyaa tnun kanꞌ, mdoꞌo yuꞌwe teꞌ kanꞌ jluꞌwe la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Loꞌo kwen ꞌa msiꞌya Jesús: ―Stiǐn, tiꞌyaa kasiya ꞌñaǎn ―ndukwin yu. Bra wa ykwiꞌ yu chaꞌ kanꞌ, bra ti ngujwi yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Bra nu naꞌan capitán ꞌin sndaru romano sa ñaꞌan ngwa chaꞌ kanꞌ, bra kanꞌ yꞌni tnun yu ꞌin Ndiose. Nde ñaꞌan ykwiꞌ yu bra kanꞌ: ―Chañi chaꞌ ja mdiꞌin kiꞌya ꞌin ayman re siyaꞌ ti ―ndukwin capitán ꞌin sndaru kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nchga nten nu ndiꞌin nde kwa bra kanꞌ, xa wa naꞌan neꞌ nchga chaꞌ nu ngwa kanꞌ, mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ. Mjiꞌin neꞌ ndukunꞌ neꞌ tijyan tiye neꞌ ndyaa neꞌ chaꞌ xiꞌin ꞌa tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","La kanꞌ nganun nchga taꞌa suꞌwe nsuꞌwi Jesús nde seꞌen nduun wsi, loꞌo neꞌ kunaꞌan nu wa mdaꞌan loꞌo yu ti bra nu mdyisnan ti tñan ꞌin yu nde Galilea, nganun neꞌ kanꞌ tijyuꞌ ti ñaꞌan kwiꞌya neꞌ chaꞌ nu nchka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Wa ndiya ska nten suꞌwe nu ngiꞌni tnun ꞌin Ndiose, Se naan yu kula kanꞌ. Arimatea lka kichen tyi yu; ndiꞌin kichen kanꞌ lo yuu ꞌin Judea. Ska nu lka tñan lka Se kanꞌ, suꞌwa ti ndukwa yu loꞌo nchga neꞌ wsiya ꞌin neꞌ judío. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ti ngwa sꞌni wa ngita ꞌa Se kanꞌ sa ñaꞌan bra kan Ndiose chaꞌ ka Ni ndloo la lo chalyuu, kanꞌ chaꞌ ja ngwa suꞌwa chaꞌ ꞌin yu loꞌo taꞌa wsiya yu chaꞌ mstya neꞌ kiꞌya ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ndyaa Se bra kanꞌ, ndyaa seꞌen ndiꞌin Pilato chaꞌ jñan chabiyaꞌ tsaa loꞌo ꞌin ayman Jesús chaꞌ kutsiꞌ ꞌin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mdiꞌya neꞌ ꞌin ayman kanꞌ lo wsi, bra kanꞌ mxiin Se ska teꞌ luwi chunꞌ ayman Jesús; yaa loꞌo neꞌ ꞌin ayman kanꞌ msuꞌwa neꞌ ꞌin yu ska niꞌ kwaa seꞌen ngulu neꞌ siꞌ yuu, seꞌen ja ya kutsiꞌ neꞌ ꞌin nten siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tsan taꞌa siin lka kanꞌ, kanꞌ chaꞌ ngiꞌni kuwe tiꞌ neꞌ chaꞌ wa tyisnan ti taꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Loꞌo neꞌ kunaꞌan nu yan loꞌo Jesús nde Galilea ni, yaa ñaꞌan neꞌ ꞌin Se kanꞌ, chaꞌ ñaꞌan niꞌ kwaa seꞌen nsu ayman Jesús, chaꞌ ka biyaꞌ tiꞌ neꞌ la nde yaꞌ msuꞌwa neꞌ ꞌin ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bra kanꞌ mxitukwi neꞌ ndyaan neꞌ lo kichen xiyaꞌ. Loꞌo yꞌni xuꞌwe neꞌ tyiꞌa nu xi tyiꞌi, loꞌo sete nu suꞌwe tyiꞌi chaꞌ xuꞌwi chunꞌ ayman kanꞌ. Bra kanꞌ mxitñaꞌ neꞌ tsan taꞌa kanꞌ, sa ñaꞌan nu ndukwa tñan lo kityi kula chaꞌ kuꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wa kiꞌya ti xaa tsan kulo ꞌin smnan kanꞌ, tlya ꞌa ndyaa neꞌ kunaꞌan kanꞌ tuꞌwa kwaa seꞌen mtsiꞌ ayman Jesús. Mbiꞌya neꞌ tyiꞌa xi tyiꞌi nu wa yꞌni xuꞌwe neꞌ. Loꞌo xka ta neꞌ kunaꞌan ndyaa loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ndiya neꞌ tuꞌwa kwaa, bra kanꞌ naꞌan neꞌ kee nu nchkunꞌ tuꞌwa kwaa kanꞌ, chaꞌ ja nduun ꞌa kee kanꞌ tuꞌwa kwaa; ndukwa laa ti kwaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Yten neꞌ niꞌ kwaa chaꞌ ñaꞌan neꞌ, loꞌo ja nsu ꞌa ayman Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ytsen ꞌa neꞌ kunaꞌan kanꞌ bra kanꞌ, ja jlyo ꞌa tiꞌ neꞌ sa ñaꞌan nu kuꞌni neꞌ. Bra kanꞌ naꞌan neꞌ chaꞌ loꞌo nduun tukwa yu kiꞌyu seꞌen ndiꞌin neꞌ; nduwi ꞌa steꞌ yu kiꞌyu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Msnan yuꞌwi tiye neꞌ kunaꞌan kanꞌ bra kanꞌ, mdyisti neꞌ lyuu chaꞌ ytsen ꞌa neꞌ ꞌin yu kiꞌyu kanꞌ. Bra kanꞌ ykwiꞌ yu kanꞌ loꞌo neꞌ: ―¿Ni chaꞌ ndaꞌan naan wan ꞌin ska nten nu luꞌu seꞌen nsu ayman re a? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ja nsu ꞌa yu kanꞌ nde re, chaꞌ wa ndyuꞌu yu xiyaꞌ. Tyaa yuꞌwi tiꞌ wan sa ñaꞌan chaꞌ nu ndukwin yu ꞌwan bra nu ti ndiꞌin wan nde Galilea. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ykwiꞌ yu nu wa yan yu lo chalyuu chaꞌ ngwa yu nten, wa ytsaꞌ yu ꞌwan nu ngwa xkanꞌ chaꞌ ta neꞌ ꞌin yu yaꞌ neꞌ xaꞌan, chaꞌ jwiꞌin kaꞌan neꞌ ꞌin yu lo wsi. La mdaꞌa snan tsan, bra kanꞌ tyuꞌu yu xiyaꞌ, ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Bra kanꞌ ndyaa yuꞌwi tiꞌ neꞌ kunaꞌan kanꞌ nchga chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ ti ngwa xkanꞌ la chaꞌ ꞌin ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Mdyituun neꞌ, mdoꞌo neꞌ ndyaan neꞌ lo kichen, ngala neꞌ seꞌen ndiꞌin tii xka neꞌ nu yꞌni xaꞌan chaꞌ ꞌin Jesús. Bra kanꞌ ytsaꞌ neꞌ kunaꞌan kanꞌ nchga chaꞌ kanꞌ ꞌin neꞌ, kanꞌ chaꞌ ngwa chaꞌ nchga neꞌ nu mdaꞌan loꞌo Jesús ynan neꞌ chaꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nde lka sa ñaꞌan naan nu kunaꞌan nu yaa tuꞌwa kwaa kanꞌ: yaa Liya Magdalena, loꞌo Xnan, loꞌo Liya jyaꞌan Santiago, loꞌo xka la neꞌ kunaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Siꞌi ngwañaꞌan ngwa, mskeꞌ tiꞌ neꞌ nu yꞌni xaꞌan kanꞌ; nan wa yten chaꞌ chen ñaꞌan ke neꞌ kunaꞌan kanꞌ, mskeꞌ tiꞌ neꞌ. Ja ndyaa ñaꞌan tiꞌ neꞌ chaꞌ nu ytsaꞌ neꞌ kunaꞌan kanꞌ ꞌin neꞌ siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ni siya ngwañaꞌan mskeꞌ tiꞌ neꞌ, bra ti msnan Tyu ndyaa yu tuꞌwa kwaa kanꞌ. Bra kanꞌ naꞌan Tyu niꞌ kwaa kanꞌ, chaꞌ xka laꞌa ti nsu teꞌ nu mxiin chunꞌ ayman Jesús nu ngwa xkanꞌ. Bra kanꞌ mdoꞌo Tyu ndyaan yu nde seꞌen ndiꞌin neꞌ xiyaꞌ, mdaꞌan ꞌa chaꞌ tiye neꞌ sa ñaꞌan ngwa chaꞌ ja nsu ꞌa ayman kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ti kwiꞌ tsan kanꞌ mdoꞌo yu tukwa yu ndyaa yu nde kichen Emaús. Kichen kanꞌ nsuꞌwi tii xka kilómetro biyaꞌ tijyuꞌ ꞌin Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mdaꞌan ti yu tuwiin, nchkwiꞌ ꞌa yu loꞌo taꞌa yu chaꞌ ꞌin nchga chaꞌ nu ngwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ti nchkwiꞌ luwe yu ꞌin chaꞌ kanꞌ, bra kanꞌ mdukwa ykwiꞌ Jesús ꞌin yu, suꞌwa ti ndaꞌan Jesús loꞌo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Naꞌan yu chinꞌ ꞌin Jesús, loꞌo ja ngwa xuꞌwi lyo suꞌwe yu ꞌin Jesús, chaꞌ nsuꞌwi ska chaꞌ nu ndukunꞌ xaa kiloo yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bra kanꞌ mnichaꞌ Jesús ꞌin yu: ―¿Ni sa ñaꞌan chaꞌ nchkwiꞌ luwe wan chaꞌ ndijyan wan tuwiin re? ¿Ni chaꞌ lka xiꞌin ꞌa tiꞌ wan? ―ndukwin Jesús ꞌin neꞌ. Bra ti ndyaa tuun yu, ");
INSERT INTO ctpNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","mxkwen ska yu nu naan Cleofas ꞌin Jesús: ―Tyukwi ñaꞌaan chalyuu wa jlyo tiꞌ neꞌ nan lka ngwa nde Jerusalén tsan nu tka mdijin ti. ¿Ta xka ti nuꞌwin nu ja jlyo tiꞌ nan lka nu ngwa nde Jerusalén kwa a? Jlyo tiꞌ nchga neꞌ xka kichen nu yaa taꞌa kwa. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","―¿Nan lka ngwa a? ―ndukwin Jesús ꞌin yu. Bra kanꞌ mxkwen yu ꞌin Jesús: ―Chaꞌ ꞌin Jesús Nazaret ―ndukwin yu―, ska nten nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ngwa yu. Ngwa ꞌa ꞌin yu chkwiꞌ yu, loꞌo ngwa ꞌa ꞌin yu kuꞌni yu kaꞌan ꞌa chaꞌ tnun chabiyaꞌ ꞌin Ndiose; kaꞌan ꞌa nten naꞌan ꞌin chaꞌ tnun kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bra kanꞌ sti joꞌo nu lka ndloo loꞌo neꞌ nu lka tñan, mda neꞌ ꞌin yu yaꞌ neꞌ wsiya chaꞌ kujwi neꞌ ꞌin yu lo wsi. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wa mdijin snan tsan nu ngwa chaꞌ kanꞌ. Loꞌo bare ni, ndyaa ñaꞌan ꞌa tiꞌ ba ꞌin yu nu ngwa xkanꞌ, chaꞌ kanꞌ lka nu kulaa ꞌin neꞌ Israel taꞌaan, chaꞌ ja ka ꞌa neꞌ xka laꞌa tsuꞌ ka ndloo la ꞌñaan, chaꞌ tyiꞌin suꞌwean lo yuu kichen tyian, ngwa tiꞌ ba. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Loꞌo ni, mxitsen chinꞌ neꞌ kunaꞌan taꞌa ndaꞌan ba ꞌwa, chaꞌ tlya ꞌa yaa neꞌ kunaꞌan kanꞌ tuꞌwa kwaa, ");
INSERT INTO ctpNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","loꞌo ja ndyija ꞌa ayman Jesús kanꞌ ꞌin neꞌ, niꞌ kwaa. Ndyaan neꞌ bra kanꞌ, ytsaꞌ neꞌ ꞌwa chaꞌ wa naꞌan neꞌ ska chaꞌ tnun. Nan ngwaꞌu tloo ti tukwa angajle ꞌin neꞌ kunaꞌan kanꞌ; ndukwin angajle kanꞌ ꞌin neꞌ chaꞌ wa ndyuꞌu Jesús xiyaꞌ ni. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Bra ti yaa chinꞌ neꞌ taꞌa yꞌni xaꞌan ba tuꞌwa kwaa bra kanꞌ, naꞌan neꞌ ꞌin angajle kanꞌ sa ñaꞌan nu ndukwin nu kunaꞌan kanꞌ, loꞌo ja naꞌan neꞌ ꞌin ykwiꞌ Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Bra kanꞌ ykwiꞌ Jesús loꞌo yu nu taꞌa ndijyan yu tuwiin kanꞌ: ―Ti lyiji ꞌa chaꞌ ꞌwan chaꞌ ka biyaꞌ suꞌwe tiꞌ wan nchga chaꞌ; keeꞌ ꞌa nxñi wan nchga chaꞌ nu ngwaꞌu ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ta siꞌi nan ndukwa chaꞌ tyijin nu nka Krixtu kanꞌ nu tiꞌí sa ñaꞌan nu ngwa ni a? Chunꞌ ndiꞌin la sten Krixtu seꞌen suꞌwe ꞌa ñaꞌan seꞌen nu ka tnun la ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Bra kanꞌ mdyisnan Jesús ngwaꞌu yu ꞌin neꞌ, nchga chaꞌ nu wa ndukwa lo kityi kula chaꞌ ꞌin ykwiꞌ yu. Mdyisnan yu loꞌo kityi nu ngwaꞌan ayman Moisés, bra kanꞌ ykwiꞌ yu nchga chaꞌ nu ndukwa lo kityi nu ngwaꞌan neꞌ nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wa tiya ti neꞌ tuꞌwa kichen seꞌen ndyaa neꞌ, bra kanꞌ yꞌni Jesús sa ñaꞌan si ti tsaa la yu tuwiin tijyuꞌ la. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Bra kanꞌ lye ꞌa ykwiꞌ neꞌ loꞌo yu chaꞌ kanun yu seꞌen ndiꞌin neꞌ. Ndukwin neꞌ ꞌin yu: ―Kanun loꞌo ba chaꞌ wa msiin ꞌa ni, wa kiꞌya ti tla. Bra kanꞌ yten Jesús niꞌ ñaꞌan chaꞌ kanun yu loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wa ndukwa yu loꞌo neꞌ tuꞌwa msaa, bra kanꞌ msñi yu ska jaxlya, ndya yu xuꞌwe ꞌin Ndiose; bra kanꞌ msuꞌwe yu jaxlya kanꞌ, chaꞌ ta yu ku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ti kwiꞌ bra ngala xaa kiloo neꞌ, loꞌo yuꞌwi lyo suꞌwe neꞌ ꞌin yu. Bra kanꞌ mdoꞌo yu seꞌen ndukwa neꞌ ndyaa yu, ja naꞌan ꞌa neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Bra ti ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―¿Ta siꞌi chañi chaꞌ suꞌwe ꞌa ngwa tiyean ni a? ―ndukwin―. Tiin ti mdiꞌin kasiya ꞌñaan bra nu mdiyan yu nchkwiꞌ yu loꞌoan tuwiin, chunꞌ wa ngwaꞌu yu ꞌñaan sa ñaꞌan nu nchkwiꞌ kityi kula ―ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Bra kanꞌ chinꞌ ti bra ngunun neꞌ, bra ti msñi neꞌ tuwiin ndyaan neꞌ nde Jerusalén xiyaꞌ. Bra kanꞌ ngala neꞌ nde seꞌen ndyoꞌ tiꞌin taꞌa tii xka neꞌ nu yꞌni xaꞌan chaꞌ ꞌin Jesús kanꞌ, loꞌo chinꞌ xka ta taꞌa ndaꞌan neꞌ ndiꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bra ti ykwiꞌ neꞌ nu ndiya kanꞌ loꞌo neꞌ nu tka ngala ti bra kanꞌ: ―Chañi chaꞌ wa ndyuꞌu Jesús xiyaꞌ ―ndukwin neꞌ―. Wa naꞌan Simón ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Bra kanꞌ loꞌo yu nu yaa nde kichen Emaús, ytsaꞌ yu ꞌin taꞌa yu sa ñaꞌan nu ngwa ꞌin yu tuwiin; ndukwin yu sa ñaꞌan ngwa chaꞌ yuꞌwi lyo yu ꞌin Jesús bra nu mkwan Jesús ꞌin jaxlya nu yku yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ti nchkwiꞌ ti neꞌ chaꞌ kanꞌ loꞌo taꞌa neꞌ, loꞌo bra kanꞌ mdiyan ykwiꞌ Jesús. Mdyituun yu jluꞌwe la seꞌen ndiꞌin neꞌ chaꞌ chkwiꞌ yu loꞌo neꞌ: ―Tiin ti tyiꞌin kasiya ꞌwan ―ndukwin yu ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ngitsen ti neꞌ ndiꞌin neꞌ bra kanꞌ, mdaꞌan ꞌa chaꞌ tiye neꞌ, chaꞌ ska kwiꞌin ti naꞌan neꞌ, mskeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bra kanꞌ ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―¿Ni chaꞌ lka nu ngitsen wan ndiꞌin wan? ―ndukwin―. ¿Ni chaꞌ lka nu nduwe ꞌa tiꞌ wan? ―ndukwin yu ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ñaꞌan wan yaǎnꞌ, ñaꞌan wan kiyaǎnꞌ; ti kwiǐnꞌ lkaǎn. Kalaꞌ wan ꞌñaǎn, chaꞌ ka biyaꞌ tiꞌ wan chaꞌ naꞌ lkaǎn. Ska kwiꞌin ti ni, ja nsuꞌwi kunaꞌ ran, ja loꞌo tijyan nsuꞌwi ran; loꞌo ni, wa naꞌan wan chaꞌ nsuꞌwi kunaǎnꞌ ―ndukwin Jesús ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Bra kanꞌ ngwaꞌu yu yaꞌ yu, ngwaꞌu yu kiyaꞌ yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ja ngwa xuꞌwi lyo suꞌwe neꞌ ꞌin yu chunꞌ chaꞌ suꞌwe ꞌa nka tiyeꞌ neꞌ, chaꞌ nduwe ꞌa tiꞌ neꞌ ñaꞌan neꞌ ꞌin yu xiyaꞌ. Kanꞌ chaꞌ ndukwin Jesús ꞌin neꞌ: ―¿Ta ja ndiya chinꞌ nan kuǔn ꞌwan a? ");
INSERT INTO ctpNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Bra kanꞌ mda neꞌ sa yuꞌwe kula ngwiꞌi ꞌin yu, loꞌo sa yuꞌwe skwaꞌ kwiñaꞌ kwitun. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","―Suꞌwe ―ndukwin Jesús bra kanꞌ. Msñi yu nan ku yu kanꞌ, yku yu ꞌin ran loꞌo neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Bra ti ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―Chaꞌ nu tka ngwa ti ꞌñaǎn, kanꞌ lka chaꞌ nu wa ytsaǎnꞌ ꞌwan bra nu ti mdiꞌiǐn loꞌo wan ti ngwa xkanꞌ ―ndukwin yu―. Bra kanꞌ niǐn ꞌwan chaꞌ ndiꞌin chaꞌ ka ꞌñaǎn nchga chaꞌ nu ndukwa chaꞌ ꞌñaǎn lo kityi nu ngwaꞌan ayman Moisés, loꞌo lo kityi nu ngwaꞌan ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni, loꞌo lo kityi Salmos ndukwa chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Bra kanꞌ ngwaꞌu Jesús ꞌin neꞌ nchga chaꞌ nu nchkwiꞌ kityi kula kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kanꞌ ndukwin yu ꞌin neꞌ: ―Wa sꞌni ndukwa chaꞌ kajaǎn, chaꞌ naꞌ lkaǎn Krixtu kanꞌ; la mdaꞌa snan tsan ngujwiǐn ni, bra kanꞌ ndukwa chaꞌ tyuꞌuǔn xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Bra kanꞌ ndiꞌin chaꞌ chkwiꞌ wan chaꞌ ꞌñaǎn loꞌo nten tyukwi ñaꞌaan chalyuu. Nde Jerusalén tyisnan wan katsaꞌ wan chaꞌ kanꞌ ꞌin nten kulo ndukwa la. Ndiꞌin chaꞌ chkwiꞌ wan loꞌo nten chaꞌ ka wjyuꞌu tiꞌ neꞌ ꞌin chaꞌ kuxi nu ndiꞌin ꞌin neꞌ, chaꞌ kulaa yaꞌ neꞌ ꞌin nchga chaꞌ kuxi nu ngiꞌni neꞌ; bra kanꞌ kuꞌni Ndiose chaꞌ tlyu tiꞌ ꞌin nchga kiꞌya nu ndukwi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Loꞌo ꞌwan ni, ka chkwiꞌ wan chaꞌ ꞌñaǎn loꞌo nten, chaꞌ jlyo tiꞌ wan nchga chaꞌ nu wa ngwa ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Loꞌo taǎn Tyiꞌiǐn ykwiǐnꞌ ꞌwan, chaꞌ wa ykwiꞌ Stiǐn chaꞌ ta Ni Tyiꞌi Ni ꞌwan; kanꞌ chaꞌ kanun wan nde Jerusalén re, sa ñaꞌan bra nu kaja jwersa ꞌin Tyiꞌi Ndiose ꞌwan, kanꞌ nu tyoꞌo nde niꞌ kwan chaꞌ kan kanun niꞌ kasiya ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Bra kanꞌ mdoꞌo Jesús kichen Jerusalén kanꞌ, ndyaa loꞌo Ni ꞌin neꞌ nde tuꞌwa kichen Betania kanꞌ. Nde kanꞌ mskwen Jesús yaꞌ chaꞌ lkwan Ni ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Laja nu mdukwan Ni ꞌin neꞌ, bra ti mdoꞌo Ni ndyaa Ni nde niꞌ kwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yꞌni tnun neꞌ kanꞌ ꞌin Ni, bra kanꞌ mxitukwi neꞌ ndyaan neꞌ nde Jerusalén xiyaꞌ. Suꞌwe ꞌa ngwa tiye neꞌ bra kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","nchga bra mdaꞌan neꞌ niꞌ lyaa chaꞌ kuꞌni tnun neꞌ ꞌin Ndiose. Ngwañaꞌan ngwa chaꞌ kanꞌ.");
INSERT INTO ctpNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nu ngwa ti kulo la ndiꞌin Ndiose, kwiꞌ ndiꞌin yu nu lka tyukwi chaꞌ ꞌin Ndiose; ndiꞌin yu kanꞌ loꞌo Ndiose. Yu nu lka chaꞌ kanꞌ ni, suꞌwa ndiꞌin chaꞌ ꞌin yu loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Suꞌwa ndiꞌin yu loꞌo Ndiose nu ngwa ti kulo la. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Loꞌo yu kanꞌ ngwiñan Ni nchga nan; ja ska nan nu nsuꞌwi chalyuu tyaꞌ, si ja loꞌo yu kanꞌ mñan yu ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Seꞌen ndiꞌin Ndiose mdoꞌo yu kanꞌ, yan yu lo chalyuu chaꞌ ka suꞌwe kasiya ꞌñaan, nan neꞌ nten chalyuu. Yꞌni yu chaꞌ ka biyaꞌ tianꞌ nchga chaꞌ nu ñi loꞌo xaa nu nda yu chaꞌ kanun niꞌ kasiya ꞌñaan. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ñaꞌan ti njñiꞌni xaa kanꞌ seꞌen tla nu nsuꞌwi niꞌ kasiya ꞌin neꞌ xaꞌan, loꞌo ja nchka ꞌin neꞌ xaꞌan suwiꞌ neꞌ xaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Ngwaꞌan tñan Ndiose ꞌin ska yu kiꞌyu nu naan Xuwa, chaꞌ chkwiꞌ yu loꞌo nten chaꞌ ꞌin xaa nu wa ta ti Ni chaꞌ xuꞌwi niꞌ kasiya ꞌin nten. Yan Xuwa kanꞌ, ykwiꞌ yu chaꞌ kanꞌ loꞌo nten, chaꞌ tsaa ñaꞌan tiꞌ nchga nten chaꞌ ꞌin Ndiose siꞌya chaꞌ nu ykwiꞌ yu loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Siꞌi ti kwiꞌ xaa nu nda Ndiose ngwa Xuwa kanꞌ, wa yan ti yu chaꞌ kwaꞌu yu chaꞌ kanꞌ ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nu lka xaa nu chañi ka, wa mdiyan yu kanꞌ lo chalyuu chaꞌ ta yu xaa nu ka xuꞌwi niꞌ kasiya ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ndiꞌin yu kanꞌ lo chalyuu, ti kwiꞌ chaꞌ nu wa ytsaꞌ Ndiose ꞌin nten lka yu kanꞌ. Ngwiñan Ni chalyuu loꞌo yu kanꞌ, loꞌo ja yuꞌwi lyo nten chalyuu ꞌin yu kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yan yu kanꞌ lo chalyuu ꞌin yu nu ngwa xkanꞌ ti, loꞌo nten chalyuu nu ngwiñan yu, ja mdukwa neꞌ chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ni siya ngwañaꞌan, ti ndiꞌin chinꞌ nten nu wa yten chaꞌ ꞌin yu, ndyaa ñaꞌan tiꞌ neꞌ kanꞌ ꞌin yu bra kanꞌ; nda Ni chabiyaꞌ ꞌin nten kanꞌ chaꞌ ka neꞌ sñiꞌ Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Loꞌo nten nu lka sñiꞌ Ndiose ni, ja ndlya neꞌ kanꞌ sa ñaꞌan nu ndlya nchga sñiꞌ nten; sñiꞌ Ndiose lka neꞌ kanꞌ, siꞌi ska nten chalyuu lka nu yꞌni kwi kasiya ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ngwa yu kanꞌ nten, ti kwiꞌ yu nu lka chaꞌ ꞌin Ndiose. Suꞌwa ti mdiꞌin yu loꞌoan lo chalyuu re. Naꞌan ba ꞌin yu chaꞌ tlyu ꞌa chaꞌ ndiꞌin ꞌin yu, chaꞌ lka yu ska ti nu nka Sñiꞌ Ndiose. Xkwiꞌ suꞌwe ꞌa ngiꞌni yu loꞌoan, xkwiꞌ chaꞌ nu ñi nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nde lka chaꞌ nu ykwiꞌ Xuwa chaꞌ ꞌin Jesús kanꞌ. Kwen ykwiꞌ Xuwa bra kanꞌ: ―Kwiꞌ yu re lka nu niǐn ꞌwan chaꞌ kan lo chalyuu chunꞌ ndiꞌin la ꞌñaǎn ―ndukwin Xuwa―, ni siya tlyu la chaꞌ ndiꞌin ꞌin yu, siyaꞌ la ti chaꞌ ꞌñaǎn. Ngwañaꞌan niǐn ꞌwan, ni siya bra nu ja ya kalaǎn, wa luꞌu ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nchga loo nan nsuꞌwi ꞌin Jesús, loꞌo nchga tsan ndyiji chaꞌ suꞌwe ꞌñaan loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nu ngwa sꞌni ytsaꞌ ayman Moisés chaꞌ ꞌin nten, nchga tñan nu ndiꞌin chaꞌ kuꞌni neꞌ chaꞌ ꞌin Ndiose. Bra nu mdiyan Jesucristo ni, xka ñaꞌan ngiꞌni yu; kaꞌan ꞌa xuꞌwe nda yu ꞌñaan, nduꞌu yu chaꞌ nu ñi ꞌñaan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ja tukwin naꞌan ꞌin Ndiose; ska ti Jesús naꞌan ꞌin Ni, kanꞌ nu nduꞌu sa ñaꞌan lka Ndiose ꞌñaan, neꞌ nten chalyuu. Loꞌo Jesús kanꞌ ni, kanꞌ lka ska ti nu lka Sñiꞌ Ndiose, loꞌo ndiya ꞌa tiꞌ Ni ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Loꞌo tyun sti joꞌo loꞌo neꞌ xta, mdoꞌo neꞌ kichen Jerusalén, mdiyan neꞌ seꞌen ndiꞌin Xuwa bra kanꞌ. Neꞌ judío nu ndiꞌin Jerusalén, kanꞌ nu ngulo tñan ꞌin neꞌ, chaꞌ tsaa neꞌ seꞌen ndiꞌin Xuwa chaꞌ kunichaꞌ neꞌ ꞌin Xuwa ti ka nu lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ja mjyuꞌu ꞌa tiꞌ Xuwa; ñi ytsaꞌ yu ꞌin neꞌ chaꞌ siꞌi ti kwiꞌ yu lka yu Krixtu, nten nu tnun nchka nu msuꞌwa Ndiose chaꞌ kan lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","―¿Ti ka nu lkaa sikwa a? ―ndukwin neꞌ ꞌin yu―. ¿Ayman Elías lkaa a? ―Siꞌi nu kanꞌ lkaǎn ―ndukwin Xuwa. ―Wa tyoꞌo tukwa ti ska yu kula nu chkwiꞌ chaꞌ ꞌin Ndiose loꞌo ba, nxkeꞌ tiꞌ ba ―ndukwin neꞌ―. ¿Siꞌi nu kanꞌ lkaa a? ―Siꞌi naꞌ ―ndukwin Xuwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","―¿Ti ka nu lkaa sikwa a? ―ndukwin neꞌ ꞌin yu―. Ndiꞌin chaꞌ xkwen ba chaꞌ ꞌin nten nu ngulo tñan ꞌwa chaꞌ kan ba nde re. ¿Ni sa ñaꞌan chaꞌ nchkwiiꞌ chaꞌ ꞌiin, ti ykwiiꞌ tii a? ");
INSERT INTO ctpNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Mxkwen Xuwa ꞌin neꞌ bra kanꞌ: ―Nde ndiya chaꞌ nu kwen nchkwiǐnꞌ loꞌo nten seꞌen nduǔn niꞌ kixinꞌ: “Slaa lya wan tuwiin ñi chaꞌ kan nu nka Xꞌnaan.” ―Kanꞌ lka ska chaꞌ ꞌin Ndiose nu wa ykwiꞌ ayman Isaías loꞌo nten nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Loꞌo ndiya chinꞌ neꞌ fariseo nu nduun loꞌo neꞌ Jerusalén kanꞌ seꞌen ndiꞌin Xuwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xiyaꞌ ykwiꞌ neꞌ kanꞌ loꞌo Xuwa bra kanꞌ: ―¿Ni chaꞌ lka nduun ndukwatyaa ꞌin nten a?, chaꞌ siꞌi nten tnun kanꞌ lkaa, siꞌi ayman Elías lkaa, siꞌi yu kula nu chkwiꞌ chaꞌ ꞌin Ndiose lkaa. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","―Loꞌo tyiꞌa ti ndukwatyaǎn ꞌin nten ―ndukwin Xuwa―. Loꞌo xka yu kiꞌyu nduun seꞌen ndiꞌin wan ni, ja ya xuꞌwi lyo wan ꞌin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Chunꞌ ndiꞌin la mdiyan yu kanꞌ lo chalyuu, naꞌ mdiyaǎn kulo ndukwa la; tnun la ti lka yu kanꞌ, chinꞌ la chaꞌ nchka ꞌñaǎn ―ndukwin Xuwa ꞌin neꞌ―. Suꞌwe ꞌa ka tiyeěn ni siya ska tñan xuwe ti ka ꞌñaǎn, ñaꞌan tiꞌ si xtiǐnꞌ ti snan yu kwa, chaꞌ tnun la chaꞌ nchkwiꞌ yu ke naꞌ ―ndukwin Xuwa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ngwañaꞌan ngwa nde lo yuu ꞌin Betania, seꞌen mduun Xuwa mdukwatya ꞌin nten. Xka laꞌa tsuꞌ chku Jordán ndiya kichen Betania kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","La xka tsan naꞌan Xuwa chaꞌ ndijyan Jesús seꞌen ndiꞌin yu, kanꞌ chaꞌ ykwiꞌ yu loꞌo nten nu nduun nde kwa: ―Ñaꞌan kwiꞌya wan ꞌin yu kula kwa ―ndukwin Xuwa―. Wa ngulo suwi Ndiose ꞌin yu kwa chaꞌ kaja yu siꞌyaan. Ñaꞌan tiꞌ ska slyaꞌ kuneꞌ nu liye tiꞌ, nu ndujwi nten tloo Ndiose, ngwañaꞌan nchka tiꞌ yu kwa, chunꞌ nu suwi yu nchga kiꞌya nu ndiꞌin ꞌin nten chalyuu ―ndukwin Xuwa―. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Chaꞌ ꞌin yu kwa ykwiǐnꞌ, bra nu niǐn ꞌwan chaꞌ wa kan ti ska nten lo chalyuu re. Tnun la chaꞌ nchka ꞌin yu kwa ke naꞌ, ni siya chunꞌ ndiꞌin la mdiyan yu. Ngwañaꞌan niǐn ꞌwan chaꞌ wa luꞌu yu kwa xa nu ti ji kalaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Loꞌoǔn ni, ja yuꞌwi lyoǔn ꞌin yu kwa ti kulo; ndukwatyaǎn ꞌin nten loꞌo tyiꞌa ti chaꞌ ka xuꞌwi lyo neꞌ Israel ꞌin yu kwa nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Chunꞌ ndiꞌin la ykwiꞌ Xuwa chaꞌ ꞌin Jesús loꞌo neꞌ: ―Wa naꞌaǎn bra nu mdoꞌo Tyiꞌi Ndiose niꞌ kwan yan ngwiꞌya ke Jesús; sa ñaꞌan ndiꞌya ska kiñi cha kun, ngwañaꞌan nganun ndukwa ke yu ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ndiose lka nu ngulo tñan ꞌñaǎn chaꞌ tukwatyaǎn ꞌin nten, loꞌo Ndiose lka nu ytsaꞌ ꞌñaǎn chunꞌ ja yuꞌwi lyoǔn ꞌin Jesús ti kulo la. “Bra nu ñaꞌaan chaꞌ ndijyan ndiꞌya Tyiꞌiǐn ykwiǐnꞌ ke ska nten” ndukwin Ndiose ꞌñaǎn, “bra kanꞌ ka biyaꞌ tiiꞌ chaꞌ yu kanꞌ lka nu tukwatya ꞌin nten loꞌo Tyiꞌiǐn ykwiǐnꞌ, siꞌi loꞌo tyiꞌa ti” ndukwin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wa naꞌaǎn chaꞌ kanꞌ. Kwiꞌ chañi chaꞌ nu chkwiǐnꞌ loꞌo wan: Yu kwa lka ska ti nu nka Sñiꞌ Ndiose, kwiꞌ nu wa ngulo suwi Ni ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ngwa xka tsan, xiyaꞌ mduun Xuwa nde kwa, nduun loꞌo tukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu; mdijin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Naꞌan Xuwa ꞌin Jesús, ykwiꞌ Xuwa chaꞌ ꞌin yu bra kanꞌ: ―Nde kwa ndyaa yu nu kaja siꞌya kiꞌya nu ndukwian, ñaꞌan tiꞌ ska slyaꞌ kuneꞌ nu ndujwi nten tloo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Bra nu ynan tyukwaa neꞌ kanꞌ chaꞌ nu ykwiꞌ Xuwa, bra ti yaa ñaꞌan neꞌ kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mxinaꞌan Jesús nde chunꞌ tuwiin seꞌen ndyaa yu, naꞌan yu chaꞌ ndyaa ñaꞌan neꞌ kanꞌ ꞌin yu. Kanꞌ chaꞌ mnichaꞌ Jesús ꞌin neꞌ: ―¿Ni nan lka ndaꞌan naan wan a? ―Mstru ―ndukwin neꞌ ꞌin Jesús―, ¿la nde yaꞌ ndiꞌin nuꞌwin a? ―Kan naꞌan wan chinꞌ seꞌen ndiꞌiǐn ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kanꞌ chaꞌ ndyaa naꞌan neꞌ naꞌan seꞌen ngala Jesús, yaa ykwiꞌ neꞌ loꞌo yu bra kanꞌ. Bra wa jakwa siin mdiyan neꞌ la kwa, loꞌo nganun neꞌ loꞌo yu tyukwi msiin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wa mdiya tukwa nten kanꞌ nu mdoꞌo ñaꞌan ꞌin Jesús, kwiꞌ nu wa ynan chaꞌ nu ykwiꞌ Xuwa loꞌo neꞌ. Ska yu kanꞌ naan Ndre, taꞌa ngula Tyu Simón lka yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Bra ti ndyaa Ndre ndyaa naan yu ꞌin taꞌa yu, ti kwiꞌ Simón kanꞌ. Ykwiꞌ Ndre loꞌo taꞌa yu bra kanꞌ: ―Wa ndyija lyo ꞌwa nu lka Krixtu, nten tnun nu msuꞌwa Ndiose ndijyan lo chalyuu ―ndukwin Ndre. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndyaa loꞌo Ndre ꞌin Simón seꞌen ndiꞌin Jesús bra kanꞌ. Naꞌan kwiꞌya ꞌa Jesús ꞌin Simón kanꞌ, loꞌo nde ndiya chaꞌ nu ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Simón lka nin nuꞌwin ―ndukwin―, sñiꞌ Jona lkaa; Cefas ka naan nde loo la ―ñaꞌan tiꞌ chkwianꞌ chaꞌtñan: ska kee, suꞌwa ti lka chaꞌ kanꞌ loꞌo Tyu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","La xka tsan, ngwa tiye Jesús chaꞌ tsaa yu nde Galilea. Nde kwa ndyukwa taꞌa yu loꞌo ska yu kiꞌyu nu naan Lpe: ―Tsaa loꞌoǔn ―ndukwin Jesús ꞌin Lpe bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ti kwiꞌ yu Galilea lka Lpe kanꞌ, kwiꞌ kanꞌ lka Ndre loꞌo Tyu; kichen Betsaida lka kichen tyi neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Chunꞌ ndiꞌin yaa Lpe chaꞌ chkwiꞌ yu loꞌo Natanael taꞌa ndaꞌan yu: ―Wa naꞌan ba ꞌin Krixtu, nten tnun nchka nu ykwiꞌ ayman Moisés chaꞌ ꞌin lo kityi ꞌin Ndiose nu ngwa sꞌni ―ndukwin Lpe―. Ti kwiꞌ chaꞌ ꞌin yu kanꞌ ykwiꞌ nchga ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten nu ngwa sꞌni. Jesús naan yu kanꞌ, sñiꞌ ska nu naan Se. Nazaret lka kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","―¿Ta suꞌwe kichen kanꞌ a? ―ndukwin Natanael―. ¿Ta ndiya nten suꞌwe nde kichen Nazaret kanꞌ a? ―Kaan naꞌaan lyaa chinꞌ ꞌin yu sikwa ―ndukwin Lpe. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Naꞌan Jesús chaꞌ ndijyan Natanael: ―Nde kwa ndijyan ska neꞌ Israel nu chañi chaꞌ ngiꞌni tnun ꞌin Ndiose ―ndukwin Jesús―. Ja la nsuꞌwi chaꞌ kwiñi ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Mnichaꞌ Natanael ꞌin Jesús bra kanꞌ: ―¿Sa ñaꞌan ngwa, chaꞌ yuꞌwi lyoo ꞌñaǎn a? ―Bra nu ti ji chkwiꞌ Lpe loꞌoo ―ndukwin Jesús―, ti bra kanꞌ naꞌaǎn ꞌiin xa nu nduun kiyaꞌ yka kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","―Mstru ―ndukwin Natanael―, chañi chaꞌ nuꞌwin lkaa ska ti nu lka Sñiꞌ Ndiose, nuꞌwin lkaa ree nu nka ndloo ꞌin neꞌ Israel. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Mxkwen Jesús ꞌin Natanael bra kanꞌ: ―¿Ta ska ti chunꞌ chaꞌ nu wa ykwiǐnꞌ loꞌoo chaꞌ wa naꞌaǎn ꞌiin kiyaꞌ yka kityi kanꞌ, kanꞌ chaꞌ ndyaa ñaꞌan tiiꞌ ꞌñaǎn a? ―ndukwin yu―. Chinꞌ ti chaꞌ lka kanꞌ, chaꞌ tnun la ti ñaꞌaan nde loo la. ");
INSERT INTO ctpNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin yu―. Nde loo la ñaꞌan wan chaꞌ tyukwa laa seꞌen ndiꞌin Ndiose niꞌ kwan. Ka biyaꞌ tiꞌ wan bra kanꞌ chaꞌ wa msuꞌwa Ndiose ꞌñaǎn ndijyaǎn lo chalyuu chaꞌ kaǎn nten. Loꞌo seꞌen tyiꞌiǐn, la kanꞌ ñaꞌan wan ꞌin angajle nu ndiꞌin seꞌen ndiꞌin Ndiose; tyaꞌan angajle kanꞌ, skwen angajle kanꞌ niꞌ kwan, kiꞌya angajle kanꞌ seꞌen tyiꞌiǐn. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Xa wa mdaꞌa snan tsan, ndyaa jyaꞌan Jesús seꞌen kaja kwilyoꞌo neꞌ nde kichen Caná, nde lo yuu ꞌin Galilea. Wa ykwiꞌ neꞌ loꞌo Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, kanꞌ chaꞌ loꞌo neꞌ kanꞌ ndyaa neꞌ taꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Chunꞌ ndiꞌin la ja mjwi ꞌa mñun koꞌo neꞌ nu ndiꞌin taꞌa kanꞌ, mdyii ran. Loꞌo ndyaa jyaꞌan Jesús ndyaa ytsaꞌ ꞌin yu bra kanꞌ: ―Wa mdyii mñun yiꞌo neꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Mxkwen Jesús ꞌin jyaꞌan bra kanꞌ: ―¿Ta tñan ꞌñaǎn lka kwa a? Ti ji tiya bra chaꞌ kwaꞌuǔn tloǔn ꞌin nten ti ka nu lkaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ni siya ngwañaꞌan ykwiꞌ yu, nde ndiya chaꞌ nu ykwiꞌ jyaꞌan yu loꞌo msu bra kanꞌ: ―Kuꞌni wan ñaꞌaan tñan nu kulo yu re ꞌwan ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nde kwa ti nduun skwa katunꞌ tyiꞌa, katunꞌ tnun nu ndyaꞌ loꞌo kee lka kanꞌ. Bra nu wa msaꞌan katunꞌ kanꞌ, nsuꞌwi ni siya tuꞌwa tyii litro, ni siya snan yla tyii litro tyiꞌa, chaꞌ wa lka tñan nu ndiꞌin ꞌin neꞌ judío, chaꞌ nu katen kiyaꞌ neꞌ xa nu sten neꞌ ska niꞌ ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kanꞌ ykwiꞌ Jesús loꞌo msu kanꞌ: ―Kuꞌni xaꞌan wan katunꞌ kwa loꞌo tyiꞌa. Yꞌni xaꞌan msu kanꞌ katunꞌ loꞌo tyiꞌa sa ñaꞌan bra nu msaꞌan ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","―Kulo wan chinꞌ tyiꞌa ―ndukwin Jesús ꞌin msu―. Yaa loꞌo wan ꞌin ran chaꞌ koꞌo nten nu kwa tyi kanꞌ. Ngwañaꞌan yꞌni msu bra kanꞌ, mda neꞌ chinꞌ tyiꞌa koꞌo neꞌ kwa tyi bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Yiꞌo biyaꞌ neꞌ kanꞌ, loꞌo mñun nchka ran. Ja jlyo tiꞌ yu kula kanꞌ nde yaꞌ mdoꞌo mñun kanꞌ, msu ti jlyo tiꞌ chaꞌ tyiꞌa nu ndyaa yꞌya neꞌ tsan lka mñun kanꞌ. Loꞌo msiꞌya neꞌ kwa tyi kanꞌ ꞌin yu nu mjwi kwilyoꞌo, ykwiꞌ yu loꞌo bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","―Xka ta nten ni ―ndukwin yu kula―, xkwiꞌ mñun nu suꞌwe la lka nu nda neꞌ ndiꞌyu nten bra nu mdyisnan ti taꞌa; xa wa ngulaꞌ tiꞌ neꞌ chaꞌ yiꞌo ꞌa neꞌ mñun kanꞌ, bra kanꞌ nda neꞌ mñun nu kuxi la chaꞌ koꞌo neꞌ nu ndiꞌin taꞌa ―ndukwin neꞌ kwa tyi ꞌin yu nu mjwi kwilyoꞌo―. Loꞌo nuꞌwin ni, ni siya wa tyii ti taꞌa, la ni ndaa mñun nu suꞌwe la ti chaꞌ koꞌoan. Suꞌwe ꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kichen Caná nde lo yuu ꞌin Galilea ngwa chaꞌ kanꞌ, bra nu mdyisnan yꞌni Jesús chaꞌ tnun chabiyaꞌ ꞌin Ndiose Sti yu. Loꞌo chaꞌ tnun kanꞌ ngwaꞌu tloo Jesús ꞌin nten, chaꞌ ñaꞌan neꞌ chaꞌ tlyu ꞌa tñan nka yu. Kanꞌ chaꞌ mdyisnan neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, ndyaa ñaꞌan tiꞌ neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa yu kichen Capernaum bra kanꞌ. Ndyaa yu loꞌo jyaꞌan yu, loꞌo yu kiꞌyu taꞌa yu, loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu ndyaa neꞌ. Nganun neꞌ chinꞌ la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wa tiya ti taꞌa pascua ꞌin neꞌ judío, kanꞌ chaꞌ ndyaa Jesús taꞌa Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ndyaa Jesús niꞌ lyaa tnun la kanꞌ, loꞌo naꞌan yu chaꞌ ndiꞌin ꞌa nten ngiꞌni kanan niꞌ lyaa kanꞌ; ndyujwiꞌ ꞌa neꞌ toro, ndyujwiꞌ neꞌ slyaꞌ, ndyujwiꞌ neꞌ kiñi cha kuun chaꞌ ka lomstan ꞌin nten niꞌ lyaa. Kwiꞌ ndiꞌin neꞌ nu ngiꞌni kanan ꞌin nten chaꞌ nu mxaꞌan neꞌ tñi nu nnanjoꞌo ꞌin neꞌ kichen niꞌ lyaa, ndukwa neꞌ kanꞌ tuꞌwa msaa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Loꞌo msñi Jesús ska ti su chaꞌ jwiꞌin yu ꞌin neꞌ nu ngiꞌni kanan kanꞌ, chaꞌ kulo yu ꞌin neꞌ kanꞌ niꞌ lyaa kanꞌ; loꞌo slyaꞌ ꞌin neꞌ, loꞌo toro ꞌin neꞌ, loꞌo nchga yuꞌwa ꞌin neꞌ, ngulo yu ꞌin neꞌ mdoꞌo neꞌ nde chunꞌ laa. Kwiꞌ mxlyuu yu msaa seꞌen ndukwa neꞌ nu mxaꞌan tñi kanꞌ, mxkwan yu tñi ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Lye ykwiꞌ yu loꞌo nten nu ndujwiꞌ kiñi cha kuun bra kanꞌ: ―¡Yaa loꞌo wan ꞌin yuꞌwa kwa nde chunꞌ laa re! ―ndukwin Jesús―. ¡Ja kuꞌni wan chaꞌ ka naꞌan tnun re ꞌin Stiǐn ñaꞌan tiꞌ naꞌan lo kiyaꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Loꞌo ndyuꞌwi tiꞌ neꞌ nu ngiꞌni xaꞌan kanꞌ ska chaꞌ nu ndukwa lo kityi ꞌin Ndiose: “Stiǐn Ndiose, xlyaǎn ꞌaǎn chaꞌ ꞌin naꞌan tyii, chunꞌ ndiya tiǎnꞌ ꞌiin” ndukwin kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Loꞌo msinꞌ ꞌa tiꞌ neꞌ judío bra kanꞌ, kanꞌ chaꞌ mnichaꞌ neꞌ ꞌin Jesús: ―¿Ti ka nu lka nda chabiyaꞌ ꞌiin chaꞌ kuꞌnii ngwañaꞌan a? ―ndukwin neꞌ ꞌin Jesús―. ¿Ni sa ñaꞌan kuꞌnii chaꞌ tsaa ñaꞌan tiꞌ ba ꞌiin? ");
INSERT INTO ctpNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","―Kuꞌni tyii wan naꞌan re ―ndukwin Jesús―, loꞌo chunꞌ snan tsan kwiñaǎn ran xiyaꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","―Tuꞌwa ndukwa skwa yijan mdyii ndyaꞌ laa tnun re ―ndukwin neꞌ ꞌin yu―. ¿Ta ka ꞌiin kwiñaan ran xiyaꞌ chunꞌ snan tsan ti a? ");
INSERT INTO ctpNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Loꞌo siꞌi chaꞌ ꞌin laa tnun ykwiꞌ Jesús, ni siya ykwiꞌ yu ska chaꞌ loꞌo neꞌ nan nu ka ꞌin yu, ti ykwiꞌ ti yu, sa ñaꞌan tyuꞌu yu xiyaꞌ xa nu wa ngujwi yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kanꞌ chaꞌ bra nu wa ndyuꞌu Jesús xiyaꞌ, kanꞌ ndyuꞌwi tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu nchga chaꞌ nu ykwiꞌ yu loꞌo neꞌ tsan kanꞌ; ndyaa ñaꞌan tiꞌ neꞌ chaꞌ kanꞌ, kwiꞌ ndyaa ñaꞌan tiꞌ neꞌ chaꞌ nu ngwaꞌan ayman lo kityi ꞌin Ndiose nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Xa nu mdiꞌin Jesús Jerusalén taꞌa pascua kanꞌ, bra kanꞌ mdyisnan kaꞌan nten ndyaa ñaꞌan tiꞌ neꞌ chaꞌ ꞌin yu, xa wa naꞌan neꞌ nchga chaꞌ tnun nu yꞌni yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ni siya ngwañaꞌan, jlyo tiꞌ Jesús chaꞌ ti ji tsaa ñaꞌan suꞌwe tiꞌ neꞌ ꞌin yu, chaꞌ suꞌwe ꞌa nsuꞌwi lyo yu ꞌin nten, nchga chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin skaa nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ja nꞌni chaꞌ katsaꞌ xka nten ꞌin yu sa ñaꞌan chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin skaa nten, chaꞌ jlyo ꞌa tiꞌ yu, ti ykwiꞌ ti yu, sa ñaꞌan chaꞌ nu nsuꞌwi niꞌ kasiya ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ndiya ska yu kula ꞌin neꞌ judío nu naan Nicodemo, yu fariseo nu lka ndloo la ngwa yu. Loꞌo neꞌ fariseo ni, kti ꞌa ngiꞌni neꞌ, nxkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Bra nu ngwiꞌya tla yaa yu kula kanꞌ seꞌen ndiꞌin Jesús: ―Mstru Jesús ―ndukwin yu―, jlyo tiꞌ nten chaꞌ nuꞌwin lkaa ska mstru nu msuꞌwa Ndiose ꞌiin ndijyaan lo chalyuu, chaꞌ ja ka ꞌiin kuꞌnii skaa chaꞌ tnun si ja loꞌo Ndiose ndayaꞌ ꞌiin. Jlyo tiꞌ ba chaꞌ ja ka ꞌin nten chalyuu kuꞌni neꞌ ngwañaꞌan ―ndukwin Nicodemo ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌoo ni, chaꞌ ngiꞌni Stiǐn Ndiose chaꞌ kala nten xiyaꞌ, xa nu xlyaa neꞌ sten neꞌ chaꞌ ꞌin Ndiose, chaꞌ ka Ni ndloo niꞌ kasiya ꞌin neꞌ ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","―¿Ni sa ñaꞌan ka kalaan xiyaꞌ xa nu wa msuanꞌ? ―ndukwin Nicodemo ꞌin Jesús―. ¿Ta ka stean niꞌ jyaꞌaan xiyaꞌ a?, chaꞌ xiyaꞌ kalaan ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","6","―Chañi chaꞌ nu chkwiǐnꞌ loꞌoo ni ―ndukwin Jesús―. Nten lka nu ndlya xa nu yꞌni kala nten chalyuu ꞌin neꞌ, loꞌo Tyiꞌi Ndiose lka nu ngiꞌni chaꞌ xaꞌan kasiya ꞌin nten ―ndukwin Jesús―. Ndiꞌin chaꞌ ka kwi kasiya ꞌwan si nchka tiꞌ wan chaꞌ kulo Ndiose tñan niꞌ kasiya ꞌwan. Ndiꞌin chaꞌ xuꞌwi wan lo tyiꞌa, kwiꞌ ngwañaꞌan ndiꞌin chaꞌ kanun Tyiꞌi Ndiose niꞌ kasiya ꞌwan ―ndukwin Jesús ꞌin Nicodemo―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ja kuwe ꞌa tiiꞌ ꞌin chaꞌ nu nchkwiǐnꞌ loꞌoo, chaꞌ ndiꞌin chaꞌ kala nten xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Kwiꞌin ni, nskwa kwiꞌin la seꞌen nchka tiꞌ ran; ni siya nganaan chaꞌ nganen nskwa kwiꞌin, ja nchka biyaꞌ tianꞌ la nde mdoꞌo kwiꞌin kanꞌ, la nde tsaa ran bra kanꞌ ―ndukwin Jesús―. Kwiꞌ ngwañaꞌan lka loꞌo Tyiꞌi Ndiose, ja nchka biyaꞌ tiꞌ nten sa ñaꞌan nu ngiꞌni Ndiose chaꞌ ka kwi kasiya ꞌin neꞌ ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","―¿Ni sa ñaꞌan ka chaꞌ kanꞌ ngwañaꞌan a? ―ndukwin Nicodemo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Loꞌo mskwen Jesús ꞌin yu bra kanꞌ: ―¿Ta siꞌi mstru kula ꞌin neꞌ judío lkaa a? ¿Ni chaꞌ lka ja ndiꞌyaa kwenta ꞌin chaꞌ kanꞌ sikwa? ―ndukwin Jesús ꞌin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌoo ni. Nu bare, ñi nchkwiꞌ ba chaꞌ ꞌin ska chaꞌ nu wa jlyo tiꞌ ba, ska chaꞌ nu wa naꞌan ba, loꞌo ja la ndukwa wan chaꞌ nu nchkwiꞌ ba ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ndiya chaꞌ nu nchkwiǐnꞌ loꞌo wan chaꞌ ꞌin chalyuu re, loꞌo ja ndyaa ñaꞌan tiꞌ wan chaꞌ kanꞌ. ¿Ni sa ñaꞌan ka chaꞌ nu tsaa ñaꞌan tiꞌ wan ꞌñaǎn xa nu chkwiǐnꞌ loꞌo wan ska chaꞌ ꞌin Ndiose nu nka ndloo a? ―ndukwin Jesús ꞌin Nicodemo―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ja ya tsaa ska nten niꞌ kwan seꞌen ndiꞌin Ndiose. Skaǎn tiǎn nu msuꞌwa Ndiose ꞌñaǎn ndijyaǎn chaꞌ kaǎn nten, nde kwa mdoꞌoǔn chaꞌ ndijyaǎn lo chalyuu re; nde kwa lka naꞌan tyiǐn. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Xa nu mdiꞌin ayman Moisés lo ntenꞌ wtyi kanꞌ nu ngwa sꞌni, kwan mskwen yu ska kunan chkwan nu ndukwi chunꞌ yka, chaꞌ ñaꞌan nten kunan kanꞌ, chaꞌ chkaa neꞌ nu yku kunan tlá ꞌin ―ndukwin Jesús―. Sa ñaꞌan nu mskwen yu ꞌin kunan chkwan kanꞌ kwan, ngwañaꞌan ndiꞌin chaꞌ skwen neꞌ ꞌñaǎn lo wsi, naꞌ nu ndijyaǎn chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Loꞌo nchga nten nu sten chaꞌ ꞌñaǎn, kaja chalyuu suꞌwe ꞌin neꞌ bra kanꞌ, chalyuu nu ja tsaa tii ꞌa ―ndukwin Jesús ꞌin Nicodemo―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Suꞌwe ꞌa nka tiye Ndiose ñaꞌan Ni ꞌin nten chalyuu, kanꞌ chaꞌ msuꞌwa Ni ꞌñaǎn, skaǎn tiǎn nu lkaǎn Sñiꞌ Ni chaꞌ ndijyaǎn lo chalyuu, chaꞌ ja tsaa ꞌa nten lo jwlyaa xa nu xñi neꞌ chaꞌ ꞌñaǎn; kaja chalyuu suꞌwe ꞌin neꞌ kanꞌ, chalyuu nu ja tsaa tii ꞌa ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wa msuꞌwa Ni ꞌñaǎn ndijyaǎn lo chalyuu chaꞌ suwiǐn kiꞌya nu ndukwi nten chalyuu. Ja nchka tiꞌ Stiǐn Ndiose chaꞌ xkwiꞌ nan xtya Ni kiꞌya ꞌin nten; ja ndijyaǎn lo chalyuu chaꞌ kuꞌniǐn ngwañaꞌan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ja ta ꞌa Ndiose nu tiꞌí ꞌin nten nu xñi chaꞌ ꞌñaǎn, ni siya wa yꞌni biyaꞌ Ni ꞌin nchga nten nu ja xlyaa xñi chaꞌ ꞌñaǎn; ta Ni nu tiꞌí ꞌin neꞌ kanꞌ, chunꞌ ja mslyaa ꞌa neꞌ tsaa ñaꞌan tiꞌ neꞌ ꞌñaǎn chaꞌ lkaǎn skaǎn tiǎn nu lka Sñiꞌ Ndiose ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wa nda Ndiose xaa ndijyan lo chalyuu, loꞌo ja nxlyaa ꞌa nten chalyuu tyiꞌin seꞌen xaa kanꞌ. Nsuꞌwi ꞌa nten nu ndiya la tiꞌ tyiꞌin seꞌen tla, chaꞌ xaꞌan ꞌa tiye neꞌ kanꞌ; kanꞌ chaꞌ nsuꞌwi kiꞌya nu mstya Ndiose ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ja nchka tiꞌ nten xaꞌan chaꞌ ta Ndiose xaa nu xuꞌwi niꞌ kasiya ꞌin neꞌ. Tijyuꞌ ti ndaꞌan neꞌ kanꞌ seꞌen ja ñaꞌan Ni ꞌin neꞌ, nxkeꞌ tiꞌ neꞌ, chaꞌ xkwiꞌ chaꞌ kuxi ngiꞌni neꞌ kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nten nu xñi chaꞌ nu nchkwiꞌ Ndiose loꞌo neꞌ, ta Ndiose xaa nu xuꞌwi niꞌ kasiya ꞌin neꞌ kanꞌ. Ndiꞌin neꞌ seꞌen xaa kanꞌ, chaꞌ ka jlyo tiꞌ xka ta nten chaꞌ ngiꞌni neꞌ kanꞌ nchga tñan nu ndlo Ndiose ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Chunꞌ ndiꞌin la ndyaa Jesús, ndyaa yu loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdiꞌin neꞌ chinꞌ nde lo yuu ꞌin Judea. Mdukwatya Jesús ꞌin nten la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Loꞌo ndiꞌin Xuwa kwiꞌ seꞌen ti, chaꞌ ti ndukwatya yu ꞌin nten; ndiꞌin yu ska seꞌen naan Enón, kwiꞌ seꞌen ti Salim, seꞌen tlya ꞌa tyiꞌa. Kaꞌan ꞌa nten ndaꞌan neꞌ chaꞌ tukwatya yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ti ji suꞌwa neꞌ ꞌin Xuwa kanꞌ niꞌ ñaꞌan chkwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Loꞌo lye ꞌa nxuun neꞌ judío loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Xuwa bra kanꞌ; lye nchkwiꞌ neꞌ loꞌo taꞌa neꞌ sa ñaꞌan nu suꞌwe la kuꞌni neꞌ chaꞌ ka luwi kasiya ꞌin neꞌ chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kanꞌ chaꞌ mdiyan neꞌ seꞌen ndiꞌin Xuwa chaꞌ chkwiꞌ neꞌ loꞌo yu: ―Mstru ―ndukwin neꞌ―, ti kwiꞌ yu nu yaa seꞌen mdiꞌiin xka laꞌa tsuꞌ chku Jordán ti ngwa xkanꞌ, ti kwiꞌ nu ndukwiin chaꞌ ndloo la lka yu, wa ngala yu kanꞌ ndukwatya yu ꞌin nten laꞌa tsuꞌ re ni. Kaꞌan ꞌa nten ndaꞌan seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Loꞌo mxkwen Xuwa ꞌin neꞌ bra kanꞌ: ―Sa kwa ti tñan ka kuꞌni ska nten, sa ñaꞌan nu nda Ndiose chabiyaꞌ kuꞌni neꞌ ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wa ynan wan chaꞌ nu niǐn ꞌwan nu ngwa xkanꞌ, chaꞌ ja lkaǎn Krixtu, nten nu tnun nchka nu wa kan ti lo chalyuu. Wa lka tñan ndiya ꞌñaǎn chaꞌ ndla la mdiyaǎn chaꞌ xñiǐn tuwiin seꞌen kan nu lka Krixtu ―ndukwin Xuwa―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ñaꞌan tiꞌ xa wa mjwi kwilyoꞌo neꞌ, ska ti yu kiꞌyu kanꞌ, kanꞌ nu lka kwilyoꞌo kuxiin; loꞌo taꞌa suꞌwe nsuꞌwi nu kiꞌyu kanꞌ, suꞌwe ꞌa nka tiye yu kunan yu chaꞌ nu nchkwiꞌ yu kanꞌ. Sa ñaꞌan suꞌwe nka tiye taꞌa suꞌwe nsuꞌwi yu ndiꞌin yu xa wa mjwi kwilyoꞌo neꞌ, ngwañaꞌan naꞌ suꞌwe ꞌa nka tiyeěn chaꞌ ñaꞌaǎn ꞌin neꞌ nu nnan chaꞌ nu nduꞌu Jesús ―ndukwin Xuwa―. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kwiꞌ ngwañaꞌan, tiꞌ kwiꞌ yu ka yu tnun la, loꞌo naꞌ ndiꞌin chaꞌ kaǎn nu siyaꞌ la bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ndloo la lka Krixtu chaꞌ mdoꞌo yu niꞌ kwan seꞌen ndiꞌin Ndiose, mdiyan yu lo chalyuu bra kanꞌ. Loꞌo Xuwa ni, sñiꞌ ska nten chalyuu ngwa yu kanꞌ; ndukwa naꞌan tyi yu lo chalyuu. Kwiꞌ ñaꞌan nchkwiꞌ yu, sa ñaꞌan nu nchkwiꞌ nten ti. Nu lka Jesucristo ni, mdoꞌo yu niꞌ kwan seꞌen ndiꞌin Ndiose, ndloo la ti yu kanꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","mduꞌu yu chaꞌ nu ñi ꞌñaan, chaꞌ ꞌin nchga nan nu wa naꞌan yu, nchga chaꞌ nu wa ynan yu la kanꞌ. Loꞌo ja xlyaa ꞌa nten xñi neꞌ chaꞌ nu nchkwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Bra nu xñian chaꞌ nu nchkwiꞌ Jesús, kanꞌ katsaanꞌ ꞌin taꞌaan chaꞌ ñi ꞌa chaꞌ nu nchkwiꞌ Ndiose loꞌoan. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wa msuꞌwa Ndiose ꞌin Jesucristo ndijyan yu lo chalyuu, loꞌo xkwiꞌ chaꞌ ꞌin Ndiose nchkwiꞌ yu loꞌoan chabiyaꞌ ꞌin Tyiꞌi Ndiose nu nsuꞌwi ꞌin yu. Loꞌo Ndiose ni, ja tsaa tii ꞌa chaꞌ nda Ni Tyiꞌi Ni ꞌin Sñiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ndiya ꞌa tiꞌ Ndiose Sti yu ñaꞌan Ni ꞌin Sñiꞌ, ti kwiꞌ Jesús kanꞌ; loꞌo nchga chabiyaꞌ nu ndiya yaꞌ Ndiose, msuꞌwa Ni ꞌin Sñiꞌ Ni chaꞌ ndijyan yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Bra nu xñi nten chaꞌ ꞌin Jesús, chaꞌ nu lka yu Sñiꞌ Ndiose, ja tsaa tii ꞌa chalyuu suꞌwe nu ta Ndiose ꞌin neꞌ kanꞌ. Loꞌo nten nu ja xlyaa tukwa chaꞌ nu nchkwiꞌ Jesús, ja ta ꞌa Ndiose chalyuu suꞌwe kanꞌ ꞌin neꞌ; ndiꞌin chaꞌ lye ta Ni nu tiꞌí ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Chunꞌ ndiꞌin la ynan neꞌ fariseo, ngwa biyaꞌ tiꞌ neꞌ chaꞌ kaꞌan la nten ndaꞌan loꞌo Jesús chaꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌin yu bra kanꞌ, kwiꞌ ndukwatya yu ꞌin neꞌ; chinꞌ la nten ndiꞌin nu ngiꞌni xaꞌan ꞌin Xuwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Loꞌo siꞌi ti kwiꞌ Jesús nu ndukwatya ꞌin nten; yu kuneꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, kanꞌ lka nu ndukwatya ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Bra nu ngwa biyaꞌ tiꞌ Jesús chaꞌ wa ynan neꞌ fariseo chaꞌ kanꞌ, mdoꞌo yu lo yuu ꞌin Judea bra kanꞌ, ndyaa yu la lo yuu ꞌin Galilea kanꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Kanꞌ chaꞌ ndyaa Jesús tuwiin, mdijin yu lo yuu ꞌin Samaria. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Kanꞌ mdiyan yu kichen Sicar, ska kichen seꞌen ndiꞌin neꞌ Samaria. Ndiya kichen kanꞌ lo yuu nu wa mda ayman Jacob ꞌin ayman Se sñiꞌ yu nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nde kwa ndiya ska tu tiyuu nu ndukwin neꞌ chaꞌ chku ꞌin ayman Jacob lka kanꞌ. Wa ndla ti ka ndiꞌya kwan ngwa bra kanꞌ, kwiꞌ ngwa tñaꞌ ꞌa Jesús tuwiin; kanꞌ chaꞌ ndyaa tukwa yu tuꞌwa chku kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Wa ndyaa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu lo kichen, ndyaa siꞌi neꞌ nan ku neꞌ. Chunꞌ ndiꞌin la yan ska nu kunaꞌan neꞌ Samaria, mdiyan yꞌya tyiꞌa bra kanꞌ. ―¿Ja taa chinꞌ tyiꞌa koꞌoǔn a? ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","―Kwiꞌ neꞌ judío lka nuꞌwin ―ndukwin nu kunaꞌan kanꞌ―, loꞌo naꞌ lkaǎn neꞌ Samaria. ¿Ni chaꞌ lka njñaan tyiꞌa koꞌoo ꞌñaǎn? ―ndukwin nu kunaꞌan kanꞌ. (Ngwañaꞌan ndukwin chaꞌ ja suꞌwe nsuꞌwi neꞌ Samaria loꞌo neꞌ judío bra kanꞌ.) ");
INSERT INTO ctpNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Loꞌo mxkwen Jesús ꞌin nu kunaꞌan kanꞌ: ―¿Ja jlyo tiiꞌ nchga chaꞌ suꞌwe nu nda Ndiose ꞌin nten a? ―ndukwin Jesús―. Si jlyo tiiꞌ ti ka nu lka nu njñan tyiꞌa koꞌo ꞌiin, ja chan nuꞌwin chkwiiꞌ loꞌoǔn chaꞌ taǎn tyiꞌa koꞌoo bra kanꞌ ―ndukwin yu―, loꞌo taǎn tyiꞌa koꞌoo nu chañi kuꞌni kuꞌu kasiya ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","―Neꞌ kula ―ndukwin nu kunaꞌan kanꞌ ꞌin Jesús―, kiꞌñi ꞌa chku tiyuu re; loꞌo ja loꞌo balde ꞌiin ―ndukwin―. ¿Ni sa ñaꞌan ka kuloo tyiꞌa chaꞌ kuꞌni kuꞌu ꞌñaǎn a? ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ta kaꞌan la nsuꞌwi lyo nuꞌwin ke ayman Jacob ꞌñaan nu nda chku tiyuu re ꞌwa a? ―ndukwin―. Yiꞌo ayman kanꞌ tyiꞌa chku re, kwiꞌ ngwañaꞌan yiꞌo sñiꞌ yu, loꞌo skunꞌ neꞌ yiꞌo tyiꞌa re. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","―Bra nu koꞌo nten tyiꞌa chku re ―ndukwin Jesús―, xiyaꞌ kityi tiꞌ neꞌ chunꞌ ndiꞌin la ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Loꞌo ni, xa nu koꞌo neꞌ tyiꞌa nu taǎn, ja kityi ꞌa tiꞌ neꞌ xiyaꞌ bra kanꞌ ―ndukwin―. Taǎn ska lo tyiꞌa koꞌo neꞌ nu kuꞌni kuꞌu kasiya ꞌin neꞌ. Sa ñaꞌan lka si tyukwa tyiꞌa niꞌ kasiya ꞌin neꞌ, ngwañaꞌan lka chaꞌ kanꞌ, loꞌo ja tsaa tii ꞌa chalyuu nu taǎn ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mxkwen nu kunaꞌan kanꞌ ꞌin Jesús bra kanꞌ: ―Taa lyaa tyiꞌa kanꞌ koꞌoǔn, neꞌ kula ―ndukwin―, chaꞌ ja kityi ꞌa tiǎnꞌ xiyaꞌ, chaꞌ ja ka ꞌa tlyu tñan ꞌñaǎn kan yꞌyaǎn tyiꞌa nde re. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Loꞌo ykwiꞌ Jesús loꞌo nu kunaꞌan kanꞌ bra kanꞌ: ―Yaa lyaa yaa tiꞌin ꞌin kwilyoꞌoo chaꞌ kan yu nde re. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","―Ja ndiya kwilyoꞌoǔn ―ndukwin nu kunaꞌan kanꞌ bra kanꞌ. ―Ñi ꞌa chaꞌ ykwiiꞌ loꞌoǔn chaꞌ ja ndiya kwilyoꞌoo ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Wa kiꞌyu yaꞌ mjwi kwilyoꞌoo nu ngwa sꞌni, loꞌo siꞌi kwilyoꞌoo lka nu kiꞌyu nu ndiꞌin loꞌoo ni ―ndukwin yu―. Ñi ꞌa chaꞌ ykwiiꞌ loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","―Neꞌ kula ―ndukwin nu kunaꞌan kanꞌ―, ngwa biyaꞌ tiǎnꞌ ni, chaꞌ ndiꞌin ꞌa chaꞌ tiya ꞌiin, chaꞌ nuꞌwin lkaa ska nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kiꞌya kwan kwa ni, kti ꞌa kiꞌya kwan kwa ꞌin nu ngwa ayman ꞌwa ti sꞌni, chaꞌ nde kwa yꞌni tnun ayman kanꞌ ꞌin Ndiose; loꞌo xka chaꞌ ndaꞌan tiye wan neꞌ judío, chaꞌ ndukwin wan chaꞌ ndiꞌin chaꞌ kuꞌni tnuan ꞌin Ndiose ska ti niꞌ lyaa tnun nu ndukwa Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","―Kunaan suꞌwe chaꞌ nchkwiǐnꞌ ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ―. Wa tiya ti bra chaꞌ ja kuꞌni tnun ꞌa wan ꞌin Ndiose lo kiꞌya kti kwa, kwiꞌ ja kuꞌni tnun ꞌa wan ꞌin Ni la kichen Jerusalén ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ꞌWan neꞌ Samaria ni, xa nu ngiꞌni tnun wan ꞌin Ndiose, ja nsuꞌwi lyo wan nan nu ngiꞌni tnun wan; neꞌ judío bare, nsuꞌwi lyo ba nan nu ngiꞌni tnun ba, chaꞌ ska neꞌ kichen tyi ba lka nten tnun nu kulaa ꞌin nchga nten ꞌin chaꞌ xaꞌan ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wa tiya ti bra, ti kwiꞌ bra nu ni lka, chaꞌ kuꞌni tnun nten ꞌin Ndiose tyukwi ti tiye neꞌ. Loꞌo Tyiꞌi Ndiose suꞌwa yaꞌ Ni ꞌin neꞌ bra kanꞌ, chaꞌ ngwañaꞌan nchka tiꞌ Ndiose chaꞌ ka xa nu kuꞌni tnun nten ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ja ka ñaꞌan nten ꞌin Ndiose; nchga tsan ngiꞌni Tyiꞌi Ni tñan lo chalyuu, ni siya ja nchka ñaꞌan nten ꞌin Ni. Ngwañaꞌan lka Ndiose. Loꞌo nten nu chañi chaꞌ nchka tiꞌ kuꞌni tnun ꞌin Ni, ndiꞌin chaꞌ kuꞌni tnun neꞌ ꞌin Ni tyukwi ti tiye neꞌ; loꞌo Tyiꞌi Ndiose suꞌwa yaꞌ Ni ꞌin neꞌ kanꞌ chaꞌ kuꞌni tnun neꞌ ꞌin Ni bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Xiyaꞌ ykwiꞌ nu kunaꞌan kanꞌ loꞌo Jesús bra kanꞌ: ―Ndiꞌyaǎn kwenta chaꞌ wa kan ti ska nten nu tnun chka, kwiꞌ nu suꞌwa Ndiose ꞌin chaꞌ kan lo chalyuu; Krixtu ka naan yu kanꞌ ―ndukwin―. Bra nu kan yu kanꞌ, kwaꞌu ñi yu nchga chaꞌ tukwi ꞌñaan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Mxkwen Jesús ꞌin nu kunaꞌan kanꞌ bra kanꞌ: ―Ti kwiǐnꞌ lkaǎn nu nchkwiǐnꞌ loꞌoo ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ti kwiꞌ bra kanꞌ ngala neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu xiyaꞌ, nduwe ꞌa tiꞌ neꞌ chaꞌ ndukwa Jesús nchkwiꞌ loꞌo nu kunaꞌan kanꞌ. Loꞌo ja mnichaꞌ neꞌ ꞌin yu kula kanꞌ: ni nan lka nchka tiꞌ nu kunaꞌan kanꞌ loꞌo yu, ni sa ñaꞌan chaꞌ nchkwiꞌ yu loꞌo nu kunaꞌan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Loꞌo mstya nu kunaꞌan kanꞌ teꞌén tyiꞌa lo yuu bra kanꞌ, mdoꞌo ndyaa lo kichen; ndyaa ytsaꞌ ꞌin nten kichen chaꞌ tsaa naꞌan neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Nde kwa ti nduun ska nten nu nsuꞌwi ꞌa chaꞌ tiya ꞌin ―ndukwin nu kunaꞌan kanꞌ―. Nchga lo tñan nu yꞌniǐn bra nu mdiyaǎn lo chalyuu, nchga chaꞌ kanꞌ wa ytsaꞌ yu kula kanꞌ ꞌñaǎn. ¿Ta siꞌi yu kanꞌ lka Krixtu, nten nu tnun nchka nu wa kan ti, xkeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Bra ti mdoꞌo nten kichen ndyaa seꞌen ndukwa Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ti ji tiya neꞌ kanꞌ seꞌen ndukwa Jesús, loꞌo tꞌnan nchkwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo yu chaꞌ ku yu chinꞌ tyaja. ―Mstru ―ndukwin neꞌ―, ¿ja kuu chinꞌ ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","―Wa ngulaꞌ tiǎnꞌ ―ndukwin Jesús bra kanꞌ―. Wa ndiya chinꞌ nan ykuǔn re loꞌo ja nsuꞌwi lyo wan ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ykwiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu loꞌo taꞌa neꞌ bra kanꞌ: ―¿Ta wa yan loꞌo neꞌ nan yku yu a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Loꞌo ykwiꞌ Jesús loꞌo neꞌ kanꞌ xiyaꞌ bra kanꞌ: ―Bra nu ngiꞌniǐn tñan ꞌin Stiǐn Ndiose, ngulaꞌ tiǎnꞌ sa ñaꞌan si wa ykuǔn tyija, sa ñaꞌan si wa yiꞌoǔn tyiꞌa ―ndukwin yu bra kanꞌ―. Ndiꞌin chaꞌ kuꞌni tyiǐn tñan nu mda Stiǐn ꞌñaǎn chaꞌ nu ndijyaǎn lo chalyuu ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Xa wa mdaꞌa jakwa koꞌ, bra kanꞌ kuꞌni neꞌ kwa.” ¿Ta kwiñi chaꞌ nchkwiꞌ nten ngwañaꞌan a? ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. Xka chaꞌ chkwiǐnꞌ loꞌo wan ni, chaꞌ ñaꞌan wan chinꞌ ꞌin nten kaꞌan kwa nu ndijyan seꞌen ndiꞌian ―ndukwin yu―. Nchka ꞌa tiꞌ neꞌ kanꞌ kunan neꞌ chaꞌ nu chkwiǐnꞌ loꞌo neꞌ. Ñaꞌan tiꞌ ska jyan nu suꞌwe ꞌa ngutsi, chaꞌ ndla ti ka kwa ꞌin ran, ngwañaꞌan lka nten kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kaja siyaꞌ msu ꞌñaǎn nu kuꞌni kwa kanꞌ, loꞌo ja tsaa tii ꞌa tñan nu yꞌni msu kanꞌ. Chunꞌ ndiꞌin la suꞌwa ti ka suꞌwe ka tiye taꞌa tyukwaa ta nten re ꞌñaǎn: loꞌo neꞌ nu nsnen chaꞌ suꞌwe ꞌin Ndiose seꞌen ndiꞌin nchga nten, loꞌo neꞌ nu ñaꞌan sa ñaꞌan wa yten nten chalyuu chaꞌ ꞌin Ndiose ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Chañi lka chaꞌ nu nchkwiꞌ nten: “Ska ta lka yu nu ntya nskwaꞌ, xka ta lka yu nu nxtun tya.” ");
INSERT INTO ctpNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nu ꞌwan ni, wa nguloǔn tñan ꞌwan ―ndukwin Jesús―, chaꞌ tsaa wan kuꞌni tyii wan ska tñan nu ja ya kuꞌni wan, chaꞌ kan loꞌo wan ꞌin nten seꞌen ndiꞌiǐn, nchga nten nu nchka tiꞌ sten chaꞌ ꞌñaǎn. Xka ta nten wa yꞌni tñan kanꞌ kulo ndukwa la, loꞌo ni ñaꞌan wan sa ñaꞌan tsaa toꞌo tñan nu yꞌni neꞌ ti bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Loꞌo tyun neꞌ Samaria, neꞌ kwa tyi ni, msñi neꞌ chaꞌ ꞌin Jesús chunꞌ chaꞌ nu ytsaꞌ nu kunaꞌan kanꞌ ꞌin neꞌ: “Nchga chaꞌ kuxi nu yꞌniǐn ti bra nu mdiyaǎn lo chalyuu sa la ni, nchga chaꞌ kanꞌ ykwiꞌ yu kula kanꞌ loꞌoǔn” ndukwin nu kunaꞌan kanꞌ ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kanꞌ mdiyan neꞌ kanꞌ seꞌen ndiꞌin Jesús, lye ꞌa ykwiꞌ neꞌ loꞌo Jesús chaꞌ ti kanun la yu chinꞌ kichen tyi neꞌ. Kanꞌ chaꞌ nganun Jesús tukwa tsan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Bra wa ynan la neꞌ chaꞌ nu ngwaꞌu Jesús ꞌin neꞌ, kaꞌan la nten msñi chaꞌ nu nchkwiꞌ yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kanꞌ ykwiꞌ neꞌ loꞌo nu kunaꞌan kanꞌ: ―Siꞌi chunꞌ chaꞌ ykwiꞌ nuꞌwin msñi ba chaꞌ ꞌin yu ni; ti ykwiꞌ ti yu, ykwiꞌ yu loꞌo ba, kanꞌ chaꞌ ndyaa ñaꞌan tiꞌ ba chaꞌ nu ykwiꞌ yu. Ndiꞌya ba kwenta chaꞌ chañi chaꞌ yu kula re lka Krixtu, nten nu tnun nchka nu wa mdiyan chaꞌ kulaa ꞌin nchga nten chalyuu ꞌin chaꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Xa wa mdijin tukwa tsan kanꞌ, mdoꞌo Jesús lo yuu nu kwenta ꞌin Samaria, ti ndyaa la yu lo yuu ꞌin Galilea bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wa ndukwin yu chaꞌ ja nnan nten chaꞌ nu nchkwiꞌ ska nten nu lka taꞌa kichen tyi neꞌ, xa nu nchkwiꞌ neꞌ kanꞌ chaꞌ ꞌin Ndiose loꞌo neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Xa wa mdiyan yu lo yuu kanꞌ, suꞌwe ꞌa ykwiꞌ neꞌ Galilea loꞌo yu. Wa naꞌan neꞌ kanꞌ nchga chaꞌ tnun nu yꞌni Jesús xa nu yaa yu taꞌa kichen Jerusalén, chaꞌ loꞌo neꞌ kanꞌ yaa neꞌ taꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chunꞌ ndiꞌin la mdiyan Jesús kichen Caná nde lo yuu ꞌin Galilea xiyaꞌ; kichen kanꞌ ngwa seꞌen ngwiñan Jesús mñun loꞌo tyiꞌa ti, chaꞌ yiꞌo neꞌ nu mdiꞌin taꞌa kanꞌ. Ndiya ska yu kula nu ndiꞌya tñan tnun ꞌin ree, tiꞌí ꞌa sñiꞌ yu nskwa naꞌan tyi yu nde kichen Capernaum. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Bra nu ynan yu nu lka tñan kanꞌ, chaꞌ mdoꞌo Jesús yuu nu kwenta ꞌin Judea, mdiyan yu lo yuu ꞌin Galilea, kanꞌ ndyaa yu kula kanꞌ seꞌen ndiꞌin Jesús. Mjñan ꞌa yu kula chaꞌ tlyu tiꞌ ꞌin Jesús chaꞌ tsaa yu kichen tyi yu kula kanꞌ, chaꞌ tsaa yu kuꞌni yu joꞌó ꞌin sñiꞌ yu kanꞌ chaꞌ wa kaja ti sñiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","―¿Ni ñaꞌan bra tsaa ñaꞌan tiꞌ wan ꞌin Ndiose a? ―ndukwin Jesús ꞌin yu kula kanꞌ bra kanꞌ―. Jlyo tiǎnꞌ chaꞌ ja tsaa ñaꞌan tiꞌ wan ꞌin Ndiose chaꞌ ka kuꞌni Ni nchga tñan, ni siya kuꞌniǐn ska chaꞌ tnun chaꞌ ñaꞌan kwiꞌya wan ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","―Yu kula ―ndukwin yu nu lka tñan kanꞌ ꞌin Jesús―, kuꞌnii chaꞌ suꞌwe tsaa naꞌan tyiǐn ni, xa nu ti ji kaja sñiěnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","―Tyaa lyaa naꞌan tyii ni ―ndukwin Jesús ꞌin yu―, chkaa sñiiꞌ, ja kaja yu kanꞌ. Ndyaa ñaꞌan tiꞌ yu nu lka tñan kanꞌ chaꞌ nu ykwiꞌ Jesús loꞌo yu bra kanꞌ. Bra ti mdoꞌo yu kula kanꞌ ndyaa yu kichen tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tuwiin kanꞌ seꞌen ndyaan yu, ndyukwa taꞌa yu loꞌo msu ꞌin yu: ―Ti luꞌu sñiiꞌ, yu kula ―ndukwin msu ꞌin yu―. Ja kaja ꞌa yu ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","―¿Ni ñaꞌan bra mdyisnan nchkaa sñiěnꞌ a? ―ndukwin yu nu lka tñan kanꞌ ꞌin msu ꞌin yu bra kanꞌ. ―Ti kaa, bra wa ska siin, bra kanꞌ mdoꞌo tikeeꞌ ꞌin yu ―ndukwin msu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Bra ti ngwa biyaꞌ tiꞌ sti yu nu ngwa tiꞌí kanꞌ, chaꞌ ti kwiꞌ bra nu ykwiꞌ Jesús loꞌo yu chaꞌ chkaa sñiꞌ yu, ti kwiꞌ bra kanꞌ nchkaa sñiꞌ yu. Ndyaa ñaꞌan tiꞌ yu kula kanꞌ ꞌin Jesús bra kanꞌ, kwiꞌ ngwañaꞌan ndyaa ñaꞌan tiꞌ nchga nten nu ndiꞌin naꞌan tyi yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wa ngwa tukwa chaꞌ tnun nu yꞌni Jesús chabiyaꞌ ꞌin Ndiose nde lo yuu ꞌin Galilea kanꞌ, xa nu wa mdoꞌo yu Judea mdiyan yu nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","La xka yijan bra nu ngwa taꞌa ꞌin neꞌ judío nde Jerusalén, xiyaꞌ ndyaa Jesús taꞌa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kichen Jerusalén, kanꞌ ndiya ska tuloꞌoo kichen seꞌen naan Tuloꞌoo ꞌin Slyaꞌ. La kanꞌ ndiya ska tiyuꞌ lyuꞌ ti, kwiꞌ Betzaa naan tiyuꞌ kanꞌ, chaꞌ nchkwiꞌ neꞌ judío lka chaꞌ kanꞌ. Nchga laꞌa tsuꞌ tuꞌwa tiyuꞌ lyuꞌ ti kanꞌ ndukwi kaꞌyu corredor, ");
INSERT INTO ctpNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","seꞌen ndiꞌin kaꞌan ꞌa nu tiꞌí: nu kwityiinꞌ, nu chkuꞌ kiyaꞌ, nu nchkunꞌ tyukwin. Ndiꞌin neꞌ la kanꞌ ngita neꞌ chaꞌ kiñan lo tyiꞌa tiyuꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ndyaa ñaꞌan ꞌa tiꞌ neꞌ kichen ꞌin tyiꞌa kanꞌ, chaꞌ xꞌni ndyukwi ndiꞌya ska angajle ꞌin Ndiose nu mdoꞌo niꞌ kwan, ndyaa lo tyiꞌa tiyuꞌ kanꞌ, chaꞌ xñan lo ran. Loꞌo nu tiꞌí nu ndyaa chaꞌ kata chku kulo ndukwa la xa nu tka mñan ti tyiꞌa, kanꞌ lka nu chkaa ꞌin ya ñaꞌan ti kicha nu nsuꞌwi ꞌin, ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wa nskwa ska nten nu tiꞌí kiyaꞌ nde kwa; wa kalatyii ndukwa snuꞌ yijan nskwa yu tiꞌí yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Bra nu naꞌan Jesús ꞌin nu tiꞌí kanꞌ seꞌen nskwa yu, ngwa biyaꞌ tiꞌ Jesús chaꞌ sꞌni nskwa yu bra kanꞌ. Mnichaꞌ Jesús ꞌin nu tiꞌí bra kanꞌ si chañi chaꞌ nchka tiꞌ yu chkaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","―Yu kula ―ndukwin yu ꞌin Jesús―, ja tukwin ndiya ꞌñaǎn nu ka tayaꞌ chinꞌ ꞌñaǎn chaꞌ tsaa loꞌo ꞌñaǎn tuꞌwa tyiꞌa bra nu kiñan lo ran. Tka mdyituun tiǎn loꞌo ndla la ndyaa xka nten lo tiyuꞌ kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","―Tyituun lyaa ni ―ndukwin Jesús bra kanꞌ―, xkuunꞌ lyaa teꞌ kwa ꞌiin loꞌo jaaꞌ kwa, tyaa loꞌoo ꞌin ran naꞌan tyii. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Loꞌo ngwañaꞌan ngwa, bra ti nchkaa nu tiꞌí kanꞌ. Ti kwiꞌ bra kanꞌ mdyisnan yu ndaꞌan yu, ndyaa loꞌo yu jaaꞌ ꞌin yu. Tsan saru ngwa bra kanꞌ. Kti ꞌa tsan kanꞌ chaꞌ ꞌin neꞌ judío, ja ngiꞌni ꞌa neꞌ tñan tsan kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Kanꞌ chaꞌ ykwiꞌ neꞌ judío loꞌo nu ngwa tiꞌí kanꞌ tuwiin: ―Tsan nu nxitñaꞌ nten lka ni ―ndukwin neꞌ kanꞌ ꞌin yu ―. Ja nsuꞌwi ꞌa chabiyaꞌ ꞌiin chaꞌ tyaꞌan loꞌoo jaaꞌ kwa ꞌiin ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Mxkwen nu ngwa tiꞌí kanꞌ ꞌin neꞌ bra kanꞌ: ―Nu yꞌni joꞌó ꞌñaǎn, kanꞌ lka nu ngulo tñan ꞌñaǎn chaꞌ tyaa loꞌoǔn jaaꞌ re tuꞌ naꞌan tyiǐn bra kanꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","―¿Ti ka nu lka ngulo tñan ꞌiin chaꞌ tyaa loꞌoo jaaꞌ kwa ꞌiin a? ―ndukwin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ja jlyo tiꞌ nu ngwa tiꞌí kiyaꞌ kanꞌ sa ñaꞌan naan nu wa yꞌni joꞌó ꞌin. Kaꞌan ꞌa nten ndiꞌin nde kwa, loꞌo ja tukwin naꞌan ꞌin Jesús bra nu mdoꞌo yu ndyaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Xa wa msiin la, xiyaꞌ mdukwa taꞌa Jesús loꞌo nu ngwa tiꞌí kanꞌ bra nu mdaꞌan yu niꞌ lyaa. Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Wa nchkaa ni ―ndukwin ꞌin yu―, kanꞌ chaꞌ kulaa yaꞌ chaꞌ kuxi kwa ꞌiin chaꞌ ja tyukwa ꞌaa xka chaꞌ tnun la. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndyaa nu ngwa tiꞌí kanꞌ bra kanꞌ, ndyaa ytsaꞌ yu ꞌin neꞌ judío kanꞌ, chaꞌ Jesús lka nu yꞌni chaꞌ nchkaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kanꞌ chaꞌ msinꞌ ꞌa tiꞌ neꞌ judío kanꞌ ꞌin Jesús, chaꞌ yꞌni Jesús chaꞌ tnun loꞌo nu tiꞌí kanꞌ tsan taꞌa nu nxitñaꞌ neꞌ. Mdyisnan neꞌ kanꞌ yꞌni liyeꞌ tiꞌ neꞌ ꞌin yu, ngwa tiꞌ neꞌ kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Ti ji tyii kuꞌni Stiǐn tñan ―ndukwin Jesús―, kwiꞌ ngwañaꞌan naꞌ, ti ngiꞌniǐn tñan. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kanꞌ chaꞌ chen ꞌa nka tiye neꞌ judío kanꞌ ñaꞌan neꞌ ꞌin Jesús, nsuꞌwi ꞌa neꞌ kanꞌ nu nchka tiꞌ kujwi ꞌin Jesús bra kanꞌ. Tiꞌí tiꞌ neꞌ kanꞌ ꞌin yu, chaꞌ yꞌni yu tñan tsan taꞌa ꞌin neꞌ, ndukwin neꞌ. Ja ndiya tiꞌ neꞌ siyaꞌ ti chaꞌ ndukwin Jesús chaꞌ Ndiose lka Sti yu, chaꞌ suꞌwa ti ngiꞌni yu loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Loꞌo mxkwen Jesús ꞌin neꞌ judío bra kanꞌ: ―Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni ―ndukwin yu―. Ja ska tñan ka kuꞌniǐn ti ykwiǐnꞌ tiǎn, skaǎn tiǎn nu lkaǎn Sñiꞌ Ndiose. Ti kwiꞌ tñan nu naꞌaǎn chaꞌ ngiꞌni Stiǐn, ti kwiꞌ tñan kanꞌ ngiꞌniǐn nde re ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Stiǐn ni, suꞌwe ꞌa nka tiye Ni ñaꞌan Ni ꞌñaǎn, chaꞌ Sñiꞌ Ni lkaǎn ―ndukwin Jesús―. Nchga tñan nu ngiꞌni Stiǐn, nduꞌu Ni ꞌñaǎn. Loꞌo ti kuꞌni la Stiǐn Ndiose chaꞌ tnun nu ja ya ñaꞌan wan, chaꞌ kuwe ꞌa tiꞌ wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ti ta Ndiose chalyuu ꞌin nten xiyaꞌ, nchga nten nu nchka tiꞌ Ni chaꞌ ta Ni chalyuu ꞌin; loꞌo ti kwiꞌ tñan ngiꞌniǐn, naꞌ nu lkaǎn Sñiꞌ Ndiose, taǎn xka chalyuu ꞌin nchga nten nu nchka tiǎnꞌ taǎn ran ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ja ngiꞌni biyaꞌ Stiǐn ꞌin nten chalyuu; wa mda Ni chabiyaꞌ ꞌñaǎn, chaꞌ Sñiꞌ Ni lkaǎn, chaꞌ kuꞌni biyaǎnꞌ ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nchka tiꞌ Ni chaꞌ kuꞌni tnun nchga nten ꞌñaǎn, sa ñaꞌan nu ngiꞌni tnun neꞌ ꞌin ti kwiꞌ Ni. Xa nu ja xlyaa nten kuꞌni tnun ꞌñaǎn chaꞌ nu lkaǎn Sñiꞌ Ni, kwiꞌ ngwañaꞌan ja ka kuꞌni tnun neꞌ ꞌin Ni nu msuꞌwa ꞌñaǎn ndijyaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni: Nchga nten nu kunan chaꞌ nu chkwiǐnꞌ loꞌo neꞌ, nchga nten nu tsaa ñaꞌan tiꞌ ꞌin Stiǐn Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn lo chalyuu, ja tsaa tii ꞌa chalyuu kwi nu ta Ndiose ꞌin neꞌ kanꞌ. Ja kuꞌni biyaꞌ Ni ꞌin neꞌ kanꞌ, chaꞌ ja ndiꞌin ꞌa chaꞌ kaja neꞌ kanꞌ; nchga bra tyiꞌin neꞌ kanꞌ loꞌo Ni ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kwiꞌ ngwañaꞌan, chañi ꞌa xka chaꞌ nu chkwiǐnꞌ loꞌo wan ―ndukwin yu―. Ndla ti tiya tsan, loꞌo wa mdiya ti kwiꞌ tyempu ni, chaꞌ naꞌ nu lkaǎn Sñiꞌ Ndiose siꞌyaǎn ꞌin nchga nten nu ndiꞌin lo chalyuu; ndiꞌin neꞌ sa ñaꞌan lka si wa ngujwi neꞌ siꞌya nchga chaꞌ xaꞌan nu nsuꞌwi tiye neꞌ. Bra nu kunan nten chaꞌ nu chkwiǐnꞌ loꞌo, kaja chalyuu suꞌwe ꞌin neꞌ, nchga nten nu xñi chaꞌ ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nchka ꞌin Stiǐn Ndiose kuꞌni Ni chaꞌ xaꞌan kasiya ꞌin neꞌ kuxi, nchka ꞌin Ni ta Ni chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ. Suꞌwa ndiꞌin chaꞌ ꞌñaǎn loꞌo Stiǐn, chaꞌ wa mda Stiǐn chabiyaꞌ chaꞌ kuꞌniǐn ngwañaꞌan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kwiꞌ ngwañaꞌan, ndiya chabiyaꞌ ꞌñaǎn chaꞌ kuꞌni biyaǎnꞌ ꞌin nten chalyuu, chunꞌ wa ndijyaǎn lo chalyuu chaꞌ kaǎn nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ja kuwe ꞌa tiꞌ wan; chañi tiya bra nu kanen xiꞌya Stiǐn Ndiose ꞌin nchga ayman seꞌen mtsiꞌ neꞌ. Kunan neꞌ kanꞌ chaꞌ nu chkwiꞌ Ni bra kanꞌ, tyoꞌo neꞌ niꞌ kwaa, tsaa neꞌ la seꞌen ndiꞌin chaꞌ tsaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nten nu ngwa suꞌwe kasiya ꞌin ni, tyuꞌu neꞌ xiyaꞌ, tyaa neꞌ tyiꞌin neꞌ loꞌo Ndiose; nten nu ndiya chaꞌ xaꞌan ꞌin, tyuꞌu neꞌ kanꞌ xiyaꞌ, tsaa neꞌ kanꞌ seꞌen ta Ndiose nu tiꞌí ꞌin neꞌ, seꞌen nu tsaa tii chaꞌ ꞌin neꞌ siyaꞌ ti ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Ja ska tñan ka ꞌñaǎn si skaǎn tiǎn ―ndukwin Jesús―. Bra nu ngiꞌni biyaǎnꞌ ꞌin nten, ngiꞌniǐn sa ñaꞌan nu nchkwiꞌ Stiǐn loꞌoǔn chaꞌ kuꞌniǐn. Suꞌwa ngiꞌni biyaǎnꞌ ꞌin nchga nten, chaꞌ ngiꞌniǐn sa ñaꞌan nu nchka tiꞌ Stiǐn nu ngwaꞌan tñan ꞌñaǎn chaꞌ ndijyaǎn lo chalyuu; ja ngiꞌniǐn ska chaꞌ nu ngulo keěn ti ykwiǐnꞌ tiǎn ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Siꞌi chaꞌ nu ndloǔn keěn tiǎn lka chaꞌ nu nchkwiǐnꞌ loꞌo wan. Ja tsaa ñaꞌan tiꞌ xka ta nten ꞌñaǎn si ngwañaꞌan ti chkwiǐnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ndiya xka nu jlyo tiꞌ chaꞌ nchkwiǐnꞌ xkwiꞌ chaꞌ nu ñi, kwiꞌ jlyo tiǎnꞌ chaꞌ xkwiꞌ chaꞌ nu ñi nchkwiꞌ Ni kanꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Wa msuꞌwa wan nten nu yaa seꞌen ndiꞌin Xuwa kanꞌ, loꞌo chañi ꞌa chaꞌ nu ykwiꞌ Xuwa loꞌo neꞌ kanꞌ chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ja ndiꞌin chaꞌ kaja xka nu chkwiꞌ chaꞌ nu ñi chaꞌ ꞌñaǎn. Nchkwiǐnꞌ chaꞌ re loꞌo wan chaꞌ kaja ñaꞌan lyaa wan ꞌin chaꞌ kuxi kanꞌ ꞌwan, bra nu ka biyaꞌ chaꞌ ꞌwan tloo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Xuwa kanꞌ ni ―ndukwin Jesús bra kanꞌ―, ykwiꞌ yu chaꞌ ꞌñaǎn loꞌo nten sa ñaꞌan si lka yu ska xaa nu ndyuwi ꞌa, nu nda xaa nchga seꞌen ndiꞌin nten. Suꞌwe ꞌa nka tiye wan xa nu ykwiꞌ Xuwa loꞌo wan bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Loꞌo chinꞌ ꞌa chaꞌ ꞌñaǎn ykwiꞌ Xuwa loꞌo wan; wa kaꞌan la chaꞌ ñaꞌan wan ni, chunꞌ chaꞌ mdiyaǎn lo chalyuu, xa nu ñaꞌan wan tñan tnun nu ngulo Stiǐn ꞌñaǎn chaꞌ kuꞌniǐn. Ti kuꞌniǐn tñan kanꞌ sa ñaꞌan yaꞌ tyii ran. Loꞌo tñan kanꞌ ka jlyo tiꞌ wan chaꞌ Stiǐn lka nu ngulo tñan ꞌñaǎn chaꞌ mdiyaǎn lo chalyuu re ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kwiꞌ ngwañaꞌan, ngwaꞌu ñi Stiǐn chaꞌ ꞌñaǎn ꞌwan, chaꞌ ti kwiꞌ Stiǐn lka nu ngwaꞌan tñan ꞌñaǎn chaꞌ mdiyaǎn. Loꞌo ꞌwan ni, ja ya kunan wan chaꞌ nu nchkwiꞌ Ndiose, ja ya ñaꞌan wan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ja nganun chaꞌ nu ykwiꞌ Stiǐn niꞌ kasiya ꞌwan, chaꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌñaǎn chaꞌ wa msuꞌwa Ni ꞌñaǎn mdiyaǎn lo chalyuu ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nchga tsan nchkwiꞌ ꞌa wan lo kityi kula ꞌin Ndiose; xkeꞌ tiꞌ wan chaꞌ xa nu chkwiꞌ wan lo kityi kanꞌ, kaja chalyuu nu ja tsaa tii ꞌa ꞌwan bra kanꞌ. Loꞌo chañi chaꞌ nu ndukwa lo kityi kanꞌ, ngwañaꞌan ka xuꞌwi lyo nten ꞌñaǎn xa nu chkwiꞌ neꞌ lo kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Loꞌo ja xlyaa wan jñan wan chalyuu suꞌwe kanꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ja nchka tiǎnꞌ chaꞌ kuꞌni tnun nten ꞌñaǎn, ti ykwiǐnꞌ tiǎn ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ꞌWan ni, jlyo tiǎnꞌ chaꞌ xka ñaꞌan ngiꞌni wan, chunꞌ ja nsuꞌwi tiye wan ꞌin Stiǐn Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wa msuꞌwa Ndiose ꞌñaǎn mdiyaǎn chaꞌ kuꞌniǐn tñan ꞌin Ni, ni siya ja xlyaa ꞌa wan kunan wan nchga chaꞌ nu nchkwiǐnꞌ loꞌo wan. Loꞌo bra nu kan xka ta nten nu kuꞌni tñan ꞌin ti ykwiꞌ ti, bra ti xñi wan chaꞌ ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Kanꞌ chaꞌ ja ka xñi wan chaꞌ ꞌin Ndiose ―ndukwin Jesús ꞌin neꞌ―. Ndloo la chaꞌ ꞌwan chaꞌ suꞌwe ti chkwiꞌ nten ꞌwan, loꞌo ja ndloo ꞌa chaꞌ ꞌwan chaꞌ kuꞌni suꞌwe Ndiose loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Siꞌi naꞌ nu xtyaǎn kiꞌya ꞌwan tloo Ndiose ―ndukwin Jesús ꞌin neꞌ judío―. Wa lka ndiꞌin kiꞌya ꞌwan chunꞌ chaꞌ nu wa ykwiꞌ ayman Moisés nu ngwa sꞌni, ti kwiꞌ ti chaꞌ nu ndyaa ñaꞌan ꞌa tiꞌ wan sa bra ni, ndukwin wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Bra ti xñi wan chaꞌ ꞌñaǎn si chañi chaꞌ wa msñi wan chaꞌ nu ykwiꞌ ayman Moisés ―ndukwin Jesús bra kanꞌ―. Chaꞌ ꞌñaǎn ngwaꞌan ayman kanꞌ lo kityi nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Loꞌo ni, ja msñi ꞌa wan chaꞌ nu ngwaꞌan ayman kanꞌ. Kanꞌ chaꞌ ni, ¿ni sa ñaꞌan kuꞌni wan chaꞌ xñi wan chaꞌ nu chkwiǐnꞌ loꞌo wan sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Chunꞌ ndiꞌin la mdoꞌo Jesús ndyaa la xka laꞌa tsuꞌ tiyuꞌ Galilea, ti kwiꞌ tiyuꞌ Tiberias lka kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sa tlyu ti ndyaa ñaꞌan kaꞌan ꞌa nten ꞌin yu, chunꞌ wa naꞌan neꞌ chaꞌ tnun nu wa yꞌni yu chaꞌ nchkaa neꞌ tiꞌí. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Loꞌo ndyaa Jesús ska lo nten, ndyaa tukwa yu chinꞌ la kanꞌ loꞌo nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Wa tiya ti taꞌa pascua bra kanꞌ, taꞌa tnun ꞌin neꞌ judío lka taꞌa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Loꞌo naꞌan Jesús chaꞌ sa tlyu ti mdiyan kaꞌan ꞌa nten seꞌen ndiꞌin yu. Kanꞌ chaꞌ mnichaꞌ yu ꞌin Lpe: ―¿La nde yaꞌ xiꞌian nan ku nten kaꞌan kwa a? ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jlyo tiꞌ Jesús sa ñaꞌan kuꞌni yu, loꞌo ngwa tiꞌ yu ñaꞌan yu sa ñaꞌan kuꞌni Lpe kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Mxkwen Lpe ꞌin yu bra kanꞌ: ―Ja tyoꞌo skwa tukwa siyentu tñi plata chaꞌ xiꞌian nan ku nchga nten re, ni siya chinꞌ ti kaja ku skaa neꞌ ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Loꞌo nduun ska yu nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús, nu naan Ndre, taꞌa ngula Tyu Simón lka yu. Ykwiꞌ Ndre loꞌo Jesús bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ndiya ska nu kiꞌyu lyuꞌ ti re ―ndukwin Ndre―, loꞌo chinꞌ kiꞌyu jaxlya tejeꞌ ꞌin yu, loꞌo tukwa kula xuwe ti ꞌin yu. Ja tyoꞌo skwa chaꞌ kanꞌ, chaꞌ ku nten kaꞌan re ―ndukwin Ndre ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","―Chkwiꞌ wan loꞌo nten kaꞌan kwa chaꞌ tyukwa neꞌ chinꞌ lo yuu kwa ―ndukwin Jesús bra kanꞌ. Xiin ꞌa yuu seꞌen suꞌwe kanꞌ loꞌo kaꞌan ꞌa kii xuwe ndiꞌin la kanꞌ. Kiꞌyu mi xkwiꞌ nu kiꞌyu ti mdiꞌin tsan kanꞌ, nu mdukwa lo kii. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Kanꞌ msñi Jesús jaxlya kanꞌ, ndya yu xuꞌwe ꞌin Ndiose chaꞌ nda Ni nan ku neꞌ kanꞌ. Kwiꞌ mdyisnan msuꞌwe Jesús jaxlya kanꞌ, mda yu ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, loꞌo neꞌ kanꞌ lka nu ngutsaa jaxlya ꞌin nten kaꞌan kanꞌ seꞌen ndukwa neꞌ. Loꞌo kunaꞌ kula kanꞌ mda Jesús ku neꞌ. Suꞌwe yku neꞌ sa ñaꞌan nu ngulaꞌ tiꞌ neꞌ nchga neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Xa wa mdyii yku neꞌ, ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu xiyaꞌ bra kanꞌ: ―Xoꞌ kii wan nchga yuꞌwe nu nganun seꞌen yku neꞌ kwa, chaꞌ ja kanaꞌ ran ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ngwañaꞌan yꞌni neꞌ bra kanꞌ, loꞌo nganun tii tyukwa xkuwi msaꞌan nu yuꞌwi jaxlya yuꞌwe kanꞌ, yuꞌwe nu nganun seꞌen yku neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wa naꞌan neꞌ chaꞌ tnun nu tka yꞌni Jesús, kanꞌ chaꞌ ykwiꞌ neꞌ loꞌo taꞌa ndiꞌin neꞌ: ―Chañi chaꞌ yu kwa lka yu kula nu ndiꞌin chaꞌ chkwiꞌ chaꞌ ꞌin Ndiose loꞌoan, nu wa kan ti lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bra ti mgii tiꞌ Jesús chaꞌ nchka ꞌa tiꞌ neꞌ xñi neꞌ ꞌin yu, chaꞌ tsaa loꞌo neꞌ ꞌin yu chaꞌ ka yu ree nu ka ndloo la ꞌin neꞌ. Kanꞌ chaꞌ mdoꞌo tsuꞌ Jesús ndyaa mnan ti siꞌ kiꞌya, ndyaa yu ska ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wa ndyaa kwichaa bra kanꞌ, loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mdiyan neꞌ tuꞌwa tiyuꞌ xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yten neꞌ niꞌ yka naꞌan chaꞌ tyoꞌo neꞌ tsaa neꞌ la xka laꞌa tsuꞌ tiyuꞌ xiyaꞌ, chaꞌ tyaan neꞌ kichen Capernaum, ngwa tiꞌ neꞌ. Ngwiꞌya tla bra kanꞌ, loꞌo ja ya kan Jesús seꞌen ndiꞌin neꞌ lo tyiꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lye ꞌa nskwa kwiꞌin lo tyiꞌa tiyuꞌ kanꞌ, ngatsa ꞌa tyiꞌa, yuꞌwi ꞌa kulooꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wa ndyaa yka naꞌan ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu ta kiꞌyu o ta skwa kilómetro biyaꞌ tijyuꞌ lo tyiꞌa, loꞌo naꞌan neꞌ chaꞌ ndijyan Jesús seꞌen ndiꞌin neꞌ bra kanꞌ; ndaꞌan yu ndijyan yu lo tyiꞌa. Ytsen ꞌa neꞌ xa nu naꞌan neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kanꞌ chaꞌ bra ti ykwiꞌ Jesús loꞌo neꞌ: ―¡Ja kutsen wan, naꞌ lkaǎn re! ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Suꞌwe ꞌa ngwa tiye neꞌ xa wa yten Jesús niꞌ yka naꞌan ꞌin neꞌ. Kwiꞌ ndla ti ngala yka naꞌan xka laꞌa tsuꞌ tiyuꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","La xka tsan ti ndiꞌin nten kaꞌan kanꞌ sa tlyu ti tuꞌwa tiyuꞌ bra kanꞌ. Ska ti yka naꞌan kanꞌ naꞌan neꞌ mdukwi tuꞌwa tyiꞌa msiin, loꞌo jlyo tiꞌ neꞌ chaꞌ ja ndyaa Jesús niꞌ yka naꞌan kanꞌ loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu; ykwiꞌ ti neꞌ ndyaa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Chunꞌ ndiꞌin la mdiyan xka ta yka naꞌan nu mdoꞌo kichen Tiberias. Ndukwi ran tuꞌwa tyiꞌa kwiꞌ seꞌen ti seꞌen yku neꞌ jaxlya kanꞌ, bra nu ndya Xꞌnaan xuꞌwe ꞌin Ndiose chaꞌ ꞌin ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Xa wa ngwa biyaꞌ tiꞌ neꞌ chaꞌ ja ndiꞌin ꞌa Jesús tuꞌwa tiyuꞌ kanꞌ, kwiꞌ ja ndiꞌin ꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu la kanꞌ, bra kanꞌ yten neꞌ niꞌ yka naꞌan nu wa mdiyan kanꞌ, ndyaa neꞌ kichen Capernaum, ndyaa naan neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","La xka laꞌa tsuꞌ kanꞌ ndyukwa taꞌa neꞌ loꞌo Jesús. Bra ti mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―Mstru ―ndukwin neꞌ―, ¿ni bra mdoꞌoo ndijyaan ti nde a? ");
INSERT INTO ctpNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ngwaꞌu Jesús ska chaꞌ ꞌin neꞌ bra kanꞌ: ―Nduwe ꞌa tiǎnꞌ chaꞌ wa ndijyan naan wan ꞌñaǎn chunꞌ chaꞌ mdaǎn jaxlya yku wan nu ngwa xkanꞌ ―ndukwin yu―. Ngulaꞌ tiꞌ wan bra nu yku wan ꞌin ran bra kanꞌ. Chañi chaꞌ kanꞌ chaꞌ ndijyan naan wan ꞌñaǎn ni, ja ndijyan wan chaꞌ ngwa biyaꞌ tiꞌ wan chaꞌ tnun nu yꞌniǐn chabiyaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Suꞌwe la kuꞌni wan tñan chaꞌ kaja ska chaꞌ nu talo la ꞌwan ―ndukwin Jesús bra kanꞌ―. Chañi chaꞌ kalaꞌ tiꞌ wan, bra nu kaja chalyuu nu ja tsaa tii ꞌa ꞌwan. Ska nan nu nchkuan ni, chinꞌ ti bra ngalaꞌ tianꞌ loꞌo ran, bra ti ngiteꞌ tianꞌ xiyaꞌ. Loꞌo ni, naꞌ nu ndijyaǎn chaꞌ kaǎn nten, taǎn ska chaꞌ suꞌwe ꞌwan nu kuꞌni chaꞌ kalaꞌ tiꞌ wan, loꞌo ja tsaa tii ꞌa chaꞌ kanꞌ ꞌwan ―ndukwin yu―. Nan wa nda Stiǐn Ndiose chabiyaꞌ ꞌñaǎn chaꞌ taǎn chaꞌ suꞌwe kanꞌ ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Mnichaꞌ neꞌ ꞌin Jesús bra kanꞌ: ―¿Ni ñaꞌan kuꞌni ba sikwa a?, chaꞌ ka kuꞌni ba tñan nu nchka tiꞌ Ndiose chaꞌ kuꞌni ba. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","―Nde lka tñan nu nchka tiꞌ Ndiose chaꞌ kuꞌni wan ―ndukwin Jesús―. Xñi wan chaꞌ ꞌñaǎn, chaꞌ wa msuꞌwa Ni ꞌñaǎn ndijyaǎn lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Bra ti mnichaꞌ neꞌ ꞌin Jesús xiyaꞌ: ―¿Ni sa ñaꞌan kuꞌnii sikwa a? ¿Ni sa ñaꞌan chaꞌ tnun kuꞌnii chaꞌ ñaꞌan kwiꞌya ba chinꞌ ꞌin ran, chaꞌ xñi ba chaꞌ ꞌiin chunꞌ ndiꞌin la? ―ndukwin neꞌ ꞌin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wa mda Ndiose nan ku ayman ꞌñaan xa wa mdaꞌan yuꞌwi ti neꞌ lo ntenꞌ wtyi nu ngwa sꞌni. Nde ndiya chaꞌ nu ndukwa lo kityi kula kanꞌ: “Wa mda Ndiose nan yku neꞌ, ska nan nu mdoꞌo seꞌen ndiꞌin Ni nde niꞌ kwan, ngwiꞌya ran lyuu.” ");
INSERT INTO ctpNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ti ngwaꞌu la Jesús ꞌin neꞌ bra kanꞌ: ―Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni: Stiǐn Ndiose lka nu ta chaꞌ nu chañi kuꞌni chaꞌ kalaꞌ tiꞌ wan kanꞌ, ti kwiꞌ chaꞌ kanꞌ lka nu ndyoꞌo seꞌen ndiꞌin Ni; ja lka ran ti kwiꞌ chaꞌ nu mda ayman Moisés, nu yku neꞌ nu ngwa sꞌni ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ta Stiǐn ska lo chaꞌ nu kiꞌya niꞌ kasiya ꞌwan, nu chañi kuꞌni chaꞌ kalaꞌ tiꞌ wan xa wa mjwi chaꞌ kanꞌ ꞌwan, sa ñaꞌan lka bra nu nchkuan tyaja. Ndyoꞌo chaꞌ suꞌwe kanꞌ seꞌen ndiꞌin Ndiose nde niꞌ kwan, ndijyan ran lo chalyuu, nda ran chalyuu nu ja tsaa tii ꞌa ꞌin nten nu xñi chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","―Yu kula ―ndukwin neꞌ ꞌin Jesús―, taa lyaa chaꞌ suꞌwe kanꞌ ku ba, chaꞌ ku ba ꞌin ran nchga tsan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","―Sa ñaꞌan ngiꞌni tyaja bra nu mdyii ykuan ꞌin ran, ngwañaꞌan kuꞌniǐn loꞌo nten, xa nu xñi neꞌ chaꞌ ꞌñaǎn ―ndukwin Jesús bra kanꞌ―. Taǎn ska chalyuu ꞌin neꞌ kanꞌ seꞌen nu kalaꞌ tiꞌ neꞌ ―ndukwin Jesús―. Loꞌo nchga nten nu xuꞌwi chaꞌ ꞌin neꞌ loꞌoǔn, ja jñan la neꞌ xka lo nan ku neꞌ; bra nu xñi neꞌ chaꞌ ꞌñaǎn, ja kityi ꞌa tiꞌ neꞌ bra kanꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ꞌWan ni, chañi chaꞌ nu niǐn ꞌwan nu ngwa xkanꞌ chaꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌñaǎn, ni siya wa naꞌan wan ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nchga nten nu wa nda Stiǐn chaꞌ ka ꞌñaǎn, neꞌ nu msñi chaꞌ ꞌñaǎn, ka neꞌ kanꞌ nten ꞌñaǎn bra kanꞌ, loꞌo ja kuloǔn ꞌin neꞌ chaꞌ tyaa neꞌ xka seꞌen. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wa mdoꞌoǔn seꞌen ndiꞌin Stiǐn Ndiose, mdiyaǎn lo chalyuu chaꞌ kuꞌniǐn tñan nu ngulo Stiǐn ꞌñaǎn; ja ndijyaǎn chaꞌ kuꞌniǐn sa ñaꞌan nu nchka tiǎnꞌ kuꞌniǐn tiǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nchka tiꞌ Stiǐn chaꞌ ja ska nten kanaꞌ, xa wa msñi neꞌ chaꞌ ꞌñaǎn. Kwiꞌ kuꞌniǐn chaꞌ tyuꞌu neꞌ kanꞌ xiyaꞌ xa wa tyii ti chalyuu ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Loꞌo Stiǐn Ndiose nu ngwaꞌan tñan ꞌñaǎn ndijyaǎn, nde lka tñan nu nchka tiꞌ Ni chaꞌ ka: Nchka tiꞌ Ni chaꞌ ja tsaa tii ꞌa chalyuu kwi nu wa nda Ni ꞌin nten, nchga neꞌ nu tsaa ñaꞌan tiꞌ ꞌñaǎn chaꞌ lkaǎn Sñiꞌ Ni, nchga neꞌ nu xñi chaꞌ ꞌñaǎn. Kwiꞌ ngwañaꞌan, chañi chaꞌ kuꞌniǐn chaꞌ tyuꞌu neꞌ xiyaꞌ xa wa tyii ti chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Loꞌo ja ndiya ꞌa tiꞌ neꞌ judío chaꞌ re nu ykwiꞌ Jesús: “Sa ñaꞌan nu ngiꞌni tyaja, ngwañaꞌan kuꞌniǐn loꞌo nten; ka kalaꞌ tiꞌ neꞌ niꞌ kasiya ꞌin neꞌ xa nu xñi neꞌ chaꞌ ꞌñaǎn. Skaǎn tiǎn nu mdoꞌoǔn seꞌen ndiꞌin Ndiose, skaǎn tiǎn ka kuꞌniǐn chaꞌ kalaꞌ tiꞌ nten” ndukwin Jesús. Lye ꞌa ykwiꞌ neꞌ judío loꞌo taꞌa neꞌ chaꞌ ja suꞌwe chaꞌ kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","―¿Ta siꞌi Jesús sñiꞌ Se lka nu kwa a? ―ndukwin neꞌ―. Wa nsuꞌwi lyoan ꞌin sti yu loꞌo jyaꞌan yu. ¿Ni sa ñaꞌan lka chaꞌ nu nchkwiꞌ yu kwa chaꞌ wa mdoꞌo yu seꞌen ndiꞌin Ndiose? ");
INSERT INTO ctpNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re: ―Ja chkwiꞌ wan chaꞌ kuxi loꞌo taꞌa wan ꞌin chaꞌ nu ykwiǐnꞌ loꞌo wan tsan ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ja tukwin ka nten ꞌñaǎn nu ja loꞌo Stiǐn Ndiose kuꞌni chaꞌ ka neꞌ ngwañaꞌan. Loꞌo naꞌ lkaǎn nu kuꞌniǐn chaꞌ tyuꞌu neꞌ kanꞌ xiyaꞌ xa wa tyii ti chalyuu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nde ndiya ska chaꞌ nu ngwaꞌan ska ayman lo kityi nu ngwa sꞌni: “Ndiose lka nu kwaꞌu chaꞌ nu ñi ꞌin nten” ndukwin kityi kanꞌ. Kanꞌ chaꞌ nten ꞌñaǎn ka nchga nten nu kunan chaꞌ nu nchkwiꞌ Stiǐn Ndiose, nchga nten nu kuꞌni xaꞌan chaꞌ nu kwaꞌu Ni ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ja ndiya nten chalyuu nu wa naꞌan ꞌin Stiǐn Ndiose ―ndukwin Jesús―. Skaǎn tiǎn wa naꞌaǎn ꞌin Ni, chaꞌ wa mdoꞌoǔn seꞌen ndiꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ nchga nten nu xñi chaꞌ ꞌin Ndiose, wa lka mjwi chalyuu nu ja tsaa tii ꞌa ꞌin neꞌ kanꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Taǎn ska lo chalyuu nu suꞌwe ꞌin neꞌ seꞌen kalaꞌ suꞌwe tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wa yku ayman ꞌwan nan nu mda Ndiose ꞌin neꞌ chaꞌ ku neꞌ, ngwiꞌya ran lyuu lo ntenꞌ wtyi seꞌen mdaꞌan yuꞌwi neꞌ; loꞌo ja luꞌu ꞌa neꞌ kanꞌ ni, ni siya yku neꞌ nan kanꞌ nu ngwa sꞌni. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nde lka chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ ꞌin chaꞌ suꞌwe kanꞌ nu ta Ndiose ꞌin nten, nu chañi kuꞌni chaꞌ kalaꞌ tiꞌ neꞌ ―ndukwin Jesús―. Seꞌen ndiꞌin Ndiose mdoꞌo chaꞌ suꞌwe kanꞌ, ndijyan kanꞌ lo chalyuu; chañi chaꞌ bra nu ku nten nan kanꞌ, ja tsaa tii ꞌa chalyuu ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naꞌ lkaǎn chaꞌ suꞌwe kanꞌ nu kaja ꞌin nten ―ndukwin Jesús―. Mdoꞌoǔn seꞌen ndiꞌin Ndiose ndijyaǎn lo chalyuu chaꞌ kaǎn nten, chaꞌ kaja chalyuu kwi ꞌin nten ñaꞌaan chalyuu. Bra nu ku neꞌ ꞌñaǎn tyukwi ñaꞌaǎn, ja tsaa tii ꞌa chalyuu ꞌin neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Loꞌo mdyisnan neꞌ judío kanꞌ, lye ꞌa ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ. ―¿Ni sa ñaꞌan kuꞌni yu kwa chaꞌ ta yu kunaꞌ yu chaꞌ kuan? ― ndukwin neꞌ ꞌin taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ: ―Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌo wan ni ―ndukwin yu―: Ja ka tyiꞌin suꞌwe wan niꞌ kasiya ꞌwan bra nu ti ji kaja nchga chaꞌ nu ꞌñaǎn ꞌwan, ti ykwiǐnꞌ tiǎn nu mdiyaǎn lo chalyuu chaꞌ kaǎn nten. Ndiꞌin chaꞌ sten chaꞌ kanꞌ niꞌ kasiya ꞌwan, ñaꞌan tiꞌ si ka ku wan kunaǎnꞌ, ñaꞌan tiꞌ si ka koꞌo wan tneěn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Loꞌo nchga nten nu kaja tyukwi ñaꞌaǎn ꞌin neꞌ ngwañaꞌan, ja tsaa tii ꞌa chalyuu ꞌin neꞌ kanꞌ. Loꞌo kuꞌniǐn chaꞌ tyuꞌu neꞌ kanꞌ xiyaꞌ xa wa tyii ti chalyuu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chañi chaꞌ ka kaja tyukwi ñaꞌaǎn ꞌwan, sa ñaꞌan si kaja kunaǎnꞌ chaꞌ ku wan, sa ñaꞌan si kaja tneěn chaꞌ koꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Loꞌo nchga nten nu ngwañaꞌan ku neꞌ, nu ngwañaꞌan koꞌo neꞌ chaꞌ nu taǎn ꞌin neꞌ ―ndukwin Jesús―, nchga tsan tyiꞌin neꞌ kanꞌ loꞌoǔn; loꞌo naꞌ ni, tyiꞌiǐn loꞌo neꞌ kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nchga bra luꞌu Stiǐn Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn nde re, kwiꞌ chabiyaꞌ ꞌin Ndiose luꞌuǔn; kwiꞌ ngwañaꞌan, chabiyaꞌ ꞌñaǎn tyuꞌu nten nu xñi chaꞌ ꞌñaǎn, nten nu kaja tyukwi ñaꞌaǎn ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ti kwiꞌ naꞌ lkaǎn chaꞌ suꞌwe kanꞌ nu ku neꞌ kanꞌ ―ndukwin Jesús―, chaꞌ wa mdoꞌoǔn seꞌen ndiꞌin Ndiose ndijyaǎn lo chalyuu; ja lka chaꞌ suꞌwe kanꞌ ti kwiꞌ nan nu yku ayman ꞌñaan lo ntenꞌ wtyi nu ngwa sꞌni ―ndukwin yu―. Ja luꞌu ꞌa neꞌ kanꞌ ni, ni siya wa yku neꞌ nan kanꞌ nu ngwa sꞌni; loꞌo ꞌwan ni, xa nu kaja chaꞌ suꞌwe kanꞌ ꞌwan chaꞌ ku wan―ndukwin yu―, ja tsaa tii ꞌa chalyuu ꞌwan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ngwañaꞌan ngwaꞌu Jesús ꞌin neꞌ Capernaum niꞌ ñaꞌan seꞌen ndyoꞌ tiꞌin neꞌ judío chaꞌ kunan neꞌ chaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bra wa ynan tyun nten nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús chaꞌ nu ykwiꞌ yu, ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―Tnun ꞌa chaꞌ nchkwiꞌ yu kula re loꞌoan. Suꞌwe la ja kunaan ꞌaan chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jlyo tiꞌ Jesús chaꞌ nchkwiꞌ ꞌa neꞌ nu ngiꞌni xaꞌan kanꞌ loꞌo taꞌa neꞌ ꞌin chaꞌ nu tka ykwiꞌ ti yu, kanꞌ chaꞌ mnichaꞌ yu ꞌin neꞌ bra kanꞌ: ―¿Ta kasinꞌ tiꞌ wan ꞌñaǎn chunꞌ chaꞌ nu nchkwiǐnꞌ loꞌo wan a? ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Ni sa ñaꞌan chaꞌ tyaꞌan chaꞌ tiye wan si ñaꞌan wan ꞌñaǎn xa nu tyaꞌaǎn seꞌen mdoꞌoǔn ti kulo?, ti kwiꞌ naꞌ nu mdiyaǎn lo chalyuu chaꞌ kaǎn nten ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ti kwiꞌ tyiꞌi nu ta Ndiose chaꞌ kanun niꞌ kasiya ꞌñaan, kanꞌ lka nu ta chalyuu suꞌwe ꞌñaan; ja luꞌuan loꞌo jwersa nu ndiꞌin ti ꞌñaan ―ndukwin Jesús―. Kwiꞌ ngwañaꞌan, nchga chaꞌ nu nchkwiǐnꞌ loꞌo wan ni, chaꞌ ꞌin ska nan nu ta Ndiose ꞌin nten lka chaꞌ kanꞌ, ska chaꞌ nu xuꞌwi niꞌ kasiya ꞌin nten lka kanꞌ; loꞌo kaja chalyuu kwi ꞌin neꞌ xa nu tukwa neꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Loꞌo ti ndiya neꞌ taꞌa ndaꞌan wan nu ja ya tsaa ñaꞌan tiꞌ ꞌñaǎn ―ndukwin Jesús bra kanꞌ. Ti bra nu wa mdyisnan ti chaꞌ, ti kwiꞌ bra kanꞌ mgii tiꞌ Jesús ti ka ka nu ja tsaa ñaꞌan tiꞌ ꞌin yu, ti ka ka nu kuꞌni trisiyun ꞌin yu chunꞌ ndiꞌin la. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ykwiꞌ Jesús bra kanꞌ: ―Kanꞌ chaꞌ ykwiǐnꞌ loꞌo wan tsan chaꞌ ja tukwin ka nten ꞌñaǎn bra nu ja loꞌo Stiǐn Ndiose kuꞌni Ni chaꞌ ka neꞌ nten ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ti bra kanꞌ tyun ꞌa nten nu ngiꞌni xaꞌan chaꞌ ꞌin yu ngulaa yaꞌ neꞌ chaꞌ kanꞌ, ja mslyaa ꞌa neꞌ kanꞌ tyaꞌan neꞌ loꞌo yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Loꞌo mnichaꞌ Jesús ꞌin tii tyukwa nten kanꞌ: ―¿Ta loꞌo wan kulaa yaꞌ wan ꞌñaǎn, nka tiye wan a? ―ndukwin yu ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mxkwen Tyu Simón ꞌin Jesús bra kanꞌ: ―Yu kula ―ndukwin―, ¿la nde yaꞌ ndiya xka seꞌen tsaa ba chaꞌ kunan ba nchga chaꞌ nu ñi nu nchkwiiꞌ a? Ja tsaa tii ꞌa chalyuu ꞌwa xa nu kunan suꞌwe ba chaꞌ nu nchkwiiꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wa ndyaa ñaꞌan tiꞌ ba ꞌiin. Wa jlyo tiꞌ ba chaꞌ Ndiose lka nu ngulo suwi ꞌiin, chaꞌ ska ti nuꞌwin nu chañi lkaa ska ti nu lka Sñiꞌ Ndiose nu ndiꞌin chaꞌ kaan lo chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","―Ngwañaꞌan naꞌ ―ndukwin Jesús―, wa ngulo suwiǐn ꞌin taꞌa tii tyukwa wan, nu si ndiya ska wan nu lka kuneꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Loꞌo ngwa tiꞌ Jesús chkwiꞌ loꞌo neꞌ chaꞌ ꞌin Juda sñiꞌ Simón Iscariote, kanꞌ lka nu ta ꞌin Jesús yaꞌ neꞌ xaꞌan chunꞌ ndiꞌin la. Loꞌo Juda kanꞌ ni, ti kwiꞌ kanꞌ ndiꞌin loꞌo nu tii tyukwa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Chunꞌ ndiꞌin la xkwiꞌ nde lo yuu ꞌin Galilea mdaꞌan Jesús; ja mdaꞌan ꞌa yu lo yuu ꞌin Judea bra kanꞌ, chaꞌ ndiya neꞌ judío nu nchka ꞌa tiꞌ neꞌ kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wa tiya ti ska taꞌa ꞌin neꞌ judío, ska taꞌa nu nchkwiꞌ neꞌ loꞌo ran chaꞌ taꞌa ꞌin naꞌan teꞌ lka ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ykwiꞌ taꞌa Jesús loꞌo yu bra kanꞌ: ―Tyoꞌoo lyaa seꞌen ndiꞌian re, yaa lyaa nde lo yuu ꞌin Judea suꞌwe la ―ndukwin taꞌa Jesús ꞌin yu―. Ndiꞌin ꞌa neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌiin nde kwa; suꞌwe la kwaꞌuu la chinꞌ chaꞌ tnun nu ngiꞌnii ꞌin neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ja kuꞌnii tñan kanꞌ mnan ti xa nu nchka tiiꞌ chaꞌ xuꞌwi lyo nchga nten ꞌiin; ti ykwiiꞌ tii katsaaꞌ ꞌin nchga nten kwa chaꞌ ka ꞌiin kuꞌnii chaꞌ tnun bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ngwañaꞌan ykwiꞌ neꞌ, chaꞌ loꞌo taꞌa Jesús, ja ndyaa ñaꞌan tiꞌ neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re: ―Ti ji tiya bra nu ndiꞌin chaꞌ tsaꞌaǎn la kanꞌ. Loꞌo ꞌwan ni, ya ñaꞌan ti tsan suꞌwe chaꞌ tsaa wan ―ndukwin Jesús―, ");
INSERT INTO ctpNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","chaꞌ ja tiꞌí tiꞌ neꞌ ꞌwan; naꞌ lkaǎn nu tiꞌí ꞌa tiꞌ neꞌ ꞌñaǎn, chaꞌ nchkwiǐnꞌ chaꞌ nu ñi loꞌo neꞌ chaꞌ ꞌin nchga chaꞌ kuxi nu ngiꞌni neꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Yaa lya wan ykwiꞌ ti wan taꞌa kanꞌ; ja tsaꞌaǎn, chaꞌ ti ji tiya bra nu ndiꞌin chaꞌ tsaꞌaǎn la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Sa kwa ti chaꞌ ykwiꞌ Jesús bra kanꞌ, loꞌo nganun yu nde Galilea bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndyaa nu kiꞌyu taꞌa Jesús taꞌa. Chunꞌ ndiꞌin la mdoꞌo yu ti ykwiꞌ ti yu ndyaa yu taꞌa kanꞌ. Ja ndyaa Jesús sa tlyu ti loꞌo xka ta nten, ska ti yu ndyaa yu chaꞌ ja ñaꞌan nten ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Laja nu nchka taꞌa kanꞌ, ndaꞌan neꞌ judío ndaꞌan naan neꞌ ꞌin yu bra kanꞌ: ―¿La nde ndaꞌan yu kanꞌ a? ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kaꞌan ꞌa chaꞌ nchkwiꞌ neꞌ kichen kanꞌ loꞌo taꞌa neꞌ chaꞌ ꞌin Jesús. Ndiya neꞌ nu nchkwiꞌ: “Suꞌwe ꞌa nten lka yu kwa.” Loꞌo ndiya xka ta nten nu nchkwiꞌ: “Siꞌi. Xkwiꞌ chaꞌ kwiñi nchkwiꞌ yu kwa, nñi lyoꞌo ti yu ꞌin nten.” ");
INSERT INTO ctpNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ntsen neꞌ ꞌin neꞌ judío, kanꞌ chaꞌ mnan ti nchkwiꞌ neꞌ loꞌo taꞌa neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ska snuꞌ tsan ndalo taꞌa kanꞌ. Mdaꞌa jakwa tsan nchka taꞌa kanꞌ, ndyaa Jesús niꞌ lyaa tnun bra kanꞌ; mdyisnan yu ngwaꞌu yu ꞌin neꞌ nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nduwe ꞌa tiꞌ neꞌ judío chaꞌ nchka ꞌa ꞌin Jesús: ―¿Ni chaꞌ nchka ꞌa ꞌin yu kwa nduꞌu yu ꞌin nten? Ja tyun yijan mdaꞌan yu xla, ja yꞌni xaꞌan suꞌwe yu kwa ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ nu ndiꞌin niꞌ lyaa kanꞌ: ―Ja nduꞌuǔn ꞌin nten chaꞌ nu ndloǔn keěn ti ykwiǐnꞌ tiǎn; nchga chaꞌ nu ndaꞌan tiye Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn lo chalyuu, kanꞌ lka chaꞌ nu nduꞌuǔn ꞌin nten ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Bra nu xlyaa wan kuꞌni wan tñan nu nchka tiꞌ Ndiose chaꞌ kuꞌni wan, bra kanꞌ ka biyaꞌ tiꞌ wan la nde yaꞌ mdoꞌo chaꞌ nu nduꞌuǔn ꞌin nten, ni siya seꞌen ndiꞌin Ndiose mdoꞌo chaꞌ kanꞌ, ni siya ska chaꞌ nu nguloǔn keěn ti ykwiǐnꞌ tiǎn lka chaꞌ kanꞌ ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ska nten nu xkwiꞌ nchkwiꞌ chaꞌ ꞌin ti ykwiꞌ ti loꞌo nten, ngiꞌni yu chaꞌ ka tlyu la yu, ti ykwiꞌ ti yu. Xka ñaꞌan ngiꞌniǐn, chaꞌ tyukwi ti tiyeěn ngiꞌniǐn tnuǔn ꞌin Ndiose nu nka Xꞌnaǎn, kanꞌ nu ngwaꞌan tñan ꞌñaǎn chaꞌ kaǎn lo chalyuu. Loꞌo ja nsuꞌwi chaꞌ kwiñi ꞌñaǎn siyaꞌ ti. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Ti kwiꞌ ayman Moisés ngwaꞌu ꞌñaan chaꞌ kuꞌnian nchga tñan nu nchka tiꞌ Ndiose, loꞌo ja siyaꞌ ndukwa wan chaꞌ kanꞌ ―ndukwin Jesús―. Loꞌo ni, nchka tiꞌ wan kujwi wan ꞌñaǎn. ¿Ni chaꞌ lka bra kanꞌ? ");
INSERT INTO ctpNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","―Ñaꞌan tiꞌ ska kuneꞌ xaꞌan, ngwañaꞌan ngiꞌni nuꞌwin ―ndukwin neꞌ ꞌin Jesús bra kanꞌ―. ¿Ti ka nu lka nchka tiꞌ kujwi ꞌiin sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Kanꞌ chaꞌ ykwiꞌ Jesús chaꞌ re loꞌo neꞌ bra kanꞌ: ―Ska yaꞌ ti yꞌniǐn ska chaꞌ tnun tsan taꞌa, tsan nu kti ꞌa ꞌwan, loꞌo nduwe ꞌa tiꞌ wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ndiya ska tñan nu ndukwa ꞌa wan ―ndukwin yu―, ska tñan nu ytsaꞌ ayman Moisés ꞌwan sꞌni chaꞌ kuꞌni wan. Loꞌo siꞌi Moisés kanꞌ ngwa nu ykwiꞌ chaꞌ kanꞌ loꞌo wan, chaꞌ ti sꞌni la, xa nu ja ya kala Moisés, yꞌni ayman taꞌa wan tñan kanꞌ. Nde lka tñan kanꞌ nu ndyaa ñaꞌan ꞌa tiꞌ wan: Nsiꞌyu wan kijin nu xuwe kiꞌyu sñiꞌ wan chaꞌ lkwan neꞌ, ni siya tsan nu nxitñaꞌ neꞌ lka kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Xa wa mdaꞌa snuꞌ tsan nu ngula sñiꞌ wan, ngiꞌni wan tñan kanꞌ, ni siya nxitñaꞌ neꞌ chaꞌ taꞌa, chunꞌ ndukwa ꞌa wan nchga chaꞌ nu wa ytsaꞌ Moisés ꞌñaan chaꞌ kuꞌnian. Kanꞌ chaꞌ ni, ¿ni chaꞌ lka msinꞌ ꞌa tiꞌ wan ꞌñaǎn sikwa? ―ndukwin Jesús―. ¿Ta chunꞌ chaꞌ nu yꞌniǐn chaꞌ nchkaa ska nten, ni siya ska tsan nxitñaꞌ neꞌ ngwa kanꞌ, kanꞌ chaꞌ msinꞌ tiꞌ wan ꞌñaǎn a? ");
INSERT INTO ctpNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ja suꞌwe kuꞌni biyaꞌ wan ꞌin nten ska chaꞌ wa naꞌan ti wan ꞌin neꞌ ―ndukwin yu―. Tsaa naan wan nu chañi lka suun chaꞌ ꞌin neꞌ, ngwañaꞌan kuꞌni biyaꞌ ñi wan ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Xa wa ynan chinꞌ neꞌ kichen Jerusalén chaꞌ kanꞌ, bra kanꞌ mdyisnan ykwiꞌ neꞌ chaꞌ ꞌin yu bra kanꞌ: ―Yu kwa ni, ¿ta siꞌi yu kwa nu ndaꞌan naan neꞌ ꞌin yu chaꞌ kujwi neꞌ ꞌin yu a? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Loꞌo ni, ñaꞌan wan chinꞌ sa ñaꞌan ngiꞌni yu kwa, nduun yu nchkwiꞌ yu seꞌen ndiꞌin nchga nten. Loꞌo ja siyaꞌ nchka ꞌin neꞌ kulo neꞌ tñan ꞌin yu chaꞌ ja chkwiꞌ ꞌa yu ―ndukwin neꞌ ꞌin taꞌa neꞌ―. ¿Ta wa mgii tiꞌ nu nka ndloo ꞌñaan, chaꞌ yu kwa lka yu Krixtu, nten nu tnun nchka nu ndiꞌin chaꞌ kan ti sꞌni sikwa? ");
INSERT INTO ctpNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jlyo tianꞌ la nde yaꞌ mdoꞌo yu kwa. Loꞌo siꞌi ngwañaꞌan ka bra nu kan Krixtu, nten nu tnun nchka kanꞌ, ti kwiꞌ yu nu ndiꞌin taan chaꞌ kan yu. Bra nu kan yu kanꞌ, ja tukwin ka biyaꞌ tiꞌ la nde yaꞌ tyoꞌo yu kan yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kanꞌ chaꞌ kwen ykwiꞌ Jesús laja nu nduun yu nduꞌu yu ꞌin neꞌ niꞌ lyaa tnun kanꞌ: ―¡Chañi chaꞌ nsuꞌwi lyo wan ꞌñaǎn, chañi chaꞌ jlyo tiꞌ wan la nde yaꞌ mdoꞌoǔn! ―ndukwin―, loꞌo ja jlyo tiꞌ wan ni kwenta ꞌin ndijyaǎn nde re. Ska ti Ndiose msuꞌwa ꞌñaǎn ndijyaǎn lo chalyuu, loꞌo ja nsuꞌwi lyo wan ꞌin Ni ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naꞌ nsuꞌwi lyoǔn ꞌin Ndiose, chaꞌ seꞌen ndiꞌin Ni mdoꞌoǔn ndijyaǎn; Ndiose lka nu ngulo tñan ꞌñaǎn chaꞌ kaǎn nde re. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Xa wa mdyii ykwiꞌ Jesús chaꞌ kanꞌ, mdiyan xka ta nten seꞌen ndiꞌin yu bra kanꞌ, ngwa tiꞌ neꞌ chaꞌ xñi neꞌ ꞌin yu. Loꞌo ja tukwin ngwa ꞌin kalaꞌ ꞌin yu, chaꞌ ti ji tiya bra ꞌin neꞌ xaꞌan chaꞌ xñi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ni siya ngwañaꞌan ngwa tiꞌ neꞌ kanꞌ, ti ndiꞌin kaꞌan nten nu msñi chaꞌ ꞌin yu. Ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―Ti kwiꞌ chaꞌ tnun chabiyaꞌ ꞌin Ndiose ngiꞌni yu re, sa ñaꞌan nu ndukwa lo kityi chaꞌ kuꞌni neꞌ nu tnun nchka kanꞌ nu ndiꞌin chaꞌ kan; kanꞌ lka yu re, nxkeꞌ tiꞌ ba ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wa ynan neꞌ fariseo nchga chaꞌ nu nchkwiꞌ neꞌ kichen chaꞌ ꞌin Jesús. Kanꞌ chaꞌ ngulo neꞌ tñan ꞌin xta nu ngiꞌni kwan niꞌ lyaa, chaꞌ tsaa neꞌ xñi neꞌ ꞌin Jesús; ngwañaꞌan yꞌni sti joꞌo nu nka ndloo loꞌo neꞌ fariseo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ykwiꞌ Jesús loꞌo nten nu ndiꞌin niꞌ lyaa tnun kanꞌ bra kanꞌ: ―Ti tyiꞌiǐn laǎn ti chinꞌ loꞌo wan lo chalyuu re ―ndukwin yu―, loꞌo bra kanꞌ tyaꞌaǎn seꞌen ndiꞌin Stiǐn nu ngwaꞌan tñan ꞌñaǎn chaꞌ ndijyaǎn nde re ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tsaa naan wan ꞌñaǎn la seꞌen ndiꞌiǐn, loꞌo ja tyija lyoǔn ꞌwan bra kanꞌ, chaꞌ ja kaja chabiyaꞌ tsaa wan seꞌen tyiꞌiǐn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","―¿La nde yaꞌ tsaa yu kwa, seꞌen ja ka tyija lyo yu ꞌñaan a? ―ndukwin neꞌ judío kanꞌ ꞌin taꞌa neꞌ―. ¿Ta tijyuꞌ tsaa yu, la seꞌen ndiꞌin xka ta neꞌ judío taꞌaan a? ¿Ta tsaa yu chaꞌ kwaꞌu yu chaꞌ ꞌin Ndiose ꞌin xka ta nten nu ndiꞌin la kanꞌ a? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ni sa ñaꞌan chaꞌ ndaꞌan tiye yu kwa chaꞌ nchkwiꞌ yu chaꞌ re a?: “Tsaa naan wan ꞌñaǎn la seꞌen ndiꞌiǐn, loꞌo ja tyija lyoǔn ꞌwan, chaꞌ ja kaja chabiyaꞌ tsaa wan seꞌen tyiꞌiǐn bra kanꞌ” ndukwin yu tsan. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Xa wa tyii ti taꞌa, tsan ykwiꞌ taꞌa, ti nduun Jesús niꞌ lyaa tnun bra kanꞌ. Kwen ykwiꞌ yu loꞌo nten nu ndiꞌin nde kwa: ―Bra nu kityi tiꞌ wan tyiꞌa, kan wan seꞌen ndiꞌiǐn chaꞌ taǎn tyiꞌa koꞌo wan ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nchga nten nu ndiꞌin chaꞌ ꞌin loꞌoǔn, ka ꞌin neꞌ kanꞌ sa ñaꞌan lka si ndukwa tyiꞌa niꞌ kasiya ꞌin neꞌ. Tlyu ꞌa chaꞌ suꞌwe ka niꞌ kasiya ꞌin neꞌ kanꞌ, chaꞌ ka kuꞌni suꞌwe neꞌ kanꞌ loꞌo taꞌa nten neꞌ bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. Lo kityi ꞌin Ndiose nchkwiꞌ chaꞌ ngwañaꞌan ka ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ngwañaꞌan ykwiꞌ Jesús loꞌo neꞌ kwa, chaꞌ wa ta ti Ndiose Tyiꞌi Ni chaꞌ kanun niꞌ kasiya ꞌin nchga nten nu xñi chaꞌ ꞌin Ni. Ja ya ta Ndiose Tyiꞌi Ni kan lo chalyuu, chunꞌ ja ya tyaa Jesús seꞌen ndiꞌin Ndiose nu lka Sti yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kanꞌ ndiya nten kichen nu wa ynan chaꞌ kanꞌ, nu ykwiꞌ chaꞌ ꞌin Jesús: ―Chañi chaꞌ yu kwa lka yu kula nu ndiꞌin chaꞌ kan ti sꞌni, nu chkwiꞌ chaꞌ ꞌin Krixtu loꞌoan ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Loꞌo xka ta nten ykwiꞌ xka chaꞌ ꞌin yu: ―Yu kwa lka nten nu tnun nchka nu msuꞌwa Ndiose chaꞌ kulaa ꞌñaan, ti kwiꞌ Krixtu lka yu ―ndukwin neꞌ. Loꞌo mxkwen xka ta nten kichen ꞌin taꞌa neꞌ bra kanꞌ: ―¡Siꞌi neꞌ Galilea ka nten tnun nchka kanꞌ! ");
INSERT INTO ctpNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lo kityi kula kanꞌ nchkwiꞌ chaꞌ ska nten taꞌa ayman David ka nten tnun kanꞌ; kichen Belén kala yu kanꞌ, chaꞌ taꞌa kichen tyi ayman David lka yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ja ngwa suꞌwa chaꞌ ꞌin neꞌ loꞌo taꞌa neꞌ chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Loꞌo ja tukwin msñi ꞌin yu, ni siya ndiꞌin nten nu ngwa ꞌa tiꞌ xñi ꞌin yu, chaꞌ tsaa loꞌo neꞌ ꞌin yu niꞌ ñaꞌan chkwan. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Xiyaꞌ ndyaa xta nu ngiꞌni kwan niꞌ lyaa kanꞌ seꞌen ndiꞌin sti joꞌo nu lka ndloo, seꞌen ndiꞌin neꞌ fariseo. Mnichaꞌ neꞌ ꞌin xta bra kanꞌ: ―¿Ni chaꞌ lka ja loꞌo yu kanꞌ mdiyan loꞌo wan seꞌen ndiꞌin ba a? ");
INSERT INTO ctpNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mxkwen xta kanꞌ ꞌin neꞌ bra kanꞌ: ―¡Ja ya kunan ba nchkwiꞌ ska nten sa ñaꞌan nu nchkwiꞌ yu kwa! ");
INSERT INTO ctpNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Lye ꞌa ykwiꞌ neꞌ fariseo loꞌo xta bra kanꞌ: ―¿Ta loꞌo wan mñi lyoꞌo yu kwa ꞌwan sikwa a? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ja siyaꞌ ndiꞌin nten nu lka ndloo ꞌñaan nu msñi chaꞌ ꞌin yu kanꞌ. Loꞌo neꞌ fariseo taꞌa ba, ti kwiꞌ ti ja ndyaa ñaꞌan tiꞌ ba chaꞌ nu nchkwiꞌ yu ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Neꞌ kichen re, ja la suꞌwe neꞌ; xkwiꞌ chaꞌ xaꞌan ndaꞌan chaꞌ tiye neꞌ, chunꞌ ja nnan ꞌa neꞌ chaꞌ nu ykwiꞌ ayman Moisés loꞌoan. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Loꞌo mdyituun ska neꞌ fariseo laja neꞌ kanꞌ bra kanꞌ; Nicodemo naan yu, ti kwiꞌ yu kula kanꞌ lka yu nu wa yaa seꞌen ndiꞌin Jesús tla kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Bra nu kuꞌni biyaanꞌ ꞌin ska nten, ja ndiya chabiyaꞌ ꞌñaan chaꞌ taan nu tiꞌí ꞌin nten kanꞌ xa nu ti ji kunaan nchga chaꞌ nu nchkwiꞌ yu kanꞌ, xa nu ti ji ka biyaꞌ tianꞌ sa ñaꞌan chaꞌ ndiꞌin ꞌin yu kanꞌ bra kanꞌ ―ndukwin Nicodemo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","―¿Ti kwiꞌ neꞌ Galilea lkaa sikwa a? ―ndukwin taꞌa fariseo ꞌin Nicodemo bra kanꞌ―. Ñaꞌan nuꞌwin chinꞌ lo kityi ꞌin Ndiose nu ngwaꞌan neꞌ nu ngwa sꞌni, chaꞌ ka biyaꞌ la tiiꞌ chaꞌ siꞌi neꞌ Galilea ka nten nu ka chkwiꞌ chaꞌ ꞌin Ndiose loꞌoan. ");
INSERT INTO ctpNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nchga nten ndyaa neꞌ tuꞌ naꞌan tyi neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Loꞌo Jesús mdoꞌo yu ndyaa yu ska ti yu lo kiꞌya Olivos chaꞌ chkwiꞌ yu loꞌo Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Bra wa kiꞌya ti xaa, xiyaꞌ ndyaa Jesús chaꞌ tyiꞌin chinꞌ niꞌ lyaa tnun. Bra ti ndyoꞌ tiꞌin nchga nten seꞌen ndiꞌin yu bra kanꞌ. Ndyaa tukwa yu, ngwaꞌu yu chaꞌ ꞌin Ndiose ꞌin neꞌ kwa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Loꞌo mdiyan neꞌ fariseo kanꞌ seꞌen ndiꞌin Jesús, loꞌo mstru nu nduꞌu chaꞌ joꞌo, yan loꞌo neꞌ ꞌin ska nu kunaꞌan nu ndukwi kiꞌya. Wa ndyija lyo nu kunaꞌan kanꞌ ꞌin neꞌ loꞌo kwilyoꞌo xka nten. Mdiyan loꞌo neꞌ ꞌin nu kunaꞌan kanꞌ, mjiꞌin tyuun neꞌ ꞌin tloo nchga nten nu ndiꞌin kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ykwiꞌ neꞌ kanꞌ loꞌo Jesús bra kanꞌ: ―Mstru ―ndukwin neꞌ―, wa ndyija lyo nu kunaꞌan re ꞌwa loꞌo kwilyoꞌo xka nten ―ndukwin neꞌ ꞌin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chabiyaꞌ ꞌwa, chabiyaꞌ ꞌin chaꞌ nu wa ykwiꞌ ayman Moisés loꞌoan, ndiꞌin chaꞌ kaja neꞌ kwa loꞌo kee ti. ¿Ni sa ñaꞌan nchkwiin ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ykwiꞌ biyaꞌ ti neꞌ kanꞌ loꞌo Jesús, chaꞌ nchka tiꞌ neꞌ tyijin ti chaꞌ ꞌin neꞌ loꞌo yu, chaꞌ kaja ñaꞌan xtya neꞌ kiꞌya ꞌin yu. Loꞌo Jesús ni, mdukwi lyuu ti yu, mdaꞌan yu letra lo yuu loꞌo loo xñii yaꞌ ti yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ti mnichaꞌ la neꞌ ꞌin Jesús, kanꞌ chaꞌ mdyituun ñi yu, ykwiꞌ yu loꞌo neꞌ nu mdiyan loꞌo ꞌin nu kunaꞌan kanꞌ bra kanꞌ: ―Si ndiya ska wan nu ja ndukwi wan kiꞌya ―ndukwin yu―, kanꞌ ka nu kuun kee ꞌin nu kunaꞌan kwa kulo ndukwa la. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xiyaꞌ mdukwi lyuu Jesús mdaꞌan loꞌo loo xñii yaꞌ ti yu lo yuu, loꞌo ja ykwiꞌ ꞌa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Bra wa ynan neꞌ chaꞌ kanꞌ, mdyisnan neꞌ mdoꞌo neꞌ ndyaa neꞌ bra kanꞌ, chaꞌ nu jlyo tiꞌ neꞌ chaꞌ ndukwi neꞌ kiꞌya. Kulo la ndyaa neꞌ nu kula la, chunꞌ ndiꞌin la ndyaa nchga neꞌ kwenta ska ti neꞌ. Loꞌo nganun Jesús ska ti yu, kwiꞌ ngwañaꞌan, ti nduun nu kunaꞌan kanꞌ ngita ꞌin yu sa ñaꞌan bra nu chkwiꞌ yu loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Mdyituun Jesús xiyaꞌ, ykwiꞌ yu loꞌo nu kunaꞌan kanꞌ bra kanꞌ: ―¿La nde yaꞌ ndyaa neꞌ kwa a? ―ndukwin yu―. ¿Ti nduun neꞌ nu mstya kiꞌya ꞌiin a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","―Ja tukwin nduun nu mstya kiꞌya ꞌñaǎn, neꞌ kula ―ndukwin nu kunaꞌan kanꞌ. ―Suꞌwe sikwa ―ndukwin Jesús ꞌin nu kunaꞌan kanꞌ―. Ngwañaꞌan naꞌ, ja ndiꞌin kiꞌya nu xtyaǎn ꞌiin. Tyaa lyaa ni ―ndukwin―, ja kuꞌnii ꞌaa ngwañaꞌan xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xiyaꞌ ykwiꞌ Jesús loꞌo nten niꞌ lyaa kanꞌ: ―Naꞌ lkaǎn nu taǎn xaa nu xuꞌwi niꞌ kasiya ꞌin nten chalyuu ―ndukwin yu―. Kanun xaa luwi ꞌñaǎn niꞌ kasiya ꞌin nten nu tsaa ñaꞌan tiꞌ ꞌñaǎn, kwiꞌ ja tsaa tii ꞌa chalyuu ꞌin neꞌ kanꞌ bra kanꞌ. Ja sten yuꞌwi neꞌ kanꞌ loꞌo kuneꞌ xaꞌan nu ja nchka tiꞌ chaꞌ xuꞌwi xaa ꞌñaǎn niꞌ kasiya ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ykwiꞌ neꞌ fariseo loꞌo Jesús bra kanꞌ: ―Ska ti nuꞌwin ndlo luwi chaꞌ ꞌiin, ti ykwiiꞌ tii. Loꞌo ja kunan ꞌa nten chaꞌ nchkwiiꞌ ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Kunan nten chaꞌ nu chkwiǐnꞌ loꞌo neꞌ. Ni siya skaǎn tiǎn nchkwiǐnꞌ ñi chaꞌ ꞌñaǎn, ti ykwiǐnꞌ tiǎn ―ndukwin yu―. Wa jlyo tiǎnꞌ la nde yaꞌ mdoꞌoǔn, kwiꞌ jlyo tiǎnꞌ la nde yaꞌ tsaꞌaǎn; ꞌwan ni, ja siyaꞌ jlyo tiꞌ wan la nde yaꞌ mdoꞌoǔn, ja jlyo tiꞌ wan la nde yaꞌ tsaꞌaǎn ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wa lka mstya wan kiꞌya ꞌñaǎn. Bra nu ngiꞌni wan ngwañaꞌan, ngiꞌni wan sa ñaꞌan ngiꞌni nten chalyuu ti. Loꞌo naꞌ ni, ja ndijyaǎn lo chalyuu chaꞌ xtyaǎn kiꞌya ꞌin nten ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Chañi chaꞌ ka ꞌñaǎn kuꞌni biyaǎnꞌ ꞌin nten. Bra nu kuꞌni biyaǎnꞌ ꞌin neꞌ ni, ñi ꞌa chaꞌ nu chkwiǐnꞌ bra kanꞌ, chaꞌ siꞌi skaǎn tiǎn kuꞌni biyaǎnꞌ ꞌin neꞌ; loꞌo naꞌ loꞌo Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn re, suꞌwa kuꞌni biyaꞌ ba ꞌin neꞌ bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ndukwaan ꞌaan chaꞌ kula nu ndukwa lo kityi ti sꞌni; nde kwa ndiya ska chaꞌ nu nchkwiꞌ chaꞌ tyoꞌo luwi nten ꞌin sa ñaꞌan chaꞌ nu ndiꞌin ꞌin neꞌ, bra nu suꞌwa chkwiꞌ tukwa nten ꞌin chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Kanꞌ chaꞌ ni, naꞌ lkaǎn ska nu kanꞌ ―ndukwin Jesús―, chaꞌ ñi nchkwiǐnꞌ chaꞌ ꞌñaǎn, ti ykwiǐnꞌ tiǎn; xka nu lka Stiǐn nu ngwaꞌan tñan ꞌñaǎn ndijyaǎn nde re. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","―¿La nde yaꞌ ndiꞌin Stii sikwa a? ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ―Ja siyaꞌ yuꞌwi lyo wan ꞌñaǎn, loꞌo ti kwiꞌ ti chaꞌ, ja la nsuꞌwi lyo wan ꞌin Stiǐn ―ndukwin Jesús ꞌin neꞌ―. Si nsuꞌwi lyo wan ꞌñaǎn, kwiꞌ ngwañaꞌan nsuꞌwi lyo wan ꞌin Stiǐn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ngwañaꞌan ndukwin Jesús xa nu ngwaꞌu yu ꞌin nten niꞌ lyaa tnun, ndukwa yu kwiꞌ seꞌen ti seꞌen nskwa kiñaꞌ tñi, seꞌen nsuꞌwa neꞌ tñi nu ka lomstan ꞌin neꞌ niꞌ lyaa. Loꞌo ja tukwin msñi ꞌin Jesús, chaꞌ tsaa loꞌo ꞌin yu niꞌ ñaꞌan chkwan, chaꞌ ti ji tiya bra ꞌin yu chaꞌ ta neꞌ xaꞌan nu tiꞌí ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Tsaꞌaǎn ni ―ndukwin yu―. Chunꞌ ndiꞌin la tsaa naan wan ꞌñaǎn nde seꞌen mdaꞌaǎn, loꞌo ja tyija lyoǔn ꞌaǎn ꞌwan bra kanꞌ ―ndukwin―. Kaja wan loꞌo kiꞌya nu ndiꞌin ꞌwan, ni siya ti ji tyija lyoǔn ꞌwan, loꞌo ja ka ꞌa ꞌwan tsaa wan seꞌen tyiꞌiǐn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","―¿Ta kujwi yu ꞌin yu, ti ykwiꞌ ti yu a? ―ndukwin neꞌ judío ꞌin taꞌa neꞌ―. ¿Ta ngwañaꞌan ndaꞌan chaꞌ tiye yu chaꞌ ndukwin yu: “Ja ka ꞌa ꞌwan tsaa wan seꞌen tyiꞌiǐn bra kanꞌ” a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Kanꞌ chaꞌ lye la ykwiꞌ Jesús loꞌo neꞌ kanꞌ: ―Chalyuu re seꞌen ndiꞌin wan, chen ꞌa ñaꞌan ngiꞌni nten; loꞌo naꞌ ni, xka chalyuu la seꞌen ndiꞌin Ndiose, nde kwa mdoꞌoǔn ―ndukwin yu―. Wa ndyaꞌan tiꞌ wan ꞌin chaꞌ xaꞌan nu ngiꞌni nten chalyuu; loꞌo naꞌ ni, nsuꞌwi tiyeěn ꞌin Stiǐn Ndiose la seꞌen ndiꞌin Ni ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kanꞌ chaꞌ niǐn ꞌwan chaꞌ kaja wan loꞌo kiꞌya nu ndiꞌin ꞌwan. Loꞌo chañi chaꞌ kanꞌ. Kaja wan loꞌo kiꞌya nu ndiꞌin ꞌwan, chaꞌ ja ndyaa ñaꞌan tiꞌ wan ꞌñaǎn, chaꞌ lkaǎn ti kwiꞌ sa ñaꞌan nu niǐn ꞌwan chaꞌ lkaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","―¿Ti ka nu lkaa sikwa a? ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ―Ti xkanꞌ niǐn ꞌwan ti ka nu lkaǎn ―ndukwin Jesús bra kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Loꞌo ti kaꞌan la chaꞌ ka chkwiǐnꞌ loꞌo wan chaꞌ ꞌin kiꞌya nu ndiꞌin ꞌwan. Chañi ꞌa chaꞌ nu nchkwiꞌ Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn, loꞌo nchga chaꞌ nu nchkwiꞌ Ni loꞌoǔn, sa kanꞌ ti chaꞌ lka nu nchkwiǐnꞌ loꞌo nten chalyuu. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ja ngwa biyaꞌ tiꞌ neꞌ chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ, chaꞌ ꞌin Ndiose nu lka Sti yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kanꞌ chaꞌ ti nchkwiꞌ la Jesús loꞌo neꞌ bra kanꞌ: ―Chunꞌ ndiꞌin la, bra nu skwen wan ꞌñaǎn lo wsi, ka biyaꞌ tiꞌ wan chaꞌ lkaǎn ti kwiꞌ sa ñaꞌan nu niǐn ꞌwan chaꞌ lkaǎn, naꞌ nu ndijyaǎn lo chalyuu chaꞌ kaǎn nten ―ndukwin Jesús―. Ja ska tñan ngiꞌniǐn chabiyaꞌ ꞌñaǎn, ti ykwiǐnꞌ tiǎn; Stiǐn Ndiose, kanꞌ lka nu ngwaꞌu ꞌñaǎn nchga chaꞌ nu chkwiǐnꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nchga tsan ndiꞌin Ni loꞌoǔn, ti kwiꞌ Ni nu ngwaꞌan tñan ꞌñaǎn chaꞌ ndijyaǎn re. Ja ngulaa yaꞌ ꞌa Stiǐn ꞌñaǎn, chaꞌ xkwiꞌ tñan nu ndiya tiꞌ Ni, kanꞌ lka tñan nu ngiꞌniǐn. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Xa wa ynan neꞌ chaꞌ nu ykwiꞌ Jesús, tyun ꞌa neꞌ ndyaa ñaꞌan tiꞌ neꞌ ꞌin yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kanꞌ chaꞌ ti ngwaꞌu la Jesús chaꞌ ꞌin neꞌ judío nu msñi ke ti neꞌ chaꞌ nu nchkwiꞌ yu: ―Bra nu kanun chaꞌ nu nduꞌuǔn ꞌwan niꞌ kasiya ꞌwan, ti kwiꞌ chaꞌ ꞌin Ndiose kanꞌ, chañi chaꞌ ka wan nten nu ngiꞌni xaꞌan ꞌñaǎn bra kanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kwiꞌ ka biyaꞌ tiꞌ wan nchga chaꞌ nu ñi; loꞌo ja tukwin ka tatsaa ꞌwan chaꞌ kuꞌni wan chaꞌ xaꞌan bra kanꞌ, chunꞌ jlyo tiꞌ wan chaꞌ nu ñi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","―Nten taꞌa ayman Abraham lka ba ―ndukwin neꞌ judío kanꞌ―, loꞌo ja tukwin ka tatsaa ꞌwa chaꞌ kuꞌni ba chaꞌ xaꞌan. ¿Ni sa ñaꞌan nchka tiiꞌ chkwiiꞌ loꞌo ba xa nu ykwiiꞌ chaꞌ re: “Ja ka tatsaa neꞌ ꞌwan chaꞌ kuꞌni wan chaꞌ xaꞌan” a? ―ndukwin neꞌ judío kanꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","―Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús bra kanꞌ―. Nchga nten nu ndiꞌin kiꞌya ꞌin, wa lka ndiya xꞌnan neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ska msu nu ndiꞌin naꞌan tyi xꞌnan yu, wa lka ti chaꞌ suꞌwe ndyiji ꞌin yu, chaꞌ ja lka yu ñaꞌan tiꞌ sñiꞌ xꞌnan yu. Loꞌo sñiꞌ xꞌnan yu kanꞌ, nchga bra ndiꞌin yu loꞌo sti yu, ndyiji nchga chaꞌ suꞌwe ꞌin yu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Skaǎn tiǎn nu lkaǎn Sñiꞌ Ndiose, bra nu kulaǎn ꞌwan, chañi chaꞌ ja ka ꞌa tatsaa neꞌ ꞌwan chaꞌ kuꞌni wan chaꞌ xaꞌan xiyaꞌ seꞌen ndiꞌin wan ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jlyo tiǎnꞌ chaꞌ ti kwiꞌ nten taꞌa ayman Abraham lka wan, ni siya nchka tiꞌ wan kujwi wan ꞌñaǎn, chunꞌ ja ndukwa wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nduꞌuǔn ꞌwan nchga chaꞌ nu wa naꞌaǎn seꞌen ndiꞌin Stiǐn Ndiose, kanꞌ lka chaꞌ nu nchkwiǐnꞌ loꞌo wan. Loꞌo ꞌwan ni, ngiꞌni wan nchga tñan nu yꞌni xaꞌan wan ꞌin sti wan, kanꞌ ti tñan nu ngiꞌni wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mxkwen neꞌ ꞌin Jesús bra kanꞌ: ―Ayman Abraham, kanꞌ ngwa ayman kula ꞌwa, nu yuꞌwi chalyuu nu ngwa sꞌni ―ndukwin neꞌ. ―Si chañi chaꞌ lka wan nten taꞌa ayman Abraham kanꞌ, kuꞌni wan ti kwiꞌ tñan nu yꞌni Abraham ―ndukwin Jesús ꞌin neꞌ kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nchka ꞌa tiꞌ wan kujwi wan ꞌñaǎn ni, ni siya xkwiꞌ chaꞌ nu ñi nduꞌuǔn ꞌwan, ti kwiꞌ chaꞌ nu ñi nu ykwiꞌ Ndiose loꞌoǔn. ¡Loꞌo ja yꞌni ayman Abraham ngwañaꞌan! ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kanꞌ chaꞌ nchkwiǐnꞌ chaꞌ ndiya xka nu lka sti wan, loꞌo ti kwiꞌ tñan nu ndlo nu kanꞌ ꞌwan, kanꞌ lka tñan nu ndiya la tiꞌ wan kuꞌni wan. ―Siꞌi sñiꞌ kuneꞌ xaꞌan lka bare ―ndukwin neꞌ―. Ska ti Ndiose lka Sti ba ―ndukwin neꞌ judío ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","―¿Ta kwiꞌ Ndiose lka Sti wan sikwa a? ¿Ni chaꞌ lka ja ndiya tiꞌ wan ꞌñaǎn sikwa a? ―ndukwin Jesús―. Seꞌen ndiꞌin Ndiose mdoꞌoǔn, loꞌo ndiꞌiǐn lo chalyuu re chabiyaꞌ ꞌin Ni ―ndukwin Jesús―. Siꞌi chaꞌ ꞌñaǎn ti ykwiǐnꞌ tiǎn ndijyaǎn lo chalyuu, Ndiose ykwiꞌ ngulo Ni tñan ꞌñaǎn chaꞌ kaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ni chaꞌ lka ja nnan wan chaꞌ nu nchkwiǐnꞌ loꞌo wan a? ―ndukwin Jesús ꞌin neꞌ bra kanꞌ―. Ja xlyaa wan ka biyaꞌ tiꞌ wan chaꞌ nu nchkwiǐnꞌ loꞌo wan ―ndukwin yu ꞌin neꞌ judío kanꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ti kwiꞌ kuneꞌ xaꞌan lka sti wan, loꞌo nchka tiꞌ wan kuꞌni wan ti kwiꞌ tñan nu ngulo nu kanꞌ ꞌwan. Ti bra nu mdyisnan chalyuu, ti bra kanꞌ mdyisnan nu kanꞌ ngiꞌni ñuꞌun ꞌin nten ―ndukwin Jesús―. Ja mdoꞌo nu kanꞌ seꞌen ndukwa kiyaꞌ chaꞌ nu ñi, kanꞌ chaꞌ ja siyaꞌ ndiya chaꞌ nu ñi ꞌin nu kanꞌ ―ndukwin―. Xa nu kwiñi lyoꞌo nu kanꞌ ꞌin nten, chaꞌ ꞌin ti ykwiꞌ ti lka chaꞌ kwiñi nu nchkwiꞌ loꞌo neꞌ. Ska nu kwiñi tnun lka kuneꞌ xaꞌan, ti kwiꞌ kanꞌ lka sti nchga nu kwiñi. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Chaꞌ nu ñi nchkwiǐnꞌ loꞌo wan ni, kanꞌ chaꞌ ja la ndyaa ñaꞌan tiꞌ wan ꞌñaǎn, chaꞌ siꞌi chaꞌ kwiñi nchkwiǐnꞌ loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Loꞌo ni, ja ka chkwiꞌ wan chaꞌ naꞌ ndukwiǐn kiꞌya; bra nu kwaꞌuǔn ska chaꞌ nu ñi ꞌwan, ¿ni chaꞌ lka ja tsaa ñaꞌan tiꞌ wan ꞌñaǎn bra kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nchga nten nu nchkwiꞌ chaꞌ Ndiose lka Sti neꞌ, xlyaa neꞌ kanꞌ kunan neꞌ nchga chaꞌ nu nchkwiꞌ Ni loꞌo neꞌ ―ndukwin Jesús ꞌin neꞌ judío kanꞌ―. Loꞌo siꞌi sñiꞌ Ndiose lka wan, kanꞌ chaꞌ ja nchka ꞌa tiꞌ wan kunan wan chaꞌ nu nchkwiǐnꞌ loꞌo wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ykwiꞌ neꞌ judío loꞌo Jesús bra kanꞌ: ―Chañi ꞌa chaꞌ nu nchkwiꞌ ba chaꞌ ꞌiin ni, chaꞌ neꞌ Samaria lka nuꞌwin. Ñaꞌan tiꞌ ska kuneꞌ xaꞌan, ngwañaꞌan ngiꞌnii ―ndukwin neꞌ ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","―Ja siyaꞌ ngwa kuneꞌ xaꞌan ndloo la ꞌñaǎn ―ndukwin Jesús―. Naꞌ ngiꞌniǐn tnuǔn ꞌin Stiǐn Ndiose; loꞌo ꞌwan ni, ja siyaꞌ ngiꞌni tnun wan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ja nchka tiǎnꞌ chaꞌ kuꞌni tnun nten ꞌñaǎn, chaꞌ Stiǐn Ndiose, kanꞌ nu ngiꞌni chaꞌ ka tlyuǔn. Ska ti Ndiose lka nu kuꞌni biyaꞌ ꞌin nchga nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni: Bra nu kunan nten chaꞌ nu ngwaꞌuǔn ꞌin neꞌ, ja tsaa tii ꞌa chalyuu suꞌwe nu taǎn ꞌin neꞌ kanꞌ, ni siya kaja neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Loꞌo ykwiꞌ neꞌ judío kanꞌ loꞌo Jesús xiyaꞌ bra kanꞌ: ―Jlyo tiꞌ bare chaꞌ ñaꞌan tiꞌ ska kuneꞌ xaꞌan, ngwañaꞌan ngiꞌnii ―ndukwin neꞌ―. Sꞌni ngujwi ayman Abraham, sꞌni ngujwi xka ta ayman nu ykwiꞌ chaꞌ ꞌin Ndiose loꞌo nten. ¿Ni sa ñaꞌan ndaꞌan chaꞌ tiyee chaꞌ nu tka ndukwiin ti, chaꞌ: “Ja tsaa tii ꞌa chalyuu ꞌin nten nu kunan chaꞌ nu kwaꞌuǔn ꞌin neꞌ” a? ―ndukwin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Nxkeꞌ tiiꞌ chaꞌ chinꞌ la chaꞌ jlyo tiꞌ ayman Abraham ꞌwa, kaꞌan la chaꞌ jlyo tiꞌ nuꞌwin sikwa a? ¿Ta ngwañaꞌan nxkeꞌ tiiꞌ a? Loꞌo ayman Abraham, loꞌo xka ta ayman kanꞌ, wa ngujwi nchga neꞌ kanꞌ. ¿Ti ka nu lka nuꞌwin, nxkeꞌ tiiꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Ja suꞌweěn siyaꞌ ti si kuꞌniǐn chaꞌ ka tlyuǔn laǎn, ti ykwiǐnꞌ tiǎn; Stiǐn Ndiose, kanꞌ nu ngiꞌni chaꞌ ca tlyuǔn ― ndukwin Jesús―. Loꞌo ꞌwan ni, ngiꞌni wan chaꞌ Sti wan lka Ndiose, ");
INSERT INTO ctpNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ni siya ja nsuꞌwi lyo wan ꞌin Ni. Naꞌ nsuꞌwi lyoǔn ꞌin Ni. Ja ka chkwiǐnꞌ chaꞌ ja nsuꞌwi lyoǔn ꞌin Ni; kwiñiǐn si ngwañaꞌan nchkwiǐnꞌ, wa lkaǎn sa ñaꞌan lka wan, chaꞌ kwiñi ꞌa wan. Chañi chaꞌ nsuꞌwi lyoǔn ꞌin Stiǐn Ndiose, kwiꞌ ngwañaꞌan, ndukwaǎn nchga chaꞌ nu nchkwiꞌ Ni loꞌoǔn ―ndukwin Jesús ꞌin neꞌ judío kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ayman Abraham ꞌwan ni, lye ꞌa ngwa tiꞌ yu chaꞌ ñaꞌan yu ꞌñaǎn xa wa ngulaǎn lo chalyuu. Loꞌo ngwañaꞌan ngwa, naꞌan yu kula ꞌñaǎn, loꞌo suꞌwe ꞌa ngwa tiye yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Lye ꞌa ykwiꞌ neꞌ judío loꞌo Jesús bra kanꞌ: ―Ja ya xuꞌwii tuꞌwatyii yijan ―ndukwin neꞌ ꞌin yu―. ¿Ni sa ñaꞌan ngwa chaꞌ wa naꞌaan ꞌin ayman Abraham sikwa a? ");
INSERT INTO ctpNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","―Chañi ꞌa chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús―. Wa nsuꞌwiǐn xa nu ngula ayman Abraham kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Msñi neꞌ kee chaꞌ kuun neꞌ ꞌin Jesús chaꞌ kujwi neꞌ ꞌin yu bra kanꞌ, loꞌo yuꞌwi kutsiꞌ yu ꞌin neꞌ. Mdoꞌo yu niꞌ lyaa kanꞌ, mdijin yu laja seꞌen ndiꞌin nten ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tuꞌwa tuwiin seꞌen ndyaa Jesús, naꞌan yu ska yu kwityiinꞌ, wa ñaꞌan kwityiinꞌ yu xa nu ngula yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kanꞌ mnichaꞌ neꞌ nu ngiꞌni xaꞌan kanꞌ ꞌin Jesús: ―Mstru ―ndukwin neꞌ―, ¿ti ka nu ndukwi kiꞌya chaꞌ kwityiinꞌ kiloo yu kwa xa nu ngula yu a? ¿Ti ykwiꞌ ti yu a? ¿O ta neꞌ kula ꞌin yu ndukwi neꞌ kiꞌya a? ");
INSERT INTO ctpNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","―Ja kwityiinꞌ yu kwa siꞌya kiꞌya nu ndukwi yu, kwiꞌ ja kwityiinꞌ yu siꞌya kiꞌya nu ndukwi neꞌ kula ꞌin yu ―ndukwin Jesús ꞌin neꞌ―. Kwityiinꞌ yu xa nu ngula yu chaꞌ ka ñaꞌan nten sa ñaꞌan chaꞌ tnun ka bra nu kuꞌni Ndiose chaꞌ chkaa yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Bra nu ti xaa ka kuꞌnian tñan ―ndukwin Jesús―; xa wa ndyaa kwichaa, ja tukwin ka kuꞌni tñan bra kanꞌ. Kwiꞌ ngwañaꞌan naꞌ ―ndukwin―, ndiꞌin chaꞌ kuꞌniǐn nchga tñan nu ngulo Ndiose ꞌñaǎn chaꞌ nu msuꞌwa Ni ꞌñaǎn ndijyaǎn lo chalyuu ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Bra nu ti tyiꞌiǐn lo chalyuu, ti taǎn xaa nu xuꞌwi niꞌ kasiya ꞌin nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Xa nu mdyii ykwiꞌ Jesús, mxtyuu yu chinꞌ tyiꞌa nu ndyoꞌo tuꞌwa yu lyuu, chaꞌ kuꞌni yu chinꞌ yuu kutsuꞌ bra kanꞌ. Mdaꞌan yu yuu kutsuꞌ kanꞌ chunꞌ kiloo yu kwityiinꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Yaa jyaꞌaan kiloo seꞌen ndiꞌin yla tyiꞌa nde Siloé―. Nchkwiꞌ neꞌ kwa chaꞌ Siloé naan chku kanꞌ, ñaꞌan tiꞌ chkwianꞌ chaꞌtñan: Chku seꞌen nu ngulo tñan ꞌin neꞌ chaꞌ tsaa neꞌ. Kanꞌ chaꞌ yaa yu kwityiinꞌ kanꞌ, yaa mjyaꞌan yu kiloo yu tuꞌwa chku kanꞌ bra kanꞌ. Bra nu ndyaan yu xiyaꞌ bra kanꞌ, wa ngalaa kiloo yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Loꞌo neꞌ nu ndiꞌin kwiꞌ seꞌen ti seꞌen ndiꞌin nu ngwa kwityiinꞌ kanꞌ, neꞌ nu wa naꞌan chaꞌ mjñan yu lomstan nu ngwa xkanꞌ, ykwiꞌ neꞌ kanꞌ loꞌo taꞌa neꞌ chaꞌ ꞌin yu: ―Nu kiꞌyu re, ¿ta ti kwiꞌ yu re lka nu mdukwa tuꞌwa tuwiin mjñan yu lomstan ꞌin nten a? ");
INSERT INTO ctpNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","―Ti kwiꞌ kanꞌ lka ― ndukwin ska ta neꞌ. ―Siꞌi yu kanꞌ, ni siya suꞌwa ñaꞌan tloo yu re ―ndukwin xka ta neꞌ. Loꞌo mxkwen ti kwiꞌ nu kiꞌyu kanꞌ chaꞌ ꞌin neꞌ bra kanꞌ: ―Naꞌ lkaǎn nu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Kanꞌ mnichaꞌ neꞌ ꞌin yu: ―¿Ni sa ñaꞌan ngwa chaꞌ nchkaa kiloo ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","―Ska nten nu naan Jesús, kanꞌ lka nu mxtiyaaꞌ chinꞌ yuu kutsuꞌ chaꞌ taꞌan yu chunꞌ kiloǔn ―ndukwin―. Kanꞌ ngulo yu tñan ꞌñaǎn chaꞌ tsaꞌaǎn jyaꞌaǎn kiloǔn nde chku Siloé. Kanꞌ chaꞌ yiꞌaǎn mjyaꞌaǎn kiloǔn la kanꞌ, loꞌo bra ti ngalaa kiloǔn; suꞌwe ꞌa nda xaa kiloǔn ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","―¿La nde yaꞌ ndyaa yu kanꞌ a? ―ndukwin neꞌ ꞌin yu bra kanꞌ. ―Ja jlyo tiǎnꞌ ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndyaa loꞌo neꞌ ꞌin yu nu ngwa kwityiinꞌ kanꞌ seꞌen ndiꞌin neꞌ fariseo niꞌ lyaa. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tsan nu nxitñaꞌ neꞌ ngwa kanꞌ, kwiꞌ tsan kti ꞌa ngwa xa nu mxtiyaaꞌ Jesús yuu kutsuꞌ kanꞌ, yꞌni yu joꞌó kiloo yu kwityiinꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Kanꞌ chaꞌ mdyisnan neꞌ fariseo, mnichaꞌ neꞌ ꞌin nu ngwa kwityiinꞌ kanꞌ: ―¿Ni sa ñaꞌan ngwa chaꞌ nu nchkaa kiloo a? ―ndukwin neꞌ ꞌin yu. ―Mdaꞌan ska nten yuu kutsuuꞌ chunꞌ kiloǔn ―ndukwin yu kanꞌ―, kanꞌ yiꞌaǎn mjyaꞌaǎn kiloǔn, suꞌwe ꞌa nda xaa kiloǔn ni ―ndukwin bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Loꞌo ndiya chinꞌ neꞌ fariseo nu ykwiꞌ chaꞌ re: ―Siꞌi seꞌen ndiꞌin Ndiose mdoꞌo yu kanꞌ, kanꞌ chaꞌ ja nduwe tiꞌ yu ni siya kti ꞌa tsan taꞌa ni. Loꞌo ndiya xka ta nten nu ykwiꞌ chaꞌ re ꞌin yu: ―¿Ni ñaꞌan ka ra ꞌin yu kanꞌ kuꞌni yu chaꞌ tnun chabiyaꞌ ꞌin Ndiose si ndukwi ꞌa yu kiꞌya ngwañaꞌan a? Ja suꞌwa ykwiꞌ neꞌ kanꞌ chaꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xiyaꞌ mnichaꞌ neꞌ ꞌin nu ngwa kwityiinꞌ bra kanꞌ: ―Nuꞌwin ni, ¿ni sa ñaꞌan chaꞌ nchkwiiꞌ chaꞌ ꞌin yu kanꞌ, chunꞌ wa yꞌni yu joꞌó kiloo a? Mxkwen yu kanꞌ ꞌin neꞌ bra kanꞌ: ―Ska yu kula nu nchkwiꞌ chaꞌ ꞌin Ndiose loꞌo nten lka yu kanꞌ ―ndukwin yu nu ngwa kwityiinꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ja ndyaa ñaꞌan tiꞌ neꞌ judío kanꞌ, chaꞌ wa ñaꞌan kwityiinꞌ yu kanꞌ xa nu ngula yu, loꞌo ni, suꞌwe ꞌa nchkanꞌ naꞌan yu. Bra wa mdyii chaꞌ, msiꞌya neꞌ ꞌin sti yu loꞌo jyaꞌan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Kwiꞌ mnichaꞌ neꞌ ꞌin neꞌ kula kanꞌ: ―¿Ta sñiꞌ wan lka yu kwa a? ―ndukwin neꞌ―. ¿Ni sa ñaꞌan ngwa chaꞌ bra kanꞌ a? ¿Ta wa ñaꞌan kwityiinꞌ yu xa nu ngula yu a? ¿Ni sa ñaꞌan ngwa chaꞌ ngalaa kiloo yu ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mxkwen sti yu loꞌo jyaꞌan yu ꞌin neꞌ fariseo bra kanꞌ: ―Jlyo tiꞌ bare chaꞌ sñiꞌ ba lka yu, jlyo tiꞌ ba chaꞌ wa ñaꞌan kwityiinꞌ yu xa nu ngula yu ―ndukwin neꞌ―, ");
INSERT INTO ctpNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","loꞌo ja siyaꞌ ndiꞌya ba kwenta sa ñaꞌan ngwa chaꞌ ngalaa kiloo yu ni. Ja jlyo tiꞌ ba ti ka nu yꞌni joꞌó ꞌin yu. Kunichaꞌ wan ꞌin yu, ti ykwiꞌ ti yu; wa tlyu yu, ti kwiꞌ yu ka kitsaꞌ ñi yu ꞌwan sa ñaꞌan ngwa chaꞌ ngalaa kiloo yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ngwañaꞌan ndukwin sti loꞌo jyaꞌan yu nu ngwa kwityiinꞌ kanꞌ ꞌin neꞌ, chaꞌ ntsen ꞌa neꞌ ꞌin neꞌ judío kanꞌ. Jlyo tiꞌ neꞌ, chaꞌ neꞌ nu lka tñan ni, wa mskanꞌ neꞌ chaꞌ loꞌo taꞌa neꞌ chaꞌ kulo neꞌ ꞌin nten niꞌ lyaa, nchga nten nu chkwiꞌ chaꞌ Jesús lka Krixtu, nten nu tnun nchka nu msuꞌwa Ndiose chaꞌ mdiyan lo chalyuu; loꞌo ja ta ꞌa neꞌ judío kanꞌ chabiyaꞌ tsaa neꞌ kanꞌ niꞌ lyaa xiyaꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kanꞌ chaꞌ ndukwin sti jyaꞌan nu ngwa kwityiinꞌ kanꞌ: “Kunichaꞌ wan ꞌin yu, ti ykwiꞌ ti yu, wa tlyu yu”. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ti msiꞌya neꞌ fariseo kanꞌ ꞌin nu ngwa kwityiinꞌ kanꞌ xiyaꞌ. Kanꞌ lye ykwiꞌ neꞌ loꞌo: ―Chabiyaꞌ ꞌin Ndiose, chkwiiꞌ ska chaꞌ nu ñi loꞌo ba ni ―ndukwin neꞌ ꞌin yu―. Wa jlyo tiꞌ ba chaꞌ ndukwi ꞌa Jesús kanꞌ kiꞌya. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","―Ja ndiꞌyaǎn kwenta si ndukwi yu kiꞌya ―ndukwin nu ngwa kwityiinꞌ kanꞌ―. Jlyo tiǎnꞌ chaꞌ kwityiǐnꞌ nu ngwa xkanꞌ, loꞌo ni, wa ngalaa kiloǔn. Sa kanꞌ ti chaꞌ jlyo tiǎnꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","―¿Ni sa ñaꞌan yꞌni yu kanꞌ loꞌoo sikwa a? ―ndukwin neꞌ―. ¿Ni sa ñaꞌan tñan yꞌni yu chaꞌ nchkaa kiloo ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","―Wa ytsaǎnꞌ ꞌwan ska yaꞌ tsan, loꞌo ja ynan wan chaꞌ kanꞌ ―ndukwin yu kanꞌ―. ¿Ni chaꞌ lka nchka tiꞌ wan kunan wan chaꞌ kanꞌ xiyaꞌ a? ¿Ta loꞌo wan nchka tiꞌ wan kuꞌni xaꞌan wan chaꞌ ꞌin yu a? ―ndukwin yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ykwiꞌ neꞌ judío kanꞌ chaꞌ tiꞌí loꞌo yu bra kanꞌ: ―Nuꞌwin lka ska nu ngiꞌni xaꞌan chaꞌ ꞌin yu kanꞌ ―ndukwin neꞌ―, bare ngiꞌni xaꞌan ba chaꞌ ꞌin ayman Moisés. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ndyaa ñaꞌan tiꞌ ba chaꞌ ytsaꞌ Ndiose tyun chaꞌ ꞌin Moisés kanꞌ, loꞌo ja la jlyo tiꞌ ba la nde yaꞌ mdoꞌo Jesús kanꞌ mdiyan nde re ―ndukwin neꞌ fariseo. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mxkwen yu ꞌin neꞌ fariseo bra kanꞌ: ―¡Tnun ꞌa chaꞌ nchkwiꞌ wan loꞌoǔn ni! ―ndukwin yu―. La kwa ti nduun ska yu kiꞌyu nu tka yꞌni joꞌó kiloǔn, loꞌo ja jlyo tiꞌ wan la nde yaꞌ mdoꞌo yu mdiyan yu ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jlyo tianꞌ taꞌaan chaꞌ ja nnan Ndiose chaꞌ nu nchkwiꞌ nten xaꞌan loꞌo Ni; kunan Ni chaꞌ nu nchkwiꞌ nten nu kuꞌni kti, nten nu ngiꞌni nchga tñan nu kulo Ni ꞌin neꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ti bra nu mdyisnan chalyuu, ja ya ka kuꞌni nten chaꞌ kalaa kiloo ska nten nu kwityiinꞌ ti xa nu ngula yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ja ka ꞌin yu kanꞌ kuꞌni yu tñan kanꞌ si ja mdoꞌo yu seꞌen ndiꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","―Ska nu xaꞌan lkaa nuꞌwin, loꞌo nchka tiiꞌ kwaꞌuu chaꞌ joꞌo ꞌwa ―ndukwin neꞌ judío bra kanꞌ―. Ngwañaꞌan xaꞌaan ti bra nu ngulaa, kwiꞌ ngwañaꞌan xaꞌaan xa nguluu ―ndukwin neꞌ. Kanꞌ ngulo neꞌ ꞌin yu nu ngwa kwityiinꞌ kanꞌ, ja nda ꞌa neꞌ chabiyaꞌ kan yu niꞌ lyaa bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Loꞌo ynan Jesús chaꞌ wa ngulo neꞌ ꞌin yu kanꞌ niꞌ lyaa bra kanꞌ, kanꞌ chaꞌ xa nu ndyukwa taꞌa Jesús loꞌo yu xiyaꞌ, mnichaꞌ Jesús ꞌin yu bra kanꞌ: ―¿Ta wa ndyaa ñaꞌan tiiꞌ ꞌin ti kwiꞌ yu nu wa mdiyan lo chalyuu chaꞌ ka nten a? ―ndukwin Jesús ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","―¿Ti ka nu lka yu kanꞌ a?, yu kula ―ndukwin yu kanꞌ―. Nchka ꞌa tiǎnꞌ sñiǐn chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","―Wa naꞌan nuꞌwin ꞌin yu kanꞌ ―ndukwin Jesús―. Naꞌ lkaǎn nu kanꞌ, naꞌ nu nchkwiǐnꞌ loꞌoo ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Bra ti mduun xtyinꞌ yu tloo Jesús. ―Ndyaa ñaꞌan tiǎnꞌ ꞌiin, Xꞌnaǎn ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ykwiꞌ Jesús loꞌo bra kanꞌ: ―Wa ndijyaǎn lo chalyuu chaꞌ kuꞌni biyaǎnꞌ ꞌin nten, ti ka nu xñi chaꞌ ꞌñaǎn, ti ka nu ja xlyaa xñi chaꞌ ꞌñaǎn ―ndukwin Jesús―. Taǎn xaa nu xuꞌwi niꞌ kasiya ꞌin nten nu xñi chaꞌ ꞌñaǎn, ni siya sa ñaꞌan kwityiinꞌ ti neꞌ ndiꞌin neꞌ lo chalyuu; loꞌo tukuǔnꞌ kiloo nten nu ja xlyaa xñi chaꞌ ꞌñaǎn, ni siya suꞌwe ꞌa ngiꞌni neꞌ, nxkeꞌ tiꞌ neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Mduun chinꞌ neꞌ fariseo seꞌen ndiꞌin Jesús xa nu ykwiꞌ yu ngwañaꞌan. ―¿Ta kwityiinꞌ bare sikwa a? ―ndukwin neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","―Ja lka wan yu kiꞌya chalyuu si jlyo tiꞌ wan chaꞌ kwityiinꞌ wan ―ndukwin Jesús―. Chaꞌ nu nchkwiꞌ wan chaꞌ ka ñaꞌan wan, kanꞌ chaꞌ ñaꞌan ti ndukwi wan kiꞌya. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús ꞌin neꞌ judío bra kanꞌ―. Tsaa ꞌa ndyaꞌ loꞌoo seꞌen ndiꞌin slyaꞌ xa tla; bra nu ndaꞌan nten niꞌ lyoꞌoo kanꞌ, ska ti tuloꞌoo ndiꞌin chaꞌ sten neꞌ. Ska nten nu kuꞌni kunan, kanꞌ nu nchkwen chunꞌ loꞌoo, ngiten yu xka seꞌen bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tuloꞌoo ti ngiten nu lka xꞌnan slyaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nsuꞌwi lyo yu nu ndiꞌin kwan tuloꞌoo ꞌin xꞌnan slyaꞌ, kanꞌ chaꞌ nda yu chabiyaꞌ ꞌin yu kanꞌ sten yu niꞌ lyoꞌoo ―ndukwin Jesús―. Nsuꞌwi lyo slyaꞌ tyiꞌi xꞌnan iꞌ; xa nu nsiꞌya yu ꞌin slyaꞌ ꞌin yu, ndijyan iꞌ seꞌen ndiꞌin yu, ndaꞌan loꞌo yu ꞌin iꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Bra wa mdoꞌo nchga slyaꞌ chunꞌ loꞌoo, kanꞌ ndukwa loo la xꞌnan iꞌ, nde chunꞌ la ndijyan slyaꞌ ꞌin yu bra kanꞌ, chaꞌ nganan iꞌ nsiꞌya xꞌnan iꞌ ꞌin iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ja ndyoꞌo ñaꞌan iꞌ ꞌin xka la nten; xa nu nnan iꞌ chaꞌ nu nchkwiꞌ xka nten loꞌo iꞌ, xnan iꞌ bra kanꞌ, chaꞌ ja nsuꞌwi lyo iꞌ tyiꞌi xka nten. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kanꞌ ngwa ska chaꞌ kutsiꞌ ti nu ykwiꞌ Jesús loꞌo neꞌ, loꞌo ja ngwa biyaꞌ tiꞌ neꞌ sa ñaꞌan lka chaꞌ nu ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ykwiꞌ Jesús loꞌo neꞌ xiyaꞌ bra kanꞌ: ―Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan ni ―ndukwin Jesús―. Naꞌ lkaǎn sa ñaꞌan lka tuloꞌoo kanꞌ, chaꞌ ndukwaǎn tuloꞌoo seꞌen ngiten iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ja ndukwa slyaꞌ kanꞌ ꞌin nten nu yan ti kulo la, bra nu ti ji kaǎn, chaꞌ xkwiꞌ neꞌ kunan lka neꞌ kanꞌ; sa kuꞌ ti ngiꞌni neꞌ kunan nan nu nsuꞌwi ꞌin taꞌa nten neꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nu ndiꞌin tuloꞌoo ni, suꞌwe ꞌa ñaꞌansiin yu ꞌin slyaꞌ ꞌin yu; kwiꞌ ngwañaꞌan naꞌ, suꞌwe ꞌa ñaꞌansiǐn ꞌin nten ꞌñaǎn ―ndukwin Jesús―. Ka sten nten chaꞌ ꞌñaǎn chaꞌ ja tyukwa neꞌ chaꞌ kuxi bra kanꞌ. Ka neꞌ kanꞌ sa ñaꞌan lka slyaꞌ kanꞌ nu ndyaꞌan niꞌ lyoꞌoo, nu ndyoꞌo xiyaꞌ, kwiꞌ ndyiji suꞌwe nan nchku iꞌ, ngwañaꞌan ka nten ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Xkwiꞌ tñan kunan ngiꞌni neꞌ kwiñi kanꞌ ―ndukwin Jesús―. Ndaꞌan neꞌ kanꞌ chaꞌ kuꞌni ñuꞌun neꞌ ꞌin nten, chaꞌ kanaꞌ kasiya ꞌin nten kanꞌ; loꞌo naꞌ ni, wa ndijyaǎn chaꞌ taǎn chalyuu suꞌwe ꞌin nten, seꞌen ka tyiꞌin neꞌ tyukwi ti tiye neꞌ bra kanꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Suꞌwe ꞌa ñaꞌansiǐn ꞌin slyaꞌ ꞌñaǎn. Naꞌ xlyaǎn kajaǎn chaꞌ ja kaja slyaꞌ ꞌñaǎn, chaꞌ xkwiꞌ ndyaꞌan chaꞌ tiyeěn chaꞌ ꞌin iꞌ ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ska msu ti ni, ja ñaꞌansiin suꞌwe yu ꞌin slyaꞌ, xnan yu bra nu ñaꞌan yu chaꞌ ndijyan ska ꞌni tlá. Msu kanꞌ ja lka yu xꞌnan slyaꞌ, siꞌi ti kwiꞌ yu nu lka ꞌin iꞌ. Kanꞌ chaꞌ kuꞌni tiꞌí ꞌni tlá ꞌin ñaꞌaan ta slyaꞌ kanꞌ; tijyuꞌ xnan slyaꞌ, kanaꞌ yuꞌwi iꞌ bra kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nxnan msu tijyuꞌ chaꞌ tñan ꞌin nten ti ndaꞌan yu, siꞌi slyaꞌ ꞌin yu lka iꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Suꞌwe ꞌa ñaꞌansiǐn ꞌin slyaꞌ ꞌñaǎn. Kwiꞌ ngwañaꞌan, nsuꞌwi lyoǔn ꞌin nten ꞌñaǎn, loꞌo wa ndyaꞌan tiꞌ nten kanꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Sa ñaꞌan nu nsuꞌwi lyo Stiǐn ꞌñaǎn, kwiꞌ ngwañaꞌan nsuꞌwi lyoǔn ꞌin Stiǐn; sa ñaꞌan nu ndiꞌin chaꞌ ꞌñaǎn loꞌo Stiǐn, ngwañaꞌan ndiꞌin chaꞌ ꞌñaǎn loꞌo nten ꞌñaǎn. Loꞌo naꞌ, xlyaǎn kajaǎn chaꞌ ja kanaꞌ kasiya ꞌin nten ꞌñaǎn ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ti ndiya tyun ꞌa ta nten ꞌñaǎn nu ndiꞌin kaꞌan ꞌa kichen, nu ja suꞌwa ndiꞌin loꞌo ñaꞌaan ta nten re; ndiꞌin chaꞌ tsaꞌaǎn tiꞌiǐn ꞌin neꞌ kanꞌ, chaꞌ loꞌo neꞌ kanꞌ kan neꞌ niꞌ lyoꞌoo re. Chunꞌ ndiꞌin la kunan neꞌ kanꞌ chaꞌ nu chkwiǐnꞌ loꞌo neꞌ. Kanꞌ ka nchga nten ꞌñaǎn ska ta ti neꞌ, loꞌo naꞌ kaǎn skaǎn tiǎn nu nka Xꞌnan neꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Tsaa tii chalyuu ꞌñaǎn kajaǎn, chaꞌ tyuꞌuǔn xiyaꞌ chunꞌ ndiꞌin la, kanꞌ chaꞌ nsuꞌwi ꞌa tiye Stiǐn ñaꞌan Ni ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ja tukwin ka kujwi ꞌñaǎn, ti ykwiǐnꞌ tiǎn xlyaǎn kajaǎn ―ndukwin Jesús―. Ka kuꞌniǐn ngwañaꞌan, chaꞌ wa nda Stiǐn Ndiose chabiyaꞌ kajaǎn; kwiꞌ ngwañaꞌan, nda Ni chabiyaꞌ chaꞌ tyuꞌuǔn xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Xiyaꞌ ja ngwa kuꞌni suꞌwa neꞌ judío chaꞌ loꞌo taꞌa neꞌ, chaꞌ nu ykwiꞌ Jesús ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ndiya ꞌa neꞌ nu ykwiꞌ chaꞌ re: ―Ñaꞌan tiꞌ ska kuneꞌ xaꞌan, ngwañaꞌan ngiꞌni yu kwa. Wa mnaꞌ chaꞌ tiya ꞌin yu. Ja ndiꞌin chaꞌ kunaan chaꞌ nu nchkwiꞌ yu kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Loꞌo ykwiꞌ xka ta nten: ―Ja ngwa chkwiꞌ yu kwa ngwañaꞌan, si nsuꞌwi kwiꞌin xaꞌan ꞌin yu. ¿Ta ka ꞌin ska kuneꞌ xaꞌan kuꞌni chaꞌ chkaa kiloo nu kwityiinꞌ a? Ja ka ꞌin. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tyempu tlyaꞌ ngwa kanꞌ, nu xuwe ꞌa tsan. Nde kichen Jerusalén ngiꞌni tnun neꞌ taꞌa nu nkwan laa tnun nde kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ndyaa Jesús tuꞌwa laa, la seꞌen nchkwiꞌ neꞌ: Corredor ꞌin Salomón. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Kanꞌ ndyoꞌ tiꞌin tyun neꞌ judío seꞌen ndiꞌin Jesús, mnichaꞌ neꞌ ꞌin yu bra kanꞌ: ―¿Ni ñaꞌan bra chkwiiꞌ ñi loꞌo ba, chaꞌ ka biyaꞌ tiꞌ ba si nuꞌwin lkaa nten nu tnun nchka nu suꞌwa Ndiose chaꞌ kaan? ―ndukwin neꞌ ꞌin Jesús―. Ja talo ba si ja katsaaꞌ nchga chaꞌ kanꞌ ꞌwa. Suꞌwe la si chkwiiꞌ chaꞌ nu ñi ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","―Ngwañaꞌan niǐn ꞌwan ska yaꞌ ―ndukwin Jesús ꞌin neꞌ kanꞌ bra kanꞌ―, loꞌo ja siyaꞌ ndyaa ñaꞌan tiꞌ wan chaꞌ nu ykwiǐnꞌ loꞌo wan nu ngwa xkanꞌ ―ndukwin―. Bra nu ñaꞌan wan chaꞌ tnun nu ngiꞌniǐn chabiyaꞌ ꞌin Stiǐn, ka biyaꞌ suꞌwe tiꞌ wan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ja ndyaa ñaꞌan tiꞌ wan chaꞌ tnun kanꞌ, chaꞌ siꞌi nten ꞌñaǎn lka wan. Ngwañaꞌan niǐn ꞌwan nu ngwa xkanꞌ ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sa ñaꞌan nnan slyaꞌ chaꞌ nchkwiꞌ xꞌnan iꞌ, ngwañaꞌan nganan nten ꞌñaǎn xa nu nchkwiǐnꞌ loꞌo neꞌ. Nsuꞌwi lyoǔn ꞌin neꞌ kanꞌ, ndaꞌan neꞌ loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ja tsaa tii ꞌa chalyuu nu taǎn ꞌin neꞌ kanꞌ, ja kanaꞌ kasiya ꞌin neꞌ kanꞌ. Loꞌo ja tukwin ꞌa ka kulaa ꞌin neꞌ nu nsuꞌwi yaǎnꞌ, chaꞌ suꞌwe ꞌa ñaꞌansiǐn ꞌin neꞌ kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nan wa nda Stiǐn ꞌin nten kanꞌ chaꞌ ka neꞌ nten ꞌñaǎn, loꞌo ja ndiya xka nu tlyu la ke Ndiose; kanꞌ chaꞌ niǐn ꞌwan chaꞌ ja tukwin ka kulaa ꞌin nten ꞌñaǎn, chaꞌ nu Stiǐn ñaꞌansiin Ni ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Kwiꞌ ngwañaꞌan suꞌwa ndiꞌin chaꞌ ꞌin Stiǐn Ndiose loꞌoǔn ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Loꞌo xiyaꞌ msñi neꞌ judío kanꞌ kee chaꞌ kuun neꞌ ꞌin Jesús, chaꞌ kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kanꞌ chaꞌ ykwiꞌ yu loꞌo neꞌ kanꞌ: ―Wa kaꞌan ꞌa tñan suꞌwe yꞌniǐn chabiyaꞌ ꞌin Stiǐn seꞌen ndiꞌin wan, kwiꞌ ngwañaꞌan, wa naꞌan wan chaꞌ tnun nu yꞌniǐn. ¿Ta siꞌya ska tñan suꞌwe nu yꞌniǐn, kanꞌ chaꞌ nchka tiꞌ wan kuun kee wan ꞌñaǎn ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mxkwen neꞌ judío kanꞌ ꞌin Jesús bra kanꞌ: ―Ja kujwi ba ꞌiin loꞌo kee siꞌya ska tñan suꞌwe nu yꞌnii ―ndukwin neꞌ―; siꞌya chaꞌ kuxi nu nchkwiiꞌ ꞌin Ndiose, kanꞌ chaꞌ kuun kee ba ꞌiin. Sñiꞌ nten chalyuu lkaa, loꞌo nuꞌwin ngiꞌnii chaꞌ Ndiose lkaa. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Xiyaꞌ ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Lo kityi seꞌen ndukwa chaꞌ kula nu ndyaa ñaꞌan ꞌa tiꞌ wan, ndiya chaꞌ re nu ykwiꞌ Ndiose: “Nchga wan lka wan ndiose”; ngwañaꞌan nchkwiꞌ kityi. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Loꞌo ni―ndukwin Jesús―, jlyo tianꞌ chaꞌ ja ka ꞌñaan tukuanꞌ ska chaꞌ nu wa ykwiꞌ Ndiose loꞌoan. Ndiya yaꞌ nchkwiꞌ kityi kanꞌ chaꞌ ñaꞌan tiꞌ ndiose, ngwañaꞌan lka nten nu kunan chaꞌ nu chkwiꞌ Ni loꞌo. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Ni chaꞌ lka mstya wan kiꞌya ꞌñaǎn tloo Ndiose sikwa a?, chaꞌ nu ndukwin wan chaꞌ kuxi ꞌa nchkwiǐnꞌ ꞌin Ndiose ―ndukwin Jesús―. Wa ngulo suwi Stiǐn ꞌñaǎn, msuꞌwa Ni ꞌñaǎn chaꞌ mdiyaǎn lo chalyuu. ¿Ni chaꞌ lka nxkeꞌ tiꞌ wan chaꞌ ja suꞌwe chaꞌ nu ykwiǐnꞌ, chaꞌ skaǎn tiǎn lkaǎn Sñiꞌ Ndiose a? ");
INSERT INTO ctpNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ngiꞌniǐn nchga tñan nu ngiꞌni Stiǐn ―ndukwin Jesús bra kanꞌ―. Si ja ngiꞌniǐn ꞌin ran, ja ndiꞌin chaꞌ tsaa ñaꞌan tiꞌ wan ꞌñaǎn sikwa ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Loꞌo ni, ka tsaa ñaꞌan tiꞌ wan chaꞌ tnun nu ngiꞌniǐn, chunꞌ ngiꞌniǐn ti kwiꞌ tñan nu ngiꞌni Ndiose, ni siya ja tsaa ñaꞌan tiꞌ wan chaꞌ nu nchkwiǐnꞌ. Kanꞌ chaꞌ ka biyaꞌ tiꞌ wan, ka jlyo tiꞌ wan, chaꞌ ska ti chaꞌ ꞌñaǎn loꞌo Stiǐn; kwiꞌ ngwañaꞌan ska ti chaꞌ ꞌin Stiǐn loꞌoǔn. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Xiyaꞌ ngwa tiꞌ neꞌ judío xñi neꞌ ꞌin Jesús. Loꞌo ja nganun ꞌa yu yaꞌ neꞌ, mdijin yu laja nten, mdoꞌo yu ndyaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kanꞌ chaꞌ ndyaa Jesús xka laꞌa tsuꞌ chku Jordán xiyaꞌ, nde seꞌen mduun Xuwa mdukwatya ꞌin neꞌ nu ngwa ti kulo. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nde kanꞌ mdiꞌin yu, loꞌo kaꞌan ꞌa nten mdaꞌan seꞌen ndiꞌin yu. Ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―Ja ska chaꞌ tnun yꞌni Xuwa chaꞌ kuwe tianꞌ ꞌin yu. Loꞌo chañi chaꞌ wa ndyaa toꞌo nchga chaꞌ nu ykwiꞌ Xuwa kanꞌ nu ngwa sꞌni chaꞌ ꞌin yu kula re. ");
INSERT INTO ctpNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Loꞌo tyun nten ndyaa ñaꞌan tiꞌ neꞌ ꞌin Jesús xa nu mdiꞌin neꞌ la kwa. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ndiya ska yu kiꞌyu nu naan Lázaro. Tiꞌí ꞌa yu kanꞌ. Neꞌ kichen Betania lka yu, loꞌo Liya loꞌo Marta lka taꞌa ngula yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ti kwiꞌ Liya kanꞌ, taꞌa ngula yu tiꞌí kanꞌ, kanꞌ lka nu suꞌwa sete xi tyiꞌi chunꞌ kiyaꞌ Jesús nde loo la, kwiꞌ suweꞌ kichanꞌ ke ykwiꞌ kiyaꞌ Jesús chaꞌ kityi ran. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Taꞌa tyukwaa nu kunaꞌan kanꞌ msuꞌwa rsun ndyaa seꞌen ndiꞌin Jesús: ―Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa, Xꞌnan ba ―ndukwin nu kunaꞌan kanꞌ―, nde ndijyan chaꞌ, chaꞌ ka biyaꞌ tiiꞌ chaꞌ tiꞌí ꞌa yu taꞌa suꞌwee nsuꞌwii, nskwa yu niꞌ ñaꞌan tyi ba. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Xa wa ynan Jesús chaꞌ kanꞌ, ykwiꞌ yu bra kanꞌ: ―Ja ndiꞌin chaꞌ kaja yu tiꞌí kanꞌ. Nan tiꞌí yu kanꞌ ni, chaꞌ ka tlyu la Ndiose chunꞌ ndiꞌin la, xa nu kuꞌni tnun nten ꞌñaǎn chaꞌ skaǎn tiǎn lkaǎn nu lka Sñiꞌ Ndiose. Bra nu ñaꞌan nten chaꞌ tnun nu kuꞌniǐn chaꞌ ka joꞌó ꞌin yu, kuꞌni tnun neꞌ ꞌin Ndiose bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Xa wa ynan Jesús chaꞌ tiꞌí Lázaro, ti nganun yu tyukwa tsan seꞌen ndiꞌin yu bra kanꞌ, ni siya nsuꞌwi ꞌa tiye yu ꞌin taꞌa snan neꞌ kanꞌ, loꞌo Marta, loꞌo nu kunaꞌan taꞌa ngula, loꞌo ti kwiꞌ Lázaro. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Chunꞌ ndiꞌin la, ykwiꞌ Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu bra kanꞌ: ―Tyaan lo yuu ꞌin Judea xiyaꞌ ―ndukwin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mxkwen neꞌ ꞌin yu bra kanꞌ: ―Mstru ―ndukwin neꞌ―, ja sꞌni lye ngwa tiꞌ neꞌ judío kanꞌ kuun kee neꞌ ꞌiin chaꞌ kujwi neꞌ ꞌiin, nka tiye neꞌ. ¿Loꞌo xiyaꞌ wa tsaa ni a? ―ndukwin neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Kanꞌ ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―¿Ta siꞌi tii tyukwa bra nsuꞌwi ska tsan a? Bra nu tyaꞌaan tikeeꞌ kwan ni, ja ska nan tyukwa kiyaanꞌ, chaꞌ ka ñaꞌaan seꞌen ndaꞌaan chaꞌ ti xaa ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Loꞌo bra nu ndaꞌaan tla, ya ñaꞌan ti nan nu nsu tuwiin tyukwa kiyaanꞌ, chaꞌ ja nsuꞌwi xaa ñaꞌaan ꞌin ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Chunꞌ ndiꞌin la, xiyaꞌ ykwiꞌ Jesús: ―Lajaꞌ Lázaro taꞌa suꞌweěn nsuꞌwiǐn. Nde kwa tsaꞌaǎn ni, chaꞌ xkwiǐn ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","―Mstru ―ndukwin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―, si nu lajaꞌ ti yu, bra ti chkaa yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mskeꞌ tiꞌ neꞌ chaꞌ nu yuꞌwi sla yu tiꞌí kanꞌ, ni siya ngwa tiꞌ Jesús nchkwin ꞌin neꞌ chaꞌ chañi chaꞌ ngujwi Lázaro. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ñi la ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Wa ngujwi Lázaro ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Loꞌo suꞌwe nka tiyeěn chaꞌ ja mdiꞌiǐn nde kwa bra nu ngujwi yu. Ja chan ka tsaa toꞌo suꞌwe la chaꞌ ꞌwan, kwiꞌ sten suꞌwe la wan chaꞌ ꞌñaǎn chunꞌ nu ngwañaꞌan ngwa ꞌin yu kanꞌ ―ndukwin―. Tyaan seꞌen nskwa ayman ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kanꞌ ykwiꞌ Toma loꞌo taꞌa ngiꞌni xaꞌan yu, ti kwiꞌ Toma nu ngula tukwa loꞌo taꞌa: ―Tyaan loꞌo yu kula sikwa, chaꞌ suꞌwa ti kajaan loꞌo yu ―ndukwin Toma. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Xa wa mdiyan Jesús la kwa, ytsaꞌ neꞌ ꞌin yu chaꞌ wa ndiya jakwa tsan mtsiꞌ ayman Lázaro. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Loꞌo ja tijyuꞌ kichen Betania kanꞌ ꞌin kichen Jerusalén, tukwa kilómetro jluꞌwe, sa kwa ti tijyuꞌ ndyoꞌo loꞌo kichen kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Kanꞌ chaꞌ kaꞌan neꞌ kichen tnun ndyaa neꞌ chaꞌ tayaꞌ neꞌ ꞌin Marta loꞌo Liya chaꞌ ngujwi taꞌa ngula neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Bra wa ynan neꞌ chaꞌ wa mdiyan Jesús, bra ti mdoꞌo Marta ndyaa chaꞌ tyukwa taꞌa loꞌo Jesús tuwiin. Ska ti Liya nganun niꞌ ñaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Kanꞌ ykwiꞌ Marta loꞌo Jesús: ―Ja ngujwi taꞌa ngulaǎn si mdiꞌiin nde re nu ngwa ti kwiꞌyu ti, neꞌ kula ―ndukwin nu kunaꞌan kanꞌ ꞌin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jlyo tiǎnꞌ chaꞌ ni siya ni, ti ka ꞌin Ndiose kuꞌni Ni ya ñaꞌan ti chaꞌ nu jñaan ꞌin Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Mxkwen Jesús ꞌin Marta bra kanꞌ: ―Tyuꞌu taꞌa ngulaa xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","―Jlyo tiǎnꞌ chaꞌ xiyaꞌ tyuꞌu yu kanꞌ xa nu tyuꞌu nchga ayman, bra nu tsaa tii chalyuu ―ndukwin Marta ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","―Naꞌ lkaǎn nu ngiꞌniǐn chaꞌ tyuꞌu nten xiyaꞌ ―ndukwin Jesús ꞌin Marta―, naꞌ lkaǎn nu ngiꞌniǐn chaꞌ chañi kaja chalyuu kwi ꞌin neꞌ ―ndukwin yu―. Ni siya kaja neꞌ, ti tyuꞌu neꞌ kanꞌ xiyaꞌ, kaja chalyuu kwi ꞌin neꞌ xa nu wa yten neꞌ chaꞌ ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Loꞌo nchga nten nu suꞌwe ti ndiꞌin tiye neꞌ chaꞌ wa yten neꞌ chaꞌ ꞌñaǎn, ja ndiꞌin ꞌa chaꞌ kaja neꞌ kanꞌ. ¿Ta wa ndyaa ñaꞌan tiiꞌ chaꞌ re a? ");
INSERT INTO ctpNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","―Chañi chaꞌ ndyaa ñaꞌan tiǎnꞌ ꞌiin, neꞌ kula ―ndukwin nu kunaꞌan kanꞌ―. Loꞌo ni, wa ndyaa ñaꞌan tiǎnꞌ ꞌiin chaꞌ nuꞌwin lkaa Krixtu, nten nu tnun nchka kanꞌ, loꞌo nuꞌwin lkaa skaa tii nu lka Sñiꞌ Ndiose ykwiꞌ; kwiꞌ ngwañaꞌan, wa msuꞌwa Ndiose ꞌiin ndijyaan lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mdyii ykwiꞌ Marta ndyaa bra kanꞌ, mnan ti msiꞌya ꞌin Liya taꞌa ngula: ―Wa kala ti Mstru ꞌñaan nde re ―ndukwin―. Nxiꞌya yu ꞌiin chaꞌ tsaa seꞌen ndiꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Bra nu ynan Liya chaꞌ kanꞌ, bra ti mdoꞌo ndyaa seꞌen ndiꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ti ji kala Jesús kichen, ti ndukwa yu seꞌen ndyukwa taꞌa Marta loꞌo yu ti kulo la. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Loꞌo neꞌ judío nu mdiyan chaꞌ tayaꞌ ꞌin Liya niꞌ ñaꞌan ni, xa wa naꞌan neꞌ chaꞌ bra ti mdoꞌo Liya ndyaa, mdoꞌo ñaꞌan neꞌ ꞌin bra kanꞌ, chunꞌ mskeꞌ tiꞌ neꞌ chaꞌ tuꞌwa kwaa ndyaa chaꞌ kunan. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Loꞌo mdiyan Liya seꞌen ndiꞌin Jesús. Bra nu naꞌan ꞌin Jesús, bra ti mduun xtyinꞌ tloo yu. Ykwiꞌ Liya loꞌo bra kanꞌ: ―Si mdiꞌiin nu ngwa ti kwiꞌyu ti ni, neꞌ kula ―ndukwin―, ja ngujwi taꞌa ngulaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tyukwi ti tiye Jesús xiꞌin ꞌa tiꞌ yu bra kanꞌ, yuwe ꞌa tiꞌ yu chaꞌ nganan Liya, kwiꞌ nganan ꞌa neꞌ judío taꞌa ndaꞌan Liya. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Mnichaꞌ Jesús ꞌin neꞌ bra kanꞌ: ―¿La nde yaꞌ mtsiꞌ wan ꞌin ayman kanꞌ a? ―Kaan naꞌaan chinꞌ ꞌin yu, neꞌ kula ―ndukwin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Loꞌo Jesús, ynan yu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","―Mdiya ꞌa tiꞌ Jesús ꞌin ayman kanꞌ, yuꞌwi ꞌa tiye yu ꞌin ayman kanꞌ ―ndukwin neꞌ judío bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Loꞌo ndiya chinꞌ nten nu ndukwin: ―¿Ni chaꞌ lka ja yꞌni yu chaꞌ tyuꞌu Lázaro kwa nu ngwa ti kwiꞌyu ti a? Nchka ꞌin yu kuꞌni yu chaꞌ chkaa kiloo neꞌ kwityiinꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Lye ꞌa ngwa xiꞌin tiꞌ Jesús xiyaꞌ, kanꞌ ndyaa yu tuꞌwa kwaa. Ska tukee lka ran, loꞌo nduun ska kee tlyu nu nchkunꞌ tuꞌwa kwaa kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","―Kulo tsuꞌ wan kee kwa ―ndukwin Jesús bra kanꞌ. Bra ti ykwiꞌ Marta taꞌa ngula ayman kanꞌ loꞌo Jesús: ―Tukun ꞌa tyiꞌi ka si nu tyoꞌo tsuꞌ kee kwa, neꞌ kula ―ndukwin―. Wa mdaꞌa jakwa tsan mtsiꞌ ayman re. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Loꞌo ykwiꞌ Jesús bra kanꞌ: ―¿Ta siꞌi wa niǐn ꞌwan chaꞌ bra nu tsaa ñaꞌan tiꞌ wan ꞌin Ndiose, bra kanꞌ ñaꞌan wan chaꞌ tnun nu kuꞌni Ni a? ");
INSERT INTO ctpNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ngulo tsuꞌ neꞌ kee nu nchkunꞌ tuꞌwa kwaa bra kanꞌ. Loꞌo mxinaꞌan Jesús niꞌ kwan bra kanꞌ. ―Stiǐn ―ndukwin Jesús ꞌin Ndiose―, ngwa xuꞌwe ꞌiin chaꞌ wa ynaan chaꞌ nu ykwiǐnꞌ loꞌoo. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nchga tsan jlyo tiǎnꞌ chaꞌ nnaan nchga chaꞌ nu nchkwiǐnꞌ loꞌoo; kanꞌ chaꞌ chkwiǐnꞌ loꞌoo ni, chaꞌ ꞌin nten nu ndiꞌin re, chaꞌ ka tsaa ñaꞌan tiꞌ neꞌ ꞌñaǎn chaꞌ nu chañi chaꞌ wa msuꞌwaa ꞌñaǎn ndijyaǎn lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kwen ꞌa ykwiꞌ Jesús bra kanꞌ: ―¡Lázaro, tyoꞌoo lyaa nde liyaꞌ re! ");
INSERT INTO ctpNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mdoꞌo nu ngwa ayman bra kanꞌ; ti mxiin teꞌ ngaten ñaꞌaan chunꞌ yu, kwiꞌ nchkunꞌ xka teꞌ tloo yu. ―Xtiꞌ lya wan teꞌ nu mxiin chunꞌ yu kwa ―ndukwin Jesús ꞌin neꞌ―, ta wan chabiyaꞌ tyaꞌan suꞌwe yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Kaꞌan ꞌa neꞌ judío nu ndiꞌin ndayaꞌ ꞌin Liya ti tsan, ndyaa ñaꞌan tiꞌ neꞌ ꞌin Jesús bra kanꞌ, chunꞌ wa naꞌan neꞌ chaꞌ tnun nu tka yꞌni ti Jesús chabiyaꞌ ꞌin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ndiya chinꞌ neꞌ kanꞌ nu bra ti ndyaa neꞌ seꞌen ndiꞌin neꞌ fariseo, ytsaꞌ neꞌ ꞌin neꞌ sa ñaꞌan nu yꞌni Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kanꞌ chaꞌ sti joꞌo nu nka ndloo, loꞌo neꞌ fariseo kanꞌ, mdyisnan neꞌ msiꞌya neꞌ ꞌin taꞌa lka neꞌ tñan chaꞌ tyoꞌ tiꞌin neꞌ. Xa wa mdiyan neꞌ ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―¿Ni ñaꞌan kuꞌnian ni a? ―ndukwin neꞌ―. Kaꞌan ꞌa chaꞌ tnun ngiꞌni yu kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si taan chabiyaꞌ ꞌin yu chaꞌ ti kuꞌni la yu ngwañaꞌan, xñi nchga neꞌ kichen chaꞌ ꞌin yu bra kanꞌ. Loꞌo kan neꞌ romano chaꞌ kuꞌni tyii neꞌ laa tnun ꞌñaan bra kanꞌ, kulo neꞌ ꞌin nchgaan loꞌo taꞌaan seꞌen ndiꞌian bra kanꞌ ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Loꞌo mdyituun ska yu nu naan Caifás. Yijan kanꞌ lka yu xꞌnan sti joꞌo. Ykwiꞌ yu loꞌo neꞌ kanꞌ bra kanꞌ: ―Ja ska chaꞌ jlyo tiꞌ wan, ");
INSERT INTO ctpNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ja ndii tiꞌ wan siyaꞌ ti ―ndukwin yu―. Suꞌwe la ka ꞌwan ni siya kaja ska ti nten, chaꞌ ja kaja nchga neꞌ taꞌa kichen tyian. Kuxi la ka chaꞌ si kuꞌni tyii neꞌ ñaꞌaan nasiyun re. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Loꞌo siꞌi chaꞌ nu ngulo ke yu, ti ykwiꞌ ti yu, chaꞌ nu ykwiꞌ yu ngwañaꞌan. Yijan kanꞌ ngwa yu xꞌnan sti joꞌo, kanꞌ chaꞌ ndukwin yu ngwañaꞌan. Chabiyaꞌ ꞌin Ndiose ykwiꞌ yu loꞌo neꞌ, sa ñaꞌan chaꞌ nu ka ꞌin Jesús nde loo la, bra nu kaja yu lo wsi. Siꞌi chaꞌ ꞌin neꞌ judío ti kaja Jesús; ");
INSERT INTO ctpNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","kaja yu chaꞌ ꞌin nchga nten chalyuu, chaꞌ suꞌwa ti ka tiye nchga nten nu ndyaa ñaꞌan tiꞌ ꞌin Ndiose, ti kwiꞌ nten nu ngulo suwi Ndiose ꞌin chaꞌ ka sñiꞌ Ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kanꞌ chaꞌ mdyisnan neꞌ ykwiꞌ neꞌ nu loꞌo taꞌa lka tñan neꞌ sa ñaꞌan ka kujwi neꞌ ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Loꞌo mdoꞌo Jesús lo yuu kanꞌ; ja ndyaa ꞌa yu seꞌen ndiꞌin neꞌ judío, ndyaa yu xka lo yuu seꞌen tijyuꞌ la chinꞌ, tuꞌwa yuu wtyi. Ngala yu ska kichen seꞌen naan Efraín bra kanꞌ, la kanꞌ mdiꞌin Jesús loꞌo neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Wa tiya ti taꞌa pascua, kanꞌ lka ska taꞌa ꞌin neꞌ judío nde Jerusalén. Kaꞌan neꞌ mdoꞌo neꞌ kichen tyi neꞌ, ni siya kichen niꞌ kixinꞌ, mdiyan neꞌ kichen Jerusalén bra kanꞌ. Bra ti yꞌni luwi neꞌ tyukwi ñaꞌaan neꞌ chaꞌ ka kuꞌni tnun neꞌ ꞌin Ndiose, xa nu ti ji ka taꞌa. ");
INSERT INTO ctpNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Loꞌo ndyaa naꞌan neꞌ si ndiꞌin Jesús. Bra nu ndiꞌin neꞌ niꞌ lyaa, ykwiꞌ neꞌ loꞌo taꞌa neꞌ bra kanꞌ: ―¿Ni ñaꞌan chaꞌ ka, xkeꞌ tiꞌ wan a? ―ndukwin neꞌ―. ¿Ta kan yu taꞌa, xkeꞌ tiꞌ wan a? ");
INSERT INTO ctpNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nduwe ꞌa tiꞌ neꞌ chaꞌ loꞌo sti joꞌo nu nka ndloo kanꞌ, loꞌo neꞌ fariseo, wa ngulo neꞌ tñan ꞌin nchga neꞌ kichen; ndukwin sti joꞌo chaꞌ bra nu kaja chaꞌ ꞌin neꞌ la nde yaꞌ ndiꞌin Jesús, bra ti ndiꞌin chaꞌ katsaꞌ neꞌ ꞌin neꞌ nu nka ndloo. Tsaa yu xta chaꞌ xñi neꞌ ꞌin Jesús bra kanꞌ, nchka tiꞌ neꞌ nu nka ndloo kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ti ji xa xkwa tsan chaꞌ ka taꞌa pascua, mdiyan Jesús kichen Betania xiyaꞌ bra kanꞌ. Betania lka kichen tyi Lázaro nu ngujwi nu ngwa xkanꞌ, loꞌo bra kanꞌ yꞌni Jesús chaꞌ ndyuꞌu yu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yꞌni neꞌ kanꞌ ska siin chaꞌ kuꞌni tnun neꞌ ꞌin Jesús bra kanꞌ, chaꞌ suꞌwe ꞌa nka tiye neꞌ chaꞌ mdiyan yu seꞌen ndiꞌin neꞌ. Marta yꞌni xuꞌwe nan nchku neꞌ bra kanꞌ, loꞌo suꞌwa ndukwa Lázaro loꞌo neꞌ seꞌen nchku siin neꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kanꞌ mdiyan Liya loꞌo ska kwartu sete xi tyiꞌi. Kaꞌan ꞌa nsuꞌwi lyo sete kanꞌ ni, chaꞌ xkwiꞌ sete yka nardo lka ran. Mslu Liya sete kanꞌ chunꞌ kiyaꞌ Jesús bra kanꞌ, loꞌo kichanꞌ ke Liya mxtyi kiyaꞌ yu; nchga niꞌ ñaꞌan mskwa xi tyiꞌi sete kanꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Loꞌo mdiꞌin Juda sñiꞌ Simón Iscariote loꞌo neꞌ, chaꞌ nten nu ngiꞌni xaꞌan chaꞌ ꞌin Jesús ngwa yu. Ti kwiꞌ kanꞌ ngwa nu kuꞌni trisiyun ꞌin Jesús loꞌo neꞌ xaꞌan chunꞌ ndiꞌin la. Naꞌan Juda kanꞌ sa ñaꞌan tñan nu yꞌni Liya, kanꞌ chaꞌ lye ꞌa ykwiꞌ yu bra kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Ni chaꞌ lka ja ngwa kiyaꞌ sete xi tyiꞌi ꞌin nu kunaꞌan kwa, chaꞌ kaja tñi nu tayaꞌ ꞌin neꞌ tiꞌi a? ―ndukwin Juda kanꞌ―. Ja chan kaja snan siyentu tñi plata loꞌo sete kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Chaꞌ ngwa Juda ska nu ngiꞌni kunan, kanꞌ chaꞌ ndukwin yu ngwañaꞌan; siꞌi chaꞌ nchka tꞌnan tiꞌ yu ꞌin neꞌ tiꞌi. Ti kwiꞌ Juda mdiꞌya loo yu kwijin seꞌen nsuꞌwi tñi ꞌin yu taꞌa ndaꞌan Jesús, loꞌo yꞌni Juda kunan tñi nu nsuꞌwi ꞌin nchga neꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","―Ta wan chabiyaꞌ kuꞌni nu kunaꞌan re ngwañaꞌan ―ndukwin Jesús―. Wa mchkwan neꞌ re sete kanꞌ chaꞌ kunanjoꞌo ꞌin neꞌ xa nu tiya bra chaꞌ kutsiꞌ neꞌ ꞌñaǎn ―ndukwin―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nchga bra ndiꞌin nu tiꞌi loꞌo wan lo chalyuu re, ya ñaꞌan ti tsan ka tayaꞌ wan ꞌin neꞌ kanꞌ; loꞌo naꞌ ni, ja tyiꞌiǐn ꞌaǎn tyun tsan seꞌen ndiꞌin wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wa mjwi rsun ꞌin neꞌ chaꞌ ndiꞌin Jesús kichen Betania, kanꞌ chaꞌ ndyaa kaꞌan neꞌ judío, sa tlyu ti ndyaa naꞌan neꞌ ꞌin Jesús. Ngwa tiꞌ neꞌ kanꞌ ñaꞌan neꞌ ꞌin nu ngwa ayman Lázaro kanꞌ, nu yꞌni Jesús chaꞌ ndyuꞌu xiyaꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Loꞌo nchga sti joꞌo nu nka ndloo mskanꞌ neꞌ chaꞌ loꞌo taꞌa neꞌ, chaꞌ loꞌo ꞌin Lázaro kujwi neꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","chaꞌ wa ndyuꞌu Lázaro xiyaꞌ, kanꞌ chaꞌ kaꞌan ꞌa neꞌ judío msñi neꞌ chaꞌ ꞌin Jesús, ngulaa yaꞌ neꞌ kanꞌ ꞌin sti joꞌo bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kaꞌan ꞌa nten ndiꞌin taꞌa kanꞌ. La xka tsan, ynan neꞌ chaꞌ ndijyan Jesús nde Jerusalén; kanꞌ chaꞌ mdoꞌo neꞌ ndyaa neꞌ sa tlyu ti chaꞌ tyukwa taꞌa neꞌ loꞌo Jesús tuwiin. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ndyaa loꞌo neꞌ lkaꞌ kiñan, loꞌo kwen ꞌa msiꞌya neꞌ bra kanꞌ: ―¡Kuꞌni tnuan ꞌin Stian Ndiose! ―ndukwin neꞌ ꞌin Jesús―. ¡Ndukwan ba ꞌiin chaꞌ ndijyaan loꞌo chabiyaꞌ ꞌin ti kwiꞌ Ni nu nka Xꞌnaan! ¡Ni siya ni ti, ndukwan Ndiose ꞌiin chaꞌ lkaa Ree nu nka ndloo ꞌin neꞌ Israel! ");
INSERT INTO ctpNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Mjwi ska buru ꞌin Jesús, ndyaa tukwa yu chunꞌ buru bra kanꞌ, chunꞌ ndukwa chaꞌ re lo kityi kula: ");
INSERT INTO ctpNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Ja kutsen wan, neꞌ kwa tyi kichen Sión; ndijyan yu nu nka Xꞌnan wan, ndukwa yu chunꞌ ska buru. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nu ngwa bra kanꞌ, ja ngwa biyaꞌ tiꞌ neꞌ chaꞌ kanꞌ. Ti ji ka chaꞌ tnun kanꞌ ꞌin Jesús, ti ji tyaa yu la seꞌen tlyu seꞌen ndiꞌin Ndiose niꞌ kwan. Xa wa ngwa chaꞌ tnun kanꞌ, ndyuꞌwi tiꞌ neꞌ nu yꞌni xaꞌan chaꞌ ꞌin yu chaꞌ nu ndukwa lo kityi kula ti sꞌni. Ngwa biyaꞌ tiꞌ neꞌ bra kanꞌ, chaꞌ sa ñaꞌan nu nchkwiꞌ kityi, kwiꞌ ngwañaꞌan ngwa chaꞌ nu yꞌni nten kaꞌan kanꞌ loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ngwañaꞌan ngwa bra kanꞌ. Nten nu mdiꞌin seꞌen ndiꞌin Jesús tuꞌwa kwaa seꞌen ngutsiꞌ ayman Lázaro, ytsaꞌ neꞌ ꞌin neꞌ kichen sa ñaꞌan nu ngwa chaꞌ kanꞌ; xa nu msiꞌya Jesús ꞌin Lázaro chaꞌ tyuꞌu yu xiyaꞌ; ");
INSERT INTO ctpNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","kanꞌ chaꞌ mdoꞌo nten kaꞌan kanꞌ, ndyaa neꞌ chaꞌ tyukwa taꞌa neꞌ loꞌo Jesús tuwiin, chaꞌ wa ynan neꞌ sa ñaꞌan chaꞌ tnun nu yꞌni Jesús loꞌo Lázaro. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kanꞌ chaꞌ ykwiꞌ neꞌ fariseo loꞌo taꞌa neꞌ: ―Ñaꞌan wan ꞌin yu kanꞌ. ¿Ni sa ñaꞌan kuꞌnian ni a? Ja ka ꞌñaan tukuanꞌ chaꞌ ꞌin yu kanꞌ siyaꞌ ti. ¡Ñaꞌaan chalyuu msñi neꞌ chaꞌ ꞌin yu ni! ");
INSERT INTO ctpNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Loꞌo neꞌ griego mdiyan laja nten nu ndaꞌan taꞌa kanꞌ nde Jerusalén. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mdiyan chinꞌ neꞌ griego kanꞌ seꞌen ndiꞌin Lpe bra kanꞌ. Kichen Betsaida nde lo yuu ꞌin Galilea lka kichen tyi Lpe kanꞌ. Ykwiꞌ neꞌ kanꞌ loꞌo Lpe bra kanꞌ: ―Kuꞌnii chaꞌ tlyu tiꞌ ꞌwa, yu kula, nchka tiꞌ ba tyukwa taꞌa ba loꞌo Jesús ―ndukwin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Kanꞌ chaꞌ mdoꞌo Lpe ndyaa yu seꞌen ndiꞌin Ndre taꞌa kichen tyi yu; kwiꞌ taꞌa tyukwa yu ndyaa ytsaꞌ yu ꞌin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Loꞌo ykwiꞌ Jesús chaꞌ re loꞌo neꞌ: ―Wa ndiya bra ꞌñaǎn chaꞌ ka tnuǔn bra nu kajaǎn, naꞌ nu wa mdiyaǎn lo chalyuu chaꞌ kaǎn nten ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌo wan ni: Ska mta nu ntya nten ni, ñaꞌan tiꞌ ska mta trigu, kanun mta kanꞌ ya ñaꞌan ti si ja kata neꞌ ꞌin ran niꞌ yuu ―ndukwin―. Xa wa yta neꞌ mta kanꞌ niꞌ yuu, katsu mta kanꞌ bra kanꞌ, tyii chaꞌ ꞌin mta kanꞌ sa ñaꞌan lka si wa ngujwi ran. Xa nu katsu kuten mta kanꞌ, kaꞌan ꞌa mta tyoꞌo loo ran xa wa ngula ran bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ngwañaꞌan lka loꞌo nten nu nchka tiꞌ xñi chaꞌ ꞌñaǎn ―ndukwin Jesús―. Nchga nten nu lye ꞌa ngiꞌni kti ꞌin neꞌ, ti ykwiꞌ ti neꞌ, kanaꞌ kasiya ꞌin neꞌ; loꞌo nten nu ja ntsen kaja chunꞌ nu wa yten chaꞌ ꞌñaǎn, ti kwiꞌ nten lka nu kaja chalyuu kwi nu ja tsaa tii ꞌa ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Bra nu nchka tiꞌ ska nten kuꞌni tñan ꞌñaǎn ―ndukwin Jesús bra kanꞌ―, ndiꞌin chaꞌ tsaa yu la nde yaꞌ nu nchka tiǎnꞌ chaꞌ tsaa yu. Chunꞌ ndiꞌin la ka tyiꞌin yu kanꞌ la seꞌen ndiꞌiǐn bra kanꞌ, chaꞌ lka yu ñaꞌan tiꞌ msu ꞌñaǎn. Loꞌo Stiǐn kuꞌni tnun Ni ꞌin yu kanꞌ, chunꞌ nxlyaa yu kuꞌni yu tñan ꞌñaǎn bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ti ykwiꞌ la Jesús loꞌo neꞌ bra kanꞌ: ―Kaꞌan ꞌa chaꞌ nduwe tiǎnꞌ ni. ¿Ta suꞌwe la si jñaǎn ꞌin Stiǐn Ndiose chaꞌ ja tyukwa ꞌa chaꞌ kuxi re ꞌñaǎn a? Ja suꞌwe kanꞌ, ja ka chkwiǐnꞌ ngwañaꞌan. Wa ndiya bra ꞌñaǎn ni, chaꞌ ka nchga tñan nu ndiꞌin chaꞌ ka ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kanꞌ ykwiꞌ Jesús loꞌo Ndiose Sti yu: ―Stiǐn, suꞌwe la ka tnun la nuꞌwin. Ynen ykwiꞌ Ndiose niꞌ kwan bra kanꞌ. Nde lka chaꞌ nu ykwiꞌ Ni: ―Wa lka ngiꞌni tnun nten chalyuu ꞌñaǎn ykwiǐnꞌ, kwiꞌ ngwañaꞌan ti kuꞌni tnun la neꞌ ꞌñaǎn xiyaꞌ chunꞌ tñan nu ngiꞌni nuꞌwin ―ndukwin Ndiose ꞌin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Loꞌo ndukwin nten kaꞌan nu ndiꞌin kwiꞌ seꞌen ti chaꞌ wa ynen ykwiꞌ tiꞌyu bra kanꞌ, mskeꞌ tiꞌ neꞌ. Xka ta nten ndukwin chaꞌ nde niꞌ kwan mdoꞌo chaꞌ nu ykwiꞌ ska angajle loꞌo Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Chaꞌ ꞌwan ngwa chaꞌ ynen ykwiꞌ Ndiose nde niꞌ kwan, siꞌi chaꞌ ꞌñaǎn ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wa ndiya bra nu kuꞌni biyaꞌ Ndiose ꞌin nchga nten chalyuu, wa ndiya bra nu tyijiǐn lyoǔn ꞌin kuneꞌ xaꞌan nu nka ndloo lo chalyuu ―ndukwin Jesús ꞌin neꞌ―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Bra nu skwen nten xaꞌan ꞌñaǎn seꞌen ndiꞌiǐn lo chalyuu, xa nu jwiꞌin kaꞌan neꞌ ꞌñaǎn lo wsi, bra kanꞌ kuniǐn chaꞌ ka sten nchga nten chaꞌ ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ngwañaꞌan ndukwin Jesús chaꞌ ka biyaꞌ tiꞌ neꞌ sa ñaꞌan ka bra nu kujwi neꞌ ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mxkwen neꞌ ꞌin Jesús bra kanꞌ: ―Wa ynan ba chaꞌ nu ngwaꞌan neꞌ lo kityi kula ꞌñaan, chaꞌ ja tsaa tii ꞌa chalyuu ꞌin Krixtu, nten nu tnun nchka kanꞌ nu ta Ndiose chaꞌ kan lo chalyuu ―ndukwin neꞌ―. ¿Ni sa ñaꞌan ndyoꞌo chaꞌ nu tka ykwiiꞌ ti, chaꞌ ndiꞌin chaꞌ jwiꞌin kaꞌan neꞌ ꞌin Krixtu lo wsi a? ¿Ta ti kwiꞌ Krixtu nu kan lo chalyuu chaꞌ ka nten a? ¿Ni sa ñaꞌan nten lka nu lka Krixtu kanꞌ a? ");
INSERT INTO ctpNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Mxkwen Jesús ꞌin neꞌ bra kanꞌ: ―Ti chinꞌ ti tsan ti tyiꞌiǐn seꞌen ndiꞌin wan, naꞌ nu taǎn xaa nu xuꞌwi niꞌ kasiya ꞌin nten ―ndukwin Jesús―. Kanꞌ chaꞌ ni, tsaa wan seꞌen ndiꞌin chaꞌ tsaa wan bra nu ti xaa, chaꞌ ja kuꞌni nu xaꞌan kanan ꞌwan, ti kwiꞌ kuneꞌ xaꞌan nu nsuꞌwa tla lo chalyuu. Bra nu nchka tla seꞌen ndaꞌaan, ja jlyo ꞌa tianꞌ la nde yaꞌ ndaꞌaan bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Loꞌo ꞌwan ―ndukwin Jesús ꞌin neꞌ―, suꞌwe la sten wan chaꞌ ꞌñaǎn laja nu ti ndiꞌiǐn lo chalyuu, naꞌ nu taǎn xaa nu xuꞌwi niꞌ kasiya ꞌwan, nten chalyuu. Loꞌo tyukwi ti tiye wan ka wan nten ꞌin Ndiose bra kanꞌ. Mdyii ykwiꞌ Jesús ngwañaꞌan loꞌo neꞌ, mdoꞌo yu ndyaa yu ska seꞌen nu ja tyija lyo yu ꞌin neꞌ bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ni siya wa yꞌni Jesús kaꞌan chaꞌ tnun seꞌen ndiꞌin nten kanꞌ, ja mslyaa neꞌ xñi neꞌ chaꞌ nu ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Chañi ngwa chaꞌ nu ngwaꞌan ayman Isaías lo kityi ꞌin Ndiose nu ngwa sꞌni, kwiꞌ nu ndukwa re: Ndiose Xꞌnaǎn, ndukwin lo kityi kanꞌ, ja xlyaa neꞌ re xñi neꞌ chaꞌ ꞌiin, ti kwiꞌ chaꞌ nu ytsaꞌ ba ꞌin neꞌ. Ja siyaꞌ ngwa biyaꞌ tiꞌ neꞌ chaꞌ nuꞌwin yꞌnii chaꞌ tnun seꞌen ndiꞌin neꞌ. Ngwañaꞌan nchkwiꞌ kityi kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kanꞌ chaꞌ ja ngwa ꞌin neꞌ judío xñi neꞌ chaꞌ ꞌin Jesús. Loꞌo ndiya xka chaꞌ nu ngwaꞌan ayman Isaías kanꞌ: ");
INSERT INTO ctpNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Wa mdukunꞌ Ndiose kiloo neꞌ kanꞌ, wa yꞌni Ni chaꞌ ngwa tla ke neꞌ kanꞌ. Ngwañaꞌan ngwa chaꞌ ja ñaꞌan ꞌa neꞌ chaꞌ kanꞌ, chaꞌ ja ka biyaꞌ ꞌa tiꞌ neꞌ sa ñaꞌan ka chaꞌ kanꞌ. Loꞌo ja xlyaa neꞌ kulaa yaꞌ neꞌ chaꞌ kuxi nu ndiꞌin tiye neꞌ, kanꞌ chaꞌ ja nchka kuꞌniǐn chaꞌ tlyu tiꞌ ꞌin neꞌ ꞌin chaꞌ kuxi kanꞌ, chaꞌ chkaa neꞌ bra kanꞌ, ndukwin Ndiose. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ngwañaꞌan ngwaꞌan ayman Isaías, chaꞌ wa mgii tiꞌ yu ni sa ñaꞌan chaꞌ tnun nu ka ꞌin Jesús; chaꞌ ꞌin Jesús kanꞌ ykwiꞌ ayman Isaías bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Loꞌo ngwa kaꞌan neꞌ judío nu ndyaa ñaꞌan tiꞌ ꞌin Jesús, loꞌo chinꞌ neꞌ nu lka tñan; ntsen neꞌ kanꞌ ꞌin neꞌ fariseo, kanꞌ chaꞌ ja mslyaa neꞌ chkwiꞌ neꞌ chaꞌ ꞌin Jesús seꞌen ndiꞌin nten. Ntsen neꞌ si kulo neꞌ fariseo tñan ꞌin neꞌ chaꞌ ja ka ꞌa tsaa neꞌ niꞌ lyaa ꞌin taꞌa neꞌ judío. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ndiya la tiꞌ neꞌ kanꞌ chaꞌ suꞌwe ti chkwiꞌ nten chalyuu chaꞌ ꞌin neꞌ. Ja nchka tiꞌ neꞌ chaꞌ ka suꞌwe tiye Ndiose ñaꞌan Ni ꞌin neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Loꞌo kwen ꞌa ykwiꞌ Jesús loꞌo neꞌ bra kanꞌ: ―Bra nu xñi nten chaꞌ ꞌñaǎn ni, siꞌi chaꞌ skaǎn tiǎn ndyaa ñaꞌan tiꞌ neꞌ kanꞌ ꞌñaǎn; loꞌo xñi neꞌ chaꞌ ꞌin Ndiose nu msuꞌwa ꞌñaǎn mdiyaǎn lo chalyuu bra kanꞌ ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Bra nu ñaꞌan nten ꞌñaǎn, bra kanꞌ ñaꞌan neꞌ kanꞌ ꞌin Ndiose nu ndlo tñan ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wa ndijyaǎn lo chalyuu chaꞌ kaǎn ñaꞌan tiꞌ ska xaa nu xuꞌwi niꞌ kasiya ꞌin nten. Bra nu xñi nten chaꞌ ꞌñaǎn, ja tyiꞌin ꞌa neꞌ kanꞌ lo chalyuu tla, sa ñaꞌan lka si ja nsuꞌwi xaa niꞌ kasiya ꞌin neꞌ siꞌya chaꞌ xaꞌan nu ngiꞌni neꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nduꞌuǔn chaꞌ ꞌin nten; xa nu kunan neꞌ chaꞌ kanꞌ, loꞌo ja tukwa neꞌ chaꞌ kanꞌ, ndiya kiꞌya ꞌin neꞌ, ni siya siꞌi naꞌ nu xtyaǎn kiꞌya ꞌin neꞌ kanꞌ bra kanꞌ ―ndukwin Jesús―. Ja mdiyaǎn chaꞌ kuꞌniǐn biyaǎnꞌ ꞌin nten chalyuu ni; chaꞌ kulaǎn ꞌin neꞌ ꞌin chaꞌ kuxi, kanꞌ chaꞌ mdiyaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wa ynan nten chaꞌ nu nchkwiǐnꞌ loꞌo neꞌ; kanꞌ lka chaꞌ nu kanun kwenta ꞌin neꞌ, bra nu kuꞌni biyaꞌ Ndiose ꞌin neꞌ xa wa mdyii chalyuu ―ndukwin Jesús―. Bra kanꞌ kuꞌni biyaꞌ Ni ꞌin nchga nten nu ja mdukwa chaꞌ nu ykwiǐnꞌ, nu ja mslyaa xñi chaꞌ nu nchkwiǐnꞌ loꞌo neꞌ ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Siꞌi chabiyaꞌ ꞌñaǎn, ti ykwiǐnꞌ tiǎn nchkwiǐnꞌ loꞌo nten; Stiǐn Ndiose nu msuꞌwa ꞌñaǎn chaꞌ mdiyaǎn lo chalyuu, kanꞌ lka nu ngulo tñan ꞌñaǎn sa ñaꞌan ka chaꞌ nu kwaꞌuǔn ꞌin nten, sa ñaꞌan ka chaꞌ nu chkwiǐnꞌ loꞌo nten ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jlyo tiǎnꞌ chaꞌ talo ꞌa nchga chaꞌ nu nchkwiꞌ Stiǐn loꞌo wan chaꞌ kuꞌni wan, loꞌo ja tsaa tii ꞌa chalyuu ꞌwan si kunan wan chaꞌ kanꞌ ―ndukwin Jesús ꞌin neꞌ―. Nchga chaꞌ nu wa ykwiꞌ Stiǐn loꞌoǔn, kanꞌ lka chaꞌ nu nchkwiǐnꞌ loꞌo wan ni. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ti ji tyukwa tsan chaꞌ ka taꞌa pascua kanꞌ; jlyo tiꞌ Jesús chaꞌ wa tiya ti bra ꞌin yu, chaꞌ tyoꞌo yu chalyuu re tyaa yu nde seꞌen ndiꞌin Ndiose Sti yu. Xkwiꞌ nsuꞌwi ꞌa chaꞌ tiye Jesús ñaꞌan yu ꞌin nten chalyuu nu wa yten chaꞌ ꞌin yu; loꞌo ñaꞌan ti nsuꞌwi ꞌa chaꞌ tiye yu ꞌin nten kanꞌ, sa ñaꞌan bra nu tyii chalyuu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ti kwiꞌ bra kanꞌ yꞌni kuneꞌ xaꞌan chaꞌ ngwiꞌya chaꞌ ke Juda sñiꞌ Simón Iscariote chaꞌ kuꞌni yu trisiyun ꞌin Jesús yaꞌ neꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jlyo tiꞌ Jesús chaꞌ nchga chaꞌ nu nsuꞌwi ꞌin Ndiose Sti yu wa nda Ni ꞌin yu. Loꞌo ngwañaꞌan jlyo tiꞌ yu chaꞌ wa mdoꞌo yu nde seꞌen ndiꞌin Ndiose mdiyan yu lo chalyuu re, loꞌo jlyo tiꞌ yu chaꞌ wa tyaa ti yu nde seꞌen ndiꞌin Ndiose xiyaꞌ. Ni siya jlyo tiꞌ Jesús nchga chaꞌ kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","mdyituun Jesús tuꞌwa msaa laja nu nchku siin neꞌ, ngulo yu teꞌ tukwin nu ndukuꞌ yu, msñi yu xka teꞌ chaꞌ skanꞌ yu siꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bra kanꞌ msuꞌwa yu tyiꞌa niꞌ siꞌyuu, ndyaa jyaꞌan yu kiyaꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, mxtyi yu kiyaꞌ neꞌ loꞌo teꞌ nu nchkanꞌ siꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Bra nu mdiyan Jesús seꞌen ndukwa Tyu Simón, ykwiꞌ Tyu loꞌo yu bra kanꞌ: ―¿Nuꞌwin a?, yu kula. ¿Ta jyaꞌaan kiyaǎnꞌ a? ―ndukwin Tyu ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","―Ja nchka biyaꞌ tiiꞌ ni, ni sa ñaꞌan tñan ngiꞌniǐn nde ―ndukwin Jesús ꞌin yu―, chunꞌ ndiꞌin la chinꞌ ka biyaꞌ tiiꞌ chaꞌ kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","―¡Ja kaja chabiyaꞌ jyaꞌaan kiyaǎnꞌ siyaꞌ ti! ―ndukwin Tyu ꞌin Jesús. ―Ja ka xuꞌwi chaꞌ ꞌiin loꞌoǔn si ja jyaꞌaǎn kiyaaꞌ ―ndukwin Jesús ꞌin Tyu bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","―Suꞌwe sikwa, yu kula ―ndukwin Tyu Simón bra kanꞌ―. Ni siꞌi kiyaǎnꞌ tiǎn jyaꞌaan sikwa, loꞌo yaǎnꞌ loꞌo keěn jyaꞌaan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","―Luwi ꞌa tyukwi ñaꞌaan nan xa wa ytaan chku ―ndukwin Jesús bra kanꞌ―, ja ndiꞌin chaꞌ kataan chku xiyaꞌ bra kanꞌ. Kiyaanꞌ tian katen bra nu stean niꞌ ñaꞌan. Loꞌo ꞌwan, ni siya luwi ꞌa kasiya ꞌwan, ti ndiꞌin xka yu loꞌo wan nu ja luwi ꞌa kasiya ꞌin yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bra nu ndukwin Jesús: “Ndiꞌin xka yu loꞌo wan nu ja luwi ꞌa kasiya ꞌin yu”, ykwiꞌ yu ngwañaꞌan chaꞌ wa jlyo tiꞌ yu ti ka lka nu kuꞌni trisiyun ꞌin yu yaꞌ neꞌ xaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Bra wa mdyii mjyaꞌan Jesús kiyaꞌ neꞌ, xiyaꞌ ykuꞌ yu steꞌ yu, loꞌo ndyaa tukwa yu tuꞌwa msaa. Ykwiꞌ yu loꞌo neꞌ bra kanꞌ: ―¿Ngwa biyaꞌ tiꞌ wan nan lka nu yꞌniǐn bra nu mjyaꞌaǎn kiyaꞌ wan ngwañaꞌan a? ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Mstru” ndukwin wan ꞌñaǎn; “Xꞌnan ba” ndukwin wan ꞌñaǎn, loꞌo chañi ꞌa chaꞌ kanꞌ. Ti kwiꞌ ngwañaꞌan lkaǎn chaꞌ ꞌwan ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naꞌ nu lkaǎn Xꞌnan wan, naꞌ nu lkaǎn Mstru ꞌwan ni, wa mjyaꞌaǎn kiyaꞌ wan; kanꞌ chaꞌ ndiꞌin chaꞌ jyaꞌan wan kiyaꞌ taꞌa wan kwiꞌ ngwañaꞌan ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ngwa tiǎnꞌ chaꞌ kuwe tiꞌ wan xa nu ñaꞌan wan mjyaꞌaǎn kiyaꞌ taꞌa wan, chaꞌ sa ñaꞌan nu yꞌniǐn bra kanꞌ, bra nu mdayaǎnꞌ ꞌwan, ngwañaꞌan ndiꞌin chaꞌ kuꞌni wan loꞌo taꞌa wan ―ndukwin Jesús ꞌin neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Chañi chaꞌ nu nchkwiǐnꞌ loꞌo wan, chaꞌ ti kwiꞌ nten nu lka xꞌnan neꞌ, kanꞌ nka ndloo ꞌin neꞌ, siꞌi msu nu nka ndloo; loꞌo nten nu ndlo tñan ꞌin neꞌ chaꞌ tsaa neꞌ lo kichen, kanꞌ nka ndloo la, siꞌi neꞌ nu ndyaꞌan lo kichen ti. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wa ngwa biyaꞌ tiꞌ wan nchga chaꞌ nu tka ykwiǐnꞌ tiǎn loꞌo wan ni, kanꞌ chaꞌ suꞌwe ꞌa ka tiye wan xa nu tukwa wan chaꞌ kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Ja nchkwiǐnꞌ chaꞌ ꞌin nchga wan. Jlyo tiǎnꞌ ti nten ka nu ngulo suwiǐn chaꞌ kuꞌni xaꞌan neꞌ chaꞌ ꞌñaǎn ―ndukwin Jesús―. Ti sꞌni ndukwa ska chaꞌ ꞌin Ndiose lo kityi kula nu nchkwiꞌ: “Ti kwiꞌ yu kanꞌ nu suꞌwa nchku tyaja loꞌoǔn, kanꞌ lka nu nxuun loꞌoǔn ni” ngwañaꞌan ndukwin kityi kanꞌ; loꞌo jlyo tiǎnꞌ chaꞌ ndiꞌin chaꞌ ka chaꞌ kanꞌ ―ndukwin Jesús―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Wa ykwiǐnꞌ chaꞌ re loꞌo wan ni, xa nu ti ji ka chaꞌ kanꞌ; bra wa ngwa ngwañaꞌan, bra kanꞌ ka tsaa ñaꞌan tiꞌ wan ꞌñaǎn, chaꞌ chañi chaꞌ lkaǎn skaǎn tiǎn nu lka Sñiꞌ Ndiose, chañi chaꞌ mdiyaǎn lo chalyuu, sa ñaꞌan nu niǐn ꞌwan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Chañi chaꞌ nu chkwiǐnꞌ loꞌo wan ni ―ndukwin yu―, xa nu kunan wan chaꞌ nu nchkwiꞌ ska nten nu msuꞌwaǎn chaꞌ kan seꞌen ndiꞌin wan, bra kanꞌ suꞌwa ndyoꞌo chaꞌ ñaꞌan tiꞌ si kunan wan chaꞌ ꞌñaǎn; loꞌo xa nu kunan wan chaꞌ ꞌñaǎn, bra kanꞌ suꞌwa ndyoꞌo chaꞌ ñaꞌan tiꞌ si kunan wan chaꞌ nchkwiꞌ Stiǐn Ndiose nu msuꞌwa ꞌñaǎn ndijyaǎn lo chalyuu re. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Bra nu wa ykwiꞌ Jesús ngwañaꞌan, tiꞌí niꞌ kasiya ꞌin yu chaꞌ xiꞌin ꞌa tiꞌ yu. Ykwiꞌ yu loꞌo neꞌ kanꞌ: ―Chañi ꞌa chaꞌ nu chkwiǐnꞌ loꞌo wan ni, chaꞌ ndiya ska yu taꞌa ndaꞌan wan nu kuꞌni trisiyun ꞌñaǎn yaꞌ yu xaꞌan ―ndukwin Jesús bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nduwe ꞌa tiꞌ neꞌ nu ngiꞌni xaꞌan chaꞌ ꞌin yu, naꞌan tloo taꞌa ti neꞌ bra kanꞌ; ja ndiꞌya neꞌ kwenta siyaꞌ ti sa ñaꞌan chaꞌ nu ykwiꞌ yu. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Mskwa ska yu lo kaꞌ kwiꞌ seꞌen ti loꞌo Jesús; suꞌwe ꞌa nsuꞌwi tiye Jesús ñaꞌan ꞌin yu kiꞌyu kanꞌ, ");
INSERT INTO ctpNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","kanꞌ chaꞌ yꞌni chkan ti Tyu Simón ꞌin yu kanꞌ, mnichaꞌ ꞌin yu: ―¿Ni sa ñaꞌan nchka tiꞌ yu kula chkwiꞌ yu bra nu ykwiꞌ yu ngwañaꞌan a? ");
INSERT INTO ctpNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kanꞌ chaꞌ ndyaa xñi tloo yu kanꞌ kwiꞌ seꞌen la seꞌen ndukwa Jesús bra kanꞌ. Mnichaꞌ yu ꞌin Jesús: ―Xꞌnaǎn, ¿ti ka lka nu kanꞌ a? ―ndukwin. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","―Nde ñaꞌan kuꞌniǐn ―ndukwin Jesús ꞌin yu bra kanꞌ―. Taꞌaǎn sa yuꞌwe tyaja ꞌñaǎn niꞌ kaꞌnan skwa re ni. Nten nu taǎn yuꞌwe tyaja kanꞌ ꞌin chaꞌ ku, kanꞌ lka nu niǐn ꞌwan. Loꞌo mdaꞌan Jesús sa yuꞌwe tyaja niꞌ kaꞌnan, mda ꞌin ran ꞌin Juda, sñiꞌ Simón Iscariote bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Bra wa msñi Juda tyaja kanꞌ, ti kwiꞌ bra kanꞌ yten kuneꞌ xaꞌan nu naan Satanás, ndyaa niꞌ kasiya ꞌin Juda kanꞌ. Ykwiꞌ Jesús loꞌo yu bra kanꞌ: ―Yaa lyaa lo kichen ꞌiin, chaꞌ kuꞌnii tñan nu ndiꞌin chaꞌ kuꞌnii. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Loꞌo ja ska nu ndukwa tuꞌwa msaa ngwa biyaꞌ tiꞌ ni chaꞌ ykwiꞌ Jesús loꞌo Juda ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ti kwiꞌ Juda ngwa nu ngwiꞌya kwijin tñi seꞌen nu ska tlyu ti nsuꞌwi tñi ꞌin taꞌa neꞌ; kanꞌ chaꞌ ndiya neꞌ kanꞌ nu mskeꞌ tiꞌ chaꞌ wa ngulo Jesús tñan ꞌin yu, chaꞌ tsaa yu xiꞌi yu ska nan nu kunanjoꞌo ꞌin neꞌ chaꞌ ka taꞌa. Loꞌo xka ta neꞌ mskeꞌ tiꞌ neꞌ chaꞌ ndiya ska tñan ꞌin Juda, chaꞌ tsaa loꞌo yu lomstan chaꞌ ta yu ꞌin neꞌ tiꞌi. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kanꞌ chaꞌ xa wa mdyii yku Juda tyaja kanꞌ, bra ti mdoꞌo yu ndyaa yu ni siya tla bra kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Xa nu wa mdoꞌo Juda ndyaa yu, bra kanꞌ ykwiꞌ Jesús loꞌo nten nu nganun kanꞌ: ―Bra nu ni kuꞌni Ndiose chaꞌ ka tlyu laǎn chaꞌ ꞌñaǎn, naꞌ nu wa ndijyaǎn lo chalyuu chaꞌ kaǎn nten ―ndukwin yu―. Loꞌo kuꞌni tnun nten ꞌin Ndiose chunꞌ chaꞌ tnun nu ka ꞌñaǎn ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Loꞌo naꞌ kuꞌniǐn chaꞌ ka tlyu la chaꞌ ꞌin Stiǐn, chaꞌ lkaǎn skaǎn tiǎn nu lka Sñiꞌ Ni, kwiꞌ ngwañaꞌan kuꞌni Ni chaꞌ ka tlyu la chaꞌ ꞌñaǎn; loꞌo bra ti kuꞌni Ni ngwañaꞌan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sñiěnꞌ ―ndukwin Jesús ꞌin neꞌ kanꞌ―, ti tyiꞌiǐn loꞌo wan lo chalyuu xa chinꞌ ti tsan. Sa ñaꞌan nu niǐn ꞌin neꞌ judío nu ngwa xkanꞌ, ti kwiꞌ chaꞌ chkwiǐnꞌ loꞌo wan ni: Tsaa naan wan ꞌñaǎn nde seꞌen mdaꞌaǎn, loꞌo ja ka ꞌa ꞌwan tsaa wan seꞌen tyiꞌiǐn bra kanꞌ ―ndukwin yu―. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nde katsaǎnꞌ ꞌwan sa ñaꞌan ka ska tñan kwi nu kuꞌni wan. Ndiꞌin chaꞌ suꞌwe ꞌa xuꞌwi tiye wan ñaꞌan wan ꞌin taꞌa nten wan; sa ñaꞌan nu suꞌwe ꞌa nsuꞌwi tiyeěn naꞌaǎn ꞌwan, kwiꞌ ngwañaꞌan ndiꞌin chaꞌ suꞌwe xuꞌwi tiye wan ñaꞌan wan ꞌin taꞌa nten wan. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bra kanꞌ ka biyaꞌ tiꞌ ya ñaꞌan ti nten chaꞌ lka wan nten nu ngiꞌni xaꞌan chaꞌ ꞌñaǎn, bra nu suꞌwe ꞌa nsuꞌwi tiye wan ñaꞌan wan ꞌin taꞌa nten wan ―ndukwin Jesús. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ykwiꞌ Tyu Simón loꞌo Jesús bra kanꞌ: ―Xꞌnaǎn ―ndukwin―, ¿la nde yaꞌ tsaa ni a? ―Ja kaja chabiyaꞌ ꞌiin bra nu ni chaꞌ tsaa loꞌoǔn la seꞌen nu tsaꞌaǎn ―ndukwin Jesús―. Chunꞌ ndiꞌin la tsaa nuꞌwin tuwiin la kanꞌ. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Loꞌo mnichaꞌ Tyu ꞌin yu bra kanꞌ: ―¿Ni chaꞌ lka ja nchka tiiꞌ chaꞌ tsaꞌaǎn loꞌoo la seꞌen tsaa, ni siya ni ti a? ―ndukwin―. Ja nꞌni chaꞌ ni siya kajaǎn chaꞌ ꞌiin. ");
INSERT INTO ctpNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","―¿Ta chañi ka ꞌiin chaꞌ xlyaa kajaa chaꞌ ꞌñaǎn? ―ndukwin Jesús ꞌin yu―. Chañi chaꞌ nu chkwiǐnꞌ loꞌoo ni, chaꞌ bra nu ti ji xiꞌya la kweꞌe nde tlya, snan yaꞌ xkween chaꞌ ꞌin nten chaꞌ ja nsuꞌwi lyoo ꞌñaǎn. ");
INSERT INTO ctpNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ja tyaꞌan ꞌa kaꞌan ch