﻿USE sofia;
DROP TABLE IF EXISTS sofia.cth_vpl;
CREATE TABLE cth_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cth_vpl WRITE;
INSERT INTO cth_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Apuengcue vah, Cathut ni kalvan hoi talai a sak. ");
INSERT INTO cth_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Talai teh meilam tawn hoeh. Ahrawng lah doeh ao. Hmonae ni kadung poung e hmuen a ramuk. Cathut e Muitha teh tui van a kâroe. ");
INSERT INTO cth_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Cathut ni angnae awm seh ati teh angnae teh ao. ");
INSERT INTO cth_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Angnae teh Cathut ni a khet navah ahawi ati teh, Cathut ni angnae teh hmonae dawk hoi a kapek. ");
INSERT INTO cth_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Cathut ni angnae hah khodai telah a phung, hmonae hah karum telah a phung. Hottelah, tangmin hoi amom teh apasuek hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hahoi Cathut ni, tui lungui lathueng awmseh, tui hoi tui kâkapek seh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Hottelah Cathut ni lathueng a sak teh, lathueng lah kaawm e tui hoi lathueng rahim lah kaawm e tui hah a kapek teh hottelah ao awh. ");
INSERT INTO cth_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Cathut ni lathueng teh kalvan telah a phung. Hottelah tangmin hoi amom teh apâhni hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hahoi Cathut ni kalvan rahim kaawm e tui hmuen buet touh koe awm seh. Kaphui e talai kamnuek seh ati e patetlah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Cathut ni kaphui e talai hah talai telah ati teh, tuikamuemnae teh tuipui telah a phung. Cathut ni a khet navah ahawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hahoi Cathut ni hettelah ati, talai ni pho, cati ka tâcawt sak e cakung, a paw ka paw e thingkung, amamouh a coung e patetlah atimu katâcawtkhai e naw hah paw naseh ati e patetlah ao awh. ");
INSERT INTO cth_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Talai ni pho, cati ka tâcawt sak e cakung, ati ka tawn ni teh a paw ka paw e thingkungnaw a pâw sak. Hotnaw hah Cathut ni a khet navah ahawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Hottelah tangmin hoi amom teh apâthum hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hahoi Cathut ni karum dawk hoi khodai kapek nahanelah, kalvan e lathueng dawk angnae awm seh, mitnoutnae tue, hnin hoi kumnaw awmseh. ");
INSERT INTO cth_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kalvan e lathueng dawk, talai angnae ka poe hanelah, angnae awmseh telah ati e patetlah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Hahoi Cathut ni angnae kalen kahni touh a sak teh, khodai ka uk hanelah kalen e buet touh, karum ka uk hanelah kathoenge buet touh hoi âsinaw a sak. ");
INSERT INTO cth_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Cathut ni talai dawk ang sak hanelah thoseh, khodai hoi karum ka uk hanelah thoseh, hmonae dawk hoi angnae kapek hanelah thoseh, kalvan e lathueng dawk a hruek. ");
INSERT INTO cth_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Hote hah Cathut ni a khet navah, ahawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hottelah tangmin hoi amom teh apali hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hahoi, Cathut ni kahring ni teh kâroe e saring, tui ni pungdaw sak naseh. Tavanaw hai kalvan e lathueng dawk kamleng naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hahoi, Cathut ni tuipui dawk e saring kalenpoungnaw, kahring ni teh kâroe e saringnaw tui ni amamouh coungnae patetlah lengkaleng a pungdaw sak teh, rathei ka tawn e tavanaw hai amamouh coungnae patetlah lengkaleng a sak. Hote hah Cathut ni a khet navah ahawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Cathut ni hote saringnaw hah yawhawi a poe teh, moikapap pungdaw awh nateh, tuipui tuinaw dawk kawi sak awh. Tavanaw hai talai dawk pungdaw awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Hottelah tangmin hoi amom teh apanga hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Hahoi Cathut ni saring hoi moithangnaw, vonpui hoi kâva e moithangnaw talî ni pungdaw sak seh telah ati e patetlah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hottelah Cathut ni moithangnaw, saringnaw, vonpui hoi kâva e moithang pueng teh a sak. Hote hah Cathut ni a khet navah ahawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hahoi Cathut ni, mamae mei hoi kâvan lah, meikalat lah tami sak awh sei. Ahni ni tuipui dawk e tanganaw, kalvan e tavanaw, talai dawk e saring pueng hoi, vonpui hoi kâva e saring pueng e lathueng kâ tawn seh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hottelah Cathut ni amae mei hoi kâvan lah, amae meikalat lah tongpa hoi napui hah a sak. ");
INSERT INTO cth_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Hahoi ahnimouh roi hah Cathut ni yawhawinae a poe teh, Cathut ni ahnimouh roi koe, canaw moikapap khe nateh pungdaw awh. Talai dawk kawi awh nateh, tâ awh loe. Tuipui dawk e tanganaw, kalvan e tavanaw, talai dawk vonpui hoi kâva e moithang pueng koe kâ tawn awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hahoi Cathut ni khenhaw! talai dawk cati ka tâcawt sak e cakung aphunphun, a paw dawk a mu kaawm e thingkung pueng, na ca awh hanelah kai ni na poe. ");
INSERT INTO cth_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Hahoi, talai e moithang, kalvan e tava, hoi kahring niteh, talai dawk vonpui hoi kâva e moithang pueng ni a ca hanelah, pho kahring aphunphun ka poe telah ati e patetlah ao. ");
INSERT INTO cth_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Hahoi, Cathut ni a sak e pueng a khet navah, ahawipoung telah ati. Hottelah tangmin hoi amom teh ataruk hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hottelah kalvan hoi talai, a thung kaawm e pueng teh koung a cum. ");
INSERT INTO cth_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Hahoi, a cum e thaw hah asari hnin dawk Cathut ni a pâpout. Hahoi, thaw pueng a cum dawkvah, asari hnin a kâhat. ");
INSERT INTO cth_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Hottelah, Cathut ni asari hnin hah yawhawi a poe teh a thoungsak. Bangkongtetpawiteh, a sak e hnopueng koung a cum toung dawkvah, hote hnin dawk a kâhat. ");
INSERT INTO cth_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Hetenaw teh kalvan hoi talai a saknae hnin navah, ");
INSERT INTO cth_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","talai dawk phokung pâw hoehnahlan, law dawk patue e hai a pâw hoehnahlan, BAWIPA Cathut ni talai van khorak sak hoeh rah. Talai dawk ka tawk hane tami hai awm hoeh rah. ");
INSERT INTO cth_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Hatei, talai dawk hoi tui kahû a tâco sak teh, talai pueng a duk sak. ");
INSERT INTO cth_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hahoi, BAWIPA Cathut ni talai dawk e vaiphu hoi tami a sak teh, hringnae kâha a hnawng dawk hoi a poe hnukkhu tami teh kahring e tami lah a kangcoung. ");
INSERT INTO cth_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hahoi BAWIPA Cathut ni kanîtholah, Eden hmuen dawkvah, takha buet touh a sak teh, a sak e tami hah hawvah a hruek. ");
INSERT INTO cth_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Hote talai dawk a meikahawi niteh, cakawi thingkung aphunphun a pâw sak. Takha lungui vah, hringnae thingkung hoi thoe hoi hawi panuenae thingkung hai a pâw sak. ");
INSERT INTO cth_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Takha kaduksak hanelah, Eden hoi tui buet touh a lawng teh, takha lawilah hoi pali touh lah a kampek teh tuisei pali touh lah a coung. ");
INSERT INTO cth_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Apasueke tui min teh Pishon. Sui onae Havilah ram pueng, kâkalup lah a lawng. ");
INSERT INTO cth_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Hote ram dawk e sui teh, ahawi. Hote hmuen koe Dellium hoi Onyx talung aphu kaawm e hai ao. ");
INSERT INTO cth_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Apâhni e tui min teh Gihon. Kush ram kâkalup lah a lawng. ");
INSERT INTO cth_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hahoi apâthum e tui min teh Khiddekel. Assiria ram kanîtholah a lawng teh, apali e tui min teh Euphrates. ");
INSERT INTO cth_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","BAWIPA Cathut ni tami a la teh, Eden takha dawk thaw tawk hane hoi khetyawt hanelah a hruek. ");
INSERT INTO cth_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hahoi, BAWIPA Cathut ni tami koe kâ a poe e teh, thoe hoi hawi panuenae thingkung hloilah, hote takha dawk kaawm e thingpaw pueng teh, na ca thai. ");
INSERT INTO cth_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hatei, thoe hoi hawi panuenae thingpaw teh na cat mahoeh. Na cat pawiteh, na ca hnin na due roeroe han atipouh. ");
INSERT INTO cth_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hahoi, BAWIPA Cathut ni tongpa teh amadueng ao e hawihoeh a titeh, kabawmkung kahawi ka sak pouh han ati. ");
INSERT INTO cth_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","BAWIPA Cathut ni talai a la teh, talai van e saring pueng hoi kalvan e tava pueng a sak hnukkhu, min phung hanelah, Adam koe a thokhai. Adam ni hai a thokhai e saring pueng min a phung e patetlah min lengkaleng a tawn awh. ");
INSERT INTO cth_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hottelah, saringpueng, kalvan e tava pueng, moithang pueng Adam ni min a phung. Hatei, Adam kabawmkung kahawi awm hoeh rah. ");
INSERT INTO cth_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hatdawkvah, BAWIPA Cathut ni Adam mat a i sak teh, a i lahun nah a nâhru buet touh a rayu pouh teh, a tak hoi bout a pâbing pouh. ");
INSERT INTO cth_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Hahoi, BAWIPA Cathut ni tongpa dawk hoi a rayu e a nâhru hoi napui a sak teh, tongpa koe a thokhai. ");
INSERT INTO cth_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Hahoi, Adam ni hethateh, ka hru thung e ka hru, ka tak thung e ka tak doeh. Tongpa thung e rayu e lah ao dawkvah, napui telah phung hanelah ao ati. ");
INSERT INTO cth_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hatdawkvah, tongpa ni manu hoi na pa a ceitakhai han. Hathnukkhu, a yu hoi a kâpahlawm vaiteh, takthai buet touh lah a coung han. ");
INSERT INTO cth_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tongpa hoi a yu teh, caici lah ao roi eiteh, kayanae tawn roi hoeh. ");
INSERT INTO cth_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","BAWIPA ni a sak e moithang pueng hlak tahrun teh huenghai kaawm poung e lah ao dawkvah, napui koe nangmouh roi ni takha dawk e thingpaw pueng cat hanh telah Cathut ni ati katang maw telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Napui ni tahrun koevah, takha dawk kaawm e thingpawnaw teh na ca thai. ");
INSERT INTO cth_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Hatei, takha lungui kaawm e thingpaw teh na cat mahoeh. Tek hai na tek mahoeh. Hoehpawiteh, na due han telah Cathut ni ati telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tahrun ni napui koe, khoeroe na dout mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bangkongtetpawiteh, a paw na ca hnin vah, na mit ang roi vaiteh, thoe hoi hawi na panue roi han. Cathut boiboe lah na o roi han tie ama Cathut ni a panue dawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hote thingkung teh cakawi kahawi e lah, mitkhet kantang e lah, tami lungkaangsakkung a paw lah a hmu dawkvah, a la teh a ca. Hahoi ateng kaawm e a vâ hai a poe teh a ca. ");
INSERT INTO cth_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hathnukkhu, ahnimouh roi teh, a mit ang roi toung dawkvah, caici lah ao roi e hah a kâpanue roi. Hatdawkvah, thai hna a khui roi teh, a khohna roi. ");
INSERT INTO cth_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Hot hnin tangmin lah, takha dawk BAWIPA Cathut a tho e pawlawk ahnimouh roi yuvâ ni a thai navah, BAWIPA Cathut e hmaitung hoi hlout nahanelah takha thung e thingkung rahak a kâhro roi. ");
INSERT INTO cth_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hatei, BAWIPA Cathut ni Adam a kaw teh, nâmaw na o atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tongpa ni, takha thung na lawk ka thai teh, caici lah ka o dawk ka taki teh ka kâhro telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","BAWIPA ni, apinimaw nang caici lah na o e hah a dei. Cat hanh ka tie thingpaw hah na ca toung maw telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tongpa ni nang ni na poe e napui ni thingpaw na poe teh ka ca atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","BAWIPA Cathut ni, napui koevah, hete hno heh bangkong maw na sak telah a pacei navah, napui ni, tahrun ni na dum teh ka ca telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","BAWIPA Cathut ni tahrun koevah, hete hno na sak dawkvah, saring hoi moithang pueng hlakvah, thoebo lah na o han. Na vonpui hoi na thawn vaiteh, na hring nathung vaiphu na ca han. ");
INSERT INTO cth_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nang hoi napui rahak, nang e catoun hoi napui e catoun rahak kai ni kâtarannae ka hruek han. Ahni ni na lû a phawm vaiteh, nang ni ahnie a khokpaimai na phawm pouh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Napui koevah, camo na vawn navah patawnae ka pung sak vaiteh, na khe nah patawnae na khang han. Na ngainae teh na vâ hanelah ao vaiteh, na vâ ni na uk han. ");
INSERT INTO cth_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Adam koevah, na yu e lawk na tarawi teh, cat hanh telah kai ni kâ na poe e thingpaw na ca dawkvah, talai teh nang kecu dawk thoebo lah ao. Tha pataw laihoi na hringyung thung na tawk vaiteh, na ca han. ");
INSERT INTO cth_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Pâkhingnaw hoi pâkhingkungnaw ka pâw sak vaiteh, law dawk hoi ka tâcawt e apawhik na ca han. ");
INSERT INTO cth_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Na tâconae talai lah bout na ban hoehroukrak, na minhmai dawk hoi lahuntui tâco laihoi na ca han. Bangkongtetpawiteh, nang teh vaiphu e lah na o dawkvah, vaiphu lah bout na ban han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hahoi, Adam ni amae yu hah Evi telah min a phung. Bangkongtetpawiteh, ahni teh kahring pueng e a manu lah ao dawk doeh. ");
INSERT INTO cth_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","BAWIPA Cathut ni Adam hoi a yu hanlah phaivuen angkidung a sak pouh teh, a khohna sak. ");
INSERT INTO cth_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hahoi, BAWIPA Cathut ni tami teh, maimouh thung dawk e buetbuet touh hoi a kâvan toung dawkvah, thoe hoi hawi a panue toe. Atuteh, yungyoe hringnae coe hanelah a kut a kâyap vaiteh hringnae thingpaw khi vaiteh, a cakawi nahoeh toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hatdawkvah, BAWIPA Cathut ni tami teh ama a tâconae talai dawk thaw tawk hanelah Eden takha thung hoi a pâlei. ");
INSERT INTO cth_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Hottelah, tami hah a pâlei hnukkhu, avoivang kamrit thai e tahloi hoi Cherubim hah, hringnae thingkung lamthung ka ring hanelah, Eden takha kanîtholah a hruek. ");
INSERT INTO cth_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam ni a yu Evi a panue teh, camo a vawn. Capa a khe teh, BAWIPA ni na kabawp dawk ca tongpa ka khe ati teh, Kain telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Hahoi, a nawngha Abel bout a khe. Abel teh tu kakhoumkung lah ao teh, Kain teh law kasakkung lah ao. ");
INSERT INTO cth_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Atueng akuep torei teh, Kain ni amae law thung e a pawhiknaw hah BAWIPA koe a sin. ");
INSERT INTO cth_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel ni hai tu pasuek ka khe e hoi, kathâwnaw a sin. Hatdawkvah, BAWIPA ni Abel hoi a sin e hno teh a dâw pouh. ");
INSERT INTO cth_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Hatei Kain hoi a sin e hno teh dâw pouh hoeh. Hatdawkvah, Kain teh a lung puenghoi a khuek dawkvah minhmai a mathoe. ");
INSERT INTO cth_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","BAWIPA ni Kain koevah, Bangkongmaw na lungkhuek teh minhmai a mathoe. ");
INSERT INTO cth_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kahawicalah na sak pawiteh ka dâw mahoeh maw. Kahawicalah na sak hoehpawiteh yon thuengnae sathei teh longkha koe a tabo. Ahnie a ngainae teh nange doeh. Hatei nang ni ahni na uk telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kain ni a nawngha Abel koevah law lah cet sei atipouh. Law a pha roi torei teh Kain ni a nawngha a taran teh a thei. ");
INSERT INTO cth_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Hatdawkvah, BAWIPA ni Kain koe, na maw na nawngha Abel te, telah a pacei navah, ahni ni ka panuek hoeh, ka nawngha ka khoum e nahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hahoi, BAWIPA ni bangmaw na sak na nawngha e thi ni talai dawk hoi kai koe a hram toe. ");
INSERT INTO cth_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Na kut hoi na palawng e na nawngha thi, dâw hanelah apâhni ka ang e talai dawk hoi nang teh atu thoebo lah na o toe. ");
INSERT INTO cth_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Talai dawk thaw na tawk navah a thaonae nang koe tâcawt mahoeh toe. Nang teh talai vah, ka yawng e tami hoi ka kâva a e tami lah na o han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ni BAWIPA koevah, reknae ka hmu e heh ka phu thai e hlak a lenhnawn. ");
INSERT INTO cth_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Sahnin teh talai hoi na pâlei toe ti ka panue. Na hmaitung hoi hro lah ka o toe. Talai van vah ka yawng e hoi yuengyoe kâva e tami lah kaawm vaiteh, ka hmawt e pueng ni na thei han doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Hatei, BAWIPA ni Kain koe nang ka thet e pueng teh let sari touh hoi a moi ka pathung han atipouh. Hahoi, BAWIPA ni Kain ka hmawt e tami, buet touh ni hai a thei hoeh nahanlah ahni dawk noutnae a ta pouh. ");
INSERT INTO cth_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hathnukkhu, Kain teh BAWIPA e hmaitung hoi a tâco teh, Eden kanîtholah, Nod ram dawk kho a sak. ");
INSERT INTO cth_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain ni a yu a panue teh, camo a vawn teh Enok a khe. Kho a thawng teh a capa min lah Enok kho telah min a poe. ");
INSERT INTO cth_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hahoi Enok ni Irad a khe. Irad ni Mehujael a khe. Mehujael ni Methushael a khe. Methushael ni Lamek a khe. ");
INSERT INTO cth_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Hathnukkhu, Lamek ni a yu kahni touh a la teh, apasueke min teh Adah, apâhni e min teh Zillah doeh. ");
INSERT INTO cth_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah ni Jabal a khe. Ahni teh rimnaw dawk kho ka sak e lah ao teh saringnaw kapacakung e na pa lah ao. ");
INSERT INTO cth_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","A nawngha e min teh Jubal. Ahni teh ratoung hoi vovitnaw ka pâtu e na pa lah ao. ");
INSERT INTO cth_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah ni hai Tubal-kain a khe. Ahni teh rahum hoi sum ka dei pueng e na pa lah ao. Naamah teh Tubal-kain e tawncanu lah ao. ");
INSERT INTO cth_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Hahoi, Lamek ni a yu roi Adah hoi Zillah koevah, ka lawk thai roi haw, patawnae na poe dawkvah tongpa buet touh ka thei. Na pacekpahlek dawkvah, thoundoun buet touh ka thei toe. ");
INSERT INTO cth_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kain ni let sari touh e moipathungnae khang pawiteh, Lamek ni teh a let 70 touh hoi a khang han. ");
INSERT INTO cth_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Hahoi, Adam ni a yu bout a panue teh, ca tongpa a khe. Seth telah min a phung. Bangkongtetpawiteh, Kain ni Abel a thei dawkvah Cathut ni alouke cati bout na poe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth ni hai capa a khe teh Enosh telah min a phung. Hahoi tami ni Jehovah min kaw han a kamtawng awh. ");
INSERT INTO cth_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam catounnaw cauk teh a rahim lae patetlah doeh. Cathut ni tami a sak navah amae meikalat lah a sak. ");
INSERT INTO cth_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tongpa hoi napui a sak teh yawhawinae a poe. A sak hnin ahnimouh roi teh tami telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam teh kum 130 touh a pha navah, ama hoi kâlat e ama hoi mei kâvan e ca tongpa a khe teh Seth telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth a khe hnukkhu, Adam teh kum 800 touh a hring teh ca tongpanaw hoi napuinaw hai bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam teh kum 930 touh akuep navah a due. ");
INSERT INTO cth_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth teh kum 105 touh a pha navah Enosh a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosh a khe hnukkhu Seth teh kum 807 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth teh a kum 912 touh akuep navah a due. ");
INSERT INTO cth_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh teh kum 90 touh a pha navah Kenan a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan a khe hnukkhu, Enosh teh kum 815 touh a hring teh ca tongpanaw hoi napuinaw khe. ");
INSERT INTO cth_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh teh kum 905 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan teh kum 70 touh a pha navah Mahalalel a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel a khe hnukkhu, Kenan teh kum 840 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan teh kum 910 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel teh kum 65 touh a pha navah Jared a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared a khe hnukkhu, Mahalalel teh kum 830 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel teh kum 895 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared teh kum 162 touh a pha navah Enok a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enok a khe hnukkhu Jared teh kum 800 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared teh kum 962 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok teh kum 65 touh a pha navah Methuselah a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Methuselah a khe hnukkhu Enok teh kum 300 touh thung Cathut hoi rei a ceio teh, ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok teh kum 365 touh a hring. ");
INSERT INTO cth_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok teh Cathut hoi cungtalah a ceio teh bout awmhoeh toe. Bangkongtetpawiteh, Cathut ni a la toe. ");
INSERT INTO cth_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah teh kum 187 touh a pha nah Lamek a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamek a khe hnukkhu Methuselah teh kum 782 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah teh kum 969 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek teh kum 182 touh a pha navah ca tongpa a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","BAWIPA ni thoebonae talai dawk kut hoi thaw tawk awh teh, patang khangnae dawk hoi lung na pahawi han ati teh, Noah telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noah a khe hnukkhu Lamek teh kum 595 touh a hring teh ca tongpanaw hoi napuinaw bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek teh kum 777 touh a hring teh a due. ");
INSERT INTO cth_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah teh kum 500 touh a pha nah Shem, Ham hoi Japheth a khe. ");
INSERT INTO cth_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Talai vah tami pungdaw a kamtawng navah, canunaw a khe awh teh, ");
INSERT INTO cth_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Cathut e capanaw ni tami e canunaw a meihawi e a hmu navah a ngai e patetlah a rawi awh teh, a paluen awh. ");
INSERT INTO cth_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Hat torei teh, BAWIPA ni ka muitha teh taminaw koe yungyoe kaawm sak mahoeh toe. Bangkongtetpawiteh, tami teh tak lah ao dawkvah, atu hoi teh tami e a hringnae teh kum 120 touh han toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Hatnae tueng dawk Nephilimnaw teh talai van ao awh. Hathnukkhu, Cathut e capanaw ni tami e canunaw a yonkhai awh teh, ahnimouh hanelah canaw a khe awh. Hote taminaw teh ayan e tueng dawk Athakasaipounge hoi min kamthang e naw lah ao awh. ");
INSERT INTO cth_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","BAWIPA ni talai van dawk tami e thoenae a len e hoi lungpouk pueng pou a payon toe tie a hmu. ");
INSERT INTO cth_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Hahoi BAWIPA ni talai van tami a sak e hah a lungmathoe teh a lung caca a pataw. ");
INSERT INTO cth_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hatdawkvah, BAWIPA ni ka sak e tami teh talai dawk hoi ka takhoe han toe. Tami hai, saring hai, vonpui hoi kâvanaw hoi kalvannaw dawk e tavanaw hai, ahnimanaw ka sak e dawk ka lung caca a pataw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hatei Noah teh BAWIPA lungyouk e tami lah ao. ");
INSERT INTO cth_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hethateh, Noah e catounnaw doeh. Noah teh tamikalan, a miphun dawk toun han kaawm hoeh e tami lah ao. Cathut hoi cungtalah a ceio. ");
INSERT INTO cth_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah ni Shem, Ham, hoi Japheth, ca tongpa kathum touh a khe. ");
INSERT INTO cth_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hat navah, talai teh Cathut hmalah karawk e lah ao. Talai teh yonnae hoi akawi. ");
INSERT INTO cth_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Cathut ni talai a khet navah, karawk e lah ao e hah a hmu. Bangkongtetpawiteh, talai van e tami pueng e takthai lamthung teh koung a ro toe. ");
INSERT INTO cth_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hatdawkvah, Cathut ni Noah koevah takthai pueng e a poutnae teh ka hmaitung a kamnue toe. Ahnimouh kecu dawk talai teh yonnae hoi akawi toe. Talai hoi cungtalah ahnimanaw teh ka raphoe katang han toe. ");
INSERT INTO cth_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Gopher thing hoi nama hanelah, long sak leih. Athung haiyah rakhannaw sak nateh, athung, avan petkâkalup lah thingtapi hoi kanan sin haw. ");
INSERT INTO cth_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hote long teh asaw e dong 300, akaw e dong 50, a rasang dong 30 touh a pha han. ");
INSERT INTO cth_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Long lemphu na sak vaiteh, a lathueng lahoi dong touh kakaw lah hlalangaw na sak vaiteh, tapang koe lah tho na sak han. Apasuekpoung, apâhni hoi apâthum telah coung thum touh lah na sak han. ");
INSERT INTO cth_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kahring e saring pueng, kalvan rahim hoi ka raphoe hanelah, talai van tuikamuem ka tho sak vaiteh, talai van kaawm pueng koung a due awh han. ");
INSERT INTO cth_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Nang koe ka lawkkam ka caksak han. Nama hoi capanaw na yu hoi langanaw teh long thung na kâen awh han. ");
INSERT INTO cth_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Hahoi ka hring e saring pueng thung e anapui hoi anatongpa kahni touh hring sak hanelah, nang hoi cungtalah long thung na kâen sak han. ");
INSERT INTO cth_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tava dawk hai amae aphun lah, saring dawk hai amae aphun lah, vonpui hoi kâva e dawk hai amae aphun lah, aphun tangkuem dawk e kahni touh hring sak hanelah nang koe a tho awh han. ");
INSERT INTO cth_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Hahoi nama ni na ca hane hoi saringnaw ni a ca hanelah, cakawi rawca aphunphun na la vaiteh, na pâkhueng han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Cathut ni kâ a poe e patetlah Noah ni koung a sak. ");
INSERT INTO cth_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hathnukkhu vah, BAWIPA ni Noah koe bout a dei pouh e teh, atu e taminaw thung dawk nang teh ka hmalah tamikalan lah na o e ka panue dawkvah, na imthungkhu abuemlahoi long thung kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kathounge saring dawk e anatongpa hoi anapui phun sari, kathounghoehe saring dawk e anatongpa hoi anapui phun hni touh, ");
INSERT INTO cth_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","kalvan e tava thung dawk e hai anatongpa hoi anapui phun sari touh telah lengkaleng talai van dawk hoi hlout sak hanelah, nama koe na thokhai han. ");
INSERT INTO cth_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Bangkongtetpawiteh, atu hoi kamtawng vaiteh hnin sari touh akuep navah, hnin 40 touh hoi a rum 40 touh thung kho ka rak sak vaiteh, ka sak e kahring e pueng koung ka raphoe han. ");
INSERT INTO cth_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","BAWIPA ni kâ a poe e patetlah Noah ni a sak. ");
INSERT INTO cth_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Talai van dawk tuikamuem a tho navah, Noah teh kum 600 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Tuikamuem kecu dawk, Noah hoi a capanaw, a yu hoi a langanaw teh a hlout nahanelah long thung a kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Cathut ni Noah koe kâ a poe e patetlah kathounge saringnaw hoi kathounghoehe saringnaw tavanaw hoi vonpui hoi kâva e saringnaw dawk e, ");
INSERT INTO cth_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","a napui hoi a na tongpanaw teh Noah hoi cungtalah long thung a kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hnin sari touh akuep hnukkhu hoi tuikamuem teh talai van a tho. ");
INSERT INTO cth_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah a kum 600 nae kum, thapa ayung pahni, hnin 17 nah, kadung poung e tuikhu pueng a kamawng teh kalvannaw dawk e hlalangaw pueng hai a kamawng. ");
INSERT INTO cth_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Hathnukkhu, hnin 40 touh hoi rum 40 touh talai van vah kho a rak. ");
INSERT INTO cth_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hote hnin dawk Noah hoi a capanaw, Shem, Ham, hoi Japheth, Noah e a yu hoi a langanaw teh long thung a kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ahnimouh hoi saring phun, sarang phun, talai dawk kâva e pueng dawk e phun, kamleng e tava phun, rathei ka tawn e pueng dawk e phun, a yuvâ lahoi long thung a kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Hringnae kâha ka tawn e pueng a yuvâ lahoi long thung Noah koe a kâen awh. ");
INSERT INTO cth_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hottelah Cathut ni lawk a thui e patetlah saring thung dawk e anatongpa hoi anapui a kâen sak teh, BAWIPA ni Noah teh athung vah tho a khan sin. ");
INSERT INTO cth_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tuikamuem teh talai van hnin 40 touh thung a kamuem. Tui hoehoe a len teh talai dawk hoi long teh a kâtakhoe teh a tawm. ");
INSERT INTO cth_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Talai van tui hoehoe a len teh, long teh tui van lah hoehoe a kâtawm. ");
INSERT INTO cth_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hahoi, tui teh talai van dawk a tha hoehoe ao teh, kalvan rahim kaawm e mon ka rasang pueng koung a muem. ");
INSERT INTO cth_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tui ni a muem e monnaw e a lathueng tui teh dong 15 touh arasang. ");
INSERT INTO cth_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Hatdawkvah, talai van ka kâroe e tava, sarang, saring, talai dawk ka kâva e saring pueng hoi tami pueng teh koung a due awh. ");
INSERT INTO cth_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","A oung lah kaawm e pueng hai koung a due. ");
INSERT INTO cth_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Hottelah talai van kaawm ni teh hringnae ka tawn e pueng, tami hoi saring, a von hoi ka kâvanaw hoi kalvan e tavanaw koung a thei. Noah hoi cungtalah long thung kaawmnaw dueng doeh kahlout. ");
INSERT INTO cth_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Hnin 150 touh thung tui teh talai van a kamuem. ");
INSERT INTO cth_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hateiteh, Cathut ni Noah hoi cungtalah long thung kaawm e kahring e pueng hoi saring pueng teh pahnim hoeh. Hahoi Cathut ni kahlî a tho sak teh tui a kum sak. ");
INSERT INTO cth_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ka dungpoung koe e tui kâkhunaw hoi kalvan e hlalangawnaw hai a khan teh khorak e a dep sak. ");
INSERT INTO cth_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Talai van e tui hah, pout laipalah a kum sak teh, hnin 150 touh aloum hnukkhu tui teh a hak. ");
INSERT INTO cth_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hottelah long teh thapa yung sarinae hnin 17 nah Ararat mon dawk a kâhat. ");
INSERT INTO cth_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Ahranae thapa totouh tui teh pout laipalah, a kum cathuk. Thapa yung hra, apasuek hnin dawk monsomnaw teh a kamnue . ");
INSERT INTO cth_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Hahoi, hnin 40 touh abaw hnukkhu, Noah ni long dawk e hlalangaw a sak e a paawng. ");
INSERT INTO cth_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Vonga buet touh a patoun teh, talai van tui a hak hoehroukrak a voivang lah yuengyoe a kamleng. ");
INSERT INTO cth_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Hahoi talai van e tui a hak toung maw tie panue thai nahanlah âbakhu hah ama koehoi a patoun. ");
INSERT INTO cth_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Hateiteh âbakhu ni a kâhat nahan a hmu hoeh dawkvah, long thung ama koe bout a ban. Bangkongtetpawiteh, tui teh talai van koung a kamuem rah. Noah ni a kut a dâw teh âbakhu a la hnukkhu, long thung ama koe bout a pakhum. ");
INSERT INTO cth_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Hnin sari touh bout ao hnukkhu hote âbakhu hah long thung hoi bout a patoun. ");
INSERT INTO cth_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tangmin lah âbakhu teh Noah koe bout a ban teh, a pahni hoi ka hringsuep e Olive hna a thokhai teh, Noah ni talai van tui a hak toe tie a panue . ");
INSERT INTO cth_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Hnin sari touh bout aloum hnukkhu hote âbakhu, bout a patoun teh ama koe bout ban hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kum 601, apasueke thapa apasuek hnin navah, talai van e tui pueng teh koung a hak. Hatdawkvah, Noah ni long ramuknae a hawng teh a khet navah talai van remke e hah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Apâhni e thapa, hnin 17 nah, talai teh remphui toe. ");
INSERT INTO cth_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Hottelah Cathut ni Noah koevah, ");
INSERT INTO cth_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Nama hoi na yu, na capanaw hoi na langanaw, long thung hoi tâcawt awh leih. ");
INSERT INTO cth_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nang koe kaawm e moithang, saring pueng, tava pueng, vonpui hoi kâva e pueng, talai van ca a khe vaiteh, pungdaw thai nahanelah, tâcawtkhai leih, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Hatdawkvah, Noah teh ama koe kaawm e a capanaw hoi a yu, a capanaw hoi a yunaw hoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Moithang, saring pueng, a von hoi kâva e pueng, tava phunkuep hoi talai van kâroe e pueng long thung hoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hahoi, Noah ni BAWIPA hanelah khoungroe a sak teh, khoungroe dawk hmaisawi thuengnae a sak. ");
INSERT INTO cth_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","BAWIPA ni hai hmuitui hmui a thai teh, kai ni taminaw hanelah, talai teh thoe bout ka bo mahoeh. Bangkongtetpawiteh, taminaw teh a nawca hoi lungthin pouknae a mathoe. Kai ni atu ka sak e patetlah kahring e pueng ka raphoe mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Talai tueng ao nathung, cati patuenae tueng hoi anae tueng, pâdingnae hoi abetnae, kompawi tue hoi kasik tue, khodai karum nâtuek hai ka pout sak mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hottelah Cathut ni Noah hoi a canaw yawhawinae a poe teh, ahnimouh koe, ca moi khe awh, pungdaw awh nateh, talai van kawi awh. ");
INSERT INTO cth_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Talai van moithang, saring phunkuep, kalvan e tava phunkuep, talai van a von hoi kâva e pueng, hoi tui thung e tanga pueng ni nangmouh na taki vaiteh a pâyaw awh han. Hote moithang pueng teh nangmae kut dawk na poe. ");
INSERT INTO cth_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kahring ni teh kâroe e pueng nangmouh han rawca lah ao han. Hnopai pueng, anhla kahring pueng totouh na poe awh han. ");
INSERT INTO cth_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hottelah a moi hah a hringnae a thi hoi hmai na cat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Hahoi, nangmae hringnae thi phu teh ka hei han. Tami saring pueng koe ka hei han. Tami tangkuem e hmaunawnghanaw koe, tami e hringnae phu teh ka hei roeroe han. ");
INSERT INTO cth_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Apipatethai tami e thi ka palawng e tami teh tami ni thi palawng lah ao van han. Bangkongtetpawiteh, tami teh Cathut ni amae meikalat lah a sak e doeh. ");
INSERT INTO cth_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Hateiteh, nangmouh teh ca khe awh nateh pungdaw awh. Talai van vah canaw moi khe awh nateh pungdaw awh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Cathut ni Noah hoi a capanaw koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Nangmouh hoi thoseh, nangmae catoun hoi thoseh, ");
INSERT INTO cth_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nangmouh koe kaawm e kahring e moithang pueng, tava pueng, saring pueng, long thung hoi tâcokhai e saring pueng koe lawkkam ka caksak han. ");
INSERT INTO cth_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nangmouh koe lawkkam ka caksak e teh, tuikamuem lahoi nâtuek hai moithang pueng ka raphoe mahoeh toe. Talai teh tui hoi ka raphoe mahoeh toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Cathut ni kai hoi nang rahak, nang koe kaawm e kâroe ni teh kahring e pueng hoi na catounnaw rahak vah ka sak e lawkkam mitnoutnae doeh. ");
INSERT INTO cth_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Kaie salumpa hah tâmai dawk ka hruek vaiteh, kai hoi talai rahak lawkkam mitnoutnae lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Kai ni tâmai ka tabo sak navah, tâmai dawk salumpa a kamnue han. ");
INSERT INTO cth_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Kai hoi nang rahak, kahring ni teh kâroe e pueng koe, ka lawkkam e pou ka pouk vaiteh, saring moithang pueng tuikamuem hoi ka raphoe mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tâmai dawk salumpa a paham e ka khet vaiteh, Cathut hoi talai van kaawm e kahring e saring moithang pueng rahak vah, yungyoe e lawkkam ka pouk han. ");
INSERT INTO cth_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hahoi Cathut ni Noah koe, hete teh kai hoi talai van kaawm e moithang saring pueng rahak vah, ka caksak e lawkkam mitnoutnae doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Long thung hoi a tâco navah Noah e a capanaw teh Shem, Ham, Japheth. Ham teh Kanaan e a na pa lah ao. ");
INSERT INTO cth_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ahnimanaw kathum touh teh Noah e a capanaw lah ao teh, ahnimanaw koehoi talai van taminaw a pungdaw. ");
INSERT INTO cth_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noah ni law sak a kamtawng teh, misur takha a sak. ");
INSERT INTO cth_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Misurtui hai a nei dawkvah a parui teh tawngtai lah ao. ");
INSERT INTO cth_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanaan e na pa Ham ni a na pa caici lah ao e a hmu teh alawilah kaawm e a hmaunawngha kahni touh koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Hatei Shem hoi Japheth ni teh hni a la roi teh a loung dawk a thueng roi teh, kâhnawn laihoi a na pa e caicinae teh a ramuk pouh roi. Ahnimouh roi teh alawilah a kangvawi roi dawkvah, a na pa caici lah ao e hah hmawt roi hoeh. ");
INSERT INTO cth_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noah ni misur parui e a thangcuem torei teh a capa cahnoung e ni a sak e a panue. ");
INSERT INTO cth_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Hatdawkvah, Kanaan teh thoebo lah awm seh. A hmau roi koe san thung dawk e san lah awm seh. ");
INSERT INTO cth_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hahoi, Shem e BAWIPA Cathut teh yawhawinae awm seh. Kanaan teh ahni koe san lah awm seh. ");
INSERT INTO cth_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Cathut ni Japheth teh len nateh roung seh. Shem e lukkareiim dawk awm seh. Kanaan teh ahni koe san lah awm seh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noah teh tuikamuem a tho hnukkhu kum 350 a hring. ");
INSERT INTO cth_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noah e a hringnae teh kum 950 touh a pha teh a due. ");
INSERT INTO cth_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Tuikamuem a tho hnukkhu, Noah capa Shem, Ham hoi Japheth koehoi patuen a khe e casaknaw teh a rahim lae patetlah doeh. ");
INSERT INTO cth_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth e capanaw teh Gomer, Magog, Madai, Javan, Tubal, Meshek hoi Tiras. ");
INSERT INTO cth_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer e capanaw teh, Ashkenaz, Riphath hoi Togarmah. ");
INSERT INTO cth_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan e capanaw teh, Elishah, Tarshish, Kittim hoi Dodarim. ");
INSERT INTO cth_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ahnimanaw teh miphun tangkuem, ram louk hmuennaw hah amamae ram, amamae lawk, amamae imthung lahoi amamae ram dawk lengkaleng kâkapek awh. ");
INSERT INTO cth_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hahoi, Ham e capanaw teh Kush, Izip, Put hoi Kanaan, ");
INSERT INTO cth_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kush e capanaw teh Seba, Havilah, Sabtah, Raamah hoi hmaloe pasuek a thakasaipoung e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Hahoi Kush ni Nimrod a khe teh, ahni teh talai van dawk hmaloe pasuek a thakasaipoung e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ahni teh BAWIPA hmalah thakasaipounge lah ao. Hatdawkvah, BAWIPA hmalah thaonae hoi moikathaipounge Nimrod patetlah ouk ati awh. ");
INSERT INTO cth_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","A uknaeram a kamtawngnae teh, Babilon, Erek, Akkad hoi Shinar ram e Kalneh. ");
INSERT INTO cth_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Hote ram koehoi Assiria ram lah a cei teh Nineveh, Rehobothir aka lahoi, ");
INSERT INTO cth_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Nineveh hoi Kalah rahak kaawm e Resen khopui kalenpounge kho hmuen hai a thawng. ");
INSERT INTO cth_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Izip e capanaw teh Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO cth_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim (philistin hoi Kaphtorimnaw a tâconae) hoi Kapthorim, ");
INSERT INTO cth_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan e a camin teh Sidon, hahoi Heth, ");
INSERT INTO cth_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","hahoi Jebusit tami Amor tami, Girgashite tami, ");
INSERT INTO cth_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiv tami, Arkit tami, Sin tami, ");
INSERT INTO cth_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad tami, Zemarit tami hoi Hamath taminaw hah a khe. Hathnukkhu, Kanaan e ca catounnaw teh a kampek awh. ");
INSERT INTO cth_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanaannaw e a ramri Sidon hoi Gerar koelae Gaza totouh. Hahoi Sodom, Gomorrah, Admah, hoi Zeboiim kho a tapoung teh Lasha kho totouh a pha. ");
INSERT INTO cth_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hete miphunnaw teh Ham e ca catounnaw doeh. Ahnimanaw teh amamae imthung lahoi, lawk lahoi, kho hmuen lahoi, amamae ram thung kho lengkaleng a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Japheth e nawngha, Hebru miphunnaw e a na pa Shem haiyah canaw a khe. ");
INSERT INTO cth_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem e capanaw teh Elam, Assyria, Arphaxad, Lud hoi Aram. ");
INSERT INTO cth_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram e capanaw teh Uz, Hul, Gether hoi Mash. ");
INSERT INTO cth_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad e capa teh Shelah, Shelah e capa teh Eber, ");
INSERT INTO cth_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ni capa kahni touh a khe. Buet touh e min teh Peleg. Bangkongtetpawiteh, ahnie a se navah talai a kârei awh. A nawngha e min teh Joktan. ");
INSERT INTO cth_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan e a capanaw teh, Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO cth_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO cth_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO cth_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, hoi Jobab, ");
INSERT INTO cth_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kho a saknae hmuen teh Mesha kho koehoi kanîtholah Sephar mon totouh a pha. ");
INSERT INTO cth_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Hete taminaw teh Shem e capanaw lah ao teh, amamae imthung lahoi, lawk, kho ram tangkuem dawk kho a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","A lathueng lae khenae hoi miphunnaw teh, Noah e imthung hoi a capanaw ni patuen a khe e catounnaw e kong doeh. Ahnimanaw teh tuikamuem a tho hnukkhu kho ram alouklah a kampek awh. ");
INSERT INTO cth_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Hatnavah lawk phun touh hoi lawk pan e buet touh dueng doeh kaawm . ");
INSERT INTO cth_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kanîtholah hoi kahlawng a cei awh teh, Shinar ram dawk tanghling a hmu awh teh, haw vah kho hmuen a thawng awh. ");
INSERT INTO cth_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Hat torei teh, buet touh hoi buet touh, tho awh amhru sak awh vaiteh kahawicalah pâeng awh sei telah a kâti awh. Hottelah talung e yueng lah amhru a hno awh teh pato nahanelah ailai a hno awh. ");
INSERT INTO cth_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Hahoi, tho awh mamouh hanelah khopui thawng awh vaiteh kalvan kadeng lah imrasang sak awh sei. Mamouh hanelah min kamsawng sak awh sei, telah hoehpawiteh talai van tangkuem koe kâkahei payon han doeh telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hatei taminaw e capanaw ni a thawng awh e khopui hoi imrasang khet hanlah BAWIPA teh a kum. ");
INSERT INTO cth_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","BAWIPA ni khenhaw! taminaw teh miphun buet touh lah ao awh teh lawk buet touh dueng a hno awh dawkvah, hete hno hmaloe pasuek a kamtawng awh. Sak han a ngai awh e kangangkung awm laipalah a sak awh han doeh. ");
INSERT INTO cth_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hatdawkvah, tho awh, kum awh sei. Ahnimanaw buet touh hoi buet touh lawk kâthai awh hoeh nahanelah, lawk alouklouk lah sak awh sei telah ati. ");
INSERT INTO cth_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hottelah BAWIPA ni ahnimanaw teh talai van a kampek sak awh teh khopui kangdout sak thai awh hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Hatdawkvah, Babel telah min a poe. Bangkongtetpawiteh, hote hmuen koehoi BAWIPA ni lawk alouklouk lah a pan sak teh talai van koung a kampek sak. ");
INSERT INTO cth_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hetnaw teh Shem e ca catounnaw doeh. Shem teh kum 100 touh a pha nah, tuikamuem a tho hnukkhu kum 2 touh aloum nah capa Arphaxad a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arphaxad a khe hnukkhu, Shem teh kum 500 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphaxad teh kum 35 touh a pha nah capa Shelah a khe. ");
INSERT INTO cth_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelah a khe hnukkhu Arphaxad teh kum 403 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah teh kum 30 touh a pha nah Eber a khe. ");
INSERT INTO cth_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber a khe hnukkhu Shelah teh kum 403 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber teh kum 34 touh a pha nah capa Peleg a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg a khe hnukkhu Eber teh kum 430 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg teh kum 30 touh a pha navah Reu a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu a khe hnukkhu Peleg teh kum 209 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu teh kum 32 touh a pha navah Serug a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug a khe hnukkhu Reu teh kum 207 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug teh kum 30 touh a pha nah Nahor a khe. ");
INSERT INTO cth_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor a khe hnukkhu Serug teh kum 200 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor teh kum 29 touh a pha navah Terah a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah a khe hnukkhu Nahor teh kum 119 touh a hring teh ca tongpanaw hoi napuinaw bout a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah teh kum 70 touh a pha nah Abram, Nahor, hoi Haran a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terah e casaknaw teh, Terah ni Abram, Nahor hoi Haran a sak. Haran ni Lot a sak. ");
INSERT INTO cth_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haran teh a na pa Terah hmaitung, a khenae hmuen Khaldean taminaw a onae Ur kho dawk a due. ");
INSERT INTO cth_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Hahoi, Abram hoi Nahor ni a yu a la roi. Abram e a yu min teh Sarai, Nahor e a yu min teh Haran e a canu Mikah. Haran teh Milkah hoi Iskah e a na pa lah ao. ");
INSERT INTO cth_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Hatei Sarai teh carôe dawkvah ca tawn hoeh. ");
INSERT INTO cth_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Terah ni a capa Abram hoi a capa Haran capa Lot, a langa lah kaawm a capa Abraham e yu Sarai, a kaw teh Kanaan ram lah cei hanelah Khaldean taminaw a onae Ur kho hoi a tâcokhai, Hatei Haran kho a pha awh navah haw vah kho a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Terah teh kum 205 touh a pha navah, Terah teh Haran kho dawk a due. ");
INSERT INTO cth_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","BAWIPA ni Abram koevah, Na ram, na imthung hoi na pa im cettakhai nateh kai ni na patue e ram koe lah cet leih. ");
INSERT INTO cth_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Kai ni miphun kalen lah na sak vaiteh, yawhawinae na poe han. Na min kamsawng sak vaiteh yawhawinae ka coe e tami lah na o han. ");
INSERT INTO cth_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Nang yawhawinae ka poe e tami teh yawkahawi sak vaiteh, thoe na ka bo e tami teh thoe ka bo van han. Nang lahoi tami pueng ni yawhawinae a coe awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","BAWIPA ni a dei pouh e patetlah Abram ni a kamthaw teh, Lot hai a kâbang van. Haran kho hoi a tâco navah Abram teh kum 75 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraham ni a yu Sarai, a hmau e capa Lot hoi hnopai pueng thoseh, Haran kho dawk a hmu e taminaw hai thoseh, a ceikhai teh Kanaan ram pha hanelah a tâco. Hottelah hoi Kanaan ram a pha. ");
INSERT INTO cth_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram ni hote ram dawk yuengyoe a kâhlai teh, Shekhem hmuen Moreh e kathen kung koe a pha. Han navah Kanaan taminaw hote ram dawk yo la o awh toe. ");
INSERT INTO cth_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","BAWIPA teh Abram koe a kamnue teh hote ram teh na ca catounnaw na poe han atipouh. Hote ka kamnuek e BAWIPA hanelah khoungroe a sak pouh. ");
INSERT INTO cth_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Hote hmuen koehoi Bethel kho Kanîtholae mon dawk a kampuen teh kanîloumlah Bethel hoi kanîtholah Ai kho rahak rim a sak. Hote hmuen koe BAWIPA hanelah khoungroe a sak teh BAWIPA e min a kaw. ");
INSERT INTO cth_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hottelah Abram teh akalah kampuen hanlah a cei teh, Negev totouh a pha. ");
INSERT INTO cth_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hathnukkhu Kanaan ram takang a tho dawkvah, Abram teh Izip ram lah a cei. Bangkongtetpawiteh, ram thung puenghoi takang a tho dawk doeh. ");
INSERT INTO cth_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Izip ram a pha tawmlei navah a yu Sarai koe nang teh meikahawi e napui lah na o tie ka panue . ");
INSERT INTO cth_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Hatdawkvah, Izip taminaw ni nang na hmu awh navah, hete napui teh a yu doeh tet awh vaiteh kai na thei awh han, hatei nang teh na hlout sak awh han. ");
INSERT INTO cth_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hatdawkvah, a tawncanu doeh na ti pouh han. Hottelah na dei pouh pawiteh nang dawk hoi kai hawinae ka hmu vaiteh ka hringnae hai a hlout han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abram teh Izip ram a kâen navah Izip taminaw ni a yu a hmu navah a meihawi ati awh. ");
INSERT INTO cth_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Faro e ukkungnaw ni a hmu navah, Faro hanelah a oup awh teh Faro im vah a ceikhai awh. ");
INSERT INTO cth_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Faro siangpahrang ni napui kecu dawk Abram teh a khetyawt. Tu, Maito, La apui atan, sannu sanpa hoi kalauknaw a poe. ");
INSERT INTO cth_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hatei BAWIPA ni Abram e yu Sarai kecu dawk Faro hoi a imthungnaw pueng hoi runae a poe. ");
INSERT INTO cth_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Faro ni Abram a kaw teh, kai dawk na sak e hno Bangtelamaw, bangkongmaw na yu nahlangva, na dei hoeh vaw. ");
INSERT INTO cth_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Bangkongmaw ka tawncanu na ti teh yu lah na la sak. Hatdawkvah, na yu heh atu hrawi nateh cet leih telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hottelah Faro ni a taminaw kâ a poe teh a yu hoi a tawn e naw pueng hoi a cei sak. ");
INSERT INTO cth_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hathnukkhu Izip ram hoi Abram a tâco teh akalae ram Negev lah vah a yu, a tawn e hnopai pueng hoi a kamthaw teh a hnuk vah Lot hai a kâbang. ");
INSERT INTO cth_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram teh saringnaw, suinaw, ngunnaw hoi lutlut a bawi. ");
INSERT INTO cth_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Negev ram lahoi bout a kamthaw teh ahmaloe pasuek e rim ao na koe lah a cei. Hote im teh Bethel hoi Ai kho rahak vah ao. ");
INSERT INTO cth_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Hmaloe pasuek e khoungroe a saknae hmuen koe bout a pha navah, Abram ni BAWIPA min a kaw. ");
INSERT INTO cth_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abram koe kâbang e Lot hai tunaw, maitonaw hoi rimnaw a tawn van. ");
INSERT INTO cth_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ahnimouh roi teh cungtalah kho rei a sak roi hanelah, hote ram ni khout hoeh. Hnopai a tawn roi e ekvoi apap dawkvah cungtalah kho sak thai roi hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hatdawkvah, Abram e saring kakhoumnaw hoi Lot e saring kakhoumnaw kâpohoehnae ao. Hat nae tueng dawk Kanaan tami hoi Periznaw hote ram dawk ao awh. ");
INSERT INTO cth_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Hahoi, Abram ni Lot koevah, maimouh roi teh, hmaunawngha roi doeh. Hatdawkvah, nang hoi kai rahak thoseh, nange saring kakhoumnaw hoi kaie saring kakhoumnaw rahak thoseh kâpohoehnae awm hanh naseh. ");
INSERT INTO cth_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Na hmalah ram moi ao nahoehmaw. Kai koehoi cet leih. Nang avoilah na cet pawiteh kai aranglah ka cei han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot ni a radoung navah, Jordan yawn pueng teh tui ka duk niteh, Jehovah e takha patetlah Sodom hoi Gomorrah kho BAWIPA ni a raphoe hoehnahlan, Zoar lah ceinae Izip ram patetlah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hottelah Lot ni Jordan yawn pueng a rawi. Hatdawkvah, Lot teh kanîtholah a cei teh buet touh hoi buet touh a kamphei roi. ");
INSERT INTO cth_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram teh Kanaan ram dawk kho a sak. Lot teh thingyei yawn dawk e khopuinaw koe kho a sak teh, Sodom kho teng rim a sak. ");
INSERT INTO cth_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hatei Sodom kho taminaw teh tamikathout lah ao awh teh, BAWIPA koevah tamikayon poung lah ao awh. ");
INSERT INTO cth_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot hoi a kamphei hnukkhu BAWIPA ni Abram a kaw teh na onae hmuen koehoi atung, aka, kanîtho, kanîloumlah radoung haw. ");
INSERT INTO cth_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Na hmu e ram pueng nama hoi na ca catounnaw na poe vaiteh a yungyoe e ram lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Na ca catounnaw vaiphu patetlah ka pungdaw sak han. Tami ni vaiphu touk thai pawiteh na ca catounnaw hai a touk thai han. ");
INSERT INTO cth_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Thaw nateh ayung lahoi thoseh, adangka lahoi thoseh cet haw, kai ni na poe han. ");
INSERT INTO cth_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hatdawkvah, Abram ni rim a puen teh Hebron kho Mamre kathenkungnaw koe kho a sak teh, BAWIPA hanelah khoungroe a sak pouh. ");
INSERT INTO cth_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Hatnae tueng dawk Shinar siangpahrang Amraphel, Ellasar siangpahrang Ariyawk, Elam siangpahrang Kedorlaomer hoi Goiim siangpahrang Tidal ti naw hoi, ");
INSERT INTO cth_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Sodom siangpahrang Bera, Gomorrah siangpahrang Birsha, Admah siangpahrang Shinab, Zebiim siangpahrang Shemeber, Zoar siangpahrang Bela tinaw taran a kâtuk awh. ");
INSERT INTO cth_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ahnimanaw pueng teh palawi tui tie Siddim yawn dawk a kamkhueng awh. ");
INSERT INTO cth_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kum 12 touh thung Kedorlaomer koe san lah ao awh teh, kum 13 nae dawk teh a tuk awh. ");
INSERT INTO cth_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kum 14 nae dawk teh Kedorlaomer ni ama koe lah kambawng e siangpahrangnaw hoi a tho awh teh, Ashterothkarnaim kho dawk Rephaim taminaw, Ham kho dawk Zuzim taminaw, Kiriathaim koe Emim taminaw, ");
INSERT INTO cth_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Seir mon dawk Khori taminaw hoi thingyei yawn teng kaawm e Elparan kho totouh a thei awh. ");
INSERT INTO cth_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hahoi bout a ban awh teh Kadesh ram Enmishpat kho dawk a pha awh navah, Amalek ram dawk kaawm e tami pueng, Hazezontamar kho dawk kaawm e Amor taminaw hai koung a thei awh. ");
INSERT INTO cth_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hathnukkhu Sodom siangpahrang, Gomorrah siangpahrang, Admah siangpahrang, Zeboiim siangpahrang hoi Bela siangpahrang, tinaw a cei awh teh, Siddim yawn dawk a kâtuk awh hanelah a kamkhueng awh. ");
INSERT INTO cth_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Hottelah, Elam siangpahrang Kedorlaomer, Goiim siangpahrang Tidal, Shinar siangpahrang Amraphel, Ellasar siangpahrang Aryawk, ahnimanaw pali touh ni siangpahrang panga touh a tuk awh. ");
INSERT INTO cth_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Siddim yawn teh tuithaw dui ka cawt e tangkawmnaw ao dawkvah, Sodom hoi Gomorrah siangpahrang teh a yawng roi, a tangawn te tangkom dawk a bo teh alouknaw teh mon lah a yawng. ");
INSERT INTO cth_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Hatdawkvah, Sodom hoi Gomorrah kho dawk kaawm e hnopai pueng, canei kawi kaawm pueng a la awh teh a ban awh. ");
INSERT INTO cth_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Sodom kho dawk kaawm e Abram e a hmau e capa Lot hoi a hnopai pueng hai koung a la awh. ");
INSERT INTO cth_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hote runae dawk hoi ka hlout e tami buet touh a tho teh, Hebru tami Abram koe a dei pouh. Ahni teh Amor tami Mamre e kathenkungnaw teng ao. Mamre teh Eskol hoi Aner e hmau doeh. Ahnimanaw teh Abram hoi cungtalah kambawng awh e doeh. ");
INSERT INTO cth_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abram ni a hmau e capa hah san hanelah a man awh toe tie a thai navah, ama im ka khe ni teh a cangkhai e tami 318 touh a hrawi teh, Dan kho totouh a pâlei. ");
INSERT INTO cth_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Khohmo navah, a hrawi e taminaw a kapek teh a tuk sak Damaskas atunglah kaawm e Hobah kho totouh a pâlei. ");
INSERT INTO cth_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","A ceikhai e hnopai pueng, a hmau e capa Lot hoi a hnopai pueng napuinaw hoi a taminaw bout a bankhai. ");
INSERT INTO cth_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Khedorlaomer hoi ama koe kaawm e siangpahrangnaw koung a thei hnukkhu a ban navah, Sodom siangpahrang teh Shaveh yawn dawk Abram dawn hanelah a tho. (Shaveh yawn teh siangpahrang yawn doeh). ");
INSERT INTO cth_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Salem siangpahrang Melkhizedek ni vaiyei hoi misurtui a sin. (Ahni teh ka rasang poung e Cathut e vaihma doeh). ");
INSERT INTO cth_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Hahoi, Abram yawhawinae a poe teh, kalvan hoi talai katawnkung ka rasang poung e Abram Cathut teh yawhawinae awm seh. ");
INSERT INTO cth_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na tarannaw na kut dawk na kapoekung ka rasang poung e Cathut teh yawhawinae awm seh telah ati. Abram ni hai hnopai a tawn e pueng dawk hoi pung hra pung touh a poe. ");
INSERT INTO cth_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom siangpahrang ni Abram koevah taminaw teh kai na poe, hatei hnopainaw teh lat yawkaw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Hatei Abram ni Sodom siangpahrang koe ralui buet touh hoi khokkhawm rui buet touh boehai nang koe ka lat mahoeh, ");
INSERT INTO cth_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","telah kalvan hoi talai katawnkung Jehovah, ka rasang poung e Cathut koe ka kut ka dâw toe. Telah hoehpawiteh Abram teh kai ni ka bawi sak e doeh na tet payon vaih. ");
INSERT INTO cth_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Thoundounnaw ni a canei e hoi ka hrawi e ka taminaw ni a coe hane hloilah teh banghai ka lat mahoeh. Aner, Eshkol hoi Mamre ni a coe awh e teh ama ni lat awh naseh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Hathnukkhu, Abram koe BAWIPA e lawk vision lahoi ka tho e teh, Abram, taket hanh kai teh nange bahling lah ka o, na tawkphu hmu hane a len poung telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Hatei Abram ni, Oe Bawipa Jehovah, ca tawn laipalah ka o e na hmu nahlangva, bangmaw na poe han. Im e râw kacoekung teh Damaskas tami Eliezer doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Hahoi Abram ni khenhaw! kai ca na poe hoeh. Ka im kaawm e ni doeh râw a coe toe telah bout atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","BAWIPA e lawk Abram koe ka tho e teh, hete tami kaawm e ni nange râw coe mahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hahoi Abram hah alawilah a hrawi teh, kalvan lah khenhaw! âsi na touk thai pawiteh touk haw, hot patetlah na catoun ka pungdaw sak han. ");
INSERT INTO cth_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ni BAWIPA a yuem dawkvah, ahnie a yuemnae hah a lannae lah a khoe pouh. ");
INSERT INTO cth_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hahoi kai ni hete ram poe hane hoi coe sak hane ka ngai dawk doeh Khaldean taminaw a onae Ur kho hoi nang kahrawikung kai teh BAWIPA doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hatei ahni ni Bawipa Jehovah, hete bangtelah hoi maw ka coe han tie ka panue han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","BAWIPA ni Abram koe a dei pouh e teh, kum thum touh e maito, kum thum touh e hmaela, kum thum touh e tutan buet touh âbakhuca hoi bakhuca buet touh thokhai loe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Hote hnonaw pueng ahni koe a thokhai pouh teh a lungui hoi a sei teh avoivang lah a hruek. Hatei tava teh sei hoeh. ");
INSERT INTO cth_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Hote moinaw koevah langtanaw a tho navah Abram ni a pâlei. ");
INSERT INTO cth_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Hatei kanî a khup toteh, Abram teh mat a i. Hahoi khenhaw! puenghoi hmonae ni a tho sin teh roumkalue. ");
INSERT INTO cth_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Hathnukkhu BAWIPA ni Abram koe, na ca catounnaw ni ayânaw e ram dawk imyin lah ao awh vaiteh, kum 400 touh thung rektapnae hoi san lah ao awh han tie kamcengcalah panuek. ");
INSERT INTO cth_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Hatei ahnimanaw san lah ka hno e taminaw kai ni lawk ka ceng han. Hathnukkhu hnopai moikapap hoi a tâco awh han. ");
INSERT INTO cth_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Nang teh mintoenaw koe karoumcalah na cei vaiteh matawng lahoi na pakawp awh han. ");
INSERT INTO cth_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Hateiteh a se palinae dawk hete ram dawk bout a ban awh han. Bangkongtetpawiteh Amornaw ni thoesaknae kuep sak lah awm hoeh rah, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Kanî a khup teh kho bout a hmo torei teh hmaikhu tâconae hlaam hoi hmai paangnae hmaiim teh moi tâtueng e rahak yuengyoe a kâhlai. ");
INSERT INTO cth_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hote hnin dawk BAWIPA ni Abram hoi lawkkamnae a sak teh Izip palang koehoi palang kalenpounge Euphrates totouh, ");
INSERT INTO cth_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ken tami, Kene tami, Kadmon tami, ");
INSERT INTO cth_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit tami, Periz tami, Rephaim tami, ");
INSERT INTO cth_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor tami, Kanaan tami, Girgashite taminaw hoi Jebusit taminaw e ram, na ca catounnaw ka poe toe, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abram e yu Sarai ni ahni hanelah ca khe pouh hoeh. Hatei ahni ni vah a sannu Izip tami buet touh a tawn. A min teh Hagar. ");
INSERT INTO cth_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Hatdawkvah, Sarai ni Abram koevah khenhaw! BAWIPA ni ca khe hanelah kâ na poe hoeh. Ka sannu koe mah cet leih ahni koehoi ca khe thai yawkaw han doeh telah atipouh. Sarai e lawk Abram ni a tarawi pouh. ");
INSERT INTO cth_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hottelah Abram teh Kanaan ram kum 10 touh ao hnukkhu Abram e yu Sarai ni a sannu Izip tami Hagar hah a hrawi teh a vâ Abram koe a yu hanelah a poe. ");
INSERT INTO cth_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ahni ni Hagar a ikhai teh camo a vawn. Camo vawn tie a kâpanue torei teh a bawinu hah a hnephnap. ");
INSERT INTO cth_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Hat torei teh Sarai ni Abram koevah, kai dawk thoenae a sak e heh nang lathueng phat seh. Kai ni ka sannu na poe ei camo vawn tie a panue torei teh a mit hoi kai na hnephnap. BAWIPA ni nang hoi kai rahak lawkceng lawiseh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Hatei Abram ni Sarai koevah, na sannu teh na kut dawk doeh ao. Sarai ni puenghoi a yue teh ahni koehoi oun a yawng. ");
INSERT INTO cth_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","BAWIPA e kalvantami ni Shur kho lah ceinae kahrawngum lam teng tuiphuek teng vah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Sarai e sannu Hagar, nâ lahoi maw na tho teh nâ lah maw na cei han telah a pacei. Hat torei teh ahni ni ka bawinu Sarai koehoi ka yawng e doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","BAWIPA e kalvantaminaw, na bawinu koe bout ban nateh a kut rahim awm pouh loe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","BAWIPA e kalvantami ni, na canaw moikapap ka pungdaw sak vaiteh na touklek thai mahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hahoi, BAWIPA e kalvantami ni thaihaw, camo na vawn vaiteh ca tongpa na khe han, Ishmael telah min na phung han. Bangkongtetpawiteh nange na reithainae BAWIPA ni a thai toe. ");
INSERT INTO cth_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Hatei na capa teh la ka matheng e lah ao han. Tami pueng a taran vaiteh tami pueng ni hai a taran van han. A hmaunawngha pueng hai a taran vaiteh kho a sak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hottelah ahni koe lawk ka dei e BAWIPA min a kaw teh, Nang teh kai kahmawtkung Cathut doeh. Bangtelamaw hivah kai kahmawtkung teh kai ni hai ka hmu toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hatdawkvah, tuikhu teh Beerlahairoi telah a phung. Hote teh Kadesh hoi Bered kho rahak vah ao. ");
INSERT INTO cth_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hathnukkhu, Hagar ni Abram hane ca tongpa a khe pouh. Hagar ni a khe e a capa teh Abram ni Ishmael telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar ni Abram hanelah Ishmael a khe pouh navah Abram teh kum 86 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Hathnukkhu, Abram teh kum 99 a pha navah, BAWIPA ni Abram koe a kamnue teh, kai teh Athakasaipounge Cathut doeh ka hmalah toun hane kawi kaawm hoeh lah awm haw. ");
INSERT INTO cth_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kaie lawkkamnae nang hoi ka sak vaiteh moikapap na pungdaw sak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram ni a tabo teh Cathut ni, ");
INSERT INTO cth_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Thai haw kaie lawkkamnae teh nang koe ao. Nang teh miphun moikapap e a na pa lah na o han. ");
INSERT INTO cth_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nange na min hai Abram telah na kaw mahoeh toe. Abraham telah na kaw han toe, bangkongtetpawiteh nang teh miphun moikapap e na pa lah na coung han. ");
INSERT INTO cth_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kai ni moikapap na pungdaw sak han. Nang lahoi miphunnaw ka pung sak vaiteh, nang dawk hoi siangpahrang a tâco han. ");
INSERT INTO cth_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ka lawkkamnae ka caksak vaiteh nang hoi kai rahak, na canaw hoi patuen e na catoun rahak vah a yungyoe e lawkkam lah ao han. Kai teh nang hoi na ca catounnaw e Cathut lah ka o han. ");
INSERT INTO cth_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Atu imyin lah na onae ram, Kanaan ram pueng nang hoi na ca catounnaw koe a yungyoe e râw lah na poe han. Kai teh ahnimae Cathut lah ka o han. ");
INSERT INTO cth_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hathnukkhu, Cathut ni Abraham koevah nang hoi na ca catounnaw pueng ni ka lawkkam heh na tarawi awh han. ");
INSERT INTO cth_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hete teh kai hoi nange na ca catounnaw ni a tarawi hane lawkkam doeh. Tongpa pueng vuensoma pouh han. ");
INSERT INTO cth_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Hatdawkvah, vuensom na a e tak teh kai hoi nang rahak mitnoutnae lawkkam lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Nangmouh dawkvah, na ca catounnaw totouh, ca tongpa pueng. Im dawk ka khe e thoseh, mae miphun nahoeh eiteh, alouke miphunnaw koe tangka hoi ran e hai thoseh, hnin 8 nah vuensom na a pouh han. ");
INSERT INTO cth_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Na im dawk ka khe e hoi tangka hoi ran e tami ni vuensoma roeroe vaiteh ka lawkkam teh tak dawk yungyoe ka cak e lawkkam lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Hatei vuensom ka a hoeh e tongpa a tak dawk e vuengsom ka a hoeh e tami teh ka miphun dawk hoi takhoe lah ao han telah atipouh. Ahni teh kaie lawkkam a raphoe toe. ");
INSERT INTO cth_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Cathut ni Abraham koevah Na yu Sarai hah, Sarai telah na kaw mahoeh, Sarah telah na kaw han toe. ");
INSERT INTO cth_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ahni hah yawhawinae ka poe vaiteh ahni lahoi nang hai ca tongpa na poe han. Yawhawinae ka poe vaiteh miphun moikapap e manu lah ao han. Athung hoi miphunnaw hane siangpahrang a tâco han. ");
INSERT INTO cth_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hat torei teh, Abraham ni a minhmai hoi a tabo teh a panui. Kum 100 touh e ni ca khe han namaw. Kum 90 touh e Sarah ni ca a khe han rah maw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Hatdawkvah, Abraham ni Cathut koe, na hmalah Ishmael mah hring yawkaw seh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hatei Cathut ni telah nahoeh, na yu Sarah ni capa na khe pouh vaiteh, Isak telah a min na phung han. Ka lawkkam ka cak e lawkkam lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ishmael e kong dawk teh kai ni ka thai toe. Ahni yawhawinae ka poe toe. A ca catoun ka pungdaw sak vaiteh moikapap sak han. Ahni teh khobawi 12 touh e a na pa lah ao han. Miphun kalen poung lah ka sak han. ");
INSERT INTO cth_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hateiteh palawng atu e tueng navah, Sarah ni na khe pouh hane Isak dawk ka lawkkam ka caksak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Hottelah Abraham hoi lawk a kâpato hnukkhu Cathut teh a luen. ");
INSERT INTO cth_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hatdawkvah, Abraham ni a capa Ishmael hoi a im dawk ka khe e pueng, tangka hoi a ran e pueng Abraham imthung dawk e tongpa pueng a ceikhai teh Cathut ni ahni koe a dei pouh tangcoung e patetlah hnin touh dawkvah vuensom koung a a pouh. ");
INSERT INTO cth_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Amae vuensom a a nah Abraham teh kum 99 touh a pha toe. ");
INSERT INTO cth_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Capa Ishmael, vuensom a a nah kum 13 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hnin touh dawk, Abraham hoi a capa Ishmael teh vuensom rei rei a a roi. ");
INSERT INTO cth_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Amae im dawk kaawm e tongpa pueng a im dawk ka khe e, miphun alouke koe tangka hoi a ran e tongpa pueng teh, ama hoi cungtalah vuensom a a awh. ");
INSERT INTO cth_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abraham teh kanîthun khumbei a thoe lahun nah, rim takhang koe a tahung navah BAWIPA teh Mamre kathenkungnaw koehoi ahni koe a kamnue . ");
INSERT INTO cth_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","A khet teh a hmalah tami kathum touh a kangdue e a hmu navah, rim takhang koehoi ahnimanaw kâhmo hanelah a yawng teh talai dawk a tabo. ");
INSERT INTO cth_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Hahoi, ka bawipa na hmalah minhmai kahawi ka hmawt pawiteh na san heh na cettakhai hanh. ");
INSERT INTO cth_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Tui youn touh ka sin vaiteh na khok pâsu awh nateh, thingkung rahim kâhat awh ei. ");
INSERT INTO cth_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na tha tawn e roum nahanelah vaiyei youn touh ka sin hnukkhu, na cettakhai awh. Hottelah e coe hanelah na san onae koe na pha toe telah atipouh. Ahnimanaw ni hai na dei patetlah sak lawih atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham teh rim thung kaawm e Sarah koe karanglah a yawng teh tavai sum thum touh hane coungkacoe lat nateh karanglah kanawk nateh thawng leih atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Hahoi Abraham ni maitohu koe a yawng teh, maitoca a tak kathâw e a la teh, a san thoundoun koe a poe teh karanglah a rakueng sak. ");
INSERT INTO cth_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Hathnukkhu, sanutui hoi maitoca moi ahnimae hmalah a pâtoum pouh teh a ca awh. Ahnimanaw ni a ca awh lahun nah, ama teh thingkung rahim a kangdue. ");
INSERT INTO cth_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ahnimanaw ni na maw Sarah ao telah a pacei navah rim thung ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Hahoi ahnimanaw ni palawng het tuektue nah nang koe bout ka tho vaiteh na yu Sarah ni ca tongpa a khe han atipouh. Hatnavah Sarah teh ahnimae a hnukkhu lae rim takhang koe ao teh a thai. ");
INSERT INTO cth_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham hoi Sarah teh a matawng ni teh a kumcue roi poung toe. Sarah teh camo o thainae a pout toe. ");
INSERT INTO cth_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hatdawkvah, Sarah ni lunghawinae kai ni ka tawn han rah maw ati teh duem a panui. Ka bawipa hai a matawng poung toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","BAWIPA ni Abraham koevah, bangkongmaw Sarah ni ka matawng toung dawkvah camo ka khe thai han rah maw ti teh a panui vaw. ");
INSERT INTO cth_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","BAWIPA hanelah hno ka ru ao maw. A tueng khoe e patetlah palawng vah Sarah camo a khe han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Hatei Sarah ni ka panui hoeh titeh a kâpapha. Bangkongtetpawiteh, a lungpuen dawk doeh. Ahni ni nahoeh na panui atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hahoi, taminaw hote hmuen koehoi a thaw awh teh Sodom kho a radoung awh. Abraham hai ahnimanaw a thak hanelah a kâbang van. ");
INSERT INTO cth_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Hatei BAWIPA ni ka sak hane hno Abraham koe ka pâpha pouh han maw. ");
INSERT INTO cth_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham teh tami kalen hoi Athakasaipounge miphun lah a coung han. Talaivan e tami pueng ni ahni lahoi yawhawi a coe awh han. ");
INSERT INTO cth_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Bangkongtetpawiteh ahni ni hmalah ka tho hane a canaw hoi imthungnaw ni BAWIPA e lamthung a dawn awh vaiteh, lannae hoi hnokahawi sak hanelah, ka dei tangcoung e patetlah BAWIPA ni Abraham koe kakuep sak hanelah ahni teh ka panue e doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Hahoi BAWIPA ni Sodom hoi Gomorrah kho dawk e hramnae lawk hoi a yonnae teh puenghoi a len toung dawkvah, ");
INSERT INTO cth_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Atu ka cei vaiteh kai koe ka phat e a hram awh patetlah ahnimanaw ni a sak katang maw. Sak katang hoeh maw tie atu ka khet han. Sak hoehpawiteh a sak hoeh e ka panue han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hote taminaw teh hote hmuen koehoi a kamlang awh teh Sodom kho lah a cei awh. Abraham ma teh BAWIPA hmalah paroup a kangdue. ");
INSERT INTO cth_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Hahoi Abraham ni a hnai teh, tamikalannaw hai tamikathoutnaw hoi mek na raphoe han maw. ");
INSERT INTO cth_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Hote kho dawk tamikalan 50 touh awm pawiteh, a thung e tamikalan 50 touh ao kecu dawk hote hmuen teh na raphoe han maw. ");
INSERT INTO cth_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tamikalannaw hah tamikathoutnaw patetlah khang sak hane teh nang hoi kâhlat naseh. Talaivan pueng lawkcengkung ni kalan lah lawkceng mahoeh maw. ");
INSERT INTO cth_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hottelah BAWIPA ni Sodom kho thung vah, tamikalan 50 touh ka hmawt pawiteh, ahnimouh kecu dawk hote hmuen pueng teh ka pasai han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham ni kai teh vaiphu hoi hraba lah ka o ei, BAWIPA nang koe lawk na pacei hanelah tha bout ka kâla. ");
INSERT INTO cth_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Tamikalan 50 touh dawk panga touh kuep hoehpawiteh, hote panga touh akuep hoeh dawk, hote khopui teh na raphoe han maw, telah a pacei. Ahni ni hawvah 45 touh ka hmu nakunghai ka raphoe mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hahoi 40 touh ka hmu yawkaw han doeh bout atipouh navah, 40 touh hai ka raphoe mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hahoi Oe BAWIPA na lungphuen hanh, bout na pacei ei nei, 30 touh ka hmu yawkaw han doeh bout atipouh navah, 30 touh hane dawk hai ka raphoe mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ahni ni thai haw, BAWIPA koe lawk bout ka pacei ei nei, hawvah 20 touh ka hmu yawkaw han doeh bout atipouh navah, 20 touh hane dawk hai ka raphoe mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Hahoi, Oe BAWIPA na lungkhuek hanh yawkaw, vai touh bout na pacei einei, hawvah 10 touh ka hmawt pawiteh atipouh navah, 10 touh hane dawk hai ka raphoe mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","BAWIPA teh Abraham hoi lawk koung a kâpato roi hnukkhu a ceitakhai. Abraham haiyah a ma onae koe a ban. ");
INSERT INTO cth_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kalvantami kahni touh tangmin lah Sodom kho a tho roi. Lot teh khopui thung kâennae longkha koe a tahung teh, Lot ni ahnimouh roi a hmu navah dawn hanelah a thaw teh, talai dawk a tabo. ");
INSERT INTO cth_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ahni ni ka bawipa roi, pahren lahoi na sanpa im kâen roi nateh roe rawi ei. Na khok hai pâsu roi ei telah atipouh. Ahnimouh roi ni telah nahoeh, alawilah ka roe roi han doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hatei, puenghoi a pasawt dawkvah, ahni koe a cei roi teh, im thung a kâen roi. Hahoi, tonphuenhoehe vaiyei a poe teh a ca roi. ");
INSERT INTO cth_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ahnimanaw a i awh hoehnahlan vah, Sodom kho e tongpa camo matawng abuemlah a tho awh teh, im khik a kalup awh. ");
INSERT INTO cth_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Lot a kaw awh teh, tapa tangmin lah na im ka tho e tami roi namaw ao. Hote tami roi ikhai hanelah ka ngai awh, alawilah tâcawt sak telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot teh takhang koehoi alawilah ahnimouh koe a tâco teh, tho a khan hnukkhu, ");
INSERT INTO cth_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ka hmaunawnghanaw pahren lahoi thoenae sak awh hanh. ");
INSERT INTO cth_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Khenhaw! tongpa ka panuek hoeh rae ka canu kahni touh ka tawn. Na ngai patetlah na ti thai awh. Hatdawkvah, pahren lahoi ahnimouh roi nangmouh koe ka tâco sak han. Imyin roi koe teh banghai sak awh hanh. ");
INSERT INTO cth_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ahnimanaw ni, kâhnawnh telah atipouh awh. Hahoi nang teh imyin lah na o eiteh, lawkcengkung lah o hanelah na kâcai. Hatdawkvah, ahnimanaw koe ka sak awh e hlak nang koe hoe kathout lah ka sak awh han telah atipouh awh. Hahoi Lot hah rek a savek awh teh, tho hai peng raphoe hanelah a tho awh. ");
INSERT INTO cth_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Hatei, ahnimouh roi ni a kut hoi imthung lah Lot hah a sawn roi teh, tho khik a khan sin roi. ");
INSERT INTO cth_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tho teng kaawm e tami kathoeng kalen abuemlahoi a mit a dawn sak teh, tho hmawt thai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ahnimouh roi ni Lot koevah, hivah nang hoi na kâkuen e tami ao rah maw. Na langa, capanaw, canunaw, hoehpawiteh, khothung kaawm e tâcawtkhai leih. ");
INSERT INTO cth_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Bangkongtetpawiteh, BAWIPA hmalah a hramki awh teh, a tarannae a len poung toe. Hatdawkvah, hie hmuen raphoe hanelah BAWIPA ni na patoun roi e doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot a tâco teh, a canu ka lat e a cavanaw koevah, thaw awh leih. Hete hmuen heh tâcawt takhai awh leih. Bangkongtetpawiteh, BAWIPA ni khopui a raphoe han toe atipouh. Hatei, a cavanaw ni panuilai lah a pouk awh. ");
INSERT INTO cth_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Amom kho vumpava a dai navah, kalvantami roi ni, thaw leih, na yu hoi na canu roi tâcawtkhai leih, nahoeh pawiteh, hete kho reknae na khang payon vaih telah ngangngang a cangawt. ");
INSERT INTO cth_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Hatei, a hnanthoe dawkvah, kalvantami roi ni, ama hoi a yu, a canu roi hoi a kut dawk hoi a sawn teh, khopui alawilah a tâcokhai. Bangkongtetpawiteh, BAWIPA ni a pahren dawk doeh. ");
INSERT INTO cth_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Alawilah, a tâcokhai awh hnukkhu, na hringnae a hlout thai nahanlah yawng leih. Hnuklah kamlang laihoi khen hanh. Tanghling koe khoeroe awm hanh. Mon vah yawng leih. Nahoeh pawiteh na due han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot ni ahnimouh roi koe, telah nahoeh, ka bawipa roi. ");
INSERT INTO cth_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Na sanpa ni na mithmu vah minhmai kahawi ka hmu toe. Ka hringnae na hlout sak teh, kai dawk lungpatawnae kalen poung na kamnue sak toe. Hatei, mon lah teh ka yawng thai mahoeh. Telah nahoeh pawiteh, runae ni na kei vaiteh, kadout han doeh. ");
INSERT INTO cth_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Khenhaw! hote kho teh yawng nahane a hnaica. Kho kathoungcalah hai ao. Hote kho kathoengca koe na yawng sak haw. Ka hring han doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ahnimouh roi ni na kâhei e patetlah lung na kuep khai toe. Na dei e kho teh ka raphoe mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Karanglah hawvah yawng leih. Hote kho dawk na pha hoehnahlan bang hno hai ka sak thai mahoeh atipouh. Hatdawkvah, hote kho teh Zoar telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Zoar kho dawk Lot a kâen navah talai van kanî teh a tâconae toe. ");
INSERT INTO cth_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Hahoi BAWIPA ni BAWIPA ma koehoi e ganhmai Sodom hoi Gomorrah kho dawk kho lah a rak sak. ");
INSERT INTO cth_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Hote khopui roi hoi thingyei yawn pueng, khopui karingkungnaw abuemlah talai hoi ka paw e thingkung pueng koung a raphoe. ");
INSERT INTO cth_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Hatei, a yu teh hnuklah a kangvawi dawkvah, palawi khom lah a kangcoung. ");
INSERT INTO cth_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham teh BAWIPA hmalah a kangduenae hmuen koe amom vah a cei. ");
INSERT INTO cth_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom hoi Gomorrah thingyei yawn pueng a khet navah, takhuen koe e hmaikhu patetlah ram pueng dawk e hmaikhu kahlun lah a luen e hah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Hottelah Cathut ni thingyei yawn dawk e khopuinaw a raphoe lahunnah hoi Lot onae khopuinaw a raphoe nah Cathut ni Abraham a pahnim hoeh dawkvah, Lot teh rawknae koehoi a hlout sak. ");
INSERT INTO cth_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Hottelah Lot teh, Zoar kho hoi a luen teh mon dawk kho a sak. A canu kahni touh hai ama koe ao. Bangkongtetpawiteh, Zoar kho dawk o hane ngam hoeh. Hahoi a canu kahni touh hoi lungngoum thung ao awh. ");
INSERT INTO cth_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","A canu kacue e ni a nawngha koe, apa a matawng toe, talai van e phung patetlah maimouh roi na ka ipkhai hane tongpa awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Thohaw, apa misurtui pânei roi sei. Apa e miphun apout hoeh nahanlah ipkhai roi sei, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hote tangmin vah, misurtui a na pa a pânei roi teh, a na pa ni a ikhai e hoi bout a thaw e hah panuek hoeh. ");
INSERT INTO cth_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Atangtho amom teh, kacue e ni paduem tangmin apa hoi kai ka i roi toe. Atu tangmin vah misurtui bout pânei sei. Apa e miphun a pout hoeh nahanelah, nang louk ipkhai loe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hote tangmin haiyah a na pa misurtui a pânei roi hnukkhu, kanaw e ni a na pa a ikhai teh, a i e hoi bout a thaw e a na pa ni panuek hoeh. ");
INSERT INTO cth_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hottelah Lot e canu roi teh camo a vawn roi. ");
INSERT INTO cth_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kacue e ni tongpa a khe teh, Moab telah a min a phung. Hote tami teh atu kaawm e Moab miphunnaw e a na pa lah ao. ");
INSERT INTO cth_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kanaw e ni hai tongpa a khe teh, Benammi telah min a phung. Hote tami teh sahnin totouh kaawm e Ammon miphunnaw e a na pa doeh. ");
INSERT INTO cth_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham teh hote hmuen koehoi akalah a cei teh, Kadesh kho hoi Shur kho rahak vah kho a sak teh Gerar kho dawk a roe. ");
INSERT INTO cth_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham ni a yu Sarah hanelah ka tawncanu atipouh. Hahoi Gerar Siangpahrang Abimelek ni tami a patoun teh Sarah a la sak. ");
INSERT INTO cth_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hatei, Cathut ni tangmin vah Abimelek koe a mang lahoi a tho teh, thai haw, na lae napui kecu dawk tami kadout patetlah doeh na o toe, bangkongtetpawiteh ahni teh ayâ yu doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Hatei, Abimelek ni ipkhai hoeh rah. Hahoi ahni ni kalan e miphun hai na thei han maw ");
INSERT INTO cth_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ama ni roeroe kai koevah, ka tawncanu ati nahoehmaw. A yu ni hai ka thangroi doeh ati tayaw, lungthin thoung lahoi, ka kut kathoungcalah hoi hete hno ka sak e doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Cathut ni a mang lah vah, ahman doeh, lungthin kathoungcalah hoi hete hno na sak e doeh tie ka panue. Hatdawkvah kai ni hai kai tak dawk hnokathout sak hane ka pasoung hoeh. Hat dawk doeh ahni na tek hanelah ka pasoung hoeh. ");
INSERT INTO cth_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Hatdawkvah ayâ yu atu bout poe leih, bangkongtetpawiteh ahni teh profet doeh. Na ratoum pouh vaiteh na dam han. Hatei na poe hoehpawiteh, nang hoi na sannaw abuemlah, na due roeroe awh han atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Hahoi Abimelek teh amom, a thaw, a sannaw pueng a kaw teh a thai e hnonaw pueng a dei pouh teh puenghoi a taki awh. ");
INSERT INTO cth_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek ni Abraham a kaw teh, kai dawk bang hno maw na sak, nang koe bangmaw ka payon teh, kai hoi kaie uknaeram koe kahawihoehe hno na pha sak. Sak hoeh hane kawi kai dawk na sak vaw atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimelek ni Abraham koevah, Bang hno maw na hmu teh kai dawk hete hno na sak telah bout atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham ni hie kho dawk e taminaw teh Cathut ka taket awmhoeh vaiteh, ka yu kecu dawk kai na thei awh han doeh telah ka pouk dawk doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Hothloilah ahni teh ka tawncanu katang doeh. Apa e canu doeh. Anu e canu nahoeh, hatei ka yu lahai ao. ");
INSERT INTO cth_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Cathut ni apa im hoi na ceisak hane navah, na pha nah tangkuem koe ka thangroi doeh na ti pouh han telah ati dawk doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelek ni tu hoi maitotannaw, sanpa hoi sannu naw a ceikhai teh Abraham a poe teh, a yu Sarah hai bout a poe. ");
INSERT INTO cth_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelek ni, Khenhaw! ka ram teh na hmalah ao, na ngainae pueng koe awm loe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Sarah koevah, na thangroi koe tangka 1,000 touh ka poe toe. Nang hoi na huikonaw pueng hanelah minhmai sak lah ka poe e doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Hottelah Abraham ni Cathut koe a ratoum teh, Cathut ni Abimelek hoi a yu, a sannunaw a dam sak teh canaw hai bout a khe. ");
INSERT INTO cth_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Abraham e a yu Sarah kecu dawk BAWIPA ni Abimelek imthung abuemlah carôe sak. ");
INSERT INTO cth_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","BAWIPA ni a dei tangcoung e patetlah Sarah koe a pai teh a lawkkam pouh e patetlah Sarah hanelah a sak pouh. ");
INSERT INTO cth_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Hahoi, ahni koe a dei pouh tangcoung e patetlah Cathut ni a khoe pouh e tueng navah Sarah ni camo a vawn teh, a matawng hnukkhu Abraham hanelah tongpa a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham ni hai a tawn e capa, Sarah ni a khe pouh e hah Isak telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Hottelah, Cathut ni kâ a poe tangcoung e patetlah Abraham ni a capa Isak hah ataroe hnin navah vuensom a a pouh. ");
INSERT INTO cth_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham teh a capa Isak a khe navah kum 100 touh a pha toe. ");
INSERT INTO cth_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah ni hai kai ka panuithainae Cathut ni na poe toe. Hete kamthang ka thai e pueng ni hai kai hoi cungtalah a panui van awh han doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Sarah ni camo sanu a pânei han telah Abraham koe apinimaw ouk a dei pouh. A matawng torei kai ni ca tongpa ka khe pouh toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Hottelah, camo a roung takhang teh sanu a pâphei. Sanu a pâphei nah hnin dawk Abraham ni buven pawi kalenpounge a sak. ");
INSERT INTO cth_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Izip tami Hagar capa, Abraham hanelah a khe pouh e ni a panuikhai e hah Sarah ni a hmu. ");
INSERT INTO cth_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Hatdawkvah, Abraham koevah, Hete sannu hoi a capa pâlei leih, bangkongtetpawiteh sannu e capa ni ka capa e râw coe thai mahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","A capa lah ao kecu dawk Abraham hanelah hno ka ru poung lah ao. ");
INSERT INTO cth_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Hatei Cathut ni Abraham koe, camo hoi na sannu kong dawk hno ka ru lah pouk hanh. Sarah ni a dei e pueng tarawi loe. Bangkongtetpawiteh Isak dawk hoi na catoun telah kaw e lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Na sannu e capa dawk hai miphun ka pungdaw sak han. Bangkongtetpawiteh ahni hai na ca doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Hottelah amom vah Abraham a thaw teh vaiyei hoi tuium a la teh Hagar e aloung dawk a patue pouh hnukkhu, camo hoi a ceisak. A cei roi teh Beersheba kahrawngum vah yuengyoe a kâva roi. ");
INSERT INTO cth_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tuium dawk e tui a baw hnukkhu camo hah buruk rahim a hruek. ");
INSERT INTO cth_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Pala vai touh ka sittouh bang hane a cei teh, hnuklah a kangvawi laihoi a tahung hnukkhu, camo due e na hmawt sak hanh loe telah ati. Hottelah hnuklah a kangvawi laihoi a tahung teh puenghoi kacaipounglah a ka. ");
INSERT INTO cth_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Camo lawk Cathut ni a thai teh Cathut kalvantami ni kalvan lahoi Hagar a kaw teh, Hagar bangmaw runae na kâhmo. Taket hanh, camo e lawk Cathut ni a thai toe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Thaw nateh camo hah na kut hoi pathaw leih, bangkongtetpawiteh miphun kalen poung lah kacoungsak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Cathut ni a mit ang sak teh tuikhu buet touh a hmu. A cei teh tuium dawk yikkawi a do hnukkhu camo a pânei. ");
INSERT INTO cth_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Cathut teh camo koe lah a o, ahni teh a roung takhang teh, kahrawngum vah kho a sak teh moikathaipounge lah ao. ");
INSERT INTO cth_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Paran kahrawngum vah kho a sak teh a manu ni a yu lah Izip tami a la pouh. ");
INSERT INTO cth_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hatnae tueng dawk Abimelek hoi ransahu kaukkung Phikhol ni Abraham koevah, na sak e hno pueng dawk Cathut ni na okhai. ");
INSERT INTO cth_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Hatdawkvah Cathut minhmai khet lahoi kai hoi ka capa catoun totouh dumyennae awm laipalah na pahren e patetlah kai hoi na onae ram heh a hawinae ka hmu nahanelah lawk na kam pouh leih telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ni hai, lawkkam han atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abimelek e a sannaw ni tuikhu a lawp dawkvah Abraham ni Abimelek a yue. ");
INSERT INTO cth_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelek ni, hot patet hno ka sak e teh apimaw. Ka panuek hoeh, nang ni hai na dei hoeh. Kai ni hai sahnin totouh ka panuek hoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Hottelah, Abraham ni tu hoi maitotan a hrawi teh Abimelek a poe, hahoi kahni touh hoi lawkkamnae a sak roi. ");
INSERT INTO cth_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham ni tuhu dawk e tulaca sari touh alouklah a kapek. ");
INSERT INTO cth_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelek ni Abraham koevah tulaca sari touh na ka pek e, bang hane maw atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ahni ni hete tuikhu ka tai e heh kapanuekkhaikung lah tulaca sari touh e ka kut dawk e na la roeroe han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hote hmuen koe kahni touh hoi lawkkamnae a sak roi dawkvah Beersheba telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Hottelah Beersheba vah lawkkamnae a sak roi hnukkhu Abimelek hoi ransabawi Phikhol tinaw a thaw awh teh Filistin ram lah a ban awh. ");
INSERT INTO cth_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham ni Beersheba vah hmaicakung a ung teh haw vah BAWIPA yungyoe Cathut e min a kaw. ");
INSERT INTO cth_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hahoi, Abimelek teh Filistin ram dawk hnin moi kasawlah a cam. ");
INSERT INTO cth_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Hathnukkhu hoi Cathut ni Abraham a tanouk teh Abraham telah a kaw. Ahni ni hi ka o telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ahni ni, na capa, na capa tawn dueng, na lungpataw poung e, Isak roeroe hah cetkhai nateh, Moriah ram lah cet, kai ni na patue e mon dawk thuengnae na sak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham ni, amom a thaw teh, la dawk hnopainaw aphu sak hnukkhu a capa Isak hoi thoundoun kahni touh a kaw. Hmaisawi thueng nahane thing a racei hnukkhu, Cathut ni a dei e hmuen koe lah a cei. ");
INSERT INTO cth_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Apâthum hnin nah a radoung teh ahlanae koehoi a hmu. ");
INSERT INTO cth_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham ni thoundoun roi koe, hivah la hoi la awm roi. Kai hoi camo teh hote hmuen koe ka cei roi vaiteh bawknae ka sak roi han. Ka cum roi hnukkhu nangmouh roi koe bout ka ban roi han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Hahoi Abraham ni hmaisawi thueng nahane thing hah a capa Isak a hrawm sak teh, ama ni hmaibo hoi sarai hah a sin teh, cungtalah a cei roi. ");
INSERT INTO cth_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Hatei, Isak ni a na pa Abraham a pato teh, Apa atipouh navah, A na pa ni ka ca kai hi ka o atipouh. Ahni ni khenhaw! hmai hoi thing teh ao toe, hatei, hmaisawi thueng nahane tuca teh na maw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham ni, ka capa Cathut ni ama hanelah hmaisawi thueng nahane tuca teh a rakueng han doeh atipouh. Hathnukkhu ahnimouh roi teh cungtalah a cei roi. ");
INSERT INTO cth_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Cathut ni a dei pouh e hmuen koe a pha roi. Abraham ni hote hmuen koe khoungroe a sak teh, thingnaw hah kahawicalah a hruek, a capa Isak hah a katek hnukkhu, khoungroe dawk e thing van a payan. ");
INSERT INTO cth_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Hahoi, Abraham ni a capa thei hanelah a kut a pho teh sarai hah a la. ");
INSERT INTO cth_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hatei BAWIPA kalvantami ni Abraham Abraham telah kalvan hoi a kaw. Ahni ni hai kai hi ka o atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ahni ni camo e tak dawk na kut tha hanh. Bangkongtetpawiteh, Cathut na taki e atu ka panue toe. Na capa, na tawn dueng e ka hei teh nang ni na kangek hoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hahoi Abraham ni a moung teh a khet navah, amae a hnuklah tutan buruk dawk a ki ka mang e hah a hmu. Abraham ni a cei teh hote tu hah a la hnukkhu, hmaisawi thuengnae a sak. ");
INSERT INTO cth_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hatdawkvah, Abraham ni hote hmuen teh, BAWIPA ni kho a khan han (Jehovah-Jireh) telah min a poe. BAWIPA e mon dawk BAWIPA ni na rakueng pouh telah atu totouh ati awh. ");
INSERT INTO cth_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hahoi, BAWIPA e kalvantami ni apâhni lah kalvan hoi Abraham bout a kaw teh, ");
INSERT INTO cth_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","hete hno na sak teh, na capa, na tawn dueng e na pasai hoeh dawkvah, yawhawi na poe roeroe han. ");
INSERT INTO cth_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kalvan e âsi hoi tui teng e sadi yit touh. Na catounnaw ka pungdaw sak roeroe han. Na catounnaw ni na tarannaw e longkha a coe awh han. ");
INSERT INTO cth_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Hahoi, ka lawk na ngâi kecu dawk talai van e tami pueng ni nange catounnaw lahoi yawhawinae a coe awh han. ");
INSERT INTO cth_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hathnukkhu thoundoun roi aonae koe lah Abraham, bout a ban teh, ahnimanaw hoi cungtalah a kamthaw awh teh, Beersheba lah a cei awh. Abraham teh Beersheba vah kho tawngtang a sak. ");
INSERT INTO cth_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Hathnukkhu, Abraham ni a thai e teh, nange na nawngha Nahor e a yu Milkah ni ca tongpanaw a khe toe. ");
INSERT INTO cth_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","A camin lah Uz, a nawngha Buz hoi Aram na pa Kemuel, ");
INSERT INTO cth_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Khesed, Hazo, Pildash, Jidlap hoi Bethuel. ");
INSERT INTO cth_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel ni Rebekah a khe. Hete taroe touh e naw teh Milkah ni Abraham e a nawngha Nahor hanelah, a khe pouh e naw doeh. ");
INSERT INTO cth_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hathnukkhu Nahor e ado Reumah ni hai Tebah, Gaham, Tahash hoi Maakah bout a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah teh kum 127 touh a hring. Sarah e a hringnae kum teh ama het doeh toe. ");
INSERT INTO cth_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah teh Kanaan ram Hebron tie Kiriatharba kho dawk a due. Abraham hai Sarah kecu dawk khuika hanelah a tho. ");
INSERT INTO cth_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Hahoi Abraham teh a yu e ro hmalah a kangdue teh Hit taminaw koe, ");
INSERT INTO cth_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Kai teh nangmouh koe imyin hoi kahlong tami lah doeh ka o. Ka yu e ro ka pakawp nahanelah nangmouh koe e talai lem na poe awh haw atipouh. ");
INSERT INTO cth_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hit taminaw ni Abraham koe a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ka bawipa kaimae lawk thai haw, nang teh kaimouh rahak vah Cathut e khobawi doeh. Hatdawkvah na ngai e hmuen rawi nateh pakawp ngoun. Na tami ro pakawp nahanelah apinihai phuen hmuen pasoung hoeh laipalah awm mahoeh, telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Hathnukkhu, Abraham teh a thaw teh, Hit taminaw hoi hote ram dawk e taminaw hmalah a tabo. ");
INSERT INTO cth_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Hahoi, ahnimouh koe, ka tami ro pakawp nahanelah, na lungkuep awh pawiteh ka lawk thai awh haw. ");
INSERT INTO cth_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Nangmouh koe, phuen hmuen ka tawn thai nahanelah, Zohar capa Ephron ni, amae law apout koe lah kaawm e Makpelah talungkhu hah, aphu hoi kâki lah kai koe a yo thai nahane, ahni koe na het pouh haw loe, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Hat torei teh Hit taminaw koe Ephron teh a tahung. Hit tami Ephron ni khopui longkha dawk hoi ka kâen e Hit taminaw pueng ni a thainae koe, ");
INSERT INTO cth_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Telah nahoeh, ka bawipa law na poe awh, law thung kaawm e talungkhu hai na poe awh. Ka miphunnaw hmaitung roeroe na poe awh, na tami ro teh pakawp leih telah Abraham koe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham teh, hote ram dawk e taminaw hmalah a tabo teh, ");
INSERT INTO cth_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ram dawk e taminaw ni a thainae koe Ephron hanelah na lungkuep pawiteh thai haw, law hmuen phu teh na poe han. Aphu dâw leih, hote hmuen koe ka tami ro teh ka pakawp han atipouh. ");
INSERT INTO cth_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ephron ni Abraham koe, ");
INSERT INTO cth_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ka bawipa, ka lawk thai haw, ka law hmuen phu tangka (shekel) cumpali touh doeh. Nang hoi kai hanlah banghai bang nahoeh. Na tami ro teh pakawp yaw kaw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham ni a lungkuepkhai teh, Hit taminaw ni a thainae koe tangka shekel cumpali touh hno kayawtnaw ni a khing e patetlah a khing teh a poe. ");
INSERT INTO cth_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Hatdawkvah Mamre kho hoi kanîtholah, Makpelah hmuen koe kaawm e Ephron e law, law thung kaawm e talungkhu hoi thingkungnaw, lawri koe kaawm e thingkung pueng, ");
INSERT INTO cth_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Hit taminaw hoi khopui longkha koe ka tho e tami pueng e hmaitung vah Abraham ni coe hanelah a poe. ");
INSERT INTO cth_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Hathnukkhu, Abraham ni Mamre kho, Hebron hoi kanîtholah, Makpelah law dawk e talungkhu dawk a yu Sarah teh a pakawp. ");
INSERT INTO cth_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hatdawkvah lawhmuen hoi talungkhu teh, Abraham ni phuen hmuen lah, a tawn hanelah, Hit taminaw ni a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham teh a kumcue teh a matawng poung toe. BAWIPA ni Abraham teh hno pueng dawk yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham ni a san, a imthungkhu thung dawk kacue poung lah a tawn e naw pueng lathueng vah kâ ka tawn poung e koevah, pahren lahoi na kut hah ka phai rahak vah tat haw, ");
INSERT INTO cth_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kai teh ahnimouh rahak kho ka sak ei, Kanaan tanglanaw heh ka capa hane a yu lah lat hanh. ");
INSERT INTO cth_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hateiteh, ka miphunnaw koe, ka hmaunawnghanaw e im dawk cet nateh ka capa Isak hanelah a yu na paluen pouh han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A san ni ahni koe, Napui ni hete ram dawk tho ngai hoehpawiteh, na capa heh na thonae ram dawkvah ka ceikhai han na maw, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham ni ahni koe, ka capa heh haw ceikhai hoeh nahanlah kâhruetcuet. ");
INSERT INTO cth_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hete ram heh na ca catounnaw ka poe han telah kai koe lawk ka kam, kalvan e BAWIPA Cathut ni apa im hoi ka tâconae ram dawk hoi na kalatkung ni na hmalah kalvantami a patoun vaiteh hote hmuen dawk e ka capa hanlah a yu na paluen pouh han. ");
INSERT INTO cth_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Hote napui ni kâbang ngai hoehpawiteh, kai koevah thoebonae dawk hoi nang teh na hlout han. Ka capa teh haw na cetkhai mahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hottelah a san ni a bawipa e a tangka vah a kut a ta teh, hote kong dawk thoe a kâbo. ");
INSERT INTO cth_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","A san ni a bawipa e kalauk thung dawk hoi hra touh a hrawi teh, a bawipa e hnokahawi phunkuep hah a sin teh a kamthaw. Hottelah a kamthaw teh Mesopotamia ram e Nahor kho lah a cei. ");
INSERT INTO cth_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tangmin lah napuinaw tui do hanlah thonae tueng dawkvah, longkha teng e tuikhu koe a kalauknaw a kamkawn sak. ");
INSERT INTO cth_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ahni ni, Oe BAWIPA Cathut, pahren lahoi sahnin vah, ka bawipa, Abraham koevah na lungmanae kamnuek sak nateh na kuep sak haw. ");
INSERT INTO cth_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Khenhaw! tuikhu koevah ka kangdue. Khothung e a canunaw hai tui do hanlah a tho awh toe. ");
INSERT INTO cth_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Hettelah awm naseh, tangla koe pahren lahoi tui ka nei hanlah tuium hah patue sak haw, ka ti navah, ahni ni net leih, na kalauknaw a nei hanlah ka poe han telah ka tet e teh na san Isak hanlah na hmoun pouh e lah awm naseh. Hottelahoi ka bawipa koe lungmanae na kamnue sak tie hah ka panue thai han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Hahoi, lawk koung a dei hoehnahlan vah, Abraham e a nawngha Nahor e a yu Milkah capa Bethuel canu Rebekah teh a loung dawk tuium thueng hoi a tho. ");
INSERT INTO cth_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Tangla teh a meihawipoung. Thoundoun ni a ikhai hoeh rae tanglakacuem lah ao. Tuikhu koe a cathuk teh tuium tui yikkawi a do hnukkhu, a takhang. ");
INSERT INTO cth_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Sanpa ni ahni kâhmo hanlah a yawng teh, pahren lahoi na tuium dawk e tui youn touh na pânei haw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Napui ni net leih ka bawipa telah atipouh. Karang poung lah a tuium teh a loung dawk hoi a patue teh tui a pânei. ");
INSERT INTO cth_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tui a pânei hnukkhu, na kalauknaw hanlah hai tui a boum awh hoehroukrak boutbout ka do han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Karang poung lah tui teh dokko dawk a hlun teh tui bout do hanlah tuikhu koe lah a cathuk teh kalauknaw pueng hanelah tui a do pouh. ");
INSERT INTO cth_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tongpa ni lawkkamuem hoi a khet teh, BAWIPA ni kahlawng ka ceinae a lam a kâko sak vaiteh akuep sak hoi kakuep sak hoeh hane panue hane a ngai dawk lawkkamuem lah ao. ");
INSERT INTO cth_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kalauknaw ni tui koung a nei awh hnukkhu vah, hnongpacap hoi sui kuthrawt sekel hra touh ka ri e hah a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ahni koevah, nang apie canu maw. Pahren lahoi na dei pouh haw. na Pa im dawk ka roe nahanlah rakhan ao han na ou, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Napui ni ahni koevah, Milkah ni Nahor hanlah a khe pouh e Bethuel canu doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Napui ni hothloilah, caphon hoi saring e rawca moi ka tawn awh. Roenae rakhan haiyah ka tawn awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hat toteh, a san ni a lûsaling teh BAWIPA hah a bawk. ");
INSERT INTO cth_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ahni ni, ka bawipa lathueng vah a lungmanae hoi hawinae ka pout thai hoeh e, ka bawipa Abraham e BAWIPA Cathut teh pholen lah awm naseh. Kai patenghai BAWIPA ni ka bawipa e a hmaunawnghanaw e im dawk na ceikhai tangngak telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tangla ni a yawng teh hno kaawmnaw hah a manu imthungkhu hah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah ni a thangroi a tawn. Ahnie min teh Laban doeh. Laban a tâco teh tuikhu koelah hote tongpa koevah a yawng. ");
INSERT INTO cth_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Hahoi, hnongpacap hoi a tawncanu e a kut dawk e a buet e a hmu nah, tongpa ni hottelah na dei pouh telah a tawncanu ni a dei e a thai toteh, tongpa koevah a cei. Ahni teh tuikhu koe e kalauknaw rahak vah kangdout e hah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban ni, BAWIPA ni yawhawi a poe e tho nateh, kaie im dawk luenh. Bangkongmaw alawilah na kangdue Bangkongtetpawiteh, im hoi kalauknaw hanlah hmuen teh koung ka rakueng toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tongpa ni imthung a kâen teh Laban ni kalauk van e hnonaw a patue pouh. Hahoi, kalauk hanlah caphon hoi rawca hah a poe teh, ama hoi a huinaw hanelah khok pâsu nahanlah tui a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ca hane rawca a hmalah a pâtoum pouh. Hateiteh, ahni ni, ka tho ngainae ka dei hoehroukrak ka cat mahoeh telah atipouh. Ahnimouh ni dei yawkaw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ahni ni kai teh Abraham e a san doeh. ");
INSERT INTO cth_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","BAWIPA ni ka bawipa teh yawhawi a poe dawk moi a tawnta. BAWIPA ni ahni koevah tunaw, maitonaw, tangka hoi sui, san napui tongpa, kalauknaw, lanaw hah a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ka bawipa e a yu Sarah ni a matawng hnukkhu, capa buet touh a khe pouh teh a tawn e naw pueng teh ahni koevah a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hahoi, ka bawipa ni ka onae Kanaan tanglanaw hah ka capa hanelah a yu lah na paluen pouh mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ka im vah, ka hmaunawnghanaw koe cet nateh ka capa hanelah a yu paluen pouh telah lawk na kam sak. ");
INSERT INTO cth_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Ka bawipa koe napui ni kâbang ngai laipalah ao thai telah ka ti pouh. ");
INSERT INTO cth_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ahni ni kai koevah, a hmalah ouk ka onae BAWIPA ni a kalvantami nang koevah a patoun vaiteh, na ceinae koe a lamcawn sak han. Hottelah ka hmaunawnghanaw hoi apa imthungkhunaw koehoi ka capa hanlah a yu na paluen pouh. ");
INSERT INTO cth_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ka hmaunawnghanaw koe na pha nah napui na poe ngai hoeh boipawiteh, hete lawkkamnae dawk hoi na hlout han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Sahnin vah tuikhu koe ka pha teh, Oe, ka bawipa Abraham e BAWIPA Cathut, ka ceinae koe a lam na cawn sak han pawiteh, ");
INSERT INTO cth_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Tuikhu koevah ka kangdue teh tui do hanlah ka tho e tanglakacuem apipatet koe haiyah, pahren lahoi tuium dawk e tui youn touh na pânei haw telah ka ti navah, ");
INSERT INTO cth_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Napui ni kai koevah, net haw. Na kalauknaw hanlah tui ka do han telah a ka tet e tami teh, ka bawipa e a capa hanlah BAWIPA ni a hmoun e lah awm naseh telah ka ti. ");
INSERT INTO cth_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Khenhaw! hottelah, ka lungthin hoi koung ka dei hoehnahlan vah, Rebekah teh tuium hoi a tho. Tuikhu koe a cathuk teh tui a do. Hahoi, ahni koevah, pahren lahoi tui na net sak haw telah ka ti. ");
INSERT INTO cth_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Ahni ni a loung dawk e tuium hah a patue teh tui net leih. Na kalauknaw hai tui pânei leih telah ati. Hatdawkvah, tui ka nei teh, kalauknaw tui a nei han haiyah a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kai ni nang apie canu maw telah ka pacei Ahni ni, Milkah ni a khe e Nahor e capa Bethuel e canu doeh telah ati. Hatdawkvah, a hnawng dawk hnongpacap ka bang pouh teh a kut dawk hai laikaw ka buet sak. ");
INSERT INTO cth_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ka lûsaling laihoi BAWIPA hah ka bawk teh, ka bawipa Abraham e BAWIPA Cathut, ka bawipa e a nawngha e canu, a capa hane a yu paluen pouh hane lamkatang dawk na kahrawikung hah ka pholen. ");
INSERT INTO cth_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Atuvah ka bawipa lathueng vah lungmanae hoi lawkkatang na kamnue sak hanelah awm pawiteh, na dei pouh haw. Hottelah hoeh nakunghai, kai koe vah na dei pouh awh haw. Hat to doeh, avoilah hai, aranglah hai ka kamlang thai tih telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban hoi Bethuel ni a pathung teh hete hno heh BAWIPA koehoi ka tâcawt e doeh. Ahawi thoseh, a thoe thoseh ka dei thai a hoeh. ");
INSERT INTO cth_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Khenhaw! Rebekah teh na hmaitung doeh ao. Hrawi nateh cetkhaih. BAWIPA ni a dei tangcoung e patetlah na bawipa e a capa e a yu lah awm naseh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Hahoi, Abraham e a sanpa ni ahnimae lawk a thai navah, talai a tabo teh BAWIPA hah a bawk. ");
INSERT INTO cth_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hatdawkvah, Abraham e a sanpa ni kamthoupnae suingun hoi hnicu a rasa teh Rebekah hah a poe. A thangroi hoi a manu hai aphu kaawm e hno hah a poe. ");
INSERT INTO cth_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ahni hoi a huinaw teh a canei awh teh, hote tangmin teh a roe awh. Amom a thaw teh ka bawipa koe na cetsak awh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hateiteh, a thangroi hoi a manu ni, napuica teh hnin dongdeng, hnin hra touh thung teh kaimouh koe awm sak ei, hahoi ka ceisak han telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ahni ni ahnimouh koevah, na haw awh hanh leih. BAWIPA ni ka ceinae dawk a lamcawn sak e patetlah ka bawipa koevah ka ban thai nahanlah na cetsak awh. ");
INSERT INTO cth_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ahnimouh ni, napuica kaw awh vaiteh, amae pahni ring awh ei sei telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebekah hah a kaw awh teh, hete tongpa koe na cei han maw telah a pacei awh. Napui ni ka cei han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hatdawkvah, a tawncanu Rebekah hoi kaawmkhai e, Abraham e a san hoi a hnukkâbang teh a ceisak awh. ");
INSERT INTO cth_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Hahoi ahnimouh ni Rebekah, ka tawncanu, nang teh tami a thongsang e manu lah na awm naseh, Na ca catounnaw ni a tarannaw e longkhanaw hah uk awh naseh telah yawhawi a poe awh. ");
INSERT INTO cth_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekah ni a tho teh a sannunaw hoi kalauk van a kâcui teh tongpa hnuk a kâbang. Hahoi, Abraham e a san ni Rebekah hah a hrawi. ");
INSERT INTO cth_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isak teh Beerlahairoi koe lahoi a tho. Bangkongtetpawiteh, akalah kaawm e doeh. ");
INSERT INTO cth_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tangminlasa vah Isak teh khopouk hanlah law lah a cei teh radoung teh a khet nah kalauk a tho e hah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekah ni a khet teh Isak a hmu toteh, kalauk van hoi a kum. ");
INSERT INTO cth_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Bangkongtetpawiteh, a san koevah, law dawkvah maimouh dawn hanlah ka tho e tami teh apimaw, telah yo a pacei toe. A san ni ka bawipa doeh telah atipouh. Hatdawkvah, minhmai ramuknae hni a la teh a minhmai hah a ramuk. ");
INSERT INTO cth_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","A san ni a sak e naw pueng Isak koevah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak ni Rebekah teh a manu Sarah e lukkareiim dawk a kâenkhai. A yu lah a coung teh a lungpataw. Hatdawkvah, a manu a due hnukkhu vah, Isak teh a lungmawng. ");
INSERT INTO cth_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham ni Keturah a yu lah bout a la. ");
INSERT INTO cth_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Hote a yu ni Zimran, Jokshan, Medan, Midian, Ishbak hoi Shuah tinaw a khe. ");
INSERT INTO cth_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan ni capa Sheba hoi Dedan a sak. Dedan capanaw teh Asshurim, Lethushim hoi Leummim tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian capanaw teh Ephah, Epher, Hanok, Abida hoi Eldaah tinaw doeh. Hetnaw pueng teh Keturah ca catounnaw lah ao. ");
INSERT INTO cth_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham ni a tawn e pueng hah Isak a poe. ");
INSERT INTO cth_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Hateiteh, Abraham ni a yu do hoi a sak e canaw teh poehno a poe. Ama a hring nah roeroe vah Isak koehoi kanîtholae ram lah a cei sak. ");
INSERT INTO cth_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham e a hringyung teh a kum 175 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham ni a hnukteng poung a kâha teh se kuep laihoi nget matong hoi kum rek kakueplah a due teh a hmaunawnghanaw koe vah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","A capa Isak hoi Ishmael ni Hit tami Zoar capa Ephron law dawk Mamre teng Makpelah talung kâko dawk a pakawp roi. ");
INSERT INTO cth_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hote law teh Abraham ni Hetnaw koehoi a ran e doeh. Hote hmuen koe Abraham teh a yu Sarah koe a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham a due hnukkhu vah, Cathut ni Isak hah yawhawi a poe. Isak teh Beerlahairoi dawk kho a sak. ");
INSERT INTO cth_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Het heh Abraham capa Ishmael, Sarah e a sannu, Izip tami Hagar ni Abraham hoi a khe roi e canaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Hetnaw heh min parui lahoi a catoun lahoi Ishmael capanaw e min lah ao. Ishmael capa camin teh Nebaioth doeh. A nawnghanaw teh Kedar, Adbeel, Mibsam tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO cth_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Jetur, Naphish hoi Kedemah tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hotnaw teh Ishmael capanaw lah ao teh amamouh hoi kho hoi a roenae patetlah a min a thut awh. A miphun parui lah bawi hlaikahni touh ao. ");
INSERT INTO cth_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael a dam nathung a kum teh 137 touh a pha. A hnuktengpoung e a kâha a phout teh a due. A hmaunawnghanaw koevah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ahnimouh teh Havilah ram koehoi Assyria ram pâtam hoi Izip ram teng Shur totouh kho a sak awh. A hmaunawnghanaw e hmaitung vah a due. ");
INSERT INTO cth_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham e capa Isak e catounnaw teh hettelah ao. Abraham ni a capa Isak a khe teh, ");
INSERT INTO cth_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak ni Paddanaram ram e Syria tami Bethuel canu, Syria tami Laban e a tawncanu Rebekah a yu lah a la nah a kum 40 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","A yu teh carôe dawk BAWIPA koevah pou a hei teh BAWIPA ni a heinae teh a thai pouh dawkvah Rebekah teh camo a vawn. ");
INSERT INTO cth_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Camo a vawn e teh a thung vah pou a kâthe dawkvah, ahni ni hettelah awm rah pawiteh, bangkongmaw kahring rah telah ati. Hatdawkvah, BAWIPA koe pacei hanlah a cei. ");
INSERT INTO cth_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","BAWIPA ni camo im dawk miphun kahni touh ao. Na von thung hoi miphun kahni touh kâkapek han. Miphun buet touh e teh buet touh e hlak a thayoun han. Hahoi, a hmau ni a nawngha e thaw a tawk pouh han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Hottelah camo khenae tueng a pha toteh, camo im dawk ca samphei e ao. ");
INSERT INTO cth_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Hmaloe e teh ka palingphung lahoi a tâco. Hni muen patetlah a muen puk a tho teh a min lah Esaw telah a phung. ");
INSERT INTO cth_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Hathnukkhu hoi, a nawngha teh Esaw e khokpaimai kuet lahoi a tâco. Hatdawkvah, a min lah Jakop telah a phung. Rebekah ni ahni a khe nah Isak teh a kum 60 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Camo roi a roung teh, Esaw teh moi ka ka thai poung e samram pou ka cet tami lah ao. Hateiteh, Jakop teh kâkamuete lah ao dawk im vah ao. ");
INSERT INTO cth_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isak teh Esaw ni a thokhai e moi ouk a ca dawkvah, Esaw hah a lungpataw. Hateiteh, Rebekah ni teh Jakop hah a lungpataw. ");
INSERT INTO cth_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Jakop ni rawca a thawng teh, Esaw teh kahrawng hoi a tho nah a vonhlam ni a khaw teh ngawt a tawn dawkvah, ");
INSERT INTO cth_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esaw ni Jakop koevah, pahren lahoi na thawng e rawca hah na cat sak haw. Bangkongtetpawiteh, ka vonhlam ni na khaw toe telah atipouh. Hat dawk nahoehmaw min teh Edom telah ati. ");
INSERT INTO cth_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Hateiteh, Jakop ni camin coungnae hah hmaloe lah na ran sak telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaw ni khenhaw! kai teh meimei ka due toe, camin coungnae teh kai hanlah bangmaw cungkei han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jakop ni, kai koevah hmaloe thoekâbo ei, telah atipouh. Jakop koe thoe a kâbo teh a camin coungnae hah a yo. ");
INSERT INTO cth_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Jakop ni Esaw teh vaiyei hoi rawca a thawng e hah a poe. Hottelah, a canei hnukkhu vah a tâco teh a cei. Hot patetlah Esaw ni camin coungnae hah banglahai noutna hoeh. ");
INSERT INTO cth_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abraham a hring nathung vah ahmaloe e takangnae hloilah, Isak tueng nahai hote ram dawk takangnae a tho. Hatdawkvah, Isak teh Gerar kho Filistin siangpahrang Abimelek koevah a cei. ");
INSERT INTO cth_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ahni koevah, BAWIPA a kamnue teh Izip ram vah cet hanh. Kai ni na dei pouh hane ram dawk awmh. ");
INSERT INTO cth_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Hete ram dawk awmh. Nang koe ka o vaiteh yawhawinae na poe han. Bangkongtetpawiteh, Hete ram pueng heh nang hoi na catounnaw koe poe hoi na pa Abraham koevah lawk ka kam e patetlah ka sak han. ");
INSERT INTO cth_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kalvan e âsi yit touh na ca catounnaw ka pung sak vaiteh hete ram pueng heh na ca catounnaw koevah ka poe han. Hahoi, na ca catounnaw lahoi talai miphunnaw pueng yawhawinae lah ao awh han. ");
INSERT INTO cth_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Bangkongtetpawiteh, Abraham ni kaie lawk, kai ni dei e, kaie kâpoelawknaw, kaie phunglawknaw hoi kaie kâlawknaw hah a tarawi telah ati. ");
INSERT INTO cth_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hot patetlah Isak teh Gerar vah kho a sak. ");
INSERT INTO cth_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Khocanaw ni a yu e kong a pacei teh ahni ni, ka tawncanu doeh telah atipouh. A meihawipoung dawkvah, ka yu doeh telah ka tetpawiteh hete khocanaw ni na thei han doeh telah ati dawk doeh. ");
INSERT INTO cth_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Hahoi, hote kho dawk moikasaw ao hnukkhu, Filistin siangpahrang Abimelek ni hlalangaw koehoi kho hah a radoung nah Isak ni a yu Rebekah hoi a pai roi e hah a hmu. ");
INSERT INTO cth_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek ni Isak hah a kaw teh na yu roeroe doeh. Bangkongmaw ka tawncanu telah na ti thai, telah atipouh. Isak ni ahni kecu dawk due hane ka taki dawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek ni kaimae lathueng vah bang hno maw na sak. Taminaw ni na yu heh a ikhai thai nahoehmaw. Hottelah kaimouh lathueng vah hnokahawi hoeh na pha sak thai nahoehmaw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelek ni apihai ama thoseh, a yu thoseh, ka tek e tami teh thei roeroe lah ao han telah a taminaw pueng koe kâ a poe. ");
INSERT INTO cth_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isak ni hote ram dawk cang a patue teh BAWIPA ni hote kum dawk roeroe alet 100 touh yawhawinae a poe. ");
INSERT INTO cth_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ahni teh hoehoe a bawi teh, lutlut bawi totouh a tawn, hnopai hoehoe a pungdaw pouh. ");
INSERT INTO cth_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Bangkongtetpawiteh, tuhunaw hoi maitonaw hoi a sannaw moi a tawn. Hatdawkvah, Filistinnaw ni a ut awh. ");
INSERT INTO cth_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","A na pa Abraham a hring nah a sannaw ni a tai e tuikhunaw pueng hah Filistinnaw ni hno han pasoung hoeh dawkvah, talai koung a paten sin awh. ");
INSERT INTO cth_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimelek ni Isak koevah, kaimouh koehoi tâcawt leih. Bangkongtetpawiteh, nang teh kaimouh hlak vah hno na sak thai telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isak ni hote hmuen koehoi a tâco teh Gerar yawn dawk rim a sak teh haw vah kho a sak. ");
INSERT INTO cth_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","A na pa Abraham ni a hring nah a tai e tuikhunaw hah Isak ni bout a tai. Bangkongtetpawiteh, Abraham a due hnukkhu vah Filistinnaw ni talai muen a paten awh. Hahoi, a na pa ni min a phung e patetlah min bout a phung. ");
INSERT INTO cth_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isak e sannaw ni hai hote yawn dawk tuikhu a tai awh teh hote hmuen koe tui a tâco e hah a hmu awh. ");
INSERT INTO cth_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Hateiteh, Gerar e saring kakhoumnaw ni tui heh kaimae doeh telah Isak e saring kakhoumnaw hoi a kâounkhai awh. Ahnimouh hoi a kâoun awh dawkvah, tuikhu e min teh Esek telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tuikhu alouke bout a tai teh hote haiyah lawp hanlah a kâounkhai awh dawkvah a min Sitnah telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hote hmuen koehoi a kampuen awh teh alouke tuikhu hah bout a tai awh. Hote teh lawp hanlah kâcai awh hoeh toe. Atu teh BAWIPA ni hmuen kakawpoung na sak pouh dawkvah hete ram dawk canaw moikapap ka khe awh han toe telah ati awh teh a min lah Rehoboth telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hote hmuen koehoi Beersheba lah a takhang awh. ");
INSERT INTO cth_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hote tangmin dawkvah BAWIPA teh ahni koevah a kamnue teh kai teh na pa Abraham e Cathut doeh, taket hanh, bangkongtetpawiteh, nang koe ka o. Yawhawinae na poe vaiteh, ka san Abraham pawlawk hoi na ca catounnaw ka pungdaw sak han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hote hmuen koe khoungroe hah a sak. BAWIPA min a kaw teh rim a sak. Hahoi, Isak e sannaw ni hote hmuen koe tuikhu hah a tai awh. ");
INSERT INTO cth_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Hatdawkvah, Gerar hoi Abimelek teh a hui Ahuzzath hoi a ransabawi Fikol hoi ahni koevah a tho awh. ");
INSERT INTO cth_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak ni na hmuhma awh teh namamouh koehoi na pâlei hnukkhu, bangkongmaw kai koevah bout na tho awh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ahnimouh ni nang koevah BAWIPA ao tie kamcengcalah ka panue awh. Patawnae poe hanlah ka tho awh hoeh. Hawinae hoi roumnae lahoi na ceisak e patetlah kaimouh pataw nahanlah banghai na sak hoeh nahanlah, ");
INSERT INTO cth_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","kaimouh rahak vah, nangmouh hoi kaimouh rahak roeroe dawkvah lawkkamnae awm naseh. Nang teh BAWIPA ni yawhawi a poe e tami doeh telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isak ni ahnimouh hanlah buvennae a sak pouh teh a canei awh. ");
INSERT INTO cth_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Amom lah palang a tho awh teh buet touh hoi buet touh thoebo lawkkamnae a sak awh. Isak ni a ceisak teh ahni koehoi karoumcalah hoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hote hnin dawkvah, Isak e sannaw hah a tho awh teh tuikhu a tai awh e kongnaw a dei pouh teh, tui ka hmu awh toe telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hote tuikhu teh Sheba telah ati awh. Hatdawkvah, hote kho teh sahnin totouh Beersheba telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaw teh a kum 40 touh a pha nah Hit tami Beeri canu Judith hoi Hit tami Elon e canu Basemath hah a yu lah a paluen. ");
INSERT INTO cth_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Hotnaw teh Isak hoi Rebekah a lung ka pataw sakkungnaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Hahoi, hettelah ao. Isak teh matawng toung dawkvah mithmu thai hoeh totouh a mitmawm hnukkhu, a capa kacue e Esaw hah a kaw teh ahni koevah, ka capa telah atipouh. Ahni ni hi vah ka o telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","A na pa ni atu kai teh ka matawng toe. Na tueng maw ka due han ti hai ka panuek hoeh. ");
INSERT INTO cth_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hatdawkvah, pahren lahoi palabom hoi licung hah sin nateh kahrawng vah moi na ka pouh haw. ");
INSERT INTO cth_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ka due hoehnahlan yawhawi na poe thai nahanlah ka ngai e patetlah katuipoung lah na thawng pouh nateh ka ca hanlah kai koevah thokhai telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Isak ni a capa Esaw hoi lawk a kâpato roi e hah Rebekah ni a thai. Hatdawkvah, Esaw teh moi ka hanlah kahrawng vah a cei. ");
INSERT INTO cth_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah ni a capa Jakop koevah, thai haw, na pa ni na hmau Esaw koevah, ");
INSERT INTO cth_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","moi ka nateh ka due hoehnahlan ka ca vaiteh BAWIPA hmalah yawhawinae na poe thai nahanlah rawca katuipoung lah na thawng pouh haw telah a dei pouh e ka thai. ");
INSERT INTO cth_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hatdawkvah, ka capa kai ni kâ na poe e patetlah na ngâi han. ");
INSERT INTO cth_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Atu saringnaw koe cet nateh haw e hmaeca kahawi e kahni touh kai koevah thokhai. Hottelah, na pa hanlah, ama ni a ngai e patetlah katuipoung lah na thawng pouh han. ");
INSERT INTO cth_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","A due hoehnahlan yawhawinae na poe thai nahanlah a ca hane na pa koevah na ceikhai han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jakop ni a manu Rebekah koevah, Khenhaw! ka hmau Esaw teh muen puk a tho, hatei, kai teh muen ka tawn hoeh. ");
INSERT INTO cth_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Apa ni na payam pawiteh, ahni ka dum e lah kaawm vaiteh, yawhawinae laipalah thoebonae koe kâhmo payon han na vaimoe telah a manu koe atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hatei, a manu ni ahni koevah, na thoebonae teh kai dawk phat na seh. Ka dei e hah tarawi nateh na lat pouh haw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ahni ni a cei teh a la. A manu koe a poe teh a manu ni na pa ni ngai e patetlah a thawng pouh. ");
INSERT INTO cth_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekah ni a capa kacue Esaw e khohna kahawipoung e, im ahni koe kaawm hah a la teh, a capa kanaw Jakop hah a khohna sak. ");
INSERT INTO cth_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Hmae pho hah a kut hoi muen o hoeh nae lahuen dawk a bet pouh. ");
INSERT INTO cth_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hahoi, ka tuipoung lah thawng e hmae moi hoi vaiyei hah a capa Jakop koevah a poe. ");
INSERT INTO cth_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hatdawkvah, na pa koe vah a cei teh, apa telah ati teh, a na pa ni hi vah ka o, ka capa, api nang maw telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jakop ni a na pa koevah, na capa kacue Esaw doeh, na patoun e patetlah koung ka sak toe, pahren lahoi thaw nateh yawhawinae na poe thai nahanlah rawca heh cat leih telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hatei, Isak ni a capa koevah, ka capa bangtelamaw telah karanglah na hmu thai telah atipouh. Ahni ni na BAWIPA Cathut ni na poe dawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak ni ka capa, na payam thai nahanlah pahren lahoi na hnai haw. Ka capa Esaw katang maw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jakop ni a na pa Isak teh a hnai. A na pa ni a payam teh na lawk teh Jakop e lawk doeh, a kut teh Esaw e a kut doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","A kut hah a hmau Esaw e kut patetlah muen a tho dawkvah, panuek thai laipalah yawhawinae a poe. ");
INSERT INTO cth_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","A na pa ni, ka capa Esaw nang ka tang maw telah atipouh. Ahni ni, Oe kai doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ahni ni, kai koe rek thokhai haw yawhawinae na poe thai nahanlah ka capa ni thokhai e moi teh ka ca hanlah telah ati. Hahoi, a hnai teh a ca. Misur hai a poe teh a nei. ");
INSERT INTO cth_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","A na pa Isak ni ahni koevah, ka capa na hnai nateh na paco haw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Hatdawkvah, a hnai teh a paco Ahni ni khohna hmui hah a thai teh yawhawi a poe. Thaihaw! ka capa e hmui heh BAWIPA ni yawhawinae ram hmuitui patetlah ao roeroe. ");
INSERT INTO cth_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hatdawkvah, Cathut ni kalvan e tadamtui thoseh, talai hawinae thoseh, cakang moikapap hoi misur moikapap na poe naseh. ");
INSERT INTO cth_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Miphunnaw ni na thaw tawk awh naseh, miphun hah na hmalah tabawk awh naseh. Na hmaunawnghanaw e bawi lah awm nateh, na manu e canaw na hmalah tabawk awh naseh. Thoe na ka bo naw pueng thoebo lah ao vaiteh yawhawinae na ka poe e pueng hah yawhawi awh naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Hahoi, hettelah ao. Isak ni Jakop yawhawinae phouk a poe nah Jakop teh a na pa koehoi nueng a tâco tahma vah Esaw teh samram a ceinae koehoi a tho. ");
INSERT INTO cth_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ahni ni hai katuipoung lah a thawng van teh, a na pa koevah a thokhai. A na pa koevah, na hringnae ni yawhawi na poe nahanlah apa teh a thaw vaiteh, a capa ni thokhai e moi hah cat naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","A na pa Isak ni ahni koevah, nang apimaw telah a pacei. Ahni ni na capa, na ca kacue Esaw doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak teh pueng hoi a pâyaw teh, moi ka hoi kai koe ka thokhai e teh apimaw. Nang na tho hoehnahlan ca vah koung ka ca teh yawhawi ka poe e hah teh api namaw. Ahni teh yawhawi lah ao roeroe han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaw ni a na pa e lawk dei e a thai navah, pueng hoi a ka teh a na pa koevah, Oe apa, kai hai, yawhawinae na poe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hateiteh, a na pa ni na nawngha ni na dum teh na yawhawinae na la pouh toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaw ni a min lah Jakop tie heh ahman katang nahoehmaw. Kai heh vai hni touh na dum teh na tâ toe. Camin coungnae na lah pouh. Atu ka yawhawinae bout na la pouh telah ati. Ahni roeroe ni yawhawinae na tat pouh hoeh maw, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak ni Esaw koe vah, khenhaw! ahni teh na bawi lah ka coung sak teh a hmaunawnghanaw pueng hai a san lah koung ka poe toe. Cakang hoi misur hoi ka kawk toe. Ka capa nang hanlah bangmaw na sak pouh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaw ni a na pa koevah, apa yawhawinae buet touh dueng maw na tawn Oe apa kai hai yawhawi na poe lah telah ati. Hatdawkvah, Esaw teh ngawngngawng a ka. ");
INSERT INTO cth_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","A na pa Isak ni Esaw koevah, thai haw, na o nahane teh talai kahawi hoi kahlun lahoi tadamtui hoi a kâhla han. ");
INSERT INTO cth_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Na tahloi hoi na kâkawk vaiteh na nawngha e thaw na tawk pouh han. Hahoi, hettelah ao han, kâhat laipalah na kâroe hnukkhu, a kahnam rui hah na lahuen dawk hoi a ling han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","A na pa ni yawhawi a poe dawkvah Esaw ni Jakop hah a hmuhma teh a lung hoi apa ka khuinae hnin teh a hnai toe. Hat hnukkhu ka nawngha Jakop teh ka thei han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","A capa kacue Esaw ni a dei e lawk hah Rebekah koe a dei pouh awh. Rebekah ni a capa kanaw Jakop a kaw teh, thai haw, na hmau Esaw teh nang na thei to doeh a lungroum ti. ");
INSERT INTO cth_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Hatdawkvah, atu ka dei e hah ngai. Thaw nateh Haran vah ka thangroi Laban koe vah yawng, ");
INSERT INTO cth_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Na hmau a lungkhueknae a roum hoehroukrak thung teh haw vah awm ei. ");
INSERT INTO cth_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Nange lathueng vah na hmau lungkhueknae a roum teh a lathueng vah na sak e heh a pahnim torei, tami ka patoun vaiteh na la sak han. Bangkongmaw hnin touh dawkvah nangmouh roi ka sung han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah ni Isak koevah, Heth canunaw kecu dawk kai hring hane ka ngai hoeh toe. Jakop ni hete ram dawk e canunaw patet e tami, a yu lah lat pawiteh, kai ka hringnae aphu bangmaw kaawm han toung telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hatdawkvah, Isak ni Jakop hah a kaw teh yawhawinae a poe, tawngtang lawk a thui e teh, Kanaan canunaw thung e yu na lat mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Thaw nateh Paddanaram ram dawk na manu e a na pa Bethuel im vah cet. Haw e na manu e a thangroi Laban canunaw thung dawk hoi na yu hah lat. ");
INSERT INTO cth_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Bangpueng ka sak thai e Cathut ni yawhawi na poe naseh, miphun moi kapap lah na pung thai nahanlah ca catoun moi na tawn sak teh na pungdaw sak naseh. ");
INSERT INTO cth_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Imyin lah onae ram, Cathut ni Abraham koe a poe e heh na coe nahanlah Abraham yawhawinae teh na coe sak awh naseh, nang hoi na canaw hoi telah lawk a thui. ");
INSERT INTO cth_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Hatdawkvah, Isak ni Jakop teh yout a ceisak teh, Paddanaram ram e Jakop hoi Esaw e manu Rebekah e a thangroi Syria tami Bethuel capa Laban koevah a cei. ");
INSERT INTO cth_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Isak ni Jakop hah yawhawi a poe teh a yu la hanlah Paddanaram ram lah a patoun. Yawhawi a poe nah Kanaan ram e tanglanaw yu lah na lat mahoeh telah lawk a thui. ");
INSERT INTO cth_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jakop ni a manu hoi a na pa e lawk hah a ngai teh, Paddanaram ram dawk a cei. ");
INSERT INTO cth_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kanaan ram e tangla naw ni a na pa Isak lungyouk sak hoeh toe tie a hmu navah, ");
INSERT INTO cth_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Esaw ni Ishmael koevah a cei teh a tawn tangcoung a yunaw hloilah, Abraham capa Ishmael e canu Mahalath Nebaioth tawncanu hah a yu lah a la. ");
INSERT INTO cth_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jakop teh Beersheba hoi a kamthaw teh Haran lah a cei. ");
INSERT INTO cth_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Hmuen buet touh koe a pha teh kanîloum toung dawkvah a roe. Talung buet touh hah a la teh lahoung lah a lahoung teh i hanlah a yan. ");
INSERT INTO cth_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Hahoi, mang a mang teh talai van khalai a kâdo teh a donghmo ni kalvan a pha. Hote khalai dawk Cathut e kalvantaminaw a kumluen awh. ");
INSERT INTO cth_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","A lathueng vah, BAWIPA a kangdue teh, Kai teh BAWIPA, na min Abraham e Cathut hoi Isak e Cathut lah ka o, na inae ram hah nang hoi na ca catounnaw ka poe han; ");
INSERT INTO cth_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Na ca catounnaw teh talai e vaiphu yit touh a pha awh han. Kanîtho, kanîloum, atunglah, akalah na pungdaw awh han. Nang pawlawk dawk hoi miphunnaw pueng ni yawhawinae a hmu awh han. ");
INSERT INTO cth_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Khenhaw! nang koevah ka o. Na ceinae pueng koe na kountouk vaiteh, hete ram dawk bout na bankhai awh han. Nang koe ka dei e ka sak hoehnahlan pueng teh na cettakhai mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jakop ni a kâhlaw teh, hete hmuen koe BAWIPA teh ao roeroe ka panuek laipalah ka o, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Hatdawkvah, a taki teh, het hmuen heh takikatho e lah ao! hete heh hmuen alouke nahoeh, Cathut e im, kalvan longkha lah ao, telah ati. Jakop ni amom a thaw teh a lahoung e talung hah a lah teh talung lah a ung teh a van vah satui hah a awi. ");
INSERT INTO cth_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Jakop ni amom a thaw teh a lahoung e talung hah a lah teh lungkhoung a ung teh, avan vah satui hah a awi. ");
INSERT INTO cth_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hote hmuen hah Bethel telah a phung. Hote kho teh hmaloe vah Luz lah ao. ");
INSERT INTO cth_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jakop ni, apa im dawk lungmawngcalah ka ban thai nahan, kai koe Cathut hah ao teh ka ceinae lam hah a ring teh, ");
INSERT INTO cth_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ca han e vaiyei hoi kâkhu hane hni na poe boipawiteh, BAWIPA teh ka Cathut lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Hete talung ka ung e haiyah Cathut e im lah ao han, hahoi na poe hane naw pueng thung dawk hoi hra touh dawk buet touh teh na poe roeroe han, telah lawkkamnae hah a sak. ");
INSERT INTO cth_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jakop ni pou a cei teh Kanîtholae taminaw e ram dawk a pha. ");
INSERT INTO cth_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","A khet navah tuikhu kaawm e lawpam vah tuhu kathum touh a kamkawn e hah a hmu. Bangkongtetpawiteh, tuikhu thung e tui hah tunaw ouk a pânei awh. Tuikhu koe lungsong ao. ");
INSERT INTO cth_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hote hmuen koe tunaw pueng pâkhueng lah ao han. Tuikhu khannae lungsong hah takhoe vaiteh, tu tui pânei hoi talung teh ama onae hmuen dawk bout teng lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jakop ni ahnimouh koevah, ka hmaunawnghanaw api kho maw, telah a pacei. Ahnimouh ni, Haran taminaw doeh telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ahni ni ahnimouh koevah, Nahor capa Laban na panue awh maw telah a pacei. Ahnimouh ni, Oe ka panue awh, telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ahni ni ahnimouh koevah, a hring rah maw, telah a pacei. Ahnimouh ni, Oe a dam rah doeh, khenhaw! a canu Rachel hai tu hoi a tho lahun, telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ahni ni, Khenhaw! Kanî asaw rah, saring pâkhueng hanelah khout hoeh rah. Tunaw hah tui pânei awh nateh bout tha awh ei, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Hateiteh, ahnimouh ni, tuhunaw pueng pâkhueng teh tuikhu tengnae talung takhoe hoehnahlan pueng teh tui pânei thai lah awm awh hoeh. Takhoe hnukkhu to doeh tu heh tui ouk ka pânei awh, telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Hottelah, lawk a kâpan navah, Rachel teh a na pa e tunaw hoi a tho, bangkongtetpawiteh ahni teh tu ka khoum e napui lah ao. ");
INSERT INTO cth_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Hahoi, hettelah ao. Jakop ni a manu e a thangroi Laban e canu Rachel hoi tunaw a hmu toteh, a cei sin teh tuikhu tengnae talung hah a takhoe pouh teh a manu e a thangroi e tu hah tui a pânei pouh. ");
INSERT INTO cth_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hahoi, Jakop ni Rachel hah a paco teh ngawngngawng a ka. ");
INSERT INTO cth_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jakop ni Rachel koe a na pa e a na minca lah a onae hoi Rebekah e capa lah a onae kong hah a dei pouh. Hatdawkvah, Rachel ni a na pa koe ayawng teh a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Hahoi, Laban ni a tawncanu e capa Jakop kong a thai tahma, ahni dawn hanelah ayawng. A tapam teh a paco hnukkhu, a im vah a hrawi. Jakop ni Laban koe hno kâhmo e akongnaw pueng a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ni ahni koe, nang teh ka misa katang doeh, telah atipouh teh ahni koevah thapa yung touh ao. ");
INSERT INTO cth_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban ni Jakop koevah, Ka minca lah na o dawkvah, aphu laipalah ka thaw na tawk han na maw. Bangmaw na poe han dei haw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban ni canu kahni touh a tawn teh a camin teh Leah a phung, a cahnoung teh Rachel a phung. ");
INSERT INTO cth_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah teh a mit roumkawt e lah ao. Hatei, Rachel teh a tungtang hoi a mei kahawi e tami lah ao. ");
INSERT INTO cth_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jakop ni Rachel a ngai dawkvah, na canu kanaw e Rachel hanlah kum sari touh na thaw ka tawk han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ni, ayâ alouke ka poe hlak teh nang na poe e heh ahawihnawn han doeh, kai koe awmh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hatdawkvah, Jakop ni Rachel hanlah kum sari touh a thaw a tawk pouh, a lungpataw poung dawkvah hnin dawngdengca e patetlah a pouk. ");
INSERT INTO cth_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Jakop ni Laban koe, ka ikhai thai nahanlah ka yu teh na poe leih, bangkongtetpawiteh, ahnintha teh akuep toe, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban ni khoca pueng a pâkhueng teh bu canae pawi a sak. ");
INSERT INTO cth_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Hahoi, kho a hmo nah a canu Leah a hrawi teh Jakop koevah a thak pouh teh a ikhai. ");
INSERT INTO cth_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban ni a sannu Zilpah hah a canu Leah koevah san hanlah a poe. ");
INSERT INTO cth_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Khodai toteh, khenhaw! Leah lah a o, Jakop ni Laban koevah, ka lathueng vah na sak e heh bangmaw. Rachel ka yu nahanlah na thaw ka tawk hoeh na maw. Bangkongmaw na dum, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ni, Ka ram dawk a hmau hoehnahlan a nawngha ceisak phung roeroe nahoeh. ");
INSERT INTO cth_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Hete napui hanlah hnin sari kuep sak ei, hahoi, kum sari touh ka thaw bout na tawk han e dawk alouknaw hai na poe han, telah atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jakop ni hottelah a sak teh hnin sari touh a kuep sak teh Laban ni a canu Rachel haiyah a yu hanlah a poe. ");
INSERT INTO cth_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Hahoi, Laban ni a sannu Bilhah hah a canu Rachel koevah a san hanlah a poe. ");
INSERT INTO cth_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Rachel bout a ikhai. Leah hlakvah Rachel heh a lung hoe a pataw dawkvah, Laban e thaw kum sari touh bout a tawk pouh. ");
INSERT INTO cth_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","BAWIPA ni Leah teh lungpataw hoeh tie a panue dawkvah a thun a kamawng sak. Hatei, Rachel teh a carôe. ");
INSERT INTO cth_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah teh camo a vawn teh ca tongpa a khe, a min lah Reuben a phung. Bangkongtetpawiteh, BAWIPA ni runae ka kâhmo e a panue. Hatdawkvah, atu teh ka vâ ni na lungpataw han toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Camo bout a vawn teh ca tongpa bout a khe. Kai na hnoun e BAWIPA ni a thai dawkvah, hete ca tongpa hai na poe telah ati teh Simeon telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Camo bout a vawn teh ca tongpa bout a khe. Atu teh ca tongpa kathum touh ka khe pouh toe dawkvah, ka vâ ni na tha mahoeh toe, telah ati. Hatdawkvah, a min lah Levih a sak. ");
INSERT INTO cth_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Hahoi, camo bout a vawn teh ca tongpa bout a khe. Atu teh, BAWIPA ka pholen han, telah ati. Hatdawkvah, a min Judah a phung. Hahoi teh, camo khe hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Rachel ni Jakop hanlah camo a khe pouh hoeh e a hmu toteh, a hmau hah a ut teh Jakop koe, Camo na poe, nahoeh pawiteh ka due han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jakop teh Rachel koe a lungkhuek teh, ca khe han ka pasoung hoeh e Cathut yueng lah maw ka o, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Napui ni, khenhaw! ka sannu Bilhah heh ipkhai nateh kai ni hai ahni koehoi camo ka tawn thai nahanlah, ka phai dawk camo a khe han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Hatdawkvah, a sannu Bilhah teh a yu hanlah a poe teh Jakop ni a ikhai. ");
INSERT INTO cth_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah ni camo a vawn teh Jakop hanlah ca tongpa a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel ni, Cathut ni na pouk teh ka lawk hai a thai dawkvah, ca tongpa na poe, telah ati. Hatdawkvah, a min lah Dan a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Rachel e a sannu teh camo bout a vawn teh Jakop hanlah ca tongpa apâhni bout a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel ni, ka hmau hoi kâthe teh ka tâ toe telah ati. Hatdawkvah, a min lah Naptali a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah ni camo ka khe thai hoeh toe tie a kâpanue dawkvah, a sannu Zilpah hah a ceikhai teh a yu hanlah Jakop hah a poe. ");
INSERT INTO cth_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Hatdawkvah, Leah e a sannu, Zilpah ni camo tongpa Jakop hanlah a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah ni, a yawhawi, telah ati teh, a min lah Gad a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Leah e a sannu Zilpah ni ca tongpa Jakop hanlah bout a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah ni, Ka yaw ahawi, napuinaw ni a yaw kahawi poung katang e na ti pouh han, telah ati teh a min lah Asher a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Canga tue nah Reuben teh law vah a cei teh, hloisi hah a hmu teh a manu Leah koevah a thokhai. Hatdawkvah, Rachel ni Leah koevah, pahren lahoi na capa hloisi youn touh na poe haw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ahni ni, ka vâ na lawp e heh hno tica e lah maw na pouk, ka capa hloisi totouh lawp han e na kâcai telah atipouh. Rachel ni, hat boi pawiteh, na capa e hloisi yueng lah atu tangmin na ikhai han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tangmin lah Jakop teh law hoi a tho teh, Leah ni a dawn hanlah a thaw teh, Na ikhai roeroe han, bangkongtetpawiteh, ka capa koe e hloisi heh ka hlai toe, telah ati dawkvah, hote tangmin teh a ikhai. ");
INSERT INTO cth_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Cathut ni Leah e ratoumnae hah a tarawi, camo a vawn teh Jakop hanlah ca tongpa panganae a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah ni, Ka sannu hah ka vâ koe ka poe dawkvah, Cathut ni ka tawknae aphu hah na poe van, telah a titeh a min lah Issakhar a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Leah ni, Camo bout a vawn teh Jakop hanlah ca tongpa ataruknae bout a khe pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Leah ni, Cathut ni kahawi poung e kamthoupnae hoi na pathoup, ka vâ hanelah ca tongpa taruk touh ka khe pouh toung dawkvah, kai koe ao han toe, telah a titeh a min lah Zebulun a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Hathnukkhu, napuica bout a khe teh a min lah Dinah a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Cathut ni Rachel hah pahnim hoeh. Hatdawkvah, Cathut ni a ratoumnae a tarawi pouh teh, camo im a kamawng sak. ");
INSERT INTO cth_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hahoi, camo a vawn teh ca tongpa a khe. Cathut ni ka min mathoenae na ramuk pouh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Hahoi, BAWIPA ni capa alouke bout na poe ei naseh, a titeh a min lah Joseph a phung. ");
INSERT INTO cth_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rachel ni Joseph a khe hnukkhu hettelah ao. Jakop ni Laban koevah, ka onae ram lah ka ban thai nahanlah na cetsak leih. ");
INSERT INTO cth_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Na thaw na tawk pouh toe. Hatdawkvah, ka yunaw hoi ka canaw na poe nateh na cetsak leih, bangkongtetpawiteh na thaw ka tawk e naw hah na panue, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban ni, Na pahren thai pawiteh, awm ei. Bangkongtetpawiteh, BAWIPA ni nang pawlawk dawk hoi yawhawinae na poe e hah ka mithmu vah ka panue, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ama roeroe ni na hmu hane to nateh na poe han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jakop ni ahni koevah, bangtelamaw na thaw ka tawk tie hoi na saring hah bangtelamaw kai koe ao ti hah na panue. ");
INSERT INTO cth_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ka tho hoehnahlan teh yitca doeh na tawnh, atuteh moikapap a kampung. Pek ka tho hoi BAWIPA ni yawhawinae hah na poe. Nâtuek maw ka imthungkhu hanelah thaw ka tawk van han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Hatdawkvah ahni koe, bangmaw na poe han telah atipouh. Jakop ni, banghai na poe hanh. Hetheh na sak pouh boipawiteh, na saringnaw teh bout na khoum pouh han. ");
INSERT INTO cth_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Sahnin vah tuhu, hmaehu, thung ka cei teh, tarakcak e hmaenaw, humtamang e tunaw pueng hah koung a kapek toe. Hathnukkhu ka tarakcak e hmae, humtamang e tunaw teh kai ni ka coe hane aphu lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hatdawkvah, atotovah kaie tawkphu ka hmu hane teh na hmalah a pha to vah, ka lannae ni na pathung han doeh. Hmae thung dawk tarakcak lah a em ka pangaw hoeh e, a em kasawlah ka pangaw hoeh e, tu thung dawk ka tamang hoeh e kai koe na hmawt pawiteh, ka paru e lah na pouk han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban ni, Oe, na dei e patetlah tho lawiseh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hot hnin totouh hoi, hmaetan tarakcak ni teh kasawlah a em kaawmnaw pueng hoi, Hmae manu tarakcak ni teh kasawlah a em kaawm e naw pueng, ka pangaw pueng hoi tu thung dawk ka tamangnaw pueng hah a kapek pouh teh a capanaw e a kut dawk a poe. ");
INSERT INTO cth_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ahni hoi Jakop rahak vah hnin thum lamcei koe ao sak teh, Jakop ni Laban e saringnaw pueng hah bout a thak pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jakop ni poplar hoi hazel hoi almond thing e akangnaw hah a la teh tarakcak lah a tarik. ");
INSERT INTO cth_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Saringnaw ni tui ouk a neinae dokko hoi palang dawkvah, saringnaw e hmalah sonron hah a ta. Bangkongtetpawiteh, tui nei hanlah ouk a tho awh nah saring hah âvâ ouk a cu awh. ");
INSERT INTO cth_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Hatdawkvah, saring hah sonron teng âvâ ouk a cu nah, a em tarakcak lah ouk a khe. ");
INSERT INTO cth_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Hahoi, Jakop ni tucanaw a kapek teh, Laban e saringhu thung dawk e a em kaawm hoi katamangnaw pueng koe lah a kangvawi sak. Amae saring hah a kapek teh Laban e saring hoi rei hrueng hoeh. ");
INSERT INTO cth_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Atha bet kaawm hnawn e saring âvâcu toteh, sonron hmalah âvâcu thai nahanlah, Jakop ni tui a lawngnae koe saringnaw e a hmaitung vah, sonron hah ouk a ta pouh. ");
INSERT INTO cth_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Hatei, saring hah kamsoe pawiteh tat pouh hoeh. Hottelah, ka kamsoe e a canaw teh Laban e lah ao teh, a tha bet kaawm e naw hah Jakop e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hatdawkvah, Jakop koe moi kapap lah a kampung teh saringhu moi kapap, sannu hoi sanpa naw hoi, kalauknaw hoi lanaw hah a tawn. ");
INSERT INTO cth_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Laban e canaw ni, Jakop ni kaimae apa e hno pueng koung a la pouh dawkvah, hete tawnta e naw pueng heh a hmu e doeh, telah a dei awh e lawk hah Jakop ni a thai. ");
INSERT INTO cth_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jakop ni, Laban e minhmai a khet nah a hmoun e patetlah minhmai kahawi ka hmawt hoeh toe tie hah a panue. ");
INSERT INTO cth_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hatdawkvah, BAWIPA ni Jakop koevah, na mintoenaw e ram hoi na imthungkhu lah ban nateh, nang koe vah ka o han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jakop ni tami a patoun teh Rachel hoi Leah hah saring onae law vah tho hanelah a kaw sak. ");
INSERT INTO cth_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ahnimouh roi koe, na pa e minhmai ka hmu navah, ahmoun e patetlah minhmai kahawi ka hmawt hoeh toe tie hah ka panue, hateiteh Apa Cathut teh kai koe ao toe. ");
INSERT INTO cth_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ka thayung abuemlahoi na pa e thaw ka tawk e hah na panue awh. ");
INSERT INTO cth_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hot nahlangva na pa ni na dum teh, ka hmu hane aphu hah vai hra touh na dum toe. Hatei patawnae na poe hane teh Cathut ni na pasoung hoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tarakcak e pueng hah aphu lah ao han telah a dei teh saring pueng ni tarakcak lah koung a khe. Taracak hoi kâkalawt lah a khe e pueng aphu lah ao han ati ei nakunghai, saring pueng ni tarakcak lah koung a khe. ");
INSERT INTO cth_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hottelah, Cathut ni na pa e saringhu hah a la pouh teh kai na poe e doeh. ");
INSERT INTO cth_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Hahoi hettelah ao. Saring âvâ yawng hane a kamtawng nah ka mang lah ka khet teh, khenhaw! âvâ ka cawt e a tan hah a em lah kaawm e hoi a em tarakcak e hoi, a em dakdak kaawm e naw hah ka hmu. ");
INSERT INTO cth_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ka mang lah Cathut e kalvantami ni, Jakop ati teh kai ni, hi vah ka i doeh, ka ti pouh. ");
INSERT INTO cth_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ahni ni, moung na teh, khenhaw! a tan ni âvâ a yawng e pueng hah a em kaawm hoi a em tarakcak e hoi a em dakdak kaawm naw seng doeh. Bangkongtetpawiteh, Laban ni nang dawk a sak e naw pueng hah be ka panue. ");
INSERT INTO cth_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Kai teh talung na ungnae dawk satui na awinae, kai koe lawkkam na saknae Bethel, hote Bethel Cathut lah ka o. Atu thaw nateh hete ram heh tâcawt takhai, na khenae ram koe lah ban leih, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel hoi Leah ni a pathung roi teh, apa im e maimouh hanelah ham hane hoi râw ao rah maw. ");
INSERT INTO cth_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ahni ni imyin patetlah na pouk awh toung nahoehmaw. Bangkongtetpawiteh, na yo awh teh maimae tangka hai be a ca awh toe. ");
INSERT INTO cth_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Bangkongtetpawiteh, Cathut ni maimae na pa koehoi a la e naw pueng teh, maimae canaw hane doeh. Hottelah Cathut ni nang koe a dei e pueng teh sak yawkaw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jakop hah a thaw teh, a capanaw hoi a yu roi hah kalauk dawk a kâcui sak. ");
INSERT INTO cth_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Kanaan ram a na pa Isak koe cei hanelah a saringnaw hoi hnopai a pâtung e a hmu e saringnaw pueng, Paddanaram ram e a tawn e naw pueng be a sin awh. ");
INSERT INTO cth_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laban teh amae tu muen ngaw hanelah a cei teh Rachel ni a cei teh a na pa e Terah meikaphawk hah yout a la pouh. ");
INSERT INTO cth_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jakop teh Siria tami Laban panuek laipalah, arulahoi a cei. A cei hane hah dei pouh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Hottelah a tawn e naw pueng hoi a yawng. A thaw teh palang a raka teh Gilead mon lah pâtam lahoi a cei. ");
INSERT INTO cth_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jakop a yawng tie hah apâthum hnin vah Laban koe a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","A hmaunawnghanaw a hrawi teh, hnin sari touh thung a pâlei teh Gilead mon dawk rek a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hateiteh, Siria tami Laban koe karum a mang lahoi Cathut a tho teh, Jakop koe a thoe hoi hawi banghai na dei hoeh nahanelah kâhruetcuet, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Hottelah Laban ni Jakop hah rek a pha. Jakop ni rim hah mon dawk a yap teh, Laban hoi a hmaunawnghanaw ni Gilead mon dawk ahnimae rim hah a yap awh van. ");
INSERT INTO cth_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban ni Jakop koe, na sak e hno heh bangmaw. Ka thai laipalah dung na cei awh teh, tarantuknae koe man e patetlah ka canunaw na yawngkhai. ");
INSERT INTO cth_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Bang kecu dawk maw, arulahoi tapueng hoi ratoung hoi na thak thai nahanlah dei laipalah na o. ");
INSERT INTO cth_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ka capanaw hoi ka canunaw ka paco han na pasoung hoeh. Hottelae pathunae hno hah na sak. ");
INSERT INTO cth_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Kai ni koung na raphoe thai han ei teh, na pa Cathut ni karum ka mang lah, Jakop koe a thoe hoi hawi banghai na dei hoeh nahanelah kâhruetcuet, telah na dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Na pa im na rabui poung kecu dawkvah, na ka cet e katang lah na o. Hatei bang kecu dawk maw ka cathutnaw na paru pouh awh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jakop ni a pathung teh Laban koe, na canunaw heh thama lah na lawm vai tie hah ka puen dawk doeh. ");
INSERT INTO cth_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Namae cathut ka lat e teh hring sak hanh. Ka hmaunawnghanaw mithmu vah na cathut kai koe kaawm e teh kahawicalah khen nateh, lat yawkaw, telah ati. Bangkongtetpawiteh, Rachel ni a paru e hah Jakop ni la panuek hoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban teh Jakop e rim hoi Leah e rim hoi a sannu kahni touh roi e rim koe a tawng teh, hmawt hoeh. Hahoi, Leah e rim hoi a tâco teh Rachel e rim dawk a kâen. ");
INSERT INTO cth_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel ni meikaphawk hah a la teh kalauk ni phunae hno thung vah a hro. Laban ni rim thung naw pueng hah pheng a pâphue eiteh hmawt hoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel ni a na pa koe, na hmalah ka thaw ngai tho hoeh. Ka bawipa, na lungkhuek sak hanh, ka kampheng lahun lah ao dawk doeh, telah ati. Pheng a pâphue eiteh meikaphawk hah hmawt thai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jakop teh a lungkhuek teh, Laban hah a yue. Jakop ni Laban koe, bang e phung maw ka ek, bangmaw ka yonnae ao teh, na lungkhuek laihoi na pâlei. ");
INSERT INTO cth_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ka hnopainaw pueng be na pâphue teh, namae hnopai bangmaw na hmu. Maimouh roi teh lawkkâceng thai nahan ka hmaunawnghanaw hoi nange hmaunawnghanaw e hmalah tat. ");
INSERT INTO cth_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Kum 20 totouh nang koe ka o teh, na tu hoi na hmaenaw ni ca khe laipalah awm boihoeh. Na tuhu thung e a tan hai ka cat boihoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Moimatheng ni a kei e hai nang koe ka phatkhai boihoeh. Kai ni paleipalang kahmat e yueng lah ouk ka rawng. Kanîthun lah a paru e naw karum lah a paru e naw hai na patho sak. ");
INSERT INTO cth_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Hettelah ouk ka o. Kanîthun khumbei um hai, karum a pâding nahai, rucat um hai, ka tawk. Ihmu boum lah ka ip boihoeh. ");
INSERT INTO cth_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Hottelah kum 20 touh thung na im vah ka o teh, na canu roi ka hni touh kutphu e dawk kum 14, na thaw ka tawk. Na saring kutphu dawk kum 6 ka tawk teh, kutphu hah vai hra totouh bout na dum. ");
INSERT INTO cth_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Apa Cathut, Abraham Cathut, Isak Cathut ni a taki e hah kai koe awm hoehpawiteh, atu patenghai tak caici lah ban sak han na noe. Cathut ni karucatnae hoi ka patangnae hah a panue, paduem vah na yue toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban ni a pathung teh, Jakop koe, napuinaw heh kaie canunaw doeh. Tongpanaw hai kaie capanaw doeh. Saringnaw hai kaie saringnaw doeh. Na tawn e naw pueng heh kaie seng doeh. Hateiteh, sahnin vah hete ka canunaw hoi a canaw e a lathueng vah bangmaw ka sak thai han. ");
INSERT INTO cth_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Hatdawkvah, nang hoi kai lawkkamnae sak roi sei. Hothateh, nang hoi kai rahak dawk kapanuekkhaikung lah awm seh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hottelah, Jakop ni talung a la teh talung hah a ung. ");
INSERT INTO cth_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Telah Jakop ni a hmaunawnghanaw koevah, talung pung awh haw, telah ati. Talung hah a la awh teh, a pung awh. Hot van vah bu a ca awh. ");
INSERT INTO cth_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban ni talung pung e hah Jegarsahdutha telah a phung. Hateiteh Jakop ni Galeed telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban ni hete pung e talung heh sahnin vah, kai hoi nang rahak vah, lawk kapanuekkhaikung lah ao telah ati. Hatdawkvah a min lah Galeed telah ati e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mizpah telah hai ati awh. Bangkongtetpawiteh, Laban ni kamphei awh hnukkhu hoi BAWIPA ni maimanaw na ring lawiseh. ");
INSERT INTO cth_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka canunaw heh roedeng na poe teh, yu alouke na tawn pawiteh, apihai maimouh koe awm hoeh eiteh, khenhaw! Cathut teh nang hoi kai rahak vah, kapanuekkhaikung lah ao, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban ni Jakop koe hete talung ung e hoi hete talung pung e heh kai hoi nang rahak vah ka ta e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Patawnae poe hanelah kai ni hete talung pung e hoi talung ung e hloilah ka tho mahoeh, tie hoi nang ni hai hete talung pung e hoi talung ung e hloilah tapuet hoi na tho mahoeh, telah hete talung pung e hah kapanuekkhaikung lah awm nateh, hete talung ung e hai kapanuekkhaikung lah awm naseh. ");
INSERT INTO cth_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham Cathut, Nahor Cathut, a na pa Cathut ni maimae rahak lawkceng naseh, telah ati. Hahoi Jakop ni a na pa Isak ni taki e noe lahoi thoe a bo. ");
INSERT INTO cth_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jakop ni mon dawkvah, thuengnae a sak teh a hmaunawnghanaw hah vaiyei ca hanelah a kaw teh, vaiyei hah a ca awh. Mon dawkvah a roe awh. ");
INSERT INTO cth_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban teh amom vah a thaw teh, a capanaw hoi a canunaw hah a paco teh yawhawi a poe hnukkhu Laban teh a ma onae koe lah a ban. ");
INSERT INTO cth_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jakop teh a cei teh, Cathut e kalvantaminaw ni a dawn. ");
INSERT INTO cth_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jakop ni hmu toteh hete Cathut roenae hmuen doeh telah a titeh, hote hmuen teh Mahanaim telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jakop ni Edom ram e Seir ram dawk a hmau Esaw koevah a hmalah patounenaw a patoun. ");
INSERT INTO cth_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ahnimouh koe lawk a thui. Ka bawipa Esaw koe hettelah na dei awh han. Na san Jakop ni hettelah ati, Laban koe imyin lah ka o teh atu totouh ka o. ");
INSERT INTO cth_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Maitotan hoi, la hoi tunaw hoi, hmaenaw hoi sanpa sannunaw hah ka tawn. Hatdawkvah, na minhmai kahawi ka hmu thai nahanlah ka bawipa koe dei pouh hanelah, taminaw ka patoun ati, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Patounenaw hah Jakop koe a ban awh teh, na hmau Esaw koe ka pha awh. Tami 400 touh hoi nang na dawn hanelah ahni hai a kamthaw, telah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Hatdawkvah, Jakop ni a takipoung teh kângairu hoi ao. Ama koe kaawm e taminaw hoi tuhu hoi maitohu hoi kalauknaw hah hu kahni touh lah koung a kapek. ");
INSERT INTO cth_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jakop ni Esaw a kâhmo toteh, ahu buet touh e thet pawiteh a hu alouknaw teh ka yawngkhai thai han doeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hottelah Jakop ni, oe apa Abraham Cathut, apa Isak Cathut, oe BAWIPA na ram hoi na imthungnaw koe ban nateh, kaimouh ka thet hane katetnaw, ");
INSERT INTO cth_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","na san e lathueng vah lungmanae hoi yuemkamcunae pueng na kamcu sak e thung dawk hoi, kathoengpounge patenghai hmu hanelah ka kamcu hoeh. Bangkongtetpawiteh, Jordan palang hah ka sonron hoi dueng ka raka teh atuteh a hu kahni touh ka pha toe. ");
INSERT INTO cth_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Pahren lahoi ka hmau Esaw e kut thung roeroe hoi na rungngang haw. Bangkongtetpawiteh, napui camonaw hoi kaimouh rekrek na saueng han doeh tie hah puenghoi ka tâsue. ");
INSERT INTO cth_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bangkongtetpawiteh, nama ni, na pungdaw sak vaiteh, na ca catounnaw hah touk thai hoeh e talî dawk e sadi yit touh na pap sak han na tie hah, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Hate karum teh hawvah a roe awh. Hahoi a tawn e thung dawk hoi hmae manu 200, hmaetan 20, ");
INSERT INTO cth_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Kalauk sanu kasu lahun e 30, a canaw khuehoi maito manu 40, maitotan 10, ");
INSERT INTO cth_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","La manu 20, la a kum kanaw e 10, hetnaw hah a hmau Esaw koe poehno lah poe hanelah a pasoum. ");
INSERT INTO cth_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hotnaw teh a huhu lahoi aloukcalah a sannaw kut dawk a poe. Hahoi, ahnimouh koe, ka hmalah cet awh nateh, a louklouk lah rahak kaawm lahoi cet awh, ati. ");
INSERT INTO cth_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hahoi lam kahrawikung koevah, ka hmau Esaw hoi na kâhmo toteh, apie taminaw maw, na maw na cei awh han, nangmae na hmalah kaawmnaw hah apinaw maw, telah na pacei awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Na san Jakop e naw seng doeh. Ka bawipa poe hanelah poehno na patawn e naw doeh. Khenhaw! ama hai kaimae hnuklah ao, na ti pouh awh han, telah lawk a thui. ");
INSERT INTO cth_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Apâhni e hoi apâthum e hoi saring kakhoumnaw pueng koe hai, Esaw na kâhmo torei teh, hot patetlah na dei awh han. ");
INSERT INTO cth_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Hahoi khenhaw! na san Jakop teh kaimae hnukkhu lah ao na ti pouh awh han, telah lawk a thui. Bangkongtetpawiteh, ka hmalah ka cet e poehno ni a lungthin ahawi sak han. Hathnukkhu hoi a mei ka hmu han, telah pawiteh, a lungroum yawkaw han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Hatdawkvah, poehno hah a hmalah a ceisak. Hatei, ama teh hote karum teh tamihunaw koe a roe. ");
INSERT INTO cth_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Karum vah a thaw teh a yu roi hoi a canaw hlaibun touh hah a ceikhai teh Jabbok palang hah a raka awh. ");
INSERT INTO cth_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ahnimouh hah a ceikhai teh palang hah a raka awh. A tawn e naw pueng hai a ceikhai. ");
INSERT INTO cth_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jakop amadueng ao nah tami buet touh hoi khodai totouh a kâthe roi. ");
INSERT INTO cth_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ahni ni ka tâ mahoeh tie a panue toteh, Jakop e a sumbunghru kâcunae koe a khoe pouh. Hatdawkvah Jakop teh a khokkhem. ");
INSERT INTO cth_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ahni ni, na cetsak leih, bangkongtetpawiteh kho hai a dai toe telah ati. Hateiteh, ahni ni yawhawi na poe hoehpawiteh, na cetsak mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ahni ni na min a pimaw telah a pacei navah, Jakop telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ahni ni na min Jakop teh Jakop tet mahoeh toe, Isarel ati awh han toe. Bangkongtetpawiteh Cathut hoi tami hai na the teh na tâ toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jakop ni pahren lahoi na min apimaw telah a pacei. Ahni ni bang kecu dawk maw ka min na pacei telah ati. Hawvah yawhawinae a poe. ");
INSERT INTO cth_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Haw e hmuen teh Jakop ni Peniel, telah ati. Bangkongtetpawiteh, Cathut teh minhmai kâhmo lahoi ka hmu teh ka hringnae hah a pâhlung telah ati. ");
INSERT INTO cth_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Hahoi Penuel hoi a tâco nah, kanî a tâco, Ahni teh a kamlang teh a phaihru kecu dawk a dongkhawt. ");
INSERT INTO cth_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Hatdawkvah, Jakop e phai hru kâcunae koe a khoe pouh dawkvah, sahnin totouh Isarel catounnaw ni phai hru kâcunae koe e tharui hah cat boi awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Hahoi Jakop ni a radoung teh, khenhaw! Esaw teh tami 400 touh hoi a tho. Hahoi a canaw hah Leah hoi a sannu koe vah a ta. ");
INSERT INTO cth_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hahoi a sannu hoi a canaw hah hma ahman, hat hnukkhu vah Leah hoi a canaw, Rachel hoi Joseph teh a hnukteng poung lah a ta. ");
INSERT INTO cth_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ama teh hma ahman teh, a hmau teng a pha toteh talai vaisari touh a tabo. ");
INSERT INTO cth_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Hatei ama kâhmo hanelah Esaw koe a yawng teh, a kâtapam roi teh, a kâpaco roi teh, a ka roi. ");
INSERT INTO cth_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esaw ni a khet teh, napui hoi camonaw hah a hmu. Hahoi teh na thokhai e naw hah tami bangpatetnaw na maw, telah atipouh. Ahni ni Cathut ni na lungma teh na san a poe e camonaw nan ma aw atipouh. ");
INSERT INTO cth_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","A sannu hah a canaw hoi a tho teh a tabut. ");
INSERT INTO cth_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leah hai a canaw hoi a tho teh a tabut. Hahoi Rachel hoi Joseph hai a tho teh a tabut rawi. ");
INSERT INTO cth_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaw ni saringhu a kâhmo e naw pueng hah bangtelane, telah ati. Ahnimouh ni ka bawipa na minhmai kahawi ka hmu thai nahanelah ka sak e doeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Hatei Esaw ni ka nawngha, moikapap ka tawn, na tawn e teh nama hane ma tat leih, atipouh. ");
INSERT INTO cth_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jakop ni nahoeh bo, na minhmai kahawi ka hmawt pawiteh, pahren lahoi na poe e poehno hah na dâw pouh loe. Cathut mei hmu lah na mei ka hmu teh, kai lathueng na lung bout ahawi. ");
INSERT INTO cth_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Cathut ni na pahren teh, moi ka tawn doeh. Pahren lahoi kai ni na poe e naw hah na dâw pouh yaw kaw, telah ati. Hottelah pou a pasawt teh a dâw pouh. ");
INSERT INTO cth_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Hahoi Esaw ni kamthaw awh sei. Cet awh sei, na hmalah ka cei han atipouh. ");
INSERT INTO cth_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Hatei Jakop ni ahni koe na camonaw heh ek a naw rah. Tuhu hoi maitohu hoi kaimouh koe kaawm e naw teh ca ka cun e naw lah ao dawkvah, ka bawipa nang ni na panue doeh. Hnin touh mah karanglah ka hrui pawiteh be a due awh han doeh. ");
INSERT INTO cth_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ka bawipa, pahren lahoi na sannaw hmalah cet nateh, Seir mon dawk ka bawipa nang koe pha awh hoehroukrak, ka hmalah saring ka cet e naw, a cei thai awh e patetlah camonaw hai a cei thai awh e patetlah payai lahoi ka ceikhai han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaw ni kai koe kaawm e a tangawn kangna teh, tat awh lawisei, telah ati. Hatei, ahni ni bangmaw a panki. Ka bawipa minhmai kahawi na hmawt sak leih telah ati. ");
INSERT INTO cth_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hottelah, Esaw teh hat hnin vah Seir mon pâtam laihoi a ban. ");
INSERT INTO cth_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jakop teh Sukoth vah a cei teh, ama hanelah im a sak teh, a saringnaw hane haiyah impui a sak pouh. ");
INSERT INTO cth_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jakop teh lungmawngcalah paddanaram ram hoi Kanaan ram e kaawm sekem khopui koe a pha teh, khopui pui hmalah rim pui hah a sak. ");
INSERT INTO cth_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Hote rim a saknae hmuen teh sekem na pa Hamor capanaw koe tangka 100 touh hoi a ran e doeh, . ");
INSERT INTO cth_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Hawvah, khoungroe a sak teh, El Elohim Isarel telah min a phung awh. ");
INSERT INTO cth_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Leah canu Dinah Jakop e a yu ni a khe pouh e hah haw e ram dawk e tanglanaw hmu han a ngai dawkvah a pai. ");
INSERT INTO cth_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Hiv tami, haw e siangpahrang Hamor capa Shekhem ni a hmu, a man teh a ikhai teh a min a mathoe sak. ");
INSERT INTO cth_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","A hringnae teh Jakop canu Dinah koe dueng a lungthin ao, hote tangla teh a lungpatawpoung dawk lawk kahawi hoi dueng a pato. ");
INSERT INTO cth_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekhem ni a na pa Hamor koe, hote tangla hah kai hane yu lah na paluen pouh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jakop ni a canu Dinah hah Shekhem ni a khin sak tie hah a panue, a capanaw hah law vah saringhu hoi a i awh teh, a tho hoehroukrak teh Jakop duem ao. ");
INSERT INTO cth_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Shekhem e a na pa Hamor teh Jakop pato hanelah a cei. ");
INSERT INTO cth_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Jakop capanaw ni a thai awh tahma vah law hoi a ban awh. Jakop canu a ikhai e hoi, Isarelnaw thungvah kayayeirai sak hane hoi, sak hoeh hane kawi yonnae a sak dawkvah, a lungmathoe awh teh a lung pueng hoi a khuek awh. ");
INSERT INTO cth_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hateiteh, Hamor ni a pato teh ka capa Shekhem a hringnae teh na canu e lathueng dueng doeh ao, pahren lahoi a yu hanelah paluen sak leih. ");
INSERT INTO cth_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kâpaluen awh sei, na canunaw na paluen sak awh haw, kaimae canu hai paluen van awh. ");
INSERT INTO cth_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kaimouh koe na o awh vaiteh ram hai moi kalen lah ao doeh. Hivah awm awh nateh hno yawt awh nateh, moikapap tawnta awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekhem ni tangla e na pa hoi a thangroinaw koevah na pahren awh loe. Kai koe na dei awh e pueng na poe awh han. ");
INSERT INTO cth_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Aphu hoi poehno teh na hei awh e yit touh na poe awh han. Bangtelah nakunghai tangla teh yu lah na paluen sak awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Hateiteh, Jakop capanaw ni a canu Dinah a khinsak awh dawkvah, Shekhem hoi a na pa Hamor teh dumnae lahoi bout a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ahnimouh ni ahnimanaw koe vuensom ka a hoeh e naw koe ka canu na poe thai awh mahoeh. Bangkongtetpawiteh, hot hateh kaimouh hanelah min mathoenae doeh. ");
INSERT INTO cth_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hateiteh, hettelah lawk na kâkam awh torei dueng doeh, nangmae lawk hah ka hnâbawt awh ti, nangmouh koe e tongpa pueng hah vuensoma awh nateh kaimanaw patetlah awm awh. ");
INSERT INTO cth_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Hat toteh, kaimae canu na paluen sak vaiteh, kaimouh ni hai nangmae canunaw hai ka paluen van awh han. Hahoi nangmouh koe ka o awh vaiteh, miphun buet touh lah o awh han. ");
INSERT INTO cth_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Hateiteh, kaimae lawk na ngai awh hoeh lah, vuensom na a awh hoehpawiteh, ka canu ka la vaiteh ka cei awh han toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hahoi ahnimae lawk ni Hamor hoi Hamor capa Shekhem hah a lunghawi sak. ");
INSERT INTO cth_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Hottelah thoundoun ni Jakop canu hah a ngai lawi vah, hothateh moikasaw e lah pouk laipalah tang a sak, ahni teh a na pa imthungnaw thung dawkvah bari poung e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor hoi a capa Shekhem ni a kho kalupnae longkha koe a pha awh teh, kho thung e taminaw hoi a kâpato awh. ");
INSERT INTO cth_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hote taminaw hoi maimouh hoi karoumcalah hoi kho a sak awh. Hatdawkvah hete ram dawk kho a sak awh vaiteh, hivah hno yawt awh naseh. Bangkongtetpawiteh, ahnimouh han ram akawpoung doeh. A canunaw hah yu lah paluen awh vaiteh, maimae canunaw hai yu lah paluen van awh naseh. ");
INSERT INTO cth_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Hateiteh, miphun buet touh lah o awh thai nahan, hettelah lawkkam awh torei dueng doeh ahnimouh ni hnâ na bo khai hanelah ao, vuensom ka a awh e patetlah mamouh thung e tongpa pueng hai vuensoma awh sei. ");
INSERT INTO cth_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ahnimae saringnaw, hnopainaw hoi a tawnta e naw pueng teh, maimae lah be kaawm han nahoehmaw. Ahnimae lawk teh hnâbawtkhai awh sei. Hottelah hoi maimouh koe kho a sak awh han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hamor hoi a capa Shekhem ni a dei e hah kalupnae rapan koe kâen ka tâcawt e pueng ni a hnâbokhai awh teh, longkha koe kâen ka tâcawt e tongpa pueng teh vuensom koung a a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Hahoi hettelah doeh. A apâthum hnin a pataw poungnae dawk Jakop capanaw thung hoi kahni touh e, Dinah e a thangroi Simeon hoi Levih ni amamouh roi e tahloi a sin roi teh arulahoi khopui a tuk roi teh tongpa pueng he a thei roi. ");
INSERT INTO cth_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamor hoi a capa Shekhem hai tahloi hoi a thei awh. Shekhem im dawk e Dinah hah a tâcokhai awh teh a cei awh. ");
INSERT INTO cth_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jakop capanaw ni a thei awh e naw koe a pha awh van teh, a tawncanu a kamhnawng sin dawkvah khopui teh a raphoe awh. ");
INSERT INTO cth_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","A tuhunaw, maitohunaw, lahunaw hoi amamouh kho e kaawm e hnopainaw hah a la pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","A hnopainaw, a canaw hoi a yunaw imthungkhu kaawm e pueng hah he a lawp awh teh be a raphoe awh. ");
INSERT INTO cth_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jakop ni Simeon hoi Levih koevah nangmanaw ni hete ram dawk e taminaw hoi Kanaannaw hoi Periznaw kecu dawkvah, kai heh min mathoenae na phu sak teh, lung na mathoe sak. Kai ka younca navah kai taranlahoi kamkhueng awh vaiteh, kai hoi ka imthungnaw hah na thet awh vaiteh, he na pahma awh han doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Hateiteh, ahnimouh ni kaimae tawncanu heh, kâyawt e napui patetlah a sak han na maw telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Cathut ni Jakop koevah, thaw nateh Bethel kho vah cet nateh hawvah awm, na hmau Esaw koehoi na yawng nah nang koe ka kamnuek e Cathut hanelah thuengnae khoungroe hah sak telah ati. ");
INSERT INTO cth_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jakop ni a imthung hoi ama koe kaawm e tami pueng koe, nangmouh koe Jentelnaw e cathut kaawm e hah tâkhawng awh, kamthoung awh, na khohna hah kâthung awh. ");
INSERT INTO cth_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bethel vah luen awh sei. Rucatnae kâhmo awh lahun navah, na pathung teh ka cei nah tangkuem koevah, na ka awmkhaikung Cathut hanelah khoungroe ka sak han ati. ");
INSERT INTO cth_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hottelah hoi miphun alouke cathutnaw e a kut dawk e kaawm e pueng hoi a hnânaw dawk a pacap awh e naw hah Jakop a poe awh. Jakop ni Shekhem teng e kathen kung rahim vah a hro awh. ");
INSERT INTO cth_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","A cei awh teh, Cathut takinae hah a tengpam e khonaw pueng dawk ao teh Jakop capa hah pâlei awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jakop teh ama koe kaawm e naw pueng hoi Kanaan ram Luz vah a pha awh (Luz teh Bethel doeh). ");
INSERT INTO cth_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Hawvah khoungroe a sak teh, haw e hmuen teh El Bethel telah ati. Bangkongtetpawiteh a hmau koehoi a yawng lahun navah hawvah ahni koe Cathut a kamnue. ");
INSERT INTO cth_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebekah ka awmkhaikung Deborah hah a due teh, khoungroe rahim e bengkengkung rahim vah a pakawp awh. Hottelah hoi hote bengkeng e a min teh Allon Bakuth telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jakop teh Padam Aram ram lahoi a ban toteh, ahni koe Cathut bout a kamnue teh yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Cathut ni ahni koe na min teh Jakop eiteh, na min teh Jakop telah tet awh mahoeh toe, na min teh Isarel ti han toe telah ati. Hottelah hoi a min hah Isarel telah ati. ");
INSERT INTO cth_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Hahoi Cathut ni ahni koevah, kai teh Athakasaipounge Cathut lah ka o. Canaw pungdaw nateh, nange miphun dawk hoi siangpahrangnaw a tâco han. ");
INSERT INTO cth_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Abraham hoi Isak koevah, ka poe e ram heh nang na poe, na catounnaw totouh ka poe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hattoteh Cathut ni ahni a patonae hmuen koehoi Jakop teh a luen takhai. ");
INSERT INTO cth_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","A patonae hmuen koe Jakop ni talung a ung. A ung e teh talung doeh. A lathueng vah nei thuengnae hah a awi teh, satui hai a van vah a awi. ");
INSERT INTO cth_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Cathut ni a patonae hmuen hah Bethel telah min a phung. ");
INSERT INTO cth_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Bethel hoi a cei awh teh, Ephrath a pha awh nahanelah ahlapoung. Rachel camo o hane a pataw teh pueng hoi patawnae a khang. ");
INSERT INTO cth_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Hahoi, hettelah doeh. A patawnae a khang lahun nah camo kaawm sak e ni taket hanh ca tongpa alouke na khe han dawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hahoi, a muitha a tâco tawmlei vah, a min hah Benoni ati teh, a na pa ni Benjamin telah a phung. ");
INSERT INTO cth_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel a due teh Epharath ceinae lamthung dawk a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","A tangkom van vah Jakop ni talung a ung teh, hothateh nout nahanelah Rachel pakawpnae tangkom lah ao. ");
INSERT INTO cth_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isarel teh pou bout a cei teh, Mikdaleder imrasang hloilah rim a sak. ");
INSERT INTO cth_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Hahoi, Isarel teh haw e ram dawk ao lahun navah, Reuben ni a na pa e ado Bilhah a ikhai e hah Isarel ni a thai. ");
INSERT INTO cth_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Jakop capanaw teh 12 touh a pha awh. Leah capanaw thung dawk Reuben teh Jakop e camin la ao teh Simeon, Levih, Judah, Issakhar hoi Zebulun tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rachel capanaw teh Joseph hoi Benjamin doeh. ");
INSERT INTO cth_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rachel e a san Bilhah capanaw teh Dan hoi Naphtali doeh. ");
INSERT INTO cth_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leah e sannu Zilpah canaw teh Gad hoi Asher doeh. Hetnaw teh Paddanaram Jakop ni khe e ca tongpanaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jakop ni Mamre Kiriatharba (Hebron) e a na pa Isak hoi Abraham onae koe a pha. ");
INSERT INTO cth_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak a hringyung teh kum 180 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Isak ni hnukteng a kâha a phout teh a hnin pakhit lahoi a due. A due toteh a huikonaw koe pakawp e lah ao van teh a capa Esaw hoi Jakop ni a pakawp roi. ");
INSERT INTO cth_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hetnaw heh Esaw (Edom doeh) e catounnaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaw ni Kanaan napui thung dawk e, Hit tami Elon canu Adah hoi Hit tami Zibeon e canu Anah canu Oholibamah hoi, ");
INSERT INTO cth_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ishmael canu Basemath, Nebaioth tawncanu hah a yu lah a la. ");
INSERT INTO cth_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah ni Esaw teh, Eliphaz a khe pouh teh, Basemath ni Reuel hah a khe. ");
INSERT INTO cth_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamah ni hai Jeush, Jalam, hoi Korah hah a khe. Hotnaw teh Esaw capanaw, Kanaan kho vah a khe e naw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaw ni a yu, a ca tongpanaw napuinaw, a im dawk kaawm e pueng, Kanaan kho vah a hmu e hnopai pueng hah a ceikhai teh, a nawngha Jakop koehoi a tâco teh ram buet touh koe a cei. ");
INSERT INTO cth_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bangkongtetpawiteh, a tawn e hno moi apap dawkvah, cungtalah awm thai awh hoeh toe. A saringnaw kecu dawk imyin lah onae ni cawng awh hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hottelah Esaw teh Seir mon dawk kho a sak. Esaw teh Edom doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hetnaw heh Seir mon e Edomnaw kakhekung Esaw catounnaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hetnaw heh Esaw catounnaw doeh, a yu Adah capa Eliphaz, a yu Basemath capa Reuel. ");
INSERT INTO cth_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphaz capanaw teh Teman, Omar, Zepho, Gatam hoi Kenaz tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna teh Esaw capa Eliphaz e a yudo lah ao teh, Eliphaz hanlah Amalek a sak pouh. Hotnaw teh Esaw e yu Adah capanaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Hahoi, Reuel capanaw teh Nahath, Zerah, Shammah, Mizzah lah ao awh teh, Esaw yu Basemath capanaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaw yu, Zibeon canu Anah canu Oholibamah capanaw lah ao awh teh, Esaw hanelah Jeush, Jalam, Korah a sak pouh. ");
INSERT INTO cth_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaw catounnaw thung dawk khobawinaw teh, Esaw e camin Eliphaz capa, khobawi Teman, khobawi Omar, khobawi Zepho, khobawi Kenaz, ");
INSERT INTO cth_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","khobawi Korah, khobawi Gatam, khobawi Amalek tinaw lah ao awh teh, ahnimanaw teh Edom kho e Eliphaz koehoi khe e khobawinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hetnaw teh Esaw capa Reuel capanaw doeh. Khobawi Nahath, khobawi Zerah, khobawi Shammah, khobawi Mizzah tinaw lah ao awh teh, ahnimanaw teh Edom kho e Esaw yu Basemath capa Reuel e khobawinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esaw yu Oholibamah e capanaw hai khobawi Jeush, khobawi Jalam, khobawi Korah tinaw ao awh teh, ahnimanaw teh Esaw yu, Anah canu, Oholibamah capanaw khobawinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hetnaw heh Edom tie Esaw capa khobawinaw doeh ");
INSERT INTO cth_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hetnaw teh Hor tami Seir capa, hote ram dawk kaawmnaw doeh. Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO cth_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, Dishan tinaw teh Edom ram e Seir capa Hor koehoi ka khe e khobawinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan capa teh Hor hoi Heman lah ao teh, Timna teh Lotan e a tawncanu doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal capanaw teh Alvan, Manahath, Ebal, Shepho, Onam doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon capanaw teh Aiah hoi Anah doeh, Anah teh a na pa Zibeon e la a khoum navah kahrawng e tuikhu kahmawtkung doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah capanaw teh Dishon hoi Anah canu Oholibamah tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Hahoi Dishon capanaw teh Hemdan, Eshban, Ithran hoi Keran doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer capanaw teh Bilhan, Zaavan hoi Akan doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan capanaw teh Uz hoi Aran doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Khobawinaw lah khobawi Lotan, khobawi Shobal, khobawi Zibeon, khobawi Anah. ");
INSERT INTO cth_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","khobawi Dishon, khobawi Ezer, khobawi Dishan lah ao awh teh, ahnimanaw teh Seir kho vah khobawi lah kaawm khobawinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hetnaw teh siangpahrang ni Isarel miphun a uk hoehnahlan e Edom siangpahrangnaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor capa Bela ni Edom vah siangpahrang a tawk navah, khopui min teh Dinnabah doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela a due hnukkhu, Bozrah tami Zerah capa Jobab ni a yueng lah a uk. ");
INSERT INTO cth_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab a due hnukkhu, Teman kho e Husham ni a uk. ");
INSERT INTO cth_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham a due hnukkhu, Bedad capa Hadad, Moab law vah Midiannaw kathetkung ni a yueng lah a uk, a khopui min te Avith doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad a due hnukkhu, ahni yueng lah Masrekah tami Samlah ni a uk. ");
INSERT INTO cth_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah a due hnukkhu, ahni yueng lah, tui teng Rehoboth tami Saul ni a uk. ");
INSERT INTO cth_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saul a due hnukkhu, ahni yueng lah Akbor capa Baalhanan ni a yueng lah a uk. ");
INSERT INTO cth_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akbor capa Baalhanan a due hnukkhu, ahni yueng lah Hadad ni a uk. Hatnavah khopui min teh Pau doeh. Hahoi, a yu min teh Mehetabel, Mezahab canu Matred canu doeh. ");
INSERT INTO cth_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hahoi hetnaw heh a imthung hoi amamouh hoi, min paruinae patetlah Esaw capa khobawinaw e minnaw teh: khobawi Timna, khobawi Alvah, khobawi Jetheth, ");
INSERT INTO cth_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","khobawi Oholibamah, khobawi Elah, khobawi Pinon, ");
INSERT INTO cth_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","khobawi Kenaz, khobawi Teman, khobawi Mibzar, ");
INSERT INTO cth_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","khobawi Magdiel, khobawi Iram doeh. Hetnaw teh a tawn awh e ram dawkvah, a khosaknae lahoi Edom catoun khobawinaw doeh. Esaw teh Edom miphun kakhekung doeh. ");
INSERT INTO cth_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jakop teh a na pa imyin lah a onae Kanaan ram dawk kho a sak. ");
INSERT INTO cth_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Hethateh Jakop catoun e lairui doeh. Joseph teh a kum 17 touh a pha nah a hmaunaw hoi saringnaw a khoum awh. Ahni teh a camo rah dawkvah, a na pa e yu Bilhah hoi Zilpah capanaw koevah ao, hahoi Joseph ni hnokahawi hoeh a sak awh e kamthang kathout hah a na pa koe ouk a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Isarel ni Joseph teh a matawng nah a khe e lah ao dawkvah, a canaw pueng hlak a lungpataw hnawn, angkidung a phun aloukcalah a khui pouh teh a poe. ");
INSERT INTO cth_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","A na pa ni a hmaunaw hlak a lungpataw hnawn tie hah a panue awh. Hottelah hoi ahni teh, hmawt ngai awh hoeh. Lawk kahawi hoi hai pato ngai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph ni mang a sak teh a hmaunaw koe a dei pouh dawkvah, hoe hmawt ngai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ahni ni ahnimanaw koe pahren lahoi mang ka sak e hah thai awh haw. ");
INSERT INTO cth_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Law vah cabong hah a thaw awh teh kaie cabong hai a thaw teh a kangdue. Hahoi thai awh haw, nangmae cabongnaw ni a kalup awh teh, kaie cabong hah a bawk awh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","A hmaunaw ni ahni koevah, nang ni kaimouh na uk katang han na maw. Nang heh kaimae lathueng vah kâ na tawn han na maw, telah atipouh awh. Hottelah hoi a mang hoi a dei e lawk kecu dawkvah, hoe a hmuhma awh. ");
INSERT INTO cth_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Hahoi mang alouke e bout a sak teh, a hmaunaw koevah bout a dei pouh. Thai awh haw, mang bout ka tawn. Kanî hoi thapa hoi âsinaw 12 touh ka hmalah be a tabut awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","A na pa hoi a hmaunaw koe a dei pouh navah, a na pa ni a yue teh, mang na sak e teh bangpatete mang han na maw. Kai hoi na manu hoi na hmaunaw ni na hmalah ka tabut han na maw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","A hmaunaw ni ahni teh a ut awh. Hateiteh, a na pa ni hno kaawm e hah a lung dawk a pâkuem. ");
INSERT INTO cth_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","A hmaunaw teh Shekhem vah a na pa e saring khoum hanelah a cei awh. ");
INSERT INTO cth_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Isarel ni Joseph koevah na hmaunaw ni Shekhem doeh saring a khoum awh khe, tho haw, ahnimouh koe na patoun han telah ati. Ahni ni na patoun yawkaw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","A na pa ni ahnimouh koe cet nateh na hmaunaw hah a dam awh maw, saringnaw a dam maw, panue hanelah kamthaw haw, haw e kamthang kai koe bout na dei pouh han telah ati. Hottelah hoi Hebron tanghling koehoi a patoun teh Shekhem vah a pha. ");
INSERT INTO cth_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Law dawk voutsout a kâhlai e hah tami buet touh ni a hmu teh ahni ni, bangmaw na tawng telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ahni ni, ka hmaunaw doeh ka tawng pahren lahoi saringhu a khoumnae na dei pouh haw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ahni ni hote hmuen koehoi yo a cei awh toe. Dothan vah cet sei ati awh e hah ka thai, telah ati. Hottelah hoi Joseph ni a hmaunaw teh a pâlei teh Dothan vah a hmaunaw a hmu. ");
INSERT INTO cth_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ahnimouh ni ahlapoungnae koehoi a hmu awh teh, ahni koe a pha hoehnahlan vah, ahni thei nahane lah a kâdei awh toe. ");
INSERT INTO cth_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Thai awh haw, mang ka sak e tami a tho toe. ");
INSERT INTO cth_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Tho awh thei awh vaiteh, moimatheng ni a kei telah tet pouh awh sei. Hahoi a mangnaw teh bangne tie hah panue awh han telah buet touh hoi buet touh lengkaleng a kâti awh. ");
INSERT INTO cth_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Hateiteh, Reuben ni a thai teh ahnimae kut dawk hoi a rungngang teh, thet lah thet awh hanh sei, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Hateiteh, Reuben ni a kut thung hoi a rungngang teh a na pa koe a bankhai thai nahan, thet awh hanh, kahrawng e tangkom thung pabawt awh nateh na kut teh tha awh hanh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Joseph ni a hmaunaw koe a pha toteh, angkidung em kaawm e hah a rading pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","A ceikhai awh teh tangkom dawk a pabo awh. Tangkom dawk tui awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Hottelah rawca ca hanelah, a tahung awh. Hahoi a radoung awh teh, Ishmael kahlawng ka cet e Gilead ram lahoi amamae kalauk hoi hmuitui hoi, thing tapi, murah phu e hoi Izip ram lah cei hanelah kamthawnaw hah a tho awh. ");
INSERT INTO cth_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Judah ni a hmaunawnghanaw koe maimae nawngha thei awh teh, a thipalawng e paphat awh pawiteh, bangmaw cungkeinae kaawm han. ");
INSERT INTO cth_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tho awh, a lathueng kut tha laipalah Ishmaelnaw koe yawt awh sei. Bangkongtetpawiteh, ahni teh nawngha maimae misa hoi kâkuen e doeh, telah ati teh, a hmaunawnghanaw ni a hnâ rip a bo khai awh. ");
INSERT INTO cth_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hottelah hoi Midian hno kayawtnaw teh a tho awh teh, Joseph teh tangkom dawk hoi a rasa awh teh, Ishmaelnaw koe tangka 20 touh lah a yo awh. Hahoi Joseph teh Izip ram lah a ceikhai awh. ");
INSERT INTO cth_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Hottelah hoi Reuben teh tangkom koe a tho teh, khenhaw! Joseph teh tangkom thung la awm hoeh toe, hat toteh a khohna hah a ravei. ");
INSERT INTO cth_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hahoi a hmaunawnghanaw koe a cei teh, camo awm hoeh toe. Kai teh na lane ka cei han toung telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Joseph e angkidung hah a la awh teh hmaetan a thei awh teh a thi dawk a ranup awh. ");
INSERT INTO cth_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Em la e angkidung hah a patawn awh teh, a na pa koe a poe awh. Hethateh ka hmu awh e doeh. Na capa e angkidung na ou, khenhaw! hottelah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","A na pa ni a nout teh, ka capa e angkidung doeh. Moimatheng buetbuet touh ni a kei toung hah tayaw. Joseph hah vekrasen lah a hruek toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Hottelah hoi Jakop teh a khohna a ravei teh, buri a kâkhu laihoi a hnin moikasaw lah a capa hah a khui. ");
INSERT INTO cth_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","A capanaw pueng hoi a canunaw pueng hah ahni a lungpahawi hanelah a thaw awh, hateiteh, a na pa ni a lungpahawinae ngai pouh hoeh. Khui nalaihoi phuen koe ka capa koevah ka cei han toe telah ati. Hottelah hoi a na pa teh ahni a pouk lawi a khui a ka. ");
INSERT INTO cth_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midiannaw ni Joseph teh Izip ram dawk a kâenkhai awh teh, Faro kut rahim e imkaringkung Potiphar koevah a yo awh. ");
INSERT INTO cth_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hatnae tueng dawkvah, Judah teh a hmaunawngha koehoi a cei teh, Adullam tami Hirah koevah ao. ");
INSERT INTO cth_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Judah ni haw vah, Kanaan tami Shua canu hah a hmu. Ahni hah a paluen teh a ikhai. ");
INSERT INTO cth_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Camo a vawn teh ca tongpa a khe. Judah ni a min lah Er a phung. ");
INSERT INTO cth_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Camo bout a vawn teh ca tongpa bout a khe. A manu ni a min lah Onan telah a phung. ");
INSERT INTO cth_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ca tongpa alouke bout a khe teh, a min lah Shelah telah a phung. Hote ca tongpa a khe lahun navah, Judah teh Kezib vah ao. ");
INSERT INTO cth_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judah ni a camin Er hah a yu a paluen pouh teh, a min teh Tamar doeh. ");
INSERT INTO cth_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Hateiteh, Judah e camin teh BAWIPA e mithmu vah tamikathout lah ao dawkvah, BAWIPA ni ahni teh a thei. ");
INSERT INTO cth_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Judah ni Onan koevah, na hmau e yu hah ipkhai nateh, na hmau e cati hah pout hoeh nahanlah sak pouh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan ni a canaw hah mae ca lah awm mahoeh tie a panue dawkvah, a hmau e a yu a ikhai navah, a ca khe hoeh nahanlah alawilah atui yout a tâco sak. ");
INSERT INTO cth_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","A sak e hno ni BAWIPA a lunghawi sak hoeh dawkvah, Onan hai a thei. ");
INSERT INTO cth_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Judah ni a langa Tamar koevah, ka capa Shelah heh a cue hoehroukrak na pa im dawk lahmai lah awm ei, telah hoehpawiteh, ahni hai a hmaunaw patetlah a due payon han doeh telah ati. Tamar ni a cei teh a na pa im vah ao. ");
INSERT INTO cth_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Atueng moi a ro hnukkhu, Judah e yu Shua canu teh a due. Judah teh a lungpahawi hnukkhu, Timnah kho dawk e tumuen kangawnaw koe vah, amae a hui Adullam tami Hirah hoi reirei a ceitakhang roi. ");
INSERT INTO cth_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","A langa Tarmar koevah, na pa teh tu muen ngaw hanelah Timnah vah cei hane a kâcai telah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ahni ni a lahmainae hni hah a rading teh, a minhmai a ramuknae hoi a kâramuk, a tak a kâyo teh Timnah kho longkha koelah a tahung. Bangkongtetpawiteh, Shelah teh a cue eiteh, a na pa ni a yu lah paluen pouh ngai hoeh. ");
INSERT INTO cth_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah ni a hmu toteh, a minhmai a kâramuk dawkvah, kâyawt e lah a pouk. ");
INSERT INTO cth_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Hottelah hoi lam teng e napui a onae hah a pâtam teh, tho haw pahren lahoi rei ip roi sei telah ati. Bangkongtetpawiteh, a langa tie panuek hoeh. Napui ni na ipkhai pawiteh bangmaw na poe han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ahni ni saringhu thung e hmaeca na patawn han telah ati, Hottelah hoi napui ni hot hah na patawn hoehnahlan vah na pâhung hane kawi na poe han na ou, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ahni ni bangmaw ka hung han telah telah ati. Napui ni na min na thutnae, arui hoi na sin e na sonron telah ati. Hottelah hoi a poe teh a ikhai, ahni teh camo a vawn. ");
INSERT INTO cth_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","A thaw teh a minhmai ramuknae a hawng teh a lahmainae khohna hah bout a kho. ");
INSERT INTO cth_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah teh napui koe hung e hno hah a ratang hanelah a hui Adullam koe vah hmaeca hah a patawn. Hateiteh, ahni ni napui hah hmawt hoeh. ");
INSERT INTO cth_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hottelah hoi haw e hmuen koe kaawm e taminaw koe lam teng e Enaim tak ka kâyawt e napui hah nâmaw ao telah a pacei, ahnimouh ni hie hmuen koe tak ka kâyawt e awm hoeh telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Judah koe a ban teh, ahni teh ka hmawt thai hoeh. Haw e Taminaw ni hie hmuen dawk tak ka kâyawt e awm boihoeh telah ati awh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah ni lat awh yawkaw naseh, hottelah hoehpawiteh, yeiraipo payon vaih, khenhaw! hmaeca heh na patawn ei, ama na hmawt ka lawn hoeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Thapa yung pâthum hnukkhu vah ahnimouh ni Judah koe na langa Tamar teh kâyo hloilah cata a phu telah a dei pouh awh. Judah ni alawilah tâcawtkhai awh nateh hmaisawi e lah awm naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","A tâcokhai awh lahun navah, Tamar ni hete hno katawnkung koe hoi nahoehmaw camo ka vawn telah a na pa koe Tami a patoun. Napui ni vah pahren lahoi hete min thutnae hoi arui hoi sonronnaw heh, apie ne, kahawicalah khenhaw! telah ati. ");
INSERT INTO cth_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah ni vah, hnopainaw teh amae lah ao tie a panue teh, ahni teh kai hlak atanghnawn toe. Bangkongtetpawiteh ka capa Shelah hane a yu lah ka lat pouh kalawn hoeh toe telah ati. Hahoi Judah ni ahni teh bout ipkhai hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Hahoi a vawn a pataw lahun navah, camo im dawk camo samphei roi e ao. ");
INSERT INTO cth_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Camo a khe navah, capa buet touh ni a kut a tâco sak. Camo ka khesakkung ni hetheh a hmaloe ka khe e telah a kut dawk a kuet teh hlangpawi a yeng pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","A kut hah bout a kâhno torei teh, pouk laipalah a nawngha hah a khe. Camo ka khe sak e naw ni, bangkongmaw khe na hanelah namahoima na sak, telah ati awh. Hatdawkvah, a min lah Perez telah a phung awh. ");
INSERT INTO cth_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hathnukkhu a hmau e a kut dawk hlangpawi yeng e a khe teh a min lah Zerah telah a phung. ");
INSERT INTO cth_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph teh Ishmael taminaw koe Izip ram a thokhai awh teh, Izip siangpahrang Faro kut rahim imkaringkung lah kaawm e Potiphar ni a ran. ");
INSERT INTO cth_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","BAWIPA teh Joseph koe ao teh, ahni teh a lam ka cawn e tami lah ao teh Izip tami a bawipa im vah ao. ");
INSERT INTO cth_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","A bawipa ni BAWIPA teh ahni koe a o, a hnosak tangkuem dawk a lamcawn tie hah a panue. ");
INSERT INTO cth_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph teh a bawipa e a lungyouk lah thaw ouk a tawk. A bawipa ni a imkaringkung kacue lah a ta teh, a tawn e hnonaw pueng ahnie kâtawnnae rahim koung a ta pouh. ");
INSERT INTO cth_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Hahoi, imkaringkung lah a ta hnukkhu, BAWIPA ni Joseph pawlawk hoi Izip imthungkhu hah yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","A tawn e pueng hah Joseph kut dawk be a ta pouh teh, a ca e vaiyei hloilah teh ahni koe kaawm e hnonaw pueng hah be a poe. Joseph teh a tungtang kahawi e lah ao teh a mei hai a hawi. ");
INSERT INTO cth_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Hathnukkhu, a bawipa e yu ni Joseph hah a noe teh, na ipkhai leih ti hoi pou a pasawt. ");
INSERT INTO cth_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Hatei ngai pouh hoeh. A bawipa e yu koevah, khenhaw! ka bawipa ni hete im dawkvah, bang hno maw kaawm tie panuek hoeh, a tawn e naw pueng ka kut dawk koung a ta. ");
INSERT INTO cth_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hete im dawk kai hlak ka len e apihai awm hoeh. A yu na tho patetlah nang hloilah kai hane a pasoung hoeh e banghai awm hoeh. Hatdawkvah, hethloilah kalen e thoenae hoi yonnae heh Cathut taranlahoi bangtelamaw khuet ka sak han vaw, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hahoi, hnin touh hnukkhu hnin touh, Joseph hah a pasawt nakunghai a ikhai hane teh ngai pouh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Hatei, a hnin hnin touh teh, Joseph imthungkhu thaw tawk hanelah a kâen teh, hatnae tueng dawk imthungkhu tami buet touh hai la awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Hahoi teh, napui ni na ipkhai leih telah a angki dawk a kuet pouh teh, a kut dawk angki pak rading teh alawilah a yawng takhai. ");
INSERT INTO cth_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Hahoi teh, a angki a kut dawk pak a rading teh a yawng takhai tie a panue toteh, ");
INSERT INTO cth_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","a im kaawmnaw hah a kaw teh, khenhaw! kai na kaya sak hanelah hete Hebru tami ni kai na yonkhai hanelah imthungkhu na kâen sin teh thayung hoi ka hram pouh. ");
INSERT INTO cth_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Hahoi, ka lawk hoi thayung hoi ka hram toteh, kama koe a angki pak a rading teh a yawng takhai telah ati. ");
INSERT INTO cth_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","A bawipa a tho hoehroukrak a hnicu teh ama koevah pou a hruek. ");
INSERT INTO cth_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hahoi teh a vâ koe telah a dei pouh. Hete Hebru tami san kai koe na thokhai e heh, yeiraipo sak hanelah hoi kai koe na kâen sin. ");
INSERT INTO cth_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Hahoi, lawk hoi tha hoi ka hram tahma vah, a khohna a yawng takhai telah ati. ");
INSERT INTO cth_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Hahoi, a bawipa koe na san ni hettelah na sak tie a yu ni a dei e lawk hah a thai toteh a lungkhuek. ");
INSERT INTO cth_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Hottelah a bawipa ni Joseph a ceikhai teh thongim siangpahrang ni tami khik katek hoi ouk tanae thongim thung a paung awh. ");
INSERT INTO cth_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Hateiteh, BAWIPA teh Joseph koe ao teh, a lathueng vah lungmanae a tawn teh thongim ka ring e hmalah minhmai kahawi a hmu sak. ");
INSERT INTO cth_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Hahoi teh, thongim karingkung ni thongkabawtnaw pueng hah Joseph kut dawk koung a ta teh, haw e sak e naw teh Joseph e tawk sak e lah koung a coung. ");
INSERT INTO cth_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","BAWIPA teh ahni koe ao teh, a lamcawn sak dawkvah, thongim karingkung ni Joseph e kâtawnnae rahim kaawmnaw pueng hah banghai khen awh hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hathnukkhu hoi teh, Izip siangpahrang misur kapoekung hoi vaiyei kasakkung roi teh Izip siangpahrang koe lungyouk hoeh e lah ao roi. ");
INSERT INTO cth_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Hatdawkvah, Faro teh a sannaw kahrawikung kacue kahni touh, misur kapoekung kacue hoi vaiyei kasakkungnaw dawk kacuepoung koe a lungphuen. ");
INSERT INTO cth_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Hottelah ama karingkung Joseph a bonae thongim koe a pabo awh. ");
INSERT INTO cth_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Im karingkung kacue ni ahnimouh teh Joseph kut dawk hnin moikasaw lah a poe teh thaw a tawk roi. ");
INSERT INTO cth_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Thongim thung katek laihoi kaawm roi e Izip siangpahrang misur kapoekung hoi vaiyei kasakkung roi teh tangmin buet touh dawk mang alouklouke reirei a sak roi. ");
INSERT INTO cth_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","A tangtho vah Joseph teh ahnimouh koe a kâen van teh, a kâhmo, hahoi a khet navah a minhmai a mathoe roi. ");
INSERT INTO cth_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Hottelah Faro e im karingkung bawipa im e thongim ka bawt e tami koevah, bangkongmaw sahnin na minhmai a mathoe roi telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ahnimouh roi ni mang ka sak roi, ka deicaikung apihai awm hoeh telah ati roi. Joseph ni ahni koe mang dei thainae teh Cathut e nahoehmaw. Pahren lahoi na dei pouh haw atipouh. ");
INSERT INTO cth_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Hottelah misur kapoenaw kahrawikung ni a mang teh Joseph koe a dei pouh. Ahni koe ka mang lavah khenhaw! ka hmalah misurkung a la o. ");
INSERT INTO cth_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Misurkung dawkvah a cakang kathum touh ao. Ka dawn e patetlah ao teh, a peinaw hah a pei. Hote a peinaw ni ka hmin e misur paw a tâco sak. ");
INSERT INTO cth_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Hahoi Faro manang hah ka kut dawk ao teh, misur paw hah ka khi. Faro e manang dawk kasu teh manang hah Faro kut dawk ka poe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph ni ahni koe hettelah han doeh. A cakang kathum touh e teh, hnin thum touh doeh. ");
INSERT INTO cth_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Hnin thum touh thung Faro ni na tawm takhang vaiteh, na tawk e thaw hah bout na tawk sak han. Hottelah misur kapoekung lah na o navah, ouk na poe e patetlah Faro manang hah a kut dawk bout na poe han. ");
INSERT INTO cth_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Hatei, onae hmuen kahawi dawk na pha navah, kai na pahnim hanh lah a. Pahren lahoi na pahrennae hah kai koehai kamnuek sak. Faro koe kaie konglam na dei pouh van lah a, hete im dawk hoi na tâcawt sak van loe. ");
INSERT INTO cth_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bangtelah tetpawiteh, Hebru taminaw e ram thung hoi tami ni arulahoi na paru awh e doeh. Hete ram thung dawk hoi thongim thung a thung patuen lah bo nahan hai banghai ka sak hoeh ei nan heh ma telah ati. ");
INSERT INTO cth_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Vaiyei ka sak e ni hete deicainae hah ahawi tie a panue toteh, Joseph koevah, kai hai mang ka sak van. Khenhaw! ka lû dawk ka pangaw e takho yung thum touh ao. ");
INSERT INTO cth_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Avanlah kabang e takho dawk, Faro hanlah kahawi e vaiyei phunkuep ao. Hahoi ka lû dawk ka thueng e takho dawk e vaiyei hah tava ni a la ca telah ati. ");
INSERT INTO cth_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph ni, takho yung thum touh teh hnin thum touh doeh, ");
INSERT INTO cth_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Hnin thum touh thung Faro ni na lû tâtueng vaiteh, thing dawk bang e lah na o han. Hahoi tavanaw ni na moi hah a ca han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Hahoi, apâthum hnin Faro khenae hnin a pha toteh, ahni ni a sannaw pueng hanelah buvennae pawi a sak pouh. Hahoi misur kapoekung hoi vaiyei kasakkung naw e lû teh, a tawmrasang. ");
INSERT INTO cth_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Joseph ni ahnimouh koe a deicai pouh e patetlah misur kapoekung teh amae tawk tangcoung e misur hah bout a poe teh, Faro kut dawk manang hai bout a poe. ");
INSERT INTO cth_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Vaiyei kasakkung teh thing dawk a vo awh. ");
INSERT INTO cth_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Hatei, misurtui kapoenaw kahrawikung ni Joseph hah panuek laipalah yout a pahnim. ");
INSERT INTO cth_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kum hni touh a loum hnukkhu, Faro ni mang a sak teh, thaihaw, palang rai vah a kangdue. ");
INSERT INTO cth_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","A meikahawi ni teh kathâw e maitomanu hah tui thung hoi a tâco teh pho um vah apa. ");
INSERT INTO cth_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Hahoi khenhaw! maitomanu sari touh, a meikahawi hoeh ni teh kamsoe e hah tui thung hoi a tâco van teh palang rai vah kangdout e maitomanu teng vah a kangdue. ");
INSERT INTO cth_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Maitomanunaw a meikahawihoeh ni teh kamsoe e naw ni a meikahawi ni teh kathâw e naw hah koung a ca awh. Hahoi teh Faro teh vak a kâhlaw. ");
INSERT INTO cth_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Hahoi bout a i teh mang bout a sak. Khenhaw! cakung buet touh dawk kahawi ni teh kalen e cavui sari touh a tâco. ");
INSERT INTO cth_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hahoi khenhaw! kathoengca ni teh Kanîtholae kahlî ni remke lah a hmang e cavui sari touh bout a tâco. ");
INSERT INTO cth_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Cavui kathoengcae sari touh ni, cavui kalen ni teh kahawi e sari touh hah koung a payawp awh. Faro vak a kâhlaw teh khenhaw! mang lah ao. ");
INSERT INTO cth_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","A tangtho torei, a muitha a lungpuen teh tami a patoun. Izip ram e mitpaleikathoumnaw hoi tami lungang pueng a kaw teh Faro ni a mang hah a dei pouh. Hahoi Faro hanelah ka deicai thai e buet touh boehai awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Hatnavah misurtui kapoenaw kaukkung ni Faro koevah, sahnin ka yonnae ka kâpanue. ");
INSERT INTO cth_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","A sannaw koevah, Faro a lungkhuek teh karingkungnaw kaukkung im vah kai hoi vaiyei kasakkungnaw kaukkung thongim ka bo roi navah, ");
INSERT INTO cth_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","mang reirei ka sak roi. Kaimouh roi e mang hah deingainae kâvan hoeh e doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hawvah kaimouh karingkung e san Hebru tami buet touh ao teh mang hah ka dei pouh roi. Ahni ni mang heh a deicai teh ka mang roi e patetlah a deicai van. ");
INSERT INTO cth_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A deicai e patetlah mang teh reirei a tâco van. Kai teh thaw bout tawk sak lah ka o teh, ahni teh kai thi sak e lah ao telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Hat toteh, Faro ni Joseph hah tang a kaw sak. Ka rang poung lah thongim thung a thung patuen dawk e a rasa awh teh, a pâkhamuen a ngaw hnukkhu a khohna a kâthung teh Faro koe a kâen. ");
INSERT INTO cth_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faro ni Joseph koe mang ka sak teh ka deicaikung apihai awm hoeh. Hatei nang ni mang heh na thaipanuek teh, na deicai thai telah ayânaw ni dei e hah ka thai telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph ni Faro koe hot teh kai koe awm hoeh. Cathut ni Faro koe roumnae lahoi a deicai han doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faro ni Joseph koe ka mang lavah khenhaw! palang rai ka kangdue. ");
INSERT INTO cth_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hahoi khenhaw! maitomanu a meikahawi ni teh kathâw e sari touh tuithung hoi a tâco teh pho um vah a pâ. ");
INSERT INTO cth_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hahoi alouke maitomanu a meikamathout niteh, ka kamsoe e hot patet e meimathout teh Izip ram pueng dawk patenghai ka hmu boihoeh e hah a tâco. ");
INSERT INTO cth_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Hahoi a mei kathout ni teh ka kamsoe e maitomanunaw ni kathâw e maitomanunaw hah koung a ca awh. ");
INSERT INTO cth_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Koung a ca awh hnukkhu patenghai yah apinihai a ca awh tie panuek kalawn hoeh. A ca awh hoehnahlan e patetlah a mei a mathoe awh mingming, hahoi vak ka kâhlaw. ");
INSERT INTO cth_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Hahoi ka mang lavah khenhaw! Cakung buet touh dawkvah, cavui kahawipoung e sari touh a tâco. ");
INSERT INTO cth_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Hahoi khenhaw! cavui sari touh kamyai ni teh kathoengcae, Kanîtholae kahlî ni remke lah a hmang e a tâco e hah bout ka hmu. ");
INSERT INTO cth_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Cavui kathoutnaw ni cavui kahawinaw sari touh hah koung a ca awh. Hote mang hah mitpaleikathoumnaw ka dei pouh ei, apinihai deicai thai awh hoeh, telah a dei. ");
INSERT INTO cth_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph ni Faro koe Faro nange mang heh buet touh doeh. Cathut ni a sak hane hah Faro koe na panue sak e doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Meikahawi e maitomanu sari touh teh kum sari touh doeh. Kahawi e cavui sari touh hai kum sari touh doeh. Mang teh buet touh doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hahoi a hnukkhu vah ka tâcawt e a mei kathout ni teh ka kamsoe e maitomanu sari touh hai kum sari touh doeh. Cavui sari touh Kanîtholae kahlî ni remke lah a hmang e hai kum sari touh doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Hetheh, Faro koe ka dei e Cathut ni a sak hane Faro a panue sak e doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Izip ram vah khobunae kum sari touh ao han. ");
INSERT INTO cth_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hatei, hat hnukkhu takangnae kum sari touh bout ao han. Hottelah takang ni ram teh voutthoup lah ao sak han dawkvah, khobunae kum pueng hah Izip ram teh pahnim e lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Rek ka tho e takang teh puenghoi a pataw han dawkvah, khobunae kum hah pahnim lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Hahoi mang vai hni totouh Faro a mangsaknae teh hete hno kecu dawk doeh. Sak hane teh Cathut ni a caksak teh Cathut roeroe ni karanglah a pha sak han. ");
INSERT INTO cth_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hatdawkvah, Faro ni tami buet touh a lungkaang e hoi kho ka pouk thai e tawng nateh Izip ram vah kahrawikung lah awm sak naseh. ");
INSERT INTO cth_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faro ni hotheh sak naseh, ram thung vah Izip ram cakang hah pung panga pung touh pâtung naseh. ");
INSERT INTO cth_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ahnimouh ni khobu kum cakang pung hah pâkhueng vaiteh Faro kâtawnnae rahim vah o hanelah kho tangkuem hmalah ca hane pâtung naseh, khenyawn awh naseh. ");
INSERT INTO cth_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Hottelah takang kecu dawk ram a rawk hoeh nahanlah, takangnae kum kum sari touh Izip ram ka phat hane dawkvah, kâhruetcuet lah ao han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hottelah pouknae a poe e hah, Faro hoi a sannaw pueng ni ahawi rip ati awh. ");
INSERT INTO cth_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hottelah Faro ni a sannaw koe het patet e Cathut Muitha onae tami heh hmu thai awh han na ou telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faro ni Joseph koe Cathut ni hote hnonaw pueng hah na panue sak dawkvah, nang patetlae tami lungkaang hoi hno kaawm hane oang ka panuek e awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nang teh kaie imthung karingkung lah na o han, ka taminaw pueng hah nange kâ lahoi ao awh han, bawitungkhung dueng hah nang hlak kai bet ka lenhnawn han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faro ni Joseph koe khenhaw! Izip ram pueng dawk kahrawikung lah na ta toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faro ni kutnoutthutnae kuthrawt hah a rading teh, Joseph kut dawk a buet pouh, hni loukloukkaang e hoi sak e hah a kâkhu sak teh a lahuen dawk sui dingyin hah a awi sak. ");
INSERT INTO cth_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A tawn e leng kahni touh dawk a kâcui sak teh, a hmalah tabut awh, telah a hram awh. Hottelah Izip ram thung kahrawikung lah a coung sak. ");
INSERT INTO cth_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faro ni Joseph koevah, kai teh Faro doeh, nange kâpoe laipalah Izip ram thung pueng a kut hai thoseh, a khok hai thoseh, dâw thai mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faro ni Joseph hah Zaphnath-Paaneah telah min a poe. On kho e vaihma Potiphar canu Asenath hah a yu lah a paluen pouh awh. Hahoi Joseph teh Izip ram kaukkung lah ahni koehoi a cei. ");
INSERT INTO cth_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph teh Izip siangpahrang Faro hmalah a kangdue navah, kum 30 touh doeh Joseph teh Faro koehoi a tâco teh Izip ram pueng dawk a cei. ");
INSERT INTO cth_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Khobu kum kum sari touh thung talai ni puenghoi a pawhik a tâco sak. ");
INSERT INTO cth_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Izip ram e khobu kum kum sari touh thung e cakang pueng hah a pâkhueng teh kho tangkuem tengpam e cakang hah a hmouk sak. ");
INSERT INTO cth_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph ni cakang hah talî teng e sadi patetlah kapappoung lah a pâtung, touk patenghai touk ngai hoeh toe, bangkongtetpawiteh, touklek hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Hahoi takang a tho hoehnahlan vah Joseph ni capa kahni toun a tawn. Hotnaw teh On kho vaihma Potiphar canu Asenath ni a khe pouh e naw doeh. ");
INSERT INTO cth_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph ni a camin hah Manasseh telah a phung. Bangkongtetpawiteh, Cathut ni ka tawntamnae hoi apa imthung pueng na pahnim sak telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Hahoi a capa apâhni e min teh Ephraim telah a phung. Bangkongtetpawiteh, Cathut ni kaie runae ram dawk ca catounnaw na tawn sak telah ati. ");
INSERT INTO cth_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Hottelah Izip ram ka phat e khobu kum teh a loum. ");
INSERT INTO cth_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Hahoi takang kum kum sari touh Joseph ni a dei tangcoung patetlah a kamtawng teh ram pueng dawk a pha. Hatei, Izip ram pueng dawk rawca ao. ");
INSERT INTO cth_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Hottelah Izip ram pueng teh takang ni koung a pha toteh, Faro koe rawca hei hoi a hram awh. Faro ni Izipnaw pueng koe Joseph koe cet awh nateh, a dei e pueng sak awh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Hahoi takang teh talai van pueng a pha teh, Joseph ni cakang pâtungnae tâsong pueng hah a paawng teh Izipnaw koevah a yo pouh. Izip ram vah takang teh puenghoi a pataw. ");
INSERT INTO cth_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Talai van pueng dawk takang teh a pataw poung dawkvah, kho tangkuem e tami pueng teh cakang ran hanelah Izip ram e Joseph koe a cei awh. ");
INSERT INTO cth_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jakop ni Izip ram vah cakang ao tie a panue teh, a capanaw koevah bangkongmaw sut na kâkhet awh. ");
INSERT INTO cth_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Izip ram vah cakang ao tie ka panue dout laipalah hring awh nahanlah hawvah cet awh nateh mamouh hanlah ran awh haw, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hottelah Joseph hmaunaw hra touh teh cakang ran hanlah Izip ram a cei awh. ");
INSERT INTO cth_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Hatei, Joseph e a nawngha Benjamin teh a hmaunaw koe Jakop ni cetsak van hoeh. Bangkongtetpawiteh, runae kâhmo langvaih ati. ");
INSERT INTO cth_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Isarel canaw teh cakang ran hanelah a cei awh. Bangkongtetpawiteh Kanaan ram hai takang teh a tho van. ");
INSERT INTO cth_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph teh ram thung bawi a tawk teh, hote ram pueng koe cakang kayawtkung lah ao. Hottelah Joseph e hmaunaw a tho awh teh, a hmalah talai khet laihoi a tabo awh. ");
INSERT INTO cth_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph ni a hmaunaw hah a hmu teh a panue. Hatei, ka panuek hoeh e patetlah a kâsak teh, ahnimouh koe lawkkahram lahoi nâhoi maw na tho awh atipouh. Ahnimouh ni cakang ran hanelah Kanaan ram hoi ka tho awh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph ni a hmaunaw hah a panue, hatei ahnimouh ni ahni teh panuek awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph ni ahnimouh kong dawk mang a sak e hah a panue teh ahnimouh koe katuetnaw doeh, khoram caicinae khet hanelah kathonaw doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ahnimouh ni nahoeh bo ka bawipa, na sannaw hah cakang ran hanelah ka tho awh e doeh, ati awh. ");
INSERT INTO cth_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tami buet touh e capanaw doeh, tami kahawi doeh. Na sannaw heh katuetnaw nahoeh, atipouh. ");
INSERT INTO cth_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Hatei ahni ni ahnimouh koe na yuem awh hoeh, khoram caicinae khet hanelah na kathonaw doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ahnimouh ni, na sannaw hah hmaunawngha hlaikahni touh ka pha awh. Kanaan ram kaawm tami buet touh e capanaw doeh. Kanawpoung e teh apa koe ao. Buet touh e teh awm hoeh toe, ati awh. ");
INSERT INTO cth_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Hatei Joseph ni ahnimouh koe katuetnaw doeh ka tie hah a tang doeh. ");
INSERT INTO cth_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hettelah tanouk e lah na o awh han. Kanawpoung e hah hi tho hoehpawiteh Faro hringnae noe lahoi hete hmuen koehoi na tâcawt awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nangmouh dawk lawkkatang ao maw awm hoeh maw, nangmae lawk tanouknae lah nangmouh thung dawk e buet touh patoun awh nateh, na nawngha teh thokhai naseh. Nangmouh teh thongim thung na o awh han rah, hoehpawiteh Faro hringnae noe lahoi katuetnaw katang doeh ka ti han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hottelah hnin thum touh abuemlah thongim a paung. ");
INSERT INTO cth_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Apâthum hnin vah Joseph ni ahnimouh koe hettelah sak awh na hring awh han. Bangkongtetpawiteh, Cathut hah ka taki, ");
INSERT INTO cth_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","tamikalan lah na awm awh pawiteh nangmouh thung dawk buet touh thongim bawt seh. Alouknaw teh ban awh nateh, takang ka tho e ni imthungnaw hanelah cakang hah phawt awh. ");
INSERT INTO cth_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Hahoi kanawpoung e hah kai koe thokhai awh. Hat pawiteh, na lawk kamceng vaiteh na dout awh mahoeh, atipouh teh hottelah a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ahnimouh ni hmaunawngha koe sak awh e hah payon poung awh toe, na pahren awh telah kâhei awh lahun nah a lungpuen e ka hmu awh eiteh, ka tarawi ngai awh hoeh. Hatdawkvah hete temdengnae ni na thosin e doeh, telah buet touh hoi buet touh a kâdei awh. ");
INSERT INTO cth_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben ni ahnimouh koe camo taranlahoi yonnae sak hanh awh, telah nangmouh koe ka dei nahoehmaw. Na thai ngai awh yawmaw. Hatdawkvah khenhaw! a thipaling phu teh atu maimouh koe hei e lah ao toe, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Hatei Joseph ni lawk tâhlat hno lahoi lawk a dei dawkvah, kho a khan awh e hah Joseph ni a thai panuek doeh tie hah ahnimouh ni panuek awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Hahoi ahnimouh koehoi alouklah a cei teh a ka. Ahnimouh koe bout a tho teh bout a pato, ahnimouh koehoi Simeon hah a hmu awhnae koe a katek. ");
INSERT INTO cth_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph ni ahnimouh cawngko dawk cakang cui hane hoi ahnimae tangka hai cawngko dawk pâseng hanelah kâ a poe. Hateh hottelah a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ahnimouh ni cakang la dawk aphu sak awh teh a tâco awh. ");
INSERT INTO cth_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ahnimouh thung dawk tami buet touh ni a roe awhnae koe lanaw rawca poe hanelah cawngko a paawng teh tangka hah a hmu, cawngko som dawkvah ao. ");
INSERT INTO cth_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hottelah a hmaunawnghanaw koevah, kaie tangka bout a ta awh, khenhaw! hei, kaie cawngko dawk ao hei, telah ati. A lungphuen awh teh Cathut ni hettelah na sak aw hei. Bang ngainae han na vaimoe telah ati awh teh, pâyaw laihoi buet touh hoi buet touh a kâkhet awh. ");
INSERT INTO cth_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kanaan ram a na pa Jakop koevah a pha awh, a kâhmo awh e pueng hah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Hot ram dawk e bawi lah kaawm e ni ka matheng poung lah na pato awh teh, ram katuetnaw lah na o awh. ");
INSERT INTO cth_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Hatei, kaimouh ni ahni koe, tamikalannaw doeh. Katuetkung lah khoeroe kaawm awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Hmaunawngha hlaikahni touh ka o awh teh, apa e capa lah ka o awh. Buet touh teh awm hoeh toe. Kanawpoung e teh atu Kanaan ram vah apa koevah ao, telah ka ti pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Hahoi hote ram dawk e bawi ni hettelahoi tamikalan lah na onae ka panue han. Na hmaunawngha buet touh cettakhai awh nateh, na imthungnaw hanelah cakang hah phawt nateh cet awh. ");
INSERT INTO cth_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Kanawpoung e hateh, kai koe thokhai awh, hat pawiteh katuetkung lah awm laipalah tamikalan doeh tie ka panue han. Hate ram dawk hno na yo awh han na ti pou, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Hahoi, cawngkonaw hah a rabu awh lahun navah, pouk laipalah tangka tangoung hah cawngko dawk ao teh, ahnimouh hoi a na pa ni tangka tangoung hah a hmu awh toteh a lungpuen awh. ");
INSERT INTO cth_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","A na pa Jakop ni nangmouh ni ka canaw koung na kahma sak awh toe. Joseph awm hoeh toe, Simeon hai awm hoeh toe. Benjamin totouh ceikhai han na kâcai awh. Hete hnonaw pueng ni na ratet toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Reuben ni a na pa koevah, nang koe ka thokhai hoehpawiteh, ka capa roi heh thet yawkaw. Ahni heh ka kut dawk na poe nateh, nang koe bout ka thokhai han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Hatei ahni ni, ka capa heh nangmouh koe cet van mahoeh, a hmau a due toe, ahni dueng doeh toe. Na ceinae lam dawk runae na kâhmo pawiteh, ka sampo heh lungmathoenae phuen dawk na loum sak awh han toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ram thung takang hoe a pataw poung. ");
INSERT INTO cth_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Izip hoi cakang a thokhai awh e a baw toteh, a na pa ni, bout cet awh nateh mamouh hanelah cakang youn touh bang bout ran awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Hatei, Judah ni ahni koe hote tami ni, na nawngha, nangmouh koe tho van hoehpawiteh, kai minhmai na hmawt awh mahoeh toe telah kamcengcalah kâhruetcuet na poe awh toe. ");
INSERT INTO cth_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Nawnghaca hah kaimouh koe na cetsak pawiteh, cakang teh na ran pouh awh han. ");
INSERT INTO cth_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Hatei na tha hoehpawiteh, ka cet awh mahoeh. Bangkongtetpawiteh, ahni ni kaimouh koe nangmouh koe na nawnghaca tho van hoehpawiteh, ka minhmai na hmawt mahoeh na ti pouh awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Isarel ni, bangkongmaw nawngha alouk tawnnae kong patetnaw hah kuekluek na dei awh teh, kai hanelah hnokahawi hoeh poung na sak awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Hatei, ahni ni hote tami ni na pa a hring rah maw, hmaunawngha alouke na tawn awh maw telah kaimae kong hoi imthungkhu kong na pacei awh dawk doeh. Hottelah lawk na pacei e patetlah ka pathung awh e doeh. Na nawnghaca thokhai awh ati hane hah apinimaw sut a panue thai han vaw telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah ni a na pa Isarel koevah, kaimouh hoi nang, nawnghaca hoi dout laipalah hring thai awh nahanlah, nawnghaca teh kaimouh koe kâbang sak nateh, ka cei awh han toe. ");
INSERT INTO cth_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ahni kong dawk kai ni kamngai vaiteh kai koe aphu teh na la han, ahni hah nang koe thokhai laipalah na hmalah kangdout sak hoehpawiteh, yonpennae pou ka phu han toe. ");
INSERT INTO cth_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Bangkongtetpawiteh, kânawngkâai awh hanh lei sei, apâhni e patenghai yo tho hane boum hei telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","A na pa Isarel ni ahni koe, hattelah pawiteh, hettelah sak awh. Hete ram dawk e hnokahawinaw thingtapi, khoitui, hmuitui, murah, câbuk paw a rakawk katha e, hoi almond pawnaw youn touh phawt awh. ");
INSERT INTO cth_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nangmae cawngko dawk tangka a pâban e hah bout sin awh, a payon awh e paka han doeh. ");
INSERT INTO cth_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hahoi na nawnghaca hai hrawi awh nateh ahni koe thaw awh nateh bout cet awh leih. ");
INSERT INTO cth_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Hote tami ni Benjamin na tha pouh nahanelah, Athakasaipounge Cathut ni na pahren awh naseh. Ka canaw teh ka sung pawiteh sung yawkaw toung vai khe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hottelah ahnimouh ni poehno hoi Benjamin hah a ceikhai awh teh, tangka hai let hni hoi a kâken awh. Hahoi a thaw awh teh Izip ram lah a cei awh teh Joseph hmalah bout a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Joseph ni ahnimouh koe kaawm e Benjamin a hmu tahma vah, imkaringkung hah a kaw teh ahnimanaw hah imthung kâenkhai nateh saring thet nateh coungkacoe rakueng haw. Bangkongtetpawiteh, ahnimouh teh kanîthun bu kai koe a ca awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Joseph ni kâ a poe e patetlah ahnimouh ni a tawk awh teh, ahni ni ahnimanaw hah imthung a kâenkhai awh. ");
INSERT INTO cth_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Joseph ni imthung kâenkhaie lah ao dawkvah, ahnimouh teh a lungpuen awh teh, ahnimouh ni, ahmaloe e kaimae cawngko dawk tangka a pâban dawkvah na kâenkhai e han doeh, maimouh hoi lanaw hoi san lah na man thai nahanelah toe hanlah a kâcai e han doeh, ati awh. ");
INSERT INTO cth_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Joseph e imkaringkung koe vah a hnai awh teh takhang koe a pato awh. ");
INSERT INTO cth_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Oe, Bawipa, ahmaloe ka tho awh navah, cakang ran hanelah dueng doeh ka tho awh. ");
INSERT INTO cth_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Hahoi hettelah ao, roenae rim koe ka pha awh navah, cawngko ka paawng awh boteh kamamae tangka lengkaleng ka kuepcalah ao. Hatdawkvah bout ka thokhai awh. ");
INSERT INTO cth_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Cakang ran nahane tangka alouke hai ka sin awh. Kaimae tangka heh apinimaw cawngko dawk a hruek tie ka panuek awh hoeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hatei ahni ni nangmouh koe roumnae awm seh, taket hanh awh. Nangmae cawngko dawk nangmae Cathut hoi na pa e Cathut ni râw na poe awh e doeh, nangmae tangka hah ka hmu doeh, telah ati. Hahoi Simeon hah ahnimouh koe a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Hottelah ahni ni ahnimouh hah Joseph imthung a kâenkhai teh tui a poe teh, a khok a kâpasu awh teh, lanaw hah rawca a poe awh. ");
INSERT INTO cth_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hahoi aphu awh e poehno hah Joseph bu a ca hanelah a tho hoehnahlan coungkacoe ao awh. Bangkongtetpawiteh, hawvah, bu ca han tie hah a panue awh. ");
INSERT INTO cth_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Joseph takhang koe a pha toteh a kut dawk kaawm e poehnonaw hah ahni koe a kâenkhai awh teh a hmalah talai khet laihoi a tabut awh. ");
INSERT INTO cth_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ahni ni kamthang a pacei, na dei awh e na pa matawng teh a hring rah maw. A tak a dam maw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ahnimouh ni apa na san teh a hring doeh rah, a tak hai a dam rah, atipouh awh. Hahoi a mahmawk a lû a saling awh teh a tabut awh. ");
INSERT INTO cth_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ahni ni a khet teh, a nawngha Benjamin a manu e capa hah a hmu, ahni heh na nawnghaca akong na dei awh e hah maw, telah ati. Hahoi ahni ni ka capa, Cathut ni na pahren naseh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Joseph ni a nawngha a hmu toteh, a lungmathoe teh karangpounglah ka nahane hmuen a tawng. Imrakhan thung a kâen teh hawvah a ka. ");
INSERT INTO cth_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","A minhmai a pâhla teh bout a tâco teh puenghoi a kâsum. Rawca rakueng awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hottelah ahni hanlah aloukcalah, ahnimouh hanlah aloukcalah, a coun e Izipnaw hanlah aloukcalah, bangkongtetpawiteh, Izipnaw ni Hebrunaw hoi bu rei cat khai boihoeh, hothateh Izipnaw hanlah panuettho e lah ao. ");
INSERT INTO cth_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Hottelah capa kacue teh camin lah ao e hoi kanaw teh cahnoung lah ao e patetlah Joseph hmalah a tahung awh teh, kângai lah a ru awh. ");
INSERT INTO cth_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Joseph ni ahnimouh ham hah amamouh koe a poe sak teh, Benjamin e ham teh ahnimae ham hlak let panga touh hoi apap. Hottelah a nei awh teh, ahni koe hroung a nawm awh. ");
INSERT INTO cth_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ahnimouh ni imkaringkung koevah, ahnimouh ni aphu thai yit touh, cawngko pakawi pouh nateh, amamae tangka rip hah amamae cawngko som koe lengkaleng tat pouh. ");
INSERT INTO cth_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Hahoi kaie manang, ngun manang hah a cahnoung e cawngko som dawkvah cakang phu tangka hoi na ta pouh han, telah kâ a poe. ");
INSERT INTO cth_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Khodai tahma vah ahnimouh teh amamae lanaw hoi a kamthaw awh. ");
INSERT INTO cth_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Kho thung hoi a kamthaw awh teh ahlapoungnae koe a pha awh hoehnahlan, Joseph ni imkaringkung koe thaw nateh ahnimanaw hah pâlei haw. Hahoi na pha toteh ahnimouh koe, bangkongmaw hawinae hah hawihoehnae hoi na patho awh. ");
INSERT INTO cth_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Hot hah, kaie bawipa e misur neinae hoi hma lae ka tho hane kong a panuenae nahoehmaw. Het patet lae na o awh e heh puenghoi na payon awh, na ti pouh han. ");
INSERT INTO cth_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Hahoi, rek a pha toteh hottelah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ahnimouh ni ahni koe, bawipa, bangkongmaw het patet lae lawk na dei, na sannaw ni hot patet e hno ka sak awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Khenhaw! kaimae cawngko som dawk ka hmu awh e tangka hoi Kanaan kho hoi nang koe bout ka thokhai awh nahoehmaw. Bangtelamaw na bawipa im e tangka hoi sui teh ka paru thai awh han namaw. ");
INSERT INTO cth_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Na sannaw thung dawk hote hno na hmunae pueng dout seh. Kaimouh hai bawipa e san lah ka o awh yawkaw han, ati awh. ");
INSERT INTO cth_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ahni ni bokheiyah, atu hai nangmae lawk patetlah lawiseh, hno ka hmunae tami hah ka san lah ao vaiteh, nangmouh teh toun kaawm hoeh lah na o awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Hat nah tahma vah amamae cawngko lengkaleng a patue awh teh lengkaleng a paawng awh. ");
INSERT INTO cth_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ahni ni kacuepoung koehoi kanawpoung totouh a tawng pouh. Hattoteh Benjamin e cawngko dawk manang teh a hmu. ");
INSERT INTO cth_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hat nah tahma vah a khohna a phi awh, lanaw a phu sak awh teh kho dawk a ban awh. ");
INSERT INTO cth_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah hoi a hmaunawnghanaw teh Joseph im a pha awh, ama teh haw vah a la o rah. Hahoi a hmalah a tabo awh. ");
INSERT INTO cth_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Hahoi Joseph ni bangmaw na sak awh. Kai patetlae tami ni hmalah ka tho hane hno a panue han tie na panuek awh hoeh maw, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah ni ka bawipa nang koe bangvai ka dei awh toung. Bangmaw ka pâpha thai awh han. Cathut ni na sannaw yonnae teh a hmu toe. Khenhaw! ka bawipa kaimouh hoi ahnie kut dawk manang a hmu e hoi na san lah doeh ka o awh toe telah ati. ");
INSERT INTO cth_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hatei ahni ni, hottelah khoeroe ka sak mahoeh, a kut dawk manang a hmunae dueng doeh ka san lah ao vaiteh nangmouh teh na pa koe karoumcalah cet awh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Hat nah tahma vah, Judah ni Joseph hah a hnai teh, Oe ka bawipa, pahren lahoi na san heh, ka bawipa na san heh na hnâthainae koe lawk kam touh na dei sak haw. Na lungkhueknae hah na san koe kaman sak hanh. Bangtelah tetpawiteh, nang teh Faro patetlah doeh na o. ");
INSERT INTO cth_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ka bawipa nang ni, na pa nakunghai, hmaunawngha nakunghai na tawn maw telah na sannaw hah na pacei. ");
INSERT INTO cth_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kaimouh ni nang koe ka matawngpoung e na pa ka tawn awh. Matawng sawi a sak e camoca ka tawn awh teh buet touh teh a due toe, a manu ni a khe e dawk ahni dueng ao teh a na pa ni a pahren poung, ka ti awh. ");
INSERT INTO cth_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Nang ni, ahni ka hmu thai nahanlah kai koe thokhai awh ati. ");
INSERT INTO cth_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ka bawipa kaimouh ni tongpaca ni a na pa cettakhai thai mahoeh, bangkongtetpawiteh, a na pa cettakhai pawiteh a na pa a due han doeh ka ti awh. ");
INSERT INTO cth_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Hatei, nang ni na nawngha cahnoung nangmouh koe tho van hoehpawiteh, ka mei na hmawt awh mahoeh toe, ati. ");
INSERT INTO cth_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Hahoi, na sannaw apa koe ka pha awh toteh, ka bawipa, bawipa nange lawk hah ka dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Apa ni bout cet awh nateh, mamouh hanelah cakang youn touh bout ran awh, ati. ");
INSERT INTO cth_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Hatei kaimouh ni ka cet thai awh mahoeh, nawngha cahnoung kaimouh koe tho van pawiteh dueng doeh ka cei awh han. Bangkongtetpawiteh, nawngha cahnoung kaimouh koe tho van hoehpawiteh ahnie mei ka hmawt thai awh mahoeh toe, telah ka ti pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Na san kaimae na pa ni, ka yu ni capa kahni touh na khe pouh tie na panue awh. ");
INSERT INTO cth_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Buet touh teh kai koehoi a tâco teh koung paset e lah ao mue toe, hahoi teh ahni ka hmawt boihoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Hahoi hete camo heh kai koe hoi na ceikhai teh, runae kâhmo pawiteh, ka sampo hah lungmathoenae lahoi phuen dawk na loum sak awh toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Hatdawkvah, tongpaca heh kaimouh koe tho van laipalah na san apa koe ka tho pawiteh, a hringnae hoi tongpaca e hringnae mekkawme lah ao dawkvah, ");
INSERT INTO cth_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","tongpaca tho van hoeh tie hah a panue tahma kadout han doeh. Hattoteh na sannaw ni na san apa e sampo hah lungmathoenae hoi phuen koe ka loum sak yawkaw han doeh. ");
INSERT INTO cth_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Bangtelah tetpawiteh, na san ni nang koe ka thokhai hoehpawiteh, a yungyoe na hmalah yonpen e lah ka o han telah apa koe tongpaca kong dawk thoe yo ka bo toe. ");
INSERT INTO cth_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Pahren lahoi na san hah tongpaca yueng lah ka bawipa, na san lah na awm sak nateh, tongpaca heh a hmaunaw hoi ban sak leih. ");
INSERT INTO cth_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Bangkongtetpawiteh, kai koe tongpaca tho van hoehpawiteh bangtelamaw apa koe ka cei thai awh han vaw. Telah hoehpawiteh, apa koe ka phat hane thoenae teh ka hmu payon awh han doeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph teh a teng kaawm e pueng hmalah kâsum thai hoeh toung dawkvah, tami pueng kai koehoi koung tâcawt awh, telah a hram. Hottelah Joseph ni a hmaunawnghanaw koe a kâpanuesak nah yunglam apihai ahni teng kangdout awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Kacaipounglah a ka teh, Izipnaw ni a thai awh, Faro imthungkhu ni hai a thai awh. ");
INSERT INTO cth_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph ni a hmaunawnghanaw koe kai teh Joseph doeh, apa atu sittouh a hring rah maw, telah ati. Hatei pato thai laipalah a hmaunaw roumkalue awh teh a hmalah sut a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph ni a hmaunawnghanaw koe, pahren lahoi na hnai awh haw, telah ati. Hateh a hnai awh. Ahni ni na hmaunawngha Joseph, Izip ram vah na yo awh e hah ma. ");
INSERT INTO cth_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Hatei, hivah cei hanelah na yo awh dawkvah, na lungmathout hanh awh, namamouh hoi namamouh hai kâhmuhma hanh awh, bangkongtetpawiteh, hringnae rungngang hanelah Cathut ni nangmouh hmalah na patoun e doeh. ");
INSERT INTO cth_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Bangkongtetpawiteh, kum hni touh thung hete ram dawk takang a tho. Kum panga touh a ngai rah. Hat nah thung pueng teh laikawk kanawk awm mahoeh. Canga e hai awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Hottelah talai van catoun ka tawn hanelah karingkung hoi rungngangnae kalen hoi na hringsakthai awh nahanlah, Cathut ni ahmaloe hoi nangmouh hmalah na patoun toe. ");
INSERT INTO cth_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hottelah hie hmuen koe na kacetsakkung hah nangmouh laipalah Cathut doeh. Ahni ni Faro hanelah na pa lah, imthungkhu kahrawikung, hoi Izip ram pueng kaukkung lah na coung sak. ");
INSERT INTO cth_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Karanglah apa koe cet awh nateh, ahni koe na capa Joseph ni hettelah a dei, Cathut ni Izip ram pueng dawk bawi lah na sak, kai koe tho awh, uet awh hanh leih. ");
INSERT INTO cth_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Goshen ram vah na o han. Nang nama hoi, na capanaw hoi na mincanaw hoi, na tuhunaw, na maitohu hoi na tawn e puenghoi kai koe roeroe vah na o han. ");
INSERT INTO cth_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Hawvah kai ni na kawk han. Bangkongtetpawiteh hawvah takang kum panga touh ao han rah. Hatdawkvah, na roedeng payon vaih nang hoi na imthung hoi na tawn e pueng hoi telah na ti pouh awh han. ");
INSERT INTO cth_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hahoi khenhaw! nangmae mit roeroe hoi ka nawngha Benjamin e mit roeroe ni kaie ka pahni ni a dei lahun e hah na hmu awh. ");
INSERT INTO cth_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Izip ram e ka bawilennae pueng hoi na hmu awh e hno pueng hah apa koe na dei awh vaiteh, apa teh karang poung lah na thokhai awh han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hahoi a lungtabue hoi Benjamin lungtabue rekkâbet lah a tapam teh a ka. Benjamin ni hai a tapam teh a ka. ");
INSERT INTO cth_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A hmaunawngha pueng a paco hnukkhu, a hmaunawnghanaw ni lawk a dei awh. ");
INSERT INTO cth_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Joseph e hmaunawnghanaw a tho awh tie kamthang teh Faro im vah a thai awh teh, hote kamthang ni Faro hoi a sannaw a lunghawi sak. ");
INSERT INTO cth_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faro ni Joseph koe, na hmaunawnghanaw koe, hettelah dei pouh, na saringnaw teh cakang phu sak hoi tâcawt awh nateh, Kanaan ram vah cet awh. ");
INSERT INTO cth_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Hahoi na pa hoi a imthung hah kaimouh koe thokhai awh. Izip ram e hnokahawi na poe awh vaiteh, hete ram dawk kaawm e hnokahawipoung hah na ca awh han telah dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Kâ na poe, hettelah dei pouh. Na canaw hoi na canunaw hane hoi na yunaw hanelah Izip ram hoi lengnaw sin awh nateh, na pa hah thokhai awh. ");
INSERT INTO cth_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Na hnopai kong dawk lungpuen hanh awh. Bangkongtetpawiteh, Izip ram e hnokahawi pueng teh nangmae doeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Hahoi teh, Isarel canaw ni hottelah a sak awh. Joseph ni Faro kâpoe e patetlah leng hah ahnimouh koe a poe. Lam vah a ca awh hane hai a poe. ");
INSERT INTO cth_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ahnimouh abuemlah koe khohna kâthung hanelah a poe. Benjamin koe teh tangka cumthum touh hoi khohna kâthung hane panga touh a poe. ");
INSERT INTO cth_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Hahoi a na pa koevah, la hra touh, Izip ram hnokahawi kapawtkung hoi lamanu hra touh, lam vah a na pa hane cakang hoi vaiyei hoi canei han kaphawtkung lah a patoun. ");
INSERT INTO cth_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Hottelah a hmaunawnghanaw hah a patoun teh a ceisak. Ahni ni lam vah na kâyue awh hoeh nahanlah kâhruetcuet awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Izip hoi a tâco awh teh a na pa Jakop koe a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Hatei, Joseph a hring rah Izip ram pueng ukkung lah ao telah a dei pouh awh. Jakop a lungmit teh, ahnimouh ni dei e tang thai hoeh. ");
INSERT INTO cth_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Hatei, ahni koe Joseph ni lawk dei e pueng hah a dei pouh awh. Hahoi a kâcui hane leng Joseph ni a patawn e hah a hmu toteh, a na pa Jakop e lungthin bout a kâhlaw. ");
INSERT INTO cth_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Isarel ni a khout toe, ka capa Joseph teh a hring doeh rah, ka cei vaiteh, ka due hoehnahlan ka hmu han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Isarel teh a tawn e pueng hoi a tâco. Beersheba vah a pha teh a na pa Isak Cathut koe thuengnae a sak. ");
INSERT INTO cth_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Cathut ni karum a mang lah Isarel koe lawk a dei teh, Jakop Jakop telah ati. Ahni ni, hivah ka o, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ahni ni, kai teh Cathut nange Cathut lah ka o. Izip ram lah na cei hane hah taket hanh. Bangkongtetpawiteh, miphun kalen lah na coung sak han. ");
INSERT INTO cth_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nang koe Izip lah ka cei van vaiteh, bout na hrawi han, hahoi Joseph ni na mit dawk na kut a hruek han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hottelah hoi Jakop teh, Beersheba hoi a tâco teh, Isarel e capanaw ni, a na pa Jakop hoi a canaw hoi a yunaw a kâcui nahanelah Faro ni na patawn e leng dawk na kâcui sak han. ");
INSERT INTO cth_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jakop hoi a catoun pueng Kanaan ram e a hmu awh e a saringnaw hoi a hnopainaw hoi a tâcokhai teh Izip vah a cei awh. ");
INSERT INTO cth_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","A capa hoi a pahringcanaw hoi a miphun a catoun pueng hah Izip vah a kâenkhai awh. ");
INSERT INTO cth_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Hetnaw heh Isarel catoun Izip ram ka kâen e Jakop hoi a canaw e minnaw doeh. Jakop e camin Reuben, ");
INSERT INTO cth_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben capanaw teh Hanok, Pallu, Hezron hoi, Karmi. ");
INSERT INTO cth_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon capanaw teh Jemuel, Jamin, Ohad, Jakhin, Zohar hoi Kanaan napui koehoi e a capa Saul, ");
INSERT INTO cth_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levih capanaw teh Gershon, Kohath hoi, Merari ");
INSERT INTO cth_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah capanaw teh Er, Onan, Shelah, Perez hoi Zerah naw doeh. Hateiteh, Er hoi Onan teh Kanaan kho vah a due awh toe. Perez ca roi lah Hezron hoi Hamul ao. ");
INSERT INTO cth_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issakhar capanaw teh Tola, Puvah, Jashub hoi Shimron, ");
INSERT INTO cth_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun capanaw teh Sered, Elon hoi Jaheel, ");
INSERT INTO cth_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hotnaw teh Leah capanaw a canu Dinah hoi Paddanaram vah Jakop hanlah a khe pouh e naw lah ao. A capanaw hoi a canunaw teh abuemlahoi 33 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad capanaw teh Ziphion, Haggi, Shuni, Ezbon, Eri, Arodi hoi Areli, ");
INSERT INTO cth_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher capanaw teh Imnah, Ishua, Ishvi, Beriah hoi a tawncanu Serah hoi Beriah capa teh Heber hoi Malkhiel tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hotnaw teh Zilpah Laban ni a canu Leah koevah a poe e capanaw doeh. Ahnimanaw teh tami 16 touh, Jakop ni a khe e naw doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jakop yu Rachel capa roi teh Joseph hoi Benjamin doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseph ni Izip kho vah ao navah Manasseh hoi Ephraim a sak, hotnaw teh On kho e vaihma Potiphar canu Asenath ni a khe pouh e doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin capanaw teh Bela, Bekher, Ashbel Gera, Naaman Ehi, Rosh, Muppin, Huppim hoi Ard tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hotnaw teh Rachel ni Jakop hanlah a khe pouh e capanaw doeh, 14 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan capa teh Hushim doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali capanaw teh Jahzeel, Guni, Jezer hoi Shillem doeh. ");
INSERT INTO cth_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hotnaw teh Laban ni a canu Rachel koe a poe e Bilhah ni Jakop hanlah a khe pouh e naw doeh, abuemlahoi 7 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jakop e a capanaw e yu hmai touksin laipalah Jakop koe Izip ram rei ka cet e tami abuemlah 66 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Joseph ni Izip ram e a capa a khe e naw teh kahni touh a pha Jakop imthung Izip ram dawk kâen e pueng teh 70 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jakop ni Goshen lam pâtue hanelah Judah teh Joseph koe hmaloe a ceisak teh, hottelah hoi Goshen ram lah a pha awh. ");
INSERT INTO cth_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph ni a leng hah coungkacoe a rakueng teh Goshen vah a na pa a dawn hanelah a cei. Ahni koe a kâpanuesak teh a lahuen dawk a tapam teh a tapam laihoi ngailawi a ka. ");
INSERT INTO cth_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isarel ni Joseph koevah, na hring rah dawkvah, na mei bout ka hmu toe, atuteh kadout lawi nakunghai yah, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph ni a hmaunawngha a na pa imthung koevah, ka cei vaiteh, Faro koe ka dei pouh vaiteh, ahni koevah, ka hmaunawngha hoi apa imthung Kanaan ram kaawm e hah kai koe a pha awh toe. ");
INSERT INTO cth_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ahnimanaw teh saring kapacanaw lah ao teh tukhoumkung lah ao awh. Tuhu hoi maitohu hoi a tawn awh e pueng a thokhai awh toe telah ka dei han. ");
INSERT INTO cth_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Faro ni na kaw awh teh, bang thaw maw ouk na tawk awh na tet pouh pawiteh, ");
INSERT INTO cth_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","nangmouh ni na sannaw teh ka mintoenaw koehoi kamtawng teh camoca hoi atu totouh, saring ka paca awh e doeh, telah na ti awh han. Hottelah hoi Goshen ram dawk na o thai awh han, telah atipouh. Bangkongtetpawiteh, tu ka khoum e pueng teh Izip taminaw ni a panuet awh. ");
INSERT INTO cth_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph ni Faro koevah, apa hoi ka hmaunawnghanaw tuhu, maitohu a tawn awh e naw pueng hoi Kanaan ram hoi a tho awh, atu Goshen ram vah ao awh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","A hmaunawnghanaw thung hoi tami panga touh a hrawi teh Faro koe a ceikhai. ");
INSERT INTO cth_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faro ni a hmaunawnghanaw koevah, bang thaw maw ouk na tawk awh telah a pacei. Ahnimanaw ni Faro koevah, na sannaw teh ka mintoenaw se nah hoi atu totouh tu doeh ka khoum awh, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ahnimouh ni Faro koevah, hete ram dawk o hanelah ka tho awh. Bangkongtetpawiteh, takang Kanaan ram dawk a pataw teh saringnaw hanlah hram awm hoeh toe. Hatdawkvah pahren lahoi na sannaw heh Goshen ram dawk na awm sak awh loe, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faro ni Joseph a pato teh, na pa hoi na hmaunawnghanaw heh nang koe a tho awh toe. ");
INSERT INTO cth_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Izip ram teh na hmalah doeh ao, na pa hoi na hmaunawnghanaw teh kahawi e ram dawk awm sak, Goshen ram dawk kho sak awh naseh. Ahnimouh thung dawk hno ka sak thai e tami na panue e awm pawiteh ka saringnaw lathueng kahrawikung lah na ta han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph ni a na pa Jakop hah a kâenkhai teh Faro hmalah a kangdue sak teh, Jakop ni Faro hah yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faro ni Jakop koevah, kum nâyittouh maw na pha toung telah a pacei. ");
INSERT INTO cth_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jakop ni Faro koevah kahlawng ka ceinae hnin hoi ka kumnaw teh 130 touh a pha toe. Ka hringnae kumnaw a duem teh a ru, na kakhekungnaw kahlawng ceinae hoi kumnaw hai khout hoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jakop ni Faro yawhawi a poe teh Faro koehoi a tâco. ");
INSERT INTO cth_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Hottelah Joseph ni a na pa hoi a hmaunawnghanaw kho a sak sak. Faro ni kâpoe e patetlah Izip ram thung e kahawipoung e ram Raameses ram dawk e ram hah râw lah a poe. ");
INSERT INTO cth_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Hahoi Joseph ni a na pa hoi a hmaunawnghanaw hoi a na pa imthungnaw pueng, a imthungnaw lahoi canei hanlah a poe. ");
INSERT INTO cth_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Hote ramnaw pueng dawk canei hane awm hoeh toe. Bangkongtetpawiteh, takang puenghoi a tho. Hote takang dawk Izip ram hoi Kanaan ram teh a patang poung awh. ");
INSERT INTO cth_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph ni cakang a ranae phu, Izip hoi Kanaan ramnaw pueng dawk hoi a hmu e tangkanaw hah Faro im lah a ceikhai. ");
INSERT INTO cth_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Izip ram hoi Kanaan ram e tangkanaw abaw toteh, Izip taminaw pueng teh Joseph koe a tho awh teh, canei hanelah na poe awh haw, bangkongtetpawiteh, bangkongmaw na hmalah ka due awh han vaw, tangka awm hoeh toe, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph ni saringnaw hah na poe awh. Tangka awm hoeh toung pawiteh, na saringnaw e phu lah canei hanlah na poe awh han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hat toteh, a saringnaw Joseph koe a ceikhai awh teh, Joseph ni marang, tu, hoi maito hoi lanaw e phu lah canei hanlah a poe. Hatnae kum dawk teh saringnaw e phu lah canei poe e lahoi a kawk. ");
INSERT INTO cth_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kum a baw teh, kum katha dawk ahni koe bout a tho awh teh, kaimouh e tangkanaw pueng abaw toe. Saringnaw a bawnae kong dawk banghai ka paphat awh hoeh. Bawipa na mithmu vah kaimouh miphun hoi lawhmuen laipalah banghai awm hoeh toe. ");
INSERT INTO cth_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Bangkongmaw na hmalah ka due awh han, kamamouh hai, lawhmuen hai na ran awh ngala lawih, telah pawiteh doeh kamamouh hoi lawhmuennaw pueng Faro e san lah ka o awh han, dout laipalah ka hring awh nahan hoi lawhmuennaw kingdi hoeh nahan, cati na poe leih telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hat toteh, Joseph ni Izip ram naw pueng Faro hanlah a ran pouh. Takang puenghoi a tho dawkvah Izip taminaw pueng ni lawhmuennaw he a yo awh teh, lawhmuennaw teh Faro e lah he ao. ");
INSERT INTO cth_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Taminaw teh Izip ramri avanglah hoi avanglah totouh kho tangkuem dawk a kampuen awh. ");
INSERT INTO cth_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Vaihmanaw e ram teh ran pouh hoeh. Bangkongtetpawiteh vaihmanaw ni Faro koehoi ham hane ao teh Faro ni ham a poe e naw hah a canei awh dawkvah, lawhmuen hah yawt awh hoeh. ");
INSERT INTO cth_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hat hnukkhu, Joseph ni taminaw pueng koe, khenhaw! sahnin dawk namamouh hoi na lawhmuennaw hah Faro hanlah ka ran toe. Khenhaw! haw vah cati ao. Talai dawk na tu awh han. ");
INSERT INTO cth_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Hahoi cakang na hmu awh toteh, hettelah Faro hanlah pung panga pung touh na poe awh vaiteh, pung pali touh e teh namamouh hanelah ao han. Hottelah law dawk bout na tu hane hoi namamouh imthungnaw ca hane hoi na canaw ca hanelah na ta awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ahnimouh ni, nang ni kaimouh hringnae na hlout sak toe. Ka bawipa ni na pahren naseh, Faro e san lah ka o awh han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Hottelah Faro ni pung panga pung touh poe e hmunae dawk vah, Izip ram dawk atu totouh Joseph ni phung a sak. Vaihmanaw e lawhmuen dueng teh Faro e lah awm hoeh. ");
INSERT INTO cth_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hahoi Isarelnaw teh Izip ram e Goshen ram dawk kho a sak awh teh, hnopainaw a hmu awh teh ca catounnaw moikapap a pungdaw awh. ");
INSERT INTO cth_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jakop teh Izip ram vah kum 17 touh ao. Hottelah Jakop hringnae kum 147 touh a pha. ");
INSERT INTO cth_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Hattoteh Isarel due nahane a hnai toung dawkvah, a capa Joseph hah a kaw teh a im vah, na lung ka youk pawiteh, pahren lahoi na kut hah ka phai rahak vah tat haw, na pahren nateh kaie lathueng vah atangcalah na sak han, pahren lahoi Izip ram dawk na pakawm hanh lah a. ");
INSERT INTO cth_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Mintoenaw koe ka kâhat toteh nang ni Izip ram thung hoi na hrawm na teh, ahnimouh pakawpnae koe na pakawp van loe, telah ati. Ahni ni na dei e patetlah ka sak han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ahni ni kai koe thoekâbo loe, telah atipouh teh, ahni koe thoe a kâbo. Hahoi Isarel teh amae ikhun dawk a tabo. ");
INSERT INTO cth_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Hathnukkhu, Joseph koe, Thai haw, na pa a pataw, telah atipouh awh. A capa Manasseh hoi Ephraim hah a hrawi teh a ceikhai. ");
INSERT INTO cth_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Jakop koevah, khenhaw! na capa Joseph nang koe a tho, telah atipouh awh. Hatdawkvah, Jakop teh tha a kâsangue teh ikhun dawk a tahung. ");
INSERT INTO cth_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jakop ni Joseph koevah, Cathut Athakasaipounge teh Kanaan ram, Luz kho dawk kai koevah a kamnue teh yawhawinae na poe. ");
INSERT INTO cth_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Kai koevah, ca catounnaw moikapap na poe han, na pungdaw sak han, tamihupui lah na sak han, hahoi hete ram heh ka tho hane na ca catounnaw koe râw lah na poe awh han, telah na ti pouh. ");
INSERT INTO cth_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Na ca roi Izip ram, nang koe ka tho hoehnahlan na khe e haiyah kaie doeh. Manasseh hoi Ephraim heh, Reuben hoi Simeon patetlah kaie lah ao han. ");
INSERT INTO cth_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Atu hoi bout na khe e teh namae lah ao han. A coe awh han e râw dawk a hmau roi e min hah a hmawng awh han. ");
INSERT INTO cth_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Hatei, kaie kong dawk, Paddanaram ram hoi ka tho navah, Rachel teh Kanaan ram e lampui dawk, Ephrath kho hoi lam bet ahlanae koe kai teng vah a due teh hawvah Ephrath lam dawk ka pakawp. (Hot teh Bethlehem doeh). ");
INSERT INTO cth_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Hahoi, Isarel ni Joseph e capa roi a khet teh, hetnaw heh apinaw maw telah ati. ");
INSERT INTO cth_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph ni a na pa koevah, ahnimouh roi teh ka capa roi doeh, Cathut ni hi vah na poe e roi doeh, telah atipouh. Ahni ni pahren lahoi kai koe thokhai haw, yawhawinae ka poe han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Isarel teh a matawng toung dawkvah a mit hah kacailah hmawt thai hoeh toe. Hahoi teh, hnai sak haw, ahni ni a tapam teh a paco. ");
INSERT INTO cth_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isarel ni Joseph koevah, Na mei hmu hane boehai ka ngaihawi hoeh ei, Cathut ni na ca catounnaw e mei totouh na hmu sak, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph ni ahnimouh teh a na pa e phai rahak hoi a la teh a hmalah a tabo sak. ");
INSERT INTO cth_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Hahoi, Joseph ni kahni touh hoi a ceikhai teh Ephraim aranglae kut hoi Isarel e avoilae kut koe lah a ceikhai. Manasseh hah avoilae kut hoi Isarel e aranglae kut koe lah a ceikhai. ");
INSERT INTO cth_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Hahoi, Isarel ni a kut a khingkhai teh aranglae kut hah kanaw e Ephraim e a lû dawk a toung teh avoilae kut hah Manasseh e lû van vah a toung. Bangkongtetpawiteh, ahni teh camin lah ao. ");
INSERT INTO cth_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hottelah yawhawinae a poe teh kakhekung Abraham hoi Isak hmalah ouk kaawm pouh e Cathut, sahnin totouh ka hringyung thung pueng na kakawkkung Cathut. ");
INSERT INTO cth_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Hawihoehnae pueng thung hoi na karatangkung kalvantaminaw ni hete camo roi yawhawinae poe naseh, Abraham hoi Isak min teh ahnimouh roi ni sin naseh. Hahoi, talai lungui vah tami moikapap lah pungdaw awh naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","A na pa ni aranglae kut Ephraim e lû dawk a toung e Joseph ni a hmu navah, a lungkuep hoeh dawkvah a na pa e kut Ephraim lû dawk a toung e hah Manasseh e a lû dawk puen hanelah a tawm. ");
INSERT INTO cth_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Joseph ni a na pa koevah, Apa hettelah mahoeh. Bangkongtetpawiteh, het nahoehmaw a camin. Aranglae na kut a lû dawk na toung hane vaw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Hatei, a na pa ni a ngai hoeh dawk, ka panue ka ca, ka panue. Ahni haiyah miphun telah kaw han e kamcu lah ao vaiteh a lentoe van han. Hatei, a nawngha heh ahni hlakvah hoe a lentoe vaiteh a ca catounnaw haiyah miphun moikapap lah ao awh han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hatdawkvah, hote hnin dawk yawhawinae a poe teh, nang pawlawk dawk Cathut ni Isarel teh yawhawinae poe naseh, nang teh Ephraim hoi Manasseh patetlah na tat naseh telah atipouh teh, Manasseh hmalah Ephraim ao sak. ");
INSERT INTO cth_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hottelah, Isarel ni Joseph koevah, khenhaw! meimei ka due toe, hat eiteh Cathut teh nang koevah ao vaiteh mintoenaw e ram dawk na hrawi awh han. ");
INSERT INTO cth_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Hothloilah, na hmaunawnghanaw hane thung hoi ham buet touh, tahloi hoi licung, Amor taminaw e kut dawk ka la e hah na thap pouh, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jakop ni a capanaw a kaw teh ahnimouh koevah, hmalah nangmouh koe ka tho hane hnonaw ka dei thai nahanlah kamkhueng awh haw. ");
INSERT INTO cth_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Nangmouh Jakop canaw kamkhueng awh nateh, na pa Isarel e lawk thai awh haw. ");
INSERT INTO cth_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben, nang teh ka ca camin, ka hnosakthainae, ka thaonae, aluepaw, karasangpoung hoi a tha kaawm poung e lah na o. ");
INSERT INTO cth_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Hatei, tui patetlah kâhuen e lungthin na tawn. Taluenae koe na phat mahoeh. Bangkongtetpawiteh, nang ni kaie ikhun dawk na luen teh na kamhnawng sak. Ka ikhun hah na tapam. ");
INSERT INTO cth_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon hoi Levih teh hmaunawngha roi doeh. Lungthin ponae senehmaica ao roinae hmuen koe ao roi. ");
INSERT INTO cth_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ka muitha ni ahnimouh roi ni hro e hno dawk kâen mahoeh. Kaie bawilennae ni ahnimouh kamkhuengnae dawk bawk van mahoeh. Ahnimouh ni a lungkhuek teh tami a thei awh, ma ngainae pâlei teh khonaw a raphoe awh toe. ");
INSERT INTO cth_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Ahnimouh lungkhueknae hah thoebonae lah awm naseh. Bangkongtetpawiteh, puenghoi a thasai. Ahnimouh lungkhueknae teh thoebo lah awm seh, bangkongtetpawiteh a kâoup awh. Jakop miphun Isarel catoun thung vah ahnimouh kâkayei sak han. ");
INSERT INTO cth_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Oe Judah nang teh, hmaunawnghanaw ni pholen e lah na o han. Na kut teh na tarannaw e lahuen dawk na toung han. Na pa e capanaw ni na hmalah a tabut awh han. ");
INSERT INTO cth_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah teh sendektanca doeh. Ka capa ni moi kei nah koehoi na luen takhai hnukkhu, sendek hoi sendekmanu patetlah ka kâva ni teh ka kamkawn e hah apinimaw a pâhlaw ngam han. ");
INSERT INTO cth_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Siangpahrang sonron ni Judah tâcawt takhai mahoeh. Kâlawk kapoekung hai a khok rahak hoi kahmat mahoeh. Shiloh a tho hoehroukrak teh miphun pueng ni a lawk a ngai pouh han. ");
INSERT INTO cth_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ahnie lanaw hah misurkung dawk a pen teh, lacanaw hah misurkung kahawi e dawk a pen. A hni hah misurtui dawk a pâsu teh a khohna hah misur thi dawk a pâsu. ");
INSERT INTO cth_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A mit teh misurtui hlak a paling teh, a hâ teh sanutui hlak a pangaw. ");
INSERT INTO cth_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun teh long kâhatnae talî teng kho a sak han. Long kâhatnae hmuen lah ao han. A khori teh Zidon totouh han. ");
INSERT INTO cth_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issakhar teh mon rahak ka tabawk e a tha kaawm poung e doeh. ");
INSERT INTO cth_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Kâhatnae hah ahawi telah a pouk teh, a ram hah a nawm telah a pouk. Hno phu hanlah a loung a rahnoum sak teh, sannaw lah a coung awh. ");
INSERT INTO cth_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan ni a taminaw hah Isarel miphun rahak vah miphun buet touh patetlah lawkceng han. ");
INSERT INTO cth_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan teh lam dawk kaawm e tahrun doeh. Marang kâcui e tami hnuklah rawp sak hanlah lam rahak ao teh, marang khok ka khuek e hrunthoe doeh. ");
INSERT INTO cth_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oe BAWIPA, na rungngangnae teh ouk ka ngaihawi. ");
INSERT INTO cth_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad teh tarannaw ni tuk vaiteh, ahni ni hai bout a tuk van han. ");
INSERT INTO cth_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher teh canei koelah tawnta vaiteh, siangpahrang canei hanlah a tâco sak han. ");
INSERT INTO cth_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali teh sayuk patetlah dawkcawk vaiteh, lawk kahawi a dei han. ");
INSERT INTO cth_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph teh a paw kara e a kang lah ao teh, a kangnaw teh rapan naw dawk a yam han. ");
INSERT INTO cth_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Licung kathoumnaw ni puenghoi a lungmathoe sak awh han. A ka awh teh a maithoe awh han. ");
INSERT INTO cth_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Hatei ahnie licung teh a thayoun hoeh. Jakop Cathut e thaonae kut hoi thao sak e lah ao, Isarel ka khoum lungsong pawlawk lahoi yah, ");
INSERT INTO cth_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","na Cathut teh nang kabawm hane hoi Athakasaipounge ni teh talai hoi kalvan yawhawi hoi sanu hoi camo im yawhawi, nang yawhawi poe hanelah tha ao sak e doeh. ");
INSERT INTO cth_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Na pa e yawhawi na poe e ni mintoenaw e yawhawi poe e hlak a yungyoe mon pout totouh, hotnaw teh Joseph e lû dawk ao vaiteh, a hmaunawnghanaw thung hoi kapek e tami koe ao han. ");
INSERT INTO cth_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin teh Asui patetlah doeh ao. Amom vah a kei e moi a ca vaiteh, tangmin vah lawphno hah a thokhai han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Hetnaw teh Isarel miphun hlaikahni touh lah ao awh teh, hethateh a na pa ni ahnimouh koe a dei pouh e lawknaw doeh. Yawhawi a poe teh yawhawi a poe e patetlah buet touh hnukkhu buet touh yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hahoi kai teh, ka mintoenaw koe ceikhai e lah ka o han toe. Hit tami Ephron lawhmuen dawk e talungkhu, Kanaan ram e Mamre hma lae Makpelah law e talungkhu, Abraham pakawpnae phuen, ");
INSERT INTO cth_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hit tami Ephron koevah lawhmuen khuehoi ran e dawk ka mintoenaw koe na pakawp awh loe. ");
INSERT INTO cth_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hawvah Abraham hoi a yu Sarah a pakawp awh teh, hawvah Isak hoi a yu Rebekah a pakawp awh teh, hawvah Leah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Lawhmuen hoi a thung e talungkhunaw teh Heth naw koehoi ran e doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Hottelah Jakop ni a canaw lawk he a thui hnukkhu, a khok hah ikhun dawk a taphawng teh a due teh, mintoenaw koe a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Hat navah Joseph ni a na pa e mithmai a tabo sin teh ka laihoi a pahnuep. ");
INSERT INTO cth_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Joseph ni tâsibawinaw hah a na pa e ro pawk hoeh nahanlah tâsi hluk hane kâ a poe. Hatdawkvah, tâsibawinaw ni Isarel e ro teh a pawk hoeh nahanlah tâsi a hluk awh. ");
INSERT INTO cth_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","A ro a rakuengnae dawk hnin 40 touh a ro. Bangkongtetpawiteh, ro a pawk thai hoeh nahanlah rakuengnae dawk hottelah ouk a ro. Hahoi, hnin 70 touh thung Izipnaw a khuika awh. ");
INSERT INTO cth_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ahni khuinae hnin a baw totouh, Joseph ni Faro imthungkhu koe a dei pouh teh, na lung ka youk pawiteh, pahren lahoi Faro hnâthai vah, ");
INSERT INTO cth_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Apa ni lawk na kam sak, khenhaw! ka due han toe, Kanaan ram phuen ka ran tangcoung e dawk, haw vah na pakawm loe, telah ati. Hatdawkvah, pahren lahoi apa heh na pakawm sak ei, bout ka ban han ati, telah na dei pouh awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faro ni, thoe na bo sak e patetlah na pa teh pakawm, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Hatdawkvah, Joseph teh a na pa pakawp hanelah a cei. Faro e a sannaw pueng, imthungkhu dawk e kacue naw hoi Izip ram e kacuenaw pueng, ");
INSERT INTO cth_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph imthungkhunaw pueng, a hmaunaw hoi a na pa imthungkhunaw pueng hai a cei awh. A ca kanawnaw hoi tuhunaw hoi maitonaw teh Goshen ram dawk a ta awh. ");
INSERT INTO cth_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ahnimouh koevah, rangleng hoi marangransanaw hai a cei awh dawkvah, tamihupui lah ao. ");
INSERT INTO cth_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jordan namran e Atad cangkatinnae koevah a pha awh. Hote hmuen koe hnin sari touh thung a ka khai awh teh a tahungkhai awh. ");
INSERT INTO cth_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Hote ram Kanaan taminaw ni Atad cangkatinnae koe vah a yu ro a tahungkhai awh e a hmu awh teh, hetheh Izipnaw e tami kadout tahungkhai e kalenpoung doeh, telah ati awh. Hatdawkvah, hote hmuen teh 'Abel-mizraim' telah ati awh. Hot teh, Jordan namran lah kaawm e doeh. ");
INSERT INTO cth_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","A canaw ni kâ a poe e patetlah ahnimouh hanlah a sak awh. ");
INSERT INTO cth_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","A canaw ni Kanaan ram a kâenkhai awh teh Abraham ni kâpakawp nahane hmuen râw lah, Hit tami Ephron koehoi law a ran e Mamre kho hmalah kaawm e Makpelah law e lungngoum thung vah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","A na pa a pakawp awh hnukkhu, Joseph hoi a hmaunaw hoi a na pa pakawpnae koe kacetnaw pueng hoi cungtalah Izip ram lah a ban awh. ");
INSERT INTO cth_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Joseph e hmaunaw ni a na pa a due e hah a hmu navah, Joseph ni na hmawt ngai awh hoeh vaiteh, ahni koe sak awh e hnokahawi hoeh e naw pueng hah moi koung na pathung han vaimoe, telah a kâti awh. ");
INSERT INTO cth_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hatdawkvah, Joseph koe dei hanelah tami a patoun awh teh, na pa ni a due hoehnahlan vah, hettelah Joseph koe na dei pouh han. ");
INSERT INTO cth_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Nang lathueng yonnae a sak awh eiteh, pahren lahoi na hmaunaw e kâtapoenae hoi a yonnae teh ngaithoum loe, telah kâ na poe. Hatdawkvah, na pa Cathut e sannaw e kâtapoenae hah ngaithoum pouh, telah ati. Ahni koe a dei pouh navah, Joseph teh a ka. ");
INSERT INTO cth_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","A hmaunaw ni hai a cei awh teh a hmalah tabo laihoi khenhaw! na sannaw lah ka o awh, telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph ni ahnimouh koevah, taket awh hanh awh, Bangkongtetpawiteh, Cathut e yueng lah maw ka o. ");
INSERT INTO cth_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nangmouh ni ka lathueng vah, hawihoehnae hah sak han na kâcai awh, hateiteh, Cathut ni sahnin vah tami moikapap hringnae rungngang hanelah hawinae hah sak han noenae lah ao. ");
INSERT INTO cth_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Hatdawkvah, taket awh hanh. Nangmouh hoi na canaw teh pou na kawk awh han, telah atipouh. Hottelah lungmawng sak teh lawk kahawi hoi a pato. ");
INSERT INTO cth_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph teh ama hoi a na pa imthungkhunaw hoi Izip ram vah kho a sak awh. Joseph teh kum 110 touh a hring. ");
INSERT INTO cth_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph ni Ephraim e a canaw, a na mincanaw hoi se thum totouh e a hmu. Manasseh capa, Makhir canaw hai Joseph e khokpakhu dawk a khe awh. ");
INSERT INTO cth_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph ni a hmaunawnghanaw koe, ka due han toe, hateiteh, Cathut ni na khet han. Hete ram dawk hoi na tâcokhai awh vaiteh, Abraham, Isak hoi Jakop koe thoebo hoi lawkkam e ram dawk na ceikhai awh han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hatdawkvah, Joseph ni Isarel catounnaw hah lawkkamnae a sak teh, Cathut ni na khet awh roeroe han. Ka hru hah hete hmuen koehoi na ceikhai awh han, telah ati. ");
INSERT INTO cth_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hatdawkvah, Joseph teh kum 110 touh a pha nah a due. A ro teh kapawk thai hoeh lah a sak awh teh Izip e thingkong buet touh thungvah a ta awh. ");
INSERT INTO cth_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Izip ram vah Jakop hoi cungtalah, amamae imthungnaw ka phat awh e Isarelnaw teh; ");
INSERT INTO cth_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, Simeon, Levih hoi Judah, ");
INSERT INTO cth_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issakhar, Zebulun hoi Benjamin, ");
INSERT INTO cth_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad hoi Asher, ");
INSERT INTO cth_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Jakop canaw abuemlah tami 70 touh a pha awh. Joseph teh Izip ram vah yo la ao toe. ");
INSERT INTO cth_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph hoi a hmaunawnghanaw senae taminaw pueng teh koung a due awh toe. ");
INSERT INTO cth_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Isarelnaw teh ca moi a pungdaw awh, a thao awh teh ram pueng dawk kho a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Hathnukkhu, Izip ram dawk Joseph ka panuek hoeh e siangpahrang katha a tâco. ");
INSERT INTO cth_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Hote siangpahrang ni hai Isarelnaw teh maimanaw hlak apap awh, a thasai awh. ");
INSERT INTO cth_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tho awh, lungangcalah hoi ahnimouh lathueng hno sak awh sei. Nahoeh pawiteh, ahnimouh teh hoe pungdaw awh vaiteh, hmalah tarankâtuknae awm pawiteh, maimae tarannaw koe lah kambawng awh vaiteh, maimouh hah na tuk vaiteh ram dawk hoi a yawng awh han doeh telah a taminaw koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hatdawkvah, Izip bawinaw ni puenghoi rektap hanelah kaukkung a ta pouh. Isarel taminaw teh hno pâtung nahanlah Pithom khopui hoi Raameses khopui hah a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Hateiteh, rektapnae hoehoe a khang awh e patetlah hoehoe a pungdaw awh. Ahnimouh kecu dawk Izipnaw teh a lungpuen awh. ");
INSERT INTO cth_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Pueng hoi hoe a rektap awh. ");
INSERT INTO cth_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Talung bonae hoi amhru saknae koe, law thawnaw pueng dawk puenghoi a tawk sak awh teh a tawk e tangkuem dawk nget ka tawn lah a tawk sak awh. ");
INSERT INTO cth_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Izip siangpahrang ni Hebru tami, camo ka khe sak roi e kahni touh, Siphrah hoi Puah koevah, ");
INSERT INTO cth_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","nangmouh roi ni Hebru napuinaw e camo khe sak roi nateh, a khenae hmuen koe na ring roi navah, ca tongpa khe pawiteh thet, napui khe pawiteh pâhlung roi haw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Camo kakhesak roi e ni Cathut a taki dawkvah, Izip siangpahrang e kâpoe e patetlah sak laipalah ca tongpa hah a pâhlung roi. ");
INSERT INTO cth_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Izip siangpahrang ni hai camo kakhesak e roi a kaw teh, nangmouh roi ni bangkongmaw camo tongpanaw na pâhlung roi telah a pacei navah, ");
INSERT INTO cth_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ahnimouh roi ni Hebru napuinaw teh Izip napuinaw patetlah awm awh hoeh. Ahnimouh teh cao a yawi dawkvah, camo kakhesak e a tho hoeh nah camo yo a la khe toe telah atipouh roi. ");
INSERT INTO cth_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Hatdawkvah, Cathut ni camo kakhesak roi e lathueng vah, hawinae a sak pouh. Hote miphun haiyah a pungdaw awh teh a thao awh. ");
INSERT INTO cth_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Camo kakhesak e napui roi ni Cathut a taki roi dawkvah ahnimae imthungkhunaw hah a khetyawt roi. ");
INSERT INTO cth_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Faro siangpahrang ni hai Isarelnaw dawk ca tongpa khe e pueng teh Nai palang dawk tâkhawng naseh, Napui pâhlung awh naseh, telah a taminaw pueng koe lawk a thui. ");
INSERT INTO cth_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Hatnae tueng nah, Levih tami tongpa buet touh ni Levih tami napui a yu lah a la. ");
INSERT INTO cth_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Napui ni camo a vawn teh ca tongpa a khe. Hote ca tongpa teh meilam hawinae hah a manu ni a hmu dawkvah, thapa yung thum touh thung a hro. ");
INSERT INTO cth_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Hateiteh, a hro thai hoeh torei teh, lungpumkung hoi sak e thingkong hah a la teh tuipan hoi thingtapi hoi a patô hnukkhu, hote thingkong dawk camo a ta teh, Nai palang rai lah lungpum um vah a ta. ");
INSERT INTO cth_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","A tawncanu ni bangtelah vaimoe ao han vaiyoe tie panue han a ngai dawkvah ahlahnawnnae koehoi a tuet. ");
INSERT INTO cth_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Hat toteh, Faro canu teh tui kamhluk hanlah a tho. A sannunaw hoi tuipui rai lah a kâhlai awh navah, sumpanaw rahak vah thingkong a hmu teh la hanlah a sannu buet touh a patoun. ");
INSERT INTO cth_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Thingkong e a khuem a paawng awh navah, ka kap e camo hah a hmu. Pahrennae lungthin a tawn dawkvah hete camo teh Hebru camo doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Camo e a tawncanu ni nang hanlah camo ka cun hane Hebru napui kai ni ka cei vaiteh, na kaw pouh han na ou telah Faro siangpahrang e canu koe a pacei navah, ");
INSERT INTO cth_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Faro canu ni cet loe telah kâ a poe dawkvah, napuica ni a cei teh camo e a manu hah a kaw. ");
INSERT INTO cth_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Hathnukkhu, Faro siangpahrang e canu ni hete camo heh lat nateh kai hanlah na kawk pouh la a, aphu na poe han telah atipouh e patetlah hote napui ni camo hah a la teh a kawk. ");
INSERT INTO cth_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Camo a roung torei teh, Faro siangpahrang e canu koe a thak pouh teh, siangpahrang e canu ni a ca lah a ta teh, Mosi telah min a phung. Bangkongtetpawiteh, tui dawk hoi kai ni ka rasa e telah ati. ");
INSERT INTO cth_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Mosi teh a kum hruet a cue torei teh, amae a miphunnaw onae hmuen koe a cei teh, ahnimae thaw tawk e naw hah a khet. A miphun Hebru tami buet touh hah Izip tami ni a hem e a hmu navah, ");
INSERT INTO cth_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","A tengpam a khet teh apihai awm hoeh tie a panue navah, Izip tami hah a thei teh sadi dawk a pakawp. ");
INSERT INTO cth_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Atangtho bout a tâco navah, Hebru tami kahni touh a kâyue roi e a hmu teh, nang ni namamouh roi reira hah bangkongmaw na hem telah ka yue e tami hah a pacei. ");
INSERT INTO cth_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Hote tami ni apinimaw nang teh kaimouh lathueng vah lawkcengkung lah na ta. Izip tami na thei e patetlah kai hah na thei han na ngai maw telah atipouh. Hatnavah, Mosi ni amae hno a sak e hah a kamphawng toe telah a panue dawkvah a taki. ");
INSERT INTO cth_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Hote kamthang hah Faro siangpahrang ni a thai torei teh, Mosi thei hanlah a tawng. Mosi teh Faro siangpahrang koehoi a yawng teh, Midian ram vah kho a sak. Ahni teh, tuido teng a tahung navah, ");
INSERT INTO cth_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midian vaihma e canu sari touh teh a na pa e tu hoi hmaenaw tui pânei hanlah a tho awh teh tui a do awh hnukkhu, dokkonaw dawk tui a pakawi awh. ");
INSERT INTO cth_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Hatnavah, tukhoumnaw a tho awh teh, tu hoi hmaenaw hah a hrui awh. Hatnavah, Mosi ni a thaw teh, hote napuinaw koe lah ao teh tu hoi hmaenaw hah tui a pânei pouh. ");
INSERT INTO cth_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Hote napuinaw teh a na pa Reuel koe a pha awh navah, bangkong sahnin teh palang na tho awh bo telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ahnimouh nihaiyah Izip tami buet touh ni tukhoumnaw e kut dawk hoi na rungngang teh tui kakhoutlah a do teh tu hoi hmaenaw hah tui a pânei atipouh awh. ");
INSERT INTO cth_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","A na pa ni hai hote tami teh na maw ao. Bangkongmaw yout na ban takhai awh. Bu ca hanlah kaw awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Hottelah hoiyah Mosi teh ahnimouh hoi cungtalah o hanelah, a hnâbo hnukkhu Reuel ni a canu Zipporah hah Mosi hoi a kâpaluen sak. ");
INSERT INTO cth_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Hote napui ni ca tongpa a khe toteh Mosi ni Gershom telah min a phung. Bangkongtetpawiteh, kai teh ramlouk dawk imyin lah ka o toe telah ati. ");
INSERT INTO cth_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","A kumtha asaw toteh, Izip siangpahrang hai yo a due toe. Hattoteh Isarelnaw teh san lah ao awhnae koe a cingou khuika awh. Hottelah san lah onae koehoi khuika hramki e lawk teh Cathut koe a pha. ");
INSERT INTO cth_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Cathut ni ahnimae cingou khuika lawk teh a thai pouh. Hatnavah, Cathut ni Abraham, Isak, Jakop tinaw hoi lawkkam a sak e hah a pouk. ");
INSERT INTO cth_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Hatdawkvah, Cathut ni Isarelnaw hah a hmu teh, a panue. ");
INSERT INTO cth_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mosi ni Midian vaihma, a masei Jethro e tu hoi hmaenaw a khoum navah, thingyeiyawn e kanîloumlah a ceikhai teh, Horeb tie Cathut e mon koe a pha. ");
INSERT INTO cth_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Hatnavah, BAWIPA e kalvantami teh buruk dawk hoi ka tâcawt e hmaito lahoi a kamnue. Mosi ni a khet navah, hmai a to ei, buruk teh a kak hoeh e hah a hmu navah, ");
INSERT INTO cth_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Bangkongmaw buruk kang laipalah ao. Hete kângairu e hno heh ka cei vaiteh ka khet han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mosi ni a khet e BAWIPA ni a hmu navah, Mosi, Mosi telah buruk thung hoiyah a kaw. Mosi ni hai ka o telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Cathut ni hai hnai hanh. Na khokkhawm hah rading haw. Na kangduenae hmuen teh kathounge talai doeh. ");
INSERT INTO cth_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Kai teh nange na pa e Cathut, Abraham e Cathut, Isak e Cathut, Jakop e Cathut, doeh telah atipouh. Mosi ni Cathut teh a khet ngam hoeh dawkvah a minhmai a ramuk. ");
INSERT INTO cth_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","BAWIPA ni hai Izip ram kaawm e ka taminaw e a khang e rektapnae hah kai ni khei ka hmu toe. Ahnimouh thaw ka tawksak e bawinaw kecu dawk ahnimae hramnae lawk ka thai teh, reithai khangnae hai ka panue. ");
INSERT INTO cth_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ahnimouh teh Izip ram, Izip taminaw e kut dawk hoi ratang vaiteh, Kanaannaw, Hitnaw, Amornaw, Periznaw, Hivnaw hoi Jebusitnaw onae ram, sanutui hoi khoitui a lawngnae ram dawk hrawi hanlah kai ka kum. ");
INSERT INTO cth_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Atu haiyah, Isarelnaw khuika lawk kai koe a pha teh, Izipnaw ni ahnimouh rektapnae hai ka hmu toe. ");
INSERT INTO cth_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Hatdawkvah, atu cet leih. Nang teh ka tami, Isarelnaw hah Izip ram hoi hrawi tâcokhai hanlah, nang teh Faro siangpahrang koe kai ni na patoun han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mosi nihai, kai teh bang patet e tami lah maw ka o teh, Faro siangpahrang koe ka cei vaiteh, Isarelnaw hah Izip ram hoi hrawi tâcokhai han telah Cathut koe atipouh navah, ");
INSERT INTO cth_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Cathut ni atangcalah kai teh nang koe lah ka o han. Kai ni nang na patounnae mitnoutnae teh, nang ni hote taminaw hah Izip ram hoi hrawi tâcokhai hnukkhu, hete mon dawk Cathut na bawk han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mosi nihai, kai ni Isarelnaw onae hmuen koe ka pha teh, nangmae mintoenaw e Cathut ni kai teh nangmouh koe na patoun toe telah kai ni ka dei pawiteh, ahnimouh ni hote Cathut e min teh apimaw telah kai bout na pacei awh navah, bangtelamaw bout ka dei pouh han telah Cathut koe a pacei. ");
INSERT INTO cth_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Cathut ni hai KAI teh KAI doeh. KAI ka tet e ni kai teh nangmouh na onae hmuen koe na patoun toe telah Isarelnaw koe bout dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Cathut ni Mosi koe bout a dei pouh e teh, nangmae mintoenaw e Cathut, Abraham e Cathut, Isak e Cathut, Jakop e Cathut lah kaawm e BAWIPA ni kai teh nangmouh koe na patoun toe, telah Isarelnaw koe na dei pouh han. Hote min teh a yungyoe e ka min lah ao teh catounnaw ni pahnim hoeh nahanelah ao. ");
INSERT INTO cth_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Cet nateh Isarel kacuenaw hah pâkhueng nateh, nangmae mintoenaw e Cathut, Abraham e Cathut, Isak e Cathut, Jakop e Cathut lah kaawm e BAWIPA ni kai koe a kamnue teh, nangmouh na khet awh navah, Izip ram vah nangmouh lathueng bangmaw a sak awh tie kamcengcalah ka hmu awh toe. ");
INSERT INTO cth_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Izip ram vah na khang a e rucatnae dawk hoi nangmouh na ratang vaiteh, Kanaannaw, Hit naw, Amor naw, Periznaw, Hiv naw hoi Jebusitnaw ram, sanutui hoi khoitui a lawngnae ram dawk hrawi kâenkhai hanlah kai ni lawk ka kam telah ahnimouh koe dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ahnimouh ni nange lawk a ngâi awh vaiteh, nang ni Isarel kacuenaw hoi Izip siangpahrang koe na kâen vaiteh, Hebrunaw e BAWIPA Cathut teh kaimouh ni kâhmo awh toe. Ramke dawk hnin thum touh lam cei koe kamamae BAWIPA Cathut thuengnae sak thai hanelah, kâ na poe haw, telah na ti pouh han. ");
INSERT INTO cth_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Izip siangpahrang ni a thaonae kut laipalah teh, cei nahane kâ na poe awh mahoeh tie ka panue. ");
INSERT INTO cth_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Kai ni hai kut ka daw vaiteh, Izip ram dawk ka sak hane kaie kângairunae hoi hote ram teh runae ka poe han. Hathnukkhu, Izip siangpahrang ni nangmouh teh na tâco sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Hote miphun teh Izipnaw koe minhmai kahawi a hmu sak vaiteh, nangmouh ni na tâco awh navah, kuthrawng hoi na tâcawt awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bangkongtetpawiteh, napui pueng ni imri, amamae im dawk kaawm e koe sui ngun hoi khohnanaw a hei awh vaiteh, nangmae na canaw hah a pathoup awh vaiteh, Izipnaw e hnopai hah na lawp awh han telah Mosi koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mosi ni, ahnimanaw ni kai na yuem awh mahoeh, ka lawk hai ngâi awh mahoeh, BAWIPA ni nang koe kamnuek mahoeh telah a ti awh han doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","BAWIPA ni na kut dawk bang hno maw kaawm telah a pacei navah, sonron ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Talai dawk tâkhawng haw atipouh e patetlah a tâkhawng navah, sonron teh tahrun lah a coung teh, Mosi ni a yawng takhai. ");
INSERT INTO cth_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","BAWIPA ni na kut hoi a mai dawk man hottelah atipouh e patetlah Mosi ni a kut hoi a man navah, a kut dawk sonron lah bout a coung pouh. ");
INSERT INTO cth_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Hottelah, na sak pawiteh ahnimae mintoenaw e Cathut, Abraham e Cathut, Isak e Cathut, Jakop e Cathut lah kaawm e BAWIPA ni nang koe a kamnuenae hah hote taminaw ni a yuem awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","BAWIPA ni na kut na lungtabue thung tapu haw bout atipouh e patetlah a kut a lungtabue thung a tapu teh a rasa navah, a kut teh a hrikbei. ");
INSERT INTO cth_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Na kut hah na lungtabue dawk bout tapu atipouh e patetlah a kut a lungtabue dawk bout a tapu teh a rasa navah, hmaloe e patetlah bout a coung. ");
INSERT INTO cth_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Hote taminaw ni na yuem awh hoeh, hmaloe e mitnoutnae hai ngai awh hoehpawiteh, apâhni e mitnoutnae teh a yuem awh han. ");
INSERT INTO cth_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Hote mitnoutnae kahni touh e hah yuem awh hoeh, na lawk hai ngâi awh hoehpawiteh, Nai tui youn touh lat nateh a oung lah rabawk, hottelah tuipui dawk e la e tui teh talai kaphui dawk thi lah ao han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Hat navah Mosi ni BAWIPA koe Oe ka Bawipa, kai teh ha hoehnahlan hai na san koe lawk na dei hnukkhu hai lawk ka dei thai e lah kaawm hoeh. Lawkdei khokpakhak e lah ka o atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","BAWIPA ni hai tami e pahni apinimaw a sak. Lawka, hnâpang, mitdawn, mitang hah apinimaw a sak. Kai, BAWIPA ni ka sak e nahoehmaw. ");
INSERT INTO cth_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Hatdawkvah, atu cet leih. Na pahni dawk ka o vaiteh, nang ni bangtelamaw na dei han tie hah na cangkhai han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mosi ni Oe ka Bawipa, na ngai e tami e kut dawk mah poe lawih telah atipouh navah, ");
INSERT INTO cth_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","BAWIPA ni Mosi koe a lungkhuek teh Levih tami Aron teh na hmau nahoehmaw. Ahni teh lawk a dei thai tie ka panue. Ahni teh nang dawn hanelah a tho lahun. Na kâhmo torei a lunghawi han. ");
INSERT INTO cth_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Nang ni ahni hoi kâpan nateh, ahni ni a dei hane lawk hah ka poe han. Nange pahni dawk thoseh, ahnie pahni dawk thoseh, Kai ka o vaiteh nangmouh roi ni bangtelamaw na sak han tie na cangkhai han. ");
INSERT INTO cth_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ahni ni nange yueng lah a dei vaiteh, ahni teh nange pahni patetlah, nang hai ahnie Cathut patetlah na han. ");
INSERT INTO cth_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Nang ni mitnoutnaw na sak thai hanelah hete sonron haiyah, na kut dawk pou na sin han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mosi ni a masei Jethro koe a cei teh, Izip ram kaawm e ka miphunnaw ni paroup a hring rah maw telah khet hanelah, ahnimouh onae hmuen koe ka cei han telah a kâhei navah, Jethro ni lungmawngcalah hoi cet lawi bout atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Hat navah BAWIPA ni, Izip ram lah bout ban leih, nang na ka thet hane taminaw teh koung a due awh toe telah midian ram dawk Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Hat navah, Mosi ni a yu hoi capa kahni touh la a kâcui sak teh, Cathut e sonron hah a kut dawk a sin teh, Izip ram lah a ban. ");
INSERT INTO cth_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","BAWIPA ni hai nang ni Izip ram lah na ban teh na pha torei teh, na kut dawk Kai ni na poe e kângairu hnonaw pueng hah Faro siangpahrang hmalah sak pouh. Hottelah, na sak nakunghai, Kai ni ahni teh a lung ka pata sak vaiteh, ahni ni Isarel taminaw hah cetsak mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Hattoteh nang ni Faro siangpahrang koe BAWIPA ni Isarel teh ka camin doeh. ");
INSERT INTO cth_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Ka ca ni Kai na bawk thai nahanlah cetsak loe, na cetsak hoehpawiteh, na camin hai Kai ni ka thei han telah na ti pouh han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kahlawng a cei lahun nah, BAWIPA ni Mosi hah rim dawk a kâhmo teh thei hanlah a kâcai. ");
INSERT INTO cth_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Hat navah, Zipporah ni lungtaw a la teh a capa e vuensom a a pouh hnukkhu, a vâ e khok a nep pouh hnukkhu, atangcalah nang teh thipaling ka lawngsakkung vâ lah doeh na o telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hat navah, Mosi hah a ceisak. A yu ni vuensomanae yawhawinae kecu dawk nang teh kai koe thipaling na ka palawng e vâ lah na o telah atipouh nae doeh. ");
INSERT INTO cth_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","BAWIPA ni hai Mosi dawn hanelah kahrawng lah cet loe telah Aron koe atipouh e patetlah Aron ni a cei teh, Cathut e mon dawk Mosi hah a kâhmo teh a paco. ");
INSERT INTO cth_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mosi ni hai ama ka patoun e BAWIPA e lawknaw pueng thoseh, lawk a thui e mitnoutnaw thoseh, Aron koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Hote hmaunawngha kahni touh roi ni Isarel tami kacuenaw a pâkhueng roi hnukkhu, ");
INSERT INTO cth_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron ni Mosi koe BAWIPA e a lawknaw pueng bout a dei teh, taminaw e hmalah mitnoutnaw a kamnue sak. ");
INSERT INTO cth_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Hote taminaw ni hai a yuem awh. BAWIPA ni Isarel miphun hah a khetyawtnae thoseh, a khang awh e rektapnae thoseh, a hmu tie a thai awh toteh, a lûsaling awh teh a bawk awh. ");
INSERT INTO cth_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hathnukkhu, Mosi hoi Aron ni Faro siangpahrang koe a kâen teh Isarelnaw e BAWIPA Cathut ni ka taminaw teh kahrawng vah kai hane pawito hanlah patoun telah ati, atipouh. ");
INSERT INTO cth_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faro siangpahrang ni hai BAWIPA lawk a ngâi teh Isarelnaw ka ceisak nahanlah hote Cathut teh apimaw. BAWIPA tie ka panuek hoeh. Isarelnaw ka cetsak mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ahnimouh roi ni hai Hebrunaw e Cathut teh kaimouh hoi kâhmo awh toe. Thingyeiyawn hnin thum lamcei koe, kaimae BAWIPA Cathut bawk nahan kâ na poe haw. Nahoeh pawiteh lacik, kâtheikârawngnae hoi maimouh na rek han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Izip siangpahrang ni hai Mosi hoi Aron, nangmouh roi ni hete taminaw bangkongmaw thaw na pakak roi. Thaw koe cet nateh thaw tawk awh, atipouh. ");
INSERT INTO cth_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Hahoi, ram dawk hote taminaw moiapap awh. Thaw tawk hoeh hanlah nangmouh ni kâ na poe bo aw telah Faro siangpahrang ni ati. ");
INSERT INTO cth_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hote hnin dawk, Faro ni thaw kakuennaw hoi kauknaw a kaw teh, ");
INSERT INTO cth_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Amhru sak nahane cakawng hmaloe e patetlah taminaw poe awh hanh. Ahnimouh ni cakawng hah amamouh hanlah tawng awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Amhru teh hmaloe e yit touh na saksak han. Payoun sak hanh. Ahnimouh teh a pangak awh dawkvah, cei awh vaiteh maimae Cathut thuengnae ka sak awh han telah ouk a hram awh. ");
INSERT INTO cth_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Hatdawkvah, thaw nget ka tawn lah a tawk sak awh. Tami kahawihoehe lawk ngâi a hanh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hahoi thaw kakuennaw ni a cei awh teh Faro siangpahrang ni cakawng na poe hoeh. ");
INSERT INTO cth_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Cakawng hah hmu thainae hmuen koe tawng awh. Hateiteh, na tawk hane thaw teh payoun mahoeh telah kâlawk ao telah taminaw a thaisak awh. ");
INSERT INTO cth_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Hatdawkvah, taminaw ni cakawng hanlah songnawng tawng hanelah Izip ram pueng dawk a kâkapek awh. ");
INSERT INTO cth_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Kauknaw ni hai cakawng hmuthainae a tue nah hnintangkuem a tawk awh e patetlah cum totouh tawk awh telah ahnimouh a hroecoe awh. ");
INSERT INTO cth_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Faro siangpahrang e kaukkungnaw ni a rawi e Isarel kahrawikungnaw hah nangmouh ni hmaloe na tawk a e patetlah bangkongmaw paduem hoi sahnin amhru sak e na cum sak awh hoeh telah atipouh teh a hemkhai awh. ");
INSERT INTO cth_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Hat navah, Isarel kahrawikungnaw ni Faro siangpahrang koe a cei awh teh, bangkongmaw nang ni na sannaw hettelah na sak. ");
INSERT INTO cth_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Na sannaw heh cakawng na poe hoeh. Kaukkungnaw ni hai amhru sak awh, telah ati awh teh kaimouh na hem awh. Na taminaw koe yonnae ao telah a hram awh. ");
INSERT INTO cth_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faro siangpahrang ni hai nangmouh teh na pangak awh. Na pangak awh. Hatdawkvah, kaimouh ka cei vaiteh BAWIPA thuengnae ka sak awh han telah nangmouh ni na ti awh. ");
INSERT INTO cth_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Hatdawkvah, atu cet awh nateh tawk awh. Cakawng na poe awh mahoeh. Hateiteh, amhru teh ama mingming lah pou na sak awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Hottelah, hnintangkuem a sak e amhru teh na payoun awh mahoeh telah kâ ao dawkvah Isarel kahrawikungnaw ni runae kâhmo awh toe tie a kâpanue awh. ");
INSERT INTO cth_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Faro siangpahrang koehoi a cei awh navah lam vah ahnimouh ka ring e Mosi hoi Aron a hmu awh navah, ");
INSERT INTO cth_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","BAWIPA ni nangmouh roi na khet teh lawk na ceng naseh. Bangkongtetpawiteh, Faro siangpahrang hoi a thaw katawknaw ni kaimouh na panuet sak han hoi thei sak hanlah nangmouh roi ni na sak toe telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mosi ni hai BAWIPA koe a cei teh, Oe Cathut, nang ni hete taminaw hah bangkongmaw na rektap. Bangkong kai hah na patoun. ");
INSERT INTO cth_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Kai ni nange kâ lahoi ka dei nahanlah Faro siangpahrang koe kâen hnin hoi kamtawng teh, ahni ni hete taminaw thoe a bo. Nang ni na taminaw khoeroe na rungngang hoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","BAWIPA ni Mosi koe, Kai ni Faro siangpahrang koe bangtelamaw ka sak han tie atu na panue han. Ahni ni thaonae kut a hmu vaiteh, ka taminaw a tâco sak han. Thaonae kut hmawt vaiteh ahnimouh teh a ram dawk hoi a pâlei han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Cathut ni Mosi koe bout a dei pouh e teh, Kai teh Jehovah doeh. ");
INSERT INTO cth_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Kai ni Abraham, Isak, Jakop tinaw koe, Athakasaipounge Cathut tie min lahoi ka kamnue pouh eiteh, ka min teh Jehovah lah ahnimouh ka panuek sak hoeh. ");
INSERT INTO cth_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ahnimouh ni a hmuen pueng koe a kâva awh teh, imyin lah onae Kanaan ram ahnimouh poe han ka tie lawkkam ka caksak toe. ");
INSERT INTO cth_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Izipnaw ni santoung sak e Isarelnaw e hramnae lawk ka thai toe. Ka lawkkam hah ka pahnim hoeh. ");
INSERT INTO cth_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Hatdawkvah, Isarelnaw koe a dei pouh hane lawk teh; Kai teh BAWIPA doeh. Kai ni nangmouh, Izipnaw e kut dawk hoi na tâco sak vaiteh, ahnimae rektapnae dawk hoi na rasa han. Kutdawnae, ka patawpoung lah reknae lahoi nangmouh teh na ratang awh han. ");
INSERT INTO cth_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ka tami hanlah na la han. Kai teh nangmae Cathut lah ka o han. Kai teh Izipnaw e kut dawk hoi na ka tâcawt sak e BAWIPA Cathut lah ka o e na panue awh han. ");
INSERT INTO cth_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Kai ni Abraham, Isak, Jakop ti koe poe hanlah lawk ka kam e ram dawk na hrawi awh vaiteh, râw lah na pang sak awh han. Kai teh BAWIPA doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Hottelah, Mosi ni Isarelnaw koe patuen a dei pouh eiteh, ahnimouh teh a lungthin puenghoi a pata awh teh, puenghoi rektapnae a khang awh dawkvah Mosi e lawk ngâi laipalah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","BAWIPA ni Izip siangpahrang Faro koe cet nateh, ");
INSERT INTO cth_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Ahni ni Isarelnaw hah a ram dawk hoi tâco sak hanlah dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mosi ni hai Isarelnaw ni patenghai ka lawk hah ngâi laipalah ao awh teh, vuensoma hoeh naw e pahni dawk hoi dei e kaie lawk hah Faro siangpahrang ni a ngai han namaw telah BAWIPA hmalah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hatdawkvah, BAWIPA ni Mosi hoi Aron teh Isarelnaw Izip ram hoi tâcokhai hanelah, a kaw teh Isarelnaw koe thoseh, Izip siangpahrang Faro koe thoseh a patoun. ");
INSERT INTO cth_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isarel kacuenaw e a minnaw teh; Isarel e camin Reuben e canaw teh Enok, Pallu, Hezron hoi Karmi. Het teh Reuben miphun lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon e canaw teh Jemuel, Jamin, Ohad, Jakhin, Zohar hoi Kanaan napui e capa Saw, hetnaw teh Simeon miphun lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levih e canaw teh Gershon, Kohath hoi Merari. Levih teh a kum 137 touh a hring. ");
INSERT INTO cth_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon e a ca roi teh Libni hoi Shimei lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath e a canaw teh Amram, Izhar, Hebron hoi Uzziel lah ao. Kohath teh a kum 133 touh a hring. ");
INSERT INTO cth_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari e a ca roi teh Mahli hoi Mushi lah ao. Hetnaw heh Levih miphunnaw lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ni a na pa e tawncanu Jokhebed a yu lah a la teh, Aron hoi Mosi a sak. Amram teh a kum 137 touh a hring. ");
INSERT INTO cth_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar e a canaw teh Korah, Nepheg hoi Zikhri lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel e a canaw teh Mishael, Elzaphan hoi Sithri lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron ni Elisheba, Amminadab canu, Nahshon tawncanu, a yu lah a la teh, Nadab, Abihu, Eleazar, hoi Ithamar hah a sak. ");
INSERT INTO cth_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah e a canaw teh Assir, Elkanah hoi Abiasaph lah ao. Hetnaw heh Korah miphunnaw lah ao. ");
INSERT INTO cth_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron capa Eleazar ni Putiel canu a yu lah a la teh, hot hoi Phinehas a sak pouh. Hetnaw heh Levih miphun dawk hoi e kacuenaw lah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","BAWIPA ni Isarelnaw Izip ram dawk hoi tâcawtkhai leih telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Isarel miphunnaw Izip ram hoi ka tâcotakhai hanelah, Faro siangpahrang koevah ka dei pouh hane tami teh Mosi hoi Aron doeh. ");
INSERT INTO cth_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","BAWIPA ni Izip ram vah Mosi koe a pâpho pouh e teh; ");
INSERT INTO cth_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Kai teh Jehovah doeh. Kai ni lawk na thui e pueng hah Izip siangpahrang Faro koe na dei pouh han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mosi ni, kai teh vuensoma hoeh e pahni ka tawn dawkvah, Faro siangpahrang ni ka lawk hah bangtelamaw a ngâi thai han telah BAWIPA hmalah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","BAWIPA ni Mosi koe, nang teh faro siangpahrang e cathut lah na o sak. Na hmau Aron teh na profet lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Kâ na poe e naw pueng hah nang ni bout na dei han. Faro siangpahrang ni Isarelnaw hah a ram dawk hoi a tâco sak nahanlah na hmau Aron ni ahni koe a dei pouh han. ");
INSERT INTO cth_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Kai ni hai Faro e lung ka pata sak vaiteh, Izip ram dawk kaie kângairu mitnoutnaw hah ka pung sak han. ");
INSERT INTO cth_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Hateiteh, Faro siangpahrang ni nangmae lawk hah ngâi laipalah ao han. Kai ni hai Izip ram lathueng ka kut ka dâw vaiteh, kalenpounge lacik hoi ka ransahu, ka tami Isarelnaw hah Izip ram hoi ka tâcokhai han. ");
INSERT INTO cth_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Hottelah, Izip ram lathueng ka kut ka dâw vaiteh, Isarelnaw ahnimouh koehoi ka tâcokhai toteh, Kai teh BAWIPA doeh tie Izipnaw ni a panue awh han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mosi hoi Aron ni BAWIPA e kâpoelawk patetlah a sak roi. ");
INSERT INTO cth_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Faro koe a dei pouh roi navah, Mosi teh a kum 80, Aron teh a kum 83 touh a pha roi. ");
INSERT INTO cth_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","BAWIPA ni Mosi hoi Aron koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Faro siangpahrang ni nangmouh koe kângairuhno na patue haw tetpawiteh, na sonron hah lat nateh a hmalah tâkhawng pouh telah Aron koe a dei pouh. Sonron haiyah tahrun lah a kangcoung han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mosi hoi Aron ni Faro siangpahrang koe a kâen roi teh BAWIPA ni a dei e patetlah a sak pouh roi. Aron ni Faro siangpahrang hoi a sannaw e hmalah sonron a tâkhawng teh tahrun lah a kangcoung. ");
INSERT INTO cth_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hat navah, Faro siangpahrang ni lungkaangnaw camkathoumnaw hah a kaw teh Izip ram e mitpaleikathoumnaw nihai, hot patetlah a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","A sin awh e sonronnaw hah a tâkhawng awh teh tahrun lah a kangcoung awh. Hateiteh, Aron e sonron ni ahnimae sonronnaw hah koung a payawp. ");
INSERT INTO cth_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","BAWIPA ni a dei e patetlah Faro siangpahrang teh a lungpata sak teh, ahnimae lawk hah ngâi laipalah ao. ");
INSERT INTO cth_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","BAWIPA nihai, Faro siangpahrang e lung a pata sak teh Isarelnaw hah tâcawt sak hoeh. ");
INSERT INTO cth_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Amom vah, Faro siangpahrang koe cet haw. Ahni ni tui namran lah a cei han. Ahni a pha hoehnahlan tuipui namran lah kangdout haw. Tahrun lah kangcoung e sonron hah na kut dawk sin haw. ");
INSERT INTO cth_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Hebru miphunnaw e Cathut Jehovah ni kaie taminaw ni kahrawng vah Kai na bawk hanelah, ahnimouh hah tâcawt sak leih telah kai heh nang koe na patoun toe. Nang ni atu totouh ngâi laipalah na o awh rah. ");
INSERT INTO cth_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","BAWIPA ni Kai teh BAWIPA doeh tie hah nang ni bangtelamaw na panue thai han tetpawiteh, ka sin e sonron hoi tuipui ka hem vaiteh hote tui teh thi lah a coung han. ");
INSERT INTO cth_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tuipui dawk kaawm e tanganaw a due awh han. Tuipui hai a hmui a tho han. Izipnaw ni tuipui tui a panuet awh han. Akong hah bout dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","BAWIPA ni Mosi koe bout a dei pouh e teh, Aron koe, na sonron sin nateh Izip ram kaawm e palang, tuipui, tuikamuem tui, tuido hoi tuiphueknaw pueng e lathueng vah kut dâw haw. Izip ram pueng dawk thing manang, talung hlaamnaw pueng dawk thi ao hane kong hah dei pouh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mosi hoi Aron ni BAWIPA ni a dei e patetlah a sak roi teh, Aron ni Faro siangpahrang hoi a sannaw e hmalah sonron a pho teh tuipui a hem teh tui pueng teh thi lah a coung. ");
INSERT INTO cth_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tuipui dawk kaawm e tanganaw hai a due. Tuipui teh a hmui a tho dawkvah Izip taminaw ni tuipui hah net thai awh hoeh. Izip ram pueng dawk thi hah koung ao. ");
INSERT INTO cth_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Izip miphun camkathoumnaw ni hai camthoumnae lahoi hottelah a sak awh. BAWIPA ni a dei tangcoung patetlah Faro siangpahrang teh a lungpata teh ahnimae lawk ngâi laipalah ao. ");
INSERT INTO cth_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faro teh a im a ban teh hote hnonaw hah a lungthin dawk tat hoeh. ");
INSERT INTO cth_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Hat navah, Izipnaw ni tuipui tui hah a nei thai awh hoeh dawkvah tui nei hane a hmu thai a nahanlah tuipui rai lah tui a tai awh. ");
INSERT INTO cth_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","BAWIPA ni tuipui a hem hnukkhu hnin sari touh aloum sak. ");
INSERT INTO cth_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","BAWIPA ni Mosi koe, nang ni Faro siangpahrang koe cet nateh Ka taminaw ni Kai na bawk nahanelah tâcawt sak leih. ");
INSERT INTO cth_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ka tâcawt sak mahoeh tetpawiteh na ram pueng ekka hoi bout ka rek han rah. ");
INSERT INTO cth_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Tuipui ni ekka moi a tâco sak vaiteh na im dawk, inae rakhan dawk, ikhun van thoseh, na sannaw e im dawk thoseh, na taminaw e a lathueng thoseh, na takhuen dawk thoseh, tavai na kanawknae kawlung dawk thoseh a luen han. ");
INSERT INTO cth_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Nangmouh koehoi kamtawng vaiteh na taminaw, na sannaw pueng lathueng vah a luen awh han telah BAWIPA ni a dei e hah thaisak loe telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","BAWIPA ni Mosi koe bout a dei pouh e teh, Aron ni palang, tuipui tui, talînaw e lathueng vah sonron a sin teh kut a dâw navah, Izip ram dawk ekkanaw luen sak hanelah dei pouh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aron ni Izip ram dawk kaawm e tuinaw lathueng kut a dâw teh ekkanaw ni a tho teh Izip ram pueng koung a ramuk. ");
INSERT INTO cth_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Camkathoumnaw ni hai camthoumnae lahoi hottelah a sak teh ekkanaw Izip ram dawk a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Hat navah, Faro siangpahrang ni Mosi hoi Aron a kaw teh, BAWIPA ni ekkanaw hah kai hoi ka taminaw koehoi takhoe hanelah dei pouh leih. Isarelnaw ni BAWIPA koe thuengnae kâ ka poe han toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mosi ni hai nang hoi na imnaw dawk hoi ekkanaw takhoe teh, tuipui dawk dueng o sak hanlah, nang hoi na sannaw, na taminaw hanlah, kai ni ngaithoumnae tueng na khoe atipouh eiteh, ");
INSERT INTO cth_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","tangtho ngaithoumnae het leih atipouh teh, Mosi ni kaimae Cathut Jehovah hoi kâvan e cathut awm hoeh tie na panue nahanlah na dei e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ekkanaw teh nang hoi na imnaw, na sannaw, na taminaw koehoi a tâco teh tuipui dawk dueng ao han telah Mosi ni a dei pouh hnukkhu, ");
INSERT INTO cth_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Aron hoi cungtalah ahni koehoi a tâco roi teh, Faro siangpahrang e lathueng vah a pha sak e ekkanaw kecu dawk Mosi ni a ratoum. ");
INSERT INTO cth_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mosi ni a hei e patetlah BAWIPA Cathut ni a sak pouh teh, ekkanaw teh imnaw, khonaw, ayawnnaw dawk a due awh. ");
INSERT INTO cth_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","A ronaw a pâkhueng awh dawkvah ram pueng dawk a hmui a tho. ");
INSERT INTO cth_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Faro siangpahrang ni ahawi toe ti a panue navah, BAWIPA ni a dei e patetlah a lungpata teh ahnimae lawk hah ngâi laipalah bout ao. ");
INSERT INTO cth_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","BAWIPA ni Mosi koe bout a dei pouh e teh, Izip ram e vaiphunaw pueng heh tangkarang lah o sak hanelah Aron ni sonron a pho teh vaiphu hah hem hanelah dei pouh atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aron ni sonron a pho teh vaiphu hah a hem. Vaiphu teh tami dawk thoseh, saring koe thoseh, tangkarang lah ao. Izip ram pueng dawk kaawm e vaiphunaw pueng teh tangkarang lah a coung. ");
INSERT INTO cth_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","mitpaleikathoumnaw ni hai tangkarang lah coung sak hanelah a thoumnae lahoi hottelah a sak a eiteh sak thai awh hoeh. Hatdawkvah, tami hoi saringnaw pueng dawk tangkarangnaw ao. ");
INSERT INTO cth_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Hat navah, mitpaleikathoumnaw ni hote hno heh Cathut e kutdawn doeh telah Faro siangpahrang koe a dei pouh awh. Hateiteh, BAWIPA ni a dei e patetlah Faro siangpahrang teh a lungpata teh ahnimae lawk hah ngâi laipalah bout ao. ");
INSERT INTO cth_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","BAWIPA ni hai nang ni amom thaw haw. Tui namran lah ka cet e Faro siangpahrang hmalah kangdout nateh BAWIPA ni, ka taminaw ni Kai na bawk nahanelah cetsak leih. ");
INSERT INTO cth_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na cetsak hoehpawiteh, nang hoi na sannaw, taminaw, imnaw dawkvah bitsei hah kai ni ka patoun vaiteh Izipnaw onae im, kangduenae talai teh bitsei hoi akawi han. ");
INSERT INTO cth_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kai teh talai van pueng dawk BAWIPA lah ka o e na panue thai nahanelah kaie taminaw onae Goshen ram dawk teh hote hnin nah kapek vaiteh, hote ram dawk bitsei awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Hottelah ka taminaw hoi na taminaw rahak vah kapeknae ka o sak han. Tangtho vah hete mitnoutnaw teh ao han tie heh dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hottelah BAWIPA ni a sak dawkvah Faro im hoi a kamtawng teh a sannaw e im hoi Izip ram pueng dawk bitsei moikapap a tho teh, hote bitseinaw kecu dawk Izip ram a rawk. ");
INSERT INTO cth_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Hat navah, Faro siangpahrang ni Mosi hoi Aron a kaw teh, nangmouh ni hote ram dawk na Cathut koe thuengnae sak hanelah cet awh telah ati eiteh, ");
INSERT INTO cth_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mosi ni hettelah sak hane nahoeh. Ka sak awh pawiteh, Izipnaw ni a panuet e hno hoi BAWIPA Cathut koe thuengnae ka sak awh han nahoehmaw. Izipnaw e mithmu vah ahnimouh hanlah panuettho e hno hoi thuengnae ka sak awh boipawiteh, talung hoi na dei awh mahoeh na maw. ");
INSERT INTO cth_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Hatdawkvah, kahrawng hnin thum lamcei koe, ka cei awh vaiteh kaimae BAWIPA Cathut ni a dei e patetlah thuengnae ka sak awh han telah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faro siangpahrang ni hai nangmae BAWIPA Cathut hah kahrawng vah na thueng awh nahanelah na cei awh han. Hatei, kahlat lah na cet awh mahoeh. Kai hanlah na kâhet pouh ei telah ati. ");
INSERT INTO cth_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mosi ni hai nang koehoi kai ni ka cei vaiteh bitseinaw ni Faro siangpahrang hoi a sannaw, taminaw koehoi tangtho a tâco hanelah BAWIPA koe ka kâhei han. Hateiteh, Isarelnaw ni BAWIPA koe thueng hane bout na pasoung laipalah na dum awh hanh telah a dei pouh hnukkhu, ");
INSERT INTO cth_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mosi ni Faro koehoi a tâco teh, BAWIPA koe a kâhei pouh. ");
INSERT INTO cth_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","BAWIPA ni hai Mosi lawk a ngâi teh, Bitseinaw hah Faro siangpahrang hoi a sannaw, a taminaw koehoi buet touh boehai ao hoeh nahanlah a takhoe pouh. ");
INSERT INTO cth_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Hatnae tueng dawk haiyah, Faro siangpahrang lung bout a pata sak teh, Isarelnaw hah tha ngai laipalah bout ao. ");
INSERT INTO cth_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","BAWIPA ni Mosi koe, Faro siangpahrang koe cet nateh dei pouh, Hebrunaw e Cathut Jehovah ni, ka taminaw ni Kai koe thuengnae a sak awh hanelah tâcawt sak leih. ");
INSERT INTO cth_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ka cetsak mahoeh telah na cakâ rah boi pawiteh, ");
INSERT INTO cth_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","BAWIPA e thaonae kut teh ayawn e kaawm saring, marang, la, kalauk, tu, hoi maitonaw lathueng ka patawpoung e lacik ka pha sak han. ");
INSERT INTO cth_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","BAWIPA ni Isarelnaw e saring hoi Izipnaw e saring rahak kapeknae a tawn vaiteh Isarelnaw e saring teh buet touh boehai dout mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Bawipa ni tueng a khoe e patetlah tangtho vah BAWIPA ni hete ram dawk a sak han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","A tangtho vah hote hno a sak teh, Izipnaw e saringnaw pueng koung a due. Hatei, Isarelnaw e saringnaw teh buet touh boehai dout hoeh. ");
INSERT INTO cth_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faro siangpahrang ni tami a patoun teh, Isarelnaw e saring buet touh boehai dout hoeh tie a panue. hat ei, a lung bout a pata teh Isarelnaw tâcawt sak hoeh. ");
INSERT INTO cth_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Bawipa ni takhuen dawk e hraba kut hoi pham nateh, Mosi ni Faro siangpahrang hmalah kahlun lah kahei naseh. ");
INSERT INTO cth_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Hote hraba teh Izip ram pueng dawk vaiphu dikkaneng e lah ao vaiteh, ram pueng dawk e tami hoi moithangnaw koe parep hoi kakawi e patawnae kathout lah ao han telah Mosi hoi Aron koe a dei pouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","ahnimouh roi ni takhuen dawk e hraba hah a pham teh Faro hmalah kangdue teh kahlun lah Mosi ni a kahei. Hote hraba teh tami hoi moithangnaw dawk parep hoi kakawi e yako patawnae lah ao. ");
INSERT INTO cth_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Mitpaleikathoumnaw ni yako kecu dawk Mosi hmalah kangdout ngam awh hoeh. Hote yako teh mitpaleikathoumnaw koe thoseh, Izip taminaw koe thoseh, koung a kâkai. ");
INSERT INTO cth_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","BAWIPA ni Faro siangpahrang e lung a pata sak dawkvah, Mosi koe a dei pouh e patetlah ahnimae lawk hah ngâi laipalah ao. ");
INSERT INTO cth_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","BAWIPA ni Mosi koe, amom thaw nateh Faro hmalah kangdout nateh Hebrunaw e Cathut Jehovah ni, ka taminaw ni Kai na bawk thai nahanelah tâcawt sak leih. ");
INSERT INTO cth_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Na hoehpawiteh, atu e tueng dawk teh, nang hoi na sannaw koe thoseh, na taminaw koe thoseh, Kaie reknae ka pha sak han. Kai patetlah e talai van pueng dawk awm hoeh tie hah na panue han. ");
INSERT INTO cth_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ka kut ka dâw vaiteh nang hoi na taminaw hah lacik hoi ka rek han. Nang haiyah talai dawk hoi takhoe lah na o han. ");
INSERT INTO cth_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Atangcalah, ka hnosakthainae hah nang patue hanelah, talai van pueng dawk ka min kamsawng nahanelah Kai ni nang teh na tawm toe. ");
INSERT INTO cth_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Nang ni ka taminaw tâcawt sak laipalah na rektap rah maw. ");
INSERT INTO cth_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Khenhaw! Izip ram kamtawngnae koehoi atu totouh kabawt boihoeh e roun, tangtho atu e tueng dawk puenghoi ka rak sak han. ");
INSERT INTO cth_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Hatdawkvah, kahrawng kaawm e saringnaw hoi kaawm e pueng pakhum sak leih. Im na pakhum hoehpawiteh ayawn dawk hmu e tami pueng hoi saringnaw pueng, roun ni bawt sin vaiteh, koung a due awh hane hah dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","BAWIPA e lawk ka taket e Faro siangpahrang e a sannaw teh a san hoi a saringnaw im lah a yawng sak. ");
INSERT INTO cth_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","BAWIPA e lawk banglahai ka ngai hoeh e taminaw teh a sannaw hoi a saringnaw teh ayawn dawk a ta awh. ");
INSERT INTO cth_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","BAWIPA ni Izip ram kho ka sak tami pueng lathueng thoseh, saringnaw pueng lathueng thoseh, ayawn dawk e thingkung pueng lathueng thoseh, roun a bo nahanelah na kut kahlun lah dâw telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mosi ni a sonron kahlun lah a dâw navah, BAWIPA ni keitat hoi roun a patoun. Hmai hai talai dawk a bo. Hottelah BAWIPA ni Izip ram dawk, roun a bo sak dawkvah, ");
INSERT INTO cth_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Izip ram kamtawngnae koehoi vai touh hai ka bawt boihoeh e hmai hoi kâkalawt e roun puenghoi a bo. ");
INSERT INTO cth_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Izip ram pueng, ayawn dawk kaawm e tami hoi saringnaw, phonaw, thingkungnaw pueng teh roun ni reprep a dei. ");
INSERT INTO cth_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Hateiteh, Isarelnaw khosaknae Goshen ram dawk dueng doeh roun bawt hoeh. ");
INSERT INTO cth_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Hat navah, Faro ni Mosi hoi Aron kaw hanlah tami a patoun. Hete hno dawk kai ka yon toe. BAWIPA teh a lan. Kai hoi ka taminaw teh ka yon awh. ");
INSERT INTO cth_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","A khout toe. Athakaawme keitat hoi roun puenghoi ka bawt e dap sak hanlah BAWIPA koe kâhet leih. Kai ni nangmouh ngang laipalah karanglah na ceisak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mosi ni hai khopui thung ka cei nah BAWIPA hmalah ka kut ka dâw han. BAWIPA ni talai pui a uk tie nang panue sak hanelah kei hoi roun ka bawt e a roum sak han. ");
INSERT INTO cth_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Hateiteh, nang hoi na sannaw ni BAWIPA Cathut na taket awh hoeh rah tie ka panue telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Pahla hoi catun hai roun ni a dei. Catun teh a paw hoi akawi. Pahla haiyah a paw a tang toe. ");
INSERT INTO cth_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Catun hoi cang teh a pâw hoeh rah dawkvah roun ni dêi hoeh. ");
INSERT INTO cth_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mosi ni Faro koe khopui alawilah a cei hnukkhu, BAWIPA hmalah kuttabei a na teh, keitat hoi roun teh a roum. Talai kho hai rak hoeh toe. ");
INSERT INTO cth_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Hottelah, kho a dep, keitat hoi roun ka bawt e hai a roum e Faro siangpahrang ni a hmu navah, bout a yon awh teh a sannaw hoi a lung bout a pata awh. ");
INSERT INTO cth_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Faro siangpahrang a lung bout a pata sak dawkvah, BAWIPA ni Mosi koe a dei pouh e patetlah Isarelnaw tâcawt sak laipalah bout ao. ");
INSERT INTO cth_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","BAWIPA ni Mosi, Faro koe cet nateh Kai ni hete mitnoutnaw heh ahnie hmalah patue hane lah, ");
INSERT INTO cth_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Izip ram dawk ka sak e hnonaw hoi Izip taminaw koe ka sak e mitnoutnaw heh, na ca catounnaw koe na dei pouh teh, Kai teh Jehovah doeh tie nangmouh ni na panue awh nahanelah thoseh, ahni hoi a sannaw e lung teh Kai ni ka pata sak telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mosi hoi Aron ni Faro siangpahrang koe a kâen roi teh Hebrunaw e Cathut Jehovah ni, nang ni ka hmalah na kârahnoum laipalah na sittouh maw na o han rah. Ka taminaw ni Kai na bawk na hanelah tâcawt sak leih. ");
INSERT INTO cth_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ka taminaw na tâcawt sak hoehpawiteh, khenhaw! na ram dawk tangtho samtongnaw ka patoun han. ");
INSERT INTO cth_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Talai kamnuek laipalah ahnimouh ni talai muen a ramuk awh han. Roun ni be a dêi hoeh e kaawm rae naw pueng thoseh, nangmouh hanlah talai dawk kapâw e a kung pueng thoseh a ca awh han. ");
INSERT INTO cth_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Na mintoenaw talai dawk khosak kamtawngnae koehoi atu totouh a hmu awh boihoeh e hah na imnaw, na sannaw e imnaw, Izipnaw e imnaw dawk akawi awh han telah a dei pouh roi hnukkhu Faro koehoi a kamlang roi teh a tâco roi. ");
INSERT INTO cth_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Faro siangpahrang e a sannaw ni hai hete taminaw ni maimouh na totouh maw na tarawk awh han. Hote taminaw ni amamae Cathut Jehovah koe thueng hanelah tâcawt sak leih. Izip ram a rawk e heh na panuek hoeh rah maw telah a dei pouh navah, ");
INSERT INTO cth_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mosi hoi Aron hah Faro siangpahrang koe bout a kâen sak awh teh, nangmae Cathut Jehovah thueng hanelah tâcawt awh. Hateiteh, apipi maw na ka cet awh han telah a pacei navah, ");
INSERT INTO cth_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mosi ni, kaimouh teh camo, matawng, ka capanaw, ka canunaw, tu hoi maitonaw hoi ka cei awh han. Bangkongtetpawiteh, BAWIPA koe pawito han ao telah bout atipouh navah, ");
INSERT INTO cth_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faro siangpahrang ni nangmouh hoi na canaw teh kai ni na tâco sak e patetlah BAWIPA teh nangmouh koe awm naseh. Kâhruetcuet awh. Kahawi hoeh e pouknae na tawn awh boma. ");
INSERT INTO cth_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hottelah mahoeh. Hmaloe na hei e patetlah tongpa dueng cet awh nateh BAWIPA Cathut bawk awh, telah atipouh teh ahnimouh teh ama koehoi a pâlei. ");
INSERT INTO cth_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","BAWIPA ni samtongnaw hah Izip ram dawk a patoun teh roun ni a dêi nawi e talai dawk kaawm rae akungnaw pueng ca sak hanelah, Izip ram lah na kut dâw telah Mosi koe atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mosi ni a sonron hah Izip ram lathueng vah a dâw teh, hote kanîruirui, karum tuettuet Kanîtholah hoi BAWIPA ni kahlî a tho sak teh, amom torei teh Kanîtholae kahlî ni samtongnaw hah a thokhai. ");
INSERT INTO cth_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Hote samtong ni Izip ram pueng muen a ramuk teh ramrinaw pueng dawk a kâhat awh teh moiapap awh. Hote samtongnaw teh ayan hoi atu totouh awm boihoeh. Ao hnukkhu hai bout awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Talai pueng muen ka tamang lah a ramuk teh ram pueng dawk e phovai kaawm pueng, roun ni a dêi nawi e a paw kaawm e naw pueng a ca dawkvah, Izip ram pueng dawk kaawm e thingkung phokungnaw dawk kahring e banghai awm hoeh. ");
INSERT INTO cth_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Hat toteh, Faro siangpahrang ni Mosi hoi Aron hah karanglah a kaw teh, nangmae Cathut Jehovah koe thoseh, nangmouh koe thoseh ka yon toe. ");
INSERT INTO cth_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Hatdawkvah, atu vai touh ka yonnae ngaithoum ei. Nangmae BAWIPA Cathut ni het duenae lacik buet touh dueng kai koehoi takhoe hanelah na kâ pouh ei, atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mosi ni ahni koehoi a cei teh BAWIPA koe ngaithoumnae a hei. ");
INSERT INTO cth_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","BAWIPA ni a tha kaawm e kanîloumlae kahlî a patoun teh, hote kahlî ni samtongnaw hah a tawm teh thipaling talî dawk a pabo. Izip ram dawk samtong buet touh boehai awm hoeh. ");
INSERT INTO cth_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Hateiteh, BAWIPA ni Faro e a lung bout a pata sak dawkvah, Isarel canaw tâcawt sak laipalah bout ao. ");
INSERT INTO cth_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Hahoi, BAWIPA ni Izip ram dawk rumram e hmonae tho laipalah thupthup payam e hmonae o sak hanelah na kut kahlun lah dâw haw telah Mosi koe a dei pouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mosi ni a kut kahlun lah a dâw navah Izip ram pueng dawk kingkahmawt e hmonae hnin thum touh ao sak. ");
INSERT INTO cth_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hat navah, buet touh hoi buet touh hai kahmawt awh hoeh. Hnin thum touh thung apihaiyah a onae hmuen koehoi thaw awh hoeh. Hatei, Isarelnaw teh a onae hmuen koe angnae a hmu awh. ");
INSERT INTO cth_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Hat navah, Faro siangpahrang ni Mosi hoi Aron a kaw teh BAWIPA bawk hanelah tâcawt awh leih. Hatei, camonaw hrawi awh nateh tu, maitonaw teh cettakhai awh naseh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mosi ni hottelah boipawiteh, ka Cathut Jehovah ka thueng awh nahanelah satheinaw, hmaisawi thueng han hnopainaw hah nang ni poe hanelah a ngai han. ");
INSERT INTO cth_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Kaimouh ni saringnaw hah ka hrawi awh han. Buet touh boehai ka tat awh mahoeh. Bangkongtetpawiteh, hotnaw thung dawk hoi kaimae Cathut Jehovah thueng nahanelah ka rawi awh han. BAWIPA bangpatet e saring hoi maw ka bawk awh han tie hote hmuen koe a pha awh hoehroukrak ka panuek awh hoeh telah atipouh navah, ");
INSERT INTO cth_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","BAWIPA ni Faro siangpahrang e a lung bout a pata sak dawkvah Isarelnaw tâcawt sak hoeh. ");
INSERT INTO cth_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mosi hanlah kai koehoi tâcawt leih. Ka minhmai bout na hmu hoeh nahanlah kâhruetcuet. Ka minhmai na hmunae hnin nah na due han atipouh. ");
INSERT INTO cth_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mosi ni hai na dei e teh ahawi. Na minhmai bout kahmawt mahoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Hat navah, BAWIPA ni Faro siangpahrang hoi Izip ram dawk lacik ka tho sak han. Hathnukkhu, nangmouh na tâco sak awh han. Na tâco sak awh toteh nangmouh pâlei lah na pâlei awh han. ");
INSERT INTO cth_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Isarel tami tongpa ni imri tongpa koe thoseh, napui ni imri napui koe thoseh, sui, ngun hoi khohnanaw hei hanlah, taminaw koe dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ahnimouh ni a hei e patetlah Izip taminaw ni poe ngainae pahrennae lung hah BAWIPA ni a tawn sak. Mosi haiyah Izip ram dawk Faro siangpahrang e a sannaw hoi a taminaw hmalah bari kaawm e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Hat navah, Mosi koe BAWIPA ni a dei e teh karumsaning vah Izip ram ka kâva han. ");
INSERT INTO cth_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Bawitungkhung dawk ka tahung e Faro e capa camin koehoi cakang phawmnae koe kaawm e sannu e camin totouh, Izip ram kaawm e camin pueng hoi saringnaw e ca caminnaw pueng koung a due awh han. ");
INSERT INTO cth_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Izip ram pueng dawk ayan hoi kaawm boihoeh e hoi hmalah hai bout kaawm hoeh hane kalenpounge khuikanae ao han. ");
INSERT INTO cth_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Hateiteh, BAWIPA ni Izipnaw hoi Isarelnaw kapeknae a tawn ti na panue thai nahanelah, Isarel tami buet touh boehai ui ni rauk mahoeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Na sannaw pueng ni hai kai koe tho awh nateh tabut laihoi cet ati han. Nang hoi na hnukkâbangnaw koung tâcawt telah a dei hnukkhu, kai ka cei han telah a dei pouh teh a lungkhuek teh Faro koehoi a tâco. ");
INSERT INTO cth_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","BAWIPA ni hai kângairu e hnonaw Izip ram dawk moiapap nahan, Faro siangpahrang ni nangmae lawkngai laipalah ao han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mosi hoi Aron ni Faro hmalah hete kângairunae a sak roi eiteh, BAWIPA ni Faro siangpahrang e a lungpata sak dawkvah Isarel canaw a ram dawk hoi tâconae kâ poe hoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","BAWIPA ni Izip ram vah Mosi hoi Aron koe a dei pouh e teh; ");
INSERT INTO cth_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Hete thapa heh nangmouh hanelah a kum tangkuem dawk apasuekpoung e thapa lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Nangmouh roi ni Isarel rangpuinaw koe lawk na thui roi hane teh; Hete thapa hnin hra touh hnin vah nangmanaw pueng ni mae imthungkhu tangkuem dawk im touh ni tuca buet touh rip na sin awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Imthung kathoeng teh tuca buet touh hoi kâki hoehpawiteh imri kahnai e koe a bawng vaiteh tami nâyittouh maw tie a parei hnukkhu, boung cakhuem hane tuca hah a sin han. ");
INSERT INTO cth_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tuca thoseh, hmaeca thoseh, nangmouh ni na sin e saring teh kacueme hoi âvâ ka cawt hoeh rae a tan han. ");
INSERT INTO cth_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Hote tucanaw hah hote thapa hnin hra hlaipali totouh ring vaiteh, tangmin vah Isarel miphun, kamkhuengnaw ni a thei awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Tuca moi kacate im takhang tâphai hoi tangkhang dawk tu thi na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","A moi teh hmai pahai hnukkhu, hote tangmin dawk tonphuenhoehe, kakhat e anhna hoi na ca awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Moi ka heng lah thoseh, thawng lahoi hai thoseh na cat awh mahoeh. A lû, a khok, a kosanaw hoi cungtalah hmai pahai hnukkhu na ca awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hote moi hah khodai totouh na tat mahoeh. Youn touh hai na cawi sak pawiteh, hmai na sawi han. ");
INSERT INTO cth_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Bangtelamaw na ca awh han tetpawiteh, taisawm kâyeng hoi, khokkhawm hoi, sonron patuep lahoi karanglah na ca awh han. Hetteh, BAWIPA e ceitakhai pawi doeh. ");
INSERT INTO cth_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Bangkongtetpawiteh, hote karum dawk Izip ram pueng dawk ka cei vaiteh Izipnaw e camin hoi saringnaw e ca caminnaw pueng ka thei han. Izipnaw e cathutnaw hah lawk ka ceng han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tuca e a thi teh nangmouh na onae im dawk nangmae mitnoutnae lah ao han. Hote a thi ka hmu navah, Kai ni nangmouh teh na ceitakhai awh han. Hottelah, Izip ram ka rek nah nangmouh karaphoekung lacik teh nangmouh koe phat mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Hete hnin teh nangmouh hanlah pahnim thai hoeh e hnin lah ao vaiteh na ca catoun totouh, hete hnin dawk Cathut koe pawi a to awh han. Kâlawk lah ao dawkvah hote pawiteh pou na to awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Hnin sari touh thung tonphuenhoehe na ca awh han. Apasuek hnin nah ton hah imnaw dawk hoi na takhoe awh han. Apasuek hnin koehoi hnin sari totouh ton phuen e vaiyei ka cat e tami teh Isarel miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Apasuek hnin thoseh, asari hnin nah thoseh kathoung kamkhuengnae na sak awh han. Hote hnin dawkvah, taminaw ni canei hoi kâkuen e thaw hloilah alouke thaw tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Hote tonphuenhoehe pawito ngainae teh, hote hnin dawk na taminaw Izip ram hoi ka tâco sak. Hatdawkvah, kâlawk ao e patetlah na ca catoun totouh hote hnin hah na ya awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Thapa yung pasuek, hnin hra hlaipali hnin tangmin hoi kamtawng teh hnin 20 tangmin totouh, nangmouh ni tonphuenhoehe na ca awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Hnin sari touh thung imnaw dawk ton na tat awh mahoeh. Ton phuen e vaiyei kacate ramlouk tami thoseh, khoca thoseh Isarelnaw koehoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Nangmouh na onae hmuen pueng koe ton phuen e vaiyei na cat awh mahoeh. Tonphuenhoehe vaiyei dueng na ca han atipouh. ");
INSERT INTO cth_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Hot navah, Mosi ni Isarel tami kacuenaw hah a kaw teh, na imthung tangkuem ni tuca hah ceitakhai pawi hanlah thet awh. ");
INSERT INTO cth_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Dingsala dawn lat awh nateh kawlung dawk ta e a thi dawk ranup nateh takhang dawk hluk awh. Hathnukkhu hoi amom totouh apihai ma im takhang alawilah na tâcawt a mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Bangkongtetpawiteh, BAWIPA teh Izipnaw thei hanlah a kâhlai han. Im takhang dawk e thi a hmu toteh BAWIPA ni takhang a ceitakhai han. Karaphoekung teh nangmouh reknae poe hanlah imthung kâen sak mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Nangmouh hoi na canaw koe lawkkamnae ao dawkvah hote hno heh pou na tarawi awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","BAWIPA ni poe hanlah kam e ram dawk na pha awh toteh, hete phunglam heh na sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Nangmae ca catounnaw ni hete phung heh bang ngainae maw na sak telah na pacei pawiteh, ");
INSERT INTO cth_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","BAWIPA ni Izipnaw a thei navah maimae imthungnaw a hlout sak. Izip ram kho ka sak e Isarelnaw e imnaw a ceitakhai e, BAWIPA e ceitakhai pawi lah ao telah bout na dei pouh han telah Mosi ni a dei hnukkhu, ahnimouh ni a lûsaling awh teh a bawk awh. ");
INSERT INTO cth_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","BAWIPA ni Mosi hoi Aron koe lawk a thui e patetlah Isarelnaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Karumsaning vah, BAWIPA ni bawitungkhung dawk ka tahung e Faro e camin koehoi kamtawng teh thongkabawtnaw e camin totouh, Izipnaw e camin pueng thoseh, saringnaw e camin pueng thoseh koung a thei. ");
INSERT INTO cth_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Hote tangmin vah, Faro siangpahrang hoi a sannaw, Izipnaw ni a thaw awh teh, im tangkuem tami a due dawkvah, Izip ram pueng dawk khuikanae puenghoi a pha. ");
INSERT INTO cth_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Hote tangmin vah, Mosi hoi Aron a kaw teh, nangmouh roi hoi Isarelnaw thaw awh nateh ka taminaw koehoi tâcawt awh. Na hei e patetlah cet awh nateh Jehovah hah bawk awh leih. ");
INSERT INTO cth_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Nangmouh ni na hei e patetlah tu, maitonaw hrawi awh nateh cet awh. Kai haiyah yawhawinae na poe awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Izipnaw ni maimouh pueng hai tami kadout lah doeh koung o awh toe telah ati awh teh, Isarelnaw Izip ram dawk hoi karanglah tâco sak hanlah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Hote taminaw ni ton phuen hoeh rae tavai a la awh teh, tavai kanawknae kawlungnaw a la awh teh, hni hoi a tangoung awh teh a phu awh. ");
INSERT INTO cth_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mosi ni a dei e patetlah Isarelnaw ni Izipnaw koe suingun, khohnanaw hah a hei awh. ");
INSERT INTO cth_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","A hei awh e patetlah poe ngainae lungthin BAWIPA ni Izipnaw a tawn sak teh, Izipnaw e hnopainaw a lawp awh. ");
INSERT INTO cth_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isarelnaw napui camo touk laipalah, tongpa ting taruk touh, Raameses khopui hoi a tâco awh teh Sukkoth lah a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Alouklouke taminaw haiyah a tawn e tu, maito hoi saringnaw pueng hoi a kâbang awh. ");
INSERT INTO cth_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Izip ram hoi a phu e tonphuenhoehe tavai a la awh teh, tonphuenhoehe a tau awh. Bangkongtetpawiteh, Izip ram hoi tang a pâlei awh dawkvah, canei kawi kârakueng mang awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isarelnaw teh Izip ram vah kum 430 touh imyin lah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","A kum 430 akuepnae hnin dawk BAWIPA e ransanaw teh Izip ram hoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Izip ram hoi a tâcokhai dawkvah hote tangmin teh BAWIPA hanlah a ya awh. Hatdawkvah, hote tangmin teh Isarelnaw ni pout laipalah pou a ya awh e tangmin lah ao. ");
INSERT INTO cth_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","BAWIPA ni Mosi hoi Aron koevah, ceitakhai pawi phunglam teh hettelah ao. Ceitakhai pawiteh alouke miphun ni cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Hateiteh, tangka hoi ran e san ni teh vuensoma hnukkhu a ca han. ");
INSERT INTO cth_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Miphun alouke hoi san lah hno e naw ni teh cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Im buet touh dawk na ca han. A moi im alawilah na sin mahoeh. A hru hai na khoe mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isarelnaw pueng ni hote pawiteh na tarawi awh han. ");
INSERT INTO cth_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Hahoi, nangmouh koe kârayen e Jentelnaw ni BAWIPA hanlah ceitakhai pawi sak han ngai awh pawiteh, tongpanaw pueng vuensoma awh naseh. Hathnukkhu hote tami teh khoca patetlah ao dawkvah pawi kâen naseh. Vuensom ka a hoeh e teh hote pawi cat thai hoeh. ");
INSERT INTO cth_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Khocanaw hoi nangmouh koe kârayennaw hanlah phunglam buet touh dueng doeh kaawm telah BAWIPA ni Mosi hoi Aron koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Hottelah, BAWIPA ni Mosi hoi Aron koe a dei pouh e patetlah Isarelnaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Hote hnin dawk BAWIPA ni Isarelnaw a ransanaw khue hoi Izip ram hoi a tâcokhai. ");
INSERT INTO cth_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","BAWIPA ni Mosi a kaw teh Isarelnaw thung dawk hmaloe khe e, ");
INSERT INTO cth_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","tami thoseh, saring thoseh ca caminnaw pueng Kai hanlah thoung sak awh. Kaie hno lah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mosi ni hai nangmouh santoungnae Izip ram hoi tâconae hete hnin heh pahnim awh hanh. BAWIPA ni nangmouh teh a thaonae kut lahoi hote ram dawk hoi na hrawi awh toe. Ton phuen vaiyei cat awh hanh. ");
INSERT INTO cth_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Abib thapa atu e hnin dawk nangmouh teh na tâco awh. ");
INSERT INTO cth_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","BAWIPA ni nangmouh poe hanlah mintoenaw koe lawk a kam e ram, Kanaannaw, Hitnaw, Amornaw, Hivnaw hoi Jebusitnaw e ram, sanutui hoi khoitui a lawngnae ram dawk na hrawi awh toteh, hete thapa dawk nangmouh ni hete hno heh na sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Hnin sari touh thung tonphuenhoehe na ca awh vaiteh, hnin sarinae dawk BAWIPA han pawi lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tonphuenhoehe vaiyei hnin sari touh thung na ca awh navah, nangmouh koe ton na tat awh mahoeh. Na onae hmuen pueng koehai hmu lah awm hanh naseh. ");
INSERT INTO cth_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Kaimouh ni BAWIPA lungmanae dawk Izip ram hoi ka tâconae tueng nah, hettelah ka sak awh, telah na ca catounnaw koe na dei pouh han. ");
INSERT INTO cth_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","BAWIPA e kâlawk teh na pahni dawk pou ao thai nahan, hote hno teh na kut dawk mitnout kapanuekkhaikung, na mit rahak vah pahnim hoeh nahanlah ao han. BAWIPA ni nang teh athakaawme a kut hoi Izip ram dawk hoi na hrawi awh toe. ");
INSERT INTO cth_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hatdawkvah, hete phunglam heh a kum tangkuem ama tueng nah na ya awh han. ");
INSERT INTO cth_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Nangmouh hoi na mintoenaw koe thoseh lawk a kam e patetlah BAWIPA ni na hrawi awh teh, hote ram na poe awh torei teh, ");
INSERT INTO cth_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Nangmae ca caminnaw pueng hoi saringnaw e ca caminnaw pueng BAWIPA hanlah na hmoun awh han. A na tongpanaw pueng teh BAWIPA e lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Hateiteh, La ni a khe e camin teh tuca hoi na ratang awh han. Ratang ngai hoehpawiteh, Laca e a lahuen na kapai pouh awh han. Taminaw dawk ca caminnaw na ratang awh han. ");
INSERT INTO cth_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Na ca ni hmalah bangtelamaw telah na pacei pawiteh, BAWIPA ni santoungnae Izip ram hoi a kut tha kaawm hoi kaimouh na tâcokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Faro siangpahrang ni kayawi lah na tâco sak awh hoeh torei teh, Izip ram dawk tami thoseh, saring thoseh, ca tongpa caminnaw pueng BAWIPA ni koung a thei. Hatdawkvah, hmaloe ka khe e saring a na tongpanaw pueng heh BAWIPA koe na poe han. Ca tongpa thung dawk tongpa caminnaw pueng teh ratang hanlah na dei pouh han. ");
INSERT INTO cth_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Hete hno haiyah nange mitnout kapanuekkhaikung, na mit rahak vah mitnout lah ao han. Bangkongtetpawiteh, BAWIPA ni athakaawme a kut hoi kaimouh Izip ram dawk hoi na tâco sak awh toe telah taminaw koe a dei awh. ");
INSERT INTO cth_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Faro ni Isarelnaw a tâco sak hnukkhu, Filistin lah ceinae lam kahnaica ao eiteh, Cathut ni hote lam dawk hrawi hoeh. Bangkongtetpawiteh, ahnimouh ni tarantuknae a kâhmo awh navah, a lungpout teh Izip ram lah a ban payon han doeh ti a panue. ");
INSERT INTO cth_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hatdawkvah, Cathut ni ahnimouh teh tuipuipaling kahrawng lam lahoi a hrawi. Isarelnaw ni Izip ram hoi ahuhu lahoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Joseph ni hmaloe vah, Cathut ni na khet awh han. Ka hrunaw hete hmuen koe na sin awh han telah Isarelnaw koe lawk a kam e patetlah Mosi ni ahnie a hrunaw ama koe a sin. ");
INSERT INTO cth_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ahnimouh ni Sukkoth hoi bout a tâco awh teh kahrawng teng, Etham khopui vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ahnimouh ni karum khodai a cei thai awh nahanelah, BAWIPA ni kanîthun lah lam ka patue hane tâmaikhom hoi thoseh, tangmin lah angnae ka poe hane hmaitokhom hoi thoseh, ahnimae hmalah a cei pouh. ");
INSERT INTO cth_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Kanîthun lah tâmaikhom, tangmin lah hmaitokhom hah ahnimae hmalah hoi takhoe pouh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","BAWIPA nihai, ");
INSERT INTO cth_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Isarelnaw ban teh Pihahiroth khopui teng, Migedan khopui hoi tuipui rahak, Baalazephon khopui hmalah rim tuk hanlah dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Bangkongtetpawiteh, Faro siangpahrang ni Isarelnaw teh khikpacu awh toe. Ramke um lam awm hoeh toe telah ati han. ");
INSERT INTO cth_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kai ni hai Faro e lungthin ka pata sak vaiteh, ahni ni Isarelnaw a pâlei han. Kai teh BAWIPA doeh tie Izipnaw ni a panue nahanlah hote siangpahrang hoi a ransanaw lahoi ka bawilennae a kamnue han telah Mosi koe atipouh e patetlah ahnimanaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Hote taminaw a yawng e kong Izip siangpahrang koe a thai sak awh navah, ahni koehoi a sannaw e lungthin bout a kamlang teh, maimouh ni hettelah sak awh teh Isarelnaw hah maimae thawtawknae koehoi bangkongmaw a hlout awh han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Hat navah, Siangpahrang ni rangleng coungkacoe a rakueng teh a taminaw hah akaw. ");
INSERT INTO cth_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Rangleng kahawi e cum taruk touh hoi Izip marangransanaw pueng hoi cungtalah, bawinaw pueng haiyah a ceikhai. ");
INSERT INTO cth_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","BAWIPA ni Faro e lungthin bout a pata sak dawkvah, ahni ni Isarelnaw hah a pâlei awh. Hat ei, Isarelnaw teh kut dâw laihoi a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Hottelah, Faro siangpahrang e marangransanaw, rangleng ransanaw hoi Izip taminaw ni a pâlei awh teh, Pihahuroth khopui teng, Baalazephon khopui hmalah tuipui rai lah rim ka tuk e Isarelnaw hah a pha awh. ");
INSERT INTO cth_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Faro ni a hnai nah Isarelnaw ni a khet awh teh Izipnaw ni pâlei e a hmu awh navah, pueng hoi a taki awh dawkvah BAWIPA koe a hramki awh. ");
INSERT INTO cth_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mosi koe hai, Izip ram dawk phuenmon ao hoeh dawkvah maw, hi ramke um due hanlah kaimouh na hrawi awh. Kaimouh koe hettelah na sak teh, Izip ram hoi bangkong na hrawi awh. ");
INSERT INTO cth_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Kaimouh teh Izipnaw koe san lah kaawm awh yawkaw nei telah Izip ram vah ka dei awh navah, hete hno khet laihoi ka dei awh hoeh na maw. Kaimouh hete kahrawngum due hlak teh Izipnaw koe san lah o e heh ahawihnawn telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mosi ni taket awh hanh. Lungmawngcalah awm awh. BAWIPA ni sahnin nangmouh hanlah rungngangnae a sak hane hah khenhaw. Sahnin nangmouh ni na hmu e Izipnaw heh bout na hmawt awh mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","BAWIPA ni taran na tuk pouh han. Nangmanaw teh lungmawngcalah na o awh han telah taminaw koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","BAWIPA ni bangkongmaw KAI na kaw awh. Isarelnaw hmalah cei hanlah dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Nang ni sonron na kut hoi tuipui van lah dâw nateh tuipui kâphi sak. Isarelnaw ni tui lungui, talai kaphui dawk a cei awh han. ");
INSERT INTO cth_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","KAI ni Izipnaw e a lungthin ka pata sak vaiteh, ahnimouh ni na pâlei awh han. Faro siangpahrang hoi a bawinaw, marang, marangransanaw lahoi ka lentoenae a kamnue han. ");
INSERT INTO cth_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Hottelah, Faro siangpahrang hoi a marang, marangransanaw lahoi ka lentoenae a kamnue toteh, kai teh BAWIPA doeh tie hah Izipnaw ni a panue awh han telah Mosi koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hat navah, Isarelnaw e hmalah ka cet e Cathut e kalvantami ni a hnuk a pâlei teh, tâmai khom teh ahnimae hmalah hoi hnuklah a kampuen teh a kangdue. ");
INSERT INTO cth_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Hottelah, Izip ransanaw hoi Isarel ransanaw rahak a pha nah, Izipnaw koe kahmawt sak e tâmai lah ao teh, Isarelnaw koe teh angnae ka poe dawkvah karum tuettuet buet touh hoi buet touh kâhnai thai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mosi ni tuipui lathueng a kut a dâw nah karum tuettuet BAWIPA ni Kanîtholae kahlî katang hoi tuipui hah hnuklah a pâban teh talai rem a phui sak. ");
INSERT INTO cth_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Isarelnaw ni tuipui lungui talai dawk a cei awh teh, tui teh ahnimae avoilah aranglah talung tapang patetlah ao. ");
INSERT INTO cth_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Izipnaw, Faro siangpahrang ni a hrawi e marang, marangransanaw teh tuipui lungui a kâen awh. ");
INSERT INTO cth_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Amom vah BAWIPA ni Izip ransanaw hah hmaikhom hoi tâmai dawk hoi a khet teh a tarawk. ");
INSERT INTO cth_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ahnimae rangleng cei a ru nahanlah a khok a kâhlehlawk sak. Izipnaw ni hai Isarelnaw koehoi yawng awh leih sei, BAWIPA ni Isarelnaw koe lahoi Izip taminaw a tuk, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","BAWIPA nihai, tuipui ni Izip taminaw, ranglengnaw, marangransanaw e lathueng vah tip sin hanelah, tupui lathueng na kut dâw atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Khodai toteh Mosi ni tuipui lathueng a kut a dâw teh, tuipui tui teh a thao teh bout a lawng. Izipnaw ni a yawng takhai ei, BAWIPA ni ahnimouh teh tuipui lungui vah a tâkhawng. ");
INSERT INTO cth_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Hottelah, tuipui tui teh bout a lawng teh tuipui dawk a bo toteh, Faro siangpahrang e rangleng, marangransanaw pueng teh muen a ramuk dawkvah buet touh hai hlout awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Isarelnaw teh tuipui lungui talai kaphui dawk hoi a cei awh teh, tui teh ahnimae avoilah aranglah talung tapang patetlah ao. ");
INSERT INTO cth_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hottelah, BAWIPA ni Isarelnaw teh Izipnaw e kut dawk hoi a rungngang teh tuipui rai lah Izipnaw e ronaw teh a hmu awh. ");
INSERT INTO cth_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Hottelah, BAWIPA ni Izipnaw koe hno ka len poung a sak e hah Isarelnaw ni a hmu awh navah, BAWIPA hah a taki awh. BAWIPA hoi a san Mosi hah a yuem awh. ");
INSERT INTO cth_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Hat navah, Mosi hoi Isarelnaw ni BAWIPA koe la a sak awh e teh, BAWIPA ni a lentoenae hoi a tâ dawkvah ama pholennae la sak awh sei. Marang hoi marangransanaw tuipui thung koung a tâkhawng toe. ");
INSERT INTO cth_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","BAWIPA teh ka thaonae hoi ka la lah ao. Ama teh na ka rungngangnae lah ao. Hote Cathut teh kai ni ka bawk e Cathut lah ao dawkvah, ka pholen han. Ka mintoenaw e Cathut lah ao dawkvah ka oup han. ");
INSERT INTO cth_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","BAWIPA teh ransa lah ao. A min teh Jehovah doeh. ");
INSERT INTO cth_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Faro siangpahrang e rangleng hoi a ransanaw teh tuipui dawk koung a tâkhawng. A rawi e bawinaw hai tuipui paling dawk koung a bo awh. ");
INSERT INTO cth_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kadung poung e hmuen dawk muen a ramuk. Talung patetlah thung a bo awh. ");
INSERT INTO cth_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oe BAWIPA, Aranglae na kut teh hnosakthainae hoi a lentoe teh, Oe BAWIPA, aranglae na kut ni tarannaw koung a raphoe. ");
INSERT INTO cth_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Nang na ka tarannaw hah na lentoenae naw hoi koung na tâkhawng. A lungkhueknae a patoun teh songnawng patetlah ahnimouh teh a kak. ");
INSERT INTO cth_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Na hnong dawk e kâha lahoi tui teh na kâcu sak teh, Kalawng e tui barukbaruk a phuen sak teh, tuipui thung kadung poung e tui hah a kamkak. ");
INSERT INTO cth_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Taran ni kai na pâlei han. ahnimouh ka pha han. Lawp e hno hah ka kârei vaiteh ahnimouh koe ka ngainae akuep han. Tahloi tabu dawk e ka rasa vaiteh, ka kut hoi ahnimouh teh koung ka thei han telah a dei. ");
INSERT INTO cth_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","BAWIPA ni kahlî a hmu teh, tuipui ni ahnimouh muen a ramuk teh katha kaawm poung e tui dawk talung patetlah a bo awh. ");
INSERT INTO cth_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Oe BAWIPA, cathutnaw thung dawk nang patetlae Cathut apine kaawm. Thoungnae lahoi ka lentoe e, pholen nah, taki kaawm e, kângairu hno ka sak e, Nang hoi bang patet e cathut maw ka kâvan. ");
INSERT INTO cth_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Aranglae kut na dâw nah ahnimouh teh talai ni koung a payawp. ");
INSERT INTO cth_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Na taran e taminaw hah lungmanae lahoi na hrawi. Kathounge na onae hmuen koe tha onae lahoi na hrawi. ");
INSERT INTO cth_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Miphunnaw ni kamthang a thai awh vaiteh a taki awh han. Filistin khocanaw teh a lungpuen awh han. ");
INSERT INTO cth_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom kahrawikungnaw kângairunae, Moab ram e ransanaw teh pâyawnae, Kanaan khocanaw pueng teh lungpoutnae koe a pha awh han. ");
INSERT INTO cth_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Oe BAWIPA, na taminaw ni a tapoung toteh, Na ran e taminaw ni a tapoung toteh, Hote miphunnaw pueng ni takinae lungthin, lungpuennae a tawn awh vaiteh, Na kut hno sakthainae dawk ahnimouh teh talung patetlah duem ao awh han. ");
INSERT INTO cth_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oe BAWIPA, râw coe hane mon, Na o nahanelah na sak e hmuen koe na taminaw na kâenkhai han. Oe BAWIPA, na kut hoi sak e kathoung e hmuen koe hmuen na ta han. ");
INSERT INTO cth_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","BAWIPA ni a yungyoe uk na lawiseh telah la a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Bangkongtetpawiteh, Faro siangpahrang e marangnaw, ranglengnaw, marangransanaw teh tuipui dawk a kâen teh BAWIPA ni ahnimae lathueng tuipui hoi muenli sak. Isarel miphunnaw teh tuipui lungui vah talai dawk a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Aron e a tawn canu, profet napui Miriam ni cecak a sin teh, napuinaw pueng ni hai cecak khawng hoi a hnuk a kâbang awh. ");
INSERT INTO cth_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miriam ni hai BAWIPA teh a lentoe teh tânae a hmu dawkvah, Ama teh pholen awh sei. Marang hoi marangransanaw hah tuipui thungvah koung a pabo toe telah ahnimouh hoi cungtalah la a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Hahoi, Mosi ni Isarelnaw hah tuipui paling koe lahoi a hrawi teh, ahnimouh teh Sur kahrawngum vah a pha awh. Hote kahrawng dawk hnin thum touh kahlawng a cei awh teh tui hmawt awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Marah tie hmuen koe a pha awh navah, Marah tui teh akha dawkvah net thai awh hoeh. Hatdawkvah, Hote hmuen hah Marah telah a kaw awh. ");
INSERT INTO cth_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Taminaw ni Mosi yonpen awh teh bangtelamaw nei han ti hoi a phuenang awh. ");
INSERT INTO cth_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mosi ni BAWIPA a kaw teh BAWIPA ni thingkung buet touh a patue. Hote akung tui dawk a tâkhawng nah tui teh a radip. Hote hmuen koe ahnimouh a tanouk teh phunglam a sak pouh e teh, ");
INSERT INTO cth_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Nangmouh ni BAWIPA Cathut e lawk hah kahawicalah na ngai teh a ngai e hno na sak teh a kâpoelawknaw hah na ngai teh aphunglawknaw pueng na tarawi pawiteh, Izipnaw koe ka pha sak e Lacik hah nangmouh koe ka phat sak mahoeh. Bangkongtetpawiteh, nangmae patawnae kadamsakkung, BAWIPA lah ka o telah ati. ");
INSERT INTO cth_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Hat hnukkhu, tuido hlaikahni touh, samtue 70 touh a onae Elim kho a pha awh teh, Hote hmuen dawk tui onae koe tengpam vah rim a tuk awh. ");
INSERT INTO cth_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Hahoi, Isarel rangpuinaw teh Elim hoi a tâco awh teh kahlawng bout a cei awh. Izip ram hoi a tâco hnukkhu, thapa yung hni, Hnin hrahlaipanga nah, Elim hoi Sinai mon rahak Sin kahrawng dawk a pha awh. ");
INSERT INTO cth_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Hote kahrawng dawk Isarel rangpuinaw ni, ");
INSERT INTO cth_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Kaimouh teh Izip ram moi thawngnae hlaam teng tahung teh, ka boum lah ka ca awh navah, BAWIPA e kut hoi kadout awh pawiteh ahawihnawn. Atu vah, ka kamkhueng e taminaw kamlum sak hanelah, Hete kahrawng dawk na hrawi awh vaw telah Mosi hoi Aron yonpen awh teh a phuenang awh. ");
INSERT INTO cth_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hat navah, BAWIPA ni khenhaw! Kai ni nangmouh hanelah kalvan hoi vaiyei ka rak sak han. Taminaw ni hnin touh rawca rawi hanelah hnintangkuem a tâco awh han. Ka kâlawk patetlah a sak hoi, a sak hoeh e hottelah lahoi ahnimouh ka tanouk han. ");
INSERT INTO cth_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Hnin tangkuem rawi e hlak kapap lah, hnin taruk hnin teh let hni touh hoi rawi hanelah kârakueng awh, telah Mosi koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mosi hoi Aron nihai, BAWIPA ni nangmouh teh Izip ram hoi na hrawi a e hah atu tangmin vah na panue awh han. ");
INSERT INTO cth_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Amom lahai BAWIPA e bawilennae na hmu awh han. BAWIPA koe na phuenangnae lawk teh a thai toe. Kaimouh yon na pen awh teh na phuenang sin hanelah, Kaimouh teh bang patet e tami lah maw ka o awh, telah Isarelnaw koe atipouh roi. ");
INSERT INTO cth_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Hahoi, Mosi ni, BAWIPA ni tangmin na ca awh han e moi thoseh, Amom kaboumlah na ca awh han e vaiyei thoseh, na poe awh toteh, hete lawk heh kakuep han. Nangmouh ni na phuenangnae lawk teh BAWIPA ni a thai toe. Kaimouh teh bang patet e tami maw. Nangmouh ni na phuenangnae e heh kaimouh roi koe na hoeh, BAWIPA koe doeh na phuenang awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Hahoi, nangmae phuenangnae lawk hah BAWIPA ni a thai dawkvah, Ama koe hnai awh, telah Isarel tamimaya pueng koe patuen dei pouh hanelah Aron koe lawkthui e patetlah, ");
INSERT INTO cth_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aron ni Isarel tamimaya koe patuen bout a dei pouh navah, ahnimouh ni kahrawng lah a khet awh teh, tâmai dawk BAWIPA e bawilennae kamnuek e hah a hmu awh. ");
INSERT INTO cth_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","BAWIPA ni hai Isarelnaw e phuenangnae lawk hah ka thai toe. ");
INSERT INTO cth_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Tangmin lah nangmouh ni moi na ca awh han. Amom lahai vaiyei kaboumlah na ca awh han. KAI teh nangmae BAWIPA Cathut doeh tie hah na panue han telah ahnimouh koe dei pouh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Tangmin lah tamuemnaw teh rim koe a tho awh. Amom lahai rim petkâtue lah tadamtui a bo. ");
INSERT INTO cth_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Tadamtui a kâkayaw toteh, tadamtui kamkak e patetlah titica kamhluem e talai dawk ao. ");
INSERT INTO cth_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Hote hno Isarelnaw ni a hmu awh toteh, bangmaw ti a panue awh hoeh dawkvah, buet touh hoi buet touh a kâpacei awh. Mosi ni hete naw teh nangmouh na ca hanelah BAWIPA ni na poe e vaiyei doeh. ");
INSERT INTO cth_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Tami pueng ni amae rim dawk kaawm e tami yit touh ni cakhuem, tami buet touh hanlah Omer buet touh rip rawi hanlah BAWIPA ni a dei e patetlah patuen bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Isarelnaw ni hottelah a sak awh teh, tami kayoun kapap e patetlah a rawi awh. ");
INSERT INTO cth_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Omer hoi a nue awh navah, kapap ka rawi e ni hoe tawn hoeh. Kayoun ka rawi e ni hai hoe vout hoeh. Abuemlah cakhuem koung a rawi awh. ");
INSERT INTO cth_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mosi ni api nang hai amom totouh na tat awh mahoeh atipouh eiteh, ");
INSERT INTO cth_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Tami tangawn ni Mosi e lawk ngai laipalah, amom totouh a ta awh dawkvah a pâri teh a hmui a tho dawk Mosi teh a lungkhuek. ");
INSERT INTO cth_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Hote tami tangkuem ni amamouh cakhuem hnintangkuem a rawi awh. Khumbeithoe nah atui lah a tho. ");
INSERT INTO cth_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","A hnin taruk hnin navah, vaiyei let hni touh, tami buet touh hanelah Omer kahni touh rip a rawi awh. Hote akong hah tamimaya ka ukkungnaw ni Mosi koe a thai sak awh. ");
INSERT INTO cth_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ahni ni hai tangtho teh BAWIPA hmalah kathounge Sabbath hnin, Kâhatnae hnin lah ao. Vaiyei thawng hanlah na ngai e patetlah thawng awh. Bue hanlah na ngai pawiteh bue awh. Kacawie teh tangtho amom hanelah na ta awh han telah BAWIPA ni a dei e hah bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mosi ni lawkthui a e patetlah atangtho amom hanelah hai a ta awh. Hotteh, a hmui tho hoeh. Pâri hai pâri hoeh. ");
INSERT INTO cth_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mosi ni hai kacawie sahnin cat awh. Sabbath teh BAWIPA e hnin doeh. Hote hno kahrawngum sahnin vah na hmawt awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Hnin taruk touh thung a rawi awh. Sabbath hnin lah kaawm e hnin sari hnin nah awm hoeh, na hmawt hai na hmawt awh mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Hnin sari hnin nah, Tami tangawn ni rawi hanelah a tâco awh teh a tawng awh navah hmawt awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","BAWIPA ni hai nangmouh ni kaie kâpoelawknaw hoi kâlawknaw na totouh maw na pahnawt awh han rah. ");
INSERT INTO cth_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","BAWIPA ni Sabbath hnin teh nangmouh na poe awh. Hatdawkvah, hnin taruk hnin nah, hnin hni touh hane vaiyei hah na poe awh. Taminaw pueng ama onae hmuen koe awm naseh. Hnin sari hnin nah, a onae hmuen koehoi nahai cetsak hanh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Taminaw ni hnin sari hnin nah a kâhat awh han. ");
INSERT INTO cth_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isarelnaw ni hote cakawi hah mana telah ati awh. Songsuenmu patetlah ao teh a pangaw. Khoitui hoi kalawt e vaiyei hoi a tuinae a kâvan. ");
INSERT INTO cth_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mosi ni nangmouh Izip ram hoi na hrawi awh navah, Kahrawng na paca e vaiyei hah na ca catounnaw pueng ni a hmu a nahan e lah, Omer buet touh tat telah BAWIPA ni a dei e hah bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mosi ni Aron koevah hlaam lat nateh, mana Omer buet touh athung vah tat. Na ca catoun totouh ta hanelah, BAWIPA hmalah na kuem han atipouh. ");
INSERT INTO cth_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","BAWIPA ni Mosi koe lawkthui e patetlah hote mana hah Aron ni pou a kuem hanelah lawkpanuesaknae hmalah a hung. ");
INSERT INTO cth_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isarelnaw ni khosaknae ram dawk a pha awh hoeh roukrak, a kum 40 touh thung mana a ca awh. Kanaan ramri koe a pha hoeh roukrak mana a ca awh. ");
INSERT INTO cth_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omer buet touh e teh ephah pung hra pung touh e kuk lah ao. (Omer buet touh teh ephah pung hra pung touh hoi a kâvan teh, ephah buet touh teh 22 liters hoi a kâvan) ");
INSERT INTO cth_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isarel rangpuinaw ni BAWIPA e kâ patetlah Sin kahrawng dawk hoi a tâco awh teh kahlawng bout a cei awh nah Rephidim vah rim a tuk awh. Hote hmuen koe taminaw nei hanelah tui awm hoeh. ");
INSERT INTO cth_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Hatdawkvah, taminaw ni Mosi koe nei hane tui na poe telah a titeh Mosi a yue awh. Mosi ni bangkongmaw kai koe thoenae na tawng awh. BAWIPA hah bangkongmaw na tanouk awh vaw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Taminaw tui a kahran dawkvah, Mosi yon a pen awh teh a phuenang awh. Kamamouh khue hoi ka canaw, saringnaw pueng tui kahran sak hanelah, Izip ram hoi bangkongmaw na hrawi telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Hat navah, Mosi ni BAWIPA hah a kaw teh, hete taminaw heh kai ni bangtelamaw ka ti han. Talung hoi kai dêi hanelah meimei coungkacoe ao awh toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","BAWIPA ni hai taminaw e hmalah cet nateh, Isarel tami kacuenaw hah kaw. Tuipui na hemnae sonron hah sin nateh Horeb mon lah cet. ");
INSERT INTO cth_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Hote hmuen koe kaawm e lungsong van vah kai ka kangdue han. Nang ni hote lungsong hah na hem han. Taminaw ni a nei hane tui hote lungsong dawk hoi a tâco han telah Mosi koe atipouh. Mosi ni Isarel kacuenaw e hmalah hottelah a sak. ");
INSERT INTO cth_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Isarelnaw ni BAWIPA teh kaimouh koe ao hoi ao hoeh e a tanouk awh dawkvah, hote hmuen teh Massah hoi Meribah telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Hat navah, Amaleknaw ni a tho awh teh Isarelnaw Refidim vah a tuk awh. ");
INSERT INTO cth_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mosi ni taminaw hah a rawi teh Amaleknaw tuk hanelah cet awh. Tangtho vah, Cathut e sonron ka sin vaiteh, mon vah ka kangdue han telah Joshua koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mosi ni a dei pouh e patetlah Joshua ni a sak teh Amaleknaw hah a tuk. Mosi, Aron hoi Hur tinaw mon vah a luen awh. ");
INSERT INTO cth_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mosi ni a kut a dâw nah, Isarelnaw ni a tâ awh. A kut a pabo nah, Amaleknaw ni a tâ awh. ");
INSERT INTO cth_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Hatei, Mosi e kut tha a tawn dawkvah, ahnimouh ni talung a la awh teh, Mosi talung van a tahung sak hnukkhu, Aron hoi Hur ni avoivang lahoi a kut a tawm pouh roi. Hatdawkvah, Kanîloum totouh a kut teh ama paroup lah ao. ");
INSERT INTO cth_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Joshua ni hai Amalek bawinaw hoi a taminaw hah tahloi hoi a thei. ");
INSERT INTO cth_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","BAWIPA ni hai hete hno dawk pahnim hoeh nahanlah ca thut nateh touk telah Joshua koe atipouh. Bangkongtetpawiteh, kalvan rahim vah Amalek pahnimhoehnae hah kai ni ka takhoe han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mosi ni khoungroe a sak teh BAWIPA teh ka tânae (Jehovah-nissi) doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Bangkongtetpawiteh, Amaleknaw e kut ni BAWIPA e khoungroe e taran lah ao dawkvah, BAWIPA ni Amaleknaw teh a yungyoe hoi taran lah a tuk han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Cathut ni Mosi hoi a tami Isarelnaw hanelah a sak pouh e naw pueng thoseh, BAWIPA ni Isarelnaw Izip ram hoi a tâcokhainae thoseh, Midian Jethro, Mosi e a masei ni a thai nah, ");
INSERT INTO cth_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mosi ni a patoun e a yu hoi, ");
INSERT INTO cth_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","A ca kahni touh a hrawi teh a cei. A capa buet touh e min teh Gershom ka phung. Bangkongtetpawiteh, ayâ ram vah imyin lah ka o atipouh. ");
INSERT INTO cth_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Alouk buet touh e min teh Eliezer ka phung. Bangkongtetpawiteh, Apa Cathut teh kai na kabawmkung lah ao. Faro e tahloi dawk hoi na rungngang telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mosi e a masei Jethro ni Mosi e capa roi hoi a yu a hrawi teh kahrawngum rim tuknae koe Cathut mon dawk Mosi koe a tho awh. ");
INSERT INTO cth_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","A masei Jethro hoi na yu, na capa roi teh nang koe a tho telah Mosi koe a dei pouh awh navah, ");
INSERT INTO cth_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mosi ni a masei hah dawn hanelah a tâco teh a paco. Na dam maw telah buet touh hoi buet touh a kâpacei awh hnukkhu, rim thung vah a kâen awh. ");
INSERT INTO cth_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","BAWIPA ni Isarelnaw hanelah Faro siangpahrang hoi Izipnaw koe hno a sak e naw pueng thoseh, lam a kâhmo awh e rucatnae naw pueng thoseh, hote rucatnae dawk hoi BAWIPA ni a rungngang e thoseh, Mosi ni a masei koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","BAWIPA ni Isarelnaw teh Izipnaw e kut dawk hoi a rasa teh a sak e lungmanae kecu dawk Jethro teh a lunghawi. ");
INSERT INTO cth_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Izipnaw e kut dawk hoi thoseh, Faro siangpahrang e kut dawk hoi thoseh, nang hoi taminaw ka rungngang e BAWIPA teh yawhawinae awm naseh. ");
INSERT INTO cth_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","BAWIPA teh alouke cathutnaw pueng hlak, hoe a lentoe tie atu ka panue. Bangkongtetpawiteh, taminaw ni kâoupkâpawinaw thaw dawk BAWIPA ni a tâ telah ati hnukkhu, ");
INSERT INTO cth_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mosi e a masei Jethro ni hmaisawi hane sathei hoi Cathut hanlah satheinaw hah a sin teh, Aron hoi Isarel tami kacuenaw ni Mosi e a masei hoi cungtalah Cathut hmalah rawca ca hanlah a tho awh. ");
INSERT INTO cth_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Atangtho vah, Mosi ni taminaw lawkceng hanlah a tahung. Amom hoi tangmin totouh, taminaw Mosi hmalah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mosi ni taminaw koe a sak e naw pueng hah a masei ni a hmu navah, hete taminaw koe bangtelamaw na sak Nang ni nama dueng na tahung teh taminaw pueng teh amom hoi tangmin lah totouh na hmalah bangkongmaw ao awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mosi ni hete taminaw teh Cathut e pouknae hei hanelah kai koe ka tho e doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Hahoi, ahnimouh ni lawkpungnae tawn awh boipawiteh, kai koe a tho awh teh, ahnimae lawkpung hah kai ni lai ka dei pouh. Cathut e kâlawknaw hah kai ka cangkhai telah a masei koe atipouh navah, ");
INSERT INTO cth_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","A masei ni na sak e hno heh hawi hoeh. ");
INSERT INTO cth_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Nang hoi nang koe kaawm e hete taminaw teh atangcalah a thayoun awh han. Hete thaw heh nang hanlah hnokari poung lah ao. Tami buet touh dueng ni sak thai kawi e nahoeh. ");
INSERT INTO cth_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ka lawk hah thai haw. Kai ni pouknae na poe han. Cathut ni na okhai han doeh. Nang ni Cathut hoi kâkuen e hno dawk taminaw e hnonaw hah Cathut koe na kâen vaiteh, na thai sak han. ");
INSERT INTO cth_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ahnimouh hai kâlawknaw na cangkhai han. Ahnimouh ni a dawn hane lamthung, a sak awh han e kawinaw hai na patue han. ");
INSERT INTO cth_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Hothloilah, Cathut ka taket e tami, kalan e tami, hounlounnae ka panuet e taminaw hah taminaw thung dawk hoi na rawi vaiteh, tami thongkhat kaukkung, tami cum touh kaukkung, tami 50 touh kaukkung, tami hra touh ka uk hanelah thaw na poe han. ");
INSERT INTO cth_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Hote taminaw ni nâtuek haiyah taminaw hah lawkceng awh naseh. Lawkpung kalen dawk teh nang koe pouknae lat awh naseh. Kathoenge lawkpungnae teh ama ni lawkceng awh naseh. Hottelah boipawiteh, ahnimouh ni cungtalah thaw rei tawk awh vaiteh nang na tha a dam han. ");
INSERT INTO cth_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Hottelah, Cathut ni kâ na poe pawiteh, nang teh na cak han. Hete taminaw pueng teh amamae hmuen koe karoumcalah a cei awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mosi ni a masei e lawk hah a ngai teh a dei pouh e patetlah a sak. ");
INSERT INTO cth_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mosi ni ka uk thai hane taminaw hah Isarelnaw thung dawk hoi a rawi teh tami thongkhat kaukkung, tami cum touh kaukkung, tami 50 touh kaukkung, tami hra touh kaukkung hanlah thaw a poe. ");
INSERT INTO cth_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Hote taminaw ni nâtuek haiyah taminaw hah lawk a ceng awh. Ka ru e lawkpung dawk teh Mosi e pouknae a la awh. Kayawi e lawkpung dawk teh amamouh lungpouk lawk a ceng awh. ");
INSERT INTO cth_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hathnukkhu, Mosi ni a masei ban hanlah a pasoung toung dawkvah ahni teh amae ram lah a ban. ");
INSERT INTO cth_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Isarelnaw ni Izip ram hoi a tâco awh hnukkhu, thapa yung thum, apasuek hnin nah Sinai mon dawk a pha awh. ");
INSERT INTO cth_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Refidim hoi a tâco awh teh Sinai mon dawk a pha awh teh, hote kahrawng dawk mon hmalah rim a tuk awh. ");
INSERT INTO cth_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mosi ni Cathut koe a luen nah BAWIPA ni mon hoiyah a kaw, nang teh Jakop e phun, Isarelnaw koe bout a dei e lawk teh, ");
INSERT INTO cth_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Kai ni Izipnaw koe ka sak e thoseh, nangmouh langta rathei hoi na phu teh kama hanlah na la e thoseh, nangmouh ni na panue awh toe. ");
INSERT INTO cth_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Hatdawkvah, nangmouh ni atu ka lawk hah atanglah na ngai awh teh, ka lawkkam na tarawi pawiteh, alouke miphunnaw pueng hlak nangmouh teh ka tawn hane râw lah na o awh han. Talai pueng heh kaie doeh. ");
INSERT INTO cth_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Nangmanaw haiyah vaihma uknaeram, kathounge miphun lah kama koe na o awh han telah Isarelnaw koe patuen dei pouh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mosi ni bout a tho teh taminaw thung dawk hoi kacuenaw hah a kaw hnukkhu, BAWIPA ni lawkthui e naw pueng hah bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Taminaw pueng ni hai BAWIPA ni a dei e pueng teh kaimouh ni ka sak awh han telah lungkânging lahoi bout ati awh. Mosi ni ahnimae lawk hah BAWIPA koe bout a thai sak. ");
INSERT INTO cth_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","BAWIPA ni khenhaw! Nang hoi Kai ni dei nah taminaw ni a thai awh teh, nang pou na yuem thai awh nahanlah, tâmai khom dawk hoi nang koe Kai ka tho han telah Mosi koe atipouh. Mosi ni hai BAWIPA e lawk hah taminaw koe bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","BAWIPA ni hai taminaw aonae koe a cei teh, Sahnin hoi tangtho dawk ahnimouh thoung sak lah. Khohna hai pâsu sak awh teh, ");
INSERT INTO cth_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Apâthum hnin dawk coungkacoe lah awm sak awh. Bangkongtetpawiteh, apâthum hnin nah, BAWIPA ni a taminaw hmalah Sinai mon dawk a kum han. ");
INSERT INTO cth_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Taminaw ni a tapuet awh hoeh hane ngangnae hah mon petkâtue lah sak nateh, nangmouh ni mon dawk luen awh hanh. Mon khok hah na kâbet awh hoeh nahanlah, kâhruetcuet telah dei pouh. Mon kâbet e taminaw teh atanglah dout awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Hote tami hah kut hoi tek awh hanh. Atangcalah talung hoi dêi han. Nahoeh pawiteh, tahroe hoi thut han. Tami thoseh, saring thoseh, hring mahoeh. Mongka ueng lawk kasawlah a cai toteh, taminaw ni mon dawk a tho han telah Mosi koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mosi ni mon hoi taminaw onae koe a kum teh, ahnimouh hah a thoungsak. Ahnimouh ni a khohnanaw a pâsu awh. ");
INSERT INTO cth_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mosi ni hai apâthum hnin nah coungkacoe lah awm awh. Yu koe ip awh hanh telah taminaw koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Apâthum hnin amom vah, mon dawk keitat, sumpa palik hoi kho tâmai muen a tabo teh, hramki lawk hoi mongka lawk a cai teh rim dawk kaawm e taminaw pueng a pâyaw awh. ");
INSERT INTO cth_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mosi ni hai taminaw Cathut hoi kâhmo sak hanelah, rim dawk hoi a hrawi teh mon khok koe a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","BAWIPA teh hmai hoi kâkayo teh Sinai mon dawk a kum dawkvah, Sinai mon teh hmai a khu. Hmaikhu haiyah takhuen dawk e hmaikhu patetlah a luen teh mon pueng hai a kâhuet. ");
INSERT INTO cth_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Mongka ueng e kasawlah hoe a cai toteh, Mosi ni a kaw teh Cathut ni lawk hoi a pato. ");
INSERT INTO cth_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","BAWIPA teh Sinai monsom dawk a kum. Mosi hah mon vah a kaw dawkvah, Mosi teh mon vah a luen. ");
INSERT INTO cth_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","BAWIPA ni hai taminaw ni khet hanelah, Kai koe tho payon awh vaiteh taminaw a due awh han e hah puennae a tawn dawkvah, kum nateh kâhruetcuetnae poe. ");
INSERT INTO cth_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","BAWIPA koe ka tho e vaihmanaw haiyah amahoima a kâthoung sak a han. Nahoeh pawiteh, BAWIPA ni a rek awh han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mosi nihai, taminaw ni Sinai mon dawk luen thai awh hoeh. Bangkongtetpawiteh, tapuet hoeh hane ngangnae naw hah mon petkalup lah ka sak teh, thoungsak awh loe telah lawk yo ka thui toe telah BAWIPA koe bout a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","BAWIPA ni hai kum leih. Nang hoi Aron dueng doeh ka luen han. Vaihmanaw hoi taminaw teh BAWIPA koe luen hanelah tho awh hanh naseh. Nahoeh pawiteh, ahnimouh ka rek han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mosi ni taminaw onae koe a kum teh a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hat navah, Cathut ni a dei e lawk teh, ");
INSERT INTO cth_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Kai teh nangmouh santoungnae hmuen, Izip ram dawk hoi na ka tâcawtkhai e nangmae Cathut Jehovah doeh. ");
INSERT INTO cth_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kai hloilah alouke cathut na bawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Lathueng kalvan thoseh, rahim talai dawk thoseh, talai rahim tui dawk thoseh, kaawm e hno hoi mei kâvan lah, meikaphawk bawk hanlah na sak mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","A hmalah tabo hoi na bawk mahoeh. Bangkongtetpawiteh, nange Cathut kai Jehovah teh nang dawk yon ao telah tang ka yuem e Cathut, kai na kahmuhmanaw e ca catoun se thum, se pali totouh a napanaw e yon hah a capanaw koe ka pathung e Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kai hah lungpataw ni teh ka kâpoelawknaw ka tarawi e a ca catoun, a se thongsang totouh lungmanae ka kamnuek sak e Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nange Cathut Jehovah e min hah laithoe lah dei awh hanh. Bangkongtetpawiteh, A min laithoe lah ka dei e tami teh yon tawn hoeh telah BAWIPA ni pouk mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Sabbath hnin thoung sak hanelah, hote hnin hah pahnim awh hanh. ");
INSERT INTO cth_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Hnin taruk touh thung thaw panki hoi tawk awh. ");
INSERT INTO cth_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Hnin sari hnin teh na BAWIPA Cathut e Sabbath hnin lah ao. Hote hnin dawk, nang hoi na canaw, na sannu sanpanaw, saring, nange longkha thung kaawm e imyinnaw hai thaw tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Bangkongtetpawiteh, BAWIPA ni kalvan, talai, hmuen pueng koe kaawmnaw pueng hah hnin taruk touh thung a sak teh, hnin sari hnin nah, a kâhat. Hatdawkvah, BAWIPA ni hnin sari hnin hah yawhawi a poe teh a thoungsak. ");
INSERT INTO cth_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Na Cathut Jehovah ni na poe e ram dawk na hringsaw nahanelah, na manu hoi na pa barih. ");
INSERT INTO cth_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tami thet hanh. ");
INSERT INTO cth_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Uicuk hanh. ");
INSERT INTO cth_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ayâ e hno parawt hanh. ");
INSERT INTO cth_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Na imri koe kalan hoeh e kapanuekkhaikung lah awm hanh. ");
INSERT INTO cth_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Imri e im, a yu, a sannu sanpa, maito, marang hoi hnopai buet touh haiyah lungthin radueknae tawn hanh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Taminaw ni keitat lawk, sumpapalik, mongka ueng lawk, mon hoi hmaikhu a tâco e naw hah a hmu awh toteh, a taki awh dawkvah, a kâhnawn awh teh ahlanae koe vah a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Mosi koevah Nang ni lawk dei lah ka ngai awh han. Kaimouh koe Cathut lawk dei han naseh. Kaimouh ka due hane hah puen ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mosi ni hai na lungpuen awh hanh. Nangmouh tanouk hanelah thoseh, nangmouh teh sak payonnae dawk hoi hlout hanelah ama taki hanelah thoseh, Cathut a tho toe telah taminaw koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Taminaw ni ahlanae koe vah a kangdue awh. Mosi teh Cathut onae koe kinghmonae koe lah a hnai. ");
INSERT INTO cth_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","BAWIPA ni Isarelnaw bout a dei pouh e teh, kai ni kalvan hoi nangmouh na pato e hah na panue awh toe. ");
INSERT INTO cth_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kai bawknae dawk namamouh hno hanlah ngun cathut thoseh, sui cathut thoseh na sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kai hanelah talai khoungroe hah na sak awh han. Hote khoungroe dawk nange hmaisawi sathei, yonthanae sathei lah kaawm e nange tu, maitonaw hah na thueng awh han. Ka min na bawknae hmuen pueng dawk nang koe ka tho vaiteh yawhawinae na poe han. ");
INSERT INTO cth_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Nang ni talung khoungroe hah kai hanlah na sak pawiteh, talung dei e hoi na sak mahoeh. Sum hoi thuk e talung hoi sak e khoungroe teh khinnae ao. ");
INSERT INTO cth_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nang dawk kayanae ao hoeh nahanelah, khoungroe dawk khalai hoi na luen mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","BAWIPA nihai, nang ni Isarelnaw koe lawk na ceng hane teh, ");
INSERT INTO cth_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Hebru tami san lah na ran pawiteh, kum taruk touh dueng san lah na ta han. Kum sari a pha toteh ratang laipalah na hlout sak han. ");
INSERT INTO cth_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Santoung nah tami buet touh dueng santoung pawiteh, buet touh dueng a tâco han. A yuvâ kahni touh hoi santoung pawiteh, a yu hoi cungtalah na tâco sak han. ");
INSERT INTO cth_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Nahoeh pawiteh, a bawipa ni a yu a la pouh e awm pawiteh, hote a yu hoi canaw khe pawiteh, a yu hoi a canaw teh a bawipa ni a coe han. San teh ama dueng a tâco han. ");
INSERT INTO cth_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Nahoeh pawiteh, san ni ka bawipa hoi ka yu ka canaw ka lungpataw, tâco hane ka ngai hoeh telah tet pawiteh, ");
INSERT INTO cth_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","A bawipa ni Cathut hmalah thoseh, im takhang koe thoseh, a hnâ caphuem hoi a kavi pouh hnukkhu, hote san teh a yungyoe san lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","A na pa ni a canu san lah yawt pawiteh, hote napui teh san tongpa patetlah hlout mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","A bawipa ni hote napui a la teh ngai hoehpawiteh, bout a ratang sak han. Ahni hah a dum dawkvah alouke miphunnaw koe yawt thai hoeh. ");
INSERT INTO cth_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","A capa hanlah lat boipawiteh, a canu patetlah a khetyawt han. ");
INSERT INTO cth_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Alouke napui bout lat pawiteh, hmaloe a la e napui e khohna hoi a yu lah onae hah raphoe pouh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Hete hno kathum touh sak pouh hoehpawiteh, aphu het laipalah a hlout sak han. ");
INSERT INTO cth_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Tami hem boi lah dout pawiteh ama hai a due roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Thei hanlah noenae awm laipalah Cathut ni a kut dawk hringnae poe boipawiteh, a yawng nahane hmuen hah na pouk pouh awh han. ");
INSERT INTO cth_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","A imri thei hanlah noenae a tawn teh, ka tuk e tami teh ka khoungroe kângue nakunghai, sawn vaiteh thei roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","A manu hoi a na pa ka hem e tami a due roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ka parawt e tami ni a paru e hno a yo nakunghai thoseh, a kut dawk kaawm nakunghai thoseh, thei lah ao roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","A manu hoi a na pa thoe ka bo e tami teh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Tami hoi tami kâyue teh buet touh ni talung hoi a dêi nakunghai thoseh, a kut hoi a thâw nakunghai thoseh, hemnae ka khang e tami kadout hoeh nakunghai, ikhun dawk sut ka yan nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","bout a thaw teh sonron hoi ka cet nakunghai thoseh, ka hem e tami han a yonnae ngaithoum han. Hatei, ka pataw e tami thaw a kamkak dawkvah, a dam nahan kâsatnae aphu a poe han. ");
INSERT INTO cth_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","A bawipa ni a sannu hoi a sanpa hah bongpai hoi a hem teh hote san dout pawiteh, a bawipa teh reknae ka patawpoung lah poe roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Hatei, san teh hnin touh, hnin hni a pataw hoi dout hoehpawiteh, hote san teh a bawipa e lah ao dawkvah reknae dawk hoi a hlout han. ");
INSERT INTO cth_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tami hoi tami kâyue teh camo ka vawn e napui a takit dawk camo a kamko teh alouke patawnae bang awm hoehpawiteh, a vâ ni a dei e patetlah rek lah ao han. Bawi ni a dei e patetlah a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Alouke patawnae awm pawiteh, hringnae hanlah hringnae thoseh, ");
INSERT INTO cth_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mit hanlah mit thoseh, hâ hanlah hâ thoseh, kut hanlah kut thoseh, khok hanlah khok thoseh, ");
INSERT INTO cth_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Hmai hanlah hmai thoseh, a hmâ hanlah a hmâ thoseh, hemnae hanlah hemnae thoseh a khang han. ");
INSERT INTO cth_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","A bawipa ni a sannu a sanpa e a mit a rawk totouh hem pawiteh, a mit a rawk dawkvah a hlout sak han. ");
INSERT INTO cth_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Hot patetvanlah, a sannu a sanpa e a hâ ka lawt lah hem pawiteh, a hâ a lawt dawkvah a hlout sak han. ");
INSERT INTO cth_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Maito ni tami napui hoi tongpa a deng dawk dout pawiteh, hote maito hah atangcalah koung kadout lah dêi han. A moi hai cat mahoeh. Katawnkung teh ngaithoum lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Hot patetvanlah, tami ouk ka deng e maito, katawnkung ni tami ouk a deng e kong a thai nahlangva, pâkhit laipalah tat pawiteh, hote maito ni tami napui tongpa koung kadout lah deng pawiteh, hote maito teh talung hoi koung kadout lah dêi han. Katawnkung hai thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Nahoeh pawiteh, tangka rawng naseh telah dei pawiteh, dei e patetlah amae hringnae kâratang nahanlah a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ayânaw e canaw deng pawiteh, a dei e patetlah a khang han. ");
INSERT INTO cth_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","A sannu sanpa deng boipawiteh, maito katawnkung ni san katawnkung tangka 30 touh a rawng pouh han. Maito hai talung hoi koung kadout lah dêi han. ");
INSERT INTO cth_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Tami ni tangkom khuem paawng teh a tanae dawk thoseh, tangkom a tai teh teng laipalah a ta e dawk thoseh, ayânaw e marang hoi maito bawt pawiteh, ");
INSERT INTO cth_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Tangkom ka tai e ni marang hoi maito phu hah a rawng vaiteh a ro a la han. ");
INSERT INTO cth_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Tami buet touh e maito ni ayâ louk e maito koung kadout lah deng pawiteh, maito ka tawn roi ni kahring e maito hah a yo roi vaiteh aphu a kârei roi han. Kadout e maito hai a kârei roi han. ");
INSERT INTO cth_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Hot patetvanlah, maito ni ouk a deng tie katawnkung ni a panue nahlangva, pâkhit laipalah paktha pawiteh, maito ro ama ni a la han. Hote maito buet touh e a yueng lah maito buet touh a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Tami ni tu hoi maito hah a paru teh a thei nakunghai thoseh, a yo nakunghai thoseh, maito buet touh dawk maito panga touh, tu buet touh dawk tu pali touh hoi bout a patho han. ");
INSERT INTO cth_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Tamru ni imthung a kun nah ayâ ni a hmu teh ka thet nakunghai, due yueng lah dout mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Hatei, kanî tâcawt pawiteh, duenae phu a due van han. Bangkongtetpawiteh, bout a poe thai. Hno awm hoehpawiteh a paru e hno patho nahanlah amahoima a kâyo han. ");
INSERT INTO cth_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Tamru e kut dawk tu maito hah a hring lah hmawt pawiteh, let hni hoi a patho han. ");
INSERT INTO cth_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ayâ e laikawk hoi misur takha a ca sak nakunghai thoseh, saring ayâ e laikawk dawk khoum nakunghai thoseh, mae laikawk hoi misur dawk e kahawi poung e rasa vaiteh bout a poe han. ");
INSERT INTO cth_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Hmaisawi nah phovai a kak dawkvah cabong, cakung, laikawk dawk kaawm e hnonaw kang pawiteh, hmai kasawikung ni a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Tami buet touh ni a imri buet touh koe suingun patet e hno buetbuet touh a hnawng teh, a hnawng e tami e im dawk hoi tamru ni parawt pawiteh tamru hah a hmu awh navah, tamru ni let hni hoi a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tamru pâphawng hoeh boipawiteh, katawnkung ni a imri hah hno a la hoi a la hoeh e Cathut hmalah a pacei han. ");
INSERT INTO cth_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ayâ e hno la payonnae dawk maito, la, tu, khohna patet e kahmat e hno buetbuet touh a hmu teh, hete hno heh kaie doeh telah tami buetbuet touh ni tetpawiteh, hote tami roi teh Cathut hmalah pacei vaiteh ka sung e ni let hni hoi a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Tami ni a imri e laikawk dawk marang, maito, tu patet e saring buetbuet touh a hnawng teh hote saring dout nakunghai thoseh, a hmâtan a ca teh pataw nakunghai thoseh, kapanuekkhaikung awm laipalah ayâ ni oun ka hrawi nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","A hnawng e tami ni ka imri e hno ka lat hoeh telah kahni touh hoi hnâ a bo roi teh BAWIPA hmalah thoe kâ bo roi pawiteh hno katawnkung ni a hnâbo khai vaiteh, a hnawng e tami ni hai rawng mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Hat ei, ayâ ni oun parawt pawiteh, a hnawng e tami ni hno katawnkung bout a poe han. ");
INSERT INTO cth_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Sarang ni kei pawiteh panuekhai nahanlah a ro patue naseh. A ro patue thai pawiteh rawng mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Tami ni a imri koe hno buetbuet touh a hlai teh katawnkung ao hoehnahlan, oun dout nakunghai thoseh, a hmâtan a ca teh pataw nakunghai thoseh, a rawng han. ");
INSERT INTO cth_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Katawnkung awm pawiteh kahlaikung ni rawng mahoeh. Aphu hoi hlai pawiteh, katawnkung ni a hlainae phu dueng a hei han. ");
INSERT INTO cth_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Tongpa buet touh ni a yu hanlah ham hoeh e tangla pasawtpanep hoi ipkhai pawiteh, aphu a poe vaiteh a yu lah a la roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","A na pa ni vâ sak hanlah ngaikhai hoehpawiteh, a ikhainae phu teh a rawng roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Hmaui napui na hring sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Saring hoi ka ip e tami teh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Jehovah hloilah, alouke cathut hmalah thuengnae ka sak e tami teh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ram alouke imyin hah na pacekpahlek awh mahoeh. Nangmouh haiyah Izip ram dawk imyin lah ouk na o awh toe. ");
INSERT INTO cth_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Nara hoi lahmai hah pacekpahlek awh hanh. ");
INSERT INTO cth_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Tami buetbuet touh na pacekpahlek awh teh ahnimouh ni kai koe tica hai hram awh boipawiteh, a hramnae lawk ka thai han. ");
INSERT INTO cth_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Nangmouh koe ka lung puenghoi a khuek vaiteh, tahloi hoi na thei awh han. Na yunaw hai lahmai lah ao vaiteh, na canaw hai nara lah ao awh han. ");
INSERT INTO cth_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ka tami, ka roedeng e na imri koe tangka na cawi pawiteh, apung kacatnaw patetlah na cat mahoeh. Apung hai na het mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Na imri ni a hni nang koe pâhung pawiteh, kho a hmo hoehnahlan bout na poe han. ");
INSERT INTO cth_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Bangkongtetpawiteh, hni kâkhu hane alouke tawn hoeh. Ama a kâkhu hanelah a tho. Ahni teh bangtelamaw a i thai han. Kai na kaw pawiteh ka thai pouh han. Kai teh pahrennae ka tawn e lah ka o. ");
INSERT INTO cth_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Cathut hah kathout lah na dei mahoeh. Na miphun ka uk e bawi hah thoe na bo mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Aluepaw hmaloe kahmin e hoi kasu e ratui hah hrawk laipalah na poe han. Ca tongpa camin haiyah kai koe na poe awh han. ");
INSERT INTO cth_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Hot patetvanlah, tu hoi maitonaw hai na sak awh han. Hnin sari touh thung tu maitoca hah a manu hoi rei na ta awh vaiteh, hnin taroe hnin nah na poe han. ");
INSERT INTO cth_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Nangmouh teh kai koe tami kathoung lah na o awh han. Sarang ni kahrawngum a kei e moi na cat awh mahoeh. Uinaw hah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Nang ni laithoe e kamthang hah patuen na pathang mahoeh, na dei mahoeh. Tamikalanhoehnaw hoi lungkânging teh kapanuekkhaikung lah na awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tamikathoutnaw e hnukkâbang mahoeh. Lawkceng navah tami kalen kambawng laihoi lamthung phensak hanlah na dei mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Mathoe koehai kapeknae na tawn mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Na taran e marang maito lam ka hmang e na hmawt pawiteh bout na thak pouh awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nang na ka hmawt ngai hoeh e tami e la hah a hno ni a ratet e na hmawt pawiteh, na kabawp ngai hoeh hai na kabawp han. ");
INSERT INTO cth_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Mathoe ni nang na oun nah kahawi hoeh lah ahni lawk na ceng mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Kahmanhoeh e hno na roun han. Yon ka tawn hoeh e tamikalan hah na thet mahoeh. Bangkongtetpawiteh, tamikathout teh kai ni ka ngaithoum mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Nang ni tadawngnae na cat mahoeh. Tadawngnae ni tami lungkaangnaw hah mit a dawn sak teh tami kalannaw lawk a phen sak. ");
INSERT INTO cth_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ram alouke imyin hah rektap awh hanh. Nangmouh teh Izip ram dawk imyin lah ouk na o awh toung dawkvah, imyin ni a tawn e lungthin hah na panue awh. ");
INSERT INTO cth_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Kum taruk touh thung laikawk na tawk vaiteh cakang na pâtung awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","A kum sari nah laikawk tawk laipalah na ta han. Hottelah, na sak pawiteh, mathoenaw ni a ca thai awh van han. Kacawie naw hai saringnaw ni a ca awh han. Hot patetvanlah, misur takha, olive takha hai na sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Hnin taruk touh thung thaw na tawk awh han. A hnin sari nah na kâhat awh han. Hottelah, na sak pawiteh, na maito hoi lanaw ni kâhatnae tueng a tawn awh han. Na canaw, imyinnaw hai tha a dam awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ka dei e lawknaw pueng hah pâkuem awh. Alouke cathut min hah dei awh hanh. Na pahni dawk hoi dei e lawk ayâ ni thai hanh naseh. ");
INSERT INTO cth_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kum touh dawk vai thum touh kai hanlah pawi na sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tonphuenhoehe vaiyei pawi na sak awh han. Kâ na poe tangcoung e patetlah hnin sari touh thung tonphuenhoehe na ca awh han. Bangkongtetpawiteh, hote thapa dawk nangmouh teh Izip ram hoi na tâco awh. Hote pawi na sak awh navah apihai kai koe a kuthrawng hoi tho hanh naseh. ");
INSERT INTO cth_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Laikawk tawk teh cang a han nah, cang takhawknae thoseh, cakang koung kuem hoi kum abaw nah, cavanca pawi thoseh na sak awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Nangmouh thung dawk tongpa pueng teh kum touh dawk vai thum touh Bawipa Jehovah e hmalah minhmai na patue awh han. ");
INSERT INTO cth_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Kai e sathei e thi hah ton phuen e vaiyei kalawt laihoi na poe mahoeh. Kai e sathei e athaw hai amom totouh na tat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Na law dawk e a pawhik kahawi poung e aluepaw hah na BAWIPA Cathut e im dawk na thokhai awh han. Hmaeca hah a manu e sanutui hoi na thawng mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Khenhaw! lam vah nang na ring vaiteh, ka rakueng e hmuen koe hrawi hanelah na hmalah kalvantami ka patoun han. ");
INSERT INTO cth_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Hote kalvantami hah barinae tawn. A lawk hah ngai pouh. A kâ ek hanh. Kâ na tapoenae hah ahni ni na ngaithoum awh mahoeh. Kai e ka min teh ahni dawk ao. ");
INSERT INTO cth_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Nang ni atangcalah a lawk na ngai teh, kaie kâlawk patetlah na sak pawiteh, nange tarannaw hah ka taran van han. Nang kangangnaw hah kai ni ka ngang van han. ");
INSERT INTO cth_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Kaie kalvantami ni na hmalah a cei vaiteh Amor tami, Hit tami, Periz tami, Kanaan tami, Hiv tami hoi Jubusitnaw onae hmuen koe na hrawi awh vaiteh, ahnimouh teh koung ka pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ahnimae cathut hah na bawk awh mahoeh. Ahnimae bawknae patet lahai na sak awh mahoeh. Koung na raphoe awh vaiteh kutsak cathutnaw hai phetrasei lah na dei pouh han. ");
INSERT INTO cth_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Nangmae BAWIPA Cathut hah na bawk awh han. Na vaiyei thoseh, tui thoseh yawhawinae a poe han. Lacik hai nange nathung hoi a takhoe han. ");
INSERT INTO cth_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Na ram dawk camo ronae hoi carôenae awm mahoeh. Na hringyung ka vang sak han. ");
INSERT INTO cth_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Kai na takinae lungthin hah na hmalah ka patoun vaiteh, na phanae hmuen pueng koe e miphunnaw pueng hah ka raphoe han. Na tarannaw pueng hah hnuklah ka ban sak han. ");
INSERT INTO cth_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Khoingannaw hah na hmalah ka patoun vaiteh, Hitnaw, Kanaannaw, Hivnaw hah na hmalah a pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Hote taminaw kum touh hoi na hmalah lahoi koung ka pâlei mahoeh. Koung ka pâlei pawiteh, ram dawk tami kingdi vaiteh sarang teh nang hanlah kapap han. ");
INSERT INTO cth_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nang ni na pungdaw teh ram dawk na kawi hoehnahlan pueng, ahnimouh teh payai lahoi ka pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na ramri teh tuipui paling tui koehoi Filistin tuipui totouh, thingyeiyawn hoi tuipui totouh kai ni ka khoe han. Hote khocanaw teh na kut dawk na poe vaiteh nang ni na pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ahnimouh hoi thoseh, ahnimae cathutnaw hoi thoseh, kâhuikonae na sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Nang ni kai koe yonnae na sak hanelah, ahnimouh ni a sak han tie puennae ao dawkvah, ahnimouh teh na ram dawk awm awh mahoeh. Nang ni ahnimae cathut hah na bawk pawiteh, kamthuinae katang lah ao han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Hahoi, BAWIPA ni Mosi koe, nang, Aron, Nadab, Abihu hoi Isarel kacue 70 touh hoi cungtalah, BAWIPA koe luen awh nateh ahnimouh teh ahlanae koehoi bawk awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Nang dueng ni BAWIPA hah na hnai han. Alouknaw ni na hnai han naseh. Taminaw teh nang hoi cungtalah rei na luen mahoeh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mosi ni hai taminaw onae koe a tho teh, BAWIPA e lawknaw pueng thoseh, lawkcengnae naw pueng thoseh, a thai sak. Taminaw ni hai BAWIPA e lawk patetlah ka sak awh han telah rip bout ati awh. ");
INSERT INTO cth_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mosi ni BAWIPA e lawknaw pueng a thut hnukkhu, amom a thaw teh mon khok koevah khoungroe thoseh, Isarel miphun hlaikahni touh hanelah talung hlaikahni touh thoseh a ung awh. ");
INSERT INTO cth_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Isarel thoundounnaw a patoun e patetlah ahnimouh ni maitonaw a thokhai awh teh BAWIPA hmalah hmaisawinae sathei, roumnae sathei hah a thueng awh. ");
INSERT INTO cth_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mosi ni a thi tangawn hah kawlung dawk a hlun hnukkhu, atangawn e hah khoungroe van vah a kathek. ");
INSERT INTO cth_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Lawkkamnae ca hah a la teh tamimaya hmalah a touk hnukkhu, ahnimouh ni hai BAWIPA ni a dei e patetlah kaimouh ni ka sak awh han, ka ngâi awh han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mosi ni thi hah a la teh taminaw e lathueng vah a kâhei teh; hete thi teh hete hnonaw dawk BAWIPA ni nangmouh koe e lawkkamnae thi lah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Hat navah, Mosi, Aron, Nadab, Abihu hoi Isarel kacue 70 touh a luen awh teh, ");
INSERT INTO cth_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Isarel miphunnaw e Cathut hah a hmu awh. A khok rahim lah Sapphire talung rem e patetlah thoseh, thoungnae teh kalvan pinkâhin e patetlah thoseh a kamnue. ");
INSERT INTO cth_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Isarel kahrawikungnaw koe a kut phat sak hoeh. Ahnimouh ni Cathut a hmu awh eiteh, a canei awh. ");
INSERT INTO cth_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","BAWIPA ni ka onae monsom vah luen nateh awm haw. Taminaw cangkhai hanelah lungphen dawk thut e kâlawknaw heh nang koe na poe han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mosi ni kabawmkung Joshua hoi a thaw teh Cathut e mon dawk a luen roi. ");
INSERT INTO cth_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kacuenaw koe kaimouh roi ka tho hoeh roukrak hete hmuen koehoi na ring awh. Aron hoi Hur teh nangmouh koe ao dawkvah rucat kâhmo e awm pawiteh ahnimouh roi koe cet naseh telah lawk a thui. ");
INSERT INTO cth_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mosi ni mon vah a luen teh tâmai ni mon teh muen a kayo. ");
INSERT INTO cth_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","BAWIPA e bawilennae teh Sinai mon vah a kâhat teh tâmai ni hnin taruk touh thung muen a kayo. Hnin sari nah, tâmai thung hoi Mosi a kaw. ");
INSERT INTO cth_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","BAWIPA e bawilennae teh monsom vah hmai ka kang e patetlah kamnuek e Isarelnaw ni a hmu awh. ");
INSERT INTO cth_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mosi teh tâmai thung a kâen teh mon a pha. A hnin 40 touh thung mon vah ao. ");
INSERT INTO cth_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","kai koevah pasoumhno poe hanelah, Isarelnaw hah dei pouh. Lungthocalah hoi ka poe e pueng kaie pasoumhno lah na la han. ");
INSERT INTO cth_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Hetnaw heh ahnimouh koehoi na la hane pasoumhno lah ao han. Sui, ngun, rahum ");
INSERT INTO cth_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kamthim hni, âthi hni, hnipaling, loukloukkaang e lukkarei, hmae muen, ");
INSERT INTO cth_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","tu pho âthi bu e, a pho kahawi phu kaawm e hoi, anri thing, ");
INSERT INTO cth_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","paang hane satui, kâhluk e satui hoi hmuitui, ");
INSERT INTO cth_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","vaihma angki hoi lungtabue bet hanelah onyx talung phu kaawm, ");
INSERT INTO cth_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","hahoi ahnimouh koe ka o thai nahanlah hmuen kathoung na sak pouh awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Lukkareiim e mei hoi a puengcangnaw e mei pueng kai ni na hmu sak e patetlah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Hahoi anri thing e thingkong ayung dong hni tangawn, adangka dong touh hoi a tangawn, arasang dong touh hoi tangawn hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Athung avan suikathoung hoi na hluk vaiteh, sui hoi pangkhek na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Laikaw pali touh sui hoi na sak vaiteh, a khok dawk na mahrawk han. Laikaw kahni touh hah avanglae a khok dawk, alouke kahni touh hah avanglae a khok dawk na mahrawk han. ");
INSERT INTO cth_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Kâkayawtnae acung hah anri thing e na sak vaiteh, sui koung na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Thingkong kâkayawt thai nahanelah, tapang dawk e laikaw dawk kâkayawtnae acung hah na hrawt han. ");
INSERT INTO cth_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Thingkong e laikaw dawkvah kâkayawtnae acung teh pou na hrawt vaiteh, na rayu mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Thingkong thung vah lawkpanuesaknae kai ni na poe hane hah na ta han. ");
INSERT INTO cth_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Lungmanae tungkhung hah ayung dong hni tangawn, adangka dong hni tangawn hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Lungmanae tungkhung apoutnae reira dawk cherubim kahni touh dei lah dei e sui hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Avang lae apoutnae dawk cherubim buet touh, avanglae apoutnae dawk hoi cherubim buet touh na sak han. Lungmanae tungkhung hoi kâkuen lah apoutnae roi koe cherubim kahni touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hottelah cherubim kahni touh minhmai kadangka lahoi lungmanae tungkhung hah a rathei kadai hoi a khu vaiteh, lungmanae tungkhung koe lah cherubim ni a khet han. ");
INSERT INTO cth_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Hote thingkong van vah lungmanae tungkhung teh na ta awh vaiteh, na poe hane lawkpanuesaknae hah thingkong thung vah na ta han. ");
INSERT INTO cth_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Hote hmuen dawk nang koe ka tho vaiteh, cherubim kahni touh rahak e lawkpanuesaknae thingkong van lungmanae tungkhung lahoi Isarel taminaw koevah kâ na poe hane pueng dawk lawk ka dei han. ");
INSERT INTO cth_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Hahoi anri thing hoi caboi ayung dong hni, adangka dong touh, a rasang dong touh hoi tangawn hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kathounge sui hoi na hluk vaiteh, pangkhek hah sui hoi na pacawp sin han. ");
INSERT INTO cth_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","A phen kuttabei tittouh e hoi petkâkalup lah a hna na bet vaiteh, sui hoi na pacawp sin han. ");
INSERT INTO cth_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Caboi hanlah sui laikaw pali touh na sak vaiteh, a khok pali touh onae takin pali touh dawk na ta han. ");
INSERT INTO cth_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Caboi hah kâkayawt thai nahan, acung hrawt thai nahanelah, laikaw hah a hna hoi kamtawm lah na mawp han. ");
INSERT INTO cth_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Caboi hah kâkayawt thai nahanlah anri thing e acung na sak vaiteh, sui tui hoi na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Hote hno hanlah, tongben, pacen, kawlung hoi awi nahane manang haiyah sui hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Caboi van vah vaiyei hah ka hmaitung vah pou na pâhung han. ");
INSERT INTO cth_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Hahoi hmaiimkhok hah sui hoi na sak vaiteh dei lah dei e han. Hmaikhom patet e kutnaw, manangnaw, a peimuemnaw, lili peinaw hah buet touh lah na dei han. ");
INSERT INTO cth_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Hmaiimkhok avoivang lahoi kathum kathum touh a tâco vaiteh, a kut taruk touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Hmaiimkhok dawk hoi ka tâcawt e a kut kathum touh dawk, a kut buet buet touh dawk a peimuem, lili pei, almond paw hoi mei kâvan e manang kathum touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Hmaiimkhok dawk hai a peimuemnaw, lili peinaw, almond paw, mei kalmond paw hoi mei kâvan evan e manang pali touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hmaiimkhok dawk hoi ka tâcawt e a kut taruk touh ao e patetlah a kut kahni touh e rahim haiyah a peimuem buet touh rip ao han. Hmaikhom abuemlah suikathoung hoi na dei han. ");
INSERT INTO cth_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","A peimuemnaw a kutnaw hah buet touh lah koung na kâkuetsak han. Abuemlah suikathoung hoi na dêi han. ");
INSERT INTO cth_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Hote hno hanlah hmaiim sari touh na sak vaiteh, a hmalah a ang thai nahanlah hmaiim hah na paang han. ");
INSERT INTO cth_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Paitei hoi padounnae haiyah suikathoung lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hmaiim tanae hoi a hnopai pueng saknae dawk suikathoung pong 100 touh na hno han. ");
INSERT INTO cth_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Mon vah meilam na patue e patetlah bangpueng sak hanelah pahnim hanh. ");
INSERT INTO cth_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Hothloilah, lukkareiim hah âthi hni, hnipaling, loukloukkaang e hni yung hra touh hoi sak e, cherubim em kahawicalah na la vaiteh, mek na sak sin han. ");
INSERT INTO cth_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Yaphni e teh ayung dong 28 touh rip a kâvan han. Adangka dong 4 touh rip han. Abuemlahoi yaphni koung a kâvan han. ");
INSERT INTO cth_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Yaphni e hah buet touh hoi buet touh koung kâbet han. Alouke panga touh hai buet touh hoi buet touh koung a kâbet han. ");
INSERT INTO cth_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Patawp e yaphni hah apasuek e a tâphai a poutnae dawk laikaw dik kamthim e hoi na sak han. Hottelah patawp e yaphni e apâhni e avanglae apoutnae dawk hai na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Yaphni buet touh dawkvah, laikaw 50 touh na sak han. Hahoi patawpnae apasueke tâphai dawk hai laikaw 50 touh na sak vaiteh, phouk kadangka lah ao awh han. ");
INSERT INTO cth_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tarennae 50 touh sui hoi na sak han. Hote tarennae ni yaphni hah hmai na taren sin vaiteh, lukkareiim teh buet touh lah na o sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Lukkareiim e a lemphu dawkvah, hmae muen hoi yaphni hah na sak han. Yaphni 11 touh hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yaphni teh ayung dong 30 touh rip a pha han. Adangka dong pali touh vaiteh, yaphni 11 touh e hah koung a kâvan han. ");
INSERT INTO cth_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Yaphni panga touh e hah koung na patawp han. Hahoi yaphni taruk touh hah lukkareiim hma lae yaphni taruk touh e hmalah koung na patawp han. ");
INSERT INTO cth_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Patawp e yaphni pasuek e tâphai dawk laikaw 50 touh hoi na sak vaiteh, patawpnae apâhni e tâphai dawk laikaw 50 touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Hetsinnae 50 touh e hah rahum hoi na sak han. Rakhan buet touh lah ao thai nahanelah, hetsinnae hah tâphai lae laikaw dawk na bang han. ");
INSERT INTO cth_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Lukkareiim e yaphni kacawie tangawn hah, lukkareiim e a hnuklah na bang han. ");
INSERT INTO cth_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Hahoi lukkareiim avanlah kacawie yaphni som dong touh reira e hateh avangvanglah lukkareiim ramuknae a kahup lah a kâbang han. ");
INSERT INTO cth_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Lukkareiim lemphu ramuk nahanelah tu pho paling bu e, hote tu pho van vah hmae pho hah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Lukkareiim tungdum nahanelah thingpheknaw hah anri thing hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Thingphek teh asaw e dong hra, akaw e dong touh hoi tangawn han. ");
INSERT INTO cth_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hote thingphek pueng dawk a khok kahni touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Lukkareiim akalah kalup nahanelah thingphek 20 touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Hote thingphek 20 touh dawk e buetbuet touh e rahim vah, a khok kahni touh mawp nahanelah ngun khokpacawp 40 touh na sak han. A tangkhang hanelah ngun khokpacawp kahni touh lengkaleng na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Hot patetvanlah, lukkareiim atunglah kalup nahanelah thingphek 20 touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ngun khokpacawp 40 touh e hah thingphek buet touh hanelah kahni touh lengkaleng na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Lukkareiim a hnuk lae kalup nahanelah thingphek 6 touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","A takin avoivang lah kalup nahane kahni touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Takin kahni touh dawk, a rahim lahai a lathueng lahai laikaw hah na bang han. ");
INSERT INTO cth_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hahoi thingphek 8 touh hah na kangdue nahanelah ngun laikaw 16 touh ao han, thingphek buet touh hanelah tarik e kahni touh lengkaleng ao han. ");
INSERT INTO cth_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Anri thing hoi tapang e pangkhek hah na sak han. Lukkareiim avangvanglah hane thingphek panga touh lukkareiim avanglah hane thingphek panga touh. ");
INSERT INTO cth_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Lukkareiim hnuklah kalupnae thingphek hrawt nahanelah tarennae acung yung panga touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","A lungui tapang tâphai hah a tangkhang thingphek lungui hoi avanglah apoutnae koehoi avanglah a poutnae totouh na pha sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Thingphek hah sui tui hoi na hluk han. Hahoi tapang e tâphai hrawtnae laikaw hah sui hoi na sak han, tapang tâphai hai sui tui hoi na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Hottelah mon dawkvah, kai ni na patue e patetlah lukkareiim teh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kamthim hni, âthi hni, hnipaling loukloukkaang e hoi carouk e na sak han. A meikahawicalah cherubim mei na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hote sui tui hluk e anri thing khom pali touh dawkvah yaphni hah na bang han. Hote khom teh sui hoi sak e hetnae hoi ngun khokpacawp pali touh dawk ung e lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Kacakcalah na het vaiteh, yaphni hah na yap vaiteh, yaphni thung lah lawkpanuesaknae thing kong hah na ta han. Yaphni na yap e hah namamouh hane hmuen kathoung hoi hmuen kathoungpounge kapeknae lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Lungmanae tungkhung hah hmuen kathoungpounge lawkpanuesaknae thingkong van na ta han. ");
INSERT INTO cth_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Yaphni alawilah caboi hah na ta vaiteh, lukkareiim akalae hmaiimkhok, atunglah caboi buet touh hoi buet touh kadangka lah na ta han. ");
INSERT INTO cth_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Hahoi lukkareiim takhang koe yaphni loukloukkaang e, carouk e lukkarei kamthim hni, âthi hni, hnipalingnaw, hoi, emlakathoum koe em la sak hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Hahoi anri thing hoi yaphni yap nahane hah khom panga touh na sak vaiteh, sui tui koung na hluk han. Bang nahanelah sui hoi na sak han. Hotnaw pâhung nahanelah, rahum khokpacawp panga touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Anri thing hoi khoungroe ayung dong panga, adangka dong panga, arasang dong thum, a takin pali touh lah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Khoungroe hoi kâkuen lah a takin pali touh dawk a ki na sak vaiteh, rahum tui koung na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Hraba kawnnae ampaikei, tawkso, ailo, cingco, hoi tawngben naw hah rahum e na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Hote khoungroe teh, rahum cuekkarue na sak vaiteh, a takin pali touh dawk rahum laikaw pali touh na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tamlawk ni khoungroe tangawn a pha thai nahanlah, a lungui totouh khoungroe hna a rahim lah na ta han. ");
INSERT INTO cth_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Khoungroe kâkayawtnae acung anri thing hoi na sak vaiteh, rahum tui na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Hote kâkayawtnae acung teh, laikaw dawk na hrawt vaiteh, kâkayawtnae acung hoi kâkayawt thai nahanelah, khoungroe teng vah, reirei ta han. ");
INSERT INTO cth_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hote khoungroe teh thingphek hoi athunglah vukkâko lah na sak han. Athung avan kâpicalah na sak han. Mon vah na patue e patetlah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Lukkareiim thongma hai na sak han. Akalah kalup nahanelah loukloukkaang e hni kawng e dong 100 touh kasaw na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Hote yaphni yap nahanelah khom 20, khokpacawp 20 touh hah rahum hoi na sak vaiteh, hetnae hoi pangkheknaw teh ngun hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Hot patetlah, atunglae kalup nahanelah, ayung dong 100 touh ka phat e yaphni hoi cungtalah, ngun hetnae, ngun pangkhek, rahum khom 20, rahum khokpacawp 20 touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Kalupnae a hnuklah kalup nahanelah ayung dong 50 touh e yaphni hoi khom hra touh, khokpacawp hra touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kalupnae a hma lae hai adangka dong 50 touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Longkha avangvanglah yap hane ayung dong hlaipanga touh kasawe yaphni hoi, khom kathum touh, ");
INSERT INTO cth_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","khokpacawp kathum touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kalupnae longkha koe yap hane dong 20 touh kasawe yaphni teh kamthim hni, âthi hni, hnipaling, loukloukkaang e lukkarei carouk e hoi, khom pali touh, khokpacawp pali touh ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kalupnae petkâkalup lah kaawm e pueng teh, hetnae hah ngun, pangkhek hah ngun, khokpacawp hah rahum han. ");
INSERT INTO cth_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kalupnae teh ayung dong cum, adangka dong 50, arasang dong panga touh a pha vaiteh, loukloukkaang e lukkarei hoi rahum khokpacawp lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Lukkareiim dawk hnopai e naw pueng hoi lukkareiim dawk hno e hetnae hoi, kalupnae dawk hno e hetnae pueng teh rahum hoi sak e lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Hmaiim pou paang thai nahanelah, Olive paw phawm laihoi raci e olive satui kathoung hah, Isarelnaw ni a thokhai awh nahanlah kâ na poe han. ");
INSERT INTO cth_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Lawkpanuesaknae yaphni yap e alawilah kamkhuengnae hmuen koe, Aron hoi a canaw ni tangmin hoi amom ditouh BAWIPA hmalah, hote thaw hah a tawk awh han. Hetheh, Isarel catounnaw ni catounnaw totouh a tarawi awh hane phunglam lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Aron hoi Aron capa Nadab, Abihu, Eleazar hoi Ithamar naw ni, kai koevah, vaihma thaw a tawk thai awh nahanelah, na hmau Aron hoi a capanaw hah Isarel catounnaw thung hoi lat haw. ");
INSERT INTO cth_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Hahoi na hmau Aron hanelah, kathounge khohna ka bawilen sakkung meikahawisakkung lah na o sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Kutsakkathoume, lungangnae muitha lahoi, kakawisaknaw pueng hah dei pouh. Aloukcalah kapek e koehoi Aron ni vaihma thaw kai hanelah a tawk thai nahan a khohna hah sak pouh naseh. ");
INSERT INTO cth_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Hetheh khohna hanelah a khui awh hanelah doeh. Saiphei, angki, angkidung, Ephod, lupawk hoi taisawm. Na hmau Aron hoi a capanaw ni kai han vaihma thaw a tawk thai awh nahan, kathounge khohna na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Sui, kamthim, paling, loukloukkaang e pahla hoi na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Vaihma angki teh kutsakkathoumnaw ni a sak e patetlah Sui, kamthim, âthi, paling, loukloukkaang e pahla hoi carouk e lahoi a sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Apoutnae koe vah a loung dawk pâbawk e arui kahni touh ao vaiteh, hothateh pâbawk e lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Sui, kamthim, âthi, paling, opaou, hoi loukloukkaang e angki dawkvah, yeng hane taisawm kahawipoung lah kawng e angki hoi, aphu kaawmpoung e hno han. ");
INSERT INTO cth_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Hahoi aphu kaawm e talung kahni touh na la vaiteh, avan vah Isarel catounnaw e min hah na thut han. ");
INSERT INTO cth_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Talung aphu kaawm e buet touh dawkvah, minnaw taruk touh, alouke talung dawkvah taruk touh, a tâconae lahoi na thut pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Min na thutnae talung thuk kathoumnaw ni a thuk awh e patetlah Isarel catounnaw e min hah talung kahni touh dawk na thuk han. Suihlaam dawk na pâseng han. ");
INSERT INTO cth_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Isarel catounnaw pahnim hoeh nahanelah hote talung kahni touh hah angki rui dawk na bet han. Hottelah Aron ni ahnimae minnaw hah a loung roi dawk BAWIPA hmalah a bang han. ");
INSERT INTO cth_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Suipahla vei e hai na sak vaiteh, ");
INSERT INTO cth_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Suidingyin kahni touh, rui karawn e patetlah na vei vaiteh, na vei e dingyin teh karawn e hoi a kamtawp han. ");
INSERT INTO cth_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Lawkcengnae Ephod hah na sak han. Sui, kamthim pahla, dikpaling pahla, opaou pahla, loukloukkaang pahla hoi kahawicalah kawng e vaihma angki na sak e patetlah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Takin pali touh a tawn vaiteh bawkhni touh lah ao han. Ayung khap touh adangka khap touh han. ");
INSERT INTO cth_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Hahoi talung phu kaawm than pali touh na pâthit han. Apasueke than dawkvah, sardius, topaz, hoi carbuncle han. ");
INSERT INTO cth_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Apâhni e than dawkvah, emerald, sapphire hoi diamon han. ");
INSERT INTO cth_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Apâthum e than dawkvah, Jacinth, agate, hoi amethyst han. ");
INSERT INTO cth_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Apalinae than dawkvah, beril, onyx hoi jasper han. Hotnaw teh sui dawk koung bet e lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Aphu kaawm talungnaw ni, Isarel catounnaw e minparui e patetlah hlaikahni touh ni min rip a tawn awh han. Min thutnae dawk thuk e patetlah miphun pueng hah a minnaw patetlah miphun hlaikahni touh hane doeh. ");
INSERT INTO cth_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ephod a poutnae koevah, rui karawn e patetlah dingyin kathounge vei e hah sui hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Hahoi Ephod hanelah suilaikaw kahni touh na sak han. Laikaw kahni touh hah Ephod a poutnae koe na bet han. ");
INSERT INTO cth_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Suidingyin kahni touh vei e hah Ephod apoutnae koe e laikaw kahni touh dawk na kan han. ");
INSERT INTO cth_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Vei e dingyin hmo a vang lae hah suipahla kahni touh vei e dawkvah na kan han. ");
INSERT INTO cth_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Hahoi suilaikaw kahni touh na sak han. Hot teh Ephod kahni touh a pawi koe vaihma angki e a thung lah na mawp han. ");
INSERT INTO cth_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Suilaikaw kahni touh alouklah na sak vaiteh, hot teh a hma lae vaihma angki kannae rahim lae kâpatawpnae koe kahawicalah kawng e, vaihma angki kannae van lah na mawp han. ");
INSERT INTO cth_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Hahoi vaihma angki laikaw dawkvah, Ephod dawk e laikaw hah kamthim pahla hoi mekkhuisin han. Kahawicalah kawng e vaihma angki suinae teh avanlah ao thai nahane hoi Ephod hah vaihma angki hoi a kâphoi thai hoeh nahan, ");
INSERT INTO cth_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","hottelah Aron teh, hmuen kathoung koe a cei toteh, BAWIPA hmalah pou a kamnue nahanelah, a lungthin dawk lawkcengnae ephod dawkvah, Isarel catounnaw e min lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim hoi thummim hah lawkcengnae Ephod dawk na hruek vaiteh, BAWIPA hmalah a cei toteh, Aron e lungthin dawk ao han. Hottelah Aron ni BAWIPA hmalah Isarel catounnaw lawkcengnae hah a lung dawk pou ao han. ");
INSERT INTO cth_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Hahoi vaihma angkidung hah kamthim pahla hoi dueng na kawng awh han. ");
INSERT INTO cth_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","A lungui vah lû mahrawk nahanelah na paaw pouh han. Ka aw e a vak hoeh nahanelah, angki lahuen patetlah arai na yep han. ");
INSERT INTO cth_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kamthim, dikpaling, loukloukkaang e hoi sak e talepawnaw hai angki petkâkalup lah na sak han. Hote rahak dawkvah, suidinghling hoi petkâkalup lah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Hottelah angkidung dawkvah, suidinghling buet touh hoi talepaw, suidinghling hoi talepaw petkâkalup lah arai dawk na sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aron ni thaw a tawk navah, hottelah a kamthoup han. Hottelah BAWIPA e hmalah hmuen kathoung dawk kâen tâconae tueng nah a pawlawk thai laipalah a due hoeh nahanelah na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Hahoi suikathoung phen na sak vaiteh, avan vah kutnoutthutnae ca tarik e patetlah BAWIPA KOE THOUNGNAE telah na thut han. ");
INSERT INTO cth_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Hot teh lupawk dawk ao nahanelah, lupawk e hmalah kamthim pahla rui hoi na bet han. ");
INSERT INTO cth_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Hot teh, Aron tampa dawk ao han. Isarel catounnaw ni kathounge a poehnonaw pueng a thoungsaknae, payonpakainae kaawm e hah Aron ni koung a phu han. Hot teh BAWIPA hmalah dâw han kamcu e lah ao thai nahanelah, a tampa dawk pou a ta han. ");
INSERT INTO cth_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Angkidung teh loukloukkaang e hoi kahawicalah na carouk vaiteh na kawng han. Loukloukkaang e hni hoiyah vaihma lupawk hah na sak vaiteh, taisawm hai na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Aron capanaw hanlah, angkidung hah na sak pouh vaiteh, taisawm hai ahnimouh han na sak pouh han. A bawilen sak nahan hoi kahawisakkung lah a bawilakhung na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Na hmau Aron hoi a capanaw hah na pathoup han, kai han vaihma thaw a tawk thai nahan satui na awi vaiteh, na hmoun vaiteh, na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Hahoi caici lah a onae na ramuk nahanelah, loukloukkaang e hnadung na sak pouh vaiteh, a keng koehoi a phai totouh a pha han. ");
INSERT INTO cth_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Hot teh Aron hoi a capanaw kamkhuengnae lukkareiim koe kâennae tueng dawk thoseh, hmuen kathoung koe thaw tawk nahanlah bawknae khoungroe teng a cei nah thoseh a kamthoup awh han. Nahoeh pawiteh, yonpen e lah awm vaiteh, dout awh langvaih. Hot teh amamouh hoi ka tho hane catounnaw totouh a yungyoe hanlah caksak e phunglam doeh toe. ");
INSERT INTO cth_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Kai hanlah vaihma thaw tawk thai nahan kamthoung sak hanelah, ahnimae lathueng na sak hane teh, hetheh doeh. Maitotan kanaw e buet touh, tutan kanaw e kahni touh toun han kaawm hoeh e, ");
INSERT INTO cth_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","tonphuenhoehe hoi, tonphuenhoehe satui hoi sak e vaiyei phen, satui hoi sak e kanem e vaiyei tonphuenhoehe naw hah na la han, kanui e tavai hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Hotehah tangthung dawk na ta vaiteh, maitotan hoi tutan kahni touh hoi tangthung hah na thokhai han. ");
INSERT INTO cth_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Aron hoi a canaw hah kamkhuengnae lukkareiim takhang koevah na thokhai vaiteh, tui na pâsu han. ");
INSERT INTO cth_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Khohnanaw na la vaiteh, angki, hni, ephod hah Aron na kho sak vaiteh, ka talue e angkidung hah taisawm hoi kâyeng sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","A lû dawk vaihmanaw e lupawk na kâmuk sak vaiteh, hote lupawk van vah kathoungnae lakhung na kâmuk sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Hahoi awi hane satui na la vaiteh, a lû dawk na awi pouh vaiteh na hluk pouh han. ");
INSERT INTO cth_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hahoi, a capanaw na kaw vaiteh, na kho sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Aron hoi a capanaw hah taisawm na kâyeng sak vaiteh, bawilakhung hai na kâmuk sak vaiteh, vaihma coungnae hah a yungyoe hanlah na caksak han. Hottelahoi Aron hoi capanaw teh na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Hahoi, kamkhuengnae lukkareiim hmalah maitotan na thokhai vaiteh, Aron hoi a capanaw ni maito e lû dawk kut a toung awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Hottelah, kamkhuengnae lukkareiim tho teng vah, BAWIPA hmalah maitotan hah na thei han ");
INSERT INTO cth_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Maitotan e thi hah na la vaiteh khoungroe ki dawk na kutdawn hoi na nep han. Hahoi kacawie thi hah khoungroe kung koe koung na rabawk han. ");
INSERT INTO cth_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","A thung e a kosanaw hoi a thin dawk kaawm e a hmue, a kuen kahni touh hoi athawnaw na la vaiteh, khoungroe dawk hmai na sawi han. ");
INSERT INTO cth_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Maitotan e a tak, a pho, a khoknaw teh rapan alawilah hmai na sawi han. Hot hah teh yon thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tutan buet touh na thokhai vaiteh, Aron hoi a capanaw ni a lû dawk kut a toung awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tutan na thei vaiteh, a thi teh khougroe tengpam vah abuemlahoi na kathek han. ");
INSERT INTO cth_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","A moi hah na tâtueng vaiteh, a ruenthin hoi a khok hoi a lûnaw hah na hruek han. ");
INSERT INTO cth_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hahoi tutan e tak abuemlahoi khoungroe dawk hmai na sawi han. Hothateh, BAWIPA hanlah hmaisawi thuengnae, BAWIPA koe hmai hoi hmuitui hmaisawi thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Hahoi tutan buet touh bout na thokhai han. Aron hoi a capanaw ni tutan e lû dawk a kut a toung awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tutan hah na thei vaiteh, a thi hah na la vaiteh, Aron e aranglae hnârakong koe, a capanaw e aranglae hnârakong koe, aranglae kutpui hoi a capanaw e aranglae khokpuinaw dawk na nep pouh vaiteh, khoungroe lathueng lah a thi hah na kathek han. ");
INSERT INTO cth_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Hahoi khoungroe dawk e thi hoi hluk e satui hah na la vaiteh, Aron hoi a capanaw hoi, ahni koe kaawm e a capanaw e hninaw dawk na kathek han. Hahoi teh, a hni hoi ama hoi a capanaw hoi, ahnimouh koe kaawm e a capanaw e hninaw pueng teh, thoung sak lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Hahoi tutan e thaw, mai, ruen ka kayo e thâw, thin dawk kaawm e hmue, kuen kahni touh e hoi, aranglae loung hah na la han. Bangkongtetpawiteh, hothateh, kapek e tuca doeh. ");
INSERT INTO cth_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Hahoi, tangthung dawk ta e tonphuenhoehe hah BAWIPA hmalah hung e vaiyei tueng buet touh hoi satui hoi sak e vaiyei phen, vaiyei ka rapam e kahni touh na la vaiteh, ");
INSERT INTO cth_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Aron e kut hoi a capanaw e kut dawk na ta pouh han. BAWIPA hmalah kahek thueng nahanelah a kahek awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Hote hah ahnimae kut dawk hoi na la pouh vaiteh, BAWIPA hanlah hmuitui lah thuengnae hmaisawinae khoungroe dawk sawi han. Hothateh BAWIPA hanlah hmaisawi thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Hahoi, Aron e kapeknae lah tu takuep hah na la vaiteh, BAWIPA hmalah kahek thueng nahanlah na kahek han. Hot teh na ham lah ao han ");
INSERT INTO cth_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Aron hoi a capanaw e ham lah kapek e tutan takuep hah kahek thuengnae hoi tawm thuengnae lah a phai kahek tangcoung e hoi tawm tangcoung e hah na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Hothateh, Isarel catounnaw koe, Aron hoi a capanaw hanlah a yungyoe hoi kapek e lah ao han. Bangkongtetpawiteh, hothateh kahek thuengnae doeh. A loung kahek tangcoung e hoi tawm tangcoung e hah na thueng sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Hote hnonaw hoi a kamthoup awh teh, satui hluk teh kathounge lah ao thai awh nahan, kathounge Aron e khohna teh, a capanaw ni râw lah a coe awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Hahoi, a capanaw yueng lah vaihma thaw ka tawk hane tami ni hmuen kathoung koe tawk awh hanelah, kamkhuengnae lukkareiim dawk a kâen navah, hnin sari touh thung a khohna han. ");
INSERT INTO cth_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Hahoi, kapeknae tutan hah la vaiteh, a moi hah hmuen kathoung dawk a thawng awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Hottelah, Aron hoi a capanaw ni tutan moi hoi tangthung dawk e vaiyei hah kamkhuengnae lukkareiim takhang koe a ca awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Yonthanae, ama kapeknae hoi thoungnae dawk poe e moi hah a ca awh han. Kathounge lah ao dawkvah, alawilae taminaw ni cat thai mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Hote kapeknae moi hoi vaiyei hah a tangtho amom totouh cawi pawiteh, hmaisawi lah ao han. Hot teh kathounge lah ao dawkvah na cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Hahoi kâ na poe e naw pueng patetlah Aron hoi a capanaw lathueng vah ka sak han, hnin sari touh thung na kapek awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Hnintangkuem yontha nahanlah maitotan buet touh pou na poe awh han. Hahoi yon ngaithoumnae na sak navah, khoungroe hah na thoungsak han. Thoungsak hanelah satui na awi han. ");
INSERT INTO cth_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hnin sari touh thung khoungroe hanlah yonthanae na sak vaiteh, na thoung sak han. Hat toteh, khoungroe teh kathounge lah ao vaiteh, khoungroe ka tek e pueng teh, a thoung awh han. ");
INSERT INTO cth_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Hethateh, khoungroe dawk na poe hane naw doeh. Kathounge tuca kum touh e kahni touh na la vaiteh, ");
INSERT INTO cth_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","tuca buet touh e hah amom lah na poe vaiteh, alouke tuca buet touh e hah tangmin lah na poe han. ");
INSERT INTO cth_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tuca buet touh na poe e dawk e tavai ephah pung hra pung touh, satuium hin pung pali pung touh hoi na kalawt han ( hin teh galon buet touh doeh). Hahoi nei thueng hanelah misurtui hin pung pali pung touh na poe han. ");
INSERT INTO cth_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tuca buet touh e teh amom lah na poe vaiteh, hot teh amom vah ca hane poenae hoi nei hane poenae hmuitui, BAWIPA hanlah hmaisawi thuengnae lah na poe han. ");
INSERT INTO cth_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Hot teh na ca catounnaw totouh kamkhuengnae lukkareiim takhang koevah, BAWIPA hmalah hmaisawi thuengnae pou poe hane doeh. Hote hmuen koevah, nang koe lawk deinae lahoi na kâhmo han. ");
INSERT INTO cth_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Isarel catounnaw hoi hawvah kâpato vaiteh, kamkhuengnae lukkareiim teh bawilennae hoi thoungsak lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Kamkhuengnae lukkareiim hoi khoungroe kathoung sak han. Aron hoi a canaw hoi kai hanelah vaihma thaw tawk laihoi ka thaw a tawk thai awh nahan ka thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Hottelah Isarel catounnaw koevah, kho ka sak vaiteh, a cathut lah ka o han. ");
INSERT INTO cth_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Izip ram hoi ka tâcawtkhaikung, kai teh ahnimae Cathut Jehovah lah ka o tie hah a panue awh han. Ahnimouh rahak vah kai Jehovah doeh ahnimae Cathut ka awm han. ");
INSERT INTO cth_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Hahoi, hmuitui sawinae khoungroe anri thing hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ayung dong touh, adangka dong touh, a rasang dong touh hoi takin pali touh lah na sak vaiteh, a ki hateh khoungroe hoi a kâkuet han. ");
INSERT INTO cth_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","A lathueng lae hoi a tapang hoi a ki hah sui kathoung hoi na hluk awh vaiteh, petkâkalup lah sui hoi arai na pacawp han. ");
INSERT INTO cth_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Arai pacawpnae rahim vah suilaikaw kahni touh na sak han. Avangvanglah na ta vaiteh, hothateh kâkayawtnae acung hrawt nahane doeh. ");
INSERT INTO cth_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Acung teh anri thing hoi na sak vaiteh, sui tui hoi na bu sin han. ");
INSERT INTO cth_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Hothateh kai ni na pato nahane hmuen lawkpanuesaknae tanae thingkong ngue nahanelah yaphni hmalah hote khoungroe hah na hruek han. ");
INSERT INTO cth_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Hottelah Aron ni hawvah, hmaisawi hane hmuitui hah a sawi han. Amom karawitawi hmaiim a rakueng navah a sawi han. ");
INSERT INTO cth_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Aron ni tangmin lah hmaiim paangnae tueng dawkvah, hmuitui hah hmai a sawi han. Hothateh, na ca catounnaw totouh BAWIPA hmalah hmuitui lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Hawvah hmuitui alouke thoseh, hmaisawi thuengnae thoseh, rawca thuengnae thoseh na poe mahoeh. Hawvah, nei hane na poe e hai na awi mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aron ni kum touh dawk vai touh yonthanae sathei thi hah a la vaiteh, kinaw dawkvah yonthanae a sak han. Na ca catounnaw totouh kum touh dawk vai touh yonthanae a sak awh han, hot teh BAWIPA hanelah kathoungpounge doeh. ");
INSERT INTO cth_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Isarel catoun milu na touk toteh, milu na touk e yit touh tami pueng ni hringlu ratang nahanelah BAWIPA a poe awh han. Na touk toteh ahnimouh na touk dawkvah, ahnimouh koe lacik a pha hoeh nahanelah, ");
INSERT INTO cth_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","hetheh a poe awh hanelah ao. Touk tangcoung e naw pueng ni, hmuen kathoung koe hno khingnae a khing tangawn hah BAWIPA hanlah a poe awh han ( Khing touh teh gerah 20 touh doeh). ");
INSERT INTO cth_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Touk tangcoung e kum 20 lathueng pueng ni, BAWIPA hanelah a poe awh han. ");
INSERT INTO cth_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Na hringlu ratang nahanelah, BAWIPA hanelah na poe awh pawiteh, khing tangawn hlak kapap lah tami ka tawnta ni poe mahoeh. Hahoi ka mathoe ni hai hothlak kayoun lah poe mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Isarel catounnaw yontha nahane tangka teh na la vaiteh, kamkhuengnae lukkareiim dawk thawtawknae lah na pouk han. Na hringlu yontha nahane BAWIPA hmalah Isarel catounnaw hanlah Pahnim hoeh nahanlah ao nahan, telah a dei. ");
INSERT INTO cth_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","kâpasu nahanlah rahum kawlung hoi pâhung nahanlah amkhoung na sak han. Lukkareiim hoi khoungroe rahak na ta han. ");
INSERT INTO cth_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Ahnimouh teh kamkhuengnae lukkareiim thung a kâen awh nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","BAWIPA koe hmaisawi thuengnae thueng hanelah, khoungroe koe a hnai nah thoseh, ");
INSERT INTO cth_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","due hoeh nahanelah, amamae kut khok hah a pâsu awh han. Hottelah ahnimouh hoi ahnimae ca catounnaw ni tarawi hane kâlawk lah ao telah ati. ");
INSERT INTO cth_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Hothloilah BAWIPA ni Mosi koevah, ");
INSERT INTO cth_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","hmuituinaw thung dawk a hmui katuipounge murah sekel 500 touh hoi nakzik hmuitui khing 250, ");
INSERT INTO cth_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","nakzik phun louk khing 500, olive satui pong 12 touh (hin buet touh) na thokhai vaiteh, ");
INSERT INTO cth_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","hmuitui kasakkung ni a sak e patetlah hluk e satui hah kathounge satui lah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Kamkhuengnae lukkareiim, lawkpanuesaknae thingkong, ");
INSERT INTO cth_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","caboi hnopainaw, hmaiimkhok, hmuitui hmaisawinae khoungroe, ");
INSERT INTO cth_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","hmaisawi thuengnae khoungroe hoi hnopainaw, kawlung hoi pâhungnae amkhoung pueng hah hote hmuitui hoi koung na hluk han. ");
INSERT INTO cth_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kathoung katang e lah ao awh nahan, na thoung sak vaiteh, hote hno ka tek e pueng teh a thoung awh han. ");
INSERT INTO cth_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Haw hanelah, vaihma thaw tawk laihoi, ka thaw a tawk thai awh nahanelah, Aron hoi a capanaw hah satui na awi vaiteh, na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Isarel catounnaw koe, hete satui heh na ca catounnaw koe totouh kaie hluk e satui kathoung lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tami tak dawk na awi mahoeh. Hete sak e hoi saknae kâvan e alouke hai na sak mahoeh. Hethateh a thoung teh, nangmouh hanlah kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Apipatethai het hoi kâvan lah a sak hai thoseh, ayâ alouk hanlah a hno hai thoseh, hote tami teh a miphun dawk hoi na takhoe han telah na dei han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","BAWIPA ni Mosi koe a hmui katuipounge hmuitui satacte hoi onycha hoi galbanum hah na la han. Hmuituipoung e ka pâcim e frankinsen hah suekâvan lah na khing vaiteh, ");
INSERT INTO cth_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","hmuitui kasakkungnaw patetlah palawi na phuen vaiteh, ka pâcim lah kathoungcalah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","A tangawn teh katipcalah phawm hane doeh. Kai ni na pato nahane lukkareiim thung e lawkpanuesaknae hmalah na ta han. Hothateh, nang hanelah kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hote hmuitui na sak hane na pâtu e patetlah sak e teh, namamouh hanelah na sak mahoeh. BAWIPA hanelah kathounge lah na pouk awh han. ");
INSERT INTO cth_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Tami bangpatet nihai, phunep rumram hanelah hot patet e sak pawiteh, hote tami teh a miphun thung hoi, takhoe lah ao han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","BAWIPA ni Mosi koevah, ");
INSERT INTO cth_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Khenhaw! Judah miphun thung dawk hoi Hur capa Uri, hote capa Bezalel hah ka kaw toe. ");
INSERT INTO cth_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Ahni teh lungangnae, thoumthainae, panuenae hoi bangpueng dawk kutsakthoumnae hoi, ");
INSERT INTO cth_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","sak hane Lungkaangcalah poukthainae hoi, ");
INSERT INTO cth_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","talung phu kaawm ka ta teh, bawng thainae, kâpicalah thing a thainae hoi bangpueng dawk kutsakthoumnae a tawn hanlah Cathut Muitha hoi kakawi sak toe. ");
INSERT INTO cth_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Khenhaw! ahni koe thaw tawk hanlah, Ahisamak e capa Oholiab teh kai ni yo ka pouk toe. Tawk hanelah kâ ka poe e naw, ");
INSERT INTO cth_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","tamimaya kamkhuengnae lukkareiim, lawkpanuesaknae thingkong, avan vah lungmanae tungkhung hoi lukkareiim dawk e hnopainaw pueng, ");
INSERT INTO cth_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","caboi hoi hnopai, kathounge sui hoi sak e hmaiimkhok hoi a hnopainaw pueng, hmuitui sawinae khoungroe, ");
INSERT INTO cth_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","hmaisawi thuengnae khoungroe hoi a hnopainaw pueng, hlaam, ");
INSERT INTO cth_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","khohna kahawicalah pathoupnae hoi vaihma thaw a tawk nah a khohna hanelah, vaihma Aron hanlah kathounge khohna, ");
INSERT INTO cth_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Kâhluk e satui hoi hmuitui kathoung hanlah hmuitui sak thai nahanlah kutsakthoumnae, lungangnae pueng ka poe. Tawk hanlah kâ ka poe e naw pueng hah a sak awh han telah a dei. ");
INSERT INTO cth_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hahoi BAWIPA ni Mosi koevah, ");
INSERT INTO cth_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Isarelnaw koevah hettelah dei pouh, kaie sabbath hah na ya awh han, bangkongtetpawiteh na ca catounnaw totouh kai hoi nangmae rahak vah mitnoutnae lah ao. Kai teh nangmouh na kathoungsakkung Jehovah lah ka o tie hah na panuethai awh nahane doeh. ");
INSERT INTO cth_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Hatdawkvah, sabbath heh na ya awh han. Bangkongtetpawiteh, hot teh nangmouh hanlah kathounge lah ao. Ka ek e pueng teh thei lah ao han. Hote hnin dawk Bangpatete thaw hai ka tawk e pueng teh a miphun koehoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Hnin taruk touh thung thaw tawk awh naseh. A sari hnin teh kâhatnae sabbath, BAWIPA hanlah hnin kathoung doeh. Apihai sabbath hnin vah thaw tawk pawiteh, thei lah ao roeroe han. ");
INSERT INTO cth_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Hatdawkvah, Isarelnaw ni sabbath teh a ca catoun totouh a yungyoe lawkkam lah awm seh. ");
INSERT INTO cth_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kai hoi Isarelnaw rahak vah, a yungyoe mitnoutnae doeh. Bangkongtetpawiteh, hnin taruk touh thung vah BAWIPA ni talai hoi kalvan a sak teh, asari hnin dawk a kâhat teh a thoung sak, na ti pouh han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Hottelah Sinai mon vah koung a kâpato hnukkhu, lawkpanuesaknae lungphen kahni touh, Cathut e kutdawn hoi thut e hah Mosi koe a poe. ");
INSERT INTO cth_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mosi teh mon hoi kum laipalah ngailawi ao toe tie tamimaya ni a panue awh toteh, tamimaya teh Aron koe a kamkhueng awh teh ahni koe thaw haw, kai mouh han lah na kahrawikung cathut sak haw. Bangkongtetpawiteh, Izip ram hoi na katâcawtkhaikung Mosi e bang pawlawk hai thai hoeh toe, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron ni, na yunaw hoi na capanaw hoi na canunaw a pacap awh e suihnapacap hah rading awh nateh kai koe thokhai awh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Hottelah tami pueng ni suihnapacap a pacap awh lahun e hah a rading awh teh Aron koe a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aron ni ahnimouh koe e a la teh, hreca hoi a thuk teh, maitoca meikaphawk lah a hlun. Hahoi ahnimouh ni Oe Isarelnaw, hetteh Izip ram hoi na katâcawtkhaikung nangmae cathut doeh, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aron ni a hmu toteh, a hmalah khoungroe hah a sak. Aron ni, tangtho vah BAWIPA hanlah pawi awm naseh telah a oung sak. ");
INSERT INTO cth_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Hottelah a tangtho vah, amom a thaw awh. Hmaisawi thuengnae a poe awh, roum thuengnae hah a poe awh teh, tamimaya teh canei hanelah a tahung awh teh lamtu hanlah a thaw awh, ");
INSERT INTO cth_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","BAWIPA ni Mosi a pato teh, kum leih. Bangkongtetpawiteh, na taminaw Izip ram hoi na tâcokhai e naw hah amamouh hoi amamouh koung a kâraphoe awh toe. ");
INSERT INTO cth_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kaie kâpoelawk hah tang a phen takhai awh toe. Maitoca meikaphawk a sak awh teh a bawk awh teh, hot koe thuengnae a sak awh teh, Oe Isarel hetheh Izip ram hoi na katâcawtkhaikung doeh ati awh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","BAWIPA ni Mosi koe hete taminaw hah ka khet toe, a lung ka patak poung e miphun doeh. ");
INSERT INTO cth_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Hatdawkvah, ahnimouh hmai koung sawi hanelah, ahnimouh lathueng ka lungkhueknae heh kaman naseh, nang heh ka lentoe e miphun lah na sak han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mosi ni, BAWIPA Cathut koe, BAWIPA bangkongmaw kalen e thaonae hoi thaonae kut hoi Izip ram hoi na tâcosak e na taminaw lathueng vah na lungkhueknae teh a kaman. ");
INSERT INTO cth_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Bangkongmaw Izipnaw ni monsom vah patawnae poe hane hoi, thei hanelah a tâcokhai awh, telah a dei awh han. Puenghoi na lungkhueknae hah roum sak nateh, na taminaw lathueng vah, hawihoehnae sak han na noe e heh kâhno lawih. ");
INSERT INTO cth_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Na san Abraham hoi Isak hoi Isarel koevah kalvan e âsinaw yit touh na catounnaw ka pung sak vaiteh, ka dei tangcoung ram heh na catoun ka poe vaiteh, a yungyoe a coe awh han, telah amahoima noe lahoi lawk na kam tangcoung e hah pahnim hanh lah a telah a kâhei. ");
INSERT INTO cth_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hot patetlah BAWIPA teh, a taminaw lathueng vah thoenae ka sak han ati nakoehoi a kâhno. ");
INSERT INTO cth_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mosi teh a kamlang teh monsom hoi a kum teh, a kut dawk lawkpanuesaknae lungphen kahni touh ao. Lungphen teh avoivang lah thut e doeh. ");
INSERT INTO cth_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Lungphen teh Cathut ni sak e lah ao teh, thut e naw teh Cathut ma roeroe ni lungphen dawk thut e doeh. ");
INSERT INTO cth_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Hahoi Joshua ni tamimaya pawlawk a thai toteh, Mosi koevah, roenae hmuen koe kâtuknae ao nahoehmaw telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Hatei, ahni ni tânae pawlawk nahoeh, tâ e naw e hramki lawk hai nahoeh. Hateiteh, ka thai e heh la sak pawlawk doeh ati. ");
INSERT INTO cth_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Hahoi, roenae teng a pha tahma hoi maitoca meikaphawk hoi kalamtunaw hah a hmu. Hottelah Mosi lungkhueknae teh a kaman teh lungphen a sin e hah a tâkhawng teh mon khok koe a kâbawng. ");
INSERT INTO cth_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","A sak awh e maitoca hah a la teh, hmai a phum teh vitkatip lah a phom. Tui dawk a phuen teh Isarelnaw hah a nei sak. ");
INSERT INTO cth_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mosi ni Aron koevah, hettelah totouh yonnae kalen hah ahnimouh lathueng pha sak hanelah, hetnaw ni nang lathueng bangmaw a sak awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron ni ka bawipa lungkhueknae heh kaman payon hanh naseh. Hete tamimayanaw heh hawihoehnae koe lah pou kangvawinaw doeh tie teh na panue toe. ");
INSERT INTO cth_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bangkongtetpawiteh, kai koevah, kaimouh na ka hrawi hanelah cathut hah na sak pouh. Bangkongtetpawiteh, Mosi Izip ram hoi na kahrawikung heh a kamthang banghai thai e lah awm hoeh toe telah ati awh. ");
INSERT INTO cth_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kai ni ahnimouh koe, sui katawnnaw ni rading awh naseh, ka ti pouh teh na poe awh. Hmai dawk ka phum toteh hete maitoca meikaphawk heh a tâco telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Hahoi tamipueng khenyawn laipalah a ngai patetlah kho a sak awh tie hah a hmu teh, bangkongtetpawiteh, a tarannaw hmunae koe Aron ni khenyawn awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mosi teh roenae rim longkha koe a kangdue teh, BAWIPA koelah kampang e pueng kai koe tho awh naseh, telah ati. Hattoteh Levih capanaw pueng teh ahni koe a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ahnimouh koe, BAWIPA Cathut ni, tami pueng ni na tahloi lat awh nateh, roenae hmuen koe kâennae longkha koehoi tâconae longkha koe totouh, na hmaunawngha thoseh, na huiko thoseh, na imri thoseh thet awh atipouh. ");
INSERT INTO cth_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Hatdawkvah, Levih capanaw ni Mosi ni dei e patetlah a sak awh teh, hot hnin vah tami 3, 000 tabang a due awh. ");
INSERT INTO cth_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Hattoteh Mosi ni, sahnin yawhawinae na poe awh nahanelah, na mahmawk BAWIPA hanelah kâhmoun awh. Bangkongtetpawiteh, tami pueng ni a capa hoi a hmaunawngha hah a taran toe, telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Hahoi, a tangtho vah Mosi ni tamimaya koevah, yonnae kalen na sak awh toe. Hatdawkvah, BAWIPA koe ka ceitakhang han. Na yonnae yontha thai han vaimoe, telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Hottelah Mosi teh BAWIPA koe a ban teh, Oe hetnaw ni yonnae kalen a sak awh teh, sui cathut hah a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Hatei nakunghai, a yonnae hah ngaithoum pouh haw. Hatei, na ngaithoum hoehpawiteh na cauk dawk na thut e ka min hah raphoe hanelah ka kâhei atipouh. ");
INSERT INTO cth_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","BAWIPA ni Mosi koevah, kai taranlahoi yonnae ka sak e pueng teh, ka cauk dawk hoi a min ka raphoe han. ");
INSERT INTO cth_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Hatdawkvah cet nateh, ka dei e hmuen koe tamimaya hah cetkhaih. Khenhaw! kaie kalvantaminaw na hmalah a cei han. Hatei, rek hanelah ka hloe awh nah hnin vah, a yonnae dawk roeroe ka rek awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Hottelah Aron ni a sak e patetlah maitoca meikaphawk a sak awh dawkvah, BAWIPA ni tamimaya teh a rek. ");
INSERT INTO cth_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hottelah BAWIPA ni Mosi hah a pato teh, hi hoi tâcawt awh nateh, Abraham, Isak hoi Jakop koevah, na catounnaw hanelah na poe han telah thoebo laihoi lawk ka kam e ram dawk, nang hoi Izip ram hoi na tâcokhai e naw hoi cet takhang awh. ");
INSERT INTO cth_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Nangmae hmalah kalvantami ka patoun vaiteh, Kanaan taminaw, Amor taminaw, Hit taminaw, Periznaw, Hivnaw hoi Jubusitnaw hah ka pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Khoitui hoi maitosanutui a lawngnae ram dawk cet takhang awh. Bangkongtetpawiteh, kai teh nangmouh koe ka cet takhang van mahoeh. A lung ka patak poung e lah na o awh dawkvah, lamlak vah koung na pathup payon han doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Hottelah tamimaya ni hete kamthang kathout a thai awh toteh, a ka awh teh apihai kamthoup ngai awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Bangkongtetpawiteh, BAWIPA ni Mosi koe Isarel catounnaw koe vah, a lung ka patak poung e miphun lah na o awh, nangmouh koe dongdeng ka o nakunghai, koung na pathup awh han. Hatdawkvah nangmouh koe ka sak hane ka panue thai nahanelah, na kamthoupnae pueng hah koung rading awh telah a dei toe. ");
INSERT INTO cth_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Hatdawkvah Isarelnaw ni a kamthoupnae hah Horeb mon vah a kârading awh. ");
INSERT INTO cth_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mosi ni Lukkareiim hah a ceikhai teh, roenae lawilah betbet ahlanae koe ouk a yap. Hot hah kamkhuengnae lukkareiim ati awh. Hahoi BAWIPA tawng ka ngai e pueng teh, roenae lawilah kamkhuengnae lukkareiim dawkvah ouk a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Hahoi, Mosi teh lukkareiim pâtam hoi a cei lahun nah, tamimaya a thaw awh teh amamae rim takhang koe a kangdue awh teh, Mosi lukkareiim thung a kâen totouh a khet awh. ");
INSERT INTO cth_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Hahoi Mosi teh lukkareiim dawk a kâen tahma vah, tâmaikhom a kum teh lukkareiim takhang koe a kangdue teh BAWIPA ni Mosi hah a pato. ");
INSERT INTO cth_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Hahoi tamimaya ni lukkareiim takhang koe tâmaikhom a kangdue e hah a hmu awh. Hat toteh, tamimaya teh a thaw awh teh, amamae rim takhang koehoi lengkaleng a bawk awh. ");
INSERT INTO cth_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Tami ni a hui a pato e patetlah, BAWIPA ni Mosi hah minhmai kâhmo laihoi a pato teh, roenae hmuen koe lah a ban. A san Nun capa thoundoun Joshua hateh lukkareiim cettakhai boihoeh. ");
INSERT INTO cth_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mosi ni BAWIPA koevah, khenhaw! nang ni kai koevah hetnaw heh luenkhai loe ati. Hatei apimaw kai koe na patoun han tie teh na panuek sak hoeh rah. Hatei, nang ni na min lahoi na panue teh, ka mit dawk minhmai kahawi ka hmu, na ti pouh. ");
INSERT INTO cth_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Hatdawkvah, na mit dawk minhmai kahawi ka hmawt pawiteh, ka panue nahan hoi na mithmu vah pahrennae ka hmu thai nahanlah lamthung na panuek sak haw, telah ka kâhei. Hete miphun heh na tamimaya doeh tie hah pouk, telah ati. ");
INSERT INTO cth_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ahni ni, nangmouh koe ka o vaiteh, kâhatnae na poe awh han atipouh. ");
INSERT INTO cth_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ahni ni, kai koevah na cet hoehpawiteh, hete hmuen koehoi na tâcawt sak hanh. ");
INSERT INTO cth_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Bangkongtetpawiteh, kaimouh koe na cet laipalah kai hoi na taminaw teh na mithmu vah lungmanae ka hmu awh tie hah, bangtelamaw ka panue awh han. Hottelah talai van kaawm e taminaw pueng koehoi kai hoi na taminaw teh ka pek e lah ka o awh han, atipouh. ");
INSERT INTO cth_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","BAWIPA ni Mosi koevah, hot hai na dei e patetlah ka sak han. Bangkongtetpawiteh, ka mit dawk na kuep teh na min lahoi na panue telah atipouh. ");
INSERT INTO cth_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ahni ni na bawilennae teh pahren lahoi na hmawt sak haw atipouh. ");
INSERT INTO cth_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ahni ni, ka hawinae pueng heh na hmalah ka kamnue sak vaiteh, Jehovah min hah na hmalah ka pâpho han. Pahren han ka ngai e hah ka pahren vaiteh, ka lungma han ka ngai e pueng hah ka lungma han, atipouh. ");
INSERT INTO cth_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hatei ahni ni, ka minhmai teh na hmawt thai mahoeh, bangkongtetpawiteh na ka hmawt e tami hring boihoeh, ati. ");
INSERT INTO cth_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","BAWIPA ni khenhaw! ka teng vah hmuen buet touh ao, lungsong van na kangdue han. ");
INSERT INTO cth_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Hahoi, ka bawilennae ni na ceihlawi navah, kâbawng e lungsong thungvah na ta han, na ceitakhai hoehroukrak ka kut hoi na tabuem han. ");
INSERT INTO cth_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Hahoi ka kut hah bout ka la vaiteh ka hnukthun hah na hmu han, hatei, ka minhmai teh na hmawt mahoeh, atipouh. ");
INSERT INTO cth_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","BAWIPA ni Mosi koevah, lungphen kahni touh a hmaloe e patetlah sak nateh hote lungphen dawkvah ahmaloe e patetlah bout ka thut han. ");
INSERT INTO cth_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Tangtho vah coungkacoe lah awmh, amom Sinai mon dawk luen nateh, monsom ka hmalah kangdout. ");
INSERT INTO cth_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nang koe apihai tho awh hanh naseh. Mon vah apihai kamnuek awh nahanh seh. Tuhu hoi maitohu naw hai mon teng vah pâ awh nahanh seh ati. ");
INSERT INTO cth_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Hottelah lungphen kahni touh hmaloe e patetlah a sak. Hahoi Mosi teh amom vah a thaw teh BAWIPA ni kâ a poe e patetlah lungphen kahni touh hah a sin teh, Sinai mon dawk a luen. ");
INSERT INTO cth_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","BAWIPA teh tâmai hoi a kum teh, a teng vah a kangdue teh BAWIPA e min hah a pathang. ");
INSERT INTO cth_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","BAWIPA ni a ceihlawi teh Jehovah, Jehovah, lungmanae hoi kakawi e Cathut, pahrennae, lungsawnae lungmanae hoi lawkkatang hoi akawi. ");
INSERT INTO cth_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Tami a thongsang koe pahrennae kamnueksakkung, payonnae hoi lawkeknae hoi, hawihoehnae kangaithoumkung, yonpennae ka tâcawtkhai boihoeh e, napanaw payonnae dawk canaw catoun totouh, se thum se pali totouh karekkung doeh telah a pâpho. ");
INSERT INTO cth_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mosi ni karanglah talai dawk a tabo teh a bawk. ");
INSERT INTO cth_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ahni ni, Atuvah BAWIPA na mit dawk minhmai kahawi ka hmawt pawiteh, kai koevah kaie BAWIPA heh cet van naseh telah ka kâhei. A lung ka patak e miphun lah ka o awh nakunghai ka payonnae hoi ka yonnae hah na ngaithoum nateh, na râw lah na tawn lawih telah ati. ");
INSERT INTO cth_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ahni ni, khenhaw! lawkkamnae ka sak. Talai pueng hoi miphun pueng dawk sak boihoeh e kângairu hno hah na taminaw pueng hmalah ka sak vaiteh, nangmouh kaawm e na taminaw pueng ni BAWIPA ni sak e hah a hmu awh han. Bangkongtetpawiteh, nangmouh koe ka sak hane heh takikathopounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Sahnin vah kâ na poe e naw heh pouk. Khenhaw! Amornaw, Kanaannaw, Hitnaw, Hivnaw, Periznaw hoi Jebusitnaw hah na hmalah hoi ka pâlei han. ");
INSERT INTO cth_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kâhruetcuet, hoehpawiteh na cei nahane ram dawk kaawmnaw hoi lawkkamnae na sak awh vaiteh, nangmouh hanlah karap lah awm payon vaih. ");
INSERT INTO cth_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Hateiteh ahnimae khoungroe hah, koung na raphoe pouh han. Talung a ung awh e hai rekrek dei awh nateh, thing meikaphawk hah koung tâtueng pouh awh. ");
INSERT INTO cth_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","A min patenghai dipma Jehovah lah ao, Cathut teh a dipma thai dawkvah Cathut alouke roeroe na bawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Hoehpawiteh hote ram dawk e taminaw hoi lawk na kam awh vaiteh, ahnimae cathut koe kâyo laihoi ahnimae cathut koe thueng laihoi buetbuet touh coun vaiteh, thuengnae moi hah ca hoi, ");
INSERT INTO cth_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","na capanaw hanelah ahnimae canunaw hah na paluen vaiteh, a canunaw ni a cathutnaw koe a kâyo awhnae koe, na capanaw hai kâyawt payon awh langvaih. ");
INSERT INTO cth_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Thuk e meikaphawk cathut hah na sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Tonphuenhoehe vaiyei pawi na sak han. Kâ na poe awh e patetlah, hnin sari touh thung tonphuenhoehe hah Abib thapa dawk khoe e tueng nah na ca han. Bangkongtetpawiteh, Abib thapa dawkvah Izip ram hoi na tâco awh. ");
INSERT INTO cth_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Camoim ka paawng e pueng kaie doeh. Na saring pueng maito hoi tu camin teh kaie doeh. ");
INSERT INTO cth_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Hatei la camin teh tuca hoi na ratang han. Na ratang ngaihoeh pawiteh, a lahuen na kapai pouh han. Na capa camin teh na ratang han. Ka hmaitung vah apihai kuthrawng hoi na tâcawt awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Hnin taruk touh thung thaw na tawk han. Asari hnin dawk na kâhat han. Laikawk na tawk tue nah hoi canga tue nahai na kâhat han. ");
INSERT INTO cth_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Yat pawi, takhawk pawi, cavanca pawi na to han. ");
INSERT INTO cth_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tongpa pueng kum touh dawk vai thum touh Bawipa Jehovah Isarel Cathut hmalah a tâco awh han. ");
INSERT INTO cth_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Bangkongtetpawiteh, na hmalah miphunnaw ka pâlei vaiteh na ramri hah ka kaw sak han, kum touh dawk vai thum touh BAWIPA na Cathut hmalah na tâco awh nahanlah na cei toteh apinihai na ram hah noe awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Kai hanelah thuengnae thipaling teh ton phuen e vaiyei hoi na poe mahoeh. Ceitakhai pawi thuengnae haiyah atangtho totouh na awm sak mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Na law dawk e aluepaw teh BAWIPA im dawk na thokhai han. Hmaeca e moi hah a manu e sanutui hoi mek na thawng mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","BAWIPA ni Mosi koe, hete lawknaw heh thun haw, bangkongtetpawiteh, hete lawknaw tarawi lahoi nang koehoi Isarel koevah lawkkamnae ka sak, telah ati. ");
INSERT INTO cth_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Hawvah BAWIPA koe hnin 40 rum 40 touh ao teh, rawca cat laipalah ao teh, tui hai net hoeh. Hahoi lungphen dawk lawkkam kâpoelawknaw hra touh a thut. ");
INSERT INTO cth_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Hahoi, Mosi teh lawkpanuesaknae lungphen kahni touh hah a kut hoi a sin teh Sinai mon hoi a kum navah, Mosi ni hottelah a kâpato dawkvah, ka minhmai vuen a ang tie hah panuek hoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aron hoi Isarelnaw pueng ni Mosi a hmu awh toteh, khenhaw! minhmai vuen a ang teh hnai ngam awh hoeh. ");
INSERT INTO cth_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mosi ni ahnimouh teh a kaw teh, Aron hoi kamkhueng e lawkcengkungnaw pueng hah ahni koe a ban awh teh Mosi ni ahnimouh teh a pato. ");
INSERT INTO cth_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Isarelnaw pueng ni a hnai awh hnukkhu Sinai mon vah BAWIPA hoi lawk a kâpato roi e naw pueng patetlah ahnimanaw hah kâ a poe. ");
INSERT INTO cth_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosi ni lawk be a dei toteh, a minhmai teh minhmai ramuknae hoi a ramuk. ");
INSERT INTO cth_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Hatei ahni hoi lawk kâpato hanelah BAWIPA hmalah Mosi a luen nah tangkuem vah, bout a pato hoehroukrak a minhmai ramuknae hah ouk a hawng. Hahoi a pato teh kâ a poe e naw hah Isarelnaw koe ouk a dei pouh. ");
INSERT INTO cth_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Isarelnaw ni Mosi minhmai a khet awh nah tangkuem vah, Mosi minhmai vuen teh a ang. Hahoi Mosi teh Cathut hoi kâpato hanelah a kâen hoehroukrak a minhmai ramuknae hoi a minhmai teh ouk a ramuk. ");
INSERT INTO cth_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mosi ni Isarelnaw koung a kamkhueng sak teh ahnimouh koe, BAWIPA ni tarawi hanelah kâlawk na poe e naw teh hetnaw hah doeh. ");
INSERT INTO cth_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Hnin taruk touh thung thaw na tawk awh toe. Asari hnin teh nangmouh hanelah hnin kathoung doeh. BAWIPA hanelah kâhatnae sabbath hnin doeh. Hot hnin vah thaw ka tawk e tami pueng teh na thei awh han. ");
INSERT INTO cth_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Sabbath hnin vah kho na sak awhnae koe hmai na patawi awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Hahoi Mosi ni Isarel kamkhuengnaw pueng koevah, hetheh BAWIPA ni na poe e kâlawknaw doeh. ");
INSERT INTO cth_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","BAWIPA koe pasoumhno sin awh. A lungthung hoi poe han ka ngai e pueng ni BAWIPA hanelah thokhai seh. Sui, Ngun, Rahum, ");
INSERT INTO cth_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kamthim hni, paling hni, âthi hni, loukloukkaang hni, hmaemuen, ");
INSERT INTO cth_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","paling bu e tu pho, saram pho, anri thing, ");
INSERT INTO cth_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","hmaiim hane satui hoi awi hane satui hoi hmaisawi hane hmuitui hoi, ");
INSERT INTO cth_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ephod hoi saiphei nahanelah onyx talung hoi talungnaw sin hanelah poe awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Nangmouh thung dawk kutsak ka thoum e pueng tho awh naseh. BAWIPA ni sak hanelah kâ a poe e hah sak awh naseh. ");
INSERT INTO cth_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Lukkareiim hoi lukkarei, lemphu, pangkhek, thingphek, tapang, khom hoi ung nahane pacawpnae naw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","thingkong hoi kâkayawtnae acung, lungmanae tungkhung, hoi rakhan nahane yaphni hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","caboi hoi kâkayawtnae acung hoi hnopainaw pueng hoi vaiyei tanae hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","hmaiang hanlah hmaiimkhok hoi hnopainaw hoi hmaiim hoi paang hane satui hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","hmuitui hmaisawinae khoungroe hoi kâkayawtnae acung hoi hluk e satui hoi hmaisawi hane hmuitui hoi lukkareiim takhang koe e yap hane yaphninaw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Hmaisawi thuengnae khoungroe rahum cuekkarue hoi kâkayawtnae acung hoi hnopainaw pueng, kawlung hoi pâhungnae hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Lukkareiim thongma yaphni, khom hoi a tapang ungnae pacawpnae naw hoi kalupnae longkha yaphninaw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Lukkarei hetnae hoi thongma hetnae hoi ruinaw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","hmuen kathoung thaw tawknae koe, a meikahawicalah kawng e hnicu hoi vaihma thaw a tawk toteh kâkhu hane vaihma Aron hnicu kathoung hoi a capanaw hnicu hai thoseh BAWIPA ni lawk na thui e patetlah na sak awh han telah patuen a dei. ");
INSERT INTO cth_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Hottelah Isarel catoun kamkhuengnaw pueng teh, Mosi koehoi a ban awh. ");
INSERT INTO cth_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Lungthonae katawnnaw hoi muitha lahoi pasoungnae ka tawn e pueng a tho awh teh, kamkhuengnae lukkareiim hanelah hno hane hoi thaw tawk nahanelah a panki e pueng, kathounge hnicu hanelah BAWIPA hanelah lengkaleng a poe awh. ");
INSERT INTO cth_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Napui hoi tongpa hoi poe ngainae lung ka tawn e pueng a tho awh teh, laikaw, hnâpacap, kuthrawt, hnawngpacap, sui hoi sak e hnopai pueng hah a sin awh. Sui poe hane ka tawn e pueng ni BAWIPA hanelah a poe awh. ");
INSERT INTO cth_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tami pueng ni, kamthim hni, âthi hni, paling hni, loukloukkaang hni, hmaemuen hoi tutan pho paling bu e hoi saram pho ka tawn e pueng ni a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Hahoi tangka hoi rahum ka thokhai e tami pueng ni, BAWIPA hanelah poe hane hah a thokhai awh. Tami pueng ni anri thing, hnopai hanelah hno kamcu e hah a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Kutsakkathoume napui pueng ni, pahla a san awh teh, a pakhit awh e pahla, kamthim, âthi hni, paling hni, Loukloukkaang e hah a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kutsakkathoume napui a lung a kathonaw ni hmaemuen hah a kawng awh. ");
INSERT INTO cth_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Vaihma angki hoi angki akalae patawp hanelah ukkungnaw ni onyx talung hoi talung phu kaawmnaw hah a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Hmuitui hoi satui hoi, paang hane hoi hluk hane satui hoi hmuitui hmaisawi hane thoseh, ");
INSERT INTO cth_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isarel catounnaw ni BAWIPA hanelah ngainae hoi poe e hno hah a poe awh teh, napui hoi tongpa lungthonae ka tawn e pueng ni sak hanelah BAWIPA ni Mosi koe kâ a poe e patetlah tawk nahanelah hnopainaw thoseh a poe awh. ");
INSERT INTO cth_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mosi ni Isarel catounnaw koevah, Khenhaw! BAWIPA ni Judah miphun thung hoi Hur capa Uri, a capa Bezalel hah ");
INSERT INTO cth_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","lungangnae hoi thaipanueknae, panuenae hoi bangpueng koe kutsak thoumnae tawn hanelah Cathut Muitha hoi akawi sak toe. ");
INSERT INTO cth_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Sak hane lungangcalah poukthainae, sui, ngun, rahum dêi thainae, ");
INSERT INTO cth_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","talung phu kaawm pâthit hanelah bawng thainae, meikahawicalah thing a thainae, bangpueng dawk kutsak thoumnae tawn hanelah a kaw toe. ");
INSERT INTO cth_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hahoi ama hoi Dan miphun thung e Ahisamak capa Oholiab hoi ayâ cangkhai thainae hah a lungthung vah a ta pouh toe. ");
INSERT INTO cth_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ahni teh bangpueng dawk kutsak thoumnae, ca thut thainae, mei thuk thainae, imthung pathoup thainae, kamthim, paling, âthi, Loukloukkaangnaw carouk thainae, hnikawngthainae, phunkuep tawk thainae, hoi tawk hane kahawicalah poukthainae tawn hanelah lungangnae hoi akawi sak toe. ");
INSERT INTO cth_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bezalel hoi Oholiab tinaw ni kutsakkathoumnaw pueng BAWIPA ni kâ a poe e patetlah, hmuen kathoung dawk thaw a tawk thai awh nahanelah, thaw phunkuep a tawk thai awh nahanelah lungangnae hoi thaipanueknae a poe e naw pueng ni lengkaleng tawk hane doeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mosi ni Bezalel hoi Oholiab tinaw kutsakkathoume, BAWIPA ni ahnimae lungthin dawk lungangnae a poe teh a thaw tawk hanelah a lungthin dawk lungthonae a poe e naw pueng hah a kaw. ");
INSERT INTO cth_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isarel catounnaw ni hmuen kathoung thawtawknae koe a tâcokhai awh e pueng hah Mosi koehoi a coe awh. Hahoi amom tangkuem ngainae lahoi poe e hah ahni koe pou a poe awh. ");
INSERT INTO cth_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Kutsakkathoumnaw pueng, hmuen kathoung thaw katawknaw pueng ni thaw a tawk awh lahun e hah lengkaleng a ceitakhai awh teh, ");
INSERT INTO cth_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Mosi koevah, BAWIPA ni tawk han kâ a poe e thaw tawk hanelah taminaw ni acawilah hno a sin awh, telah a pathang awh. ");
INSERT INTO cth_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Mosi ni kâ a poe teh, hmuen kathoung hanelah poehno hah napui hai tongpa hai apihai poe hanelah kâcai awh nahanh lawiseh, telah roenae hmuen koe a oung sak. Hottelah taminaw ni a poe awh e hah pasoung hoeh toe. ");
INSERT INTO cth_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bangkongtetpawiteh, a tawn awh tangcoung e hah panki e pueng sak nahanelah a khout toe. Atangcalah apap poung toe. ");
INSERT INTO cth_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ahnimouh thung dawk a lungkaangnaw pueng ni, lukkareiim teh yaphni hra touh hoi a sak awh. Hote yaphni teh Loukloukkaang e hoi carouk e kamthim, paling, âthi naw hoi kathoumnaw ni cherubim mei a sak awh e hah kamnuek lah sak e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Yaphni teh dong 28 touh lengkaleng a saw teh, akaw e teh dong pali touh rip a pha. Yaphni pueng ayung adangka koung a kâvan. ");
INSERT INTO cth_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Yaphni panga touh a kâbet teh, alouke panga touh hai koung a kâbet. ");
INSERT INTO cth_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Patawp e yaphni rui a poutnae koe vah, laikaw kamthim lah sak e lah ao. Hot patetlah patawp e yaphni avanglae a poutnae koe haiyah sak e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Yaphni buet touh dawk laikaw 50 touh a sak teh alouke patawp e dawk haiyah, laikaw 50 touh a sak. Hote laikawnaw teh minhmai kâhmo lah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Hahoi sui hetnae 50 touh a sak teh, hetnae naw ni yaphni hah a hetsin. Hottelah lukkareiim teh rakhan buet touh lah a coung. ");
INSERT INTO cth_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Hahoi lukkareiim lemphu ramuknae lah, Hmae muen yaphni hah hlaibun touh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yaphni teh dong 30 touh saw sak lah ao teh, akaw e teh dong pali touh lengkaleng a pha. Yaphni hlaibun touh teh koung a kâvan. ");
INSERT INTO cth_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Yaphni panga touh hah patawp e lah ao teh, yaphni taruk touh hai patawp e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Patawp e yaphni buet touh a rai poutnae koe vah laikaw 50 touh a sak teh, yaphni patawp e avanglae arai dawk hai laikaw 50 touh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Lukkareiim hah rakhan buet touh lah ao nahanelah, hetsin nahanelah hetsinnae 50 touh hah rahum hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Hahoi tutan pho paling bu e hoi lukkareiim lemphu ramuknae hoi hot van ramuk nahanelah saram pho hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Lukkareiim tapang thung hanelah anri thing hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Thingphek teh dong hra touh asaw teh, dong touh hoi tangawn akaw. ");
INSERT INTO cth_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Thingphek tangkuem dawk a khok kahni touh hoi a kâkuetsak. Hottelah lukkareiim tapang pueng teh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Lukkareiim hanelah tapang thingphek hah a sak teh, akalae tapang hanelah thingphek 20 touh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Hote thingphek 20 touh a kangdue nahanelah ngun pacawp 40 touh a sak. Thingphek buet touh dawk a khok kahni touh pâhung nahanelah pacawp kahni touh rip a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Lukkareiim atunglae hanlah thingphek 20 touh hoi ");
INSERT INTO cth_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ngun pacawp 40, thingphek buet touh hanelah pacawp kahni touh rip a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Lukkareiim kanîloumlah hane thingphek 6 touh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Lukkareiim hnuk lae takin koe hanelah thingphek kahni touh hai a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","A rahim hoi a lathueng lae laikaw totouh a kâkuetsak. A takin roi koe hot patetlah a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Thingphek taroe touh, pâhung nahane ngun pacawp 16 touh hoi ao. Thingphek buet touh pâhung nahanelah pacawp kahni touh rip ao. ");
INSERT INTO cth_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Hahoi lukkareiim tapang pangkhek hanelah anri thing panga touh, ");
INSERT INTO cth_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","lukkareiim avanglah hane panga touh a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","A lungui e tarennae hah avoivang lae takin koe rek a pâcue sak. ");
INSERT INTO cth_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Thingpheknaw hah sui hoi a hluk. Tarennae hrawt nahanelah sui laikaw hai a sak teh, tarennae naw hah sui hoi a hluk. ");
INSERT INTO cth_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Yaphni hanelah kamthim, âthi, paling, loukloukkaang e hni hoi cherubim meikahawicalah a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Hot hanelah anri thing khom pali touh a sak teh sui tui hoi a hluk. Hahoi a bangnae naw teh sui hoi sak e doeh. Hotnaw pâhung nahanelah ngun pacawp pali touh a hlun. ");
INSERT INTO cth_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Hahoi lukkareiim takhang koe yap hanelah, kamthim, âthi, paling, Loukloukkaang e hoi carouk e kathoumnaw ni kahawicalah carouk e hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Hotnaw yap nahanelah khom panga touh, bang nahane naw hoi a sak. Hote khom a som kacoumnaw hoi yapnae khomnaw teh, sui tui hoi hluk e lah ao. Hotnaw pâhung nahanelah pacawp e panga touh hateh rahum hoi sak e doeh. ");
INSERT INTO cth_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezalel ni anri thing e thingkong hah ayung dong hni tangawn, adangka dong touh hoi tangawn, arasang dong touh hoi tangawn hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","A thung hoi alawilah sui tui kathoung hoi hluk e lah ao teh, sui hoi a rai yep e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","A khok pali touh pâhung nahanelah, sui laikaw pali touh a hlun. Laikaw kahni touh e teh avanglah hane a tho teh, alouke kahni touh e teh avanglah hane a tho. ");
INSERT INTO cth_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Hahoi anri thing hoi kâkayawtnae acung hah a sak teh, sui tui hoi a hluk. ");
INSERT INTO cth_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Thingkong hah kâkayawt thai nahanelah a tapang dawk e laikaw dawk a hrawt. ");
INSERT INTO cth_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Sui kathoung hoi lungmanae tungkhung hah a sak teh, ayung dong hni touh hoi tangawn, adangka dong touh hoi tangawn. ");
INSERT INTO cth_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Hahoi cherubim kahni touh hah sui hoi a sak. Lungmanae tungkhung som dawk e roi teh dei lah a dei. ");
INSERT INTO cth_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Avang lae apoutnae koe cherubim buet touh, avanglae apoutnae koe cherubim buet touh, lungmanae tungkhung hoi kâbet sak hanelah avoivang lah apoutnae koe vah cherubim hah a ta. ");
INSERT INTO cth_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubim hah minhmai kâhmo lah, lungmanae tungkhung hah a rathei a kadai teh a khu teh, lungmanae tungkhung koe lah a kangvawi. ");
INSERT INTO cth_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Hahoi anri thing hoi caboi hah a sak teh, ayung dong hni touh, adangka dong touh, arasang dong touh hoi tangawn. ");
INSERT INTO cth_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Hot teh suitui kathoung hoi hluk lah ao teh sui hoi a tâphai hah a pacawp. ");
INSERT INTO cth_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Kuttabei hlawk touh a tâphai a sak teh, sui hoi a pacawp. ");
INSERT INTO cth_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Hot hanelah sui laikaw pali touh a hlun teh, hote laikaw pali touh hah caboi khok pali touh dawk a bet. ");
INSERT INTO cth_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Caboi teh kâkayawt thai nahanelah laikaw teh a tâphai teng vah a bang. ");
INSERT INTO cth_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Caboi teh kâkayawt thai nahanelah acung hah anri thing hoi a sak teh sui tui hoi a hluk. ");
INSERT INTO cth_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Caboi van vah hno hane tongben, pacen, awi nahane manangkhom hah sui kathoung hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Hahoi hmaiimkhok teh suikathoung hoi a sak. Hmaiimkhok teh dêi lah a dêi. A kutnaw, manangnaw, a peinaw teh koung kâkuen lah a dêi. ");
INSERT INTO cth_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Hmaiimkhok avoivang lah a kang kathum touh reira a tâco teh, a kut taruk touh ao. ");
INSERT INTO cth_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Hmaiimkhok dawk hoi e a kang kathum touh dawk e a kang buet buet touh dawkvah, a peimuem, hoi almond paw hoi mei kâvan e manang kathum touh ao. ");
INSERT INTO cth_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hmaiimkhok dawkvah a peimuem hoi almond paw hoi mei kâvan e manang pali touh ao. ");
INSERT INTO cth_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hmaiimkhok dawk a kut taruk touh ao e patetlah avoivang lae a kut kahni touh e rahim vah a peimuem buetbuet touh rip ao. ");
INSERT INTO cth_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","A peimuem hoi a kutnaw hah buet touh lah koung a kâkuetsak teh abuemlahoi suikathoung hoi dei e doeh. ");
INSERT INTO cth_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Hmaiim sari touh hoi, paitei, paitei tanae naw pueng hai suikathoung hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Hmaiim hoi hmaiim hnopai pueng hah suikathoung talen buet touh hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Hahoi hmuitui sawi nahanelah anri thing hoi khoungroe hah a sak. Ayung dong touh, adangka dong touh. Takin pali touh ao. Arasang dong hni touh. A kinaw hoi koung a kâkuet. ");
INSERT INTO cth_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","A lathueng lae a tapang hoi a kinaw teh, suikathoung tui hoi hluk lah ao teh suikathoung hoi a tâphai hah a pacawp. ");
INSERT INTO cth_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","A tâphai a rahim lae a rai reira dawk sui laikaw kahni touh a sak teh, a hmo a voivang lah kahni reira koe sak lah ao. Hot hah teh kâkayawtnae acung hrawt nahane doeh. ");
INSERT INTO cth_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Hahoi anri thing hoi kâkayawtnae a sak teh suitui hoi hluk e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Hahoi kathounge satui hluk e, kathounge hmuitui sawi hanelah hmuitui ka sak thai e patetlah a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Hahoi anri thing hoi hmaisawi thuengnae khoungroe hah a sak. Ayung dong panga touh, adangka dong panga touh, takin pali touh ao. Arasang dong thum touh. ");
INSERT INTO cth_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Takin pali touh som vah kinaw hah a sak. Hote kinaw teh khoungroe hoi koung a kâkuet teh, rahum tui hoi hluk e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Khoungroe hanelah hno e hnopainaw pueng, hlaam, ampaikei, kawlung, cingco, hmaisaan lanae hah a sak. Hote hnonaw pueng teh rahum hoi sak e seng doeh. ");
INSERT INTO cth_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Hahoi khoungroe hanelah rahum cuekkarue hah a sak teh khoungroe keng koe rahim vah a ta. ");
INSERT INTO cth_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Kâkayawtnae acung hrawtnae cuekkarue takin pali touh koe bang hanelah rahum laikaw pali touh a hlun. ");
INSERT INTO cth_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Kâkayawtnae acung hah anri thing hoi a sak teh, rahum tui hoi a hluk. ");
INSERT INTO cth_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Kâkayawt nahane khoungroe rai e laikaw dawkvah, acung hah a hrawt. Khoungroe teh a lûlahei pou a aw thai nahanlah thingphek hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hahoi rahum kawlung hoi pâhungnae a khok hah kamkhuengnae lukkareiim takhang koe thaw ka tawk awh e napuinaw e hlalang hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Hahoi lukkareiim thongma hah a sak teh, akalae yaphni teh loukloukkaang e hoi dong 100 touh hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Hote yaphni hanelah khom 20 touh, rahum khomkhok pacawp 20 touh a sak teh, khom hetnae, pangkheknaw teh ngun hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Atunglae yaphni teh dong 100 touh a pha. Khom 20 touh, rahum khomkhok pacawp 20 touh a sak teh, khom hetnae, pangkheknaw teh ngun hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kanîloumlae yaphni teh dong 50 touh a pha. Khom hra touh, pacawpnae hra touh. Khom hetnae, pangkheknaw teh ngun hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Kanîtholae yaphni teh dong 50 touh. ");
INSERT INTO cth_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Longkha avoivang lae yaphni teh dong hlaipanga touh a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Khom kathum touh, pacawpnae kathum touh. ");
INSERT INTO cth_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Kalupnae yaphni pueng teh loukloukkaang e hoi sak e seng doeh. ");
INSERT INTO cth_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Hahoi khom pacawpnae, hetnae, pangkheknaw teh rahum hoi sak e doeh. ");
INSERT INTO cth_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Hahoi kalupnae longkha koe e yaphni teh, kamthim, âthi, paling, loukloukkaang e hoi carouk e ayung dong 20, rasang dong panga touh a pha. Kalupnae yaphni hoi rei a kâvan. ");
INSERT INTO cth_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kalupnae takhang khom teh pali touh, rahum khok pacawpnae pali touh, hetnae ngun, pangkhek ngun, ngun hoi sak e khom ramuknae naw ao. ");
INSERT INTO cth_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Hahoi Lukkareiim petkâkalup lah hetnae pueng teh rahum hoi sak e lah ao. ");
INSERT INTO cth_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hetheh lukkareiim hnopai, lawkpanuesaknae lukkareiim hanelah hno e, Mosi ni kâpoe e patetlah Aron capa Ithamar hoi Levih miphunnaw ni a touk awh e doeh. ");
INSERT INTO cth_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Judah miphun thung e Hur capa Uri, ahnie capa Bezalel ni BAWIPA ni Mosi koevah sak hanelah kâ a poe e naw pueng teh, koung a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ahni koe Dan miphun Ahisamak capa Oholiab ca thut kathoum, kutsak kathoum, kamthim, âthi, paling, loukloukkaang meikahawicalah ka carouk thai e ni hai a tawk. ");
INSERT INTO cth_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hmuen kathoung a pankinae pueng koe hno hane suinaw pueng, a poe awh e teh hmuen kathoung thung khingnae patetlah pong 2, 195 touh a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Touk tangcoung e tamimaya koe kabawknaw ni a poe awh e ngun hmuen kathoung koe khingnae patetlah pong 7, 550 touh a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Kum 20 lathueng touk tangcoung e tamimaya koe kacetnaw teh 603, 550 touh a pha teh, hmuen kathoung koe khingnae patetlah a poe awh e teh khing tangawn lengkaleng a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Hahoi ngun thung hoi pong 7, 500 touh teh hmuen kathoung khomnaw pacawp hane hoi ung nahanelah a hno awh. Pacawpnae hah 100 touh a pha teh, pacawpnae buet touh ramuk nahanelah hno e teh pong 75 touh a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ka cawi e ngun pong 50 touh hoi khom dawk bangnae hah a sak teh, khom ramuknae teh ngun tui hoi hluk e lah ao. Hahoi yapnae pangkhek hah a sak. ");
INSERT INTO cth_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","A poe awh e rahum talen 70 touh hoi shekel 2,400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Hot teh kamkhuengnae takhang khom pâhungnae khom pacawp hoi rahum khoungroe hoi rahum cuekkarue hoi, ");
INSERT INTO cth_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","lukkareiim kamkhuengnae thongma petkâkalup lah khom pâhungnae khom pacawp hoi lukkareiim hetnae pueng lah koung a hno awh. ");
INSERT INTO cth_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Hahoi kamthim, âthi, paling naw hoi hmuen kathoung thaw tawk nahanelah a meikahawicalah khohna hah a sak teh, BAWIPA ni Mosi koe kâ a poe e patetlah Aron hanelah kathounge khohna hah a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Sui, kamthim, âthi, paling loukloukkaang e hoi carouk e vaihma angki hah a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Sui hah ka rapamcalah a dêi teh ayung lahoi a bawng teh, kamthim, âthi, paling, loukloukkaang e kutsakkathoume ni a carouk teh a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kâyeng e 20 touh lah a sak teh, angki a lathueng lae a rai roi a kâkuet nahanelah rui hoi a sui sin. ");
INSERT INTO cth_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Angki van kâyeng hane taisawm meikahawicalah kawng e hah angki hoi kâvan e lah ao teh, BAWIPA ni Mosi koe kâ a poe e patetlah sui hoi kamthim, âthi, paling, loukloukkaang e carouk e hoi kawng e doeh. ");
INSERT INTO cth_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Karnelian talung kahni touh a kata awh teh, sui tabu thung a bet awh. Kuthrawt dawk min thuk e patetlah Isarel miphunnaw e minnaw hah a thut. ");
INSERT INTO cth_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","BAWIPA ni Mosi koe lawk a thui e patetlah Isarel miphunnaw pahnim hoeh nahanelah, hote talung kahni touh hah vaihma angki kâyengnae dawk a bet awh. ");
INSERT INTO cth_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Saiphei hah vaihma angki sak e patetlah sui, kamthim, âthi, paling, loukloukkaang e carouk e hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bawkhni touh lah thep e lah ao teh, takin pali touh lah a o, ayung khap touh, adangka khap touh, takin pali touh hoi rei a kâvan. ");
INSERT INTO cth_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Saiphei dawk talung 40 touh lah a pâthit. Apasueke rui dawk Sardius, topaz, emerald doeh. ");
INSERT INTO cth_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Apâhni e rui dawk emerald, sapphire hoi diamon doeh. ");
INSERT INTO cth_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Apâthum e rui dawk Jacinth, agate hoi amethyst doeh. ");
INSERT INTO cth_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Apali e rui dawk beril, onyx, hoi jasper doeh. Hotnaw teh sui tabu dawk a pâthit awh. ");
INSERT INTO cth_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Isarelnaw miphun hlaikahni touh e hah noutnae min thut e patetlah, hote talungnaw dawkvah, hote hlaikahni touh e minnaw hah a thut teh, talung buet touh dawk min buet buet touh rip ao. ");
INSERT INTO cth_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Hahoi saiphei van vah, tangron patetlae dingyin sui kathoung hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Sui pahla vei e kahni touh hoi sui laikaw kahni touh a sak teh, saiphei dawk laikaw kahni touh hah a bang. ");
INSERT INTO cth_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Hahoi suibawtarui vei e kahni touh hah saiphei a tâphai lae rui dawk e laikaw dawkvah a sui. ");
INSERT INTO cth_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","A meikahawicalah vei e dingyin kahni touh avanglae asomnaw teh, sui pahla vei e kahni touh dawkvah, a patawp awh teh, vaihma angki a hma lae kâyengnae dawk a sui. ");
INSERT INTO cth_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Sui laikaw kahni touh a sak teh, ephod rahim lah kaawm e saiphei rahim lae taki kahni touh dawk a bang. ");
INSERT INTO cth_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Alouke sui laikaw kahni touh hai a sak teh, vaihma angki a hma lae rahimca hoi kâyengnae lathueng patawpnae koe angki hah avangvanglah a bet. ");
INSERT INTO cth_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Saiphei sui laikaw kahni touh hah vaihma angki, sui laikaw kahni touh hoi mek sui teh, kamthim e pahlarui hoi a sak. Hottelah BAWIPA ni Mosi koe lawk a thui e patetlah saiphei teh kâyengnae dawkvah bang lah ao teh, vaihma angki hoi reirei pou ao. ");
INSERT INTO cth_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Hahoi vaihma angkidung teh kamthim hoi dueng kawng e hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Angkidung lungui vah angki kutkaduem patetlah a aw sak. Ka aw e teh a kâphi hoeh nahanelah, a rai hah pou a yep. ");
INSERT INTO cth_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Angkidung dawkvah, tale paw mei hah kamthim, âthi, paling, loukloukkaang e carouk e hoi a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Hahoi sui kathoung hoi dinghlingnaw hah a sak teh, angki pawi dawk e talepaw rahak vah cakhout laihoi a bang. ");
INSERT INTO cth_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","BAWIPA ni Mosi kâ a poe e patetlah dinghling buet touh hoi tale paw buet touh rip hah angki pawi petkâkalup lah thaw tawk nahanelah kamthoupnae dawk a ta. ");
INSERT INTO cth_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Hahoi Aron hoi a capanaw hanelah loukloukkaang e hoi kawng e hah a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Loukloukkaang e hoi sak e vaihma lupawk hoi luhuem, loukloukkaang e hoi sak e hnadung hoi, ");
INSERT INTO cth_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","loukloukkaang e carouk e hoi kamthim, âthi, paling hoi meikahawicalah em la e hoi kathoumnaw ni em la e taisawm hoi BAWIPA ni Mosi koe kâ a poe e patetlah a sak. ");
INSERT INTO cth_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Hahoi bawilakhung hanelah sui phen hah sui kathoung hoi a sak, BAWIPA KOE THOUNGNAE telah thut e hah a kamnue sak. ");
INSERT INTO cth_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Hahoi BAWIPA ni Mosi koe kâ a poe e patetlah vaihma lupawk a patunglah bet hanelah kamthim e rui hoi a sui. ");
INSERT INTO cth_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Hottelah kamkhuengnae lukkareiim, thaw pueng teh cum lah ao. BAWIPA ni Mosi koe sak hanelah kâ a poe e naw patetlah Isarelnaw ni a tarawi awh. ");
INSERT INTO cth_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Hahoi lukkareiim teh Mosi koe a ceikhai awh. lukkareiim hoi hnopainaw pueng, hetsinnae, tapang thingphek, tapang nahane tâphai, khom hoi khom pâhungnae naw hoi, ");
INSERT INTO cth_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Tutan pho kapaling bu e khunae hoi saram pho hoi sak e a kânguenae a kâkapek nahane yaphninaw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Lawkpanuesaknae thingkong hai kâkayawtnae acung, lungmanae tungkhung hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","caboi hoi hnopainaw pueng hoi vaiyei tanae hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","suikathoung hoi sak e hmaiimkhok hoi hmaiim hoi, hnopai pueng hoi paang nahane satui hoi thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Sui khoungroe, hluk e satui, sawi hane hmuituinaw hoi yaphni takhang koe yap hane yaphninaw hai thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Rahum khoungroe, rahum cuekkarue, acung, hnopai pueng, kawlung hoi pâhungnae, ");
INSERT INTO cth_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Lukkareiim thongma e yaphni, khom, khom pâhungnae khompacawp, kalupnae longkha yaphni hoi a rui, hetsinnae, kâpatonae, lukkareiim thung e hnopai pueng thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","hmuen kathoung koe thaw tawk nahanelah hnicu meikahawicalah kawng e vaihma Aron hoi a capanaw ni vaihma thaw a tawk awh torei teh a kâkhu awh hanelah kathounge hnicunaw hoi thoseh, ");
INSERT INTO cth_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","BAWIPA ni Mosi koe tawk hanelah kâ a poe e pueng hah Isarelnaw ni a tawk awh. ");
INSERT INTO cth_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Hahoi Mosi ni a tawk e pueng a khet teh, khenhaw! koung a cum awh toe. BAWIPA ni kâpoe e patetlah koung a cum awh teh, Mosi ni yawhawi a poe. ");
INSERT INTO cth_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","BAWIPA ni Mosi koe a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","apasueke thapa, apasuek hnin vah kamkhuengnae lukkareiim hah na sak han. ");
INSERT INTO cth_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","A thung vah lawkpanuesaknae thingkong hah na hruek vaiteh, yaphni hoi na ngue sak han. ");
INSERT INTO cth_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Caboi hah na kâenkhai vaiteh, avan kaawm e hnonaw hah na hruek han, hmaiimkhok hah na kâenkhai vaiteh, hmaiim hah na hruek han. ");
INSERT INTO cth_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Hmuitui hmaisawinae sui khoungroe hah lawkpanuesaknae hmalah na hruek vaiteh, lukkareiim takhang yaphni hah na yap han. ");
INSERT INTO cth_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Hmaisawi thuengnae khoungroe hah kamkhuengnae lukkareiim takhang hmalah na hruek han. ");
INSERT INTO cth_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kamkhuengnae lukkareiim hoi khoungroe rahak vah kawlung na hruek vaiteh, hawvah tui na hlun han. ");
INSERT INTO cth_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Lukkareiim petkâkalup lah kalupnae thungup thongma na sak vaiteh, kalupnae longkha dawk yaphni na yap han. ");
INSERT INTO cth_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Hluk e satui hah la vaiteh, lukkareiim hoi a thung kaawmnaw pueng hah hluk vaiteh, na thoung sak han, hnopainaw pueng hai hottelah a thoung awh han. ");
INSERT INTO cth_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hmaisawi thuengnae khoungroe hoi hnopai pueng hah satui hluk vaiteh, khoungroe hah na thoung sak han. Hottelah khoungroe teh kathoungpounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kawlung hoi pâhungnae hah satui na hluk vaiteh na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Aron hoi a capanaw hah kamkhuengnae lukkareiim takhang koevah, thokhai vaiteh, tui hoi na pâsu han. ");
INSERT INTO cth_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Aron hah kathounge khohna hah na kho sak vaiteh, vaihma thaw kai han a tawk thai nahanelah, satui na hluk vaiteh na thoung sak han. ");
INSERT INTO cth_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","A capanaw hai thokhai vaiteh, angki na kho sak han. ");
INSERT INTO cth_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Hottelah vaihma thaw kai han a tawk thai awh nahanelah a na pa satui na hluk e patetlah satui na hluk han. Satui hluk lah ao awh e heh a ca catounnaw totouh a yungyoe vaihma lah ao awh nahanelah pouk pouh e lah pou ao han telah ahnimouh hanlah mitnoutnae lah ao telah a dei. ");
INSERT INTO cth_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Hottelah, Mosi ni BAWIPA ni kâ a poe e patetlah koung a sak. ");
INSERT INTO cth_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Hahoi, apâhni kum, apasuek thapa, apasuek hnin vah, lukkareiim hah a sak awh. ");
INSERT INTO cth_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosi ni lukkareiim hah a sak teh, khompacawpnae naw hah a ung teh, thingpheknaw hah a kangdue sak teh, pangkheknaw hah a hrawt teh, khomnaw hah a kangdue sak. ");
INSERT INTO cth_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","BAWIPA ni Mosi koe kâ a poe e patetlah lukkareiim van vah hni a padi teh, hote van vah patuen patuen a ramuk sin. ");
INSERT INTO cth_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Lawkpanuesaknae hah a la teh, thingkong thung vah a hruek. Thingkong dawk acung hah a hrawt teh, Thingkong van lungmanae tungkhung hah a hruek. ");
INSERT INTO cth_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","BAWIPA ni Mosi kâ a poe tangcoung e patetlah thingkong teh lukkareiim thung vah a hruek. Rakhannae yaphni hah a yap teh, lawkpanuesaknae thingkong teh rakhan thung vah ao. ");
INSERT INTO cth_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Caboi teh kamkhuengnae lukkareiim thung, atunglah yaphni lawilah a hruek. ");
INSERT INTO cth_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","BAWIPA ni Mosi kâ a poe tangcoung e patetlah BAWIPA hmalah caboi dawk vaiyei teh a pâhung. ");
INSERT INTO cth_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Hmaiimkhok hah kamkhuengnae lukkareiim thung akalah, caboi hoi kadangka lah a hruek. ");
INSERT INTO cth_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","BAWIPA ni Mosi kâ a poe tangcoung patetlah hmaiim hah BAWIPA hmalah a hruek. ");
INSERT INTO cth_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","BAWIPA ni Mosi kâ a poe tangcoung patetlah sui khoungroe teh kamkhuengnae lukkareiim thung yaphni hmalah a hruek teh, ");
INSERT INTO cth_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","hot van hmuitui hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Hahoi lukkareiim takhang yaphni hah a yap. ");
INSERT INTO cth_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","BAWIPA ni Mosi kâ a poe tangcoung patetlah kamkhuengnae lukkareiim takhang kung koevah, hmaisawi thuengnae khoungroe hah a hruek teh, hot van vah hmaisawi thuengnae hoi canei thuengnae hah a thueng. ");
INSERT INTO cth_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","BAWIPA ni Mosi kâ a poe tangcoung patetlah kawlung hah kamkhuengnae lukkareiim hoi khoungroe rahak vah a hruek teh, kâpasu nahanlah tui a hlun. ");
INSERT INTO cth_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mosi, Aron hoi a capanaw ni haw vah a kutnaw hoi a khoknaw hah a pâsu awh. ");
INSERT INTO cth_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Kamkhuengnae lukkareiim thung a kâen han nah hoi, khoungroe teng a cei awh han nah ouk a pâsu awh. ");
INSERT INTO cth_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Hahoi lukkareiim hoi khoungroe petkâkalup lah a kalup teh, thongma e longkha dawk yaphni hah a yap teh, hottelah Mosi ni thaw hateh a cum. ");
INSERT INTO cth_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Hottelah kamkhuengnae lukkareiim teh tâmai ni muen a kayo teh, lukkareiim teh BAWIPA bawilennae hoi a kawi. ");
INSERT INTO cth_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Hot patetlah tâmai a pâyam teh, BAWIPA bawilennae hoi lukkareiim muen akawi dawkvah, Mosi teh kamkhuengnae lukkareiim thung kâen thai hoeh. ");
INSERT INTO cth_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tâmai ni lukkareiim a kâtawm takhai torei vah, Isarelnaw teh a cei awh nahane koe lah ouk a cei awh. ");
INSERT INTO cth_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Hatei, tâmai ni kâtawm takhai hoehpawiteh, a kâtawm hoehroukrak kampuen laipalah ao awh. ");
INSERT INTO cth_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Bangkongtetpawiteh, kahlawng a cei awh nah thung pueng, Isarelnaw pueng e mithmu vah, BAWIPA e tâmai teh kanîthun vah lukkareiim lathueng a pâyam teh, karum vah ahnimouh lathueng ouk a ang pouh. ");
INSERT INTO cth_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","BAWIPA ni Mosi a kaw teh kamkhuengnae lukkareiim dawk hoi a pato. ");
INSERT INTO cth_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Nang ni Isarel miphunnaw koe na dei pouh hane lawk teh, nangmouh thung dawk tami buetbuet touh ni BAWIPA koe hno poe hanelah ngai pawiteh, saring, tu, hmae hoi maito a sin han. ");
INSERT INTO cth_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Maito hah hmaisawi thuengnae lah a sak han ngai pawiteh, kacueme a na tongpa na thokhai vaiteh, Cathut lungyouk nahanlah kamkhuengnae lukkareiim takhang koe na poe han. ");
INSERT INTO cth_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Thueng e maito lû dawk amae kut a toung vaiteh, ahnie yontha nahanlah a dâw han. ");
INSERT INTO cth_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","BAWIPA hmalah hote maito a thei awh hnukkhu, Aron e capanaw ni a thi hah a sin awh vaiteh, kamkhuengnae lukkareiim takhang teng sathei thuengnae khoungroe van petkâtue lah thi a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Thuengnae ka sak e tami ni saring e pho a hlip vaiteh, thoukthouk a tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aron e capa vaihmanaw ni sathei thuengnae khoungroe van, thing a paruen hnukkhu hmai a patawi vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Thing van vah a lû, athaw hoi a takpatinaw na ta han. ");
INSERT INTO cth_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","A khok hoi a ruenthinnaw hah tui hoi hmaloe na pâsu han. Vaihma ni hote sathei abuemlahoi khoungroe van hmai hoi a sawi han. Hetteh, hmai hoi sathei thuengnae doeh. BAWIPA koe hmuitui hanlah hmai hoi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Tu, hmae hah hmaisawi thuengnae lah sak han na ngai pawiteh, kacueme a na tongpa na thokhai vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","BAWIPA hmalah khoungroe atunglah na thei hnukkhu, Aron e capa, vaihmanaw ni a thi hah khoungroe petkâtue lah a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Thuengnae ka sak e tami ni thoukthouk a tâtueng han. A lû hoi a moi hah a pâkhueng vaiteh vaihma ni khoungroe van e thing van a ta han. ");
INSERT INTO cth_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","A khok hoi a ruenthinnaw hah tui hoi hmaloe a pâsu han. Vaihma ni abuemlahoi a sin vaiteh khoungroe van hmai a sawi han. Hetteh, BAWIPA koe hmaisawi hmuitui thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","BAWIPA koe tava hoi hmaisawi thuengnae sak hanlah na ngai pawiteh, bakhu thoseh, âbakhu thoseh, na thokhai vaiteh na poe han. ");
INSERT INTO cth_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Vaihma ni khoungroe koe a thokhai hnukkhu, a lahuen a kapen vaiteh khoungroe van hmai a sawi han. A thi teh khoungroe teng a pacâ han. ");
INSERT INTO cth_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","A yoncapo hoi a cuekcaduen dawk e rawcanaw hah na la hnukkhu hraba tanae hmuen, khoungroe hmalah a tâkhawng han. ");
INSERT INTO cth_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","A rathei khuehoi tava a sei vaiteh vaihma ni khoungroe van e thing van hmai a sawi han. Hetteh, BAWIPA koe hmaisawi hmuitui thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","BAWIPA koe tavai hoi thuengnae sak hanlah na ngai pawiteh, tavai kaneng e na sin han. Tavai e avan satui na awi vaiteh, frankinsen hai na thum han. ");
INSERT INTO cth_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Aron e capa, vaihma koe na sin vaiteh, vaihma ni tavai kut karum buet touh, satui youn touh, frankinsen kaawm e pueng a la vaiteh, khoungroe van hmaisawi awh han. Hetteh, BAWIPA koe hmaisawi hmuitui thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kacawie tavainaw teh Aron hoi a capanaw hanelah ao han. BAWIPA koe hmai hoi thuengnae thung dawk kathoungpounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Hmai pâeng e vaiyei hoi thuengnae sak hanlah na ngai pawiteh, satui, tonphuenhoehe phen thoseh, satui hluk e vaiteh kamrâw tonphuenhoehe hai thoseh, thuengnae lah na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ukkang dawk karê e vaiyei thuengnae lah sak han na ngai pawiteh, satui hoi kalawt teh tonphuenhoehe tavai hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Hote vaiyei na raen vaiteh, satui na awi han. Tavai hoi thuengnae sak e doeh. ");
INSERT INTO cth_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ukkang dawk karê e vaiyei hoi thuengnae sak han na ngai pawiteh, satui hoi kalawt e tavai hoi na sak han. ");
INSERT INTO cth_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Hote tavai hoi thuengnae sak e naw pueng, BAWIPA koe a thokhai vaiteh vaihma koe a poe hnukkhu ahni ni khoungroe koe a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Tavai hoi thuengnae dawk e a pham thai tawk a pham vaiteh khoungroe van hmai a sawi han. Hetteh, BAWIPA koe hmaisawi hmuitui thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kacawie tavai teh Aron hoi a capanaw hanelah ao han. BAWIPA koe thuengnae thung dawk kathoungpounge hno lah ao. ");
INSERT INTO cth_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","BAWIPA koe poe e tavai hoi thuengnae dawk ton phuen mahoeh. BAWIPA koe hmai hoi thuengnae na sak navah, ton hmai na sawi mahoeh. Khoitui hai hmai na sawi mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Aluepaw thuengnae dawk ton hoi khoitui hah BAWIPA koe poe thai ei nakunghai, hmuitui hanelah khoungroe dawk teh hmai na sawi mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tavai hoi thuengnae pueng dawk palawi na phuen han. Na sak e thuengnae dawk, BAWIPA e lawkkam palawi na phuen roeroe han. ");
INSERT INTO cth_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Cavui aluepaw, BAWIPA koe thuengnae sak hanlah na ngai pawiteh, cavui hah hmai na pahai lahoi na kamkim sak vaiteh na kanawi hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Satui na awi vaiteh, frankinsen hai na thum han. Hetteh, BAWIPA koe tavai hoi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Na kanawi tangcoung e cakang youn touh, satui youn touh, frankinsen kaawm e puenghoi vaihma ni hmaisawi han. Hetteh, BAWIPA koe hmaisawi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Maito hoi roum thuengnae sak hanlah na ngai pawiteh, kacueme atan nakunghai ala nakunghai buetbuet touh BAWIPA koe na sin han. ");
INSERT INTO cth_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Maito lû van amae kut a toung vaiteh, kamkhuengnae lukkareiim takhang teng a thei hnukkhu, Aron e capa vaihmanaw ni khoungroe petkâtue lah a thi a kahei awh han. ");
INSERT INTO cth_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","A ruen ka ramuk e athaw, a ruen hoi kâkuen e athaw, patuen dawk kaawm e kuen kahni touh dawk e athaw, ");
INSERT INTO cth_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kuen hoi cungtalah thin van kaawm e maimaranaw hah, roum thuengnae sathei thung e la vaiteh, BAWIPA koe hmai hoi thueng hanelah poe hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Aron e a capanaw ni khoungroe van ta e sathei hoi cungtalah hmai a sawi a han. Hetteh, BAWIPA koe hmuitui hmaisawi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","BAWIPA koe tu hoi hmae hah roum thuengnae sak han na ngai pawiteh, toun kaawm hoeh e atan nakunghai ala nakunghai buetbuet touh na sin han. ");
INSERT INTO cth_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Tuca thuengnae lah sak han na ngai pawiteh BAWIPA hmalah na poe hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Tu e a lû van amae kut a toung vaiteh kamkhuengnae lukkareiim hmalah a thei hnukkhu, Aron e capanaw ni thuengnae khoungroe van a thi petkâtue lah a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Atak dawk e athaw, a kenghru tâtueng e, a moi abuemlah, a ruen ka ramuk e athaw, a ruen dawk e athaw, ");
INSERT INTO cth_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Patuen dawk kaawm e kuen kahni touh dawk e athaw, kuen hoi thin dawk e maimaranaw, roumnae sathei dawk e na la vaiteh BAWIPA koe thuengnae na sak hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Vaihma ni khoungroe van hmai a sawi han. BAWIPA koe hmaisawi thuengnae sak e rawca katuilah ao. ");
INSERT INTO cth_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Hmae hoi thuengnae sak han na ngai pawiteh BAWIPA hmalah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Hmae lû dawk a kut toung vaiteh kamkhuengnae lukkareiim hmalah a thei hnukkhu, Aron e capanaw ni khoungroe petkâtue lah a thi hah a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","A ruen ka ramuk e athaw, a ruen dawk e athaw, ");
INSERT INTO cth_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Patuen dawk kaawm e kuen kahni touh hoi cungtalah athin dawk e maimaranaw, ama ni thuengnae dawk e a la vaiteh, BAWIPA koe hmaisawi thuengnae sak hanlah a poe hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Vaihma ni khoungroe van hmai a sawi han. Hmuitui hanlah hmaisawi thuengnae lah ao. Athaw kaawm e pueng teh BAWIPA e lah doeh ao. ");
INSERT INTO cth_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Na miphun catounnaw ni ao na tangkuem koe a thaw hoi a thi hah cat mahoeh telah yungyoe e kâpoe e lah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","BAWIPA ni Mosi koe, nang ni na miphunnaw koe patuen bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Phunglawk panuek awh hoeh, kâlawk a tapoe teh a sak hoeh hane kawi sakpayon pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Satui awi e vaihma ni yon sak hanlah taminaw a tacuek teh ama hai yon pawiteh, hote yontha nahanelah yon ka tawn hoeh e maitotanca hah ");
INSERT INTO cth_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Rangpui kamkhuengnae lukkareiim takhang teng, BAWIPA hmalah a thokhai vaiteh BAWIPA koe a poe han. Hahoi, maito lû dawk a kut toung vaiteh BAWIPA hmalah maito a thei han. ");
INSERT INTO cth_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Satui awi e vaihma ni maito thi a la vaiteh kamkhuengnae lukkareiim koe a sin hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Amae kutdawn hah thi dawk a ranup vaiteh, kathounge hmuen, lukkarei yap e hmalah, BAWIPA hmalah vai sari touh a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Vaihma ni kamkhuengnae lukkareiim thung BAWIPA hmalah kaawm e hmuitui thuengnae khoungroe naw dawk maito thi a hluk vaiteh, kacawie a thi hah kamkhuengnae lukkareiim takhang hmalah kaawm e hmaisawinae khoungroe kung koe a rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Roum thuengnae sathei dawk e maito thaw la e patetlah kâmaihawi nahanlah sak e maito ruen ka ramuk e athaw, a ruen dawk kaawm e athaw, ");
INSERT INTO cth_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Patuen dawk kaawm e kuen kahni touh hoi thin dawk e maimara, athaw kaawm e pueng a la vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Thuengnae khoungroe van hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Maito e a lû, a khok, a ruen, a ruen kanem hoi a vuen, a moi kaawm e pueng, ");
INSERT INTO cth_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Maito buem hah lukkareiim alawilah hraba rabawknae hmuen kathoung koe a ceikhai vaiteh thing van hmai a sawi han. Hraba rabawknae hmuen koe hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Isarel miphun abuemlah ni, phunglawk panuek laipalah sak kawi hoeh e yon hoi kâlawk a tapoe teh yon sakpayon pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Hottelah, a sak payonnae yon a kâpanue torei teh, hote yon hanlah tamimaya ni a kum kanaw e maitotan hah, kamkhuengnae lukkareiim hmalah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Rangpui thung dawk a kum kacuenaw ni BAWIPA hmalah maito lû van kut toung vaiteh a thei han. ");
INSERT INTO cth_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Satui awi e vaihma ni kamkhuengnae lukkareiim koe maito thi a sin hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","A kutdawn hah thi dawk a ranup vaiteh BAWIPA koe lukkarei yap e hmalah vai sari touh a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Vaihma ni kamkhuengnae lukkareiim thung, BAWIPA hmalah kaawm e thuengnae khoungroekinaw dawk thi a hlun vaiteh kacawie thi teh, kamkhuengnae lukkareiim takhang hmalah kaawm e hmaisawi thuengnae khoungroe kung koe a rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Maito thaw pueng a la vaiteh khoungroe van hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Yontha nahanlah maito hoi thuengnae sak e patetlah vaihma ni taminaw hanelah yonthanae sak pawiteh, ahnimae yontha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hathnukkhu hoi maito hah rim alawilah a hrawi awh vaiteh, apasueke maito hmaisawi e patetlah hmai a sawi awh han. Hethateh, taminaw yontha nahanlah thuengnae sak e doeh. ");
INSERT INTO cth_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ukkung ni hai phunglawk panuek laipalah, BAWIPA e kâlawk a tapoe teh sak hoeh hane kawi yon, sakpayon pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Ama ni a sakpayon e yon a kâpanue torei teh, kacueme hmaetanca thueng nahanelah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Hmae lû van amae kut a toung vaiteh, BAWIPA hmalah, hmaisawinae, sathei theinae hmuen koe a thei han. Hethateh, yontha nahanlah sak e thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Vaihma ni yonthanae sathei thi hah, kutdawn hoi a la vaiteh, hmaisawi thuengnae khoungroe kinaw dawk a hlun hnukkhu, kacawie thi hah, khoungroe kung koe na rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Roum thuengnae sathei thaw sak e patetlah athaw pueng, khoungroe van hmai a sawi han. Hot patetlah vaihma ni ukkung e yontha nahanlah sak pawiteh, yontha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Mathoe buetbuet touh ni phunglawk panuek laipalah BAWIPA e kâlawk a tapoe teh sak kawi hoeh e yon sak pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ama ni a sak e yon a kâpanue torei teh, hote yon hanelah, kacueme hmaelaca a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Kâmaihawinae sathei, Hmae lû van, amae kut a toung vaiteh, hmaisawinae sathei theinae hmuen koe hote hmae a thei han. ");
INSERT INTO cth_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Vaihma ni a kutdawn hoi a thi a sin vaiteh khoungroe kinaw dawk a hlun hnukkhu, kacawie hah, khoungroe kung koe a rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Roum thuengnae sathei thaw la e patetlah athaw kaawm pueng a la vaiteh, BAWIPA koe hmuitui hanlah khoungroe van hmai a sawi han. Hottelah, vaihma ni hote tami hanlah yonthanae sak pouh pawiteh, a yontha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Tuca hoi yonthanae sak hanlah na ngai pawiteh kacueme napui na thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Kâmaihawinae sathei tu lû van amae kut a toung vaiteh, hmaisawinae sathei theinae hmuen koe a thei han. ");
INSERT INTO cth_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Vaihma ni hote sathei thi a kutdawn hoi a la vaiteh, hmaisawi thuengnae khoungroe kinaw dawk a hlun hnukkhu, a kahei vaiteh, kacawie thi hah khoungroe kung koe a rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Roumnae thuengnae tuca thaw sak e patetlah athaw kaawm pueng la vaiteh, BAWIPA koe hmaisawi thuengnae hoi cungtalah, khoungroe van hmai a sawi han. Hottelah, vaihma ni hote tami a sakpayon e yon hanlah yonthanae a sak pouh pawiteh a yontha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Tami buetbuet touh ni a hmu e hoi a panue e hno dawk, kapanuekkhaikung lah ao teh, a pathang e thoebonae a thai nahlangva, dei laipalah awm pawiteh, yonpennae teh ama ni a khang han. ");
INSERT INTO cth_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Tami buetbuet touh ni kathounghoehe sarang, saring, vonpui hoi kâva e saring kathoung hoeh e kadout e ro tek pawiteh yonpen lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Hot hnukkhu hoi, tami hanelah kathounghoehe, kakhin e lah kaawm e hno, a kâbet payon e hah bout a panue torei teh yon pen lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Tami buetbuet touh ni kahawi hno thoseh, kathout hno thoseh, sut pouk laipalah lawkkamnae a sak teh, thoe a bo. Hote lawkkamnae bout a kâpanue torei teh, yon pen lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Hetpatete yonpennae buet buet touh ao torei teh, Bangpatete nakunghai ama ni yonpâpho naseh. ");
INSERT INTO cth_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","A sakpayon e yontha nahanlah tu thoseh, hmae thoseh, a napui ca buetbuet touh yon thueng nahanelah, Cathut koe a thokhai hnukkhu, vaihma ni hote tami hanelah yon thuengnae a sak pouh han. ");
INSERT INTO cth_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Tuca tawn hoehpawiteh, a sak payonnae yontha nahanlah sathei buet touh hmai thueng nahanlah buet touh, bakhu kahni touh, hoeh pawiteh âbakhu kahni touh BAWIPA koe vaihma hmalah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Vaihma ni yonthanae sathei hah hmaloe thuengnae a sak han. A lahuen a kapen vaiteh, a tâtueng han. A tak teh na sei mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Hote yon thuengnae sathei thi hah, khoungroe tapang dawk a kahei vaiteh, kacawie a thi teh, khoungroe kung koe a paca han. Hethateh, yon thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Apâhni e tava teh a lamthung patetlah hmai thuengnae patetlah thuengnae a sak han. Hottelah, Vaihma ni ahnie a sakpayon e yon hanlah yonthanae a sak pouh pawiteh, ahnie yon teh tha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Bakhu kahni touh thoseh, âbakhu kahni touh thoseh, buetbuet touh coung thai hoehpawiteh, yon ka sak e tami ni yon thuengnae sathei yueng lah tavai ephah pung hra pung touh a thokhai han. Yon thuengnae lah ao dawkvah satui hoi frankinsen na awi mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Vaihma koe na thokhai hnukkhu, vaihma ni tavai vai touh kasum a la vaiteh, BAWIPA koe hmai thuengnae hoi cungtalah khoungroe van hmai a sawi han. Hethateh, yon thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Hettelah, vaihma ni hote tami ni a sakpayon e yon hanelah yon thuengnae sak pawiteh ahnie yontha lah ao han. Kacawie teh tavai thuengnae patetlah vaihma hanelah ao han telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","BAWIPA ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Tami buetbuet touh ni phunglawk panuek laipalah BAWIPA hoi kâkuen e hno dawk payon pawiteh, hote payonnae hanlah yonthanae sathei tie tutan hmuen kathoung koe e patetlah ngun tangka a to vaiteh, BAWIPA koe a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Hottelah, BAWIPA hoi kâkuen e hno dawk, a sakpayon e hanlah, panga touh dawk buet touh a thapsin vaiteh, vaihma koe a poe han. Vaihma ni hai yonthanae sathei lah kaawm e tu hoi hote tami hanelah yonthanae sak pouh pawiteh, ahnie yon teh tha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Tami buetbuet touh ni BAWIPA ni kâ a poe e sakpayon pawiteh, a sak payonnae ama ni a panue hoeh nakunghai a sak hno teh ama ni a khang han. ");
INSERT INTO cth_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yonnae ngaithoum nahanelah, kacueme tutan, vaihma koe a thokhai han. Phunglawk panuek laipalah, a sakpayon nakunghai, amahoima yonnae kâpanuek hoeh e tami hanelah vaihma ni yonthanae sak pouh pawiteh, ahnie yon teh tha lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hettelah, BAWIPA ka taran niteh, kâ kaek katang e kâtapoe thuengnae doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","BAWIPA ni Mosi koe bout a dei e teh, ");
INSERT INTO cth_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Tami buetbuet touh ni a imri ni hnopai a kuem sak e dawk laithoe dei nakunghai thoseh, ayâ e hnopai a lawp nakunghai thoseh, laithoe a dei teh a imri a dum nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Kahmat e hno a hmu navah laithoe a dei teh thoe ka bo nakunghai thoseh, hot patet lae yonnae buetbuet touh a sak teh BAWIPA koe sakpayon pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Hote tami teh a yon kecu dawkvah, a lawphno ayâ dum laihoi a hmu e hnopai, ayâ ni a kuem sak e hnopai, a pâphawng e hnopai, ");
INSERT INTO cth_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Kahmanhoeh lahoi thoe a kâbo e hnopai phu, a hmu e a phu hoi cungtalah, yon thuengnae hnin dawkvah katawnkung koe panga touh dawk pung touh, bout a poe sin han. ");
INSERT INTO cth_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Yonnae a sak e dawk thueng nahanelah, kacueme tutan hah BAWIPA koe, vaihma hmalah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Vaihma ni hote tami hanelah, BAWIPA koe yonthanae sak pouh pawiteh, ahnie yonnae pueng teh ngaithoum lah ao han atipouh. ");
INSERT INTO cth_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","BAWIPA ni Mosi koe bout a dei e teh, ");
INSERT INTO cth_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Nang ni Aron hoi a capanaw koe, na dei pouh hane teh, hmaisawi thuengnae teh, sathei hah khoungroe hmai van karum tuettuet khodai totouh na o sak vaiteh, thuengnae khoungroe hmai teh pou na kamtawi sak han. ");
INSERT INTO cth_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Vaihma ni lukkarei khohna a khohna vaiteh, khoungroe van e hraba a kawn vaiteh, khoungroe teng a ta han. ");
INSERT INTO cth_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","A khohna e bout a kâhleng vaiteh, hote hraba hah alawilah kathounge hmuen koe a sin han. ");
INSERT INTO cth_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Thuengnae khoungroe hmai teh dout laipalah pou a kamtawi han. Vaihma ni amom tangkuem hmai a racum vaiteh thing van sathei a hruek han. Hote khoungroe van roum thuengnae sathei hai hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Thuengnae khoungroe hmai teh roum sak laipalah pou kamtawi sak han. ");
INSERT INTO cth_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Tavai thuengnae teh Aron e capanaw ni khoungroe hmalah BAWIPA koe a thokhai awh han. ");
INSERT INTO cth_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Tavai vai touh kasum, satui youn touh, frankinsen abuemlah a la vaiteh, BAWIPA koe hmuitui hanlah khoungroe van hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kacawie naw teh Aron hoi a capanaw ni kamkhuengnae lukkareiim thung hmuen kathoung koe tonphuenhoehe a ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Hote tavai dawk ton phuen vaiteh, vaiyei lah na sak mahoeh. Hmai hoi Kai koe thuengnae sak e thung dawk hote vaiyei hah ahnimouh hanlah kai ni ka poe toe. Yontha thuengnae, kâtapoe thuengnae patetlah kathoungpounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Aron hoi a capanaw pueng ni a ca awh han. Hmai hoi BAWIPA koe thuengnae ka tawk e pueng teh a kamthoung awh han, telah nangmae miphun catounnaw totouh a sak hane kâlawk doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","BAWIPA ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aron hoi a capanaw ni satui a awinae hnin hoi, a yungyoe e thuengnae lah ao thai nahanlah, tavai ephah pung hra pung touh, amom lah tangawn tangduem lah tangawn BAWIPA koe thuengnae a sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Hote tavai hah satui a awi vaiteh, ukkang dawk a karê vaiteh, vaiyei lah a sak hnukkhu, a thokhai awh vaiteh, a raen hnukkhu a kanuikapin naw hah BAWIPA koe hmuitui hanlah thuengnae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Aron e hmuen dawk satui awi lah kaawm e a capa ni hai hote thuengnae a sak han. BAWIPA hanelah a yungyoe e kâlawk lah ao. ");
INSERT INTO cth_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Vaihma hanelah tavai thuengnae kaawm pueng hmai koung a sawi han. Khoeroe cat mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","BAWIPA ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Nang ni Aron hoi a capanaw koe na dei pouh hane teh, yon thuengnae teh hmaisawi thuengnae sathei theinae hmuen koe, yonthanae sathei thei han. Hot teh, kathoungpounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","yontha nahanlah thuengnae na ka sak pouh e vaihma ni kamkhuengnae lukkareiim thung hmuen kathoung koe a ca han. ");
INSERT INTO cth_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Hote moi kâbet e pueng teh a thoung. Thi ni a tâcawn sin e khohnanaw hmuen kathoung koe a pâsu han. ");
INSERT INTO cth_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Hote moi thawngnae talai hlaam rek hem han. Rahum hlaam pawiteh, hma vaiteh tui hoi pâsu han. ");
INSERT INTO cth_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Vaihma tongpa naw pueng ni a ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Kathoung poung e lah ao. Yonthanae sathei thi hah hmuen kathoung koe yontha nahanelah, kamkhuengnae lukkareiim thung a sin vaiteh, hote sathei moi hah cat mahoeh. Hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Kâtapoe thuengnae teh kathoungpounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Hmai thuengnae sathei, theinae hmuen koe, kâtapoe thuengnae sathei hah thei vaiteh khoungroe van petkâtue lah a thi kahei han. ");
INSERT INTO cth_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","A mai hoi cungtalah a ruen ka ramuk e athaw, ");
INSERT INTO cth_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Kuen kahni touh dawk e athaw, kuen hoi cungtalah athin van kaawm e maimara dawk e athaw pueng na poe han. ");
INSERT INTO cth_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Vaihma ni khoungroe van hmai a sawi vaiteh, Cathut koe hmai hoi thuengnae a sak han. Kâtapoe thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","A moi hai vaihma thung e tongpa pueng ni hmuen kathoung koe a ca awh han. Kathoung poung e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Kâtapoe thuengnae teh yon thuengnae hoi a kâvan teh thuengnae ka sak pouh e vaihma ni a coe han. ");
INSERT INTO cth_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Tami buetbuet touh ni a sak e hmaisawi thuengnae ka sak pouh e vaihma ni sathei e a vuen teh a la han. ");
INSERT INTO cth_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","A karênae dawk a karê e tavai thuengnae puenghoi ukkang dawk a karê e pueng teh vaihma ni a coe han. ");
INSERT INTO cth_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Satui a awi nakunghai thoseh, a awi hoeh nakunghai thoseh, tavai thuengnae naw pueng Aron e a capanaw pueng ni suetalah a kârei awh han. ");
INSERT INTO cth_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","BAWIPA koe roum thuengnae tie teh, ");
INSERT INTO cth_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Lunghawilawkdeinae dâw hanlah, thuengnae na sak pawiteh, lunghawilawkdeinae sathei hoi cungtalah satui kalawt e tonphuenhoehe phen, satui hoi sak e tonphuenhoehe kamrâw, satui kalawt e tavai hoi sak teh karê e vaiyeinaw hah na thueng han. ");
INSERT INTO cth_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Hote vaiyei phen hloilah, roum thuengnae hoi kâseng e lunghawilawkdeinae dâwnae sathei hoi cungtalah tonphuenhoehe hai na thueng han. ");
INSERT INTO cth_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Thuengnae pueng dawk e vaiyei buet touh BAWIPA koe thuengnae na sak vaiteh hote vaiyei hah roum thuengnae sathei thi kaheikung vaihma ni a coe han. ");
INSERT INTO cth_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Lunghawilawkdeinae lah thueng e roum thuengnae sathei moi hah thueng hnin vah na ca han, amom hanelah bout pek mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Hoehpawiteh, lawkkam laihoi thueng nakunghai thoseh, malungpouk thuengnae thoseh, thueng hnin vah sathei moi ca vaiteh kacawie moi hai atangtho bout ca han. ");
INSERT INTO cth_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kacawie a moi hah tawkkahnin hmaisawi han. ");
INSERT INTO cth_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Roum thuengnae sathei moi, tawkkahnin vah yitca hai na cat payon pawiteh, a lungyouk hoeh e lah na o han. Thuengnae a sak e dâw pouh mahoeh. Panuetkatho e lah ao han. Ka cat e tami teh yon phu a hmu han. ");
INSERT INTO cth_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kathounghoehe hno hoi kâbet e sathei moi cat mahoeh. Hmaisawi han. Kathounge taminaw ni dueng hote sathei moi a ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Apihai thoseh, kathounghoehe yon a tawn nahlangva, Cathut hoi kâseng e roum thuengnae sathei moi ka cat e tami teh, a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Apihai thoseh, tami dawk thoung hoeh e hno, kathounghoehe moi, kathounghoehe pâri patet e hno buetbuet touh a kânep laihoi BAWIPA hoi kâkuen e roum thuengnae sathei moi cat pawiteh, hote tami teh a miphun dawk hoi takhoe lah ao han telah ati. ");
INSERT INTO cth_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","BAWIPA NI Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Maito thoseh, Tu thoseh, hmae thoseh, athaw na cat a mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Amahmawk kadout e saring e athaw hoi sarang ni a kei e athawnaw teh alouke hnonaw dawk na hno thai, eiteh na cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Apihai thoseh, Cathut koe hmaisawi thuengnae sathei thaw ka cat e tami teh, a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Na onae hmuen tangkuem koe a thi thoseh, tava thi thoseh, thi tie pueng na cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Apihai thoseh thi kacate tami teh miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Cathut ni Mosi koe, na miphunnaw koe bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Cathut koe roum thuengnae sathei ka thueng e tami ni teh ama ni thueng hane sathei, BAWIPA koe poe hanelah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Cathut hmalah takuep a sei vaiteh, takuep hoi athaw hah hmai hoi Cathut koe thueng e hah na thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Vaihma ni athaw hah khoungroe van hmai a sawi vaiteh, Aron hoi a capanaw ni takuep teh a la awh han. ");
INSERT INTO cth_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Roum thuengnae sathei thung dawk e aranglae aphai thueng hanelah. vaihma koe a poe han. ");
INSERT INTO cth_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Aron e capanaw thung dawk roum thuengnae sathei a thi hoi athaw thuengnae ka sak e tami ni aphai a ham han. ");
INSERT INTO cth_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Isarel miphunnaw ni a sak e roum thuengnae satheinaw thung dawk e rek sei e takuep hoi aphai teh ka la vaiteh Isarel miphun Aron hoi a capanaw, yungyoe e aphung lah ka poe toe telah ati. ");
INSERT INTO cth_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hottelah, Aron hoi a capanaw ni Cathut hmalah vaihma thaw tawk hanelah, ahnimanaw a rawinae hnin dawk BAWIPA koe, hmai hoi canei kawi naw thuengnae thung dawk e ahnimouh ni a ham awh hane doeh. ");
INSERT INTO cth_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Isarel miphunnaw dawk hoi e hot patet lae a coe a nahanelah, ahnimanaw teh satui awinae hnin dawkvah BAWIPA ni kâ a poe toe. ");
INSERT INTO cth_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hete lawk teh Isarel miphunnaw ni Sinai kahrawng dawk Cathut koe thuengnae a sak hanelah, ");
INSERT INTO cth_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Kâtapoenae hnin nah, Sinai mon dawk Cathut ni Mosi koe a poe e hmaisawi thuengnae, tavai thuengnae, yon thuengnae, kâtapoe thuengnae, thaw poe thuengnae hoi roum thuengnae naw doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Cathut ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aron hoi a capanaw ni a khohna hane naw, kâhluk han satui, yon thueng nahan maitotan, tutan, kahni touh, tonphuenhoehe tangthung buet touh a tho khai vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Rangpui kamkhuengnae lukkareiim takhang hmalah, tamimaya abuemlah kamkhueng sak awh, telah Mosi koe kâ a poe e patetlah, ");
INSERT INTO cth_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mosi ni a tawk teh, tamimaya teh lukkareiim takhang hmalah a kamkhueng awh. ");
INSERT INTO cth_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mosi ni hai tamimaya koe Cathut ni hettelah lawk na thui toe atipouh teh, ");
INSERT INTO cth_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Cathut ni lawkthui e patetlah Aron hoi a capanaw a kaw teh tui a pâhluk hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aron hai angki a kho sak teh, taisawm a kâyeng sak. Angkidung a kho sak teh, vaihma angki a kâkhu sak. Vaihma angkikep khan nahan e a meikahawicalah kawng e angki a kho sak teh a khan pouh. ");
INSERT INTO cth_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","A lungtabue a ramuk sak teh athung vah, Urim hoi Thummim hah a hruek. ");
INSERT INTO cth_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","A lû dawkvah lupawk a pawk teh, kathounge sui phen lupawk hmalah a bet. ");
INSERT INTO cth_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Cathut ni lawkthui e patetlah Mosi ni a hluk nahane satui a la teh, lukkareiim hoi athung e puengcangnaw pueng hah a hluk teh a thoungsak. ");
INSERT INTO cth_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Hote satui hah khoungroe puengcangnaw pueng thoseh, maroi hoi a khok hai thoseh, thoung sak hanelah a hluk. ");
INSERT INTO cth_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Hluk nahan e satui hah Aron e lû dawk a awi pouh teh, thoung sak hanelah a hluk. ");
INSERT INTO cth_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Aron e a capanaw hai angki a kho sak. Taisawm hai a kâyeng sak teh, bawilakhung a huem sak. ");
INSERT INTO cth_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","BAWIPA ni a dei pouh e patetlah yon thueng nahanelah maitotan a hrawi teh, Aron hoi a capanaw ni a lû van a kut a toung pouh han. ");
INSERT INTO cth_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Maito a thei vaiteh, Mosi ni khoungroe petkâtue lah kinaw dawk thi hah a kutdawn hoi a la teh, khoungroe hah a thoung sak hnukkhu, kacawie a thi hah khoungroe kung koe a rabawk vaiteh, hote khoungroe van yon thueng nahanlah a thoungsak han. ");
INSERT INTO cth_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","A ruen ka ramuk e ahrei, athin van e maimara, kuen kahni touh dawk e athaw na la vaiteh, khoungroe van hmai na sawi han. ");
INSERT INTO cth_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","A vuen, a moi, a ei hoi cungtalah maito buem hah alawilah hmaisawi han. ");
INSERT INTO cth_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Cathut ni lawk na thui e patetlah hmaisawi thueng nahane hah a thokhai teh, Aron hoi a capanaw ni tu lû van kut a toung sin awh. ");
INSERT INTO cth_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Tu a thei hnukkhu, Mosi ni khoungroe petkâtue lah a thi a kahei. ");
INSERT INTO cth_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Tu hah koung a raban hnukkhu, a lû, a moinaw hoi athaw hah hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","A von thung e naw hoi a khoknaw tui a pâsu teh, tu buem hah, khoungroe van hmai a sawi. Hmuitui hanlah hmaisawi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Cathut ni lawkthui e patetlah alouke tu yueng lah, a rawi e tu a thokhai vaiteh, Aron hoi a capanaw ni tu lû van kut a toung pouh awh. ");
INSERT INTO cth_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Tu a thei hnukkhu, Mosi ni thi a la teh, Aron e aranglae hnârakong dawk thoseh, aranglae kut pui hoi aranglae khokpui dawk thoseh, a hluk pouh. ");
INSERT INTO cth_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Aron e a capanaw hai a kaw teh, ahnimouh e, aranglae hnârakong, aranglae kutpui hoi khokpui dawk hai thoseh a hluk pouh hnukkhu, khoungroe van petkâtue lah a kahei. ");
INSERT INTO cth_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","A thaw, a mai, a ruen ka ramuk e a hrei, a thin ka ramuk e maimara, a kuen kahni touh hoi akuen ka ramuk e athaw, aranglae aphai, ");
INSERT INTO cth_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Cathut hmalah tangthung dawk ta e tonphuenhoehe buet touh, satui hoi sak e vaiyei a phen buet touh, vaiyei karê e buet touh a la teh, satui hoi aranglae aphai van a hruek hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Aron e a kut, a capanaw e a kut dawk, hote hnonaw hah a hruek teh, Cathut e hmalah a kahek teh, kahek thuengnae a sak. ");
INSERT INTO cth_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mosi ni ahnimae a kut dawk e a la teh, khoungroe van, hmaisawi thuengnae sathei hoi cungtalah hmai a sawi han. Hmuitui teh thaw poe thuengnae lah ao. BAWIPA koe hmai hoi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Hathnukkhu, Mosi ni takuep a la teh BAWIPA hmalah a kahek teh kahek thuengnae a sak. Tu takuep teh Mosi ham lah ao. ");
INSERT INTO cth_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mosi ni khoungroe van kaawm e a thi hoi kâhluk hane satui a la teh, Aron hoi a khohna e dawk thoseh, a capanaw hoi a khohna e naw dawk hai thoseh, a kahei teh, Aron hoi a capanaw, khohnanaw a thoungsak. ");
INSERT INTO cth_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mosi ni Aron hoi a capanaw koe, hote thi moi hah kamkhuengnae lukkareiim takhang teng a thawng awh. BAWIPA ni Aron hoi a capanaw ni hote moi, a ca awh han, telah kai koe lawk na thui e patetlah hote moi thoseh, thawpoe thuengnae tangthung dawk kaawm e vaiyei thoseh, hote hmuen koe cat awh. ");
INSERT INTO cth_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Kacawie moi hoi vaiyei teh hmai na sawi han. ");
INSERT INTO cth_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Thawpoe thoungnae hnin sari akuep hoehnahlan kamkhuengnae lukkareiim takhang thung hoi alawilah na tâcawt mahoeh. Bangkongtetpawiteh, hnin sari touh thung na kamthoung awh han. ");
INSERT INTO cth_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Sahnin na sak a e patetlah nangmouh hane yon thuengnae na sak a hanelah Cathut ni lawk na thui awh toe. ");
INSERT INTO cth_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Hatdawkvah, nangmouh duenae dawk hoi na hlout a nahanelah, kamkhuengnae lukkareiim takhang teng vah, hnin sari touh thung karum khodai na o awh vaiteh, Cathut ni kâ na poe e na tarawi awh han. Hottelah Cathut ni lawk na thui toe tie patuen ka dei e lah ao teh, ");
INSERT INTO cth_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","BAWIPA ni Mosi koehoi lawk thui e naw pueng Aron hoi a capanaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","A hnin taroe hnin dawk Mosi ni Aron hoi a capanaw, Isarel miphun, kacuenaw a kaw teh, ");
INSERT INTO cth_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aron koe, nang ni yon thueng nahanelah, kacueme maito kum kanaw e buet touh, hmaisawi thueng nahanelah, kacueme tutan buet touh, na thokhai vaiteh, Cathut hmalah thuengnae sak loe. ");
INSERT INTO cth_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Isarel miphunnaw koehai thoseh, nangmouh ni yon thueng nahanlah, hmae kum kanaw e buet touh, hmaisawi thueng nahanlah, âvâ ka cawt hoeh rae maitoca buet touh, ");
INSERT INTO cth_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Tuca buet touh, BAWIPA koe roum thueng nahanlah, maitotan buet touh, tutan buet touh, satui hoi kalawt e vaiyei thuengnae hah thokhai loe. Sahnin nangmouh koe BAWIPA a kamnue han telah dei pouh loe atipouh. ");
INSERT INTO cth_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Mosi ni kâ a poe e patetlah kamkhuengnae lukkareiim hmalah a thokhai hnukkhu, tamimaya naw ni a hnai teh, BAWIPA hmalah a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mosi ni hai nangmouh ni BAWIPA ni kâ na poe e patetlah hottelah na sak awh teh, BAWIPA e bawilennae teh nangmouh koe a kamnue han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mosi ni Aron koe, khoungroe koe, cet nateh, Cathut ni kâ na poe e patetlah nama e thuengnae, hmaisawi thuengnae sak nateh, nama hoi na taminaw hanelah, yonthanae sak awh. Taminaw ni a thokhai e sathei thuengnae a thueng teh taminaw hanlah yonthanae sak awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aron ni hai khoungroe koe a cei teh, ama hanlah yon thuengnae maitoca a thei. ");
INSERT INTO cth_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","A capanaw ni a thi a sin awh teh, Aron ni a kutdawn thi dawk a ranup teh, khoungroe kinaw dawk a hlun hnukkhu, kacawie a thi hah khoungroe kung koe a rabawk. ");
INSERT INTO cth_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yon thuengnae sathei thaw, akuen, athin van e maimara hah khoungroe van hmai a sawi. Hottelah, Cathut ni Mosi koe kâ a poe. ");
INSERT INTO cth_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","A moi hoi a vuen teh alawilah hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Hmaisawi thuengnae sathei hai a thei teh a capanaw ni Aron koe thi a poe teh ahni ni khoungroe petkâtue lah a kahei. ");
INSERT INTO cth_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ahnimanaw ni hmaisawi thuengnae sathei moi, takpatinaw hoi a lû hah a poe teh Aron ni khoungroe van hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","A vonthung e naw hoi a khoknaw hah a pâsu teh, khoungroe van kaawm e sathei hoi cungtalah hmai sawi. ");
INSERT INTO cth_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Taminaw ni thueng nahanelah a thokhai teh, taminaw e yon thuengnae lah kaawm e hmae a thei hnukkhu, ahmaloe e patetlah yon thuengnae a sak. ");
INSERT INTO cth_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Hmaisawi thuengnae sathei hai a thokhai awh teh, hot patetlah a sak. ");
INSERT INTO cth_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Tavai thuengnae hai a sin teh, vai touh kasum a la teh, khoungroe dawk amom lah hmaisawi thuengnae khoungroe dawk hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Taminaw hanelah roum thuengnae maitotan, tutan hai a thei awh teh, a capanaw ni thi a sin hnukkhu, khoungroe van petkâtue lah thi a kahei awh. ");
INSERT INTO cth_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","A mai hoi a ruen ka ramuk e ahrei, a kuen, a thin van e a maimaranaw, tu hoi maito e athaw hah, ");
INSERT INTO cth_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","A takuep van a toung vaiteh, khoungroe dawk hmai a sawi. ");
INSERT INTO cth_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Takuep hoi aranglae aphai hah BAWIPA hmalah a kahek teh kahek thuengnae a sak. Hottelah, sak hanelah Mosi ni kâ a poe. ");
INSERT INTO cth_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aron ni amae kut a dâw teh, ayânaw yawhawi a poe teh, yon thuengnae, hmaisawi thuengnae, roum thuengnae a sak hnukkhu, a kumcathuk. ");
INSERT INTO cth_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mosi hoi Aron ni kamkhuengnae lukkareiim thung bout a kâen teh a tâco hnukkhu, taminaw yawhawinae a poe teh, BAWIPA e bawilennae teh taminaw koe a kamnue. ");
INSERT INTO cth_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Cathut koehoi hmai a tâco teh, khoungroe van kaawm e hmaisawi thuengnae sathei hoi athaw, hmai a kak. Hote taminaw ni a hmu awh navah a hram awh teh a tabo awh. ");
INSERT INTO cth_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aron e a capa Nadab hoi Abihu ni hmai sinnae tawngben a la roi teh, hmai a hruek roi. Hmai dawk hmuitui a phuen hnukkhu, BAWIPA ni kâ a poe hoeh e ka talue e hmai hoi thuengnae a sak roi. ");
INSERT INTO cth_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Hatdawkvah, BAWIPA koehoi hmai a tâco teh, BAWIPA hmalah hmai a kak teh a due roi. ");
INSERT INTO cth_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mosi ni Aron a kaw teh BAWIPA ni KAI teh kathounge lah ka o dawkvah, KAI koe kâhnai han kangainaw ni a pâkuem hane teh tami pueng ni ka lentoenae a bari awh han telah ka dei navah, Hot patetlah e doeh ka dei ngai telah ati hnukkhu, Aron teh lawkkamuem lah ao. ");
INSERT INTO cth_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mosi ni Aron e a na pa kanaw, Uzziel e capa Mishael hoi Elzaphan a kaw teh, tho roi haw, na hmaunawngha roi hah, hmuen kathoung koehoi alawilah kâkayawn roi ei telah atipouh e patetlah, ");
INSERT INTO cth_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ahnimouh roi ni a tho roi teh, angki khohna khue hoi rim alawilah a kâkayawt roi. ");
INSERT INTO cth_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mosi ni Aron hoi a capa roi, Eleazar hoi Ithamar a kaw teh, nangmouh hai na due awh han. Taminaw pueng koe lungkhueknae phat payon vaih ti a ngaihri teh, na bawilakhung rading awh hanh, khohna phi awh hanh. Hmaunawngha Isarel miphun abuemlah Cathut ni hmai hoi a kak sak e duengma khuikapkhai awh. ");
INSERT INTO cth_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Nangmouh na due awh hoeh nahanelah, tamimaya kamkhuengnae takhang alawilah, tâcawt awh hanh. BAWIPA e satui awinae nangmouh koe ao telah, Mosi ni a dei e patetlah a sak awh. ");
INSERT INTO cth_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","BAWIPA ni Aron koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Nang hoi na capanaw ni due awh hoeh nahanlah thoseh, kathoung hoi kathounghoehe, kakhin hoi ");
INSERT INTO cth_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kakhin hoeh e hnonaw, na kapek thai nahanlah thoseh, ");
INSERT INTO cth_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","BAWIPA ni Mosi koe a dei pouh e kâlawknaw hah, Isarel miphunnaw koe cangkhai thai nahanelah thoseh, kamkhuengnae lukkareiim dawk na kâen awh navah, Misurtui hoi paruithai e naw net awh hanh. Na miphun, catounnaw totouh na tarawi awh han e phung lah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mosi ni hai Aron hoi kahring rae capa Eleazar hoi Ithamar a kaw teh, BAWIPA koe hmaisawi thuengnae tavai kacawie lat nateh, tonphuenhoehe, khoungroe teng cat awh. Kathoung poung e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Cathut koe hmai hoi thuengnae teh nang hoi na capanaw ni coe hane kawi lah ao dawkvah, hmuen kathoung koe na ca awh han. Bangkongtetpawiteh, Hottelah kâpoe e lah ao dawk doeh. ");
INSERT INTO cth_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Kahek e takuep hoi dâw e kahek e aphai teh, nama hoi cungtalah, na canaw hoi hmuen kathoung koe na ca awh han. Isarel miphunnaw ni roum thuengnae sathei thung dawk e nang hoi na capanaw ni ham hane kawi lah ao. ");
INSERT INTO cth_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Hmaisawi thuengnae sathei thaw hoi cungtalah dâw e aphai, kahek e takuep, BAWIPA hmalah a kahek vaiteh, BAWIPA ni kâ a poe e patetlah nama hoi na capanaw ni yungyoe a ham han kawi phung lah ao han telah ati. ");
INSERT INTO cth_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mosi ni yon thuengnae hmae panki laihoi a tawng eiteh, pâphawng hoeh. Hmaisawi thuengnae lah oun a sak toe. Hatdawkvah, Aron e a capa Eleazar hoi Ithamar koe a lungkhuek teh, ");
INSERT INTO cth_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Bangkongmaw, yon thuengnae sathei moi teh, a thoungpoung. Hatei, nangmouh ni rangpuinaw e yon na ham teh, BAWIPA hmalah ahnimouh hanelah yon thuengnae sak hanelah, hote sathei moi na poe a eiteh, bangkongmaw hmuen kathoung koe na ca awh hoeh vaw. ");
INSERT INTO cth_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Hote sathei thi haiyah, hmuen kathoung koe na thokhai awh hoeh vaw. Kai ni lawk na thui e patetlah hmuen kathoung koe sathei moi ca han na tet awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aron ni sahnin ahnimouh ni taminaw hanlah, yon thuengnae sathei, hmaisawi thuengnae sathei, yo a thueng awh han toe. Kai koe hot patetlah e hno a tho dawkvah, sahnin yon thuengnae sathei moi ka cat pawiteh, Cathut lungyouk han na maw telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mosi ni hote lawk a thai navah a lungkuep. ");
INSERT INTO cth_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","BAWIPA ni Mosi hoi Aron bout a kaw teh, ");
INSERT INTO cth_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Nangmouh roi ni Isarelnaw koe patuen bout na dei pouh hane teh, talai van kaawm e moithang pueng dawk, ");
INSERT INTO cth_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","A khoksamen samka ni teh a thepkaai e moithangnaw teh ca thainae kâ ao. ");
INSERT INTO cth_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Hatei, thepkaai ni teh khoksamen samka hoeh e moithang thung dawk, ca hoeh hane moithangnaw teh Kalauk teh athepai hoeh eiteh khoksamen samka hoeh dawkvah nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Kovei teh thepkaai eiteh a khoksamen samka hoeh dawkvah nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Saveh teh thepkaai eiteh a khoksamen samka hoeh dawkvah nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Vok teh a khoksamen samka eiteh thepkaai hoeh dawkvah nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hot patet e moithangnaw e a moi na cat awh mahoeh. Ro haiyah na tek awh mahoeh. Kathounghoehe lah na pouk awh han. ");
INSERT INTO cth_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Tuipui hoi sawkca dawk kaawm e moithangnaw thung dawk a rathei hoi a lakep kaawm e teh na ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","A rathei hoi a lakep kaawm hoeh e tuipui hoi sawkca dawk kaawm e moithang pueng teh nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","A rathei hoi a lakep kaawm hoeh e tui dawk e moithang na cat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","A ronaw hai panuettho e lah na pouk awh han. ");
INSERT INTO cth_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Nangmouh ni panuettho e lah na pouk awh vaiteh na ca awh hoeh hane tavanaw teh: Mataw, Langta, Tawbu, ");
INSERT INTO cth_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Mataw phun, ");
INSERT INTO cth_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Vonga phun kuep, ");
INSERT INTO cth_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Kalauk tava, bukbu phun kuep, batuiling phun kuep, ");
INSERT INTO cth_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Kawhna hoi balengek, ");
INSERT INTO cth_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Tuicawmpai, ");
INSERT INTO cth_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Butakok phun kuep, Bongpi, Bongcakhat phun kuep, ");
INSERT INTO cth_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","A rathei ka tawn ni teh a khok pali touh hoi kacetnaw pueng teh nangmouh hanlah kathounghoehe lah ao. ");
INSERT INTO cth_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Hateiteh, a rathei a tawn teh a khok pali touh hoi ka cet e phun dawk dawkcawk nahanlah a khok kasaw poung naw teh: ");
INSERT INTO cth_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Samtong, pâluen, tawktaboe, Tawngkaruetnaw teh na ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","A rathei ka tawn ni teh a khok pali touh hoi ka cet e alouke moithang pueng teh nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Hote moithang lahoi nangmae thoungnae hah a khin thai. Hot patet e ro katek e tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Hote kadout e ro ka sin e tami teh khohna a pâsu han, tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","A khoksamen samka hoeh e, a thepkaai hoeh e saring pueng teh nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","A khoksamen samka hoeh e saring pueng teh nangmouh hanlah thoung hoeh. Hote ro ka tek e tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Hote ro ka phawt e tami pueng teh a khohna a pâsu han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Talai dawk a vonpui hoi kâva e saring thung dawk thangbui, moihnam, Insi phun, ");
INSERT INTO cth_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Tawkkei, Tawngkang, Cingkadawt, Dekko hoi Khaipadounnaw teh nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Hotnaw e ro katek e tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Hote kadout e a ro hah thingkawlung, khohna, a pho, cawngko patetlah e im dawk e hno e buet touh van bawt pawiteh thoung hoeh. Tui dawk ranup han. Tangmin totouh thoung hoeh. Hathnukkhu a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Talai hlaam buetbuet touh van ro hah bawt pawiteh, Hote talai hlaam teh a thounghoeh dawkvah rek hem han. ");
INSERT INTO cth_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Hote talai hlaam dawk e tui cakawi moi van vah, bawt pawiteh moi thoung hoeh. Hote talai hlaam dawk e nei hane tui hai thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Takhuen dawk thoseh, lunghmu dawk thoseh, hote hno buetbuet touh bawt pawiteh nangmouh hanelah a thounghoeh dawkvah, peng raphoe han. ");
INSERT INTO cth_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Hatei, sambuem, tai e tui im teh kathounghoehe lah awm hoeh. Ro ni a bosin e dueng doeh kathounghoehe lah ao. ");
INSERT INTO cth_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Cati dawk hote ro bawt pawiteh, Cati teh kathounghoehe lah awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Tui dawk padung tangcoung e cati dawk hote ro bawt pawiteh cati teh nangmouh hanlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Nangmouh ni na ca han kawi saring dout pawiteh, ro katek e tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Hote ro ka cat e tami teh a khohna a pâsu han. Tangmin totouh thoung hoeh. Hote ro ka phawt e tami hai amae a khohna a pâsu han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Talai dawk kâva e saringnaw pueng teh panuettho e lah ao dawkvah na cat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","A khok tawn hoeh, a von hoi ka cet e thoseh, khok pali touh hoi ka cet e thoseh, khok pali hlak kapap e khok hoi ka cet e thoseh, talai dawk kâva e saring buet touh boehai na cat awh mahoeh. Panuetkatho e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Kâva e saring buetbuet touh kecu namahoima kâkhinsak awh hanh. Hotnaw hoi nama kâkhinsak awh hanh. ");
INSERT INTO cth_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Kai teh nangmae BAWIPA Cathut lah ka o. Kai teh kathoung dawkvah nangmouh haiyah namahoima kâthoung sak awh nateh thoungnae tawn awh. Talai dawk kâva e saring buet touh boe hoi hai kâkhinsak awh hanh. ");
INSERT INTO cth_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Kai teh nangmae Cathut lah ka o nahanlah nangmouh teh Izip ram hoi na ka rasat e BAWIPA lah ka o. Kai teh kathoung dawkvah nangmouh hai thoungnae tawn awh. ");
INSERT INTO cth_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Hetnaw teh, kathoung, kathoung hoeh, cakawi hoi cakawi hoeh e saringnaw kapek thai nahanelah, ");
INSERT INTO cth_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Moi, tava, tui dawk kaawm e moithang, talai dawk kâva e moithangnaw puenghoi ka kâkuen e phunglawk doeh ati. ");
INSERT INTO cth_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Cathut ni Mosi koe bout a dei pouh e teh, nang ni Isarel miphunnaw koe patuen na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Napui ni camo a vawn teh ca tongpa a khe hnukkhu, Kampheng nah hnin sari touh a thounghoeh e patetlah hnin sari totouh kathoung hoeh lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ataroe hnin nah vuensom a a pouh han. ");
INSERT INTO cth_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hat hnukkhu, thipaling kecu dawk a manu teh hnin sari touh a kâthoung sak lah ao han. A kâthoung saknae hnin akuep hoehroukrak kathounge hno tek mahoeh. Hmuen kathoung koehai cet mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Hateiteh, napui khe pawiteh, kamphengnae patetlah yat hni touh thung kathounghoehe lah ao han. Thipaling kecu dawk hnin 66 touh a kâthoung sak han. ");
INSERT INTO cth_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ca tongpa thoseh, napui thoseh, kâthoung saknae hnin akuep torei teh, hmaisawi thueng nahanelah âvâ ka cawt hoeh rae tu ca buet touh, yonthueng nahanelah âbakhu buet touh, hoehpawiteh bakhu buet touh hah kamkhuengnae lukkareiim takhang hmalah, vaihma koe a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Vaihma ni BAWIPA hmalah thuengnae a sak vaiteh, hote napui hanlah yon thuengnae a sak pouh vaiteh, ahni teh thi kârabawknae yon dawk hoi a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Tuca coung thai hoehpawiteh, bakhu kahni touh thoseh, âbakhu ca kahni touh thoseh, hmaisawi thueng nahanlah buet touh, yon thueng nahanlah buet touh a thokhai vaiteh, vaihma ni ahni hanlah thuengnae a sak pouh vaiteh ahni teh a thoung han. Hete phunglawk teh ca tongpa, ca napui ka khe e manu hoi kâkuen e phunglawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","BAWIPA ni Mosi hoi Aron koe bout a dei e teh, ");
INSERT INTO cth_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Tami ni a vuen dawk hluetkaco e thoseh, takpatha nakunghai thoseh, bahlaw thoseh, hrikbei mitnoutnae kamnuek pawiteh, hote tami hah vaihma Aron koe thoseh, a capa vaihma buetbuet touh koe thoseh, a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Vaihma ni hote tami e a vuen dawk e patawnae a khet vaiteh, patawnae dawk e a muen pangaw pawiteh patawnae teh vuen thung tak dawk ka phat e patetlah awm pawiteh ka hrikbei e doeh. Vaihma ni hote tami a khet hnukkhu, thoung hoeh telah a pouk han. ");
INSERT INTO cth_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Bahlaw teh pangaw pawiteh vuen thung ka phat e mahoeh. Muen pangaw hoehpawiteh vaihma ni ka pataw e tami hah hnin sari touh a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Asari hnin vaihma ni a khet navah a vuen dawk e patawnae kampai hoehpawiteh hnin sari touh bout a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Asari hnin bout a khet navah ama paroup ni teh meimei tamang pawiteh hote tami teh a thoung telah vaihma ni a pathang han. Ka pathak rumram e lah doeh ao. Amae khohna a pâsu vaiteh kathounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Thoung sak hanelah vaihma ni a khet hnukkhu, ka pathak e hoehoe lui pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Hote tami teh kathounghoehe lah a pathang vaiteh ka hrikbei e tami lah a khoe han. ");
INSERT INTO cth_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ka hrikbei e tami hah vaihma koe a ceikhai awh han. ");
INSERT INTO cth_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Vaihma ni a khet navah, a vuen dawk ka pâphu ni teh a muen pangaw pawiteh, pâphu e dawk cawcawyu pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Hrikbei karuem e doeh. Kathounghoehe tami telah vaihma ni a pouk vaiteh a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Ka hrikbei e tami teh atak buemlah a lû koehoi a khok koe totouh, vaihma ni a khet navah hrikbei kingkawi pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Hot patet e atak dawk king kakawi e tami teh a thoung telah vaihma ni a pathang han. atak buemlah koung a pangaw dawkvah ahni teh a thoung. ");
INSERT INTO cth_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Hateiteh, atak dawk cawcawyu pawiteh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Vaihma ni atak dawk cawcawyu e a khet navah, hote tami teh kathounghoehe lah a pathang han. Atak dawk cawcaw ka yu e tami teh thoung hoeh, ka hrikbei katang e doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Cawcaw ka yu e atak kâthung lah bout pangaw pawiteh vaihma koe bout a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Vaihma ni a khet navah patawnae bout pangaw e hah hmawt pawiteh vaihma ni a thoung telah a pathang vaiteh, ahni teh a thoung toe. ");
INSERT INTO cth_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Vuen dawk âhlut ao teh a dam hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Âhlut a onae a hmâ pangaw dawk a phing nakunghai thoseh, pangawpanang e hrikbei patetlah kamnuek pawiteh, vaihma ni a khet vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Vuen thung lah a pha teh a muen pangaw pawiteh hote tami teh vaihma ni thoung hoeh telah a pathang han. Âhlut koehoi ka hrikbei e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Vaihma ni a khet navah a muen ka pangaw e awm hoeh, vuen thung lah phat hoeh, meimei tamang pawiteh vaihma ni hote tami hah hnin sari touh a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Vuen dawk hmâ hoehoe len pawiteh hote tami teh vaihma ni thoung hoeh telah a pathang han. Hote tami teh ka hrikbei e doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Hateiteh, kâlum e kampuen hoeh, kampai hoehpawiteh âhlut hmâ doeh. Hote tami teh a thoung telah a pathang han. ");
INSERT INTO cth_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Tak dawk vuen hmai a kak teh hmaikakhma cawcaw ka yu e dawk ka paling pangaw lah awm pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Vaihma ni a khet han. A hmâ dawk e muen a pangaw teh vuen thung ka phat e patetlah awm pawiteh hmai kak dawk hoi ka tho e hrikbei doeh. Hote tami teh thoung hoeh telah vaihma ni a pathang han. Hrikbei patawnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Vaihma ni a khet navah a hmâ dawk a muen pangaw e awm hoeh, vuen thung phat hoeh, meimei tamang pawiteh vaihma ni hote tami teh hnin sari touh thung a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Apa sari hnin vaihma ni a khet navah, vuen dawk e hmâ hoe kampai pawiteh, hote tami teh thoung hoeh, hrikbei ka pataw e doeh telah vaihma ni a pathang han. ");
INSERT INTO cth_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Hateiteh, vuen dawk kâlum e kampuen hoeh, kampai hoeh, meimei tamang pawiteh hmaikakhma karado e doeh. Hote tami teh vaihma ni a thoung telah a pathang han. Hmaikak hmâ rumram doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Napui hoehpawiteh tongpa ni lû dawk thoseh, pâkha dawk thoseh, patawnae tawn pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Vaihma ni a khet navah, vuen thung ka phat e lah ao teh a muen hai ka samenpanang lah awm pawiteh hote tami teh thoung hoeh telah vaihma ni a pathang han. Lû dawk e hai thoseh, pâkha dawk e hai thoseh raipha patawnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Vaihma ni hote patawnae a khet navah, vuen thung lah ka phat e lah awm hoeh, a muen hai tamang hoehpawiteh, hote patawnae ka tawn e tami hah vaihma ni hnin sari touh a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","A hnin sari hnin vaihma ni a khet navah, a hmâ kampai hoeh, a muen hai samen hoeh, vuen thung lah phat hoeh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Hote tami e muen a ngaw pouh han. Hma dawk e muen teh ngaw pouh mahoeh. Hnin sari touh bout a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","A hnin sari hnin vaihma ni a khet navah, vuen dawk e hmâ kampai hoeh, vuen thung lah hai phat hoehpawiteh vaihma ni a thoung telah a pathang han. Amae khohna hah a pâsu vaiteh ahni teh kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","a thoung toe telah a pathang hnukkhu, raipha patawnae bout kampai pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Vaihma ni bout a khet vaiteh patawnae hoe kampai katang pawiteh vaihma ni a muen ka samen e tawng mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Hote tami teh thoung hoeh. Hatei, raipha hah ama paroup lah a hmu teh a muen ka tamang e tâcawt pawiteh raipha a kahma teh, hote tami teh kathounge lah ao toung dawkvah, vaihma ni hote tami hah a thoung toe telah a pathang han. ");
INSERT INTO cth_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Napui hai thoseh, tongpa hai thoseh a vuen dawk bahlaw awm pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Vaihma ni a khet navah phouhou e awm pawiteh a vuen dawk e bahlaw doeh. Hote tami teh a thoung. ");
INSERT INTO cth_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Sam ka sarut e tami teh a lû luengpalueng nakunghai thoseh a thoung. ");
INSERT INTO cth_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Tampa sam ka sarut e tami teh a tampanga nakunghai a thoung. ");
INSERT INTO cth_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","A lû luengpalueng e thoseh, tampa ka nga e thoseh, ka pangaw ka paling tâcawt pawiteh, hote bahlaw teh hrikbei doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Hat toteh, vaihma ni a khet vaiteh a vuen dawk hrikbei patetlah kamnuek pawiteh a nganae koe bahlaw pangaw paling lah tâcawt pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Hote tami teh thoung hoeh. Hrikbei patawnae ka tawn e doeh. Lû dawk patawnae a tâco dawk thoung hoeh telah a pathang han. ");
INSERT INTO cth_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Ka hrikbei e tami teh a kapawn e khohna hah a khohna han. Luhuem laipalah atunglae pahni a huem vaiteh kathoung hoeh, kathoung hoeh telah a hram han. ");
INSERT INTO cth_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Hote tami teh pou kathounghoehe, kakhin e tami lah ao. Kathounghoehe tami lah ao toung dawkvah rim hloilah ao han. ");
INSERT INTO cth_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ka hrikbei ni khohna e lukkarei thoseh, tu muen e thoseh, ");
INSERT INTO cth_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Kawng e thoseh, phaivuen e thoseh, phaivuen hoi sak e khohna thoseh, ");
INSERT INTO cth_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","khohna ka kâbet e hmâ kahring ut lah, dukpaling lah kamnuek pawiteh, hrikbei patawnae doeh. Vaihma koe a patue han. ");
INSERT INTO cth_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Vaihma ni khohna dawk ka kâbet e a khet vaiteh, hnin sari touh a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Asari hnin bout a khet vaiteh khohna dawk patawnae teh, kawng e khohna dawk thoseh, phaivuen dawk thoseh, phaivuen hoi sak e khohna dawk thoseh, thoung hoeh hoe kampai pawiteh a patawnae teh tangpha a payang toung dawkvah, thoung hoeh. Hrikbei patawnae doeh toe. ");
INSERT INTO cth_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hote khohna kawng e dawk thoseh, tu muen e thoseh, phaivuen e thoseh, phaivuen hoi sak e khohna thoseh, hmai a sawi han. Bangkongtetpawiteh, a hrikbei toe. ");
INSERT INTO cth_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Hateiteh, vaihma ni a khet navah, kawng e khohna, phaivuen hoi sak e khohna dawk patawnae kampai hoeh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Khohna a pâsu hanlah kâ a poe vaiteh hnin sari touh bout a paung han. ");
INSERT INTO cth_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","A pâsu hnukkhu vaihma ni bout a khet navah, moihna hah kampai hoeh eiteh, patawnae amaparoup lah awm pawiteh thoung hoeh, hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Athunglah thoseh, alawilah thoseh hmâ cawcawyu pawiteh, a pâsu hnukkhu vaihma ni a khet vaiteh patawnae teh ka tamangpanang lah awm pawiteh, kawng e khohna, phaivuen dawk kâbet e hma kâlum e vek a phi han. ");
INSERT INTO cth_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kawng e khohna, khohna hanlah sak e phaivuen dawk thoseh, hmâ bout kamnuek pawiteh kampai thai e patawnae doeh. ");
INSERT INTO cth_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Hot patet e patawnae kâbet e hnopai hmai a sawi han. Kawng e khohna, phaivuen hoi sak e khohna pueng, a pâsu vaiteh patawnae dam pawiteh apâhni lah bout a pâsu vaiteh a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Hete phunglam teh thoung hoi thounghoehnae pathang nahanelah, hrikbei kaman e hni, tumuen e khohna, kawng e khohna, phaivuen hoi sak e khohna kawi hoi kâkuen e kâlawk doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Cathut ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ka hrikbei e ni kamthoungnae hnin dawk a tarawi hane kawi phunglawk teh, ");
INSERT INTO cth_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Hote tami hah vaihma koe a kaw hnukkhu, vaihma ni rim alawilah a tâco vaiteh a khet navah, hrikbei kahmat katang pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Hote kathounge tami hanelah, kahring ni teh kathounge tava kahni touh, sidar thing, ka paling e pahla rui, dingsala dawn naw hah thokhai hanlah kâ a poe han. ");
INSERT INTO cth_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Vaihma ni tava buet touh e hah tui tanae talai hlaam thung a thei sak hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Sidar thingphek, pahla rui paling, dingsala dawn hoi cungtalah kahring e tava a thokhai vaiteh, tava thi kalawt tangcoung e thi dawk a ranup hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Hrikbei kathoung hane tami dawk vai sari touh a kahei vaiteh, hote tami teh a thoung toe telah a pathang han. Hat hnukkhu kahring e tava hah kahrawngum anganae koe a tha han. ");
INSERT INTO cth_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Thoung sak hane tami hah amae khohna a pâsu vaiteh, a sam koung a ngaw hnukkhu, thoung nahanelah tui a kamhluk han. Hathnukkhu, rim dawk a kâen vaiteh, amae rim lawilah hnin sahnin touh ao han. ");
INSERT INTO cth_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Asari hnin vah amae sam, pahnimuen, mitmuen, tak dawk kaawm e muen pueng a ngaw vaiteh, amae khohna a pâsu hnukkhu, tui a kamhluk vaiteh, kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Apa taroe hnin dawk hai thoseh, kacueme âvâ ka cawt hoeh rae, tutanca kahni touh, a napui buet touh thoseh, tavai thueng hanelah, satui kalawt e tavai ephah pung hra pung touh, hoi satuium buet touh a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kathoungsakkung vaihma ni thoungsak hane tami hah tamimaya kamkhuengnae takhang teng BAWIPA hmalah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Vaihma ni tutanca buet touh a la vaiteh, kâtapoe thueng nahanelah a thueng vaiteh, BAWIPA hmalah kahek thueng nahanlah satuium buet touh hoi a kahek han. ");
INSERT INTO cth_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Tuca hah yon thuengnae sathei, hmaisawi thuengnae sathei theinae hmuen kathoung koe a thei han. Bangkongtetpawiteh, yon thuengnae hai vaihma ni a ham e doeh. Kathoung poung e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Vaihma ni kâtapoe thuengnae sathei thi a la vaiteh, thoung sak lah kaawm e tami e aranglae a hnârakong dawk thoseh, aranglae kutpui hoi aranglae khokpui dawk thoseh, a hluk han. ");
INSERT INTO cth_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Satui hai youn touh a la vaiteh, amae kuttabei dawk a awi hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Hote satui hah, aranglae a kutdawn a ranup vaiteh, Cathut hmalah vai sari touh a kahek han. ");
INSERT INTO cth_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","A kut dawk e kacawie satui hah thoung sak lah kaawm e tami e a hnârakong dawk thoseh, aranglae kutpui hoi aranglae a khokpui dawk thoseh, kâtapoe thuengnae sathei thi a hluk han. ");
INSERT INTO cth_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","A kut dawk kacawi rae satui hah thoung sak lah kaawm e tami e a lû van a awi vaiteh, hote tami hanelah yonthanae BAWIPA hmalah a sak han. ");
INSERT INTO cth_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hothloilah, thoung sak lah kaawm e tami hanelah, yontha nahanlah yon thuengnae sathei a thueng vaiteh, hmaisawi thuengnae sathei hah bout a thei han. ");
INSERT INTO cth_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hmaisawi thuengnae hoi tavai thuengnae hah khoungroe dawk a thueng vaiteh, hote tami hanelah yonthanae a sak pouh vaiteh, hote tami teh a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Hote tami teh a mathoe dawk, hottelah totouh coung thai hoeh pawiteh, a kahek vaiteh, kâtapoe thueng nahanelah, yonthanae sathei, tutanca buet touh thoseh, tavai thueng nahanelah, satui kalawt e tavai ephah pung hra pung touh, satuium buet touh hoi a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Hathnukkhu, a coung thai e patetlah bakhu kahni touh, hoehpawiteh, âbakhuca kahni touh hah, yon thueng nahanelah buet touh, hmaisawi thueng nahanelah buet touh, a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ama kâthoung nahanelah, BAWIPA hmalah kamkhuengnae lukkareiim takhang teng koe, vaihma koe ataroe hnin a thokhai hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","vaihma ni kâtapoenae sathei, tuca hoi satuium buet touh a la vaiteh, BAWIPA hmalah kahek thuengnae a kahek han. ");
INSERT INTO cth_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Hottelah, tuca a thei hnukkhu, thi a la vaiteh, thoungsak hane tami, aranglae hnârakong dawk thoseh, aranglae kutpui hoi aranglae khokpui dawk thoseh a hluk han. ");
INSERT INTO cth_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Vaihma ni satui hai youn touh avoilae kuttabei dawk a awi han. ");
INSERT INTO cth_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Hote satui hah aranglae kutdawn hoi vai sari touh BAWIPA hmalah a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","A kut dawk e kacawie satui hah thoungsak lah kaawm e tami e aranglae hnârakong dawk thoseh, aranglae kutpui hoi aranglae khokpui dawk thoseh a hluk hnukkhu, kaawm e satui hah kâtapoe thuengnae sathei thi dawk thoseh a hlun han. ");
INSERT INTO cth_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ama koe kaawm rae satui hah, hote tami e a lû dawk a awi vaiteh, ahni hanlah yon thuengnae a sak pouh han. ");
INSERT INTO cth_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Hote tami ni bakhu thoseh, âbakhu thoseh, ");
INSERT INTO cth_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Yon thueng nahanlah buet touh, tavai thuengnae hoi cungtalah, hmaisawi thueng nahanlah buet touh a thokhai vaiteh, Vaihma ni a thueng vaiteh, hote tami hanlah yonthanae BAWIPA hmalah a sak pouh awh han. ");
INSERT INTO cth_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hete phung teh ka hrikbei ni teh a thoung nahanlah ka tawn hoeh e mathoe hoi kâkuen e kâlawk lah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","BAWIPA ni Mosi hoi Aron koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Kai ni na poe e Kanaan ram coe hanlah na kâen awh torei teh, na coe e ram buet touh dawk im buetbuet touh dawk Kai ni ka hrikbei sak pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Imkung ni vaihma koe a cei vaiteh, Kaie im dawk ka hrikbei e ao patet telah tetpawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Hote im dawk kaawm e pueng thounghoehnae koe phat payon vai ti ngaihri ao dawkvah, vaihma ni ka hrikbei e hah a khet hoehnahlan, kaawm e pueng takhoe sak hanelah, kâ a poe han. Hathnukkhu, vaihma ni a khet hanelah imthung a kâen han. ");
INSERT INTO cth_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Patawnae a khet nah tapang dawk kahring patet, ka paling patetlah ao teh tapang dawk a hmâ kâbet e patetlah awm pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Imthung hoi alawilah a tâco vaiteh, hote im hah hnin sari touh thung tho a khan han. ");
INSERT INTO cth_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Asari hnin vaihma ni bout a khet vaiteh, tapang dawk patawnae hoe kampai pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Hmâ kâbetnae talungnaw hah a la vaiteh, kho alawilah kakhin e hmuen koe tâkhawng hanelah kâ a poe han. ");
INSERT INTO cth_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Hote imthung petkâtue lah a koe sak han. A koe e naw hah kho alawilah a khinnae hmuen koe a rabawk han. ");
INSERT INTO cth_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Apasueke talung e hmuen koe alouke talung hah a la vaiteh, a ta hnukkhu, alouke lungphen hoi bout a pathoup han. ");
INSERT INTO cth_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Hottelah, talung a la vaiteh, im a koe e naw bout a pathoup hnukkhu, patawnae bout tawn rah pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Vaihma ni a khet hanelah bout a tho navah hote im dawk patawnae hoe kampai pawiteh, tak kacate hrikbei doeh. Hote im hah thoung hoeh e lah ao dawkvah, ");
INSERT INTO cth_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","talung, thing, tangpung kaawm e pueng a raphoe vaiteh, kho alawilah kakhin e hmuen koe a hruek han. ");
INSERT INTO cth_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Hothloilah, hote imrakhan dawk kâen e pueng teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Hote im dawk ka ip e tami, ka catnet e tami teh, amae khohna a pâsu han. ");
INSERT INTO cth_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Im teh a pathoup hnukkhu, vaihma ni a khet navah, patawnae kampai hoehpawiteh, a dam toung dawkvah, hote im teh a thoung toe telah a pathang han. ");
INSERT INTO cth_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Hote im a thoung nahanelah tava kahni touh, sidarthing, pahla paling hoi dingsala a sin vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","tui kalawng e tanae talai hlaam thung, tava buet touh e a thei han. ");
INSERT INTO cth_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Sidarthing, dingsala, pahla paling hoi kahring e tava a la vaiteh, tava thi hoi kalawt e tui dawk a ranup hnukkhu, hote im dawk vai sari touh a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Hottelah, tava thi, kalawng e tui, kahring e tava, pahla paling, dingsala hoi sidarthing hoi im thoung sak hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kahring e tava hah a ngainae koe kho alawilah a tha vaiteh, hote im hanelah yonthanae a sak vaiteh, a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Hete phung heh hrikbei patawnae phunkuep hoi raipha patawnae, ");
INSERT INTO cth_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Khohna dawk kâbet e hrikbei hoi im dawk kâbet e hrikbei. ");
INSERT INTO cth_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Tak dawk ka pâphu e, ka pathak e, kâlum e hrikbei, hot patet e kong dawk, ");
INSERT INTO cth_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","athoung hoi athounghoeh e kapek vaiteh, panue thai nahanelah, poe e kâlawk doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","BAWIPA ni Mosi hoi Aron koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Nangmouh roi ni Isarel miphunnaw koe na dei pouh hane teh, tongpa tie pueng atak dawk lacip tâcawt pawiteh, hote lacip teh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Pou a tâco nakunghai thoseh, avaivai a tâco nakunghai thoseh, hote tami teh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","A inae, a tahungnae naw pueng hai thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Ahnie ikhun kâbet e tami, a tahungnae dawk ka tahung e tami teh, ");
INSERT INTO cth_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ahnie tak kâbet e tami hoi, ");
INSERT INTO cth_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Tamtui kâbet e tami teh amae e khohna a pâsu vaiteh tui a kamhluk han. ");
INSERT INTO cth_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Hote tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","A kâcuinae rangdoun hai thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Hote tami e rahim kaawm e hno kâbet e tami teh tangmin totouh thoung hoeh. Hote hno buetbuet touh ka sin e tami teh amae khohna a pâsu vaiteh tui a kamhluk han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Lacip ka tâcawt e tami ni a kut pâsu laipalah alouke tami a kut hoi tek pawiteh, hote tami teh a khohna a pâsu vaiteh tui a kamhluk han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Lacip ka tâcawt e tami ni a kâbet e talai hlaam rek hem han. Thingtongben teh tui hoi pâsu han. ");
INSERT INTO cth_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Lacip ka tâcawt e tami a patawnae a dam torei teh, a damnae hnin hoi a kamtawng vaiteh, hnin sari touh aloum hnukkhu, amae khohna a pâsu vaiteh, tui kalawng a kamhluk vaiteh a kamthoung han. ");
INSERT INTO cth_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ataroe hnin vah, bakhu kahni touh thoseh, âbakhu kahni touh thoseh buetbuet touh Cathut hmalah kamkhuengnae lukkareiim takhang koe a thokhai vaiteh vaihma koe a poe han. ");
INSERT INTO cth_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Vaihma ni yon thueng nahanelah buet touh, hmaisawi thueng nahanelah buet touh a thueng vaiteh lacip ka tâcawt e tami hanelah BAWIPA hmalah yonthanae a sak pouh han. ");
INSERT INTO cth_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Tongpa ni a yangtui tâcawt pawiteh tui a kamhluk han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","A yangtui kâbet e pueng teh tui hoi pâsu han. Ama hai tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Tongpa ni napui hoi ip roi pawiteh tui a kamhluk roi han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Napui ni kampheng pawiteh hnin sari touh thung thoung hoeh. Ahni kâbet e tami hai tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","A kampheng lahun nah a inae hoi a tahungnae naw pueng hai thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ahnie a inae hoi a tahungnae ka kâbet e tami teh amae khohna a pâsu vaiteh tui a kamhluk han. ");
INSERT INTO cth_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Hote tami teh tangmin totouh kathounghoehe lah ao. ");
INSERT INTO cth_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","A inae ikhun dawk thoseh, a tahungnae dawk thoseh, a pacâ e thi ka kâbet e tami teh tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Ka kampheng e napui hoi ka ip e tami teh hnin sari touh thung thoung hoeh. A inae pueng haiyah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","A kamphengnae hnin akuep hnukkhu, a thi khap hoeh rah pawiteh, a thikhap hoehroukrak, kamphengnae tueng patetlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","A thikui e a dam hoehroukrak ahnie a inae hoi a tahungnae teh a kamphengnae patetlah thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Hote hnonaw ka kâbet e tami hai a thounghoeh dawkvah amae e khohna a pâsu vaiteh tui a kamhluk han. Tangmin totouh thoung hoeh. ");
INSERT INTO cth_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Hote napui teh thikui e a khap hnukkhu, hnin sari touh loum pawiteh a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ataroe hnin vah, bakhu kahni touh thoseh, âbakhu kahni touh thoseh, buetbuet touh kamkhuengnae lukkareiim takhang koe, vaihma koevah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Vaihma ni yon thueng nahanelah buet touh, hmaisawi thueng nahanelah buet touh a thueng vaiteh, kampheng nah kathounghoehe napui hanelah BAWIPA hmalah yonthanae a sak pouh han. ");
INSERT INTO cth_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Hottelah, Isarel miphunnaw ni ahnimouh koe kaawm e Kaie lukkareiim a khin sak awh teh, a thounghoehnae dawk a due awh hoeh nahanlah a kamthoung awh han. ");
INSERT INTO cth_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Hete phung teh tak dawk hoi lacip ka tâcawt e, a yangtui ka tâcawt ni teh kakhin e tami, ka kampheng e napui, ");
INSERT INTO cth_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Napui tongpa o inae dawk tarawi hane kawi phung doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aron e capa roi ni BAWIPA hmalah thuengnae a sak teh a due roi hnukkhu, BAWIPA ni Mosi koe a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Na hmau Aron ni a due hoeh nahanelah, hmuen kathoung dawk thingkong van, lungmanae tungkhung hmalah nâtuek hai kâen sak hanh. Kai teh thingkong van, lungmanae tungkhung hmalah tâmai dawk hoi ka kamnue han. ");
INSERT INTO cth_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aron ni lukkarei hmuen kathoung thung bangtelah hoi maw a kâen han tetpawiteh, yon thueng nahanelah, a kum kanaw e maitotan buet touh, hmaisawi thueng nahanelah tutan buet touh a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Kathounge lukkarei angki hoi hna a khohna vaiteh lukkarei taisawm a kâyeng han. Lukkarei lupawk hai a pawk han. Hote khohnanaw teh a thoung dawkvah, tui a kamhluk hnukkhu a khohna han. ");
INSERT INTO cth_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isarel miphun tamimaya naw koe e, yon thueng nahanelah hmaeca kahni touh, hmaisawi thueng nahanelah tu buet touh a la han. ");
INSERT INTO cth_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aron ni amae yon thueng nahanelah maito a thueng vaiteh, ama hoi a imthungkhunaw hanelah yonthanae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Hmae kahni touh hai a thokhai vaiteh, kamkhuengnae lukkareiim takhang koe, Cathut hmalah a poe han. ");
INSERT INTO cth_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aron ni hmae kahni touh hane kong dawk cungpam a rayu han. Buet touh e Cathut hanelah a rayu vaiteh, bout touh e teh kahrawngum tha hanelah a rayu han. ");
INSERT INTO cth_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Cathut e cungpam lah a rayu e hmae teh Aron ni a la vaiteh yon thueng nahanelah a thueng han. ");
INSERT INTO cth_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Tha hanelah cungpam a rayu e hmae teh a hring lahoi Cathut hmalah a poe vaiteh, a lathueng yonthanae a sak hnukkhu, kahrawngum a nganae koe a tha han. ");
INSERT INTO cth_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aron ni amae yon thueng nahanelah maito a thokhai hnukkhu, ama hoi a imthungkhunaw hanelah yonthanae a sak vaiteh, amae yon thuengnae maito a thei han. ");
INSERT INTO cth_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Cathut hmalah khoungroe hmaisaan hoi kakawi e tongben buet touh a la vaiteh, kanui lah phawm e hmuitui kutvang touh hoi, lukkarei yap e athunglah kâenkhai han. ");
INSERT INTO cth_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Aron ni duenae dawk hoi a hlout nahanelah hmuitui e hmaikhu ni lawkpanuesaknae thingkong khuem hmuitui sak hanelah BAWIPA hmalah hmuitui van a phuen han. ");
INSERT INTO cth_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Maito thi youn touh a la vaiteh, Kanîtholah thingkong khuem van a kutdawn hoi a kahei han. Thingkong khuem a hmalah hai vai sari touh a kutdawn hoi a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Hathnukkhu, taminaw hanelah yon thuengnae hmae a thei vaiteh, a thi hah lukkarei yap e athunglah a kâenkhai hnukkhu, maito thi a kahei e patetlah thingkong khuem van thoseh, a hmalah hai thoseh, a kahei han. ");
INSERT INTO cth_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Isarel miphunnaw e thounghoehnae yon dawk thoseh, kâtapoenae yon pueng dawk thoseh, hmuen kathoung hanelah yonthanae a sak han. Hottelah, Isarel miphunnaw thounghoehnaw yon thung kaawm e naw kamkhuengnae lukkareiim hanelah a sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Hmuen kathoung koe yonthanae sak hanelah, a kâen nah, ama hanelah a imthungnaw hanelah, Isarel miphun abuemlah hanelah, yonthanae a sak teh, a tâco hoehroukrak kamkhuengnae lukkareiim thung apihai awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","BAWIPA hmalah khoungroe koe bout a tâco vaiteh, yonthanae a sak hanelah, maito thi, hmae thi, a la vaiteh khoungroe kinaw dawk a hlun han. ");
INSERT INTO cth_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Thuengnae khoungroe van hai hote thi hah a kutdawn hoi vai sari touh a kahei vaiteh, Isarel miphunnaw e thounghoehnae a thoung sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Hottelah, hmuen kathoung hanelah, kamkhuengnae lukkareiim hanelah, khoungroe hanelah, yonthanae a sak hnukkhu, hmae a hring lah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aron ni kahring e hmae lû van a kut kahni touh hoi a toung vaiteh, Isarel miphunnaw e yonnae naw hoi a sakpayonnae pueng yonpâpho vaiteh, hmae lû van a toung pouh hnukkhu, a rawi e tami buet touh ni kahrawngum a ceikhai han. ");
INSERT INTO cth_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ahnimae yonnae pueng tami ohoehnae hmuen koe ka cetkhai e hote hmae hah kahrawngum a tha han. ");
INSERT INTO cth_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aron ni kamkhuengnae lukkareiim thung bout a kâen vaiteh, hmuen kathoung koe apasuek a kâen navah, a kho e loukloukkaang e khohna a kho e hah a rading vaiteh, hmuen kathoung koe a ta han. ");
INSERT INTO cth_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Hmuen kathoung koe tui a kamhluk vaiteh amae khohna a khohna hnukkhu, bout a tâco vaiteh, Ama hoi taminaw hanelah hmaisawi thuengnae sathei hah a thueng vaiteh, Ama hoi ayânaw hanelah yonthanae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yon thuengnae sathei thaw teh khoungroe van vah hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Kahrawngum hmae ka tha e tami hai amae khohna a pâsu vaiteh tui a kamhluk hnukkhu, a onae rim dawk bout a kâen han. ");
INSERT INTO cth_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Yon thuengnae maito hoi yon thuengnae hmae thi yonthanae sak hanelah hmuen kathoung koe kâenkhai e hah rim alawilah a ceikhai han. A pho, a moi, hoi a ei hah hmaisawi han. ");
INSERT INTO cth_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hmai ka sawi e tami hai amae khohna a pâsu vaiteh, tui a kamhluk han. Hathnukkhu, roenae rim koe a cei han. ");
INSERT INTO cth_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Nangmouh ni na tarawi awh hane phung teh Isarelnaw thoseh, nangmouh koe kaawm e imyinnaw thoseh, Asari e thapa, hnin hra hnin vah, thaw na tawk awh mahoeh. Na kâhat awh han. ");
INSERT INTO cth_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Bangkongtetpawiteh, BAWIPA hmalah nangmanaw yonnae pueng dawk hoi na thoung awh nahanelah, hote hnin dawk vaihma ni nangmouh na thoung a nahanelah yonthanae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hote hnin teh nangmouh na kâhat nahanelah sabbath hnin lah ao dawkvah duem na kâhat awh han. ");
INSERT INTO cth_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","A na pa e yueng lah vaihma thaw ka tawk hanelah, apasueke vaihma kut dawk hoi satui awi lah kaawm e tami ni yonthanae a sak han. Hote vaihma teh kathounge lukkarei khohna a khohna han. ");
INSERT INTO cth_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Hmuen kathoung hanelah, kamkhuengnae lukkareiim hanelah, khoungroe hanelah, vaihmanaw hanelah, tami pueng hanelah yonthanae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Hete phung teh Isarel miphunnaw ni a yonnae kaawm pueng dawk, kum touh dawk vai touh, yonthanae sak hanelah, nangmouh ni pou na tarawi a hanelah, kâpoe e lah ao telah Cathut ni Mosi koe lawkthui e patetlah Aron ni a sak. ");
INSERT INTO cth_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Nang ni Aron hoi a capa, Isarel miphunnaw koe bout na dei pouh han e teh, ");
INSERT INTO cth_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isarel miphun dawk e tami buetbuet touh ni tu, hmae maito hah rim thung a thei nakunghai thoseh, rim alawilah a thei nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Cathut e lukkareiim hmalah, Cathut koe thuengnae sak hanelah, kamkhuengnae lukkareiim takhang koe thokhai hoehpawiteh, hote tami teh hringnae a thei dawk a yon telah pouk han. Thi ka palawng e hote tami teh a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Isarel miphunnaw ni kahrawng um vah thueng e satheinaw hah kamkhuengnae lukkareiim takhang hmalah, Cathut koe vaihma hmalah a thokhai vaiteh, roum thuengnae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Vaihma ni hote sathei thi hah tamimaya kamkhuengnae takhang teng e khoungroe van a kahei vaiteh, athaw hai Cathut koe hmuitui hanlah hmai a sawi han. ");
INSERT INTO cth_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ahnimouh ni apasueke a kâyo awh e patetlah hmalah kahraituilinaw koe thuengnae bout sak awh mahoeh. Hete kâlawk teh ahnimae miphun catounnaw ditouh a tarawi hane kâlawk lah ao. ");
INSERT INTO cth_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Isarel miphun thoseh, nangmouh koe kho ka sak e alouke miphun thoseh, hmaisawi thuengnae hoehpawiteh, alouke sathei buetbuet touh, a thueng navah, ");
INSERT INTO cth_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","BAWIPA koe thuengnae a sak han navah, kamkhuengnae lukkareiim takhang koe a thokhai hoehpawiteh, hote tami teh a miphun dawk hoi na takhoe awh han telah ahnimouh koe na dei pouh awh han. ");
INSERT INTO cth_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Isarel miphunnaw na hoehpawiteh, nangmouh koe kho ka sak e alouke miphunnaw, buetbuet touh ni thi cat pawiteh, hote tami teh kai ni ka maithoe vaiteh a miphun dawk hoi ka takhoe han. ");
INSERT INTO cth_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Bangkongtetpawiteh, tak hringnae teh thi dawk doeh ao. Nangmae na sak e yontha nahanelah, hote thi hah nang koe thuengnae khoungroe van ka poe toe. Tami e yon katha thai e teh thi doeh. ");
INSERT INTO cth_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Hatdawkvah, nangmouh dawk apihai thi na cat awh mahoeh. Nangmouh koe kho ka sak e alouke miphunnaw hai thi cat awh mahoeh telah Isarel miphunnaw koe Kai ni kâ ka poe. ");
INSERT INTO cth_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Isarel miphunnaw hoehpawiteh nangmouh koe kho ka sak e alouke miphunnaw buetbuet touh ni a hrampa teh ca hanelah moithang tava man pawiteh, thi a palawng vaiteh talai hoi a paten han. ");
INSERT INTO cth_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Thi teh moithang pueng e hringnae lah ao. Hatdawkvah, nangmouh ni moithang buetbuet touh e thi na cat awh mahoeh telah Isarel miphunnaw koe kâ ka poe. Moithangnaw pueng ni a hringnae teh thi dawk ao dawkvah, thi ka cat e tami teh takhoe roeroe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Amahmawk kadout e saring, sarang ni a kei e caha ka cat e, mae miphun, alouke miphun thoseh, amae khohna a pâsu vaiteh tui a kamhluk han. Tangmin totouh kathounghoehe lah ao. ");
INSERT INTO cth_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Khohna pâsu hoeh, tui hai kamhluk hoehpawiteh amae a yonnae ama ni a khang han telah BAWIPA ni ati. ");
INSERT INTO cth_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","nang ni patuen na dei pouh hane teh, Kai teh nangmae BAWIPA Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nangmouh ni ouk na onae Izip ram e nuencang thoseh, nangmouh na kâen khai nahane ram Kanaan ram e a nuencang thoseh, nangmouh ni na tarawi awh mahoeh. Ahnimae lamthung hai na dawn awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Kai ni kâ na poe e patetlah na tarawi awh vaiteh, Kaie ka phunglam dawk na hring awh han. Kai teh nangmae Cathut Jehovah lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hatdawkvah, Kaie ka phunglamnaw hah tarawi awh. Hote phung ka tarawi e tami teh hote phung lahoi a hring han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nangmouh thung dawk apihai ama hoi kâhnai e tami yonkhai mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nange na pa hoi kâkuen e na manu na ipkhai mahoeh. Na manu lah ao dawkvah na yonkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Na pa e yu koe na hnai mahoeh. Na pa hoi kâkuen e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Im touh dawk rei khe e thoseh, alouke kho dawk khe e thoseh, na tawncanu na ipkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Na minca na ipkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Manu Alouklouk ei teh, na pa buet touh e na tawncanu na ipkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Na mani thoseh, ");
INSERT INTO cth_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","na manta thoseh, ");
INSERT INTO cth_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","na pa e hmaunawngha hoi kâkuen e a yuca hai thoseh, ");
INSERT INTO cth_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","na capa e a yu, na langa hai thoseh, ");
INSERT INTO cth_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","hmaunawngha hoi dueng kâkuen e na hmaunawngha e a yu hai thoseh, na ipkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Na yu hoi kâhnai lah kaawm e na yu e canu, na yu e minca na ipkhai mahoeh. Hot patet hateh, kahawihoehe hno doeh. ");
INSERT INTO cth_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Na yu a hring navah, runae na poe hoeh nahanlah a nawngha na lat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Na yu a kampheng lahun nah na ipkhai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Ayâ yu na yonkhai mahoeh. Ayâ yu yonkhainae teh mahoima kâkhinsaknae doeh. ");
INSERT INTO cth_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Na canaw hah Molek koe thuengnae lah na sak mahoeh. Na Cathut e min na pathoe mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Napui hoi rei na i e patetlah tongpa hoi rei na ip mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Panuetkatho e hno doeh. Ma kâkhinsaknae doeh. Saring na ka ipkhai mahoeh. Napui hai thoseh, saring hoi na ip sak mahoeh. Panuetkatho e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Hot patet e hno hoi namamouh hoi namamouh na kâkhinsak awh mahoeh. Bangkongtetpawiteh, hete hno a sak awh kecu dawk, nangmae hmalah ka takhoe e miphunnaw ni hottelah a sak awh teh a khin awh toe. ");
INSERT INTO cth_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Ahnimae ram hai a khin. A khin kecu dawk Kai ni ka toun awh teh hote ram ni amae canaw a palo awh han. ");
INSERT INTO cth_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nangmouh teh Kai ni ka dei e phunglamnaw hah na tarawi awh han. ");
INSERT INTO cth_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Hote ram ni hmaloe kaawm e miphunnaw a palo e patetlah bout na khin awh vaiteh, na palo awh hoeh nahanlah ram thung e tami thoseh, nangmouh koe kho ka sak e alouke miphunnaw thoseh, hot patet e panuettho e na sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Hot patet e hno panuettho e saknae lahoi ahnimae ram teh a khin toe. ");
INSERT INTO cth_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Hot patet e hno panuettho e ka sak e tami teh a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Hatdawkvah, hmaloe a sak a e panuettho e singyoe, nangmouh ni dawn laihoi na kâkhinsak awh hoeh nahanelah, kâlawk tarawi awh. Kai teh nangmae BAWIPA Cathut doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Nang ni Isarel miphun, rangpuinaw koe bout na dei pouh hane teh, nangmae BAWIPA, Kai teh kathounge patetlah nangmouh hai thoung van awh. ");
INSERT INTO cth_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Tami pueng ni na manu hoi na pa na bari awh han. Kaie sabbath hnin hai na ya awh han. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Kutsak na bawk awh mahoeh. Ma hanelah hlun e cathutnaw na sak awh mahoeh. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Roum thuengnae sathei BAWIPA koe thuengnae na sak pawiteh, BAWIPA lung ka youk lah na thueng awh han. ");
INSERT INTO cth_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Thuengnae hnin hoi atangtho hnin dawk na ca awh han. Cawi pawiteh, a tawkkahnin teh hmai na sawi awh han. ");
INSERT INTO cth_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Tawkkahnin dawk yitca nakunghai na cat awh pawiteh, panuettho e lah ao. Lungyouk lah awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ka cat e tami teh BAWIPA thoungnae a khinsak dawkvah, a yonnae phu teh ama ni a khang han. Hote tami teh a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Na law dawk e cang na a torei teh, lawrai lae koung na a awh mahoeh. Cabong bout na hrawm a torei hai na pahnim a e bout na hrawm awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Misur paw hai koung na khi awh mahoeh. Kacawie a paw bout na khi awh mahoeh. Hote a paw teh, kamathoe e tami, hoi imyinnaw hanelah, na pek awh han. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ayâ e hno na parawt awh mahoeh. Ayâ na dum awh mahoeh. Buetbuet touh laithoe na kâdei awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Kaie min lahoi kahmanhoeh lah thoe na ka bo awh mahoeh. Na Cathut e min mathout sak awh hanh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Na imri e hno kamsoum hoeh lahoi lawm hanh. Thama lahoi lat pouh hanh. Counnae phu hah karum loum sak hanh. ");
INSERT INTO cth_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Hnâpang thoe na bo mahoeh. Mitdawn hmalah kamthui kawi hno na tat pouh mahoeh. Na Cathut hah barih. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Lawkcengnae koe kamsoum hoeh lah lawk na ceng mahoeh. Kamathoe e noutna laipalah awm hanh. Athakaawme tami minhmai khen hanh. Na imri hah kamsoum lah lawk na ceng han. ");
INSERT INTO cth_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ayânaw minhmai mathoenae kamthang hah dei hanelah na taminaw koe na kâhlai mahoeh. Na imri runae kâhmo sak hanlah na kâcai mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Na lung thung hoi na hmaunawngha hmuhmanae na tawn mahoeh. Na imri a payonnae hah pak khen laipalah na yue katang han. ");
INSERT INTO cth_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Na taminaw ni nang koe payon awh pawiteh, bout pathung hanh. A yonnae hah pâkuem pouh hanh. Na imri hah nama patetlah lungpataw. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Kaie phunglawk na tarawi awh han. Aphun alouklouk e saring a napui, a na tongpa âvâ na yawng sak mahoeh. Cati alouklouk e mak kâkalawt lah law dawk na patue awh mahoeh. Pahla hoi tumuen carouk teh kawng e khohna na khohnat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Paluen hanelah sut ham teh ratang hoeh rae a sannu ka ipkhai e tami teh hemnae a khang han. Hote napui teh amae san lah ao dawkvah thei lah awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Tongpa ni hai kâtapoe thueng nahanelah, tutan buet touh kamkhuengnae lukkareiim takhang koe BAWIPA koevah a thokhai han. ");
INSERT INTO cth_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Hote tongpa ni a sakpayon e yontha nahanelah, kâtapoe thuengnae tutan hah, vaihma ni BAWIPA hmalah a thueng han. Hote tongpa teh yon ngaithoum lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Nangmouh koe Kai ni na poe e ram dawk na pha awh toteh, cakawi thingthai aphunphun na ung awh hnukkhu, kum thum touh thung kapaw e a pawnaw hah, vuensoma hoeh e a paw telah na pouk awh vaiteh, na cat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","A kum palinae kapaw e a paw pueng teh a thoung dawkvah BAWIPA pholen nahanelah pasoum lah ao. ");
INSERT INTO cth_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","A kum panganae a pawnaw hah na ca awh han. Hottelah na sak pawiteh thingthainaw hoe a paw han. Kai teh nangmae BAWIPA Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","A thi hoi bangpatet e a moi hai mek na cat awh mahoeh. Tami na ân mahoeh. Kut na khet hoi khueyue lawk na dei mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Na lû kâkalup lah na sam na ngaw mahoeh. Pâkhamuen na ngaw mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Kadout e tami hanelah na tak na a mahoeh. Mangkâkhuinae na sak mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Na canu kâyawt sak hanh. Hoehpawiteh ram ni kâyawt e koe kâbang vaiteh, kahawihoehe hno hoi akawi han. ");
INSERT INTO cth_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Sabbath hnin hah na ya han. Kaie hnin kathoung hah na bari han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Nama hoi nama kâkhinsak hanelah kahrai khueyue koe, kamlang hanh. Hmaui hai tawng awh hanh. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Sam ka po e hmalah kangdout nateh, matawng e minhmai na bari han. Na Cathut hah na taki han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Nangmouh koe kârayen e imyin hah na rektap mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Nangmouh koe kârayen e imyin hah na tami patetlah na pouk han. Nama patetlah na lungpataw han. Nangmouh teh Izip ram vah imyin lah ouk na o awh toe. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Bangnuenae, Khingnae, tonae dawkvah kamsoum hoeh lah na sak mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Kahman e yawcu, khinglung, Kahman e ephah, kahman e hinnaw hah na hno han. Kai teh Izip ram hoi nangmouh ka tâcawtkhai e nangmae BAWIPA Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Kaie phunglamnaw puenghoi lawk tâtueng e naw pueng hah na tarawi awh han. Kai teh BAWIPA doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","BAWIPA ni Mosi koe, nang ni Isarel miphunnaw koe bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Isarel taminaw thoseh, Isarelnaw koe kho ka sak e alouke miphunnaw thoseh, amae canaw Molek koe, ka poe e tami teh thei roeroe han. Khocanaw ni talung hoi a dei awh han. ");
INSERT INTO cth_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Kaie hmuen kathoung kakhin sak niteh, Ka min kathoung kamathout sak niteh, amae canaw Molek koe ka poe e tami teh, Kai ni mithmaithung sin vaiteh, a miphun dawk hoi ka takhoe han. ");
INSERT INTO cth_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Amae canaw Molek koe ka poe e tami hah, khocanaw ni nout laipalah thet awh hoeh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Hottelah kaawm e tami hoi a imthungkhunaw hah, Kai ni mithmaithung sin vaiteh, ahni hai thoseh, ahni hoi cungtalah Molek koe, ka kâyawtnaw hai thoseh, ahnimae miphun dawk hoi ka takhoe han. ");
INSERT INTO cth_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Lam ka phen ni teh kahrai khueyue koe kamlang e taminaw hoi camkathoumnaw koe kâyawt e naw hah, mithmaithung sin vaiteh, a miphun dawk hoi ka takhoe han. ");
INSERT INTO cth_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Nangmae BAWIPA KAI Cathut teh kathoung dawkvah nangmouh hai kâthoung sak awh nateh, kathoung lah awm awh. ");
INSERT INTO cth_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Kaie ka phunglamnaw hah na tarawi awh han. Kai teh BAWIPA, nangmouh na kathoung sak e BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Apipatethai a manu, hoi a na pa thoe ka bo e tami pueng teh, thei roeroe lah ao han. A manu hoi a na pa thoe a bo dawkvah, a thi phu teh amae lû dawk a bo han. ");
INSERT INTO cth_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ayâ yu yonkhai pawiteh, ka uicuk e napui hoi tongpa hah mek thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Apihai a na pa e yu yonkhai pawiteh, a na pa kaya sak e lah ao dawkvah, hote napui hoi tongpa mek thei lah ao han. Ahnimae thi phu teh amae lû dawk a bo han. ");
INSERT INTO cth_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Apihai amae langa ipkhai pawiteh, ahnimouh roi panuettho e hno hah a sak dawkvah, mek thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Apihai napui ikhai e patetlah tongpa reira ipkhai pawiteh, ahnimouh roi teh panuettho e hno a sak roi dawkvah, mek thei lah ao han. Ahnimouh roi e thi phu teh amamouh roi dawk a bo han. ");
INSERT INTO cth_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Apihai a manu hoi canu a yu lah mek lat pawiteh, Hot teh, kahawihoehe hno doeh. Nangmouh koevah kahawihoehe hno ao hoeh nahanelah, ahnimanaw teh hmai na sawi awh han. ");
INSERT INTO cth_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Apihai saring ipkhai pawiteh, ahni teh thei lah ao han. Hote saring hai thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Napui ni saring koe kâ ipkhai sak pawiteh, hote napui hoi saring teh mek thei lah ao han. Ahnie thi phu teh amae lû dawk a bo han. ");
INSERT INTO cth_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Tongpa ni a tawncanu, a na pa e canu, na hoehpawiteh, a manu e canu a yu lah a paluen teh ipkhai pawiteh, hot hateh, kamsoumhoehe hno doeh. Ahnimouh roi teh a taminaw e hmaitung hoi takhoe lah ao han. Hote tongpa teh amae tawncanu a okhai dawkvah a yonnae phu ama ni a khang han. ");
INSERT INTO cth_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Tongpa ni kampheng lahun e napui ipkhai pawiteh, thi palawng hanlah a lungkuep roi dawkvah, ahnimouh roi teh a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Na mani hoi na manta na ipkhai mahoeh. Hottelah, kâhnai e imthung hoi ka ipawm e tami teh amamae yonnae a khang han. ");
INSERT INTO cth_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Tongpa ni a na pa e hmaunawngha yu ipkhai pawiteh, a na pa e hmaunawngha hoi dueng kâkuen e a ikhai dawkvah, ahnimouh teh amae yon phu teh amae lû dawk a bo han. Carôe laihoi a due han. ");
INSERT INTO cth_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Tami ni a hmaunawngha e yu ipkhai pawiteh, kakhin e hno lah ao. A hmaunawngha hoi dueng kâkuen e a ikhai dawkvah, ahnimouh teh carôe lahoi a due han. ");
INSERT INTO cth_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Kai ni nangmouh na hrawi awh teh, kho na sak hane ram ni na palo awh hoeh nahanelah, Kaie phunglawknaw pueng na tarawi awh han. ");
INSERT INTO cth_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Nangmae hmalah ka takhoe e miphunnaw e singyoe hah na tarawi awh mahoeh. Ahnimanaw ni hot patet e hno a sak awh dawkvah ka panuet. ");
INSERT INTO cth_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ahnimae ram lah kaawm e sanutui hoi khoitui a lawngnae ram hah, nangmouh ni râw lah na coe awh hanelah, Kai ni khoeroe na poe awh han telah Kai ni kâ na poe awh toe. Kai teh alouke miphunnaw hoi nangmouh na kapek e nangmae BAWIPA Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Hatdawkvah, kathounge moi, kathounghoehe moi, kathounge tava, kathounghoehe tavanaw hah na kapek han. Kai ni kapek e patetlah Kathounghoehe moi, tava, talai dawk a von hoi kâva e saring buetbuet touh lahoi namahoima kâkhinsak awh hanh. ");
INSERT INTO cth_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Kai Cathut, kathoung dawkvah nangmouh na panki teh Jentelnaw hoi na kapek dawkvah, Kai hanelah na kâthoung awh han. ");
INSERT INTO cth_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tongpa thoseh, napui thoseh, kahrai khueyue, camkathoum lah kaawm e tami teh thei roeroe lah ao han. Hot patet e tami teh, talung hoi dei lah ao han. Amae thi phu amae lû dawk a bo han. ");
INSERT INTO cth_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Cathut ni Mosi koe, nang ni Aron capa, vaihmanaw koe bout na dei pouh hane teh, na miphunnaw duenae dawk apihai na kâkhinsak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Hateiteh, kahnai poung e manu napa, canaw, hmaunawngha, ");
INSERT INTO cth_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Vâ ka tawn hoeh rae na tawncanu hanelah, khin thainae kâ a tawn. ");
INSERT INTO cth_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Na tami khobawinaw hanelah kâkhinsak hanelah awm hoeh. ");
INSERT INTO cth_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Vaihma teh lû hoi pâkhamuen ngaw mahoeh. Atak hai kâbouk mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ahni teh amamae Cathut hanelah a thoung han. Na Cathut e min mathout sak awh hanh. Cathut e canei a thueng awh dawkvah, a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ahni teh kâyawt e napui, a nuencang kahawihoehe napui, vâ hoi kamphei e napui hoi na kâyuva mahoeh. Bangkongtetpawiteh, vaihma teh Cathut hanelah kâthoung e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Vaihma teh na Cathut e vaiyei ka poe e lah ao dawkvah, amahoima kâthoung naseh. Nangmouh na kathoung sak e Kai BAWIPA teh kathoung dawkvah, ahni hai nangmouh hanlah kâthoung naseh. ");
INSERT INTO cth_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Vaihma e canu ni amae tak a kâyo teh amahoima min mathoenae sak pawiteh, a na pa min kamathout sak e lah ao. Ahni teh hmai hoi sawi lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Hmaunawngha thung dawk vaihma kacue lah rawi teh, a lû dawk satui awi lah kaawm e teh, a khohna ravek hanh naseh. A lû dawk e lupawk rading hanh naseh. ");
INSERT INTO cth_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ro koe cet hanh naseh. A manu hoi a na pa hanelah kathounghoehe lah awm hanh naseh. ");
INSERT INTO cth_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Hmuen kathoung koehoi tâcawt mahoeh. Amae Cathut e hmuen kathoung khin sak mahoeh. Bangkongtetpawiteh, amae Cathut ni rawinae satui ahni dawk ao toe. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Tanglakacuem duengdoeh a yu lah a la han. ");
INSERT INTO cth_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Lahmai thoseh, Ma e napui thoseh, Min mathoe ka phawt e napui thoseh, kâyawt e napui thoseh, yu lah lat mahoeh. A miphun dawk e tanglakacuem dueng hah a la han. ");
INSERT INTO cth_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Amae capa hah a taminaw koe min mathout sak mahoeh. Kai Cathut teh ahnimanaw kathoung sak e doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","BAWIPA ni Mosi koe, nang ni Aron koe bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Na miphunnaw, catounnaw dawk yon ka tawn e tami teh vaiyei thueng hanelah tho hanh naseh. ");
INSERT INTO cth_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Mitdawn, khokkhem, a hnawng ka uek e, a kutkhok hloi kasaw e taminaw, ");
INSERT INTO cth_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kut ka lawt e, a khok ka lawt e, ");
INSERT INTO cth_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Hnamkhun, rahnoum, mitmawm, raipha, ngavangrawca, yangmukhe e taminaw teh bawk mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Vaihma Aron phun dawk e ka kuepcing hoeh e tami buet touh ni boehai hmaisawi thuengnae hah hnai mahoeh. Tak ka kuepcing hoeh e lah ao dawkvah, vaiyei poe hanelah hnai mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Kathounge vaiyei thoseh, kathoungpounge vaiyei thoseh, amae Cathut e vaiyei teh a ca han. ");
INSERT INTO cth_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Tak ka kuepcing hoeh dawkvah, hni yap e thung thoseh, thuengnae khoungroe thoseh, cet awh mahoeh. Telah hoehpawiteh, Kaie hmuen kathoung khin payon vaih. Kai BAWIPA ni hote hmuennaw teh kathoung sak toe ati. ");
INSERT INTO cth_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Hottelah, Mosi ni Aron hoi capanaw, Isarel miphunnaw pueng koe patuen a dei pouh. ");
INSERT INTO cth_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","BAWIPA ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Aron hoi capanaw ni kai hanelah thoung sak laihoi ka min mathoe hoeh hanelah, Isarel miphunnaw e kathounge hnonaw hoi amamouh hoi kâhla sak hanlah dei pouh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","BAWIPA hanelah Isarel miphunnaw thoung sak nateh, kathounge hnonaw hah, thoung laipalah ka hnai e vaihmanaw teh, Kai koehoi takhoe lah ao han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Ka hrikbei e hoi lacip patawnae ka tawn e Aron e capanaw teh, a thoung awh hoehroukrak kathounge hno cat awh mahoeh. Ro hoi kâkuen lah kathounghoehe hno ka tek e tami, a yangtui ka tâcawt e tami, ");
INSERT INTO cth_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ama kakhin sak thai e, a von hoi ka kâva e saring ka tek e tami, khinnae buetbuet touh hoi kâkhinsak e tami, hot patet e tami kâbet e taminaw teh, ");
INSERT INTO cth_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Tangmin totouh kathounghoehe lah ao awh han. Tui kamhluk hoehpawiteh kathounge cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Kanî a khup hoi teh kathounge lah ao toung dawkvah, Kathounge hno teh ahnimae rawca lah ao dawkvah bout a ca han. ");
INSERT INTO cth_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ama pouk kadout e saring, sarang ni a kei e caha cat mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Vaihmanaw ni ka phunglam a raphoe awh teh, a yonnae kecu dawk a due awh hoeh nahanelah, Kaie phunglam a tarawi awh han. Kai teh nangmouh kathoung sak e BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Alawilae tami ni kathounge hno poe e hah, cat mahoeh. Vaihma im ka luen e imyin ni cat mahoeh. Thaw tawk hanlah hlai e tami ni hai cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Vaihma ni phoisa hoi a ran e tami, a kawk e taminaw ni hote rawca teh a ca han. ");
INSERT INTO cth_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Vaihma canu teh alawilae tami ni a yu lah lat pawiteh, kathounge hno poe e hah cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Hateiteh, a vâ a due nakunghai thoseh, a vâ hoi kamphei nakunghai thoseh, ca khe laipalah a na pa im bout a ban teh a nawnae patetlah bout awm pawiteh, a na pa ni a ca e bout a ca han. Alawilae tami ni cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Tami ni kathounge hno panuek laipalah cat payon pawiteh, ca payonnae hno phu hoi pung panga touh dawk pung touh vaihma koe bout a sin han. ");
INSERT INTO cth_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Isarel miphunnaw ni BAWIPA koe poe e kathounge hnonaw hah, khin sak mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Hote hnonaw ka cat payon ni teh sak payonnae yon teh amamouh ni a khang han. Bangkongtetpawiteh, Kai teh nangmouh kathoung sak e BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","BAWIPA ni Mosi koe, nang ni Aron hoi a canaw, Isarelnaw pueng koe patuen na dei pouh han e teh, ");
INSERT INTO cth_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Isarel miphun thoseh, Isarelnaw koe kho ka sak e Jentelnaw thoseh, lawkkam e lahoi poe e hno, lungtho lahoi poe e hno lah kaawm e hmaisawi thuengnae Cathut koe thueng han na ngai pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Cathut lungyouk nahanelah kacueme tu, hmae, hoi maitotannaw hah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Toun kaawm e saring na poe awh mahoeh. Poe pawiteh Cathut ni a lungyouk mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Lawkkam e lahoi poe e, lungtho e lahoi poe e tu, hmae, hoi maitonaw hah BAWIPA koe roum thuengnae lah poe han na ngai pawiteh, a lungyouk thai nahanlah, akuepcing han. Toun han buet touh boehai awm han naseh. ");
INSERT INTO cth_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","A mit ka dawn e, A hru ka lawt e, a tak ka kuep hoeh e, a hmâ ka cat e, ka pâphu e, ka raipha e, hot patet e patawnae buet touh awm pawiteh, Cathut koe poe mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ma lungtho hoi poenae dawk teh, maito thoseh, tu thoseh, a takthai ka vout e lahoi poenae dawk teh hot patet e hah a lungyouk mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","A yangtuen buet touh ka khe e, hoehpawiteh, ka tangpawk e, hoehpawiteh phengcatai e teh Cathut koe poe mahoeh. Nangmae ram thung hot patet e thuengnae na sak awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Hot patet e saring hah Jentelnaw ni ka poe nakunghai toun ao dawkvah na Cathut e pawi hanlah poe hanh naseh. Poe pawiteh a lungyouk mahoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","BAWIPA ni Mosi koe bout a dei pouh e teh, ");
INSERT INTO cth_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Tu, hmae hoi maito naw a khe navah, hnin sari touh thung a ca hoi a manu na papek awh mahoeh. A hnin taroe hnin hoi doeh, BAWIPA koe hmai thuengnae hanlah a khout. ");
INSERT INTO cth_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Maito thoseh, tu hoi hmae thoseh, a manu hoi a ca hnin touh dawk mek na thet mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Hahoi, BAWIPA koe lunghawilawkdeinae thuengnae poe hanlah na ngai pawiteh a lungyouk lah poe haw. ");
INSERT INTO cth_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Hnin touh hoi be na ca han. Atangtho ditouh na pek mahoeh. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Nangmouh ni kaie kâpoelawknaw na tarawi awh han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ka min kathoung heh na khin sak awh mahoeh. Isarelnaw ni BAWIPA a thoung telah a panue awh han. ");
INSERT INTO cth_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Kai teh nangmae Cathut lah ka o nahanlah, Izip ram hoi na ka tâcawt sakkung hoi na kathoung sakkung lah ka o. Kai teh BAWIPA doeh telah ati. ");
INSERT INTO cth_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","BAWIPA ni Mosi koe, nang ni Isarelnaw koe bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Nangmouh ni na sak e kathounge kamkhuengnae, Kai BAWIPA e pawinaw teh; Hnin taruk touh thung thaw na tawk awh han. Hnin sari hnin teh kâhatnae sabbath hnin, kathoung kamkhuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Hnin taruk touh thung thaw na tawk awh han. Hateiteh, hnin sari hnin teh kâhatnae, kamkhuengnae hnin kathoung lah ao dawkvah bang thaw haiyah na tawk awh mahoeh, na onae pueng koevah BAWIPA hanlah sabbath hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ama tueng nah nangmouh ni na pathang awh hane kathounge kamkhuengnae lah kaawm e Cathut pawinaw teh; ");
INSERT INTO cth_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Apasueke thapa, hnin hlaipali, tangmin nateh BAWIPA e ceitakhai pawi doeh. ");
INSERT INTO cth_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Hote thapa, hnin hlaipanga hnin teh BAWIPA hanlah tonphuenhoehe pawi lah ao. Hnin sari touh thung tonphuenhoehe na ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Apasuek hnin vah kathoung kamkhuengnae na sak awh han. Bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Hateiteh, hnin sari touh thung BAWIPA koe rawca thuengnae na sak awh han. Asari hnin nah kathoung kamkhuengnae na sak han. Hat hnin nah, bang thaw hai na tawk mahoeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Cathut ni Mosi koe bout a dei pouh e teh, nang ni Isarel miphunnaw koe patuen na dei pouh hane teh; ");
INSERT INTO cth_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Kai ni na poe e ram dawk na pha awh toteh, cang na a awh toteh, apasuek na a e cabong buet touh vaihma koe na thokhai awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Nangmouh ni a lungyouk awh nahanlah vaihma ni sabbath hnin atangtho vah hote cabong hah Cathut hmalah a kahek han. ");
INSERT INTO cth_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Cabong a kaheknae hnin dawkvah âvâ ka cawt hoeh rae tutanca hah BAWIPA hanlah hmaisawi thuengnae a sak han. ");
INSERT INTO cth_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Hote thuengnae hoi ka kâkuen e tavai thuengnae teh Cathut koe hmuitui hanlah hmaisawi thuengnae lah kaawm e satui hoi kalawt e tavai ephah pung hra pung touh kalawt e lah ao han. Awi thuengnae teh misurtui buet touh han. ");
INSERT INTO cth_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Na Cathut koe thuengnae hnin a pha hoehnahlan vah, vaiyei, vaicakuem karê e, anhla kahring a pawhik na cat awh mahoeh. Hetteh, na onae hmuen pueng koe na catoun ditouh na tarawi hane phunglam lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kahek thuengnae cabong na thokhainae hnin, sabbath hnin atangtho hoi sabbath avai sari totouh na touk awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Sabbath avai sarinae atangtho amom hoiyah hnin 50 touh na touk hnukkhu, Cathut koe tavai thuengnae a tha lah bout na sak han. ");
INSERT INTO cth_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","BAWIPA hanlah aluepaw, ton ni a po sak e tavai ephah pung hra pung hni hoi sak e kahek hane vaiyei kahni touh na im hoi na sin awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Hote vaiyei hoi âvâ ka cawt hoeh rae tuca sari touh, maitotanca buet touh, hmae kahni touh, tavai thuengnae, awi thuengnae hoi cungtalah BAWIPA koe hmuitui nahanlah hmai hoi sawi e thuengnae lah kaawm e hmaisawi thuengnae sathei hah na thueng awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Yon thuengnae lah hmaeca buet touh thoseh, roum thuengnae hanlah âvâ ka cawt hoeh rae tuca kahni touh thoseh, na thueng han. ");
INSERT INTO cth_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Vaihma ni aluepaw, vaiyei hoi cungtalah a kahek vaiteh, tuca kahni touh a sin vaiteh BAWIPA hmalah kahek thuengnae a sak han. Hote hnonaw haiyah vaihma hanlah BAWIPA hmalah kathounge hno lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Hote hnin dawk kathoung kamkhuengnae hah na sak awh han. Thaw banghai na tawk awh mahoeh. Na onae hmuen pueng koe na ca catoun ditouh na tarawi awh hane phunglawk lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Na law dawk cang na a awh navah, lawri totouh koung na a awh mahoeh. Cabong na pâhma e hah bout na racawng mahoeh. Hotnaw teh karoedengnaw hoi imyinnaw hanlah na pek pouh han. Kai teh nangmae BAWIPA Cathut doeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","BAWIPA ni Mosi koe, nang ni Isarel miphunnaw koe patuen bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Nangmouh ni tha sari, apasuek hnin nah mongka ueng pawi kathoung kamkhuengnae sabbath hnin hah na ya awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Thaw na tawk awh mahoeh. BAWIPA hanlah hmaisawi thuengnae na sak han telah a ti. ");
INSERT INTO cth_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Cathut ni Mosi koe bout a dei e teh, ");
INSERT INTO cth_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Tha sari, hnin hra navah, yonthanae hnin, kathoung kamkhuengnae saknae hnin lah ao. Khang laihoi BAWIPA hanlah hmaisawi thuengnae na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Hote hnin dawk bang thaw hai na tawk mahoeh. Na BAWIPA Cathut hmalah yonthanae hnin lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Hote hnin nah, ka ya hoeh e taminaw teh amae miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Hote hnin dawk thaw buetbuet ka tawk e tami teh a miphun dawk hoi a takhoe vaiteh ka raphoe han. ");
INSERT INTO cth_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Bang thaw hai na tawk awh mahoeh. Na onae hmuen pueng koe na ca catoun ditouh na tarawi awh hane phunglawk lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hote hnin teh yanae hnin lah ao. Atako hnin tangmin lahoi atangtho tangmin ditouh na ya awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Cathut ni Mosi koe, nang ni Isarel miphunnaw koe patuen bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Nangmouh ni tha sari, hnin hrahlaipanga hnin hoi hnin sari touh thung Cathut hanelah lukkarei pawi na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Apasuek hnin dawk kathoung kamkhuengnae na sak awh han. Thaw na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Hnin sari touh thung BAWIPA koe hmaisawi thuengnae na sak awh han. A hnin taroe hnin haiyah, kathoung kamkhuengnae hoi BAWIPA koe hmaisawi thuengnae hah na sak awh han. Ka talue e kamkhuengnae lah ao dawkvah thaw na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Hotnaw teh, BAWIPA e sabbath hnin, BAWIPA koe pasoumhno, ");
INSERT INTO cth_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Lawkkamnae lahoi thuengnae, lungtho lahoi thuengnae hloilah hnin touh hoi hnin touh BAWIPA koe hmaisawi thuengnae, tavai thuengnae, sathei thuengnae hoi awi thuengnae naw sak e lah kathoung kamkhuengnae, BAWIPA e pawinaw lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Hotnaw hloilah, law dawk e caticamu pâkhueng hnukkhu, tha sari, hnin hrahlaipanga hnin hoi hnin sari touh thung BAWIPA koe pawi na to awh han. Apasuek hnin hoi a taroe hnin vah sabbath na ya awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Apasuek hnin dawk a paw kahawihloe e, samtue kang hoi a hna karung e thingkangnaw hah a sin awh teh, Nangmae BAWIPA Cathut hmalah hnin sari touh thung na lunghawi sak awh. ");
INSERT INTO cth_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hote pawi hah kum kum touh dawk hnin sari touh thung Cathut hanlah na sak awh han. Na miphun na catoun ditouh tarawi hane kawi phunglawk lah ao. ");
INSERT INTO cth_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Hote pawiteh thapa ayung sari nah na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Isarel miphunnaw Izip ram hoi tâcokhai navah, thingkang rim dawk o saknae hah na miphun, na catounnaw ni a panue thai nahanelah, Isarelnaw teh thingkang rim dawk hnin sari touh ao han. Kai teh nangmae BAWIPA Cathut doeh a ti. ");
INSERT INTO cth_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mosi ni hai BAWIPA e pawinaw hah Isarel miphunnaw koe na pathang pouh. ");
INSERT INTO cth_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","BAWIPA ni Mosi koe bout a dei e teh, ");
INSERT INTO cth_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Rangpui kamkhuengnae lukkareiim dawk lawkpanuesaknae lukkarei yap e alawilah, hmaikhom dawk hmai pou a ang nahanlah, Olive paw na phawm vaiteh, na lae olive satui hah Isarel miphunnaw ni nang koe thokhai hanelah patuen dei pouh. ");
INSERT INTO cth_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aron ni hai tangmin hoi amom totouh Cathut hmalah hote thaw a tawk han. Na miphun na catounnaw ditouh tarawi hane kâ poe e lah ao. ");
INSERT INTO cth_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Kathounge hmaiimkhok dawk hmaiimnaw hah Cathut hmalah Aron ni pou a rakueng han. ");
INSERT INTO cth_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Nang ni tavai na la vaiteh, ephah pung hra pung hni touh e hah vaiyei buet touh lah, vaiyei hrahlaikahni touh na sak hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","BAWIPA hmalah kathounge caboi van vah, vaiyei taruk taruk touh hoi pung hni telah na pacoung han. ");
INSERT INTO cth_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","BAWIPA koe hmaisawi thuengnae lah kaawm e pahnim hoeh nahanelah, hote vaiyei pung hni touh e van vah, kathounge frankinsen na ta han. ");
INSERT INTO cth_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Cathut e lawkkam patetlah Isarelnaw e kut dawk hoi dâw e vaiyei hah, Aron ni Cathut hmalah sabbath hnintangkuem pou a rakueng han. ");
INSERT INTO cth_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hote vaiyei teh Aron hoi a canaw e lah ao dawkvah hmuen kathoung dawk a ca awh han. BAWIPA koe hmaisawi thuengnae thung dawk hote vaiyei teh a yungyoe phunglam patetlah Aron hanlah kathoungpounge lah ao telah a ti. ");
INSERT INTO cth_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Hahoi Isarel napui e capa, a na pa teh Izip tami, Isarelnaw onae koe a cei teh, Isarel napui e capa hoi Isarel tami e capa teh roenae rim thung a kâyue roi. ");
INSERT INTO cth_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Cathut e min a pacekpahlek teh thoe a bo. Ahnie a manu teh Dan miphun, dibri e canu Shelomith lah ao. ");
INSERT INTO cth_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Ka payon e tami hah Mosi koe a thokhai awh teh, BAWIPA e ngainae a panue hoehroukrak a paung awh. ");
INSERT INTO cth_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","BAWIPA ni Mosi koe, ");
INSERT INTO cth_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Thoe ka bo e tami hah rim alawilah a hrawi awh teh, ahnie lawk ka thai naw pueng ni a lû van kut a toung pouh hnukkhu, rangpuinaw ni talung hoi dei awh naseh. ");
INSERT INTO cth_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Nang ni Isarel miphunnaw koe patuen na dei hane teh, Cathut thoe ka bo e tami teh ama ni a khang han. ");
INSERT INTO cth_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Cathut e min ka pacekpahlek e tami teh thei roeroe lah ao han. Rangpuinaw ni hote tami hah talung hoi a dei katang awh han. A miphun thoseh, alouke miphun thoseh, a min pacekpahlek pawiteh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Tami ka thet e tami hai thei roeroe lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Saring ka thet e tami hai katawnkung koe buet touh thet pawiteh buet touh aphu a rawng pouh awh han. ");
INSERT INTO cth_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Tami ni a imri lungpataw sak pawiteh, ahni koe a sak e patetlah ama ni a khang han. ");
INSERT INTO cth_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","A hru hanlah a hru, mit hanlah mit, hâ hanlah hâ, ahni koe patawnae na sak e patetlah nama hai patawnae na khang han. ");
INSERT INTO cth_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Saring ka thet e tami teh buet touh hanelah buet touh bout a poe han. Tami ka thet e tami teh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","A miphun thoseh, alouke miphun thoseh, ama dueng lahoi lawkcengnae teh a khang han. Kai teh nangmae BAWIPA Cathut doeh telah Mosi koe atipouh. ");
INSERT INTO cth_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Thoe ka bo e tami teh rim alawilah a hrawi awh vaiteh talung hoi dei hanelah Mosi koe patuen a dei pouh teh, Cathut ni Mosi koe lawkthui e patetlah Isarel miphunnaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Sinai mon dawk, BAWIPA ni Mosi koe, nang ni Isarel miphunnaw koe patuen bout na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Kai ni na poe e ram dawk na pha awh toteh, Hote ram ni BAWIPA hanlah sabbath ayâ han. ");
INSERT INTO cth_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kum taruk touh thung law hoi misur takha na sak awh vaiteh, apawhik na pâkhueng awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kum sarinae kum teh BAWIPA hanlah sabbath kum, ram thung kaawm e pueng kâhat vaiteh, sabbath yanae kum lah ao. Law na sak mahoeh. Misur takha hai na rasoun mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Law dawk ama pouk kapâw e apawhik hai na khi mahoeh. Na rasoun hoeh e misur hai na khi mahoeh. Ram pueng kâhatnae kum lah ao. ");
INSERT INTO cth_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ram thung sabbath kum nah ka tâcawt e apawhik pueng teh namamouh, napui hoi tongpa, na thaw ka tawk e hoi, nang koe kaawm e imyinnaw hoi, ");
INSERT INTO cth_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","ram thung kaawm e saring pueng ni ca hane kawi lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Sabbath kum, kum sari touh na parei vaiteh, kum sari vai sari touh tie kum 49 akuep hnukkhu, ");
INSERT INTO cth_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Tha sari, hnin 10, yonthanae hnin dawk mongka hah ram pueng dawk ueng sak han. ");
INSERT INTO cth_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Aruipanganae kum hah thoung sak vaiteh, ram pueng dawk khoca pueng koe hloutnae pathang han. Jubili kum lah ao dawkvah tami pueng amae talai, amae phun koe a ban han. ");
INSERT INTO cth_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Hote aruipanganae kum teh Jubili kum lah ao dawkvah law na sak mahoeh. ama pouk kapâw e hai na a mahoeh. Rasoun hoeh e misur takha dawk e a paw hai na khi awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Jubili kum teh kathounge kum lah ao dawkvah law dawk e apawhik dueng ca han. ");
INSERT INTO cth_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Jubili kum nateh tami pueng ni amae khoram lah a ban awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Nangmouh ni buet touh hoi buet touh yorannae na sak pawiteh buet touh hoi buet touh kâyue awh hanh. ");
INSERT INTO cth_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Jubili kum aloum teh a ngai rae kumnaw apawhik a paw nahan a kum parei vaiteh yorannae na sak han. ");
INSERT INTO cth_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Hottelah, a paw paw na kum parei hoi yo e lah ao dawkvah, kum ayoun apap e patetlah aphu payoun, paluen lahoi yoran han. ");
INSERT INTO cth_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Nangmouh teh buet touh hoi buet touh kâyue awh hanh. Na Cathut taket awh. Kai teh nangmae BAWIPA Cathut lah ka o. ");
INSERT INTO cth_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Nangmouh ni ka phunglam hah na tarawi pawiteh hote ram dawk lungmawng lahoi kho na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Talai ni hai apawhik a tâco sak vaiteh, kaboumlah na ca awh vaiteh, lungmawng lah kho na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Nangmouh ni hai asari kum nah, kaimouh ni bangtelamaw ka ca awh han. Law ka sak awh hoeh. Apawhik hai ka pâkhueng awh hoeh na tet awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","A kum taruk nah, nangmouh yawhawinae na poe vaiteh, hote kum dawk kum thum touh hane apawhik ka tâco sak han. ");
INSERT INTO cth_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","nangmouh ni a kum taroe nah law na sak teh a kum tako nah apawhik pâkhuengnae totouh a karuem e apawhik na ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Talai hah ayâ pou tawn sak hanelah, yawt hanh. Talai teh Kaie doeh. Nangmouh teh Kai koe kârayen e imyin lah na o awh. ");
INSERT INTO cth_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nangmouh ni talai na tawn a e hmuen pueng bout ratangnae kâ na poe awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Na hmaunawnghanaw ni roedeng boilah a tawn e talai yawt pawiteh, kahnai e hmaunawngha ni a yo e talai hah bout ratangnae kâ ao han. ");
INSERT INTO cth_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Hote talai hah ka ratang hane buet touh hai awm hoehpawiteh, ka tawn karuem ni ama ni bout ratang thai pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","A yonae kum hah a touk vaiteh, aphu yit touh bout poe naseh. Hote talai teh bout a coe han. ");
INSERT INTO cth_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Bout poe thai hoehpawiteh, a yo e hno hah Jubili kum totouh ka ran e kut dawk ao sak han. Jubili kum nah tha pawiteh, hmaloe e katawnkung e kut dawk bout a pha han. ");
INSERT INTO cth_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Khopui dawk e im hah imkung ni yawt pawiteh, kum touh thung ratang thainae kâ ao sak han. ");
INSERT INTO cth_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kum touh thung ratang thai hoehpawiteh, hote im ka ran e catounnaw ni pou a tawn han. Jubili kum ka phat nakunghai tha pouh mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Rapan ka tawn hoeh e kho dawk kaawm e im hah law patetlah a pouk vaiteh, ratang thainae kâ ao. Jubili kum pha toteh a tha pouh han. ");
INSERT INTO cth_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Hat navah, Levihnaw ni a tawn e khopui hoi khopui dawk e imnaw teh nâtuek hai thoseh, ratang thainae kâ ao. ");
INSERT INTO cth_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Levih ni a tawn e im hoi kho thoseh, ayâ ni ran pawiteh, Jubili kum a pha toteh a tha han. Bangkongtetpawiteh, Isarel miphun dawk Levihnaw teh ama onae kho hoi im hloilah alouke hno tawn hoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Hateiteh, Levih kho dawk kaawm e imlawnaw yawt mahoeh. Pou a tawn awh han. ");
INSERT INTO cth_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Nange na hmaunawngha ni a roedeng lawi, imyin patetlah tho pawiteh, nang koe o sak hanlah na kabawp han. ");
INSERT INTO cth_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ahni koe apung na cat mahoeh. Na hmaunawngha hah, nang koe o sak hanelah, na Cathut taket loe. ");
INSERT INTO cth_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Apung ngaihawi lahoi ahni koe tangka thoseh, canei thoseh na cawi mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Kai ni Kanaan ram na poe awh teh, nangmae Cathut lah ka o nahanlah nangmouh Izip ram hoi na ka tâcawtkhai e nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Na hmaunawngha ni a roedeng dawkvah nang koe kâyawt pawiteh, san patetlah na hno mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Ahni teh hlai e patetlah thoseh, imyin patetlah thoseh, nang koe ao vaiteh, Jubili kum totouh na thaw a tawk han. ");
INSERT INTO cth_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Hat navah, ahni teh a canaw hoi a tâco vaiteh amae a hmaunawngha, a mintoenaw e talai koe lah bout a ban han. ");
INSERT INTO cth_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Bangkongtetpawiteh, ahnimouh teh Izip ram hoi ka tâcokhai e ka thaw ka tawk e lah ao dawkvah san lah o hanelah na yawt mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ahni teh puenghoi na rektap mahoeh. Na Cathut hah taket. ");
INSERT INTO cth_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Nang ni na tawn hane sannu sanpa teh na tengpam kaawm e Jentelnaw koe na ran han. ");
INSERT INTO cth_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Hothloilah, nangmouh koe kho ka sak e alouk ram e taminaw thoseh, na ram dawk a khe e a canaw thoseh, na ran vaiteh na tawn han. ");
INSERT INTO cth_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Ahnimanaw teh san dawk hoi ka khe e lah ao teh, nang hoi na canaw ni râw lah na tawn han. Na hmaunawngha, Isarel miphun dawk e tho pawiteh, buet touh hoi buet touh puenghoi na rektap mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Nangmouh koe kho ka sak e alouke tami ni a tawnta ei teh, ahnie teng kho ka sak e na hmaunawngha a roedeng teh, nang koe kho ka sak e alouke ram e taminaw koe thoseh, a ca catounnaw koehai thoseh, kâyawt awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Yo hnukkhu, bout ratang thainae kâ ao han. A hmaunawngha lah kaawm e buetbuet touh ni a ratang han. ");
INSERT INTO cth_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","A na hma, a panga, a hmaunawngha koehoi rei ka tâcawt e imthung buetbuet touh ni a ratang han. Ama ni ratang thai pawiteh a ratang han. ");
INSERT INTO cth_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Bawi hoi sannaw teh yorannae kum dawk hoi kamtawng vaiteh, Jubili kum totouh kum a parei hnukkhu, a kum ayoun apap e patetlah thoseh, a hlainae tueng khet lahoi thoseh, aphu teh to han. ");
INSERT INTO cth_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Jubili kum a pha hoehnahlan a thawtawknae kum ayoun apap e parei vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","A ngai rae a kumtha ayoun apap e patetlah ratang nahane aphu hah rannae phu dawk hoi rayu vaiteh bout a pâban han. ");
INSERT INTO cth_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ahni teh kum touh hnukkhu, kum touh hlai e patetlah ao han. Na hmaitung vah rektap lah awm hanh naseh. ");
INSERT INTO cth_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Hottelah hoi ratang thai hoehpawiteh, Jubili kum a pha toteh, ahni teh a canaw hoi bawi e kut dawk hoi a hlout han. ");
INSERT INTO cth_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Bangkongtetpawiteh, Isarelnaw teh ka thaw ka tawk e lah ao awh. Izip ram hoi ka tâcokhai e ka thaw ka tawk e lah ao awh. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","BAWIPA ni bawk hanlah kutsak thoseh, talung ung e thoseh, meilam thuk e talung thoseh, na sak awh mahoeh. Kai teh nangmae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Kaie Sabbath hah na ya awh vaiteh ka hmuen kathoung na bari awh han. Kai teh BAWIPA doeh. ");
INSERT INTO cth_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Kaie phunglawknaw hoi kâpoelawknaw hah na tarawi pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Ama tue nah kho ka rak sak han, talai ni apawhik a tâco sak vaiteh takha thung e thingthainaw ni a paw awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Canganae teh misur paw khinae tueng totouh thoseh, misur paw khinae teh law tunae tueng totouh thoseh, a pha vaiteh, nangmouh ni kaboumlah na ca awh vaiteh, na ram dawk lungmawngcalah kho na sak awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Na ram dawk taran karoum sak vaiteh, katarengkung awm laipalah ihmutui lah na i awh han. Sarangnaw hah na ram dawk hoi ka pâlei vaiteh na ram pueng ni tahloi duenae dawk hoi a hlout awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Nangmouh ni na tarannaw na pâlei awh vaiteh, tahloi hoi na thei awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Nangmouh thung dawk tami panga touh ni taran 100 touh na pâlei awh han. Tami 100 touh ni taran thong hra, touh na pâlei awh vaiteh, tahloi hoi na tâ awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Yawhawinae na poe awh vaiteh na pungdaw awh han. Nangmouh hoi lawkkam ka sak e pou ka caksak han. ");
INSERT INTO cth_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Na pâtung e caruem abaw hoehnahlan, catha bout ao toung dawkvah caruem teh na pahoung awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kai ni panuet laipalah nangmouh koe lukkareiim ka o sak han. ");
INSERT INTO cth_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nangmouh koe ka o vaiteh nangmae Cathut lah ka o han. Nangmouh hai ka tami lah na o awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Izip ram dawk san na tang awh hoeh nahanelah, Kai na BAWIPA Cathut ni na tâcokhai awh toe. Na kahnamrui ka a teh, kalan lah na ceisak toe. ");
INSERT INTO cth_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Hateiteh, nangmouh ni ka lawk na ngai awh hoeh, kâpoelawk abuemlah na tarawi awh hoeh, ");
INSERT INTO cth_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Ka phunglawknaw na panuet awh teh, banglahai noutna laipalah kâpoelawk na tarawi awh hoeh, lawkkam na raphoe awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Nangmouh koe ka sak hane hnonaw teh, mit ronae, lungpuennae, kaluekalapnae, kahawi thai hoeh e patawnae hoi patawnae aphunphun ka pha sak han. Cati na kahei eiteh, aphu awm hoeh. Tarannaw ni a ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nangmouh na pahnawt awh vaiteh taran hmalah na sung sak awh han. Nangmanaw teh tarannaw ni na uk awh vaiteh apini na ka pâlei hoeh nakunghai na yawng awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Hottelah na khang a eiteh, ka lawk bout na ngai awh hoehpawiteh, namae yon dawk let sari totouh na rek awh han rah. ");
INSERT INTO cth_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Nangmae kâoupnae hah ka khoe han, kalvan hah sum patetlah thoseh, talai hah rahum patetlah thoseh, ka sak vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Nangmanaw teh ayawmyin lah tha na patho awh han. Na talai ni rawca tâcawt sak mahoeh. Takha dawk e thingthainaw ni paw mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Nangmouh ni ka lawk na ngai awh hoeh, Kai na taran awh pawiteh, na yonnae patetlah let sari touh e runae ka pha sak han. ");
INSERT INTO cth_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Nangmouh koe sarang katha vaiteh, na canaw a rakoung awh han, na saringnaw kei awh vaiteh, tami hoe na youn awh han, na lamthung hai kingdi han. ");
INSERT INTO cth_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Hottelah, na khang a nakunghai, na ka panuek awh hoeh lah, Kai bout na taran awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Kai ni hai na taran awh vaiteh na yonnae kecu dawk let sari touh e runae hoi na rektap awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Ka lawkkam na tapoe dawkvah lawkcengnae talai nangmouh lathueng ka pha sak han. Nangmouh ni kho dawk na kamkhueng awh navah, lacik ka pha sak vaiteh, taran kut dawk na poe awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nangmae rawca hah ka takhoe toteh, napui hra touh ni nangmae vaiyei hah takhuen buet touh dawk a pâeng hnukkhu, hote vaiyei hah a khing pouh teh nangmouh ni na boum awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Hathnukkhu haiyah, ka lawk na ngai awh hoeh lah, Kai paroup na taran awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Kai hai ka lungkhuek vaiteh, na taran awh han. Na yon kecu dawk alet sari touh na rek awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Nangmouh ni na canaw e a moi na ca awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Na hmuen karasangnaw hah ka raphoe vaiteh, kutsak cathutnaw hah koung ka rawp sak han. Na ronaw hah hringnae ka tawn hoeh e kutsak cathut van vah, ka tâkhawng vaiteh na panuet awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nangmae khopuinaw ka raphoe hoi hmuen kathoung ka raphoe vaiteh nangmae hmuituinaw ka pahnuem mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Na ram pueng Kai ni ka raphoe e hah hote ram dawk kaawm e na tarannaw ni a hmu navah, kângairu awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Alouke miphunnaw koe na kampek sak awh vaiteh, tahloi hoi na pâlei awh han. Na khopui a rawk vaiteh na ram a kingdi han. ");
INSERT INTO cth_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Hottelah, nangmanaw teh na tarannaw e ram dawk na o awh vaiteh, na ram teh tami kingdi lah onae tueng pueng dawk, na ram kingdi vaiteh, Sabbath hninnaw dawk na nawm awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Nangmouh na o nateh, Sabbath hninnaw dawkvah na ram teh kâhat mahoeh. Tami kingdi lah onae tueng dawk na ram teh kâhat lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Taran ram dawk kaawm rae nangmae lungthin thung kaluenae ka pakhum vaiteh, thinghna kâhuet pawlawk dawk na taki vaiteh, taran kut dawk hoi na yawng e patetlah na yawng awh han. Apinihai pâlei hoeh nakunghai a rawp han. ");
INSERT INTO cth_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Apinihai pâlei hoeh eiteh taran kut dawk hoi ka yawng e patetlah buet touh van buet touh a rawp awh han. Taran hmalah kangdue thainae tawn mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Na tarannaw e ram ni na payawp awh vaiteh Jentelnaw koe na sung awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Kacawirae nangmouh ni taran ram dawk nangmae yon hoi mintoenaw e yon hah na khang awh vaiteh, mintoenaw hoi cungtalah na kahma awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Hateiteh, ahnimouh ni kai koe a yon awh teh, Kai na taran awh dawkvah, ");
INSERT INTO cth_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Kai ni ahnimanaw ka taran vaiteh, a tarannaw e ram dawk ka thak han. Ma e yon, mintoenaw e yon hah pâpho laihoi kâhet awh pawiteh, vuensom ka a hoeh e amamae lungthin hah kârahnoum awh teh, amamae yon dawk reknae khang awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Kai ni Jakop, Isak, Abraham tinaw hoi ka sak e lawkkam thoseh, hote ram thoseh pahnim mahoeh. ");
INSERT INTO cth_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Hote ram teh ahnimae kut dawk hoi a hlout vaiteh, ahnimouh awm laipalah kingdi lah ao navah, amae Sabbath hninnaw dawk a nawm awh han. Ahnimouh ni ka phunglam a panuet awh teh, banglahai noutna hoeh lah a sak e yon kecu dawk reknae a khang awh han. ");
INSERT INTO cth_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Hottelah tarannaw dawk ao awh navah, ahnimanaw ka raphoe vaiteh, ahnimouh hoi lawkkam e raphoe totouh, ahnimanaw Kai ni ka maithoe mahoeh. Ka pahnawt mahoeh. Kai teh ahnimae BAWIPA Cathut doeh. ");
INSERT INTO cth_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Kai teh ahnimae Cathut lah ka o nahanelah Jentelnaw hmalah Izip ram hoi ka tâcokhai e ahnimae mintoenaw hoi ka sak e lawkkam hah, ahnimouh hanlah ka pahnim mahoeh. Kai teh BAWIPA doeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hote phunglawk hoi kâlawknaw hah Sinai mon dawk BAWIPA ni Isarelnaw hanlah Mosi koe a poe e doeh. ");
INSERT INTO cth_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Cathut ni Mosi koe, nang ni Isarelnaw koe patuen na dei pouh hane teh, ");
INSERT INTO cth_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Tami ni lawkkam e patetlah BAWIPA koe poe pawiteh, ka poe hane kawi naw, nang ni aphu tâtueng tangcoung e patetlah Cathut e hno lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Nang ni bangtelamaw aphu na tâtueng han tetpawiteh, tongpa a kum 20 hoi 60 totouh e teh ngun tangka 50 touh lah aphu na tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Napui teh ngun tangka 30 touh lah aphu na tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kum panga koehoi kum 20 totouh e tongpa teh ngun tangka 20, napui teh ngun tangka phek hra touh lah aphu na tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Kum panga a rahim e tongpa teh ngun tangka phek panga, napui teh phek thum touh lah aphu na tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Kumrui taruk lathueng e tongpa teh ngun tangka hlaipanga, napui teh phek hra touh lah aphu na tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Nang ni aphu na tâtueng e patetlah poe thai hoehpawiteh, vaihma koe a cei vaiteh, vaihma ni lawkkam ka sak e tami ni a poe thai e patetlah aphu a tâtueng pouh awh han. ");
INSERT INTO cth_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Tami ni Cathut koe saring poe pawiteh, a poe e pueng teh a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kahawi thoseh, kahawihoehe thoseh, buet touh hoi buet touh na thung awh mahoeh. Thung han na ngai awh pawiteh, kahni touh hoi roi a thoung han. ");
INSERT INTO cth_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Cathut koe poe kawi hoeh e kathounghoehe saring lah awm pawiteh vaihma koe patue vaiteh, ");
INSERT INTO cth_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Ahawi hoi hawihoeh e patetlah vaihma ni aphu a tâtueng han. Vaihma ni a tâtueng e patetlah aphu teh ao han. ");
INSERT INTO cth_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kapoekung ni ratang hanelah ngai pawiteh, saring phu hoi pung panga touh dawk pung touh bout a poe sin han. ");
INSERT INTO cth_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Tami ni BAWIPA hanlah a im poe pawiteh, im ahawi hoi hawihoeh e vaihma ni a khet vaiteh aphu a tâtueng han. Vaihma ni aphu a tâtueng e patetlah aphu teh ao han. ");
INSERT INTO cth_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Im kapoekung ni bout ratang hanlah ngai pawiteh, im phu hoi pung panga touh dawk pung touh bout a poe sin han. ");
INSERT INTO cth_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Tami ni a lawhmuen hah BAWIPA hanlah poe pawiteh, Cati patue e patetlah aphu teh a tâtueng han. Cati hmuen touh patue e law hah ngun tangka 50 touh lah aphu tâtueng han. ");
INSERT INTO cth_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Jubili kum kamtawng nah a law hah poe pawiteh aphu teh a tâtueng yit touh a poe han. ");
INSERT INTO cth_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Jubili kum abaw hnukkhu law hah poe pawiteh, hmalae Jubili kum totouh e a ngai rae kumnaw hah vaihma ni a parei vaiteh, a tâtueng e law phu teh a payoun pouh han. ");
INSERT INTO cth_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Law kapoekung ni bout ratang hanlah ngai pawiteh, a law phu hoi pung panga pung touh bout a poe sin han. ");
INSERT INTO cth_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ratang thai hoeh lah alouke tami koe yawt pawiteh, bout ratang han lawi naseh. ");
INSERT INTO cth_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Jubili kum akuep toteh, hote law teh BAWIPA e lah ao vaiteh vaihmanaw ni a pang han. ");
INSERT INTO cth_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Tami ni a ran e law hah BAWIPA hanlah poe pawiteh, ");
INSERT INTO cth_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Jubili kum totouh hane aphu tâtueng e hah vaihma ni a kum a parei vaiteh, aphu a tâtueng e patetlah hote tami ni hote hnin dawk a poe han. Hote teh BAWIPA e doeh. ");
INSERT INTO cth_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Jubili kum a pha toteh, hote law hah ahmaloe ka tawn ni teh kayawtkung koe bout a poe han. ");
INSERT INTO cth_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Aphu tâtueng e pueng dawk ngun tangka lahoi na tâtueng han. Ngun tangka phek touh e teh gerah 20 touh hoi a kâvan. ");
INSERT INTO cth_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","BAWIPA e lah kaawm e saring camin pueng teh, apinihai ama hanlah lat mahoeh. Bangkongtetpawiteh, camin teh BAWIPA e doeh. Maito, tu hoi hmaecanaw teh BAWIPA e lah doeh ao. ");
INSERT INTO cth_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kathounghoehe saring lah awm pawiteh, aphu tâtueng e patetlah a ratang vaiteh pung panga touh dawk pung touh bout a poe sin han. Ratang ngai hoehpawiteh, aphu tâtueng e patetlah a yo han. ");
INSERT INTO cth_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Hateiteh, tami thoseh, saring thoseh, mae law thoseh, Cathut koe thoebo laihoi poe e pueng teh, apinihai bout ratang bout yawt nahanh lawi naseh. Thoebo laihoi poe e pueng teh Cathut hanlah kathoungpounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Tami patenghai thoebo laihoi na poe pawiteh, bout na ratang mahoeh, na thei han. ");
INSERT INTO cth_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Cakang thoseh, apawhik thoseh, talai dawk hoi ka tâcawt e apawhik pueng hra touh dawk buet touh e teh BAWIPA e hno doeh. BAWIPA hanelah kathounge lah ao. ");
INSERT INTO cth_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Hra touh dawk buet touh e hah ratang hanelah na ngai pawiteh, Aphu hoi pung panga touh dawk pung touh bout na poe sin han. ");
INSERT INTO cth_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Maito thoseh, tu hoi hmae thoseh, sonron rahim vah kâen e ahranae pueng teh BAWIPA hanelah kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Ahawi hoi hawihoeh e na khen awh mahoeh. Buet touh hoi buet touh na thung awh mahoeh. Thung han na ngai awh pawiteh, kahni touh hoi rei a thoung han. Bout na ratang mahoeh telah na dei pouh han. ");
INSERT INTO cth_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hete kâpoelawknaw teh Cathut ni Sinai mon dawk Isarelnaw hanlah Mosi koe kâ a poe e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Izip hoi a tâco awh hnukkhu, kum hni nah kum, thapa yung pahni, apasuek hnin vah Sinai kahrawngum kamkhuengnae lukkareiim dawk BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Isarel tamihu pueng hah a miphun lahoi, a imthung lahoi, a min kâtarui lahoi tongpa pueng koung touk haw, ");
INSERT INTO cth_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","kum 20 lathueng Isarelnaw thung dawk hoi taran ka tuk thai e naw pueng nang nama hoi Aron ni ahuhu lahoi koung na touk awh han. ");
INSERT INTO cth_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Nang koe e miphunnaw pueng thung dawk hoi imthung kahrawikung buet touh koung ao awh han. ");
INSERT INTO cth_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Hetnaw heh nang koe kaawm hane tami minnaw doeh. Reuben dawk hoi Shedeur capa Elizur, ");
INSERT INTO cth_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon dawk hoi Zurishaddai capa Shelumiel, ");
INSERT INTO cth_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Judah dawk hoi Amminadab capa Nahshon, ");
INSERT INTO cth_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issakhar dawk hoi Zuar capa Nethanel, ");
INSERT INTO cth_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun dawk hoi Helon capa Eliab, ");
INSERT INTO cth_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Joseph casak Ephraim dawk hoi Ammihud capa Elishama hoi, Manasseh dawk hoi Pedahzur capa Gamaliel, ");
INSERT INTO cth_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamin dawk hoi Gideoni capa Abidan, ");
INSERT INTO cth_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan dawk hoi Ammishaddai capa Ahiezer, ");
INSERT INTO cth_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asher dawk hoi Okran capa Pagiel, ");
INSERT INTO cth_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad dawk hoi Deuel capa Eliasaph, ");
INSERT INTO cth_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naphtali dawk hoi Enan capa Ahira Enan seh, atipouh. ");
INSERT INTO cth_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Hetnaw heh tamimaya thung dawk hoi rawi e a na mintoenaw miphun dawk hoi kahrawikung Isarel imthung kahrawikungnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Hot patetlah Mosi hoi Aron ni min a kaw e hetnaw heh a ceikhai awh. ");
INSERT INTO cth_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Tamimaya hah thapa yung pahni, apasuek hnin vah koung a kamkhueng awh teh, a na pa hoi, imthungnaw hoi kakhekungnaw, khetsin lahoi yah, kum 20 lathueng pueng teh kakhekungnaw hah ama buet touh min lahoi a kaw awh. ");
INSERT INTO cth_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","BAWIPA ni Mosi koe kâ a poe e patetlah Sinai kahrawngum vah a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Isarel capa, a camin Reuben casak thung hoi a min kâtarui lah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai e, ");
INSERT INTO cth_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Reuben miphun a touk awh e teh 46, 500 touh a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Simeon casak dawk hoi a miphun lahoi imthungkhu lahoi a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Simeon casak a touk awh e naw teh 59, 300 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Gad catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gad miphun dawk a touk awh e teh 45, 650 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Judah catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Judah miphun dawk a touk awh e teh 74, 600 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Issakhar catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Issakhar miphun dawk a touk awh e teh 54, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Zebulun catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Zebulun miphun dawk a touk awh e teh 57, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Joseph catounnaw dawk hoi Ephraim catoun hai imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ephraim miphun dawk a touk awh e teh 40, 500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Manasseh catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Manasseh miphun dawk a touk awh e teh 32, 200 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Benjamin catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Benjamin miphun dawk a touk awh e teh 35, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Dan catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Dan miphun dawk a touk awh e teh 62, 800 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Asher catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Asher miphun dawk a touk awh e teh 41500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Naphtali catounnaw dawk hoi a miphun lahoi a imthungkhu lahoi, a min kâtarui e patetlah tongpa pueng kum 20 lathueng tarantuknae koe ka cet thai naw, ");
INSERT INTO cth_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Naphtali miphun dawk a touk awh e teh 53, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Hotnaw teh Mosi hoi Aron ni Isarel kahrawikung hlaikahni imthung kahrawikungnaw hai a touk awh e doeh. ");
INSERT INTO cth_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Hot patetlah Isarel imthung abuemlahoi kum 20 lathueng taranruknae koe ka cet thai e naw pung Isarel lah koung a touk awh teh, ");
INSERT INTO cth_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","a touk awh e naw pueng teh 603550 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Hatei, ahnimouh thung dawk hoi Levihnaw kakhekung lah touk awh hoeh. ");
INSERT INTO cth_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","BAWIPA ni Mosi koevah, ");
INSERT INTO cth_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Levih miphun teh na touk mahoeh. Isarel taminaw lahai na touksin mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Bangkongtetpawiteh, Levihnaw teh lawkpanuesaknae lukkareiim hoi, hnopai khenyawnkung, haw e kaawm e naw pueng ka khenyawnkung lah na pouk awh han. Lukkareiim hoi a hnonaw pueng ka kâkayawt awh teh, ka khetyawt awh han. Bawknae rim a tengpam moi ao sin awh han. ");
INSERT INTO cth_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Hote bawknae rim teh a tâcokhai hanlah ao toteh, Levihnaw ni a raphoe vaiteh, hote rim bout a thung awh han. Tami alouke miphun bawk pawiteh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isarelnaw ni amamouh o nah tangkuem koe ahuhu lahoi apap e lahoi lukkareiim teh a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levihnaw a pâlei teh, kamkhueng e Isarelnaw lathueng vah a lungkhueknae ao hoeh nahan, Cathut onae im a tengpam vah a roe awh vaiteh, Levihnaw ni lawkpanuesaknae bawknae im teh, a khetyawt awh han. ");
INSERT INTO cth_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Hot patetlah Isarelnaw ni BAWIPA ni Mosi koe kâ a poe e patetlah a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","BAWIPA ni Mosi hoi Aron a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Isarelnaw ni a imthung mitnoutnae koung a vo awh vaiteh, amamae hu lahoi lukkarei rim hah a yap awh han. Kamkhuengnae lukkareiim hmalah koung a kâhmo awh nahanelah, petkâkalup lah a yap awh han. ");
INSERT INTO cth_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Kanîtholah hoi kanîloumlah kangvawi sak hoi a imthung mitnout hah a vo awh vaiteh, lukkareiim ka yap kung teh Judah ransahu han doeh. Judah catoun kahrawikungnaw teh Amminadab capa Nahshon han. ");
INSERT INTO cth_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","A ransahu teh 74, 600 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A hnukthawi lukkareiim kayapkung teh Issakharnaw han. Issakhar catoun kahrawikung teh Zuar capa Nethanel han. ");
INSERT INTO cth_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","A ransahu teh 54, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","A hnukthawi teh Zebulun doeh. Zebulun catoun kahrawikung teh Helon capa Eliab han. ");
INSERT INTO cth_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","A ransahu teh 51, 400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","A ransahu a pap e lahoi Judahnaw a touk e lahoi 186, 400 touh a pha awh teh, hetnaw heh roenae koehoi ahmaloe a tâco awh han. ");
INSERT INTO cth_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Reuben miphunnaw teh akalah ao awh han, a imthung mitnoutnae a vo awh han. Reuben catoun kahrawikung teh Shedeur capa Elizur han. ");
INSERT INTO cth_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","A ransahu teh 46, 500 a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Hahoi mitnout ka yap hane teh Simeon miphun han. Simeon catoun kahrawikung teh Zurishaddai capa Shelumiel han. ");
INSERT INTO cth_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","A ransahu teh 59, 300 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gad miphun doeh. Gad catoun kahrawikung teh Reuel capa Eliasaph han. ");
INSERT INTO cth_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","A ransahu teh 45, 650 a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Reuben miphun teh a ransahu apap e lahoi, 151, 450 a pha awh. Hetnaw heh a hnuk rekkâbang hane tami lah ao awh. ");
INSERT INTO cth_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hot patetlah kamkhuengnae lukkareiim khue hoi a cei awh han. Levihnaw hah a lungui vah ao awh vaiteh, a onae koehoi kamcunae hmuen koehai a huhu lahoi a cei awh han. ");
INSERT INTO cth_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","A imthungkhu mitnoutnae a vonae koehoi kanîloumlah, Ephraim miphunnaw ao awh han. Ephraim catoun kahrawikung teh Ammihud capa Elishama han. ");
INSERT INTO cth_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","A ransahu teh 40, 500 a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Hahoi Manasseh miphun han. Manasseh catoun kahrawikung teh Pedahzur capa Gamaliel han. ");
INSERT INTO cth_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","A ransahu teh 32, 200 a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Hahoi Benjamin miphunnaw han. Benjamin catounnaw kahrawikung teh Gideoni capa Abidan han. ");
INSERT INTO cth_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","A ransahu teh 35, 400 a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ephraim catoun a ransahu a pap e lahoi touk e pueng teh, 108, 100 a pha. Hahoi rekkâbang hanelah a tâco awh han. ");
INSERT INTO cth_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","A imthungkhu mitnoutnae a vonae koehoi Dannaw teh atunglah ao awh han. Dan catoun kahrawikung teh Ammishaddai capa Ahiezer han. ");
INSERT INTO cth_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","A ransanaw teh 62, 700 a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Hahoi mitnout ka yap hane teh, Asher miphun han. Asher catoun kahrawikungnaw teh Okran capa Pagiel han. ");
INSERT INTO cth_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","A ransahu teh 41, 500 a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Hahoi Naphtali catounnaw han. Naphtali catounnaw kahrawikung teh Enan capa Ahira han. ");
INSERT INTO cth_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","A ransahu teh 53, 400 a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan miphun ransahu touk e pueng teh 157, 600 a pha awh. Hahoi ahnimouh teh, a huhu lahoi ka tâcawt e a hnukteng poung lah ao awh han. ");
INSERT INTO cth_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Hetnaw heh Isarel catoun a na pa e imthungkhu lahoi a touk awh e naw doeh. A ransahu teh a sumkum lah 603, 550 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Hatei BAWIPA ni, Mosi koe kâ a poe e patetlah Levihnaw teh Isarelnaw koe touksin e lah awm hoeh. ");
INSERT INTO cth_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","BAWIPA ni Mosi koe kâlawk a poe e patetlah Isarelnaw ni a sak awh. Amamae ahu kâbang lahoi a roe awh. Hot patetlah a miphun lahoi imthung ao awh e patetlah a tâco awh. ");
INSERT INTO cth_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hetnaw heh, Sinai mon koehoi BAWIPA ni Mosi a pato navah, Aron hoi Mosi se nah a thut e doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aron capanaw e a min teh, camin lah Nadab. Hahoi Abihu Eleazar hoi Ithamar doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hetnaw heh vaihma hanlah satui awi e, vaihma thaw tawk hanlah hmoun e, Aron e capanaw e min doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadap hoi Abihu teh Sinai kahrawngum vah kathounghoehe hmai, BAWIPA hmalah thuengnae a sak roi navah, BAWIPA hmalah a due roi, ahnimouh roi teh capa tawn roi hoeh. Eleazar hoi Ithamar teh a na pa a hring navah vaihma thaw a tawk roi. ");
INSERT INTO cth_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Levih miphun teh vaihma Aron koe cetkhai nateh, a thaw a tawk thai nahan, ahni koe awm naseh. ");
INSERT INTO cth_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ahnimouh ni lukkareiim dawk thaw a tawk awh vaiteh, kamkhuengnae lukkareiim hmalah ama hoi kamkhuengnaw ni panki e patetlah thaw a tawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Hnopai pueng a khetyawt awh vaiteh, Isarel catounnaw ni a ham kawi e lah lukkareiim dawk thaw a tawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levihnaw teh Aron hoi a capanaw koevah, na poe awh vaiteh, Isarel catounnaw thung hoi ahnimouh hah na rawi awh vaiteh, kai koe ahnimouh na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aron hoi a capanaw hah na pouk vaiteh, vaihma coungnae hah pou a pang awh han. Ahnimouh koe miphun louk bawk pawiteh, thei lah ao han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","khenhaw! Levihnaw heh Isarel catounnaw thung hoi camin camoim hmaloe ka paawng hanelah kai kama roeroe ni Isarel catounnaw thung hoi ka lae lah ao teh, Levihnaw teh kaie lah ao awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Bangkongtetpawiteh, caminnaw pueng teh kaie lah ao han. Izip ram vah caminnaw pueng ka thei navah, Isarelnaw pueng teh camin hoi tami hoi moithang hoi kai kama hanelah ka thoung sak e lah ao. Kai teh Jehovah doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","BAWIPA ni Sinai kahrawngum vah, Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Levih catounnaw hah a na pa imthung lahoi tongpa pueng thapa yung touh lathueng pueng teh koung na touk han atipouh. ");
INSERT INTO cth_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Hot patetlah Mosi koe kâ a poe e BAWIPA lawk patetlah koung a touk pouh. ");
INSERT INTO cth_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levih catounnaw e min teh Gershon, Kohath, hoi Merari naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershon catoun imthungnaw e teh, Libni hoi Shimei doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath catoun imthungnaw e teh Amram, Izhar, Hebron hoi Uziel doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari catoun imthungnaw teh, Mahli hoi Mushi doeh. Hetnaw heh a na pa imthung lahoi Levih catounnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershon teh Libni imthung hoi Shimei imthung kakhekung doeh. Hetnaw heh Gershom catounnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Thapa yung touh hoi lathueng tongpa pueng a touk awh e teh 7500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gershon catoun imthungnaw teh lukkareiim a hnuklah kanîloumlah a roe awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershonnaw e imthung kahrawikung teh Lael capa Eliasaph han. ");
INSERT INTO cth_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gershon catounnaw thaw teh, lukkareiim lemphu ramuk nahane hoi kamkhuengnae takhang dawk hane yaphni hoi, ");
INSERT INTO cth_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","thongma takhang dawk hane yaphni hoi khoungroe petkâkalup e hnonaw hoi, hawvah hnonaw pueng a tawk awh hanelah ao han. ");
INSERT INTO cth_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohath teh Amram imthung, Izhar imthung, Hebron imthung hoi Uziel imthungnaw kakhekung doeh. Hetnaw heh Kohath catounnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Tongpa pueng thapa yung touh hoi lathueng hmuen kathoung ringnae koe tawk hanelah a poe e naw a touk awh navah 8600 a pha. ");
INSERT INTO cth_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohath catoun imthungnaw teh lukkareiim akalah a roe awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohath catoun imthung kahrawikung teh Uziel capa Elizaphan han. ");
INSERT INTO cth_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ahnimae thaw teh, thingkong hoi caboi hoi satui hmaiimkhok hoi, thuengnae hoi, hmuen kathoung koe thaw tawk nahane, hlaamnaw, lukkarei yap e hoi haw e thaw tawknae koe e hnopainaw pueng lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hahoi vaihma Aron capa Eleazar teh Levihnaw kahrawikung a lû lah ao han. Hmuen kathoung karingkungnaw hah a hrawi han. ");
INSERT INTO cth_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari teh Mahlinaw thung hoi Mushinaw imthung kakhekung lah ao. Hetnaw teh Merari imthungnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Tongpanaw pueng thapa yung touh lathueng a touk awh navah 6200 a pha. ");
INSERT INTO cth_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari catounnaw e imthung kahrawikung teh Abihail capa Zuriel doeh. Hetnaw teh lukkareiim atunglah a roe awh han. ");
INSERT INTO cth_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Merari capa hoi a tawk han kawi lah pouk e teh lukkareiim tapang, pangkhek, khom, a tâphai kepnae, a hnopainaw hoi a thaw tawknae hnopai lah ao awh. ");
INSERT INTO cth_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Thongma petkâkalup lah khonaw teh, a kangdue nahane cemnaw pueng hoi a hetsinnae ruinaw hai a sak han. ");
INSERT INTO cth_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Hothloilah lukkareiim kanîtholah kamkhuengnae lukkareiim hmalah ka roe e naw teh Mosi, Aron hoi a canaw han. Hmuen kathoung ringnae koe teh Isarel catounnaw a pankinae pueng koe a tawk awh han. Hatei alouke tami rek kahnai e awm pawiteh, thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","BAWIPA kâpoe e lahoi Levihnaw e a catoun tongpanaw thapa yung touh lathueng hoi Aron ni touk e naw teh 22, 000a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","BAWIPA ni Mosi koevah, Isarel catounnaw thung dawk camin tongpa thapa yung touh lathueng pueng nâyittouh maw ka phat tie a min lahoi koung touk loe. ");
INSERT INTO cth_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Hahoi Levihnaw hah Isarel catoun thung dawk hoi caminnaw yueng lah kai hanelah na la vaiteh, Levihnaw e saring hai, Isarel catounnaw e saring camin pueng e yueng lah kai hanlah na la han. Kai teh Jehovah doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mosi teh BAWIPA ni kâ a poe e patetlah Isarel catoun thung dawk caminnaw pueng hah a touk awh ");
INSERT INTO cth_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","A min phung e lahoi thapa yung touh lathueng tongpa camin pueng a touk awh e teh 22, 273 a pha. ");
INSERT INTO cth_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Isarel catoun camin yueng lah Levihnaw hah lat nateh, a saring yueng lah, Levihnaw e saring lat pouh. Levihnaw teh kaie lah ao awh han. Kai teh Jehovah doeh. ");
INSERT INTO cth_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Levihnaw hlak vah, bet kapap e Isarel catoun camin 273 ratang nahanelah, ");
INSERT INTO cth_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tami buet touh hane hmuen kathoung khingnae tangka patetlah shekel panga touh rip na la awh han. Hmuen kathoung khingnae shekel teh gerah 20 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Ka cawi e ratang nahan hnopai teh Aron hoi a capanaw na poe han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Hahoi Mosi ni Levihnaw ni a ratang awh hoeh e ratangnae hnopai hah a la. ");
INSERT INTO cth_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Isarel catoun caminnaw koehoi hnopainaw a la teh hmuen kathoung shekel 1365 a la pouh. ");
INSERT INTO cth_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","BAWIPA ni Mosi kâ a poe e BAWIPA lawk patetlah Mosi ni a ratangnae hnopai teh Aron hoi a capanaw a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","BAWIPA ni Mosi hoi Aron a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Levihnaw thung dawk Kohath capanaw a catoun lahoi a imthung lahoi, ");
INSERT INTO cth_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kum 30 lathueng kum 50 totouh kamkhuengnae lukkareiim dawk thaw ka tawk hane naw teh koung a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Hete kamkhuengnae lukkareiim dawk kathoungpounge hno hoi kâkuen lah Kohath casaknaw e thaw lah ao. ");
INSERT INTO cth_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Roenae koehoi a kampuen awh tangkuem vah, Aron hoi a capa a tho vaiteh, hmuen kathoung lukkareiim yap e hah a la vaiteh lawkpanuesaknae thingkong hah a ramuk han. ");
INSERT INTO cth_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Hahoi phaivuen hoi a ramuk vaiteh, kamthim hni hoi bout a ramuk han. Hahoi a tâphai hah a hrawt han. ");
INSERT INTO cth_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Caboi dawk kamthim hni a phai vaiteh, tongben, pacen, awi nahane kawlungnaw hoi, vaiyei hruek vaiteh. ");
INSERT INTO cth_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hot teh hni paling a ramuk awh vaiteh, saram pho hoi a ramuk vaiteh, a tâphai a hrawt awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Hmaiimkhok hoi hawvah hno hane hmaiim, paitei hoi paitei tanae manang, satuiumnaw hah kamthim hni hoi a ramuk han. ");
INSERT INTO cth_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Hote hno hoi a puengcangnaw teh saram pho hoi ramuk vaiteh kâkayawtnae dawk a tâ han. ");
INSERT INTO cth_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Sui khoungroe hah kamthim hni hoi ramuk vaiteh, saram pho hoi a ramuk han. Hahoi a tâphai na hrawt han. ");
INSERT INTO cth_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Hmuen kathoung koe thaw tawknae hnonaw pueng hah, koung a la vaiteh, kamthim hni hoi a taoung awh han. Saram pho hoi a ramuk awh han, kâkayawtnae a hrawt awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Khoungroe dawk e hraba hah kathoungcalah kawn vaiteh, avan vah hni paling a phai awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Avan vah thaw a tawknae hlaamnaw pueng, hmaisawinae, cingco, tawkso ka kaw e, maroi, hoi thuengnae khoungroe dawk a ta awh han. Saram pho hoi a ramuk awh vaiteh, a tâphai kâkayawtnae a hrawt awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Hahoi Aron hoi a capanaw ni, a hmuen kathoung poung hoi hmuen kathoung hnopainaw koung a ramuk awh vaiteh, a onae hmuen a kampuen awh nah karawitawi Kohath capa ni kâkayawt hanelah a tho awh han. Hatei kathounge hno hah tek awh mahoeh. Tek awh boipawiteh, a due awh han. Hetnaw heh kamkhuengnae lukkareiim hno, Kohath capanaw ni a tawk awh hane doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Hahoi vaihma Aron capa Eleazar capa a tawk hane kawi teh, paang hane satui hoi hmuitui pout laipalah, tavai poenae, awi e satui hoi lukkareiim thung kaawm e hnonaw pueng, hmuen kathoung hoi hnopainaw ring hanelah ao telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","BAWIPA ni Mosi hoi Aron a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Kohath catoun imthungnaw hah Levihnaw thung dawk hoi kahmat sak hanh. ");
INSERT INTO cth_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Hatei kathoungpounge hno hah ouk a hnai toteh, dout laipalah a hring awh nahan, hot hoi kâkuen lah het heh sak loe. Aron hoi a capa hah a kâen vaiteh, a tawk awh hane thaw hah amamouh lengkaleng pouk pouh naseh. ");
INSERT INTO cth_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Hatei, kathoungpounge hno khet hanlah dongdeng hai kâen hanh awh. Hoehpawiteh a due awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Gershon capanaw hoi a imthungkhu a catounnaw abuemlah koung a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","kum 30 hoi a lathueng a lathueng kum 50 totouh, kamkhuengnae lukkareiim koe thaw ka tawk hane naw hah koung a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gershon catounnaw a tawk awh hanelah a kamngai awh e teh, ");
INSERT INTO cth_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Lukkareiim dawk lukkarei yap e, kamkhuengnae lukkareiim takhang koe hni yap e hah, ");
INSERT INTO cth_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Kalupnae hni yap e, kalupnae longkha koe yap e, bawknae rim thuengnae khoungroe teng kaawm e, arui hoi a hnopainaw pueng a phu awh vaiteh, tawksak a ngai e pueng a tawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gershon capanaw a tawk awh nah tangkuem koe Aron hoi a capanaw ni thaw a poe awh e patetlah a tawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hetheh, kamkhuengnae lukkareiim Gershon capa imthungnaw e thaw a tho. Ahnimae thaw hah, vaihma Aron capa Ithamar kâtawnae rahim ao awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Merari capanaw kong dawk a catounnaw abuemlahoi imthungkhu lahoi koung na touk a han. ");
INSERT INTO cth_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kum 30 hoi a lathueng lah kum 50 totouh kamkhuengnae lukkareiim dawk thaw a tawk awh hanelah ka kâen hane pueng na touk awh han. ");
INSERT INTO cth_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Kamkhuengnae lukkareiim dawk, ka ceitakhai han naw e thaw teh, hethah doeh. Bawknae im tapang, thing a tâphai hai, a khom, a kanâ, ");
INSERT INTO cth_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","thongma tumdumnae khom, a kanâ, cem, hoi ruinaw, hote hnopainaw pueng hoi alouke hnonaw kâkayawt hanelah, a min lahoi amamae ham na pouk pouh han. ");
INSERT INTO cth_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hetheh vaihma Aron capa Ithamar kâtawnnae rahim vah, kamkhuengnae lukkareiim hanelah Merari capa imthungnaw niyah a sak awh hane thaw la doeh ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Hahoi Mosi hoi Aron hoi tamimaya kahrawikungnaw ni Kohath capa a catoun abuemlahoi imthung abuemlahoi, ");
INSERT INTO cth_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","kamkhuengnae lukkareiim dawk a tawk awh hane hah kum 30 touh hoi a lathueng lah kum 50 totouh a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","A catoun abuemlahoi a touk awh e teh, 2, 750 a pha. ");
INSERT INTO cth_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hotnaw teh kamkhuengnae lukkareiim dawk thaw ka tawk thai e Kohath casaknaw a touk awh e Mosi hno lahoi BAWIPA kâpoe e patetlah Mosi hoi Aron ni a touk roi e doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershon capanaw kamkhuengnae lukkareiim tawk ka tawk hane teh, a na pa im hoi imthung abuemlahoi doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Kum 30 touh hoi a lathueng kum 50 totouh touk e lah ao. ");
INSERT INTO cth_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","A imthung abuemlahoi a napanaw imthung abuemlah a touk awh e teh 2, 630 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hetnaw teh Gershon capanaw e casaknaw kamkhuengnae lukkareiim thaw katawknaw lah BAWIPA kâpoe e patetlah Mosi hoi Aron ni a touk e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Hahoi Merari capa ni kamkhuengnae lukkareiim dawk thaw ka tawk hane teh a napanaw imthung hoi amamouh imthungnaw seng doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Kum 30 hoi a lathueng kum 50 totouh touk e lah ao. ");
INSERT INTO cth_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","A na pa hoi imthung abuemlah a touk awh e teh, 3, 200 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hetnaw heh Merari capanaw a touk awh e teh Mosi hno lahoi BAWIPA kâpoe e patetlah Mosi hoi Aron ni a touk roi e doeh. ");
INSERT INTO cth_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Levihnaw thaw tawk hanelah kamkhuengnae lukkareiim phu hanelah, hoi ouk ka phawt e a napanaw imthung lahoi a imthungkhu abuemlahoi ");
INSERT INTO cth_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","kum 30 lathueng kum 50 totouh Mosi hoi Aron Isarel kahrawikungnaw ni a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","A touk awh e naw teh, 8, 580 touh a pha ");
INSERT INTO cth_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mosi hno lahoi BAWIPA kâpoe e patetlah tami pueng ni a tawk awh hane teh, a ham awh e hoi ka kâvan lah a touksin awh. BAWIPA ni Mosi kâ a poe e patetlah a touk awh. ");
INSERT INTO cth_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Isarel catounnaw ka hrikbeinaw hoi moihnakathout hoi tami ro kâbet e hoi kakhin e napui tongpa naw hah roenae rim hloilah tâco sak hanelah kâ a poe. ");
INSERT INTO cth_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","A lungui vah, ka onae roenae hmuen hah a khin sak awh hoeh nahanelah, napui tongpa roenae hmuen lawilah na tâco sak han. ");
INSERT INTO cth_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Isarel catounnaw ni hot patetlah a sak awh teh, roenae hmuen alawilah ouk a tâco sak awh. BAWIPA ni Mosi koe a dei e patetlah Isarel catounnaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Isarel catounnaw koe dei pouh loe. Tongpa thoseh, napui thoseh, BAWIPA taranlahoi yon bang patet e a sak awh teh yon pen e lah ao toteh, ");
INSERT INTO cth_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","a sak awh e yonnae hah pankângai hoi a kâhei awh han. Hahoi a sakpayon e yonnae phu teh ka kuepcalah a patho han. Hahoi a tak dawk hawihoehnae a sak e hah pung panga touh dawk pueng touh a thap han. ");
INSERT INTO cth_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Hatei, yon phu kacoekung ni a hmaunawngha tawn hoehpawiteh, BAWIPA koe thueng e yon phu teh vaihma koe a poe han. Yontha nahanlah tutan a thueng e touksin laipalah yonthanae alouke a sak han. ");
INSERT INTO cth_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Hahoi Isarel catounnaw ni a poe awh e pueng Isarelnaw hno kathoung pueng vaihma koe a thokhai e pueng teh amae lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Tami tangkuem ni a poe awh e hno kathoung poung hah a ahnimae lah ao han. Tami pueng ni vaihma koe a poe awh e teh ahnimae lah ao han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Isarel catounnaw koe dei pouh loe. Ahnimouh koe, apipatet e a yu nakunghai, a vâ koe yuemkamcu lah awm laipalah alouke a ngai e awm pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","a payon lahun nah ayâ ni hmawt hoeh, kapanuekkhaikung awm hoeh eiteh, hote hah a pâpha teh, a vâ ni panue hoeh nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ahni lathueng dipmanae muitha a pha hai thoseh, a yu a dipma nakunghai thoseh, hahoi napui a kamhnawng teh dipmanae muitha tongpa koe a tho hai thoseh, a yu hah a dipma ei, a yu kamhnawng hoeh pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","tongpa ni a yu hah vaihma koe a thokhai han, napui hanlah a panki e poehno catun ephah pung hra pung touh dawk buet touh, satui awi mahoeh, hmuitui hai kalawt mahoeh. Bangkongtetpawiteh, hethateh dipmanae canei thuengnae, pahnim hoeh nahan canei thuengnae, payonnae panue nahanelah pahnim hoeh nahane doeh. ");
INSERT INTO cth_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Vaihma ni napui hah a thokhai vaiteh, BAWIPA hmalah a kangdue sak han. ");
INSERT INTO cth_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Vaihma ni talai hlaam dawk hoi tui kathoung a la vaiteh, lukkareiim khom koe e vaiphu a la vaiteh tui dawk a phuen han. ");
INSERT INTO cth_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Vaihma ni napui hah BAWIPA hmalah a kangdue sak vaiteh, a sam a rathap sak han. Yu dipmanae tavai thuengnae kâhruetcuet poe nahanelah thuengnae hah a kut dawk a sin sak han. Hahoi vaihma ni thoebonae tui kakhat e hah a sin han. ");
INSERT INTO cth_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Vaihma ni napui hah lawk a kam sak vaiteh, napui koe na vâ e kâtawnnae dawk na 0 navah, ayâ ni na ipkhai hoehpawiteh, na kamhnawngnae lam dawk na dawn hoeh boum teh hete thoebonae kaphawtkung kakhat e tui dawk hoi na hlout han. ");
INSERT INTO cth_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Hatei, na vâ e kâtawnnae dawk na o navah, nama na kamhnawng teh ayâ ni na ipkhai boipawiteh telah na ti vaiteh, ");
INSERT INTO cth_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","vaihma ni napui hah thoebonae lawkkam rahim vah ao sak vaiteh, napui koe BAWIPA ni na phai a kamsoe sak teh na von a phing sak toteh, BAWIPA ni na miphunnaw thung dawk thoebonae kaphawtkung lah na awm naseh. ");
INSERT INTO cth_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Hahoi, thoebonae kaphawtkung hete tui ni na ruen dawk a kâen vaiteh, na von a phing sak vaiteh, na phai a kamsoe sak han, telah ati han. Hahoi napui ni teh, Amen, hot patetlah thoseh ati han. ");
INSERT INTO cth_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Vaihma ni thoebonae lawk hah cauk dawk a thut vaiteh, kakhat e tui dawk a phum han. ");
INSERT INTO cth_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Hahoi thoebonae kaphawtkung kakhat e tui hah, napui hah a pânei han. Hot patetlah thoebonae kaphawtkung a von thung a kâen vaiteh a kha han. ");
INSERT INTO cth_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Hot patetlah vaihma ni dipmanae canei thuengnae a kahek vaiteh, a poe e napui e kut dawk hoi a la vaiteh, BAWIPA hmalah tavai thuengnae a sin pouh vaiteh, thuengnae khoungroe koe a ceikhai han. ");
INSERT INTO cth_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Vaihma ni panuenae tavai thuengnae hah kutvang touh a la vaiteh, khoungroe dawk a sawi han. Hathnukkhu, kakhat e tui hah napui a pânei han. ");
INSERT INTO cth_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Tui a nei sak toteh, hettelah han doeh. A la kamhnawng teh a vâ koe yonnae sak boipawiteh, thoebonae kaphawtkung lah ao dawk kakhat e tui teh a von thung a kâen vaiteh a kha han. A von a phing vaiteh, a phai hah a kamsoe han. Hahoi teh, hote napui teh a miphunnaw thung dawkvah, thoebo e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Hatei, napui teh kamhnawng hoeh lah thoung boipawiteh, a hlout vaiteh, camo ka vawn thai e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Hete napui ni a vâ e kâtawnnae rahim ao navah, kho louk lah radoung hoi a vâ hoeh e tami alouke hoi koe ka kamhnawng e thoseh, ");
INSERT INTO cth_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","tongpa ni dipmanae lungthin ueue tawn pawiteh, a yu a dipma dawkvah, dipmanae kâlawk lah ao han. Hahoi teh napui hah BAWIPA hmalah a ceikhai vaiteh, vaihma ni hete kâlawknaw pueng a tak dawk a sak pouh han. ");
INSERT INTO cth_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Hottelah, tongpa teh payonpakainae koehoi a hlout han. Hatei, hete napui ni yonpennae naw heh a khang han, atipouh. ");
INSERT INTO cth_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Isarel catounnaw koe dei pouh. Ahnimouh koe tongpa thoseh, napui thoseh BAWIPA koe ama Nazirite lawkkamnae la hanlah, a kâkapek teh a kâhmoun toteh, ");
INSERT INTO cth_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","misur hoi yamu tek mahoeh. Misurtui hoi yamucang hai net mahoeh. Misurtui nei e hoi misurpaw katha e khumbei dawk vaw teh kamyai e hai cat mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","A kâkapek nah yunglam pueng teh misurkung dawk hoi a mu thoseh, atui thoseh cat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","A kâkapeknae lawk a kam nah thung pueng teh, a lû ngaw mahoeh. BAWIPA hmalah a kâpeknae hnin a pha hoehroukrak teh kathounge lah ao han. Hottelah a sam a hlung vaiteh, a sai sak han. ");
INSERT INTO cth_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","BAWIPA hanlah a kâkapeknae thung pueng teh, tami ro koe hnai mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","A na pa thoseh, a manu thoseh, a hmaunawngha thoseh, a tawncanu thoseh, a duenae kong dawk hai kâkhinsak hanh naseh. Bangkongtetpawiteh, Cathut hanlah a kâkapeknae a lû dawk ao. ");
INSERT INTO cth_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","A kâkapek yunglam teh BAWIPA hanlah kathounge lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ateng vah, pouk laipalah tami koe dout pawiteh, a kâkapeknae a lû dawk khin sak pawiteh, a kamthoung nah hnin vah, a lû a ngaw vaiteh, a hnin sari hnin vah a pâkhamuen a ngaw han. ");
INSERT INTO cth_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","A hnin taroe hnin vah, kamkhuengnae lukkareiim takhang koe e vaihma koe bakhu kahni touh thoseh, Âbakhu kahni touh thoseh a sin awh han. ");
INSERT INTO cth_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Vaihma ni buet touh teh yon thueng nahanlah a poe vaiteh, alouke buet touh teh hmaisawi thueng nahan, tami kadout kecu dawk a sakpayon e dawk a yontha nahanlah a sak pouh han. Hot hnin vah a lû hah a thoung sak han. ");
INSERT INTO cth_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Hahoi kâtapoe thuengnae dawkvah kum touh ka pha e tuca a tan a thokhai vaiteh, kâkapeknae hnin teh BAWIPA koe vah a katha lah a tâcokhai han. Bangkongtetpawiteh, kâkapeknae hah a khin sak toung dawkvah, ahmaloe e teh banglah tho mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Hahoi Nazirite a kâkapeknae hnin a kuep toteh, a sak awh hane kâlawk doeh. Kamkhuengnae lukkareiim takhang koe na ceikhai awh han. ");
INSERT INTO cth_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Hahoi BAWIPA koe thuengnae hah a poe han. Tutan kacueme hmaisawi thuengnae koe buet touh, yon thueng nahanelah tulaca kacueme buet touh, roum thueng nahanelah, kacueme tutanca buet touh, ");
INSERT INTO cth_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","tonphuenhoehe tavai hah a kanui e tavai satui hoi kanawk e tavai tueng buet touh satui hluk e tavai ka rapamca e a tabu buet touh, tavai thuengnae hoi lannae thueng hoi na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Hahoi vaihma ni tavai hah BAWIPA hmalah a thokhai vaiteh, yon thuengnae hoi hmaisawi thuengnae hah a poe han. ");
INSERT INTO cth_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Hahoi tutan hah tonphuenhoehe tavai tabu dawk hoi roum thuengnae hah Bawipa koe a poe han. Vaihma ni tavai thuengnae, nei thuengnae hoi a poe sin han. ");
INSERT INTO cth_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Nazirite tami ni, kamkhuengnae lukkareiim takhang koe a sam hah a ngaw vaiteh, roum thuengnae a saknae koe hmai hoi a sawi han. ");
INSERT INTO cth_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Hahoi vaihma ni tutan e a loung a thawng e hoi tonphuenhoehe a tabu dawk a ta e vaiyei buet touh, tonphuenhoehe vaiyei ka rapam e phen buet touh, a la vaiteh, Nazirite niyah a kâhmounnae a sam koung a ngaw hnukkhu hoi a kut dawk a ta han. ");
INSERT INTO cth_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Hahoi vaihma ni kahek thuengnae dawkvah, BAWIPA hmalah a kahek han. Hetheh vaihma hmang lah kaawm han. Hetheh vaihma e ham lah kaawm han. Kahek e a takuep hoi a kahek e a phai teh a thoung han, hahoi teh Nazirite tami ni misur a nei thai han toe, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hetheh Nazirite lawkkam a kâhmounnae hoi poehno e BAWIPA koe lawkkamnae kasakkung e kâlawk lah ao. Hothloilah a ma kut hoi ka dam sak e pueng hah lawkkamnae a sak e patetlah a kâhmounnae kâlawk patetlah a sak roeroe han. ; ");
INSERT INTO cth_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Aron hoi a capanaw koevah, het patetlah Isarel catounnaw yawhawi na poe han, ahnimouh koe, ");
INSERT INTO cth_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","BAWIPA ni yawhawi na poe awh teh, na khenyawn awh naseh. ");
INSERT INTO cth_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","BAWIPA ni a minhmai nangmouh koe kho lah a sei vaiteh, na pahren awh naseh. ");
INSERT INTO cth_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","BAWIPA teh nangmouh koelah kangvawi seh, roumnae na poe awh han, telah dei pouh awh telah a dei. ");
INSERT INTO cth_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Hot patetlah sak e ni Isarel catounnaw koe ka min a kamnue sak awh han. Kai ni ahnimouh teh yawhawi ka poe han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Hahoi teh, hettelah doeh. Mosi ni lukkareiim a sak teh, a cum toteh, a hnopainaw hoi a khoungroe hoi hlaam naw pueng hah satui a hluk teh a thoung sak. ");
INSERT INTO cth_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Hahoi Isarel kahrawikung, a imthung kahrawikung, a miphun kahrawikungnaw a touk awh e ni poehno hane hah a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","A poe awh e naw hah BAWIPA hmalah a thokhai awh vaiteh, a lemphu kaawm e leng taruk touh, maitotan hlaikahni touh, kahrawikung kahni touh ni leng buet touh lengkaleng, buet touh ni maitotan buet touh lengkaleng lukkareiim hmalah a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","kamkhuengnae lukkareiim dawk thaw tawk navah a cungkei han dawkvah, ahnimouh koehoi dâw pouh. Levihnaw koe a thaw tawknae hoi kâkuen lah na poe han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hahoi Mosi ni leng hoi maitotan a la teh, Levihnaw hah a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Leng kahni touh hoi maitotan pali touh hah Gershon capa hah a thaw hoi kamcu lah a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Leng pali touh hoi maitotan taroe touh hah vaihma Aron capa Ithamar, Merari capa hah a thaw hoi kamcu lah a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Hatei, Kohath capa teh poe awh hoeh. Bangkongtetpawiteh, hmuen kathoung koe e thaw a ham e lah ao teh, aloung hoi kâkayawnkung lah ao. ");
INSERT INTO cth_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Thuengnae khoungroe hah satui awi hanlah ao toteh, kahrawikungnaw ni lungtho lahoi a poe awh e heh khoungroe dawk a ta awh. Hot patetlah pasoumhno a poe han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Bangkongtetpawiteh, BAWIPA ni Mosi koevah thuengnae khoungroe dawk poe hanelah, hnin touh dawk kahrawikung buet touh ni pasoumhno hah a poe han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Apasuek hnin vah, pasoumhno ka poe e teh, Judah miphun dawk hoi Amminadab capa Nahshon ni a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","hmaisawi thueng nahane maitotanca buet touh, tu buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","yon thueng nahane maitotan kahni touh, ");
INSERT INTO cth_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","roum thueng nahanelah maitotan kahni, tu panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Amminadab capa Nahshon ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Apâhni hnin vah, pasoumhno ka poe e teh, Issakhar kahrawikung Zuar capa Nethanel ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","hmaisawi thueng nahane maitotanca buet touh, tu buet touh, tutanca kum touh ka phat e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh ka phat e panga touh. Hetnaw heh Zuar capa Nethanel ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Apâthum hnin vah, pasoumhno ka poe e teh, Zebulun catounnaw kahrawikung Helon capa Eliab ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Helon capa Eliab ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Apali hnin vah, pasoumhno ka poe e teh, Reuben catounnaw kahrawikung Shedeur capa Elizur ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Shedeur capa Elizur ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Apanga hnin vah, pasoumhno ka poe e teh, Simeon catounnaw kahrawikung Zurishaddai capa Shelumiel ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Zurishaddai capa Shelumiel ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ataruk hnin vah, pasoumhno ka poe e teh, Gad catounnaw kahrawikung Deuel capa Eliasaph ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Deuel capa Eliasaph ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Asari hnin vah, pasoumhno ka poe e teh, Ephraim catounnaw kahrawikung Ammihud capa Elishama ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Ammihud capa Elishama ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ataroe hnin vah, pasoumhno ka poe e teh, Manasseh catounnaw kahrawikung Pedahzur capa Gamaliel ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Pedahzur capa Gamaliel ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Atako hnin vah, pasoumhno ka poe e teh, Benjamin catounnaw kahrawikung Gideon capa Abidan ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Gideon capa Abidan ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","A hnin hra navah, pasoumhno ka poe e teh, Dan catounnaw kahrawikung Ammishaddai capa Ahiezer ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Ammishaddai capa Ahiezer ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","A hlaibun hnin vah, pasoumhno ka poe e teh, Asher catounnaw kahrawikung Okran capa Pagiel ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Okran capa Pagiel ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","A hlaikahni hnin vah, pasoumhno ka poe e teh, Naphtali catounnaw kahrawikung Enan capa Ahira ni pasoumhno a poe. ");
INSERT INTO cth_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","A poe e teh shekel 130 ka ri e ngun hlaam buet touh, hmuen kathoung shekel 70 touh ka ri e ngun kawlung buet touh, tavai thuengnae hanlah vaiui satui hoi kanawk tangcoung e hote roi dawk ka kawi lah, ");
INSERT INTO cth_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","shekel hra touh ka ri e hmuitui hoi ka kawi e suipacen buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","hmaisawi thueng nahane maitotanca buet touh, tutan buet touh, tutanca kum touh e buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","yon thueng nahane hmaetan buet touh, ");
INSERT INTO cth_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","roum thueng nahanelah maitotan kahni, tutan panga, hmaetan panga, tutanca kum touh e panga touh. Hetnaw heh Gideon capa Abidan ni a pasoung e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Hot patetlah thuengnae khoungroe satui awi nah hnin vah, Isarel kahrawikungnaw ni a pasoung awh e ngun hlaam hlaikahni touh, ngun kawlung hlaikahni touh, suipacen hlaikahni touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ngun hlaam teh shekel 130 touh a ri teh, ngun kawlung teh shekel 70 touh a ri. Ngun hlaamnaw pueng teh hmuen kathoung khingnae shekel 20,400 touh a ri. ");
INSERT INTO cth_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hmuitui suipacen 12 touh dawk ka kawi e teh, hmuen kathoung shekel 10 tabang hane a ri. Suipacen pueng teh shekel 120 touh a ri. ");
INSERT INTO cth_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Hmaisawi thueng nahan maitotanca abuemlah 12, tutan 12, tutanca kum touh e 12, tavai thueng nahanlah a pasoung awh e pueng hoi yon thueng nahanelah hmaetan 12, ");
INSERT INTO cth_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","tutan 60, hmaetan 60, tutanca kum touh e 60 touh a pha. Hetnaw heh satui awi hnukkhu thuengnae khoungroe dawk thueng nahanlah a poe awh e doeh. ");
INSERT INTO cth_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Hot patetlah, kamkhuengnae lukkareiim dawk bawk hanelah, Mosi a kâen navah, lawkpanuesaknae thingkong dawk lungmanae tungkhung a lathueng lavah, cherubim kahni touh e rahak hoiyah, ama hoi lawk kâthai lah a kâpato roi. ");
INSERT INTO cth_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Aron hah pato nateh ahni koe, hmaiim hah na paang toteh, hmaiim sari touh ni hmaiimkhok hmalah a ang awh han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","A dei e patetlah Aron ni a sak. BAWIPA ni Mosi kâ a poe e patetlah hmaiimkhok a hmalah a ang hanlah hmaiim teh a paang. ");
INSERT INTO cth_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hete hmaiimkhok teh sui hoi mek dêi sin e doeh. BAWIPA ni Mosi koe a meilam a kamnue sak e patetlah a sak pouh. ");
INSERT INTO cth_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Levihnaw hah Isarelnaw thung dawk hoi aloukcalah hmoun nateh, kamthoung sak. ");
INSERT INTO cth_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ahnimouh a kamthoung nahanelah, hettelah na sak han. Ahnimouh tak dawk thoungnae tui hah kaheisin nateh, a takbuem muen koung ngaw naseh, a khohna pâsu awh vaiteh, kamthoung naseh. ");
INSERT INTO cth_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Maitotanca buet touh hoi, tavai thuengnae a kanui e satui hoi kalawt e lat sak loe. Yon thuengnae maitotanca buet touh na ceikhai han. ");
INSERT INTO cth_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Levihnaw hah kamkhuengnae lukkareiim koe a ceikhai vaiteh, Isarel catoun tamimaya teh cungtalah pâkhueng. ");
INSERT INTO cth_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Hahoi teh, Levihnaw hah BAWIPA hmalah na thokhai awh han. Isarel catounnaw ni Levihnaw lathueng a kut a toung pouh vaiteh, ");
INSERT INTO cth_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aron ni Levihnaw hah BAWIPA thaw a tawk awh thai nahan, Isarel catounnaw koe kahek thuengnae BAWIPA hmalah a poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Levihnaw ni maitotanca e a lû dawk a kut a toung awh vaiteh, Levihnaw han yontha nahanlah BAWIPA Cathut hmalah maito buet touh, hmaisawi thueng nahanlah buet touh na sak han. ");
INSERT INTO cth_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Levihnaw hah Aron hoi a canaw hmalah a kangdue vaiteh, BAWIPA koe kahek thuengnae patetlah na sak han. ");
INSERT INTO cth_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Hot patetlah, Isarel catoun thung hoi Levihnaw hah na hmoun vaiteh, Levihnaw teh kai ka ham lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Hathnukkhu hoi teh, Levihnaw ni kamkhuengnae lukkareiim koe a kâen awh han. Nang ni ahnimanaw thoung sak hanlah, kahek thuengnae patetlah na sak pouh han. ");
INSERT INTO cth_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Bangkongtetpawiteh, Isarel miphun thung dawk hoi ahnimanaw hah na rawi vaiteh, kai koe koung na poe han. Isarel miphunnaw ni hmaloe a khe awh e camin yueng lah ka la toe. ");
INSERT INTO cth_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Izipnaw e caminnaw kai ni ka thei navah, Isarel miphun dawk teh tami thoseh, saring thoseh, caminnaw pueng hah kai kama hanlah ka thoung sak dawkvah, caminnaw pueng teh kai ka ham doeh. ");
INSERT INTO cth_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Hahoi Isarel catounnaw dawk camin hanlah Levihnaw teh kai ni ka la toe. ");
INSERT INTO cth_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Ahnimanaw ni kamkhuengnae lukkareiim koevah, Isarelnaw ni a tawk awh hane thaw a tawk awh thai nahan thoseh, Isarel miphunnaw ni kathoungpounge hmuen koe a cei awh toteh, Lacik dawk hoi a hlout awh thai nahan, yontha sak nahan hai thoseh, Isarel miphun thung hoi Levihnaw teh Aron hoi a canaw hah ka poe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Levihnaw hanlah BAWIPA Cathut ni Mosi koe a dei e patetlah Mosi hoi Aron koehoi Isarel miphunnaw abuemlah hanelah Levihnaw ni a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Ahnimanaw ni thoungnae a hmu awh teh, amamae khohna a pâsu awh. Aron ni hai BAWIPA hmalah kahek thuengnae BAWIPA koe yonthanae ahnimouh han a sak teh a thoung awh. ");
INSERT INTO cth_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Hahoi teh, Levihnaw hmalah Aron hoi a canaw hmalah a thaw tawk hanlah kamkhuengnae lukkareiim thung a kâen. Levihnaw kong dawk BAWIPA ni Mosi kâ a poe e patetlah ahnimouh koe a sak pouh. ");
INSERT INTO cth_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Hetheh Levihnaw a coungnae doeh. Kum 25 touh lathueng ni kamkhuengnae lukkareiim dawk thaw a tawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kum 50 ka phat e ni thaw a kâhat han, tawk awh mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hatei, kamkhuengnae lukkareiim khetyawtnae dawkvah, a hmaunawnghanaw a kabawp han. Thaw teh tawk mahoeh. Het patetlah Levihnaw a thaw kong dawk, laideitâtueng pouh loe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Izip ram hoi a tâco hoi a kum pahni, thapa yung pasuek navah, BAWIPA ni Sinai ram kahrawngum vah, Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Isarel catounnaw ni ceitakhai pawi hah ama tueng dawk a sak awh naseh. ");
INSERT INTO cth_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Atueng teh atu e thapa hnin hrahlaipali tangmin lah na sak awh han. Ama e phunglam patetlah na hno awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Hahoi teh, Mosi ni Isarelnaw hah ceitakhai pawi hno hanlah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Sinai kahrawngum vah thapa ayung pasuek hnin hrahlaipali tangmin lah ceitakhai pawi a sak awh. BAWIPA ni Mosi koe kâlawk a poe e patetlah Isarelnaw ni a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Hahoi tami bangpatet ni tami ro kecu dawk kathoung hoeh lah awm pawiteh, hot hnin vah ceitakhai pawi dawk bawk thai hoeh. Hot hnin vah Mosi hoi Aron hmalah a cei teh, ");
INSERT INTO cth_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ahnimouh ni ama koe tami ro kecu dawk kathoung hoeh toe. Bangkongmaw Isarelnaw koevah, ama tue vah, BAWIPA koe thuengnae dawk na bawk sak hoeh telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mosi ni duem awm awh ei, nangmouh kong dawk BAWIPA ni bangtelamaw kâ na poe tie hah ka ring ei vai telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Isarel catounnaw koehoi nangmouh thung hoi thoseh, na catounnaw thung hoi thoseh, tami ro kecu dawk kathounghoehnaw thoseh, lamhla vah kahlawng kacetnaw thoseh, na awm payon pawiteh, BAWIPA hanlah ceitakhai pawi hah a hno thai awh. ");
INSERT INTO cth_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Thapa yung pahni hnin hrahlaipali hnin tangmin lah a hno thai awh han. Tonphuenhoehe vaiyei hah kakhat e a hna hoi a ca awh han. ");
INSERT INTO cth_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Tangtho hanlah bangcahai na tat awh mahoeh. A hru na khoe mahoeh. Ceitakhai pawi saknae lah a pouk e naw pueng a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Hahoi, a thoung ngoun ei, kahlawng hai cet hoeh ei, ceitakhai pawi dawk bawk hoehpawiteh, a miphun koehoi takhoe e lah ao han. Bangkongtetpawiteh, ama tueng dawkvah, BAWIPA koe thuengnae a sak hoeh dawkvah, ama koe yon a kamtue han. ");
INSERT INTO cth_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Hahoi, nangmouh koe kaawm e imyin ni BAWIPA hane ceitakhai pawi dawk bawk han ngai pawiteh, ceitakhai pawi dawk pouk e hoi kâlawk patetlah a sak van han. Ram thung e tami hoi imyin naw hanelah kâvancalah phunglam na tawn awh han, telah dei pouh atipouh. ");
INSERT INTO cth_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Hot patetlah lukkareiim kangdue sak navah, lukkareiim, lawkpanuesaknae rim hah tâmai, hmai patetlah ka kamnuek e hah lukkareiim lathueng tangmin lahoi amom totouh ao. ");
INSERT INTO cth_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hot patetlah tâmai ni pou a ramuk teh tangmin teh hmai patetlah pou a kamnue. ");
INSERT INTO cth_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Lukkareiim dawk e tâmai a kampuen toteh, Isarel catounnaw a cei awh han. Hahoi tâmai a kangdue tangkuem vah, Isarel catounnaw ni rim a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","BAWIPA kâpoe e patetlah Isarelnaw hah a cei awh vaiteh, BAWIPA kâpoe e lahoi a roe awh han. Lukkareiim dawk tâmai a kangdue yunglam teh, rim thung vah pou ao awh. ");
INSERT INTO cth_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Lukkareiim dawk tâmai kasawlah kaawm nakunghai, Isarelnaw ni BAWIPA e kâ a ngai awh dawkvah, cet laipalah ao awh. ");
INSERT INTO cth_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Hahoi teh hettelah doeh. Tâmai teh lukkareiim dawkvah, dongdeng ao navah, BAWIPA kâpoe e patetlah roenae rim dawk pou ao awh han. Hahoi BAWIPA kâpoe e patetlah a cei awh han. ");
INSERT INTO cth_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Hahoi teh hettelah doeh. Tâmai teh tangmin lahoi amom totouh dueng doeh ao teh, amom lah tâmai a kampuen toteh, a cei awh han. Kanîthun hai thoseh, amom hai thoseh, tâmai a kampuen boum teh a cei awh han. ");
INSERT INTO cth_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Lukkareiim dawk tâmai ni hnin hni touh thoseh, thapa yung touh thoseh, kum touh thoseh koe awm pawiteh, Isarelnaw ni hote hmuen cettakhai laipalah, rim thung roup ao awh. Hatei, a lathueng lah a kâtawm toteh a cei awh. ");
INSERT INTO cth_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","BAWIPA kâpoelawk patetlah a roe awh teh, BAWIPA kâpoelawk patetlah a cei awh. Mosi hno lahoi BAWIPA kâpoe patetlah ao awh. ");
INSERT INTO cth_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","ngun mongka kahni touh, dêi lah dêi nateh sak loe. Tamimaya kawnae hoi tâcosak nahanlah na hno han. ");
INSERT INTO cth_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Kahni touh hoi na ueng navah, taminaw teh kamkhuengnae lukkareiim takhang koe a kamkhueng awh han. ");
INSERT INTO cth_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Hatei, buet touh dueng na ueng pawiteh, Isarel catoun kahrawikung a hu buet touh dawk kacuenaw hah nang koe a kamkhueng awh han. ");
INSERT INTO cth_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kâhruetcuetnae na ueng pawiteh, Kanîtholae naw ni a kamthaw awh han. ");
INSERT INTO cth_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Hahoi kâhruetcuetnae apâhni na ueng toteh, akalae naw ni a roenae koehoi a kamthaw awh han. A kamthaw awh nahanelah, kâhruetcuetnae pou na ueng pouh han. ");
INSERT INTO cth_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Maya a kamkhueng nahanelah, hmaloe na ueng awh han. Hatei kâhruetcuetnae teh na ueng mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aron e canaw, vaihmanaw ni mongka teh a ueng awh han. Hete hno heh nangmae se yunglam, yungyoe hanelah phunglam lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Na ram dawk namamouh rep kacuengroekung, na taran tuk hanlah na cei navah, kâhruetcuetnae ueng lah na ueng awh han. Hottelah BAWIPA Cathut hmalah, pou na panue e lah pou awm vaiteh, na tarannaw thung hoi rungngang e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na lunghawinae hnin thoseh, pawi e tueng dawk thoseh, thapareinae dawk thoseh, hmaisawi thuengnae hoi roum thuengnae thoseh, mongka na ueng awh han. Hot patetlah na Cathut hmalah nangmouh han pahnimhoehnae lah ao han. Kai teh Jehovah na Cathut lah ka o telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Hahoi a kum hni, thapa yung pahni, hote thapa 20 hnin teh, lawkpanuesaknae lukkareiim koehoi tâmai hah kahlun lah a kâtawm. ");
INSERT INTO cth_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Hahoi hmalah pâtam hoi Sinai kahrawng koehoi Isarelnaw teh a kamthaw. Hahoi Paran ram kahrawng dawk tâmai teh a kangdue. ");
INSERT INTO cth_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mosi hno lahoi BAWIPA kâpoe e patetlah avai pasuek a kamthaw awh. ");
INSERT INTO cth_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ahmaloe poung lah Judah ransanaw hah a imthungkhu mitnoutnae sin hoi a tâco awh. A ransabawi teh, Amminadab capa Nahshon doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Issakhar miphun catounnaw ransabawi teh Zuar capa Nethanel doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Zebulun miphun catounnaw ransabawi teh Helon capa Eliab doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hahoi lukkareiim hah a raphoe awh teh, Gershon catounnaw hoi Merari catounnaw ni lukkareiim kâkayawt hanlah a tâco awh. ");
INSERT INTO cth_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Hahoi Reuben ransanaw teh amamae mitnout sin laihoi a tâco awh. A ransabawi teh Shedeur capa Elizur doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeon miphun catounnaw ransabawi teh Zurishaddai capa Shelumiel doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Gad miphun catounnaw ransabawi teh Deuel capa Eliasaph doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hahoi, Kohathnaw ni kathounge hno a kâkayawt awh teh a tâco awh. Alouke a tho hoehnahlan vah lukkarei hah a rakueng awh. ");
INSERT INTO cth_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Hahoi Ephraim ransanaw teh, mitnout a sin awh teh, a tâco awh. A ransabawi teh Ammihud capa Elishama doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manasseh miphun catounnaw ransabawi teh Pedahzur capa Gamaliel doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Benjamin miphun catounnaw ransabawi teh Gideon capa Abidan doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Hahoi, a hnuktengpoung lah Dan catoun ransanaw hah amamae mitnout a sin awh teh, a tâco awh. A ransabawi teh Ammishaddai capa Ahiezer doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Asher miphun catounnaw ransabawi teh Okran capa Pagiel doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Naphtali miphun catounnaw ransabawi teh Enan capa Ahira doeh. ");
INSERT INTO cth_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isarel catounnaw a kamthaw awh toteh, a ransanaw patuen patuen lahoi a ceinae nuencang la a tho. ");
INSERT INTO cth_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mosi e a napu Midian tami Reuel capa Hobab koevah, Mosi ni nang koe na poe han telah BAWIPA ni ati e hmuen koevah, cei han a kâcai awh teh, kaimouh koe tho van leih, kahawicalah na tak dawk ka sak han, bangdawk tetpawiteh, Isarel koevah, BAWIPA ni hnokahawi a kam toe atipouh. ");
INSERT INTO cth_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ahnimouh ni nangmouh koe ka cet mahoeh. Kamamouh e ram hmaunawngha koe doeh ka cei awh han atipouh awh. ");
INSERT INTO cth_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Hahoi teh Mosi ni hrumhram na cettakhai awh hanh. Bangkongtetpawiteh, kahrawngum roe nahan hmuen sak hane koe vah, na panue e patetlah hoi, na panue e yit touh kaimouh hanlah, mit lah doeh na awm awh ti. ");
INSERT INTO cth_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kaimouh koe na cet awh pawiteh BAWIPA ni hnokahawi na sak pouh e patetlah na sak pouh van han atipouh. ");
INSERT INTO cth_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Hahoi teh, BAWIPA e mon koehoi hnin thum lamcei dawk a cei awh. Ahnimouh han kâhatnae hmuen tawng hanlah BAWIPA lawkkam thingkong hah hnin thum touh thung a hmalah a cei pouh. ");
INSERT INTO cth_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Rim koehoi a kamthaw awh toteh, kanîthun BAWIPA e tâmai ahnimouh lathueng vah ao. ");
INSERT INTO cth_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Hahoi thingkong a tâco nah tangkuem vah, Mosi ni oe, BAWIPA kang dout haw. Na taran hah kâkahei awh naseh. Na kahmuhmanaw hah na hmalah yawng awh naseh, telah ouk ati. ");
INSERT INTO cth_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Hahoi, thingkong a kâhat nah tangkuem vah, Oe BAWIPA, Isarelnaw a thongsang koe, kamlang haw telah ouk atipouh. ");
INSERT INTO cth_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Tamimaya a phuenang awh toteh, BAWIPA lunghawinae awmhoeh. Bangkongtetpawiteh, hote hah BAWIPA ni a thai toteh, a lungkhuek teh a lungkâan. Hat torei teh BAWIPA e hmai hah ahnimouh rahak vah paluk a to pouh teh, roenae hmuen alawilah, a tangawn koung a kak pouh. ");
INSERT INTO cth_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Hahoi teh, tamimaya ni Mosi koe a hram awh teh, Mosi ni BAWIPA koe a ratoum teh, hmai teh bout a roum. ");
INSERT INTO cth_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","BAWIPA e hmai hah ahnimouh rahak vah paluk a to pouh dawkvah, hote hmuen teh Taberah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Hahoi ahnimouh rahak vah, mak kâkalawt e maya koehoi, takthai ngai awh e hah a tâco. Isarel canaw hai bout a khuika awh teh, apinimaw ca hane moi na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Aphu laipalah hoi Izip ram vah tanga moi canae hah ka pahnim thai awh hoeh. Payin paw hoi angkem paw, rasonpaling, rasonpangaw, ankahringnaw hah ka rabuipoung awh toe. ");
INSERT INTO cth_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Atuteh ka rakhing koung a ke awh toe, Manna laipalah hoi banghai ka mit ni hmawt awh hoeh toe telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna teh songsuen mu patetlah a o, arong teh badellium patetlah ao. ");
INSERT INTO cth_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Taminaw ni a racawng awh teh, a roe awhnae koe a phawm awh teh, hlaam dawk a thawng awh, vaiyei lah a sak awh, a ca awh toteh satui hoi karê e patetlah ao. ");
INSERT INTO cth_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Tangminlah a roenae rim koe tadamtui a bo toteh manna hai ouk a bo van. ");
INSERT INTO cth_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Taminaw pueng teh imthung lahoi roenae rim takhang koe a ka awh tie Mosi ni a thai. Hahoi BAWIPA lungphuennae teh puenghoi a kâan teh, Mosi hai a lunghawi hoeh. ");
INSERT INTO cth_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Hot patetlah Mosi ni BAWIPA koe bangkongmaw na san heh runae na poe, bangkongmaw, na mitkhetcawp hoeh e maw, hete maya hnokarinaw heh kai ka van na patue. ");
INSERT INTO cth_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Hete taminaw kai ni ka vawn e namaw. A na mintoenaw koe thoebonae ram koe ceikhai hanlah, camo kakhenaw ni sanu ka net lahun a tawm e patetlah na lungtabue dawk tawm awh na ti hanelah ka khe e na ma. ");
INSERT INTO cth_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Hete taminaw na poe hane moi teh nâhoi maw ka la han. Bangkongtetpawiteh, ka ca hane moi hah na poe telah khuika laihoi na cusin awh toe. ");
INSERT INTO cth_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Hete taminaw pueng hah, kai kamadueng teh ka phawt thai hoeh toe. Kai hanlah a ri poung ");
INSERT INTO cth_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Het patet e na sak hane pawiteh, na pahren nateh na thei leih, ka rei na thaisak hanh leih telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","BAWIPA ni Mosi koevah, Isarel kacuenaw, maya thung dawk kacuenaw hoi bet a lungkaha lah na panue e naw tami 70 touh pâkhueng nateh, kai koe kamkhuengnae koe lukkareiim dawk nang koe a ka due thai nahan thokhai loe. ");
INSERT INTO cth_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Hattorei haw vah tho vaiteh na pato han. Na tak dawk kaawm e muitha hah ka la vaiteh ahnimouh lathueng ka hruek han. Nang dueng ni phawt laipalah, maya e hmuenri hah ahnimouh ni na phu khai han. ");
INSERT INTO cth_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Nang ni tamimaya koe tangtho hanelah kamthoung awh nateh, moi teh na ca awh han. Moi na ca awh hane apinimaw na poe awh han, bangtelamaw Izip ram vah phu ka nep lah ka o teh telah BAWIPA hnâthainae koe na ka awh vaw. Hatdawkvah, BAWIPA ni moi na poe awh vaiteh na ca awh han. ");
INSERT INTO cth_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hnin touh hnin hni touh laipalah, apanga hnin hra touh laipalah, hnin 20 touh laipalah, ");
INSERT INTO cth_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","thapa yung touh thung hmawtcei hoi palopalai nunnun a tho toteh, na ca awh han. Bangkongtetpawiteh, nama koe kaawmnaw ni BAWIPA na dudam awh, Bangkongmaw Izip ram hoi kaimanaw na tâcokhai telah a hmalah, na ka awh telah tet pouh ati telah a ati. ");
INSERT INTO cth_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mosi ni kai koe kaawm e khok hoi kacetnaw ting taruk touh a pha teh, thapa yung touh ca hane moi ka poe han telah na ti. ");
INSERT INTO cth_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Tuhu hoi maitohu naw hai thet pouh haw a boum awh han vaimoe. Talî dawk e tanganaw pueng man pouh nakunghai a boum awh han vaimoe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","BAWIPA ni Mosi koevah, BAWIPA e kut teh a duem maw. Ka dei e hah nang koe a kuep hoi kuep hoeh e na panue han doeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hahoi Mosi a tâco teh, BAWIPA lawk hah taminaw pueng koe a dei pouh. Tamihu kacuenaw 70 touh hah a kaw teh, lukkareiim petkâkalup lah a kangdue sak ");
INSERT INTO cth_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Hahoi BAWIPA teh tâmai dawk a kum teh a pato. Ahni koe kaawm e muitha hah kacuenaw 70 touh lathueng vah a ta. Ahnimouh tak dawk muitha a pha teh, Lawk a pâpho awh. Hot patetlah ouk sak awh boihoeh ei nan toung mah. ");
INSERT INTO cth_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Hatei, roenae hmuen koe tami kahni touh pou ao. Buet touh e a min teh Eldad doeh. Alouk buet touh e min teh Medad doeh, Muitha hah ahnimouh koe ao. Touk e naw dawk ka bawk awh e eiteh, kamkhuengnae lukkareiim koe cet vah hoeh. Roenae hmuen koe lawk hah a pâpho roi. ");
INSERT INTO cth_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Hahoi thoundoun buet touh a yawng teh Mosi koe a dei pouh teh, Eldad hoi Medad ni lawk teh pâpho lahun telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nun capa Joshua a nawsai lahoi yah. Mosi thaw ka tawk pouh e ni a pathung teh, ka bawipa Mosi ahnimouh hah ngang haw ati pouh. ");
INSERT INTO cth_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mosi ni ahni koe, kai na dipma e na ou. BAWIPA ni taminaw pueng heh profet lah koung awm naseh, BAWIPA ni ahnimouh lathueng muitha hah ahnimouh van tat pouh naseh ka tie nahoehmaw. ");
INSERT INTO cth_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hahoi Mosi teh ama hoi Isarel a lungkahanaw hoi roenae hmuen koe a ban awh. ");
INSERT INTO cth_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hahoi BAWIPA koehoi kahlî a tho teh, talî koe lahoi tamuem hrut a palek pouh teh roenae rim avangvanglah hoi hnin touh lamcei reira dawk dong hni touh ka rasang lahoi a pabo pouh. ");
INSERT INTO cth_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Hot patetlah tamimaya ni karum tuettuet kanîruirui a tangtho kanîruirui tamuem teh a racawng awh. Kayounpoung ka racawng e ni hai Homer 10 touh a racawng awh (homer teh ephah hra touh, 220 liters a cawng). Rim pueng koe amamouh hane lengkaleng a vaw awh. ");
INSERT INTO cth_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Hatei moi teh a la awh lahun nah, be a ca awh hoehnahlan tamimaya lathueng BAWIPA e lungkhueknae a kâan teh, tamimaya koe takikatho poung e lacik hoi BAWIPA ni a rek awh. ");
INSERT INTO cth_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Hote hmuen teh a min Kiborthhattaavah telah ati. Bangkongtetpawiteh, haw vah, takthaingainae katawnnaw hah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kiborthhattaavah koehoi tamihupui teh Hazeroth lah a pâtam awh teh Hazeroth a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mosi ni Ethiopia tami a yu lah a la kecu dawkvah, Miriam hoi Aron ni Bangdawkmaw Ethiopia tami hah a yu lah a la titeh lairoekhai roi. ");
INSERT INTO cth_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ahnimouh roi ni Mosi koe dueng maw, BAWIPA ni lawk a dei. Kaimouh koehai dei van hoeh na maw, telah atipouh roi e hah BAWIPA ni a thai. ");
INSERT INTO cth_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mosi teh talai van pueng e taminaw hlak kârahnoumpoung e lah ao. ");
INSERT INTO cth_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Hahoi, Mosi, Aron hoi Miriam koevah BAWIPA ni kathum touh hoi tâcawt awh. Kamkhuengnae lukkareiim koe tho awh, telah atipouh. Hot patetlah kathum touh hoi a tâco awh. ");
INSERT INTO cth_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","BAWIPA ni tâmai khom lahoi a kum teh, kamkhuengnae bawkim takhang koe a kangdue pouh. Aron hoi Miriam a kaw teh, kahni touh hoi hmalah a tâco roi. ");
INSERT INTO cth_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Ahni ni ka lawk hah thai roi haw, nangmouh rahak profet awm pawiteh, ahni teh kai BAWIPA ni vision ka panuesak han, a mang lahoi ka pato han. ");
INSERT INTO cth_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ka san Mosi teh hot patetlah awm hoeh. Ka imthungnaw pueng kong dawkvah yuemkamcu. ");
INSERT INTO cth_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Arulahoi laipalah, minhmai phek kadangka hoi kacaipinlah lawk ka dei pouh. BAWIPA meilam hai a hmu. Hot patetlah bangkongmaw ka san Mosi heh phuenang sin hanlah louk na ngai roi vaw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Hot patetlah BAWIPA ni ahnimouh roi koe a lungkhuek teh a ceitakhai. ");
INSERT INTO cth_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Hahoi lukkareiim koehoi tâmai a kâtawm teh, khenhaw, Miriam teh tadamtui patetlah a pangaw teh hrikbei lah a coung. Aron ni Miriam hah a khet teh, khenhaw a hrikbei toe hei ati. ");
INSERT INTO cth_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Hahoi Aron ni Mosi koevah, Oe ka bawipa, kai koe hete yon heh kamtue sak hanh. Pathu lahoi ka sak teh ka payon toe. ");
INSERT INTO cth_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Tami a manu von kâko hoi a tâco teh, kadout tangcoung e patetlah hete napui hah awm sak hanh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mosi teh BAWIPA koevah a hram teh, Oe Cathut pahren lahoi hawi sak haw telah a ratoum. ");
INSERT INTO cth_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","BAWIPA ni Mosi koevah, na pa ni a minhmai dawk a tamthawi e patenghai hnin sari touh teh kayak mahoeh maw. Roenae alawilah hnin sari touh kâhrawk naseh, hahoi bout kâenkhai awh naseh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Hot patetlah, Miriam teh roenae alawilah hnin sari touh a kâhro. Miriam a kâenkhai awh hoehroukrak, tamimaya teh cet awh hoeh ");
INSERT INTO cth_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hahoi, taminaw teh Hazeroth hoi a kamthaw awh teh, Paran kahrawngum vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Isarelnaw koe ka poe e Kanaan ram tuet sak hanlah, tami patoun leih. Miphun tangkuem kahrawikungnaw thung hoi tami buet touh rip na tha han atipouh. ");
INSERT INTO cth_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Hatdawkvah, Mosi ni Paran kahrawngum hoi BAWIPA kâpoe e patetlah a patoun. Abuemlahoi Isarel catoun kahrawikungnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Hotnaw e minnaw teh, Reuben miphun dawk hoi Zakkur capa Shammua, ");
INSERT INTO cth_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon miphun dawk hoi Khori capa Shaphat, ");
INSERT INTO cth_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judah miphun dawk hoi Jephunneh capa Kaleb, ");
INSERT INTO cth_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issakhar miphun dawk hoi Joseph capa Igal, ");
INSERT INTO cth_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ephraim miphun dawk hoi Nun capa Hosi, ");
INSERT INTO cth_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamin miphun dawk hoi Raphu capa Palti, ");
INSERT INTO cth_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebulun miphun dawk hoi Sodi capa Gaddiel, ");
INSERT INTO cth_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Joseph miphun dawk hoi ( hot teh Manasseh miphun doeh) Susi capa Gaddiel, ");
INSERT INTO cth_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan miphun dawk hoi Gemalli capa Ammiel, ");
INSERT INTO cth_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asher miphun dawk hoi Michael capa Sethur, ");
INSERT INTO cth_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Naphtali miphun dawk hoi Vophsi capa Nahbi, ");
INSERT INTO cth_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad miphun dawk hoi Makhi capa Geuel, ");
INSERT INTO cth_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Hetnaw heh ram tuet sak hanelah Mosi ni a patoun e naw doeh. Nun capa Hosi teh Mosi ni Joshua telah a kaw. ");
INSERT INTO cth_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Hot patetlah Mosi ni Kanaan ram tuet hanelah ahnimouh teh a patoun. Ahnimouh koe akalae lam dawk hoi hmaloe cet awh nateh, mon dawk luen awh. ");
INSERT INTO cth_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ram teh bangtelah vaimoe. Haw e kho ka sak e taminaw hah a thasai awh maw, a thayoun awh maw, tami a pap maw ayoun maw tie hoi, ");
INSERT INTO cth_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","a onae ram teh kahawi na ou, a onae kho teh bangpatet lae na vaimoe. Rim na ou, rapanim kaawm na ou. ");
INSERT INTO cth_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ram teh ka tawnta na ou, ka takang awh na ou, ratu na ou. Tarankahawilah awm awh nateh, ram dawk e a paw phawt awh telah atipouh. Hote tueng teh misur paw a hminnae tueng hoi a kâvoe. ");
INSERT INTO cth_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Hottelah a kamthaw awh teh, a takhang awh. Ram teh Zin kahrawngum hoi Hamath kâennae Rehob totouh, Kanaan ram koung a tuet awh. ");
INSERT INTO cth_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Akalah hoi hmaloe a takhang awh teh Hebron vah a pha awh. Hawvah Anakim catounnaw, Ahiman Sheshai hoi Talmai taminaw ao awh. ( Hebron teh Izip ram hoi Zoan kho thawng hoehnahlan kum sari nah thawng e kho lah a o). ");
INSERT INTO cth_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Hahoi Eshkol tanghling dawk a pha awh. Haw e misur paw hah abawm khuehoi a bouk awh teh, tami kahni touh ni a kâkayawt awh. Tale paw hoi thaibunglung paw hai a thokhai awh. ");
INSERT INTO cth_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Haw e misur bawm Isarelnaw ni a bouk pouh dawkvah, hote hmuen teh Eshkol tanghling ati awh. ");
INSERT INTO cth_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Hnin 40 hnukkhu, Kanaan ram tuetnae koehoi a ban awh. ");
INSERT INTO cth_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Hot patetlah Paran kahrawng dawk Kadesh vah Mosi hoi Aron hoi a taminaw pueng koe bout a pha awh. Ahnimouh ni tamimaya koe lawk a thokhai awh. Hot ram hoi e a pawnaw hah a patue awh. ");
INSERT INTO cth_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Hahoi ahnimouh ni ahnimouh koe, na patounnae ram dawkvah ka cei awh teh, sanutui hoi khoitui a lawngnae tangngak doeh, hetheh haw e ram dawk e a pawnaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Hatei, hote ram dawk khokasaknaw teh tami a thasai seng doeh. Khonaw hai rapan ka tawn e khopui seng doeh. Hothloilah Anakim catounnaw ka hmu awh. ");
INSERT INTO cth_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaleknaw akalah ao awh teh, Hitnaw hoi Jebusitnaw, Amornaw monrui dawk ao awh. Hahoi Kanaannaw teh talî tengpam, Jordan palang rayawk lah ao awh telah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Hottelah, Kalep ni Mosi hmalah taminaw pueng sairasuep lah ao sak teh, pâtam vaiteh lat awh sei. Bangkongtetpawiteh, tâ awh roeroe han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Hatei, ahni hoi rei kacetnaw ni, hotnaw tuk hanlah ka cet thai awh mahoeh. Bangkongtetpawiteh, maimouh hlak a thasai awh telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Hottelah a tuet awh e ram kong teh Isarel catounnaw koe kamthang mathout lah a pathang awh, ramnaw pueng tuet hanelah ka cei awh navah, amamae a canaw patenghai a thei awh, ka hmu awh e naw teh a rasangpoung awh, a thasai seng doeh. ");
INSERT INTO cth_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Hahoi hete hmuen koevah Anakim catoun kalenpoungnaw ka hmu awh. Kaimanaw teh samtong patetlah doeh ka o awh ati awh. ");
INSERT INTO cth_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Hahoi teh, kamkhuengnaw pueng ni hote tangmin puenghoi a khuika awh. ");
INSERT INTO cth_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Isarel catounnaw pueng Mosi hoi Aron koe a phuenang awh. Kamkhueng e tamimaya koevah, Izip ram vah dout awh ngala pawiteh, hoehpawiteh hete kahrawngum dout ngala pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","bangkongmaw, tahloi hoi thei vaiteh, yuca pueng taran kut dawk pha sak hanelah maw BAWIPA ni hete ram dawk na ceikhai. Izip ram bout ban pawiteh, maimouh han bet a hawihnawn nahoehmaw telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Hahoi a kamkhueng awh teh kahrawikung rawi vaiteh, Izip ram vah ban awh sei telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mosi hoi Aron teh kamkhueng e Isarelnaw pueng e hmalah a tabo roi. ");
INSERT INTO cth_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Hateiteh, Nun capa Joshua hoi Jephunneh capa Kalep, ram katuetnaw thung dawk ka bawk roi van e ni a hni a phi roi teh, ");
INSERT INTO cth_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","kamkhueng e Isarelnaw pueng koe tuet hanelah ka cei sin awh e ram teh, kahawi poung tangngak e doeh. ");
INSERT INTO cth_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Maimouh koe BAWIPA a lunghawi pawiteh, ama ni na cetkhai awh vaiteh, khoitui hoi sanutui a lawngnae ram teh na poe han doeh. ");
INSERT INTO cth_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","BAWIPA taranlahoi taranthaw laipalah, hote ram dawk e tami taket laipalah, awm awh sei. Bangkongtetpawiteh, ahnimouh teh maimae rawca lah doeh awm awh ti, ahnimanaw teh a kângue awh e awm hoeh. BAWIPA teh maimouh koe ao. Ahnimouh teh taket awh hanh sei telah ati roi. ");
INSERT INTO cth_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Hahoi ka kamkhueng e pueng ni talung hoi dêi han a noe awh. Hahoi BAWIPA bawilennae teh kamkhuengnae lukkareiim dawk hoi Isarelnaw pueng e hmalah a kamnue pouh. ");
INSERT INTO cth_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","BAWIPA ni Mosi koevah hete taminaw pueng nâtotouh maw na pahnawt awh han. Ahnimouh koe mitnoutnae ka sak pouh ei teh, nâtotouh maw yuem laipalah ao awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Lacik hoi ka yue vaiteh, be ka pahma ngala han. Nang dawkvah, ahnimouh hlak ka sungren e hoi hno ka tet thai e miphun ka kangdue sak han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mosi ni BAWIPA koevah hot teh Izipnaw ni thai langvaih. Bangkongtetpawiteh, hete tamihupui heh na thao e lahoi na tâcokhai e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Hot teh hete ram taminaw koe a dei pou han. BAWIPA nang teh hete taminaw koevah na o teh, BAWIPA nang nama teh minhmai phek kadangka lah na hmu awh kanîthun tâmaikhom hoi karum lah hmaikhom hoi a hmalah na cei pouh tie a panue awh toe. ");
INSERT INTO cth_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Hot patetlah hete tamimaya heh tami buet touh e patetlah na thei pawiteh, na min kamthang ka panuek e miphunnaw ni, ");
INSERT INTO cth_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","BAWIPA ni hete tamimayanaw heh thoebo hoi a kam e ram dawk a hrawi thai hoeh dawkvah, kahrawngum koung a thei telah a dei awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","BAWIPA ni a lungsaw teh lungmanae hoi ka kawi e, payonnae hoi kâtapoenae ka ngaithoumkung yonpen e naw kayawicalah hloutsak laipalah, ");
INSERT INTO cth_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","napanaw yonnae kecu dawk canaw, catounnaw se thum se pali totouh, ouk karekkung doeh na a telah na dei tangcoung e patetlah BAWIPA na hnosakthainae teh, hoe lentoe lawiseh. ");
INSERT INTO cth_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Na lungmanae a pap e patetlah hoi Izip ram hoi atu totouh na ngaithoum e patetlah na tamimaya e payonnae naw hah ngaithoum pouh haw telah ka ratoum. ");
INSERT INTO cth_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Hat toteh, BAWIPA ni na lawk patetlah ka ngaithoum toe. ");
INSERT INTO cth_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Hatei, ka hring e patetlah BAWIPA bawilennae hoi talai heh muen a kawi han. ");
INSERT INTO cth_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Izip ram hoi kahrawngum ka sak e naw bawilennae hoi kângairunae a hmuen teh, vai hra totouh na tanouk teh, ka lawk ka ngaihoeh e naw pueng ni, ");
INSERT INTO cth_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","kakhekungnaw koe thoebo nalaihoi ka kam pouh e ram teh, hmawt awh roeroe mahoeh. Ahnimouh rahak ka lawk banglahai ka ngaihoehnaw ni hmawt mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Hatei, ka san Kalep, aloukcalah kaawm e muitha hah tawn teh, atangcalah ka hnuk a kâbang dawk, ahni teh a pâtam e ram koe ka hrawi vaiteh, a catounnaw ni a coe awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Atuvah, Amaleknaw hoi Kanaan taminaw hah ayawn dawk ao awh. Tangtho vah ban awh nateh tuipui paling lam koelah hoi kahrawng dawk kâen awh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","BAWIPA ni, Mosi hoi Aron a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","hete kamkhueng e tamikathoutnaw e phuenangnae heh, nâtotouh maw ka ring han. Kai taranlahoi Isarel catounnaw lai a roe awh e ka thai. ");
INSERT INTO cth_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ahnimouh koe ka hring e patetlah ka hnâthainae koe na dei awh e patetlah nangmouh lathueng ka sak han, telah BAWIPA ni a dei. ");
INSERT INTO cth_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nangmouh ni milu na parei awh teh na touk awh tangcoung e patetlah, kum 20 lathueng kai koe laikaroenaw pueng teh, hete kahrawngum vah ro lah a o awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kai ni hete ram dawk na o sak awh awh han ka ti e ram dawkvah, Jephunneh capa Kalep hoi Nun capa Joshua laipateh api hai phat awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Hatei, thei hanelah doeh ao awh, na tie na canaw hah ka kâen sak vaiteh, na ngai awh hoeh ram dawk kho a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Hatei, nangmanaw teh na ronaw ramke dawk koung a kamlei han. ");
INSERT INTO cth_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Na capanaw hah kahrawngum vah kum 40 touh a kâva awh vaiteh, ramke dawk a ro hah a pawk awh hoehroukrak, namamouh na kâyo phu na phu awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ram na tuetnae hnin 40 touh hah, hnin touh yueng lah kum touh telah to lahoi kum 40 touh thung kâtapoe phu na khang awh han. Ka noenae yo a kâthung toe tie na panue awh han. ");
INSERT INTO cth_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Kai BAWIPA ni hete tamikathoutnaw kai taranlahoi kamkhueng e maya pueng koevah, hetheh ka sak roeroe han ka ti toe. Hete kahrawngum vah kahmakata vaiteh, hawvah a due awh han ati telah a dei tet pouh loe. ");
INSERT INTO cth_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Hottelah ram tuet hanlah Mosi ni a patoun teh ka ban awh e ram kong kamthang kathout lah ka pathang e naw, ama taranlahoi tamimaya lai ka roe sak e hoi, ");
INSERT INTO cth_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ram kong dawk kamthangmathout kaphawtnaw roeroe hah BAWIPA hmalah lacik hoi a due awh. ");
INSERT INTO cth_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Hatei, ram tuet han kacetnaw thung dawk Nun capa Joshua hoi Jephunneh capa Kalep teh a hring roi rah. ");
INSERT INTO cth_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Hat toteh, Mosi ni hote lawk teh Isarelnaw pueng koevah a dei pouh teh, taminaw pueng ni a thai awh teh a lung koung a mathoe awh. ");
INSERT INTO cth_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Hottelah amom vah a thaw teh, monsom vah a luen. Khenhaw, ka tho toe. BAWIPA ni na kam pouh e koelah ka cei han. Bangkong, ka payon toe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mosi ni, bangkongmaw BAWIPA kâpoelawk na ek awh, Bangkongtetpawiteh, hete ni kuepcing sak thai mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Takhang awh hanh, telah hoehpawiteh, na tarannaw ni na tâ awh han, bangdawk nangmouh koe BAWIPA awm hoeh. ");
INSERT INTO cth_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nangmouh hmalah Ameleknaw hoi Kanaannaw a o, tahloi hoi be na thet awh langvaih. BAWIPA teh na kamlang takhai dawkvah nangmouh koe BAWIPA awm hoeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Hatei, monsom cei han pou a kâcai awh. Hatei BAWIPA lawkkam thingkong hoi Mosi hai rim dawk hoi tâcawt hoeh. ");
INSERT INTO cth_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Hottelah hot mon dawk kaawmnaw Ameleknaw hoi Kanaannaw hah a cathuk awh teh, a tuk awh. Hormah totouh a pâlei awh. ");
INSERT INTO cth_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Isarelnaw hah pato nateh ahnimouh koe Na o nahane ram kai ni na poe e ram koe na pha awh toteh, ");
INSERT INTO cth_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","BAWIPA koe hmai hoi thuengnae, hmaisawi thuengnae thoseh, lawkkam kuep sak nahanelah, ma lungtho lahoi pawito nah na poe awh e thuengnae thoseh, saringhu dawk hoi tuhunaw thung dawk hoi thoseh, BAWIPA hanlah hmuitui hanelah na poe awh toteh, ");
INSERT INTO cth_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","BAWIPA koe thuengnae ka poe e pueng ni, tavai thuengnae, tavaikanui ephah pung hra pung touh, satui pung pali pung touh kanawk e hoi, ");
INSERT INTO cth_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","nei hane thuengnae koevah, misurtui hnin pung pali pung touh, hmaisawi thuengnae koevah thoseh, poenae koevah tuca tangkuem hanelah na rakueng awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Telah hoehpawiteh, tutan buet touh dawkvah, tavai thuengnae a kanui e tavai ephah pung hra pung hni, satui pung thum pung touh hoi kanawk e, ");
INSERT INTO cth_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","BAWIPA hanlah nei thuengnae hmuitui dawk misurtui hin pung thum pung touh na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Hmaisawi thuengnae thoseh, lawkkam kuepsaknae thuengnae thoseh, BAWIPA koe roum thuengnae dawk maitotan na rakueng awh toteh, ");
INSERT INTO cth_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","maitotan poenae hoi tavai thuengnae, tavaikanui ephah pung hra pung thum, satui hin tangawn hoi kanawk e, ");
INSERT INTO cth_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","nei thueng nahanelah misurtui hin tangawn, BAWIPA hanlah hmuitui hoi thuengnae na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Hot patetlah maitotan hanlah thoseh, tutan hanlah thoseh, tuca hoiyah hmaeca hanlah na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ayoun apap e lahoi na rakueng awh vaiteh, ayoun apap e lahoi na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Hote ram dawk hoi ka tâcawt e pueng ni, het patetlah BAWIPA hanlah hmuitui hmaisawi thuengnae a poe awh navah, a sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Nangmouh koe kho ka sak e imyin thoseh, nangmouh se nah nangmouh koe kho ka sak e naw pueng ni, BAWIPA hanlah hmai hoi hmuitui thuengnae hah nama ni na sak e patetlah a sak awh van han. ");
INSERT INTO cth_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Na se yunglam pueng dawkvah, kamkhueng e maya hoi nangmouh koe kaawm e imyin han haiyah, phung buet touh dueng doeh kaawm han. BAWIPA hmalah imyin teh namamouh patetlah ao han. ");
INSERT INTO cth_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Namamouh han hoi nangmouh koe imyin kaawm e hanlah kâlawk buet touh hoi sak kawi buet touh dueng doeh kaawm han, tet pout telah ati. ");
INSERT INTO cth_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Isarelnaw pato nateh, ahnimouh koe ceikhai hanelah ka noe e ram dawk na pha awh toteh, ");
INSERT INTO cth_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","hote ram dawk vaiyei na ca awh toteh, BAWIPA koe kahek thuengnae na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Nangmouh koe hmaloe kanawk e, vaiyei heh kahek thuengnae koe na poe awh han. Kahek thuengnae na sak awh e patetlah na kahek awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Na catounnaw totouh tavai hmaloe kanawk e hah BAWIPA koe kahek thuengnae na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Hete kâpoe BAWIPA ni Mosi koevah, a dei e pueng BAWIPA ni kâpoelawknaw a kamtawngnae koehoi na catounnaw hanelah, ");
INSERT INTO cth_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Mosi hno lahoi kâpoelawk a poe e naw pueng hah dâw laipalah, ceknoe e awm laipalah hoi yonnae na sak awh pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","hot teh tamimaya panuek laipalah ceknoe hoeh hoi yonnae na sak awh pawiteh, tamimaya ni hmaisawi thuengnae, BAWIPA koevah hmuitui hanlah, maitotan kanaw e buet touh a poe vaiteh, tamimaya ni hmaisawi thuengnae, BAWIPA koevah hmuitui hanlah maitotan kanaw e buet touh a poe vaiteh, aphung patetlah tavai thuengnae hoi roum thuengnae hoi yon thueng nahanelah hmaetan buet touh na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Hottelah, vaihma ni, Isarel catoun tamimaya hanlah, yontha nahanlah a sak vaiteh, ngaithoum e lah ao han. Bangkongtetpawiteh, hot teh ceknoe laipalah sakpayon e doeh. BAWIPA koe thuengnae, hmai hoi sak e thuengnae, BAWIPA hmalah yon thuengnae, ceknoe e awm laipalah sakpayonnae hanlah a thokhai awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Isarel catoun tamimaya teh, ahnimouh koe kho ka sak e, imyinnaw pueng hai ngaithoum e lah ao han. Bangkongtetpawiteh, taminaw pueng ni ceknoenae awm laipalah a sak awh e doeh. ");
INSERT INTO cth_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Hahoi tami buet touh ni ceknoe laipalah yonnae sak pawiteh, yontha thueng nahanlah hmaela âvâ ka cawt hoeh rae kum touh ka phat e a poe han. ");
INSERT INTO cth_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Hahoi, ama hanlah yon thuengnae sak hanlah BAWIPA hmalah, ceknoe e awm laipalah payonnae koe a sak toteh, vaihma ni ceknoe e awm laipalah payonae ka sak e tami hanlah yontha nahan a sak vaiteh, yontha lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ceknoe e awm laipalah ka payonkung hanelah Isarel catounnaw thung dawk, amamanaw hoi ahnimouh koe kaawm imyin hanlah hai reikâvan lah kâlawk a tawn awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Hatei ceknoe hoi yonnae ka sak e teh, ram thung tami thoseh, imyin thoseh, BAWIPA min mathoe sak e lah ao dawkvah, a miphun dawk hoi takhoe lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Bangkongtetpawiteh, BAWIPA e lawk a dudam teh kâpoelawk a ek dawkvah, hote tami teh pahnawt roeroe lah ao han. Yonpennae lah a onae phu hah a phu han, tet pouh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Hottelah Isarel catounnaw kahrawngum ao awh navah, sabbath hnin thing a ei e hmawt pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","thing a ei e kahmawtkung ni Mosi hoi Aron tamimaya koe a ceikhai han. ");
INSERT INTO cth_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Ahni hah bangtelamaw ti han tie deipan hoeh rah dawkvah thongim a pabo awh. ");
INSERT INTO cth_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","BAWIPA ni Mosi koe hote tami teh thei han roeroe lah ao, rapan alawilah taminaw pueng ni talung hoi dêi roeroe hanlah ao telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","BAWIPA ni Mosi koevah, kâ a poe e patetlah taminaw pueng ni rapan hloilah a ceikhai awh teh, talung hoi koung kadout lah a dei awh. ");
INSERT INTO cth_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Isarel catounnaw pato nateh, na catounnaw totouh, khohna pawi koe akana na sak awh vaiteh, kamthim e ralui hoi na na yep awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Hote akananaw hah na hmu awh toteh, BAWIPA e kâpoelawknaw pou na panue awh teh na tarawi awh nahan hoi, ahmaloe vah ma ngainae pâlei awh teh, ma lungpouknae lahoi payon awh e patetlah payon laipalah, ");
INSERT INTO cth_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","kaie kâpoelawknaw pueng na panue awh teh na tarawi awh teh na Cathut hanelah na thoung awh nahan hottelah na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Kai teh nangmae Cathut lah ka o nahan, nangmouh hah Izip ram hoi ka tâcawtkhai e nangmae Cathut Jehovah doeh. Kai teh nangmae Cathut Jehovah doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Levih miphun Kohath capa Izhar, ahnie capa Karah teh, Reuben miphun Eliab capa Dathan hoi Abiram, hoi Peleth capa On tinaw hah a ceikhai teh, ");
INSERT INTO cth_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Isarel catoun thung hoi a min bet kamsawngnaw dawk hoi a lungkahanaw hoi lawkcengkung lah rawi e naw thung dawk hoi tami 250 touh Mosi hmalah a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Mosi hoi Aron taranlahoi ahnimouh koe, hloi na lui awh toe. Bangdawk tetpawiteh a tamimaya koung a thoung awh teh, taminaw pueng koe BAWIPA ao doeh. Bangkongmaw BAWIPA e tamimaya van vah ka taluepoung lah na kâpouk roi telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Hot hah Mosi ni a thai toteh a tabo teh, ");
INSERT INTO cth_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Korah hoi a huinaw pueng koe, tangtho vah BAWIPA ni apimaw amae lah kaawm niteh, apimaw kathoung tie a kamnue sak vaiteh, ama rek hnai hanelah ati han doeh. ");
INSERT INTO cth_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Hetheh sak awh, Korah hoi na huinaw pueng ni hmai lanae tongben lat awh nateh, ");
INSERT INTO cth_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","tangtho vah, athung vah hmai hah tat nateh hmuitui hah BAWIPA hmalah phum awh. Hahoi BAWIPA ni a rawi e pueng teh kathounge lah ao han. Nangmouh Levih capanaw ekvoi na lui awh toe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mosi ni Korah koevah, nangmouh Levih capanaw thaihaw, ");
INSERT INTO cth_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","BAWIPA bawknae rim dawkvah thaw a tawk teh tamimaya hmalah thaw tawk hanlah kangdout e Isarelnaw, Cathut ni ama hnai hanelah Isarel taminaw pueng koehoi a kapek e, ");
INSERT INTO cth_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Levih capa na hmaunawnghanaw hoi ama hnai sak hanlah a ta e naw heh, hno kathoungcalah na pouk awh dawk maw vaihma lah onae na tawng awh rah. ");
INSERT INTO cth_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Hatdawkvah, nang nama hoi na hu pueng teh BAWIPA taranlahoi na kamkhueng awh vaw. Aron heh bangpatet lae tami lah maw ao teh, ahni koevah na phuenang awh vaw telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mosi ni Eliab capa Dathan hoi Abiram a kaw sak, hatei ahnimouh ni ka takhang awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Kahrawngum vah thei rumram hanelah sanutui hoi khoitui a lawngnae ram koehoi na tâcokhai e hah hno kathoengcae na maw, kaimouh lathueng vah bawi lah o han thouk na ngai bo aw. ");
INSERT INTO cth_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Sanutui hoi khoitui a lawngnae ram dawk na ceikhai laipalah law hoi misur takha hai râw hanlah na poe kalawn hoeh. Hetnaw e mit heh ton na phuen pouh han na maw. Ka takhang awh roeroe mahoeh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mosi teh a lungphuen poung teh, BAWIPA koe vah a poe awh e teh dâw pouh hanh. Ahnimae la buet touh boehai ka lat pouh hoeh. Apihai patawnae ka poe hoeh a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mosi ni Korah koevah tangtho vah nang nama hoi na huinaw pueng Aron hoi BAWIPA hmalah la awm awh. ");
INSERT INTO cth_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Hahoi hmai lanae tongben rip sin awh naseh. Hmuitui koung phuen awh naseh. BAWIPA hmalah hmai lanae 250 touh hah sin awh naseh. Nang nama hoi Aron ni hai hmai na lanae tongben reirei sin roih telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Hahoi teh tami pueng ni hmai lanae rip a sin awh teh, hmai a ta awh teh hmuitui a phuen awh. Mosi hoi Aron teh kamkhuengnae lukkareiim takhang koe a kangdue roi. ");
INSERT INTO cth_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hahoi Korah ni tamimayanaw pueng hah ama taran lahoi kamkhuengnae lukkareiim takhang koe a pâkhueng awh. Hahoi hote tamimaya lathueng BAWIPA bawilennae a kamnue. ");
INSERT INTO cth_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Hahoi BAWIPA ni Mosi hoi Aron a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","hete tamihu heh tawkkadekca dawk be a kahma thai nahanlah ahnimouh koehoi alouklah awm awh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Hottelah ahnimouh a tabo awh teh, Oe! Cathut takthainaw pueng e muitha Cathut, buet touh yon kecu dawk taminaw pueng koe na lungkhuek han maw telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","taminaw pueng koe dei pouh. Korah hoi Dathan hoi Abiram tinaw e roenae rim dawk hoi yawng awh telah tet pouh. ");
INSERT INTO cth_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mosi a thaw teh Dathan hoi Abiram koe a cei teh, Isarel kacuenaw a kambawng awh. ");
INSERT INTO cth_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Hahoi taminaw pueng koe a dei teh, hete tamikayonnaw e rim koehoi a tâco awh. Banghai tek pouh hanh awh. Hoehpawiteh a yonae pueng dawk nangmouh hai na bawk awh langvaih telah tet pouh. ");
INSERT INTO cth_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hahoi Korah hoi Dathan hoi Abiram tinaw kathum touh teh, koung a tâcawttakhai awh. Dathan hoi Abiram teh amamae rim dawk hoi a tâco roi teh, amamae rim takhang koe a yucanaw hoi a kangdue awh. ");
INSERT INTO cth_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mosi ni kai kama ngainae lahoi ka sak e nahoeh. BAWIPA ni sak hanelah na patoun e doeh tie hah hete hnonaw dawk hoi na panue awh han. ");
INSERT INTO cth_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hete taminaw niyah ayânaw due e patetlah dout boilah, taminaw pueng rek e patetlah rek pawiteh Cathut ni na patoun hoeh e han doeh. ");
INSERT INTO cth_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Hatei, BAWIPA ni a katha lah hno a sak teh, talai ni a kâko ang pawiteh, amamouh hoi kâkuen e pueng koung a padoun hoiyah tangkom dawk a hringo kâen awh pawiteh, BAWIPA ni hete taminaw heh a pahnawt toe tie na panue awh han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Hahoi, hete lawknaw koung a dei hnukkhu hoi ahnimouh onae koe talai rak a kâbawng. ");
INSERT INTO cth_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Hahoi teh talai ni a kâko a ang teh, imthung buemlahoi, Korah e taminaw pueng hoi hnopainaw pueng hoi he a payawp. ");
INSERT INTO cth_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Hahoi amamouh hoi a tawn awh e naw pueng hah tangkom dawk a hringo koung a bo awh. Talai ni a kâko a cakuep teh, ka kamkhueng e naw koehoi he a kahma awh. ");
INSERT INTO cth_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Hahoi a tengpam e Isarelnaw pueng teh, hotnaw e hramki lawk dawk hoi a yawng awh teh, talai ni na payawm awh langvaih telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Hahoi BAWIPA koehoi hmai a tâco teh hmuitui ka thueng e tami 250 touh he a kak awh. ");
INSERT INTO cth_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","nang ni hmai hah tâkhawng nateh, vaihma Aron capa Elizur ni hmai thung e hmailanae tongben la hanelah dei pouh. Bangkongtetpawiteh, kathounge hno lah ao. ");
INSERT INTO cth_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Amamouh hringnae dawk kapayonnaw e hmailanae tongbennaw hai lat nateh, khoungroe ramuk nahanelah dêi lah awm naseh. Bangkongtetpawiteh BAWIPA hmalah poe e a tho dawkvah, kathounge lah ao teh, Isarel catounnaw hanelah mitnout lah ao han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Hahoi Isarel catounnaw hanelah pahnim hoeh nahanelah Aron hoeh laipateh Jentelnaw BAWIPA hanlah hmuitui hmaisawi thueng hanelah a cei awh hoeh nahan, ");
INSERT INTO cth_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Karah hoi a huinaw patetlah ao awh hoeh nahan, Mosi hno lahoi BAWIPA ni ahnimouh koe a dei pouh e patetlah bawknae khoungroe ramuk nahan a dêi awh. ");
INSERT INTO cth_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","A tangtho vah, Isarel catoun tamihu teh Mosi hoi Aron taranlahoi a phuenang awh. BAWIPA e tamihunaw na thei awh atipouh awh. ");
INSERT INTO cth_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Mosi hoi Aron hah taminaw pueng ni a kamkhueng sin navah kamkhuengnae lukkareiim koelah a kangvawi awh teh, khenhaw! tâmai ni king a kayo awh teh, BAWIPA bawilennae a kamnue. ");
INSERT INTO cth_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mosi hoi Aron teh kamkhuengnae lukkareiim hmalah a tho roi. ");
INSERT INTO cth_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","hete taminaw thung hoi aloukcalah awm awh. Tawkkadekca kahma sak nahanelah, telah atipouh. Hahoi ahnimouh teh a tabo awh. ");
INSERT INTO cth_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mosi ni Aron koevah, hmai lanae tongben sin loe, khoungroe dawk hmai hah tat, hmuitui hah phuen nateh, taminaw pueng koe karanglah cetkhaih. Ahnimouh hanlah yontha nahan sak pouh. BAWIPA koehoi lungkhueknae a tâco toe. Patawnae lacik a kamtawng toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron ni Mosi ni dei e patetlah a sin teh, ka kamkhueng e naw koe lah a yawng. Hahoi teh khenhaw! Lacik teh taminaw pueng koe pataw a kamtawng toe. Hmuitui a phuen teh taminaw yontha sak nahanlah a sak. ");
INSERT INTO cth_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Tami kadout hoi kahring rahak a kangdue teh lacik teh a thoung. ");
INSERT INTO cth_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Hottelah Korah kong dawk hoi kadoutnaw touksin laipalah, lacik lahoi kadoutnaw teh 14700. ");
INSERT INTO cth_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aron teh kamkhuengnae lukkareiim takhang koe Mosi koe a ban teh laciknaw pueng teh a thoung. ");
INSERT INTO cth_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Isarel catounnaw pato nateh a miphun lahoi a napanaw imthung, Isarelnaw hlaikahni touh koe kahrawikungnaw lengkaleng poe hanelah sonron hlaikahni touh na la vaiteh, amamae min hah sonron dawk lengkaleng thut pouh. ");
INSERT INTO cth_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Hahoi Levih sonron dawk, Aron min na thut han. Bangkongtetpawiteh, a na pa imthung kahrawikung hanelah sonron buet touh lah rip ao han. ");
INSERT INTO cth_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Kamkhuengnae lukkareiim, lawkpanuesaknae hmalah na ta han. ");
INSERT INTO cth_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Kai ni ka rawi e sonron teh a dawn a pei han. Hattoteh, nangmouh roi yon ka pen e Isarelnaw e phuenangnae teh ka takhoe pouh han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hottelah Mosi ni Isarel catounnaw hah a pato teh, kahrawikungnaw ni a imthungkhu yueng lah kahrawikung buet touh ni sonron buet touh rip a sin teh, sonron hlaikahni touh hah a poe teh, Aron e sonron hai hotnaw rahak vah a bawk van. ");
INSERT INTO cth_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mosi ni kapanuekkhaikung lukkareiim dawk BAWIPA hmalah sonron hah a ta. ");
INSERT INTO cth_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","A tangtho vah Mosi teh kapanuekkhaikung lukkareiim dawkvah, a cei teh, Levih imthung e yueng lah Aron e sonron hah a dawn teh, a pei a muem, a pei a pei teh almond paw a paw. ");
INSERT INTO cth_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mosi ni BAWIPA hmalae sonronnaw pueng hah Isarel catounnaw pueng koe a ceikhai. A khet awh teh amamae sonron hah lengkaleng a la awh. ");
INSERT INTO cth_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Oe BAWIPA ni, laikaroenaw koe lah mitnout lah ao nahanelah, Aron e sonron hah lawkpanuesaknae kung koe tat leih. Hat pawiteh doeh ahnimae phuenangnae hah ka mithmu hoi kâhat vaiteh dout awh mahoeh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","BAWIPA ni Mosi lawk a thui e patetlah ahni ni a tarawi teh a sak. ");
INSERT INTO cth_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Isarel catounnaw ni Mosi koevah, koung kahma awh teh, koung ka due awh toe, koung rawk awh katang toe. ");
INSERT INTO cth_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","BAWIPA lukkareiim kâhnai pueng ni a due awh. Koung kahmat lah due awh han namaw telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","BAWIPA ni Aron koevah, nangmouh hoi na capanaw hoi nang koe kaawm e na pa imthungnaw ni, hmuen kathoung hoi kâkuen e payonpakainae yon teh na phu awh han. Hahoi nama hoi nang koe kaawm e na capanaw hoi vaihma lah na onae hoi kâkuen e payonpakainae yo hah na phu awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Na pa miphun, Levih miphun na hmaunawnghanaw ni kapanuekkhaikung lukkareiim hmalah na capanaw koe ao navah, nang hoi thaw cungtalah rei a tawk thai nahan, nang koe na thokhai han. ");
INSERT INTO cth_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Na panki e thaw hoi lukkareiim thaw a panki e naw na kabawp han. Hatei, hmuen kathoung hlaamnaw hoi bawknae khoungroe hah hnai awh hanh naseh, telah nahoeh pawiteh, ahnimouh hai nangmouh hai na due awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ahnimouh ni na kabawp awh vaiteh, kamkhuengnae lukkareiim thaw pueng hah a panki e patetlah lukkareiim thaw a tawk awh han. Hatei alawilae tami ni na hnai awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Isarel catounnaw lathueng vah lungkhueknae ao hoeh nahanlah, nang nama ni hmuen kathoung thaw hoi khoungroe thaw hah na ham lah na la han. ");
INSERT INTO cth_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Khenhaw! kai ni na hmaunawngha Levih taminaw hah Isarel catounnaw thung hoi ka la teh, kamkhuengnae lukkareiim koe thaw tawk hanlah, nangmouh hanlah BAWIPA koehoi poe e nangmouh koe poe e doeh. ");
INSERT INTO cth_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Hatdawkvah, nang nama hoi na capanaw ni khoungroe hoi yaphni athung lae hnonaw pueng dawk vaihma na coungnae thaw heh poehno patetlah nang koe poe lah ao. Hatei, alawilae tami bawk pawiteh thei lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","BAWIPA ni Aron a pato teh, khenhaw! kai kama roeroe ni kahek thuengnae koe Isarel catounnaw poehno kathoungnaw pueng hah, nang nama hoi na capanaw e ham lah a yungyoe hane phung lah na poe. ");
INSERT INTO cth_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Hmai sawi hoeh e pueng nang han hno kathoung poung lah ao han. A pasoung awh e pueng, tavai thuengnae, yon thuengnae, hoi kâtapoe thuengnae, kai koe na poe awh e hah, nang hoi na capanaw hanlah ka thoung poung lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Tongpa pueng ni hmuen kathoung poung koe na ca awh vaiteh, nangmouh hanlah ka thoung e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Het hai na ham lah ao han, tavai thuengnae koe a poe awh e hno, Isarel catounnaw kahek thuengnae hnopoe pueng hah nang nama hoi na capa na canu naw hoi a yungyoe na ham lah na poe. Na im dawk tamikathoung kaawm e pueng ni a ca thai awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Kahawipoung e satui hoi misur kahawipoung e hoi aluepaw BAWIPA hanlah a poe awh e hah na poe. ");
INSERT INTO cth_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ahnimae law dawk e aluepaw hmaloe ka hmin e BAWIPA hanlah a poe awh e hah nange lah ao han. Na im dawk tamikathoung kaawm e pueng ni a ca thai awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Isarelnaw ni poehno e pueng teh nange lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","BAWIPA hanlah a poe awh e camoim ka paawng pasuek e pueng teh tami thoseh, saring thoseh nange lah ao han. Hatei camin teh na ratang roeroe han. Kathounghoehe saring camin hai na ratang han. ");
INSERT INTO cth_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Thapa yung touh e ratang hanlah kaawm e hah ratangnae phu na to vaiteh, hmuen kathoung koe hno e sekel panga touh hoi na ratang han (sekel teh gerah 20 touh doeh). ");
INSERT INTO cth_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Hatei maitotan camin hoi tu camin hoi hmae camin teh na ratang awh mahoeh. Hotnaw teh a thoung awh. A thipaling teh khoungroe dawk na kathek vaiteh, BAWIPA han hmuitui lah athaw hah hmai hoi hmaisawi thuengnae koe na sawi awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Kahek thuengnae koe a takuep hoi aloung teh nange lah ao e patetlah a moi hah nange lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Kathounge hno hoi kahek thuengnae koe Isarelnaw ni BAWIPA hanlah a poe awh e hah, a yungyoe na ham lah na poe. BAWIPA hmalah nang nama hoi na capanaw hoi na canu naw hoi yungyoe lawkkam lah ao han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","BAWIPA ni Aron koevah, a ram dawk na ham kawi banghai awm mahoeh, a thungup hai na ham kawi banghai awm mahoeh. Kai doeh Isarel catoun thung dawk na ham hoi na coe e râw lah ka o. ");
INSERT INTO cth_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Hahoi Levih catounnaw teh, khenhaw! thawtawknae koe a thaw tawk awh e lukkareiim koe thaw tawk phu lah Isarel ram e pung hra pung touh pueng teh na poe awh. ");
INSERT INTO cth_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Atu totouh hoi teh Isarel catounnaw ni, kamkhuengnae lukkareiim teh hnai awh roeroe hanh naseh. Telah hoehpawiteh, yonpennae phu hoi a due payon awh han doeh. ");
INSERT INTO cth_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Hatei, Levihnaw ni kamkhuengnae lukkareiim koe thaw a tawk awh vaiteh, thaw abuemlahoi a la awh han. Hetnaw heh catounnaw ditouh phunglam lah ao han. Isarel catoun thung vah a ham kawi banghai awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Isarel catounnaw ni pung hra pung touh BAWIPA hanlah kahek thuengnae a poe awh e hah Levihnaw hanlah râw lah ka poe toe. Hatdawkvah, ahnimouh koe Isarel catounnaw thung dawk râw a coe kawi banghai awm mahoeh telah yo ka ti pouh toung tayaw telah ati. ");
INSERT INTO cth_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","hothloilah Levihnaw hah pato nateh, ahnimouh koe na râw hanlah Isarel catounnaw pung hra touh dawk pung touh na poe e hah ahnimouh koehoi na hmu awh toteh, hote pung hra pung touh e thung hoi pung hra pung touh hah BAWIPA koe kahek thuengnae na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Hottelah nangmae kahek thuengnae teh cangkatinnae koe cakang aluepaw hoi misurtui ahruem patetlah pouk e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Hottelah Isarel catounnaw koehoi pung hra pung touh na hmu awh e pueng BAWIPA hanelah kahek thuengnae koe pou na poe awh han. Hahoi BAWIPA hanelah kahek thuengnae hah Aron na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Na hmu awh e pueng thung hoi, kahawipoung, kathoungpounge hah BAWIPA koe kahek thuengnae na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Hatdawkvah ahnimouh koe, hotnaw thung dawk hoi kahawi poung e na kahek awh toteh, Levihnaw a cangkatin e dawk hoi ka tâcawt e hoi misurtui ka lawng e patetlah pouk lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Nâ e hmuen pueng koehai koung na ca thai awh han. Nangmouh hoi na imthung ni hai, bangkongtetpawiteh, kamkhuengnae lukkareiim koe e thaw tawk phu doeh ");
INSERT INTO cth_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Kahawipoung e na kahek awh toteh, yonae yon phu lah awm mahoeh. Hatei, Isarel catounnaw poehno kathounge hah na kamhnawng awh mahoeh, telah hoehpawiteh, na due awh han tet pouh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","BAWIPA ni Mosi hoi Aron hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","hethateh, BAWIPA kâlawk poe e phunglam kâlawk doeh. Isarel catounnaw hah maitola ka paling e kacuem e a laphu thueng pouh hoeh e, thokhai hanlah dei pouh. ");
INSERT INTO cth_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Rapan hloilah ceikhai vaiteh, a hmalah thei thai nahanlah vaihma Eleazar koevah na poe han. ");
INSERT INTO cth_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Vaihma Eleazar ni a kutcarei hoi thipaling youn touh a la vaiteh, kamkhuengnae lukkareiim hmalah, vai sari touh paloupalou a kathek han. ");
INSERT INTO cth_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Hottelah maitola teh a pho, a moi, a thi hoi a ei hai a mithmu vah hmaisawi han. ");
INSERT INTO cth_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Vaihma ni sidar thing hoi dingsala hoi langsan a la vaiteh, maitola hmaisawinae koe a tâkhawng han. ");
INSERT INTO cth_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Vaihma ni a khohna a pâsu vaiteh, tui a kamhluk han. Hahoi roenae hmuen koe a cei han, tangmin totouh vaihma teh a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Hmai kasawikung ni hai amae khohna a pâsu vaiteh tui a kamhluk han, tangmin totouh a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Kathounge ni maitola hraba hah a kawn vai teh, rapan hloilah thoungnae hmuen koe a ta vaiteh, Isarel catounnaw, tamimaya hanlah kamthoungnae tui dawk a hno han, hethateh yon thung hoi thoungnae doeh. ");
INSERT INTO cth_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Hahoi maitola hraba kakawnkung teh, a khohna a pâsu vaiteh, tangmin totouh a khin han. Hethateh Isarel catounnaw hoi ahnimouh koe kaawm e imyinnaw hanlah a yungyoe phunglam lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Bangpatetlae tami ro nakunghai katekkung teh hnin sari touh thung a khin han rah. ");
INSERT INTO cth_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Hahoi tami teh hnin thum hnin vah hraba hoi a kamthoung vaiteh, hnin sari hnin vah a thoung han. Apâthum hnin kamthoung hoehpawiteh, asari hnin totouh a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Tami bangpatet ni hai Bangpatete tami ro hai a tek awh teh kamthoung awh hoehpawiteh, BAWIPA lukkareiim kakhinsakkung lah ao teh, hote tami teh Isarel taminaw thung dawk hoi hnoun e lah ao han. Kamthoungnae tui ahnimouh koe kathek sin lah ao hoeh dawkvah, a khin han. A khinnae hah ahnimouh koe ao rah. ");
INSERT INTO cth_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Tami buet touh lukkareiim dawk dout pawiteh, hetheh kâlawk lah ao han. Lukkareiim dawk kâen e pueng teh lukkareiim dawk kaawm e pueng hnin sari touh thung a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Hahoi hlaam a khuem kâkhuem hoeh e puenghai a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Hahoi tami bangpatet ni law vah, tahloi hoi a thei awh e thoseh, ao navah kadout e ro thoseh, tami kadout e hru thoseh, tangkom dawk thoseh, tek pawiteh hnin sari touh a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Hahoi kathoung hoeh naw hanlah, yon thoung nahanlah hmaisawi e, maitola hraba teh a la vaiteh, amamae tongben dawk, ka lawng e tui a ta awh han. ");
INSERT INTO cth_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Hahoi kathounge ni dingsala a la vaiteh, tui dawk a padung han. Hahoi lukkareiim hlaamnaw pueng hai haw e kaawmnaw pueng hraba thoseh, ka tek e pueng teh be a kahei sin han. ");
INSERT INTO cth_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Hahoi kathounge naw ni apâthum hnin hoi asari hnin vah kathoung hoeh pueng a kahei sin han, a khohna a pâsu hoi tui a kamhluk vaiteh tangmin lah teh a thoung han. ");
INSERT INTO cth_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Hatei kakhin e ka kamthoung hoeh e niteh, BAWIPA e hmuen kathoung a khin sak dawkvah, hote tami teh kamkhueng e tamihu thung hoi takhoe e lah ao han. Kamthoungnae tui hah ahni koe kahei sin lah ao hoeh dawkvah, kakhin e lah ao. ");
INSERT INTO cth_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Hetheh ahnimouh han a yungyoe phunglam lah ao han. Kamthoungnae tui kahei sin e pueng ni a khohna a pâsu han, hahoi a kamthoungnae tui kateknaw pueng teh tangmin totouh a khin han. ");
INSERT INTO cth_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Kathounghoehe naw ni a tek e pueng teh kakhin e lah awm toung vaiteh, hot hno kateknaw pueng teh, tangmin totouh a khin han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Hahoi Isarel catounnaw pueng teh, thapa yung pasuek dawkvah, Zin kahrawngum dawkvah a kâen awh. Taminaw pueng teh, Kadesh vah a hnin ao awh. Hawvah, Miriam a due teh hawvah a pakawp awh. ");
INSERT INTO cth_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Hahoi taminaw pueng hanlah tui nei han awm hoeh toe. Hat toteh, haw vah Mosi hoi Aron taran lahoi a kamkhuengsin awh. ");
INSERT INTO cth_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Taminaw pueng ni BAWIPA hmalah hmaunawnghanaw a due nah dout ngala boipawiteh, ");
INSERT INTO cth_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","bangkongmaw BAWIPA e taminaw hete kahrawngum vah kamamanaw hoi saringnaw abuemlah due hanlah na ceikhai. ");
INSERT INTO cth_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Bangkongmaw het patet kahawihoehe ram dawkvah kâenkhai hanlah Izip ram hoi na tâcokhai. Tâsong, thaibunglung kung, misurkung, tale paw hai o hoeh nah koe, tui boehai nei hane ao hoeh nah koe, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mosi hoi Aron teh tamimaya koehoi kamkhuengnae lukkareiim takhang koe a cei roi teh, a tabo roi. Hahoi ahnimouh roi koe BAWIPA bawilennae a kamnue. ");
INSERT INTO cth_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","sonron lat nateh, nang hoi na hmau Aron ni taminaw pâkhueng awh. Ahnimae mithmu vah lungsongpui koe lawk dei pouh. Tui a tâcosak han. Hot patetlah hoiyah, lungsongpui dawk hoi tui na tâcosak vaiteh, taminaw pueng hoi saringnaw hah na nei sak han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Hot patetlah Mosi ni BAWIPA hmalah sonron hah kâ a poe e patetlah a la. ");
INSERT INTO cth_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mosi hoi Aron ni taminaw pueng hah lungsongpui teng a pâkhueng teh, ahnimouh koe, taran ouk ka thaw e taminaw, atu thai awh haw! hete lungsong dawk hoi nangmouh han tui ka tâcosak roeroe han maw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Hahoi teh Mosi ni a kut a dâw teh, a sonron hoi lungsongpui hah vai hni touh a hem, hat toteh, tui kapap poung lah a tâco. Taminaw pueng hoi saringnaw ni a nei awh. ");
INSERT INTO cth_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","BAWIPA ni Mosi hoi Aron koe kai na yuem hoeh teh, Isarel catounnaw mithmu vah, kai na barilawa hoeh dawkvah, hete taminaw pueng teh kai ni na poe awh e ram dawk na kâenkhai mahoeh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Isarel catounnaw ni BAWIPA rek a cusin awh teh ahnimouh thung vah ama barilawa hanlah ao dawk hote tui teh Meribah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Hahoi Mosi ni Kadesh hoi Edom siangpahrang koevah, patounenaw a patoun. Na hmaunawngha Isarel ni hettelah a dei. Maimouh koe ka phat e runae kathonaw pueng, ");
INSERT INTO cth_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","mintoenaw Izip ram a cei awh teh, moikasaw lah Izip ram vah ka o awh teh, Izipnaw ni kai koe hoi mintoenaw totouh rucatnae na poe e hah na panue. ");
INSERT INTO cth_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","BAWIPA koe ka hram awh e lawk hah a thai teh, kalvantaminaw a patoun teh, Izip ram hoi na tâco sak. Khenhaw, na ram hoi ka hnai poung lah, Kadesh khopui dawkvah ka o awh. ");
INSERT INTO cth_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Pahren lahoi na ram thung pou na rakan sak haw. Law thoseh, misur takha thoseh, ka coungroe awh mahoeh. tuikhu dawk e tui hai ka net mahoeh. Siangpahrang lamthungpui dawk doeh ka cei awh han, na ram ka tapoung hoeh roukrak avoilah aranglah hai kampuen awh mahoeh, telah ati. ");
INSERT INTO cth_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edom ni kai ka ram dawk na cet awh mahoeh, telah hoehpawiteh, nangmouh tuk hanelah tahloi hoi kamthaw awh han, telah ati. ");
INSERT INTO cth_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Isarel catounnaw ni lamthungpui dawk hoi ka cei awh vaiteh kamamouh hoi ka saringnaw ni na tui ka net awh pawiteh, aphu na poe awh han, hno alouke banghai sak laipalah, raka lah doeh pou ka raka awh ti telah atipouh awh. ");
INSERT INTO cth_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ahni ni na raka awh mahoeh atipouh. Hahoi teh, Edom teh tami moikapap hoi tami athakaawme taminaw hoi ahnimouh tuk hanlah a kamthaw awh. ");
INSERT INTO cth_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Hot patetlah Isarel catounnaw teh Edom ni a ram dawk dei hanlah pasoung awh hoeh. Hahoi Isarel teh ahnimouh koehoi a kamlang takhai awh. ");
INSERT INTO cth_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Hothloilah Isarelnaw pueng teh Kadesh hoi a kamthaw awh teh, Hor mon koe a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","BAWIPA ni Mosi hoi Aron teh Edom khori koe Hor mon hoi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aron teh a taminaw koe ceikhai han toe. Bangtelah tetpawiteh, Isarel catounnaw koe ka poe e ram dawk kâen mahoeh. Bangkongtetpawiteh, Meribah tui koe ka lawk taran lahoi taran a thaw awh. ");
INSERT INTO cth_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aron hoi a capa Eleazar hah Hor mon koe a luenkhai awh. ");
INSERT INTO cth_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aron e khohna rading awh nateh, a capa Eleazar kâkhu sak awh. Bangkongtetpawiteh, Aron teh a taminaw koe ceikhai vaiteh, haw vah a due han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mosi ni BAWIPA kâ poe e patetlah a sak teh, taminaw pueng e mithmu vah Hor mon vah a luen awh. ");
INSERT INTO cth_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Mosi ni Aron e khohna a rading pouh teh, Eleazar a kho sak teh, Aron teh monsom vah a due. Hottelah Mosi hoi Eleazar teh monsom hoi a kum roi. ");
INSERT INTO cth_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Taminaw pueng ni Aron a due tie a thai awh toteh, Isarelnaw pueng ni Aron teh hnin 30 touh a khui awh. ");
INSERT INTO cth_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Kanaannaw Arad siangpahrang akalae kaawm e niyah, Isarelnaw, Atharim lam koe lah a tho awh ti a thai awh toteh, Isarelnaw hah a tuk awh teh, a tangawn san lah a man awh. ");
INSERT INTO cth_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Hottelah Isarelnaw ni BAWIPA koevah lawk a kam awh teh, hetnaw heh kaimouh kut dawk na poe pawiteh, a khopui hah peng ka raphoe thai han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","BAWIPA ni Isarelnaw e lawk a tarawi pouh teh, Kanaannaw teh a kut dawk poe lah ao. Amamouh hoi a khopuinaw hah he a raphoe teh, hote hmuen teh Hormah telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Hor mon koehoi tuipui paling koelah Edom ram lawngven lahoi a cei awh. Lam ekvoi a kâhei awh dawkvah, taminaw pueng teh a lungkuep laipalah, ");
INSERT INTO cth_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Cathut hoi Mosi taranlahoi kahrawngum vah due hanelah bangkongmaw Izip ram hoi na tâcokhai. Vaiyei hai awm hoeh, tui hai awm hoeh, hete vaiyei karawcap e hai ka hringnae ni a panuet toe, telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Hatdawkvah, BAWIPA ni hmai tahrun a thasin teh, taminaw a khue dawkvah moikapap a due awh. ");
INSERT INTO cth_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Hatnavah taminaw ni Mosi koe a tho awh teh, BAWIPA hoi nang koe taranlahoi lawk ka dei e hah ka yon awh toe. Tahrunnaw hah kaimouh koehoi takhoe hanlah BAWIPA koe na kâhet pouh leih, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","BAWIPA ni Mosi koe hmai tahrun hah sak nah teh khom dawk hoi pathout pouh. Tahrun ni a khue e pueng ni hote hah a khet vaiteh a hring awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Hahoi Mosi ni rahum tahrun hah a sak teh, khom dawk a vo. Hahoi teh tahrun ni a khue e pueng rahum tahrun hah a khet awh teh a dam awh. ");
INSERT INTO cth_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Isarel catounnaw teh, pou a kâtahruet awh teh, Oboth vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Oboth hoi bout a cei awh teh, Kanîtholah Moab kahrawng teng Iyeabarim vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Haw hoi a cei awh teh Zered tanghling dawk a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Haw hoi bout a cei awh teh, Amornaw e ramri hoi pou kâkuen e Arnon namran lah a roe awh. Arnon teh Moab ramri, Moab hoi Amornaw rahak vah kaawm e doeh. ");
INSERT INTO cth_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Hatdawkvah, BAWIPA tarantuknae cauk dawk, Suphat hoi Vaheb Arnon, Arnon sawkcanaw hoi. ");
INSERT INTO cth_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Ar kho lahoi ka lawng e sawkcanaw hai, Moab ramri lahoi a teng poe ka lawng e telah a dei awh. ");
INSERT INTO cth_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Hahoi, Beer lah a cei awh. Haw teh BAWIPA ni Mosi koevah, taminaw pueng hah kaw nateh, tui ka poe han ati nae tuikhu koe doeh. ");
INSERT INTO cth_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Hahoi hete la heh Isarelnaw ni a sak awh. Oe tuiphuek tâcawt haw telah la heh a phueng awh ");
INSERT INTO cth_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kahrawikungnaw a bonae tuikhu hah kâlawk kapoekung sonron hoi tai e, miphunnaw kahrawikung ni a tai e, ti hoiyah, hote kahrawng koehoi Mattanah lah a cei awh. ");
INSERT INTO cth_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mattanah hoi Nahaliel, Nahaliel hoi Bamoth, ");
INSERT INTO cth_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bamoth hoi Moab ram kaawm e tanghling, Pisgah som kho ouk khetnae hmuen, hmu thainae koe a kâtahruet awh. ");
INSERT INTO cth_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isarelnaw ni Amornaw e siangpahrang Sihon koevah, na ram dawk hoi kaimouh na rakan sak haw. Na law dawk thoseh, misur takha dawk thoseh, ka cet awh mahoeh. Na tuikhu dawk e tui hai ka net awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Na ram ka tapoung hoeh roukrak, siangpahrang lamthungpui dawk doeh ka cet awh ti telah patounenaw a patoun. ");
INSERT INTO cth_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Hatei, Sihon ni a ram dawk rakan sak hane pasoung hoeh. Hottelah Sihon ni a taminaw pueng a pâkhueng teh, Isarelnaw tuk hanlah kahrawngum a kamthaw awh. Jahaz vah a pha awh teh Isarelnaw hah a tuk awh. ");
INSERT INTO cth_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Isarelnaw ni, kahran e tahloi hoi a tuk awh van teh a ram teh Arnon hoi Jabbok totouh, Ammon catounnaw ram totouh a la pouh awh. Bangkongtetpawiteh, Ammonnaw e ramri teh pou a patoup awh e doeh. ");
INSERT INTO cth_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Isarelnaw ni khonaw pueng koung a la awh. Hottelah Isarelnaw teh, Ammonnaw e khonaw pueng dawk Heshbon hoi khotenaw pueng dawk kho a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshbon kho teh Ammornaw e siangpahrang Sihon onae kho doeh. Ahni teh Moab siangpahrang hoi taran a kâtuk teh a kut dawk e a ram naw pueng Arnon palang kalatkung doeh. ");
INSERT INTO cth_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Hatdawkvah, la ka phuengkung ni, Heshbon vah tho loe, Sihon khopui teh bout thawng awh sei, bout pathoup awh sei. ");
INSERT INTO cth_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Bangkongtetpawiteh, Heshbon hoi hmai a tâco teh, Sihon khopui hoi hmai a to. Moab khopui Ar kho koung a kak. Arnon hmuenrasang bawinaw hoi, ");
INSERT INTO cth_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Oe Moab na yawthoe, nang teh na kahma toe. Khemosh taminaw, Amornaw e siangpahrang koevah, a capanaw yawngkhai hane hoi, a canunaw a san lah a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Hatei, kai ni na tâ awh toe. Heshbon teh Dibon totouh a kahma. Hottelah Nophah kho totouh a raphoe teh, hot ni teh Medeba totouh a pha. ");
INSERT INTO cth_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Hot patetlah Amornaw e ram koe Isarelnaw teh kho a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Hahoi Mosi ni Jazer tuet hanlah tami a patoun. Hote kho a la teh, haw vah kaawm e Amor taminaw a pâlei awh. ");
INSERT INTO cth_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","A ban awh teh, Bashan lam koe lah a takhang awh. Bashan siangpahrang Og teh ahnimouh tuk hanelah ama hoi a taminaw pueng hoi Edrei hoi tuk hanelah a kamthaw awh. ");
INSERT INTO cth_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","BAWIPA ni Mosi koevah ahni teh taket hanh loe. Ama hoi a taminaw khuehoi a ram totouh na kut dawk na poe toe. Heshbon e kaawm e Amornaw e siangpahrang Sihon koevah na sak e patetlah na sak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Hahoi teh ama thoseh, a capanaw thoseh, buet touh boehai pâhlung laipalah a taminaw pueng hoi a thei awh teh a ram teh hmawi a tawn pouh awh. ");
INSERT INTO cth_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Isarel catounnaw teh pou a cei awh teh, Jeriko kho namran lah Jordan palang na ran Moab tanghling dawk a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Zippor capa Balak ni Isarelnaw ni Amornaw lathueng a sak e naw pueng a thai. ");
INSERT INTO cth_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Tamimaya hah apap poung dawkvah, Moab ni taki lah a taki katang. Isarelnaw kecu dawk Moab teh kângairu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Hottelah Moab ni Midian a lungkahanaw koe Maito ni hram koung a ai e patetlah hete taminaw ni kaimae tengpam e taminaw pueng koung a i han doeh telah ati. Hote tueng navah Zippor capa Balak teh Moab siangpahrang lah ao. ");
INSERT INTO cth_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Ahni ni khenhaw! miphun buet touh Izip ram hoi ka tâcawt e ao teh, talai dawk muen a kawi awh. Kaimouh rahak vah sut ao awh. Pahren lahoi tho nateh hetnaw heh thoebo haw. Bangkongtetpawiteh kai hane teh a thasaipoung awh. ");
INSERT INTO cth_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ahnimanaw tâ vaiteh ram dawk hoi ka pâlei thai yawkaw han kai ma. Bangkongtetpawiteh, yawhawi na poe e teh yawhawi e lah ao, thoe na bo e pueng teh thoebo lah ao tie ka panue, telah kaw hanelah na catounnaw a onae ram, palang teng vah, Pethor e Beor capa Balaam koevah patounenaw a patoun. ");
INSERT INTO cth_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Hatdawkvah, Moab a lungkahanaw hoi Midian a lungkahanaw teh thoebo sak phu poe hanelah tadawnghno sin hoi a cei awh teh, Balaam koe a pha awh. Balak ni lawkthui e hah a dei pouh awh. ");
INSERT INTO cth_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ahni ni, atu tangmin lah teh awi hi vah roe awh. BAWIPA ni na dei pouh e patetlah nangmouh koe lawk na thui awh han telah atipouh. Hottelah, Moab tami kalennaw teh Balaam koe a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Balaam koe Cathut a tho teh nang koe kaawm e taminaw heh bangpatetnaw maw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam ni Cathut koevah, Zippor capa Moab siangpahrang Balak ni kai koevah, ");
INSERT INTO cth_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","khenhaw! Izip ram hoi ka tho e miphun ni talai dawk muen a kawi awh. Ahnimouh ka tâ vaiteh, ka pâlei thai nahanelah thoe na bo pouh haw, a titeh, taminaw a patoun e doeh telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Cathut ni Balaam koevah, ahnimouh koe cet hanh, hotnaw teh thoe hai bo hanh. Bangkongtetpawiteh, ahnimouh teh yawkahawi e tami doeh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam teh amom a thaw teh Balak e tamikalennaw koe, na ram lah ban awh leih, bangkongtetpawiteh, BAWIPA ni nangmouh koe cei hanlah na pasoung hoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Moab tamikalennaw teh, a thaw awh teh Balak koevah a cei awh. Ahni koe Balaam ni maimouh koe kâbang ngai hoeh atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak ni ahnimouh hlak kapap, ahnimouh hlak minhmai khet kaawm, tamikalennaw hah bout a patoun. ");
INSERT INTO cth_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Balaam koevah, a pha awh teh, Zippor capa Balak ni telah ati, kai koe na kâbang hane bang ni hai na ngang hanh naseh. ");
INSERT INTO cth_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Bangkongtetpawiteh, barilawa kaawm lah na tawm katang han, kai koe na dei e pueng ka sak han, hatdawkvah, tho nateh hetnaw heh thoe na bo pouh haw ati telah ati. ");
INSERT INTO cth_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam ni Balak e sannaw hah a pathung teh ahnimouh koe Balak ni a im hoi athung vah sui ngun khakkawi lah na poe han nakunghai, BAWIPA ka Cathut lawk hloilah banghai ka sak thai hoeh. ");
INSERT INTO cth_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Hatdawkvah, BAWIPA ni kai koe bangmaw bout a dei han, atu tangmin teh hi roe awh ei telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Hat hnin tangmin vah Balaam koe Cathut a tho teh, ahnimouh koe, hetnaw heh nang na kaw hanlah tho pawiteh, thaw nateh ahnimouh koe kâbang. Hatei nang koe ka dei e dueng na sak han, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam teh amom vah a thaw teh, la hah a rakueng, Moab tamikalennaw koevah a kâbang. ");
INSERT INTO cth_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Hottelah, a cei kecu dawkvah, Cathut lungkhueknae a kaman teh, BAWIPA kalvantami teh ama ngang hanelah lam dawk sut a kangdue. Ama teh la dawk kâcui niteh, a san kahni touh hoi haw vah ao. ");
INSERT INTO cth_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","La ni BAWIPA kalvantami ni tahloi patuep hoi lam dawk a kangdue e hah a hmu teh, lam a phen teh kahrawng lahoi a cei. Hottelah Balaam ni la teh lam dawk ban hanelah a hem. ");
INSERT INTO cth_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","BAWIPA kalvantami teh misur takha hoi takha rahak e lam koe bout a kangdue. ");
INSERT INTO cth_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","La ni BAWIPA kalvantami hah bout a hmu toteh, misur takha rai lah a kâhnawn dawkvah, Balaam khok pak a kuen. Balaam ni bout a hemkhai. ");
INSERT INTO cth_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","BAWIPA kalvantami ni teh, a hmalah rek bout a cusin teh avoilah, aranglah kamheithaihoehnae lamceknae koe a kangdue pouh. ");
INSERT INTO cth_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","La ni, BAWIPA kalvantami hah a hmu teh Balaam teh rawk a tabo khai. Hahoi, Balaam a lungkhuek teh, a sonron hoi la teh a hem. ");
INSERT INTO cth_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","BAWIPA ni la hah a lawk a thosak. Balaam koevah nang na tak dawk bangmaw ka sak, vai thum touh totouh kai na hemkhai telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam ni la koevah, nang ni kai na noutna hoeh teyaw, tahloi ka sin nah pawiteh, na thei han ei nan maw atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","La ni Balaam koevah, sahnin totouh na kâcui e la nahoehmaw. Hettelah nang koe ouk ka sak boimaw, telah ati. Ahni ni na sak boihoeh bokheiyah telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","BAWIPA ni Balaam mit hah a ang sak teh, BAWIPA kalvantami tahloi hoi lam dawk sut a kangdue e hah a hmu. A saling teh talai dawk minhmai rek kâbet lah a tabo. ");
INSERT INTO cth_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","BAWIPA kalvantami ni ahni koe, bangkongmaw, vai thum totouh la na hem. Khenhaw! na cei hoeh nahan koelah na cei kecu dawkvah, nang ngang hanlah ka tâco. ");
INSERT INTO cth_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","La ni na hmu teh ka hmalah vai thum touh na roun. Na roun hoehpawiteh, la teh thet hoeh vaiteh, nang nama nouh thei lah na awm ei ti heh ma, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam ni BAWIPA kalvantami koevah, ka yon toe, bangkongtetpawiteh, kai taranlahoi lam na kangdue tie ka panuek hoeh, hatdawkvah na lunghawihoeh pawiteh ka ban han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","BAWIPA e kalvantami ni Balaam koevah, hetnaw koe vah cet, hateiteh, nang koe ka dei e dueng ahnimouh koe na dei pouh han telah atipouh. Hahoi teh, Balaam teh Balak e tami kalennaw koe a cei. ");
INSERT INTO cth_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak ni Balaam a tho tie hah a panue toteh, Arnon koelae ramri Moab khopui totouh a dawn awh. ");
INSERT INTO cth_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak ni Balaam koevah, atangcalah nang la hanlah tami ka patoun nahoehmaw. Bangkongmaw kai koe na tho ngai hoeh. Tamikalen poung lah na coung sak thai mahoeh maw, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam ni Balak koevah, khenhaw! nang koe vah ka tho toe. Bang hno pueng deithainae kâ ka tawn na maw. Cathut ni ka pahni dawk a ta e dueng doeh ka dei tih, telah ati. ");
INSERT INTO cth_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Hottelah Balaam teh Balak koe a cei teh, Kiriath-huzoth vah a pha awh. ");
INSERT INTO cth_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak ni maito hoi tu hoi thuengnae a sak. Balaam hoi ama koe kaawm e tamikalennaw koe youn touh a poe. ");
INSERT INTO cth_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Hahoi a tangtho vah, Balak ni Balaam a hrawi teh, tamimaya hah pâtue hanelah, Baal hmuenrasang koe a luenkhai. ");
INSERT INTO cth_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Hahoi, Balaam ni Balak koevah, hivah thuengnae khoungroe sari touh na sak pouh loe. Maitotan sari touh, tutan sari touh kai hanlah na rakueng pouh loe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak ni Balaam dei e patetlah a sak. Balak hoi Balaam ni bawknae khoungroe tangkuem vah, maitotan buet touh hoi tutan buet touh a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam ni Balak koevah, nang ni hmaisawi thuengnae teng vah, pou kangdout lah a, kai teh alouk lah yo ka cet eivai, BAWIPA ni kai pato hanlah a tho thai, hahoi na dei pouh e pueng kai ni nang koe na dei pouh han telah atipouh. Hahoi kacailum e hmuenrasang koe a cei. ");
INSERT INTO cth_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Cathut ni Balaam a kâhmo teh ahnimouh ni ama koe bawknae khoungroe sari touh ka sak toe. Bawknae khoungroe buet touh dawk maitotan buet touh, tutan buet touh rip ka poe toe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Hottelah BAWIPA ni Balaam koe pahni dawk lawk hah a ta pouh teh, ahni koe Balak koe ban nateh, hettelah patuen dei pouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Hahoi ahnimouh a ban teh, khenhaw, hmaisawinae a kung koe ama hoi Moab tami kalennaw teh pou a kangdue teh, ");
INSERT INTO cth_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","ahni ni lawk hah a pâpho pouh teh, a ram lahoi Balak ni a ceikhai teh, Kanîtholae mon Moab siangpahrang ni tho haw, Jakop hah thoebo haw, tho haw, Isarel hah na pathoe pouh haw telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Bangtelamaw, Cathut ni thoebo hoeh e thoe louk ka bo han, bangtelamaw, Cathut ni pathoe hoeh e louk ka pathoe han. ");
INSERT INTO cth_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Bangkongtetpawiteh, lungsongpui dawk ahnimouh teh ka hmu teh, monpui dawk hoi ahnimouh teh ka khet. Khenhaw! miphun louk lah doeh ao awh. Jentelnaw koe pareisin hanlah awm hoeh. ");
INSERT INTO cth_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Jakop vaiphu teh apinimaw a touk thai han. Isarel pung pali pung touh teh apinimaw a touk thai han. Tamikalan due e patetlah dout van boipawiteh, ka poutnae teh a poutnae lah thoseh, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak ni Balaam koevah, na sak e teh bangtelae na maw. Ka tarannaw thoebo hanlah na hrawi teh, yawhawi dai na poe atipouh. ");
INSERT INTO cth_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Ahni ni BAWIPA ni ka pahni dawk a ta e lawk ka dei mahoeh na maw telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak ni alouklah cet ei, haw hoi teh na hmu thai nahanlah a onae hmuen ram pueng be na hmu han, abuemlahoi teh be na hmawt mahoeh ei, hot hmuen koehoi ahnimouh teh thoe na bo pouh han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Hottelah, Zophimnaw onae Pisgah monsom dawk a luenkhai. Thuengnae khoungroe sari touh a sak teh, hote thuengnae khoungroe tangkuem dawk maitotan buet touh hoi tutan buet touh rip a poe. ");
INSERT INTO cth_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balak koevah, hawvah, BAWIPA ka kâhmo navah, hmaisawi thuengnae a kung koe pou ka kangdout loe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","BAWIPA ni Balaam a kâhmo teh a pahni dawk lawk a ta pouh. Balak koe ban nateh hettelah patuen dei pouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ahni koe a cei sin teh, khenhaw! hmaisawi thuengnae akung koevah, a kangdue teh, Moab tami kalennaw hai ahni koe ao. Balak ni BAWIPA ni bangtelamaw a dei telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Hahoi teh ahni ni lawk hah a pâpho teh, thaw haw, Balak ka lawk thai haw, Zippor capa ka lawk hah thai haw. ");
INSERT INTO cth_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Cathut teh laithoe ka dei e tami nahoeh. Pankângai e tami capa lahai tho hoeh. A dei e teh sak mahoeh na maw. A dei tangcoung e hah kuep sak mahoeh na maw. ");
INSERT INTO cth_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Khenhaw! yawhawi poe hanelah kâlawk ka hmu teh, a yaw ahawi sak toung dawkvah, kâthung thai mahoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Jakop koe payonpakainae hmawt hoeh niteh, Isarel hawihoehnae hmawt hoeh. Jehovah a Cathut ni a okhai teh, siangpahrang hramnae lawk ahnimouh koe ao. ");
INSERT INTO cth_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Izip ram hoi a tâcokhai teh, sakraktan patetlah a thaonae a tawn. ");
INSERT INTO cth_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Bangkongtetpawiteh, taân ni Jakop teh tâ thai hoeh, hmaui ni Isarel teh tâ thai hoeh. Jakop hoi Isarel koevah, Cathut hno sak e hah dei lah kaawm roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Khenhaw! taminaw teh sendekmanu patetlah a thaw teh, sendek patetlah a dawkcawk teh, a kei awh e moi a ca hoehroukrak teh, a kei awh e moi thi a nei hoehroukrak teh duem awm awh mahoeh, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak ni Balaam koevah thoebo hanh leih. Yawhawi hai poe hanh leih, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Hatei Balaam ni a pathung, BAWIPA ni a dei e naw pueng teh ka sak roeroe hane doeh, telah ka dei nahoehmaw telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Hahoi Balak ni Balaam koevah, tho haw, alouklah na ceikhai han, awi haw kangna teh Cathut ni thoe na bo sak hanelah ahawi ati ta panue maw, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Hottelah Balak ni Balaam teh kahrawng khetnae Peor mon som a luenkhai. ");
INSERT INTO cth_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam ni Balak koevah, hivah thuengnae khoungroe sari touh na rakueng pouh loe, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak ni Balaam dei e patetlah a sak pouh teh thuengnae khoungroe tangkuem maitotan buet touh hoi tutan buet touh rip a poe. ");
INSERT INTO cth_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Hot patetlah Isarel yawhawi poe e hah BAWIPA a ngainae lah doeh ao tie hah Balaam ni a panue toteh, ahmoun ouk a sak e patetlah taânnae hno hanlah cet laipalah kahrawngum lah letlang a pâtam. ");
INSERT INTO cth_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam ni a khet teh Isarelnaw hah ama miphun aloukcalah ao e hah a hmu. Cathut e Muitha hah ahnimouh koe a pha. ");
INSERT INTO cth_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Hahoi lawk hah a pâpho teh, Beor capa Balaam mit a ang sak, ");
INSERT INTO cth_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Cathut lawk hah thai hoi, Athakasaipounge kamnuenae hah a hmu hoi, ka tabawk ni teh a mit ka padai e ni, ");
INSERT INTO cth_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Oe Jakop na rim teh ahawi. Oe Isarel na khosaknae teh ahawi doeh. ");
INSERT INTO cth_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Tanghling patetlah a kâphai. Palang teng e takha patetlah BAWIPA ni a ung e sumpakung hoi, palang teng e Sidar thing patetlah doeh ao. ");
INSERT INTO cth_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Khotui moikapap a coe vaiteh, tui apapnae koe cati a patue awh han. Agag hlak vah a siangpahrang a rasang vaiteh, a uknaeram teh tawmtakhang han. ");
INSERT INTO cth_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Izip hoi Cathut ni a tâcokhai teh, sakraktan patetlah a thao awh. A taran Jentelnaw hah cat awh vaiteh, a hru hah vitpatit lah a dêi awh han. A samtang hoi pawkkayawng lah a ka awh han. ");
INSERT INTO cth_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","A tabut awh teh, sendekmanu patetlah a tabo teh apinimaw a pathaw ngam han. Yawhawi na kapoekung hah yawhawi poe nateh, thoe na ka bo naw hah thoebo awh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Hat toteh, Balaam tak dawk Balaam a lung a kâan teh, Balak ni Balaam koevah, ka taran thoebo hanlah na kaw. Hatei, khenhaw! vai thum totouh yawhawi na poe. ");
INSERT INTO cth_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Hatdawkvah, na onae koe kahmakata han lah cet. Ka taluepoung e lah tawmrasang hanlah ka kâcai e doeh. Khenhaw! hatei, BAWIPA ni tawmtakhang hanlah na pasoung hoeh toe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam teh Balak ni sui ngun yikkawi lah na ka poe nakunghai, ");
INSERT INTO cth_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","ahawinae koe lah thoseh, thoenae koelah thoseh, kai kama lung lahoi teh, BAWIPA lawk hloilah sak thai e banghai ka tawn hoeh. BAWIPA ni a dei e pueng ka dei han telah na patoun e patounenaw pueng koehai ka dei nahoehmaw. ");
INSERT INTO cth_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Khenhaw! ka taminaw koe ka cei han toe. Tho haw hete taminaw ni, hma lae tueng dawk na taminaw koe a sak hane kong dawk pouknae na poe han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ahni ni lawk hah a pâpho teh, Beor capa Balaam mit a ang sak teh, ");
INSERT INTO cth_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Cathut lawk hah thai hoi, Lathueng Poung e panuenae tha panue hoi, Athakasaipounge vision a hmu teh, a tabo hoi a mit ka ang e ni ");
INSERT INTO cth_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","ama teh ka hmu, hatei atu nahoeh. Ama teh ka khet, hatei kahnaicalah nahoeh. Jakop koehoi Âsi a tâco han. Isarel koehoi siangpahrang sonron a tâco han. Moab ram pawkkayawng lah a cuek vaiteh, Sethnaw hai be a raphoe awh han. ");
INSERT INTO cth_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","A taran lah ouk kaawm e Edom hoi Seir hai a coe han. Isarel kangduenae ahawi nah thung pueng teh, kaukkung buet touh a tawn awh han. ");
INSERT INTO cth_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Jakop koehoi kaukkung buet touh a tawn vaiteh, kacawirae khonaw hah a raphoe awh han. ");
INSERT INTO cth_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Amalek lah kangvawi hoi lawk hah a pâpho. Amalek teh miphun kung pui lah ao eiteh, hatei hnukteng teh rawkphainae lah ao. ");
INSERT INTO cth_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kennaw lah kangvawi laihoi lawk a pâpho. Na onae hmuen teh a cak. Na tabu teh lungsong dawk na tuk. ");
INSERT INTO cth_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Hatei, Ken teh, hmaisawi lah ao vaiteh, Asshur ni san lah na hrawi totouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Lawk hah bout a pâpho teh, Aiyoe, Cathut ni hetheh a sak toteh apimaw ka hring thai han. ");
INSERT INTO cth_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Hatei, Cyprus tuilum koehoi long phat vaiteh, Asshur hoi Eber hah runae a poe han. Amalek a kahma totouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Hahoi teh Balaam a thaw teh a onae hmuen koe a ban teh, Balak hai a ban van. ");
INSERT INTO cth_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Isarel teh shittim kho a sak navah, taminaw pueng teh Moab napui koe kâyo hanlah a kamtawng awh. ");
INSERT INTO cth_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","A cathut koe thuengnae a sak navah, ouk a coun awh. Taminaw pueng ni a canei awh teh, a cathut koe ouk a tabo awh. ");
INSERT INTO cth_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Isarel teh, Peor e hmuen koe Baal hoi a kâkuet awh teh, Isarel koe BAWIPA lungkhueknae teh a kâan. ");
INSERT INTO cth_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","BAWIPA ni Mosi koevah takikatho poung e BAWIPA lungkhueknae teh, Isarel koe lahoi a roum thai nahanlah tamimaya kahrawinaw pueng hah a ceikhai awh teh, kanîthun vah, kâtapoenaw pueng hah BAWIPA hmalah kamcengcalah kaithi sak haw telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Hatdawkvah, Mosi ni Isarel lawkcengkungnaw koevah, Peor hmuen koe Baal kabawknaw pueng koung thet awh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Khenhaw! Isarel catounnaw thung dawk tami buet touh ni kamkhuengnae lukkareiim takhang koe a khuika navah, Mosi mithmu hoi Isarel catoun tamimaya mithmu vah, Midian napui buet touh a hmaunawnghanaw koe a thokhai. ");
INSERT INTO cth_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Vaihma Aron e capa Eleazar capa Phinahas ni a hmu toteh, tamimaya koehoi a thaw teh tahroe hah a la. ");
INSERT INTO cth_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Isarelnaw teh lukkareiim thung vah a pâlei teh kahni touh roi hoi pawkkayawng lah a thut. Isarel tami hoi napui teh a vawn dawk a thut teh, Isarel catounnaw koe lacik hah a roum. ");
INSERT INTO cth_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Hote lacik hoi kadoutnaw teh 24000 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","vaihma Aron capa Eleazar capa Phinehas ni Isarel catounnaw koe ka lungkhueknae ka roum sak toe. Bangkongtetpawiteh, ka lungkhueknae ni Isarel catounnaw a raphoe hoeh nahanelah, ahnimouh rahak ka dipmanae patetlah a kâdipma awh van han. ");
INSERT INTO cth_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Hatdawkvah, khenhaw! roumnae ka lawkkam teh, ama koevah ka poe. ");
INSERT INTO cth_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ama hoi a catounnaw hanlah, a yungyoe vaihma lah a onae lawkkam lah ao han. Bangkongtetpawiteh, dipma Cathut teh, Isarel catounnaw hanlah yonthanae a sak tet awh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isarelnaw Midian napui hoi a thei awh e min teh Simeonnaw thung dawk imthungkhu kahrawikung Salu capa Zimri doeh. ");
INSERT INTO cth_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Midian napui a thei awh e min teh Midian imthungkhu kahrawikung Zur canu Kozbi doeh. ");
INSERT INTO cth_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Midiannaw teh reksaueng nateh tuk awh. ");
INSERT INTO cth_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Bangkongtetpawiteh, Peor kecu dawk lacik a tho navah, a tawncanu, Midiannaw kahrawikung canu Kozbi a thei awh e kong dawkvah, nangmouh lathueng kalanhoehe hno sak hoi na tarawk awh toe telah ati. ");
INSERT INTO cth_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Lacik pawng a kâkayaw hoi BAWIPA ni Mosi hoi vaihma Aron capa Eleazar hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Isarel catounnaw pueng hah kum 20 lathueng amamae miphun lahoi Isarel ram dawk e tarantuknae koe kacetthainaw pueng hah be touk loe atipouh. ");
INSERT INTO cth_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mosi hoi vaihma Eleazar ni Jeriko avanglah Jordan palang teng Moab tanghling dawk ahnimouh teh a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","BAWIPA ni Mosi hoi Izip ram hoi katâcawtnaw Isarel catounnaw koevah, kâ a poe e patetlah taminaw hah kum 20 hoi a lathueng e pueng touk loe atipouh. ");
INSERT INTO cth_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Isarel e camin teh Reuben doeh. Reuben capanaw teh, Hanok hoi Hanok imthungkhu, Pallu hoi Pallu imthungkhu. ");
INSERT INTO cth_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron hoi Hezron imthungkhu, Karmi hoi Karmi imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Reuben imthungkhunaw a touk awh teh 43,730 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pallu catoun hoi Eliab, ");
INSERT INTO cth_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Eliab capanaw teh, Nemuel, Dathan hoi Abiram doeh. Dathan hoi Abiram teh Mosi hoi Aron ka cusin e tamimaya yueng lah doeh ao awh. BAWIPA a taran awh navah Korah hoi kambawng e lahai ao roi. ");
INSERT INTO cth_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Hotnaw a due navah, talai ni rak a ang teh Korah hah koung a payawp teh, hmai ni tami 250 koung a kak navah, bangnuenae lah a coung awh. ");
INSERT INTO cth_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Hatei, Korah catounnaw dout awh hoeh. ");
INSERT INTO cth_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","A imthungkhu lahoi Simeon capanaw teh; Nemuel hoi Nemuel imthungkhu, Jamin hoi Jamin imthungkhu, Jakhin hoi Jakhin imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zerah hoi Zarah imthungkhu, Saul hoi Saul imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeon imthungnaw heh 22,200 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad capanaw hai ama imthungkhu lahoi, Zephon hoi Zephon imthungkhu, Haggi hoi Haggi imthungkhu, Shuni hoi Shuni imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni hoi Ozni imthungkhu, Eri hoi Eri imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arod hoi Arodi imthungkhu, Areli hoi Areli imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Hetnaw heh Gad imthungkhunaw 40,500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Judah capa roi heh Er hoi Onan ei, Er hoi Onan teh Kanaan kho vah a due. ");
INSERT INTO cth_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Judah capanaw ama imthungkhu lahoi, Shelah hoi Shelah imthungkhu, Perez hoi Perez imthungkhu, Zerah hoi Zarah imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perez capanaw teh, Hezron hoi Hezron imthungkhu, Hamul hoi Hamul imthungkhu la ao awh. ");
INSERT INTO cth_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Hetnaw heh Judah imthungkhunaw a touk awh e 76,500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Issakhar capanaw a imthungkhu lahoi, Tola hoi Tola imthungkhu, Puvah hoi Puvah imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Jashub hoi Jashub imthungkhu, Shimron hoi Shimron imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Hetnaw heh Issakhar imthungkhu a touk awh e 64,300 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zebulun capanaw a imthungkhu lahoi, Sered hoi Sered imthungkhu, Elon hoi Elon imthungkhu, Jahleel hoi Jahleel doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Hetnaw heh Zebulun imthungkhu a touk awh e 60,500 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Joseph capanaw a imthungkhu lahoi, Manasseh hoi Ephraim. ");
INSERT INTO cth_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manasseh capa imthungkhunaw teh, Makhir hoi Makhir imthungkhu. Makhir ni Gilead a sak teh Gilead hoi Gilead imthungkhu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead capanaw teh, Iezer hoi Iezer imthungkhu, Helek hoi Helek imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel hoi Asriel imthungkhu, Shekhem e Shekhem imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida e Shemida imthungkhu, Hepher e Hepher imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Hepher capa Zelophehad heh a ca tongpa awm hoeh, napuinaw dueng doeh kaawm. Zelophehad canunaw e minnaw teh, Mahlah, Noah, Hoglah, Milkah hoi Tirzah. ");
INSERT INTO cth_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Hetnaw teh Manasseh imthungkhu a touk awh e 52,700 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ephraim capanaw a imthungkhu lahoi, Shuthela hoi Shuthela imthungkhu, Bekher hoi Bekher imthungkhu, Tahan hoi Tahan imthungkhu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Shuthela capanaw teh, Eran hoi Eran imthungkhu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Hetnaw teh Ephraim imthungkhu a touk awh e 32,500 touh a pha awh. Hetnaw heh Joseph capa imthungkhunaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benjamin capanaw a imthungkhu lahoi, Bela hoi Bela imthungkhu, Ashbel hoi Ashbel imthungkhu, Ahiram hoi Ahiram imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shupham hoi Shupham imthungkhu, Hupham hoi Humpham imthungkhu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela capa roi teh Ard hoi Naaman doeh. Ard imthungkhu hoi Naaman hoi Naaman imthungkhunaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","hetnaw heh Benjamin imthungkhunaw a touk awh e 45,600 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan capanaw a imthungkhu lahoi, Shuham hoi Shuham imthung lah ao. Hetnaw heh doeh ahnimae imthungkhu dawk hoi Dan imthungkhu lah kaawm. ");
INSERT INTO cth_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Hetnaw heh Shuham imthungkhunaw a touk awh e 64,400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Asher capanaw a imthungkhu lahoi, Imnah hoi Imnah imthungkhu, Ishvi hoi Ishvi imthungkhu, Beriah hoi Beriah imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriah ca roi, Heber hoi Heber imthungkhu, Malkhiel hoi Makhiel imthung lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asher e canu min teh Serah doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Hetnaw teh Asher capanaw imthungkhu lahoi a touk awh e 53,400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naphtali capanaw a imthung lahoi, Jahzeel hoi Jahzeel imthung, Guni hoi Guni imthungkhu, ");
INSERT INTO cth_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Jezer hoi Jezer imthungkhu, Shillem hoi Shillem imthungkhu lah ao. ");
INSERT INTO cth_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Hetnaw heh Naphtali imthungkhu a touk awh e 45,400 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Hetnaw heh Isarel catounnaw a touk awh e 601,730 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Hete ramnaw heh apap e lahoi a kârei awh han e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Bet kapap e teh ram bet kapap lah na poe awh vaiteh, kayoun e teh ram bet kayoun lah na poe awh han. Miphun lahoi râw teh a coe awh han. ");
INSERT INTO cth_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Hatei cungpam rayu e lahoi ram teh rei lah ao han, a na mintoenaw hoi miphun min kâbang lahoi rem teh a coe awh han. ");
INSERT INTO cth_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Cungpam rayu e lahoi apap hai ayoun hai a rei awh han. ");
INSERT INTO cth_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Hetnaw heh Levihnaw e imthungkhu touk e lah ao. Gershon hoi Gershon imthungkhu, Kohath hoi Kohath imthungkhu, Merari hoi Merari imthungkhunaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hetnaw heh Levih imthungkhunaw doeh. Libni imthungkhu, Hebron imthungkhu, Mahli imthungkhu, Mushi imthungkhu, Korah imthungkhu lah ao. Kohath ni Amram a khe. ");
INSERT INTO cth_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram e a yu min teh Jokhebed Levih canu, Izip ram hoi Levih koehoi ka tâcawt e doeh. Ahni ni Amram koehoi Aron hoi Mosi, hoi a tawncanu Miriam a khe. ");
INSERT INTO cth_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aron ni Nadab hoi Abihu, Eleazar hoi Ithamar a sak. ");
INSERT INTO cth_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Hatei Nadab hoi Abihu teh BAWIPA hmalah hno hoeh kawi e hmai a hni dawk a due roi. ");
INSERT INTO cth_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ahnimae tami tongpa thapa yung touh lathueng touk e pueng teh, 23,000 touh a pha. Isarelnaw thung dawk kârei e ram ka coe hoeh hanlah ao dawkvah, Isarelnaw koe mektouksin e lah awm hoeh. ");
INSERT INTO cth_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Hetnaw heh Jeriko namran, Jordan palang teng Moab tanghling dawk Isarel catounnaw touk nah Mosi hoi vaihma Eleazar ni touk e doeh. ");
INSERT INTO cth_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Hatei, Sinai kahrawng e Isarelnaw Mosi hoi vaihma Aron ni a touk e naw hah tami buet touh hai awm hoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Bangkongtetpawiteh, BAWIPA ni kahrawngum vah a due awh roeroe han ati toe. Jephunneh capa Kalep hoi Nun capa Joshua laipalah teh apihai kahring e awm hoeh toe. ");
INSERT INTO cth_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Joseph capa Manasseh imthung, Makhir, ahnie capa Gilead, ahnie capa Hepher, ahnie capa Zelophehad e canu naw doeh. A canunaw e minnaw teh, Mahlah, Noah, Hoglah, Milkah hoi Tirzah tinaw doeh. ");
INSERT INTO cth_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Kamkhuengnae lukkareiim takhang koe Mosi hoi vaihma Eleazar hoi tamikalennaw kamkhuengnaw e hmalah a kangdue awh teh, ");
INSERT INTO cth_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Kahrawngum vah maimae na pa a due teh, BAWIPA taranlahoi cusin hane tamihu, Korah tamihu koe bawk van hoeh. Hatei, ama yon e lahoi a due teh a capa hai tawn hoeh ");
INSERT INTO cth_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Capa a tawn hoeh kecu dawkvah, bangkongmaw apa min teh miphun thung hoi a kahma han, mintoenaw thung dawkvah, ka ham kawi na poe van leih ati awh. ");
INSERT INTO cth_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Hot patetlah Mosi ni hote lawk teh BAWIPA koe a pha sak. ");
INSERT INTO cth_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Zelophehad canunaw ni kathuem e a sak awh. A na pa hmaunawnghanaw rahak vah, a ham kawi na poe awh roeroe vaiteh, a na pa ham hah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Isarel catounnaw koevah, tami buet touh ca tongpa tawn laipalah dout pawiteh, a râw teh a canunaw na poe han. ");
INSERT INTO cth_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Hahoi a canu tawn hoehpawiteh, a râw teh a hmaunawngha na poe han. ");
INSERT INTO cth_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Hmaunawngha tawn hoehpawiteh, a na pa e hmaunawngha na poe pouh han. ");
INSERT INTO cth_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","A na pa ni hmaunawngha tawn hoehpawiteh, a râw teh a huikonaw na poe vaiteh, ahnimouh ni a ham awh han. BAWIPA ni Mosi kâ a poe e patetlah Isarel canaw hanlah lawkcengnae phunglam lah ao han, telah dei pouh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","BAWIPA ni Mosi koevah, Abarim mon dawkvah luen nateh, Isarel catounnaw ka poe hane ram hah radoung haw. ");
INSERT INTO cth_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Hahoi na hmu toteh, na hmaunawngha Aron e a miphunnaw koevah, a ceikhai awh e patetlah nang hai na ceikhai awh han. ");
INSERT INTO cth_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Bangkongtetpawiteh, Zin thingyei dawk taminaw pueng ni a phuenang awh navah, a mithmu vah tui dawk kai barilawa na poe nahanelah, kai ni kâ na poe e taranlahoi taran a thaw awh telah ati (hot teh Zin thingyei dawk Kadesh hoi Meribah tie lah a o). ");
INSERT INTO cth_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Hahoi Mosi ni BAWIPA a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","moithangnaw pueng e hringnae kaukkung Cathut BAWIPA e taminaw hah kakhoumkung tawn laipalah tu patetlah ao hoeh nahanlah tamihu, ");
INSERT INTO cth_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","hmalah cei hoi ahnimouh tâcokhai hane hoi kâenkhai hane kahrawikung hah rawi seh, telah ati. ");
INSERT INTO cth_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","BAWIPA ni Mosi koevah, Nun capa hnotithainae ka tawn e Joshua hrawi nateh, ahni van na kut toung pouh. ");
INSERT INTO cth_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Vaihma Eleazar hoi ka kamkhuengnaw hmalah kangdout sak nateh, ahnimae mithmu vah caksak. ");
INSERT INTO cth_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Isarel catounnaw pueng ni a lawk a ngâi pouh thai nahan, na kâtawnnae a tangawn hah na poe han. ");
INSERT INTO cth_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ahni teh vaihma Eleazar hmalah a kangdue vaiteh, ama ni BAWIPA hmalah, Urim hno lahoi lawkkamnae a la vaiteh, ama kâ lahoi Isarel catounnaw pueng teh a tâco a kâen awh han, telah ati. ");
INSERT INTO cth_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mosi ni BAWIPA kâpoe e patetlah a sak, Joshua hah a hrawi teh, Eleazar hoi kamkhuengnaw hmalah a kangdue sak. ");
INSERT INTO cth_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","A lathueng vah kut a toung pouh teh, Mosi hno lahoi BAWIPA ni kâ a poe e patetlah kâtawnnae hah a poe. ");
INSERT INTO cth_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Isarel canaw hah kâ poe nateh, ahnimouh koe kai hanelah poe han e hmaisawi thuengnae hmuitui, kaie rawca lah kaawm e kâhruetcuetcalah hoi atueng kahmancalah na poe awh han ati tet pouh. ");
INSERT INTO cth_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ahnimouh koevah, hetheh hmaisawi thuengnae BAWIPA koe na poe hane doeh. Tutanca kum touh e, kacueme hnintangkuem kahni touh hmaisawi thuengnae pou a poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tuca buet touh teh amom lah na poe awh han. Alouke buet touh teh tangmin lah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Tavai thueng nahane dawk a kanui e tavai, ephah pung hra pung touh, satui hin pung pali pung touh hoi kanawk e, ");
INSERT INTO cth_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","BAWIPA hanlah hmaisawi thuengnae hmuitui thuengnae hanlah, Sinai mon hoi pouk e hmaisawi thuengnae hah pou na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Tuca buet touh poenae, nei thuengnae teh pung pali pung touh han. BAWIPA hanlah misur nei thuengnae hah, hmuen kathoung koe na rabawk awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Tuca kanaw buet touh teh, tangmin lah na poe awh han. Amom lah tavai thuengnae hoi hawvah, nei thuengnae patetlah BAWIPA koevah hmuitui hmaisawi thuengnae hah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Hahoi sabbath hnin vah, tucatan kum touh e kacueme kahni touh hoi tavai thueng nahanelah tavaikanui ephah pung hra pung hni, satui hoi kanawk e, hawvah nei thuengnae hai na poe sin han. ");
INSERT INTO cth_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Hetheh sabbath hni tangkuem vah, hmaisawi thuengnae pou na poe e, nei thuengnae touksin laipalah poe hanelah poe hane doeh. ");
INSERT INTO cth_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Hahoi thapa katha tangkuem vah BAWIPA hanlah hmaisawi thuengnae na poe awh han. Maitotan kahni touh hoi tutan kum touh e, kacueme sari touh. ");
INSERT INTO cth_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Maitotan tangkuem dawk tavai thueng nahanelah, tavaikanui satui hoi kanawk e ephah pung hra pung thum touh, hahoi tu buet touh dawk tavai thueng nahanelah tavaikanui satui hoi kanawk e ephah pung hra pung hni, ");
INSERT INTO cth_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","tuca kanaw e tangkuem tavai thueng nahanelah, tavaikanui satui hoi kanawk e, ephah pung hra pung touh, hetheh hmuitui thuengnae BAWIPA hanlah hmaisawi thuengnae doeh. ");
INSERT INTO cth_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Hahoi nei thuengnae a poe awh e teh, maitotan buet touh dawk misur hin tangawn han. Tutan buet touh dawk teh, hin pung thum touh dawk pung touh. Hahoi tucanaw dawk teh, hin pung pali pung touh. Hetheh kum touh thung thapa tangkuem hmaisawi thuengnae lah ao. ");
INSERT INTO cth_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","BAWIPA koevah, yon thuengnae hmaetan buet touh hoi pou na poe awh e, hmaisawi thuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Thapa yung pasauek, hlaipali hnin teh BAWIPA e ceitakhai pawi doeh. ");
INSERT INTO cth_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Hote thapa hlaipanga hnin teh pawi hnin doeh. Hnin sari touh thung teh, tonphuenhoehe tavai hah na ca awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Apasuek hnin vah, kathounge kamkhuengnae pawi na to awh han. Bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Hmaisawi thuengnae palei teh, BAWIPA koe na poe awh han. Maitotan kanaw e kahni touh hoi, tutan kanaw e kum touh e sari touh, kacueme han. ");
INSERT INTO cth_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Tavaikanui satui hoi kanawk e tavai thuengnae hoi, maitotan buet touh dawk ephah pung hra pung thum, tutan buet touh dawk ephah pung hra pung hni touh. ");
INSERT INTO cth_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Tuca kanaw e sari touh teh, tuca kanaw e buet touh dawk ephah pung hra pung touh han doeh. ");
INSERT INTO cth_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Hahoi yontha nahanlah yon thuengnae hmaetan buet touh. ");
INSERT INTO cth_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Hetnaw heh amom e poehno hmaisawi thuengnae pou poe e touk laipalah, na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Het patetlah BAWIPA han hmuitui hmaisawi poenae, ca hanlah hnintangkuem hnin sari touh thung na poe awh han. Hetheh pou poe e hmaisawi thuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Asari hnin vah, kathounge kamkhuengnae na tawn vaiteh, bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Hahoi yat touh dawk e pawi, canga pasuek e pawi, BAWIPA hanlah hno katha tavai thuengnae hno poe hnin dawk hai, kathounge kamkhueng pawi na tawn awh han, bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","BAWIPA hanlah hmuitui thuengnae na poe awh han. Maitotan kahni, tutan buet touh, tuca kanaw e a tan kum touh e sari touh. ");
INSERT INTO cth_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Tavai thuengnae tavaikanui satui hoi kanawk e maitotan kanaw e buet touh, ephah pung hra touh dawk pung thum, tutan buet touh dawkvah, ephah pung hra pung hni. ");
INSERT INTO cth_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Tuca kanaw e sari touh, tuca kanaw e buet touh tangkuem dawk, ephah pung hra pung touh . ");
INSERT INTO cth_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Nangmouh yontha awh nahanlah hmaetan buet touh hah, ");
INSERT INTO cth_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","toun khoeroe kaawm hoeh e han. Pou poe e hmaisawi thuengnae hoi tavai thuengnae touksin laipalah, hotnaw teh nei thuengnae hoi na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Thapa yung sari, a hnin apasuek hnin vah, kathounge na kamkhueng awh vaiteh, thaw banghai na tawk awh mahoeh. Nangmouh hanlah mongka uengnae hnin lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","BAWIPA hmalah hmuitui thuengnae hah na poe awh han. Maitotanca buet touh, tu buet touh, tuca buet touh, kum touh ka phat e kacueme sari touh. ");
INSERT INTO cth_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Tavai thuengnae dawk tavaikanui satui hoi kanawk e maitotan buet touh dawkvah, ephah pung hra pung thum. ");
INSERT INTO cth_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Tutan buet touh ephah pung hra pung hni, tuca kanaw e sari touh, buet touh dawk buet touh dawk lengkaleng ephah pung hra pung touh. ");
INSERT INTO cth_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Yontha nahanelah hmaetan buet touh hoi, ");
INSERT INTO cth_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","thaparei hnin hmaisawi thuengnae hoi hot hoi tavai thuengnae ouk a sak awh e, BAWIPA hanlah hmuitui hmaisawi thuengnae tawk sin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Hahoi thapa yung sari, ahra hnin vah, kathounge kamkhueng pawi na tawn awh han. Rawca na hai vaiteh, bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","BAWIPA koevah, hmuitui thuengnae hah na poe awh han. Maitotan kanaw e buet touh, tutan buet touh, tutan kanaw e a tan kum touh ka phat e sari touh, kacueme roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Tavaithuengnae teh tavaikanui satui hoi kanawk e maitotan buet touh dawkvah, ephah pung hra pung thum touh, tu buet touh dawk pung hra pung hni touh hoi, ");
INSERT INTO cth_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","tu ca kanaw e sari touh thung vah, buet touh dawk teh ephah pung hra pung touh rip han. ");
INSERT INTO cth_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Yon thuengnae hanlah hmaetan buet touh hoi yontha nahanelah yon thuengnae hoi hmaisawi thuengnae pou na poe awh e hah tavai thuengnae hoi nei thuengnae touksin laipalah, pou na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Thapa asari, hnin hlaipanga hnin vah kathounge kamkhuengnae na tawn awh han. Bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","BAWIPA han hmuitui hmaisawi thuengnae na poe awh han. Maitotan kanaw e hlaikathum, tutan kahni, tuca kum touh e hlaipali, kacueme seng han. ");
INSERT INTO cth_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Tavai thuengnae dawk maitotan hlaikathum, maitotan buet touh dawk tavaikanui e satui hoi kanawk e ephah pung hra pung thum, tutan kahni touh, tutan buet touh dawk ephah pung hra pung hni touh han. ");
INSERT INTO cth_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","tuca kanaw e hlaipali, tuca kanaw e buet touh dawk ephah pung hra pung touh han. ");
INSERT INTO cth_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Yon thuengnae dawkvah, hmaetan buet touh hoi hmaisawi thuengnae pou na poe awh e, hote tavai thuengnae hoi nei thuengnae touksin laipalah, na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Hahoi apâhni hnin vah maitotan hlaikahni, tutan kahni, tuca kanaw e a tan kum touh ka phat e kacueme hlaipali touh na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Tavaithuengnae hoi nei thuengnae phung patetlah a younpap e patetlah maitotan thoseh, tutan thoseh, tuca thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","yontha thuengnae hmaetan buet touh hoi hmaisawi thuengnae pou na poe awh e hah, tavaithuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Hahoi apâthum hnin vah, maitotan hlaibun, tutan kahni, tutan kum touh e kacueme hlaipali, ");
INSERT INTO cth_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","tavai thuengnae hoi nei thuengnae hah aphung patetlah a younpap e lahoi maitotan han e thoseh, tutan hane thoseh, tuca kanaw hane thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","yontha thueng nahanelah hmaetan buet touh hoi hmaisawi thuengnae dawk pou na poe awh e tavai thuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Hahoi, apali hnin vah, maitotan kanaw e hra, tutan kahni, tuca kum touh ka phat e kacueme hlaipali, ");
INSERT INTO cth_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","tavai thuengnae hoi nei thuengnae phueng patetlah a younpap e lahoi maitotan thoseh, tutan, tuca kanaw e thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","yontha thueng nahanelah hmaetan buet touh hmaisawi thuengnae dawk pou poe lah kaawm e tavaithuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Hahoi, apanga hnin maitotan kanaw e tako, tutan kahni, tutanca kanaw e kum touh ka phat e kacueme hlaipali, ");
INSERT INTO cth_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","tavaithuengnae hoi nei thuengnae phueng patetlah a younpap e lahoi maitotan thoseh, tutan, tuca kanaw e thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","yontha thueng nahanelah hmaetan buet touh hmaisawi thuengnae dawk pou poe lah kaawm e tavaithuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Hahoi a taruk hnin vah maitotan taroe, tutan kahni, tutanca kanaw e kum touh ka phat e kacueme hlaipali, ");
INSERT INTO cth_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","tavai thuengnae hoi nei thuengnae phueng patetlah a younpap e lahoi maitotan thoseh, tutan, tuca kanaw e thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","yontha thueng nahanelah hmaetan buet touh hmaisawi thuengnae dawk pou poe lah kaawm e tavaithuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Hahoi asari hnin vah maitotan kanaw e sari, tutan kahni, tutanca kanaw e kum touh ka phat e kacueme hlaipali, ");
INSERT INTO cth_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","tavai thuengnae hoi nei thuengnae phueng patetlah a younpap e lahoi maitotan thoseh, tutan, tuca kanaw e thoseh, ");
INSERT INTO cth_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","yontha thueng nahanelah hmaetan buet touh hmaisawi thuengnae dawk pou poe lah kaawm e tavaithuengnae hoi nei thuengnae touksin laipalah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Hahoi ataroe hnin vah ka sungrenpoung lah kamkhuengnae pawi na tawn awh han. Bang thaw hai na tawk awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","BAWIPA hanlah hmaisawi thuengnae na pou awh han. Maitotan kanaw e buet touh, tutan buet touh, tuca kanaw e kum touh ka pha e kacueme sari touh, ");
INSERT INTO cth_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","tavai thuengnae hoi nei thuengnae phueng patetlah a younpap e lahoi maitotan thoseh, tutan, tuca kanaw e thoseh, aphung patetlah a younpap lahoi, ");
INSERT INTO cth_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","yontha thueng nahanelah hmaetan buet touh, hmaisawi thuengnae dawk pou na poe awh e tavaithuengnae hoi nei thuengnae touksin laipalah, ");
INSERT INTO cth_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","lawk na kam awh e thoseh, nama ngai lahoi na poe awh e thoseh, tavaithuengnae hai thoseh, hmaisawi thuengnae thoseh, roum thuengnae thoseh, touksin laipalah, hetnaw heh atueng ka tawn e, pawi patetlah hoiyah BAWIPA koe na poe awh han tet pouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","BAWIPA ni Mosi koe kâ a poe e naw pueng heh Mosi ni Isarel catounnaw koe a dei pouh. ");
INSERT INTO cth_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mosi ni Isarel catounnaw hanlah, a miphun kahrawikungnaw a pato teh, BAWIPA ni lawk a thui e patetlah a dei pouh. ");
INSERT INTO cth_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Tongpa buet touh ni BAWIPA koe lawk kam pawiteh, thoebonae hoi mahoima thoekâbo nakunghai, akuep sak roeroe han, a lawk dei patetlah koung a sak roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Napui teh a na pa im a naw lahun nah BAWIPA koe lawk a kam hai thoseh, thoe a kâbo laihoi a mahoima a kâkin hai thoseh, ");
INSERT INTO cth_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","a na pa ni a lawkkam thoseh, a lawkkin e thoseh, a panue hoi duem awm takhai pawiteh, a lawkkam thoseh, a lawkkin e thoseh a sak roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Hatei, a na pa ni a panue nah hnin vah, pasoung hoehpawiteh, a lawkkam thoseh, a lawkkin e thoseh, a hlout thai han. A na pa ni koung a uk e a tho dawkvah, BAWIPA ni ahni teh a ngaithoum han. ");
INSERT INTO cth_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Napui teh a vâ ao hai lawk kam pawiteh, amae lungthin dawk lawkkin hanelah a dei navah, ");
INSERT INTO cth_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","a vâ ni a panue hnin hoi roup awm takhai pawiteh, a lawkkam thoseh, a lawkkin e thoseh, a kuepsak roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Hatei, a vâ ni a panue hnin vah pasoung hoehpawiteh, pouk laipalah lawk a kam e dawk hoi ahni teh a hlout vaiteh, BAWIPA ni a ngaithoum han. ");
INSERT INTO cth_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Lahmai hoi ayâ ni amae naw teh a lawkkam thoseh, a lawkkin e thoseh, a kuepsak roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","A vâ im vah ao lahunnae lawkkam hoi lawkkin e teh, ");
INSERT INTO cth_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","a vâ ni a panue nakunghai roup awm takhai lah oun hoeh toung pawiteh, a lawkkin e teh a kuepsak roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Hatei, a vâ ni a panue hnin vah, raphoe pouh lah, haw pouh pawiteh, a lawkkam hoi a lawkkin e teh bout a kâhno han. ");
INSERT INTO cth_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Lawkkam hoi lawkkin e pueng teh a vâ ni hnâbo lahoi a raphoe thai. ");
INSERT INTO cth_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Hatei, a vâ ni a thai teh roup awm takhai pawiteh, a lawkkam hoi a lawkkin e patetlah a kuepsak roeroe han. Bangkongtetpawiteh, a panue nah hnin hoi roup ao takhai dawkvah, a caksak toe tie lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","A thai tahma hoi raphoe hoi haw pawiteh, napui e thoesaknae teh ama ni a phu han. ");
INSERT INTO cth_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Hetnaw heh tongpa hoi a yu rahak hane, na pa hoi a canu rahak, a naw nah a na pa im ao nah hane BAWIPA ni Mosi koe kâ a poe e lah ao. ");
INSERT INTO cth_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Isarel catounnaw hanlah Midian taminaw koevah, moipathung nateh, hahoi teh na miphunnaw koevah na ceikhai han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Hottelah Mosi ni taminaw pueng hah a dei pouh teh, Midian taminaw koevah, BAWIPA ni a moipathung hanelah puengcang kâmahrawk awh nateh, midiannaw tuk hanelah kamthaw naseh. ");
INSERT INTO cth_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Isarel miphunnaw pueng thung dawk hoi miphun buet touh dawk hoi tarantuk hanlah tami 1,000 rip na patoun han telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Hottelah Isarelnaw moikapap thung dawk hoi tarantuknae koe cei hanelah, miphun buet touh thung dawk hoi tami tong touh rip a tâ awh teh asumkum tami 12,000 touh a tâco sak awh. ");
INSERT INTO cth_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Hottelah Mosi ni a miphun tangkuem hoiyah, 1,000 rip hoi vaihma Eleazar capa Phinehas ka thoung e hlaamnaw hoi kâhruetcuetnae mongka hah a sin awh teh, tarantuknae koe a ceisak awh. ");
INSERT INTO cth_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","BAWIPA ni Mosi kâ a poe e patetlah Midiannaw hah a tuk awh teh tongpa pueng a thei awh. ");
INSERT INTO cth_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","A thei awh e naw thung dawk Midiannaw e siangpahrang hai a bawk van. Midian siangpahrang panga, Evi, Rekem, Zur, Hur hoi Reba tinaw doeh. Beor capa Balaam hai tahloi hoi a thei awh. ");
INSERT INTO cth_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Hahoi Isarel catounnaw ni Midian napuinaw hah san lah koung a hrawi awh. A saringhunaw pueng, a tuhunaw pueng, a hnopainaw pueng, hah lawphno lah koung a la pouh awh. ");
INSERT INTO cth_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","A onae khonaw pueng hoi a roenae naw pueng hmai koung a sawi pouh awh teh, ");
INSERT INTO cth_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","tami hoi saring, san hoi lawphnonaw pueng teh koung a ceikhai awh. ");
INSERT INTO cth_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Hahoi san hoi man e naw pueng hoi lawphnonaw teh Mosi hoi vaihma Eleazar hoi Isarel catounnaw koevah, Jeriko namran Jordan palang teng Moab tanghling a roe awhnae koe a phakhai awh. ");
INSERT INTO cth_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Hottelah, Mosi hoi vaihma Eleazar hoi taminaw pueng ni longkha koehoi a dawn awh. ");
INSERT INTO cth_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Hatei, Mosi teh ransabawi 1,000 touh kahrawikung, 100 touh kahrawikung kacuenaw hoi tarantuknae koehoi kabannaw lathueng vah a lungkhuek. ");
INSERT INTO cth_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Hottelah Mosi ni ahnimouh koe, napuinaw teh a hring lah na hlung awh na maw. ");
INSERT INTO cth_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Khenhaw, Balaam khokhangnae kecu dawk Peor kong dawkvah, Isarel catounnaw ni BAWIPA taranlahoi kâtapoenae katâcawtsakkungnaw teh hete napuinaw doeh. BAWIPA e taminaw koe lacik a pha sak awh toe. ");
INSERT INTO cth_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Hatdawkvah, camonaw thung dawk tongpanaw hah koung thet awh nateh, tongpanaw ni yo a ikhai e napuinaw hai thet awh. ");
INSERT INTO cth_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Hatei, camohnawn e napuinaw tami ni a ikhai hoeh raenaw pueng teh, namamouh hanlah pâhlung awh. ");
INSERT INTO cth_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Hahoi longkha koe hnin sari touh roe awh. Bang patetlae tami nakunghai tami ka thet e hoi tami ro kateknaw pueng teh, apâthum hnin hoi asari hnin teh namamouh hoi na sannaw hoi kamthoung awh. ");
INSERT INTO cth_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kamthoupnae pueng hoi, phaivuen hoi sak e hnonaw pueng kong dawk be na kamthoung awh han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Hahoi, vaihma Eleazar ni hai tarantuknae koe ka cet e ransanaw hah a kaw teh, hethateh BAWIPA ni Mosi koevah kâ a poe e kâlawk doeh. ");
INSERT INTO cth_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Sui, ngun, hoi rahum, hoi sum, samphei, hoi konlawk, ");
INSERT INTO cth_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","bangpatete hnonaw pueng haiyah, hmai ni a kak thai hoeh e pueng, hmai dawk pou ceisak vaiteh a thoung han. Bangpatet nakunghai yah pâsu hoi thoungthainae tui hoi pâsu vaiteh thoungsak hanlah ao. Hahoi hmai dawk phum han kahawihoehnaw pueng teh, khohna hoi tui dawk pekpâsu hanelah ao. ");
INSERT INTO cth_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Hahoi asari hnin vah na hni na pâsu awh vaiteh, hahoi doeh roenae hmuen koe na kâen awh han. ");
INSERT INTO cth_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","nang nama hoi vaihma Eleazar hoi tamihu kaukkung kahrawikungnaw hoi hnopai na lawp awh e tami hoi saring hah be touk awh. ");
INSERT INTO cth_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Lawphno kahni touh lah kapek awh. Tarantuknae koe ka cet ni teh tarankatuknaw hane hoi tamimaya hanlah, ");
INSERT INTO cth_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","hahoi tarantuknae koe kacetnaw e a hma thung dawk hoi tami hoi, maito, hoi la, hoi tu, hoi kahring e pueng dawk hoi 500 touh dawk buet touh BAWIPA han a ham lah ta hanlah na kapek han. ");
INSERT INTO cth_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Hotnaw teh lat awh nateh, BAWIPA hanlah kahek thuengnae vaihma Eleazar hah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Isarelnaw ni a ham awh e a tangawn thung dawk hoi tami, maito, la, tu totouh moithang phun 50 touh dawk buet touh, na la vaiteh, BAWIPA e lukkareiim ka ring e Levihnaw hah na poe awh han, telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Hottelah BAWIPA ni Mosi kâ a poe e patetlah Mosi hoi vaihma Eleazar ni a sak roi. ");
INSERT INTO cth_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ransanaw ni a man awh e lawphno touksin laipalah a la awh e teh, tu 675,000, ");
INSERT INTO cth_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","maito 72,000, ");
INSERT INTO cth_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","la 61,000, ");
INSERT INTO cth_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","napui tongpa ni a ikhai hoeh rae 32,000, ");
INSERT INTO cth_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","tarantuknae koe kacetnaw tangawn ni a ham awh e tu 337,500, ");
INSERT INTO cth_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","BAWIPA ham tu 675, ");
INSERT INTO cth_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","maito 36,000 touh a pha teh BAWIPA ham teh 72 touh. ");
INSERT INTO cth_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","La 30,500 touh a pha teh BAWIPA ham teh 61 touh. ");
INSERT INTO cth_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Tami teh 16,000 touh a pha teh BAWIPA ham teh 32 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","BAWIPA ni Mosi kâ a poe e patetlah ham, BAWIPA koe kahek thuengnae Mosi ni vaihma Eleazar a poe. ");
INSERT INTO cth_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Mosi ni tarankatuknaw e a ham koung a poe. Isarelnaw e a ham teh, ");
INSERT INTO cth_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","tu 337,500, ");
INSERT INTO cth_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","maito 36,000, ");
INSERT INTO cth_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","la 30,500, ");
INSERT INTO cth_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","tami 16,000 a pha. ");
INSERT INTO cth_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Isarelnaw ni a ham thung dawk hoi Mosi ni tami hoi saring 50 touh thung dawk hoi buetbuet touh pou a la teh, BAWIPA kâpoelawk patetlah BAWIPA lukkareiim kakhenyawnkung Levihnaw hah a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Hahoi ransanaw thung dawk tami 100 kaukkungnaw, 1,000 kaukkungnaw ni Mosi koe a hnai awh teh, ");
INSERT INTO cth_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Mosi koevah na sannaw niyah kaimae kut dawk kaawm tarankatuknaw hah ka touk awh teh kakuep hoeh e apihai kaawm awh hoeh. ");
INSERT INTO cth_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Hatdawkvah, ka hring awh nahanlah BAWIPA hmalah yontha sak hanelah tamipueng ni lengkaleng a coe awh e sui hoi sak e, dingyin, laikaw, kuthrawt, hnongpacap, hnâpacap naw hah BAWIPA koe thueng hanelah ka thokhai awh toe telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mosi hoi vaihma Eleazar ni, sui hoi sak e puengcangnaw hah a la pouh. ");
INSERT INTO cth_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","1,000 touh kahrawikung, 100 touh kahrawikungnaw ni BAWIPA hanelah kahek thuengnae lah a poe awh e suinaw pueng teh sekel 16,750 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Ransanaw ni a la awh e lawphnonaw teh amamouh hanlah lengkaleng a la awh. ");
INSERT INTO cth_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Hahoi Mosi hoi vaihma Eleazar ni 1,000 kahrawikung, 100 kahrawikungnaw e sui teh a la pouh teh, Isarel catounnaw pahnim hoeh nahanlah kamkhuengnae lukkareiim dawk BAWIPA hmalah a tâcokhai awh. ");
INSERT INTO cth_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Reuben hoi Gad miphunnaw ni saring moi a tawn awh teh, Jazer ram hoi Gilead ram a hmu awh toteh, a hmuen teh saring o nahan ahawipoung ati awh. ");
INSERT INTO cth_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Hothateh, Gad, hoi Reuben catounnaw ni Mosi hoi Eleazar maya kahrawikungnaw hah a pato awh teh, ");
INSERT INTO cth_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Isarelnaw hmalah, BAWIPA ni a ta e ram Ataroth, Dibon, Jazer, Nimrah, Heshbon, Elealeh, Sebam, Nebo hoi Beon teh, ");
INSERT INTO cth_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","saring pâ nahanlah kahawipoung e ram lah ao teh, na sannaw hai saring ka tawn awh. ");
INSERT INTO cth_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Hatdawkvah na hnâ bawt pawiteh, hete ram heh coe hanlah na poe awh loe. Jordan namran hrumhram na takhangkhai awh hanh telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mosi ni Gad hoi Reuben catounnaw koevah, na hmaunawnghanaw tarantuknae koe a cei vaiteh, nangmanaw teh hi vah sut na o awh han na maw. ");
INSERT INTO cth_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Bangkongmaw, BAWIPA ni na poe awh e ram dawk kâen hanlah Isarel catounnaw ni na lungthin thung na kâhnawn awh. ");
INSERT INTO cth_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Kadeshbarnea hoi ram tuet hanlah na patoun awh navah, hettelah na mintoenaw ni ati awh toe. ");
INSERT INTO cth_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Eshkol ravo koe a pha awh navah, ram teh a hmu awh. BAWIPA ni na poe e ram kâen hoeh hanlah Isarelnaw a lungthin a kamlang sak awh. ");
INSERT INTO cth_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Hote hno niyah, BAWIPA lung a kâan sak teh, ");
INSERT INTO cth_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Izip ram hoi ka tâcawt e kum 20 lathueng pueng ni Abraham hoi Isak hoi Jakop tinaw koe thoekâbo hoi ka poe e ram teh, apinihai hmawt mahoeh. Bangkongtetpawiteh, kai hnukkâbang katang awh hoeh telah thoe a kâbo awh. ");
INSERT INTO cth_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Keniz tami Jephunneh capa Kaleb hoi Nun capa Joshua teh BAWIPA hnuk a kâbang roi. ");
INSERT INTO cth_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Isarelnaw koe BAWIPA a lung a kâan teh BAWIPA mithmu vah hno kahawihoehe kasaknaw e se pueng a kahma awh hoehroukrak kahrawngum vah kum 40 touh a kâva sak. ");
INSERT INTO cth_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Khenhaw! Isarelnaw koe BAWIPA lungkhueknae takikathopoung e hah bout thapsin hanlah nangmouh sekatha tamikayonnaw ni mintoenaw yueng lah na kâsak awh. ");
INSERT INTO cth_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Bangtelamaw ahni hnukkâbang laipalah na awm pawiteh hete kahrawngum vah bout na o sak awh vaiteh, hete tamimaya heh kahmasak han telah atipouh. ");
INSERT INTO cth_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Hahoi rek a hnai awh teh, ahni koe awi hivah saringnaw hoi tuhunaw hanlah a im sak pouh vaiteh, canaw hanlah khothawng awh han, ");
INSERT INTO cth_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","hatei, kaimanaw teh, o awh nahane hmuen koe pha hoehroukrak, Isarel catounnaw hmalah cei hanelah puengcang coungkacoe kâmahrawk awh han, hete ram taminaw kecu dawk, canaw heh rapan ka tawn e kho dawk o sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Isarel catounnaw ni a coe awh hane kawi hmuen be a coe hoehroukrak, ma im lah na ban awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Bangtelamaw tetpawiteh, coe hane kawi teh, hi namran lah Jordan kanîtholah a tho dawkvah, Jordan namran hoi ahlawilae teh coekhai awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mosi ni hot patetlah na sak awh teh, tarantuk nah koevah, BAWIPA hmalah cei hanlah na kamthoup awh teh, ");
INSERT INTO cth_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","a hmalah a tarannaw a pâlei teh, BAWIPA hmalah ram na tâ awh hoehroukrak, nangmouh rahak puengcang kâmahrawk e naw pueng ni, BAWIPA hmalah Jordan be na raka awh pawiteh, a hnuk bout na kâbang awh vaiteh, ");
INSERT INTO cth_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","BAWIPA lathueng hoi Isarelnaw lathueng vah, yonpen lah na awm awh mahoeh. Hottelah ram te BAWIPA hmalah na coe awh han. ");
INSERT INTO cth_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Hatei hottelah na sak awh hoehpawiteh, khenhaw!, BAWIPA koevah na yon e lah awm vaiteh, na yonnae na hmu awh roeroe han tie hah panuek awh. ");
INSERT INTO cth_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Na camonaw hanlah khothawng awh nateh, na tunaw hanlah im sak pouh awh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Hottelah Gad hoi Reuben catounnaw ni Mosi koevah, na sannaw ni mintoenaw e kâpoelawk patetlah ka sak han. ");
INSERT INTO cth_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ka yunaw hoi camonaw hoi tuhunaw hoi saringhunaw pueng teh, Gileadnaw e khoram dawk ao han. ");
INSERT INTO cth_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Hatei, na sannaw tarantuk hanlah, puengcang hoi kâmahrawknaw pueng ni bawipa ni a dei pouh telah BAWIPA hmalah ka luen van awh han telah ati awh. ");
INSERT INTO cth_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Mosi ni ahnimouh kong kecu dawk vaihma Eleazar hoi Nun capa Joshua hoi Isarel miphun imthung kahrawikungnaw hah kâ a poe. ");
INSERT INTO cth_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Mosi ni ahnimouh koe Gad canaw hoi Reuben canaw tarantuknae puengcang kâmahrawk e pueng ni, BAWIPA hmalah Jordan tui a rakakhai han. Ram teh na la hnukkhu, Gilead ram teh a coe awh hanlah na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Hatei puengcang kâmahrawk hoi na cetkhai awh hoehpawiteh, Kanaan ram vah nangmouh koe a bawk van han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Hahoi Gad canaw hoi Reuben canaw ni na sannaw koevah, BAWIPA ni a dei e patetlah ka sak han. ");
INSERT INTO cth_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Puengcang kâmahrawk hoi BAWIPA hmalah, Kanaan ram takhang vaiteh kâen awh han. Hatei, coe awh hane ram teh, Jordan namran lah doeh pou coe awh ti telah a pathung awh. ");
INSERT INTO cth_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mosi ni Gad catounnaw hoi Reuben catounnaw hah Joseph capa Manasseh miphun tangawn teh, Amor siangpahrang Sihon uknaeram hoi Bashan siangpahrang, Og uknaeram kaawm e khonaw pueng hoi, a tengpam khotenaw pueng hoi koung a poe awh. ");
INSERT INTO cth_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Gad catounnaw ni Dibon, Ataroth hoi Aroer, ");
INSERT INTO cth_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Aroth-shonphan, Jazer hoi Jobehah, ");
INSERT INTO cth_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bethnimrah hoi Bethharan kho a thawng awh teh, rapan ka tawn e khopui hoi tu imnaw a sak awh. ");
INSERT INTO cth_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Reuben catounnaw ni Heshbon, Elealeh hoi Kiriathaim, ");
INSERT INTO cth_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baalmeon, Sibmah hah a thawng awh. Hote kho a thawng awh e hah min louk lah a phung awh ");
INSERT INTO cth_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manasseh capa Makhir catounnaw teh Gilead ram a cei awh teh a la awh. Amornaw haw kaawm pueng teh be a lawp awh. ");
INSERT INTO cth_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Hatdawkvah, Mosi ni Gilead ram teh Manasseh capa Makhir koe a poe teh hawvah khosak awh. ");
INSERT INTO cth_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manasseh capa Jair ni a cei teh khotenaw hah a la dawkvah, hotnaw hah Jair telah a phung awh. ");
INSERT INTO cth_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobah hai a cei teh, Kenath khotenaw a la teh, a min lah Nabah telah a phung awh. ");
INSERT INTO cth_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Hetnaw heh Mosi hoi Aron ni hrawi e lahoi IZip ram hoi ahuhu lahoi a tâco awh teh, a ceinae doeh. ");
INSERT INTO cth_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","BAWIPA ni kâ poe e patetlah a tâco pasuek hoiyah, a ceinae naw hah Mosi ni koung a thut. Hetheh kahlawng cei a kamtawngnae koehoi pou a deinae doeh. ");
INSERT INTO cth_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Thapa ayung pasuek, hnin hlaipanga hin vah Raameses hoi a tâco awh teh ceitakhai pawi hnin a tangtho amom vah Izipnaw e mithmu vah, ");
INSERT INTO cth_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","a caminnaw pueng BAWIPA ni a thei pouh e naw a pakawp awh lahun nah, Isarel catounnaw pueng lungtang lahoi a tâco awh. Bangkongtetpawiteh, BAWIPA ni ahnimae cathut koehai lawk a ceng teh a rek pouh. ");
INSERT INTO cth_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Hahoi teh Isarel catounnaw teh Raameses hoi a tâco awh teh, Sukkoth vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukkoth hoi a tâco awh teh kahrawngum Etham vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Etham hoi a tâco awh teh Baalzephon teng Pihahiroth lah a ban awh teh Migdol vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Pihahiroth hoi a tâco awh teh talî tapoung hoi kahrawngum vah a kâen awh. Hahoi Etham kahrawng dawk hnin thum touh a cei awh teh, Marah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Marah hoi a cei awh teh, Elim lah a pha awh. Haw vah tuiphuek hlaikahni touh hoi ungkung 70 touh ao teh haw vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Elim hoi a cei awh teh tuipui paling teng vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Tuipui paling koehoi a cei awh teh Sin kahrawngum vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sin kahrawngum koehoi a cei awh teh, Dophkah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Dophkah koehoi a cei awh teh Alush vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Alush koehoi a cei awh teh, Rephidim vah a roe awh. Hatei, hawvah tui nei hane awm hoeh. ");
INSERT INTO cth_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Rephidim koehoi a cei awh teh, Sinai kahrawngum vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sinai kahrawngum koehoi a cei awh teh, Kiborthhattaavah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Kiborthhattaavah koehoi a cei awh teh, Hazeroth vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Hazeroth koehoi a cei awh teh, Rithmah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Rithmah koehoi a cei awh teh Rimmonperez a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Rimmonperez koehoi a cei awh teh Libnah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Libnah koehoi a cei awh teh Rissah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Rissah koehoi a cei awh teh Kehelathah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Kehelathah koehoi a cei awh teh Shepher mon vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Shepher mon koehoi a cei awh teh Haradah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Haradah koehoi a cei awh teh Makheloth vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Makheloth koehoi a kampuen awh teh Tahath vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tahath koehoi a cei awh teh Terah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Terah koehoi a cei awh teh Mithkah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Mithkah koehoi a cei awh teh Hashmonah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Hashmonah koehoi a cei awh teh Moserah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Moserah koehoi a cei awh teh Benejaakan vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Benejaakan koehoi a cei awh teh Horhagidgad vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Horhagidgad koehoi a cei awh teh Jobathah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Jobathah koehoi a kampuen awh teh Abronah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Abronah koehoi a kampuen awh teh Eziongeber vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Eziongeber koehoi a cei awh teh Kadesh e Zin kahrawng vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Kadesh koehoi a cei awh teh Edom ram poutnae Hor mon vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Hor mon vah vaihma Aron hai BAWIPA e lawk patetlah a luen teh, Izip hoi Isarelnaw a tâco awh hoi kum 40, thapa yung panga apasuek hnin, hawvah a due. ");
INSERT INTO cth_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aron teh Hor mon dawk a due nah kum 120 touh a pha. ");
INSERT INTO cth_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Hahoi Kanaannaw, Kanaan ram akalah kaawm e Arad siangpahrang ni Isarelnaw a tho awh e hah a thai. ");
INSERT INTO cth_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Hor mon koehoi a kampuen awh teh Zalmonah vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Zalmonah koehoi a kampuen awh teh Punon vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Punon koehoi a kampuen awh teh Oboth vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Oboth koehoi a kampuen awh teh Moab ramri Ijeabarim vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Iyim koehoi a kampuen awh teh Gad Dibon vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Gad Dibon koehoi a kampuen awh teh Almondiblathaim vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Almondiblathaim koehoi a kampuen awh teh Nebo hma lae Abarim mon vah a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Abarim mon koehoi a kampuen awh teh Jeriko tengpam Jordan palang teng Moab tanghling dawk a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Jordan palang teng Bethjeshimoth koehoi Abelshittim totouh Moab tanghling dawk a roe awh. ");
INSERT INTO cth_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Hahoi Jeriko tengpam Jordan palang teng Moab tanghling dawk BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Isarel catounnaw hah pato nateh, ahnimouh koe Jordan tui na raka awh teh, Kanaan ram na kâen awh toteh, ");
INSERT INTO cth_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","hote ram dawk kaawmnaw pueng be na pâlei awh han. Ahnimae talung meikaphawknaw pueng be na raphoe pouh han, hmuenrasang hai be na raphoe pouh han. ");
INSERT INTO cth_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Hahoi ram teh na coe awh vaiteh, hawvah kho na sak awh han, bangkongtetpawiteh, na coe hane ram teh na poe toe. ");
INSERT INTO cth_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Hahoi a ma miphun lahoi cungpam na rayu awh vaiteh, ram teh na coe awh vaiteh, na kârei awh han, bet kapap e hah ram kakawhnawn na poe awh han. Kayoun e hah kabuenghnawn lah na poe awh han. Cungpam na rayu awh e patetlah kâvan lah na ham awh han. Na mintoenaw e phung patetlah na coe awh han. ");
INSERT INTO cth_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Hatei, hote ram dawk kaawmnaw hah na pâlei awh hoeh e naw teh, na mit dawk mittanuen hoi na tak dawk pâkhing kaawm vaiteh, na onae ram dawk runae na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Hothloilah, ahnimouh koe sak han ka noe e hah namamouh koe letlang ka sak han tet pouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Isarelnaw hah lawkthui nateh, hetheh Kanaan ram na pha awh toteh nangmouh ni na pang awh hane Kanaan ramri doeh atipouh. ");
INSERT INTO cth_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Akalah nangmae khori teh, Zin kahrawngum hoi Edom ram yunglam han, akalae khori teh palawi talî apoutnae koehoi Kanîtholae han. ");
INSERT INTO cth_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Hahoi nangmae ramri teh, Akrabbim takhangnae a rahim hoi a lawngven vaiteh, Zin pou a rakan vaiteh, Kadeshbarnea a rahim totouh han, hahoi Hazaraddar lah cet vaiteh, Azmon vah pou a cei tâphai han. ");
INSERT INTO cth_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Hote ramri teh Azmon Izip palang totouh lawngven vaiteh, tuipuipaling koe a pout han. ");
INSERT INTO cth_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Kanîloumlah, tuipui hah khori lah na coe awh han, hetheh kanîloumlae na ramri lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Hahoi hetheh atunglae na khori lah ao han, tuipui koehoi Hor mon pâum lahoi na sak han. ");
INSERT INTO cth_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Hor mon koehoi Hamath kâennae koe totouh na sak awh han, haw hoi khori a tâconae teh Zedad koe han. ");
INSERT INTO cth_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Khori teh, Ziphron pou tapoung vaiteh, Hazarenan vah a pout han, hetheh atunglae na ramri lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Hahoi Kanîtholae na khori teh, Hazarenan hoi Shepham totouh na sak awh han. ");
INSERT INTO cth_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Na khori teh Shepham hoi Riblah hoi Ain kanîtholah pou a cathuk vaiteh, haw hoi paloupalou cathuk vaiteh, Khinnereth kanîtho talîpui rai koelah a pha han. ");
INSERT INTO cth_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Khori teh Jordan lah cathuk vaiteh, palawi talî koe apout han, hetheh na khori lah ao tet pouh telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Hahoi teh, Mosi ni Isarelnaw hah kâ a poe teh, hetheh BAWIPA ni miphun tako touh hoi a tangawn poe hanelah, cungpam rayu hoi na coe awh hane ram doeh. ");
INSERT INTO cth_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Bangkongtetpawiteh, Reuben miphun catounnaw ni a imthung lahoi, Gad miphun catounnaw ni a imthung lahoi, Manasseh miphun tangawn ni a imthung lahoi a coe awh hane teh be a coe awh toe. ");
INSERT INTO cth_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Hete miphun kahni touh hoi tangawn ni a coe awh hane teh, kanîtholah Jeriko tengpam, Jordan palang kanîtholah a coe awh toe telah a ti. ");
INSERT INTO cth_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","BAWIPA ni Mosi a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","hetnaw heh na coe awh hane ram nangmouh rahak vah kareikung min teh vaihma Eleazar hoi Nun capa Joshua doeh. ");
INSERT INTO cth_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Hahoi na coe awh hane ram kareikung lah miphun tangkuem dawk hoi khobawi buet touh rip na rawi awh han ati pouh. ");
INSERT INTO cth_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","A minnaw teh hetnaw hah doeh. Judah catoun dawk hoi Jephunneh capa Kaleb, ");
INSERT INTO cth_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simeoncanaw dawk hoi Ammihud capa Samuel, ");
INSERT INTO cth_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Benjaminnaw dawk hoi Khislon capa Elidad, ");
INSERT INTO cth_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dan canaw dawk hoi khobawi Jogli capa Bukki, ");
INSERT INTO cth_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Joseph capa Manasseh canaw dawk hoi Ephod capa khobawi Hanniel, ");
INSERT INTO cth_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Ephraimcanaw e catoun dawk hoi Shiphtan capa khobawi Kemuel, ");
INSERT INTO cth_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Zebuluncanaw dawk hoi Parnach capa khobawi Elizaphan, ");
INSERT INTO cth_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Issakharnaw dawk hoi Azzan capa khobawi Azzan, ");
INSERT INTO cth_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asher canaw dawk hoi Shelomi capa khobawi Ahihud, ");
INSERT INTO cth_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Naphtalinaw dawk hoi Ammihud capa khobawi Pedahel, han atipouh. ");
INSERT INTO cth_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Hetnaw heh Kanaan ram e Isarel catounnaw ram coe hane kareikung lah BAWIPA ni a poe e naw doeh. ");
INSERT INTO cth_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Hahoi Jeriko teng Jordan palang teng vah Moab tanghling dawk BAWIPA ni Mosi hah a pato. ");
INSERT INTO cth_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Isarel canaw hah kâpoe leih. A ram thung dawk Levihnaw o nahanlah kho poe awh naseh. Saring a pâ nahanlah kho tengpam hah Levihnaw na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Kho a saknae kho tawn awh vaiteh, a tengpam pueng teh a maito hoi saringnaw a paca awh e a pâ nahanlah awm naseh. ");
INSERT INTO cth_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Kho tengpam Levihnaw na poe awh hane teh, kho rapan petkâkalup lah dong 1000 touh akaw han. ");
INSERT INTO cth_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Hahoi tumdumnae alawilah hoi na bangnue awh vaiteh, kanîtholah dong 2000, akalah dong 2000, kanîloumlah dong 2000, atunglah dong 2000, alungui kho ao han. Hetnaw heh a ham awh e khopuinaw rapan alawilah han. ");
INSERT INTO cth_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Levihnaw na poe awh hane khonaw thung dawkvah, tamikathetnaw a yawng nahane taruk touh na rawi awh han. Hothloilah kho 42 touh na thapsin han. ");
INSERT INTO cth_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Levihnaw na poe hane khonaw pueng teh, a ram hoi kho 48 touh a pha han. ");
INSERT INTO cth_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isarelnaw khosak nahan na poe e teh, kapap hah kapap na poe vaiteh, kayoun hah kayoun na poe han. Tami pueng ni a coe awh e ram apap e patetlah Levihnaw kho na poe awh han. ");
INSERT INTO cth_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","BAWIPA ni Mosi hah a pato teh, ");
INSERT INTO cth_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Isarel canaw hah pato nateh, ahnimouh koe Jordan na raka awh teh, Kanaan ram na kâen toteh, ");
INSERT INTO cth_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","pouk laipalah tamikathet payon e teh a yawng vaiteh a kângue nahane kho na pouk pouh han. ");
INSERT INTO cth_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Tamimaya hmalah lawkceng hanlah a kangdue hoehnahlan, tamikathet payon e teh, ama a due hoeh nahanelah, hote khonaw teh moipathungkung ni a tawng navah a kângue awh nahanelah ao han. ");
INSERT INTO cth_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Hottelah, nangmouh hanlah kângue nahane kho na pouk awh hane teh kho 6 touh a pha han. ");
INSERT INTO cth_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Jordan namran lah kho kathum touh na pouk awh vaiteh, Kanaan ram lah kho kathum touh na pouk awh han. Kânguenae kho lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Isarel catounnaw hoi ahnimouh koe kaawm e imyinnaw hanlah kho 6 touh hah kânguenae kho lah ao han. Awi hawvah, tamikathet payonnaw ni a yawng awh han. ");
INSERT INTO cth_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Hatei, sum hoi tami hem boilah dout pawiteh, tamikathet e lah ao dawkvah, tamikathet e teh ama hai roup thei roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Hahoi talung hoi tami kadout lah dei pawiteh, ayâ ka thet e lah ao dawkvah, ayâ ka thet e teh ama hai thei roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Hahoi tami ni thing hoi tami kadout lah hem pawiteh, ayâ ka thet e lah ao dawkvah, ayâ ka thet e teh ama hai thei roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Thiphu moipathungkung ni tami ka thet e teh tang a thei thai han. A hmu boum teh a thei han. ");
INSERT INTO cth_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Hahoi tami a hmuhma kecu dawk puenghoi dei tanawt nakunghai thoseh, sut pawp laihoi kadout lah a dêi nakunghai thoseh, ");
INSERT INTO cth_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","kâoun hoi kut hoi thaw lah koe dout pawiteh, kathetkung hah thei van hane roeroe lah ao. Bangkongtetpawiteh, tamikathetkung doeh. Thipaling moipathungkung ni a hmu nah tangkuem koe a thei han. ");
INSERT INTO cth_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Hatei, kâoun kâtai dawk laipalah, a tanawt payon dawk nakunghai thoseh, lam hoi a pawp dawk tho laipalah, tami awm hoeh ti hoi a panue hoehnahlan vah, taran lah hai kaawm hoeh e, ");
INSERT INTO cth_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","pataw nahan poe hanlah hai kâcai hoeh eiteh, talung hoi koe dêi lah dout payon pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tamimaya ni hete lawkcengnae kâlawk patetlah kathetkung hoi thipaling moipathungkung hanlah lawk a ceng awh han. ");
INSERT INTO cth_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Hahoi tamimaya ni tamikathetkung hah thipaling moipathungkung koehoi a la ring awh vaiteh, tamimaya ni a yawng nahane kânguenae kho dawk ao sak awh han. Satui kathoung hoi awi e vaihma kacue ka tawk lahun e a due hoehroukrak haw vah ao han. ");
INSERT INTO cth_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Hatei, bangpatet e tueng pueng dawk hai tami ka thet e teh, a yawngnae kânguenae kho, khori hloilah cet pawiteh, ");
INSERT INTO cth_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","thipaling moipathungkung ni kânguenae kho hloilah hmawt boilah thet pawiteh, thipaling dawk yonpennae awm mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Bangkongtetpawiteh, vaihma kacue a due hoehroukrak, kânguenae kho dawk pou o hanlah ao. Vaihma a due hnukkhu, hote tami ka thet e teh ama onae kho dawk a ban han. ");
INSERT INTO cth_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Hatei, hnonaw pueng hah na catounnaw totouh na o awh nah tangkuem koe lawkceng e lah ao han. ");
INSERT INTO cth_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Tami bangpatet ni nakunghai tami thet pawiteh, tamikathetkung teh kapanuekkhaikung e pahni dawk lawk a tâco sak e lawk lahoi thei lah ao han. Hatei, kapanuekkhaikung buet touh dueng e a pahni dawk e lawk pawiteh, thei khai nahanelah khout hoeh. ");
INSERT INTO cth_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Tami kathetkung teh na ratang awh mahoeh. Bangkongtetpawiteh, due han kamcu totouh yonpen e lah ao toung dawkvah, na thei awh roeroe han. ");
INSERT INTO cth_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Kânguenae kho dawk ka yawng e tami teh, hatnae tueng dawk vaihma kacue ka tawk e a due hoehroukrak a onae khoruem dawk bout ban thai nahan, ratang thai mahoeh. ");
INSERT INTO cth_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Hatdawkvah, na onae ram na khin sak mahoeh. Bangkongtetpawiteh, thipaling ni ram hah a khin sak teh, ram a dam nahanlah, thipalawngkung e thipaling hoi dueng doeh yontha thai lah ao. ");
INSERT INTO cth_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Hatdawkvah, a lungui e khosaknae na coe awh e ram teh, na khinsak awh mahoeh. Bangkongtetpawiteh, kai Jehovah teh Isarel catounnaw koe ka o tet pouh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Joseph imthung dawk hoi Manasseh capa Makhir capa Gilead catoun imthung kahrawikungnaw hmalah lawk a dei awh. ");
INSERT INTO cth_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ahnimouh ni, BAWIPA ni Isarel catounnaw hah cungpam rayu hoi a coe awh hane ram poe hanlah, ka bawipa Mosi hah kâ a poe teh, hmaunawngha Zelophehad canunaw a coe hane râw hah BAWIPA ni ka bawipa koe kâ a poe toe. ");
INSERT INTO cth_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Hatei, ahnimouh ni Isarel catoun thung dawk hoi miphun alouke capa koe vâ sak pawiteh, na mintoenaw e ram a coe awh e hah la pouh vaiteh, a vâ koelae ram miphun koe lah a kâthap han. Hottelah coe tangcoung e ram dawk hoi tâcokhai han. ");
INSERT INTO cth_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Hahoi Isarel catounnaw e Jubili a pha toteh, a ram hah a vanaw e miphunnaw ni coe e ram lah thapsin lah ao han. Hottelah mintoenaw e miphun ram thung dawk hoi let na lawp pouh awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Hatdawkvah, Mosi ni BAWIPA lawk patetlah Isarel catounnaw hah kâ a poe teh, Joseph capa hoi miphunnaw ni a dei e a thuem. ");
INSERT INTO cth_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Zelophehad canunaw kong dawkvah BAWIPA ni kâ a poe e teh hettelah doeh. Ahawi ati e pueng vâ naseh, hatei a napanaw e miphun hah vâ awh naseh telah ati. ");
INSERT INTO cth_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Hatdawkvah, Isarel catounnaw e ram teh, miphun alouklouk koe voutsout puen laipalah, Isarel catounnaw ni a na mintoenaw e ram teh pou a ham awh han. ");
INSERT INTO cth_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Isarel catounnaw thung dawk râw ka pang hane canunaw pueng teh, Isarel catounnaw ni a na mintoenaw e ram lah kaawm e pou a ham thai nahan, a na pa miphun thung e a yu a la hanlah ao. ");
INSERT INTO cth_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ram teh miphun alouklouk koe puen thai mahoeh. Bangkongtetpawiteh, Isarel catounnaw ni amamae ram hah pou a pang awh e lah kaawm han telah a dei. ");
INSERT INTO cth_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Hottelah, BAWIPA ni Mosi kâ a poe e patetlah Zelophehad canunaw ni a sak awh van. ");
INSERT INTO cth_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Zelophehad canunaw Mahlah, Tirzah hoi Hoglah, Milkah hoi Noah tinaw ni a na pa e hmaunawnghanaw e capanaw hah a vâ awh. ");
INSERT INTO cth_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Joseph capa Manasseh e capa hah a vâ awh teh, a ram teh a na pa miphunnaw ni a coe e râw lah pou a kangning. ");
INSERT INTO cth_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Hetnaw heh Jeriko tengpam Jordan namran Moab tanghling dawkvah, BAWIPA ni Mosi hno lahoi Isarelnaw koevah, kâ a poe e kâpoelawknaw hoi lawkcengnaenaw doeh. ");
INSERT INTO cth_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Kahrawngum, Jordan palang teng, Shuph khopui, Paran khopui, Tophel khopui, Hazeroth, Dizahab khopuinaw koevah, Mosi ni Isarelnaw koe bout a dei e lawk teh: ");
INSERT INTO cth_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Kadeshbarnea hateh, Seir mon lam lahoi Horeb e a onae hoi hnin 11 lamcei ahla. ");
INSERT INTO cth_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Mosi ni Heshbon khopui kaawm e, Amor Siangpahrang Sihon thoseh, Edrei ram, Ashtaroth khopui kaawm e Bashan siangpahrang Og thoseh, a thei hnukkhu ");
INSERT INTO cth_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Kum 40 thapa yung 11 apasuek hnin dawk Moab ram ");
INSERT INTO cth_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Jordan palang teng vah, Cathut ni lawk a poe tangcoung e patetlah Isarelnaw koe bout a dei e kâlawk hateh, ");
INSERT INTO cth_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Maimae BAWIPA Cathut ni, Horeb hmuen dawk, na dei pouh e teh, nangmouh ni atueng a kuep ditouh hete mon dawk na o awh toe. ");
INSERT INTO cth_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Kamlang awh nateh bout kamthaw awh haw. Amor mon totouh thoseh, hote mon hoi kahnai e hmuen tanghling, akalah, tuipui teng, Kanaan ram, Lebanon mon, Euphrates tuipui totouh cet awh haw. ");
INSERT INTO cth_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Hote ram teh nangmouh hmalah ka hruek toe. Cathut ni, nangmae na pa Abraham, Isak, Jakop koehoi kamtawng teh a catounnaw ka poe han telah lawk a kam e ram hah kâen nateh coe awh, telah atipouh. ");
INSERT INTO cth_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Hatnavah, Kai ni nangmouh koe ka dei e thaw heh ka madueng ka phawt thai mahoeh. ");
INSERT INTO cth_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Nangmae BAWIPA Cathut ni nangmouh na pung sak awh vaiteh, nangmouh teh kalvan âsi patetlah sahnin na o awh. ");
INSERT INTO cth_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Nangmae na pa BAWIPA Cathut ni nangmouh teh alet 1000 lahoi na pung sak naseh. Lawk a kam e patetlah yawhawi na poe a seh. ");
INSERT INTO cth_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Na tawntamnae, thawtawknae, kâyuekâounnae hnokari kai ka madueng ni bangtelamaw ka phu thai han. ");
INSERT INTO cth_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","A lungkaangnaw, ka thaipanueknaw, hoi ka thoumthainaw hah na miphun thung hoi rawi awh. Ahnimanaw hah ka hrawikung lah ka hruek han telah dei awh pawteh, ");
INSERT INTO cth_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","nangmouh ni, na dei e patetlah ahawi telah bout a dei awh. ");
INSERT INTO cth_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Hatdawkvah na miphunnaw dawk mitkhet kamcu e kacuenaw panuenae ka tawn naw ka rawi hnukkhu nangmouh koe kacue thaw ka tawk hanelah 1,000 ka uk hane, 100 ka uk hane, 50 ka uk hane, 10 ka uk hane ukkungnaw hah ka rawi. ");
INSERT INTO cth_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Lawkcengkungnaw hai, na hmaunawnghanaw e kamcan hah a thai awh vaiteh, hmaunawngha reira e kamcan thoseh, Jentelnaw hoi e kamcan thoseh kalancalah lawkceng awh. ");
INSERT INTO cth_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Lawkcengnae dawkvah, apie minhmai hai khen hanh. Camo e lawk hah kacue e lawk patetlah pouk. Apihai taket hanh. Bangkongtetpawiteh, lawkcengnae teh Cathut e doeh. Na dei thai hoeh e kamcan hah kai koe thokhai awh. Kai ni hai ka thai han telah lawk a thui. ");
INSERT INTO cth_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Nangmouh ni na sak awh hane naw hai hatnavah kâ na poe toe. ");
INSERT INTO cth_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Kaimouh ni Horeb hmuen koehoi ka tâco awh teh, Amor mon totouh ceinae lam teng vah, takikathopounge kahrawngum ka cei awh teh Kadeshbarnea hmuen koe ka pha awh. ");
INSERT INTO cth_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","BAWIPA ni kâ na poe e patetlah hatnavah kai nihai, maimae BAWIPA Cathut ni na poe awh e Amor mon vah nangmouh ni na pha awh toe. ");
INSERT INTO cth_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Nangmae BAWIPA Cathut ni ram kahawi teh nangmouh hmalah ka hruek toe. Nangmae napanaw e BAWIPA ni a dei e patetlah cet awh nateh lawm awh, taket awh hanh, na lung hai pout awh hanh telah a dei. ");
INSERT INTO cth_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Hatnavah nangmanaw pueng ni kai koe na tho awh teh, kaimae hmalah taminaw ka patoun han. Ahnimouh ni hote ram hah a rip awh hnukkhu, kaimouh teh nâ lam cet pawiteh, bang khopui dawk pha awh han doeh telah a dei awh han telah a dei awh e heh, ");
INSERT INTO cth_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","kai ni ka ngai dawkvah miphun buet touh dawk tami buet touh, asumkum 12 touh hah na rawi awh. ");
INSERT INTO cth_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Ahnimouh ni mon koe lah a kamlang awh teh Eshkol tanghling koe a pha awh teh a tuet awh. ");
INSERT INTO cth_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Hote ram dawk e a paw a hrawm awh teh a thokhai navah, maimae Cathut ni na poe e ram teh kahawi e ram doeh telah a dei awh eiteh, ");
INSERT INTO cth_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Nangmouh ni na cet awh laipalah, namamae BAWIPA Cathut e kâ na ek awh. ");
INSERT INTO cth_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Cathut ni maimouh na hmuhma teh raphoe sak han na ngai awh dawkvah, Amornaw e kut dawk na poe hanlah, Izip ram hoi na tâcokhai awh khe. ");
INSERT INTO cth_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Maimouh ni bangtelamaw cei awh han toung, hmaunawnghanaw ni hote kho dawk e taminaw teh maimouh hlak a len awh. A rasang poung awh. Kalvan ka deng e khopui, rapan hai ao. Hote kho dawk Anakim miphunnaw ka hmu awh telah maimae lungthin a raphoe toe telah nangmouh ni rimnaw dawk na taran awh toe. ");
INSERT INTO cth_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Hatnavah kai ni, puen hanh awh, ahnimouh taket a hanh awh. ");
INSERT INTO cth_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Nangmae hmalah ka cet e nangmae Cathut ni na hmalae Izip ram hai thoseh, ");
INSERT INTO cth_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","nangmouh ni na dawn e lam, hete hmuen totouh a na pa ni a ca a tapam e patetlah nangmae Cathut ni nangmouh na tapam teh, lungmanae na coenae kahrawng hai thoseh, nangmouh han a sak e patetlah nangmouh koe lah taran na kabawp awh han telah a dei nakunghai, ");
INSERT INTO cth_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","nangmouh ni rim tumpup nahan hmuen tawng awh nateh na cei awh nahan lam na patue hanelah karum vah hmai dawk thoseh, khodai lah tâmai dawk thoseh, ");
INSERT INTO cth_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","nangmae hmalah ka cet e Cathut e lawk hah hote kong dawk nangmouh ni na yuem awm hoeh toe. ");
INSERT INTO cth_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Nangmae lawk Cathut ni a thai nah a lungkhuek teh, ");
INSERT INTO cth_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","ahnimae mintoenaw ka poe han ka tie ka lawkkam ram kahawi hah Jephunneh capa Kalep hloilah hete kathoute Miphunnaw buet touh ni boehai kâen awh mahoeh. ");
INSERT INTO cth_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Ahni teh Cathut e hnuk roup a kâbang dawk a kâen. A coungroe e ram hah ahni koehoi kamtawng teh ahnie catounnaw ka poe han telah lawk ka kam . ");
INSERT INTO cth_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Ahnimouh han Cathut ni, kai koehai a lungkhuek, nang teh hote ram na coe mahoeh. ");
INSERT INTO cth_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Na kut rahim e Nun capa Joshua ni a coe han. Ahni teh Isarelnaw râw ka coe sak hanelah ao dawk. Ahni hah thapoe haw. ");
INSERT INTO cth_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Taran ni a lawp e lah ao han na ti awh e camonaw, hatnavah thoe hoi hawi kapek thai hoeh rae canu capanaw ni, hote ram a coe awh vaiteh, kai ni ka poe e patetlah a lawp awh han. ");
INSERT INTO cth_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Nangmouh teh na kamlang awh vaiteh tuipuipaling lam lahoi kahrawng lah bout cet awh ei telah a ti. ");
INSERT INTO cth_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Nangmouh ni hai, kaimouh ni Cathut hah koe ka payon awh toe. Maimae Cathut ni lawk na thui awh e patetlah atu cei awh vaiteh taran tuk han telah na dei pouh teh, tami pueng puengcang rip a patuep awh teh, mon lah takhang hanelah coungkacoe ao awh. ");
INSERT INTO cth_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Cathut ni hai tuk awh hanh, nangmouh koe lah kai kaawm hoeh, na tuk awh pawiteh taran hmalah na sung awh han telah kai ni ka dei e patetlah, ");
INSERT INTO cth_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","kai ni ka dei nakunghai nangmouh ni na tarawi awh hoeh. Cathut e kâ eknae hoi mon lah na luen awh. ");
INSERT INTO cth_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Hatnavah mon dawkvah la kaawm e Amor miphunnaw ni nangmouh koe lah a tâco teh, khoi ni a rongyawn e patetlah nangmouh na kayo awh teh Seir hoi Hormah khopui totouh na thei awh. ");
INSERT INTO cth_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Nangmouh hai bout na tho awh teh, Cathut hmalah na khui na ka awh. Hatei nangmae na lawk hah Cathut ni thai hoeh. ");
INSERT INTO cth_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Hatdawkvah Kadesh hmuen dawk yampa na o awh e patetlah moi ka saw lah na o awh. ");
INSERT INTO cth_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Cathut ni kai koe bout a dei e patetlah kaimouh ni kamlang awh vaiteh, Tuipui paling kahrawng lahoi ka cei teh Seir mon hah moi ka saw lah ka lawngven awh. ");
INSERT INTO cth_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Cathut nihai, nangmouh ni atueng akuep nahan hete mon hah na lawngven awh toe. ");
INSERT INTO cth_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Atunglah bout cet awh ei. ");
INSERT INTO cth_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Nang ni tami pueng koe na dei pouh hane teh, na hmau Esaw miphunnaw a onae Seir ram teng vah, nangmouh na cei awh toteh ahnimouh ni a taki awh han. Hatdawkvah kâhruetcuet awh. ");
INSERT INTO cth_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Rek saueng hanh awh. Ahnimae ram hah, kai ni nangmouh na poe hoeh. Na coungroenae khok hmuen tittouh hai na poe hoeh. Seir mon hateh Esaw yo ka poe toe. ");
INSERT INTO cth_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Nangmouh ni na canei nahane bu hoi tui hai thoseh, ahnimouh koe tangka hoi na ran awh han. ");
INSERT INTO cth_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Nangmouh ni na tawksaknae pueng dawk, nangmae Cathut ni yawhawinae a poe toe. Hete kahrawngpui dawk nangmouh na lawngven awh e a kongnaw a panue. A kum 40 touh thung nangmae BAWIPA Cathut ni nangmouh hoi cungtalah ao nah, banghai nangmouh dawk panki hoeh telah ati. ");
INSERT INTO cth_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Seir ram kaawm e maimae hmau Esaw miphun koe cei awh teh, Elath khopui Eziongeber khopui hoi ka cet e lam tâphai koe ka dawn awh teh, haw hoi bout kamlang awh teh Moab kahrawng lam lahoi ka cei awh. ");
INSERT INTO cth_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","BAWIPA Cathut nihai, Moab khocanaw rucat poe awh hanh, tuk awh hanh, ahnimae ram kai ni na poe awh hoeh. Arab ram teh Lot miphunnaw kai ni yo ka poe toe telah ti pouh. ");
INSERT INTO cth_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Ayan vah Anakim miphun patetlah ka rasang kalen e Em miphunnaw teh hote ram dawk ao awh. ");
INSERT INTO cth_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Ahnimouh teh, Anakim miphunnaw patetlah ao e lah a pouk awh. Hatnavah Moab ram khocanaw ni ahnimanaw teh EM telah a kaw awh. ");
INSERT INTO cth_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Ayan vah Hor taminaw teh Seir ram vah ao awh. Ahnimouh hah Esaw miphunnaw ni a thei awh teh, ahnimouh onae hmuen dawk ao awh. Hot patetlah Cathut ni a poe e ram hah Isarel miphunnaw ni ati awh. ");
INSERT INTO cth_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Atu cet awh nateh Zered tui rakat awh haw telah a dei e patetlah Ahnimouh ni Zered tui a raka awh. ");
INSERT INTO cth_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Kadeshbarnea hmuen koe ahmaloe phanae tueng koehoi ka tâco awh teh Zered tui rakanae tueng totouh kum 38 touh a ro. Cathut ni lawk a kam e patetlah ahmaloe e taran ka tuk thai e ransanaw pueng teh taminaw thungup hoi a due awh. ");
INSERT INTO cth_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ahnimouh raphoe hoeh roukrak, Cathut ni ahnimouh koehoi pâmit hanelah a kut a dâw. ");
INSERT INTO cth_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Taran ka tuk thai e pueng tamihu thung e koung a pâmit sak hnukkhu, ");
INSERT INTO cth_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Cathut ni nang teh Moab ram, ");
INSERT INTO cth_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Ar ram a lungui vah sahnin na cei han. ");
INSERT INTO cth_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ammon miphunnaw teng na pha torei teh ahnimouh rucatnae poe awh hanh, reksaueng awh hanh. Ammon miphunnaw a onae ram hah kai ni nangmouh koe na poe hoeh. Hote ram teh Lot miphunnaw kai ni ka poe toe telah kai koe a dei. ");
INSERT INTO cth_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Hote ram hai kalenpounge taminaw e hmuen doeh telah taminaw ni a pouk awh. Ayan e tueng dawk, hot patetlae taminaw ni ao awh. Ahnimouh hah Ammon ram khocanaw ni Zamzummim telah a kaw awh. ");
INSERT INTO cth_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Hote miphun teh Anakim miphunnaw patetlah kalenpoung kapap poung e taminaw doeh. ");
INSERT INTO cth_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Hatei Seir ram dawk kaawm e Esaw miphun e hmalah Hor taminaw hah Cathut ni a raphoe dawkvah, ahnimae hmuen dawk Esaw miphunnaw ni sahnin totouh ao e patetlah koung a pâmit teh ahnimae hmuen dawk Arnonnaw ni ao awh. ");
INSERT INTO cth_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Hot patetlah Hazrim khopui koehoi Gaza khopui totouh ouk kaawm e naw Avvimnaw hai Kaptor khopui ka tâcawt e Kaptor taminaw ni a raphoe awh teh, ahnimanaw a onae hmuen dawk ao awh. ");
INSERT INTO cth_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Nangmouh na thaw awh vaiteh cet awh haw, Arnon tuipui raka awh haw. Amor miphun, Heshbon siangpahrang Sihon hoi a talai hah nangmae kut dawk ka poe toung dawkvah, khosak awh nateh hote bawi hah tuk awh. ");
INSERT INTO cth_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Tâmai rahim kaawm e pueng, miphunnaw ni sahnin nangmouh tâsue taki laihoi ao nahan ka sak han. Nangmae kamthang a thai awh vaiteh, puennae, pâyawnae, runae puenghoi a kâhmo awh han telah ati. ");
INSERT INTO cth_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Kai hai Kedemoth kahrawng hoi Heshbon siangpahrang Sihon koevah patounenaw ka patoun vaiteh, ");
INSERT INTO cth_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Aram lungui vah na cetsak haw, na lam dawk dueng ka dawn han. Avoilah aranglah ka phen mahoeh. ");
INSERT INTO cth_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Seir ram kaawm e Esaw miphun, Ar ram dawk kaawm e Moab miphunnaw ni kai dawk a sak awh e patetlah ka ca hane rawca thoseh, nei hane tui hai thoseh, tangka hoi yawt lawih. ");
INSERT INTO cth_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Kai teh Cathut ni na poe e ram lah Jordan palang ka raka vaiteh ka pha hoehroukrak Seir ram lungui dawk khok hoi ka cet haw nei telah kâhuikonae lawk hoi ka dei nakunghai, ");
INSERT INTO cth_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Kaimouh ka cei nahane Heshbon siangpahrang Sihon ni kâ na poe hoeh. Bangkongtetpawiteh, sahnin kamnue e patetlah nangmae Cathut ni hote siangpahrang nangmae kut dawk na poe hanelah, lung a tha o sak, lungpatanae lungthin a poe. ");
INSERT INTO cth_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Cathut ni hai Sihon siangpahrang hoi a talai hah na poe han. Hote talai hah râw lah na pang hanelah lat lawih telah a dei. ");
INSERT INTO cth_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Hatnavah, Sihon siangpahrang teh amae tami puenghoi Jahaz vah maimanaw na tuk hanelah a tâco. ");
