﻿USE sofia;
DROP TABLE IF EXISTS sofia.csy_vpl;
CREATE TABLE csy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES csy_vpl WRITE;
INSERT INTO csy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Abraham le David i suan ahi, Jesus Christ i khang thu sia hibang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tapa Isaac; Isaac tapa Jacob; Jacob tapa Judah le a suapuite; ");
INSERT INTO csy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah le Tamar tapa te Perez le Zerah, Perez ta Hezron; Hezron tapa Aram, ");
INSERT INTO csy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram tapa Amminadab; Amminadab tapa Nahshon; Nahshon tapa Salmon; ");
INSERT INTO csy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon tapa Boaz hi; Boaz i nu Rahab; Boaz tapa Obed; Obed nu Ruth; Obed tapa Jesse; ");
INSERT INTO csy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse tapa David Kumpipa; David kumpipa tapa Solomon; a nu sia Uriah i zi hi ngei hi. ");
INSERT INTO csy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon tapa Roboam; Roboam tapa Abijah; Abijah tapa Asa; ");
INSERT INTO csy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tapa Jehoshaphat; Jehoshaphat tapa Jehoram; Jehoram ta Uzziah; ");
INSERT INTO csy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah ta Jotham; Jotham ta Ahaz; Ahaz ta Hezekiah; ");
INSERT INTO csy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah ta Manasseh; Manasseh ta Amon; Amon tapa Josiah; ");
INSERT INTO csy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiah ta Jechoniah, Jechoniah in Babylon khua ah a ki khin ma a nei a suapui te; ");
INSERT INTO csy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babylon a ki khin zawkciang Jechoniah tapa Shealtiel; Shealtiel tapa Zerubbabel; ");
INSERT INTO csy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel ta Abiud; Abiud ta Eliakim; Eliakim ta Azor; ");
INSERT INTO csy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor ta Zadok; Zadok ta Achim; Achim ta Elihud; ");
INSERT INTO csy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihud ta Eleazar; Eleazar ta Matthan; Matthan ta Jacob; ");
INSERT INTO csy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob ta Joseph; Joseph sia Mary i pasal hi a, Mary sung pan Christ a kici Jesus hong suak hi. ");
INSERT INTO csy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tua ahikom Abraham pan in David dong khang sawm le khang li hi a; David pan in Babylon ah a ki khin dong khang sawm le khang li; Babylon a ki khin pan in Christ ciang dong khang sawm le khang li a hihi. ");
INSERT INTO csy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Christ sua na thu sia hibang a hihi: A nu Mary sia Joseph in dokzu a piak sa hi a, a ki ngawm khop ma in Tha Thiangtho taw nau ngil om hi. ");
INSERT INTO csy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Joseph sia thutang khat hi a, Mary mindaisak nuam ngawl ahikom, nol ku tu in ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tabang a ngaisut laitak in, a mang sungah vantungmi khat hong ki lang a, David suan Joseph awng, Mary na zi tu in tenpui tu lau heak in: banghangziam cile a naungil sia Tha Thiangtho taw a hihi. ");
INSERT INTO csy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tapa nei tu a, tua tapa in a mite mawna pan ngum tu ahi man in, Jesus ci in a min na phuak tu hi: ci in vantungmi in son hi. ");
INSERT INTO csy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Hi te theampo Pathian in kamsang te tungtawn in a sonkholsa a tangtun na a hihi, kamsang i sonkhol na ah, ");
INSERT INTO csy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","En vun, ngaknu thiangtho khat naungil om tu a, tapa khat nei tu hi, a min Immanuel kiphuak tu hi, Emmanuel a khiakna sia, Pathian eite taw hong om hi, ci nopna a hihi. ");
INSERT INTO csy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph a khanlaw ciang, Topa vantungmi i sawl bang in, Mary tenpui hi. ");
INSERT INTO csy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ahihang taciil a nei dong luppui ngawl a, a min Jesus ci in phuak hi. ");
INSERT INTO csy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herod Kumpi a sep laitak in, Judah ngam Bethlehem khua ah Jesus a sua ciang in, nisuana sang pan mipil te Jerusalem ah hong theng uh a; ");
INSERT INTO csy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hong suak Judah te Kumpipa koisung ah om ziam? Nisuana sang panin ama i aksi hong suak ka mu uh a, ama bia tu in hong theng khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herod kumpipa in hi thu a zak ciang in ama le Jerusalem ah a om theampo linglawng ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herod in mipi te sung pan thiampi lian te le thukhamhil sya te kaikhawm in, Christ koisung a suak tu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Taciang amate in, Judah ngam Bethlehem khua ah hi tu hi: banghangziam cile kamsang khat i atkhol na ah, ");
INSERT INTO csy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judah ngam sung a om, nang Bethlehem awng, Judah ngam uk te sungah a nobel na hi bua hi: banghangziam cile ka mi Israel te a uk tu nang sung pan hong piang tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tasiaciang Herod kumpipa in mipil te samku a, banghun in aksi suak ziam ci thiangtak in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Taciang amate Bethlehem ah paisak a, tua nauno phatak hong zong tavun; Ama na mu uh ciang in hong sonkik tavun, keizong pai in bia tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Amate in kumpipa son teng a zak zawk uh ciang pai uh hi; Taciang, en vun, nisuana sang pan a mu uh aksi sia nausen omna tungsan ah theng in a tawlngak dong amate mai ah pai hi. ");
INSERT INTO csy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amate in tua aksi a mu uh ciang in, nasiatak in lungdam uh hi. ");
INSERT INTO csy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Innsung a tum uh ciang in, a nu Mary le nausen mu uh a, kun in bia tek uh hi: taciang a ken uh na manpha te sua in, kham, frankincense le myrh te pia uh hi. ");
INSERT INTO csy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tuazawkciang Herod kumpipa kungah heakkik nawnngawl tu in Pathian in amate i mang sungah kidop natu a piak hu in lamdang pan in amate ngam ah cia uh hi. ");
INSERT INTO csy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Amate cia zawkciang, Joseph mang sungah Topa vantungmi hong kilang a, tho in, nausen le a nu keng in, Egypt ngam ah tai vun, thu kong puak kik dong tua ngam ah om nginge vun: banghangziam cile Herod in hi nausen that tu in zong tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joseph a khanlaw ciang, nausen le a nu keng in, a zan a zan in Egypt ngam ah taipui hi. ");
INSERT INTO csy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herod kumpipa a thi dong tua ngam ah om uh hi: hi thu sia, ka tapa Egypt ngam pan samkik zo khi hi, ci Topa in kamsang tungtawn in a sonkhol thu a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod kumpipa in, mipil te i theam hunlam a heak ciang, a thin-uk mama a, mihing sawl in, mipil te in ama kungah phatak in a dok thu taw kisai in Bethlehem khua pan kipan a kim a pam a om patang kum ni le a nuai sia theampo that siat hi. ");
INSERT INTO csy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kamsang Jeremiah i sonkhol na ah, ");
INSERT INTO csy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramah ngam pan in kaana aw te le nasiatak in tau na aw ki za hi, a tate a om ngawl hu in Rachel i kaana sia kuama in heneam zo ngawl hi, ci thu a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herod thi zawkciang, Egypt ngam a om Joseph mang sungah Topa vantungmi khat hong kilang a, ");
INSERT INTO csy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tho in, nauno le a nu keng in Israel ngam ah paipui in: banghangziam cile nauno that nuam in a zong te thi siat zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joseph tho in, nauno le a nu Israel ngam ah paipui hi. ");
INSERT INTO csy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ahihang Archelaus in a pa Herod zalai in Judah ngam uk hi, ci Joseph in a zak ciang tua ngam ah pai ngam ngawl hi: ahihang a mang sungah Pathian in kidop natu a son bang in, Joseph zong Galilee ngam ah kiheam hi. ");
INSERT INTO csy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazareth kici khua hong theng in tua khua ah om uh hi: tabang in kamsang i sonkholsa bang in, Nazareth khuami, kici tuh hi, a ci sia hong tangtung hi. ");
INSERT INTO csy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tua hun laitak in tuiphumpa John hong theng a, Judah ngam duisung ah thuhil hi, ");
INSERT INTO csy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","John in, vantung kumpingam hong nai zo hi, na thinsung uh ki kheal in na mawna uh ki sikkik vun: ci hi. ");
INSERT INTO csy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Banghangziam cile hi thu sia, duisung ah a au mikhat i aw in, Topa pai na lampi pua vun, tangsak vun, ci kamsang Isaiah in John thu sonkhol zo hi. ");
INSERT INTO csy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","John i puansil sia kala-uk mul taw ki tak a, savun khau taw a kawng hen hi; ama an sia khaumaw le ngam khuaitui a hihi. ");
INSERT INTO csy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Taciang Jerusalem pan ahizong, Judah ngam khua tatuam pan ahizong, Jordan ngun kiim theampo pan ahizong a kungah hongpai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Amate mawna tek uh pualak in, Jordan ngun sungah tui ki phum uh hi. ");
INSERT INTO csy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pharisee te le Sadducee te tui ki phum tu in hongpai John in a mu ciang in, maw no ngul suan te, hong theng pheang tu Pathian thin-ukna taisan tu in akua in kidop natu hong pia ziam? ");
INSERT INTO csy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mawna pan ki sikkikna taw a kilawm nga pha te nga tavun: ");
INSERT INTO csy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ka pa uh Abraham hi ci in na thin sungah ngaisun heak vun: banghangziam cile, Pathian in hi suangtum te Abraham suan le pal in vawt thei hi, ci kong son hi. ");
INSERT INTO csy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tu in thingkung te bul ah heipui ki ngat zo hi: tua ahikom nga pha a nga ngawl thingkung sia phuk tu a, mei sungah bum hi. ");
INSERT INTO csy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kei ka hile mawna ki sikkik na in tui kong phum hi: ahihang ka nung pan hongpai pa sia kei sang in vanglian zaw a, a peangdap toaisak tu zong ka kilawm bua hi: Ama in Tha Thiangtho le mei taw tuiphumna hong pia tuh hi: ");
INSERT INTO csy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A khut sungah tangkheaplaw toai in, tangzap tu hi, taang tang teng beamsung ah thun tu a, taangsi te sia a mit thei ngawl mei taw hal tu hi. ");
INSERT INTO csy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tua laitak in Jesus sia Galilee pan Jordan ngun ah tui ki phum tu in John kungah hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ahihang John in ama tho a, Keima sia nangma i nong tuiphum tu hizaw napi, kei kungah nang hongpai zaw ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tasiaciang Jesus in Tu hile hibang hi phot hen, banghangziam cile thutang suana theampo a kicin kul hi, ci hi. Taciang John zong thukim hi. ");
INSERT INTO csy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus tui a kiphum zawk pociang tui sung pan hong pusuak to hi: taciang en vun, van ki hong in, Pathian Thaa sia vakhu bang hong tuaksuk in a tungah a tawl nga, John in mu hi: ");
INSERT INTO csy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Taciang van pan in aw khat in, Hisia in ka it ka Tapa a hihi, ama tungah ka lungkim hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tuazawkciang doaimangpa i ze-etna thuak tu in Thaa in duisung ah paipui hi. ");
INSERT INTO csy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Sun sawm li le zan sawm li an a tan zawkciang, Jesus a ngilkial hi. ");
INSERT INTO csy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tasia ciang ze-et tu pa hongpai a, Pathian Tapa na hile, suang hite anluum suak tu in thupia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ahihang Jesus in, Mihingte sia anluum bek taw hi ngawl in, Pathian kam pan a pusuak kammal taw nungta hi, ci in ki at hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tuazawkciang doaimangpa in Jesus sia khuapi thiangtho ah paipui a, biakinn khuvum ah a domto zawkciang, ");
INSERT INTO csy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Pathian Tapa na hile nangma le nangma ki khiasuk in, banghangziam cile Pathian in a khut taw hong dom tu in vantungmi te thupia tu a, na peang suang taw ki khen ngawl tu hi, ci ki at hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus in, Na Topa Pathian na ze et heak in, ci zong ki at thua hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tuazawkciang doaimangpa in mualsang mama tungah Jesus paipui in, leitung kumpingam theampo le vangletna te lak a, ");
INSERT INTO csy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ka mai ah kun in nong bia le, hi teng theampo kong pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tasiaciang Jesus in, Satan awng, tai in: banghangziam cile, Topa na Pathian bek bia in a, Ama na bek seam in, ci in ki at hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tasiaciang doaimangpa sia Jesus kung pan in tai a, vantungmi te hongpai in Jesus ou uh hi. ");
INSERT INTO csy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","John thongtak hi, ci thu Jesus in a zakciang in, Galilee ah pai hi; ");
INSERT INTO csy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazareth khua nusia in, Capernaum ah om tu in pai hi, tua khua sia Zebulun le Naphtali ngamngi, tuipi hui ah a om khua a hihi. ");
INSERT INTO csy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hibang teng sia kamsang Isaiah i sonkholsa, ");
INSERT INTO csy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulun ngam le Naphtali ngam, Jordan ngun ngal tuipi pai na lam hui, Gentile mite omna mun Galilee; ");
INSERT INTO csy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Khuazing sungah a teang mihingte in, a lian mama khuavak mu tu a, thina lim nuai ah a omte tungah khuavak tang tu hi, ci thu a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tua hun pan kipan Jesus in, Na mawna ki sikkik vun: banghangziam cile vantung kumpingam hong nai zo hi, ci in thuhil kipan hi. ");
INSERT INTO csy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus Galilee hui ah a va laitak in ngasa man te u nau ni, tui sungah ngen a pai laitak mu hi, tua u nau ni te sia Peter a kici Simon le a nau Andrew te a hihi. ");
INSERT INTO csy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesus in amate tung ah, Hong zui tavun, mihing mante kong suaksak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tasia pociang amate in a ngen te nusia uh a, ama zui pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tua mun pan a paisuak uh ciang, Zebedee tapa te ni James le John te u nau mu hi, amate sia a pa taw ngunkuang sungah a ngente a phaw laitak hi a; Jesus in amate sam hi. ");
INSERT INTO csy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tasia pociang a ngunkuang le a pa nusia in zui pai hi. ");
INSERT INTO csy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus Galilee ngamsung theampo ah vak in, amate synagogue tatuam te ah thuhil a, kumpingam lungdamna thu son kawm in natna tatuam a thuak cina te damsak siat hi. ");
INSERT INTO csy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Syria ngamsung theampo ah a minthang mama a: natna le ngimna namcin a thuak cina theampo ahizong, doai vei te, butthi thei te le langngaw te damsak siat hi. ");
INSERT INTO csy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilee, Decapolis, Jerusalem, Judah le Jordah ngunngal pan mihon tampi te in Ama zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tua mihonpi te Jesus in a mu ciang in mualtung ah kato hi: a tosuk zawkciang, a nungzui te a kungah hongpai uh hi: ");
INSERT INTO csy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Taciang a kam hong in, amate thuhil a, ");
INSERT INTO csy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Thaa thu ah a zawngkhal te thuphatoai a hihi: banghangziam cile vantung ki ukna sia amate a, a hihi. ");
INSERT INTO csy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Thum le tau in a kap te thuphatoai a hihi: banghangziam cile amate in henepna nga tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mi nunneam te thuphatoai a hihi: banghangziam cile amate in leitung ngamh lua tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Thutang suana an du tui du bang in a du te thuphatoai a hihi: banghangziam cile amate a ngilva kik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Hesuakna neite thuphatoai a hihi: banghangziam cile amate hesuakna ma sangkik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Thin sung thiangtho te thuphatoai a hihi: banghangziam cile amate in Pathian mu tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kilemna a vawt te thuphatoai a hihi: banghangziam cile amate Pathian tate kici tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Thutang suana hang in vawtsiatna a thuak te thuphatoai a hihi: banghangziam cile vantung ngam sia amate a, a hihi. ");
INSERT INTO csy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Keima hang in ngual in mawsiatna taw hong vawtsia a, leilot thu a tatuam a son ciang in, thuphatoai na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Lungdam vun a, angtang vun, banghangziam cile vantung ah na thaman uh lian mama hi: banghangziam cile note mai ah kamsang te zong tabangma in vawtsia ngei uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Note sia leitung i ci na hi uh hi: ahihang ci sia a al na a om nawn bale, bangbang in al kik thei tu ziam? doipua ah vawk in peangtaw siicil tu simngawl bangma phatuam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Note sia leitung i khuavak na hi uh hi. Mualdawn ah a kisa khuapi sia kilia thei ngeingawl hi. ");
INSERT INTO csy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kuama in khuaimei a det ciang khum taw khup ngei ngawl hi, meidetna munsang na ah suan in de hi; taciang tua meivang in innsung theampo tangsak hi. ");
INSERT INTO csy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na khuavak uh midang te muna ah tang tahen, tabang in amate in a pha na vawt te mu tu a, van ah a om na Pa pokna pia tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Keima sia thukham le kamsang te thu siatsua tu in hongpai hi, ci in ngaisun heak vun: siatsua tu in hongpai ngawl khi hi, a kicingsak tu in hongpai zaw khi hi. ");
INSERT INTO csy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Amantak kong son hi, van le lei a bo zong thukham sung pan a nobel bawkno khat zong khuangkhim ngawl in bo thong ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tua ahikom, a kuamapo in, thupiak te sung pan a nobel khat pealkhial in, ngualdang thu a hil le, vantung kumpingam sungah a nobel hi kici tu hi: ahizong in a kuamapo in thupiakte seam a, ngualdang zong a hil le, vantung kumpingam sungah lian hi, kici tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Banghangziam cile, thukhamhil te le Pharisee te na dem zo bua u le, vantung kumpingam sungah tum thei ngawl tu nu hi, ci in kong son hi. ");
INSERT INTO csy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nidanglai in, tualthat heak in; tualthat te thukhenna thuak tu kilawm hi, ci thu na zazo uh hi. ");
INSERT INTO csy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ahihang keima in hibang in kong ci hi, a kuamapo matlap nei ngawl in a suapui te tungah a thin-uk peuma, thukhenna thuak tu hi: taciang a kuamapo in, a suapui a zawngsak sia zong thukhen upa te kung puak tu kilawm hi: a kuamapo in, a suapuipa mi ngoai a ci peuma, hell sung a theng tu kilawm hi. ");
INSERT INTO csy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tua ahikom biaktau tungah piak tu na ken ciang in, na suapui khatpo i hong mawsiatna khatpo na phawk le, ");
INSERT INTO csy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Na piaktu sia biaktau mai ah nusia phot in a, na suapuipa kungah pai masa in; kilemna na vawt zawkciang, biakpiakna pia kik pheang in. ");
INSERT INTO csy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Khatpo in thu hong vawt a hile, zumkong na thetma in, lamkallak ah manlang in ama taw thukimna vawt pak in; tabang a hibale, thukhen te kung hong ap tu a, thukhen te in palik te hong ap in, palik te in thonginn ah hong khia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A mantak kong ci ciang, liausum na piak siat mateng thonginn sung pan na suakta thei batu hi. ");
INSERT INTO csy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nidang in palngul mawna vawtheak in, ci sia na zaksa uh a hihi: ");
INSERT INTO csy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ahizong tu in, khatpo in numei khat khialpui nopna thin taw a en a hile, a thin sung pan tua nu taw khial zo hi. ");
INSERT INTO csy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Na ziatsang mit in hong khialsak a hile, khelkeak in vawk in: na pumpi vekpi taw hell sungah na ki khiak tu sang in pumpi khen khat na sup tu phazaw hi. ");
INSERT INTO csy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Na ziatsang khut in hong khialsak le, tan in vawk in: na pumpi vekpi taw hell sungah na ki khiak tu sang in pumpi khen khat na sup tu phazaw hi. ");
INSERT INTO csy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Khat po in a zi a khul nuam a hile, khulna lai pia tahen, kici hi: ");
INSERT INTO csy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ahihang keima in, khatpo in paktatna thu simngawl a zi a khul le, a zi sia palngul mawna vawt suaksak hi, taciang tua a ki khul numei a tenpui kik pa zong, palngul mawna vawt ma hi veve hi. ");
INSERT INTO csy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nidang in, kamciam pia heak in, ahihang Topa kungah na kiciamna te tangtun in, ci thu na zazo uh hi: ");
INSERT INTO csy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ahihang kei ka hile hibang kong ci hi, kiciamna vawt lilim heak in; van sam in kiciam heak in; banghangziam cile Pathian kumpi tokhum a hihi: ");
INSERT INTO csy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Lei sam in kiciam heak in; banghangziam cile Pathian i peang ngakna mun hi: Jerusalem sam in zong kiciam heak in; banghangziam cile a lian kumpipa omna mun khuapi a hihi. ");
INSERT INTO csy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na lu sam in zong kiciam heak in, banghangziam cile na samzamno khat vomsak le kangsak thei ngawl ni hi. ");
INSERT INTO csy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ahihang, ngualdang taw na ki paupui ciang in, A “hi” te ‘hi'; a “hi ngawl” te “hi ngawl” ma ci vun: banghangziam cile hi teng zawkciang sia pha nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mittang khat luang in mit tang khat, ha tang khat luang in ha tang khat, ci thu na zaksa uh a hihi: ");
INSERT INTO csy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ahihang kei hibang in kong ci hi, siatna te na khak heak vun: khatpo in na ziatsang biang hong beang le, na veisang biang zong daw vet lai in. ");
INSERT INTO csy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khatpo in na puansil dei in thu hong vawt le, na tungsil zong pia vet in. ");
INSERT INTO csy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nang hong zawthawkvawt khatpo in tai khat hongpaisak le, tai ni dong paipui vet in. ");
INSERT INTO csy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Van hong ngen te pia in, ciang hong pu nuam te zong nial heak in. ");
INSERT INTO csy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Na innpam it in, na ngal te ensan in, ci thu na zaksa uh a hihi. ");
INSERT INTO csy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ahihang kei kong cina pan, na ngal te uh it vun a, no hong hamsiat te thupha pia vun, no hong ensan te atu thungetsak vun; ");
INSERT INTO csy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tabang in vantung a om na Pa uh i tate na hi tu uh hi: banghangziam cile Ama in misia le mipha te tungah ni suaksak a, thuman le thuman ngawl te tungah ngua zusak hi. ");
INSERT INTO csy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Banghangziam cile no hong it te bek na it uh le, bang thaman a om ziam? siadong te nangawn zong in tabangma seam hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Na suapui te bek na paupui uh le, ngualdang taw bang ki lamdang nu ziam? siadong te zong tabangma vawt hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Vantung a na Pa uh cialcing ahi bangma in, note zong na cialcing ta vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Mizawng te hu na na piak uh ciang in ngual mai ah na vawt thak tu kidawm vun, tabang in ngual mu na ah na vawt uh le vantung a om na Pa uh kung pan in thaman bangma nga ngawl tu nu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tua ahikom, mizawng te hu na na piak uh ciang in, a ki hitheamsak te in ngual pok tu thangai in synagogue sung le lampi dung teng ah a vawt bang in, na mai uh pan lemle tum in vawt heak vun. Amantak kong ci ciang, amate thaman a sang hi zo uh hi. ");
INSERT INTO csy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ahihang mizawng te hu na na piak ciang in, na ziatsang khut i sep sia, na veisang khut in he heak tahen: ");
INSERT INTO csy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kuama heak ngawl in mizawng te na hu na, thuku a mu na Pa in thaman a kilangtak in hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Thu na nget ciang in a ki hitheamsak te bang in ngen heak in: banghangziam cile amate sia synagogue sung le lamkabom ah ding in, ngual i mu thei tu in thungen nuam sap si. Amantak in kong ci ciang, amate in thaman nga zo uh hi. ");
INSERT INTO csy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ahihang, thu na nget ciang in, na inndoi sungah tum in a, kongkha na kha zawkciang, a ki mu ngawl na mun ah a om na Pa kungah thungen in; taciang thuku a mu na Pa in a kilangtak in thaman hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ahizong, thu na nget ciang in Pathian nei ngawl te in matlap nei ngawl a thuap kikik bang in ngen heak vun: banghangziam cile amate in tam tatak ngen bialbual le Pathian in za tuansap tu in um uh hi. ");
INSERT INTO csy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amate bang hi heak vun: na kisapna uh na nget uh ma in, na Pa uh in he siat zo hi. ");
INSERT INTO csy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tua ahiciang, hibang in thu ngen vun: vantung a om kote Pa awng, na min thiangtho ki upat tahen. ");
INSERT INTO csy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na kumpingam hong piang tahen. Vantung ah na deina a kicin bang in, leitung ah kicing tahen. ");
INSERT INTO csy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tu ni in ka nisim an uh hong pia ta in. ");
INSERT INTO csy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ngual dang mawna ka maisak uh bangma, kote mawna zong hong maisak ta in. ");
INSERT INTO csy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ze-etna sungah hong paipui ngawl in, phatngawlna sung pan in hong tankhia tan: ukzawkna, vangletna le minthanna a tawntung in nangma a, a hihi. Amen. ");
INSERT INTO csy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngual i khialna te na maisak uh le, vantung a om na Pa in note khialna zong hong maisak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ahihang ngual khialna na maisak bua uh le, noma khialna te zong na Pa uh in hong maisak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Bektham ngawl in, an na tan uh ciang in, a ki hitheamsak te bang in maikhing in om heak vun: banghangziam cile amate in ngual mu na ah antang ci a ki heak thei natu in maikhing in om uh hi: Amantak in kong ci ciang, amate in thaman a sang zo uh hi. ");
INSERT INTO csy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ahihang, nang na hile, an na tan ciang in, na lu sathau thi in a, na mai phiat in. ");
INSERT INTO csy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tua hile na antan hunlam ngualdang kungah ki lang ngawl tu a, a kimu ngawl na mun ah a om na Pa mai bek ah kilang tu hi: taciang thuku a mu na Pa in kilangtak in thaman hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nget i neak thei, eakseau thei le nguta te i phul in a nguk theina hi leitung ah na neisa uh khol heak vun: ");
INSERT INTO csy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nget i neak thei ngawl, eakseau thei ngawl le nguta te in phul in a nguk thei ngawl na mun, vantung ah noma atu in na neisa te khol zaw tavun: ");
INSERT INTO csy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Banghangziam cile na neisa omna mun ah na thin le lung zong om tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Mittang sia pumpi atu in khuavak a hihi: na mit a ciim le, na pumpi khuavak siat tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ahizong, na mit a pha bua a hile, na pumpi theampo mial siat tu hi. Tua ahikom na sungah a om khuavak a thim le, tua khuazing sia bangza zing tuh ziam? ");
INSERT INTO csy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kuama in to ni i sal hi thei ngawl hi: banghangziam cile ama in khat ensan tu a, khat it tu hi; khat zaw sia beal tu a, a dang khat sia thusimngawl tu hi. Pathian le neisa i sal na seam khawm thei batu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Tua ahikom kei kong ci na ah, bang na ne tu uh a, a hibale, bang dawn tu nu ziam: taciang na pumpi atu in, bang na sil tu uh ziam, ci in na nuntakna atu in thintoi heak vun. An le tui sang in nuntakna, nik le puan sang in pumpi thupi zaw hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Van a leang vacim te en vun: amate in thai cing ngawl, anla ngawl a, saal sungah zong khol ngawl hi; ahihang vantung ah a om na Pa in amate vak hi. Vacim te sang in thupi zaw hi ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Note sung pan thintoi na taw a khan tong khat a pe thua thei akua om ziam? ");
INSERT INTO csy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Banghang in nik le puan atu thintoi nu ziam? Duisung ah unok pak te bangbang in khang ziam, ci in ngaisun vun; naseam ngawl hi, pat khau zong hual ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kei kong ci na pan, Solomon in a vangletna theampo taw a kipua ciang zong tua unokpak te khat zong ban ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tua ahikom, tu in pak a, zingciang in vawk in a ki hal tu lo lai a lopa te bekzong Pathian in zeam a hile, tua te sang in, note hong zeam zawkan lai tu hi ngawl ziam, maw no upna no te. ");
INSERT INTO csy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tua ahikom, bang i ne tu ziam? a hibale, bang i dawn tu ziam? a hibale, bang sil tu hi ziam, ci in thintoi heak vun. ");
INSERT INTO csy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Banghangziam cile hite theampo sia Gentile te in zong thei bul uh hi: hibang te na kisap uh hunlam vantung ah na Pa uh in he nginge hi. ");
INSERT INTO csy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tua sang in Pathian kumpingam le ama i thutang suana zong masa vun; taciang hi nate theampo zong hong pia thua tu hi. ");
INSERT INTO csy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tua ahikom zingciang atu in thintoi in om heak vun: banghangziam cile zingciang in ama atu thintoi tu zam. Tuni phatngawlna teng tuni atu kicing zo hi. ");
INSERT INTO csy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Thukhenna taw na ki peal thei natu in, ngualdang thukhen heak vun. ");
INSERT INTO csy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Banghangziam cile ngualdang te thu na khen uh bangma in, ngualdang te in zong no tung thu hong khen tu hi: ngualdang te na tekak bangma in hong te kik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na mit sungah thing tawnpui thintoi ngawl in, na suapuipa mitsung a om nin themno sia banghang en ni ziam. ");
INSERT INTO csy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Na mitsung a om thing tawnpui om nginge in, na suapuipa mitsung a om nin themno sia kong kheisak tu, bangbang in ci thei tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","A ki hitheamsakpa, na mitsung a thing tawnpui sia vawk masa in a; tuazawkciang na suapuipa mitsung a nin themno sia kheisak tu in thiangtak in mu thei tu ni hi. ");
INSERT INTO csy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","A thiangtho nate ui te na pia heak vun a, vok te mai ah pale te lot heak vun, a peang nuai ah sikcil tu a, leheak in hong pet tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ngen vun, hong pia tu hi; zong vun, mu tu nu hi; king vun, hong ki hon tu hi: ");
INSERT INTO csy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Banghangziam cile a ngen te in nga hi; a zong te in mu hi; a king te ki hon tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na tate in anluum hong ngen le, a kua in suangtum na pia tu uh ziam? ");
INSERT INTO csy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ngasa hong ngen le, kua in ngul na pia tu uh ziam? ");
INSERT INTO csy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Na phat ngawl uh kawm pan in na tate letsong pha nano piak tu na he uh le, vantung a a om na Pa uh in a ngen te a tamzawkan in pia ngawl in om tu ziam? ");
INSERT INTO csy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tua ahikom ngual in no tungah hong vawt le na oai uh theampo, ngualdang tungah zong vawt tavun: banghangziam cile hiteng theampo sia thukham le kamsang te thu theampo a khaikim thu a hihi. ");
INSERT INTO csy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kongbiang ciak pan in tum vun: banghangziam cile siatna a then kongpi le lampi sia zai mama a, a tum tam mama hi: ");
INSERT INTO csy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Banghangziam cile nuntakna a then kongpi le lampi sia ciak a, tua lampi a mu tawm hi. ");
INSERT INTO csy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","A sungsang sia ngia hangsan hi napi, ki phualseal in na kung hongpai leilot kamsang te kidawm vun. ");
INSERT INTO csy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ama te i nga tungtawn in na tel tu uh hi. Mihing te in lingkung pan in sapit le thei a lo ngei ziam? ");
INSERT INTO csy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tabangma in thingkung pha in nga pha nga a; thingkung phangawl in nga phangawl ma nga hi. ");
INSERT INTO csy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Thingkung pha in nga phangawl a nga thei ngawl bangma in, thingkung phangawl zong nga pha nga thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nga pha nga ngawl thingkung peuma phuk in, meisung ah khia hi. ");
INSERT INTO csy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tua ahiciang amate i nga te pan in amate hina tatak na tel tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Topa, Topa, ci in hong sam theampo vantung kumpingam sungah tum siat ngawl tu uh hi; ahizong vantung a a om ka Pa deibang a seam te bek tum tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tua ni ciang in, Topa, Topa, na min taw mailam thu sonkhol hi ngawl khu ziam? taciang na min taw doai te zong hawlkhia hi ngawl khu ziam? bekdom ngawl in na min taw nalamdang tam mama vawt hi ngawl khu ziam? ci in mi tampi te in ka kungah hong ci lai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tasiaciang, note kong he ngei bua hi: na phangawl seam te ka kung pan kiheam vun, ci in ka pualak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Tua ahikom, a kuamapo in, ka son thu za a, a seam te sia suangtung ah innsa mipil pa taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nguazu in khuanawl suak a, huipi in tua inn sia nawm in nuaicip napi; puk ngawl hi: banghangziam cile suangtung ah a kisak hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Akua mapo in ka son thu te za napi, a seam ngawl sia, senneal tungah innsa mi mawmawpa taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nguazu in khuanawl suak a, huipi in tua inn sia nawm in a nuaicip ciang in; tua inn puk hi: a nasia mama puna a hihi. ");
INSERT INTO csy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus in hi thu te a son zawkciang in, mihon te in ama hilna lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Banghangziam cile thukham hil te bang hi ngawl in, thunei ulian khat bang in hil hi. ");
INSERT INTO csy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus mualtung pan hong tuaksuk ciang in, mihonpi te in zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tasiaciang miphak khat a kungah hongpai in, a biak zawkciang, Topa, uk hipo le te, hong thiangsak thei ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesus in a khut zan in, tham a, Ka uk hi, thiang tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesus in tua pa tung ah, Ngai in, kuama son heak in; ahihang thiampipa kungah pai in kilak in, midang atu tetti hi tu in, Moses thupiakna bang in, biakpiakna pia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesus Capernaum khua sung a tum ciang in, zakhat uk ngalkapmang khat a kungah hongpai in, hesuak ngen hi, ");
INSERT INTO csy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Topa awng, ka naseampa langngaw nat na in inn ah lum a, ngim mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus in ama kungah, Hongpai in damsak tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tua ngalkap mangpa in, Topa, nangma vateak ka inn sung dong nong pai tu ki phu ngawl khi hi: ahizong paukhia po le te, ka naseampa dam lel tu hi. ");
INSERT INTO csy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Banghangziam cile keima sia thuneina khutnuai a om ka hi a, ka khutnuai ah zong ngalkap te nei khi hi; khatpo pai in, ka cile pai a, a dang khat sia hongpai tan, ka cile hongpai hi; ciang ka naseam khat, hisia seam in ka cile seam hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesus in hi thu a zak ciang, lamdangsa in, a nungzui te kungah, A tatak in ka ci ciang, Israel te sung nangawn ah hibangza a lian upna mu ngeingawl lai khi hi. ");
INSERT INTO csy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kei kong ci na ah, nisuana le nitumna pan in mihing tam mama hongpai tu a, vantung kumpingam sungah Abraham, Isaac le Jacob te taw to khawm tek tu hi. ");
INSERT INTO csy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ahihang kumpingam sungah a omte sia kaana le ha ngoaina om na mun, doipua khuazing sungah ki khia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus in ngalkap mangpa kungah, Cia kik tan, na upna bang in ki vawtsak zo tu hi, ci hi. Ngalkap mangpa naseampa tua hun laitak lian in dam hi. ");
INSERT INTO csy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus Peter innsung a tum laitak in, Peter zi i nu sia cisa natna taw dam ngawl in a om mu hi. ");
INSERT INTO csy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus in a khut pan tham in, a cisa dam hi: taciang tho in amate leangna do hi. ");
INSERT INTO csy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nitak sang hong thet ciang in, doaivei tam mama hong paipui uh hi: Jesus in a kammal taw thaa niin te hawlkhia in, cina theampo damsak siat hi: ");
INSERT INTO csy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Hi thu sia, Ama vateak ma in i thaneamna le i natna theampo hong laksak siat hi, ci in kamsang Isaiah sonkhol thu a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus in a kim a om mihon tampi te a mu ciang in, ngalkhat ah pai tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Thukhamhil khat a kungah hongpai a, Syapa awng, na pai na po ah kong zui tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesus in, Ngia te in kua nei a, tungleang vacimte in zong bu nei uh hi; ahihang mihing Tapa in a lu ngak natu nangawn zong nei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A nungzui dang khat in, Topa awng, pai in ka pa hong vuisak masa tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ahihang Jesus in, Hong zui tan, mithi te in amate i mithi te vui tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesus ngunkuang sung a tum ciang in, a nungzui te in zui hi. ");
INSERT INTO csy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Taciang en vun, tuipi sungah huipi suangval hong tho ngawp a, ngunkuang sia tui in khum hi: ahihang Jesus sia mu hi. ");
INSERT INTO csy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","A nungzui te hongpai in phong a, Topa awng, hong hun tan: bocip khu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesus in, Banghang in lau nu ziam, upna no te awng? ci hi. Tuazawkciang Jesus tho in, hui le tuipi thupia hi; taciang thim khipkhep hi. ");
INSERT INTO csy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Amte in lamdang sa mama uh a, hi sia pa sia bangbang mihing hi tu ziam, hui le tuipi te nangawn in a thu ngai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesus ngalkhat Gargesenes ngam a thet ciang in, than pan hong pusuak doai vei thin-am ni taw ki si hi, amate sia ngilo mama ahikom, tua lampi sia kuama in tawn ngam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Amate au in, Jesus, nang Pathian Tapa, ko kungah bang kin nei ni ziam? A hun cin ma ko hong vawtsia tu in hongpai ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tuak sung pan a khuala hiat na mun ah an zong tu a ki tha vok hon te om hi. ");
INSERT INTO csy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Doai te in Jesus thum uh a, nong hawlkhia tu a hile, zesung vok hon te sungah hong tumsak tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesus in, Pai vun, ci hi. Amate pusuak in vok hon te sungah tum uh hi: taciang, en vun, vok te a vekpi in tai a, tuipi sungah kinuntaw suk in, tuisung ah thi siat hi. ");
INSERT INTO csy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Vokcing te khuapi sungah tai in, doai vei te ni tungah thupiang teng son uh hi. ");
INSERT INTO csy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tua ahikom khuapi sung mihing bup Jesus munuam in hongpai tek uh a: a mu uh ciang amate ngamngi pan pusuak tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus ngunkuang sungah tum a, a langkhat dong kantan in, ama khuapi ah theng hi. ");
INSERT INTO csy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Langngaw natna hang in lupna tungah a lum cina khat, Jesus kungah hong paipui uh hi: Jesus in amate upna a mu ciang in cina pa kungah, Ka tapa awng, thinnuam in om in; na mawna ki maisak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tasiaciang thukhamhil te pawlkhat in, hi sia pa in Pathian thusimngawl hi, ci in a thin sung uh pan ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tabang in a ngaisut uh Jesus in he a, Banghang in thuphangawl na thin sung uh pan ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Na mawna hong ki maisak zo hi; a hibale, tho in a, lampai in, ci koisia ol zaw ziam? ");
INSERT INTO csy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mihing Tapa in leitung ah mawmaisak theina vangletna nei hi, ci na heak thei natu uh hi, ci in, cina pa kungah, tho in a, na luppha la in, na inn ah cia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Taciang ama zong tho in, a inn ah cia hi. ");
INSERT INTO csy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tua thu mipi te in a mu uh ciang in, lamdangsa tek in, hibang in mihing te tungah vangletna a pia Pathian poktek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesus tua mun teng kantan in a pai ciang, Matthew a kici pa khat shia piakna zum sungah ato mu a: Hong zui tan, ci hi. Taciang ding vangiat in Jesus nungzui hi. ");
INSERT INTO csy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tuazawkciang in, Jesus anne tu in a to ciang, siadong te le mawnei te zong hongpai in nungzui te taw tokhawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharesee te in a mu ciang in a nungzui te kungah, na syapa uh banghang in hibang mite taw anne ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ahihang Jesus in a zakciang in amate tung ah, A cidam te in syavuan kisam ngawl hi, cina te bekma in kisam hi. ");
INSERT INTO csy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ahihang pai tavun a, biakpiakna sang in hesuakna dei zaw khi hi, ci thu a khiakna sin tavun: banghangziam cile mipha te sam tu in kong pai bua hi, mawnei te ki sikkik natu kong pai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tuazawkciang, John nungzui te a kungah hongpai a, koma le Pharesee te antang tawntung khu hi, banghang na nungzui te antang ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus in, Bangbang in zinei pa om laitak in a lawmte antang tu ziam? ahihang zinei pa sia amate kung pan in mundang ah a ki paipui zawkciang amate antang pheang tu hi. ");
INSERT INTO csy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kuama in puan luisa khat a thak taw phaw thua ngei ngawl hi, banghangziam cile, tua a phaw thua na puanthak in puan lui sia kaikin tu a, ekkeak seseam tu hi. ");
INSERT INTO csy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tasia bangma in savun um lui sungah kuama in sapittui thak thun ngei ngawl hi: a thun le savun um tamtham tu a, sapittui buasiat in, savun um zong laltham tu hi: ahihang sapittui thak sia savun um thak sungah a thun le, a ni ma pha khawm tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tua thu a son laitak in, Ulian khat Jesus kungah hongpai in bia a, ka tanu tulian ma in thi hi: ahihang hongpai in atung ah na khut suan in, tuahile ama nungtakik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus ding in ama zui a, nungzui te in zong zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Tasiaciang, kum sawm le kum ni sung thisuak natna a nei numei khat a nungsang pan hongpai in, Jesus puan mong tham hi: ");
INSERT INTO csy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","A puanmong beak ka tham zong, dam tu khi hi, ci a thinsung pan ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus in le-et kik in, numei nu a mu ciang, Ka tanu awng, na thin nuamsak in; na upna in hong damsak zo hi, ci hi. Tua hun lian pan in numei nu dam hi. ");
INSERT INTO csy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tuazawkciang Jesus ulianpa inn sung a tum laitak in, tumnging tum te le mihing te ngamlum litlut in om khawm tek a mu ciang, ");
INSERT INTO csy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Amate kungah, Hong pial tavun: banghangziam cile hi numeino sia thi ngawl hi, mu hi, ci hi. Tasiaciang amate in nuisan uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Mihonte a pusua zawkciang, a sungah tum a, a khut pan len hi, taciang numeino hong tho hi. ");
INSERT INTO csy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hi thu tua ngam sung bup ah thang hi. ");
INSERT INTO csy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus tua mun pan a pai ciang, mittaw ni te in zui in au kawm a, nang David tapa, hong hesuak kapo in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus inn sungah atum ciang in, mittaw te a kungah hongpai a: Jesus in, Hi thu seam thei tu in nong um uh ziam? ci hi. Amate in hong um khu hi Topa awng, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tasiaciang, Jesus in amate mit thamsak in, Na upna uh bangin piang tahen, ci hi ");
INSERT INTO csy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tasiaciang in amate mit ki hong kik a, Kuama na hesak heak vun, ci in Jesus in nasiatak in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ahihang amate pai in, Jesus thu sia tua ngamsung theampo ah kizelsak hi. ");
INSERT INTO csy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Amate a pusua uh ciang, doaivei hang in a pau thei ngawl khat a kungah hong paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tua doai a hawlkhiat zawkciang, a pau thei ngawl pa sia hong pau in: mipi te in lamdangsa mama uh a, Israel mite sungah hibang i mu ngei balai hi, ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ahihang Pharisee te in, doaikungpu vang taw in doai te nawt hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus khuapi le khuano te ah vak kakoai in, amate synagogue sungah kumpingam lungdamna thu son kawm in, natna namcin a thuak te damsak siat hi. ");
INSERT INTO csy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mihon te amu ciang in, amate tung hesuakna thin nei hi, banghangziam cile amate sia toi mama uh a, a cing tu om ngawl a peakkeak tuu taw kibang sa hi. ");
INSERT INTO csy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tuazawkciang, a nungzui te kungah, Anlak tu tam mama napi, naseam te tawm hi; ");
INSERT INTO csy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tua ahikom anneipa tung ah, anla tu naseam mi tam mama hong sawl natu, thu na ngen vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesus in nungzui sawmleni te sam in, tha-nin te hawlkhiat thei natu le natna namcin damsak thei na vangletna pia hi. ");
INSERT INTO csy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nungzui sawmleni te i min sia hi teng a hihi; a masa phit in Peter kici Simon le a nau Andrew; Zebedee i tapa James le a nau John; ");
INSERT INTO csy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip le Bartholomew; Thomas le siadongpa Matthew; Alphaeus i tapa James le Thaddaeus kici Lebbaeus; ");
INSERT INTO csy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Canan minam Simon, le Jesus leheakpa Judah Iscariot te a hihi. ");
INSERT INTO csy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Hi sawmleni teng paisak in thupia hi, Gentile te kung paina lampi le Samaria minam te i khuapi sungah tum heak vun: ");
INSERT INTO csy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ahihang, Israel minam sung pan a mangthang tuu te kungah pai zaw vun. ");
INSERT INTO csy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Na pai uh kawm, vantung kumpingam hong nai zo hi, ci in thuhil tavun. ");
INSERT INTO csy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cina te damsak vun, miphak te thiangsak vun, mithi te thosak vun, doai te hawlkhia vun a, a thong in na san uh te sia a thong ma in pia tavun. ");
INSERT INTO csy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na sumbawm uh sungah kham, ngun le tau ngo te keng heak vun, ");
INSERT INTO csy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Na khualhaw na atu thungkua ahizong, puan sil ni ahizong, peangdap kop ni le ciangkhut te zong keng heak vun: banghangziam cile naseampa an vak tu kilawm hi. ");
INSERT INTO csy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Khuapi sung a hibale, khuapi khatpo sung na tum tu uh ciang, zintun natu a ki phu le a ki phu ngawl dong masa vun; na pusuakik dong tua mun ah tam vun. ");
INSERT INTO csy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Innsung na tum uh ciang, innteak te nukset vun. ");
INSERT INTO csy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tua inn sia a ki phu le, ama tungah na thupha uh theng tu hi: ahihang a ki phu bale, noma tungah hong heakkik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Taciang khatpo in note hong sang ngawl le na thu uh hong ngai nuam ngawl te tung ah, a inn a hibale, a khuapi pan na pusua uh ciang, na peang i leivui te thin vun. ");
INSERT INTO csy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A tatak kong ci ciang, thukhen ni ciang in tua khuapi sang in Sodom le Gomorah te thuakna sia ol zaw lai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","En vun, ngia hon sungah tuu bang in kong paisak hi: Tua ahikom ngul bang in pilvang vun a, vakhu bang in cingh tavun. ");
INSERT INTO csy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mihing te kidawm vun: banghangziam cile zum ah hong ap tu a, synagogue sungah hong vel tu hi; ");
INSERT INTO csy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Keima, na tetti pan na uh le Gentile te hang in thunei te le kumpi te mai ah hong puak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ahihang amate i hong ap ciang in, bang son tu le bangbang son tu, ci thintoi in om heak vun: banghangziam cile a hun a cin ciang na pau tu uh hong kipia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Banghangziam cile noma pau hi ngawl in, na sung uh ah a om na Pa uh i Thaa in pau hi zaw hi. ");
INSERT INTO csy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Suapui laipe cilteal zong thina ciang ki then tu a, a pa in a tapa ahizong: tate in a nu le a pa ahizong thina dong ki then tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ka min hang in mi theampo in hong ensan tu hi: ahihang a tawp dong a thuakzo sia suatakna nga tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Hi khuapi sungah hong ki vawtsia le, a dang khat ah tai vun: A tatakin kong ci ciang, mihing Tapa hong paikik ma in, Israel te khuapi theampo thengsiat man ngawl tu nu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Nungzui khat sia a syapa sang in a sanzawk ngawl bangma, naseam pa zong a topa sang in sangzaw ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nungzui sia syapa bang ahizong, naseam khat sia a topa taw a kibang le, pha zo hi. Innteak sia Beelzabub a kici le, a innkuanpui te kicizaw kan tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Tua ahikom, amate lau heak vun: a kilang ngawl tu in phualseal thei a om ngawl bangma; heak ngawl tu in a ki phualseal thei zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Khuazing sungah kong son te sia khuavak sungah son tavun a, a thimtham na zak uh te innkhum tung pan in na thangsak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Taciang, pumpi that in, tha a that thei ngawl te lau heak vun: ahihang tha le taksa pumpi hell sungah a lalcip khawmsak thei sia lau zaw vun. ");
INSERT INTO csy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tonbawm ni sia pia khat in ki zuak hi ngawl ziam? ahizong tua tonbawm khat nangawn na Pa thu ngawl in lei ah tak ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ahihang note na hi uh le na lu tungah na samzam te dong in hong ki simsak siat sa a hihi. ");
INSERT INTO csy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tua ahikom lau heak vun, note sia tonbawm tam mamate sangin manphazaw nu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Akua mapo mipi mai ah kei hong pualak peuma, vantung Pa mai ah ama zong ka pualak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ahihang mihingte mai ah kei hong nial peuma, vantung Pa mai ah zong ka nial tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Leitung ah kilemna puak tu in hongpai hi, ci in ngaisun heak vun: kilemna puak tu in hongpai ngawl zaw in, namsau taw hongpai khi hi. ");
INSERT INTO csy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Banghangziam cile Keima sia, pa le tapa te, nu le tanu te, nu le monu te ki tukalsak tu in hongpai khi hi. ");
INSERT INTO csy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Khatpo i a ngal te sia ama innsung pan hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Akua mapo kei sang in a nu le a pa a it zaw sia, kei taw ki phu ngawl hi: kei sang in a tapa le a tanu a it zaw sia kei taw ki phu ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Akuamapo ama thinglamte pua in ka nung hong zui ngawl peuma, kei taw ki phu ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","A nuntakna a zong peuma a nuntakna sum tu hi, keima hang in a nuntakna a suplaw peuma nuntakna mu tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Note hong sang peuma keima hong sang hi a, keima hong sang peuma in keima hong sawlpa a sang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kamsang min taw kamsang a sang peuma thaman nga tu hi; mipha min taw mipha a sang peuma thaman nga tu hi. ");
INSERT INTO csy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A tatak kong ci ciang, a kuamapo in, a nobel te sung pan, khatpo sia nungzui mintaw tuivot hai no khat a pia le, thaman sumthong peuma ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus in a nungzui sawmleni te thu a hil zawkciang, tua mun pan pusuak in, amate khuapi sungteng ah hilna pia tu le thuhil tu in pai hi. ");
INSERT INTO csy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Thonginn sung pan in tuiphumpa John in Christ nasep nate a zak ciang in, a nungzui ni te sawl a, ");
INSERT INTO csy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesus kungah, Nangma sia hongpai tu pa na hi ziam, a hibale a dang ngak laitu khu ziam, ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus in, Heakkik tavun a, na zak le na mu uh teng John tungah sonkik vun; ");
INSERT INTO csy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mittaw te khuamu in, peangbai te lampai thei a, miphak te thiang in, nangong te khuaza thei a, mithi te thosak in, mizawng te tungah lungdamna thu ki tangko zo hi. ");
INSERT INTO csy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Akua mapo kei hang in muanlakna a nei ngawl te thuphatoai a hihi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Amate a heakkik zawkciang Jesus in mipi te tungah John thu son kipan a, Duisung ah bang en tu in pai nu ziam? Hui i seam phaikung ngawk ziam? ");
INSERT INTO csy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bang en tu in pai nu ziam? Puanneam hoi nano sil mu nuam nu ziam? en vun, puanneam nano sil te kumpi innsung ah a omte a hihi. ");
INSERT INTO csy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bang en tu in pai nu ziam? Kamsang ziam? hi hi, kamsang bek domngawl hi, kong ci hi. ");
INSERT INTO csy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Banghangziam cile, en in, na mai ah na lampi puakhol tu in ka thupuak sawl khi hi, ci a ki atkholsa thu sia, John thu a hihi. ");
INSERT INTO csy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A tatak ka ci ciang, numei sung pan a piang teng sungpan tuiphumpa John sang in a lianzaw kuama om ngawl hi: ahihang vantung kumpingam sungah a nobel sia nangawn John sang in lianzaw lai hi. ");
INSERT INTO csy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tuiphumpa John hunlai pan in tuni dong vantung kumpingam sia zawthawkthu taw ki suttol in, a ngoltol te in sut in la hi. ");
INSERT INTO csy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Banghangziam cile, kamsang theampo le Moses thukham te in John hundong maisang thu sonkhol zo uh hi. ");
INSERT INTO csy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hi thu te na sangthei uh le, Elijah hongpai tu hi, a ci sia a ma John hi zo hi. ");
INSERT INTO csy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Zak natu bil nei theampo in za tahen. ");
INSERT INTO csy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Tu hun mihing te sia bang taw sonte tu khi ziam? Amate sia sumbuk te ah to in, a lawmte a biakpui patang te taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Tamngai kong tum uh hang lam nuam ngawl nu hi; katap kong law uh hang zong kap tuan ngawl nu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Banghangziam cile John sia ne ngawl dawn ngawl in hongpai ciang, amate in doai vei hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mihing Tapa sia ne le dawn in hongpai ciang, amate in, en vun, an tuang pa, sapittui tuang pa, siadong te le mawnei te i lawmpa, ci uh hi. Ahihang ciimna in a tate mawsiatna pan suatak hi. ci hi. ");
INSERT INTO csy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jesus in nalamdang a tamzaw a vawtna khuapi te a ki sikkik nop ngawl hang in mawsiat a: ");
INSERT INTO csy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Chorazin awng! na mailam bing hi! Bethsaida awng! na mailam bing hi! banghangziam cile na sungah a ki vawt nalamdang te, Tyre le Sidon khua sungah ki vawt hile, khau-ip le vut taw a ki sikkik uh ngei zo tu hi. ");
INSERT INTO csy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ahizong kei kong ci na pan, thukhenna ni ciang Tyre le Sidon te nang sang in thuak nop zawlai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Nang Capernaum awng! van dong in lapsang hi napi, hell sung dong khiaksuk na hi tu hi: banghangziam cile na sungah a ki vawt nalamdang te Sodom ah ki vawt hile, tuni dong taang lai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ahihang, kei kong ci na pan, thukhenna ni ciang nang sang in Sodom leitang i thuakna sia thuaknop zawlai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tua hun laitakin Jesus in, Simlei le vantung i Pa, Ka Topa awng, mipil mithiam te kung pan in na sealcip thu te, hi patangno te tungah pualak na hi man in ka lungdam hi. ");
INSERT INTO csy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hi tahen, Pa awng: hibang teng a piang tu na dei na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ka Pa in na theampo hong pia zo hi: Pa simngawl kuama in Tapa a he bua uh hi; Tapa le Tapa in a telsak nop te simngawl kuama in Pa a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Van ngit pua in a toite theampo, ka kungah hongpai tavun, tawlngakna kong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ka hakkol la in ki suan vun; keima tung pan ki sin vun; banghangziam cile keima in cingh in thinsung ki niamkhiakna nei ka hi kom: na thaa atu in tawlngakna na mu tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Banghangziam cile, ka hakkol puak nop a, ka van a zaang hi., ");
INSERT INTO csy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tua hun laitak, Jesus sia sabbath ni khat losung kantan in pai a; a nungzui te a ngilkial ahikom, zungtang hui te hiat in ne uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ahihang Pharisee te in a mu uh ciang, Jesus kungah, en in, na nungzui te in sabbath ni sep tu a kilawm ngawl te seam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ahihang Jesus in amate tung ah, David le a lawm te a ngilkial uh ciang in, bang vawt ci sim ngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David sia Pathian innsung ah tum in, amate neak tu a kilawm ngawl, thiampi te bek i a neak thei tu in Pathian mai ah a ki lui anluum te ne uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Biakinn sungah thiampi te zong sabbath ni sim in, sabbath thukham paltan napi, mawsiatna thuak ngawl hi, ci in thukhambu sungah sim ngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A tatak in kong ci ciang, biakinn sang in a lianzaw khat om hi. ");
INSERT INTO csy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Biakpiakna sang in hesuakna ka dei zaw hi, a ci sia i a khiakna he le uh te, maw nei ngawl khat mawsiat ngawl tu nu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Banghangziam cile mihing Tapa sia sabbath i Topa a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tua mun pan Jesus a pai zawkciang, amate synagogue sungah tum uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","En vun, a khut zaw khat om hi. Amate in, sabbath ni in cina damsak sia ngeina om ziam? ci a maw natu zong nuam in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus in, Note sungah mi khat in tuu khat nei hi, tua tuu sia sabbath ni in dumsung ah tak bang hile, pusua ngawl in om tu ziam? ");
INSERT INTO csy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mihing sia tuu sang in bangza phazaw ziam? Tua ahikom sabbath ni ah na pha sep tu kilawm hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tuapa kungah, Na khut zan in, ci hi. A khut a zan ciang in, a khut langkhat bangma in dam hi. ");
INSERT INTO csy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tuazawkciang Pharisee te pusuak uh a, ama sia bangbang in susia thei tu, ci thu vaihawm uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesus in tua thu a heak ciang mundang ah pai a: mihon tampi in zui uh hi, amate natna theampo damsak hi; ");
INSERT INTO csy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ama thu ngualdang tung a son ngawl natu in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Tua thu in kamsang Isaiah sonkholna, ");
INSERT INTO csy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","En vun, ka tealsa ka naseampa; keima i ka it pa, ama sungah ka thaa a lungkim mama hi: ama tungah ka thaa ka koi tu a, ama in Gentile te tungah thukhenna lak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ama sia kuama nial ngawl tu a, au zong au ngawl tu hi; lampi ah kuama in a aw za ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ama in zawna nga a, a ki kuaikhumsa pumpa a thiaktan batu hi, a khu va buai mei-inn zong mit ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Gentile te in ama min um in muang tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tuazawkciang doai vei hu in a thin-am, a mittaw in, a pau thei ngawl khat Jesus kungah hong paipui uh hi: Ama in tua mittaw le a pau thei ngawl pa sia, a damsakkik man in pau thei in khuamu kik hi. ");
INSERT INTO csy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Mi theampo in lamdangsa mama uh a, Ama sia David i tapa hi ngawl ziam, ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ahihang Pharisee te in hi thu a zak uh ciang, hi sia pa in doai te hawlkhia hi ngawl in, doai te i topa Beelzebub vang taw in hawlkhia hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus in amate ngaisutna he a, Ngam khat sia ki khen in a ki do le, siatna sung theng tu hi; khuapi le inn te zong ki khen in a ki do uh le, kip ngawl tu hi: ");
INSERT INTO csy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan in satan hawlkhia in, ama le ama ki khen in a ki do le; bangbang in a ngam kip thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Keima in Beelzebub vang taw doai te ka hawlkhia a hile, na tate uh in a kua vang taw hawlkhia ziam? Tua ahikom amate sia note i thukhen te ahi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Keima in Pathian Thaa vangletna taw in doai te ka hawlkhia a hile, Pathian kumpingam sia no kungah hong theng hi. ");
INSERT INTO csy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kua in mihing thahatpa hencip masa ngawl in a inn sungah tum in a van sut thei tu ziam? Mi thahat pa a lehhen zawkciang bek in a innsung om van te sut thei tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Keima taw hong om ngawl peuma ka ngal hi a; keima taw a kaikhawm ngawl peuma a thezau a hihi. ");
INSERT INTO csy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Tua ahikom mihing te mawna tatuam le sonsiatna tatuam te ki maisak tu hi: ahihang Tha Thiangtho a sonsia peuma ki maisak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Akua mapo in mihing Tapa sia kammal taw a do peuma, ki maisak tu hi: ahihang khatpo in Tha Thiangtho kammal taw a do peuma sia, tu hun le hongpai pheang tu hun sungah zong ki maisak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Thingkung pha in a pha nga a; thingkung phangawl in nga phangawl nga hi: banghangziam cile, thingkung sia a nga pan in ki he thei hi. ");
INSERT INTO csy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Maw, no ngul ngilo suan te, note sia mihing ngilo te hi napi, bangbang in kampha pau thei tu nu ziam? banghangziam cile na thinsung uh pan a let sia na muk uh pan pau nu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mipha te thinsung na manpha te pan in napha te ma pusuak hi: taciang miphangawl te i na manphangawl pan in naphangawl ma pusuak hi. ");
INSERT INTO csy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ahihang, kei kong ci na ah, a kuamapo phattuamna om ngawl a pau kammal te pan thukhenna thuak kik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Nangma kampau te hang in na suakta tu a, nangma kampauna ma taw in mawsiatna thuak tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Thukham hil te le Pharisee te pawlkhat in, syapa awng, musakna lim khat hong lak tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus in, Mihing phangawl le thuman ngawl te awng; kamsangpa Jonah musakna lim simngawl a dang om ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Banghangziam cile, Jonah sia whale ngasa ngilsung ah ni thum le zanthum sung a om bangma in; mihing Tapa zong lei sungah ni thum le zan thum sung om tu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Thukhenna ni ciang in Nineveh khuami te sia hi minam te taw hong ding tu a, mawsiat tu uh hi: banghangziam cile amate in Jonah thuhilna a zak uh ciang in kisikkik tek uh hi; en vun, Jonah sang in a lianzaw ziaksung ah om hi. ");
INSERT INTO csy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Thukhenna ni ciang in, thangsang ngam kumpinu hong ding tu a, hong mawsiat tu hi: banghangziam cile kumpi Solomon ciimna za nuam in leitung mongkhat pekpan in hongpai hi; en vun, Solomon sang in a lianzaw ziaksung ah om hi. ");
INSERT INTO csy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Thaniin sia mihing khat sung pan a pusua zawk ciang, mun ko ngaw sung teng ah tawlngak natu zong in vak kakawai napi, mu ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ka pusua na mun inn sungah heakkik tong, ci hi; a thet ciang in tua inn sia a hawm, a ki phiat sa le a ki pua sa in mu hi. ");
INSERT INTO csy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Tasiaciang, pai in ama sang a sukzaw thaniin sali te kaizawn in, tua inn sungah tum in om khawm uh hi: tuapa i omdan sia amasa sang in suk zawkan hi. Hibang tatsia minam te tasia bangma hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus mihon pite thu a hil laitak in, A nu le a suapuipa te hong theng a, a puasang ah ama paupui nuam in ding uh hi. ");
INSERT INTO csy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Taciang mi khat in, en in, na nu le na suapui te nangma paupui nuam in puasang ah ding hi, ci in son hi. ");
INSERT INTO csy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesus in, Ka nu akua ziam? a kua ziam ka suapui te? ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Taciang, a nungzui te kawk in, En in, ka nu le ka suapui te! ");
INSERT INTO csy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Akua mapo vantung a om Ka Pa i deina bang a seam peuma, ka suapui pa, ka suapui nu te a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tua ni ma in Jesus inn pan pusuak in, tuili hui ah to hi. ");
INSERT INTO csy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mihon pi te ama kungah hong ki kaikhop ngawp ciang in, ngunkuang sungah tuaksuk in, to hi; taciang in mihonpi theampo sia tuili hui ah ding tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Taciang in sontena te zang in thu tampi son a; En vun, thaici poai pa thaici poai tu in hongpai hi; ");
INSERT INTO csy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A poai ciang in, thaici pawlkhat te sia lamzin tungah tak a, tungleang te hongpai in nekhawng siat hi: ");
INSERT INTO csy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Pawlkhat te sia suang tam in, leidai na mun ah tak hi: tawmvei sung in hong po pai hi, banghangziam cile lei thuk ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tabang in ni hong sua ciang, nisa in kang a; zungthuk nei ngawl ahikom in vuai in ngawtak siat hi. ");
INSERT INTO csy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pawlkhat te sia lingphung sungah tak a; lingkung te khang in zapcip siat hi: ");
INSERT INTO csy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","A dang te sia leipha na sungah tak a, pawlkhat te a se zakhat, pawlkhat te a se sawmluk, pawlkhat te a se sawm thum in khang hi. ");
INSERT INTO csy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Zak natu bil nei peuma in, za tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Taciang in nungzui te Jesus kungah hongpai a, banghang in sontena taw thuson ni ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesus in, Banghangziam cile, vantung kumpingam thuku heak thei na sia note hong kipia zo hikale, mipi te ki pia ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Banghangziam cile, a neite ki pia thua tu a, a dimlet in nei tu hi: ahihang a nei ngawl te kung pan in a neisun zong ki laksak lai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tua ahikom amate tungah sontena te taw thuson khi hi: banghangziam cile amate sia en napi mu ngawl; ngai napi za ngawl in tel zong tel thei ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kamsang Isaiah in maisangthu a sonkholna ah, note sia za napi na tel bua uh hi; mu tu hi napi, kan tel ngawl nu hi, a ci thu amate tungah tangtung hi. ");
INSERT INTO csy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Banghangziam cile, hi minam te sia a mit te khua mu ngawl, a bil te khuaza ngawl, a thinsung in bangma tel thei ngawl in, a nuntak na uh zong ki kheal ngawl hang in, a natna te zong ka damsak ngawl zadong in, amate sia a thinpui lei a, a bil uh in khua za hak bek domngawl in a mit uh zong thi siat hi. ");
INSERT INTO csy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ahizong, note sia na mit in mu a: na bil zong in za ahikom in thuphatoai na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A tatak ka ci ciang, na mu uh le na zak uh te kamsang te le mi thutang te in mu nuam mama napi, mu tha ngawl hi; za nuam mama napi, za tha ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tuahang in thaici poaipa thu sontena sia ngai vun. ");
INSERT INTO csy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Lamzin tungah atak thaici i khiakna sia, khatpo in kumpingam thu za a, tel thei ngawl hi, taciang mi phangawl pa hongpai in, a thinsung ah a ki poai thaici sia laksak hi. ");
INSERT INTO csy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Suangtam na mun ah a tak thaici sia, thu a zak pociang lungdamtak in a sang te hi; ");
INSERT INTO csy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ahihang zungthuk tha ngawl ahikom, tawmvei sung bek khom in: tua thu hang in haksatna le vawtsiatna a thet ciang, tawlnga kik pai hi. ");
INSERT INTO csy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Lingphung sung a tak thaici te sia, thu za napi; hileitung thinngimna, leitung hauna i theamna in tua thu zapcip a, nga zo ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Leipha na ah a tak thaici te sia, thu za a, a telthiam te hi; tua te in a nga hong nga a, pawlkhat te a se zakhat, pawlkhat te a se sawmluk, pawlkhat te a se sawmthum ciang dong khang hi. ");
INSERT INTO csy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus in amate tungah sontena adang khat son thua a, Vantung kumpingam sia pasal khat in a lo sungah thaici pha a cing taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Hi kale, ngual mut lan in, a ngal pa hongpai a, zungtang sungah mimphei ci a poai zawkciang, ciakik hi. ");
INSERT INTO csy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Thaici hong po in, tanghui te hong luak ciang in, mimphei te hong kilang hi. ");
INSERT INTO csy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tabang ahiciang, naseam te innteakpa kungah hongpai a, Topa awng, na losung ah thaici pha poai hi ngawl ni ziam? koisung pan hi mimphei te hong theng ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Innteakpa in hite sia ka ngalpa i vawt a hihi, ci hi. A naseam te in ama kungah, pai in mimphei te ka bot tu uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ahihang inteakpa in, bot heak vun; banghangziam cile mimphei te na baw uh ciang, zungtang te taw bot khawm tha tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Anlak hun dong khang khawm phot tahen, anlak hun ciang in mimphei te khawm masa vun a, na lom hen zawk uh ciang hal vun: ahihang zungtang te a hile seau sungah thun vun, ci in anla te ka ci tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus in sontena dang khat ma a son thua na ah, Vantung kumpingam sia pasal khat in ankam cii la in, lo sungah a poai taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tua thaici sia thaici theampo sung pan a nobel hi: ahihang hong khan ciang in ante teng sung pan a lianbel hong suak a, a kung hong suak hi, tua hu in van a vacim te zong hongpai in a bak te tungah tawlnga hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus in amate tungah sontena dang khat a son thu sia; Vantung kumpingam sia nupi khat in tol tawm a lak sia, anvui law thum sungah hel a, tua tol tawm cilik in anvui theampo a pawmsak siat taw kibang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesus in hi sontena te zang in mipite tungah thuson hi: sontena zang ngawl in thuson ngeingawl hi: ");
INSERT INTO csy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kamsang i sonkholna ah, amate tungah sontena te zang in thuson tu khi hi; leitung bulpi a ki phu panin thuku sia amate tungah pualak tu khi hi, ci thu a tangtun natu hi. ");
INSERT INTO csy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tuazawkciang Jesus in mihonpi te ciasak a, innsung ah a tum uh ciang: a nungzui te a kungah hongpai in, losung a mimphei thu sontena sia hong son tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesus in, Thaici pha a poai sia mihing Tapa hi; ");
INSERT INTO csy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Lo sia leitung bup hi; thaici pha sia kumpingam tate a hihi; ahihang mimphei te sia mi phangawl pa tate a hihi; ");
INSERT INTO csy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mimphei cii a poai ngalpa sia doaimangpa hi; anlak hun sia leitung bo hun hi a; anla te sia vantungmi te a hihi. ");
INSERT INTO csy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tua ahikom mimphei te sia khawm in, mei taw hal siat hi; tasiabangma in hileitung a bo ciang in piang tu hi. ");
INSERT INTO csy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mihing Tapa in, Ama vantungmi te sawl tu a, mi a khialsak te le siatna a vawt te ama ukna sung pan kaikhawm tu hi; ");
INSERT INTO csy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tua te sia kaa na le hangoaina mun mei sungah khiasuk tuh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Taciang in mipha te sia a Pa uh i ukna sungah ni bang in tang tu uh hi. Zak natu bil nei theampo in za tahen. ");
INSERT INTO csy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Vantung kumpingam thu sia, losung ah a ki sealcip na manpha taw kibang hi; tua neisa sia khatpo in a mu ciang in, phual a, lungdam mama in a neisa theampo zuak hi, taciang tua lo lei hi. ");
INSERT INTO csy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Vantung kumpingam sia a manham pale a zong sumleang pa taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ama in a manham pale khat a mu ciang in, a neisa theampo zuak in, lei hi. ");
INSERT INTO csy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Vantung kumpingam thu sia tuipi sungah a ki pai, ngasa tatuam a awk ngen taw kibang hi: ");
INSERT INTO csy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A ngen a dim ciang in tuihui ah kai a, a to kawm in teal hi, ngasa pha te bawm sungah heang a, a phangawl te sia vawk hi. ");
INSERT INTO csy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hi leitung bo ciang in tabangma hi tu hi: vantungmi te hongpai in, mipha te sung pan in mi phangawl te khen tu a, ");
INSERT INTO csy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kaana le hangoaina mun meisung ah khia tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus in, Hi thu te theampo na tel zo uh ziam? ci in dong hi, amate in tel khu hi, Topa, ci in zo kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jesus in amate tung ah, Tua ahikom, vantung kumpingam atu in a ki hil thukhamhil te sia, a neisa a lui le a thak a vekpi in a pusua inn neipa taw kibang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus in hi sontena te a son zawkciang tua mun pan in pusuak hi. ");
INSERT INTO csy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ama ngamsung a tum ciang in, amate i synagogue sungah thuhil a, amate in lamdangsa mama in, hibang ciimna le vangletna nei nasep te sia koisung pan nga ziam? ");
INSERT INTO csy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ama sia lettama pa tapa hi ngawl ziam? Mary sia a nu hi ngawl ziam? James, Joses, Simon le Judah te zong a suapui te hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A suapui nu te zong i kung ma ah hong om hi ngawl ziam? koisung pan hisia pa in hite theampo nga ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Amate sia Jesus hang in tha neam uh hi. Ahihang Jesus in amate tung ah, Kamsang sia ama ngamsung le a innkuan sung simngawl mundang ah ki upat hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amate i up ngawlna hang in, tua mun ah vanglian nasep tam seam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tua hun laitak in Herod in Jesus thu za a, ");
INSERT INTO csy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A naseam te kungah, hisia pa sia tuiphumpa John hi; ama sia thina pan thokik hi; tua ahikom hibang vanglian nasep te lak thei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Banghangziam cile Herod in John sia a naupa zi Herodias hang in man a, lehhen in thong sungah khia hi. ");
INSERT INTO csy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","John in, hi sia nu na tenpui ngeina om ngawl hi, a ci hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herod in ama sia that nuam hi napi, mihonpi te lau hi, banghangziam cile ama sia kamsang khat bang in a ngaisut uh a hihi. ");
INSERT INTO csy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herod suani in Herodias tanu sia amate mai ah lam a, Herod a lungkimsak hi. ");
INSERT INTO csy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tua hang in, Herod in a nget po pia tu in tua nu kamciam pia hi. ");
INSERT INTO csy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","A nu in ngaisutna a piak bang in, kuangdal sungah tuiphumpa John i lu hong pia tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tasiaciang kumpipa sia khuangai mama hi: ahihang a kamciam le anneak na mun ah a topui te mai a et na in, tua tanu i a nget bang piak tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Taciang, ama in thonginn sungah John ngawng tan tu in sawl hi. ");
INSERT INTO csy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A lutang sia kuangdal taw hong paipui a, tanu nu pia hi: ama in a nu kungah paipui hi. ");
INSERT INTO csy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","John nungzui te hongpai uh a, a luang pua in phum uh hi; tuazawkciang amate pai in Jesus kungah son hi. ");
INSERT INTO csy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus in tua thu a zak ciang in, pusuak a ngunkuang to in senneal omna sangah pai hi: midang te in a zak ciang in, khuapi te sung pan in pusuak a, peang taw pai in a nung pan zui tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesus in mihon tampi te a mu ciang in, amate hesuak huai sa a, cina te damsak hi. ");
INSERT INTO csy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nitak sang ciang in, a nungzui te a kungah hongpai in, hi mun sia senneal ngam hi, khua niam zo ahikom; mihonpi te paisak in a, khuapi te ah pai in amate neak tu an lei tahen, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ahihang Jesus in, Amate paisak kul ngawl hi, a neak tu note in pia vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tasiaciang amate in, ziak ah anluum nga le ngasa ni bek nei khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus in, Hong paipui tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mihonpi te sia lopa tungah to tu in thupia hi, taciang anluum nga le ngasa ni la in, vandak to in thupha a piak zawkciang, bal in, a nungzui te pia hi, a nungzui te in mihonpi te pia hi. ");
INSERT INTO csy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A vekpi khamteak in a neakzawk uh ciang: a neakval a neng a tawng te tawm a, bawm sawm le bawm ni dim hi. ");
INSERT INTO csy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A ne te sia numei le patang simngawl, pasal cingteng tul nga kiim pha uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tuazawk pociang, Jesus in mihonpi te a ciasak laitak in, a nungzui te sia a mai ngalkhat ah pai khol tu in ngunkuang sung tosak hamtang hi. ");
INSERT INTO csy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mihonpi te a ciasak zawkciang, thungen tu in mualtung ah ka to a: nitak hun ciang in tua mun ah ama nguak om hi. ");
INSERT INTO csy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tua hun laitak in ngunkuang tui lai ah om a, hui hongpai taw ki situa ahikom tuihual in ngunkuang lok zazan hi. ");
INSERT INTO csy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Zingsang nai thum le nai luk kilaklaw ciang, Jesus sia tuitung, a nungzui te kung hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","A nungzui te in tuitung ah lampai a mu ciang in patau uh a, hi sia thitha hi, ci in lau in aukeak uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ahihang tasia pociang Jesus in amate paupui a, Na thin uh nuamsak vun, keima khi hi; lau heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter in, Topa awng, nangma na hile, tuitung na kungah hongpaisak tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus in, Hongpai tan, ci hi. Tasiaciang Peter sia ngunkuang sung pan tuak in Jesus kungah pai tu in tuitung ah pai hi. ");
INSERT INTO csy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ahihang vui va ngawp a mu ciang lau hi; tui sung tumsuk tu a kithoai ciang, Topa hong hun tan, ci in au hi. ");
INSERT INTO csy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Thakhat in Jesus in a khut zan in zam pai a, Maw nang upna no pa, banghang in muangla ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Amate ngunkuang sungah a thetkik uh ciang hui zong thim hi. ");
INSERT INTO csy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tasiaciang in ngunkuang sung a omte hongpai in bia a, nangma in Pathian Tapa tatak na hihi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Amate ngalkhat a thet uh ciang Gennersaret ngam sungah hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tua mun ah mihing te in Jesus thu a heak uh ciang, a kim a pam ngam theampo ah sawl in, cina theampo a kungah puak uh hi; ");
INSERT INTO csy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Amate in a puanmong thamtha tu in ngen uh a: a thamtha peuma dam siat hi. ");
INSERT INTO csy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tuazawkciang Jerusalem pan in, Pharisee te le thukhamhil te Jesus kungah hongpai uh a, ");
INSERT INTO csy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Banghangin na nungzui te in ka pu le pa ngeina te paltan ziam? Banghangziam cile amate in an a neak tu uh ciang a khut uh sil ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ahihang Jesus in, Banghang in Pathian thupiak te sia na pu le pa ngeina taw paltan nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Banghangziam cile, Pathian in thupia a, na nu le na pa zakta in: a nu le a pa a taisan peuma ki that tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ahihang note in, khatpo in a nu a hibale a pa a piak tu khatpo sia, Pathian atu a kipia sa hi, ci a hi po le, ");
INSERT INTO csy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","A nu a hibale a pa sia upat kul nawn ngawl, peng thei hi, ci nu hi. Tabang in note in na pu le pa ngeina zang in Pathian thupiak sia mannei ngawl sua nu hi. ");
INSERT INTO csy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","No a ki hitheamsak te, kamsang Isaiah in noma thu a mantak in a sonkhol na ah, ");
INSERT INTO csy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Hi mite in a kam bek uh taw kei hong neak a, a muk bek taw kei hong upat uh hi; ahihang a thinsung uh sia kei taw ki khuala hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ahihang mihing te thupiakna bang in pomdan te hil a, keima hong biak sia luithathong bek hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Taciang Jesus in mihonpi te sam a, Ngai vun a, he tavun. ");
INSERT INTO csy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kamsung pan a tum te in mihing ninsak ngawl a, kam sung pan a a pusuak te in mihing ninsak zaw hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tasiaciang a nungzui te a kungah hongpai a, na thuson te in Pharisee te thin-uksak hi, ci na he ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus in, Vantung a om Ka Pa i suan ngawl peuma ki bot siat tu hi. ");
INSERT INTO csy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Koi lel vun: amate sia mittaw te lamlak mittaw te hi. Mittaw in mittaw lamlak le a ni in luamsung ah tak tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter in tua thu sontena hong son thiang tan, ci ngen hi. ");
INSERT INTO csy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus in, Note zong tu dong telthiam ngawl lai nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kamsung a tumsuk te theampo sia ngilpi sungah theng a, taciang dumsung ah vawk hi, ci tu dong tel thei ngawl lai nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ahihang kamsung pan a pusuakte sia thinsung pan pusuak ahikom; tua te in mihing sia ninsak hi. ");
INSERT INTO csy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Banghangziam cile, ngaisutna phangawl, tual that, palngul mawna, paktat na, nguta, a man ngawl tetti, sonsiatna te theampo sia thinsung pan in a pusuak a hihi: ");
INSERT INTO csy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hite in mihing ninsak hi: hi kale khut sil ngawl anneakna in mihing ninsak ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus tua mun pan pai a, Tyre le Sidon khua kiim teng ah pai hi. ");
INSERT INTO csy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tua khua kiim ah a teang Canaan numei khat a kungah hongpai a, Maw Topa, nang David Tapa awng, hong hesuak ka po in, ka tanu sia doai in nasiatak in vawtsia hi, ci in au hi. ");
INSERT INTO csy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ahihang Jesus in kamkhat zong zo kik ngawl hi. A nungzui te hongpai in, hi numei sia not in, banghangziam cile i nung pan in au top hi, ci ngen hi. ");
INSERT INTO csy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ahihang Jesus in, Israel minam sung pan tuu pai te kung simngawl hong ki sawl ngawl hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tasiaciang tua nu hongpai in, Jesus bia a, Topa awng, hong hu tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus in ama zo kik a, Tate i anneak laksak in ui piak tu sia ngeina om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Numei nu in, man hi, Topa awng: hima kale, to te i sabuai pan anneng tak te buang ui in ne hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tasiazawkciang Jesus in zo kik a, Maw numei nu, na upna lian mama hi: na deina bang in hi tahen, ci hi. Tua hun lian in a tanu damthiang hi. ");
INSERT INTO csy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesus tua mun nusia in, Galilee tuili hui ah pai in; mualtung ah kato hi. ");
INSERT INTO csy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Mihon tampi te a kungah hongpai a, amate taw peangbai, mittaw, pau thei ngawl, pumpi cing ngawl le a dang tampi te hong paipui a, Jesus peang ah koi tek uh hi; Jesus in amate damsak hi: ");
INSERT INTO csy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A pau thei ngawl te pau thei, pumpi kim ngawl te dam, peangbai te lampai, mittaw te in khuamu ci mihonpi in a mu uh ciang in lamdangsa tek mama a: Israel te Pathian pok uh hi. ");
INSERT INTO csy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus in a nungzui te sam a, Hi mihonpi te tungah hesuakna nei khi hi, banghangziam cile ka kungah nithum sung a kipe in om zo uh a, neak tu bangma nei ngawl hi: amate lamkal ah puk-hong in a tha bo tu ahiciang, an ngawl in ciasak ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nungzui te in, mihon tampi te a kham in vak natu an tampi hi duisung ah koisung pan om tu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus in, Anluum bangza nei nu ziam? ci in dong hi. Amate in anluum sali le ngasa nosi tawm, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tasiaciang Jesus in mihonpi te lei ah to tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Anluum sali le ngasa tawm teng la in, lungdam a ko zawkciang khen in a nungzui te kungah pia hi, a nungzui te in mihonpi te pia hi. ");
INSERT INTO csy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","A vekpi a khamteak in ne tek uh hi: tuazawkciang a bal nen sa a val teng a top uh ciang bawm sali dim hi. ");
INSERT INTO csy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","A nete sia numei le patang ki simngawl pasal tul li pha hi. ");
INSERT INTO csy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus in mihonpi te ciasak a, ama sia ngunkuang sungah to in Magdala khua kiim ah theng hi. ");
INSERT INTO csy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pharisee te Sadducee te pawlkhat taw Jesus kungah hongpai uh a, maw a zon nop uh man in tungsang musakna laksak hi. ");
INSERT INTO csy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesus in amate tung ah, Nitak sang in van hong san le, khuapha tu hi. ");
INSERT INTO csy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Taciang zingsang ciang in, van hong san in khua hong niim le khuasia tu hi, ci nu hi. Maw no a ki hitheamsak te, van en in khuahun omdan tu telthei napi, hun le ni i musakna te telthei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Mi ngilo le tatsia tate in musakna zong napi; kamsang Jonah musakna simngawl a dang ki pia ngawl tu hi, ci in zo kik hi. Tuazawkciang amate nusia in paisan hi. ");
INSERT INTO csy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nungzuite ngalkhat ah hong thet uh ciang, anluum ken tu mangil uh hi. ");
INSERT INTO csy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Taciang in Jesus in, Pharisee te le Sadducee te i tol pan in kidawm tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Amate in anluum i ken ngawl hang hi, ci in amate kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tua thu Jesus in a heak ciang in, Maw no upna no te, anluum na ken ngawl uh hang hi, ci in banghang in kikum nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anlum nga sia mihing tul nga in a neak zawkciang a val bawm bangza tawm nu ziam, ci he ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Anlum sali mihing tul li in a neakzawkciang, a val bawm bangza tawm kik, ci sia phawk nawn ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pharisee le Saducee te tol kidawm vun kong ci ciang, anluum thu ka son nop na hi ngawl hi, ci banghang in tel thei ngawl nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Tasiaciang a nungzui te in, anluum sung a tol kidawm tu a cinopna hi ngawl a, Pharisee le Saducee te hilna hi zaw, ci sia tel kik hi. ");
INSERT INTO csy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesus in Ceasaria Philippi khua kiim a thet uh ciang, a nungzui te kungah, Ngual in mihing Tapa sia kua hong ci uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Amate in, pawlkhat te in tuiphumpa John: pawlkhat te in Elijah; pawlkhat te in Jeremiah, a hibale kamsang khat papo, hong ci hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesus in, No ma na e, keima sia kua hi nong ci uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Peter in zo a, Nangma sia a nungta Pathian Tapa, Christ na hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tasiaciang Jesus in, Jonah tapa Simon awng, thuphatoai na hihi: banghangziam cile, hi thu sia mihing cile sa le thisan in hong hesak thei ngawl hi, vantung a om Ka Pa in hong hesak hi. ");
INSERT INTO csy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Keima in kong son hi, nang sia Peter ni hi, hi suangpi tungah ka pawlpi ka phut tu hi; taciang hell ngam kongpi te in a zo zo batu hi. ");
INSERT INTO csy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Vantung kumpingam tawtang te kong pia tu hi: leitung ah na hen theampo vantung ah zong ki hen tu hi: leitung ah na tha theampo vantung ah zong ki tha tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ama sia Christ kici Jesus a hina sia kuama a son ngawl natu in nungzui te vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tua hun panin, Jesus in a nungzui te tung ah, Jerusalem a pai natu thu, ulian te, thiampi lian te le thukhamhil te hang in a thuak tu tampi te le ki that tu a, ni thum ni ciang a thawkik natu thu te son kipan hi. ");
INSERT INTO csy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tasiaciang Peter in Jesus sia samtuam in tei hi, Topa awng, hi thu sia nangma taw ki khuala tahen a: na tungah hong theng heak tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ahihang Jesus in le-et in, Peter kungah, Satan, nang ka nung ah om in, kei hong khak in hongliksak na hihi: banghangziam cile Pathian thu sang in, mihing te thu kinzaw ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tuazawkciang Jesus in a nungzui te kungah, A kuamapo ka nung hong zui nuam peuma, ama le ama ki nial hen a, ama thinglamte pua in, hong zui tahen. ");
INSERT INTO csy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Banghangziam cile, kuamapo in, ama nuntakna a hun nuam sia sum tu a: keima atu in a nuntakna a sum peuma nuntakna mu tu hi. ");
INSERT INTO csy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mihing khat in leitung theampo a nga zong in, a tha nuntakna a sum le bang phattuamna om ziam? mihing in a tha nuntakna bang taw theak thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mihing Tapa sia a Pa vangletna le Ama vantungmi te taw hongpai tu a; khatsim i a sep bang tek in thaman pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A tatak kong ci ciang, hi lai ah a om pawlkhat te, mihing Tapa Ama kumpingam sungah hongpaikik na mu uh dong thina a tep ngawl tu te omhi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ni luk zawkciang Jesus in Peter, James le a suapuipa John te mual tungah kapui to hi. ");
INSERT INTO csy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Amate mu tangin Jesus a meal kikheal hi: a maitang ni bang in tang a, a puansil zong khuavak bang in ngo hi. ");
INSERT INTO csy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Taciang en vun, Moses le Elijah te hong kilang a Jesus taw thu kikum khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter in Jesus kungah, Topa, hi mun sia ko atu in pha hi: na lung a kim le buk thum, nang atu khat, Moses atu khat, Elijah atu khat sa tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tabang a pau laitak in, a tang meingo in lia a: ngai vun meingo sung pan in aw khat in, Hi sia ka it ka Tapa a hihi, ama tungah ka lungkim hi, a thu ni vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nungzui te in tua aw a zak uh ciang in, lau mama ahikom lei ah bokcip uh hi. ");
INSERT INTO csy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus hongpai in amate phong a, Tho vun, lau heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tasiaciang dakto in en uh a, Jesus simngawl adang kuama a mu bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mualtung pan a tuaksuk kawm in Jesus in, Hi na mu uh thu sia mihing Tapa thina pan a thawkik mateng kuama son heak vun, ci in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A nungzui te in Jesus kungah, banghang in thukhamhil te in Elilah hongpai masa tu hi ci ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesus in, Elijah hongpai masa takpi tu a, na theampo sia ama in puapha siat tu hi. ");
INSERT INTO csy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ahihang kei kong ci na ah, Elijah hong theng zo a amate in tel ngawl hi, tua hang in amate a uk bang in vawt hi. Tasia bangma in mihing Tapa zong thuak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tasiaciang in ama in tuiphumpa John thu son hi, ci in a nungzui te in tel uh hi. ");
INSERT INTO csy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Amate mihonpite kungah a paikik uh ciang in, pasal khat Jesus kungah pai a, a mai ah khupdin in, ");
INSERT INTO csy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Topa awng, ka tapa hesuak po in: butthi nei a a nat tun ciang, mei sung le tuisung ah puk in tak tawntung a, nasiatak in vawtsiatna thuak hi. ");
INSERT INTO csy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na nungzui te kungah ka paipui uh hang in, amate in damsak thei ngawl uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesus in zo kik a, Maw upna nei ngawl le lamkhial te, banghun dong no taw hong om tu khi ziam? banghun dong hong maisak lai tu khi ziam? patangno sia ka kungah hong puak tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesus in doai tungah thupia a; tua patang sung pan in tai hi: Tua hun lian in patangno dam hi. ");
INSERT INTO csy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nungzuite sia atuam in Jesus kungah hongpai a, banghang in hawlkhia zo ngawl khu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesus in, Na up ngawl uh hang hi: a tatak in kong ci ciang, ankam ci cia upna nei le uh te, mual hisia hi mun pan in zesung mun ah ki khin in: ci le uh te kikhin tu hi; no atu a piangthei ngawl bangma om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ahizong, thungetna le antan na simngawl hibang te pusuak thei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilee ah a omtek uh laitak in, Jesus in amate tung ah, Mihing Tapa sia ngualdang khutsung ah ap tu hi: ");
INSERT INTO csy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Amate in that tu uh a, ni thum ni ciang in thokik tu hi, ci hi. Taciang amate nasiatak in khuangai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Amate Capernaum khua a thet uh ciang in, siadong te Peter kungah hongpai a, na syapa in, shia a pia ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Peter in, pia hi, ci hi. Innsung ah a tum uh ciang in, Jesus in dok phit in nei a, Simon awng, bangbang ngaisun ni ziam? Hi leitung kumpite in a kuate tung pan sum vawt shia, a hibale inn le lo shia la ziam? amate tate tung pan maw, ngamdang mite tung pan ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Peter in, ngamdang mite, ci in zo hi. Jesus in Peter kungah, Tabang a hile atate shia piak tu pan in peng hi. ");
INSERT INTO csy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ahihang, ei hang in ngual a puk ngawl natu in, tuili ah na pai tan a, ngasa tangthak tan, a awk masabel sia la in a, a kam keau in, dangka khat mutu ni hi: tasia la in a, nangma le keima atu in shia pia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tua hun laitak in a nungzui te Jesus kungah hongpai a, vantung kumpingam sungah a kua lianbel tu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesus in patangno khat a kungah sam in, amate laizang ah koi a, ");
INSERT INTO csy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A tatak in kong ci ciang, kikheal in patangno te bang na hi bua uh le, vantung ngam sungah na tum thei batu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tua ahikom a kuamapo hi patangno bang in ama le ama a ki niamkhiak te, vantung kumpingam sungah a lianbel hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","A kuamapo keima min taw tabang patangno khat a sang sia in keima hong sang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mihing khatpo in keima hong um hi patangno khat a siatsua peuma, a ngawng ah an ngoaina suangtum khai in, tuipi thuk sungah khia leang ama atu in phazawlai hi. ");
INSERT INTO csy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mihing te upna a lalsak thei nate om ahikom, hileitung mite mailam bing hi! Tabang te sia hong piang tawntung tu hi, ahihang tabang a piangsak te atu in, a mailam bing hi! ");
INSERT INTO csy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tua ahikom na khut a hibale na peang in hong khialsak le, tan in: khut lang ni, a hibale peang ni nei in tawntung mei sungah khiak thuak tu sang in, pumpi cing ngawl in nuntakna sungah tum tu phazaw hi. ");
INSERT INTO csy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Taciang na mit in hong khialsak le, khel in a, vawk in: mit ni taw hell sungah khiak suk thuak sang in, mit langkhat taw nuntakna sungah tum tu phazaw hi. ");
INSERT INTO csy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Patangno te sung pan khatpo zawnsak vawt thak ngawl tu in kidawm in; banghangziam cile, amate vantungmi te in vantung Ka Pa mai en tawntung uh hi, ci in kong son hi. ");
INSERT INTO csy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Banghangziam cile mihing Tapa sia, a bote ngum tu in hongpai a hihi. ");
INSERT INTO csy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Bangbang in na ngaisun uh ziam? mihing khat in tuu zakhat nei a, khat sia lampial in bo bang hile, sawm kua le kua te nu sia in mual tung theampo ah pai in, a bo tuu sia zong tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mu kik a hile, a man tatak kong ci ciang, a bo ngawl tuu sawm kua le kua te sang in, tua a bo tuu khat tungah lungdam zaw hi. ");
INSERT INTO csy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tabang ma in vantung a om na Pa in, hibang patangno khat a siat tu oai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Bek tham ngawl in, na suapuipa in na tungah hong khial a hile, va pai tan a, na ki laklaw ah a khial na a ma bek taw kikum vun: na thu hong ngai a hile, na suapuipa na nga kik zo hi. ");
INSERT INTO csy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ahihang na thu hong ngai bua a hile, mihing a dang khat, a hibale, ni zuisak in a, taciang tetti ni le thum kam pan a pau nate taw ki kipsak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Taciang ama in hong ngai ngawl in na thu hong ni bale, pawlpi tungah son in: ahihang pawlpi thu zong ngai ngawl in a ni nuam tuan ba lai le, Pathian he ngawl te le shiadong te bang in koi lel vun. ");
INSERT INTO csy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","A tatak in kong ci ciang, leitung ah na hen uh te vantung ah zong ki hen tu hi: taciang leitung ah na tha uh te, vantung ah zong ki tha tu hi. ");
INSERT INTO csy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Khatvei kong son kik hi, leitung ah mihing ni a nget tu thu taw kisai thu akisi le van a om Ka Pa in vawtsak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Banghangziam cile ka min taw ni le thum na ki kaikhop uh ciang, note lai ah keima ka om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jesus kungah Peter hongpai a, Topa awng, ka tungah hong khial ka suapuipa bangza vei dong maisak tu khi ziam? sali vei dong ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus in, Sali vei dong hong ci ngawl khi hi: ahihang sawm sali vei a se sali dong maisak tu ni hi. ");
INSERT INTO csy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Tua ahikom vantung kumpingam sia, a naseam te sazian a sittel kumpipa taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tabang in a sittel ciang in, talent tul sawm a ba mi khat a kungah hong ki puak hi. ");
INSERT INTO csy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ahihang piak tu a nei ngawl hu in, a topa in, a zi le a ta, a neisa theampo zuak in, piasak tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Naseampa bok in bia a, topa, hong ngak lai tan, a vekpi in hong lo tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tasiaciang in kumpipa in a naseampa khuangai huai sa a, a bat theampo maisak in ciasak hi. ");
INSERT INTO csy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Hi kamale tua naseampa sia pai in, ama tungah zakhat a ba a nasep khoppui khat taw a ki sik ciang, a tawlsan in, na leiba hong lo tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tasiaciang a naseppui pa sia a peang nuai ah bok in, hong ngak hi lai po tan, a vekpi in kong lo tu hi, ci in thum hi. ");
INSERT INTO csy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ahizong maisak nuam ngawl hi: a leiba a lo siat dong thong sungah khum hi. ");
INSERT INTO csy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","A naseppui te in a mu uh ciang in, a thin uh nuam ngawl a, a vawt na theampo a topa kungah pai in son tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tuazawkciang a topa in ama sam a, maw nang naseam tatsia, nong thum bang in na leiba theampo hong maisak khi hi: ");
INSERT INTO csy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nang tungah hesuakna ka nei bang in, nang zong na naseppui te tungah hesuakna na nei tu kilawm hi ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kumpipa a thin-uk a, a leiba a lo siat mateng thong cingpa kungah ap hi. ");
INSERT INTO csy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Tasia bangma in a kuamapo na suapuipa i sepkhial nate na thinsung uh pan na maisak bua uh le, vantung a om Ka Pa in note zong hong maisak ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus in hi thu teng a son zawkciang, Galilee ngam nusia in, Jordan ngun ngalkhat Judah ngam ah pai hi. ");
INSERT INTO csy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mihon tampi in zui a; tua mun ah mi tampi damsak hi. ");
INSERT INTO csy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Pharisee te a kungah hongpai a, bang thu po taw ahizong pasal khat in a zi a khul tu sia ngeina a hi ziam? ci in aita nuam in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesus in, a kipatcil in a vawtpa in numei le pa in vawt hi, ci thu sim ngei ngawl nu ziam, ");
INSERT INTO csy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hi thu hang in pasal in a pa le a nu nusia tu a, a zi beal tu hi: bekdom ngawl amate ni sia phumkhat hi tu hi, ci thu zong sim ngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tua ahikom amate sia ni hi nawn ngawl in pumkhat suak hi. Pathian i ngawmsa sia mihing in khen heak tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Amate in Jesus kungah, Moses in zi khul na lai at in, khul tahen, ci in banghang thupia ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus in amate tung ah, Moses in na thinpui lei uh hang in zi khul tu hong oai hi: ahihang a kipatcil in tabang hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Keima in hibang kong ci hi, khatpo in paktat na simngawl thudang hang in a zi khul in, zi dang a nei peuma palngul mawna vawt a hihi, taciang a khul sa sia a tenpui pa zong palngul mawna vawt a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","A nungzui te in Jesus kungah, pasal le a zi thu sia tabang a hile, ki ten awl vet tu phazaw hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesus in amate tung ah, Tabang thu sia, mi theampo i san thei hi ngawl hi, tua tel a ki pia teng bek in nga tu hi. ");
INSERT INTO csy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Banghangziam cile, pawlkhat te sia a nu sung pan a sua lilim in cilkhe in suak hi: pawlkhat te sia amate vawttawm in cilkhe hi: pawlkhat te sia vantung kumpingam atu in amate le amate cilkhe in ki vawt uh hi. Tabang in a sang te bek in sang ta uh hen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tuazawkciang in patangno te lu tungah khut nga a, thungetsak tu dei in Jesus kungah paipui uh a; nungzui te in tei hi. ");
INSERT INTO csy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ahihang Jesus in, Patangno te ka kungah hongpai tahen, khak heak vun: banghangziam cile vantung kumpingam sia hibang te atu a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesus in patangno te i lutung ah khutnga a, tuazawkciang paisan hi. ");
INSERT INTO csy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Khat hongpai in, sya pha awng, tawntung nuntakna ka nei natu in bang ngamtatpha seam tu khi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus in, Banghang in, pha, hong ci ni niam? A pha khat bek om a, tua in Pathian a hihi: ahihang nuntakna sungah na tum nuam le thupiak te zui in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tua pa in koisia bel ziam? ci in dong hi. Jesus in, Tualthat heak in, palngul mawna vawt heak in, nguta heak in, tetti man ngawl pang heak in, ");
INSERT INTO csy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na nule na pa zakta in: nangma le nangma na ki it bang in na innpam te zong it in, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tangval pa in hi te theampo ka no lai pan in ka zui siat sa hi: bang kisamlai khi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus in ama kungah, Na cialcing nuam le va pai tan a, na neisa te zuak in a, a zawngte pia in, tua hile vantung ah neisa na nei tu hi: tuazawkciang hongpai tan a, hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ahihang tangvalpa in a zakciang in a thin nuam ngawl in pusuak hi: banghangziam cile ama sia nei le lam tam mama nei hi. ");
INSERT INTO csy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tuazawkciang Jesus in a nungzui te kungah, A man tatak in kong ci ciang, vantung kumpingam sungah tua mihaupa sia haksa tak in tum tu hi. ");
INSERT INTO csy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kong ci kik hi, mihau khat Pathian kumpingam sung a tum sang in, kala-uk khat phil bilvang sung a tum tu ol zaw lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tua thu a nungzui te in a zakciang in lamdangsa mama uh a, a kua peuma ngupna nga zo thong tu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ahihang Jesus in amate en a, Hi thu sia mihing te atu in piang thei ngawl hi; ahihang Pathian atu in na theampo piang thei siat hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Taciang Peter in, En in, na theampo nusia khu hi; bang ka nga tu uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus in amate tung ah, A man tatak kong ci ciang, na theampo puaphat hun hong theng tu hi, mihing Tapa sia a vangletna tokhum tung a to ciang in, no ka nungzui te tokhum sawmleni tungah to in, Israel minam sawmleni te thu na khen tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Khatpo in keima hang in a inn le a lo, a nu le a pa, a suapui, a zi le a ta a nusia a hile, a se zakhat in sang kik tu a, tawntung nuntakna ngamh in lua tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ahihang amasa te nungkhak tu a, a nungkhak te amasa hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Vantung kumpingam sia, ama sapit huan sungah naseam tu te sam tu in zingtung a vak innteakpa taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nikhat thaman dangkasan pheak khat piak tu in naseam tute taw a thukim zawkciang, amate sia sapit huan ah sawl hi. ");
INSERT INTO csy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Zingsang nai kua ciang hong pusuak a, ngual sumbuk ah a ding thathong mu hi, ");
INSERT INTO csy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Amate kungah, note zong sapit huan ah pai tavun a, a kiphu bang in hong pia tu khi hi, a ci ciang, amate zong pai hi. ");
INSERT INTO csy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ama sia nai sawmleni le nitaksang nai thum ciang in vakkik a, a dang te zong sawl leleau hi. ");
INSERT INTO csy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","'Nitaksang nai nga kimpawl in paikik leleau a, bangma seam ngawl in a ding thathong te mu hi, taciang, banghang in na seam ngawl in sun khuateak ziaksung ah ding nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Amate in ko kuama in hong cial ngawl hi, ci uh hi. Ama in, no zong ka sapit huan ah thalaw vun a; a kilawm za nga tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nitakciang in sapit huanneipa in sumkeampa kungah, a khakbel pan a masabel dong a seam te theampo sam siat in a, a thaman pia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nitaksang nai nga pan nasep kipan te hongpai ciang, ngun dangka piakhat tek nga uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Amasabel te hongpai ciang in, a tamzaw nga tu in ngaisun hi kale; ngun dangka piakhat tek ma nga uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Amate in thaman a nga uh ciang in, innteakpa phunsan uh a, ");
INSERT INTO csy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Hi a khakbel a seam te sia nai khat sung bek seam napi, vanngit pua in, nisaham thuak ko te taw a kikim in hong vawt ni hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hi kamale, ama in amate sung pan khat tungah hibang in zo kik hi, lawm awng, na tungah khialna vawt ngawl khi hi: ngun dangka piakhat piak tu in i thukim sa hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na thaman la in a, cia in: a khakbel te zong nangma kong piak za pia tu khi hi. ");
INSERT INTO csy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Keima neisa sia ka ukbang zeak thei natu ngeina om ngawl ziam? Keima phatna hang in banghang hong mu khial ni ziam? ");
INSERT INTO csy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tua ahikom a khakbel te sia masabel tu a, a masabel te sia nungkhakbel tu hi: banghangziam cile sapna nga tam hi ka le, a ki teal tawm hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus Jerusalem a pai ciang in, a nungzui sawmleni te a tuam in sam a, ");
INSERT INTO csy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","En vun! Jerusalem ah i pai hi; mihing Tapa sia thiampi lian te le thukhamhil te kungah ki zuak tu a, that tu in thukhen tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Mihing Tapa sia selno tu, sat tu le thinglamte tungah khai tu in Gentile te kungah ap tu a, nithum ni ciang in thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedee zi sia Jesus kungah a tate ni taw hongpai in bia a, a dei thu khat ngen hi. ");
INSERT INTO csy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus in, Bang dei ni ziam? ci in dong hi. Ama in, na kumpingam sungah hi ka tapa te ni sia na ziatsang ah khat, na veisang ah a dang khat tosak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ahihang Jesus in, Bang thu hong ngen nu ziam ci na he bua uh hi. Ka dawn tu hai dawn zo tu nu ziam, ka thuak tu baptisma thuak zo tu nu ziam? ci in zo kik hi. Amate in zo tu khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus in, Ka dawn tu hai sia dawn takpi tu nu hi, ka thuak tu baptisma zong thuak takpi tu nu hi: ahihang ka ziatsang le ka veisang ah a to tu sia Kei i piak tu hi ngawl a, Ka Pa in a ngealkholsa te pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Hi thu a dang sawm te in a zak uh ciang, tuate u nau tungah thin-uk mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ahihang Jesus in amate a kungah sam a, Na heaksa uh bangma in Gentile kumpi te in a mihing te sia zawthawk thu taw uk a, ulian te in thuneina taw uk uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ahizong note sungah tabang hisak heak vun: note sungah khatpo a lian nuam le, note i naseam hi tahen, ");
INSERT INTO csy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Note sungah khatpo in a lu bel a hi nuam le, note i sila hi tahen. ");
INSERT INTO csy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mihing Tapa sia ngual a sawl tu in hongpai ngawl hi, ngual atu seam tu in le mi tampi tatkhiat natu a nuntakna pia tu in hongpai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Amate Jericho pan in a pusua uh ciang, mihon tampi in zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","En vun, mittaw ni te lamhui ah to in, Jesus in hong kantan hi, ci a zak uh ciang, maw Topa, nang David Tapa, hong hesuak po tan, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mihonpi te in a om khipkhep natu in tei uh hi: ahihang amate au seseam uh a, nang David Tapa, hong hesuak po tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesus ding in amate sam a, Bang kong vawtsak tu uk nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Amate in, Topa awng, ka mit uh hong in khua hong musak tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus in amate tungah hesuakna nei a, a mit te uh a thamsak ciang in thakhatthu in khuamu uh a, amate in a nung zui hi. ");
INSERT INTO csy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Amate Jerusalem a thet ma, Olive mual nai Bethphage a thet uh ciang, Jesus in a nungzui te ni sawl in, ");
INSERT INTO csy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Na mai khua ah pai tavun a, Lapui a ki khit a no taw mu tu nu hi: a khau sut vun a ka kungah hong paipui tavun. ");
INSERT INTO csy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Mi khatpo in thu khatpo hong ci le, Topa in tulmaw hi ci vun; tua hile hong paisak pai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hi bangin a pian thei na sia kamsangpa sonkhol thu a tangtunna a hihi. ");
INSERT INTO csy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Zion tanu tungah son vun, en in, na kumpipa sia kiniamkhiak a, laa tungah to hi, lano to in na kungah hongpai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","A nungzui te pai uh a, Jesus thupiak bang in vawt uh hi, ");
INSERT INTO csy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Laa le a no hong paipui uh a, a nungzang ah puan pha in Ama tosak uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Mihon tampi in a puan te uh lampi tungah pha uh hi; midang te zong in thingsawl te sat in lampi tungah pha uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Taciang mihonpi te a mai ah pai a, a nung pan zong zui in, David Tapa tungah Hosanna: Topa min taw hongpai pa thupha nga tahen; a sangbel na mun ah Hosanna, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalem khua sung a tum ciang in, khuapi sung theampo linglawng a, hi sia a kua ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tasiaciang in mihonpi te in, hisia pa sia Galilee ngam Nazareth khuami kamsang Jesus hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesus Pathian biakinn sungah tum in, biakinn sungah vanzuak te le vanlei te a vekpi in notkeak siat hi, sum theak te i sabuai te le vakhu zuak te tokhum te theampo zong lawnthal siat hi, ");
INSERT INTO csy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Taciang amate kungah, Ka inn sia thungetna mun, kici tu hi; ci in ki atkhol napi, note in nguta te kua suaksak nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mittaw le peangbai te biakinn sung ama kungah hongpai uh a, damsak siat hi. ");
INSERT INTO csy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na lamdang a vawt te le biakinn sung pan patangno te in, David Tapa tungah Hosanna, ci in a au na uh thiampi lian te le thukhamhil te in a mu uh ciang, a thin-uk mama uh hi, ");
INSERT INTO csy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Amate in ama kungah, hi te bang au ci na za ziam? ci in dong uh hi. Jesus in amate tung ah, Za khi hi, nausen noaitawp te kam sung pan in pokna cialcing na suaksak hi, ci thu sim ngei ngawl nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesus in amate nusia a, khuapi puasang ah paisuak in, Bethany khua ah zuan a, tuak ah tam hi. ");
INSERT INTO csy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","A zingsang ciang in Jesus khuapi sang a heakkik ciang, a ngilkial hi. ");
INSERT INTO csy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lamhui ah theikung khat a mu ciang, a tungah a te simngawl bangma a mu ngawl hu in, Bangmahun in nga nawn heak in, ci hi. Tasia pociang tua theikung ko hi. ");
INSERT INTO csy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nungzui te in a mu uh ciang, lamdangsa mama in, bangbang in hizata manlang in ko pai ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesus in, A tatak in kong ci ciang, um in muang la bua po le uh te, theikung tungah a ki vawt bang bek hi ngawl, hi mual tung ah, ki khin in a, tuipi sungah tak in, na ci uh le, na ci uh bang in piang tu hi. ");
INSERT INTO csy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Na um uh le thungetna taw na nget uh theampo na nga tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus biakinn sung hongpai in, thu a hil laitak, thiampi lian te le ulian te a kungah hongpai a, bang thuneina taw hibang te seam ni ziam? Akua in hibang thuneina hong pia ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus in, Kei zong thu khat kong dong tu hi, tua thu nong son thei uh le, kua thu taw hite vawt khi ziam, ci kong son tu hi. ");
INSERT INTO csy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","John i tuiphumna sia koisung pan ziam? van pan ziam maw, mihing te kung pan ziam? ci in dong hi. Tasiaciang amate ngaisun tek a, van pan ci leang, banghang in um ngawl nu ziam? hong ci tu hi. ");
INSERT INTO csy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ahihang, mihing tung pan ci thong leang, mipite ki lau si: banghangziam cile mi theampo in kamsang khat in sang uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tasiaciang amate in Jesus kungah, hong son thei ngawl khu hi, ci in zo kik uh hi. Tasiaciang Jesus in, Kei zong bang thuneina taw hite vawt, ci hong son ngawl tu khi hi. ");
INSERT INTO csy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ahihang, bangbang na ngaisun uh ziam? Mi khat in tapa ni nei hi; a tapa a lianzaw pa kungah pai a, ka tapa awng, tu ni sun ka sapithuan ah pai in a, naseam in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A tapa in, kuan ngawl tu khi hi: ci in zokik napi, a zawkciang ki sikkik in kuankik hi. ");
INSERT INTO csy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tuazawkciang a tapa nozaw kungah pai in, tabangma in son hi. Taciang a tapa in, kuan tu khi hi, topa, ci in zo napi, kuan ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Hi tapa te ni sung pan a kua in a pa deina seam ziam? Amate in a tapa lianzaw, ci in zo kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Banghangziam cile John sia thutang in note kungah hongpai napi, um ngawl nu hi, ahihang siadong te le pumpi zuak te in um hi: note sia na mu zawk uh ciang zong um tu in na thinsung uh na kikheal nuam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A dang sontena ngai lai vun: innteakpa khat in sapit huan sungah sapit cing hi; a kimkot pan dal um in, sapit sukna mun dum to hi, teitan te zong daw in, huan naseam te sap thaw sak a, ama sia ngam khuala mama na ah khualhaw hi: ");
INSERT INTO csy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","A nga hun a cin ciang, huan naseam te tung pan sapit nga ama nga tu teng la tu in a naseam te paisak hi. ");
INSERT INTO csy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Huan tho te in a naseam te man in, khat sia vel hi, khat sia that in, a dang khat sia suangtum taw deang hi. ");
INSERT INTO csy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amasa sang in a tamzaw naseam te paisak kik a, amasa te bangma in vawt leleau uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ahihang a khakbel ciang in, a tapa paisak hi, amate in ka tapa sia upat tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ahihang huan naseam te in a tapa a mu uh ciang in, hi sia a ngamhlua tu pa hi, pai tavun, thatlum in a ngamh sut tawng, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tabang in a tapa sia man in, sapit huan puasang ah pusua in that uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tua ahikom sapit huannei pa hongpai ciang, huan naseam te sia bangbang in vawt tu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Amate in, tua ngamtat sia te susia tu a, a hun a cin ciang thing nga te a pia tu lo tho dang te sapthawsak tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus in amate tung ah, Innsa te in a nil uh suangtum sia innbul thupibel hongsuak hi, hi thu sia Topa i nasep hi a, i mu na ah, lamdang mama hi, ci Lai Thiangtho sungah sim ngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tua ahikom kong ci hi, Pathian kumpingam sia note kung pan in la tu a, nga tampi a nga minam te pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","A kuamapo hi suang tungah a tak le tam tham tu hi: ahihang hi suang a takna mun po, ki ngoai in hui siat tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesus i sontena te sia thiampi te le Pharisee te in a zak uh ciang, amate thu son hi, ci tel uh hi. ");
INSERT INTO csy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Amate in Jesus mat sawm uh hi napi, mihonpi te kita uh hi, banghangziam cile amate in kamsang khat bang in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus in amate tungah sontena son kik a, ");
INSERT INTO csy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Vantung kumpingam sia a tapa atu mopoai a vawt kumpipa taw kibang hi, ");
INSERT INTO csy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A naseam te sawl in, a khualhil sa teng samsak napi, kuama pai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A naseam te sawlkik a, khualhil sa teng tung son vun, nitak an sia ki nginkhol sa in om zo hi: ka khui tal te le nganno thau mamate ki ngo siat zo a, na theampo ki nginsa hi zo hi, mopoai ah hongpai tek tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ahihang a khualhil nate in, bangma thusim ngawl in, khat sia lo ah, a dang khat sia sumzonna mun ah, tabang in amate uk na tek ah pai veve uh hi: ");
INSERT INTO csy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A dang a tang lai te in a naseam te man a, vawtsia in that uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kumpipa in a zak ciang thin-uk mama a, a ngalkap te sawl in tualthat te siatsua in, amate khuapi te zong mei taw hal siat hi. ");
INSERT INTO csy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tua mun ah a naseam te hibang in ci hi, mopoai sia kinging siset zo hi, ahihang ka khualhil sa teng a sap thamman om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tua ahikom lamzikpi ah pai vun a, na mu uh theampo mopoai pai tu in hil vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tua ahikom a naseamte lamzikpi ah pai uh a, miphangawl le a pha a kibang in a mu uh theampo kaikhawm in, mopoai ah leangna dim siat hi. ");
INSERT INTO csy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Taciang kumpipa a leangna te en tu in a tum ciang, mopoai puan a sil ngawl mi khat mu a: ");
INSERT INTO csy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Lawm awng, hi mun ah bangbang in mopoai puan sil ngawl in hongpai ni ziam? ci in a dok ciang, bangma son tu a nei bua hi. ");
INSERT INTO csy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tuazawkciang, kumpipa in a naseam te kungah, a khut le a peang hencip in paipui vun a, a puasang khuazing na ah khia vun; tua mun ah kaana le ha ngoai na om tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Banghangziam cile a kisam tam mama napi, a ki teal tawm hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tuazawkciang Pharisee te hongpai in, Jesus pauna pan, bangbang in aita thei tu, ci in ngaisun tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Amate in a nungzui te le Herod i mihing te sawl in, Topa awng, nangma sia na thuman hi, kuama zong lau ngawl in le kuama mai zong zakta tuan ngawl a, Pathian thuman lampi hil ni hi, ci kong he uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tua ahikom, bangbang in ngaisun ni ziam? Caesar tungah shia pia tu khu ziam maw, pia ngawl tu khu ziam? hong son tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ahihang Jesus in amate tatsiatna he a, No a ki hitheamsak te, banghang in hong aita nu ziam ");
INSERT INTO csy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Shia dangka hong lak tavun, ci hi, amate in zong dangka tangkhat paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesus in, Hi sia a kua lim le ceptena ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Amate in, Caesar lim le ceptena hi, ci uh hi, tasiaciang, Caesar neisa te Caesar pia vun a, Pathian a te Pathian pia vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Amate in hi thu a zak uh ciang in, lamdangsa tek mama uh a, ama nusia in paisan uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tua ni in thawkikna om ngawl hi, a ci Saducee te a kungah hongpai in, thu dong hi. ");
INSERT INTO csy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Syapa awng, mi khat in ta nei ngawl in a thi le, a ci-mit ngawl tu in a nau in a mo tenpui tahen, ci in Moses in ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Tu in u nau pa sali om hi: a lianbel sia in zi nei napi, ta nei ngawl in thi hi, tasiaciang a nau kungah a zi nusiat hi: ");
INSERT INTO csy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tabangma in a ni na, a thum na le a sali na dong in thi hi. ");
INSERT INTO csy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A khakbel ciang in tua numei nu zong thi hi. ");
INSERT INTO csy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tua ahikom thawkikni ciang tua numei nu sia, sali sung pan a kua bel i zi hi tu ziam? banghangziam cile a u nau vekpi in tenpui ngeitek uh hi, ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus in amate zo kik a, Lai thiangtho le Pathian vangletna na heak ngawl uh hang in khial siat nu hi: ");
INSERT INTO csy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Banghangziam cile, thawkik ni ciang in kipui na le tenpui tu in ki pia, cite om nawn ngawl tu a, vantung ngam ah Pathian i vantung mite bang hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ahihang mithi te thawkikna thu taw kisai Pathian in note tung hong son na ah, ");
INSERT INTO csy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Keima in Abraham Pathian, Isaac Pathian, Jacob Pathian ka hihi, ci in a son thu sim ngei ngawl nu ziam? Pathian sia mithi te Pathian hi ngawl a, a nungta te pathian a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tasiaciang mihonpi te in hi thu a zak uh ciang in, Jesus thuhilna lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus in Sadducee te pau natu he ngawl in vawt hi, ci Pharisee te in a zak uh ciang, amate munkhat ah ki kaikhawm uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tuazawkciang amate sungah thukhamhil khat in Jesus aita nuam ahikom, ");
INSERT INTO csy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Syapa awng, thukham sung pan a lianbel thupiak sia bang ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus in ama tung ah, Topa na Pathian sia na thinsung theampo, na nuntakna theampo le na ngaisutna theampo taw it in. ");
INSERT INTO csy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hi thu sia thupiak masabel le a lian thupiak a hihi. ");
INSERT INTO csy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Taciang a ni na sia, nangma le nangma na ki it bang in, na innpam te it in, a ci sia a masabel taw a kibang a hihi. ");
INSERT INTO csy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hi thupiak ni te tungah thukham theampo le kamsang te thu theampo khuangkhim siat hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee te munkhat ah a ki kaikhop laitak in, Jesus in amate tung ah, ");
INSERT INTO csy_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Christ sia bangbang in ngaisun nu ziam? akua tapa ziam? ci in dong hi; amate in, David Tapa hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesus in amate mun ah, Tabang a hile David in Christ sia; Topa, ci in Thaa taw banghang in sam thei ziam, David i ci na ah, ");
INSERT INTO csy_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Topa in ka Topa kungah, na ngal te na peang koina in ka vawt mateng Ka ziatsang ah to in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David in Christ sia ka Topa ci in a sam le, banghang in a tapa hi thei tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Kuama in kamkhat zong zo kik thei ngawl ahikom, tua ni pan kipan in, kuama in thu dong ngam nawn ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tuazawkciang in Jesus in mihonpi te le a nungzui te kungah thuhil a, ");
INSERT INTO csy_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Thukhamhil te le Pharisee te sia Moses tokhum ah to uh hi: ");
INSERT INTO csy_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tua ahikom amate in vawt a hong sawl peuma zui vun a, ahihang amate ngamtat bang in ngamta heak vun, banghangziam cile amate in a son uh bang in seam ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Banghangziam cile amate in a puak zawk ngawl tu vanngit te hen in mihing te i liangko tungah suan uh a, puasak uh a hihang amate a hile, a khutme dawn taw zong tham nuam ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ahihang amate i a vawt theampo te sia, mite mu thei tu in vawt uh hi: Amate lai thiangtho bu koi na savun ip te nangawn a lianpui in vawt uh a, a puan kiil te zong a zai tatak in vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Poai sungah a sangbel khan sungah to nuam in, synagogue sungah zong tokhum thupibel tungah to nuam uh hi, ");
INSERT INTO csy_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Sumbuk te ah ngual i paupui tu le Rabbi, Rabbi, ci in sap tu dei uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Hi kale note sia, Rabbi ci in sap tu uk heak vun; banghangziam cile, na Topa uh khatbek om a, tua in Christ a hihi, note sia u nau khat na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Taciang in hileitung ah kuama, pa, ci heak vun: banghangziam cile vantung a om na Pa uh khat bekma om hi. ");
INSERT INTO csy_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Christ bekma na Topa uh ahikom kuama peuma, topa, ci in ki sam heak tahen. ");
INSERT INTO csy_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ahizong note sung pan a lianbel sia na naseam uh hi tu hi, ");
INSERT INTO csy_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Akua mapo ama le ama a ki lamsang sia khiaksuk na thuak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Ahihang thukhamhil te le Pharisee te, a ki hitheamsak te, na mailam uh bing hi, banghangziam cile, vantung kumpingam na khaktan uh a, noma le tum nuam ngawl bekdom ngawl a tum nuam te zong na tumsak bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Thukhamhil te le Pharisee te awng! na mailam uh bing hi! banghangziam cile note in meingong te inn te sia ngongtat in na suttol uh a, a sau theiza in thu ki ngen theamsak nu hi: Tua ahikom dan a lianzaw na thuak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Thukhamhil te le Pharisee te, a kihitheamsak te, na mailam uh bing hi! banghangziam cile mi khat biakna lai tu in tuipi le leitung kimveal in na vak uh a, a ki kheal zawkciang note sang in a se ni tamzaw Hell ngam i ta na suaksak uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","No mittaw lamlak te, na mailam uh bing hi, khatpo in biakinn sam in a kiciam le bangma poimaw ngawl hi, ahihang a kuamapo biakinn a om kham sam in a kiciam le ama sia leiba nei hi, na ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","No mi mawmaw le mittaw te: bang lianzaw ziam, kham maw, a hibale kham a thiangthosak biakinn koisia hi zaw? ");
INSERT INTO csy_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Khat po in biaktau sam in a kiciam le bangma poimaw ngawl hi, ahihang khatpo in tua tungah biakpiakna a ki piasia sam in a kiciam le ama sia mawnei hi. ");
INSERT INTO csy_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","No mi mawmaw le mittaw te! bang lianzaw ziam; biaktau ah a ki pia sia maw, a hibale a ki pia sia a thiangsak biaktau lianzaw ziam? ");
INSERT INTO csy_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Tua ahikom mihing khat in biaktau sam in a kiciam le tua tungah a omte theampo sam in kiciam a hihi. ");
INSERT INTO csy_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Taciang khatpo in biakinn sam in a kiciam le tua biakinn sungah a om sia sam in kiciam a hihi. ");
INSERT INTO csy_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Taciang van le Pathian tokhum sam in a kiciam peuma tokhum tungah a to pa sam in kiciam a hihi. ");
INSERT INTO csy_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Thukhamhil te, Pharisee te le a ki hitheamsak te, na mailam uh bing hi! banghangziam cile note in lenmui, thihawm le, lonamsia te se sawm sua se khat pia tek napi, thukham sungah a thupi zaw thukhenna, hesuakna le upna thu te zui ngawl in khe nu hi: tua te sia na vawt tu uh hi a, a dang te zong vawt ngawl in nusiat thong tu hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","No mittaw lamlak te, thosi no khat zong ki hel ngawl tu in hawp napi, kala-uk lopval nu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Thukhamhil te, Pharisee te le a ki hitheamsak te, na mailam uh bing hi! banghangziam cile hai le kuang na sil uh ciang in, a puasang bek na sil uh a, a sungsang sia ngual neisa na lak uh le duhopna taw kidim hi. ");
INSERT INTO csy_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nang Pharisee mittaw pa, hai le kuang te a sungsang sil masa in a, a puasang zong thiang tu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Thukhamhil te, Pharisee te le a ki hitheamsak te, na mailam uh bing hi! banghangziam cile, note sia za ngo a ki zut thankul taw na kibang uh hi, a puasang sia a hoi tu bang in kilang napi, a sungsang sia mithi ngu le a thiang ngawl taw kidim hi. ");
INSERT INTO csy_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tasia bangma in note zong na puasang uh sia mihing te mai ah a thutang in kilang napi, na sungsang uh sia ki hitheamsak na le siatna taw dim hi. ");
INSERT INTO csy_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Thukhamhil te, Pharisee te le a ki hitheamsak te, na mailam uh bing hi! banghangziam cile kamsang te thankul na sa uh a, mi thutang te thankul te zong a hoi mama in zeam nu hi, ");
INSERT INTO csy_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ka pu ka pa te hun lai koma om kana le ung, kamsang te thisan luan na ah ki hel ngawl tu kana khu hi, ci nu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Tua ahikom kamsangte a that te na hi uh hi, ci noma mama tetti te na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tua ahikom na pu na pa te i ki te na note in dim tavun. ");
INSERT INTO csy_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","No ngul suan te, hell ngam thet natu pan bangbang suakta thei tu nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Tua ahikom, en vun, note kungah kamsang te, mipil te le thukhamhil te kong paisak a, pawlkhat te sia that in thinglamte tungah khai tu nu hi; taciang pawlkhat te sia synagogue sungah vel in le khuapi khat zawkciang khat ah vawtsia tu nu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Tua ahikom a thutang Abel thisan pan kipan biakinn le biaktau ki kal ah na thalup uh Barachias tapa Zachariah thisan ciangdong, leitung ah a luang thisan theampo note tungah hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A tatak in kong ci ciang, hi thu te theampo sia tu hun mihing te tungah theng tu hi. ");
INSERT INTO csy_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Maw Jerusalem, Jerusalem, kamsang te na that a, na kungah hongpai te suangtum taw sep ni hi, akpui in a no te a thakhui nuai ah a uap bang in, tamveipi hong uap nuam hi kaleng, na uk bua hi! ");
INSERT INTO csy_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","En vun, na inn uh ngamkhing dide in ki nusia zo hi. ");
INSERT INTO csy_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Banghangziam cile Topa min taw hongpai pa sia thuphatoai hi, na ci uh mateng, note in hong mu nawn ngawl tu nu hi, ci in kong son hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus biakinn pan pusuak in a pai laitak, a nungzui te in biakinn kisa lak tu in a kungah hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesus in, Hi bang van te a vekpi in mu hi ngawl nu ziam? a tatak in kong ci ciang, phelthap ngawl bul in suangtum khat zong kithuap nawn ngawl in cimtham lai tu hi. ci hi. ");
INSERT INTO csy_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus Olive mualtung ah to a, a nungzui te kuama heak ngawl in a kungah hongpai uh hi, hi thu te banghun ciang hong piang tu ziam, nangma paikik tu le leitung bo tu thu musakna sia bangbang ziam? ci hong son tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus in, Kuama in hong theam ngawl natu in kidawm vun. ");
INSERT INTO csy_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Banghangziam cile mi tampi te keima min taw hongpai tu a, keima in Christ ka hihi; ci in mi tampi theam tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Taciang ngal kido na le ngal ki sim tu thu te na zak uh ciang in thinngim le buai in om heak vun, banghangziam cile hibang te theampo a piang hamtang tu thu hi a, a tawpna hi ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Banghangziam cile minam khat le minam khat ki do tu a, kumpingam khat le kumpingam khat kisim tu uh hi, mun tatuam ah kial le pul te hong tung tu a, zinling tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hite theampo sia hena dana kipat na a hihi. ");
INSERT INTO csy_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tuazawkciang note vawtsiat tu le thalup tu in hong ki ap tu a, Keima min hang in, minam theampo in hong ensan tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mi tampi te thin-uk tu in kivawt tu uh a, khat le khat ki leheak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kamsang tampi te hong piang tu a, mi tampi theam tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Siatna hong khang va-ial tu ahikom, mi tampi te itna kiam va-ial tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ahihang a tawp dong a thuak te in ngupna nga tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Minam theampo atu tetti hi tu in kumpingam lungdamna thu sia leitung theampo ah ki son tu a, tua zawkciang in a tawpna hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Tua ahikom kamsang Daniel sonkholna bang in suksiatna, a lipkhaphuai sia mun thiangtho ah a din ciang in, hi lai a sim peuma in tel tahen. ");
INSERT INTO csy_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Taciang Judah ngam sungah omte mualtung ah tai tahen. ");
INSERT INTO csy_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Inn tungah a omte sia innsung van la tu in tuaksuk heak tahen. ");
INSERT INTO csy_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Lo sungah a omte in a nik le puan la tu in cia heak hen. ");
INSERT INTO csy_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tua hun ciang in, naupai te le nau noailuai te sia haksa mama tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ahihang na tai tu uh hun sia phalbi hun le sabbath ni a hi ngawl natu in thungen vun: ");
INSERT INTO csy_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Banghangziam cile leitung ki bitphua pan kipan a om ngei ngawl le mailam hun ah zong a om nawn ngawl tu haksatna lianpi a hihi. ");
INSERT INTO csy_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tua ni te tomsak ngawl hile kuama in thuakzo ngawl tu hi: ahihang a tealsa te atu in, tua ni te tomsak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tasiaciang khatpo in Christ sia ziak ah om hi, a hibale zesung ah om hi, hong ci le um heak vun. ");
INSERT INTO csy_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Banghangziam cile Christ phaw a sil te le leilot kamsang te hong theng tu a, a suak thei le a tealsa te zong theam tu in musakna le nalamdang tampi lak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","En vun, hi thu te kong sonkhol zo hi. ");
INSERT INTO csy_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tua ahikom, mihing te in en vun Christ sia duisung ah om hi, hong cile pai heak vun: en vun, inndoi sungah om hi, a ci le zong um heak vun. ");
INSERT INTO csy_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Banghangziam cile, khualeng sia nisuana sang pan hong leng in nitumna sang dong taan hi; mihing Tapa hongpai ciang zong tabangma hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Banghangziam cile, mithi luang omna mun theampo ah vaciik te hong ki kaikhawm tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tua ngimna ni te zawk pociang ni hong mial tu a, tha zong tang nawn ngawl tu hi, taciang aksi te van pan in tak tu a, vantung vangletna te zong ling tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tasiaciang mihing Tapa musakna van ah hong kilang tu a, leitung minam theampo tau tu hi, taciang amate in vangletna le minthanna lianpi taw mihing Tapa mei tungah hongpai mu tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ama vantungmi te a lian mama lemle tum tu in sawl tu a, a tealsa te van mongkhat pan mongkhat dong leitung kingli a a omte theampo munkhat ah hong kaikhawm tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Theikung pan in sontena khat sin vun; a bak te pan in a dawnmoi hong sua ciang, khal hun hong nai zo hi, na ci thei uh hi: ");
INSERT INTO csy_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tasia bangma in hi thu te na mu uh ciang a hun hong nai zo a, kongbiang bul vacin hong theng zo hi, ci he tavun. ");
INSERT INTO csy_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A tatak in kong ci ciang, hi thu te theampo a tangtut dong hi minam te bo ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Van le lei bo tu hi, ahihang ka kammal te a bo batu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ahizong tua ni le hun sia kuama in he ngawl hi, vantungmi te in zong he ngawl hi, Ka Pa bek in he hi. ");
INSERT INTO csy_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hikama le Noah hun lai bangma in mihing Tapa hongpai ciang zong tabangma hitu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Banghangziam cile tuipiliim ma, Noah tembaw sung a tum ni dong mihing te, ne in dawn in, kipui le mopoai vawt in om tek uh hi, ");
INSERT INTO csy_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tuipi a liim hunlam zong he ngawl in, tui in a khu siat bangma in mihing Tapa hongpai ciang zong tabangma hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tua hun ciang in lolai ah mi ni sung pan khat la tu a, a khat ki nusia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","An ngoai numei ni sung pan khat ki la tu a, khat ki nusia tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Na Topa uh hongpai tu hun he ngawl na hi uh ciang in, encik in ngak vun. ");
INSERT INTO csy_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nguta hongpai tu hun innteakpa in he hile, a inn encik nginge tu a, nguta te i phulsak na thuak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tua a hiciang kinging kholsa in om vun, banghangziam cile mihing Tapa siana ki ngin ngawl hun laitak in hongpai tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","A topa in ama innkuanpui te a hun cinciang neaktu an a pia thei sia a makai in koi tu a, a muanhuai le a ciim naseam sia a kua ziam? ");
INSERT INTO csy_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","A topa hongpai ciang in na a sep laitak a mu thak naseampa sia thuphatoai a hihi. ");
INSERT INTO csy_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A tatak in kong ci ciang, tua naseam pa sia a topa in a neisa theampo tungah thunei tu in koi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ahihang naseam phangawl in a thinsung pan in ka topa hong cia hak tu zam, ci in ngaisun a; ");
INSERT INTO csy_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Naseam dang te vel in zukham thei te taw ne le dawn in om tu hi, ");
INSERT INTO csy_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tua naseampa in a upmawk ngawl ni le a kingin ngawl laitak in a topa hong theng tu hi, ");
INSERT INTO csy_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tua naseampa sia a topa in nasiatak in sat tu a, kana le ha ngoaina om na mun ah a ki hitheamsak te taw koi khawm tu hi. ");
INSERT INTO csy_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Tasiaciang in vantung kumpingam sia Zineipa a muak tu in mei-inn taw a pai ngaknu thiangtho sawm taw sonte hi. ");
INSERT INTO csy_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nga te sia ciim a, a dang nga te sia mawmaw uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","A mawmaw nga teng in mei-inn keng ahihang meitui keng thua ngawl uh hi, ");
INSERT INTO csy_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A ciim te a hile bungsung ah a mei-inn taw keng uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zineipa hong theng hak ahikom a vekpi in lusu in mu siat uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Zankim ciang in, en vun, zineipa hongpai zo hi; pai vun a, muak vun, ci hong ki tangko hi. ");
INSERT INTO csy_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tasiaciang ngaknu thiangtho te a vekpi in tho uh a, amate mei-inn tek vak tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","A mawmaw te in, a ciim te kungah, na meitui hong pia tavun; banghangziam cile ka mei-inn te uh mitsiat hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ahihang a ciim te in, tabang hi ngawl hi; ka meitui uh no atu taw kicing ngawl hi: meitui zuak te kungah pai tavun a, lei tavun, ci in zo kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Amate meitui lei tu a pai lan in zineipa hongpai hi; taciang a ki ngingsa in a omte taw mopoai sungah tum tek uh a: tuazawkciang kongkha sia kikhak hi. ");
INSERT INTO csy_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tuazawkciang, a dang ngaknu thiangtho te zong hongpai uh a, Topa, Topa, kong hong hon tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ahihang ama in, amantak in kong son hi, note kong he ngei bua hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Tua a hikom, mihing Tapa hongpai tu ni le a hun he ngawl na hi uh ciang in, encik in ngak nginge tavun. ");
INSERT INTO csy_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Banghangziam cile, vantung kumpingam sia khual khuala a haw tu hu in, a naseam te sam a, a neisa te a ap pa taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Amate hitheiza taw kisi in, khat tungah tatent nga, a dang khat tungah talent ni le a dang khat tungah talent khat pia in; a piak zawk pociang in khualhaw hi. ");
INSERT INTO csy_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Talent nga a sang pa sia pai in summet a vawt ciang a dang talent nga metsak hi. ");
INSERT INTO csy_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tasia bangma in talent ni a sang pa in zong a dang talent ni nga thua hi. ");
INSERT INTO csy_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ahihang talent khat a sang pa sia pai in, dum a taw zawkciang a topa i sum sia phual hi. ");
INSERT INTO csy_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","A khuangei zawkciang in, a topa hongpai a, a naseam te san za tek en hi. ");
INSERT INTO csy_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Talent nga a sang pa sia a dang talent nga keng in hongpai a, topa nangma in talent nga hong ap ni hi: en in, talent nga ma a met nga khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A topa in, a pha in na seam hi, nang a pha le a thuman naseam pa: na tawmno tungah thuman na hikom in, na tampi uk tu in kong koi tu hi: na topa lungdamna sungah tum in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Talen ni a sang pa zong hongpai in, topa, talent ni hong ap ni hi: en in, a dang talent ni nga thua khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","A topa in, a pha in na seam hi, nang a pha le a thuman naseam pa; na tawmno tungah thuman na hikom in na tampi uk tu in kong koi tu hi: na topa lungdamna sungah tum in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tuazawkciang in, talent khat a sang pa zong hongpai a, topa awng, nangma sia mi sonhak ni hi, ci kong he hi, na poai ngawl na mun ah na at a, na ciin ngawl na mun ah anla ni hi: ");
INSERT INTO csy_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Lau ka hikom pai in, lei sungah na talent ka phual hi: en in, na neisa tuak sungah om nginge hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","A topa in, nang naseam tatsia le datham pa, ka poai ngawl na ah ka at le ka ciin ngawl na pan ka lak, na he a hile: ");
INSERT INTO csy_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ka sum teng sumtheak te kung ap le te pha hi, tabang hile kongpai ciang ka sum le a met nga tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Tua ahikom a talent laksak vun a, talent sawm a nei pa tungah pia vun. ");
INSERT INTO csy_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Banghangziam cile, a neite ki pia thua tu a, a dimlet in nei tu hi: ahihang a nei ngawl te sia a neisun uh zong ki laksak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Phattuamna om ngawl naseam pa sia kana le ha ngoaina mun doipua khuazing sungah khia vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Mihing Tapa minthanna taw, a thiangtho vantungmi theampo taw hongpai ciang in a vangletna kumpi tokhum tungah to tu hi: ");
INSERT INTO csy_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Taciang in a mai ah mi theampo te kaikhawm tu a: tuucing pa in tuu le keal te a khen bang in khat le khat khen tu hi. ");
INSERT INTO csy_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Tuu te sia a ziatsang ah koi tu a, keal te sia a veisang ah koi tu hi. ");
INSERT INTO csy_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tuazawkciang in, kumpipa in a ziatsang a te tung ah, hongpai tavun, no ka Pa thupha sang te, leitung bitphua pan kipan in note atu a kipua kholsa kumpingam lua tavun: ");
INSERT INTO csy_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Banghangziam cile, ka ngilkial laitak in, an nong pia uh hi: ka dangko laitak in, tui nong pia uh hi: zin ka hi laitak in, nong tungsak uh hi: ");
INSERT INTO csy_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Pum nguak in ka om laitak in, puan nong silsak uh hi: ka cinat laitak in, nong ve uh hi: ka thongtak laitak in, nong pai uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tasiaciang in a thutang te in, Topa, banghun lai na ngilkial hong mu in, an hong pia khu ziam? a hibale na dangko in dawn tu hong pia khu ziam? ");
INSERT INTO csy_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Banghun lai in zin na hi hong mu in, hong tungsak khu ziam, na pum nguak hong mu in, puan hong silsak khu ziam? ");
INSERT INTO csy_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Banghun lai na nat le na thongtak hong mu in, hong ve khu ziam? ci in zokik uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kumpipa in, a mantak ka ci ciang, ka suapui te sung a nobel te tungah na vawt uh te, keima tungah hong vawt na hi uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tasiaciang in a veisang a to te tung ah, Topa in, no hamsiat thuak te ka kung pan in kiheam tavun, doaimangpa le a nungzui te a tu a ki vawtkhol tawntung mei sungah pai vun: ");
INSERT INTO csy_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Banghangziam cile, ka ngilkial a, an hong pia ngawl nu hi: ka dangko a, tui hong pia ngawl nu hi: ");
INSERT INTO csy_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Zin ka hi lai in, hong tungsak ngawl nu hi: pum nguak in ka om a, puan hong silsak ngawl nu hi: ka nat le thong ka tak ciang in, hong ve ngawl nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tasiaciang a mate in, Topa, banghun lai na ngilkial, na dangko, zin na hile thong na tak hong mu in hong khoi ngawl khu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tasiaciang ama in, kei kong cina pan, hi teng sung pan a nobel tungah na vawt ngawl uh teng sia kei tungah vawt ngawl na hi uh hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hite sia tawntung ngim na sungah pai tu a: mi thutang te a hile tawntung nuntakna sungah pai tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hi thu te a hil zawkciang in Jesus in a nungzui te tung ah, ");
INSERT INTO csy_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Tuzawk ni ni ciang in, paisan poai hi tu hi, ci na he uh hi, taciang mihing Tapa sia thinglamte tungah khai tu in ap tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Taciang in thiampi lian te, thukhamhil te le mi upa te thiampi sang Caiaphas leitual ah ki kaikhawm uh a, ");
INSERT INTO csy_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jesus man ku in, a thalup thei natu thu ngeal uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Poai hun sungah vawt ngawl tu hi, tabang hi thong leang, mipite hong ngamlum tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Bethany khua ah Simon kici miphak pa inn ah Jesus a om laitak in, ");
INSERT INTO csy_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Anne in a to na mun ah numei khat, a manham mama sathau namtui alabaster thawlkhat keng in hongpai a, Jesus lu tung pan buak hi. ");
INSERT INTO csy_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ahihang a nungzui te in a mu uh ciang in thin-uk uh a, banghang in hibang ki pakvawt ziam? ");
INSERT INTO csy_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Banghangziam cile hi sathau namtui sia a mantam in zuak in, mizawng te piak tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tua thu Jesus in a heak ciang in, Banghang in numei nu nawngkaisak nu ziam? hi numei nu in ka tungah napha vawt hi. ");
INSERT INTO csy_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Banghangziam cile mizawng te noma taw om tawntung hi; ahihang kei hong om tawntung ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ka pumpi tungah sathau namtui hong buak na sia, keima ki vui natu in hong vawt a hihi. ");
INSERT INTO csy_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A tatak in kong ci ciang, leitung theampo lungdamna thu ki son na theampo ah hi numei nu vawt thu zong ama phaw tawntung na in son tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tuazawkciang Judas Iscariot a kici, nungzui sawmleni sung pan khat pa sia, thiampi lian te kungah pai a, ");
INSERT INTO csy_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Amate tung ah, Jesus note hong ap leng bang hong pia tu nu ziam? ci hi. Amate in dangka sawmthum taw thukim na vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tua hun pan kipan Jesus a ap thei natu hunpha zong tan hi. ");
INSERT INTO csy_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tol saw ngawl anluum poai ni masabel ni in nungzui te Jesus kungah hongpai a, paisan poai ciang in, koisung ah anneak natu mun vawtsak tu khu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesus in, Khuapi sungah pai tavun a, khat i tungah hibang son vun, Syapa in ka hun cing zo hi; ka nungzui te taw na inn ah paisan poai vawt tu khi hi, ci hi, ci in sawl hi. ");
INSERT INTO csy_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","A nungzui te in Jesus sawl bangin vawt uh a, paisan poai atu kinging khol uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nitaksang ciang in Jesus a nungzui sawmleni te taw to uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Amate an a neak uh laitak Jesus in, A mantak in ka ci ciang, note sung pan khat in kei hong leheak tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Amate sia he mama uh a, khat zawkciang khat in, Topa, keima ka hi ziam? ci in dong tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesus in, Keima taw kuang sung a sawkkhawm sia in kei hong leheak tu hi. ");
INSERT INTO csy_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","A ki atsa om bang in, mihing Tapa sia pai tu hi: ahihang mihing Tapa a leheak sia a hile, a mailam bing hi, ama sia piang bale phazaw hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Topa a leheak pa Judas in, Topa, keima khi ziam? ci in dong a, Jesus in, Na ci bang in man hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Amate an a neak uh laitak in, Jesus in anluum la a, thupha a piak zawkciang phel in, a nungzui te pia a, La vun a, ne vun, hisia in ka pumpi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tuazawkciang hai zong la in, lungdam a ko zawkciang, amate pia a, Na vekpi in dawn vun; ");
INSERT INTO csy_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Banghangziam cile, hisia in thuciam thak taw kisai mi tampi te mawna maisakna tu in a luang ka thisan a hihi. ");
INSERT INTO csy_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ahihang kei kong ci na pan, hibang sapittui a thak sia ka Pa kumpingam sungah note taw ka dawn kik mateng, bangmahun in dawn kik ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Amate la a sak zawk uh ciang, Olive mualtung zuan in pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tuazawkciang Jesus in, Tuucingpa ka that tu a, tuu hon te kikhen in peakkeak tu hi, ci in a ki atkhol bang in, na vekpi in tu zan keima hang in thinkiam mama tu nu hi. ");
INSERT INTO csy_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ahihang ka thawkik zawkciang in, Galilee ah note mai ah ka na paikhol tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Peter in, mi theampo nangma hang in thinkiam in om kale, kei ka thinkiam batu hi, ci in zokik hi. ");
INSERT INTO csy_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus in, A tatak kong ci ciang, tu zan ak khuan ma thum vei hong nial tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Peter in, nangma taw ka thi tu ahizong hong nial ngawl tu khi hi, ci hi. Tasia bangma in nungzui dang theampo in zong citek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jesus amate taw Gethsemane a kici huan ah pai uh a, Zia sungah thu ka nget laitak ziak ah to vun, ci in a nungzui te son hi. ");
INSERT INTO csy_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter le Zebedee tapa ni te paipui a, thinngim mama le thuakhak na hong kipan hi. ");
INSERT INTO csy_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tasiaciang amate tung ah, Thi tu za dong in ka thinngim hi: ziak ah om vun a, keima taw ngak nginge vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tua mun pan in khua la zaw hiat na mun ah pai a, bok in thungen hi; Maw ka Pa, a hi thei le, hi hai sia kei taw ki pealsak tan: ahihang kei deina bang hi ngawl in nangma deina bang hi zaw tahen, ci in thungen hi. ");
INSERT INTO csy_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","A nungzui te kungah hongpai a, a mate a mutthip sa in mu hi, taciang Peter kungah, Nai khatpo zong hong ngak zo ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ze-etna sungah na tum ngawl natu thungen in ngak vun: thaa sia ukna nei ahihang, pumpi sia thaneam hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus a ni veina paikik a, Maw ka Pa, a hi thei le, hi hai sia kei taw ki pealsak in: ahihang kei deina bang hi ngawl in nangma deina bang hi zaw tahen, ci in thungen hi. ");
INSERT INTO csy_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A nungzui te kungah hongpai a, a mutthip sa ma in mu kik hi: banghangziam cile amate a mutsuak mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jesus in amate nusia in khatvei paikik a, a ngetsa bangma in a thumvei na ngen hi. ");
INSERT INTO csy_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tuazawkciang nungzui te kungah hongpai a, Tu in mu vun a, tawlnga vun, mihing Tapa sia mawnei te khut ah ap tu hun hong theng zo hi. ");
INSERT INTO csy_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tho vun a, pai tawng, en vun keima hong ap sia pa hong theng zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tabang in Jesus a pau laitak in, en vun, nungzui sawmleni sung pan khat a hi, Judas hongpai a, thiampi lian te le ulian te i sawl mihon tampi te zong namsau le moltum te toai in hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jesus a ap sia pa in, ka nap sia Ama hi, man vun; ci in heaksakna pia khol zo hi. ");
INSERT INTO csy_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Taciang Jesu kungah manlang tak in hongpai a, Topa, na tungah thupha om tahen; ci in nam hi. ");
INSERT INTO csy_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus in, Lawm awng, banghang hongpai ni ziam? ci hi. Tuazawkciang amate hongpai a, Jesus man in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","En vun, Jesus taw a omkhawm khat in, a namsau dok in thiampi lian pa i naseam pa sat ahikom, a bil tawng pai hi. ");
INSERT INTO csy_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tasiaciang in Jesus in ama kungah, Na namsau ama omna mun ah koikik in: banghangziam cile namsau a zam te, namsau taw ma in thi kik tu hi. ");
INSERT INTO csy_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tu mama in ka Pa tungah ngen thei khi hi, ci le, ngen leng vantungmi hon sawmleni sang tamzaw hong sawl tu hi, ci thu ngaisun ngawl ni ziam? ");
INSERT INTO csy_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ahihang hibang hi tu hi, ci laithiangtho sung a ki atkholsa thu te bangbang tangtung thei tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tua hun laitak in mihonpi te tung ah, Note, banghang nguta man tu bang in namsau le moltum taw kei man tu in hongpai nu ziam? biakinn sungah thuhil in nisim note taw ka to lai hong man ngawl nu hi. ");
INSERT INTO csy_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ahihang hi thu te sia, kamsang te atkholsa laithiangtho a tangtun natu a hihi, ci hi. Tasiaciang in a nungzui te theampo ama nusia in, tai siat uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesus a man te in thukhamhil te le ulian te ki kaikhop na mun thiampi sang Caiaphas kungah paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Peter in a khuala thithim na pan zui in thiampi sangbel pa leitual dong pai a, a tawp dong en tu in naseam te taw to khawm hi. ");
INSERT INTO csy_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Thiampi lian te, upa te le council te theampo in Jesus that thei tu in leilot tetti te zong uh hi; ");
INSERT INTO csy_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ahihang khat zong a mu bua uh hi, leilot tetti tam mama hongpai napi khat zong a mu bua uh hi. A khakbel ciang leilot tetti ni hongpai a, ");
INSERT INTO csy_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Hisia pa in Pathian biakinn sia pheltam in nithum sung sa kik thei tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Thiampi lianbelpa hong ding a, bangma zo kik ngawl tu ni ziam? Hite tetti te in bangbang in nangma hong langpan ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ahihang Jesus huthe ngawl hi. Thiampi sangbel pa in, nang Christ a kici Pathian Tapa na hile hi ngawl nong son tu in a nungta Pathian min taw kong ngen hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus in, Na ci bang in man hi: ahihang keima in kong ci hi, tu zo mihing Tapa sia vangletna ziatsang ah to in mei tung pan hong tuaksuk na mu tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Tasiaciang in thiampi sangbel in a puan eaukeak a, hisia pa in Pathian min daisak in pau hi, tetti dang bang kul lai ziam? en vun, Pathian min a daisak, na za zo uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Bangbang ngaisun nu ziam? ci a dok ciang in, amate in hisia pa in, thina tu kilawm mawna nei hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tuazawkciang a maitang cilphi uh a, sat cip uh hi; a khut zapheak uh taw beang uh hi, ");
INSERT INTO csy_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kua na hong beang ziam? nang Christ, kamsang bang in hong son tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Peter sia leitual ah a to laitak in, naseam numei khat a kungah hongpai a, nang zong Galilee mi Jesus taw om khawm nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ahihang Peter in, amate theampo mai ah nial a, bang son ni ziam, ci kong he bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tuazawkciang Peter sia innmai kongbiang ah pai a, a dang naseam numei khat in a mu ciang in, tua mun a omte sungah hisia pa zong Nazareth mi Jesus taw om khawm hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Peter in kiciam na kammal taw hisia pa he ngawl khi hi, ci nial leleau hi. ");
INSERT INTO csy_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tuazawk a ngei ngawl in tua mun ah a ding te Peter kungah hongpai a, nang sia hi mite sungah ki hel te khat hi lalawm ni hi; banghangziam cile na paudan taw ki he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tasiaciang Peter in, kiciam in, hisia pa he ngawl khi hi, ci hi. Tasia pociang akkhuang hi. ");
INSERT INTO csy_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jesus in, Ak khuan ma thumvei dong hong nial tu ni hi, a ci sia Peter in phawkkik hi. Taciang a puasang ah pusuak in, nasiatak in kap hi. ");
INSERT INTO csy_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Zingsang hong thet ciang in thiampi lian te le upa te theampo in Jesus that tu in kikum khawm uh hi: ");
INSERT INTO csy_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Amate in a lehhen zawk uh ciang, ngam uk Pontius Pilate kungah paipui in ap uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tuazawkciang in Jesus a leheak pa Judas in, Topa sia thalup tu in maw ki suan hi, ci a mu ciang in, ki sikkik a, dangka sawmthum sia thiampi lian te le upa te kungah puak kik in, ");
INSERT INTO csy_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Mawna nei ngawl pa thisan ka ap thak man in khial khi hi, ci hi. Amate in, ko taw bang kisai ziam? nangma taw kisai bek hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ama in tua dangka sia biakinn sungah lawn a, mundang ah pai in ama le ama ngui awk hi. ");
INSERT INTO csy_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Thiampi lian te in, tua dangka te la a, hi sum sia thisan man a hikom in, biakinn neisa te sungah koi tu kilawm ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Amate kikum khawm uh a, ngamdang mite ki phum natu in bealvawtpa lo lei uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tua ahikom tua lo sia, tu ni dong in thisan lo, kici hi. ");
INSERT INTO csy_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kamsang Jeremiah in a sonkholna ah, Israel mite in a kitat na uh man dangka sawmthum sia amate in la a; ");
INSERT INTO csy_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Topa thupiak na bang in bealvawtpa lo lei hi, a ci thu tangtung hi. ");
INSERT INTO csy_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus sia ngam uk pa mai ah ding a, tua ngam uk pa in, nangma sia Judah Kumpipa ni ziam? ci in dong hi; taciang Jesus in, Na ci bang in hi khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Thiampi lian te le upa te in ama a mawsiat ciang in kamkhat zong zo kik ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tuazawkciang in Pilate in, nangma hong ki mawsiat na tetti theampo za ngawl ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesus in kamkhat zong a zo kik ngawl ciang in: ngam uk pa in lamdangsa mama hi. ");
INSERT INTO csy_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tua poai sungah ngam uk pa in thongtak te sung pan, mipi te dei khat suatak thei hi. ");
INSERT INTO csy_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tua ahikom thongtak te sungah Barabbas a kici a minthang mama khat om hi. ");
INSERT INTO csy_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Tua ahikom mipite hong ki kaikhop ciang, Pilate in amate tung ah, kua na suaktasak nuam uh ziam? Barabbas maw, Christ a kici Jesus? ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Banghangziam cile Pilate in amate in Jesus sia el ahikom hong ap hi, ci he hi. ");
INSERT INTO csy_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilate sia thukhenna tokhum tung a to ciang in, a zi in mikhat sawl a, hi thutangpa tungah bangma vawt heak in, banghangziam cile tuni ka mang sungah ama hang in tampitak thuak khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ahihang thiampi lian te le upa te in mihonpi te sia Barabbas ngen tu le Jesus that tu in hol uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilate in hi ni te sung pan a kua suatak tu dei nu ziam? ci in a dok ciang, amate in Barabbas suatak tu dei khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tua a hile Christ a kici Jesus sia banglaw tu khi ziam? ci in Pilate in a dok ciang in, amate theampo in, thinglamte tungah khaina thuak tahen, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Taciang ngam uk pa in, banghangziam, bang khialna vawt ziam? a ci ciang in, amate in thinglamte tungah ki khai tahen, ci in au seseam uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilate in zo nawn ngawl khi hi, mipi te ngamlum siat hi, ci a mu ciang, tui la in, a khut sil a, hi a thutang pa thisan pan ka thiang hi: no ma khensat tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tasiaciang in mi theampo in, hi sia pa i thisan koma le ka tate tungah om tahen, ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Taciang Pilate in Barabbas suatak a: Jesus sia a sat zawkciang thinglamte tungah khai tu in ap hi. ");
INSERT INTO csy_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tuazawkciang Pilate ngalkap te in Jesus sia ngam uk pa inn ah paipui uh a, ngalkap hon bup ama kim ah kikhawm hi. ");
INSERT INTO csy_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Amate in a puan te sutkeak in, puan sannum silsak uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Amate in lingtaw a ki pheak ling lukhu a lu tungah khusak uh a, a ziatsang khut ah phai kung khat toaisak uh hi: taciang a mai ah khupdin in, Judah te kumpipa! na khansau tahen, ci in selno uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Amate in ama tungah cilphi uh a, a phaikung la in a lu pan vel uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tabang in a selno uh zawkciang a puan tual hawksak kik in, ama puan sil sakkik uh hi, tua zawkciang thinglamte tungah khen tu in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tabang in a paipui uh laitak, Simon a kici, Cyrene khuami khat mu uh a: thinglamte zawthawk thu taw puasak uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Amate in Golgotha a kici lu ngu mual a thet uh ciang in, ");
INSERT INTO csy_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jesus sia sapittui le a kha a kihel pia uh hi: ama in tep bek a, dawn nuam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jesus sia thinglamte tungah khai uh a, a puan te a khen zawk uh ciang in, aisan nataw hawm uh hi: tua thu sia kamsangpa sonkholna, amate in ka puan te aisan in hawm uh hi, ci thu a tangtunna a hihi. ");
INSERT INTO csy_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tuazawkciang tua mun ah to in ama encik uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A lu tung san ah mawsiatna lai, HI SIA JUDAH TE KUMPIPA JESUS HI ci in at uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ama taw nguta ni te zong a ziatsang ah khat, a veisang zong ah a dang khat, thinglamte tungah khai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Lampi ah a vak te in zong nu nau in, a lu thin uh a; ");
INSERT INTO csy_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Biakinn pheltham in nithum sung a sakik tu pa, nangma le nangma ki hun in. Pathian Tapa na hile, thinglamte tung pan tuaksuk in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tasia bangma in thiampi lian te, thukhamhil te le, upa te zong in nu nau in, ");
INSERT INTO csy_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ama in ngualdang ngum thei a, ama le ama ki ngum thei ngawl hi. Ama sia Israel te kumpipa a hile thinglamte tung pan tu mama in tuak hen a, tasiaciang in ka um tu uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ama in Pathian muang a; keima sia Pathian Tapa khi hi, ci a hi ciang, tu mama in Pathian in suaktasak hen: ci in nu nau tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ama taw thinglamte tungah a ki khai nguta te zong in, tabangma in nu nau uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sun nai sawmleni pan nitak sang nai thum dong leitung theampo khuazing hi. ");
INSERT INTO csy_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nai thum kim ciang in, Jesus a nging tatak in, Eli, Eli, Lama sabachthani? ci in au hi, a khiakna sia, Ka Pathian, Ka Pathian, banghang in hong taisan ni ziam? a cinopna hi. ");
INSERT INTO csy_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tua mun ah a ding te pawlkhat in a zak uh ciang in, Elijah sam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Tasia pociang amate sung pan khat tai a, tuihup puan la in, sapittui hau sungah a papsuk zawkciang, phaikung dawn ah hen in, Jesus dawn tu in pia hi. ");
INSERT INTO csy_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","A dang te in, ngak hi vun, Elijah ama hun tu in hongpai tha tu hi, ci en tawng, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesus ngingtak in au kik in thi hi. ");
INSERT INTO csy_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Taciang in, en vun, biakinn sung sang kidalna puan sia a lu pan a taw dong khen ni in ki khen suk hi; zin zong ling in, suangtum te zong kektham a, ");
INSERT INTO csy_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Thankul te ki hong in; a thisa mithiangtho tampi te thokik hi, ");
INSERT INTO csy_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Amate than sung pan pusuak uh a, Jesus thawkik zawkciang in, khuapi thiangtho sungah pai uh a, mi tampi te kungah kilang uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ngalkap zakhat uk pa le a kungah omte in Jesus en in, zinling le thupiang dang te a mu uh ciang in, lau mama uh a, hisia pa Pathian Tapa tatak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Galilee pan Jesus a zui te le a khoi numei tampi te in, a khuala na pan en tek uh hi: ");
INSERT INTO csy_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Tua numei te sungah Mary Magdalene, James le Joses te nu Mary le Zebedee zi zong ki hel hi. ");
INSERT INTO csy_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nitak sang ciang in, Arimathea khua pan mihau pa khat hongpai hi, a min sia Joseph kici a, Jesus nungzui khat a hihi: ");
INSERT INTO csy_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ama Pilate kungah pai a, Jesus luanghawm ngen hi. Tasiaciang Pilate in Jesus luanghawm piak tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Taciang Joseph in Jesus luanghawm a lak zawkciang, puanneam thiang taw tun in, ");
INSERT INTO csy_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ama atu in a taw suang hawng thankul sungah vui hi: than kongkha ah suangtum lian mama khat lik in a kha zawkciang pai hi. ");
INSERT INTO csy_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdalene le a dang Mary te sia tua mun ah thankul sang nga in to uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ki ngin ni a zingciang in, thiampi lian te le Pharisee te Pilate kungah hongpai uh a, ");
INSERT INTO csy_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Topa awng, tua leilot thu son pa in a nuntak lai in, nithum zawkciang thokik tu khi hi, a ci sia phawkkik khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A nungzui te zan ciang hongpai in a luanghawm ngu a, thina pan thokik zo hi: ci in midang te tungah son a hile, a nungsang thu sia a masa sang in poimaw zaw tu hi, tua ahiciang a than sia nithum dong cing tu in thupia in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilate in amate tung ah, a cing tu nei nu hi: pai tavun a, na hitheitawp in vawt vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tua ahikom amate zong than ah pai in, thankul kha na suangpheak tungah ceptena khen in, a cing te koi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabbath ni bo in nipi khat sung ni masabel khuavak tu hong kipat ciang in, Mary Magdalene le a dang Mary te than en tu in pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tua laitak in nasiatak in zinling hi: banghangziam cile Topa vantungmi van pan hong tuaksuk in, than kongkha suangtum sia lik a, a tungah to hi. ");
INSERT INTO csy_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","A mai sia khualeng bang hi a, a puan vukbang in pak hi: ");
INSERT INTO csy_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Taciang than cing te lau in ling uh a, mithi bang hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Vantungmi in numei te kungah, lau heak vun: banghangziam cile, thinglamte tungah a ki khai Jesus zong nu hi, ci kong he hi. ");
INSERT INTO csy_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ama ziak ah om ngawl hi: banghangziam cile, a sonsa bang in thokik zo hi. Hongpai tavun a, a ki sial na en vun. ");
INSERT INTO csy_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Taciang manlang in pai tavun a, thina pan thokik zo hi, ci in a nungzui te son vun; en vun, ama note mai Galilee ah pai hi; tuak ah mu tu nu hi: en vun, hong son zo khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amate than pan in launa le lungdamna lianpi taw ciakik uh a; a nungzui te son tu in tai uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A nungzui te son tu in a tai uh laitak in, en vun, Jesus a mate kung hongpai a, Note tungah nopna om tahen, ci hi. Taciang amate Jesus peang ah hongpai in, a peang len in bia uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tuazawkciang Jesus in amate tung ah, Lau heak vun, ka suapui te Galilee ah pai tu in son vun a, tuaksung ah hong mu tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amate a pai zawkciang in than cing pawlkhat te khuapi sungah pai uh a, thiampi lian te kungah thupiang teng theampo son uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ama te upa te taw ki kaikhawm in, thu a kikup zawk uh ciang in, ngalkap te sum tampi pia uh a, ");
INSERT INTO csy_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","A nungzui te zan in hongpai uh a, ka mut uh lan in a luang ngu uh hi, ci vun. ");
INSERT INTO csy_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hi thu te ngam uk pa i nakheng ah a theng zong in, na suatak thei natu uh, koma in hong sonsak tu khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tua ahikom amate in sum la in, a son uh bang in vawt uh hi: taciang tua thu sia Judah mite in tuni dong in mun theampo ah hil uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A nung zui sawm le khat te Galilee ah pai uh a, Jesus in a ciamsa mun mualtung ah ka to uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Amate in Jesus a mu uh ciang bia tek uh hi: ahihang pawlkhat te in muang ngam ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus hongpai a, amate tung ah, Van le lei thuneina theampo hongpia siat zo hi. ");
INSERT INTO csy_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tua a hiciang note pai tavun a, minam theampo te hil tavun, Pa, Tapa le Tha Thiangtho min taw tuiphumna pia tavun: ");
INSERT INTO csy_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Keima i kong thupiak teng theampo a vekpi zui tu in hil tavun: taciang en vun, leitung bo dong in a tawntung keima in kong ompui hi, ci hi. Amen. ");
INSERT INTO csy_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pathian Tapa Jesus Christ lungdamna thu a kipatna in; ");
INSERT INTO csy_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kamsang te in a sonkholsa bangma in, en vun, na pai natu lampi a pua tu in, ka kamtaipa na mai ah sawl khi hi. ");
INSERT INTO csy_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Senneal ngam sungah a au aw khat in, Topa lampi puakhol vun a, tangsak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","John in senneal ngam ah tuiphumna pia a, mawmaisakna tu in ki sikkik na tuiphumna thu tangko hi. ");
INSERT INTO csy_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jerusalem le Judah ngam theampo pan in mi tampi te John kungah hongpai uh a, amate mawna te pualak in Jordan ngun ah tui ki phum tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","John sia kala-uk mul taw a ki tak puan sil a, a kawng sia savun kawngkhau taw kil hi; khaumaw le khuaitui te ne hi; ");
INSERT INTO csy_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ka nung pan hongpai pa sia kei sang in thahat zaw a, kei ka hile kun in a peangdap khau sutsak tu in zong ka kiphu bua hi: ");
INSERT INTO csy_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Keima in tui taw tuiphumna kong pia hi: ahizong Ama in Tha Thiangtho taw tuiphumna hong pia tu hi, ci in pualak hi. ");
INSERT INTO csy_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tuazawkciang in, Jesus sia Galilee ngam Nazareth pan hongpai in, John in Jordan ngun ah tuiphumna pia hi. ");
INSERT INTO csy_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesus tuisung pan a thawto pociang, van hong ki hong in, Thaa sia vakhu bang in a tungah hong tuaksuk John in mu hi: ");
INSERT INTO csy_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Van pan in aw khat hong nging a, Nangma sia ka it ka Tapa na hihi, Na tungah ka lungkim mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tuazawk pociang in, Thaa in Jesus sia senneal ngam ah paisak hi. ");
INSERT INTO csy_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tua senneal ngam ah ni sawm li om a, Satan in ze-et hi; senneal ngam sung ngamsa te taw omkhawm a; vantung mite in khoi hi. ");
INSERT INTO csy_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John thong a tak zawkciang in Jesus Galilee ah pai a, Pathian kumpingam lungdamna thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A hun hong cing zo a, Pathian kumpingam hong nai zo hi, na mawna uh kisik vun a, lungdamna thu um vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesus Galilee tuili hui ah a pai laitak in Simon le a suapuipa Andrew sia tuili sungah ngenpai in a om laitak mu hi: ");
INSERT INTO csy_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus in amate tung ah, Ka nung hong zui tavun, mihing man te kong suaksak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Taciang amate in thakhatthu in a ngen te nusia in, a nungzui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","A khuala hiat na mun a thet uh ciang in Zebedee tapa James le John te u nau ngunkuang sungah ngen a phaw uh laitak mu hi. ");
INSERT INTO csy_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesus in a mu pociang in sam a; amate zong ngunkuang sungah a pa Zebedee le a naseam te nusia in a nung zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Amate Capernaum khua ah pai uh a; sabbath ni hong thet pociang synagogue sungah tum in, thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Amate in a hil na lamdangsa tek uh hi: banghangziam cile thukhamhil te bang in hil ngawl in, thunei te khat bang in hil hi. ");
INSERT INTO csy_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Amate synagogue sungah doai ngilo vei pasal khat om a, ");
INSERT INTO csy_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Nang Nazareth mi Jesus, hong om nginge sak po tan; nang taw bang sep tu nei khu ziam? hong susia tu in hongpai hi ngawl ni ziam? Nangma in Pathian mithiangtho ni hi, ci hong he khi hi, ci au hi. ");
INSERT INTO csy_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Tasiaciang Jesus in ama tei a, Om nginge po in a, hisia pa sung pan pusuak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Doai ngilo in tuapa huangsak vadil a, a nging tatak a au zawkciang, a sung pan pusuak hi. ");
INSERT INTO csy_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Amate theampo in lamdangsa mama uh a, hisia in bangbang hithong ziam? hibang te koibang hil na thak ziam? banghangziam cile thuneina taw thupia in, doai ngilo te nangawn in a thuni hi, ci in amate sungah ki dong tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Taciang a min sia Galilee ngam kimkot teng theampo ah manlangtak in thang hi. ");
INSERT INTO csy_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Amate synagogue sung pan a pusua zawk uh ciang in, James le John te taw Simon le Andrew te innsung ah tumsuak pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ahihang Simon zi i a nu sia a cisa in lum hi, ci manlang tak in son uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Taciang Jesus hongpai a, a ban pan len in kaito hi; tasia pociang in a cisa thai a, amate leangna do hi. ");
INSERT INTO csy_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nitak sang ni tum ciang in, cina te le doai te a kungah puak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tua khuapi sung mihing theampo a kongbiang ah hong ki kaikhawm siat uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus in natna namcin a thuak te damsak a, doai tam mama hawlkhia hi; Jesus in doai te pausak ngawl hi, banghangziam cile amate in Jesus he uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A zingciang khuavak ma in Jesus tho a, khuapua sangah pusuak in kuama om ngawl na mun ah thungen hi. ");
INSERT INTO csy_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon le a lawmte in ama zui tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Amate in a mu uh ciang in, a kungah, mi theampo in hong zong uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesus in, Khuapi dang te ah zong pai tawng, tuak sungah thuhil tu khi hi: banghangziam cile thuhil tu in hongpai ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilee ngam mun tatuam synagogue te ah thuhil a, doai te zong hawlkhia hi. ");
INSERT INTO csy_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Miphak khat ama kungah hongpai a, khupdin in, Topa uk hi po le te keima hong thiangsak thei ni hi, ci in thum hi. ");
INSERT INTO csy_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesus in tuapa tungah hesuakna nei in, a khut tham a, Uk khi hi; thiang tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jesus in a ci zawkpociang in, a phak natna bo vingveng a, ama thiang hi. ");
INSERT INTO csy_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesus in ama phatak in thu a vaithak zawkciang, paisak hi; ");
INSERT INTO csy_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ama kungah, Kuama son heak in: ahizong thiampi te kungah pai tan a, nangma le nangma ki lak in, amate tungah tetti na lak natu in Moses thupiak biakpiakna pia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ahihang tua pa pai in, mun theampo ah a pualak kakoai hu in, Jesus khuapi sungah a kilang in tum thei ngawl a, khua pua sang duisung ah om hi: taciang mun theampo pan in a kungah hongpai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tuazawk ni tam ki hal ngawl in Jesus Capernaum khua ah hong theng kik a; inn ah om hi, ci thu hong kison hi. ");
INSERT INTO csy_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tasia pociang in mihing tam mama hong theng tek uh a, innsung ah a awng na munkhat mama zong om ngawl in, kongkha hui a puasang dong in dimteak uh hi: tua mun ah Jesus in amate thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tualaitak in mihing li in pumzawpa khat zawng khawm uh a, hong paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mihing tamlei ahikom in Jesus kung dong pai thei ngawl hi, tua ahikom Jesus om na tungsan pan inn khuvum sulet uh a: pumzawpa a lupna taw khiasuk uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesus in amate upna uh a mu ciang, pumzawpa kungah, Ka tapa awng, na mawna te hong ki maisak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ahihang tua mun ah thukhamhil te pawlkhat tokhawm uh a, amate thinsung uh ah, ");
INSERT INTO csy_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Banghang in hisia pa in Pathian mindaisak in pau ziam? Pathian bek in mawna maisak thei hi ngawl ziam? ci in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Thakhatthu in Jesus in amate ngaisutna a thaa taw he a, Banghang in na thinsung uh ah hi thu te ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Hi pumzawpa kungah, na mawna te hong ki maisak zo hi; ci le, tho in a, na lupna zial in, pai in, ci tu koisia ol zaw ziam? ");
INSERT INTO csy_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ahihang, mihing Tapa in leitung ah mawna te maisak thei na vangletna nei hi, ci na tel thei natu uh in, (pumzawpa kungah), ");
INSERT INTO csy_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nangma tungah kong ci hi, tho in a, na lupna zial in, pai in a, cia in, hong ci khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tasia pociang thakhatthu in tho a, a lupna la in mi theampo i mai ah pai hi; amate theampo in lamdangsa mama uh a, hibang thu i mu ngei bua hi, ci in Pathian minthang pok uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesus tuili hui ah pai kik hi; taciang mihonpi te a kungah hongpai uh a, amate thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Lampi ah a pai uh laitak in Alphaeus i tapa Levi sia shia ki dong na mun innsung ah a to mu a, Hong zui tan, ci hi. Tasia ciang ama zong ding in, Jesus nungzui hi. ");
INSERT INTO csy_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tuazawkciang in, Jesus Levi innsung anneakna mun ah to hi, siadong te le mawnei tampi te zong Jesus le a nungzui te taw to khawmtek uh hi: banghangziam cile mitampi in a nung pan zui hi. ");
INSERT INTO csy_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Taciang siadong te le mawnei te taw an a neak khop uh, thukhamhil te le Pharisee te in a mu uh ciang in, a nungzui te kungah, bangbang in siadong te le mawnei te taw annekhawm ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tua thu Jesus in a zakciang in amate tung ah, A cidam te in syavuan kul ngawl hi, ahihang cina te in kul hi: mipha te sam tu in hongpai ngawl khi hi, mawnei te ki sikkiksak tu in hongpai khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","John le Pharisee te zungzui te antang tawntung uh hi: amate Jesus kungah hongpai uh a, John le Pharisee te i nungzui te antang uh hi, banghang in na nungzui te tang ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus in amate kungah, Zineipa sia a lawmte taw a om laitak in amate antang thei tu ziam? zineipa om sung theampo antang thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ahihang amate kung pan zineipa a ki lak ni hong theng tu a, tasiaciang antang kik lai tu hi. ");
INSERT INTO csy_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Puan lui sia puan thak taw kuama in phaw ngei ngawl hi: tabang in phaw le tua a phawna puan thak in puan lui sia kaikin tu a, a ek zai seseam tu hi. ");
INSERT INTO csy_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tasia bangma in savun um lui sungah kuama in sapittui thak thun ngei ngawl hi: a thun le savun um tamtham tu a, sapittui bua siat in, savun um zong laltham tu hi: ahihang sapittui thak sia savun um thak sungah a thun hamtang tu uh a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tuazawkciang in, Jesus sabbath ni khat lo sung kantan in pai a; a nungzui te a ngilkial ahikom, zungtang hui te hiat in ne uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ahihang Pharisee te in a mu uh ciang, Jesus kungah, en in, na nungzui te in sabbath ngeina a hi ngawl te banghang seam uh ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesus in amate tung ah, David le a lawmte a ngilkial uh a, kisap na a nei ciang in, bang vawt ci thu simngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Thiampi sangbel Abiathar hun lai in Pathian innsung ah bangbang tum in, thiampi te bek i a neak thei, Pathian mai ah a ki lui anluum te ne in, a lawmte zong pia hi ngawl ziam? amate neak tu a kilawm ngawl, thiampi te bek i a neak thei tu in Pathian mai ah a ki lui anluum te ne uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tasiaciang Jesus in amate tung ah, Sabbath sia mihing te atu a kivawt hi a, mihing sia sabbath atu in a ki vawt hi ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tua ahikom mihing Tapa sia sabbath i tungah Topa a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesus synagogue sungah tumkik a; tuaksung ah khut langzaw khat om hi. ");
INSERT INTO csy_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ama maw zong nuam te in sabbath ni in damsak maw, damsak ngawl; ci encik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesus in tua khut langzaw pa tung ah, A maisang ah hong ding tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Taciang Jesus in amate tung ah, Sabbath ni in a pha sep tu kilawm ziam maw, a hibale a phangawl sep tu kilawm ziam? ngual nuntakna ngum tu maw, that tuh?, ci hi. Ahihang amate a huthe bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesus in a kimkot teng thin-uk kawm in en a, amate thinpui uh hu in khuangai a, tua pa kungah, Na khut phal in, ci hi. Tasiaciang ama in a khut phal a: tua a khut sia a langkhat bangma in dam kik hi. ");
INSERT INTO csy_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tasia pociang, Pharisee te pai in Herod mihing te taw Jesus suksiat thei natu thu kikum pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ahihang Jesus a nungzui te taw tuili sangah pai uh a: a zui mihon tampi te sia, Galilee le Judah, ");
INSERT INTO csy_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea le Jordan ngunngal; Tyre le Sidon kim teng pan hongpai te a hi uh hi. Tua mihon tampi te sia Jesus i na lianpi a vawt te a zak uh ciang in, a kungah hongpai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Mihonpi te in phulcip tha tu a hi ciang in ngunkuang no khat taw ngak khol tu in a nungzui te sawl hi. ");
INSERT INTO csy_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Banghangziam cile mi tam mama damsak zo a; natna a thuak te theampo in ama tham tu in kitu ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Doai ngilo te in Ama a mu uh ciang in, a mai ah bok uh a, nang sia Pathian Tapa ni hi, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesus in amate tung ah, Ama thu kuama hesak ngawl tu in nasiatak in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesus mualtung ah kato hi, taciang Ama i dei te teal a: tua te a kungah hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Mihing sawmleni te sia ama kungah om tu in ahizong, thuhil tu in paisak tu ahizong, nasep pia in, ");
INSERT INTO csy_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Natna te damsak tu in ahizong, doai te hawlkhiat zawk na vangletna nei tu in ahizong: ");
INSERT INTO csy_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Peter kici Simon; ");
INSERT INTO csy_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedee tapa James le John; amate sia Boanerges ci in min kivaw a, a khiakna sia vanto tate, cinopna a hihi: ");
INSERT INTO csy_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, Alphaeus tapa James, Thaddaeus, Canaan mi Simon, ");
INSERT INTO csy_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Jesus leheakpa Judas Iscariot te a hi uh hi: Taciang amate innsung ah tum tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Taciang mihonpi te hongpai kik uh hi, tua ahikom amate anneak hun zong a nei bua hi. ");
INSERT INTO csy_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tua thu a mealheak te in a zak uh ciang in, Jesus sia a thin-am zo hi, a ci uh hu in Ama pui tu in pai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jerusalem pan hongpai thukhamhil te in, Jesus sungah Beelzabub om hi, doai ngilo le topa vang taw in doai te hawlkhia hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Taciang Jesus in amate a kungah sam in, sontena te taw thu son a, Bangbang in Satan in Satan hawlkhia thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kumpingam khat kikhen in kido a hile, tua kumpingam sia kho ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Inn khat sia kikhen in kido a hile, tua inn kho ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tasia bangma in Satan zong ama le ama kikhen in a kido le, kho ngawl tu a, bo in mangthang tu hi. ");
INSERT INTO csy_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Kuama in mihing thahatpa hencip masa ngawl in, a innsung ah tum in a neisa te sut thei ngawl tu hi, mihing thahatpa a hencip zawkciang bek in; a innsung van te sut thei tu hi. ");
INSERT INTO csy_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A tatak ka ci ciang, mihing te mawna namcin le sonsiatna te kimaisak tu hi: ");
INSERT INTO csy_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ahihang Tha Thiangtho a sonsiate, bangmahun in ki maisak ngei ngawl tu hi, banghangziam cile tawntung thukhenna dan thuak tu kilawm hi: ci hi. ");
INSERT INTO csy_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Amate in Jesus sungah tha-nin om hi, a ci uh hu in Jesus in hibang in a pau a hihi. ");
INSERT INTO csy_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tuazawkciang Jesus nu le a nau te hongpai a, a puasang ah ding in, mikhat Jesus kungah sawl in sam hi. ");
INSERT INTO csy_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A kim a mihonpi te to a, a kungah, en in, na nu le na nau te nangma zong in a puasang ah om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesus in, Ka nu, a hibale, ka suapui te kua te ziam? ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Taciang a kim a pam a to te en in, En vun, ka nu le ka suapui te! ");
INSERT INTO csy_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Banghangziam cile a kuamapo Pathian deina a seam peuma sia, ka suapui le ka nu a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesus tuili hui ah thuhil kipan kik hi: a kungah mihon tampi te hong ki kaikhop ciang in tuili sung ngunkuang sungah tuak in to a; mihonpi te sia tuili hui ah om uh hi. ");
INSERT INTO csy_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tasiaciang sontena te zang in thuhil a, ");
INSERT INTO csy_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ngai vun a; en vun, thaici poaipa khat thaici poai tu in pai hi: ");
INSERT INTO csy_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tabang a poai ciang in, thaici pawlkhat te lampi ah tak a, tungleang te hongpai in ne siat hi. ");
INSERT INTO csy_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pawlkhat te suang tam na mun ah tak a, lei tawm a hi man in thaici te hong po pai hi, banghangziam cile lei thuk ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ni hong sua ciang in, nisa in kang a; zung tha ngawl ahikom ngawtak hi. ");
INSERT INTO csy_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pawlkhat te lingphung sungah tak a, lingkung te a khan ciang in deapcip in, nga zo ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","A dang te lei pha na tungah tak hi, taciang po in hong khang a, a nga hong nga hi; pawlkhat te a se sawmthum, pawlkhat te a se sawmluk, pawlkhat te a se zakhat dong in khang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Taciang Jesus in amate tung ah, Zak natu bil a nei peuma in za tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ama nguak a om laitak in, a nungzui sawmleni te taw a omte in sontena thu dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesus in amate tung ah, Pathian kumpingam thuku heak theina hong pia zo hi: ahihang a puasang a omte tung ah, tua thu te theampo sia sontena te taw son hi: ");
INSERT INTO csy_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Amate in mu tu hi napi, a he bua tu uh hi; ngai tu hi napi, a tel thei bua tu uh hi; tabang hi bua le hun khatpo ah amate ki kheal in, amate i mawna ki maisak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus in amate tung ah, Hi sontena te he ngawl nu ziam? taciang sontena theampo bangbang in tel thei tu nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Thaici poaipa in Pathian kammal poai hi. ");
INSERT INTO csy_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lampi ah a tak thaici te thu sia hibang te a hihi, amate in Pathian kammal a zak uh ciang in Satan manlang tak in hongpai a, amate thinsung pan Pathian kammal te laksak hi. ");
INSERT INTO csy_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Suang tam na mun ah a tak thaici te sia hibang te a hihi; amate sia Pathian kammal a zak uh ciang in thakhatthu in lungdamna taw sang hi napi; ");
INSERT INTO csy_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amate sungah zungtha ngawl ahikom, tawmvei sung bek khom hi: Pathian thu hang in haksatna le vawtsiatna a thet ciang in, thakhathu in pukkik hi. ");
INSERT INTO csy_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lingsung a tak thaici te thu sia hibang te a hihi, Pathian kammal za napi, ");
INSERT INTO csy_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Hi leitung thinngimna, hauna i theamna, nadang tampi te lungngul nate tum in Pathian thu sia deapcip ahikom, a nga toai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Lei pha na a tak thaici te thu sia hibang a hihi; Pathian thu za in sang a, pawlkhat te a se sawmthum, pawlkhat te a se sawmluk, pawlkhat te a se zakhat in a nga hong toai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesus in amate tung ah, Khuaimei sia khum nuai ah, a hibale, lupna nuai ah koi tu in ki keng ngei ziam? meivak na tungah a ki koi tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Banghangziam cile a ki lang ngawl tu in phualcip thei bangma a om ngawl bangma; pualak ngawl tu thuku zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Zak natu bil nei theampo in za tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesus in amate tung ah, Na zak thu uh kidawm vun: ngualdang na te uh bangma in noma zong hong ki tekik tu hi: taciang a za te a tamzaw hong ki piakik tu hi. ");
INSERT INTO csy_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Banghangziam cile a nei te ki pia thua tu a: a nei ngawl te a neisun ki laksak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus in, Pathian kumpingam sia, mikhat in a lo ah thaici poai tu hi; ");
INSERT INTO csy_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Taciang mu in, le tho in, sun le zan in thaici bangbang in po tu le bangbang in khang tu ci a he ngawl thaici poaipa taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Banghangziam cile leitang in ama thu in ngasak a; a masabel in a te meangsak hi, tua zawkciang vui a, a vui zawkciang a tang hong suak hi. ");
INSERT INTO csy_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ahihang anlak hun hong thet ciang in, ama in phiau taw manlangtak in at hi, banghangziam cile anlak hun cing zo hi, ");
INSERT INTO csy_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesus in, Kumpingam sia bangtaw sonte tu khi ziam? a hibale bangtaw tekak tu khi ziam? ");
INSERT INTO csy_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hisia in ankam cii taw kibang hi, lei ah a poai ciang in thaici dang theampo sang in no zaw hi: ");
INSERT INTO csy_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ahihang a poai zawkciang in hong khang a, an te theampo sung pan a lianbel hong suak hi, van a vacim te a lim ah tawlnga thei zadong in a bak te nei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Amate i zak thei tuh in sontena tampi taw thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sontena kihel ngawl in amate tungah thuhil ngawl hi: taciang amate bek a om uh ciang in a nungzui te kungah tua thu te son thiang hi. ");
INSERT INTO csy_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tua ni nitak sang in, Jesus in a nungzui te kungah, Ngalkhat ah pai tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Amate in mihonpi te a paisak zawk uh ciang in, Ama sia nungzui te in ngunkuang taw paipui hi. Tua mun ah a dang ngunkuang no te zong om hi. ");
INSERT INTO csy_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tasiaciang huipi suangval nasiatak in hong tho a, tuihual te in ngunkuang sia nuaicip ahikom, ngunkuang sungah tui hong dim hi. ");
INSERT INTO csy_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus sia ngunkuang nungsang kham in mu hi: amate in phong uh a, Syapa awng, ka thisiat tu uh phamaw hong sa ngawl ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesus hong tho in, huipi tei hi, taciang tuipi tung ah, Thim in, ci hi. Taciang hui thim in, dai dide hi. ");
INSERT INTO csy_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesus in nungzui te kungah, Banghang in hibang lalawm in lau nu ziam? bangbang lalawm in upna nei ngawl nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Amate lau mama uh a, hisia pa sia bangbang mihing ziam, hui le tuipi in a thuni hi? ci in khat le khat kici uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Amate tuili ngalkhat Gadarenes ngam theng uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus ngunkuang sung pan a pusua pociang, than pan in hongpai doai vei khat taw kisi hi, ");
INSERT INTO csy_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ama than ah om a; kuama in hen thei ngawl hi, thikkol taw nangawn in khit thei ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Banghangziam cile thikkol le saikhau taw tu le tu khit uh hi kale, saikhau te bot tan in, thikkol te santham hi: kuama in zualsak zo ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sun le zan in, mual tung tatuam le than ah om a, au tawntung in, ama le ama suang taw ki kui hi. ");
INSERT INTO csy_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ahihang a khuala mama na pan Jesus a mu ciang, hong tai in bia hi, ");
INSERT INTO csy_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Taciang a nging tak in au a, Jesus awng, nang, a sangbel Pathian Tapa, nang taw bang kisai na nei khi ziam? Nong vawtsiat ngawl natu in Pathian min taw hong ngen khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Banghangziam cile Jesus in ama tung ah, Nang doai ngilo, hisia pa sung pan in pusuak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesus in, Na min kua ziam? ci in dong hi. Tua pa in, ka min sia Legion hi, banghangziam cile ka tam mama uh hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ama in tua ngam pan hawlkhia ngawl tu in thum hi. ");
INSERT INTO csy_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mual te taw a ki nai na mun ah vokhon tampi anne keukho hi. ");
INSERT INTO csy_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Doai ngilo te theampo in, vok sungah tum tu in hong sawl tan, ci ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tasia pociang Jesus in paisak hi. Doai ngilo te pusuak a, vokhon sungah tum uh hi: taciang vokhon te liang pan in manlang tak in tai uh a, tuili sungah tuita in thi siat hi. Tua vok te tul ni kiim pha uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Vokcing te tai in, khuapi le ngam sungah son hi. Mipi te tabang thu piang te en tu in hongpai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Amate Jesus kungah hongpai uh a, legion a kici doai ngilo vei pa sia puansil in, a thin ciim in a to mu uh hi: amate lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tua thu a mu te in doai ngilo vei pa le vokhon tungah thu piang te ngualdang tungah son uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tasiaciang amate in Jesus sia amate ngam pan pusuak tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesus ngunkuang sung a tum ciang in, doai ngilo vei ngei pa in, Ama taw kikop tu in ngen hi. ");
INSERT INTO csy_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ahihang Jesus in zuisak ngawl a, ama kungah, Na inn ah cia tan a, na lawmte kungah, Topa in nangma atu hong vawtsak te bangza in lian ci le, na tungah hesuakna a nei nate son in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tua pa zong pai in, Decapolis ngam sung theampo ah Jesus in ama atu a vawtsak nate bangza in lian ziam, ci thu te tangko hi: a za theampo in lamdangsa uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesus sia ngunkuang taw ngalkhat ah paikik a, mi tampi te a kungah hong ki kaikhawm hi: Ama sia tuili nai na ah om hi. ");
INSERT INTO csy_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Taciang, en vun, Jairus a kici synagogue lampui khat Jesus kungah hongpai a; a mu ciang in a peang ah bok in, ");
INSERT INTO csy_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ka tanu a thi dektak in lum hi: hongpai tan a tungah na khut nga tu in hong ngen khi hi, tasiaciang ama dam tu a; nungta tu hi, ci in nasiatak in thum hi. ");
INSERT INTO csy_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Taciang Jesus ama taw pai hi; mi tampi in zui uh a, a kiim a pam pan phul ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Taciang kum sawm le kum ni sung thisuak numei khat, ");
INSERT INTO csy_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Syavuan tam mama kungah ki lak zo a, a neisa theampo zang siat zo hi kale, dam tuan ngawl bekdom ngawl in lawmawk seseam hi, ");
INSERT INTO csy_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesus thu a zak ciang in, mihon sungah a nung pan pai in, a puan tham hi. ");
INSERT INTO csy_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Banghangziam cile, a puan thamtha po leng dam tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Thakhatthu in a thi suak kang a; tua natna pan dam khi hi, ci phawk hi. ");
INSERT INTO csy_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus in, a sung pan vangletna pusuak hi, ci he lian ahikom, mihonpi sangah kiheak in, A kua in ka puan hong tham nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A nungzui te in, mihonpi in hong phul ngawp mu nginge napi, banghang in, kua na tham nu ziam ci ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesus in a puan tham sia nu mu nuam in a kiim teng en hi. ");
INSERT INTO csy_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ahihang numei nu in a sungah thu piang he ahikom, lau le ling kawm in, Jesus mai ah pai in bok a, thu piang theampo a man in son hi. ");
INSERT INTO csy_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesus in a kungah, Ka ta nu awng, na upna in hong damsak zo hi; thinnuam in pai tan a, vawtsiat na pan in suakta ta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus a pau laitak in, synagogue lampui pa inn pan in hongpai te in, na tanu thi zo hi: banghang in syapa nawngkaisak lai ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tua thu Jesus in a zak pociang, synagogue lampui pa kungah, Lau heak in, um bek po in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesus in, Peter, James le a suapui pa John simngawl kuama zuisak ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jesus synagogue lampui pa inn a thet ciang in, nasiatak in kap le tau in ngamlum lialua mu hi. ");
INSERT INTO csy_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Amate kungah hong sungtan ciang in, Banghang in ngamlum lialua in kap nu ziam? numeino sia a thi hi ngawl hi, a mu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Amate in Jesus selno in nuisan uh hi. Ahihang amate a vekpi a puasang ah pusuaksak siat a, numeino i a nu le pa le a paipui teng bek sam in, numeino nu lupna mun inndoi sungah tum tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Taciang Jesus in numeino a khut pan len a, Talitha kumi, ci hi; a khiakna sia, numeino, tho in kong ci hi, a cinopna hi. ");
INSERT INTO csy_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Taciang numeino sia thakhatthu in hong tho a, lampai hi; ama sia kum sawmleni kiim hi. Amate in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesus in, hi thu te kuama hesak heak vun, ci in nasiatak in vaitha hi; tua nu i neak tu khatpo a piak natu in thu pia hi. ");
INSERT INTO csy_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesus tua mun pan in pai a, Ama khua ah theng hi; a nungzui te in zui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabbath ni a thet ciang in, synagogue sungah thuhil kipan hi: a za mi tampi te in lamdangsa in, hi thu te koisung pan in nga ziam? ama tungah a ki pia pilna sia bang pilna ziam, bangbang in vanglian nasep te a khut taw seam thei ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ama sia Mary tapa, James, Joses, Judah le Simon te suapuipa, lettama pa hi ngawl ziam? a suapui numei te zong ziak ma ah om hi ngawl ziam? ci in, a sang thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ahihang Jesus in amate tung ah, Kamsang khat sia ama khua, mealheak suapui le, ama inn simngawl mundang ah ki upat hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tua mun ah cina tawm te tungah a khut nga in a damsak simngawl, a vanglian nasep dang bangma seam thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Amate up ngawl na hang in Jesus in lamdangsa hi. Taciang ama a kiim a pam khuapi te ah pai in thuhil hi. ");
INSERT INTO csy_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A nungzui sawmleni te a kungah sam a, ni tek in sawl hi; doai ngilo te zo tu in vangletna pia hi; ");
INSERT INTO csy_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A khualhaw na mun uh ah ciangkhut bek keng tu a; thung, anluum le sumbawm sungah sum te keng ngawl in: ");
INSERT INTO csy_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Peangdap te bul tu le; laktong sil ni keng ngawl tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ama te kungah, Na tum na uh inn ah tua mun pan na paikik uh dong, tam vun. ");
INSERT INTO csy_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A kuapo a hi zong note hong sang nuam ngawl le na thu uh a ngai nuam ngawl peuma tua mun pan na pusua kik uh ciang in, amate langpan tu tetti tu in na peang leihui thin vun. A tatak kong ci ciang, thukhenna ni ciang in tua khuapi sang in Sodom le Gomorah te thuakna thuak nop zaw lai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Amate pai uh a, mihing te ki sikkik tu in thuhil uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Amate in doai ngilo tampi hawlkhia uh a, cina tampi te zong sathau zut in damsak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesus sia muntheampo ah a minthang a, Herod kumpipa in a thu a zakciang in; tuiphumpa John thina pan thokik hi, tua hang in a vanglian nasep te lak thei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","A dangte in Elijah hi, ci uh hi. A dang te in kamsang khat hi, a hibale kamsang sung pan khat papo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ahihang Herod in a zakciang in, hi thu sia a ngawng ka tan John thina pan thokik hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod in a nau Philip i zi Herodias sia tenpui a, tua Herodias thu hang in, ama vateak in mi sawl a, John man in thong ah khum hi. ");
INSERT INTO csy_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John in Herod kungah, na naupa zi na tenpui sia ngeina om ngawl hi, a ci hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tua ahikom Herodias in John ngaimaw in that nuam napi; that thei ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Banghangziam cile Herod in John sia mi thutang le mithiangtho hi, ci a heak hang in lau hi, ama in keamcing in, a sep sa tampi te lungdamtak in ngai hi. ");
INSERT INTO csy_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Hunpha a thet ciang in, Herod in a suani ah, ama i to te, ngalkapmang te le Galilee ngam uk ulian te atu in nitak an vak hi; ");
INSERT INTO csy_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias i ta nu tum in, a lap ciang, Herod le a kiim a to te a lungkimsak mama hi, tua ahikom kumpipa in ngaknu nu kungah, na dei theampo hong ngen tan, kong pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nong nget theampo, ka kumpingam a lang a hi zong kong pia tu hi, ci in kamciam hi. ");
INSERT INTO csy_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tasiaciang ngaknu nu a nu kungah pai a, bang ka ngen tu ziam? ci hi. A nu in, tuiphumpa John lu ngen in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ngaknu nu hongpai kik pai in, kumpipa kungah tuiphumpa John i lu sia pakandal sungah a manlang in nong piak tu ka dei hi, ci in ngen hi. ");
INSERT INTO csy_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kumpipa sia khuangai mama hi kale; a kamciam na sa le a kiim a to te hang in, ngaknu nu nget na nial ngam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Taciang kumpipa in mihing that te khat sawl in paisak pai a, John lu puak tu in thupia hi: taciang mihing that pa pai a, thonginn sungah John ngawng tan hi, ");
INSERT INTO csy_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Taciang pakandal taw a lu puak a, ngaknu nu pia hi: taciang ngaknu nu in a nu pia hi. ");
INSERT INTO csy_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tua thu John nungzui te in a zak ciang in, amate hongpai uh a, a luanghawm la in than ah vui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sawltakte Jesus kungah hong ki kaikhawm uh a, amate i vawt te le a thuhilna uh theampo son uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesus in amate tungah hibang in ci hi, Hongpai tavun, senneal sungah a tuam in tawmvei tawlnga tawng, ci hi: banghangziam cile a pai le a cia mihing tam mama a, amate anneak hun zong nei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Taciang amate ngunkuang taw a tuam in senneal sangah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mipi te in amate pai a mu uh ciang in, mi tampi in Ama he uh ahikom, khuapi theampo sung pan in peang taw hongpai tek uh a, amate kantan in, a kungah hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesus hong pusua ciang in, mitampi a mu ciang, a cing nei ngawl tuuhon taw kibang uh ahikom khuangaihuai sa hi: taciang amate thu tampi hil kipan hi. ");
INSERT INTO csy_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nitak sang ciang in a nungzui te a kungah hongpai a, hi mun sia senneal ngam hi, khua zong niam zo hi: ");
INSERT INTO csy_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amate paisak in a, kiim le pam khua tatuam ah pai in, amate neak tu anluum lei tahen: banghangziam cile amate neak tu bangma nei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus in, Note in amate neak tu pia vun, ci in zo kik hi. Taciang amate in, koma pai in dangka za ni man an lei in, amate neak tu pia tu hong sawl ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesus in, Anluum bangza nei nu ziam? pai vun a en vun, ci hi. Amate in a heak uh ciang, lum nga le ngasa ni, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesus in a vekpi in lopa hing tungah a hon a hon in to tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Taciang amate, pawlkhat zakhat, pawlkhat sawm nga ci bang in a hon a hon in to tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesus in anluum nga le ngasa ni te a lak zawkciang in, vandak to a, thupha a piak zawkciang, anluum te bal in, a nungzui te mai ah lui hi; ngasa ni te zong amate theampo hawmsak hi. ");
INSERT INTO csy_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Amate theampo in ngilva tak in ne tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Amate in anluum le ngasa a val te tawm uh a, bawm sawm le bawm ni dim hi. ");
INSERT INTO csy_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Anlum a ne teng pasal tul nga kiim pha uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Mipite a ciasak uh laitak in, a nungzui te ngunkuang sungah tumsak pai in, ngalkhat Bethsaida ah paikholsak hi. ");
INSERT INTO csy_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Amate a paisak zawkciang in, mualtung ah thungen tu in pai hi. ");
INSERT INTO csy_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nitak sang ciang in, ngunkuang sia tuili laizang ah om a, Jesus ama nguak mualtung ah om hi. ");
INSERT INTO csy_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Amate sangah hui hongpai ahikom a nungzui te in ngunkuang sia haksa tak in hot uh hi: zingsang nai thum le nai luk ki laklaw kiim in, Jesus amate sang tuili tungah lampai in, amate kantan tu bang in kithoai hi. ");
INSERT INTO csy_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ahihang amate in tui tungah a lampai a mu uh ciang in, thitha sa in, au ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Banghangziam cile a vekpi in mu uh a, amate lungmang mama uh hi. Tasia pociang Jesus in amate paupui a, Thinnuam in om vun: Keima khi hi; lau heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesus amate kung ngunkuang tungah ka to a, a sung a thet ciang in; hui zong thim hi: taciang amate in sonzawk ngawl zadong in lamdangsa uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Amate in anluum taw kisai nalamdang thu phawk ngawl uh hi, banghangziam cile amate a thinpui lei uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ngalkhat a thet uh ciang in, Gennesaret ah hongpai uh a, tuihui ah ngunkuang khit uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Amate ngunkuang sung pan a pusua pociang, mipi te in Jesus a hi hunlam tel pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Tasiaciang tua ngam kimkot theampo ah tai uh a, Jesus om hi, ci a zak na mun uh ah, cina te a lupna uh taw hong pua tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus a tum na mun khua theampo, khuapi te le lo lam theampo ah, amate in cina te lampi tungah sial uh a, a puanmong tham tu in ngen tek uh hi: a tham tha theampo in damna nga uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tuazawkciang in Pharisee te le thukhamhil te honkhat Jerusalem pan hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Amate in Jesus nungzui pawlkhat te khut silngawl a ninpui taw anne a mu uh ciang in, mawsiat uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Banghangziam cile amate ngeina a zui Pharisee te le Judah minam theampo, khut sil ngawl in anne ngei ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Amate sumbuk pan a cia uh ciang zong, khut a sil bua uh le anne ngawl uh hi. Thu dang tampi a zui uh te, hai, beal, danbeal le sabuai ci bang te zong sil tawntung uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tasiaciang Pharisee te le thukhamhil te in ngeina te zui ngawl in, banghang khut sil ngawl in anne ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus in amate tung ah, Isaiah in phatak in noma a kihitheamsak te thu a sonkholna a atsa bangma in, hi mite in a muk uh bek taw hong upat uh hi, ahihang a thinsung uh sia kei kung pan khuala uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ahihang amate in mihing thupiak te sia ki hil na phabel atu in zang uh a, a lui thathong in kei hong bia uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Banghangziam cile, Pathian thupiak te vawk in, mihing te i ngeina beal le hai te sil ngeina zui zaw nu hi, tabang thudang tampi te zong vawt nu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus in amate tung ah, Na ngeina uh na zui thei natu uh in, Pathian thupiak te nial thal nu hi. ");
INSERT INTO csy_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Banghangziam cile Moses in, na nu le na pa zakta in; a pa a hibale a nu a hamsiat peuma, thina thuak tahen, ci hi: ");
INSERT INTO csy_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ahihang note in, khatpo in a nu, a hibale a pa kungah zatakna tu in van a nei te, hisia Corban hi, hisia letsong hi cinopna hi, Pathian kungah piaksa hi: ci po le ama peng tu hi. ");
INSERT INTO csy_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tabang in a pa, a hibale a nu atu in a vawtsak tu te vawt nuam nawn ngawl nu hi; ");
INSERT INTO csy_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Na ki hil sawn uh na ngeina uh te zang in Pathian thu sia vang nei ngawl suaksak nu hi: tabang in na vawt uh dang tam mama lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesus in mihonpi te a vekpi in a kungah sam a, Note sung pan khatsim in hong ngai tavun a, tel thei tavun: ");
INSERT INTO csy_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Mihing sia a puasang pan in a sungah a tumsuk te taw a nin om ngawl hi: ahihang a sungsang pan a pusuak thu te in ninsak hi. ");
INSERT INTO csy_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Khat po in zak thei na bil a nei le, za tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesus sia mihonpi te kung pan in innsung ah a tum ciang in, a nungzui te in sontena taw kisai in thu dong hi. ");
INSERT INTO csy_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesus in amate tung ah, Note zong tel thei tuan ngawl nu ziam? Bangpo a hi zong a puasang pan mihing sung a tum sia in ama ninsak ngawl hi, ci sia tel thei ngawl nu ziam; ");
INSERT INTO csy_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Banghangziam cile a thinsung ah tum ngawl in a ngilpi sungah tum a, taciang awng dum sungah an theampo ki thiangsak hi ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tasiaciang Ama in, Mihing sung pan a pusuak sia in, tua mihing ninsak hi. ");
INSERT INTO csy_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Banghangziam cile mihing thinsung pan in, ngaisutna phangawl, palngul mawna, paktatna, tual that, ");
INSERT INTO csy_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Nguta, duhop na, ngitlona, theam na, maizum heak ngawl na, el na, sonsiat na, kiphatsakna, mawmawt na: ");
INSERT INTO csy_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Hibang a phangawl theampo sia a sung pan a pusuak te hi a, mihing ninsak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tuazawkciang Jesus tua mun pan in ding a, Tyre le Sidon ngamngi sangah pai in, innkhat sungah tum hi, kuama heak tu zong dei ngawl hi: ahihang bucip thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Banghangziam cile, doai ngilo vei numeino khat i nu in Jesus thu a zak cing, hongpai in a peang ah bok hi: ");
INSERT INTO csy_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Taciang a tanu sung pan doai hawlkhiatsak tu in ngen hi; tua nupi nu sia Greek minam hi a, Syrophenicia ngammi a hihi. ");
INSERT INTO csy_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ahihang Jesus in, Tate ngilva phot tahen: banghangziam cile tate i anluum laksak in, ui piaksak tu ngeina om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tua nupi nu in, hi hi, Topa awng: hima kale, tate sabuai pan anneng tak sabuai nuai pan ui in ne thei hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Tasiaciang Jesus in a kungah, Hi thu hang in, pai tan a; na tanu sung pan in doai ngilo pusuak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A inn a thet ciang in, a tanu sung pan doai ngilo pusuak zo a, lupna tungah a lum mu hi. ");
INSERT INTO csy_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesus Tyre le Sidon ngam kiim kot pan pai kik a, Decapolis ngam huam sung teng kantan in Galilee tuili theng hi. ");
INSERT INTO csy_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Taciang amate in Jesus kungah nangong le a pau thei ngawl pa khat hong paipui uh a, a tungah khut nga tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesus in tua pa sia mihonpi te kung pan in mundang ah paipui a, a khutzung te a bil lang le lang sungah thun in, cilphi a, a lei zong thamsak hi; ");
INSERT INTO csy_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Taciang Jesus vandak to in, a tau zawkciang tua pa kungah, Ephphatha, ci hi, a khiakna sia, ki hong tahen, a cinopna a hihi. ");
INSERT INTO csy_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tasia pociang in a bil te ki hong in, a lei thangui zong ki phel a, a thiang vaset in pau hi. ");
INSERT INTO csy_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesus in tua thu kuama tungah son ngawl tu in vaitha hi: ahihang a vaithak tam seseam le nasia va-ial in pualak hi; ");
INSERT INTO csy_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tasiaciang amate in lamdangsa mama uh a, Ama in na theampo a pha in vawt hi: nangong te khua zasak zo a, a pau thei ngawl te zong pausak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tuazawkciang a tam mama mihonpi te neak tu nei ngawl hi, taciang Jesus in a nungzui te a kungah sam a, ");
INSERT INTO csy_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Mihonpi te hesuakhuai sa khi hi, banghangziam cile amate ka kungah nithum hong om zo a, neak tu bangma nei ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","An ne ngawl in amate innlam zuan in ciasak hileng, amate lamkal ah puk-hong tu hi: banghangziam cile pawlkhat te a khuala mama na pan in hongpai uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","A nungzui te in, hi duisung ah a kua in mihing hi za ngilva tu in vak tu anluum kong pan nga thei tu ziam? ci in zo kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Taciang Jesus in, Anluum bangza nei nu ziam? ci in dong hi. Amate in sali, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesus in mipi te lei ah to tu in thupia hi: taciang anluum sali la a, lungdam a ko zawkciang phel in, mipi te lui tu in a nungzui te mai ah koi a; a nungzui te in mipi te lui hi. ");
INSERT INTO csy_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amate in ngasa tawm nei hi: Jesus in thupha a piak zawkciang in, mipi te lui tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Amate ngilvatak in a neak zawk uh ciang in: anluum neng teng tawm uh a bawm sali dim hi. ");
INSERT INTO csy_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","A ne te sia tul li kiim pha uh hi: taciang Jesus in amate ciasak hi. ");
INSERT INTO csy_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tuazawk pociang ngunkuang sungah a nungzui te taw tum a, Dalmanutha ngam huam sungah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pharisee te hongpai in, Jesus thu dok kipan uh hi, Ama ze-et tu in vanlam musakna ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesus in a thinsung tawng pan tau vahum in, Banghang in hi minam te in musakna ngen ziam? a tatak in kong ci ciang, hi minam te kungah musakna bangma pia ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Taciang Jesus in amate nusia in, ngunkuang sungah to kik a ngalkhat ah pai hi. ");
INSERT INTO csy_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nungzuite in anluum ken tu mangil uh a, ngunkuang sungah anluum khat simngawl a dang bangma nei ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesus in amate tung ah, Pharisee te le Herod i tol pan kidawm vun, ci in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Hi thu sia anluum i ken ngawl hang hi, ci in amate kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Taciang Jesus in a heak ciang in amate tung ah, Anluum na nei ngawl uh hang hi, ci in banghang kikum nu ziam? he ngawl lai in tel thei ngawl lai nu ziam? na thin uh puisak top lai nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mit nei napi, mu ngawl nu ziam? bil nei napi, za ngawl nu ziam? bangma ciamte ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tul nga te sungah anluum nga ka phel lai, a val bawm bangza tawm nu ziam? ci hi. Amate in, sawmleni, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tul li sungah sali ka phel lai in, a val bawm bangza tawm nu ziam? ci hi. Amate in, sali, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesus in amate tung ah, Bangbang in hi thu he thei ngawl nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesus Bethsaida ah hongpai a; amate in mittaw khat a kungah hong paipui uh hi, taciang tua pa a thamsak tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesus in mittaw pa a khut pan in len a, khuapi puasang ah paipui hi; taciang a mitte tungah cilphi in, a khut nga a, khatpo mu na nei ziam, ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mittaw pa in en a, mihing te thingkung bang in a vak mu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tuazawkciang Jesus in, mittaw pa mit tungah a khut nga kik a, ensak hi: a mit vak in, mihing te thiangtak in mu hi. ");
INSERT INTO csy_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesus in a inn ah ciasak a, Khuapi sungah tum heak in a, kuama zong son heak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus le a nungzui te pai uh a, Caesarea Philippi khuapi kiim khua te ah pai hi: lamkal ah a nungzui te kungah, Ngual in keima sia akua hong ci uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Taciang amate in, tuiphumpa John: pawlkhat te in Elijah; a dang te in kamsang khat papo hong ci hi, ci in zo kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Taciang Jesus in amate tung ah, Hi kale, note in, Keima sia kua hi nong ci uh ziam? ci hi. Taciang Peter in, Nangma sia, Christ na hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tasiaciang in, Ama thu kuama tungah son ngawl tu in nungzui te vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesus in amate thuhil kipan a, mihing Tapa in tam mama thuak tu hi, upa te, thiampi lian te le thukhamhil te in nial tu uh hi, that tu uh a, nithum zawkciang thokik tu hi. ");
INSERT INTO csy_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Tua thu Jesus in a kilangtak in son hi. Taciang Peter in Jesus samtuam in tei hi. ");
INSERT INTO csy_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ahihang Jesus in a nungzui te kihei in a le-et kawm in, Satan: nang ka nung ah kiheam in, banghangziam cile Pathian thu sang in, mihing thu kinzaw ni hi, ci in Peter tei hi. ");
INSERT INTO csy_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Taciang Jesus in mihon te le a nungzui te Ama kungah a sap zawkciang in, A kuamapo ka nung hong zui nuam peuma, ama le ama ki nial hen a, ama thinglamte pua in, hong zui tahen. ");
INSERT INTO csy_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Banghangziam cile a kuamapo in, ama nuntakna a hung nuam sia in sum tu hi; ahihang a kuamapo in keima le lungdamna thu hang in a nuntakna a sum peuma in, a nuntakna hu zo tu hi. ");
INSERT INTO csy_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Banghangziam cile mi khat in hileitung buppi a nei hial zong, a thaa nuntakna a sum le bang phatuam ziam? ");
INSERT INTO csy_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mihing in a thaa nuntakna bang taw theak thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tua ahikom a kuamapo in hi seksol suan te mai ah keima le ka thu a maizumpui peuma; a Pa vangletna sungah a thiangtho vantungmi te taw hongpai ciang in, mihing Tapa in maizumpui kik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus in amate tung ah, A tatak in kong ci ciang, hi mun ah a om pawlkhat te in, Pathian kumpingam vangletna taw hongpai a mu dong thina tep tha ngawl tu uh hi. ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ni luk zawkciang Jesus in, Peter, James le John te mualsang tungah a tuam in sam a, amate mai ah a meal kikheal hi. ");
INSERT INTO csy_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","A puan taang a, leitung ah koibang puansawp peuma in zong a thiansak thei ngawl tu za dong in; vuk bang in pak hi. ");
INSERT INTO csy_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elijah le Moses te hong ki lang a: Jesus taw ki paupui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Peter in Jesus kungah, Syapa awng, eite atu in hi mun ah om tu pha hi: buk thum sa tawng; Nangma atu khat, Moses atu khat le Elijah atu khat, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Banghangziam cile amate a laulei uh hu in, bang son tu ci zong a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Taciang amate meingo in lia a: meingo sung pan in, hisia ka it ka Tapa a hihi, ama thu ni vun, ci aw khat hong nging hi. ");
INSERT INTO csy_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tasia pociang, amate in a kiim a pam a et uh ciang in, Jesus le amate simngawl kuama a mu bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Amate mualtung pan a tuaksuk uh ciang in, Jesus in, mihing Tapa thina pan in a thawkik dong, a mu uh thu te kuama a son ngawl natu in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Amate in tua a son thu te ciamte uh a, thina pan thokik, ci kammal sia bang a cinopna hi tu ziam, ci in khat le khat ki dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Taciang a nungzui te in, banghang in thukhamhil te in Elijah hongpai masa tu hi, ci ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesus in, Elijah hongpai masa takpi tu a, na theampo ama in puakhol tu hi; taciang mihing Tapa thu bangbang in atkhol ziam ci le, ama in tam mama thuak tu a, bangma thusimngawl in koi tu hi. ");
INSERT INTO csy_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ahihang keima in hibang in kong ci hi, Elijah hong theng takpi a, ama thu a ki atkholsa ombang in, amate uk bang in vawt uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","A nungzui te kungah hongpai ciang in, thukhamhil te le mihonpi te a kiim ah thu kidong mu hi. ");
INSERT INTO csy_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Thakhatthu in, mi theampo in Jesus a mu uh ciang in, lamdangsa uh a, ama sangah hong tai in, paupui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesus in thukhamhil te kungah, Amate taw bang ki dong nu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Mihonpi sung pan khat in, Syapa awng, ka tapa sungah a pau thei ngawl doai lut a, na kung hong puak khi hi; ");
INSERT INTO csy_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tua a pau thei ngawl doai in a paipui na mun theampo ah, lei ah puksak in, a kam pan cilphuan te pusuak hi, a ha ngoai in, ngawm law liang hi: na nungzui te hawlkhiasak tu in ka son hang; amate in hawlkhia zo ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesus in ama zokik a, Maw upna nei ngawl suan te, note taw bang hun dong hong om tu khi ziam? banghun dong hong khual lai tu khi ziam? ama ka kungah hong paipui tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Amate in Jesus kungah paipui uh hi: Jesus a mu ciang in, thaa in patang pa sia thakhatthu in lei ah puksak a; cilphuan te thasak hi. ");
INSERT INTO csy_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesus in, Hi bang a hi zawk ngei zo ziam? ci in a pa dong hi. A pa in a no lai pan ma hi zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Taciang ama siatsua tu in, tu le tu mei sungah ahizong, tui sungah ahizong, sep tawntung hi: ahihang khatpo na vawt thei le, kote tungah hesuakna nei in hong hu tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesus in ama kungah, Na um ngam ziam, a umte atu in na theampo suakthei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tua patang i pa in thakhatthu in, Topa, um khi hi; ka up ngawl na hong hu tan, ci in thitui taw au hi. ");
INSERT INTO csy_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesus in mihon te tai kawm in hongpai a mu ciang, doai ngilo tung ah, Nang pau thei ngawl le nangong doai, hi sia pa sung pan pusuak tu le tumkik nawn ngawl tu in thu hong pia khi hi, ci in tei hi. ");
INSERT INTO csy_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Tua thaa ngilo au a, patangno kawngkaw cip bang in a omsak zawkciang, a sung pan pusuak hi: taciang ama sia a thi bang in om a; mi tampi in, thi zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ahihang Jesus in a khut pan len in kaito hi; taciang ama ding to hi. ");
INSERT INTO csy_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesus innsung ah a tum ciang in, a nungzui te in a, banghang in ko te in hawlkhia thei ngawl khu ziam? ci in a tuam in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesus in amate tung ah, Hi bang te sia thungetna le antan na simngawl, thudang taw pusuak thei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Amate tua mun pan Galilee ngam kantan in pai uh a; kuama i heak tu dei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Banghangziam cile a nungzui te hil a, Mihing Tapa sia ngual khut ah ap tu hi, taciang amate in that tu uh a; a ma a ki thalup zawk nithum ni ciang in thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ahihang amate in a son thu telthiam ngawl uh hi napi, dong ngam tuan ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaum khua theng uh a: innsung a tum uh ciang in Jesus in a nungzui te kungah, Lamkal ah bang thu ki nial nu ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ahihang amate huthe ngawl in om uh hi: banghangziam cile lamkal ah a ki nial uh thu sia, a kua lianbel tu, ci thu ki nial uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesus to suk a, a nungzui sawmleni te sam in, amate tung ah, A kuamapo a masabel nuam le, tua pa sia, a khakbel le mi theampo te naseam hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Taciang Jesus in patangno khat la in, amate lai ah koi hi: a toai zawkciang in, amate tung ah, ");
INSERT INTO csy_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","A kuama po in keima min taw hibang patang te a sang peuma keima hong sang a hihi, taciang a kuamapo keima hong sang peuma in, keima hong sang hi ngawl in, keima hong sawl pa a sang a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","John in, Syapa awng, na min taw doai te a hawlkhia khat ka mu uh a, hong zui ngawl hu in: tho khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ahihang Jesus in, Khak heak vun; banghangziam cile keima min taw na lamdang a vawt khat in, kei hong sonsia mameang ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Banghangziam cile ei hong langpan ngawl peuma ei sangah om hi. ");
INSERT INTO csy_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A tatak in kong ci ciang, a kuapo a hi zong keima mihing na hi uh hang in, ka min taw tui dawn tu hai khat hong pia peuma, a thaman tan ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Khat po in keima hong um patangno te sung pan khat lam a khialsak peuma, a ngawng ah an ngoai na suangtum khit in, tuipi thuk na mun ah khiasuk leang ama atu phazaw lai hi. ");
INSERT INTO csy_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na khut in hong khialsak le, at tan in: bangmahun in a mit ngei ngawl tu hell meisung ah khut lang ni taw pai sang in, pumpi kim ngawl in nuntakna sungah tum tu phazaw hi: ");
INSERT INTO csy_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tua mei sungah than zong thi ngawl a, mei zong mit ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Taciang na peang in hong khialsak le, at tan in: bangmahun in a mit ngei ngawl tu hell meisung ah peang lang ni taw pai sang in, pumpi kim ngawl in nuntakna sungah tum tu phazaw hi: ");
INSERT INTO csy_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tua mei sungah than zong thi ngawl a, mei zong mit ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Taciang na mit in hong khialsak le, khel keak in: bangmahun in a mit ngei ngawl tu hell meisung ah mit lang ni taw pai sang in, pumpi kim ngawl in nuntakna sungah tum tu phazaw hi: ");
INSERT INTO csy_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tua mei sungah than zong thi ngawl a, mei zong mit ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Banghangziam cile khatsim khatsim mei taw hong ki alsak tu hi, taciang biakpiakna theampo zong ci taw ki alsak tu hi. ");
INSERT INTO csy_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Cii sia pha hi: ahihang a al na bo a hile, bangbang in al kiksak thei tu nu ziam? Cii bang in al vun a, khat le khat kilem vadiam in om tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus tua mun pan ding in, Jordan ngun ngal khat Judah ngam kimkot teng ah pai hi: mipi te a kungah hong ki kaikhawm kik leleau a; a hil ngei bang in thuhil kik hi. ");
INSERT INTO csy_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Pharisee te a kungah hongpai a, pasal khat in a zi khul tu ngeina a om ziam? ci ze-et in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesus in amate tung ah, Moses in note bang thu hong pia ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Taciang amate in, Moses in khul na lai at in, zi khul tu oai hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus in amate tung ah, Moses in na thinpui lei uh hang in hi ngeina a at a hihi. ");
INSERT INTO csy_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ahihang Pathian in a kipatcil bitphuana hun lai in pa le numei vawt hi. ");
INSERT INTO csy_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tua ahikom pasal in a pa le a nu nusia tu a, a zi beal tu hi; ");
INSERT INTO csy_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Taciang amate ni sia taksa pumkhat hi tu hi: tua ahikom amate sia ni hi nawn ngawl tu a taksa pumkhat a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tua ahikom Pathian in a ngawm sa te mihing in khen heak tahen, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Innsung ah a nungzui te in tua thu ma dong kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesus in amate tung ah, A kuamapo in a zi khul in, ngualdang a tenpui le palngul mawna vawt a hihi. ");
INSERT INTO csy_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Zi in a pasal nusia in, pasal dang a nei kik le, palngul mawna vawt a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Amate in a tate uh a thamsak tu dei in Jesus kungah paipui uh a: a nungzui te in amate tei hi. ");
INSERT INTO csy_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ahihang Jesus in a mu ciang in, a thin-uk a, amate tung ah, Patangno te ka kung hong paisak tavun, khak heak vun: banghangziam cile Pathian kumpingam sia hibang patang te atu a hihi. ");
INSERT INTO csy_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A tatak in kong ci ciang, a kuamapo hibang patangno bang in Pathian kumpingam a sang ngawl peuma, Pathian kumpingam sungah tum ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Taciang Jesus in patang te toai a, amate tungah a khut nga in, thupha pia hi. ");
INSERT INTO csy_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus lamkal ah a pai laitak in, mi khat hong tai a, khupdin in, Sya pha awng, tawntung nuntakna ka nga thei natu in bang vawt tu khi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Taciang Jesus in ama kungah, Banghang in, pha, hong ci ni ziam? Pathian khatbek simngawl kuama a pha om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Thupiak te he ni hi, palngul mawna vawt heak in, tual that heak in, nguta heak in, a man ngawl tettipang heak in, ngual neisa sut heak in, na nu le na pa zakta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Taciang tua pa in Jesus kungah, Syapa awng, hite theampo ka no lai pan in zuisiat zo khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tasiaciang Jesus in ama itna taw en a, Khat bek kisam lai ni hi: pai tan a, na neisa theampo zuak siat in, taciang mizawng te pia in, tua hile vantung ah neisa na nei tu hi: taciang hongpai tan a, thinglamte pua in hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tua thu hang in ama khuangai mama a, thinna in paisan hi: banghangziam cile a neisa tam mama hi. ");
INSERT INTO csy_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesus in a kimkot teng en a, a nungzui te kungah, Mihau te Pathian kumpingam sung a tum tu uh bangza in haksa ziam! ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taciang a nungzui te in Jesus i son thu hang in lungmang mamatek uh hi. Ahihang Jesus in amate tung ah, Ka tate awng, hauna a muang te atu in Pathian kumpingam sungah tum tu sia bangza in haksa ziam! ");
INSERT INTO csy_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mihau pa Pathian kumpingam sungah a tum tu sang in, phin bilvang sungah kala-uk tum tu ol zaw hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Amate in lamdangsa mamatek uh a, tabang hithong le, a kua peuma ngupna nga thei tu ziam? ci in amate kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Taciang Jesus in amate en a, Hi thu sia mihing te atu in suak thei ngawl hi, ahihang Pathian atu in hi ngawl hi: banghangziam cile Pathian atu in na theampo suak thei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Tuazawkciang in Peter in, Jesus kungah, en in, kote ka hi uh le na theampo nusia in kong zui uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesus in, A tatak in kong son hi, a kuamapo keima le lungdamna thu hang in a inn le lo a hi zong, a u le a nau a hi zong, a nu le a pa a hi zong, a zi le a ta te a hi zong, a nusia a hile, ");
INSERT INTO csy_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Tu hun in inn le lo hi kale, nu te hi kale, u le nau hi kale, tate hi kale, vawtsiatna tatuam taw a se za in sang tu a; hongpai lai tu hun ah tawntung nuntakna sang tu hi. ");
INSERT INTO csy_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ahihang a masabel te nungkhakbel tu a; a nungkhakbel te masabel hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Amate Jerusalem pai na lamkal ah hi uh a; Jesus amate mai ah pai hi: taciang amate in lamdangsa in, a nung pan zui kawm in lau tek mama uh hi. A nungzui sawmleni te sam a, a tungah thupiang tu te son kipan hi, ");
INSERT INTO csy_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","En vun, Jerusalem sangah i pai hi; mihing Tapa sia thiampi lian te le thukhamhil te kungah ap tu hi; amate in thi tu in thukhen tu uh a, Gentile te kungah ap tu uh hi: ");
INSERT INTO csy_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Amate in selno tu a, vel in cilphi tu uh hi, taciang that tu uh a: nithum ni ciang in thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedee tapa James le John te Jesus kungah hongpai uh a, Syapa awng, kong nget tu uh sia nong vawtsak tu ka uk uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesus in amate tung ah, No atu in bang hong vawtsak tu khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Amate in, na minthanna sungah khat na ziatsang ah, a dang khat na veisang ah hong tosak tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Hi kamale, Jesus in, Bang ngen nu ziam ci zong he ngawl nu hi: ka dawn tu hai dawn zo tu nu ziam, ka san tu baptisma sang zo tu nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Amate in, zo tu khu hi, ci uh hi. Jesus in, Ka dawn tu hai dawn takpi tu nu hi, ka san tu baptisma zong sang takpi tu nu hi: ");
INSERT INTO csy_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ahihang ka ziatsang le ka veisang a to tute sia kei i piak tu hi ngawl a; ka Pa in a ngealkholsa te pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tua thu a dang sawm te in a zak uh ciang in, James le John tungah a lung uh kim ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ahihang Jesus in amate tung ah, Na heak uh bang ma in Gentile kumpi te in a mihing te sia zawthawk thu taw uk uh a, ulian te in mipi te tungah thuneina zang tawntung uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ahihang no sungah hibang hi ngawl tu hi: note sungah khatpo a lian nuam le, note i naseam hi tahen: ");
INSERT INTO csy_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Note sung pan khatpo in a lu bel a hi nuam le, note i sila hi tahen. ");
INSERT INTO csy_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mihing Tapa sia ngual a sawl tu in hongpai ngawl hi, ngual atu seam tu in le mi tampi tatkhiat natu a nuntakna pia tu in hongpai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesus le a nungzui te Jericho ah hongpai uh a: amate mihon tampi taw Jericho pan a pusua uh ciang in, Timaeus i tapa, Bartimaeus a kici mittaw pa sia lamhui ah to in khutdaw ngen hi. ");
INSERT INTO csy_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ama in Nazareth khua mi Jesus hi, ci a zak ciang in, David Tapa Jesus awng, hong hesuak kapo in, ci in au hi. ");
INSERT INTO csy_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mi tampi te in ama a om khikhep natu in tei uh hi kale: Nang David Tapa awng, hong hesuak kapo in, ci in au seseam hi. ");
INSERT INTO csy_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesus ding a, ama sam tu in thupia hi. Amate in mittaw pa kungah, thinnuam in a, ding in; Ama in hong sam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A puantual sil sia khia in, ding a, Jesus kungah pai hi. ");
INSERT INTO csy_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus in ama zo a, Nang tungah bang ka vawt tu uk ni ziam? ci hi. Mittaw pa in, Topa awng, ka mit khua mu tu uk khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesus in ama kungah, pai in; na upna in hong damsak zo hi, ci hi. Tasia pociang in khuamu a, lampi ah Jesus nungzui hi. ");
INSERT INTO csy_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Amate Jerusalem hong nai ciang, Olive mual a om Bethphage le Bethany a thet uh ciang in, Jesus in nungzui te ni sawl in, ");
INSERT INTO csy_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Na mai uh ah pai tavun a: khuasung na tum uh pociang kuama to ngei ngawl lai laano a ki khitsa in mu tu nu hi; a khau sut vun a, ka kungah paipui tavun. ");
INSERT INTO csy_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Khat po in banghang hibang ngamta nu ziam? hong ci le, Topa in tulmaw hi; ci vun, tasia pociang hong paisak pai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Amate pai uh a, lampi kisiktua na mun kongkha hui a puasang ah laano a ki khit mu uh hi; taciang sut uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tua mun ah a ding te in, banghang in laano sut nu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A nungzui te in Jesus thupiak sa bang in a son uh ciang: amate in paisak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Amate in laano sia Jesus kungah hong paipui uh a, a tungah puan te pha hi; taciang Jesus a tungah to hi. ");
INSERT INTO csy_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Mi tampi te in lampi ah a puan uh te pha uh a: midang te in zong thingbak te sat in lampi tungah pha uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A mai ah a pai te le a nung pan a zuite in, Hosanna; Topa min taw hongpai pa thuphatoai a hihi: ");
INSERT INTO csy_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","I pa David kumpingam in thupha nga tahen, Topa min taw hongpaipa: a sangbelna ah Hosanna, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Taciang Jerusalem biakinn sungah tum uh a: na theampo a et zawk, nitaksang ciang in, nungzui sawmleni te taw Bethany khua ah pai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","A zingciang Bethany khua pan amate a paikik uh ciang in, Jesus a ngilkial hi: ");
INSERT INTO csy_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A ngalkhat pan in a te puitung mama theikung khat mu a, a nga a om tha le, ci in pai hi: a bul a thet ciang in, a te simngawl bangma mu ngawl hi; banghangziam cile a nga hun hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesus in tua theikung sia, Kuama in bangmahun in na nga ne nawn heak tahen, ci hi. A nungzui te in zong za uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Amate Jerusalem ah hongpai uh a: Jesus biakinn sungah tum hi, biakinn sungah vanzuak te le a lei te nawtkeak in, sum theak te sabuai te le vakhu zuak te i tokhum te lawnthal siat hi; ");
INSERT INTO csy_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Biakinn hui pan zong kuama vanpua kawm in tawnsak nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesus in, Ka inn sia minam theampo in thungetna inn, ci tu uh hi, ci atkhol hi ngawl ziam? ahihang note in nguta te kua in na vawt uh hi, ci hil hi. ");
INSERT INTO csy_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tua thu thukhamhil te le thiampi lian te in a zak uh ciang in, Jesus bangbang in that thei tu, ci in zong tek uh hi: banghang in amate in Jesus lau ziam cile, mi theampo in a hilna lamdang asak uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nitak sang ciang in Jesus khuapi sung pan in pusuak hi. ");
INSERT INTO csy_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","A zingsang ciang lampi ah a pai uh kawm in, amate in theikung sia a sungpan kipan a ko siat mu hi. ");
INSERT INTO csy_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter in phawkkik a, Jesus kungah, Syapa awng, en in, na hamsiat theikung sia ko siat zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Taciang Jesus in amate tung ah, Pathian sungah upna nei vun. ");
INSERT INTO csy_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Banghangziam cile, a mantak in kong ci hi, a kuamapo in, a thinsung ah uplakna nei ngawl in, a pau bang in a vekpi piang tu hi; ci upna taw hi mual tung ah, ki khin in a, tuipi sungah ki khiasuk in; a ci le a ci bang in piang tu hi. ");
INSERT INTO csy_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tua ahikom kong ci hi, thu na nget uh ciang in, na dei uh theampo sia nga khi hi, ci na um uh le na nga tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Thu na nget tu uh ciang in, khatpo i tungah diksak ngawl na na nei uh le, maisak vun: tabang in vantung a om na Pa uh zong in na vawtkhial uh te hong maisak tu hi. ");
INSERT INTO csy_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ahihang note in ngual khialna te na maisak bua uh le, vantung a om na Pa uh in note khial na zong hong maisak ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Amate Jerusalem ah hongpaikik uh a: biakinn sungah Jesus a pai laitak in, thiampi lian te, thukhamhil te le upa te a kungah hongpai uh a, ");
INSERT INTO csy_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ama tung ah, bang thuneina taw hibang nate vawt ni ziam? hibang nate vawt tu in a kua in hibang thuneina hong pia ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tasiaciang in Jesus in amate tung ah, Kei zong thu khat hong dong tu khi hi, hong zo tavun, hibang te bang thuneina taw vawt khi ziam, ci kong son tu hi, ci zo hi. ");
INSERT INTO csy_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","John i tuiphumna a piak sia, vantung pan ziam, mihing tung pan ziam? hong zo tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Amate kikum uh a, vantung pan ci leang; ama in banghang ama um ngawl nu ziam? hong ci tu hi. ");
INSERT INTO csy_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ahihang, mihing tung pan hi, ci tu hile; amate in mipi te lau hi: banghangziam cile mi theampo in John sia kamsang tatak hi, ci ngaisun tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Taciang amate in Jesus kungah, hong son thei ngawl khu hi, ci uh hi. Tasiaciang Jesus in amate tung ah, Hibang te bang thuneina taw vawt khi ziam ci keizong kong son bua tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus in thu sontena te zang in amate thuhil pan hi. Mi khat in sapit huan sungah sapit cing a, a huang um in sapit sukna tu dum zong to hi, taciang teitan zong sa a, huan naseam tu te zawn in ama a khuala mama na ah khualhaw hi. ");
INSERT INTO csy_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A hun a cin ciang in, huan naseam te kung pan a nga te la tu in a naseam te khat sawl hi. ");
INSERT INTO csy_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Amate in man in vel uh a, khut nguak in tha kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A dang naseam khat sawl kik leleau hi; tua pa sia suangtum taw sep in a lu zong liam hi, taciang maizum huaitak in tha kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Taciang a dang khat sawl kik leleau a; amate in tua pa that uh hi, a dang tampi te zong vel in that uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tua ahikom a it mama a tapa khat a neisun sia, amate in ka tapa sia zakta tu uh hi, ci in, a khakbel ciang in paisak hi. ");
INSERT INTO csy_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ahihang lo naseam te in, hisia pa a ngamhlua tu pa hi; pai tavun, ama that tawng, a ngamh teng eima a hi tu hi, ci in kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Taciang amate in a tapa man in, that uh a, sapit huan puasang ah vawk hi. ");
INSERT INTO csy_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tua ahikom sapit huan nei topa in bangbang vawt tu ziam? ama hongpai tu a huan naseam te siatsua tu hi, taciang sapit huan sia ngualdang te kungah pia tu hi. ");
INSERT INTO csy_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Innsa te in a nil uh suangtum sia innbul thupibel suak hi: ");
INSERT INTO csy_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hi thu in Topa i vawt hi a, i mu na ah, lamdang mama hi, ci in Lai Thiangtho sungah simngei ngawl lai nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Amate in, sontena a son te amate a cinopna hi, ci he ahikom in, Jesus sia mat sawm napi: mipi te lau a hi uhkom in Jesus paisan uh a, a kung pan in kiheam siat uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Amate in Jesus a kampauna pan man tu in, Pharisee te pawlkhat le Herod pawl te sawl uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Amate hongpai uh ciang in Jesus kungah, Syapa awng nangma sia thutang ni hi, kuama zong lau ngawl le mihing te maitang zong en ngawl in Pathian thutak lampi hil ni hi, ci kong he uh hi: Caesar kungah shia piak tu sia ngeina a hi ziam, hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pia tu khu ziam maw, a hibale pia ngawl tu khu ziam? ci hi. Ahihang Jesus in amate ki hitheamsak he ahikom, Banghang in hong ze-et nu ziam? dangka khat paipui tavun, en tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Taciang amate in paipui uh hi. Jesus in, Hi lim le ceptena sia a kua ziam? ci hi. Amate in, Caesar le ceptena hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Taciang Jesus in amate tung ah, Caesar neisa te Caesar pia vun a, Pathian neisa te Pathian pia vun, ci in zo hi. Taciang amate in Jesus lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Thawkikna om ngawl hi; a ci Sadducee te Jesus kungah pai in, thu dong uh a, ");
INSERT INTO csy_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Syapa awng, mi khat a suapuipa a thi ciang in, a zi ta nei ngawl in a nusia le, a thi pa i cimit ngawl natu in a nau in a mo tenpui hen, ci Moses in hong ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","U nau sali om uh a: a lianbel sia in zi nei napi, ta nei ngawl in thi hi. ");
INSERT INTO csy_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","A nina pa in tua nu tenpui a, ta nei ngawl ma in thi hi: a thumna zong tabangma hi. ");
INSERT INTO csy_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","A sali bup in tua nu tenpui uh a, kuama in ta a nei bua uh hi: a khakbel ciang in tua nu zong thi hi. ");
INSERT INTO csy_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tua ahikom thawkikna ni, amate a thawkik uh ciang in, tua nu sia a kua zi hi tu ziam? banghangziam cile a sali bup in tenpui hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus in amate tung ah, Lai thiangtho le Pathian vangletna na heak ngawl uh hang in, khial hi ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Banghangziam cile, amate thina pan a thawkik ciang in, kipui na le nupa tu in ki piak ci bang om nawn ngawl tu a; vantungngam ah vantung mite bang i hi tu hi. ");
INSERT INTO csy_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mithi te thawkik na thu taw kisai in: Moses laibu sungah, Pathian in lopa phung sung pan Moses a son na ah, Keima sia Abraham Pathian, Isaac Pathian le Jacob Pathian ka hihi, a ci na simngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pathian sia mithi te Pathian hi ngawl a, a nungta te Pathian a hihi: tua ahikom note nasiatak in khial nu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Amate in tua thu a kikup uh thukhamhil te sung pan khat in a zak ciang in, Jesus in phatak in zo hi, ci a heak ciang, a kungah pai a, thupiak theampo sung pan a masabel bang ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus in ama kungah, Thupiak theampo sung pan a masabel sia, ngai vun, Maw Israel; Topa i Pathian bek Topa hi: ");
INSERT INTO csy_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Topa na Pathian sia na thinsung theampo, na nuntakna theampo, na ngaisutna theampo le na hatna theampo taw it in: hi sia in a masabel thupiak a hihi. ");
INSERT INTO csy_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Taciang a ni na sia, a khatna taw a kibang hi a, nangma le nangma na ki it bang in na innpam it tu ni hi. Hi te sang in a lianzaw thupiak om nawn ngawl hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Thukhamhil pa in Jesus kungah, pha hi, Syapa awng, nang thutak son ni hi: banghangziam cile Pathian khatbek om a; Ama simngawl a dang om ngawl hi: ");
INSERT INTO csy_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Taciang Ama sia, thinsung theampo le heakna theampo, nuntakna theampo le hatna theampo taw it tu a hihi, taciang ama le ama a ki it bang in a innpam zong a it tu hi, tua thu sia meihal biakpiakna le sangaw biakpiakna theampo sang in thupi zaw hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tua pa in pilvangtak in a zo kik Jesus in a mu ciang in, ama tung ah, Nangma sia Pathian kumpingam taw na ki khuala bua hi, ci hi. Tuazawkciang kuama in Jesus thu a dong ngam nawn bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesus in, biakinn sungah thu a hil laitak in, Bangbang in thukhamhil te in Christ sia David Tapa ci thei ziam? ");
INSERT INTO csy_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Banghangziam cile David in Tha Thiangtho taw in ama le ama a kici na ah, Topa in ka Topa kungah, na ngal te na peang ngakna in ka vawt mateng ka ziatsang ah to in, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tua ahikom David in ama le ama sia Topa kici a hile; bangbang in a tapa hi thei tu ziam? ci in zo hi. Mihonpi in lawptak in ngai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus in a hil na ah, Thukhamhil te kidawm vun, amate sia puantualpui taw vak nuam sap uh a, sumbuk te ah paupui na te, ");
INSERT INTO csy_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Syngogues sungah tokhum tungnung te le poai mun theampo ah a sangbel inn doi te dei uh hi: ");
INSERT INTO csy_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Amate in meingong te inn zawthawk thu taw sut uh a, a sau mama thu ki ngensak hi: tua ahikom hi te in a lian zaw dan thuak tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus sumpi kuang mai ah to a, ngual in sumpi kuang sungah bangbang in sumpi khia ziam, ci in en hi: mihau tampi te in tampitak khia uh hi. ");
INSERT INTO csy_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Taciang a zawng meingongnu khat hongpai a, a son thamman ngawl dangka tang ni khia hi. ");
INSERT INTO csy_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Taciang Jesus in a nungzui te a kungah sam a, A mantak in kong son hi, hi a zawng meingong nu in sumpi kuang sungah a khia theampo sang in a tamzaw khia hi: ");
INSERT INTO csy_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Banghangziam cile, amate sia a dimlet a nei uh sung pan in khia uh hi; ahihang meingong nu a hile, a kivak natu kisam kawm pan in a nei theampo khia hi, ");
INSERT INTO csy_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus biakinn sung pan a pusua ciang in, a nungzui te sung pan khat in, Syapa awng, en in, hi suangtum te bangbang in kiphut le bangbang a kisa innpi te ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesus in ama kungah, Hi inn lianpui te na mu ziam? suangtum kithuap khat zong om nawn ngawl in ki lawnthal siat lai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesus biakinn ngalkhat Olive mualtung ah a to laitak in, Peter, James, John le Andrew te in, ");
INSERT INTO csy_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Hi thu te banghun ciang in piang tu ziam, hong son tan? ci in a tuam in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesus in amate tung ah, Kuama i hong theam ngawl natu in kidawm vun: ");
INSERT INTO csy_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Banghangziam cile ka min taw mi tampi hongpai tu uh a, keima in Christ ka hihi; ci in mi tampi theam tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Taciang ngal ki do le ngal kisim natu thu te na zak uh ciang in thinngim heak vun: banghangziam cile tabang theampo sia a piang kul hamtang hi a; a tawpna tu hi ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Banghangziam cile minam khat le khat kido tu uh a, kumpingam khat le khat ki sim tu hi: mun tatuam ah zinling tu a, kial le haksatna te om tu hi: hi te sia ngimna te i kipatna a hihi. ");
INSERT INTO csy_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Hi kamale noma le noma kidawm vun: banghangziam cile amate in hausa zum ah hong ap tu uh hi; taciang synagogue sungah zong hong vel tu uh a: keima hang in le amate atu tetti hitu in, ngam uk te le kumpi te mai ah hong paipui tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lungdamna thu sia minam theampo sungah ki son masa tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ahihang amate paipui in hong ap uh ciang, na pau tu uh ngaisun khol heak vun, ngeal zong ngealkhol heak vun: ahizong a hun ciang in hongpiak babang in pau vun: banghangziam cile tua te sia no i pau hi ngawl in, Tha Thiangtho hi. ");
INSERT INTO csy_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Unau zong thi tu in ki zuak tu hi, a pa zong in a tapa zuak tu a; tate in a nu le a pa ding in langpan tu uh a, thina ciangdong ki then tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Mi theampo in Keima min hang in hong ensan tu uh hi: hi kamale a tawp dong in a thuakzo sia, ki ngum tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ahihang kamsang Daniel sonkholna bang in a lipkhaphuai sia a kilawm ngawl na mun ah na mu uh ciang in, (a sim te in tel ta uh hen) Judah ngam sungah a omte mual tung pan in tai tahen: ");
INSERT INTO csy_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Innkhum tung a omte inn sungah van la tu in tuaksuk nawn heak hen: ");
INSERT INTO csy_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Lo sung a omte in a puan la tu in cia nawnheak hen. ");
INSERT INTO csy_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ahihang tua ni ciang naupai te le nau noailuai te haksa mama tu uh hi! ");
INSERT INTO csy_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Na tai tu uh hun sia phalbi sung a hi ngawl natu in thungen vun. ");
INSERT INTO csy_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Banghangziam cile tua hun ciang hong theng tu ngimna sia, Pathian in a kipatcil bitphuana pan kipan tuning dong om ngei ngawl lai a, maisang ah zong om kik nawn ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tua hun le ni te Topa in tomsak ngawl hile, kuama suakta ngawl tu hi: ahihang a tealsa te atu in, tua ni te tomsak hi. ");
INSERT INTO csy_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Taciang khatpo in, en vun, Christ ziak ah om hi; a hibale, zesung ah om hi; hong ci le um heak vun: ");
INSERT INTO csy_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Banghangziam cile Christ phaw sil te le leilot kamsang te hong theng tu uh a; a hi thei le a tealsa te zong theam tu in musakna le nalamdang tampi lak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ahihang kidawm vun: en vun, hi thu te hong sonkhol zo khi hi. ");
INSERT INTO csy_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ahihang haksatna teng zawk, tua hun le ni te sungah, ni hong mial tu a, tha zong tang ngawl tu hi, ");
INSERT INTO csy_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Van ah aksi te zong tak tu a, vantung vangletna te zong ki thing tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuazawkciang in mihing Tapa sia minthang vanglian taw meingo pan hong tuak amate in mu tu uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Taciang leitung mongkhat pan in van mongkhat dong, leitung kingli pan a tealsa te kaikhawm tu in, Ama vantungmi te sawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Theikung pan in sontena khat sin vun; a bak te pan in a dawnmoi te hong sua ciang khal hong nai zo hi, cina he uh hi: ");
INSERT INTO csy_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tasia bangma in hibang te na mu uh ciang in, a hun hong nai mama zo a, kongbiang kung tatak ma hong theng zo hi, ci he tavun. ");
INSERT INTO csy_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A tatak kong ci ciang, hibang te theampo a piansiat mateng, hi suan le pal te bo siat ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Van le lei bo tu hi: ahihang ka kammal te a bo bua tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ahizong tua ni le hun sia kuama in he ngawl hi, vantungmi te in zong he ngawl hi, Ka Pa bek in he hi. ");
INSERT INTO csy_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kinging khol vun a, ngak in thungen vun: banghangziam cile a hun na he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Banghangziam cile, mihing Tapa sia, khual khuala mama a haw khat, a inn a om naseam te thuneina pia in, mi theampo amate nasep tek seam tu le kongcing te zong cingsak in a nusia pa taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Tua ahikom, note ngak nginge vun, banghangziam cile, innteakpa sia nitak sang, a hibale zan laitak, a hibale akkhuan hun, a hibale zingsangkuan, banghun theng tu ci na he bua uh hi: ");
INSERT INTO csy_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A hibale thakhatthu hong theng le na mut laitak hong si tu hi. ");
INSERT INTO csy_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ngak nginge vun, ci note kong son bang ma in, mi theampo son khi hi. ");
INSERT INTO csy_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Paisanpoai le tolsaw ngawl anluum poai tu, ni ni a kisap ciang in: thiampi lian te le thukhamhil te in Jesus sia bangbang man in that thei tu ci thimtheltak in kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ahihang amate in mipi te buaisak ngawl in poai ni ci bua tawng, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesus sia Bethany khua miphak Simon inn ah anne in a om laitak, numei khat a manham mama alabaster sathau namtui thawl khat keng in hongpai a, a palang sutham in, Jesus lutung ah buak hi. ");
INSERT INTO csy_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tua mun ah a om pawlkhat te a thin-uk uh a, banghang in hi sathau namtui sia pakvawt ziam? ");
INSERT INTO csy_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Banghangziam cile ta sia dangka zathum sang in a tamzaw taw zuak in, mizawng te pia leang pha hi, ci uh hi. Taciang amate in numei nu langpan in phun uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus in, Ama thu in omsak po vun; banghang in nawngkaisak nu ziam? ama in ka tungah na pha vawt hi. ");
INSERT INTO csy_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Banghangziam cile mizawng te sia noma taw om tawntung hi, taciang na ukhun uh po in amate tungah napha vawt thei nu hi: ahihang kei ka hile no kungah hong om tawntung ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ama in a vawt thei za vawt hi: ka luanghawm vui natu ama in sathau namtui buakkhol hi. ");
INSERT INTO csy_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A tatak in ka ci ciang, leitung mun tatuam lungdamna thu ki son na theampo ah hi numei nu i vawt thu zong ama phaw tawntung natu in kison tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Taciang, nungzui sawmleni sung pan khat, Judah Iscariot sia, thiampi lian te kungah Jesus ap tu in pai hi. ");
INSERT INTO csy_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Amate in a zak uh ciang in, lungdam mama uh a, dangka piak tu in kamciam pia hi. Taciang ama in bangbang ap thei tu, ci hunpha zong tawntung hi. ");
INSERT INTO csy_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Paisanpoai tuuno ki ngaw ni, tol saw ngawl anluum poai ni masabel ni in, a nungzui te in Jesus kungah, paisanpoai na anneak natu mun koisung ah pai in vawtkhol tu dei ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tasiaciang a nungzui te ni sawl a, Khuapi sungah pai tavun a, tuibeal taw tui pua khat mu tu nu hi: ama zui vun. ");
INSERT INTO csy_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ama tum na innteakpa kungah, Syapa in, ka nungzui te taw paisanpoai an ka neak natu mun leangna inndoi koisung ziam? ci vun. ");
INSERT INTO csy_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tua hile ama in inntung doituam zai mama eite atu in, a ki puakholsa in a om hong lak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","A nungzui te pai uh a, khuapi sung a thet uh ciang in, Jesus sonkhol bang in mu uh hi: amate in paisanpoai atu in vawtkholsiat uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Taciang nitak sang ciang in Jesus a nungzui sawmleni te taw hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Amate to uh a an a neak tek uh laitak in, Jesus in, A tatak kong ci ciang, note sung pan khat, keima taw anne sia in hong leheak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tasiaciang amate khuangai mama uh a, khat zawkciang khat in Jesus kungah, kei ka hi ziam? a dang khat in, kei ka hi ziam? ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesus in amate tung ah, Sawmleni sung pan khat, keima taw kuangsung ah a sawkkhawm sia hi. ");
INSERT INTO csy_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ama thu a ki atkholsa bang in: mihing Tapa sia pai hamtang tu hi, ahihang mihing Tapa a leheak sia, a mailam bing hi! piang bua zaw le ama atu phazaw hi, ci zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Amate a neak tek uh laitak, Jesus in anluum la a thupha a piak zawkciang in, phel hi, taciang amate pia a, La vun a, ne vun: hisia in ka pumpi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Taciang hai zong la a, lungdam a ko zawkciang in, amate pia hi: taciang a vekpi in dawn tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Taciang amate tung ah, Hisia in thuciamthak taw kisai in mi tampi atu a luang ka thisan a hihi. ");
INSERT INTO csy_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A mantak ka ci ciang, hibang sapittui thak sia, ka Pa kumpingam sungah note taw ka dawn kik mateng bangmahun in ka dawn nawn batu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Taciang amate la asak zawk uh ciang in, Olive mualtung sangah paito uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Taciang Jesus in amate tung ah, Tuucingpa ka that tu a, tuu te peakkeak siat tu hi, ci a ki atkhol bangma in, tu zan in note theampo in keima hang in na thin uh no mama tu hi. ");
INSERT INTO csy_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ahihang ka thawkik zawkciang in, Galilee ah note mai ah pai tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ahihang Peter in, mi theampo nangma hang in thinkiam siat kale, kei thinkiam ngawl het tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesus in, A mantak kong ci ciang, tuni, tuzan mama in, ak nivei a khuan ma, thumvei hong nial tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter in nangma taw thi tu ahizong hong nial ngawl tu khi hi, ci in khotak in ci hi. Tasia bangma in a dangte theampo in zong ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Amate Gethsemane a kici huan ah theng uh hi: taciang a nungzui te kungah, Ka thunget lan ziak ah to hi vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jesus in, Peter, James le John te paipui a, lungmann ale nasiatak in thinngimna hong kipan hi. ");
INSERT INTO csy_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Taciang amate tung ah, Ka thin sia thi tu za dong in nasiatak in khuangai hi: hi mun ah om in ngak nginge vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Taciang a maisang tawm pai lai a, lei ah bok in, a suak thei a hile, hi hun taw a ki peal thei natu in thungen hi. ");
INSERT INTO csy_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Taciang, Abba, Pa awng, nang atu in na theampo hi thei hi; hi hai ka kung pan hong laksak tan: ahihang keima deina bang hi ngawl in nangma deina bang hi zaw tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Taciang Jesus hongpai a, amate mut laitak mu hi, taciang Peter kungah, Simon, mu na hi ziam? nai khat sungbeak zong ngak zo ngawl na hi ziam? ");
INSERT INTO csy_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ze-etna sungah na tum ngawl natu in thungen in ngak vun. Thaa sia uk mama hi kale cilesa sia a thaneam hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Taciang Jesus paikik a, a nget sa bangma in ngen leleau hi. ");
INSERT INTO csy_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jesus a heakkik ciang in, amate mutthip leleau mu hi, banghangziam cile amate mitte ngit mama hi, amate in bangba zo kik tu ci zong a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Thumvei na hongpaikik ciang in, amate tung ah, Tu in mu vun a, tawlnga vun: hisia in pha zo hi, a huncing hi zo hi; en vun, mihing Tapa sia mawnei te khut ah leheak hun theng zo hi. ");
INSERT INTO csy_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tho vun a, pai tawng; en vun, Keima hong leheak pa hong theng zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tabang a pau laitak, thakhatthu in, nungzui sawmleni sung pan khat, Judas Iscariot sia, thiampi lian te, thukhamhil te le upa te taw hongpai hi. ");
INSERT INTO csy_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jesus a leheak pa in, ka nap sia Ama hi, man vun a; paipui vahiat vun, ci in heaksakna piakhol hi. ");
INSERT INTO csy_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas hong thet pociang, Jesus kungah hongpai suak a, Syapa, syapa awng; ci in nam hi. ");
INSERT INTO csy_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Taciang amate in Jesus man uh a, paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Taciang a kiim a ding te khat in namsau dawk in, thiampi sangbel pa naseam pa sat ahikom a bil tawng hi. ");
INSERT INTO csy_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesus in amate tung ah, Banghang in nguta man tu bang in namsau le moltum taw keima man tu in hongpai nu ziam? ");
INSERT INTO csy_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Biakinn sungah thuhil in nisim note taw om hi napi, hong man ngawl nu hi: ahihang laithiangtho sia tangtung hamtang tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tasiaciang amate a vekpi in Jesus nusia uh a, tai siat uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tua mun ah tangval khat, puanneal khat bek sil in Jesus nung zui a, tangval te in ama man ahikom: ");
INSERT INTO csy_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","A puanneal sia nusia in, amate kung pan a pumnguak in tai keak hi. ");
INSERT INTO csy_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Amate in Jesus sia thiampi sangbel pa kungah paipui uh a: ama taw thiampi lian te, upa te le thukhamhil te kaikhawm tek hi. ");
INSERT INTO csy_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Taciang Peter in thiampi sangbel pa leitual dong a khuala na pan zui a: naseam te taw mei oai in to khawm hi. ");
INSERT INTO csy_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Thiampi lian te le tangpi upa te theampo in Jesus thalup thei natu in a man ngawl tetti te zong napi; a mu bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","A man ngawl tetti tu tam mama hongpai napi, amate tetti pan nate a thu uh ki si ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pawlkhat te ding in a man ngawl tettipang uh a, ");
INSERT INTO csy_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Khut taw a kisa hi biakinn ka pheltham tu a, khuttawsak ngawl a dang biakinn nithum sung sa tu khi hi, a ci za khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ahihang amate tetti pan nate sia a thu uh kisi thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Thiampi sangbel pa a lai ah ding a, Jesus kungah, bangma zo kik ngawl tu ni ziam? hi te in bangbang in nang hong langpan in tettipang ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ahihang Jesus huthe ngawl in om a, bangma zong zo kik ngawl hi. Thiampi sangbel pa in, nangma sia Christ a kici, thupha taw a dim Pathian Tapa na hi ziam? ci in dong kik hi. ");
INSERT INTO csy_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesus in, Hi khi hi: mihing Tapa vangletna ziatsang ah to in meingo sung pan hongpai na mu tu uh hi, ");
INSERT INTO csy_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tasiaciang thiampi sangbel pa in a puan eaukeak a, tetti dang bang kul nawn ziam? ");
INSERT INTO csy_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pathian a sonsiat na za zo nu hi: bangbang ngaisun nu ziam? ci hi. Amate theampo in, thi tu kilawm mawna nei hi, ci in mawsiat tek uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pawlkhat te in Jesus sia cilphi hi, a mai humsak uh a vel in, a vel sia kamsang bang in pualak in, ci uh hi: naseam te in a khutpheak taw beang uh hi. ");
INSERT INTO csy_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter sia a nuai sang leitual ah a om laitak in, thiampi sangbel pa naseam te sung pan khat hongpai a: ");
INSERT INTO csy_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Tua nu in Peter mei oai a mu ciang in, en a, nangma zong Nazareth mi Jesus taw om nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ahihang ama in, he ngawl khi hi, bang son ni ziam ci zong he ngawl khi hi, ci in nial hi. Taciang ama a puasang ah pusuak a, akkhuang hi. ");
INSERT INTO csy_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Naseam numei nu in mu leleau a, a kung a ding te kungah, hisia pa zong amate sungah ki hel hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Taciang Peter in nial leleau hi. Tuazawk a ngei ngawl in, a kung a ding te in Peter kungah, nangma sia amate sungah kihel lalawm ni hi: banghangziam cile nangma sia Galilee mi ni hi, na kampau pan ki he hi, ci leleau hi. ");
INSERT INTO csy_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ahihang Peter in, kiciam in, na son uh sia pa he ngei ngawl khi hi, ci in kiciam hi. ");
INSERT INTO csy_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Taciang ak a ni veina khuang hi. Taciang Peter in Jesus i sonkhol, ak nivei a khuan ma thumvei hong nial tu ni hi, a ci thu phawkkik hi. Taciang tua thu a ngaisut ciang in kap hi. ");
INSERT INTO csy_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Zingsang ciang in thiampi lian te in upa te, thukhamhil te le thunei te teng taw manlangtak in thu kikupna nei uh hi, taciang Jesus lehhen in paipui uh a, Pilate kungah ap uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate in, nangma in Judah mite Kumpipa na hi ziam? ci in dong hi. Ama in, Na ci bang in ka hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Thiampi lian te in thu tatuam taw Ama mawsiat uh ahihang: bangma zo kik ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Taciang Pilate in, bangma zo kik ngawl tu ni ziam? en in, amate in nangma mawsiat na bangzata tettipang uh ziam, ci dong hi. ");
INSERT INTO csy_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ahihang Jesus in bangma zo kikngawl ahikom; Pilate in lamdangsa mama hi. ");
INSERT INTO csy_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tua poai sungah amate in thongtak te sung pan, mipi te i dei khat papo suatak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Taciang ngaltho a, tualthat pa Barabbas a kici khat om hi, ama sia ngaltho dang te taw thongtak hi. ");
INSERT INTO csy_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mihonpi te in a vawt ngei uh bangma in vawtsak tu dei in, a nging tatak in au kipan uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ahihang Pilate in, Judah te Kumpipa ka suatak tu na dei uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Banghangziam cile ama in Jesus sia thiampi lian te in a el uh man in hong ap hi, ci he nginge hi. ");
INSERT INTO csy_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ahihang thiampi lian te in mihonpi te, Barabbas suatak zaw tu in holku uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Taciang Pilate in amate tung ah, Judah te Kumpipa a kici pa bang law tu khi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Taciang amate in, thinglamte tungah khai in, ci in au kik uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Taciang Pilate in amate tung ah, banghang ziam, bang mawna vawt ziam? ci hi. Amate in thinglamte tungah khai in, ci in au seseam uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate in mipi te lungkimsak nuam ahikom, Barabbas suatak a, Jesus a vel zawkciang in, thinglamte tungah khai tu in ap hi. ");
INSERT INTO csy_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ngalkap te in Jesus Pilate inn ah tumpui uh a; ngalkap theampo munkhat ah sam hi. ");
INSERT INTO csy_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Taciang amate in Jesus puan sannum silsak uh a, ling kipheak lukhu a lu ah khusak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Tuazawkciang, Judah te Kumpipa! thuphatoai ta in, ci in zatakna pia uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Amate in phaikung taw a lu pan vel uh hi, cilphi uh a, khupdin in bia uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Amate in a selno zawk uh ciang in, puan sannum a silsak uh sia sutsak kik uh a, Ama puansil te silsak kik uh hi, taciang thinglamte tungah khai tu in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alexander le Rufus te i pa, Cyrene ngam mi Simon sia, khuano pan hongpai a, lamkal ah ama a mu uh ciang zawthawk thu taw thinglamte puasak uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Amate in Jesus sia Golgotha a kici, lu ngu mun ah paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Amate in myrrh taw a ki hel sapittui pia uh ahihang: Jesus in sang nuam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Amate in thinglamte tungah a khai zawk uh ciang in, a puan te khen uh a, mi khatsim in a nga tu uh tek aisan in hawm uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Tabang in thinglamte tungah a khai uh sia zingsang nai kua a hihi. ");
INSERT INTO csy_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ama mawsiatna lai tak uh a, judah te kumpipa, ci in a tungah at uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Taciang Ama taw nguta ni te sia; a ziatsang ah khat le a veisang ah khat, thinglamte tungah khai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Taciang Ama sia mawnei te taw ki sim khawm hi, ci laithiangtho tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Lampi a tawn peuma in nu nau uh a, lupei in, biakinn phel in, nithum sung a sa kik tu pa, ");
INSERT INTO csy_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nangma le nangma ki hun in a, thinglamte tung pan hong tuaksuk tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tabangma in thiampi lian te le thukhamhil te in zong, hisia pa sia ngualdang ngum thei a; ama le ama ki ngum thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Israel te Kumpipa, Christ sia thinglamte tung pan tu mama in tuaksuk hen a, tabang in ka mu le um tu khu hi, ci in selno uh hi. Taciang Ama taw thinglamte tung a ki khai te in zong selno uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sun nai sawmleni pan nitak sang nai thum dong leitung theampo khuazing hi. ");
INSERT INTO csy_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nitak sang nai thum ciang in Jesus a nging tak in, ELOI, ELOI, LAMASABAKTANI? ci in au hi. A khiakna sia, Ka Pathian, Ka Pathian awng, banghang hong taisan ni ziam? a cinopna a hihi. ");
INSERT INTO csy_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tua mun ah a ding pawlkhat te in a zak uh ciang in, En vun, ama in Elijah sam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Amate sung pan khat hong tai a, tuihup puan la in sapittui hau sungah pap suk a, phaikung dawn ah a sawm zawkciang, Jesus dawn tu in pia hi, Koi hi po in; Elijah hongpai in a khiasuk ziam, en hi tawng, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesus a ngingtak in a au zawkciang thi hi. ");
INSERT INTO csy_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Taciang biakinn sungah kidoi na puan sia a lu pan a taw dong ki zensuk a, khen ni ki sua hi. ");
INSERT INTO csy_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Taciang, Jesus au in, thi ci amai a ding ngalkap mangpa in a mu ciang in, hisia pa sia Pathian Tapa tatak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Numei te in a khuala na pan in ngal-et uh a: amate sungah Mary Magdalene, James a no le Joses te nu Mary le Salome; ");
INSERT INTO csy_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Amate Jesus Galilee ngam a om lai in a nungzui te le a khoi te a hi uh hi; Jesus taw Jerusalem ah a pai khawm numei dang tampi te zong om hi. ");
INSERT INTO csy_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tua ni sia sabbath ni a thet ma, ki ngin ni hi a, nitak sang ciang in, ");
INSERT INTO csy_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","A zatak huai ngaisutna pia le Pathian kumpingam a ngak Arimathaea khua mi Joseph hongpai a, hangsantak in Pilate kungah pai hi, taciang Jesus luanghawm ngen hi. ");
INSERT INTO csy_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilate in Jesus thi zo hi, a ci uh ciang lamdangsa mama hi: ngalkap mangpa sam a, Jesus a thi zawk ngei zom ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ngalkap mangpa kung pan a heak ciang in Jesus luanghawm Pilate in Joseph pia hi. ");
INSERT INTO csy_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Taciang Joseph in puanneal lei a, Jesus khiasuk in, puanneal taw tuam hi, taciang a ki to tawm suang hawng sungah vui a, than kongkha ah suangtum lik hi. ");
INSERT INTO csy_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene le Joses nu Mary te in Jesus a vui na mun en uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabbath ni a bo ciang in, Mary Magdalene, James nu Mary le Salome te hongpai uh a, Jesus luanghawm zut tu sathau namtui te keng uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nipikal khat sung ni masabel ni zingtung, ni sua ciang in, amate than ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Taciang amate in than kongkha a suangtum sia kua in hong liksak tu ziam? ci in kikum kawm uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Amate in a et uh ciang in, suangtum a ki lik sa in mu uh hi: banghangziam cile tua suangtum sia lian mama hi. ");
INSERT INTO csy_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Than sung a tum uh ciang in, tangval khat puanpak tualpui sil in ziatsang ah a to, amate in mu uh a; lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ama in numei te kungah, lau heak vun: thinglamte tung a ki khai Nazareth khua mi Jesus zong nu hi; Ama thokik zo hi; hi mun ah om nawn ngawl hi: Ama ki vui na hong en tavun. ");
INSERT INTO csy_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ahihang pai tavun a, a nungzui te le Peter kungah, na mai uh Galilee ah pai hi, ci in son vun: note hong sonkholsa bangma in, tua mun ah mu tu nu hi, ci in son hi. ");
INSERT INTO csy_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Taciang amate than pan in manlangtak in pai uh a, tai kawm uh hi; banghangziam cile amate huang liang in lamdangsa mama uh hi: kuama kungah zong bangma son ngawl hi; banghangziam cile amate a lau uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus sia nipikal khat sung ni masabel ni zingtung a thawkik ciang in, a sung pan doai ngilo sali a hawlkhiatsak Mary Magdalene kungah kilang masabel hi. ");
INSERT INTO csy_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Taciang ama pai a, Jesus taw kithawl ngei in, a kap a tau te son hi. ");
INSERT INTO csy_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amate in, Jesus nungta hi, ci le Mary in mu hi, ci a zak uh ciang in, a um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tuazawkciang in amate sung pan mi ni, khuano sang a pai te kungah, Jesus meal lamdang in kilaak hi. ");
INSERT INTO csy_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Taciang amate pai in a dang te son a hi uh hang: amate in a um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tuazawkciang in, nungzui sawm le khat te anneakna mun ah a to uh laitak, Jesus hong kilang a, amate tei hi, banghangziam cile amate in a thawkik zawk a mu te i son te um ngawl in a thinpui uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jesus in amate tung ah, Note leitung theampo ah pai tavun a, piansakna theampo tungah lungdamna thu son tavun. ");
INSERT INTO csy_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Um in tuiphumna a sang peuma ngupna nga tu hi; ahihang a um ngawl te sia thukhenna thuak tu hi. ");
INSERT INTO csy_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","A umte sia hibang musakna te in zui tu hi; ka min taw doai te hawlkhia tu uh a; kam thak taw pau tu uh hi; ");
INSERT INTO csy_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ngul te zong man tu uh a; ngu a ne hial uh zong, bangma tat ngawl tu hi; cina te tungah a khut uh te nga tu uh a, dam tu hi, ");
INSERT INTO csy_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Topa in amate thu a son zawkciang in, Ama sia van ah ki la to a, Pathian ziatsang ah to hi. ");
INSERT INTO csy_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Amate pai uh a, mun theampo ah thuhil uh hi, Topa amate taw naseam a, a thuhilna uh te nalamdang te in zui in kipsak hi. Amen. ");
INSERT INTO csy_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kote sungah thu piang te mitampi in a ban a ban in at zo a, tua thu tangkona te sia ka up bel uh a hihi, ");
INSERT INTO csy_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","A kipatcil pan in mitmu tetti te le Pathian kamal naseam te i hong son bang in a ki at a hihi; ");
INSERT INTO csy_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A masabel pan in thu theampo a cialcing in he ka hikom, na tungah a ban a ban in hong at leng pha tu hi, ci ngaisun khi hi, a thupibel Theofilas awng, ");
INSERT INTO csy_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nangma hong hil sa thu te a kip a kho thei natu in hong at khi hi. ");
INSERT INTO csy_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judah kumpipa Herod hun lai in, Zacharias a kici thiampi khat om a, ama sia Abijah i thiampi pawl sungah kihel hi: a zi min sia Elizabeth hi a, Aaron suan a hihi. ");
INSERT INTO csy_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Amate ni sia Pathian mai ah mi thutang te hi uh a, thupiak te le biakna ngeina te paubang ngawl in a zui te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amate in ta a nei bua uh hi, banghangziam cile Elizabeth sia ciing hi, taciang amate a ni ma in a kum uh zong ham zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Zecharias sia ama pawl te taw a nasep hun cing a Pathian mai ah thiampi nasep a sep laitak in, ");
INSERT INTO csy_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Thiampi te ngeina bang in aisan in ki teal uh a, Zecharias sia Topa biakinn sung tum a ciang in ngimnamtui hal tu a hihi. ");
INSERT INTO csy_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ngimnamtui a hal laitak in mihonpi theampo a puasang ah thungen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Topa vantungmi khat a kungah hong kilang a, ngimnamtui hal na mun biaktau ziatsang ah ding hi. ");
INSERT INTO csy_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah in ama a mu ciang in, patau a, a tungah launa theng hi. ");
INSERT INTO csy_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ahihang vantungmi in, Zechariah: lau heak in, Pathian in na thungetna hong za zo hi, taciang na zi Elizabeth in tapa hing tu a, a min sia John, phuak tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Lungdamna le thinnopna nei tu ni hi; a sua ciang in mi tampi te zong lungdam tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Banghangziam cile ama sia Topa mai ah mi thupi hi tu hi, sapittui ahizong, zu ahizong, dawn ngawl tu hi; a nu ngil sung pan ma in Tha Thiangtho taw kidim tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Israel mi tampi te zong amate Pathian Topa kungah heakkiksak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elijah i thaa le vangletna taw Topa mai ah pai tu a, pa te le ta te i thinsung te ahizong, thu ni ngawl te mi thuman te i ciimna ah ahizong; Topa atu in mihing te kinging kholsak le ki thoaikholsak tu in heakkiksak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah in vantungmi kungah, nong son bang in piang takpi tu hi, ci bangbang in he tu khi ziam? banghangziam cile keima sia pasal huai ka hihi, taciang ka zi zong huai mama zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tasiaciang vantungmi in, keima sia Pathian mai ah a ding Gabriel ka hihi; nangma paupui tu le lungdamna thu son tu in hong sawl hi. ");
INSERT INTO csy_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Taciang, en in, hi thu te a pian ni dong pau thei ngawl tu ni hi, banghangziam cile amate hun ciang a tangtung tu ka thu na up ngawl hang a hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mipi te in Zechariah ngak uh a, biakinn sungah ngei mama om ahikom in, lamdangsa uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Biakinn sung pan a pusua ciang in amate tungah bangma son thei ngawl hi: taciang biakinn sungah mangmu hi, ci amate in he uh hi: banghangziam cile a khut taw lak a, pau thei tuan ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Thiampi nasep ni te a khuangkhim po ciang in Zechariah sia a inn ah cia hi. ");
INSERT INTO csy_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tuazawkciang in a zi Elizabeth naupai a, tha nga sung bu hi, ");
INSERT INTO csy_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Tua ahikom Elizabeth in, Topa in keima atu in hi thu hong vawtsak hi, mihing te sungah zawnsakna ka thuak nate hong laksak tu in Ama in hong ve zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tha luk a cin ciang in, Pathian in vantungmi Gabriel sia Galilee ngam Nazareth khua ah a om, ");
INSERT INTO csy_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ngaknu thiangtho khat, David suan Joseph taw nupa tu in zuthawl piaksa, Mary kungah paisak hi. ");
INSERT INTO csy_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Vantungmi a kungah hongpai a, na tungah thupha om tahen, nangma sia a thupi mama maipha nga na hihi, Topa nang taw hong om hi: numei te sungah thuphatoai na hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ama in vantungmi a mu ciang, a sonthu hang in a thinsung buai a, bangbang paupuina hi tu ziam, ci ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Taciang vantungmi in, Mary awng, lau heak in, banghangziam cile Pathian mai ah maipha nga zo ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","En in, nau na pai tu a, tapa nei tu ni hi, taciang a min Jesus phuak tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ama sia mi thupi hi tu a, A sangbel i Tapa, kici tu hi: taciang Topa Pathian in a Pa David i kumpi tokhum pia tu hi: ");
INSERT INTO csy_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ama in Jacob suan te a tawntung in uk tu a; Ama ukna sia tawp hun nei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary in vantungmi kungah, bangbang piang thei tu ziam, keima in pa taw ki he ngei ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Vantungmi in zo kik a, Tha Thiangtho na tungah hong theng tu a, A sangbel i vangletna in hong tuam tu hi: tua ahikom na sung pan in a suak tu tapa thiangtho sia Pathian Tapa kici tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","En in, na mealheak Elizbeth, a ciing ci in ngual i son ngei sia a kum ham zawkciang in tapa pai hi: tu in tha luk pha zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Banghangziam cile, Pathian taw a piang thei ngawl bangma om ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary in, keima sia Topa i sal nu ka hihi; ka tungah na ci bang in hi tahen, ci hi. Taciang vantungmi a kung pan in paikhia hi. ");
INSERT INTO csy_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tua hun in, Mary ding a, Judah ngam huam mualtung khua ah manlangtak in pai hi; ");
INSERT INTO csy_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zechariah innsung ah tum a, Elizabeth paupui hi. ");
INSERT INTO csy_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Taciang, Elizabeth in Mary paupuina a zak ciang in a ngil sungah nauno tawn hi; taciang Elizabeth sia Tha Thiangtho taw kidim a: ");
INSERT INTO csy_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Aw ngingtak taw, nangma sia numei te sung pan thuphatoai na hihi, taciang na ngilsung a om nauno zong thuphatoai a hihi. ");
INSERT INTO csy_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Bangbang in ka Topa i nu sia kei kungah hongpai ziam? ");
INSERT INTO csy_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Banghangziam cile, en in, nong paupui na aw ka zak pociang, ka ngil sungah nauno sia lungdamna taw tawn hi. ");
INSERT INTO csy_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A um nu sia thuphatoai a hihi: banghangziam cile tua thu te Topa in ama a son bang in vawt tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mary in, ka nuntakna in Topa lamsang hi, ");
INSERT INTO csy_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Keima hong Ngum Pathian tungah ka thaa a lungdam hi. ");
INSERT INTO csy_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Banghangziam cile, nunniam kei a salnu hong ve hi: en vun, tu pan kipan in khangkhat zawk khangkhat, thuphatoai nu, hong kici tu hi. ");
INSERT INTO csy_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Banghangziam cile a vanglian Pathian in keima atu in a thupi mama te vawt zo hi; taciang a min thiangtho hi. ");
INSERT INTO csy_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","A hesuakna sia ama a zakta te tungah khangkhat zawk khangkhat om tawntung hi. ");
INSERT INTO csy_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ama in a ban taw a thahatna hong lak zo a; a ki phasak te thinsung ngaisutna zong ki thethangsak siat zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ama in a vanglian te amate tokhum pan in a nuai ah khiasuk zo a, mi nunniam te domto zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ama in a ngilkial te thupha te taw ngilvasak zo a; a hau te khut hawm taw ki heamsak hi. ");
INSERT INTO csy_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ama in a hesuakna phawk tawntung in a sal Israel hu zo hi; ");
INSERT INTO csy_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","I pu i pa te kungah a sonsa bangma in, Abraham le a suan te hu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Taciang Mary sia Elizabeth kungah tha thum sung om a, ama inn ah ciakik hi. ");
INSERT INTO csy_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elizabeth nau sua tu hun a cin ciang in tapa nei hi. ");
INSERT INTO csy_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elizabeth kungah Topa hesuakna lianpi kilang ci a innpam te le a mealheak te in a zak uh ciang in lungdampui tek mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nausen ni liat a cin ciang in vunteap tan tu in hongpai a, a pa min zui in, Zechariah, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","A nu in, hi ngawl hi; a min John kici tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Amate in, na phung sung uh ah hibang min nei kuama om ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Taciang amate in a pa khut taw lak uh a, bangbang ci nuam ni ziam, ci dong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah in lai at natu ngen a, a min sia John hi, ci at hi. Taciang a vekpi in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Taciang thatkhatthu in a kam ki hong in a lei hong suakta kik ahikom, pau in Pathian pok hi. ");
INSERT INTO csy_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A kim a om theampo tungah lau na hong theng a; tua thu sia Judah kual mualtung khuano theampo ah ki zel hi. ");
INSERT INTO csy_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tua thu a za theampo in amate thinsung tek ah keam uh a, hisia bangbang nausen hi peuma tu ziam! ci tek uh hi. Taciang Topa khut sia Ama tungah om hi. ");
INSERT INTO csy_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","John i pa Zechariah sia Tha Thiangtho taw kidim hi, taciang maisang thu a pualak na ah, ");
INSERT INTO csy_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Israel te Topa Pathian minthang tahen; banghangziam cile a mite ve in hun zo hi, ");
INSERT INTO csy_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eite atu in ngupna kii sia a sal David inn sung pan in hong suaksak zo hi; ");
INSERT INTO csy_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Leitung kipat lai pan in kamsang thiangtho te kam zang in son zo hi: ");
INSERT INTO csy_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I ngal te le hong ensan te khutsung pan in eite ngum tu in ahizong; ");
INSERT INTO csy_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I pu i pa te tungah vawt tu in thu a ciam sa hesuakna le thuciam thiangtho phawk tawntung tu in ahizong; ");
INSERT INTO csy_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I pa Abraham tungah a kiciamna thukham, ");
INSERT INTO csy_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eite tungah pia tu le i ngal te khutsung pan in hong suaktasak tu a, lau na om ngawl in, ");
INSERT INTO csy_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","I nuntaksung theampo Ama mai ah thianthona le thutang suana taw Ama na i sep thei natu a hihi. ");
INSERT INTO csy_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Taciang nang, nausen, A sangbel i kamsang, hong ci tu hi: banghangziam cile Topa mai ah a lampi puakhol tu in pai tu hi; ");
INSERT INTO csy_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","A mite tung ah, amate mawna pan in mawmaisak na tungtawn in ngupna thu hesak tu in, ");
INSERT INTO csy_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","I Pathian i a neam thuthiamna tungtawn in; van pan zing nisuak bang in hong ve zo hi, ");
INSERT INTO csy_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Khuazing le thina lim sungah a to te khuavak pia tu le eite i peang te thinnopna lampi ah hong makai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nausen sia khang a, thaa lam ah thahat hi, Israel te kungah a kilaak mateng duisung ah om hi. ");
INSERT INTO csy_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tua hun laitak in Caesar Augustus in leitung bup misimna vawt tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Hi misimna masabel a vawt laitak in Syrenius sia Syria ngam uk a hihi. ");
INSERT INTO csy_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Taciang mi theampo misimna nei tu in amate khua tek ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph zong Galilee ngam, Nazareth khua pan in David khua, Judah ngam Bethlehem khua ah pai hi; banghangziam cile ama sia David i suan le minam a hihi: ");
INSERT INTO csy_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Misimna nei tu in dokzu a piaksa Mary taw pai uh hi, Mary sia naungil lian mama zo hi. ");
INSERT INTO csy_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Bethlehem ah a om uh laitak in, Mary a naunei tu ni hong cing hi. ");
INSERT INTO csy_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A tacil tapa hong nei a, puan taw a tun zawkciang, khui ankuang sungah sial hi, banghangziam cile zintun inn ah amate atu inndoi om nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tua ngamsung ah tuucing te duisung ah ngiak uh a, zan in a tuuhon te cing in om uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Taciang, en vun, Topa vantungmi amate kungah hongpai a, Topa vangletna sia amate kiim teng ah taang hi: taciang amate lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Vantungmi in amate tung ah, lau heak vun: banghangziam cile, en vun, note tungah lungdamna thu hong puak khi hi, tua thu sia mi theampo atu in lungdamna lianpi hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Banghangziam cile tuni in David khuapi sungah Ngumpa Christ Topa suak zo hi. ");
INSERT INTO csy_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hisia in note atu musakna a hihi; nausen sia puan taw tun a, khui ankuang sungah a kisial na mu tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Thakhatthu in vantungmi taw vantungmi honpi te Pathian pok uh a, ");
INSERT INTO csy_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Van a sangbel na ah Pathian minthang tahen, leitung ah thinnop na om tahen a, mihing te tungah deisakna pha om tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Vantungmi te amate kung pan van ah a heakkik zawkciang in tuucing te in, tu in Bethlehem khua ah pai tawng, Topa i hong heaksak thu en tawng, khat le khat kici uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Taciang manlangtak in pai uh a, Mary, Joseph le khui ankuang sungah a kisial nausen mu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tuucing te in ama a mu uh ciang in, vantungmi in hi nausen thu taw kisai amate a son thu te midang te tungah son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tuucing te i son thu te a za theampo in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ahihang Mary in hi thu te theampo, a thinsung ah keam in ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Vantungmi in amate tungah a son bang in, a zak uh le a mu uh thu te hang in tuucing te in Pathian vangletna le minthanna pok in heakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nausen sia vunteap tan tu ni liat a cin ciang, a min sia Jesus ci hi, tua min sia a nu in a ngilsung a pai ma in vantungmi i a phuakholsa min a hihi. ");
INSERT INTO csy_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mary sia Moses thukham bang in thianthona hun a cin ciang in, Topa kungah ap tu in nausen sia Jerusalem ah paipui hi; ");
INSERT INTO csy_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Topa thukham sungah, sulhong tapa masabel peuma Topa atu a thiangtho, kici tu hi; ci in ki at hi. ");
INSERT INTO csy_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Topa thukham sungah a om bangma in, khutun kop khat, a hibale khutheh ni taw biakpiakna piak tu a hihi. ");
INSERT INTO csy_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Taciang en vun, Jerusalem ah Simeon a kici pasal khat om hi; ama sia mi pha thutang le biakna sangah a ki pumpiak hi a, Israel te henepna a ngak khat zong a hihi: ama tungah Tha Thiangtho om hi. ");
INSERT INTO csy_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Topa i Messiah na mu mateng na thi buatu hi, ci in Tha Thiangtho in pualak hi. ");
INSERT INTO csy_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tha ompui na taw in Simeon sia biakinn sungah hong pai a: thukham ngeina bang in vawtsak tu in nulepa te in nausen Jesus paipui uh hi, ");
INSERT INTO csy_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon in nausen a kang ah toai a, Pathian pok kawm in, ");
INSERT INTO csy_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Topa awng, tu in, na thu bang in na sal keima thinnuamtak in hong paisak ta in: ");
INSERT INTO csy_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Banghangziam cile na ngupna ka mit taw mu zo khi hi, ");
INSERT INTO csy_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tua thu sia mi theampo mai ah na vawtsa a hihi; ");
INSERT INTO csy_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gentile te tung khuavaksak tu le na minam Israel te minthan natu a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeon pau nate sia Joseph le Mary te in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Taciang Simeon in amate thupha pia a, a nu Mary kungah, hi nausen sia Israel mitampi te lutu na le mitampi te ki phokkik na hi tu hi; banghangziam cile kam ki nial na musakna hi tu hi; ");
INSERT INTO csy_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hi hi, namsau in na nuntakna hong sun tu hi, taciang mitampi te thinsung ngaisutna te kilangsak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Asher suan, Phanuel tanu Anna a kici kamsang nu khat om a, ama sia huai mama zo hi: ama sia ngaknu thiangtho a hina pan in a pasal taw kum sali sung bek omkhawm hi; ");
INSERT INTO csy_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ama sia meingong hi a, kum sawm liat le kum li pha zo hi, biakinn pan pusuak ngawl in sun tawzan taw antang le thungen in Pathian naseam hi. ");
INSERT INTO csy_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jesus biakinn ah a thetpui laitak in Anna zong hong theng a, Topa tungah lungdam ko hi, taciang Jerusalem ah ngupna a ngakla te theampo tungah nausen thu son hi. ");
INSERT INTO csy_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph le Mary te in Topa thukham bang in na theampo a vawt zawk uh ciang in, Galilee ngam Nazareth khua ah ciakik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nausen hong khang a, thaa lam ah thahat in, ciimna taw dim a: Pathian hesuakna ama tungah om hi. ");
INSERT INTO csy_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesus i nulepa te kumsim paisanpoai ciang in Jerusalem ah pai bul uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesus kum sawm le kum ni a cin ciang in, Jerusalem ah ngeina bang in poai mun ah pai hi. ");
INSERT INTO csy_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Poai man ciang in a inn ah ciakik uh hi, ahihang nauno Jesus sia Jerusalem ah tanglai hi; Joseph le a nu in tua thu a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ahihang, mi honpi sungah hi tu hi, ci ngaisun uh a ni khat sung pai uh hi; taciang amate mealheak te le a ki naipui uh te sungah zong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Amate in a mu ngawl uh ciang in, Jerusalem ah heakkik in zong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nithum zawkciang in amate in biakinn sungah mu hi, doctor te laizang ah to a, thu ngai le thu dong in om hi. ");
INSERT INTO csy_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","A thu heak le a zo kik nate a za theampo in lamdangsa uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Amate in a mu uh ciang in lamdangsa mama uh a: a nu in, ka Tapa awng, banghang hibang in hong vawt ni ziam? en in, na pa taw thinngim mama in hong zong khu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesus in amate tung ah, Banghang in hong zong nu ziam? ka Pa nasep seam hamtang tu khi hi, ci he ngawl nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Taciang amate in a sonnop na a tel bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Taciang amate taw pai a, Nazareth ah ciakik in amate thu ni in om hi: ahihang a nu in Ama kampau te a thinsung ah keamcing hi. ");
INSERT INTO csy_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesus sia a ciimna le a pumpi khang a, Pathian mai le mihing te mai ah maipha nga hi. ");
INSERT INTO csy_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberius Caesar in ngam a uk zawk kum sawm le kum nga a cin ciang in, Pontius Pilate sia Judah ngam ukpa hi a, Herod sia Galilee ngam ukpa a hihi, taciang Herod nau Philip sia Ituraea le Trachonitis ngam ukpa a hihi, taciang Lysanias sia Abilene ngam ukpa a hihi, ");
INSERT INTO csy_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas le Caiaphas te sia thiampi sangbel hi uh a, tua hun sung in duisung ah a om Zechariah tapa John tungah Pathian thu theng hi. ");
INSERT INTO csy_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tua ahikom John sia Jordan ngun dung khuano te theampo ah maw ki sikkik na tuiphumna tungtawn in mawmaina thu hil hi. ");
INSERT INTO csy_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Kamsangpa Isaiah i kammal te laibu sungah a ki atsa bang in, duisung ah a au aw khat in, Topa i lampi puakhol vun, lampi te na tangsak vun. ");
INSERT INTO csy_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A kom na theampo dim vun a, mual sang le mualdung te theampo niamsak vun; a kingkoai theampo tangsak vun a, lampi ham theampo nealsak vun; ");
INSERT INTO csy_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Taciang mi theampo in Pathian i ngupna mu tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ama kungah tui ki phum tu in hongpai mihonpi te kungah, maw, ngul suan te, hong theng tu thin-ukna pan suakta tu in kua in note kidopna hong pia ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Taciang mawna ki sikkikna taw a kiphu in nga pha te nga tavun, kote in ka pa uh Abraham nei khu hi: ci heak vun, banghangziam cile Pathian in hi suangtum te Abraham suan suaksak thei hi, hong ci khi hi. ");
INSERT INTO csy_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tu in thingkung te a bul ah heipui ki koi zo hi: nga pha a nga ngawl thingkung peuma phuk tu a, meisung ah khia hi. ");
INSERT INTO csy_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Taciang mipi te in, tabang hithongle banglaw tu khu ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ama in, puansil ni a nei sia in a nei ngawl te pia tahen; an a nei sia in tabangma in vawt tahen, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Siadong te zong tui ki phum tu in hongpai uh a, Syapa awng, kote bangbang ngamta tu khu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Taciang ama in, a kiciangtan za sang in a tamzaw khon heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ngalkap te in zong tabangma in, kote e, bangbang ngamta tu khu ziam? ci in dong uh hi. Amate kungah, zawthawk thu taw mite tungah bangma ngamta heak vun, a manngawl pi in mite mawsiat heak vun; na nga uh thaman taw lungkim vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mite in lametna a nei tek uh bangma in, John sia Christ a hi le hi ngawl, mi theampo in amate thinsung ah ngaisun tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tua ahikom John in amate theampo tung ah, keima in a tatak in tui taw tuiphumna hong pia khi hi; ahihang kei sang in a vanglianzaw khat hongpai tu hi, a peangdap khau sutsak tu nangawn ka kilawm bua hi: Ama in Tha Thiangtho le mei taw baptisma hong pia tu hi: ");
INSERT INTO csy_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A khut sungah tangkheaplaw toai a, tangzap tu hi, tang pha te beam sungah thun tu a; tangsi te a hi le a mit ngei ngawl meitaw hal tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ama hanthotna sungah thudang tampi te zong mite tungah pualak hi. ");
INSERT INTO csy_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ahizong ngam uk Herod sia a naupa Philip i a zi, Herodias thu le a phangawl a vawt nate hang in John in tek hi, ");
INSERT INTO csy_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Taciang Herod in John sia thongtaksak a, tabang in mawna dang vawt thua belap hi. ");
INSERT INTO csy_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ngual theampo tui a ki phum zawk uh ciang in, Jesus zong tui ki phum a, thu a nget laitak in van ki hong hi, ");
INSERT INTO csy_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Tha Thiangtho sia vakhu bang in a tungah tuaksuk hi, taciang van pan in aw khat hong theng a, Nangma sia ka it mama Ka Tapa ni hi; na tungah ka lungkim mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Tua hun in Jesus sia kum sawmthum hong cing hi, Ama sia mihing ngaisut na bang in Joseph tapa hi a, Joseph sia Heli tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli sia Matthat tapa hi, Matthat sia Levi tapa hi, Levi sia Melchi tapa hi, Melchi sia Janna tapa hi, Janna sia Joseph tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph sia Mattathias tapa hi, Mattathias sia Amos tapa hi, Amos sia Nahum tapa hi, Nahum sia Esli tapa hi, Esli sia Nagge tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagge sia Maath tapa hi, Maath sia Mattathias tapa hi, Mattathias sia Semei tapa hi, Semei sia Joseph tapa hi, Joseph sia Judah tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judah sia Joanan tapa hi, Joanan sia Rhesa tapa hi, Rhesa sia Zerubbabel tapa hi, Zerubbabel sia Shealtiel tapa hi, Shealtiel sia Neri tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri sia Melchi tapa hi, Melchi sia Addi tapa hi, Addi sia Cosam tapa hi, Cosam sia Elmodam tapa hi, Elmodam sia Er tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er sia Jose tapa hi, Jose sia Eliezer tapa hi, Eliezer sia Jorim tapa hi, Jorim sia Matthat tapa hi, Matthat sia Levi tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi sia Simeon tapa hi, Simeon sia Judah tapa hi, Judah sia Joseph tapa hi, Joseph sia Jonan tapa hi, Jonan sia Eliakim tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim sia Melea tapa hi, Melea sia Menan tapa hi, Menan sia Mattatha tapa hi, Mattatha sia Nathan tapa hi, Nathan sia David tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David sia Jesse tapa hi, Jesse sia Obed tapa hi, Obed sia Boaz tapa si. Boaz sia Salmon tapa hi, Salmon sia Nahshon tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon sia Amminadab tapa hi, Amminadab sia Aram tapa hi, Aram sia Hezron tapa hi, Hezron sia Pharez tapa hi, Pharez sia Judah tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah sia Jacob tapa hi, Jacob sia Isaac tapa hi, Isaac sia Abraham tapa hi, Abraham sia Terah tapa hi, Terah sia Nahor tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor sia Serug tapa hi, Serug sia Reu tapa hi, Reu sia Peleg tapa hi, Peleg sia Heber tapa hi, Heber sia Shelah tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah sia Cainan tapa hi, Cainan sia Arphaxad tapa hi, Arphaxad sia Shem tapa hi, Shem sia Noah tapa hi, Noah sia Lamek tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek sia Methuselah tapa hi, Methuselah sia Enok tapa hi, Enok sia Jared tapa hi, Jared sia Mahalalel tapa hi, Mahalalel sia Kenan tapa hi, ");
INSERT INTO csy_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan sia Enosh tapa hi, Enosh sia Seth tapa hi, Seth sia Adam tapa hi, Adam sia Pathian tapa a hihi. ");
INSERT INTO csy_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesus sia Tha Thiangtho taw kidim in Jordan pan ciakik a, Thaa in duisung ah paipui hi, ");
INSERT INTO csy_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ni sawmli sung doaimangpa in ze-et hi. Tua hunsung theampo bangma ne ngawl hi: taciang tua ni te a bo zawkciang in a ngilkial hi. ");
INSERT INTO csy_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Doaimangpa in ama tuung ah, Pathian Tapa na hile, hi suangtum te anluum suak tu in thupia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Taciang Jesus in hibang in zo hi, Mihing te sia anluum bek hi ngawl in, Pathian thu taw nungta zaw tu hi, ci ki at hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Doaimangpa in mualsang dawn ah paipui a, leitung kumpingam theampo tawmvei sung in lak hi. ");
INSERT INTO csy_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Taciang doaimangpa in, hi thuneina theampo le minthanna teng kong pia tu hi: banghangziam cile hite sia keima hong ki pia zo a; ka piaknop po pia khi hi. ");
INSERT INTO csy_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tua ahikom keima nong bia le, a vekpi in nangma neisa hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesus in, Satan, ka nung ah om in: banghangziam cile, Topa na Pathian bia in a, Ama na bek seam in, ci in ki at hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Taciang doaimangpa in Jerusalem ah paipui a, biakinn khuhum ah koi hi, taciang, Pathian Tapa na hile, hi mun pan in leangsuk in: ");
INSERT INTO csy_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Banghangziam cile, nangma a keam tu in Pathian in ama vantungmi te sawl tu hi: ");
INSERT INTO csy_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Na peang suang taw a khet ngawl natu in amate in a khut taw hong dom tu hi, ci in ki at hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Taciang Jesus in, Topa na Pathian ze-et heak in, ci zong om hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Doaimangpa in ze-et na theampo a man ciang in, a kung pan tawlkhat sung kiheam hi. ");
INSERT INTO csy_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesus sia Tha Thiangtho vangletna taw Galilee ah heakkik a: tua ngamsung theampo ah a minthang hi. ");
INSERT INTO csy_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ama in synagogue sungah thuhil a, mi theampo in pok tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesus a khan na mun Nazareth khua ah pai a, ama ngeina bang in, sabbath ni synagogue sungah pai hi, taciang laithiangtho sim tu in ding hi. ");
INSERT INTO csy_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kamsang Isaiah laibu ama pia uh hi. Taciang tua laibu a hon ciang in, hi lai ki at na mun mu hi. ");
INSERT INTO csy_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Topa Thaa sia ka tungah om hi, banghangziam cile mizawng te tungah lungdamna thu pualak tu in sathau hong buak zo hi; thinsung tamtham te damsak tu in ahizong, saltang mite tungah suatakna thu pualak tu in ahizong, mittaw te khuamu kik natu in ahizong, vawtsiatna thuak te suatakna pia tu le, ");
INSERT INTO csy_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Topa i santhei kum pualak tu in hong sawl hi. ");
INSERT INTO csy_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus in a sim laibu khupkik a, naseam pa tungah a ap zawkciang to hi. Synagogue sung a omte theampo in sal tinten uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Taciang Ama in, Hi laithiangtho sia tu ni in na bilsung uh ah tangtung hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","A kamsung pan a pusuak kammal te amate in lamdangsa mama uh a, a vekpi in tettipang uh hi. Taciang, ama sia Joseph tapi hi ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesus in amate tung ah, Hi paunak sia kei tung ah, syavuan pa, nangma le nangma ki damsak in: Capernaum ah na vawt ka zak uh theampo hina khua ah zong vawt in, hong ci tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Taciang Jesus in, A tatak kong ci hi, kamsang sia ama khua ah ki sang ngei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ahihang a mantak kong ci hi, Elijah hun lai, kumthum le tha luk sung ngua zu ngawl hi, ngamsung theampo ah kialpi a tun lai in, Israel ngamsung ah meingong tam mama om hi; ");
INSERT INTO csy_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ahihang tua meingong te kungah Elijah paisak ngawl in, Sidon ngam Zarephath khua meingong nu kungah paisak hi. ");
INSERT INTO csy_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Taciang in kamsang Elisha hun ciang in, Israel ngamsung ah miphak tampi om napi, Syria minam Naaman simngawl midang kuama a ki thiangsak om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Synagogue sung a omte theampo in hi thu te a zak uh ciang in, thin-ukna taw kidim uh a, ");
INSERT INTO csy_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","A vekpi ding in, Jesus sia khuasung pan hawlkhia uh a, khualu mualtung liangdawn pan lusuknuailam khiasuk tu in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ahihang Jesus in amate laizang pan kantan in paisuak hi. ");
INSERT INTO csy_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Taciang Galilee ngam Capernaum khuapi ah pai a, sabbath ni in thuhil hi. ");
INSERT INTO csy_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","A hilna te amate in lamdangsa mama uh hi: banghangziam cile Ama thu sia vanglian hi. ");
INSERT INTO csy_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Taciang synagogue sungah doai ngilo a vei pa khat om a, aw nging mama taw, ");
INSERT INTO csy_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Nang Nazareth khuami Jesus, koma nguak hong omsak po tan; nang taw bang kisai hi ziam? A kua ci hong he khi hi; Pathian i mithiangtho pa na hihi, ci in au hi. ");
INSERT INTO csy_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Taciang Jesus in tei a, Thim in, ama sung pan pusuak in, ci hi. Doai ngilo in mipi te mai ah ama puksak a, ama vawtsia ngawl in a sungpan pusuak hi. ");
INSERT INTO csy_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amate theampo in lamdangsa mama uh a, amate sungah, hisia in bangthu ziam! banghangziam cile thuneina le vangletna taw doai ngilo te thupia a, amate pusuak siat hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jesus thu sia tua ngam kiim mun theampo ah ki zel hi. ");
INSERT INTO csy_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesus sia synagogue sung pan pusuak a, Simon inn ah pai hi. Simon zi i nu sia cisa nasia mama in na a; Jesus kungah amate in hesuak ngetsak uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesus a hui ah ding in, a cisa natna tei hi; taciang a natna in nusia a: tasia pociang tho in, amate leangna do hi. ");
INSERT INTO csy_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nitum ciang in, natna namcin taw cina te Jesus kungah hong paipui uh hi: khatsim tungah a khut nga a, damsak siat hi. ");
INSERT INTO csy_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mitampi sung pan doai te pusuak a, Nangma sia Pathian Tapa Christ na hihi, ci in au uh hi. Taciang Jesus in amate tei in, pausak ngawl hi: banghangziam cile doai te in Ama sia Christ hi, ci he uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Khua hong vak ciang in, Jesus khuasung pan in senneal ngam sangah pai a, mite in zong uh hi, a kungah hongpai uh a, amate paisan ngawl tu in thum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ahihang, amate tung ah, Pathian kumpingam sia khuadang tatuam ah zong ka pualak kul hamtang hi: banghangziam cile tua thu a pualak tu in hong ki sawl ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Taciang Galilee ngamsung synagogue te sungah thuhil hi. ");
INSERT INTO csy_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ni khat Jesus Gennesaret tuihui ah a din laitak in, Pathian thu a hil ngai nuam in mite in ama phul ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Taciang Jesus in tuihui ah ngunkuang ni a tawlnga mu hi: ahihang ngasa man te ngunkuang sung pan tuak a, a ngen te sawp uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesus ngunkuang khatsung ah tum a, ta sia Simon ngunkuang a hihi, tuihui pan in a khuala zawhiat na ah khin tu in ngen hi. Tua ngunkuang sungah Jesus to in, mipi te thuhil hi. ");
INSERT INTO csy_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Thuhil a man ciang in, Simon kungah, Tui thukna mun sangah na ngunkuang khin in a, na ngen uh pai vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon in, Topa awng, zan khuateak hanciam zo ka hi uh hang, bangma nga ngawl khu hi, ahizong na thu bang in ngen pai tu khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ngen a pai uh ciang in, ngasa tam mama awk a, a ngen uh ek hi. ");
INSERT INTO csy_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tasiaciang in ngunkuang dang ah a om a lawmte pai in a hu natu in khutphet uh hi. Amate hongpai uh a, ngunkuang ni sungah ngasa dim ahikom, ngunkuang tuisung tum dektak hi. ");
INSERT INTO csy_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tua thu Simon Peter in a mu ciang in, Jesus khup nuai ah bok a, Topa, ka kung pan kiheam in; banghangziam cile keima in mawnei ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Banghangziam cile Ama le a kung a, a omte in, ngasa tam mama a mat uh hu in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tasia bangma in ama taw ngasa a man Zebedee tapa James le John zong in lamdangsa mama uh hi. Jesus in Simon tung ah, Lau heak in; tu pan kipan in mihing man tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A ngunkuang te tuihui ah a koi zawk uh ciang in, na theampo nusia in Jesus zui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Khatvei Jesus miphak khat omna khuapi khat ah theng hi, tua pa in Jesus a mu ciang in a mai ah bok a, Topa awng, uk po le te hong thiangsak thei ni hi, ci in thum hi. ");
INSERT INTO csy_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesus in a khut zan a, a tham zawkciang, Uk khi hi, dam in, ci hi. Tasia pociang a phak natna in ama taisan hi. ");
INSERT INTO csy_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesus in kuama son heak in ci vaitha hi: Ahihang pai tan a, nangma le nangma thiampi te kungah ki lak in, taciang Moses thupiak bang in thianthona biakpiakna pia in, banghangziam cile amate tungah na thiantho na tetti hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ahihang Jesus thu sia muntheampo ah kizel a: mihon tampi te a thu ngai tu le natna dam nuam in hongpai hon uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Taciang mipi te kung pan in duisung ah pai a, ama nguak thungen hi. ");
INSERT INTO csy_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ni khat, Jesus in thu a hil laitak in, Jerusalem, Judah le Galilee ngamsung khua tatuam pan hongpai Pharisee le thukhamhil te zong to uh hi: cina damsak thei na vangletna sia Topa tungah om hi. ");
INSERT INTO csy_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","En vun, pumzaw khat a lupna taw hong zawng uh a, Jesus mai ah sial tu in, innsung ah tumpui sawm hi. ");
INSERT INTO csy_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ahihang mihonpi te hang in a tum natu lampi a mu zawk ngawl uh ciang, inntung ah kato uh a, a khuhum hawk in mipi te laizang Jesus mai ah a lupna taw cinapa khiasuk uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesus in amate upna a mu ciang in, Pasal pa, na mawna te ki maisak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Thukhamhil te le Pharisee te in, Pathian mindaisak in a pau sia a kua ziam? A kua in mawna te maisak thei ziam, Pathian bek hi ngawl ziam? ci in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ahihang Jesus in amate ngaisutna a heak ciang in, amate tung ah, Na thinsung uh ah bang ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Na mawna te ki maisak zo hi; ci le, ding in a, lampai in, ci koisia ol zaw ziam? ");
INSERT INTO csy_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ahihang mihing Tapa in leitung ah mawna te maisak tu in vangletna nei hi, ci na heak natu uh in, (cina pa tungah ci hi) Keima in kong ci hi, tho in a, na lupna la in, na inn ah cia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Thakhatthu in pumzaw pa amate mai ah ding to a, a lupna la in, Pathian pok kawm, a inn ah cia hi. ");
INSERT INTO csy_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Amate theampo in lamdangsa uh a, Pathian pok uh hi, taciang patau na taw dim uh a, tuni na lamdang mama i mu zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tuazawkciang in, Jesus pusuak a, Levi a kici siadong khat, a zumsung ah a to mu hi: taciang Jesus in ama kungah, Hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi hong ding a, na theampo nusia in Jesus zui hi. ");
INSERT INTO csy_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Taciang Levi in a inn ah Jesus atu in poai lian mama khat vawtsak a: siadong te le midang tampi taw tokhawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ahihang amate i thukhamhil te le Pharisee te in a nungzui te tungah phun uh a, banghang in siadong te le mawnei te taw ne khawm dawn khawm nu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesus in amate zo kik a, Cidam te in syavuan kul ngawl a; cina te bek in kul hi. ");
INSERT INTO csy_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mi pha te sam tu in hongpai ngawl khi hi, ahihang mawnei te a mawna ki sikkik natu in hongpai khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amate in, John nungzui te le Pharisee te nungzui te antang in thungen tawntung uh hi; ahihang banghang in na nungzui te ne le dawn in om uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus in amate tung ah, Mopoai vawt te in mopa amate te taw a om laiteng antangsak thei tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ahihang mopa sia amate kung pan in mundang ah a paipui hun hong theng tu hi, tasiaciang amate zong antang kik tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesus in amate tungah sontena khat son a; Puan lui sia puan thak taw kuama in phaw ngei ngawl hi; tabang hile puanthak in puan lui sia kaikin tu a, puan lui tungah a bel ciang in puan thak taw kizawp thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Savun um lui sungah kuama in sapittui thak thun ngei ngawl hi; a thun le sapittui thak in savun um puakthamsak tu a, sapittui bua siat in, savun um zong laltham tu hi. ");
INSERT INTO csy_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ahihang sapittui thak sia savun um a thak sungah thun kul hamtang hi; taciang a ni in pha khawm tu hi. ");
INSERT INTO csy_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kuama in sapittui lui a dawn zawk uh ciang, sapittui thak dawn kik pai nuam ngawl uh hi: banghangziam cile a lui sia phazaw hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabbath ni a masa bo in, sabbath ni ni na hong thet ciang in, Jesus zungtang losung kantan in pai a; a nungzui te in zungtang vui te hiat in amate khutsung ah nuai in ne uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pharisee te in amate tung ah, banghang in sabbath ni ngeina a hi ngawl te vawt nu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesus in, David le a lawm te a ngilkial uh ciang in, bang vawt ci simngei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David sia Pathian innsung ah tum a, Pathian mai ah a ki lui anluum la in ne hi, taciang a lawm te zong pia hi; tua anluum sia thiampi te bek i neak thei hi ngawl ziam? ci in amate zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesus in amate tung ah, Mihing Tapa sia sabbath ni i Topa a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabbath ni dang khat, Jesus synagogue sungah tum a, thuhil hi: kut ziatsang zaw khat om hi. ");
INSERT INTO csy_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Thukhamhil te le Pharisee te in Jesus maw na zong nuam a hi uhkom, sabbath ni in a damsak ziam, a damsak bua ziam, ci encik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ahihang Jesus in amate ngaisutna he a, a khutzaw pa kungah, Ding in a, a laizang ah ding in, ci hi. Taciang ama zong tho in ding hi. ");
INSERT INTO csy_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jesus in amate tung ah, Thu khat kong dong tu hi; sabbath ni in na pha sep tu ngeina a om ziam, a hibale, na phangawl sep tu ziam? nuntakna hun tu maw, that tu? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Taciang a kiim a pam en a, tua pa kungah, na khut phal in, ci hi. A khut a phal ciang a langkhat bangma in dam kik hi. ");
INSERT INTO csy_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Amate thin-uk na taw dim uh a; Jesus banglaw thei tu hi ziam ci kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tasiaciang in Jesus thungen tu in mualtung ah kato a, Pathian kungah zan khuateak thungen hi. ");
INSERT INTO csy_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Khuavak ciang in, a nungzui te a kungah sam a: sawmleni pha uh hi, tuate sia sawltakte, kici a; ");
INSERT INTO csy_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Peter a kici Simon le a suapui pa Andrew, James le John, Philip le Bartholomew, ");
INSERT INTO csy_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew le Thomas, Alphaeus tapa James le Zelotes a kici Simon, ");
INSERT INTO csy_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","James i suapui pa Judah le Jesus leheak pa Judah Iscariot te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesus a nungzui te taw tuaksuk a, amtam na mun ah ding hi, mihon tampi te sia Judah le Jerusalem, tuipi hui Tyre le Sidon pan in thu ngai tu le amate natna pan a dam nuam in hongpai uh hi; ");
INSERT INTO csy_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Doai ngilo te i vawtsiat te damsak hi. ");
INSERT INTO csy_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","A sung pan in vangletna pusuak a, a vekpi in damsak ahikom mihonpi te theampo in Ama tham tu in zong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesus in a zungzui te en a, Mizawng te thuphatoai te na hi uh hi: banghangziam cile Pathian kumpingam sia note a, a hihi. ");
INSERT INTO csy_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tu in a ngilkial te thuphatoai na hi uh hi: banghangziam cile na ngil uh va kik tu hi. Tu in a kap te thuphatoai na hi uh hi: banghangziam cile na nui kik tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mihing Tapa hang in ngual in hong ensan, amate sung pan hong hawlkhia, hong vawtsia, na min uh hong siatsak ciang in, thuphatoai te na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tua ni ciang in, angtang vun a, lungdam in tawn vun: en vun, banghangziam cile vantung ah na thaman uh lian mama hi: banghangziam cile amate pu le pa te in kamsang te tungah tabangma in vawt zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","A hizong no mihau te na mailam uh bing hi! banghangziam cile nuntak nuam na nga zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","A ngilva te na mailam uh bing hi! banghangziam cile na ngil uh kialkik tu hi. Tu in a nuite na mailam uh bing hi! banghangziam cile kap in na taukik tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ngual theampo in hong pok ciang in na mailam uh bing hi! banghangziam cile amate pu le pa te in leilot kamsang te tabangma in vawt zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ahizong ka thu a za note hibang in kong ci hi, na ngal te it vun a, hong ensan te tungah thupha vawt vun, ");
INSERT INTO csy_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Note hong hamsiat te thupha pia vun a, hong vawtsia te atu in thungetsak vun. ");
INSERT INTO csy_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Na biang langkhat hong beang sia a langkhat ngat vet in; na laktong hong laksak sia na puanlum a lak tu zong khak heak in. ");
INSERT INTO csy_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na tungah hong ngen peuma pia in; taciang na van a la sia zong ngenkik heak in. ");
INSERT INTO csy_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na tungah ngualdang i vawttu na dei bang in, amate tungah vawt vun. ");
INSERT INTO csy_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Banghangziam cile no hong it te bek na it uh le, bang lungdam kotak na nei tu uh ziam? banghangziam cile mawnei te zong amate a itte it uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","No tungah thupha vawt te tung ah, thupha na vawt uh le, bang lungdam kotak na nei tu uh ziam? banghangziam cile mawnei te zong in tabangma in vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hong lo kik tu hi, ci na lamet uh te tung bek ah na puk uh le, bang lungdam kotak na nei uh ziam? banghangziam cile mawnei te zong in a puk uh za nga kik tu a hile, a dang mawnei te tungah puk uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ahihang note in, na ngal te it vun a, amate tungah phatna vawt vun, pukthak vun a, nga kik tu in lamen heak vun; taciang na thaman uh lian mama tu a, a Sangbel i tate hi tu nu hi: banghangziam cile Ama sia lungdam ko thei ngawl te le miphangawl te tungah pha hi. ");
INSERT INTO csy_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tua ahikom na Pa uh sia ngual hesuak thei a hibangma in, note zong hesuakna nei tavun. ");
INSERT INTO csy_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Ngual dang thukhen heak vun, taciang note zong thukhenna na thuak batu uh hi: ngualdang mawsak heak vun, taciang note zong mawsiatna na thuak buatu uh hi: ngual dang maisak vun, taciang note zong hong ki maisak tu hi: ");
INSERT INTO csy_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ngual dang te pia vun, note zong piak na hi tu uh hi; phatak a ki te, a ki hen ih-eh, a ki lok cinten, a dimlet in ngual in note kang sungah hong pia tu uh hi. Banghangziam cile ngualdang na tesak uh bangma in note zong hong tesak kik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus in amate tungah sontena khat son a, Mittaw in mittaw lamlak thei tu ziam? a ni in dum sungah tak tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nungzui in a syapa sang in sangzaw ngawl hi: ahihang a cialcing in a sin khat sia a syapa bang hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na mitsung ah thing tawnpui zong phawk ngawl in, na suapui pa mit sungah nin themno sia banghang en ni ziam? ");
INSERT INTO csy_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na mitsung a om thing tawnpui om nginge nangma le nangma ki en ngawl in, bangbang in na suapui pa kungah, na mit sungah nin themno sia hong laksak tu khi hi, ci thei tu ni ziam? A ki hitheamsak pa, na mit sung a om thing tawnpui sia vawk masa in a, tua zawkciang in na suapuipa mit sung a om nin themno sia a thiangtak in na mu thei tu a, khelsak thei tu ni hi. ");
INSERT INTO csy_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Banghangziam cile thingkung pha in a phangawl nga ngei ngawl hi; thingkung phangawl zong nga pha nga ngei tuan ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Banghangziam cile thingkung peuma a nga pan in ki tel thei hi. Lingkung tung pan in thei min ki lo ngei ngawl a, theimiling kung pan in sapit nga ki lo ngei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mi pha in a thinsung a om na pha te pusuaksak hi; mi phangawl in a thinsung a om na phangawl te ma pusuaksak hi: banghangziam cile a thinsung pan a dimlet te a kam uh pan pau uh hi. ");
INSERT INTO csy_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ka son te nangawn seam nuam ngawl in, banghang in Topa, Topa awng, ci hong sam nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","A kuamapo in ka kungah hongpai in ka son thu te za a a seam te sia bang taw kibang ziam, ci kong lak tu hi: ");
INSERT INTO csy_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ama sia, dum thuk mama to in, suangpi tungah innbul a phut pa taw kibang hi: tui hong khang in, hawktui in tua inn sia nasiatak in nawk napi ngawk zo ngawl hi: banghangziam cile suangpi tungah innbul a phu hang a hihi. ");
INSERT INTO csy_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","A hizong ka son te za napi, a zui ngawl te sia innbul kip nei ngawl in leinen tungah innsa pa taw kibang hi; hawktui in nasiatak in a nawk ciang in, thakhatthu in puk a; tua inn siatna sia na sia mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus in mipi te tungah hi thu te theampo a hil zawkciang in, Capernaum khua sungah tum hi. ");
INSERT INTO csy_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tua mun ah zakhat uk ngalkap mangpa khat i a it mama a naseam pa thi dektak in na hi. ");
INSERT INTO csy_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesus thu a zak ciang in, Judah upa te sawl a, Jesus pai in a naseam pa damsak tu in ngen hi. ");
INSERT INTO csy_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Amate Jesus kung a thet uh ciang in, hanciam in thum uh a, ama atu vawtsak tak mama hi: ");
INSERT INTO csy_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Banghangziam cile ama in ka minam uh it a, synagogue zong hong saksak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesus amate taw hongpai hi. Tua inn a thet dektak uh ciang in, zakhat uk ngalkap mangpa in a lawmte Jesus kungah sawl a, Topa, nangma tatak ngim ki pia heak in: banghangziam cile, Nangma vateak ka innsung dong nong pai tu sia kei kiphu ngawl khi hi: ");
INSERT INTO csy_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Tua ahikom na kungah keima kong pai tu zong ka ki phu bua hi, ci ngaisun khi hi: ahihang kamkhat pau po le te, ka naseam pa dam tu hi. ");
INSERT INTO csy_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Banghangziam cile keima zong thuneina nuai ah ka om hi, ka nuai ah ngalkap te nei khi hi, taciang khat kungah pai in, ka cile pai hi; taciang a dang khat kungah, hongpai tan, ka cile hongpai hi; taciang ka naseam khat kungah zong, hisia seam in, ka cile seam hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesus in hi thu a zak ciang in, lamdangsa hi, Ama hong kihei in, a zui te kungah, Note tungah kong son hi, Israel mite sungah zong hibangza a lian upna mu ngei ngawl lai khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","A paisak te inn ah hong heakkik a, a dam ngawl a naseam pa a dam sa in mu hi. ");
INSERT INTO csy_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A zingciang in, Nain a kici khua ah Jesus pai a; a nungzui tampi te le mi tampi te zong pai uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Khuapi tumna kongpi a thet uh ciang, mithi khat hong pua uh a, ama sia a nu i tapa neisun a hihi: taciang khuasung ah mi tampi te sia meingong nu kungah om hi. ");
INSERT INTO csy_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Topa in tua nu a mu ciang in, a tungah hesuakna nei a, Kap heak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jesus hongpai a, mithikuang tham hi: taciang a pua te tawlnga hi. Taciang Jesus in, Tangvalpa, tho in, hong ci khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mithi hong tho to a, hong pau hi. Jesus in a nu kungah ap kik hi. ");
INSERT INTO csy_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","A vekpi tungah launa hong theng a, eite sungah kamsang lian hong piang hi; Pathian in a mite hong ve hi, ci in Pathian pok uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jesus thu sia Judah ngamsung theampo le a kiim a pam ah thang hi. ");
INSERT INTO csy_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John i nungzui te in hi thu teng ama tungah son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tasiaciang John in a zungzui te ni sam a, Jesus kungah paisak in, Nangma sia hongpai tu pa ni ziam? a hibale a dang ngak lai tu khu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Amate Jesus kung a thet uh ciang in, tuiphumpa John in, na kungah hongpaisak hi, Nangma sia hongpai tu pa na hi ziam? a hibale a dang ngak lai tu khu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tuahun laitak in Jesus in mi tampi te natna a tatuam, nat sia tatuam le doai ngilo vei te damsak a, mittaw tampi te zong khuamusak hi. ");
INSERT INTO csy_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesus in amate tung ah, Pai tavun a, na mu uh le na zak uh te John kung son vun; bangbang in mittaw te in khuamu thei, peangbai te lampai thei, miphak te thiang, nangong te khuaza thei, mithi te thokik a, mizawng te tungah lungdamna thu ki pualak zo hi. ");
INSERT INTO csy_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","A kuamapo Keima hang in uplakna a nei ngawl te thuphatoai a hihi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John i kamtaite a pai zawk uh ciang in, Jesus in mite tungah John thu son kipan a, Duisung ah bang en tu in pai nu ziam? Hui i seam phaikung ngawk ziam? ");
INSERT INTO csy_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bang en tu in pai nu ziam? Puan neam hoi nano sil mu nuam nu ziam? en vun, puan neam nano sil in nuntak nuam mamate kumpi innsung ah a omte hi. ");
INSERT INTO csy_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bang en tu in pai nu ziam? Kamsang ziam? hi hi, a man tatak kong ci ciang, kamsang bek domngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Banghangziam cile, en vun, ka kamtai pa na mai ah ka sawl hi, ama in na mai pan in na lampi hong puakholsak tu hi, ci ama thu sonkhol hi. ");
INSERT INTO csy_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Banghangziam cile keima in kong ci hi, numei sungsuak theampo sungpan tuiphumpa John sang in a lianzaw kuama om ngawl hi: ahihang vantung kumpingam sungah a nobel sia nangawn John sang in lianzaw lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tua thu a za te theampo le siadong te in, Pathian sia thuman hi, ci in pualak uh hi, amate sia John i tuiphumna a piak te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ahihang Pharisee te le thukhamhil te in amate langpan in Pathian i ngaisut nate nial uh hi, amate sia John i tuiphumna a piak te hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Topa in, Tu hun mihing te bang taw sonte tu khi ziam? taciang amate bang taw kibang uh ziam? ");
INSERT INTO csy_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Amate sia sumbuk ah a to patang te taw kibang hi, amate khat le khat ki biakpui uh a, tamngai kong tum uh hang lam nuam ngawl nu hi, katap kong law uh hang, kap nuam tuan ngawl nu hi, ");
INSERT INTO csy_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Banghangziam cile, tuiphumpa John sia anluum ne ngawl sapittui dawn ngawl in hongpai ciang, note in doai vei hi, na ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mihing Tapa sia ne le dawn in hongpai ciang; note in, en vun, an tuang pa, sapittui tuang pa, siadong te le mawnei te i lawmpa, na ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ahihang ciimna in a tate mawsiatna pan suatak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pharisee khat in Jesus taw an ne khawm nuam hi. Taciang Jesus sia Pharisee te inn ah pai in, anne tu in to hi. ");
INSERT INTO csy_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Taciang, en vun, tua khua ah mawnei numei khat om a, Jesus sia Pharisee pa inn ah anne tu in to hi, ci a heak ciang in, alabaster sathau namtui thawl khat keng hi, ");
INSERT INTO csy_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus i nung, a peang kungah kap a, Jesus i peang a thitui taw silsak hi, taciang a sam taw nawlsak a, a nap zawkciang in sathau namtui buak hi. ");
INSERT INTO csy_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tabang a vawt Jesus a sam Pharisee pa in amu ciang, a thinsung pan in, hisia pa kamsang a hile, ama a tham sia bangbang numei ziam, ci he tu hi: banghangziam cile tua numei nu sia mawnei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesus in ama zo kik a, Simon awng, kong son nop khat om hi, ci hi. Taciang ama in, syapa awng, hong son tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus in, Dangka pukthak khat om a, leiba nei ni om hi: khat in dangka za nga ba a, a dang khat sia in sawm nga ba hi. ");
INSERT INTO csy_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amate in a lokik zawk ngawl uh hu in, a ni ma in maisak hi. Tua ahikom tua te ni sungah kua in dangka pukthak pa itzaw tu ziam, hong son tan? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon in, dangka tamzaw a maisak pa in itzaw tu in ngaisun khi hi, ci in zo kik hi. Taciang Jesus in, A man in thukhen ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Numeinu sangah kiheikik a, Simon kungah, Hi numei nu na mu ziam? Na innsung ah hong tum ka hihang, ka peang sil natu tui nong pia bua hi; ahihang hi numei nu in ka peang a thitui taw hong silsak a, a sam taw hong nawlsak hi. ");
INSERT INTO csy_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nang in hong nam ngawl ni hi, ahihang hi numei nu a hile kong tum pan kipan ka peang tawlnga ngawl in nam hi. ");
INSERT INTO csy_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nang ka lu zong sathau hong buak ngawl ni hi: ahihang hi numei nu in ka peang sathau namtui hong buak hi. ");
INSERT INTO csy_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tua ahikom hong son khi hi, a mawna tam mamate ki maisak zo ahikom a itna zong tam hi: ahihang tawmbek a ki maisak te in tawm bek it hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesus in numei nu tung ah, Na mawna te ki maisak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Anneak na mun ah a tote in, mawna a maisak sia kua ziam? ci in amate thinsung pan in ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesus in numei nu tung ah, na upna in hong ngum zo hi; thinnuam in pai in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tuazawkciang in, Jesus sia Pathian kumpingam lungdamna thupha son tu in khuapi le khua no sangah nungzui sawmleni te taw pai hi, ");
INSERT INTO csy_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Taciang natna a tatuam le doai ngilo vei na pan a damsak numei te, tua numei te sungah, a sung pan doai sali a hawlkhiatsak Mary magdalene, ");
INSERT INTO csy_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Herod i neisa keam Chuza i zi Joanna, Susanna le a dang tampi te in amate neisa te taw Jesus ou uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Khua tatuam pan in mi tampi te Jesus kungah hong ki kaikhop ciang in, thu sontena son a: ");
INSERT INTO csy_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Thaici poai khat thaici poai tu in pai hi: a poai ciang in, pawlkhat te lamlai ah tak hi; tate sia ki sikcil lel a, van a leang vacim te in ne siat hi. ");
INSERT INTO csy_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pawlkhat te suang tungah tak a; a po zawkpociang ngawtak pai hi, banghangziam cile lei hing ngawl hang a hihi. ");
INSERT INTO csy_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Thaici pawlkhat te lingphung sungah tak hi; ling te taw khangkhawm a, ling te in deapcip hi. ");
INSERT INTO csy_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","A dang te leipha na mun ah tak a, po in a se zakhat in khang hi. Taciang hi thu te a son zawkciang in, Zak natu bil nei theampo in za ta uh hen, ci au hi. ");
INSERT INTO csy_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taciang a nungzui te in, hi sontena a khiakna bang ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesus in, Pathian kumpingam thuku te heak thei na note tungah hong ki pia zo hi: ahihang ngualdang te tungah sontena te bek taw ki son tu hi; en napi mu ngawl tu uh hi, ngai na pi tel tuan ngawl tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Hi sontena sia hibang a hihi: thaici sia Pathian kammal a hihi. ");
INSERT INTO csy_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lampi ah a tak thaici sia Pathian kammal za napi, um in ngupna a nga thei ngawl natu in, doaimangpa hongpai a amate thinsung pan in Pathian kammal te laksak siat hi. ");
INSERT INTO csy_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Suang tungah a tak thaici te sia, Pathian kammal za a, lungdam in sang napi, zung a nei ngawl hang in tawmvei sung um a, ze-etna hun ciang pukkik pai hi. ");
INSERT INTO csy_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Lingphung sung a tak thaici te sia, Pathian kammal za napi, leitung thinngimna, hauna le lungkimna te in deap cip a, nga pha nga zo ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ahihang leipha na a tak thaici te sia, Pathian kammal a zak uh ciang in, thinsung pha le thuman taw Pathian kammal za a, keamcing ahikom thuakna taw nga pha a nga te a hihi. ");
INSERT INTO csy_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kuama in khuaimei a det uh ciang in khum taw sin ngei ngawl a, lupna nuai ah zong koi ngei ngawl hi; ahihang innsung a tum te in a vaangtang a mu thei natu in meidet na munsang ah koi hi. ");
INSERT INTO csy_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Banghangziam cile a kilang ngawl tu in sealcip thei om ngawl a; heak ngawl tu le ki thethang ngawl tu in phual thei na zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tua ahikom na thu zak uh te kidawm vun, banghangziam cile a kuamapo a nei te ki pia tu a; a nei ngawl khatpo zong a nei bang in a ngaisut te ki laksak vet lai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus a nu le a suapui te hongpai uh ahihang, mi tamlei ahikom a kungah pai thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Mi khat in Jesus kungah, na nu le na suapui te nangma taw ki mu nuam in a puasang ah ding hi, ci in son hi. ");
INSERT INTO csy_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Taciang Jesus in amate tung ah, Pathian thu ngai in, a seam te sia ka nu le ka suapui te a hi uh hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nikhat Jesus a nungzui te taw ngunkuang sungah to uh a: amate tung ah, Tuili ngalkhat ah pai tawng, ci hi. Taciang ngunkuang taw pai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ahihang ngunkuang taw a pai uh laitak in Jesus mu hi: tuili tungah huipi suangval hong va hi; taciang ngunkuang sungah tuidim in, a lauhuai mama dinmun hong theng hi. ");
INSERT INTO csy_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nungzui te Jesus kung pai in phong a, Topa, Topa, bo cip khu hi, ci uh hi. Jesus hong tho a, huipi le tuihual te tei hi: taciang amate thim uh a, dai dide hi. ");
INSERT INTO csy_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus in amate tung ah, Na upna uh koisung ziam? ci hi. Taciang amate lau le lamdangsa in, hisia pa sia bangbang mihing ziam! banghangziam cile ama in huipi le tui te thupia a, a thu ni uh hi, ci in khat le khat kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Taciang amate Galilee ngalkhat, Gadarenes ngam ah hong theng uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesus tuihui ah hong kato ciang in, doai a vei zawk a ngei mama zo khat taw ki si uh hi, ama sia puansil ngawl in, inn zong om ngei ngawl a, than sung bebek ah om hi. ");
INSERT INTO csy_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus a mu ciang in, au a, a mai ah bok in, taciang aw ngingtak taw, Jesus, nang a sangbel Pathian Tapa, nang taw bang kisaina nei hi ziam? hong vawtsia heak in, hesuak kong ngen hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Banghangziam cile Jesus in tha-nin sia mihing sung pan pusuak tu in thu pia zo hi. Tamvei mama doai ngilo in ama man hi: taciang ama sia saikhau le thikkhau taw hen uh ahihang; a hen nate bottan in, doai ngilo in duisung ah paisak hi. ");
INSERT INTO csy_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus in, Na min kua ziam? ci in dong hi, ama in ka min sia Legion, hi ci hi: banghangziam cile doai ngilo tam mama a sungah tum hi. ");
INSERT INTO csy_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Doai ngilo te in Jesus kungah, dum thukpi sungah a hawlkhiat ngawl natu in ngen hi. ");
INSERT INTO csy_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Mualtung ah vokhon tam mama anne in om hi: taciang doai ngilo te in Jesus tungah vokhon sungah tumsak natu in ngen uh a, Jesus in tumsak hi. ");
INSERT INTO csy_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tua pa sung pan in doai ngilo te pusuak a, vokhon sungah tum hi: vokhon te liang pan ki nuntaw suk in tuili sungah tuita in thi siat hi. ");
INSERT INTO csy_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Vokcing te in thupiang teng a mu uh ciang, tai uh a, tua thu khuasung le khuano tatuam te ah son hi. ");
INSERT INTO csy_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tua thupiang en tu in mi tampi pusuak uh a; Jesus kungah hongpai uh hi, taciang a sung pan doai ngilo a pusuak pa nik le puan sil in, thinsung man in Jesus peang kungah a to a mu uh ciang in, lau tek mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tua pa a mu uh ciang in doai ngilo vei in a thin-am pa a damkik na thu ngualdang te son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tasiaciang Gadarenes ngam le a kiimkot a om mihonpi theampo in amate kung pan pusuak tu in ngen uh hi; banghangziam cile amate lau mama uh hi: taciang Jesus sia ngunkuang sungah to a, cia kik hi. ");
INSERT INTO csy_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","A sung pan doai ngilo tampi a pusuak pa in Jesus zui tu in ngen hi: ahihang Jesus in ama paisak a, ");
INSERT INTO csy_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Na inn ah cia tan a, Pathian in nangma atu in na lianpi hong vawtsak te son in, ci hi. Tua pa zong pai a, Jesus in ama atu a vawtsak na lianpi te khuapisung theampo ah tangko hi. ");
INSERT INTO csy_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus a heakkik ciang in, mite in lungdamtak in sang uh hi: banghangziam cile a vekpi in ama ngak tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Taciang, en vun Jairus a kici, synagogue lampui khat hongpai hi: taciang a inn ah pai tu in a peang ah bok in thum hi. ");
INSERT INTO csy_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Banghangziam cile a tanu neisun sia kum sawm le kum ni kiim hi a, thi dektak in zau hi. Ahihang Jesus a pai ciang in ngual in phul kheukho hi. ");
INSERT INTO csy_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tuate sungah numei khat kum sawm le kum ni sung thisuak in a nei theampo syavuan te tungah zangsiat napi, kuama in damsak thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesus nung pan pai in, a puan mong dawn a tham pociang, a thisuak tawlnga hi. ");
INSERT INTO csy_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Taciang Jesus in, Kua na hong tham nu ziam? ci hi. Mi theampo in nial uh a, Peter le a kungah a omte in, Topa awng, mihonpi in hong phul kheukho in hong neng cip hi, banghang in, kua in hong tham nu ziam ci ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus in, Khat in hong tham hi: banghangziam cile ka sung pan in vangletna a pusuak hunlam he khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Numeinu in ki im thei ngawl tu hi, ci a tel ciang, huang vadil kawm in hongpai a, Jesus mai ah bok hi, mi theampo mai ah, banghang in Jesus tham ci le, thakhatthu in a dam na thu pualak hi. ");
INSERT INTO csy_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesus in, Ka tanu awng, patau heak in: na upna in hong damsak zo hi; thinnuamtak in cia in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Taciang Jesus a pau laitak in, synagogue lampui pa inn pan khat hongpai a, na tanu thi zo hi; Syapa nawngkaisak nawn heak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ahihang Jesus in, tua thu za a, Lau heak in: um bek um in, taciang ama dam tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesus tua inn a thet ciang in, Peter, James, John le patangno i nu le pa simngawl kuama innsung ah tumsak ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Mi theampo kap uh a, tua nu sia nasia tak in ka tek uh hi: ahihang Jesus in, Kap heak vun; ama thi ngawl hi, a mu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Numei no sia thi hi, ci he tek zo a hi uh man in Jesus selno in nuisan uh hi. ");
INSERT INTO csy_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus in a vekpi in pusuaksak siat hi, taciang numeino khut pan len in sam a, Tanu no, tho in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tasiaciang a thaa hong heakkik a, thakhatthu in thokik hi: taciang Jesus in, an pia tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Taciang a nu le a pa te in lamdangsa mama hi: ahihang Jesus in a sep thu kuama tung son ngawl tu in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus in a nungzui sawmleni te munkhat ah sam a, doai ngilo theampo tungah ahizong, natna te damsak tu in ahizong, a vanglian thuneina pia hi. ");
INSERT INTO csy_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tabang in Pathian kumpingam thuhil tu le cina te damsak tu in paisak hi. ");
INSERT INTO csy_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jesus in amate tung ah, Na khualhaw natu uh in bangma keng heak vun, ciangkhut ahizong, thung a hizing, anluum ahizong, dangka ahizong; puansil ni ahizong in keng heak vun. ");
INSERT INTO csy_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Koibang innsung ah na tum uh zong in, mundang na pai kik uh mateng tua inn ah tam nginge vun. ");
INSERT INTO csy_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Khat po note hong sang ngawl te sia, tua khua pan na pusua uh ciang in, na peang uh tungah leivui te thin vun a, tate sia amate langpang in tetti te hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A nungzui te pai uh a, khuapi khat zawkciang khat pai in lungdamna thupha tangko uh hi, taciang mun theampo ah cina te damsak hi. ");
INSERT INTO csy_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ngam uk Herod in Jesus na vawt te a zak ciang in, thin ngim mama in om uh hi, banghangziam cile pawlkhat te in John hong thokik hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Mi pawlkhat te in, Elijah hong kilang zo hi; ci uh a, taciang ngualdang te in nidanglai kamsang te khat papo thokik hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herod in John i ngawng ka tan sa hi: ahihang hibang thu ka zak sia a kua ziam? ci a, mu nuam mama hi. ");
INSERT INTO csy_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Sawltakte hong cia kik uh ciang in, amate vawt theampo Jesus tungah son uh hi. Jesus in amate sia senneal om na mun Bethsaida ngamsung ah a tuam in paipui hi. ");
INSERT INTO csy_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Taciang mipi te in a heak uh ciang in, zui uh a, Jesus in amate sang uh hi, taciang Pathian kumpingam thuhil uh a, damna a kisam te damsak uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ni tum tu kuan ciang in, nungzui sawmleni te Jesus kungah hongpai uh a, mihonpi te khuapi sung le a kiimkot ngam tatuam ah pai in, ngia natu mun le an zong tu in paisak in: banghangziam cile eite senneal ngam ah i om hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ahihang Jesus in amate tung ah, Note in amate neak tu pia vun, ci hi. Amate in, hi mihing theampo atu pai in an lei ngawl in hileang, anluum nga le ngasa ni simngawl bangma i nei bua hi; ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Banghangziam cile amate sia pasal bebek tul nga kiim pha uh hi. Jesus in nungzui te tung ah, Amate sawm nga, sawm nga pawl in tosak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Tabang in a nungzui te in a sonbang in vawt uh a, a vekpi in tosak uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Taciang Jesus in anluum nga le ngasa ni la a, vanlam en in thupha a piak zawkciang, phel a, mihonpi hawm tu in nungzui te kungah pia hi. ");
INSERT INTO csy_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","A vekpi khamtak in a neak tek zawk uh ciang in, a neakmong a val teng tawm uh a, bawm sawm le bawm ni dim hi. ");
INSERT INTO csy_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jesus ama nguak thu a nget laitak in, a nungzui te a kungah om uh hi: taciang amate tung ah, Ngual in keima kua hong ci uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Amate in, tuiphumpa John ci uh hi; ahihang pawlkhat te in Elijah; hong ci uh hi, a dang pawlkhat te in, nidang lai kamsang khatpo hong thokik hi, hong ci uh hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesus in amate tung ah, Ahizong note in kua nong ci uh ziam? ci in a dok ciang in, Peter in, Pathian i Christ na hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Taciang Jesus in tua thu kuama tung son ngawl tu in thupia a, a khotak in amate vaitha hi; ");
INSERT INTO csy_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mihing Tapa in tam mama thuak hamtang tu hi, taciang upa te, thiampi lian te le thukhamhil te in nial tu uh a, that tu uh hi, taciang nithum a cin ciang in thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesus in a vekpi tung ah, A kuamapo ka nung hong zui nuam le, ama le ama ki nial hen a, ama thinglamte nisim pua in, hong zui tahen. ");
INSERT INTO csy_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Banghangziam cile a kuamapo in, ama nuntakna a ngum nuam peuma sum tu a: ahihang keima atu in, a nuntakna a sum peuma nungta tu hi. ");
INSERT INTO csy_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mihing khat in leitung buppi a nei hial zong, ama nuntakna sum in bo hile, bang phattuamna om tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Banghangziam cile, khatpo in keima le ka thu atu in a maizum le, mihing Tapa sia Ama, Pa le a thiangtho vantungmi te minthanna taw hongpai ciang in, mihing Tapa in zong ama atu maizum pui tu hi. ");
INSERT INTO csy_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ahihang, a mantak in kong ci ciang, hisung mun ah a ding pawlkhat te, Pathian kumpingam a mu uh mateng, thina tep tha ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hi thu te a son zawk ni liat ni ciang in, Peter, John le James te sam a, thungen tu in mualtung ah kato tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Thu a nget laitak in, Jesus a maitang meal kikheal a a puan te taang in te liang hi. ");
INSERT INTO csy_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Taciang, en vun, mi ni in paupui hi, tuate sia Moses le Elijah te a hi uh hi: ");
INSERT INTO csy_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Amate vangletna taw kilang a, Jerusalem ah a thinatu le a nasep a khuangkhim natu thu son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ahihang Peter le a kung a omte sia mutnuam mama uh a: a khuaphaw kik uhciang in, Jesus vangletna le a dinpui mi ni te mu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amate Jesus kung pan a pai zawk uh ciang in, Peter in Jesus kungah, Topa, hi mun ah om leang pha hi: buk thum sa tawng; khat nangma atu, khat Moses atu, khat Elijah atu, ci hi: Peter in bang son ci zong tel ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tabang a pau laitak in, meingo in amate tuam a: meingo sung a tum ciang in amate lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Taciang meingo sung pan in aw khat in, hisia in ka it mama ka Tapa hi: a thu ni vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tua aw nging a bo ciang in, Jesus ama nguak bek mu uh hi. Taciang amate in hithu phualseal uh a, a mu uh thu te kuama tung a son bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","A zingciang, amate mualtung pan a tuaksuk uh ciang in, mi tam mama in Jesus muak uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Taciang, en vun, mipi sung pan in mikhat au a, Syapa awng, ka tapa hong etsak kapo in: banghangziam cile ama sia ka neisun ka tapa hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Taciang, en in, doai in man a, upmawk ngawlbul in au hi; taciang puksak a, a kam pan cilphuan te pusuak za dong in, vawtsia a, pusuak kik vacit nuam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Na nungzui te i hawlkhiatsak tu in ka nget hang; hawlkhia zo ngawl uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesus in, Maw! upna nei ngawl le lamkhial te, banghun dong note taw hong om khawm tu khi ziam? banghun dong hong maisak lai tu khi ziam? Na tapa ka kung paipui tan, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tabang in Jesus kungah patangno hong paipui ciang, doai ngilo in puksak a, a thangui ki kaikinsak hi. Jesus in doai ngilo tei a, patang pa damsak hi, taciang a pa kungah ap kik hi. ");
INSERT INTO csy_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Amate a vekpi in Pathian i vangletna lian lamdangsa tek mama uh hi. Ahihang amate in Jesus vawt te theampo te lamdang asak mama uh laitak in, Jesus in a nungzui te tung ah, ");
INSERT INTO csy_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Hi ka thuhil te na bilsung uh ah tum tahen: banghangziam cile mihing Tapa sia mihing te khutsung ah ap tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ahizong a nungzui te in Jesus thuhil te a tel bua uh hi, amate kung pan in ki phualseal ahikom a tel bua uh hi: taciang a sonte zong a dong ngam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tuazawkciang in, a nungzui te amate laklaw ah, a kua lianbel tu, ci ngaisun tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus in amate thinsung ngaisutna a heak ciang in, patang khat la a, a kungah koi hi, ");
INSERT INTO csy_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Amate tung ah, Khatpo in, ka min taw hi patangno a sang peuma keima hong sang a hihi: keima hong sang peuma in keima hong sawlpa a sang a hihi: banghangziam cile note sungah, a nobel sia a lian hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John in, Topa awng, na min taw doai ngilo te a hawlkhia khat ka mu uh a; tho khu hi, banghangziam cile kote taw hong kithawl ngawl hang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus in, Tho heak vun: banghangziam cile hong langpan ngawl peuma hong hu a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesus sia van a ka tu hun hong nai ciang in, Jerusalem pai tu in a maitang khosak mama hi. ");
INSERT INTO csy_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A mai ah kamtai paisak khol a, amate pai hi, taciang Ama atu kinging tu in Samaria khua khat ah tum hi. ");
INSERT INTO csy_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ahihang tua khuasung mite in a sang bua uh hi, banghangziam cile a mai sia Jerusalem ah pai tu bang in a om hang a hihi. ");
INSERT INTO csy_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hi thu a nungzui te James le John in a mu uh ciang in, Topa, Elijah in a vawt bang in, van pan in mei tak suk a, amate kangsiatsak tu in thu ka piak tu uh nong oai ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ahihang Jesus ki hei in, amate tei hi, Bangbang thaa nei nu ziam ci zong he ngawl nu hi. ");
INSERT INTO csy_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Banghangziam cile mihing Tapa sia mihing te nuntakna lalsak tu in hongpai ngawl hi, ahihang ngum tu in hongpai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Amate lampi ah a pai uh laitak in, mi khat in, Topa, na pai na mun theampo ah hong zui tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Taciang Jesus in ama tung ah, Ngia te in kua nei a, van a vacim te in bu nei hi; ahihang mihing Tapa in a lu ngakna tu zong nei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Taciang a dang khat tungah Jesus in, Hong zui tan, ci hi. Ahihang ama in, Topa awng, pai in ka pa hong vuisak phot tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus in ama tung ah, Mithi te sia mithi te in vui tahen: ahihang nang na hile pai in a, Pathian kumpingam thuhil in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Midang khat in, Topa awng, hong zui tu khi hi; ahihang ka inn ah pai in, innkuanpui te nukset in vaitha masa phot tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus in ama tung ah, A kuamapo nungsang en in lo a tho peuma, Pathian kumpingam atu in man na om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hiteng zawkciang in Topa in a dang sawm sali teal a, ama pai na mun tu khua le mun tatuam ah ni veu ni veu kop in paikholsak hi. ");
INSERT INTO csy_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Taciang Topa in amate tung ah, Tang at tu tampi om napi, naseam tu tawm hi: tua ahikom, tang at tu Topa in naseam tu te tang at na mun ah sawl tu in thungen vun. ");
INSERT INTO csy_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pai tavun: en vun, ngia hon sungah tuuno bang in hong tha khi hi. ");
INSERT INTO csy_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Dangka bawm, thung le peangdap te keng heak vun: lamkal ah ngual dang paupui heak vun. ");
INSERT INTO csy_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Inn khatpo ah na tum uh ciang in, a masabel in, hi innsung ah thinnopna om tahen, ci vun. ");
INSERT INTO csy_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tua inn ah thinnopna tapa a om le, na thinnop na uh a tungah om tu hi: a om bua a hile, note tungah hong heakkik tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Tua inn ah tam nginge vun a, hongpiak po ne in, dawn vun: banghangziam cile naseam te thaman nga tu kilawm hi. Inn khat pan a dang inn khat ah kikhin heak vun. ");
INSERT INTO csy_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Khua khatpo ah na tum uh ciang in, hong sang uh a hile, na mai uh ah hong lui te ne vun: ");
INSERT INTO csy_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tua khua sung a om cina te damsak vun a, amate tung ah, Pathian kumpingam hong nai zo hi, ci in hil vun. ");
INSERT INTO csy_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ahihang khuapi khatpo ah na tum uh ciang in, hong sang bua a hile, na tum na uh lampi pan ma in pusuakkik vun a, ");
INSERT INTO csy_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ka peang tung uh ah a bang leivui te cikteak sia, note langpan tu in nawl khu hi: ahihang Pathian kumpingam hong nai zo hi, ci tel thiang tavun, ci tavun. ");
INSERT INTO csy_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ahihang kong son tu hi, tua ni ciang in Sodom thuak na sia tua khuapi sang in thuak nop zaw tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Maw Chorazin! na mailam bing hi, maw Bethsaida! na mailam bing hi, banghangziam cile na sungah a ki vawt vanglian nasep te Tyre le Sidon khua ah ki vawt hile, khau-ip puan le vut sungah to in a mawna uh a ki sikkik zawk ngei zo tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ahihang thukhenna ni ciang Tyre le Sidon sia nang sang in a thuakna uh ol zaw tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Taciang nang, Capernaum, van dong hong ki lamsang zo napi, hell sung dong in khiaksuk kik na hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Na thu hong ni te sia ka thu hong ni te a hi uh hi; note hong zawngsak te keima hong zawngsak a hihi; keima hong zawngsak te keima hong sawl pa zawngsak a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sawm sali te lungdamna taw hong heakkik uh a, Topa awng, doai ngilo te nangawn in na min hang in ka thu uh hong ni hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Taciang Jesus in amate tung ah, Khualeng bang in van pan Satan a taksuk ka mu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","En vun, ngul te le ai-kam te sikcil tu in vangletna kong pia hi, taciang ngal te vangletna theampo tungah zong vangletna kong pia hi: taciang bangma peuma in hong susia thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ahihang thaa te in na thu uh hong nit hu in lungdam heak vun; tua sang in na min uh vantung ah ki at zo ahikom in lungdam zaw vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tua hun laitak in Jesus sia Thaa sungah lungdam a, Maw ka Pa, lei le van Topa, mipil le mi thiam te tungah na phualseal te, patangno te tungah na pualak hu in lungdam kong ko hi: hi tahen, maw ka Pa awng; banghangziam cile na mu na ah hisia in pha hi. ");
INSERT INTO csy_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ka pa in na theampo kei hong pia zo hi: Tapa a kua ziam, ci Pa simngawl kuama in a he bua hi; taciang, Pa sia a kua ziam, ci Tapa le, ama Tapa i a pualak te bek in a he uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesus a nungzui te sangah kihei a, Na mu uh thu te a mu mitte thuphatoai a hihi: ");
INSERT INTO csy_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kei kong cina pan, kamsang le kumpi tampi te in na mu uh thu te mu nuam napi, mu tha ngawl hi; na zak uh thu te za nuam napi za tha ngawl uh hi, ci a tuam in son hi. ");
INSERT INTO csy_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Taciang, en vun, thukhamhil khat hong ding a, Syapa awng, tawntung nuntakna ka lua natu bang vawt tu khi ziam? ci in ze-et hi. ");
INSERT INTO csy_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus in ama tung ah, Thukham laibu sungah bang ki at ziam? bangbang sim ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tua pa in, Topa na Pathian sia na thinsung theampo, na nuntakna theampo, na hatna theampo le na ngaisutna theampo taw it in; nangma le nangma na ki it bang in na innpam te it in, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesus in, Na zo na man hi: hi te vawt in a, na nungta tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ahihang thukhamhil pa in ama le ama ki thutangsak nuam ahikom, Jesus tung ah, ka innpam te a kua ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tasiaciang Jesus in, Khatvei mikhat Jerusalem pan Jericho ah pai hi, phalak te taw ki si a, a nikten puansil teng sutsak in velcip hi, nasia mama in liam a, a thi dektak in nusia hi. ");
INSERT INTO csy_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Thiampi khat tua lampi tawn luilam a; tua pa a mu ciang in, a langkhat pan pial in paisan hi. ");
INSERT INTO csy_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tabangma in Levi khat zong tua mun ah hongpai a, a et zawkciang in, a langkhat pan pial in paisan hi. ");
INSERT INTO csy_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ahihang Samaria mi khat, tua lampi ah khualhaw in hongpai a, tua cina pa a mu ciang in, a tungah hesuakna nei hi, ");
INSERT INTO csy_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Taciang a kungah pai in, a meima te sathau le sapittui buaksak in tuamsak hi, taciang ama nganno tungah suan a, zintun inn ah paipui in khoi hi. ");
INSERT INTO csy_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","A zingciang a paikik tu ciang in, dangka tang ni sua a, zintun inn keampa pia hi, taciang hi sia pa na khoi in a; na bo thua na teng theampo sia, kong paikik ciang in hong pia tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hi te thum sung pan, phalak te taw a ki si pa i innpam sia a kua hi tu ngaisun ni ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Thukhamhil pa in, cina pa tungah hesuakna a nei pa, ci in zo hi. Taciang Jesus in ama tung ah, Pai tan a, nang zong tabang in ngamta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus le a nungzui te pai uh a, khua khat ah theng uh hi; taciang Martha a kici numei khat in Jesus sia a inn ah sang hi. ");
INSERT INTO csy_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha in Mary a kici naunu khat nei a, ama sia Jesus peang kungah to in, thu ngai hi. ");
INSERT INTO csy_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ahihang Martha sia nasep tam hu in a thintoi a, Jesus kungah pai in, Topa, ka naunu in nasep theampo keima nguak i sep tu in hong awn hi, phamaw sa ngawl ni ziam? tua ahikom keima nasep hu tu in sawl in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Taciang Jesus in, Martha, Martha, nang sia na tam mama thintoi le buaipui ni hi: ");
INSERT INTO csy_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ahihang a kisam tatak khat bek om hi: tasia Mary in teal zo a, kuama in ama tung pan in laksak kik thei nawn ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesus munkhat ah thungen a, a man ciang in, a nungzui te sung pan khat in, Topa awng, John in a nungzui te a hil bang in, thunget hong hil tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesus in amate tung ah, Thu na nget uh ciang in, hibang in ci vun, vantung a om kote pa awng, na min thiangtho ki upat tahen. Na kumpingam hong theng tahen. Vantung ah na deina a kicin bang in, leitung ah zong kicing tahen. ");
INSERT INTO csy_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ka nisim an uh, ni khat zawk ni khat hong pia tan. ");
INSERT INTO csy_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ngual mawna te ka maisak uh bangma in; kote mawna te zong hong maisak ta in. Ze-etna sungah hong paipui heak in; siatna sung pan hong hun ta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesus in a nungzui te tung ah, Note sungah khatpo in lawmtam nei tu a, zanlai tak a inn ah pai in, ka lawm awng, anluum thum hong puk hi tan; ");
INSERT INTO csy_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Banghangziam cile ka lawmte a khualkhaw na mun pan in ka kungah hongtheng a, bangma piak tu nei ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Taciang a lawmpa in innsung pan in, hong nawngkaisak heak in: innkha zong ka khak zo a, ka tate zong ka kung lupna tungah om hi; tho in hong pia thei ngawl tu khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hong ci khi hi, lawmtam a hi hang in tho in pia tuan ngawl hi, ahihang maizum ngawl in a nget hamtang hang in, tho tu a, a kisap theampo pia tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Keima in kong ci hi, ngen vun, hong ki pia tu hi; zong vun, na mu tu uh hi; king vun, note atu in hong ki hon tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Banghangziam cile a ngen peuma in nga tu a; a zong peuma in mu tu hi; taciang a king te atu ki hon tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Note sungah pa khatpo, a tapa in anluum ngen le, suangtum a pia tu ziam? a hibale ngasa ngen le, tua ngasa tang in ngul a pia tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A hibale, aktui ngen le, ai-kam a pia tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Note mi phangawl te hi napi, na tate uh tungah letsong pha te bangbang in pia tu, ci na he uh le: vantung a om na Pa uh in a ngente tungah Tha Thiangtho bangzata in hong pia zawkan tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesus in a pau thei ngawl pa sung pan doai ngilo khat hawlkhia hi. Doai ngilo a pusua ciang in, tua a pau thei ngawl pa hong pau hi; taciang midang te in lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ahihang pawlkhat te in, doai ngilo te i topa Beelzabub vang taw in Ama in doai ngilo te hawlkhia hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A dang te in Jesus ze-et uh a, van pan musakna te ngen hi. ");
INSERT INTO csy_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ahihang Jesus in amate ngaisutna te he a, Ngam khat sia ki khen in a ki langpan uh le, siatna sung theng tu hi; taciang inn khatpo zong ki khen in a ki langpan uh le puk tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satan sia ama le ama ki khen in a ki langpan le, bangbang in a kumpingam kho thei tu ziam? banghangziam cile note in Beelzebub vang taw doai ngilo te hawlkhia hi, hong ci nu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Taciang Beelzebub vang taw in doai ngilo te hawlkhia ka hile, na tate uh in a kua vang taw in hawlkhia uh ziam? tua ahikom amate sia note i thukhen te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ahihang Pathian khutma taw doai ngilo te hawlkhia ka hile, note tungah Pathian kumpingam hong theng a hihi, ci thu uplak natu om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","A thahat mama pa khat in a innpi huang sia ngalhiam taw a cin ciang in, a neisa te bit tu hi: ");
INSERT INTO csy_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ahihang ama sang a hat zaw khat hongpai in, a zo le, a muan mama a ngalhiam theampo laksak siat in, a sutol van te khen in hawm siat tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Keima taw a om ngawl te sia ka ngal hi a, kei taw a kaikhawm ngawl peuma a thethang te a hihi. ");
INSERT INTO csy_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tha-nin khat sia mi khat sung pan a pusua ciang in, tawlngak natu zong in kongaw ngam tatuam ah vak a; a mu ngawl ciang in, ka pusua na mun ka inn ah heakkik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","A thet ciang in, a inn sia mun ki phiat sa le a ki pua sa in mu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tuazawkciang in paikik a, ama sang a sia zaw a dang thaa sali kaizawn thua hi; taciang tua mun ah tum in om khawm uh hi: taciang tua pa i om dan sia a masa sang in law mawk zaw hi. ");
INSERT INTO csy_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus in hi thu te a hil laitak in, mipi te sung pan numei khat in, au kawm in Jesus kungah, nangma hongpai ngil le na tawp noaimuk sia thuphatoai a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ahizong Jesus in, Hi hi, tasia sang in Pathian thu za a, a zuite thuphatoai zaw lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Mitampi te a hon a hon in hong ki kaikhop uh ciang in, Jesus in, Hi mi phangawl suan te in musakna zong uh ahihang; kamsang Jonah musakna simngawl a dang ki pia ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Banghangziam cile Jonah sia Nineveh mite atu in, musakna a hibangma in, mihing Tapa sia hi suan le pal te atu in musakna hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Thukhenna ni ciang in, thangsang kumpinu hong ding tu a, amate mawsak tu hi: banghangzima cile kumpipa Solomon ciimna ngai tu in leitung mong vateak pan in hongpai hi; en vun, hi mun ah Solomon sang a lian zaw om hi. ");
INSERT INTO csy_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Thukhenna ni ciang in Nineveh mite hi suan le pal te taw ding tu uh a, mawsak tu uh hi: banghangziam cile amate in Jonah thuhilna a zak uh ciang in maw ki sikkik uh hi; en vun, ziak ah Jonah sang a lianzaw om hi. ");
INSERT INTO csy_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Kuama in khuaimei a det uh ciang in a bulia na ah koi ngei ngawl hi, khum nuai ah zong koi ngei ngawl hi, a sungtang te in khuavak a mu thei natu in meidetna munsang tungah koi hi. ");
INSERT INTO csy_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mit sia pumpi atu in khuavak a hihi: tua ahikom na mit a ciim le, na pumpi theampo taang siat tu hi; ahihang na mit a pha bua le, na pumpi mial siat tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tua ahikom na sung uh ah khuavak sia a mial ngawl natu in kidawm vun. ");
INSERT INTO csy_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tua ahikom na pumpi theampo sia khuavak taw kidim in, a mial na mun a om bua a hile, a tang khuaimei in nangma khuavak hongpiak bang in, na pumpi theampo in khuavak taw dim tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus thu a hil zawkciang, Pharisee khat in annekhawm tu in ngen hi: taciang tum uh a, anne tu in to uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesus nitak an a neak uh ma khut sil masa ngawl ci Pharisee pa in a mu ciang in lamdangsa hi. ");
INSERT INTO csy_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Taciang Topa in ama tung ah, Tu in no Pharisee te, na hai uh le na kuang uh te a puasang bek sil nu hi; ahihang na sungsang uh sia ngual van suttol nopna le ngitlo na taw kidim hi. ");
INSERT INTO csy_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","No a mawmaw te, a puasang a vawt pa in a sungsang zong vawt hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ahihang na nei uh taw kizui in mizawng te huna pia zaw vun; taciang, en vun, na theampo sia note atu in thiang hi. ");
INSERT INTO csy_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ahihang Pharisee te, na mailam uh bing hi! banghangziam cile lenmui le ante tatuam te, se sawm sua se khat pia na hi uh hang, Pathian i itna le thukhenna te kalvol siat nu hi: tabang te na vawt tu uh te hi zaw a, vawt ngawl in na nusiat thong tu uh hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Pharisee te, na mailam uh bing hi! banghangziam cile synagogue sungah a sangbel tokhum te le sumbuk ah paupui tu na dei uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Thukhamhil le Pharisee te, a ki hitheamsak te, na mailam uh bing hi! banghangziam cile note sia a ki lang ngawl than taw na kibang uh hi, taciang than tungah a vak te in a om hunlam zong a he bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tasiaciang thukhamhil te sung pan khat in, Syapa awng, hibang na pau sia koma nong zawnsak na hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus in, Thukhamhil te zong, na mailam uh bing hi! banghangziam cile puakzawk ngawl vanngit ngual tungah suan nu hi, taciang note in na khutme dawn taw zong, tua vanngit thutha nuam ngawl nu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Na mailam uh bing hi! banghangziam cile na pu le pa te i thalup kamsang te i than note in na sa uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","A mantak in na pu le pa te i sep teng na lung uh kim hi, ci kilangsak nu hi: banghangziam cile na pu na pa te in kamsang te that takpi uh a, note in a than na sa uh hi. ");
INSERT INTO csy_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tua ahikom Pathian ciimna in amate tung ah, kamsang te le sawltakte ka sawl tu hi, pawlkhat te amate in that in vawtsia tu uh hi: ");
INSERT INTO csy_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tua kamsang theampo te i thisan, leitung ki bitphua pan kipan a luang theampo, hi minam te tungah ka siik tu hi; ");
INSERT INTO csy_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel thisan pan kipan biaktau le biakinn kikal a a bo Zacharias i thisan dong in: a mantak kong ci ciang, hi minam tungah ki ngen tu hi. ");
INSERT INTO csy_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Thukhamhil te, na mailam uh bing hi! banghangziam cile heakna tawtang na la zo uh a: note zong tum ngawl in, a tum tu te zong khak nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesus in hi thu te amate tungah a hil ciang in, thukhamhil te le Pharisee te a thin uh uk mama uh a, thu tampi hil tu in dong uh hi: ");
INSERT INTO csy_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","A kam pau na pan, Ama mawsiat thei natu in a paukhial tu encik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tua laitak in simzawk ngawl za dong in mihonpi hong ki kaikhawm kheukho uh a, khat le khat a ki phul ngawp liang uh laitak in, Jesus in a nungzui te kungah amasabel in, Pharisee te tol a kici ki hitheamsak nate kidawm vun. ");
INSERT INTO csy_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Banghangziam cile a kilang ngawl tu in a ki sincip thei a om ngawl bangma in; heak ngawl tu in a ki phualcip thei zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tua ahikom khuazing sungah na son theampo uh khuavak sungah ki za tu hi; inndoi sung bil kung vacin pan na son uh te innkhum tung pan ki tangko tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ka lawmte awng hong son khi hi, pumpi that in, tua zawkciang bangma a law thei nawn ngawl te lau heak vun. ");
INSERT INTO csy_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ahihang na lau tu uh te kidop na kong pia khol tu hi: a thalup zawkciang hell sungah a khia thei sia na lau vun; hi hi, keima in kong son hi, lau vun. ");
INSERT INTO csy_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tonbawm nga ciang dangkasan pia ni taw ki zuak hi, tua te khat zong Pathian in mangil ngawl hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ahihang na lu tung uh a samzam te nangawn simsiat sa a hihi. Tua ahikom lau heak vun: note sia tonbawm tam mama sang in manphazaw nu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Keima in kong ci hi, a kuamapo mipi mai ah hong pualak sia, mihing Tapa in Pathian i vantungmi te mai ah ama zong pualak tu hi: ");
INSERT INTO csy_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ahihang mipi mai ah kei hong nial te Pathian i vantungmi te mai ah ka nial tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","A kuamapo in mihing Tapa langpan in a pau sia, ki maisak tu hi: ahihang a kuamapo Tha Thiangtho a sonsia peuma, ki maisak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Synagogue sungah ahizong, ngam uk te le thunei te mai ah hong ki paipui ciang in, bangbang in, a hibale, bangbang zo kik tu, a hibale bang pau tu, ci in ngaisun heak vun: ");
INSERT INTO csy_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Banghangziam cile Tha Thiangtho in hong hil tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Mipi sung pan khat in, Syapa awng, ka suapuipa in ngamh hong khen natu in hong sonsak tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Taciang Jesus in, Pasal pa awng, note tungah a kua in thukhen tu le ngamh khensak tu in hong vawt ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tasiaciang in Jesus in amate tung ah, Duhopna kidawm vum: banghangziam cile mihing khat i nuntakna sia a dimlet a nei le a lam sungah ki hel ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesus in amate tungah sontena khat son a, Mihau pa khat om a, a lo sung pan in an tam mama piang hi. ");
INSERT INTO csy_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tasiaciang a thinsung pan in, an khol natu inndoi nei ngawl ka hikom, bangbang hi tu khi ziam? ci in ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tua ahikom, hibangin ka vawt tu hi: ka ansal ka phel siat tu a, a lianzaw in ka sa tu hi; tua mun ah ka an le van te theampo khol tu khi hi. ");
INSERT INTO csy_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Taciang ka thaa tung ah, Maw ka thaa awng, kum tampi atu kholsa van le na tam mama nei ni hi; suaktatak in, ne in a, dawn in, a nuam mama in om in, ka ci tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ahihang Pathian in ama tung ah, nang a mawmaw pa, tuzan mama in na thaa la tu khi hi: taciang na khol sa van theampo sia akua in lua tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tasia bangma in ama atu neisa khol a, Pathian sungah a hau ngawl peuma, hi mihau pa taw kibang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesus in a nungzui te tung ah, Tua ahikom kong ci hi, na nuntakna atu in na kisap uh an le tui; na pumpi atu sil le ten atu in thintoi heak vun. ");
INSERT INTO csy_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","An sang in nuntakna, puansil sang in pumpi thupi zaw hi. ");
INSERT INTO csy_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Va-ak te nuntak na en vun: banghangziam cile amate thaici ciing ngawl a, tang zong at ngawl hi; ansal zong nei ngawl hi; ahihang Pathian in vak hi: note sia vacimno te sang in bangza in thupi zaw nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Note sungah a kua in thintoi na taw a khan tongkhat belap thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hi a nobel nangawn vawt thei ngawl na hi uh le, banghang a dang te thintoi nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Duisung ah unok pak te bangbang in khang, ci ngaisun pak vun, naseam ngawl hi, khauzong hual ngawl hi; Keima in kong ci hi, Solomon in a minthanna theampo taw a kipua ciang in, hi pak khat zong ban zo ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tuni po a, zingciang vawk in a ki hal tu lolai ah lopa te nangawn Pathian in zeam a hile, tuate sang in note hong zeam zaw mama tu hi ngawl ziam, no upna no te? ");
INSERT INTO csy_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na neak tu uh le na dawn tu uh te zong heak vun, uplakna thinsung zong nei heak vun. ");
INSERT INTO csy_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Banghangziam cile hibang te leitung minam theampo te in zong peu uh hi; hibang nate kisam nu hi, ci na Pa uh in hong he hi. ");
INSERT INTO csy_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ahihang note Pathian kumpingam zong zaw vun; tua hile hibang na theampo hong pia thua tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Lau heak vun, tuuhon tawm no te awng; banghangziam cile note kumpingam piak tu sia na Pa uh i deina a hihi. ");
INSERT INTO csy_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Na neisa uh te zuak vun a, mizawng te hu na pia vun; a nget le a lui thei ngawl te note atu in khol vun, na neisa te uh a bo thei ngawl na mun, nguta te a thet thei ngawl na mun le nget i neak thei ngawl na mun vantung ah khol vun. ");
INSERT INTO csy_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Banghangziam cile na neisa uh om na mun ah na thinsung uh zong om tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Na kawng uh kawngkhau thua vun, na meivak uh tangsak vun; ");
INSERT INTO csy_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Note mopoai pan in a topa hong theng a; kongkha hong kik pociang, hon pai tu in a ngak nginge te bang hi tavun. ");
INSERT INTO csy_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","A topa a thet ciang in ama ngak nginge in a mu naseam te thuphatoai a hihi: a tatak kong ci ciang, a topa ama vateak in a kawngkhau kil in, a naseam te an ne tu in tosak tu a, amate an lui tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nai ni ciang ziam, nai thum ciang ziam, a topa hongpai a hile, ama ngak nginge in a mu, a naseam te thuphatoai a hihi. ");
INSERT INTO csy_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Nguta hongpai tu hun, innteakpa in he hile, a inn cing nginge tu a, nguta i inn phulsak thuak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tua ahikom ki ngingsa in om vun: banghangziam cile mihing Tap na ki ngin ngawl uh laitak in hongpai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter in, Topa awng, hi thu sontena koma atu nong son ni ziam maw, a hibale mi theampo atu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Topa in, A topa in ama innkuanpui te a hun a cin ciang in amate i tel tek neak tu a pia thei lampui koi tu a, a muantak le a ciim neisa keampa sia a kua ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","A topa hongpai ciang in, na a sep laitak a mu, naseam pa thuphatoai a hihi. ");
INSERT INTO csy_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A tatak ka ciciang, tua naseam pa sia a topa in a nei theampo keam in koi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ahizong naseam khat in a thinsung pan in, ka topa hongpai pai ngawllai tu hi, ci ngai sun a; naseam dang numei le pasal ci ngawl in vel tu hi, taciang ne le dawn tu a, zukham in om tu hi; ");
INSERT INTO csy_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tua naseam pa in a upmawk ngawl ni le a ki ngin ngawl hun laitak in a topa hongpai tu a, tua naseam pa sia a topa in nasiatak in velcip tu hi, taciang thu um ngawl te taw ama ngatu a tel teng koisak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tua naseam in a topa dei na he nginge napi, vawtkhol ngawl in a topa deina bang in seam ngawl hi, tua naseam pa sia nasia mama in a liam dong vatcip tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ahihang topa deina a heak ngawl hu in, a vawt te nasiatak liamna thuak tak napi, tawmbek liam in vat tu hi. Banghangziam cile khatpo tungah tam mama a pia a hile, ama tungah tam mama ki ngen kik tu hi: taciang mitampi a ap le, tampi ma ki ngen kik tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Leitung ah mei kuangsak tu in kongpai hi; taciang a kuang zo bang hi zen thong le, bangza in uk khi ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ahihang thuak tu baptisma khat nei khi hi; tasia ka vawt ma teng ka thin nuam thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Leitung ah kilemna pia tu in hongpai hi, ci hong ngaisun nu ziam? hong ci khi hi, tabang hi ngawl hi; kikhenna tu in hongpai zaw khi hi: ");
INSERT INTO csy_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Banghangziam cile tu pan kipan in inn khat sungah mihing nga a omte ki khen tu a, thum te a dang ni te in langpan tu hi, taciang ni te a dang thum te in langpan tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","A pa in a tapa taw ki khen in ki langpan tu a, a tapa in zong a pa langpan kik tu hi; a nu in a tanu langpan tu a, a tanu in zong a nu langpan tu hi; a nu in a mo langpan tu a, a mo in zong a tonupi langpan tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus in mipi te tung ah, Nitum na sang pan mei hong kai ciang in, ngua zu tu hi, na ci thei pai uh a; zu takpi hi. ");
INSERT INTO csy_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Thangsang pan in hui hong va le, khualum tu hi, na ci uh a; lum takpi hi. ");
INSERT INTO csy_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","No a ki hitheamsak te, van le lei pan in khuahun he thei nu hi; ahihang banghang in, tu hun paizia tel thei ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Hi hi, banghang in thu man khat sia thukhen ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mihing khat in zum hong then le, zum na thet uh ma lamkal ah, a kung pan na suatak thei natu hanciam in; tabang na hi bale, thukhen pa kungah hong ap tu a, thukhen pa in palik te kungah hong ap in, palik te in thong hong taksak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na liausum na piaksiat mateng, thonginn sung pan in suakta ngawl tu ni hi, ci in kong son hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Taciang Pilate in amate biakpiakna taw Galilee te thisan hel hi, ci in Jesus kungah a son pawlkhat om hi. ");
INSERT INTO csy_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesus in amate tungah hibang in zo hi, Hi Galilee mite sia tabang a thuak uh hu in, a dang Galilee mite theampo sang in mawzaw uh hi, ci in ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kong ci hi, hi ngawl hi: ahihang noma zong na ki sikkik bua uh le, na vekpi in tabangma in na lalcip tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Siloam tausang cim in hukcip a, a thi sawm le liat te, Jerusalem a teang ngualdang te sang in mawzaw uh hi, ci in ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kong son hi, hi ngawl hi: ahihang note zong na ki sikkik bua uh le, na vekpi in tabangma in na lalcip tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesus in hi sontena zong son hi; Mi khat in a sapit huan sungah theikung khat suan hi; taciang a nga zong tu in hongpai a, khat zong mu ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Taciang in sapit huan cing te tung ah, en in, hi theikung tungah a nga zong tu in ka pai a, kum thum sung khat zong mu ngawl khi hi: phuk lel in; banghang in leitang deap lel in koi tu hi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huan cing pa in, Topa awng, tu kum sung om hi lai po hen, a kiim teng pan lei taw tu khi hi, taciang eaklei pia phot hi lai tu khi hi: ");
INSERT INTO csy_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hong nga a hile, pha hi: taciang hong nga bua a hi le tua zawkciang phuk in, ci hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesus sabbath ni khat synagogue khat sungah thuhil hi. ");
INSERT INTO csy_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Taciang, en vun, cinasak doai in kum sawm le kum liat sung zawngkhal in a thaneamsak numei khat om hi, taciang ama sia a cing zong bawng a, bangbang po in a om zong ama le ama ki mamsak thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tua nu Jesus in a mu ciang in, a kungah sam a, Nu mei awng, na natna pan in na suakta zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesus in a tungah a khut nga hi: ta sia pociang thakhat thu in ding tang thei a, Pathian pok hi. ");
INSERT INTO csy_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesus in sabbath ni in a damsak hu in, synagogue lampui pa a thin-uk a, ni luk sung nasep tu sia a ngeina hi: tua ahikom tua ni luk sung in hongpai tavun, sabbath ni in hongpai heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tasiaciang in Topa in, Nang a ki hitheamsak pa, note sungah khatpo, sabbath ni in na khui uh a hibale, na laa uh a khau sut in, tui dawn tu in paipui hi ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kum sawm le kum liat sung Satan hencip, Abraham tanu sia tua a ki hencip napan sabbath ni in suatak tu hi ngawl ziam? ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hi teng a son zawkciang in, a ngal te theampo maizum in om uh hi: taciang Jesus in a vawt nalamdang te hang in mi theampo lungdam uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesus in, Pathian kumpingam sia bangtaw kibang ziam? bangtaw sonte tu khi ziam? ");
INSERT INTO csy_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mi khat in ankamci la a, huansung ah a poai taw kibang hi; tua anci hong khang a, thingkung lianpui hong suak hi; a bak te tungah van a vacim te ngiak hi. ");
INSERT INTO csy_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesus in son thua kik a, Pathian kumpingam sia bangtaw sonte tu khi ziam? ci kik hi. ");
INSERT INTO csy_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nupi khat in tol la a, an hui law thum sungah hel hi, tua tol in an hui theampo a thosak taw kibang hi. ");
INSERT INTO csy_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesus Jerusalem sangah pai a, khuapi le khuano tampi ah pai in thuhil hi. ");
INSERT INTO csy_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Khat hongpai a, Topa awng, ngupna a nga tu mihing tawmbek a hi ziam? ci in dong hi. Tasiaciang Jesus in, ");
INSERT INTO csy_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Kongkha ciak na pan tum tu in hanciam vun: banghangziam cile mihing tampi te tum tu hanciam napi, a tum thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Innteakpa topa sia khat vei tho a, kongkha a kha zawkciang in, note a puasang ah ding in kongkha na king uh a, Topa, Topa awng, kong hong hon tan; na ci uh ciang in, Topa in, koisung pan hongpai nu ziam, hong he ngei ngawl khi hi, hong ci tu hi: ");
INSERT INTO csy_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tasiaciang in, note in, na mai ah an ne tui dawn in om khu hi, taciang ka lampi uh ah zong thuhil ni hi, ci tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ahihang ama in, hong son khi hi, kong pan hongpai nu ziam, hong he ngawl khi hi; no na phangawl seam te, ka kung pan tai tavun, ci tu hi. ");
INSERT INTO csy_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob le kamsang theampo te sia Pathian kumpingam sungah na mu uh ciang in, note a puasang ah hong vawk tu a, tua mun ah kaana le ha ngoaina om tu hi. ");
INSERT INTO csy_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Amate nisua na sang, nitum na sang, sak le thang pan in hongpai tu uh a, Pathian kumpingam sungah to tek tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Taciang, en vun, a khakbel te masabel tu a, a masabel te nungkhakbel tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tua ni in Pharisee pawlkhat te Jesus kungah hongpai uh a, hi mun pan pusuak in a, pai in: banghangziam cile Herod in hong that tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Taciang Jesus in amate tung ah, Pai tavun a, tua ngia tungah son vun, en in, doai te hawlkhia khi hi, taciang tuni le zingciang cina te damsak khi hi, taciang nithum na ciang in ka cialcing tu hi. ");
INSERT INTO csy_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ahihang tu ni, zingciang le thai ciang vak hamtang tu khi hi: banghangziam cile kamsang khat sia Jerusalem puasang ah lalcip thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Maw Jerusalem, Jerusalem awng, kamsang te na that a, na tungah a ki sawl te suangtum taw na deang hi; akpui in a note a tha nuai ah a uap bang in, tamvei mama hong uap nuam ka hi hang, na uk bua hi! ");
INSERT INTO csy_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","En vun, na inn uh dap khipkhep in ki nusia tu hi: a mantak kong ci ciang, Topa min taw hongpai pa thuphatoai a hihi, na ci uh mateng, note in hong mu nawn ngawl tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabbath ni khat Jesus Pharisee upa te sung pan khat i inn ah anne tu a pai ciang in midang te in encik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Taciang, en vun, a khut le a peang a tum pasal khat Jesus mai ah om hi. ");
INSERT INTO csy_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesus in thukhamhil te le Pharisee te, Sabbath ni in cina damsak sia ngeina a hi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tasiaciang in amate pau ngawl in om uh hi. Taciang Jesus in cina pa len in damsak a, ciasak hi; ");
INSERT INTO csy_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jesus in amate tung ah, Note sung pan khatpo in a laa a hibale, a khui dumsung tak bang hile, sabbath ni in kai kik tu a, a pusua ngawl tu na om uh ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Amate in hi thu zong bangma a zo kik thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","A ki sam leangna te in to na phabel te teal uh hi, ci a mu ciang in; amate tungah sontena khat son hi, ");
INSERT INTO csy_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Khat po in mopoai ah hong sap ciang in, a sangbel indoi sungah to heak in; nang sang in a zatak huai zaw a sam a hile; ");
INSERT INTO csy_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nang hong sam sia hongpai tu a, ama na to na pial in; hong ci le, a niambel inndoi sung na to suk tu na maizum tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ahihang ngual in hong sap ciang in, a niambel inndoi ah pai in to in; taciang nang hong sam te hongpai ciang in, lawm awng, a sang zaw ah ka to in, hong ci tu hi: taciang in na an kuang umpui te mai ah zatakna na nga tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Banghangziam cile a kuamapo ama le ama a ki lamsang peuma ki khiasuk tu a; ama le ama a ki niamkhiak peuma ki lamsang tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesus in a sam pa tung zong ah, Zing an ahizong, nitak an ahizong, na vawt ciang in, na ngualtam, na suapui, mealheak, mihau innpam te sam heak in; tabang in na sam a hile amate in nangma hong sam thuk kik tu a, hong lo kik tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ahihang poai na vawt ciang in, mizawng, pumpi cing ngawl, peangbai le mittaw te sam in: ");
INSERT INTO csy_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Taciang nangma in thupha na sang tu hi; banghangziam cile amate in hong thukkik zo ngawl tu hi: mi thutang te thawkik na ni ciang hong thukkik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Anneak poai ah a ankuang umpui sung pan khat in, hi thu te a zak ciang in, Pathian kumpingam sungah anluum a ne tu te thuphatoai a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus in tua pa tungah hibang in son hi, Mi khat in poai lian mama khat vawt a, khual tam mama hil hi: ");
INSERT INTO csy_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nitak an neak hun ciang in a naseam te sawl a, a hil sa uh te kungah, Pai tavun; banghangziam cile tu in na theampo ki nginsa hi zo hi, ci in sonsak hi. ");
INSERT INTO csy_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","A sap te theampo ki tuiton tak in kamzong tek uh hi. A masabel khat in lo ciing khat ka lei a, pai in ka et kul tu hi: hong telthiam tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","A dang khat in, kuital kap nga ka lei a, pai in tuate ki sinsak nuam khi hi: hong telthiam tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","A dang khat in, zi ka nei a, hongpai thei ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Naseampa a topa kungah pai kik a, thu theampo son hi. Taciang innteakpa a thin-uk a, manlang in khuasung lampi le lamzin teng ah pai tan a, mizawng, pumpi cing ngawl, peangbai le mittaw te hong paipui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Naseam pa in, Topa awng, na thupiak bang in vawt zo khi hi, ahihang mun awng lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Taciang a topa in naseam pa kungah, lamzikpi le daipam teng ah pai tan a, ka inn a dim thei natu, hongpai hamtang natu in sam in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Banghangziam cile, keima in hong ci khi hi, kasap te khat zong in ka nitak an tep ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mihon tampi te in a nung pan zui uh hi: taciang Jesus amate sang kihei a, ");
INSERT INTO csy_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Mi khatpo ka kung hongpai in, a nu le a pa, a zi le a ta te, a suapui, a nau nu te le ama nuntakna zong a ensan bale, ka nungzui hi thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","A kuamapo in ama thinglamte pua in ka nung pan hong zui ngawl peuma, ka nungzui hi thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Banghangziam cile note sung pan khatpo in, tausangsak tu a sawm le, a man dong a cing tu le a cing ngawl tu to masa in aman tuat tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tabang tuat masa ngawl in, khuambul a phu zawkciang, a man dong a sa bale, a mu theampo in selno tu a, ");
INSERT INTO csy_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Hisia pa in tausang sa napi, manzo ngawl hi, ci tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","A hibale kumpi khat in, a dang kumpi khat taw ki sim tu a hile, ama do tu in ngalkap tul kul taw hongpai sia, ngalkap tul sawm taw do thei tu le do thei ngawl tu, ci sia to in thu ngaisun masa ngawl tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A do thei bua tu le, kumpi dangkhat kungah, a khuala lai in kilemna vawt tu in, palai paisak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Tabangma in, note sungah a kuamapo in a neisa theampo a nusia bua a hile, ka nungzui hi thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ci sia pha hi: ahihang a al na a bo le, bangbang in al kiksak thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Leitang atu le phangawl, eaklei zong kizang thei ngawl hi; ahizong mihing te in a puasang ah vawk hi. Zak natu bil a nei theampo in za tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Siadong te le mawnei te Jesus thu ngai tu in a kungah hongpai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Taciang, hisia pa in mawnei te sang a, amate taw an ne khawm hi, ci Pharisee te le thukhamhil te phun uh hi. ");
INSERT INTO csy_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Taciang Jesus in hi sontena amate tungah son hi. ");
INSERT INTO csy_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Note sungah khatpo in, tuu zakhat nei a, khat bo a hile, sawm kua le kua teng duisung ah nusia in, a bo tuu a mu dong zong tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A mu ciang in, lungdam in a liangko mual suan hi. ");
INSERT INTO csy_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Inn a thet ciang in, a lawm te le innpam te samkhawm tek a, hong lungdampui tavun; banghangziam cile a bo ka tuu mukik khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Keima in kong son hi, tasia bangma in, mawna kisikkik ngawl mihing sawm kua le kua te sang in, mawna a ki sikkik khat tung ah, vantung ah lungdamna tamzaw tu hi. ");
INSERT INTO csy_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","A hibale, numei khat in dangka pia sawm nei a, pia khat a bosua le, khuaimei de in, a inn phiat tu a, hanciam in a mu dong zong tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A mu ciang in, a lawm te le a innpam te samkhawm in, hong lungdam pui tavun; banghangziam cile ka bosua dangka mukik zo khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tasia bangma in, keima in kong ci hi, a ki sikkik mawnei khat tungah Pathian vantungmi te sungah lungdamna om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus in hibang in ci hi, Pasal khat in tapa ni nei a: ");
INSERT INTO csy_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","A nozaw in a pakung ah, pa awng, ka lua tu ngamh hong pia tan, ci hi. Taciang a pa in a neisa theampo a tate ni hawmsak hi. ");
INSERT INTO csy_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ni tam ngei ngawl in a tapa nozaw in a nga teng theampo kaikhawm a, ngam khuala mama ah khualhaw hi, taciang a neisa theampo a ukbang in pakvawt in zang vapeak hi. ");
INSERT INTO csy_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","A nei theampo a zaksiat zawkciang, tua ngam ah kialpi tung a; ki tangsam mama in om hi. ");
INSERT INTO csy_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Tua ngam mi khat kungah pai a, tua pa in vok an pia tu in a lo ah paisak hi. ");
INSERT INTO csy_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Vok i neak be haw nangawn a khamteak in ne nuam napi: kuama in bangma pia ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","A thin ciim ciang in, ka pa kungah a kicial naseam te bekzong an a kham in nei uh a val lai hi, kei ka hile ngilkial in mangthang tu ka hi zo hi! ");
INSERT INTO csy_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tho in, ka pa kungah pai tu khi hi, taciang ama tung ah, pa awng, vantung le na mai ah khial zo khi hi, ");
INSERT INTO csy_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na tapa ci tu zong ki phu nawn bong: na cial tawm naseam khat bang in hong koi tan, ka ci tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Taciang ama hong ding a, a pa kungah pai hi. Ahihang a khuala mama kisam lai na pan, a pa in mu hi, taciang khuangaihuai sa in tai a, a ngawng pan koai in nam hi. ");
INSERT INTO csy_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Taciang, a tapa in a pa kungah, pa awng, vantung le na mai ah maw zo khi hi, na tapa ci tu zong ki phu nawn ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ahihang a pa in a naseam te kungah, puan a phabel hong la tavun a, silsak vun; a khut ah khutzungbu bulsak vun, taciang a peang ah peangdap bulsak vun: ");
INSERT INTO csy_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Taciang khuino thau khat hong la tavun a, ngo vun; taciang i ne khawm tek tu a, thinnuam in i om khawm tek tu hi: ");
INSERT INTO csy_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Banghangziam cile hi ka tapa sia thi hi, ahizong, nungta kik hi; bo hi kale, ki mu kik hi, ci hi. Tabang in thinnuam in om khawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tu in a tapa lianzaw lo ah om hi: lo pan hong cia a, inn nai a thet ciang in lasa le lapna aw nging te za hi. ");
INSERT INTO csy_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Taciang naseam khat sam a, hi thu te a bangthu ziam, ci dong hi. ");
INSERT INTO csy_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tua naseam pa in, na naupa hong cia a; cidam ludam in hong thengkik ahikom, na pa in khuino a thau khat ngaw hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A tapa lianzaw sia a thin-uk ahikom, innsung zong tum nuam ngawl hi: tua ahikom a pa pusuak a, innsung ah tum tu in tho hi. ");
INSERT INTO csy_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","A pa hibang in zo hi, en in, kum tam mama na na seam khi hi, na thupiak bangma hun peal ngei ngawl khi hi: ahihang ka lawm te taw thinnuam khawm tu in, kealno khat zong hong pia ngei ngawl ni hi: ");
INSERT INTO csy_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ahihang hina tapa, pumpi kizuak te taw na neisa theampo hong sut pa hong cia pociang in, khuino thau ngaw ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Taciang a pa in ama tung ah, ka tapa awng, nang sia keima taw om tawntung ni hi, taciang ka neisa theampo sia nangma' a hihi. ");
INSERT INTO csy_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ahihang na naupa sia, thi napi, nungta kik hi; bo napi, tu in mu kik khi hi, tua ahikom thinnop na le lungdamna ka vawt tu ki lawm hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesus in a nungzui te tung ah, Mihau khat om a, neisa keam tu khat nei hi; tua pa in na neisa teng bo thongsak siat hi, ci in a topa tungah ki mawsiat hi. ");
INSERT INTO csy_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Taciang a topa in sam a ama tung ah, na thu ka zak te bangbang ziam? ka van na kep teng sazian hong pia tan; banghangziam cile ka neisa keam hi nawn ngawl tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tasiaciang in neisa keam pa in, ka topa in ka nasep pan hong tawlngasak tu a hi ciang in, bang vawt tu khi ziam? lo le ka tho thei bua a; khutdaw ngen tu le ka maizum hi. ");
INSERT INTO csy_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Neisa keam dinmun pan hong tawlngaksak ciang in, amate inn ah hong san thei natu in ka vawt tu ka he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tua ahikom a topa kungah leiba nei te theampo sam a, a masabel pa kungah, ka topa tung bangza ba ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tua pa in, sathau pheal zakhat, ci hi. Taciang neisa keam pa in, na sazian la tan a, a manlang in to in, taciang pheal sawm nga ci at in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","A dang khat kungah, nang e, bangza ba ni ziam? ci hi. Ama in, zungtang hui ip zakhat, ci hi. Taciang neisa keam pa in, na sazian la tan a, ip sawm liat ci at in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hi a thuman ngawl neisa keampa in thimtheltak in a vawt nate a topa in pok hi: banghangziam cile, leitung mihing te sia amate hun sung, khuavak tate sang in lupil zaw uh hi. ");
INSERT INTO csy_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Keima in kong ci hi, note hileitung pan na pusua uh ciang in tawntung omna biakbuk sungah hong sang tu na nei thei natu uh in, leitung sum le pai taw ngualtam vawt vun. ");
INSERT INTO csy_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","A tawmno ah a thuman peuma a tampi ah zong thuman hi: A tawmno ah a thuman ngawl peuma a tampi tungah zong thuman ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tua ahikom a kip ngawl neisa tungah thuman ngawl na hi uh le, a kua in hauna tatak hong ap ngam tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ngual dang neisa tung nangawn ah thuman ngawl na hi uh le, noma nei tu in a kua in hong pia ngam tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mihing khat in to ni na seam thei ngawl tu hi: banghangziam cile khat ensan tu a, a dang khat it tu hi; khat beal tu a, a dang khat ngaingon tu hi. Note in Pathian le nei le lam naseam hi khawm thei ngawl tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","A duhop Pharisee te in hi thu te theampo a zak uh ciang in, Jesus selno in nui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tasiaciang in Jesus in amate tungah hibang in ci hi, Note in mihing te mai ah noma le noma ki thutangsak nu hi; ahihang Pathian in na thinsung uh hong he hi: banghangziam cile mihing te sungah a sang mama in a ki ngaisun te, Pathian mai ah lipkhap huai mama hi. ");
INSERT INTO csy_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","John hong thet dong thukham le kamsang thu te om hi: tua hun pan kipan Pathian kumpingam thu pualak uh a, mi theampo phul in tum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Thukham sungah a nobel a bawk no khat sang in, van le lei a bo tu ol zaw lai hi. ");
INSERT INTO csy_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","A kuamapo a zi khul a, zi dang a nei sia, palngul mawna vawt a hihi: taciang a pasal in a khul numei a tenpui sia zong palngul mawna vawt ma a hihi. ");
INSERT INTO csy_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Mi hau khat om a, puan sannum le puan neamno a pha mama sil in, nisim nuamsa in nungta hi: ");
INSERT INTO csy_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Taciang a pumpi tung theampo meima taw a dim, Lazarus a kici khutdaw ngen khat om a, mi hau pa kongbiang ah ngual in koi hi. ");
INSERT INTO csy_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mihaupa sabuai pan a tak anneng te ne nuam in om a, ui hongpai in a meima te liasak hi. ");
INSERT INTO csy_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Khutdaw ngen pa thi a, vantung mite in Abraham kang sungah paipui hi: taciang, mihaupa zong thi a, phum hi; ");
INSERT INTO csy_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Taciang a ngim thuak na hell sung pan a tungsang a et ciang in, a khuala mama na ah Abraham mu hi, taciang a kangsung ah Lazarus om hi. ");
INSERT INTO csy_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Mihaupa au in, ka pa Abraham awng, hong hesuak kapo in, hi meikuang sungah ngim na thuak kahikom Lazarus in a khutzung dawn tuisung ah papsuk in, ka lei hong votsak natu in sawl in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ahihang Abraham in, ka tapa awng, na nuntaksung a pha theampo sang zo ni hi, tabangma in Lazarus sia a phangawl teng sang hi: ahizong tu in ama sia henepna nga zo a, nang na hile ngimna na thuak hi, ci phawk in. ");
INSERT INTO csy_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hiteng theampo bek domngawl, kote le nangma ki laklaw ah luam lian mama om hi: tua ahikom hi mun pan in na kungah ki pai thei ngawl a, nangma kung pan zong ko kung ki pai thei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tasiaciang in mihaupa in, tua a hi ciang, ka pa Abraham awng, Lazarus sia ka pa inn ah paisak tu in hong ngen khi hi: ");
INSERT INTO csy_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Banghangziam cile, suapui nga nei lai khi hi; hi ngimna sungah hong thet ngawl natu uh in Lazarus in amate tungah tettipang tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham in, amate in Moses le kamsang te nei hi; tuate thu ngai tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Taciang in mihaupa in, hi ngawl hi, ka pa Abraham awng: mithi te sung pan in khat amate kungah pai a hile, amate ki sikkik tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham in ama kungah, Moses le kamsang te thu a ngai nuam bua a hile, khatpo thina pan a thokik hial zong in ngai nuam tuan ngawl tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesus in a nungzui te tung ah, Mawna sungah puk le khial thak ngawl tu sia suak thei ngawl hi: ahihang tabang a thengsak sia a mailam bing hi! ");
INSERT INTO csy_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Patang no khat khialsak tu sang in, a ngawng ah an ngoaina suang khit in, tuipi sungah ki khiasuk le, ama atu in phazaw hi. ");
INSERT INTO csy_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Noma le noma kidawm vun: na suapui pa na tungah hong khial le, tei in; a ki sikkik a hile, maisak in. ");
INSERT INTO csy_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Na tungah ni khat sung sali vei dong hong khial a, na tungah sali vei dong hongpai in, kisik khi hi, hong cile, maisak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Sawltakte in, Topa tung ah, ka upna uh hong khangsak tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Taciang Topa in, Note in ankamci cia upna nei le uh te, hi theikung mun ah, na bul pan kilong in, tuipi sungah ki phut in; ci le uh te, na thu hong ni tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ahihang note sungah khatpo in, lo tho, a hibale tuucing naseam khat nei in, tua naseampa lo pan hong cia pociang, pai in a, anne tu in to in, ci a kua in ci tu nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ka an neak tu hong vawtkholsak tan a, an hong thuk tan, ka neak ka dawn man dong hong ngak tan, tua zawkciang in ne in a, dawn kik in; ci tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Naseam pa in thupiak teng a vawt siat zawkciang a topa in lungdam a ko tu ziam? Ko tu um ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tabangma in, note zong thupiak theampo na vawt siat zawk uh ciang, kote sia phattuam na nei ngawl naseam te ka hi uh hi, ka sep tu nasep a seam bekma khu hi, ci tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesus Jerusalem a pai uh a, Samaria le Galilee ngamngi tawn in pai hi. ");
INSERT INTO csy_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Khua khat sungah a tum uh ciang in, miphak sawm te taw kisi a, a khuala na ah ding in: ");
INSERT INTO csy_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jesus, Topa awng, hong hesuak tan, ci in a nging tatak in au uh hi. ");
INSERT INTO csy_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesus in amate a mu ciang in, Pai tavun a, thiampi te kungah noma le noma ki lak tavun, ci hi. Amate a pai uh laitak in, a vekpi in thiangtho siat uh hi. ");
INSERT INTO csy_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amate sung pan khat in damzo khi hi, ci a mu ciang in, heakkik a, aw ngingtak taw Pathian pok hi, ");
INSERT INTO csy_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Taciang Jesus peang ah bok a, lungdam ko hi: ama sia Samaria mi a hihi. ");
INSERT INTO csy_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesus in, Mihing sawm ki thiangsak hi ngawl ziam? Ahihang a dang kua te, koisung ah om ziam? ");
INSERT INTO csy_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Hi ngamdang mi simngawl Pathian pok tu in a heakkik mu ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Taciang in Jesus in, Tho in a, pai in: na upna in hong damsak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pharisee te in, Pathian kumpingam sia banghun ciang hong theng tu ziam? ci in Jesus dong uh hi, Jesus in, Pathian kumpingam sia mit taw mu thei in hong theng ngawl tu hi: ");
INSERT INTO csy_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Hi mun ah en vun! a hibale, zesung ah en vun! ci in kuama in hong ci ngawl tu hi, banghangziam cile, en vun, Pathian kumpingam sia note sungah om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesus in a nungzui te tung ah, Mihing Tapa ni sia, nikhat sung bek zong na mu nop mama uh hun hong theng tu hi, ahihang mu tha ngawl tu nu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Note tung ah, hi mun ah en vun; a hibale, zesung ah en vun, hong ci tu uh hi: tabang te nung pan zui tha heak vun. ");
INSERT INTO csy_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Banghangziam cile, khualeng sia, van mong khat pan mong khat dong a tang bang in, mihing Tapa ni zong tabangma hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ahizong a masabel in ama in nasiatak thuak tu a, tu hun mihing te in nial tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noah hunlai bangma in mihing Tapa hun ciang zong tabangma hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noah tembaw sung tum a, tuiliim in mi theampo a bocip siat dong, amate ne le dawn, mopui motha in om tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Tasia bangma in Lot hun lai zong amate ne le dawn, van zuak, thingkung cing le inn sa in om tek uh hi; ");
INSERT INTO csy_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ahihang Lot sia Sodom khua pan a pusua ni ciang in, van pan mei le kat sia ngua bang in zu a, a vekpi in susia siat hi. ");
INSERT INTO csy_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Mihing Tapa hong ki pualak ni ciang zong tabangma hi tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tua ni ciang in, innkhum tung a om te, innsung ah van la tu in tuaksuk nawn heak hen: lo ah a omte zong inn ah ciakik nawn heak hen. ");
INSERT INTO csy_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot i zi na phawk tavun. ");
INSERT INTO csy_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","A kuamapo ama nuntakna a hung nuam peuma a nuntakna sum tu hi; a kuamapo a ma nuntakna a sum peuma nuntakna nga tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Keima in kong ci hi, tua ni zan ciang lupna khat tungah mi ni lumkhawm tu hi; khat ki la tu a, khat ki nusia tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Numei ni an ngoai khawm tu hi; khat ki la tu a, khat ki nusia tu hi. ");
INSERT INTO csy_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pasal ni lo sungah na seam khawm tu hi; khat kila tu a, khat ki nusia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ama te in, Topa, koisung hi tu ziam? ci in dong uh hi, Jesus in amate tung ah, Mithi luang om na mun theampo ah vaciik te ki kaikhawm tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tuazawkciang Jesus in a nungzui te tungah thinkiam ngawl a, a thunget tawntung natu a hilna in thusontena te son hi; ");
INSERT INTO csy_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Khuapi khat sungah Pathian a lau ngawl, kuama zong a khual ngawl, thukhenpa khat om hi: ");
INSERT INTO csy_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tua khuapi sungah meingong khat om hi; thukhen pa kungah pai a, ka ngal pa phu hong lamsak tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Thukhenpa in hun saupi sung thukhensak ngawl in om hi: ahihang a khakbel ciang ama in, keima sia Pathian kita ngawl in mihing zong kuama khual tuan ngawl ka hi hang; ");
INSERT INTO csy_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Hi meingong nu in hong nawngkaisak ahikom, phu lamsak tu khi hi, tabang hibale hongpai tawntung tu a, hong nawngkaisak tawntung tu hi, ci ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Topa in, A man ngawl thukhenpa son na ngai vun. ");
INSERT INTO csy_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ama sia haisang napi, Pathian in a tealsa te, sun le zan in Ama kungah a au te phu lamsak ngawl in om tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Keima in kong ci hi, a manlangtak in phulamsak tu hi. Ahihang mihing Tapa hongpai ciang in, hi leitung ah upna a mu tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus in, mipha khi hi, ci amate le amate ki muang mama a, ngualdang a thusimngawl te kungah hi sontena son hi: ");
INSERT INTO csy_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Mihing ni thungen tu in biakinn ah pai uh hi; khat sia Pharisee hi a, a dang khat sia siadong a hihi. ");
INSERT INTO csy_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pharisee pa hong ding to a, Pathian awng, keima sia phalak te, thuman ngawl te, palngul mawna vawt te, a hibale siadong pa bang ka hi ngawl man in ka lungdam hi. ");
INSERT INTO csy_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nipi khat sung ni vei antang khi hi, ka neisa theampo sung pan se sawm sua se khat pia khi hi, ci in thungen hi. ");
INSERT INTO csy_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Taciang siadongpa sia, a khuala na ah ding a, van lam zong en ngam ngawl in, a awm tum in, maw Pathian awng kei mawneipa tungah hesuakna hong nei po tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Keima in kong ci hi, hisia pa sia a dang khat sia sang in thutang suana nga zaw a, a inn ah cia hi: banghangziam cile ama le ama a ki lamsang peuma khiaksuk na thuak tu a, ama le ama a ki niamkhiak peuma ki lamsang tu hi. ");
INSERT INTO csy_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amate in patang te a thamsak tu a dei uh hu in, Jesus kungah paipui uh hi: tua thu a nungzui te in a mu uh ciang in amate tei uh hi. ");
INSERT INTO csy_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ahihang Jesus in, patang te ama kungah sam a, Patangte ka kungah hongpai tahen, khak heak vun: banghangziam cile Pathian kumpingam sia hibang te atu a hihi. ");
INSERT INTO csy_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A man tatak kong ci ciang, a kuamapo in Pathian kumpingam sia patangno te bang in a sang thei ngawl peuma tua kumpingam sungah tum thei ngawl tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Lampui khat in Jesus kungah, Sya pha awng, tawntung nuntakna ka nga thei natu in bang vawt tu khi ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesus in, Banghang in pha hong ci ni ziam? Pathian khatbek simngawl mipha dang kuama om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Thupiakte na he hi, palngul mawna vawt heak in, tualthat heak in, nguta heak in, a man ngawl tetti son heak in, na pa le na nu zakta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tua tangval pa in, hite theampo sia ka nolai pan ma in ka zui sa hi zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Hi thu te Jesus in a zak ciang in, a kungah, Na khat na kisam lai hi: na neisa theampo zuak in a, mizawng te hawmsak in, tua hile vantung ngam ah nei le lam na nei tu hi: taciang hongpai tan a, hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Hi thu a zak ciang in khuangai mama hi: banghangziam cile ama sia mihau mama a hihi. ");
INSERT INTO csy_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesus in a khuangai mama a mu ciang in, Mihau te Pathian kumpingam sung a tum tu bangza in haksa ziam! ");
INSERT INTO csy_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Banghangziam cile mihau khat Pathian kumpingam sung a tum tu sang in, kala-uk khat phin bilvang sung a tum tu ol zaw hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tua thu a zate in, kua peuma ngupna nga thei tu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesus in, Mihing te taw a piang thei ngawl te sia, Pathian taw piang thei siat hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tuazawkciang in Peter in, en in, ka neisa uh theampo nusia in hong zui khu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Taciang Jesus in amate tung ah, A man tatak kong ci ciang, Pathian kumpingam atu in, a inn, a nu le a pa, a suapui, a zi, a hibale a tate a nusia peuma, ");
INSERT INTO csy_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Tu hun sung in a se tampi le hongpai lai tu hun sungah tawntung nuntakna a nga ngawl tu om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesus in a nungzui sawmleni te ama kungah sam a, amate tung ah, En vun, Jerusalem ah i pai hi, kamsang te in mihing Tapa thu a atkholsa thu theampo tangtung tu hi. ");
INSERT INTO csy_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gentile te khutsung ah ap tu a, selno na zong thuak tu hi, vawtsiatna zong thuak tu a, cil zong phi tu uh hi: ");
INSERT INTO csy_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Amate in vel tu a, that tu uh hi: taciang ni thum ni ciang tho kik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amate in hi thu khat zong a tel bua uh hi: hi a son te sia amate kung pan ki phualseal hi, tua ahikom Jesus i son thu te khat zong a tel bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesus Jericho nai na hong thet ciang in, mittaw khat lamhui ah khutdaw ngen in to hi: ");
INSERT INTO csy_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Mihonpi in a kantan thu a zak ciang in, bang thu ziam, ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Amate in, Nazareth mi Jesus in hong kantan hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Taciang ama in, Jesus, nang David Tapa awng, hong hesuak ka po in, ci au hi. ");
INSERT INTO csy_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A mai a pai te in a om khipkhep natu in tei hi: ahihang, nang David Tapa awng, hong hesuak ka po in, ci a nasia seseam in au hi. ");
INSERT INTO csy_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Taciang Jesus ding a, a kungah paipui tu in thupia hi: a nai ah hongpai ciang in, ");
INSERT INTO csy_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Bang vawtsak tu dei ni ziam? ci in dong hi. Ama in, topa awng, khua ka mu nuam hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Taciang Jesus in a kungah, Khua mu in: na upna in hong ngum zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Thakhat thu in khuamu a, Jesus zui in Pathian min pok hi: taciang a mu te theampo in Pathian minthang pok uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesus Jericho khua sungah tum in kantan hi. ");
INSERT INTO csy_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Taciang en vun, siadong te lampui Zacchaeus a kici khat om a, ama sia hau mama hi. ");
INSERT INTO csy_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesus sia a kua ziam, ci mu nuam in zong napi; mihing tamlei bek domngawl ama sia a tuntom ahikom mu thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Taciang mipi te mai ah tai a, Jesus mu thei tu in theikung tungah ka to hi: banghangziam cile tua lampi ah Jesus hongpai hi. ");
INSERT INTO csy_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tua mun ah Jesus a thet ciang in, a tung ento a, Zacchaeus mu hi, taciang ama tung ah, Zacchaeus, manlangtak in tuaksuk in; banghangziam cile tuni na inn ah hong tam tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus manlangtak in hong tuaksuk a, lungdamtak in Jesus a sang hi. ");
INSERT INTO csy_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tua thu amate in a heak uh ciang in, a vekpi in phun uh a, hisia pa sia mawnei pa inn ah leangna hi tu in pai hi, ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Tasiaciang Zacchaeus ding a, Topa kungah, en in, Topa awng, ka neisa a lang sia mizawng te pia khi hi; taciang khatpo tung pan in na khatpo a man ngawl in mawsiatna taw ka laksak a hile, a se li in lokik khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesus in ama tung ah, Tuni hi inn sungah ngupna theng hi, banghangziam cile ama zong Abraham tapa a hihi. ");
INSERT INTO csy_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Banghangziam cile mihing Tapa sia a bo te zong tu le ngum tu in hongpai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Amate in hi thu te a zak ciang in, sontena khat son thua hi, banghangziam cile ama sia Jerusalem nai zo a, mite in Pathian kumpingam sia thakhatthu in hong ki lang tu hi zo hi, ci ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tua ahikom hibang in ci hi, Ulian khat sia kumpipa ukna ngam a san zawkciang in hong ciakik tu in, ngam khuala mama ah khualhaw hi. ");
INSERT INTO csy_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A vai din ma in a naseam te sawm sam a, dangka mina khattek ap hi, taciang, hisia taw kong thetkik mateng summet vawt tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ahihang a ngamsung mihing tein tua ulian pa ensan uh ahikom, hisia pa sia kote hong uk tu in dei ngawl khu hi, ci in a nung pan thu vaitha uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tuapa in kumpi ukna za a nga zawkciang hong ciakik a, sum a piak a naseam te khatsim in a summet vawt na uh pan a met bangza nga, ci he nuam in a kungah sam tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","A masabel in khat hongpai a, Topa awng, dangka mina khat pan in sawm a met nga khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Topa in ama tung ah, pha hi, nang, naseam pha: a no mama na tungah muantak nahikom in khuapi sawm tungah thuneina nei tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","A nina pa hongpai a, Topa, dangka mina khat pan in nga a met nga khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Taciang Topa in ama tung ah, nang zong khuapi nga tungah thuneina nei tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","A dang khat hongpai a, en in, ziaksung ah na dangka mina, dial no taw tun in koi khi hi: ");
INSERT INTO csy_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Banghangziam cile nangma sia a sonhak mama mihing na hi man in hong lau khi hi: na koi ngawl pi na la a, na poai ngawl pi zong na at hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Taciang in a Topa in, nang naseam phangawl, nangma kampau pan in thu hong khen tu khi hi. Mihing sonhak ka hina he a, ka koi ngawl na pan la in, ka poai ngawlpi zong at, ci nong he le: ");
INSERT INTO csy_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Banghang in ka sum dangka inn ah koi ngawl ni ziam, koi a hile te kong thet ciang a sum teng a met taw nga tu hi ngawl khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Taciang a hui ah a ding te kungah, a tung pan in dangka mina sia la vun a, dangka mina sawm a neipa pia vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ahihang amate in Topa awng, ama in dangka mina sawm nei zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Note tungah kong ci hi, a neite ki pia thua tu a, a nei ngawl te a neisun po zong ki laksak belap lai tu hi. ");
INSERT INTO csy_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ahihang ka ukna a dei ngawl hibang ka ngalte ka kungah hong paipui tavun a, ka mai ah that vun, ci in Topa in ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hi thu te a son zawkciang in, Jesus sia a nungzui te mai pan in Jerusalem ah pai hi. ");
INSERT INTO csy_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Olive mual ah a om Bethphage le Bethany khua nai a thet ciang in, a nungzui ni sawl a, ");
INSERT INTO csy_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Na mai ah a om khua ah pai tavun a; kuama to ngei ngawl lai laa no khat a ki khit mu tu nu hi: sut vun a, hi mun ah hong paipui tavun. ");
INSERT INTO csy_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Khat po in, banghang sut nu ziam? ci hong dong le, Topa in tulmaw hi, ci vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","A sawl te pai uh a, Jesus in amate tungah a sonkhol bang in mu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Laano a sut uh laitak in, a neite in amate tung ah, banghang laano sut nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Amate in, Topa in tulmaw hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Taciang Jesus kungah hong paipui uh a: laano tungah puan pha in, Jesus suanto uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesus a pai kawm in, lampi ah puan te pha uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olive mualtung pan tuaksuk natu a nai ciang in, nungzui mihonpi theampo in a vanglian nasep te mu uh ahikom, aw ngingtak taw lungdamtak in Pathian pok uh a; ");
INSERT INTO csy_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Topa min taw hongpai Kumpipa thuphatoai tahen: vantung ah nopna om tahen a, a sangbel na mun ah vangletna om tahen, ci in au tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Mihonpi sung a om Pharisee te in Jesus kungah, Syapa awng, na nungzui te tei in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesus in, Keima in kong ci hi, hi te om khipkhep a hile suangtum te thakhatthu in au tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalem nai na hong thet ciang in, tua khuapi en in, kap a, ");
INSERT INTO csy_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Thinnuam in na om thei natu, tuni in bang kisam ziam ci in he thei thong le te maw! Ahizong tua thu mu thei ngawl ni hi! ");
INSERT INTO csy_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Banghangziam cile na ngal te in na kimkot pan in phunglecian bang in hong kimum uh a, kingli pan in hong pang uh hi, ");
INSERT INTO csy_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Taciang nangma le na tate sia leizul in hong mon siat tu hi; taciang suangtum khat le khat a ki thuap in khe ngawl tu hi; banghangziam cile nangma hong ve tu hun na heak ngawl hang a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jesus biakinn sungah tum a, vanzuak te le van lei te nawtkeak siat hi; ");
INSERT INTO csy_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Amate tung ah, Ka inn sia thungetna mun kici tu hi: ci ki at hi, ahihang note in nguta phalak te kua na suaksak uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Taciang Jesus in biakinn sungah nisim in thuhil hi. Ahihang thiampi lian te, thukhamhil te le upa te in Jesus that tu in zong uh hi, ");
INSERT INTO csy_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ahihang thalup thei natu lampi a mu bua uh hi: banghangziam cile mi theampo in a thuhilna phatak in ngai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ni khat Jesus biakinn sungah mipi te thuhil in lungdamna thu a son laitak, thiampi lian te le thukhamhil te upa te taw hongpai uh a, ");
INSERT INTO csy_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jesus kungah, hong son tan, hibang te bang thuneina taw vawt ni ziam? a hibale hi thuneina kua in hong pia ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesus in zo kik a, Kei zong thu khat hong dong tu khi hi; hong zo tavun: ");
INSERT INTO csy_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tuiphumpa John sia, van pan ziam maw, mihing te kung pan ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Amate ngaisun khawm tek uh a, van pan hi; ci leang, ama in, banghang um ngawl nu ziam? hong ci tu. ");
INSERT INTO csy_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","A hi tazong, mihing te kung pan hi; ci leang zong, mihing te in suangtum taw hong sep tu hi: banghangziam cile amate in John sia kamsang hi, ci um uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Taciang amate in, koisung pan, ci hong son thei ngawl khu hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesus in amate tung ah, Kei zong hi te bang thuneina taw vawt, ci sia hong son ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tuazawkciang Jesus in mipi te hi sontena son hi; Mi khat in sapit huan sungah sapit suan a, huan naseam te thosak hi, taciang ama sia a ngei mama om tu in khual khuala ah haw hi. ");
INSERT INTO csy_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","A hun a cin ciang in, huan naseam te in sapit huan sungah a nga te a piak tu in, a naseam khat sawl hi: ahihang huan naseam te in a naseam pa vel uh a, a khut hawm taw tha kik hi. ");
INSERT INTO csy_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Taciang naseam dang khat sawl kik leleau a, tua pa zong vel leleau hi, taciang maizumhuai tak in koi uh a, khut hawm nguak ma tha kik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A thum na sawl kik leleau hi: taciang amate in liamsak uh a, doi pua sangah nawt uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Tuazawkciang in sapit huan nei pa in, bangbang hi tu khi ziam? Ka it ka tapa sawl a hileng, amate in a mu uh ciang zakta tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ahihang huan naseam te in a mu uh ciang in, kikum uh a, hi sia pa sia a ngamhlua tu pa hi: pai tavun, that tawng, taciang a ngamh teng i lua tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Taciang amate in sapit huan puasang ah pusuapui in that uh hi. Tua ahikom huan neipa in amate tungah bang vawt tu ziam? ");
INSERT INTO csy_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ama hongpai tu a hi teng that in a sapit huan sia ngual dang pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus in amate en a, Innsa te i a nil uh suangtum sia innkhuambul hong suak hi, ci a ki atkhol thu sia bang ziam? ");
INSERT INTO csy_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A kuamapo hi suang tungah a tak peuma tal tu hi, ahizong hi suang a takna te sia a vui in ki ngoai siat tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tua hun laitak in thiampi lian te le thukhamhil te in Jesus mat tu in zong hi; banghangziam cile hi thu sontena sia amate langpan in kampau hi, ci he uh hi, taciang amate in mipi te lau hi. ");
INSERT INTO csy_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Amate in Jesus pang uh a, thukan te paisak uh hi, tua thukan te sia mipha bang in ki hitheamsak a, ama kammal pan in mat tu le ngam uk za nei ulian te ap tu in sawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Thukan te in, Syapa awng, a man tatak in hil le kampau ci kong he uh hi, kuama doidan zong nei ngawl ni hi, Pathian i lampi sia a mantak in na hil hi: ");
INSERT INTO csy_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Caesar shia pia tu khu ziam maw, pia ngawl tu khu ziam? ci in dong uh. ");
INSERT INTO csy_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ahihang Jesus in amate thin kukal na he a, Banghang hong ze-et nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Sum tang hong lak tavun. A kua i lim le ceptena ziam? ci hi. Amate in Caesar lim le ceptena hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Taciang Jesus in amate tung ah, Caesar neisa te Caesar pia vun a, Pathian neisa te Pathian pia vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Mipi te mai ah a kammal te pan in a man thei bua uh hi: a zo kik nate lamdangsa uh a, huthe ngawl in om tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Thawkikna a nial Sadducee pawlkhat te Jesus kungah hongpai uh a, ");
INSERT INTO csy_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Sya awng, mi khatpo sia ta nei ngawl in a thi le, a ci mit ngawl natu in a nau in a mo tenpui tahen, ci Moses in at hi. ");
INSERT INTO csy_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Tua ahikom u nau sali om uh hi: a lianbel sia in zi nei a, ta nei ngawl in thi hi. ");
INSERT INTO csy_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","A ni na pa in tua nu tenpui a, ta nei ngawl ma in thi hi. ");
INSERT INTO csy_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","A thum na pa zong in tua nu tenpui hi; tabangma in a sali in tenpui uh a, ta nei ngawl in thi siat uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","A khakbel ciang tua nu zong thi hi. ");
INSERT INTO csy_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tua ahikom thawkik na ni ciang tua nu sia a kua bel i zi hi tu ziam? banghangziam cile a sali in tenpui hi, ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesus in amate tung ah, Hi leitung mite kipui uh a, nupa tu in ki pia uh hi: ");
INSERT INTO csy_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ahihang tua leitang lua tu kilawm ci in ngaisut te le thina pan a thokik te sia kipui le nupa tu in ki piak om nawn ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Amate sia thi thei nawn ngawl tu uh hi: banghangziam cile amate sia vantungmi te bang hi tu uh a, thawkikna i tate a hi uh man in Pathian i tate a hihi. ");
INSERT INTO csy_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tu in mithi te thokik hi, ci Moses zong in lophung sungah topa, Abraham Pathian, Isaac Pathian le Jacob Pathian, a sap ciang in mu hi. ");
INSERT INTO csy_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Banghangziam cile Pathian sia mithi te Pathian hi ngawl hi, ahihang a nungta te i Pathian a hihi: banghangziam cile mi theampo ama sungah a nungta te vive a hihi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Thukhamhil pawlkhat te in, Syapa awng, na pau na pha mama hi, ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tuazawkciang amate in thudong ngam nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesus in amate tung ah, Bangbang in mihing te in Christ sia David tapa hi, ci thei uh ziam? ");
INSERT INTO csy_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David ama mama in Psalm labu sungah, Topa in ka Topa tung ah, ");
INSERT INTO csy_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Na ngalte na peang koi na in na vawt mateng, ka ziatsang ah to in. ");
INSERT INTO csy_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tua ahikom David in Topa, ci in sam hi, bangbang in a tapa hi thei tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tuazawkciang in thu ngai te theampo i zak in a nungzui te tung ah, ");
INSERT INTO csy_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Thuakhamhil te kidawm vun, amate sia puan tualpi sil in vak nuam uh a, sumbuk te ah paupuina, synagogue sungah tokhum sangbel te le poai mun ah a inndoi lianbel te dei uh hi; ");
INSERT INTO csy_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Amate in meingong te inn suttol uh a, ngual mu tu in thu sau tatak ngen uh hi: tabang te in a lianzaw danpiak na thuak tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus khuadak a, sumkholna sungah mihaute i sumpi khiak mu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Taciang a zawng meingong nu khat i dangka san pia ni a khiak zong mu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jesus in, A tatak kong ci ciang, hi a zawng meingong nu in ngualdang theampo sang in a tamzaw khia hi: ");
INSERT INTO csy_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Banghangziam cile midang te in a dimlet a nei uh sung pan in Pathian atu a piak uh teng khia hi: ahihang hi meingong nu a hile zawng napi, a nuntak natu in a nei theampo khia hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Mi pawlkhat te in biakinn sia suangtum hoi mama te le a kipia van te taw a kizep nathu a son uh ciang in, ");
INSERT INTO csy_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Hi na mu uh nate, kuama in vawk ngawl napi, suangtum khat le khat a ki thuap nawn ngawl hun hong theng tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Amate in Jesus kungah, Syapa awng, hibang te banghun ciang piang tu ziam? hibang te hong pian tu ciang in bangbang musakna om tu ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesus in, Ngual i theam na hi ngawl natu uh in kidawm vun: banghangziam cile mi tampi te keima min taw hongpai tu uh a, keima in Christ ka hihi; a hun hong nai zo hi, ci tu uh hi: hi kamale amate zui heak vun. ");
INSERT INTO csy_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ahihang ngal ki do na le tualngal thu te na zak uh ciang in lau heak vun: banghangziam cile hibang te hong piang masa hamtang tu hi; ahizong a tawpna hong theng pai ngawl lai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tuazawkciang amate tung ah, Minam khat le namkhat, kumpi ngam khat le khat ki langpan tu hi: ");
INSERT INTO csy_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mun tatuam te ah a nasia mama zinling tu a, kial le pul te hong tung tu hi; vantung ah a kimu thei a lauhuai te le musakna tatuam te hong om tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ahizong hite theampo a pian ma in, amate in hong man tu uh a, hong vawtsia in synagogue le thonginn ah hong ap tu uh hi, keima min hang in kumpi te le ngam uk te mai ah hong then tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tasia sia note atu tettipanna hong suak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tua ahikom note i thin sungah, bangbang in zo tu, ci ngaisun khol heak vun: ");
INSERT INTO csy_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Banghangziam cile na ngalte theampo i hong nial zawk ngawl tu le hong nal zawk ngawl tu in pau thiam nale ciimna kong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Na nu le na pa, na suapui, na mealheak le na lawmte in hong zuak tu uh hi; pawlkhat te thi tu ciangdong in hong then tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Keima min hang in mi theampo in hong ensan tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ahihang na lutung samzam khat zong sumsi ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Na thuakzawkna uh sungah nuntakna na nei tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalem sia ngalkap te in a kimum na mu uh ciang in, siatsuana hong nai zo hi, ci na tel tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tua hun ciang in Judah ngam a omte mual tungah tai tahen; khuasung ah a omte khuapua ah pusuak tahen; duisung ah a omte khuasung ah tum heak tahen. ");
INSERT INTO csy_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Banghangziam cile tua hun sia phu lak ni hi tu hi, ci a ki atkhol theampo tangtun natu a hihi. ");
INSERT INTO csy_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ahihang tua hun laitak in naupai te le nausen noailuai lai nei te mailam bing tu hi! banghangziam cile Judah ngam ah haksatna lianpi theng tu a, Judah minam te tungah Pathian thin-ukna theng tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Amate namsau taw puk tu uh a, ngam theampo ah sal in ki kai tu hi: Jerusalem sia Gentile te hun a bo dong Gentile te in sik tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Ni le tha le aksite tungah musakna te hong om tu a; leitung minam theampo tungah thinngimna le dipkuatna hong theng tu hi; tuipi le tuihual te hawk tu hi; ");
INSERT INTO csy_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Leitung ah a theng tu te en in mihing te thin sia lau na hang in but thi in puk tu uh hi: banghangziam cile vantung vangletna te ki thiing tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tuazawkciang in mihing Tapa sia mei tung pan in vangletna le minthanna lianpi taw hongpai amate in mu tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hibang te hong thet kipat ciang in, dak in na lu tung vun; banghangziam cile note i ngupkhiatna ni hong nai zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus in amate tungah sontena khat son hi; Theikung le thingkung theampo en vun; ");
INSERT INTO csy_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","A te no meang hong sua ciang in khuakhal hun hong nai zo hi, ci mu in na he uh hi. ");
INSERT INTO csy_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tasia bangma in, hibang te hong thet na mu uh ciang in, Pathian kumpingam hong nai zo hi, ci he tavun. ");
INSERT INTO csy_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","A man tatak kong ci ciang, hi thu te theampo a tangtut mateng, hi minam bothong ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Van le lei bo tu hi: ahihang ka kammal te bo ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Note ki nging in om vun, a valkai neak le dawn hu in thinngimna le zu kham buaina, leitung nuntakna atu thintoi in na om uh le, tua ni sia muanmawkngawl het laitak in note tungah hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Banghangziam cile leitung mi theampo tungah thaang bang in hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tua ahikom note in ngak nginge vun, hong theng tu na theampo pan a suakta tu a kilawm tu le mihing Tapa mai ah ding tu in thungen tawntung vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesus sia sun hun sung in biakinn sungah thuhil hi; zan ciang in a puasang pusuak a, Olive mual tungah ngiak hi. ");
INSERT INTO csy_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mi theampo zingtung in a thuhilna ngai nuam in biakinn sung ama kungah hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paisanpoai a kici, tol saw ngawl anluum poai hong nai zo hi. ");
INSERT INTO csy_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Thiampi lian te le thukhamhil te in Jesus bangbang in that thei tu ci in zong uh hi; banghangziam cile amate in mipi te lau uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tuazawkciang in nungzui sawmleni sung a ki hel Iscariot a kici Judas sungah Satan tum hi. ");
INSERT INTO csy_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Taciang Judah paikhia a, thiampi lian te le biakinn cing upa te taw Jesus bangbang in amate tungah zuak thei tu, ci kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Amate lungdam mama uh a, dangka piak tu in lungkim uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Taciang Judas in hunpha zong a, mipi te om ngawl laitak in amate tungah zuak tu in kiciam hi. ");
INSERT INTO csy_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tol saw ngawl anluum poai ni in paisanpoai atu tuu no ngaw tu hun hong theng hi. ");
INSERT INTO csy_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Taciang Jesus in Peter le John te sawl a, Pai tavun a, paisanpoai an neak khop natu vawtkhol tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Amate in koisung ah vawtkhol tu in dei ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Taciang Jesus in amate tung ah, En vun, khuasung na tum uh ciang in tuibeal pua pasal khat taw ki si tu nu hi; a tum na mun innsung ah zui tavun. ");
INSERT INTO csy_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Taciang inn nei pa kungah, Syapa in nangma kungah, ka nungzui te taw paisanpoai an ka neak natu uh inndoi koi sungah om ziam? hong ci hi, na ci tavun. ");
INSERT INTO csy_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Taciang ama in inn tungah innsung van a cing in a ki koi inndoi lian mama hong lak tu a, tuaksung mun ah vawtkhol tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Amate pai uh a, Jesus in a sonkhol bang in mu uh hi: taciang paisanpoai atu vawtkhol uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","A hun hong cin ciang in, Jesus sia a Sawltak sawmleni te taw to khawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Taciang Jesus in amate tung ah, Hi paisanpoai sia haksatna ka thuak ma in, note taw neakkhop tu ka uk mama hi: ");
INSERT INTO csy_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Banghangziam cile keima in kong ci hi, Pathian kumpingam sungah hi thu a khuangkhim mateng, hi sia ne nawn ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Taciang Jesus in hai la a, lungdam a ko zawkciang, Hi sia la vun a hawmtek vun: ");
INSERT INTO csy_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Banghangziam cile keima in kong ci hi, Pathian kumpingam hong thet mateng, hi sapittui dawn kik nawn ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Taciang Jesus in anluum la a, lungdam a ko zawkciang, phel in amate pia hi, Hisia in note atu in kong piak ka pumpi a hihi: keima nong phaw na in vawt tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Tasia bangma in nitak an a neak zawk uh ciang hai zong la a, Hi hai sia note atu in a luang ka thisan sungah thuciam thak a hihi. ");
INSERT INTO csy_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","A hizong en vun, keima hong leheakpa khut sia keima taw sabuai tungah om hi. ");
INSERT INTO csy_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ciangtan sa ombang in mihing Tapa sia pai hamtang tu hi: ahizong mihing Tapa a leheak sia a mailam bing hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Taciang in hibang a ngamta tu sia kua hitu ziam ci amate sungah ki dong uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","A nungzui te sungah, a lianbel tu in kua kilawm tu ziam, ci ki nial na hong om hi. ");
INSERT INTO csy_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus in amate tung ah, Gentile kumpi te in mipi te sia to hina taw uk uh a, amate tungah thuneina a zang te sia, ngual huna pia te, kici hi. ");
INSERT INTO csy_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ahihang note tabang na hi heak vun: note sungah a lianbel sia a no zaw bang hi tahen a; a thupi bel sia in, naseam khat bang in om tahen. ");
INSERT INTO csy_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","A kua lian zaw ziam, An ne tu in a to sia pa lianzaw ziam maw ankuang a lui pa lianzaw ziam? A to sia pa lianzaw hi. Ahizong in note sungah kei sia ankuang luipa bangin kong om hi. ");
INSERT INTO csy_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Note in ze-etna ka thuak sung theampo ah nong ompui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ka pa in kumpingam nasep hongpiak bangma in keima in note kong pia hi; ");
INSERT INTO csy_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka kumpingam sungah ka sabuai pan dawn in na ne tu uh a, kumpi tokhum tungah to in Israel mi nam sawmleni te thu na khen tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Taciang Topa in, Simon, Simon, en in, Satan in nangma hong nei nuam mama a, tang kheap bang in hong kheap nuam hi: ");
INSERT INTO csy_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ahihang na upna a puk ngawl natu in, thu hong ngetsak zo khi hi: taciang kei sang nong ki hei kik ciang in, na suapui te tha na khohsak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter in ama kungah, Topa, nangma taw thonginn sungahizong, thi khawm tu ahizong ka ki nging zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus in, Peter awng, hong ci khi hi, tu ni in, he ngawl khi hi, ci thum vei dong nong nial mateng akkhuang ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus in a nungzui te tung ah, Dangka bawm, thung le peangdap keng ngawl in kong paisak lai, na kisapna uh a om ziam? ci hi. Amate in bangma ka kisam bua uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jesus in amate tung ah, Ahizong tu in, dangka bawm a nei te in keng tahen a, tasia bangma in thung zong keng tahen: namsau a nei ngawl te in, a puan tungsil zuak tahen a, khat lei tahen, ");
INSERT INTO csy_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Banghangziam cile ama sia thukham paltan te sungah ki hel hi, ci a ki atkhol sia keima tungah tangtung hamtang tu hi: banghangziam cile keima taw kisai thu te a tawpna hong theng zo hi, ci in kong son hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","A nungzui te in, Topa, en in, ziak ah namsau ni om hi, ci uh hi. Ama in, Hisia pha zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesus pusuak a, a ngeina bang in Olive mual ah pai hi; taciang a nungzui te in zong zui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tua mun a thet uh ciang in, amate tung ah, Ze-etna sungah na tum thak ngawl natu uh in thungen vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A nungzui te taw muiden khat za a ki khuala na mun ah pai a, khupdin in thungen hi. ");
INSERT INTO csy_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Pa awng, na deina a hile hi hai sia kei kung pan in hong khinsak tan: ahihang keima deina bang hi ngawl in nangma deina bang hizaw tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Taciang tua mun ah vantung pan in vantungmi khat hong kilang a, Jesus tha dimsak hi. ");
INSERT INTO csy_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Thin ngimna lianpi taw nasia seseam in thungen hi: taciang a khua ulsa sia thisan bang in lei ah tak hi. ");
INSERT INTO csy_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","A thungetna mun pan ding in a nungzui te kungah a pai ciang, amate khua ngai in a mutthip uh mu a, ");
INSERT INTO csy_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Taciang amate tung ah, Banghang in mu nu ziam? ze-etna sungah na thet ngawl natu uh in, tho vun a, thungen vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus a pau laitak in, en vun, mi honpi te mai ah Judas a kici, nungzui sawmleni sung pan khat in Jesus nam tu in hong neak hi. ");
INSERT INTO csy_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ahihang Jesus in ama kungah, Judas, mihing Tapa sia nap na taw leheak ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus kungah a omte in bang piang tu, ci a mu uh ciang in, Topa, namsau taw ka vat tu uh ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Amate sung pan khat in thiampi sang i naseam pa ziatsang bil sattansak hi. ");
INSERT INTO csy_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus in, Tu za pha zo hi, ci a, a bil thamsak in damsak hi. ");
INSERT INTO csy_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Taciang Jesus in a kung hongpai thiampi lian te, biakinn cing ulian te le, upa te tung ah, Note in nguta man tu bang in, namsau le moltum te taw hongpai nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nizim in biakinn sungah note taw ka om lai in, hong man ngawl nu hi: ahihang hi thu sia note i hun le khuamial i vangletna hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Amate in Jesus man uh a, thiampi sang pa inn ah paipui uh hi. Peter in a khuala pan in zui hi. ");
INSERT INTO csy_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Leitual laizang ah meiphual sep a, to tek uh hi, amate ki laklaw ah Peter to hi. ");
INSERT INTO csy_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ahihang naseam numei khat in Peter mei hui ah a to a mu ciang in, sal tinten a, hi sia pa zong Jesus taw om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Taciang Peter in nial a, numei awng, Ama he ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tawmvei zawkciang a dang khat in Peter a mu ciang, nangma zong amate sungah kihel ni hi, ci hi. Taciang Peter in, pasal pa awng, kei hi ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nai khat bang zawkciang in, a dang khat in, a tatak in hi sia pa zong Jesus taw om hi: banghangziam cile ama sia Galilee mi hi, ci in teltak in son hi. ");
INSERT INTO csy_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Taciang Peter in, pasal pa awng, bang son ni ziam, ci he ngawl khi hi, ci hi. Tua hun lian Peter a pau laitak in ak khuang hi. ");
INSERT INTO csy_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Taciang Topa hong ki hei a, Peter en hi. Taciang Peter in Topa i ama tungah a son sa, Ak khuan ma in thum vei hong nial tu ni hi, ci kammal phawk kik hi. ");
INSERT INTO csy_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter pusuak a, nasiatak in kap hi. ");
INSERT INTO csy_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesus a man te in ama nu-nau in vel uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Taciang a mit puan taw tuamsak a, a mai pan vel uh hi, taciang kua in hong vel ziam? kamsang bang in hong son sin tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Taciang ama selno na kam te pau uh hi. ");
INSERT INTO csy_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Khuavak pociang in, upa te, thiampi sang te le thukhamhil te ki kaikhawm uh hi, taciang Jesus sia amate thu kikup na mun ah paipui uh a, ");
INSERT INTO csy_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Nangma in Christ na hi ziam? hong son tan, ci uh hi. Taciang Jesus in amate tung ah, Kong son hang hong um ngawl tu nu hi: ");
INSERT INTO csy_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Taciang note thu kong dong zong, hong zo ngawl tu nu hi, taciang zong hong tha ngawl tu nu hi. ");
INSERT INTO csy_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tu zawkciang in mihing Tapa sia Pathian vangletna ziatsang ah to tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tuazawkciang amate theampo in, nangma sia Pathian Tapa ni ziam? ci uh hi. Jesus in amate tung ah, Na son uh bang in ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Taciang amate in, bang tetti dang kul lai ziam? banghangziam cile eima vateak in ama kam pan i za zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Taciang mihonpi te hong ding uh a, Jesus sia Pilate kungah paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Amate in Jesus mawsiat kipan uh a, hi sia pa in i ngamsung i mipui te lampialsak hi, ci mu khu hi, Ama le Ama sia Christ Kumpipa khi hi, ci a, Caesar tungah shia piak tu zong kham hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate in Judah Kumpipa na hi ziam? ci in dong hi. Jesus in, Nangma in ci ni hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tasiaciang in Pilate in thiampi lian te le mipi te tung ah, hisia pa a maw na mu ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Taciang amate in a nasia zaw in, hisia pa in Galilee pan kipan hi mun dong, Judah ngam sung theampo mipi te thuhil in hanthawn hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate in Galilee thu a zak ciang in, hisia pa sia Galilee mi a hi ziam, ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilate in Jesus sia Herod thuneina nuai ah om hi, ci a heak pociang, Herod kungah puak hi, tua hun laitak in Herod sia Jerusalem ah a om laitak a hihi. ");
INSERT INTO csy_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod in Jesus a mu ciang in angtang mama hi: banghangziam cile Ama thu tampitak za zo a, a mu nop zawk ngei mama zo hi; taciang nalamdang a vawt te mu tu in ki lamen hi. ");
INSERT INTO csy_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Tuazawkciang in Herod in Jesus sia thu tam mama dong hi; ahihang Jesus in bangma a zo kik bua hi. ");
INSERT INTO csy_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Thiampi lian te le thukhamhil te hong ding uh a, Jesus nasiatak in mawsiat uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herod le a ngalkap te in Jesus sia bangma thusimngawl in nu-nau uh a, puan pha mama khat a silsak zawk uh ciang, Pilate kungah puakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tua ni tatak ma in Pilate le Herod te lawmtam suak uh hi: banghangziam cile tua masia amate ni a kilem bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilate in thiampi lian te, ngam uk te le mihon te sam khawm in, ");
INSERT INTO csy_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Amate tung ah, hisia pa sia mipi te lampialsak hi, ci in ka kungah hong paipui nu hi: en vun, note i mai ah ka sittel zo a, na mawsiatna uh mawna khat zong mu ngawl khi hi: ");
INSERT INTO csy_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod in zong a mawna a mu ngawl hang in keikung ah hong puakkik hi: thi natu a kilawm mawna bangma om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Tua ahikom thu ka hil tu a, tha kik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Banghangziam cile paisanpoai ciang in ama in mihing khat papo suatak hamtang hi. ");
INSERT INTO csy_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Taciang amate theampo sia thakhat thu in au uh a, hisia pa that in a, Barabbas suaktasak in, ci uh hi: ");
INSERT INTO csy_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas sia khuapi sungah buaina le tual tha na hang in thongtak a hihi. ");
INSERT INTO csy_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate in Jesus a suatak nop hang in, amate tungah thu son kik hi. ");
INSERT INTO csy_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ahihang amate au uh a, Ama thinglamte tungah khai in, Ama thinglamte tungah khai in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate in a thumvei na amate tung ah, banghang ziam, bang phatngawlna vawt ziam? thina tu za dong a vawt bangma mu ngawl khi hi: tua ahikom sat in thakik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amate aw ngingtak in, thinglamte tungah khai tu in ngen uh hi. Taciang amate le thiampi lian te aw in zo hi. ");
INSERT INTO csy_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Tua ahikom amate nget bang in Pilate in thukhen hi. ");
INSERT INTO csy_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Taciang in Pilate in buaina le tualthat hang in thongtak pa sia amate deina bang in suaktasak hi, ahihang amate deina bang in Jesus ap hi. ");
INSERT INTO csy_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Amate in Jesus a paipui uh ciang in, khuano sang pan hongpai Cyrene khua mi Simon sia man uh a, thinglamte puasak in Jesus nung pan zuisak hi. ");
INSERT INTO csy_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jesus nung pan in mihonpi te in zui uh a, Jesus kaa kawm in a zui numei te zong om hi. ");
INSERT INTO csy_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ahihang Jesus in, amate sang kihei a, Jerusalem tanu te awng, keima atu in kap heak vun, ahizong note le na tate atu in kap zaw vun. ");
INSERT INTO csy_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Banghangziam cile, en vun, a ciing te, nau a nei ngei ngawl sul le nau i tawp ngei ngawl noai te, thuphatoai a hihi, a kici tu nite hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mual te tung ah, ko tungah hong cim tavun; mualdung te tungah kote hong huk tavun, ci tu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Banghangziam cile, thingkung hing te tung nangawn ah hibang vawt a hile, thing ko te tungah bang a vawt tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Taciang thi dan a thuak tak mi ngilo ni zong Jesus taw that khawm tu in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calvary a kici na mun a thet uh ciang in, Jesus taw tua thi dan a piak tak mi ngilo ni te sia a ziatsang ah khat, a veisang ah khat, thinglamte tungah khai uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesus in, Pa awng, amate maisak in; banghangziam cile, amate in bang ka vawt uh ci zong a he bua uh hi, ci hi. Taciang amate in a puan zong ai-san in hawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mipi te in dinkhawl in en uh hi. Ngam uk te in, midang te ngum hi; Pathian i teal Christ a hile, ama le ama ki ngum tahen, ci in selno uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ngalkap te zong in, a kungah hongpai in, sapittui hau pia hi. ");
INSERT INTO csy_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Taciang Judah kumpipa na hile, nangma le nangma ki ngum in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ama i tung ah, hisia in judah te kumpipa a hihi, ci in Greek, Latin le Hebrew lai taw in at uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ama taw a ki khaikhawm thi dan piaktak khat in selno a, nangma sia Christ na hile, nangma le nangma ki ngum in a, kote zong hong ngum tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ahihang a dang khat sia in, nangma sia ama taw mawsiatna a kibang ci na musa hi napi, Pathian kita ngawl ni ziam? ");
INSERT INTO csy_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eite i hile i thuak tuma hi; banghangziam cile i ngamtatna bang in thaman a sang i hihi: ahihang hisia pa sia bangma khialna nei ngawl hi, ci in tei hi. ");
INSERT INTO csy_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Taciang ama in Jesus kungah, Topa awng, na kumpingam sungah na tum ciang in hong phawk tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesus in ama kungah, A tatak in kong ci hi, tuni in keima taw paradise ah i om tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tua hun sia sun nai sawmleni pawl hi a, nitak nai thum ciang dong leitung theampo ah khuazing hi. ");
INSERT INTO csy_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Taciang in ni zong mial a, biakinn sung ki doi na puan sia a laizang pan ki zen hi. ");
INSERT INTO csy_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Taciang in Jesus aw ngingtak in au a, Pa awng, ka tha na kutsung ah kong ap hi: ci hi, tabang a ci zawkciang thi hi. ");
INSERT INTO csy_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tua thu ngalkap mangpa in a mu ciang in, Pathian pok a, hisia pa sia mi thutang khat hi takpi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tua thu piang en tu in hongpai mihing theampo in tua thu piang te a mu uh ciang in, a awm uh tum in heakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesus a he theampo le Galilee pan in a zui numei te sia a khuala na ah ding in, thu piang teng en khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Taciang, en vun, Joseph a kici ngaisutna pia khat om a, ama sia mipha le mi thutang a hihi: ");
INSERT INTO csy_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ama sia makai khat hi napi, makai dang te i ngaisutna le a sep dan a lungkim ngawl hi; ama sia Judah minam te khuapi Arimathaea khua pan hi a, Pathian kumpingam a ngak khat a hihi. ");
INSERT INTO csy_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hi pasal pa sia Pilate kungah pai in, Jesus luanghawm ngen hi. ");
INSERT INTO csy_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Taciang thinglamte tung pan in khiasuk uh a, puanneam taw a tuam zawk uh ciang in, kuama a ki sial ngei ngawl lai na mun, a ki khuak tawm suang hawng than thak sungah sial hi. ");
INSERT INTO csy_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tua ni sia ki ngin ni hi a, sabbath ni theng dektak zo hi. ");
INSERT INTO csy_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilee pan in Jesus taw hongpai numei te in Joseph zui uh a, Topa Jesus luang bangbang in sial ziam, ci in than en tek uh hi. ");
INSERT INTO csy_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Amate heakkik uh a, paknamtui te le sathau namtui a tatuam te ki nging khol uh hi; taciang thupiak bang in sabbath ni in tawlnga uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nipi kal khat sung ni masabel ni zingsang tung in numei te a vawtkhol sa ngimnamtui te keng in, a dang numei te taw than ah pai khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Amate in than pan in suangtum a ki lik sa in mu uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Amate than sungah tum uh a, Topa Jesus luang a mu bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tasia ciang amate a lungmang tek mama uh a, en vun, mihing ni puan pak sitset sil in amate hui ah ding hi: ");
INSERT INTO csy_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Amate in lau kawm in, lei ah boksuk uh a, tua mihing te in amate tung ah, banghang in mihing sia mithi te sungah zong nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ama ziak ah om ngawl hi, tho zo hi: Galilee ah a om lai in note tungah bangbang in hong son ziam, ci phawk tavun, ");
INSERT INTO csy_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Mihing Tapa sia mi ngilo te khut sungah ap tu uh a, thinglamte tungah khai tu uh hi, taciang nithum ni ciang in thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Taciang amate in Jesus kammal te phawkkik uh hi, ");
INSERT INTO csy_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Taciang than pan heakkik uh a, Sawltak sawm le khat te le midang te kungah hi thu te theampo son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hi thu te Sawltakte kungah a son te sia, Mary Magdalene, Joana le James nu Mary te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sawltakte in numei te kammal te sia phuatawm tangthu banglel in ngaisun uh a, a um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tuazawkciang in Peter ding a, than sangah tai hi; taciang kun in puanneam no a ki koi bek mu hi, taciang thu piang te lamdangsa mama in heakkik hi. ");
INSERT INTO csy_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Taciang, en vun, tua ni in amate sungpan mi ni te sia, Jerusalem pan tai sali kiim a khuala na mun Emmaus a kici khua ah pai khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Amate in hi thu piang te theampo kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tabang a kikup le a ngaisut khop uh laitak in Jesus Ama mama hong nai a, amate taw tonkhawm hi. ");
INSERT INTO csy_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ahihang amate in Jesus a hi hunlam a tel ngawl tu in a mit uh ki humsak hi. ");
INSERT INTO csy_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesus in amate tung ah, Na paikawm in bang thu kikum nu ziam, banghang in maikhing nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Amate sung pan khat ahi, Cleopas a kici pa in, tulai thu piang te he ngawl in Jerusalem ah khual a haw nangmabek ni ziam? ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Taciang Jesus in amate tung ah, Bang thu te ziam? ci hi. Amate in, Pathian le mi theampo mai ah sep na le kammal taw a vanglian mama kamsang khat, Nazareth mi Jesus thu a hihi: ");
INSERT INTO csy_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Thiampi lian te le ka ngam uk te in, thidan thuak tu in mawsiat uh a, thinglamte tungah khai hi. ");
INSERT INTO csy_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ahihang Ama sia Israel te ngumpa tu in, ka lam-et mama uh a hihi: bek domngawl in, tu ni hi thu te a pian zawk ni thum na hi zo hi. ");
INSERT INTO csy_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kote sungah numei te in hong lungmangsak belap lai hi, amate zingtung in than ah pai tek uh a; ");
INSERT INTO csy_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","A luang a mu ngawl uh ciang in, heakkik uh a, amate in vantungmi te hong kilang mu uh hi, tua vantungmi in, Ama nungta hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Taciang kote sung pan mi pawlkhat te than ah pai uh a, numei te sonbang in mu uh hi: ahihang Ama a mu bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Taciang in Jesus in amate tung ah, Aw mi mamaw te, kamsang te sonkholsa um tu in na lungtang uh hai lei hi: ");
INSERT INTO csy_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Christ in hi thu te theampo a thuak zawkciang in Ama minthanna sungah tum tu hi ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moses laibu pan kipan kamsang laibu theampo le, laithiangtho theampo sungah Ama thu a ki at te amate tungah hilthiang hi. ");
INSERT INTO csy_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","A pai natu khua a thet dektak uh ciang: Jesus sia paisuak lai tu bang in om hi. ");
INSERT INTO csy_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ahihang amate in, koma kungah hong tam tan: banghangziam cile nitak sang hi zo a, khua niam mama zo hi, ci in tho hamtang uh hi. Taciang amate taw tam tu in pai hi. ");
INSERT INTO csy_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tuazawkciang in, amate taw an ne tu in to khawm tek uh hi, taciang anluum la a thupha pia hi, taciang phel a, amate pia hi. ");
INSERT INTO csy_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Amate mitte te honsak a, amate in Jesus he uh hi; taciang amate mitmu pan in na bo zo hi. ");
INSERT INTO csy_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Amate khat le khat kungah, lamkal ah hong paupui a, laithiangtho hong hilthiang laitak in, i thinsung ah mei bang in hong kang hi ngawl kana ziam? kici khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Amate tua laitak ma in ding uh a, Jerusalem ah heakkik uh hi, taciang Sawltak sawm le khat te le a dang te munkhat ah a ki kaikhawm tek mu uh a, ");
INSERT INTO csy_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Topa sia tho takpi hi, taciang Simon kungah kilang zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Amate in lamkal lak ah thu piang te le anluum a bal ciang in Topa hi, ci a heak thu te son uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Amate a kikup uh laitak in, Jesus sia amate laizang ah hong ding a, Note tungah thinnopna om tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ahihang amate in thitha mu ki sa uh a, lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jesus in amate tung ah, Banghang in patau nu ziam? banghang in na thinsung uh ah a tatuam ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","En vun, ka khut le ka peang te, keima tatak ma khi hi: hong tham tavun a hong en tavun; ngu le tang te ka nei na mu uh bang in, thitha in ngu le tang nei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jesus in a son zawkciang in, amate a khut le a peang te lak hi. ");
INSERT INTO csy_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Amate lungdam le lamdang asak uh hu in a up ngawl uh ciang, Jesus in amate tung ah, Ziak sungah neak thei khatpo na nei uh ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Amate in ngasa em bakkhat le khuai phang khat pia uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesus in la a, amate mai ah ne hi. ");
INSERT INTO csy_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Taciang Jesus in amate tung ah, Hi kammal te sia note taw ka om lai in kong son te a hihi, Moses thukham, kamsang laibu te le Psalms labu sungah keima thu a ki atkhol theampo te a tangtut hamtang na a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Taciang laithiangtho a tel thei natu in amate heaktheina honsak a, ");
INSERT INTO csy_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Amate tung ah, Hibang in ki atkhol hi, Christ sia a thuak kul hamtang a, thina pan nithum ni ciang in thokik tu hi: ");
INSERT INTO csy_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jerusalem pan kipan in minam theampo tung ah, Ama min taw mawna ki sikkik na le mawmaisak na thu pualak tu hi. ");
INSERT INTO csy_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Taciang note sia hi thu te i tetti te na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Taciang, en vun, ka Pa kamciam sia note tungah hong puak khi hi: ahihang tungsang pan vangletna taw hong tuam mateng, Jerusalem ah om nginge vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Taciang Jesus in amate Bethany dong paipui a, a khut lamto in, amate thupha pia hi. ");
INSERT INTO csy_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Thupha a piak laitak in, amate kung pan kikhen a, vantung ah ki lato hi. ");
INSERT INTO csy_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Amate in Jesus a biak zawk uh ciang in, Jerusalem ah lungdamna lianpi taw heakkik tek uh hi: ");
INSERT INTO csy_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Amate tatsat ngawl in biakinn sungah om uh a, Pathian pok in thupha pia tek uh hi. Amen. ");
INSERT INTO csy_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","A kipatcil in Thu om hi, tua thu sia Pathian taw omkhawm a, tua Thu in Pathian a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tua thu sia a kipatcil in Pathian taw omkhawm hi. ");
INSERT INTO csy_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Na theampo Ama vawt a hihi; a kivawt theampo sungah Ama kihel ngawl in a kivawt khatzong a om bua hi. ");
INSERT INTO csy_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ama sungah nuntakna om a; tua nuntakna sia mihing te i khuavak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Taciang khuavak sia khuazing sungah tang a; khuazing in Ama a he bua hi. ");
INSERT INTO csy_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pathian kungpan hong ki sawl mi khat om a, ama min sia John a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","John sia tetti tu in hongpai a, mi theampo in ama tungtawn in a up thei natu, khuavak tettipang tu in hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ama sia tua Khuavak hi ngawl hi, ahihang tua Khuavak tettipang tu in a ki sawl a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tasia sia Khuavak tatak hi a, mi theampo taan tu in hi leitung ah hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ama sia leitung ah om a, leitung sia Ama vawtsa a hihi, taciang leitung in Ama a he bua hi. ");
INSERT INTO csy_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ama minam te kungah hongpai napi, a minam te in Ama a sang bua hi. ");
INSERT INTO csy_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ahihang a sang te theampo tung ah, Pathian tapa sua na vangletna pia hi, tua te sia Ama min a umte a hihi: ");
INSERT INTO csy_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ama te sia thisan, ci le sa deina, le mihing deina tungtawn in a piang a hi bua uh hi, ahihang Pathian deina tungtawn in a piang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Tua thu sia ci le sa in ki vawt a, taciang thuthiamna le thutak taw kidim in eite sungah hong om a, Pa i Tapa a neisun minthanna bang in a minthanna i mu hi. ");
INSERT INTO csy_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John in Ama thu tettipang in a au na aw sia, ka nung pan hongpai pa sia kei sang in thupi zaw hi: banghangziam cile Ama sia kei pian ma in om zo hi: A thu ka sason sia Ama a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ama kicinna pan in i vekpi in hesuakna khat zawkciang khat i sang tato hi. ");
INSERT INTO csy_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Banghangziam cile thukham sia Moses tungtawn in hong kipia hi, ahihang thuthiamna le thutak ahile Jesus Christ tungtawn in hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kuama in bangmahun in Pathian mu ngei ngawl hi; Pa kangsung ah a om khatbek a nei a Tapa in, Pa thu hong tangko zo hi. ");
INSERT INTO csy_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hi thu sia, nang sia a kua ni ziam? ci dong tu in Judah te in thiampi te le Levite te Jerusalem pan a sawl uh ciang in, John i a cepte thu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","John in nial peuma ngawl in, keima sia Christ hi ngawl khi hi; ci in pualak hi. ");
INSERT INTO csy_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Amate in, tua a hile a kua ni ziam? Elijah ni ziam? ci in dong uh hi. Taciang John in, hi ngawl khi hi, ci hi. Amate in, kamsang tasia ni ziam? ci in a dok leleau uh ciang in, hi ngawl khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Amate in, nang a kua ni ziam? tua hile hong sawl te kungah son thei tu khu hi. Nangma le nangma kua ka hi ci ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John in, kamsang Isaiah sonkholsa bang in, Topa i lampi tangsak vun, ci in ngamsung pan a au Aw ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Amate sia Pharisee te in sawl in a paisak te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Amate in, Christ na hi bua a, Elijah le hi ngawl, kamsang le hi tuan ngawl napi, banghang in tuiphumna pia ni ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John in, keima in tui taw tuiphumna kong pia hi: ahihang na heak ngawl uh mi khat note sungah ding nginge hi; ");
INSERT INTO csy_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ama sia, ka nung pan hongpai a, kei sang in thupi zaw hi, kei sia a peangdap khau sutsak tu zong ka kilawm bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hi thu te sia John in tuiphumna a piak na mun, Jordan ngun ngal Bethabara ah a sep thu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","A zingciang in John in Jesus a kungah hongpai mu a, en vun, leitung mawna a pua Pathian Tuuno. ");
INSERT INTO csy_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Hi sia pa sia, ka nung pan hongpai a, kei sang in thupi zaw hi: banghangziam cile kei pian ma in om zo hi, ci ka son sia Ama a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ama ka he bua hi: ahihang Ama sia Israel te tungah kilangsak tu hi, tua ahikom keima hongpai in tui taw tuiphumna pia khi hi. ");
INSERT INTO csy_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Taciang John in ceptena tettipang a, Thaa sia vantung pan vakhu bang in tuaksuk a, Ama tungah a tu ka mu hi. ");
INSERT INTO csy_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ama ka he bua hi: ahihang tui taw tuiphumna pia tu in, hong sawl sia in, Ama tungah Thaa hong tuaksuk tu a, tua na mu uh sia sia, Tha Thiangtho taw tuiphumna pia tu pa hi, ci in hong son hi. ");
INSERT INTO csy_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ama ka mu zo a, hisia pa sia Pathian Tapa a hihi, ci in ceptena tettipang khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","A zingciang in John le a nungzui ni te hong dingkik uh a; ");
INSERT INTO csy_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesus hongpai a mu ciang in, en vun Pathian Tuuno! ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taciang nungzui nite in tua thu a zak uh ciang, Jesus nung zui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tuazawkciang in Jesus in a nungsang le-et a, amate i zui a mu ciang, amate tung ah, Bang zong nu ziam? ci hi. Amate in, Rabbi awng koisung ah om ni ziam? ci uh hi. Rabbi a khiakna sia syapa awng, a cinopna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesus in amate tung ah, Hongpai tavun a hong en tavun, ci hi. Amate hongpai uh a, a omna mun mu uh hi, taciang tua ni Ama taw omkhawm uh hi: banghangziam cile a hun sia nitak sang nai li pawl a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","John i son thu a za mihing ni te sungah khat sia Simon Peter suapui pa, Andrew a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A masaphit in a u Simon taw ki si uh a, ko Messiah taw ki mu zo khu hi, ci son hi. Messiah a khiakna sia Christ a ci nopna hi. ");
INSERT INTO csy_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ama in Jesus kungah paipui hi. Jesus in ama a et ciang in, Nangma sia Jonah i tapa Simon na hihi: nang sia Cephas hong kici tu hi, ci hi, Cephas a khiakna sia suangpi a cinopna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","A zingciang in Jesus sia Galilee ah pai nuam hi, taciang Philip taw ki si a, ama kungah, Hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip sia Bethsaida khua mi hi a, Andrew le Peter te i khua a hihi. ");
INSERT INTO csy_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip in Nathanael mu a, ama kungah, Moses i thukham sung le kamsang te in a atkholsa, Joseph tapa Nazareth mi Jesus mu zo khu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Taciang Nathanael in, Nazareth khua pan na pha piang thei na ziam? ci hi. Philip in, hongpai tan a, en in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesus in Nathanael hongpai a mu ciang in, En vun, Israel mi tatak a hihi, a sungah theamna om ngawl hi! ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael in, bangbang in hong he thei ni ziam? ci hi. Jesus in, Philip in nang hong sap ma theikung nuai ah na to laitak in, kong mu zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael in, Rabbi, nangma sia Pathian Tapa na hihi; nangma sia Israel Kumpi na hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus in, Theikung nuai ah na to laitak kong mu hi, ka ci hang in hong um ni ziam? Hi te sang in a lianzaw nate na mu lai tu hi, ci in zo kik hi. ");
INSERT INTO csy_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus in ama kungah, Amantak in kong ci hi, a ngei ngawl in van a ki hong na mu tu a, mihing Tapa tungah Pathian i vantungmi te a tuaksuk le a kato na mu tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ni thum ni ciang in Galilee huam Kana khua ah mopoai om a; tua mun ah Jesus i nu zong om hi: ");
INSERT INTO csy_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Taciang Jesus le a nungzui te zong mopoai ah ki sam hi. ");
INSERT INTO csy_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Amate sapittui a ki sap uh ciang in, a nu in Jesus kungah, amate in sapittui nei nawn ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus in, Numei awng, nang taw bang kisai hi ziam? ka hun cing ngawl lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","A nu in naseam te kungah, hong son theampo seam vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tua mun ah Judah te ngeina bang in, thiansuana tu in suang tuibeal luk koi uh hi, beal khat sungah tui gallon kul pan sawmthum kiim ta hi. ");
INSERT INTO csy_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus in amate tung ah, Tuibeal te tui dim vun, ci hi. Taciang amate in a dim in tui dim uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jesus in amate tung ah, Tu in tui suak vun a, poai ukpa kungah paipui vun, ci hi. Taciang amate in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Poai uk pa in tua sapittui a ki suaksak tui a tep zawkciang in, koisung pan ci a he bua hi: ahihang naseam tuitoai te in he uh hi; poai uk pa in mopa sam a, ");
INSERT INTO csy_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ama kungah, midang te in sapittui a pha te koi masa hi; amate in a khomkhat tek a dawn zawk uh ciang in, a phangawl zawhiat te koi hi: ahihang nang na hile sapittui a pha te tu dong ciang in na khealsia lai hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesus in hi amasabel nalamdang sia Galilee huam Cana khua ah vawt a, a minthanna kilangsak hi; taciang nungzui te in Ama um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hite zawkciang in, Jesus le a nu, a suapui te le a nungzui te Capernaum ah pai uh a: tua mun ah ni tampi sung taam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judah te paisanpoai hong naizo a himan in, Jesus sia Jerusalem ah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Biakinn sungah khuital, tuu le vakhu zuak te le sumtheak te a to hon uh laitak mu hi: ");
INSERT INTO csy_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ciangduai tang in khauhual vawt a, tuu le khuital te biakinn sung pan in bengkeak hi; taciang sumtheak te i sum te sung keak a, sabuai te zong lotthalsak hi; ");
INSERT INTO csy_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Taciang vakhu zuak te tung ah, Hi van te hi mun pan in lasiat vun; ka Pa inn sia sumzuakna mun suaksak heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","A nungzui te in, na inn i lawpna in hong ne siat hi, ci a ki atkhol sia phawk uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judah mite in zo kik a, hibang te vawt na hikom in bang musakna hong lak tu ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus in zo kik a, Hi biakinn pheltham vun, nithum sung sakik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Judah mite in, hi biakinn sia kum sawmli le kum luk sung a kisa a hihi, nithum sung tung kik zo tu ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ahihang Jesus in Ama pumpi biakinn a son na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tua ahikom Jesus sia thina pan a thawkik ciang in, a nungzui te in hi thu te son a hi hunlam phawkkik uh hi; taciang amate in laithiangtho le Jesus i son thu te um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tu in Jesus sia Jerusalem ah paisanpoai ni in, nalamdang tampi a vawt te a mu uh hu in, mi tampi in Ama min um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ahihang Jesus in amate tungah Ama le Ama ki ap ngawl hi, banghangziam cile mi theampo a heak hang a hihi, ");
INSERT INTO csy_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kuama in mihing te thu tettipan kul ngawl hi: banghangziam cile mihing sungah bang om ziam, ci Ama in he hi. ");
INSERT INTO csy_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Judah mite i lampui, a min Nicodemus a kici Pharisee khat om hi: ");
INSERT INTO csy_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ama sia Jesus kungah zan ciang in hongpai a, Rabbi, nang sia Pathian kung pan in hongpai syapa ni hi, ci hong he khi hi: banghangziam cile na vawt nalamdang te Pathian in ompui ngawl hile, kuama in vawt thei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus in ama kungah, Aman tatak in kong ci hi, mihing khat sia a suakkik bua ahile Pathian kumpingam a mu bua tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus in, mihing khat a huai zawkciang bangbang in suakkik thei tu ziam? A nu ngil sungah a ni vei na tum in suakkik tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus in, Aman tak in kong son hi, mihing khat sia tui le Thaa taw a suak bua a hile, Pathian kumpingam sungah tum thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ci le sa taw a suak sia ci le sa hi; taciang Thaa taw a suak sia thaa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na sua kik kul tu hi kong ci hu in, lamdang na sa heak in. ");
INSERT INTO csy_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Vui sia a uknapo pan in hongpai hi, taciang a nging za ni hi, ahihang kongpan hongpai a, koisang ah pai ziam, ci son thei ngawl ni hi: tasia bangma in Thaa taw a suak te zong tabangma a hihi, ci ni. ");
INSERT INTO csy_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus in, bangbang in hi thu te piang thei tu ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus in zo a, Nangma sia Israel te sya khat hi napi, hi thu te he ngawl ni ziam? ");
INSERT INTO csy_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Aman tatak kong ci hi, kote ka hi uh le ka heak thu uh son khu hi, taciang ka mu uh thu te tettipang khu hi; taciang note in ka tetti pan uh hong sang ngawl nu hi. ");
INSERT INTO csy_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Leitung thu te kong son a, um ngawl na hile, bangbang in vantung thu te kong son ciang in um thei tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Van om a, van pan hong tuaksuk, mihing Tapa simngawl kuama van ah kato ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses in senneal ngam ah ngul a khai bang in, mihing Tapa zong ki khai tu hi: ");
INSERT INTO csy_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","A kuamapo Ama a um peuma, ki siacip ngawl tu a, tawntung nuntakna nei hi. ");
INSERT INTO csy_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Banghangziam cile Pathian in leitung mite it mama ahikom a Tapa neisun pia hi, akuamapo Ama a um peuma kisia ngawl tu a, nuntak tawntungna nei hi. ");
INSERT INTO csy_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Banghangziam cile Pathian in leitung mite mawsiat tu in a Tapa leitung ah hong paisak ngawl hi; ahihang Ama hang in leitung mite ngupna a nga natu in hongpaisak hi. ");
INSERT INTO csy_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ama a um peuma mawsiat nataw kipeal hi: ahihang a um ngawl peuma sia mawsiatna thuak zo hi, banghangziam cile Pathian i a neisun a Tapa i min a up ngawl uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Taciang hi thu sia mawsiatna hi, khuavak sia leitung ah hongpai a, mihing te in khuavak sang in khuazing dei zaw uh hi, banghangziam cile amate sep nate a phat ngawl hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Banghangziam cile na phangawl a vawt peuma in khuavak ensan uh hi, tabang hi bale a vawtna te tungah kitekna thuak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ahihang thuman a seam peuma in, a sep uh po Pathian deina taw seam hi, ci kilangsak tu in khuavak sungah hongpai uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Hiteng zawkciang in Jesus le a nungzui te Judah ngamsung ah pai uh hi; tua mun ah amate taw omkhawm uh a, tuiphumna pia hi. ");
INSERT INTO csy_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","John zong Salim pan a nai na mun Aenon ah tuiphumna pia hi, banghangziam cile tua mun ah tui tam mama om hi: taciang amate hongpai uh a tui kiphum uh hi. ");
INSERT INTO csy_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Banghangziam cile John sia thong a tak laitak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tuazawkciang in John i nungzui te le Judah mite kilaklaw ah ki thiansua na taw kisai thu dok na hong piang hi. ");
INSERT INTO csy_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Amate John kungah hongpai uh a, Rabbi, Jordan ngunngal ah nangma taw om a, Ama thu tetti na pansak pa, en in, tua pa in tuiphumna pia a, mi theampo a kungah pai uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John in, vantung pan a ki pia simngawl mihing in bangma peuma sang thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Keima sia Christ hi ngawl khi hi, ahihang Ama mai ah a ki sawlpa ka hihi, ka ci thu taw kisai note ka tetti na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mo nei sia mopa a hihi: ahihang mopa a dinpui pa le, a aw a za a lawmpa sia, mopa i aw hang in nasiatak in lungdam hi: tua ahikom ka lungdamna pawlcing hi. ");
INSERT INTO csy_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ama puicing va-ial tu hi, ahihang kei ka hile ka kiam va-ial tu hi. ");
INSERT INTO csy_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tungsang pan hongpai pa sia na theampo i tungah om hi: leitung pan hongpai pa sia leitung mi hi a, leitung thu son hi: vantung pan hongpai pa sia na theampo i tungah a hihi. ");
INSERT INTO csy_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ama in a mu le a zak sa thu te son a, ama tettipanna kuama in sang ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ama tettipanna a sang peuma in Pathian sia thuman hi, ci ama ceptena khen hi. ");
INSERT INTO csy_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Banghangziam cile Pathian i sawl pa in Pathian thu te son hi: banghangziam cile Pathian in ama tungah Thaa khaikhin in hong pia ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Pa in Tapa it a, na theampo a khutsung ah pia zo hi. ");
INSERT INTO csy_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tapa a um peuma tawntung nuntakna nei hi: Tapa a um ngawl peuma in nuntakna mu ngawl tu hi; ahihang Pathian thin-ukna a tungah om tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Tua ahikom Jesus in John sang in nungzui tam koi zaw a, tuiphumna pia hi, ci thu Pharisee te in zazo uh hi, ci Topa in a heak ciang in, ");
INSERT INTO csy_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesus Ama vateak in tuiphumna pia ngawl hi, ahihang a nungzui te bek in pia hi, ");
INSERT INTO csy_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Judah ngam nusia in Galilee ngam sungah paikik uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Taciang Jesus sia Samaria ngamsung a kantan ngawl phamaw hi. ");
INSERT INTO csy_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Sychar a kici, Samaria ngam khuapi khat, Jacob in a tapa Joseph a piak lo ngam nai na ah Jesus theng hi. ");
INSERT INTO csy_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tua mun ah Jacob tuikhuk om hi. Jesus sia a khualhaw na toi ahikom in, tuikhuk hui ah to hi: tua hun sia sun nai sawm le nai ni pawl a hihi. ");
INSERT INTO csy_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samaria numei khat tuitoai tu in hongpai a: Jesus in a kungah, Ka dawn tu hong pia tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Banghangziam cile a nungzui te khuapi sungah an lei tu in pai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Taciang in Samaria numei nu in, nang sia Judah mi na hi a, kei sia Samaria numei ka hihi, bangbang in tui dawn tu hong ngen ni ziam? ci hi. Banghangziam cile Judah te in Samaria te taw ki pawlkhawm ngei ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus in a kungah hibang in ci hi, Pathian i letsong le nangma hong paupui sia kua ci he le te, Ama kungah, tui dawn tu hongpia tan, ci in ngen zawsap tu ni hi; taciang Ama in nuntakna tui hongpia tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Numei nu in, Topa awng, tuitoai natu le bangma na nei bua a, tuikhuk zong thuk mama si hi: koisungpan tua nuntakna tui nei tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nangma in ka pa uh Jacob sang in lianzaw ni ziam? ama in tuikhuk hong pia a, ama tatak ma, a tate le nganno te zong in dawn hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus in a kungah, A kuamapo hi tui a dawn peuma dangtak kik tu hi: ");
INSERT INTO csy_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ahihang keima i ka piak tu tui a dawn peuma a dangtak kik nawn ngawl tu hi; ahihang ka piak tu tui sia ama sungah tawntung nuntakna a piangsak ciktui hi tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Numei nu in, Topa awng, dangtak ngawl tu le hi mun ah tuitoai pai kul ngawl tu in, hi tui hong pia tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus in, Pai in, na pasal sam tan a hi mun ah hongpai tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Numei nu in, pasal ka nei bua hi, ci in zo hi. Jesus in, Pasal nei ngawl khi hina ci sia pha hi: ");
INSERT INTO csy_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Banghangziam cile pasal nga na nei zo hi; taciang tu in na nei sia zong na pasal hi ngawl hi: tua thu ah a mantak in na son hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Numei nu in, Topa awng, nangma sia kamsang ni hi, ci hong he khi hi. ");
INSERT INTO csy_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ka pa te uh in hi mual tungah biakpia uh hi; taciang note in Jerusalem ah na biak tu uh a hihi, na ci uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus in ama tung ah, Numei awng, hong um tan, Pa sia hi mualtung ah ahizong, Jerusalem ah ahizong, na biak ngawl uh hun hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Na biak uh sia bang ziam, ci na he bua uh hi: kote in bang bia khu ziam, ci ka he uh hi: banghangziam cile ngupna sia Judah mite kung pan in hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ahihang a mantak in a bia te in, Pa sia thaa le thutak taw a biak tu uh hun hong theng tu hi, tu in tua hun hong theng zo hi: banghangziam cile Pa in tabang in Ama a bia te zong hi. ");
INSERT INTO csy_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pathian sia Thaa a hihi: taciang a bia peuma in thaa le thutak taw a biak tu uh a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Numei nu in a kungah, Christ a kici Messiah sia hongpai tu a: hongpai ciang in, Ama in na theampo hong son tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus in, Na kungah nang hong paupui sia, tua pa ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Taciang in a nungzui te hongpai uh a, numei nu taw a ki paupui uh lamdangsa mama uh ahihang: kuama in bang zong ni ziam? a hibale, banghang in numei nu taw ki paupui ni ziam? a ci bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tua numei nu in a tuibeal nusia in, khuasung ah pai a, mite tung ah, ");
INSERT INTO csy_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Ka sep theampo hong son pa sia pai vun a, en vun: hi sia in Christ hi ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Tabang in khuasung pan pusuak uh a, Jesus kungah hongpai hon uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tua laitak in a nungzui te in, Syapa awng, an ne in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ahihang ama in, Note i heak ngawl an neak tu ka nei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Tua ahikom khatpo in neak tu puak a hi tam? ci in a nungzui te khat le khat ki dong uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus in amate kungah, Keima hong sawlpa deina bang sep tu le Ama nasep ka zaw tu sia keima an a hihi. ");
INSERT INTO csy_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tu zo tha li ciang in anlak hun hong theng tu hi, ci hi ngawl nu ziam? dak vun a, lo te en vun; amate ang zo a, anlak hun zo hi, kong ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Taciang anla peuma in sep thaman nga tu a, tawntung nuntakna atu in thing nga te kaikhawm tu hi: taciang thaici a poai te le anla te lungdam khawm tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Khat in thaici poai a, a dang khat in anla hi, a ci sia a thuman a hihi. ");
INSERT INTO csy_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na sep ngawl na uh lo sungah anla tu in kong sawl hi: midang te in seam uh a, taciang midang te sepnasa sungah note na tum uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Numei nu in, ka sep theampo Ama in hong son hi, ci in son ahikom, Samaria khua sung mi tampi te in Jesus um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","A kungah Samaria mite hongpai ciang in, amate taw om tu in kun uh a: tua mun ah ni ni sung taam hi. ");
INSERT INTO csy_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesus Ama kammal vateak hang in a um mihing hong tam seseam hi; ");
INSERT INTO csy_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Taciang numei nu kungah, tu in nangma son bek taw hi ngawl in, koma vateak in ka zak uh hu in um khu hi, taciang Ama sia leitung ngum tu Christ a hihi, ci ka he uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ni ni zawkciang in, Jesus tua mun pan in pusuak a, Galilee ah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Banghangziam cile Jesus ama vateak in, kamsang sia ama ngam ah ki zakta ngawl hi, ci in tettipang hi. ");
INSERT INTO csy_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilee ah hongpai ciang in, Galilee mite in Ama sang uh hi, banghangziam cile Jerusalem poai ah amate pai uh a: a sep theampo mu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tua ahikom Jesus in tui pan sapittui a suasak na mun, Galilee huam Cana khua ah paikik hi. Tua khua ah ulian khat om a, a tapa Capernaum khua ah a cina hi. ");
INSERT INTO csy_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesus sia Judah ngam pan in pusuak a, Galilee ah om hi, ci a zak ciang in, a kungah pai hi, Capernaum khua ah pai in, a tapa damsak tu in ngen hi: banghangziam cile a tapa thi dektak hi. ");
INSERT INTO csy_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus in ama kungah, Musakna te le nalamdang te na mu bua uh le, na um bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tua ulian pa in, Topa awng, ka tapa a thi ma hongpai tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus in ama kungah, Va pai tan, na tapa nungta hi, ci hi. Tua pa in Jesus kammal um in pai hi. ");
INSERT INTO csy_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","A pai laitak in, a naseam te in dawntua a, na tapa nungta hi, ci son hi. ");
INSERT INTO csy_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ama in a tapa bang hun laitak in damzaw ziam, ci dong hi. A naseam te in sun nai khat pawl in a cisa dam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Tua hun sia Jesus in, Na tapa nungta hi, a ci lian laitak hi, ci a pa in he hi: taciang ama vateak le a innkuan bup in um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hi thu sia Judah ngam pan in Galilee huam ah Jesus a paizawk nalamdang a vawt ni vei na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tuazawkciang in Judah mite i poai om a; Jesus sia Jerusalem ah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem tuu kongpi hui, Hebrew kam in Bethesda a kici tuili khat om a, buk nga zong om hi. ");
INSERT INTO csy_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Hi buk nga sungah natna namcin a thuak cina tampi, mittaw, peangbai le langngaw te tui kilok tu ngak in lum uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Banghangziam cile hun khakhat ciang in tuili sungah vantungmi hong tuaksuk a, tuili sau hi: tua tui a sau zawkciang in tuisung ah a tuaksuk masabel sia bang natna po ahizong dam hi. ");
INSERT INTO csy_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tua mun ah, kum sawmthum le kum liat sung a dam ngawl khat om hi. ");
INSERT INTO csy_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus in tua pa a lum a mu ciang in, kum tam mama sung om zo hi ci he a, Na dam nuam ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tua cina pa in, Topa awng, tui a ki lok ciang in tuili sungah hong koi tu mihing nei ngawl khi hi: taciang, ka pai laitak in ka mai ah ngualdang tuaksuk masa hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus in, Tho in, na luppha la in a, lampai in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Thakhat thu in tua pa dam a, a luppha la in lampai hi: tua ni sia sabbath ni a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tua ahikom Judah mite in damna a nga pa kungah, tu ni sia sabbath ni hi: na luppha na puak sia ngeina om ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ama in, keima hong damsak pa in, na luppha la in a, lampai in, hong ci hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Taciang amate in, na luppha la in a, lampai in, hong ci sia bang mihing ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Damna a nga pa in, a kua ci zong he ngawl hi: banghangziam cile tua mun ah mihonpi te om a, Jesus sia ama le ama na ki heam zo hi. ");
INSERT INTO csy_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tuazawkciang Jesus in tua pa biakinn sungah mu a, En in, na dam zo hi: mawna vawt nawn heak in, tabang a hibale na tungah a nasia zaw hong theng tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tua pa pai in, keima hong damsak pa sia Jesus hi, ci Judah mite son hi. ");
INSERT INTO csy_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tua ahikom Judah te in Jesus vawtsia in, thatlum tu in zong uh hi, banghangziam cile sabbath ni in hibang te a sep hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ahihang Jesus in, Ka Pa sia tu dong in na seam a, keima zong seam khi hi, ci in amate zo hi. ");
INSERT INTO csy_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tua ahikom Judah te in Ama that tu in nasia seseam in zong uh hi, banghangziam cile sabbath ni paltan bek domngawl in, Pathian zong Ama Pa ci a, Ama le Ama sia Pathian taw kikimsak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tuazawkciang in Jesus in, A mantak in kong ci hi, Tapa in ama thu in bangma seam thei ngawl hi, ahihang Pa i sep bang in seam hi: banghangziam cile Pa i a sep theampo sia Tapa in zong seam hi. ");
INSERT INTO csy_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Banghangziam cile Pa in Tapa it a, a sep theampo te lak siat hi: taciang hi te sang in a lianzaw nasep te zong lak tu a, lamdang na sa tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Banghangziam cile Pa in mithi te thokiksak a, nungtasak hi; tasia bangma in Tapa in zong a nuntaksak nop te nungtasak hi. ");
INSERT INTO csy_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Banghangziam cile Pa in kuama thukhen ngawl hi, ahihang thukhenna theampo Tapa tungah ap siat hi: ");
INSERT INTO csy_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Tua ahikom Pa a zakta peuma in Tapa zong a zatak tu uh a hihi. Tapa a zakta ngawl peuma in Ama a sawl Pa a zakta bua hi. ");
INSERT INTO csy_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","A tatak in kong ci hi, ka kammal za a, kei hong sawl pa a um peuma in, tawntung nuntakna nei hi, taciang mawsiatna sungah theng ngawl tu hi; ahihang thina pan in nuntakna ah kantan zo hi. ");
INSERT INTO csy_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","A tatak in kong ci hi, mithi te in Pathian Tapa kammal a zak uh hun hong theng tu a, tu mama zong hi zo hi: taciang a za peuma a nungta tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Banghangziam cile Pa in ama sung mama ah nuntakna nei hi; tua ahikom Tapa in zong ama sung mama ah nuntakna nei tu in, pia zo hi; ");
INSERT INTO csy_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tapa i tungah thukhen theina thuneina pia hi, banghangziam cile ama sia mihing Tapa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hi thu te lamdangsa heak vun: banghangziam cile than sung a omte theampo in Ama aw a zak tu uh hun hong theng tu a, ");
INSERT INTO csy_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Amate Thankuul sung panin hong pusuak tu hi; na pha a seam ngei te tho in nungta tu a, siatna vawt te tho in mawna thukhenna thuak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Keima aituam bangma seam thei ngawl khi hi: ka zakna bang in thukhen khi hi: taciang ka thukhenna sia thutang hi; banghangziam cile keima deina ka zong bua hi, ahihang keima hong sawl Pa deina ka zong hi. ");
INSERT INTO csy_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Keima le Keima tetti ka kipang le, ka tettipanna man ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Keima atu in tetti a pang tu ngual dang khat om hi; taciang keima thu tetti a pan na sia man hi, ci ka he hi. ");
INSERT INTO csy_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Note in John kungah na sawl uh a, taciang ama in thutak atu in tettipang hi. ");
INSERT INTO csy_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ahihang mihing kung pan in tetti panna sang ngawl khi hi: ahihang hi thu te note ngupna na nga thei natu uh in ka son a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","John sia a kuang le a tang khuavak a hihi: taciang note ama i khuavak sungah hunkhat sung nuam na sa uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ahihang John sang in a lianzaw tetti nei khi hi: banghangziam cile Pa in zaw tu in hongpiak nasep te ka seam hi, tua nasep te in keima sia Pa i hong sawl hi, ci tettipang hi. ");
INSERT INTO csy_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Taciang kei hongsawl Pa ama vateak in ka thu tettipang hi. Note in Ama aw sia bangma hun in na za ngei bua uh hi, a meal zong na mu ngei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A thu note sungah na kipsak bua uh hi: banghangziam cile ama i a sawl pa na um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tawntung nuntakna om hi, ci na ngaisut uh hu in, laithiangtho sungah na zong uh hi; ahihang laithiangtho in keima thu tettipang hi. ");
INSERT INTO csy_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ahihang nuntakna nga tu in ka kungah nong pai nuam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Mihing te kung pan in upatna ka sang bua hi. ");
INSERT INTO csy_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ahihang note sungah Pathian itna nei ngawl nu hi, ci kong he hi. ");
INSERT INTO csy_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ka Pa min taw kong pai hi, ahihang note in hong sang ngawl nu hi: ngualdang khat ama min taw hongpai le, note in na sang tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Khat le khat kung pan in zatakna sang a, Pathian kung pan bek in zatakna a zong ngawl peuma, bangbang in um thei tu nu ziam? ");
INSERT INTO csy_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Keima in Pa kungah kong mawsiat tu hi, ci ngaisun heak vun: note hong mawsiat tu khat om a, tasia in note i na muan mama uh Moses a hihi. ");
INSERT INTO csy_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Banghangziam cile Moses um hile uhte, keima zong hong um tu nu hi: banghangziam cile Moses in keima thu at hi. ");
INSERT INTO csy_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ahihang ama i at te na um bua uh a hile, ka kammal te bangbang in um thei tu nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Hi teng zawkciang in, Jesus sia Galilee tuili ah pai hi, tua mun sia Tiberias tuili a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Taciang mihon tampi in Ama zui uh hi, banghangziam cile cina te tungah a vawt nalamdang te a mu uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesus mual tungah kato a, tua mun ah nungzui te taw to khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Taciang Judah te paisanpoai hong nai zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus khua a dak ciang in mihon tampi Ama kungah hongpai mu a, Philip kungah, Hi te i neak tu anluum koisung pan lei tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hibang in a ci sia Philip a ze-et nop hang a hihi: banghangziam cile Ama in bang ka seam tu ci hekhol zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip in, mi khatsim in tawm tek ne tu ahizong, dangka za ni man anluum zong kicing zo ngawl tu hi, ci zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","A nungzui te sung pan khat, Simon Peter suapui pa Andrew in, ");
INSERT INTO csy_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Hiak ah patang khat om a, ama in bali anluum nga le ngasa no ni nei hi: ahihang mihing tam mama sungah, bang son thamman tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus in, Mipi te tosak vun, ci hi. Tua mun ah lopa tam mama om hi. Tua ahikom mipite to uh a, tul nga bang pha uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus in anluum te la a; lungdam a ko zawkciang in, a nungzui te kungah hawmsak hi, taciang a nungzui te in a to te hawmsak hi; tasia bangma in ngasa te zong amate dei za in hawmsak hi. ");
INSERT INTO csy_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amate a kham zawk uh ciang, Jesus in a nungzui te kungah, Bangma bo thong ngawl tu in a omlai teng kaikhawm tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tua ahikom bali anluum nga a neak zawk uh ciang in a neak mong uh teng amate in tawm uh a, a kaikhop uh ciang in, bawm sawm le bawm ni dim hi. ");
INSERT INTO csy_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amate in Jesus i sep nalamdang te a mu uh ciang in, leitung ah hongpai tu hi, a kici kamsang sia Ama tatak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tua ahikom Jesus in, amate hongpai in zawthawk thu taw kumpi hong seamsak tu hi, ci a heak ciang in, mualtung ah ama nguak pai hi. ");
INSERT INTO csy_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nitak sang ciang in, Jesus a nungzui te tuili sangah tuaksuk uh hi, ");
INSERT INTO csy_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ngunkuang sungah to uh a, tuili ngalkhat Capernaum sangah pai uh hi. Taciang khua hong zing hikale Jesus sia amate kungah hongpai ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hui nasiatak in hong va ahikom, tuihual te kilok ngawp hi. ");
INSERT INTO csy_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tua ahikom amate in ngunkuang sia tai thum tai li bang a hot zawk uh ciang, Jesus tuitung ah lampai in, ngunkuang sangah hong nai va-ial a mu uh ciang in amate lau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ahihang Jesus in amate tung ah, Keima khi hi; lau heak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tuazawkciang in amate in Jesus lungdamtak in ngunkuang sungah tosak uh hi: taciang ngunkuang zong amate pai natu ngam ah tawmvei sung in theng hi. ");
INSERT INTO csy_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","A zingciang in, tuili ngalkhat sangah a ding te in Jesus nungzui te i to na simngawl, ngunkuang dang om ngawl hi, ci mu uh hi, taciang Jesus a nungzui te taw ngunkuang sungah tum ngawl hi, ahihang a nungzui te amate bek pai uh hi; ");
INSERT INTO csy_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ahihang Topa in lungdam a ko zawkciang in, anluum a neak tekna uh Tiberias nai pan in ngunkuang dangte hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tua ahikom, mite in Jesus le a nungzui te tua mun ah om ngawl hi, ci a mu uh ciang in, amate zong ngunkuang to uh a, Jesus zong tu in Capernaum ah pai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Amate in tuili ngalkhat ah, Jesus a mu uh ciang in, Rabbi, hiak ah bang hun in pai ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus in, A tatak in kong ci hi, nalamdang na mu uh hang bek in hong zong na hi bua uh a, anluum khamteak in na neak uh hang in hong zong nu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A kisia thei an atu in naseam heak vun, ahihang tawntung nuntakna ciangdong a kho tu, mihing Tapa in note tungah hongpiak tu an atu in seam zaw vun: banghangziam cile Pa Pathian in ceptena khen zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tuazawkciang in amate in, Pathian nasep te ka sep thei natu uh in bang seam tu khu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus in amate tung ah, A ki sawl pa na um uh le Pathian naseam na hi uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Amate in, mu in ka up thei natu uh in, bang musakna hong lak tu ni ziam? a bang vawt tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Laithiangtho sungah a ki atsa bang in, ka pa te uh in senneal ngam ah mana ne ngei uh hi; ama in neak tu in vanpan in anluum pia hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesus in, A tatak in kong ci hi, Moses in van pan in anluum hong pia ngawl hi; ahihang ka Pa in van pan in anluum tatak note hong pia hi. ");
INSERT INTO csy_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Banghangziam cile Pathian i hongpiak anluum sia vantung pan in tuaksuk a, leitung nuntakna pia tu pa a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Amate in, Topa awng, hi anluum sia a tawntung in hong pia tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus in amate tung ah, Keima sia nuntakna anluum ka hihi: ka kung hongpai peuma a ngilkial kik nawn ngawl tu hi; keima hong um peuma a dangtak kik nawn ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ahihang ka sonsa bang in, note in hong mu zo napi, hong um ngawl nu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pa in hongpiak theampo ka kungah hongpai tu hi; taciang ka kung hongpai peuma ka hawlkhia ngei batu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Banghangziam cile keima deina bang seam tu in vantung pan kong tuaksuk bua hi, ahihang hong sawlpa deina seam tu in hong tuaksuk ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Keima hongpiak theampo khatzong bosua ngawl tu in, ni tawpkhak ni ciang, thawkiksak tu sia keima hong sawlpa i deina a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tapa a mu peuma in ama um a, tawntung nuntakna nei tu le ni tawpkhak ni ciang in keima in ka thawkiksak tu sia keima hong sawlpa i deina a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Keima sia vantung pan hong tuaksuk anluum ka hihi, a ci hu in Judah mite phun uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Taciang amate in, hi Jesus sia Joseph i tapa hi ngawl ziam, a pa le a nu te zong i heak hi ngawl ziam? bangbang in van pan in hong tuaksuk khi hi, ci thei ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tua ahikom Jesus in, Note sungah phun teaptup heak vun, ");
INSERT INTO csy_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Keima hong sawlpa in hong kai bale, kuama ka kungah hongpai thei ngawl hi: taciang keima in ni tawpkhak ni ciang in ka thokiksak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kamsang te laibu sungah, amate a vekpi in Pathian i hil te hi tu uh hi. Tua ahikom a za peuma le Pa kung pan a sin te ka kungah hongpai hi, ci in atkhol hi. ");
INSERT INTO csy_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Hibang ka ci ciang in, khatpo in Pa mu zo hi, cinopna hi ngawl hi, Pathian kung pan in hongpaipa bekma in Pa a mu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A tatak in kong ci hi, keima hong um peuma in tawntung nuntakna nei hi. ");
INSERT INTO csy_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Keima sia tua nuntakna anluum ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na pa te uh in senneal ngamsung ah mana ne napi uh a, thi siat veve hi. ");
INSERT INTO csy_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hisia in vantung pan hong tuaksuk anluum a hihi, tua anluum a ne peuma a thi bua tu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Keima in vantung pan hongpai a nungta anluum ka hihi. Khat po in hi anluum a ne le nungta tawntung tu hi, taciang ka piak tu anluum zong ka taksa hi a, tua in leitung mite nuntakna atu ka piak a hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tua ahikom Judah mite in, hisia pa in bangbang in a taksa sia neak tu in hong pia thei tu ziam? ci in amate le amate ki nial uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Tuazawkciang in Jesus in amate tung ah, A tatak in kong ci hi, mihing Tapa i taksa na ne bua uh a, a thisan na dawn bua uh le, na sung uh ah nuntakna na nei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","A kuamapo in ka taksa ne a, ka thisan a dawn peuma in, tawntung nuntakna nei hi; taciang ni tawpkhak ni ciang in ka thokiksak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Banghangziam cile ka taksa sia an tatak hi a, ka thisan sia dawn tu tatak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ka taksa ne a, ka thisan a dawn peuma, keima sungah om hi, taciang keima zong ama sungah ka om hi. ");
INSERT INTO csy_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","A nungta Pa in kei hong sawl a, taciang Pa hang in ka nungta hi: tua ahikom ka taksa a ne peuma, keima hang in nungta tu hi. ");
INSERT INTO csy_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Hi thu sia vantung pan hong tuaksuk anluum a hihi: na pate uh mana ne a, a thi uh bang hi ngawl hi: hi anluum a ne peuma a tawntung in nungta tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Hi thu te Capernaum khua synagogue sungah thu a hil lai in, ahil thu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Tua ahikom a nungzui tampi te in hi thu a zak uh ciang in, hi thu haksa lei hi; a kua in ngai zo tu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesus in a nungzui te phun uh hi, ci a heak ciang in, amate tung ah, Hi thu in hong puksak ziam? ");
INSERT INTO csy_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mihing Tapa ama omna ah a kato mu le uhte, bang na ci tu uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nuntakna a pia sia Pathian i Thaa a hihi; cilesa sia bangma phattuamna nei ngawl hi: note tungah kong son kammal te sia, thaa le nuntakna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ahihang note sungah mi pawlkhat te in na um bua uh hi, ci hi. Banghangziam cile Jesus in a kipatcil pan kipan in a um ngawl te le, ama a leheak tu sia a heakkholsa hi zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tua ahikom kong ci hi, Pa in hongpiak te simngawl kuama ka kungah hongpai thei ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tua hun pan kipan in nungzui tampi te heakkik uh a, Ama taw ki thawl nawn ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tuazawkciang in Jesus in a nungzui sawmleni te kungah, Note zong nong paisan nuam uh ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter in, Topa awng, a kua kungah pai tu khu ziam? nangma in tawntung nuntakna kammal te na nei hi. ");
INSERT INTO csy_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nangma sia a nungta Pathian Tapa Christ na hihi, ci um in ka he uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus in, Sawmle ni hong teal hi ngawl khi ziam? taciang note sungah khat sia doai a hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ama in Simon tapa Judah Iscariot thu a son a hihi: banghangziam cile nungzui sawmleni sung pan khat hi napi, Ama a leheak pa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Hibang teng zawkciang in, Jesus Galilee huam sungah pai hi: banghangziam cile Judah mite in that nuam ahikom Judah ngam sungah pai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tu in Judah te i biakbuk poai hong nai zo hi. ");
INSERT INTO csy_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tua ahikom a suapui te in Jesus kungah, na vawt nasep te na nungzui te zong in a mu thei natu in, hi mun pan Judah ngam sungah pai tan. ");
INSERT INTO csy_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Banghangziam cile a kilang in ngual heak tu a dei te kuama in a thimtham in seam ngawl hi. Hibang te na vawt ahile leitung mite kungah nangma le nangma ki pualak in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Banghangziam cile a suapui te in zong Ama a um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Tuazawkciang in Jesus in amate tung ah, Ka hun hong theng ngawl lai hi: ahihang note atu a tawntung in hunpha a hihi. ");
INSERT INTO csy_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Leitung in note hong ensan thei ngawl hi; ahihang kei hong ensan hi, banghangziam cile amate nasep phangawl hi, ci tetti ka pang hi. ");
INSERT INTO csy_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Hi poai ah pai tavun: kei hile ka hun cing ngawl lai ahikom pai ngawl lai tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hi thu te a son laitak in, Ama sia Galilee ah om nginge lai hi. ");
INSERT INTO csy_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ahihang a suapui te a pai zawkciang in, Jesus zong poai ah hongpai a, a kilang ngawl in pai ku hi. ");
INSERT INTO csy_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tuazawkciang in poai mun ah Judah te in Ama zong uh a, koisung ah om ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Taciang mipi te sungah Jesus thu taw kisai in phun teaptup uh hi: banghangziam cile mi pawlkhat te in, Ama sia mipha hi, ci uh a: a dang te in, hi ngawl hi; Ama in ngual theam hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ahihang Judah mite a lau uh hu in kuama in a kilang in a pau ngam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Tu in poai a lang bang a man ciang Jesus biakinn sungah pai a, thuhil hi. ");
INSERT INTO csy_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judah mite in lamdangsa in, hi sia pa sia sin le sin ngei ngawl napi, bangbang in lai he thei ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus in, Kong hil thu sia keima a hi ngawl hi, ahihang keima hong sawlpa i hilna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mihing khatpo in Pathian deina a seam tu ahile, ka hilna sia Pathian kung pan maw, a hibale keima thinsung suak hi zaw, ci he tu hi. ");
INSERT INTO csy_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ama thinsung suak a hil peuma in ama minthanna tu zong hi: ahihang ama a sawlpa atu in minthanna a zong sia mipha a hihi, taciang ama sungah thuman ngawl na om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses in note thukham hong pia hi ngawl ziam? ahihang kuama in thukham na zui bua uh hi, Banghang in hong that nuam nu ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mipi te in, doai vei ni hi: kua in hong that nuam na ziam? ci zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus in amate tung ah, Nasep khat ka seam a, na vekpi in lamdang na sa uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tua ahikom Moses in vunteap atna thu hong pia hi; (hi sia in Moses hang hi ngawl in, pu le pa te hang a hihi;) taciang note in sabbath ni in vunteap at nu hi. ");
INSERT INTO csy_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moses thukham paltan ngawl tu in khatpo in sabbath ni in vunteap ki at a hile, banghang in sabbath ni in mihing khat ka damsak hang in ka tungah thin-uk nu ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Maitang en in thukhen heak vun, ahihang a man thukhenna taw thukhen vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tuazawkciang in Jerusalem pan mi pawlkhat te in, ngual i thatlum nuam in a zon uh sia hi sia pa hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ahihang, en vun, hangsantak in thuhil a, amate in bangma ci thei ngawl hi. Ngam uk te in hisia pa sia Christ tatak hi, ci a he takpi uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ahihang hisia pa sia a kua ziam, ci i he bua hi: ahihang Christ hongpai ciang in, koisung pan hongpai, ci sia kuama in he ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesus sia biakinn sungah thu a hil kawm in au a, Note in hong he nu hi, taciang koisung pan hongpai, ci zong hong he nu hi: ahihang kei hong sawlpa sia thuman hi a, note in Ama na he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ahihang keima in Ama ka he hi: banghangziam cile keima sia Ama kung pan ka hi a, Ama in hong sawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tuazawkciang in amate in Jesus mat sawm uh hi: ahihang kuama in man ngam ngawl hi, banghangziam cile a hun cing ngawl lai hi. ");
INSERT INTO csy_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Taciang mi tampi te in Ama um uh a, Christ hongpai ciang in, hi sia pa i vawt sang in a tamzaw nalamdang te vawt tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pharisee te in Jesus thu taw kisai in mite a phunna thu za uh hi; taciang Pharisee te le thiampi lian te in Jesuh man tu in palik te paisak hi. ");
INSERT INTO csy_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tuazawkciang in Jesus in amate tung ah, Tawmvei sung note taw kong omkhawm tu hi, taciang kei hong sawlpa kungah pai tu khi hi. ");
INSERT INTO csy_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Note in nong zong tu uh a, ahihang nong mu bua tu uh hi: ka omna mun ah note nong pai thei bua tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tuazawkciang in Judah te in amate sungah, ei i mu ngawl tu in koisung pai tu ziam? Gentile mite sungah a ki thethang te kung pai in, Gentile mite hil tu a hi tu ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Note in nong zong tu uh a, ahihang hong mu ngawl tu nu hi: ka omna mun ah note nong pai thei bua tu uh hi, a ci sia bang a cinopna hi tu ziam? ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Poai ni a khakbel, ni thupi ni in, Jesus hong ding a, Khatpo a dang a tak le, ka kungah hongpai tahen a, dawn tahen. ");
INSERT INTO csy_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Keima hong um peuma laithiangtho in a ci bang in, a pumpi sung pan in a nungta nguntui luang tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ahihang hithu sia Jesus in Ama a umte in a san tu Thaa thu a sonna a hihi: banghangziam cile Jesus vang ki liansak ngawl lai ahikom in Tha Thiangtho ki pia ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tua ahikom in mi tampi in hi thu a zak uh ciang in, hisia pa sia kamsang tatak hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Midang te in, hisia Christ hi, ci uh hi. Ahihang pawlkhat te in, Galilee pan Christ hongpai tu ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Laithiangtho in, Christ sia David suan sung pan hongpai tu hi, taciang David omna Bethlehem khuapi pan hongpai tu hi, ci hi ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tua ahikom, Jesus hang in mite sungah ki khenna hong om hi. ");
INSERT INTO csy_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pawlkhat te in man nuam uh hi napi; ahihang kuama in khut a nga ngam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tuazawkciang in, palik te thiampi lian le Pharisee te kungah hongpai uh a; amate in, banghang in Jesus hong paipui ngawl nu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Palik te in, hisia pa bang in kuama in thuhil ngei ngawl hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tuazawkciang in Pharisee te in, note zong hong theam tha zo ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ngam uk te le Pharisee te sungah Ama a um om zo ziam? ");
INSERT INTO csy_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ahihang thukham a he ngawl hi mite sia hamsiat thuak te a hi uh hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pharisee te sung pan mi khat a hi, zan lai in Jesus kungah a pai Nicodemus in, amate tung ah, ");
INSERT INTO csy_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Ih thukham in mi khat sia a thu ngai masa ngawl in le a vawtna he masa ngawl in thukhen ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Amate in zo kik a, nangma zong Galilee mi ni ziam? kan in a, en in: banghangziam cile Galilee pan in kamsang piang ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Taciang amate inn tek ah cia siat uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus Olive mualtung ah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Taciang zingtung in biakinn sungah paikik a, mi theampo a kungah hongpai uh hi; taciang to in, amate thuhil hi. ");
INSERT INTO csy_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Taciang thukhamhil te le Pharisee te in palngul mawna a vawt laitak a mat numei khat hong paipui uh a; a laizang ah a koi zawk uh ciang, ");
INSERT INTO csy_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jesus kungah, Syapa awng, hi numei nu sia palngul mawna a vawt laitak in a kiman a hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Tu in Moses in thukham sungah hibang te suangtum taw den tu in thu hong pia hi: ahihang nang bangbang ci tu ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Amate in hibang in a ci uh sia, Jesus a mawsiat thei natu uh in aita a hi uh hi. Ahihang Jesus in a za ngawl bang in kun a, lei ah a khutzung taw lai at hi. ");
INSERT INTO csy_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Amate in a ki zom in thu a dok uh ciang in, Jesus vandakto a amate tung ah, Note sungah mawna a nei ngawl sia in deang masa tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Taciang kun kik a, lei ah lai atkik leleau hi. ");
INSERT INTO csy_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tua thu amate in za uh a, sia le pha heakna in amate mawna kiphawksak ahi man in u hambel pan khat zawkciang khat a khakbel dong in nusia uh hi: Jesus bek nusia uh a, numei nu sia a lai ah ding nginge hi. ");
INSERT INTO csy_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesus a dakto kik ciang in, numei nu simngawl kuama mu ngawl hi, Jesus in numei nu kungah, Nangma hong mawsiat te koisung ziam? kuama in hong mawsak ngawl ahi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Numei nu in, Topa awng, kuama in hong mawsak ngawl hi, ci hi. Jesus in ama kungah, Kei zong hong mawsak ngawl khi hi: pai tan a, mawna vawt nawn heak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus in amate paupui kik a, Keima sia leitung khuavak ka hihi: ka nung hong zui peuma khuazing sungah vak ngawl tu hi, ahihang nuntakna i khuavak nei tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tua ahikom Pharisee te in Jesus kungah, nangma thu sia nangma ma in tetti na pang hi, na tetti pan na man ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus in amate zo kik a, Keima thu keima ma in tettipang hi ka leng, ka tettipanna sia man veve hi: banghangziam cile koisungpan kong pai, ci le koisung ah pai tu, ci ka he hi, ahihang kongpan kong pai cile koisung ah pai tu ci note in nong son thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Note in ci le sa zui in thu na khen uh hi; kei ka hile kuama thu ka khen bua hi. ");
INSERT INTO csy_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taciang thu ka khen hial zong, ka thukhenna man hi: banghangziam cile keima bek hi ngawl khi hi, ahihang keima le hong sawlpa taw ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na thukham uh sungah zong, mihing ni i tettipanna sia man hi, ci ki at hi. ");
INSERT INTO csy_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Keima thu sia keima in tetti ka pang hi, taciang hongsawl Pa in keima thu tettipang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tuazawkciang in amate in Jesus kungah, na Pa koisung ziam? ci uh hi. Jesus in, Note in nong he bua uh hi, taciang ka Pa zong na he bua uh hi: keima hong he le uhte, ka Pa zong na he tu uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Hi thu te sia Jesus in biakinn sungah thu a hil kawm in, sumpi kuang koina mun ah a son thu a hihi: taciang kuama in Ama a man ngam bua uh hi; banghangziam cile a hun a cing balai hi. ");
INSERT INTO csy_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tuazawkciang in Jesus in amate tung ah, Ka pai natu lampi ah ka pai tu a, note in nong zong tu uh hi, taciang na mawna uh sungah na thi tu uh hi: ka pai na mun ah note nong pai thei bua tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tuazawkciang in Judah mite in, ka pai na mun ah note nong pai thei bua tu uh hi, ci ahikom, Ama le Ama ki that tu a hi tu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus in amate tung ah, Note sia nuailam mi na hi uh hi; kei sia tunglam mi ka hihi: note hileitung mi na hi uh hi; keima sia leitung mi ka hi bua hi. ");
INSERT INTO csy_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Tua ahikom, na mawna uh sungah na thi tu uh hi, ci note tungah kong ci hi: banghangziam cile keima sia Ama khi hi, ci na up ngawl uh hu in na mawna uh sungah na thi tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tuazawkciang in amate in, Nang a kua ni ziam? ci uh hi. Taciang Jesus in amate tung ah, A kipatcil pan kipan in kong son sa bangma ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Note tungah kong son tu le thu ka khen tu tampi om hi: ahihang kei hong sawlpa sia a thuman hi; taciang Ama tung pan ka zak thu te leitung mite tungah ka son hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesus in Pa thu a son na amate in a tel bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Tuazawkciang in Jesus in amate tung ah, Mihing Tapa na khai uh ciang in keima sia Ama khi hi, ci le, keima thu taw bangma vawt ngawl khi hi; ahihang Pa in hong hilna bang in, hi thu te kong son hi, ci na he tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Taciang kei hong sawlpa sia keima taw om hi: Pa in keima bek hong nusia ngawl hi; banghangziam cile Ama lungkim na te ka seam tawntung hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hi thu te a son zawkciang in, mi tampi in Ama um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tuazawkciang in Jesus in Ama a um Judah te tung ah, Ka thu sungah na kip uh a hile, ka nungzui tatak na hi uh hi; ");
INSERT INTO csy_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Taciang thutak na he tu uh a, tua thutak in hong suaktasak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Amate in, kote sia Abraham suan te ka hi uh hi, taciang kuama kungah saltang ngei ngawl khu hi: bangbang in nang in, na suakta tu uh hi, hong ci ni ziam? ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus in amate tung ah, A tatak in kong ci hi, a kuamapo mawna a vawt peuma mawna i sila a hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Taciang sila sia a tawntung in innsung ah om tawntung ngawl hi: ahihang Tapa ahile om tawntung hi. ");
INSERT INTO csy_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Tua ahikom Tapa in hong suaktasak a hile, na suakta takpi tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Note sia Abraham suan te na hi uh hi, ci ka he hi; ahihang keima that tu in hong zong nu hi, banghangziam cile ka thu in note sungah mun nei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ka Pa taw ka mu thu te ka son hi: taciang na pa uh taw na mu uh te na vawt uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Amate in, Abraham sia ka pa uh hi, ci in zo uh hi. Jesus in amate tung ah, Abraham i tate na hi uh le, Abraham i nasep te seam tu nu hi. ");
INSERT INTO csy_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ahihang tu in, Pathian tung pan ka zak thutak a son keima hong that nuam in hong zong nu hi: Abraham in hibang te vawt ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Note in na pa uh i septe na seam uh hi, ci hi. Tuazawkciang in amate in, kote paktat na pan a piang lamlakta hi ngawl khu hi; Pa khat ka nei uh a, tasia in Pathian a hihi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus in amate tung ah, Pathian sia na Pa uh hile, keima hong it tu nu hi: banghangziam cile keima sia Pathian kungpan piang in hongpai ka hihi; keima thu in kongpai bua hi, ahihang Ama in hong sawl hi. ");
INSERT INTO csy_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ka thuson te bang hang in um thei ngawl nu ziam? ka thu na zak thei ngawl uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Note sia na pa uh doaimangpa i tate na hi uh hi, taciang na pa uh i deina bek na seam uh hi. Ama sia a kipatcil pan kipan in tualthat pa a hihi, taciang thutak sungah om ngawl hi, banghangziam cile ama sungah thutak om ngawl hi. Leilotthu a son ciang in, ama i nei te bek son hi: banghangziam cile ama sia leilotthu son pa hi a, leilotthu i pa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Taciang note in thutak ka son hu in, nong um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Note sungah a kua in ka maw hunlam hong lak thei tu nu ziam? Taciang thutak ka son a hile, banghang in hong um ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pathian mite in Pathian thu ngai uh hi: tua ahikom, note Pathian mi na hi ngawl uh hu in Pathian thu na ngai bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Judah mite in zo kik uh a, Nangma sia Samaria mi na hihi, taciang nangma doai vei ni hi, kong ci uh sia man hi ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus in, Doai vei ngawl khi hi; note in hong zakta ngawl nu hi, ahihang keima in ka Pa ka zakta hi. ");
INSERT INTO csy_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Taciang keima minthanna tu zong ngawl khi hi: ama minthan natu zong in thu a khen khat om hi. ");
INSERT INTO csy_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","A tatak in kong ci hi, khatpo in ka kammal a zui le bangmahun in thina mu ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tuazawkciang in Judah te in, tu in doai vei ni hi, ci ka he uh hi. Abraham le kamsang te thi siat zo hi; ahihang nangma in, khatpo in ka thu a zui le bangmahun in thina tep ngawl tu hi, na ci hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nangma sia ka pu uh Abraham sang in thupi zaw ni ziam? Abraham thi zo hi, taciang kamsang te zong thi siat zo hi: nangma le nangma kua ki sa ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus in, Keima le keima ka ki thupisak le, tua ka ki thupisak na sia bangma hi ngawl hi: keima hong thuphisak sia ka Pa hi a; note i Pathian na ci uh sia a hihi. ");
INSERT INTO csy_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Note in Ama na he bua lai uh hi; ahihang keima in ka he hi: taciang keima in ka he bua hi ka ci le, note bangma in leilot thuson ka hi tu hi: ahihang keima in Ama ka he a, a thu zong ka ni hi. ");
INSERT INTO csy_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Na pa uh Abraham in keima ni mu tu lawp mama hi: taciang mu zo a, angtang mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Tuazawkciang in Judah te in a kungah, Nangma sia kum sawm nga zong phangawl lai napi, Abraham mu zo ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus in amate tung ah, A tatak in kong ci hi, Abraham pian ma in kei ka om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tuazawkciang in amate in suangtum te tawm uh a, den sawm uh hi: ahihang Jesus bu a, biakinn sung pan pusuak hi, taciang amate zanglai pan in kantan hi. ");
INSERT INTO csy_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus lampi ah a pai laitak in, a pian pan kipan mittaw khat mu hi. ");
INSERT INTO csy_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","A nungzui te in Syapa awng, hisia pa mittaw in a pian sia ama in mawna a vawt hang ziam maw, a hibale a nu le a pa te in mawna a vawt uh hang ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus in, Ama mawna hang hi ngawl hi, taciang a nu le a pa mawna hang zong hi ngawl hi: ahihang Pathian i nasep te ama tung pan a kilang thei natu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Sun hun ahi lai in keima hong sawlpa i nasep te ka sep hamtang tu a hihi: kuama na a sep thei ngawl hun, zan hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Leitung ah ka om sung theampo, keima sia leitung i khuavak ka hihi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus in hibang a ci zawkciang in, leitung ah cilsia suk a, a cil taw buannoai vawt hi, taciang mittaw pa i mitte buan noisak hi, ");
INSERT INTO csy_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Taciang ama tung ah, Pai tan a, Siloam tuili ah sil tan, ci hi. Siloam a khiakna sia, sawl, a cinopna a hihi. Tua ahikom ama zong pai a, a sil zawkciang in, khuamu in cia hi. ");
INSERT INTO csy_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tua ahikom a innpam te le, nidang mittaw a hi a mu ngei te in, hisia pa sia, to a khutdaw ngen pa hi ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Pawlkhat te in, hisia ama hi, ci uh a: midang te in, ama tua pa taw kibang hi, ci uh hi: ahihang ama in, keima khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tua ahikom amate in, bangbang in na mit khuamu ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ama in, Jesus a kici khat in buan vawt a, ka mit te hong noisak hi, taciang Siloam tuili ah pai tan a, sil in, hong ci hi: taciang ka pai a ka sil zawkciang in, khuamu khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tuazawkciang in amate in, tua pa koisung ziam? ci uh hi. Ama in, kei he ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tuazawkciang amate in a mittaw ngeipa sia, Pharisee te kungah paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jesus in leibuan vawt a, a mitte khua a musak sia sabbath ni a hihi. ");
INSERT INTO csy_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tuazawkciang in Pharisee te in zong, bangbang in khua mu ni ziam, ci in dongkik uh hi. Ama in ka mit ah leibuan hongkoisak a, ka sil zawkciang in, khuamu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tua ahikom Pharisee pawlkhat te in, hisia pa sia Pathian mi hi ngawl hi, banghangziam cile sabbath ni tang ngawl hi, ci uh hi. Midang te in, mimaw khat in hibang nalamdang te bangbang in vawt thei tu ziam? ci uh hi. Taciang amate sungah kikhen na hong om hi. ");
INSERT INTO csy_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Amate in mittaw pa kungah, na mit khua hong musak pa bangba na ngaisun ziam? ci kik uh hi. Mittaw pa in, Ama sia kamsang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ahihang Judah te in, ama a mittaw ngei a, khuamu kik hi, ci thu a up ngawl uh hu in, a nu le a pa te sam uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Taciang amate in, hisia na tapa uh a pian pan in mittaw na ci uh sia ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","A pa le a nu in, hisia ka tapa uh hi, taciang mittaw in piang hi, ci ka he uh hi: ");
INSERT INTO csy_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ahihang bangbang in tu in khuamu kik, ci le kua in a mit khuamusak, ci he ngawl khu hi: ama puicing zo hi; ama dong vun: ama in ama atu hong son tu hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A nu le a pa in Judah te a lau uh hu in hibang in a ci uh a hihi: banghangziam cile mi khatpo in ama sia Christ hi, ci in a pualak a hile synagogue sung pan hawlkhiat tu in lungkimna nei zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Tua ahikom a nu le a pa in, ama sia puicing zo hi; ama dong vun, a ci a hihi. ");
INSERT INTO csy_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tuazawkciang in amate in mittaw pa samkik leleau uh a, Pathian pokna pia in: hisia pa sia mawnei hi ci ka he uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Tua pa in, kei ka hile Ama mawnei a hile a hi ngawl ka he bua hi: ka heak thu khat sia, mittaw ka hi ngei a, tu in khuamu khi hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tuazawkciang in amate in, na tungah bang hong law ziam? na mitte bangbang in khuamusak ziam? ci in dong leleau uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ama in, hong son zo khi hi, na za bua uh hi: zakik nuam nu ziam? noma zong Ama nungzui nuam nu ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tuazawkciang in amate in tua pa sia selno in, nangma sia Ama nungzui na hihi; ahihang kote ka hi uh le Moses nungzui ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Pathian in Moses paupui hi, ci ka he uh hi: hisia pa sia koisungpan hongpai ci ka he bua uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tua pa in amate tung ah, koisungpan hongpai ci na heak ngawl uh sia lamdang mama hi, ahihang Ama in ka mit khua hong musak hi. ");
INSERT INTO csy_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tu in Pathian in mawnei te kammal ngai ngawl hi, ci ka he uh hi: ahihang mi khatpo in Pathian bia in, a deina a seam le, tua pa i kammal te ngai hi. ");
INSERT INTO csy_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Leitung kipat pan mittaw in a piang kuama a mit khuamusak, ci i za ngei bua hi. ");
INSERT INTO csy_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hisia pa sia Pathian mi ahi buale, bangma vawt thei ngawl tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Amate in, Nang sia mawna namcin sung pan piang na hi a, hong hil sawm zaw ni ziam? ci in zo uh a, pua sangah nawt uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus in a puasang ah nawt uh hi ci thu a zak ciang in; tua pa taw ki mu a, Pathian Tapa na um ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tua pa in, Topa awng, Ama ka up thei natu in Ama sia a kua ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus in ama tung ah, Ama na mu zo hi, taciang nangma taw a kipau sia Ama a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Taciang ama in, Topa awng, um khi hi, ci in, Jesus bia hi. ");
INSERT INTO csy_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesus in, Hi leitung ah thukhen tu in kong pai hi, tua thukhenna sia mittaw te in khuamu tu a; khua a mu te mittawsak tu in hongpai ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesus kungah a om Pharisee pawlkhat te in hi thu a zak uh ciang in, kote zong ka mit uh taw ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus in amate tung ah, Mittaw hile uhte, maw nei ngawl zawsap tu nu hi: ahihang tu in, note in khua ka mu uh hi, na ci uh hu in, a maw lai na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","A tatak in kong ci hi, tuukhawk sungah kongkha pan tum ngawl in, mundang pan a kato peuma, nguta le phalak te a hihi. ");
INSERT INTO csy_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ahihang kongkha pan a tum sia a hile tuu te i tuucing a hihi. ");
INSERT INTO csy_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kongkha cingpa in ama kong hon a; tuu te in ama aw a za uh hi: taciang ama in tuu te a min taw sam in, pusua pui hi. ");
INSERT INTO csy_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Taciang a tuu te a pusua zawkciang, ama sia tuu te mai ah pai a, tuu te in zui hi: banghangziam cile tuu te in ama aw a he uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amate in ngualdang nung zui ngawl tu uh hi, a kung pan tai zaw tu uh hi: banghangziam cile amate in ngualdang te aw a he bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus in hi sontena amate tungah son hi: ahihang amate in bangson ci a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Tuazawkciang in Jesus in amate tung ah, A tatak in kong ci hi, keima in tuu kongpi ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ka mai ah hongpai sa theampo sia nguta le phalak te a hi uh hi: ahihang tuu te in amate aw a ngai bua hi. ");
INSERT INTO csy_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Keima in kongkha ka hihi: mi khatpo keima tawn in a tum a hile, ki ngum tu hi, taciang in sungtang le pusuak tu a, lono hing a mu tu hi. ");
INSERT INTO csy_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Nguta in ngu tu, that tu le susia tu bek in hongpai hi: kei ka hile amate in nuntakna a nei thei natu le a dimlet nuntakna a nei thei natu in kongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Keima in tuucing pha ka hihi: tuucing pha in a tuu te atu in a nuntakna pia hi. ");
INSERT INTO csy_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ahihang tuucing a hi ngawl, tuu nei pa zong hi ngawl, a kicial tawm tuucing pa in, ngia hongpai a mu ciang, tuu te nusia in, taisan hi: taciang ngia in tuu te man a, ki thethang siat hi. ");
INSERT INTO csy_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","A kicial tawm tuucing pa sia tai hi, banghangziam cile ama sia sum thalaw hi a, tuu te awlmawk ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Keima in tuucing pha ka hihi, keima in ka tuu te ka he hi, taciang ka tuu te in zong hong he uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pa in keima hong heak bang in, keima in zong Pa ka he hi: taciang ka tuu te atu in ka nuntakna ka pia hi. ");
INSERT INTO csy_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Taciang hi tuukhawk sungah a theng ngawl lai tuu dang te ka nei lai hi: amate zong ka paipui tu hi, taciang amate in ka aw ngai tu uh a; tuukhawk khat le tuucing khat suak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Tua ahikom ka Pa in keima hong it hi, banghangziam cile ka nuntakna ka lak kik thei tu in ka pia hi. ");
INSERT INTO csy_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ka nuntakna sia kuama in kei tung pan in la ngawl hi, ahihang keima thu in ka piak a hihi. Piak thei natu vangletna ka nei a, lakkik thei natu vangletna zong ka nei hi. Hi thupiak sia ka Pa tung pan in ka nga a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hi thu te hang in Judah mite sungah ki khenna omkik hi. ");
INSERT INTO csy_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mitampi in, Ama in doai vei a, a thin-am hi; banghang in a thu ngai nu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ngual dang te in, hibang te sia doai vei te i kammal te hi ngawl hi. Doai in mittaw te khua musak thei ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Taciang Jerusalem ah apna poai om a, tua hun sia phalbi hun a hihi. ");
INSERT INTO csy_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus biakinn sung, Solomon talaap sungah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tuazawkciang in Judah mite hongpai uh a, Jesus kim um uh hi, taciang banghun ciangdong hong lungmangsak lai tu ni ziam? Nangma sia Christ na hile, a thiang in hong son tan, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus in, Kong son zo hi, taciang note in um ngawl nu hi: ka Pa min taw ka vawt nasep te in, keima atu in tettipang hi. ");
INSERT INTO csy_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ahihang kong son sa bang in, ka tuu te na hi ngawl uh hu in, um ngawl na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ka tuu te in ka aw hong ngai hi, taciang keima in amate ka he hi, taciang amate in hong zui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Taciang amate tung ah, tawntung nuntakna ka pia a; bangmahun in kisia ngei nawn ngawl tu hi, kuama in zong ka khutsung pan hong sut thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ka tungah hong pia ka Pa sia na theampo sang in lianzaw hi; taciang amate kuama in ka Pa khut sung pan hong sut thei ngwl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ka pa le keima sia khat ka hi uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tuazawkciang in Judah mite in Ama sep tu in suangtum tawm leleau uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus in amate tung ah, Pa kung pan in nasep pha tampi kong lak zo hi; tua nasep te atu in suangtum taw hong sep na hi uh ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judah mite in zo kik uh a, nasep pha atu in suangtum taw kong sep bua uh hi; ahihang Pathian min na daisak hang a hihi; taciang mihing hi napi, nangma le nangma Pathian in na ki vawt hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus in amate zo kik a, Na thukham uh sungah, note sia pathian te na hi uh hi, ci in ki at hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Amate tung pan Pathian kammal hongpai a hikom in, pathian te, kici a hile, laithiangtho ki paltan thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Keima sia Pa in hong thiangthosak a, leitung ah hong sawl hi, keima sia Pathian Tapa ka hihi, ka ci hu in Pathian mindaisak ni hi, hong ci na hi uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ka Pa i nasep te ka seam bua a hile, hong um heak vun. ");
INSERT INTO csy_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ahihang ka seam a hile, keima nong um bua uh zong, ka nasep te um vun: tabang in Pa sia ka sungah om a, keima sia Pa sungah ka om hi, ci na he tu uh a, hong um tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Tua ahikom amate in Jesus sia mat sawm leleau uh hi: ahihang amate khut pan in Jesus suakta hi, ");
INSERT INTO csy_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Taciang Jesus sia Jordan ngun ngal, John in amasabel tuiphumna a piak na mun ah paikik a; tua mun ah taam hi. ");
INSERT INTO csy_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Taciang mi tampi a kungah hongpai uh a, John in nalamdang bangma vawt ngawl hi: ahihang hisia pa thu John i son theampo man hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tua mun ah mitampi in Ama um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bethany ah a teang Lazarus a kici khat sia a cina hi, tua Bethany sia Mary le a suapui nu Martha te i khuapi a hihi. ");
INSERT INTO csy_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Hi Mary sia Topa sathau namtui buak in, taciang a sam taw a peang a nawlsak nu hi a, a suapuipa Lazarus sia a cina hi. ");
INSERT INTO csy_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tua ahikom a suapui nu in ngual paisak a, Topa, en in, na it bel pa a cina hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tua thu Jesus in a zakciang in, Hi natna sia thi natu natna hi ngawl hi, ahihang Pathian minthanna tu hi a, tua tungtawn in Pathian Tapa in minthanna nga tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus in Martha, a suapui nu le Lazarus te it hi. ");
INSERT INTO csy_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lazarus a cina, ci thu za hi kale, a omna ah ni ni sung taam lai hi. ");
INSERT INTO csy_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tuazawkciang a nungzui te kungah, Judah ngam sungah paikik tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","A nungzui te in, Syapa awng, Judah mite in tu nung hiat ma in, suangtum taw den tu in hong zong uh a; tua mun ah paikik tu ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus in, Nikhat sungah nai sawm le nai ni om hi ngawl ziam? Khatpo sia sun hun in a vakle lutu ngawl hi, banghangziam cile ama in hi leitung khuavak mu hi. ");
INSERT INTO csy_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ahihang khatpo in zan in a vak le, lutu tu hi, banghangziam cile ama sungah khuavak om ngawl hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hi thu te a son zawkciang in, Jesus in amate tung ah, I lawmpa Lazarus mu hi; ahihang keima ka pai tu a, a mut na pan in ka phong tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","A nungzui te in, Topa awng, mu a hile, dam tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ahihang Jesus in a thina thu a son a hihi: hi kamale amate in tawlnga in mu hi ci bang in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tuazawkciang in Jesus in amate tungah son thiang a, Lazarus thi hi. ");
INSERT INTO csy_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Taciang, na up thei natu uh in tua mun ah ka om ngawl sia note atu in ka angtang hi; hi kale a kungah pai tek tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuazawkciang in, Didymus a kici Thomas in, a nungzui pui te kungah, Ama taw thi khawm tu in eite zong pai tek tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesus a thet ciang in, Lazarus sia than ah a phum zawk ni li hi zo ci he hi. ");
INSERT INTO csy_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bethany sia Jerusalem nai na ah om a, tai ni dektak pha hi: ");
INSERT INTO csy_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Martha le Mary te sia a suapuipa taw kisai, amate a heneam tu in Judah mi tampi te hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tuazawkciang in, Martha in Jesus hongpai hi, ci a zak po ciang, pai in muak hi: ahihang Mary sia innsung ah to nginge hi. ");
INSERT INTO csy_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha in Jesus kungah, Topa awng, himun ah om hile te, ka suapui pa thi ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ahihang, tu zong in Pathian tungah na nget theampo Pathian in hong pia tu hi, ci ka he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus in Martha kungah, Na suapuipa thokik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha in Jesus kungah, thawkikna ni tawpkhak ni ciang in thokik tu hi, ci ka he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus in ama kungah, Keima in thawkikna le nuntakna ka hihi: keima hong um peuma, a thi zong in nungta tu hi: ");
INSERT INTO csy_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Taciang in a kuamapo nungta a, keima hong um peuma bangmahun in thi nawn ngawl tu uh hi. Hi thu na um ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha in, Hi hi, Topa awng: nangma in leitung ah hongpai tu Pathian Tapa, Christ na hihi, ci ka um hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha sia tateng a pau zawkciang pai hi, taciang a nau Mary samku a, Syapa hongpai hi, taciang nangma hong sam hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Tua thu Mary in a zak pociang manlangtak in ding a, Jesus kungah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tu in Jesus sia khuapi sungah tum ngawllai a, Martha i a mu na mun ah omlai hi. ");
INSERT INTO csy_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mary inn ah a om Judah mite le ama a heneam te in, Mary manlangtak in ding a, a pusua a mu uh ciang, zui kheukho uh a, than ah a kap tu in pai hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesus kungah Mary a thet ciang in, Jesus mu a, a peang ah bok in, Topa awng, nangma himun ah om le te, ka suapuipa thi ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Tua ahikom Jesus in Mary kakap in le, ama taw hongpai Judah mite zong a kakap a mu ciang in, a thaa in thuak hak sa in, tau a, ");
INSERT INTO csy_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Koisung ah phum nu ziam? ci hi. Amate in, Topa awng, hongpai tan a, en in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus kap hi. ");
INSERT INTO csy_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tuazawkciang in Judah mite in, en vun, Lazarus bangza in it ziam! ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Taciang pawlkhat te in, mittaw te khua a musak hisia pa in, Lazarus thi ngawl tu in vawt thei ngawl a hi tam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tua ahikom Jesus a thinsung pan tau kawm in than ah pai hi. Hi than sia suanghawng hi a, a tungah suangtum khat taw huk hi. ");
INSERT INTO csy_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus in, A suangtum khin vun, ci hi. Mithi pa suapui nu Martha in, Topa awng, tu in ui zo tu hi: banghangziam cile a thi zawk ni li hi zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus in ama tung ah, Na umle, Pathian vangletna na mu tu hi, hong ci zo hi ngawl khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tuazawkciang in amate in suangtum sia mithi ki sial na pan in khin uh hi. Taciang Jesus in a tungsang ento a, Pa awng, nangma in hong za zo na hikom in lungdam kong ko hi. ");
INSERT INTO csy_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Taciang a tawntung in nong za hi, ci ka he hi: ahihang ka kiim ah a ding mihing te in, nangma in keima nong sawl hi, ci a up thei natu uh in kong ci a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tabang in a ci zawkciang, Jesus in aw ngingtak taw, Lazarus, pusuak tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Taciang Lazarus hong pusuak a, a khut le a peang te mithi tunna puan taw ki tuam hi: taciang a mai zong dial no taw kituam hi. Jesus in amate tung ah, Sut vun a, paisak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tuazawkciang in Mary kungah hongpai Judah mi tampi te in, Jesus i vawt te a mu uh ciang in, Ama um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ahihang pawlkhat sia Pharisee te kungah pai uh a, Jesus i sep teng son uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tuazawkciang in thiampi lian te le Pharisee te thu kikum tu in ki kaikhawm uh a, bangba hi tu hi ziam? banghangziam cile hisia pa in nalamdang tampi vawt hi. ");
INSERT INTO csy_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Hibang in i en thong a hile, mi theampo in Ama um tu uh a: Rome mite in i mun le i ngam teng hong sut siat tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Taciang amate sung pan khat, Caiaphas a kici pa, ama sia tua kum ciang in thiampi sang hi a, note bangma he ngawl nu hi, ");
INSERT INTO csy_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Minam bup i lalcip ngawl natu in, mi khat mipi atu in thi le, eite atu in phazaw tu hi, ci zong ngaisun ngawl nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Taciang hi thu sia ama thu in a pau hi ngawl hi: ahihang tua kum atu in thiampi sang ahikom in, Jesus sia tua minam atu in a thi natu mailamthu sonkhol a hihi: ");
INSERT INTO csy_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Taciang hi minam atu bek hi ngawl in, ngam theampo ah a ki thethang Pathian tate a ki kaikhop natu thu zong a son a hihi. ");
INSERT INTO csy_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tua ni pan kipan in Ama bangbang in thatlum thei tu ci ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Tua ahikom Jesus sia Judah mite sungah a kilang in vak nawn ngawl a; senneal ngam nai khuano sang, Ephraim a kici khua sangah a nungzui te taw om uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judah mite paisanpoai hong nai zo hi: taciang mi tampi te khuano sang pan in Jerusalem ah paisanpoai ma, amate le amate ki thiansua tu in pai tek uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tuazawkciang in amate in Jesus zong uh a, biakinn sungah a dinkawm in kikum uh a, Jesus sia poai ah hongpai ngawl tu hi, bang na ngaisun uh ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tu in, mihing khatpo in Jesus sia koisung a om ziam, ci a he le a omna mun lak tu a, man tu in thiampi lian te le Pharisee te in thupia uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tuazawkciang in Jesus sia paisanpoai tu ni luk a kisap ciang in thina pan a thawkiksak Lazarus omna Bathany ah pai hi. ");
INSERT INTO csy_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tua mun ah amate in nitak an vak uh a; Martha in an huan hi: ahihang Lazarus sia Jesus taw sabuai kim ah a tote sungah kihel hi. ");
INSERT INTO csy_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tuazawkciang Mary in a manham mama sathau namtui thawlkhat la a, Jesus peang buak hi, taciang a sam taw Jesus peang nawlsak a: a innsung theampo sia tua sathau namtui ngim taw kidim hi. ");
INSERT INTO csy_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tuazawkciang in a nungzui te sung pan khat a hi, Ama a leheak tu pa, Simon tapa, Judas Iscariot in, ");
INSERT INTO csy_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Banghang in sathau namtui sia dangka zathum taw zuak in, mizawng te pia ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Hibang a pau na sia, mizawng te a awlmawk hang hi ngawl hi; ahihang ama sia nguta hi a, dangka bawm keam ahikom in, dangka bawm sung a kikoi dangka te dawk tawntung hi. ");
INSERT INTO csy_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tuazawkciang in Jesus in, Ama omsak po vun: keima ki vui ni atu kingingkhol in hi sathau namtui a keam a hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Banghangziam cile mizawng te note taw om tawntung tu uh hi; ahihang kei sia note taw om tawngtung ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tua ahikom Judah mi tampi te in Jesus sia tua mun ah om hi, ci he uh hi: taciang Jesus a mu nop uh hang bek hi ngawl in, thina pan a thawkiksak Lazarus zong mu nuam uh ahikom hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ahihang thiampi lian te in Lazarus zong that nuam in thu vaihawm uh hi; ");
INSERT INTO csy_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Banghangziam cile Judah mi tampi te Lazarus hang in pai uh a, Jesus um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","A zingciang in mi tampi te a poai ah hongpai uh a, Jesus Jerusalem ah hongpai hi, ci a zak uh ciang in, ");
INSERT INTO csy_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nuktu bak te la uh a, Jesus muak tu in pai uh hi, taciang in Hosanna: Topa min taw hongpai Israel kumpipa thuphatoai a hihi, ci in au kheukho uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Taciang Jesus in laa no khat a mu ciang in a tungah to a; ");
INSERT INTO csy_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tua thu sia, lau heak in, Zion tanu awng: en in, na kumpipa sia laa no tungah to in hongpai hi, ci in laithiangtho sungah ki atkhol hi. ");
INSERT INTO csy_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","A nungzui te in hi thu te a tel pai bua uh hi: ahihang Jesus min a than zawkciang in, hi thu te Ama thu a ki atkhol le Ama tungah a piang thu te hi, ci phawkkik uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tua ahikom Jesus in Lazarus sia thansung pan sam a, thina pan a thawkiksak ciang in Ama taw a omte in, tua thu tettipang uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Hi thu hang in mite in Jesus muak uh hi, banghangziam cile amate in hi nalamdang a vawt thu za uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Tua ahikom Pharisee te in, amate sungah, bangma zozo ngawl nu hi ci na he uh ziam? en vun, leitung bup in a nung zui siat zo hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tua poai sungah Pathian bia tu in hongpai te sungah Greek mite zong om hi: ");
INSERT INTO csy_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tua ahikom amate Galilee ngam Bethsaida khua mi Philip kungah hongpai uh a, Topa awng, Jesus ka mu nuam uh hi, ci in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip sia Andrew kungah pai in, son a: taciang Andrew le Philip in Jesus kungah son uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Taciang Jesus in amate tung ah, A Tapa a minthansak tu hun hong theng hi. ");
INSERT INTO csy_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A tatak in kong ci hi, zungtang sia leisung ah tak a a thi buale, ama bek hi top hi: ahihang a thi le, a tang tam mama hong piang hi. ");
INSERT INTO csy_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","A nuntakna a it peuma sum tu hi; taciang hi leitung ah a nuntakna a ensan peuma tawntung nuntakna dong in keamcing tu hi. ");
INSERT INTO csy_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mi khatpo in keima na a seam nuam le hongzui tahen; taciang keima omna mun ah ka naseam peuma om tu hi: mi khatpo in keima na a seam a hile, Pa in ama patoai tu hi. ");
INSERT INTO csy_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tu in ka thinngim hi; a bang son tu khi ziam? Pa awng, hi hun pan hong ngum tan: ahihang hisia atu in tu hun in hongpai ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pa awng, na minthangsak in, ci hi. Tuazawkciang in, keima in minthangsak zo khi hi, ci in van pan in aw khat hong theng hi. ");
INSERT INTO csy_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tua ahikom Jesus kiim ah a ding mihing te in, za uh a, vanto hi, ci uh hi: a dang te in, vantungmi in Ama paupui hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus in zo kik a, Hi aw sia keima hang hi ngawl hi, ahihang note atu hi zaw hi. ");
INSERT INTO csy_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Tu in hi leitung thukhenna hun a hihi: tu in leitung a ukpa sia puasang ah ki hawlkhia tu hi. ");
INSERT INTO csy_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Leitung pan in ka ki khai ciang in, mi theampo ka kungah ka kai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hibang a ci ciang in, bangbang thina taw thi tu, ci a pualak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mihonte in, Christ sia a tawntung in hong teang tu hi, ci thukham tungtawn in ka za uh hi: taciang nangsia bangbang in, mihing Tapa sia khai tu uh hi, ci ni ziam? hi mihing Tapa sia akua ziam? ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tuazawkciang in Jesus in amate tung ah, Note taw khuavak tawmvei sung omlai hi. Khuavak na nei uh lai in, tabang a hibale note tungah khuazing hong theng tu hi: banghangziam cile khuazing sungah a vak peuma in a paina mun a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Khuavak na nei uh lai in, khuavak sungah om vun, tabang in khuavak i tate na hi tu uh hi, ci hi. Jesus in hi thu te a son zawkciang in pusuak a, amate kung pan in kiheam hi. ");
INSERT INTO csy_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus in amate mai ah nalamdang tampi vawt zo napi, amate in Jesus a um bua lai uh hi: ");
INSERT INTO csy_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tua thu kamsang Isaiah in, Topa awng, ka thuson uh te a kua in um ziam? taciang a kua tungah Topa ban kilangsak ziam? a ci sia a tangtun natu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tua ahikom amate in a um thei bua uh hi, banghangziam cile Isaiah in, ");
INSERT INTO csy_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Pathian in amate i mitte tawsak a, a thinsung uh zong khauhsak hi; tabang in amate mitte taw mu ngawl tu uh a, a thinsung taw zong a he bua tu uh hi, tabang hibua thong le amate ki kheal tu uh a, ka damsak tu hi, ci in sonkik hi. ");
INSERT INTO csy_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Hi thu te sia Isaiah in, Pathian a minthanna a mu ciang in a son a hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hi kamale ngam uk ulian te sungah mi tampi in Jesus um uh a; ahihang Pharisee te hang in a pualak bua uh hi, pualak uh hile synagogue sung pan in hawlkhia tu hi: ");
INSERT INTO csy_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Banghangziam cile amate in Pathian i pokna sang in mihing te i pokna dei zaw uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesus hong au a, Keima hong um peuma in keima hong um hi ngawl in, hong sawlpa um uh hi. ");
INSERT INTO csy_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Taciang keima hong mu peuma in hong sawlpa a mu hi. ");
INSERT INTO csy_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A kuamapo keima hong um peuma, khuazing sungah om ngawl tu uh a, hi leitung ah keima sia khuavak in hongpai ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Khat po in ka thu te za a, a um bua ahile, ama sia thukhen ngawl khi hi: banghangziam cile leitung thukhen tu in hongpai ngawl khi hi, ahihang leitung ngum tu in hongpai ka hihi. ");
INSERT INTO csy_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Kei hong nial a, ka thu a sang ngawl te, thukhen tu nei uh hi: ka son thu in ni tawpkhak ni ciang ama thukhen tu hi. ");
INSERT INTO csy_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Banghangziam cile keima thu in pau ngawl khi hi; ahihang keima hong sawl Pa in ka pau tu le ka son tu thu hong pia hi. ");
INSERT INTO csy_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Taciang a thupiak te sia tawntung nuntakna hi, ci ka he hi: tua ahikom bangpo ka pau hial zong in, Pa i hong son bang in ka pau hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tu in paisanpoai mahiat, Jesus leitung pan pusuak a, Pa kung a pai tu hun hong theng zo hi, ci a heak ciang in, leitung ah a om a mite it a, a tawpdong in it hi. ");
INSERT INTO csy_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nitak an a neak zawk uh ciang in, Simon tapa Judah Iscariot thinsung ah doaimangpa in Jesus leheak tu thu koi hi; ");
INSERT INTO csy_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Pa in a khutsung ah na theampo pia siat zo hi, ci le Ama sia Pathian kung pan hongpai a, Pathian kungah paikik tu hi, ci Jesus in he ahikom; ");
INSERT INTO csy_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nitak an a neakna mun pan ding a, a puan te a sut zawkciang in; dial khat la a, a kawng ah vet hi. ");
INSERT INTO csy_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tuazawkciang in kuangdal sungah tui sung a, a nungzui te peang silsak hi, taciang, a kawng ah a ve dial taw nawlsak hi. ");
INSERT INTO csy_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simon Peter kung a thet ciang in, Peter in, Topa awng, nangma in ka peang hong silsak tu ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus in zo kik a, Ka vawt nate tu in na he bua hi; ahihang nungsang ciang in na he kik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter in, bangmahun in nangma in ka peang hong silsak ngei ngawl tu ni hi, ci hi. Jesus in, Na peang ka sil bua ahile, kei taw ki zopna na nei bua hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Peter in, Topa awng, ka peang bek hi ngawl in, ka khut te le ka lu zong hong sil tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus in, A kibual sa khat sia a peang sil tu simngawl a dang kul nawn ngawl hi, banghangziam cile a pum bup thiangtho zo hi: taciang note na thiangtho uh hi, ahihang na vekpi in na thiangtho bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Banghangziam cile Jesus in Ama a leheak tu sia hekhol hi; tua ahikom na vekpi in na thiang bua uh hi, a ci a hihi. ");
INSERT INTO csy_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tua ahikom Jesus in amate peang te a silsak zawkciang, a puan te silkik a, to kik hi, taciang amate tung ah, Note tungah ka vawt thu na he uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Note in, Syapa le Topa awng, ci in nong sam uh hi: nong ci uh sia pha hi; banghangziam cile nong sap uh bang in hi tatak khi hi. ");
INSERT INTO csy_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na Topa le Syapa, keima in na peang uh hong silsak ka hile; note zong khat le khat na peang uh na ki silsak tu uh a hihi. ");
INSERT INTO csy_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Banghangziam cile keima in note tungah ka vawt bang in, note in zong vawt tu in ette tu kong pia zo hi. ");
INSERT INTO csy_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A tatak in kong ci hi, sal sia a topa sang in lianzaw ngawl hi; a ki sawl khat zong a sawlpa sang in lianzaw ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Hi thu te na he uh a na vawt uh a hile, mi thuphatoai te na hi uh hi. ");
INSERT INTO csy_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na vekpi i thu hong son ka hi bua hi: ka tealsa te ka he hi: ahihang laithiangtho in, keima taw anluum a nekhawm pa in keima langpan in a siakmit lam zo hi, a ci thu a tangtun natu a hihi. ");
INSERT INTO csy_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tu in kong sonkhol hi, hi thu a pian ciang in, note in keima sia Ama hi, ci na um tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A tatak in kong ci hi, ka sawlpa a sang peuma in, keima hong sang hi; taciang keima hong sang peuma in keima hong sawlpa a sang a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus thu a son zawkciang in, a thinngim in om a, tettipang hi, taciang, A tatak in kong ci hi, note sung pan khat in hong leheak tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tuazawkciang in nungzui te in kua thu son ziam? ci in khat le khat ki muangmaw in ki en uh hi. ");
INSERT INTO csy_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tu in nungzui te sung pan khat, Jesus i a it pa in, Jesus kang neal hi. ");
INSERT INTO csy_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tua ahikom Simon Peter in tua pa khoiku a, a kua thu son ziam, ci dongsak hi. ");
INSERT INTO csy_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tuazawkciang in Jesus kang a neal pa in, Topa awng, a kua ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus in, Anluum ka bal sa sia ka dia zawkciang in ka piakpa sia hi, ci in zo hi. Taciang anluum a bal sa sia a dia zawkciang, Simon tapa Judah Iscariot pia hi. ");
INSERT INTO csy_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Anluum a piak zawkciang in, Judah Iscariot sungah Satan tum hi. Tuazawkciang in Jesus in Judah Iscariot tung ah, Na vawt tuteng manlang in vawt in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tu in Jesus in bang sawm in Judah Iscariot tungah thuson ziam, ci sia sabuai kim a to te kuama in a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Banghangziam cile Judah sia dangka bawm keampa ahikom in, nungzui pawlkhat te in, Jesus in poai atu in a kisam te leisak hi tu hi; a hibale, mizawng te bang khatpo piasak hi tu hi, ci in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judah in Jesus i piak anluum la a thakhat thu in pusuak hi: tua hun sia zan a hihi. ");
INSERT INTO csy_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tua ahikom, Judah a pusua zawkciang in, Jesus in, Tu in mihing Tapa sia ki minthangsak zo hi, taciang Pathian vangletna sia Ama sungah kilang tu hi. ");
INSERT INTO csy_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ama sungah Pathian minthanna a kilang le, Pathian in zong mihing Tapa minthanna sia Ama sung mama pan in kilangsak tu hi ");
INSERT INTO csy_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tano te awng, note taw hun tomno sung om lai tu khi hi. Judah mite tungah ka son bang in, note in nong zong tu uh hi, ka paina mun ah note hongpai thei ngawl nu hi; tua ahikom tu in kong son hi. ");
INSERT INTO csy_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Thupiak a thak kong pia hi, keima in note kong it bang in, note zong khat le khat ki it tavun. ");
INSERT INTO csy_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Khat le khat na ki it uh le, ngual in keima nungzui te na hi uh mi theampo in hong he tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter in, Topa awng, koisung pai tu ni ziam? ci hi. Jesus in, Ka pai na mun ah tu in hong zui thei ngawl lai ni hi; ahihang nungsang ciang in hong zui tu ni hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter in, Topa awng, banghang in tu in hong zui thei ngawl lai khi ziam? Nangma atu in ka nuntakna dong pia tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus in, Keima atu in na nuntakna pia tu ni ziam? A tatak in kong ci hi, thumvei nong nial mateng akkhuang ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na thin uh ngimsak heak vun: Pathian um vun a, keima zong hong um tavun. ");
INSERT INTO csy_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ka Pa innsung ah inndoi tam mama om hi: om ngawl hile, hong son zo tu khi hi. Note atu in mun puakhol tu in ka pai tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Taciang pai in note atu mun ka puakhol le, hongpai kik tu khi hi, taciang ka kungah kong sang tu hi; tabang in ka omna mun ah, note zong na om tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ka pai natu mun le lampi sia na he uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Thomas in, Topa awng, koisung pai tu ni ziam? ci ka he bua uh hi; taciang bangbang in lampi he thei tu khu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesus in, Keima in lampi, thutak le nuntakna ka hihi: keima taw ngawl in kuama Pa kung pai thei ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Keima nong he uh le, ka Pa zong na heak tu uh a hihi: taciang tu pan kipan in Ama na he uh hi, taciang na mu zo uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Philip in, Topa awng, Pa hong lak tan, tua in ka lung uh kimsak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus in, Note taw ngei mama hong omkhawm zo napi, hong he ngawl lai nu ziam, Philip awng? kei hong mu peuma in Pa a mu zo hi; banghang in Pa hong lak tan, hong ci ni ziam? ");
INSERT INTO csy_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pa sungah keima ka om hi, ci hong um ngawl ni ziam? nang tungah kong son te keima thu in kong son hi ngawl hi: ahihang ka sungah a om Pa i nasep a hihi. ");
INSERT INTO csy_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Keima sia Pa sungah ka om a, Pa sia keima sungah om hi ci sia hong um tavun: a hibale ka nasep te mama pan in hong um tavun. ");
INSERT INTO csy_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A tatak in kong ci hi, keima hong um peuma in keima vawt te ma vawt tu uh hi; taciang hi te sang in a lianzaw te zong vawt tu uh hi; banghangziam cile kei sia ka Pa kungah pai tu khi hi. ");
INSERT INTO csy_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Pa sia Tapa sungah a minthan thei natu in, ka min taw na nget uh theampo seam tu khi hi. ");
INSERT INTO csy_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ka min taw khatpo na ngen uh le, keima in ka seam tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nong it uh le ka thupiakte na zui vun, ");
INSERT INTO csy_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Taciang Pa kungah ka ngen tu a, Ama in a dang Hupa note hong pia tu hi, taciang note kungah a tawntung in hong om tu hi; ");
INSERT INTO csy_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ama sia thuman Thaa hi a; leitung mite in sang thei ngawl hi, banghangziam cile a mu ngawl uh hang a hihi, taciang he zong a he bua uh hi: ahihang note in Ama na he uh hi; banghangziam cile note kungah om a, note sungah hong om hi. ");
INSERT INTO csy_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Hupa nei ngawl in hong nu sia ngawl tu khi hi: note kungah kongpai tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Hai ngawl in leitung mite in hong mu nawn ngawl tu hi; ahihang note in nong mu tu uh hi: banghangziam cile keima ka nungta a, note zong na nungta tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tua ni ciang keima sia Pa sungah om khi hi, taciang note sia ka sungah na om uh hi, ci le note sungah keima ka om hi, ci sia na he tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ka thupiak te a nei le a zui peuma keima hong it a hihi: taciang keima hong it peuma ka Pa in zong it tu hi, taciang keima in zong ka it tu hi, taciang a kungah keima tatak ma ka kilak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iscariot hi ngawl Judas in, Topa awng, leitung mite kungah kilak ngawl in kote tungah nong kilak tu sia bangbang ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus in, Mi khatpo in keima hong it a hile ka kammal te zui tu hi: taciang ka Pa in ama it tu hi, taciang kote ama kungah ka pai tu uh a, ama taw ka omkhawm tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Kei hong it ngawl peuma ka son thu te a zui bua hi: taciang na zak uh thu sia keima thu hi ngawl hi, ahihang keima hong sawl Pa i son a hihi. ");
INSERT INTO csy_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Note taw ka omkhop lai in hi thu te hong son zo khi hi. ");
INSERT INTO csy_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ahihang Pa in keima min taw hong sawl tu Hupa Tha Thiangtho in, na theampo hong hil tu a, note kungah ka son theampo a vekpi in hong phawksak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Note taw thinnopna kong nusia hi, keima thinnopna kong pia hi: leitung i piak thinnopna bang in kong pia bua hi. Na thin uh ngimsak heak vun a, lau zong lau heak vun. ");
INSERT INTO csy_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ka pai tu a, note kungah kong paikik tu hi, kong ci na za zo uh hi. Nong it uh le, Pa kungah pai tu khi hi, ka ci thu na lung uh dam tu hi: banghangziam cile Pa sia kei sang in lianzaw hi. ");
INSERT INTO csy_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A pian tatak ciang na up thei natu uh in, tu in hi thu teng hong sonkhol zo khi hi. ");
INSERT INTO csy_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Note tungah thu tampi kong son nawn bua tu hi: banghangziam cile hi leitung a ukpa hongpai in, ka sungah bangma nei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ahihang keima in Pa ka it hi, ci leitung in a heak thei natu in, Pa i thupiak bang in ka vawt hi. Ding vun, hi mun pan pai tawng. ");
INSERT INTO csy_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Keima in sapit ngui tatak ka hihi, taciang ka Pa sia huan neipa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Keima sungah a nga ngawl a bak peuma sat siat hi, taciang nga a nga bak peuma tam seseam a nga thei natu in heu hi. ");
INSERT INTO csy_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tu in note tungah ka son thu tungtawn in note na thiang uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Keima sungah hong om tavun, taciang keima zong note sungah ka om tu hi. Sapit bak sia sapit ngui taw a kizom buale, ama thu in a nga thei ngawl bangma in; note zong keima sungah na om bua uh le, bangma na nga thei bua tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Keima sia sapit ngui ka hihi, note a bak te na hi uh hi: keima sungah om in, a sungah keima ka om a hile, nga tampi nga tu hi: banghangziam cile keima ngawl taw note bangma na seam thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Khat po in keima sungah a om bua ahile, a bak bangin ki vawk in, vuai tu hi; taciang mihing te in khawmtua in, meisung ah khia hi, taciang kang siat hi. ");
INSERT INTO csy_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Keima sungah na om uh a, ka thu te note sungah a omle, na deina uh na ngen tu uh a, taciang na nget uh bang in hong vawtsak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nga tampi na nga uh ciang in ka Pa minthanna kilang a; tabang in ka nungzui te na hi tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pa in keima hong it bangma in, kong it hi: ka itna sungah om tawntung vun. ");
INSERT INTO csy_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Keima in ka Pa thupiak te ka zui a, Ama itna sungah ka om bangma in, ka thupiak te na zui uh le, keima itna sungah na om tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Keima i lungdamna sia note sungah om a, note i lungdamna a dim thei natu in hi thu te kong son hi. ");
INSERT INTO csy_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Hisia in ka thupiak a hihi, keima in note kong it bang in, note khat le khat ki it tavun. ");
INSERT INTO csy_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mi khat in a lawmte atu a nuntakna a piak sang in, a lianzaw itna mihing in nei thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ka thupiak theampo na vawt uh a hile ka lawmte na hi tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tu pan kipan, sal te, kong ci nawn bua hi; banghangziam cile sal te in a topa bangvawt ci a he bua uh hi: ahihang keima in, lawm te, kong ci zo hi; banghangziam cile Pa kung pan in ka zak theampo kong hesak siat zo hi. ");
INSERT INTO csy_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Note in nong teal bua uh hi, ahihang keima in kong teal zo hi, taciang note pai in, nga na nga thei natu uh in nasep kong pia zo hi, taciang a ki khomsuan in na nga tu uh a: ka min taw Pa kungah na nget uh theampo Ama in hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Note khat le khat na ki it natu uh in hi thu te kong pia hi. ");
INSERT INTO csy_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Leitung in note hong ensan a hile, note mai ah keima hong ensan zo hi, ci he tavun. ");
INSERT INTO csy_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Leitung neisa hile uhte, leitung in ama neisa te it tu hi: ahihang note leitung i neisa na hi bua uh hi, ahihang leitung i neisa te sungpan in keima in kong teal zo hi, tua ahikom leitung in hong ensan hi. ");
INSERT INTO csy_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sal sia a topa sang in lianzaw ngawl hi, ci kong son sia phawk tawntung vun. Ama te in keima hong vawtsia a hile, note zong hong vawtsia tu hi; ka son te hong zui le, note i son te zong hong zui tu hi. ");
INSERT INTO csy_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ahihang hite theampo sia keima min hang in note tungah hong vawt tu uh hi, banghangziam cile amate in keima hong sawlpa a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Amate tungah hongpai ngawl in thu son bua leng, amate mawna nei ngawl zaw tu hi: ahihang tu in amate mawna atu in paulap a nei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Kei hong ensan sia in ka Pa zong ensan a hihi. ");
INSERT INTO csy_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Amate sungah kuama i vawt ngei ngawl nate vawt ngawl in om kana leng, amate mawnei ngawl zaw tu uh hi: ahihang tu in amate in mu zo uh a, keima le ka Pa hong ensan uh hi. ");
INSERT INTO csy_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ahihang hi thu teng a pian thei na sia, amate thukham sungah a ki atkhol, bangma thu om ngawl in hong ensan hi, ci thu a tangtunna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ahihang Pa kung pan in note kungah ka sawl tu Hupa, Pa kungpan hongpai thutak Thaa hong thet ciang in, Ama in keima thu tettipang tu hi: ");
INSERT INTO csy_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Taciang note zong tetti na pang tu uh hi, banghangziam cile a kipat pan kipan keima taw na om zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Note na thinkiam ngawl natu in hi thu te kong son hi. ");
INSERT INTO csy_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Amate in synagogue sung pan hong nawt tu uh hi: a kuamapo in note thalup sia Pathian nasep in a ngaisut uh hun hong theng tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hi thu te sia amate in note tungah vawt tu uh hi, banghangziam cile amate in Pa a he bua uh a, keima zong hong he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ahihang hi thu te kong son zo hi, tabang in a hun a cin ciang in, note in kong sonsa te na phawkkik tu uh hi. Taciang hi thu te sia a kipatcil in hong son ngawl khi hi, banghangziam cile keima sia note taw ka omkhop hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ahihang tu in hong sawlpa kungah pai tu khi hi; taciang, koisung ah paitu ni ziam? ci in kuama in nong dong bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ahihang hi thu te hong son zo ka hikom in, na thinsung uh hena taw kidim hi. ");
INSERT INTO csy_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ahihang thutak hong son khi hi; kei pai leng note atu in phazaw hi: banghangziam cile ka pai bua ahile, Hupa sia note kungah hongpai ngawl tu hi; ahihang ka pai ahile, Ama sia note kungah kong paisak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ama hongpai ciang in leitung mite mawna, thuman ngawlna le thukhenna te hong tek tu hi: ");
INSERT INTO csy_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mawna thu sia, amate in keima hong up ngawl uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Thuman sia, Pa kung ka pai tu a, nong mu nawn ngawl tu uh hang a hihi; ");
INSERT INTO csy_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Thukhenna thu sia, leitung ukpa sia thukhenna a thuak hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Note tungah sonnop tampi nei lai khi hi, ahihang tu in na ngai zo nawn bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ahizong thuman Thaa hongpai ciang in, Ama in thutak sungah note hong paipui tu hi: banghangziam cile Ama thu hong son ngawl tu a; a zak theampo hong son tu hi: taciang hongpai lai tu thu te hong son tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ama in hong minthangsak tu hi: banghangziam cile Ama in ka kung pan a sansa thu te hong lak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pa i neisa theampo sia keima neisa a hihi: tua ahikom, keima neisa hong laksak tu te, note hong lak tu hi, kong ci hi. ");
INSERT INTO csy_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Tawmvei sung hong mu ngawl tu nu ni: taciang tawmvei sung in nong mukik tu uh hi, banghangziam cile Pa kungah ka pai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Tuazawkciang in a nungzui pawlkhat te, amate sungah, tawmvei sung nong mu bua tu uh hi: taciang tawmvei sung in nong mukik tu uh hi, banghangziam cile Pa kungah ka pai tu hi, hong ci sia bang hi thong tu ziam? ci tek uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Tua ahikom amate in, tawmvei sung, a ci sia bang hi tu ziam? bang hong son ziam ci i son thei bua hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tu in Jesus in amate in thu hong dong nuam hi, ci he a, Tawmvei sung nong mu bua tu uh hi: taciang tawmvei sung in nong mukik tu uh hi, ci ka son sia note sungah ki kan na hi uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A tatak in kong ci hi, note kap in na tau tu uh hi, ahihang leitung mite lungdam tu uh hi: note na khuangai tu uh hi, ahihang na khuangaina uh sia lungdamna hong suak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nupi khat nau a tut ciang in khuangai hi, banghangziam cile a hun hong cing zo hi: ahihang nau a nei zawkpo ciang, leitung ah mihing khat pianna i lungdamna hang in a haksatna a phawk nawn bua hi. ");
INSERT INTO csy_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tua ahikom note tu in na khuangai uh hi: ahihang hong mu kik tu khi hi, taciang note na lung uh dam tu hi, taciang na lungdamna uh sia mihing in hong laksak ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tua ni ciang in note bangma nong ngen bua tu uh hi. A tatak in kong ci hi, ka min taw Pa kungah na nget uh theampo Ama in hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tuciang dong ka min taw bangma na ngen bua lai uh hi: ngen vun, na nga tu uh hi, tabang in na lungdamna uh hong dim tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Hi thu te sontena taw note tungah kong son hi: ahihang sontena te taw kong son ngawl hun hong theng zo hi, ahihang Pa sia a thiangtak in kong lak tu hi. ");
INSERT INTO csy_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tua ni ciang in note in ka min taw nong ngen tu uh hi: taciang, Pa kungah kong ngetsak tu hi, kong ci bua hi: ");
INSERT INTO csy_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Banghangziam cile Pa ama vateak ma in hong it hi, Pathian kung pan hongpai khi hi, ci na um zo uh hi, banghangziam cile nong it uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pa kung pan kongpai a, leitung ah hong theng khi hi: leitung ka nusia tu a, Pa kungah ka paikik tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","A nungzui te in ama kungah, en in, tu in sontena zang ngawl in a thiangtak in nong son hi. ");
INSERT INTO csy_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Tu in nangma in na theampo na he hi, taciang kuama in thu hong dok kul ngawl hi, ci ka he uh hi: hi thu hang in nangma sia Pathian kung pan hongpai na hihi, ci ka um uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus in amate tung ah, Tu in na um uh ziam? ");
INSERT INTO csy_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","En vun, a hun hong theng tu hi, tu in hong theng zo hi, tabang in na vekpi in noma omna mun tek ah na ki thethang siat tu uh hi, taciang keima bek nong nusia tu uh hi: ahihang keima bek hi ngawl khi hi, banghangziam cile Pa sia keima taw hong om hi. ");
INSERT INTO csy_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Keima sungah thinnopna na nei thei natu uh in, hi thu te kong son hi. Hi leitung ah haksatna nei tu nu hi: ahihang thinnuam in om vun, keima in leitung ka zo zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus in hi thu teng a son zawkciang in, vantung ento a, Pa awng, a hun cing zo hi; na Tapa minthangsak in, tabang in na Tapa in zong nangma min hong thangsak tu hi: ");
INSERT INTO csy_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tapa tungah na piak theampo, Ama in tawntung nuntakna pia tu in mihing theampo tungah thuneina na pia zo hi. ");
INSERT INTO csy_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amate in nangma bek a thuman Pathian hi, ci le na sawlkhiat Jesus Christ heak sia tawntung nuntakna hi. ");
INSERT INTO csy_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Leitung ah na min ka thangsak zo hi: vawt tu in nong piak nasep ka seam zo hi. ");
INSERT INTO csy_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pa awng, tu in, leitung om ma in nangma taw ka neisa minthanna taw hong minthangsak tan. ");
INSERT INTO csy_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Leitung mite sung pan nong piak mihing te tungah na min kilangsak zo khi hi: amate sia nangma a, a hi uh a, keima nong piak te a hi uh hi; taciang amate in na thu zui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Tu in, nangma in nong piak theampo te sia nangma tung pan hi, ci amate in he zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Banghangziam cile nangma in nong piak thu te amate ka pia zo hi; taciang amate in hong sang zo uh hi, taciang na kung pan in ka pusuak hi, ci le nangma in nong sawl hi, ci amate in um zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amate atu in thu kong ngen hi: leitung mite atu in kong ngen bua hi, ahihang nangma i nong piak te atu thu kong ngen hi; banghangziam cile amate sia nangma a, a hihi. ");
INSERT INTO csy_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ka nei theampo nangma a, hi a, na nei theampo keima a, a hihi; taciang amate sungah keima min a thang hi. ");
INSERT INTO csy_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tu in keima sia leitung ah om nawn ngawl tu khi hi, ahihang hi te leitung ah om lai tu uh hi, taciang keima na kungah hongpai tu khi hi. A Thiangtho ka Pa awng, kei tungah nong piak sate, eite bang in pumkhat a hi thei natu in, na min suang in na keamcing in. ");
INSERT INTO csy_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Amate kung leitung ah ka omlai in, amate na min taw ka keamcing hi: nangma i nong piak te, laithiangtho tangtungsak siatna i tapa simngawl; khatzong bosua ngawl in ka keamcing zo hi. ");
INSERT INTO csy_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Tu in na kungah kongpai tu hi; ka lungdamna mate sungah a kicin thei natu in, hi thu te leitung ah ka son hi. ");
INSERT INTO csy_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Amate na thu ka pia zo hi; taciang leitung mite in amate ensan uh hi, banghangziam cile keima sia leitung mi ka hi ngawl bangma in amate zong a hi bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amate leitung pan lato tu in kong ngen bua hi, ahihang mihing phangawl pa kung pan keamcing tu in kong ngen hi. ");
INSERT INTO csy_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Keima sia leitung mi ka hi ngawl bangma in, amate zong leitung mi a hi bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amate na thutak taw in thiangthosak in: na kammal sia thutak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Keima leitung ah nong sawl bang in, amate zong keima in leitung ah ka sawl hi. ");
INSERT INTO csy_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Amate thutak taw in thianthosak ahi thei natu in, amate hang in keima le keima ka ki thiangthosak hi. ");
INSERT INTO csy_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Amate atu bek thu kong ngen bua hi, ahihang amate thuhilna taw in keima hong umte atu zong thu kong ngen hi; ");
INSERT INTO csy_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nangma in nong sawl hi, ci leitung mite in a up thei natu uh ahizong, amate theampo pumkhat hi tu in, ka Pa awng, nangma sia keima sungah na om a, keima zong nangma sungah ka om bangma in, amate zong i sungah pumkhat a hi tu in, thu kong ngen hi. ");
INSERT INTO csy_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nangma le keima sia pumkhat i hi bangma in amate zong pumkhat a sua thei natu in, nangma i nong piak minthanna amate ka pia zo hi: ");
INSERT INTO csy_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Amate pumkhat sungah a cialcing thei natu in, keima sia amate sungah ka om a, taciang nangma ka sungah na om hi; taciang nangma in nong sawl a, keima nong it bangma in amate zong na it hi, ci leitung mite in he tu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Pa awng, nangma in nong piaksa te ka omna mun ah om tu in le; nangma in nong piak ka minthanna amate in zong a mu thei natu ka dei hi: banghangziam cile nangma in leitung a ki bitphua ma in nong it zo hi. ");
INSERT INTO csy_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maw a thuman ka Pa, leitung mite in hong he ngawl hi: ahihang keima in kong he zo hi, taciang hite in zong nangma in nong sawl hi, ci a he zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Amate tungah na min ka tangko zo a, taciang tangko lai tu khi hi: tabang in nangma in keima nong itna amate sungah om tu a, taciang keima zong amate sungah ka om tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hi thu te a son zawkciang in, Jesus a nungzui te taw Kidron lui ngalkhat ah pai uh hi, tua mun ah huan khat om a, tua huan sungah nungzui te taw tum khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesus a leheakpa Judas zong in tua mun he hi: banghangziam cile Jesus a nungzui te taw tua mun ah pai bul uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas in thiampi lian te le Pharisee te kung pan in, mi pawlkhat le palik te taw tua mun ah mei-inn, meisip te le ngal van te taw hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus in a tungah a theng tu thu theampo hekhol zo ahikom, a mai ah pai in amate tung ah, Kua zong nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Amate in, Nazareth khua mi Jesus, ci uh hi. Jesus in, Keima khi hi, ci hi. Ama a leheakpa Judas zong amate taw ding hi. ");
INSERT INTO csy_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesus in amate tung ah, keima khi hi, a ci po ciang, a nungsang uh ah thalpu siat uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tuazawkciang in Jesus in amate tung ah, Kua zong nu ziam? ci in dong kik hi. Amate in, Nazareth mi Jesus, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus in, Keima khi hi, kong ci zo hi: tua ahikom keima nong zong uh ahile, hi teng paisak in, ci in zo hi: ");
INSERT INTO csy_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tabang in, nangma i nong piak te khat zong kisiasak ngawl khi hi, a ci sia a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tuazawkciang in Simon Peter in, a namsau dok a, thiampi lian i naseampa sat hi, taciang a ziatsang bil tawng pai hi. Tua naseampa min sia Malchus a hihi. ");
INSERT INTO csy_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus in Peter kungah, Na namsau a paisung ah thunkik in: ka Pa i hongpiak hai sia dawn ngawl tu khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tuazawkciang in mihon, ngalkapmang le palik te in Jesus man in, hencip uh a, ");
INSERT INTO csy_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Amasabel in Annas kungah paipui uh hi; banghangziam cile ama sia Caiaphas zi i pa a hihi, tua kum in thiampi sang sia Caiaphas a hihi. ");
INSERT INTO csy_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Tu in Caiaphas sia, mipi atu in mi khat thi le phazaw hi, ci in Judah mite tungah ngaisutna a pia pa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Peter le a dang nungzui khat in, Jesus zui uh hi: tua a dang nungzui pa sia thiampi sang in he hi, taciang Jesus taw thiampi sang pa leitual ah tum hi. ");
INSERT INTO csy_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ahihang Peter sia kongkha hui a puasang ah ding hi. Tuazawkciang in thiampi sang pa i heak adang nungzui pa in, kongkha cing nu paupui a, Peter sia a sungah tumpui hi. ");
INSERT INTO csy_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kongkha cing naseam numei nu in, Peter kungah, nangma zong hisia pa i nungzui te sungah khat hi ngawl ni ziam? ci hi. Peter in, hi ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Khuasik ahikom, naseam te le palik te in meihol thut uh a; ding kawm in mei oai tek uh hi: taciang Peter zong amate taw ding a, mei oai khawm hi. ");
INSERT INTO csy_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Thiampi sang in Jesus sia a nungzui te thu le a thuhil nate dong hi. ");
INSERT INTO csy_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus in, Leitung mite tungah a kilang in thu ka hil hi; Judah mite i pai tawntung na mun, synagogue le biakinn sungah zong thuhil khi hi; taciang a thimtham in bangma son ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Banghang in keima hong dong ni ziam? amate tungah ka thuhil a zate dong in: en in, amate in ka thuhil te he uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jesus in hibang in a son zawkciang in, a kungah a ding palik te sung pan khat in Jesus a khut zapheak taw beang a, thiampi sang tabang in zo ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus in A phangawl ka pau a hile, a phatngawlna tetti hong lak tan: ahihang ka pau na a pha a hile, banghang in hong vua ni ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tu in Annas in Jesus sia a ki hencip sa ma in Caiaphas kungah puak hi. ");
INSERT INTO csy_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Taciang Simon Peter ding in mei oai hi. Tua ahikom amate in a kungah, nangma zong a nungzui te sungah khat hi ngawl ni ziam? ci hi. Peter in hi ngawl khi hi, ci nial hi. ");
INSERT INTO csy_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Thiampi sang i naseam te sung pan khat, Peter in a bil a satsak pa i mealheak khat in, Jesus taw huan sungah hong mu hi ngawl khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter in nial kik leleau hi: tasia pociang akkhuang hi. ");
INSERT INTO csy_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Zingtung in Jesus sia Caiaphas kung pan in Pilate inn ah paipui uh hi: amate a thiangtho in paisanpoai an a neak nop uh hu in, Pilate innsung ah a tum bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilate sia amate kungah hong pusuak a, hisia pa mawsakna thu bang keng nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Amate in, ama naphangawl seam hi bale, na kungah hong ap ngawl tu khu hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tuazawkciang in Pilate in amate tung ah, Ama paipui vun a, noma ngeina bang in thukhen vun, ci hi. Tua ahikom Judah mite in a kungah, kote atu in mi khatpo thalup tu ngeina om ngawl hi, ci uh hi: ");
INSERT INTO csy_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesus in bangbang thina taw thi tu, ci a sonkholsa a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate a innsung ah tumkik hi, taciang Jesus sam a, nangma sia Judah te kumpi na hi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus in, Hi thu sia nangma thu in na pau ziam, a hibale keima thu ngualdang in hong son ziam?, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate in zo kik a, keima sia Judah mi khi ziam? Nangma minam le thiampi lian te in nangma ka kungah hong ap uh hi: bang sep nei ni ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus in, Keima kumpingam sia hi leitung ah hi ngawl hi: ka kumpingam sia hileitung hile, Judah te khut ah hong ap ngawl natu in na naseam te in do tu uh hi: ahihang ka kumpingam sia himun hi ngawl hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tua ahikom Pilate in, tabang ahile Nangma sia kumpi na hi ziam? ci hi. Jesus in, Keima sia kumpi ka hihi, nangma in hong ci ni hi. Thuman tettipang tu in ka piang a, hi leitung ah kongpai hi. Thuman taw a kizom peuma in ka aw a za uh hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate in, thuman sia bang ziam? ci a, a pau zawkciang in, Judah mite kungah paikik hi, taciang amate tung ah, a mawna mu ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ahihang na ngeina uh bang in, paisanpoai ah mi khat note atu ka suatak kul hi: tua ahikom Judah te Kumpipa note atu ka suatak tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Amate in, hisia pa suatak heak in, Barabbas suatak zaw in, ci in a vekpi in au kik uh hi. Barabbas sia ngual suam pa a hihi. ");
INSERT INTO csy_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Tua ahikom Pilate in Jesus paipui a, sat hi. ");
INSERT INTO csy_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ngalkap te in ling taw kumpi lukhut khat pheak in, a lu tungah khusak uh a, puan sannum silsak uh hi, ");
INSERT INTO csy_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Taciang Judah te Kumpi! na khan sau tahen, ci uh a, amate in a khut uh taw beang uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tua ahikom, Pilate pusuak kik a, amate tung ah, en vun, a mawna mu ngawl khi hi, ci na heak natu uh in, note kungah hong pusua khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tuazawkciang in, Jesus ling lukhu khu a, puan sannum sil in hong pusuak hi. Taciang Pilate in amate tung ah, Ama en vun! ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Thiampi lian te le palik te in a mu uh ciang in, thinglamte tungah khai in, thinglamte tungah khai in, ci au uh hi. Pilate in amate tung ah, paipui tavun a, thinglamte tungah khai vun: banghangziam cile a mawna bangma ka mu bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Judah mite in, ngeina nei khu hi, ka ngeina bang hile a thi tu in kilawm hi, banghangziam cile ama le ama Pathian Tapa in ki vawt hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tua ahikom Pilate in tua thu a zak ciang in, lau seseam hi; ");
INSERT INTO csy_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Taciang a innsung ah tum kik a, Jesus kungah, koisung pan ni ziam? ci hi. Ahihang Jesus in zo ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tuazawkciang in Pilate in ama kungah, hong paupui ngawl tu ni ziam? nangma thinglamte tungah khai tu le suatak natu thuneina nei khi hi, ci he ngawl ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus in, Tungsang pan a ki pia thu simngawl, keima langpan in thuneina na nei thei bua tu hi: tua ahikom na kungah keima hong ap sia in a lianzaw mawna nei hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Tasia pan kipan in Pilate in Jesus suatak thei natu zong hi: ahihang Judah mite in, hisia pa na suatak le, Caesar i lawm hi thei ngawl tu ni hi: a kuama po in ama le ama kumpi in a kivawt peuma Caesar langpan in kampau a hihi, ci au kheukho uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tua ahikom Pilate in tua a kampau a zak ciang in, Jesus pusua a, suangpheak kipha a kici na, thukhen tokhum tungah to hi, tasia sia Hebrew kam in, Gabbatha, kici hi. ");
INSERT INTO csy_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tua hun sia paisanpoai atu in kingin ni hi a, nai sawm le nai ni kiim a hihi: taciang ama in Judah mite tung ah, en vun, na Kumpipa uh! ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ahihang amate in, ama khai in, ama khai in, thinglamte tungah that in, ci in au lialua uh hi. Pilate in amate tung ah, na Kumpipa uh thinglamte tungah khai tu khi ziam? ci hi. Thiampi lian te in, kote in Caesar simngawl kumpi dang nei ngawl khu hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Tuazawkciang in Pilate in Jesus sia thinglamte tungah khai tu in amate tungah ap hi. Taciang amate in Jesus la uh a, paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Taciang a thinglamte pua in lungu mun, a kici na mun ah paipui uh hi, tua mun sia Hebrew kam in Golgotha kici hi: ");
INSERT INTO csy_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Tua mun ah amate in Jesus sia thinglamte tungah khai uh hi, taciang midang ni te zong a ziat le vei ah khai uh a, Jesus sia a lai ah khai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilate in lai at a, thinglamte tungah tak hi, Tua a lai at sia, nazareth khuami jesus, judah te kumpi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hi lai ki at sia Judah mi tampi in sim uh hi: banghangziam cile Jesus thinglamte tung a khai na mun sia khuapi nai na a hihi: taciang tua lai sia Hebrew, Greek le Latin taw in ki at hi. ");
INSERT INTO csy_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Judah mite thiampi lian te in Pilate tung ah, Judah mite Kumpipa, ci in at heak in; ahihang, keima sia Judah mite i Kumpipa ka hihi, ci hi, ci in at zaw in, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate in, ka at sa sia, ka at sa hi tahen, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ngalkap te in Jesus sia thinglamte tungah a khai zawk uh ciang in, a puan sil sia khen li in khen uh a, ngalkap khat in khen khat tek la uh hi; taciang a laktong zong laksak uh hi: tua a laktong sia a zung ki khui ngawl hi a, a tung pan a nuai dong a ki tak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Tua ahikom amate sungah, hisia eau tham bua tawng, ahihang kua in i nga ziam, aisan tawng, ci uh hi: hi thu sia, amate in ka puan te hawm uh a, ka laktong atu in aisan uh hi, ci laithiangtho sungah a ki atkholsa a tangtun natu a hihi. Tua ahikom hi thu te ngalkap te in seam uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tu in Jesus thinglamte kungah a nu le a nu i nau nu, Cleopas i zi Mary le Mary Magdalene te ding uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tua ahikom Jesus in a nu le a it mama a nungzui pa a ding a mu ciang, a nu kungah, Numei awng, na tapa en in! ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tuazawkciang in a nungzui pa kungah, Na nu en in! ci hi. Tua hun pan kipan tua nungzuipa in a nu sia ama inn ah ciapui hi. ");
INSERT INTO csy_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Hi teng zawkciang in Jesus in, tu in na theampo khuagkhim zo hi, ci he a, laithiangtho a tangtun natu in, Ka dangtak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tua mun ah sapittui thuk taw a dim beal khat om hi: taciang tuihup puan khat sapittui thuk sungah pap suk a, hyssop baak dawn ah a koi zawkciang, Jesus kam ah taa hi. ");
INSERT INTO csy_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tua ahikom Jesus in sapittui thuk sia a san zawkciang in, A zo zo hi, ci a: taciang a lu kun in thi hi. ");
INSERT INTO csy_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Tua ni sia kingin ni hi a, zingciang sabbath ni zong ni thupi ahikom in, thiluang te thinglamte tungah om ngawl tu in, a peang te thiaktan tu a, thiluang te la siat tu in, Judah mite in Pilate kungah ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Tua ahikom ngalkap te hongpai uh a, Jesus taw thinglamte tungah a ki khai khat sia i peang thiaktan a, taciang a dang khat sia i peang zong thiaktan uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ahihang Jesus kungah hongpai ciang in, thi zo hi, ci a mu uh ciang a peang thiatansak ngawl uh hi: ");
INSERT INTO csy_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ahizong ngalkap te sungpan khat in Jesus pang pan in teipi taw sun a, thakhatthu in thi le tui hong pusuak hi. ");
INSERT INTO csy_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hi thu a mu pa in tettipang hi, taciang tettipanna sia a man hi: na up thei natu uh in, a son thu man hi, ci a he uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Hibang thu te a vawt na sia, a ngu khat zong ki thiaktan ngawl hi, ci laithiangtho a tangtun na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","A dang laithiangtho in a son kikna ah, amate in a sut pa en tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Hisia zawkciang in, Judah mite a lau uh hu in a thimtham in Jesus nung a zui, Arithmathaea khua mi Joseph in Pilate kungah Jesus luanghawm la tu in ngen a: Pilate in pia hi. Tua ahikom Joseph in Jesus luang la hi. ");
INSERT INTO csy_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jesus kungah zan lai in a pai ngei Nicodemus sia myrrh le aloe a kihel, pong zakhat keng in hongpai hi. ");
INSERT INTO csy_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Amate in Jesus luang la a, Judah te mithi vui ngeina bang in, ngim namtui le puan neamno taw tun uh hi. ");
INSERT INTO csy_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesus thinglamte tung a khai na mun ah huan khat om a; tua huan sungah kuama a ki vui ngei ngawl lai na mun than thak khat om hi. ");
INSERT INTO csy_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Judah mite kingin ni ahikom in Jesus sia tua than ah vui uh hi; banghangziam cile tua than sia a nai na ah om hi. ");
INSERT INTO csy_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nipi kalkhat sung ni masabel ni zingtung khuavak ma, Mary Magdalene sia than ah pai a, suangtum sia than pan a ki khin sa in mu hi. ");
INSERT INTO csy_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Tuazawkciang in Mary Magdalene tai a, Simon Peter le Jesus i it mama a dang nungzui pa kungah pai hi, taciang amate tung ah, Topa sia mite in than pan in la zo uh hi, taciang a koina mun ka he bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Tua ahikom Peter le a dang nungzui pa sia, than ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A ni in tai khawm uh hi: taciang a dang nungzui pa in Peter suangkhial a, than theng masa hi. ");
INSERT INTO csy_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Taciang kun a, a sung a et ciang in, puan neamno mu napi, a sungah tum ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","A nung pan in Simon Peter in zui a, than sungah tum hi, taciang puan neamno sia mu hi, ");
INSERT INTO csy_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesus lu tuam na dial zong mu a, puan neamno taw munkhat a omkhawm ngawl hi, ahihang a tuam veve in a kizial sa in om hi. ");
INSERT INTO csy_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tuazawkciang in than a theng masa a dang nungzui khat sia zong a sungah tum hi, taciang mu a, um hi. ");
INSERT INTO csy_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Banghangziam cile, thina pan thokik tu hi, ci laithiangtho sia amate in a heak ngawl lai uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tuazawkciang in nungzui te amate inn tek ah ciakik uh hi. ");
INSERT INTO csy_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ahihang Mary sia than puasang ah ding in kap hi: taciang a kap kawm in kun a, than sung en hi, ");
INSERT INTO csy_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Taciang vantungmi ni puanpak sil a, Jesus luang kisial na mun a luthung ah khat, a khawdop ah khat, a to mu hi. ");
INSERT INTO csy_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Vantungmi te in, numei awng, banghang in kap ni ziam? ci hi. Mary in, ka Topa hong laksak zo uh a, a koi na mun he ngawl ka hikom kap khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tabang a pau zawkciang in, Mary in a nungsang le-et a, Jesus a ding mu hi, taciang Jesus ahi hunlam a he bua hi. ");
INSERT INTO csy_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus in ama tung ah, Numei awng, banghang in kap ni ziam? kua zong ni ziam? ci hi. Mary in huancing pa sa a, ama tung ah, Topa awng, nangma in la na hile na koina hong son tan, taciang keima in ka la tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus in ama tung ah, Mary, ci hi. Mary zong Jesus sangah kihei a, Rabboni, ci hi; Rabboni a ci sia, Syapa awng, a ci na a hihi. ");
INSERT INTO csy_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus in Mary kungah, Hong tham heak in; banghangziam cile ka Pa kungah kato ngawl lai khi hi: ahihang ka suapui te kungah pai tan a, na Pa uh le ka Pa kungah kato tu khi hi; keima i Pathian le note i Pathian zong a hihi, ci in son in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mary Magdalene pai in, Topa mu zo khi hi, taciang hi thu te zong hong son hi, ci in a nungzui te kungah son hi. ");
INSERT INTO csy_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nipi khat sung ni masabel ni, nitak sang in, nungzui te Judah mite a lau uh hu in, innkha te khak siat in, a kikhop uh laitak, Jesus hongpai a, amate laizang ah hong ding hi, taciangNote tungah thinnopna om tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tabang in a paupui zawkciang, Jesus in a khut te le a pang amate lak hi. Tuazawkciang in a nungzui te in Topa a mu uh ciang in angtang mama uh hi. ");
INSERT INTO csy_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tuazawkciang in Jesus in amate tung ah, Note tungah thinnopna om tahen: ka Pa in keima hong sawl bang in, keima in note kong sawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hi thu a son zawkciang in, amate tungah mut a, Tha Thiangtho sang tavun. ");
INSERT INTO csy_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ngual dang mawna te na maisak uh le, mai tu a, na maisak bua uh le, mai ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ahihang nungzui sawm le ni te sung pan khat, Didymus a kici Thomas sia, Jesus hongpai laitak in amate taw om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Tua ahikom nungzui dang te in, Topa ka mu zo uh hi, ci uh hi. Ahihang Thomas in amate tung ah, a khut te thikpim taw a kikhet na mapawn mu ngawl in, thikpim mapawn ah ka khutme ka tham bua a hile, taciang a pang sungah ka khut ka thun bua a hile, um ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ni liat zawkciang in nungzui te innsung ah om tek uh a, Thomas zong amate taw om hi: taciang innkha te a kha siat uh hi napi, Jesus hongpai a, amate laizang ah ding in, Note tungah thinnopna om tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tuazawkciang in Thomas kungah, Na khutme taw tham in a, ka khut te en in; na khut ka pang sungah thun in: taciang um ngawl om heak in, um in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Taciang Thomas in, ka Topa le ka Pathian, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus in ama kungah, Thomas awng, nang in nong mu hang in, hong um ni hi: mu ngawl napi a, a umte thuphatoai a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hi laibu sungah a ki at ngawl, musakna a dang tam mama, Jesus in a nungzui te mai ah vawt hi: ");
INSERT INTO csy_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ahihang note in Jesus sia Pathian Tapa, Christ hi, ci na um uh a; tua na upna uh hang in a min tungtawn in nuntakna na nga thei natu uh in, hi thu te a ki at a hihi. ");
INSERT INTO csy_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Hiteng zawkciang in Jesus sia a nungzui te kung Taiberias tuili hui ah kilaakkik hi; taciang a kilaak dan sia hibang a hihi. ");
INSERT INTO csy_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Peter le Didymus kici Thomas, Galilee ngam Cana khuami Nathanael, Zebedee tapa te le a dang nungzui ni te zong om uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter in amate tung ah, kei ngasa man ka pai tu hi, ci hi. Amate in ko zong nangma taw pai tu khu hi, ci uh hi. Amate pai vingveng in ngunkuang sungah tuak uh hi; taciang tua zan in bangma a man bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Zingsang ciang in Jesus sia tui hui ah ding hi: ahihang a nungzui te in Jesus a hi hunlam a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesus in, Tano te awng, neakpha khatpo nei ngawl nu ziam? ci hi. Amate in, nei ngawl khu hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesus in amate tung ah, Na ngunkuang ziatsang ah na ngen pai vun a, mu tu nu hi, ci hi. Tua ahikom amate zong paai uh a, ngasa tampitak awk ahikom in a ngen uh zong kai zo ngawl liang uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Tua ahikom Jesus i a it mama nungzui pa in, Peter kungah, Topa hi, ci hi. Simon Peter in Topa hi, ci a zak ciang in, ngasa matna laktong sia vet in, tuisung ah leangsuk hi, banghangziam cile ama a pumnguak a hihi. ");
INSERT INTO csy_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Adang nungzui te ngunkuang no taw hongpai uh a; ngasa taw a dim ngen kai uh hi. Banghangziam cile amate sia tui hui pan in khuala ngawl hi, tong za ni kiim khawng bekma khuala hi. ");
INSERT INTO csy_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Amate tui hui ah a thet po uh ciang, meihol a ki seam meitung ah, ngasa le anluum a ki em mu uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus in amate tung ah, Tu in na mat uh ngasa hiak ah hong paipui tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter hong kato a, ngasa lian mama za le sawm nga le thum taw a dim ngen tui hui ah kai uh hi: tabang in ngasa tam mama hi napi, a ngen uh tat ngawl hi. ");
INSERT INTO csy_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus in amate tung ah, Hongpai tavun a, ne vun, ci hi. Nungzui te in, Topa hi, ci he napi, kuama in, Kua ni ziam? ci a dong ngam bua uh hi. ");
INSERT INTO csy_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesus hongpai a, anluum la in amate pia hi, tabangma in ngasa zong la a amate pia hi. ");
INSERT INTO csy_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Hi thu sia Jesus thina pan a thawkik zawk, nungzui te kungah a thum veina a kilaakna a hihi. ");
INSERT INTO csy_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Amate an a neak zawk uh ciang in Jesus in, Simon Peter kungah, Jonah tapa, Simon awng, hi te sang in nong it zaw ziam? ci hi. Simon Peter in, hi hi, Topa awng; hong it khi hi, ci nangma in na he hi, ci hi. Jesus in, Ka tuuno te an vak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus in, Jonah tapa, Simon awng, nong it ziam? ci in a ni vei na ci kik hi. Simon Peter in, hi hi, Topa awng; kong it hi, ci nangma in na he hi, ci hi. Jesus in ama kungah, Ka tuu te an vak in, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus in, Jonah tapa, Simon awng, nong it ziam? ci in a thum vei na ci hi. Tabang thum vei dong Jesus in, nong it ziam? a ci hu in Peter khuangai a, Jesus kungah, Topa awng, Nangma in na theampo na he hi; hong it khi hi, ci na he hi, ci hi. Jesus in ama kungah, Ka tuu te an vak in. ");
INSERT INTO csy_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A tatak in kong ci hi, na khangmoi lai in nangma thu in kawngkhau kil tawm a, na uk na po ah na pai hi: ahihang na huai zawkciang in na ban te na phal tu a, ngual in hong kilsak tu hi, taciang na uk ngawl na mun ah hong pua tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hi thu a son ciang, bangbang thina taw Pathian minthangsak tu ci kilangsak hi. Taciang hi thu a son zawkciang, Jesus in Peter kungah, Hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter hong kihei a, Jesus i a it mama a nungzui pa in a zui mu si; tua mun sia nitak an a neakkhop na uh mun ah Jesus kang neal in, Topa awng, nangma hong leheak sia a kua ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter in tua pa a mu ciang in, Topa, hisia pa bangbang hitu ziam? ci in Jesus kungah ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus in, Ka thet dong om tu in ka dei le, nang atu in bang poimaw ni ziam? nang hong zui po tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tuazawkciang in, tua a nungzui pa sia thi ngawl tu hi, ci thu suapui te sungah hong kizel hi: ahihang Jesus in, ama sia thi ngawl tu hi, ci ngawl hi; ahihang, ka thet dong om tu in ka dei le, nang atu bang poimaw ziam? a ci hi zaw hi. ");
INSERT INTO csy_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Hi a nungzui pa sia, hi thu te tetti pan nate a at pa a hihi: taciang hi tettipanna sia a man a hihi, ci ka he hi. ");
INSERT INTO csy_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesus i sep na dang tampi om lai hi, ta te sia khatsim at siat leang, leitung ah tua thu at natu laibu te ta zo ngawl tu hi, ci ka ngaisun hi. Amen. ");
INSERT INTO csy_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus awng, amasa laibu ka atna sungah, Jesus i sep le a hilna theampo a kipat pan in, ");
INSERT INTO csy_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ama a ki lakto ni dong, tuazawk Tha Thiangtho tungtawn in a tealsa sawltak te tungah thupia hi: ");
INSERT INTO csy_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A thuak zawkciang in sawltak te in ni sawm li sung Ama mu uh a, Pathian kumpingam taw kisai thu te son hi, Ama nungta tatak hi, ci tetti kho tampi taw lak hi: ");
INSERT INTO csy_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Munkhat ah amate taw a ki kaikhop laitak in, Jerusalem pan koima pai ngawl tu in, Keima tung pan na zaksa uh bangma in, Pa i kamciam na ngak vun. ");
INSERT INTO csy_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Banghangziam cile John in tui taw tuiphumna hong pia takpi hi; ahihang ni tampi ma in Tha Thiangtho i tuiphumna na sang tu uh ci, ci in amate thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tua ahikom amate munkhat a ki kaikhop tek uh ciang in, sawltak te in Jesus kungah, Topa awng, tu in Israel te tungah kumpingam na piakik tu ziam? ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesus in amate tung ah, Pa in Ama vangletna sungah a koisa hun le ni te sia, note i heak tu kisam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ahihang note tungah Tha Thiangtho hong thet zawkciang in, vangletna na nga tu uh hi: taciang in Jerusalem le Judah ngamsung theampo, taciang Samaria ngamsung le lei mong a tawp dong in, keima tetti te na hi tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Taciang hi thu te a son zawkciang, amate in a et uh laitak in, Jesus sia a tungsang ah ki lato a; amate mutang in mei in lia hi. ");
INSERT INTO csy_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tabang in vantung ah a kato sia mate in a et tek uh laitak in, en vun, amate hui ah puanpak sil in mi ni hong ding hi; ");
INSERT INTO csy_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Tua te in, no Galilee mite, banghang in vantung en in ding top lai nu ziam? note kung pan in van ah a ki lato na mu uh bangma in, hongpai kik tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tuazawkciang in amate Olive mual pan in Jerusalem ah heakkik uh hi, Olive mual sia Jerusalem pan in sabbath ni pai thei na tan khawng khuala hi. ");
INSERT INTO csy_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalem a thet uh ciang in, inn tung doituam ah kato tek uh a, tua mun ah, Peter, James le John, taciang Andrew, Philip le Thomas, Bartholomew le Matthew, Alphaeus tapa James, Simon Zealot, James naupa Judas te om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Hiteng a vekpi lungkim in nupi te, Jesus nu Mary le a suapui te taw tatsat ngawl in thungen khawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Taciang in Peter sia a nungzui te, mihing za le kul kiim i laizang ah ding a, ");
INSERT INTO csy_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","U le nau te awng, Tha Thiangtho in David i kam zangin a sonkholsa, Jesus man tute a makai Judas thu taw kisai in hi laithiangtho sia a tangtun hamtang kul hi. ");
INSERT INTO csy_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Banghangziam cile ama sia eite taw a kisim khawm hi a, hi Pathian nasepna sungah panmun nga hi. ");
INSERT INTO csy_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hisia pa in phatngawlna a vawt man taw lo ciing khat lei hi; taciang a lusuk nuailam in tak in, a pumpi kisantham a, a ngil zong ke keak hi. ");
INSERT INTO csy_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Hi thu sia Jerusalem ah a om theampo in he uh a; tua lo sia amate kam in, Akeldama, ci uh hi, a khiakna sia, thisan lo, a cinopna a hihi. ");
INSERT INTO csy_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Banghangziam cile, Psalm labu sungah, ama omna mun sia awngthong tahen a, a sungah kuama om heak tahen: taciang a nasep sia midang in la tahen, ci in ki atkhol hi. ");
INSERT INTO csy_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tua ahikom Topa Jesus eite sungah sungtum le pusuak in a om hunsung theampo, ");
INSERT INTO csy_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","John in tuiphumna a piakpan kipan, eite kung panvan ah a ki lakto ni dong, eite taw a omkhawm te sung pan khatpo sia thawkikna thu eite taw tetti a hi tu in, nasep piak hamtang tu a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Taciang amate in, Barsabas kici a, Justus zong a kici Joseph le Matthias te ni teal uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Amate in, Topa awng, nangma in mi theampo i thinsung na he hi, hi te ni sung pan kua na teal ziam, ci hong lak tan, ");
INSERT INTO csy_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tabang in ama in, thunit ngawlna hang in puk a, ama omna mun ah a pai Judas atu in, hi Pathian nasepna le sawltak te sungah kihel tu hi, ci in thungen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Taciang amate in aisan uh a; aitang sia Matthias tungah tak hi; taciang ama sia sawltak sawm le khat te taw kisim khawm hi. ");
INSERT INTO csy_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecost ni hong thet ciang in, amate a vekpi thukimtak in munkhat ah ki kaikhawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Thakhatthu in van pan hui theau vapum bang aw nging hong theng a, amate to na inn hong dim hi. ");
INSERT INTO csy_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Taciang leii taw a kibang meikuang hong kilang a, amate khatsim tungah hong om hi. ");
INSERT INTO csy_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Amate a vekpi in Tha Thiangtho taw kidim uh a, Thaa in pau thei na a piak bang in, kam dang tek taw pau uh hi, ");
INSERT INTO csy_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Van nuai ngam tatuam pan in biakna sang a ki pumpiak Judah mite Jerusalem ah om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Tua aw a zak uh ciang in, mihonpi te hongpai ngawp uh a, amate i pauna sia amate kam tek taw za uh ahikom buai tek mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Taciang amate a vekpi in lungmang in lamdangsatek mama uh a, en vun, amate a vekpi uh in Galilee mite hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Bangbang in i pianpui kam tek taw za hi ziam? ");
INSERT INTO csy_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Eite sia Parthia ngam, Media ngam, Elam ngam, Mesopotamia ngam, Judah ngam, Cappadocia ngam, Pontus ngam, Asia ngam, ");
INSERT INTO csy_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia ngam, Pamphylia ngam, Egypt ngam le Libya ngam Syrene khua pan i hi a, Rome sung leangna te, Judah mite le Judah biakna a bia Gentile te, ");
INSERT INTO csy_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Cretes le Arabia ngam pan i hi a, amate i eima kam in a pau i zak sia Pathian i a lamdang nasep na hi, ci in khat le khat ki sason uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Amate a vekpi in lamdangsa mama uh a, lungmang mama in, hi thu sia a bang khiakna peuma ziam? ci in khat le khat ki dong uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","A dang te in selno in, hite sia sapittui thak kham hon uh, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ahihang Peter sia a dang sawm le khat te taw ding uh a, aw ngingtak in amate tung ah, no Judah mite le Jerusalem ah a omte, hi thu he tavun a, ka pau te ngai vun: ");
INSERT INTO csy_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Banghangziam cile hite sia no i ngaisut bang in kham ngawl hi, zingsang nai kua hi pheang hi. ");
INSERT INTO csy_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ahihang hi thu sia kamsang Joel i sonkholsa; ");
INSERT INTO csy_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Pathian in ni tawpkhak ni ciang in, mi theampo tungah ka Thaa ka buak tu hi: taciang na tapa te le na tanu te in maisang thu pualak tu uh hi, taciang na tangval te in mangmu tu uh hi, taciang na puhuai te uh in mangman tu uh hi: ");
INSERT INTO csy_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tua ni ciang in, ka salpa le salnu te tungah ka Thaa ka buak tu a; amate in mailam thu pualak tu hi: ");
INSERT INTO csy_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Taciang vantung ah nalamdang te ahizong, lei nuai ah thisan, mei le meikhu musakna te ahizong, ka lak tu hi: ");
INSERT INTO csy_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","A thupi le a cepte tak Topa ni hong thet ma in, ni hong mial tu a, tha zong thisan suak tu hi: ");
INSERT INTO csy_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Tua hun ciang in a kuamapo Topa min a sam theampo in ngupna nga tu hi. ");
INSERT INTO csy_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","No Israel mite, hi thu te ngai vun; Nazareth mi Jesus sia, Pathian in note sungah a tumdang nate, nalamdang te le musakna te taw tettipang in a kipsak mihing a hihi, note mama in zong na heak uh bangma in: ");
INSERT INTO csy_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ama sia, Pathian i khensat sa ngaisutna le heakkholsa bang in ki ap hi, taciang note in na man uh a, a seksol khut taw thinglamte tungah khai in na that uh hi: ");
INSERT INTO csy_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ama sia thina in a letcip tu suakthei ngawl ahikom, Pathian in thokiksak a, thina ngimthuak na pan in suaktasak hi. ");
INSERT INTO csy_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Banghangziam cile David in Ama taw kisai in a son na ah, Topa sia a tawntung in ka mai ah ka mukhol hi, banghangziam cile Ama sia ka ziatsang ah om a, bangma in hong linglawngsak zo batu hi: ");
INSERT INTO csy_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tua ahikom ka thinsung ah nopna om a, ka lei a lungdam hi; tuabek domngawl ka taksa zong lametna sungah tawlnga tu hi: ");
INSERT INTO csy_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Banghangziam cile nangma in ka tha sia hell sungah na nusia bua hi, na Mi Thiangtho sia a muatcip tu na oai bua hi. ");
INSERT INTO csy_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nangma in nuntakna lampi te nong hesak zo a; na maitang taw lungdamna dim in nong vawt tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ka suapui te awng, minam te i pa David thu hangsan tak in kong son tu hi, ama sia thi a kivui zo hi, taciang tuni dong eite taw a than om nginge hi. ");
INSERT INTO csy_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ama in cilesa lam a suanlepal te sung pan, Pathian in Christ sia thokiksak tu a, kumpi tokhum tungah tosak tu hi, ci in kiciamna taw a kamciam na sia kamsang a hi nataw in he hi; ");
INSERT INTO csy_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hi Christ thawkikna a mukhol hu in, a tha sia hell ah nusia ngawl hi, a taksa zong muat ngawl hi, ci son hi. ");
INSERT INTO csy_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Hi Jesus sia Pathian in thokiksak zo a, kote sia a tetti te ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tua ahikom Pathian i ziatsang ah ki lamsang a, Pa i kamciam Tha Thiangtho a san hu in, tu in na mu uh le na zak uh te sia Ama i hong buak a hihi. ");
INSERT INTO csy_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Banghangziam cile David sia van ah kato ngawl hi: ahihang ama vateak in, Topa in ka Topa kungah, ka ziatsang ah to in, ");
INSERT INTO csy_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Na ngalte ka peang koina in ka vawt mateng, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tua ahikom Israel minam theampo in thiangtak in tel tavun, thinglamte tungah na khai uh Jesus sia Pathian in Topa le Christ in vawt zo hi. ");
INSERT INTO csy_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tu in amate in hi thu a zak uh ciang in, amate i thinsung hol a, Peter le adang sawltak te kungah, U le nau te awng, banglaw tu khu ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Taciang in Peter in amate tung ah, na mawna uh kisik vun a, na mawna uh hang in na vekpi Jesus Christ min taw tui ki phum vun, taciang Tha Thiangtho letsong na nga tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Banghangziam cile kamciam sia noma, na tate, taciang a khuala mi theampo le Topa i Pathian in a sap tu theampo atu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter in a dang kammal tampi taw tettipang in hanthawn a, hi minam seksol te kung pan in noma le noma ki ngum vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Tuazawkciang in Peter thuhilna sia lungdamtak in a sang te tui ki phum uh hi: taciang tua ni ma in mihing tul thum kiim amate kungah ki belap hi. ");
INSERT INTO csy_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Amate sia sawltak te hilna le ki pawlkhopna, anluum bal na le thungetna ah tatsat ngawl in kiptak in om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Sawltak te in nalamdang tampi le musakna tampi vawt uh a, mi theampo tungah launa hong theng hi. ");
INSERT INTO csy_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Taciang a umte theampo ki kaikhawm uh a, a neisa theampo zong neikhawm uh hi; ");
INSERT INTO csy_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Amate neisa le van te zuak uh a, mi khatsim i a kisapna bang in, mi theampo tungah hawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Amate sia nisim tatsat ngawl in biakinn sungah thukim in om tek uh hi, taciang inn khat zawk inn khat ah anluum te bal uh a, lungdamtak le thin ki si lung kisi in an ne khawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Pathian pok khawm tek uh a, mi theampo taw maipha nga uh hi. Ngupna nga mi Topa in nisim in pawlpi sungah belap hi. ");
INSERT INTO csy_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tu in Peter le John te thunget hun nitak sang nai thum ciang in biakinn ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","A nu ngil sung pan ma in a peangbai khat sia midang te in toai a, biakinn sung a tum te tung pan huna ngen tu in, Hoi, a kici biakinn kongpi ah nisim in koi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ama in Peter le John te biakinn sung a tum tu a mu ciang in huna ngen hi. ");
INSERT INTO csy_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Taciang Peter in, John taw phatak in en a, hong en tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Amate tung pan in khatpo nga tu lamen in phatak in en hi. ");
INSERT INTO csy_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peter in, dangka le kham bangma nei ngawl khi hi; ahihang ka neisun kong pia hi: Nazareth mi Jesus Christ min taw ding in a, lampai in, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Taciang Peter in tua pa ziatsang khut pan len a, kaito hi: tasia pociang tua pa i peang le a ngumit te thakho kik hi. ");
INSERT INTO csy_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ama sia tawnkawm in ding hi, taciang lampai a, biakinn sungah amate taw tum hi, taciang lampai kawm tawnkawm in Pathian pok hi. ");
INSERT INTO csy_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Taciang lampai in Pathian a pok mi theampo in mu uh hi: ");
INSERT INTO csy_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ama sia biakinn ah, Hoi, a kici kongpi ah to in hu na a ngen pa hi, ci a he uh hi: taciang hisia pa tungah thupiang te lamdangsa in lungman na taw dim uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","A peangbai na pan a dam pa in Peter le John te beal a, mi theampo in lamdangsa in amate kung, Solomon buk sangah tai lialua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tua thu Peter in a mu ciang in amate tung ah, no Israel mite awng, banghang in hi thu lamdangsa nu ziam? a hibale banghang in hisia pa sia koma vang le thianthona hang in lampai bang in, hong en cinten nu ziam? ");
INSERT INTO csy_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac le Jacob te Pathian, i pu le pa te Pathian in, a Tapa Jesus sia vangliansak zo hi; Ama na ap uh a, Pilate in thakik nuam napi, note in Pilate mai ah na nial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Note in Mi Thiangtho le Mi Thutang pa na nial uh a, tualthat pa note tungah piak tu in na dei uh hi; ");
INSERT INTO csy_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Taciang nuntakna Topa na that uh hi, Ama sia Pathian in thina pan in thokiksak a; kote sia a tetti te ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Jesus min upna tungtawn in hisia pa na mu uh le na heak uh bang in, Ama min taw hatsak hi: hi hi, a upna hang in hi damna kicing sia note theampo mai ah pia hi. ");
INSERT INTO csy_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Tu in ka suapui te awng, noma le na makai te in Jesus tungah na vawt uh te, na heak ngawl uh hu in a vawt na hi uh hi, ci ka he hi. ");
INSERT INTO csy_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ahihang tua thu te sia, Pathian in kamsang te kam tungtawn in hong lakkholsa, Christ sia thuak tu hi, ci thu a tangtun natu a hihi. ");
INSERT INTO csy_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tua ahikom note na mawna uh ki sikkik vun a, na thinsung uh ki kheal vun, tabang in na mawna uh te hong phiatsak tu a, Topa mai pan in tha thak na nga uh hun hong thengkik tu hi. ");
INSERT INTO csy_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Taciang note tungah a ki pualaksa Jesus Christ hongpaisak tu hi: ");
INSERT INTO csy_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Leitung pian pan kipan Pathian in Ama kamsang thiangtho te kam tungtawn in a sonkholsa bang in, na theampo thaksua na hun dong Jesus Christ sia vantung ah om suak tu hi. ");
INSERT INTO csy_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Banghangziam cile Moses in a tatak in, pu le pa te tung ah, Topa na Pathian in keima bang kamsang khat, na suapui te sung pan ka piangsak tu a; note tungah a sonsa theampo sia na theampo sungah na ngai tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Taciang in kamsang thu a ngai nuam ngawl peuma, mipi sung pan in susia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel pan kipan in a nungsang pan kamsang thu a son te theampo in, hi ni thu te sonkhol zo uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Note sia kamsang te i tate na hi uh hi, Pathian in i pu le pa te taw Abraham kungah a vawt kamciam, na suanlepal tungtawn in leitung minam theampo in thupha sang tu hi, ci thu na sang tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Note sungah phat ngawlna pan in, a heakkik peuma thupha pia tu in, Pathian in a Tapa Jesus thokiksak a, a masabel in note kungah hong sawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Amate in mipite tungah thu a hil uh laitak in, thiampi te, biakinn lampui te le Sadducee te amate kungah hongpai uh hi, ");
INSERT INTO csy_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Sawltak te in mipi te thuhil a, Jesus tungtawn in thina pan thawkikna thu a pualak uh hu in, amate thinna in om tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Taciang amate in sawltak te man uh a, a zingciang dong thongtaksak uh hi: banghangziam cile tu in khua niam zo hi. ");
INSERT INTO csy_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ahihang a thuhilna a zate in um uh hi; a umte a mimal in tul nga kiim pha uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","A zingciang in amate i lampui te, upa te le thukhamhil te, ");
INSERT INTO csy_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Taciang thiampi sang Annas le Caiaphas, John le Alexander, taciang thiampi sang i mealheak te theampo taw Jerusalem ah ki kaikhawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Amate a laizang ah dingsak uh a, bang thuneina, a hibale akua min taw in hibang te vawt nu ziam? ci dong hi. ");
INSERT INTO csy_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tuazawkciang in Peter sia Thaa Thiangtho taw kidim a, amate tung ah, no mipi lampui te le Israel upa te, ");
INSERT INTO csy_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tuni in hi cina pa tungah napha a ki vawtna le banghang in dam, ci thu taw kisai in thu hong dong nahi uh le; ");
INSERT INTO csy_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Note theampo le Israel mi theampo in he tavun, thinglamte tungah na khai uh a, Pathian in thina pan a thawkiksak Nazareth mi Jesus Christ min taw, note mai ah a ding pa sia dam hi. ");
INSERT INTO csy_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Noma inn sate in na nil uh hi suangtum sia inn khuampi suak hi. ");
INSERT INTO csy_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ngupna sia mundang ah om ngawl hi; banghangziam cile ngupna i nga thei natu in vantung leinuai ah mindang a kipia om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Amate in Peter le John te hangsanna a mu uh ciang in, lai he ngawl le pilna nei ngawl te, ci he uh a, lamdangsa mama uh hi; taciang amate sia Jesus taw omkhawm ngei hi, ci zong he kik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Taciang a damsak pa sia amate taw a dingkhawm nginge a mu uh hu in, tua thu langpan in bangma a pau thei bua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Amate thuneite kungpan pusuak tu in thu a piak zawk uh ciang, amate bek thu kikum khawm uh a, ");
INSERT INTO csy_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Hite banglaw tu hi ziam? banghangziam cile amate in a cepte tak nalamdang te vawt uh a, Jerusalem ah a om mi theampo mai ah vawt uh hi; taciang hi thu i nial thei bua hi. ");
INSERT INTO csy_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ahihang hi thu mite sungah kizel thua ngawl tu in ahizong, kuama tungah hi min taw thuhil ngawl tu ahizong, nasiatak in thawmvau tawng, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Taciang amate sam uh a, Jesus min taw thuhil ngawlhet tu le son nawn ngawl tu in thupia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ahihang Peter le John in, Pathian thu sang in note i thu man tu sia Pathian mai ah a pha le a phangawl noma in khensat vun. ");
INSERT INTO csy_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Banghangziam cile ka mu uh thu le ka zak uh thu te son ngawl in ka om thei bua uh hi, ci in zo uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tua ahikom amate in a thawmvau zawk uh ciang in, bangbang in danpia tu ci a heak ngawl uh hu in suatak uh hi, banghangziam cile mi theampo in hi a sep uh te hang in Pathian minthang pok tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Banghangziam cile hi cidamna nalamdang a tungah a kilangpa sia kum sawm li val zo hi. ");
INSERT INTO csy_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","A suatak zawk uh ciang, amate a lawmte kungah pai uh a, thiampi lian te le upa te in amate tungah a son theampo sonkik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Tua thu amate in a zak uh ciang in, thinkhat lung khat in Pathian kungah au tek uh a, Topa awng, Nangma sia van le lei, tuipi le a sung om theampo a vawt Pathian na hihi: ");
INSERT INTO csy_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na naseam David tungtawn a son thu, banghang in Gentile mite thin-uk ziam, taciang mihing te banghang in matlap nei ngawl thu te ngaisun uh ziam? ");
INSERT INTO csy_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Leitung kumpi te ding uh a, taciang ngam uk te zong ki kaikhawm in Topa le Christ langpan uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Banghangziam cile sathau na buaksa Nangma i a thiangtho nauno Jesus sia Herod le Pontius Pilate, Gentile mite le Israel mite taw, ki kaikhawm tek in, nasiatak in langpan uh hi, ");
INSERT INTO csy_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Banghangziam cile na khut taw na vawt tu te le na khensatsa ngaisutna te na khuangkhim natu a hihi. ");
INSERT INTO csy_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Tu in Topa awng, amate i hong thawmnvauna te en in: na sal te tungah na thu pualak tu in hangsanna hongpia tan, ");
INSERT INTO csy_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na nauno thiangtho Jesus min taw cina te damsak tu le musakna te le nalamdang te vawt tu in na ban hong phal ta in, ci in thungen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Amate thu a nget zawk uh ciang in, a kikhopna mun ling hi; taciang amate sia Tha Thiangtho taw kidim uh a, Pathian thu hangsantak in son uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Taciang thu um mihonpi te thinkhat lungkhat taw in omkhawm tek uh hi: kuama in a neisa te uh keima a hi, ci ngawl uh hi; ahihang amate neisa na theampo neikhawm tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Topa Jesus thawkikna thu ssawltak te in vangletna lianpi taw tettipang uh a: amate tungah hesuakna lianpi om hi. ");
INSERT INTO csy_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Amate sungah a ki tangsam khat zong a om bua uh hi: banghangziam cile lo ngam te, a hibale inn nei te in zuak uh hi, taciang a sum nga uh teng keng uh a, ");
INSERT INTO csy_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Sawltak te peang ah koi tek uh hi: taciang khatsim i kisapna bang in hawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Taciang Joses, sawltak te in Barnabas a ci uh, Barnabas i a khiakna sia, henepna tapa a kici pa, ama sia Levi minam hi a, Cyprus ngam mi a hihi, ");
INSERT INTO csy_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tua pa in a lo zuak a, a dangka keng in, sawltak te peang ah koi hi. ");
INSERT INTO csy_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ahihang Ananias kici mi khat om a, a zi Sapphira taw a neisa uh zuak hi, ");
INSERT INTO csy_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Taciang a zi i heakpui nataw a man pawlkhat phualseal uh a, pawlkhat hong paipui in, sawltak te peang ah koi hi. ");
INSERT INTO csy_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ahihang Peter in, Ananias awng, banghang in Tha Thiangtho theam tu in le lo man pawlkhat phualseal tu in Satan in na thinsung hong dimsak ziam? ");
INSERT INTO csy_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Lo a om lai in, nangma a hi ngawl ziam? taciang na zuak zawkciang zong, nangma thu ma hi ngawl ziam? banghang in na thinsung ah hibang ngaisun ni ziam? mihing theam hi ngawl in, Pathian theam hi zaw ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Taciang Ananias in hi kammal te a zak ciang puk in, thi hi: hithu te a za theampo tungah launa lianpi hong theng hi. ");
INSERT INTO csy_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Taciang tangval te ding in, tuun uh hi, taciang puasang ah zawng in, vui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nai thum bang a kihal zawkciang in, bang thu piang ci zong he ngawl pi in a zi hong tum hi. ");
INSERT INTO csy_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Taciang Peter in a kungah, na lo uh hi za taw zuak nu ziam? hong son tan, ci dong hi. Taciang ama in, hi za ma hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Tuazawkciang in Peter in ama kungah, bangbang in Topa Thaa ze-et tu in thukim thei nu ziam? en in, na pasal vui te i peang sia kongkha bul ah om hi, taciang amate in puasang ah hong zawng tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tua zawkpo ciang in Peter peang ah puksuk in, thi hi: taciang tangval te hong tum uh a, a thisa in mu uh hi, taciang, puasang ah zawng uh a, a pasal kungah vui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Taciang pawlpi le hi thu a za theampo tungah launa lianpi hong theng hi. ");
INSERT INTO csy_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sawltakte i khut tungtawn in musakna le nalamdang tampi mite sungah vawt uh a; thu umte theampo Solomon buk sungah ki thukim tak in omtek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Amate sia ngual in pok mama napi, a dang kuama in ki pawlpui ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Taciang thu um mi numei le pasal mihonpi sia Topa kungah tam seseam ki belap hi. ");
INSERT INTO csy_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Cina te lamdung ah hong paipui uh a, Peter in a kantan laitak in, a lim in pawlkhat te lia tu in lupna le luppha te taw sial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem kimkot khua tampi pan in mihonpi te zong hongpai uh a, cina te le doai te i zawthawk te zong hong paipui uh hi: taciang amate a vekpi in dam siat hi. ");
INSERT INTO csy_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Tuazawkciang in thiampi sang le ama taw a om Sadducee te theampo thin-ukna taw dim in hong ding uh a, ");
INSERT INTO csy_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Sawltak te man in, thong sungah khia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ahihang Topa vantungmi in zan ciang in thonginn kongkha te hong a, pusua siat hi, ");
INSERT INTO csy_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Taciang, pai vun a, ding in biakinn sung mipi te tungah hi nuntakna thu theampo son tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Amate in hi thu a zak uh ciang in, zingtung in biakinn sungah tum uh a, thuhil uh hi. Ahihang thiampi sang le a naseam te hongpai uh a, thudokpi te le Israel upa te theampo sam hi, taciang amate in ngual sawl in sawltak te paipuisak hi. ");
INSERT INTO csy_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ahihang palik te a thet ciang in, thong sungah a mu ngawl uh ciang, heakkik in son uh a, ");
INSERT INTO csy_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Thonginn phatak in a kikhak in mu khu hi, taciang thongcing te zong a puasang kongkha mai ah ding nginge hi: ahihang ka hon uh ciang in, a sungah mihing khat zong ka mu bua uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Hi thu te thiampi sang, biakinn lampui te le thiampi lian te in a zak uh ciang in, bang thu hithong ziam, ci in lungmang mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Tasia ciang in mi khat hongpai a, en vun, thong sung na khum mihing te biakinn sungah ding in mite thuhil san uh hi, ci son hi. ");
INSERT INTO csy_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Tuazawkciang in biakinn lampui le palik te pai hong pai uh a, amate zawthawk thu zang ngawl in paipui hi: banghangziam cile mite in suangtum taw a den tu a lau uh hang a hihi. ");
INSERT INTO csy_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Amate in sawltak te paipui uh a, thudokpi te mai ah dingsak uh hi: taciang thiampi sang in amate thu dong a, ");
INSERT INTO csy_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Hi min taw thuhil ngawl tu in nasiatak in thu hongpia zo hi ngawl khu ziam? taciang, en vun, Jerusalem sia note i hilna taw kidimsak siat zo nu hi, taciang hisia pa thisan sia kote tungah hong thengsak nuam nu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Taciang Peter le a dang sawltak te in zo kik uh a, mihing te thu sang in Pathian thu ka zui zaw tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Note in thing tungah that in, na khai uh Jesus sia ka pu le pa te i Pathian in thokiksak hi. ");
INSERT INTO csy_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Israel te maw kisikik na le maw maisakna pia tu in Ama sia Pathian in a ziatsang khut taw To le Ngumpa in lamsang zo hi. ");
INSERT INTO csy_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Taciang kote sia hi thu te i tetti te ka hi uh hi; taciang Pathian in a thu a zui te tungah a piak Tha Thiangtho zong tetti a hihi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Amate in tua thu a zak uh ciang in, nasiatak in a thin uh uk a, sawltak te that tu in ngaisun uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Tuazawkciang in thudokpi te sung pan Pharisee khat, Gamaliel a kici, thukham taw kisai doctor a hi, mi theampo sungah a ki zakta pa in, sawltak te tawmvei sung pusuaksak tu in thupia a; ");
INSERT INTO csy_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Amate tung ah, no Israel mite, hi thu taw kisai in na vawt tu uh thu kidawm vun. ");
INSERT INTO csy_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Banghangziam cile hi te om ma in Theudas a kici khat piang ngei a, ama le ama sia mi thupi khat bang in ki suangtak mama hi; mihing zali kiim in beal phot napi, ama ki that hi; taciang a thu zuite theampo ki thethang siat a, bokik siat hi. ");
INSERT INTO csy_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Hisia pa om ma in Galilee mi, Judas kici misim hun laitak in hong piang leleau a, a nungzui mi tamma kaizawn hi: ama zong bokik veve a; a thuzui te theampo a vekpi in, ki thethang leleau hi. ");
INSERT INTO csy_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Taciang tu in kong son hi, hi te pial vun a, amate om in om lel tahen: banghangziam cile hi ngaisutna, a hibale, hi nasep sia mihing tung pan ahile, bokik siat lel tu hi: ");
INSERT INTO csy_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ahihang, hisia sia Pathian kung pan ahile, na zozo batu uh hi; Pathian langpan in a do zong na suak thei zawsap tu uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Amate in Gamaliel i son thu lungkim tek uh hi: taciang sawltak te sam uh a, a sat zawkciang in, Jesus min taw thuhil nawn ngawl tu in thupia a, suatak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Taciang amte Jesus min hang in maizumna thuaktak in a cepte hu in angtang mama in thudokpi te mai pan pusuak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Taciang nisim in biakinn sung le inn tatuam ah tatsat ngawl in Jesus Christ thuhil in pualak tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tua hun sung, nungzui te hong khan ciang in, Greek te in Hebrew te langpan in kamtam na hong piang hi, banghangziam cile Greek meingong te sia nisim an a hawm uh ciang in ki ngaingonsak hi. ");
INSERT INTO csy_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Tua zawkciang in sawltak sawm le ni te in nungzui mihonpi te amate kungah sam a, kote Pathian thu nusia in an ka hawm tu uh sia lungkim huai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tua ahikom, suapui te awng, noma sung pan in a belcing minpha, Tha Thiangtho le ciimna taw a kidim mi sali hong zong tavun a, hi nasep amate i ap tu hi. ");
INSERT INTO csy_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ahihang kote thungen le Pathian thu sungah a tawntung in ka kipumpiak tu uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Taciang amate sonbang in mihonpi theampo lungkim uh a: amate in, upna le Tha Thiangtho taw a kidim Stephen, Philip, Prochorus, Nicanor, Timon, Parmenas le Antioch khua mi Judah biakna ah a tum Nicolas te teal uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Amate sia sawltak te mai ah dingsak uh a, thu a ngetsak uh ciang in, amate lutung ah a khut nga uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Taciang Pathian thu hong khang a; Jerusalem ah nungzui te nasiatak in hong ki belap hi; taciang thiampi tampi te in upna thu zui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Taciang upna le vangletna taw a kidim Stephen in, mite sungah a lian mama nalamdang le lim tumdang lianpi te vawt hi. ");
INSERT INTO csy_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tuazawkciang in A Suaktate synagogue a kici, synagogue sungah Cyrene mite, Alexandria mite, Cilicia mite le Asia mite Stephen taw thu kinial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amate in Stephen i ciimna le thaa taw a pauna te a nalh zo bua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Tuazawkciang in amate in mite sumnguk pia ku uh a, tua te in, hisia pa in Moses le Pathian langpan in mindaisak na kammal te a pau sia kote in ka za uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Taciang amate in mihonpi te, upa te le thukhamhil te hol uh a, Stephen kungah hongpai uh hi, taciang thudokpi te kungah paipui uh a, ");
INSERT INTO csy_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Hisia pa in mun thiangtho le thukham langpan in mindaisak na kammal te tatsat ngawl in pau hi, ci uh hi, tabang in leilot tetti tampi koi uh hi: ");
INSERT INTO csy_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Banghangziam cile, Nazareth mi Jesus in hi mun susia tu a, Moses i hongpiak thukham te lai tu hi, ci in hisia pa in a son ka za uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Thudokpi te thukhen na mun ah a to theampo in, Stephen sia phatak in sal uh a, a maitang sia vantungmi te maitang bang in mu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Tuazawkciang in thiampi sang in, hi thu te tabangma ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Taciang Stephen in, suapui te le pa te awng, ngai vun; i pa Abraham sia Haran ah a om ma, Mesopotamia ah a omlai tak in, a vanglian Pathian ama tungah kilang a, ");
INSERT INTO csy_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ama tung ah, na ngam le na mipui te sung pan in pusuak in a, kong lak tu ngam ah pai in, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Tuazawkciang in Chaldaeans ngam pan pusuak a, Haran khua ah om hi: tua mun pan a pa a thi ciang in, tu in na omna uh mun, hi ngamsung ah ki khin hi. ");
INSERT INTO csy_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Taciang hi ngam sungah a peang ngak natu na ngawn, mun pia ngawl hi: ahihang ama le a suan le pal te hi ngam pia tu in ta a nei ma in, kamciam pia zo hi. ");
INSERT INTO csy_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Taciang Pathian in hi bang in son hi, a suan le pal te ngamdang ah peam tu uh a; kum zali sung sal tang in ngimna thuak tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Taciang a saltanna mun minam te keima in thu ka khen tu hi, tua zawkciang in amate pusuak tu uh a, hi mun ah keima na seam tu uh hi, ci in Pathian in ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Taciang Pathian in Abraham sia vunteap tanna kamciam pia hi: taciang Abraham in Isaac nei a, ni liat ni ciang in a vunteap tansak hi; taciang Isaac in Jacob nei a; taciang Jacob in minam makai sawm le ni te nei hi. ");
INSERT INTO csy_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Taciang minam makai te in ki enna hang in Joseph sia Egypt ngam ah zuak uh hi napi: Pathian in ompui a, ");
INSERT INTO csy_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Haksatna theampo sung pan suatak in, Egypt kumpipa Pharaoh mai ah ciimna le maipha pia hi; taciang Egypt ngam le ama inn theampo tungah a uk tu in vawt hi. ");
INSERT INTO csy_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egypt ngam le Canaan ngamsung theampo ah kialtung a, taciang haksatna lianpi theng ahikom in i pu i pa te bangma neak tu muzo ngawl uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ahihang Jacob in Egypt ngam ah an om hi, ci a zak ciang in, i pu le pa te a masabel in paisak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Taciang a ni veina ciang in Joseph in a suapui te kungah ama thu hesak hi; taciang Joseph i mealheak te Pharaoh kungah hesak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tuazawkciang Joseph in paisak a, a pa Jacob le a mealheak theampo mihing sawm sali le nga te ama kungah sam hi. ");
INSERT INTO csy_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tua ahikom Jacob sia Egypt ngam ah pai a, ama le i pupi te tuak ah thi hi, ");
INSERT INTO csy_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A luanghawm sia Shechem ah pua uh a, Abraham in Hamor tapa kung pan dangka taw a lei sa than ah vui hi. Hamor sia Shechem i pa a hihi. ");
INSERT INTO csy_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Ahihang Pathian i Abraham tung kiciamna taw a kamciamna hun hong nai ciang in, Egypt ngam ah amate khang in pung seseam uh hi, ");
INSERT INTO csy_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Joseph a he ngawl a dang kumpi khat hong khan dong in pung uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Tua kumpipa in i mipui te philphit tak in theambawl uh a, nausen te a nungta ngawl tu in vawk tu in i pupi te sia phatngawlna taw vawtsia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Tua hun in Moses suak a, ama sia hoi mama hi, taciang a pa inn ah tha thum sung ki vak hi: ");
INSERT INTO csy_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Taciang ama sia a puasang ah a ki vawk ciang in, Pharaoh tanu in la a, ama tapa tu in vak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tua Moses in Egypt te pilna theampo sin a, ama sia kampau le sepna ah lawcing mama hi. ");
INSERT INTO csy_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Taciang ama sia kum sawmli a phak ciang in, a suapui Israel tate ve nopna a thinsung pan hong suak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Israel mi khat a man ngawl in a thuak a mu ciang in, tua pa ngum a, a vawtsia Egypt pa sia phulam in that hi: ");
INSERT INTO csy_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Banghangziam cile Pathian in ama khut zang in amate suatak tu hi, ci a suapui te in he tu in ngaisun hi: ");
INSERT INTO csy_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","A zingciang in Israel mi ni a kihau te kungah pai a, leptua sawm in, note u nau nu hi; banghang in kihau nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ahihang a innpam pa a vawtsia pa in Moses sawn a, nang akua in kote tungah thunei le thukhen tu in hong vawt ziam? ");
INSERT INTO csy_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Zei ni Egypt pa na thalup bang in hong that nuam ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tuazawkciang hisia pa i kampau hang in Moses tai a Midian ngam ah peamta in om hi, tua mun ah tapa ni nei hi. ");
INSERT INTO csy_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Kum sawm li a bo ciang in, Sinai mual duisung ah Topa vantungmi sia lophung kuang bang in kilang hi. ");
INSERT INTO csy_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tasia Moses in a mu ciang in, a mu thu lamdangsa hi: en tu in a neak ciang in, Topa aw ama tungah theng a, ");
INSERT INTO csy_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Keima sia na pu le pa te i Pathian, Abraham Pathian, Isaac Pathian le Jacob Pathian ka hihi, ci hi. Tuazawkciang in Moses sia ling a, en zong en ngam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tuazawkciang in Topa in ama kungah, na peangdap sut in: banghangziam cile na dinna mun sia a thiangtho leitang a hihi. ");
INSERT INTO csy_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Keima in ka mu zo hi, Egypt ngam ah ka mite haksatna keima in mu zo khi hi, taciang amate tauna ka za zo a, suatak tu in kong tuaksuk hi. Taciang tu in hongpai tan, Egypt ngam ah hong sawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Hi Moses sia amate in nial uh a, nangma sia hong uk tu le thukhen tu in a kua in hong vawt ziam? ci uh hi. Pathian in Moses sia lophung sung pan ama tungah a kilang vantungmi i khut tungtawn in ukpa le ngumpa tu in paisak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses in amate pusua pui a, tua zawkciang in Egypt ngam, san tuipi le senneal ngam sungah kum sawmli sung, nalamdang le musakna tampi te lak hi. ");
INSERT INTO csy_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Topa na Pathian in keima bang kamsang khat, na suapui te sung pan ka piangsak tu hi; note in a thu na ngai tu uh hi, tabang in Israel tate tungah a sonpa sia Moses a hihi. ");
INSERT INTO csy_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ama sia senneal ngamsung a om pawlpi te kungah ahizong, Sinai mual ah vantungmi taw a ki paupui na ah ahizong, taciang i pu i pa te taw ahizong, omkhawm ngei a: ama sia eite tungah hongpiak tu a nungta kammal te a sang pa a hihi: ");
INSERT INTO csy_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","I pu i pa te in thu ni ngawl uh a, amate kung pan sawnthal uh hi, taciang amate thinsung pan in Egypt ngam ah heakkik uh hi, ");
INSERT INTO csy_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Amate in Aaron tung ah, kote i mai ah a pai tu in pathian te hong vawtsak tan: banghangziam cile Egypt ngam pan hong pusua hi Moses sia bangsuak, ci ka he bua uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Taciang tua hun sung in amate in khuino vawt uh a, milim tungah biakpiakna pia uh hi, taciang amate khut taw a vawttawm nate tungah lungdam in om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tuazawkciang in Pathian in amate nungngat a, van aksi te bia tu in koicip hi; kamsang te laibu sungah a ki atsa bang in, Maw, no Israel minam te, senneal ngam ah kum sawm li sung a ki thatlum ngamsa te le biakpiakna te nong pia uh ziam? ");
INSERT INTO csy_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Note in Molech i biakbuk le na aksi pathian Remphan, na biak tu in na vawttawm uh milim te na keng uh hi: tua ahikom keima in note Babylon ngalkhat dong in kong paipui tu hi. ");
INSERT INTO csy_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","I pu le pa te in senneal ngam sungah biakbuk tetti te nei hi, Moses tung son uh a, a mu uh lim bang in, vawt tu in sawl uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tuazawkciang in i pu le pa te in tua biakbuk sia Gentile te i neisa ngamsung ah Joshua taw tumpui uh hi, tua Gentile te sia Pathian in David hun dong i pu le pa te mai pan in hawlkhia siat hi. ");
INSERT INTO csy_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David in Pathian mai ah maipha nga a, Jacob Pathian atu biakbuk sa tu in ngen hi. ");
INSERT INTO csy_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ahihang Solomon in Pathian atu in inn sa hi. ");
INSERT INTO csy_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ahihang a sangbel Pathian sia khut taw a kisa biakinn sungah om ngawl hi; kamsang i a son na ah, ");
INSERT INTO csy_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Vantung sia ka kumpi tokhum hi a, leitung sia ka peang ngakna hi, bangbang inn kei atu satu nu ziam? a hibale ka tawlngak na mun sia bang ziam? ");
INSERT INTO csy_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Hi nate theampo sia keima khut taw ka vawt hi ngawl ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Note ngawng ngu khoh te le thinsung le nakheng vunteap tan ngawl te awng, note in Tha Thiangtho na khak tawntung uh hi; na pu le pa te i a vawt uh bang in note in zong na vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Kamsang te sung pan na pu le pa te in a vawtsiat ngawl khat beak a om ziam? Mi thutang pa hongpai natu thu a pualak te amate in that uh a; tu in note sia tua mi thutang pa a zuak te le a that te na hi uh hi: ");
INSERT INTO csy_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Vantungmi te i huna taw thukham na sang uh a, na zui bua uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Amate in hi thu te a zak uh ciang in, nasiatak in thin-uk mama uh a, a ha te ngoai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ahihang Stephen sia Tha Thiangtho taw kidim in, vantung lam tangtak in ento hi, taciang Pathian vangletna le Jesus sia Pathian ziatsang ah a ding mu hi. ");
INSERT INTO csy_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","En vun, van ki hong a, Pathian ziatsang ah mihing Tapa a ding ka mu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Tuazawkciang in aw ngingtak in au uh a, a bil uh hum in, ki lomtang in Stephen sangah hong tai uh hi, ");
INSERT INTO csy_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Taciang khuapua ah nawt uh a, suangtum taw deang uh hi: taciang tetti te in a nik le puan te tangvalpa peang ah koi uh hi, tua tangvalpa min sia Saul a hihi. ");
INSERT INTO csy_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Amate in Stephen sia suangtum taw deang uh hi, taciang Stephen in, Pathian sam a, Topa Jesus awng, ka tha hong sang tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Taciang ama khupdin in, Topa awng, hi mawna sia amate tungah koi heak in, ci in a ngingtak in au hi, tabang a au zawkciang in ama mutthip hi. ");
INSERT INTO csy_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Taciang Stephen i thina ah Saul a lungkim hi. Tua hun sung in Jerusalem pawlpi langpan in vawtsiatna lianpi om hi; sawltak te simngawl, thu um mite theampo sia Judah ngam le Samaria ngam muntheampo ah peakkeak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Stephen sia biakna sang a kipia mite in zawng in vui uh hi, taciang nasiatak in kaa uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saul ahile, inn sim ah tum a, numei pasal ci ngawl in kaikeak a, taciang thonginn ah ap in, pawlpi susia hi. ");
INSERT INTO csy_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Tua ahikom mun theampo ah a ki thethang te mun tatuam ah pai in Pathian thu tangko tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Tuazawkciang in Philip sia Samaria khuapi ah pai a, amate tungah Christ thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Taciang Philip in nalamdang te a vawtna za uh a, a mu uh hu in a thuhil nate mite in kilomtang in phatak in ngai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Banghangziam cile doai te nangawn in au in, amate i thin-apsak mihing te sung pan pusuak uh hi: taciang pumzaw te le peangbai te zong damsak hi. ");
INSERT INTO csy_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Taciang tua khuapi sungah lungdamna lianpi om hi. ");
INSERT INTO csy_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ahihang tua mun ah Simon a kici mi khat om a, ama sia nidang in tua khuapi sungah bum le ai zang in Samaria mite bum a, ama le ama mi thupi khat in ki son hi. ");
INSERT INTO csy_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Mi theampo, a nobel pan a lianbel dong in a thu phatak in ni uh a, hisia pa sia Pathian vangletna lianpi hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Hun saupi sung bum le ai taw ngual a bum hu in, ngual in ama zakta uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ahihang Philip in Pathian kumpingam le Jesus Christ min taw kisai thu te a hil ciang in, numei zong pasal zong tui ki phum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Tuazawkciang in Simon ama tatak zong in um hi: taciang tui a ki phum zawkciang in, Philip taw ki thawl hi, taciang nalamdang le musakna a kivawtte lamdangsa mama in en hi. ");
INSERT INTO csy_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Tu in Jerusalem a om sawltak te in Samaria mite in Pathian thu sang zo uh hi, ci a zak uh ciang in Peter le John sia amate kungah paisak uh a: ");
INSERT INTO csy_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Amate a thet uh ciang in, Tha Thiangtho a nga thei natu in thungetsak hi: ");
INSERT INTO csy_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","(Banghangziam cile Tha Thiangtho sia kuama tungah theng ngawl lai hi: Topa Jesus min taw tui ki phum bek sang pheang uh hi.) ");
INSERT INTO csy_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Tuazawkciang in Peter le John in amate tungah a khut te nga uh hi, taciang amate in Tha Thiangtho sang uh uh. ");
INSERT INTO csy_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Taciang sawltak te in khutngakna tungtawn in Tha Thiangtho piakna sia Simon in a mu ciang in, sawltak te dangka pia a, ");
INSERT INTO csy_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Akuapo tungah khut ka nga ahizong Tha Thiangtho a san thei natu in, hi vangletna kei zong hong pia tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ahihang Peter in ama tung ah, na dangka sia nangma taw lalcip tahen, banghangziam cile nangma in Pathian letsong sia dangka taw lei thei tu in na ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nangma sia hi thu taw kisaina na nei bua hi: banghangziam cile Pathian mai ah na thinsung phangawl hi. ");
INSERT INTO csy_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tua ahikom hina phatngawlna pan in kisik in a, Pathian kungah thungen in, tabang hile na thinsung ngaisutna mawna hong maisak tu hi. ");
INSERT INTO csy_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Banghangziam cile nangma sia a kha mama thinkha sungah na om a, phatngawlna in hong hencip hi, ci ka he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tuazawkciang in Simon in, na son thu te theampo khat zong ka tungah hong thet ngawl natu in, Topa tungah thu hong ngetsak tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Taciang amate in Topa thuhil le tetti a pan zawk uh ciang Jerusalem ah heakkik uh a, Samaria mite khua tampi ah lungdamna thuhil uh hi. ");
INSERT INTO csy_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Taciang Topa vantungmi in Philip tung ah, ding in a, Jerusalem pan thangsang Gaza paina lampi ah paisuk in, tua mun sia senneal ngam a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Taciang Philip ding in pai hi: taciang, en in, Ethiopa mi cil ki nget khat, Ethiopia kumpinu Candace khut nuai ah za lian mama le neisa theampo a keampa sia Jerusalem ah Pathian bia tu in hongpai a, ");
INSERT INTO csy_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ama sia a ciakik lam in, siphu leang to in kamsang Isaiah laibu sim hi. ");
INSERT INTO csy_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Thaa in Philip tung ah, neakphei in a, hi siphu leang tungah ama taw paikhawm vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip sia tua pa kungah tai a, kamsang Isaiah laibu a sim za hi, taciang na sim sia na tel ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Tua pa in, mi khatpo in hong hil bua ahile, bangbang in tel thei tu khi ziam? ci hi. Taciang ama in Philip sia siphu leang tungah kato in ama taw tokhawm tu in sam hi. ");
INSERT INTO csy_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Laithiangtho a sim na mun sia, Ama sia ngaw tu in a ki paipui tuu bang a hihi; taciang a mulmet pa mai ah a ham ngawl tuuno bang in, Ama sia a kam zong ka ngawl hi: ");
INSERT INTO csy_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ki zawnsak na sungah a man ngawl in thukhenna thuak hi: taciang akua in ama suan te tungah tangko tu ziam? banghangziam cile ama nuntakna sia hi leitung pan in la uh hi, a ci na mun a hihi. ");
INSERT INTO csy_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Taciang tua cil ki nget pa in Philip zo kik a, kong thum hi, hong son tan, kamsang in akua thu son ziam? ama thu ziam, a hibale midang thu son ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tuazawkciang in Philip in a kam hong a, tua laithiangtho pan kipan in, Jesus thu dong ama tungah hil hi. ");
INSERT INTO csy_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Tabang in amate lampi dung ah a pai uh laitak in, tui omna mun ah theng uh hi: tua cil ki nget pa in, en in, hi mun ah tui om hi; tui ki phum tu bang in hong khak ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Taciang Philip in, na thinsung theampo taw na um le, ki phum thei ni hi, ci hi. Taciang ama in, Jesus Christ sia Pathian Tapa hi, ci ka um hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ama in siphu leang tawlnga tu in thupia hi: taciang a ni in tuisung ah tuaksuk uh a, Philip in ama tuiphumna pia hi. ");
INSERT INTO csy_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Taciang amate tui sung pan a pusua uh ciang in, Topa Thaa in Philip lato a, tua pa in mu kik nawn ngawl hi: taciang lungdamtak in a lampi dung ah paisuak hi. ");
INSERT INTO csy_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ahihang Philip sia Azotus khua ah, mite in mu uh hi: Caesarea a thet dong khuapi theampo ah Pathian thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Taciang Saul in Topa nungzui te that tu in nasiatak in thawmvau tawntung lai a, thiampi sang pa kungah pai in, ");
INSERT INTO csy_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ama tung pan in, Damascus synagogue te tung piak tu lai te ngen hi, tua mun ah Topa lampi zui te a mu le, numei pasal ci ngawl, hen in Jerusalem ah paipui sawm hi. ");
INSERT INTO csy_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ama a khualhaw na, Damascus hong theng dektak hi: taciang thakhatthu in van pan khuavak in a kimkot teng tan hi: ");
INSERT INTO csy_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ama sia lei ah pusuk a, Saul, Saul, banghang hong vawtsia ni ziam? ci aw za hi. ");
INSERT INTO csy_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul in, Topa awng, akua ni ziam? ci hi. Taciang Topa in, Keima sia na vawtsiat Jesus khi hi: nangma atu in a zum khat sui sia thuakhak mama hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Taciang ama ling va dil le laukawm in, Topa awng, bang hong vawtsak nuam ni ziam? ci hi. Taciang Topa in ama tung ah, Ding in a, khuapi sungah pai in, taciang na vawt hamtang tu thu kong son tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Taciang ama taw khualhaw te in aw nging za uh hinapi, mihing khat zong mu ngawl uh a hikom kamkhat zong pau ngawl in ding uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul sia lei pan tho to a; a mit a ha ciang in, mihing kuama mu ngawl hi: ahihang amate in a khut pan kai a, Damascus khua sungah paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Taciang ni thum sung khua mu ngawl a, an ne ngawl in tui zong dawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascus khuasung ah Ananias a kici nungzui khat om hi; taciang Topa in mangmuna sung pan in ama kungah, Ananias awng, ci hi. Taciang ama in, en in, Topa awng, keima hiak ah ka om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Topa in ama tung ah, Ding in a, a Tang, a kici lampi ah pai tan, taciang Judah inn ah Tarsus khuami, Saul a kici mi khat zong in: banghangziam cile, en in, ama thungen in om hi, ");
INSERT INTO csy_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Taciang ama in Ananias a kici mi khat tum a, khua a mu thei natu in, ama tungah a khut a ngak sia mangmuna sungah mu zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias in, Topa awng, Jerusalem ah na mithiangtho te kungah phat ngawlna a vawt bangza in tam ci, hisia pa thu mi tampi te tung pan in ka za zo hi: ");
INSERT INTO csy_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Taciang na min hong sam theampo hen tu in thiampi lian te tung pan thuneina nei hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ahihang Topa in Ananias tung ah, Pai in, banghangziam cile ama sia keima atu in a kiteal beal hi a, Gentile mite, kumpi te le Israel tate mai ah ka min a pua tu pa a hihi: ");
INSERT INTO csy_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Banghangziam cile keima in ama sia ka min hang in a thuak hamtang tu te bangza in lian ziam, ci sia ka lak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Taciang Ananias pai a, inn sungah tum hi; Saul tungah a khut nga a, suapui pa Saul awng, khua mu in, Tha Thiangtho taw na dim thei natu, nong pai na lampi, na tungah hong kilang Topa Jesus in hong sawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Tasia pociang in Saul i mit pan in ngasalip a kibang khat tak hi: taciang thakhatthu in khuamu hi, taciang ding a, tui ki phum hi. ");
INSERT INTO csy_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Saul sia an a neak zawkciang in, a thadim hi. Tuazawkciang in Damascus ah nungzui te taw ni tampi sung omkhawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tua zawkpo ciang synagogue sungah Christ sia Pathian Tapa hi, ci in thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ahihang a zate theampo in lamdangsa mama uh a, ama sia Jerusalem ah Jesus min a lo te theampo a susia pa hi ngawl ziam, amate a hen zawkciang, thiampi lian te kungah a paipui nop hang hi ngawl ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ahihang Saul sia thahat seseam a, Jesus in Christ a hihi, ci a pualak hu in, Damascus a om Judah mite buaisak mama hi. ");
INSERT INTO csy_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ni tampi a cin zawkciang in, Judah mite in ama that tu in kikum khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ahihang amate i pan hunlam Saul in he hi. Taciang amate in Saul that tu in kongpi te sun taw zan taw cing uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Tuazawkciang in nungzui te in Saul sia zan in paipui uh a, bawm taw luphung pan in khiasuk uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul sia Jerusalem a thet ciang in, nungzui te taw kikop sawm hi: ahihang amate in Saul sia nungzui hi, ci um ngawl in lau uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ahihang Barnabas in panpui a, sawltak te kungah paipui hi, taciang lampi ah ama in Topa mu a, Topa zong in ama paupui hi, ci le, Damascus ah Jesus min taw hangsantak in Pathian thuhil hi, ci amate tungah tangko hi. ");
INSERT INTO csy_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Taciang Saul sia Jerusalem ah amate taw sungtum le pusuak in omtek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Taciang Topa Jesus min taw hangsantak in thuhil a, Greek mite taw ki nial uhhi: tua ahikom amate in Saul that nuam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tua thu suapui te in a heak uh ciang in, Caesaria ah paipui uh a, Tarsus ah puak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tuazawkciang in Judah ngam, Galilee ngam le Samaria ngam theampo ah pawlpi te thinnopna taw kiptak in om uh hi; taciang Topa zatakna le Tha Thiangtho henepna sungah nungta in, khangto uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Peter sia mun tatuam ah khualhaw a, Lydda khua a om mithiangtho te kung theng hi. ");
INSERT INTO csy_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Tua mun ah Aeneas a kici khat taw ki mu hi, ama sia a pumzaw a, lupmun tungah kum liat sung tho thei ngawl in lum hi. ");
INSERT INTO csy_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter in ama tung ah, Aeneas awng, Jesus Christ in hong damsak hi: tho in a, na lupna zial in, ci hi. Tasia pociang in tho hi. ");
INSERT INTO csy_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Taciang Lydda le Sharon ah a om theampo in mu uh a, Topa sangah heakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tu in Joppa khua ah Tabitha a kici nungzui khat om hi. Tabitha a khiakna sia Dorcas a cinopna a hihi: hi numei in na pha tampi vawt a, mizawng tampi hu hi. ");
INSERT INTO csy_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tua ni in, ama sia a cina in thi hi: taciang amate in a luang a sil zawk uh ciang, inn tung doituam ah sial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lydda sia Joppa taw kinai ahikom in nungzui te in Peter tua mun ah om hi, ci za uh a, manlangtak in hongpai natu in, mihing sawl in sam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Taciang Peter ding in amate taw pai hi. A thet uh ciang in Peter sia inntung doituam ah paipui uh hi: tua mun ah meingong te theampo a hui ah ding in kap lialua uh a, a nuntaklai a ta laktong le puan te zong lak hi. ");
INSERT INTO csy_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter in amate pusuaksak siat a, khupdin in thu a nget zawkciang, a luang sangah kihei in, Tabitha, tho in, ci hi. Taciang a mit hong hak hi: Peter a mu ciang in, to hi. ");
INSERT INTO csy_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter in a khut thak in kaito a, mithiangtho te le meingong te a sap zawkciang in, a nungta in ap hi. ");
INSERT INTO csy_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tua thu sia Joppa khua sung theampo ah thang a; mi tampi in Topa um uh hi. ");
INSERT INTO csy_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter sia Joppa khua ah savun vawtpa Simon kungah ni tampi sung om hi. ");
INSERT INTO csy_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Caesarea khua ah Cornelius a kici khat om hi, ama sia Italy ngalkap hon, a kici ngalkap zakhat uk ngalkapmang a hihi, ");
INSERT INTO csy_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ama sia biakna sangah a kipia, a innkuan bup taw Pathian zakta khat, mizawng te huna tampi a pia, tatsat ngawl in Pathian tungah thu a ngen pa a hihi. ");
INSERT INTO csy_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nitak nai thum kiim pawl in a thiangtak in a mangmuna sungah, Pathian vantungmi khat a kungah hongpai a, Cornelius, ci in sam hi. ");
INSERT INTO csy_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Tua vantungmi laukawm in en a, bang thu ziam, Topa? ci hi. Vantungmi in, na thungetna te le mizawngte na hu nate Pathian mai ah theng a, Pathian in hong ciamte hi. ");
INSERT INTO csy_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tu in mihing pawlkhat Joppa ah paisak in, Simon Peter kici pa samsak tan. ");
INSERT INTO csy_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ama sia tuipi hui ah a teang savun vawt Simon inn ah zintung hi: hi Simon inn sia tuihui ah om a, ama in na vawt tu a kilawm te hong son tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cornelius a paupui vantungmi a heakkik zawkciang in, a naseam ni le biakna sang ki pia a, tatsat ngawl in ama a cing ngalkap khat sam hi; ");
INSERT INTO csy_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hi thu te theampo a son zawkciang in, Joppa ah paisak hi. ");
INSERT INTO csy_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A zingciang in, amate khual a haw uh laitak, Joppa a thet dektak uh ciang, Peter sia sun nai sawmleni kiim pawl in, inn tungah thungen tu in kato hi: ");
INSERT INTO csy_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Peter sia a ngil hong kial mama a, an ne nuam zo hi: ahihang amate i an neak tu a vawt laitak in mangmu hi. ");
INSERT INTO csy_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Van kihong a, puan a ki pheak kingli nei a lian mama na koina taw akibang khat leitung ama kungah hong ki khiasuk mu hi: ");
INSERT INTO csy_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","A sungah peang li nei nganhing a tatuam, sapi te, a bokvak te le van a leang vacim te om hi. ");
INSERT INTO csy_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Aw khat in ama tung ah, Peter awng; tho in, ngo in a, ne in, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ahihang Peter in, hi ngawl hi, Topa awng; banghangziam cile a nin le a thiangtho ngawl te ne ngei ngawl khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Pathian in a thianthosak te nin hi ci heak in, taciang tua aw in a nivei na son thua hi. ");
INSERT INTO csy_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Hisia thumvei dong tabang in vawt hi: taciang tua na koina sia van ah ki lato kik hi. ");
INSERT INTO csy_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Peter in hi mangmuna a mu sia a khiakna a lungman laitak in, en vun, Cornelius kung pan a kisawlte Simon inn zong in kongbiang mai ah ding uh hi. ");
INSERT INTO csy_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Taciang a sap zawkciang in, Peter a kici Simon sia hiak ah hong tung ziam, ci in dong uh hi. ");
INSERT INTO csy_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter in tua mangmuna thu a ngaisut laitak in, Thaa in, en in, mihing thum in nang hong zong hi. ");
INSERT INTO csy_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tua ahikom tho in a, tuaksuk in, bangma lungmang heak in, banghangziam cile amate sia keima i sawl a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Tuazawkciang in Peter sia Cornelius i sawl te kungah tuaksuk a, en vun, na zon uh sia keima khi hi: banghang in hongpai nu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Amate in, ngalkap zakhat uk ngalkap mangpa, mi thutang, Pathian a zakta le Judah minam theampo sungah minpha, Cornelius in Pathian kung pan kidop piakna thu theng a, a thiangtho vantungmi in ama inn ah nangma hongsawl hi, taciang namgma thuhil ngai tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Tuazawkciang in Peter in amate innsung ah sam a, amate zan taam uh hi. A zingciang in Peter sia amate taw pai khawm a, Joppa ah suapui te in zong zui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A zingciang in amate sia Caesarea ah tum uh hi. Taciang Cornelius in a mealheak te le a lawmte kaikhawm khol in ngak tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter a tum ciang in, Cornelius in muak a, a peang ah kun in bia hi. ");
INSERT INTO csy_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ahihang Peter in ama kaito a, ding in; keima zong mihing ma khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter in a paupui kawm in innsung ah tum uh a, a pai tam mama mu hi. ");
INSERT INTO csy_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Peter in amate tung ah, Judah mi khat mi namdang te taw ki thawl tu, a hibale, a kungah pai tu sia ngeina om ngawl hi, ci na he tek uh hi; ahihang khatpo sia a nin, a hibale, a thiangtho ngawl, a kici ngawl natu in Pathian in hong lak zo hi. ");
INSERT INTO csy_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tua ahikom note kungah hong sawl pociang, nial ngawl in kongpai hi: tua ahikom bang deina in hong sam nu ziam? ci kong dong hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Taciang Cornelius in, a bosa ni li lai in hi hun ciang dong an ka tang hi; nitak nai thum in ka innsung ah thu ka ngen hi, taciang, en in, puan pak sil mikhat ka mai ah hong ding a, ");
INSERT INTO csy_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Cornelius awng, na thungetna hong hong ki za zo a, mizawngte na hu nate Pathian mai ah ki ciamte hi. ");
INSERT INTO csy_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tua ahikom Peter a kici Simon sia hiak ah sam tu in Joppa ah mi sawl in; ama sia tuihui ah savun vawtpa Simon inn ah tung hi: taciang hongpai ciang in ama in thu hong hil tu hi, ci hong son hi. ");
INSERT INTO csy_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tua ahikom tasia pociang in na kungah mi hongpaisak khi hi; taciang nongpai man in pha hi. Tua ahikom tu in Pathian kung pan na thupiak theampo ngai tu in, ka vekpi in hi mun Pathian mai ah om khawm khu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Tuazawkciang in Peter in a kam hong a, Pathian sia mi doidan nei ngawl hi, a ci thuman sia ka umhi: ");
INSERT INTO csy_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ama a zakta te le thutanna a vawt minam peuma sia Pathian in sang hi. ");
INSERT INTO csy_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Na theampo i Topa: Jesus Christ tungtawn in a ki pualak kilemna thu sia Pathian in Israel te kungah paisak hi: ");
INSERT INTO csy_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tua ka son thu note in na he uh a, John in tui a phum zawk ciang Galilee pan kipan, Judah ngamsung theampo ah a tangko thu a hi; ");
INSERT INTO csy_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nazareth mi Jesus sia Pathian in Tha Thiangtho le vangletna taw sathau buak hi: napha vawt in pai a, doai i nencip te theampo damsak hi; banghangziam cile Ama sia Pathian in ompui hi, ci thu a hihi. ");
INSERT INTO csy_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kote sia Jerusalem pan kipan in Judah ngamsung ah a vawt theampo i tetti te ka hi uh hi; amate in Jesus that uh a, thing tungah khai uh hi: ");
INSERT INTO csy_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pathian in Ama sia ni thum ni ciang in thokiksak a, a kilang in lak hi; ");
INSERT INTO csy_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mi theampo tungah hi ngawl in, Pathian mai ah tealsa tetti te, thina pan a thawkkik zawkciang in Ama taw a ne le a dawn khawm kote tungah hong lak hi. ");
INSERT INTO csy_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Taciang midang te tungah phuang tu le Ama sia mihing le mithi te thukhen tu in Pathian in nasep a piak a hihi, ci tettipang tu in thu hong pia hi. ");
INSERT INTO csy_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ama a umte theampo mihing sim in ama min vangletna taw a mawna uh ki maisak tu hi, ci in kamsang theampo in son uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter in hi thu te a son laitak in Pathian thu a za te tungah Tha Thiangtho hong theng hi. ");
INSERT INTO csy_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Taciang Peter taw hongpai te theampo, vunteap tanna a umte in lamdangsa mama uh hi, banghangziam cile Gentile te tungah zong Tha Thiangtho letsong buak hi. ");
INSERT INTO csy_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Banghangziam cile amate in, kam tatuam in a pau uh za uh hi. Taciang Pathian pok uh hi. Tua zawkciang in Peter in zo kik a, ");
INSERT INTO csy_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Koma bangma in Tha Thiangtho a sang te tuiphumna sang ngawl tu in, khatpo in tui a khak thei tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Taciang Peter in Topa min taw tuiphumna sang tu in thupia hi. Tuazawkciang in amate in Peter kungah ni tampi taam tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Gentile te in zong Pathian thu sang zo uh hi, ci Judah ngamsung ah a om sawltak te le suapui te in za uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Taciang Peter sia Jerusalem ah a thet ciang in, vunteap tan te in ama nalh uh a, ");
INSERT INTO csy_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Vunteap tan ngawl te kungah na pai a, amate taw an na ne hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ahihang Peter in tua thu a kipat pan in sonkik a, a ban a ban in amate son siat hi, ");
INSERT INTO csy_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Joppa khua ah thu ka nget laitak in, ka mangmuna sungah, puanlam zai mama taw a kibang kingli nei na koina khat van pan hong ki khiasuk a, ka kungah hong theng hi: ");
INSERT INTO csy_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A tungah phatak in ka en a, ka ngaisut ciang in, a sungah leitung nganhing peang li nei a tatuam, sapi te, a bokvak te le van a leang vacim te ka mu hi. ");
INSERT INTO csy_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Taciang aw khat ka za a, Peter awng, tho in, ngo in a, ne in, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ahihang keima in, hi ngawl hi, Topa awng: banghangziam cile a nin, ahibale, a thiangtho ngawl peuma ka kamsung ah bangmahun in tum ngei ngawl hi, ka ci hi. ");
INSERT INTO csy_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ahihang van pan in tua aw in, Pathian i a thianthosak te nangma in nin hi ci heak in, ci in hong zo kik hi. ");
INSERT INTO csy_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Hisia bang in thumvei dong hong ci hi: taciang a vekpi in van ah lato kik siat hi. ");
INSERT INTO csy_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Taciang, en vun, tasia pociang in Caesarea pan hong kisawl mihing thum te ka omna mun inn ah hong theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Taciang in bangma ngaisun nawn ngawl in amate taw pai tu in Thaa in hong sawl hi. Tuabek domngawl in hi suapui luk te in hong zui uh hi, taciang Cornelius innsung ah tum tek khu hi: ");
INSERT INTO csy_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Taciang Cornelius in a innsung ah vantungmi a mu na thu hong son hi, tua vantungmi ding a a kungah, Joppa khua ah mi sawl in a, Peter a kici Simon sam in; ");
INSERT INTO csy_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ama in thu hong hil tu a, tabang in nangma le na innkuan bup in ngupna na nga tu uh hi, ci in son hi. ");
INSERT INTO csy_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Taciang thuhil ka kipan a, a kipat in kote tungah Tha Thiangtho hong thet bangma in amate tung zong ah theng hi. ");
INSERT INTO csy_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Tuazawkciang in, John in tui taw tuiphumna hong pia takpi hi; ahihang note Tha Thiangtho taw tuiphumna na sang tu uh hi, a ci Topa kammal ka phawkkik hi. ");
INSERT INTO csy_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Banghangziam cile Pathian in Topa Jesus Christ a umte tungah letsong a piak sia, kote hongpiak taw a kibang a hihi; Pathian khak zo tu in keima sia akua khi ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Amate in hi thu te a zak uh ciang in, thim khipkhep in om uh a, Pathian in Gentile mite zong nuntakna atu maw ki sikkik na pia zohi, ci in Pathian poktek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stephen thu pan vawtsiatna hang in mun tatuam ah a ki thethang te sia, Phoenicia, Cyprus le Antioch ciang dong pai uh a, Pathian thu midang te tungah hil ngawl in Judah mite tung bek ah hil uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ahihang Cyprus le Cyrene a om mi pawlkhat te in, Antioch a thet ciang in, Greek te paupui a, Topa Jesus thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Taciang Topa khut amate tungah om hi: tabang in mi tampi te in um uh a, Topa kungah hong heakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Tuazawkciang in hi thupha sia Jerusalem pawlpi dong ah hong theng hi: taciang amate in Antioch dong pai tu in Barnabas sawl uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Antioch ah Barnabas a thet ciang in Pathian i hesuakna mu a, angtang mama hi, taciang amate theampo in thinsung takpi taw Topa beal tu in hanthawn hi. ");
INSERT INTO csy_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banghangziam cile Barnabas sia mipha hi a, Tha Thiangtho le upna taw kidim hi: taciang mi tampi te Topa kungah kibelap hi. ");
INSERT INTO csy_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tuazawkciang in Barnabas sia Saul zong tu in Tarsus ah pai hi: ");
INSERT INTO csy_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A mu ciang in Antioch ah paipui hi. Ama te sia kum khat sung buppi pawlpi taw kipawlkhawm uh a, mi tampi te thuhil hi. Taciang nungzui te sia, Christian te, a kici phitbel na sia Antioch khua ah a hihi. ");
INSERT INTO csy_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tua hun sung in kamsang te sia Jerusalem pan in Antioch ah hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Amate sung pan Agabus a kici kamsang khat hong ding a, leitung mun theampo ah kialpi tung tu hi, ci in thaa in telsak hi: tua kialpi sia Claudius Caesar hun lai in tung hi. ");
INSERT INTO csy_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nungzui te in amate hi thei za tek taw Judah ngam a om suapui te hu na thak tu in khensatna nei tek uh a: ");
INSERT INTO csy_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Amate in upa te kungah Barnabas le Saul te khut tungtawn in thak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Tua hun pawl in Herod kumpipa in pawlpi sung mi pawlkhat te vawtsiat tu in man hi. ");
INSERT INTO csy_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Taciang John i suapuipa James sia namsau taw that hi. ");
INSERT INTO csy_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Hi thu in Judah mite lungkimsak hi, ci a mu ciang in, Peter zong mat thua sawm hi. Tol saw ngawl anluum poai hun sung a hihi. ");
INSERT INTO csy_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Peter a mat zawkciang in thongtaksak a, ngalkap sawm le luk tei cin tu in ap hi; paisanpoai zawkciang in mihon mai ah pusua tu in ngeal hi. ");
INSERT INTO csy_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Tua ahikom Peter sia thong sungah koi nginge hi: ahihang pawlpi te in ama atu in Pathian tungah tatsat ngawl in thungetsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Taciang Herod in a pusua tu ni zan ciang in, Peter sia ngalkap ni te ki laklaw ah thikkol ni taw hen in mu hi: a cingte in kongkha maipan in thonginn cing nginge uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","En vun, Topa vantungmi a kungah hongpai a, thonginn sungah khuavak tang hi: Peter pang pan in beang a, thosak hi, taciang manlang in tho in, ci hi. Taciang in a khut pan thikkhau te tak hi. ");
INSERT INTO csy_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Vantungmi in ama kungah, na kawngkhau kil in a, na peangdap bul in, ci hi. Taciang a son bang in Peter in vawt hi. Na puan sil in a, hong zui tan, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Peter pusuak in, vantungmi zui hi; taciang vantungmi i vawt teng sia a tatak hi, ci a he bua hi; ahihang mangmu bang in ki ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Inn doi khat na le doi ni na a kan zawkciang in, khuapi sung paina thik kongpi dong theng hi; tua thik kongpi sia amathu in kihong a: amate a puasang ah pusuak uh hi, taciang lampi khat dungzui in a pai zawk uh ciang; vantungmi in Peter nusia hi. ");
INSERT INTO csy_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter a khang hong ciim a, a tel thiang kik ciang, tu in a thiangtak in ka tel hi, Topa in Ama vantungmi sawl in, Herod khut le Judah mite lametna pan in hong suatak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Peter in hi thu a ngaisut zawkciang in, Mark a kici John nu Mary te inn ah pai hi; tua mun ah mi tampi te thungen in ki khawmtua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Taciang Peter in kongpi i kongkha a kik ciang in, Rhoda a kici naseam nu in ngai tu in pai hi. ");
INSERT INTO csy_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Taciang Rhoda in Peter aw hi, ci a heak ciang in, lungdam lei ahikom kongpi hong ngawl in, innsung ah tai hi, taciang kongpi mai ah Peter ding hi, ci in son hi. ");
INSERT INTO csy_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Amate in, mawmaw ni hi, ci uh hi. Ahihang, a tatak a hihi, ci valeng hi. Tuazawkciang in amate in, ama i vantungmi hi tu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ahihang Peter in king top lai hi: taciang amate in kongkha a hon uh ciang in, Peter mu uh a, lamdangsa mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ahihang Peter in a thim natu in a khut taw lak a, Topa in thong sung pan bangbang in pusua, ci thu amate tungah pualak hi. Taciang James le suapui te kungah pai tavun a hi thu te son tavun, ci hi. Taciang amate pusuak uh a mundang ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Khua a vak pociang Peter sia bangsuak ci thu taw kisai in ngalkap te sungah buaina lianpi hong piang hi. ");
INSERT INTO csy_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod in Peter a zon ciang in, mu ngawl a, a cing te thusit in, thalup natu thu pia hi. Taciang Herod sia Judah ngam pan pusuak a Caesarea ah pai a, tua mun ah tam hi. ");
INSERT INTO csy_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herod sia Tyre le Sidon mite tungah nasiatak in lungkim ngawl hi: ahihang amate thu kisitak in Herod kungah hongpai uh hi, taciang kumpipa lupna inndoi cingpa Blastus pawlvawt uh in, kilemna ngen uh hi; banghangziam cile amate ngam sia Herod ngam sung pan hongpai an le tui taw nungta a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","A ciangtan ni in Herod sia kumpi puan taw ki pua a, kumpi tokhum tungah to in mipi te tungah thu son hi. ");
INSERT INTO csy_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Taciang mipite in, hisia sia mihing aw hi ngawl hi, pathian aw hi, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tasia pociang Topa vantungmi in Herod vel hi, banghangziam cile ama in Pathian minthanna pia ngawl hi: ama sia than in ne a, thi hi. ");
INSERT INTO csy_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ahihang Pathian thu khang in ki zel hi. ");
INSERT INTO csy_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas le Saul sia amate nasep a man uh ciang in Jerusalem pan hong heakkik uh a, Mark a kici John hong tonpui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch pawlpi sungah, kamsang le sya pawlkhat om hi; amate sia Barnabas, Niger a kici Simeon, Cyrene khuami Lucius, ngam uk Herod taw a khang khawm pa Manaen le Saul te a hihi. ");
INSERT INTO csy_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Amate sia Topa naseam uh a, an a tan uh ciang in, Tha Thiangtho in Barnabas le Saul sia amate ka sap nathu nasep seam tu in a tuam in hong koi tuamsak tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Taciang amate antang in thu a nget zawk uh ciang, Barnabas le Saul tungah khut nga in, paisak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Tha Thiangtho in a sawl bangma in, Barnabas le Saul sia Seleucia ah pai uh a; tua mun pan in Cyprus ah tembaw taw pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Taciang amate Salamis ah a om uh laitak in, Judah te synagogue te sungah Pathian thuhil uh hi: taciang amate a hu tu in John zong om hi. ");
INSERT INTO csy_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tuikul sung theampo pai uh a, Paphos dong theng uh hi, tua mun ah mitbum thiam, leilot kamsang, Judah mi Bar-jesus a kici khat taw ki mu uh hi: ");
INSERT INTO csy_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ama sia Sergius Paulus a kici mipil ngam ukpa taw om khawm hi; tua Sergius Paulus in Pathian thu a zak nop man in Barnabas le Saul sam hi. ");
INSERT INTO csy_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ahihang a min khiakna mitbum thiam a kici Elymas in, ngam ukpa a upna pan ki khealsak tu in Barnabas le Saul te khak hi. ");
INSERT INTO csy_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Tuazawkciang in Paul zong a kici Saul sia Tha Thiangtho taw kidim in, Elymas tangtak in en a, ");
INSERT INTO csy_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Nang doaimangpa tapa, leilot thu le seksolna taw a kidim, phatngawlna theampo i ngal, Topa lampi pha te suksiatna pan in tawlnga ngawl lai tu ni ziam? ");
INSERT INTO csy_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Tu in, en in, Topa khut na tungah om hi, na mittaw tu a, a ciangtan hun sung theampo ni na mu batu hi, ci hi. Taciang thakhatthu in a tungah meikai le khuamial hong theng a; a khut pan a len tu te zong in pai hi. ");
INSERT INTO csy_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ngam ukpa in a vawt te a mu ciang in um a, Topa hilna te lamdangsa mama hi. ");
INSERT INTO csy_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Tu in Paul le a lawm te sia Paphos pan in ngunkuang taw pai uh a, Pamphylia ngam Perga theng uh hi: taciang John sia amate kung pan paikhia in Jerusalem ah cia kik hi. ");
INSERT INTO csy_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ahihang Perga pan a pai uh ciang in, Pisidia ngam Antioch theng uh a, sabbath ni in synagogue sungah tum in to hi. ");
INSERT INTO csy_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Taciang thukham le kamsang te a sim zawkciang ulian te in ngual paisak a, no u le nau te, mite atu in hanthotna kammal nei na hi uh le, son vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Taciang Paul dingto in, a khut van hi, Israel mite le no Pathian zakta te, ngai vun. ");
INSERT INTO csy_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Hi Israel mite Pathian in i pu le pa te teal a, Egypt ngam ah peamta bang in a om laitak in lamsang hi, taciang a ban sangpi taw Egypt ngam pan in pusua hi. ");
INSERT INTO csy_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Taciang senneal ngam sungah kum sawmli kiim anvak hi. ");
INSERT INTO csy_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Canaan ngam a om minam sali te a suksiat zawkciang in, amate ngam sia aisan in hawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tuazawkciang in kamsang Samuel hun hong thet ma kum zali le sawm nga sung, Pathian in thukhenmang te pia hi. ");
INSERT INTO csy_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Tuazawkciang in amate in kumpi ngen uh a: Pathian in Benjamin minam Kish i tapa Saul sia kum sawmli sung pia hi. ");
INSERT INTO csy_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saul a hepkhiat zawkciang Pathian in David sia amate kumpi tu in lamsang hi; taciang ama thu Pathian in tettipang a, ka lungtang bang a nei Jesse tapa David ka mu zo hi, ama in ka deina theampo khuangkhim tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pathian in ama kamciam bang in Israel te ngumtu David suan Jesus tungding hi: ");
INSERT INTO csy_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesus hongpai ma in John in mawna ki sikkik na taw kisai tuiphumna thu Israel mite theampo tungah hil masa zo hi. ");
INSERT INTO csy_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Taciang John in a nasep a man tu ciang in, note in keima kua nong ci uh ziam? Keima sia Ama ka hi bua hi. Ahihang, en vun, ka nung pan in khat hongpai a, a peangdap khau sutsak tu zong ka kilawm bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","U le nau te awng, Abraham tate le note sungah Pathian a zakta te, hi ngupna thu sia note tungah hong kipuak a hihi. ");
INSERT INTO csy_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Banghangziam cile Jerusalem a omte le ulian te in Jesus a heak ngawl uh hang ahizong, sabbath ni sim in a sim kamsang te kammal te zong a heak ngawl lai uh hu in, amate in Jesus mawsak in kamsang te thu tangtungsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Amate in Jesus tungah thi tak mawna a mu bua uh hi, ahihang Ama sia that tu in Pilate kungah ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Jesus thu a ki atkholsa theampo te sia amate in a tangtunsak zawk uh ciang, thing tung pan in khiasuk uh a, than ah vui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ahihang Pathian in Ama sia thina pan thokiksak hi: ");
INSERT INTO csy_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ama taw Galilee pan Jerusalem dong a pai te in, ni tampi sung mu uh a, tua te sia midang te tungah Ama i tetti te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Taciang note tungah lungdamna thupha kote in kong tangko uh hi, tua thu sia i pu le pa te tung a kivawt kamciam a hihi, ");
INSERT INTO csy_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tua thu sia Pathian in ko a tate kungah Jesus a thawkiksak na tungtawn in khuagkhimsak hi; Psalm ni na sungah, Nangma sia ka Tapa na hihi, tu ni in kong nei zo hi, ci in ki atkhol hi. ");
INSERT INTO csy_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Taciang Ama sia muat ngawl tu in thina pan a thawkik na thu taw kisai in, David i a muantak hesuakna kong pia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Mundang Psalm sung ma ah, na mi Thiangtho a muatthong tu na oai bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Banghangziam cile David in Pathian deina bang in ama hun mihing te atu na a sep zawkciang mu a, a pu le pa te kungah vui in a pumpi muat hi: ");
INSERT INTO csy_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ahihang Pathian in a thawkiksak pa sia, a pumpi muat ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tua ahikom u le nau te, hisia pa tungtawn in note tungah maw maisakna thu kong hil uh hi, ci kong hesak hi: ");
INSERT INTO csy_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses thukham tungtawn in na san thei ngawl uh thutang suana sia Jesus upna tungtawn in a um theampo na theampo pan in thutang suana nga hi. ");
INSERT INTO csy_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tua ahikom kamsang te sonkhol nate note tungah hong thet thei ngawl natu in; ");
INSERT INTO csy_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","En vun, no ngual selno thei te, lamdangsa vun a, lalcip tavun: banghangziam cile no hun sungah, ka vawt nasep sia bangbang po ahizong na um bua tu uh hi, a ci thu sia kidawm vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Taciang Judah te synagogue sung pan a pusua ciang in, Gentile mite in mai sabbath ni ciang in hi thu te hil tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Mipi te kikhop a man uh ciang in, Judah mi tampi le Judah biakna sung a tum Gentile te in Paul le Barnabas te zui uh hi: Paul le Barnabas in Pathian thuthiamna sungah om suak tu in hanthawn uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A mai nipi Sabbath ni ciang in Pathian thu ngai tu in tua khuapi sung om buppi phial hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ahizong Judah mite in mihonpi a mu uh ciang in, hazatna taw kidim uh a, Paul i thuhil nate langpan le sonsia in pau uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tuazawkciang in Paul le Barnabas te hangsan seseam uh a, Pathian thu note kong hil phot uh kul hi: ahihang note in na vawk uh a, noma le noma tawntung nuntakna nga tu kiphu ngawl in thu na khen uh hi, en vun, ko Gentile te sangah ka kihei zo uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Banghangziam cile Topa in thu hongpiakna ah, Gentile mite khuavak hi tu in, lei mong khat dong ngupna atu hi tu in kong koi zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Hi thu sia Gentile te in a zak uh ciang in, lungdam mama uh a, Topa thu poktek uh hi: taciang tawntung nuntakna nga tu in a koi sa te in um uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Topa thu sia tua ngamsung theampo ah kizel hi. ");
INSERT INTO csy_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ahihang Judah mite in biakna sang a ki pumpiak te le a zatakhuai nupi te, khuasung a om ulian te hanthawn uh hi, taciang Paul le Barnabas te nasia seseam in vawtsia uh a, amate ngamsung pan in hawlkhia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ahihang Paul le Barnabas te in a peang tung a bang leivui te thin uh a, Iconium sangah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Taciang nungzui te sia lungdamna le Tha Thiangtho taw kidim uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconium ah Paul le Barnabas te a ni in Judah te synagogue sungah paikhawm uh a, thuhil uh hi. Tabang in Judah mite le Greek mite mihon tampi in um uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ahihang a um ngawl Judah mite in Gentile mite hanthawn uh a, a um suapui te langpan nopna thinsung phangawl nei tu in vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tua ahikom amate in Topa sungah hangsantak in thuhil uh a, hun saupi sung tam uh hi, tabang in Pathian hesuakna thu tettipanna atu in musakna te le nalamdang te amate khut tungtawn in vawt thei na pia hi. ");
INSERT INTO csy_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ahihang khuapi sung a om mihonpi te kikhen uh hi: pawlkhat te in Judah mite sang pang uh a, a dang pawlkhat te in sawltak te sang pang uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Gentile mite, Judah mite le lampui te in amate selno uh a, suangtum taw sep tu in a del uh ciang, ");
INSERT INTO csy_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Amate in he uh a, Lycaonia ngamsung a om Lystra khua, Derbe khua le a kimlepam ngam te ah tai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Taciang tua mun ah lungdamna thupha hil uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra ah a khealzaw, a nu sung pan a sua pan kipan a peangbai a, a vak ngei ngawl mi khat om hi: ");
INSERT INTO csy_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Tuapa in Paul thuhilna za hi: Paul in ama sia tangtak in en a, dam natu upna nei hi, ci a heak ciang in, ");
INSERT INTO csy_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Na peang tungah a tangtak in ding in, ci in a ngingtak in sawl hi. Taciang tua pa tawn in lampai hi. ");
INSERT INTO csy_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Mihon te in Paul i na vawt a mu uh ciang in, amate Lycaonia kam taw, pathian te mihing bang in eite kungah hong tuaksuk uh hi, ci in a ngingtak in au uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Amate in Barnabas sia, Jupiter, ci uh hi; Paul sia a thuhilpi ahikom in Mercurius, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Tuazawkciang in a khua mai ah a om Jupiter thiampi in khuital le pakkual te kongpi ah paipui a, mihon te taw biakpiakna piak sawm hi. ");
INSERT INTO csy_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tua thu sawltak te, Paul le Barnabas in a zak uh ciang in, a nik le puan te eau keak uh hi, taciang mihon sungah tai kawm in au uh a, ");
INSERT INTO csy_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Banghang in hibang te vawt nu ziam? kote zong note bangma ka hi uh hi, hi a thupi ngawl nate pan in vantung, leitung, tuipi le a sung om theampo a vawt a nungta Pathian sangah kihei tu in note tungah thu ka hil uh hi: ");
INSERT INTO csy_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Abosa hun sungah Pathian in minam theampo te amate lampi tek ah paisak hi. ");
INSERT INTO csy_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ahihang Pathian in Ama le Ama sia tetti om ngawl in koithong ngawl a na pha vawt hi, van pan in nguatui le anlak hun te hongpia a, eite i thinsung te an le lungdamna taw hong dimsak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Taciang hi thu te hil uh a, mipi te in amate tungah biakpiakna vawt ngawl tu in khak zo vamial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Taciang Antioch le Iconiam ah Judah mi pawlkhat te in, mihon te hanthawn uh a, Paul sia suangtum taw a den zawk uh ciang in, thi zo sa uh a, khua puasang ah kaikeak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ahihang nungzui te a kiimkot ah a din tek uh laitak in thoto a, khuasung ah tum hi: taciang a zingciang in Barnabas taw Derbe ah pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paul le Barnabas in Derbe khua ah lungdamna thu hil uh a, mi tampi a hil zawk uh ciang in, Lystra, Iconiam le Antioch ah heakkik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Nungzui te nuntakna kipsak uh a, upna sungah om paisuak tu le Pathian kumpingam sungah haksatna tampi kantan in i tum hamtang tu hi, ci in hanthawn uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Taciang amate in pawlpi tatuam ah upa te nasep pia hi, taciang antang in thungetsak a, amate upna Topa tungah ap uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Taciang amate in Pisidia ngam sung theampo a kantan zawk uh ciang in, Pamphylia theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perga ah thu a hil zawk uh ciang in, Attalia ah pai uh hi: ");
INSERT INTO csy_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Tua mun pan in tembaw taw Antioch sangah pai uh a, Antioch ah amate sepnasa te a seam tu in Pathian i thuthiamna sungah apna a neisakna mun a hihi. ");
INSERT INTO csy_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Taciang amate Antioch a thet uh ciang in, pawlpi munkhat ah kaikhawm uh a, Pathian in amate taw a sep uh te Gentile te kungah upna kongkha a honsak na thu te son uh hi. ");
INSERT INTO csy_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Tua mun ah a nungzui te taw hun tampi omkhawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Judah ngam pan hongpai mi pawlkhat te in, Moses thukham bang in vunteap na tan bua uh le, ngupna nga thei ngawl tu nu hi, ci in suapui te hil uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Amate Paul le Barnabas taw thu kisik ngawl na le ki nial na nasia mama nei uh ahikom in, Antioch a om pawlpi te in Paul, Barnabas le mi pawlkhat te hi thudokna taw kisai Jerusalem ah sawltak te le upa te kungah then tu in khensat uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pawlpi in lamkal ah amate tha uh a, Phoenicia le Samaria kantan in pai hi, taciang Gentile te i kikhealna thu pualak uh hi: taciang suapui te theampo nasiatak in lungdamsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Amate Jerusalem a thet uh ciang in pawlpi, sawltak te le upa te in muak uh a, Pathian in amate tungtawn a vawt nate theampo son uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ahihang Pharisee te sungpan thu um pawlkhat te in Gentile thu umte sia vunteap tan kul a, Moses thukham zong zui tu in thupiak kul hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Taciang hi thu ngaisun khawm tu in sawltak te le upa te munkhat ah ki kaikhawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Thu tampi a ki nial zawk uh ciang, Peter ding a, amate tung ah, u le nau te awng, Gentile mite in keima kam pan in lungdamna thupha za uh a, a up theina tu in, tuma hiat in Pathian in eite sung pan keima hong teal hi, ci na he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Taciang thinsung a he Pathian in tettipang a, eite tungah hongpiak bang in amate zong Tha Thiangtho pia hi; ");
INSERT INTO csy_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Taciang eite le amate kilaklaw ah ki bat ngawlna bangma koi ngawl a, upna tungtawn in amate thinsung te thiangthosak hi. ");
INSERT INTO csy_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tua ahikom, tu in, i pu le pa te le eite in zong i puak zawk ngawl hakkol sia nungzui te ngawng ah koi in banghang Pathian ze-et nu ziam? ");
INSERT INTO csy_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ahihang Topa Jesus Christ i thuthiamna tungtawn in amate ngupna a nga uh bangma in eite zong i nga tu hi, ci in ka um hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tuazawkciang in Paul le Barnabas te in Gentile te sungah Pathian in amate zang in a vawt nalamdang tatuam te a son uh ciang in, mihon pi te in thim khipkhep in ngai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Amate thim khipkhep in a om zawk uh ciang in, James in, u le nau te awng, hong ngai tavun: ");
INSERT INTO csy_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ama min atu mi teal tu in Pathian in amasabel in Gentile mite tungah a pai na thu Simon in hong pualak zo hi. ");
INSERT INTO csy_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Taciang hi thu sia kamsang te kammal in zong lungkim uh a, ");
INSERT INTO csy_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Hi thu zawkciang in kong paikik tu a, a puksa David i biakbuk ka sa kik tu hi; taciang a lal sa sia kasakik tu a, ka dingsak kik tu hi: ");
INSERT INTO csy_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Tabang in a tanglai mihing te le Ama min taw a sap Gentile te theampo in Topa zong tu uh hi, ci in hi thu te theampo a vawt Topa in ci hi. ");
INSERT INTO csy_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Pathian in leitung piancil pan in a nasep theampo he siat hi, ci ki at zo hi. ");
INSERT INTO csy_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Tua ahikom keima i thukhenna sia, Gentile mite sung pan in Pathian sangah a kihei te nawngkaisak bua tawng: ");
INSERT INTO csy_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ahihang milim taw in a thiangtho ngawl te, paktat mawna, tawlsan in a kithat sa te le thisan te pial tu in lai kong thak zaw hi. ");
INSERT INTO csy_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Banghangziam cile Moses i thukham sia nidang pek pan in khua tatuam ah ki hil a, synagogue te sung zong ah sabbath nisim in ki sim tawntung hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Tuazawkciang in amate sung pan in a tealsa te, suapui te sungah a thupibel Judah a kici Barsabas le Silas te sia, Paul le Barnabas te taw Antioch ah paisak tu in, sawltak te le elder te pan kipan pawlpi buppi in lungkim uh hi: ");
INSERT INTO csy_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Taciang amate in hibang in laithak at uh a, sawltak te, elder te le suapui te in Antioch, Syria le Cilicia a om Gentile suapui te hong paupui khu hi: ");
INSERT INTO csy_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kote kung pan in mi pawlkhat te note kungah hongpai uh a, koma thupiak hi ngawl napi, vunteap na tan hamtang uh kul hi, ciang thukham zong na zui hamtang uh kul hi, ci in hong sawl na kammal in note hong nawngkaisak a, na nuntakna uh hong susia hi, ci thu ka za uh hi: ");
INSERT INTO csy_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Munkhat ah thu kisi in omkhawm tek a, ka teal uh mihing te, ka it mama uh Barnabas le Paul taw note kungah kong paisak tu uh pha ka sa uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Amate sia i Topa Jesus Christ min atu in a nuntakna dong a pia ngam te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tua ahikom Judah le Silas te kong paisak uh a, lai kong thak uh bangma in amate in a kam uh taw hongson tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Banghangziam cile note tungah hi a kisam nate simngawl a lianzaw vanngit kong sot ngawl tu uh sia Tha Thiangtho le kote in pha kasa uh hi; ");
INSERT INTO csy_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tabang in note in milim tungah na piak uh sa te, thisan, tawlsan in a kingo sa te le paktat mawna te pial vun: tabang te pan in noma le noma na ki keamcing uh le, a pha ngamta na hi uh hi. Na damtek tavun, ci in laithak at uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Tua ahikom amate a paikhiat uh ciang in Antioch theng uh hi: mihon te munkhat ah a ki kaikhop zawk uh ciang in, laithak sia pia uh hi: ");
INSERT INTO csy_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Tua laithak a sim zawk uh ciang in, henepna thu ahikom in lungdam mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Taciang Judah le Silas te zong kamsang te ahi uh bangma in, suapui te thu tampi taw hanthawn uh a, kipsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Tua mun ah tawlkhat sung a om zawk uh ciang in, suapui te kung pan sawltak te kungah thinnuam takin paisak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ahihang Silas sia tua mun ah om nuam lai hi. ");
INSERT INTO csy_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paul le Barnabas te Antioch ah omsuak a, midang tampi te taw Topa thuhil in tangko uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tawlkhat sung zawkciang in, Paul in Barnabas kungah, Topa thu i hil na uh mun khua tatuam ah suapui te ve tu in paikik tawng, bangbang in om ziam, ci en tawng, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Taciang Barnabas in Mark a kici John sia amate taw tonpui tu in ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ahihang Paul in Pamphylia pan in amate taw kikhen a, nasep na mun ah a pai ngawl hu in, amate taw tonpui tu phangawl hi, ci ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Tua thu Paul le Barnabas nasiatak in ki nial uh a, khat le khat kikhen uh hi: taciang Barnabas in Mark tonpui a, Cyprus sangah tembaw taw pai hi; ");
INSERT INTO csy_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Taciang Paul in Silas teal a, suapui te i Pathian thuthiamna sungah apna taw in pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Taciang Syria le Cilicia ngamsung theampo ah pai kakoai uh a, pawlpi te kipsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul sia Derbe le Lystra theng hi: taciang, en vun, nungzui khat om a, a min sia Timothy kici hi, a nu sia Judah mi hi a, thu um mi a hihi; ahihang a pa sia Greek mi a hihi: ");
INSERT INTO csy_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystra le Iconium a om suapui te in Timothy sia phatson mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Timothy sia Paul in tonpui nuam ahikom in a vunteap tansak hi, banghangziam cile tua kiim a om Judah mite theampo in a pa sia Greek mi hi, ci he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Amate khuapi tatuam te ah a pai uh kawm in, Jerusalem ah a om sawltak te le upa te in zui tu le kepcing tu in a khensat uh thu sia, a pai na uh khua tatuam te ah ap uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Tua ahikom pawlpi te upna sungah kho uh a, nisim in khang uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tu in amate Phrygia le Galatia ngam a kantan zawk uh ciang in, Tha Thiangtho in Asia ngam ah Pathian thuhil tu khak hi, ");
INSERT INTO csy_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mysia ngam a thet zawk uh ciang in, Bithynia ngamsung ah paisawm uh hi: ahihang Thaa in a pai tu uh oai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Taciang amate Mysia ngam kantan uh a, Troas theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Tua zan in Paul in mangmu hi; Macedonia mi khat ding a, Macedonia ah hongpai tan a, kote hong hu tan, ci in ngen hi. ");
INSERT INTO csy_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paul in a mangmu zawkpo ciang in, Macedonia ah lungdamna thupha tangko tu in Topa in hong sam hi, ci thiangtak in tel ka hi uhkom, pai tu in ka hanciam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Tua ahikom Troas pan in ngunkuang taw ka pai uh a, Samotracia ah a tangtan in ka pai uh hi, taciang a zingciang in Neapolis ka theng uh hi; ");
INSERT INTO csy_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Tua mun pan in Macedonia ngamkhen sung pan khuapi lianbel Philippi ka theng uh hi, Philippi khua sia Rome te in ngamkeak in a ukna ngam a hihi: tua khuapi sungah tawlkhat sung ka om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabbath ni in ngunhui khuapi ah ka pai uh hi, thungetna mun ah ka to uh a, hongpai numei te ka paupui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Taciang Lydia a kici Thyatira khua mi, puan sandup a zuak numei khat om a, ama sia Pathian bia khat a hihi: ama in Paul i thuhilna te ngai tu in Topa in a thinsung honsak hi. ");
INSERT INTO csy_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ama le a innkuanpui te tui a ki phum zawk uh ciang in, Topa tungah muantak hi, ci in nong mu uh ahile, ka inn ah hongpai tavun a, tua mun ah hong taam tavun, ci in hong sam a, hong thum hi. ");
INSERT INTO csy_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Thungen tu ka pai uh ciang in, a sungah maisang thu sonkhol theina thaa nei a, a to te atu in dangka tampi a ngasak naseam numei no khat in hong muak hi: ");
INSERT INTO csy_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ama in Paul le kote nung pan in hongzui a, hi mite sia ngupna lampi hong lak tu a sangbel Pathian i sal te a hi uh hi, ci in au hi. ");
INSERT INTO csy_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Taciang ama in hibang in ni tampi sung vawt hi. Ahihang Paul a thin-uk in le-et a, tua thaa kungah, Jesus Christ min taw hi numei sung pan pusuak tu in thu kong pia hi, ci hi. Tuahun laitak lian in pusuak hi. ");
INSERT INTO csy_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","A to te in dangka tampi nga natu lametna om nawn ngawl hi, ci a mu uh ciang in Paul le Silas te man uh a, thukhen zum ulian te kungah kai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Taciang ulian te kungah paipui a, hi Judah mite in i khuapi nasiatak in buaisak hi, ");
INSERT INTO csy_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ko Rome mite in ka san thei ngawl uh le ka zui ngawl uh ngeina te hil hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Taciang mihonpi te hong ding tek uh hi: taciang ulian te in zong a puan uh eaukeaksak uh a, Paul le Silas te vel tu in thupia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Amate in nasiatak in a sat zawk uh ciang in, thonginn sungah khia uh a, thong cing pa in phatak a cin natu in vaitha hi: ");
INSERT INTO csy_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Thu a vaithak thonginn cingpa in, thonginn doi sungah khumsuk a, a peang te uh peangkol bul in koi hi. ");
INSERT INTO csy_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Zan laitak in Paul le Silas te thungen uh a, Pathian pok na lasa khawm uh hi: taciang thongtak te in ngai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Thakhatthu in zin nasiatak hong ling a, thong innbul te ki lok hi: tasia pociang in kongkha te a vekpi in ki hong siat a, a ki hen na uh theampo zong ki sut siat hi. ");
INSERT INTO csy_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Thongcingpa hong khanglo a, kongkha te a ki hong a mu ciang in, thongtak te taisiat zo sa a, a namsau dok in, ama le ama ki tha sawm hi. ");
INSERT INTO csy_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ahihang Paul ngingtak in au a, nangma le nangma ki vawtsia heak in: banghangziam cile ka vekpi in hi mun ah ka om nginge uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tuazawkciang in thongcingpa in mei ngen a, hong bingbung hi, taciang ling vadil kawm in hongpai a, Paul le Silas te mai ah bok hi, ");
INSERT INTO csy_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Taciang amate pusua a, ka topa te awng, ngupna ka nga natu in bang ka vawt tu ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Amate in, Topa Jesus Christ um in a, nangma le na innkuanpui te in ngupna na nga tu uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Taciang Paul le Silas te in ama innsung ah a omte theampo tungah Topa thuhil uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Tua zan in thongcingpa in amate pusua a, a liamma uh te silsak hi; taciang ama le a innkuanpui theampo tui ki phum pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Saul le Silas sia ama inn ah ciapui a, amate mai ah anlui hi, taciang ama le a innkuanpui theampo in Pathian um uh a, lungdam mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","A zingciang in, ulian te in palik mang te sawl a, tua mihing te pusua vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Taciang thongcingpa in Paul kungah, ulian te in note sam tu in mi sawl hi; tua ahikom tu in pusuak vun a, thinnuamtak in pai vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ahihang Paul in amate tung ah, kote sia Rome ngammi hi napi, mawsiatna om ngawlpi kilangtak in hong sat a, thong hong taksak hi; tu in kuama heak ngawl in hong hawlkhia nuam ziam? hi thei ngawl hi; ahihang amate hongpai ta hen a hong suatak tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Taciang palik mang te in hi thu a ulian te kungah son uh hi: taciang amate Rome ngam mi hi, ci a zak uh ciang in, ulian te patau mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Taciang amate hongpai uh a, Paul te thum uh hi, taciang suatak uh a, tua khuapi sung pan pusuak tu in sawl uh hi. ");
INSERT INTO csy_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Amate thong sung pan pusuak uh ah, Lydia te innsung ah tum uh hi: taciang suapui te a mu uh ciang in heneam uh a, paikik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paul le Silas te Amphipolis le Apollonia a kantan zawk uh ciang in, Thessalonica theng uh hi, tua mun ah Judah te synagogue om hi: ");
INSERT INTO csy_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Taciang Paul sia ama ngeina bang in, synagogue sungah tum a, sabbath ni nithum sung amate taw laithiangtho sung thu te kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Christ sia a thuak kul hamtang a hina le thina pan thokik hamtang tu hi; ci in note tungah ka pualak hi Jesus sia Christ a hihi, ci in pualak in hil thiang hi. ");
INSERT INTO csy_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Amate sung pan pawlkhat te in um uh a, Paul le Silas te kipawlpui uh hi; taciang tua te sungah biakna sang a kipumpiak Greek mihon tampi le numei lampui tampi kihel uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ahihang a um ngawl Judah mite in haza uh a, van zuakna lamdung a vakvai mannung ngawl mite sam uh hi, taciang honpi khat hong pha uh a khuapi sungah buaina piangsak uh hi, taciang Jason i inn sim uh a, mipi mai ah pusua tu in zong uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Taciang amate in a mu ngawl uh ciang in, Jason le suapui pawlkhat te khuapi ulian te kungah kai uh a, hileitung lumlet te himun zong ah hongpai uh hi; ");
INSERT INTO csy_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Amate sia Jason in ama inn ah tungsak hi: hi te theampo in Caesar thupiakna te langpan uh a, Jesus a kici a dang kumpi khat om hi, ci uh hi, ci in au lialua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Hi thu te mipi te le khuapi ulian te in a zak uh ciang in, buai mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Taciang Jason le a dang te sia a kisam za dangka liausak uh a, tua zawkciang in thaa kik uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Zan ciang in suapui te in Paul le Silas te Berea ah a zan a zan in paisak uh hi: tua mun a thet uh ciang in Judah mite i synagogue sungah tum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Hi te sia Thessalonica mite sang in a thinsung uh phazaw hi, thalawptak in thu ngai uh a, tua a ngai uh thu te a man le man ngawl nisim laithiangtho sungah zong uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Tua ahikom amate sung panmi tampi in um uh a; a zatak huai Greek nupi pasal tampi zong kihel uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ahihang Thesslonica a om Judah mite in Berea khua ah zong Paul in Pathian thuhil hi, ci a heak uh ciang in, hongpai uh a, mipi te thawn uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Tua zawk pociang in suapui te in Paul sia tuipi sangah paisak uh hi: ahihang Silas le Timothy sia Berea ah taamlai hi. ");
INSERT INTO csy_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Paul a tha te in Athens dong tha uh hi: taciang Silas le Timothy sia manlangtak a pai natu in Paul kung pan thupiak nga uh a, pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul in Athen pan Silas le Timothy te ngak in a om laitak, tua khuapi sungah milim biakna bebek om hi, ci a mu ciang in, a thinsung sutha mama hi. ");
INSERT INTO csy_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tua ahikom Judah biakna lampui te taw synagogue sungah thu ki nial uh a, vanzuakna ah a kisikpui te taw nisim in ki nial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Tuazawkciang in thu ngaisun thiam Epicurean te le Stoic te taw ki mu uh hi. Taciang pawlkhat te in, hi a papau sia bang son ziam? a dang pawlkhat te zong in, hisia pa sia ngamdang te pathian te thu son hi tu hi, ci uh hi: banghangziam cile Paul in amate tungah Jesus le a thawkikna thu son hi. ");
INSERT INTO csy_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Taciang amate in Paul man uh hi, taciang Areopagas ah paipui uh a, hi hilna thak na son te kote zong ka heak tu uh kisam ziam? ");
INSERT INTO csy_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Banghangziam cile a tumdang te ka bil uh ah nong zasak hi: hi thu te i deina sia bangziam, ci ka he nuam uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Banghangziam cile Athen mite le leangna te theampo in thuthak son tu, a hibale ngai tu simngawl bangma dang atu amate hun a zang bua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Tuazawkciang in Paul sia Mars mual laizang ah ding a, no Athen mite, note sia na theampo nasiatak thuciing cimteam mama te na hi uh hi, ci kong he hi. ");
INSERT INTO csy_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Banghangziam cile ka vakawm in biakna sang na hanciam nate uh ka en a, a ki he ngawl pathian atu ci a ki at biaktau khat ka mu hi. Tua ahikom note in he ngawlpi in na biak uh Pathian thu kong pualak hi. ");
INSERT INTO csy_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Tua Pathian sia leitung le a sung om theampo a vawtpa a hihi, ama sia van le lei i Topa hi a, khut taw a kisa biakinn sungah om ngawl hi; ");
INSERT INTO csy_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Pathian sia mi theampo tungah nuntakna, husanna le na theampo a piapa ahikom, mihing te khut taw i vawtsak tu bangma kisam ngawl hi; ");
INSERT INTO csy_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Taciang Ama in leitung theampo ah a om minam theampo sia thisan khat in vawt a, amate om tu hun te le a om natu mun te zong ngealkholsak siat hi; ");
INSERT INTO csy_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tabang in amate in Topa zong uh a, tham in a mu thei natu a hihi, Pathian sia eite khatsim kuama taw ki khuala ngawl hi: ");
INSERT INTO csy_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Banghangziam cile i nungta a, i tuk i dian le i hina theampo sia Ama sungah a hihi; tasia bangma in na laphuak te in zong, eite zong Ama suan te i hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tabang in Pathian suan te i hi man in, mihing te khutthiam le ngaisutna taw a kivawt kham, ngun le suangtum milim bang in Pathian sia i ngaisut tu hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Mihing te in Pathian a heak ma hunlai in Pathian in a mu ngawl bang in omthong ngei napi; tu in mun theampo ah a om mi theampo maw ki sikkik natu in thupia hi: ");
INSERT INTO csy_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Banghangziam cile nasep a piaksa mihing khat zang in leitung ah thutang suana tungtawn thu a khen tu ni ciangtan zo hi; tua thu sia a ma a hihi, ci in mi theampo tungah kilangsak tu in tua pa sia thina pan thokiksak zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Amate in mithi te thawkikna thu a zak uh ciang in, mi pawlkhat te in selno uh hi: a dang te in, hi thu nangtung pan ka za kik nuam uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Taciang Paul sia amate sung pan in pusuak hi. ");
INSERT INTO csy_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ahihang mi pawlkhat te in ama beal uh a, um uh hi: tua te sungah Areopagas mi Dionysius, Damaris a kici nupi khat le midang te zong kihel uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Hiteng zawkciang in Paul sia Athens pan pai a, Corinth theng hi; ");
INSERT INTO csy_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Taciang Aquila a kici Judah mi khat taw ki mu hi, ama sia Pontus ah a suak hi a, a zi Prisilla taw Italy pan a thet zawk uh ngei ngawl lai hi; banghangziam cile Claudius in Judah mi theampo Rome pan pusuak tu in thupia hi: taciang Paul sia amate kungah hongpai hi. ");
INSERT INTO csy_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Amate taw khutthiam kibang ahi uhkom in amate kungah taam a, naseam khawm uh hi: banghangziam cile amate sia puanbuk khui te a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Sabbath ni sim in synagogue sungah Judah mite le Greek mite thu sonpui in kaizawn tawntung uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Macedonia pan Silas le Timothy te a thet ciang in, Jesus sia Christ hi, ci thu Paul in Judah mite tungah hanciam in tettipang hi. ");
INSERT INTO csy_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Amate in Paul langpan uh a, a sonsiat uh ciang in, Paul in a puan thin a, na thisan uh noma lutung ah om tahen; kei ka hile na thisan uh pan ka thiang hi: tu pan kipan in Gentile te kungah ka pai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Taciang Paul sia tua mun pan pai a, Justus innsung ah tum hi, ama in Pathian bia a, a inn sia synagogue taw kinai na a hihi. ");
INSERT INTO csy_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Synagogue makai lianbel Crispus le a innkuanpui theampo in Topa um uh hi; taciang Corinth mi tampi te in zong za in um uh a, tui kiphum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Tuazawkciang in Topa in mangmuna taw zan ciang inb Paul paupui a, Lauheak in a, thuhil in, om thong heak in: ");
INSERT INTO csy_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Banghangziam cile keima in kong ompui hi, kuama in hong vawtsia ngawl tu hi: banghangziam cile hi khuapui sungah keima in mi tampi ka nei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Taciang Paul sia tua mun ah kumkhat le tha luk sung om suak a, amate sungah Pathian thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallio sia Rome ngam uk a sep lai in, Judah mite in thu kisitak in Paul langpan uh a, thukhenna tokhum mai ah paipui uh a, ");
INSERT INTO csy_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Hisia pa in thukham paltan in Pathian bia tu in ngual kaizawn hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul pau tu a kipat ciang in, Gallio in Judah mite kungah, hi thu sia a man ngawl le thusia hile, Maw, no Judah mite, note tungah thinsausak tu kisam ci in ngaisun khi hi: ");
INSERT INTO csy_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ahihang hi thu sia na thukham uh sung a thu le min te ki nialna ahile, noma in khensat tawm vun; banghangziam cile kei sia tabang thu te tungah thukhen ngawl tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Taciang amate thukhen zum pan in hawlkhia siat hi. ");
INSERT INTO csy_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tuazawkciang in Greek mite in synagogue makai lianbel Sosthenes man uh a, thukhen na mai ah sat uh hi. Taciang Gallio in hi thu te awlmawk ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Taciang in Paul sia Corinth khua ah tawlkhat sung a om zawkciang in, suapui te nusia a, Pricilla le Aquila te taw Syria ah tembaw taw pai hi; taciang Cenchrea ah a sam met hi: banghangziam cile kamciam na a nei hang a hihi. ");
INSERT INTO csy_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ephesus khua theng uh a, tua mun ah Pricilla le Aquila te nusia hi: ahihang ama vateak synagogue sungah tum in, Judah mite taw thu kikum khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Amate in ngei zaw hiat om tu a nget uh ciang, thukim pui ngawl hi; ");
INSERT INTO csy_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ahihang kikhenna kam te nusiat a, Jerusalem ah hi poai sia bangbangpo ahizong ka kihel kul hamtang hi; ahihang Pathian deina a om ahile, note kungah heakkik tu khi hi, ci hi. Taciang Ephesus pan in tembaw taw pai hi. ");
INSERT INTO csy_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Caesarea a thet ciang in, pawlpi te paupui a, Antioch sangah pai hi. ");
INSERT INTO csy_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Tua mun ah tawlkhat sung hun a zak zawkciang in pusuak kik a, nungzui te theampo hanthawn tu in Galatia le Phrygia ngamsung theampo ah pai hi. ");
INSERT INTO csy_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Taciang Alexandria khua ah a suak Judah mi Apollos a kici khat Ephesus ah hong theng hi, ama sia kamthiam mama a, laithiangtho taw kisai zong thahat mama hi. ");
INSERT INTO csy_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Hisia pa sia Topa lampi taw kisai phatak a kihil mi a hihi; taciang thaalam ah thalawp mama a, Topa thu te thupitak in a son le a hil pa a hihi, ahihang John i tuiphumna thu bek he hi. ");
INSERT INTO csy_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Taciang synagogue sungah hangsantak in thuhil kipan a: Aquila le Pricilla te in a zak uh ciang in, amate kungah sam hi, taciang Pathian lampi a kimtak in hilcian hi. ");
INSERT INTO csy_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollos sia Achaia ngamkhen ah pai nuam ahikom, Ephesus khua a om suapui te in Achaia a om nungzui te kungah lai thak uh a, Apollos a san natu uh in hanthawn uh hi, a thet ciang in thu um mite sia hesuakna tungtawn in nasiatak in hu hi: ");
INSERT INTO csy_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Banghangziam cile Jesus sia Christ hi, ci thu laithiangtho zang in a kilangtak in lak a, Judah mite nasiatak in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos sia Corinth khua ah a om laitak in, Paul in saksang ngam te kantan a, Ephesus hong theng hi: tua mun ah nungzui pawlkhat te taw kimu uh a, ");
INSERT INTO csy_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Amate kungah, na up zawk uh Tha Thiangtho na sang zo uh ziam? ci hi. Taciang amate in Paul tung ah, Tha Thiangtho a om hunlam zong ka za ngei bua uh hi, ci uh ih. ");
INSERT INTO csy_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Taciang Paul in amate tung ah, bang tuiphumna sang nu ziam? ci hi. Taciang amate in, John i tuiphumna ka sang uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Tuazawkciang in Paul in hibang in ci hi. John in mawna ki sikkikna tuiphumna hongpia takpi a, mite tungah a nung pan hongpai tu Christ Jesus sia amate in a up tu uh a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Amate in hi thu a zak uh ciang in, Topa Jesus min taw tui ki phum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Taciang Paul in amate tungah a khut a ngak ciang in, Tha Thiangtho sia amate tungah hong theng hi; taciang kam tatuam taw in pau uh a, mailam thu zong pualak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Amate a vekpi in pasal sawmleni khawng a hi uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paul sia synagogue sungah tum a, Pathian kumpingam thu taw kisai in thuhil le hanthawn in, tha thum sung hangsantak in thuhil hi. ");
INSERT INTO csy_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ahihang pawlkhat te a thinsung khauh uh a um ngawl in, mipi mai ah tua lampi phat ngawlna thu son uh hi, taciang Paul sia amate kung pan pusuak a, nungzui te tuamkhen in Tyrannus sanginn khat sungah nisim in thu kikum khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Hi bangin kum ni sung zomsuak uh hi; tua ahikom Asia ngamsung a om Judah mite le Greek mite theampo in Topa Jesus thu za kim uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pathian in Paul i khut te zang in a tuan in nalamdang te vawt hi: ");
INSERT INTO csy_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ama pumpi pan in dialno le kawngkhau te cina te kungah paipui uh a, cina te sung pan in natna te le doai te pusuak hi. ");
INSERT INTO csy_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Mun theampo ah vak a thaa ngilo a hawlkhia Judah mi pawlkhat om hi, thaa ngilo a neite tungah Topa Jesus min lo uh a, Paul i a hil Jesus tungtawn in thu hong pia khu hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Judah mi thiampi lian Sceva tapa sali te in tabang in vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Taciang tua thaa ngilo in, Jesus ka he hi, taciang Paul zong ka he hi; ahihang note a kuate nu ziam? ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Taciang a sungah thaa ngilo a neipa sia amate tungpan baw in buan ngawp a, zothal hi, tua ahikom amate tua innsung pan pumnguak le liamma taw tai mang uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Taciang hi thu sia Ephesus a om Judah mite le Greek mite theampo in he uh hi; taciang amate tungah launa hong theng a, Topa Jesus min pok tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Thu um tampi te hongpai uh a, amate mawna te pualak in a sep a vawt uh te zong pholak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Mitbum thiam tampi te zong a laibu te uh munkhat ah hong paipui uh a, mi theampo mai ah mei taw hal uh hi: tua laibu te i man a tuat uh ciang in, ngun dangka then nga man hi. ");
INSERT INTO csy_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tua ahikom Pathian thu in zo a nasiatak in khang uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Hi thu te a tawp zawk, paul in Macedonia ngam le Achaia ngam te a kantan zawkciang in, Jerusalem ah pai tu in ngealkhol hi, tua mun ah ka thet zawkciang in Rome zong mu hamtang lai tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Tua ahikom ama a hu tu te sung pan in, Timothy le Erastus te sia Macedonia ah heakkik uh a; ama sia Asia ngamsung ah tawmvei sung om lai hi. ");
INSERT INTO csy_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Tua hun in hi lampi thu hang in buaina lianpi piang hi. ");
INSERT INTO csy_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Banghangziam cile ngun seak thiam Demetrius a kici pa in Artimis doai numei atu in biakinn lim te ngun taw in vawt a, khutthiam neite kungah a met tam mama then hi; ");
INSERT INTO csy_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Tua a nasep kibang naseam te kaikhawm a, hi khutthiam tungtawn in hau na i nga hi, ci na he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Tua bekdom ngawl, Ephesus bek ah hi ngawl in, Asia ngamsung bup dektak ah, hi Paul in khut taw a ki vawt te Pathian hi ngawl hi, ci a, mi tampi te hanthawn in kikhealsak hi, ci zong mu in na za uh hi: ");
INSERT INTO csy_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tua ahikom i khutthiam sia mannung ngawl a sua tu lauhuai bek domngawl in; Asia ngam theampo le leitung bup i biak Artemis doai nu i biakinn zong ki thusimngawl tu hi, taciang a minthanna susia tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Taciang hi thu te amate in a zak uh ciang in thin-uk na taw kidim uh a, Ephesus mite i Artemis sia thupi hi, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Taciang tua Khuapi sia buaina taw kidim hi: Paul i khualhaw pui Macedonia mi Gaius le Aristarchus te man uh a, poai etna sungah thukimtak in manlangtak in tum tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul sia mihon te kungah a tum sawm ciang in, nungzui te in oai ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Taciang Asia ngam ukpa i lawm te zong poai etna sungah tum ngawl tu in a kungah ngual sawl in, ngen hi. ");
INSERT INTO csy_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tua ahikom pawlkhat te in thu khat au uh a, a dang pawlkhat te in thudang au uh hi: banghangziam cile a tamzaw in banghang in ki kaikhawm, ci he ngawl in, mihonpi te buai mama hi. ");
INSERT INTO csy_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Judah mite in Alexander sia mipi sung pan in kaikeak a, mai ah sawn uh hi. Taciang Alexander in a khut taw lak a, mipi te kungah ama le ama ki ngum in thuson nuam hi. ");
INSERT INTO csy_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ahihang amate in Alexander sia Judah mi hi, ci a heak uh ciang in, Ephesus mite i Artemis sia thupi hi, ci in a vekpi in nai ni sung aw khat sua in au va nuau uh hi. ");
INSERT INTO csy_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Taciang khuapi lai-at pa in mipi te a thim zawkciang in, no Ephesus mite, Ephesus khuapi sia a lian mama Artemis doai nu Jupiter pan in hong tak milim bia hi, ci a he ngawl a kua om ziam? ");
INSERT INTO csy_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Hi thu te sia kuama i nial thei ngawl thu ahikom in, na om khipkhep tu uh hi a, bangma ngaisun ngawl in na pheang tat tu uh hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Banghangziam cile hi mun ah na paipui uh hi te sia, pawlpi van a suttol te hi ngawl a, na doai nu uh mindaisak te zong hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Tua ahikom Demetrius le khutthiam nei te khatpo taw ki langpan in thu a om ahile, thukham sia a ki hong sa in om hi, taciang ngam uk te zong om ahikom in: amate khat le khat thu ki sua khawm ta uh hen. ");
INSERT INTO csy_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ahihang thu dang te taw kisai in na kan nuam uh le, ngeina bang in a ki kaikhawm mipi te in khensat tahen. ");
INSERT INTO csy_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Banghangziam cile tu ni i buaina hang in thu dong tu in hong sap tu lauhuai hi, hibang ngeina om ngawl in i kikhoptua na sia a hang son tu le i nei tuan bua hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hibang in a son zawkciang, a ki kaikhawm te ciakik siat uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Buaina a bo zawkciang, Paul in nungzui te a kungah sam a, a koai zawkciang in, Macedonia ah pai tu in pusuak hi. ");
INSERT INTO csy_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Tua ngamsung mun tatuam te ah pai a, thu tam mama taw hanthawn in tha a piak zawkciang, Greece ngam theng hi, ");
INSERT INTO csy_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tua mun ah tha thum sung om hi. Syria ah tembaw taw a paisawm ciang in, Judah mite in pang ahikom in Macedonia pan heakkik tu in ngeal hi. ");
INSERT INTO csy_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Asia ngamsung a pai ciang in Berea khua mi Sopater; Thessalonica khua mi Aristarchus le Secundus; Derbe khua mi Gaius le Timothy, Asia ngam pan Tychicus le Trophimus te in tonpui hi. ");
INSERT INTO csy_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Amate ka mai ah pai masa uh a, Troas pan hong ngak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tol saw ngawl anluum poai ni zawkciang in, Philippi pan in tembaw taw ka pai uh a, ni nga sung ka pai zawk uh ciang amate kung Troas ka theng uh hi, tua mun ah ni sali sung ka om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nipi kalkhat sung ni masabel ni in, nungzui te anluum bal tu in a ki kaikhop uh ciang, Paul in amate tungah Pathian thuhil a, a zingciang pai tu hi zo ka hi uhkom in; zankim dong thuhil suak hi. ");
INSERT INTO csy_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Amate kikhopna mun inn tung doi ah mei-inn tam mama om hi. ");
INSERT INTO csy_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Taciang Eutychus a kici tangval khat a to kawm in, a mutsuak mama hi: taciang Paul in ngei mama thuhil ahikom, lusu in inn dawl thum na pan taksuk a, a thisa in tawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Taciang Paul tuaksuk in, tangval pa tungah bok hi, taciang koai a, Paul in buai heak vun, banghangziam cile a sungah a nuntakna om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Taciang Paul inn tung a kato kik ciang in, anluum balnen uh a, ne khawm uh hi, khuavak dong ngei mama thu a sonkhop zawkciang in Paul pai hi. ");
INSERT INTO csy_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Amate in tangval pa a nungta in hong paipui uh hu in, amate a thin uh nuam mama hi. ");
INSERT INTO csy_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paul muak kawm tu in tembaw taw Assos ah ka pai uh hi: banghangziam cile ama in peang taw pai tu ngaisun ahikom, hong sonkholsa a hihi. ");
INSERT INTO csy_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Assos ah Paul taw ka ki situa uh a, ama ka muak uh hi, taciang Mitylene ka theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Tua mun pan in tembaw taw ka pai khawm leleau uh a, a zingciang in Chios ngalkhat ka theng uh hi; taciang a zingciang in Samos ka theng uh a, Trogyllium ah ka ngiak uh hi; taciang a zingciang in Miletus ka theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Banghangziam cile Paul in Asia ah hun zang ngawl tu le Ephesus pan tembaw taw pai tu in ngeal hi: banghangziam cile a suak thei tu ahile, Pentecost ni in Jerusalem ah manlang in theng nuam hi. ");
INSERT INTO csy_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Taciang Miletus pan in Ephesus ah mi paisak in, pawlpi upa te samsak hi. ");
INSERT INTO csy_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Amate a thet ciang in, Paul in amate tung ah, Asia ngamsung ka thet masabel pan in, note kung ka om sung theampo bangbang in ka om, ci sia na heak uh a hihi, ");
INSERT INTO csy_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Thinsung kiniamkhiak le thitui tampi taw Topa na ka seam hi, taciang Judah mite in hong pang tawntung uh ahikom ka tungah mawsiatna te hong theng hi: ");
INSERT INTO csy_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Taciang note tungah phattuamna khat zong khet nei ngawl khi hi, ahihang mihonpi te mai ah ahizong, inn khat zawk inn khat ah ahizong, hong lak in hong hil khi hi, ");
INSERT INTO csy_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Judah mite le Greek mite tungah zong, Pathian tungah mawmaina le i Topa Jesus Christ tungah upna thu tetti ka pang hi. ");
INSERT INTO csy_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Tu in, Jerusalem ah pai tu in Thaa in hong hen a, ka tungah bang thu piang tu, ci zong ka he bua hi: ");
INSERT INTO csy_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ahizong khuapi tatuam ah hencip le haksatna te in hong ngak hi, ci Tha Thiangtho in tettipang hi. ");
INSERT INTO csy_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ahihang Topa Jesus kung pan ka san Pathian thuthiamna lungdamna thupha tetti pan nasep sia, lungdamna taw ka zaw thei natu in, hi thu te in hong lingsak zo ngawl a, ka nuntakna zong pamai ka sa bua hi. ");
INSERT INTO csy_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Taciang tu in, en vun, Pathian kumpingam thuhil in ka pai na mun theampo ah note in ka maitang nong mu kik nawn ba tu uh hi, ci ka he hi. ");
INSERT INTO csy_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Tua ahikom mi theampo i thisan pan in ka suakta hi, ci in tu ni note tungah tetti kong pang hi. ");
INSERT INTO csy_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Banghangziam cile Pathian i tupna a vekpi in note tungah ka pualak tu khet ka nei bua hi. ");
INSERT INTO csy_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tua ahikom Ama thisan taw a lei sa, Pathian pawlpi an vak tu le keamcing tu in Tha Thiangtho in a koi sa note atu in ahizong, tuu hon theampo atu in ahizong, kidawm tavun. ");
INSERT INTO csy_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Banghangziam cile ka pai zawkciang in ngia ngilo te note sungah hong tum tu a, tuu hon te khoaikhe ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Noma sung mama pan in pawlkhat te pusuak tu uh a, nungzui te kaizawn tu in a man ngawl thu te son tu uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Tua ahikom en vun, kum thum sung tawntung sun le zan tawlnga ngawl in thitui taw mi theampo kidop natu thu ka hil hi, ci phawk tawntung tavun. ");
INSERT INTO csy_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Tu in, suapui te awng, Pathian le Ama thuthiamna kammal kong ap hi, Ama in hong khangtosak zo tu a, mithiangtho te theampo sungah ngamh hong pia tu hi. ");
INSERT INTO csy_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Kuama i puansil nikten, le kham le ngun te ka eang bua hi. ");
INSERT INTO csy_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Hi ka khut taw keima le ka ompuite kisapna atu in na ka seam hi, ci sia note in na he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Tabang in note in zong keima bang naseam a, thaneam te na hu uh kul hi, ci le, Nga na sang in piak na ah thupha tamzaw hi, ci Topa Jesus i son kammal te na phaw tawntung natu uh in hi thu te theampo a vekpi in kong laksiat zo hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul in a thuson man ciang in khupdin a, amate theampo taw thungen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Taciang amate theampo nasiatak in kap uh a, Paul ngawngkoai in nam uh hi, ");
INSERT INTO csy_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Kuama in a maitang mu nawn ngawl tu, ci a kammal hang in khuangai tuansap uh hi. Taciang amate in tembaw kung dong tha uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Amate kung pan ka pai uh ciang in, tembaw taw a tangtan in ka pai uh a, Coos ka theng uh hi, a zingciang in Rhodes ka theng uh a, tua mun pan in Patara ka paisuak uh hi: ");
INSERT INTO csy_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Phoenicia pai tu tembaw ka mu uh a, a sung ka tum zawk uh ciang ka pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Cyprus ka mu uh ciang in veisang ka zuan uh a, Syria sangah ka pai uh hi, taciang Tyre ah ka tawlnga uh hi: banghangziam cile tua mun ah tembaw i puak van te khia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Taciang nungzui te taw ka kimu uh a, ni sali sung ka taam uh hi: amate in, Paul sia Jerusalem a pai tu hi ngawl hi, ci in Thaa tungtawn in son hi. ");
INSERT INTO csy_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tua hun teng zawkciang in, ka pusuak kik uh a, ka paisuak uh hi; taciang amate a vekpi in a zite le a tate uh taw, khuapi puasang dong hong tha uh a: tuihui ah khupdin in thu ka ngen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Taciang khat le khat ka kikhen zawk uh ciang, tembaw sung ka tum uh a, amate zong inn sangah cia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyre pan in khualhaw ka man uh ciang in Ptolemais ka theng uh hi, taciang suapui te ka paupui uh a, amate taw ni khat sung ka om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A zingciang in koma Paul le a lawmte ka pai uh a, Caesarea ka theng uh hi: taciang thupha puak Philip innsung ah ka tum uh a, ka taam uh hi, Philip sia upa sali sung pan khat a hihi. ");
INSERT INTO csy_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Taciang Philip in tanu li nei hi, amate sia ngaknu thiangtho te hi a, mailam thu pualak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Tua mun ah ni tampi sung ka taam uh hi, tua mun ah Judah ngam pan in Agabus a kici kamsang khat hong theng hi. ");
INSERT INTO csy_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Taciang ka kung uh ah hongpai ciang in, Paul i kawngkhau la a, ama khut le peang te hen hi, taciang, hi kawngkhau neipa sia Judah mite in Jerusalem ah hen tu a, Gentile mite khut sungah ap tu hi, ci in Tha Thiangtho in ci hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Hi thu ka zak uh ciang in, koma le tua mun a omte in Paul sia Jerusalem pai ngawl tu in ka thum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Tuazawkciang in Paul in, banghang in kap in ka thin hong nosak nu ziam? banghangziam cile ki hen tu bek hi ngawl, Jerusalem ah Topa Jesus min hang in thi tu zong ka ki nging khol zo hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Taciang ka sonpui zawk ngawl uh ciang in, ka tawlnga uh a, Topa deina bang hi tahen, ka ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Tua ni teng zawkciang in ka van te uh ka ki thoai uh a, Jerusalem ah ka pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Caesarea a om nungzui pawlkhat te in zong hong zui uh a, ka ngia natu uh mun Syprus mi Mnason zong hong tonpui uh hi, Mnason sia a kipatcil pan kipan in nungzui khat a hihi. ");
INSERT INTO csy_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem ka thet uh ciang in, suapui te in angtangtak in hong muak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","A zingciang Paul taw James kungah ka tum uh a; upa te theampo zong om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul in amate nukset a, a tuan in Gentile te sung a nasep na tungtawn in Pathian i nasep nate pualak hi. ");
INSERT INTO csy_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Amate in tua thu a zak uh ciang in, Topa minthang pok uh a, thukham taw kisai a citak mama Judah mi tul tampi te in um uh hi; ci mu uh hi: ");
INSERT INTO csy_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nangma in Moses thukham na nusia tu a, amate tate zong vunteap tan kul ngawl hi, taciang ngeina te zong a zui tu uh hi ngawl hi, ci in na hil hi, ci thu Gentile mite sungah a om Judah mite theampo tungah phawksak hi. ");
INSERT INTO csy_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tua ahikom bang vawt tu khu ziam? mihonpi te hong ki kaikhop kul hamtang tu hi: banghangziam cile amate in nong thet hunlam he tu hi. ");
INSERT INTO csy_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Tua ahikom kong son uh bang in vawt in: amate tungah kiciamna a nei mi li ka nei uh hi; ");
INSERT INTO csy_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Amate taw pai tavun a, thiansuana vawt tavun, amate lu mettol hen a, a bo na dangka te zong piaksak in: taciang nangma taw kisai thu te sia bangma thupi ngawl hi; ahizong nangma vateak in thukham bang zui in nanungta hi, ci thu mi theampo in he tu hi. ");
INSERT INTO csy_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","A um Gentile mite taw kisai in, tabang thu te bangma zui ngawl tu in, lai ka thak zo uh hi, ahihang milim te tung a kipia thisan, tawlsan in a ki ngo sa te le paktat nate pan in amate le amate kikeam tahen, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Tua ahikom Paul in a zingciang in mihing li te paipui a, amate taw thianthona vawt khawm uh hi, taciang biakinn sungah tum uh a, thianthona hun a bo tu ni le amate khatsim atu biakpiakna piak tu zong hil hi. ");
INSERT INTO csy_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ni sali a bo ciang in, Asia ngam Judah mite biakinn sungah Paul a mu uh ciang in, mi theampo hanthawn uh a, Paul man uh hi, ");
INSERT INTO csy_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Israel mite awng, hong hu tavun: hisia pa in mun tatuam a om mi theampo, thukham le hi mun langpan in thuhil hi: tuabek domngawl in Greek mite zong biakinn sungah tumpui a, hi mun thiangtho ninsak hi, ci in au uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Banghangziam cile amate in Ephesus khua mi Trophimus taw Jerusalem ah a mu ngei uh ahikom biakinn sungah tumpui hi, ci muangmaw uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Taciang khuapi bup hong linglawng a, mipi te tai kheukho uh hi: taciang amate in Paul man uh a, biakinn sung pan in kaikeak uh hi: tasia pociang kongkha te khak siat hi. ");
INSERT INTO csy_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Amate in Paul that tu a paipui uh ciang in, tulkhat uk ngalkap mangpa kungah, Jerusalem buppi buaina piang hi, ci thu theng hi. ");
INSERT INTO csy_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ama in ngalkap te le zakhat uk ngalkapmang te sam pai a, mipi te sangah tai uh hi: taciang amate in tulkhat uk ngalkap mangpa le ngalkap te a mu ciang in, Paul sia vel nawn ngawl in tawlnga hi. ");
INSERT INTO csy_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tuazawkciang in tulkhat uk ngalkap mangpa sia Paul kungah hongpai a, a mat zawkciang thikkol ni taw hen tu in thupia hi; taciang ama akua ziam, cile bangvawt ziam, ci dong hi. ");
INSERT INTO csy_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Taciang mihonpi sung pan in mi pawlkhat te in a tuam in au uh a, pawlkhat te in a tuam in au uh hi: tabang in ngalkap mangpa in buaina thu thiangtak in a tel thei ngawl hu in, Paul sia ngalkap inn huang sungah tumpui tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Keallei tung a thet ciang in, ngalkap te in dom uh hi, banghangziam cile mipi te in nawm ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Banghangziam cile mihonpi te in a nung pan zui uh a, hisia pa that vun, ci in au kawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Paul sia ngalkap inn huang sungah a paipui tu uh ciang in, tulkhat uk ngalkap mangpa kungah, kong paupui thei tu ziam? ci hi. Taciang ngalkap mangpa in Greek kam pau thei ni ziam? ");
INSERT INTO csy_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Nangma sia tu masia buaina vawt a, tualthat mi tul li duisung ah a paipui Egypt mi pa hi ngawl ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ahihang Paul in, keima sia Cilicia ngamsung ah khua thathong a hi ngawl, khuapi khat a hi Tarsus a om Judah mi ka hihi: taciang, hi mipi te tungah thuson hun nong piak natu kong thum hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ngalkap mangpa in thuson hun a piak ciang in, Paul sia keallei tungah ding a, mipi te a khut taw van hi. Taciang mipi te a thim khipkhep uh ciang in, amate tungah Hebrew kam taw thuson a, ");
INSERT INTO csy_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Suapui te le pa te awng, keima le keima ka ki hukna kammal te hong ngaisak tavun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Amate in Hebrew kam taw a pau a zak uh ciang in, thim seseam uh a: taciang Paul in, ");
INSERT INTO csy_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","Keima sia Judah mi tatak ka hihi, Silicia ngamsung ah khuapi khat ahi Tarsus ah ka suak hi, ahihang hi Jerusalem ah ka khang a, Gamaliel peang ah pu le pa te i ngeina a cing in hong hil hi, taciang tu ni in note bangma in Pathian sangah thalawptak in ka om ngei hi. ");
INSERT INTO csy_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Taciang Topa lampi a zui te vawtsia in, ka that hi, taciang numei le pasal ci ngawl in ka hen a, thong sungah ka ap hi. ");
INSERT INTO csy_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Thiampi sang le thudokpi te theampo in zong keima atu in tettipang hi: Damascus a omte hen tu le Jerusalem ah paipui in, danpiak natu lai te ka nga zawkciang in Damascus ah ka pai hi. ");
INSERT INTO csy_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Taciang khual ka haw a, Damascus ka thet dektak sun hun pawl in, van pan in khuavak tang mama ka kimkot ah thakhathu in hong tang pimpem hi. ");
INSERT INTO csy_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Lei ah ka puk a, aw khat in, Saul, Saul, banghang hong vawtsia ni ziam? hong ci ka za hi. ");
INSERT INTO csy_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Taciang keima in, Topa awng, nang akua ni ziam? ci in ka zo hi. Taciang Ama in keima tung ah, Keima sia na vawtsiat Nazareth mi Jesus ka hihi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Taciang ka kungah omte in khuavak sia mu takpi uh a, lau mama uh hi; ahihang keima hong paupui pa i aw a za bua uhhi. ");
INSERT INTO csy_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Taciang keima in, Topa awng, bang vawt tu khi ziam? ka ci hi. Topa in keima tung ah, Tho in a, Damascus ah pai in; tua mun ah na vawt tu in kong sawl theampo te hong kison tu hi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tua a vanglian khuavak hang in khua ka mu thei bua hi, ka kung a omte in a khut uh taw hong kai uh a, Damascus ka theng hi. ");
INSERT INTO csy_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Tua mun ah Ananias a kici mi khat om hi, ama sia thukham bang in biakna sangah a kipumpiak hi a, tua mun ah a om Judah mite sungah a ki phatson pa khat a hihi, ");
INSERT INTO csy_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Tua Ananias sia ka kungah hongpai a, a din kawm in, suapui pa Sawl awng, khua mu kik in, hong ci hi. Tua hun lian in ama ka en hi. ");
INSERT INTO csy_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Taciang ama in ka kungah, i pu le pa te Pathian in Ama deina he tu le, mi thutang khat mu tu a, a kam pan a pusuak kammal ngai tu in hong teal zo hi. ");
INSERT INTO csy_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Banghangziam cile nangma sia na mu le na zak te ngual theampo tungah Ama tetti na hi tu hi. ");
INSERT INTO csy_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Taciang, tu in bang ngak ni ziam? tho in a, tui ki phum in, taciang na mawna te sil in a, Topa min sam in, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Tuazawkciang Jerusalem ka theng kik a, biakinn sungah thu ka nget laitak in, mang khat ka mu hi; ");
INSERT INTO csy_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Tua mun ah Topa in, Manlang in, taciang Jerusalem pan manlangtak in pusuak in: banghangziam cile amate in keima taw kisai in na tettipanna hong sang ngawl tu uh hi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Taciang keima in Topa awng, Nang hong umte synagogue sung theampo ah sat in thong ka taksak hi, ci amate in hong he hi: ");
INSERT INTO csy_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Taciang nangma ngalhang Stephen thisan a luan lai zong in, keima zong a hui ah ka ding a, a thina ah ka lungkim in a that te i puan te ka kepsak hi, ka ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Taciang Topa in ka tung ah, Pai in: banghangziam cile Gentile mite kung a khuala mama na ah kong paisak tu hi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Hi thu a son dong amate in ngai uh hi, tua zawkciang in a ngingtak in au uh a, hibang mihing that vun, leitung ah om heak tahen: banghangziam cile ama sia a nungta tu ki phu ngawl hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Amate a au kawm in, a puan u te hawkkeak uh a, leivui van ah lawn ngawp uh hi. ");
INSERT INTO csy_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Tulkhat uk ngalkap mangpa in Paul sia ngalkap inn huang sungah tumpui tu in thupia hi, taciang ama langpan in banghang mipi te au ziam? ci a heak natu in Paul sat a, thu dong tu in vaitha hi. ");
INSERT INTO csy_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ahihang amate in savun khauhual taw a hen uh ciang in, Paul in zakhat uk ngalkap mangpa kungah, thu a kisit ngawl lai Rome ngam mi khat sat tu ngeina ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Tua thu zakhat uk ngalkap mangpa in a zak ciang in, tul khat uk ngalkap mangpa tung ah, na nasep kidawm in: banghangziam cile hisia pa sia Rome mi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Tuazawkciang in tulkhat uk ngalkap mangpa hongpai a, nangma sia Rome mi na hi ziam? hong son tan, ci hi. Paul in, hi khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Taciang tulkhat uk ngalkap mangpa in, Rome mi ka hina sia dangka tampi pia in ka nga hi, ci in zo hi. Taciang Paul in, ahihang kei ka sua pan in Rome mi ka hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Tua zawk pociang in thudong tu te Paul kung pan paikhia uh hi: taciang tulkhat uk ngalkap mangpa zong Paul sia Rome mi hi, ci a heak zawkciang in, patau mama hi, banghangziam cile ama in Paul man in a lehhen hang a hihi. ");
INSERT INTO csy_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","A zingsang ciang in, Judah mite in Paul thusitna thu a tel thiang nop uh hu in, a hen nate sutsak uh a, thiampi lian te le, thudokpi te hongpai tu in thupia hi, taciang Paul paipui uh a, amate mai ah koi hi. ");
INSERT INTO csy_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul in thudokpi te tangtak in en a, u le nau te awng, tu ni dong Pathian mai ah sia le pha khentel theina thinsung pha taw ka nungta hi. ");
INSERT INTO csy_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Taciang thiampi sang Ananias sia Paul kungah ding a, Paul i muk pan sat tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Tuazawkciang in Paul in, nang a ngo ki zut pangpi, Pathian in hong sat tu hi: banghangziam cile thukham bang in thukhen tu in to napi, banghang thukham taw ki lebul in keima sat tu in thu pia ni ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Taciang Paul kungah a ding te in, Pathian i thiampi sang thusimngawl ni ziam? ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Tuasiaciang Paul in, suapui te awng, ama sia thiampi sang hi, ci ka he bua hi: banghangziam cile, na mihing lampui te phatngawlna kampau heak in, ci in ki atsa om hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ahihang Paul in pawlkhat te sia Saducee te hi a, a dang te sia Pharisee te hi, ci a heak ciang in, thudokpi te sungah, u le nau te awng, keima sia Pharisee ka hihi, Pharisee i tapa ka hihi: mithi te lametna le thawkikna thu dong tu in hongsam uh hi, ci au hi. ");
INSERT INTO csy_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Tabang in a son zawkciang in, Pharisee te le Saducee te ki laklaw ah ki thusik ngawl na hong om a: mihonpi kikhen siat hi. ");
INSERT INTO csy_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Banghangziam cile Saducee te in thawkikna, vantungmi le thaa om ngawl hi ci uh hi: ahihang Pharisee te in a vekpi in om hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nasiatak in au ngawp uh hi: taciang Pharisee te sung pan in thukhamhil te hong ding uh a, hisia pa a phatngawlna ka mu bua uh hi: ahihang thaa a hibale, vantungmi in paupui ahile, Pathian i do batu hi, ci in nasiatak in nial uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","A thu kisik ngawlna a nasiat seseam ciang in, tulkhat uk ngalkap mangpa in, Paul sia amate in a laithap tu uh lau ahikom, ngalkap te tuaksuk in, amate sung pan lakeak tu le, ngalkap inn huang sungah paipui tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Taciang a zingzan ciang in Topa sia paul kungah ding a, Paul, hangsantak in om in: banghangziam cile Jerusalem ah keima thu tetti na pan bang in, Rome ah zong pang hamtang tu ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","A zingsang ciang in, Judah mi pawlkhat te ki kaikhawm uh a, Paul a thalup mateng, an ne ngawl le tui dawn ngawl tu, ci in kiciamna vawt uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Hi kiciamna a vawt te sia mihing sawmli val pha uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Taciang amate thiampi lian te le ulian te kungah pai uh a, Paul ka thalup uh mateng bangma ne ngawl tu in kiciamna lianpi ka vawt zo uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Tua ahikom tu in, noma le thudokpi te in tulkhat uk ngalkap mangpa kungah, Paul thu a kicingzaw dong tu bang in na kungah a zingciang hong paipui tu in son vun: taciang kote in, a nai na pan, that tu in ka kinging khol tu uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Taciang amate in tabang in suam tu a ngeal khop uh sia Paul i nau nu i tapa in a zak ciang in, ngalkap inn huang sungah tum a, Paul tungah son hi. ");
INSERT INTO csy_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Tuazawkciang in Paul in zakhat uk ngalkap mangpa te sung pan khat a kungah sam a, hi tangvalpa tulkhat uk ngalkap mangpa kungah paipui tu in son hi: banghangziam cile ama in tulkhat uk ngalkap mangpa tung sonnop nei hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Tua ahikom tua ngalkap mangpa in tangvalpa sia tulkhat uk ngalkap mangpa kungah paipui a, thongtak pa Paul in keima hong sam hi, taciang na kungah thuson tu a nei hi tangvalpa paipui tu in hong ngen hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Tuazawkciang in tulkhat uk ngalkap mangpa in tangvalpa a khut pan len a, a tuam in paipui hi, taciang bang hong son nuam ni ziam? ci in dong hi. ");
INSERT INTO csy_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tangvalpa in, Judah mite in Paul thu a cingzaw dong tu bang in zingciang thudokpi te kungah paipui tu in hong ngen tu ci in, lungkim zo uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ahihang amate thu zui heak in: banghangziam cile mihing sawmli val in Paul suam nuam in pang uh hi, Paul a thalup uh mateng an ne ngawl le tui dawn ngawl tu in, kiciamna nei zo uh hi: taciang, amate sia nangma tung pan kamciam ngak in kinging khol in om uh hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Tua ahikom tulkhat uk ngalkap mangpa in tangval pa kungah, hi thu te nong son sia kuama tung son heak in, ci in vaitha a, ciasak hi. ");
INSERT INTO csy_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Taciang ama in zakhat uk ngalkap mangpa sam a, ngalkap za ni, siphu ngalkap sawm sali le teipi ngalkap za ni te tu zan nai kua in Caesarea pai tu in kinging khol vun; ");
INSERT INTO csy_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Paul i to tu nganhing te zong vaihawmsak vun a, taciang ngam uk Felix tungah bangma tat ngawl in puak vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Taciang hibang in laithak at hi: ");
INSERT INTO csy_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Claudius Lysias in a phabel ngam uk Felix tungah paupuina lai kong thak hi. ");
INSERT INTO csy_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Hisia pa sia Judah te in man uh a, a thalup tu uh hi napi: Rome mi hi, ci ka he a, ngalkap te taw pai in ka hun hi. ");
INSERT INTO csy_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Taciang amate i mawsiat na thu ka heak nop hu in thudokpi te kungah ka paipui hi: ");
INSERT INTO csy_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ama a mawsiatna uh sia amate thukham thu ki dokna te hi, ci ka he hi, ahihang thina tak le thongtak khop tu mawna bangma nei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Taciang Judah mite in hisia pa suam sawm tawntung uh hi, ci thu hong ki son pociang in, na kungah hong puak khi hi, taciang a mawsiat te zong nangma mai ah son tu in thu ka pia hi, Na dam ta in, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Tuazawkciang in ngalkap te zong thupiakna bang in Paul la uh a, Antipatris ah zan ciang in paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A zingciang in siphu ngalkap te sia ama taw pai tu in nusia a, a dang te ngalkap huang sungah heakkik uh hi: ");
INSERT INTO csy_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Caesaria a thet uh ciang in, laithak sia ngam uk pa tungah ap uh a, Paul zong a mai ah ap uh hi. ");
INSERT INTO csy_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ngam uk pa in laithak a sim zawkciang, koisung pan ziam, ci in dong hi, Taciang Caesaria pan hi, ci a heak ciang in; ");
INSERT INTO csy_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Nangma hong mawsiat te hong thet ciang in, na thu ka ngai kik tu hi, ci hi. Taciang Herod i thukhenna mun innpi sungah keam tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ni nga zawkciang in thiampi sang Ananias sia ulian te le thusungpa Tertullus taw tuaksuk khawm uh a, Tertullus in paul thu sia ngam ukpa kungah son hi. ");
INSERT INTO csy_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Taciang Paul a sap uh ciang in Tertullus in mawsiat a, taciang Felix kungah, nangma hang in kilemna lianpi ka nei uh hi, na ukna tungtawn in hi mite tungah nong deisakna hang in phatna tampi nong vawtsak a, ");
INSERT INTO csy_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Tua thu te sia a tawntung in mun tatuam ah lungdamna taw in ka na sang uh hi, maw thinsung phabel Felix awng, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ahitazong, hun saupi hong nawngkaisak ngawl in a tomno kong son tu thu thinsautak in nong ngaisak natu in kong thum hi. ");
INSERT INTO csy_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Banghangziam cile hisia pa sia ngual nawngkaisak, leitung theampo ah Judah mi theampo sungah ki nialna a piangsak le Nazaren pawl te makaipa ka mu zo uh hi: ");
INSERT INTO csy_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ama sia biakinn ninsak tu in zong pai zo hi: ama ka man uh a, ka thukham uh bang in thu ka khen nuam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ahihang tulkhat uk ngalkap mangpa Lysias hongpai a, ka khutsung uh pan in hong lakkeaksak hi, ");
INSERT INTO csy_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ama a mawsiat te na kungah hongpai natu in thupia hi: nangma vateak in thu dong le te kote i mawsiatna hi thu te a vekpi in na he tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Taciang Judah mite in zong hi thu te man hi, ci in thukim uh hi. ");
INSERT INTO csy_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Pual sia ngam uk pa in thuson tu in a khut taw a lak zawkciang in, nangma sia hi minam tungah kum tampi thukhenpa na hihi, ci ka heak ciang in lawptak in keima thu kong son tu hi: ");
INSERT INTO csy_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Jerusalem ah Pathian bia tu in ka pai zawk ni sawm le ni ni pha pheang hi, ci na he tu hi. ");
INSERT INTO csy_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Amate in biakinn sungah midang taw thu ka ki nial hong mu ngawl hi, taciang synagogue le khuapi sungah mipi te ka buaisak zong hong mu bua uh hi: ");
INSERT INTO csy_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Tu in hong mawsiatna thu te sia amate in tetti lak tu a he bua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ahihang hi thu sia na kungah kong pualak hi, ka pu le pa te Pathian ka bia a, thukham le kamsang te sungah a ki at theampo ka up hu in, amate in tua thu sia umkhial hi hong ci uh hi: ");
INSERT INTO csy_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Taciang mi thutang le thutang ngawl kibang tek in mithi te thawkikna om tu hi, ci amate in lametna a nei uh bangma in, keima zong Pathian tungah lametna ka nei hi. ");
INSERT INTO csy_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Taciang Pathian le mihing tungah khial tha ngawl in, sia le pha heak na thinsung thiangtho nei tu, ka hanciam theitawp in ka hanciam tawntung hi. ");
INSERT INTO csy_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Tu in kum tampi zawkciang ka mipui te kungah mizawng te huna le piakna te keng in ka pai hi. ");
INSERT INTO csy_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Biakinn sungah thianthona ka vawt zawkciang in, Asia ngam pan hongpai Judah mite in hong mu a, mihonpi le buaina om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Asia ngam pan hongpai Judah mite in keima mawsiatna tu nei ahile amate vateak na mai ah hongpai tu kilawm hi. ");
INSERT INTO csy_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ahibale, hi mun a omte in, na phangawl ka vawt hong mu le, thudokpi te mai ah hong son tahen, ");
INSERT INTO csy_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Amate sungah ka din laitak in ka au na aw khat, mithi te thawkikna thu simngawl, tu in nangma in thu dong tu in nong sap natu thu dang om ngawl hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix in hi thu te a zakciang in, tua lampi thu heakna a cingzaw in nei ahikom a ni khin a, tulkhat uk ngalkap mangpa Lysias hong thet ciang in, na thukhen kik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Taciang zakhat uk ngalkap mangpa kungah, Paul keamcing tu le, a suaktatak in omsak natu ahizong, taciang ama khoi tu le a kung hongpai a lawm te kuama khak ngawl natu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Tua zawk a ngei ngawl in Felix a zi Drusilla taw hongpai hi, Drusilla sia Judah mi hi a, Paul sam in, Christ sungah a upna thu te ngai hi. ");
INSERT INTO csy_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Taciang Paul in thutang suana, kitekna le hong theng tu thukhenna thu te sonpui a, Felix sia lau in ling hi, taciang, tu in pai phot tan a, hun pha a om ciang in kong sam kik tu hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Paul in a suatak thei natu in dangka hong pia tu hi, ci lamen ahikom Felix in Paul sia tu le tu in sam a, paupui tawntung hi. ");
INSERT INTO csy_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ahihang kum ni zawkciang in Porcius Festas sia Felix inndoi sungah tum a: Judah mite lungkimsak tu dei ahikom, Felix in Paul sia pusua ngawl in thongsung ah nusia hi. ");
INSERT INTO csy_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus sia tua ngamkhen sung a thet zawk ni thum ciang in, Caesarea pan Jerusalem ah paito hi. ");
INSERT INTO csy_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Tuazawkciang in thiampi sang le Judah mi makai te in Paul langpan na thu son in, thum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Paul sia lamkal pan suam tu in pang uh a, a thalup nop uh hu in, Jerusalem ah puak tu in ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ahihang Festus in, Paul sia Caesarea ah kepcing tu a hihi, ci in zo hi, taciang ama zong hai ngawl in Caesarea ah pai sawm hi. ");
INSERT INTO csy_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Tua ahikom note sung pan a pai thei tu te keima taw hongpai tavun a, Paul in phat ngawlna nei ahile mawsiat vun, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus sia amate sungah ni sawm val taam a, Caesarea pai hi; taciang a zingciang in thukhenna tokhum tungah to a, Paul paipui tu in thupia hi. ");
INSERT INTO csy_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Taciang Paul a thet ciang in, Jerusalem pan hongpai Judah mite a kimkot ah ding uh a, Paul tungah tetti a lak thei ngawl uh, thuak zawk a hi ngawl mawsiatna tampi suan uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul in Judah mite thukham langpan in ahizong, biakinn langpan in ahizong, taciang Caesar langpan in ahizong, ka vawtkhial khat zong om ngawl hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ahihang Festus in Judah mite lungkimsak nuam ahikom, Paul kam zo kik a, Jerusalem ah pai in ka mai ah hi thu te taw kisai thukhen tu na uk ziam? ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Tasia ciang Paul in, ka thu hong khensak tu a kilawm Caesar thukhenna tokhum ah ka ding hi: nangma in a thiangtak in na heaksa bangma in Judah mite tungah bangma a man ngawl vawt ngawl khi hi. ");
INSERT INTO csy_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Banghangziam cile keima sia thukham paltan, a hibale, thi tu kilawm mawna vawt ka hile, thi tu ka nial bua hi: ahihang hi mite i hong mawsiatna khat zong a man om ngawl ahile, kuama in amate tungah hong ap thei ngawl tu hi. Caesar tungah thusungkik tu khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus in thudokpi te taw a kikup zawkciang in, Caesar kungah thusungkik tu ni ziam? Caesar kungah pai tu ni hi, ci in zo hi. ");
INSERT INTO csy_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ni pawlkhat sung a ngei zawkciang in kumpipa Agrippa le Bernice te Caesarea ah Festus nukset tu in hongpai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Taciang amate Caesarea ah ni tampi a om zawk uh ciang in, Festus in kumpipa tung ah, Felix in thong a taksak khat om hi, ci in Paul thu pualak a: ");
INSERT INTO csy_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Jerusalem ah ka pai lai in, thiampi lian te le Judah mi ulian te in Paul i thu hong son uh a, ama thukhen tu in hong ngen uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Amate kungah, mawsiatna a thuak pa sia a mawsiat te taw maitang kisi tu in, amate i mawsiatna thu taw kisai, ama atu thuson hun pia masa ngawl in, mi khatpo that tu in ap tu sia Rome mite i ngeina hi ngawl hi, ci in ka zo hi. ");
INSERT INTO csy_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tua ahikom amate in hi mun ah hongpai uh ciang in, a zingciang khangkhan ngawl in thukhenna tokhum tungah ka to a, hisia pa hong paipui natu in thu ka pia hi. ");
INSERT INTO csy_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ama a mawsiat te a din uh ciang in, ka ngaisut bang in mawsiatna bangma a son bua uh hi: ");
INSERT INTO csy_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ahihang amate thuciin taw kisai in thudokna te, taciang Jesus a kici mi khat thi zo a, Paul in tua pa nungta hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Taciang tabang thudokna te um ngawl ka hikom, hi thu te hang in thukhenna thuak tu in Jerusalem ah na pai tu ziam, ci ka dong hi. ");
INSERT INTO csy_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ahihang Paul in Augustus mai ah thusung kik tu in hong ngen ahikom, Caesar kungah ka puak mateng keamcing tu in thu pia khi hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Tasiaciang Agrippa in Festus tung ah, tua pa thu sia keima vateak zong in ka ngai tu hi, ci hi. Taciang Festus in zingciang in na ngai tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","A zingciang in, Agrippa le Bernice te sia thupitak in hongpai khawm uh hi, taciang tulkhat uk ngalkap mang te le khuapi sungah mi thupi te taw thu kikup ngai na mun inndoi sungah hong tum khawm uh a, Festus thupiakna bang in Paul paipui uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Taciang Festus in, kumpipa Agrippa le hi mun ka kung a om mi theampo awng, hisia pa en vun, ama sia Jerusalem le hi mun ah om Judah mihonpi theampo in ka kungah a thu hong then uh a, ama sia a nungta tu kilawm ngawl hi, ci au uh hi. ");
INSERT INTO csy_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ahihang ama in thi tu kilawm zadong a vawt bangma ka mu ngawl ciang in, ama in zong Augustus kungah thusungkik tu hong nget hu in, ama puak tu in thu ka khensat zo hi. ");
INSERT INTO csy_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ahihang ka topa kungah bangma at tu ka nei bua hi, Tua ahikom ama sia note i mai ah kong paipui hi, a tuan in kumpipa Agrippa awng, thu na dok zawkciang in, at tu nei thei tha tu khi hi. ");
INSERT INTO csy_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Banghangziam cile thongtak khat sia ama langpan in mawsiatna bangma kilang ngawlpi in puak tu phangawl tu in ka ngaisun hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa in Paul tung ah, nangma thu a son tu in hun kong pia hi, ci hi. Tuazawkciang in Paul in a khut phal in, ama thu hibang in son in zo hi: ");
INSERT INTO csy_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Kumpipa Agrippa awng, tu ni in Judah mite i hong mawsiatna hi thu te taw kisai in na mai ah keima vateak in hong zo tu ka hi man in, keima le keima hampha ka kisa hi: ");
INSERT INTO csy_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","A tuan in nangma sia Judah mite ngeina te le thudokna theampo ah a telbel na hihi, ci ka he hi: tua ahikom thinsautak in nong ngaisak tu kong thum hi. ");
INSERT INTO csy_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ka nolai pan kipan in ka nuntak zia sia, a masabel ka omna Jerusalem a om ka mipui Judah mite theampo in hong he hi; ");
INSERT INTO csy_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Amate in keima thu tettipang nuam uh hile, ka biakna uh i ngeina a khobel, Pharisee khat in ka nungta hi, ci sia a kipat pan ma in hong heak sa uh a hihi. ");
INSERT INTO csy_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Tu in Pathian in ka pu le pa te kungah a vawt kamciam i lametna hu in thukhenna thuak in ka ding hi: ");
INSERT INTO csy_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tua hong thengpheang tu kamciam sungah lametna nei in ka mipui sawm le ni te in sun le zan tawlnga ngawl in, Pathian na ka seam uh hi. Tua lametna hang in, kumpi Agrippa awng, Judah mite in keima hong mawsak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Pathian in mithi te thosak kik tu hi, ci sia banghangin uptak ngawl thu in ngaisun nu ziam? ");
INSERT INTO csy_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nazareth khua mi Jesus min langpan in na tampi vawt tu kilawm hi, ci in keima tatak in zong ngaisun takpi ngei khi hi. ");
INSERT INTO csy_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Tuathu sia keima in zong Jerusalem ah ka vawt ngei hi: thiampi lian te kung pan in sep thei na thu ka nga a, mithiangtho te thongsung ah ka khum hi; taciang amate thalup a thuak ciang zong, amate langpan in lungkimpui khi hi. ");
INSERT INTO csy_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Synagogue tatuam sungah zong ka vawtsia bul a, amate zawthawk vawt in Pathian min ka sonsiasak hi; taciang amate tungah ka thin-uk mama hu in, ngamdang khuapi ciangdong zong amate ka vawtsia ngei hi. ");
INSERT INTO csy_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Tabang in thiampi lian te kung pan thuneina le thupiakna taw Damascus ka pai ciang in, ");
INSERT INTO csy_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kumpipa awng, sun laitak in, lampi ah van pan in ni sang a tangzaw khuavak ka mu hi, tasia in keima le ka lawm te kimkot ah hong tang hi. ");
INSERT INTO csy_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Taciang ka vekpi in lei ah ka puk siat uh a, Hebrew kam taw, Saul, Saul, banghang in hong vawtsia ni ziam? so zum khat sui ek tu sia nangma atu in haksak mama hi, ci aw khat in hong paupui ka za hi. ");
INSERT INTO csy_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Taciang keima in, akua ni ziam, Topa? ka ci hi. Taciang in, Keima sia na vawtsiat Jesus ka hihi. ");
INSERT INTO csy_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ahihang tho in a, nangma peang tungah ding in: banghangziam cile hi ngealna atu in na kungah kong kilaak zo hi, na musa hi thu te le kong lak laitu thu te atu in naseam tu le tetti tu in kong vawt tu hi; ");
INSERT INTO csy_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nangma sia Judah mite le Gentile mite kung pan in kong suatak tu hi, ");
INSERT INTO csy_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Amate i mit honsak tu ahizong, taciang khuamial pan in khuavak ah le Satan vangletna pan in Pathian kungah a heakkiksak tu, tabang in mawmaisak na nga tu le keima sungah upna tungtawn in a ki thiangthosak sa te sungah ngamhlua tu in, amate tungah tu in kong sawl hi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Tua ahikom, maw kumpipa Agrippa awng, van pan in hongpai ka mangmuna thu ka nial bua hi. ");
INSERT INTO csy_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Amasabel in Damascus, taciang Jerusalem, taciang Judah ngamsung theampo le Gentile te kungah amate mawna ki sikkik a, Pathian kungah a heakkik thei natu le ki sikkik nataw a kiphu nasep te a sep natu in thu ka hil hi. ");
INSERT INTO csy_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Hi thu te hang in Judah mite in biakinn sungah hong man uh a, hong that nuam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Pathian panpuina ka nga hu in, tuni dong tatsat ngawl in a lian a no te tungah a kibang in tetti ka pang a, kamsang te le Moses in hong theng tu hi, ci a sonsa thu te simngawl a dang bangma ka son bua hi: ");
INSERT INTO csy_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Tua Christ sia thuak tu a, ama sia mithi te sung pan in a masabel thokik tu hi, taciang Judah mite le Gentile mite kungah khuavak thu tangsak tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Taciang Paul in ama atu thu a son zawkciang in, Festus in aw ngingtak taw, Paul awng, na thin-am hi; a tamlei na sinna in na thin hong amsak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ahihang Paul in, ka thin-am ngawl hi, a phabel Festus awng: ahihang thuman le ciimkam te ka pau hi. ");
INSERT INTO csy_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Banghangziam cile kumpipa in hi thu te he hi, a mai ah suaktatak in ka son hi: hi thu te theampo sia a kung pan in a ki phualseal khat zong om ngawl hi; banghangziam cile hi thu sia a kingsong mun ah a kivawt hi ngawl hi, ci sia keima in ka tel thiang hi. ");
INSERT INTO csy_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kumpipa Agrippa awng, kamsang te na um ziam? Na um hi, ci ka he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Tasia ciang Agrippa in Paul kungah, Christian suak tu in hong kaizawn zo dektak ni hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Taciang Paul in, nangma bek hi ngawl in, tu ni ka thusonna a za note theampo, dektak cibek hi ngawl in, thongtak thu simngawl keima bang tatak na hi thiangtho natu uh Pathian tungah ka thungetna a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Paul in thu a son zawkciang in, kumpipa, ngam uk Bernice te a topui te taw ding uh a: ");
INSERT INTO csy_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Amate a kingsong ah a pai zawk uh ciang in, hisia pa in thina tu kilawm le thongtak khop natu bangma vawt ngawl hi, ci amate sungah son tek uh hi. ");
INSERT INTO csy_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Tuazawkciang in Agrippa in Festus kungah, hisia pa in Caesar kungah thusungkik tu ngen hibale, suataksak tu hi napi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Italy ah teambaw taw pai tu a ki khensat zawkciang in, amate in Paul le a dang thongtak te sia Augustus ngalkaphon sungah zakhat uk ngalkap mangpa Julius kungah ap uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Taciang Adramyttium tembaw sungah ka tum uh a, Asia ngam tuipi dung zui in pai tu ka kipan uh hi; Macedonia ngam Thessalonica khua mi Aristarchus a kici khat zong kote taw hong ki thawl hi. ");
INSERT INTO csy_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","A zingciang in Sidon ah ka tawlnga uh hi. Taciang Julius in Paul sia phat vawt a, a lawmte kungah pai in, ama le ama thathak la tu in suaktatak in ap hi. ");
INSERT INTO csy_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Tua mun pan in ka ki patkik uh ciang in, koma sangah hui hongpai ahikom Cyprus nuai pan in ka pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Cilicia le Pamphylia tuipi tungah ka pai zawk uh ciang, Lycia ngam khuapi Myra ka theng uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Tua mun ah zakhat uk ngalkap mangpa in Italy a pai tu Alexandria tembaw mu a; tua tembaw sungah hong tumsak hi. ");
INSERT INTO csy_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Taciang dadam in ni tampi sung ka pai zawk uh ciang in, Cnidus tangtan haksatak in ka theng uh hi, hui in hong khak ahikom in, Crete tuikul nuai pan Salmone ah a tangtan in ka pai uh hi; ");
INSERT INTO csy_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Taciang haksatak in ka kantan uh a, A Pha Tembaw Tawlngakna Mun, a kici na mun ka theng uh hi; tua mun sia Lasea khuapi taw ki nai hi. ");
INSERT INTO csy_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Tu in hun tampi ka zak zawk uh ciang in, antan hun zong bo zo a, tembaw taw khualhaw tu sia lauhuai hi, ci in Paul in kidopna tu son hi, ");
INSERT INTO csy_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","Taciang amate tung ah, hi tembaw taw khualhaw tu sia vanpuak te le tembaw atu bek hi ngawl in, eite nuntakna dong in haksatna le siatsuana tampi om tu hi, ci i he hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ahihang zakhat uk ngalkap mangpa in Paul i thuson te sang in, tembaw hawlpa le a neipa thu um zaw hi. ");
INSERT INTO csy_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Tua tembaw tawlngakna mun sia phalbi hun sung om natu phangawl ahikom, ahi thei le Phenice thet dong paisuak tu a, tua mun ah phalbi sung theampo om tu a tamzaw in ngaisutna pia uh hi; tasia sia Crete tembaw tawlngakna mun hi a, nitum na thangsang le nitumna saksang maingat in om hi. ");
INSERT INTO csy_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Taciang thangsang pan hui in hongseam va hiau a, amate in a ngealna theng zo hi, ci ngaisun uh a, Crete nai na pan in pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ahihang a hai ngawl in, Euroclydon a kici sumpei bang in huipi hong ki nuai ngawp hi. ");
INSERT INTO csy_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Ka tembaw uh sia hui in nuaicip a, tua hui nawk zo ngawl ahikom in, hui in a ukna mun theampo ah hong paipui hi. ");
INSERT INTO csy_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Clauda a kici tuikul nuai pan in ka pai uh laitak in, haksatak in ngunkuang ka dom uh a; ");
INSERT INTO csy_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Tembaw tungah ka domto zawk uh ciang in, tembaw a kho natu in ngunkuang sia khau taw hen hi; taciang senneal tam na mun ah tembaw awk tu lau uh ahikom tembaw puankhak te khiasuk uh a, hui in a uk na munpo ah hong paipui hi. ");
INSERT INTO csy_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Huipi in nasiatak in hong nuaicip veve ahikom in, a zingciang in tembaw zaangsak uh hi; ");
INSERT INTO csy_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Taciang ni thum na ciang in kote i khut vateak taw in tembaw vanpuak te ka vawk uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Taciang ni tampi sung ni le aksi te ki mu nawn ngawl a, huipi nasiatak in hong vak lai ciang in, ka suatak natu uh lametna theampo bosiat zo hi. ");
INSERT INTO csy_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Ahihang ngei mama an a ki ngawl zawkciang, Paul sia amate laizang ah ding a, ka thu nong man tu uh hi napi, Crete pan in pai ngawl hileang, hi haksatna le supna te i thuak batu hi. ");
INSERT INTO csy_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Tuin thinnuamtak in om tu in kong hanthawn hi: banghangziam cile tembaw simngawl, note sungah mihing nuntakna khat zong bo ngawl tu hi. ");
INSERT INTO csy_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Banghangziam cile tuzan in keima hong nei le a na ka sepsak Pathian vantungmi ka kungah hong ding a, ");
INSERT INTO csy_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Paul awng, lau heak in; nangma sia Caesar mai ah hong paipui hamtang tu khi hi: taciang, en in, nangma taw tembaw tung khualhaw te theampo Pathian in hong pia zo hi, hong ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Tua ahikom, thinnuam in om vun: banghangziam cile Pathian in keima hong sonsa bang in tangtung tu hi, ci ka um hi. ");
INSERT INTO csy_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ahihang tuikul khatpo ah hui in hong vawk hamtang tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ahihang zan sawm le zan ni na ciang in, Adria tuipi sungah loksuk lokto in hong paipui a, zankim laitak pawl in tembaw naseam te in tuihui lei ki nai zo hi, ci muangmaw uh hi; ");
INSERT INTO csy_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Taciang tui a te uh ciang in pi za le kul thuk hi, ci he uh hi: taciang tawm a khuala zawhiat a pai zawkciang in te kik a, pi sawmkua thuk hi, ci he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Tuazawkciang in tembaw in suangpi a taithak tu a lau uh hu in, tembaw nungsang pan thikkapui li khia uh a, khuavak natu in thu ka ngen khawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Taciang tembaw naseam te tembaw sung pan in a puasang ah tai sawm uh a, ngunkuang tuipi sungah a khiak uh ciang in, tembaw lusang pan in thikkapui te khia tu bang in ki omsak uh hi, ");
INSERT INTO csy_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul in zakhat uk ngalkap mangpa le ngalkap te kungah, hi mite tembaw sung a om nginge bua ahile, kuama suakta thei ngawl tu nu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Tuazawkciang in ngalkap te in ngunkuang khii na khau te sattan a, ngunkuang khia uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Khuavak dektak ciang in, Paul in amate theampo an ne tu in thum a, tuni sia a kizom in antang in, bangma ne ngawl in na om uh ni sawm le ni li na hi zo hi. ");
INSERT INTO csy_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Tua ahikom an tawmtek ne tu in kong thum hi: banghangziam cile hisia sia na dam natu uh a hihi: banghangziam cile na lu tung uh pan in samzam khat zong tong ngawl tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Tabang a ci zawkciang in, anluum la a, amate theampo i mai ah Pathian tung lungdam a ko zawkciang in: balnen in ne hi. ");
INSERT INTO csy_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Tuazawkciang in amate theampo thinnuam tek uh a, an tawmtek ne uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Tembaw sungah ka vekpi uh in mihing zani le sawm sali le luk ka pha uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Amate an a kham in a neak tek zawk uh ciang in, zungtang te tuipi sungah khuasuk uh a, tembaw vanzaangsak hi. ");
INSERT INTO csy_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Khua hong vak ciang in, koisung ngam ci a he bua uh hi: ahihang amate in kingkoai khat sia valbo taw ki thua mu uh a, a suakthei le tua sungah tembaw tumpui sawm uh hi. ");
INSERT INTO csy_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Taciang thikkapui te sattan in tuipi sungah nusia hi, taciang tembaw khiina khau te sut uh a, tembaw maisang puankhak sia hui i mut tu in khak uh hi, taciang tembaw sia tuihui sangah paisak hi. ");
INSERT INTO csy_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Tembaw sia tuipi ni ki siktua na mun ah theng a, senneal tungah awksak uh hi; taciang a maisang sia senneal sungah tumsak uh a, tung thei ngawl in awk hi, ahihang a nungsang sia tuihual hat mama in tamthamsak hi. ");
INSERT INTO csy_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ngalkap te, thongtak te that siat tu in kikum uh hi, tabang hibale thongtak te tui op tu a, tai siat tu hi. ");
INSERT INTO csy_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ahihang zakhat uk ngalkap mangpa in, Paul a ngup nop hu in, amate i ngealna khak a; tui op thiam peuma amasabel in tuisung ah leangsuk tu le tuihui dong op tu in thupia hi: ");
INSERT INTO csy_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","A tanglai pawlkhat te sia thingpheak tung le pawlkhat te tembaw bek thingpheak te tung pan in tuihui ah bangma tat ngawl in theng siat uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Amate a suatak zawk uh ciang in, tua tuikul sia Melita kici hi, ci he uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Ngua hong zu a, khuasik mama ahikom in mimawl te in mei hong tawsak uh a, ka vekpi in hong sang in, kote hong phatvawt mama uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Taciang Paul in thing lomkhat hong toai in, meisung ah a bumsuk ciang, sa ahikom in ngul khat hong pusuak a, Paul i khut tungah hong ki vial hi. ");
INSERT INTO csy_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Taciang mimawl te in Paul i khut ah a ngu hang mama ngulpui in pom ci a mu uh ciang in, hisia pa sia tualthat hi nanak tu hi, tuipi sung pan suakta napi, phulakna in nungtasak tuan ngawl hi, ci in amate kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Taciang Paul in tua nganhing sia meisung ah thing a, bangma tat ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ahihang amate in banghun ciang hong tumkeak tam maw, a hibale, banghun ciang upmawk ngawlpi, puk in a thi tam maw, ci in encik uh hi: ahihang hun saupi sung a etcik zawk uh ciang in, bangma a phatmawk ngawl ciang, amate in a ngaisutna uh khealkik a, hisia pa sia pathian hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tua mun ah tuikul ukpa in lo ngam nei a, tua pa min sia Publius kici hi; ama in phatak in hong sang a, ni thum sung hong taamsak hi. ");
INSERT INTO csy_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Taciang in, Publius i pa sia cisa natna le ngilsan vei in lum hi: Paul a kungah pai a, thungen in a tungah khut nga a, damsak hi. ");
INSERT INTO csy_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tua ahikom hibang a vawt zawkciang in, tuikul sung a natna nei theampo zong hongpai uh a, dam uh hi: ");
INSERT INTO csy_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Amate in letsong tam mama hongpia uh a, ka din uh ciang in ka kisap uh na tampi tembaw tungah hong koisak uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Tha thum zawkciang phalbi sung theampo tuikul ah ka om uh a, Castor le Pollux ci khiakna nei Alexandria tembaw taw ka pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Syracuse ah ka tawlnga uh a, tua mun ah ni thum sung ka om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Tua mun pan pusuak in ka kiimveal uh a, Rhegium ka theng uh hi: ni khat zawkciang in, thangsang pan hui hong va ahikom, a zingciang in Puteoli ka theng uh hi: ");
INSERT INTO csy_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Tua mun ah suapui te ka mu uh a, amate in ni sali om tu in hong ngen uh hi: tabang in Rome sangah ka pai uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rome a om suapui te in ka thu a zak uh ciang in, koma muak tu in Appii vanzuak na le zintun inn thum kici na pan in hongpai uh hi: taciang Paul in amate a mu ciang in, Pathian pok a, thinnuam in om uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Rome ka thet uh ciang in, zakhat uk ngalkap mangpa in thongtak te thonginn cing topa kungah ap hi: ahihang Paul sia ama nguak in a cingtu ngalkap khat taw omsak hi. ");
INSERT INTO csy_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ni thum zawkciang in, Paul in Judah makai te munkhat ah kaikhawm a: hongpai uh ciang in, amate tung ah, u le nau te awng, mite le ka pu le pa te ngeina langpan in ka vawt na bangma om ngawl hi napi, Jerusalem pan in thongtak tu in Rome mite khut sungah hong ap uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Thu hong dong uh a, thina tak mawna bangma vawt ngawl ci mu a hi uh man in, Rome mite in hong suatak nuam uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ahihang Judah mite in a nial uh ciang in, ka mipui te ka mawsak tu hi ngawl napi, Caesar kungah thusungkik ngawl in suak thei nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Tua ahikom, hi thu hang in noma taw kimu tu le paupui tu in hong sam ka hihi: Israel te lametna atu in thikkol thak ka thuak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Taciang amate in Paul tung ah, nangma taw kisai in Judah ngam pan laithak nga ngawl khu hi, taciang suapui te sung pan in hongpai uh a na phatngawlna thu a son khat zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ahihang na ngaisutna ka za nuam uh hi: banghangziam cile hite pawl te thu taw kisai in, mun tatuam ah midangte langpan in kampau hi, ci ka he uh hi, ci uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Taciang amate in Pual sia nikhat a ciangtansak zawk uh ciang in, a tunna ah mi tampi hongpai uh a; tuate tungah Pathian kumpingam thu tettipang in hilcian hi, Moses thukham le kamsang laibu te sung pan in Jesus thu taw kisai in zingpan kipan nitak sang dong hanthotna nei hi. ");
INSERT INTO csy_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Taciang a son thu te sia mi pawlkhat te in um uh a, pawlkhat te in a um bua uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ama te sungah a thu uh a kisik ngawl uh ciang in, pai uh a, tua zawkciang in Paul in thu khat son hi, Tha Thiangtho in kamsang Isaiah tungtawn in i pu le pa te tung ah, ");
INSERT INTO csy_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Hi mite tungah pai tan a, son in, a zak in za napi, na tel bua uh hi; a mu in mu napi, na tel thei tuan bua uh hi: ");
INSERT INTO csy_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Banghangziam cile, hi minam te sia a mit uh te khua mu ngawl, a bil uh te khua za ngawl, a thinsung in bangma tel thiam ngawl in a nuntak dan te zong ki kheal ngawl uh ahikom in, a natna uh te zong ka damsak ngawl dong in amate sia a thin uh pui lei a, a bil uh te in khua za hak bek domngawl a mit uh te zong thi siat hi, ci in a mantak in son hi. ");
INSERT INTO csy_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Tua ahikom Pathian i ngupna sia Gentile mite tungah ki puak zo a, amate in tua thu ngai tu uh hi, ci in kong phawksak hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Paul in hi thu te a son zawkciang in, Judah mite pai uh a, amate sungah nasiatak in thu kikum uh hi. ");
INSERT INTO csy_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul sia a sap tawm inn ah kum ni sung om hi, taciang a kungah hongpai theampo sang a, ");
INSERT INTO csy_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Pathian kumpingam thupha hil le Topa Jesus Christ taw kisai thu te hangsantak in hil a, kuama in khaktan ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Jesus Christ i sal, Sawltak a hi tu in a ki samtuam le Pathian lungdamna thupha atu koituam, keima Paul in, ");
INSERT INTO csy_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Laithiangtho sungah Ama kamsang te taw in hong kamciam sa, ");
INSERT INTO csy_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","A Tapa, i Topa Jesus Christ thu taw kisai in, Ama sia cilesa taw in David suan sung pan piang a hihi; ");
INSERT INTO csy_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Taciang Pathian Tapa a hina sia, vangletna taw ahizong, thianthona thaa taw ahizong, thina pan thawkikna tungtawn in ahizong, a ki tangko sa a hihi: ");
INSERT INTO csy_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesus Christ tungtawn in thuthiamna le Sawltak hina ka sang zo uh hi, banghangziam cile minam theampo sungah upna thu manna sia Ama min atu a hihi: ");
INSERT INTO csy_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Tua thu theampo sung pan note zong Jesus Christ in hong sam hi: ");
INSERT INTO csy_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","I Pa Pathian le Topa Jesus Christ kungpan thuthiamna le thinnopna sia, Pathian itna le mithiangtho te a kici Rome ah a omte na vekpi tungah hong om tahen, ci in kong paupui hi. ");
INSERT INTO csy_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Na upna uh sia leitung theampo ah ki son ahikom, note theampo atu in Jesus Christ tungtawn in a masabel in ka Pathian tungah ka lungdam hi. ");
INSERT INTO csy_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Banghangziam cile ka thungetna theampo ah tatsat ngawl in hong hel tawntung khi hi, ci sia Ama Tapa i lungdamna thupha sungah ka thaa taw a na ka sepsak Pathian sia ka tetti a hihi; ");
INSERT INTO csy_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Pathian deina a om le bangbang po ahizong hai ngawl in note kungah kong pai thei natu in, thu ka ngen tawntung hi. ");
INSERT INTO csy_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Banghangziam cile note kong mu nuam mama hi, tabang in thaa letsong te hong pia in, a tawp dong na kip thei natu uh a hihi; ");
INSERT INTO csy_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Tabang ka ci ciang in, note le keima sia upna tungtawn in khat le khat ki henep khop thei natu thu a hihi. ");
INSERT INTO csy_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Suapui te awng, Gentile mite sung bangma in note sungah zong nga pha ka nei thei natu in, tam veipi note kungah hong haw tu in ka ngealsa hi napi, ahihang tudong hong haw thei ngawl lai khi hi, ci he ngawl in na om tu uh ka dei bua hi. ");
INSERT INTO csy_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Keima sia Greek mite le mimawl te ahizong; mipil te le a pil ngawl te tungah ahizong leiba khi hi. ");
INSERT INTO csy_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Tua ahikom Rome khua ah a om note kungah zong, ka hi thei za in lungdamna thuhil tu in ka ki ngingkhol zo hi. ");
INSERT INTO csy_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Christ lungdamna thu atu in ka mai a zum bua hi: banghangziam cile hi lungdamna thu sia amasabel in Judah mite tung ah, taciang Greek mite tung ah, a um khatsim ngupkhiatna atu in Pathian i vangletna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Banghangziam cile, a thutang peuma upna taw in nungta tu hi, ci a ki at sa bangma in, tua lungdamna thu sungah Pathian i thutanna sia upna pan upna ah kilang hi. ");
INSERT INTO csy_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Banghangziam cile thuman sia thutan ngawl na taw a len mihing te Pathian nei ngawl nuntak dan le thutan ngawl na taw ki lebul in, Pathian thin-ukna sia van pan in hong kilang hi; ");
INSERT INTO csy_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Tua ahikom amate in Pathian a heak natu thu sia amate sungah kilang zo hi; banghangziam cile Pathian in amate tungah lak zo hi. ");
INSERT INTO csy_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Banghangziam cile leitung a ki bitphua pan kipan in, mit taw mu thei ngawl Pathian i tawntung vangletna le ama i hina te sia a vawt nate tungtawn in ki tel thei hi, tua ahikom amate in paulap a nei bua uh hi: ");
INSERT INTO csy_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Banghangziam cile amate in Pathian a heak uh ciang in, Pathian i hina bang in minthanna pia ngawl uh a, lungdam zong ko ngawl uh hi; ahihang amate ngaisutna te sia man nei ngawl suak siat a, amate mawmawt thinsung te mialcip siat hi. ");
INSERT INTO csy_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Amate le amate ka pil hi, ci uh hi napi, a mamaw suak siat uh hi, ");
INSERT INTO csy_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Taciang a lal thei ngawl Pathian i minthanna sia a lal thei mihing lim, vacim te, peangli nei ngamsa te le a bokvak te taw lai uh hi. ");
INSERT INTO csy_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Tua ahikom amate pumpi te sia amate le amate thupi kisa ngawl tu in, Pathian in zong amate i thinsung deina tungtawn in a thiangtho ngawl mun ah ap hi: ");
INSERT INTO csy_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Amate in Pathian thuman sia leilot thu suaksak uh a, tawntung minthanna bitphuapa Pathian sang in a bitphua sa te bia in paai zaw uh hi. Amen. ");
INSERT INTO csy_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Hi thu hang in Pathian in amate sia maizumhuai cilesa deina ah ap hi; banghangziam cile numei te nangawn amate numei hi nate a ngeina bang in zang nuam ngawl a, numei le numei ki khialpui khawm uh hi: ");
INSERT INTO csy_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Tasia bangma in pa te zong a ngeina bang in numei taw omkhop na nusia a, pa le pa ki laklaw ki thangai na sia mei bang in kuang hi; tabang in pa te sia pa te taw maizumhuai na phangawl te a vawt uh hu in, na phangawl sep thaman amate tungah theng hi. ");
INSERT INTO csy_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Amate in Pathian sia amate heakna sungah cepte tawntung tu a uk ngawl uh hu in, a ngamtat huai ngawl nate vawt tu in thinsung phangawl ah amate ap hi; ");
INSERT INTO csy_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Amate sia thutan ngawl na taw dim uh a, paktatna, ngitlona, duhopna, deisakna phangawl, vang enna taw kidim, tual that, thu ki nialna, ki theamna, sonsiatna; ngual huau ku te, ");
INSERT INTO csy_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Ngual phunsan te, Pathian a ensan te, ngual zawngsak te, mihing ki phasak te, a ki suangtak te, na phangawl vawttawm te, nulepa thu ngai ngawl te, ");
INSERT INTO csy_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Tel theina nei ngawl te, thukham paltan te, ngeina bang in a ki tha ngai ngawl te, ki lemna a vawt nuam ngawl te, hesuakna nei ngawl te: ");
INSERT INTO csy_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Hibang nate a vawt te sia a thi tu in kilawm hi, ci amate in Pathian thukhenna sia he napi, amate vateak in vawt bek domngawl in, a vawt te tungah zong lungkimpui uh hi. ");
INSERT INTO csy_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Tua ahikom, pasal pa awng, kuapo nahizong ngualdang tung thu a khen nangma in bangma paulap na nei bua hi: banghangziam cile ngualdang thu na khen na mun ah nangma le nangma thu a ki khen na hihi. ");
INSERT INTO csy_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ahihang tabang a ngamta te tungah Pathian thukhenna sia thuman ahina taw kizui in thukhen hi, ci thiangtak i he hi. ");
INSERT INTO csy_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Maw pasal pa awng, tabang te a ngamta te bang in na ngamta uh ahile, Pathian thukhenna taw kipeal thei tu, ci ki ngaisun ni ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Ahi bale Pathian phatna in kisikikna ah hong makai hi, ci he ngawl in, a dimlet a phatna, thuakzawkna le thinsauna te thusimngawl ni ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Ahihang asak mama le a kisik nuam ngawl na thinsung in nangma vateak atu in thin-ukna ni le a thutang Pathian thukhenna a kilang natu in a khol na hihi. ");
INSERT INTO csy_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Pathian in mihing khatsim ama ngamtatna bang in thukkik tu hi: ");
INSERT INTO csy_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Thinsau in napha seam paisuak a, minthanna, upatna le thi thei ngawl nuntakna a zong peuma tawntung nuntakna pia tu hi: ");
INSERT INTO csy_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ahihang thu ki nialna a piangsak te le thuman zui ngawl a, thutan ngawl na a zui te tung ah, Pathian thin-ukna pia tu hi, ");
INSERT INTO csy_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Na phangawl a vawt te, a masabel in Judah mite, taciang Gentile mite zong, mihing khatsim tungah haksatna le thinngimna om tu hi; ");
INSERT INTO csy_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Ahihang a masabel in Judah mi, taciang Gentile mite ahi zong, a pha a ngamta mihing khatsim tungah minthanna, upatna le thinnopna om tu hi: ");
INSERT INTO csy_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Banghangziam cile Pathian in mihing doidan nei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Banghangziam cile thukham nei ngawl in a maw te theampo thukham nei ngawl ma in lalcip tu uh hi: taciang thukham sungah mawna a vawt te thukham in thukhen tu hi; ");
INSERT INTO csy_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Banghangziam cile thukham a za te sia Pathian mai ah thutang suana nga ngawl hi, ahihang thukham bang in a ngamta te thutang suana nga tu uh hi. ");
INSERT INTO csy_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Banghangziam cile thukham a nei ngawl Gentile mite in, thukham sungah a om thu te sia amate pianpui heakna taw a sep uh ciang in, thukham nei ngawl napi, tua te sia amate atu in thukham hi veve tu hi. ");
INSERT INTO csy_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Tabang te in amate thinsung pan thukham i nasep kilangsak a, amate i sia le pha heak na in zong tettipang hi, taciang amate ngaisutna in amate mawsiat hi, a hibale, maisak hi; ");
INSERT INTO csy_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Keima i lungdamna thu bang in mihing te thuku te sia Jesus Christ tungtawn in Pathian in tua ni ciang thukhen tu hi. ");
INSERT INTO csy_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","En in, nangma sia Judah mi a kici khat na hi a, thukham sungah na tawlnga hi, taciang Pathian sungah na ki suangtak hi, ");
INSERT INTO csy_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Thukham sung pan a ki hil na hikom in, Pathian deina na he a, taciang a phazaw nate zong na teal thei hi; ");
INSERT INTO csy_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Nangma le nangma sia mittaw te lamlak pa, khuazing sungah a omte atu in khuavak, ");
INSERT INTO csy_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Taciang a mawmaw te le patang te a hil tu, thukham sung pan in heakna le thuman a nei, ci in kimuanna na nei hi. ");
INSERT INTO csy_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Tua ahikom ngualdang ahil nangma in, nangma le nangma ki hil ngawl ni ziam? ngualdang tungah nguta ngawl tu, ci na hil a, nangma na nguta ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Nangma in palngul mawna vawt ngawl tu ci napi, nangma in vawt ni ziam? milim te lipkhap hi napi, biakinn sung van le nate phuul na hi ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Thukham sungah na ki suangtak napi, thukham paltan nataw in na Pathian melsia ni ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Banghangziam cile Gentile mite sungah nangma hang in Pathian min ki sonsia hi, ci in a ki atsa om hi. ");
INSERT INTO csy_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Banghangziam cile thukham na zui ahile vunteap tanna sia phatuam takpi hi: ahihang thukham na paltan ahile, na vunteap tanna zong vunteap tan ngawl hong suak hi. ");
INSERT INTO csy_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Tua ahikom vunteap tan ngawl te in thukham i thumanna a zui le, ama vunteap tan ngawl na sia vunteap tan na bang in kisimsak tu hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Taciang ngeina om bang in hunteap tan ngawl khat in thukham kicingsak ahile, vunteap tan in thukham a paltan nangma sia thu hong khen hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Banghangziam cile a puasang bek Judah mi a hi sia Judah mi hi ngawl hi; a puasang cilesa vunteap tan zong vunteap tanna hi ngawl hi: ");
INSERT INTO csy_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ahihang a sungsang Judah mi a hi sia, Judah mi tatak hi; taciang lai taw a ki at thukham hi ngawl in, thinsung le thaa sungah vunteap tanna sia vunteap tan na tatak a hihi; tua lapsangna sia mihing tung pan hi ngawl a, Pathian tung pan a hihi. ");
INSERT INTO csy_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tabang ahile Judah mite in bang tungtuanna nei ziam? a hibale vunteap tan sia bang phatuam ziam? ");
INSERT INTO csy_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Phattuamna tam mama om a: a thupibel sia, Pathian kammal te amate tungah a ap hang a hihi. ");
INSERT INTO csy_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Banghangziam cile mi pawlkhat te in a um bua ahile bang a suak tu uh ziam? amate up ngawl na in Pathian upna a phiat thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Phiat thei thathong ngawl hi: Pathian sia thuman tahen, ahihang mihing khatsim sia leilot thu son a hihi; nangma sia na kampauna ah thutang suana na nga thei natu in le thukhenna na thuak ciang in na zaw thei natu hi, ci in ki atkhol hi. ");
INSERT INTO csy_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ahihang eite thutan ngawl na in Pathian i thutanna kilangsak ahile, bang i ci thei tu ziam? Pathian i phulamna hang in Ama sia thutang ngawl ziam? Hisia sia mihing bang in ka pau a hihi. ");
INSERT INTO csy_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Hi phaphot ngawl hi: tabang hile Pathian in leitung sia bangbang in thukhen tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Banghangziam cile keima i leilot na tungtawn in Pathian i thumanna sia Ama minthanna tu in khang ahile; banghang in keima sia mawnei ka hina bang in thukhennna thuak khi ziam? ");
INSERT INTO csy_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Taciang, a pha a suak tu in a phangawl vawt tawng, banghang ci zaw ngawl hi ziam? tabang in ngual in mawsiat in hong son a, pawlkhat te in ci takpi uh hi, hong ci hi, amate i mawsakna a man a hihi. ");
INSERT INTO csy_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Tabang ahile bang i ci tu ziam? amate sang in eite phazaw hi ziam? Hi ngawl hi, bangbang po ahizong ki phazaw tuan ngawl hi: banghangziam cile Judah mite le Gentile mite theampo mawna nuai ah om uh hi, ci tetti i mu zo hi; ");
INSERT INTO csy_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Mi pha om ngawl hi, khat zong om ngawl hi: ");
INSERT INTO csy_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","A telthiang kuama om ngawl hi, Pathian a zong kuama om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Amate a vekpi in lampial siat zo uh a, bangma phattuamna om ngawl suak siat zo uh hi, napha a vawt kuama om ngawl hi, khat zong om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Amate longtawl sia than ki hong bang hi; amate leii te sia ngual theam na in zang uh hi; amate muk ah ngul ngu om hi: ");
INSERT INTO csy_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Amate kam sia hamsiatna le kammal kha taw kidim hi: ");
INSERT INTO csy_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Amate i peang te sia thisan sua tu in zuanngang mama hi: ");
INSERT INTO csy_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Amate i lampi ah siatsuana le haksatna te om hi: ");
INSERT INTO csy_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Taciang amate in thinnopna lampi a he ngei bua uh hi: ");
INSERT INTO csy_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Amate i mit ah Pathian zatakna om ngawl hi, ci in ki at khol hi. ");
INSERT INTO csy_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tu in thukham i a son theampo sia thukham nuai ah a omte tungah son hi, ci i he hi: tabang in kam theampo sia ki hup tu a, leitung mi theampo Pathian mai ah mawnei suak tu hi. ");
INSERT INTO csy_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Tua ahikom Pathian mai ah thukham zuina hang in kuama in mipha suak zo ngawl tu hi: banghangziam cile thukham sia mawna heakna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Ahihang thukham ki hel ngawl in Pathian i phatna sia tu in hong kilang zo hi, tasia sia thukham le kamsang te in tettipang uh hi; ");
INSERT INTO csy_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Jesus Christ upna tungtawn in Pathian i phatna sia a um theampo te tung le a umte theampo tungah om hi: banghangziam cile bangma ki lamdanna om ngawl hi: ");
INSERT INTO csy_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Banghangziam cile mi theampo mawsiat zo a, Pathian i vangletna sang ban nawn ngawl hi; ");
INSERT INTO csy_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Christ Jesus sungah tatna tungtawn in Pathian hesuakna hang in thutangsuana a thong in i sang hi: ");
INSERT INTO csy_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Pathian in Christ Jesus sia thisan upna tungtawn in a thin-ukna a dapsak tu in a koi hi a, Ama thutang suana tangko natu a hihi, banghangziam cile Pathian i thuakzawkna tungtawn in a bosa hun mawna te pan in suatak natu a hihi; ");
INSERT INTO csy_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Jesus a umte le a thutansak te thutang a sua thei natu in Ama i thutang suana sia tu in tangko tu hi, ci in kong son hi. ");
INSERT INTO csy_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Tabang ahile, ki suantak natu koisung om ziam? ki suantakna ki vawk zo hi. Bang thukham in vawk ziam? sepna te a hi ziam? Hi ngawl hi: ahihang upna thukham in vawk hi. ");
INSERT INTO csy_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Tua ahikom mihing khat sia thukham in sepna ki hel ngawl, upna tungtawn in thutang suana nga hi, ci in i thu i khup hi. ");
INSERT INTO csy_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ama sia Judah te Pathian bek a hi ziam? Gentile te Pathian zong hi ngawl ziam? Hi hi, Gentile te Pathian zong hi veve hi: ");
INSERT INTO csy_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Vunteap tanna le tan ngawl nate sia upna tungtawn in thutang suana hong ngasak tu Pathian khat bek om hi. ");
INSERT INTO csy_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Tabang ahile upna tungtawn in thukham vawk i hi ziam? i vawk bua hi: thukham a khosak zaw i hihi. ");
INSERT INTO csy_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Tabang ahile eite i pa Abraham thu bangbang son tu hi ziam, cilesa taw kisai bang mu ziam? ");
INSERT INTO csy_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Banghangziam cile Abraham sia a sepna te hang in thutang suana nga ahile, ki suantak natu nei hi; ahihang Pathian mai ah hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Banghangziam cile laithiangtho in bang hong ci ziam? Abraham in Pathian um a, tua a upna sia thutang suana in ceptesak hi. ");
INSERT INTO csy_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Tu in naseam khat sia a sep thaman sang hi, hesuakna ci in ngaisut tu hi ngawl zaw a, a leibat hi zaw hi. ");
INSERT INTO csy_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Ahihang a seam ngawl khat sia Pathian nei ngawl te thutangsakpa a up uh hu in, tua a upna sia thutang suana in ceptesak hi. ");
INSERT INTO csy_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Pathian in sepna kihel ngawl napi, mi thutang in a cepte mi khat i thupha sang ahina thu sia David in a sonna ah, ");
INSERT INTO csy_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","A phatngawl nate maisak na le, a mawna te a ki phualsealsak te sia mihing thuphatoai te a hihi. ");
INSERT INTO csy_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Topa i a mawsak ngawl pa sia thuphatoai a hihi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Hi thupha sia vunteap tan te tung bek ah ahi ziam, a hibale, vunteap tan ngawl te tung zong a theng veve ziam? banghangziam cile, Abraham i a upna sia thutang suana in ceptesak hi, i ci hi. ");
INSERT INTO csy_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Tabang hile bangbang in ceptesak ziam? vunteap a tan zawkciang ziam maw, a hibale vunteap a tan ma ziam? Vunteap a tan zawkciang hi ngawl hi, vunteap a tan ma hi zaw hi. ");
INSERT INTO csy_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Abraham in vunteap tan taw ceptena sang hi, tua thu sia vunteap a tan ma in a neisa upna hang in thutang suana kipsakna a hihi: tabang in vunteap tan ngawl te ahizong a um theampo te i Pa ahi thei natu le vunteap tan ngawl te zong a upna uh thutang suana in a ceptesak thei natu a hihi: ");
INSERT INTO csy_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Taciang ama sia vunteap a tan te i Pa bek hi ngawl in, eite i Pa Abraham in vunteap a tan ma in a neisa upna khaw-ni a zui te i Pa zong a hihi. ");
INSERT INTO csy_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Banghangziam cile Abraham le a suan a pal te leitung ngamhlua tu in a kamciam sia thukham taw hi ngawl hi, ahihang upna i thutang suana tungtawn a hihi. ");
INSERT INTO csy_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Banghangziam cile thukham a zui te ngamhlua te ahile, upna sia mannei ngawl suak hi, taciang kamciam zong mannung ngawl hong suak hi: ");
INSERT INTO csy_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Banghangziam cile thukham in Pathian thin-ukna piangsak hi: banghangziam cile thukham om ngawl na mun ah, thukham palsat na om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Tua ahikom in kamciam sia hesuakna hang in, upna tungtawn in i nga hi; ci sia a suan le pal theampo in a tawpdong a telthiang thei natu a hihi; tasia sia thukham a zui te bek hi ngawl in, Abraham bang in upna nei te zong kihel hi; banghangziam cile Abraham sia eite theampo i Pa a hihi, ");
INSERT INTO csy_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Minam tampi te i Pa in kong vawt zo hi, ci a ki atsa bang in, Abraham sia, mithi te a thokiksak, a om ngawl lai nate a omsa bang in a son, a up Pathian mai ah eite theampo i Pa a hihi. ");
INSERT INTO csy_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Na suan le pal te sia tabang in hi tu hi, ci a son bang in, minam tampi te i Pa hi tu lam-et om ngawl napi, upna taw lam-etna nei nginge hi. ");
INSERT INTO csy_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","A upna thaneam ngawl ahikom, Abraham sia kum zakhat kiim a phak ciang in, ama pumpi le Sarah i sul sia a thisa bang in ngaisun ngawl hi: ");
INSERT INTO csy_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Pathian kamciam muangla ngawl in, a upna thahat ahikom, Pathian pokna pia hi; ");
INSERT INTO csy_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Pathian in kamciam a piak na bang in vawt thei hi, ci um ngam takpi hi. ");
INSERT INTO csy_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Tua ahikom a upna sia Pathian in thutang suana in ceptesak hi. ");
INSERT INTO csy_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Tu in hi upna thutang suana in a ceptesak sia, ama atu bek in a ki at hi ngawl hi; ");
INSERT INTO csy_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Ahihang eite i Topa Jesus Christ thina pan a thokiksak sia i um ahile, eite atu zong thutang suana in hong ceptesak tu hi; ");
INSERT INTO csy_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Eite mawna hang in ki ap a, eite thutang suaksak tu in thina pan ki thokiksak hi. ");
INSERT INTO csy_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Tua ahikom upna tungtawn in mipha a ki tangsak te i hikom in, i Topa Jesus Christ tungtawn in Pathian taw kilemna i nei hi: ");
INSERT INTO csy_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Ama tungtawn in hi i dinmun thuthiamna sungah, upna taw tum thei i hihi, taciang Pathian i minthanna lamen i hikom i lungdam hi. ");
INSERT INTO csy_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Hisia bek hi ngawl in, haksatna tampi sungah zong i ki suangtak thei hi: banghangziam cile haksatna in thuakzawkna piangsak hi, ci zong i he hi; ");
INSERT INTO csy_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Taciang thuakzawkna in phulthak heakna piangsak a; phulthak heakna pan in lametna piangsak hi: ");
INSERT INTO csy_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Taciang lametna in maizumna piangsak ngawl hi; banghangziam cile eite tungah hongpiak Tha Thiangtho tungtawn in eite thinsung ah Pathian itna hong buak zo hi. ");
INSERT INTO csy_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Banghangziam cile hatna i nei ngawl laitak, Pathian nei ngawl te atu in Christ sia a hun lian in hong thi hi. ");
INSERT INTO csy_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Banghangziam cile a thutang pa khat atu in mihing khat a thi tu haksa mama tu hi: mipha atu in a thi ngam pawlkhat om thei tha tu hi. ");
INSERT INTO csy_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Ahihang mawnei i hi laitak in eite atu Christ hong thi zo ahikom, Pathian in eite hong itna hong kilangsak hi. ");
INSERT INTO csy_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Tu in a thisan tungtawn in thutang suana nga zo bekdom ngawl in, Ama tungtawn in Pathian thin-ukna pan in i suakta tu hi. ");
INSERT INTO csy_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Banghangziam cile a ngal te i hi laitak, a Tapa i thina tungtawn in Pathian taw kilemna hong vawtsak hi, tuabek domngawl in, kilemna nei zo i hikom, Ama nuntakna in hong ngum tu hi. ");
INSERT INTO csy_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Hiteng domngawl in, i Topa Jesus Christ tungtawn in Pathian sungah eite zong i lungdam hi, tu in Ama tungtawn in tatkhiatna i sang hi. ");
INSERT INTO csy_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Mihing khat hang in hileitung ah mawna hong tum a, tua mawna hang in thina hong theng hi; taciang mi theampo tungah thina hong theng hi, banghangziam cile mi theampo maw siat zo uh hi: ");
INSERT INTO csy_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Banghangziam cile thukham a om ma in leitung ah mawna om zo hi: ahihang thukham a om ma in mawsakna om ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Ahihang Adam pan in Moses dong, Adam khialna bang in a maw ngawl te zong thina in uk hi, tua Adam sia hongpai lai tu pa i lim a hihi. ");
INSERT INTO csy_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ahihang a thong a ki nga letsong sia Adam mawna taw kibang ngawl hi. Banghangziam cile mi khat i mawna hang in mi tampi thi ahile, Pathian hesuakna tam seseam hi, tua hesuakna hang in letsong sia, mihing khat ahi Jesus Christ tungtawn in mi tampi tungah hong pung hong khang hi. ");
INSERT INTO csy_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Taciang hi letsong sia mihing khat i mawna taw kibang ngawl hi: banghangziam cile thukhenna sia mihing khat hang in mawsakna hong theng hi, ahihang man piak ngawl letsong sia mawna tampi pan in thutang suasakna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Banghangziam cile mihing khat mawna hang in thina in uk ahile; a dimlet hesuakna le thutang suana letsong a sang te nuntakna sia Jesus Christ in a tam zawkan in uk tu hi. ");
INSERT INTO csy_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Tua ahikom mihing khat i mawna hang in mi theampo tungah thukhenna le mawsakna a thet bangma in; mihing khat i thutanna tungtawn in mi theampo tungah man piak ngawl letsong, thutang suasakna nuntakna hong theng hi. ");
INSERT INTO csy_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Banghangziam cile mihing khat i thunit ngawlna tungtawn in mi tampi mawnei suak hi, tasia bangma in mihing khat thunitna tungtawn in mi tampi thutang suak tu hi. ");
INSERT INTO csy_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Tuabek domngawl in, thukham hong tum a, mawna hong khang hi. Ahihang mawna a khanna mun ah, hesuakna a tamzaw in hong khang hi: ");
INSERT INTO csy_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Tabang in mawna in thina dong a uk bangma in, i Topa Jesus Christ tungtawn in thuthiamna in thutang suana tungtawn in tawntung nuntakna dong uk hi. ");
INSERT INTO csy_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Tabang ahile bang i son lai tu ziam? Hesuakna a khan thei natu in mawna vawt lai tu hi ziam? ");
INSERT INTO csy_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Hi ngawl het hi. Mawna ah a thi eite tua mawna sungah bangbang in nungta tu hi ziam? ");
INSERT INTO csy_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Jesus Christ sungah tuiphumna a sang eite mi tampi te Ama thina sungah tuiphumna i sang zo hi, ci he ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Tua ahikom tua tui kiphumna tungtawn in Ama taw thina sungah a ki vui i hihi: Christ sia Pa i minthanna taw in a thawkiksak bangma in, eite zong nuntakna thak sungah i nungta tu hi. ");
INSERT INTO csy_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Banghangziam cile ama i thina taw a kibang in a kisuan te i hile, Ama thawkikna ah zong i thokik tu hi: ");
INSERT INTO csy_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Mawna pumpi sia susia tu in, i mihing lui sia Christ taw thinglamte tungah khen khawm zo hi, hi thu he in, eite tu pan kipan in mawna i sal i seam nawn buatu hi. ");
INSERT INTO csy_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Banghangziam cile mithi sia mawna pan in a suakta hi. ");
INSERT INTO csy_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Tu in eite Christ taw i thi khawm le, Ama taw i nungta khawm tu hi, ci i um hi: ");
INSERT INTO csy_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Thina pan a ki thokiksak Christ sia thikik nawn ngawl hi; thina in Ama tungah thunei nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Banghangziam cile Christ sia mawna atu khatvei thi hi: ahihang a nuntak kikna sia, Pathian atu in nungta hi. ");
INSERT INTO csy_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Tasia bangma in noma le noma zong mawna taw kisai a thi tatak in ki ngaisun vun, ahihang i Topa Jesus Christ tungtawn in Pathian sungah i nungta hi, ci ngaisun tavun. ");
INSERT INTO csy_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Tua ahikom cilesa deina zui tu in a thi thei na pumpi uh sia mawna in uk heak tahen. ");
INSERT INTO csy_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Na pumpi nate uh sia a phangawl lam a vanzak te a hi ngawl natu in mawna sungah ap heak vun: ahihang thina pan a nungta te bang in, na pumpi nate uh sia thutang suana i vanzak te bang in Pathian kungah noma le noma ki ap tavun. ");
INSERT INTO csy_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Banghangziam cile mawna in note tungah thu nei ngawl tu hi: banghangziam cile note sia thukham nuai ah hi ngawl in, thuthiamna nuai ah na om uh hi. ");
INSERT INTO csy_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Tabang ahile bang i ci tu ziam? thukham nuai ah hi ngawl in thuthiamna nuai ah om i hikom, mawna vawt te i hi ziam? Hi peuma ngawl hi hing. ");
INSERT INTO csy_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Note in khat le khat tungah ama sal hi tu le a thunit tu in noma le noma na ki ap uh a hile, tua in thina tu mawna, a hibale, thutang suana tu thunitna i sal na hi uh hi, ci he ngawl na hi uh ziam? ");
INSERT INTO csy_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Ahihang Pathian ki pok tahen, banghangziam cile note sia mawna i sal te na hi ngei uh a, note tungah hong ap hilna sia note in na thinsung uh pan in na zui zo uh hi. ");
INSERT INTO csy_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Mawna pan in a ki suaktasak te na hi uhkom in, note thutang suana i sal te na suakkik zo uh hi. ");
INSERT INTO csy_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Na cilesa uh i thaneamna hang in mihing ngeina bang in kong son hi: na pumpi nate sia thiantho ngawl na le phat ngawlna khat zawkciang khat tungah hong ap ngei bangma in; tu in na pumpi nate sia thutang suana le thianthona i sal te hi tu in ap tavun. ");
INSERT INTO csy_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Banghangziam cile mawna i sal te na hi uh lai in, thutang suana taw na kipeal uh hi. ");
INSERT INTO csy_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Tu in na maizum na uh tua nate hang in bang phattuamna na nei ngei uh ziam? banghangziam cile tabang te i tawpna sia thina a hihi. ");
INSERT INTO csy_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Ahihang tu in mawna pan na suakta zo uh a, Pathian i sal te suakzo na hi uhkom, thianthona sangah na phatuam uh a, a tawpna sia tawntung nuntakna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Banghangziam cile mawna thaman sia thina a hihi; ahihang Pathian letsong sia i Topa Jesus Christ tungtawn in tawntung nuntakna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Thukham a he suapui te awng, mihing khat sia thukham in a nuntaksung theampo uk hi, ci he ngawl nu ziam? ");
INSERT INTO csy_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Banghangziam cile pasal a nei numei sia a pasal nuntaksung theampo thukham in hen hi; ahihang a pasal a thi le, a pasal thukham pan in suakta hi. ");
INSERT INTO csy_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Tua ahikom a pasal a nuntak lai teng, pasal dang taw a teang le, palngul mawna vawt nu, kici tu hi: ahihang a pasal a thi le, tua thukham pan in suakta a, pasal dang a nei hial zong, palngul mawna vawt hi nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Tua ahikom, ka suapuite awng, note sia thina pan a thokik a dang khat i zi a hi tu le Pathian atu in nga pha tampi na nga thei natu uh in, Christ pumpi tungtawn in na thi uh a, thukham taw na ki khen uh hi. ");
INSERT INTO csy_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Banghangziam cile cilesa sungah i omlai in, mawna i deina te sia thukham tungtawn in i pumpi nate sungah thina dong in nga tampi nga tu in naseam hi. ");
INSERT INTO csy_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Ahizong tu in i thi laitak na ngawn in hong lencip thukham taw i kipeal zo hi; tasia in a ki at thukham ngeina lui bangin na i seam nawn bua a, thaa i thaksuana bang in i seam zaw hi. ");
INSERT INTO csy_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Tabang hile bang i son tu ziam? Thukham maw ziam? maw ngawl hi. Thukham om bale, mawna thu i he batu hi: banghangziam cile thukham in ngual neisa dungawk heak in, ci bale, ngual neisa dungawkna sia bangziam ci ka he batu hi. ");
INSERT INTO csy_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Ahihang mawna in thukham beal in hunpha la a, ka sungah cilesa deina namcin piangsak hi. Banghangziam cile thukham om ngawl hile mawna sia a thi a hihi. ");
INSERT INTO csy_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Banghangziam cile thukham ngawl taw keima ka nungta ngei hi: ahihang thukham hong thet ciang in, mawna sia hong ki thaksua kik a, ka thi hi. ");
INSERT INTO csy_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Taciang nuntakna hong pia tu thukham sia, thina hong pia hi, ci ka mu hi. ");
INSERT INTO csy_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Banghangziam cile mawna in thukham beal in hunpha la a, hong theam hi, taciang hong that hi. ");
INSERT INTO csy_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Tua ahikom thukham le thupiak sia thiangtho hi, taciang thuman a, pha hi. ");
INSERT INTO csy_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Tabang hile pha a kici thukham sia keima tungah thina hong suak ziam? Suak ngawl het hi. Ahihang mawna sia mawna a hina kilangsak tu in ka sungah na pha in thina piangsak hi; tabang in thukham hang in mawna sia a khial pi khat hong suak hi. ");
INSERT INTO csy_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Banghangziam cile thukham sia thaa taw kisai hi, ci ka he hi: ahihang keima sia cilesa taw kisai ka hi a, mawna nuai ah a kizuak sa ka hihi. ");
INSERT INTO csy_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Banghangziam cile bang ka seam ci ka he bua hi: banghangziam cile ka vawt nop te ka vawt bua hi; ahihang ka ngaimawk te keak ka vawt zaw hi. ");
INSERT INTO csy_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Tabang in ka vawt nop ngawl te ka vawt le, thukham sia pha hi, ci in ka lungkim hi. ");
INSERT INTO csy_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Tu in tabang ahile a vawt sia keima hi ngawl in, ka sungah a om mawna in vawt a hihi. ");
INSERT INTO csy_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Banghangziam cile ka cilesa sungah na pha khat zong om ngawl hi, ci ka he hi: banghangziamcile ka sungah na pha vawt nopna om napi; bangbang in vawt tu, ci ka mu bua hi. ");
INSERT INTO csy_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Banghangziam cile ka vawt nop na pha te ka vawt bua a: ka vawt nop ngawl na phangawl te ka vawt zaw hi. ");
INSERT INTO csy_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Tu in ka vawt nop ngawl te ka vawt le, a vawt sia keima hi ngawl zaw in, ka sungah a om mawna in vawt a hihi. ");
INSERT INTO csy_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Na pha ka vawt nop ciang in ka sungah na phangawl a omsak thukham ka mu hi. ");
INSERT INTO csy_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Banghangziam cile ka sungsang mihing sia Pathian thukham sungah nuamsa hi: ");
INSERT INTO csy_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Ahihang ka pumpi nate sungah ka thinsung a om thukham taw a ki lebul thukham dang ka mu hi, tasia sia ka pumpi nate sungah a om mawna i thukham sungah sal hong tangsak sia in hong lampui hi. ");
INSERT INTO csy_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Maw keima bangza in buai khi ziam! hi thina pumpi pan in kua in hong suatak tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","I Topa Jesus Christ tungtawn in Pathian ka pok hi. Tua ahikom keima thinsung tatak taw Pathian thukham ka zui hi; ahihang ka cilesa in mawna i thukham zui hi. ");
INSERT INTO csy_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Tua ahikom tu in cilesa thukham bang in nungta ngawl in, Thaa thukham bang in a nungta, Christ Jesus sungah a omte atu in mawsiatna om nawn ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Banghangziam cile Christ Jesus sungah nuntakna Thaa thukham in mawna le thina thukham pan in hong suaktasak zo hi. ");
INSERT INTO csy_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Banghangziam cile cilesa tungtawn in thukham sia thaneam in, a vawt thei ngawl te sia Pathian in vawt tu in mawna taw a dim cilesa bang in a Tapa hong sawl a, mawna atu in cilesa sungah mawna sia puavawk hi. ");
INSERT INTO csy_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Tabang in cilesa deina bang in nungta ngawl a, Thaa i deina bang in a nungta eite sungah, thukham i thutanna a khuangkhim natu a hihi. ");
INSERT INTO csy_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Banghangziam cile cilesa deina bang in a nungta te in cilesa taw kisai thu te ngaisun hi; ahihang Thaa i deina bang in a nungta te in Thaa taw kisai thu te ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Banghangziam cile cilesa deina bang in ngaisutna sia thina a hihi; ahihang thaa i deina bang in ngaisutna sia nuntakna le thinnopna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Cilesa taw kisai ngaisutna sia Pathian i ngal a hihi: banghangziam cile hi te in Pathian thukham zui nuam ngawl a, zui zong zui thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Tua ahikom cilesa sungah a omte in Pathian lungkimsak thei ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Ahihang note sia cilesa sungah hi ngawl in, Thaa sungah na om uh hi, tabang in Pathian Thaa note sungah om hi. Tu in khatpo in Christ i Thaa a nei bale ama sia Christ i neisa hi ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Taciang note sungah Christ a om le, pumpi sia mawna hang in thi napi, Thaa sia thutang suana hang in nungta hi. ");
INSERT INTO csy_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Ahihang Jesus sia thina pan in a thokiksak Thaa sia note sungah a om le, Christ sia thina pan a thokiksak sia in a thi thei na pumpi uh zong note sungah a om Ama Thaa tungtawn in hong nungtasak tu hi. ");
INSERT INTO csy_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Tua ahikom, suapui te awng, eite sia cilesa deina bang a nungta tu in, cilesa taw kisai leiba nei te i hi bua hi. ");
INSERT INTO csy_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Banghangziam cile cilesa deina bang in na nungta uh le, na thi tu uh hi: ahihang Thaa tungtawn in na pumpi uh i nasep te na thisak uh a hile, na nungta tu uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Banghangziam cile Pathian Thaa i lampui theampo sia, Pathian i tate a hihi. ");
INSERT INTO csy_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Banghangziam cile a lau tu in sal hina thaa na sang bua uh hi; ahihang note in ta suasakna Thaa na sang zaw uh hi, tua Thaa tungtawn in Abba, Pa awng, ci in i sam hi. ");
INSERT INTO csy_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Eite sia Pathian tate i hihi, ci sia Thaa ama tatak in eite i thaa taw tettipang hi: ");
INSERT INTO csy_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Taciang tate i hile, ngamhlua te i hihi; Christ taw kizom in Pathian ngamhlua te i hihi; tabang in Ama taw i thuakkhawm le, Ama taw i minthang khawm tu hi. ");
INSERT INTO csy_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Banghangziam cile eite tungah hong kilang tu minthanna sia tu in i thuakna te taw sonte thamman ngawl hi, ci ka ngaisun hi. ");
INSERT INTO csy_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Banghangziam cile Pathian tapa te kilakna sia bitphua sate theampo in lametna taw ngakla tek uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Banghangziam cile bitphua sate sia bangma ngawl i nuai ah koi tu in a ki vawt a hihi, ahihang amate deina bang in om hi ngawl a, a piangsak pa in lametna taw a piansak hi zaw hi, ");
INSERT INTO csy_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Piansak nate sia siatna sal hina pan in suatak tu a, Pathian tate i a minthang suatakna ah tum tu uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Tuni dong in piansak na theampo sia nautun nat thuak bang in tau in om uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Taciang amate bek hi ngawl in, Thaa i nga masabel a nei eite mama zong i pumpi tatkhiatna, ta suasakna ngak in i sungsang pan in i tau tek veve hi. ");
INSERT INTO csy_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Banghangziam cile lametna tungtawn in ngupnga te i hihi: ahihang i lametna sia mu zo hileang lametna hi ngawl hi: banghangziam cile mihing khat in a musa te bangbang in lamen lai tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Ahihang i mu ngawl khat lamen hileang, thuakzawkna taw i ngak hi. ");
INSERT INTO csy_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Tasia bangma in Thaa in i thaneamna te hong hu hi: banghangziam cile bang ngen tu ci zong i he bua hi: ahihang Tha ama tatak ma in i son thei ngawl te sia tau kawm in eite atu in thu hong ngetsak hi. ");
INSERT INTO csy_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Taciang in thinsung a encik pa in Thaa i thinsung he hi, tua ahikom Pathian deina bang in mithiangtho te atu in thungetsak hi. ");
INSERT INTO csy_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Pathian a it peuma le Ama ngealna bang in a sap te atu in, na theampo te a pha tu in vawt tek uh hi, ci i he hi. ");
INSERT INTO csy_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Banghangziam cile Pathian Tapa sia suapui tampi sungah tapa upabel ahi thei natu in, Pathian in a heakkhol sa te sia a Tapa i meal taw a kibang tu in tealkhol hi. ");
INSERT INTO csy_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Tuabek domngawl in, a tealsa te sam a, taciang a sap te sia thutang suaksak hi: taciang thutang a suasak te zong minthanna pia hi. ");
INSERT INTO csy_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Tabang a hile hi thu te bang i law tu ziam? Pathian sia eite atu a hile, a kua in hong langpan thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","A Tapa cikteak nangawn khe ngawl in, eite theampo atu a pia Pathian in, na theampo zong a Tapa taw a thong in hong pia ngawl in om tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Pathian i tealsa te sia a kua in mawsak thei tu ziam? Pathian sia thutang hong suaksak pa a hihi. ");
INSERT INTO csy_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ngual a mawsak sia a kua ziam? Christ sia thi a, thokik hi, ama sia Pathian ziatsang ah om a, eite atu in thu hong ngetsak hi. ");
INSERT INTO csy_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Christ i itna pan in kua in hong khen tu ziam? haksatna, thinngimna, ngimna, kial, pumnguak hina, lauhuai na le namsau te in hong khen thei tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","A ki atkholsa bang in, nangma atu in kote sun khuateak in thalup ka thuak uh hi; thalup tu in a kikoi tuu bang in cepte te ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ahihang, hi thu theampo sungah kote hong it pa tungtawn in ngualzo te sang in ngualzo zaw te ka hi uh hi. ");
INSERT INTO csy_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Banghangziam cile thina, nuntakna, vantung mite, doai te, thuneina te, tu lai thu te le hongpai lai tu te, ");
INSERT INTO csy_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","A sang, a thuk le a dang piansak nate in i Topa Jesus Christ sungah a om Pathian itna pan in hong khen thei ngawl tu hi, ci in ka muang hi. ");
INSERT INTO csy_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Christ sungah thuman ka son hi, leilot ngawl khi hi, keima i sia le pha heakna in Tha Thiangtho sungah tettipang hi. ");
INSERT INTO csy_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ka thinsung ah vanngit lianpi le a tawntung in khuangaina ka nei hi. ");
INSERT INTO csy_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Cilesa deina taw ka suapui te atu in keima tatak sia Christ tung pan in hamsiat ka thuak nuam zaw liang hi: ");
INSERT INTO csy_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Amate sia Israel mite hi uh a; amate sia ta suasak na, minthanna, kamciam te, dan piakna, Pathian nasep le kamciam te taw a kizom te a hihi; ");
INSERT INTO csy_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Amate sia pu le pa te taw kizom in, Christ zong cilesa ngeina taw amate sung pan hong theng a hihi, tua Christ sia na theampo tungah om a, Pathian in a tawntung in thupha pia hi. Amen. ");
INSERT INTO csy_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Pathian thu sia mannung ngawl hi, cinopna hi ngawl hi. Banghangziam cile Israel mi theampo in Israel mi tatak hi siat ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Abraham i suan le pal theampo sia a tate hi siat ngawl hi: ahihang, Isaac bek ah na suanlepal kip tu hi. ");
INSERT INTO csy_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Hi thu sia, cilesa ngeina taw Abraham tate theampo sia Pathian tate hi ngawl hi, ahihang kamciam i tate sia a suan le pal in ceptesak hi. ");
INSERT INTO csy_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Banghangziam cile hisia sia kamciam kammal a hihi, hibang hun in kong paikik tu a, Sarah in tapa nei tu hi. ");
INSERT INTO csy_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Hi thu bek hi ngawl hi; ahihang Rebecca zong eite i pa Isaac taw in naupai hi; ");
INSERT INTO csy_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","A tate suak ngawl lai in, a pha le a phangawl bangma vawt ngawl lai hi napi, Pathian i ngealna sia a tealsa bangma in a kip thei natu, sepna tungtawn hi ngawl in, amate a sam pa hang a hi zawkna sia; ");
INSERT INTO csy_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Rebecca tung ah, a upa in a naupa i na seam tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Jacob ka it hi, ahihang Esau ka ensan hi, ci at khol hi. ");
INSERT INTO csy_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Tabang hile bang i son thua tu ziam? Pathian sungah thutan ngawl na om ziam? Om vet ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Banghangziam cile Moses tung ah, ka hesuak nop te tungah hesuakna ka nei tu hi, taciang ka mulkim nop te tungah mulkimna ka nei tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Tua ahikom hi thu sia dei thu le taikhiatna thu hang hi ngawl a, hesuakna a kilangsak Pathian hang a hihi. ");
INSERT INTO csy_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Banghangziam cile laithiangtho in Pharaoh tung ah, nangma tungah ka vangletna ka kilatsak thei natu le ka min sia leitung mun theampo ah ki thangsak tu, ci tupna taw in kong zang hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Tua ahikom Pathian in a hesuak nop te tungah hesuakna nei a, a deisak mite lungtang khauhsak hi. ");
INSERT INTO csy_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Tabang hile nangma in ka tung ah, banghang in Pathian in maw hong zong lai ziam? hong ci tu ni hi. Banghangziam cile a kua in Pathian deina nial tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Ahihang, mihing pa awng, Pathian a zo kik tu in nangma sia akua ni ziam? Banghang in hibang in hong vawt ni ziam, ci in a vawtsa nate in a vawtpa tungah ci tu ziam? ");
INSERT INTO csy_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Tungman lomkhat pan in beal khat sia a zatak huai in vawt tu le, a dang khat sia zatak huai ngawl in vawt tu sia, beal vawt pa in tungman tungah thu nei hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Pathian in a thin-ukna kilangsak nuam a, a thuneina a hesak nuam le, suksiat tu in a vawtsa thin-ukna beal te sia thinsautak in thuak hi: ");
INSERT INTO csy_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Taciang minthanna tu in a puakhol sate sia hesuakna beal te tungah a minthanna i letna hesak tu hi, ");
INSERT INTO csy_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Eite na ngawn, a saptuam te i hihi, Judah mite bek hi ngawl in, Gentile mite zong sam hi ngawl ziam? ");
INSERT INTO csy_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Hosea laibu sungah zong, ka mite a hi ngawl te ka mite, ka ci tu hi; taciang ka it ngawl te zong, ka it te, ka ci tu hi. ");
INSERT INTO csy_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Tuazawkciang in amate tung ah, note ka mi na hi bua uh hi, ka ci na mun ah; a nungta Pathian tate, ci in amate ka sam tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Isaiah in zong Israel mite taw kisai in, Israel tate sia tuipi ah senneal za hinapi, a tanglai te bek ngupna nga tu hi: ");
INSERT INTO csy_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Banghangziam cile Ama in nasep khuangkhim tu hi, taciang thutang suana taw a tuntom sak tu hi: banghangziam cile Topa in leitung ah nasep tuntom sak tu hi. ");
INSERT INTO csy_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Taciang Isaiah in hi thu te i mai ah, ngalkaphon te i Topa in thaici khe ngawl hile, eite sia Sodom le Gomorah bang i hi siat tu hi, ci hi. ");
INSERT INTO csy_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Tabang hile bang i son tu ziam? Thutang suana a del ngawl Gentile mite in thutang suana phaban hi, tua thu sia upna hang in thutang suana a hihi. ");
INSERT INTO csy_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ahihang thutang suana a del Israel mite in, thutang suana i thukham sia phaban ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Banghangziam? Amate in upna taw a zong bua uh hi, thukham i sepna te taw a zon uh hang a hihi. Tabang in amate sia lutu theina suang tungah lutu uh hi; ");
INSERT INTO csy_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","En vun, Zion ah lutusak thei suang le lutuna suangtum ka koi hi: taciang akuamapo Ama a um peuma a maizum ngawl tu hi, ci in at khol hi. ");
INSERT INTO csy_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Suapuite awng, Israel mite ngupna a nga tu uh sia ka thinsung i deina le Pathian tungah ka thungetna a hihi. ");
INSERT INTO csy_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Banghangziam cile amate in Pathian atu in thalawpna nei hi, ahihang heakna ki hel ngawl thalawpna a hihi, ci sia kong pualak hi. ");
INSERT INTO csy_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Banghangziam cile amate in Pathian i thutang suana sia a he bua uh hi, taciang mate thutang suana kipsak sawm uh a, Pathian i thutang suana sungah amate le amate ki ap nuam ngawl hi. ");
INSERT INTO csy_vpl VALUES ("RM10_4","075_10_4","ROM","10","4"