﻿USE sofia;
DROP TABLE IF EXISTS sofia.csoNT_vpl;
CREATE TABLE csoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES csoNT_vpl WRITE;
INSERT INTO csoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Hi³ lá² bíh¹ cáun² sí² hi³ cha³² jáɨ¹³ hi³ ca³tɨn¹ Jesús Tsá² lɨ́n³ Cristo, jan² Tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹ quionh³ hla¹ re²¹ Dá²vi²¹. Jáun² né³, ñí¹ lá² má²ja³toh³ hi³ jmáɨ² tsá²haun³² dí¹hio³ ñú¹deh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Há²bran²¹ hí³ jmɨ́¹ lɨ́n³ jméi² Isaac, tsá² lɨn³ jméi² Jacob, tsá² lɨn³ jméi² Judá la³ má²quionh³ jɨ³ tsá¹ raɨnh²¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá hí³ quionh³ Tamar ñí²cuo² jmɨ́¹ lɨ́n³ jméi² mí¹ziú¹³ Fares quionh³ Zara. Jáun² Fares hí³ lɨn³ jméi² Esrom tsá² lɨn³ jméi² Aram. ");
INSERT INTO csoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram hí³ lɨn³ jméi² Aminadab tsá² lɨn³ jméi² Naasón, tsá² lɨn³ siáh³ jméi² Salmón. ");
INSERT INTO csoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón hí³ quionh³ Rahab ñí²cuo² jmɨ́¹ lɨ́n³ jméi² mí¹ziú¹³ Booz, hi³ jáun² Booz hí³ né³ quionh³ Rut ñí²cuo² jmɨ́¹ lɨ́n³ jméi² mí¹ziú¹³ Obed. Obed hí³ né³ lɨn³ jméi² Isaí. ");
INSERT INTO csoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí hí³ lɨn³ jméi² hla¹ re²¹ Dá²vi²¹, jáun² re²¹ Dá²vi²¹ la³ má²quionh³ tsá²mɨ³ tsá² jmɨ́¹ ñí²cuo² Urías lɨn³ jméi² mí¹ziú¹³ Salomón. ");
INSERT INTO csoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón hí³ lɨn³ jméi² Roboam tsá² lɨn³ hí³ jméi² Abías, hi³ hí³ né³ lɨn³ jméi² Asa. ");
INSERT INTO csoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Jáun² Asa hí³ né³ lɨn³ jméi² Josafat tsá² lɨn³ jméi² Joram, tsá² lɨn³ hí³ jméi² Uzías. ");
INSERT INTO csoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Jáun² Uzías lɨn³ jméi² Jotam tsá² lɨn³ jméi² Acaz, Acaz hí³ né³ lɨn³ jméi² Ezequías. ");
INSERT INTO csoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Jáun² Ezequías lɨn³ jméi² Manasés tsá² lɨn³ hí³ jméi² Amón; Amón hí³ né³ lɨn³ jméi² Josías. ");
INSERT INTO csoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hi³ jáun² Josías lɨn³ jméi² Jeconías la³ má²quionh³ tsá¹ raɨnh²¹, jmáɨ¹ hi³ ca³ja³taunh²¹ jáun² tsá² *Israel hi³ tson³ tɨ³ hué³² Babilonia. ");
INSERT INTO csoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jmɨ́¹ má²lɨ³² jáun² né³, Jeconías hí³ siáh³ ca³lɨ³zian² Salatiel jon², tsá² lɨn³ hí³ jméi² Zorobabel. ");
INSERT INTO csoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jáun² Zorobabel lɨn³ jméi² Abiud tsá² lɨn³ hí³ jméi² Eliaquim, tsá² lɨn³ jméi² Azor. ");
INSERT INTO csoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hi³ Azor hí³ né³ lɨn³ jméi² Sadoc tsá² lɨn³ jméi² Aquim, tsá² lɨn³ hí³ jméi² Eliud. ");
INSERT INTO csoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Jáun² Eliud lɨn³ jméi² Eleazar tsá² lɨn³ hí³ jméi² Matán, tsá² lɨn³ jméi² Jacob. ");
INSERT INTO csoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jáun² né³, Jacob lɨn³ jméi² Sé³² ñí²cuo² Má²réi³; Má²réi³ né³ lɨn³ mí¹ziú¹³ Jesús Tsá² ca³lɨn³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Hi³ jáun² la³ nɨ́² bíh¹ lɨ́³ hi³ quia³quiún³ nió³ jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹ tín³ ca³la³ tɨ³ jmáɨ¹ hi³ zian² hla¹ Dá²vi²¹, hi³ hla¹ Dá²vi²¹ ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³huén² tsá² Israel hi³ ja³taunh²¹ hi³ tson³ tɨ³ Babilonia tín³ siáh³ quia³quiún³ nió³ jón²zɨ́h¹ jón²cho¹ tsú², hi³ cónh³í¹ quia³quiún³ nió³ jón²zɨ́h¹ jón²cho¹ tsú² tín³ la³ tɨ³ jmɨ́¹ ca³lɨ³zian² jáun² Cristo. ");
INSERT INTO csoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","La³ lá² bíh¹ lɨ³ hi³ ca³lɨ³zian² Jesús Tsá² lɨ́n³ Cristo: Má²réi³ jmɨ́¹ má²ná¹lɨ́³ jáɨ¹³ hi³ jenh¹³ cuo² quionh³ Sé³²; tɨ³la³ ñeh² bíh¹ hi³ jenh¹³ cuo² tsú² má¹ná¹, ca³lɨ³ lin¹ Má²réi³ hi³ quian² jon², cáun² hi³ lɨ³ cun³quionh³ pí³ quioh²¹ Jmɨ́²chí³ Chun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jáun² Sé³² tsá² nióh³² tsú² hí³ jáɨ¹³ quionh³ né³, ca³lɨ³hnió³ tsunh³ jáɨ¹³ quionh³ Má²réi³. Ca³lɨ́n¹³ tsú² hi³ jmu³ la³ jáun² ta³ tiá² hin² ñi³², quí¹hliá² tsá² hí³ jan² tsá² chun¹ bíh¹ hi³ jáun² tiá² jmɨ́¹ hnió³ yáh³ tsú² chin¹³ hua³heih²¹ Má²réi³. ");
INSERT INTO csoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tɨ³la³ tá¹la³ lɨ́n²³ tsú² jáun² la³ nɨ́² né³, jan² tsá²cuú² tsá²ta³ Juo¹³ dí² ca³jnia³ jéinh³² tsú² juɨ³² qui³ ziú³, hi³ ca³juáh³ la³ lá²: ―Hnú² Sé³², tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, ha³ lɨ́² jmú² juénh² nú² hi³ hen¹³ nú² Má²réi³ hi³ lɨ́n¹³ ñí²cuoh² nú², quí¹ dáɨn² hi³ quian² tsú² ca³can³ tsú² cun³quionh³ pí³ quioh²¹ Jmɨ́²chí³ Chun¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hi³ jáun² nɨ́¹ má¹ca³lɨ³zian² dáɨn² hí³, hniáuh³² teh¹ nú² Jesús. La³ nɨ́² bíh¹ lɨ³ jmáɨ² tsú², quí¹hliá² lión³² tsú² tsá² joh¹ hi³ ca³tɨ²¹ tso³. ");
INSERT INTO csoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","La³ nɨ́² bíh¹ ca³lɨ³ hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ Juo¹³ dí² cun³quionh³ jan² *tɨ³² jë¹ Dió³², hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jan² tsá¹máɨ¹³, tsá² tiá² hin² má²ca³cáuh³², can³ jon², hi³ jáun² nɨ́¹ má¹ca³lɨ³zian² dáɨn² hí³, lɨ³ jmáɨ² Emanuel, (hi³ hnió³ juáh³ “Dió³² zenh² quiúnh¹ jnoh¹”). ");
INSERT INTO csoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jmɨ́¹ ñi²¹ jáun² hi³ rá²cuóun¹ Sé³², ca³jmú³ bíh¹ la³ cun³ hi³ má²lɨ́²juáh³ jáun² tsá²cuú² tsá²ta³ Juo¹³ dí², hi³ ca³hen³ Má²réi³ hi³ lɨ́¹³ ñí²cuo². ");
INSERT INTO csoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tɨ³la³ cun³ tiá² ca³tiánh³ bíh¹ tsú² cu³tsa³² ta³ ñeh² bí¹ hi³ lɨ³zian² jon²; jáun² Sé³² né³ ca³teh³ Jesús dáɨn² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jáun² né³, Jesús hí³ ca³lɨ³zian² já¹ juú² Belén, hué¹³ Judea, jmáɨ¹ hi³ jmɨ́¹ cuá¹lɨ́n³ Herodes re²¹ hué³² jáun². Jmɨ́¹ lɨ́¹cáɨn² jáun² né³, ca³cha³táunh¹ ma³ jan² tsá²ñuh² já¹ juú² Jerusalén, tsá² já²taunh²¹ tɨ³ juɨ³² ñí¹ hia³² hiú², tsá² quia³lín³ jmɨ́¹ tsɨ́³ hi³ chú² ñih²³ chí¹jmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hi³ jáun² tsá² hí³ né³ ca³ngáɨ³: ―¿Ha³ jinh¹ rón³² Tsá² má²ca³lɨ³zian², Tsá² lɨ́n³ Re²¹ Juo¹³ tsá² *judíos? Quí¹ tɨ³ ñí¹ hia³² hiú² má²ca³neh²¹ jnoh¹ chí¹jmaɨ²¹ hi³ ca³tɨn¹ tsú², hi³ jáun² jau³ jnoh¹ ñí¹ lá² hi³ ja³ma³tsú¹ ma³jonh²¹ jnoh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jmɨ́¹ ca³lɨ³ ñi³² re²¹ Herodes jáɨ¹³ nɨ́² né³, ca³la³ lɨ́¹ tiá² ñi³² he³ jmu³ bíh¹ lɨ³, jɨ³ la³jɨ́n³² tsá² zian² já¹ juú² Jerusalén nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jmɨ́¹jáun² ca³teh³ re²¹ hí³ la³jɨ́n³² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́², jáun² ca³ngáɨh³ dí² tsá² hí³ ha³ jinh¹ ca³tɨ²¹ hi³ lɨ³zian² Tsá² lɨ́n¹³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jáun² tsá² hí³ ca³juáh³: ―Já¹ juú² Belén hɨ́n¹³ tɨ³ hué¹³ Judea bíh¹ lɨ³zian²; quí¹ jan² hla¹ *tɨ³² jë¹ Dió³² ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Hnú² juú² Belén hɨ́n¹³ tɨ³ hué¹³ Judá, tiá² huen³ yáh³ hnú² ja¹ tsá² ná¹ho² ta²¹ hué³² nɨ́²; quí¹ ñí¹con² hnú² bíh¹ cua³haɨn³² jan² Tsá² chín¹, Tsá² jmu³ hua³hí¹³ tsá² *Israel tionh² jo³uón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jáun² ta³máɨh³ bíh¹ ca³teh³ Herodes tsá² quia³lín³ jmɨ́¹ tsɨ́³ hí³, hi³ jáun² ca³ngáɨh³ dí² hi³ hín² jmáɨh¹ ti³tsóh³ ca³jnia³ chí¹jmaɨ²¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jáun² ca³zen³ dí² tsú² tɨ³ já¹ juú² Belén hi³ ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh² ñí¹ zio¹, hi³ cuá²hniah³² náh² re² lɨ́n³² dáɨn² hí³; hi³ jáun² nɨ́¹ má¹ca³chanh²¹ náh², ñá²juah²¹ náh² ñí¹con² jná¹³, hi³ jáun² ja³bí¹ jná¹³ siáh³ uá²jaɨ³² ñe¹ hi³ ñí¹ma³tsú¹ ma³jonh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jmɨ́¹ má²lɨ́²zéih³² jáun² re²¹ tsá² hí³ jáɨ¹³ nɨ́² né³, ja³taunh²¹ bíh¹ tsá² hí³ juɨ³² hi³ tiáunh¹; hi³ jáun² chí¹jmaɨ²¹ hi³ ca³jɨ́e³ tsú² jáun² tɨ³ ñí¹ hia³² hiú² cuá¹tsau³² chí¹ján³ ta³ ñí¹ tsú² ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³háɨ³² tie³ tá²chi²¹ ñí¹ rón²¹ dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hi³ jáun² jmɨ́¹ ca³jɨ́e³ tsá² quia³lín³ hí³ jmɨ́¹ tsɨ́³ hi³ má²he² tie³, jáun² jlánh¹ ca³lɨ³ hiún² lɨ́n³² tsɨ́³; ");
INSERT INTO csoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","hi³ jáun² jmɨ́¹ taunh²¹ tsú² jáun² ñéih³ né³, ca³jɨ́en³² dáɨn² quionh³ Má²réi³ mí¹ziú¹³. Jmɨ́¹jáun² ca³di³jñí³² dí² tiáunh¹ hi³ ca³ma³tsu³ ma³jónh³² dáɨn² hí³. Jmɨ́¹ lɨ²¹ jáun² ca³nia³ tsú² cuó² quioh²¹, hi³ ca³huéh³ cú¹mí¹niau²¹, ziún², jɨ³ no¹ hi³ lɨ́³ quionh³ há² má²ró³² jmáɨ² mirra nɨ́² siáh³, hi³ lɨ́¹ ca³cuéh³ dí² dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáun² juɨ³² qui³ ziú³ hi³ tiú²uú² hniáuh³² tsa³tánh¹ tɨ³ juɨ³² ñí¹ cuá³ Herodes, hi³ jáun² juɨ³² siáh³ bíh¹ ja³tanh²¹ tsú² cú²jueh³² tɨ³ juú²co¹. ");
INSERT INTO csoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jmɨ́¹ má²já²tanh²¹ jáun² tsá² quia³lín³ hí³ jmɨ́¹ tsɨ́³ né³, jáun² jan² tsá²cuú² tsá²ta³ Dió³² Juo¹³ dí² ca³jnia³ jéinh³² Sé³² juɨ³² qui³ ziú³ hi³ ca³juáh³ la³ lá²: ―Náu², jan³² dáɨn² nɨ́² quionh³ mí¹ziú¹³, cuóun³ tɨ³ hué³² Egipto, ca³la³ ñí¹ cá¹juáh²¹ jná¹³ hi³ cuá¹han² nú² siáh³ hué³² jáun²; quí¹ né³bí¹ ja³hniah² Herodes dáɨn² hi³ jngɨh³. ");
INSERT INTO csoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jmɨ́¹jáun² ca³náu² Sé³² hi³ ca³jan³ dáɨn² quionh³ mí¹ziú¹³ hi³ ja³taunh²¹ ta³ já¹niéi² tɨ³ hué³² Egipto; ");
INSERT INTO csoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","jáun² ñí¹ jáun² bíh¹ ca³tiánh³ tsú² ca³la³ tɨ³ ñí¹ jun¹ Herodes. La³ nɨ́² ca³lɨ³ hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ má²ca³juáh³ Juo¹³ dí² jmɨ́¹tin² cun³quionh³ jan² hla¹ tɨ³² jë¹ Dió³²: “Tɨ³ hué³² Egipto bíh¹ ca³teh³ jná¹³ Jón³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jmɨ́¹ ca³lɨ³tsɨn² jáun² Herodes hi³ tsá² quia³lín³ hí³ jmɨ́¹ tsɨ́³ lɨ́¹ má²lɨ́²cáuh³² cú²nga¹ bíh¹, jáun² ca³míh³ lɨ́n³² tsɨ́³ tsú²; hi³ jáun² ca³jmú³ dí² héih³² hi³ ma³tsan² tsú² la³jɨ́n³² tsá¹míh¹ tsá² jmɨ́¹ má²tiáunh¹ tun³ mieh² tɨ³ la³ hué³² jmɨ́¹ zian² já¹ juú² Belén jɨ³ juú² la³ cu³ la³ jéin³ jáun² nɨ́², la³ cun³ tí³ jmáɨ¹ hi³ ca³hɨ́e³ jáun² tsá² quia³lín³ hí³ jmɨ́¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","La³ jáun² bíh¹ ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ jáun² hla¹ Jeremías tɨ³² jë¹ Dió³²: ");
INSERT INTO csoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ñí¹ja²¹ cáun² mah¹ tɨ³ juú² Ramá, hi³ ñí¹ho¹ lɨ́n²¹ tsú² hi³ hú¹ quí² hú¹ jngɨh³² tsɨ́³; Raquel bíh¹ hí³ tsá² cuá¹ho² hi³ ca³tɨn¹ jón²zɨ́h¹. Cun³ tiá² ca³lɨ³hnió³ bíh¹ tsú² hi³ niau²¹ re² tsɨ́³, quí¹ cun³ñí¹ hi³ jlánh¹ má²ca³hiá² cá²tsan³ jón²zɨ́h¹. ");
INSERT INTO csoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hi³ jáun² né³, jmɨ́¹ má²jún¹ jáun² Herodes ca³jnia³ jan² tsá²cuú² tsá²ta³ Dió³² Juo¹³ dí² jéinh³² Sé³² juɨ³² qui³ ziú³ tá¹la³ cuá³ jáun² hué³² Egipto, hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Náu², jon¹ dáɨn² quionh³ mí¹ziú¹³ hi³ cuánh² tɨ³ hué³² Israel, quí¹ má²cá²tsan³ bíh¹ tsá² jmɨ́¹ hnió³ jngɨh³ dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jáun² Sé³² ca³náu² hi³ ca³jón³² dáɨn² la³ má²quionh³ mí¹ziú¹³ hi³ jaunh³ tɨ³ hué³² Israel. ");
INSERT INTO csoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tɨ³la³ jmɨ́¹ ca³lɨ³ ñi³² Sé³² hi³ Arquelao má²cuá¹ho² siáh³ ta²¹ tɨ³ Judea cha¹³ hla¹ Herodes jméi², jáun² ca³lɨ³ cóh³² tsú² hi³ tsánh³² tɨ³ jáun²; tɨ³la³ jmɨ́¹ má²lɨ́²héi³ tsú² jáun² héih³² juɨ³² qui³ ziú³ né³, jaunh³ bíh¹ tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jmɨ́¹ cá¹chánh²¹ tsú² hué³² jáun² né³, ngau³ hi³ ca³ñí¹cuá² já¹ juú² Nazaret. La³ nɨ́² ca³lɨ³ hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ jáun² tsá² jmɨ́¹ ná¹lɨ́n³ hí³ tɨ³² jë¹ Dió³² jmɨ́¹tin² hi³ Jesús téh³ tsú² hná¹ tsá² Nazaret. ");
INSERT INTO csoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jmɨ́¹jáun² cuan³ Juan² tsá² ziau² jmáɨ² tɨ³ hué³² quiéin² lɨ́³ tɨ³ hué¹³ Judea, hi³ hleh³² jáɨ¹³ quioh²¹ Dió³², ");
INSERT INTO csoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","hi³ juáh³ la³ lá²: ―¡Za¹ náh² jmɨ́¹ honh², quí¹ má²ja³quián³ ma³jnia² bíh¹ Dió³² Tsá² má²cuá¹hiáun¹ hi³ lɨ́n¹³ Re²¹! ");
INSERT INTO csoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Hi³ ca³tɨn¹ Juan² nɨ́² bíh¹ jáɨ¹³ hi³ ca³hléh³ jáun² hla¹ Isaías *tɨ³² jë¹ Dió³², jmɨ́¹ ca³juáh³ jáun² la³ lá²: Tɨ³ hué³² quiéin² niéih³ cáun² ho³ tsáu², hi³ ñí¹juah²¹: Jmu³ náh² hua³jan²¹ juɨ³² ñí¹ já²¹ Juo¹³ dí²; jmu³ náh² cáun² juɨ³² cú²tso². ");
INSERT INTO csoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jáun² ha¹ Juan² hí³ né³ jmɨ́¹ lɨ́³ jñú¹³ jáh³ cánh¹ téh²³ tsú² camello, lá² hñéih¹ tsú² jmɨ́¹ lɨ́³ láu², hi³ má³² quioh²¹ tsú² né³ jmɨ́¹ lɨ́n³ náɨh² la³ má²quionh³ jmɨ́²toh¹ hi³ zia³² ja¹ náɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hi³ jáun² tsá² zian² Jerusalén jmɨ́¹ ja³táunh¹ hi³ náɨ³² jë¹ tsú², la³ má²quionh³ la³jɨ́n³² tsá² hɨ́n¹³ tɨ³ Judea jɨ³ tsá² zian² hué³² can³² cua³ Jordán nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","hi³ jáun² nɨ́¹juáh³ nɨ́¹ má¹lɨ́²ton³ tsú² tso³ quioh²¹, má¹lɨ³² jáun² tɨ́² ziau² Juan² jmáɨ² cua³ Jordán jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jáun² ca³chó³² cáun² jmáɨ¹ hi³ cua³taunh²¹ tsá² téh²³ tsú² tsá² *fariseos jɨ³ tsá² *saduceos, tsá² tun³ nió³ hɨ́n¹³ cuáh³² quioh²¹ tsá² *judíos. Jáun² né³, jmɨ́¹ ca³jɨ́e³ Juan² hi³ juóun³² lɨ́n³² bíh¹ tsá² hí³ ja³to¹ ja³lɨn²³ hi³ hnió³ zón³² jmáɨ², jáun² ca³záɨh³ dí² la³ lá²: ―¡Hnoh² dá² jón²zɨ́h¹ jón²cho¹ jáh³ hláɨnh¹ bíh¹! ¿Hin² dá² tsánh² ca³záɨ³ hnoh² hi³ hniáuh³² cuóunh¹³ náh² ca³tɨ²¹ uu³mí²tsɨ³² hi³ má²ja³² má²janh²? ");
INSERT INTO csoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jmu³ náh² lin¹ hi³ tson² má²ca³za² jmɨ́¹ honh² náh², ");
INSERT INTO csoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ha³ lɨ́²uú² lɨ́¹ cuɨ́¹ lɨ́n¹³ náh² hi³ lɨ́¹³ liáun³ náh² cun³ñí¹ hi³hliá² hnoh² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹; quí¹ jná¹³ juanh³² hi³ hí¹ ca³la³ tɨ³ quɨ́n¹ lá² yáh³ lɨ́¹³ jmu³ Dió³² hi³ láɨn¹ jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Quí¹ má²rá¹lɨ́³ bíh¹ hua³jan²¹ mí¹chí¹ hi³ quiúh³² tsú² la³jɨ́³² hmá² tiá² máɨ³ chu²¹ háɨ³², hi³ jáun² tsa³toh³ ja¹ sɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Quí¹ tson² bíh¹ jná¹³ ziau² jmáɨ² hnoh² cun³quionh³ jmɨ́² jma³, cáun² li²¹ hi³ lin¹ hi³ tson² má²lɨ́²záɨ³² tsú² jmɨ́¹ tsɨ́³; tɨ³la³ né³bí¹ já²¹ yáh³ jan² Tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cun³ bí¹ jná¹³, quí¹ cun³ tiá² cu³ tiá² ren³ bíh¹ jná¹³ quiúnh¹ ná¹ Tsá² hí³, ca³la³ hí¹juáh³ tiá² ca³tɨn¹ yáh³ jná¹³ hi³ má¹con²¹ ná¹ tsú² hi³ cue¹ ná¹ chí² láu² tsɨ³² ta³. Jáun² Tsá² hí³ bíh¹ ziau³ hnoh² jmáɨ² cun³quionh³ Jmɨ́²chí³ Chun¹ jɨ³ cun³quionh³ sɨ́² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Má²zianh³² bíh¹ Tsá² hí³ cuah²¹ quioh²¹ hi³ chí³² cuú²miih²¹, hi³ jáun² tsa³cuɨ́³² má¹quɨ³². Chá³² tsú² cu³lɨ²¹ cuú²miih²¹ má²jɨ² jáun² ñéih³ hñu³cuɨ́³ quioh²¹; hi³ jáun² má¹quɨ³² jáun² né³, tsa³toh³ ja¹ sɨ́² bíh¹, cáun² sɨ́² hi³ tiá² tón³² jmáɨ¹ yéi³². ");
INSERT INTO csoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jmɨ́¹jáun² cua³han³ Jesús tɨ³ Galilea, hi³ ca³chó³² can³² cua³ Jordán ñí¹ jmɨ́¹ dí¹zion² Juan² tsáu² jmáɨ², hi³ hnió³ ziau³ Juan² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tɨ³la³ tiá² jmɨ́¹ hei³² yáh³ Juan², hi³ jáun² ca³záɨh³ dí² Jesús: ―Jná¹³ bíh¹ tɨ³ hniáuh³² zón³² jmáɨ² hi³ ziau¹³ hnú²; ¿he³ lɨ³ sa³ hnú² bíh¹ tɨ³ ñeih³² ñí¹con² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tɨ³la³ Jesús né³ ca³juáh³: ―Cuɨ́¹ lɨ́¹³ tín² la³ nɨ́² ta³né³²; quí¹ ca³ta¹ bíh¹ dí² jmú¹³ la³jɨ́³² la³ cun³ hi³ hnió³ Dió³². Jmɨ́¹jáun² né³, ca³ma³tí³² Juan² hi³ ca³zion³ jmáɨ² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jmɨ́¹ cáun³ jáun² Jesús jmáɨ² né³, cua³han³ chu³ jmáɨ². Jmɨ́¹jáun² né³ ca³niá³ hñu³mɨ³cuú², hi³ jáun² ca³jɨ́en³² tsú² Jmɨ́²chí³ Chun¹ joh¹ Dió³² hi³ má²cuá¹son² ñí¹ quioh²¹ dí², hi³ jniá³ la³jmɨ́¹ jniá³ jan² jáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jmɨ́¹jáun² ja³ cáun² mah¹ tɨ³ hñu³mɨ³cuú² hi³ ñí¹juah²¹ la³ lá²: ―Tsá² nɨ́² bíh¹ Jón³² jná¹³, Tsá² hno³ lɨ́n³² ná¹, Tsá² jlánh¹ lɨ́²hiún² tsɨn³² jná¹³ hi³ ca³tɨn¹. ");
INSERT INTO csoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jmɨ́¹ lɨ²¹ jáun² ca³jan³ Jmɨ́²chí³ Chun¹ Jesús tɨ³ hué³² quiéin², hi³ jáun² ñí¹ jáun² lɨ́¹³ ca³ lau³ tsá² hláɨnh¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ñí¹ jáun² ca³ma³hɨen²¹ tsú² tun³ló³² jmáɨ¹ jɨ³ tun³ló³² nie³, jmɨ́¹ lɨ²¹ jáun² né³ lɨ³ ñí¹cuóunh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jáun² tsá² cá² lau²³ hí³ ca³ma³janh³² ñí¹con² Jesús hi³ ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ tson² bíh¹ hnú² Jon² Dió³², jmu³ neh²¹ hi³ quɨ́n¹ lá² jeinh²¹ *hí³ cuú²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tɨ³la³ Jesús ca³ngáɨ³: ―Ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Jun³juáh¹³ jmáh³la³ cun³quionh³ hí³ yáh³ lɨ́¹³ zian² tsá²mɨ³cuóun², quí¹ ja³bí¹ cun³quionh³ ca³la³ jɨ́³² jáɨ¹³ hi³ hleh³² Dió³² bíh¹ siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Hi³ jáun² tsá² hláɨnh¹ hí³ ca³jau³ tɨ³ Jerusalén juú² hɨ́en¹, jáun² ca³di³chin³ dí² Jesús tsáɨh³ cuáh³² chín¹, ");
INSERT INTO csoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","hi³ ca³záɨh³ dí² la³ lá²: ―Nɨ́¹juáh³ tson² cu³tí³ hi³ hnú² Jon² Dió³², tanh² la³ tɨ³ hué³² ó³² neh²¹; quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: Dió³² zen³ tsá²cuú² tsá²ta³ hi³ jmu³ hua³hí¹³ hnú²; hi³ ziau³ tsú² hnú² cun³quionh³ cuo² hmóu³², quí¹ nɨ́² lɨ́¹ ca³cuɨ́h³ tanh¹ hnú² cun³quionh³ quɨ́n¹. ");
INSERT INTO csoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tɨ³la³ Jesús né³ ca³ngáɨ³: ―Ja³bí¹ ñí¹ Sí² jáun² siáh³ rá¹juáh³: “Ha³ lɨ́² cá² lɨ́² lan³ hnú² Dió³² Juóuh³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Siáh³ siáh³ cu³ jéin³² ca³ñí¹jau² tsá² hláɨnh¹ cáun² tsɨ³ máh³ ñe¹ lɨ́n²¹, hi³ jáun² ñí¹ jáun² ca³hɨ́eh³ dí² Jesús la³jɨ́³² juú² ñí¹ ná¹hu²¹ cuo² tsá² ná¹ho² ta²¹ tá¹ cáun² hngá¹máh³ jɨ³ la³jɨ́³² hi³ zia³² quioh²¹ tsá² hí³ nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","hi³ jáun² ca³záɨh³ dí² siáh³ la³ lá²: ―Jná¹³ chá¹³ la³jɨ́³² hi³ jniá³ nɨ́² jo³cuonh² hnú² nɨ́¹juáh³ hi³ dí¹jñih²¹ hnú² ta³ ñi³² jná¹³, jɨ³ hi³ má¹tsú¹ má¹jauh²¹ nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² hláɨnh¹ la³ lá²: ―Cuánh² quián¹³ *Satanás, quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Ma³tsú¹ ma³jonh²¹ Dió³² Juóuh³², hi³ ñí¹ jɨ́²¹la³ jan² tán¹ hí³ bíh¹ má¹cú¹ má¹haɨn²¹ nú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jmɨ́¹jáun² ca³náu² tsá² hláɨnh¹ tɨ³ có³² ñí¹con² Jesús, hi³ jáun² cua³taunh²¹ tsá²cuú² tsá²ta³ Dió³² hi³ cua³ma³cón³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jmɨ́¹ ca³náɨ³² Jesús hi³ Juan² tsá² ziau² jmáɨ² má²cuá¹hún¹ hñu³mí¹ñí², jáun² ngah³ dí² tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tɨ³la³ tiú²uú² ca³cuá³ yáh³ tsú² já¹ juú² Nazaret má¹ná¹, quí¹ já¹ juú² Capernaum bíh¹ ngau³ tsú² cú²jueh³² hi³ ca³ñí¹cuá², cáun² juú² nio² can³² jmáɨ² lɨ́¹ ná¹ho³, ñí¹ má²can³² hué¹³ juú² Zabulón quionh³ juú² Neftalí. ");
INSERT INTO csoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ Isaías *tɨ³² jë¹ Dió³² jmɨ́¹ ca³juáh³ jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tsá² hué³² Zabulón quionh³ tsá² hué³² Neftalí, tsá² zian² hué³² nio² hú¹ juɨ³² tɨ³ can³² jmɨ́²miih²¹, tsá² zian² jo²¹ cua³ Jordán, juɨ³² ñí¹ hia³² hiú², la³ má²quionh³ tsá² zian² hué¹³ Galilea ñí¹ má²tionh² *tsá²cá²jo²¹, ");
INSERT INTO csoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","la³jɨ́n³² tsá² nɨ́², tsá² qui³ tionh² nɨ́² ñí¹ já¹niéi² ca³jɨ́e³ cáun² joh¹ zɨ́n³ lɨ́n³²; hi³ jáun² tsá² nɨ́², tsá² tionh² ñí¹ quian² heinh²¹ quioh²¹ hmú³², má²ca³táɨn³ cáun² joh¹ hi³ lɨ́³ la³jmɨ́¹ lɨ́³ joh¹ quioh²¹ cáun² jmáɨ¹ hmaɨ²¹ hi³ ca³jniá³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Hi³ jáun² né³, la³ cun³ jmáɨ¹ jáun² bíh¹ ca³ma³liáu³² Jesús hi³ hleh³² jáɨ¹³ quioh²¹ Dió³² hi³ juáh³: ―Za¹ náh² jmɨ́¹ honh², quí¹ má²ca³ma³jnia² bíh¹ Dió³² Tsá² má²cuá¹hiáun¹ hi³ lɨ́n¹³ Re²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jáun² jmɨ́¹jáun² jmɨ́¹ cuá¹ngɨ³² Jesús can³² jmáɨ² lɨ́¹ ná¹ho³ hué¹³ Galilea; ñí¹ jáun² né³ ca³jɨ́en³² gon³ tsá² má²tún² raɨnh²¹, jan² tsá² jmɨ́¹ jmáɨ² Sí¹mu²¹ tsá² ca³lɨ³ jmáɨ² siáh³ Pé¹, hi³ tsá² jan² né³ jmáɨ² Tre²¹. Tsá² hí³ jmɨ́¹ lɨ́n³ tsá² zanh²³ juo¹³, hi³ jáun² jmɨ́¹ ná¹tón³² hmá³ quioh²¹ chu³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Ñá²táunh¹ náh² cu³hna³² jná¹³, hi³ jáun² la³jmɨ́¹ jáun²³ náh² nɨ́² juo¹³ janh²¹ náh² siáh³ tsá²mɨ³cuóun² hi³ tónh³² jo³uón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³chá³ tsá² hí³ tɨ³ có³² hmá³ jáun² quioh²¹ hi³ ja³taunh²¹ cu³hna²¹ hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tɨ³ chí¹ján³ jáun² ca³lá² ca³jɨ́en³² siáh³ Jesús cónh³í¹ gon³ tsá² má²tún² raɨnh²¹: Jacobo jon² Zebedeo quionh³ Juan² dá¹jon²¹. Tsá² hí³ jmɨ́¹ tiáunh¹ hñu³ mu² quionh³ jméi², hi³ ná¹rauh³² hmá³ quioh²¹. Hi³ jáun² Jesús ca³teh³ siáh³ tsá² hí³, ");
INSERT INTO csoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³quiú² tsú² mu² quioh²¹ hi³ ca³chan³ tsú² siáh³ jméi², hi³ jáun² ja³taunh²¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hi³ jáun² jmɨ́¹jáun² jmɨ́¹ cuá¹tɨ́² cuá¹ngɨ³² Jesús tá¹ cáun² hué¹³ Galilea hi³ má²tɨn² tsáu² hñu³ cuáh³² quioh²¹ tsá² *judíos hi³ táun³ ma³ quin³² ma³ caun³² juú², hi³ hleh³² jú¹ chú³² ca³tɨ²¹ hi³ Dió³² má²cuá¹hinh²³ tsáu² jo³cuo², jɨ³ hi³ jmɨ́¹ jmah²³ siáh³ tsáu² ca³la³ jáh³ dú¹ ñí¹ mɨ́¹uɨ́³ hi³ ná¹zian² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ca³lɨ³ ñi³² bíh¹ tsáu² tá¹ cáun² hué³² Siria la³ cun³ ta²¹ hi³ jmu² Jesús, hi³ jáun² ca³cua³jan² tsú² la³jɨ́n³² tsá² jmɨ́¹ ná¹má²tso² tsɨ́³ la³jáh³ dúh¹ ñí¹ hi³ hlah³, mɨ́¹uɨ́³, hi³ cúh² hi³ uóu³²; tsá² tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³, tsá² ná¹jau² mɨ́¹uɨ́³ tsá¹ lɨ́¹ jún²³ jɨ³ tsá² hma² nɨ́² siáh³. Hi³ jáun² la³jɨ́n³² bíh¹ tsá² hí³ ca³jmah³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hi³ jáun² juóun³² lɨ́n³² bíh¹ tsáu² ja³taunh²¹ cu³hna²¹ tsú², tsá² zian² Galilea, tsá² zian² la³cáun² ñí¹ tioh³ jáun² tá¹ quia³ juú² míh¹ tiá² cu³tsa³², tsá² Jerusalén, jɨ³ tsá² hɨ́n¹³ tɨ³ Judea nɨ́², jɨ³ tsá² zian² tɨ³ jo²¹ cua³ Jordán tɨ³ juɨ³² ñí¹ hia³² hiú² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jmɨ́¹ ca³jɨ́en³² jáun² Jesús la³jɨ́n³² tsá² hí³ né³, ca³uú³ tsɨ³ máh³ hi³ jáun² ca³cuá³ ñí¹ jáun². Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³tiánh³ la³ cu³ la³ jéin³ ñí¹ cuá³; ");
INSERT INTO csoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","hi³ jáun² Jesús ca³ma³liáu³² hi³ má²tɨn² tsá² hí³ jáɨ¹³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Jlánh¹ jmɨ́¹ ren² tsá² má²ca³lɨ³tsɨn² hi³ tia³mii² jmɨ́²chí³ quioh²¹ ñí¹con² Dió³², quí¹ tsá² la³ hí³ bíh¹ tónh³² jo³cuo² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","”Jlánh¹ jmɨ́¹ ren² tsá² nio² hlah³ tsɨ́³, quí¹ Dió³² bíh¹ Tsá² chá³² re² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","”Jlánh¹ jmɨ́¹ ren² tsá² tsɨ́¹juɨ́³, quí¹ hí³ bíh¹ tsa³tiánh² cáun² mɨ³cuú² ñí¹ má²ca³jmú³ Dió³² jáɨ¹³ hi³ cué³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","”Jlánh¹ jmɨ́¹ ren² tsá² dí¹quian¹ hi³ ma³zian² la³ cun³ hi³ tɨ³² tsɨ́³ Dió³², la³juah²¹ dúh¹ hi³ ñí¹cuóunh²¹ jɨ³ hi³ hí¹quiéin² tsɨ́³, quí¹ Dió³² bíh¹ jmu³ hi³ conh²¹ hñu³ jmɨ́¹ hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","”Jlánh¹ jmɨ́¹ ren² nɨ́¹juáh³ tsá² ja³² mií³ tsɨ́³ ñí¹con² tsá² siánh³, quí¹ ja³bí¹ Dió³² já³² siáh³ mií³ tsɨ́³ ñí¹con² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","”Jlánh¹ jmɨ́¹ ren² nɨ́¹juáh³ tsá² jɨ² hñu³ tsɨ́³, quí¹ tsá² la³ hí³ bíh¹ lɨ́¹³ jɨ́en³² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","”Jlánh¹ jmɨ́¹ ren² tsá² jmu² hi³ niau²¹ tie³ ja¹ quioh²¹ tsáu², quí¹ tsá² la³ hí³ bíh¹ lɨ́¹³ juáh³ Dió³² hi³ jon². ");
INSERT INTO csoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","”Jlánh¹ jmɨ́¹ ren² tsá² má²tso² tsɨ́³ la³ cun³ hi³ jmoh²³ tsáu² cun³ñí¹ hi³ hnió³ jmu³ la³ cun³ hi³ hnió³ Dió³², quí¹ tsá² la³ hí³ bíh¹ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Jlánh¹ jmɨ́¹ ren² hnoh² nɨ́¹juáh³ jmɨ́¹ quiú² jmɨ́¹ je²³ tsáu², hi³ ca³la³ hi³ hɨ́¹ tsa¹ tsú² hnoh², jɨ³ nɨ́¹juáh³ jmɨ́¹ hleh³² tsú² la³jáh³ dúh¹ ñí¹ jú¹ tɨ́¹jáɨ² quián¹³ hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ma³hiún¹³ náh² honh², tsɨnh¹ náh² jmu³, quí¹ hñu³mɨ³cuú² hián¹³ náh² cáun² hi³ jlánh¹ bíh¹ quien²; quí¹ la³ nɨ́² bíh¹ ca³jmúh³² tsú² uá²jaɨ³² tsá² lɨn³ hí³ *tɨ³² jë¹ Dió³², tsá² ca³lɨ³zian² jmɨ́¹tin² la³ cónh³ bíh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”Hnoh² bíh¹ lɨ́n³ ñí¹ ñí¹con² tsá² zian² ñí¹ hué²¹ lá². Tɨ³la³ nɨ́¹juáh³ la³ ca³lɨ³ máɨh³ bíh¹ ñí¹ né³, ¿lánh³ yáh³ rón³² lɨ́¹³ jmóuh³² tsú² hi³ jáun² lɨ³ ñeh¹ siáh³? Tiú²uú² lin¹ ñí¹ jmu³ ta²¹ hí¹ cáun² yáh³; cáun² má²cuɨ́³ bíh¹ tsú², hi³ jáun² ñí¹ jáun² ha³ zóh³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","”Hnoh² bíh¹ lɨ́n³ joh¹ sɨ́² ñí¹con² tsá² zian² ñí¹ hué²¹ lá². Jáun² né³, jmú¹³ jáɨ¹³: Cáun² juú² nio² ñí¹ lɨ́³ tsáɨh³ máh³, tiá² lɨ́¹³ yáh³ hính³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Sa³jun³ héinh²³ yáh³ tsú² cáun² sɨ́² hi³ jáun² zih³² tɨ³ ñeh² cáun² tsɨ́¹ cuó²; tɨ³la³ ñí¹ ñe¹ bíh¹ dí²chí³ tsú², hi³ jáun² taɨn²¹ joh¹ la³jɨ́n³² tsá² tionh² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ja³bí¹ la³ jáun² hnoh² uá²jaɨ³², jmu³ náh² hi³ taɨ²¹ joh¹ quián¹³ náh² ñí¹con² tsáu², hi³ jáun² nɨ́¹ má¹ca³jɨ́e³ tsáu² la³jɨ́³² hi³ chu²¹ hi³ jmuh³² hnoh² jáun², hi³ jáun² ma³quien² tsú² Ñeh² hnoh² Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”Ha³ lɨ́² cuɨ́¹ lɨ́n¹³ hnoh² hi³ jná¹³ cuan³ hi³ má¹tauh²¹ ná¹ héih³² quioh²¹ hla¹ Moisés, sa³jun³ hi³ ja³ma³tauh²¹ jná¹³ jáɨ¹³ hi³ ca³ma³ta² jáun² tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³² yáh³; quí¹ jun³juáh¹³ hi³ ja³ma³tauh²¹ yáh³ jná¹³ jáɨ¹³ jáun², quí¹ tɨ³ ja³ma³tson¹³ jná¹³ la³ cun³ hi³ hnió³ juáh³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Quí¹ jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ uá¹ cun³ má²já²hín³ la³jɨ́³² hi³ jniá³ chi³cuú² la³ má²quionh³ hngá¹máh³ lá², tiá² lɨ́¹³ yáh³ tsa³hín³ hí¹ cáun² huéh³ quioh²¹ liei²¹, sa³jun³ hí¹ cáun² máɨ³ pih²¹ quioh²¹ huéh³ jáun², ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ lɨ³tí³ la³ cun³ hi³ ca³tɨ²¹ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Cun³ñí¹ hi³ jáun² bíh¹, nɨ́¹juáh³ tsá² tiá² ta²¹ haɨh²¹ lɨ³ua³ cáun² héih³² hi³ rá¹lɨ́³ jáun², uá¹jinh¹ cáun² hi³ tiá² lin¹ nga³ quien², hi³ záɨh³² tsú² siáh³ tsáu² hi³ tiá² hniáuh³² tónh³² ta²¹, hi³ jáun² má²lɨ́n³ bíh¹ tsú² jan² tsá² tiá² lin¹ ñí¹ quien² ja¹ quioh²¹ la³jɨ́n³² tsá² tónh³² jo³cuo² Dió³². Tɨ³la³ nɨ́¹juáh³ tsá² má²tí³² héih³² jáun² né³, jɨ³ hi³ hɨeh³² siáh³ tsá² siánh³ hi³ jmu³ la³ jáun², tsá² la³ hí³ bíh¹ lɨ́n³ jan² tsá² quien² ja¹ quioh²¹ la³jɨ́n³² tsá² tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Quí¹ juah³² jná¹³ ñí¹con² hnoh², hi³ nɨ́¹juáh³ tiá² tɨ³ jlánh¹ bí¹ re² jmúh¹³ náh² hi³ tɨ³² tsɨ́³ Dió³² la³ cónh³ bíh¹ tɨ³² liei²¹ jɨ³ tsá² *fariseos, hi³ jáun² jmɨ́¹lɨ́h³ bíh¹ tiá² lɨ́¹³ tonh²¹ náh² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”Hnoh² má²ca³niéih² hi³ hiauh³ tsá² haun³² dí¹hio³ ñú²deh³ dí² héih³² hi³ lɨ́³ la³ lá²: “Ha³ lɨ́² jngɨh³ tsáu², quí¹ lɨ³ua³ jan² tsá² jngɨh² tsáu² ca³tɨn¹ tá¹tsɨn¹ héih³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tɨ³la³ jná¹³ juah³², hi³ lɨ³ua³ jan² tsá² jmu² hian² ñí¹con² raɨnh²¹, cun³ tá¹tsɨn¹ bíh¹ tsá² la³ hí³ héih³². Nɨ́¹juáh³ tsá² tú² hión³² raɨnh²¹, jáun² ñí¹con² tsá² ná¹ho² ta²¹ hi³ chín¹ bíh¹ tá¹tsɨn¹ tsú² héih³²; hi³ nɨ́¹juáh³ tsá² zaɨh³² raɨnh²¹ tsá² lín¹ ja³ juón¹, háɨnh¹³ tsó³² ja¹ sɨ́² quiu³juóu³² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”Hi³ jáun² né³, nɨ́¹juáh³ jmɨ́¹ zia³² hi³ cuá¹cánh¹ hnú² ñí¹hiú¹³ hi³ cuá¹cuéh³ nú² Dió³², hi³ tá¹la³ má²zenh² nú² ñí¹ jáun² né³ tsau³ honh² hnú² hi³ zian² jan² renh² hnú² hi³ hau² nú², ");
INSERT INTO csoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chá¹ tín² hi³ quiánh¹ jáun² có³² ñí¹hiú¹³ jáun², hi³ cuánh² tín² hi³ cuá¹jmuh³ nú² hi³ niau²¹ tie³ ja¹ quián¹³ nú² quiúnh¹ renh². Má¹jáun² má²ñeih²¹ hnú² siáh³ ñí¹hiú¹³ hi³ ñá¹ma³jnia¹³ nú² hi³ quiánh¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","”Nɨ́¹juáh³ zian² tsá² ca³hna³ hnú² ñí¹ta²¹, hi³ jáun² jau³ tsú² hnú² ta³ ñí¹ tsá²tan²¹, ma³ré¹³ náh² jáɨ¹³ tá¹la³ hí¹cua³táunh¹ náh² jáun² hú¹ juɨ³² quiúnh¹ tsú², hi³ jáun² tiá² tsa³jau² tsú² ta³ ñí¹ tsá² lɨ́n³ jue²¹; quí¹ nɨ́² lɨ́¹ ca³cue³ hnú² jue²¹ hí³ tsá² tú²jáɨ¹³ hi³ tsa³tiaunh² tsú² hnú² hñu³mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Juanh³² jná¹³ hi³ tiá² cáun² lɨ́¹ liáun³ yáh³ hnú², ca³la³ tɨ³ nɨ́¹ má¹ca³ma³hmah²¹ hnú² jɨ³lɨ³² máh³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”Hnoh² má²ca³niéih² hi³ ca³juáh³ tsú² la³ lá²: “Ha³ lɨ́² lɨ́¹ jmú² lɨ́¹ cuó³”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tɨ³la³ jná¹³ juanh³² hi³ lɨ³ua³ jan² tsá² jɨ́en³² tsá²mɨ³ hi³ hu²¹ hlah³ tsɨ́³, má²lɨ́²jmú³ bíh¹ tsú² tso³ hñu³ tsɨ́³ quionh³ tsá²mɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","”Nɨ́¹juáh³ mɨ́¹máh¹ tɨ³ cuá² chu²¹ nú² má²lɨ́²jmú³ hi³ ca³tánh³ nú² tso³, chí³ cú²jueh³² hi³ jáun² tiáun² ñí¹ uóunh³; quí¹ tɨ³ re² bíh¹ hi³ tsa³hín³ cá² máɨ³ mɨ́¹máh¹ nú² la³ cónh³ bíh¹ hi³ tsa³háɨn³ nú² tá¹ jan² quiu³juóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hi³ nɨ́¹juáh³ cuá² chu²¹ quián¹³ nú² jmu² siáh³ hi³ tanh³² hnú² tso³, hná¹ cú²jueh³², hi³ jáun² tiáun² ñí¹ uóunh³; quí¹ tɨ³ re² bíh¹ hi³ tsa³háɨ³ cáun² cuonh² hnú² la³ cónh³ bíh¹ hi³ cuóh¹³ hnú² tá¹ jan² quiu³juóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Ja³bí¹ jáɨ¹³ lá² siáh³ juáh²³ tsáu² la³ cun³ jmɨ́¹tin²: “Lɨ³ua³ jan² tsá² hnió³ tsáun³ quionh³ tsá²mɨ³ ñí²cuo², hniáuh³² bíh¹ cuéh³² tsú² ñí²cuo² cáun² sí² hi³ lin¹ hi³ ca³tsáun³ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Tɨ³la³ jná¹³ juanh³² ñí¹con² hnoh² hi³ lɨ³ua³ jan² tsá² hnió³ tun³ tsá²mɨ³ ñí²cuo² ta³ tiá² lin¹ zia³² jáɨ¹³ he³ tso³ lɨ́²jmú³ quionh³ tsá²ñuh² siánh³, cun³quionh³ la³ jáun² má²cueh³² tsú² tsú² jáɨ¹³ hi³ jmu³ juón¹ bíh¹; hi³ nɨ́¹juáh³ tsá² jéinh³² cuo² quionh³ tsá²mɨ³ tsá² má²ca³tsáun³ quionh³ ñí²cuo² né³, jáun² tsá² la³ hí³ má²lɨ́n³ jan² tsá² juón¹ bíh¹ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Ja³bí¹ má²ca³niéih² hnoh² hi³ tsá²haun³² hiauh³ héih³² lá² jmɨ́¹tin²: “Ha³ lɨ́² tsunh²¹ jáɨ¹³ hi³ má²lɨ́²jmuh³ ñí¹con² Dió³², la³ cun³ jáɨ¹³ hi³ má²lɨ́²ma³tson¹³ nú² jáun² ñí¹con² tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tɨ³la³ jná¹³ juanh³² hi³ hí¹ cáun² bíh¹ hi³ tiá² hniáuh³² hɨ́eh¹ náh². Ha³ lɨ́² lɨ́¹ ma³tson¹³ jáɨ¹³ quián¹³ cun³quionh³ hi³ hɨeh³² náh² hñu³mɨ³cuú², quí¹ ñí¹ jáun² bíh¹ ñí¹ cuá¹quien² Dió³²; ");
INSERT INTO csoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","sa³jun³ hniáuh³² má¹tson¹³ náh² jáɨ¹³ quián¹³ cun³quionh³ hi³ hɨeh³² náh² hngá¹máh³ lá², quí¹ ñí¹ hué²¹ lá² dá² lɨ́³ la³jmɨ́¹ lɨ́³ cáun² ñí¹ ná¹tsɨn¹ ta³ bíh¹ Dió³²; hi³ sa³jun³ hniáuh³² má¹tson¹³ náh² jáɨ¹³ quián¹³ cun³quionh³ hi³ hɨeh³² náh² juú² Jerusalén, quí¹ ñí¹ jáun² dá² ca³tɨn¹ Re²¹ Tsá² chín¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ha³ lɨ́² lɨ́¹ ma³tson¹³ jáɨ¹³ quián¹³ cun³quionh³ hi³ hɨeh³² hnú² chinh³², quí¹ hí¹ cá² máɨh³² yáh³ jñú² chinh³² hnú² tiá² lɨ́¹³ tiáu² ho³ liáh² hi³ jmúh¹³ nú² huen². ");
INSERT INTO csoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ñí¹ jɨ́²¹la³ ti³ hniáuh³² juáh¹³ hnú²: “Ján³”, ho³lá²dá²: “Já¹han²¹” bíh¹; quí¹ la³jɨ́³² jáɨ¹³ hi³ lɨ́¹ má²ná²tsɨn³ tsú² ñí¹ jáɨ¹³ nɨ́² ja³² ñí¹con² tsá² hláɨnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”Hnoh² má²ca³niéih² náh² jáɨ¹³ hi³ qui³ juáh²³ tsú² jáun² la³ cun³ jmɨ́¹tin²: “Hniáuh³² jéinh³² tsú² la³ cun³ rón³² lɨ́³ hi³ ca³quiúnh³², uá¹la³ cun³ mɨ́¹ñí¹ tsú², nɨ́¹juáh³ ca³hliah³ tsú² mɨ́¹ñí¹ raɨnh²¹, ja³bí¹ la³ jáun² hi³ ca³tɨ²¹ ján¹ tsú² uá²jaɨ³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Tɨ³la³ jná¹³ juanh³² ñí¹con² hnoh²: Ha³ lɨ́² jéinh¹ náh² ñí¹con² tsá² hian² tsɨ́³; tɨ³la³ nɨ́¹juáh³ zian² tsá² pá²³ cá² jo²¹ máh¹ náh², tɨ³ cuéh³ tsú² siáh³ tɨ³ cá² jo²¹ cáun² cuɨ́¹ pá¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nɨ́¹juáh³ zian² tsá² hnió³ hna³ hnú² ñí¹ta²¹, hi³ hnió³ tsú² quin³ hanh² nú², cuéh³ tsú² la³ jɨ³ hmɨh³² cháu³ quián¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nɨ́¹juáh³ zian² tsá² dí²quiaun³ hnú² jmáɨ¹ hi³ cánh¹ hnú² lio²¹ ñí¹ tí³ cú² mei²¹ quin² ta³ tsú², tɨ³ re² quián² ñí¹ tí³ tenh³ cu³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Lɨ³ua³ jan² tsá² zia³² hi³ mɨ³² ñí¹con² hnú², cuéh³ tsú², hi³ ha³ lɨ́² ma³zian¹³ siáh³ ñí¹con² tsá² zia³² hi³ chí² ñí¹con² nú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”Ja³bí¹ má²ca³niéih² hnoh² hi³ juáh²³ tsú² la³ cun³ jmɨ́¹tin²: “Ma³hno¹ tsá² re² juónh³² quiúnh¹, tɨ³la³ hon² nú² jmu³ nɨ́¹juáh³ tsá² hau² nú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Tɨ³la³ jná¹³ juah³²: Ma³hno¹ náh² tsá² jmu² hian² tsɨ́³ ñí¹con² náh², hi³ chu²¹ jéinh¹ náh² ñí¹con² tsá² chú² juóu³², jmu³ náh² hi³ chú³² ñí¹con² tsá² hau², Dió³² lienh¹ quioh²¹ tsá² quiú² je²³ jɨ³ tsá² jmu² hian² tsɨ́³ ñí¹con² nú². ");
INSERT INTO csoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jáun² la³ nɨ́² bíh¹ lɨ³ lin¹ hi³ tson² lɨ́n³ hnoh² jon² Dió³² Ñeh² náh², Tsá² cuá³ hñu³mɨ³cuú²; quí¹ hí³ dá² jmu² hi³ taɨn³² hiú² tsá² chun¹ la³ jɨ³ tsá² hláɨh¹ nɨ́² siáh³, hi³ zen² tsú² siáh³ jmɨ́³ ñí¹con² tsá² zian² la³ cun³ hi³ tɨ³² tsɨ́³ dí², la³ jɨ³ ñí¹con² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Su³uú² lɨ́¹ lɨ́n²³ náh² hi³ zia³² hi³ hián¹³ cun³ñí¹ hi³ hno³ náh² jmáh³la³ tsá² hniau³ náh² hmóu³². Quí¹ hí¹ la³ tɨ³ *tsá² chi² hmah²¹ yáh³ jmu² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hi³ nɨ́¹juáh³ cuen²³ hnoh² Dió³² jmáh³la³ tsá² juónh³² náh² re² quiúnh¹, ¿he³ dá² hi³ chu²¹ jmuh³² náh² nɨ́¹juáh³ la³ jáun²? Quí¹ hí¹ la³ tɨ³ tsá² tiá² cuóun³² Dió³² yáh³ ná¹jmu² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jmu³ náh² chun¹ la³jmɨ́¹ chun¹ Ñeh² náh² Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","”Ha³ lɨ́² lɨ́¹ ma³ti²¹ náh² cuáh³² jmáh³la³ ñí¹ jɨ́e²³ tsáu² cun³ñí¹ hi³ hniá¹ náh² hi³ jɨ́e³ tsáu² lánh³ jmuh³² náh². Quí¹ hí¹ cáun² yáh³ tiú²uú² hi³ hián¹³ náh² ñí¹con² Ñeh² Tsá² cuá³ hñu³mɨ³cuú², nɨ́¹juáh³ la³ jáun² la³ jmuh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","”Cun³ñí¹ hi³ jáun² bíh¹, nɨ́¹juáh³ jmɨ́¹ ma³hon¹ hnú² tsá² lɨ³hniauh²³ ñí¹con², ha³ lɨ́² jmu² hnú² chú¹ja²¹ ñí¹con² ca³la³ jánh³ dú¹ tsáu², tsá² zian² ja¹ hñú³ jɨ³ tsá² tiáunh¹ hñu³ cuáh³² nɨ́² la³jmɨ́¹ jmu² tsá² lɨ́n³ la³ cá¹ la³ jéinh¹, cun³ñí¹ hi³ hnió³ hi³ hléh³² tsáu² re² quioh²¹. Jú¹ tson² juanh³² jná¹³, hi³ jɨ́³²la³ jú¹ chu²¹ hi³ hléh³² jáun² tsáu² bíh¹ jéi³²í¹ hiáuh³ tsú², ha³ tiú²uú² hi³ siáh³ zia³² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tɨ³la³ nɨ́¹juáh³ nɨ́¹ má¹ca³ma³hon¹ hnú² tsá² lɨ³hniauh²³ ñí¹con², jmu³ la³ cun³ lɨ³ lɨ́¹³ hi³ hí¹ jan² tiá² hin² lɨ³ ñi³², uá¹jinh¹ tsá² jlánh¹ re² juónh³² náh² quiúnh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ta³máɨh³ bíh¹ hniáuh³² jmúh¹³ hnú², hi³ jáun² hián¹³ nú² la³ cun³ hi³ cué³² Ñeh² nú², Tsá² jɨ́e²³ la³ cun³ hi³ jmuh³² nú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Nɨ́¹juáh³ nɨ́¹ má¹ca³lienh¹ hnoh² Dió³², ha³ lɨ́² jmú² náh² la³jmɨ́¹ jmu² tsá² lɨ́n³ la³ cá¹ la³ jéinh¹, hi³ zaɨn³² liéinh³² Dió³² ta³ ná¹táun³ ñí¹ lɨ́³ hñu³ cuáh³² quiú¹³ dí² jɨ³ ñí¹ lɨ́³ cuoh¹ ja¹ hñú³ nɨ́² siáh³, hi³ jáun² jɨ́e³ tsáu². Jú¹ tson² juanh³² jná¹³ hi³ jɨ́³²la³ jú¹ chu²¹ hi³ hléh³² jáun² tsáu² bíh¹ jéi³²í¹ hiáuh³ tsú², ha³ tiú²uú² hi³ siáh³ zia³² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tɨ³la³ nɨ́¹ má¹ca³lienh¹ hnú² Dió³² né³, hen² ñéih³ quián¹³ hi³ jnáɨ¹ ho³hñú¹³, hi³ jáun² ñí¹ zenh² nú² jáun² huen² lienh¹ Ñeh². Hi³ jáun² la³ jáun² zia³² hi³ hián¹³ nú² ñí¹con² Ñeh², Tsá² jɨ́e²³ hi³ jmuh³² hnú² jáun² ta³ conh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Nɨ́¹ má¹ca³lienh¹ nú² Dió³², ha³ lɨ́² hléh² cú²hiú² cú²cuóh³² jáɨ¹³ tiá² lin¹ ñí¹ jmu³ ta²¹ la³jmɨ́¹ jmu² tsá² tiá² Dió³² má²cuóun³², quí¹ tsá² hí³ lɨ́¹ lɨ́n²³ hi³ cun³quionh³ hi³ hleh³² jáun² hliáun³ jáɨ¹³ lɨ́¹³ ne³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Lɨ́² jmú² náh² la³jmɨ́¹ jmu² tsá² hí³; quí¹ ñeh² bí¹ hi³ mɨ́h¹³ náh² má²ñi³² bíh¹ Ñeh² náh² nɨ́¹juáh³ he³ lɨ³hniauh²³ ñí¹con² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Hi³ jáun² né³, lienh¹ náh² Dió³² la³ lá²: Hnú² Tia²¹, Tsá² ñíh³ nú² hñu³mɨ³cuú², cá² ñí¹ hi³ chu²¹ cuɨ́¹ ná¹chan¹ hi³ jmáɨ² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Cuɨ́¹ chau²¹ bíh¹ jmáɨ¹ hi³ la³jɨ́n³² tsáu² tónh³² jo³cuonh² hnú². Cuɨ́¹ lɨ́¹³ bíh¹ ñí¹ hué²¹ lá² la³ cun³ hi³ hnáuh² hnú² jmúh¹³, la³jmɨ́¹ lɨ́³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cué¹ tiá³ má³² hi³ hniáuh³² ñí¹con² jnoh¹ né³², la³ cun³ hi³ qui³ hniáuh³² quiú¹³ jnoh¹ cun³ jmá² cun³ jnia³². ");
INSERT INTO csoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Chin³² tiá³ honh² ca³tɨ²¹ hi³ má²ca³hliáuh² jnoh¹, la³jmɨ́¹ chin²³ jnoh¹ tsɨ́³ la³ cun³ hi³ má²ca³hliánh² tsáu² ñí¹con² jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma³hau¹ tiá³ jnoh¹ hi³ tiá² ca³ tiá² lau³ jnoh¹ tsá² hláɨnh¹, liau¹ tiá³ jnoh¹ ñí¹con² pí³ quioh²¹ tsú². Quí¹ hnú² bíh¹ Tsá² hauh³² nú² jáɨ¹³ ñí¹con² ca³la³ jɨ³lɨ³², Tsá² pin³ cun³ tán¹ cun³ hián², Tsá² cuá¹quien² la³ cun³ jmɨ́¹hi³nio². Tson² bíh¹ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”Jáun² né³, nɨ́¹juáh³ hnoh² chíh¹ honh² tsáu¹³ tsá² jmu² hlah³ ñí¹con² náh², jáun² Ñeh² náh² Tsá² cuá³ hñu³mɨ³cuú² chí¹³ uá²jaɨ³² tsɨ́³ tsáuh³ hnoh²; ");
INSERT INTO csoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","tɨ³la³ nɨ́¹juáh³ tiá² chin²³ yáh³ hnoh² honh² tsáu¹³ tsáu², jáun² sa³jun³ Ñeh² yáh³ hnoh² chin¹³ tsɨ́³ tsáuh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Nɨ́¹ má¹ca³ma³hɨen²¹ hnoh², ha³ lɨ́² háɨ² náh² hlah³ máh¹ la³jmɨ́¹ jmu² tsá² lɨ́n³ la³ cá¹ la³ jéinh¹; quí¹ tsá² jmu² hí³ la³ jáun² dá² hnió³ jɨ́e³ tsáu² hi³ hí³ dí² ná¹má²hɨen²¹. Jú¹ tson² juanh³² jná¹³ hi³ cun³ nɨ́² bíh¹ má²ca³táuh³ la³ cun³ hi³ hiáuh³ tsá² la³ hí³ nɨ́¹juáh³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tɨ³la³ hnú² má¹na²¹, nɨ́¹ má¹ca³ma³hɨen²¹ nú², ráɨn² máh¹ hi³ siáu¹ siáh³ re² chinh³², ");
INSERT INTO csoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","hi³ jáun² tiá² lɨ³lieih²¹ tsáu² hi³ hnú² ñi³ma³hɨen²¹ nú². Jɨ́³²la³ Ñeh² hnú², Tsá² zenh² quiúnh¹ hnú² ta³ tiá² jniá³ jáun² bíh¹ lɨ³ ñi³²; hi³ jáun² hí³ bíh¹ zia³² hi³ cué³² ca³tɨ²¹ la³ cun³ hi³ jmuh³² hnú² jáun² ta³máɨh³. ");
INSERT INTO csoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”Ha³ lɨ́² jmú² dí¹quiaunh²¹ honh² hi³ lɨ³ zian² náh² hliáun³ ñí¹ hué²¹ lá², ñí¹ lɨ́¹³ tsa³hín³ hi³ quián¹³ cun³quionh³ hi³ cuh³ mí¹cháu² jɨ³ hi³ hiá³² juóuh³² nɨ́², jɨ³ ñí¹ lɨ́¹³ hí³ háɨn² hi³ han³. ");
INSERT INTO csoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tɨ³ re² jmu³ náh² pí³ hi³ lɨ³ zian² náh² hliáun³ hñu³mɨ³cuú², ñí¹ tiá² lɨ́¹³ hí³ mí¹cháu² hi³ cuh³, sa³jun³ hiá³² juóuh³² siáh³, hi³ sa³jun³ háɨn² lɨ́¹³ tónh³² siáh³ hi³ han³. ");
INSERT INTO csoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quí¹ nɨ́¹juáh³ ñí¹ nio¹ hi³ quián¹³ náh², ñí¹ jáun² bíh¹ uá²jaɨ³² cua³ jmɨ́²chí³ quián¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Mɨ́¹ñí¹ tsú² lɨ́³ la³jmɨ́¹ lɨ́³ cáun² sɨ́² quioh²¹ tá¹ jan² tsú²; jáun² né³ nɨ́¹juáh³ chu²¹ mɨ́¹máh¹ hnú², jáun² ñí¹con² tá¹ jan² bíh¹ nú² zia³² joh¹; ");
INSERT INTO csoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","tɨ³la³ nɨ́¹juáh³ jlánh¹ la³ hláɨh¹ mɨ́¹máh¹ nú² né³, jáun² tá¹ jan² bíh¹ nú² zenh² já¹niéi². Hi³ nɨ́¹juáh³ cha³ jmɨ́¹ lɨ́³ joh¹ quián¹³ nú² cáun² já¹niéi² bíh¹ la³ lɨ́³, ¡cónh³ bíh¹ tiá² la³ lɨ́³ cáun² já¹niéi² hmíh² nɨ́¹juáh³ la³ jáun²! ");
INSERT INTO csoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Hí¹ jan² tsáu² tiá² lɨ́¹³ ma³tí³² ñí¹con² gon³ juo¹³, quí¹ tiá² tɨ²¹ yáh³ tsɨ́³ tsú² tsá² jan², hi³ tsá² jan² né³, tɨ́³² lɨ́n³² bíh¹ tsɨ́³ tsú²; re² lɨ́n³² bíh¹ ma³tí³² tsú² héih³² quioh²¹ jan², hi³ tsá² jan² né³, tiá² ta²¹ tanh² yáh³ tsú². Jáun² né³, cónh³ tiá² lɨ́¹³ bíh¹ hno³ náh² Dió³² cu³tsa³² quionh³ hi³ hniá¹ náh² hi³ zia³² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”Juo³ jná¹³ hnoh²: Ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh² ha³ lánh³ rón³² lɨ́¹³ zian² náh², ca³tɨ²¹ ha³ jinh¹ já³² má³² hi³ cúh¹³ náh² ho³ jmáɨ² hi³ húh¹³ náh², jɨ³ ha³ jinh¹ já³² hmɨh³² hi³ quɨ́h¹³ náh² siáh³. ¿Há¹ jun³juáh¹³ jmɨ́²chí³ quioh²¹ bíh¹ tsú² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bí¹ má³² dúh¹; hi³ ngú³ quioh²¹ bíh¹ tsú² siáh³ tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ ha¹ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sá¹nɨ́² jɨe³ ha³ lánh³ zian² quiuh²¹ tan³², jáh³ tiá² lin¹ hi³ jñi³² hí¹ cáun², sa³jun³ zia³² bíh¹ cáun² hi³ lau³² quioh²¹ jáh³, hi³ sa³jun³ zeh² bíh¹ siáh³ hñu³cuɨ́³ quioh²¹, tɨ³la³ cun³ jáun² zia³² bíh¹ má³² hi³ cue³² Ñeh² náh² hi³ cúh² jáh³. ¡Tɨ³la³ hnoh² má¹ná¹, tɨ³ jlánh¹ bíh¹ quien² náh² la³ cónh³ bíh¹ tan³²! ");
INSERT INTO csoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Hin² yáh³ hnoh² tɨn² jmúh¹³ hi³ cuóun¹³ cónh³í¹ cá² lɨ́², uá¹jinh¹ hen² lɨ́n³² honh² náh² hi³ cuóun¹³ náh²? ");
INSERT INTO csoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”Hi³ ¿he³ láɨh³² hɨ³² honh² náh² ca³tɨ²¹ hmɨh³² hi³ quɨ́h¹³ náh²? Sá¹nɨ́² jɨe³ náh² ha³ lánh³ rón³² cuóun² lí¹³ hi³ tsɨ²¹ ñí¹ náɨ², lí¹³ jáun² tiá² lin¹ jáu² zeh³² yáh³, hi³ sa³jun³ ta³² siáh³ tá³; ");
INSERT INTO csoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","tɨ³la³ cun³ jáun² ta³ bíh¹ hla¹ re²¹ Salomón yáh³ tiá² chú³² jmɨ́¹ jniá³ la³jmɨ́¹ jniá³ lí¹³ nɨ́², uá¹jinh¹ jmɨ́¹ zioh² lɨ́n³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hi³ jáun² né³, nɨ́¹juáh³ Dió³² jmu² hi³ ca³la³ chú³² lɨ́n³² jniá³ náɨ², cáun² hi³ tsɨ²¹ ñí¹ náɨ² né³², hi³ jáun² tsa³háu² má²jɨ́n³² bíh¹ tsú² tɨ³ ñeh² cáun² pɨeh¹ nɨ́¹ má¹ca³lɨ³ quiéin², jáun² nɨ́¹juáh³ ta³ bí¹ náɨ² yáh³ jmu² Dió³² hi³ chú³² jniá³, ¡cónh³ bíh¹ tiá² jmu³ Dió³² hi³ zia³² hanh² hnoh², hnoh² tsá² cáun² lɨ́¹ hɨ³² honh² náh²! ");
INSERT INTO csoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Hi³ jáun² ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh², hi³ juáh¹³ náh²: “¿He³ dá² cúh¹³ dí²?”, hi³: “¿He³ dá² hnáɨh¹³ dí²?” ho³ hi³: “¿He³ dá² quɨ́h¹³ dí²?” ");
INSERT INTO csoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Quí¹ la³jɨ́n³² tsá² tiá² Dió³² má²cuóun³² ná¹hɨ³² tsɨ́³ ca³tɨ²¹ la³jɨ́³² hi³ nɨ́²; tɨ³la³ hnoh² má¹ná¹, zian² bíh¹ jan² Ñeh² hnoh², Tsá² cuá³ hñu³mɨ³cuú², Tsá² cuá¹ñi³² la³jɨ́³² hi³ lɨ³hniauh²³ quián¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ñí¹ jɨ́²¹la³ ti³ chan¹³ náh² hmóu³² jo³cuo² Dió³² bíh¹ hi³ má¹tih²¹ náh² re² ñí¹con² tsú², jɨ³ hi³ má¹zián¹³ náh² re² la³ cun³ hi³ tɨ³² tsɨ́³ tsú², hi³ jáun² bíh¹ hián¹³ náh² ca³la³ jɨ³lɨ³² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ha³ lɨ́² jmú² náh² hɨ³² honh² ca³tɨ²¹ he³ lɨ́¹³ tsa³háu², quí¹ zia³² bíh¹ jmáɨ¹ tsa³háu² hi³ lɨ́¹³ hɨ³² honh² hnoh² ca³tɨ²¹ hi³ quioh²¹ tsa³háu². Quí¹ ma³ quin³² ma³ cú² jmáɨ¹ bíh¹ má²zia³² uu³mí²tsɨ³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","”Ha³ lɨ́² chú¹ lɨ́² ñih²¹ náh² tsáu² hi³ jáun² tiá² ra³tsa² náh² Dió³² héih³² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Quí¹ la³ jáun² bíh¹ ra³tsɨ³² tsú² héih³² ñí¹con² hnoh², la³jmɨ́¹ rá²tsɨh³² hnoh² jáun² héih³² ñí¹con² tsáu² bíh¹. La³ cun³ rón³² lɨ́³ héih³² hi³ chah³² náh² hi³ cueh³² náh² ñí¹con² tsáu², héih³² la³ jáun² bíh¹ siáh³ chá³² Dió³² hi³ cué³² ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ha³ bí¹ lánh³ rón³² lɨ́¹³ jɨeh²¹ hnú² má¹quɨ³² pih²¹ hi³ hu²¹ mɨ́¹ñí¹ renh², nɨ́¹juáh³ tiá² lɨ́²tsɨn² yáh³ hnú² hi³ hu²¹ cáun² pa²¹ hná¹ hmá² mɨ́¹máh¹ huen²? ");
INSERT INTO csoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Ha³ lánh³ rón³² hó³² honh¹ hnú² hi³ juoh¹ nú² renh²: “¡Cuɨ́¹ chí¹³ ná³ má¹quɨ³² hu²¹ mɨ́¹máh¹ hnú²!”, hi³ nɨ́¹juáh³ cáun² pa²¹ hná¹ hmá² bíh¹ la³ hu²¹ quián¹³ hnú² huen² má¹lɨ³² jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Hnú² tsá² lɨ́n³ nú² la³ cá¹ la³ jéinh¹!, la³ñí¹ tín² chí³ hná¹ hmá² pa²¹ hi³ hu²¹ mɨ́¹máh¹ huen², hi³ jáun² má¹jáun² lɨ́¹³ jɨeh²¹ hnú² re² hi³ chíh¹ nú² má¹quɨ³² pih²¹ hi³ hu²¹ mɨ́¹ñí¹ renh². ");
INSERT INTO csoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”Ha³ lɨ́² lɨ́¹ cué² hi³ hɨ́en¹ ñí¹con² tsá² zian² la³jmɨ́¹ zian² tsáɨ², quí¹ nɨ́² lɨ́¹ ca³qui³ ca³jme³ tsú² hi³ chau³ náh² tsú² cú²tiú² cú²jóh³² hó³². Ha³ lɨ́² lɨ́¹ ma³jnia¹³ hi³ quien² quián¹³ ñí¹con² tsá² zian² la³jmɨ́¹ zian² mí²ñí³, quí¹ nɨ́² lɨ́¹ ca³ha³ ca³zauh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","”Mɨ́¹ náh² ñí¹con² Dió³² hi³ jáun² hian³ náh², hniauh² náh² hi³ jáun² chanh¹ náh², hléh¹ náh² ho³hñú¹³ hi³ jáun² niá³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Quí¹ nɨ́¹juáh³ tsá² mɨ³² ñí¹con² tsú², hiáuh¹³ bíh¹ tsú²; nɨ́¹juáh³ tsá² hnauh², choh¹³ bíh¹; hi³ nɨ́¹juáh³ tsá² hleh³² ho³hñú¹³ né³, niá³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","”Quí¹ ¿hin² yáh³ tsánh² hnoh² tiá³ honh² hi³ cueh¹ cá² máɨ³ quɨ́n¹ jónh³² nɨ́¹juáh³ hí¹miih²¹ bíh¹ la³ cuá¹mɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ho³ nɨ́¹juáh³ cuá¹mɨ² jan² juo¹³, ¿hí¹ tiá³ honh² náh² hi³ cuen¹³ jan² jáh³ hláɨnh¹? ");
INSERT INTO csoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Hi³ jáun² né³, nɨ́¹juáh³ tu³ bí¹ hnoh² yáh³ tsá² tiá² chun¹ náh², tɨn² bíh¹ náh² cuéh¹ hi³ chu²¹ ñí¹con² jónh³², ¡tiá¹³ bíh¹ tiá³ Ñeh² náh² Tsá² cuá³ hñu³mɨ³cuú² tiá² cué³² hi³ chu²¹ ñí¹con² tsá² hiú² mɨ³²! ");
INSERT INTO csoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”Jáun² jmu³ náh² la³jɨ́³² jmáɨ¹ ñí¹con² tsáu² nɨ́¹juáh³ he³ lánh³ hnáuh² náh² jmu³ tsú² ñí¹con² náh² hmóu³²; quí¹ la³ jáun² bíh¹ lɨ́³ héih³² hi³ jmu² jáun² liei²¹ quioh²¹ hla¹ Moisés jɨ³ ñí¹ Sí² quioh²¹ tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³² nɨ́² uá²jaɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Tiónh³² náh² tɨ³ juɨ³² ho³jnɨ́¹³ tsáɨ². Hú³ bíh¹ ho³jnɨ́¹³, hi³ ca³la³ hi³ jáu² lɨ́n³² bíh¹ juɨ³² hi³ chau²¹ ñí¹ lɨ́¹³ tsa³hín³ tsú², hi³ juóun³² lɨ́n³² bíh¹ tsáu² tsá²táunh¹ juɨ³² jaun³²; ");
INSERT INTO csoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","tɨ³la³ ho³jnɨ́¹³ jɨ³ juɨ³² hi³ chau²¹ ñí¹ lɨ́¹³ zian² tsú² né³, jáɨ³² lɨ́n³² bíh¹ hi³ tiá² lɨ³ tɨ́¹ lɨ³ jenh¹, hi³ jáun² cú¹pih²¹ tsáu² bíh¹ tsá² choh²³ juɨ³² jaun³². ");
INSERT INTO csoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Hua³hín¹³ náh² ñí¹con² tsá² lɨ́¹ juáh²³ hi³ lɨ́n³ tɨ³² jë¹ Dió³². Tsá² hí³ dá² ja³táunh¹ ñí¹con² hnoh² hi³ ná¹lɨ́n³ la³jmɨ́¹ lɨ́n³ *já¹ziáh², tɨ³la³ tɨ³ ñeh² má¹ná¹ ná¹lɨ́n³ tsú² la³jmɨ́¹ lɨ́n³ tsɨ́² náɨ¹ jính¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Hnoh² lɨ́¹³ lɨ³ cuóun³² náh² tsú² cun³quionh³ ha³ lánh³ jmu² bíh¹ tsú²; quí¹ tiá² cun³² yáh³ tsú² mɨ³ uóun²jɨeh¹³ ja¹ tan³ mɨ³juɨ́h², hi³ sa³jun³ cun³² yáh³ tsú² mɨ³ sí² co² tsɨ³ hmá² ton². ");
INSERT INTO csoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","La³ nɨ́² bíh¹ lɨ́³ hi³ la³jɨ́³² hmá² chu²¹ háɨ³² máɨ³ chu²¹, hi³ la³jɨ́³² hmá² hlah³ né³, háɨ³² mɨ³ hlah³. ");
INSERT INTO csoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Nɨ́¹juáh³ hmá² chu²¹, tiá² lɨ́¹³ yáh³ hi³ ha³ máɨ³ hlah³, sa³jun³ hmá² hlah³ lɨ́¹³ ha³ máɨ³ chu²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","La³jɨ́³² hmá² tiá² máɨ³ chu²¹ háɨ³², quiéih³² bíh¹ tsú² hmá² jáun², hi³ jáun² jɨ́n³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hi³ jáun² la³ jáun² bíh¹ lɨ³ cuóun³² hnoh² tsáu² cun³quionh³ lánh³ jmu² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","”Jun³juáh¹³ la³jɨ́n³² yáh³ tsá² záɨ³² jná¹³: “¡Hnú² bíh¹ lɨ́n³ Juóu³² jná¹³!” lɨ́¹³ tónh³² jo³cuo² Dió³²; tɨ³la³ jɨ́³²la³ tsá² jmu² la³ cun³ hi³ tɨ³² tsɨ́³ Ñuh³² jná¹³ Tsá² cuá³ hñu³mɨ³cuú² bíh¹ lɨ́¹³ tónh³². ");
INSERT INTO csoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nɨ́¹ má¹cá²chó³² jmáɨ¹ jáun², juóun³² lɨ́n³² tsáu² záɨ³² jná¹³: “Hnú² Juo¹³ jnoh¹, jnoh¹ ca³hléh¹³ cun³ñí¹ hi³ ca³tɨn¹ hnú² jáɨ¹³ hi³ ca³hi³ hñu³ tsɨ́³ jnoh¹, hi³ cun³ñí¹ hi³ ca³tɨn¹ hnú² bíh¹ ca³huen¹³ jnoh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², hi³ cun³ñí¹ hi³ ca³tɨn¹ hnú² siáh³ ca³jmú¹³ jnoh¹ hliáun³ hua³jueh³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tɨ³la³ jná¹³ né³ nga¹ la³ lá² má¹jáun², hi³ juo¹³ ná¹: “Hí¹ cónh³ yáh³ tiá² ca³lɨ³ cuóu³² jná¹³ hnoh². ¡Tɨ³ có³² quin³² náh² ñí¹con² jná¹³, hnoh² tsá² jmuh³² náh² hi³ hlah³ hi³ hó³²!” ");
INSERT INTO csoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”Hi³ jáun² né³, lɨ³ua³ jan² tsá² má²tí³² la³ cun³ jáɨ¹³ hi³ juah³² jná¹³, tsá² la³ hí³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá² quia³lín³ jmɨ́¹ tsɨ́³, tsá² ca³zíh³ hñú¹³ cáun² tsɨ³ hláu². ");
INSERT INTO csoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hi³ jáun² uá¹jinh¹ tsau³ jmɨ́³, hi³ ca³lɨ³ hliáun³ bíh¹ siáh³ cua³, hi³ ja³ bíh¹ siáh³ chí³ tiá³ hi³ jmɨ́¹ hnió³ quɨ́h³ hñú³ jáun², tɨ³la³ tiá² cá²quɨ́h³² yáh³, quí¹ ñí¹ hláu² bíh¹ jmɨ́¹ chí¹hliaun³² jmɨ́h¹ hiah³². ");
INSERT INTO csoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tɨ³la³ lɨ³ua³ jan² tsá² tiá² má²tí³² la³ cun³ jáɨ¹³ hi³ juah³² jná¹³ má¹ná¹, tsá² la³ hí³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá²ñuh² cáun¹ bíh¹, tsá² ca³zíh³ hñú¹³ ñí¹ záɨ¹ táh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hi³ jáun² jmɨ́¹ tsau²¹ jmɨ́³, hi³ ca³lɨ³ hliáun³ bíh¹ jmɨ́² cua³, hi³ ja³ bíh¹ siáh³ chí³ hi³ hnió³ quɨ́h³ hñú³ jáun², jáun² hñú³ jáun² né³, ca³quɨ́² cá²cuon³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jmɨ́¹ má²ca³táuh³ hi³ hleh³² jáun² Jesús, lɨ́¹ ca³ja³cáun² tsɨ́³ bíh¹ tsá² jmɨ́¹ ná¹náɨ³² hí³ ca³tɨ²¹ jáɨ¹³ hi³ má²ta² tsú² jáun²; ");
INSERT INTO csoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","quí¹hliá² jmɨ́¹ cuá¹hɨeh³² tsú² tsáu² la³juah²¹ dúh¹ jan² tsá² ho² jáɨ¹³, jun³juáh¹³ la³jmɨ́¹ jmu² tsá² ná¹lɨ́n³ tɨ³² liei²¹ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jmɨ́¹ ca³son² jáun² Jesús tsɨ³ máh³, juóun³² lɨ́n³² tsáu² ja³taunh²¹ cu³hna²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hi³ jáun² cuan³ jan² tsá²ñuh² lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³, hi³ ca³di³jñí³² ta³ ñí¹ Jesús, hi³ ca³juáh³: ―Hnú² Tɨ³², nɨ́¹juáh³ hnáuh² hnú², tɨn² bíh¹ hnú² jmúh¹³ hi³ lɨ³ jɨn² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jáun² né³, Jesús ca³tí³ cuo² ñí¹ quioh²¹ tsá² hí³, hi³ ca³juáh³ la³ lá²: ―Hnó³² jná¹³. Hi³ jáun² ¡cuɨ́¹ lan² hnú²! Jmɨ́¹ má²lɨ́²juáh³ tsú² jáun² la³ nɨ́² né³, la³juɨ³² ca³hin³ bíh¹ mɨ́¹uɨ́³ jáun² quioh²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Hi³ jáun² ca³juáh³ Jesús hi³ ca³záɨh³ tsá² hí³: ―Sá¹nɨ́² jɨe³, ha³ lɨ́² hin² juouh³² hí¹ jan² ha³ lánh³ rón³² lɨ³ hi³ má²laɨn³² nú²; jɨ́³²la³ ti³ cuánh² hi³ cuá²ma³jnia¹³ ñí¹con² mí²tsáu² bíh¹, hi³ cuá²cuen²¹ siáh³ jáh³ ñí¹con² Dió³² la³ cun³ hi³ qui³ ca³juáh³ jáun² hla¹ Moisés, hi³ jáun² la³ jáun² lɨ³ ñi³² tsáu² hi³ má²laɨn³² nú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jmɨ́¹ lɨ²¹ jáun² né³, ngah³ siáh³ Jesús já¹ juú² Capernaum. Jáun² jan² hliáu³ tsá² chín¹ tsá² *romano ja³ ñí¹con² tsú² hi³ ca³hiu³ ca³mɨ́³, ");
INSERT INTO csoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","hi³ juáh³ la³ lá²: ―Tɨ³², tsá² lɨ́n³ quian²¹ jná¹³ rón³² rá²tsáun¹ hi³ hma², jɨ³ hi³ má²tso² tsɨ́³ hi³ cú² uóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jáun² Jesús ca³juáh³: ―Ñe¹ bíh¹ jná¹³ hi³ ñí¹jmah²¹ ná¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Tɨ³la³ hliáu³ tsá² chín¹ hí³ né³ ca³ngáɨ³: ―Tɨ³², jun³ lin¹ tsáu² yáh³ jná¹³ hi³ juáh¹³ hi³ hnú² cuóh¹³ hñu³² ná¹; ñí¹ jɨ́²¹la³ ti³ jmúh¹³ hnú² héih³² bíh¹ hi³ jáun² tsá² quian²¹ jná¹³ lan¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Quí¹ ja³bí¹ jná¹³ siáh³ zian² juóu³², hi³ ja³bí¹ lɨ́n³ jná¹³ siáh³ hi³ chín¹ ñí¹con² hliáu³. Jáun² nɨ́¹ má¹cá²jmú³² jná¹³ héih³² ñí¹con² lɨ³ua³ jan² tsá² hí³ hi³ tsó³², jáun² tsau³² bíh¹; hi³ nɨ́¹juáh³ juo¹³ jná¹³ jan²: “¡Ña³²!” jáun² ja³²; hi³ nɨ́¹juáh³ juo¹³ jná¹³ tsá² lɨ́n³ quian²¹ ná¹: “¡Jmu³ hi³ lá²!” jáun² jmu² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jmɨ́¹ má²lɨ́²niéi³² Jesús jáɨ¹³ nɨ́² né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³, hi³ jáun² ca³záɨh³ tsá² jmɨ́¹ hí¹já²táunh¹ hí³ cu³hna²¹ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ hí¹ jan² yáh³ tsáu² tiá² má²ca³chanh²¹ jná¹³ ja¹ tsá² *Israel lá², tsá² nio² cáun² tán¹ tsɨ́³ la³jmɨ́¹ nio² cáun² tsɨ́³ tsá²ñuh² *tsá²cá²jo²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jná¹³ juanh³² ñí¹con² hnoh², hi³ juóun³² lɨ́n³² tsáu² ja³táunh¹ tɨ³ juɨ³² ñí¹ hia³² hiú² jɨ³ tɨ³ juɨ³² ñí¹ tá²tsɨ²¹ hiú² nɨ́² siáh³, hi³ tsa³cuú² tsa³hính² cu³lɨ²¹ quionh³ hla¹ Há²bran²¹, hla¹ Isaac jɨ³ hla¹ Jacob nɨ́² hñu³mɨ³cuú² ñí¹ cuá¹quien² Dió³²; ");
INSERT INTO csoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","tɨ³la³ tsá² jmɨ́¹ ca³tɨn¹ hi³ tsa³tiánh² ñí¹ cuá¹quien² Dió³² né³, tsá² hí³ dá² chu³ huen³ bíh¹ tsú² hi³ ziu³ cuɨn³ tsú² ñí¹ lɨ́³ já¹niéi² tɨ³ cheih³², ñí¹ jáun² tsa³tɨ́² tsa³hoh³² hi³ má²zian² hi³ chéi³ hi³ uóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jmɨ́¹jáun² ca³juáh³ Jesús ñí¹con² hliáu³ tsá² chín¹ hí³: ―Cuánh² hñuh³², cuɨ́¹ lɨ́¹³ la³ cun³ hi³ táunh²³ hnú² nɨ́² ta²¹. Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ lan³ tsá² quian²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ Jesús hñú¹³ Pé¹, hi³ jáun² ñí¹ jáun² ca³jɨ́en³² tsú² mɨ³ziú¹³ Pé¹ hi³ rá¹tsɨn² ñí¹ jen³ hi³ rá²tsáun¹ hi³ chéin³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jáun² ca³tí³ dí² cuo² cuo² tsá²mɨ³ hí³, jáun² la³juɨ³² ca³quin³ hi³ jmɨ́¹ chéin³ tsú²; jmɨ́¹jáun² ca³náu² tsá²mɨ³ hí³, hi³ ca³jmú³ má³² hi³ cuh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Jmɨ́¹ ca³niéi² jáun² né³, cua³jan² tsú² juóun³² lɨ́n³² tsá² tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ ñí¹con² Jesús; jáun² cun³quionh³ cá² jon¹ jáɨ¹³ bíh¹ ca³huen³ tsú² la³jɨ́n³² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², ja³bí¹ ca³jmah³ tsú² siáh³ tsá² jmɨ́¹ ná¹tsáun¹ mɨ́¹uɨ́³ siáh³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Cun³quionh³ la³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ Isaías *tɨ³² jë¹ Dió³², jmɨ́¹ ca³juáh³ jáun² la³ lá²: “Hí³ bíh¹ ca³caun² hi³ jmɨ́¹ lɨ́n³ jnoh¹ jáun², jɨ³ hi³ ca³caun² tsú² siáh³ mɨ́¹uɨ́³ quiú¹³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jmɨ́¹ ca³jɨ́e³ jáun² Jesús hi³ juóun³² lɨ́n³² bíh¹ tsáu² tionh² cu³ jéin³ quioh²¹, jáun² ca³jmú³ dí² héih³² hi³ hán³² tsú² cú²jueh³² tɨ³ jo²¹ jmáɨ¹ lɨ́¹ ná¹ho³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jmɨ́¹jáun² jan² tsá² lɨ́n³ tɨ³² liei²¹ ja³ hi³ cua³lienh³ Jesús, hi³ ca³juáh³ la³ lá²: ―Hnú² Tɨ³², ñe¹ bíh¹ jná¹³ quiúnh¹ hnú² lɨ³ua³ cáun² ñí¹ cuóh¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jáh³ zia³² tá² hláu² quioh²¹ bíh¹ cuo², hi³ zia³² bíh¹ siáh³ záɨ² quioh²¹ tan³²; tɨ³la³ Jon² tsá²mɨ³cuóun² má¹ná¹, tiá² zia³² yáh³ ñí¹ lɨ́¹³ jnioh¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Siáh³ siáh³ jan² tsá² má²hen² tɨ³ con² tsú² ca³juáh³: ―Tɨ³², cué¹ tín² jáɨ¹³ hi³ ñí¹hón²¹ jná¹³ ñuh³² nɨ́¹ má¹jun². ");
INSERT INTO csoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tɨ³la³ Jesús né³, ca³záɨh³ tsá² hí³: ―Ña³² cu³hna³² jná¹³, hi³ jáun² tsá² ná¹jún¹ ñí¹con² Dió³² cuɨ́¹ cha³hón³² hla¹ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jmɨ́¹jáun² ca³hi³ Jesús cáun² mu², hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² já¹taunh²¹ siáh³ quionh³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Hi³ jáun² hú¹ juɨ³² jáun² né³, cu³diá²jan² ca³ja³ cáun² chí³ tiá³ lɨ́n³² hi³ hí¹ ca³la³ tɨ³ jmɨ́¹ má²hí¹conh³² yáh³ jmáɨ² hñu³ mu², hi³ jmɨ́¹ má²jláɨ²³ siáh³ mu² ma³ quin³² ma³ cu³ tsɨn¹ jmɨ́²miih²¹. Tɨ³la³ Jesús má¹ná¹, jmɨ́¹ má²rá²cuóun¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jáun² ca³ñí¹ñi¹³ tsú² Jesús, hi³ ca³záɨh³ dí² la³ lá²: ―¡Tɨ³², liau¹ jnoh¹! ¡Hénh³ máh³ má²tsá²hanh³² dí² hñu³ jmáɨ²! ");
INSERT INTO csoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jáun² hí³ né³ ca³ngáɨ³: ―¿He³ láɨh³² ja³²lɨ³ ná¹juenh²¹ náh²? ¡Jlánh¹ tiá² cáun² la³ nio² honh² náh²! Hi³ jáun² ca³náu² Jesús hi³ ca³jin³ chí³ jɨ³ jmɨ́²miih²¹ nɨ́²; hi³ jáun² jmɨ́¹jáun² ca³hná³ chí³ hi³ ca³ta³no¹ tie³ pih²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hi³ jáun² tsá² jmɨ́¹ tiáunh¹ hí³ hñu³ mu² quionh³ Jesús né³, lɨ́¹ ca³ja³cáun² tsɨ́³ bíh¹, hi³ ca³juánh³ la³ lá²: ―¿Hin² dá² tsánh² tsá² nɨ́² hi³ hí¹ la³ tɨ³ chí³ jɨ³ jmɨ́²miih²¹ máh³ taunh² ta²¹? ");
INSERT INTO csoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jmɨ́¹ cá¹chó²¹ jáun² Jesús jo²¹ jmáɨ² lɨ́¹ ná¹ho³ né³, ñí¹ má²lɨ́³ hué³² quioh²¹ tsá² Gadara, jáun² ca³huén² gon³ tsá²ñuh² ñí¹ táun³ jéin³ lo¹ ñí¹ ná¹hón²¹ hla¹, hi³ jáun² ca³ja³taunh²¹ ñí¹ zenh¹ Jesús. Tá¹ gon³ bíh¹ tsú² jmɨ́¹ tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³; tsá² hí³ jmɨ́¹ hian² lɨ́n³² tsɨ́³ hi³ ca³la³ hí¹ jan² tiá² hin² jmɨ́¹ lɨ³ ngá¹³ hú¹ juɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jmɨ́¹jáun² ca³ma³liáu³² hóh³² tiá³ lɨ́n³² hi³ juáh³: ―¿He³ ca³tɨn¹ hnú² quiúnh¹ jnoh¹, hnú² Jesús Jon² Dió³²? ¿Hí¹ ñeh³ hnú² ñí¹ lá² hi³ ña³jmuh³ nú² hi³ má¹tso¹ jnoh¹ tsɨ́³ ta³ ñeh² bíh¹ hi³ chau²¹ jmáɨ¹? ");
INSERT INTO csoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ñí¹ má²janh² jáun² jmɨ́¹ ñi³táunh¹ juóun³² mí²ñí³ hi³ ñi³cúh¹³ háu²; ");
INSERT INTO csoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ né³, ca³hiu³ ca³mɨ́³ ñí¹con² Jesús, hi³ ca³juáh³: ―Nɨ́¹juáh³ hi³ hue¹³ nú² jnoh¹, cué¹ tiá³ jáɨ¹³ hi³ tsá¹tauh²¹ jnoh¹ hñu³ tsɨ́³ mí²ñí³ ó³². ");
INSERT INTO csoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jáun² Jesús ca³juáh³: ―¡Huen³ náh²! ¡Cuá²tiónh³² náh²! Hi³ jáun² ca³huén² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsá²ñuh² hí³ hi³ ca³ñí¹tiónh²¹ hñu³ tsɨ́³ mí²ñí³; la³ cun³ jmɨ́¹jáun² bíh¹ ca³cuóun³ mí²ñí³ hí³ tɨ³ juɨ³² dí¹jɨ²³ ñí¹ hlah³, hi³ jáun² ca³sunh³ chu³ jmáɨ² lɨ́¹ ná¹ho³ jáun², hi³ ca³tsan³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tsá² jmɨ́¹ ná¹jmu² hua³hí¹³ mí²ñí³ hí³ né³, ca³cuóun³ bíh¹ hi³ ca³ñí¹chá² já¹ juú² la³ cun³ hi³ má²lɨ³², jɨ³ la³jɨ́³² hi³ má²lɨ³² jáun² ñí¹con² tsá²ñuh² tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jmɨ́¹jáun² ca³huén² la³jɨ́n³² tsá² juú² hi³ ca³ñí¹ma³jéinh³ Jesús; jmɨ́¹ ca³jɨ́en³² dí² jáun² né³, ca³hiu³ ca³mɨ́³ dí² ñí¹con² tsú² hi³ cua³han² tsú² hué³² jáun² quioh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jmɨ́¹ lɨ²¹ jáun² né³ ca³hi³ Jesús hñu³ mu², hi³ ca³han³ tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun² hi³ ca³chánh³² tɨ³ juú²co¹. ");
INSERT INTO csoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ñí¹ jáun² ca³ñí¹jan² tsáu² jan² tsá²ñuh² tsá² hma², hi³ rá¹tsɨn² cáun² ñí¹ jmu². Jmɨ́¹ ca³lɨ³tsɨn² jáun² Jesús hi³ cáun² tán¹ bíh¹ ná¹tioh³ tsɨ́³ tsá² ca³cha³táunh¹ hí³, hi³ jáun² ca³záɨh³ dí² tsá² tsáun¹ hí³ la³ lá²: ―Hnú² jón³, tiá³ chá¹ honh²; má²cá²hin³ bíh¹ tso³ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jmɨ́¹jáun² ma³ jan² tsá² ná¹lɨ́n³ tɨ³² liei²¹ ca³lɨ́n¹³ la³ lá² hñu³ tsɨ́³: “Tsá²ñuh² nɨ́² cáun² lɨ́¹ chú² lɨ́¹ lén³² Dió³² cun³quionh³ jáɨ¹³ quioh²¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tɨ³la³ Jesús jmɨ́¹ ñi³² bíh¹ he³ lánh³ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ dí²: ―¿He³ láɨh³² hlaɨh³ lɨ́n²¹ ná¹tioh³ honh² hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Hín² jáɨ¹³ hi³ tun³ lá² hi³ jlánh¹ huán¹ tsɨ́³ lɨ³ lin¹ hi³ zia³² pí³ quioh²¹ tsá² hleh³², hí¹ cun³quionh³ hi³ juáh³ tsú²: “¡Tso³ quián¹³ hnú² má²cá²hin³!” ho³ hi³ juáh³ tsú²: “¡Náu², ngɨ́¹!”? ");
INSERT INTO csoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Re² bíh¹, cuɨ́¹ má¹jnia¹³ jná¹³ ñí¹con² hnoh² hi³ jná¹³ Jon² tsá²mɨ³cuóun² ho² ná¹ jáɨ¹³ ñí¹ hué²¹ lá² hi³ hin¹³ ná¹ tsáu¹³ tsáu². Hi³ jáun² ca³záɨh³ dí² siáh³ tsá² hma² hí³: ―¡Náu², quiaun² jmu² quián¹³, cuánh² hñuh³²! ");
INSERT INTO csoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jmɨ́¹jáun² ca³náu² tsá² jmɨ́¹ hma² hí³ hi³ ngah³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jmɨ́¹ má²lɨ́²jɨ́e³ tsáu² hi³ lɨ³ la³ jáun², lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³, hi³ jáun² ca³ma³quien² tsú² Dió³² Tsá² ca³cué³ pí³ la³ jáun² ñí¹con² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús ñí¹ jáun² hi³ ngau³ ñí¹ siáh³, jáun² ca³jɨ́en³² tsú² jan² tsá²ñuh² jmáɨ² Má²téh³, hi³ jmɨ́¹ cuá¹tón²¹ ñí¹ cuá¹caɨ³² hmah²¹ cha¹³ tsá² *romanos, hi³ jáun² ca³záɨh³ dí²: ―Ña³² cu³hna³² jná¹³. Jmɨ́¹jáun² ca³náu² Má²téh³ hi³ ngau³ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jmɨ́¹ lɨ²¹ jáun² né³, Jesús jmɨ́¹ cuá¹jmu² má³² hñú¹³ Má²téh³ hí³, la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con². Ja³bí¹ ca³tiánh³ siáh³ juóun³² lɨ́n³² *tsá² caɨ³² hmah²¹ ñí¹ mesa jáun² quionh³ tsú², la³ má²quionh³ tsá² juáh²³ tsáu² hi³ tiá² chun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jáun² jmɨ́¹ ca³jɨ́e³ tsá² cu³ nió³ téh²³ tsú² *fariseos hi³ jáun² né³, jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² tsú²: ―¿Ha³ bí¹ lánh³ rón³² sa³ tɨ³² juóuh³² hnoh² cáun² cuú² hɨ́nh²³ cu³lɨ²¹ quionh³ tsá² caɨ³² hmah²¹ jɨ³ tsá² ren² tso³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jmɨ́¹ ca³náɨ³² Jesús jáɨ¹³ nɨ́² né³, ca³juáh³: ―Ha³ tiá² tɨ³² mɨ́³ hniah³ yáh³ ñí¹con² tsá² chun¹, tɨ³la³ ñí¹con² tsá² tsáun¹ bíh¹ hniah³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Cuá²tánh¹ náh², hi³ cuá²ma³tɨn¹³ náh² la³ cun³ hi³ hnió³ juáh³ Sí² tioh³ jáɨ¹³ quioh²¹ Dió³², ñí¹ rá¹juáh³ la³ lá²: “Jná¹³ hnó³² hi³ já³² mií³ honh² bíh¹ náh², jun³juáh¹³ hi³ hnó³² jná¹³ hi³ jngɨh¹³ náh² jáh³ yáh³ ñí¹con² jná¹³”. La³ nɨ́² bíh¹ rá¹juáh³, quí¹ tiá² ja³ yáh³ jná¹³ hi³ ja³te³ ná¹ tsá² chun¹, quí¹ hi³ ja³te³ tsá² ná¹ren² tso³ bíh¹ jná¹³ ja³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jmɨ́¹jáun² cua³taunh²¹ tsá² haɨn²¹ tɨ³ con² Juan² tsá² ziau² hí³ jmáɨ² ñí¹ zenh¹ Jesús, hi³ ca³ngáɨ³: ―¿He³ láɨh³² ma³hɨen²¹ lɨ́n²¹ jnoh¹, jɨ³ tsá² fariseos nɨ́² siáh³, tɨ³la³ tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² né³, sa³ tiá² má²hɨen²¹ yáh³? ");
INSERT INTO csoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jáun² Jesús ca³juáh³ la³ lá²: ―¿Hí¹ lɨ́¹³ hi³ tsá² ná¹tén¹ ñí¹ jmu² tsú² jmáɨ¹ hi³ jenh² cuo² tsáu² tiánh³ hi³ ná¹haɨ²¹ hlah³ tsɨ́³ tá¹la³ má²ná¹má²hiún² tsú² tsɨ́³ quionh³ tsá²ñuh² tsá² jenh¹³ hí³ cuo² dúh¹? Tɨ³la³ chau²¹ bíh¹ jmáɨ¹ hi³ quin³ tɨ³ có³² tsá²ñuh² jenh¹³ hí³ cuo²; hi³ jáun² má¹jáun² máh³ má²ma³hɨen²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","”Hí¹ jan² yáh³ tiá² hin² taun³² cáun² hmɨh³² tseh¹ quionh³ cá² cuonh²¹ hmɨh³² hmaɨ²¹; quí¹ tsáuh³² bíh¹ hná¹ hmɨh³² hmaɨ²¹ jáun², hi³ jáun² cáɨ³² bíh¹ hmɨh³² má²tseh¹, hi³ jáun² tɨ³ jlánh¹ bíh¹ ñí¹ jueh³² má²cáɨ³² má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hi³ sa³jun³ tah³² tsú² siáh³ mu² ráu³ cun³ ñí¹ dí¹jaun³² hñu³ chí² láu² má²tseh¹; quí¹ nɨ́¹juáh³ hi³ jmu³ tsú² la³ jáun², má²cáɨ³² bíh¹ chí² láu² tseh¹ jáun² lɨ́¹³, hi³ jáun² tsa³hín³ bíh¹ mu² ráu³ la³ má²quionh³ chí² láu² tseh¹ jáun². Hi³ jáun² bíh¹ hniáuh³² táh³² tsú² mu² ráu³ cun³ ñí¹ dí¹jaun³² hñu³ chí² láu² hmaɨ²¹, hi³ jáun² tiá² hi³ láɨh¹³ tá¹ tun³ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tá¹la³ jmɨ́¹ cuá¹juáh²³ Jesús jáɨ¹³ nɨ́² né³, jan² tsá² chín¹ ñí¹con² tsá² *judíos cuan³, hi³ jáun² ca³di³jñí³² hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³² ta³ ñí¹ dí², hi³ ca³juáh³: ―Mɨ́¹míh¹ jón³² jná¹³ cun³ jun³; tɨ³la³ nɨ́¹juáh³ hnú² ñeih²¹ hi³ ñá¹ra³tsɨh³² cuonh² ñí¹ quioh²¹ tsú², jenh¹³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jmɨ́¹ má²lɨ́²juáh³ jáun² tsá² hí³ la³ nɨ́², ca³náu² Jesús hi³ ngau³ quionh³ tsá² hí³, la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hi³ jáun² hú¹ juɨ³² jáun² né³ ja³ jan² tsá²mɨ³ tsáun¹ má²janh² cu³hna²¹ Jesús hi³ ca³tí³ cuo² zéi¹ ha¹ tsú². Tsá²mɨ³ hí³ né³ má²tí³ cun³ quia³tún³ mii² hi³ jmɨ́¹ má²tso² tsɨ́³ hi³ zian² jmɨ́²hán¹. ");
INSERT INTO csoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jáun² tsá²mɨ³ hí³ né³ ca³lɨ́n¹³ hñu³ tsɨ́³ la³ lá²: “Nɨ́¹juáh³ jɨ́³²la³ ti³ tí¹³ jná¹³ uón³² zéi¹ ha¹ bíh¹ tsú², cun³ jáun² bíh¹ má²lan¹³ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tɨ³la³ Jesús ca³jinh³ tɨ³ cu³hna²¹ hi³ ca³jɨ́e³ tɨ³ ñí¹ cuá¹ja³² tsá²mɨ³ hí³, hi³ jáun² ca³záɨh³ dí²: ―Jón³, tiá³ chá¹ honh²; má²laɨn³² nú² quí¹hliá² lɨ́²cháh¹ cáun² honh². Hi³ jáun² dá² la³ cun³ jmɨ́¹jáun² bíh¹ lan³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jmɨ́¹ cá¹chó²¹ Jesús hñú¹³ tsá² chín¹ hí³ né³, ca³jɨ́e³ hi³ má²tionh² tɨ³² tsá² haɨnh³² hi³ má²tiáunh¹ hua³jan²¹ hi³ tsa³hón³² hla¹, hi³ tsáu² né³ má²tiáunh¹ tiá³ siaun³² ca³la³ cú²tiú² cú²jan³² nio². ");
INSERT INTO csoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―¡Huen³ náh² ñí¹ lá²! Quí¹ mɨ́¹míh¹ lá² tiá² rá²jún¹ yáh³, quí¹ rá²cuóun¹ bíh¹ tsú². Tɨ³la³ tsá² hí³ né³, lɨ́¹ ca³ju³ ca³ngáɨ³ bíh¹ quioh²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jmɨ́¹ má²lɨ́²huen³ Jesús tsá² hí³ né³, ca³hi³ ñéih³ ñí¹ rón²¹ mɨ́¹míh¹ hí³ hi³ ca³zanh³ dí² cuo² hla¹ mɨ́¹míh¹ hí³, hi³ jáun² ca³náu². ");
INSERT INTO csoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hi³ jáun² la³ tán¹ la³ cu³ la³ jéin³ jáun² ca³lɨ³ ñi³² tsáu² la³ cun³ hi³ lɨ³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jmɨ́¹ lɨ²¹ jáun² né³ cua³han³ Jesús ñí¹ jáun², jáun² hú¹ juɨ³² ja³taunh²¹ gon³ tsá² ten³ cu³hna²¹ tsú² hi³ hí¹hóh³², hi³ hí¹juáh²³: ―Hnú² Tsá² jón²zɨ́h¹ jon²cho¹ hla¹ Dá²vi²¹, ¡cuɨ́¹ já² mií³ honh² hnú² quiú¹³ jnoh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jmɨ́¹ hi²¹ jáun² Jesús ñéih³, jáun² tsá² ten³ hí³ taunh³ siáh³ ñéih³, jáun² ca³záɨh³ Jesús tsá² hí³: ―¿Nió¹ cáun² honh² hnoh² hi³ lɨ́¹³ jmu¹ jná¹³ la³ cun³ hi³ mɨh³² náh² nɨ́²? Jáun² tsá² hí³ ca³ngáɨ³: ―Ján³, Tɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jmɨ́¹jáun² ca³tí³ Jesús cuo² mɨ́¹ñí¹ tsá² hí³, hi³ ca³záɨh³ dí²: ―La³ cun³ hi³ táunh²³ hnoh² nɨ́² ta²¹ cuɨ́¹ lɨ́¹³ ñí¹con² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jáun² la³ cun³ jmɨ́¹jáun² ca³niá³ mɨ́¹ñí¹ tsá² hí³. Jmɨ́¹ lɨ²¹ jáun² né³, jlánh¹ ca³jmú³ Jesús héih³² ñí¹con² tsá² hí³ hi³ ca³juáh³: ―Jmu³ náh² tion³ hi³ hí¹ jan² tsáu² lɨ́² cuɨ́¹ lɨ³ ñi³² hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tɨ³la³ cun³ rón³² ná¹huen³² bíh¹ tsú² ñí¹ jáun², la³juɨ³ ca³chá³ bíh¹ tsú² ñí¹con² tsá² juú² la³ tán¹ la³ cu³ la³ jéin³ jáun² la³ cun³ hi³ má²lɨ́²jmú³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tá¹la³ hí¹huen³² jáun² tsá² hí³ cua³taunh²¹ ma³ jan² tsáu² ñí¹con² Jesús hi³ ná¹ján² jan² tsá²ñuh² tsá² tiá² hleh³² hi³ jmɨ́¹ hún¹ jan² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","La³ cun³ jmɨ́¹ ca³chin² jáun² Jesús jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsú², ca³ma³liáu³² hleh³². Jáun² tsáu² né³, lɨ́¹ ca³ja³cáun² tsɨ́³ bíh¹, hi³ jáun² ca³juáh³ la³ lá²: ―Hí¹ cónh³ yáh³ tiá² má²ca³neh²¹ dí² hué³² *Israel lá² la³ cun³ hi³ má²lɨ³² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tɨ³la³ tsá² fariseos má¹ná¹, jmɨ́¹ ná¹juáh²³: ―Tsá²ñuh² nɨ́² dá² huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² cun³quionh³ héih³² quioh²¹ tsá² hláɨnh¹ juo¹³ jmɨ́²chí³ hláɨnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jmɨ́¹ lɨ²¹ jáun² né³, ca³tɨ³ ca³ngɨ́³ Jesús la³jɨ́³² juú², jɨ³ juú² míh¹ juú² siún¹ hi³ má²tɨn² tsáu² hñu³ cuáh³² quioh²¹ tsá² judíos hi³ táun³ ma³ quin³² ma³ caun³² juú², hi³ ñi³hleh²¹ jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³², jɨ³ hi³ jmah²³ tsáu² jɨ³lɨ³² ñí¹ mɨ́¹uɨ́³ hi³ zian² tsú², jɨ³ hi³ cú² hi³ uóu³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jmɨ́¹ ca³jɨ́en³² tsú² tsá² juóun³² lɨ́n³² hí³ né³, ca³ja³ mií³ tsɨ́³ quioh²¹ tsá² hí³, quí¹hliá² jmɨ́¹ ná¹haɨ²¹ hlah³ tsɨ́³ tsú² jɨ³ hi³ ná¹lɨ́n³ tsú² tsá² tiá² hin² zian² hi³ lɨ́¹³ ma³hau³, la³jmɨ́¹ ñi³táunh¹ *já¹ziáh² tiá² juo¹³ zian². ");
INSERT INTO csoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jmɨ́¹jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―¡Hliáun³ cu³tí³ bíh¹ hi³ má²ca³láu², tɨ³la³ pih²¹ lɨ́n²¹ bíh¹ tsá² jmu² ta²¹ zian²! ");
INSERT INTO csoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Hi³ jáun² né³, hiú¹ mɨ́¹ náh² ñí¹con² Tsá² quioh²¹ hi³ má²ca³láu² jáun², hi³ cuɨ́¹ zen¹ tsú² tsá² ja³quiaun² hi³ má²ca³láu² jáun² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jmɨ́¹ lɨ²¹ jáun² né³ ca³teh³ Jesús tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³cuéh³ dí² pí³ hi³ lɨ́¹³ huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², jɨ³ hi³ jmah³ tsú² tsá² ná¹tsáun¹ la³jɨ́³² ñí¹ mɨ́¹uɨ́³ jɨ³ hi³ cú² hi³ uóu³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hi³ lá² bíh¹ hi³ jmáɨ² tán¹ quian³tun³ *tɨ³² tsá² quian³² jë¹ Dió³²: la³ñí¹ Sí¹mu²¹ tsá² ca³lɨ³ jmáɨ² siáh³ Pé¹, jɨ³ Tre²¹ dá¹jon²¹ tsú² nɨ́²; Jacobo jon² Zebedeo la³ má²quionh³ Juan² dá¹jon²¹; ");
INSERT INTO csoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pí²liéi¹, Bartolomé, Tú¹ma²¹ jɨ³ Má²téh³ nɨ́², tsá² jmɨ́¹ lɨ́n³ hí³ *tsá² caɨ³² hmah²¹; Jacobo jon² Alfeo; jɨ³ Tadeo; ");
INSERT INTO csoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Sí¹mu²¹ tsá² ca³lɨ³ quionh³ tsá² cu³ nió³ *Cananista nɨ́², jɨ³ Judas tsá² zian² juú² Queriot, tsá² ca³ñí¹jɨenh¹³ hí³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús ca³zen³ tsá² quian³tun³ hí³ cun³quionh³ héih³² lá²: ―Ha³ lɨ́² cua³táunh¹ náh² hué¹³ *tsá²cá²jo²¹, sa³jun³ cuá¹tiónh³² náh² juú² hɨ́n¹³ tɨ³ Samaria; ");
INSERT INTO csoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","tɨ³la³ hniáuh³² cuá¹táunh¹ náh² ñí¹con² tsá² *Israel lá² bíh¹, tsá² ná¹lɨ́n³ la³jmɨ́¹ lɨ́n³ *já¹ziáh² má²já²cuɨn³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Cuá²táunh¹ náh², cuá²zéih³ náh² tsú² hi³ Dió³² má²cuá¹hinh²³ tsáu² jo³cuo². ");
INSERT INTO csoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jmah²¹ náh² tsá² ná¹lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³ jɨ³ tsá² ná¹lɨ́n³ mɨ́¹uɨ́³ siáh³ siáh³; jmu³ náh² hi³ jenh¹³ tsá² má²jún¹; huen³ náh² siáh³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu². Quí¹ hnoh² lɨ́¹ má²hian² bí¹ náh² pí³ nɨ́² ta³ tiá² hmah²¹ quien², jáun² jmuh²¹ náh² ta²¹, tɨ³la³ ha³ lɨ́² cán² náh² hmah²¹ má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”Ha³ lɨ́² ñi³quián¹ náh² hí¹ cú¹pih²¹ quɨe³, uá¹ hi³ cú¹mí¹niau²¹, uá¹ hi³ *cú¹tiáu², hí¹ cáun² cú¹dáɨn³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Sa³jun³ hniáuh³² cánh¹ náh² tuh³² hi³ tioh³ hi³ hniáuh³² hú¹ juɨ³². Ha³ lɨ́² cán² náh² tun³ hanh², sa³jun³ tuh³² tioh³ tanh¹, hi³ sa³jun³ cánh¹ náh² siáh³ hmá²hu²¹; quí¹ tsá² jmu² ta²¹ cun³ ca³tɨn¹ bíh¹ hiáuh³ la³jɨ́³² la³ cun³ hi³ lɨ³ hniáuh³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","”Nɨ́¹ má¹ca³cha³táunh¹ náh² cáun² juú² ho³lá²dá² lɨ³ua³ cáun² ñí¹náɨ², hniah³² náh² jan² tsá² chú³² tsɨ́³ ñí¹ jáun² hi³ jáun² tianh³ náh² hñú¹³ tsá² hí³ ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ huen¹³ náh² ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nɨ́¹ má¹ca³tiónh³² náh² hñú³ jáun², zéih³ tsá² tionh² ñí¹ jáun² hi³ cuɨ́¹ tionh² tsú² cáun² hi³ re² hi³ tɨn². ");
INSERT INTO csoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nɨ́¹juáh³ hi³ ca³tɨn¹ tsá² hí³ hi³ tiánh³ cáun² hi³ re² hi³ tɨn², lɨ³ quien² bíh¹ hi³ má²lɨ́²zéih³ náh² tsá² hí³, tɨ³la³ nɨ́¹juáh³ tiá² ca³tɨn¹ tsá² hí³ hi³ tiánh³ cáun² hi³ re² hi³ tɨn², jáun² jáɨ¹³ hi³ má²lɨ́²zéih³ náh² tsú² jáun² jáuh³ bíh¹ siáh³ ñí¹con² náh² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hi³ nɨ́¹juáh³ lɨ³ua³ cáun² hñú³ ho³ juú² ñí¹ ca³cha³táunh¹ náh² tiá² ca³he³ náh² tsú², hi³ sa³jun³ hnió³ tsú² ne³ jáɨ¹³ quián¹³ náh², hi³ jáun² né³, súh³ náh² hliáu² quian²¹ tanh¹ nɨ́¹ má¹tɨ³ ñí¹ huen¹³ náh² hñú³ jáun² ho³ juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jú¹ tson² juo³ jná¹³ hnoh², hi³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ ra³tsɨ³² Dió³² héih³², tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ hi³ ma³tson¹³ Dió³² tsá² juú² la³ hí³ la³ cónh³ bíh¹ hi³ ca³quiúnh³² jáun² tsá² jmɨ́¹ zian² juú² Sodoma jɨ³ Gomorra. ");
INSERT INTO csoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”¡Sá¹nɨ́² jɨe³! Jná¹³ zei²¹ hnoh² hi³ ná¹lɨ́n³ náh² la³jmɨ́¹ lɨ́n³ *já¹ziáh² tionh² ja¹ tsɨ́² náɨ¹. Tɨ³la³ jmu³ náh² jan²¹ lɨ́n²¹ la³jmɨ́¹ lɨ́n³ jáh³ hláɨnh¹; tɨ³la³ tá¹la³ jáun² né³, jmu³ náh² hi³ chú³² honh² náh² má¹ná¹ la³jmɨ́¹ lɨ́n³ chi³ jáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Hua³hín¹³ náh², quí¹ hnoh² jɨenh³ tsú² jo³cuo² tsá²tan²¹, jɨ³ hi³ quiu³ po³ tsú² hnoh² la³ tɨ³ hñu³ cuáh³² quiú¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hi³ hí¹ ca³la³ tɨ³ ñí¹con² tsá² ná¹ho² ta²¹ jɨ³ tsá² ná¹lɨ́n³ re²¹ yáh³ tsa³jau² tsú² hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³; má¹jáun² bíh¹ má²lɨ́¹³ cuéh¹ hnoh² jú¹ tson² hi³ ca³tɨn¹ jná¹³ ñí¹con² tsá² hí³ jɨ³ ñí¹con² tsá²cá²jo²¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tɨ³la³ nɨ́¹ má¹ca³zeh³ tsú² hnoh² ñí¹ ta³ ñí¹ tsá²tan²¹ né³, ha³ lɨ́² jmú² náh² hɨ³² honh² nɨ́¹juáh³ he³ juáh¹³ náh² ho³ nɨ́¹juáh³ he³ lánh³ rón³² hléh¹³ náh²; quí¹ nɨ́¹juáh³ nɨ́¹ má¹ca³tɨ³ ñí¹ hléh¹³ náh², Dió³² bíh¹ cué³² jáɨ¹³ hi³ cuá¹hléh¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Quí¹ jun³juáh¹³ hnoh² yáh³ tsá² cuá¹hléh¹ náh², quí¹ Jmɨ́²chí³ joh¹ Ñeh² bíh¹ náh² Tsá² hléh³² cun³quionh³ honh¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Hí¹ la³ tɨ³ tsá² jan² jméi² mí¹ziú¹³ quionh³ yáh³ tsú² jɨenh³ hi³ jngah³ tsáu², jɨ³ tsá² má²lieih²¹ siáh³ jɨenh³ jon²; jon² tsáu² jmu³ hniéi² quionh³ jméi² mí¹ziú¹³, hi³ hí¹ ca³la³ tɨ³ jɨenh³ yáh³ tsú² tsá² má²lieih²¹ hi³ jngah³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tsá² zian² tá¹ cáun² hngá¹máh³ bíh¹ lɨ³ hau² hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³; tɨ³la³ nɨ́¹juáh³ tsá² ca³tion³ tsɨ́³ ca³la³ tɨ³ ñí¹ cá¹táuh³ jmáɨ¹ quioh²¹ hi³ zian² ñí¹ hué²¹ lá² né³, tsá² la³ hí³ bíh¹ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nɨ́¹juáh³ ca³hɨ́¹ ca³tsa¹ tsú² hnoh² cáun² juú², huen³ náh² ñí¹ jáun² hi³ cuá¹táunh¹ náh² cáun² juú² siáh³; quí¹ jú¹ tson² juah³² jná¹³ hi³ jná¹³ Jon² tsá²mɨ³cuóun² jáunh¹³ ná¹ ñeh² bíh¹ hi³ táunh³ hnoh² la³jɨ́³² juú²co¹ juú²hñú¹³ tsá² Israel. ");
INSERT INTO csoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Hí¹ jan² yáh³ tsá² má²tɨn³² tiá² lɨ́¹³ lɨ³tɨn² tɨ³ hliáun³ la³ cónh³ bíh¹ tɨ³² joh¹, hi³ hí¹ jan² yáh³ tsá² lɨ́n³ quian²¹ tiá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ tsá² lɨ́n³ juo¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tsá² cuá¹má²tɨn³² hí³ dá² ca³tɨn¹ ma³hiún² tsɨ́³ cun³ jɨ́³²la³ ti³ hi³ chau²¹ jmáɨ¹ hi³ lɨ́n¹³ la³jmɨ́¹ lɨ́n³ tɨ³² joh¹ bíh¹, hi³ tsá² lɨ́n³ quian²¹ né³ ca³tɨn¹ ma³hiún² tsɨ́³ hi³ lɨ́n¹³ la³jmɨ́¹ lɨ́n³ juo¹³. Quí¹ nɨ́¹juáh³ ta³bí¹ tsá² chín¹ cáun² hñú³ yáh³ ca³juáh³ tsáu² hi³ lɨ́n³ Beelzebú tsá² chín¹ juo¹³ jmɨ́²chí³ hláɨnh¹, ¡cónh³ bíh¹ tiá² tu³ hión³² tsú² tsá² hñú¹³ tsú² ñí¹ hná¹ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Hi³ jáun² né³, tiá² hniáuh³² yáh³ jmúh¹³ náh² juénh² ñí¹con² tsáu². Quí¹ lɨ³ua³ cáun² hi³ jlɨ́²³ tsú², chau³² bíh¹ jmáɨ¹ hi³ jñéih²³, hi³ lɨ³ua³ cáun² hi³ ná¹hmá¹ né³, chau³² bíh¹ jmáɨ¹ hi³ lɨ́²jnia² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","La³jɨ́³² hi³ juo³ jná¹³ hnoh² ta³ hñu³ niéi², ma³jnia¹³ náh² jáɨ¹³ jáun² ta³ jma²; hi³ lɨ³ua³ cáun² hi³ juah³² jná¹³ ñí¹con² hnoh² ñí¹ ná¹conh¹ né³, cuá²tɨ́¹ cuá²hoh³ náh² ca³la³ tɨ³ tsáɨh³ hñú³ hi³ cháh¹³ náh² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ha³ lɨ́² juenh³ náh² tsá² jngɨh² jmáh³la³ ngú³, hi³ má¹lɨ³² jáun² né³, tiá² tɨn² yáh³ tsú² jngɨh³ jmɨ́²chí³ quián¹³ náh²; tɨ³ re² juenh³ náh² ñí¹con² Tsá² lɨ́¹³ jngah³ náh², hi³ má¹lɨ³² jáun² né³ lɨ́¹³ zen³ tsú² jmɨ́²chí³ quián¹³ náh² quiu³juóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","”¿Há¹ tiá² cuen² tsú² gon³ tan³² pih²¹ la³ cun³ cá² héih³² quɨe³ dúh¹? Tɨ³la³ cun³ jáun² hí¹ jan² yáh³ jáh³ pih²¹ la³ hí³ tiá² jún²³ tá¹la³ tiá² má²lɨ́²cué³² Ñeh² náh² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hi³ hí¹ ca³la³ tɨ³ jñú² chinh³² yáh³ hnoh² ná¹hɨ¹³ siáh³ ma³ quin³² ma³ cá² máɨh³². ");
INSERT INTO csoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jáun² né³, ha³ lɨ́² juenh³ náh², quí¹ tɨ³ jlánh¹ bíh¹ quien² hnoh² la³ cónh³ bíh¹ tan³² ná¹juóun²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”Hi³ jáun² né³, la³jɨ́n³² tsá² má²quien² jná¹³ ñí¹ ta³ ñí¹ tsáu², ja³bí¹ jná¹³ siáh³ má¹quien¹³ tsá² la³ hí³ ñí¹ ta³ ñí¹ Ñuh³² ná¹, Tsá² cuá³ hñu³mɨ³cuú²; ");
INSERT INTO csoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","tɨ³la³ lɨ³ua³ jan² tsá² tiá² hnió³ má²quien² jná¹³ ñí¹con² tsáu² né³, ja³bí¹ jná¹³ siáh³ tiá² má¹quien¹³ tsá² la³ hí³ ñí¹con² Ñuh³² Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","”Su³uú² lɨ́¹ cuɨ́¹ lɨ́n¹³ hnoh² hi³ jná¹³ ja³jmú³² hi³ niau²¹ tie³ ñí¹ hué²¹ lá²; quí¹ jun³juáh¹³ hi³ ja³chá³ jná¹³ tie³ yáh³, tɨ³la³ jná¹³ dá² ja³ hi³ chá¹³ ná¹ hniéi² quɨ³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ja³ jná¹³ hi³ ja³jmú³² hi³ tsá²ñuh² ná¹háun³ quionh³ jméi², tsá²mɨ³ ná¹háun³ quionh³ mí¹ziú¹³, hi³ ló³² tsú² ná¹háun³ siáh³ quionh³ mɨ³ziú¹³; ");
INSERT INTO csoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","jáun² la³ jáun² bíh¹ lɨ́¹³ hi³ ma³ quin³² ma³ jan³² tsú² ná¹hniei²¹ quionh³ má²tún² tsá² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","”Nɨ́¹juáh³ tsá² ja³²lɨ³ hnio³ jméi² jɨ³ mí¹ziú¹³ cha³ jmɨ́¹ ma³hniau³ tsú² jná¹³, tsá² la³ hí³ tiá² ca³tɨn¹ hen² tɨ³ con² jná¹³. Hi³ nɨ́¹juáh³ tsá² ja³²lɨ³ hnio³ tsá²mɨ³ tsá²ñuh² jon² cha³ jmɨ́¹ ma³hniau³ tsú² jná¹³, tsá² la³ hí³ siáh³ tiá² ca³tɨn¹ yáh³ hen² tɨ³ con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ja³bí¹ tiá² lɨ́¹³ han³ tsú² tɨ³ con² jná¹³ nɨ́¹juáh³ tsá² tiá² hnió³ cán³ crei²¹ hi³ ma³zian² tsú² la³jmɨ́¹ zian² jná¹³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nɨ́¹juáh³ tsá² hnió³ liáu³ jmɨ́²chí³ quioh²¹, tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tsa³hín³ jmɨ́²chí³ quioh²¹ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ né³, tsá² la³ hí³ bíh¹ tɨ³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Lɨ³ua³ jan² tsá² he³ hnoh², ja³bí¹ má²lɨ́²he³ jɨ³ jná¹³ bíh¹ tsú² jaun³²; hi³ lɨ³ua³ jan² tsá² ca³he³ jná¹³ né³, ja³bí¹ la³ jáun² má²lɨ́²hen³ tsú² la³ jɨ³ Tsá² ca³ze³ bí¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Lɨ³ua³ jan² tsá² hen² jan² *tɨ³² jë¹ Dió³² quí¹ cun³ñí¹ hi³ ja³ tsú² hi³ ja³hléh² jë¹ Dió³², ja³bí¹ tsá² hí³ hiáuh¹³ la³ cun³ hi³ hiáuh³ jan² tɨ³² jë¹ Dió³²; hi³ nɨ́¹juáh³ tsá² hen² jan² tsá² zian² la³ cun³ hi³ tɨ³² tsɨ́³ Dió³² cun³ñí¹ hi³ zian² tsú² la³ jáun², ja³bí¹ hí³ dí² hiáuh³ la³ cun³ hi³ hiáuh¹³ tsá² zian² hí³ la³ cun³ hi³ tɨ³² tsɨ́³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Lɨ³ua³ jan² tsá² cué³² uá¹jinh¹ cáun² vaso jmɨ́² jma³ cuóuh³ ñí¹con² lɨ³ua³ jan² tsá² haɨn²¹ tɨ³ con² jná¹³, uá¹jinh¹ jan² tsá² tsɨ́¹juɨ́³, tɨ³la³ cun³ñí¹ hi³ hen² tsú² tɨ³ con² jná¹³ bíh¹, ja³bí¹ tsá² hí³ uá²jaɨ³² hiáuh³ cáun² hi³ chu²¹ la³ cun³ hi³ ca³tɨn¹ hiáuh³. ");
INSERT INTO csoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jmɨ́¹ cá¹tsan³ jáɨ¹³ hi³ ca³záɨh³ jáun² Jesús tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con² né³, cua³han³ ñí¹ jáun² hi³ ca³ñí¹hɨeh¹ dí² tsá² tiáunh¹ juú² la³ cu³ la³ jéin³ jáun², hi³ ca³ñí¹hléh² jú¹ chú³². ");
INSERT INTO csoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tá¹la³ jmɨ́¹ cuá¹hún¹ jáun² Juan² tsá² ziau² hí³ jmáɨ² hñu³mí¹ñí² ca³lɨ³ ñi³² la³ cun³ hi³ jmu² Cristo. Jáun² ca³zen³ dí² gon³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ tsa³jɨen³ Jesús, ");
INSERT INTO csoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","hi³ tsa³ngáɨ³ tsú² la³ lá²: ―¿Hí¹ hnú² uá¹ Tsá² ca³tɨn¹ já³², ho³ hniáuh³² uá¹ jan¹³ jnoh¹ jan² tsá² siánh³? ");
INSERT INTO csoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jáun² Jesús ca³ngáɨ³: ―Cuá²tánh¹ náh², cuá²zéih³ náh² Juan² la³ cun³ hi³ ná¹jɨ́eh³² náh² jɨ³ hi³ ná¹naɨh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Cuá²zéih³ náh² tsú² hi³ tsá² ten³ má²jniá³ ñí¹, tsá² hma² má²ñi³táunh¹, hi³ má²laɨn³² siáh³ tsá² jmɨ́¹ ná¹lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³, hi³ tsá² jmɨ́¹ te³ cuá¹ né³ má²náɨ³² bíh¹, má²ca³jenh¹³ bíh¹ tsá² jmɨ́¹ má²ná¹jún¹, hi³ tsá² tia³mii² né³, má²ná¹náɨ³² bíh¹ jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Jlánh¹ jmɨ́¹ ren² tsá² tiá² lɨ́¹ cha³² hliáun³ ñéih³ tsɨ́³ hi³ ca³tɨn¹ jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jmɨ́¹ já¹tanh²¹ jáun² tsá² hí³ ca³ma³liáu³² Jesús hleh³² ñí¹con² tsá² tionh² hí³ la³ cu³ la³ jéin³ ñí¹ zenh¹ hi³ ca³tɨn¹ Juan² tsá² ziau² hí³ jmáɨ², hi³ juáh³ la³ lá²: ―¿He³ dá² jaun³² ca³ñí¹jɨeh¹³ hnoh² ñí¹ lɨ́³ hué³² quiéin²? ¿Hí¹ ca³ñí¹jɨeh¹³ hnoh² cáun² hmá² tá² náɨ² hi³ lɨ́¹ quí² lɨ́¹ jɨ́eh²³ cun³quionh³ chí³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Hi³ nɨ́¹juáh³ tiá² la³ jáun² né³, ¿he³ bíh¹ ca³ñí¹jɨeh¹³ náh²? ¿Hí¹ ca³ñí¹jɨen¹ náh² jan² tsá²ñuh² quih³² hmɨh³² jlánh¹ bí¹ huá¹? Sá¹nɨ́² dú¹ jɨe³ náh², tsá² ná¹quih³² hmɨh³² hi³ jlánh¹ bí¹ huá¹ tionh² re² tɨn² ñéih³ hñú¹³ tsá² ná¹lɨ́n³ re²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Hi³ jáun² né³, ¿he³ bíh¹ ca³ñí¹jɨeh¹³ náh²? ¿Hí¹ ca³ñí¹jɨen¹ náh² jan² *tɨ³² jë¹ Dió³²? Quí¹ tson² bíh¹ cu³tí³, tɨ³la³ tsá² hí³ má¹ná¹, tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ lɨ³ua³ jan² tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹ja³² jáɨ¹³ hi³ ca³tɨn¹ Juan² tsá² ziau² hí³ jmáɨ², hi³ juáh³ la³ lá²: Sá¹nɨ́² jɨe³, jná¹³ zein²¹ jan² tsá² tsa³can³² jáɨ¹³ ta³ tin² la³ cun³ bíh¹ hnú², tsá² hí³ bíh¹ jmu³ hua³jan²¹ juɨ³² ñí¹ cuóh¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jmɨ́¹ má²lɨ́²chá³² Jesús jáɨ¹³ nɨ́² né³, ca³záɨh³ siáh³ tsá² hí³ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ tiá² hin² zian² hí¹ jan² yáh³ tsá² jlánh¹ bíh¹ quien² ja¹ la³jɨ́n³² tsá² ca³lɨ³zian² ñí¹ hué²¹ lá² la³ cónh³ bíh¹ Juan² tsá² ziau² hí³ jmáɨ²; tɨ³la³ cun³ jáun² tsá² tiá² lin¹ ñí¹ quien² ja¹ quioh²¹ tsá² má²tionh² jo³cuo² Dió³², tsá² la³ hí³ bíh¹ tɨ³ jlánh¹ quien² la³ cónh³ bíh¹ Juan². ");
INSERT INTO csoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","”Hi³ jáun² ca³la³ cun³ jmɨ́¹ cuan¹ Juan² tsá² ziau² hí³ jmáɨ² hi³ la³ tɨ³ ta³né³², héih³² quioh²¹ Dió³² cáun² cuá²zá² cuá²tsó³ bíh¹ ja¹ hniéi² hi³ tɨ³ lɨ³mí¹ tsá²lɨ³quien², hi³ tsá² jlánh¹ ná¹cueh³² pí³ né³, má²ná¹cah²³ bíh¹ jmáɨ¹ hi³ lɨ́¹³ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jmɨ́¹ tɨ́² quien² bíh¹ la³jɨ́³² hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ tsá² lɨn³ hí³ tɨ³² jë¹ Dió³², jɨ³ liei²¹ quioh²¹ hla¹ Moisés siáh³, ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ cuan³ Juan² tsá² ziau² hí³ jmáɨ²; ");
INSERT INTO csoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","jáun² Juan² hí³ bíh¹ lɨ́n³ Líh³, tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³², tsá² ca³tɨn¹ hi³ já³² nɨ́¹juáh³ hi³ hnáuh² hnoh² táunh¹³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nɨ́¹juáh³ tsá² tsɨ²¹ cuá¹, cuɨ́¹ nie¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”¿He³ ñí¹ tsáu² lɨ́¹³ cunh²¹ jná¹³ quionh³ tsá² zian² jmáɨ¹ hi³ ziáun² dí² lá²? Lɨ́¹³ juáh¹³ la³ lá²: Jmu² tsú² la³jmɨ́¹ jmu² tsá¹míh¹ ñi³co¹ ja¹ hmah²¹. Ná¹hóh³² tsú² hi³ jéinh³² hlah³, hi³ zaɨh³² raɨnh²¹ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Sa³ tiá² ca³lɨ³ hnáuh² yáh³ hnoh² tsan¹³ jmɨ́¹ lɨ́¹jiéi¹³ jnoh¹ jáun² hmá² tá² le²; hi³ sa³jun³ lɨ́²uoh³ yáh³ hnoh² jmɨ́¹ lɨ́¹jmú¹³ jnoh¹ siáh³ sun¹ ca³tɨ²¹ jmáɨ¹ hi³ nio² hlah³ tsɨ́³ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juanh³² jná¹³ la³ nɨ́², quí¹ cuan³ Juan² tsá² tiá² cú² tiá² hɨ́nh²³, hi³ jáun² tsáu² né³ juáh³: “Tsá² hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ bíh¹ hí³”. ");
INSERT INTO csoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jáun² né³, cuan³ siáh³ jná¹³ Jon² tsá²mɨ³cuóun², tsá² cú² tsá² aɨh³² ná¹, tɨ³la³ má¹lɨ³² jáun² né³ juáh²³ siáh³ tsáu²: “¡Tsá² jlién³ bíh¹ nɨ³², hi³ hɨ́nh²³ siáh³ jmáɨ², tsá² juónh²³ re² quionh³ tsá² ren² tso³ jɨ³ *tsá² chi² hmah²¹ nɨ́² siáh³!” Tɨ³la³ cun³quionh³ la³jɨ́³² hi³ ná¹lɨ́²³ bíh¹ lɨ́² lin¹ hi³ Dió³² jan² Tsá² quia³lín³ jmɨ́¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jmɨ́¹jáun² ca³ma³liáu³² Jesús jí²³ hi³ ca³tɨn¹ tsá² juú² ñí¹ má²ca³jmú³ tsú² hliáun³ hua³jueh³², quí¹ cun³ñí¹ hi³ tsá² hí³ tiá² má²ca³za³ yáh³ jmɨ́¹ tsɨ́³. Hi³ ca³juáh³: ");
INSERT INTO csoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Jlánh¹ juon²³ hnoh² tsá² juú² Corazín! ¡Jlánh¹ juon²³ siáh³ hnoh² tsá² juú² Betsaida! Quí¹ sá¹jmɨ́¹ hi³ ca³lɨ³ la³jɨ́³² hua³jueh³² já¹ tsá² jmɨ́¹ zian² juú² Tiro jɨ³ juú² Sidón dúh¹, la³jmɨ́¹ má²lɨ³² nɨ́² ja¹ quián¹³ hnoh², hi³ jáun² má²hia³ jáun¹³ máh³ jmɨ́¹ má²ca³za³ tsú² jmɨ́¹ tsɨ́³, hi³ jmɨ́¹ má²ca³jmú³ tsú² lin¹ cun³quionh³ hi³ jmɨ́¹ quɨ́h²¹ tsú² jáun² tú²cho¹, jɨ³ hi³ jmɨ́¹ sén²¹ tsú² siáh³ juá² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Hi³ jáun² tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ hi³ má¹tsoh¹ hnoh² honh² má¹tɨ³ ñí¹ ra³tsɨ³² Dió³² héih³², la³ cónh³ bíh¹ tsá² jmɨ́¹ zian² jáun² jmɨ́¹tin² já¹ juú² Tiro quionh³ juú² Sidón. ");
INSERT INTO csoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hi³ hnoh² siáh³ tsá² juú² Capernaum, ¿hí¹ ná¹lɨ́n²³ hnoh² hi³ cuá¹tánh¹ náh² hñu³mɨ³cuú²? Hnoh² dá² cuá¹tánh¹ la³ tɨ³ quiu³juóu³² bíh¹. Quí¹ sá¹jmɨ́¹ hi³ ca³lɨ³ hua³jueh³² la³ nɨ́² já¹ juú² Sodoma jmɨ́¹tin² la³jmɨ́¹ lɨ²¹ nɨ́² ja¹ quián¹³ hnoh², hi³ jáun² jmɨ́¹ nio² bíh¹ juú² jáun² la³ tɨ³ ta³né³² dúh¹ sá¹jmɨ́¹ hi³ lɨ³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Hi³ jáun² jná¹³ né³ juanh³², hi³ tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ hi³ má¹tsoh¹ hnoh² honh² jmáɨ¹ hi³ ra³tsɨ³² Dió³² héih³² la³ cónh³ bíh¹ tsá² jmɨ́¹ zian² jáun² juú² Sodoma jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jmáɨ¹ jáun² ca³juáh³ Jesús la³ lá²: ―Hnú² Tia²¹, Tsá² lɨ́n³ nú² Juo¹³ tsá² zian² hñu³mɨ³cuú² jɨ³ tsá² zian² ñí¹ hué²¹ lá² nɨ́² siáh³, cué²³ jná¹³ tiá¹hmah¹ quí¹hliá² ca³hmáh¹ hnú² jú¹ tson² hi³ jáun² tiá² lɨ́¹³ há¹ ngɨ¹³ tsá² quia³lín³ jmɨ́¹ tsɨ́³, jɨ³ tsá² ñí² tsá² lieih²¹ nɨ́² siáh³; tɨ³la³ ñí¹con² tsá² tsɨ́¹ tsá² juɨ́³ bíh¹ ca³niah²¹ hnú² jú¹ tson² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ján³, quí¹ la³ jáun² jlánh¹ re² tɨ́³ honh² hnú² Tia²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","”Sá¹nɨ́² jɨe³ náh², jo³uón³² jná¹³ má²ca³chá³ Ñuh³² jná¹³ ca³la³ jɨ³lɨ³². Hnga² bíh¹ Dió³² cuóun³² re² Jon², hi³ hnga² bíh¹ siáh³ Jon² Dió³² cuóun³² re² Jméi²; hi³ lɨ³ua³ jan² tsá² hnió³ dí² ma³jnia² Jméi² ñí¹con² siáh³, lɨ³ cuóun³² bíh¹ tsú² Jméi² dí². ");
INSERT INTO csoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ñá²táunh¹ náh² ñí¹con² jná¹³, la³jɨ́n³² náh² tsá² má²cá²huon³ náh² hi³ ná¹jmuh³² náh² ta²¹ jɨ³ hi³ ná¹quiánh¹ náh² lio²¹, hi³ jáun² jná¹³ chau²¹ tie³. ");
INSERT INTO csoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Hen³ náh² hi³ ñí¹táunh¹ náh² ná¹cunh² quiúnh¹ jná¹³ la³jmɨ́¹ ñi³táunh¹ cuá¹juɨ́² quiáh² hué³², hi³ jáun² cuɨ́¹ lɨ³ tɨn² náh² la³ cun³ hi³ tɨn² jná¹³, quí¹ jná¹³ jan² tsá² juenh² tsɨ́³ bíh¹, jan² tsá² tiá² jmu² quien² hnga², hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ niau²¹ tie³ jmɨ́¹ honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Quí¹ la³ cun³ ta²¹ hi³ jmúh¹³ náh² ta³ ná¹cunh² náh² quiúnh¹ jná¹³ lɨ́³ cáun² ta²¹ huá¹ bíh¹, hi³ sa³jun³ héi² yáh³ lio²¹ hi³ cué¹³ jná¹³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jmɨ́¹jáun² né³ jmɨ́¹ cuá¹ngɨ³² Jesús ja¹ ñí¹ zia³² hi³ jná¹ quioh²¹ tsáu² cáun² *jmáɨ¹ nio² tie³. Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³lɨ³ ñí¹cuóunh²¹, hi³ jáun² ca³ma³liáu³² tsú² hi³ caɨ³² chí² hieh² cuú²miih²¹ hi³ jná¹ ñí¹ jáun², hi³ jáun² hí¹cúh² dí² máɨ³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jmɨ́¹ ca³jɨ́e³ tsá² *fariseos hi³ jáun² né³, jáun² ca³záɨh³ tsú² Jesús la³ lá²: ―Sá¹nɨ́² jɨe³, tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² jmu² ta²¹ hi³ tiá² ca³tɨ²¹ jmu³ tsú² jmáɨ¹ nio² tie³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tɨ³la³ hí³ má¹ná¹, ca³juáh³: ―¿Tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³², ñí¹ rá¹juáh³ hi³ he³ ca³jmú³ hla¹ re²¹ Dá²vi²¹ cu³ jéin³² jmɨ́¹ lɨ²¹ ñí¹cuóunh²¹ quionh³ tsá² quionh³? ");
INSERT INTO csoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Tsá² hí³ dá² ca³ñí¹hi³² ñéih³ hñu³ cuáh³² lɨ́³ hmɨh³² hi³ ca³ñí¹cúh² *hí³ cuú²miih²¹ hɨ́en¹ quionh³ tsá² quionh³, cáun² hi³ tiá² jmɨ́¹ ca³tɨn¹ cuh³, quí¹ hí³ jáun² dá² jmɨ́¹ ná¹chan¹ hi³ cuh³ jmáh³la³ tsá² ná¹lɨ́n³ mí²tsáu² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ho³ ¿tiá¹ má²ca³híh³ hnoh² liei²¹ quioh²¹ hla¹ Moisés ñí¹ rá¹juáh³ hi³ mí²tsáu² tsá² jmu² ta²¹ hñu³ cuáh³² chín¹ tiá² tianh³² yáh³ tie³ nɨ́¹juáh³ jmáɨ¹ nio² tie³, tɨ³la³ cun³ jáun² tiá² tso³ yáh³ hi³ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tɨ³la³ jná¹³ juanh³² hi³ ñí¹ lá² zia³² cáun² hi³ tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ cuáh³² chín¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tiá² la³ má²ca³ngɨ¹³ máh³ hnoh² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí² quioh²¹ Dió³², hi³ juáh³ jáun² la³ lá²: “Jná¹³ dá² hnó³² hi³ já³² mií³ honh² bíh¹ hnoh², jun³juáh¹³ hi³ jngɨh¹³ náh² jáh³ ñí¹con² jná¹³ yáh³”. Sá¹jmɨ́¹ hi³ má²ca³ngɨ¹³ náh² jáɨ¹³ nɨ́² dúh¹, jáun² tiá² cáun² lɨ́¹ jmɨ́¹ cueh¹ yáh³ náh² tso³ tsá² tiá² hi³ lɨ́²jmú³ hí¹ cáun². ");
INSERT INTO csoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quí¹ uá¹ hi³ jmáɨ¹ nio² tie³, cun³ jáun² cáun² ho² bíh¹ Jon² tsá²mɨ³cuóun² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jmɨ́¹jáun² cua³han³ Jesús ñí¹ jáun², hi³ jáun² ca³ñí¹hi³² hñu³ cuáh³² quioh²¹ tsá² *judíos zeh² já¹ juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ñí¹ jáun² jmɨ́¹ cuá³ jan² tsá²ñuh² jmɨ́¹ má²ca³náɨ³ cáun² cuo²; tɨ³la³ tsá² tionh² ñí¹ jáun² má¹ná¹, jmɨ́¹ hnió³ choh¹³ ha³ lánh³ rón³² lɨ́¹³ chá³² dí² tsáu¹³ tsú², hi³ jáun² ca³ngáɨh³ dí²: ―¿Hí¹ lɨ́¹³ jmah³ tsú² jan² tsá² tsáun¹ nɨ́¹juáh³ jmáɨ¹ nio² tie³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jáun² Jesús ca³ngáɨ³ ñí¹con² tsá² hí³: ―¿Hin² dá² lɨ³ua³ jan² hnoh², nɨ́¹juáh³ hi³ ca³tánh³ jan² *já¹ziáh² joh² náh² cáun² ñí¹ hlah³, há¹ tiá² cuá¹chin³² náh² jáh³ hí³ joh² uá¹jinh¹ jmáɨ¹ nio² tie³? ");
INSERT INTO csoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tɨ³la³ ¡tɨ³ jlánh¹ bíh¹ quien² jan² tsáu² la³ cónh³ bíh¹ jan² já¹ziáh²! Jáun² né³, zia³² bíh¹ jáɨ¹³ hi³ jmu³ tsú² hi³ chu²¹ jmáɨ¹ nio² tie³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jmɨ́¹jáun² ca³záɨh³ dí² tsá² lɨ́³ hí³ cuo² la³ lá²: ―Ñéih¹ cuonh². Jmɨ́¹ jáun² ca³ñeh³ tsá² hí³ cuo², hi³ jáun² la³ bíh¹ la³ cun³ rón³² lɨ́³ cuá² cáun². ");
INSERT INTO csoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jmɨ́¹jáun² ca³huén² tsá² fariseos tɨ³ cheih³², hi³ ca³juu³ ca³hlénh³ ha³ lánh³ rón³² lɨ́¹³ jngɨh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jmɨ́¹ ca³lɨ³ ñi³² Jesús jáɨ¹³ jáun² né³, cua³han³ bíh¹ cú²jueh³² ñí¹ jáun²; jmɨ́¹jáun² ja³taunh²¹ juóun³² lɨ́n³² tsáu² cu³hna²¹ tsú². Jesús ca³jmah³ la³jɨ́n³² tsá² jmɨ́¹ ná¹tsáun¹, ");
INSERT INTO csoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","hi³ jáun² jmu² dí² héih³² hi³ hí¹ jan² tiá² hin² záɨh³² tsáu² hi³ hin² tsánh² hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","La³ nɨ́² lɨ³, hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ Isaías *tɨ³² jë¹ Dió³², jmɨ́¹ ca³juáh³ jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Tsá² lá² bíh¹ Tsá² lɨ́n³ quian²¹ jná¹³, Tsá² má²cá²quiánh³² jná¹³, Tsá² jlánh¹ hno³ jná¹³ jɨ³ hi³ jlánh¹ tsah¹ jná¹³ hi³ ca³tɨn¹ tsú². Cuen²¹ jná¹³ Jmɨ́²chí³ joh² ñí¹con² tsú², jáun² ngáɨ³² tsú² ñí¹con² tsá² zian² tá¹ cáun² hngá¹máh³ jáɨ¹³ he³ lánh³ rón³² rá¹tsɨ³² jná¹³ héih³². ");
INSERT INTO csoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tiá² hniéi² jmu³ yáh³ tsú², sa³jun³ tɨ³ hóh³² tsú², hi³ hí¹ jan² yáh³ tiá² hin² ne³ hi³ jmu² tsú² tiá³ siaun³² ja¹ hñú³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hí¹juáh³ cáun² hmá² tá² má²ca³jñáh³ yáh³ tiá² jau³ tsú², sa³jun³ ye³ tsú² cáun² sɨ́² jmɨ́²cau³² pih²¹ hi³ tion³ chí¹hún¹, ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ jmu³ tsú² hi³ jú¹ tson² cah¹³ jmáɨ¹ la³ tán¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hi³ jáun² tsá² zian² tá¹ cáun² hngá¹máh³ ha³ tsɨ́³ ñí¹con² Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jmɨ́¹jáun² ca³ñí¹jan² tsú² ñí¹con² Jesús jan² tsá²ñuh² ten³ jɨ³ hi³ tiá² hleh³² siáh³, hi³ jmɨ́¹ hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. Jáun² Jesús ca³jmah³ tsá² hí³, hi³ jáun² tsá²ñuh² hí³ ca³jnia³ ñí¹ jɨ³ hi³ ca³lɨ³ siáh³ hléh³². ");
INSERT INTO csoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jáun² la³jɨ́n³² tsáu² ca³ja³cáun² tsɨ́³, hi³ jáun² ca³juáh³: ―¿Hí¹ hí³ dá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹ tsá² nɨ́² juáh¹³, tsá² qui³ ná¹jan²³ dí² hí³? ");
INSERT INTO csoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tɨ³la³ jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² fariseos jáɨ¹³ jáun² né³, ca³juáh³ la³ lá²: ―Tsá²ñuh² nɨ́² dá² huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² cun³quionh³ pí³ quioh²¹ Beelzebú tsá² hláɨnh¹ tsá² chín¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tɨ³la³ Jesús jmɨ́¹ dí¹ñi³² bíh¹ ha³ lánh³ jmɨ́¹ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Nɨ́¹juáh³ zia³² hniéi² ja¹ cu³ nió³ má²tún² hmóu³² tsá² ná¹lɨ́n³ ta²¹, jáun² la³jɨ́n³² bíh¹ tsú² tsa³hín³; ja³bí¹ la³ jáun² nɨ́¹juáh³ cáun² juú², ho³lá²dá² tsá² má²tún² cáun² hñú³ ñí¹ tionh¹ lɨ́³ ná¹tsoh³ ja¹ má²tún² hmóu³² hi³ ná¹quiú² ná¹tɨ́n²³, ha³ tiá² lɨ³ uén³ yáh³ tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jáun² ja³bí¹ la³ jáun² bíh¹ siáh³ lɨ́³ uá²jaɨ³² nɨ́¹juáh³ *Satanás la³ chin² cheih³² hnga², jáun² ñí¹con² hnga² bíh¹ tsú² má²jmu² hniéi²; jáun² né³ ¿ha³ ya³ lánh³ rón³² lɨ́¹³ ma³hɨ́e² pí³ quioh²¹ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hnoh² juánh³ náh² hi³ jná¹³ huen² ná¹ jmɨ́²chí³ hláɨnh¹ cun³quionh³ pí³ quioh²¹ Beelzebú; jáun² nɨ́¹juáh³ la³ nɨ́² né³, ¿hin² cun³quionh³ pí³ quioh²¹ huen² tsá² haɨn²¹ tɨ³ con² hnoh² jmɨ́²chí³ hláɨnh¹ tiáunh¹ hñu³ tsɨ́³ tsáu²? Hi³ jáun² né³, cun³quionh³ ta²¹ hi³ jmu² nɨ́² tsá² haɨn²¹ nɨ́² tɨ³ con² bí¹ náh² má²lɨ́²lin¹ hi³ lɨ́¹ ná¹tsá²con² bí¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tɨ³la³ jná¹³ má¹ná¹, huen² ná¹ jmɨ́²chí³ hláɨnh¹ cun³quionh³ Jmɨ́²chí³ joh¹ Dió³² bíh¹; hi³ jáun² la³ nɨ́² né³ má²lɨ́²lin¹ hi³ jná¹³ bíh¹ tsá² ca³hiáu³² Dió³² hi³ lɨ́n¹³ ná¹ Re²¹, Tsá² qui³ ná¹jan²³ hnoh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","”Né³² né³, ¿lánh³ bíh¹ rón³² lɨ́¹³ hí³ jan² tsáu² hñú¹³ jan² tsá² pin³ lɨ́n³² hi³ quin³ tsú² la³jɨ́³² hi³ nio² hñú¹³ tsú², nɨ́¹juáh³ tiá² la³ hñe³ yáh³ tsú² tín² tsá² hñú¹³ hí³? Quí¹ jɨ́³²la³ la³ jáun² bíh¹ lɨ́¹³ quin³ tsú² hi³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","”Hi³ jáun² né³, lɨ³ua³ jan² tsá² tiá² hen² tɨ³ con² jná¹³, tsá² la³ hí³ tiá² hún¹ yáh³ cá²hon³ quiúnh¹ jná¹³; hi³ lɨ³ua³ jan² tsá² tiá² cha³² cu³lɨ²¹ quiúnh¹ jná¹³, tsá² la³ hí³ tɨ³ toh² tiú² jóh³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","”Hi³ jáun² bíh¹ juanh³² jná¹³ hi³ zia³² bíh¹ uu³i³tso³ quioh²¹ la³jɨ́³² tso³ hi³ jmu² tsá²mɨ³cuóun², jɨ³ la³jɨ́³² jú¹ hlah³ hi³ hleh³² tsú² nɨ́² siáh³; tɨ³la³ nɨ́¹juáh³ tsá² tú² hión³² Jmɨ́²chí³ Chun¹ má¹ná¹, ha³ tiú²uú² uu³i³tso³ zia³² yáh³ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Lɨ³ua³ jan² tsá² tú² hiáu³² jná¹³ Jon² tsá²mɨ³cuóun², zia³² bíh¹ uu³i³tso³ quioh²¹ tsú²; tɨ³la³ nɨ́¹juáh³ tsá² ca³tu³ ca³hión³² Jmɨ́²chí³ Chun¹ né³, tiú²uú² uu³i³tso³ zia³² yáh³ quioh²¹ tsá² la³ hí³, sa³jun³ mɨ³cuú² lá² hi³ sa³jun³ mɨ³cuú² cáun². ");
INSERT INTO csoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Né³² né³, máɨ³ chu²¹ bíh¹ háɨ³² nɨ́¹juáh³ hmá² chu²¹; jáun² nɨ́¹juáh³ hmá² hlah³ né³, mɨ³ hlah³ bíh¹ háɨ³². Quí¹ cun³quionh³ máɨ³ hi³ háɨ³² bíh¹ hmá² lɨ́¹³ lɨ³ cuoh² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Hnoh² dá² jón²zɨ́h¹ jón²cho¹ jáh³ hláɨnh¹ bíh¹! ¿Ha³ bíh¹ lánh³ rón³² lɨ́¹³ hléh¹³ hnoh² jáɨ¹³ chu²¹ nɨ́¹juáh³ chín¹dí¹ hmóu³² bíh¹ hnoh² tiá² chun¹ náh²? Quí¹ lɨ³ua³ cáun² hi³ ná¹canh² hñu³ jmɨ́¹ hñu³ tsɨ́³ tsú², hi³ jáun² bíh¹ hue³² ho³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tsá² chun¹ hleh³² jú¹ chu²¹ quí¹hliá² hi³ chu²¹ zia³² hñu³ tsɨ́³; tɨ³la³ tsá² hláɨh¹ tsá² hon² má¹ná¹, hleh³² hi³ hlah³ quí¹hliá² hi³ jáun² bíh¹ zia³² hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hi³ jáun² jná¹³ juanh³² ñí¹con² hnoh² hi³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ ra³tsɨ³² Dió³² héih³², la³jɨ́n³² tsáu² bíh¹ tsa³jɨ́enh¹ jú¹ tson² quioh²¹ ca³tɨ²¹ la³jɨ́³² jáɨ¹³ tiá² tsú²ta²¹ hi³ má²lɨ́²tá² lɨ́²hí³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quí¹ la³ cun³ lɨ́³ jáɨ¹³ quián¹³ bíh¹ nú² tá¹tsɨn¹ nú² héih³², má¹jáun² lɨ³ lin¹ nɨ́¹juáh³ tá¹can¹ nú² tso³ ho³ tiá² tso³ hauh³² nú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jáun² né³, ma³ jan² tsá² fariseos quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ ca³juáh³ ñí¹con² Jesús la³ lá²: ―Tɨ³², hnáu² jnoh¹ neh²¹ hi³ jmúh¹³ hnú² cáun² li²¹ hi³ lɨ́³ hua³jueh³². ");
INSERT INTO csoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tɨ³la³ Jesús né³ ca³ngáɨ³: ―Tsá² hláɨh¹ hon², tsá² tiá² má²tí³² jë¹ mɨ³² cáun² li²¹ hi³ lɨ́³ hua³jueh³²; tɨ³la³ tiú²uú² li²¹ siáh³ hiáuh³ yáh³ tsú², jɨ́³²la³ li²¹ hi³ ca³jɨ́e³ jáun² tsáu² hi³ ca³tɨn¹ hla¹ Jonás bíh¹, tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Quí¹ la³jmɨ́¹ ca³hi³ jáun² hla¹ Jonás hnɨ³² jmáɨ¹ hnɨ³² nie³ hñu³ héin¹ jan² jáh³ jmáɨ² pan¹ lɨ́n²¹, ja³bí¹ la³ jáun² hniáuh³² tsa³hi³² siáh³ Jon² tsá²mɨ³cuóun² hnɨ³² jmáɨ¹ hnɨ³² nie³ hñu³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jáun² nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ cán³ Dió³² jú¹ tson² ñí¹con² la³jɨ́n³² tsáu², má¹jáun² nu³ tiánh³ tsá² jmɨ́¹ zian² juú² Nínive hi³ chá³² tso³ hi³ ca³tɨn¹ tsá² zian² né³², quí¹ hí³ dí² ca³ja³conh² bíh¹ tsɨ́³ tso³ quioh²¹ jmɨ́¹ ca³náɨ³² jáɨ¹³ quioh²¹ hla¹ Jonás. Ján³, chá³² tsá² hí³ tsáu¹³ tsá² zian² né³², quí¹ ñí¹ lá² zenh² jan² tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hla¹ Jonás hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ja³bí¹ hla¹ tsá²mɨ³ tsá² jmɨ́¹ chín¹ hué³² tɨ³ la³ quián³ nó³² nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ cán³ Dió³² jú¹ tson², hi³ jáun² tsá²mɨ³ hí³ chá³² tsáu¹³ tsá² zian² né³²; quí¹ hla¹ tsá²mɨ³ hí³ ja³ cáun² hué³² ñí¹ jlánh¹ bíh¹ uóunh³ hi³ cua³niéi³ jáɨ¹³ quioh²¹ hla¹ re²¹ Salomón tsá² jlánh¹ jmɨ́¹ quia³lín³ hí³ jmɨ́¹ tsɨ́³. Ján³, tsá²mɨ³ hí³ chá³² tsáu¹³ tsá² zian² né³², quí¹ ñí¹ lá² zenh² jan² tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hla¹ re²¹ Salomón hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","”Nɨ́¹juáh³ má¹cuá²han³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², jáun² tsá²ngɨ́² ñí¹ quiéin², hi³ tsá²hniauh² ñí¹ lɨ́¹³ cuá³² tie³; hi³ jáun² nɨ́¹juáh³ tiá² ca³choh¹³ né³, jáun² lɨ́n²³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Cuɨ́¹ ñih²¹ jná¹³ cú²jueh³² hñu³² ñí¹ cuá¹han³ ná¹”. Jáun² nɨ́¹ má¹cá²chánh³² tsú² jáun² né³, chanh²¹ tsú² tsá² hí³ hi³ má²lɨ́n³ la³jmɨ́¹ lɨ́³ cáun² hñú³ má²jáu², hi³ má²rá²hiah¹³ jɨ³ hi³ má²dí¹lɨ́³ re² tɨn² lɨ́n³² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Má¹jáun² tsau³² hi³ tsá²quian³ cónh³í¹ quiaun³ jmɨ́²chí³ hi³ tɨ³ jlánh¹ bíh¹ hláɨnh¹ la³ cónh³ bí¹ hnga², hi³ jáun² la³jɨ́n³² jáun² bíh¹ taunh³² hñu³ tsɨ́³ tsá² hí³, hi³ jáun² tɨ³ jlánh¹ bíh¹ hlaɨh³ má²lɨ́²³ quioh²¹ tsá² hí³ nɨ́¹ má¹lɨ³² jáun² la³ cónh³ bíh¹ jmɨ́¹tin². La³ nɨ́² bíh¹ lɨ́¹³ ñí¹con² tsá² hláɨh¹ tsá² hon² zian² jmáɨ¹ hi³ ziáun² dí² lá². ");
INSERT INTO csoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tá¹la³ dí¹liéinh³² jáun² tsá² hí³ bíh¹ Jesús, cuan³ mí¹ziú¹³ la³ má²quionh³ tsá¹ raɨnh²¹ dí². Jáun² ca³ta³tonh¹ tsú² cheih³² hi³ jmɨ́¹ hnió³ liéinh³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jmɨ́¹jáun² ca³juáh³ tsáu² ñí¹con² Jesús la³ lá²: ―Mí²ziúh² hnú² quionh³ tsá¹ renh² nú² tionh² cheih³² nɨ́² hi³ hnió³ liéih³² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jáun² Jesús ca³záɨh³ tsá² má²lɨ́²ngáɨ³² hí³ jáɨ¹³: ―¿Hin² dá² tsánh² hí³ mí²zia³² jná¹³ dúh¹, hi³ hin² dá² tsánh² hí³ renh² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jáun² né³ ca³hɨen³ dí² tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³ la³ lá²: ―Tsá² lá² bíh¹ ná¹lɨ́n³ mí²zia³² jná¹³ jɨ³ jon³ renh² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Quí¹ lɨ³ua³ jan² tsá² jmu² la³ cun³ hi³ hnió³ Ñuh³² jná¹³ Tsá² cuá³ hñu³mɨ³cuú², tsá² la³ hí³ bíh¹ lɨ́n³ tsá²mɨ³ tsá²ñuh² renh² jná¹³, jɨ³ mí²zia³² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jmáɨ¹ jáun² cua³han³ Jesús hñú³ jáun² hi³ ca³ñí¹cuá² can³² jmáɨ² lɨ́¹ ná¹ho³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tɨ³la³ juóun³² lɨ́n³² bíh¹ tsáu² ca³cuú² ca³ngɨh³² la³ cu³ la³ jéin³ ñí¹ cuá³ Jesús, hi³ jáun² ca³hi³ tsú² cú²jueh³² cáun² hñu³ mu², hi³ jáun² ca³cuá³ tsú² tɨ³ ñeh² jáun², hi³ jáun² la³jɨ́n³² tsá² hí³ ca³ta³tonh¹ can³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jmɨ́¹jáun² ca³ma³tɨn² dí² tsáu² hliáun³ ñí¹ lɨ́n²¹ jáɨ¹³ cun³quionh³ jáɨ¹³ hi³ jmu² dí², hi³ ca³juáh³ la³ lá²: ―Jmɨ́¹ zian² jan² tsá² ca³ñí¹suh³² jún² ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tá¹la³ jmɨ́¹ hí¹súh²³ tsú² jáun² jún² né³, la³ ca³súh³² ca³lá² hú¹ juɨ³², hi³ jáun² cua³taunh²¹ quiuh²¹ tan³² hi³ ca³cúh². ");
INSERT INTO csoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ lɨ́³ ja¹ quɨ́n¹, ñí¹ tiá² hliáun³ cuáh¹ jmɨ́¹ tón²¹; hi³ jáun² tia³juɨ³² lɨ́n³² bíh¹ ca³hiá² jún² jáun² quí¹ cun³ñí¹ hi³ tiá² hliáun³ cuáh¹ jmɨ́¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tɨ³la³ jmɨ́¹ cá¹chéi²¹ hiú² né³, ca³lɨ³ quiéin² bíh¹ quí¹ cun³ñí¹ hi³ tiá² ñí¹ ñe¹ jmɨ́¹ tioh³ chí² jmu² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ la³ hiau² ton², tia³juɨ³² lɨ́n³² bíh¹ ca³quí² cá²cuon³ ton² jáun², hi³ jáun² lɨ́¹ ca³juón³ bíh¹ jún² jáun² jmɨ́¹ ca³hiá². ");
INSERT INTO csoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Tɨ³la³ la³jɨ́³² jún² ñí¹ hná¹ jáun² né³ ca³súh³² ñí¹ chu²¹ hué³², hi³ jáun² re² lɨ́n³² bíh¹ ca³láu²; ma³ cá² máɨ³ jún² jáun² ca³cué³ ma³ hña³láu³ máɨ³, ma³ cá² máɨ³ ca³cué³ ma³ hnaɨh³² nio² quiú³ máɨ³, hi³ zia³² ma³ cá² máɨ³ né³, ca³cué³ ma³ quiu³quia³ máɨ³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nɨ́¹juáh³ tson² tsɨ²¹ cuáh³ náh², jáun² niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jmɨ́¹jáun² ca³ma³janh³² tsá² haɨn²¹ tɨ³ con² Jesús ñí¹ cuá³ jáun², hi³ ca³ngáɨh³ dí² la³ lá²: ―¿He³ lɨ³ sa³ cá² ñí¹ jmuh³² jáɨ¹³ bíh¹ hnú² nɨ́¹ má¹tɨ³ ñí¹ lienh¹ hnú² tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jáun² hí³ né³ ca³ngáɨ³ la³ lá²: ―Hnoh² bíh¹ tsá² ca³tɨn¹ náh² hi³ lɨ³ ñíh¹³ jáɨ¹³ hi³ jmɨ́¹ ná¹hmá¹ ná¹jnɨ́¹ hi³ ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³²; tɨ³la³ tsá² ñí¹ hná¹ nɨ́² né³, tiá² lɨ́¹³ yáh³ hi³ há¹ ngɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jáun² né³, nɨ́¹juáh³ tsá² zia³² quioh²¹, tɨ³ hiáuh³ bíh¹ tsú² hná¹ jáun²; hi³ jáun² lɨ³ zia³² hliáun³ quioh²¹ ca³la³ hi³ lɨ́¹ má²tú² má²ziáun²³. Tɨ³la³ nɨ́¹juáh³ tsá² tiá² zia³² quioh²¹ né³, tɨ³ quin³ bíh¹ la³ cun³ cú¹pih²¹ hi³ zia³² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Hi³ jáun² bíh¹ lienh¹ jná¹³ tsáu² cun³quionh³ jáɨ¹³ hi³ jmu² ná¹. Quí¹ tsá² nɨ́² dá² jɨ́e²³ bíh¹, hi³ má¹lɨ³² jáun² tá²tonh¹ la³jmɨ́¹ lɨ́³ tiá² hi³ lɨ́²jɨ́e³ bíh¹; náɨ³² bíh¹ tsú², tɨ³la³ tiá² ngɨ²³ yáh³, la³jmɨ́¹ lɨ́³ tiá² lɨ́²niéi³² bíh¹ tsú² lɨ́²³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","La³ cun³ hi³ ná¹lɨ́²³ ñí¹con² tsá² nɨ́² má²lɨ³tí²³ la³ cun³ hi³ ca³juáh³ hla¹ Isaías *tɨ³² jë¹ Dió³², jmɨ́¹ ca³juáh³ jáun² la³ lá²: Lɨ³ dá² náɨh¹ náh² re² lɨ́n³², tɨ³la³ tiá² ngɨ¹³ yáh³ náh²; Lɨ³ dá² jɨeh²¹ náh² siáh³, tɨ³la³ tiá² lɨ³tsɨn² yáh³ náh² he³ jaun³² ná¹jɨ́eh³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Cún¹tio¹ bíh¹ má²cá²jéinh³² tsɨ́³ tsá² lá², hi³ jáun² tiá² ngɨ¹³ tsú²; má²ca³jnɨ́³ bíh¹ tsú² cuá¹, hi³ jáun² tiú²uú² ne³; má²ca³jnɨ́³ bíh¹ tsú² siáh³ ñí¹, hi³ jáun² tiá² lɨ́¹³ jɨ́e³; Cónh³ tiá² jeinh³² bíh¹ tsú² jmɨ́¹ tsɨ́³ hi³ jmɨ́¹ lɨ³ jmah²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”Tɨ³la³ hi³ ca³tɨn¹ hnoh² má¹ná¹, jlánh¹ jmɨ́¹ ren² hnoh², quí¹hliá² jɨ́eh³² hnoh² cun³quionh³ mɨ́¹máh¹, jɨ³ hi³ naɨh³² hnoh² siáh³ cun³quionh³ cuáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Quí¹ jú¹ tson² juo³ jná¹³ hnoh², hi³ juóun³² tsá² ca³lɨn³ *tɨ³² jë¹ Dió³² jɨ³ tsá² jmɨ́¹ ná¹zian² la³ cun³ hi³ tɨ³² tsɨ́³ Dió³² nɨ́² siáh³ jmɨ́¹ hniá¹ jɨ́e³ la³ cun³ hi³ jɨ́eh³² hnoh² lá², tɨ³la³ tiá² ca³lɨ³ yáh³ jɨ́e³ tsú², hi³ jmɨ́¹ hniá¹ siáh³ ne³ la³ cun³ hi³ naɨh³² hnoh² la³, tɨ³la³ tiá² ca³lɨ³ yáh³ ne³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”Sá¹nɨ́² niéi² hnoh² he³ hnió³ juáh³ jáɨ¹³ hi³ má²lɨ́²jmú³² jná¹³ hi³ ca³tɨn¹ tsá² súh²³ jún². ");
INSERT INTO csoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nɨ́¹juáh³ tsá² náɨ³² jáɨ¹³ ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsú² jo³cuo² Dió³², hi³ nɨ́¹juáh³ tiá² ngɨ²³ yáh³ tsú² má¹lɨ³² jáun², jáun² tsá² la³ hí³ lɨ́n³ la³jmɨ́¹ lɨ́³ hú¹ juɨ³² ñí¹ ca³súh³² jáun² jún²; jáun² ja³² tsá² hláɨnh¹ hi³ quin²³ jú¹ chú³² hi³ má²jná¹ jáun² hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jáun² tsá² he² jáɨ¹³ tia³juɨ³² lɨ́n³² né³, hi³ ca³la³ hi³ hiún² lɨ́n³² tsɨ́³ jmu², tsá² la³ hí³ dá² lɨ́n³ la³jmɨ́¹ lɨ́³ ja¹ quɨ́n¹ ñí¹ cá¹súh²¹ jáun² jún²; tia³juɨ³² lɨ́n³² bíh¹ ca³hiá² jmɨ́¹ ca³hiá², ");
INSERT INTO csoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tɨ³la³ cun³ñí¹ hi³ tiá² hliáun³ chí² jmu² chá²³ yáh³, hi³ jáun² tiá² lɨ³ uén²³. Hi³ jáun² nɨ́¹ má¹ca³lɨ³ zia³² uu³mí²tsɨ³², ho³ zian² tsá² hnió³ jmoh³ hian² tsɨ́³, jáun² tɨ³ có³² bíh¹ nau³² tsú² cú²jueh³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ja³bí¹ zian² tsá² náɨ³² jáɨ¹³ quioh²¹ Dió³² lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² ñí¹ ca³hiau² ton² ñí¹ cá¹súh²¹ jáun² jún². Quí¹ cun³ñí¹ hi³ jlánh¹ lɨ́¹ quí² lɨ́¹ cha³² tsú² hliáun³ ñéih³ tsɨ́³ ca³tɨ²¹ hi³ zia³² ñí¹ hué²¹ lá², jɨ³ hi³ lɨ́¹ lɨ́²can² tsú² siáh³ hi³ lɨ́²hniá¹ hi³ lɨ³ zioh² hliáun³, hi³ jáun² tiú²uú² lɨ́²quien² yáh³ jáɨ¹³ quioh²¹ Dió³² hñu³ tsɨ́³ tsú², hi³ jáun² tiú²uú² hi³ lau³² yáh³ ñí¹con² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tɨ³la³ tsá² ngɨ²³ jáɨ¹³ quioh²¹ Dió³² má¹ca³náɨ³² né³, lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² chu²¹ ñí¹ cá¹súh²¹ jáun² jún², hi³ jáun² ca³láu² bíh¹ re². Ma³ jan² tsáu² lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ ma³ hña³láu³ máɨ³ máɨ³ la³ cun³ cá² máɨ³, ma³ jan² lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ ma³ hnaɨh³² nio² quiú³ máɨ³ máɨ³, hi³ ma³ jan² né³ lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ ma³ quiu³quia³ máɨ³ máɨ³ la³ cun³ cá² máɨ³ jún². ");
INSERT INTO csoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jmɨ́¹jáun² ca³jmú³ siáh³ Jesús cónh³í¹ cáun² jáɨ¹³ hi³ lɨ́³ la³ lá²: ―Jmáɨ¹ hi³ cán³ Dió³² jú¹ tson² quioh²¹ tsáu² lɨ́¹³ la³jmɨ́¹ lɨ²¹ jmáɨ¹ hi³ ca³jñí³ jan² tsá²ñuh² jún² chu²¹ hué³² quioh²¹, ");
INSERT INTO csoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","tɨ³la³ tá¹la³ má²ná¹cuóun¹ tsú² la³jɨ́n³² né³, ca³ñí¹hi³² jan² tsáu² ñí¹náɨ² jáun², tsá² hau² tsá² quioh²¹ ñí¹náɨ² jáun², hi³ ca³jñí³ náɨ² hlah³ ja¹ cuú²miih²¹, hi³ jáun² jmɨ́¹ lɨ²¹ jáun² ngah³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ca³cuon³ bíh¹ cuú²miih²¹ jmɨ́¹ cá¹cuon³, hi³ jáun² ca³hiá² mɨ́h³, ja³bí¹ la³ jáun² ca³cuon³ siáh³ náɨ² hlah³ ja¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jmɨ́¹jáun² né³, tsá² quian²¹ ca³ñí¹zeh¹ tsá² quioh²¹ ñí¹náɨ²: “Tɨ³², já² jún² chu²¹ bíh¹ ca³jñíh³ hnú² ñí¹náɨ² quián¹³, ¿ha³ yáh³ jinh¹ ja³ náɨ² hlah³ hi³ má²tsɨ²¹ ja¹ jáun²?” ");
INSERT INTO csoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jáun² tsá² quioh²¹ ñí¹náɨ² ca³juáh³: “Cun³ zian² tsá² hian² tsɨ́³ ca³jñí³ bíh¹ náɨ² hlah³ jáun²”. Jáun² tsá² quian²¹ hí³ ca³ngáɨ³: “¿Hnáuh¹ hnú² hi³ tsá¹cáɨ¹³ jnoh¹ náɨ² hlah³ jáun²?” ");
INSERT INTO csoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tɨ³la³ tsá² quioh²¹ ñí¹náɨ² ca³juáh³: “Tiá² jáun² yáh³, quí¹ nɨ́² lɨ́¹ ca³quiéih² yáh³ náh² cu³diá²jan² cuú²miih²¹ nɨ́¹ má¹ca³quiéih² náh² náɨ² hlah³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tɨ³ re² cáun² nɨ́² cuɨ́¹ cuóun² tín² cu³tsa³² ca³la³ tɨ³ ñí¹ ca³láu² máɨ³; má¹jáun² zein²¹ jná¹³ tsá² jmu² ta²¹ hi³ tsa³quiéi³ tín² náɨ² hlah³ jáun², hi³ jáun² hñe³ tsú² ma³ cá² tsu²¹, hi³ jáun² tsa³toh³ ja¹ sɨ́² hi³ có³², hi³ jáun² má¹lɨ³² jáun² né³ tiú³² tsú² cuú²miih²¹, jáun² caun¹³ tsú² hi³ tóh³² ñéih³ hñu³cuɨ́³ quion²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús ca³jmú³ siáh³ cáun² jáɨ¹³ lá²: ―Tsá² tónh³² jo³cuo² Dió³² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cá² máɨ³ jún² mostaza hi³ ca³jñí³ jan² tsáu² ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Máɨ³ jáun² bíh¹ máɨ³ hi³ jlánh¹ bíh¹ pih²¹ la³ cónh³ bíh¹ ñí¹ jɨ³lɨ³² jún²; tɨ³la³ nɨ́¹ má¹cá²cuon³ né³, lɨ́²³ cáun² náɨ² má²ró³² tɨ³ jlánh¹ bíh¹ pa²¹, hi³ lɨ́²tí³ la³ cun³ jmɨ́¹ tí³ cáun² hmá², hi³ hí¹ ca³la³ tɨ³ quiuh²¹ tan³² yáh³ ja³táunh¹ hi³ ná²tsɨ́³ za³ ja¹ chí² cuoh² hmá² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ja³bí¹ ca³jmú³ tsú² siáh³ cáun² jáɨ¹³ la³ lá²: ―Tsá² tónh³² jo³cuo² Dió³² lɨ́n¹³ la³jmɨ́¹ lɨ́³ tie³ hi³ ca³jan³ jan² tsá²mɨ³ quia³ hmá² juɨ²¹ cuú²miih²¹, hi³ jáun² tá¹ cá² pɨenh¹ bíh¹ cán¹ cáu³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jáun² né³, Jesús ca³ma³tɨn² tsáu² jmáh³la³ cun³quionh³ jáɨ¹³ hi³ jmu², hí¹ cáun² yáh³ tiá² hi³ jmɨ́¹ zaɨh³² tsú² tsáu² ta³ tiá² quionh³ cáun² jáɨ¹³ hi³ jmu² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","La³jɨ́³² hi³ nɨ́² ca³lɨ³, hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ tɨ³² jë¹ Dió³² jmɨ́¹ ca³juáh³ jáun² la³ lá²: Cun³quionh³ hi³ jmu¹ jáɨ¹³ bíh¹ jná¹³ hléh¹³ nɨ́¹ má¹tɨ³ ñí¹ hléh¹³; juo¹³ jná¹³ tsáu² la³jɨ́³² la³ cun³ hi³ jmɨ́¹ ná¹hmá¹ ca³la³ cun³ jmɨ́¹tin², jmɨ́¹ ca³jmú³ Dió³² hngá¹máh³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jmɨ́¹ lɨ²¹ jáun² ca³hah² Jesús jáɨ¹³ ñí¹con² tsá² hí³, hi³ jáun² ngau³ siáh³ ñéih³, hi³ jáun² ñí¹ jáun² ja³taunh²¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ ca³ñí¹zeh¹ dí² la³ lá²: ―Jmu³ tiá³ na²¹ ñí¹con² jnoh¹ jáɨ¹³ hi³ ca³tɨn¹ náɨ² hlah³ hi³ hia³² jáun² ñí¹náɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jná¹³ Jon² tsá²mɨ³cuóun² bíh¹ lɨ́n³ tsá² jñi³² jún² chu²¹ jáun², ");
INSERT INTO csoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","hngá¹máh³ lá² bíh¹ dá² jaun³² niéih¹ jáɨ¹³ hi³ lɨ́³ ñí¹náɨ². Tsá² tionh² jo³cuo² Dió³² bíh¹ hí³ hi³ niéih¹ jáɨ¹³ jún² chu²¹, náɨ² hlah³ jáun² né³ niéih¹ jáɨ¹³ tsá² joh¹ tsá² hláɨnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hi³ jáun² tsá² hian² tsɨ́³ hi³ ca³jñí³ náɨ² hlah³ jáun² né³, hnga² bíh¹ tsá² hláɨnh¹ hí³. Jmáɨ¹ hi³ ló³² jáun² máɨ³ né³ niéih¹ jáɨ¹³ jmáɨ¹ hi³ tsa³hín³ hngá¹máh³ lá² bíh¹, hi³ jáun² tsá² caun¹³ máɨ³ hi³ ló³² jáun² né³, tsá²cuú² tsá²ta³ Dió³² bíh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jáun² la³jmɨ́¹ caun² tsú² náɨ² hlah³ jáun² hi³ tóh³² ja¹ sɨ́² hi³ jáun² có³², la³ jáun² bíh¹ lɨ́¹³ nɨ́¹ má¹tɨ³ ñí¹ tsa³hín³ hngá¹máh³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jná¹³ Jon² tsá²mɨ³cuóun² zein²¹ ná¹ tsá²cuú² tsá²tán² tá¹ cáun² ñí¹ hu²¹ uón³² ná¹ hi³ quianh³ la³jɨ́n³² tsá² jmu² hi³ tsá² siánh³ jmu³ tso³, jɨ³ tsá² jmu² hi³ hlah³ hi³ hó³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jáun² tsa³tionh³ dí² ñí¹ nio² sɨ́² chéi³ lɨ́n³², ñí¹ jáun² tsa³tɨ́² tsa³hoh³² hi³ tsa³ma³zian² cáun² hi³ chéi³ hi³ uóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tɨ³la³ tsá² zian² la³ cun³ hi³ tɨ³² tsɨ́³ Dió³² má¹na²¹, tsá² la³ hí³ bíh¹ lɨ́¹³ jnia³ la³jmɨ́¹ jniá³ joh¹ hiú² ca³la³ cú²tú¹ cú²lí¹³ ñí¹ cuá¹quien² Dió³² Jméi² tsú². Nɨ́¹juáh³ hnoh² chi²¹ cuáh³, jáun² niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”Hi³ taunh³² tsú² jo³cuo² Dió³² lɨ́³ cáun² hi³ quien² lɨ́n³² bíh¹, la³jmɨ́¹ lɨ²¹ ñí¹con² jan² tsá² ca³choh¹³ cú¹mí¹niau²¹ hi³ tioh³ hñu³ hué³² ñí¹ lɨ́³ ñí¹náɨ² quioh²¹ tsáu²; hi³ jáun² tɨ³ ca³jla² bíh¹ tsú² siáh³ ñí¹ tioh³ jáun². Ca³la³ má²hiún² lɨ́n³² tsɨ́³ tsú² ngah³ hi³ ca³ñí¹hnáɨh¹ la³jɨ́³² hi³ jmɨ́¹ zia³² quioh²¹, hi³ jáun² ca³lau² hué³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”Ja³bí¹ hi³ taunh³² tsú² jo³cuo² Dió³² lɨ́³ cáun² hi³ quien² lɨ́n³², la³jmɨ́¹ lɨ²¹ ñí¹con² jan² tsá²ñuh² tsá² ca³tɨ³ ca³ngɨ́³ tɨ³ hlá² tɨ³ nɨ́² hi³ hnauh² máɨ³ zɨ́n³ hi³ téh²³ tsú² jáun² perla, máɨ³ jlánh¹ bíh¹ chu²¹, nɨ́¹juáh³ hin² zia³² quioh²¹; ");
INSERT INTO csoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","jáun² jmɨ́¹ ca³choh¹³ tsú² jáun² hi³ jlánh¹ bíh¹ hmuh²¹ né³, ngah³ hñú¹³ hi³ ca³ñí¹hnáɨh¹ la³jɨ́³² hi³ zia³² quioh²¹, hi³ jáun² ca³lau² máɨ³ zɨ́n³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”Ja³bí¹ jmáɨ¹ hi³ cán³ Dió³² jú¹ tson² quioh²¹ tsáu² lɨ́¹³ la³jmɨ́¹ lɨ́³ jmáɨ¹ hi³ ñeih³² tsú² hmá³ hñu³ jmɨ́²miih²¹, hi³ jáun² jáun²³ la³jáh³ dúh¹ ñí¹ jáh³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jáun² nɨ́¹ má¹ca³canh² jáh³ hmá³ jáun² né³, tsá² zanh²³ jáh³ jmáɨ² chí² hmá³ tɨ³ can³² jmáɨ² hi³ jáun² tiánh²³ hi³ quianh²³ jáh³; jáun² jáh³ chun¹ tónh³² tsú² mɨ́²tá², hi³ jáun² cuɨn²³ bíh¹ tsú² jáh³ tiá² chun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","La³ nɨ́² bíh¹ lɨ́¹³ ñí¹ táuh³ jmáɨ¹ ñí¹ hué²¹ lá²; hi³ ja³táunh¹ tsá²cuú² tsá²ta³ Dió³² hi³ ja³quianh³ ja¹ tsá² hláɨh¹ tsá² chun¹, ");
INSERT INTO csoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","hi³ jáun² tsá² hláɨh¹ tónh³² tsú² ja¹ sɨ́² chéi³ lɨ́n³², hi³ jáun² ñí¹ jáun² ho³ jngɨh³ jɨ³ hi³ lɨ́¹³ zian² cáun² hi³ chéi³ hi³ uóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jmɨ́¹ lɨ²¹ jáun² né³ ca³ngáɨ³ Jesús ñí¹con² tsá² hí³: ―¿Má¹ca³ngɨ¹³ hnoh² la³jɨ́³² jáɨ¹³ hi³ má²lɨ́²jmú³² jná¹³ nɨ́²? Jáun² tsá² hí³ ca³ngáɨ³: ―Ján³ Tɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jmɨ́¹jáun² né³ ca³záɨh³ dí² siáh³ tsú² la³ lá²: ―Lɨ³ua³ jan² tɨ³² liei²¹, tsá² má²lɨ́²hí³ jo³cuo² Dió³², tsá² hí³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá² hánh³, hi³ tɨn² huéh³ hi³ quien² ja¹ hi³ quioh²¹, uá¹ hi³ yeh³ uá¹ hi³ hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jmɨ́¹ má²ca³táuh³ hi³ jmu² Jesús la³jɨ́³² jáɨ¹³ nɨ́² né³, cua³han³ ñí¹ jáun² ");
INSERT INTO csoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","hi³ jáun² ca³chánh³² juú²co¹. Ñí¹ jáun² né³ ca³ma³liáu³² tsú² hi³ hɨeh³² tsáu² hñu³ cuáh³² quioh²¹ tsá² *judíos hi³ zeh² juú² jáun², hi³ jáun² tsáu² né³ jmɨ́¹ ná¹tsá²cáun² tsɨ́³ hi³ juáh³ la³ lá²: ―¿Ha³ dá² jinh¹ ca³ñí¹ma³tɨn³² tsá²ñuh² nɨ́², hi³ jáun² sa³ jlánh¹ yáh³ quiáh¹ jmɨ́¹ tsɨ́³? ¿Ha³ bí¹ lánh³ rón³² tɨn² tsú² siáh³ jmu² hua³jueh³²? ");
INSERT INTO csoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Já² jon² hla¹ tɨ³² hmá² bíh¹ nɨ³², hi³ Má²réi³ bíh¹ mí¹ziú¹³ tsú². ¿Há¹ jun³juáh¹³ raɨnh²¹ Jacobo bíh¹ nɨ³² quionh³ Sé³², Sí¹mu²¹ nɨ́², jɨ³ Judas nɨ́² siáh³ dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ja³bí¹ tsá²mɨ³ raɨnh²¹ tsú² siáh³ tionh² já¹ juú² lá². Jáun² né³ ¿jinh¹ dá² ca³ñí¹ziú¹ ñí¹liáuh¹ tsá² nɨ́² jáɨ¹³ hi³ jlánh¹ ñi³² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jáun² cun³ñí¹ hi³ jáun² bíh¹ tiá² ca³quiú¹ ca³jéin¹³ dí² tsú². Tɨ³la³ Jesús né³ ca³záɨh³ tsá² hí³: ―Jɨ́³²la³ ja¹ quioh²¹ tsá²co¹ jɨ³ ja¹ quioh²¹ tsá² jún¹ tsá² raɨnh²¹ bíh¹ jan² *tɨ³² jë¹ Dió³² tiá² lɨ³ quien². ");
INSERT INTO csoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hi³ jáun² tiá² hliáun³ hua³jueh³² ca³jmú³ yáh³ Jesús ñí¹ jáun², quí¹ tiá² ta²¹ jmɨ́¹ taunh² yáh³ tsá² hí³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jmáɨ¹ jáun², Herodes tsá² cuá¹lɨ́n³ ta²¹ hué¹³ Galilea ca³lɨ³ ñi³² hi³ ca³tɨn¹ Jesús, ");
INSERT INTO csoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","hi³ jáun² ca³záɨh³ tsú² tsá²cuú² tsá²ta³ la³ lá²: ―Juan² tsá² tɨ́² zion² tsáu² jmáɨ² bíh¹ nɨ³², hi³ má²ca³jenh¹³ ja¹ hla¹. Hi³ jáun² bíh¹ zia³² pí³ jáun² quioh²¹ tsú² hi³ jmu² hua³jueh³². ");
INSERT INTO csoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Quí¹hliá² Herodes jmɨ́¹ má²ca³tanh² Juan² hñu³mí¹ñí² hi³ cuá¹tson³, hi³ cuá¹hñei²¹ quionh³ cá²den¹ná¹ cun³ñí¹ hi³ tsáu¹³ tsá²mɨ³ Herodías, tsá² jmɨ́¹ ñí²cuo² Pí²liéi¹ raɨnh²¹ tsá² lɨ́n³ ta²¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ca³tanh² tsú² Juan² hñu³mí¹ñí² quí¹ cun³ñí¹ hi³ Juan² hí³ jlánh¹ chí¹ñi¹ ca³juáh³ la³ lá²: ―Tiá² ca³tɨn¹ yáh³ hnú² hi³ ján³ nú² tsá²mɨ³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes jmɨ́¹ hnió³ jngɨh³ Juan², tɨ³la³ cun³ñí¹ hi³ la³jɨ́n³² tsáu² bíh¹ jmɨ́¹ ná¹juáh²³ hi³ Juan² lɨ́n³ jan² *tɨ³² jë¹ Dió³², jáun² jmɨ́¹ juénh² tsú² ñí¹con² la³jɨ́n³² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tɨ³la³ jmɨ́¹ ca³jmú³ Herodes jmáɨ¹ hi³ ca³tsɨn¹³ mieh² né³, ñéi¹ tsá¹máɨ¹³ jon² tsá²mɨ³ Herodías hí³ hi³ ca³ñí¹tsan³² ñí¹ ta³ ñí¹ jɨ³lɨn² tsá² ná¹tén¹ jmáɨ¹ jáun², hi³ jáun² Herodes né³ jlánh¹ ca³tɨ́³ lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Jmɨ́¹jáun² ca³jmú³ dí² jáɨ¹³ ca³la³ hi³ hɨen² Dió³² hi³ cuéh³² dí² mɨ́¹ hí³ lɨ³ua³ cáun² hi³ mɨ́³². ");
INSERT INTO csoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jáun² mɨ́¹ hí³ né³, cun³ñí¹ hi³ ca³ma³cau² tín² mí¹ziú¹³, hi³ jáun² ca³ñí¹zeh¹ Herodes la³ lá²: ―Mɨ³ chí¹ Juan² tsá² ziau² hí³ jmáɨ² bíh¹ hnó³² jná¹³ cuéh¹ nú², hi³ ná¹hu²¹ cáun² hñu³ uon². ");
INSERT INTO csoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hlah³ lɨ́n²¹ bíh¹ ca³ta³no¹ tsɨ́³ re²¹ jmɨ́¹jáun²; tɨ³la³ Dió³² yáh³ má²lɨ́²hɨen³ tsú², hi³ hí¹ ca³la³ tɨ³ tsá² ná¹tén¹ yáh³ má²lɨ́²niéi³² jáɨ¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jáun² ca³jmú³ dí² héih³² hi³ tsa³quiéih³ tsú² láɨ¹ Juan² hñu³mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jáun² quiaun² bíh¹ tsú² mɨ³ chí¹ Juan² hi³ ná¹hu²¹ cáun² uon² hi³ ca³cuéh³ dí² mɨ́¹ hí³, hi³ jáun² ca³ñí¹jɨenh¹³ tsú² mí¹ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jáun² cua³taunh²¹ tsá² jmɨ́¹ haɨn²¹ tɨ³ con² Juan² hi³ cua³quión³² hla¹, hi³ jáun² ca³ñí¹hón²¹ dí²; jmɨ́¹ lɨ²¹ jáun² ja³taunh²¹ dí² hi³ ca³ñí¹zeh¹ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jmɨ́¹ ca³lɨ³ ñi³² Jesús hi³ lɨ³ la³ jáun², jáun² cua³han³ ñí¹ jáun² hi³ hi³ cáun² mu² hi³ ngau³ ñí¹ tɨ³ có³² ñí¹ lɨ́¹³ cuá³ hnga². Tɨ³la³ ca³lɨ³ ñi³² bíh¹ tsáu² hín² juɨh³² ngau³ tsú², hi³ jáun² tsá² zian² juú² la³ cu³ la³ jéin³ jáun² ca³huén² hi³ já¹taunh²¹ juɨ³² ta³ tɨ³ ñí¹ ngau²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cua³han³ bíh¹ Jesús hñu³ mu² jmɨ́¹ cuá¹han³, tɨ³la³ jmɨ́¹ ca³jɨ́e³ tsú² hi³ sa³ juóun³² lɨ́n³² bíh¹ tsáu² má²tionh² ñí¹ jáun², hi³ jáun² ca³ja³ mií³ tsɨ́³ dí² ñí¹con² tsá² hí³ hi³ ca³jmah³ dí² tsá² tsáun¹ hi³ jmɨ́¹ ná¹jan² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tɨ³la³ jmɨ́¹ má²ca³hláu³ bíh¹, hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ca³ma³janh³² ñí¹ zenh¹ hi³ ca³juáh³ la³ lá²: ―Já² má²ca³hláu³ bíh¹ la³², hi³ hí¹ jan² yáh³ tiá² hin² zian² ñí¹ má²janh² lá². Jáun² chú³² juoh¹ nú² tsá² nɨ́² hi³ tsa³tánh¹, hi³ jáun² cuɨ́¹ cha³lia³² má³² cuh³ ñí¹ táun³ hñú³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tɨ³la³ Jesús ca³juáh³: ―Tiá² lin¹ lɨ³ hniáuh³² yáh³ tsa³tánh¹ tsú²; hnoh² bíh¹ hniáuh³² cueh¹ tsú² hi³ cuh³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jáun² tsá² hí³ né³ ca³juáh³: ―Tiá² hi³ zia³² yáh³ quiú¹³ jnoh¹, jɨ́³²la³ hñá³ *hí³ cuú²miih²¹ quionh³ gon³ hma²¹ bíh¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jáun² Jesús ca³juáh³: ―Ñá²cán¹ ñí¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jmɨ́¹jáun² ca³jmú³ dí² héih³² hi³ chan³ tsú² tsáu² hué³² ja¹ mí¹ñéi². Jmɨ́¹jáun² ca³zanh³ dí² tá¹ hñá³ hí³ jáun² quionh³ tá¹ gon³ hma²¹, hi³ jáun² ca³jɨ́e³ tsú² tɨ³ hñu³mɨ³cuú² hi³ ca³cuéh³ tiá¹hmah¹ Dió³², jmɨ́¹ lɨ²¹ jáun² ca³ca³ tsú² hí³ cuú²miih²¹ jáun², hi³ jáun² ca³cuéh³ dí² tsá² haɨn²¹ tɨ³ con², hi³ jáun² tsá² hí³ siáh³ ca³tsóh³ ñí¹con² tsá² tionh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","La³jɨ́n³² bíh¹ tsáu² ca³cúh² ca³la³ lah³ má³² re²; jmɨ́¹ má²lɨ³² jáun² né³ ca³cónh³² quia³tún³ mɨ́²tá² chí² juoh¹ hi³ ca³ziaun³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","La³ cun³ tsá² ca³cúh² má³² jáun² né³ jmɨ́¹ tín³ hñá³ mei²¹ jmáh³la³ tsá²ñuh², tɨ³la³ tiá² ná¹hɨ́n¹³ yáh³ tsá²mɨ³ quionh³ tsá¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jmɨ́¹ lɨ²¹ jáun² né³, ca³jmú³ Jesús héih³² hi³ tónh³² tsá² haɨn²¹ hí³ tɨ³ con² hñu³ mu² hi³ hán³² tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ ta³ tin² tá¹la³ dí¹hah² dí² jáɨ¹³ ñí¹con² tsá² ná¹ngɨh³² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jmɨ́¹ má²lɨ́²heh² tsú² jáun² jáɨ¹³ quionh³ tsá² tionh² hí³ né³, ca³uú³ tsɨ³ máh³ hi³ ca³ñí¹lienh¹³ Dió³² hnga² tán¹; jáun² ñí¹ jáun² bíh¹ jmɨ́¹ cuá³ tsú² cú² hnga² pih²¹ la³ ñí¹ ca³niéi². ");
INSERT INTO csoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Tá¹la³ jáun² né³ má²hí¹tsau³² mu² ñí¹ chu³ jo² jmáɨ² lɨ́¹ ná¹ho³ jáun². Jmáɨ² hi³ ja³² ma³ cu³ tsɨn¹ jáun² jmɨ́¹ má²hí¹hlia³² mu² tɨ³ hlá² tɨ³ nɨ́² quí¹hliá² jmɨ́¹ ja³² chí³ tɨ³ juɨ³² ñí¹ hí¹tsá²táunh¹ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jmɨ́¹ má²já²jnia² jáun² né³ ngau³ Jesús juɨ³² ñí¹ hí¹tsá²táunh¹ tsú² jáun², hi³ chí¹ngɨ³² ñí¹ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jmɨ́¹ ca³jɨ́e³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ cuá¹ngɨ³² dí² ñí¹ jmáɨ², jáun² ca³hiá²han¹ lɨ́n²¹ bíh¹ tsú², hi³ jáun² ta³ juénh² jáun² bíh¹ tsú² ca³hóh³² hi³ ca³juáh³ la³ lá²: ―¡Jan² tsá² le¹ bíh¹ ó³²! ");
INSERT INTO csoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɨ³la³ Jesús ca³liéinh³² tsá² hí³ hi³ ca³juáh³ la³ lá²: ―¡Tiá³ chá¹ náh² honh²; ha³ lɨ́² juenh³ náh², quí¹ jná¹³ bíh¹ la³²! ");
INSERT INTO csoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Hi³ jáun² Pé¹ né³ ca³záɨh³ Jesús la³ lá²: ―Tɨ³², nɨ́¹juáh³ hnú² bí¹ nɨ³², jmu³ héih³² hi³ lɨ́¹³ ngɨ́¹³ jná¹³ uá²jaɨ³² ñí¹ jmáɨ² hi³ ñe¹ ná¹ la³ tɨ³ ñí¹ hí¹ñeih³² hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jáun² Jesús ca³juáh³: ―Ña³² jaun³². Jáun² Pé¹ cua³han³ hñu³ mu² hi³ ca³ma³liáu³² hi³ ca³ngɨ́³ ñí¹ jmáɨ² hi³ ngau³ tɨ³ juɨ³² ñí¹ cuá¹ja³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tɨ³la³ jmɨ́¹ ca³lɨ³lieih²¹ tsú² hi³ tiá³ lɨ́n³² bíh¹ he² chí³, jmɨ́¹jáun² ca³juénh²; hi³ jáun² ca³ja³hanh³² bíh¹ tsú² hñu³ jmáɨ². Tá¹la³ má²hí¹tsá²hanh³² tsú² jáun² né³, ca³hóh³² hi³ ca³juáh³: ―¡Liau¹ tiá³ Tɨ³²! ");
INSERT INTO csoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","La³ cun³ jmɨ́¹jáun² bíh¹ ca³zanh³ Jesús cuo² tsú², hi³ ca³juáh³: ―¡Jlánh¹ tiá² re² la³ nio² cáun² honh² hnú²! ¿He³ láɨh³² lɨ́²cháh¹ hnú² tun³ honh²? ");
INSERT INTO csoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jmɨ́¹ taunh²¹ tsú² jáun² hñu³ mu² né³, ca³hná³ bíh¹ chí³. ");
INSERT INTO csoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hi³ jáun² tsá² ñí¹ hná¹ jmɨ́¹ tiáunh¹ hí³ hñu³ mu² né³, ca³ma³tsu³ ma³jáuh³² dí², hi³ ca³juáh³ la³ lá²: ―¡Tson² bíh¹ cu³tí³, hi³ la³ Jon² Dió³² bíh¹ hnú²! ");
INSERT INTO csoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jmɨ́¹ lɨ²¹ jáun² né³, ca³hán² bíh¹ tsú² tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun², hi³ ca³cha³táunh¹ hué³² Genesaret. ");
INSERT INTO csoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jmɨ́¹ ca³lɨ³ cuóun³² tsá² zian² hué³² jáun² Jesús, ca³nga³ tsú² jáɨ¹³ la³ tá¹ cáun² hué³² jáun², hi³ jáun² ca³cua³jan² tsú² la³jɨ́n³² tsá² ná¹tsáun¹ ñí¹ jmɨ́¹ zenh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hi³ jáun² ca³hiu³ ca³mɨ́³ tsú² ñí¹con² dí² hi³ cué³² dí² jáɨ¹³ hi³ hliéih³ tsá² tsáun¹ cuo² uá¹jinh¹ jmáh³la³ zéi¹ ha¹ bíh¹ dí²; hi³ jáun² la³jɨ́n³² tsá² ca³tí³ hí³ cuo² ha¹ tsú² né³, lan³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jmɨ́¹jáun² cua³taunh²¹ ma³ jan² tsá² *fariseos ñí¹con² Jesús quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹; tsá² hí³ má²já²taunh²¹ já¹ juú² Jerusalén, hi³ jáun² ca³ngáɨh³ dí² Jesús: ");
INSERT INTO csoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿He³ láɨh³² tiá² má²tí³² tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² la³ cun³ hi³ ná¹ngɨ²³ tsá²daun³²? Quí¹ tiá² má²tí³² yáh³ tsú² ca³tɨ²¹ ha³ lánh³ rón³² hniáuh³² sɨ³ ren³ tsú² cuo² la³ cun³ ca³tɨ²¹ nɨ́¹ má¹tɨ³ ñí¹ jmu³ tsú² má³². ");
INSERT INTO csoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tɨ³la³ Jesús né³ ca³záɨh³ tsá² hí³: ―¿Hi³ he³ láɨh³² sa³ tiá² ma³tih²¹ siáh³ hnoh² uá²jaɨ³² héih³² quioh²¹ Dió³²? Já² ma³tih²¹ bí¹ náh² cáun² hi³ ná¹hëh³ chinh³² náh² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Quí¹ Dió³² ca³juáh³ la³ lá²: “Tianh³² náh² ta²¹ ñeh² mí²ziúh²”. Hi³ juáh³ siáh³: “Lɨ³ua³ jan² tsá² chú² juóun³² jméi² mí¹ziú¹³, tsá² la³ hí³ ca³tɨn¹ jún³ bíh¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tɨ³la³ hnoh² né³ juánh³ hi³ lɨ́¹³ bí¹ néh¹ hi³ záɨh³² tsáu² jméi² mí¹ziú¹³ la³ lá²: “Tiú²uú² lɨ́¹³ yáh³ má¹hau¹ jná¹³ hnú², quí¹ ñí¹con² Dió³² bíh¹ má²ná¹chan¹ la³jɨ́³² hi³ zia³² quion²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Hi³ jáun² nɨ́¹juáh³ lɨ³ua³ jan² tsá² má²lɨ́²juáh³ la³ nɨ́² néh¹, tiú²uú² tion³ hniáuh³² yáh³ ma³hon³ tsú² jméi² mí¹ziú¹³. Jáun² cun³quionh³ la³ nɨ́² bíh¹ má²ná¹jmuh³² hnoh² hi³ tiá² quien² cu³tí¹³ héih³² quioh²¹ Dió³², cun³quionh³ hi³ ná¹jmuh³² náh² quien² la³ cun³ hi³ jlánh¹ ná¹hëh³ chinh³² náh² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Hnoh² tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Jú¹ tson² cu³tí³ bíh¹ ca³juáh³ hla¹ Isaías *tɨ³² jë¹ Dió³² hi³ ca³tɨn¹ hnoh² jmɨ́¹ ca³juáh³ jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Tsá² nɨ́² dá² má²quien² jná¹³ cun³quionh³ jmáh³la³ ho³ bíh¹, tɨ³la³ jun³juáh¹³ la³ jonh³ jmɨ́¹ tsɨ́³ yáh³ tsú² hniau³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Hí¹ cáun² tiá² lin¹ ñí¹ quien² yáh³ hi³ má²tsú² má²jáuh³² tsú² jáun² jná¹³, quí¹ héih³² quioh²¹ tsá²mɨ³cuóun² bíh¹ jaun³² hɨeh³² tsú² tsáu² la³juah²¹ dúh¹ héih³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jmɨ́¹jáun² ca³teh³ tsú² tsá² tionh² hí³ hi³ ca³záɨh³ dí² la³ lá²: ―Niéi² náh² jáɨ¹³ lá², jɨ³ hi³ cuɨ́¹ ngɨ¹³ náh² nɨ́² siáh³: ");
INSERT INTO csoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jun³juáh¹³ hi³ tsá²toh³ ho³ yáh³ tsú² jmu² hi³ tiá² jɨn² tsú². Quí¹ la³jɨ́³² hi³ hue³² hñu³ tsɨ́³ bíh¹ tsú² jmu² hi³ hliánh². ");
INSERT INTO csoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jmɨ́¹jáun² ca³ma³janh³² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ñí¹ zenh¹ hi³ ca³juáh³ la³ lá²: ―¿Cá¹lɨ³tsɨn² hnú² hi³ jlánh¹ ca³míh³ tsɨ́³ tsá² fariseos jmɨ́¹ lɨ́¹niéi²¹ jáɨ¹³ hi³ lɨ́²juah²¹ hnú² jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tɨ³la³ hí³ dí² né³ ca³juáh³: ―Lɨ³ua³ cáun² hmá² hi³ tiá² lɨ́²jñí³² Ñuh³² jná¹³, hniáuh³² tsa³ca³ bíh¹ ca³la³ tɨ³ chí² jmu². ");
INSERT INTO csoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ha³ lɨ́² hí¹³ cán² he³ jmu² tsá² nɨ́²; quí¹ tsá² ten³ bíh¹ nɨ³² hi³ lɨ́n³ tsá² quian³² ñí¹ juɨ³² ñí¹con² te³ raɨnh²¹. Quí¹ nɨ́¹juáh³ jan² tsá² ten³ la³ hɨ́eh³² juɨ³² jan² tsá² ten³ raɨnh²¹, jáun² né³, chau²¹ jmáɨ¹ hi³ tán¹ gon³ bíh¹ tsú² sunh³ cu³tsa³² nɨ́¹juáh³ ñí¹ hó²¹ táu². ");
INSERT INTO csoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jáun² Pé¹ ca³záɨh³ Jesús: ―Hnú² Tɨ³², jmu³ tiá³ na²¹ jáɨ¹³ jáun² ñí¹con² jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús ca³juáh³: ―¿Hí¹ chín¹dí¹ hnoh² uá¹ tiá² la³ ngɨ²³ náh² siáh³? ");
INSERT INTO csoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tiá¹ má²ñíh¹ hnoh² hi³ la³jɨ́³² hi³ tsá²toh³ ho³ tsú² chau³² hñu³ héin¹ bíh¹ tsú², nɨ́¹ má¹lɨ³² jáun² né³ hue³² tɨ³ cheih³²? ");
INSERT INTO csoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Tɨ³la³ hi³ hue³² ho³ tsú² má¹ná¹, ja³² la³ tɨ³ hñu³ tsɨ́³ bíh¹ tsú²; hi³ jáun² bíh¹ ján¹ tson² jmu² hi³ hliáh² jmɨ́¹ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Quí¹ hñu³ tsɨ́³ bíh¹ tsú² ja³² la³jɨ́³² hi³ hlah³, uá¹la³ cun³ hi³ lɨ́¹ chin² tsú² chí¹, hi³ jngɨh² tsú² tsáu², hi³ lɨ́¹ jmu² tsú² juón¹ quionh³ tsá² hlá² tsá² nɨ́², hi³ jmu² hi³ hlah³ hi³ hó³², hi³ lɨ́n³ tsú² tsá² háɨn² siáh³, hi³ jmu² tsú² jú¹ tɨ́¹jáɨ², jɨ³ hi³ lɨ́¹ tú² lɨ́¹ hión³² tsú² tsáu² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Hi³ nɨ́² bíh¹ jmu² hi³ tiá² jɨn² tsú² ta³ ñí¹ Dió³². Tɨ³la³ nɨ́¹juáh³ tsá² ca³cúh² ta³ tiá² má²lɨ́²ma³tí³² hi³ ma³jɨ² tín² cuo² la³ cun³ hi³ ná¹ngɨ²³ tsáu² né³, jun³juáh¹³ hi³ jáun² yáh³ jmu² hi³ hliánh² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jmɨ́¹ lɨ²¹ jáun² né³ cua³han³ Jesús ñí¹ jáun² hi³ ngau³ la³cáun² juú² Tiro jɨ³ juú² Sidón. ");
INSERT INTO csoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jáun² hué³² jáun² né³ jmɨ́¹ cuá³ jan² tsá²mɨ³ tsá² hué³² Canaán. Tsá² hí³ né³, ja³ ñí¹con² Jesús hi³ hí¹hóh³² hi³ juáh³ la³ lá²: ―¡Hnú² Tɨ³², jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ já² mií³ honh² hnú² ñí¹con² jná¹³! Mɨ́¹míh¹ jón³² jná¹³ hún¹ jan² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³, hi³ jáun² má²tso² lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tɨ³la³ Jesús tiá² hi³ ca³ngáɨ³ hí¹ cáun² yáh³. Hi³ jáun² tsá² haɨn²¹ tɨ³ con² tsú² cua³taunh²¹ hi³ ca³hiu³ ca³mɨ́³ hi³ ca³juáh³: ―Chanh²¹ tsá² ó³², quí¹ jlánh¹ tiú² jan³² hí¹jmu² cu³hna²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hi³ jáun² Jesús ca³záɨh³ tsá²mɨ³ hí³ la³ lá²: ―Dió³² ca³ze³ jná¹³ jmáh³la³ ñí¹con² tsá² *Israel bíh¹, tsá² ná¹lɨ́n³ la³jmɨ́¹ lɨ́n³ *já¹ziáh² má²já²cuɨn³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tɨ³la³ tsá²mɨ³ hí³ má¹ná¹, ja³ la³ tɨ³ ta³ ñí¹ tsú² hi³ ca³di³jñí³² hi³ juáh³ la³ lá²: ―¡Tɨ³², ma³hau¹ tiá³ jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tɨ³la³ Jesús ca³juáh³: ―Tiá² re² jniá³ yáh³ hi³ quin¹³ dí² má³² quioh²¹ tsá¹míh¹ hi³ cue¹³ dí² tsáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tɨ³la³ tsá²mɨ³ hí³ né³, ca³juáh³: ―Tson² bíh¹ la³ jáun² Tɨ³²; tɨ³la³ cun³ jáun² cúh² bíh¹ tsáɨ² chí² juoh¹ má³² hi³ suh³² ñí¹ mesa quioh²¹ juo¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jáun² Jesús ca³juáh³: ―¡Tsá²mɨ³, jlánh¹ cáun² la³ nio² honh² hnú²! ¡Cuɨ́¹ lɨ́¹³ la³ cun³ hi³ hnáuh² hnú²! Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ lan³ mɨ́¹míh¹ jon² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jmɨ́¹ lɨ²¹ jáun² né³ cua³han³ siáh³ Jesús ñí¹ jáun², hi³ jáun² ca³nga² can³² jmáɨ² lɨ́¹ ná¹ho³ hi³ téh²³ tsú² Galilea; hi³ jáun² ca³uú³ cáun² tsɨ³ máh³, ñí¹ jáun² né³ ca³cuá³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jáun² juóun³² lɨ́n³² bíh¹ tsáu² ca³cha³táunh¹ ñí¹ cuá³ tsú² jáun², hi³ ná¹jan² tsá² hma², tsá² ten³, tsá² cáun¹, tsá² hliánh² nɨ́² siáh³, hi³ juóun³² lɨ́n³² siáh³ tsá² ná¹jau² mɨ́¹uɨ́³ siáh³ ñí¹ hná¹ nɨ́². Jáun² ca³chan³ tsú² ñí¹ hó²¹ñí¹ Jesús, hi³ jáun² hí³ né³ ca³jmah³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hi³ jáun² lɨ́¹ ca³lɨn³ bíh¹ tsáu² jmɨ́¹ ca³jɨ́e³ hi³ tsá² jmɨ́¹ cáun¹ hí³ má²hleh³² bíh¹, hi³ tsá² hliánh² má²laɨn³², tsá² hma² má²ñi³táunh¹, hi³ jáun² tsá² ten³ né³ má²lɨ́²³ jɨ́e³. Hi³ jáun² jmɨ́¹jáun² ca³ma³quien² tsú² Dió³² Juo¹³ tsá² Israel. ");
INSERT INTO csoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jmɨ́¹ lɨ²¹ jáun² né³ ca³teh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² hi³ ca³záɨh³ dí² la³ lá²: ―Jlánh¹ ja³² mií³ tsɨn³² jná¹³ ñí¹con² tsá² lá², quí¹hliá² hnɨ³² jmáɨ¹ máh³ má²tí³ hi³ tionh² tsú² ñí¹ lá² quiúnh¹ jná¹³, hi³ hí¹ cú¹pih²¹ yáh³ hi³ cuh³ tsú² tiú²uú² zia³². Tiá² hnó³² yáh³ jná¹³ chanh²¹ tsú² hñú¹³ ta³ tiá² hi³ má²lɨ́²cuh³, quí¹ nɨ́² lɨ́¹ ca³huán³ tsú² hú¹ juɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³juáh³: ―Tɨ³la³ ¿ha³ bíh¹ jinh¹ tsá¹cán¹³ jnoh¹ má³² hi³ cuh³ tsá² juóun³² lɨ́n³² lá²? Já² hí¹ jan² yáh³ tiá² hin² zian² ñí¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jáun² hí³ né³ ca³ngáɨh³ tsá² hí³: ―¿Cónh³ bíh¹ *hí³ cuú²miih²¹ zia³² quián¹³ hnoh² dúh¹? Jáun² tsá² hí³ né³ ca³juáh³: ―Quiau³ hí³ quionh³ gon³ gáun³ juo¹³ pih²¹ bíh¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jmɨ́¹jáun² ca³jmú³ dí² héih³² hi³ tiánh³² tsá² hí³ hué³², ");
INSERT INTO csoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","jáun² ca³zanh³ dí² tá¹ quiau³ hí³ jáun² la³ má²quionh³ juo¹³ pih²¹ hí³, hi³ ca³cuéh³ dí² tiá¹hmah¹ Dió³². Jmɨ́¹ lɨ²¹ jáun² ca³ca³ tsú² hí³ cuú²miih²¹ jáun² hi³ ca³cuéh³ dí² tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² tsá² hí³ né³ ca³tsóh³ ñí¹con² tsá² má²tionh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Jáun² la³jɨ́n³² bíh¹ tsáu² ca³cúh² ca³la³ lah³ má³² re² lɨ́n³². Ca³lɨ³í¹ máh³ ca³cónh³² quiau³ mɨ́²tá² chí² juoh¹ hi³ ziau³. ");
INSERT INTO csoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tsá² ca³jmú³ hí³ má³² né³ jmɨ́¹ tín³ quiún³ mei²¹ jmáh³la³ tsá²ñuh², ha³ tiá² ná¹hɨ́n¹³ yáh³ tsá²mɨ³ quionh³ tsá¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jmɨ́¹ lɨ²¹ jáun² ca³hah² Jesús jáɨ¹³ ñí¹con² tsá² jmɨ́¹ tionh² hí³, hi³ hi³ hñu³ mu² hi³ ngau³ tɨ³ hué¹³ juú² Magadán. ");
INSERT INTO csoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Hi³ jáun² né³, ca³chó³² siáh³ cáun² jmáɨ¹ hi³ ñí¹táunh¹ tsá² *fariseos quionh³ tsá² *saduceos hi³ ca³ñí¹jɨen¹³ Jesús; hi³ cun³ñí¹ hi³ hnió³ dí² ca³ lan³ tsú² né³, jáun² ca³mɨ́³ dí² hi³ hɨ́e³² Jesús cáun² li²¹ hi³ lɨ́³ hua³jueh³² hi³ já³² tɨ³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tɨ³la³ hí³ má¹ná¹ ca³ngáɨ³: ―Nɨ́¹ má¹ca³hláu³ juánh³ hnoh² la³ lá²: “Jlánh¹ re² jniau¹³ hiú², hi³ jáun² bíh¹ dáɨn³ chi³cuú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Hi³ jáun² tɨ³ hú²niéi² né³ juánh³ hnoh² la³ lá²: “Né³² chau¹³ jmɨ́³, quí¹ jlánh¹ dáɨn³ jnie²”. ¡Hnoh² tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Já² tɨn² bíh¹ hnoh² chú¹ ñih²¹ ha³ lánh³ jniá³ chi³cuú², tɨ³la³ tiá² la³ tɨn² yáh³ hnoh² chú¹ ñih²¹ jmáɨ¹ hi³ ziáun² dí² lá² ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tsá² hláɨh¹ hon², tsá² tiá² má²tí³² jë¹ mɨ³² cáun² li²¹; tɨ³la³ tiá² li²¹ siáh³ hiáuh³ yáh³ tsú², jɨ́³²la³ li²¹ hi³ ca³jɨ́e³ jáun² tsáu² hi³ ca³tɨn¹ hla¹ Jonás bíh¹. Jmɨ́¹ lɨ²¹ jáun² né³ ngah³ dí²; hi³ tsá² hí³ né³, lɨ́¹ ca³ta³tonh¹ bíh¹ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jmɨ́¹ ca³hán² tsú² jáun² tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun² né³, sa³ la³ ca³ja³có³ bíh¹ tsɨ́³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ jmɨ́¹ cán³ ca³lá² má³². ");
INSERT INTO csoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² hí³: ―Sá¹nɨ́² jɨe³, hua³hín¹³ náh² jmu³ ca³tɨ²¹ tie³ quioh²¹ tsá² fariseos jɨ³ tsá² saduceos nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ma³liáu³² hi³ juónh²³ la³ lá² ja¹ hmóu³²: ―Cun³ñí¹ hi³hliá² tiá² quián¹ má³² bíh¹ dí² nɨ³², hi³ jáun² la³ nɨ́² ñí¹juah²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tɨ³la³ Jesús ca³lɨ³tsɨn² bíh¹ hi³ jáun², hi³ jáun² ca³juáh³ siáh³ la³ lá²: ―¿He³ láɨh³² ná¹juónh³² náh² hi³ tiá² quiánh¹ má³²? ¡Jlánh¹ tiá² re² la³ nio² cáun² honh² náh²! ");
INSERT INTO csoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tiá¹ má²ngɨ²³ máh³ hnoh², hi³ sa³jun³ chau² siáh³ honh² náh² ca³tɨ²¹ hñá³ *hí³ cuú²miih²¹ hi³ ca³tsóh³² jná¹³ jáun² ñí¹con² hñá³ mei²¹ tsáu², hi³ ha³ cónh³ mɨ́²tá² ca³ziau³ siáh³? ");
INSERT INTO csoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Hí¹ sa³jun³ chau² siáh³ honh² náh² ca³tɨ²¹ quiau³ hí³ cuú²miih²¹ jáun² hi³ ca³tsóh³² jná¹³ jáun² ñí¹con² quiún³ mei²¹ tsáu², jɨ³ hi³ cónh³ mɨ́²tá² ca³ziau³ siáh³ jmɨ́¹ lɨ²¹ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Lánh³ bíh¹ rón³² hi³ tiá² ca³lɨ³tsɨn² hnoh² hi³ jun³juáh¹³ ca³tɨ²¹ quioh²¹ má³² yáh³ dí¹hléh²³ jná¹³ jmɨ́¹ lɨ́¹juáh²¹ jná¹³ hi³ jmúh¹³ náh² hua³hín¹³ ca³tɨ²¹ tie³ quioh²¹ tsá² fariseos quionh³ tsá² saduceos? ");
INSERT INTO csoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jmɨ́¹jáun² bíh¹ ca³lɨ³tsɨn² tsú² hi³ tiá² la³ ca³juáh³ yáh³ Jesús hi³ jmu³ tsú² hua³hín¹³ ca³tɨ²¹ tie³ quioh²¹ cán¹ hí¹miih²¹, tɨ³la³ la³ ca³juáh³ tsú² hi³ jmu³ dí² hua³hín¹³ ca³tɨ²¹ jáɨ¹³ hi³ hɨe³² bíh¹ tsá² fariseos quionh³ tsá² saduceos. ");
INSERT INTO csoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jáun² jmɨ́¹ cá¹chó²¹ Jesús cu³ jéin³ juú² Cesarea quioh²¹ Pí²liéi¹, jáun² ñí¹ jáun² ca³ngáɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² hi³ ca³záɨh³ dí² la³ lá²: ―¿Hin² tsánh² jná¹³ Jon² tsá²mɨ³cuóun² juáh³ tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jáun² tsá² hí³ ca³ngáɨ³: ―Zian² tsá² juáh³ hi³ hnú² bíh¹ néh¹ hla¹ Juan² tsá² tɨ́² ziau² hí³ jmáɨ²; zian² tsá² juáh³ siáh³ hi³ hnú² bí¹ néh¹ Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin², hi³ zian² siáh³ tsá² juáh³ hi³ hnú² bíh¹ hla¹ tɨ³² jë¹ Dió³² Jeremías, ho³lá²dá² lɨ³ua³ jan² tsá² jmɨ́¹ lɨ́n³ tɨ³² jë¹ Dió³² jmɨ́¹tin² ñí¹ hná¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jáun² ca³záɨh³ dí² siáh³: ―Hi³ hnoh² né³, ¿hin² tsánh² jná¹³ juánh³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jáun² Sí¹mu²¹ Pé¹ né³ ca³juáh³ la³ lá²: ―Hnú² bíh¹ Tsá² lɨ́n³ Cristo Jon² Dió³² Tsá² juú²tsáun². ");
INSERT INTO csoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jáun² Jesús ca³juáh³: ―Jlánh¹ jmɨ́¹ ren² hnú² Sí¹mu²¹, jon² Jonás, quí¹ hí¹ jan² yáh³ tsáu² tiá² má²ca³hɨ́e³ hnú² jáɨ¹³ nɨ́², quí¹ Ñuh³² jná¹³ Tsá² cuá³ hñu³mɨ³cuú² bíh¹ má²ca³hɨ́e³ hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hnú² bíh¹ jmáɨ² nú² Pé¹ (hi³ hnió³ juáh³ “Quɨ́n¹”). Jná¹³ né³ juanh³² hi³ ñí¹ quɨ́n¹ lá² bíh¹ chan²¹ jná¹³ tsá² cu³ nió³ joh² ná¹; hi³ ca³la³ hí¹juáh³ pí³ quioh²¹ hmú³² yáh³ tiá² cah¹³ jmáɨ¹ quionh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jáun² jná¹³ cué¹³ llaves, hi³ hauh³² hnú² jáɨ¹³ hi³ tonh¹ hnú² tsáu² jo³cuo² Dió³²; lɨ³ua³ cáun² hi³ hñeih²¹ hnú² ñí¹ hué²¹ lá², má²chí¹hñéih²³ bíh¹ siáh³ hñu³mɨ³cuú², hi³ lɨ³ua³ cáun² hi³ zaɨh²¹ hnú² ñí¹ hué²¹ lá² né³, má²záɨh³ bíh¹ siáh³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jmɨ́¹ lɨ²¹ jáun² né³ ca³jmú³ Jesús héih³² ñí¹con² tsá² hí³ hi³ hí¹ jan² tiá² hin² záɨh³² tsú² hi³ hí³ bíh¹ dí² Tsá² lɨ́n³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","La³ cun³ jmáɨ¹ jáun² máh³ ca³ma³liáu³² Jesús hi³ hɨeh³² jú¹ tá²na²¹ tsá² haɨn²¹ hí³ tɨ³ con², hi³ hniáuh³² tsó³² dí² tɨ³ Jerusalén; hi³ ñí¹ jáun² né³, tsá²daun³² tsá² ná¹ñí¹ juú², jɨ³ tsá² ná¹lɨ́n³ mi³jmú³ quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́² jmu³ hi³ ma³tso² lɨ́n³² dí² tsɨ́³. Ca³juáh³ dí² siáh³ hi³ hí¹ ca³la³ tɨ³ jngah³ yáh³ tsá² hí³, tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ má¹ná¹, jenh¹³ bíh¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jmɨ́¹jáun² ca³ñí¹jau² Pé¹ ñí¹ tɨ³ có³², hi³ jáun² ca³ma³liáu³² dí² hi³ quiú² jin²³ Jesús, hi³ juáh³ la³ lá²: ―¡Len³ jná¹³ ca³la³ hí¹juáh³ tiá² hnió³ yáh³ Dió³² hi³ lɨ́¹³ la³ nɨ́² Tɨ³²! ¡Tiá² ca³tɨn¹ yáh³ hnú² hi³ quiunh²¹ la³ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tɨ³la³ Jesús ca³jinh³ tɨ³ ñí¹ zenh¹ Pé¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―¡Tɨ³ có³² quin³² ñí¹con² jná¹³ *Satanás! Hnú² dá² lɨ́¹ chí¹cuú² chí¹jnaɨ³² bíh¹ ñí¹con² jná¹³. Tiá² lɨ́n²³ yáh³ hnú² la³jmɨ́¹ lɨ́n²³ Dió³², hnú² dá² lɨ́n²³ la³ cun³ qui³ lɨ́n²³ tsá²mɨ³cuóun² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jmɨ́¹ lɨ²¹ jáun² ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―Nɨ́¹juáh³ zian² tsá² hnió³ já³² cu³hna³² jná¹³, hniáuh³² chá³² tsú² tɨ³ có³² la³jɨ́³² hi³ dí¹quiaunh²¹ tsɨ́³ hnga², hi³ jáun² cuɨ́¹ quián¹³ tsú² crei²¹ quioh²¹, la³ cun³ hi³ cuéh³² tsú² jáun² tsɨ́³ uá¹jinh¹ ca³la³ ñí¹ ca³cáɨn³ jmɨ́²chí³ quioh²¹, hi³ jáun² cuɨ́¹ já² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Quí¹ nɨ́¹juáh³ tsá² hnió³ lión³² hnga², tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tsa³hín³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ má¹ná¹, jáun² tsá² la³ hí³ bíh¹ tɨ³ liáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Quí¹ ¿ha³ dá² jinh¹ quien² nɨ́¹juáh³ ca³láɨh¹³ tsú² la³jɨ́³² hi³ zia³² ñí¹ hué²¹ lá², nɨ́¹juáh³ la³ ja³hín³ bíh¹ jmɨ́²chí³ quioh²¹ tsú² má¹lɨ³² jáun²? Quí¹ ¿he³ yáh³ cun³quionh³ lɨ́¹³ joh¹³ tsú² siáh³ jmɨ́²chí³ quioh²¹? ");
INSERT INTO csoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Quí¹ Jon² tsá²mɨ³cuóun² dá² jáunh³ hi³ lin¹ hi³ quien² la³jmɨ́¹ quien² Jméi², la³ má²quionh³ tsá²cuú² tsá²ta³, hi³ jáun² má¹jáun² cué³² hmah²¹ ñí¹con² ma³ quin³² ma³ jan³² tsáu² la³ cun³ rón³² lɨ́³ ta²¹ hi³ lɨ́²jmú³. ");
INSERT INTO csoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jú¹ tson² juo³ jná¹³ hnoh², hi³ zian² tsá² ja¹ ñí¹ tiauh¹ dí² lá² tiá² má²jún³ yáh³ ta³ tiá² má²lɨ́²jɨ́e³ hi³ jná¹³ Jon² tsá²mɨ³cuóun² má²cuá¹ho² ná¹ jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jmɨ́¹ la³ má²jñéi³ jmáɨ¹ jáun² né³, Jesús ca³jan³ Pé¹, Jacobo jɨ³ Juan² dá¹jon²¹ Jacobo nɨ́² siáh³, hi³ ja³taunh²¹ cáun² tsɨ³ máh³ ñe¹ ñí¹ lɨ́¹³ tiánh³ hmóu³²; ");
INSERT INTO csoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","hi³ jáun² ñí¹ jáun² ca³za² ho¹ñí¹ tsú² ñí¹ ta³ ñí¹ tsá² hí³. La³jmɨ́¹ jniá³ joh¹ hiú² jniá³ ñí¹ tsú² lɨ³, hi³ jáun² ha¹ tsú² né³ lɨ³ tiáu² lɨ́n³² la³jmɨ́¹ jniá³ joh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hi³ jáun² cu³diá²jan² jmɨ́¹ ca³jɨ́en³² tsá² hí³ Moisés quionh³ Líh³, hi³ ná¹juónh²³ quionh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jmɨ́¹jáun² ca³juáh³ Pé¹ hi³ ca³záɨh³ Jesús: ―Hnú² Tɨ³², ¡hénh³ ma³ chú³² má²tiauh² dí² ñí¹ lá²! Nɨ́¹juáh³ hnáuh² hnú², jmu¹ jná¹³ hnɨ³² hñú³reh³; cáun² quián¹³ hnú², cáun² quioh²¹ Moisés hi³ cáun² siáh³ quioh²¹ Líh³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² bíh¹ Pé¹ ja³ cáun² jnie² zɨ́n³ lɨ́n³² hi³ ca³tsáɨnh³² tsú² jɨ³lɨn²; hi³ jáun² ja¹ jnie² jáun² ñí¹ca³hléh³ jan² tsáu² hi³ ñí¹juah²¹: ―Tsá² lá² bíh¹ Jón³² jná¹³, jan² Tsá² hno³ lɨ́n³² ná¹, Tsá² jlánh¹ lɨ́²hiún² tsɨn³² jná¹³ hi³ ca³tɨn¹. Niéi² náh² la³ cun³ hi³ juáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² hí³ jáɨ¹³ nɨ́² né³, ca³juénh² lɨ́n³² bíh¹, hi³ jáun² ca³di³jñí³² ca³la³ hi³ ca³jmú³ rá¹hin³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hi³ jáun² Jesús ca³ja³janh³² ñí¹ tionh¹ tsú², hi³ ca³tí³ cuo² quioh²¹ tsú², hi³ ca³záɨh³ dí² la³ lá²: ―Nú¹ tianh³ náh²; ha³ lɨ́² juenh³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hi³ jáun² jmɨ́¹ ca³jɨ́e³ tsú² né³, tiú²uú² hin² zian² hí¹ jan² yáh³, jɨ́³²la³ hnga² bíh¹ jéi³²í¹ Jesús zenh². ");
INSERT INTO csoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tá¹la³ ná¹son² tsú² jáun² tsɨ³ máh³ né³, ca³jmú³ Jesús héih³² hi³ ca³juáh³: ―Ha³ lɨ́² hin² juoh² náh² hí¹ jan² la³ cun³ hi³ má²lɨ́²jɨeh³, ca³la³ tɨ³ nɨ́¹ má¹ca³jenh¹³ jná¹³ Jon² tsá²mɨ³cuóun² ja¹ hla¹ máh³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jmɨ́¹jáun² ca³ngáɨ³ tsá² haɨn²¹ hí³ tɨ³ con² Jesús hi³ ca³juáh³: ―¿He³ láɨh³² sa³ juáh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ hi³ Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³² bí¹ néh¹ tín² jáunh³ la³ñí¹? ");
INSERT INTO csoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jáun² hí³ né³ ca³ngáɨ³: ―Tson² bíh¹ cu³tí³ hi³ Líh³ bíh¹ tín² jáunh³, hi³ ja³ma³re² jɨ³lɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tɨ³la³ jná¹³ juanh³² hi³ má²cuán² bíh¹ Líh³, tɨ³la³ tiá² hin² ca³lɨ³ cuóu³² yáh³, hi³ jáun² dá² ca³jmúh³² bíh¹ tsú² tsú² la³ cun³ hi³ hnió³ jmu³. La³ jáun² bíh¹ siáh³ ma³tso² Jon² tsá²mɨ³cuóun² tsɨ́³ hi³ jmu³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jmɨ́¹jáun² ca³lɨ³tsɨn² tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ hla¹ Juan² tsá² tɨ́² ziau² jmáɨ² bíh¹ la³ hí¹hɨen² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jmɨ́¹ ca³cha³tánh¹ tsú² siáh³ ñí¹ tionh¹ jáun² tsá² juóun³² lɨ́n³² hí³ né³, ja³ jan² tsá²ñuh² ñí¹con² Jesús hi³ ca³di³jñí³² ñí¹ hó²¹ñí¹ tsú² hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tɨ³², cuɨ́¹ já² mií³ honh² nú² quioh²¹ jón³² jná¹³, quí¹hliá² zian² tsú² tsá¹ lɨ́¹ jún²³ hi³ jáun² má²tso² lɨ́n³² tsú² tsɨ́³; quí¹ hiú² cuóh³² bíh¹ quɨnh² tsú² chu³ sɨ́² ho³lá²dá² chu³ jmáɨ² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Cua³jan³² jná¹³ tsú² ñí¹con² tsá² haɨn²¹ lá² tɨ³ con² hnú², tɨ³la³ tiá² ca³tioh²¹ yáh³ tsú² hi³ jmah³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jáun² Jesús ca³ngáɨ³: ―¡Hnoh² tsá² tiá² ta²¹ táunh²³ náh², tsá² cáun² lɨ́¹ cháunh²³ chinh³² la³ siáh³! ¿Jáh³ jmáɨ¹ máh³ hniáuh³² hi³ ngɨ́¹³ jná¹³ quiúnh¹ hnoh² dúh¹? ¿Jáh³ jmáɨ¹ máh³ hniáuh³² hi³ tion¹ jná¹³ tsɨn³² hi³ ca³tɨn¹ hnoh²? Ñá²jan³² ñú²míh¹ tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jmɨ́¹jáun² ca³jin³ Jesús jmɨ́²chí³ hláɨnh¹, hi³ ca³jmú³ dí² héih³² hi³ cua³haɨn³² hñu³ tsɨ́³ ñú²míh¹ hí³, hi³ jáun² la³ cun³ jmɨ́¹jáun² lan³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jmɨ́¹ má²lɨ³² jáun² ca³liéih³² tsá² haɨn²¹ hí³ tɨ³ con² Jesús cáun² ñí¹ tɨ³ có³², hi³ ca³ngáɨ³ jáɨ¹³ lá²: ―¿He³ láɨh³² sa³ tiá² ca³tiau¹³ yáh³ jnoh¹ hi³ chin¹³ jmɨ́²chí³ hláɨnh¹ hí³? ");
INSERT INTO csoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jáun² Jesús ca³juáh³: ―Cun³ñí¹ hi³ tiá² re² má²nio² cáun² honh² bíh¹ hnoh². Quí¹ jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², sá¹jmɨ́¹ hi³ ná¹tioh³ cáun² honh² náh² uá¹jinh¹ ma³ pih²¹ lɨ́n²¹ la³ cun³ tí³ cá² máɨ³ mɨ³ mostaza, jmɨ́¹ lɨ́¹³ bíh¹ juoh¹ náh² máh³ zeh² nɨ́² la³ lá²: “¡Quin³² ñí¹ lá², tɨ³ ó³² cua³²!”, hi³ jáun² máh³ nɨ́² jmɨ́¹ lɨ́¹³ quin³. Hí¹ cáun² yáh³ tiá² hi³ juóuh³² lɨ́¹³ nɨ́¹juáh³ hi³ tson² nio² cáun² honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tɨ³la³ jmɨ́²chí³ hláɨnh¹ la³ nɨ́² má¹ná¹, jɨ́³²la³ cun³quionh³ hi³ liéinh³² tsú² Dió³² jɨ³ hi³ má²hɨen²¹ bíh¹ tsú² lɨ́¹³ tioh²¹ hi³ chin¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jmɨ́¹ lɨ²¹ jáun² né³, tá¹la³ jmɨ́¹ ñi³táunh¹ tsú² cu³lɨ²¹ hué¹³ Galilea, Jesús ca³záɨh³ siáh³ tsá² hí³ la³ lá²: ―Jná¹³, Jon² tsá²mɨ³cuóun² jɨenh³ tsú² jo³cuo² tsáu², ");
INSERT INTO csoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","hi³ jáun² jngah³ tsú², tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² né³, jenh¹³ bíh¹ jná¹³. Hlaɨh³ lɨ́n²¹ bíh¹ ca³ta³no¹ tsɨ́³ tsá² hí³ cun³quionh³ jáɨ¹³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jmɨ́¹ cá¹chánh²¹ Jesús já¹ juú² Capernaum quionh³ tsá² haɨn²¹ hí³ tɨ³ con² né³, jáun² *tsá² chi² hmah²¹ tiáunh¹ cuáh³² chín¹ ca³cha³táunh¹ hi³ mɨ³² tun³ *cú¹tiáu², hi³ ca³záɨh³ Pé¹ la³ lá²: ―¿Tiá¹ ma³hmah¹ tɨ³² juóuh³² hnoh² hmah²¹ hi³ ca³tɨn¹ cuáh³² chín¹? ");
INSERT INTO csoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jáun² Pé¹ ca³juáh³: ―Ján³. Hi³ jáun² né³, jmɨ́¹ hein²¹ Pé¹ ñéih³ né³, Jesús tín² ca³hléh³ la³ñí¹ hi³ ca³juáh³: ―¿He³ lánh³ lɨ́n²³ hnú² Sí¹mu²¹? ¿Hin² ñí¹con² caɨ³² tsá² ná¹lɨ́n³ re²¹ ñí¹ hué²¹ lá² hmah²¹ jɨ³ la³jɨ́³² quɨe³ hi³ lɨ³ hniáuh³²: hí¹ tsá²co¹ tsú², ho³ tsá² siánh³ uá¹? ");
INSERT INTO csoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jáun² Pé¹ ca³juáh³: ―Tsá² siánh³ bíh¹. Hi³ jáun² Jesús ca³juáh³: ―Hi³ jáun² tiá² la³ má²hmah¹ yáh³ tsá²co¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tɨ³la³ hí¹ jan² yáh³ tsáu² tiá² hniáuh³² jmú¹³ dí² hi³ míh³ tsɨ́³, jáun² cua³² tɨ³ ñí¹ nio¹ jmáɨ² lɨ́¹ ná¹ho³, hi³ cuá²héi³ mɨ³quɨe³; hi³ jáun² ho³ juo¹³ la³ñí¹ hi³ janh²¹ nú² hí³ bíh¹ hu²¹ cáun² quɨe³ hu²¹ quiún³ cú¹tiáu² hi³ la³ cun³ má²tsɨn¹³ hi³ má¹hmah²¹ nú² quioh²¹ hmah²¹ hi³ chi² tsú² quion²¹ jná¹³ jɨ³ hi³ quián¹³ nú² huen² nɨ́² siáh³; hi³ jáun² cuá²ma³hmah²¹ nɨ́¹ má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jmáɨ¹ jáun² ca³ja³janh³² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ñí¹ zenh¹ hi³ ca³juáh³ la³ lá²: ―¿Hin² bíh¹ tsánh² tsá² má²tionh² jo³cuo² Dió³² jlánh¹ lɨ³ quien²? ");
INSERT INTO csoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jmɨ́¹jáun² ca³teh³ Jesús jan² tsá¹míh¹, hi³ ca³zinh³ dí² ja¹ quioh²¹ tsá² hí³, ");
INSERT INTO csoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","hi³ ca³záɨh³ dí² la³ lá²: ―Jú¹ tson² juanh³² jná¹³ hi³ nɨ́¹juáh³ tiá² zan¹³ náh² hi³ lɨ́n¹³ náh² la³jmɨ́¹ lɨ́n³ jan² tsá¹míh¹, tiá² lɨ́¹³ yáh³ háuh¹ hnoh² jáɨ¹³ quiúnh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hi³ jáun² la³ nɨ́² bíh¹ lɨ́³, hi³ lɨ³ua³ jan² tsá² jmu² hi³ tiá² lin¹ quien² hnga², hi³ jmu² tsú² la³jmɨ́¹ lɨ́n³ jan² tsá¹míh¹ lá², tsá² la³ hí³ bíh¹ tsá² jlánh¹ lɨ³ quien² ja¹ quioh²¹ la³jɨ́n³² tsá² má²tionh² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hi³ lɨ³ua³ jan² tsá² hen³ jan² tsá¹míh¹ la³ lá² chá³² jná¹³, má²lɨ́²he³ jɨ³ jná¹³ bíh¹ tsú² jaun³². ");
INSERT INTO csoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","”Jáun² né³, lɨ³ua³ jan² tsá² jmu³ hi³ tánh³² tso³ tsá¹míh¹ tsá² taunh² jná¹³ lá² ta²¹, tɨ³ jlánh¹ bíh¹ re² sá¹jmɨ́¹ hi³ tónh³² tsú² zié³ láɨ¹ tsá² la³ hí³ hi³ chí¹hñéih²³ cáun² tá² quɨ́n¹ pa²¹ lɨ́n²¹, hi³ jáun² jmɨ́¹ taun³ tsú² ca³la³ tɨ³ ñeh² jmɨ́²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Jlánh¹ hlah³ quioh²¹ tsá² zian² hngá¹máh³ lá² cun³ñí¹ hi³ jlánh¹ hliáun³ ñí¹ hi³ zia³² hi³ lɨ́¹³ jmu³ hi³ tánh³² tsú² tso³! Tiú² nio² bíh¹ lɨ³ zia³², tɨ³la³ ¡jlánh¹ bíh¹ juo²³ tsá² jmu³ hi³ tánh³² tsáu² tso³! ");
INSERT INTO csoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","”Cun³ñí¹ hi³ jáun² bíh¹, nɨ́¹juáh³ cuonh² hnú² ho³lá²dá² tanh¹ nú² jmu² hi³ tanh³² hnú² tso³, tɨ³ re² hná¹ hi³ jáun² tiáun² ñí¹ uóunh³; quí¹ tɨ³ re² bíh¹ hi³ cuánh¹³ nú² ta³ tiúnh¹ cáun² cuonh² ho³ hi³ tiúnh¹ cáun² tanh¹ ñí¹ lɨ́¹³ zian² nú² cun³ jmɨ́¹hi³nio² la³ cónh³ bí¹ hi³ cuóh¹³ nú² ja¹ sɨ́² cun³ jmɨ́¹hi³nio² quionh³ tá¹ tun³ cuonh² ho³ tá¹ tun³ tanh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Hi³ nɨ́¹juáh³ mɨ́¹máh¹ nú² jmu² siáh³ hi³ tanh³² nú² tso³, chí³ cú²jueh³² hi³ jáun² tiáun² ñí¹ uóunh³; quí¹ tɨ³ re² bíh¹ cuánh¹³ nú² cun³quionh³ cá² máɨ³ mɨ́¹máh¹ ñí¹ lɨ́¹³ zian² nú² cun³ jmɨ́¹hi³nio², la³ cónh³ bíh¹ hi³ cuóh¹³ nú² quiu³juóu³² quionh³ tá¹ tun³ máɨ³ mɨ́¹máh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”Hi³ jáun² né³, ha³ lɨ́² jmú² náh² hi³ tiá² jéin²³ náh² lɨ³ua³ jan² tsá² tiá² má²hún¹ tsɨ́³ la³jmɨ́¹ lɨ́n³ tsá¹míh¹ lá². Quí¹ jná¹³ juanh³² hi³ tsá²cuú² tsá²ta³ Ñuh³² jná¹³, la³ cun³ tsá² tanh² hó¹ñí¹ tsá² la³ nɨ́², tsá² hí³ bíh¹ tionh² ñí¹ hó²¹ñí¹ Ñuh³² jná¹³ jmáɨ¹ ca³la³ jɨ́³² tɨ³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Quí¹ jná¹³ dá² Jon² tsá²mɨ³cuóun² ja³ ná¹ hi³ ja³hnáh³² tsá² ná¹cuɨn² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”¿Ha³ lánh³ lɨ́n²³ hnoh²? Nɨ́¹juáh³ jan² tsáu² tiónh³² hña³láun³ *já¹ziáh², hi³ nɨ́¹juáh³ la³ ja³háɨn³ jan² jáh³ hí³ né³, ¿há¹ tiá² chan³ tsú² jáh³ quiéinh³ nio² quiú³ tsɨ²¹ quia³ñu³ hí³ ñí¹ má²zenh² jáun², hi³ jáun² tsa³tɨ́² tsa³ngɨ́² hi³ hnah² jáh³ ja³háɨn³ hí³? ");
INSERT INTO csoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hi³ nɨ́¹juáh³ ca³chanh²¹ tsú² né³, tɨ³ jlánh¹ bíh¹ tsah³ tsú² cun³ñí¹ hi³ tsanh²¹ jáh³ jan² hí³ la³ cónh³ bíh¹ hi³ ca³tɨn¹ jáh³ quiéinh³ nio² quiú³ tsɨ²¹ quia³ñu³ hi³ tiá² já²cuɨn³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ja³bí¹ la³ jáun² Ñeh² hnoh² Tsá² cuá³ hñu³mɨ³cuú² tiá² hnió³ yáh³ hi³ lɨ́¹ tsa³hín³ lɨ³ua³ jan² tsá² lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá¹míh¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”Nɨ́¹juáh³ jan² renh² nú² jmu² cáun² hi³ hlah³ ñí¹con² nú², cuá²lienh¹ tín² ñí¹ hnga² hi³ cuá²zéih³ la³ cun³ hi³ lɨ́²jmú³. Nɨ́¹juáh³ ca³ngɨ¹³ tsú² jáɨ¹³, jáun² má²ca³janh²¹ bíh¹ nú² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tɨ³la³ nɨ́¹juáh³ tiá² jáɨ¹³ ngɨ²³ yáh³ tsú², jáun² né³, tiéh³ conh³í¹ jan² ho³ gon³ tsáu², hi³ jáun² tsá² hí³ lɨ́n³ tsá² nau³² jáɨ¹³ nɨ́¹juáh³ ha³ lánh³ ca³juáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hi³ nɨ́¹juáh³ cun³ jáun² bíh¹ tiá² jáɨ¹³ ca³ngɨ¹³ tsú², hi³ jáun² zéih³ cú²jueh³² la³jɨ́n³² tsá² cuáh³². Hi³ nɨ́¹juáh³ cun³ jáun² bíh¹ tiá² jáɨ¹³ ca³ngɨ¹³ tsú² ñí¹con² tsá² lɨ́n³ cuáh³², jáun² jɨen¹ tsú² cú²jueh³² la³jmɨ́¹ jɨen¹ nú² jan² tsá² tiá² Dió³² má²cuóun³², ho³ la³jmɨ́¹ jɨen¹ nú² jan² *tsá² chi² hmah²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","”Jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ cáun² hi³ hñeih²¹ hnoh² ñí¹ hué²¹ lá², má²chí¹hñéih²³ bíh¹ siáh³ hñu³mɨ³cuú², hi³ jáun² lɨ³ua³ cáun² hi³ zaɨh²¹ hnoh² ñí¹ hué²¹ lá² né³, ja³bí¹ hñu³mɨ³cuú² siáh³ má²záɨh³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”Ja³bí¹ juanh³² jná¹³ siáh³, nɨ́¹juáh³ gon³ náh² jmúh¹³ náh² cá²honh¹ ñí¹ hué²¹ lá² hi³ lienh¹ náh² Dió³² ca³tɨ²¹ cáun² hi³ hnáuh² náh² mɨ́h¹, jáun² cué³² bíh¹ Ñuh³² jná¹³ Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Quí¹ nɨ́¹juáh³ ñí¹ ná¹ngɨh³² tsú² gon³ gáun³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³, jáun² ja¹ quioh²¹ tsá² hí³ bíh¹ zenh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jáun² Pé¹ ngau³ hi³ ca³ñí¹ngah¹ Jesús: ―Tɨ³², ¿jáh³ jéin³² lɨ́¹³ chin²¹ jná¹³ tsɨn³² hi³ ca³tɨ²¹ hi³ hlah³ hi³ jmu² renh² jná¹³ ñí¹con² ná¹? ¿Hí¹ la³ tɨ³ quiau³ jéin³²? ");
INSERT INTO csoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jmɨ́¹jáun² ca³záɨh³ Jesús Pé¹ la³ lá²: ―Tiá² juanh³² yáh³ jná¹³ quiau³ jéin³², tɨ³la³ la³ tɨ³ hnaɨh³² nio² quiú³ tsɨ²¹ quia³ nio² ma³ quiau³ máh³. ");
INSERT INTO csoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”Cun³ñí¹ hi³ jáun² bíh¹ juanh³² jná¹³, hi³ Dió³² bíh¹ jan² Tsá² juenh² lɨ́n³² tsɨ́³ ñí¹con² tsá² má²tionh² jo³cuo²; la³jmɨ́¹ ca³jmú³ jan² re²¹ hi³ ca³lɨ³hnió³ caun¹³ quɨe³ hi³ jmɨ́¹ nio² jo³cuo² ma³ quin³² ma³ jan³² tsá² joh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tá¹la³ má²cuá¹jɨ́e²³ tsú² nɨ́¹juáh³ hin² tsánh² ca³dánh² hi³ hin² tsánh² tiá² ca³dánh², jmɨ́¹jáun² cua³jan² tsú² jan² tsá² jmɨ́¹ la³ ca³dánh² hliáun³ mí²yaun²¹ cu³tí¹³ héih³² quɨe³. ");
INSERT INTO csoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tɨ³la³ tsá² hí³ má¹ná¹, tiá² jmɨ́¹ zia³² yáh³ he³ lánh³ rón³² cháu³² quɨe³ jáun², jáun² re²¹ hí³ né³ ca³jmú³ héih³² hi³ hna³ tsú² cú²jueh³² tsá² hí³ hi³ lɨ́n¹³ *tsá² dí¹hlánh¹ la³ má²quionh³ la³jɨ́n³² tsá² hñú¹³, jɨ³ la³jɨ́³² la³ cun³ hi³ zioh² tsú² nɨ́² siáh³, hi³ jáun² lɨ³hmáh¹ la³jɨ́³² hi³ ca³lɨ³ren² tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jmɨ́¹jáun² ca³di³jñí³² tsá² hí³ ta³ ñí¹ re²¹ hí³, hi³ jáun² ca³hiu³ ca³mɨ́³ hi³ juáh³: “Hnú² juóu³² jná¹³, juenh² lɨ́n³² jmu³ honh² hi³ ca³tɨn¹ jná¹³, má¹hmah²¹ bíh¹ jná¹³ jɨ³lɨ³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jáun² re²¹ hí³ né³ ca³ja³ mií³ tsɨ́³, hi³ jáun² ca³chin² dí² cú²jueh³² tsɨ́³ ca³tɨ²¹ la³jɨ́³² hi³ ca³dánh² tsá² hí³, hi³ jáun² ca³lión³² bíh¹ dí² cú²jueh³². ");
INSERT INTO csoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”Tɨ³la³ tsá² hí³ né³, la³ cun³ jmɨ́¹ cuá¹han³ jáun² bíh¹ ca³jenh² jan² tsá² quian²¹ raɨnh²¹, tsá² jmɨ́¹ la³ ren² hña³láu³ *cú¹tiáu² quioh²¹. Jáun² ca³cuɨ́h³ dí² láɨ¹ tsá² hí³ hi³ ca³záɨh³ dí² la³ lá²: “¡Ma³hmah²¹ la³ cun³ hi³ ren² nú² quion²¹ ná¹!” ");
INSERT INTO csoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jáun² tsá² hí³ siáh³ ca³di³jñí³² ñí¹ hó²¹ñí¹ dí² hi³ ca³hiu³ ca³mɨ́³ ñí¹con² tsú², hi³ juáh³ la³ lá²: “Juenh² jmu³ honh² ñí¹con² jná¹³, má¹hmah²¹ bíh¹ jná¹³ la³jɨ́³² hi³ quián¹³ hnú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tɨ³la³ tsá² hí³ má¹ná¹, tiá² ca³jmú³ yáh³ juenh² tsɨ́³, hñu³mí¹ñí² bíh¹ ca³tanh² dí² ca³la³ ñí¹ ca³ma³hmah¹ jɨ³lɨ³² hi³ jmɨ́¹ ren². ");
INSERT INTO csoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jmɨ́¹ ca³jɨ́e³ tsá² quian²¹ ñí¹ hná¹ jáun² hi³ ca³jmú³ tsá² hí³ la³ jáun², jáun² hlah³ lɨ́n²¹ bíh¹ ca³jeinh²¹, hi³ jáun² já¹tanh²¹ hi³ ca³ñí¹zeh¹ juo¹³ la³jɨ́³² la³ cun³ hi³ má²lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jmɨ́¹jáun² ca³jmú³ juo¹³ tsú² héih³² hi³ ca³ñí¹tieh¹ tsú² tsá² hí³, hi³ ca³záɨh³ dí²: “¡Hnú² tsá² quian²¹ hláɨh¹! Jná¹³ lɨ́²chín³² tsɨn³² la³jɨ́³² hi³ jmɨ́¹ ren² nú² jáun², quí¹hliá² lɨ́²hiú¹ lɨ́²mɨ́h¹ hnú²; ");
INSERT INTO csoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ja³bí¹ hnú² siáh³ jmɨ́¹ hniáuh²¹ jmúh¹³ juenh² honh² hi³ ca³tɨn¹ renh² nú² la³jmɨ́¹ lɨ́¹jmú²¹ jná¹³ juenh² tsɨn³² ñí¹con² hnú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jáun² juo¹³ tsú² hí³ ca³míh³ lɨ́n³² bíh¹ tsɨ́³, hi³ jáun² ca³jmú³ tsú² héih³² hi³ ma³tson¹³ tsú² tsá² quian²¹ hí³ ca³la³ ñí¹ ca³ma³hmah¹ tsú² la³jɨ́³² hi³ ren². ");
INSERT INTO csoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jmɨ́¹jáun² ca³ma³táuh³² Jesús jáɨ¹³, hi³ ca³juáh³ la³ lá²: ―Ja³bí¹ la³ nɨ́² siáh³ jmu³ Ñuh³² jná¹³ Tsá² cuá³ hñu³mɨ³cuú² ñí¹con² ma³ quin³² ma³ jan³² hnoh² nɨ́¹juáh³ tiá² chin¹³ náh² honh² ca³la³ jonh³ jmɨ́¹ honh² náh² tsáu¹³ renh² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³jɨ́³² jáɨ¹³ nɨ́² né³, cua³han³ hué¹³ Galilea hi³ ngau³ tɨ³ hué¹³ Judea nio² jo²¹ cua³ Jordán juɨ³² ñí¹ hia³² hiú². ");
INSERT INTO csoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Juóun³² lɨ́n³² bíh¹ tsáu² ja³taunh²¹ cu³hna²¹ tsú², hi³ jáun² ñí¹ jáun² ca³jmah³ tsú² juóun³² lɨ́n³² tsá² tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jáun² ma³ jan² tsá² *fariseos ca³ma³janh³² ñí¹ zenh¹ Jesús hi³ ca³ca³ ca³lan³ dí² tsú²; hi³ ca³juáh³ la³ lá²: ―¿Hí¹ lɨ́¹³ tun³ tsú² ñí²cuo² cun³ñí¹ hi³ ca³tɨ²¹ lɨ³ua³ cáun² uu³mí²tsɨ³² pih²¹ hi³ zia³²? ");
INSERT INTO csoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jáun² hí³ dí² né³ ca³ngáɨ³ la³ lá²: ―¿Tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³²?, ñí¹ rá¹juáh³ jáun² hi³ Tsá² ca³jmú³ la³ cu³ la³ juéh³ mɨ³cuú²: “Tsá²mɨ³ tsá²ñuh² bíh¹ ca³jmú³ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ja³bí¹ ca³juáh³ tsú² siáh³ la³ lá²: “Cun³ñí¹ hi³ jáun² bíh¹ chan³ tsá²ñuh² jméi² mí¹ziú¹³ tɨ³ có³², hi³ jáun² ma³zian² cu³lɨ²¹ quionh³ tsá²mɨ³ ñí²cuo², hi³ jáun² la³juah²¹ dúh¹ jan² tsáu² bíh¹ má²lɨ́n¹³ tsú² tá¹ gon³”. ");
INSERT INTO csoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Hi³ jáun² né³, tiú²uú² lɨ́³ yáh³ gon³ tsú², quí¹ jan² tsáu² bíh¹ má²lɨ́n³ tsú². Cun³ñí¹ hi³ jáun² bíh¹ tiá² ca³tɨn¹ tsá²mɨ³cuóun² tson³ cáun² hi³ má²lɨ́²cunh³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jáun² jmɨ́¹jáun² ca³ngáɨh³ tsú² Jesús: ―¿Nɨ́¹juáh³ la³ nɨ́² né³, jáun² he³ láɨh³² ca³jmú³ hla¹ Moisés héih³² hi³ hniáuh³² hiáuh³ tsá²mɨ³ cáun² sí² hi³ ca³tɨ²¹ hi³ tsáun³ quionh³ ñí²cuo², hi³ jáun² má¹jáun² má²lɨ́¹³ tún³ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jáun² Jesús ca³juáh³ siáh³: ―Cun³ñí¹ hi³ jlánh¹ tiá² jáɨ¹³ ngɨ²³ hnoh² bíh¹ jaun³², hi³ jáun² bí¹ ca³cué³ hla¹ Moisés jáɨ¹³ hi³ lɨ́¹³ tsáun³ tsú² quionh³ tsá²mɨ³ ñí²cuo²; tɨ³la³ tiá² la³ nɨ́² jmɨ́¹ lɨ́³ yáh³ jmɨ́¹ ca³jmú³ Dió³² la³ cu³ la³ juéh³ mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jná¹³ juanh³² hi³ lɨ³ua³ jan² tsá² tun²³ tsá²mɨ³ ñí²cuo², hi³ jáun² jéinh³² siáh³ cuo² quionh³ tsá²mɨ³ siánh³, cun³quionh³ la³ jáun² má²lɨ́²jmú³ tsú² tso³ juón¹ bíh¹. Jɨ́³²la³ ti³ nɨ́¹juáh³ hnga² bíh¹ tsá²mɨ³ ñí²cuo² tsú² tín² ca³liéinh³² tsá²ñuh² siánh³, jáun² bíh¹ zia³² jáɨ¹³ tun³ tsú² tsá²mɨ³. Ja³bí¹ má²lɨ́n³ jan² tsá² lɨ́¹ jmú² lɨ́¹ tsau³² bíh¹ tsú² nɨ́¹juáh³ hi³ ca³jéinh³² cuo² quionh³ jan² tsá²mɨ³ tsá² má²lɨ́²te³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jáun² jmɨ́¹jáun² ca³juáh³ tsá² haɨn²¹ hí³ tɨ³ con² tsú²: ―Nɨ́¹juáh³ la³ nɨ́² bíh¹ la³ lɨ́³ hi³ ca³tɨn¹ tsá²ñuh² quionh³ tsá²mɨ³ ñí²cuo², tiá² lin¹ ñí¹ quien² yáh³ hi³ la³ jéinh³² tsú² cuo². ");
INSERT INTO csoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jáun² Jesús ca³juáh³: ―Tiá² la³jɨ́n³² tsáu² ngɨ²³ yáh³ hi³ nɨ́², jɨ́³²la³ tsá² hí³ bíh¹ ngɨ²³ tsá² má²ca³hiauh³ jáɨ¹³ hi³ ngɨ¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Zia³² bíh¹ hliáun³ ñí¹ ca³tɨ²¹ he³ láɨh³² tiá² lɨ́¹³ jéinh³² tsáu² cuo²: quí¹ zian² tsá²ñuh² tsá² má²tiéh³ la³ cun³ nɨ́¹ má¹ca³lɨ³zian² máh³, zian² né³ *tsá² tiéh³ hi³ ca³jmú³ tsá²mɨ³cuóun² bíh¹, hi³ zian² né³ tsá² jmu² hnga² hi³ lɨ́n³ la³juah²¹ dúh¹ tsá² tiéh³ cun³ñí¹ hi³ hnió³ hi³ ma³zian² tán¹ hián² cu³tí¹³ ñí¹con² Dió³². Jáun² lɨ³ua³ jan² tsá² lɨ́¹³ ngɨ¹³ jáɨ¹³ nɨ́², cuɨ́¹ ngɨ¹³ tsú² re². ");
INSERT INTO csoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jáun² né³, jmɨ́¹jáun² cua³jan² tsáu² ma³ jan² tsá¹míh¹ ñí¹con² Jesús, hi³ hnió³ tsú² hi³ ra³tsɨ³² Jesús cuo² ñí¹ quioh²¹ tsá¹míh¹ jɨ³ hi³ liéinh³² dí² siáh³ Dió³²; tɨ³la³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, ca³jin³ bíh¹ tsá² ná¹jan² hí³ tsá¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tɨ³la³ Jesús né³ ca³záɨh³ tsá² hí³: ―Cuéh³ náh² tsá¹míh¹ nɨ́² jáɨ¹³, cuɨ́¹ ja³táunh¹ ñí¹con² jná¹³, ha³ lɨ́² jnɨ́² náh² juɨ³² quioh²¹; quí¹ tsá² lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá¹míh¹ nɨ́² bíh¹ lɨ́¹³ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jáun² ca³ra³tsɨ³² tsú² cuo² ñí¹ quioh²¹ tsá¹míh¹; jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ tsú² ñí¹ jáun² hi³ ngah³. ");
INSERT INTO csoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jáun² né³, ca³chó³² cáun² jmáɨ¹ hi³ ñéi¹ jan² tsá² tsá¹ñú¹ hi³ ca³ñí¹jɨen¹³ Jesús, hi³ ca³ngáɨ³ hi³ juáh³ la³ lá²: ―Hnú² Tɨ³², ¿he³ ñí¹ hi³ chu²¹ hniáuh³² jmu¹ jná¹³ hi³ jáun² lɨ́¹³ lɨ³ zian² jná¹³ la³ cun³ jmɨ́¹hi³nio²? ");
INSERT INTO csoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jáun² Jesús ca³ngáɨ³ hi³ ca³juáh³: ―¿He³ láɨh³² hngaɨh³² hnú² ca³tɨ²¹ hi³ chu²¹? Quí¹ jɨ́³²la³ jan² tán¹ bíh¹ Tsá² chun¹ zian². Tɨ³la³ nɨ́¹juáh³ hi³ hnáuh² hnú² hi³ lɨ́¹³ zian² nú² la³ cun³ jmɨ́¹hi³nio², ma³ti²¹ ca³la³ jɨ́³² héih³² quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jáun² ca³juáh³ tsá¹ñú¹ hí³ la³ lá²: ―¿La³ cun³ he³ jaun³² né³? Hi³ jáun² Jesús ca³juáh³: ―Ha³ lɨ́² jngɨh³ náh² tsáu², ha³ lɨ́² jmu² náh² juón¹, ha³ lɨ́² háɨn², ha³ lɨ́² lɨ́¹ ma³tson¹³ cáun² jú¹ tɨ́¹jáɨ², ");
INSERT INTO csoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","tianh³² ta²¹ ñeh² mí²ziúh², hi³ ma³hno¹ siáh³ tsá²mɨ³cuóun² renh² nú² la³jmɨ́¹ hno³ nú² huen². ");
INSERT INTO csoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jáun² tsá² tsá¹ñú¹ hí³ ca³juáh³: ―La³jɨ́³² bíh¹ hi³ nɨ́² má²ca³ma³ti²¹ jná¹³; ¿zia²¹ siáh³ cáun² hi³ lɨ³hniauh²³ ñí¹ hná¹ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jmɨ́¹jáun² ca³juáh³ Jesús: ―Nɨ́¹juáh³ hi³ hnáuh² hnú² hi³ lɨ́n¹³ nú² jan² tsá² chun¹ cun³ tán¹ cun³ hián², jáun² cuánh², cuá²hnáɨ¹ la³jɨ́³² hi³ zia³² quián¹³, hi³ jáun² tsoh³ quɨe³ jáun² ñí¹con² tsá² tia³mii², hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ lɨ³ hánh³ nú² hñu³mɨ³cuú²; nɨ́¹ má¹lɨ³² jáun² né³, ña³² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tɨ³la³ jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² tsá¹ñú¹ hí³ jáɨ¹³ nɨ́² né³, jmɨ́¹jáun² ngah³ hi³ má²hí¹uɨ́n³ lɨ́n³² tsɨ́³, quí¹hliá² jlánh¹ jmɨ́¹ hánh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hi³ jáun² Jesús né³ ca³juáh³ hi³ ca³záɨh³ tsá² haɨn²¹ hí³ tɨ³ con²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ jlánh¹ bíh¹ juóuh³² hi³ hí³ jan² tsá² hánh³ jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Juanh³² jná¹³ siáh³ ñí¹con² hnoh², hi³ tɨ³ jlánh¹ bíh¹ huán¹ tsɨ́³ hi³ ngá¹³ jáh³ cánh¹ téh²³ tsú² camello chí² léh¹³ mɨ³quɨe³ la³ cónh³ bíh¹ hi³ hí¹³ jan² tsá² hánh³ jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáɨ¹³ nɨ́² né³, ca³ja³cáun² lɨ́n³² bíh¹ tsɨ́³ tsú², hi³ jáun² ca³ngáɨh³ raɨnh²¹ tsá²ján² tsá²ján² hi³ ca³juáh³ la³ lá²: ―¿Hi³ jáun² né³, hin² bí¹ dá² tsánh² la³ lɨ́¹³ liáun³ jaun³²? ");
INSERT INTO csoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jáun² Jesús ca³jɨ́e³ ñí¹ tionh¹ tsú², hi³ ca³záɨh³ dí² la³ lá²: ―Tiá² tɨn² yáh³ tsá²mɨ³cuóun² jmu³ hi³ nɨ́², tɨ³la³ ñí¹con² Dió³² má¹ná¹, hí¹ cáun² yáh³ hi³ juóuh³² tiá² zia³². ");
INSERT INTO csoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jáun² jmɨ́¹jáun² ca³juáh³ Pé¹ la³ lá²: ―Sa¹nɨ́² jɨe³, jnoh¹ má²ca³chá¹³ tɨ³ có³² la³jɨ́³² hi³ jmɨ́¹ zia³² quiú¹³, hi³ jáun² má²ngɨ́¹ jnoh¹ quiúnh¹ hnú². Jáun² né³ ¿he³ dá² lɨ³ zia³² quiú¹³ jnoh¹? ");
INSERT INTO csoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jáun² jmɨ́¹jáun² ca³záɨh³ siáh³ Jesús tsá² hí³ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ jmáɨ¹ hi³ la¹³ jáun² hmaɨ²¹ ca³la³ jɨ́³² hi³ zia³², jmáɨ¹ hi³ tá¹cuón¹ jáun² Jon² tsá²mɨ³cuóun² ñí¹ hmá²sɨ¹ quien² quioh²¹, ja³bí¹ hnoh² uá²jaɨ³² lɨ³ zia³² quia³tún³ hmá²sɨ¹ ñí¹ cuá¹tianh³ náh², hi³ cuá¹quiánh² náh² jú¹ tson² quioh²¹ tá¹ quia³tún³ tsoh³ tsá² *Israel. ");
INSERT INTO csoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hi³ jáun² la³jɨ́n³² tsá² má²ca³chan³ jméi² mí¹ziú¹³, jɨ³ tsá²mɨ³ tsá²ñuh² raɨnh²¹, jɨ³ jón²zɨ́h¹, jɨ³ hi³ má²ca³tú³ siáh³ hñú¹³, jɨ³ hué³² quioh²¹ nɨ́² siáh³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³, tsá² la³ hí³ bíh¹ hiáuh³ hña³láu³ nió³ tɨ³ hliáun³ la³ cónh³ bíh¹ hi³ lɨ́²chá³² jáun² tɨ³ có³²; ja³bí¹ hiáuh³ tsú² siáh³ jáɨ¹³ hi³ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tɨ³la³ juóun³² tsá² ná¹lɨ́n³ tsá² la³ñí¹ ta³né³², tsá² la³ hí³ dá² lɨ́n¹³ tsá² ñí¹ ca³táuh³ bíh¹ má¹jáun², hi³ jáun² juóun³² tsá² ná¹lɨ́n³ tsá² ñí¹ cá¹táuh³ ta³né³² né³, tsá² la³ hí³ dá² tɨ³ lɨ́n¹³ tsá² la³ñí¹ bíh¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","”Quí¹ sá¹nɨ́² jɨe³: Nɨ́¹ má¹tɨ³ ñí¹ hiáuh¹³ tsá² tionh² jo³cuo² Dió³² la³ cun³ hi³ hnió³ Dió³² cué³², lɨ́¹³ la³jmɨ́¹ ca³jmú³ jan² tsá² zia³² cáun² ñí¹náɨ² quioh²¹. Jmɨ́¹ ca³juú² mɨ³ uóun²jɨeh¹³ ñí¹náɨ² quioh²¹ tsú², ngau³ tsú² hú²niéi² hi³ já¹tieh¹ tsá² jmu³ ta²¹ ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Jáun² ca³ma³ren²¹ tsú² jáɨ¹³ quionh³ tsá² jmu³ ta²¹ hi³ ma³hmah¹ dí² cáun² *cú¹tiáu², la³ cun³ tí³ quɨe³ hi³ hlánh¹ tsú² cú² jmáɨ¹ ta²¹ ñí¹náɨ², jmɨ́¹jáun² ca³zen³ dí² tsá² hí³ hi³ ja³jmú³ ta²¹ ñí¹náɨ² jáun² quioh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Má²cu³lé³ jáun² cua³han³ tsú² siáh³ cun³ la³ nió¹ ñu³ tɨ³ hú²niéi², hi³ jáun² ja¹ hmah²¹ né³ ca³jenh² tsú² tsá² lɨ́¹ ñi³táunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jáun² ca³záɨh³ dí² tsá² hí³: “Cuá²jmu³ uá²jaɨ³² hnoh² ta²¹ ñí¹náɨ² quion²¹ jná¹³, hi³ jáun² má¹hmah²¹ jná¹³ quián¹³ hnoh² la³ cun³ hi³ ca³tɨ²¹”. Hi³ jáun² tsá² hí³ ja³taunh²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tsá² quioh²¹ ñí¹náɨ² cua³han³ siáh³ la³ cun³ chi³hiú², jáun² siáh³ siáh³ cua³han³ cun³ la³ nio¹ hnɨ³² tɨ³ ca³hláu³, hi³ la³ má²jmu² jáun² bíh¹ hi³ zen² tsáu² ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hi³ siáh³ siáh³ cua³han³ tsú² cun³ la³ nio¹ hñá³ tɨ³ ca³hláu³ hi³ ngau³ siáh³ tɨ³ ja¹ hmah²¹, jáun² ñí¹ jáun² ca³jenh² tsú² siáh³ ma³ jan² tsá² lɨ́¹ ñi³táunh¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: “¿He³ láɨh³² lɨ́¹ tionh¹ hnoh² ñí¹ lá², hi³ tiá² ta²¹ ná¹jmuh³² náh²?” ");
INSERT INTO csoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jáun² tsá² hí³ ca³juáh³: “Quí¹ hí¹ jan² yáh³ tiá² hin² má²lɨ́²tié³ jnoh¹ hi³ jmú¹³ ta²¹”. Jáun² jmɨ́¹jáun² ca³záɨh³ dí² la³ lá²: “Jáun² cuá²táunh¹ hnoh² uá²jaɨ³² hi³ cuá¹jmuh³ ta²¹ ñí¹náɨ² quion²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Tɨ³la³ jmɨ́¹ ca³niéi² jáun² né³, tsá² quioh²¹ ñí¹náɨ² jáun² ca³záɨh³ tsá² nio² ta²¹ jo³cuo² la³ lá²: “Cuá²tieh³ tsá² ná¹jmu² ta²¹, hi³ jáun² ma³hmah²¹ la³ cun³ hmah²¹ quioh²¹ tsú², hi³ má¹liauh²¹ nú² má¹hmah²¹ tín² ñí¹con² tsá² taunh³ chí¹cáɨn², hi³ jáun² táuh³ ñí¹con² tsá² taunh³ la³ñí¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jmɨ́¹jáun² cua³tanh²¹ tsá² ca³taunh³ hná¹ ta²¹ cun³ la³ nio¹ hñá³, hi³ jáun² ma³ quin³² ma³ jan³² ca³héi³ cáun² cú¹tiáu² quioh²¹ jmɨ́¹ cuá¹tanh²¹, la³ cun³ hmah²¹ quioh²¹ cú² jmáɨ¹ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jmɨ́¹ lɨ²¹ jáun² né³ tɨn³ tsá² taunh³ ta²¹ hú²niéi²; tsá² hí³ jmɨ́¹ ná¹lɨ́n²³ hi³ he³ hmah²¹ chí¹lɨ́³ la³ cónh³ bí¹ tsá² taunh³ cáɨn²; tɨ³la³ cun³ jáun² cáun² cú¹tiáu² bíh¹ ca³héi³ tsú² ma³ quin³² ma³ jan³². ");
INSERT INTO csoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jmɨ́¹ tɨ³ ñí¹ he³ tsú² jáun² hmah²¹ quioh²¹ né³, ca³ma³liáu³² jmu² liúnh¹ ñí¹con² tsá² quioh²¹ ta²¹, ");
INSERT INTO csoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","hi³ juáh³ la³ lá²: “Já² cáun² o¹rá¹ tán¹ bíh¹ ta²¹ lɨ́²jmú³ tsá² taunh³ nɨ́² chí¹cáɨn², hi³ cá²ren² bíh¹ má²lɨ́²ma³hmah²¹ hnú² quioh²¹ tsú² quiúnh¹ jnoh¹, tsá² má²lɨ́²má¹tso¹ jnoh¹ tsɨ́³ hná¹ ta²¹ tán¹ jmáɨ¹ jɨ³ hi³ chéi³ hiú² nɨ́²”. ");
INSERT INTO csoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tɨ³la³ tsá² quioh²¹ ta²¹ ca³juáh³ la³ lá² hi³ ca³záɨh³ jan² tsá² hí³: “Sá¹nɨ́² jɨe³ dúh¹, ha³ tiá² cuá¹jmu² yáh³ jná¹³ hí¹ cáun² hi³ tiá² ca³tɨ²¹. ¿Há¹ jun³juáh¹³ lɨ́²jmuh³ hnú² jáɨ¹³ quiúnh¹ jná¹³ hi³ má¹hmah²¹ jná¹³ cáun² cú¹tiáu² la³ cun³ tí³ quioh²¹ cú² jmáɨ¹ ta²¹ bíh¹ dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jánh³² hmah²¹ quián¹³ jáun² cuánh². Quí¹ jná¹³ dá² hnó³² má¹hmah²¹ ñí¹con² tsá² taunh³ nɨ́² chí¹cáɨn² cá²ren² la³ cun³ hi³ má¹hmah²¹ jná¹³ quián¹³ hnú² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Hí¹ tiá² ca³tɨn¹ jná¹³ hi³ jmuh²¹ ta²¹ quɨe³ quion²¹ la³ cun³ tɨ³² tsɨn³² huen² dúh¹? ¿Ho³ hi³ uóu³² honh² uá¹ hnú² cun³ñí¹ hi³ jná¹³ chú³² tsɨn³²?” ");
INSERT INTO csoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","”La³ nɨ́² bíh¹ lɨ́³, hi³ tsá² ñí¹ ca³táuh³ lɨ́n¹³ tsá² la³ñí¹, hi³ jáun² tsá² la³ñí¹ né³ lɨ́n¹³ tsá² ñí¹ ca³táuh³ bíh¹. Quí¹ juóun³² lɨ́n³² bíh¹ tsá² ná¹tén¹, tɨ³la³ cú¹pih²¹ tsáu² bíh¹ tsá² quiánh³ ―ca³juáh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jmɨ́¹ lɨ²¹ jáun² né³, tá¹la³ má²hí¹hún¹ jáun² Jesús juɨ³² hi³ hí¹uú²³ tɨ³ juú² Jerusalén, jáun² ca³teh³ dí² ñí¹ tɨ³ có³² tsá² quian³tun³ hí³ hi³ ca³záɨh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Sá¹nɨ́² jɨe³, ta³né³² má²hí¹uú²³ dí² tɨ³ já¹ juú² Jerusalén, ñí¹ jɨenh³ tsú² jáun² jná¹³ Jon² tsá²mɨ³cuóun² ñí¹con² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́² siáh³, hi³ jáun² tsá² hí³ jmu³ héih³² hi³ ma³nga² tsú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jɨenh³ tsú² jná¹³ ñí¹con² *tsá²cá²jo²¹ hi³ jáun² qui³ cáuh³² tsú² cú²nga¹ jɨ³ hi³ quiu³ po³ dí², hi³ má¹lɨ³² jáun² né³ taun³ tsú² jná¹³ ñí¹ crei²¹; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² má¹ná¹ jenh¹³ bíh¹ jná¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jmɨ́¹jáun² ca³ma³janh³² ñí²cuo² Zebedeo ñí¹con² Jesús quionh³ tá¹ gon³ jon²; tsá²mɨ³ hí³ né³ ca³di³jñí³² ta³ ñí¹ Jesús hi³ ca³mɨ́³ cáun² hi³ chú³². ");
INSERT INTO csoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hi³ jáun² Jesús ca³ngáɨ³: ―¿He³ jmɨ́¹ hnáuh² hnú²? Jáun² tsá²mɨ³ hí³ ca³juáh³ la³ lá²: ―Jmu³ tiá³ hi³ chú³², hi³ nɨ́¹ má¹tɨ³ ñí¹ má²ñi³quien² hnú², tá¹ gon³ jón³² jná¹³ lá² tiánh³² cu³henh¹ hnú², jan² tɨ³ cuá² chu²¹ hi³ jan² tɨ³ cuá² cáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tɨ³la³ Jesús né³ ca³ngáɨ³: ―Hnoh² dá² hí¹juáh³ tiá² ñíh¹ bíh¹ náh² he³ ná¹mɨh³². ¿Hí¹ quɨnh¹ náh² jmáɨ¹ hi³ há¹ ngá¹³ náh² la³ cun³ hi³ há¹ ngá¹³ jná¹³, jɨ³ hi³ zón³² náh² siáh³ jmáɨ² hi³ má¹tsoh¹ honh² la³jmɨ́¹ zón²¹ jná¹³? Jáun² tsá² hí³ né³ ca³juáh³: ―Lɨ́¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jáun² ca³juáh³ siáh³ Jesús: ―Tson² bíh¹ cu³tí³ hi³ hnoh² ha¹ ngá¹³ náh² la³ cun³ hi³ há¹ ngá¹³ jná¹³, jɨ³ hi³ zón³² náh² siáh³ jmáɨ² la³jmɨ́¹ zón²¹ jná¹³; tɨ³la³ hi³ ca³tɨ²¹ hi³ cuá¹tianh³ náh² cu³hén² jná¹³, jan² cuá² chu²¹ hi³ jan² tɨ³ cuá² cáun¹ má¹ná¹, tiá² ca³tɨn¹ yáh³ jná¹³ cué¹³, quí¹ ñí¹ jáun² má²lɨ́³ hua³jan²¹ hi³ tsa³tiánh² tsá² má²ca³quianh³ hnga² bíh¹ Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jmɨ́¹ ca³náɨ³² tsá² quian³ ñí¹ hná¹ jáun² jáɨ¹³ jáun² né³, ca³míh³ tsɨ́³ ñí¹con² tsá² gon³ má²tún² raɨnh²¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tɨ³la³ Jesús má¹ná¹, ca³teh³ jɨ³lɨn² tsá² hí³ hi³ ca³záɨh³ dí² la³ lá²: ―Hnoh² ná¹ñíh¹ hi³ tsá² ná¹ho² ta²¹ ma³ quin³² ma³ caun³² hué³² jmu² quien² ñí¹con² tsá² zian² hué³² jáun², hi³ jáun² tsá² ná¹quien² hí³ né³ cáun² jmu² héih³² ñí¹con² tsá² tionh² hí³ jo³cuo². ");
INSERT INTO csoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Tɨ³la³ tiá² ca³tɨ²¹ yáh³ hi³ lɨ́¹³ la³ jáun² ja¹ quián¹³ hnoh². Quí¹ nɨ́¹juáh³ tsá² hnió³ lɨ³ quien² ja¹ quián¹³ hnoh², hniáuh³² lɨ́n³ tsú² jan² tsá² quian²¹ bíh¹ ñí¹con² tsá² ñí¹ hná¹ jáun²; ");
INSERT INTO csoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","hi³ lɨ³ua³ jan² hnoh² tsá² hnáuh² náh² lɨ́n¹³ tsá² la³ñí¹, hniáuh³² jmúh¹³ náh² hi³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² *tsá² má²dí¹hlánh¹ joh¹ tsá² ñí¹ hná¹ jáun² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hniáuh³² jmu³ tsú² la³jmɨ́¹ jmu² jná¹³ bíh¹ Jon² tsá²mɨ³cuóun². Quí¹ jná¹³ dá² cuan³ ná¹ hi³ ja³ma³con²¹ bí¹ ná¹ tsáu², jun³juáh¹³ hi³ tɨ³ ma³cáu³² yáh³ tsáu² jná¹³; jɨ³ hi³ cuan³ ná¹ siáh³ hi³ jɨenh²¹ ná¹ huen² hi³ jun³, hi³ lɨ́³ cáun² hmah²¹ ca³tɨ²¹ hi³ lɨ́¹³ liáun³ juóun³² lɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jáun² né³, tá¹la³ jmɨ́¹ má²hí¹huen³² tsú² jáun² já¹ juú² Jericó, juóun³² lɨ́n³² bíh¹ tsáu² jmɨ́¹ hí¹já²táunh¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Can³² hú¹ juɨ³² ñí¹ jmɨ́¹ hí¹ja³tánh¹ tsú² jáun² jmɨ́¹ tionh¹ gon³ tsá² ten³; hi³ jáun² jmɨ́¹ ca³náɨ³² tsú² hi³ cuá¹ja³² Jesús, jáun² ca³hóh³² tiá³ hi³ ca³juáh³ la³ lá²: ―¡Hnú² Tɨ³², jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ já² mií³ honh² hnú² quiú¹³ jnoh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jáun² tsá² jmɨ́¹ hí¹já²táunh¹ hí³ né³ ca³jin³ tsá² ten³ hí³, hi³ jmɨ́¹ hnió³ tsú² hi³ tiánh³ tsú² ta³máɨh³; tɨ³la³ tsá² hí³ má¹ná¹, tɨ³ lɨ³mí¹ tiá³ ca³hóh³² bíh¹, hi³ ca³juáh³: ―¡Hnú² Tɨ³², jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ já² mií³ honh² hnú² quiú¹³ jnoh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jáun² Jesús ca³náu², hi³ ca³teh³ dí² tsá² hí³, hi³ jáun² ca³ngáɨh³ dí²: ―¿He³ jmɨ́¹ hnáuh² hnoh² hi³ jmu¹ jná¹³ ñí¹con² náh²? ");
INSERT INTO csoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jáun² tsá² ten³ hí³ né³ ca³juáh³: ―Tɨ³², hnáu² jnoh¹ hi³ jnia³ siáh³ mɨ́¹ñí¹. ");
INSERT INTO csoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jmɨ́¹jáun² ca³ja³ mií³ tsɨ́³ Jesús ñí¹con² tsá² hí³, hi³ jáun² ca³tí³ dí² cuo² mɨ́¹ñí¹ tsú². Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³jnia³ siáh³ mɨ́¹ñí¹ tsá² hí³, hi³ jáun² ja³taunh²¹ cu³chin¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jmɨ́¹ má²ja³quián³ chá¹táunh¹ tsú² juú² Jerusalén, ca³cha³táunh¹ tsú² có³² juú² Betfagé can³² máh³ míh¹ Olivos; jmɨ́¹jáun² ca³zen³ Jesús gon³ tsá² haɨn²¹ hí³ tɨ³ con², ");
INSERT INTO csoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","hi³ ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh² juú² míh¹ nio² tɨ³ chí¹ján³ nɨ́². Jáun² ñí¹ nɨ́² la³juɨ³² chanh²¹ náh² jan² lo¹ búh¹ quionh³ jáh³ míh¹ jon², hi³ cuá¹hñéih¹. Cuá²zanh¹ náh² jáh³, hi³ jáun² ñá²jan³² ñí¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Hi³ jáun² nɨ́¹juáh³ zian² tsá² zia³² hi³ ca³juáh³ ñí¹con² hnoh², jáun² juoh¹ náh² tsú²: “Hliá² má²hniah³ ñí¹con² Tɨ³² Juo¹³ bíh¹ jnoh¹ jáh³, hi³ jáun² la³juɨ³ já¹jon¹ jnoh¹ siáh³ ñí¹ tionh¹ lá²”. ");
INSERT INTO csoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","La³ nɨ́² ca³lɨ³ hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ *tɨ³² jë¹ Dió³², jmɨ́¹ ca³juáh³ jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Zéih³ náh² tsá² zian² tɨ³ ñí¹ zeh¹ máh³ Sión la³ lá²: Sá¹nɨ́² jɨe³, Re²¹ Juóuh³² hnoh² cuá¹ja³² ñí¹con² náh²; jan² Tsá² tsɨ́¹juɨ́³ bíh¹ hí³, hi³ cuá¹tsɨn¹ jan² lo¹ búh¹ míh¹, la³ cun³ lo¹ pih²¹ jon² jan² jáh³ qui³ cán²³ lio²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jáun² ja³taunh²¹ bíh¹ tsá² gon³ haɨn²¹ hí³ tɨ³ con² tsú² hi³ ca³jmú³ la³ cun³ hi³ má²lɨ́²juáh³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ná¹jón²¹ bíh¹ tsú² ló¹ búh¹ la³ má²quionh³ jon² jmɨ́¹ ca³cha³tánh¹, hi³ jáun² ca³na³tsɨ́³ tsú² ha¹ cu³hna²¹ jáh³, hi³ jáun² ca³cua³tsɨn¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jmɨ́¹ lɨ²¹ jáun² né³, juóun³² lɨ́n³² bíh¹ tsáu² ca³qui³ ca³ja³ ha¹ hú¹ juɨ³²; hi³ ma³ jan² né³ ca³quieh³ cuú² ñeh¹ hmá² hi³ ca³ja³ siáh³ hú¹ juɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tsá² jmɨ́¹ hí¹tsá²táunh¹ chí¹ján³, jɨ³ tsá² jmɨ́¹ hí¹ja³táunh¹ chí¹cáɨn² nɨ́² ca³ma³liáu³² hi³ tɨ³ hóh³² tiá³ hi³ juáh³ la³ lá²: ―¡Cuɨ́¹ lɨ³quien² bíh¹ jón²zɨ́h¹ jón²cho¹ hla¹ re²¹ Dá²vi²¹! ¡Cuɨ́¹ lɨ³quien² bíh¹ Tsá² cuá¹ja³² cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²! ¡Hénh³ ma³ chun¹ Dió³² Tsá² cuá³ hñu³mɨ³cuú²! ");
INSERT INTO csoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hi³ jáun² jmɨ́¹ hi²¹ Jesús já¹ juú² Jerusalén, la³jɨ́n³² bíh¹ tsá² juú² ca³ja³cáun² tsɨ́³ hi³ quí² ngaɨh³² raɨnh²¹ hi³ juáh³: ―¿Hin² dá² tsánh² tsá² ó³²? ");
INSERT INTO csoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hi³ jáun² tsá² hí¹ja³tú² ja³lɨn²³ hí³ cu³chin¹ cu³hna²¹ Jesús né³ ca³juáh³: ―Jesús Tsá² lɨ́n³ tɨ³² jë¹ Dió³² bíh¹ ó³², Tsá² juú² Nazaret hɨ́n¹³ tɨ³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jmɨ́¹ lɨ²¹ jáun² hi³ Jesús hñu³ cuáh³² chín¹, hi³ jáun² ca³huen³ dí² tɨ³ cheih³² la³jɨ́n³² tsá² jmɨ́¹ ná¹hna² jɨ³ tsá² jmɨ́¹ ná¹la³² ñí¹ jáun². Ca³ziu³ ca³cuɨ́³ tsú² mesa quioh²¹ tsá² jmɨ́¹ ná¹zaɨ³² quɨe³ quioh²¹ hué³² siáh³ jɨ³ hmá²sɨ¹ quioh²¹ tsá² jmɨ́¹ ná¹hna² chi³ jáɨ² nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","hi³ jáun² ca³záɨh³ dí²: ―Ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³ la³ lá²: “Hñu³² jná¹³ dá² jmáɨ²: hñú³ ñí¹ liéinh³² tsú² Dió³²” bíh¹. ¡Tɨ³la³ hnoh² né³, tá² hláu² quioh²¹ háɨn² bíh¹ má²ca³jmuh³ náh²! ");
INSERT INTO csoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Hñu³ cuáh³² jáun² né³, cua³taunh²¹ ma³ jan² tsá² ten³ jɨ³ tsá² hma² nɨ́² siáh³ ñí¹ zenh¹ Jesús, hi³ jáun² ca³jmah³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tɨ³la³ jmɨ́¹ ca³jɨ́e³ tsá² ná¹lɨ́n³ mi³jmú³ quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ hua³jueh³² hi³ jmu² jáun² Jesús, jɨ³ hi³ ca³náɨ³² tsú² siáh³ hi³ jlánh¹ ná¹tɨ́² ná¹hóh³² tsá¹míh¹ hñu³ cuáh³² hi³ juáh³ la³ lá²: “¡Cuɨ́¹ lɨ³quien² bíh¹ jón²zɨ́h¹ jón²cho¹ hla¹ re²¹ Dá²vi²¹!”, ca³míh³ lɨ́n³² bíh¹ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hi³ jáun² ca³záɨh³ dí² Jesús la³ lá²: ―¿Naɨh²¹ hnú² la³ cun³ hi³ ñí¹juah²¹ tsú² nɨ́²? Hi³ jáun² Jesús ca³juáh³: ―Ján³, tɨ³la³ ¿tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³² ñí¹ rá¹juáh³ la³ lá² dúh¹?: Má²ca³jmuh³ hnú² hi³ tsá¹míh¹ pih²¹, jɨ³ dáɨn² tiúh²³ nɨ́² siáh³, ná¹má²quí² ma³quien² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jmɨ́¹ lɨ²¹ jáun² né³, ca³ta³tonh¹ bíh¹ tsá² hí³, quí¹ cua³han³ bíh¹ Jesús já¹ juú² Jerusalén, hi³ ngau³ juú² Betania, hi³ jáun² ñí¹ jáun² ca³jnioh². ");
INSERT INTO csoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hú²niéi² jmɨ́¹ cá¹jniá²¹ jáun² má²cuá¹tsau³² siáh³ Jesús tɨ³ já¹ juú² Jerusalén, jáun² tá¹la³ hí¹hún¹ jáun² juɨ³² ca³ráun³ ñí¹cuóunh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Can³² juɨ³² jáun² jmɨ́¹ chi²¹ cáun² hmá² sí² co², jáun² ngau³ tsú² jmɨ́h¹ hmá² hi³ ca³ñí¹jɨ́e¹³ nɨ́¹juáh³ haɨ²¹ máɨ³, tɨ³la³ hí¹ cá² máɨ³ yáh³ máɨ³ tiá² tsoh³ tsú², jɨ́³²la³ mu²¹ bíh¹ hmá² jmɨ́¹ tsɨ²¹. Jáun² Jesús ca³záɨh³ hmá² sí² jáun² la³ lá²: ―¡Hí¹ cónh³ yáh³ tiú²uú² chau²¹ jmáɨ¹ hi³ ha³ hnú² máɨ³! Jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³lɨ³ quiéin² hmá² sí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jmɨ́¹ ca³jɨ́e³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ lɨ³ la³ jáun², jáun² jlánh¹ ca³ja³cáun² tsɨ́³, hi³ jáun² ca³ngáɨh³ dí² Jesús: ―¿Ha³ bíh¹ lánh³ rón³² sa³ cu³tiá³ pih²¹ la³ lá² máh³ la³ ca³lɨ³ quiéin² hmá² sí² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jáun² Jesús ca³ngáɨ³ la³ lá²: ―Jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ nɨ́¹juáh³ cáun² nio² honh² náh², hi³ tiá² tioh³ hliáun³ ñéih³, jun³juáh¹³ jɨ́³²la³ la³ cun³ hi³ lɨ́²jmú³² jná¹³ ñí¹con² hmá² sí² nɨ́² yáh³ lɨ́¹³ jmúh¹³ hnoh², quí¹ hí¹ la³ tɨ³ lɨ́¹³ bíh¹ hi³ juoh¹ hnoh² máh³ nɨ́² la³ lá²: “¡Quin² hnú² ñí¹ nɨ́², hñu³ jmɨ́²miih²¹ cuá²hú³²!” hú¹tá¹ lɨ³tí³ bíh¹ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Quí¹ la³jɨ́³² hi³ mɨ́h¹³ bíh¹ náh² ñí¹con² Dió³², cun³ héih¹ bíh¹ náh² nɨ́¹juáh³ hi³ cu³tí³ nio² cáun² honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jmɨ́¹ lɨ²¹ jáun² né³ hi³ Jesús cuáh³² chín¹, hi³ jáun² tá¹la³ jmɨ́¹ dí¹hɨeh³² tsú² tsáu² ñí¹ jáun² né³ cua³taunh²¹ tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́² siáh³, hi³ ca³ngáɨh³ Jesús la³ lá²: ―¿Hin² ca³cué³ héih³² hi³ jmuh³² nú² ta²¹ nɨ́²? ¿Hin² tsánh² ca³cué³ jáɨ¹³ hi³ hauh³² hnú² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jáun² Jesús ca³juáh³: ―Ja³bí¹ jná¹³ siáh³ nga¹ cáun² jáɨ¹³ ñí¹con² hnoh²; nɨ́¹juáh³ hi³ ngáɨh¹ hnoh² jáɨ¹³ hi³ nga¹ jná¹³ lá², jáun² má¹jáun² juanh²¹ jná¹³ hi³ hin² ca³cué³ jná¹³ jáɨ¹³ hi³ jmu² la³jɨ́³² hi³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Hin² tsánh² ca³ze³ hla¹ Juan² hi³ cua³zion³ tsáu² jmáɨ²? ¿Hí¹ Dió³², ho³ tsá²mɨ³cuóun² uá¹? Tɨ³la³ tsá² hí³ né³ cáun² lɨ́¹ ca³juu³ ca³hlénh³ ja¹ má²tún² hmóu³² bíh¹ hi³ ca³juónh³ la³ lá²: ―Nɨ́¹juáh³ hi³ juáh¹³ dí² hi³ Dió³² bíh¹ ca³ze³ tsú², hi³ jáun² tsá² nɨ́² né³ lɨ́¹³ nga³: “Hi³ jáun² né³, ¿he³ láɨh³² sa³ tiá² ta²¹ ca³tianh³² yáh³ náh² tsú²?” ");
INSERT INTO csoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hi³ nɨ́¹juáh³ hi³ juáh¹³ dí² siáh³ hi³ tsá²mɨ³cuóun² bíh¹ ca³ze³ tsú², já² cáu² bíh¹ he² quiú¹³ dí² ñí¹con² tsáu²; quí¹ la³jɨ́n³² bíh¹ tsáu² ná¹lɨ́n²³ hi³ hla¹ Juan² jmɨ́¹ lɨ́n³ jan² tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Hi³ jáun² cu³tsa³² ca³záɨh³ tsú² cú²jueh³² Jesús: ―Tiá² né¹ yáh³ jnoh¹. Jáun² Jesús né³ ca³juáh³ siáh³: ―Hi³ jáun² sa³jun³ jná¹³ yáh³ juanh²¹ siáh³ hi³ hin² tsánh² ca³cué³ jáɨ¹³ hi³ jmu² jná¹³ la³jɨ́³² ta²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jmɨ́¹ lɨ²¹ jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―¿He³ lánh³ lɨ́n²³ hnoh² ca³tɨ²¹ jáɨ¹³ hi³ jmu¹ jná¹³ lá²? Jan² tsá²ñuh² jmɨ́¹ zian² gon³ jon²; jáun² ca³záɨh³ dí² tsá² má²ján³ la³ lá²: “Jón³, cua³², cuá²jmu³ ta²¹ ñí¹ jná¹ mɨ³ uóun²jɨeh¹³ quiú¹³ né³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jáun² jon² tsú² ca³ngáɨ³: “¡Tiá² hnó³² nia²¹ ñe¹!” Tɨ³la³ jmɨ́¹ má²cu³lé³ jáun² né³, ca³za² bíh¹ tsɨ́³ tsú², hi³ jáun² ngau³ hi³ ñí¹jmú¹³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jmɨ́¹ lɨ²¹ jáun² né³ ngau³ tsá² má²lieih²¹ hí³ hi³ ca³ñí¹lienh¹³ siáh³ tsá² cáɨn² hi³ ca³ñí¹zeh¹ dí² siáh³ la³ jáun²; hi³ jáun² tsá² hí³ né³ ca³ngáɨ³: “Re² bíh¹ tia²¹, ñe¹ jná¹³”. Tɨ³la³ tiá² ñéi¹ yáh³ tsú² jmɨ́¹ lɨ²¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Hin² bíh¹ tsánh² tsá² gon³ hí³ ca³jmú³ la³ cun³ hi³ hnió³ jméi²? Jáun² tsá² hí³ ca³juáh³: ―Tsá² má²ján³ hí³ bíh¹. Hi³ jáun² Jesús ca³záɨh³ siáh³ tsá² hí³: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ *tsá² caɨ³² hmah²¹ jɨ³ tsá²mɨ³ juón¹ bíh¹ tín² má²ná¹taunh³² jo³cuo² Dió³² la³ cónh³ bíh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Quí¹ hla¹ Juan² tsá² tɨ́² ziau² jmáɨ² cuan³ hi³ cua³ma³ta² hnoh² ha³ lánh³ rón³² má¹zián¹³ náh² la³ cun³ tɨ³² tsɨ́³ Dió³², tɨ³la³ tiá² ca³tianh³² yáh³ hnoh² tsú² ta²¹; tɨ³la³ tsá² caɨ³² hmah²¹ quionh³ tsá²mɨ³ tsá² lɨ́¹ jmú² lɨ́¹ tsau³² má¹na²¹, ca³tanh² bíh¹ ta²¹ tsá² hí³. Tɨ³la³ hnoh² né³, uá¹jinh¹ ca³jɨeh³ náh² hi³ jáun², cun³ jáun² bíh¹ tiá² ca³zah¹ hnoh² jmɨ́¹ honh² hi³ juáh¹³ hi³ jmɨ́¹ lɨ³ tanh¹³ náh² ta²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”Niéi² náh² siáh³ jáɨ¹³ hi³ jmu¹ jná¹³ lá²: Jan² tsáu² ca³jñí³ mɨ³ uóun²jɨeh¹³ ñí¹náɨ² quioh²¹; hi³ jáun² ca³jmú³ jnɨ́¹³ la³ cu³ la³ jéin³ jáun², hi³ ca³zíh³ siáh³ cáun² ñí¹ lɨ́¹³ quiáuh³² jmaɨh²¹ mɨ³ uóun²jɨeh¹³, jɨ³ hi³ ca³jmú³ tsú² siáh³ cáun² hñú³ ñe¹ lɨ́n²¹ ñí¹ lɨ́¹³ di³chín³² tsá² jmu³ hua³hí¹³ ñí¹náɨ² jáun². Jmɨ́¹ lɨ²¹ jáun² né³, ca³quiú² tsú² ñí¹náɨ² jáun² jo³cuo² tsá² lɨ́¹³ jmu³ ta²¹, hi³ jáun² tsá² jmu² hí³ ta²¹ né³ jmɨ́¹ ma³hmah¹ ca³lá² quioh²¹ hué³² jáun² cun³quionh³ hi³ jɨ́enh³² cú¹pih²¹ la³ cun³ hi³ ló³² jáun². Jmɨ́¹ lɨ²¹ jáun² ngau³ ñí¹ uóunh³. ");
INSERT INTO csoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ ca³láu² mɨ³ uóun²jɨeh¹³ né³, ca³zen³ tsú² ma³ jan² *tsá² má²ná¹hlánh¹ joh¹ hi³ ca³ñí¹máɨ¹ ñí¹con² tsá² jmu² ta²¹ la³ cun³ hi³ ca³tɨn¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tɨ³la³ tsá² jmu² hí³ ta²¹ né³ ca³zanh³ bíh¹ tsá² ca³zen³ hí³ tsá² quioh²¹ ñí¹náɨ², hi³ ca³qui³ ca³quiunh³ dí², ma³ jan² ca³jngɨh³ dí² hi³ ma³ jan² né³ ca³qui³ ca³jláɨn³² dí² quɨ́n¹. ");
INSERT INTO csoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jáun² tsá² quioh²¹ ñí¹náɨ² jáun² ca³zen³ siáh³ juóun³² tsá² quian²¹ la³ cónh³ bíh¹ jmɨ́¹tin²; tɨ³la³ tsá² jmu² ta²¹ hí³ má¹ná¹, siáh³ bíh¹ siáh³ ca³jmúh³² tsú² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","”Ñí¹ cá¹táuh³ né³ cu³tsa³² ca³zen³ tsú² cú²jueh³² jon², quí¹ ca³lɨ́n¹³ tsú² la³ lá²: “Cun³ tanh¹³ bíh¹ tsú² ta²¹ jón³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tɨ³la³ jmɨ́¹ ca³jɨ́en³² tsá² ná¹jmu² hí³ ta²¹ jon² tsá² quioh²¹ ñí¹náɨ² né³, ca³juónh³ ja¹ hmóu³² hi³ ca³juáh³ la³ lá²: “Já² tsá² nɨ́² bíh¹ lɨ³quioh²¹ ñí¹náɨ² lá² nɨ́¹ má¹jun² jméi²; chú³² cuɨ́¹ jngɨh¹³ dí² tsú² hi³ jáun² lɨ³ quiú¹³ dí² ñí¹náɨ² lá²”. ");
INSERT INTO csoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Hi³ jáun² ca³chin² tsú² tsá² hí³ tɨ³ cheih³² hi³ jáun² ca³jngɨh³ dí² tiáunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jmɨ́¹ lɨ²¹ jáun² ca³ngáɨ³ Jesús ñí¹con² tsá² hí³: ―Nɨ́¹ má¹cuanh³² tsá² quioh²¹ hí³ ñí¹náɨ² jáun² né³, ¿he³ lɨ́n²³ hnoh² jmu³ tsú² ñí¹con² tsá² jmu² hí³ ta²¹? ");
INSERT INTO csoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tsá² hí³ ca³juáh³: ―Tsá² hláɨh¹ hí³ dá² jngɨh³ bíh¹ tsú², ca³la³ hí¹ cú¹pih²¹ mií³ tiá² já³² tsɨ́³; hi³ jáun² ñí¹náɨ² jáun² cuéh³² tsú² tsá² siánh³ bíh¹ hi³ jmu³ siáh³ ta²¹, la³ cun³ tsá² lɨ³ jɨ́enh³² la³ cun³ hi³ ca³tɨn¹ tsú² caun¹³ nɨ́¹ má¹ca³láu². ");
INSERT INTO csoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jmɨ́¹jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―¿Tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³², ñí¹ rá¹juáh³ jáun² la³ lá²?: Quɨ́n¹ hi³ tiá² ca³jeih²¹ jáun² tsá² ná¹lɨ́n³ tɨ³² hiah³², ta³né³² má²lɨ́³ cá² máɨ³ quɨ́n¹ hi³ jlánh¹ bíh¹ quien², quɨ́n¹ hi³ hu²¹ cuoh¹ hiah³². Hi³ nɨ́² dá² ca³jmú³ Juo¹³ bíh¹ dí², cáun² hi³ lɨ́¹³ lɨ³ tsa³cáun² tsɨ́³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Hi³ jáun² bíh¹ juanh³² jná¹³ ñí¹con² hnoh², hi³ tiú²uú² lɨ́¹³ yáh³ hián¹³ hnoh² jáɨ¹³ hi³ tonh²¹ náh² jo³cuo² Dió³², la³ cun³ hi³ jmɨ́¹ ca³tɨn¹ náh² hián¹³; hi³ jáun² tsá² hué³² siáh³ bíh¹ má²hiáuh¹³, tsá² jmu² la³ cun³ hi³ tɨ³² Tsɨ́³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tɨ³la³ hi³ ca³tɨn¹ quɨ́n¹ jáun² né³, lɨ³ua³ jan² tsá² cá²hính³² quionh³ quɨ́n¹ jáun², ca³la³ juoh¹ mí¹ siún¹ nio² bíh¹ tsú² lɨ́¹³; hi³ nɨ́¹juáh³ quɨ́n¹ jáun² la³ ca³táh³ ñí¹ quioh²¹ lɨ³ua³ jan² tsáu² né³, jáun² ca³la³ juɨ²¹ nio² bíh¹ tsú² lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jmɨ́¹ ca³náɨ³² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² *fariseos jáɨ¹³ hi³ jmu² jáun² Jesús, jmɨ́¹jáun² ca³lɨ³tsɨn² tsú² hi³ ca³tɨn¹ hí³ bíh¹ dí² jáɨ¹³ hi³ má²lɨ́²hléh³² tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jmɨ́¹jáun² jmɨ́¹ má²hnió³ dí² zanh³ Jesús, tɨ³la³ jmɨ́¹ juénh² bíh¹ tsú² ñí¹con² tsá² ná¹ngɨh³² hí³, quí¹ jmɨ́¹ ná¹juáh²³ bíh¹ tsá² hí³ hi³ Jesús lɨ́n³ jan² tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ca³ma³liáu³² hi³ liéinh³² siáh³ tsá² hí³ cun³quionh³ jáɨ¹³ hi³ jmu², hi³ ca³záɨh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Jmáɨ¹ hi³ téh³ Dió³² tsá² lɨ́¹³ tónh³² jo³cuo² lɨ́¹³ la³jmɨ́¹ lɨ²¹ jmɨ́¹ ca³jmú³ jan² re²¹ jmáɨ¹ hi³ ca³jenh² cuo² jon². ");
INSERT INTO csoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ca³zen³ tsú² *tsá² má²ná¹hlánh¹ joh¹ hi³ tsa³tieh¹ tsú² tsá² má²ná¹tén¹, tɨ³la³ tsá² ná¹tén¹ hí³ né³ tiá² ca³he³ yáh³ hi³ ja³táunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jáun² ca³zen³ tsú² siáh³ tsá² má²ná¹hlánh¹ joh¹ ñí¹ hná¹ jáun² hi³ ca³záɨh³ dí² la³ lá²: “Cuá²zéih³ náh² tsá² ná¹tén¹ hi³ má²ná¹lɨ́³ bíh¹ hua³jan²¹ má³² quion²¹ jná¹³. Má²lɨ́²jmú³² jná¹³ héih³² hi³ jngɨh³ tsú² cuá¹juɨ́² jɨ³ la³jɨ́n³² jáh³ húnh¹ nɨ́² siáh³, hi³ jáun² la³jɨ́³² bíh¹ má²ná¹lɨ́³ hua³jan²¹; cuɨ́¹ ja³táunh¹ tsú² jmáɨ¹ ñí¹ jenh¹³ cuo² jón³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tɨ³la³ tsá² ná¹tén¹ hí³ má¹ná¹, ca³la³ uá¹ tiá² náɨ³² bíh¹ ca³jmú³. Ma³ jan² tsá² hí³, ta²¹ bíh¹ ca³ñí¹jmú¹³ ñí¹náɨ² quioh²¹, ma³ jan² né³ ca³ñí¹jmú¹ ñí¹hnáɨh¹, ");
INSERT INTO csoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","hi³ ma³ jan² né³, ca³zanh³ bíh¹ tsá² hí³ joh¹ re²¹, hi³ ca³quiu³ ca³pan³ dí² ca³la³ ñí¹ ca³jngɨh³ dí² tiáunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jmɨ́¹jáun² ca³míh³ lɨ́n³² bíh¹ tsɨ́³ re²¹ hí³, hi³ jáun² ca³zen³ hliáu³ joh¹ hi³ ca³ñí¹ma³tsan² tsá² hláɨh¹ tsá² hon² hí³, jɨ³ hi³ ca³ñí¹jín² tsú² juú²co¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jmɨ́¹ lɨ²¹ jáun² ca³záɨh³ dí² tsá² hí³ joh¹: “La³jɨ́³² bíh¹ má²ná¹lɨ́³ hua³jan²¹ quioh²¹ hi³ jenh¹³ cuo² jón³² jná¹³, tɨ³la³ tsá² jmɨ́¹ ná¹tén¹ hí³ né³, tiá² jmɨ́¹ la³ ca³tɨ²¹ yáh³ hi³ te¹ jná¹³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Hi³ jáun² cuá²táunh¹ náh² cú²jueh³² la³ tán¹ ja¹ hñú³, hi³ cuá²tiéh³ náh² ñí¹ lá² la³jɨ́n³² tsá² jenh¹³ náh² ñí¹ jáun²”. ");
INSERT INTO csoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hi³ jáun² tsá² hí³ né³, ca³huén² bíh¹ hi³ ja³taunh²¹ ja¹ hñú³ hi³ ca³ñí¹tieh¹ la³jɨ́n³² lɨ³ua³ jan² tsá² ca³jenh², cuɨ́¹ tsá² chun¹ cuɨ́¹ tsá² hláɨh¹; hi³ jáun² ca³cónh³² bíh¹ tsáu² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","”Jmɨ́¹jáun² hi³ re²¹ ñéih³ hi³ ca³ñí¹jɨen¹³ tsá² má²ca³lɨ³tén¹ hí³, hi³ jáun² ca³jɨ́en³² tsú² jan² tsá²ñuh² hi³ jmɨ́¹ cuá¹tón²¹ ñí¹ jáun², tɨ³la³ tiá² jmɨ́¹ cuá¹quih³² yáh³ tsú² hmɨh³² la³ cun³ hi³ qui³ quɨh³² tsú² ñí¹ jenh² cuo² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hi³ jáun² ca³záɨh³ dí² la³ lá²: “Hnú² tsá²ñuh², ¿ha³ lánh³ rón³² lɨ́²húh³² hnú² ñí¹ lá² ta³ tiá² quíh¹ nú² hmɨh³² hi³ ca³tɨ²¹ quɨh³² tsú² jmáɨ¹ hi³ jenh² cuo² tsáu²?” Tɨ³la³ tsá² hí³ má¹na²¹, cáun² lɨ́¹ ca³cuá³ tie³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jáun² re²¹ hí³ ca³záɨh³ tsá² ná¹ná²tsɨ́³ má³² ñí¹ mesa, hi³ ca³juáh³ la³ lá²: “Hñéi³ náh² cuá² ta³ tsá² lá², hi³ jáun² cuá²tion³ tɨ³ cheih³² ñí¹ já¹niéi², hi³ jáun² ñí¹ jáun² tsa³tɨ́² tsa³hoh³², hi³ tsa³qui³ tsa³hon³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―Quí¹ juóun³² lɨ́n³² bíh¹ tsáu² má²ná¹tén¹, tɨ³la³ cú¹pih²¹ bíh¹ tsá² quiánh³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jmɨ́¹ lɨ²¹ jáun² ja³tanh²¹ tsá² *fariseos hi³ ca³ñí¹jmú¹³ cá²hon³ ha³ lánh³ tsa³ca³ tsa³lian³ dí² Jesús, hi³ jáun² zia³² lánh³ rón³² tánh³² tsú² tso³ cun³quionh³ jáɨ¹³ hi³ hléh³². ");
INSERT INTO csoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hi³ jáun² ca³zen³ dí² ma³ jan² tsá² haɨn²¹ tɨ³ con² la³ má²quionh³ ma³ jan² tsá² cu³ nió³ joh¹ Herodes, hi³ ca³ñí¹zeh¹ Jesús la³ lá²: ―Hnú² Tɨ³², né¹ jnoh¹ hi³ jmáh³la³ jú¹ tson² bíh¹ hɨeh³² hnú², hnú² bíh¹ hɨeh³² jú¹ tson² ca³tɨ²¹ juɨ³² quioh²¹ Dió³²; hi³ né¹ jnoh¹ siáh³ hi³ tiá² jmuh³² yáh³ hnú² jan² quien² hi³ jan² tiá² quien². ");
INSERT INTO csoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jáun² hnáu² jnoh¹ hi³ hnú² juáh¹³ la³ cun³ hi³ lɨ́n²³ hnú²: ¿Hí¹ ca³tɨ²¹ má¹hmah²¹ jnoh¹ quɨe³ hi³ mɨ³² *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma, ho³ tiá² hniáuh³²? ");
INSERT INTO csoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tɨ³la³ Jesús má¹ná¹, ca³lɨ³tsɨn² bíh¹ la³ cun³ hi³ hlah³ hi³ hó³² hi³ jmɨ́¹ ná¹tioh³ jáun² tsɨ́³ tsá² hí³, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―¡Hnoh² tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! ¿He³ láɨh³² cá² lau²³ hnoh² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Hɨ́e¹ náh² cáun² quɨe³ hi³ qui³ ma³hmah²¹ náh² jáun² neh²¹. Hi³ jáun² tsá² hí³ ca³cué³ cáun² *cú¹tiáu². ");
INSERT INTO csoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jmɨ́¹ jáun² ca³ngáɨh³ Jesús tsá² hí³: ―¿Hin² mɨ³ ñí¹ tá²láɨ¹ ñí¹ lá², hi³ hin² hi³ jmáɨ² tón³² lá² siáh³? ");
INSERT INTO csoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jáun² tsá² hí³ ca³ngáɨ³: ―Quioh²¹ *tsá² cuá¹lɨ́n³ mɨ³chí¹ bíh¹ nɨ³². Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jáun² cuéh³ náh² tsá² cuá¹lɨ́n³ mɨ³chí¹ la³ cun³ hi³ ca³tɨn¹ hiáuh³, hi³ cuéh³ náh² siáh³ Dió³² la³ cun³ hi³ ca³tɨn¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáɨ¹³ jáun² né³, lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹, hi³ jáun² ja³tanh²¹ bíh¹, jáun² hnga² bíh¹ Jesús jéi³²í¹ ca³ta³zanh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jmáɨ¹ jáun² siáh³ cua³taunh²¹ ma³ jan² tsá² *saduceos hi³ cua³jɨen³ Jesús. Tsá² cu³ nió³ tsá² saduceos hí³ tiá² ta²¹ haɨh²¹ yáh³ hi³ jenh¹³ tsá² má²cá²tsan³; hi³ jáun² bí¹ jlánh¹ ca³ñí¹ngah¹ dí² Jesús jáɨ¹³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tɨ³², hla¹ Moisés ca³juáh³ hi³ nɨ́¹juáh³ jan² tsá²ñuh² ca³jéinh³² cuo², hi³ jun³ bíh¹ ta³ tiá² jon² ca³lɨ³zian² quionh³ tsá²mɨ³ hí³, jáun² dá¹jon²¹ tsú² ca³tɨn¹ jéinh³² cuo² quionh³ tsá²mɨ³ hnáɨ³ hí³ hi³ jáun² lɨ³zian² jon² ca³tɨn¹ hla¹ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jáun² né³, ja¹ quiú¹³ jnoh¹ jmɨ́¹ zian² cá² mí¹zionh² tsá²ñuh² hi³ jmɨ́¹ ná¹lɨ́n³ quiaun³ má²tún² raɨnh²¹ jan² jméi² mí¹ziú¹³. Tsá² má²ján³ né³ ca³jéinh³² cuo² quionh³ tsá²mɨ³, tɨ³la³ jun³ bíh¹ ta³ tiá² jon² ca³lɨ³zian² hí¹ jan², hi³ jáun² dá¹jon²¹ bíh¹ hla¹ hí³ ca³jéinh³² siáh³ cuo² quionh³ tsá²mɨ³ hnáɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","La³ jáun² bíh¹ siáh³ lɨ³ ñí¹con² tsá² ñí¹ má²gon³ hí³ ca³la³ ñí¹ jun¹; jáun² tsá² ñí¹ má²gáun³ siáh³ ca³jan³ tsá²mɨ³ hí³. La³ jáun² bíh¹ lɨ³ quioh²¹ tán¹ quiaun³ tsá²ñuh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jáun² ñí¹ ca³táuh³ né³, jun³ bíh¹ siáh³ tsá²mɨ³ hí³ hnga². ");
INSERT INTO csoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Hi³ jáun² né³, nɨ́¹ má¹tɨ³ ñí¹ ca³jenh¹³ tsú², ¿hin² dá² tsánh² tsá² quiaun³ hí³ lɨ́¹³ ñí²cuo² tsá²mɨ³ hí³, quí¹ tán¹ quiaun³ bíh¹ tsú² ca³jéinh³² cuo² quionh³ tsá²mɨ³ hí³? ");
INSERT INTO csoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jáun² Jesús ca³ngáɨ³, hi³ ca³juáh³ la³ lá²: ―Hnoh² dá² lɨ́¹ ná¹tsá²con² bíh¹ náh², quí¹ cun³ñí¹ hi³ tiá² cuɨn² náh² Sí² quioh²¹ Dió³², hi³ sa³jun³ pí³ quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quí¹ nɨ́¹ má¹ca³jenh¹³ tsú² ja¹ hla¹, tiá² hin² jéinh³² yáh³ cuo², hi³ sa³jun³ cuen³ yáh³ tsú² jon² hi³ jéinh³² cuo², quí¹ má¹jáun² dá² má²lɨ́n¹³ tsú² la³jmɨ́¹ lɨ́n³ tsá²cuú² tsá²ta³ Dió³² bíh¹, tsá² tionh² hí³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tɨ³la³ hi³ ca³tɨ²¹ jáɨ¹³ nɨ́¹juáh³ hi³ tson² jenh¹³ tsá² má²cá²tsan³ né³, ¿tiá¹ má²ca³híh³ hnoh² la³ cun³ jáɨ¹³ hi³ ca³juáh³ jáun² Dió³² hnga² dúh¹?, jmɨ́¹ ca³juáh³ jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“¡Jná¹³ bíh¹ la³² Dió³² Juo¹³ Há²bran²¹, Isaac jɨ³ Jacob nɨ́² siáh³!” Quí¹ Dió³² dá² lɨ́n³ Dió³² Juo¹³ tsá² zian² bíh¹, tiá² lɨ́¹³ yáh³ lɨ́n³ tsú² Dió³² Juo¹³ tsá² má²jún¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jmɨ́¹ má²lɨ́²niéi³² tsá² tionh² la³ cu³ la³ jéin³ hí³ jáɨ¹³ nɨ́² né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ tsú² ca³tɨ²¹ jáɨ¹³ hi³ hleh³² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jmɨ́¹ ca³lɨ³ ñi³² tsá² fariseos hi³ Jesús ca³jmú³ hi³ tsá² saduceos lɨ́¹ tiá² ñi³² he³ nga³, hi³ jáun² ca³ngɨh³² dí² tiáunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hi³ jáun² jan² tsá² hí³, tsá² lɨ́n³ tɨ³² liei²¹, jmɨ́¹ hnió³ ca³ lan³ Jesús, hi³ ca³ngáɨh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Hnú² Tɨ³², ñí¹ ca³la³ jɨ́³² héih³² zia³² ñí¹ liei²¹, ¿hín² bíh¹ héih³² hi³ jlánh¹ bíh¹ quien²? ");
INSERT INTO csoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―“Ma³hno¹ Dió³² Juóuh³² ca³la³ jonh³ jmɨ́¹ honh², la³jɨ́³² jmɨ́²chí³ quián¹³ jɨ³ la³jɨ́³² hi³ lɨ́n²³ nú² nɨ́² siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Hi³ nɨ́² bíh¹ héih³² la³ñí¹, héih³² hi³ jlánh¹ bí¹ quien² ñí¹ ca³la³ jɨ́³² héih³². ");
INSERT INTO csoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hi³ héih³² ñí¹ má²tun³ né³ míh¹ tiá² cá²ren² bíh¹, hi³ juáh³ la³ lá²: “Ma³hno¹ tsá²mɨ³cuóun² renh² la³jmɨ́¹ hno³ nú² huen²”. ");
INSERT INTO csoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tá¹ tun³ héih³² nɨ́² bíh¹ lɨ́³ mí¹zioh²¹ quioh²¹ tá¹ cáun² liei²¹ quioh²¹ hla¹ Moisés jɨ³ la³jɨ́³² la³ cun³ hi³ ca³hɨ́e³ tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tá¹la³ jmɨ́¹ ná¹ngɨh³² jáun² tsá² fariseos hí³, ");
INSERT INTO csoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","jáun² Jesús ca³ngáɨ³: ―¿He³ lánh³ lɨ́n²³ hnoh² hi³ ca³tɨn¹ Tsá² lɨ́n¹³ Cristo? ¿Hin² jón²zɨ́h¹ jón²cho¹ hí³? Tsá² hí³ né³ ca³juáh³: ―Jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹ bíh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Nɨ́¹juáh³ la³ nɨ́² né³, ¿he³ bí¹ lánh³ rón³² sa³ ca³juáh³ yáh³ hla¹ Dá²vi²¹ hnga² cun³quionh³ Jmɨ́²chí³ Chun¹, hi³ Juo¹³ bíh¹ dí² Tsá² lɨ́n³ Cristo? Quí¹ hla¹ Dá²vi²¹ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Dió³² Juóu³² jná¹³ ca³záɨh³ Tɨ³² Juóu³² jná¹³: Tɨ³ cuá² chu²¹ quion²¹ jná¹³ ñí³, ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ jmu¹ jná¹³ hi³ tsá² hau² hnú² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cáun² jlɨ²¹ hi³ hí¹ cú¹pih²¹ tiá² quien², hi³ ná¹tsɨn²¹ hnú² tanh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jáun² né³, ¿ha³ bí¹ lánh³ rón³² lɨ́¹³ hi³ Tsá² lɨ́n¹³ Cristo lɨ́n³ jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, nɨ́¹juáh³ ta³bí¹ hnga² yáh³ hla¹ Dá²vi²¹ la³ ca³juáh³ hi³ Juo¹³ bíh¹ tsú² Tsá² lɨ́n¹³ hí³ Cristo? ");
INSERT INTO csoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hi³ jáun² hí¹ jan² yáh³ tsá² hí³ tiú²uú² ca³lɨ³ nga³ hí¹ cáun² jáɨ¹³; hi³ jáun² la³ cun³ jmáɨ¹ jáun² né³, hí¹ jan² yáh³ tiú²uú² hin² ca³tia³ tsɨ́³ hi³ nga³ hí¹ cáun² jáɨ¹³ ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jmɨ́¹jáun² ca³juáh³ Jesús ñí¹con² tsá² ñi³tú¹ ñi³lɨn¹³ chí¹cá¹ chí¹tón²¹ cu³héin¹ tsú², jɨ³ ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con² dí², hi³ juáh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ tsá² *fariseos nɨ́² ná¹ho² jáɨ¹³ hi³ tɨn² niá³² jáɨ¹³ hi³ rá¹tioh³ liei²¹ quioh²¹ hla¹ Moisés. ");
INSERT INTO csoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hi³ jáun² né³, tionh² náh² ta²¹ la³ cun³ la³jɨ́³² jáɨ¹³ hi³ juáh³ tsú² jáun²; tɨ³la³ ha³ lɨ́² cán² náh² nóh³² quioh²¹ tsú² má¹ná¹, quí¹ tsá² hí³ dá² hɨe³² cáun² jú¹ tson², tɨ³la³ má¹lɨ³² jáun² né³, la³ siáh³ bíh¹ jmu² tsú² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Quí¹ tsá² hí³ dá² jlánh¹ jmu² héih³² huáh² tsɨ́³ ñí¹con² tsáu², héih³² hi³ hí¹juáh³ hmóu³² tsú² tiá² hnió³ ma³tí³². ");
INSERT INTO csoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","La³jɨ́³² hi³ jmu² tsú² jáun², jmu² tsú² cun³ñí¹ hi³ hnió³ tsú² jɨ́e³ tsáu² bíh¹. Tsá² hí³ jlánh¹ zaɨn³² pɨ³ tsáɨh³ hná¹ hmɨh³² hú³ má²ná¹tón²¹ jáɨ¹³ quioh²¹ Dió³² la³cáun² chí¹quie¹³ jɨ³ cuo² tsú² nɨ́² siáh³, hi³ zaɨn³² tsú² quɨ́h³² siáh³ hmɨh³² hi³ haɨ²¹ láuh¹³ tɨ³ jlánh¹ bíh¹ cuo² la³ cónh³ bí¹ hi³ quɨh³² lɨ³ua³ jan² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tsá² hí³ siáh³ jlánh¹ hniá¹ tiánh³ ñí¹ chu²¹ nɨ́¹ má¹ca³cha³táunh¹ lɨ³ua³ cáun² ñí¹ nio² jmáɨ¹, hi³ hniá¹ siáh³ tiánh³ ñí¹ jlánh¹ bí¹ quien² hñu³ cuáh³² quioh²¹, ");
INSERT INTO csoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","hi³ jlánh¹ hniá¹ tsú² siáh³ hi³ tsáu² cuen³ Dió³² nɨ́¹ má¹ca³jenh² dí² tsáu² ja¹ hmah²¹, hi³ hniá¹ tsú² siáh³ hi³ té³ tsáu²: “¡Tɨ³²!” ");
INSERT INTO csoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","”Tɨ³la³ hnoh² má¹ná¹, tiá² hniáuh³² yáh³ jmúh¹³ hnoh² hniá¹ hi³ tsáu² té³ “Tɨ³²”. Quí¹ má²tún² renh² bíh¹ hnoh² la³jɨ́n³² náh², hi³ jɨ́³²la³ jan² tán¹ bíh¹ Tɨ³² Juóuh³² náh² zian². ");
INSERT INTO csoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ha³ lɨ́² lɨ́¹ teh² náh² “Tia²¹” lɨ³ua³ jan² tsá² zian² ñí¹ hué²¹ lá², quí¹ jɨ́³²la³ jan² tán¹ bíh¹ Ñeh² náh² zian², Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sa³jun³ jmúh¹³ náh² hi³ té³ tsáu² hnoh² tsá² chín¹, quí¹ jɨ́³²la³ jan² tán¹ Tsá² lɨ́n³ Cristo bíh¹ lɨ́n³ Tsá² chín¹ ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Quí¹ nɨ́¹juáh³ jan² tsá² má²cón³² tsá² ñí¹ hná¹ nɨ́², tsá² hí³ bíh¹ tsá² tɨ³ jlánh¹ quien² ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Lɨ³ua³ jan² tsá² jmu² quien², tɨ³ méih³ bíh¹ hi³ quien² tsú², hi³ nɨ́¹juáh³ tsá² tiá² jmu² quien² né³, tsá² la³ hí³ tɨ³ lɨ³ quien² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹ jɨ³ hnoh² tsá² fariseos tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹!, quí¹ hnoh² dá² quí² jna²³ bíh¹ ñí¹con² tsáu², hi³ jáun² tiá² lɨ́¹³ tónh³² tsú² jo³cuo² Dió³². Tiá² hnáuh² yáh³ hnoh² tonh²¹ hmóu³², hi³ sa³jun³ cueh³² yáh³ hnoh² jáɨ¹³ hi³ tónh³² tsá² hnió³ tónh³². ");
INSERT INTO csoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹ jɨ³ hnoh² tsá² fariseos, tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹!, quí¹ hnoh² dá² quin³² náh² la³ jɨ³ sɨ́¹ hñú¹³ tsá²mɨ³ hnáɨ³, má¹lɨ³² jáun² né³ má²raɨnh³² náh² máh¹ cun³quionh³ hi³ lienh¹ náh² Dió³² ué³ lɨ́n³². Cun³ñí¹ hi³ jáun², tɨ³ jlánh¹ bí¹ huáh² tsɨ́³ héih³² hi³ tá¹tsɨn¹ hnoh² nɨ́¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹ jɨ³ hnoh² tsá² fariseos, tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Hnoh² jlánh¹ ñi³táunh¹ náh² tá¹ cáun² cuá¹ hué²¹ hi³ jmuh³² náh² pí³ lɨ́n³² hi³ janh²¹ náh² uá¹jinh¹ jan² tsáu² bíh¹, hi³ jáun² nɨ́¹ má¹ca³janh²¹ náh² tsú² né³, jmuh³² náh² hi³ tsá² hí³ tɨ³ jlánh¹ bíh¹ má²ca³tɨn¹ tsa³táunh¹ quiu³juóu³² la³ cónh³ bíh¹ hmóu³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”¡Jlánh¹ juon²³ hnoh², hnoh² tsá² ten³ tsá² ná¹quiánh¹ náh² ñí¹ juɨ³²! Quí¹ hnoh² juánh³: “Nɨ́¹juáh³ jan² tsá² jmu² jáɨ¹³ hi³ hɨe³² cuáh³² chín¹, jáun² tiá² lin¹ tion³ hniáuh³² ma³tí³² yáh³ tsú² jáɨ¹³ jáun²; tɨ³la³ nɨ́¹juáh³ hi³ hɨ́e³² tsú² cú¹mí¹niau²¹ hi³ tioh³ hñu³ cuáh³² né³, hi³ jáun² bíh¹ hú¹tá¹ má²hniáuh³² ma³tí³² tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Tsá² cáun¹ te³! ¿He³ dá² tɨ³ jlánh¹ bíh¹ quien²: hí¹ cú¹mí¹niau²¹, ho³ cuáh³² hi³ ca³ma³hɨen²¹ uá¹ cú¹mí¹niau²¹? ");
INSERT INTO csoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ja³bí¹ juánh³ siáh³ hnoh² la³ lá²: “Lɨ³ua³ jan² tsá² jmu² jáɨ¹³ hi³ hɨe³² ñí¹hiú¹³ nɨ́¹ má¹ca³jmú³ jáɨ¹³, tiá² lin¹ tion³ hniáuh³² ma³tí³² tsú² jáɨ¹³ jáun²; tɨ³la³ nɨ́¹juáh³ tsá² hɨe³² la³ cun³ hi³ má²lɨ́²cuéh³² tsú² Dió³² né³, hi³ ná¹tsɨ²¹ ñí¹hiú¹³, jáun² jáɨ¹³ la³ jáun² bíh¹ hú¹tá¹ hniáuh³² ma³tí³² tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Tsá² cáun¹ te³! ¿He³ bíh¹ tɨ³ jlánh¹ quien²: hí¹ hi³ ná¹tsɨ²¹ ñí¹hiú¹³, ho³ hnga² uá¹ ñí¹hiú¹³, ñí¹ jmu² hi³ lɨ́²hɨ́en¹ hi³ lɨ́¹ cue³² tsú² jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Quí¹ nɨ́¹juáh³ tsá² hɨe³² ñí¹hiú¹³ nɨ́¹ má¹ca³jmú³ jáɨ¹³, jun³juáh¹³ má²lɨ́²hɨ́e³² jmáh³la³ ñí¹hiú¹³ yáh³ tsú², quí¹ jɨ³ la³jɨ́³² hi³ ná¹tsɨ²¹ bíh¹ ñí¹ jáun² má²lɨ́²hɨ́e³² tsú²; ");
INSERT INTO csoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","hi³ nɨ́¹juáh³ tsá² hɨe³² cuáh³² chín¹ nɨ́¹ má¹ca³ma³tson² jáɨ¹³ quioh²¹ né³, jun³juáh¹³ má²lɨ́²hɨ́e³² jmáh³la³ cuáh³² yáh³ tsú², quí¹ hi³ má²lɨ́²hɨen³ tsú² jɨ³ Dió³² bíh¹, Tsá² cuá³ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ja³bí¹ nɨ́¹juáh³ tsá² hɨe³² hñu³mɨ³cuú² nɨ́¹ má¹ca³ma³tson² jáɨ¹³ quioh²¹, jáun² má²hɨe³² tsú² siáh³ la³ jɨ³ hmá²sɨ¹ quioh²¹ bíh¹ Dió³², jɨ³ hnga² Dió³² Tsá² cuá¹tsɨ²¹ siáh³ hmá²sɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”¡Jlánh¹ juon²³ hnoh² tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ hnoh² siáh³ tsá² fariseos, hnoh² tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Re² bíh¹ má²ná¹cueh³² hnoh² cáun² la³ cun³ quia³ ñí¹con² Dió³² la³jɨ́³² ñí¹ hi³ zia³² quián¹³, hí¹ la³ tɨ³ zié² yáh³ cueh³² náh² la³ jáun², jɨ³ má²hna³ eneldo jɨ³ má²hna³ comino nɨ́² siáh³. Tɨ³la³ má¹lɨ³² jáun² né³ tiá² ma³quien¹³ yáh³ náh² héih³² hi³ jlánh¹ bíh¹ quien² hi³ rá¹tioh³ ñí¹ liei²¹, la³ cun³ hi³ jmɨ́¹ lɨ³ rá¹tsɨh³² náh² héih³² cú²tso², hi³ ja³² mií³ honh² náh², jɨ³ hi³ lɨ́n³ náh² tsá² ma³tí³² jë¹ nɨ́² siáh³. Tɨ³la³ jun³juáh¹³ hi³ cháh¹ tɨ³ có³² la³ cun³ hi³ má²ná¹jmuh³² jáun² yáh³ náh² hi³ jmúh¹³ náh² hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Hnoh² tsá² ten³ tsá² quiánh¹ náh² ñí¹ juɨ³², hnoh² jlánh¹ ma³jɨ́h¹³ má³² hi³ cuɨn²³ náh² lú¹³, tɨ³la³ jáh³ cánh¹ jáh³ la³ camello né³ cáun² nah¹ bíh¹ náh²! ");
INSERT INTO csoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹ jɨ³ hnoh² tsá² fariseos, tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹!, quí¹ hnoh² dá² jlánh¹ sɨ́² raɨnh³² náh² cuá¹uon² jmáh³la³ tɨ³ coh³ bíh¹, tɨ³la³ hñu³ honh² náh² né³, jmáh³la³ hi³ hlah³ hi³ hó³² bíh¹ tiu³ canh², hi³ tsɨ́nh² náh² hi³ quioh²¹ tsáu², jɨ³ hi³ dí¹quian¹ náh² má¹zián¹³ siáh³ cun³ tɨn² honh² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Hnoh² tsá² fariseos te³; la³ñí¹ tín² ma³jɨ́¹³ náh² tɨ³ ñeh² cuá¹uon², hi³ jáun² má¹jáun² lɨ³ jɨ² bíh¹ siáh³ tɨ³ coh³. ");
INSERT INTO csoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹ jɨ³ tsá² fariseos nɨ́², tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹!, quí¹ hnoh² dá² ná¹lɨ́n³ náh² la³jmɨ́¹ lɨ́³ jéin³ lo¹ quioh²¹ hla¹ hi³ lɨ́³ tiáu² jmáh³la³ tɨ³ coh³ hi³ jáun² jlánh¹ re² jniá³, tɨ³la³ tɨ³ ñeh² né³ ná¹cónh²¹ hná¹ mú²¹ jɨ³ la³jɨ́³² hi³ hlah³ hi³ hó³² quioh²¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","La³ jáun² bíh¹ lɨ́n³ hnoh²; ñí¹ ta³ ñí¹ tsáu² jniá³ hnoh² chun¹ lɨ́n²¹, tɨ³la³ hñu³ honh² náh² né³, jmáh³la³ tɨ́¹jáɨ² bíh¹ ná¹cónh²¹ jɨ³ la³jɨ́³² hi³ hlah³ hi³ dí¹quiaunh²¹ honh² náh² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”¡Jlánh¹ ma³ juon²³ hnoh² tɨ³² liei²¹ jɨ³ hnoh² tsá² fariseos, tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Hnoh² ná¹jmóuh¹ náh² tá²hón³² quioh²¹ tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³², jɨ³ hi³ jmuh³² náh² siáh³ re² jniá³ jéin³ lo¹ ná¹táun³ ñí¹ ná¹hú¹hón²¹ tsá² chun¹ hí³, ");
INSERT INTO csoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","hi³ má¹lɨ³² jáun² né³, juánh³ náh²: “Sá¹jmɨ́¹ jnoh¹ bíh¹ má²ziáun² jmáɨ¹ hi³ jmɨ́¹ zian² tsá²haun³² dí¹hio³ ñú¹deh³ dí² jmɨ́¹tin², ha³ tiá² jmɨ́¹ jmú¹³ yáh³ dí² cá²hon³ quiúnh¹ tsú² jmɨ́¹ ca³ma³tsan² tsú² jáun² tsá² jmɨ́¹ ná¹lɨ́n³ hí³ tɨ³² jë¹ Dió³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Cun³quionh³ jáɨ¹³ nɨ́² má²ná¹má²lih²¹ hnoh² hi³ hnoh² bíh¹ jón²zɨ́h¹ jón²cho¹ tsá² ca³ma³tsan² hí³ *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jáun² né³, ¡ma³tauh²¹ náh² hná¹ ta²¹ hi³ ca³ma³liáu³² jáun² dí²hioh³ ñú²deh³ náh² jmɨ́¹tin²! ");
INSERT INTO csoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","”¡Tsá² ná¹lɨ́n³ jáh³ hláɨnh¹ bíh¹ hnoh², jón²zɨ́h¹ jón²cho¹ jáh³ hláɨh¹ jáh³ hon²! ¿Ha³ bí¹ lánh³ rón³² liáun³ hnoh² ca³tɨ²¹ hi³ cuá¹ma³tsoh¹ náh² honh² quiu³juóu³²? ");
INSERT INTO csoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Cun³ñí¹ hi³ ca³tɨ²¹ hi³ jáun² bíh¹ zein²¹ jná¹³ ñí¹con² hnoh² tsá² ná¹lɨ́n³ tɨ³² jë¹ Dió³², tsá² quia³lín³ jmɨ́¹ tsɨ́³, jɨ³ tsá² ná¹lɨ́n³ tɨ³² nɨ́² siáh³. Tɨ³la³ hnoh² má¹ná¹, jngɨh¹³ bíh¹ náh² tsá² hí³, hi³ ma³ jan² tsá² hí³ ton¹³ náh² crei²¹, ma³ jan² quiú¹ pan¹³ náh² ca³la³ tɨ³ hñu³ cuáh³² quián¹³ náh², jɨ³ hi³ cuá¹hɨ́¹ cuá¹tsɨn²¹ náh² tsú² siáh³ ma³ quin³² ma³ caun³² juú². ");
INSERT INTO csoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ hi³ tá¹can¹ hnoh² ca³tɨ²¹ jmɨ² hi³ ca³táɨn² quioh²¹ tsá² chun¹ tsá² ca³ma³tsau² hí³ tsáu², ca³la³ cun³ jmáɨ¹ hi³ ca³táɨn² jáun² jmɨ́²hán¹ hla¹ Abel tsá² chun¹ hi³ la³ tɨ³ jmáɨ¹ hi³ ca³táɨn² jáun² jmɨ́²hán¹ hla¹ Zacarías jon² hla¹ Barachías tsá² ca³jngɨh³² hnoh² hí³ ja¹ quioh²¹ ñí¹hiú¹³ quionh³ ñí¹ jlánh¹ bíh¹ hɨ́en¹ quioh²¹ cuáh³² chín¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jú¹ tson² bíh¹ juo³ jná¹³ hnoh², hi³ tsá² zian² né³² bíh¹ tá¹can¹ jmɨ́²hán¹ la³jɨ́n³² tsá² ca³ma³tsan² tsú² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”¡Hnú² juú² Jerusalén, hnú² bíh¹ tsá² jngɨh²³ nú² tɨ³² jë¹ Dió³², tsá² zen² Dió³² ñí¹con² nú², hi³ quí¹ jlan¹ nú² quɨ́n¹! ¡Hliáun³ jéin³² bíh¹ jmɨ́¹ hnó²¹ jná¹³ hi³ chan²¹ jon³zɨ́h¹ hnú² la³jmɨ́¹ chan² cá¹hio³ cu³lɨ²¹ jon² ñeh² chí¹pí¹³; tɨ³la³ hnú² má¹ná¹, tiá² ca³lɨ³hnáuh² yáh³ la³ jáun²! ");
INSERT INTO csoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Sá¹nɨ́² jɨe³, tiú²uú² taunh²¹ yáh³ jná¹³ hó¹ñi³², jáun² má²ca³ta³huen¹³ bíh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Hi³ juanh³² jná¹³ siáh³, tiú²uú² jɨe¹ yáh³ hnú² jná¹³ ca³la³ tɨ³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ juáh¹³ nú²: “¡Hénh³ ma³ chun¹ Tsá² cuá¹jáunh²³ cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²!” ");
INSERT INTO csoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, Jesús cua³han³ hñu³ cuáh³² chín¹, hi³ tá¹la³ má²cuá¹tsanh³² tsú² jáun² né³ ca³ma³janh³² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ñí¹con², hi³ ca³ma³liáu³² hi³ hɨe³² hná¹ hiah³² cuáh³² ñí¹con² dí². ");
INSERT INTO csoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tɨ³la³ Jesús né³ ca³juáh³ la³ lá²: ―¿Jɨ́eh²¹ hnoh² la³jɨ́³² hi³ lá²? Jú¹ tson² juo³ jná¹³ hnoh², hi³ ñí¹ lá² chau²¹ jmáɨ¹ lɨ́¹³ hi³ hí¹ cá² máɨ³ quɨ́n¹ tiú²uú² ná¹juɨn¹ ñí¹ quɨ́n¹ raɨnh²¹; la³jɨ́³² bíh¹ juú¹ tsúnh¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ siáh³ Jesús tsɨ³ máh³ Olivos; hi³ tá¹la³ jmɨ́¹ má²cuá¹tón²¹ tsú² tsɨ³ máh³ jáun² né³, tsá² haɨn²¹ hí³ tɨ³ con² tsú² ja³taunh²¹ ñí¹ cuá³ tsú² hi³ ca³ñí¹zeh¹ dí¹ la³ lá² tá¹la³ tiá² hin² zian²: ―Hnáu² jnoh¹ hi³ juáh¹³ hnú² ha³ lɨ́h³ lɨ́¹³ hi³ má²lɨ́²juah²¹ hnú² jáun². ¿He³ dá² li²¹ lɨ³ zia³² nɨ́¹ má¹tɨ³ ñí¹ ñeih²¹ hnú², jɨ³ jmáɨ¹ hi³ táuh³ tá¹ cáun² ñí¹ hué²¹ lá²? ");
INSERT INTO csoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Hua³hín¹³ lɨ́n³² náh² jmu³, hí¹ jan² lɨ́² hin² cuɨ́¹ má¹cau² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Quí¹ juóun³² lɨ́n³² tsáu² ja³táunh¹ hi³ ja³jmú³ hi³ lɨ́n³ la³juah²¹ dú¹ jná¹³, hi³ ja³juah²¹: “¡Jná¹³ bíh¹ lɨ́n³ Cristo!”, jáun² juóun³² lɨ́n³² bíh¹ tsáu² ma³can² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hnoh² náɨh¹ náh² hi³ má²zia³² hniéi² tɨ³ hlá² tɨ³ nɨ́²; tɨ³la³ ha³ lɨ́² juenh³ náh² má¹ná¹, quí¹ la³ jáun² ca³tɨ²¹ lɨ́¹³ bíh¹ tín²; tɨ³la³ jun³juáh¹³ hi³ má²tsa³hín³ yáh³ jaun³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Quí¹ tsá² zian² cáun² hué³² jmu³ hniéi² quionh³ tsá² zian² hué³² siáh³, jɨ³ tsá² hɨ́n¹³ hué³² ñí¹ hliáun³ siáh³ quiu³ tɨ́n³ quionh³ tsá²ján² tsá²ján²; hi³ ñí¹ hliáun³ siáh³ lɨ³ zia³² ho³cuóun³ jɨ³ hi³ qui³ jɨ́eh³ hué³² tiá³ lɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tɨ³la³ jɨ³lɨ³² hi³ nɨ́² má¹ná¹, cu³ ja¹ má²ca³lɨ³liau³ bíh¹ hi³ ma³tso² tsáu² tsɨ́³, jun³juáh¹³ má²hnáu² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”Má¹jáun² jɨenh³ tsú² hnoh² ñí¹ cuá¹ma³tsoh¹ náh² honh², jɨ³ hi³ jngah³ tsú² nɨ́² siáh³; hi³ tá¹ cáun² hngá¹máh³ bíh¹ lɨ³hau² tsú² hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jmáɨ¹ jáun² né³ juóun³² lɨ́n³² tsáu² tiánh³ tɨ³ có³² ca³tɨ²¹ la³ cun³ hi³ taunh³² ta²¹, hi³ lɨ³hó² lɨ³uon² tsú² raɨnh²¹, jɨ³ hi³ tsá²ján² tsá²ján² bíh¹ tsú² tu³ hna³ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Má¹jáun² ma³jnia³² juóun³² lɨ́n³² tsá² tɨ́¹ jáɨn², hi³ juáh³ hi³ lɨ́n³ *tɨ³² jë¹ Dió³², hi³ jáun² juóun³² lɨ́n³² bíh¹ tsáu² lɨ³can². ");
INSERT INTO csoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cun³ñí¹ hi³ cun³ jmá² cun³ jnia³² tɨ³ lɨ³mí¹ tsá²lɨ́²hliáun²³ hi³ hlah³ hi³ hó³², jáun² juóun³² bíh¹ tsáu² tiú²uú² lɨ³ hnáu³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Tɨ³la³ nɨ́¹juáh³ tsá² nio² cáun² tsɨ́³ la³ má²nio² jáun² ca³la³ tɨ³ ñí¹ cá¹táuh³ jmáɨ¹ né³, tsá² hí³ bíh¹ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hi³ jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsú² jo³cuo² Dió³² né³, há¹ ngá¹³ tá¹ cáun² hngá¹máh³, hi³ jáun² la³jɨ́n³² tsá² zian² tá¹ cáun² hngá¹máh³ lɨ́¹³ lɨ³ cuoh²; hi³ jáun² má¹jáun² máh³ má²lɨ³liau³ hi³ táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”Hla¹ Daniel tɨ³² jë¹ Dió³² ca³hléh³ hi³ ca³tɨ²¹ hi³ hlah³ hi³ hó³², hi³ jmu² jáun² hi³ hliáh¹³ ñí¹ hɨ́en¹. Jáun² nɨ́¹juáh³ má²jɨ́eh³² hnoh² hi³ hi³ jáun² má²nio² ñí¹ hɨ́en¹ né³, ―nɨ́¹juáh³ tsá² hɨ³² jáɨ¹³ lá², cuɨ́¹ ngɨ¹³ tsú²―, ");
INSERT INTO csoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","hi³ jáun² jmáɨ¹ jáun² má²hniáuh³² cuon³ tsá² hɨ́n¹³ tɨ³ Judea ñí¹ lɨ́³ máh³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jáun² nɨ́¹juáh³ tsá² cuá¹tsɨ²¹ tsáɨh³ hñú³ máɨ² tsáɨh³ quioh²¹, ha³ lɨ́² cuɨ́¹ son² tsú² hi³ tsa³quián³ hi³ nio² ñéih³ quioh²¹, hniáuh³² la³juɨ³² cuon³ bíh¹ tsú²; ");
INSERT INTO csoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","hi³ nɨ́¹juáh³ tsá² cuá¹hún¹ ñí¹náɨ² né³, tiá² hniáuh³² yáh³ tsánh³² tsú² hi³ tsa³quián³ ha¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tɨ³la³ ¡jlánh¹ juo²³ tsá²mɨ³ tsá² ná¹quian² jon² jmáɨ¹ jáun², jɨ³ tsá² ná¹jan² dáɨn² tiúh²³ nɨ́² siáh³! ");
INSERT INTO csoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mɨ́¹ náh² ñí¹con² Dió³² hi³ jáun² tiá² lɨ³ hniáuh³² cuóunh¹ náh² jmɨ́¹ ñí²cuóu³, hi³ sa³jun³ *jmáɨ¹ hi³ tionh² tsú² tie³; ");
INSERT INTO csoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","quí¹ jmáɨ¹ jáun² lɨ³zia³² cáun² uu³mí²tsɨ³² huáh² tsɨ́³ cu³tí¹³, cáun² hi³ hí¹ cónh³ tiá² má²lɨ³² la³ cun³ jmɨ́¹ lɨ²¹ hngá¹máh³ lá², hi³ sa³jun³ lɨ³zia³² bíh¹ siáh³ tɨ³ chí¹cáɨn² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sá¹jmɨ́¹ hi³ Dió³² tiá² hná³² jmáɨ¹ jáun² dúh¹, jáun² ca³la³ jɨ́n³² bíh¹ tsáu² jmɨ́¹ hiá¹ jmɨ́¹ tsán¹³; tɨ³la³ cun³ñí¹ hi³ ca³tɨn¹ tsá² má²ná¹quiánh¹ bíh¹, hi³ jáun² bíh¹ má²ca³hná³ Dió³² jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”Jáun² né³, nɨ́¹juáh³ má¹jáun² má²zian² tsá² juáh³ ñí¹con² hnoh²: “¡Sá¹nɨ́² jɨe³, ñí¹ lá² má²cuá³ Tsá² lɨ́n³ Cristo!”, ho³: “¡Sá¹nɨ́² jɨe³, ñí¹ zio¹ má²cuá³!”, ha³ lɨ́² lɨ́¹ táunh³ náh² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Quí¹ juóun³² bíh¹ tsáu² ja³táunh¹ hi³ ja³ma³cau² hi³ juáh³ hi³ lɨ́n³ Cristo, jɨ³ tsá² juáh³ siáh³ hi³ ná¹lɨ́n³ tɨ³² jë¹ Dió³²; hi³ jmu³ siáh³ li²¹ hi³ cáu² hi³ jueh³² lɨ́n³² jɨ³ hua³jueh³² nɨ́² siáh³ hi³ jáun² lɨ³can² tsáu², hi³ hí¹ la³ tɨ³ tsá² má²ca³quianh³ hnga² yáh³ Dió³² ma³can² tsú² siáh³ nɨ́¹juáh³ hi³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Sá¹nɨ́² jɨe³ né³, ta³ ñeh³ bíh¹ má²lɨ́²juo³ jná¹³ hnoh² jáɨ¹³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Cun³ñí¹ hi³ jáun² né³, nɨ́¹juáh³ zian² tsá² juáh³: “¡Sá¹nɨ́² jɨe³, ó³² má²zenh² ñí¹ lɨ́³ cuá¹ quiéin²!”, ha³ lɨ́² cua³táunh¹ náh² ñí¹ jáun². Ho³ nɨ́¹juáh³ hi³ juáh³ tsú²: “¡Sá¹nɨ́² jɨe³, lá² má²cuá³ tsú² ñéih³ lá²!”, ha³ lɨ́² ta²¹ táunh³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Quí¹ la³jmɨ́¹ hia³² sɨ́² quioh²¹ miíh³² tɨ³ máɨ² hi³ jáun² taɨ³² ca³la³ tɨ³ ñí¹ tá²tsɨ²¹ hiú², la³ jáun² bíh¹ lɨ́¹³ nɨ́¹ má¹jaunh³² jná¹³, Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lɨ³ lin¹ bíh¹ jmáɨ¹ jáun² la³jmɨ́¹ lɨ́²lin¹ ñí¹ rá²jún¹ jáh³ cun³quionh³ hi³ jlánh¹ cuú² ngɨh³² tú²jue³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”Jáun² la³ cun³ nɨ́¹ má¹ca³táuh³ uu³mí²tsɨ³² huáh² tsɨ́³ nɨ́² né³, má¹jáun² má²nieh¹³ hiú², hi³ zɨ́h² siáh³ tiú²uú² joh¹ cué³², jɨ³ hi³ ziu³ súh³² siáh³ chí¹jmaɨ²¹ haɨ²¹ chi³cuú², hi³ hí¹ ca³la³ tɨ³ pí³ hi³ jniá³ chi³cuú² yáh³ ru³ juá³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Má¹jáun² jɨ́e³ tsú² li²¹ hñu³mɨ³cuú² hi³ lin¹ hi³ má²cuá¹jáunh²³ Jon² tsá²mɨ³cuóun², hi³ jáun² tsá² zian² tá¹ cáun² hngá¹máh³ bíh¹ ho³ jngɨh³ má¹jáun², quí¹ hi³ jɨ́en³² tsú² Jon² tsá²mɨ³cuóun² hi³ cuá¹jáunh²³ juɨ³² ja¹ jnie² chi³cuú² quionh³ pí³ hi³ cáu² hi³ jueh³² hi³ lin¹ hi³ quien² lɨ́n³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Má¹jáun² zen³ tsú² tsá²cuú² tsá²ta³ hi³ jiéi³² tiá³ lɨ́n³² mí¹ñí², hi³ chan³ cu³lɨ²¹ tsá² má²ná¹quiánh¹ hí³ joh¹ tsú², tsá² zian² tá¹ quiún³ cuoh¹ mɨ³cuú², la³ tɨ³ jo²¹ cá² táun² cá² táun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”Cuɨ́¹ ngɨ¹³ náh² jáɨ¹³ hi³ jmu¹ jná¹³ lá² cun³quionh³ hmá² sí² co²: Jɨ́eh³² hnoh² nɨ́¹juáh³ jmɨ́¹ tá¹jmu¹³ hmá² hi³ má²ná¹hion² siáh³ mu²¹ zɨ́h³, jáun² má²ñíh¹ hnoh² hi³ má²má²janh² bíh¹ jmɨ́¹ ñí²hiú². ");
INSERT INTO csoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ja³bí¹ la³ jáun² bíh¹ siáh³, nɨ́¹juáh³ má²jɨ́eh³² hnoh² hi³ má²lɨ́²³ la³jɨ́³² hi³ má²lɨ́²juánh³² jná¹³ jáun², jáun² má²ñíh¹ náh² hi³ ho³hñú¹³ bíh¹ má²zenh² jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Jú¹ tson² juo³ jná¹³ hnoh², hi³ la³jɨ́³² hi³ nɨ́² lɨ́¹³ ñeh² bíh¹ hi³ hiá¹ tsán¹³ tsá² zian² jmáɨ¹ hi³ ziáun² dí² lá². ");
INSERT INTO csoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Chau²¹ jmáɨ¹ tsa³hín³ la³jɨ́³² hi³ jniá³ chi³cuú² la³ má²quionh³ hngá¹máh³ lá², tɨ³la³ jáɨ¹³ quion²¹ jná¹³ má¹ná¹, tiá² tón³² jmáɨ¹ tsa³hín³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Tɨ³la³ hi³ ca³tɨ²¹ hín² jmáɨ¹ ho³ hín² la³ nio¹ lɨ́¹³ la³ jáun² né³, hí¹ jan² yáh³ tiá² hin² ñi³². Hí¹juáh³ tsá²cuú² tsá²ta³ Dió³² tsá² tionh² hñu³mɨ³cuú² yáh³ tiá² ñi³², hi³ sa³jun³ hnga² yáh³ Jon² Dió³² ñi³² siáh³; jɨ́³²la³ hnga² bíh¹ Dió³² Jméi² tsú² ñi³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”Hi³ jáun² né³, la³jmɨ́¹ lɨ²¹ jmáɨ¹ hi³ jmɨ́¹ zian² jáun² hla¹ Noé, la³ jáun² bíh¹ uá²jaɨ³² lɨ́¹³ nɨ́¹ má¹jaunh³² jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Quí¹ jmáɨ¹ jáun², ñeh² bíh¹ hi³ ja³tsauh²¹ jmáɨ², jmɨ́¹ ná¹cú² ná¹hɨ́nh²³ tsú², hi³ ná¹jéinh³² tsú² cuo² jɨ³ hi³ ná¹cuen² tsú² tsá²mɨ³ jon² hi³ jéinh³² cuo², ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³hi³ hla¹ Noé hñu³ cuó² jueh³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tsá² hí³ né³, tiá² ca³lɨ³tsɨn² yáh³ he³ lɨ́¹³ ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³ja³tsauh²¹ jmáɨ², hi³ jáun² ca³hiá² cá²tsan³ bíh¹ jɨ³lɨn² tsá² hí³. La³ jáun² bíh¹ siáh³ lɨ́¹³ nɨ́¹ má¹jaunh³² Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jmáɨ¹ jáun² tiáunh¹ gon³ tsá²ñuh² ñí¹náɨ²; jan² bíh¹ tsá² hí³ tsánh³², hi³ jan² né³ tá¹zanh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Jmáɨ¹ jáun² siáh³, gon³ tsá²mɨ³ ná¹quiuh³² cán¹; jan² bíh¹ tsá² hí³ tsánh³², hi³ jan² né³, tá¹zanh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","”Cun³ñí¹ hi³ jáun² né³, ná¹ñí¹ hnoh² tianh³, quí¹ tiá² ñíh¹ yáh³ náh² ha³ lɨ́h³ jáunh³ Juóuh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tɨ³la³ cuɨ́¹ lɨ³ ñíh¹ hnoh² jáɨ¹³ lá²: Sá¹jmɨ́¹ hi³ ñi³² tsá² hñú¹³ hín² la³ nio¹ cuán¹³ háɨn² ta³ já¹niéi², hi³ jáun² jmɨ́¹ lɨ́¹³ bíh¹ cuá³² tsú² cuá¹ñí¹, hi³ tiá² jmɨ́¹ cué²¹ yáh³ tsú² jáɨ¹³ hi³ hí³ háɨn² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hi³ jáun² bíh¹ hniáuh³² tionh² hnoh² hua³jan²¹; quí¹ cáun² jmáɨ¹ hi³ tiá² lɨ́n²³ bíh¹ hnoh² jáunh¹³ jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","”Né³² né³, nɨ́¹juáh³ zian² jan² tsá² quian²¹ chun¹, tsá² jlánh¹ quia³lín³ jmɨ́¹ tsɨ́³, hi³ jáun² juo¹³ tsú² chan³ la³jɨ́n³² tsá² quian²¹ ñí¹ hná¹ jáun² jo³cuo² hí³ dí² hi³ jmu³ dí² héih³² ñí¹con² tsá² hí³, jɨ³ hi³ jmu³ tsú² siáh³ héih³² hín² la³ nio¹ lɨ́¹³ jmu³ tsú² má³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jlánh¹ jmɨ́¹ ren² tsá² quian²¹ la³ hí³ nɨ́¹juáh³ hi³ cuá¹má²tí³² tsú² héih³² quioh²¹ juo¹³ nɨ́¹ má¹cuanh³². ");
INSERT INTO csoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jú¹ tson² juo³ jná¹³ hnoh², hi³ juo¹³ tsá² hí³ má²chá³² la³jɨ́³² hi³ zioh² jo³cuo² tsú², hi³ jáun² tɨ³ má²zó³² bíh¹ tá¹³ tsú² lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Tɨ³la³ nɨ́¹juáh³ tiá² la³ chun¹ yáh³ tsá² quian²¹ hí³ né³, hi³ cuá¹lɨ́n²³ hi³ tiá² má²jáunh³ yáh³ juo¹³, ");
INSERT INTO csoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","hi³ jáun² tsá² quian²¹ raɨnh²¹ bíh¹ cuá¹quí² cuá¹quiunh² jɨ³ hi³ cuá¹cú² cuá¹hɨ́nh²³ hi³ cuá¹má²héinh³² siáh³ quionh³ tsá² hen²; ");
INSERT INTO csoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jáun² juo¹³ tsú² né³, cuánh³² cáun² jmáɨ¹ hi³ tiá² cuá¹jan²¹ bíh¹ tsú², caun² o¹rá¹ hi³ tiá² ñi³² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Hi³ jáun² má¹jáun² ma³tson¹³ tsú² tsá² hí³ chí¹nga² cu³tí³, hi³ jáun² má¹lɨ³² jáun² zen³ tsú² ñí¹ ca³tɨn¹ tsa³táunh¹ tsá² lɨ́n³ la³ cá¹ la³ jéinh¹. Hi³ jáun² ñí¹ jáun² tsa³hó² tsa³jngɨh³² tiáunh¹, jɨ³ hi³ tsa³quí² tsa³hon³² lɨ́n³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”Jáun² né³, jmáɨ¹ hi³ lɨ³ lin¹ hin² tsánh² lɨ́¹³ tónh³² jo³cuo² Dió³² lɨ́¹³ la³jmɨ́¹ cá¹quiúnh²¹ quian³ tsá¹máɨ¹³ tsá² ca³lɨ³ tén¹ ñí¹ ca³jenh² cuo² tsáu². Tsá² hí³ ca³can³ sɨ́² quioh²¹ la³ má²quionh³ jmɨ́² no¹, hi³ jáun² ja³taunh²¹ hi³ ca³ñí¹hen¹³ tsá²ñuh² tsá² jenh¹³ cuo². ");
INSERT INTO csoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tɨ³la³ hñá³ tsá² hí³ tiá² hua³jan²¹ jmɨ́¹ tiáunh¹ yáh³, hi³ hñá³ né³ lɨ́n³ tsá² zian² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tsá² tiá² hua³jan²¹ tiáunh¹ hí³ né³, ca³can³ sɨ́² quioh²¹, tɨ³la³ tiá² ca³can³ yáh³ jmɨ́² no¹ hi³ táuh³²; ");
INSERT INTO csoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","tɨ³la³ tsá² zian² tsɨ́³ hí³ né³ ca³can³ sɨ́² quioh²¹ la³ má²quionh³ zɨ́³ ha²¹ jmɨ́² no¹. ");
INSERT INTO csoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tsá²ñuh² tsá² jenh¹³ cuo² hí³ né³ ca³lén³ bíh¹ ca³lá², jáun² ziú³ bíh¹ ca³tóh³ ñí¹ tsá¹máɨ¹³ hí³, hi³ jáun² ca³cuóun² la³jɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hi³ jáun² ta³ hua² ca³náɨ³² tsú² cáun² mah¹ hi³ ñí¹juah²¹: “¡Lá² má²jaunh³² tsá²ñuh² tsá² jenh¹³ cuo²; huen³ náh² hi³ ñá²hinh²¹ náh² tsú²!” ");
INSERT INTO csoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Hi³ jáun² la³jɨ́n³² tsá¹máɨ¹³ hí³ ca³nu³ ca³tiánh³ hi³ ca³héinh³ siáh³ sɨ́² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jmɨ́¹jáun² ca³juáh³ tsá² hñá³ tiá² hua³jan²¹ jmɨ́¹ tiáunh¹ hi³ ca³záɨh³ tsá² hñá³ jmɨ́¹ tiáunh¹ hí³ hua³jan²¹: “Cué¹ tiá³ ca³lá² jmɨ́² no¹ quián¹³ ñí¹con² jnoh¹, quí¹ má²ñí¹yéi²¹ bíh¹ sɨ́² quiú¹³ jnoh¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tɨ³la³ tsá¹máɨ¹³ tsá² ná¹tiáunh¹ hí³ hua³jan²¹ né³ ca³záɨh³ raɨnh²¹ la³ lá²: “Tiá² jáun² yáh³, quí¹ nɨ́² lɨ́¹ tiá² ca³laɨn²¹ yáh³ quiú¹³ dí² la³jáɨ³²”. Tɨ³ re² cuá²táunh¹ náh² ñí¹ hna² tsú² jmɨ́² no¹ hi³ cuá¹liáh³ náh² quián¹³ hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tɨ³la³ tá¹la³ ca³ñí¹lia³² tsá¹máɨ¹³ hñá³ hí³ jmɨ́² no¹ quioh²¹ né³, cuanh³ bíh¹ tsá²ñuh² tsá² jenh¹³ cuo². Jáun² tsá¹máɨ¹³ tsá² jmɨ́¹ tiáunh¹ hí³ hua³jan²¹ né³, taunh³ bíh¹ ñéih³ quionh³ tsá²ñuh² hí³ ñí¹ ca³jenh² cuo² tsú², hi³ jáun² ca³jna² bíh¹ ho³hñú¹³ jmɨ́¹ lɨ²¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hi³ jmɨ́¹ má²cu³lé³ jáun² né³ cua³tanh²¹ tsá²mɨ³ hñá³ tiá² hua³jan²¹ jmɨ́¹ tiáunh¹ hí³ hi³ ca³juáh³ la³ lá²: “¡Nia²¹ tiá³ ho³hñú¹³ hi³ tauh²¹ jnoh¹!” ");
INSERT INTO csoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tɨ³la³ tsá²ñuh² hí³ ca³ngáɨ³ hi³ juáh³: “Ha³ tiá² hnoh² cuóu³² yáh³ jná¹³ tsá²mɨ³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Jáun² né³, tianh³ náh² ná¹ñí¹ náh², quí¹ tiá² ñíh¹ yáh³ hnoh² ha³ lɨ́h³ chau²¹ jmáɨ¹, ho³ hín² la³ nio¹ jáunh³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","”Ja³bí¹ la³ jáun² siáh³ lɨ́¹³ nɨ́¹ má¹tɨ³ ñí¹ quianh³ Dió³² tsá² tónh³² jo³cuo² la³jmɨ́¹ lɨ²¹ jmáɨ¹ hi³ ngau³ jan² tsá²ñuh² ñí¹ uóunh³; hi³ jmɨ́¹ tɨ³ ñí¹ cua³haɨn³² tsú² né³, ca³teh³ tsá² quian²¹, hi³ jáun² ca³chá³ dí² quɨe³ quioh²¹ jo³cuo² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jo³cuo² jan² tsá² quian²¹ hí³ ca³chá³ tsú² hñá³ tuh³² tioh³ quiu³quia³ mei²¹ héih³² quɨe³ *cú¹tiáu² cun³ tá¹ hñá³, hi³ jan² né³ ca³cuéh³ dí² tun³ tuh³² tioh³ quia³tún³ mei²¹ héih³² quɨe³ cú¹tiáu² cun³ tá¹ tun³, hi³ jan² né³ ca³cuéh³ dí² cáun² tuh³² tioh³ jñéi³ mei²¹ héih³² quɨe³ cú¹tiáu²; ma³ quin³² ma³ jan³² tsá² hí³ hiauh³ lin¹ la³ cun³ rón³² hi³ lɨ³ cah¹³ jmáɨ¹ hi³ cóh³². Jmɨ́¹ lɨ²¹ jáun² né³ ngau³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tsá² quian²¹ tsá² ca³héi³ hñá³ tuh³² cú¹tiáu² jáun² ca³jmú³ ta²¹ hi³ ca³ra³tsɨ³² quɨe³ jáun², hi³ jáun² ca³ta³tsaɨh²¹ cónh³í¹ hñá³ tuh³² quɨe³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","La³ jáun² bíh¹ siáh³ ca³jmú³ tsá² ca³hiauh³ tun³ tuh³² cú¹tiáu², hi³ ca³ta³tsaɨh²¹ siáh³ cónh³í¹ tun³ tuh³² quɨe³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Tɨ³la³ tsá² ca³héi³ hí³ cáun² tuh³² tán¹ cú¹tiáu² má¹ná¹, ngah³ bíh¹ hi³ ca³ñí¹ho³² cáun² táu² hué³² hi³ ca³hmá³ quɨe³ jáun² quioh²¹ juo¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Jmɨ́¹ má²já²uén³ lɨ́n³² jáun² né³, cuanh³ bíh¹ juo¹³ tsú². Jmɨ́¹ cuanh²¹ jáun² tsú² né³ ca³ngáɨh³ tsá² quian²¹ hi³ he³ cónh³ quɨe³ má²ta³tsaɨh²¹ tsú² la³ ma³ quin³² ma³ jan³². ");
INSERT INTO csoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tsá² ca³héi³ hñá³ tuh³² cú¹tiáu² cuan³ la³ñí¹, hi³ jáun² ca³jɨenh³ juo¹³ cónh³í¹ hñá³ tuh³² cú¹tiáu² hi³ má²ta³tsaɨh²¹ jáun², hi³ ca³juáh³ la³ lá²: “Tɨ³², lá² nio² hñá³ tuh³² cú¹tiáu² hi³ jmɨ́¹ ca³cuéh¹ hnú² jáun², hi³ lá² nio² siáh³ cónh³í¹ hñá³ tuh³² hi³ ca³ta³tsaɨ²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jáun² juo¹³ tsú² ca³juáh³: “Jlánh¹ re² la³ nɨ́², hnú² bíh¹ jan² tsá² quian²¹ chun¹, tsá² má²tí³² la³ cun³ rón³² lɨ́³ héih³² hi³ hiáuh²³. Cun³ñí¹ hi³ ca³jmuh³ hnú² re² la³ cun³ rón³² lɨ́³ cú¹pih²¹ hi³ ca³chá³ jná¹³ jo³cuonh² hnú², hi³ jáun² tɨ³ hliáun³ bíh¹ má²chá¹³ jná¹³ jo³cuonh² hnú² ta³né³². Hú³² ñéih³ hi³ má¹hiúnh¹³ nú² honh² quiúnh¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jmɨ́¹ lɨ²¹ jáun² cuan³ siáh³ tsá² quian²¹ tsá² ca³héi³ tun³ tuh³² cú¹tiáu², hi³ ca³juáh³: “Tɨ³², tun³ tuh³² cú¹tiáu² jmɨ́¹ ca³cuéh¹ hnú² jná¹³, hi³ lá² nio² cónh³í¹ tun³ tuh³² cú¹tiáu² hi³ ca³ta³tsaɨ²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jmɨ́¹jáun² ca³juáh³ juo¹³ tsú²: “Jlánh¹ re² la³ nɨ́², hnú² bíh¹ jan² tsá² quian²¹ chun¹, tsá² má²tí³² la³ cun³ rón³² lɨ́³ héih³². Hi³ cun³ñí¹ hi³ ca³ma³tih²¹ nú² la³ cun³ rón³² lɨ́³ cú¹pih²¹ hi³ ca³chá³ jná¹³ jáun² jo³cuonh² hnú², hi³ jáun² tɨ³ hliáun³ bíh¹ hi³ má²chá¹³ jná¹³ jo³cuonh² hnú² ta³né³². Hú³² ñéih³ hi³ má¹hiúnh¹³ nú² honh² quiúnh¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”Tɨ³la³ jmɨ́¹ cuan¹ tsá² quian²¹ tsá² ca³héi³ hí³ cáun² tuh³² tán¹ cú¹tiáu² né³, tsá² hí³ ca³juáh³ hi³ ca³záɨh³ juo¹³ la³ lá²: “Tɨ³², jmɨ́¹ má²ño¹ bíh¹ jná¹³ hi³ hnú² jan² tsá² huáh² tsɨ́³, hi³ caun²³ hnú² cáun² hi³ tiá² lɨ́²jñíh³, jɨ³ hi³ caun²³ hnú² siáh³ cáun² hi³ tiá² lɨ́²páh³ nú². ");
INSERT INTO csoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Hi³ jáun² bíh¹ jmɨ́¹ juénh² jná¹³, hi³ jáun² cu³tsa³² ca³hmá³ jná¹³ cú²jueh³² quɨéɨh³ hnú² hñu³ hué³². Sá¹nɨ́² jɨe³, lá² bíh¹ rón³² la³ cun³ rón³² hi³ jmɨ́¹ ca³cuéh¹ hnú² quián¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jáun² juo¹³ tsú² ca³ngáɨ³: “Hnú² tsá² quian²¹ hláɨh¹, juoh². Jmɨ́¹ la³ má²ñíh¹ bíh¹ hnú² hi³ jná¹³ jan² tsá² caun² cáun² hi³ tiá² lɨ́²jñí³², jɨ³ hi³ caun³² jná¹³ siáh³ cáun² hi³ tiá² lɨ́²pá³ ná¹ hí¹ cú¹pih²¹; ");
INSERT INTO csoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","hi³ jáun² jmɨ́¹ hniáuh²¹ bíh¹ jmuh²¹ hnú² ta²¹ quɨe³ nɨ́² quion²¹ jná¹³, uá¹jinh¹ hñú³ ñí¹ rá²tsɨ³² tsú² quɨe³ bíh¹ jmɨ́¹ cuá¹tionh² nú², hi³ jáun² jmɨ́¹ cuanh²¹ jná¹³ jmɨ́¹ má²lɨ́¹³ héih¹ jná¹³ hi³ má²tsɨn² bíh¹ quɨe³ quion²¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hi³ jáun² ca³záɨh³ tsú² tsá² jmɨ́¹ tionh¹ ñí¹ jáun² la³ lá²: “Quin³² náh² tuh³² tioh³ quɨe³ nɨ́², hi³ jáun² cuéh³ tsá² quian³² quia³ tuh³² cú¹tiáu². ");
INSERT INTO csoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Quí¹ nɨ́¹juáh³ tsá² zia³² quioh²¹, tɨ³ hiáuh³ bíh¹, hi³ jáun² tɨ³ lɨ́¹ tú² lɨ́¹ ziáun²³ bíh¹ quioh²¹ tsú² lɨ́¹³; tɨ³la³ nɨ́¹juáh³ tsá² tiá² zia³² quioh²¹ né³, tɨ³ quin³ bíh¹ tsú² la³ cun³ cú¹pih²¹ hi³ zia³² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hi³ jáun² tɨ³ cheih³² ñí¹ já¹niéi² tion³ náh² tsá² quian²¹ tiá² lin¹ ñí¹ jmu³ ta²¹ nɨ́², hi³ jáun² ñí¹ nɨ́² cuɨ́¹ cha³háu³ jɨ³ hi³ cuɨ́¹ cha³quí² cha³hon³²”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”Jáun² né³, nɨ́¹ má¹jaunh³² Jon² tsá²mɨ³cuóun² hi³ lin¹ hi³ quien², quionh³ tsú² jɨ³lɨn² tsá²cuú² tsá²ta³ tsá² tionh² hñu³mɨ³cuú², hi³ jáun² má¹jáun² né³ cuá³² tsú² ñí¹ hmá²sɨ¹ quioh²¹, ñí¹ lɨ́³ cú²tú¹ cú²lí¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Má¹jáun² cuú¹ ngɨh¹³ la³jɨ́n³² tsá² zian² tá¹ cáun² hngá¹máh³ ñí¹ hó²¹ñí¹ tsú², hi³ jáun² tson³ dí² tsá² hí³ la³jmɨ́¹ jmu² jan² tsá² jmu² hua³hí¹³ jáh³, hi³ cánh³ chan² tsú² *já¹ziáh², hi³ cánh³ chan² tsú² siáh³ zéin¹. ");
INSERT INTO csoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Já¹ziáh² chan³ tsú² tɨ³ cuá² chu²¹ quioh²¹, hi³ jáun² zéin¹ né³ chan³ tsú² tɨ³ cuá² cáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","”Má¹jáun² né³, Tsá² lɨ́n³ hí³ Re²¹ záɨh³² tsá² tionh² tɨ³ cuá² chu²¹ quioh²¹: “Ñá²táunh¹ hnoh² tsá² má²ca³ma³mieh² Ñuh³² jná¹³; tiónh³² náh² ñí¹ cuá¹quien² Dió³², ñí¹ má²ná¹lɨ́³ hua³jan²¹ quián¹³ náh² ca³la³ cun³ jmɨ́¹ ca³jmú³ Dió³² tá¹ cáun² mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Quí¹ jmɨ́¹ ca³lɨ³ ñí¹cuóun²¹ jná¹³, hnoh² bíh¹ ca³cuéh¹ má³² hi³ ca³cúh³²; jmɨ́¹ lɨ²¹ hí¹quiéin² tsɨn³² jná¹³, hnoh² bíh¹ ca³cuéh¹ jmáɨ² hi³ ca³áɨh³² jná¹³; jmɨ́¹ lɨ́¹ ca³tɨ³ ca³ngɨ́³ jná¹³, hnoh² bíh¹ ca³cuéh¹ hñú³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jmɨ́¹ lɨ²¹ hi³ tiá² zia³² hán² jná¹³, ca³cuéh¹ bíh¹ hnoh²; jmɨ́¹ ca³lɨ³ tsáun¹ jná¹³, ca³ñí¹jɨe¹ bíh¹ hnoh²; hi³ ca³ñí¹jɨe¹ bíh¹ siáh³ hnoh² jmɨ́¹ cá¹hú²¹ jná¹³ hñu³mí¹ñí²”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”Hi³ jáun² tsá² má²ca³ma³zian² hí³ la³ cun³ hi³ tɨ³² tsɨ́³ Dió³² né³ lɨ́¹³ juáh³ la³ lá²: “Tɨ³², ¿hín² dá² jmɨ́¹ ca³neh²¹ jnoh¹ hnú² hi³ ñí¹cuon¹³, hi³ jáun² jnoh¹ ca³cué¹³ hi³ ca³quɨéɨh³? Ho³ ¿hín² dá² jmáɨ¹ ca³neh²¹ jnoh¹ hnú² hi³ hí¹quiéin² honh², hi³ jáun² jnoh¹ ca³cué¹³ jmáɨ²? ");
INSERT INTO csoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Lɨ́h³ dá² ca³neh²¹ jnoh¹ hi³ hnú² lɨ́¹ ñi³tɨ́¹ ñi³ngɨ́h¹, hi³ jáun² jnoh¹ ca³cué¹³ hñú³? Ho³ ¿lɨ́h³ ca³lɨ³ hniauh³ hanh² nú², hi³ jáun² jnoh¹ ca³cué¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Hín² jmáɨ¹ ca³lɨ³ tsáun¹ hnú², ho³ hi³ ca³húh³² hnú² hñu³mí¹ñí², hi³ jáun² jnoh¹ né³ ca³ñí¹neh²¹?” ");
INSERT INTO csoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","”Hi³ jáun² Re²¹ hí³ né³ nga³ la³ lá²: “Jú¹ tson² juanh³² jná¹³, hi³ lɨ³ua³ cáun² hi³ ca³jmuh³ náh² ñí¹con² lɨ³ua³ jan² tsá² tsɨ́¹juɨ́³ renh² jná¹³ lá², ñí¹con² jná¹³ bíh¹ lɨ́²jmuh³ hnoh² hi³ jáun²”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”Nɨ́¹ má¹lɨ³² jáun² né³ záɨh³² tsú² tsá² tionh² hí³ tɨ³ cuá² cáun¹ la³ lá²: “Tɨ³ nɨ́² cuá²táunh¹ hnoh², hnoh² tsá² má²ca³ta³tonh¹ ñí¹ hlah³, cuá²táunh¹ náh² ja¹ sɨ́² tiá² tón³² jmáɨ¹ yéi³² ñí¹ má²ná¹lɨ́³ hua³jan²¹ quioh²¹ tsá² hláɨnh¹ la³ má²quionh³ tsá²cuú² tsá²ta³. ");
INSERT INTO csoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Quí¹ jmɨ́¹ lɨ²¹ ñí¹cuóun²¹ jná¹³, tiá² ca³cuéh¹ yáh³ hnoh² má³² cuh²¹ jná¹³; jmɨ́¹ lɨ²¹ hí¹quiéin² tsɨn³² jná¹³, ha³ tiá² ca³cuéh¹ yáh³ hnoh² jmáɨ² hi³ aɨh²¹ jná¹³; ");
INSERT INTO csoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","jmɨ́¹ lɨ́¹ ca³tɨ³ ca³ngɨ́³ jná¹³ siáh³, ha³ tiá² hñú³ ca³cuéh¹ yáh³ hnoh². Jmɨ́¹ lɨ²¹ hi³ tiá² zia³² hán² jná¹³, tiá² lɨ́¹ ca³cuéh¹ yáh³ hnoh² hí¹ cá² tsonh². Jmɨ́¹ ca³lɨ³ tsáun¹ jná¹³ jɨ³ hi³ ca³hú³² jná¹³ siáh³ hñu³mí¹ñí², ha³ tiá² hnoh² ca³ñí¹jɨe¹ yáh³ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”Má¹jáun² né³, tsá² hí³ lɨ́¹³ nga³: “Tɨ³², ¿lɨ́h³ dá² ca³neh²¹ jnioh¹ hi³ hnú² ñi³ngɨ́h¹ ñí¹cuon¹³ ho³ hi³ ñí¹húh² nú² jmáɨ²? ¿Lɨ́h³ ca³neh²¹ jnoh¹ hi³ hnú² lɨ́¹ tɨ́¹ lɨ́¹ ngɨ́h¹? Ho³ ¿hín² dá² jmɨ́¹ ca³lɨ³ tsáun¹ hnú², ho³ hi³ ca³húh³² hnú² hñu³mí¹ñí², hi³ jáun² jnoh¹ né³, tiá² ca³má¹hau¹?” ");
INSERT INTO csoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","”Jáun² Re²¹ né³ nga³ la³ lá²: “Jú¹ tson² juo³ jná¹³ hnoh², lɨ³ua³ cáun² hi³ tiá² lɨ́²jmuh³ náh² ñí¹con² lɨ³ua³ jan² tsá² tsɨ́¹juɨ́³ lá², ñí¹con² jná¹³ bíh¹ tiá² lɨ́²jmuh³ náh²”. ");
INSERT INTO csoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","”Má¹lɨ³² jáun² tsa³táunh¹ tsá² hí³ ja¹ sɨ́² ñí¹ tsa³ma³tso² tsɨ́³ la³ cun³ jmɨ́¹hi³nio², tɨ³la³ tsá² ca³ma³zian² hí³ la³ cun³ hi³ tɨ³² tsɨ́³ Dió³² má¹ná¹, tsa³tánh¹ ñí¹ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³jɨ́³² jáɨ¹³ nɨ́² né³, jmɨ́¹jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con²: ");
INSERT INTO csoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Má²ná¹ñíh¹ hnoh² hi³ yó³² tɨ²¹ *Jmɨ́¹hɨ́en¹; hi³ jáun² jná¹³ né³, Jon² tsá²mɨ³cuóun², ton³ tsú² crei²¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hi³ jáun² né³, jmɨ́¹jáun² ca³cuú² ca³ngɨh³² tsá² ná¹lɨ́n³ mi³jmú³ ñí¹ lɨ́³ ñí¹ta²¹ quioh²¹ Caifás tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹, quionh³ tsú² tsá²daun³² tsá² ná¹ñí¹ juú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hi³ jáun² ñí¹ jáun² ca³ma³cú¹ ma³ren²¹ tsú² jáɨ¹³ hi³ zanh³ Jesús ta³máɨh³, hi³ jáun² jngɨh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jáun² ca³juónh³ tsú² siáh³ la³ lá²: ―Ha³ tiá² zanh¹³ yáh³ dí² tsú² tá¹la³ jmáɨ¹ má¹ná¹, quí¹ ho³ sa³ nɨ́² lɨ́¹ ca³taunh³ tsáu² tiá³ siaun³². ");
INSERT INTO csoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hi³ jáun² né³, tá¹la³ jmɨ́¹ cuá¹tón²¹ Jesús já¹ juú² Betania, hñú¹³ Sí¹mu²¹ tsá² jmɨ́¹ téh²³ tsú² hí³ “tsá² lɨ́n³ *mɨ³ho²¹ péin³”, ");
INSERT INTO csoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","hi³ jáun² ca³chó³² jan² tsá²mɨ³ hi³ quian³² cáun² tse³ míh¹ hi³ lɨ́³ cún¹ tiáu² alabastro, hi³ ha²¹ no¹ má²ró³², cáun² hi³ hmuh²¹ lɨ́n²¹. Tá¹la³ cuá¹tón²¹ jáun² Jesús ñí¹ mesa ca³sé³ tsá²mɨ³ hí³ no¹ má²ró³² jáun² chí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jmɨ́¹ ca³jɨ́e³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ jáun², jáun² ca³míh³ tsɨ́³, hi³ jáun² ca³juu³ ca³hlénh³ hi³ juáh³: ―¿He³ láɨh³² sa³ lɨ́¹ quí² lɨ́¹ hin²³ yáh³ tsú² hi³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hi³ nɨ́² dá² cáun² hi³ jmɨ́¹ lɨ́¹³ tsa³hnáɨ¹ hmuh²¹ bíh¹, hi³ jáun² quɨe³ jáun² jmɨ́¹ lɨ́¹³ cuéh³² tsú² tsá² tia³mii². ");
INSERT INTO csoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús né³ ca³náɨ³² jáɨ¹³ jáun², hi³ jáun² ca³juáh³: ―¿He³ láɨh³² ma³tsan¹³ hnoh² tsɨ́³ tsá²mɨ³ lá²? Quí¹ cáun² hi³ chu²¹ bíh¹ la³² má²lɨ́²jmú³ tsú² ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Quí¹ la³jɨ́³² jmáɨ¹ bíh¹ zian² tsá² tia³mii² ja¹ quián¹³ hnoh², tɨ³la³ jná¹³ né³, jun³juáh¹³ jmáɨ¹ ca³la³ jɨ́³² yáh³ cuon¹ jná¹³ ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hi³ jáun² la³ cun³ hi³ má²lɨ́²jmú³ tsá²mɨ³ lá² ñí¹con² jná¹³, hi³ má²lɨ́²sé³² tsú² jná¹³ no¹ má²ró³², má²lɨ́²jmú³ tsú² hua³jan²¹ hi³ ca³tɨ²¹ jmáɨ¹ hi³ tsa³haun³ bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Quí¹ jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ cáun² ñí¹ tsa³hléh² tsú² jú¹ chú³² tá¹ cáun² hngá¹máh³, ja³bí¹ tsa³chá² tsú² siáh³ la³ cun³ hi³ má²lɨ́²jmú³ tsá²mɨ³ lá², hi³ jáun² chau¹³ tsɨ́³ tsáu² hi³ ca³tɨn¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jáun² né³, jan² tsá² quian³tun³ joh¹ tsú², tsá² jmáɨ² Judas tsá² ja³ hí³ tɨ³ juú² Queriot ñéi¹ hi³ ca³ñí¹lienh¹³ tsá² ná¹lɨ́n³ mi³jmú³, ");
INSERT INTO csoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hi³ ca³ñí¹juah²¹ la³ lá²: ―¿Cónh³ cuéh¹ hnoh² nɨ́¹juáh³ hi³ jɨenh²¹ jná¹³ Jesús? Jáun² tsá² hí³ né³ ca³cué³ quiu³quia³ héih³² quɨe³ hu²¹ quiún³ *cú¹tiáu² la³ ma³ cáun². ");
INSERT INTO csoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","La³ cun³ jmɨ́¹jáun² ca³hnauh² Judas tsɨ́³ he³ lánh³ rón³² lɨ́¹³ jɨenh³ dí² Jesús ñí¹con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ cua³hlau³ Jmɨ́¹hɨ́en¹, jmáɨ¹ hi³ cúh² tsá² *judíos *hí³ cuú²miih²¹, la³ cun³ hí¹miih²¹ tiá² tie³ jan² yáh³, jáun² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ca³ja³janh³² hi³ ca³ngáɨ³, hi³ juáh³ la³ lá²: ―¿Ha³ jinh¹ hnáuh² hnú² tsá¹jmú¹³ jnoh¹ hua³jan²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá² hi³ cúh¹³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jáun² hí³ né³ ca³ngáɨ³: ―Cuá²táunh¹ náh² já¹ juú², hñú¹³ jan² tsá²ñuh², hi³ cuá²zéih³ náh² la³ lá²: “Tɨ³² Juo¹³ jnoh¹ ñí¹juah²¹: Má²ñí¹chau²¹ héih³² quion²¹ jná¹³, hi³ jáun² hñuh³² hnú² jmu¹ jná¹³ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá² quiúnh¹ ná¹ tsá² haɨn²¹ tɨ³ con² ná¹”. ");
INSERT INTO csoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ca³jmú³ la³ cun³ hi³ má²lɨ́²juáh³ jáun², hi³ ca³ñí¹jmú¹³ hua³jan²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jmɨ́¹ má²ca³zɨ³² jáun² né³ ca³cuá³ Jesús ñí¹ mesa quionh³ tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con²; ");
INSERT INTO csoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","hi³ tá¹la³ ná¹jmu² tsú² jáun² má³² né³, ca³juáh³ dí² la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ ja¹ quián¹³ náh² nɨ́² zian² jan² tsá² né³bí¹ jɨenh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jmɨ́¹jáun² jlánh¹ hlaɨh³ ca³niau²¹ tsɨ́³ tsá² hí³, hi³ jáun² ca³ma³liáu³² tsú² hi³ ca³ngáɨh³ Jesús ma³ quin³² ma³ jan³², hi³ juáh³: ―Hnú² Tɨ³², ¿hí¹ jná¹³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Hi³ jáun² Jesús ca³juáh³: ―Tsá² hí³ bíh¹ jɨenh³ jná¹³, tsá² cáun² uon² cuh³² jná¹³ quiúnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Quí¹ jná¹³ Jon² tsá²mɨ³cuóun², cuá¹tsau³² bíh¹ hná¹ he² juɨ³² hi³ ca³tɨn¹, la³ cun³ hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³²; tɨ³la³ ¡juo²³ bíh¹ tsá²ñuh² tsá² jɨenh³ jná¹³! Tɨ³ jlánh¹ bíh¹ jmɨ́¹ re² quioh²¹ tsá² hí³ sá¹jmɨ́¹ hi³ cu³tsa³² tiá² ca³lɨ³zian² bíh¹ tsú² cú²jueh³² dúh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jmɨ́¹jáun² ca³hléh³ Judas tsá² jɨenh³ hí³ Jesús, hi³ ca³juáh³: ―Tɨ³², ¿hí¹ jná¹³ juáh¹³? Jáun² ca³juáh³ Jesús: ―Ján³, la³ má²lɨ́²juah²¹ hnú² nɨ́² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Tá¹la³ ná¹cúh² tsú² jáun² né³, Jesús ca³can³ hí³ cuú²miih²¹, hi³ jáun² ca³cuéh³ tiá¹hmah¹ Dió³²; jmɨ́¹ lɨ²¹ jáun² ca³ca³ dí², hi³ jáun² ca³tsóh³ dí² ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³ la³ lá²: ―Quɨéɨh³ náh², quí¹ hi³ lá² bíh¹ ngú³ quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jmɨ́¹ lɨ²¹ jáun² ca³can³ dí² siáh³ cáun² copa, hi³ jáun² ca³cuéh³ tiá¹hmah¹ Dió³²; jmɨ́¹ lɨ²¹ jáun² né³ ca³nga³ dí² siáh³ ñí¹ tionh¹ tsá² hí³, hi³ ca³juáh³ la³ lá²: ―Hính³ náh² la³jɨ́n³² hi³ lá², ");
INSERT INTO csoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","quí¹ hi³ nɨ́² bíh¹ jmɨ́²hán¹ jná¹³ hi³ táɨn³² cun³ñí¹ hi³ ca³tɨn¹ juóun³² tsáu², hi³ jáun² lɨ́¹³ hin³ tso³ quioh²¹ tsú²; la³ jáun² bíh¹ lɨ³ lin¹ hi³ má²quien² cáun² nió³² hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ tiú²uú² aɨh²¹ yáh³ jná¹³ mu² ráu³ mɨ³ uóun²jɨeh¹³ lá², ca³la³ tɨ³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ aɨh²¹ jná¹³ mu² ráu³ lin¹³ cu³lɨ²¹ quiúnh¹ hnoh² máh³ jmáɨ¹ hi³ má²cuá¹ho² jná¹³ jáɨ¹³ cun³quionh³ héih³² quioh²¹ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jmɨ́¹ lɨ²¹ jáun² né³ ca³hɨ́e³ tsú² cáun² sun¹ quioh²¹ Dió³², hi³ jáun² jmɨ́¹ lɨ²¹ jáun² ja³taunh²¹ tɨ³ máh³ Olivos. ");
INSERT INTO csoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―La³jɨ́n³² bíh¹ hnoh² tianh¹³ tɨ³ có³² ca³tɨn¹ jná¹³ já¹niéi² lá²; quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Jngɨh²¹ jná¹³ Tsá² jmu² hua³hí¹³ *já¹ziáh², hi³ jáun² já¹ziáh² hí³ né³ lɨ́¹ tiú¹ lɨ́¹ hán¹ bíh¹ lɨ́¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tɨ³la³ nɨ́¹ má¹ca³jenh¹³ jná¹³ jáun² má¹ná¹, ñih²¹ jná¹³ chí¹ján³ la³ cónh³ bíh¹ hnoh² tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Hi³ jáun² Pé¹ né³ ca³juáh³ la³ lá²: ―Uá¹jinh¹ la³jɨ́n³² tsá² ñí¹ hná¹ lá² ca³ta³tonh¹ tɨ³ có³² ñí¹con² hnú², tɨ³la³ jná¹³ má¹ná¹, cun³ tiá² jáun² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tɨ³la³ Jesús né³ ca³záɨh³ Pé¹ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnú², hi³ já¹niéi² lá² bíh¹ cánh³², ñeh² bíh¹ hi³ hau³ cá¹háu², juánh¹³ hnú² hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tɨ³la³ hí³ né³ ca³juáh³: ―Uá¹jinh¹ ca³la³ tɨ³ jmɨ́²chí³ quion²¹ yáh³ jná¹³ ca³cáɨn³ hi³ jún³ jná¹³ cu³lɨ²¹ quiúnh¹ hnú², cun³ tiá² zeih²¹ bíh¹ jná¹³ hnú² tɨ³ có³². La³jɨ́n³² bíh¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú² ñí¹ hná¹ jáun² ca³juáh³ cá²ren². ");
INSERT INTO csoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jmɨ́¹jáun² ca³cha³táunh¹ Jesús quionh³ tsá² quionh³ cáun² ñí¹ téh²³ tsú² Getsemaní, hi³ jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―Tianh³ hnoh² ñí¹ lá² tá¹la³ ñí¹lienh¹ jná¹³ Dió³² ñí¹ zio¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jáun² jɨ́³²la³ gáun³ tsáu² bíh¹ ca³jan³ tsú²: Pé¹, la³ má²quionh³ tá¹ gon³ jon² Zebedeo; jmɨ́¹jáun² ca³lɨ³liau³ hi³ ca³ta³no¹ hlah³ lɨ́n²¹ tsɨ́³ tsú², jɨ³ hi³ ca³la³ hi³ ca³hu³ ca³jngɨh³ lɨ́n³² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jáun² ca³záɨh³ dí² tsá² gáun³ hí³ la³ lá²: ―Jlánh¹ ñí¹jún³ jná¹³ lɨ́²³ cun³ñí¹ hi³ ja³²lɨ³ hlah³ nio² tsɨn³². Tɨ³la³ hnoh² tianh³ náh² ñí¹ lá², hi³ ná¹ñí¹ náh² quiúnh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jáun² né³ Jesús ngau³ ca³lá² tɨ³ chí¹ján³, hi³ jáun² ca³jmú³ cuá¹jñi²³ hi³ ca³hiéih³ ñí¹ la³ tɨ³ hué³² hi³ ca³mɨ́³ ñí¹con² Dió³², hi³ ca³juáh³ la³ lá²: ―Hnú² Tia²¹, sá¹jmɨ́¹ hi³ lɨ́¹³ bíh¹ hi³ liau¹ nú² tiá³ jná¹³ hi³ ca³tɨ²¹ jmáɨ² tsɨ́h³² hi³ ca³tɨn¹ jná¹³ aɨh²¹; tɨ³la³ ha³ lɨ́² cuɨ́¹ lɨ́¹³ la³ cun³ hi³ hnó³² jná¹³ má¹ná¹, cuɨ́¹ lɨ́¹³ bíh¹ la³ cun³ hi³ hnáuh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jmɨ́¹ lɨ²¹ jáun² ngah³ dí² tɨ³ ñí¹ tionh¹ jáun² tsá² gáun³ haɨn²¹ hí³ tɨ³ con², jáun² sa³ ná¹cuóun¹ bíh¹ tsá² hí³ jmɨ́¹ cá¹chánh²¹ dí² jáun²; jáun² ca³záɨh³ dí² Pé¹: ―¿Hí¹ hí¹juáh³ cu³tiá³ pih²¹ uá¹ tiá² ca³tion¹³ hnoh² hi³ tianh¹³ náh² ná¹ñí¹ quiúnh¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tianh³ náh² ná¹ñí¹ hi³ lienh¹ náh² siáh³ Dió³², hi³ jáun² tiá² lɨ́¹³ tánh³² náh² tso³. Quí¹ hua³jan²¹ lɨ́n²¹ bíh¹ hún¹ jmɨ́²chí³ quián¹³ náh², tɨ³la³ ngú³ quián¹³ bí¹ náh² jlánh¹ tiá² pin³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jáun² ngau³ siáh³ tsú² ca³tɨ́³ tenh³ hi³ ca³ñí¹lienh¹³ Dió³² la³ lá²: ―Hnú² Tia²¹, nɨ́¹juáh³ tiá² lɨ́¹³ yáh³ hi³ tiá² há¹ ngá¹³ jná¹³ uu³mí²tsɨ³² lá², cuɨ́¹ lɨ́¹³ bíh¹ la³ cun³ hi³ hnáuh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jáun² cuanh³ tsú² siáh³, sa³ siáh³ bíh¹ siáh³ má²ná¹cuóun¹ tsá² hí³ jmɨ́¹ cuanh²¹ dí², quí¹ cun³ñí¹ hi³hliá² jlánh¹ má²tioh³ ziú³ ñí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jáun² ca³chan³ tsú² tsá² hí³ hi³ ngau³ siáh³ ñí¹ má²hnaɨh³² jéin³² hi³ ca³ñí¹lienh¹³ Dió³² hi³ ñí¹ zeh¹ dí² la³ cun³ hi³ má²lɨ́²zéih³² dí² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jmɨ́¹ lɨ²¹ jáun² né³, ngah³ dí² siáh³ ñí¹ tionh¹ tsá² haɨn²¹ hí³ tɨ³ con²; hi³ jáun² ca³záɨh³ dí² siáh³ la³ lá²: ―¿Hí¹ la³ má²tionh² jáun² uá¹ hnoh² tie³ hi³ ná¹cuóun¹ náh²? Sá¹nɨ́² jɨe³, má²cá²chó³² bíh¹ jmáɨ¹ hi³ jɨenh³ tsú² jná¹³ Jon² tsá²mɨ³cuóun² jo³cuo² tsá² ná¹ren² tso³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nú¹ tianh³ náh², ma³tsáu¹³; quí¹ nɨ́² bíh¹ má²cuá¹ja³² tsá² jɨenh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² bíh¹ Jesús cuan³ Judas, jan² tsá² jmɨ́¹ lɨ́n³ tsá² quian³tun³ joh¹ tsú², hi³ má²hí¹quionh³ tsú² juóun³² lɨ́n³² tsá² ná¹quian³² mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ jɨ³ tsá² ná¹quian³² hmá² nɨ́² siáh³. Tsá² zéi¹ tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas tsá² ca³jɨenh³ hí³ bíh¹ Jesús ca³jmú³ jáɨ¹³ ha³ lánh³ rón³² hɨen³ dí² Jesús, hi³ ca³juáh³ la³ lá²: “Nɨ́¹juáh³ tsá² ca³hen³ jná¹³ ñí¹, tsá² hí³ bíh¹ jan¹³ náh² tson³”. ");
INSERT INTO csoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jmɨ́¹jáun² ca³ja³janh³² tsú² ñí¹con² Jesús hi³ ca³juáh³: ―¡Hia² nú² Tɨ³²! Hi³ jáun² ca³hen³ dí² ñí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jáun² Jesús ca³ngáɨ³: ―Há²mei²¹ quiú¹³, tia³juɨ³² jmu³ la³ cun³ hi³ má²ca³lɨ́n¹³ nú² jmúh¹³. Hi³ jáun² la³ cun³ jmɨ́¹jáun² ja³taunh²¹ tsá² ñí¹ hná¹ hí³ hi³ ca³zanh³ Jesús, hi³ ca³jan³ dí² tson³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jmɨ́¹jáun² né³, jan² tsá² quionh³ Jesús ca³chí² mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ quioh²¹, hi³ ca³jmú³ cu³ ngá¹³ mí¹táɨ³ cuá¹ jan² *tsá² má²dí¹hlánh¹ joh¹ mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Tiáunh¹ mí¹táɨ³ quián¹³ ñí¹ jmɨ́¹ hu²¹; quí¹ nɨ́¹juáh³ tsá² jmu² hniéi² cun³quionh³ mí¹táɨ³, ja³bí¹ cun³quionh³ mí¹táɨ³ bíh¹ siáh³ jún³ tsú² hnga². ");
INSERT INTO csoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Há¹ tiá² ñíh¹ nú² hi³ jná¹³ jmɨ́¹ lɨ́¹³ mɨ́¹³ ñí¹con² Ñuh³², hi³ jáun² hí³ jmɨ́¹ lɨ́¹³ zen³ cun³ quiéinh³ nio² quiú³ mei²¹ tsá²cuú² tsá²ta³, tsá² jmɨ́¹ lɨ́¹³ ma³hau³? ");
INSERT INTO csoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Tɨ³la³ sá¹jmɨ́¹ la³ jáun² né³, jáun² tiú²uú² jmɨ́¹ zia³² yáh³ ha³ lánh³ rón³² lɨ³tí³ la³ cun³ hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³² ñí¹ rá¹juáh³ jáun² hi³ ca³tɨ²¹ lɨ́¹³ la³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² cuá²taunh²¹ hí³ la³ lá²: ―¿Hí¹ má²ñá²taunh²¹ hnoh² hi³ ná¹quiánh¹ náh² mí¹táɨ³ jɨ³ hmá² nɨ́², hi³ jau¹³ náh² jná¹³ hi³ tson³ la³jmɨ́¹ lɨ́³ hi³ jná¹³ bíh¹ jan² tsá² háɨn²? Jmáɨ¹ ca³la³ jɨ́³² bíh¹ jmɨ́¹ ñi³² jná¹³ ja¹ quián¹³ hnoh², hi³ jmɨ́¹ ma³ta¹³ jná¹³ hnoh² hñu³ cuáh³² chín¹, tɨ³la³ hí¹ cónh³ yáh³ tiá² lɨ́¹ ca³ziaunh² náh² jná¹³ hi³ tson³ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tɨ³la³ la³jɨ́³² hi³ nɨ́² má²ná¹lɨ́²³ hi³ jáun² lɨ́¹³ lɨ³tí³ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí² bíh¹, hi³ ca³jmú³ jáun² tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin². Jáun² né³, hnga² bíh¹ Jesús jéi³²í¹ ca³ta³zanh¹, quí¹ ca³cuóun³ bíh¹ la³jɨ́n³² tsá² haɨn²¹ hí³ tɨ³ con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hi³ jáun² né³, tsá² ca³zanh³ hí³ Jesús hi³ tson³ ca³ñí¹jan² Jesús ta³ ñí¹ Caifás tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹; ñí¹ jáun² jmɨ́¹ má²ná¹ngɨh³² tɨ³² liei²¹ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú². ");
INSERT INTO csoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tɨ³la³ Pé¹ né³, uóunh³ chí¹cáɨn² bíh¹ ngau³ cu³hna²¹ dí² ca³la³ ñí¹ cá¹chó²¹ ñéih³ ñí¹ lɨ́¹ hó²¹ hñú¹³ mí²tsá² hɨ́en¹; ñí¹ jáun² hi³, hi³ ca³cuá³ quionh³ tsá²cuú² tsá²ta³ mí²tsáu² hi³ jáun² lɨ́¹³ jɨ́e³ nɨ́¹juáh³ he³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hi³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ quionh³ la³jɨ́n³² tsá² ná¹ñí¹ jmɨ́¹ hnauh² he³ lánh³ rón³² lɨ́¹³ ma³tson² dí² tsáu¹³ Jesús, uá¹jinh¹ cun³quionh³ jú¹ tɨ́¹jáɨ², hi³ jáun² lɨ́¹³ jngɨh³ dí²; ");
INSERT INTO csoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","tɨ³la³ tiá² ca³choh¹³ yáh³ tsú², uá¹jinh¹ juóun³² tsá² ca³chá³ jú¹ tɨ́¹jáɨ² hi³ ca³tɨn¹ tsú². Ñí¹ ca³táuh³ né³ ca³ma³jnia³² gon³ tsá² ca³ma³tson² jú¹ tɨ́¹jáɨ², ");
INSERT INTO csoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tsá² hí³ né³ ca³juáh³ la³ lá²: ―Tsá²ñuh² nɨ́² ca³juáh³: “Jná¹³ tɨn² tsunh²¹ hñú³ hɨ́en¹ quioh²¹ Dió³², hi³ jáun² ñí¹ cá²hnɨ́² jmáɨ¹ ziúh¹ jná¹³ siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jáun² tsá² cuá¹lɨ́n³ hí³ mí²tsá² hɨ́en¹ ca³náu² hi³ ca³záɨh³ Jesús la³ lá²: ―¿Hí¹ hí¹ cá² jon¹ uá¹ tiá² la³ ngáɨh¹ nú²? ¿He³ dá² nɨ³² ná¹juáh²³ tsá² nɨ́² hi³ ca³tɨn¹ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Tɨ³la³ Jesús má¹ná¹, la³ má² tiá² nga² jáun² bíh¹. Jáun² tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹ ca³juáh³ siáh³: ―Cun³quionh³ héih³² quioh²¹ Dió³² Tsá² juú²tsáun² taunh³² jná¹³ hnú² hú¹mu³héih³² nɨ́¹juáh³ tiá² juáh¹³ hnú² jú¹ tson²; jáun² né³, ¿hí¹ hnú² uá¹ Tsá² lɨ́n³ Cristo Jon² Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Ján³, lɨ́n³ jná¹³ la³ cun³ juánh³ hnú² nɨ́². Ja³bí¹ juo³ jná¹³ siáh³ hnoh², hi³ chau²¹ jmáɨ¹ jɨen¹ hnoh² Jon² tsá²mɨ³cuóun² hi³ má²cuá¹tón²¹ tɨ³ cuá² chu²¹ quioh²¹ Dió³² Tsá² cú² juenh², jɨ³ hi³ jɨen¹ náh² tsú² siáh³ hi³ má²cuá¹jáunh²³ hñu³mɨ³cuú² juɨ³² ja¹ jnie². ");
INSERT INTO csoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jmɨ́¹jáun² ca³ca³ mí²tsá² hɨ́en¹ ha¹, hi³ jmu² lin¹ hi³ tiá² tɨ³² tsɨ́³ jáɨ¹³ jáun², hi³ ca³juáh³: ―Tsá²ñuh² lá² má²lɨ́²chú² lɨ́²lén³² Dió³² cun³quionh³ jáɨ¹³ quioh²¹; ¿he³ láɨh³² sa³ ca³lɨ³í¹ tsá² zih³² jú¹ tson² hno³ dí²? Quí¹ nɨ́² bíh¹ má²lɨ́²niéih² hnoh² jú¹ hlah³ hi³ má²lɨ́²hléh³² tsú²; ");
INSERT INTO csoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","jáun² né³ ¿he³ lánh³ lɨ́n²³ hnoh² ta³né³²? Jáun² tsá² ná¹ngɨh³² hí³ ca³juáh³ la³ lá²: ―Má²hniáuh³² bíh¹ jún³ tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jmɨ́¹jáun² ca³tiu³ ca³hñe³ dí² ñí¹, jɨ³ hi³ ca³ma³qui³ ma³jnó³² dí² siáh³. Hi³ jáun² la³jɨ́n³² tsá² ca³pá³ hí³ ñí¹ tsú² ");
INSERT INTO csoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ hnú² Tsá² lɨ́n³ Cristo, ¡chí³ jáɨ¹³ neh²¹, hin² tsánh² lɨ́²po³! ");
INSERT INTO csoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hi³ jáun² né³, tá¹la³ jmɨ́¹ cuá¹tón²¹ jáun² Pé¹ ñéih³ ñí¹ lɨ́¹ hó²¹, ja³ jan² tsá²mɨ³ lɨ́n³ quian²¹ tsá² hñú¹³, hi³ ca³juáh³: ―Ja³bí¹ hnú² uá²jaɨ³² jmɨ́¹ ngɨ́h¹ quiúnh¹ Jesús tsá² hɨ́n¹³ ó³² tɨ³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Tɨ³la³ Pé¹ né³, tiá² ca³ton³ yáh³; la³ lá² bíh¹ ca³záɨh³ dí² tsá²mɨ³ hí³ ta³ ñí¹ la³jɨ́n³² tsá² tionh² hí³: ―Hí¹juáh³ tiá² ño¹ yáh³ jná¹³ hi³ juánh³ hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pé¹ jmɨ́¹ má²cuá¹tsanh³² ho³hñú¹³ jmɨ́¹ ca³jɨ́e³ siáh³ jan² tsá²mɨ³ lɨ́n³ quian²¹, hi³ jáun² ca³záɨh³ dí² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun²: ―Ja³bí¹ tsá²ñuh² lá² jmɨ́¹ ngɨ³² quionh³ Jesús hná¹ tsá² Nazaret ó³². ");
INSERT INTO csoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Siáh³ bíh¹ siáh³ tiá² ca³ton³ Pé¹ cónh³í¹ cu³ jéin³² ca³la³ hi³ hɨen² Dió³², hi³ juáh³: ―¡Hú¹tá¹ tiá² cuóun³² bíh¹ jná¹³ tsá² hɨen²³ hnú² nɨ́², juú¹ néh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jmɨ́¹ má²cu³lé³ míh¹ jáun² né³, tsá² jmɨ́¹ tionh¹ ñí¹ jáun² ja³taunh²¹ má²janh² ñí¹ zenh¹ Pé¹ hi³ ca³záɨh³ dí² la³ lá²: ―Cu³tí³ bíh¹ hnú² uá²jaɨ³² jan² tsá² ja¹ quioh²¹ tsá² ó³², quí¹ hí¹ ca³la³ tɨ³ jáɨ¹³ quián¹³ yáh³ hnú² lin¹. ");
INSERT INTO csoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jmɨ́¹jáun² ca³ma³liáu³² Pé¹ hi³ hɨen² Dió³² ca³la³ hi³ tanh² siáh³ hú¹mu³héih³² hnga², hi³ juáh³ hi³ cun³ tiá² cuóun³² bíh¹ tsá² hí³. La³ cun³ jmɨ́¹jáun² bíh¹ ca³hó³ jan² cá¹tsó³. ");
INSERT INTO csoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jmɨ́¹jáun² tsau³ tsɨ́³ Pé¹ la³ cun³ hi³ ca³záɨ³ jáun² Jesús jmɨ́¹ ca³juáh³ tsú² jáun² la³ lá²: “Ñeh² bíh¹ hi³ hau³ cá¹háu², hnú² juáh¹³ hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³”. Jmɨ́¹jáun² cua³han³ Pé¹ tɨ³ cheih³² hi³ ca³ñí¹hó² ñí¹jngɨh³² lɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Jmɨ́¹ má²já²jnia² jáun² né³, la³jɨ́n³² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú², ca³ma³ren²¹ jáɨ¹³ he³ lánh³ rón³² jngɨh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jáun² ca³hñéi³² dí² tsú², hi³ ca³ñí¹jan² dí² ñí¹con² Pilato tsá² lɨ́n³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Tɨ³la³ jmɨ́¹ ca³jɨ́e³ Judas tsá² ca³jɨenh³ hí³ Jesús hi³ má²lɨ́²jmú³ tsáu² héih³² hi³ jngɨh³ tsú² Jesús, jmɨ́¹jáun² jlánh¹ hlah³ ca³jeinh²¹ tsú², hi³ jáun² ca³ñí¹caun² cú²jueh³² quɨe³ quiu³quia³ héih³² *cú¹tiáu² jáun² ñí¹con² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá²daun³², ");
INSERT INTO csoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","hi³ jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Tso³ bíh¹ má²lɨ́²jmú³² jná¹³ hi³ má²lɨ́²jɨenh²¹ jná¹³ jan² tsá² tiá² tso³ ren². Tɨ³la³ tsá² hí³ né³ ca³ngáɨ³: ―¿Hi³ he³ dá² ca³ta¹ jnoh¹ hi³ nɨ́²? ¡Hi³ nɨ́² dá² má²ta³can¹ hnú² huen² bíh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hi³ jáun² Judas ca³ñí¹cuɨ³² quɨe³ ñéih³ ñí¹ hɨ́en¹ quioh²¹ cuáh³² chín¹, jmɨ́¹ lɨ²¹ jáun² ngah³ hi³ ca³ñí¹tiáunh¹³ zié³ láɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jáun² tsá² ná¹lɨ́n³ mi³jmú³ ca³jieh³ quɨe³ jáun², hi³ jáun² ca³juónh³ la³ lá²: ―Tiá² lɨ́¹³ yáh³ toh²¹ dí² quɨe³ lá² hñu³ cuó² quioh²¹ hi³ lɨ́¹ cue³² tsáu² ñí¹con² Dió³², quí¹ hmah²¹ quioh²¹ jmɨ² bíh¹ la³². ");
INSERT INTO csoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","La³ cun³ jmɨ́¹jáun² né³, ca³ma³ren²¹ tsú² jáɨ¹³ hi³ lá³² cáun² hué³², hué³² hi³ jmɨ́¹ téh²³ tsú² “Hué³² Quioh²¹ Tsá² Jmu² Hia³²”, hi³ jáun² zia³² ñí¹ lɨ́¹³ hón³² tsú² tsá² hué³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cun³ñí¹ hi³ jáun² bíh¹, jáun² “Hué³² Jmɨ²” má²téh²³ tsú² hué³² jáun² la³ tɨ³ ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","La³ jáun² bíh¹ ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ hla¹ Jeremías *tɨ³² jë¹ Dió³² jmɨ́¹ ca³juáh³ jáun² la³ lá²: “Ca³caun² bíh¹ tsú² tá¹ quiu³quia³ héih³² cú¹tiáu² jáun², la³ cun³ tí³ hmah²¹ hi³ ca³jmú³ jáun² tsá² *Israel, ");
INSERT INTO csoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hi³ jáun² cun³quionh³ quɨe³ jáun² bíh¹ ca³lau² tsú² ñí¹náɨ² quioh²¹ tsá² jmu² hia³², la³ cun³ rón³² héih³² hi³ ca³jmú³ jáun² Juo¹³ dí² ñí¹con² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hi³ jáun² jmɨ́¹jáun² né³ ca³ñí¹jan² tsú² Jesús ta³ ñí¹ tsá² cuá¹lɨ́n³ hí³ ta²¹, hi³ jáun² tsá² hí³ ca³ngáɨ³ hi³ ca³juáh³ la³ lá²: ―¿Hí¹ hnú² uá¹ lɨ́n³ nú² Re²¹ Juo¹³ tsá² *judíos? Jesús né³ ca³ngáɨ³: ―Ján³, tson² bíh¹ la³ juáh³ hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Tɨ³la³ jmɨ́¹ ca³chá³ tsá² ná¹lɨ́n³ mi³jmú³ tso³ quionh³ tsá²daun³² né³, hí¹ cáun² yáh³ tiú²uú² hi³ ca³ngáɨ³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jáun² Pilato ca³juáh³ siáh³: ―¿Tiá¹ naɨh³² hnú² la³jɨ́³² la³ cun³ hi³ ná¹juáh²³ tsú² nɨ́² quián¹³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Tɨ³la³ la³ má² tiá² nga² jáun² bíh¹ Jesús, hi³ jáun² lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ tsá² lɨ́n³ hí³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hi³ jáun² né³, tsá² lɨ́n³ hí³ ta²¹ jmɨ́¹ tan² hi³ lión³² jan² tsá² tson³ tá¹la³ *Jmɨ́¹hɨ́en¹ nɨ́¹juáh³ hin² tsánh² mɨ³² tsáu² hi³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jmɨ́¹jáun² jmɨ́¹ cuá¹hún¹ jan² tsá² tson³ hñu³mí¹ñí², tsá² jmáɨ² Barrabás, jan² tsá² jlánh¹ má²ná¹ñi³² juóun³² tsáu² hi³ hian² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jáun² jmɨ́¹ ca³ngɨh³² jáun² tsá² juú² né³, ca³ngáɨ³ Pilato ñí¹con² tsú²: ―¿Hin² tsánh² hnáuh² hnoh² hi³ lion¹ jná¹³? ¿Hí¹ Barrabás, ho³ Jesús tsá² téh²³ tsú² Cristo uá¹? ");
INSERT INTO csoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Quí¹ jmɨ́¹ má²ca³lɨ³tsɨn² bíh¹ Pilato hi³ cun³ñí¹ hi³ uóu³² tsɨ́³ bíh¹ tsá² hí³ hi³ jáun² ñí¹con² hí³ dí² cua³jan² tsú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Né³² né³, tá¹la³ jmɨ́¹ cuá¹tón²¹ Pilato ñí¹ta²¹ quioh²¹, jáun² ñí²cuo² tsú² ca³zen³ jáɨ¹³, hi³ juáh³ la³ lá²: “Ha³ lɨ́² lɨ́¹ hú³² hnú² quiúnh¹ tsá²ñuh² chun¹ nɨ́², quí¹ jmɨ́¹ hua² hmáɨ³ lɨ́²ma³tso¹ lɨ́n²¹ jná¹³ tsɨn³² cun³ñí¹ hi³ ca³tɨn¹ tsá² nɨ́² jmɨ́¹ lɨ́²quɨ́³ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tɨ³la³ tsá² ná¹lɨ́n³ hí³ mi³jmú³ né³, jɨ³ tsá²daun³² nɨ́² jlánh¹ ca³hlɨ́² ca³liéinh³² tsáu² hi³ hniáuh³² hiu³ mɨ́³² tsú² hi³ liáun³ Barrabás, hi³ jáun² né³, cuɨ́¹ jun¹³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jáun² tsá² lɨ́n³ ta²¹ ca³ngáɨ³ siáh³ hi³ ca³juáh³: ―¿Hin² tsánh² tsá² gon³ nɨ́² hnáuh² hnoh² hi³ lion¹ jná¹³? Jáun² tsá² tionh² hí³ né³ ca³ngáɨ³ hi³ ca³juáh³: ―¡Barrabás bíh¹! ");
INSERT INTO csoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jáun² Pilato ca³ngáɨ³ siáh³: ―¿Hi³ he³ bí¹ hnáuh² náh² jmu¹ jná¹³ ñí¹con² Jesús tsá² teh³² náh² lá² Cristo? Jáun² la³jɨ́n³² bíh¹ tsáu² ca³ngáɨ³ hi³ ca³juáh³: ―¡Crei²¹ ton³ tsá² nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Jmɨ́¹jáun² ca³juáh³ Pilato: ―Tɨ³la³, ¿he³ dá² hi³ hlaɨh³ má²ca³jmú³ tsú² né³? Tɨ³la³ tsá² hí³ né³, tɨ³ lɨ³mí¹ ca³tɨ³ ca³hóh³² bíh¹, hi³ ca³juáh³: ―¡Cuɨ́¹ taun¹ tsá² nɨ́² crei²¹! ");
INSERT INTO csoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jmɨ́¹ ca³jɨ́e³ Pilato hi³ tiá² hi³ lɨ́²³ yáh³ jmu³ dí² hí¹ cáun², quí¹ sa³ lɨ³mí¹ tiá³ siaun³² taunh³² bíh¹ tsá² hí³, jmɨ́¹jáun² ca³jmú³ dí² héih³² hi³ tsa³quián³ tsú² jmáɨ², hi³ jáun² ca³liah³ dí² cuo² ñí¹ ta³ ñí¹ la³jɨ́n³² tsá² hí³, hi³ juáh³ la³ lá²: ―Hí¹ cú¹pih²¹ yáh³ tiá² rá¹can² jná¹³ hi³ jún³ tsá²ñuh² tsá² tiá² hi³ ren² lá², má²ca³tɨn¹ hmóu³² bíh¹ hnoh² hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hi³ jáun² la³jɨ́n³² tsáu² ca³ngáɨ³ la³ lá²: ―¡Jnoh¹ la³ má²quiúnh¹ jon³zɨ́h¹ cuɨ́¹ rá¹can² jnoh¹ jmɨ́²hán¹ tsá² nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Hi³ jáun² cu³tsa³² ca³lión³² bíh¹ cú²jueh³² Pilato Barrabás hí³; jmɨ́¹ lɨ²¹ jáun² ca³jmú³ dí² héih³² hi³ quiu³ pan³ tsú² Jesús cun³quionh³ cáun² hñu¹jméi¹³ hi³ lɨ́³ láu², jmɨ́¹ lɨ²¹ jáun² né³ ca³jɨenh³ dí² hi³ tsa³ton³ tsú² crei²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jmɨ́¹ lɨ²¹ jáun² né³, hliáu³ joh¹ tsá² ho² ta²¹ ca³jan³ Jesús tɨ³ la³ ñéih³ ñí¹ lɨ́¹ hó²¹ quioh²¹ ñí¹ta²¹, jáun² ca³cuú² ca³ngɨh³ tsú² la³jɨ́n³² hliáu³ raɨnh²¹ cu³ jéin³ ñí¹ zenh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jmɨ́¹jáun² ca³chí² dí² ha¹ hi³ jmɨ́¹ quih³², hi³ jáun² ca³quinh³ dí² cáun² hmɨh³² zɨ́n¹³ la³ cun³ hi³ qui³ quɨh³² jan² tsá² quien², ");
INSERT INTO csoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","hi³ ca³tanh² dí² siáh³ chí¹ tsú² cáun² chí² lɨh³² la³juah²¹ dúh¹ *có²ron¹ná¹ hi³ quioh²¹ jan² tsá² ho² jáɨ¹³, tɨ³la³ chí² lɨh³² jáun² dá² lɨ́³ cun³quionh³ cuoh² hmá² ton² bíh¹. Jɨ³ hi³ ca³zianh³ dí² tsú² siáh³ cáun² hmá² tiéi¹³ tɨ³ cuá² chu²¹ la³juah²¹ dúh¹ cáun² hmá² hɨ́h¹. Jmɨ́¹jáun² ca³cónh³² dí² cú²nga¹, hi³ ca³di³qui³ di³jñí³² dí² ta³ ñí¹ tsú², hi³ zaɨh³² dí² la³ lá²: ―¡Cuɨ́¹ lɨ³quien² bíh¹ Re²¹ Juo¹³ tsá² judíos! ");
INSERT INTO csoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ja³bí¹ ca³tiu³ ca³hñéi³² dí² tsú² siáh³, hi³ cán²³ dí² siáh³ hmá² hi³ zianh³² jáun² Jesús hi³ pá²³ dí² chí¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jmɨ́¹ má²lɨ́²cónh³² dí² jáun² cú²nga¹ né³, ca³chí² dí² siáh³ hmɨh³² zɨ́n¹³ hi³ jmɨ́¹ má²lɨ́²quinh³ dí² jáun², hi³ jáun² ca³quinh³ dí² siáh³ ha¹ hi³ qui³ jmɨ́¹ quih³². Jmɨ́¹ lɨ²¹ jáun² né³ ca³jan³ dí² hi³ ca³ñí¹ton¹³ dí² crei²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hú¹ juɨ³² jáun² né³ ca³jenh² tsú² jan² tsá²ñuh² tsá² juú² Cirene, tsá² jmáɨ² Sí¹mu²¹; tsá² hí³ ca³di³quian³ tsú² jmáɨ¹ hi³ cán³ crei²¹ cha¹³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tá¹la³ jáun² ca³cha³táunh¹ tsú² tsɨ́³ máh³ míh¹ téh²³ tsú² Gólgota, (hi³ hnió³ juáh³ “Máh³ Mú³² Chí¹ Tsáu²”). ");
INSERT INTO csoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ñí¹ jáun² jmɨ́¹ cueh³² dí² Jesús mu² má²zéih¹ lɨ́n²¹ quioh²¹ mɨ³ uóun²jɨeh¹³ hi³ hɨ́nh³, hi³ má²jan² mɨ́³ hi³ jmu² hi³ tiá² lieih²¹ tsú²; tɨ³la³ jmɨ́¹ má²lɨ́²jɨ́e³ tsú² jáun² cú¹pih²¹ né³, tiú²uú² ca³he³ yáh³ hɨ́nh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ta³ má²chí¹tón²¹ jáun² Jesús crei²¹ né³ ca³chí² hliáu³ jáɨ¹³, hi³ jáun² jɨ́e³ dí² nɨ́¹juáh³ hin² joh¹³ ha¹ tsú². La³ jáun² bíh¹ ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ jan² hla¹ tɨ³² jë¹ Dió³² jmɨ́¹ ca³juáh³ la³ lá²: “Ca³tsáunh³ tsú² hán² jná¹³ cun³quionh³ hi³ ca³chí² jáɨ¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jmɨ́¹ lɨ²¹ jáun² ca³tiánh³ ñí¹ jáun² hi³ ná¹jmu² hua³hí¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jáun² ta³ chí¹ Jesús ca³tón³ tsú² huéh³ hi³ jmu² lin¹ hi³ he³ ca³tɨ²¹ má²ma³ngɨ́³ dí² tsú². Huéh³ jáun² juáh³ la³ lá²: “Tsá² lá² bíh¹ Jesús Tsá² lɨ́n³ Re²¹ Juo¹³ tsá² judíos”. ");
INSERT INTO csoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ja³bí¹ ca³ton³ tsú² siáh³ crei²¹ gon³ tsá² háɨn² quionh³ Jesús, jan² tɨ³ cuá² chu²¹ hi³ jan² tɨ³ cuá² cáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hi³ jáun² tsá² há² ngaɨ³² ñí¹ jáun² né³, ca³tu³ ca³hión³² Jesús, hi³ ca³la³ hi³ jeih³² chí¹ bíh¹ tsú², ");
INSERT INTO csoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","hi³ juáh³ la³ lá²: ―¡Hnú² tsá² jlánh¹ juánh³ hi³ tsunh²¹ nú² hñú³ hɨ́en¹ quiú¹³, hi³ jáun² ñí¹ cá²hnɨ́² jmáɨ¹ jáun² né³ jmóuh¹ nú² siáh³, né³² né³, lion¹ huen²! Nɨ́¹juáh³ tson² bíh¹ cu³tí³ hi³ hnú² Jon² Dió³², hi³ jáun² né³, ¡son² ñí¹ chí¹tón²¹ nú² nɨ́² crei²¹! ");
INSERT INTO csoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ja³bí¹ la³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ siáh³ ca³cónh³² cú²nga¹ Jesús, la³ má²quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́², hi³ juónh²³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Tsá² siánh³ bíh¹ jlánh¹ ca³lión³² tsú², tɨ³la³ hnga² né³, tiá² la³ lɨ́¹³ yáh³ lión³². Nɨ́¹juáh³ tson² bíh¹ lɨ́n³ tsú² Re²¹ Juo¹³ dí² tsá² Israel, jáun² cuɨ́¹ son² tsú² ñí¹ crei²¹ hnga², hi³ jáun² má¹jáun² tanh¹³ dí² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Má²ca³chá³ tsú² cáun² tsɨ́³ ñí¹con² Dió³², jáun² né³² né³, cuɨ́¹ liáu²¹ Dió³² nɨ́¹juáh³ hi³ tson² hniau³; quí¹ Jon² Dió³² yáh³ nɨ³² má²ca³juáh³ ñí¹con² dí². ");
INSERT INTO csoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hí¹ la³ tɨ³ tsá² háɨn² jmɨ́¹ ná¹tón²¹ jáun² crei²¹ cu³tsa³² quionh³ yáh³ tsú² ca³quiu³ ca³je³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hi³ jáun² jmɨ́¹ tɨ́³ chi³hiú² né³, ca³nieh² tá¹ cáun² hué³², ca³la³ tɨ³ la³ nió¹ hnɨ³² tɨ³ ca³hláu³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jáun² la³ cun³ jmɨ́¹jáun² ca³hóh³² Jesús tiá³, hi³ ca³juáh³ la³ lá²: ―Elí, Elí, ¿lema sabactani? (hi³ hnió³ juáh³ “Dió³² Juóu³² jná¹³, Dió³² Juóu³² jná¹³, ¿he³ láɨh³² huen² jná¹³ má²lɨ́²zeh² hnú²?”) ");
INSERT INTO csoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma³ jan² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³náɨ³², hi³ jáun² ca³juáh³: ―Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³² má²ñí¹téh¹³ tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","La³ cun³ jmɨ́¹jáun² né³ ngau³ jan² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² cú²hé², hi³ ca³ñí¹quián¹³ cáun² chí² náh² hɨnh²³ jmáɨ² hi³ ca³ñí¹cuóuh¹³ quionh³ mu² má²zéih¹ lɨ́n²¹ quioh²¹ mɨ³ uóun²jɨeh¹³, hi³ jáun² ca³di³chí³ dí² hná¹³ hmá² tiéi¹³ hi³ ca³ñí¹hiéih¹³ dí² ho³ Jesús, hi³ hnió³ dí² hɨ́nh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tɨ³la³ tsá² ñí¹ hná¹ hí³ né³ ca³juáh³: ―Nɨ́² tín² cuɨ́¹ lɨ́³ cu³ nɨ́²; cuɨ́¹ neh²¹ nɨ́¹juáh³ hi³ já³² Líh³ hi³ ja³liau³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jáun² Jesús ca³hóh³² siáh³ cónh³í¹ cu³ jéin³² tiá³ lɨ́n³², hi³ jmɨ́¹ lɨ²¹ jáun² né³ cua³ha³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³zen³ tɨ³ tun³ zaɨnh²¹ hmɨh³² jmɨ́¹ hí¹jnáɨ²³ ñí¹ jlánh¹ hɨ́en¹ quioh²¹ cuáh³² chín¹, hi³ ca³lɨ³liau³ tɨ³ chi³cuú² hi³ tsa³ la³ tɨ³ hué³². Jmɨ́¹jáun² ca³jɨ́eh³ siáh³ hué³², hi³ jáun² hláu² né³, ca³juú² ca³tsúnh², ");
INSERT INTO csoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","hi³ jáun² jmɨ́¹jáun² ca³qui³ ca³niá³ siáh³ tá²hón³²; hi³ hí¹ ca³la³ tɨ³ juóun³² lɨ́n³² yáh³ hla¹ ca³jenh¹³, tsá² jmɨ́¹ má²ná¹chan¹ joh¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tsá² hí³ ca³huén² hñu³ tá²hón³² jmɨ́¹ má²ca³jenh¹³ jáun² Jesús máh³, hi³ jáun² taunh³ já¹ juú² Jerusalén, juú² ná¹chan¹ ñí¹con² Dió³²; ñí¹ jáun² ca³jɨ́e³² juóun³² lɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Né³² né³, jmɨ́¹ ca³jɨ́e³ jáun² hliáu³ tsá² chín¹ tsá² romano hi³ má²jɨ́eh²³ hué³² jɨ³ la³jɨ́³² hi³ ná¹lɨ́²³ ñí¹ hná¹ jáun² nɨ́² siáh³, quionh³ hliáu³ joh¹, tsá² jmɨ́¹ ná¹jmu² hí³ hua³hí¹³ Jesús, jɨ³lɨn² bíh¹ tsú² ca³juénh² lɨ́n³², hi³ jáun² ca³juónh³ tiáunh¹: ―¡Cu³tí³ bíh¹ la³ Jon² Dió³² bíh¹ hla¹ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Có³² jáun² jmɨ́¹ tionh¹ juóun³² tsá²mɨ³ hi³ jmɨ́¹ ná¹jɨ́e²³ ñí¹ uóunh³, tsá² hí³ jmɨ́¹ má²ca³ñi³táunh¹ cu³hna²¹ Jesús ca³la³ tɨ³ hué¹³ Galilea, jɨ³ hi³ jmɨ́¹ má²ca³ma³cáu³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ja¹ tsá² hí³ jmɨ́¹ zenh¹ Má²réi³ tsá² ja³ juú² Magdalá, jɨ³ Má²réi³ mí¹ziú¹³ Jacobo quionh³ Sé³², jɨ³ mí¹ziú¹³ tsá¹ jon² Zebedeo nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jáun² jmɨ́¹ má²ja³quián³ tá¹tsɨ²¹ hiú² né³, cuan³ jan² tsá²ñuh² tsá² hánh³, tsá² jmáɨ² Sé³², tsá² hí³ zian² juú² Arimatea; ja³bí¹ tsá² hí³ jmɨ́¹ má²lɨ́n³ tsá² hen² tɨ³ con² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jáun² ñéi¹ hi³ ca³ñí¹ma¹³ hla¹ Jesús ñí¹con² Pilato; jmɨ́¹jáun² ca³jmú³ Pilato héih³² hi³ jɨenh³ tsú² hla¹ Jesús ñí¹con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jáun² Sé³² ca³cón³² hla¹ hi³ ca³tsáɨnh³² dí² cáun² hmɨh³² jmuh³ tiáu² hi³ ná¹jɨ²¹ hi³ lɨ́³ cun³quionh³ mí²ñi³² lino; ");
INSERT INTO csoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hi³ jáun² ca³ñí¹hón²¹ dí² cáun² hñu³ tá²hón³² hmaɨ²¹ ñí¹ jmɨ́¹ má²ca³hó³ dí² hnga² hñu³ hláu². Jmɨ́¹ má²lɨ́²jnáɨ³² dí² jáun² ho³ tá²hláu² quionh³ cá² máɨ³ quɨ́n¹ pa²¹ né³, jáun² ngah³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hi³ jáun² la³ re² ho³ tá²hón³² jáun² jmɨ́¹ tionh¹ tá¹ gon³ Má²réi³, tsá² ja³ hí³ juú² Magdalá jɨ³ Má²réi³ jan² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jmɨ́¹ cá¹jniá²¹ jáun² hi³ ná¹jueh³² *Jmɨ́¹hɨ́en¹, jáun² tsá² ná¹lɨ́n³ mi³jmú³ la³ má²quionh³ tsá² *fariseos ca³ñí¹jɨen¹³ Pilato, ");
INSERT INTO csoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","hi³ ca³ñí¹zeh¹ dí² la³ lá²: ―Hnú² tsá² ho² ta²¹, má²tsau³² tsɨ́³ jnoh¹ hi³ tá¹la³ jmɨ́¹ zian² tsá² tɨ́¹ jáɨn² hí³ ca³juáh³ hi³ ñí¹ cá²hnɨ́² jmáɨ¹ néh¹ jenh¹³ dí² ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jáun² né³, chú³² zen¹³ nú² tsá² tsa³jmú³ hua³hí¹³ ca³la³ tɨ³ ñí¹ ca³táɨh¹³ cá²hnɨ́² jmáɨ¹, quí¹ nɨ́² lɨ́¹ já¹taunh²¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú² ta³ já¹niéi² hi³ tsa³chin² hla¹, hi³ má¹lɨ³² jáun² né³ záɨh³² tsáu² la³ lá²: “¡Má²ca³jenh¹³ bíh¹ tsú² ja¹ hla¹!” Quí¹ jú¹ tɨ́¹jáɨ² ñí¹ ca³táuh³ jáun² dá² lɨ́¹³ cáun² hi³ tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ la³ cónh³ bíh¹ tɨ́¹jáɨ² la³ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jáun² ca³juáh³ Pilato: ―Ó³² tionh² cun³ nió³ hliáu³. Cuá²táunh¹ náh² quiúnh¹ tsú², cuá²jmu³ náh² hua³hí¹³ re² lɨ́n³² tá²hón³² la³ cun³ ñí¹lɨ́²³ jen²³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jáun² ja³taunh²¹ bíh¹ tsú² hi³ ca³ñí¹jnáɨ¹ re² lɨ́n³² tá²hón³², hi³ ca³tón³ dí² cáun² li²¹ ñí¹ quɨ́n¹ jáun² hi³ lin¹ hi³ má²dí¹jnaɨ³² tiá³, hi³ jáun² ca³chan³ dí² cun³ nió³ hliáu³ ñí¹ jáun² hi³ jmu³ hua³hí¹³. ");
INSERT INTO csoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jáun² né³, jmɨ́¹ má²ca³nga² *jmáɨ¹ hi³ tianh³² tsú² tie³, jmɨ́¹ má²já²jnia² la³ñí¹ jmáɨ¹ hi³ ca³lɨ³liau³ sɨ́²ma¹ná¹, ngau³ Má²réi³ tsá² ja³ hí³ juú² Magdalá, la³ má²quionh³ Má²réi³ jan² nɨ́² siáh³ hi³ ca³ñí¹jɨ́e¹³ tá²hón³². ");
INSERT INTO csoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cu³diá²jan² jmɨ́¹ ca³jɨ́eh³ hué³² tiá³ lɨ́n³², quí¹ jan² tsá²cuú² tsá²ta³ Dió³² Juo¹³ dí² la³ ca³son² hñu³mɨ³cuú² hi³ cuan³ ho³ tá²hón³², hi³ jáun² ca³lɨ́h³ tsú² tɨ³ có³² quɨ́n¹ hi³ jmɨ́¹ dí¹jnáɨ²³ jáun² ho³ tá²hón³², hi³ jmɨ́¹ lɨ²¹ jáun² né³ ca³cua³tsɨ́¹ tsú² ñí¹ quɨ́n¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tsá² hí³ jmɨ́¹ jniá³ cú²tú² cú²zɨ́n³ la³jmɨ́¹ jniá³ sɨ́² quioh²¹ miíh³², hi³ jáun² ha¹ tsú² né³, jmɨ́¹ tiáu² la³jmɨ́¹ tiáu² jan³². ");
INSERT INTO csoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jmɨ́¹ ca³jɨ́e³ hliáu³ hi³ jáun², jáun² lɨ́¹ ca³juan³ bíh¹ hi³ ca³juénh²; hi³ jáun² ca³ta³tonh¹ la³jmɨ́¹ tionh² tsá² má²ná¹jún¹. ");
INSERT INTO csoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jáun² tsá²cuú² tsá²ta³ Dió³² ca³záɨh³ tsá²mɨ³ hí³ la³ lá² jmɨ́¹ ca³cha³táunh¹: ―Ha³ lɨ́² juenh³ náh². Jná¹³ ño¹ hi³ hnoh² hnah²³ Jesús Tsá² ca³taun³ hí³ crei²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tɨ³la³ tiú²uú² hin² zian² yáh³ ñí¹ lá², quí¹ má²ca³jenh¹³ bíh¹ tsú², rón³² la³ cun³ hi³ qui³ ca³juáh³ tsú² jáun² jmɨ́¹tin². Sá¹nɨ́² dúh¹ ñá²jɨe³ náh² ñí¹ jmɨ́¹ ca³quión³² tsú² hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jáun² né³, tia³juɨ³² cuá²tánh¹ náh², cuá²zéih³ náh² tsá² haɨn²¹ hí³ tɨ³ con² tsú² la³ lá²: “Má²ca³jenh¹³ bíh¹ tsú² ja¹ hla¹; hi³ jáun² né³² né³, má²tsó³² tsú² chí¹ján³ tɨ³ Galilea la³ cun³ bíh¹ hnoh², hi³ jáun² ñí¹ jáun² lɨ́¹³ cuá¹jɨen¹ náh² tsú²”. Jɨ́³²la³ hi³ nɨ́² bíh¹ ja³ jná¹³ hi³ ja³juánh³² ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hi³ jáun² tia³juɨ³² lɨ́n³² bíh¹ ja³tanh²¹ tsá²mɨ³ hí³, hi³ hí¹juenh²¹, jɨ³ hi³ hí¹tsah³ siáh³ tá¹la³ jáun²; hi³ ca³ñí¹caun² dí² jáɨ¹³ ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tá¹la³ hí¹tsá²tánh¹ jáun² tsá²mɨ³ hí³ ca³ma³jnia³² Jesús ñí¹con², hi³ ca³juáh³: ―Hia² náh². Jáun² tsá²mɨ³ hí³ ca³ma³janh³² ñí¹con² Jesús hi³ ca³ma³tsu³ ma³jónh³² dí² tsú², hi³ ca³zanh³ dí² ta³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jáun² Jesús ca³juáh³ ñí¹con² tsá²mɨ³ hí³: ―Ha³ lɨ́² juenh³ náh². Cuá²zéih³ náh² renh² jná¹³ hi³ hniáuh³² tsa³táunh¹ tsú² Galilea, hi³ jáun² ñí¹ jáun² jenh¹³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tá¹la³ má²hí¹tsá²tánh¹ jáun² tsá²mɨ³, ja³bí¹ ma³ jan² hliáu³ hí³ ja³tanh²¹ tɨ³ já¹ juú², tsá² jmɨ́¹ ná¹jmu² hí³ hua³hí¹³ tá²hón³², hi³ ca³ñí¹zeh¹ tsá² ná¹lɨ́n³ mi³jmú³ la³jɨ́³² la³ cun³ hi³ má²lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jáun² tsá² hí³ né³ ca³ñí¹lienh¹³ tsá²daun³² tsá² ná¹ñí¹ juú², hi³ ca³ñí¹jmú¹³ cá²hon³ quionh³; jmɨ́¹ lɨ²¹ jáun² ca³cuéh³ dí² hliáu³ hliáun³ lɨ́n³² quɨe³, ");
INSERT INTO csoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Hnoh² juáh¹³ náh² hi³ ta³ hua² tá¹la³ ná¹cuóun¹ bíh¹ náh² ca³cha³táunh¹ tsá² haɨn²¹ tɨ³ con² Jesús hi³ cuɨ́²ñí¹han¹³ hla¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hi³ nɨ́¹juáh³ ca³lɨ³ ñi³² tsá² ho² ta²¹ jáɨ¹³ nɨ́² né³, jnoh¹ tauh¹³ tiá³ hi³ má¹hiún¹³ jnoh¹ tsɨ́³ tsú², hi³ jáun² tiá² lɨ³ zia³² uu³mí²tsɨ³² ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Hi³ jáun² jmɨ́¹jáun² né³ ca³héi³ hliáu³ quɨe³, hi³ jáun² ñí¹jmú¹³ la³ cun³ hi³ má²lɨ́²juáh³ tsú² jáun². Hi³ jáun² la³ jáun² bí¹ ná¹juáh²³ tsá² *judíos la³ tɨ³ ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jáun² né³, tán¹ quian³jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ja³taunh²¹ tɨ³ tsɨ³ máh³ có³² Galilea ñí¹ jmɨ́¹ má²ca³juáh³ jáun² Jesús jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hi³ jáun² jmɨ́¹ ca³jɨ́en³² tsú² Jesús, ca³ma³tsu³ ma³jónh³² dí²; uá¹jinh¹ ma³ jan² tsáu² jmɨ́¹ ná¹tioh³ tun³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jáun² Jesús ca³ja³janh³² ñí¹con² tsá² hí³, hi³ ca³záɨh³ dí² la³ lá²: ―Jná¹³ má²ho² jáɨ¹³ ñí¹ ca³la³ jɨ́³² hñu³mɨ³cuú² jɨ³ ñí¹ hué²¹ lá² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Cuá²táunh¹ náh² ñí¹con² la³jáh³ dúh¹ ñí¹ juo³ tsá² jma², cuá²jmu³ náh² hi³ han³ tsú² tɨ³ con² jná¹³; cuá²zion³ náh² tsú² jmáɨ² cun³quionh³ héih³² quioh²¹ Jméi² dí², jɨ³ Jon² tsú², jɨ³ cun³quionh³ héih³² quioh²¹ Jmɨ́²chí³ Chun¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Cuá²ma³tɨn¹³ náh² tsú² hi³ ma³tí³² la³jɨ́³² héih³² hi³ má²cá²jmú³² jná¹³ ñí¹con² hnoh². Hi³ cuɨ́¹ lɨ³ ñíh¹ náh² siáh³ hi³ jná¹³ zenh² ná¹ quiúnh¹ hnoh² ca³la³ tɨ³ ñí¹ cá¹táuh³ jmáɨ¹. Cun³ nɨ́² bíh¹ tí³ jáɨ¹³.");
INSERT INTO csoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","La³ lá² bíh¹ ca³lɨ³liau³ jú¹ chú³² hi³ ca³tɨn¹ Jesús Tsá² lɨ́n³ Cristo Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ñí¹ Sí² quioh²¹ hla¹ Isaías tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² rá¹juáh³ la³ lá²: Sá¹nɨ́² jɨe³, jná¹³ zein²¹ jan² tsá² tsa³can³² jáɨ¹³ ta³ tin² la³ cónh³ bíh¹ hnú², tsá² hí³ bíh¹ jmu³ hua³jan²¹ juɨ³² ñí¹ cuóh¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tɨ³ hué³² quiéin² niéih³ cáun² ho³ tsáu² hi³ ñí¹juah²¹: Jmu³ náh² hua³jan²¹ juɨ³² ñí¹ já²¹ Juo¹³ dí²; jmu³ náh² cú²tso² juɨ³² ñí¹ tsó²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Hi³ jáun² bíh¹ cuan³ Juan² hi³ ca³zion³ jmáɨ² tsáu² ñí¹ lɨ́³ jáun² hué³² quiéin², hi³ ca³záɨh³ dí² tsáu² hi³ hniáuh³² záɨ³² tsú² jmɨ́¹ tsɨ́³ jɨ³ hi³ zón³² tsú² siáh³ jmáɨ², hi³ jáun² lɨ́¹³ hin³ tsáu¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","La³jɨ́n³² tsá² hɨ́n¹³ tɨ³ Judea jmɨ́¹ já²táunh¹ hi³ náɨ³² jáɨ¹³ quioh²¹ tsú², la³ má²quionh³ tsá² zian² juú² Jerusalén nɨ́² siáh³; hi³ jáun² nɨ́¹juáh³ nɨ́¹ má¹lɨ́²ton³ tsú² tso³ quioh²¹, má¹lɨ³² jáun² tɨ́² ziau² Juan² jmáɨ² cua³ Jordán jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ha¹ Juan² hí³ né³ jmɨ́¹ lɨ́³ jñú¹³ jáh³ cánh¹ téh²³ tsú² camello, hi³ jáun² lá² hñéih¹ tsú² jmɨ́¹ lɨ́³ láu²; má³² hi³ jmɨ́¹ cúh² tsú² né³, jáh³ téh²³ tsú² náɨh² bíh¹ quionh³ jmɨ́²toh¹ quioh²¹ toh² zian² ja¹ náɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jáun² tsá² hí³ jmɨ́¹ hleh³² hi³ zaɨh³² tsáu² la³ lá²: ―Né³bí¹ já²¹ jan² tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cun³ bí¹ jná¹³, quí¹ cun³ tiá² cu³ tiá² ren³ bíh¹ jná¹³ quiúnh¹ ná¹ Tsá² hí³, hi³ juáh¹³ hi³ jmɨ́¹ lɨ³ dí¹jñi²¹ jná¹³ ta³ ñí¹ tsú² hi³ hueh²¹ ná¹ láu² tsɨ³² ta³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jná¹³ dá² má²lɨ́²ziau³ ná¹ hnoh² jmáɨ² cun³quionh³ jmɨ́² jma³; tɨ³la³ tsá² hí³ né³, ziau³ hnoh² jmáɨ² cun³quionh³ Jmɨ́²chí³ Chun¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jáun² jmɨ́¹jáun² cua³han³ Jesús já¹ juú² Nazaret, juú² hɨ́n¹³ tɨ³ Galilea, hi³ ca³chó³² dí² cua³ Jordán ñí¹ ca³ziau³ jáun² Juan² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hi³ jáun² la³ cun³ jmɨ́¹ cuá¹han³ Jesús chu³ jmáɨ² né³, ca³jɨ́e³ tsú² tɨ³ hñu³mɨ³cuú² hi³ má²ca³niá³, hi³ jáun² má²cuá¹son² Jmɨ́²chí³ Chun¹ ñí¹ quioh²¹ dí² hi³ jniá³ la³jmɨ́¹ jniá³ jan² jáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Hi³ jáun² ca³náɨ³² tsáu² cáun² mah¹ hi³ ja³ tɨ³ hñu³mɨ³cuú², hi³ ñí¹juah²¹ la³ lá²: ―Hnú² bíh¹ Jón³² jná¹³, Tsá² hno³ lɨ́n³² jná¹³, ¡jlánh¹ lɨ́²hiún² tsɨn³² jná¹³ ca³tɨn¹ hnú²! ");
INSERT INTO csoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","La³ cun³ jmɨ́¹jáun² né³, ca³jau³ Jesús Jmɨ́²chí³ Chun¹ tɨ³ hué³² quiéin². ");
INSERT INTO csoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ñí¹ jáun² ca³cuá³ Jesús tun³ló³² jmáɨ¹ hi³ ñi³ngɨ²¹ ja¹ jáh³ hngá¹ jáh³ náɨ², hi³ *Satanás né³ ca³ca³ ca³lau³ quioh²¹ tsú². Jáun² cua³taunh²¹ tsá²cuú² tsá²ta³ Dió³² hi³ cua³ma³cáu³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jmɨ́¹ má²hi³² jáun² Juan² tsá² ziau² hí³ jmáɨ² hñu³mí¹ñí² né³, ngah³ siáh³ Jesús tɨ³ hué¹³ Galilea, hi³ hleh³² jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsú² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Má²ca³ma³jnia² bíh¹ Dió³² Tsá² má²cuá¹hiáun¹ hi³ lɨ́n¹³ Re²¹. Za¹ náh² jmɨ́¹ honh², hi³ tionh² náh² siáh³ ta²¹ jú¹ chú³² hi³ lɨ́¹³ liáu³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús jmɨ́¹ cuá¹tsau³² can³² ñí¹ ná¹ho³ jmáɨ² hué¹³ Galilea, jáun² ñí¹ jáun² né³ ca³jɨ́en³² tsú² Sí¹mu²¹ quionh³ Tre²¹ raɨnh²¹ hi³ ná¹tón³² hmá³ chu³ jmáɨ², quí¹ tsá² zanh²³ jáh³ jmáɨ² bíh¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Ñá²táunh¹ náh² cu³hna³² jná¹³, hi³ jáun² la³jmɨ́¹ jáun²³ náh² nɨ́² jáh³ jmáɨ² janh²¹ náh² siáh³ tsá²mɨ³cuóun² hi³ tónh³² jo³uón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³chá³ tsá² hí³ tɨ³ có³² hmá³ jáun² quioh²¹, hi³ ja³taunh²¹ cu³hna²¹ hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cú¹pih²¹ bíh¹ ñí¹ ngau²¹ Jesús hi³ jáun² ca³jɨ́en³² siáh³ Jacobo, jon² Zebedeo, la³ má²quionh³ Juan² dá¹jon²¹, hi³ jmɨ́¹ tiáunh¹ hñu³ mu² hi³ ná¹rauh³² hmá³ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hi³ jáun² Jesús ca³teh³ siáh³ tsá² hí³; hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³chan³ tsá² hí³ Zebedeo jméi² hñu³ mu² la³ má²quionh³ tsá² ná¹lɨ́n³ quian²¹, hi³ jáun² hí³ dí² né³ já¹taunh²¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jmɨ́¹jáun² ca³cha³táunh¹ tsú² juú² Capernaum; hi³ jáun² jmɨ́¹ cá¹chó²¹ *jmáɨ¹ nio² tie³ né³, ca³hi³ Jesús hñu³ cuáh³² quioh²¹ tsá² *judíos hi³ ca³ma³liáu³² hi³ má²tɨn² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ ca³tɨ²¹ jáɨ¹³ hi³ má²ta² tsú² jáun²; quí¹hliá² jmɨ́¹ cuá¹hɨeh³² tsú² tsáu² la³juah²¹ dúh¹ jan² tsá² ho² jáɨ¹³, jun³juáh¹³ la³jmɨ́¹ jmu² tsá² ná¹lɨ́n³ tɨ³² liei²¹ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hñu³ cuáh³² jáun² jmɨ́¹ cuá³ jan² tsá²ñuh² hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³, jáun² ca³hóh³² tiá³ hi³ ca³juáh³: ");
INSERT INTO csoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―¿He³ jáɨ¹³ zia³² quiúnh¹ jnoh¹ hnú², Jesús Tsá² Nazaret? ¿Hí¹ ñeh³ hnú² hi³ ña³cua² nú² jnoh¹ quiu³juóu³²? Tsá² cuóu³² bíh¹ jná¹³ hnú², hi³ ño¹ jná¹³ hi³ hnú² Tsá² hɨ́en¹ Tsá² zéi¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jáun² Jesús ca³ngáɨ³ tiá³ ñí¹con² jmɨ́²chí³ hláɨnh¹ hí³ hi³ ca³juáh³: ―¡Tie³ náu², tun³² tsá²ñuh² nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ né³ ca³jmú³ hi³ ca³jéinh³² tsá²ñuh² hí³ tsá¹ lɨ́¹ jún²³, hi³ ca³hóh³² tiá³ lɨ́n³², jmɨ́¹jáun² cua³han³ hñu³ tsɨ́³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jáun² la³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³ja³cáun² tsɨ́³ hi³ ca³qui³ ca³ngáɨh³ raɨnh²¹, hi³ juáh³: ―¿He³ dá² nɨ³²? ¿He³ dá² jú¹ hmaɨ²¹ nɨ³² hi³ hɨe³² tsú²? ¡Sa³ tɨn² máh³ tsá²ñuh² nɨ́² jmu² héih³² ñí¹con² jmɨ́²chí³ hláɨnh¹, hi³ jáun² jmɨ́²chí³ hláɨnh¹ má²tí³² máh³! ");
INSERT INTO csoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jáun² né³² cánh³ bíh¹ ca³lɨ³ ñi³² tsú² tá¹ cáun² hué¹³ Galilea hi³ jmu² Jesús la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jmɨ́¹ ca³huén² tsú² hñu³ cuáh³² jáun² né³, ngau³ Jesús quionh³ Jacobo jɨ³ Juan² hñú¹³ Sí¹mu²¹ quionh³ Tre²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jmɨ́¹jáun² jmɨ́¹ rá²tsáun¹ mɨ³ziú¹³ Sí¹mu²¹ hi³ chéin³; hi³ jáun² tsá² tionh² hí³ ñéih³ la³juɨ³² ca³záɨh³ Jesús hi³ tsá² hí³ rá²tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jmɨ́¹jáun² ngau³ Jesús ñí¹ rón²¹ tsá² hí³, hi³ ca³zanh³ dí² cuo² tsú², hi³ ca³zion³ dí²; hi³ jáun² ca³quin³ hi³ jmɨ́¹ chéin³ tsú², hi³ jáun² jmɨ́¹jáun² ca³jmú³ tsú² má³² hi³ cuh³ tsú² jɨ³lɨn². ");
INSERT INTO csoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Jmɨ́¹ má²ca³ta³tsɨ²¹ hiú² ca³cua³jan² tsú² la³jɨ́n³² tsá² tsáun¹ ñí¹con² Jesús, jɨ³ tsá² jmɨ́¹ tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","hi³ jáun² la³jɨ́n³² tsá² juú² ca³cuú² ca³ngɨh³² ho³hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jmɨ́¹jáun² ca³jmah³ dí² juóun³² lɨ́n³² tsá² tsáun¹; tsá² hí³ jmɨ́¹ ná¹lɨ́n³ hliáun³ ñí¹ mɨ́¹uɨ́³, hi³ juóun³² siáh³ tsáu² ca³huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. Jmɨ́²chí³ hláɨnh¹ hí³ jmɨ́¹ má²ná¹ñi³² hi³ hin² tsánh² Jesús, tɨ³la³ Jesús né³ ca³jmú³ héih³² hi³ tiá² hɨe³ tsú² hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jmɨ́¹ cá¹jniá²¹ jáun² né³, ta³ ná¹juan³² bíh¹ ca³náu² Jesús hi³ ngau³ hi³ ñí¹lienh¹³ Dió³² ñí¹ má²tɨ³ có³². ");
INSERT INTO csoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jáun² Sí¹mu²¹ la³ má²quionh³ tsá² quionh³ ca³ñí¹hniauh², ");
INSERT INTO csoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","hi³ jáun² jmɨ́¹ ca³chanh²¹ dí² Jesús ca³záɨh³ dí² la³ lá²: ―La³jɨ́n³² bíh¹ tsáu² ná¹hnauh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tɨ³la³ hí³ dí² né³ ca³juáh³: ―Ma³tsáu¹³ dí² juú² tioh³ cu³ jéin³ nɨ́², hi³ tsá¹hléh¹³ dí² uá²jaɨ³² jú¹ chú³² quioh²¹ Dió³² ñí¹ nɨ́²; quí¹ ta²¹ jáun² yáh³ má²cuán² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","La³ jáun² bíh¹ ca³ngɨ́³ Jesús hi³ ngaɨ³² jú¹ chú³² hñu³ cuáh³² quioh²¹ tsá² judíos hi³ táun³ ma³ quin³² ma³ caun³² juú² hɨ́n¹³ tɨ³ Galilea, jɨ³ hi³ huen² dí² siáh³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jmɨ́¹jáun² cuan³ jan² tsá²ñuh² lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³ ñí¹con² Jesús, hi³ jáun² ca³di³jñí³² dí² hi³ ca³juáh³: ―Tɨn² bíh¹ hnú² jmúh¹³ hi³ lɨ³ jɨn² jná¹³ nɨ́¹juáh³ hi³ hnáuh² nú² jmúh¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jáun² Jesús ca³ja³ mií³ tsɨ́³, hi³ jáun² ca³tí³ dí² cuo² ñí¹ quioh²¹ tsá² hí³, hi³ ca³juáh³ la³ lá²: ―Hnó³² jná¹³. Hi³ jáun² ¡cuɨ́¹ lan² hnú²! ");
INSERT INTO csoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jmɨ́¹ má²lɨ́²juáh³ tsú² jáun² la³ nɨ́² né³, la³juɨ³² ca³hin³ bíh¹ mɨ́¹uɨ́³ jáun² quioh²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jmɨ́¹jáun² ca³hah² Jesús jáɨ¹³ ñí¹con² tsá² hí³, tɨ³la³ la³ñí¹ tín² ca³jmú³ tsú² héih³², hi³ ca³záɨh³ dí²: ");
INSERT INTO csoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Sá¹nɨ́² jɨe³, ha³ lɨ́² hin² juouh³² hí¹ jan² ha³ lánh³ rón³² lɨ³ hi³ má²laɨn³² nú²; jɨ́³²la³ ti³ cuánh², hi³ cuá²ma³jnia¹³ ñí¹con² mí²tsáu² bíh¹, hi³ cuá²cuen²¹ siáh³ jáh³ ñí¹con² Dió³² ca³tɨ²¹ hi³ má²ca³lɨ³ jɨn² nú², la³ cun³ lɨ́³ jáun² héih³² quioh²¹ hla¹ Moisés. Hi³ jáun² la³ jáun² lɨ³ ñi³² tsáu² hi³ má²laɨn³² nú². ");
INSERT INTO csoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ngah³ bíh¹ tsá²ñuh² hí³ jmɨ́¹ ngah²¹, tɨ³la³ jmɨ́¹ lɨ²¹ jáun² né³, ca³ma³liáu³² hi³ quí² cha³² la³ cun³ hi³ má²lɨ³² jáun². Cun³ñí¹ hi³ jáun² né³, hí¹ cáun² yáh³ juú² tiú²uú² jmɨ́¹ lɨ́²³ hí³ Jesús chú¹ja²¹, jáun² tɨ³ cheih³² ñí¹ tiá² hin² zian² bíh¹ cú²jueh³² jmɨ́¹ ngɨ³² tsú²; tɨ³la³ tsá² zian² ñí¹ hliáun³ bíh¹ jmɨ́¹ já²táunh¹ hi³ já²jɨe³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jmɨ́¹ má²ca³nga² tun³ hnɨ³² jmáɨ¹ jáun² ngah³ siáh³ Jesús já¹ juú² Capernaum; hi³ jáun² ca³lɨ³ ñi³² tsáu² hi³ hí³ má²cuá¹tón²¹ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Hi³ jáun² juóun³² lɨ́n³² bíh¹ tsáu² ca³cuú² ca³ngɨh³² ñí¹ cuá³ jáun² Jesús, ca³la³ hí¹juáh³ ho³hñú¹³ yáh³ tiú²uú² jáu² lɨ³. Tá¹la³ jmɨ́¹ dí¹hɨe³² Jesús jáɨ¹³ quioh²¹ Dió³² ñí¹con² tsá² hí³ né³, ");
INSERT INTO csoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","cua³taunh²¹ quiun³ tsá²ñuh² hi³ ná¹jan² jan² tsá²ñuh² lɨ́n³ mɨ́¹uɨ́³ hi³ hma², hi³ rá¹tsɨn² ñí¹ jmu². ");
INSERT INTO csoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tɨ³la³ tiá² lɨ³ yáh³ tsa³táunh¹ tsú² ñí¹ cuá³ Jesús quí¹hliá² jlánh¹ juóun³² tsáu² jmɨ́¹ tionh¹, hi³ jáun² tsáɨh³ hñú³ bíh¹ cú²jueh³² ca³uú³ tsú², hi³ ca³quin³ tsú² cuá¹lá² hi³ jláɨ³ hñú³ la³ re² ñí¹ cuá³ jáun² Jesús, hi³ jáun² juɨ³² jaun³² bíh¹ ca³sión³² tsú² tsá² tsáun¹ la³ má²tsɨn² jáun² ñí¹ jmu². ");
INSERT INTO csoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jmɨ́¹ ca³lɨ³tsɨn² jáun² Jesús hi³ cáun² tán¹ bíh¹ ná¹tioh³ tsɨ́³ tsá² ca³cha³táunh¹ hí³, hi³ jáun² ca³záɨh³ dí² tsá² tsáun¹ hí³ la³ lá²: ―Hnú² jón³, má²cá²hin³ bíh¹ tso³ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tɨ³la³ ma³ jan² tɨ³² liei²¹ jmɨ́¹ tionh¹ ñí¹ jáun² ca³lɨ́n¹³ la³ lá² hñu³ tsɨ́³: ");
INSERT INTO csoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿He³ láɨh³² sa³ la³ nɨ́² máh³ hleh³² tsá²ñuh² nɨ́²? Tsá² lɨ́¹ chú² lɨ́¹ lén³² Dió³² bíh¹ nɨ³², quí¹ hí¹ jan² yáh³ tiá² hin² tɨn² hin³ tso³, jɨ́³²la³ hnga² Dió³² bíh¹ Tsá² tɨn²”. ");
INSERT INTO csoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tɨ³la³ Jesús jmɨ́¹ ñi³² bíh¹ he³ lánh³ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ dí²: ―¿He³ láɨh³² sa³ la³ nɨ́² ná¹lɨ́n²³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Hín² jáɨ¹³ hi³ tun³ lá² hi³ jlánh¹ huán¹ tsɨ́³ lɨ³ lin¹ hi³ zia³² pí³ quioh²¹ tsá² hleh³²; hí¹ cun³quionh³ hi³ juáh³ tsú²: “¡Tso³ quián¹³ hnú² má²cá²hin³!”, ho³ hi³ juáh³ tsú²: “¡Náu², quiaun² jmu² quián¹³, hi³ jáun² ngɨ́¹!” uá¹? ");
INSERT INTO csoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Re² bíh¹, cuɨ́¹ má¹jnia¹³ jná¹³ ñí¹con² hnoh² hi³ jná¹³ Jon² tsá²mɨ³cuóun², ho² ná¹ jáɨ¹³ ñí¹ hué²¹ lá² hi³ hin¹³ ná¹ tsáu¹³ tsáu². Hi³ jáun² ca³záɨh³ dí² siáh³ tsá² hma² hí³: ");
INSERT INTO csoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Hnú² juo³ jná¹³: náu², ziáuh¹ jmu² quián¹³, quiaun², cuánh² hñuh³². ");
INSERT INTO csoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³náu² tsá² jmɨ́¹ hma² hí³ ta³ ñí¹ la³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñéih³, jáun² ca³ziauh³ jmu² hi³ jmɨ́¹ tsɨn², hi³ ca³caun² ngah³ hñú¹³. Jáun² la³jɨ́n³² tsá² jmɨ́¹ ná¹jɨ́e²³ hí³ ca³ja³cáun² lɨ́n³² tsɨ́³, jáun² ca³ma³quien² tsú² Dió³², hi³ ca³juáh³: ―¡Hí¹ cónh³ yáh³ tiá² má²ca³neh²¹ dí² la³ cun³ hi³ má²lɨ́²neh²¹ dí² nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jmɨ́¹ lɨ²¹ jáun² cua³han³ Jesús hi³ ngau³ siáh³ can³² ñí¹ ná¹ho³ jmáɨ²; hi³ jáun² jmɨ́¹ cuá¹taunh²¹ la³jɨ́n³² tsáu² ñí¹ zenh¹ tsú² ca³ma³tɨn² dí² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jáun² né³, tá¹la³ má²hún¹ tsú² siáh³ juɨ³² hi³ má²tsánh³² tɨ³ já¹ juú², ca³jɨ́en³² dí² jan² tsá² jmáɨ² Leví jon² Alfeo, hi³ jmɨ́¹ cuá¹tón²¹ ñí¹ cuá¹caɨ³² hmah²¹ cha¹³ tsá² *romanos, hi³ jáun² ca³záɨh³ dí²: ―Ña³² cu³hna³² jná¹³. Jmɨ́¹jáun² ca³náu² Leví, hi³ ngau³ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jmɨ́¹ lɨ²¹ jáun² né³, Jesús jmɨ́¹ cuá¹jmu² má³² hñú¹³ Leví hí³, la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ juóun³² siáh³ *tsá² caɨ³² hmah²¹ jɨ³ la³ má²quionh³ tsá² juáh²³ tsáu² hi³ tiá² chun¹ jmɨ́¹ tionh¹ ñí¹ mesa quionh³ Jesús, quí¹ juóun³² lɨ́n³² bíh¹ tsá² jmɨ́¹ hí¹tsá²táunh¹ cu³hna²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tɨ³la³ jmɨ́¹ ca³jɨ́e³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, tsá² tiáunh¹ ja¹ cu³ nió³ quioh²¹ tsá² téh²³ tsú² *fariseos, hi³ cuá¹cúh² Jesús quionh³ la³jɨ́n³² tsá² hí³, jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² tsú²: ―¿Ha³ bí¹ lánh³ rón³² sa³ tɨ³² juóuh³² hnoh² cáun² cuú² hɨ́nh²³ cu³lɨ²¹ quionh³ tsá² caɨ³² hmah²¹ jɨ³ tsá² ren² tso³ nɨ́² siáh³? ");
INSERT INTO csoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jmɨ́¹ ca³náɨ³² Jesús jáɨ¹³ nɨ́² né³, ca³juáh³: ―Tiá² tɨ³² mɨ́³ hniah³ yáh³ ñí¹con² tsá² chun¹, ñí¹con² tsá² tsáun¹ bíh¹ hniah³. Quí¹ tiá² ja³ yáh³ jná¹³ hi³ ja³te³ tsá² chun¹, quí¹ hi³ ja³te³ tsá² ná¹ren² tso³ bíh¹ jná¹³ ja³. ");
INSERT INTO csoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Cu³ jéin³² jmɨ́¹ ná¹má²hɨen²¹ tsá² haɨn²¹ tɨ³ con² Juan² tsá² ziau² hí³ jmáɨ² jɨ³ tsá² haɨn²¹ tɨ³ con² tsá² fariseos nɨ́² siáh³, jmɨ́¹jáun² cua³taunh²¹ ma³ jan² tsáu² ñí¹con² Jesús hi³ ca³ngáɨ³: ―¿He³ láɨh³² sa³ jlánh¹ má²hɨen²¹ tsá² haɨn²¹ tɨ³ con² Juan² tsá² ziau² hí³ jmáɨ² jɨ³ tsá² haɨn²¹ tɨ³ con² tsá² fariseos siáh³, tɨ³la³ tsá² haɨn²¹ tɨ³ con² hnú² má¹ná¹, tiá² lin¹ má²hɨen²¹ yáh³? ");
INSERT INTO csoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jáun² Jesús ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ tá¹la³ ná¹má²hiún² tsú² tsɨ́³ quionh³ tsá²ñuh² tsá² jenh¹³ cuo² ¿hí¹ lɨ́¹³ ma³hɨen²¹ tsá² ná¹tén¹ ñí¹ jmu² tsú² jmáɨ¹ hi³ jenh² cuo² tsáu² dúh¹? Tiá² lɨ́¹³ yáh³ ma³hɨen²¹ tsú² tá¹la³ quionh³ bíh¹ tsú² tsá² jenh¹³ hí³ cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tɨ³la³ chau²¹ bíh¹ jmáɨ¹ hi³ quin³ tɨ³ có³² tsá²ñuh² jenh¹³ hí³ cuo²; hi³ jáun² má¹jáun² máh³ má²ma³hɨen²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","”Hí¹ jan² yáh³ tiá² hin² taun³² cáun² hmɨh³² tseh¹ quionh³ cá² cuonh²¹ hmɨh³² hmaɨ²¹; quí¹ tsauh³² bíh¹ hná¹ hmɨh³² hmaɨ²¹, hi³ jáun² cáɨ³² bíh¹ hmɨh³² tseh¹, hi³ jáun² tɨ³ jlánh¹ bíh¹ ñí¹ jueh³² má²cáɨ³² má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ja³bí¹ la³ jáun², hí¹ jan² yáh³ tiá² hin² tah³² mu² ráu³ cun³ ñí¹ dí¹jaun³² hñu³ chí² láu² má²tseh¹; quí¹ nɨ́¹juáh³ hi³ jmu³ tsú² la³ jáun², má²cáɨ³² bíh¹ chí² láu² tseh¹ jáun² lɨ́¹³, hi³ jmu³ mu² ráu³ cun³ ñí¹ dí¹jaun³² jáun², jáun² lɨ́¹ má²tsa³hín³ bíh¹ mu² ráu³ jáun² lɨ́¹³ la³ má²quionh³ chí² láu². Hi³ jáun² hñu³ chí² láu² hmaɨ²¹ bíh¹ hniáuh³² táh³² tsú² mu² ráu³ cun³ ñí¹ dí¹jaun³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ cuá¹ngɨ³² Jesús ja¹ ñí¹ zia³² hi³ jna¹ quioh²¹ tsáu² cáun² *jmáɨ¹ nio² tie³; hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, ca³ma³liáu³² hi³ caɨ³² chí² hieh² cuú²miih²¹ tá¹la³ hí¹tsá²táunh¹ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Hi³ jáun² tsá² fariseos ca³juáh³: ―Sá¹nɨ́² jɨe³, ¿he³ láɨh³² jmu² bíh¹ tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² ta²¹ hi³ tiá² ca³tɨ²¹ jmu³ tsú² jmáɨ¹ nio² tie³? ");
INSERT INTO csoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tɨ³la³ hí³ má¹ná¹, ca³juáh³: ―¿Tiá¹ má²ca³híh³ hnoh² hí¹ cónh³ ñí¹ Sí² quioh²¹ Dió³² hi³ he³ ca³jmú³ hla¹ re²¹ Dá²vi²¹ cu³ jéin³² jmɨ́¹ lɨ²¹ ñí¹cuóunh²¹ quionh³ tsá² quionh³, hi³ tiá² jmɨ́¹ zia³² hi³ cuh³ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tsá² hí³ dá² ca³ñí¹hi³² ñéih³ hñú³ cuáh³² lɨ́³ hmɨh³² hi³ ca³ñí¹cúh² *hí³ cuú²miih²¹ hɨ́en¹ hi³ ca³tɨn¹ cuh³ jmáh³la³ tsá² ná¹lɨ́n³ mí²tsáu² bíh¹; hi³ ja³bí¹ ca³cuéh³ tsú² siáh³ tsá² jmɨ́¹ tionh¹ quionh³. La³ jáun² lɨ³ jmáɨ¹ hi³ jmɨ́¹ lɨ́n³ hla¹ Abiatar mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ja³bí¹ ca³záɨh³ tsú² siáh³ tsá² hí³: ―Dió³² ca³jmú³ hi³ zia³² jmáɨ¹ nio² tie³ cun³ñí¹ hi³ ca³tɨn¹ tsá²mɨ³cuóun² bíh¹, jun³juáh¹³ ca³lɨ³zian² tsá²mɨ³cuóun² cun³ñí¹ hi³ ca³tɨ²¹ jmáɨ¹ nio² tie³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jáun² né³, uá¹ hi³ jmáɨ¹ nio² tie³, cun³ jáun² cáun² ho² bíh¹ Jon² tsá²mɨ³cuóun² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ca³chó³² siáh³ cáun² jmáɨ¹ hi³ ca³ñí¹hi³² Jesús hñu³ cuáh³² quioh²¹ tsá² *judíos; hi³ ñí¹ jáun² né³ jmɨ́¹ cuá³ jan² tsá²ñuh² jmɨ́¹ má²ca³náɨ³ cáun² cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jmɨ́¹jáun² jmɨ́¹ ná¹tan² tsú² Jesús hi³ hnió³ dí² jɨ́e³ nɨ́¹juáh³ hi³ jmah³ tsú² tsá² hí³ tá¹la³ *jmáɨ¹ nio² tie³, hi³ jáun² zia³² ha³ lánh³ rón³² lɨ́¹³ chá³² dí² tsáu¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² jmɨ́¹ má²ca³náɨ³ hí³ cuo²: ―Náu², jmu³ zenh² nú² ja¹ lá² quiú¹³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Hi³ jáun² Jesús ca³ngáɨh³ tsá² ná¹ngɨh³² hí³: ―¿He³ ca³tɨ²¹ jmu³ tsú² jmáɨ¹ nio² tie³, hí¹ hi³ chu²¹ ho³ hi³ hlah³? ¿Hí¹ lɨ́¹³ lión³² tsú² tsáu² ho³ hi³ tɨ³ hniáuh³² jngɨh³ uá¹ tsú²? Tɨ³la³ tsá² hí³ má¹ná¹, cáun² lɨ́¹ ca³tiánh³ tie³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jmɨ́¹jáun² ca³jɨ́en³² Jesús tsá² hí³ ca³la³ hi³ míh²³ tsɨ́³, jɨ³ hi³ hlah³ jéinh³² dí² siáh³ quí¹hliá² tiá² hnió³ yáh³ tsá² hí³ hi³ ngɨ¹³ jáɨ¹³; hi³ jáun² ca³záɨh³ dí² tsá² lɨ́³ hí³ cuo²: ―Ñéih¹ cuonh². Jáun² ca³ñeh³ tsá² hí³ cuo², hi³ jáun² jmɨ́¹jáun² la³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jmɨ́¹jáun² ca³huén² tsá² *fariseos cheih³² hi³ ca³ma³cú¹ ma³ren²¹ jáɨ¹³ quionh³ tsá² haɨn²¹ tɨ³ con² Herodes hi³ ha³ lánh³ jngɨh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jmɨ́¹ lɨ²¹ jáun² ngau³ Jesús can³² ñí¹ ná¹ho³ jmáɨ² quionh³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² juóun³² lɨ́n³² tsá² zian² hué¹³ Galilea ja³taunh²¹ cu³hna²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Hi³ juóun³² siáh³ tsá² já¹taunh²¹ tɨ³ hué¹³ Judea, tɨ³ já¹ juú² Jerusalén, tsá² Idumea, tsá² zian² tɨ³ jo²¹ cua³ Jordán tɨ³ juɨ³² ñí¹ hia³² hiú², jɨ³ tsá² hué¹³ Tiro quionh³ Sidón siáh³ cua³taunh²¹ hi³ hnió³ jɨ́en³² Jesús jmɨ́¹ ca³lɨ³ ñi³² dí² la³jɨ́³² hua³jueh³² hi³ jmu² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Cun³ñí¹ hi³ jáun² bíh¹ ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² hi³ jmu³ tsú² hua³jan²¹ cáun² mu² hi³ jáun² tiá² cuu³ tiá² jáɨ³² tsú² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Quí¹hliá² juóun³² lɨ́n³² bíh¹ tsáu² má²lɨ́²jmah³ tsú², hi³ jáun² la³jɨ́n³² tsá² tsáun¹ ñí¹ hná¹ jáun² cua³tú¹ cuá¹lɨn³, ca³la³ hi³ cuú² hi³ hlián²³ bíh¹ tsú² hi³ hnió³ tin³ cuo² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hi³ tsá² ná¹tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ né³, jmɨ́¹ ca³jɨ́en³² dí² Jesús, jáun² ca³di³jñí³² dí² ta³ ñí¹ tsú², hi³ ca³hóh³² hi³ juáh³: ―Hnú² bíh¹ lɨ́n³ Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tɨ³la³ Jesús ca³jin³ jmɨ́²chí³ hláɨnh¹ hí³, hi³ ca³jmú³ dí² héih³² ñí¹con² hi³ tiá² hin² záɨh³² tsú² hí¹ jan² hi³ hin² tsánh² hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jmɨ́¹ lɨ́¹ cáɨn² jáun² né³, ngau³ Jesús tsɨ³ máh³, hi³ jáun² ñí¹ jáun² ca³teh³ tsú² tsá² ca³tɨ́³ hí³ tsɨ́³ tsú² hi³ quianh³, hi³ jáun² né³ ja³taunh²¹ tsá² hí³ ñí¹con² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hi³ jáun² ca³hión³² dí² quian³tun³ tsá² hí³ hi³ ñi³táunh¹ dí² quionh³, jɨ³ hi³ zen³ dí² hi³ tsa³hléh² jú¹ chú³² quioh²¹ Dió³² nɨ́² siáh³. Tsá² quian³tun³ hí³ né³ ca³teh³ tsú² “*tɨ³² quian³² jë¹ Dió³²”. ");
INSERT INTO csoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jáun² ca³cuéh³ dí² tsú² pí³ hi³ lɨ́¹³ huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², jɨ³ hi³ tsa³jmah¹ tsú² siáh³ tsá² tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Tsá² quian³tun³ hí³ ná¹jmáɨ² la³ lá²: Sí¹mu²¹ tsá² ca³lɨ³ jmáɨ² siáh³ Pé¹; ");
INSERT INTO csoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","tá¹ gon³ jon² Zebedeo siáh³, Jacobo quionh³ Juan² dá¹jon²¹, la³ cun³ tá¹ gon³ tsá² téh²³ tsú² hí³ Boanerges yáh³ (hi³ hnió³ juáh³ “Tsá² lɨ́n³ la³jmɨ́¹ lɨ́n³ miíh³²”); ");
INSERT INTO csoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","jɨ³ Tre²¹ nɨ́², Pí²liéi¹, Bartolomé, Má²téh³, Tú¹ma²¹, Jacobo jon² Alfeo, Tadeo, Sí¹mu²¹ tsá² ca³lɨ³ quionh³ tsá² cu³ nió³ *Cananista, ");
INSERT INTO csoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","jɨ³ Judas tsá² zian² juú² Queriot nɨ́² siáh³, tsá² ca³ñí¹jɨenh¹³ hí³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jmɨ́¹ lɨ²¹ jáun² né³, ngah³ Jesús hñú¹³ quionh³ tsú² tsá² haɨn²¹ hí³ tɨ³ con²; hi³ jáun² ñí¹ jáun² ca³ngɨh³² siáh³ juóun³² lɨ́n³² tsáu², ca³la³ hí¹juáh³ tiú²uú² zia³² jmáɨ¹ hi³ cuh³ bíh¹ tsú² lɨ³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jmɨ́¹ ca³lɨ³ ñi³² jón¹ raɨnh²¹ Jesús hi³ jáun², jáun² cua³taunh²¹ tsú² hi³ cón³² Jesús, quí¹ jmɨ́¹ ná¹juáh²³ tsáu² hi³ Jesús má²ca³lɨ³ ngo² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ja³bí¹ tsá² ná¹lɨ́n³ tɨ³² liei²¹, tsá² ja³taunh²¹ hí³ tɨ³ já¹ juú² Jerusalén jmɨ́¹ ná¹juáh²³: ―Beelzebú tsá² chín¹ juo¹³ jmɨ́²chí³ hláɨnh¹ bíh¹ hún¹ hñu³ tsɨ́³ tsá²ñuh² nɨ́², cun³quionh³ pí³ quioh²¹ tsá² hí³ bíh¹ huen² tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hi³ jáun² Jesús né³ ca³teh³ tsá² hí³ hi³ ca³jmú³ dí² cáun² jáɨ¹³ ñí¹con² tsú² hi³ juáh³ la³ lá²: ―¿He³ lánh³ rón³² lɨ́¹³ hi³ *Satanás lɨ́¹³ chin¹³ cheih³² hnga²? ");
INSERT INTO csoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nɨ́¹juáh³ jmɨ́¹ zia³² hniéi² ja¹ má²tún² hmóu³² tsá² ná¹lɨ́n³ ta²¹, jáun² tiá² lɨ³ uén³ yáh³ tsú² jáɨ¹³ hi³ ná¹ho² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ja³bí¹ la³ jáun² nɨ́¹juáh³ tsá² zia³² hniéi² hñú¹³, tiá² lɨ³ uén³ yáh³ tsú² cáun² hñú³ cu³tsa³². ");
INSERT INTO csoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hi³ jáun² né³, sá¹jmɨ́¹ hi³ hnga² Satanás jmu² hniéi² ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² tiá² ma³hɨ́e² yáh³ pí³ quioh²¹ tsú², ñí¹ má²tsa³hín³ bíh¹ tsú² jaun³² nɨ́¹juáh³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","”Hí¹ jan² yáh³ tiá² hin² lɨ́¹³ hí³ hñú¹³ jan² tsá² pin³ lɨ́n³², hi³ quin³ tsú² la³jɨ́³² hi³ nio² hñú¹³ tsú², nɨ́¹juáh³ tiá² la³ hñe³ yáh³ tsú² tín² tsá² hñú¹³ hí³; quí¹ jɨ́³²la³ la³ jáun² bíh¹ lɨ́¹³ quin³ tsú² hi³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","”Jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ la³jɨ́³² tso³ hi³ jmu² tsá²mɨ³cuóun², jɨ³ la³jɨ́³² jú¹ hlah³ hi³ hleh³² tsú², zia³² bíh¹ uu³i³tso³ quioh²¹ tsú²; ");
INSERT INTO csoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","tɨ³la³ tsá² tú² hión³² Jmɨ́²chí³ Chun¹ má¹ná¹, cun³ jmɨ́¹lɨ́h³ bíh¹ tiú²uú² uu³i³tso³ zia³², ca³la³ cun³ jmɨ́¹hi³nio² bíh¹ má²ren² tsú² tso³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","La³ nɨ́² ca³juáh³ Jesús quí¹hliá² tsá² hí³ jmɨ́¹ ná¹juáh²³ hi³ hí³ dí² hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jmɨ́¹ lɨ²¹ jáun² cuan³ mí¹ziú¹³ Jesús la³ má²quionh³ jɨ³ tsá¹ raɨnh²¹ dí² ñí¹ cuá³; tɨ³la³ cheih³² bíh¹ ca³ta³tonh¹ tsú², hi³ jáun² ca³jmú³ tsú² héih³² hi³ téh³ tsú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hi³ jáun² tsá² jmɨ́¹ tionh¹ cu³ jéin³ ñí¹ cuá³ Jesús ca³juáh³: ―Mí²ziúh² hnú² quionh³ tsá¹ renh² nú² tionh² cheih³² nɨ́² hi³ hnauh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Tɨ³la³ Jesús né³, ca³záɨh³ tsá² ná¹ngɨh³² hí³ la³ lá²: ―¿Hin² dá² tsánh² lɨ́n³ mí²zia³² jná¹³ jɨ³ renh² jná¹³ dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jáun² ca³jɨ́en³² dí² tsá² tionh² la³ cu³ la³ jéin³ ñí¹ cuá³ dí² jáun², hi³ jáun² ca³juáh³ dí² la³ lá²: ―Tsá² lá² bíh¹ ná¹lɨ́n³ mí²zia³² jná¹³ jɨ³ jon³ renh² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quí¹ lɨ³ua³ jan² tsá² jmu² la³ cun³ hi³ hnió³ Dió³², tsá² la³ hí³ bíh¹ lɨ́n³ tsá²mɨ³ tsá²ñuh² renh² jná¹³, jɨ³ mí²zia³² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Hi³ jáun² né³, ca³chó³² siáh³ cáun² jmáɨ¹ hi³ ca³ma³liáu³² Jesús hi³ má²tɨn² tsáu² can³² jmáɨ² lɨ́¹ ná¹ho³. Tɨ³la³ juóun³² lɨ́n³² bíh¹ tsáu² ca³cuú² ca³ngɨh³² la³ cu³ la³ jéin³ ñí¹ zenh¹ tsú², hi³ jáun² ca³hi³ tsú² cú²jueh³² cáun² mu² hi³ jmɨ́¹ rón²¹ can³² jmáɨ² lɨ́¹ ná¹ho³ jáun², hi³ jáun² ca³cuá³ dí² tɨ³ ñeh² jáun², hi³ jáun² la³jɨ́n³² tsá² hí³ ca³ta³tonh¹ can³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jmɨ́¹jáun² ca³ma³tɨn² dí² tsáu² hliáun³ ñí¹ lɨ́n²¹ jáɨ¹³ cun³quionh³ jáɨ¹³ hi³ jmu² dí²; hi³ ca³hɨ́eh³ dí² tsú² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Sá¹nɨ́² niéi² náh² jáɨ¹³ hi³ jmu¹ jná¹³ lá²: Jmɨ́¹ zian² jan² tsá² ca³ñí¹suh³² jún² ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tá¹la³ jmɨ́¹ hí¹súh²³ tsú² jáun² jún² né³, la³ ca³súh³² ca³lá² hú¹ juɨ³², hi³ jáun² ca³cua³taunh²¹ quiuh²¹ tan³² hi³ ca³cúh². ");
INSERT INTO csoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ lɨ́³ ja¹ quɨ́n¹, ñí¹ tiá² hliáun³ cuáh¹ jmɨ́¹ tón²¹; hi³ jáun² tia³juɨ³² lɨ́n³² bíh¹ ca³hiá² jún² jáun² quí¹ cun³ñí¹ hi³ tiá² hliáun³ cuáh¹ jmɨ́¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tɨ³la³ jmɨ́¹ cá¹chéi²¹ hiú² né³, ca³lɨ³ quiéin² bíh¹, quí¹ cun³ñí¹ hi³ tiá² ñí¹ ñe¹ jmɨ́¹ tioh³ chí² jmu² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ la³ hiau² ton². Tia³juɨ³² lɨ́n³² bíh¹ ca³quí² cá²cuon³ ton² jáun², hi³ jáun² lɨ́¹ ca³juón³ bíh¹ jún² jáun² jmɨ́¹ ca³hiá², hi³ jáun² cun³ tiú²uú² hi³ ca³láu² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tɨ³la³ la³jɨ́³² jún² ñí¹ hná¹ jáun² né³, ca³súh³² ñí¹ chu²¹ hué³². Ca³hiá² bíh¹ jún² jáun² hi³ ca³cuon³ bíh¹ re², hi³ jáun² re² lɨ́n³² bíh¹ ca³láu²; ma³ cá² máɨ³ jún² jáun² ca³cué³ quiú³quia³ máɨ³ máɨ³, zia³² hi³ jáun² ca³cué³ hnaɨh³² nio² quiú³ máɨ³ la³ cun³ cá² máɨ³ jún², hi³ zia³² siáh³ hi³ jáun² ca³cué³ hña³láu³ máɨ³ la³ cun³ cá² máɨ³ jún² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jmɨ́¹ má²lɨ́²juáh³ jáɨ¹³ nɨ́² Jesús, ca³záɨh³ tsá² hí³: ―Nɨ́¹juáh³ tson² tsɨ²¹ cuáh³ náh², jáun² niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jmɨ́¹ má²lɨ³² jáun² né³, jmɨ́¹ má²cuá¹tón²¹ Jesús hnga², hi³ jáun² tsá² jmɨ́¹ tionh¹ cu³ jéin³ ñí¹ cuá³ tsú² jáun² né³, la³ má²quionh³ tsá² quian³tun³ hí³, ca³ngáɨh³ tsú² Jesús hi³ he³ dá² hnió³ juáh³ jáɨ¹³ hi³ má²lɨ́²jmú³ dí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Hi³ jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Hnoh² bíh¹ tsá² ca³tɨn¹ náh² hi³ lɨ³ ñíh¹³ jáɨ¹³ hi³ jmɨ́¹ ná¹hmá¹ ná¹jnɨ́¹ ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³²; tɨ³la³ tsá² ñí¹ hná¹ nɨ́² né³, jɨ́³²la³ ti³ náɨ³² tsú² cun³quionh³ jáɨ¹³ hi³ jmu² bíh¹ jná¹³; ");
INSERT INTO csoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","hi³ jáun² uá¹jinh¹ jɨ́e³ tsú², cun³ jáun² bíh¹ tá¹tonh¹ tsú² la³jmɨ́¹ lɨ́³ hi³ tiá² hi³ lɨ́²jɨ́e³, hi³ uá¹jinh¹ ne³ tsú², tɨ³la³ cun³ jáun² tiá² ngɨ¹³ yáh³ tsú² siáh³, hi³ jáun² tiá² tɨ́¹ tiá² jeinh²¹ yáh³ jmɨ́¹ tsɨ́³ tsú², hi³ sa³jun³ lɨ́¹³ yáh³ hin³ tso³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ja³bí¹ ca³záɨh³ dí² siáh³ tsá² hí³ la³ lá²: ―¿Hí¹ tiá² ngɨ²³ máh³ hnoh² jáɨ¹³ hi³ má²lɨ́²jmú³² jná¹³ nɨ́²? ¿Ha³ bíh¹ lánh³ rón³² ngɨ¹³ náh² jáɨ¹³ hi³ jmu¹ ná¹ ñí¹ hná¹ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tsá² ngaɨ³² jú¹ chú³² quioh²¹ Dió³² bíh¹ lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá² súh²³ hí³ jún². ");
INSERT INTO csoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma³ jan² tsá² náɨ³² jú¹ chú³² jáun² né³, lɨ́n³ la³jmɨ́¹ lɨ́³ hú¹ juɨ³² ñí¹ cá¹súh²¹ jáun² jún²: náɨ³² bíh¹ tsú² jú¹ chú³², tɨ³ la³ nɨ́¹ má¹lɨ́²niéi³² tsú² jáun² né³, má¹jáun² ja³² Satanás hi³ quin²³ jú¹ chú³² hi³ má²jná¹ jáun² hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Jáun² tsá² he² jáɨ¹³ tia³juɨ³² lɨ́n³² né³, hi³ ca³la³ hi³ hiún² lɨ́n³² tsɨ́³ jmu², tsá² la³ hí³ bíh¹ lɨ́n³ la³jmɨ́¹ lɨ́³ ja¹ quɨ́n¹ ñí¹ cá¹súh²¹ jáun² jún²; tia³juɨ³² lɨ́n³² bíh¹ ca³hiá² jmɨ́¹ ca³hiá², ");
INSERT INTO csoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tɨ³la³ cun³ñí¹ hi³ tiá² hliáun³ chí² jmu² cha²³ yáh³, hi³ jáun² tiá² lɨ³uén²³. Hi³ jáun² dá² lɨ́¹ hliáh² bíh¹ tsɨ́³ tsú² nɨ́¹ má¹ca³lɨ³ zia³² uu³mí²tsɨ³² ho³ nɨ́¹ má¹ca³ma³tso² tsú² tsɨ́³ cun³ñí¹ hi³ ca³tɨ²¹ jú¹ chú³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Hi³ zian² né³ tsá² lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² ñí¹ ca³hiau² ton² ñí¹ cá¹súh²¹ jáun² jún²: náɨ³² tsú² jú¹ chú³² quioh²¹ Dió³², ");
INSERT INTO csoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tɨ³la³ jlánh¹ lɨ́¹ quí² lɨ́¹ cha³² tsú² hliáun³ ñéih³ tsɨ́³ ca³tɨ²¹ hi³ zia³² ñí¹ hué²¹ lá², jɨ³ hi³ lɨ́¹ lɨ́²can² tsú² hi³ lɨ́²hniá¹ tsú² hi³ lɨ́¹³ lɨ³ hánh³, hi³ jáun² chau³² jmáɨ¹ hi³ lɨ́²hniá¹ tsú² hi³ zioh² hi³ hlá² hi³ nɨ́². La³jɨ́³² hi³ jáun² bíh¹ jmu² hi³ tiú²uú² lɨ́² quien² jáɨ¹³ quioh²¹ Dió³² hñu³ tsɨ́³ tsú², hi³ jáun² ñí¹con² tsá² la³ hí³ tiá² hi³ lau³² hí¹ cáun² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tɨ³la³ zian² ma³ jan² tsá² náɨ³² jú¹ chú³² quioh²¹ Dió³², hi³ jáun² he² tsú² re² jáɨ¹³ jáun²; tsá² la³ hí³ bíh¹ lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² chu²¹ ñí¹ cá¹súh²¹ jáun² jún². Hi³ jáun² ñí¹con² tsá² la³ hí³ né³ lau³² re² lɨ́n³² máɨ³, la³jmɨ́¹ lau³² re² lɨ́n³² máɨ³ jún² hi³ ca³súh³² jáun² ñí¹ lɨ́³ hué³² chu²¹. Ma³ jan² tsá² hí³ lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ quiú³quia³ máɨ³ la³ cun³ cá² máɨ³, hi³ ma³ jan² né³ lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ ma³ hnaɨh³² nio² quiú³ máɨ³ la³ cun³ cá² máɨ³, hi³ zian² siáh³ tsá² lɨ́n³ la³jmɨ́¹ lɨ́³ ñí¹ ca³cué³ ca³la³ tɨ³ hña³láu³ máɨ³ la³ cun³ cá² máɨ³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ja³bí¹ ca³záɨh³ tsú² siáh³ tsá² hí³ la³ lá²: ―¿Hí¹ lɨ́¹³ héinh³² tsú² sɨ́² hi³ jáun² zíh³² tsú² ñeh² tsɨ́¹ cuó² ho³lá²dá² ñeh² jen³ juáh¹³? Tiá² jáun² yáh³, chi³cuú² bíh¹ dí²chí³ tsú² sɨ́², ñí¹ lɨ́¹³ taɨ²¹ joh¹ tá¹ cáun² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hí¹ cáun² yáh³ hi³ ná¹hmá¹ tiá² zia³² hi³ juáh¹³ hi³ tiá² lɨ́¹³ jnia³; hi³ hí¹ cáun² yáh³ siáh³ hi³ ná¹hmá¹ ná¹jnɨ́¹ tiá² zia³² hi³ juáh¹³ hi³ tiá² lɨ́¹³ jñéih³. ");
INSERT INTO csoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Hnoh² tsá² tsɨ²¹ cuáh³, niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ja³bí¹ ca³juáh³ siáh³ Jesús ñí¹con² tsá² hí³ la³ lá²: ―Sá¹nɨ́² quián² náh² re² hua³hí¹³ la³ cun³ hi³ naɨh³² náh². Quí¹ la³ cun³ tí³ héih³² hi³ chah³² náh² ca³tɨ²¹ jú¹ tson² hi³ cueh³² náh² tsáu², la³ jáun² bíh¹ cué³² siáh³ Dió³² ñí¹con² hnoh², hi³ tɨ³ hliáun³ bíh¹ jú¹ tson² ñí¹ hná¹ nɨ́² cué³² náh² siáh³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Quí¹ nɨ́¹juáh³ tsá² zia³² quioh²¹, tɨ³ hiáuh³ bíh¹ tsú² hná¹ jáun²; tɨ³la³ nɨ́¹juáh³ tsá² tiá² zia³² quioh²¹ né³, tɨ³ quin³ bíh¹ la³ cun³ cú¹pih²¹ hi³ jmɨ́¹ zia³² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jmɨ́¹ lɨ²¹ jáun² né³ ca³juáh³ siáh³ Jesús: ―Tsá² tónh³² jo³cuo² Dió³² lɨ́n³ la³jmɨ́¹ lɨ́³ jún² hi³ jñi³² jan² tsáu² hué³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jún² jáun² dá² tsá²hi³² hñu³ hué³²; hi³ jáun² uá¹ hi³ rá²cuóun¹ tsú², uá¹ hi³ cuá¹ñí¹ tsú², jún² jáun² cáun² hia³² bíh¹, hi³ cuóun² siáh³, tɨ³la³ tsá² lɨ́²jñí³² né³ tiá² ñi³² yáh³ he³ lánh³ rón³² lɨ́²³. ");
INSERT INTO csoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Cun³ jáun² jmu² hué³² bíh¹ hi³ lɨ́²³ la³ jáun²; la³ñí¹ tín² hia³² ta³, má¹jáun² hia³² ñí¹ tóh²¹ máɨ³ cuú²miih²¹, hi³ cáɨn² jáun² máh³ lɨ́² hán¹ máɨ³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Hi³ jáun² nɨ́¹ má¹ca³lɨ³ quiéin² máɨ³ jáun² né³, jáun² má²tsa³quiaun² bíh¹ tsú², quí¹ má²ca³láu² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ja³bí¹ ca³juáh³ siáh³ Jesús: ―¿He³ yáh³ cun³quionh³ lɨ́¹³ cunh²¹ jná¹³ tsá² tónh³² jo³cuo² Dió³²? ¿He³ dá² jáɨ¹³ lɨ́¹³ jmu¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Quí¹ tsá² tónh³² jo³cuo² Dió³² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cá² máɨ³ mɨ³ mostaza hi³ ca³jñí³ jan² tsáu² hué³² quioh²¹. Máɨ³ jáun² bíh¹ máɨ³ hi³ jlánh¹ bíh¹ pih²¹ la³ cónh³ bíh¹ ñí¹ jɨ³lɨ³² jún² hi³ zia³² hngá¹máh³; ");
INSERT INTO csoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tɨ³la³ nɨ́¹ má¹já²jná¹ jáun² né³, cuóun² hi³ jáun² lɨ́²³ cáun² hmá² hi³ jlánh¹ bíh¹ pa²¹ la³ cónh³ bíh¹ la³jɨ́³² náɨ² má²ró³² ñí¹ hná¹ jáun², hi³ hia³² cuú² ñeh¹, hi³ hí¹ la³ tɨ³ quiuh²¹ tan³² yáh³ lɨ́¹³ na³tsɨ́³ za³ ja¹ hính¹³ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","La³ nɨ́² bíh¹ ca³ma³tɨn² Jesús tsáu² jáɨ¹³ quioh²¹ Dió³² cun³quionh³ hi³ jmu² hliáun³ ñí¹ jáɨ¹³, la³ cun³ hi³ jmɨ́¹ lɨ́¹³ lɨ³ ngɨ¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Hí¹ cáun² yáh³ tiá² hi³ jmɨ́¹ zaɨh³² tsú² tsáu² ta³ tiá² quionh³ cáun² jáɨ¹³ hi³ jmu² tsú²; tɨ³la³ jmɨ́¹ nia³² bíh¹ tsú² la³jɨ́³² jáɨ¹³ jáun² ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con² nɨ́¹ má¹ca³ta³tonh¹ hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Jmɨ́¹ ca³niéi² jáun² né³ ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con²: ―Ma³tsáu¹³ tɨ³ jo²¹ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jáun² né³, ca³chan³ dí² tsá² jmɨ́¹ ná¹ngɨh³² hí³, hi³ jáun² ca³taunh³ tsá² joh¹ dí² hñu³ mu² ñí¹ qui³ jmɨ́¹ má²dí¹hún¹ dí² jáun², hi³ ca³jan³ dí² tsú² hi³ tsa³táunh¹ quionh³; ja³bí¹ jmɨ́¹ hí¹tsá²toh³ siáh³ ma³ cáun² mu² siáh³ siáh³ quionh³ mu² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hú¹ juɨ³² jáun² né³ ja³ chí³ tiá³ lɨ́n³², hi³ ca³la³ má²tsá²ha²¹ bíh¹ jmáɨ² hñu³ mu², hi³ jáun² jmɨ́¹ má²hí¹conh³² bíh¹ jmáɨ² hñu³ mu². ");
INSERT INTO csoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Tɨ³la³ Jesús má¹ná¹, jmɨ́¹ má²rá²cuóun¹ bíh¹ ñí¹ lɨ́³ tɨ³ cu³hna²¹ mu² hi³ cuá¹can¹ cáun² hi³ huá¹; jáun² né³ tsá² tiáunh¹ hí³ hñu³ mu² ca³ñí¹ñi¹³ tsú² hi³ ca³záɨh³ dí² la³ lá²: ―¡Tɨ³², sa³ tiá² hɨ³² máh³ honh² hnú², já² tɨ³ ñeh² bíh¹ má²hí¹tsá²hanh³² dí²! ");
INSERT INTO csoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Hi³ jáun² ca³náu² Jesús hi³ ca³jin³ chí³; hi³ ca³záɨh³ siáh³ jmɨ́²miih²¹ la³ lá²: ―¡Ta³máɨh³! ¡Hnú² jmáɨ², tie³ cuɨ́¹ tá¹ron¹³ nú²! Jmɨ́¹jáun² ca³hná³ chí³, jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ta³no¹ tie³ pih²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jmɨ́¹jáun² né³ ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con²: ―¿He³ láɨh³² jlánh¹ ná¹juenh²¹ náh²? ¿He³ láɨh³² jlánh¹ tiá² cáun² la³ nio² honh² náh²? ");
INSERT INTO csoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jáun² tsá² hí³ ca³ta³ná¹juenh²¹ lɨ́n²¹ bíh¹, hi³ jáun² ca³juu³ ca³hlénh³ ja¹ hmóu³²: ―¿Hin² dá² tsánh² tsá² nɨ́², sa³ la³ jɨ³ chí³ jɨ³ jmɨ́²miih²¹ máh³ taunh² ta²¹? ");
INSERT INTO csoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jáun² ca³cha³táunh¹ bíh¹ tsú² tɨ³ jo²¹ jmáɨ², hué³² quioh²¹ tsá² Gerasa. ");
INSERT INTO csoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","La³ cun³ jmɨ́¹ cuá¹han³ Jesús hñu³ mu² ja³ jan² tsá²ñuh², tsá² jmɨ́¹ cuá³ ñéih³ jéin³lo¹ hi³ táun³ ñí¹ ná¹hón²¹ hla¹, hi³ cuan³ ñí¹ zenh¹ Jesús; tsá² hí³ jmɨ́¹ tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tsá²ñuh² hí³ dá² jmɨ́¹ má²cuá³ bíh¹ ñí¹ táun³ jéin³lo¹ ñí¹ ná¹hón²¹ hla¹, hí¹ jan² yáh³ tiá² hin² jmɨ́¹ tióh³² hi³ hñe³ tsá² hí³ uá¹jinh¹ quionh³ cá²den¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Hliáun³ jéin³² lɨ́n³² bíh¹ jmɨ́¹ má²ca³hñéi³² tsú² cuá² ta³ tsá² hí³ cun³quionh³ hñe¹³ jɨ³ cá²den¹ná¹, tɨ³la³ tiú²nio² bíh¹ jmɨ́¹ caɨ³² tsú² hi³ jmu² juoh¹ mí¹ siún¹ nio², hí¹ jan² yáh³ tiá² hin² jmɨ́¹ tióh³². ");
INSERT INTO csoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","La³jɨ́³² jmáɨ¹ bíh¹ jmɨ́¹ ngɨ³² tsú² la³ huá² la³ jma², hi³ ñi³tɨ́¹ ñi³hóh²¹ ñí¹ lɨ́³ tsɨ³ máh³ jɨ³ ja¹ ñí¹ ná¹hón²¹ hla¹ nɨ́² siáh³, hi³ jmɨ́¹ quí² jmɨ́¹ jñei³² quɨ́n¹ quioh²¹ hnga² ca³la³ ca³cuɨ́h³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tɨ³la³ jmɨ́¹ ca³jɨ́en³² tsú² Jesús hi³ zenh² ñí¹ uóunh³, jáun² ngau³ cú²hé² lɨ́n³² hi³ ca³ñí¹di³jñí³² ta³ ñí¹ Jesús, ");
INSERT INTO csoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","hi³ jáun² ca³la³ má²hóh³² tiá³ ca³juáh³: ―¿He³ ca³tɨn¹ hnú² quiúnh¹ jná¹³, hnú² Jesús Jon² Dió³² Tsá² cú² juenh²? Ca³la³ jɨ́e²³ Dió³², ¡ha³ lɨ́² jmú² hian² honh² ñí¹con² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","La³ nɨ́² ca³juáh³ tsá² hí³ quí¹hliá² Jesús má²dí¹jmu² héih³², hi³ juáh³ la³ lá²: ―¡Hnú² jmɨ́²chí³ hláɨnh¹, tun³² tsá² nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jáun² Jesús ca³ngáɨ³ ñí¹con² tsá² hí³: ―¿Ha³ lánh³ jmáɨ² hnú²? Jáun² tsá² hí³ ca³ngáɨ³: ―Cu³ Nió³ bíh¹ jmáɨ² jná¹³, quí¹ juóu³² bíh¹ jnoh¹ ná¹láɨ³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ jlánh¹ ca³hiu³ ca³mɨ́³ lɨ́n³² ñí¹con² Jesús hi³ tiá² ze³ tsú² ñí¹ uóunh³ lɨ́n³² la³ cun³ hué³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tsoh² máh³ zeh² có³² jáun² né³, jmɨ́¹ tiáunh¹ juóun³² mí²ñí³ hi³ ná¹cúh² háu². ");
INSERT INTO csoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jáun² jmɨ́²chí³ hláɨnh¹ hí³ né³, ca³hiu³ ca³mɨ́³ hi³ ca³juáh³ la³ lá²: ―Ze² tiá³ jnoh¹ ñí¹ tiáunh¹ mí²ñí³ ó³²; cué¹ jáɨ¹³ hi³ tsá¹tauh²¹ jnoh¹ hñu³ tsɨ́³ jáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jáun² ca³cué³ bíh¹ Jesús jáɨ¹³. Hi³ jáun² jmɨ́¹jáun² ca³huén² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsá² hí³, hi³ jáun² ca³ñí¹tiónh²¹ hñu³ tsɨ́³ mí²ñí³ hí³. Cun³ tun³ mei²¹ mí²ñí³ hí³ jmɨ́¹ tín³. Jáun² la³jɨ́n³² mí²ñí³ hí³ ca³cuóun³ cú²hé² lɨ́n³² tɨ³ ñí¹ dí¹jɨ²³ ñí¹ hlaɨh³ lɨ́n²¹, jáun² ca³sunh³ chu³ jmáɨ², hi³ jáun² ca³hnúh³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jáun² tsá² jmɨ́¹ ná¹jmu² hua³hí¹³ mí²ñí³ hí³ ca³cuóun³, hi³ ca³ñí¹chá² já¹ juú² jɨ³ ñí¹ náɨ². Hi³ jáun² cua³taunh²¹ tsá² juú² hi³ cua³jɨ́e³ tsú² nɨ́¹juáh³ he³ dá² má²lɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jmɨ́¹ cuá¹taunh²¹ tsú² ñí¹ zenh¹ jáun² Jesús né³, ca³jɨ́en³² tsú² tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ hi³ má²cuá¹tón²¹ hi³ má²quih³² ha¹, hi³ má²chun¹, ha³ tiú²uú² ngo² yáh³. Hi³ jáun² tsá² ca³cha³táunh¹ hí³ né³, ca³juénh² lɨ́n³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jáun² tsá² ca³jɨ́e³ hí³ la³ cun³ hi³ má²lɨ³² jáun² ñí¹con² tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ né³, ca³chá³ ñí¹con² tsá² cuá²taunh²¹ hí³, hi³ ca³chá³ tsú² siáh³ la³ cun³ hi³ lɨ³ jáun² ñí¹con² mí²ñí³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jmɨ́¹jáun² ca³ma³liáu³² tsá² hí³ hi³ ca³hiu³ ca³mɨ́³ ñí¹con² Jesús hi³ cua³haɨn³² tsú² hué³² jáun² quioh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jmɨ́¹ tɨ³ ñí¹ hí³ siáh³ Jesús hñu³ mu², jáun² tsá²ñuh² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ ca³hiu³ ca³mɨ́³ ñí¹con² Jesús hi³ tsó³² dí² quionh³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Tɨ³la³ Jesús tiá² jáɨ¹³ ca³cué³ yáh³, la³ lá² bíh¹ ca³juáh³: ―Cuánh² hñuh³² ñí¹ tionh¹ jon³ renh² nú², cuá²chá¹ la³jɨ́³² la³ cun³ hi³ má²lɨ́²jmú³ Dió³² ñí¹con² nú², jɨ³ hi³ ha³ lánh³ rón³² ca³ja³ mií³ tsɨ́³ tsú² ñí¹con² nú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jáun² ngah³ bíh¹ tsá²ñuh² hí³, hi³ ca³ma³liáu³² cha³² ñí¹con² tsá² zian² tá¹ quia³ juú² míh¹ tiá² ná¹cunh² jáun² la³jɨ́³² la³ cun³ hi³ má²lɨ́²jmú³ jáun² Jesús ñí¹con² tsú²; hi³ jáun² lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ la³jɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jmɨ́¹ cá¹chánh²¹ siáh³ Jesús jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun², ñí¹ zenh¹ tsú² jáun² ca³cha³táunh¹ juóun³² lɨ́n³² tsáu², hi³ jáun² ca³ta³zanh¹ bíh¹ tsú² can³² jmáɨ² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jmɨ́¹jáun² ca³chó³² jan² tsá² chín¹ cáun² cuáh³² quioh²¹ tsá² *judíos, tsá² hí³ jmɨ́¹ jmáɨ² Jairo. Jmɨ́¹ ca³jɨ́en³² tsú² Jesús, jáun² ca³di³jñí³² hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³² ta³ ñí¹ tsú², ");
INSERT INTO csoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","hi³ jáun² ca³hiu³ ca³mɨ́³ lɨ́n³² dí² ñí¹con² tsú², hi³ ca³záɨh³ dí² la³ lá²: ―Mɨ́¹míh¹ jón³² jná¹³ má²ñí¹jún³, ña³² tiá³ hñu³² jná¹³, ñá²ra³tsɨ³² cuonh² ñí¹ quioh²¹ tsú² hi³ jáun² lán¹³ hi³ tiá² jún³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jáun² Jesús ngau³ quionh³ tsá² hí³; tɨ³la³ juóun³² lɨ́n³² bíh¹ tsáu² ja³taunh²¹ cu³chin¹ cu³hna²¹ tsú² ca³la³ má²chí¹cuú² chí¹jaɨn³² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ja¹ tsá² hí³ né³ jmɨ́¹ cuá¹tsau³² jan² tsá²mɨ³ tsáun¹, quia³tún³ mii² jmɨ́¹ má²tí³ hi³ zian² tsú² jmɨ́²hán¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jmɨ́¹ má²ca³ma³tso² lɨ́n³² bíh¹ tsú² tsɨ́³ hi³ má²ñéi¹ hliáun³ hñú¹³ tɨ³² mɨ́³, jáun² jɨ³lɨ³² bíh¹ hi³ jmɨ́¹ zia³² quioh²¹ tsú² jmɨ́¹ má²cá²tsá³²; tɨ³la³ cha³ jmɨ́¹ jmu³ ta²¹ hi³ jáun², tɨ³ lɨ³mí¹ jmɨ́¹ má²cá²já³² bíh¹ mɨ́¹uɨ́³ hi³ zian² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jmɨ́¹ ca³náɨ³² tsá²mɨ³ hí³ jáɨ¹³ hi³ cha³² tsáu² hi³ ca³tɨn¹ Jesús, jáun² hi³ dí² ja¹ tsáu² hi³ ngau³ má²janh² tɨ³ cu³hna²¹ Jesús, jáun² ca³tí³ dí² cuo² zéi¹ ha¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Quí¹ ca³lɨ́n¹³ tsú² hñu³ tsɨ́³ la³ lá²: “Cun³ lán¹³ bíh¹ jná¹³ uá¹jinh¹ cun³ ti³ hlieih²¹ jná¹³ uón³² cú¹pih²¹ zéi¹ ha¹ bíh¹ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³hná³ jmɨ́²hán¹ tsú²; jmɨ́¹jáun² ca³lɨ³lieih²¹ tsú² hi³ má²cá²hin³ bíh¹ mɨ́¹uɨ́³ hi³ jmɨ́¹ zian². ");
INSERT INTO csoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jáun² jmɨ́¹jáun² ca³lɨ³lieih²¹ uá²jaɨ³² Jesús hi³ má²laɨn³² jan² tsáu² cun³quionh³ pí³ quioh²¹ dí²; jáun² ca³jinh³ dí² tɨ³ cu³hna²¹ ja¹ ñí¹ hí¹já²táunh¹ jáun² tsáu², hi³ ca³juáh³: ―¿Hin² tsánh² lɨ́²tí³ cuo² hán² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³juáh³ la³ lá²: ―Já² nɨ́² bíh¹ jɨ́eh³² nú² ca³la³ hi³ cuú² jáɨ³² bíh¹ tsáu², ¡sa³ ngaɨh³² ma³ nú² hi³ hin² tsánh² lɨ́²tie³ cuo²! ");
INSERT INTO csoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Tɨ³la³ Jesús né³, la³ má²jɨ́e²³ jáun² bíh¹ tɨ³ hlá² tɨ³ nɨ́² hi³ hnah² nɨ́¹juáh³ hin² dá² tsánh² lɨ́²tie³ dí² cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Tɨ³la³ cun³ñí¹ hi³ ñi³² tsá²mɨ³ he³ má²lɨ³² ñí¹con² né³, jáun² ngau³ ca³la³ má²juán²³ hi³ má²juénh² hi³ ca³ñí¹di³jñí³² hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³² ta³ ñí¹ Jesús, hi³ ca³chá³ la³jɨ́³² jú¹ tson². ");
INSERT INTO csoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jáun² Jesús ca³záɨh³ tsá²mɨ³ hí³: ―Hnú² jón³, má²laɨn³² hnú² quí¹ cun³ñí¹ hi³ lɨ́²cháh¹ nú² cáun² honh². Cuánh² cáun² hi³ re² hi³ tɨn², jɨ³ hi³ cuɨ́¹ chun¹ nú² la³ má²chun¹ nú² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² Jesús cua³taunh²¹ tsá² hñú¹³ Jairo, tsá² chín¹ hí³ cuáh³² quioh²¹ tsá² judíos, jáun² ca³záɨh³ dí² Jairo la³ lá²: ―Má²jun² bíh¹ mɨ́¹míh¹ jónh²¹ hnú²; ¿he³ láɨh³² ma³tsan¹³í¹ máh³ hnú² tsɨ́³ Tɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tɨ³la³ Jesús má¹ná¹, hí¹juáh³ tiá² ca³ma³jáun² bíh¹ la³ cun³ hi³ juáh³ jáun² tsá² hí³, jáun² ca³záɨh³ dí² tsá² chín¹ hí³ cuáh³²: ―Ha³ lɨ́² juenh³, ñí¹ jɨ́²¹la³ chá¹ hnú² cáun² honh² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jmɨ́¹jáun² tiú²uú² ca³cué³ yáh³ tsú² jáɨ¹³ hi³ tsa³táunh¹ tsá² siánh³ quionh³, jɨ́³²la³ Pé¹, Jacobo jɨ³ Juan² raɨnh²¹ Jacobo bíh¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jmɨ́¹ ca³cha³táunh¹ tsú² hñú¹³ tsá² chín¹ hí³ cuáh³² né³, ca³jɨ́e³ tsú² hi³ má²nio² tiá³ siaun³² lɨ́n³² hi³ ná¹tɨ́² ná¹hóh³² tsáu² hi³ hó² jngɨh². ");
INSERT INTO csoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jáun² ca³hi³ Jesús, hi³ ca³juáh³: ―¿He³ láɨh³² lɨ́¹ tiáunh¹ tiá³ siaun³² lɨ́n³² hnoh² jɨ³ hi³ ná¹uoh³² náh² siáh³? Mɨ́¹míh¹ nɨ́² tiá² rá²jún¹ yáh³, quí¹ rá²cuóun¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Tɨ³la³ tsá² hí³ má¹ná¹, cáun² lɨ́¹ ca³jú² ca³ngáɨ³² bíh¹ Jesús. Jáun² Jesús ca³jmú³ héih³² hi³ huén³² tsú² la³jɨ́n³², jɨ́³²la³ jméi² jɨ³ mí¹ziú¹³ bíh¹ mɨ́¹míh¹ ca³jan³ tsú², jɨ³ tsá² gáun³ jmɨ́¹ quionh³ tsú² hí³ bíh¹, hi³ jáun² taunh³ ñéih³ ñí¹ rón²¹ jáun² mɨ́¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jáun² ca³zanh³ dí² cuo² hla¹ mɨ́¹míh¹ hí³, hi³ ca³záɨh³ dí² la³ lá²: ―Talita, cum. (Hi³ hnió³ juáh³ “Mɨ́¹míh¹, hnú² juo³ jná¹³, náu²”). ");
INSERT INTO csoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","La³ cun³ jmɨ́¹jáun² bíh¹ ca³náu² mɨ́¹míh¹ hí³, hi³ ca³ngɨ́³. Mɨ́¹míh¹ hí³ jmɨ́¹ má²hún¹ quia³tún³ mii². Hi³ jáun² tsá² tionh² hí³ lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tɨ³la³ Jesús né³, ca³jmú³ héih³² chí¹tson³ hi³ hí¹ jan² yáh³ tiá² hin² hniáuh³² záɨh³² tsú² la³ cun³ hi³ má²lɨ³² jáun², hi³ jáun² ca³jmú³ dí² siáh³ héih³² hi³ ma³ton³ tsú² mɨ́¹míh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús ñí¹ jáun² hi³ ngah³ tɨ³ juú²co¹ quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jmɨ́¹ cá¹chó²¹ *jmáɨ¹ nio² tie³, jmɨ́¹jáun² ca³ma³liáu³² Jesús hi³ hɨeh³² tsáu² hñu³ cuáh³² quioh²¹ tsá² *judíos zeh² já¹ juú² jáun². Jáun² la³jɨ́n³² tsá² ca³náɨ³² né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ hi³ ca³juónh³ tsá²ján² tsá²ján²: ―¿Ha³ dá² jinh¹ ca³ñí¹ma³tɨn³² tsá²ñuh² nɨ́² la³jɨ́³² jáɨ¹³ nɨ́²? ¿Ha³ dá² jinh¹ hiauh³ tsá² nɨ́² hi³ jlánh¹ quiáh¹ nɨ́² jmɨ́¹tsɨ́³. Ha³ bí¹ lánh³ rón³² tɨn² tsú² siáh³ jmu² hua³jueh³²? ");
INSERT INTO csoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Já² tɨ³² hmá² jon² Má²réi³ bíh¹ nɨ³², lá² bíh¹ tionh² tsá¹ dá¹jon²¹ tsú²: Jacobo, Sé³², Judas jɨ³ Sí¹mu²¹ nɨ́² siáh³, hi³ tsá²mɨ³ dá¹jon²¹ tsú² né³ tionh² bíh¹ já¹ juú² lá² quiúnh¹ dí². Hi³ jáun² tiá² ca³quiú¹ ca³jéin¹³ dí² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―Jɨ́³²la³ ja¹ quioh²¹ tsá²co¹ jɨ³ ja¹ quioh²¹ tsá² jún¹ tsá² raɨnh²¹ bíh¹ jan² tɨ³² jë¹ Dió³² tiá² lɨ́²quien². ");
INSERT INTO csoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tiá² lin¹ nga³ hua³jueh³² ca³lɨ³ yáh³ jmu³ tsú² ñí¹ jáun², ñí¹ jɨ́²¹la³ ti³ ca³jmah³ tsú² gon³ gáun³ tsá² tsáun¹ bíh¹ hi³ ca³ra³tsɨ³² dí² cuo² ñí¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hi³ lɨ́¹ jmɨ́¹ dí¹tsá²cáun² bíh¹ tsɨ́³ tsú² quí¹hliá² tiá² ta²¹ jmɨ́¹ ná¹taunh² yáh³ tsá² hí³. Jmɨ́¹ lɨ²¹ jáun² né³, ca³tɨ³ ca³ngɨ́³ Jesús la³jɨ́³² juú² míh¹ juú² siún¹ hi³ má²tɨn² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jáun² jmɨ́¹jáun² ca³teh³ tsú² tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² ca³ma³liáu³² dí² hi³ ca³zen³ dí² ma³ quin³² ma³ gon³ tsáu², hi³ jáun² ca³cuéh³ dí² pí³ hi³ lɨ́¹³ huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jáun² ca³jmú³ dí² héih³² hi³ tiá² hi³ cán³ tsú² hí¹ cáun² hi³ hniáuh³² hú¹ juɨ³², jɨ́³²la³ hmá²hu²¹ bíh¹. Sa³jun³ ca³cué³ yáh³ dí² jáɨ¹³ hi³ cán³ tsú² tuh³², sa³jun³ má³², sa³jun³ quɨe³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jɨ́³²la³ chí² láu² bíh¹ hniáuh³² ra³tsɨ³² tsú² ta³, tɨ³la³ tiá² cán³ yáh³ tsú² tun³ ha¹, jɨ́³²la³ cáun² hi³ má²quih³² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Hi³ ca³záɨh³ dí² siáh³ la³ lá²: ―Lɨ³ua³ cáun² hñú³ ñí¹ ca³he³ tsú² hnoh² re² tɨn², tianh³ náh² ñí¹ jáun² ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ huen¹³ náh² juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nɨ́¹juáh³ ca³cha³táunh¹ náh² ñí¹ tiá² hnió³ tsú² he³ náh², hi³ sa³jun³ hnió³ tsú² ne³ jáɨ¹³, cu³tsa³² huen³ náh² cú²jueh³² juú² la³ jáun², hi³ súh³ náh² hliáu² quian²¹ tanh¹ ñí¹ jáun², hi³ jáun² la³ jáun² lɨ³ lin¹ hi³ tiá² ca³quiú¹ ca³jéi¹³ náh² tsú². Jú¹ tson² juanh³² jná¹³, hi³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ ra³tsɨ³² Dió³² héih³², tɨ³ pih²¹ bíh¹ ca³lá² ma³tso² tsá² jmɨ́¹ zian² juú² Sodoma jɨ³ Gomorra tsɨ́³ la³ cónh³ bíh¹ tsá² juú² ñí¹ tiá² he³ tsú² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jáun² jmɨ́¹jáun² já¹taunh²¹ tsá² hí³ hi³ hleh³² jáɨ¹³ hi³ ca³tɨ²¹ hi³ záɨ³² tsáu² jmɨ́¹ tsɨ́³, ");
INSERT INTO csoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","hi³ ca³huen³ tsú² juóun³² lɨ́n³² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², hi³ juóun³² siáh³ tsá² tsáun¹ ca³jñéi³² tsú² jmɨ́² no¹ hi³ jáun² lan³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hi³ jáun² la³jɨ́³² hi³ jáun² ca³lɨ³ ñi³² re²¹ Herodes, quí¹hliá² ja³ngɨ³ jáɨ¹³ hi³ ca³tɨn¹ Jesús la³ tán¹. ―La³ má²ca³jenh¹³ bíh¹ hla¹ Juan² tsá² tɨ́² ziau² hí³ jmáɨ² ―ca³juáh³ tsú²―, hi³ jáun² bíh¹ zia³² pí³ jáun² quioh²¹ tsú² hi³ jmu² hua³jueh³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hi³ ma³ jan² siáh³ tsáu² ca³juáh³: ―Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² bíh¹ hí³. Hi³ ma³ jan² siáh³ tsá² juáh³: ―Já¹ tɨ³² jë¹ Dió³² bíh¹ hí³, tsá² la³ tɨ³² jë¹ Dió³² tsá² jmɨ́¹ zian² cá²jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jmɨ́¹ ca³náɨ³² jáun² Herodes jáɨ¹³ nɨ́², ca³juáh³: ―Já¹ Juan² tsá² tɨ́² zion² tsáu² jmáɨ² bíh¹ nɨ³², tsá² cá²jmú³² jná¹³ héih³² hi³ tsa³quiéih³ tsú² cun³ ngá¹³ mí¹táɨ³ láɨ¹, hi³ né³² né³ la³ má²ca³jenh¹³ bíh¹ tsú² ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Hliá² Herodes bíh¹ ca³jmú³ héih³² hi³ ma³tson¹³ tsú² Juan², hi³ jáun² ca³hñéi³² tsú² quionh³ cá²den¹ná¹ ñéih³ hñu³mí¹ñí² cun³ñí¹ hi³ tsáu¹³ tsá²mɨ³ Herodías. Ñí²cuo² Pí²liéi¹ raɨnh²¹ bíh¹ Herodes tsá²mɨ³ Herodías hí³, tɨ³la³ Herodes má¹ná¹, jmɨ́¹ má²ca³can³ hi³ ca³jéinh³² cuo² quionh³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hi³ jáun² Juan² né³, jmɨ́¹ má²ca³juáh³ hiú² cuóh³² ñí¹con² Herodes: “¡Tiá² ca³tɨn¹ yáh³ hnú² hi³ ján³ nú² ñí²cuo² renh²!” ");
INSERT INTO csoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Cun³ñí¹ hi³ jáun² jmɨ́¹ hon² tsá²mɨ³ Herodías hí³ Juan², hi³ jáun² jmɨ́¹ hnió³ dí² jngɨh³; tɨ³la³ tiá² jmɨ́¹ lɨ́²³ yáh³, ");
INSERT INTO csoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","quí¹ Herodes jmɨ́¹ ñi³² hi³ Juan² hí³ bíh¹ jan² tsá² chun¹, jan² tsá² cuá¹chan¹ ñí¹con² Dió³², hi³ jáun² jmɨ́¹ juénh² dí² tsú². Hi³ jáun² bíh¹ tiá² jmɨ́¹ cue³² tsú² jáɨ¹³ hi³ jmu³ tsá²mɨ³ hí³ hian² tsɨ́³. Hi³ uá¹jinh¹ jmɨ́¹ tá²zanh¹ Herodes hi³ lɨ́¹ tiá² ñi³² lánh³ jmu³ nɨ́¹ má¹ca³náɨ³² la³ cun³ hi³ jmɨ́¹ zaɨ³² Juan², cun³ jáun² jmɨ́¹ hnió³ bíh¹ tsú² ne³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tɨ³la³ tsá²mɨ³ Herodías né³, ca³choh¹³ bíh¹ he³ lánh³ rón³² jmu³ jmɨ́¹ ca³jmú³ jáun² Herodes jmáɨ¹ hi³ ca³tsɨn¹³ mieh², hi³ ca³cué³ má³² chu²¹ lɨ́n²¹ ñí¹con² la³jɨ́n³² tsá² ná¹chín¹ joh¹, jɨ³ ñí¹con² juo¹³ hliáu³, jɨ³ la³jɨ́n³² tsá² ná¹quien² hué¹³ Galilea nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Jáun² jmɨ́¹jáun² ca³hi³ tsá¹máɨ¹³ jon² tsá²mɨ³ Herodías hí³ ñí¹ ná¹cúh² tsú² jáun² hi³ ca³tsan³²; jáun² ca³zaɨn²¹ lɨ́n²¹ bíh¹ re²¹ Herodes la³ má²quionh³ la³jɨ́n³² tsá² ná¹tén¹ hí³ hi³ ca³tsan³² mɨ́¹ hí³. Hi³ jáun² ca³záɨh³ re²¹ tsá¹máɨ¹³ hí³ la³ lá²: ―Mɨ́¹ ñí¹con² jná¹³ la³ cun³ hi³ hnáuh², hi³ jáun² jná¹³ cué¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Hi³ jáun² ca³jmú³ dí² jáɨ¹³ ca³la³ hi³ hɨen² Dió³² hi³ tson² bíh¹ cu³tí³ cué³² dí² lɨ³ua³ cáun² hi³ mɨ́³² tsá¹máɨ¹³ hí³, uá¹jinh¹ tá¹ cá²tso¹³ hué³² ñí¹ hu²¹ cuo² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jáun² mɨ́¹ hí³ né³ cua³han³, hi³ ca³ñí¹zeh¹ mí¹ziú¹³: ―¿He³ dá² ñí¹mɨ́³ jná¹³ ñí¹con² tsú²? Jáun² mí¹ziú¹³ tsú² ca³juáh³: ―Mɨ³chí¹ Juan² tsá² ziau² hí³ jmáɨ² cuá²mɨ́¹. ");
INSERT INTO csoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Jáun² mɨ́¹ hí³ né³, la³juɨ³² ca³hi³ siáh³ ñí¹ cuá³ re²¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Mɨ³chí¹ Juan² tsá² zion² tsáu² jmáɨ² bíh¹ hnó³² jná¹³ hi³ cuéh¹ hnú² ta³né³², hi³ ná¹hu²¹ hñu³ uon². ");
INSERT INTO csoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ca³la³ hlaɨh³ lɨ́n²¹ bíh¹ ca³ta³no¹ tsɨ́³ re²¹; tɨ³la³ Dió³² yáh³ má²lɨ́²hɨen³ tsú², hi³ hí¹ ca³la³ tɨ³ tsá² ná¹tén¹ yáh³ má²lɨ́²niéi³² jáɨ¹³ jáun², jáun² tiú²uú² lɨ³ yáh³ hi³ jmu³ tsú² huáh² chí¹ hi³ tiá² cué³² la³ cun³ hi³ mɨ³² tsá²mɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","La³ cun³ jmɨ́¹jáun² ca³zen³ re²¹ jan² hliáu³, hi³ ca³jmú³ dí² héih³² hi³ tsa³quiéih³ tsú² láɨ¹ Juan² hñu³mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jáun² ñéi¹ hliáu³ hñu³mí¹ñí² hi³ ca³ñí¹quiéih¹³ láɨ¹ Juan², jáun² quiaun² dí² hi³ ná¹hu²¹ hñu³ uon². Jáun² ca³cuéh³ tsú² tsá¹máɨ¹³ hí³, hi³ jáun² tsá¹máɨ¹³ hí³ né³ ca³ñí¹jɨenh¹³ siáh³ mí¹ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jmɨ́¹ ca³lɨ³ ñi³² tsá² haɨn²¹ hí³ tɨ³ con² Juan², jáun² ja³taunh²¹ hi³ ca³ñí¹quión²¹ hla¹, hi³ jáun² ca³ñí¹hón²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jmɨ́¹ cá¹jính²¹ jáun² *tɨ³² tsá² quian³² hí³ jë¹ Dió³² ñí¹con² Jesús, jáun² ca³chá³ tsú² jɨ³lɨ³² la³ cun³ hi³ ca³jmú³, jɨ³ la³ cun³ hi³ ca³hɨ́eh³ dí² tsáu² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jáun² Jesús ca³juáh³: ―Ñá²táunh¹ náh², ma³tauh¹³ dí² cu³tiá³ tie³ ñí¹ cú² hnga². Quí¹ juóun³² lɨ́n³² bíh¹ tsáu² jmɨ́¹ ja³tú¹ ja³lɨn²³, hi³ hí¹juáh³ tiá² jmáɨ¹ cue³² bíh¹ quioh²¹ tsú² hi³ cuh³ má³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jmɨ́¹jáun² ca³hi³ Jesús cáun² mu² la³ má²quionh³ jáun² tsá² quian³tun³ hí³ joh¹ hi³ ja³taunh²¹ tsú² hmóu³² ñí¹ má²tɨ³ có³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tɨ³la³ juóun³² bíh¹ tsáu² ca³jɨ́e³ jmɨ́¹ já¹taunh²¹ tsú², hi³ jáun² ca³lɨ³tsɨn² tsá² hí³ hi³ hí³ bíh¹ Jesús; hi³ jáun² tsá² hí³ jɨ³ tsá² zian² juú² la³ cu³ la³ jéin³ jáun² ja³taunh²¹ cú²hé² lɨ́n³² juɨ³² ta³, hi³ jáun² ta³ tin² bíh¹ ca³cha³táunh¹ tsú² ñí¹ jáun² la³ cónh³ bíh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cua³han³ bíh¹ Jesús hñu³ mu² jmɨ́¹ cuá¹han³, tɨ³la³ jmɨ́¹ ca³jɨ́e³ tsú² hi³ sa³ juóun³² lɨ́n³² bíh¹ tsáu² má²tionh² ñí¹ jáun², hi³ jáun² ca³ja³ mií³ tsɨ́³ dí² ñí¹con² tsá² hí³, quí¹hliá² la³jmɨ́¹ tionh¹ *já¹ziáh² tiá² juo¹³ zian² bíh¹ jmɨ́¹ tionh¹ tsá² hí³; hi³ jáun² ca³ma³liáu³² dí² cú²jueh³² hi³ má²tɨn² tsá² hí³ hliáun³ ñí¹ jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jmɨ́¹ má²ca³hláu³ jáun² né³, ca³ma³janh³² tsá² haɨn²¹ tɨ³ con² tsú² ñí¹ zenh¹ hi³ ca³juáh³ la³ lá²: ―Já² má²ca³hláu³ bíh¹ la³², hi³ hí¹ jan² yáh³ tiá² hin² zian² ñí¹ má²janh² lá². ");
INSERT INTO csoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jáun² chú³² juoh¹ hnú² tsá² nɨ́² hi³ tsa³tánh¹, cuɨ́¹ cha³táunh¹ juú² pih²¹ jɨ³ ñí¹náɨ² ñí¹ táun³ hñú³, hi³ cuɨ́¹ cha³lia³² tsú² má³² hi³ cuh³, quí¹ ñí¹ tiauh¹ dí² lá² tiá² zia³² yáh³ hi³ lɨ³ cúh¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tɨ³la³ Jesús ca³juáh³ ñí¹con² tsú²: ―Hnoh² bíh¹ hniáuh³² cueh¹ tsú² hi³ cuh³. Jáun² né³, tsá² hí³ ca³ngáɨ³ siáh³: ―¿Jinh¹ dá² tsá¹cán¹³ jnoh¹ hí³ cuú²miih²¹ hi³ cue¹³ jnoh¹ tsá² nɨ́² cuh³? Quí¹ cun³ tun³ nio² hña³láu³ máh³ *cú¹tiáu² lɨ³ hniáuh³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jáun² Jesús ca³ngáɨ³: ―¿Cónh³ bíh¹ hí³ cuú²miih²¹ zia³² quián¹³ hnoh² dúh¹? Cuá²jɨe³ dú¹ neh²¹. Jmɨ́¹ má²lɨ́²jɨ́e³ tsú² jáun² né³, ca³juáh³: ―Hñá³ *hí³ cuú²miih²¹ quionh³ gon³ hma²¹ bíh¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jáun² Jesús ca³jmú³ héih³² hi³ tiánh³² tsú² ma³ cu³ nió³ hué³² ja¹ mí¹ñéi² réh²; ");
INSERT INTO csoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","jáun² ma³ hña³láun³ jɨ³ ma³ tu³la³quian³ tsáu² ca³tiánh³ ma³ quin³² ma³ cu³ nió³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jmɨ́¹jáun² ca³can³ Jesús tá¹ hñá³ hí³ cuú²miih²¹ jáun² jɨ³ tá¹ gon³ hma²¹ nɨ́² siáh³, jáun² ca³jɨ́e³ tsú² tɨ³ hñu³mɨ³cuú² hi³ ca³cuéh³ tiá¹hmah¹ Dió³², jmɨ́¹jáun² ca³ca³ tsú² hí³, jáun² ca³cuéh³ dí² tsá² haɨn²¹ hí³ tɨ³ con² hi³ tsóh³ ñí¹con² tsá² tionh² hí³. Ja³bí¹ ca³tsóh³ tsú² siáh³ quioh²¹ hma²¹ hí³ ñí¹con² la³jɨ́n³² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jáun² la³jɨ́n³² bíh¹ tsá² hí³ lah³ re² má³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jmɨ́¹ lɨ²¹ jáun² ca³jieh³ tsú² la³jɨ́³² chí² juoh¹ hí³, jɨ³ quioh²¹ hma²¹ hi³ ziau³ jáun² nɨ́² siáh³, jáun² chí² juoh¹ jáun² né³ ca³cónh³² quia³tún³ mɨ́²tá². ");
INSERT INTO csoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","La³ cun³ tsá² ca³cúh² hí³ cuú²miih²¹ jáun², jmɨ́¹ tín³ hñá³ mei²¹ jmáh³la³ tsá²ñuh². ");
INSERT INTO csoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jmɨ́¹ lɨ²¹ jáun² né³, ca³jmú³ Jesús héih³² hi³ tónh³² tsá² haɨn²¹ hí³ tɨ³ con² hñu³ mu² hi³ hán³² tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ ta³ tin², hi³ tsa³táunh¹ tsú² juú² Betsaida tá¹la³ dí¹hah² dí² jáun² jáɨ¹³ ñí¹con² tsá² ná¹ngɨh³² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jmɨ́¹ má²lɨ́²heh² tsú² jáun² jáɨ¹³ quionh³ tsá² tionh² hí³ né³, ngau³ tsɨ³ máh³ hi³ ca³ñí¹lienh¹³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Jmɨ́¹ ca³niéi² jáun² né³, mu² jáun² jmɨ́¹ má²he² ñí¹ chu³jo² jmáɨ², jáun² hnga² bíh¹ jéi³²í¹ Jesús jmɨ́¹ zenh¹ ñí¹ quiéin². ");
INSERT INTO csoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jmɨ́¹jáun² ca³jɨ́e³ dí² hi³ zia³² uu³mí²tsɨ³² ñí¹con² tsá² hí³ joh¹ hi³ tiú²uú² re² lɨ́²³ juóh³ tsú² jmáɨ², quí¹hliá² jmɨ́¹ ja³² chí³ tɨ³ juɨ³² ñí¹ hí¹tsá²táunh¹ tsú² jáun². Jmɨ́¹ má²já²jnia² jáun² né³, ngau³ Jesús juɨ³² ñí¹ hí¹tsá²táunh¹ tsú² jáun², hi³ chí¹ngɨ³² ñí¹ jmáɨ², tɨ³la³ Jesús cáun² lɨ́¹ jmɨ́¹ má²ngá¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jmɨ́¹ ca³jɨ́e³ tsá² tiáunh¹ hí³ hñu³ mu² hi³ cuá¹ngɨ³² jan² tsáu² ñí¹ jmáɨ², jáun² ca³lɨ́n¹³ hi³ tsá² le¹ bíh¹ ná¹jɨ́en³² dí², hi³ jáun² ca³hóh³², ");
INSERT INTO csoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","quí¹ la³jɨ́n³² bíh¹ dí² ca³ta³hú¹ cóh²¹ tsɨ́³ jmɨ́¹ ca³jɨ́en³² tsú². Tɨ³la³ Jesús ca³liéinh³² tsá² hí³ hi³ ca³juáh³ la³ lá²: ―¡Tiá³ chá¹ náh² honh²; ha³ lɨ́² juenh³ náh², quí¹ jná¹³ bíh¹ la³²! ");
INSERT INTO csoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jáun² ca³uú³ bíh¹ tsú² hñu³ mu² ñí¹ jmɨ́¹ tiáunh¹ tsá² hí³, jáun² la³ cun³ jmɨ́¹jáun² ca³hná³ chí³; jáun² tsá² hí³ lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹ hi³ ná¹tsá²cáun² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Hliá² tiá² jmɨ́¹ la³ má²ca³ngɨ¹³ yáh³ tsá² hí³ hua³jueh³² hi³ ca³jmú³ tsú² jáun² quionh³ hí³ cuú²miih²¹ jáun², jmɨ́¹ la³ ná¹jlɨ³² la³ jáun²í¹ máh³ jmɨ́¹ tsɨ́³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jmɨ́¹ lɨ²¹ jáun² né³, ca³hán² bíh¹ tsú² tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun², hi³ ca³cha³táunh¹ hué³² Genesaret; ñí¹ jáun² ca³hñéih³² tsú² mu² can³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","La³ cun³ jmɨ́¹ ca³huén² tsú² jáun² hñu³ mu², la³juɨ³² ca³lɨ³ cuóun³² bíh¹ tsáu² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","La³ cun³ jmɨ́¹jáun² ca³ñi³tú¹ ñi³lɨn¹³ tiá³ siaun³² tsá² tiáunh¹ hí³ cu³ jéin³ ñí¹ jáun², hi³ jáun² ca³ma³liáu³² hi³ já²jan² tsá² tsáun¹ hi³ ná¹tsɨn¹ ñí¹ jmu² nɨ́¹juáh³ lɨ³ua³ cáun² ñí¹ ca³lɨ³ ñi³² tsú² hi³ ngɨ³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Hi³ jáun² la³jɨ́³² juú² cáh¹ ñí¹ chau²¹ tsú², juú² míh¹ jɨ³ ñí¹náɨ² nɨ́² siáh³ jmɨ́¹ chan² tsáu² tsá² tsáun¹ ja¹ hñú³, hi³ jáun² jmɨ́¹ hiú² jmɨ́¹ mɨ³² tsú² ñí¹con² Jesús hi³ cué³² jáɨ¹³ hi³ hliéih³ tsá² tsáun¹ cuo² uá¹jinh¹ jmáh³la³ zéi¹ ha¹ bíh¹ tsú²; hi³ jáun² la³jɨ́n³² tsá² ca³tí³ hí³ cuo² ha¹ tsú² né³, lan³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jmɨ́¹jáun² cua³taunh²¹ ma³ jan² tsá² *fariseos ñí¹con² Jesús, la³ má²quionh³ ma³ jan² tɨ³² liei²¹ hi³ má²já²taunh²¹ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jáun² tsá² hí³ né³ ca³jɨ́e³ hi³ ma³ jan² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ná¹cúh² ta³ tiá² má²jɨ² cuo²; la³ cun³ ta³ tiá² má²lɨ́²ma³tí³² tsú² héih³² hi³ ná¹ngɨ²³ ca³tɨ²¹ ha³ lánh³ rón³² hniáuh³² liáh³² tsú² cuo²; hi³ jáun² bíh¹ jlánh¹ ca³ziu³ ca³hɨen³ dí² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Quí¹hliá² tsá² fariseos jɨ³ la³jɨ́n³² tsá² *judíos ná¹má²tí³² bíh¹ la³ cun³ hi³ jlánh¹ ná¹hëh³ chí¹ tsá²daun³², hi³ tiá² cáun² lɨ́¹ cuh³ yáh³ ta³ tiá² má²lɨ́²liáh³² cuo² la³ cun³ hi³ ná¹ngɨ²³ dí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Hi³ nɨ́¹ má¹cuá²tanh²¹ tsú² ja¹ hmah²¹ né³, tiá² cáun² lɨ́¹ cuh³ yáh³ tsú² ta³ tiá² má²lɨ́²ma³tí³² la³ cun³ hi³ ná¹ngɨ²³ jáun² hi³ liah³² cuo² re². Zia³² bíh¹ siáh³ hliáun³ hi³ ná¹hëh³ chí¹ tsú² ñí¹ hná¹ nɨ́², uá¹la³ cun³ hi³ ráɨn³² tsú² jáun² vasos, tse³, jɨ³ cuah²¹ mí¹ñí² nɨ́² jɨ³ jen³ míh¹ ñí¹ ná²tsɨ́n³² tsú² má¹ca³jmú³ má³² nɨ́² siáh³.) ");
INSERT INTO csoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jáun² né³, tsá² fariseos quionh³ jɨ³ tɨ³² liei²¹ ca³ngáɨ³ ñí¹con² Jesús: ―¿He³ láɨh³² tiá² má²tí³² tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² la³ cun³ hi³ ná¹ngɨ²³ tsá²daun³², hi³ cáun² lɨ́¹ cúh² bíh¹ ta³ tiá² má²jɨ² cuo²? ");
INSERT INTO csoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jáun² Jesús ca³ngáɨ³: ―Tson² lɨ́n³² bíh¹ jáɨ¹³ hi³ ca³juáh³ hla¹ Isaías jmɨ́¹ ca³hléh³ tsú² jáun² jáɨ¹³ hi³ ca³cué³ Dió³² hñu³ tsɨ́³ hi³ hnoh² ná¹lɨ́n³ náh² la³ cá¹ la³ jéinh¹, la³ cun³ rá¹juáh³ jáun² ñí¹ Sí² quioh²¹ tsú², hi³ juáh³ la³ lá²: Tsá² nɨ́² dá² má²quien² jná¹³ cun³quionh³ jmáh³la³ ho³ bíh¹, jun³juáh¹³ la³ jonh³ jmɨ́¹tsɨ́³ yáh³ tsú² hniau³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Hí¹ cáun² tiá² lin¹ ñí¹ quien² yáh³ hi³ má²tsú² má²jáuh³² tsú² jáun² jná¹³, quí¹ héih³² quioh²¹ tsá²mɨ³cuóun² bíh¹ jaun³² hɨeh³² tsú² tsáu² la³juah²¹ dúh¹ héih³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jáun² ca³juáh³ tsú² siáh³: ―Quí¹ hnoh² dá² chah³² náh² tɨ³ có³² héih³² quioh²¹ Dió³², hi³ ma³tih²¹ náh² la³ cun³ hi³ ná¹hëh³ chí¹ tsá²mɨ³cuóun², la³ cun³ hi³ ráɨn³² tsú² jáun² la³jɨ́³² cuá¹ uon² jɨ³ hi³ jmu² tsú² siáh³ hliáun³ lɨ́n³² hi³ siáh³ ñí¹ hná¹ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ja³bí¹ ca³záɨh³ tsú² siáh³ tsá² hí³ la³ lá²: ―Hnoh² dá² chah³² náh² tɨ³ có³² héih³² hi³ jmu² Dió³² quí¹ cun³ñí¹ hi³ hnáuh² náh² má¹tih²¹ la³ cun³ hi³ ná¹hëh³ chinh³² náh² hmóu³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Quí¹ sá¹nɨ́² jɨe³ dúh¹, la³ lá² bíh¹ ca³juáh³ hla¹ Moisés: “Tianh³² náh² ta²¹ ñeh² mí²ziúh²”. Ja³bí¹ ca³juáh³ tsú² siáh³: “Lɨ³ua³ jan² tsá² chú² juóun³² jméi² mí¹ziú¹³, tsá² la³ hí³ ca³tɨn¹ jún³ bíh¹”. ");
INSERT INTO csoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tɨ³la³ hnoh² né³ juánh³ hi³ lɨ́¹³ bíh¹ néh¹ záɨh³² tsáu² jméi² mí¹ziú¹³ la³ lá²: “Tiú²uú² lɨ́¹³ yáh³ má¹hau¹ jná¹³ hnú², quí¹ la³jɨ́³² hi³ zia³² quion²¹ jná¹³ ná¹lɨ́³ corbán bíh¹”, (la³ cun³ nieih³ jáɨ¹³ “hi³ má²ná¹chan¹ ñí¹con² Dió³² bíh¹”). ");
INSERT INTO csoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Hi³ jáun² nɨ́¹juáh³ má²lɨ́²juáh³ tsú² la³ nɨ́², jáun² hnoh² né³ má²juánh³ náh² hi³ tiú²uú² tion³ hniáuh³² yáh³ ma³hon³ tsú² jméi² mí¹ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jáun² cun³quionh³ la³ nɨ́² bíh¹ má²ná¹jmuh³² hnoh² hi³ tiá² quien² cu³tí¹³ héih³² quioh²¹ Dió³² cun³quionh³ hi³ ma³tɨn¹³ náh² tsáu² la³ cun³ hi³ ná¹hëh³ chinh³² náh² hmóu³². Hi³ jun³juáh¹³ jmáh³la³ hi³ nɨ́² yáh³ jmuh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Siáh³ siáh³ ca³teh³ Jesús tsáu² hi³ ja³niéi³ jáɨ¹³, hi³ ca³záɨh³ dí² la³ lá²: ―Niéi² náh² la³jɨ́n³², jɨ³ hi³ cuɨ́¹ ngɨ¹³ náh² siáh³: ");
INSERT INTO csoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jun³juáh¹³ hi³ tsá²toh³ jáun² tɨ³ ñeh² quioh²¹ yáh³ tsú² jmu² hi³ tiá² jɨn² tsú². Quí¹ hi³ ja³² la³ tɨ³ hñu³ tsɨ́³ bíh¹ tsú² jmu² hi³ hliánh². ");
INSERT INTO csoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Hnoh² tsá² ná¹chi²¹ cuáh³ náh², niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jmɨ́¹ má²lɨ́²chan³ jáun² Jesús tsá² hí³ né³, hi³ cáun² hñú³; jmɨ́¹jáun² ca³ngáɨ³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³tɨ²¹ jáɨ¹³ hi³ má²lɨ́²jmú³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jáun² hí³ né³ ca³juáh³ la³ lá²: ―¿Hí¹ chín¹dí¹ hnoh² uá¹ tiá² la³ ngɨ²³ náh² siáh³? ¿Tiá¹ má²ñíh¹ hnoh² hi³ la³jɨ́³² hi³ zia³² tɨ³ cheih³² hi³ tsá²toh³ tɨ³ ñeh² quioh²¹ tsáu², tiá² lɨ́¹³ yáh³ jmu³ hi³ jáun² hi³ hliánh¹³ tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Quí¹ hñu³ héin¹ bíh¹ tsú² tsá²toh³, jun³juáh¹³ hñu³ tsɨ́³ yáh³ tsú², hi³ má¹lɨ³² jáun² né³ hue³² siáh³ tɨ³ cheih³². Cun³quionh³ la³ nɨ́² ca³lɨ³hnió³ tsú² juáh³ hi³ jɨ² bíh¹ ca³la³ jɨ́³² ñí¹ má³². ");
INSERT INTO csoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ja³bí¹ ca³juáh³ tsú² siáh³: ―Hi³ hue³² hñu³ tsɨ́³ bíh¹ tsáu² ján¹ tson² jmu² hi³ hliáh² jmɨ́¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Quí¹hliá² tɨ³ ñeh² hñu³ tsɨ́³ bíh¹ tsú² hue³² la³jɨ́³² hi³ hlah³, uá¹la³ cun³ hi³ lɨ́¹ chin² tsú² chí¹, hi³ lɨ́¹ jmu² tsú² juón¹ quionh³ tsá² hlá² tsá² nɨ́², jɨ³ hi³ lɨ́n³ tsú² tsá² háɨn², tsá² jngɨh² tsáu² ho³ tsá² jmu² hi³ hlah³ hi³ hó³², ");
INSERT INTO csoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tsá² lɨ́¹ hniá¹ hi³ quioh²¹ tsáu², tsá² hláɨh¹ hon², tsá² má²can² tsáu², tsá² lɨ́¹ jmu² la³ cun³ hi³ tɨ³² tsɨ́³ hnga², tsá² uóu³² tsɨ́³, tsá² tɨn² jú¹ tɨ́¹jáɨ², tsá² jmu² tonh², jɨ³ tsá² lɨ́¹ jmu² hi³ cáun¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ca³la³ jɨ́³² hi³ hlah³ nɨ́² ja³toh²³ tɨ³ ñeh² hñu³ tsɨ́³ bíh¹ tsú², hi³ jáun² bíh¹ jmu² hi³ tiú²uú² jɨn² tsú² ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús ñí¹ jáun² hi³ ca³ñí¹ngɨ́² la³cáun² juú² Tiro jɨ³ juú² Sidón. Jáun² hi³ tsú² cáun² hñú³, hi³ hí¹ jan² tsáu² tiá² jmɨ́¹ hnió³ tsú² lɨ³ ñi³²; tɨ³la³ tiá² ca³lɨ³ yáh³ hính³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","La³ cun³ jmɨ́¹jáun² bíh¹ ca³lɨ³ ñi³² mí¹ziú¹³ jan² mɨ́¹míh¹ tsá² jmɨ́¹ hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³, hi³ Jesús má²cuán² juú² jáun²; hi³ jáun² ja³ tsú² hi³ ca³di³jñí³² ta³ ñí¹ Jesús, hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jan² tsá² cú²juú² bíh¹ tsá²mɨ³ hí³, tsá² jmɨ́¹ hɨ́n¹³ tɨ³ Fenicia hué³² Siria. Cuan³ tsú² ñí¹con² Jesús hi³ ca³mɨ́³ dí² hi³ chin¹³ tsú² jmɨ́²chí³ hláɨnh¹ hi³ hún¹ hñu³ tsɨ́³ mɨ́¹ míh¹ jon² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Tɨ³la³ Jesús ca³juáh³: ―Cué¹ jáɨ¹³ hi³ láɨh¹³ tín² re² má³² tsá²co¹ jná¹³, quí¹ tiá² re² jniá³ yáh³ hi³ quin¹³ dí² má³² quioh²¹ tsá¹míh¹ hi³ cue¹³ dí² tsáɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tɨ³la³ tsá²mɨ³ hí³ né³, ca³juáh³: ―Tson² bíh¹ la³ jáun² Tɨ³²; tɨ³la³ hí¹ ca³la³ tɨ³ tsáɨ² tionh² ñeh² mesa yáh³ cúh² chí² juoh¹ hi³ súh²³ tsá¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jáun² né³, Jesús ca³juáh³: ―Re² bíh¹ má²lɨ́²juah²¹ hnú² la³ nɨ́²; má²lɨ́¹³ bíh¹ cuánh¹³ hnú². Má²cuá²han³ bíh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ jónh³² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jmɨ́¹ cá¹chánh²¹ tsú² jáun² hñú¹³ né³, ca³jɨ́en³² tsú² mɨ́¹míh¹ jon² hi³ rá¹tsɨn² ñí¹ jen³; hi³ jmɨ́²chí³ hláɨnh¹ né³, la³ má²cuá²han³ bíh¹ hñu³ tsɨ́³ mɨ́¹míh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ siáh³ Jesús ñí¹ hu²¹ cuo² juú² Tiro, hi³ ngau³ juɨ³² juú² Sidón jɨ³ la³cáun² tɨ³ ñí¹ tioh³ jáun² tá¹ quia³ juú² míh¹ tiá² ná¹cunh² siáh³, jáun² ca³chó³² tsú² ñí¹ ná¹ho³ jmáɨ² Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ñí¹ jáun² cua³jan² tsú² jan² tsá²ñuh² te³ cuá¹, tsá² tiá² re² hleh³², hi³ jáun² ca³hiu³ ca³mɨ́³ tsú² hi³ ra³tsɨ³² Jesús cuo² ñí¹ quioh²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jáun² Jesús ca³jan³ tsá² hí³ ñí¹ tɨ³ có³², ñí¹ tiá² hin² zian², hi³ jáun² ca³lóh³ dí² zeih²¹ cuo² cuá¹ tsá² hí³, hi³ jáun² jmɨ́¹jáun² ca³hñe³ dí² siáh³ zeih²¹ cuo² hi³ jáun² ca³hliéih³ dí² zɨ́h¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jáun² la³ cun³ jmɨ́¹jáun² ca³jɨ́e³ dí² hñu³mɨ³cuú², hi³ ca³zion³ tsɨ́³ hi³ ca³juáh³: ―¡Efata! (hi³ hnió³ juáh³ “¡Cuɨ́¹ niá¹³!”). ");
INSERT INTO csoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La³ cun³ jmɨ́¹jáun² bíh¹ ca³niá³ cuá¹ tsá² jmɨ́¹ ten³ hí³, hi³ la³ siáh³ zɨ́h¹ tsú², hi³ jáun² ca³lɨ³ bíh¹ hléh³² tsá² hí³ re². ");
INSERT INTO csoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jáun² né³, Jesús ca³jmú³ héih³² ñí¹con² tsá² jmɨ́¹ tsáun¹ hí³ la³ má²quionh³ tsá² ná¹jɨ́e²³, hi³ hí¹ jan² tiá² hin² záɨh³² tsú²; tɨ³la³ uá¹jinh¹ ca³jmú³ dí² héih³² chí¹tson³ hi³ tiá² hin² záɨh³² tsú² hi³ jáun², tɨ³la³ tɨ³ lɨ́³mí¹ ca³qui³ ca³chá³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Hi³ jáun² jlánh¹ ca³ja³cáun² lɨ́n³² tsɨ́³ tsá² ca³náɨ³² hí³ hi³ lɨ³ la³ jáun², hi³ jáun² ca³juáh³ la³ lá²: ―La³jɨ́³² bíh¹ jmu² tsú² re²; hí¹ la³ tɨ³ tsá² te³ cuá¹ yáh³ náɨ³² jmu² tsú², jɨ³ hi³ jmu² tsú² siáh³ hi³ hléh³² tsá² cáun¹. ");
INSERT INTO csoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jmɨ́¹ lɨ́¹cáɨn² pih²¹ jáun² ca³ngɨh³² siáh³ juóun³² lɨ́n³² tsáu², hi³ tiá² jmɨ́¹ zia³² yáh³ he³ cuh³ tsú². Jáun² né³, Jesús ca³teh³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ ca³záɨh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Jlánh¹ ja³² mií³ tsɨn³² jná¹³ ñí¹con² tsá² lá², quí¹hliá² hnɨ³² jmáɨ¹ máh³ má²tí³ hi³ tionh² tsú² ñí¹ lá² quiúnh¹ jná¹³, hi³ hí¹ cú¹pih²¹ yáh³ hi³ cuh³ tsú² tiú²uú² zia³². ");
INSERT INTO csoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nɨ́¹juáh³ hi³ chanh²¹ jná¹³ tsú² hñú¹³ ta³ tiá² hi³ má²lɨ́²cuh³, lɨ́¹³ huán³ bíh¹ tsɨ́³ tsú² hú¹ juɨ³², quí¹hliá² ma³ jan² tsá² nɨ́² tsá² já²taunh²¹ ñí¹ uóunh³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jáun² né³, tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ngáɨ³: ―Tɨ³la³ ¿ha³ bí¹ lánh³ rón³² lɨ́¹³ cue¹³ dí² tsá² nɨ́² má³² hi³ cuh³ ñí¹ lá², cáun² ñí¹ tiá² hin² zian² hí¹ jan² bíh¹ la³²? ");
INSERT INTO csoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jáun² Jesús ca³ngáɨ³: ―¿Cónh³ bíh¹ *hí³ cuú²miih²¹ zia³² quián¹³ hnoh² dúh¹? Jáun² tsá² hí³ ca³ngáɨ³: ―Quiau³ hí³ bíh¹ zia³². ");
INSERT INTO csoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jmɨ́¹jáun² ca³jmú³ dí² héih³² hi³ tiánh³² tsá² hí³ hué³², hi³ jáun² ca³zanh³ dí² tá¹ quiau³ hí³ jáun², hi³ ca³cuéh³ dí² tiá¹hmah¹ Dió³². Jmɨ́¹ lɨ²¹ jáun² ca³ca³ tsú² hí³ cuú²miih²¹ jáun² hi³ ca³cuéh³ dí² tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² tsá² hí³ né³, ca³tsóh³ ñí¹con² tsá² má²tionh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Hi³ jmɨ́¹ zian² siáh³ cun³ gon³ gáun³ juo¹³ pih²¹, hi³ jáun² Jesús ca³ma³mieh² siáh³ jáh³ hí³, jáun² ca³jmú³ dí² siáh³ héih³² hi³ tsóh³ tsú² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Jáun² ca³la³ jɨ́n³² tsá² hí³ lah³ re² má³², ca³lɨ³í¹ máh³ ca³cónh³² quiau³ mɨ́²tá² chí² juoh¹ hi³ ziau³ jmɨ́¹ má²lɨ́²cuh³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","La³ cun³ tsá² ca³jmú³ hí³ má³² jmɨ́¹ tín³ cun³ quiún³ mei²¹ tsáu². Hi³ jáun² jmɨ́¹ má²lɨ³² jáun² né³, ca³hah² Jesús jáɨ¹³ ñí¹con² tsá² jmɨ́¹ tionh¹ hí³, ");
INSERT INTO csoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","hi³ jáun² hi³ hñu³ mu² quionh³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ ja³taunh²¹ tɨ³ ñí¹ téh²³ tsú² Dalmanuta. ");
INSERT INTO csoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jmɨ́¹jáun² cua³taunh²¹ tsá² *fariseos hi³ ca³ma³liáu³² hi³ quiú² táɨnh²³ jáɨ¹³ quionh³ Jesús. La³ cun³ hi³ hnió³ dí² ca³ lan³ Jesús, hi³ jáun² ca³mɨ́³ dí² cáun² li²¹ hi³ lɨ́³ hua³jueh³² hi³ já³² tɨ³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jáun² Jesús jlánh¹ ca³zion³ lɨ́n³² tsɨ́³ hi³ ca³juáh³ la³ lá²: ―¿He³ láɨh³² mɨ³² tsá² zian² né³² cáun² li²¹ cun³quionh³ hua³jueh³²? Jú¹ tson² juanh³² jná¹³ hi³ hí¹ cáun² yáh³ li²¹ tiá² lɨ́¹³ hiáuh³ tsá² zian² né³². ");
INSERT INTO csoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jmɨ́¹jáun² ca³chan³ dí² tsá² hí³ ñí¹ jáun², hi³ jáun² taunh³ dí² siáh³ hñu³ mu² hi³ ngau³ tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jmɨ́¹jáun² ca³ja³có³ tsɨ́³ tsá² quian³tun³ hi³ cán³ má³² cuh³, jɨ́³²la³ cáun² tán¹ bíh¹ hí³ cuú²miih²¹ jmɨ́¹ quian³² tsú² jmɨ́¹ taunh²¹ hñu³ mu² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jáun² Jesús ca³hlɨ́² ca³liéinh³² tsá² hí³ hi³ ca³juáh³ la³ lá²: ―Sá¹nɨ́² jɨe³, hua³hín¹³ náh² jmu³ ca³tɨ²¹ tie³ quioh²¹ tsá² fariseos la³ má²quionh³ jɨ³ tie³ quioh²¹ Herodes nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ma³liáu³² hi³ juónh²³ la³ lá² ja¹ hmóu²¹: ―Cun³ñí¹ hi³hliá² tiá² quián¹ má³² bíh¹ dí² nɨ³², hi³ jáun² la³ nɨ́² ñí¹juah²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tɨ³la³ Jesús ca³lɨ³tsɨn² bíh¹ hi³ jáun², hi³ jáun² ca³juáh³ siáh³: ―¿He³ láɨh³² ná¹juónh³² náh² hi³ tiá² quiánh¹ má³²? ¿Hí¹ la³ tɨ³ ta³né³² máh³ tiá² má²ca³ngɨ¹³ náh², hi³ sa³jun³ má²ca³lɨ³tsɨn² náh² siáh³? ¿Hí¹ ná¹jlɨ³²í¹ máh³ honh² hnoh² la³ tɨ³ ta³né³² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Hí¹ tiá² la³ jniá³ máh³ máh¹ náh², hi³ sa³jun³ la³ niéih³ siáh³ cuáh³ náh²? ¿Hí¹ tiú²uú² chau² máh³ honh² hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jmɨ́¹ ca³tsóh³² jná¹³ jáun² hñá³ hí³ cuú²miih²¹ ja¹ ñí¹ tionh¹ hñá³ mei²¹ tsáu², ¿jáh³ mɨ́²tá² chí² juoh¹ ca³jiéih¹ náh² jmɨ́¹jáun² dúh¹? Jáun² tsá² hí³ ca³ngáɨ³: ―Quia³tún³ mɨ́²tá². ");
INSERT INTO csoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Hi³ jmɨ́¹ ca³tsóh³² jná¹³ jáun² tá¹ quiau³ hí³ ja¹ ñí¹ tionh¹ quiún³ mei²¹ tsáu², ¿cónh³ mɨ́²tá² ca³cónh³² chí² juoh¹ hi³ ca³jiéih¹ hnoh² jáun² siáh³? Hi³ jáun² tsá² hí³ ca³ngáɨ³ siáh³: ―Quiau³ mɨ́²tá². ");
INSERT INTO csoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jmɨ́¹jáun² né³ ca³záɨh³ dí²: ―¿He³ lɨ³ sa³ la³ tɨ³ ta³né³² máh³ tiá² má²ca³ngɨ¹³ náh² né³? ");
INSERT INTO csoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Hi³ jáun² né³, jmɨ́¹ ca³cha³táunh¹ tsú² já¹ juú² Betsaida, jáun² cua³jan² tsáu² jan² tsá² ten³ ñí¹con² Jesús; jáun² ca³hiu³ ca³mɨ́³ tsú² hi³ Jesús ra³tsɨ³² cuo² ñí¹ quioh²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jáun² ca³zanh³ Jesús cuo² tsá² ten³ hí³, hi³ jáun² ca³chín² dí² tɨ³ cheih³² juú². Jáun² ca³yóh³ dí² mí¹héh¹³ mɨ́¹ñí¹ tsá² hí³ hi³ jáun² ca³ra³tsɨ³² dí² siáh³ cuo² ñí¹ quioh²¹ tsú², jmɨ́¹jáun² ca³ngáɨh³ dí² nɨ́¹juáh³ má²lɨ́²³ jɨ́e³ ca³lá². ");
INSERT INTO csoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jáun² tsá² ten³ hí³ né³ ca³jɨ́e³, hi³ jáun² ca³juáh³: ―Jɨen¹ jná¹³ tsáu², tɨ³la³ la³jmɨ́¹ jniá³ hmá² bíh¹ jniá³ tsáu² ñi³táunh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jáun² Jesús ca³tí³ siáh³ cuo² mɨ́¹ñí¹ tsú², jmɨ́¹jáun² ca³tauh² tsá²ñuh² hí³ tiá³ ñí¹, hi³ ca³jɨ́e³; jáun² lan³ bíh¹ tsú². La³jɨ́³² bíh¹ má²jɨ́e²³ tsú² re² lɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jáun² né³, Jesús ca³chanh³ tsú² hñú¹³, hi³ ca³záɨh³ dí² la³ lá²: ―Ha³ lɨ́² cua³hú³² já¹ juú², hi³ sa³jun³ hí¹ jan² tsáu² tiá² hniáuh³² cuá¹zéih³ nú² hi³ lɨ³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jmɨ́¹ lɨ²¹ jáun² ngau³ Jesús quionh³ tsá² haɨn²¹ hí³ tɨ³ con² ñí¹ tioh³ juú² míh¹ cu³ jéin³ juú² Cesarea quioh²¹ Pí²liéi¹. Ta³ hí¹tiáunh¹ dí² jáun² juɨ³² ca³ngáɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con²: ―¿Hin² tsánh² jná¹³ juáh³ tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jáun² tsá² hí³ ca³ngáɨ³: ―Zian² tsá² juáh³ hi³ hnú² bíh¹ néh¹ hla¹ Juan² tsá² tɨ́² ziau² hí³ jmáɨ², ma³ jan² tsáu² juáh³ hi³ hnú² bíh¹ Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin², hi³ ma³ jan² tsá² juáh³ siáh³ hi³ hnú² bíh¹ néh¹ jan² tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jmɨ́¹jáun² né³ ca³ngáɨh³ dí² siáh³ tsá² hí³: ―Hi³ hnoh² né³, ¿hin² tsánh² jná¹³ juáh³ hnoh²? ―Hnú² bíh¹ Tsá² lɨ́n³ Cristo ―ca³juáh³ Pé¹. ");
INSERT INTO csoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Tɨ³la³ Jesús ca³jmú³ héih³² hi³ hí¹ jan² tiá² hin² záɨh³² tsú² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jmɨ́¹jáun² ca³ma³liáu³² Jesús hɨeh³² tsá² haɨn²¹ hí³ tɨ³ con² hi³ juáh³: ―Jná¹³, Jon² tsá²mɨ³cuóun² ca³tɨn¹ má¹tso¹ lɨ́n²¹ tsɨn³². Ca³záɨh³ dí² tsú² hi³ tsá²daun³² tsá² ná¹ñí¹ juú² quionh³ tsá² ná¹lɨ́n³ mi³jmú³, jɨ³ tɨ³² liei²¹ nɨ́² siáh³ tiá² quiú¹ tiá² jéi¹³, hi³ jngah³; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² má¹ná¹, jenh¹³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Na²¹ lɨ́n²¹ bíh¹ ca³hléh³ tsú² jáɨ¹³ nɨ́². Jmɨ́¹jáun² ca³ñí¹jau² Pé¹ ñí¹ tɨ³ có³² hi³ jáun² ca³ma³liáu³² dí² hi³ quiú² jin²³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tɨ³la³ Jesús ca³jinh³ tɨ³ ñí¹ tionh¹ tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² ta³ má²jɨ́en³² tsá² hí³ dí² ca³jin³ Pé¹, hi³ ca³záɨh³ dí² la³ lá²: ―¡Tɨ³ có³² quin³² ñí¹con² jná¹³ *Satanás!, quí¹ tiá² lɨ́n²³ yáh³ hnú² la³jmɨ́¹ lɨ́n²³ Dió³², hnú² dá² lɨ́n²³ la³cun³ qui³ lɨ́n²³ tsá²mɨ³cuóun² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jáun² né³, Jesús ca³teh³ tsá² haɨn²¹ hí³ tɨ³ con² jɨ³ tsá² ñi³táunh¹ hí³ cu³chin¹ cu³hna²¹ dí², hi³ ca³záɨh³ dí² la³ lá²: ―Nɨ́¹juáh³ zian² tsá² hnió³ já³² cu³hna³² jná¹³, hniáuh³² chá³² tsú² tɨ³ có³² la³jɨ́³² hi³ dí¹quiaunh²¹ tsɨ́³ hnga², hi³ jáun² cuɨ́¹ quián¹³ tsú² crei²¹ quioh²¹, la³ cun³ hi³ cuéh³² tsú² jáun² tsɨ́³ uá¹jinh¹ ca³la³ ñí¹ ca³cáɨn³ jmɨ́²chí³ quioh²¹, hi³ jáun² cuɨ́¹ já² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Quí¹ nɨ́¹juáh³ tsá² hnió³ lión³² hnga², tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tsa³hín³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ má¹ná¹ jɨ³ hi³ ca³tɨn¹ jú¹ chú³² quioh²¹ Dió³² nɨ́² siáh³, tsá² la³ hí³ bíh¹ tɨ³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Quí¹ ¿ha³ dá² jinh¹ quien² nɨ́¹juáh³ ca³láɨh¹³ tsú² la³jɨ́³² hi³ zia³² ñí¹ hué²¹ lá², nɨ́¹juáh³ la³ ja³hín³ bíh¹ jmɨ́²chí³ quioh²¹ tsú² má¹lɨ³² jáun²? ");
INSERT INTO csoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Quí¹ ¿he³ yáh³ cun³quionh³ lɨ́¹³ joh¹³ tsú² siáh³ jmɨ́²chí³ quioh²¹? ");
INSERT INTO csoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Quí¹ lɨ³ua³ jan² tsá² jmu² heh³ ta³ ñí¹ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², tsá² ná¹ren² tso³, cun³ñí¹ hi³ ca³tɨn¹ jná¹³ jɨ³ ca³tɨ²¹ jú¹ chú³² quion²¹ jná¹³ siáh³, ja³bí¹ jná¹³ Jon² tsá²mɨ³cuóun² jmu¹ heh¹ ca³tɨn¹ tsá² la³ hí³ nɨ́¹ má¹jaunh³² ná¹ hi³ lin¹ hi³ quien² ná¹ la³jmɨ́¹ quien² Ñuh³², la³ má²quiúnh¹ jná¹³ tsá² ná¹chun¹ tsá²cuú² tsá²ta³ Dió³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ja³bí¹ ca³juáh³ siáh³ Jesús: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ zian² tsá² ja¹ ñí¹ tiauh¹ dí² lá² tiá² má²jún³ yáh³ ta³ tiá² má²lɨ́²jɨ́e³ tsú² hi³ má²cua³² pí³ quioh²¹ Dió³² ñí¹con² tsá² má²tionh² jo³cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jmɨ́¹ la³ má²jñéi³ jmáɨ¹ jáun² né³, Jesús ca³jan³ Pé¹ quionh³ Jacobo jɨ³ Juan² nɨ́² hi³ ja³taunh²¹ cáun² tsɨ³ máh³ ñe¹ ñí¹ lɨ́¹³ tiánh³² hmóu³²; ñí¹ jáun² ca³za² ho¹ñí¹ tsú² ñí¹ ta³ ñí¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Zɨ́n³ lɨ́n³² ca³lɨ³ ha¹ tsú² jɨ³ hi³ ca³lɨ³ tiáu² lɨ́n³² siáh³ la³jmɨ́¹ jniá³ jan³², ca³la³ hí¹ jan² yáh³ tsá² zian² ñí¹ hué²¹ lá² tiá² tɨn² jmu³ hi³ jniá³ tiáu² lɨ́n³² ha¹ nɨ́¹ má¹lɨ́²ráɨn³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jmɨ́¹jáun² ca³jɨ́en³² tsá² hí³ Líh³ quionh³ Moisés, hi³ ná¹juónh²³ quionh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jáun² né³, Pé¹ ca³záɨh³ Jesús: ―Hnú² Tɨ³², ¡hénh³ ma³ chú³² má²tiauh² dí² ñí¹ lá²! Cuɨ́¹ jmú¹³ jnoh¹ hnɨ³² hñú³reh³; cáun² quián¹³ hnú², cáun² quioh²¹ Moisés, hi³ cáun² siáh³ quioh²¹ Líh³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Quí¹hliá² jmɨ́¹ ná¹juenh²¹ bíh¹ tsá² haɨn²¹ tɨ³ con² tsú², hi³ jáun² Pé¹, hí¹juáh³ tiá² ñi³² bíh¹ he³ dá² jmɨ́¹ dí¹hleh³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jmɨ́¹jáun² ja³ cáun² jnie² ñí¹ tionh¹ tsú² jáun², hi³ jáun² ca³tsáɨnh³² tsú² jɨ³lɨn², hi³ jáun² ja¹ jnie² jáun² ñí¹ ca³hléh³ jan² tsáu² hi³ ñí¹juah²¹: ―Tsá² lá² bíh¹ Jón³² jná¹³, jan² Tsá² hno³ lɨ́n³² ná¹; niéi² náh² la³ cun³ hi³ juáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Hi³ jáun² la³ cun³ jmɨ́¹ ca³jɨ́e³ tsú² cu³ jéin³ ñí¹ tionh¹, hí¹ jan² yáh³ tiú²uú² hin² ca³jnia³ jéinh³² tsú², jɨ́³²la³ hnga² bíh¹ Jesús jéi³²í¹ zenh². ");
INSERT INTO csoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tá¹la³ ná¹son² tsú² jáun² tsɨ³ máh³ né³, ca³jmú³ Jesús héih³² hi³ hí¹ jan² tiá² hin² záɨh³² tsú² la³ cun³ hi³ má²lɨ́²jɨ́e³ jáun², ca³la³ tɨ³ nɨ́¹ má¹ca³jenh¹³ Jon² tsá²mɨ³cuóun² ja¹ hla¹ máh³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jáun² ca³hmá³ bíh¹ tsú² jáɨ¹³ jáun² ja¹ má²tún² hmóu³², tɨ³la³ cun³ jáun² ca³ngáɨ³ bíh¹ tsú² ja¹ hmóu³² hi³ he³ dá² niéih³ jáɨ¹³ hi³ jenh¹³ tsú² ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Hi³ jáun² né³ ca³ngáɨh³ dí² Jesús: ―¿He³ láɨh³² sa³ juáh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, hi³ Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³² bíh¹ néh¹ tín² jáunh³ la³ñí¹? ");
INSERT INTO csoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jáun² hí³ né³ ca³ngáɨ³: ―Tson² bíh¹ Líh³ tín² jáunh³ la³ñí¹, hi³ ja³ma³re² jɨ³lɨ³². Tɨ³la³ hi³ ca³tɨn¹ Jon² tsá²mɨ³cuóun² né³, ¿he³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³² hi³ ca³tɨn¹ tsú² dúh¹? Ñí¹ jáun² rá¹juáh³ hi³ hí³ dí² ca³tɨn¹ ma³tso² tsɨ́³, hi³ lɨ́n¹³ tsú² jan² Tsá² tiá² hin² quiú² jéi²³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Tɨ³la³ jná¹³ juanh³² hi³ má²cuán² bíh¹ Líh³, hi³ jáun² ca³jmoh³ tsú² tsáu² la³ cun³ hi³ hnió³ tsáu² jmoh³, la³ cun³ rón³² rá¹juáh³ jáun² ñí¹ Sí² hi³ ca³tɨ²¹ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jmɨ́¹ lɨ²¹ jáun² ca³cha³tánh¹ tsú² ñí¹ tionh¹ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² tsá² ñí¹ hná¹ jáun², jáun² ca³jɨ́e³ tsú² hi³ juóun³² lɨ́n³² tsáu² má²tionh² cu³ jéin³ jáun²; ja³bí¹ tɨ³² liei²¹ siáh³ jmɨ́¹ tionh¹ ñí¹ jáun² hi³ ná¹quiú² ná¹táɨnh²³ jáɨ¹³ quionh³ tsá² hí³ joh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jáun² la³ cun³ jmɨ́¹ ca³jɨ́en³² tsú² jáun² Jesús, ca³ja³cáun² lɨ́n³² bíh¹ tsɨ́³ la³jɨ́n³² tsá² hí³, hi³ jáun² ja³taunh²¹ dí² cú²hé² ñí¹ cuá¹jáunh²³ tsú² jáun² hi³ ca³ñí¹hen¹³ dí² tsú² ca³la³ hi³ hiún² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jáun² né³, ca³ngáɨh³ tsú² tsá² joh¹: ―¿Hín² dá² jáɨ¹³ ná¹quí² ná¹táɨnh³² hnoh² quiúnh¹ tsá² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jáun² jan² tsá² jmɨ́¹ zenh¹ ja¹ tsá² ná¹ngɨh³² hí³ ca³ngáɨ³: ―Hnú² Tɨ³², lá² ján³ jná¹³ jón³² ñí¹con² hnú², hi³ hún¹ jan² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ hi³ jmu² hi³ tiá² lɨ́²³ hléh³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Quí¹ lɨ³ua³ cáun² ñí¹ tsó²¹ ñú²míh¹ lá², jmɨ́²chí³ hláɨnh¹ cáun² ja³² hi³ zaunh²³ hi³ juóu³² hué³², hi³ jáun² má¹jáun² hia³² jan³² ho³ jɨ³ hi³ cúh² siáh³ ján¹. Cun³quionh³ hi³ lɨ́²³ la³ nɨ́² bíh¹ má²tsá²lɨ³huán¹ tsú². Má²lɨ́²mɨ́³ bíh¹ jná¹³ ñí¹con² tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² hi³ jmɨ́¹ chin¹³ tsú² jmɨ́²chí³ hláɨnh¹, tɨ³la³ tiá² ca³tioh²¹ yáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Hi³ jáun² Jesús ca³ngáɨ³: ―¡Hnoh² tsá² tiá² ta²¹ táunh²³ náh²! ¿Jáh³ jmáɨ¹ máh³ hniáuh³² hi³ ngɨ́¹³ jná¹³ quiúnh¹ hnoh² dúh¹? ¿Jáh³ jmáɨ¹ máh³ hniáuh³² hi³ tion¹ jná¹³ tsɨn³² hi³ ca³tɨn¹ hnoh²? Ñá²jan³² ñú²míh¹ tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Hi³ jáun² cua³jan² dí² tsú². Jáun² la³ cun³ jmɨ́¹ ca³jɨ́en³² jmɨ́²chí³ hláɨnh¹ Jesús né³, ca³jmú³ hi³ he¹³ tsá¹ lɨ́¹ jún²³ ñú²míh¹ hí³, jáun² ca³quɨnh³ hué³², hi³ ca³pɨ³ ca³lɨnh³ hi³ ca³hiá² jan³² ho³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jmɨ́¹jáun² ca³ngáɨ³ Jesús ñí¹con² jméi² tsú²: ―¿Jáh³ jmáɨ¹ má²tí³ hi³ jéinh³² tsú² la³ nɨ́²? ―La³ cun³ jmɨ́¹ míh² máh³ tsú² jéinh³² la³ nɨ́² ―ca³juáh³ jméi² tsú²―. ");
INSERT INTO csoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Hliáun³ jéin³² lɨ́n³² má²ca³jmú³ jmɨ́²chí³ hláɨnh¹ hi³ taunh² chu³ sɨ́² jɨ³ chu³ jmáɨ² siáh³, hi³ hnió³ jngah³. Hi³ jáun² né³, nɨ́¹juáh³ zia³² hi³ lɨ́¹³ jmúh¹³ hnú² ca³lá², cuɨ́¹ já² mií³ honh² hnú² quiú¹³ jnoh¹, ma³hau¹ tiá³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jáun² Jesús ca³juáh³: ―Nɨ́¹juáh³ lɨ́¹³ cháh¹³ hnú² cáun² honh², quí¹ jɨ³lɨ³² bíh¹ lɨ́¹³ ñí¹con² tsá² nio² cáun² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Hi³ jáun² jméi² ñú²míh¹ hí³ ca³hléh³ tiá³ hi³ ca³juáh³ la³ lá²: ―¡Taunh³² bíh¹ jná¹³ ta²¹; ma³hau¹ hi³ tɨ³ lɨ³mí¹ niau²¹ cáun² tsɨn³² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jmɨ́¹ ca³jɨ́e³ Jesús hi³ juóun³² lɨ́n³² tsáu² má²hí¹ngɨh³², jáun² ca³jin³ dí² jmɨ́²chí³ hláɨnh¹ hi³ ca³záɨh³ dí² la³ lá²: ―Hnú² jmɨ́²chí³ jmu² hi³ cáun¹ tsú² jɨ³ hi³ te³ cuá¹ tsú², jná¹³ jmu² héih³² hi³ cuá¹haɨn³² hnú²; tun³² tsá² nɨ́², ha³ lɨ́²uú² ña³hu³² siáh³ hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ ca³hóh³² tiá³, jɨ³ hi³ ca³jmú³ siáh³ hi³ he¹³ cónh³í¹ cu³ jéin³² tsá¹ lɨ́¹ jún²³ ñú²míh¹ hí³, jmɨ́¹jáun² cua³han³; hi³ jáun² ca³quión³² dí² ñú²míh¹ hí³ la³jmɨ́¹ rón²¹ jan² tsá² má²rá²jún¹, hi³ jáun² juóun³² lɨ́n³² tsáu² jmɨ́¹ ná¹juáh²³ hi³ hú¹tá¹ má²rá²jún¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tɨ³la³ Jesús ca³zanh³ cuo² tsú² hi³ ca³zion³ dí²; hi³ jáun² ñú²míh¹ hí³ né³, ca³náu² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jmɨ́¹ lɨ²¹ jáun² né³, ca³hi³ siáh³ Jesús cáun² hñú³, hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ngáɨ³ ñí¹ hnga² tsú², hi³ ca³juáh³: ―¿He³ láɨh³² sa³ tiá² ca³tiáu¹³ yáh³ jnoh¹ hi³ chin¹³ jmɨ́²chí³ hláɨnh¹ hí³? ");
INSERT INTO csoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jáun² ca³záɨh³ dí² tsú²: ―Quí¹hliá² jmɨ́²chí³ hláɨnh¹ la³ hí³ lɨ́¹³ chin¹³ tsú² jɨ́³²la³ cun³quionh³ hi³ liéinh³² tsú² Dió³² bíh¹ jɨ³ hi³ má²hɨen²¹ tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jmɨ́¹ ca³huén² tsú² jáun² ñí¹ jáun², ca³ngá² tsú² la³cáun² hué¹³ Galilea. Tɨ³la³ Jesús tiá² jmɨ́¹ hnió³ hi³ lɨ³ ñi³² tsáu² hi³ ngɨ³² dí² ñí¹ jáun² ");
INSERT INTO csoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","quí¹hliá² jmɨ́¹ má²tɨn² dí² tsá² haɨn²¹ hí³ tɨ³ con²; jɨ³ hi³ zaɨh³² dí² la³ lá²: ―Jná¹³ Jon² tsá²mɨ³cuóun² jɨenh³ tsú² jo³cuo² tsáu², hi³ jáun² jngah³ tsú²; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² né³, jenh¹³ bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tɨ³la³ tsá² hí³ né³, hí¹juáh³ tiá² ca³ngɨ¹³ bíh¹ he³ dá² jaun³² dí¹ juáh²³ tsú², hi³ jmɨ́¹ juénh² tsú² siáh³ hi³ mɨ́³² ñí¹con² Jesús hi³ jmu³ na²¹ jáɨ¹³ hi³ má²lɨ́²juáh³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jmɨ́¹ lɨ²¹ jáun² ca³cha³tánh¹ tsú² já¹ juú² Capernaum; jáun² má²cuá³ ñéih³ Jesús la³ cun³ jmɨ́¹ ca³ngáɨh³ tsá² joh¹ hi³ ca³juáh³: ―¿He³ dá² jaun³² jmɨ́¹ hí¹juónh³² hnoh² hú¹ juɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tɨ³la³ tsá² hí³ cáun² lɨ́¹ ca³tiánh³ tie³ bíh¹, quí¹hliá² hú¹ juɨ³² jáun² jmɨ́¹ hí¹juónh²³ tsú² hi³ hin² bíh¹ tsánh² jlánh¹ quien² ja¹ hmóu³² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jáun² né³, Jesús ca³cuá³ hi³ jáun² ca³teh³ dí² tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ ca³záɨh³ dí² la³ lá²: ―Nɨ́¹juáh³ zian² tsá² hnió³ hi³ lɨ³ quien², hniáuh³² jmu³ tsú² hi³ lɨ́n³ jan² tsá² huen³ ñí¹ cá¹táuh³ bíh¹, jɨ³ hi³ ma³cón³² tsú² siáh³ jɨ³lɨn² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jmɨ́¹jáun² ca³can³ dí² jan² tsá¹míh¹ hi³ ca³zinh³ dí² ja¹ quioh²¹ tsá² hí³, hi³ jáun² ca³ráɨn³² dí² siáh³, jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Lɨ³ua³ jan² tsá² hen³ jan² tsá¹míh¹ la³ lá² chá³² jná¹³, má²lɨ́²he³ jɨ³ jná¹³ bíh¹ tsú² jaun³²; hi³ nɨ́¹juáh³ tsá² he³ jná¹³ né³, jun³juáh¹³ jmáh³la³ jná¹³ yáh³ he³ tsú², quí¹ ja³bí¹ la³ jáun² má²lɨ́²hen³ tsú² siáh³ Tsá² ca³ze³ bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jmɨ́¹jáun² ca³juáh³ Juan²: ―Tɨ³², má²lɨ́²neh²¹ jnoh¹ jan² tsá² huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² la³juah²¹ dúh¹ cun³quionh³ héih³² quián¹³ hnú², jáun² má²lɨ́²jmú¹³ jnoh¹ héih³² hi³ tiú²uú² jmu³ tsú² la³ jáun², quí¹hliá² tiá² ngɨ³² yáh³ tsú² quiúnh¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Tɨ³la³ Jesús ca³juáh³: ―Ha³ lɨ́² jmú² náh² héih³² la³ nɨ́²; quí¹ hí¹ jan² yáh³ tiá² hin² zian² hi³ jmu² hua³jueh³² cun³quionh³ héih³² quion²¹ jná¹³, hi³ má¹lɨ³² jáun² hléh³² siáh³ hlah³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nɨ́¹juáh³ tsá² tiá² hau² jnoh¹, jáun² tsá² la³ hí³ bíh¹ tsá² hen² tɨ³ con² jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Quí¹ lɨ³ua³ jan² tsá² cué³² hnoh² uá¹jinh¹ cáun² vaso jmáɨ² cun³ñí¹ hi³ hnoh² lɨ́n³ náh² tsá² joh¹ Cristo, ja³bí¹ tsá² hí³ uá²jaɨ³² hiáuh³ cáun² hi³ chu²¹, la³ cun³ hi³ ca³tɨn¹ hiáuh³. ");
INSERT INTO csoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”Lɨ³ua³ jan² tsá² jmu³ hi³ tánh³² tso³ tsá¹míh¹ tsá² taunh² jná¹³ lá² ta²¹, tɨ³ jlánh¹ bíh¹ re² sá¹jmɨ́¹ hi³ tónh³² tsú² zié³ láɨ¹ tsá² la³ hí³, hi³ chí¹hñéih²³ cáun² tá² quɨ́n¹ pa²¹ lɨ́n²¹, hi³ jáun² taun³ tsú² hñu³ jmɨ́²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jáun² né³, nɨ́¹juáh³ cuonh² hnú² jmu² hi³ tanh³² hnú² tso³, tɨ³ re² hná¹; quí¹ tɨ³ re² bíh¹ hi³ cuánh¹³ hnú² ta³ tiúnh¹ cáun² cuonh² ñí¹ lɨ́¹³ zian² nú² cun³ jmɨ́¹hi³nio², la³ cun³ bíh¹ hi³ cuóh¹³ nú² hi³ chi²¹ tá¹ tun³ cuonh² quiu³juóu³², ñí¹ tiá² lɨ́¹³ yéi³² jáun² sɨ́², ");
INSERT INTO csoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ñí¹ hí¹ jáh¹ tiáunh¹ ngú³ quioh²¹ tsáu² tiú²uú² tsán¹³, hi³ sa³jun³ sɨ́² bíh¹ yéi³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Hi³ nɨ́¹juáh³ tanh¹ nú² jmu² siáh³ hi³ tanh³² nú² tso³, hná¹ siáh³; quí¹ tɨ³ re² bíh¹ hi³ cuánh¹³ hnú² ñí¹ lɨ́¹³ zian² tsú² cun³ jmɨ́¹hi³nio² hi³ tiá² zia³² cáun² tanh¹, la³ cun³ bíh¹ hi³ cuóh¹³ nú² quiu³juóu³² quionh³ tá¹ tun³ tanh¹ nú² ñí¹ tiá² lɨ́¹³ yéi³² sɨ́², ");
INSERT INTO csoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ñí¹ tiá² jáh¹ tsán¹³, hi³ sa³jun³ sɨ́² bíh¹ yéi³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Hi³ nɨ́¹juáh³ mɨ́¹máh¹ hnú² jmu² siáh³ hi³ tanh³² nú² tso³, chí³ cú²jueh³²; quí¹ tɨ³ re² bíh¹ cuánh¹³ hnú² ñí¹ cuá¹quien² Dió³² cun³quionh³ cá² máɨ³ mɨ́¹máh¹ cha³ jmɨ́¹ cuóh¹³ nú² quiu³juóu³² quionh³ tá¹ tun³ máɨ³ mɨ́¹máh¹, ");
INSERT INTO csoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ñí¹ tiú²uú² tsán¹³ jáh¹ taunh³² ngú³ quioh²¹ tsáu², hi³ sa³jun³ sɨ́² bíh¹ yéi³². ");
INSERT INTO csoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”Quí¹ la³jmɨ́¹ sé²³ tsú² jáun² ñí¹ ñí¹ quioh²¹ jáh³ má²lɨ́²jngɨh³ tsú² ñí¹con² Dió³² ta³ ñeh² bíh¹ hi³ jɨn³ tsú², la³ jáun² bíh¹ siáh³ lɨ́¹³ tiánh³ hua³jan²¹ tsá² taunh² ta²¹ jná¹³, cun³quionh³ hi³ há¹ ngá¹³ tsú² uu³mí²tsɨ³² lɨ́³ la³jmɨ́¹ lɨ́³ sɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Chu²¹ bíh¹ ñí¹; tɨ³la³ nɨ́¹juáh³ la³ ca³lɨ³ máɨh³ bíh¹ ñí¹ né³, ¿ha³ bí¹ lánh³ rón³² lɨ́¹³ jmu³ tsú² siáh³ hi³ lɨ³ ñeh¹? Cuɨ́¹ zia³² ñí¹ hñu³ honh² hnoh², jɨ³ hi³ cuɨ́¹ zian² náh² cáun² hi³ re² hi³ tɨn² quiúnh¹ náh² tsá²ján² tsá²ján². ");
INSERT INTO csoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jmɨ́¹ lɨ²¹ jáun² cua³han³ Jesús já¹ juú² Capernaum, hi³ ngau³ tɨ³ hué¹³ Judea, hué³² nio² tɨ³ juɨ³² ñí¹ hia³² hiú² tɨ³ jo²¹ cua³ Jordán. Ñí¹ cá¹chó²¹ tsú² jáun² né³, ca³ngɨh³² siáh³ juóun³² lɨ́n³² tsáu², hi³ jáun² ca³ma³tɨn² dí² siáh³ tsáu² la³ cun³ qui³ jmu² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jáun² ma³ jan² tsá² *fariseos ca³ja³taunh²¹ ñí¹ zenh¹ Jesús, hi³ ca³ca³ ca³lan³ dí² tsú², hi³ jáun² ca³ngáɨ³ dí² nɨ́¹juáh³ hi³ lɨ́¹³ tsáun³ tsá²ñuh² quionh³ tsá²mɨ³ ñí²cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jmɨ́¹jáun² ca³ngáɨ³ Jesús: ―¿He³ héih³² ca³quiú² hla¹ Moisés ñí¹con² hnoh² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jáun² tsá² hí³ ca³juáh³: ―Moisés ca³cué³ jáɨ¹³ hi³ lɨ́¹³ cuéh³² tsú² tsá²mɨ³ ñí²cuo² cáun² sí² hi³ lin¹ hi³ ca³tsáun³ tsú², hi³ jáun² má²lɨ́¹³ chin¹³ dí² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jáun² Jesús ca³juáh³: ―Moisés ca³cué³ héih³² jáun² cun³ñí¹ hi³ jlánh¹ tiá² jáɨ¹³ ngɨ²³ hnoh² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Tɨ³la³ la³ cun³ jmɨ́¹ ca³lɨ³liau³, jmɨ́¹ ca³jmú³ Dió³² la³cu³ la³juéh³ mɨ³cuú²: “Tsá²mɨ³ tsá²ñuh² bíh¹ ca³jmú³ Dió³²; ");
INSERT INTO csoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","hi³ jáun² bíh¹ chan³ tsá²ñuh² jméi² mí¹ziú¹³ tɨ³ có³² hi³ ma³zian² cu³lɨ²¹ quionh³ tsá²mɨ³ ñí²cuo², ");
INSERT INTO csoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","hi³ jáun² la³juah²¹ dúh¹ jan² tsáu² bíh¹ má²lɨ́n¹³ tsú² tá¹ gon³”. La³nɨ́² bíh¹ rá¹juáh³ ñí¹ Sí², hi³ jáun² né³, tiú²uú² lɨ́³ yáh³ gon³ tsú², quí¹ jan² tsáu² bíh¹ má²lɨ́n³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Cun³ñí¹ hi³ jáun² bíh¹ tiá² ca³tɨn¹ tsá²mɨ³cuóun² tson³ cáun² hi³ má²lɨ́²cunh³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jmɨ́¹ má²tionh² tsú² jáun² ñéih³ né³, tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ngáɨ³ siáh³ ca³tɨ²¹ hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jáun² Jesús ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ tsá² tun²³ tsá²mɨ³ ñí²cuo², hi³ jéinh³² siáh³ cuo² quionh³ tsá²mɨ³ siánh³, tsá² la³ hí³ má²lɨ́²jmú³ tso³ juón¹ bíh¹ ñí¹con² tsá² ca³jan³ la³ñí¹; ");
INSERT INTO csoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","hi³ nɨ́¹juáh³ tsá²mɨ³ siáh³ tun²³ ñí²cuo² hi³ jéinh³² siáh³ cuo² quionh³ tsá²ñuh² siánh³, ja³bí¹ tsá²mɨ³ la³ hí³ siáh³ má²lɨ́²jmú³ tso³ juón¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jmɨ́¹jáun² cua³jan² tsáu² ma³ jan² tsá¹míh¹ ñí¹con² Jesús, hi³ jáun² tin³ tsú² cuo²; tɨ³la³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³ ca³jin³ bíh¹ tsá² ná¹jan² hí³ tsá¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tɨ³la³ jmɨ́¹ ca³jɨ́e³ Jesús hi³ jáun² né³, ca³míh³ bíh¹ tsɨ́³, hi³ jáun² ca³záɨh³ dí² tsá² hí³: ―Cuéh³ náh² tsá¹míh¹ nɨ́² jáɨ¹³, cuɨ́¹ ja³táunh¹ ñí¹con² jná¹³, ha³ lɨ́² jnɨ́² náh² juɨ³² quioh²¹, quí¹ tsá² lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá¹míh¹ nɨ́² bíh¹ lɨ́¹³ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Jú¹ tson² juo³ jná¹³ hnoh², hi³ nɨ́¹juáh³ tsá² tiá² he² héih³² hi³ jmu² Dió³² la³jmɨ́¹ he² tsá¹míh¹, jmɨ́¹lɨ́h³ bíh¹ tiá² chau²¹ jmáɨ¹ hi³ hí³ tsú² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Hi³ jáun² ca³ráɨn³² dí² tsá¹míh¹ hí³, jmɨ́¹jáun² ca³ra³tsɨ³² dí² cuo² ñí¹ quioh²¹ hi³ ca³ma³miih² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jmɨ́¹ ngau²¹ siáh³ Jesús juɨ³² hún¹, jan² tsá²ñuh² ja³ cú²hé² hi³ ca³di³jñí³² ta³ ñí¹ tsú², hi³ ca³juáh³: ―Hnú² Tɨ³² chun¹, ¿he³ bíh¹ hniáuh³² jmu¹ jná¹³ hi³ jáun² lɨ́¹³ lɨ³zian² jná¹³ la³ cun³ jmɨ́¹hi³nio²? ");
INSERT INTO csoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jáun² Jesús ca³záɨh³ tsá² hí³: ―¿He³ láɨh³² juáh³ hnú² hi³ jná¹³ tsá² chun¹? Hí¹ jan² yáh³ tsá² chun¹ tiá² zian², jɨ́³²la³ jan² Dió³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Má²ñíh¹ bíh¹ hnú² la³ cun³ hi³ rá¹juáh³ jáun² héih³² quioh²¹ Dió³², hi³ juáh³ la³ lá²: “Ha³ lɨ́² jngɨh³ náh² tsáu², ha³ lɨ́² jmú² náh² juón¹, ha³ lɨ́² háɨn² náh², ha³ lɨ́² lɨ́¹ ma³tson¹³ náh² jú¹ tɨ́¹jáɨ², ha³ lɨ́² lɨ́¹ ma³can¹³ náh² tsáu², tianh³² náh² ta²¹ ñeh² mí²ziúh²”. ");
INSERT INTO csoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jáun² tsá² hánh³ hí³ ca³juáh³: ―Tɨ³², la³jɨ́³² bíh¹ hi³ nɨ́² má²ca³ma³ti²¹ jná¹³ la³ cun³ jmɨ́¹ míh² ná¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jáun² Jesús ca³jɨ́en³² tsá² hí³ ca³la³ hi³ hnio³ lɨ́n³² dí², jáun² ca³záɨh³ dí² siáh³: ―Cun³ jáun² zia³² bíh¹ cónh³í¹ cáun² hi³ hniáuh³² jmúh¹³ nú²: cuánh², cuá²hnáɨ¹ la³jɨ́³² hi³ zia³² quián¹³, hi³ jáun² tsoh³ quɨe³ jáun² ñí¹con² tsá² tia³mii², hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ lɨ³ hánh³ nú² hñu³mɨ³cuú²; nɨ́¹ má¹lɨ³² jáun² né³, ña³² cu³hna³² jná¹³ uá¹jinh¹ ca³la³ ñí¹ ca³cáɨn³ jmɨ́²chí³ quián¹³ nú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáun² jáɨ¹³ nɨ́², jlánh¹ hlaɨh³ ca³ta³no¹ tsɨ́³, hi³ jáun² ngah³ hi³ hí¹uɨ́n³ tsɨ́³ quí¹hliá² jlánh¹ jmɨ́¹ hánh³. ");
INSERT INTO csoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jmɨ́¹jáun² ca³jɨ́e³ Jesús cu³ jéin³ ñí¹ zenh¹, jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con²: ―¡Hénh³ ma³ jlánh¹ juóuh³² hi³ hí³ jan² tsá² hánh³ jo³cuo² Dió³²! ");
INSERT INTO csoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, lɨ́¹ ca³ja³cáun² tsɨ́³ bíh¹ ca³tɨ²¹ jáɨ¹³ hi³ má²lɨ́²juáh³ tsú² jáun²; tɨ³la³ Jesús ca³juáh³ siáh³: ―Jón³, ¡hénh³ ma³ dá² juóuh³² hi³ tónh³² tsú² jo³cuo² Dió³² nɨ́¹juáh³ tsá² háɨ³² tsɨ́³ hi³ zia³² ñí¹ hué²¹ lá²! ");
INSERT INTO csoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tɨ³ jlánh¹ bíh¹ huán¹ tsɨ́³ ngá¹³ jáh³ cánh¹ téh²³ tsú² camello chí² léh¹³ mɨ³quɨe³ la³ cónh³ bíh¹ hi³ hí³ jan² tsá² hánh³ jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáɨ¹³ nɨ́² né³, ca³ja³cáun² lɨ́n³² bíh¹ tsɨ́³, jáun² ca³ngáɨh³ raɨnh²¹ tsá²ján² tsá²ján², hi³ ca³juáh³: ―Hi³ jáun² né³, ¿hin² bí¹ dá² tsánh² la³ lɨ́¹³ liáun³? ");
INSERT INTO csoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jáun² Jesús ca³jɨ́e³ ñí¹ tionh¹ tsú², hi³ ca³záɨh³ dí² la³ lá²: ―Hnga² Dió³² bíh¹ tɨn² hi³ nɨ́², jun³juáh¹³ tsá²mɨ³cuóun² yáh³; quí¹ hí¹ cáun² yáh³ hi³ juóuh³² tiá² zia³² ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jáun² Pé¹ né³ ca³juáh³: ―Sá¹nɨ́² jɨe³, jnoh¹ má²ca³chá¹³ tɨ³ có³² la³jɨ́³² hi³ jmɨ́¹ zia³² quiú¹³, hi³ jáun² má²ngɨ́¹ jnoh¹ quiúnh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jáun² Jesús ca³ngáɨ³ siáh³: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ jan² tsá² má²ca³tú³ hñú¹³, hi³ má²ca³chan³ siáh³ tsá²mɨ³ jɨ³ tsá²ñuh² raɨnh²¹, jméi² mí¹ziú¹³ tsú², ñí²cuo² tsú², jon² tsú², jɨ³ hi³ má²ca³tú³ tsú² siáh³ ñí¹náɨ² quioh²¹ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ jɨ³ hi³ ca³tɨ²¹ jú¹ chú³² nɨ́² siáh³, ");
INSERT INTO csoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","jáun² tsá² la³ hí³ hiáuh³ bíh¹ ñí¹ hué²¹ lá² hña³láu³ nió³ la³ cónh³ bíh¹ hi³ jmɨ́¹ zia³² jáun² quioh²¹, uá¹la³ cun³: hñú³, raɨnh²¹ tsú² tsá²mɨ³ tsá²ñuh², mí¹ziú¹³ tsú², jon² tsú², jɨ³ ñí¹náɨ² nɨ́² siáh³, uá¹jinh¹ ta³ hó² uo² tsáu²; hi³ jmɨ́¹tsú² jmɨ́¹ja³² né³, lɨ́¹³ zian² tsú² siáh³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tɨ³la³ juóun³² tsá² ná¹lɨ́n³ tsá² la³ñí¹ ta³né³², tsá² la³ hí³ dá² lɨ́n¹³ tsá² ñí¹ ca³táuh³ bíh¹ má¹jáun²; hi³ jáun² juóun³² tsá² ná¹lɨ́n³ tsá² ñí¹ ca³táuh³ ta³né³² né³, tsá² la³ hí³ dá² tɨ³ lɨ́n¹³ tsá² la³ñí¹ bíh¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Hi³ jáun² né³, tá¹la³ má²hí¹uú²³ tsú² tɨ³ juú² Jerusalén, ca³ma³liáu³² Jesús hi³ tsau³² uóunh³ ján³ ta³ ñí¹ tsá² haɨn²¹ hí³ tɨ³ con²; jáun² tsá² hí³ má²hí¹ná¹tsá²cáun² tsɨ́³, hi³ tsá² ñí¹ hná¹ jáun² né³, jmɨ́¹ má²hí¹tsá²táunh¹ siáh³ ta³ má²hú¹ cóh²¹ tsɨ́³ cu³hna²¹ tsú². Hi³ jáun² Jesús ca³teh³ siáh³ ñí¹ tɨ³ có³² tá¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con² la³ cun³ qui³ tan² jmu², hi³ jáun² ca³ma³liáu³² dí² hi³ zaɨh³² tsú² he³ lánh³ quiunh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Hi³ ca³juáh³ la³ lá²: ―Sá¹nɨ́² jɨe³, ta³né³² má²hí¹uú²³ dí² tɨ³ já¹ juú² Jerusalén, ñí¹ jɨenh³ tsú² jáun² jná¹³ Jon² tsá²mɨ³cuóun² ñí¹con² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́² siáh³; hi³ jáun² tsá² hí³ jmu³ héih³² hi³ ma³nga² tsú² jná¹³ hi³ jɨenh³ dí² siáh³ ñí¹con² *tsá²cá²jo²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jáun² tsá²cá²jo²¹ né³, qui³ cáuh³² jná¹³ cú²nga¹, hi³ tiu³ hñéi³² tsú², jɨ³ hi³ quiu³ po³ tsú², má¹lɨ³² jáun² né³ jngah³ tsú²; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² má¹ná¹, jenh¹³ bíh¹ jná¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jmɨ́¹jáun² tá¹ gon³ jon² Zebedeo, Jacobo quionh³ Juan², ca³ma³janh³² ñí¹ zenh¹ Jesús hi³ ca³juáh³ la³ lá²: ―Tɨ³², hnáu² jnoh¹ hi³ jmúh¹³ hnú² cáun² hi³ chú³² hi³ mɨ́¹³ jnoh¹ ñí¹con² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jáun² Jesús ca³ngáɨ³: ―¿He³ hnáuh² hnoh² hi³ jmu¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jáun² tsá² hí³ né³ ca³juáh³: ―Jmu³ tiá³ hi³ chú³² hi³ lɨ́¹³ tsá¹tauh² jnoh¹ cu³henh¹ hnú², jan² tɨ³ cuá² chu²¹ hi³ jan² siáh³ tɨ³ cuá² cáun¹ nɨ́¹ má¹tɨ³ ñí¹ má²ñi³quien² nú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Tɨ³la³ Jesús né³ ca³ngáɨ³: ―Hnoh² dá² hí¹juáh³ tiá² ñíh¹ bíh¹ náh² he³ ná¹mɨh³². ¿Hí¹ quɨnh¹ náh² jmáɨ¹ hi³ há¹ ngá¹³ náh² la³ cun³ hi³ há¹ ngá¹³ jná¹³, jɨ³ hi³ zón³² náh² siáh³ jmáɨ² hi³ má¹tsoh¹ honh² la³jmɨ́¹ zón²¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","―Ján³, lɨ́¹³ bíh¹ ―ca³juáh³ tsá² hí³. Jáun² Jesús ca³juáh³ siáh³: ―Tson² bíh¹ cu³tí³ há¹ ngá¹³ hnoh² la³ cun³ hi³ há¹ ngá¹³ jná¹³ jɨ³ hi³ zón³² náh² siáh³ jmáɨ² la³jmɨ́¹ zón²¹ jná¹³; ");
INSERT INTO csoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","tɨ³la³ hi³ ca³tɨ²¹ hi³ cuá¹tianh³ náh² cu³hén² jná¹³, jan² cuá² chu²¹ hi³ jan² tɨ³ cuá² cáun¹ má¹ná¹, tiá² ca³tɨn¹ yáh³ jná¹³ cué¹³, quí¹ ñí¹ jáun² má²lɨ́³ hua³jan²¹ hi³ tsa³tiánh² tsá² má²ca³quianh³ hnga² bíh¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jmɨ́¹ ca³náɨ³² tsá² quian³ ñí¹ hná¹ jáun² jáɨ¹³ jáun² né³, ca³míh³ tsɨ́³ ñí¹con² Jacobo quionh³ Juan². ");
INSERT INTO csoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tɨ³la³ Jesús má¹ná¹, ca³teh³ jɨ³lɨn² tsá² hí³ hi³ ca³záɨh³ dí² la³ lá²: ―Hnoh² ná¹ñíh¹ hi³ tsá² ná¹ho² ta²¹ ma³ quin³² ma³ caun³² hué³² jmu² quien² ñí¹con² tsá² zian² hué³² jáun², hi³ jáun² tsá² ná¹quien² hí³ né³, cáun² jmu² héih³² ñí¹con² tsá² tionh² hí³ jo³cuo². ");
INSERT INTO csoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Tɨ³la³ tiá² ca³tɨ²¹ yáh³ hi³ lɨ́¹³ la³ jáun² ja¹ quián¹³ hnoh². Quí¹ nɨ́¹juáh³ tsá² hnió³ lɨ³quien² ja¹ quián¹³ hnoh², hniáuh³² lɨ́n³ tsú² jan² tsá² quian²¹ bíh¹ ñí¹con² tsá² ñí¹ hná¹ jáun²; ");
INSERT INTO csoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","hi³ lɨ³ua³ jan² hnoh² tsá² hnáuh² náh² lɨ́n¹³ tsá² la³ñí¹, hniáuh³² jmúh¹³ náh² hi³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² *tsá² má²dí¹hlánh¹ joh¹ tsá² ñí¹ hná¹ jáun² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Quí¹ hí¹ la³ tɨ³ jná¹³ Jon² tsá²mɨ³cuóun² yáh³ cuan³ ná¹ ñí¹ hué²¹ lá² hi³ ja³ma³con²¹ ná¹ tsáu², jun³juáh¹³ hi³ tɨ³ ma³cáu³² yáh³ tsáu² jná¹³; jɨ³ hi³ cuan³ ná¹ siáh³ hi³ jɨenh²¹ ná¹ huen² hi³ jún³, hi³ lɨ́³ cáun² hmah²¹ ca³tɨ²¹ hi³ lɨ́¹³ liáun³ juóun³² lɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jmɨ́¹ lɨ²¹ jáun² né³, ca³cha³táunh¹ tsú² já¹ juú² Jericó. Jmɨ́¹ má²cuá¹cuá²haɨn³² Jesús já¹ juú² jáun² quionh³ tsá² joh¹, jɨ³ la³ má²quionh³ juóun³² lɨ́n³² tsá² siánh³ siáh³, jmáɨ¹ jáun² jmɨ́¹ cuá¹tón²¹ jan² tsá² ten³ jmáɨ² Bartimeo hú¹ juɨ³², jon² Timeo, hi³ cuá¹mɨ³² cú¹dáɨn³. ");
INSERT INTO csoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jmɨ́¹ ca³náɨ³² tsá² hí³ hi³ má²cuá¹ja³² Jesús Tsá² juú² Nazaret, jmɨ́¹jáun² ca³ma³liáu³² tsú² hóh³² tiá³ hi³ juáh³: ―¡Hnú² Jesús, jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ já² mií³ honh² hnú² ñí¹con² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Juóun³² tsáu² ca³je³ tsá² ten³ hí³, hi³ jmɨ́¹ hnió³ tsú² cuá³² tsá² hí³ ta³máɨh³, tɨ³la³ tsá² ten³ hí³ má¹ná¹, tɨ³ lɨ³mí¹ tiá³ ca³hóh³² bíh¹ hi³ ca³juáh³: ―¡Jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ já² mií³ honh² hnú² ñí¹con² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jmɨ́¹jáun² ca³náu² Jesús hi³ ca³juáh³: ―Cuá²tiéh³ tsá² ó³². Jáun² ca³ñí¹tieh¹ tsú² tsá² ten³ hí³, hi³ jáun² ca³záɨh³ dí². ―Ma³hiún¹³ hnú² honh², náu², má³², quí¹ ó³² dí¹té²³ tsú² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jmɨ́¹jáun² ca³tú³ hmɨh³² hi³ jmɨ́¹ cuá¹jaunh³² hi³ ca³náu² cu³diá²jan² la³ lá² hi³ ngau³ tɨ³ ñí¹ zenh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jáun² Jesús ca³ngáɨ³ hi³ juáh³: ―¿He³ jmɨ́¹ hnáuh² hnú² jmu¹ jná¹³ ñí¹con² nú²? Jáun² tsá² ten³ hí³ ca³ngáɨ³: ―Tɨ³², hnó³² jná¹³ hi³ jnia³ siáh³ mɨ́¹ñi³². ");
INSERT INTO csoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jáun² Jesús ca³záɨh³ tsá² hí³: ―Má²lɨ́¹³ bíh¹ cuánh¹³ hnú², má²laɨn³² bíh¹ hnú² quí¹hliá² lɨ́²cháh¹ nú² cáun² honh². Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³jnia³ siáh³ mɨ́¹ñí¹ tsá² hí³, jáun² ngau³ cu³chin¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jmɨ́¹ má²ja³quián³ chá¹táunh¹ tsú² juú² Jerusalén, ca³cha³táunh¹ tsú² có³² juú² Betfagé jɨ³ Betania, can³² máh³ míh¹ Olivos; jmɨ́¹jáun² ca³zen³ Jesús gon³ tsá² haɨn²¹ hí³ tɨ³ con², ");
INSERT INTO csoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","hi³ ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh² juú² míh¹ nio² tɨ³ chí¹ján³ nɨ́², jáun² nɨ́¹ má¹ca³cha³táunh¹ náh² né³, chanh²¹ náh² jan² lo¹ búh¹ míh¹ hi³ cuá¹hñéih¹, jáh³ hí³ hí¹ jan² tiá² hin² má²ca³ñi³tsɨn¹. Jáun² cuá²zanh¹ náh² jáh³ hí³ hi³ ñá¹jan³² náh² tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nɨ́¹juáh³ zian² tsá² ca³ngáɨ³ ñí¹con² hnoh²: “¿He³ láɨh³² sa³ hnoh² yáh³ ná¹zanh¹ jáh³ nɨ́²?”, jáun² juoh¹ náh² tsú² la³ lá²: “Hliá² má²hniah³ ñí¹con² Tɨ³² Juo¹³ bíh¹ jnoh¹ jáh³, hi³ jáun² la³juɨ³ já¹jon¹ jnoh¹ siáh³ ñí¹ lá²”. ");
INSERT INTO csoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jáun² ja³taunh²¹ bíh¹ tsá² gon³ hí³, hi³ jáun² ca³chanh²¹ tsú² jan² lo¹ búh¹ míh¹ zenh² ja¹ hñú³ hi³ dí¹hñéih¹ cáun² ho³hñú¹³; hi³ jáun² ca³záɨnh³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Hi³ jáun² ma³ jan² tsá² jmɨ́¹ tionh¹ ñí¹ jáun² ca³juáh³: ―¿He³ láɨh³² sa³ hnoh² yáh³ ná¹zanh¹ jáh³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jáun² tsá² hí³ né³ ca³záɨh³ tsú² la³ cun³ rón³² hi³ má²lɨ́²juáh³ jáun² Jesús; jmɨ́¹jáun² ca³cué³ bíh¹ tsú² jáɨ¹³ hi³ tsa³tánh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jáun² ca³ñí¹jan² tsú² lo¹ búh¹ míh¹ hí³ tɨ³ ñí¹ zenh¹ Jesús, hi³ jáun² ca³na³tsɨ́³ dí² ha¹ cu³hna²¹ jáh³, jáun² jmɨ́¹ lɨ²¹ jáun² ca³ñi³tsɨn¹ Jesús jáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Juóun³² tsá² ca³qui³ ca³ja³ ha¹ hú¹ juɨ³², hi³ ma³ jan² né³, ca³quieh³ cuú² ñeh¹ hmá² tsɨ²¹ hué¹³ tsáu² hi³ ca³ja³ siáh³ hú¹ juɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tsá² jmɨ́¹ hí¹tsá²táunh¹ chí¹ján³, jɨ³ tsá² jmɨ́¹ hí¹já²táunh¹ chí¹cáɨn² nɨ́² siáh³ ca³ma³liáu³² hi³ tɨ³ hóh³² tiá³, hi³ juáh³: ―¡Hénh³ ma³ chun¹ Dió³²! ¡Cuɨ́¹ lɨ³quien² bíh¹ Tsá² cuá¹ja³² cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²! ");
INSERT INTO csoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cuɨ́¹ lɨ³quien² bíh¹ Tsá² cuá¹ja³² nɨ́² hi³ hau³ jáɨ¹³ la³jmɨ́¹ ca³hó³ jáun² hla¹ Dá²vi²¹ dí¹hio³ ñú¹deh³ dí²! ¡Hénh³ ma³ chun¹ Dió³² Tsá² cuá³ hñu³mɨ³cuú²! ");
INSERT INTO csoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jáun² né³, hi³ bíh¹ Jesús já¹ juú² Jerusalén, hi³ ca³ñí¹hi³² siáh³ hñu³ cuáh³² chín¹; jmɨ́¹ má²lɨ́²jɨ́e³ tsú² jáun² la³jɨ́³² hi³ zia³² ñéih³ jáun², jmɨ́¹jáun² ngau³ cú²jueh³² juú² Betania quionh³ tsá² quian³tun³ hí³, quí¹ jmɨ́¹ má²ca³hláu³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jmɨ́¹ cá¹jniá²¹ jáun² ca³huén² tsú² juú² Betania, hú¹ juɨ³² jáun² ca³ráun³ ñí¹cuóunh²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ta³ hí¹hún¹ tsú² jáun² juɨ³² ca³jɨ́e³ cáun² hmá² sí² co² chi²¹ ñí¹ uóunh³ hi³ má²tsauh²¹ mu²¹; jáun² ngau³ dí² hi³ ca³ñí¹jɨ́e¹³ hmá² jáun² nɨ́¹juáh³ hi³ haɨ²¹ mɨ³ sí², tɨ³la³ hí¹ cá² máɨ³ yáh³ máɨ³ tiá² ca³choh¹³ tsú², jmáh³la³ mu²¹ bíh¹ hmá² tsɨ²¹, quí¹ jun³juáh¹³ jéin² quioh²¹ mɨ³ sí² yáh³ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jáun² Jesús ca³záɨh³ hmá² sí² jáun² la³ lá²: ―Né³² tɨ³ chí¹ján³ jmɨ́¹lɨ́h³ tiú²uú² hin² cuh³ máɨ³ hi³ jmɨ́¹ ha³ hnú². Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³náɨ³² jáɨ¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jmɨ́¹ lɨ²¹ jáun² ca³cha³táunh¹ tsú² siáh³ já¹ juú² Jerusalén. Jáun² Jesús ca³hi³ siáh³ hñu³ cuáh³² chín¹, hi³ jáun² ca³ma³liáu³² dí² hi³ ca³chu³ ca³huen³ tsá² jmɨ́¹ ná¹hna² jɨ³ tsá² jmɨ́¹ ná¹la³² ñí¹ jáun². Ca³ziu³ ca³cuɨ́³ tsú² mesa quioh²¹ tsá² jmɨ́¹ ná¹zaɨ³² quɨe³ quioh²¹ hué³² siáh³ jɨ³ hmá²sɨ¹ quioh²¹ tsá² jmɨ́¹ ná¹hna² chi³ jáɨ² nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","hi³ hí¹ jan² tsáu² tiú²uú² ca³cuéh³ tsú² jáɨ¹³ hi³ tsa³can³² lio²¹ juɨ³² ñéih³ hiah³² hu²¹ cuáh³². ");
INSERT INTO csoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hi³ jáun² ca³ma³tɨn² tsú² tsáu², hi³ juáh³ la³ lá²: ―Ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Hñu³² jná¹³ dá² jmáɨ²: Hñú³ ñí¹ lɨ́¹³ liéinh³² tsá² zian² tá¹ cáun² hngá¹máh³ Dió³²”. Tɨ³la³ hnoh² né³, tá²hláu² quioh²¹ háɨn² bíh¹ má²ca³jmuh³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hi³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ siáh³ ca³náɨ³² jáɨ¹³ jáun², hi³ jáun² jmɨ́¹jáun² ca³hnauh² tsú² ha³ lánh³ rón³² lɨ́¹³ jngɨh³ Jesús, hliá² jmɨ́¹ juénh² dí², quí¹hliá² la³jɨ́n³² tsáu² bíh¹ jmɨ́¹ ná¹tsá²cáun² tsɨ́³ ca³tɨ²¹ jáɨ¹³ hi³ hɨe³² tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tɨ³la³ jmɨ́¹ ca³niéi² jáun² né³, cua³han³ bíh¹ Jesús já¹ juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jmɨ́¹ cá¹jniá²¹ jáun² ca³nga² tsú² ta³ hú²niéi² juɨ³² ñí¹ chi²¹ hmá² sí² jáun², hi³ jáun² ca³jɨ́e³ tsú² hi³ la³ má²ca³lɨ³ quiéin² bíh¹ ca³la³ tɨ³ chí² jmu². ");
INSERT INTO csoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jmɨ́¹jáun² tsau³ tsɨ́³ Pé¹, hi³ jáun² ca³záɨh³ dí² Jesús: ―Tɨ³², sá¹nɨ́² jɨe³ dúh¹, má²ca³lɨ³ quiéin² máh³ hmá² sí² hi³ ca³jin³² hnú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jáun² Jesús ca³ngáɨ³ la³ lá²: ―Cáun² chá¹ náh² honh² ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Quí¹ jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ jan² tsá² záɨh³² máh³ nɨ́²: “¡Quin³² hnú² ñí¹ nɨ́², hñu³ jmɨ́²miih²¹ cuá²hú³²!”, nɨ́¹juáh³ tiá² hu²¹ yáh³ hliáun³ ñéih³ tsɨ́³ tsú², tɨ³la³ taunh³² tsú² ta²¹ hi³ lɨ́¹³ bíh¹ lɨ³tí³ la³ cun³ hi³ má²lɨ́²juáh³, hi³ jáun² bíh¹ lɨ́¹³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Hi³ jáun² bíh¹ juanh³² jná¹³ ñí¹con² hnoh², hi³ la³jɨ́³² hi³ mɨ́h¹³ náh² ñí¹con² Dió³², nɨ́¹juáh³ hi³ nio² cáun² honh² náh² hi³ má²hian² náh², jáun² la³ jáun² bíh¹ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Hi³ nɨ́¹juáh³ nɨ́¹ má¹ca³lienh¹ náh² Dió³² né³, nɨ́¹juáh³ zian² tsá² ná¹háun³ náh² quiúnh¹, chú³² chíh¹³ náh² honh², hi³ jáun² Ñeh² náh² Tsá² cuá³ hñu³mɨ³cuú² chí¹³ siáh³ tsɨ́³ tsáuh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tɨ³la³ nɨ́¹juáh³ hnoh² tiá² la³ chíh¹³ yáh³ honh², hi³ jáun² ja³bí¹ Ñeh² náh² Tsá² cuá³ hñu³mɨ³cuú² tiá² chí¹³ yáh³ tsɨ́³ tsáuh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jáun² né³, ca³cha³tánh¹ tsú² siáh³ já¹ juú² Jerusalén. Tá¹la³ cuá¹ngɨ³² jáun² Jesús hñu³ cuáh³² chín¹ ca³cua³taunh²¹ tsá² ná¹lɨ́n³ mi³jmú³ ñí¹ zenh¹ tsú², la³ má²quionh³ tɨ³² liei²¹ jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́², ");
INSERT INTO csoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","hi³ jáun² ca³ngáɨh³ dí² Jesús: ―¿Hin² ca³cué³ héih³² hi³ jmuh³² nú² ta²¹ nɨ́²? ¿Hin² tsánh² ca³cué³ jáɨ¹³ hi³ hauh³² hnú² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jáun² Jesús ca³ngáɨ³: ―Ja³bí¹ jná¹³ siáh³ nga¹ cáun² jáɨ¹³ ñí¹con² hnoh²; nɨ́¹juáh³ hi³ ngáɨh¹ hnoh² jáɨ¹³ hi³ nga¹ jná¹³ lá², jáun² má¹jáun² juanh²¹ jná¹³ hi³ hin² tsánh² ca³cué³ jáɨ¹³ hi³ jmu² jná¹³ la³jɨ́³² hi³ lá². ");
INSERT INTO csoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Hin² tsánh² ca³ze³ hla¹ Juan² hi³ cua³zion³ tsáu² jmáɨ²? ¿Hí¹ Dió³², ho³ tsá²mɨ³cuóun² uá¹? Nga³ né³. ");
INSERT INTO csoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tɨ³la³ tsá² hí³ né³, cáun² lɨ́¹ ca³juu³ ca³hlénh³ ja¹ má²tún² hmóu³² bíh¹, hi³ ca³juónh³ la³ lá²: ―Nɨ́¹juáh³ hi³ juáh¹³ dí² hi³ Dió³² bíh¹ ca³ze³ tsú², jáun² tsá² nɨ́² né³ lɨ́¹³ nga³: “Hi³ jáun² né³, ¿he³ láɨh³² sa³ tiá² ta²¹ ca³tianh³² yáh³ náh² tsú²?” ");
INSERT INTO csoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Tɨ³la³ ¿hí¹ lɨ́¹³ za¹³ dí² tsú² hi³ tsá²mɨ³cuóun² bíh¹ ca³ze³? Quí¹hliá² jmɨ́¹ juénh² tsú² ñí¹con² tsáu², quí¹ ñi³² tsú² hi³ la³jɨ́n³² tsáu² bíh¹ ná¹lɨ́n²³ hi³ hla¹ Juan² jmɨ́¹ lɨ́n³ jan² *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Hi³ jáun² cu³tsa³² ca³záɨh³ tsú² cú²jueh³² Jesús: ―Tiá² né¹ yáh³ jnoh¹. Jáun² Jesús né³ ca³juáh³ siáh³: ―Hi³ jáun² sa³jun³ jná¹³ yáh³ juanh²¹ siáh³ hi³ hin² tsánh² ca³cué³ jáɨ¹³ hi³ jmu² jná¹³ la³jɨ́³² ta²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jáun² Jesús ca³ma³liáu³² hi³ liéinh³² tsáu² cun³quionh³ jáɨ¹³ hi³ jmu², hi³ ca³juáh³ la³ lá²: ―Jmɨ́¹ zian² jan² tsá² ca³jñí³ mɨ³ uóun²jɨeh¹³ hué³² quioh²¹; jáun² ca³jmú³ jnɨ́¹³ la³ cu³ la³ jéin³ jáun², hi³ ca³zíh³ siáh³ cáun² ñí¹ lɨ́¹³ quiáuh³² jmaɨh²¹ mɨ³ uóun²jɨeh¹³, jɨ³ hi³ ca³jmú³ tsú² siáh³ cáun² hñú³ ñe¹ lɨ́n²¹ ñí¹ lɨ́¹³ di³chín³² tsá² jmu³ hua³hí¹³ ñí¹náɨ² jáun². Jmɨ́¹ lɨ²¹ jáun² né³, ca³quiú² ñí¹náɨ² jáun² jo³cuo² tsá² lɨ́¹³ jmu³ ta²¹; hi³ jáun² tsá² jmu² hí³ ta²¹ né³, jmɨ́¹ ma³hmah¹ quioh²¹ ñí¹náɨ² jáun² cun³quionh³ hi³ jɨ́enh³² cú¹pih²¹ la³ cun³ hi³ ló³² jáun². Jmɨ́¹ lɨ²¹ jáun² ngau³ ñí¹ uóunh³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ ca³láu² mɨ³ uóun²jɨeh¹³ né³, jáun² ca³zen³ tsú² jan² *tsá² má²dí¹hlánh¹ joh¹ ñí¹con² tsá² ca³cuéh³ tsú² hí³ ñí¹náɨ² jáun², hi³ tsa³máɨ¹ ca³lá² hi³ ca³láu² jáun², la³ cun³ hi³ ca³tɨn¹ tsá² quioh²¹ ñí¹náɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Tɨ³la³ tsá² ná¹jmu² hí³ ta²¹ má¹ná¹, ca³zanh³ bíh¹ tsá² ca³zen³ hí³ tsá² quioh²¹ ñí¹náɨ², hi³ ca³qui³ ca³quiunh³ dí², hi³ jáun² lɨ́¹ haɨ²¹ cuá² ta³ bíh¹ tsú² ca³chanh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jáun² tsá² quioh²¹ ñí¹náɨ² ca³zen³ siáh³ cónh³í¹ jan² tsá² má²dí¹hlánh¹ joh¹; tɨ³la³ tsá² hí³ né³, ca³quiunh³ bíh¹ tsú² ca³la³ ca³cuɨ́h³ chí¹ jɨ³ hi³ ca³tu³ ca³hión³² dí² jú¹ hlah³ jú¹ hó³². ");
INSERT INTO csoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tsá² quioh²¹ hí³ ñí¹náɨ² ca³zen³ siáh³ cónh³í¹ jan² tsáu², tɨ³la³ tsá² hí³ né³ ca³jngɨh³ bíh¹ tsú². Jmɨ́¹ lɨ²¹ jáun² ca³zen³ dí² siáh³ juóun³² tsá² ñí¹ hná¹ jáun²; ma³ jan² tsá² hí³ ca³quiu³ ca³pan³ bíh¹ tsú², hi³ ma³ jan² tsá² hí³ ca³jngɨh³ tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”Jáun² jɨ́³²la³ jon² bíh¹ tsú² jéi³²í¹ jmɨ́¹ zian² jan², tsá² jlánh¹ jmɨ́¹ hnio³ dí² lɨ́n³²; hi³ jáun² tsá² hí³ jon² bíh¹ tsú² ca³zen³ ñí¹ cá¹táuh³, quí¹ jmɨ́¹ lɨ́n²³ dí²: “Cun³ tanh¹³ bíh¹ tsú² ta²¹ jón³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Tɨ³la³ tsá² ná¹jmu² hí³ ta²¹ né³, ca³juu³ ca³hlénh³ ja¹ má²tún² hmóu³² hi³ ca³juónh³ la³ lá²: “Já² tsá² nɨ́² bíh¹ lɨ³quioh²¹ ñí¹náɨ² lá² nɨ́¹ má¹jun² jméi², chú³² cuɨ́¹ jngɨh¹³ dí² tsú², hi³ jáun² lɨ³ quiú¹³ dí² ñí¹náɨ² lá²”. ");
INSERT INTO csoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jáun² ca³zanh³ dí² tsá² hí³ hi³ ca³jngɨh³ dí² tiáunh¹, jmɨ́¹ lɨ²¹ jáun² ca³chin² dí² tɨ³ cheih³² ñí¹náɨ² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jmɨ́¹ lɨ²¹ jáun² ca³ngáɨ³ Jesús ñí¹con² tsá² hí³: ―¿He³ lɨ́n²³ hnoh² jmu³ tsá² quioh²¹ hí³ ñí¹náɨ² ñí¹con² tsá² ca³jmú³ hí³ la³ jáun²? Tsá² hí³ dá² jáunh³ bíh¹, hi³ ja³ma³tsan² tsú² tsá² jmu² hí³ ta²¹ ñí¹náɨ² quioh²¹, hi³ jáun² tsá² siánh³ bíh¹ cuéh³² tsú² cú²jueh³² ñí¹náɨ² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","”¿Tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³² ñí¹ rá¹juáh³ jáun² la³ lá²?: Quɨ́n¹ hi³ tiá² ca³jeih²¹ jáun² tsá² ná¹lɨ́n³ tɨ³² hiah³², ta³né³² má²lɨ́³ cá² máɨ³ quɨ́n¹ hi³ jlánh¹ bíh¹ quien², quɨ́n¹ hi³ hu²¹ cuoh¹ hiah³². ");
INSERT INTO csoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Hi³ nɨ́² dá² ca³jmú³ Juo¹³ bíh¹ dí², cáun² hi³ lɨ́¹³ lɨ³ tsa³cáun² tsɨ́³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jmɨ́¹jáun² ca³lɨ́n¹³ tsú² hi³ ma³tson¹³ Jesús, quí¹hliá² má²ca³lɨ³tsɨn² dí² hi³ jáɨ¹³ ca³tɨn¹ hmóu³² bíh¹ dí² hi³ má²lɨ́²jmú³ tsú² jáun². Tɨ³la³, jmɨ́¹ juénh² bíh¹ tsú² ñí¹con² tsá² ná¹ngɨh³² hí³, hi³ jáun² cáun² lɨ́¹ca³lión³² bíh¹ dí² tsú² cú²jueh³², hi³ jáun² ja³tanh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jmɨ́¹ lɨ²¹ jáun² né³ ca³zen³ tsú² ma³ jan² tsá² *fariseos jɨ³ tsá² cu³ nió³ joh¹ Herodes nɨ́² siáh³, hi³ tsa³ca³ tsa³lian³ dí² Jesús, neh²¹ tiá¹ hléh³² cáun² jáɨ¹³ hi³ lɨ³ lɨ́¹³ tánh³² tso³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tsá² hí³ cua³taunh²¹ hi³ ca³záɨh³ Jesús la³ lá²: ―Hnú² tɨ³², né¹ jnoh¹ hi³ hnú² hɨeh³² jmáh³la³ jú¹ tson² bíh¹, tiá² hɨ³² yáh³ honh² hnú² la³ cun³ hi³ juáh³ tsáu², quí¹ tiá² jmuh³² yáh³ hnú² hi³ jan² quien² hi³ jan² tiá² quien², tɨ³la³ hnú² bíh¹ jan² tsá² hɨeh³² jú¹ tson² hi³ ca³tɨ²¹ juɨ³² quioh²¹ Dió³². ¿Hí¹ ca³tɨ²¹ má¹hmah²¹ jnoh¹ quɨe³ hi³ mɨ³² *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma, ho³ tiá² hniáuh³²? ¿Má¹hmah²¹ jnoh¹, ho³ tiá² má¹hmah²¹? ");
INSERT INTO csoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Tɨ³la³ Jesús má¹ná¹, ca³lɨ³tsɨn² hi³ tsá² hí³ lɨ́n³ la³ cá¹ la³ jéinh¹ bíh¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―¿He³ láɨh³² cá² lau²³ hnoh² jná¹³? Ñá²cán¹ dú¹ cáun² *cú¹tiáu² neh²¹ hi³ jɨe²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jáun² cua³can³² tsú², hi³ jáun² jmɨ́¹ ca³jɨ́e³ Jesús ca³ngáɨ³: ―¿Hin² mɨ³ ñí¹ tá²láɨ¹ ñí¹ lá², hi³ hin² hi³ jmáɨ² tón³² lá² siáh³? Jáun² tsá² hí³ ca³ngáɨ³: ―Quioh²¹ tsá² cuá¹lɨ́n³ mɨ³chí¹ bíh¹ nɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jáun² cuéh³ náh² tsá² cuá¹lɨ́n³ mɨ³chí¹ la³ cun³ hi³ ca³tɨn¹ hiáuh³, hi³ cuéh³ náh² siáh³ Dió³² la³ cun³ hi³ ca³tɨn¹. Jáun² lɨ́¹ ca³ja³cáun² tsɨ́³ bíh¹ tsá² hí³ lɨ³, quí¹hliá² la³ jáun² bíh¹ ca³ngáɨ³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Hi³ jáun² jmɨ́¹jáun² cua³taunh²¹ ma³ jan² tsá² *saduceos hi³ cua³jɨen³ Jesús. Tsá² cu³ nió³ tsá² saduceos hí³ tiá² ta²¹ haɨh²¹ yáh³ hi³ jenh¹³ tsá² má²cá²tsan³; hi³ jáun² bí¹ jlánh¹ ca³ñí¹ngah¹ dí² Jesús jáɨ¹³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Hnú² Tɨ³², ñí¹ liei²¹ quioh²¹ hla¹ Moisés rá¹juáh³ nɨ́¹juáh³ jan² tsá²ñuh² ca³jun³ ta³ tiá² ca³lɨ³zian² jon² quionh³ tsá²mɨ³ ñí²cuo², jáun² tsá²ñuh² dá¹jon²¹ hla¹ hí³ ca³tɨn¹ jan³ siáh³ tsá²mɨ³ hí³, hi³ jáun² lɨ³ zian² jon² hi³ ca³tɨn¹ hla¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Hi³ jáun² né³, jmɨ́¹ zian² cá² mí¹zionh² tsá²ñuh² hi³ jmɨ́¹ ná¹lɨ́n³ quiaun³ má²tún² raɨnh²¹ jan² jméi² mí¹ziú¹³. Tsá² má²ján³ né³ jmɨ́¹ ca³jéinh³² cuo² quionh³ jan² tsá²mɨ³, tɨ³la³ jun³ bíh¹ tsá²ñuh² hí³ ta³ tiá² jon² ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jáun² dá¹jon²¹ bíh¹ tsú² ca³jéinh³² siáh³ cuo² quionh³ tsá²mɨ³ hnáɨ³ hí³, tɨ³la³ ca³jun³ bíh¹ siáh³ tsá² hí³ ta³ tiá² jon² ca³lɨ³zian²; la³ jáun² bíh¹ ca³lɨ³ siáh³ quioh²¹ tsá² ñí¹ má²gáun³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","La³ jáun² bíh¹ ca³lɨ³ quioh²¹ tán¹ quiaun³ tsá² hí³, hí¹ jan² yáh³ tsú² tiá² ca³lɨ³zian² jon² quionh³ tsá²mɨ³ hí³. Ñí¹ cá¹táuh³ jáun² né³, jun³ bíh¹ siáh³ hnga² tsá²mɨ³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jáun² né³, nɨ́¹ má¹tɨ³ ñí¹ ca³jenh¹³ tsú², ¿hin² dá² tsánh² tsá² quiaun³ hí³ lɨ́¹³ ñí²cuo² tsá²mɨ³ hí³, quí¹ tán¹ quiaun³ bíh¹ tsú² ca³jéinh³² cuo² quionh³ tsá²mɨ³ hí³? ");
INSERT INTO csoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jáun² Jesús ca³ngáɨ³ hi³ ca³juáh³ la³ lá²: ―Ná¹tsá²con² lɨ́n³² bíh¹ hnoh², cun³ñí¹ hi³ tiá² cuɨn² náh² Sí² quioh²¹ Dió³² hi³ sa³jun³ pí³ quioh²¹ Dió³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quí¹ nɨ́¹ má¹ca³jenh¹³ tsáu² ja¹ hla¹, tiú²uú² cuo² tsú² jéinh³² yáh³, hi³ sa³jun³ cuen³ bíh¹ tsú² siáh³ jon² hi³ jéinh³² cuo², quí¹ má¹jáun² dá² má²lɨ́n¹³ tsú² la³jmɨ́¹ lɨ́n³ tsá²cuú² tsá²ta³ Dió³² bíh¹, tsá² tionh² hí³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tɨ³la³ hi³ ca³tɨ²¹ nɨ́¹juáh³ hi³ tson² jenh¹³ tsá² má²cá²tsan³ né³, ¿tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ hla¹ Moisés, hi³ ha³ lánh³ lɨ́³ jáɨ¹³ hi³ ca³hléh³ jáun² Dió³² ja¹ hmá² ton² hi³ jmɨ́¹ chí¹cau³² jáun²? Jmɨ́¹ ca³juáh³ tsú² jáun² la³ lá²: “Jná¹³ bíh¹ la³², Dió³² Juo¹³ Há²bran²¹, Isaac jɨ³ Jacob nɨ́² siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Quí¹ Dió³² dá² lɨ́n³ Dió³² Juo¹³ tsá² zian² bíh¹, tiá² lɨ́¹³ yáh³ lɨ́n³ tsú² Dió³² Juo¹³ tsá² má²jun¹; jáun² né³, lɨ́¹ ná¹tsá²con² tɨ³ ca³nga² bíh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ja¹ quioh²¹ tsá² hí³ né³ jmɨ́¹ zenh¹ siáh³ jan² tsá² lɨ́n³ tɨ³² liei²¹, tsá² má²lɨ́²niéi³² jáɨ¹³ hi³ má²lɨ́²juáh³ tsú² jáun². Tsá² hí³ né³ ca³lɨ³tsɨn² hi³ re² bíh¹ má²lɨ́²ngáɨ³ Jesús, hi³ jáun² ca³ngáɨh³ dí² siáh³ la³ lá²: ―¿Hín² bíh¹ héih³² hi³ jlánh¹ bíh¹ quien²? ");
INSERT INTO csoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jáun² Jesús ca³záɨh³ tsá² hí³: ―Hi³ lá² bíh¹ héih³² hi³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ ñí¹ la³jɨ́³²: “Sá¹nɨ́² niéi² hnoh² tsá² *Israel, jɨ́³²la³ jan² tán¹ Dió³² Juo¹³ bíh¹ dí² lɨ́n³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jáun² ¡ma³hno¹ Dió³² Juóuh³² ca³la³ jonh³ jmɨ́¹ honh², la³jɨ́³² jmɨ́²chí³ quián¹³, jɨ³ la³jɨ́³² hi³ lɨ́n²³ nú², jɨ³ ca³la³ jɨ́³² pí³ quián¹³ nú² siáh³!” Hi³ nɨ́² bíh¹ héih³² la³ñí¹ hi³ jlánh¹ bíh¹ quien². ");
INSERT INTO csoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hi³ jáun² héih³² ñí¹ má²tun³ né³ lɨ́³ la³ lá²: “¡Ma³hno¹ tsá²mɨ³cuóun² renh² la³jmɨ́¹ hno³ nú² huen²!” Tiú²uú² zia³² yáh³ cónh³í¹ cáun² héih³² hi³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hi³ tun³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jáun² né³, tɨ³² liei²¹ hí³ ca³juáh³ siáh³ la³ lá²: ―Chú³² lɨ́n³² bíh¹ la³ má²lɨ́²juah²¹ hnú² nɨ́² Tɨ³². Jú¹ tson² bíh¹ nɨ³² má²lɨ́²juah²¹ hnú², hi³ jɨ́³²la³ jan² tán¹ Dió³² bíh¹ zian², hi³ tiá² zian² yáh³ cónh³í¹ jan² Dió³² siánh³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jɨ³ hi³ jlánh¹ bíh¹ quien² hi³ má¹hno¹ dí² Dió³² la³ jonh³ jmɨ́¹ tsɨ́³ dí², la³jɨ́³² hi³ ngɨ²³ dí², la³jɨ́³² jmɨ́²chí³ quiú¹³ dí², jɨ³ la³jɨ́³² pí³ quiú¹³ dí² nɨ́² siáh³; jɨ³ hi³ ca³ta¹ dí² má¹hno¹ siáh³ tsá²mɨ³cuóun² raɨnh²¹ la³jmɨ́¹ hno³ dí² hmóu³², hi³ nɨ́² bíh¹ hi³ tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ jáh³ hi³ jngɨh² tsú² jáun² ñí¹con² Dió³², jɨ³ la³jɨ́³² hi³ lɨ́¹ cue³² tsú² jáun² ñí¹con² Dió³² hi³ jɨn³² tsú² jáun² ñí¹ lɨ́³ ñí¹hiú¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Hi³ jáun² jmɨ́¹ má²lɨ́²niéi³² jáun² Jesús hi³ tsá² hí³ má²lɨ́²ngáɨ³ re² lɨ́n³², jáun² ca³juáh³ dí² la³ lá²: ―Cú¹pih²¹ bíh¹ jéi³²í¹ hniáuh³² hi³ huh²¹ hnú² jo³cuo² Dió³². Hi³ jáun² hí¹ jan² yáh³ tiú²uú² hin² ca³tia³ tsɨ́³ hi³ nga³ siáh³ jáɨ¹³ ñí¹ hná¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús jmɨ́¹ cuá¹má²tɨn² tsáu² hñu³ cuáh³² chín¹, hi³ jmɨ́¹ cuá¹juáh²³ la³ lá²: ―¿He³ láɨh³² juáh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ hi³ jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹ bíh¹ néh¹ Tsá² lɨ́n¹³ Cristo? ");
INSERT INTO csoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Quí¹ hnga² hla¹ Dá²vi²¹ ca³hléh³ la³ cun³ jáɨ¹³ hi³ ca³cué³ Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³, hi³ ca³juáh³ la³ lá²: Dió³² Juóu³² jná¹³ ca³záɨh³ Tɨ³² Juóu³² jná¹³: Tɨ³ cuá² chu²¹ quion²¹ jná¹³ ñí³, ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ jmu¹ jná¹³ hi³ tsá² hau² hnú² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cáun² jlɨ²¹ hi³ hí¹ cú¹pih²¹ tiá² quien² hi³ ná¹tsɨn²¹ hnú² tanh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Hi³ jáun² né³, ¿ha³ bí¹ lánh³ rón³² lɨ́¹³ hi³ Tsá² lɨ́n¹³ Cristo lɨ́n³ jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹?, quí¹ ta³ bí¹ hnga² yáh³ hla¹ Dá²vi²¹ hí³ la³ ca³juáh³ hi³ Juo¹³ bíh¹ tsú² Tsá² lɨ́n¹³ hí³ Cristo. Jáun² tsá² juóun³² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² né³, ca³la³ hi³ hiún² lɨ́n³² bíh¹ tsɨ́³ jmɨ́¹ ná¹náɨ³². ");
INSERT INTO csoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jmɨ́¹ ca³ma³tɨn² Jesús tsá² ná¹ngɨh³² hí³ né³, ca³juáh³: ―Hua³hín¹³ náh² jmu³ quiúnh¹ tsá² ná¹lɨ́n³ tɨ³² liei²¹, quí¹ tsá² hí³ jlánh¹ zaɨn³² hi³ quɨ́h³² hmɨh³² cuo² hi³ ñi³táunh¹ tɨ³ hlá² tɨ³ nɨ́²; jlánh¹ hniá¹ tsú² hi³ tsáu² cuen³ Dió³² nɨ́¹ má¹ca³jenh² dí² ja¹ hmah²¹, ");
INSERT INTO csoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","jlánh¹ hniá¹ tsú² tiánh³ ñí¹ jlánh¹ bí¹ quien² hñu³ cuáh³² quioh²¹, jɨ³ hi³ hniá¹ tsú² siáh³ tiánh³ ñí¹ jlánh¹ bí¹ quien² nɨ́¹ má¹ca³cha³táunh¹ ñí¹ nio² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsá² hí³ bíh¹ tsá² quin²³ sɨ́¹ hñú¹³ tsá²mɨ³ hnáɨ³, hi³ má¹lɨ³² jáun² né³, lɨ́¹ ráɨn³² ñí¹ cun³quionh³ hi³ liéinh³² jáun² Dió³² ué³ lɨ́n³². Cun³ñí¹ hi³ jáun², tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ héih³² hi³ tá¹tsɨn¹ tsú² nɨ́¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cu³ jéin³² jmɨ́¹ cuá¹tón²¹ Jesús có³² ho³hñú¹³ cuáh³² chín¹, có³² ñí¹ táun³ cuó² toh² tsú² quɨe³, hi³ cuá¹jɨ́en³² dí² tsá² toh² quɨe³ ñí¹ jáun²; hi³ jáun² ca³jɨ́e³ tsú² hi³ juóun³² tsá² hánh³ toh² hliáun³ quɨe³ hñu³ cuó² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jmɨ́¹jáun² ca³chó³² jan² tsá²mɨ³ hnáɨ³ tia³mii² hi³ ca³taunh³ tun³ cú¹dáɨn³, quɨe³ tiá² lin¹ nga³ quien². ");
INSERT INTO csoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jmɨ́¹jáun² ca³teh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³záɨh³ dí² la³ lá²: ―Jú¹ tson² cu³tí³ juo³ jná¹³ hnoh², hi³ tsá²mɨ³ hnáɨ³ tia³mii² ó³², tɨ³ hliáun³ bíh¹ má²lɨ́²cué³² tsú² la³ cónh³ bíh¹ la³jɨ́n³² tsá² má²lɨ́²tióh³² quɨe³ hñu³ cuó² ñí¹ hná¹ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Quí¹ la³jɨ́n³² tsá² ñí¹ hná¹ nɨ́² cue³² la³ cun³ hi³ má²ziau³² quioh²¹ bíh¹; tɨ³la³ tsá²mɨ³ tia³mii² ó³² né³, má²lɨ́²cué³² la³jɨ́³² la³ cun³ hi³ jmɨ́¹ zia³² quioh²¹ bíh¹, hi³ jmɨ́¹ má²ma³hau³ hi³ lɨ́¹³ zian² tsú² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ta³ má²cuá¹cuá²haɨn³² Jesús hñu³ cuáh³² chín¹, jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³juáh³: ―Tɨ³², sá¹nɨ́² jɨe³, ¡hénh³ ma³ chú³² jniá³ hñú³ nɨ́², hi³ hen³ ma³ cáh¹ siáh³ quɨ́n¹ hi³ lɨ́³ hiah³²! ");
INSERT INTO csoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tɨ³la³ Jesús ca³ngáɨ³ la³ lá²: ―¿Jɨ́eh²¹ hnú² hi³ jueh³² lɨ́n³² hñú³ lá²? Ñí¹ lá² dá² lɨ́¹³ hi³ hí¹ cá² máɨ³ quɨ́n¹ tiú²uú² ná¹juɨn¹ quionh³ quɨ́n¹ raɨnh²¹; la³jɨ́³² bíh¹ juú¹ tsúnh¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jmɨ́¹jáun² ja³taunh²¹ dí² tɨ³ tsɨ³ máh³ Olivos ñí¹ jniá³ jáun² cuáh³² chín¹. Tá¹la³ má²cuá¹tón²¹ jáun² Jesús ñí¹ jáun² né³, jáun² Pé¹, Jacobo, Juan² jɨ³ Tre²¹ nɨ́² siáh³ ca³ngáɨ³ ñí¹con² tsú² la³ lá² tá¹la³ tiá² hin² zian²: ");
INSERT INTO csoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Hnáu² jnoh¹ hi³ juáh¹³ hnú² ha³ lɨ́h³ lɨ́¹³ hi³ má²lɨ́²juah²¹ hnú² jáun². ¿He³ dá² lánh³ rón³² lɨ³ lin¹ nɨ́¹juáh³ má¹tɨ³ ñí¹ lɨ³tí³ hi³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jáun² Jesús ca³juáh³ la³ lá²: ―Hua³hín¹³ lɨ́n³² náh² jmu³, hí¹ jan² lɨ́² hin² cuɨ́¹ má¹cau² náh². ");
INSERT INTO csoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Quí¹ juóun³² lɨ́n³² tsáu² ja³táunh¹ hi³ ja³jmú³ hi³ lɨ́n³ la³juah²¹ dú¹ jná¹³, hi³ ja³juah²¹: “¡Jná¹³ bíh¹ lɨ́n³ Cristo!”; jáun² juóun³² lɨ́n³² bíh¹ tsáu² ma³can² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Tɨ³la³ nɨ́¹ má¹ca³niéih² náh² jáɨ¹³ hi³ má²zia³² hniéi² tɨ³ hlá² tɨ³ nɨ́², ha³ lɨ́² juenh³ náh², quí¹ la³ jáun² ca³tɨ²¹ lɨ́¹³ bíh¹ tín², tɨ³la³ jun³juáh¹³ hi³ má²tsa³hín³ yáh³ jaun³². ");
INSERT INTO csoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Quí¹ tsá² zian² cáun² hué³² jmu³ hniéi² quionh³ tsá² zian² hué³² siáh³, jɨ³ tsá² hɨ́n¹³ hué³² ñí¹ hliáun³ quiu³ tɨ́n³ siáh³ quionh³ tsá²ján² tsá²ján²; ñí¹ hliáun³ qui³ jɨ́eh³ hué³² hi³ lɨ³ zia³² siáh³ ho³cuóun³, jɨ³ hi³ lɨ́¹ tiáunh¹ tsáu² tiá³ siaun³². Hi³ nɨ́² dá² cun³ ja¹ má²ca³lɨ³liau³ bíh¹ hi³ ma³tso² tsáu² tsɨ́³, jun³juáh¹³ má²hnáu² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”Tɨ³la³ hniáuh³² tiáunh¹ hua³jan²¹ bíh¹ hnoh²; quí¹ hnoh² dá² jɨenh³ tsú² jo³cuo² tsá²tan²¹, jɨ³ hi³ quiu³ po³ tsú² hnoh² la³ tɨ³ hñu³ cuáh³² quiú¹³ dí². Hi³ tsa³jau² tsú² siáh³ hnoh² ta³ ñí¹ tsá² ná¹ho² ta²¹ jɨ³ ta³ ñí¹ tsá² ná¹lɨ́n³ re²¹ nɨ́² siáh³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³; má¹jáun² bíh¹ má²lɨ́¹³ cuéh¹ hnoh² jú¹ tson² hi³ ca³tɨn¹ jná¹³ ñí¹con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ñeh² bíh¹ hi³ táuh³ jmáɨ¹ má¹ná¹, jú¹ chú³² hi³ lɨ́¹³ liáun³ tsú² ca³tɨ²¹ ngáɨ³² tsú² tín² ñí¹con² la³jɨ́n³², la³jáh³ dú¹ ñí¹ juo³ tsá² jma². ");
INSERT INTO csoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nɨ́¹ má¹já²jau² tsú² hnoh² ta³ ñí¹ tsá²tan²¹ né³, ha³ lɨ́² jmú² náh² hɨ³² honh² nɨ́¹juáh³ he³ cuá¹juah²¹ náh² ñí¹ jáun². Quí¹ jmáɨ¹ jáun² dá² cáun² cuá¹hléh¹ hnoh² la³ cun³ jáɨ¹³ hi³ hí³ hñu³ honh² bíh¹ náh²; quí¹ jáɨ¹³ jáun² cué³² Jmɨ́²chí³ Chun¹ bíh¹, jun³juáh¹³ jáɨ¹³ quián¹³ hmóu³² yáh³ náh². ");
INSERT INTO csoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Hí¹ la³ tɨ³ tsá² jan² jméi² mí¹ziú¹³ quionh³ yáh³ tsú² jɨenh³ hi³ jngah³ tsáu², jɨ³ tsá² má²lieih²¹ siáh³ jɨenh³ jon²; jon² tsáu² jmu³ hniéi² quionh³ jméi² mí¹ziú¹³, hi³ hí¹ ca³la³ tɨ³ jɨenh³ yáh³ tsú² tsá² má²lieih²¹ hí³ hi³ jngah³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tsá² zian² tá¹ cáun² hngá¹máh³ bíh¹ lɨ³hau² hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³; tɨ³la³ nɨ́¹juáh³ tsá² nio² cáun² tsɨ́³ la³ má²nio² jáun² ca³la³ tɨ³ ñí¹ cá¹táuh³ jmáɨ¹ né³, tsá² hí³ bíh¹ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Nɨ́¹ má¹ca³jɨeh³ hnoh² hi³ hlah³ hi³ hó³² hi³ jmu³ hi³ hliáh¹³ ñí¹ hɨ́en¹ la³ cun³ hi³ ca³hɨ́e³ jáun² hla¹ Daniel *tɨ³² jë¹ Dió³², má¹ca³jɨeh³ hnoh² hi³ hi³ jáun² má²nio² ñí¹ tiá² jmɨ́¹ ca³tɨn¹ ―nɨ́¹juáh³ tsá² hɨ³² jáɨ¹³ lá², cuɨ́¹ ngɨ¹³―, hi³ jáun² jmáɨ¹ jáun² má²hniáuh³² cuon³ tsá² hɨ́n¹³ tɨ³ Judea ñí¹ lɨ́³ máh³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Hi³ jáun² nɨ́¹juáh³ tsá² cuá¹tsɨ²¹ tsáɨh³ hñú³ máɨ² tsáɨh³ quioh²¹ jmáɨ¹ jáun² né³, ha³ lɨ́² cuɨ́¹ son² hi³ tsa³hen² ñéih³ hi³ tsa³quián³ hi³ nio² ñéih³ quioh²¹, hniáuh³² la³juɨ³² cuon³ bíh¹ tsú²; ");
INSERT INTO csoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","hi³ nɨ́¹juáh³ tsá² cuá¹hún¹ ñí¹náɨ² né³, tiá² hniáuh³² yáh³ tsánh³² tsú² hi³ tsa³quián³ ha¹. ");
INSERT INTO csoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Jlánh¹ juo²³ tsá²mɨ³ tsá² ná¹quian² jon² jmáɨ¹ jáun², jɨ³ tsá² ná¹jan² dáɨn² tiúh²³ nɨ́² siáh³! ");
INSERT INTO csoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mɨ́¹ náh² ñí¹con² Dió³² hi³ ha³ lɨ́² cuɨ́¹ chau²¹ jmáɨ¹ jáun² cáun² jmɨ́¹ ñí¹cuóu³; ");
INSERT INTO csoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","quí¹ jmáɨ¹ jáun² lɨ³ zia³² cáun² uu³mí²tsɨ³² huáh² tsɨ́³ cu³tí¹³, cáun² hi³ hí¹ cónh³ tiá² má²lɨ³² la³ cun³ jmɨ́¹ ca³jmú³ Dió³² hngá¹máh³ lá², hi³ sa³jun³ lɨ³ zia³² bíh¹ siáh³ tɨ³ chí¹cáɨn² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sá¹jmɨ́¹ hi³ Dió³² Juo¹³ dí² tiá² hná³² jmáɨ¹ jáun² dúh¹, jáun² ca³la³ jɨ́n³² bíh¹ tsáu² jmɨ́¹ hiá¹ jmɨ́¹ tsán¹³; tɨ³la³ cun³ñí¹ hi³ hnio³ tsú² tsá² joh¹, tsá² má²ca³quianh³ tsú² hí³ hnga², hi³ jáun² bíh¹ má²ca³hná³ Dió³² jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”Né³² né³, nɨ́¹juáh³ má¹jáun² má²zian² tsá² juáh³ ñí¹con² hnoh²: “¡Sá¹nɨ́² jɨe³, ñí¹ lá² má²cuá³ Tsá² lɨ́n³ Cristo!”, ho³: “¡Sá¹nɨ́² jɨe³, ñí¹ zio¹ má²cuá³!”, ha³ lɨ́² lɨ́¹ táunh³ náh² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Quí¹ juóun³² bíh¹ tsáu² ja³táunh¹ hi³ ja³ma³cau², hi³ juáh³ hi³ lɨ́n³ Cristo, jɨ³ tsá² juáh³ siáh³ hi³ ná¹lɨ́n³ tɨ³² jë¹ Dió³²; hi³ jmu³ siáh³ li²¹ jɨ³ hua³jueh³², hi³ ma³can² tsáu², hi³ hí¹ la³ tɨ³ tsá² má²ca³quianh³ hnga² yáh³ Dió³² ma³can² tsú² siáh³ nɨ́¹juáh³ hi³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tɨ³la³ cuɨ́¹ tiáunh¹ hnoh² hua³jan²¹ lɨ́n²¹; quí¹ la³jɨ́³² bíh¹ má²lɨ́²juo³ jná¹³ hnoh² ta³ tin². ");
INSERT INTO csoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Tɨ³la³ nɨ́¹ má¹ca³nga² uu³mí²tsɨ³² huáh² tsɨ́³ nɨ́² né³, má¹jáun² má²nieh¹³ hiú², hi³ zɨ́h² siáh³ tiú²uú² joh¹ cué³², ");
INSERT INTO csoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","jɨ³ hi³ ziu³ súh³² siáh³ chí¹jmaɨ²¹ haɨ²¹ chi³cuú², hi³ hí¹ ca³la³ tɨ³ pí³ hi³ jniá³ chi³cuú² yáh³ ru³ juá³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Má¹jáun² máh³ jɨ́en³² tsú² Jon² tsá²mɨ³cuóun² hi³ cuá¹jáunh²³ juɨ³² ja¹ jnie² quionh³ pí³ hi³ cáu² hi³ jueh³² lɨ́n³² quioh²¹, hi³ lin¹ hi³ quien² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Má¹jáun² zen³ tsú² tsá²cuú² tsá²ta³ hi³ chan³ cu³lɨ²¹ tsá² má²ná¹quiánh¹ hí³ joh¹, tsá² zian² tá¹ quiún³ cuoh¹ mɨ³cuú², la³ tɨ³ hué³² ñí¹ má²uóunh³, ca³la³ tɨ³ ñí¹ cá¹táuh³ cuoh¹ mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","”Cuɨ́¹ ngɨ¹³ náh² jáɨ¹³ hi³ jmu¹ jná¹³ lá² cun³quionh³ hmá² sí² co²: Jɨ́eh³² hnoh² nɨ́¹juáh³ má²tá¹jmu¹³ hmá², hi³ má²ná¹hion² siáh³ mu²¹ zɨ́h³, jáun² má²ná¹ñíh¹ hnoh² hi³ má²má²janh² bíh¹ jmɨ́¹ ñí²hiú². ");
INSERT INTO csoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ja³bí¹ la³ jáun² bíh¹ siáh³, nɨ́¹juáh³ má²jɨ́eh³² hnoh² hi³ má²lɨ́²³ la³jɨ́³² hi³ má²lɨ́²juánh³² jná¹³ nɨ́², jáun² má²ñíh¹ náh² hi³ ho³hñú¹³ bíh¹ má²zenh² jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jú¹ tson² juo³ jná¹³ hnoh², hi³ la³jɨ́³² hi³ nɨ́² lɨ́¹³, ñeh² bíh¹ hi³ hiá¹ tsán¹³ tsá² zian² jmáɨ¹ hi³ ziáun² dí² lá². ");
INSERT INTO csoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Chau²¹ jmáɨ¹ tsa³hín³ bíh¹ la³jɨ́³² hi³ jniá³ chi³cuú² la³ má²quionh³ hngá¹máh³ lá², tɨ³la³ jáɨ¹³ quion²¹ jná¹³ má¹ná¹, tiá² tón³² jmáɨ¹ tsa³hín³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Tɨ³la³ hi³ ca³tɨ²¹ hín² jmáɨ¹, ho³ hín² la³nió¹ lɨ́¹³ la³ jáun² né³, hí¹ jan² yáh³ tiá² hin² ñi³², quí¹ hí¹juáh³ tsá²cuú² tsá²ta³ Dió³², tsá² tionh² hñu³mɨ³cuú² yáh³ tiá² ñi³², hi³ sa³jun³ hnga² yáh³ Jon² Dió³² ñi³² siáh³; jɨ́³²la³ hnga² bíh¹ Dió³² Jméi² tsú² ñi³². ");
INSERT INTO csoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","”Cun³ñí¹ hi³ jáun² né³, tianh³ náh² ná¹ñí¹ hi³ ná¹ua³hin¹³ náh², jɨ³ hi³ ná¹lienh¹ náh² siáh³ Dió³², quí¹ tiá² ñíh¹ yáh³ náh² ha³ lɨ́h³ chau²¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Quí¹ jmáɨ¹ jáun² lɨ́¹³ la³ lá²: Jan² tsá²ñuh² cua³han³ hñú¹³, hi³ ngau³ ñí¹ uóunh³; tɨ³la³ ñeh² bíh¹ hi³ cua³haɨn³² tsú² má¹ná¹, ca³chá³ tsú² hñú¹³ jo³cuo² tsá² quian²¹, hi³ ma³ quin³² ma³ jan³² ca³cuéh³ dí² ta²¹ hi³ ca³tɨn¹ jmu³, hi³ ca³jmú³ tsú² siáh³ héih³² ñí¹con² tsá² jmu² hua³hí¹³ ho³hñú¹³ hi³ jmu³ re² ta²¹ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Hi³ jáun² ja³bí¹ hnoh² uá²jaɨ³² tianh³ náh² ná¹ñí¹, quí¹ tiá² ñíh¹ yáh³ náh² ha³ lɨ́h³ cuánh³² tsá² hñú¹³, hí¹ cuánh³² cun³ ca³niéi², ho³ cuánh³² cun³ chu³nie², ho³ cuánh³² la³ cun³ ca³hó³ cá¹háu² hi³ ñí¹, ho³lá²dá² tɨ³ nɨ́¹ má¹já²jnia² uá¹; ");
INSERT INTO csoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","su³uú² jáunh²³ tsú² cu³diá²jan² ta³ ná¹cuóun¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","La³ cun³ hi³ juanh³² jná¹³ ñí¹con² hnoh² juo³ jná¹³ siáh³ la³jɨ́n³² tsáu²: ¡Tianh³ náh² ná¹ñí¹ náh²! ");
INSERT INTO csoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tun³ jmáɨ¹ bíh¹ jéi³²í¹ jmɨ́¹ hniáuh²¹ hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹, jmáɨ¹ hi³ cúh² tsá² *judíos *hí³ cuú²miih²¹, la³ cun³ hí¹miih²¹ tiá² tie³ jan² yáh³. Hi³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́² siáh³ ca³hnauh² tsɨ́³ ha³ lánh³ rón³² lɨ́¹³ zanh³ dí² Jesús ta³máɨh³, hi³ jáun² jngɨh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tɨ³la³ jmɨ́¹ ná¹juáh²³ dí²: ―Ha³ tiá² zanh¹³ yáh³ dí² tsú² tá¹la³ jmáɨ¹ má¹ná¹, quí¹ hu³sa³ nɨ́² lɨ́¹ ca³taunh³ tsáu² tiá³ siaun³². ");
INSERT INTO csoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jmɨ́¹jáun² jmɨ́¹ cuá¹tón²¹ Jesús já¹ juú² Betania, hñú¹³ Sí¹mu²¹ tsá² jmɨ́¹ téh²³ tsú² hí³ “tsá² lɨ́n³ *mɨ³ho²¹ péin³”. Tá¹la³ jmɨ́¹ cuá¹tón²¹ jáun² Jesús ñí¹ mesa né³, cuan³ jan² tsá²mɨ³ hi³ quian³² cáun² tse³ míh¹ hi³ lɨ́³ cún¹ tiáu² alabastro hi³ jmɨ́¹ canh², hi³ ha²¹ no¹ má²ró³² chu²¹ lɨ́n²¹, jmaɨh²¹ hngó³² quioh²¹ cáun² há² má²ró³² jmáɨ² nardo, cáun² hi³ hmuh²¹ lɨ́n²¹. Jáun² ca³jó³ tsú² mɨ³láɨ¹ tse³ pih²¹ jáun², hi³ jáun² ca³sé³ dí² no¹ má²ró³² jáun² chí¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma³ jan² tsá² jmɨ́¹ tionh¹ ñí¹ jáun² ca³míh³ tsɨ́³, hi³ jáun² ca³juónh³ la³ lá² ja¹ hmóu³²: ―¿He³ láɨh³² sa³ lɨ́¹ quí² lɨ́¹ hin²³ tsú² no¹ má²ró³² nɨ́² quioh²¹? ");
INSERT INTO csoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","No¹ má²ró³² nɨ́² jmɨ́¹ lɨ́¹³ tsa³hnáɨ¹ lɨ́³ cun³ hnɨ³² nio² hña³láu³ héih³² quɨe³ *cú¹tiáu², jáun² quɨe³ jáun² jmɨ́¹ lɨ́¹³ cuéh³² tsú² tsá² tia³mii². Jáun² ca³ziu³ ca³hɨen³ tsú² tsá²mɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tɨ³la³ Jesús ca³juáh³ la³ lá²: ―Ha³ lɨ́² lɨ́¹ jmú² náh² liúnh¹ ñí¹con² tsú²; ¿he³ láɨh³² ma³tsan¹³ hnoh² tsɨ́³ tsú²? Quí¹ cáun² hi³ chu²¹ bíh¹ la³² má²lɨ́²jmú³ tsú² ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Quí¹ la³jɨ́³² jmáɨ¹ bíh¹ zian² tsá² tia³mii² ja¹ quián¹³ hnoh², hi³ jáun² lɨ́¹³ bíh¹ jmúh¹³ náh² hi³ chú³² ñí¹con² tsú² lɨ³ua³ cáun² jmáɨ¹ hi³ hnáuh² náh² jmúh¹³; tɨ³la³ jná¹³ né³, jun³juáh¹³ jmáɨ¹ ca³la³ jɨ́³² yáh³ cuon¹ jná¹³ ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tsá²mɨ³ nɨ́² má²lɨ́²jmú³ la³ cun³ hi³ lɨ́¹³ lɨ³ jmu³ ñí¹con² jná¹³; quí¹ má²lɨ́²sé³² tsú² jná¹³ no¹ má²ró³² ta³ tin² ñeh² bíh¹ hi³ tsa³haun³ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Quí¹ jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ cáun² ñí¹ tsa³hléh² tsú² jú¹ chú³² tá¹ cáun² hngá¹máh³, ja³bí¹ tsa³chá² tsú² siáh³ la³ cun³ hi³ má²lɨ́²jmú³ tsá²mɨ³ lá², hi³ jáun² chau¹³ tsɨ́³ tsáu² hi³ ca³tɨn¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jáun² né³, jmɨ́¹jáun² ngau³ Judas tsá² ja³ hí³ tɨ³ juú² Queriot, jan² tsá² quian³tun³ joh¹ Jesús, hi³ ca³ñí¹lienh¹³ dí² tsá² ná¹lɨ́n³ mi³jmú³ hi³ jmu³ dí² jáɨ¹³ hi³ jɨenh³ dí² Jesús jo³cuo² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² hí³ jáɨ¹³ jáun² né³, ca³lɨ³ hiún² lɨ́n³² bíh¹ tsɨ́³, jáun² ca³jmú³ tsú² jáɨ¹³ hi³ cué³² quɨe³. Jáun² né³, Judas ca³hnauh² tsɨ́³ ha³ lánh³ rón³² lɨ́¹³ jɨenh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ cua³hlau³ Jmɨ́¹hɨ́en¹, jmáɨ¹ hi³ cúh² tsá² judíos hí³ cuú²miih²¹, la³ cun³ hí¹miih²¹ tiá² tie³ jan², jmáɨ¹ hi³ jngɨh² tsú² jáun² *já¹ziáh² míh¹ ñí¹con² Dió³² ca³tɨ²¹ Jmɨ́¹hɨ́en¹, jáun² tsá² haɨn²¹ hí³ tɨ³ con² Jesús ca³ngáɨ³, hi³ ca³juáh³ la³ lá²: ―¿Ha³ jinh¹ hnáuh² hnú² hi³ tsá¹jmú¹³ jnoh¹ hua³jan²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá² hi³ cúh¹³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jmɨ́¹jáun² ca³zen³ dí² gon³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh² já¹ juú², hi³ jáun² ñí¹ jáun² jenh¹³ náh² jan² tsá²ñuh² quiaun² tse³ ha²¹ jmáɨ². Cuá²táunh¹ náh² cu³chin¹ cu³hna²¹ tsú², ");
INSERT INTO csoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","jáun² hñú³ ñí¹ hen¹³ tsá² hí³, cuá²zéih³ náh² tsá² hñú¹³ la³ lá²: “Tɨ³² Juo¹³ jnoh¹ ñí¹juah²¹: ¿Ha³ jinh¹ lɨ́³ ñéih³ ñí¹ cueh³² tsú² tsáu² quion²¹ jná¹³, ñí¹ lɨ́¹³ cuh²¹ jná¹³ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá² quiúnh¹ jná¹³ tsá² haɨn²¹ tɨ³ con² ná¹?” ");
INSERT INTO csoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jáun² tsá² hí³ tsa³jau² hnoh² cáun² ñéih³ jueh³² ñí¹ tun³ tsɨn¹, ñí¹ má²lɨ́³ re²; ñí¹ jáun² bíh¹ cuá¹jmuh³ hnoh² hua³jan²¹ má³² quiú¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Hi³ jáun² né³, ja³taunh²¹ bíh¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú², hi³ jáun² ca³cha³táunh¹ tsú² já¹ juú², hi³ jáun² ca³lɨ³tí³ bíh¹ la³ cun³ rón³² hi³ má²lɨ́²juáh³ jáun² Jesús; hi³ jáun² ñí¹ jáun² bíh¹ ca³jmú³ tsú² hua³jan²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jmɨ́¹ má²ca³zɨ³² jáun² né³, ca³chó³² Jesús ñí¹ jáun², la³ má²quionh³ tsú² tsá² quian³tun³ joh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tá¹la³ má²tionh² tsú² jáun² ñí¹ mesa hi³ má²ná¹cúh² tsú² má³², jáun² ca³juáh³ Jesús la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ zian² jan² tsá² ná¹cúh²³ dí² lá² quiúnh¹ né³bí¹ jɨenh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jmɨ́¹jáun² jlánh¹ hlaɨh³ ca³niau²¹ tsɨ́³ tsá² hí³, hi³ jáun² ma³ quin³² ma³ jan³² tsú² ca³ngáɨh³ Jesús, hi³ juáh³: ―¿Hí¹ jná¹³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jáun² Jesús né³ ca³juáh³: ―Jan² hnoh² tsá² quian³tun³, tsá² cuh³² jná¹³ cáun² uon² quiúnh¹ bíh¹ jmu³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Quí¹ jná¹³ Jon² tsá²mɨ³cuóun² cuá¹tsau³² bíh¹ hná¹ he² juɨ³² hi³ ca³tɨn¹, la³ cun³ hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³²; tɨ³la³ ¡juo²³ bíh¹ tsá²ñuh² tsá² jɨenh³ jná¹³! Tɨ³ jlánh¹ bíh¹ jmɨ́¹ re² quioh²¹ tsá² hí³ sá¹jmɨ́¹ hi³ cu³tsa³² tiá² ca³lɨ³zian² bíh¹ tsú² cú²jueh³² dúh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tá¹la³ ná¹cúh² tsú² jáun² né³, Jesús ca³can³ hí³ cuú²miih²¹, hi³ jáun² ca³cuéh³ tiá¹hmah¹ Dió³², jmɨ́¹ lɨ²¹ jáun² né³ ca³ca³ dí², hi³ jáun² ca³tsóh³ tsú² ñí¹con² tsá² hí³, hi³ ca³juáh³ la³ lá²: ―Quɨéɨh³ náh², quí¹ hi³ lá² bíh¹ ngú³ quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jmɨ́¹ lɨ²¹ jáun² ca³can³ tsú² siáh³ cáun² copa, hi³ jáun² ca³cuéh³ tiá¹hmah¹ Dió³²; jmɨ́¹ lɨ²¹ jáun² né³, ca³nga³ dí² siáh³ ñí¹ tionh¹ tsá² hí³, hi³ jáun² ca³la³ jɨ́n³² bíh¹ tsú² ca³hɨnh³ hi³ jmɨ́¹ ha²¹ jáun² copa. ");
INSERT INTO csoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Hi³ nɨ́² bíh¹ jmɨ́²hán¹ jná¹³ hi³ táɨn³² cun³ñí¹ hi³ ca³tɨn¹ juóun³² tsáu²; la³ jáun² bíh¹ lɨ³ lin¹ hi³ má²quien² cáun² nió³² hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ tiú²uú² aɨh²¹ yáh³ jná¹³ mu² ráu³ mɨ³ uóun²jɨeh¹³ lá², ca³la³ tɨ³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ aɨh²¹ jná¹³ mu² ráu³ lin¹³ cu³lɨ²¹ quiúnh¹ hnoh² máh³, jmáɨ¹ hi³ má²cuá¹ho² jná¹³ jáɨ¹³ cun³quionh³ héih³² quioh²¹ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jmɨ́¹ lɨ²¹ jáun² né³, ca³hɨ́e³ tsú² cáun² sun¹ quioh²¹ Dió³², hi³ jáun² jmɨ́¹ lɨ²¹ jáun² ja³taunh²¹ tɨ³ máh³ Olivos. ");
INSERT INTO csoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―La³jɨ́n³² bíh¹ hnoh² tianh¹³ tɨ³ có³² ca³tɨn¹ jná¹³ já¹niéi² lá²; quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Jngɨh²¹ jná¹³ Tsá² jmu² hua³hí¹³ *já¹ziáh², hi³ jáun² já¹ziáh² hí³ né³ lɨ́¹ tiú¹ lɨ́¹ hán¹ bíh¹ lɨ́¹³”. ");
INSERT INTO csoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tɨ³la³ nɨ́¹ má¹ca³jenh¹³ jná¹³ jáun² má¹ná¹, ñih²¹ jná¹³ chí¹ján³ la³ cun³ bíh¹ hnoh² tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Hi³ jáun² Pé¹ né³, ca³juáh³ la³ lá²: ―Uá¹jinh¹ la³jɨ́n³² tsá² ñí¹ hná¹ lá² ca³ta³tonh¹ tɨ³ có³² ñí¹con² hnú², tɨ³la³ jná¹³ má¹ná¹, ¡cun³ tiá² jáun² yáh³! ");
INSERT INTO csoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tɨ³la³ Jesús né³ ca³záɨh³ Pé¹ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnú², hi³ já¹niéi² lá² bíh¹ cánh³², ñeh² bíh¹ hi³ hau³ tenh³ jéin³² cá¹háu² juáh¹³ hnú² hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Tɨ³la³ hí³ né³, ca³jmú³ pin³ jë¹ hi³ ca³juáh³: ―Uá¹jinh¹ ca³la³ tɨ³ jmɨ́²chí³ quion²¹ yáh³ jná¹³ ca³cáɨn³, hi³ jún³ jná¹³ cu³lɨ²¹ quiúnh¹ hnú², cun³ tiá² zeih²¹ bíh¹ jná¹³ hnú² tɨ³ có³². Hi³ jáun² la³jɨ́n³² bíh¹ tsá² ñí¹ hná¹ hí³ ca³juáh³ cá²ren². ");
INSERT INTO csoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jmɨ́¹jáun² ca³cha³táunh¹ tsú² cáun² ñí¹ téh²³ tsú² Getsemaní, jáun² Jesús ca³záɨh³ tsá² haɨn²¹ hí³ tɨ³ con²: ―Tianh³ hnoh² ñí¹ lá² tá¹la³ ñí¹lienh¹ jná¹³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jáun² jɨ́³²la³ gáun³ tsáu² bíh¹ ca³jan³ tsú²: Pé¹, Jacobo jɨ³ Juan² nɨ́² siáh³; jmɨ́¹jáun² ca³lɨ³liau³ hi³ ca³ta³no¹ hlaɨh³ lɨ́n²¹ tsɨ́³ tsú², jɨ³ hi³ ca³la³ hi³ ca³hu³ ca³jngɨh³ lɨ́n³² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Jáun² ca³záɨh³ dí² tsá² gáun³ hí³ la³ lá²: ―Jlánh¹ ñí¹jún³ jná¹³ lɨ́²³ cun³ñí¹ hi³ ja³²lɨ³ hlaɨh³ nio² tsɨn³². Tɨ³la³ hnoh² tianh³ náh² ná¹ñí¹ ñí¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jáun² né³ Jesús ngau³ ca³lá² tɨ³ chí¹ján³, jáun² ca³jmú³ cuá¹jñi²³ hi³ ca³hiéih³ ñí¹ la³ tɨ³ hué³² hi³ ca³mɨ́³ dí² ñí¹con² Dió³² nɨ́¹juáh³ hi³ lɨ́¹³ hi³ tiá² há¹ tiá² ngá¹³ dí² la³ cun³ hi³ né³bí¹ lɨ́¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","―Hnú² Tia²¹ ―ca³zaɨh³ dí² Jméi²―, tiá² hi³ zia³² yáh³ hi³ juóuh³² ñí¹con² hnú², liau¹ tiá³ jná¹³ ca³tɨ²¹ jmáɨ² tsɨ́h³² hi³ ca³tɨn¹ jná¹³ aɨh²¹; tɨ³la³ ha³ lɨ́² cuɨ́¹ lɨ́¹³ la³ cun³ hi³ hnó³² jná¹³ má¹ná¹, cuɨ́¹ lɨ́¹³ bíh¹ la³ cun³ hi³ hnáuh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jmɨ́¹ lɨ²¹ jáun² ngah³ dí² tɨ³ ñí¹ tionh¹ jáun² tsá² gáun³ hí³, jáun² sa³ ná¹cuóun¹ bíh¹ tsá² hí³ jmɨ́¹ cá¹chánh²¹ dí²; jáun² ca³záɨh³ dí² Pé¹: ―Sí¹mu²¹, ¿hí¹ rá²cuóun¹ uá¹ nú²? ¿Hí¹ hí¹juáh³ cu³tiá³ uá¹ tiá² ca³tion¹³ hnú² hi³ ñíh¹³ ñi³ñí¹? ");
INSERT INTO csoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tianh³ náh² ná¹ñí¹ hi³ lienh¹ náh² siáh³ Dió³², hi³ jáun² tiá² lɨ́¹³ tánh³² náh² tso³. Quí¹ hua³jan²¹ lɨ́n²¹ bíh¹ hún¹ jmɨ́²chí³ quián¹³ náh², tɨ³la³ ngú³ quián¹³ bí¹ náh² jlánh¹ tiá² pin³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jmɨ́¹jáun² ngau³ tsú² siáh³ hi³ ca³ñí¹lienh¹³ Dió³² la³ cun³ hi³ má²lɨ́²juáh³ tsú² jáun² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jáun² cuanh³ tsú² siáh³, sa³ siáh³ bíh¹ siáh³ má²ná¹cuóun¹ tsá² hí³ jmɨ́¹ cuanh²¹ dí², quí¹ cun³ñí¹ hi³hliá² jlánh¹ má²tioh³ ziú³ ñí¹ tsú². Jáun² tiá² ñi³² he³ nga³ bíh¹ tsú² lɨ³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jáun² ngau³ tsú² siáh³ ñí¹ má²tɨ³² hnaɨh³² jéin³²; jmɨ́¹ cuanh²¹ tsú² jáun² né³ ca³juáh³: ―¿Hí¹ la³ má²tionh² jáun² uá¹ hnoh² tie³ hi³ ná¹cuóun¹ náh²? Má²tioh²¹ bíh¹ cu³ nɨ́², má²cá²chó³² bíh¹ jmáɨ¹ hi³ jɨenh³ tsú² Jon² tsá²mɨ³cuóun² jo³cuo² tsá² ná¹ren² tso³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nú¹ tianh³ náh², ma³tsáu¹³; quí¹ nɨ́² bíh¹ má²cuá¹ja³² tsá² jɨenh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² bíh¹ Jesús cuan³ Judas, jan² tsá² jmɨ́¹ lɨ́n³ tsá² quian³tun³ joh¹ tsú², hi³ má²hí¹quionh³ juóun³² lɨ́n³² tsá² ná¹quian³² mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ jɨ³ tsá² ná¹quian³² hmá² nɨ́² siáh³. Tsá² hí³ dá² hí¹já²táunh¹ hi³ zéi¹ tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tɨ³² liei²¹, jɨ³ hi³ ca³tɨn¹ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas tsá² ca³jɨenh³ hí³ bíh¹ Jesús ca³jmú³ jáɨ¹³ ha³ lánh³ rón³² hɨen³ dí² Jesús, hi³ ca³juáh³ la³ lá²: “Nɨ́¹juáh³ tsá² ca³hen³ jná¹³ ñí¹, tsá² hí³ bíh¹ jan¹³ náh² hi³ tson³ ca³la³ ja¹ uá¹ dí¹cho¹”. ");
INSERT INTO csoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jmɨ́¹ cá¹chó²¹ tsú² jáun² né³, ngau³ ñí¹con² Jesús, hi³ juáh³ la³ lá²: ―Hia² nú² Tɨ³². Hi³ jáun² ca³hen³ dí² ñí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","La³ cun³ jmɨ́¹jáun² bíh¹ ca³zanh³ tsá² cuá²taunh²¹ hí³ Jesús, hi³ ca³jan³ dí² tson³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tɨ³la³ jan² tsá² jmɨ́¹ zenh¹ ñí¹ jáun² né³, ca³chí² mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ quioh²¹, hi³ ca³jmú³ cu³ ngá¹³ mí¹táɨ³ cuá¹ jan² *tsá² má²dí¹hlánh¹ joh¹ mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jáun² Jesús ca³záɨh³ tsá² tionh² hí³: ―¿Hí¹ má²ñá²taunh²¹ hnoh² hi³ ná¹quiánh¹ náh² mí¹táɨ³ jɨ³ hmá² nɨ́² hi³ jau¹³ náh² jná¹³ hi³ tson³, la³jmɨ́¹ lɨ́³ hi³ jná¹³ bíh¹ jan² tsá² háɨn²? ");
INSERT INTO csoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jmáɨ¹ ca³la³ jɨ́³² bíh¹ jmɨ́¹ cuon¹ jná¹³ ja¹ quián¹³ hnoh², hi³ jmɨ́¹ ma³ta¹³ jná¹³ hnoh² hñu³ cuáh³² chín¹, tɨ³la³ hí¹ cónh³ yáh³ tiá² lɨ́¹ ca³ziaunh² náh² jná¹³ hi³ tson³ ná¹. La³ nɨ́² dá² lɨ́²³ hi³ jáun² lɨ³tí³ la³ cun³ hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jáun² né³, hnga² bíh¹ Jesús jéi³²í¹ ca³ta³zanh¹, quí¹ ca³cuóun³ bíh¹ la³jɨ́n³² tsá² haɨn²¹ hí³ tɨ³ con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tɨ³la³ jan² tsá² tsá¹ñú¹ jmɨ́¹ hí¹tsau³² cu³chin¹ hi³ chí¹tsaɨnh³² cáun² hmɨh³² tiáu², hi³ jáun² ca³zaunh³ tsáu²; ");
INSERT INTO csoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tɨ³la³ tsá² hí³ né³, cáun² ca³tú³ bíh¹ hmɨh³² jáun², hi³ jáun² ca³cuóun³ láun³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jmɨ́¹jáun² ca³ñí¹jan² tsú² Jesús ta³ ñí¹ tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹; jáun² jmɨ́¹jáun² ca³cuú² ca³ngɨh³² la³jɨ́n³² tsá² ná¹lɨ́n³ mi³jmú³, tsá²daun³² tsá² ná¹ñí¹ juú² jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jáun² Pé¹ né³, ngau³ ca³lá² sáh³ chí¹cáɨn² ñí¹ uóunh³, ca³la³ ñí¹ cá¹chó²¹ ñí¹ lɨ́³ ñéih³ ñí¹ lɨ́¹ hó²¹ hñú¹³ mí²tsá² hɨ́en¹, jáun² ca³cuá³ can³² sɨ́² quionh³ tsá²cuú² tsá²ta³ mí²tsáu² hi³ cuá¹chóh²³ sɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hi³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ la³jɨ́n³² tsá² ná¹ñí¹ nɨ́² siáh³ ca³hnauh² jáɨ¹³ he³ lánh³ rón³² lɨ́¹³ ma³tson² dí² tsáu¹³ Jesús, hi³ jáun² lɨ́¹³ jngɨh³ dí²; tɨ³la³ tiá² ca³choh¹³ yáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Juóun³² tsáu² ca³chá³ jú¹ tɨ́¹jáɨ² quioh²¹ tsú², tɨ³la³ lɨ́¹ jmɨ́¹ ná¹quiú² ná¹táɨnh²³ bíh¹ tsú² jáɨ¹³ tsá²ján² tsá²ján². ");
INSERT INTO csoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jmɨ́¹ lɨ²¹ jáun² né³, ma³ jan² tsáu² ca³nu³ ca³tiánh³ hi³ ca³chá³ tso³ tɨ́¹jáɨ², hi³ ca³juáh³: ");
INSERT INTO csoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Jnoh¹ má²ca³náɨ¹³ hi³ juáh³ tsá² nɨ́² la³ lá²: “Jná¹³ tsunh²¹ hñú³ hɨ́en¹ lá² hi³ ca³jmú³ tsáu² cun³quionh³ cuá² ta³, hi³ jáun² ñí¹ má²cá²hnɨ́² jmáɨ¹ bíh¹ má²dí¹láɨ¹ siáh³, tɨ³la³ jun³juáh¹³ uá² lɨ́³ cun³quionh³ cuá² ta³ tsá²mɨ³cuóun² yáh³”. ");
INSERT INTO csoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tɨ³la³ sa³jun³ la³ jáun² yáh³ ca³jmú³ tsú² cá²hon³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jáun² né³, tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹ ca³náu² ja¹ tsá² ná¹ngɨh³² hí³, hi³ ca³ngáɨ³ ñí¹con² Jesús: ―¿Hí¹ hí¹ cá² jon¹ uá¹ tiá² la³ ngáɨh¹ hnú²? ¿He³ dá² nɨ³² ná¹juáh²³ tsá² nɨ́² hi³ ca³tɨn¹ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Tɨ³la³ Jesús má¹ná¹, tie³ bíh¹ ca³náu², la³ má² tiá² nga² jáun² bíh¹ hí¹ cáun². Jáun² tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹ ca³ngáɨ³ siáh³ cónh³í¹ cu³ jéin³², hi³ ca³juáh³: ―¿Hí¹ hnú² dá² Tsá² lɨ́n³ Cristo Jon² Dió³² Tsá² hɨ́en¹? ");
INSERT INTO csoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jáun² Jesús ca³juáh³: ―Ján³, jná¹³ bíh¹ hí³. Hi³ jáun² hnoh² jɨen¹ náh² hí³ dí² Jon² tsá²mɨ³cuóun² hi³ má²cuá¹tón²¹ tɨ³ cuá² chu²¹ quioh²¹ Dió³² Tsá² cú² Tsá² juenh², hi³ jɨen¹ náh² tsú² siáh³ hi³ má²cuá¹jáunh²³ hñu³mɨ³cuú² juɨ³² ja¹ jnie². ");
INSERT INTO csoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jmɨ́¹jáun² ca³ca³ mí²tsá² hɨ́en¹ ha¹ hi³ jmu² lin¹ hi³ tiá² tɨ³² tsɨ́³ jáɨ¹³ jáun², hi³ juáh³ la³ lá²: ―¿He³ láɨh³² sa³ ca³lɨ³í¹ tsá² zíh³² jú¹ tson² hno³ dí²? ");
INSERT INTO csoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Quí¹ nɨ́² bíh¹ má²lɨ́²niéih² hnoh² ha³ lánh³ rón³² chú² lén³² tsá² nɨ́² Dió³²; jáun² né³, ¿he³ lánh³ lɨ́n²³ hnoh² ta³né³²? Jáun² la³jɨ́n³² bíh¹ tsá² ná¹ngɨh³² hí³ ca³juáh³ hi³ ca³tɨn¹ tsú² jún³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hi³ jáun² jmɨ́¹jáun² ma³ jan² tsáu² ca³ma³liáu³² hi³ tiú² hñéi³², hi³ ca³jnɨ́³ dí² siáh³ ñí¹ tsú², hi³ jáun² ca³quiu³ ca³pan³ dí², hi³ ca³záɨh³ dí² la³ lá²: ―¡Chí³ jáɨ¹³ neh²¹ hin² tsánh² lɨ́²po³! Hi³ jáun² tsá²cuú² tsá²ta³ mí²tsáu² ca³jau³ tsú² ca³la³ hi³ má²quiú² má²po²³. ");
INSERT INTO csoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tá¹la³ jmɨ́¹ cuá¹tón²¹ jáun² Pé¹ tɨ³ la³ quián³ ñéih³ ñí¹ lɨ́¹ hó²¹ jáun², jáun² ñí¹ jáun² ca³chó³² jan² tsá²mɨ³ quian²¹ mí²tsá² hɨ́en¹; ");
INSERT INTO csoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","jmɨ́¹ ca³jɨ́e³ tsú² hi³ cuá¹chóh²³ Pé¹ sɨ́², jáun² ca³jɨ́en³² dí² chí¹tiá³ ñí¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Ja³bí¹ hnú² jmɨ́¹ ngɨ́h¹ quiúnh¹ Jesús hná¹ tsá² Nazaret ó³². ");
INSERT INTO csoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Tɨ³la³ Pé¹ né³, tiá² ca³ton³ yáh³, hi³ ca³juáh³: ―Hí¹juáh³ tiá² cuóun³² yáh³ jná¹³ tsú², hi³ sa³jun³ ngɨ²³ yáh³ jná¹³ jáɨ¹³ hi³ dí¹juáh²³ hnú² nɨ́². Jmɨ́¹jáun² cua³han³ tsú² cheih³² tɨ³ juɨ³² ñí¹ taunh³² tsú²; tá¹la³ jáun² né³ ca³hó³ jan² cá¹háu². ");
INSERT INTO csoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jáun² tsá² quian²¹ hí³ ca³jɨ́e³ siáh³ cónh³í¹ cu³ jéin³² hi³ ca³ma³liáu³² hi³ zaɨh³² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² la³ lá²: ―Jan² tsá² ja¹ quioh²¹ tsá² ó³² bíh¹ tsá²ñuh² lá². ");
INSERT INTO csoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tɨ³la³ Pé¹ né³, siáh³ bíh¹ siáh³ tiá² ca³ton³. Má²cu³lé³ míh¹ jáun² siáh³ ca³juáh³ tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² hi³ ca³záɨh³ Pé¹: ―Tson² bíh¹ cu³tí³ hi³ hnú² bíh¹ jan² tsá² ja¹ quioh²¹ tsá² ó³², quí¹ hnú² bíh¹ jan² tsá² Galilea, quí¹ la³jmɨ́¹ hleh³² tsá² hɨ́n¹³ tɨ³ ñí¹ jáun² bíh¹ hléh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tɨ³la³ Pé¹ né³, ca³hɨen³ Dió³² ca³la³ hi³ tanh² hú¹mu³héih³² hnga², hi³ ca³juáh³ la³ lá²: ―Hí¹juáh³ tiá² cuóun³² yáh³ jná¹³ tsá²ñuh² tsá² ná¹hɨen²³ hnoh² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","La³ cun³ jmɨ́¹jáun² siáh³ ca³hó³ jan² cá¹tsó³ hi³ má²tɨ³² tenh³ jéin³². Jmɨ́¹jáun² tsau³ tsɨ́³ Pé¹ la³ cun³ hi³ ca³záɨ³ jáun² Jesús jmɨ́¹ ca³juáh³ tsú² jáun² la³ lá²: “Ñeh² bíh¹ hi³ hau³ cá¹háu² tenh³ jéin³², hnú² juáh¹³ hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³”. Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³hi³ cúh² tsɨ́³ Pé¹, hi³ ca³hó³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jmɨ́¹ má²já²jnia² jáun² né³, ca³cuú² ca³ngɨh³² siáh³ tsá² ná¹lɨ́n³ mi³jmú³ quionh³ tsá²daun³² tsá² ná¹ñí¹ juú², tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ la³jɨ́n³² tsá² ná¹quien² nɨ́² siáh³, hi³ ca³ma³re² tsú² jáɨ¹³. Jáun² ca³hñéi³² dí² Jesús hi³ ca³ñí¹jan² dí² ñí¹con² Pilato. ");
INSERT INTO csoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jmɨ́¹jáun² ca³ngáɨ³ Pilato: ―Hí¹ hnú² uá¹ lɨ́n³ nú² Re²¹ Juo¹³ tsá² *judíos? Jáun² Jesús ca³juáh³: ―Ján³, tson² bíh¹ la³ juáh³ hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jáun² tsá² ná¹lɨ́n³ mi³jmú³ né³ jlánh¹ ca³qui³ ca³chá³ hliáun³ ñí¹ tso³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jáun² Pilato ca³ngáɨ³ siáh³ hi³ ca³juáh³: ―¿Hí¹ hí¹ cá² jon¹ uá¹ tiá² hi³ ngáɨh¹ hnú²? Sá¹nɨ́² jɨe³, cónh³ bíh¹ tiá² tí³ tso³ hi³ cha³² tsú² quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tɨ³la³ Jesús cun³ jáun² tiá² hi³ ca³ngáɨ³ hí¹ cáun² bíh¹; hi³ jáun² Pilato lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Hi³ jáun² né³, Pilato jmɨ́¹ tan² hi³ lión³² jan² tsá² tson³ tá¹la³ *Jmɨ́¹hɨ́en¹ nɨ́¹juáh³ hin² tsánh² mɨ³² tsáu² hi³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Jmɨ́¹jáun² jmɨ́¹ zian² jan² tsá² jmɨ́¹ cuá¹hún¹ hñu³mí¹ñí², tsá² jmáɨ² Barrabás quionh³ tsá² siánh³ siáh³, tsá² jmɨ́¹ má²ca³jngɨh³ tsáu² jmáɨ¹ hi³ ca³taunh³ tiá³ siaun³² hi³ ca³jmú³ quien² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jáun² cua³taunh²¹ tsáu² ñí¹con² Pilato hi³ ca³hiu³ ca³mɨ́³ tsú² hi³ jmu³ Pilato la³ cun³ hi³ qui³ tan² jmu². ");
INSERT INTO csoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Hi³ jáun² Pilato ca³ngáɨ³ ñí¹con² tsá² hí³ hi³ ca³juáh³: ―¿Hnáuh¹ hnoh² hi³ lion¹ jná¹³ Re²¹ Juóuh³² hnoh² tsá² judíos? ");
INSERT INTO csoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quí¹hliá² jmɨ́¹ má²ca³lɨ³tsɨn² bíh¹ Pilato hi³ cun³ñí¹ hi³ uóu³² tsɨ́³ bíh¹ tsá² ná¹lɨ́n³ hí³ mi³jmú³ hi³ jáun² ñí¹con² hí³ dí² cua³jan² tsú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Tɨ³la³ tsá² ná¹lɨ́n³ hí³ mi³jmú³ né³, jlánh¹ tiá³ siaun³² ca³jmú³ ñí¹con² tsáu², hi³ jáun² hiu³ mɨ́³² tsú² hi³ Barrabás bíh¹ tɨ³ re² lión³² dí². ");
INSERT INTO csoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jmɨ́¹jáun² ca³ngáɨ³ siáh³ Pilato: ―¿Hi³ he³ bí¹ hnáuh² náh² jmu¹ jná¹³ ñí¹con² Tsá² teh³² náh² lá² Re²¹ Juóuh³² hnoh² tsá² judíos? ");
INSERT INTO csoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jáun² né³, tsá² hí³ ca³tɨ³ ca³hóh³² tiá³ hi³ ca³juáh³: ―¡Cuɨ́¹ taun¹ tsá² nɨ́² crei²¹! ");
INSERT INTO csoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jáun² Pilato ca³záɨh³ tsá² hí³: ―Tɨ³la³ ¿he³ dá² hi³ hlaɨh³ má²ca³jmú³ tsú² né³? Tɨ³la³ tsá² hí³ né³, tɨ³ lɨ³mí¹ ca³tɨ³ ca³hóh³² bíh¹, hi³ ca³juáh³: ―¡Cuɨ́¹ taun¹ tsá² nɨ́² crei²¹! ");
INSERT INTO csoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jmɨ́¹jáun² ca³lión³² Pilato cú²jueh³² Barrabás hí³, quí¹ hi³ hnió³ dí² hi³ lɨ³ hiún² tsɨ́³ tsá² tionh² hí³. Jmɨ́¹ má²lɨ́²jmú³ dí² jáun² héih³² hi³ quiu³ pan³ tsú² Jesús cun³quionh³ cáun² hñú¹jméi¹³ hi³ lɨ́³ láu², jmɨ́¹ lɨ²¹ jáun² né³, ca³jɨenh³ dí² hi³ tsa³ton³ tsú² crei²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jmɨ́¹jáun² ca³jan³ hliáu³ Jesús tɨ³ la³ ñéih³ ñí¹ lɨ́¹ hó²¹ quioh²¹ ñí¹ta²¹, jáun² ca³cuu³ ca³ngɨh³ tsú² la³jɨ́n³² hliáu³ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jmɨ́¹jáun² ca³quinh³ dí² cáun² hmɨh³² zɨ́n¹³ la³ qui³ quɨh³² jan² tsá² quien², hi³ jáun² ca³tanh² dí² siáh³ chí¹ tsú² cáun² chí² lɨh³², la³juah²¹ dúh¹ *có²ron¹ná¹ hi³ quioh²¹ jan² tsá² ho² jáɨ¹³, tɨ³la³ chí² lɨh³² jáun² dá² lɨ́³ cun³quionh³ cuoh² hmá² ton² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jáun² la³juɨ³² ca³ma³liáu³² tsú² hi³ tɨ³ hóh³² hi³ juáh³: ―¡Cuɨ́¹ lɨ³quien² bíh¹ Re²¹ Juo¹³ tsá² judíos! ");
INSERT INTO csoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jmɨ́¹jáun² ca³ma³liáu³² dí² hi³ ca³quiu³ ca³pá³ dí² chí¹ tsú² cun³quionh³ cáun² hmá²tiéi¹³, hi³ tiú² hñéi³² dí² siáh³, jɨ³ hi³ dí²quí² dí²jñí³² dí² ta³ ñí¹ tsú² siáh³ la³juah²¹ dúh¹ hi³ má²ná¹má²quien² dí² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jmɨ́¹ má²lɨ́²cónh³² dí² jáun² cú²nga¹ né³, ca³chí² dí² siáh³ hmɨh³² zɨ́n¹³ hi³ jmɨ́¹ má²lɨ́²quinh³ dí² jáun², hi³ jáun² ca³quinh³ dí² siáh³ ha¹ hi³ qui³ jmɨ́¹ quih³². Jmɨ́¹jáun² ca³jan³ dí² tsú² hi³ tsa³ton³ dí² crei²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hú¹ juɨ³² jáun² né³ ca³jenh² tsú² jan² tsá²ñuh² tsá² juú² Cirene, tsá² jmáɨ² Sí¹mu²¹, jméi² Lí²ján¹ jɨ³ Rufo, hi³ jmɨ́¹ má²cuá¹hen² já¹ juú²; hi³ jáun² ca³di³quian³ dí² Sí¹mu²¹ hí³ jmáɨ¹ hi³ cán³ crei²¹ hi³ jmɨ́¹ quian³² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jáun² ca³jan³ tsú² Jesús cáun² tsɨ³ máh³ míh¹ jmáɨ² Gólgota (hi³ hnió³ juáh³ “Máh³ Mú³² Chí¹ Tsáu²”). ");
INSERT INTO csoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ñí¹ jáun² ca³jenh³ dí² tsú² mu² mɨ³ uóun²jɨeh¹³ má²ná¹jan² quionh³ mɨ́³ mirra, tɨ³la³ Jesús tiá² ca³hɨnh³ yáh³ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jmɨ́¹jáun² ca³ton³ dí² crei²¹; hi³ jmɨ́¹ lɨ²¹ jáun² né³ ca³chí² hliáu³ jáɨ¹³ hi³ jɨ́e³ dí² nɨ́¹juáh³ hin² joh¹³ ha¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jmɨ́¹ ca³ton³ tsú² jáun² Jesús crei²¹, jmɨ́¹jáun² jmɨ́¹ má²tí³ la³ nió¹ ñu³ tɨ³ hú²niéi². ");
INSERT INTO csoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hi³ jáun² ca³tón³ tsú² siáh³ huéh³ ta³ chí¹ Jesús hi³ jmu² lin¹ hi³ he³ ca³tɨ²¹ má²ma³ngɨ́³ dí² tsú². Huéh³ jáun² juáh³ la³ lá²: “Re²¹ Juo¹³ tsá² judíos”. ");
INSERT INTO csoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ja³bí¹ ca³ton³ tsú² siáh³ crei²¹ gon³ tsá² háɨn² quionh³ Jesús, jan² tɨ³ cuá² chu²¹ hi³ jan² tɨ³ cuá² cáun¹ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","La³ jáun² bíh¹ ca³lɨ³tí³ la³ cun³ hi³ rá¹juáh³ ñí¹ Sí² hi³ juáh³ la³ lá²: “Ja¹ tsá² ren² tso³ bíh¹ ca³ta³dí¹hɨn¹³ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hi³ jáun² tsá² há² ngaɨ³² ñí¹ jáun² né³, ca³tu³ ca³hión³² Jesús, hi³ ca³la³ hi³ jeih³² chí¹ bíh¹ tsú², hi³ juáh³ la³ lá²: ―¡He³ dá² rón³² hnú²! Hnú² tsá² jlánh¹ juánh³ hi³ tsunh²¹ nú² hñú³ hɨ́en¹ quiú¹³, hi³ jáun² ñí¹ cá²hnɨ́² jmáɨ¹ jáun² né³, jmóuh¹ nú² siáh³, ");
INSERT INTO csoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","né³² né³, lion¹ huen² hi³ son² ñí¹ crei²¹ nɨ́² neh²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ja³bí¹ la³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ la³ má²quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ ca³cáuh³² cú²nga¹ quioh²¹ tsú², hi³ juónh²³ la³ lá²: ―Tsá² siánh³ bíh¹ jlánh¹ ca³lión³² tsú², tɨ³la³ hnga² né³, tiá² la³ lɨ́¹³ yáh³ lión³². ");
INSERT INTO csoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nɨ́¹juáh³ hi³ ca³neh²¹ dí² hi³ má²cuá¹son² tsá² nɨ́² ñí¹ crei²¹, má¹jáun² máh³ táunh¹³ dí² ta²¹ hi³ lɨ́n³ tsú² Cristo, Tsá² lɨ́n³ Re²¹ Juo¹³ dí², tsá² *Israel. Hi³ hí¹ ca³la³ tɨ³ tsá² jmɨ́¹ ná¹tón²¹ hí³ crei²¹ quionh³ yáh³ tsú² ca³quiu³ ca³je³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jmɨ́¹ tɨ́³ chi³hiú² né³, ca³nieh² tá¹ cáun² hué³² jáun², ca³la³ ñí¹ tɨ́³ la³ nio¹ hnɨ³² tɨ³ ca³hláu³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³hóh³² Jesús tiá³, hi³ ca³juáh³ la³ lá²: ―Eloi, Eloi ¿lama sabactani? (Hi³ hnió³ juáh³ “Dió³² Juóu³² jná¹³, Dió³² Juóu³² jná¹³, ¿he³ láɨh³² huen² jná¹³ má²lɨ́²zeh² hnú²?”). ");
INSERT INTO csoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma³ jan² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³náɨ³², hi³ jáun² ca³juáh³ la³ lá²: ―Sá¹nɨ́² niéi² náh², Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² má²ñí¹téh¹³ tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jáun² jan² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ngau³ cú²hé² hi³ ca³ñí¹cuóuh¹³ cáun² chí² náh² hɨnh²³ jmáɨ² mu² má²zéih¹ lɨ́n²¹ quioh²¹ mɨ³ uóun²jɨeh¹³, hi³ jáun² ca³di³chí³ dí² hná¹³ hmá²tiéi¹³, hi³ ca³ñí¹hiéih¹³ dí² ho³ Jesús hi³ hnió³ dí² hɨ́nh³. Jmɨ́¹ lɨ²¹ jáun² né³, ca³juáh³ tsá² hí³ la³ lá²: ―Nɨ́² tín² cuɨ́¹ lɨ́³, cuɨ́¹ neh²¹ nɨ́¹juáh³ já³² Líh³ hi³ ja³siau³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jmɨ́¹ lɨ²¹ jáun² ca³hóh³² Jesús tiá³ lɨ́n³², hi³ jáun² jun³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hi³ jáun² hmɨh³² hi³ jmɨ́¹ hí¹jnáɨ²³ ñí¹ jlánh¹ hɨ́en¹ hñu³ cuáh³² chín¹ né³, ca³zen³ tɨ³ tun³ zaɨnh²¹ ca³lɨ³liau³ tɨ³ chi³cuú² hi³ tsa³ la³ tɨ³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jmɨ́¹ má²lɨ́²jɨ́e³ jáun² hliáu³ tsá² chín¹ tsá² *romano jmɨ́¹ zenh¹ hí³ ta³ ñí¹ Jesús hi³ ha³ lánh³ rón³² má²lɨ́²hóh³² Jesús jɨ³ hi³ ha³ lánh³ rón³² má²jun² tsú², jáun² ca³juáh³ la³ lá²: ―Cu³tí³ bíh¹ la³ Jon² Dió³² bíh¹ hla¹ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Có³² jáun² jmɨ́¹ tionh¹ ma³ jan² tsá²mɨ³ hi³ jmɨ́¹ ná¹jɨ́e²³ ñí¹ uóunh³; ja¹ tsá² hí³ jmɨ́¹ zenh¹ Má²réi³ tsá² ja³ juú² Magdalá, Má²réi³ mí¹ziú¹³ Jacobo tsá² cáɨn² jɨ³ Sé³² nɨ́² siáh³, jɨ³ mɨ́¹ Salomé nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tsá²mɨ³ hí³ jmɨ́¹ má²ca³ñi³táunh¹ cu³hna²¹ Jesús jmɨ́¹ cuá³í¹ máh³ tsú² hué¹³ Galilea, jɨ³ hi³ jmɨ́¹ má²ca³ma³cáu³² siáh³. Ja³bí¹ jmɨ́¹ tionh¹ siáh³ juóun³² lɨ́n³² tsá²mɨ³ ñí¹ hná¹ jáun², tsá² cuá²taunh²¹ quionh³ Jesús tɨ³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jmɨ́¹ má²ja³quián³ tá¹tsɨ²¹ hiú² né³, hi³ ti³tsóh³dí¹ jmáɨ¹ jáun² jmáɨ¹ hi³ jmu² tsú² hua³jan²¹, la³ cun³ jmɨ́¹ lɨ́¹³ juáh¹³, cua³hlau³ *jmáɨ¹ hi³ tionh² tsú² tie³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jáun² jmɨ́¹jáun² cuan³ Sé³² tsá² zian² juú² Arimatea, jan² tsá² quien² ja¹ quioh²¹ tsá² ná¹lɨ́n³ ta²¹ hi³ chín¹. Tsá² hí³ uá²jaɨ³² jmɨ́¹ má²jan³² hi³ lɨ³ lin¹ hin² tsánh² má²ca³hión³² Dió³² hi³ hau³ jáɨ¹³, jáun² jlánh¹ tiá³ nio² tsɨ́³ tsá² hí³ ca³hi³ ñí¹ jmɨ́¹ cuá³ Pilato hi³ ca³ñí¹ma¹³ tsú² hla¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Lɨ́¹ lɨn¹ bíh¹ Pilato jmɨ́¹ ca³náɨ³² hi³ la³juɨ³² má²jun² Jesús, jáun² ca³teh³ dí² jan² hliáu³ tsá² chín¹ hi³ ca³ngáɨh³ dí² nɨ́¹juáh³ tson² bíh¹ má²lɨ³² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jmɨ́¹ ca³ma³tson² hliáu³ tsá² chín¹ jáɨ¹³ jáun², jáun² ca³cué³ Pilato jáɨ¹³ ñí¹con² Sé³² hi³ tsa³quión³² tsú² hla¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jmɨ́¹jáun² ca³la³ Sé³² cáun² hmɨh³² jmuh³ tiáu² hi³ lɨ́³ quionh³ mí²ñi³² lino, jáun² ca³sión³² dí² hla¹ hi³ ca³tsáɨnh³² dí² hmɨh³² jáun². Jáun² ca³ñí¹hón²¹ dí² cáun² hñu³ tá²hón³² hmaɨ²¹ hi³ jmɨ́¹ hó²¹ hláu², jáun² ca³lɨ́h³ tsú² cá² máɨ³ quɨ́n¹ pa²¹ hi³ ca³jnáɨ³ tsú² ho³ tá²hón³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jáun² Má²réi³ tsá² juú² Magdalá, jɨ³ Má²réi³ mí¹ziú¹³ Sé³² nɨ́² siáh³ ca³jɨ́e³ ñí¹ ca³hón³² tsú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jmɨ́¹ ca³nga² jáun² *jmáɨ¹ hi³ tionh² tsú² tie³, jáun² Má²réi³ tsá² Magdalá hí³, Má²réi³ mí¹ziú¹³ Jacobo jɨ³ mɨ́¹ Salomé nɨ́² siáh³ ca³la³ háu² má²ró³² hi³ jmɨ́¹ tsa³jñe³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Jmɨ́¹ ca³lɨ³liau³ jáun² sɨ́²ma¹ná¹ né³, ja³taunh²¹ tsá²mɨ³ hí³ hú²niéi² lɨ́n³² ho³ tá²hón³², cun³ ja¹ má²ca³hiá² hiú² jmɨ́¹ ca³cha³táunh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Hú¹ juɨ³² jáun² né³ jmɨ́¹ hí¹juónh²³ tsú² hmóu³²: ―¿Hin² bí¹ tsánh² quin³ quɨ́n¹ dí¹jnáɨ²³ jáun² ho³ tá²hón³²? ");
INSERT INTO csoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tɨ³la³ jmɨ́¹ ca³jɨ́e³ tsú² ho³ tá²hón³² jáun², sa³ tiú²uú² dí¹jnáɨ²³ yáh³ quɨ́n¹ pa²¹ hi³ jmɨ́¹ dí¹jnáɨ²³ jáun² ho³ tá²hón³², quí¹ tɨ³ có³² bíh¹ la³ má²lɨ́² lɨ́h³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jáun² ca³taunh³ tsú² hñu³ tá²hón³² jáun²; ñí¹ jáun² né³, ca³jɨ́en³² tsú² jan² tsá² tsá¹ñú¹ hi³ cuá¹tón²¹ tɨ³ cuá² chu²¹, hi³ cuá¹quih³² cáun² hmɨh³² tiáu² cuó²; jáun² lɨ́¹ ca³yá²han¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tɨ³la³ tsá² hí³ né³ ca³juáh³: ―Ha³ lɨ́² juenh³ náh²; hnoh² dá² hnah²³ náh² Jesús Tsá² Nazaret, Tsá² ca³taun³ hí³ crei²¹. Tɨ³la³ má²ca³jenh¹³ bíh¹ tsú²; ha³ tiú²uú² hin² zian² yáh³ ñí¹ lá². Sá¹nɨ́² dúh¹ ñá²jɨe³ náh² ñí¹ jmɨ́¹ ca³quión³² tsú² tsú². ");
INSERT INTO csoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jáun² né³, cuá²tánh¹ náh² cuá²zéih³ náh² tsá² haɨn²¹ hí³ tɨ³ con² tsú², jɨ³ Pé¹ nɨ́² siáh³, hi³ cuá¹zéih³ náh² tsú² la³ lá²: “Hí³ bíh¹ tsó³² chí¹ján³ tɨ³ Galilea la³ cun³ bíh¹ hnoh², hi³ jáun² ñí¹ jáun² lɨ́¹³ cuá¹jɨen¹ náh² tsú² la³ cun³ lɨ́³ jáɨ¹³ hi³ ca³juáh³ tsú² jáun² jmɨ́¹tin²”. ");
INSERT INTO csoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jáun² tsá²mɨ³ hí³ ca³huén² bíh¹ hñu³ tá²hón³² jáun² hi³ ca³cuóun³, ca³la³ má²hí¹juán²³ bíh¹ tsú² ja³tanh²¹, ca³la³ tiá² ñi³² he³ jmu³. Hi³ jáun² hí¹ cáun² yáh³ tiá² hi³ ca³záɨh³ tsú² tsáu², quí¹hliá² juénh². ");
INSERT INTO csoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jmɨ́¹ ca³jenh¹³ jáun² Jesús tɨ³ ca³jniá³² la³ ñí¹ jmáɨ¹ hi³ ca³lɨ³liau³ sɨ́²ma¹ná¹, ca³ma³jnia³² la³ñí¹ ñí¹con² Má²réi³ tsá² juú² Magdalá, tsá² má²ca³huen³ tsú² hí³ quiaun³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Hi³ jáun² tsá²mɨ³ hí³ ñéi¹ hi³ ca³ñí¹zeh¹ tsá² jmɨ́¹ má²ca³ñi³táunh¹ hí³ quionh³ Jesús. Tsá² hí³ né³ jmɨ́¹ ná¹haɨ²¹ hlaɨh³ tsɨ́³ hi³ jmɨ́¹ ná¹ho². ");
INSERT INTO csoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tɨ³la³ jmɨ́¹ ca³náɨ³² jáun² tsá² hí³ hi³ zian² bíh¹ Jesús, hi³ tsá²mɨ³ hí³ né³ hú¹tá¹ má²lɨ́²jɨ́en³² siáh³, lɨ́¹ tiá² ta²¹ ca³taunh³ bíh¹ tsá² hí³ jáɨ¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jmɨ́¹ má²lɨ³² jáun² né³, Jesús ca³ma³jnia³² hi³ jniá³ la³ siáh³ ñí¹con² gon³ tsá² joh¹ ñí¹ hí¹tsá²táunh¹ tsú² cáun² juɨ³² ñí¹ náɨ². ");
INSERT INTO csoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jáun² tsá² hí³ já¹tanh²¹ hi³ ca³ñí¹zeh¹ tsá² ñí¹ hná¹ jáun²; tɨ³la³ sa³jun³ jáɨ¹³ hi³ cha³² tsá² hí³ yáh³ ca³taunh³ tsú² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jmɨ́¹ lɨ́¹ cáɨn² jáun² né³, ca³ma³jnia³² siáh³ Jesús ñí¹con² tá¹ quian³jan² tsá² haɨn²¹ hí³ tɨ³ con² tá¹la³ jmɨ́¹ ná¹cúh² tsá² hí³ má³²; hi³ jáun² jmɨ́¹jáun² ca³hlɨ³ ca³liéinh³² dí² tsú² cun³ñí¹ hi³ tiá² cáun² nio² tsɨ́³ tsú² jɨ³ hi³hliá² jlánh¹ huáh² chí¹ tsú² siáh³, quí¹ cun³ñí¹ hi³ tiá² ta²¹ ca³taunh³ tsú² la³ cun³ hi³ ca³chá³ tsá² ca³jɨ́e³ hí³ hi³ má²ca³jenh¹³ bíh¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jáun² ca³záɨh³ dí²: ―Cuá²táunh¹ náh² tá¹ cáun² hngá¹máh³, hi³ cuá¹hléh¹ náh² jú¹ chú³² jáun² ñí¹con² la³jɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tsá² chá³² cáun² tsɨ́³, jɨ³ hi³ zón³² jmáɨ², tsá² la³ hí³ bíh¹ lɨ́¹³ liáun³; tɨ³la³ nɨ́¹juáh³ tsá² tiá² cha³² cáun² tsɨ́³ né³, tsá² la³ hí³ dá² má²tá¹tsɨn¹ héih³² hlah³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Hi³ li²¹ lá² né³ lɨ³ zia³² ñí¹con² tsá² nio² cáun² tsɨ́³ bíh¹: Cun³quionh³ héih³² quion²¹ jná¹³ huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², hi³ lɨ́¹³ hléh³² tsú² siáh³ jú¹jma² siáh³, ");
INSERT INTO csoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","lɨ́¹³ zanh³ tsú² siáh³ jáh³ hláɨnh¹, hi³ nɨ́¹juáh³ ca³hɨnh³ tsú² siáh³ cáun² hi³ lɨ́³ mɨ́³ hlah³ né³, tiá² hi³ quiunh²¹ hí¹ cáun² yáh³ tsú²; ja³bí¹ la³ jáun² ra³tsɨ³² tsú² cuo² ñí¹ quioh²¹ tsá² tsáun¹, hi³ jáun² tsá² hí³ né³ lan¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jmɨ́¹ má²lɨ́²liéinh³² jáun² Jesús Tɨ³² Juo¹³ dí² tsá² hí³ né³, ca³zanh³² tɨ³ hñu³mɨ³cuú², hi³ jáun² ca³ta³cua¹³ tɨ³ cuá² chu²¹ quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Hi³ jáun² tsá² hí³ né³, ca³huén² bíh¹ hi³ ca³ñí¹hléh² jú¹ chú³² ca³la³ tán¹. Jáun² hnga² Tɨ³² Juo¹³ dí² ca³ma³hau³ hi³ ca³jmú³ lin¹ hi³ tson² jú¹ chú³² hi³ hleh³² tsá² hí³ cun³quionh³ li²¹ hi³ lɨ́³ jáun² hua³jueh³². Cun³ nɨ́² bíh¹ tí³ jáɨ¹³.");
INSERT INTO csoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Hnú² reh² Tíoh³, juóun³² lɨ́n³² tsáu² má²ca³jmú³ sí², la³ cun³ hi³ ca³ngɨ¹³ tsú² hi³ ca³lɨ³ jáun² ja¹ quiú¹³ dí² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ca³jmú³ tsú² sí² la³ cun³ rón³² hi³ ca³ma³ta² jnoh¹ jáun² tsá² ca³jɨ́e³ la³ cun³ jmɨ́¹ ca³lɨ³liau³, tsá² ca³nga³ hí³ jú¹ chú³² quioh²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ja³bí¹ jná¹³ uá²jaɨ³² má²cá²hnáuh³² re² lɨ́n³² la³jɨ́³² jú¹ tson² la³ cun³ jmɨ́¹ ca³lɨ³liau³, hi³ jáun² ca³lén¹³ jná¹³ hi³ chú³² nɨ́¹juáh³ jná¹³ siáh³ jmu¹ cáun² sí² hi³ rá¹tioh³ jú¹ tson² ca³la³ re² he² hná¹, hi³ zein²¹ ná¹ ñí¹con² hnú² reh² Tíoh³; ");
INSERT INTO csoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","hi³ jáun² tɨ³ lɨ³mí¹ re² lɨ³ ñíh¹³ hnú² jú¹ tson² hi³ má²ca³ma³ta² hnú² jáun² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jmáɨ¹ hi³ jmɨ́¹ cuá¹lɨ́n³ Herodes re²¹ ñí¹con² tsá² hɨ́n¹³ tɨ³ Judea, jmɨ́¹jáun² jmɨ́¹ zian² jan² mí²tsáu² jmáɨ² Zacarías, tsá² hí³ jmɨ́¹ hún¹ ja¹ tsá² cu³ nió³ quioh²¹ Abías. Ñí²cuo² tsú² jmɨ́¹ jmáɨ² Elisabet, tsá² ñí¹ má²cú¹ má²ñeh¹ jón²zɨ́h¹ hla¹ mí²tsáu² Aarón. ");
INSERT INTO csoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Tá¹ gon³ jáun² tsú² jmɨ́¹ chun¹ ñí¹con² Dió³², hi³ jmɨ́¹ tɨ́² má²tí³² tsú² héih³² jɨ³ liei²¹ quioh²¹ Dió³² Juo¹³ dí², la³ cun³ hí¹ jan² tiá² hin² lɨ́¹³ chá³² tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tɨ³la³ tiá² jon² tsú² jmɨ́¹ zian² yáh³, quí¹ tiá² jmɨ́¹ lɨ́²³ yáh³ can³ Elisabet hí³ jon², hi³ ja³bí¹ jmɨ́¹ má²lieih²¹ bíh¹ tsú² siáh³ tá¹ gon³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ca³chó³² jmáɨ¹ hi³ tɨn³ Zacarías quionh³ mí²tsáu² tsá² quionh³ hi³ jmu³ ta²¹ ta³ ñí¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","La³ cun³ hi³ jmɨ́¹ ná¹ngɨ²³ jáun² tsá² ná¹lɨ́n³ hí³ mí²tsáu² hi³ tan² chi² jáɨ¹³, jmɨ́¹jáun² ca³chi² tsú² jáɨ¹³, jáun² Zacarías bíh¹ tɨn³ hi³ tsa³hi³² hñu³ cuáh³² chín¹ quioh²¹ Dió³² Juo¹³ dí², hi³ tsa³jín² ziún². ");
INSERT INTO csoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tá¹la³ jmɨ́¹ dí¹jɨn³² tsú² jáun² ziún² ñí¹hiú¹³ né³, la³jɨ́n³² tsá² tionh² ñí¹ tauh²¹ la³ñí¹ jmɨ́¹ ná¹liéinh³² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jmɨ́¹jáun² ca³jnia³ jan² tsá²cuú² tsá²ta³ Dió³² ñí¹con² Zacarías, hi³ zenh² tɨ³ cuá² chu²¹ can³² ñí¹hiú¹³ ñí¹ dí¹jɨn³² tsú² jáun² ziún². ");
INSERT INTO csoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jmɨ́¹ ca³jɨ́en³² jáun² Zacarías tsá² hí³ né³, ca³la³ tiá² ñi³² he³ jmu³ bíh¹ tsú² lɨ³, ca³juénh² lɨ́n³² bí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Tɨ³la³ tsá² hí³ né³, ca³juáh³ la³ lá²: ―Zacarías, ha³ lɨ́² juenh³, quí¹ Dió³² má²ca³náɨ³² hi³ hiú² mɨh³² hnú² jáun², hi³ jáun² né³bí¹ chau²¹ jmáɨ¹ hi³ lɨ³zian² jan² jon² Elisabet ñí²cuonh² hnú², tsá² teh¹ nú² Juan². ");
INSERT INTO csoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nɨ́¹ má¹ca³lɨ³zian² jáun² dáɨn² lɨ³ tsɨnh¹ lɨ́n²¹ nú², hi³ lɨ³ hiún² lɨ́n³² siáh³ honh² nú². Ja³bí¹ juóun³² lɨ́n³² siáh³ tsá² siánh³ lɨ³ hiún² tsɨ́³ nɨ́¹ má¹jáun²; ");
INSERT INTO csoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","quí¹ jónh³² hnú² lɨ³quien² ñí¹con² Dió³², jan² tsá² tiá² hɨ́nh³ mu² ráu³ mɨ³ uóun²jɨeh¹³, sa³jun³ ma³chéi³ hɨ́nh³, jan² tsá² má²canh² Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³ ñeh² bíh¹ hi³ lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hi³ hí³ bíh¹ jmu³ hi³ juóun³² tsá² zian² hué³² *Israel jinh²¹ tɨ³ ñí¹con² Dió³² Juo¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan² hí³ bíh¹ joh¹³ jmɨ́²chí³ jɨ³ pí³ hi³ la³jmɨ́¹ quian³² jáun² Líh³, tsá² jmɨ́¹ lɨ́n³ hí³ *Tɨ³² jë¹ Dió³² jmɨ́¹tin², hi³ hí³ bíh¹ tín² tsó³² chí¹ján³ la³ cónh³ bíh¹ Tɨ³² Juo¹³ dí². Hí³ bíh¹ jmu³ hi³ tiánh³² tsáu² re² tɨn² quionh³ jón²zɨ́h¹; hi³ jáun² tsá² tiá² má²tí³² héih³² quioh²¹ Dió³² né³, má²lɨ³tɨn² bíh¹ ma³tí³² má¹jáun². La³ jáun² bíh¹ chan³ tsú² hua³jan²¹ tsáu², hi³ jáun² hen³ tsáu² Tɨ³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jáun² Zacarías ca³záɨh³ tsá² hí³: ―¿Ha³ bí¹ lánh³ rón³² lɨ³ ño¹ jná¹³ hi³ tson² jáɨ¹³ juáh³ hnú² nɨ́²? Quí¹ jan² tsá² má²liei²¹ lɨ́n²¹ bíh¹ jná¹³ quiúnh¹ ñí²uón³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jáun² tsá² hí³ ca³juáh³ siáh³: ―Jná¹³ Gabriel, tsá² zenh² ná¹ ta³ ñí¹ Dió³², Tsá² lɨ́²ze³ jná¹³ hi³ ja³ngáɨ¹ ná¹ jú¹ chú³² lá² ñí¹con² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Tɨ³la³ ta³né³², cun³ñí¹ hi³ tiá² ta²¹ lɨ́²tionh² hnú² la³ cun³ hi³ lɨ́²juánh³² jná¹³ nɨ́², jáun² tiú²uú² lɨ́¹³ yáh³ hléh¹³ hnú², ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ lɨ³zian² jónh³² hnú². Jáɨ¹³ lá² lɨ³tí³ la³ cun³ jmáɨ¹ hi³ má²tón³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","La³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñéih³ ñí¹ tauh²¹ jáun² la³ñí¹ jmɨ́¹ ná¹he² ná¹jan² Zacarías. Má²ná¹tsá²cáun² lɨ́n³² bíh¹ tsɨ́³ tsú², quí¹ he³ láɨh³² sa³ ca³lén³ lɨ́n³² yáh³ Zacarías ñí¹hiú¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tɨ³la³ jmɨ́¹ cuá¹han³ jáun² Zacarías má¹ná¹, tiú²uú² lɨ́²³ yáh³ hléh³²; jmɨ́¹jáun² ca³lɨ³lieih²¹ tsá² jmɨ́¹ ná¹jaun² tsú² hí³ hi³ zia³² cáun² hi³ ca³jnia³ jéinh³² tsú² ñí¹hiú¹³ jáun². Jmɨ́¹jáun² ca³jmú³ tsú² lin¹ quionh³ cuo² hi³ tiú²uú² lɨ́²³ hléh³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jmɨ́¹ ca³tsɨ́n¹³ jáun² jmáɨ¹, la³ cun³ jmáɨ¹ hi³ ca³tɨn¹ jáun² Zacarías jmu³ ta²¹ hñu³ cuáh³² chín¹ né³, ngah³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jmɨ́¹ lɨ²¹ jáun² né³, ca³can³ Elisabet jon², hi³ jáun² cun³ hñá³ zɨ́h² tiá² cuá²han³ tsú² hñú¹³, hi³ jmɨ́¹ cuá¹lɨ́n²³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Juóu³² jná¹³ má²ca³jmú³ la³ lá² ñí¹con² jná¹³, hi³ quin³ hua³heih²¹ quion²¹ jná¹³ ñí¹con² la³jɨ́n³² tsáu², hi³ tiá² jmɨ́¹ lɨ́²³ can²¹ jná¹³ dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","La³ má²jñéi³ zɨ́h² hi³ lɨ³ la³ jáun² né³, ca³zen³ siáh³ Dió³² Gabriel, tsá²cuú² tsá²ta³, la³ tɨ³ cáun² juú² hɨ́n¹³ tɨ³ Galilea, juú² jmáɨ² Nazaret, ");
INSERT INTO csoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","hi³ tsa³jɨen³ jan² tsá²mɨ³ tsá¹máɨ¹³, tsá² jmáɨ² Má²réi³, tsá² tiá² tsá²ñuh² má²ca³cáuh³². Tsá² hí³ ná¹lɨ́³ jáɨ¹³ hi³ jenh¹³ cuo² quionh³ jan² tsá²ñuh² jmáɨ² Sé³², tsá² ñí¹ má²cú¹ má²ñeh¹ jón²zɨ́h¹ jón²cho¹ hla¹ re²¹ Dá²vi²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jáun² ca³hi³ tsá² hí³ ñéih³ ñí¹ jmɨ́¹ cuá³ jáun² Má²réi³, hi³ ca³juáh³ la³ lá²: ―¡Hia² nú², hnú² tsá² jlánh¹ tɨ³² tsɨ́³ Dió³²! Dió³² Juo¹³ dí² zenh² quiúnh¹ hnú². Jlánh¹ má²mieh² hnú² Dió³² la³ cun³ bí¹ la³jɨ́n³² tsá²mɨ³ siánh³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Lɨ́¹ ca³lɨn³ bíh¹ Má²réi³ jmɨ́¹ ca³náɨ³² jáɨ¹³ hi³ ca³hléh³ jáun² tsá² hí³. Jmɨ́¹jáun² ca³lɨ́n¹³ tsú² hi³ he³ lɨ³ la³ jáun² hleh³² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jáun² tsá² hí³ né³ ca³juáh³ siáh³: ―Má²réi³, ha³ lɨ́² juenh³, quí¹ Dió³² má²hnió³ ma³mieh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jáun² né³, né³² can¹³ hnú² jan² dáɨn², Tsá² teh¹ nú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tsá² hí³ bíh¹ Tsá² lɨ³quien²; Tsá² téh³ tsú² Jon² Dió³², Tsá² cú² juenh². Hi³ jáun² Dió³² Juo¹³ dí² jmu³ hi³ cuá¹ho² tsú² jáɨ¹³ hi³ lɨ́n³ tsú² re²¹ la³jmɨ́¹ ca³cuá³ hla¹ re²¹ Dá²vi²¹ jméi² dí¹hio³ ñú¹deh³ tsú², tsá² jmɨ́¹ zian² jmɨ́¹tin²; ");
INSERT INTO csoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","hi³ jáun² tsá² hí³ bíh¹ cuá³², hi³ cuá¹ho² jáɨ¹³ cun³ jmɨ́¹hi³nio² ca³tɨn¹ la³jɨ́n³² tsá² Israel. Jáɨ¹³ hi³ hau³ tsú² jáun², tiá² tón³² jmáɨ¹ táuh³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jáun² né³, Má²réi³ ca³ngáɨh³ siáh³ tsá² hí³: ―¿Lánh³ bíh¹ rón³² lɨ́¹³ la³ jáun², nɨ́¹juáh³ tiá² ñí²uón³² jná¹³ má²zian² yáh³? ");
INSERT INTO csoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jáun² tsá² hí³ ca³juáh³ siáh³: ―Jmɨ́²chí³ Chun¹ joh¹ Dió³² bíh¹ já³² ñí¹con² hnú², jɨ³ pí³ quioh²¹ Dió³² Tsá² cú² juenh², hi³ jláɨn³² hnú² la³jmɨ́¹ lɨ́³ cáun² jnie². Jáun² dáɨn² hí³ jónh³² hnú² lɨ́¹³ cuá¹chan¹ hi³ ca³tɨn¹ Dió³², hi³ jáun² tsá² hí³ téh³ tsú² jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ja³bí¹ Elisabet renh² hnú² uá²jaɨ³², lɨ³zian² jan² jon² uá¹jinh¹ má²lieih²¹ lɨ́n²¹ tsú²; hi³ jáun² né³, ta³né³² má²tí³ jñéi³ zɨ́h² hi³ quian² tsú² jon², tsá² jmɨ́¹ juáh²³ tsáu² hi³ cun³ tiá² lɨ́¹³ bíh¹ can³ jon². ");
INSERT INTO csoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Quí¹ ñí¹con² Dió³², hí¹ cáun² yáh³ hi³ juóuh³² tiá² zia³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Hi³ jáun² Má²réi³ né³ ca³juáh³: ―Jná¹³ la³², tsá² lɨ́n³ ná¹ quian²¹ Juóu³² ná¹, hi³ jáun² cuɨ́¹ jmu¹ bíh¹ Dió³² ñí¹con² jná¹³ la³ cun³ hi³ má²lɨ́²juah²¹ hnú² nɨ́². Jmɨ́¹ lɨ²¹ jáun² né³, ngah³ tsá²cuú² tsá²ta³ Dió³² ñí¹ ta³ ñí¹ Má²réi³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jmáɨ¹ jáun² ngau³ Má²réi³ cú²hé² juɨ³² máh³, hi³ chau²¹ cáun² juú² hɨ́n¹³ tɨ³ Judea. ");
INSERT INTO csoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jmɨ́¹ cá¹chó²¹ tsú² jáun², ca³hi³ ñéih³ hñú¹³ Zacarías, hi³ ca³juáh³: ―Hia² nú² Elisabet. ");
INSERT INTO csoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jmɨ́¹ má²lɨ́²niéi³² jáun² Elisabet hi³ ca³juáh³ jáun² Má²réi³: “Hia² nú²”, jáun² la³juɨ³² ca³jɨ́enh³² dáɨn² hñu³ héin¹, hi³ ca³cónh³² siáh³ Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³ Elisabet hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jmɨ́¹jáun² ca³hléh³ tiá³ lɨ́n³² hi³ ca³juáh³: ―Dió³² jlánh¹ má²ca³ma³mieh² hnú² la³ cónh³ bíh¹ la³jɨ́n³² tsá²mɨ³ siánh³, jɨ³ jónh³² nú² siáh³ má²ca³ma³mieh² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Hin² dá² tsánh² jná¹³, hi³ jáun² sa³ mí¹ziú¹³ Juóu³² máh³ jná¹³ ja³ hi³ ja³jɨe³? ");
INSERT INTO csoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quí¹ la³ cun³ jmɨ́¹ lɨ́¹cuen²¹ hnú² Dió³², ca³la³ hiún² lɨ́n³² bíh¹ tsɨ́³ jón³² jná¹³ ca³jɨ́enh³² tiá³ lɨ́n³² hñu³ hén² ná¹. ");
INSERT INTO csoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jlánh¹ jmɨ́¹ ren² hnú², tsá² ca³tionh² hnú² ta²¹, quí¹ lɨ³tí³ bíh¹ la³ cun³ hi³ má²ca³juáh³ Dió³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Hi³ jáun² Má²réi³ ca³juáh³: Jmɨ́¹ tsɨn³² jná¹³ má²quien² Juóu³² jná¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","hi³ má²hiún² tsɨn³² jná¹³ ca³tɨn¹ Dió³² Tsá² liáu³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Quí¹ Dió³² má²ca³taunh² jná¹³ hó¹ñí¹, tsá² lɨ́n³ jná¹³ quian²¹ tsú². Hi³ jáun² la³jɨ́n³² tsá² zian² ta³né³² jɨ³ jmáɨ¹ né³bí¹ ja³² juáh³ hi³ jná¹³ jan² tsá² jlánh¹ bí¹ jmɨ́¹ ren². ");
INSERT INTO csoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Quí¹ Dió³² Tsá² hɨ́en¹, Tsá² cú² juenh² má²ca³jmú³ hliáun³ lɨ́n³² hi³ chú³² ñí¹con² jná¹³; ");
INSERT INTO csoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","hi³ ja³² mií³ tsɨ́³ tsú² ñí¹con² ca³la³ jɨ́n³² tsá² jmu² juénh² ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Quí¹ ta²¹ jueh³² lɨ́n³² má²ca³jmú³ Dió³², hi³ ca³láɨh¹³ hniéi² ñí¹con² tsá² jmɨ́¹ ná¹jmu² tonh², jáun² lɨ́¹ ca³háɨn³² ma³ quin³² bíh¹ tsá² hí³ lɨ³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ca³jmú³ tsú² hi³ tiú²uú² quien² tsá² jmɨ́¹ ná¹quien², hi³ jáun² tsá² tsɨ́¹juɨ́³ bíh¹ ca³zion³ tsú² hi³ lɨ³quien². ");
INSERT INTO csoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tsá² jmɨ́¹ tionh¹ ñí¹cuóunh²¹ bíh¹ ca³cuéh³ tsú² hliáun³ lɨ́n³², hi³ jáun² tsá² hánh³ né³, lɨ́¹ haɨ²¹ cuá² ta³ bíh¹ ca³chanh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ca³ma³hon³ tsú² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Israel, tsá² quian²¹, tiá² ca³ja³có³ yáh³ tsɨ́³ tsú² hi³ jmu³ juenh² tsɨ́³ ñí¹con² tsá² hí³, ");
INSERT INTO csoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","la³ cun³ rón³² lɨ́³ jáɨ¹³ hi³ ca³jmú³ tsú² quionh³ dí¹hio³ ñú¹deh³ dí² jmɨ́¹tin². Hi³ ca³jmú³ tsú² jáun² jáɨ¹³ quionh³ hla¹ Há²bran²¹ hi³ já³² mií³ tsɨ́³ tsú² la³ cun³ jmɨ́¹hi³nio², la³ má²quionh³ jón²zɨ́h¹ jón²cho¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jmɨ́¹ má²lɨ́²juáh³ jáun² Má²réi³ la³ nɨ́² né³, ca³ta³cua¹³ cun³ hnɨ³² zɨ́h² hñú¹³ Elisabet. Jmɨ́¹ lɨ²¹ jáun² né³, ngah³ siáh³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Jmɨ́¹ lɨ́¹cáɨn² jáun² né³, ca³chó³² jmáɨ¹ hi³ lɨ³zian² jon² Elisabet, hi³ jáun² ca³lɨ³zian² jan² ñú²míh¹ jon² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jmɨ́¹ ca³lɨ³ ñi³² jáun² tsá² jún¹ tsá² raɨnh²¹ tsú² hi³ Dió³² jlánh¹ má²ca³ja³ mií³ tsɨ́³ ñí¹con² tsú², hi³ jáun² ca³ñí¹ma³hiún² tsá² hí³ tsɨ́³ quionh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jáun² jmɨ́¹ la³ má²jña³ jmáɨ¹ jáun² *ca³tiú³ tsú² chí² láu² hná¹³ ñí¹ zian² dáɨn², hi³ jmɨ́¹ hnió³ tsú² siáh³ hi³ lɨ³ jmáɨ² dáɨn² Zacarías, la³jmɨ́¹ jmáɨ² jméi². ");
INSERT INTO csoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tɨ³la³ mí¹ziú¹³ dáɨn² ca³juáh³: ―Ján¹han²¹, Juan² bíh¹ lɨ³ jmáɨ² dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jáun² tsá² hí³ ca³juáh³: ―¿He³ láɨh³²? Já² hí¹ jan² yáh³ jon³ renh² hnú² tiá² jmáɨ² la³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jmɨ́¹jáun² hmóu³² tsá² hí³ ca³ngáɨ³ ñí¹con² jméi² dáɨn² cun³quionh³ li²¹, nɨ́¹juáh³ he³ hnió³ tsú² lɨ³ jmáɨ² dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jáun² ca³mɨ́³ jméi² dáɨn² cáun² jó¹hmá² pih²¹ hi³ ca³jmú³ huéh³ hi³ juáh³: “Juan² bíh¹ lɨ³ jmáɨ² dáɨn²”. Jáun² la³jɨ́n³² tsá² hí³ ca³ja³cáun² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","La³ cun³ jmɨ́¹jáun² bíh¹ lɨ³ siáh³ hléh³² Zacarías, hi³ ca³ma³liáu³² hi³ má²quien² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ca³la³ jɨ́n³² tsá²co¹ tsú² ca³ja³cáun² lɨ́n³² tsɨ́³ jmɨ́¹ ca³lɨ³ ñi³² hi³ lɨ³ la³ jáun², hi³ jáun² jáɨ¹³ jáun² ja³ngɨ³ ja¹ la³jɨ́n³² tsá² zian² tsɨ³ cuánh² tsɨ³ jën³ ñí¹ hɨ́n¹³ tɨ³ Judea. ");
INSERT INTO csoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ca³la³ jɨ́n³² tsá² ca³lɨ³ ñi³² hi³ jáun² jmɨ́¹ ná¹hnauh² tsɨ́³, hi³ jmɨ́¹ ngaɨh³² tsú² siáh³ tsá²ján² tsá²ján²: ―¿He³ bíh¹ jmu³ dáɨn² hí³? Quí¹ jmɨ́¹ má²lin¹ lɨ́n²¹ bíh¹ hi³ tanh² Dió³² hó¹ñí¹ dáɨn² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jáun² Zacarías jméi² dáɨn² hí³ ca³cónh³² Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³, hi³ ca³hléh³ jáɨ¹³ hi³ ca³cué³ Dió³² hñu³ tsɨ́³, hi³ ca³juáh³: ");
INSERT INTO csoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Cuɨ́¹ lɨ³quien² bíh¹ Dió³² Juo¹³ tsá² Israel, quí¹ má²cuán² tsú² ja¹ ñí¹ tiauh¹ dí², tsá² tiauh² dí² jo³cuo² tsú², hi³ má²ca³liáu³² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quí¹ ca³cuen³ tsú² jan² Tsá² liáu³² dí², jan² Tsá² ñí¹ má²cú¹ má²ñeh¹ jón²zɨ́h¹ jón²cho¹ hla¹ re²¹ Dá²vi²¹, tsá² ca³lɨn³ hí³ quian²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Má²ca³ma³tí³² bíh¹ Dió³² jáɨ¹³ hi³ ca³jmú³ quionh³ tsá² chun¹ joh¹, tsá² ca³lɨn³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin², ");
INSERT INTO csoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","hi³ ca³juáh³ Dió³² hi³ liáu³² jnoh¹ ñí¹con² tsá² jmu² hniéi² quiúnh¹ dí², jɨ³ ñí¹con² ca³la³ jɨ́n³² tsá² hau² dí² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Má²ca³ja³ bíh¹ mií³ tsɨ́³ tsú² ñí¹con² dí¹hio³ ñú¹deh³ dí², tsá² jmɨ́¹ zian² jmɨ́¹tin². Tiá² tsá²có³ yáh³ tsɨ́³ tsú² nió³² hɨ́en¹ hi³ ca³tanh² jáun² la³ cun³ jmɨ́¹tin², ");
INSERT INTO csoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","la³ cun³ jáɨ¹³ hi³ ca³jmú³ tsú² jáun² ñí¹con² hla¹ Há²bran²¹, jméi² dí¹hio³ ñú¹deh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Hi³ ca³juáh³ tsú² hi³ liáu³² tsú² jnoh¹ ñí¹con² tsá² jmu² hniéi² quiúnh¹ dí², hi³ jáun² tiá² juénh² yáh³ dí² hi³ má¹ti²¹ ñí¹con² tsú², ");
INSERT INTO csoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","hi³ chun¹ dí², hi³ ná¹chan¹ dí² ñí¹con² tsú² la³ cun³ jmáɨ¹ hi³ ziáun² dí². ");
INSERT INTO csoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jáun² né³, hnú² jón³² jná¹³, hnú² té³ tsú² tɨ³² jë¹ Dió³², tsá² lɨ́n³ quian²¹ Dió³² Tsá² cuá³ hñu³mɨ³cuú², quí¹ hnú² bíh¹ tsá² cuóh¹³ chí¹ján³ la³ñí¹, hi³ jmúh¹³ hnú² hua³jan²¹ juɨ³² ñí¹ tsó²¹ Tɨ³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Jmúh¹³ hnú² hi³ lɨ³ ñi³² tsá² joh¹ tsú² ha³ lánh³ lɨ́¹³ liáun³ tsú², jɨ³ hi³ hin³ siáh³ tsáu¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quí¹ Dió³² ja³² lɨ́n³² mií³ tsɨ́³ ñí¹con² dí², hi³ jáun² cué³² tsú² cáun² joh¹ quiú¹³ dí² hi³ lɨ́¹³ la³jmɨ́¹ lɨ́³ hi³ ca³jniá³² cáun² jmáɨ¹ hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tsá² hí³ jmu³ hi³ taɨ²¹ joh¹ ñí¹con² tsá² tionh² já¹niéi², jɨ³ tsá² tionh² ñí¹ he² heinh²¹ quioh²¹ hmú³² nɨ́² siáh³. Tsá² hí³ bíh¹ Tsá² hɨ́e³² juɨ³² hi³ ha³ lánh³ lɨ́¹³ niau²¹ tie³ tsɨ́³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hi³ jáun² né³, ca³cuon³ bíh¹ ñú²míh¹ hí³, hi³ tsá²lɨ³hún¹ siáh³ tsɨ́³. Jáun² ca³ñí¹cuá² tsú² ñí¹ lɨ́³ hué³² quiéin², ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³ma³jnia² tsú² tá¹³ ñí¹con² tsá² Israel. ");
INSERT INTO csoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jmɨ́¹jáun², Augusto *tsá² cuá¹lɨ́n³ mɨ³chí¹ cuá³ juú² Roma ca³jmú³ héih³² hi³ la³jɨ́n³² tsá² zian² la³ cun³ hué³² ñí¹ hu²¹ cuo² tsú² tónh³² ñí¹ sí² quioh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","La³ñí¹ jéin³² hi³ ca³tónh³² bíh¹ tsú² tsáu² sí² jmɨ́¹jáun², jmáɨ¹ hi³ jmɨ́¹ cuá¹lɨ́n³ jáun² Cirenio ta²¹ hué³² Siria. ");
INSERT INTO csoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","La³jɨ́n³² tsáu² ca³lɨ³ hniáuh³² tsa³tánh¹ juú² ñí¹ ca³lɨ³zian² tsá²haun³² dí¹hio³ ñú¹deh³, hi³ tsa³tiónh³² sí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hi³ jáun² bíh¹ cua³han³ Sé³² já¹ juú² Nazaret, juú² hɨ́n¹³ tɨ³ Galilea, hi³ ngau³ tɨ³ juú² jmáɨ² Belén, juú² hɨ́n¹³ tɨ³ Judea, ñí¹ ca³lɨ³zian² hla¹ re²¹ Dá²vi²¹, quí¹ Sé³² lɨ́n³ jan² tsá² ñí¹ má²cú¹ má²ñeh¹ jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hi³ jáun² ñéi¹ tsú² juú² Belén, hi³ ca³ñí¹tiónh²¹ sí² cu³tsa³² quionh³ Má²réi³, tsá² jmɨ́¹ má²ná¹lɨ́³ hí³ jáɨ¹³ hi³ jéinh³² tsú² cuo² quionh³. Jmɨ́¹jáun² jmɨ́¹ má²quian² bíh¹ Má²réi³ jon². ");
INSERT INTO csoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Jáun² tá¹la³ tiáunh¹ tsú² jáun² já¹ juú² Belén bíh¹, ca³chó³² jmáɨ¹ hi³ lɨ³zian² jon² Má²réi³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hi³ jáun² ca³lɨ³zian² dún² tsá² ñí¹ jon² tsú², jáun² ca³tsáɨnh³² tsú² tsɨ́¹há², hi³ jáun² ca³tanh² tsú² siáh³ tɨ³ ñeh² hñu³ hmá²mu² pa²¹ rón³² ñéih³ hñú¹³ jáh³, quí¹ tiá² jmɨ́¹ zia³² yáh³ hñú³ ñí¹ jmɨ́¹ lɨ³ jnioh¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hi³ jáun² né³, ñí¹ náɨ² ñí¹ má²janh² juú² Belén jáun² jmɨ́¹ tiáunh¹ tsá² ná¹jmu² hua³hí¹³ já¹ziáh² joh¹ ta³ já¹niéi². ");
INSERT INTO csoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jáun² cu³diá²jan² ca³jnia³ jan² tsá²cuú² tsá²ta³ Dió³² Juo¹³ dí², hi³ jáun² ca³táɨ³ joh¹ quioh²¹ Dió³² cu³ jéin³ ñí¹ tionh¹ jáun² tsá² hí³; hi³ jáun² né³, tsá² hí³ ca³juénh² lɨ́n³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tɨ³la³ tsá² ca³jnia³ hí³ ca³juáh³: ―Ha³ lɨ́² juenh³ náh², quí¹ jná¹³ quion¹ cáun² jú¹ chú³², jú¹ chú³² hi³ ca³tɨn¹ la³jɨ́n³² tsáu², hi³ jáun² lɨ³ hiún² lɨ́n³² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Quí¹ né³² ca³lɨ³zian² jan² dáɨn² juú²co¹ hla¹ re²¹ Dá²vi²¹, jan² Tsá² liáu³² hnoh², Tsá² lɨ́n³ Cristo Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Juanh²¹ jná¹³ ha³ lánh³ rón³² lɨ³ cuóun³² hnoh² dáɨn² hí³: Dáɨn² hí³ chanh²¹ náh² hi³ rá¹tsaɨnh³² tsɨ́¹há², hi³ rá²hún¹ tɨ³ ñeh² hñu³ hmá²mu² quioh²¹ jáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hi³ jáun² cu³diá²jan² jmɨ́¹ cá¹jnia³ juóun³² lɨ́n³² tsá²cuú² tsá²ta³ Dió³² tsá² já²taunh²¹ hñu³mɨ³cuú², can³² ñí¹ jmɨ́¹ zenh¹ jáun² tsá² jan² hí³, hi³ má²ná¹má²tsú² má²jónh³² Dió³², hi³ má²ná¹juáh²³: ");
INSERT INTO csoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Tsá² tionh² hñu³mɨ³cuú² cuɨ́¹ má¹quien² Dió³², hi³ tsá² zian² ñí¹ hué²¹ nɨ́² siáh³ cuɨ́¹ tionh² cáun² hi³ re² hi³ tɨn², ca³la³ jɨ́n³² tsáu² tanh² Dió³² hó¹ñí¹!” ");
INSERT INTO csoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jmɨ́¹ já¹tanh²¹ jáun² tsá² hí³ hñu³mɨ³cuú² né³, jáun² tsá² jmu² hí³ hua³hí¹³ já¹ziáh² ca³juu³ ca³hlénh³ la³ lá²: ―Ma³tsáu¹³ tɨ³ já¹ juú² Belén, hi³ tsá¹neh²¹ la³ cun³ hi³ má²lɨ³², hi³ má²lɨ́²juáh³ jáun² Dió³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jáun² ja³taunh²¹ tsú² cú²hé². Jmɨ́¹ ca³cha³táunh¹ tsú² jáun², ca³chanh²¹ tsú² Má²réi³ quionh³ Sé³² jɨ³ dáɨn² siáh³, hi³ rá²hún¹ tɨ³ ñeh² cáun² hñu³ hmá²mu² quioh²¹ jáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jmɨ́¹ má²lɨ́²jɨ́en³² tsú² jáun² dáɨn² né³, ca³chá³ tsú² la³ cun³ hi³ má²lɨ́²juáh³ jáun² tsá²cuú² tsá²ta³ Dió³² hi³ ca³tɨn¹ dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jáun² la³jɨ́n³² tsá² jmɨ́¹ ná¹náɨ³² ca³ja³cáun² tsɨ́³ la³ cun³ jáɨ¹³ hi³ ca³juáh³ jáun² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Tɨ³la³ Má²réi³ má¹ná¹, ca³hmá³ bíh¹ la³jɨ́³² jáɨ¹³ jáun² hñu³ tsɨ́³, hi³ ca³hnauh² tsú² tsɨ́³ ca³tɨ²¹ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hi³ jáun² tsá² jmu² hí³ hua³hí¹³ já¹ziáh² ja³tanh²¹, hi³ má²hí¹má²tsú² má²jónh³² Dió³², hi³ má²hí¹má²quien² tsú² Dió³², quí¹hliá² má²lɨ́²niéi³² tsú² jɨ³ hi³ má²lɨ́²jɨ́e³ tsú² la³ cun³ jáɨ¹³ hi³ má²lɨ́²juáh³ jáun² tsá²cuú² tsá²ta³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jmɨ́¹ la³ má²jña³ jmáɨ¹ hi³ ca³lɨ³zian² jáun² dáɨn² *ca³tiú³ tsú² chí² láu² hná¹³ ñí¹ zian²; jmɨ́¹jáun² ca³jmú³ tsú² hi³ lɨ³ jmáɨ² dáɨn² Jesús, la³ cun³ hi³ ca³juáh³ jáun² tsá²cuú² tsá²ta³ Dió³² ñí¹con² Má²réi³ la³ cun³ jmɨ́¹ ñeh² bíh¹ hi³ can³ tsú² dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jmɨ́¹ ca³tsɨ́n¹³ jáun² jmáɨ¹ hi³ má²lɨ́¹³ lɨ³ jɨn² mí¹ziú¹³ Jesús quionh³ Sé³² ñí¹con² Dió³² la³ cun³ hi³ rá¹juáh³ ñí¹ liei²¹ quioh²¹ hla¹ Moisés, jáun² ca³ñí¹jan² tsú² dáɨn² hí³ já¹ juú² Jerusalén, hi³ ca³ñí¹ma³jnia² tsú² dáɨn² hí³ ñí¹con² Dió³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","La³ jáun² ca³jmú³ tsú² quí¹hliá² liei²¹ quioh²¹ Dió³² Juo¹³ dí² rá¹juáh³ la³ lá²: “Ca³la³ jɨ́n³² tsá²ñuh², tsá² lɨ³zian² la³ñí¹ ca³tɨn¹ ná¹chan¹ ñí¹con² Dió³² Juo¹³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Hi³ jáun² bíh¹ ca³ñí¹táunh¹ tsú² ñí¹ jáun² hi³ ca³ñí¹cuen¹³ tsú² jáh³ ñí¹con² Dió³² hi³ ca³tɨn¹ dáɨn² jon², quí¹hliá² liei²¹ quioh²¹ Dió³² Juo¹³ yáh³ dí² rá¹juáh³ hi³ hniáuh³² cuen³ tsú² gon³ jú²pe³² míh¹ ho³lá²dá² gon³ jáɨ² tiáun². ");
INSERT INTO csoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Jmɨ́¹jáun² jmɨ́¹ zian² jan² tsá²ñuh² jmáɨ² Sɨ³ñóh³ já¹ juú² Jerusalén. Tsá² hí³ jmɨ́¹ lɨ́n³ jan² tsá² chun¹, hi³ jmɨ́¹ má²tsú² má²jónh³² Dió³², hi³ jmɨ́¹ jan³² tsú² hi³ liáun³ tsá² *Israel. Jmɨ́¹ quionh³ tsú² Jmɨ́²chí³ Chun¹, ");
INSERT INTO csoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","hi³ jáun² Jmɨ́²chí³ Chun¹ hí³ né³ ca³jmú³ lin¹ ñí¹con² tsú² hi³ tiá² má²jún³ yáh³ tsú² ta³ tiá² má²lɨ́²jɨ́en³² Tsá² lɨ́n¹³ Cristo, Tsá² zen³ hí³ Dió³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jáun² Jmɨ́²chí³ Chun¹ hí³ ca³ze³ tsú² tɨ³ hñu³ cuáh³² chín¹; jmɨ́¹jáun² ca³ñí¹jau² jméi² mí¹ziú¹³ dáɨn² Jesús hñu³ cuáh³² chín¹, hi³ tsa³ma³tí³² tsú² la³ cun³ hi³ rá¹juáh³ jáun² liei²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jmɨ́¹jáun² ca³zanh³ Sɨ³ñóh³ dáɨn² hí³, hi³ ca³ma³tsú² ma³jónh³² Dió³², hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Hnú² Juóu³² jná¹³, ta³né³² má²lɨ́¹³ bíh¹ jún³ jná¹³ cáun² hi³ re² hi³ tɨn², quí¹ má²lɨ́²ma³tih²¹ bíh¹ hnú² la³ cun³ jáɨ¹³ hi³ ca³jmuh³ hnú² jáun² quiúnh¹ jná¹³, tsá² lɨ́n³ jná¹³ quian²¹ hnú²; ");
INSERT INTO csoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","quí¹ má²lɨ́²jɨen¹ bíh¹ jná¹³ cun³quionh³ mɨ́¹ñi³² huen² Tsá² liáu³² jnoh¹, ");
INSERT INTO csoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tsá² ca³cuen²¹ hnú² lá² hi³ ca³tɨn¹ la³jɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tsá² lá² bíh¹ lɨ́n¹³ joh¹ hi³ taɨ²¹ ñí¹con² *tsá²cá²jo²¹, hi³ jmu³ tsú² siáh³ hi³ ma³quien² tsáu² tsá² Israel, tsá² joh² hnú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ jméi² mí¹ziú¹³ Jesús jmɨ́¹ ca³náɨ³² la³jɨ́³² jáɨ¹³ hi³ ca³juáh³ jáun² Sɨ³ñóh³ ca³tɨn¹ dáɨn² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hi³ jáun² Sɨ³ñóh³ ca³ma³mieh² tsá² hí³, hi³ ca³záɨh³ dí² Má²réi³ mí¹ziú¹³ Jesús: ―Sá¹nɨ́² jɨe³, dáɨn² lá² bíh¹ jmu³ hi³ juóun³² lɨ́n³² tsá² Israel hua³ jlính³, hi³ juóun³² lɨ́n³² tsá² tiá² jmɨ́¹ ná¹pin³ siáh³ nu³ tiánh³. Hi³ lɨ́n¹³ tsú² cáun² li²¹ hi³ juóun³² lɨ́n³² tsáu² tiá² jéi¹³; ");
INSERT INTO csoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","la³ jáun² bí¹ lɨ́¹³ hi³ lɨ³ lin¹ la³ cun³ hi³ ná¹tioh³ hñu³ tsɨ́³ tsáu² ma³ quin³² ma³ jan³². Hi³ ca³tɨn¹ huen² hnú² siáh³, chau²¹ jmáɨ¹ hi³ lɨ́¹³ honh² hnú² la³jmɨ́¹ lɨ́³ hi³ ja³hɨ́nh¹ nú² quionh³ cáun² mí¹jla². ");
INSERT INTO csoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ja³bí¹ ñí¹ jáun² siáh³ jmɨ́¹ zenh¹ jan² tsá²mɨ³ tsá² jmɨ́¹ lɨ́n³ *tɨ³² jë¹ Dió³², tsá² jmɨ́¹ jmáɨ² mɨ́¹ Hán¹, jon² hla¹ Fanuel, tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Aser. Tsá² hí³ má²lieih²¹ lɨ́n²¹ bíh¹. Tsá¹míh¹ bí¹ tsú² jmɨ́¹ ca³jenh² cuo², hi³ jáun² ca³cuá³ tsú² quiau³ mii² quionh³ ñí²cuo²; ");
INSERT INTO csoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","jmɨ́¹ lɨ²¹ jáun² né³, ca³lɨ³ hnáɨ³ bíh¹ tsú². Tiá² jmɨ́¹ cuá²haɨn³² yáh³ tsú² hñu³ cuáh³² chín¹ jáun², hi³ jmɨ́¹ cuá¹má²tsú² má²jónh³² Dió³² Juo¹³ dí² la³ huá² la³ jma², hi³ cuá¹má²hɨen²¹ hi³ cuá¹liéinh³² siáh³ Dió³²; hi³ jáun² jmɨ́¹jáun² jmɨ́¹ má²hún¹ tsú² quiéinh³ nio² quiú³ tsɨ²¹ quiún³ mii². ");
INSERT INTO csoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jáun² né³, mɨ́¹ Hán¹ hí³ ca³chó³² ñí¹ jmɨ́¹ tionh¹ tsú² jáun², hi³ jáun² ca³ma³tsú² má²jónh³² Dió³²; jmɨ́¹ lɨ²¹ jáun² ca³hléh³ tsú² hi³ ca³tɨn¹ dáɨn² Jesús hí³ ñí¹con² tsá² Israel tionh² ñí¹ jáun², tsá² ná¹jan³² hí³ hi³ liáu³ juú² Jerusalén ñí¹con² tsá² *romanos. ");
INSERT INTO csoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hi³ jáun² jmɨ́¹ má²lɨ́²ma³tí³² tsú² jáun² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ liei²¹ quioh²¹ Dió³² Juo¹³ dí², ja³tanh²¹ tsú² siáh³ tɨ³ juú²co¹, juú² Nazaret, juú² hɨ́n¹³ tɨ³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hi³ jáun² ca³cuon³ bíh¹ ñú²míh¹ hí³, hi³ tɨ³ lɨ³mí¹ tsá²lɨ³pin³, jɨ³ hi³ tɨ³ lɨ³mí¹ lɨ́²jnia² siáh³ jmɨ́¹ tsɨ́³, hi³ ca³ma³hé² ma³mieh² lɨ́n³² siáh³ Dió³². 2 ");
INSERT INTO csoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hi³ jáun² né³, cú² jéin² cú² mii² jmɨ́¹ tɨ³² *Jmɨ́¹hɨ́en¹ bíh¹, tɨ́² tsá²táunh¹ jméi² mí¹ziú¹³ Jesús tɨ³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jáun² né³, jmɨ́¹ ca³tsɨ́n¹³ jáun² quia³tún³ mieh² Jesús, ca³ñí¹jan² tsú² siáh³ já¹ juú² Jerusalén, la³ cun³ qui³ ná¹ngɨ²³ tsú² hi³ tsá²táunh¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jmɨ́¹ ca³tu³² jáun² jmáɨ¹ né³, ja³tanh²¹ bíh¹ tsú² tɨ³ juú²co¹; tɨ³la³ Jesús má¹ná¹, ca³ta³cua¹³ bíh¹ Jerusalén ta³ tiá² ñi³² jméi² mí¹ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jmɨ́¹ hí¹lɨ́n²³ tsú² hi³ cáun² cuá¹jáunh²³ bíh¹ Jesús ja¹ tsáu², hi³ tá¹la³ jáun² né³ ca³jmú³ tsú² cú² jmáɨ¹ juɨ³²; tɨ³la³ jmɨ́¹ ca³hnah² tsú² ñú²míh¹ Jesús ja¹ tsá² jún¹ tsá² raɨnh²¹ jɨ³ ja¹ tsá² má²cuóun³ quionh³ tsú² nɨ́² siáh³, ");
INSERT INTO csoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","tiá² ca³chanh²¹ yáh³ tsú². Hi³ jáun² já¹taunh²¹ tsú² siáh³ tɨ³ Jerusalén, hi³ ja³hniah² ñú²míh¹ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jmɨ́¹ la³ má²hnɨ³² jmáɨ¹ jáun² máh³, ca³chanh²¹ tsú² ñú²míh¹ hñu³ cuáh³² chín¹, hi³ cuá¹tón²¹ ja¹ quioh²¹ tɨ³² liei²¹, hi³ cuá¹náɨ³² jáɨ¹³ quioh²¹ tsá² hí³, jɨ³ hi³ cuá¹nga² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hi³ jáun² ca³la³ jɨ́n³² tsá² jmɨ́¹ ná¹náɨ³² hí³ jë¹ ñú²míh¹, jmɨ́¹ ná¹tsá²cáun² tsɨ́³ cun³ñí¹ hi³ jlánh¹ re² jmɨ́¹ cuá¹nga² ñú²míh¹ hí³, jɨ³ ca³tɨ²¹ la³jɨ́³² hi³ jmɨ́¹ má²ñi³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jáun² lɨ́¹ ca³lɨn³ bíh¹ jméi² mí¹ziú¹³ jmɨ́¹ ca³jɨ́e³; hi³ jáun² ca³juáh³ mí¹ziú¹³: ―Jón³, ¿he³ láɨh³² la³ nɨ́² lɨ́²jmoh¹ hnú² jnoh¹? Jmɨ́¹ má²hɨ³² lɨ́n³² bíh¹ tsɨn³² jná¹³ quiúnh¹ ná¹ ñeh² nú², hi³ má²lɨ́²hnauh¹³ lɨ́n³² jnoh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Hi³ jáun² Jesús ca³juáh³: ―¿He³ láɨh³² hnauh²³ hnoh² jná¹³? ¿Hí¹ tiá² ñíh¹ hnoh² hi³ ca³tɨn¹ jná¹³ ñi²¹ hñú¹³ Ñuh³²? ");
INSERT INTO csoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tɨ³la³ jméi² mí¹ziú¹³ tsú² tiá² ca³ngɨ¹³ yáh³ hi³ ca³juáh³ jáun² jon². ");
INSERT INTO csoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hi³ jáun² ja³tanh²¹ bíh¹ tsú² quionh³ ñú²míh¹ juú² Nazaret. Hi³ jáun² ñú²míh¹ hí³ jmɨ́¹ tanh² ta²¹ jméi² mí¹ziú¹³; hi³ mí¹ziú¹³ tsú² né³, ca³hmá³ hñu³ tsɨ́³ la³jɨ́³² hi³ má²lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tá¹la³ ca³cuon³ jáun² Jesús, tɨ³ lɨ³mí¹ re² jmɨ́¹ cháunh²³ bíh¹ tsɨ́³, hi³ Dió³² ca³lɨ³ hiún² siáh³ tsɨ́³ ca³tɨn¹ tsú², hi³ ca³lɨ³ hiún² siáh³ tsɨ́³ la³jɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","La³ má²quia³hñá³ mii² hi³ lɨ́n³ jáun² Tiberio *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma, ja³bí¹ Poncio Pilato jmɨ́¹ lɨ́n³ tsá² ho² ta²¹ ñí¹con² tsá² hɨ́n¹³ tɨ³ Judea. Ja³bí¹ jmáɨ¹ jáun² jmɨ́¹ lɨ́n³ Herodes ta²¹ ñí¹con² tsá² hɨ́n¹³ tɨ³ Galilea, jáun² Pí²liéi¹ raɨnh²¹ Herodes hí³ jmɨ́¹ lɨ́n³ siáh³ ta²¹ ñí¹con² tsá² hɨ́n¹³ tɨ³ Iturea jɨ³ Traconite nɨ́² siáh³, hi³ Lisanias né³, jmɨ́¹ lɨ́n³ ta²¹ ñí¹con² tsá² hɨ́n¹³ tɨ³ Abilinia. ");
INSERT INTO csoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ja³bí¹ jmáɨ¹ jáun² jmɨ́¹ lɨ́n³ Anás mí²tsá² hɨ́en¹ quionh³ Caifás. Jmɨ́¹jáun² ca³cué³ Dió³² cáun² jáɨ¹³ ñí¹con² Juan² jon² Zacarías tá¹la³ jmɨ́¹ cuá³ tsú² jáun² hué³² quiéin². ");
INSERT INTO csoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jáun² Juan² hí³ ca³ñí¹nga¹ la³ tán¹ can³² cua³ Jordán, hi³ zaɨh³² tsú² tsáu² hi³ ca³tɨ²¹ zón³² tsú² jmáɨ², hi³ hniáuh³² záɨ³² tsú² jmɨ́¹ tsɨ́³ nɨ́² siáh³, hi³ jáun² lɨ́¹³ hin³ tsáu¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","La³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ jáun² hla¹ Isaías tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin², hi³ ca³juáh³ tsú² jáun² la³ lá²: Tɨ³ hué³² quiéin² niéih³ cáun² ho³ tsáu² hi³ ñí¹juah²¹: Jmu³ náh² hua³jan²¹ juɨ³² ñí¹ já²¹ Juo¹³ dí²; jmu³ náh² cáun² juɨ³² cú²tso². ");
INSERT INTO csoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hniáuh³² conh²¹ la³jɨ́³² ñí¹ há¹tɨ́² há¹hmúh²³, jɨ³ la³jɨ́³² ñí¹ lɨ́³ máh³ la³ má²quionh³ tsɨ³ cuánh² tsɨ³ jën³ nɨ́² hniáuh³² lɨ́¹³ máɨ², la³jɨ́³² juɨ³² jliu³² siáh³ hniáuh³² la¹³ cú²tso², jɨ³ la³jɨ́³² juɨ³² tiá² re² máɨ² nɨ́² hniáuh³² la¹³ máɨ²; ");
INSERT INTO csoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","hi³ jáun² la³jɨ́n³² tsá² zian² hngá¹máh³ lɨ́¹³ jɨ́en³² tsá² liáu³² dí² hi³ cuen³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jmɨ́¹ cuá¹taunh²¹ jáun² tsá² hnió³ zón³² jmáɨ² né³, ca³záɨh³ dí² la³ lá²: ―¡Hnoh² dá² jón²zɨ́h¹ jon²cho¹ jáh³hláɨnh¹ bíh¹! ¿Hin² dá² tsánh² ca³záɨ³ hnoh² hi³ hniáuh³² cuóunh¹³ náh² ca³tɨ²¹ uu³mí²tsɨ³² hi³ má²ja³² má²janh²? ");
INSERT INTO csoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Jmu³ náh² lin¹ hi³ má²ca³za² jmɨ́¹ honh² náh², ha³ lɨ́²uú² lɨ́¹ cuú¹ lɨ́n¹³ náh² hi³ lɨ́¹³ liáun³ náh² cun³ñí¹ hi³hliá² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹, quí¹ jná¹³ juanh³² hi³ hí¹ ca³la³ tɨ³ quɨ́n¹ lá² yáh³ lɨ́¹³ jmu³ Dió³² hi³ láɨn¹ jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Quí¹ má²rá¹lɨ́³ bíh¹ hua³jan²¹ mí¹chí¹ hi³ quiúh³² tsú² la³jɨ́³² hmá² tiá² máɨ³ chu²¹ háɨ³², hi³ jáun² tsa³toh³ já¹ sɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hi³ jáun² jmɨ́¹jáun² ca³ngáɨ³ la³jɨ́n³² tsá² hí³, hi³ ca³juáh³: ―¿He³ bíh¹ hniáuh³² jmú¹³ jnoh¹ né³? ");
INSERT INTO csoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jáun² Juan² ca³juáh³: ―Nɨ́¹juáh³ tsá² nióh³² tun³ ha¹, hniáuh³² cué³² tsú² cáun² ñí¹con² tsá² tiá² zia³² hí¹ cáun² quioh²¹; hi³ nɨ́¹juáh³ tsá² zia³² siáh³ má³² quioh²¹, hniáuh³² tsóh³ tsú² ñí¹con² tsá² tiá² zia³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jáun² jmɨ́¹jáun² cua³taunh²¹ siáh³ *tsá² chi² hmah²¹ hi³ hnió³ zón³² jmáɨ², hi³ jáun² ca³ngáɨh³ dí² Juan²: ―Hnú² tɨ³², ¿he³ bíh¹ hniáuh³² jmú¹³ jnoh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hi³ jáun² Juan² ca³juáh³: ―Ha³ lɨ́² can² náh² hmah²¹ chí¹nga² la³ cun³ bí¹ hi³ má²lɨ́²juáh³ juóuh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ja³bí¹ jmɨ́¹jáun² cua³taunh²¹ siáh³ ma³ jan² hliáu³ hi³ ca³ngáɨh³ Juan²: ―Hi³ jnoh¹ né³, ¿he³ hniáuh³² jmú¹³ jnoh¹? Hi³ jáun² Juan² ca³záɨh³ siáh³ tsá² hí³: ―Ha³ lɨ́² jmu² náh² hian² honh² hi³ quin¹³ náh² hi³ quioh²¹ tsáu²; hi³ sa³jun³ cueh¹ náh² tsú² tso³, cáun² hi³ tiá² lɨ́²jmú³ tsú². Hniáuh³² má¹hiúnh¹³ náh² honh² la³ cun³ hmah²¹ hi³ má²hlánh¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","La³jɨ́n³² tsá² tionh² hí³ jmɨ́¹ má²ná¹jan² Tsá² lɨ́n³ Cristo, Tsá² ca³jmú³ hí³ Dió³² jáɨ¹³ hi³ zen³; hi³ jáun² jmɨ́¹jáun² ca³juu³ ca³hlénh³ hi³ ca³juáh³ hu³sa³ Juan² bíh¹ lɨ́n³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tɨ³la³ Juan² ca³juáh³, hi³ ca³záɨh³ la³jɨ́n³² tsá² hí³: ―Tson² bíh¹ jná¹³ ziau² jmáɨ² hnoh² cun³quionh³ jmɨ́² jma³; tɨ³la³ né³bí¹ já²¹ jan² Tsá² jlánh¹ quien² la³ cun³ bí¹ jná¹³, quí¹ cun³ tiá² cu³ tiá² ren³ bíh¹ jná¹³ quiúnh¹ ná¹ Tsá² hí³, hi³ sa³jun³ quien² jná¹³ hi³ hueh²¹ láu² tsɨ³² ta³ tsú². Jáun² Tsá² hí³ bíh¹ ziau³ hnoh² jmáɨ² cun³quionh³ Jmɨ́²chí³ Chun¹ jɨ³ cun³quionh³ sɨ́² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Má²zianh³² bíh¹ Tsá² hí³ cuah²¹ quioh²¹ hi³ chí³² cuú²miih²¹, hi³ jáun² tsa³cuɨ́³² má¹quɨ³². Chá³² tsú² cu³lɨ²¹ cuú²miih²¹ má²jɨ² jáun² ñéih³ hñu³cuɨ́³ quioh²¹; hi³ jáun² má¹quɨ³² jáun² né³, tsa³toh³ já¹ sɨ́² bíh¹, cáun² sɨ́² hi³ tiá² tón³² jmáɨ¹ yéi³². ");
INSERT INTO csoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hliáun³ lɨ́n³² bíh¹ hi³ ca³hlɨ³ ca³liéinh³² Juan² tsáu². La³ jáun² bíh¹ lɨ³ hi³ ca³nga³ tsú² jú¹ chú³² quioh²¹ Dió³² ñí¹con² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ja³bí¹ la³ jáun² ca³jí³ tsú² siáh³ hi³ ca³tɨn¹ Herodes tsá² cuá¹lɨ́n³ ta²¹ hué¹³ Galilea jáun², quí¹hliá² ca³jan³ tsú² Herodías ñí²cuo² Pí²liéi¹ raɨnh²¹; hi³ ja³bí¹ ca³jí³ tsú² siáh³ ca³tɨ²¹ la³jɨ́³² ta²¹ hlaɨh³ hi³ má²ca³jmú³ tsú² ñí¹ hná¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tɨ³la³ Herodes hí³, cun³ jáun² ca³jmú³ bíh¹ cónh³í¹ cáun² hi³ hlah³: hi³ ca³tanh² Juan² hñu³mí¹ñí², tsá² jmɨ́¹ zion² hí³ jmáɨ² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ñeh² bí¹ hi³ quiunh²¹ Juan² la³ jáun², tá¹la³ jmɨ́¹ dí¹zion² jáun² Juan² jmáɨ² la³jɨ́n³² tsáu², ja³bí¹ jmɨ́¹jáun² siáh³ cáun³ Jesús jmáɨ². Tá¹la³ jmɨ́¹ dí¹liéinh³² jáun² Jesús Jméi² né³, ca³niá³ hñu³mɨ³cuú²; ");
INSERT INTO csoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","hi³ jáun² jmɨ́¹jáun² ca³son² Jmɨ́²chí³ Chun¹ ñí¹ quioh²¹ dí² hi³ jniá³ la³jmɨ́¹ jniá³ jan² jáɨ². Hi³ jáun² jmɨ́¹jáun² ñí¹ja²¹ siáh³ cáun² mah¹, hi³ ñí¹juah²¹: ―Hnú² bíh¹ Jón³² jná¹³, Tsá² hno³ lɨ́n³² jná¹³; jlánh¹ hiún² tsɨn³² jná¹³ ca³tɨn¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quiu³quia³ mii² jmɨ́¹ má²hún¹ Jesús la³cun³ jmɨ́¹ ca³ma³liáu³² tá¹³. Jáun² né³, la³ cun³ hi³ jmɨ́¹ ná¹lɨ́n²³ jáun² tsáu² hi³ jon² Sé³² bíh¹ Jesús; jáun² jméi² Sé³² né³ jmáɨ² Elí. ");
INSERT INTO csoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Matat bíh¹ jméi² Elí, Leví bíh¹ jméi² Matat, Melqui bíh¹ jméi² Leví, Jana bíh¹ jméi² Melqui, Sé³² bíh¹ jméi² Jana, Matatías bíh¹ jméi² Sé³², ");
INSERT INTO csoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Amós bíh¹ jméi² Matatías, Nahum bíh¹ jméi² Amós, Esli bíh¹ jméi² Nahum, Nagai bíh¹ jméi² Esli, Maat bíh¹ jméi² Nagai, ");
INSERT INTO csoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Matatías bíh¹ jméi² Maat, Semei bíh¹ jméi² Matatías, Josec bíh¹ jméi² Semei, Judá bíh¹ jméi² Josec, Joanán bíh¹ jméi² Judá, ");
INSERT INTO csoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Resa bíh¹ jméi² Joanán, Zorobabel bíh¹ jméi² Resa, Salatiel bíh¹ jméi² Zorobabel, Neri bíh¹ jméi² Salatiel, Melqui bíh¹ jméi² Neri, ");
INSERT INTO csoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Adi bíh¹ jméi² Melqui, Cosam bíh¹ jméi² Adi, Elmadam bíh¹ jméi² Cosam, Er bíh¹ jméi² Elmadam, Josué bíh¹ jméi² Er, ");
INSERT INTO csoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eliezer bíh¹ jméi² Josué, Jorim bíh¹ jméi² Eliezer, Matat bíh¹ jméi² Jorim, Leví bíh¹ jméi² Matat, ");
INSERT INTO csoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sɨ³ñóh³ bíh¹ jméi² Leví, Judá bíh¹ jméi² Sɨ³ñóh³, Sé³² bíh¹ jméi² Judá, Jonam bíh¹ jméi² Sé³², Eliaquim bíh¹ jméi² Jonam, Melea bíh¹ jméi² Eliaquim, ");
INSERT INTO csoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Mena bíh¹ jméi² Melea, Matata bíh¹ jméi² Mena, Natán bíh¹ jméi² Matata, Dá²vi²¹ bíh¹ jméi² Natán, ");
INSERT INTO csoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Isaí bíh¹ jméi² Dá²vi²¹, Obed bíh¹ jméi² Isaí, Booz bíh¹ jméi² Obed, Sala bíh¹ jméi² Booz, Naasón bíh¹ jméi² Sala, Aminadab bíh¹ jméi² Naasón, ");
INSERT INTO csoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Admin bíh¹ jméi² Aminadab, Arni bíh¹ jméi² Admin, Esrom bíh¹ jméi² Arni, Fares bíh¹ jméi² Esrom, Judá bíh¹ jméi² Fares, Jacob bíh¹ jméi² Judá, ");
INSERT INTO csoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Isaac bíh¹ jméi² Jacob, Há²bran²¹ bíh¹ jméi² Isaac, Taré bíh¹ jméi² Há²bran²¹, Nacor bíh¹ jméi² Taré, Serug bíh¹ jméi² Nacor, ");
INSERT INTO csoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ragau bíh¹ jméi² Serug, Peleg bíh¹ jméi² Ragau, Heber bíh¹ jméi² Peleg, Sala bíh¹ jméi² Heber, Cainán bíh¹ jméi² Sala, ");
INSERT INTO csoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Arfaxad bíh¹ jméi² Cainán, Sem bíh¹ jméi² Arfaxad, Noé bíh¹ jméi² Sem, Lamec bíh¹ jméi² Noé, Matusalén bíh¹ jméi² Lamec, ");
INSERT INTO csoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Enoc bíh¹ jméi² Matusalén, Jared bíh¹ jméi² Enoc, Mahalaleel bíh¹ jméi² Jared, Cainán bíh¹ jméi² Mahalaleel, Enós bíh¹ jméi² Cainán, ");
INSERT INTO csoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Set bíh¹ jméi² Enós, Adán bíh¹ jméi² Set, hi³ jáun² né³, Dió³² bíh¹ jméi² Adán. ");
INSERT INTO csoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jmɨ́¹ má²cáun³ jáun² Jesús jmáɨ² né³, cua³han³ cua³ Jordán, ca³la³ canh² Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³; hi³ jáun² Jmɨ́²chí³ Chun¹ hí³ né³, ca³jau³ Jesús tɨ³ hué³² quiéin². ");
INSERT INTO csoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Hué³² quiéin² jáun² né³, ca³cuá³ tsú² tu³ló³² jmáɨ¹, hi³ jáun² ñí¹ jáun² ca³ca³ ca³lau³ tsú² tsá² hláɨnh¹. Tá¹la³ jáun² né³, hí¹ cú¹pih²¹ má³² tiá² ca³cúh² yáh³ tsú². Jmɨ́¹ lɨ²¹ jáun² né³, ca³lɨ³ ñí¹cuóunh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jmɨ́¹jáun² ca³záɨh³ tsá² hláɨnh¹ Jesús la³ lá²: ―Nɨ́¹juáh³ tson² bíh¹ hnú² Jon² Dió³², jmu³ neh²¹ hi³ quɨ́n¹ lá² jeinh²¹ *hí³ cuú²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tɨ³la³ Jesús ca³juáh³: ―Ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Jun³juáh¹³ cun³quionh³ jmáh³la³ hí³ yáh³ lɨ́¹³ zian² tsáu², tɨ³la³ la³ má²quionh³ la³jɨ́³² jáɨ¹³ hi³ ja³² ho³ Dió³² bíh¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jáun² tsá² hláɨnh¹ hí³ ca³jan³ Jesús cáun² tsɨ³ máh³ ñe¹ lɨ́n²¹, hi³ jáun² ñí¹ jáun² ca³jmú³ dí² siáh³ hi³ jɨ́e³ Jesús cu³tiá³ pih²¹ la³jɨ́³² juú² ñí¹ ná¹hu²¹ cuo² tsá² ná¹lɨ́n³ ta²¹ tá¹ cáun² hngá¹máh³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jáun² ca³záɨh³ dí² siáh³ la³ lá²: ―Jná¹³ cué¹³ jáɨ¹³ hi³ hnú² jmúh¹³ héih³² ñí¹con² la³jɨ́³² juú² jniá³ nɨ́², la³ má²quionh³ la³jɨ́³² hi³ zia³² nɨ́² quioh²¹ siáh³. Quí¹ jo³uón³² jná¹³ bíh¹ má²nio² la³jɨ́³² hi³ jniá³ nɨ́², hi³ jáun² ñí¹con² lɨ³ua³ jan² tsá² hnó³² jná¹³ cue¹, jná¹³ bíh¹ tsá² cue¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jáun² né³, nɨ́¹juáh³ dí¹jñih²¹ hnú² ta³ ñi³² jná¹³, hi³ má¹tsú¹ má¹jauh²¹ nú² jná¹³, jáun² hnú² bíh¹ hian³ ca³la³ jɨ́³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tɨ³la³ Jesús ca³záɨh³ tsá² hláɨnh¹ hí³: ―Cuánh² quián¹³ *Satanás, quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Ma³tsú¹ ma³jonh²¹ Dió³² Juóuh³², hi³ ñí¹jɨ́²¹ la³ jan² tán¹ hí³ bíh¹ má¹cú¹ má¹haɨn²¹ nú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jmɨ́¹ lɨ²¹ jáun² né³, ca³jan³ siáh³ tsá² hláɨnh¹ Jesús já¹ juú² Jerusalén hi³ ca³ñí¹di³chin³ dí² Jesús tɨ³ tsáɨh³ cuáh³² chín¹, jáun² ca³záɨh³ dí²: ―Nɨ́¹juáh³ tson² cu³tí³ hi³ hnú² Jon² Dió³², tanh² la³ tɨ³ hué³² ó³² neh²¹; ");
INSERT INTO csoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³ la³ lá²: Dió³² zen³ tsá²cuú² tsá²ta³ hi³ jmu³ hua³hí¹³ hnú²; ");
INSERT INTO csoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","hi³ ziau³ tsú² hnú² cun³quionh³ cuo² hmóu³², quí¹ nɨ́² lɨ́¹ ca³cuɨ́h³ tanh¹ hnú² cun³quionh³ quɨ́n¹. ");
INSERT INTO csoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tɨ³la³ Jesús ca³ngáɨ³ siáh³: ―Ja³bí¹ ñí¹ Sí² jáun² siáh³ rá¹juáh³: “Ha³ lɨ́² cá² lɨ́² lan³ hnú² Dió³² Juóuh³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hi³ jáun² jmɨ́¹ má²lɨ́²cá² lɨ́²lian³ tsá² hláɨnh¹ Jesús cun³quionh³ la³jɨ́³² hi³ nɨ́² né³, ca³quin³ cu³tiá³ tɨ³ có³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jmɨ́¹ jaunh²¹ jáun² Jesús Galilea, ca³la³ canh² pí³ quioh²¹ Jmɨ́²chí³ Chun¹ hñu³ tsɨ́³. Jmɨ́¹jáun² jlánh¹ ca³juu³ ca³hlénh³ tsáu² hi³ ca³tɨn¹ tsú² la³cu³ la³jéin³ tá¹ cáun² hué³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hi³ jáun² ñí¹ jáun² ca³ñí¹ma³tɨn² tsú² tsáu² ma³ quin³² ma³ caun³² juú² ñí¹ lɨ́³ cuáh³² quioh²¹ tsá² *judíos. Hi³ jáun² la³jɨ́n³² tsá² hí³ ca³ma³quien² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jáun² né³, ngah³ siáh³ Jesús juú² Nazaret ñí¹ cá¹cuon³. Jáun² *jmáɨ¹ hi³ tionh² jáun² tsá² judíos tie³, ca³hi³ tsú² hñu³ cuáh³², la³ cun³ qui³ tan² tsú² jmu². Hi³ jáun² ca³jmú³ tsú² zenh² hi³ hɨ́³² Sí² tioh³ jáɨ¹³ quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Jáun² né³, ñí¹con² Jesús ca³cué³ tsáu² Sí² quioh²¹ hla¹ Isaías, tsá² jmɨ́¹ lɨ́n³ *tɨ³² jë¹ Dió³². Jmɨ́¹ ca³jen³ tsú² sí² jáun², jáun² ca³choh¹³ tsú² ñí¹ rá¹juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Jmɨ́²chí³ joh¹ Juóu³² jná¹³ ta³ cuá¹tsɨ²¹ ñí¹ quion²¹ jná¹³, quí¹ má²ca³jmú³ tsú² hi³ cuá¹chan¹ jná¹³ hi³ ñí¹cué³ jú¹ chú³² ñí¹con² tsá² tia³mii²; ca³ze³ tsú² jná¹³ hi³ jmah²¹ jná¹³ tsá² nio² hlah³ tsɨ́³ hi³ ngáɨ¹ jná¹³ siáh³ jú¹ chú³² ñí¹con² tsá² ná¹tson³ hi³ lɨ́¹³ liáun³ tsú², hi³ jmu¹ jná¹³ siáh³ hi³ niá³ ñí¹ tsá² ná¹ten³, hi³ lion¹ jná¹³ siáh³ tsá² quiú¹ jín¹; ");
INSERT INTO csoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","hi³ ja³ngáɨ¹ jná¹³ jáɨ¹³ ca³tɨ²¹ jmáɨ¹ chu²¹ quioh²¹ Dió³² Juo¹³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jmɨ́¹ lɨ²¹ jáun² né³, ca³tseh² siáh³ Jesús sí² jáun², hi³ ca³jɨenh³ tsú² siáh³ tsá² ho² jáɨ¹³ cuáh³² jáun²; jmɨ́¹jáun² ca³cuá³. Jáun² la³jɨ́n³² tsá² tiáunh¹ hí³ hñu³ cuáh³² ca³jɨ́e³ ca³la³ chí¹tiá³ ñí¹ tɨ³ ñí¹ cuá³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jáun² ca³hléh³ tsú² ñí¹con² tsá² tionh² hí³, hi³ ca³juáh³ la³ lá²: ―Né³² má²ca³lɨ³tí³ ñí¹ hó²¹máh¹ náh² la³ cun³ juáh³ ñí¹ Sí² quioh²¹ Dió³² hi³ má²lɨ́²hɨ́³ jná¹³ nɨ́² ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","La³jɨ́n³² bíh¹ tsáu² jmɨ́¹ ná¹hleh³² re² hi³ ca³tɨn¹ tsú², hi³ jmɨ́¹ ná¹tsá²cáun² siáh³ tsɨ́³ ca³tɨ²¹ jáɨ¹³ chu²¹ hi³ jmɨ́¹ cuá¹hleh³² tsú² jáun² ca³tɨ²¹ hi³ ja³² mií³ tsɨ́³ Dió³². Jmɨ́¹jáun² ca³juu³ ca³hlénh³ tsá² hí³ má²tún² hmóu³²: ―¿Há¹ jun³ tsá² nɨ́² bíh¹ hí³ jon² hla¹ Sé²¹? ");
INSERT INTO csoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jáun² Jesús ca³záɨh³ tsá² hí³: ―Cu³tí³ bíh¹ juo¹³ hnoh² jná¹³ jáɨ¹³ lá²: “Hnú² tɨ³² mɨ́³, jmah²¹ huen² neh²¹”. Hi³ juo¹³ hnoh² siáh³ jná¹³ la³ lá²: “Jmu³ siáh³ juú²cáu³ dí² lá² neh²¹, la³ cun³ hi³ má²ca³náɨ¹³ jnoh¹ hi³ ca³jmuh³ hnú² já¹ juú² Capernaum”. ");
INSERT INTO csoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Hi³ jáun² la³ má²hleh³² jáun² bíh¹ Jesús, hi³ ca³juáh³: ―Jú¹ tson² juanh³² jná¹³ ñí¹con² hnoh², hi³ hí¹ jan² yáh³ tɨ³² jë¹ Dió³² tiá² lɨ́²quien² juú²co¹. ");
INSERT INTO csoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ja³bí¹ zia³² siáh³ cáun² jú¹ tson² hnó³² jná¹³ juanh²¹ ñí¹con² hnoh²: Jmáɨ¹ hi³ jmɨ́¹ zian² jáun² Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³², ca³chó³² jmáɨ¹ hi³ tiá² tsau³ jmɨ́³ hí¹ cú¹pih²¹ cun³ hnɨ³² mii² tón³²; ja³bí¹ jmáɨ¹ jáun² siáh³ ca³lɨ³ ho³cuóun³ tá¹ cáun² hué³² lá². Ti³tsóh³dí¹ jmáɨ¹ jáun² jmɨ́¹ zian² juóun³² lɨ́n³² tsá²mɨ³ hnáɨ³ hué³² *Israel lá²; ");
INSERT INTO csoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","tɨ³la³ jmɨ́¹jáun² né³ tiá² ca³zen³ yáh³ Dió³² Líh³ hí³ ñí¹con² hí¹ jan² tsá²mɨ³ hnáɨ³ tsá² jmɨ́¹ zian² hué³² *Israel lá², tɨ³la³ Dió³² ca³zen³ Líh³ hí³ ñí¹con² jan² tsá²mɨ³ hnáɨ³ *tsá²cá²jo²¹ zian² juú² Sarepta bíh¹, juú² hɨ́n¹³ tɨ³ Sidón. ");
INSERT INTO csoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ja³bí¹ jmáɨ¹ hi³ jmɨ́¹ zian² hla¹ Eliseo tsá² jmɨ́¹ lɨ́n³ tɨ³² jë¹ Dió³², jmɨ́¹ zian² juóun³² tsá² ná¹lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³ hué³² Israel lá², tɨ³la³ hí¹ jan² yáh³ tsá² hí³ tiá² ca³lan³, jmáh³la³ hla¹ Naamán tsá²cá²jo²¹ zian² hué³² Siria bíh¹ lan³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jmɨ́¹ ca³náɨ³² jáun² tsá² hí³ hi³ ca³juáh³ Jesús la³ nɨ́² né³, ca³la³ jɨ́n³² bíh¹ tsá² jmɨ́¹ tionh¹ hí³ hñu³ cuáh³² ca³míh³ lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jáun² ca³nu³ ca³tiánh³ tsú² hi³ ca³chin² Jesús tɨ³ cheih³² juú². Juú² jáun² quioh²¹ tsú² jmɨ́¹ nio¹ cáun² ñí¹ lɨ́³ tsáɨh³ máh³, jáun² ca³jan³ tsú² Jesús hi³ jmɨ́¹ já¹hlian² dí² ñí¹ lɨ́³ hná¹ cho¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Tɨ³la³ Jesús má¹ná¹, cáun² ca³nga³ bíh¹ chu³jo² ja¹ ñí¹ tionh¹ jáun² tsá² hí³, hi³ ngah³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hi³ jáun² Jesús ngau³ Capernaum, juú² hɨ́n¹³ tɨ³ Galilea, jáun² ñí¹ jáun² ca³ma³tɨn² tsú² tsáu² jmáɨ¹ hi³ tionh² tsá² judíos tie³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jáun² tsá² hí³ lɨ́¹ ca³ja³cáun² tsɨ́³ ca³tɨ²¹ jáɨ¹³ hi³ jmɨ́¹ cuá¹má²ta² jáun² Jesús, quí¹hliá² jmɨ́¹ cuá¹hɨeh³² tsú² tsáu² la³juah²¹ dúh¹ jan² tsá² ho² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hñu³ cuáh³² jáun² jmɨ́¹ cuá³ jan² tsá²ñuh² hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. Tsá² hí³ ca³hóh³² tiá³, hi³ ca³juáh³: ");
INSERT INTO csoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¿He³ jáɨ¹³ zia³² quiúnh¹ jnoh¹ hnú², Jesús Tsá² Nazaret? ¿Hí¹ ñeh³ hnú² hi³ ña³cua² nú² jnoh¹ quiu³juóu³²? Tsá² cuóu³² bíh¹ jná¹³ hnú², hi³ ño¹ jná¹³ hi³ hnú² Tsá² hɨ́en¹ Tsá² zéi¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jáun² Jesús ca³ngáɨ³ tiá³ ñí¹con² jmɨ́²chí³ hláɨnh¹ hí³, hi³ ca³juáh³: ―¡Tie³ náu², tun³² tsá²ñuh² nɨ́²! Hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ né³, ca³jmú³ hi³ ca³quɨnh³ tsá²ñuh² hí³ ja¹ ñí¹ tionh¹ tsá² hí³, tɨ³la³ hí¹ cáun² yáh³ hi³ hlah³ tiú²uú² ca³jmú³ jmɨ́²chí³ hláɨnh¹ hí³ jmɨ́¹ cuá¹han³ jáun² hñu³ tsɨ́³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jáun² la³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³ja³cáun² tsɨ́³, hi³ ca³qui³ ca³ngáɨh³ raɨnh²¹, hi³ juáh³: ―¿Hín² ma³ dá² jáɨ¹³ hleh³² tsá² nɨ́², jáun² sa³ ca³la³ pin³ lɨ́n³² máh³ jë¹ tsú² hi³ jmu² héih³² hi³ huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jáun² la³jɨ́n³² tsá² tiáunh¹ hí³ cu³ jéin³ ñí¹ jáun² ca³qui³ ca³ngɨ³ jáɨ¹³ ca³tɨ²¹ hi³ jmu² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús hñu³ cuáh³² jáun² hi³ ngau³ hñú¹³ Sí¹mu²¹. Jmɨ́¹jáun² jmɨ́¹ rá²tsáun¹ mɨ³ziú¹³ Sí¹mu²¹ hi³ chéin³, jáun² tsá² tionh² hí³ ñéih³ ca³mɨ́³ ñí¹con² Jesús ca³tɨn¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jáun² Jesús ca³jmú³ dí¹hin³ can³² ñí¹ rón²¹ jáun² tsá² hí³, hi³ ca³jin³ mɨ́¹uɨ́³ chéi³ jáun², jáun² ca³quin³ bíh¹ hi³ jmɨ́¹ chéin³ tsú². Jáun² la³ cun³ jmɨ́¹jáun² ca³náu² tsá²mɨ³ hí³, hi³ ca³jmú³ má³² hi³ cuh³ tsú² jɨ³lɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Jmɨ́¹ má²ca³ta³tsɨ²¹ hiú², jáun² lɨ³ua³ jan² tsá² jmɨ́¹ zian² tsá² tsáun¹ raɨnh²¹ ca³ñí¹jan² ñí¹con² Jesús, he³ cáun² mɨ́¹uɨ́³ ná¹lɨ́n³ bíh¹ ma³ quin³² ma³ jan³² tsá² hí³. Hi³ jáun² Jesús ca³ra³tsɨ³² cuo² ñí¹ quioh²¹ ma³ quin³² ma³ jan³² tsá² hí³; la³ jáun² bíh¹ ca³jmú³ Jesús hi³ lan³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ja³bí¹ ja¹ tsá² tsáun¹ hí³ jmɨ́¹ ná¹tso¹ juóun³² tsá² ca³huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³; ca³la³ tiáunh¹ tɨ³ hóh³² bíh¹ jmɨ́²chí³ hláɨnh¹ hí³, hi³ juáh³: ―Hnú² bíh¹ Jon² Dió³². Tɨ³la³ Jesús ca³quiu³ ca³jin³ bíh¹ jmɨ́²chí³ hláɨnh¹ hí³, hi³ tiá² ca³cuéh³ dí² jáɨ¹³ hi³ hléh³², quí¹ tɨ³la³ jmɨ́²chí³ hláɨnh¹ hí³ má²ná¹ñi³² hi³ Jesús bíh¹ Tsá² lɨ́n³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jmɨ́¹ cá¹jniá²¹ jáun² né³, cua³han³ Jesús juú² jáun², hi³ ngau³ ñí¹ má²tɨ³ có³². Tɨ³la³ tsáu² né³ ca³hnauh² tsú², hi³ jáun² ca³cha³táunh¹ ñí¹ cuá³ tsú². Hi³ jmɨ́¹ hnió³ tsú² hi³ cuá³² Jesús, hi³ tiá² jmɨ́¹ cua³haɨn³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―Hniáuh³² bíh¹ hléh¹³ jná¹³ ñí¹con² tsá² juú² siáh³ uá²jaɨ³² jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsú² jo³cuo² Dió³², quí¹ ca³tɨ²¹ hi³ jáun² bíh¹ ca³ze³ jná¹³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hi³ jáun² la³ jáun² ca³ngɨ́³ Jesús hi³ ngaɨ³² jú¹ chú³² hñu³ cuáh³² quioh²¹ tsá² judíos hi³ táun³ hué¹³ Judea. ");
INSERT INTO csoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ zenh¹ Jesús can³² ñí¹ ná¹ho³ jmáɨ² téh²³ tsú² Genesaret; jáun² ñí¹ jáun² ca³cha³táunh¹ juóun³² tsáu², ca³la³ hi³ má²cuú² má²jaɨn³² bíh¹ tsú², hi³ hnió³ ne³ jáɨ¹³ quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jáun² ñí¹ jáun² ca³jɨ́e³ Jesús tun³ mu² lɨn²¹ hi³ ná¹háɨ²¹ ñí¹ má²tiéin² jmáɨ², quí¹ la³ má²ca³huén² bíh¹ tsá² quioh²¹ mu² jáun², hi³ jáun² jmɨ́¹ má²ná¹ráɨn³² bíh¹ tsú² hmá³ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hi³ jáun² Jesús ca³hi³ tɨ³ ñeh² cáun² mu² hi³ jmɨ́¹ quioh²¹ jáun² Sí¹mu²¹, hi³ jáun² ca³mɨ́³ dí² hi³ tsa³can³² tsú² ñí¹ má²ñe¹í¹ ca³lá² jmáɨ². Jáun² hñu³ mu² jáun² ca³cuá³ Jesús hi³ ca³ma³tɨn² tsá² tionh² hí³ can³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jmɨ́¹ cá¹táuh³ jáun² hi³ hleh³² dí², ca³záɨh³ dí² Sí¹mu²¹: ―Ma³cán¹ mu² lá² tɨ³ ñí¹ ñe¹ jmáɨ², ma³ñéih¹ hmá³ ma³zianh³² jáh³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tɨ³la³ Sí¹mu²¹ ca³ngáɨ³: ―Hnú² Tɨ³², ca³la³ jmɨ³ nie³ bíh¹ má²lɨ́²jmú¹³ jnoh¹ ta²¹, hi³ hí¹ jan² yáh³ jáh³ tiá² ca³jáun³ jnoh¹; tɨ³la³ cun³ñí¹ hi³ hnáuh² hnú², ñí¹ñéih¹ bí¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jmɨ́¹ ca³ñeh³ tsú² jáun² hmá³ né³, jmɨ́¹jáun² ca³janh²¹ tsú² juóun³² lɨ́n³² jáh³ jmáɨ², hí¹ ca³la³ tɨ³ hmá³ yáh³ ca³lɨ³liau³ caɨ³². ");
INSERT INTO csoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jmɨ́¹jáun² ca³jmú³ tsú² li²¹ ñí¹con² tsá² ná¹quian³² mu² cáun² jáun², hi³ ja³ma³hau³ tsú². Jáun² ja³taunh²¹ bíh¹ tsá² hí³ hi³ ñí¹can³² mu² cáun² jáun². Hi³ jáun² né³, tá¹ tun³ bíh¹ mu² jáun² ca³cónh³², hí¹ ca³la³ tɨ³ jmɨ́¹ má²ñí¹tsa³hanh³² yáh³ mu² jáun² hñu³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jmɨ́¹ ca³jɨ́e³ Sí¹mu²¹ Pé¹ hi³ lɨ³ la³ jáun², jáun² ca³di³jñí³² dí² ta³ ñí¹ Jesús hi³ ca³záɨh³ dí²: ―Hnú² Tɨ³², chú³² quin¹³ hnú² tɨ³ có³² ñí¹con² jná¹³, quí¹ tsá² ren² tso³ bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quí¹hliá² jlánh¹ ca³ja³cáun² lɨ́n³² tsɨ́³ Sí¹mu²¹, la³ má²quionh³ dí² tsá² quionh³, cun³ñí¹ hi³hliá² jlánh¹ juóun³² jáh³ jmáɨ² ca³janh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ja³bí¹ ca³ja³cáun² lɨ́n³² tsɨ́³ tá¹ gon³ jon² Zebedeo, tsá² jmáɨ² hí³ Jacobo jɨ³ Juan² nɨ́², tsá² jmɨ́¹ quionh³ hí³ Sí¹mu²¹. Tɨ³la³ Jesús ca³záɨh³ Sí¹mu²¹: ―Ha³ lɨ́² juenh³ hniu³², quí¹ né³² tɨ³ chí¹ján³ tsá²mɨ³cuóun² bíh¹ má²janh²¹ nú², cha³ jmɨ́¹ janh²¹ nú² jáh³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hi³ jáun² jmɨ́¹jáun² ca³huéh³ tsú² mu² jáun² hi³ ca³chá³ tsú² ñí¹ quiéin². Jáun² ñí¹ jáun² bíh¹ ca³ta³no¹ la³jɨ́³² hi³ jáun², quí¹ quionh³ Jesús bíh¹ tsú² já¹taunh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ Jesús cáun² juú². Juú² jáun² né³ ca³jenh² tsú² jan² tsá²ñuh² tsáun¹, hi³ lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³. Jmɨ́¹ ca³jɨ́en³² tsá² hí³ Jesús né³, ca³di³jñí³² dí² ta³ ñí¹, hi³ ca³jmú³ cuá¹hin³, hi³ ca³hiu³ ca³mɨ́³ quioh²¹, hi³ ca³juáh³: ―Hnú² Tɨ³², nɨ́¹juáh³ hnáuh² hnú², tɨn² bíh¹ hnú² jmúh¹³ hi³ lɨ³ jɨn² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hi³ jáun² Jesús ca³tí³ cuo² ñí¹ quioh²¹ tsú², hi³ ca³juáh³ la³ lá²: ―Hnó³² jná¹³. Hi³ jáun² ¡cuɨ́¹ lan² hnú²! Jmɨ́¹ má²lɨ́²juáh³ tsú² jáun² la³ nɨ́² né³, la³juɨ³² ca³hin³ bíh¹ mɨ́¹uɨ́³ jáun² quioh²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hi³ jáun² ca³jmú³ Jesús héih³² hi³ tiá² hniáuh³² chá³² tsú² ñí¹con² hí¹ jan² tsáu² hi³ ha³ lánh³ rón³² lan³, hi³ ca³záɨh³ dí² siáh³ la³ lá²: ―Jɨ́³²la³ ti³ cuánh², hi³ cuá²ma³jnia¹³ ñí¹con² mí²tsáu² bíh¹, hi³ cuá² cuen²¹ siáh³ jáh³ ñí¹con² Dió³² ca³tɨ²¹ hi³ má²ca³lɨ³ jɨn² nú², la³ cun³ lɨ́³ jáun² héih³² quioh²¹ hla¹ Moisés. Hi³ jáun² la³ jáun² lɨ³ ñi³² tsáu² hi³ má²laɨn³² nú². ");
INSERT INTO csoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tɨ³la³ tɨ³ lɨ³mí¹ ca³lɨ³ cuoh² bíh¹ tsáu² tá¹³ Jesús, jáun² tɨ³ jlánh¹ juóun³² tsáu² ca³cuú² ca³ngɨh³² bíh¹ hi³ náɨ³² jáɨ¹³ quioh²¹ tsú², jɨ³ tsá² má²hnió³ lan¹³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Tɨ³la³ Jesús má¹ná¹, jmɨ́¹ tsá²lienh³ Dió³² ñí¹ tiá² hin² zian² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ cuá¹má²tɨn² Jesús tsáu² ñéih³. Ñí¹ jáun² jmɨ́¹ tionh¹ ma³ jan² tsá² téh²³ tsú² *fariseos jɨ³ tsá² ná¹lɨ́n³ tɨ³² liei²¹ nɨ́², tsá² já²taunh²¹ la³jɨ́³² juú² hɨ́n¹³ tɨ³ Galilea, jɨ³ juú² hɨ́n¹³ tɨ³ Judea nɨ́², jɨ³ já¹ juú² Jerusalén nɨ́² siáh³. Hi³ jáun² jmáɨ¹ jáun² ca³lɨ³ lin¹ hi³ quian³² Jesús pí³ quioh²¹ Dió³² jmɨ́¹ ca³jmah³ tsú² jáun² tsá² tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jmɨ́¹jáun² cua³taunh²¹ tsá² ná¹jan² jan² tsá² hma², hi³ rá¹tsɨn² ñí¹ jmu², hi³ jmɨ́¹ hnió³ tsá² hí³ hi³ jmɨ́¹ tónh²¹ ñéih³, hi³ jmɨ́¹ tsa³jan² dí² tsá² tsáun¹ hí³ ta³ ñí¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tɨ³la³ tiá² ca³choh¹³ yáh³ tsú² hín² juɨ³² tónh³², quí¹hliá² jlánh¹ juóun³² tsáu² jmɨ́¹ tionh¹. Hi³ jáun² cáun² ca³uú³ tsáɨh³ hñú³ bíh¹ tsú² cú²jueh³², jáun² ca³quin³ tsú² ca³lá² cuá¹lá² jláɨ³ hñú³ jáun²; jáun² juɨ³² jaun³² bíh¹ ca³sió³ tsú² jmu² hi³ tsɨn² jáun² tsá² tsáun¹ hí³ cú²tso² chu³jo² ja¹ ñí¹ tionh¹ tsáu² ta³ ñí¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jmɨ́¹ ca³lɨ³tsɨn² jáun² Jesús hi³ cáun² tán¹ bíh¹ ná¹tioh³ tsɨ́³ tsá² ca³cha³táunh¹ hí³, hi³ jáun² ca³záɨh³ dí² tsá² tsáun¹ hí³ la³ lá²: ―Hnú² tsá²ñuh², má²cá²hin³ bíh¹ tso³ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Hi³ jáun² tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ tsá² fariseos nɨ́² ca³juu³ ca³hlénh³, hi³ ca³juáh³: ―¿Hin² dá² tsánh² tsá² nɨ́², sa³ tiá²³ máh³ tsɨ́³ chú² lén³² Dió³²? Quí¹ hí¹ jan² yáh³ tiá² hin² tɨn² hin³ tso³, jɨ́³²la³ hnga² Dió³² bíh¹ Tsá² tɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tɨ³la³ Jesús jmɨ́¹ ñi³² bíh¹ he³ lánh³ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ dí²: ―¿He³ láɨh³² sa³ la³ nɨ́² ná¹lɨ́n²³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Hín² jáɨ¹³ hi³ tun³ lá² hi³ jlánh¹ huán¹ tsɨ́³ lɨ³ lin¹ hi³ zia³² pí³ quioh²¹ tsá² hleh³²; hí¹ cun³quionh³ hi³ juáh³ tsú²: “Tso³ quián¹³ hnú² má²cá²hin³”, ho³ hi³ juáh³ tsú²: “Náu², ngɨ́¹”? ");
INSERT INTO csoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Re² bíh¹, cuɨ́¹ má¹jniá¹³ jná¹³ ñí¹con² hnoh² hi³ jná¹³ Jon² tsá²mɨ³cuóun², ho² ná¹ jáɨ¹³ ñí¹ hué²¹ lá² hi³ hin¹³ ná¹ tsáu¹³ tsáu². Hi³ jáun² ca³záɨh³ dí² siáh³ tsá² hma² hí³: ―Hnú² juo³ jná¹³: náu², ziáuh¹ jmu² quián¹³, quiaun², cuánh² hñuh³². ");
INSERT INTO csoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³náu² tsá² jmɨ́¹ hma² hí³ ta³ ñí¹ la³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñéih³, jáun² ca³ziauh³ jmu² hi³ jmɨ́¹ tsɨn², hi³ ca³caun² hi³ ngah³ hñú¹³ hi³ má²hí¹má²tsú² má²jónh³² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jáun² la³jɨ́n³² tsá² jmɨ́¹ ná¹jɨ́e²³ hí³ ca³ja³cáun² lɨ́n³² tsɨ́³, jáun² ca³ma³quien² tsú² Dió³². Jáun² ta³ má²hú¹ cóh²¹ tsɨ́³ bíh¹ tsú² ca³juáh³: ―Né³² má²lɨ́²neh²¹ dí² cáun² hi³ tiá² má²ca³neh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jmɨ́¹ lɨ²¹ jáun² cua³han³ Jesús, jáun² ca³jɨ́en³² dí² jan² *tsá² caɨ³² hmah²¹, tsá² jmáɨ² Leví, hi³ jmɨ́¹ cuá¹tón²¹ ñí¹ cuá¹caɨ³² hmah²¹ cha¹³ tsá² *romanos; hi³ jáun² ca³záɨh³ dí²: ―Ña³² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jmɨ́¹jáun² ca³náu² Leví, ca³tunh³ ta²¹ hi³ jmɨ́¹ cuá¹jmu² jáun², hi³ ngau³ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jmɨ́¹ lɨ²¹ jáun² ca³jmú³ Leví cáun² jmáɨ¹ jueh³² hñú¹³ hi³ ca³tɨn¹ Jesús, hi³ ca³ngɨh³² siáh³ juóun³² tsá² caɨ³² hmah²¹ la³ má²quionh³ tsá² siánh³ siáh³, hi³ ca³tiánh³ ñí¹ mesa quionh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tɨ³la³ tsá² cu³ nió³ téh²³ tsú² fariseos né³, jɨ³ la³ má²quionh³ tɨ³² liei²¹ nɨ́², ca³quiu³ ca³jin³ tsá² haɨn²¹ hí³ tɨ³ con² Jesús, hi³ ca³záɨh³ dí²: ―¿He³ láɨh³² sa³ hnoh² yáh³ cú² húh²³ náh² quiúnh¹ tsá² caɨ³² hmah²¹, jɨ³ tsá² ren² tso³ nɨ́² siáh³? ");
INSERT INTO csoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―Tiá² tɨ³² mɨ́³ hniah³ yáh³ ñí¹con² tsá² chun¹; tɨ³la³ ñí¹con² tsá² tsáun¹ bíh¹ hniah³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Quí¹ tiá² ja³ yáh³ jná¹³ hi³ ja³te³ tsá² chun¹, quí¹ hi³ ja³te³ tsá² ná¹ren² tso³ bíh¹ jná¹³ ja³, hi³ záɨ³² tsú² jmɨ́¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hi³ jáun² tsá² fariseos hí³ ca³záɨh³ Jesús: ―Tsá² haɨn²¹ tɨ³ con² Juan² tsá² zion² hí³ tsáu² jmáɨ², jɨ³ tsá² haɨn²¹ tɨ³ con² jnoh¹ tsá² fariseos siáh³ jlánh¹ má²hɨen²¹, hi³ liéinh³² siáh³ Dió³² chí¹ñi¹. ¿He³ láɨh³² sa³ la³ má²jmu² jáun² bíh¹ tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² hi³ cá² ñí¹ ná¹cú² ná¹hɨ́nh²³ bíh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jáun² Jesús ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ zian² tsá² ná¹tén¹ ñí¹ jmu² tsú² jmáɨ¹ hi³ jenh² cuo² tsáu², ¿hí¹ lɨ́¹³ jmúh¹³ hnoh² héih³² ñí¹con² tsá² la³ hí³ hi³ hniáuh³² ma³hɨen²¹ tsú² tá¹la³ má²ná¹má²hiún² tsú² jáun² tsɨ́³ quionh³ tsá²ñuh² tsá² jenh¹³ hí³ cuo²? ");
INSERT INTO csoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tɨ³la³ chau²¹ bíh¹ jmáɨ¹ hi³ quin³ tɨ³ có³² tsá²ñuh² tsá² jenh¹³ hí³ cuo²; hi³ jáun² má¹jáun² máh³ má²ma³hɨen²¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ja³bí¹ ca³jmú³ siáh³ Jesús cáun² jáɨ¹³ hi³ lɨ́³ la³ lá²: ―Hí¹ jan² yáh³ tiá² hin² tiu³² cú¹pih²¹ hmɨh³² hmaɨ²¹ hi³ táun³² cáun² hmɨh³² má²tseh¹. Quí¹ nɨ́¹juáh³ ca³jmú³ tsú² la³ jáun², lɨ́¹ tsa³hín³ bíh¹ hná¹ hmɨh³² hmaɨ²¹ jáun² lɨ́¹³; hi³ tiá² re² cunh³ ya³ siáh³ quionh³ hmɨh³² má²tseh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ja³bí¹ la³ jáun², hí¹ jan² yáh³ tiá² hin² tah³² mu² ráu³ cun³ ñí¹ dí¹jan³² hñu³ chí² láu² má²tseh¹; quí¹ nɨ́¹juáh³ hi³ jmu³ tsú² la³ jáun², má²cáɨ³² bíh¹ chí² láu² tseh¹ jáun² lɨ́¹³ hi³ jmu³ mu² ráu³ cun³ ñí¹ dí¹jan³² jáun²; jáun² lɨ́¹ má²tsa³hín³ bíh¹ mu² ráu³ jáun² lɨ́¹³, la³ má²quionh³ chí² láu². ");
INSERT INTO csoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Hi³ jáun² hñu³ chí² láu² hmaɨ²¹ bíh¹ hniáuh³² táh³² tsú² mu² ráu³ cun³ ñí¹ dí¹jan³², hi³ jáun² la³ jáun² tiá² hi³ láɨh¹³ tá¹ tun³. ");
INSERT INTO csoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nɨ́¹juáh³ zian² tsá² má²tan² hɨ́nh²³ mu² má²zéih¹, jáun² tsá² la³ hí³ tiú²uú² zaɨn³² yáh³ hɨ́nh³ mu² cun³ ñí¹ dí¹jan³², quí¹hliá² juáh³ tsú² hi³ hi³ má²zéih¹ bíh¹ tɨ³ jlánh¹ re² jmá³. La³ jáun² bíh¹ lɨ́n³ tsá² má²tan² cáun² hi³ ná¹ngɨ²³, tiá² hnió³ yáh³ tsú² ne³ cáun² hi³ hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ cuá¹ngɨ³² Jesús ja¹ ñí¹ zia³² hi³ jná¹ quioh²¹ tsáu² cáun² *jmáɨ¹ nio² tie³, hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² jmɨ́¹ hí¹caɨ³² chi² hieh² cuú²miih²¹; hi³ jáun² jmɨ́¹ hí¹hianh²³ tsú² quionh³ cuo², hi³ hí¹cúh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Hi³ jáun² ma³ jan² tsá² *fariseos ca³juáh³: ―¿He³ láɨh³² sa³ ta²¹ hi³ tiá² ca³tɨ²¹ jmu³ tsú² jmáɨ¹ nio² tie³ yáh³ jmuh³² hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jáun² Jesús ca³záɨh³ tsá² hí³: ―¿Tiá¹ má²ca³híh³ hnoh² ñí¹ Sí² quioh²¹ Dió³² hi³ he³ ca³jmú³ hla¹ re²¹ Dá²vi²¹ cu³ jéin³² jmɨ́¹ lɨ²¹ ñí¹cuóunh²¹ quionh³ tsá² quionh³? ");
INSERT INTO csoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tsá² hí³ dá² ca³ñí¹hi³² ñéih³ hñu³ cuáh³² lɨ́³ hmɨh³², hi³ ca³ñí¹quián¹³ *hí³ cuú²miih²¹ hɨ́en¹ hi³ jmɨ́¹ nio² jáun² ñéih³ ñí¹hiú¹³, hi³ ca³cúh²; ja³bí¹ ca³cuéh³ tsú² siáh³ tsá² quionh³. Tɨ³la³ hí³ jáun² né³, tiá² jmɨ́¹ ca³tɨn¹ yáh³ tsú² cuh³, quí¹ hí³ jáun² jmɨ́¹ ná¹chan¹ hi³ cúh² jmáh³la³ tsá² ná¹lɨ́n³ mí²tsáu² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja³bí¹ ca³záɨh³ tsú² siáh³ tsá² hí³: ―Jáun² né³, uá¹ hi³ jmáɨ¹ nio² tie³, cun³ jáun² cáun² ho² bíh¹ Jon² tsá²mɨ³cuóun² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ca³chó³² siáh³ cáun² jmáɨ¹ hi³ ca³ñí¹hi³² Jesús hñu³ cuáh³² quioh²¹ tsá² *judíos cáun² jmáɨ² nio² tie³; hi³ jáun² ñí¹ jáun² ca³ma³tɨn² tsú² tsáu². Jáun² ñí¹ jáun² jmɨ́¹ cuá³ jan² tsá² má²ca³náɨ³ cuá² chu²¹ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hi³ jáun² tɨ³² liei²¹ quionh³ tsá² fariseos né³, jmɨ́¹ ná¹tan² Jesús, hi³ hnió³ dí² jɨ́e³ nɨ́¹juáh³ hi³ jmah³ tsú² tsáu² jmáɨ¹ nio² tie³, hi³ jáun² la³ jáun² jmɨ́¹ lɨ́¹³ chá³² dí² tsáu¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Tɨ³la³ Jesús jmɨ́¹ má²ñi³² bíh¹ he³ jmɨ́¹ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ tsú² tsá² jmɨ́¹ má²ca³náɨ³ hí³ cuo²: ―Náu², jmu³ zenh² nú² ja¹ lá² quiú¹³ jnoh¹. Jáun² tsá² hí³ né³, ca³jmú³ zenh² chu³jo². ");
INSERT INTO csoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Hi³ jáun² Jesús ca³ngáɨh³ tsá² ná¹ngɨh³² hí³: ―Nga¹ jná¹³ cáun² jáɨ¹³: ¿He³ ca³tɨ²¹ jmu³ tsú² jmáɨ¹ nio² tie³, hí¹ hi³ chu²¹ ho³ hi³ hlah³? ¿Hí¹ lɨ́¹³ lión³² tsú² tsáu² ho³ hi³ tɨ³ hniáuh³² jngɨh³ uá¹ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jmɨ́¹jáun² ca³jɨ́en³² dí² la³jɨ́n³² tsá² tionh² hí³ cu³ jéin³ ñí¹ zenh¹ dí², hi³ jáun² ca³záɨh³ dí² tsá² lɨ́³ hí³ cuo²: ―Ñéih¹ cuonh². Jáun² ca³ñeh³ tsá² hí³ cuo², hi³ jáun² jmɨ́¹jáun² la³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tɨ³la³ tsá² jmɨ́¹ ná¹tan² hí³ Jesús má¹ná¹, ca³míh³ lɨ́n³² bíh¹ tsɨ́³, hi³ jáun² hi³ jan² hi³ jan² tsú² ca³juu³ ca³hlénh³ hi³ ha³ lánh³ lɨ́¹³ jmúh³² dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ Jesús tsɨ³ máh³ hi³ ñí¹lienh¹³ Dió³², jáun² tá¹ cú² nie² bíh¹ la³ ca³liéinh³² tsú² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jmɨ́¹ cá¹jniá²¹ jáun² né³, ca³teh³ dí² tsá² haɨn²¹ hí³ tɨ³ con², hi³ jáun² ja¹ jáun² ca³quianh³ dí² quian³tun³ tsá² ca³teh³ tsú² hí³ *tɨ³² tsá² quian³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tsá² hí³ ná¹jmáɨ² la³ lá²: Sí¹mu²¹ tsá² ca³lɨ³ jmáɨ² siáh³ Pé¹, jɨ³ Tre²¹ dá¹jon²¹ tsú² nɨ́², Jacobo jɨ³ Juan² nɨ́², Pí²liéi¹, Bartolomé, ");
INSERT INTO csoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Má²téh³, Tú¹ma²¹, Jacobo jon² Alfeo, Sí¹mu²¹ tsá² ca³lɨ³ quionh³ tsá² cu³ nió³ *Cananista, ");
INSERT INTO csoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas raɨnh²¹ Jacobo, jɨ³ Judas tsá² zian² juú² Queriot nɨ́² siáh³, tsá² ca³ñí¹jɨenh¹³ hí³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jmɨ́¹ lɨ²¹ jáun² ca³son² Jesús tsɨ³ máh³ jáun² quionh³ tsá² quian³tun³ hí³, hi³ jáun² cua³tanh²¹ tsú² cáun² ñí¹ máɨ². Jáun² ñí¹ jáun² jmɨ́¹ ná¹ngɨh³² juóun³² tsá² haɨn²¹ tɨ³ con² tsú². Ja³bí¹ jmɨ́¹ quionh³ tsú² juóun³² lɨ́n³² tsá² siánh³ siáh³, tsá² hɨ́n¹³ tɨ³ Judea, tsá² juú² Jerusalén, la³ má²quionh³ tsá² hɨ́n¹³ tɨ³ hué³² can³² jmɨ́²miih²¹ có³² juú² Tiro, jɨ³ juú² Sidón nɨ́² siáh³. Tsá² hí³ cua³taunh²¹ hi³ hnió³ ne³ jë¹ Jesús, hi³ má²hnió³ siáh³ hi³ quin³ mɨ́¹uɨ́³ hi³ jmɨ́¹ ná¹jau². ");
INSERT INTO csoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ja³bí¹ jmɨ́¹jáun² lan³ tsá² jmɨ́¹ ná¹má²tso² tsɨ́³ hi³ jmɨ́¹ ná¹jan² jmɨ́²chí³ hláɨnh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jmɨ́¹jáun² ca³lɨ³ hniá¹ la³jɨ́n³² tsá² tsáun¹ hí³ hi³ tin³ cuo² Jesús, quí¹hliá² ñí¹con² Jesús ja³² pí³ hi³ lɨ́¹³ lan¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hi³ jáun² ca³jɨ́e³ Jesús ñí¹ tionh¹ jáun² tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³záɨh³ dí² la³ lá²: ―Hnoh² tsá² tia³mii² náh², jlánh¹ jmɨ́¹ ren² náh² quí¹hliá² má²tionh² náh² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","”Jlánh¹ jmɨ́¹ ren² hnoh², tsá² ñí¹cuon¹³ náh², quí¹ Dió³² bíh¹ jmu³ hi³ conh²¹ hñu³ jmɨ́¹ hñu³ honh² náh². ”Jlánh¹ jmɨ́¹ ren² hnoh² tsá² má²ná¹uoh³² náh², quí¹ hnoh² bíh¹ tsá² ngáɨh¹³ nɨ́¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","”Jlánh¹ jmɨ́¹ ren² hnoh² nɨ́¹juáh³ tsá² ca³lɨ³hau² náh² tsáu², nɨ́¹juáh³ ca³che² tsú² cheih³², nɨ́¹juáh³ ca³quiu³ ca³je³ tsú², ho³ nɨ́¹juáh³ ca³ziu³ ca³hɨe³ náh² tsáu² cun³ñí¹ hi³ ca³tɨn¹ jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tsɨnh¹ náh² jmu³, hi³ ca³la³ hi³ rú² hi³ háɨnh²³ náh² jmu³ hi³ hiún² honh² jmáɨ¹ la³ jáun², quí¹ hñu³mɨ³cuú² hián¹³ náh² cáun² hi³ jlánh¹ bíh¹ quien²; quí¹ la³ nɨ́² bíh¹ ca³jmú³ dí²hioh³ ñú²deh³ hnoh² ñí¹con² la³jɨ́n³² *tɨ³² jë¹ Dió³² jmɨ́¹ zian² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","”Tɨ³la³ jlánh¹ juon²³ hnoh² tsá² ná¹hánh³ náh², quí¹ má²ná¹ma³hiúnh¹³ náh² honh² ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","”Jɨ³ hnoh² tsá² ná¹cónh²¹ henh¹ náh² re² tɨn² ta³né³², juon²³ bíh¹ hnoh², quí¹ né³bí¹ lɨ́¹³ ñí¹cuon¹³ náh². ”Jɨ³ tsá² ná¹ngáɨh²³ náh² siáh³ ta³né³², juon²³ bíh¹ hnoh², quí¹ né³bí¹ uóh¹³ náh², hi³ ha³ hlaɨh³ lɨ́n²¹ honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","”Juon²³ bíh¹ hnoh² nɨ́¹juáh³ la³jɨ́n³² tsáu² hleh³² re² ca³tɨn¹ náh², quí¹ la³ jáun² bíh¹ ca³jmú³ tsá² jmɨ́¹ zian² jmɨ́¹tin² ca³tɨn¹ tɨ³² tɨ́¹jáɨ², tsá² lɨ́¹ ca³juáh³ hí³ hi³ lɨ́n³ tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","”Juanh³² jná¹³ ñí¹con² hnoh² tsá² ná¹naɨh³² náh²: Ma³hno¹ náh² tsá² jmu² hian² tsɨ́³ ñí¹con² náh², jmu³ náh² hi³ chú³² ñí¹con² tsá² hau², ");
INSERT INTO csoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","hi³ chú³² jéinh¹ náh² ñí¹con² tsá² chú² juóu³² náh², lienh¹ náh² Dió³² ca³tɨn¹ tsá² quiú² je²³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nɨ́¹juáh³ zian² tsá² pá²³ cá² jo²¹ máh¹ náh², cuéh³ tsú² siáh³ tɨ³ cá² jo²¹ cáun², cuɨ́¹ pá¹³; hi³ nɨ́¹juáh³ zian² tsá² quin²³ hmɨh³² cháu³ quián¹³ náh², cuéh³ tsú² siáh³ jɨ³ hanh², cuɨ́¹ quián¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Lɨ³ua³ jan² tsá² zia³² hi³ mɨ³² ñí¹con² náh², cuéh³; hi³ nɨ́¹juáh³ tsá² quin²³ cáun² hi³ quián¹³ nú², ha³ lɨ́² máɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jmu³ náh² ñí¹con² tsá² siánh³ la³ cun³ hi³ qui³ hnáuh² náh² jmu³ tsú² ñí¹con² náh² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”Quí¹ nɨ́¹juáh³ hnoh² hno³ náh² jmáh³la³ tsá² hniau³ náh², ¿he³ dá² hi³ chu²¹ ná¹jmuh³² náh²? Quí¹ hí¹ la³ tɨ³ tsá² hian² tsɨ́³ yáh³ ná¹jmu² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ho³ nɨ́¹juáh³ jmuh³² náh² hi³ chu²¹ ñí¹con² jmáh³la³ tsá² jmu² hi³ chu²¹ ñí¹con² náh² hmóu³², ¿he³ dá² hi³ chu²¹ jmuh³² náh² jaun³²? Quí¹ ja³bí¹ tsá² hian² tsɨ́³ yáh³ jmu² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hi³ nɨ́¹juáh³ zia³² hi³ chíh¹ náh² ñí¹con² jmáh³la³ tsá² lɨ́n²³ náh² hi³ lɨ́¹³ jéinh³² siáh³ ñí¹con² náh², ¿he³ dá² hi³ chu²¹ ná¹jmuh³² náh² jaun³²? Quí¹ ja³bí¹ tsá² hian² tsɨ́³ yáh³ chi² hi³ quioh²¹ ñí¹con² tsá² cá²ren² quionh³, quí¹ má²ná¹hëh³ chí¹ tsú² hi³ jɨ́enh³² siáh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tɨ³la³ hniáuh³² má¹hno¹ bí¹ náh² tsá² jmu² hian² tsɨ́³ ñí¹con² náh², hi³ jmúh¹³ náh² hi³ chú³² ñí¹con² tsú², jɨ³ hi³ zia³² hi³ chíh¹ náh² ñí¹con² tsú²; tɨ³la³ jun³juáh¹³ hi³ háɨh¹³ náh² honh² hi³ zia³² cáun² hi³ jɨ́enh³² yáh³ tsú² siáh³. Hi³ jáun² má¹jáun² hián¹³ hnoh² cáun² hi³ jlánh¹ bíh¹ chu²¹, hi³ jáun² hnoh² lɨ́n¹³ jon² Dió³² Tsá² jlánh¹ cuá¹quien²; quí¹ ta³bí¹ hnga² yáh³ Dió³² jmu² hi³ chu²¹ ñí¹con² tsá² tiá² cue³² tiá¹hmah¹ quioh²¹ hi³ hiáuh²³, jɨ³ ñí¹con² tsá² hláɨh¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hniáuh³² ja³² mií³ honh² náh² la³jmɨ́¹ ja³² mií³ tsɨ́³ Dió³² Ñeh² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”Ha³ lɨ́² chú¹ lɨ́² ñih²¹ náh² tsáu², hi³ jáun² tiá² ra³tsa² náh² Dió³² héih³² la³ jáun². Ha³ lɨ́² zinh³ náh² tsáu² ñí¹ hlaɨh³, hi³ jáun² sa³jun³ Dió³² zeh³ náh² siáh³ ñí¹ la³ jáun². Juenh² jmu³ náh² honh², hi³ jáun² Dió³² jmu³ siáh³ juenh² tsɨ́³ ñí¹con² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Cuéh³ náh² tsáu², hi³ jáun² Dió³² chá³² héih³² hi³ cué³² siáh³ ñí¹con² hnoh² ca³la³ hliáun³ cu³tí³, ca³la³ hi³ tioh³ tiá³ tɨ³ ñeh² tuh³² quián¹³ hnoh², ca³la³ ná¹quiúnh¹ tiá³, ca³la³ hi³ ziú² suh³² bíh¹ lɨ́¹³. Quí¹ la³ cun³ lɨ́³ héih³² hi³ cueh³² hnoh² ñí¹con² tsáu², Dió³² chá³² héih³² hi³ cué³² siáh³ ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́², ca³juáh³ siáh³ la³ lá²: ―¿Hí¹ lɨ́¹³ hɨ́e³² tsá² ten³ juɨ³² ñí¹con² tsá² ten³ raɨnh²¹? ¿Haun¹³ juáh¹³ tá¹ gon³ bíh¹ tsú² sunh³ cu³tsa³² nɨ́¹juáh³ ñí¹ hó²¹ táu²? ");
INSERT INTO csoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hí¹ jan² yáh³ tsá² má²tɨn³², tiá² lɨ́¹³ lɨ³tɨn² tɨ³ hliáun³ la³ cónh³ bíh¹ tɨ³² joh¹; tɨ³la³ nɨ́¹ má¹ca³lɨ³tɨn² tsú² la³jɨ́³², ñí¹jɨ́²¹ la³ cun³ hi³ tɨn² tɨ³² hí³ bíh¹ lɨ́¹³ tɨn² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”¿Ha³ bí¹ lánh³ rón³² lɨ́¹³ jɨeh²¹ hnú² má¹quɨ³² pih²¹ hi³ hu²¹ mɨ́¹ñí¹ renh² nɨ́¹juáh³ tiá² lɨ́²tsɨn² yáh³ hnú² hi³ hu²¹ cáun² pa²¹ hná¹ hmá² mɨ́¹máh¹ huen²? ");
INSERT INTO csoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Ha³ lánh³ rón³² hó³² honh¹ hnú² hi³ juoh¹ nú² renh²: “Hnú² reh², cué¹ jáɨ¹³ hi³ chí¹³ jná¹³ má¹quɨ³² pih²¹ hi³ hu²¹ nɨ́² mɨ́¹máh¹ nú²”, tɨ³la³ tiá² ñíh¹ yáh³ hnú² hi³ hu²¹ cáun² pa²¹ hná¹ hmá² mɨ́¹máh¹ huen²? ¡Hnú² tsá² lɨ́n³ nú² la³ cá¹ la³ jéinh¹! La³ñí¹ tín² chí³ hná¹ hmá² pa²¹ hu²¹ mɨ́¹máh¹ huen², má¹jáun² lɨ́¹³ jɨeh²¹ hnú² re² hi³ chíh¹ nú² má¹quɨ³² pih²¹ hi³ hu²¹ mɨ́¹ñí¹ renh². ");
INSERT INTO csoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","”Tiá² lin¹ zia³² yáh³ hmá² chu²¹ hi³ háɨ³² máɨ³ hlah³; sa³jun³ zia³² siáh³ hmá² hlah³ hi³ lɨ́¹³ ha³ máɨ³ chu²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Quí¹ cun³quionh³ máɨ³ hi³ háɨ³² bíh¹ hmá² lɨ́¹³ lɨ³cuoh² tsú². Uá¹la³ mɨ³ hmá² sí² co², tiá² cun³² yáh³ tsú² tsɨ³ hmá² ton², sa³jun³ mɨ³ uóun²jɨeh¹³ yáh³ cun³² tsú² siáh³ cuú²ñeh¹ tan³ mɨ³ juɨ́h². ");
INSERT INTO csoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tsá² chun¹ jmu² hi³ chu²¹ quí¹hliá² hi³ chu²¹ zia³² hñu³ tsɨ́³; tɨ³la³ tsá² hláɨh¹ tsá² hon² má¹ná¹, jmu² jmáh³la³ hi³ hlah³ bíh¹, quí¹hliá² hi³ hlah³ bíh¹ zia³² hñu³ tsɨ́³ tsú². Quí¹ lɨ³ua³ cáun² hi³ ná¹canh² hñu³ jmɨ́¹ hñu³ tsɨ́³ tsú², hi³ jáun² bíh¹ hué³² ho³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","”¿He³ láɨh³² sa³ juáh³ hnoh² hi³ Juóuh³² náh² jná¹³, já² tiá² jmuh³² yáh³ hnoh² la³ cun³ hi³ juanh³² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Juanh²¹ jná¹³ ha³ lánh³ lɨ́n³ jan² tsá² ja³² ñí¹con² jná¹³, tsá² ñi³nie¹³ jáɨ¹³ quion²¹ jná¹³ hi³ má²tí³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Tsá² la³ hí³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá² quiáh² ñe¹ ñí¹ ma³liáu³² jmɨ́h¹ hiah³² hñú¹³. Má¹tɨ́³ jáun² quɨ́n¹ né³, ñí¹ quɨ́n¹ jáun² bíh¹ dí²chin³ tsú² jmɨ́h¹ hiah³² hñú³ quioh²¹. Hi³ jáun² nɨ́¹ má¹cá²chó³² jáun² jmáɨ¹ hi³ lɨ³ hliáun³ jmɨ́² cua³, hi³ já³² jmáɨ² tiá³ lɨ́n³² ñí¹ zeh¹ jáun² hñú³, tiá² tioh²¹ yáh³ jmáɨ² hi³ tsunh³ quí¹hliá² jmɨ́h¹ hiah³² hñú³ jáun² dí¹chin¹ ñí¹ quɨ́n¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tɨ³la³ tsá² náɨ³² jáɨ¹³ quion²¹ jná¹³, tsá² tiá² má²tí³² la³ cun³ hi³ juanh³² jná¹³, tsá² la³ hí³ né³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá² jmu² hñú¹³ jmáh³la³ ñí¹ hué²¹, hi³ tiá² jmɨ́h¹ hiah³² quiú²; jáun² nɨ́¹ má¹cá²chó³² jáun² jmáɨ¹ hi³ lɨ³ hliáun³ jmɨ́² cua³, hi³ já³² jmáɨ² tiá³ lɨ́n³² ñí¹ zeh¹ jáun² hñú¹³ tsú², jáun² má¹jáun² quɨ́h³² bíh¹, hi³ má²juú¹ má²tsúnh¹³ cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jmɨ́¹ cá¹tsan³ jáun² jáɨ¹³ hi³ ca³hléh³ Jesús ñí¹con² tsá² hí³ né³, ngau³ tɨ³ juú² Capernaum. ");
INSERT INTO csoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ñí¹ jáun² jmɨ́¹ zian² jan² hliáu³ tsá² chín¹ tsá² *romano, hi³ jáun² tsá² hí³ jmɨ́¹ zian² jan² *tsá² má²dí¹hlánh¹ joh¹, tsá² jmɨ́¹ hnio³ tsú² lɨ́n³². Tsá² hí³ joh¹ tsú² jmɨ́¹ rá²tsáun¹ lɨ́n²¹ hi³ jmɨ́¹ má²ñí¹jún³ cu³tí¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jmɨ́¹ ca³náɨ³² hliáu³ tsá² chín¹ hí³ hi³ zian² jan² tsá² jmah²³ tsáu², tsá² jmáɨ² Jesús, jáun² ca³zen³ dí² tsá² *judíos tsá²daun³² tsá² ná¹ñí¹ juú², hi³ tsa³zeh¹ tsú² Jesús tiá¹ jmu³ tiá³ hi³ chú³² hi³ já³² hi³ ja³jmah¹ tsá² má²dí¹hlánh¹ hí³ joh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jáun² tsá² má²lieih²¹ hí³ né³, ja³taunh²¹ bíh¹ ñí¹con² Jesús, hi³ ca³ñí¹hiú² ñí¹mɨ², hi³ ñí¹juah²¹ la³ lá²: ―Cu³tí³ ca³tɨn¹ hliáu³ tsá² chín¹ tsá² hɨen²³ jnoh¹ lá² hi³ hiáuh³ cáun² hi³ chú³² quián¹³ hnú²; ");
INSERT INTO csoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","quí¹ jlánh¹ hniau³ tsú² jnoh¹ tsá² ziáun² dí² hué³² *Israel lá². Hnga² bíh¹ tsú² ca³ma³hmah¹ hi³ lɨ³ cáun² cuáh³² quiú¹³ jnoh¹ já¹ juú² lá². ");
INSERT INTO csoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hi³ jáun² ngau³ Jesús quionh³ tsá² hí³, tɨ³la³ jmɨ́¹ má²ñí¹chau²¹ tsú² hñú¹³ hliáu³, jáun² hliáu³ tsá² chín¹ hí³ ca³zen³ ma³ jan² há²mei²¹ hi³ ja³zeh¹ Jesús la³ lá²: ―Hnú² Tɨ³², lɨ́²juáh³ hliáu³: “Ha³ lɨ́² ma³tsan¹³ hnú² honh² hi³ ñeih²¹ hnú² la³ tɨ³ hñu³² jná¹³, quí¹ jun³ lin¹ tsáu² yáh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cun³ñí¹ hi³ jáun² yáh³ tiá² lɨ́²chá³ jná¹³ tsɨn³² hi³ ñe¹ huen², hi³ ñí¹jɨe¹ jná¹³ hnú². Jɨ́³²la³ ti³ jmúh¹³ hnú² héih³² bíh¹, hi³ jáun² lan¹³ tsá² joh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quí¹ ja³bí¹ jná¹³ siáh³ zian² juóu³², hi³ ja³bí¹ lɨ́n³ jná¹³ siáh³ hi³ chín¹ ñí¹con² hliáu³. Jáun² nɨ́¹ má¹cá²jmú³² jná¹³ héih³² ñí¹con² lɨ³ua³ jan² tsá² hí³ hi³ tsó³², jáun² tsau³² bíh¹; hi³ nɨ́¹juáh³ juo¹³ jná¹³ jan²: Ña³², jáun² ja³²; hi³ nɨ́¹juáh³ juo¹³ jná¹³ tsá² lɨ́n³ quian²¹ ná¹: Jmu³ hi³ lá², jáun² jmu² bíh¹ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jmɨ́¹ má²lɨ́²niéi³² jáun² Jesús jáɨ¹³ hi³ lɨ́²zen³ jáun² hliáu³ tsá² chín¹ hí³ né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³. Jmɨ́¹jáun² ca³jɨ́en³² tsú² tsá² hí¹já²táunh¹ hí³ tɨ³ cu³hna²¹, hi³ ca³záɨh³ dí² la³ lá²: ―Jná¹³ juanh³² ñí¹con² hnoh², hi³ hí¹ jan² tsá² zian² hué³² *Israel lá² tiá² má²ca³chanh²¹ jná¹³, tsá² nio² cáun² tsɨ́³ la³jmɨ́¹ nio² cáun² tsɨ́³ *tsá² cá²jo²¹ lɨ́²zen³ jáɨ¹³ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hi³ jáun² jmɨ́¹ ca³cha³tánh¹ tsá² ca³ñí¹can³² hí³ jáɨ¹³ ñí¹con² Jesús hñú¹³ hliáu³, jáun² ca³jɨ́e³ tsú² hi³ má²laɨn³² bíh¹ tsá² jmɨ́¹ tsáun¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jmɨ́¹ lɨ²¹ jáun², ngau³ Jesús cáun² juú² jmáɨ² Naín, la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con². Hi³ jmɨ́¹ hí¹já²táunh¹ siáh³ juóun³² lɨ́n³² tsáu² cu³hna²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jmɨ́¹ cá¹chó²¹ tsú² jáun² can³² juú², ca³jɨ́e³ tsú² hi³ ná¹jan² tsáu² jan² hla¹ hi³ má²já²hón³², tsá² jmɨ́¹ jan² tán¹ jon² jan² tsá²mɨ³ hnáɨ³; hi³ jmɨ́¹ hí¹já²táunh¹ siáh³ juóun³² tsá² juú² quionh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jmɨ́¹ ca³jɨ́en³² jáun² Tɨ³² Juo¹³ dí² tsá²mɨ³ hí³, ca³ja³ mií³ tsɨ́³, hi³ ca³záɨh³ dí²: ―Ha³ lɨ́² uó². ");
INSERT INTO csoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jáun² ca³ja³janh³² Jesús hi³ ca³tí³ cuo² ñí¹ cuó² hún¹ hla¹, jáun² ca³tiánh³ tsá² jmɨ́¹ ná¹quian³² hí³ cuó². Jáun² Jesús ca³záɨh³ hla¹ la³ lá²: ―Hnú², tsá¹ñú¹, jná¹³ juanh³² náu². ");
INSERT INTO csoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jáun² né³, hla¹ hí³ la³juɨ³² ca³jenh¹³ hi³ ca³náu², hi³ ca³ma³liáu³² hleh³². Jáun² Jesús ca³jɨenh³ tsá¹ñú¹ hí³ ñí¹con² mí¹ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jáun² la³jɨ́n³² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³juénh² hi³ ca³ja³cáun² lɨ́n³² tsɨ́³. Jmɨ́¹jáun² ca³ma³quien² tsú² Dió³², hi³ ca³juáh³: ―¡Jan² *tɨ³² jë¹ Dió³² pin³ má²cá²jnia³ ja¹ ñí¹ tiauh¹ jnoh¹ lá²! Ja³bí¹ ca³juáh³ tsú² siáh³: ―¡Dió³² má²cua³ma³hon³ tsá² joh¹! ");
INSERT INTO csoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hi³ jáun² la³jɨ́n³² tsá² hɨ́n¹³ tɨ³ Judea, jɨ³ tsá² tiáunh¹ la³ cu³ la³ jéin³ jáun², ca³lɨ³ ñi³² hi³ ca³jmú³ Jesús la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² Juan² né³, ca³chá³ siáh³ la³jɨ́³² jáɨ¹³ hi³ ca³tɨn¹ Jesús. Jmɨ́¹ lɨ²¹ jáun² ca³teh³ dí² gon³ tsá² haɨn²¹ hí³ tɨ³ con², ");
INSERT INTO csoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","hi³ ca³zen³ dí² ñí¹con² Jesús hi³ tsa³ngáɨ³ la³ lá²: “¿Hí¹ hnú² uá¹ Tsá² ca³tɨn¹ já³², ho³ hniáuh³² uá¹ jan¹³ jnoh¹ jan² tsá² siánh³?” ");
INSERT INTO csoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jmɨ́¹ ca³cha³táunh¹ jáun² tsá² hí³ ta³ ñí¹ Jesús né³, ca³juáh³ la³ lá²: ―Juan² tsá² zion² hí³ jmáɨ² tsáu² lɨ́²ze³ jnoh¹ hi³ ja³ngáɨ¹³ jnoh¹ ñí¹con² hnú² nɨ́¹juáh³ hnú² bíh¹ Tsá² lɨ́n³ Cristo, ho³ nɨ́¹juáh³ hniáuh³² uá¹ jan¹³ jnoh¹ tsá² siánh³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jáun² la³ cun³ jmɨ́¹jáun² ca³jmah³ Jesús juóun³² lɨ́n³² tsá² tsáun¹ jɨ³ tsá² ná¹cán²³ uu³mí²tsɨ³², jɨ³ tsá² tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ nɨ́² siáh³; hi³ ca³nia³ tsú² siáh³ mɨ́¹ñí¹ tsá² ten³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jmɨ́¹ lɨ²¹ jáun² ca³záɨh³ tsú² tsá² cuá²taunh²¹ hí³ la³ lá²: ―Cuá²tánh¹ náh², cuá²zéih³ náh² Juan² la³ cun³ hi³ má²lɨ́²jɨeh³ náh² jɨ³ hi³ má²lɨ́²niéih² náh² nɨ́² siáh³; cuá²zéih³ náh² tsú² hi³ tsá² ten³ má²jniá³ ñí¹, tsá² hma² má²ñi³táunh¹, hi³ má²laɨn³² siáh³ tsá² jmɨ́¹ ná¹lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³, hi³ tsá² jmɨ́¹ te³ cua¹ né³, má²náɨ³² bíh¹, hi³ má²ca³jenh¹³ bíh¹ siáh³ tsá² jmɨ́¹ má²ná¹jún¹, hi³ tsá² tia³mii² né³, má²ná¹náɨ³² bíh¹ jú¹ chú³² hi³ ha³ lánh³ rón³² lɨ́¹³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jlánh¹ jmɨ́¹ ren² tsá² tiá² lɨ́¹ cha³² hliáun³ ñéih³ tsɨ́³ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jmɨ́¹ já¹tanh²¹ jáun² tsá² ca³zen³ hí³ Juan² né³, ca³ma³liáu³² Jesús hi³ ca³chá³ jáɨ¹³ hi³ ca³tɨn¹ Juan² hí³ ñí¹con² tsá² tionh² hí³ la³ cu³ la³ jéin³ ñí¹ zenh¹, hi³ ca³juáh³ la³ lá²: ―¿He³ dá² jaun³² ca³ñí¹jɨeh¹³ hnoh² ñí¹ lɨ́³ hué³² quiéin²? ¿Hí¹ ca³ñí¹jɨeh¹³ hnoh² cáun² hmá² tá² náɨ² hi³ lɨ́¹ quí² lɨ́¹ jɨ́eh²³ cun³quionh³ chí³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Hi³ nɨ́¹juáh³ tiá² la³ jáun² né³, ¿he³ bíh¹ ca³ñí¹jɨeh¹³ náh²? ¿Hí¹ ca³ñí¹jɨen¹ náh² jan² tsá²ñuh² quih³² hmɨh³² hi³ jlánh¹ bí¹ huá¹? Sá¹nɨ́² dú¹ jɨe³ náh², tsá² ná¹quih³² hmɨh³² chú³² jniá³ tionh² re² tɨn² ñéih³ hñú¹³ tsá² ná¹lɨ́n³ re²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Hi³ jáun² né³, ¿he³ bíh¹ ca³ñí¹jɨeh¹³ náh²? ¿Hí¹ ca³ñí¹jɨen¹ náh² jan² tɨ³² jë¹ Dió³²? Quí¹ tson² bíh¹ cu³tí³, tɨ³la³ tsá² hí³ má¹ná¹, tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ lɨ³ua³ jan² tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Quí¹ ñí¹ Sí² quioh²¹ Dió³² rá¹ja³² jáɨ¹³ hi³ ca³tɨn¹ Juan² tsá² ziau² hí³ jmáɨ², hi³ juáh³ la³ lá²: Sá¹nɨ́² jɨe³, jná¹³ zein²¹ jan² tsá² tsa³can³² jáɨ¹³ ta³ tin² la³ cun³ bí¹ hnú², tsá² hí³ bíh¹ jmu³ hua³jan²¹ juɨ³² ñí¹ cuóh¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jmɨ́¹ má²lɨ́²chá³² Jesús jáɨ¹³ nɨ́² né³, ca³záɨh³ siáh³ tsá² hí³ la³ lá²: ―Jná¹³ juanh³² ñí¹con² hnoh², hi³ tiá² hin² zian² hí¹ jan² yáh³ tsá² jlánh¹ bíh¹ quien² la³ cónh³ bí¹ Juan² ja¹ la³jɨ́n³² tsá² ca³lɨ³zian² ñí¹ hué²¹ lá²; tɨ³la³ cun³ jáun² tsá² tiá² lin¹ ñí¹ quien² ja¹ quioh²¹ tsá² má²tionh² jo³cuo² Dió³², tsá² la³ hí³ bíh¹ tɨ³ quien² la³ cónh³ bíh¹ Juan². ");
INSERT INTO csoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hi³ jáun² la³jɨ́n³² tsáu², la³ má²quionh³ *tsá² chi² hmah²¹, tsá² ca³náɨ³² hí³ jáɨ¹³ hi³ ca³hléh³ jáun² Juan², ca³ma³tson² bíh¹ tsú² hi³ Dió³² tɨn² ra³tsɨ³² re² héih³², la³ cun³ la³jɨ́n³² tsá² ca³ziau³ hí³ Juan² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Tɨ³la³ tsá² *fariseos má¹ná¹, la³ má²quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, tsá² tiá² ca³he³ hí³ hi³ ziau³ Juan² jmáɨ², tiá² ca³tɨ́³ yáh³ tsɨ́³ tsá² hí³ la³ cun³ hi³ jmɨ́¹ hnió³ Dió³² jmu³ ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Hi³ jáun² né³, ¿hin² dá² tsánh² lɨ́¹³ cunh²¹ jná¹³ quionh³ tsá² zian² jmáɨ¹ hi³ ziáun² dí² lá²? Quí¹ ¿hin² yáh³ tsánh² lɨ́¹³ cunh³ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lɨ́¹³ juáh¹³ la³ lá²: Jmu² tsú² la³jmɨ́¹ jmu² tsá¹míh¹ ñi³co¹ já¹ hmah²¹. Ná¹hóh³² tsú² ca³la³ hi³ jéinh³² hlah³, hi³ zaɨh³² raɨnh²¹ la³ lá²: “Sa³ tiá² ca³lɨ³hnáuh² náh² tsan¹³ jmɨ́¹ lɨ́²jiéi¹³ jnoh¹ jáun² hmá² tá² le², hi³ sa³jun³ lɨ́²uoh³ yáh³ hnoh² jmɨ́¹ lɨ́¹jmú¹³ jnoh¹ siáh³ sun¹ ca³tɨ²¹ jmáɨ¹ hi³ nio² hlah³ tsɨ́³ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juanh³² jná¹³ la³ nɨ́², quí¹ cuan³ Juan² tsá² zion² hí³ tsáu² jmáɨ², tsá² tiá² cúh² hí¹miih²¹, sa³jun³ hɨ́nh²³ mu² ráu³ mɨ³ uóun²jɨeh¹³; hi³ jáun² hnoh² né³ juáh³: “Tsá² hún¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ bíh¹ hí³”. ");
INSERT INTO csoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jáun² né³, cuan³ siáh³ jná¹³ Jon² tsá²mɨ³cuóun², tsá² cú² tsá² aɨh³² ná¹, tɨ³la³ hnoh² né³, juáh³ siáh³: “¡Tsá² jlién³ bíh¹ nɨ³², hi³ hɨ́nh²³ siáh³ jmáɨ², tsá² juónh²³ re² quionh³ tsá² ren² tso³ jɨ³ tsá² chi² hmah²¹ nɨ́² siáh³!” ");
INSERT INTO csoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tɨ³la³ la³jɨ́n³² tsá² cháunh²³ re² chí¹ má²jnia³² hi³ chu²¹ bíh¹ la³jɨ́³² hi³ cháunh²³ tsɨ́³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jmɨ́¹ lɨ²¹ jáun² né³, jan² tsá² fariseo ca³teh³ Jesús hi³ tsa³jmú³ má³² hñú¹³ dí². Jáun² né³, ñéi¹ bíh¹ Jesús hñú¹³ tsá² hí³, jáun² ca³cuá³ ñí¹ mesa. ");
INSERT INTO csoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jáun² né³, jan² tsá²mɨ³ tsá² juón¹, tsá² zian² juú² jáun², ca³lɨ³ ñi³² hi³ Jesús cuá¹jmu² má³² hñú¹³ tsá² fariseo hí³, jáun² ñéi¹ hi³ ñí¹can³² cáun² tse³ pih²¹ hi³ lɨ́³ cún¹ tiáu² alabastro; hi³ jmɨ́¹ ha²¹ no¹ má²ró³². ");
INSERT INTO csoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hi³ jáun² tsá²mɨ³ hí³ ca³ta³zanh¹ cu³hna²¹ Jesús, hi³ má²ho²; hi³ jáun² ca³ma³jlɨh²¹ tsú² ta³ Jesús cun³quionh³ jmɨ́²zɨ́h¹ taɨn³² ñí¹, hi³ jáun² ca³ma³quiéin² siáh³ cun³quionh³ jñú²chí¹ hnga². Jmɨ́¹jáun² ca³hen³ tsú² ta³ Jesús, hi³ ca³jñéi³ tsú² siáh³ no¹ má²ró³². ");
INSERT INTO csoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jmɨ́¹ ca³jɨ́e³ jáun² tsá² fariseo tsá² hñú¹³ ñí¹ cuá³ tsú² jáun², hi³ jmu² tsá²mɨ³ hí³ la³ jáun², jáun² ca³lɨ́n¹³ tsú²: “Sá¹jmɨ́¹ hi³ tson² jan² tɨ³² jë¹ Dió³² tsá²ñuh² nɨ́², jmɨ́¹ lɨ³tsɨn² bíh¹ tsú² he³ ñí¹ tsá²mɨ³ dí¹tie²³ nɨ́² cuo², quí¹ tsá²mɨ³ juón¹ bíh¹ tsá²mɨ³ nɨ́²”. ");
INSERT INTO csoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² fariseo hí³ la³ lá²: ―Hnú² Sí¹mu²¹, zia³² cáun² jáɨ¹³ hi³ juanh²¹ jná¹³ ñí¹con² hnú². Jáun² tsá² hí³ ca³ngáɨ³: ―¿He³ bíh¹ jmɨ́¹ juáh¹³ hnú² Tɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Hi³ jáun² Jesús ca³juáh³: ―Jmɨ́¹ zian² jan² tsá² ca³chí² quɨe³ ñí¹con² gon³ tsáu². Jáun² né³, jan² tsá² hí³ jmɨ́¹ ren² hñá³ nio² hña³láu³ héih³² *cú¹tiáu², hi³ tsá² jan² hí³ né³, jmɨ́¹ ren² tu³la³quia³ héih³² cú¹tiáu². ");
INSERT INTO csoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Tɨ³la³ jmɨ́¹ ca³lɨ³ ñi³² tsá² hí³ hi³ tá¹ gon³ tsá² ren² hí³ quɨe³ tiú²uú² lɨ́¹³ yáh³ ma³hmah¹, jáun² cáun² lɨ́¹ ca³hin³ bíh¹ tsú² cú²jueh³² hi³ jmɨ́¹ ren² tsú². Jáun² né³, juáh¹³ hnú² neh²¹ ¿hin² tsánh² tsá² gon³ hí³ lɨ́n²³ hnú² hi³ tɨ³ jlánh¹ má²hnio³ lɨ́n³² tsá² ca³chí² hí³ quɨe³? ");
INSERT INTO csoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hi³ jáun² Sí¹mu²¹ ca³ngáɨ³: ―Len³ jná¹³ tsá² ca³hin³ hliáun³ hi³ jmɨ́¹ ren² bíh¹. ―Tson² bíh¹ cu³tí³ la³ nɨ́² ―ca³juáh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tá¹la³ cuá¹jɨ́en³² tsú² jáun² tsá²mɨ³ hí³ né³, ca³záɨh³ dí² Sí¹mu²¹ la³ lá²: ―Sá¹nɨ́² jɨen¹ dúh¹ tsá²mɨ³ lá². La³ cun³ jmɨ́¹ lɨ́¹hú²¹ jná¹³ hñuh³² hnú², tiá² jmáɨ² lɨ́²cuéh¹ yáh³ hnú² hi³ ren¹ jná¹³ tán², tɨ³la³ tsá²mɨ³ lá² má²lɨ́²ma³jlɨh²¹ tán² jná¹³ cun³quionh³ jmɨ́²zɨ́h¹ taɨn³² ñí¹, hi³ má²lɨ́²ma³quiéin² tsú² siáh³ cun³quionh³ jñú²chí¹ hnga². ");
INSERT INTO csoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Hi³ sa³jun³ lɨ́²hen³ bíh¹ hnú² siáh³ ñi³² jná¹³ la³ cun³ hi³ jmɨ́¹ ca³tɨ²¹ hen³ tsú² jan² tsá² cuá¹tén¹; tɨ³la³ tsá²mɨ³ lá², cun³ tiá² má²lɨ́²tunh³ bíh¹ hi³ hen² tán² jná¹³ la³ cun³ jmɨ́¹ cuan¹ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ja³bí¹ la³ jáun² tiá² lɨ́²táh¹ yáh³ hnú² no¹ tsáɨh³ chin³² jná¹³ jmɨ́¹ cuan¹ ná¹, tɨ³la³ tsá² lá² né³, má²lɨ́²jñéi³ no¹ má²ró³² tán² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jáun² juanh³² jná¹³, uá¹jinh¹ hliáun³ tso³ jmɨ́¹ ren² tsá² lá², tɨ³la³ má²cá²hin³ bíh¹, quí¹hliá² jlánh¹ hniau³ tsú² jná¹³; tɨ³la³ nɨ́¹juáh³ tsá² jmɨ́¹ la³ ren² cú¹pih²¹ tso³, jáun² cú¹pih²¹ bíh¹ hniau³ tsú² jná¹³ nɨ́¹ má¹cá²hin³ tso³ quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jáun² Jesús ca³záɨh³ tsá²mɨ³ hí³ la³ lá²: ―Má²cá²hin³ bíh¹ tso³ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hi³ jáun² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ mesa quionh³ tsú² ca³juu³ ca³hlénh³, hi³ ca³juáh³: ―¿Hin² dá² tsánh² tsá² lá², hi³ jáun² sa³ tsáu¹³ tsáu² máh³ hin²³ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tɨ³la³ Jesús cáun² ca³záɨh³ tsá²mɨ³ hí³ la³ lá²: ―Má²ca³liáun³ nú² quí¹hi³hliá² má²nio² cáun² honh² nú². Cuánh² cáun² hi³ re² hi³ tɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ca³ñí¹tɨ́² ñí¹ngɨ́² Jesús juú² ñí¹ hliáun³, jɨ³ juú² míh¹ juú² siún¹, la³ má²quionh³ tsú² jáun² tsá² quian³tun³ hí³ hi³ ñí¹can³² jú¹ chú³², hi³ ca³ñí¹hléh² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ja³bí¹ jmɨ́¹ quionh³ tsú² ma³ jan² tsá²mɨ³ tsá² má²ca³jmah³ tsú² hí³ jmɨ́¹tin², jɨ³ tsá² má²ca³huen³ tsú² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ nɨ́² siáh³. Ja¹ tsá²mɨ³ hí³ jmɨ́¹ hí¹tsau³² Má²réi³, tsá² ja³ juú² Magdalá, tsá² ca³huen³ hí³ Jesús quiaun³ jmɨ́²chí³ hláɨnh¹ hi³ jmɨ́¹ tiáunh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ja³bí¹ jmɨ́¹ hí¹tsau³² siáh³ mɨ́¹ Juánh³ ñí²cuo² tsá² jmáɨ² Chuza tsá² jmɨ́¹ chín¹ hñú¹³ re²¹ Herodes; jɨ³ tsá²mɨ³ jmáɨ² Susana nɨ́², quionh³ siáh³ juóun³² tsá²mɨ³ ñí¹ hná¹ jáun², tsá² jmɨ́¹ má²hon³ Jesús cun³quionh³ hi³ zia³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hi³ jáun² jmɨ́¹jáun² ca³cua³taunh²¹ tsá² zian² juú² ñí¹ hliáun³ hi³ ca³cuú² ca³ngɨh³² ñí¹ cuá³ Jesús. Jmɨ́¹jáun² ca³jmú³ tsú² cáun² jáɨ¹³ ñí¹con² tsá² hí³, hi³ lɨ́³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jmɨ́¹ zian² jan² tsá² ca³ñí¹suh³² jún² ñí¹náɨ² quioh²¹. Tá¹la³ jmɨ́¹ hí¹súh²³ tsú² jáun² jún² né³, la³ ca³súh³² ca³lá² hú¹ juɨ³², hi³ jáun² ca³ha³ ca³zauh³ tsáu², hi³ ca³cúh² siáh³ tan³². ");
INSERT INTO csoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ lɨ́³ já¹ quɨ́n¹; jáun² jmɨ́¹ ca³hiá², la³juɨ³² ca³lɨ³ quiéin² bíh¹, quí¹hliá² tiá² cuóuh³ yáh³ ñí¹ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ja³bí¹ ca³súh³² siáh³ ca³lá² ñí¹ la³ hiau² ton², hi³ jáun² la³ má²quionh³ ton² bíh¹ ca³hiá². Jáun² ton² bíh¹ jlánh¹ tia³juɨ³² ca³quí² cá²cuon³, hi³ jáun² tiú²uú² cá²cuon³ yáh³ jún² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tɨ³la³ la³jɨ́³² jún² ñí¹ hná¹ jáun² né³ ca³súh³² ñí¹ chu²¹ hué³², hi³ jáun² ca³háɨ³² ca³la³ tɨ³ hña³láu³ máɨ³ la³ cun³ cá² máɨ³ jún² hi³ ca³súh³ tsú² jáun². Jmɨ́¹ má²lɨ́²juáh³ Jesús la³ nɨ́², jáun² ca³hléh³ tiá³ hi³ ca³juáh³: ―¡Nɨ́¹juáh³ tson² tsɨ²¹ cuáh³ náh², jáun² niéi² náh²! ");
INSERT INTO csoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jmɨ́¹ lɨ²¹ jáun² né³, ca³mɨ́³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ jmu³ tsú² na²¹ jáɨ¹³ hi³ má²lɨ́²juáh³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Hnoh² bíh¹ tsá² ca³tɨn¹ náh² hi³ lɨ³ ñíh¹³ jáɨ¹³ hi³ jmɨ́¹ ná¹hmá¹ ná¹jnɨ́¹ ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³²; tɨ³la³ tsá² ñí¹ hná¹ nɨ́² né³, jɨ́³²la³ ti³ náɨ³² tsú² cun³quionh³ jáɨ¹³ hi³ jmu² bíh¹ jná¹³. Hi³ jáun² uá¹jinh¹ jɨ́e²³ tsú², tɨ³la³ cun³ jáun² tá²tonh¹ tsú² la³jmɨ́¹ lɨ́³ tiá² hi³ lɨ́²jɨ́e³ bíh¹, hi³ uá¹jinh¹ náɨ³² tsú², tɨ³la³ cun³ jáun² tiá² ngɨ²³ yáh³ tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”Jáɨ¹³ hi³ má²lɨ́²juánh³² jná¹³ nɨ́² niéih³ la³ lá²: Jáɨ¹³ quioh²¹ Dió³² lɨ́³ la³jmɨ́¹ lɨ́³ jún²; ");
INSERT INTO csoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","hi³ jáun² tsá² náɨ³² jáɨ¹³ quioh²¹ Dió³² né³, lɨ́n³ la³jmɨ́¹ lɨ́³ hú¹ juɨ³², tɨ³la³ tsá² hláɨnh¹ né³ ja³² hi³ quin²³ jáɨ¹³ jáun² hñu³ tsɨ́³ tsá² hí³; quí¹ nɨ́¹ ca³taunh³ tsú² ta²¹, hi³ jáun² lɨ́¹³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jáun² tsá² he² jáɨ¹³ tia³ juɨ³² lɨ́n³² né³, hi³ ca³la³ hi³ hiún² lɨ́n³² tsɨ́³ jmu², tsá² la³ hí³ dá² lɨ́n³ la³jmɨ́¹ lɨ́³ ja¹ quɨ́n¹ ñí¹ cá¹súh²¹ jáun² jún²; tia³ juɨ³² lɨ́n³² bíh¹ ca³hiá² jmɨ́¹ ca³hiá², tɨ³la³ cun³ñí¹ hi³ tiá² hliáun³ chí² jmu² chá²³ yáh³, hi³ jáun² tiá² lɨ³uén²³. Jáun² uá¹jinh¹ ca³taunh³ tsú² ta²¹ cu³tiá³, tɨ³la³ jmɨ́¹ ca³lɨ³ zia³² uu³mí²tsɨ³² ñí¹con² tsú², tɨ³ có³² bíh¹ ca³náu². ");
INSERT INTO csoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ja³bí¹ zian² tsá² náɨ³² jáɨ¹³ quioh²¹ Dió³² lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² ñí¹ ca³hiau² ton² ñí¹ cá¹súh²¹ jáun² jún². Tɨ³la³ tá¹la³ chí¹cuóun² tsú² jáun² cun³quionh³ jáɨ¹³ quioh²¹ Dió³², ja³² hñu³ tsɨ́³ tsú² hi³ zaɨn³² hi³ zia³² ñí¹ hué²¹ lá², hi³ má²hiún² tsú² tsɨ́³ quionh³ hi³ jáun², hi³ jlánh¹ lɨ́¹ quí² lɨ́¹ cha³² tsú² hliáun³ ñéih³ tsɨ́³ ca³tɨ²¹ hi³ zia³² ñí¹ hué²¹ lá², hi³ jáun² tiá² hi³ lau³² yáh³ ñí¹con² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tɨ³la³ tsá² he² re² jáɨ¹³ quioh²¹ Dió³² nɨ́¹ má¹ca³náɨ³² né³, lɨ́n³ la³jmɨ́¹ lɨ́³ hué³² chu²¹ ñí¹ cá¹súh²¹ jáun² jún². Tsá² la³ hí³ bíh¹ tsá² zánh²³ tiá³ jáɨ¹³ jáun², tsá² cueh³² tsɨ́³, hi³ jáun² loh¹³ hliáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","”Nɨ́¹juáh³ tsá² héinh²³ sɨ́² hñú¹³, hí¹ jan² yáh³ tsá² la³ hí³ tiá² hi³ jláɨ²³ sɨ́² jáun² quioh²¹, sa³jun³ zih³² tsú² ñeh² jen³; tɨ³la³ dí²chí³ tsú² chi³cuú² bíh¹ ñí¹ lɨ́¹³ taɨ²¹ joh¹ tá¹ cáun² ñéih³, hi³ jáun² jniá³ lɨ́¹³ jeinh²¹ lɨ³ua³ jan² tsá² hí³ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quí¹ hí¹ cáun² yáh³ hi³ ná¹hmá¹ tiá² zia³² hi³ juáh¹³ hi³ tiá² lɨ́¹³ jniá³, hi³ hí¹ cáun² yáh³ siáh³ hi³ ná¹hmá¹ ná¹jnɨ́¹ tiá² zia³² hi³ juáh¹³ hi³ tiá² lɨ́¹³ jñéih³, chau³² bíh¹ jmáɨ¹ hi³ lɨ́²ñi³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","”Jáun² né³, quian² náh² hua³hí¹³ hi³ niéi² náh² re²; quí¹ nɨ́¹juáh³ tsá² má²ca³ngɨ¹³ re², tsá² la³ hí³ tɨ³ lɨ³mí¹ hliáun³ ngɨ¹³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tiá² re² ngɨ²³ né³, tsá² la³ hí³ tɨ³ lɨ³mí¹ tiú²uú² ngɨ¹³ bíh¹ lɨ³ua³ cáun² hi³ jmɨ́¹ lɨ́n²³ tsú² hi³ má²ngɨ²³ ca³lá². ");
INSERT INTO csoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hi³ jáun² cuan³ mí¹ziú¹³ Jesús la³ má²quionh³ jɨ³ tsá¹ raɨnh²¹ dí² ñí¹ cuá³, tɨ³la³ tiá² lɨ³ yáh³ tónh³² tsú² la³ tɨ³ ñí¹ cuá³ dí², quí¹ juóun³² lɨ́n³² bíh¹ tsáu² ná¹ngɨh³². ");
INSERT INTO csoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jmɨ́¹jáun² ca³nga³ tsáu² jáɨ¹³, hi³ ca³juáh³: ―Mí²ziúh² hnú² quionh³ tsá¹ renh² hnú² tionh² cheih³² nɨ́², hi³ hnió³ tsú² jɨ́e³² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tɨ³la³ Jesús né³, ca³záɨh³ tsá² ná¹ngɨh³² hí³ la³ lá²: ―Tsá² náɨ³² jáɨ¹³ quioh²¹ Dió³², hi³ má²tí³² siáh³, tsá² la³ hí³ bíh¹ ná¹lɨ́n³ mí²zia³² jná¹³ jɨ³ jon³ renh² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ca³chó³² cáun² jmáɨ¹ hi³ ca³hi³ Jesús cáun² mu² la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con²; jáun² ca³záɨh³ dí²: ―Ma³tsáu¹³ tɨ³ jo²¹ jmáɨ² ó³². Jáun² ja³taunh²¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tá¹la³ jmɨ́¹ hí¹tsá²táunh¹ tsú² jáun² né³, ca³cuóun² Jesús hñu³ mu². Jáun² cu³diá²jan² ca³ja³ chí³ tiá³ lɨ́n³², hi³ ca³la³ jmɨ́¹ má²hí¹conh³² yáh³ jmáɨ² hñu³ mu², ca³la³ háɨnh¹³ lɨ́n²¹ bíh¹ ca³lɨ³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hi³ jáun² ca³ñí¹ñi¹³ tsú² Jesús, hi³ ca³záɨh³ dí² la³ lá²: ―¡Tɨ³², Tɨ³², hénh³ máh³ má²tsá²hanh³² dí² hñu³ jmáɨ²! Hi³ jáun² ca³náu² Jesús hi³ ca³jin³ jmáɨ² hi³ ja³² jáun² ma³ cu³ tsɨn¹ quionh³ chí³, hi³ jáun² la³ cun³ jmɨ́¹jáun² ta³no¹ tie³ pih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jmɨ́¹jáun² ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con²: ―¿He³ lɨ³, jáun² sa³ tiú²uú² cáun² ná¹tioh³ honh² hnoh²? Tɨ³la³ tsá² hí³ má¹ná¹, lɨ́¹ ca³ta³ná¹juenh²¹ bíh¹, hi³ ca³juu³ ca³hlénh³ ja¹ hmóu³²: ―¿Hin² dá² tsánh² tsá² nɨ́², hi³ jáun² sa³ lɨ́²quien² máh³ héih³² quioh²¹ tsú² ñí¹con² jmáɨ² quionh³ chí³? ");
INSERT INTO csoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jmɨ́¹ lɨ²¹ jáun² né³, ca³cha³táunh¹ tsú² hué³² quioh²¹ tsá² Gadara, juú² nio² tɨ³ jo²¹ jmáɨ², ñí¹ jniá³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","La³ cun³ jmɨ́¹ cuá¹han³ jáun² Jesús hñu³ mu² jáun², ja³ jan² tsá²ñuh² ta³ ñí¹, tsá² zian² juú² jáun². Jmɨ́¹ má²ngau³² jmáɨ¹ lɨ́n²¹ bíh¹ hi³ tiáunh¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsá² hí³. Tsá² hí³ tiá² ha¹ jmɨ́¹ quɨh³², sa³jun³ jmɨ́¹ cuá³ hñú¹³, tɨ³la³ ñéih³ jéin³lo¹ táun³ ñí¹ tiáunh¹ hla¹ bíh¹ jmɨ́¹ cuá³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jáun² la³ cun³ jmɨ́¹ ca³jɨ́en³² jáun² tsá² hí³ Jesús, ca³hóh³² tiá³ lɨ́n³², hi³ ca³ñí¹di³jñí³² hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³², hi³ ca³juáh³ la³ lá²: ―¿He³ ca³tɨn¹ hnú² quiúnh¹ jná¹³, hnú² Jesús Jon² Dió³² Tsá² cú² juenh²? Mɨ́²³ jná¹³ hi³ ha³ lɨ́² jmú² hnú² hian² honh² ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","La³ nɨ́² ca³juáh³ tsá² hí³ quí¹hliá² má²dí¹jmu² Jesús héih³² hi³ huén³² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsú². Hliáun³ jéin³² má²ca³jmú³ jmɨ́²chí³ hláɨnh¹ hí³ hian² tsɨ́³, hi³ má²ca³zaunh³ tiá³ quioh²¹ tsú² jmɨ́¹tin², hi³ jáun² uá¹jinh¹ má²ca³hñéi³² tsáu² quioh²¹ tsú² cun³quionh³ hñe¹³ jɨ³ cá²den¹ná¹ nɨ́², hi³ ca³jmú³ tsú² hua³hí¹³ nɨ́² siáh³, tɨ³la³ cun³ jáun² ca³ca³ bíh¹ tsú² hi³ jáun²; hi³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ ca³di³quian³ jmáɨ¹ tsá² hí³ hi³ tsó³² la³ tɨ³ ñí¹ lɨ́³ hué³² quiéin². ");
INSERT INTO csoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jáun² Jesús ca³ngáɨ³ ñí¹con² tsá² hí³: ―¿Ha³ lánh³ jmáɨ² hnú²? Jáun² tsá² hí³ ca³ngáɨ³: ―Cu³ Nió³ bíh¹ jmáɨ² jná¹³. Hi³ jáun² la³ jáun² ca³juáh³ tsú² quí¹hi³hliá² jmɨ́¹ tiáunh¹ juóun³² lɨ́n³² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jáun² jmɨ́²chí³ hláɨnh¹ hí³ ca³hiu³ ca³mɨ́³ lɨ́n³² hi³ tiá² ze³ Jesús tɨ³ hñu³ háunh³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tsoh² máh³ zeh² có³² jáun² né³, jmɨ́¹ tiáunh¹ juóun³² mí²ñí³ hi³ jmɨ́¹ ná¹cúh² háu², jáun² jmɨ́²chí³ hláɨnh¹ hí³ né³, ca³hiu³ ca³mɨ́³ hi³ tsa³tiónh³² hñu³ tsɨ́³ mí²ñí³ hí³. Jáun² ca³cué³ bíh¹ Jesús jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Hi³ jáun² jmɨ́¹jáun² ca³huén² jmɨ́²chí³ hláɨnh¹ hí³ hñu³ tsɨ́³ tsá² hí³, hi³ jáun² ca³ñí¹tiónh²¹ hñu³ tsɨ́³ mí²ñí³. Jáun² la³jɨ́n³² mí²ñí³ hí³ ca³cuóun³ cú²hé² lɨ́n³² tɨ³ ñí¹ dí¹jɨ²³ ñí¹ hlah³ lɨ́n²¹, jáun² ca³sunh³ chu³ jmáɨ², hi³ jáun² ca³hnúh³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jáun² tsá² jmɨ́¹ ná¹jmu² hua³hí¹³ mí²ñí³ hí³ ca³cuóun³ jmɨ́¹ ca³jɨ́e³ hi³ lɨ³ la³ jáun², hi³ ja³tanh²¹ hi³ ca³ñí¹chá² tɨ³ já¹ juú² jɨ³ ñí¹ náɨ² nɨ́², hi³ má²lɨ́²jɨ́e³ jáun² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Hi³ jáun² tsá² ca³náɨ³² hí³ jáɨ¹³ jáun² né³, ca³ñí¹jɨ́e¹³ nɨ́¹juáh³ he³ dá² má²lɨ³², jáun² ca³cha³táunh¹ la³ tɨ³ ñí¹ zenh¹ Jesús, hi³ ca³jɨ́en³² tsú² siáh³ tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³, hi³ má²cuá¹tón²¹ ta³ ta³ Jesús, hi³ má²quih³² ha¹, hi³ má²chun¹, ha³ tiú²uú² ngo² yáh³. Hi³ jáun² tsá² ca³cha³táunh¹ hí³ né³, ca³juénh² lɨ́n³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jáun² tsá² ca³jɨ́e³ hí³ la³ cun³ hi³ má²lɨ³² jáun² ca³chá³ ha³ lánh³ rón³² lan³ tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jmɨ́¹ ca³náɨ³² jáun² tsá² hɨ́n¹³ hí³ juú² Gadara la³ jáun² né³, jáun² ca³la³ ca³juénh² lɨ́n³² bíh¹; hi³ jáun² la³jɨ́n³² tsá² hí³ ca³mɨ́³ hi³ cua³haɨn³² Jesús hué³² jáun² quioh²¹ dí². Hi³ jáun² Jesús ca³hi³ siáh³ hñu³ mu² hi³ ngah³ juɨ³² ñí¹ ja²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tɨ³la³ ñeh² bíh¹ hi³ tsánh³² Jesús, jáun² tsá² jmɨ́¹ tiáunh¹ hí³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ ca³hiu³ ca³mɨ́³ ñí¹con² Jesús hi³ tsó³² dí² quionh³ tsú². Tɨ³la³ Jesús má¹ná¹, ca³hah² jáɨ¹³ hi³ ca³jmú³ héih³², hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Cuánh² hnú² hñuh³², cuá²chá¹ la³jɨ́³² la³ cun³ hi³ má²lɨ́²jmú³ Dió³² ñí¹con² nú². Jáun² tsá² hí³ ngah³ hi³ ca³ñí¹chá² tɨ³ já¹ juú² la³ cun³ hi³ má²lɨ́²jmú³ jáun² Jesús ñí¹con² dí². ");
INSERT INTO csoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jmɨ́¹ lɨ²¹ jáun² ca³chánh³² Jesús tɨ³ jo²¹ jmáɨ², hi³ jáun² juóun³² lɨ́n³² tsáu² ca³heh³ tsú² hi³ hiún² lɨ́n³² tsɨ́³, quí¹hliá² la³jɨ́n³² tsá² hí³ jmɨ́¹ ná¹jaun² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jmɨ́¹jáun² ca³chó³² jan² tsá² jmáɨ² Jairo, tsá² jmɨ́¹ chín¹ cuáh³² quioh²¹ tsá² *judíos ñí¹ jáun²; jáun² ca³di³jñí³² hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³² ta³ ñí¹ Jesús, hi³ ca³hiu³ ca³mɨ́³ dí² hi³ tsó³² tsú² la³ tɨ³ hñú¹³ dí², ");
INSERT INTO csoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","quí¹hliá² jmɨ́¹ má²ñí¹jún³ mɨ́¹míh¹ tsá² jan² tán¹ jon² tsú². Mɨ́¹míh¹ hí³ jmɨ́¹ má²hún¹ quia³tún³ mii². Tá¹la³ hí¹tsau³² jáun² Jesús hñú¹³ tsá² hí³, jmɨ́¹ hí¹tsá²táunh¹ juóun³² lɨ́n³² tsáu² cu³chin¹ cu³hna²¹ tsú², ca³la³ má²chí¹cuú² chí¹jaɨn³² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hi³ jáun² ja¹ ñí¹ hí¹tsá²táunh¹ tsú² jáun² né³, jmɨ́¹ hí¹tsau³² jan² tsá²mɨ³, tsá² jmɨ́¹ tsáun¹ hi³ jmɨ́¹ zian² jmɨ́²hán¹ má²tí³ cun³ quia³tún³ mii². Ca³tsá³² bíh¹ la³jɨ́³² hi³ jmɨ́¹ zia³² quioh²¹ tsú², tɨ³la³ cun³ jáun² hí¹ jan² yáh³ tɨ³² mɨ́³ tiá² ca³tioh²¹ hi³ jmah³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jáun² tsá²mɨ³ hí³ ngau³ tɨ³ cu³hna²¹ Jesús, hi³ ca³tí³ dí² cuo² zéi¹ ha¹ tsú²; jáun² la³ cun³ jmɨ́¹jáun² ca³hná³ jmɨ́²hán¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Hi³ jáun² Jesús ca³juáh³: ―¿Hin² tsánh² lɨ́²tie³ jná¹³ cuo²? Tɨ³la³ hí¹ jan² yáh³ tiá² hin² ca³ton³. Jáun² Pé¹ ca³juáh³ la³ lá² quionh³ tsá² quionh³: ―Tɨ³², já² la³jɨ́n³² tsáu² bíh¹ jmu² hi³ chí¹cuú² chí¹jaɨn³² hnú², hi³ cuú² hliau² tsú² hnú². Sa³ hin² lɨ́²tie³ jná¹³ cuo² yáh³ juánh³ nú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tɨ³la³ Jesús ca³juáh³ siáh³: ―Cu³tí³ bíh¹ lɨ́²tie³ jná¹³ jan² tsáu² cuo², quí¹hliá² ca³lɨ³ liei²¹ jná¹³ hi³ lɨ́²jmú³ ta²¹ pí³ quion²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jmɨ́¹ ca³lɨ³ lieih²¹ jáun² tsá²mɨ³ hí³ hi³ tiá² la³ lɨ́¹³ yáh³ hính³², jáun² ca³la³ má²juán²³ hi³ má²juénh² ja³ hi³ ca³ñí¹di³jñí³², hi³ ca³jmú³ cuá¹hin³ la³ tɨ³ hué³² ta³ ñí¹ Jesús; hi³ jáun² ca³chá³ tsú² ñí¹ ta³ ñí¹ la³jɨ́n³² tsáu² hi³ he³ ca³tɨ²¹ lɨ́²tí³ dí² cuo² ha¹ Jesús, jɨ³ he³ lánh³ rón³² lan³ tsú² siáh³ ca³la³ cun³ jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jáun² Jesús ca³juáh³ la³ lá² ñí¹con² tsá²mɨ³ hí³: ―Hnú² jón³, má²laɨn³² hnú² quí¹ cun³ñí¹ hi³ lɨ́²cháh¹ nú² cáun² honh². Cuánh² hnú² cáun² hi³ re² hi³ tɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² Jesús, cuan³ jan² tsá² hñú¹³ Jairo tsá² chín¹ hí³ cuáh³² quioh²¹ tsá² judíos, jáun² ca³záɨh³ dí² Jairo la³ lá²: ―Má²jun² bíh¹ mɨ́¹míh¹ jónh³² hnú², ha³ lɨ́²uú² ma³tsan¹³ tsɨ́³ Tɨ³² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tɨ³la³ jmɨ́¹ ca³náɨ³² Jesús jáɨ¹³ jáun² né³, ca³juáh³: ―Ha³ lɨ́² juenh³, ñí¹ jɨ́²¹la³ chá¹ hnú² cáun² honh² bíh¹, hi³ jáun² lan¹³ jónh³² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jmɨ́¹ cá¹chó²¹ jáun² Jesús hñú¹³ tsá² hí³ né³, tiá² jáɨ¹³ ca³cuéh³ yáh³ tsú² tsáu² hi³ tónh³² ñéih³, jɨ́³²la³ Pé¹ quionh³ Jacobo, Juan² nɨ́², jɨ³ jméi² mí¹ziú¹³ bíh¹ mɨ́¹míh¹ hí³ ca³cuéh³ tsú² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","La³jɨ́n³² bíh¹ tsá² jmɨ́¹ má²tionh² hí³ jmɨ́¹ ná¹tɨ́² ná¹hóh³² hi³ ná¹ho² ná¹jngɨh² hi³ ca³tɨn¹ mɨ́¹míh¹ hí³. Tɨ³la³ Jesús ca³juáh³: ―Ha³ lɨ́² uó² náh², ha³ tiá² rá²jún¹ yáh³ mɨ́¹míh¹ lá², quí¹ rá²cuóun¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tɨ³la³ tsá² hí³ né³, lɨ́¹ ca³ju³ ca³ngáɨ³ bíh¹, quí¹hliá² jmɨ́¹ ná¹ñi³² tsú² hi³ cu³tí³ bíh¹ má²rá²jún¹ mɨ́¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tɨ³la³ Jesús cáun² ca³zanh³ bíh¹ cuo² hla¹ mɨ́¹míh¹ hí³, hi³ ca³hléh³ tiá³, hi³ ca³juáh³: ―¡Mɨ́¹míh¹, náu²! ");
INSERT INTO csoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hi³ jáun² ca³jenh¹³ siáh³ mɨ́¹míh¹ hí³, hi³ jáun² la³juɨ³² ca³náu² bíh¹. Hi³ jáun² ca³jmú³ Jesús héih³² hi³ ma³ton³ tsú² mɨ́¹míh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jáun² lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹ jméi² mí¹ziú¹³ mɨ́¹míh¹ hí³, tɨ³la³ Jesús ca³jmú³ héih³² hi³ hí¹ jan² yáh³ tiá² hin² hniáuh³² záɨh³² tsú² ca³tɨ²¹ hi³ má²lɨ³² jáun² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ca³ngɨh³ Jesús tsá² quian³tun³ hí³, hi³ ca³cuéh³ dí² tsá² hí³ pí³ hi³ lɨ́¹³ huen³ tsú² la³jánh³ dú¹ ñí¹ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², jɨ³ hi³ jmah³ tsú² siáh³ tsá² ná¹tsáun¹ la³jɨ́³² ñí¹ mɨ́¹uɨ́³; ");
INSERT INTO csoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","jáun² ca³zen³ tsú² tsá² hí³ hi³ tsa³hléh² jáɨ¹³ ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³², hi³ tsa³jmah¹ tsú² tsá² tsáun¹ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jmɨ́¹jáun² ca³záɨh³ tsú² tsá² hí³ la³ lá²: ―Hí¹ cáun² yáh³ hi³ quioh²¹ hú¹ juɨ³² tiá² hniáuh³² ñí¹quiánh¹ náh². Lɨ́² cán² náh² hmá²hu²¹, sa³jun³ tuh³², sa³jun³ má³², hi³ sa³jun³ quɨe³. Ñí¹ jɨ́²¹la³ quián² ma³ cáun² hmɨh³² cháu³ bíh¹, tɨ³la³ lɨ́² cán² tun³ má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jáun² lɨ³ua³ cáun² hñú³ ñí¹ chauh²¹ náh² jáun², ñí¹ jáun² bíh¹ tianh¹³ náh² ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ huen¹³ náh² juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nɨ́¹juáh³ ca³cha³táunh¹ náh² ñí¹ tiá² hnió³ tsú² he³ náh², cu³tsa³² huen³ náh² cú²jueh³² juú² la³ jáun², súh³ náh² hliáu² quian²¹ tanh¹ ñí¹ jáun², hi³ jáun² la³ jáun² lɨ³ lin¹ hi³ tiá² ca³quiú¹ ca³jéi¹³ náh² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hi³ jáun² jmɨ́¹jáun² já¹taunh²¹ tsú² juú² ñí¹ hliáun³ hi³ ca³ñí¹hléh² jú¹ chú³² quioh²¹ Dió³², hi³ jáun² ca³jmah³ tsú² tsá² tsáun¹ ca³la³ jɨ́³² juú² ñí¹ ca³cha³táunh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hi³ jáun² jmáɨ¹ jáun², Herodes, tsá² cuá¹lɨ́n³ ta²¹ hué¹³ Galilea, ca³lɨ³ ñi³² la³jɨ́³² hi³ jmu² Jesús; hi³ tiá² jmɨ́¹ ñi³² yáh³ tsú² he³ hniáuh³² lɨ́n¹³, quí¹hliá² ma³ jan² tsáu² jmɨ́¹ ná¹juáh²³ hi³ hla¹ Juan² tsá² jmɨ́¹ zion² tsáu² jmáɨ² bíh¹ má²ca³jenh¹³ ja¹ tsá² má²cá²tsan³; ");
INSERT INTO csoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","hi³ ma³ jan² siáh³ tsá² siánh³ jmɨ́¹ ná¹juáh²³ hi³ Líh³ tsá² jmɨ́¹ lɨ́n³ *tɨ³² jë¹ Dió³² bíh¹ néh¹ hí³, hi³ má²cá²jnia³ siáh³. Ja³bí¹ ma³ jan² tsá² siánh³ siáh³ jmɨ́¹ ná¹juáh²³ hi³ hí³ bíh¹ jan² tsá² jmɨ́¹ lɨ́n³ tɨ³² jë¹ Dió³² jmɨ́¹tin² lɨ́n³², hi³ má²ca³jenh¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tɨ³la³ Herodes ca³juáh³: ―Huen² bíh¹ jná¹³ ca³jmú³² héih³² hi³ tsa³quiéih³ tsú² cun³ ngá¹³ mí¹táɨ³ láɨ¹ Juan². Jáun² né³, ¿hin² bíh¹ tsánh² tsá² hí³ hi³ jlánh¹ cha³² tsú² hliáun³ jáɨ¹³ quioh²¹? Hi³ jáun² hnga² Herodes jlánh¹ jmɨ́¹ hniá¹ hi³ jɨ́en³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jmɨ́¹ cá¹jính²¹ jáun² tɨ³² tsá² quian³² hí³ jë¹ Dió³² ñí¹con² Jesús, jáun² ca³chá³ tsú² la³jɨ́³² la³ cun³ hi³ ca³jmú³. Jmɨ́¹jáun² ca³jan³ Jesús tsá² hí³, hi³ ja³taunh²¹ tsú² tɨ³ ñí¹ siáh³, ñí¹ má²janh² ca³lá² juú² Betsaida. ");
INSERT INTO csoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tɨ³la³ jmɨ́¹ ca³lɨ³ ñi³² tsáu² ha³ jinh¹ ngau³ Jesús, jáun² jmɨ́¹jáun² já¹taunh²¹ tsú² ñí¹ jáun². Hi³ jáun² hiún² lɨ́n³² bíh¹ tsɨ́³ Jesús ca³hen³ tsá² hí³, jáun² ca³hɨ́eh³ dí² tsá² hí³ ha³ lánh³ rón³² lɨ́¹³ tónh³² jo³cuo² Dió³², hi³ ca³jmah³ dí² siáh³ tsá² tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jmɨ́¹ má²ca³hláu³ jáun² né³, ca³ma³janh³² siáh³ tsá² quian³tun³ hí³ ñí¹con² Jesús hi³ ca³juáh³ la³ lá²: ―Chú³² juoh¹ hnú² tsá² nɨ́² hi³ tsa³tánh¹ hi³ tsa³hniáu³ hñú³ jɨ³ hi³ cuh³ la³jɨ́³² juú² hi³ zia³² la³ cu³ la³ jéin³ ñí¹ tiauh¹ dí² lá², quí¹ hí¹ jan² yáh³ tiá² hin² zian² ñí¹ má²janh² lá². ");
INSERT INTO csoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Tɨ³la³ Jesús ca³ngáɨ³: ―Hnoh² bíh¹ hniáuh³² cueh¹ tsú² hi³ cuh³. Jáun² né³, tsá² hí³ ca³ngáɨ³ siáh³: ―Jɨ́³²la³ hñá³ *hí³ cuú²miih²¹ bíh¹ zia³² quiú¹³ jnoh¹ hi³ cónh³ gon³ hma²¹ siáh³. Jɨ́³² uá¹ jáun² bíh¹, nɨ́¹juáh³ hi³ tsá¹lá¹³ jnoh¹ má³² quioh²¹ ca³la³ jɨ́n³² tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tsá² jmɨ́¹ tionh¹ jáun² ñí¹jáun² jmɨ́¹ tín³ cun³ hñá³ mei²¹ jmáh³la³ tsá²ñuh². Jáun² Jesús ca³záɨh³ siáh³ tsá² quian³tun³ hí³: ―Jmu³ hnoh² héih³² hi³ tiánh³ tsú² ma³ tu³la³quian³ ma³ quin³² ma³ cun³ nió³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hi³ jáun² la³ jáun² ca³jmú³ tsú², hi³ la³jɨ́n³² tsú² ca³tiánh³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jáun² jmɨ́¹jáun² ca³zanh³ Jesús tá¹ hñá³ hí³ cuú²miih²¹ jáun² jɨ³ tá¹ gon³ hma²¹ hí³, hi³ ca³jɨ́e³ tsú² tɨ³ hñu³mɨ³cuú², hi³ ca³cuéh³ tiá¹hmah¹ Dió³². Jmɨ́¹ lɨ²¹ jáun² né³, ca³cuéh³ tsú² tsá² haɨn²¹ hí³ tɨ³ con² hi³ tsóh³ ñí¹con² tsá² tionh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jáun² ca³la³ jɨ́n³² tsá² hí³ lah³ re² má³². Jmɨ́¹ lɨ²¹ jáun² né³, ca³jieh³ tsú² ca³la³ jɨ́³² chí² juoh¹ hi³ ziau³ jáun²; chí² juoh¹ jáun² né³ lɨ³ quia³tún³ mɨ́²ta². ");
INSERT INTO csoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ca³chó³² jmáɨ¹ hi³ Jesús jmɨ́¹ cuá¹liéinh³² Dió³² cáun² ñí¹ tɨ³ có³², hi³ jmɨ́¹ quionh³ tsú² tsá² haɨn²¹ hí³ tɨ³ con². Jmɨ́¹jáun² ca³ngáɨh³ tsú² tsá² hí³ hi³ ca³juáh³: ―¿Hin² tsánh² jná¹³ juáh³ tsáu²? ");
INSERT INTO csoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jáun² tsá² hí³ ca³ngáɨ³: ―Zian² tsá² juáh³ hi³ hnú² bíh¹ néh¹ hla¹ Juan² tsá² tɨ́² zion² tsáu² jmáɨ², ma³ jan² siáh³ tsá² juáh³ hi³ hnú² bíh¹ Líh³, tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³², hi³ ma³ jan² siáh³ tsá² juáh³ hi³ hnú² bíh¹ néh¹ jan² tɨ³² jë¹ Dió³² tsá² jmɨ́¹ zian² jmɨ́¹tin², hi³ má²ca³jenh¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hi³ jáun² Jesús ca³ngáɨ³ siáh³: ―Hi³ hnoh² né³, ¿hin² tsánh² jná¹³ juáh³ hnoh²? Jáun² né³, Pé¹ ca³juáh³: ―Hnú² bíh¹ Tsá² lɨ́n³ Cristo Tsá² zéi¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Tɨ³la³ Jesús ca³jmú³ héih³² hi³ hí¹ jan² tiá² hin² hniáuh³² záɨh³² tsú² la³ cun³ hi³ má²lɨ́²juáh³ jáun² Pé¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Hi³ jáun² ca³juáh³ siáh³ la³ lá²: ―Ca³tɨn¹ Jon² tsá²mɨ³cuóun² hi³ ma³tso² lɨ́n³² tsɨ́³. Tsá²daun³² tsá² ná¹ñí¹ juú² quionh³ tsá² ná¹lɨ́n³ mi³jmú³, jɨ³ tɨ³² liei²¹ nɨ́² siáh³ tiá² quiú¹ tiá² jéin¹³ tsá² hí³, hi³ jngɨh³ tsú²; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² má¹ná¹, jenh¹³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jmɨ́¹ lɨ²¹ jáun² né³, ca³záɨh³ Jesús la³jɨ́n³² tsá² hí³: ―Nɨ́¹juáh³ zian² tsá² hnió³ já³² cu³hna³² jná¹³, hniáuh³² chá³² tsú² tɨ³ có³² la³jɨ́³² hi³ dí¹quiaunh²¹ tsɨ́³ hnga², hi³ jáun² cuɨ́¹ quián¹³ tsú² crei²¹ quioh²¹, la³ cun³ hi³ cuéh³² tsú² jáun² tsɨ́³ uá¹jinh¹ ca³la³ ñí¹ ca³cáɨn³ jmɨ́²chí³ quioh²¹, hi³ jáun² cuɨ́¹ já² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Quí¹ nɨ́¹juáh³ tsá² hnió³ lión³² hnga², tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tsa³hín³ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ má¹ná¹, jáun² tsá² la³ hí³ bíh¹ tɨ³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Quí¹ ¿ha³ dá² jinh¹ quien² nɨ́¹juáh³ ca³láɨh¹³ tsú² la³jɨ́³² hi³ zia³² ñí¹ hué²¹ lá², nɨ́¹juáh³ la³ ja³hín³ bíh¹ jmɨ́²chí³ quioh²¹ tsú² má¹lɨ³² jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nɨ́¹juáh³ tsá² jmu² heh³ hi³ ca³tɨn¹ jná¹³ jɨ³ ca³tɨ²¹ jáɨ¹³ quion²¹ jná¹³ siáh³, ja³bí¹ jná¹³ Jon² tsá²mɨ³cuóun² jmu¹ heh¹ ca³tɨn¹ tsá² la³ hí³ nɨ́¹ má¹jaunh³² jná¹³ jáun²; hi³ lɨ³ lin¹ hi³ quien² jná¹³, jɨ³ hi³ quien² Ñuh³² jná¹³, jɨ³ hi³ lin¹ hi³ quien² uá²jaɨ³² tsá²cuú² tsá²ta³ Dió³² tsá² ná¹chun¹ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jú¹ tson² juo³ jná¹³ hnoh², hi³ zian² tsá² ja¹ ñí¹ tiauh¹ dí² lá² tiá² má²jún³ yáh³ ta³ tiá² má²lɨ́²jɨ́e³ hi³ má²cua³² pí³ quioh²¹ Dió³² ñí¹con² tsá² má²tionh² jo³cuo². ");
INSERT INTO csoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jmɨ́¹ má²ñí¹tɨ²¹ jáun² jña³ jmáɨ¹ hi³ ca³juáh³ Jesús jáɨ¹³ jáun², jáun² ca³ñí¹uu³² tsú² cáun² máh³, hi³ ca³ñí¹lienh¹³ Dió³²; jáun² ca³jan³ dí² Pé¹, Jacobo, jɨ³ Juan² siáh³ hi³ tsa³quionh³ dí² tsɨ³ máh³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tá¹la³ cuá¹liéinh³² jáun² Jesús Dió³² né³, ca³za² ho¹ñí¹, jɨ³ ha¹ nɨ́² ca³lɨ³ tiáu² hi³ lɨ³ siáh³ zɨ́n³ lɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hi³ jáun² cu³diá²jan² ca³jnia³ gon³ tsáu² hi³ ca³juónh³ quionh³ Jesús, hla¹ Moisés quionh³ Líh³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Tá¹ gon³ jáun² tsá² hí³ jmɨ́¹ ná¹quian³² joh¹ zɨ́n³ lɨ́n³². Tsá² hí³ ca³juónh³ Jesús quionh³ ca³tɨ²¹ jmáɨ¹ hi³ jún³ tsú² já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hi³ jáun² uá¹jinh¹ Pé¹ jmɨ́¹ tioh¹³ lɨ́n³² ziú³ ñí¹ quionh³ tsá² quionh³, tɨ³la³ ca³tiánh³ bíh¹ tsú² ná¹ñí¹, hi³ jáun² ca³jɨ́e³ tsú² hi³ ca³lɨ³ zɨ́n³ lɨ́n³² Jesús; hi³ ca³jɨ́en³² tsú² siáh³ tá¹ gon³ tsá² tionh² hí³ quionh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jáun² tsá² gon³ hí³ jmɨ́¹ má²ná¹hah² jáɨ¹³ quionh³ Jesús, tɨ³la³ Pé¹ né³ ca³juáh³: ―Hnú² Tɨ³², hénh³ ma³ chú³² má²tiauh² dí² ñí¹ lá². Jáun² cuɨ́¹ jmú¹³ jnoh¹ hnɨ³² hñú³reh³, cáun² quián¹³ hnú², cáun² quioh²¹ Moisés, hi³ cáun² siáh³ quioh²¹ Líh³. Tɨ³la³ tiá² jmɨ́¹ ñi³² yáh³ Pé¹ he³ dá² dí¹hleh³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tá¹la³ dí¹hleh³² jáun² bíh¹ Pé¹, ja³ cáun² jnie² ñí¹ tionh¹ tsú² jáun² hi³ ca³tsáɨnh³² tsú² jɨ³lɨn², hi³ jáun² ca³juénh² tsú² jmɨ́¹ ca³ta³tonh¹ jáun² ja¹ jnie². ");
INSERT INTO csoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Hi³ jáun² ja¹ jnie² jáun² ñí¹ca³hléh³ jan² tsáu² hi³ ñí¹juah²¹: ―Tsá² lá² bíh¹ Jón³² jná¹³, Tsá² cuá¹quiánh¹. Niéi² náh² la³ cun³ hi³ juáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jmɨ́¹ ca³nga² jáɨ¹³ jáun² né³, ca³jɨ́en³² tsú² Jesús cuá¹tón²¹ hnga². Jáun² Pé¹ quionh³ tsá² quionh³, hí¹ cáun² yáh³ jáɨ¹³ jáun² tiá² ca³chá³ tsú² jmɨ́¹jáun² ñí¹con² tsá² siánh³ la³ cun³ hi³ lɨ³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Jmɨ́¹ cá¹jniá²¹ jáun² ca³jính³² Jesús tsáɨh³ máh³ jáun² quionh³ tsá² quionh³. Jmɨ́¹jáun² ca³jenh² tsú² juóun³² lɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Hi³ jáun² ja¹ tsá² ná¹ngɨh³² hí³ ca³hóh³² jan² tsá²ñuh² tiá³ lɨ́n³², hi³ ca³juáh³: ―Hnú² Tɨ³², tiá¹ jmúh¹³ hnú² hi³ chú³² hi³ jɨen¹ nú² tiá³ ñú²míh¹ jón³² jná¹³, jan² tán¹ lá² bíh¹ jón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Quí¹ jan² jmɨ́²chí³ hláɨnh¹ ja³² hi³ zaunh²³, hi³ jmu² hi³ hóh³² tsú² tiá³, hi³ he² tsú² siáh³ tsá¹ lɨ́¹ jún²³, hi³ hia³² jan³² ho³; ca³la³ hian² lɨ́n³² tsɨ́³ jmu², tion³ cu³tí³ bíh¹ tun²³ ñú²míh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Má²lɨ́²hiú² lɨ́²mɨ́³ bíh¹ jná¹³ ñí¹con² tsá² haɨn²¹ nɨ́² tɨ³ con² hnú² hi³ jmɨ́¹ chin¹³ tsú² jmɨ́²chí³ hláɨnh¹, tɨ³la³ tiá² ca³tioh²¹ yáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hi³ jáun² Jesús ca³ngáɨ³: ―¡Hnoh² tsá² tiá² ta²¹ táunh²³ náh², tsá² cáun² lɨ́¹ cháunh²³ chinh³² la³ siáh³! ¿Jáh³ jmáɨ¹ máh³ hniáuh³² hi³ ngɨ́¹³ jná¹³ quiúnh¹ hnoh², hi³ tion¹ jná¹³ tsɨn³²? Ñá²jan³² jónh³² tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tɨ³la³ tá¹la³ cuá¹ja³² jáun² ñú²míh¹ hí³ ñí¹ zenh¹ Jesús, ca³la³ hian² lɨ́n³² bíh¹ tsɨ́³ jmɨ́²chí³ hláɨnh¹ ca³jmú³ ñí¹con² ñú²míh¹, hi³ ca³jmú³ hi³ he¹³ tsá¹ lɨ́¹ jún²³ ñú²míh¹ hí³. Tɨ³la³ jmɨ́¹ ca³jin³ Jesús jmɨ́²chí³ hláɨnh¹ hí³ né³, la³ cun³ jmɨ́¹jáun² bíh¹ lan³ ñú²míh¹ hí³. Jmɨ́¹jáun² ca³jɨenh³ tsú² ñú²míh¹ hí³ ñí¹con² jméi². ");
INSERT INTO csoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hi³ jáun² ca³la³ jɨ³lɨn² tsú² ca³ja³cáun² tsɨ́³ jmɨ́¹ ca³jɨ́e³ pí³ quioh²¹ Dió³². Tá¹la³ jmɨ́¹ ná¹tsá²cáun² jáun² tsɨ́³ tsú² jɨ³lɨn² ca³tɨ²¹ hi³ má²lɨ́²jmú³ jáun² Jesús la³ jáun², jáun² ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Náɨh¹³ hnoh² re² lɨ́n³² jáɨ¹³ hi³ juanh²¹ jná¹³ lá²: jná¹³, Jon² tsá²mɨ³cuóun², jɨenh³ tsú² jo³cuo² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tɨ³la³ tsá² hí³ né³, hí¹juáh³ tiá² ca³ngɨ¹³ bíh¹ he³ dá² jaun³² dí¹juáh²³ tsú², quí¹ tiá² jmɨ́¹ má²zia³² yáh³ jáɨ¹³ hi³ lɨ́¹³ lɨ³ ngɨ¹³ tsú², hi³ jmɨ́¹ juénh² tsú² siáh³ hi³ mɨ́³² ñí¹con² Jesús hi³ jmu³ na²¹ jáɨ¹³ hi³ má²lɨ́²juáh³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Hi³ jáun² né³, tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ma³liáu³² hi³ quiú² táɨnh²³ hi³ hin² bíh¹ tsánh² jlánh¹ quien² já¹ hmóu²¹ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tɨ³la³ Jesús ca³lɨ³tsɨn² hi³ ha³ lánh³ ná¹lɨ́n²³ tsá² hí³, jáun² ca³can³ dí² jan² tsá¹míh¹ hi³ ca³zinh³ dí² cu³héin¹; ");
INSERT INTO csoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","jmɨ́¹jáun² ca³juáh³ la³ lá²: ―Lɨ³ua³ jan² tsá² hen³ tsá² tsá¹míh¹ la³ lá² chá³² jná¹³, má²lɨ́²he³ jɨ³ jná¹³ bíh¹ tsú² jaun³². Hi³ nɨ́¹juáh³ tsá² he³ jná¹³ né³, ja³bí¹ la³ jáun² má²lɨ́²hen³ tsú² siáh³ Tsá² ca³ze³ jná¹³. Quí¹ tsá² tiá² lin¹ ñí¹ quien² ja¹ ñí¹ tionh¹ hnoh² nɨ́², tsá² la³ hí³ bíh¹ tɨ³ jlánh¹ quien². ");
INSERT INTO csoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Hi³ jáun² Juan² ca³záɨh³ Jesús: ―Tɨ³², má²lɨ́²neh²¹ jnoh¹ jan² tsá² huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² la³juah²¹ dú¹ cun³quionh³ héih³² quián¹³ hnú², jáun² má²lɨ́²jmú¹³ jnoh¹ héih³² hi³ tiú²uú² jmu³ tsú² la³ jáun², quí¹hliá² tiá² ngɨ³² yáh³ tsú² quiúnh¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tɨ³la³ Jesús ca³juáh³: ―Ha³ lɨ́² jmu² náh² héih³² la³ nɨ́², quí¹ nɨ́¹juáh³ tsá² tiá² hau² náh², tsá² hen² tɨ³ con² bíh¹ náh² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jmɨ́¹ má²ñí¹chau²¹ jáun² jmáɨ¹ hi³ má²tsánh³² Jesús tɨ³ hñu³mɨ³cuú², jáun² ca³chá³ tiá³ tsɨ́³ hi³ tsó³² la³ tɨ³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jáun² ca³zen³ dí² tsáu² chí¹ján³ ñí¹ nio¹ cáun² juú² míh¹ hɨ́n¹³ tɨ³ Samaria hi³ tsa³hniáu³ la³jɨ́³² la³ cun³ hi³ lɨ³ hniáuh³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tɨ³la³ tsá² juú² jáun² má¹ná¹, tiá² ca³hen³ yáh³ Jesús, quí¹hliá² ca³lɨ³tsɨn² tsú² hi³ Jesús má²hún¹ juɨ³² hi³ tsó³² tɨ³ Jerusalén bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jmɨ́¹ ca³jɨ́e³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² Jesús, la³ cun³ Jacobo jɨ³ Juan² nɨ́², hi³ jmu² tsá² juú² jáun² la³ jáun², jáun² ca³juáh³: ―Hnú² Tɨ³² ¿tiá¹ hnáuh² hnú² hi³ jmú¹³ jnoh¹ héih³² hi³ já³² sɨ́² tɨ³ hñu³mɨ³cuú² hi³ tsán¹³ tsá² juú² nɨ́², la³ cun³ ca³jmú³ jáun² Líh³ tsá² jmɨ́¹ lɨ́n³ hí³ tɨ³² jë¹ Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jáun² Jesús ca³jɨ́e³ tɨ³ ñí¹ tionh¹ tsú² hi³ ca³jin³ dí² tá¹ gon³ tsá² hí³, hi³ ca³juáh³: ―Jun³juáh¹³ la³ nɨ́² yáh³ jmɨ́¹ hniáuh²¹ lɨ́n¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Quí¹ jun³juáh¹³ jáun² yáh³ cuan³ jná¹³, Jon² tsá²mɨ³cuóun², hi³ má¹tsán¹³ jná¹³ tsáu², tɨ³la³ cuan³ jná¹³ hi³ tɨ³ lion¹ bíh¹ jná¹³ tsú². Jáun² juú² siáh³ bíh¹ cú²jueh³² ja³taunh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tá¹la³ jmɨ́¹ hí¹tiáunh¹ tsú² jáun² juɨ³², ca³hléh³ jan² tsáu² ñí¹con² Jesús hi³ ca³juáh³: ―Hnú² Tɨ³², ñe¹ bíh¹ jná¹³ quiúnh¹ hnú² lɨ³ua³ cáun² ñí¹ cuóh¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jáh³ zia³² tá²hláu² quioh²¹ bíh¹ cuo², hi³ zia³² bíh¹ siáh³ záɨ² quioh²¹ tan³²; tɨ³la³ Jon² Tsá²mɨ³cuóun² má¹ná¹, tiá² zia³² yáh³ ñí¹ lɨ́¹³ jnioh¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jmɨ́¹jáun² ca³záɨh³ Jesús jan² tsá² siánh³ siáh³: ―Ña³² cu³hna³² jná¹³. Tɨ³la³ tsá² hí³ né³, ca³ngáɨ³: ―Tɨ³², cué¹ tín² jáɨ¹³ hi³ ñí¹hón²¹ jná¹³ ñuh³² nɨ́¹ má¹jun². ");
INSERT INTO csoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Tɨ³la³ Jesús né³, ca³záɨh³ tsá² hí³: ―Tsá² ná¹jún¹ ñí¹con² Dió³² cuɨ́¹ cha³hón³² hla¹ raɨnh²¹, tɨ³la³ hnú² ca³tɨn¹ cuá¹ngáɨ¹ jú¹ chú³² ca³tɨ²¹ ha³ lánh³ rón³² lɨ́¹³ tónh³² tsáu² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hi³ jáun² ca³juáh³ jan² tsá² siánh³ siáh³: ―Hnú² Tɨ³², jná¹³ hnó³² ñe¹ quiúnh¹ hnú², tɨ³la³ cué¹ tín² jáɨ¹³ hi³ ñí¹háɨh¹ jná¹³ jáɨ¹³ ñí¹con² tsá² tionh² hñu³². ");
INSERT INTO csoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Lɨ³ua³ jan² tsá² má²liáu³² ta²¹ quioh²¹, lɨ́n³ la³jmɨ́¹ lɨ́n³ jan² tsá² quiáh² hué³² quionh³ cuá¹juɨ́²; nɨ́¹juáh³ cá² ñí¹ jɨ́e²³ tɨ³ cu³hna²¹ bíh¹ tsú², jáun² tsá² la³ hí³ tiá² lɨ́¹³ yáh³ hí³ jo³cuo² Dió³², quí¹ jan² tsá² hliah²³ tá¹³ bíh¹ lɨ́n³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ca³quianh³ siáh³ Jesús hnaɨh³² nio² quiún³ tsɨ²¹ quian³ tsá² siánh³ siáh³, hi³ jáun² ma³ gon³ tsá² hí³ ca³zen³ dí² la³jɨ́³² juú² ñí¹ ca³tɨ²¹ tsó³² dí² hnga². ");
INSERT INTO csoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Jmɨ́¹jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Hliáun³ cu³tí³ bíh¹ hi³ má²ca³láu², tɨ³la³ cú¹pih²¹ bíh¹ tsá² jmu² ta²¹ zian². Hi³ jáun² né³, hiú¹ mɨ́¹ náh² ñí¹con² Tsá² quioh²¹ hi³ má²ca³láu² jáun², hi³ cuɨ́¹ zen¹ tsú² tsá² ja³quiaun² hi³ má²ca³láu² jáun² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Cuá²táunh¹ hnoh² ta³né³²; tɨ³la³ sá¹nɨ́² jɨe³ tín², jná¹³ zei²¹ hnoh² hi³ ná¹lɨ́n³ náh² la³jmɨ́¹ lɨ́n³ *já¹ziáh² míh¹ tionh² ja¹ tsɨ́²náɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ha³ lɨ́² cán² náh² tuh³², sa³jun³ chí² láu² tioh³ quɨe³, sa³jun³ tuh³² tioh³ ta³ tsú². Tiá² hniáuh³² cuá¹ma³léh¹³ hnoh² siáh³ hú¹ juɨ³² hi³ lienh¹ hnoh² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hi³ jáun² lɨ³ua³ cáun² hñú³ ñí¹ chá¹táunh¹ náh² jáun², juoh¹ náh² tsá² hñú¹³ la³ lá²: “Cuɨ́¹ tionh² bíh¹ hnoh² cáun² hi³ re² hi³ tɨn²”. ");
INSERT INTO csoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hi³ nɨ́¹juáh³ zian² tsá² ca³tɨn¹ tiánh³ cáun² hi³ re² hi³ tɨn² ñí¹ jáun², jáun² lɨ́¹³ bíh¹ tiánh³ tsú² tie³ cun³quionh³ jáɨ¹³ hi³ hléh¹³ hnoh² jáun²; tɨ³la³ nɨ́¹juáh³ tiá² zian² tsá² la³ hí³, jáun² ñí¹con² hmóu³² bíh¹ hnoh² jmu³ ta²¹ jáɨ¹³ hi³ hléh¹³ náh² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Cáun² tán¹ hñú³ bíh¹ hniáuh³² cuá¹tianh³ náh²; cáun² cuá²cú¹ cuá²hính³ náh² lɨ³ua³ cáun² hi³ cue³² tsú² ñí¹ jáun², quí¹ jan² tsá² jmu² ta²¹, cun³ ca³tɨn¹ he³ bíh¹ hmah²¹ quioh²¹. Ha³ lɨ́² cua³jnioh² náh² tɨ³ hlá² tɨ³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hi³ jáun² né³, lɨ³ua³ cáun² juú² ñí¹ he³ tsú² hnoh², quɨéɨh³ náh² la³ cun³ má³² hi³ cue³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jmah²¹ náh² tsá² ná¹tsáun¹ ñí¹ jáun², hi³ zéih³ náh² siáh³ tsáu² la³ lá²: “Dió³² má²cuá¹hinh²³ tsáu² jo³cuo²”. ");
INSERT INTO csoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tɨ³la³ lɨ³ua³ cáun² juú² ñí¹ tiá² he³ tsú² hnoh², cuá²tianh³ náh² já¹ hñú³, hi³ juáh¹³ hnoh² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Hí¹ la³ tɨ³ hliáu² quian²¹ ta³ yáh³ jnoh¹ má²súh¹³ ta³né³², hi³ jmú¹³ jnoh¹ lin¹ hi³ má²tionh² hnoh² ñí¹ háɨnh¹³. Tɨ³la³ cuɨ́¹ ná¹ñíh¹ náh², hi³ jmɨ́¹ má²ca³lɨ³zia³² bíh¹ jáɨ¹³ hi³ jmɨ́¹ lɨ́¹³ heh³ náh² Dió³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Juanh³² jná¹³ siáh³ ñí¹con² hnoh² hi³ tɨ³ cú¹pih²¹ bíh¹ ma³tso² tsá² jmɨ́¹ zian² juú² Sodoma tsɨ́³ la³ cun³ bíh¹ tsá² zian² juú² ñí¹ tiá² he³ tsú² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","”¡Jlánh¹ juon²³ hnoh² tsá² juú² Corazín! ¡Jlánh¹ juon²³ siáh³ hnoh², tsá² juú² Betsaida! Quí¹ sá¹jmɨ́¹ hi³ ca³lɨ³ la³jɨ́³² hua³jueh³² ja¹ tsá² jmɨ́¹ zian² juú² Tiro jɨ³ juú² Sidón dúh¹, la³jmɨ́¹ má²lɨ³² nɨ́² ja¹ quián¹³ hnoh², hi³ jáun² má²hia³ jáun¹³ máh³ jmɨ́¹ má²ca³za³ tsú² jmɨ́¹ tsɨ́³, hi³ jmɨ́¹ má²ca³jmú³ tsú² lin¹ cun³quionh³ hi³ jmɨ́¹ quɨ́h²¹ tsú² jáun² tú²cho¹, jɨ³ hi³ jmɨ́¹ sén²¹ tsú² siáh³ jua² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Hi³ jáun² tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ hi³ má¹tsoh¹ hnoh² honh² má¹tɨ³ ñí¹ ra³tsɨ³² Dió³² héih³², la³ cun³ bíh¹ tsá² jmɨ́¹ zian² jáun² jmɨ́¹tin² já¹ juú² Tiro quionh³ juú² Sidón. ");
INSERT INTO csoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hi³ hnoh² siáh³ tsá² juú² Capernaum, ¿hí¹ ná¹lɨ́n²³ hnoh² hi³ cuá¹tánh¹ náh² hñu³mɨ³cuú²? Hnoh² dá² cuá¹tánh¹ la³ tɨ³ quiu³juóu³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","”Jáun² né³, hnoh² má¹ná¹, nɨ́¹juáh³ tsá² náɨ³² jáɨ¹³ quián¹³ hnoh², ja³bí¹ náɨ³² tsú² siáh³ jáɨ¹³ quion²¹ jná¹³; tɨ³la³ tsá² tiá² he³ jáɨ¹³ quián¹³ hnoh² má¹ná¹, ja³bí¹ jná¹³ siáh³ tiá² he³ tsú². Hi³ jáun² tsá² tiá² he³ hí³ jná¹³, ja³bí¹ tiá² hen³ tsú² siáh³ Tsá² ca³ze³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jmɨ́¹ cá¹jính²¹ jáun² tsá² hnaɨh³² nio² quiún³ tsɨ²¹ quian³ hí³ tɨ³ ñí¹con² Jesús, ca³la³ hi³ tsah³ lɨ́n³² tsú² ca³juáh³ la³ lá²: ―Hnú² Tɨ³², hí¹ ca³la³ tɨ³ jmɨ́²chí³ hláɨnh¹ máh³ má²tí³² héih³² hi³ jmu³² jnoh¹ cun³quionh³ héih³² quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jáun² Jesús ca³záɨh³ tsá² hí³: ―Ján³, ca³jɨen¹ jná¹³ *Satanás hi³ ca³tánh³ hñu³mɨ³cuú² la³jmɨ́¹ taɨ³² sɨ́² quioh²¹ miíh³². ");
INSERT INTO csoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jáun² sá¹nɨ́² jɨe³, má²ca³cué³ jná¹³ pí³ quián¹³ hnoh² hi³ lɨ́¹³ han¹³ hnoh² jáh³hláɨnh¹ jɨ³ hñú³ nɨ́² siáh³, hi³ lɨ́¹³ jmúh¹³ hnoh² hi³ tiá² quien² pí³ quioh²¹ tsá² hláɨnh¹, hi³ hí¹ cáun² tiá² hi³ lɨ́¹ quiunh²¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tɨ³la³ ha³ lɨ́² ma³hiún¹³ náh² honh² cun³ñí¹ hi³hliá² jmɨ́²chí³ hláɨnh¹ má²tí³² héih³² quián¹³ náh², tɨ³la³ ma³hiún¹³ náh² honh² cun³ñí¹ hi³hliá² má²tón³² hi³ jmáɨ² náh² ñí¹ sí² rón³² hñu³mɨ³cuú² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³jmú³ Jmɨ́²chí³ Chun¹ hi³ ma³hiún² lɨ́n³² Jesús tsɨ́³, hi³ ca³juáh³ la³ lá²: ―Hnú² Tia²¹, Tsá² lɨ́n³ nú² Juo¹³ tsá² zian² hñu³mɨ³cuú² jɨ³ tsá² zian² ñí¹ hué²¹ lá² nɨ́² siáh³, cué²³ jná¹³ tiá¹hmah¹ quí¹hliá² ca³hmáh¹ hnú² jú¹ tson², hi³ jáun² tiá² lɨ́¹³ há¹ ngɨ¹³ tsá² quia³lín³ jmɨ́¹ tsɨ́³, jɨ³ tsá² ñí² tsá² lieih²¹ nɨ́² siáh³; tɨ³la³ ñí¹con² tsá² tsɨ́¹ tsá² juɨ́³ bíh¹ ca³niah²¹ hnú² jú¹ tson² jáun². Ján³, quí¹ la³ jáun² jlánh¹ re² tɨ́³ honh² hnú² Tia²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","”Sá¹nɨ́² jɨe³ náh², jo³uón³² jná¹³ má²ca³chá³ Ñuh³² jná¹³ ca³la³ jɨ³lɨ³². Hnga² bíh¹ Dió³² cuóun³² hin² tsánh² Jon², hi³ hnga² bíh¹ Jon² tsú² ñi³² hi³ hin² tsánh² Jméi², hi³ lɨ³ua³ jan² tsá² hnió³ dí² ma³jnia² Jméi² ñí¹con² siáh³, lɨ³ cuóun³² bíh¹ tsú² Jméi² dí². ");
INSERT INTO csoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jáun² ñí¹ tɨ³ có³² ca³liéinh³² Jesús tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³: ―Jlánh¹ jmɨ́¹ ren² tsá² jɨ́e²³ la³ cun³ hi³ má²ná¹jɨ́eh³² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Quí¹ juo³ jná¹³ hnoh² la³ lá²: hi³ juóun³² tsá² ca³lɨn³ *tɨ³² jë¹ Dió³², jɨ³ tsá² ca³lɨn³ re²¹ hué³² lá² nɨ́², jmɨ́¹ hniá¹ jɨ́e³ la³ cun³ hi³ jɨ́eh³² hnoh² lá², tɨ³la³ tiá² ca³lɨ³ yáh³ jɨ́e³ tsú²; hi³ jmɨ́¹ hniá¹ siáh³ ne³ la³ cun³ hi³ naɨh³² hnoh² lá², tɨ³la³ tiá² ca³lɨ³ yáh³ ne³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jmɨ́¹ lɨ²¹ jáun² né³, jan² tɨ³² liei²¹ ca³ñí¹cá² ñí¹lian² Jesús, hi³ ca³juáh³ la³ lá²: ―Hnú² Tɨ³², ¿he³ bíh¹ hniáuh³² jmu¹ jná¹³, hi³ jáun² lɨ́¹³ lɨ³ zian² jná¹³ la³ cun³ jmɨ́¹hi³nio²? ");
INSERT INTO csoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―¿Ha³ lánh³ rón³² rá¹juáh³ ñí¹ liei²¹ dúh¹? ¿He³ bíh¹ hi³ má²ca³híh³ nú² ñí¹ Sí² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jáun² tɨ³² liei²¹ hí³ né³ ca³ngáɨ³, hi³ ca³juáh³: ―La³ lá² rá¹juáh³: “Ma³hno¹ Dió³² Juóuh³² ca³la³ jonh³ jmɨ́¹ honh², cun³quionh³ jmɨ́²chí³ quián¹³, jɨ³ la³jɨ́³² pí³ quián¹³ nú² nɨ́², jɨ³ la³jɨ́³² hi³ lɨ́n²³ hnú² nɨ́² siáh³; hi³ ma³hno¹ siáh³ tsá²mɨ³cuóun² renh² ca³la³ jmɨ́¹ hno³ nú² huen²”. ");
INSERT INTO csoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jáun² Jesús ca³ngáɨ³ siáh³: ―Jú¹ tson² bíh¹ hi³ má²lɨ́²juah²¹ hnú² nɨ́². Jmu³ hnú² la³ nɨ́², hi³ jáun² lɨ́¹³ zian² nú² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tɨ³la³ tɨ³² liei²¹ hí³ jmɨ́¹ hnió³ ren³ ñí¹, hi³ jáun² ca³záɨh³ Jesús la³ lá²: ―¿Hin² dá² tsá² hí³, tsá²mɨ³cuóun² renh² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jmɨ́¹jáun² ca³ngáɨ³ siáh³ Jesús la³ lá²: ―Jmɨ́¹ zian² jan² tsá² cuá²han³ já¹ juú² Jerusalén hi³ ngau³ tɨ³ juú² Jericó. Hú¹ juɨ³² jáun² né³ ca³quieh³ tsá² háɨn², hi³ ca³háɨn³ tsú² la³jɨ́³² hi³ quioh²¹ tsú², la³ má²quionh³ ha¹ tsú² nɨ́² siáh³. Ca³qui³ ca³pan³ tsú² tsá² hí³ ca³la³ ja³háɨn³ cun³ jún¹. ");
INSERT INTO csoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jmɨ́¹jáun² ca³nga² jan² mí²tsáu² có³² ñí¹ jáun²; tɨ³la³ jmɨ́¹ ca³jɨ́en³² tsú² jáun² tsá² rón³² hí³ hué³², jáun² cáun² ca³nga³ cú²tso² he² ñí¹ bíh¹ mí²tsáu² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Jmɨ́¹ lɨ²¹ jáun², ca³nga² siáh³ jan² tsá² *levita. Jmɨ́¹ ca³jɨ́en³² tsú² jáun² tsá² rón³² hí³, siáh³ bíh¹ siáh³ cáun² he² ñí¹ tsá² hí³ ca³nga³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tɨ³la³ jmɨ́¹ cá¹chó²¹ jan² tsá² hɨ́n¹³ tɨ³ Samaria ñí¹ rón²¹ jáun² tsá² hí³ né³, tsá² hí³ bíh¹ jlánh¹ ca³ja³ mií³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jáun² ñéi¹ tsú² tɨ³ ñí¹ rón²¹ jáun² tsá² hí³, jáun² ca³jñéi³ tsú² ca³lá² no¹ quionh³ mu² ráu³ mɨ³ uóun²jɨeh¹³ ñí¹ ca³cuɨ́h³ quioh²¹ tsú², hi³ jáun² ca³hñéi³² tsú² siáh³ quionh³ hná¹ hmɨh³². Jmɨ́¹ lɨ²¹ jáun² né³, ca³zion³ tsú² tsá² hí³ cu³hna²¹ jáh³ joh¹, jáun² ca³jón³² dí² tɨ³ ñí¹ zeh² cáun² hñú³ ñí¹ jnioh² tsáu²; hi³ jáun² ñí¹ jáun² ca³jmú³ tsú² hua³hí¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jmɨ́¹ cá¹jniá²¹ jáun² né³, tsá² hɨ́n¹³ hí³ tɨ³ Samaria ca³cué³ tun³ *cú¹tiáu² ñí¹con² tsá² hñú¹³ ñí¹ jáun², hi³ ca³záɨh³ dí² tsú² la³ lá²: “Jmu³ hnú² tiá³ hua³hí¹³ tsá²ñuh² lá², hi³ nɨ́¹juáh³ ca³cáɨn³ hliáun³ quɨe³ la³ cónh³ bíh¹ hi³ lɨ́²cué³ jná¹³ nɨ́², má¹hmah²¹ bíh¹ jná¹³ má¹cá²jính³² jná¹³ lá²”. ");
INSERT INTO csoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Hi³ jáun² Jesús ca³ngáɨ³ ñí¹con² tɨ³² liei²¹ hí³ la³ lá²: ―Cuɨ́¹ neh²¹, ¿hin² bíh¹ tsánh² tsá² gáun³ hí³ lɨ́n²³ hnú² hi³ lɨ́n³ tsá²mɨ³cuóun² raɨnh²¹ tsá² ca³cuɨ́nh³ hí³ hi³ ca³jmú³ jáun² tsá² háɨn²? ");
INSERT INTO csoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jáun² tɨ³² liei²¹ hí³ ca³juáh³: ―Tsá² ca³ja³ hí³ mií³ tsɨ́³ ñí¹con² tsá² hí³ bíh¹. Jáun² Jesús ca³záɨh³ tsú²: ―Cuánh² hnú², cuá²jmu³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jáun² Jesús ngau³ juɨ³² má²hún¹, hi³ ca³chó³² cáun² juú² míh¹. Jmɨ́¹ cá¹chó²¹ Jesús ñí¹ jáun², ca³he³ jan² tsá²mɨ³ jmáɨ² Marta. ");
INSERT INTO csoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jmɨ́¹ zian² jan² tsá²mɨ³ raɨnh²¹ Marta hí³ hi³ jmáɨ² Má²réi³. Jáun² Má²réi³ hí³ ca³cuá³ hué³² ta³ ñí¹ Jesús, hi³ ca³náɨ³² dí² jë¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Tɨ³la³ Marta hí³ jlánh¹ tiá³ siaun³² ca³jmú³ hua³jan²¹ má³², jáun² ca³ñí¹lienh¹³ Jesús, hi³ ca³juáh³: ―Hnú² Tɨ³², ¿tiá¹ lɨ́n²³ hnú² hi³ renh² jná¹³ nɨ́² zeh² jná¹³ huen² tán¹, hi³ jáun² jo³uón³² huen² bíh¹ jná¹³ má²ta³no¹ ca³la³ jɨ́³² ta²¹? Zéih³ hnú² tiá³ hi³ cuɨ́¹ ja³ma³hau³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tɨ³la³ Jesús ca³ngáɨ³: ―Hnú² Marta, jlánh¹ hliáun³ hi³ dí¹cháunh²³ chinh³² hnú², hi³ jlánh¹ hɨ³² honh² hnú² ta²¹ hi³ ñi³jmuh³². ");
INSERT INTO csoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tɨ³la³ cáun² tán¹ bíh¹ hi³ jlánh¹ quien² zia³². Má²réi³ lá² má²lɨ́²quiáh³² hi³ jlánh¹ bí¹ quien², hi³ jáun² hí¹ jan² yáh³ tiá² hin² lɨ́¹³ quin³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ca³chó³² cáun² jmáɨ¹ hi³ zia³² cáun² ñí¹ jmɨ́¹ cuá¹liéinh³² Jesús Dió³². Jmɨ́¹ má²lɨ³² jáun² né³, ca³juáh³ jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú² la³ lá²: ―Hnú² Tɨ³², ¿tiá¹ hɨ́eh¹³ hnú² jnoh¹ ha³ lánh³ rón³² hniáuh³² lienh¹ jnoh¹ Dió³², la³jmɨ́¹ ca³ma³tɨn² jáun² hla¹ Juan² tsá² jmɨ́¹ haɨn²¹ hí³ tɨ³ con²? ");
INSERT INTO csoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jáun² Jesús ca³juáh³ la³ lá²: ―Nɨ́¹ má¹ca³lienh¹ hnoh² Dió³², juáh¹³ hnoh² la³ lá²: Hnú² Tia²¹, Tsá² ñíh³ hnú² hñu³mɨ³cuú², cá² ñí¹ hi³ chu²¹ cuɨ́¹ ná¹chan¹ hi³ jmáɨ² hnú². Cuɨ́¹ chau²¹ bíh¹ jmáɨ¹ hi³ la³jɨ́n³² tsáu² tónh³² jo³cuonh² hnú². Cuɨ́¹ lɨ́¹³ bíh¹ ñí¹ hué²¹ lá² la³ cun³ hi³ hnáuh² hnú² jmúh¹³, la³jmɨ́¹ lɨ́³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cué¹ tiá³ má³² hi³ hniáuh³² quiú¹³ jnoh¹ cun³ jmá² cun³ jnia³². ");
INSERT INTO csoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Chin³² tiá³ honh² ca³tɨ²¹ tso³ hi³ má²lɨ́²jmú¹³ jnoh¹, la³jmɨ́¹ chin²³ jnoh¹ tsɨ́³ la³ cun³ hi³ má²ca³hliánh² tsáu² ñí¹con² jnoh¹. Ma³hau¹ tiá³ jnoh¹ hi³ tiá² ca³ tiá² lau³ jnoh¹ tsá² hláɨnh¹, liau¹ tiá³ jnoh¹ ñí¹con² pí³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jmɨ́¹jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―Jmú¹³ jáɨ¹³, hi³ hnú² zian² jan² há²mei²¹ joh², hi³ ta³ hua² né³ cuóh¹³ nú² hñú¹³ tsú² hi³ cuá¹zéih³ nú² la³ lá²: “Hnú² há²mei²¹ quiú¹³, jmu³ tiá³ hi³ chú³², cué¹ tiá³ hnɨ³² hí³ quiú¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","quí¹ jan² há²mei²¹ joh² jná¹³ hún¹ juɨ³² hi³ cun³ cuan³ hñu³² jná¹³, hi³ hí¹ cáun² yáh³ tiú²uú² hi³ zia³² hi³ jmɨ́¹ lɨ́¹³ jein²¹ jná¹³ ñí¹con² tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hi³ jáun² tsá² hí³ né³ nga³ la³ tɨ³ ñéih³, hi³ juáh³ la³ lá²: “Lɨ́²uú² ma³tsán¹³ tsɨn³² jná¹³, quí¹ má²chí¹jnaɨ³² bíh¹ ho³hñú¹³, má²rá²cuóun¹ bíh¹ jná¹³ quiúnh¹ tsá¹míh¹ jón²¹; ha³ tiú²uú² lɨ́¹³ yáh³ no¹ jná¹³ hi³ zia³² hi³ cué¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Hi³ jáun² juanh³² jná¹³, uá¹ jáun² la³ jáun² tiá² jmɨ́¹ ñí¹cué²¹ hnú² tsá² hí³ hi³ mɨh³², uá¹jinh¹ tsá² juónh³² hnú² re² quiúnh¹, tɨ³la³ cun³ñí¹ hi³ hnú² jlánh¹ hiú² mɨh³², hi³ jáun² nó³² bíh¹ tsú² hi³ cué³² la³jɨ́³² hi³ hnáuh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hi³ jáun² la³ lá² juanh³² jná¹³: Mɨ́¹ náh² ñí¹con² Dió³², hi³ jáun² hian³ náh². Hniauh² náh², hi³ jáun² chanh¹ náh². Hléh¹ náh² ho³hñú¹³, hi³ jáun² niá³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Quí¹ nɨ́¹juáh³ tsá² mɨ³² ñí¹con² tsú², hiáuh²³ bíh¹ tsú²; nɨ́¹juáh³ tsá² hnauh² choh²³ bíh¹; hi³ nɨ́¹juáh³ tsá² hleh³² ho³hñú¹³ né³, niá²³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”Hnoh², tsá² zian² jónh³², ¿hin² dá² tsánh² hnoh² tiá³ honh² náh² hi³ cueh¹ cá² máɨ³ quɨ́n¹ jónh³² nɨ́¹juáh³ hí¹miih²¹ bíh¹ la³ cuá¹mɨ³²? Ho³ nɨ́¹juáh³ cuá¹mɨ² jan² juo¹³, ¿hí¹ tiá³ honh² náh² hi³ cuen¹³ jan² jáh³hláɨnh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ho³ nɨ́¹juáh³ jónh³² náh² mɨ³² cá² máɨ³ mɨ³ jláɨ², ¿hí¹ lɨ́¹³ cuen¹³ náh² jan² hñú³? ");
INSERT INTO csoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Hi³ jáun² né³, nɨ́¹juáh³ tu³bí¹ hnoh² yáh³ tsá² tiá² chun¹ náh², tɨ́n² bí¹ náh² cuéh¹ hi³ chu²¹ ñí¹con² jónh³², hi³ jáun² tiá¹³ bíh¹ tiá³ tiá² cuen³ Jméi² dí² Tsá² cuá³ hñu³mɨ³cuú² Jmɨ́²chí³ Chun¹ ñí¹con² tsá² mɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ca³chó³² jmáɨ¹ hi³ ca³chin² Jesús jmɨ́²chí³ hláɨnh¹ jmɨ́¹ hún¹ hñu³ tsɨ́³ jan² tsá² tiá² jmɨ́¹ tɨ́n² hléh³². Jmɨ́¹ cuá¹han³ jáun² jmɨ́²chí³ hláɨnh¹ hí³ hñu³ tsɨ́³ tsú² né³, ca³lɨ³ hléh³². La³jɨ́n³² tsá² ca³jɨ́e³ hi³ jáun² ca³ja³cáun² lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tɨ³la³ ma³ jan² tsáu² né³ ca³juáh³: ―Tsá² nɨ́² dá² huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² cun³quionh³ pí³ quioh²¹ Beelzebú, tsá² chín¹ juo¹³ jmɨ́²chí³ hláɨnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hi³ ma³ jan² siáh³ tsá² hí³ jmɨ́¹ hnió³ ca³ lan³ Jesús, jáun² ca³mɨ́³ tsú² cáun² li²¹ hi³ lɨ́³ hua³jueh³² hi³ já³² tɨ³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Tɨ³la³ Jesús jmɨ́¹ dí¹ñi³² bíh¹ ha³ lánh³ jmɨ́¹ ná¹lɨ́n²³ tsá² hí³, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Nɨ́¹juáh³ zia³² hniéi² ja¹ cu³ nió³ má²tún² hmóu³² tsá² ná¹lɨ́n³ ta²¹, jáun² la³jɨ́n³² bíh¹ tsú² tsá²hín³. Ja³bí¹ la³ jáun² nɨ́¹juáh³ tsá² zia³² hniéi² hñú¹³, la³jɨ́n³² bíh¹ tsú² tsá²hín³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hi³ jáun² né³, sá¹jmɨ́¹ hi³ hnga² *Satanás jmu² hniéi² ñí¹con² tsá² haɨn²¹ tɨ³ con², jáun² né³, ha³ ya³ lánh³ rón³² lɨ́¹³ ma³hɨ́e² pí³ quioh²¹ tsú². Hnoh² juánh³ hi³ jná¹³ huen² jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu² cun³quionh³ pí³ quioh²¹ Beelzebú; ");
INSERT INTO csoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","tɨ³la³ sá¹ hi³ tson² la³ cun³ hi³ juáh³ hnoh² nɨ́² dúh¹, ¿hin² cun³quionh³ pí³ quioh²¹ huen³ tsá² haɨn²¹ tɨ³ con² hnoh² jmɨ́²chí³ hláɨnh¹ tiáunh¹ hñu³ tsɨ́³ tsáu²? Hi³ jáun² né³, cun³quionh³ ta²¹ hi³ jmu² tsá² haɨn²¹ tɨ³ con² bí¹ náh², má²lɨ́²lin¹ hi³ lɨ́¹ ná¹tsá²con² bí¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tɨ³la³ jná¹³ má¹ná¹, huen² ná¹ jmɨ́²chí³ hláɨnh¹ cun³quionh³ pí³ quioh²¹ Dió³² bíh¹; hi³ jáun² la³ nɨ́² né³, má²lɨ́²lin¹ hi³ jná¹³ bíh¹ Tsá² ca³hiáu³² Dió³² hi³ lɨ́n¹³ ná¹ Re²¹, Tsá² qui³ ná¹jan²³ náh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”Nɨ́¹juáh³ zian² jan² tsá² pin³ lɨ́n³², tsá² zia³² hliáun³ he³ cun³quionh³ jmu³ hniéi², tiá² zia³² yáh³ hi³ háɨnh¹³ ca³tɨ²¹ hi³ zia³² quioh²¹ tsú², nɨ́¹juáh³ hi³ hún¹ tsú² hua³jan²¹ hi³ jmu³ hniéi². ");
INSERT INTO csoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tɨ³la³ nɨ́¹juáh³ ja³ jan² tsá² tɨ³ jlánh¹ bíh¹ pin³ la³ cónh³ bíh¹ tsá² hí³, jáun² tsá² já³² hí³ bíh¹ má²láɨh¹³ hniéi², hi³ quin³ tsú² la³jɨ́³² hi³ jmɨ́¹ nióh²¹ tsá² hí³ hi³ jmu³ hniéi², má¹lɨ³² jáun² né³ má²tsóh³ tsú² ñí¹con² tsá² quionh³ la³ cun³ hi³ má²ca³joh¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”Hi³ jáun² né³, lɨ³ua³ jan² tsá² tiá² hen² tɨ³ con² jná¹³, tsá² la³ hí³ tɨ³ hau² bíh¹ jná¹³. Hi³ lɨ³ua³ jan² tsá² tiá² cha³² cu³lɨ²¹ quiúnh¹ jná¹³, tsá² la³ hí³ tɨ³ toh² tiú² jóh³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","”Nɨ́¹juáh³ má¹cuá²han³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², jáun² tsá²ngɨ́² ñí¹ quiéin², hi³ tsá²hniauh² ñí¹ lɨ́¹³ cuá³² tie³. Hi³ jáun² nɨ́¹juáh³ tiá² ca³choh¹³ né³, jáun² lɨ́n²³ la³ lá²: “Cuɨ́¹ ñih²¹ jná¹³ cú²jueh³² hñu³² ñí¹ cuá¹han³ ná¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jáun² nɨ́¹ má¹cá²chánh³² tsú² jáun² né³, chanh²¹ tsú² tsá² hí³ hi³ má²lɨ́n³ la³jmɨ́¹ lɨ́³ cáun² hñú³ hi³ má²rá²hiah¹³, jɨ³ hi³ má²dí¹lɨ́³ re² tɨn² lɨ́n³² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Má¹jáun² tsau³² hi³ tsá²quian³ cónh³í¹ quiaun³ jmɨ́²chí³ hi³ tɨ³ jlánh¹ bíh¹ hláɨnh¹ la³ cónh³ bíh¹ hnga². Hi³ jáun² la³jɨ́n³² jáun² bíh¹ taunh³² hñu³ tsɨ́³ tsá² hí³, hi³ jáun² tɨ³ jlánh¹ bíh¹ hlaɨh³ má²lɨ́²³ quioh²¹ tsá² hí³ nɨ́¹ má¹lɨ³² jáun², la³ cónh³ bíh¹ jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² Jesús jáɨ¹³ nɨ́², jáun² jan² tsá²mɨ³ jmɨ́¹ zenh² ja¹ tsá² ná¹ngɨh³² hí³ ca³hléh³ tiá³ hi³ ca³juáh³: ―Hénh³ ma³ jmɨ́¹ ren² tsá²mɨ³ tsá² ca³taunh² hnú² hñu³ héin¹ hñu³ tsɨ́³, tsá² ca³cué³ hnú² tiuh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―Tɨ³ jlánh¹ bíh¹ jmɨ́¹ ren² tsá² náɨ³² jáɨ¹³ quioh²¹ Dió³², hi³ nɨ́¹juáh³ má²tí³² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tá¹la³ ná¹juóun²³ jáun² tsá² tionh² hí³ né³, ca³juáh³ Jesús la³ lá²: ―Tsá² zian² jmáɨ¹ hi³ tiauh² dí² lá² jlánh¹ hláɨh¹, hi³ cáun² lɨ́¹ hiú² lɨ́¹ mɨ³² hi³ jnia³ li²¹; tɨ³la³ hí¹ cáun² yáh³ li²¹ tiá² lɨ́¹³ hiáuh³ tsú², jɨ́³²la³ li²¹ hi³ ca³jɨ́e³ jáun² tsáu² hi³ ca³tɨn¹ hla¹ Jonás bíh¹, tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Quí¹ hla¹ Jonás bíh¹ jmɨ́¹ lɨ́n³ cáun² li²¹ ñí¹con² tsá² jmɨ́¹ zian² juú² Nínive jmɨ́¹tin², ja³bí¹ la³ jáun² jná¹³ siáh³ Jon² tsá²mɨ³cuóun² lɨ́n³ ná¹ cáun² li²¹ ñí¹con² tsá² zian² né³². ");
INSERT INTO csoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ cán³ Dió³² jú¹ tson² ñí¹con² la³jɨ́n³² tsáu², jáun² hla¹ tsá²mɨ³ tsá² jmɨ́¹ chín¹ hué³² tɨ³ la³ quián³ nó³², hi³ chá³² tsáu¹³ tsá² zian² né³²; quí¹ hla¹ tsá²mɨ³ hí³ ja³ cáun² hué³² ñí¹ jlánh¹ bíh¹ uóunh³, hi³ cua³niéi³ jáɨ¹³ quioh²¹ hla¹ re²¹ Salomón, tsá² jlánh¹ jmɨ́¹ quia³lín³ hí³ jmɨ́¹ tsɨ́³. Ján³, tsá²mɨ³ hí³ chá³² tsáu¹³ tsá² zian² né³², quí¹hliá² ñí¹ lá² zenh² jan² Tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hla¹ re²¹ Salomón hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ja³bí¹ la³ jáun² nu³ tiánh³ siáh³ tsá² jmɨ́¹ zian² juú² Nínive nɨ́¹ má¹ca³can³ Dió³² jú¹ tson², hi³ ja³bí¹ tsá² Nínive hí³ chá³² siáh³ tso³ hi³ ca³tɨn¹ tsá² zian² né³², quí¹ hí³ dí² ca³ja³conh² bíh¹ tsɨ́³ tso³ quioh²¹ jmɨ́¹ ca³náɨ³² jáɨ¹³ quioh²¹ hla¹ Jonás. Ján³, chá³² tsá² hí³ tsáu¹³ tsá² zian² né³², quí¹ ñí¹ lá² zenh² jan² Tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hla¹ Jonás hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","”Nɨ́¹juáh³ tsá² héinh²³ sɨ́² hñú¹³, hí¹ jan² yáh³ tsá² hí³ tiá² zih³² sɨ́² jáun² ñí¹ ná¹conh¹, sa³jun³ taunh³² tsú² siáh³ hñu³ tsɨ́¹ cuo²; tɨ³la³ dí²chí³ tsú² ñí¹ lɨ́¹³ taɨ²¹ joh¹ tá¹ cáun² ñéih³ bíh¹, hi³ jáun² jniá³ jeinh²¹ lɨ³ua³ jan² tsá² hí³ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mɨ́¹máh¹ hnú² lɨ́³ la³jmɨ́¹ lɨ́³ cáun² sɨ́² quioh²¹ tá¹ jan² nú². Jáun² né³, nɨ́¹juáh³ chu²¹ mɨ́¹máh¹ hnú², jáun² zia³² joh¹ quián¹³ hnú² tá¹ jan² nú². Tɨ³la³ nɨ́¹juáh³ jlánh¹ la³ hláɨh¹ mɨ́¹máh¹ hnú² né³, jáun² tá¹ jan² bíh¹ hnú² zenh² já¹niéi². ");
INSERT INTO csoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jáun² jmu³ hnú² re² hua³hí¹³, hi³ jáun² tiá² lɨ́¹³ joh¹ quián¹³ nú² la³jmɨ́¹ lɨ́³ já¹niéi². ");
INSERT INTO csoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Quí¹ nɨ́¹juáh³ taɨ³² joh¹ quián¹³ hnú² tá¹ jan² nú², hi³ hí¹ cú¹pih²¹ já¹niéi² tiá² zia³², hi³ jáun² re² bíh¹ jniá³ jen¹³ hnú² la³jɨ́³², la³jmɨ́¹ lɨ́³ hi³ zia³² cáun² sɨ́² hi³ cue³² joh¹ ñí¹con² nú². ");
INSERT INTO csoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jmɨ́¹ cá¹táuh³ jáun² hi³ hleh³² Jesús, jáun² jan² tsá² *fariseo ca³te³ hi³ tsa³jmú³ dí² má³² hñú¹³ tsú². Jáun² Jesús ngau³ hi³ ca³hi³ ñéih³, hi³ ca³cuá³ ñí¹ mesa. ");
INSERT INTO csoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jmɨ́¹jáun² ca³ja³cáun² tsɨ́³ tsá² fariseo hí³ jmɨ́¹ ca³jɨ́e³ hi³ tiá² ca³liah³ Jesús cuo² la³ cun³ hi³ ná¹ngɨ²³ tsú² jmu² ñeh² bíh¹ hi³ jmu³ má³². ");
INSERT INTO csoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² hí³ la³ lá²: ―Hnoh², tsá² fariseos, jmáh³la³ tɨ³ coh³ bíh¹ cuá¹uon² jlánh¹ sɨ́² raɨnh³² hnoh², tɨ³la³ hñu³ honh² náh² né³, tiu³ canh² jmáh³la³ hi³ hlaɨh³ hi³ hó³², jɨ³ hi³ jlánh¹ tsɨ́nh² náh² hi³ quioh²¹ tsáu² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Hnoh² tsá² tiá² jáɨ¹³ ngɨ²³, ¿há¹ tiá² ñíh¹ hnoh² hi³ Tsá² ca³jmú³ tɨ³ coh³, ca³jmú³ siáh³ tɨ³ ñeh²? ");
INSERT INTO csoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Tɨ³la³ nɨ́¹juáh³ hi³ ja³² la³ tɨ³ hñu³ honh² náh² hi³ lɨ́¹ cueh³² ñí¹con² tsá² tiá² zia³² quioh²¹, hi³ jáun² la³ jáun² bíh¹ má²lɨ́³ cáun² hi³ jɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”¡Jlánh¹ juon²³ hnoh² tsá² fariseos! Quí¹ uá¹jinh¹ má²ná¹cueh³² hnoh² ñí¹con² Dió³² cáun² la³ cun³ quia³ hi³ zia³² quián¹³, hí¹ la³ tɨ³ zie² yáh³ quionh³ háu² ruda, jɨ³ ca³la³ jɨ́³² ñí¹ jonh² nɨ́² siáh³, tɨ³la³ má¹lɨ³² jáun² né³, tiá² ra³tsɨh³² yáh³ náh² héih³² cú²tso², hi³ sa³jun³ hno³ bíh¹ náh² Dió³². Tɨ³la³ jun³juáh¹³ hi³ cháh¹³ tɨ³ có³² la³ cun³ hi³ má²ná¹jmuh³² jáun² yáh³ náh² hi³ jmúh¹³ náh² hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”¡Jlánh¹ juon²³ hnoh² tsá² fariseos! Jlánh¹ hniá¹ náh² tianh¹³ ñí¹ jlánh¹ quien² hñu³ cuáh³², hi³ jlánh¹ hniá¹ náh² siáh³ hi³ tsáu² cuen³ Dió³² nɨ́¹ má¹ca³jenh² náh² tsáu² já¹ hmah²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”¡Jlánh¹ juon²³ hnoh²!, quí¹hliá² lɨ́n³ hnoh² la³jmɨ́¹ lɨ́³ jéin³lo¹ ñí¹ rá²hún¹ hla¹, ñí¹ tiú²uú² lin¹ jniá³, ñí¹ cáun² lɨ́¹ má²há² má²ngaɨ³² tsáu² ñí¹ quioh²¹ ta³ tiá² ñi³². ");
INSERT INTO csoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jáun² né³, jan² tɨ³² liei²¹ ca³záɨh³ Jesús: ―Hnú² Tɨ³², jɨ³ jnoh¹ bíh¹ má²je²³ nú² siáh³ cun³quionh³ jáɨ¹³ hi³ má²lɨ́²juah²¹ nú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jáun² Jesús ca³juáh³ siáh³: ―Ja³bí¹ hnoh² siáh³ tɨ³² liei²¹, ¡jlánh¹ juon²³ náh²! Quí¹ hnoh² jlánh¹ jmuh³² héih³² huáh² tsɨ́³ ñí¹con² tsáu², ca³la³ hí¹ jan² tsáu² tiá² tióh³² ma³tí³², hi³ má¹lɨ³² jáun² né³, hí¹juáh³ hmóu³² náh² tiá² ma³tih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”¡Juon²³ hnoh²!, quí¹hliá² jmóuh¹ náh² re² jéin³lo¹ ñí¹ ná¹hón²¹ tsá² ca³lɨn³ hí³ tɨ³² jë¹ Dió³², tsá² ca³jngɨh³ hí³ dí²hioh³ ñú²deh³ hmóu³² náh² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Hi³ jáun² má²lin¹ hi³ la³ ná¹tiáunh¹ náh² cá²honh¹ quiúnh¹ náh² dí²hioh³ ñú²deh³, quí¹ tsá² hí³ bíh¹ ca³jngɨh³ tsá² lɨn³ hí³ tɨ³² jë¹ Dió³² jmɨ́¹tin², hi³ hnoh² né³ lɨ́¹ ná¹jmóuh¹ náh² jéin³lo¹ ñí¹ ná¹hón²¹ hla¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","”Hi³ jáun² Dió³², Tsá² jlánh¹ re² cuá¹ñi³², ca³juáh³: “Zein²¹ jná¹³ tɨ³² jë² ná¹, jɨ³ *tɨ³² tsá² quian³² jë² ná¹ nɨ́² siáh³ ñí¹con² tsá² hí³, jáun² ma³ jan² tsá² zein²¹ jná¹³ hí³ hɨ³ tsa¹ tsáu², hí¹ la³ tɨ³ jngɨh³ tsú² siáh³ ma³ jan² tsá² hí³”. ");
INSERT INTO csoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jáun² né³, tsá² zian² né³² bíh¹ tá¹can¹ jmɨ́²hán¹ ca³la³ jɨ³lɨn² tɨ³² jë¹ Dió³², tsá² ca³ma³tsan² tsú² hí³ jmɨ́¹tin² la³ cun³ jmɨ́¹ lɨ²¹ hngá¹máh³ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ján³, tsá² zian² né³² tá¹can¹ jmɨ́²hán¹ tsá² hí³, hla¹ Abel tín² la³ñí¹, ca³la³ ñí¹ ca³jngɨh³ tsú² siáh³ hla¹ Zacarías ja¹ quioh²¹ ñí¹hiú¹³ quionh³ ñí¹ jlánh¹ bíh¹ hɨ́en¹ quioh²¹ cuáh³² chín¹. ");
INSERT INTO csoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”¡Jlánh¹ juon²³ hnoh² tɨ³² liei²¹!, quí¹hliá² ca³hmáh¹ hnoh² jú¹ tson² hi³ jmɨ́¹ lɨ³ liáun³ tsáu². Hí¹ hmóu³² yáh³ hnoh² tiá² hnáuh² táunh¹³ ta²¹ jú¹ tson² jáun², sa³jun³ cueh³² bíh¹ náh² siáh³ tsá² siánh³ jáɨ¹³ hi³ lɨ́¹³ tónh³² ta²¹, uá¹jinh¹ zian² tsá² jmɨ́¹ hnió³ ne³. ");
INSERT INTO csoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, cua³han³ ñí¹ jáun². Jáun² la³jɨ́n³² tɨ³² liei²¹ hí³ né³, quionh³ tsá² fariseos ca³míh³ lɨ́n³² tsɨ́³. Jáun² hliáun³ lɨ́n³² jáɨ¹³ ca³ca³ ca³lan³ dí² Jesús, ");
INSERT INTO csoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","hi³ ca³can³ tsú² re² lɨ́n³² hua³hí¹³ jáɨ¹³ hi³ hleh³² Jesús, nɨ́¹juáh³ ca³náɨ³² tsú² cáun² jáɨ¹³ hi³ lɨ³ lɨ́¹³ chá³² tsú² tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tá¹la³ jáun² né³, ca³la³ juóun³² mei²¹ cu³tí³ tsáu² ca³ngɨh³² ñí¹ jáun², ca³la³ ná¹cuú² ná¹jaɨn³² tiá³ bíh¹ tsú² lɨ³. Jáun² Jesús ca³hléh³ tín² ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³ la³ lá²: ―Hua³hín¹³ náh² jmu³ ca³tɨ²¹ tie³ quioh²¹ tsá² *fariseos. Jáɨ¹³ “tie³” nɨ́² hnió³ juáh³: tsá² lɨ́n³ la³ cá¹ la³ jéinh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Quí¹ lɨ³ua³ cáun² hi³ jlɨ́²³ tsú², chau³² bíh¹ jmáɨ¹ hi³ jñéih²³; hi³ lɨ³ua³ cáun² hi³ ná¹hmá¹ né³, chau³² bíh¹ jmáɨ¹ hi³ lɨ́²jnia² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Jáun² la³jɨ́³² hi³ má²ca³juah²¹ hnoh² hñu³niéi², chau²¹ jmáɨ¹ lɨ³jnia² bíh¹ jáɨ¹³ jáun². Ja³bí¹ la³ jáun², lɨ³ua³ cáun² hi³ má²ca³juah²¹ náh² ñí¹ ná¹conh¹, chau²¹ bíh¹ jmáɨ¹ hi³ chá³² tsú² jáɨ¹³ jáun² ca³la³ hi³ tsa³di³chín³² tsú² tsáɨh³ hñú³ hi³ chá³² ca³la³ hi³ chi²¹ tiú² mah¹ tiú² jan³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","”Hnoh², tsá² re² juóh³² dí² quiúnh¹, juanh²¹ jná¹³ ñí¹con² hnoh² jáɨ¹³ lá²: Ha³ lɨ́² juenh³ náh² tsá² jngɨh² jmáh³la³ ngú³, hi³ nɨ́¹ má¹lɨ³² jáun², tiú²uú² zia³² hí¹ cáun² yáh³ hi³ siáh³ hi³ lɨ́¹³ jmu³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tɨ³la³ jná¹³ juanh²¹ hi³ hin² ñí¹con² hniáuh³² jmúh¹³ hnoh² juénh²: juenh³ náh² ñí¹con² Tsá² zia³² pí³ quioh²¹ hi³ lɨ́¹³ jngah³, hi³ má¹lɨ³² jáun² né³ lɨ́¹³ ze³ siáh³ quiu³juóu³². Ñí¹con² Tsá² hí³ bíh¹ hniáuh³² jmúh¹³ hnoh² juénh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”¿Há¹ tiá² cuen² tsú² hñá³ tan³² pih²¹ la³ cun³ tun³ héih³² quɨe³ dúh¹? Tɨ³la³ cu³ jáun² tiá² tsá²có³ yáh³ tsɨ́³ Dió³² hi³ ca³tɨn¹ jáh³ pih²¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jáun² hnoh² né³, hí¹ ca³la³ tɨ³ jñú² chinh³² yáh³ hnoh² ná¹hɨ¹³ siáh³ ma³ quin³² ma³ cá² máɨh³². Ha³ lɨ́² juenh³ náh², quí¹ tɨ³ jlánh¹ bíh¹ quien² hnoh² la³ cónh³ bíh¹ tan³² ná¹juóun²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","”Juanh³² jná¹³ siáh³ jáɨ¹³ lá²: Nɨ́¹juáh³ zian² tsá² ma³quien² jná¹³ ñí¹con² tsáu², ja³bí¹ jná¹³ siáh³ Jon² tsá²mɨ³cuóun², má¹quien¹³ ná¹ tsú² ñí¹con² tsá²cuú² tsá²ta³ Dió³²; ");
INSERT INTO csoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","tɨ³la³ lɨ³ua³ jan² tsá² tiá² hnió³ ma³quien² jná¹³ ñí¹con² tsáu² né³, ja³bí¹ jná¹³ siáh³ tiá² má¹quien¹³ tsá² la³ hí³ ñí¹con² tsá²cuú² tsá²ta³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","”Lɨ³ua³ jan² tsá² hleh³² jú¹ hlah³ hi³ ca³tɨn¹ jná¹³ Jon² tsá²mɨ³cuóun², zia³² bíh¹ uu³i³tso³; tɨ³la³ nɨ́¹juáh³ tsá² tú² hión³² Jmɨ́²chí³ Chun¹ má¹ná¹, cu³tí³ tiá² zia³² bíh¹ uu³i³tso³ quioh²¹ tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”Nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ jau³ tsú² hnoh² hi³ nga³ tsú² jáɨ¹³ ñí¹con² hnoh² hñu³ cuáh³², ho³lá²dá² ñí¹ta²¹, ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh² hi³ hín² jáɨ¹³ ngáɨh¹ náh², ho³ he³ lánh³ juáh¹³ náh²; ");
INSERT INTO csoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","quí¹ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ hniáuh³² hléh¹³ hnoh², má¹jáun² bíh¹ má²hɨ́e³² Jmɨ́²chí³ Chun¹ ha³ lánh³ hniáuh³² hléh¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jáun² né³, jan² tsá² zenh² ja¹ tsá² ná¹ngɨh³² hí³ ca³juáh³: ―Hnú² Tɨ³², juoh¹ hnú² tiá³ renh² jná¹³ hi³ cué³² tsú² la³ cun³ hi³ ca³tɨn¹ jná¹³, hi³ jmɨ́¹ quioh²¹ jméi² mí¹ziú¹³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―¿Hin² tsánh² ca³hiáu³² jná¹³ hi³ lɨ́n¹³ ná¹ jue²¹, ho³ hi³ lɨ́n¹³ jná¹³ tsá² tsóh²³ hi³ jmɨ́¹ quioh²¹ ñeh² mí²ziúh² hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jáun² jmɨ́¹jáun² ca³záɨh³ dí² siáh³ la³jɨ́n³² tsá² hí³ la³ lá²: ―Hniáuh³² jmúh¹³ náh² re² lɨ́n³² hua³hí¹³ hi³ tiá² lɨ́¹ jmúh¹³ náh² hniá¹ hi³ zia³² ñí¹ hué²¹ lá², quí¹ jun³juáh¹³ cun³quionh³ hi³hliá² hliáun³ hi³ zioh² jáun² yáh³ tsú² lɨ́¹³ zian² re² tɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jáun² ca³jmú³ tsú² siáh³ cáun² jáɨ¹³ hi³ juáh³ la³ lá²: ―Jmɨ́¹ zian² jan² tsá² hánh³. Tsá² hí³ ca³loh² hliáun³ lɨ́n³² ñí¹náɨ² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jáun² tsá² hí³ ca³lɨ́n¹³: “¿He³ bíh¹ jmu¹ jná¹³? Já² tiú²uú² zia³² yáh³ ñí¹ lɨ́¹³ hmá¹³ jná¹³ la³jɨ́³² hi³ ca³láu² lá² quion²¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jmɨ́¹jáun² ca³liéinh³² tsú² jmɨ́¹ tsɨ́³ hnga²: “Né³² má²ca³cháunh¹³ tsɨn³² jná¹³ ha³ lánh³ rón³² jmu¹. Cu³tsa³² cuɨ́¹ tsunh²¹ jná¹³ cú²jueh³² hñu³cuɨ́³ míh¹ táun³ nɨ́², hi³ jmu¹ jná¹³ hi³ jlánh¹ bíh¹ cáh¹; hi³ jáun² ñí¹ jáun² hmá¹³ jná¹³ la³jɨ́³² hi³ ca³lo², la³ má²quionh³ hi³ siáh³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɨ́¹ má¹lɨ³² jáun² né³, hlɨ́¹ lienh¹ jná¹³ jmɨ́¹ tsɨn³², hi³ juo¹³ jná¹³ la³ lá²: Hliáun³ lɨ́n³² bíh¹ má²zia³² hi³ lɨ́¹³ ma³hɨ́e² hliáun³ mii² quiú¹³ dí². Jáun² né³² né³, cuɨ́¹ zian² dí² tie³. Cuɨ́¹ cú¹ cuɨ́¹ hnáɨh¹³ dí² quiú¹³, hi³ cuɨ́¹ zian² dí² cáun² hi³ re² hi³ tɨn²”. ");
INSERT INTO csoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tɨ³la³ Dió³² ca³záɨ³ tsá² hí³ la³ lá²: “Hnú², tsá² tiá² jáɨ¹³ ngɨ²³, já¹niéi² lá² jɨ́enh¹ hnú² jmɨ́²chí³ quián¹³ ñí¹con² jná¹³. Hi³ jáun² la³jɨ́³² hi³ má²ná¹hmá¹ nɨ́² quián¹³ hnú², ¿hin² dá² tsánh² lɨ³ quioh²¹?” ");
INSERT INTO csoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","La³ jáun² bíh¹ quiunh³² tsá² hánh³, tsá² hma³² ñí¹con² hnga² hi³ quioh²¹. Tsá² tia³mii² bíh¹ tsá² la³ hí³ ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jmɨ́¹ lɨ²¹ jáun² né³, ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con²: ―Juo³ jná¹³ hnoh²: Ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh² ha³ lánh³ rón³² lɨ́¹³ zian² náh², ca³tɨ²¹ ha³ jinh¹ já³² má³² hi³ cúh¹³ náh², jɨ³ ha³ jinh¹ já³² hmɨh³² hi³ quɨ́h¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Quí¹ jmɨ́²chí³ quioh²¹ bíh¹ tsú² hi³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ má³²; hi³ ngú³ quioh²¹ tsú² nɨ́² siáh³ tɨ³ jlánh¹ quien² la³ cónh³ bíh¹ ha¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sá¹nɨ́² jɨe³ ha³ lánh³ zian² quiú¹liáh². Jáh³ hí³ tiá² lin¹ hi³ jñi³² hí¹ cáun² yáh³, sa³jun³ zia³² bíh¹ hi³ loh², sa³jun³ zeh² hñu³cuɨ́³ quioh²¹; tɨ³la³ cun³ jáun² zia³² bíh¹ má³² hi³ cue³² Dió³² cúh² jáh³. ¡Tɨ³la³ hnoh² má¹ná¹, tɨ³ jlánh¹ bíh¹ quien² náh² la³ cónh³ bíh¹ tan³²! ");
INSERT INTO csoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Hin² yáh³ hnoh² tɨn² jmúh¹³ hi³ cuóun¹³ cónh³í¹ cá² lɨ́², uá¹jinh¹ hen² lɨ́n³² honh² náh² hi³ cuóun¹³ náh²? ");
INSERT INTO csoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Hi³ jáun² né³, nɨ́¹juáh³ cáun² hi³ pih²¹ la³ nɨ́² bíh¹ tiá² la³ tɨn² náh² jmúh¹³, hi³ jáun² ¿he³ láɨh³² sa³ hɨ³² lɨ́n³² honh² náh² ca³tɨ²¹ la³jɨ́³² hi³ ñí¹ hná¹ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”Sá¹nɨ́² jɨe³ náh² ha³ lánh³ rón³² cuóun² lí¹³. Lí¹³ nɨ́² tiá² lin¹ zeh³² yáh³ jáu², hi³ sa³jun³ ta³² siáh³ tá³, tɨ³la³ cun³ jáun² ta³bí¹ hla¹ re²¹ Salomón yáh³ tiá² chú³² jmɨ́¹ jniá³ la³jmɨ́¹ jniá³ lí¹³ nɨ́², uá¹jinh¹ jmɨ́¹ zioh² lɨ́n³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hi³ jáun² né³, nɨ́¹juáh³ Dió³² jmu² hi³ ca³la³ chú³² lɨ́n³² jniá³ náɨ², cáun² hi³ tsɨ²¹ nɨ́² ñí¹ náɨ² né³², hi³ jáun² tsa³háu² má²jɨ́n³² bíh¹ tsú² tɨ³ ñeh² cáun² pɨeh¹ nɨ́¹ má¹ca³lɨ³ quiéin²; jáun² nɨ́¹juáh³ ta³bí¹ náɨ² yáh³ jmu² Dió³² hi³ chú³² jniá³, ¡cónh³ bíh¹ tiá² jmu³ Dió³² hi³ zia³² hanh² hnoh², hnoh² tsá² cáun² lɨ́¹ hɨ³² honh² náh²! ");
INSERT INTO csoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Hi³ jáun² ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh² hi³ hnáuh¹³ náh² hi³ cúh¹³, sa³ jun³ hi³ húh¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Quí¹ la³jɨ́n³² tsá² zian² ñí¹ hué²¹ lá² ná¹hɨ³² tsɨ́³ ca³tɨ²¹ hi³ nɨ́²; tɨ³la³ hnoh² má¹ná¹, zian² bíh¹ jan² Ñeh² náh², Tsá² cuá¹ñi³² la³jɨ́³² hi³ lɨ³hniauh²³ quián¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ñí¹ jɨ́²¹la³ ti³ chan¹³ náh² hmóu³² jo³cuo² Dió³² bíh¹, hi³ má¹tih²¹ náh² re² ñí¹con² tsú², hi³ jáun² bíh¹ hián¹³ náh² ca³la³ jɨ³lɨ³² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","”Hnoh², tsá² lɨ́n³ náh² la³juah²¹ dúh¹ cu³ nió³ pih²¹ *já¹ziáh², ha³ lɨ́² juenh³ náh², quí¹ hiún² lɨ́n³² bíh¹ tsɨ́³ Ñeh² náh² cué³² jáɨ¹³ hi³ cuá¹tánh¹ náh² ñí¹ cuá¹quien² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Hnáɨ¹ náh² hi³ zia³² quián¹³, hi³ lɨ́¹ cueh¹ náh² tsá² lɨ́²hniáuh³² ñí¹con². Nɨ́¹juáh³ hi³ jmúh¹³ náh² la³ jáun², hi³ jáun² la³ jáun² má²ná¹jmuh³² náh² cáun² tuh³² hi³ tiá² chau²¹ jmáɨ¹ lɨ³yenh³, hi³ jáun² lɨ³ zian² náh² hliáun³ hñu³mɨ³cuú², cáun² hi³ tiá² chau²¹ jmáɨ¹ tsa³hín³. Ñí¹ jáun² tiá² lɨ́¹³ hí³ háɨn², sa³jun³ mí¹cháu² lɨ́¹³ ma³tsa² hi³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Quí¹ nɨ́¹juáh³ ñí¹ nio¹ hi³ quián¹³ náh², ñí¹ jáun² bíh¹ uá²jaɨ³² cuá³ jmɨ́²chí³ quián¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","”Hniáuh³² tiáunh¹ náh² hua³jan²¹, hi³ chí¹hún¹ sɨ́² quián¹³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tianh³ náh² hua³jan²¹ la³jmɨ́¹ tionh¹ tsá² ná¹hé² ná¹jan² juo¹³. Hi³ jáun² nɨ́¹ má¹cá²jính³² jáun² tsá² hí³ ñí¹ lɨ́¹jmú³ tsáu² jmáɨ¹ hi³ ca³jenh² cuo², la³juɨ³² niá³² bíh¹ tsú² ho³hñú¹³ nɨ́¹ má¹ca³póh³ tsá² hí³ cuo². ");
INSERT INTO csoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jlánh¹ chú³² quioh²¹ tsá² quian²¹ tsú² hí³, nɨ́¹juáh³ hi³ tionh² tsú² ná¹ñí¹ nɨ́¹ má¹cuanh³² jáun² juo¹³. Jú¹ tson² juo³ jná¹³ hnoh², hi³ juo¹³ tsú² hí³ hah¹³ hmɨh³² ta³ ñí¹, hi³ cué³² jáɨ¹³ hi³ tsá² quian²¹ tsú² hí³ lɨ́¹³ tiánh³² ñí¹ mesa. Hi³ jáun² nɨ́¹ má¹ta³tonh¹ tsú² jáun² ñí¹ mesa né³, hnga² juo¹³ tsú² ma³tau³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hi³ jáun² nɨ́¹juáh³ cuanh³ tsá² hí³ ta³ hua², ho³lá²dá² má²já²jnia², jáun² né³, jlánh¹ chú³² quioh²¹ tsá² quian²¹ hí³, nɨ́¹juáh³ la³ ná¹ñí¹ bíh¹ nɨ́¹ má¹cuanh³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Hniáuh³² lɨ³ ñíh¹³ náh² re² jáɨ¹³ lá² siáh³: Sá¹jmɨ́¹ hi³ ñi³² tsá²hñú¹³ hín² la³nio¹ já³² tsá² háɨn², jáun² tiá² jmɨ́¹ cué²¹ yáh³ tsú² jáɨ¹³ hi³ hí³ háɨn² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jáun² hnoh² né³, hniáuh³² ná¹tiáunh¹ náh² hua³jan²¹, quí¹ nɨ́¹juáh³ jmáɨ¹ hi³ ná¹lɨ́n²³ hnoh² hi³ tiá² má²jáunh¹³ jná¹³ Jon² tsá²mɨ³cuóun², tɨ³la³ jmáɨ¹ jáun² bíh¹ ti³tsóh³ cuánh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́² né³, ca³ngáɨ³ Pé¹ ñí¹con² tsú²: ―Hnú² Tɨ³², ¿hí¹ ca³tɨn¹ jmáh³la³ jnoh¹ jáɨ¹³ hi³ má²lɨ́²jmuh³ hnú² nɨ́², ho³ hi³ ca³tɨn¹ ca³la³ jɨ́n³² tsáu² uá¹? ");
INSERT INTO csoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jáun² Tɨ³² Juo¹³ dí² ca³juáh³: ―Nɨ́¹juáh³ zian² jan² tsá² quian²¹ chun¹, tsá² jlánh¹ quia³lín³ jmɨ́¹ tsɨ́³, hi³ jáun² juo¹³ tsú² chan³ la³jɨ́n³² tsá² quian²¹ ñí¹ hná¹ jáun² jo³cuo² hí³ dí² hi³ jmu³ dí² héih³² ñí¹con² tsá² hí³, jɨ³ hi³ jmu³ dí² siáh³ héih³² ha³ cónh³ má³² lɨ́¹³ cuh³ tsú², jɨ³ hín² la³nió¹ lɨ́¹³ jmu³ tsú² má³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jlánh¹ jmɨ́¹ ren² tsá² quian²¹ la³ hí³ nɨ́¹juáh³ hi³ cuá¹má²tí³² tsú² héih³² quioh²¹ juo¹³ nɨ́¹ má¹cuanh³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jú¹ tson² juo³ jná¹³ hnoh², hi³ juo¹³ tsá² hí³ má²chá³² la³jɨ́³² hi³ zioh² jo³cuo² tsú², hi³ jáun² tɨ³ má²zó³² bíh¹ tá¹³ tsú² lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tɨ³la³ nɨ́¹juáh³ tsá² hí³ la³ ca³lɨ́n¹³ hi³ tiá² má²jáunh³ yáh³ tia³juɨ³² juo¹³, hi³ jáun² cuá¹quí² cuá¹quiunh² tsá²mɨ³ tsá²ñuh², tsá² quian²¹ ñí¹ hná¹ jáun², jɨ³ hi³ cuá¹cú² cuá¹hɨ́nh²³ tsú² siáh³ ca³la³ ñí¹ ca³lɨ³ hen²; ");
INSERT INTO csoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jáun² juo¹³ tsú² né³, cuánh³² cáun² jmáɨ¹ hi³ tiá² cuá¹jan²¹ bíh¹, cáun² o¹rá¹ hi³ tiá² ñi³² tsú² siáh³. Hi³ jáun² má¹jáun² ma³tson¹³ tsú² tsá² hí³ chí¹nga² cu³tí¹³, hi³ jáun² má¹lɨ³² jáun² zen³ tsú² ñí¹ ca³tɨ²¹ tsa³táunh¹ tsá² tiá² nieh³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”Quí¹ nɨ́¹juáh³ jan² tsá² quian²¹ ñi³² héih³² quioh²¹ juo¹³, tɨ³la³ tiá² jmu² yáh³ tsú² jan²¹, sa³jun³ má²tí³² bíh¹ tsú², jáun² tsá² quian²¹ la³ hí³ quiu³ pan³ tsú² hliáun³ tsɨ³². ");
INSERT INTO csoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Tɨ³la³ nɨ́¹juáh³ zian² tsá² quian²¹, tsá² tiá² re² jmɨ́¹ ñi³² héih³² quioh²¹ juo¹³, hi³ jáun² ca³jmú³ cáun² hi³ hlaɨh³, cun³ jáun² ca³tɨn¹ bíh¹ tsú² tsa³pán¹, tɨ³la³ míh² bíh¹ ca³lá² pan³ tsú². Nɨ́¹juáh³ tsá² ca³hiauh³ hliáun³, jáun² né³, tsáu² cáun² má²ná¹jan³² hi³ hliáun³ bíh¹ hi³ jmu³ tsá² hí³; hi³ nɨ́¹juáh³ jan² tsá² ca³ta³no¹ hliáun³ jo³cuo² né³, jáun² hliáun³ bíh¹ hi³ má²máɨ³² tsú² ñí¹con² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","”Má²cuan² jná¹³ ñí¹ hué²¹ lá² hi³ to¹ ná¹ sɨ́² huáh² tsɨ́³ hi³ ca³tɨn¹ la³jɨ́n³² tsá² zian² tá¹ cáun² hngá¹máh³; hi³ jlánh¹ jmɨ́¹ hiún² tsɨn³² jná¹³ sá¹ hi³ má²ná¹hún¹ ta³né³² dúh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ca³tɨn¹ jná¹³ zón³² siáh³ cónh³ jmáɨ² la³ siáh³, hi³ jlánh¹ tiá² niau³² tie³ tsɨn³² jná¹³ ca³la³ ñí¹ chau²¹ jmáɨ¹ hi³ lɨ³tí³ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Hí¹ ná¹lɨ́n²³ hnoh² hi³ cuan³ jná¹³ hi³ jmu¹ hi³ niau²¹ tie³ ñí¹ hué²¹ lá²? ¡Tiá² jáun² yáh³! Cuan³ jná¹³ hi³ quion¹ hniéi² bíh¹, hi³ tiú²uú² tiánh³² tsú² cá²hon³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Quí¹ ta³né³², jɨ³ jmɨ́¹tsú² jmɨ́¹ja³², má²zia³² bíh¹ hniéi² ja¹ hmóu³² tsá² hñú¹³. Jáun² né³, nɨ́¹juáh³ cáun² hñú³ ñí¹ tionh² tsú² hñá³, tsáun³ bíh¹ tsú² lɨ́¹³, gáun³ tsá² hí³ hon² gon³ raɨnh²¹, hi³ jáun² gon³ né³ lɨ³hon² gáun³ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tsá²ñuh² jmu³ ná¹háun³ quionh³ tsá²ñuh² jon², tsá²mɨ³ siáh³ jmu³ ná¹háun³ quionh³ tsá²mɨ³ jon², jɨ³ tsá¹míh¹ siáh³ jmu³ ná¹háun³ quionh³ jméi² mí¹ziú¹³. Ja³bí¹ la³ jáun² tsá²mɨ³ má²lieih²¹ jmu³ ná¹háun³ quionh³ ló³², hi³ tsá¹máɨ¹³ né³, jmu³ siáh³ ná¹háun³ quionh³ mɨ³ziú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² ná¹ngɨh³² hí³ la³ lá²: ―Hnoh², nɨ́¹juáh³ jmɨ́¹ jɨ́eh³² náh² hi³ má²tioh¹³ jnie² tɨ³ ñí¹ tá²tsɨ²¹ hiú², jáun² juáh²³ hnoh²: “Jmɨ́³ bíh¹ má²ha³”, hi³ tson² bíh¹ la³ jáun² lɨ́²³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hi³ nɨ́¹juáh³ jmɨ́¹ ja³² chí³ tɨ³ quián³ né³, hi³ jáun² juáh²³ hnoh²: “Má²jniau¹³ bíh¹ hiú²”; hi³ tson² bíh¹ la³ jáun² lɨ́²³. ");
INSERT INTO csoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Hnoh², tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹! Já² tɨn² bíh¹ hnoh² chíh¹ jáɨ¹³ nɨ́¹juáh³ nɨ́¹ má¹lɨ́²jɨeh³ náh² chi³cuú² jɨ³ tɨ³ hué³² nɨ́². Jáun² né³, ¿he³ láɨh³² sa³ tiá² ñíh¹ yáh³ hnoh² hi³ hín² jmáɨh¹ tiauh² dí² lá² ta³né³²? ");
INSERT INTO csoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","”¿He³ láɨh³² tiá² ma³réh¹³ náh² tso³ quián¹³ ja¹ hmóu²¹ náh²? ");
INSERT INTO csoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nɨ́¹juáh³ zian² tsá² ca³hna³ hnú², hi³ jáun² má²jau³ tsú² hnú² tɨ³ ñí¹con² jue²¹, jáun² jmu³ pí³ hi³ tsán¹³ hniéi² quián¹³ tá¹la³ hí¹cua³táunh¹ náh² jáun² hú¹ juɨ³². Hi³ jáun² tiú²uú² tsa³jau² tsú² ta³ ñí¹ tsá²tan²¹, quí¹ nɨ́¹ ca³cue³ hnú² tsá²tan²¹ tsá² tú²jáɨ¹³; hi³ jáun² tsá² tú²jáɨ¹³ hí³ má²tsa³tiaunh² hnú² hñu³mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Juanh³² jná¹³, tiá² cáun² lɨ́¹ liáun³ yáh³ hnú²; ca³la³ tɨ³ nɨ́¹ má¹ca³ma³hmah²¹ hnú² tá¹ jɨ³lɨ³² máh³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hi³ jáun² ma³ jan² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³chá³ ñí¹con² Jesús, hi³ Pilato néh¹ má²ca³jngɨh³ ma³ jan² tsá² hɨ́n¹³ tɨ³ Galilea, tsá² jmɨ́¹ ná¹jngɨh² jáh³ ñí¹con² Dió³²; hi³ jáun² jmɨ² quioh²¹ hmóu³² tsú² ca³lɨ³ ná¹jan² cun³quionh³ jmɨ́¹³ jáh³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―¿Hí¹ ná¹lɨ́n²³ hnoh² hi³ tsá² má²cá²tsan³ hí³ jlánh¹ bíh¹ jmɨ́¹ ná¹ren² tso³ la³ cónh³ bíh¹ la³jɨ́n³² tsá² hɨ́n¹³ hí³ tɨ³ Galilea, hi³ jáun² la³ jáun² ca³quiúnh³²? ");
INSERT INTO csoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jná¹³ juanh³² hi³ tiá² tson² yáh³ hi³ ná¹lɨ́n²³ hnoh² nɨ́². Tɨ³la³ nɨ́¹juáh³ tiá² záɨh¹³ hnoh² jmɨ́¹ honh², ja³bí¹ hnoh² siáh³ hiá¹ tsán¹³ náh² la³jmɨ́¹ cá¹hiá¹ cá¹tsan³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Nga¹ jná¹³ siáh³ cáun² jáɨ¹³ ca³tɨn¹ tsá² quian³jña³ ca³jláɨn³² hí³ hñú³ ñe¹ hi³ jmɨ́¹ zeh¹ jáun² já¹ juú² Jerusalén tɨ³ Siloé. ¿Hí¹ ná¹lɨ́n²³ hnoh² hi³ tsá² cá²tsan³ hí³ jlánh¹ bíh¹ jmɨ́¹ ná¹ren² tso³ la³ cónh³ bíh¹ la³jɨ́n³² tsá² ñí¹ hná¹ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jná¹³ juanh³² hi³ tiá² tson² yáh³ hi³ ná¹lɨ́n²³ hnoh² nɨ́². Tɨ³la³ nɨ́¹juáh³ tiá² záɨh¹³ hnoh² jmɨ́¹ honh², ja³bí¹ hnoh² siáh³ hiá¹ tsán¹³ náh² la³jmɨ́¹ cá¹hiá¹ cá¹tsan³ jáun² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jmɨ́¹jáun² ca³jmú³ siáh³ Jesús cáun² jáɨ¹³, hi³ ca³juáh³: ―Jmɨ́¹ zian² jan² tsá²ñuh² jmɨ́¹ chi²¹ cáun² hmá² sí² co² ñí¹náɨ² quioh²¹. Hi³ jáun² ñéi¹ tsú² ñí¹jɨ́e¹³ nɨ́¹juáh³ má²haɨ²¹ máɨ³, tɨ³la³ tiá² hi³ jmɨ́¹ má²haɨ²¹ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jáun² tsá² hí³ né³, ca³záɨh³ tsá² quian²¹, tsá² jmu² ta²¹ hué³² jáun² quioh²¹ tsú², hi³ ca³juáh³: “Sá¹nɨ́² jɨe³, má²tí³ hnɨ³² mii² hi³ ñi³jɨ́e²¹ jná¹³ hmá² sí² lá², hi³ tiá² máɨ³ má²ca³háɨ³² yáh³. Quieh¹ tiá³; ¿he³ láɨh³² lɨ́¹ chí¹jnáɨ²³ hué³² lá²?” ");
INSERT INTO csoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tɨ³la³ tsá² quian²¹ tsú² hí³ né³ ca³juáh³: “Hnú² juóu³² jná¹³, nɨ́² tín² cuɨ́¹ chi²¹ hmá² nɨ́² mii² lá², já¹cáh³ jná¹³ hué³² jmɨ́h¹ hmá², hi³ já¹tóh³² jná¹³ siáh³ háuh¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","cuɨ́¹ neh²¹ tiá¹ ha³ máɨ³ nɨ́¹ má¹jáun². Jáun² nɨ́¹juáh³ tiá² ca³háɨ³² né³, jáun² má¹jáun² má²quieih²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jáun² né³, ca³chó³² cáun² jmáɨ¹ hi³ Jesús jmɨ́¹ cuá¹má²tɨn² tsáu² hñu³ cuáh³² quioh²¹ tsá² *judíos *jmáɨ¹ nio² tie³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hi³ jáun² ñí¹ jáun² jmɨ́¹ cuá³ jan² tsá²mɨ³, tsá² tsáun¹ má²quia³jña³ mii²; hi³ jliun² tsú² hi³ jmu² jan² jmɨ́²chí³ hláɨnh¹, cónh³ tiá² jmɨ́¹ lɨ́²³ nó³² tsú² cú²tso². ");
INSERT INTO csoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jmɨ́¹ ca³jɨ́en³² Jesús tsá²mɨ³ hí³ né³, jáun² ca³teh³ dí² tɨ³ ñí¹ zenh¹, hi³ ca³záɨh³ dí² la³ lá²: ―Má²ca³liáun³ bíh¹ hnú² mɨ́¹uɨ́³ hi³ zian² nú². ");
INSERT INTO csoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jáun² jmɨ́¹jáun² ca³ra³tsɨ³² Jesús cuo² tsáɨh³ chí¹ tsú², hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³náu² tsú² re², hi³ ca³ma³quien² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tɨ³la³ tsá² lɨ́n³ hi³ chín¹ cuáh³² jáun² quioh²¹ tsá² judíos né³, ca³míh³ bíh¹ tsɨ́³, quí¹hliá² ca³jmah³ Jesús tsá² hí³ jmáɨ¹ nio² tie³. Jáun² tsá² chín¹ hí³ ca³záɨh³ tsá² ná¹ngɨh³² ñí¹ jáun² la³ lá²: ―Jñéi³ jmáɨ¹ bíh¹ zia³² jáɨ¹³ hi³ lɨ́¹³ jmu³ tsú² ta²¹; jmáɨ¹ la³ jáun² bíh¹ lɨ́¹³ jmah³ tsú² tsá² tsáun¹, jun³juáh¹³ jmáɨ¹ tionh² tsú² tie³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tɨ³la³ Tɨ³² Juo¹³ dí² ca³juáh³ siáh³ la³ lá²: ―Hnoh², tsá² lɨ́n³ náh² la³ cá¹ la³ jéinh¹, já² chín¹dí¹ hmóu³² bíh¹ hnoh² cua³quin³² náh² jáh³ joh² jmáɨ¹ nio² tie³, hi³ cua³jan³² náh² siáh³ ñí¹ ha²¹ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tɨ³la³ tsá²mɨ³ lá² má¹ná¹, má²tí³ quia³jña³ mii² hi³ jliun², hi³ ca³jmú³ *Satanás. Hi³ jáun² né³, ¿hí¹ tiá² ca³tɨn¹ tsá² lɨ́n³ lá² jan² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹ hi³ lan¹³ uá¹jinh¹ jmáɨ¹ nio² tie³? ");
INSERT INTO csoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́², ca³la³ jɨ́n³² bíh¹ tsá² jmɨ́¹ hnió³ hí³ hi³ ma³cu³ ma³jéinh³ jáɨ¹³ ca³lɨ³ heh³. Tɨ³la³ la³jɨ́n³² tsá² jmɨ́¹ ná¹ngɨh³² hí³ ñí¹ jáun² má¹ná¹, ca³lɨ³ tsah³ lɨ́n³² bíh¹ quí¹hliá² má²lɨ́²jɨ́e³ la³jɨ́³² hua³jueh³² hi³ má²lɨ́²jmú³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jáun² Jesús ca³juáh³ siáh³: ―¿He³ yáh³ cun³quionh³ lɨ́¹³ cunh²¹ jná¹³ tsá² tónh³² jo³cuo² Dió³²? ¿He³ dá² jáɨ¹³ lɨ́¹³ jmu¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Quí¹ tsá² tónh³² jo³cuo² Dió³² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cá² máɨ³ mɨ³ mostaza hi³ ca³jñí³ jan² tsáu² ñí¹náɨ² quioh²¹. Jáun² jmɨ́¹ ca³hia² jáun² né³, ca³lɨ³ cáun² hmá² pa²¹, hi³ jáun² jmɨ́¹jáun² cua³taunh²¹ tan³² hi³ ca³jmú³ za³ tsɨ³ hmá² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jáun² ca³juáh³ tsú² siáh³: ―¿He³ cun³quionh³ cunh²¹ jná¹³ siáh³ tsá² tónh³² jo³cuo² Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tsá² hí³ dá² lɨ́n¹³ la³jmɨ́¹ lɨ́³ tie³ hi³ ca³jan³ jan² tsá²mɨ³ quia³ hmá² juɨ²¹ cuú²miih²¹, hi³ jáun² tá¹ cá² pɨenh¹ bíh¹ cán¹ cáu³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ siáh³ Jesús juɨ³² má²hún¹ hi³ chau²¹ tɨ³ Jerusalén, hi³ ca³hɨ́eh³ tsú² tsáu² jú¹ chú³² quioh²¹ Dió³² ma³ quin³² ma³ caun³² juú² ñí¹ ca³nga². ");
INSERT INTO csoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jáun² né³, jan² tsáu² ca³ngáɨ³ ñí¹con² tsú²: ―Hnú² Tɨ³², ¿hí¹ cú¹pih²¹ uá¹ tsáu² lɨ́¹³ liáun³? Jáun² Jesús ca³záɨh³ la³jɨ́n³² tsá² tionh² hí³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Jmu³ náh² pí³ hi³ lɨ́¹³ ngá¹³ náh² juɨ³² ho³hñú¹³ jáɨ³². Jná¹³ juanh³² hi³ juóun³² lɨ́n³² tsá² cáun² lɨ́¹ ná¹hen² tsɨ́³ hi³ tónh³², tɨ³la³ tiá² cáun² lɨ́¹ lɨ́¹³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Quí¹ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ jnáɨ³² tsá² hñú¹³ tiá³ ho³hñú¹³ quioh²¹, jáun² hnoh² lɨ́¹ tá¹tonh¹ cheih³² bíh¹ má¹jáun², hi³ ná¹póh³² náh² cuonh² ho³hñú¹³ quioh²¹ tsú², hi³ ná¹juáh²³ náh²: “Hnú² Tɨ³², nia²¹ tiá³ ho³hñú¹³”. Tɨ³la³ tsá² hñú¹³ hí³ nga³: “Tiá² ño¹ jná¹³ ha³ jinh¹ ña³taunh²¹ hnoh²”. ");
INSERT INTO csoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Má¹jáun² né³, má²juáh¹³ hnoh²: “Jnoh¹ bíh¹ la³² tsá² má²ca³cú¹ ca³hnáɨh¹³ quiúnh¹ hnú², hi³ hí¹ la³ tɨ³ já¹ hñú³ quiú¹³ yáh³ jnoh¹ ca³hɨ́eh¹ hnú² jú¹ chú³² quioh²¹ Dió³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tɨ³la³ tsá²hñú¹³ hí³ nga³ siáh³: “Tiá² ño¹ jná¹³ ha³ jinh¹ zian² hnoh². Tɨ³ có³² quin³² náh² ñí¹con² jná¹³, hnoh² tsá² jmuh³² náh² hi³ hlah³ hi³ hó³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Hi³ jáun² má¹jáun² má²uóh¹ bíh¹ hnoh², hi³ má²cúh¹ náh² jánh¹, nɨ́¹ má¹ca³jɨen¹ náh² jáun² hla¹ Há²bran²¹, hla¹ Isaac, hla¹ Jacob, jɨ³ la³jɨ́n³² tsá² lɨn³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin² nɨ́² siáh³; hi³ la³jɨ́n³² tsá² hí³ má²tionh² ñí¹ cuá¹quien² Dió³², tɨ³la³ hnoh² má¹ná¹, má²ta³tonh¹ tɨ³ có³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Quí¹ tsa³táunh¹ tsáu² hi³ tsa³jmú³ má³² tɨ³ hñu³mɨ³cuú² ñí¹ cuá¹quien² Dió³². Tsá² tsa³táunh¹ hí³ ñí¹ jáun² ja³táunh¹ tɨ³ ñí¹ hia³² hiú², jɨ³ tɨ³ ñí¹ tá²tsɨ²¹ hiú² nɨ́², hué³² tɨ³ ñei³², jɨ³ hué³² tɨ³ quián³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Jáun² jmáɨ¹ jáun² za¹³ bíh¹. Zian² ma³ jan² tsá² ná¹lɨ́n³ tsá² ñí¹ ca³táuh³ ta³né³², tɨ³la³ nɨ́¹ má¹jáun² né³, lɨ́n¹³ tsú² tsá² la³ñí¹ bíh¹; hi³ zian² siáh³ tsá² ná¹lɨ́n³ tsá² la³ñí¹ ta³né³², tɨ³la³ má¹jáun² né³, má²lɨ́n¹³ tsú² tsá² ñí¹ ca³táuh³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jmáɨ¹ jáun² cua³taunh²¹ ma³ jan² tsá² *fariseos, hi³ ca³záɨh³ dí² Jesús la³ lá²: ―Chú³² cuóh¹³ hnú² tɨ³ ñí¹ siáh³, quí¹ re²¹ Herodes hnió³ jngah³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tɨ³la³ Jesús ca³ngáɨ³: ―Cuá²tánh¹ náh², cuá²zéih³ náh² tsá² lín¹ cuo² hian² tsɨ́³ hí³ la³ lá²: “Sá¹nɨ́² jɨe³, né³² jɨ³ tsa³háu² nɨ́² huen¹ jná¹³ jmɨ́²chí³ hláɨnh¹ hñu³ tsɨ́³ tsáu², hi³ jmah²¹ jná¹³ siáh³ tsá² tsáun¹, hi³ jáun² yó³² né³ má²má¹táuh¹³ jná¹³ la³ cun³ hi³ hu²¹ tsɨn³² jmu¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Quí¹ cun³ ca³tɨn¹ jná¹³ ñe¹ juɨ³² má²hún¹ ná¹ né³², tsa³háu² jɨ³ yó³² nɨ́²; quí¹ tiá² ca³tɨn¹ yáh³ jan² tɨ³² jë¹ Dió³² hi³ jún³ ñí¹ siáh³, jmáh³la³ já¹ juú¹ Jerusalén bíh¹ ca³tɨ²¹ jún³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”¡Hnú² juú² Jerusalén, hnú² bíh¹ tsá² jngɨh²³ tɨ³² jë¹ Dió³², tsá² zen² Dió³² ñí¹con² nú², hi³ quí¹ jlan¹ nú² quɨ́n¹! ¡Hliáun³ jéin³² bíh¹ jmɨ́¹ hnó²¹ jná¹³ hi³ chan²¹ jon³zɨ́h¹ hnú² la³jmɨ́¹ chan² cá¹hio³ cu³lɨ²¹ jon² ñeh² chí¹pí¹³, tɨ³la³ hnú² má¹ná¹, tiá² ca³lɨ³hnáuh² yáh³ la³ jáun²! ");
INSERT INTO csoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Sá¹nɨ́² jɨe³, tiú²uú² taunh²¹ yáh³ jná¹³ hó¹ñi³² hnú². Hi³ juanh²¹ jná¹³ siáh³, tiú²uú² lɨ́¹³ yáh³ jɨe¹ hnú² jná¹³ ca³la³ tɨ³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ juáh¹³ hnú²: “Hénh³ ma³chun¹ Tsá² cuá¹jáunh²³ cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jáun² né³, Jesús ngau³ cáun² *jmáɨ¹ nio² tie³ hñú¹³ jan² tsá² *fariseo tsá² chín¹ hi³ ja³jmú³ má³². Hi³ jáun² la³jɨ́n³² tsá² tiáunh¹ ñí¹ jáun² ca³can³ hua³hí¹³ nɨ́¹juáh³ he³ jmu³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ja¹ tsá² hí³ jmɨ́¹ cuá³ jan² tsá² tsáun¹ lɨ́n³ mɨ́¹uɨ́³ hi³ dáun². ");
INSERT INTO csoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hi³ jáun² Jesús ca³ngáɨ³ ñí¹con² tsá² ná¹lɨ́n³ tɨ³² liei²¹ jɨ³ tsá² fariseos, hi³ ca³juáh³: ―¿Hí¹ lɨ́¹³ jmah²¹ tsá² tsáun¹ jmáɨ¹ nio² tie³, ho³ tiá² lɨ́¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tɨ³la³ tie³ pih²¹ bíh¹ ca³tiánh³ tsá² hí³, hí¹ jan² yáh³ tsú² tiá² ca³ngáɨ³. Jáun² Jesús ca³zanh³ tsá² tsáun¹, hi³ ca³jmah³. Jáun² jmɨ́¹jáun² ca³záɨh³ dí² hi³ tsánh³² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jmɨ́¹ má²lɨ³² jáun² né³, ca³záɨh³ dí² siáh³ tsá² fariseos hí³ la³ lá²: ―Nɨ́¹juáh³ ca³tánh³ jónh³² náh² ho³ cuá¹juɨ́² joh² náh² cáun² hñu³ táu², ¿hin² yáh³ tsánh² hnoh² tiá² jmúh¹³ pí³ tia³juɨ³² lɨ́n³² hi³ cuá¹chin³² náh² jónh³² ho³lá²dá² jáh³ hí³ joh², uá¹jinh¹ jmáɨ¹ nio² tie³? ");
INSERT INTO csoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Hi³ jáun² hí¹ cáun² yáh³ tiá² hi³ ca³lɨ³ nga³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jmɨ́¹ ca³jɨ́en³² jáun² Jesús tsá² ná¹tén¹ hí³, hi³ hnió³ tiánh³ ñí¹ mesa la³ tɨ³ ñí¹ jlánh¹ quien², jmɨ́¹jáun² ca³jmú³ dí² cáun² jáɨ¹³ hi³ ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nɨ́¹juáh³ zian² tsá² ca³te³ hnú² ñí¹ jmu³ jmáɨ¹ hi³ jenh¹³ cuo², ha³ lɨ́² ñí³ hnú² ñí¹ jlánh¹ quien², quí¹ ho³sa³ cuán¹³ siáh³ jan² tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hi³ jáun² tsá² ca³te³ hnú² hí³ la³ má²quionh³ tsá² jan² siáh³ ja³juah²¹ ñí¹con² hnú²: “Cuéh³ tsá² lá² ñí¹ nɨ́² cuá³²”. Hi³ jáun² lɨ́¹ lɨ³ hinh¹ bíh¹ hnú² lɨ́¹³, quí¹hliá² lɨ³ hniáuh³² cuá¹ñíh³ hnú² ñí¹ tiá² nga³ quien². ");
INSERT INTO csoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tɨ³la³ la³ lá² bíh¹ hniáuh³² jmúh¹³ hnú²: Nɨ́¹juáh³ hi³ ca³te³ tsú² hnú² ñí¹ jmu³ jmáɨ¹, chú³² cuá¹ñíh³ hnú² ñí¹ tiá² quien²; hi³ jáun² tsá² ca³te³ hnú² hí³ lɨ́¹³ ja³juah²¹: “Hnú² há²mei²¹ quiú¹³, ña³², ñá²ñí³ ñí¹ quien² lá²”. Hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ lɨ³ quien² hnú² ta³ ñí¹ tsá² ñí¹ hná¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Quí¹ nɨ́¹juáh³ tsá² jmu² pan¹ hnga², jáun² tsá² la³ hí³ má²méih³ bíh¹ hi³ quien²; tɨ³la³ tsá² tiá² jmu² quien² hnga² má¹ná¹, tsá² la³ hí³ bíh¹ tɨ³ zó³² hi³ quien². ");
INSERT INTO csoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jmɨ́¹ má²lɨ́²juáh³ jáun² la³ nɨ́² Jesús, ca³záɨh³ siáh³ tsá² ca³te³ hí³ la³ lá²: ―Nɨ́¹juáh³ ca³chó³² jmáɨ¹ hi³ teh¹ hnú² tsá² ja³jmú³ má³² quiúnh¹ hnú², ha³ lɨ́² teh³² hnú² jmáh³la³ tsá² juónh³² hnú² re² quiúnh¹, sa³jun³ tsá² jun³ renh² hnú², sa³jun³ tsá² hánh³ juónh³² hnú² re² quiúnh¹ nɨ́² siáh³. Quí¹ tsá² la³ hí³ chau²¹ jmáɨ¹ té³ hnú² siáh³ hñú¹³ hi³ cuá¹jmuh³ hnú² má³²; hi³ jáun² cun³quionh³ la³ jáun² má²jéinh³² tsú² siáh³ ñí¹con² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cha³ jmɨ́¹ teh¹ hnú² tsá² la³ hí³, chú³² teh¹ hnú² tsá² tia³mii² bíh¹ hi³ jmu³ má³² quiúnh¹ hnú², jɨ³ tsá² hliánh², tsá² hma², jɨ³ tsá² ten³ nɨ́² siáh³; ");
INSERT INTO csoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","hi³ jáun² tɨ³ jlánh¹ bí¹ chú³² quián¹³ hnú² lɨ́¹³, quí¹hliá² tsá² la³ hí³ tiá² zia³² yáh³ ha³ lánh³ rón³² lɨ́¹³ jéinh³². Hi³ jáun² nɨ́¹ má¹ca³jenh¹³ tsá² chun¹ tsá² má²cá²tsan³, má¹jáun² hnga² Dió³² bíh¹ ma³hmah¹ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² hí³ jáɨ¹³ hi³ má²lɨ́²juáh³ jáun² Jesús, jáun² jan² tsá² jmɨ́¹ cuá³ hí³ ñí¹ mesa ca³záɨh³ Jesús la³ lá²: ―¡Hénh³ ma³ jmɨ́¹ ren² tsá² tsa³jmú³ má³² ñí¹ cuá¹quien² Dió³²! ");
INSERT INTO csoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jáun² Jesús ca³jmú³ siáh³ cáun² jáɨ¹³ hi³ ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Jmɨ́¹ zian² jan² tsá²ñuh² jmɨ́¹ hnió³ jmu³ cáun² jmáɨ¹ jueh³² lɨ́n³², jáun² jmɨ́¹ ca³teh³ tsú² juóun³² lɨ́n³² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jmɨ́¹ cá¹chó²¹ jáun² jmáɨ¹ hi³ má²jmu³ tsú² jmáɨ¹ né³, jáun² ca³zen³ tsú² siáh³ tsá² má²dí¹hlánh¹ joh¹ hi³ tsa³ngáɨ¹ siáh³ jáɨ¹³ ñí¹con² tsá² má²ná¹tén¹, hi³ tsa³juah²¹: “Ñí¹juah²¹ juóu³² jná¹³: Ñá²táunh¹ náh², má²lɨ³² bíh¹ re² la³jɨ́³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tɨ³la³ la³jɨ́n³² bíh¹ tsá² hí³ ca³hiu³ ca³mɨ́³ uu³i³tso³. Tsá² la³ñí¹ ca³juáh³: “Hué³² bíh¹ má²lɨ́²lá³ jná¹³ cáun², hi³ jáun² ñí¹ jáun² bíh¹ má²hniáuh³² ñí¹jɨ́e²¹ jná¹³ ta³né³². Juenh² lɨ́n³² cuɨ́¹ jmu¹ juóuh³² hnú² tsɨ́³ hi³ tiá² chau²¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jáun² ca³juáh³ siáh³ jan²: “Cuá¹juɨ́² bíh¹ má²lɨ́²lán³² jná¹³ hñá³ tsonh², hi³ jáun² má²ñí¹jɨ́e²¹ jná¹³ nɨ́¹juáh³ cuounh³² jáh³ re² mí¹ñí² quiáh² hué³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hi³ jáun² tsá² siánh³ siáh³ ca³juáh³: “Uón³² bíh¹ jná¹³ tá² ca³jenh² cu³tí¹³, hi³ jáun² tiá² má²lɨ́¹³ yáh³ ñe¹ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jmɨ́¹ cá¹chánh²¹ jáun² tsá² joh¹ tsú² hí³ né³, ca³chá³ la³jɨ́³² jáɨ¹³ jáun² ñí¹con² juo¹³. Jmɨ́¹jáun² jlánh¹ ca³míh³ tsɨ́³ tsá² má²jmu³ hí³ jmáɨ¹; hi³ jáun² ca³záɨh³ dí² tsá² joh¹: “Háun¹ nú² cua³² já¹ hñú³, jɨ³ la³jáh³ dú¹ juɨ³² chi²¹ nɨ́², hi³ cuá¹tiéh³ nú² tsá² tia³mii², tsá² tsáun¹, tsá² hliánh², jɨ³ tsá² ten³ nɨ́² siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jmɨ́¹ má²cu³lé³ jáun² né³, ca³juáh³ siáh³ tsá² quian²¹ tsú²: “Má²lɨ́²jmú³² bíh¹ jná¹³ la³ cun³ hi³ lɨ́²juah²¹ hnú², tɨ³la³ cun³ jáun² jáu² bíh¹ ca³lá²”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jáun² tsá² má²jmu³ hí³ jmáɨ¹ né³, ca³juáh³ siáh³: “Cua³² siáh³ cu³ jéin³² já¹ juú², la³jɨ́³² juɨ³² pih²¹ juɨ³² siún¹, hi³ cuá¹jmuh³ nú² héih³² hi³ ja³táunh¹ tsú² ñí¹ lá², hi³ jáun² má²lɨ́¹³ canh¹³ hñu³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Quí¹ juanh³² jná¹³ ñí¹con² hnoh², hi³ hí¹ jan² yáh³ tsá² ca³te³ jná¹³ hí³ la³ñí¹, cu³tí³ tiú²uú² lɨ́¹³ jmu³ má³² quiúnh¹ jnoh¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jmɨ́¹jáun² jmɨ́¹ zian² juóun³² lɨ́n³² tsáu² hi³ ja³taunh²¹ cu³hna²¹ Jesús. Jáun² né³, Jesús ca³jinh³ cu³hna²¹ hi³ ca³jɨ́en³² dí² tsá² hí³, hi³ jáun² ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Nɨ́¹juáh³ zian² tsá² hnió³ já³² cu³hna³² jná¹³, tɨ³la³ nɨ́¹juáh³ tiá² chan² yáh³ tsú² tɨ³ có³² jméi² mí¹ziú¹³, ñí²cuo², jon², jɨ³ tsá¹ raɨnh²¹ nɨ́² siáh³, jɨ³ ca³la³ jɨ³ jmɨ́²chí³ quioh²¹ hnga² tsú² nɨ́² siáh³, hi³ jáun² tsá² la³ hí³ cu³tí³ tiá² lɨ́¹³ bíh¹ hen² tɨ³ con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ja³bí¹ tiá² lɨ́¹³ hen² tsú² tɨ³ con² jná¹³ nɨ́¹juáh³ tiá² hnió³ yáh³ tsú² cán³ crei²¹ quioh²¹, hi³ ma³zian² tsú² la³jmɨ́¹ zian² jná¹³ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nɨ́¹juáh³ zian² jan² hnoh² hi³ hnáuh² náh² jmúh¹³ cáun² hñú³ ñe¹ lɨ́n²¹, ¿há¹ tiá² hɨ́h¹ hnoh² tín² quɨe³ quián¹³, neh²¹ nɨ́¹juáh³ hi³ tsɨn¹³ hi³ lɨ́¹³ hián¹³ ta²¹ jáun² quián¹³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Quí¹ nɨ́¹juáh³ la³ ca³jmú³ tsú² jmáh³la³ jmɨ́h¹ hiah³² bíh¹, hi³ nɨ́¹juáh³ tiú²uú² la³ tsɨ́n¹³ yáh³ quɨe³ quioh²¹ ñí¹ hná¹ jáun², hi³ jáun² ca³la³ jɨ́n³² tsá² jɨ́e³ hi³ jáun² má²ju³ má²ngáɨ³ bíh¹, ");
INSERT INTO csoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","hi³ juáh³: “Tsá² nɨ́² tsá² ti³ lɨ́¹ ca³ma³liáu³² bíh¹, tɨ³la³ tiá² la³ tioh²¹ yáh³ ma³hián²”. ");
INSERT INTO csoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ho³ nɨ́¹juáh³ ca³chó³² cáun² jmáɨ¹ hi³ jan² re²¹ jmu³ hniéi² quionh³ jan² re²¹ siánh³ siáh³, ¿há¹ tiá² hnauh¹³ tsú² tín² ca³lá² chí¹ hi³ jɨ́e³ tsú² tiá¹ lɨ́¹³ láɨh¹³ hniéi² jáun² cun³quionh³ quian³ mei²¹ hliáu³ joh¹, uá¹jinh¹ zian² quiú³ mei²¹ hliáu³ joh¹ re²¹ jan²? ");
INSERT INTO csoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jáun² né³, nɨ́¹juáh³ ca³lɨ́n¹³ re²¹ hí³ hi³ tiá² tioh²¹ yáh³, jáun² tá¹la³ cuá¹ja³² jáun² ñí¹ uóunh³ bíh¹ re²¹ tsá² hí¹jan² hí³ quiú³ mei²¹ hliáu³, zen³ dí² tsá² tsa³ngáɨ³ ñí¹con² re²¹ hí³ nɨ́¹juáh³ he³ hnió³ tsú², hi³ jáun² lɨ́¹³ niau²¹ tie³. ");
INSERT INTO csoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hi³ jáun² la³ jáun² bíh¹ tiá² lɨ́¹³ han³ hnoh² tɨ³ con² jná¹³, lɨ³ua³ jan² hnoh² tsá² tiá² chah³² náh² tɨ³ có³² ca³la³ jɨ³lɨ³² hi³ zia³² quián¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","”Chú³² bíh¹ ñí¹, tɨ³la³ nɨ́¹juáh³ la³ ca³lɨ³ máɨh³ bíh¹ né³, jáun² ¿ha³ yáh³ lánh³ rón³² lɨ́¹³ jmóuh³² tsú² hi³ lɨ́¹³ siáh³ ñeh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ñí¹ la³ jáun² hí¹ cáun² yáh³ tiú²uú² lin¹ ñí¹ jmu³ ta²¹, sa³jun³ ma³hau³ bíh¹ quioh²¹ hué³², sa³jun³ hi³ jmu³ tsú² háuh¹³; hi³ jáun² cáun² má²cuɨ́³ bíh¹ tsú² ñí¹ la³ jáun². Hi³ jáun² né³, nɨ́¹juáh³ tson² chi²¹ cuáh³ hnoh², jáun² niéi² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jmɨ́¹jáun² la³jɨ́n³² *tsá² chi² hmah²¹, jɨ³ tsá² ná¹ren² tso³ nɨ́² ca³ñí¹niéi¹³ jáɨ¹³ quioh²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hi³ jáun² tsá² *fariseos jɨ³ tɨ³² liei²¹ nɨ́² ca³ziu³ ca³hɨen³ Jesús, hi³ ca³juáh³: ―Tsá² nɨ́² cáun² lɨ́¹ hen² tsá² jmu² tso³, ca³la³ hi³ jmu² má³² quionh³ ján¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jmɨ́¹jáun² ca³jmú³ siáh³ Jesús cáun² jáɨ¹³ lɨ́³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Nɨ́¹juáh³ zian² jan² tsá² ja¹ hnoh² nɨ́² hi³ tiónh³² hña³láun³ *já¹ziáh², tɨ³la³ nɨ́¹juáh³ la³ ja³háɨn³ jan² jáh³ hí³ né³, ¿há¹ tiá² chan³ tsú² tá¹ quiéinh³ nio² quiú³ tsɨ²¹ quian³ñu³ jáh³ hí³ ñí¹ tionh¹ jáun² tá¹la³ tsa³hniah² tsú² jáh³ má²já²háɨn³ hí³? ");
INSERT INTO csoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hi³ jáun² nɨ́¹ má¹ca³tsanh²¹ tsú² jáun² jáh³ hí³, hiún² lɨ́n³² bíh¹ tsɨ́³ tsú² ra³tsɨn² jáh³ hí³ cu³láɨ¹ hi³ jón³². ");
INSERT INTO csoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hi³ jáun² nɨ́¹ má¹cá²chánh³² tsú² jáun² hñú¹³, téh³ tsú² tsá² há²mei²¹ joh¹, jɨ³ tsá² tiáunh¹ có³² hñú¹³ tsú² nɨ́², hi³ záɨh³² tsú² tsá² hí³ la³ lá²: “Ma³hiún¹³ hnoh² honh² quiúnh¹ jná¹³, quí¹ má²tsanh²¹ bíh¹ jná¹³ já¹ziáh² jmɨ́¹ má²já²háɨn³ joh²”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Juanh³² jná¹³, ja³bí¹ la³ jáun² jlánh¹ bí¹ tsah³ tsú² hñu³mɨ³cuú² hi³ ca³tɨn¹ jan² tsá² jmɨ́¹ jmu² tso³, tsá² ca³za³ jmɨ́¹ tsɨ́³, la³ cónh³ bíh¹ hi³ ca³tɨn¹ quiéinh³ nio² quiú³ tsɨ²¹ quian³ñu³ tsá² tiá² lin¹ lɨ³ hniáuh³² záɨ³² jmɨ́¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ja³bí¹ la³ jáun², nɨ́¹juáh³ jmɨ́¹ zia³² quia³ *cú¹tiáu² quioh²¹ jan² tsá²mɨ³, hi³ nɨ́¹juáh³ ja³háɨ³ cáun² hi³ jáun², ¿haun¹³ juáh¹³ sɨ́² yáh³ héinh³ tsú² quioh²¹ tá¹la³ hiáh³² tsú² jáun² re² lɨ́n³² ñéih³, ca³la³ ñí¹ ca³choh¹³ tsú² quɨe³ ja³háɨ³ jáun² quioh²¹? ");
INSERT INTO csoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hi³ jáun² nɨ́¹ má¹ca³choh¹³ tsú² jáun² né³, téh³ tsú² há²mei²¹ joh¹, jɨ³ tsá² tionh² có³² hñú¹³ tsú² nɨ́², hi³ záɨh³² dí² tsá² hí³ la³ lá²: “Ma³hiún¹³ hnoh² honh² quiúnh¹ jná¹³, quí¹ má²tsoh¹ bíh¹ jná¹³ quɨe³ hi³ jmɨ́¹ má²já²háɨ³ quion²¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Juanh³² jná¹³ siáh³, ja³bí¹ la³ jáun² tsah³ lɨ́n³² tsá²cuú² tsá²ta³ Dió³² hi³ ca³tɨn¹ lɨ³ua³ jan² tsá² zaɨ³² jmɨ́¹ tsɨ́³ ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jáun² Jesús ca³jmú³ siáh³ cáun² jáɨ¹³ lɨ́³ la³ lá²: ―Jan² tsá²ñuh² jmɨ́¹ zian² gon³ jon². ");
INSERT INTO csoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ca³chó³² jmáɨ¹ hi³ ca³záɨ³ jon² tsú² tsá² cáɨn² la³ lá²: “Tia²¹, ¿tiá¹ cuéh¹ hnú² jná¹³ ta³né³² hi³ ca³tɨn¹ jná¹³ hiáu³ nɨ́¹ má¹jun² hnú²?” Hi³ jáun² tsá² má²lieih²¹ hí³ né³, ca³tsóh³ bíh¹ la³jɨ́³² hi³ zia³² quioh²¹ ñí¹con² tá¹ gon³ jon². ");
INSERT INTO csoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jmɨ́¹ ngau²¹ jáun² cú¹pih²¹ jmáɨ¹ né³, jáun² jon² tsú² tsá² cáɨn² hí³ ca³chá³ cu³lɨ²¹ ca³la³ jɨ́³² hi³ hiauh³ jáun², hi³ jáun² la³jɨ́³² hi³ jáun² ca³can³ jmɨ́¹ ngau²¹ ñí¹ uóunh³, tɨ³ hué³² siáh³. Jáun² ñí¹ jáun² ca³ñí¹jmú¹³ tsú² cáun² hi³ cáun¹, hi³ cáun² lɨ́¹ ca³ñí¹quí² ñí¹hin² quɨe³ quioh²¹ ñí¹con² tsá² hlá² tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jmɨ́¹ cá¹tsóh²¹ tsú² jáun² la³jɨ́³² quɨe³ jáun² né³, he³dí¹ jmɨ́¹jáun² ja³ cáun² ho³cuóun³ tá¹ cáun² hué³² ñí¹ jmɨ́¹ hún¹ tsú² jáun². Jmɨ́¹jáun² ca³ma³tso² lɨ́n³² tsá² hí³ tsɨ́³ hi³ ñí¹cuóunh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jáun² ca³hnó³² tsú² ta²¹ ñí¹ jáun², hi³ jáun² jan² tsá² zian² ñí¹ jáun² ca³ze³ ñí¹ lɨ́³ ñí¹náɨ² quioh²¹ hi³ tsa³jmú³ tsú² hua³hí¹³ mí²ñí³ joh¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ca³la³ ñí¹cuóunh²¹ lɨ́n³² bíh¹ tsú² lɨ³, hí¹ ca³la³ tɨ³ má³² quioh²¹ mí²ñí³ hí³ yáh³ jmɨ́¹ hnió³ tsú² cuh³, hi³ jniá³ jáun² la³jmɨ́¹ jniá³ jñéi². Hí¹ jan² yáh³ tiá² hin² lɨ́¹ jmɨ́¹ cue³² hi³ cuh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jmɨ́¹jáun² ca³hnauh² tsú² tsɨ́³ hi³ ca³lɨ́n¹³ la³ lá²: “¡Já² ca³la³ hi³ lɨ́¹ tú² lɨ́¹ ziáun²³ bíh¹ má³² quioh²¹ tsá² quian²¹ ñuh³² jná¹³, he³ láɨh³² sa³ jná¹³ yáh³ lɨ́¹ má²ñí¹jún³ ná¹ ñí¹ lá² hi³ ñí¹cuóun²¹! ");
INSERT INTO csoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cuɨ́¹ ñih²¹ jná¹³ cú²jueh³² tɨ³ ñí¹ cuá³ ñuh³², hi³ jáun² ñí¹juo³ jná¹³ ñuh³² la³ lá²: Hnú² tia²¹, má²cá²jmú³² jná¹³ tso³ ñí¹con² Dió³², jɨ³ ñí¹con² hnú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cu³tí³ tiú²uú² ca³tɨn¹ jná¹³ hi³ jɨe¹ hnú² la³jmɨ́¹ jɨen¹ nú² jan² jónh³², jɨe¹ jná¹³ la³jmɨ́¹ jɨen¹ hnú² jan² tsá² quian²¹ bíh¹ nú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","La³ cun³ jmɨ́¹ ca³lɨ́n¹³ tsú² la³ nɨ́², la³juɨ³² ngah³ hñú¹³ jméi². Tá¹la³ jmɨ́¹ hí¹jáunh²³ tsú² jáun² ñí¹ uóunh³ ca³lá², jáun² ca³jɨ́e³² jméi² tsú² hi³ má²hí¹jáunh²³. Jmɨ́¹jáun² ca³ja³ mií³ tsɨ́³ tsá² má²lieih²¹ hí³ ñí¹con² jon². Jáun² cú²hé² lɨ́n³² ngau³ hi³ ja³hinh¹ jon² ca³la³ hi³ hiún² lɨ́n³² tsɨ́³, hi³ ca³hen³ dí² siáh³ ñí¹. ");
INSERT INTO csoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jáun² né³, tsá¹ñú¹ hí³ ca³záɨh³ jméi² la³ lá²: “Hnú² tia²¹, má²cá²jmú³² jná¹³ tso³ ñí¹con² Dió³², jɨ³ ñí¹con² hnú² nɨ́² siáh³. Cu³tí³ tiú²uú² ca³tɨn¹ jná¹³ hi³ jɨe¹ hnú² la³jmɨ́¹ jɨen¹ nú² jónh³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Tɨ³la³ jméi² tsú² má¹ná¹, la³juɨ³² ca³záɨh³ tsá² má²ná¹hlánh¹ joh¹ la³ lá²: “Háun¹ náh² cuá²quián² náh² hmɨh³² hi³ jlánh¹ bíh¹ chu²¹ hi³ quɨ́h³² jón³² jná¹³ lá², cuá²quián² siáh³ cáun² mí¹ñí² hu²¹ cuo² tsú² hi³ táunh¹³ zí¹cuo² tsú², hi³ cuá²quián² siáh³ tuh³² tauh¹³ tsú² ta³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Né³² né³, cuá²quian³² náh² siáh³ cuá¹juɨ́² míh¹ húnh¹ hí³, hi³ jngɨh¹³ náh² cunh¹³ dí², hi³ jmú¹³ dí² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Quí¹hliá² jmɨ́¹ len³ jná¹³ hi³ má²jún¹ bíh¹ jón³² jná¹³ lá², tɨ³la³ ta³né³² lɨ́³ la³jmɨ́¹ lɨ́³ hi³ ca³jenh¹³ bíh¹ tsú²; jmɨ́¹ má²já²háɨn³ cu³tí¹³ bíh¹ tsú², tɨ³la³ ta³né³² má²tsanh³² bíh¹ tsú²”. Jáun² la³juɨ³² ca³ma³liáu³² tsú² hi³ jmu³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”Tá¹la³ jáun² né³, tsá² má²ján³ jon² tsá² má²lieih²¹ hí³, ñí¹náɨ² bíh¹ jmɨ́¹ cuá¹hún¹. Jmɨ́¹ má²hí¹jáunh²³ tsú² jáun² hú¹ juɨ³² né³, ca³náɨ³² sun¹ jɨ³ hi³ má²ñí¹ná¹tsan³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jáun² ca³teh³ tsú² jan² tsá² quian²¹ hi³ ca³ngáɨh³ dí² he³ dá² lɨ³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jáun² tsá² quian²¹ tsú² hí³ ca³juáh³: “Hliá² má²cuanh³² renh² bíh¹ hnú², hi³ jáun² ñeh² hnú² má²lɨ́²jmú³ héih³² hi³ jngɨh³ tsú² cuá¹juɨ́² míh¹ húnh¹ hí³, quí¹hliá² má²cuanh³² renh² hnú² cáun² hi³ re² hi³ tɨn²”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tɨ³la³ tsá² má²ján³ hí³ má¹ná¹, ca³míh³ bí¹ tsɨ́³, hi³ tiú²uú² jmɨ́¹ hnió³ hen¹³ ñéih³. Jmɨ́¹jáun² cua³han³ jméi² tsú² hi³ ca³ñí¹lieh¹³, hi³ ca³hlɨ³ ca³liéinh³² tsú² jon² hi³ ca³záɨh³ dí² hi³ hniáuh³² hen¹³ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jáun² tsá² hí³ né³, ca³záɨh³ jméi²: “Ñíh¹ bíh¹ hnú² re² jáh³ mii² má²cá²jmú³² jná¹³ ta²¹ quián¹³ hnú², hi³ má²ca³ma³ti²¹ jná¹³ ca³la³ jɨ́³² héih³² hi³ jmuh³² hnú², tɨ³la³ hí¹ cu³ jéin³² yáh³ tiá² má²ca³cuen²¹ hnú² jná¹³ uá¹jinh¹ jan² zéin¹ bíh¹ hi³ jmɨ́¹ jmu¹ jná¹³ cáun² jmáɨ¹ quion²¹ quiúnh¹ há²mei²¹ quion²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Tɨ³la³ jmɨ́¹ cuanh²¹ jónh³² hnú² né³, tsá² lɨ́¹ ca³ñí¹quí² ñí¹hin² ó³² quɨéɨh³ hnú² quionh³ tsá²mɨ³ hláɨh¹, sa³ jáh³ húnh¹ máh³ má²lɨ́²jngɨh³² hnú² hi³ ca³tɨn¹ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Hi³ jáun² né³, tsá² má²lieih²¹ hí³ ca³juáh³: “Hnú² jón³, la³jɨ́³² jmáɨ¹ bíh¹ ñíh³ hnú² quiúnh¹ jná¹³; hnú² bíh¹ tsá² lɨ³quián¹³ la³jɨ́³² hi³ nió³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Quí¹ né³² ca³ta¹ dí² hi³ má¹hiún¹³ tsɨ³², quí¹hliá² renh² hnú² lɨ́³ la³jmɨ́¹ lɨ́³ hi³ jmɨ́¹ má²jún¹ bíh¹, tɨ³la³ ta³né³² má¹ná¹, lɨ́³ la³jmɨ́¹ lɨ́³ hi³ má²ca³jenh¹³ tsú²; jmɨ́¹ má²já²háɨn³ cu³tí¹³ bíh¹ tsú², tɨ³la³ ta³né³² né³ má²ná¹néh³² dí² tsú² siáh³”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jmɨ́¹jáun² ca³záɨh³ siáh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³: ―Jmɨ́¹ zian² jan² tsá² jmɨ́¹ jmu² hua³hí¹³ la³jɨ́³² hi³ zia³² quioh²¹ jan² tsá² hánh³. Tɨ³la³ ca³chó³² jmáɨ¹ hi³ ca³chá³ tsáu² tso³ quioh²¹ tsú² ñí¹con² tsá² hánh³ hí³. Ca³chá³ tsú² hi³ tsá² quian²¹ tsú² hí³ néh¹ cáun² lɨ́¹ quí² lɨ́¹ hin²³ hi³ zia³² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jáun² tsá² hánh³ hí³ né³, ca³teh³ tsá² quian²¹, hi³ ca³ngáɨh³ dí² la³ lá²: “¿Hí¹ tson² bíh¹ la³ cun³ hi³ má²ca³chá³ tsáu² ñí¹con² jná¹³ hi³ ca³tɨn¹ hnú²? Jɨ́enh¹ sí² quián¹³ neh²¹, ca³tɨ²¹ ta²¹ hi³ jmuh³² hnú² quion²¹ jná¹³, quí¹ tiú²uú² hnú² jmúh¹³ yáh³ ta²¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jmɨ́¹jáun² ca³lɨ́n¹³ tsá² hí³: “¿Ha³ lánh³ rón³² jmu¹ jná¹³ ta³né³², quí¹hliá² juóu³² jná¹³ má²ñí¹quin¹³ bíh¹ ta²¹ hi³ jmu² jná¹³? Já² tiá² pin³ yáh³ jná¹³ hi³ cáh¹³ hué³². Já² hua³heih²¹ bíh¹ nɨ́¹juáh³ hi³ cáun² lɨ́¹ mɨ́¹³ jná¹³ quɨe³ quioh²¹ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Há¹, ta³né³² má²ño¹ jná¹³ ha³ lánh³ rón³² jmu¹, hi³ jáun² lɨ³ zian² tsá² he³ jná¹³ hñú¹³ nɨ́¹ má¹ca³che² jná¹³ juóu³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hi³ jáun² jmɨ́¹jáun² ca³teh³ tsú² ma³ quin³² ma³ jan³² tsá² ná¹ren² hí³ quioh²¹ juo¹³. Ñí¹con² tsá² la³ñí¹ hí³ ca³ngáɨ³ tsú²: “¿Cónh³ ren² hnú² quioh²¹ juóu³² jná¹³?” ");
INSERT INTO csoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jáun² tsá² hí³ ca³juáh³: “Ren² jná¹³ hña³láu³ barril hi³ ha²¹ ma³ quiu³quia³ñu³ lí¹³ no¹”. Jmɨ́¹jáun² tsá² quian²¹ tsá² hánh³ hí³ ca³juáh³: “Lá² rón³² sí² ca³tɨ²¹ hi³ ren² hnú². Tia³juɨ³² ñí³, jmu³ hi³ ren² nú² tu³la³quia³ tán¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jmɨ́¹ lɨ²¹ jáun² né³, ca³ngáɨh³ tsú² siáh³ tsá² jan²: “Hnú² siáh³, ¿ha³ cónh³ ren² hnú² quioh²¹ juóu³² jná¹³?” Jáun² tsá² hí³ ca³ngáɨ³: “Ren² jná¹³ quiún³ nio² hña³láu³ lio²¹ cuú²miih²¹”. Jmɨ́¹jáun² ca³záɨh³ tsú² siáh³ tsá² hí³ la³ lá²: “Lá² rón³² sí² ca³tɨ²¹ hi³ ren² hnú², jmu³ hnú² hi³ ren² nú² hnɨ³² nio² hña³láu³ tsɨ²¹ quiú³ lio²¹ tán¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jáun² juo¹³ tsá² quian²¹ tiá² chun¹ hí³ ca³juáh³: “Ha³ lánh³ rón³² jlánh¹ cháunh²³ chinh³² hnú² hi³ ca³lɨ́n¹³ hnú² jmúh¹³ la³ nɨ́²”. Jáun² jmɨ́¹jáun² ca³nia³ Jesús jáɨ¹³ jáun² quioh²¹, hi³ ca³juáh³: ―Tsá² zian² hngá¹máh³ lá² jlánh¹ bíh¹ jan²¹ ñí¹con² tsá²mɨ³cuóun² raɨnh²¹ la³ cónh³ bíh¹ tsá² tanh² ta²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","”Jáun² juanh³² jná¹³ ñí¹con² hnoh² hi³ cun³quionh³ hi³ zia³² quián¹³ hnoh² ñí¹ hué²¹ lá², jmúh¹³ hnoh² hi³ lɨ³ zian² tsá² juonh²¹ náh² re² quiúnh¹, jáun² nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ tsá¹³ hi³ jáun² quián¹³ hnoh² né³, lɨ³ zian² bíh¹ tsá² lɨ́¹³ he³ náh² ñí¹ lɨ́¹³ zian² náh² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”Nɨ́¹juáh³ zian² tsá² jmúh³² re² ta²¹ cun³quionh³ cú¹pih²¹ hi³ zia³² quioh²¹, jáun² la³ má²chun¹ jáun² bíh¹ tsú² uá¹ cun³ ca³lɨ³ zia³² hliáun³ hi³ quioh²¹. Tɨ³la³ tsá² tiá² jmu² hi³ chú³² cun³quionh³ cú¹pih²¹ hi³ zia³² quioh²¹ né³, sa³jun³ chun¹ bíh¹ tsú² nɨ́¹juáh³ ca³lɨ³ zioh² hliáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Hi³ jáun² nɨ́¹juáh³ tiá² la³ jmuh²¹ yáh³ hnoh² re² ta²¹ hi³ zia³² quián¹³ náh² ñí¹ hué²¹ lá², hi³ tiá² lin¹ nga³ quien², ¿lánh³ bíh¹ rón³² lɨ́¹³ hian³ náh² hú¹tá¹ hi³ quien² cu³tí³ nɨ́¹ má¹jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nɨ́¹juáh³ tiá² la³ chun¹ yáh³ náh² hi³ jmúh¹³ hua³hí¹³ hi³ quioh²¹ tsáu², ¿lánh³ bíh¹ rón³² lɨ́¹³ hian³ náh² hi³ lɨ́¹³ lɨ³ quián¹³ náh² hmóu³²? ");
INSERT INTO csoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Hí¹ jan² tsáu² tiá² lɨ́¹³ ma³tí³² ñí¹con² gon³ juo¹³, quí¹ tiá² tɨ²¹ yáh³ tsɨ́³ tsú² tsá² jan², hi³ tsá² jan² né³, tɨ́³² lɨ́n³² bíh¹ tsɨ́³ tsú²; re² lɨ́n³² bíh¹ má²tí³² tsú² héih³² quioh²¹ tsá² jan², hi³ tsá² jan² né³, tiá² ta²¹ tanh² yáh³ tsú². Jáun² né³, cónh³ tiá² lɨ́¹³ bíh¹ hno³ náh² Dió³² cu³tsa³² quionh³ hi³ hniá¹ náh² hi³ zia³² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, jáun² tsá² *fariseos cáun² lɨ́¹ ca³juú² ca³ngáɨ³² bíh¹ Jesús, quí¹hi³hliá² jlánh¹ ná¹hniá¹ tsú² quɨe³ hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³: ―Hnoh² tsá² lɨ́¹ ná¹haɨh³² náh² re² máh¹ ñí¹ ta³ ñí¹ tsáu², tɨ³la³ Dió³² cuá¹ñi³² he³ ná¹lɨ́n²³ náh² hñu³ honh². Quí¹ zia³² bíh¹ hi³ lɨ́¹ ná¹lɨ́n²³ tsáu² hi³ jlánh¹ quien², tɨ³la³ Dió³² má¹ná¹, hí¹ cú¹pih²¹ yáh³ tiá² jéih³² hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","”Jmɨ́¹ tɨ́² quien² bíh¹ liei²¹ quioh²¹ hla¹ Moisés, jɨ³ jáɨ¹³ quioh²¹ tsá² lɨn³ hí³ *tɨ³² jë¹ Dió³², ca³la³ tɨ³ jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ cuan³ Juan², tsá² jmɨ́¹ zion² hí³ jmáɨ² tsáu². Jáun² la³ cun³ jmɨ́¹jáun² né³, ca³lɨ³liau³ hi³ tsá²ngɨ³ jú¹ chú³² hi³ ca³tɨ²¹ héih³² hi³ jmu² Dió³², hi³ jáun² tsá² jlánh¹ ná¹cueh³² pí³ né³, má²ná¹cah²³ bíh¹ jmáɨ¹ hi³ lɨ́¹³ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","”Tɨ³la³ tɨ³ huán¹ bíh¹ tsɨ́³ hi³ tsa³hín³ la³jɨ́³² hi³ jniá³ chi³cuú² la³ má²quionh³ hngá¹máh³ lá², la³ cónh³ bíh¹ jáɨ¹³ hi³ rá¹tioh³ ñí¹ liei²¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","”Nɨ́¹juáh³ jan² tsá²ñuh² ca³tun³ ñí²cuo², hi³ jáun² jan³ jan² tsá²mɨ³ siánh³ siáh³, jáun² tsá² la³ hí³ lɨ́¹ jmu² tso³ juón¹ bíh¹. Hi³ nɨ́¹juáh³ zian² siáh³ jan² tsá²ñuh² ca³jan³ tsá²mɨ³ tsá² jmɨ́¹ ñí²cuo² tsá² hí³, jáun² tsá²ñuh² la³ hí³ má²lɨ́²jmú³ siáh³ tso³ juón¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","”Jmɨ́¹ zian² jan² tsá² hánh³ jmɨ́¹ quɨh³² jmáh³la³ cá² ñí¹ hmɨh³² chú³² jniá³, hmɨh³² zɨ́n¹³ pin³ hi³ lɨ́³ mí²ñi³² lino, hi³ cun³ tsa³háu² jlánh¹ jmɨ́¹ má²hiún² tsú² tsɨ́³ hi³ jmu² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ja³bí¹ jmɨ́¹jáun² jmɨ́¹ zian² jan² tsá² tia³mii², tsá² jmɨ́¹ jmáɨ² Lá¹, hi³ jmɨ́¹ lɨ́n³ mɨ³ho²¹. Tsá² hí³ jmɨ́¹ tsá²cuá² hué³² ho³hñú¹³ quioh²¹ tsá² hánh³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tsá² tia³mii² hí³ jmɨ́¹ hnió³ cuh³ jmáh³la³ má³² suh³² ñeh² mesa quioh²¹ tsá² hánh³ hí³. Hí¹ la³ tɨ³ tsáɨ² jmɨ́¹ já²táunh¹ hi³ ziunh³² ñí¹ lɨ́³ jáun² mɨ³ho²¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ jun³ tsá² tia³mii² hí³, jáun² cua³taunh²¹ tsá²cuú² tsá²ta³ Dió³² hi³ cua³quiáun³², hi³ tsa³cuá² cáun² ñí¹ chu²¹ quionh³ hla¹ Há²bran²¹. Ja³bí¹ tsá² hánh³ hí³ ca³jun³ siáh³, jáun² ca³ñí¹hón²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tá¹la³ má²cuá¹má²tso² tsú² jáun² tsɨ́³ quiu³juóu³² né³, ca³jɨ́e³ tsú² tɨ³ chi³cuú² ñí¹ uóunh³, ñí¹ cuá³ hla¹ Há²bran²¹ quionh³ hla¹ Lá¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jáun² ca³hóh³² tiá³ lɨ́n³² hi³ ca³juáh³: “Hnú² tia²¹ yeh³ Há²bran²¹, cuɨ́¹ lɨ́n¹³ nú² hi³ juo²³ jná¹³, cuéh³ hnú² Lá¹ nɨ́² jáɨ¹³ hi³ jmu³ jlɨh²¹ hna¹³ zí¹cuo² hi³ ja³hiéih³ zɨh³² jná¹³, hi³ jáun² lɨ³ cuóuh³, quí¹ jlánh¹ cuá¹má²tso¹ jná¹³ tsɨn³² ñí¹ chéi³ uóu³² lá²”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Tɨ³la³ hla¹ Há²bran²¹ hí³ ca³juáh³: “Hnú² jón³, cháu¹ hnú² honh² la³jɨ́³² hi³ chu²¹ jmɨ́¹ zia³² quián¹³ tá¹la³ jmɨ́¹ zian² nú² jáun², tɨ³la³ quioh²¹ Lá¹ lá² jmɨ́¹ zia³² jmáh³la³ hi³ huáh² tsɨ́³ bíh¹. Ta³né³² má²cuá³ tsá² lá² re² tɨn²; tɨ³la³ hnú² má¹ná¹, ca³tɨn¹ má¹tsoh¹ honh². ");
INSERT INTO csoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ja³bí¹ zia³² cáun² hná¹ jëh³ jueh³² lɨ́n³² ja¹ ñí¹ tiauh¹ dí², hi³ jáun² hí¹ jan² yáh³ tsá² cuá³ ñí¹ lá² tiá² lɨ́¹³ ngá¹³ tɨ³ ñí¹ nɨ́², uá¹ cun³ ca³lɨ³hnió³, sa³jun³ hí¹ jan² tsá² tionh² ñí¹ nɨ́² lɨ́¹³ ngá¹³ siáh³ tɨ³ lá²”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hi³ jáun² tsá² jmɨ́¹ hánh³ hí³ ca³juáh³ siáh³: “Mɨ́²³ jná¹³ ñí¹con² hnú² tia²¹ yeh³, ¿há¹ tiá² zen¹³ hnú² tiá³ Lá¹ nɨ́² hñú¹³ ñuh³² jná¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ñí¹ tionh² hñá³ renh² jná¹³, hi³ tsa³lienh³ tsú² renh² jná¹³? Hi³ jáun² tiá² ja³táunh¹ tsú² ñí¹ cuá¹má²tso¹ jná¹³ lá² tsɨn³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Tɨ³la³ hla¹ Há²bran²¹ ca³juáh³: “Má²raunh³² bíh¹ tsú² liei²¹ quioh²¹ hla¹ Moisés, jɨ³ jáɨ¹³ quioh²¹ tsá² lɨn³ hí³ *tɨ³² jë¹ Dió³² nɨ́² siáh³; ¡cuɨ́¹ nie¹³ tsú² jáɨ¹³ jáun²!” ");
INSERT INTO csoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jáun² tsá² hánh³ hí³ ca³juáh³ siáh³: “Tson² bíh¹ la³ má²lɨ́²juah²¹ hnú² nɨ́² tia²¹ yeh³ Há²bran²¹, tɨ³la³ nɨ́¹juáh³ jan² tsá² má²ca³jenh¹³ ja¹ tsá² má²cá²tsan³ la³ tsó³² hi³ tsa³lienh³ tsá² hí³, jáun² cu³tí³ záɨ³² bíh¹ tsú² jmɨ́¹ tsɨ́³”. ");
INSERT INTO csoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jáun² hla¹ Há²bran²¹ ca³ngáɨ³ siáh³: “Nɨ́¹juáh³ tiá² hnió³ yáh³ tsú² ne³ jáɨ¹³ quioh²¹ hla¹ Moisés, sa³jun³ jáɨ¹³ quioh²¹ tsá² lɨn³ hí³ tɨ³² jë¹ Dió³² jmɨ́¹tin², jáun² sa³jun³ tónh³² bíh¹ tsú² ta²¹ jáɨ¹³ hi³ juáh³ jan² tsá² ca³jenh¹³ ja¹ tsá² má²cá²tsan³”. ");
INSERT INTO csoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―Cu³tí³ tiá² chau²¹ jmáɨ¹ hi³ juáh¹³ hi³ tiú²uú² zia³² hi³ jmu³ hi³ tánh³² tsáu² tso³, tɨ³la³ jlánh¹ juo²³ tsá² jmu² hi³ tsá²mɨ³cuóun² raɨnh²¹ tsú² tanh³² tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jlánh¹ bíh¹ re² sá¹jmɨ́¹ hi³ tónh³² tsú² zié³ láɨ¹ tsá² la³ hí³, hi³ chí¹hñéih²³ cáun² tá² quɨ́n¹ pa²¹ lɨ́n²¹, hi³ jáun² jmɨ́¹ taun³ tsú² hñu³ jmɨ́²miih²¹ cha³ jmɨ́¹ jmu³ tsú² hi³ jan² tsá¹míh¹ jmu³ tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Jáun² jmúh¹³ hnoh² hua³hín¹³ hi³ tiá² jmúh¹³ náh² la³ jáun². ”Nɨ́¹juáh³ jan² renh² hnú² ca³jmú³ hlah³ ñí¹con² nú², hniáuh³² hlɨ́¹ lienh¹ nú² tsú²; jáun² nɨ́¹juáh³ ca³za³ tsú² jmɨ́¹ tsɨ́³ né³, jáun² jmúh¹³ hnú² juenh² honh². ");
INSERT INTO csoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Uá¹jinh¹ quiau³ jéin³² cú² jmáɨ¹ jmu² tsú² hlah³ ñí¹con² nú², hi³ jáun² quiau³ jéin³² siáh³ mɨ³² tsú² uu³i³tso³ ñí¹con² nú², hi³ juáh³ tsú² hi³ tiú²uú² hi³ jmu³, jáun² hniáuh³² bíh¹ jmúh¹³ hnú² juenh² honh² ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jmɨ́¹jáun² tsá² ná¹lɨ́n³ hí³ *tɨ³² tsá² quian³² jë¹ Dió³² ca³záɨh³ la³ lá² Tɨ³² Juo¹³ dí²: ―Hnú² Tɨ³², jmúh¹³ hnú² hi³ tɨ³ lɨ³mí¹ niau²¹ cáun² tsɨ́³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jáun² Jesús ca³juáh³: ―Sá¹ hi³ jmɨ́¹ ná¹tioh³ cáun² honh² náh², uá¹jinh¹ ma³pih²¹ lɨ́n²¹ la³ cun³ tí³ cá² máɨ³ mɨ³ mostaza, jáun² jmɨ́¹ lɨ́¹³ bíh¹ juoh¹ hnoh² hmá² sí² náɨ² lá²: “Cuɨ́¹ cáɨ² hnú² ñí¹ chi²¹ nɨ́², cuɨ́¹ cha³jná¹ hnú² hñu³ jmɨ́²miih²¹”, jáun² hmá² lá² jmɨ́¹ má²taunh¹³ bíh¹ hnoh² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","”Nɨ́¹juáh³ zian² jan² tsá² quian²¹ náh², hi³ cuɨ́²ñí¹quiáh² hué³², ho³ hi³ cuɨ́²ñí¹jmú¹³ hua³hí¹³ jáh³ joh² náh² ñí¹ lɨ́³ ñí¹náɨ² quián¹³ náh², jáun² nɨ́¹ má¹cuanh³² tsá² hí³ ñéih³ né³, ¿tiá² né¹ hí¹ juouh³² náh² tsá² hí³: “Ña³², ñá²ñí³, ñá²jmu³ má³²”? ");
INSERT INTO csoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ján¹han²¹, tiá² juáh²³ yáh³ hnoh² la³ nɨ́², tɨ³la³ hnoh² dá² juáh³ la³ lá² bíh¹: “Cuá²jmu³ hua³jan²¹ má³² hi³ cuh²¹ jná¹³, cuá²quih³² hmɨh³² tiáu², jáun² cuéh¹ hnú² la³jɨ́³² hi³ hnó³² jná¹³ má¹tɨ³ ñí¹jmu¹ jná¹³ má³². Jáun² nɨ́¹ má¹laɨ³² jáun² jná¹³ má³² né³, má²jmúh¹³ hnú² siáh³ huen²”. ");
INSERT INTO csoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Hí¹ hiáuh²³ tsá² quian²¹ hí³ tiá¹hmah¹ nɨ́¹juáh³ má²lɨ́²ma³tí³² la³jɨ́³² héih³² quioh²¹ juo¹³? Tiá² lin¹ tiá¹hmah¹ hiáuh²³ yáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jáun² hnoh² né³, nɨ́¹juáh³ ma³tih²¹ náh² la³jɨ́³² héih³² hi³ ca³hian³, jáun² má¹jáun² ca³tɨn¹ hnoh² juáh¹³ la³ lá²: “Jnoh¹ láɨ³ tsá² quian²¹ tiá² lin¹ ñí¹ jmu³ ta²¹, quí¹ cáun² ca³jmú¹³ jnoh¹ la³ cun³ hi³ jmɨ́¹ hniáuh²¹ má²ca³jmú¹³ bíh¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jáun² ngau³ siáh³ Jesús juɨ³² má²hún¹ hi³ tsó³² tɨ³ já¹ juú² Jerusalén. Jáun² ca³nga² tsú² hué¹³ tsá² hɨ́n¹³ tɨ³ Samaria, jɨ³ hué¹³ tsá² hɨ́n¹³ tɨ³ Galilea nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jmɨ́¹ cá¹chó²¹ tsú² jáun² ñí¹ nio¹ cáun² juú² míh¹, jáun² né³, quian³ tsá² ná¹lɨ́n³ mɨ́¹uɨ́³ *mɨ³ho²¹ péin³ ca³ja³taunh²¹ má²janh² tɨ³ juɨ³² ñí¹ cuá¹ja³² jáun² Jesús. Tá¹la³ tionh² ñí¹ uóunh³ jáun² tsú², ");
INSERT INTO csoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ca³hléh³ tiá³, hi³ ca³juáh³: ¡Hnú² Tɨ³² Jesús, cuɨ́¹ ja² mií³ honh² hnú² quiú¹³ jnoh¹! ");
INSERT INTO csoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jmɨ́¹ ca³jɨ́en³² jáun² Jesús tsá² hí³, jáun² ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh², cuá²ma³jnia¹³ náh² ñí¹con² mí²tsáu². Jáun² tá¹la³ jmɨ́¹ má²hí¹tsá²táunh¹ jáun² hú¹ juɨ³² bíh¹ tsá² hí³, ca³lan³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jáun² jan² tsá² hí³ ca³jính³² tɨ³ ñí¹ zenh¹ Jesús jmɨ́¹ ca³jɨ́e³ jáun² hi³ má²laɨn³², hi³ hí¹hleh³² tiá³ lɨ́n³² hi³ hí¹má²quien² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jmɨ́¹ cuan¹ tsú² jáun² ta³ ñí¹ Jesús né³, ca³di³jñí³² hi³ ca³jmú³ cuá¹hin³ ca³la³ tɨ³ hué³², hi³ ca³cué³ tiá¹hmah¹. Tsá² ca³jính³² hí³ má¹ná¹, tsá² hɨ́n¹³ tɨ³ hué¹³ Samaria bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jáun² Jesús ca³ngáɨh³ tsá² hí³: ―¿Haun¹³ juáh¹³ tá¹ quian³ hnoh² má²laɨn³²? ¿Ha³ jinh¹ ja³taunh²¹ tsá² ñu³ hí³ né³? ");
INSERT INTO csoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Hí¹ jmáh³la³ jan² tán¹ *tsá²cá²jo²¹ lá² uá¹ ca³jính³² hi³ ma³quien² Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jáun² Jesús ca³záɨh³ tsá² hí³: ―Náu², cuánh². Má²laɨn³² nú², quí¹hliá² lɨ́²cháh¹ nú² cáun² honh² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jmɨ́¹ lɨ²¹ jáun² né³, tsá² *fariseos ca³ngáɨh³ Jesús, hi³ ca³juáh³: ―¿Lɨ́h³ zen³ Dió³² tsá² hau³ jáɨ¹³ hué³² lá² quiú¹³ dí²? Jáun² Jesús ca³ngáɨ³: ―Chau²¹ bíh¹ jmáɨ¹ hi³ cuán¹³ tsá² má²ca³hión³² hí³ Dió³², tɨ³la³ jun³juáh¹³ lɨ́¹³ cú²tiú² cú²jan³² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sa³jun³ lɨ́¹³ juáh³ tsáu²: “Tɨ³ lá² má²cuá¹ho² tsú² jáɨ¹³”; sa³jun³ lɨ́¹³ juáh³ tsú² siáh³: “Ñí¹ zio¹ má²cuá³ tsú²”. Quí¹ tsá² hí³ dá² má²ngɨ³² bíh¹ ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jmɨ́¹jáun² ca³záɨh³ tsú² tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―Chau²¹ jmáɨ¹ hi³ lɨ³ hniá¹ lɨ́n²¹ hnoh² hi³ jná¹³ Jon² tsá²mɨ³cuóun² já¹ñí³² ná¹ ja¹ quián¹³ hnoh², uá¹jinh¹ cú² jmáɨ¹; tɨ³la³ tiá² cáun² lɨ́¹ lɨ́¹³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Má¹jáun² lɨ³ zian² tsá² juáh³: “Tɨ³ lá² má²cuanh³²”; ho³lá²dá² juáh³ tsú² siáh³: “Tɨ³ ó³² má²cá²jnia³”. Tɨ³la³ ha³ lɨ́² lɨ́¹ cua³táunh¹ náh² cu³hna²¹ tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Quí¹ la³jmɨ́¹ hia³² sɨ́² quioh²¹ miíh³² jo²¹ cáun², hi³ jáun² taɨ³² ca³la³ tɨ³ jo²¹ cá² táun², la³ jáun² bíh¹ lɨ́¹³ nɨ́¹ má¹jaunh³² jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Tɨ³la³ la³ñí¹ tín² ca³tɨn¹ jná¹³ má¹tso¹ lɨ́n²¹ tsɨn³²; hi³ tsá² zian² né³² zeh³ jná¹³ tɨ³ có³². ");
INSERT INTO csoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Quí¹ jmáɨ¹ hi³ jáunh¹³ jná¹³ Jon² tsá²mɨ³cuóun², lɨ́¹³ la³jmɨ́¹ lɨ²¹ jmáɨ¹ hi³ jmɨ́¹ zian² hla¹ Noé. ");
INSERT INTO csoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tsá² jmɨ́¹ zian² jmɨ́¹jáun² cá² ñí¹ ca³tiánh³ ná¹cuú² ná¹hɨ́nh²³ bíh¹, hi³ ná¹jéinh³² siáh³ cuo², ja³ tsá² cuen² tsáu² jon² siáh³ hi³ jéinh³² cuo², ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ ca³hi³ Noé hñu³ cuó² jueh³² jáun². Jáun² jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ ca³ja³tsauh²¹ jmáɨ² né³, la³jɨ́n³² bíh¹ tsá² hí³ ca³hiá² cá²tsan³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ja³bí¹ la³ jáun² siáh³ ca³lɨ³ jmáɨ¹ hi³ jmɨ́¹ zian² hla¹ Lot. Tsá² jmɨ́¹ zian² jmɨ́¹jáun² uá²jaɨ³² cáun² lɨ́¹ ca³cuu³ ca³hɨnh³ bíh¹, hi³ cá² ñí¹ zia³² hi³ ná¹quí² ná¹la³² bíh¹ jɨ³ hi³ tɨ́² hnaɨh³² siáh³; hi³ cá² ñí¹ zia³² hi³ ná¹jñí² ná¹hó²³ bíh¹ ca³tiánh³, hi³ cáun² ta²¹ tiá² lɨ³ hñú¹³ bíh¹ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Tɨ³la³ jmɨ́¹ cuá¹han³ jáun² hla¹ Lot juú² Sodoma ñí¹ jmɨ́¹ cuá³ né³, jmɨ́¹jáun² ca³ziú² cá²súh³² juɨ²¹ quɨ́n¹ azufre hi³ hún¹ sɨ́² chéi³ lɨ́n³² hi³ ca³súh³² chi³cuú². Cun³quionh³ hi³ jáun² bíh¹ ca³hiá² cá²tsan³ la³jɨ́n³² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","La³jmɨ́¹ ca³jmú³ jáun² tsá² hí³ bíh¹ jmu³ tsú² má¹jáun², jmáɨ¹ hi³ ma³jnia³² jáun² Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","”Nɨ́¹ má¹cá²chó³² jmáɨ¹ jáun² né³, tsá² cuá¹tsɨ²¹ tsáɨh³ hñú³ máɨ² tsáɨh³ quioh²¹, tiá² hniáuh³² yáh³ son¹³ hi³ tsa³quián³ hi³ nio² ñéih³ quioh²¹, hniáuh³² la³juɨ³² cuon³ bíh¹ tsú²; hi³ nɨ́¹juáh³ tsá² cuá¹hún¹ ñí¹náɨ² né³, tiá² hniáuh³² yáh³ tsánh³² tsú² tɨ³ ñí¹ zeh¹ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Jáun² cháu¹ náh² honh² la³ cun³ hi³ ca³quiúnh³² jáun² hla¹ tsá²mɨ³ ñí²cuo² Lot hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nɨ́¹juáh³ tsá² hnió³ lión³² hnga² jmɨ́²chí³ quioh²¹, tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹, tɨ³la³ nɨ́¹juáh³ tsá² já²hín³ jmɨ́²chí³ quioh²¹ cun³ñí¹ hi³ ca³tɨn¹ jná¹³ né³, tsá² la³ hí³ bíh¹ tɨ³ liáun³. ");
INSERT INTO csoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","”Juanh³² jná¹³ ñí¹con² hnoh², hi³ má¹ca³niéi² jmáɨ¹ jáun², má¹jáun² má²ná¹cuóun¹ gon³ tsáu² ñí¹ jen³; jan² tsá² hí³ tsánh³² hñu³mɨ³cuú², hi³ jan² né³ tá¹ron¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nɨ́¹ má¹jáun² siáh³, gon³ tsá²mɨ³ ná¹quiuh³² cán¹; jan² bíh¹ tsá² hí³ tsánh³², hi³ jan² né³ tá¹zanh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ja³bí¹ má¹jáun², gon³ tsá²ñuh² ná¹jmu² ta²¹ ñí¹náɨ², jan² bíh¹ tsá² hí³ tsánh³² hñu³mɨ³cuú², hi³ jan² né³, tá¹zanh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jmɨ́¹ má²lɨ́²niéi³² tsú² jáun² hi³ juáh³ Jesús la³ nɨ́², jáun² ca³ngáɨ³ tsú²: ―Hnú² Tɨ³², ¿ha³ dá² jinh¹ lɨ́¹³ hi³ má²lɨ́²juah²¹ hnú² nɨ́²? Jáun² Jesús ca³juáh³ siáh³: ―Lɨ³ lin¹ bíh¹ jmáɨ¹ jáun² la³jmɨ́¹ lɨ́² lin¹ ñí¹ rá²jún¹ jáh³ cun³quionh³ hi³ jlánh¹ cuú² ngɨh³² tú²jue³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hi³ jáun² Jesús ca³hɨ́eh³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³tɨ²¹ liéinh³² tsú² Dió³² jmáɨ¹ ca³la³ jɨ́³², hi³ tiá² hniáuh³² ma³tsan² tsú² tsɨ́³. Jáun² ca³jmú³ dí² cáun² jáɨ¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","hi³ lɨ́³ la³ lá²: ―Jmɨ́¹ zian² jan² jue²¹ jmɨ́¹ cuá³ cáun² juú². Tsá² lɨ́n³ jue²¹ hí³ tiá² ta²¹ jmɨ́¹ tanh² yáh³ Dió³², sa³jun³ jmɨ́¹ tanh² bíh¹ hó¹ñí¹ tsá²co¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ja³bí¹ juú² jáun² jmɨ́¹ zian² siáh³ jan² tsá²mɨ³ hnáɨ³. Tsá²mɨ³ hí³ jmɨ́¹ tsá²jɨen³ hiú² cuóh³² lɨ́n³² jue²¹ hí³, hi³ jmɨ́¹ zaɨh³² dí² jue²¹ hí³ la³ lá²: “Ma³ré¹³ tiá³ uu³mí²tsɨ³² quion²¹ jná¹³ quiúnh¹ ná¹ tsá² hau²”. ");
INSERT INTO csoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tɨ³la³ hliáun³ jmáɨ¹ bíh¹ ca³nga² hi³ tiá² jmɨ́¹ hei³² jue²¹ hí³ hi³ ma³re² hniéi² jáun². Tɨ³la³ ca³chó³² jmáɨ¹ hi³ ca³lɨn¹³ jue²¹ hí³ la³ lá²: “Uá¹jinh¹ tiá² ta²¹ tanh³² jná¹³ Dió³², sa³jun³ tanh³² jná¹³ hó¹ñi³² tsá²co¹, ");
INSERT INTO csoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","tɨ³la³ cun³ñí¹ hi³ jlánh¹ hiú² cuóh³² ja³² tsá²mɨ³ nɨ́² hi³ ñi³jmu¹ liúnh¹, hi³ jáun² cu³tsa³² cuɨ́¹ má¹ré¹³ jná¹³ cú²jueh³², hi³ jáun² tiú²uú² ja³ma³tsan² tsú² tsɨn³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jáun² Tɨ³² Juo¹³ dí² ca³juáh³: ―La³ jáun² bíh¹ ca³juáh³ jue²¹ hláɨh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Há¹ tiá² ma³re² Dió³² hniéi² quioh²¹ tsá² má²ná¹quiánh¹ joh¹, tsá² ná¹hiú² ná¹mɨ³² la³ huá² la³ jma²? ¿Hí¹ ma³lé³ tsú² hi³ ma³hau³? ");
INSERT INTO csoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Juanh³² jná¹³ ñí¹con² hnoh², hi³ tia³juɨ³² bíh¹ ma³re² Dió³² hniéi² quioh²¹ tsá² joh¹. Tɨ³la³ nɨ́¹ má¹jaunh³² jná¹³ Jon² tsá²mɨ³cuóun² né³, ¿hí¹ chanh²¹ bíh¹ jná¹³ tsá² má²ná¹taunh² ta²¹ ñí¹ hué²¹ lá² nɨ́¹ má¹jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hi³ jáun² Jesús ca³jmú³ cáun² jáɨ¹³ ñí¹con² tsá² jmɨ́¹ ná¹lɨ́n²³ hí³ hi³ chun¹ hmóu³², tsá² jmɨ́¹ ná¹lɨ́n²³ hí³ hi³ jun³ lin¹ yáh³ tsá² siánh³, hi³ ca³juáh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Jmɨ́¹ zian² gon³ tsá²ñuh² hi³ ca³ñí¹lienh¹³ Dió³² hñu³ cuáh³² chín¹. Jan² tsá² hí³ tsá² *fariseo, hi³ jan² siáh³ *tsá² chi² hmah²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Tsá² fariseo hí³ ca³jmú³ zenh² hi³ ca³liéinh³² Dió³², hi³ ca³juáh³ la³ lá²: “Hnú² Dió³² Juóu³² jná¹³, cué²³ jná¹³ tiá¹hmah¹ hnú² quí¹ tiá² lɨ́n³ yáh³ jná¹³ la³jmɨ́¹ lɨ́n³ tsá² siánh³, la³jmɨ́¹ lɨ́n³ tsá² háɨn², tsá² hláɨh¹, tsá² lɨ́¹ jmu² lɨ́¹ tsau³² nɨ́² siáh³; sa³jun³ lɨ́n³ jná¹³ la³jmɨ́¹ lɨ́n³ tsá² chi² hmah²¹ zenh² ó³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jná¹³ má²hɨen²¹ tun³ jéin³² cun³ jña³ jmáɨ¹, hi³ jɨ́enh²³ jná¹³ siáh³ ñí¹con² hnú² cáun² la³ cun³ quia³ quioh²¹ la³jɨ́³² hi³ láɨ²³ ná¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Tɨ³la³ tsá² chi² hí³ hmah²¹ ca³ta³zanh¹ ñí¹ uóunh³ ca³lá², sa³jun³ ca³ziauh³ bíh¹ tsá² hí³ ñí¹ chi³cuú²; hi³ jáun² cáun² ca³ta³dí¹quien² ñí¹ tsɨ́³ bíh¹, hi³ dí¹juáh²³: “¡Hnú² Dió³², cuɨ́¹ ja² mií³ honh² hnú² ñí¹con² jná¹³, tsá² ren² ná¹ tso³!” ");
INSERT INTO csoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jáun² Jesús ca³juáh³: ―Juanh²¹ jná¹³ ñí¹con² hnoh², tsá² chi² hí³ hmah²¹ bíh¹ tsá² má²jɨ² jmɨ́¹ tsɨ́³ jmɨ́¹ ngah²¹ hñú¹³; tɨ³la³ tsá² fariseo hí³ má¹ná¹, tiá² jɨ² yáh³ jmɨ́¹ tsɨ́³ jmɨ́¹ ngah²¹. Quí¹ tsá² jmu² pan¹ hnga², tsá² la³ hí³ tɨ³ má²méih³ bíh¹ hi³ quien²; tɨ³la³ tsá² tiá² jmu² quien² hnga² má¹ná¹, tsá² la³ hí³ bíh¹ tɨ³ jlánh¹ lɨ³ quien². ");
INSERT INTO csoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ja³bí¹ jmɨ́¹jáun² cua³jan² tsáu² dáɨn² jon² ñí¹con² Jesús, hi³ hnió³ tsú² hi³ Jesús tin³ cuo² dáɨn². Tɨ³la³ jmɨ́¹ ca³jɨ́e³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ jmu² tsá² hí³ la³ jáun² né³, jáun² ca³jin³ tsú² tsá² ná¹jan² hí³ dáɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jmɨ́¹jáun² ca³teh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³záɨh³ dí² la³ lá²: ―Cuéh³ náh² tsá¹míh¹ nɨ́² jáɨ¹³, cuɨ́¹ ja³táunh¹ ñí¹con² jná¹³, ha³ lɨ́² jnɨ́² náh² juɨ³² quioh²¹. Quí¹ tsá² lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá¹míh¹ nɨ́² bíh¹ lɨ́¹³ tónh³² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jú¹ tson² juo³ jná¹³ hnoh²: Lɨ³ua³ jan² tsá² tiá² he² héih³² quioh²¹ Dió³² la³jmɨ́¹ he² tsá¹míh¹, tsá² la³ hí³ cu³tí³ tiá² lɨ́¹³ hí³ jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jmɨ́¹jáun² ca³ngáɨ³ jan² tsá² chín¹ ñí¹con² tsá² *judíos ñí¹con² Jesús, hi³ ca³juáh³: ―Hnú² Tɨ³² chun¹, ¿he³ bíh¹ hniáuh³² jmu¹ jná¹³ hi³ jáun² lɨ́¹³ lɨ³ zian² jná¹³ la³ cun³ jmɨ́¹hi³nio²? ");
INSERT INTO csoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jáun² Jesús ca³záɨh³ tsá² hí³: ―¿He³ láɨh³² juáh³ hnú² hi³ jná¹³ tsá² chun¹? Hí¹ jan² yáh³ tsá² chun¹ tiá² zian², jɨ́³²la³ jan² Dió³² bíh¹ chun¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Má²ñíh¹ bíh¹ hnú² la³ cun³ hi³ rá¹juáh³ jáun² héih³² quioh²¹ Dió³², hi³ juáh³ la³ lá²: “Ha³ lɨ́² jmú² náh² juón¹, ha³ lɨ́² jngɨh³ náh² tsáu², ha³ lɨ́² háɨn² náh², ha³ lɨ́² lɨ́¹ ma³tson¹³ náh² jú¹ tɨ́¹jáɨ², tianh³² náh² ta²¹ ñeh² mí²ziúh²”. ");
INSERT INTO csoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jáun² tsá² hí³ ca³juáh³: ―La³jɨ́³² bíh¹ hi³ nɨ́² má²ca³ma³ti²¹ jná¹³ la³ cun³ jmɨ́¹ míh² ná¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jmɨ́¹ má²lɨ́²niéi³² jáun² Jesús jë¹ tsá² hí³ né³, ca³juáh³: ―Cun³ jáun² zia³² bíh¹ cónh³í¹ cáun² hi³ hniáuh³² jmúh¹³ nú²: cuánh², cuá²hnáɨ¹ la³jɨ́³² hi³ zia³² quián¹³, hi³ jáun² tsoh³ quɨe³ jáun² ñí¹con² tsá² tia³mii², hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ lɨ³ hánh³ nú² hñu³mɨ³cuú². Nɨ́¹ má¹lɨ³² jáun² né³, ña³² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² hí³ jáɨ¹³ nɨ́² né³, jlánh¹ hlaɨh³ ta³no¹ tsɨ́³, quí¹hliá² jlánh¹ hánh³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jmɨ́¹ ca³jɨ́e³ jáun² Jesús hi³ hlaɨh³ má²nio² tsɨ́³ tsá² hí³, jáun² ca³juáh³ la³ lá²: ―¡Hénh³ ma³ jlánh¹ juóuh³² hi³ hí³ jan² tsá² hánh³ jo³cuo² Dió³²! ");
INSERT INTO csoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tɨ³ jlánh¹ bíh¹ huán¹ tsɨ́³ ngá¹³ jáh³ cánh¹ téh²³ tsú² camello chí² léh¹³ mɨ³quɨe³, la³ cónh³ bíh¹ hi³ hí³ jan² tsá² hánh³ jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² tionh² hí³ jáɨ¹³ nɨ́² né³, ca³juáh³: ―Hi³ jáun² né³, ¿hin² bí¹ dá² tsánh² la³ lɨ́¹³ liáun³? ");
INSERT INTO csoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Zia³² hi³ tiá² lɨ́¹³ jmu³ tsá²mɨ³cuóun², tɨ³la³ Dió³² bíh¹ Tsá² tɨn² jmu³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Hi³ jáun² Pé¹ ca³záɨh³ Jesús la³ lá²: ―Sá¹nɨ́² jɨe³, jnoh¹ má²ca³chá¹³ tɨ³ có³² la³jɨ́³² hi³ jmɨ́¹ zia³² quiú¹³, hi³ jáun² má²ngɨ́¹ jnoh¹ quiúnh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jáun² jmɨ́¹jáun² ca³záɨh³ siáh³ Jesús tsá² hí³ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ lɨ³ua³ jan² tsá² má²ca³tú³ hñú¹³, hi³ má²ca³chan³ siáh³ jméi² mí¹ziú¹³, raɨnh²¹ tsú², ñí²cuo² tsú², jɨ³ jon² tsú² nɨ́² siáh³, cun³ñí¹ hi³ tónh³² tsú² tsáu² jo³cuo² Dió³², ");
INSERT INTO csoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tsá² la³ hí³ tɨ³ hliáun³ hiáuh³ bíh¹ ñí¹ hué²¹ lá² la³ cónh³ bíh¹ hi³ má²ca³chá³ tsú² jáun² tɨ³ có³², hi³ jáun² má¹jáun² hiáuh³ tsú² siáh³ hi³ lɨ́¹³ zian² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hi³ jáun² Jesús ca³teh³ siáh³ tsá² quian³tun³ hí³ tɨ³ la³ có³², hi³ ca³záɨh³ dí² la³ lá²: ―Sá¹nɨ́² jɨe³, ta³né³² má²hí¹uú²³ dí² tɨ³ já¹ juú² Jerusalén, ñí¹ lɨ́¹³ lɨ³tí³ ca³la³ jɨ́³² hi³ rá¹juáh³ jáun² ñí¹ Sí² hi³ ca³jmú³ tsá² lɨn³ hí³ *tɨ³² jë¹ Dió³² jmɨ́¹tin², la³jɨ́³² jáɨ¹³ hi³ ca³tɨn¹ Tsá² lɨ́n³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tsá² hí³ bíh¹ jɨenh³ tsá² judíos ñí¹con² *tsá²cá²jo²¹, hi³ qui³ cáuh³² tsú² cú²nga¹, hi³ tu³ hión³² tsú², hi³ tiu³ hñéi³² tsú², ");
INSERT INTO csoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","hi³ quiu³ pan³ tsú² siáh³, hi³ nɨ́¹ má¹lɨ³² jáun² né³, jngah³ tsú²; tɨ³la³ ñí¹ má²cá²hnɨ́² jmáɨ¹ jáun² má¹ná¹, jenh¹³ bíh¹ jná¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tɨ³la³ tiá² ca³ngɨ¹³ yáh³ tsá² hí³ hi³ ca³juáh³ jáun² Jesús la³ nɨ́², cu³tí³ tiá² ca³lɨ³tsɨn² bíh¹ tsú² he³ dá² jmɨ́¹ niéih³ jáɨ¹³ jáun², quí¹hliá² jáɨ¹³ jáun² jmɨ́¹ lɨ́³ jú¹ jnɨ² bíh¹ hi³ ca³tɨn¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jmɨ́¹ má²ñí¹chau²¹ Jesús já¹ juú² Jericó. Can³² juɨ³² jáun² jmɨ́¹ cuá³ jan² tsá² ten³, hi³ jmɨ́¹ cuá¹mɨ³² cú¹dáɨn³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jmɨ́¹ ca³náɨ³² jáun² tsá² ten³ hí³ hi³ juóun³² lɨ́n³² tsáu² má²ñí¹hí¹já²táunh¹, jáun² ca³ngáɨ³ he³ dá² la³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jáun² tsáu² ca³juáh³: ―Jesús, tsá² ja³ juú² Nazaret bíh¹ cuá¹ja³² ñí¹zio¹. ");
INSERT INTO csoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jáun² tsá² ten³ hí³ ca³hléh³ tiá³ lɨ́n³² hi³ ca³juáh³: ―¡Hnú² Jesús, jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹, cuɨ́¹ ja² mií³ honh² hnú² ñí¹con² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jáun² tsá² hí¹tsá²táunh¹ hí³ chí¹ján³ ca³jin³ tsá² ten³ hí³, hi³ jmɨ́¹ hnió³ tsú² cuá³² tsá² hí³ ta³máɨh³. Tɨ³la³ tsá² ten³ hí³ má¹ná¹, tɨ³ lɨ³mí¹ tiá³ ca³hléh³ bíh¹ hi³ ca³juáh³: ―¡Hnú² jón²zɨ́h¹ hla¹ Dá²vi²¹, cuɨ́¹ ja² mií³ honh² hnú² ñí¹con² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Hi³ jáun² Jesús ca³náu², hi³ ca³jmú³ héih³² hi³ tsa³quian³ tsú² tsá² ten³ hí³. Jmɨ́¹ cuan¹ jáun² tsá² ten³ hí³ ta³ñí¹ dí² né³, ca³záɨh³ dí² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿He³ jmɨ́¹ hnáuh² hnú² jmu¹ jná¹³ ñí¹con² nú²? Jáun² tsá² ten³ hí³ ca³ngáɨ³: ―Hnú² Juóu³² jná¹³, hnó³² jná¹³ hi³ jnia³ siáh³ mɨ́¹ñi³². ");
INSERT INTO csoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jáun² Jesús ca³záɨh³ tsá² hí³: ―¡Cuɨ́¹ jnia¹ yáh³! Má²laɨn³² hnú² quí¹hliá² lɨ́²cháh¹ nú² cáun² honh². ");
INSERT INTO csoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³jnia³ siáh³ mɨ́¹ñí¹ tsá² hí³, jáun² ngau³ cu³chin¹ cu³hna²¹ Jesús hi³ hí¹má²quien² Dió³². Hi³ jáun² ca³la³ jɨ́n³² tsá² ca³jɨ́e³ hi³ jáun² ca³ma³tsú² ma³jónh³² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, hi³ Jesús já¹ juú² Jericó. ");
INSERT INTO csoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Juú² jáun² jmɨ́¹ zian² jan² tsá² hánh³ jmáɨ² Zaqueo. Tsá² hí³ jmɨ́¹ chín¹ ñí¹con² *tsá² chi² hmah²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tsá² hí³ jlánh¹ ca³lɨ³hnió³ jɨ́e³ nɨ́¹juáh³ hin² dá² tsánh² hí³ Jesús; tɨ³la³ tiá² lɨ³ yáh³ jɨ́en³² tsú², quí¹ juóun³² lɨ́n³² bíh¹ tsáu² jmɨ́¹ ná¹ngɨh³² ñí¹ jáun², hi³ hnga² siáh³ Zaqueo hí³ jlánh¹ tsa¹; jáun² tiá² ca³lɨ³ yáh³ jɨ́en³² tsú² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jáun² cu³tsa³² chí¹ján³ tsú² cú²jueh³² ngau³, hi³ ja³uu³² tsɨ³ hmá² sí² náɨ² chi²¹ tɨ³ juɨ³² ñí¹ tsó²¹ Jesús, hi³ jáun² lɨ́¹³ jɨ́en³² dí², quí¹hliá² juɨ³² jaun³² ngá¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jmɨ́¹ cá¹chó²¹ jáun² Jesús ñí¹ chi²¹ hmá² jáun² né³, ca³ziauh³ ñí¹ tsɨ³ hmá², jáun² ca³juáh³: ―Hnú² Zaqueo, tia³juɨ³² son² ñí¹ nɨ́², quí¹ né³² ca³tɨn¹ jná¹³ ñí¹jnioh² hñuh³² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jáun² Zaqueo la³juɨ³² ca³son² bíh¹, hi³ ca³hen³ Jesús ca³la³ hiún² lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jmɨ́¹ ca³jɨ́e³ jáun² tsá² ná¹ngɨh³² hí³ hi³ ngau³ Jesús hñú¹³ tsá² hí³, jáun² ca³ziu³ ca³hɨen³ dí² Jesús, hi³ ca³juáh³: ―¿He³ láɨh³² sa³ hñú¹³ jan² tsá² ren² tso³ bíh¹ ngau³ tsá² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jmɨ́¹ cá¹chánh²¹ jáun² Zaqueo hñú¹³ né³, ca³jmú³ zenh², hi³ ca³záɨh³ Jesús: ―Hnú² Tɨ³², sá¹nɨ́² niéi², ñí¹con² tsá² tia³mii² cué¹³ jná¹³ cá²tsó¹³ la³jɨ́³² hi³ zia³² quion²¹; hi³ ñí¹con² tsá² má²ca³ma³can¹³ jná¹³ né³, cué¹³ jná¹³ siáh³ quiún³ nió³ la³ cónh³ bíh¹ hi³ má²ca³háɨn³² jná¹³ jáun² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jáun² Jesús ca³juáh³ la³ lá² ñí¹con² tsú²: ―Né³² má²liáun³ tsá² hñú¹³ hñú³ lá², quí¹ cu³tí¹³ bíh¹ jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹ tsá² lá². ");
INSERT INTO csoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Quí¹ jná¹³, Jon² tsá²mɨ³cuóun², má²cuan² hi³ ja³hnáh³² ná¹ tsá² má²já²cuɨn³. Hi³ ja³lion¹ tsá² la³ hí³ bíh¹ jná¹³ ja³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","La³ má²ná¹náɨ³² jáun² bíh¹ tsá² hí³ jáɨ¹³ hi³ cuá¹hleh³² jáun² Jesús, jáun² ca³jmú³ siáh³ Jesús cónh³í¹ cáun² jáɨ¹³ ñí¹con² tsú², quí¹hliá² tsá² hí³ jmɨ́¹ má²ná¹lɨ́n²³ hi³ cu³diá²jan² bíh¹ ma³jnia³² Jesús hi³ hí³ bíh¹ dí² tsá² ca³hiáu³² Dió³² hi³ hau³ jáɨ¹³, cun³ñí¹ hi³ jmɨ́¹ má²ñí¹chau²¹ jáun² Jesús já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Hi³ jáun² bíh¹ ca³záɨh³ Jesús tsá² hí³ la³ lá²: ―Jmɨ́¹ zian² cá² mí¹zionh² tsá² cáun² hñú³ hi³ jmɨ́¹ ná¹quien². Jáun² jan² tsá² hí³ ngau³ ñí¹ uóunh³, la³ tɨ³ hué³² siáh³, hi³ ca³ñí¹mɨ́² jáɨ¹³ hi³ lɨ́¹³ lɨ́n³ ta²¹ juú²co¹, hi³ hu²¹ cuo² ñí¹ hliáun³; hi³ nɨ́¹ má¹lɨ³² jáun² jáunh³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ñeh² bíh¹ hi³ tsó³² tsú² jáun² ca³teh³ quian³ tsá² quian²¹, hi³ ca³tsóh³ dí² ma³ cú² mei²¹ héih³² quɨe³ *cú¹tiáu² ñí¹con² ma³ quin³² ma³ jan³² tsú². Jmɨ́¹jáun² ca³záɨh³ tsú² tsá² quian³ hí³: “Cuá²ma³hliáun¹³ náh² quɨe³ má²lɨ́²cué³ jná¹³ nɨ́², ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ jáunh¹³ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tɨ³la³ tsá²co¹ tsú² má¹ná¹, jmɨ́¹ ná¹hau² bíh¹. Hi³ jáun² jmɨ́¹ ngau²¹ tsá² hí³ né³, ca³zen³ tsú² tsá² ja¹ hmóu³² hi³ tsa³can³² jáɨ¹³, hi³ tsa³juah²¹ la³ lá²: “Cu³tí¹³ tiá² hnáu² jnoh¹ hi³ lɨ́n¹³ tsá² nɨ́² ta²¹ juú²co¹ jnoh¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tɨ³la³ cun³ jáun² ca³lɨ³hiáun¹ bíh¹ tsú² hi³ lɨ́n¹³ ta²¹; jmɨ́¹ lɨ²¹ jáun² né³, jaunh³ siáh³ juú²co¹. Jmɨ́¹ cuanh²¹ tsú² jáun² né³, ca³teh³ siáh³ tsá² quian²¹ hí³, tsá² ca³cuéh³ tsú² hí³ quɨe³, hi³ ca³ngáɨ³ tsú² nɨ́¹juáh³ ha³ cónh³ ca³ta³tsaɨh²¹ tsú² ma³ quin³² ma³ jan³². ");
INSERT INTO csoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jáun² tsá² ca³ma³jnia³² la³ñí¹ ta³ ñí¹ tsú² ca³juáh³ la³ lá²: “Hnú² juóu³² jná¹³, má²zia³² cónh³í¹ cú² mei²¹ héih³² cú¹tiáu² la³ cónh³ bíh¹ hi³ jmɨ́¹ ca³cháh¹ hnú² jáun² jo³uón³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jáun² tsá² má²lɨ́n³ hí³ ta²¹ ca³juáh³: “Jlánh¹ re² la³ nɨ́², hnú² bíh¹ jan² tsá² quian²¹ chun¹. Jmu¹ jná¹³ hi³ hnú² lɨ́n¹³ ta²¹ ñí¹con² quia³ juú², quí¹hliá² re² bíh¹ ca³jmuh³ hnú² cun³quionh³ cú¹pih²¹ hi³ ca³chá³ jná¹³ jáun² jo³ cuonh² nú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jáun² siáh³ siáh³ jan² ca³ma³jnia³² ta³ ñí¹ tsú², hi³ ca³juáh³: “Hnú² juóu³² jná¹³, má²zia³² hñá³ nio² hña³láu³ héih³² cú¹tiáu² la³ cónh³ bíh¹ hi³ jmɨ́¹ ca³cháh¹ hnú² jáun² jo³uón³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ja³bí¹ ñí¹con² tsá² hí³ ca³juáh³ tsú² siáh³ la³ lá²: “Jmu¹ jná¹³ hi³ hnú² lɨ́n¹³ ta²¹ ñí¹con² hñá³ juú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jáun² ca³ma³jnia³² siáh³ jan² tsá² siánh³ siáh³, hi³ ca³juáh³ la³ lá²: “Hnú² juóu³² jná¹³, lá² nio² quɨe³ hi³ jmɨ́¹ ca³cuéh¹ hnú² jáun² jná¹³. Cáun² ca³tsáɨh³² pá¹ñu²¹ bíh¹ jná¹³ quɨe³ jáun², hi³ ca³hmá³ jná¹³, ");
INSERT INTO csoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","quí¹hi³hliá² juénh² jná¹³ hnú². Quí¹hliá² ño¹ jná¹³ hi³ hnú² jan² tsá² huáh² tsɨ́³, hnú² jan² tsá² caun²³ hi³ tiá² ca³tɨn¹ nú² caun¹³, hi³ caun²³ hnú² siáh³ cáun² hi³ tiá² lɨ́²jñíh³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jmɨ́¹jáun² ca³juáh³ tsá² má²lɨ́n³ hí³ ta²¹: “Hnú² bíh¹ jan² tsá² quian²¹ hláɨh¹; cun³quionh³ jëh² nɨ́² huen² bíh¹ hnú² rá¹tsɨ³² jná¹³ héih³² ñí¹con² nú². Nɨ́¹juáh³ tson² ñíh¹ hnú² hi³ jná¹³ lɨ́n³ jan² tsá² huáh² tsɨ́³, jan² tsá² caun² cáun² hi³ tiá² ca³tɨn¹, jan² tsá² caun² hi³ tiá² ca³jñí³, ");
INSERT INTO csoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","hi³ jáun² jmɨ́¹ hniáuh²¹ bíh¹ jmuh²¹ hnú² ta²¹ quɨe³ nɨ́² quion²¹ jná¹³, uá¹jinh¹ hñú³ ñí¹ rá²tsɨ³² tsú² quɨe³ bíh¹ jmɨ́¹ cuá¹tionh² nú², hi³ jáun² jmɨ́¹ cuanh²¹ jná¹³ jmɨ́¹ má²lɨ́¹³ héih¹ jná¹³ hi³ má²tsɨn² quɨe³ quion²¹”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jáun² tsá² lɨ́n³ ta²¹ hí³ ca³jmú³ héih³² ñí¹con² tsá² tionh² ñí¹ jáun², hi³ ca³juáh³: “Quin³² náh² quɨe³ hi³ jmɨ́¹ nio² jo³cuo² tsá² lá², hi³ cueh¹ náh² tsá² ca³ta³tsaɨh²¹ nɨ́² cú² mei²¹ héih³² quɨe³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tɨ³la³ tsá² jmɨ́¹ tionh¹ hí³ ca³ngáɨ³: “Hnú² juo¹³ jnoh¹, já² má²zia³² bíh¹ cú² mei²¹ héih³² quɨe³ quioh²¹ tsú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Jáun² tsá² lɨ́n³ ta²¹ hí³ ca³juáh³ siáh³: “Juanh³² jná¹³, nɨ́¹juáh³ tsá² zia³² hi³ quioh²¹, tsá² la³ hí³ tɨ³ hliáun³ hiáuh³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tiá² zia³² quioh²¹ né³, tɨ³ quin³ bíh¹ tsú² la³ cun³ cú¹pih²¹ hi³ zia³² quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Hi³ jáun² ca³tɨn¹ la³jɨ́n³² tsá² hau² jná¹³ hí³ né³, tsá² tiá² jmɨ́¹ hnió³ hí³ hi³ lɨ́n¹³ jná¹³ ta²¹ ñí¹con², cuá²quian³² náh² hi³ má¹tsán¹³ náh² ta³ ñi³² jná¹³ lá²” ―ca³juáh³ tsá² má²lɨ́n³ hí³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́² né³, ngau³ siáh³ juɨ³² má²hún¹ hi³ chau²¹ tɨ³ Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jmɨ́¹ má²ñí¹chau²¹ tsú² jáun² juú² Betfagé, juú² nio² má²janh² có³² máh³ míh¹ Olivos, ñí¹ nio¹ siáh³ juú² Betania, jáun² ca³zen³ tsú² gon³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ tsa³táunh¹ chí¹ján³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Hi³ ca³záɨh³ dí² la³ lá²: ―Cuá²táunh¹ náh² juú² míh¹ nio² tɨ³ chí¹ján³ nɨ́², jáun² nɨ́¹ má¹ca³cha³táunh¹ náh² né³, chanh²¹ náh² jan² lo¹ búh¹ míh¹ hi³ cuá¹hñéih¹; jáh³ hí³ hí¹ jan² tiá² hin² má²ca³ñi³tsɨn¹. Jáun² cuá²zanh¹ náh² jáh³ hí³, hi³ ñá¹jan³² náh² tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nɨ́¹juáh³ zian² tsá² ca³ngáɨ³ ñí¹con² hnoh²: “¿He³ láɨh³² sa³ hnoh² yáh³ ná¹zanh¹ jáh³ nɨ́²?”, jáun² juoh¹ náh² tsú² la³ lá²: “Hliá² má²hniah³ ñí¹con² Tɨ³² Juo¹³ bíh¹ jnoh¹ jáh³”. ");
INSERT INTO csoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jáun² ja³taunh²¹ bíh¹ tsá² gon³ hí³, hi³ jáun² ca³chanh²¹ tsú² jan² lo¹ búh¹ míh¹ la³ cun³ hi³ má²lɨ́²juáh³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hi³ jáun² jmɨ́¹ má²ná¹záɨnh³² tsú² lo¹ míh¹ hí³, jáun² ca³jɨ́e³² tsá² joh¹ jáh³, jáun² ca³juáh³: ―¿He³ láɨh³² sa³ hnoh² yáh³ ná¹zanh¹ jáh³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jáun² tsá² gon³ hí³ ca³ngáɨ³: ―Hliá² má²hniah³ ñí¹con² Tɨ³² Juo¹³ bíh¹ jnoh¹ jáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jáun² ca³ñí¹jan² tsú² lo¹ búh¹ míh¹ hí³ tɨ³ ñí¹ zenh¹ Jesús. Jmɨ́¹jáun² ca³na³tsɨ́³ dí² ha¹ cu³hna²¹ jáh³ hí³. Jmɨ́¹ lɨ²¹ jáun² né³, ca³zion³ dí² Jesús cu³hna²¹ jáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tá¹la³ jmɨ́¹ hí¹tsau³² jáun² Jesús tɨ³ já¹ juú² Jerusalén né³, ca³qui³ ca³ja³ tsáu² ha¹ hú¹ juɨ³² ñí¹ cuá¹tsau³² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jmɨ́¹ cá¹chó²¹ tsú² jáun² ñí¹ má²lɨ́³ dí¹jɨ²³ máh³ Olivos tɨ³ juɨ³² Jerusalén, ca³la³ jɨ́n³² tsá² má²tanh² ta²¹ Jesús ca³ma³liáu³² hi³ hléh³² ca³la³ tiá³ lɨ́n³², hi³ hiún² lɨ́n³² tsɨ́³ tsú² ca³ma³tsu³ ma³jónh³² Dió³² ca³tɨ²¹ la³jɨ́³² hua³jueh³² hi³ má²ca³jɨ́e³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Hi³ ca³juáh³ tsú² la³ lá²: ―¡Cuɨ́¹ lɨ³ quien² bíh¹ Tsá² lɨ́n³ Re²¹, Tsá² cuá¹ja³² cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²! ¡Cuɨ́¹ tionh¹ bíh¹ tsá² zian² hñu³mɨ³cuú² cáun² hi³ re² hi³ tɨn²! Hénh³ ma³ chun¹ Dió³² Tsá² cuá³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jáun² ja¹ ñí¹ hí¹tsá²táunh¹ tsú² jáun² jmɨ́¹ zian² ma³ jan² tsá² *fariseos, hi³ ca³juáh³: ―Tɨ³², má²né³² jin³² tsá² hí¹hleh³² nɨ́² la³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tɨ³la³ Jesús ca³záɨh³ tsá² hí³: ―Jná¹³ juanh³², sá¹ hi³ tsá² lá² hí¹já²táunh¹ ta³máɨh³ dúh¹, jáun² hí¹ la³ tɨ³ quɨ́n¹ yáh³ jmɨ́¹ má²hléh³² tiá³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jmɨ́¹ má²ñí¹chau²¹ jáun² Jesús já¹ juú² Jerusalén né³, ca³jɨ́e³ tɨ³ ñí¹ nio¹ juú², hi³ jáun² ca³hó³. ");
INSERT INTO csoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Jmɨ́¹jáun² ca³juáh³ la³ lá² hi³ ca³tɨn¹ juú² jáun²: ―¡Hen³ ma³ chú³² sá¹ hi³ jmɨ́¹ lɨ³ ñíh¹³ hnú² né³² ha³ lánh³ rón³² lɨ́¹³ niau²¹ tie³ quián¹³, uá¹jinh¹ má²hia³ jáun¹³ lɨ́n³² jmɨ́¹ hniáuh²¹ hi³ lɨ³ ñíh¹³ hnú²! Tɨ³la³ ca³tɨn¹ hnú² má¹ná¹, má²ná¹hmá¹ bíh¹ hi³ jáun² ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Quí¹ chau²¹ jmáɨ¹ hi³ ja³táunh¹ tsá² jmu³ hniéi² quiúnh¹ hnú²; tsá² hian² tsɨ́³ hí³ qui³ quéɨh³² hnú², hi³ jmu³ siáh³ ta³² lɨ́³ quɨ́n¹ tɨ³ coh³ hiah³² quián¹³ hnú² nɨ́². Hi³ jáun² cun³quionh³ ta³² jáun² uú³ tsú² hi³ tsa³tiónh³² hi³ jmu³ hniéi² quiúnh¹ hnú², hi³ jmu³ tsú² ná¹pɨ́² ná¹danh³² cu³ jéin³ quián¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tsá² hí³ bíh¹ qui³ tóh³² tiú² jóh³², hi³ ma³hiá² ma³tsan² tsú² tsá² zian² nɨ́² ñí¹con² hnú², hi³ jmu³ tsú² hi³ hí¹ cá² máɨ³ quɨ́n¹ tiú²uú² ná¹tsɨ²¹ ñí¹ quɨ́n¹ raɨnh²¹, quí¹ cun³ñí¹ hi³ tiá² ca³lɨ³tsɨn² yáh³ hnú² jmáɨ¹ hi³ cuan³ Dió³² ta³ máh¹ nú². ");
INSERT INTO csoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jmɨ́¹ lɨ²¹ jáun² ca³hi³ Jesús hñu³ cuáh³² chín¹, hi³ jáun² ca³ma³liáu³² hi³ ca³chu³ ca³huen³ tsá² jmɨ́¹ ná¹jmu² ná¹hna² hí³ ñí¹ jáun²; ");
INSERT INTO csoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","hi³ ca³záɨh³ dí² la³ lá²: ―Ñí¹ Sí² quioh²¹ Dió³² rá¹juáh³: “Hñú³ quion²¹ jná¹³ dí¹chan¹ hi³ liéih³² tsú² jná¹³ bíh¹”; tɨ³la³ hnoh² né³, tá²hláu² quioh²¹ háɨn² bíh¹ má²ca³jmuh³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jmɨ́¹jáun² ca³ma³tɨn² Jesús tsáu² cun³ tsa³háu² hñu³ cuáh³² chín¹ jáun²; tɨ³la³ tá¹la³ jáun² jmɨ́¹ má²ná¹hnauh² tsá² ná¹lɨ́n³ mi³jmú³ tsɨ́³, quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, jɨ³ tsá²tan²¹ nɨ́², hi³ ha³ lánh³ rón³² lɨ́¹³ jngɨh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tɨ³la³ tiá² choh²³ yáh³ tsú² ha³ lánh³ rón³² lɨ́¹³ jngɨh³ Jesús, quí¹hliá² la³jɨ́n³² bíh¹ tsáu² ná¹lɨ́²hiún² lɨ́n³² tsɨ́³ hi³ ná¹náɨ³² jë¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ cuá¹má²tɨn² Jesús tsáu² hñu³ cuáh³² chín¹, hi³ jmɨ́¹ cuá¹hɨeh³² tsú² tsáu² jú¹ chú³² quioh²¹ Dió³². Jáun² jmɨ́¹jáun² ca³cua³taunh²¹ tsá² ná¹lɨ́n³ mi³jmú³ quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, jɨ³ la³ má²quionh³ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jáun² tsá² hí³ ca³juáh³ la³ lá²: ―Juah²¹ neh²¹, ¿hin² ca³cué³ héih³² hi³ jmuh³² hnú² ta²¹ nɨ́²? ¿Hin² tsánh² ca³cué³ jáɨ¹³ hi³ hauh³² hnú² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jáun² Jesús ca³juáh³: ―Ja³bí¹ jná¹³ siáh³ nga¹ cáun² jáɨ¹³ ñí¹con² hnoh². Juah²¹ tín² hnoh² neh²¹: ");
INSERT INTO csoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Hin² tsánh² ca³ze³ hla¹ Juan² hi³ cua³zion³ tsáu² jmáɨ²? ¿Hí¹ Dió³², ho³ tsá²mɨ³cuóun² uá¹? ");
INSERT INTO csoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tɨ³la³ tsá² hí³ né³, cáun² lɨ́¹ ca³juu³ ca³hlénh³ ja¹ má²tún² hmóu³² bíh¹, hi³ ca³juónh³ la³ lá²: ―Nɨ́¹juáh³ hi³ juáh¹³ dí² hi³ Dió³² bíh¹ ca³ze³ tsú², jáun² tsá² nɨ́² né³ lɨ́¹³ nga³: “Hi³ jáun² né³, ¿he³ láɨh³² sa³ tiá² ta²¹ ca³tianh³² yáh³ náh² tsú²?” ");
INSERT INTO csoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Hi³ nɨ́¹juáh³ juáh¹³ dí² siáh³ hi³ tsá²mɨ³cuóun² bíh¹ ca³zen³ tsá² hí³, jáun² quɨ́n¹ bíh¹ qui³ jláɨ³² dí² la³jɨ́n³² tsáu² lɨ́¹³, hi³ jngah³ tsú²; quí¹ jɨ³lɨn² tsáu² bíh¹ ná¹lɨ́n²³ hi³ hla¹ Juan² jmɨ́¹ lɨ́n³ jan² *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Hi³ jáun² cu³tsa³² tiá² ñi³² bíh¹ dí² cú²jueh³² ca³záɨh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jáun² Jesús né³, ca³juáh³ siáh³: ―Hi³ jáun² sa³jun³ jná¹³ yáh³ juanh²¹ siáh³ hi³ hin² tsánh² ca³cué³ jáɨ¹³ hi³ jmu² jná¹³ la³jɨ́³² ta²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jáun² la³ cun³ jmɨ́¹jáun² ca³hléh³ Jesús ñí¹con² tsá² tionh² hí³ ñí¹ jáun², hi³ ca³jmú³ tsú² cáun² jáɨ¹³ lɨ́³ la³ lá²: ―Jmɨ́¹ zian² jan² tsá² ca³jñí³ mɨ³ uóun²jɨeh¹³ ñí¹náɨ² quioh²¹. Jmɨ́¹ lɨ²¹ jáun² né³, ca³quiú² tsú² ñí¹náɨ² jáun² jo³cuo² tsá² lɨ́¹³ jmu³ ta²¹, hi³ jáun² tsá² jmu² hí³ ta²¹ né³, jmɨ́¹ ma³hmah¹ ca³lá² quioh²¹ ñí¹náɨ² jáun² cun³quionh³ hi³ jɨ́enh³² cú¹pih²¹ la³ cun³ hi³ ló³² jáun². Jmɨ́¹ lɨ²¹ jáun² jáɨ¹³ la³ nɨ́² né³, ngau³ bíh¹ tsú², hi³ jáun² ca³lén³ ué³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ ca³láu² mɨ³ uóun²jɨeh¹³ né³, jáun² ca³zen³ tsú² jan² *tsá² má²ná¹hlánh¹ joh¹ ñí¹con² tsá² ca³cuéh³ tsú² hí³ ñí¹náɨ² jáun², hi³ tsa³máɨ¹ ca³lá² hi³ má²ca³láu² jáun², la³ cun³ hi³ ca³tɨn¹ tsá² quioh²¹ ñí¹náɨ². Tɨ³la³ tsá² ná¹jmu² hí³ ta²¹ má¹ná¹, ca³qui³ ca³quiunh³ bíh¹ tsá² zéin¹ hí³ tsá² quioh²¹ ñí¹náɨ², hi³ jáun² lɨ́¹ haɨ²¹ cuá² ta³ bíh¹ tsú² ca³chanh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jáun² tsá² quioh²¹ hí³ ñí¹náɨ² né³, ca³zen³ siáh³ jan² tsá² joh¹. Jmɨ́¹ cá¹chó²¹ jáun² siáh³ tsá² hí³ né³, siáh³ bíh¹ siáh³ ca³qui³ ca³quiunh³ tsú² tsá² hí³, hi³ ca³tu³ ca³hión³² dí² jú¹ hlah³ jú¹ hó³², jáun² lɨn²¹ bíh¹ siáh³ tsá² hí³ ca³jính³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jáun² ca³zen³ tsú² siáh³ cónh³í¹ jan² tsá² joh¹, tɨ³la³ tsá² ca³hiauh³ hí³ ñí¹náɨ² má¹ná¹, cun³ jáun² ca³quiunh³ bíh¹ siáh³ tsá² hí³ ca³la³ ca³cuɨ́nh³, hi³ ca³chin² dí² tɨ³ cheih³² hué³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”Jmɨ́¹ lɨ²¹ jáun² né³, ca³lɨ́n¹³ tsá² quioh²¹ hí³ ñí¹náɨ² la³ lá²: “¿He³ lɨ́¹³ jmu¹ jná¹³ juáh¹³? Cu³tsa³² jón³² huen² jná¹³ cú²jueh³² cuɨ́¹ zein²¹, tsá² jlánh¹ hno³ jná¹³ lɨ́n³². Len³ jná¹³ ho³sa³ tanh¹³ bíh¹ tsú² ta²¹ jón³² jná¹³ nɨ́¹ má¹ca³jɨ́en³²”. ");
INSERT INTO csoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Tɨ³la³ jmɨ́¹ ca³jɨ́en³² jáun² tsá² ná¹jmu² hí³ ta²¹ jon² tsá² quioh²¹ ñí¹náɨ² né³, ca³juu³ ca³hlénh³ ja¹ má²tún² hmóu³², hi³ ca³juáh³: “Já² tsá² nɨ́² bíh¹ lɨ³quioh²¹ ñí¹náɨ² lá² nɨ́¹ má¹jun² jméi²; chú³² cuɨ́¹ jngɨh¹³ dí² tsú², hi³ jáun² lɨ³ quiú¹³ dí² ñí¹náɨ² lá²”. ");
INSERT INTO csoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jáun² la³juɨ³² ca³chin² tsú² tsá² hí³ tɨ³ cheih³² ñí¹náɨ² jáun², hi³ ca³jngɨh³ dí² tiáunh¹. Jmɨ́¹ lɨ²¹ jáun², ca³ngáɨ³ Jesús ñí¹con² tsá² hí³: ―¿He³ lɨ́n²³ hnoh² jmu³ tsá² quioh²¹ hí³ ñí¹náɨ² ñí¹con² tsá² ca³jmú³ hí³ la³ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tsá² hí³ dá² jáunh³ bíh¹, hi³ ja³ma³tsan² tsú² tsá² jmu² hí³ ta²¹ ñí¹náɨ² quioh²¹, hi³ jáun² tsá² siánh³ bíh¹ cuéh³² tsú² cú²jueh³² ñí¹náɨ² jáun². Jmɨ́¹ má²lɨ́²niéi³² jáun² tsá² tionh² hí³ ñí¹ jáun² jáɨ¹³ hi³ má²lɨ́²hléh³² jáun² Jesús, jáun² ca³juáh³: ―¡Ha³ lɨ́² cuɨ́¹ lɨ́¹³ bíh¹ la³ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Tɨ³la³ Jesús ca³jɨ́e³ chí¹tiá³ ñí¹ ñí¹ tionh¹ tsá² hí³, hi³ ca³juáh³: ―¿Ha³ bí¹ lánh³ rón³² ngɨ²³ náh² jáɨ¹³ ñí¹ rá¹juáh³ jáun² Sí² quioh²¹ Dió³² la³ lá² dúh¹?: Quɨ́n¹ hi³ tiá² ca³jeih²¹ jáun² tsá² ná¹lɨ́n³ tɨ³² hiah³², ta³né³² má²lɨ́³ cá² máɨ³ quɨ́n¹ hi³ jlánh¹ bíh¹ quien² bíh¹, quɨ́n¹ hi³ hu²¹ cuoh¹ hiah³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Hi³ jáun² lɨ³ua³ jan² tsá² cá²hính³² quionh³ quɨ́n¹ jáun², ca³la³ juoh¹ mí¹ siún¹ nio² bíh¹ tsú² lɨ́¹³; hi³ nɨ́¹juáh³ quɨ́n¹ jáun² la³ ca³táh³ ñí¹ quioh²¹ jan² tsáu² né³, jáun² ca³la³ juɨ²¹ nio² bíh¹ tsú² lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","La³ cun³ jmɨ́¹jáun² jmɨ́¹ hnió³ tsá² ná¹lɨ́n³ mi³jmú³ la³ má²quionh³ tɨ³² liei²¹ hi³ zanh³ Jesús, quí¹hi³hliá² ca³lɨ³tsɨn² tsú² hi³ Jesús má²lɨ́²jmú³ cáun² jáɨ¹³ hi³ ca³tɨn¹ hí³ dí²; tɨ³la³ tiá² lɨ³ yáh³ zanh³ tsú² Jesús, quí¹hi³hliá² juénh² tsú² tsá² ná¹ngɨh³² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jáun² cu³tsa³² ca³zen³ tsú² cú²jueh³² tsá² tsa³cá² tsa³lian² Jesús, hi³ tsa³jmú³ tsú² la³juah²¹ dúh¹ tsá² chun¹. Jáun² tsá² hí³ ca³can³ re² lɨ́n³² hua³hí¹³ jë¹ Jesús, nɨ́¹juáh³ nɨ́² lɨ́¹ ca³hléh³ tsú² cáun² jáɨ¹³ tiá² ca³tɨ²¹, hi³ jáun² lɨ́¹³ jɨenh³ dí² ñí¹con² tsá² lɨ́n³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jáun² tsá² hí³ ca³juáh³ ñí¹con² Jesús: ―Hnú² Tɨ³², né¹ jnoh¹ hi³ jmáh³la³ jú¹ tson² bíh¹ hɨeh³² hnú²; hi³ né¹ jnoh¹ siáh³ hi³ tiá² jmuh³² hnú² hi³ quien² jan² hi³ jan² tiá² quien², tɨ³la³ hnú² bíh¹ hɨeh³² tsáu² jú¹ tson² hi³ ca³tɨ²¹ juɨ³² quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jáun² juáh¹³ hnú² neh²¹: ¿Hí¹ ca³tɨ²¹ má¹hmah²¹ jnoh¹ quɨe³ hi³ mɨ³² *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma, ho³ tiá² hniáuh³²? ");
INSERT INTO csoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Tɨ³la³ Jesús má¹ná¹, ca³lɨ³tsɨn² bíh¹ hi³ hlah³ hi³ ná¹quionh² chí¹ tsá² hí³, jáun² ca³záɨh³ dí² la³ lá²: ―¿He³ láɨh³² sa³ cá² lau²³ hnoh² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Hɨ́e¹ náh² cáun² *cú¹tiáu² neh²¹. ¿Hin² mɨ³ ñí¹ tá²láɨ¹ ñí¹ lá², hi³ hin² hi³ jmáɨ² tón³² lá² siáh³? Jáun² né³, tsá² hí³ ca³ngáɨ³: ―Quioh²¹ tsá² cuá¹lɨ́n³ hí³ mɨ³chí¹ bíh¹ nɨ³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jáun² cuéh³ náh² tsá² cuá¹lɨ́n³ mɨ³chí¹ la³ cun³ hi³ ca³tɨn¹ hiáuh³, hi³ cuéh³ náh² siáh³ Dió³² la³ cun³ hi³ ca³tɨn¹. ");
INSERT INTO csoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hi³ jáun² tiá² ca³láɨh¹³ yáh³ tsá² hí³ hi³ jmɨ́¹ ca³ jmɨ́¹ lan³ Jesús ta³ ñí¹ tsá² tionh² hí³ ñí¹ jáun²; hi³ jáun² lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹ tsú² jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́². Jáun² tie³ bíh¹ ta³tonh¹ tsú² cú²jueh³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jmɨ́¹ lɨ²¹ jáun² né³, cua³taunh²¹ ma³ jan² tsá² *saduceos hi³ cua³jɨen³ Jesús. Tsá² cu³ nió³ tsá² saduceos hí³ tiá² ta²¹ haɨh²¹ yáh³ hi³ jenh¹³ tsá² má²cá²tsan³; hi³ jáun² bí¹ jlánh¹ ca³ñí¹ngah¹ dí² Jesús jáɨ¹³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Hnú² Tɨ³², ñí¹ liei²¹ quioh²¹ hla¹ Moisés rá¹juáh³ nɨ́¹juáh³ jan² tsá²ñuh² ca³jun³ ta³ tiá² ca³lɨ³zian² jon² quionh³ tsá²mɨ³ ñí²cuo², jáun² tsá²ñuh² dá¹jon²¹ hla¹ hí³ ca³tɨn¹ jan³ siáh³ tsá²mɨ³ hí³, hi³ jáun² lɨ³zian² jon² hi³ ca³tɨn¹ hla¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jáun² né³, jmɨ́¹ zian² cá² mí¹zionh² tsá²ñuh² hi³ jmɨ́¹ ná¹lɨ́n³ quiaun³ má²tún² raɨnh²¹ jan² jméi² mí¹ziú¹³. Tsá² má²ján³ né³, ca³jan³ tsá²mɨ³, tɨ³la³ ca³jun³ bíh¹ tsú², hí¹ jan² yáh³ jon² tsú² tiá² ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jáun² dá¹jon²¹ bíh¹ tsú² ca³jéinh³² siáh³ cuo² quionh³ tsá²mɨ³ hnáɨ³ hí³. Ja³bí¹ ca³jun³ bíh¹ siáh³ tsá² hí³, hí¹ jan² yáh³ jon² tiá² ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jáun² tsá² ñí¹ má²gáun³ hí³ né³, ca³jan³ siáh³ tsá²mɨ³ hí³. Siáh³ bíh¹ siáh³ ca³jun³ tsá²ñuh² hí³. La³ jáun² bíh¹ lɨ³ quioh²¹ tán¹ quiaun³ tsá² hí³, hi³ hí¹ jan² yáh³ jon² tsá² quiaun³ hí³ tiá² ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jáun² ñí¹ ca³táuh³ né³, jun³ bíh¹ siáh³ tsá²mɨ³ hí³ hnga². ");
INSERT INTO csoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Hi³ jáun² né³, nɨ́¹ má¹tɨ³ ñí¹ ca³jenh¹³ tsú² ¿hin² dá² tsánh² tsá² quiaun³ hí³ lɨ́¹³ ñí²cuo² tsá²mɨ³ hí³, quí¹ tán¹ quiaun³ bíh¹ tsá²ñuh² hí³ ca³jéinh³² cuo² quionh³ tsá²mɨ³ hí³? ");
INSERT INTO csoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Ñí¹ hué²¹ lá² bíh¹ jaun³² jéinh³² tsá²mɨ³ tsá²ñuh² cuo², ");
INSERT INTO csoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","tɨ³la³ tsá² ca³tɨn¹ hi³ tsánh³² ñí¹ chu²¹ nɨ́¹ má¹ca³jenh¹³ ja¹ tsá² má²cá²tsan³ né³, tsá² la³ hí³ tiú²uú² cuo² jéinh³² yáh³, sa³jun³ cuen³ bíh¹ tsú² siáh³ jon² hi³ jéinh³² cuo², ");
INSERT INTO csoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","quí¹ ñí¹ jáun² hí¹ jan² yáh³ tiú²uú² hin² jún³. Quí¹ má¹jáun² lɨ́n¹³ tsú² la³jmɨ́¹ lɨ́n³ tsá²cuú² tsá²ta³ Dió³² bíh¹. Jon² Dió³² bíh¹ má²lɨ́n¹³ tsú², quí¹hliá² má²ca³jenh¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ta³bí¹ hnga² hla¹ Moisés yáh³ ca³hléh³ hi³ ca³tɨn¹ tsá² jenh¹³ ja¹ tsá² má²cá²tsan³, ñí¹ rá¹juáh³ jáun² jáɨ¹³ hi³ ca³tɨ²¹ sɨ́² hia³² ja¹ hmá² ton². Ñí¹ jáun² rá¹juáh³ hi³ Dió³² Juo¹³ dí² lɨ́n³ Dió³² ñí¹con² Há²bran²¹, Isaac, jɨ³ Jacob nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Quí¹ Dió³² dá² lɨ́n³ Dió³² Juo¹³ tsá² zian² bíh¹, tiá² lɨ́¹³ yáh³ lɨ́n³ tsú² Dió³² Juo¹³ tsá² má²jún¹. Quí¹ ñí¹con² Dió³² ca³la³ jɨ³lɨn² bíh¹ tsáu² ná¹liéih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jmɨ́¹jáun² né³, ma³ jan² tɨ³² liei²¹ ca³záɨh³ Jesús: ―Chú³² lɨ́n³² bíh¹ la³ jmɨ́¹ má²lɨ́²juah²¹ hnú² nɨ́² Tɨ³². ");
INSERT INTO csoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","La³ cun³ jmɨ́¹jáun² tiú²uú² hin² ca³tia³ yáh³ tsɨ́³ hi³ nga³ siáh³ jáɨ¹³ ñí¹con² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―¿He³ láɨh³² ná¹juáh²³ tsáu² hi³ Tsá² lɨ́n¹³ Cristo jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹ bíh¹? ");
INSERT INTO csoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Já² ñí¹ Sí² Salmos ca³juáh³ hnga² hla¹ Dá²vi²¹ la³ lá²: Dió³² Juóu³² jná¹³ ca³záɨh³ Tɨ³² Juóu³² jná¹³ la³ lá²: Tɨ³ cuá² chu²¹ quion²¹ jná¹³ ñí³, ");
INSERT INTO csoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ca³la³ tɨ³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ jmu¹ jná¹³ hi³ tsá² hau² hnú² lɨ́n¹³ la³jmɨ́¹ lɨ́³ cáun² jlɨ²¹ hi³ hí¹ cú¹pih²¹ tiá² quien², hi³ ná¹tsɨn²¹ hnú² tanh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","”Hi³ jáun² né³, ¿ha³ bíh¹ lánh³ rón³² lɨ́¹³ hi³ Tsá² lɨ́n¹³ Cristo lɨ́n³ jan² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Dá²vi²¹?, quí¹ ta³bí¹ hnga² yáh³ hla¹ Dá²vi²¹ hí³ la³ ca³juáh³ hi³ Juo¹³ bíh¹ tsú² Tsá² lɨ́n¹³ hí³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jmɨ́¹jáun² jmɨ́¹ ná¹náɨ³² ca³la³ jɨ́n³² tsá² tionh² hí³ ñí¹ jáun² jáɨ¹³ hi³ ca³hléh³ jáun² Jesús ñí¹con² tsá² haɨn²¹ hí³ tɨ³ con², jmɨ́¹ ca³juáh³ tsú² jáun² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Hua³hín¹³ náh² jmu³ quiúnh¹ tsá² ná¹lɨ́n³ tɨ³² liei²¹, quí¹ tsá² hí³ jlánh¹ zaɨn³² hi³ quɨ́h³² hmɨh³² cuo² hi³ ñi³táunh¹ tɨ³ hlá² tɨ³ nɨ́², hi³ jlánh¹ hniá¹ tsú² siáh³ hi³ tsáu² cuen³ Dió³² nɨ́¹ má¹ca³jenh² dí² já¹ hmah²¹; hi³ jlánh¹ hniá¹ tsú² siáh³ tiánh³ ñí¹ jlánh¹ bí¹ quien² hñu³ cuáh³² quioh²¹, jɨ³ hi³ hniá¹ tsú² siáh³ tiánh³ ñí¹ jlánh¹ bí¹ quien² nɨ́¹ má¹ca³cha³táunh¹ ñí¹ nio² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tsá² hí³ bíh¹ tsá² quin²³ sɨ́¹ hñú¹³ tsá²mɨ³ hnáɨ³, hi³ má¹lɨ³² jáun² né³, lɨ́¹ ráɨn³² ñí¹ cun³quionh³ hi³ liéinh³² jáun² Dió³² ué³ lɨ́n³². Cun³ñí¹ hi³ jáun², tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ héih³² hi³ tá¹tsɨn¹ tsú² nɨ́¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jmɨ́¹jáun² ca³jɨ́e³ Jesús hi³ toh² tsá² hánh³ quɨe³ hñu³ cuó² quioh²¹ cuáh³² chín¹ hi³ cue³² ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ja³bí¹ ca³jɨ́en³² tsú² siáh³ jan² tsá²mɨ³ hnáɨ³ tia³mii² hi³ dí¹taunh³² tun³ cú¹dáɨn³ hñu³ cuó² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jmɨ́¹jáun² ca³juáh³ dí² la³ lá²: ―Jú¹ tson² cu³tí³ juo³ jná¹³ hnoh², hi³ tsá²mɨ³ hnáɨ³ tsá² tia³mii² ó³² bíh¹ tɨ³ hliáun³ má²lɨ́²cué³² la³ cónh³ bíh¹ jɨ³lɨn² tsá² hánh³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Quí¹ la³jɨ́n³² tsá² ñí¹ hná¹ nɨ́² cue³² la³ cun³ hi³ má²ziau³² quioh²¹ bíh¹, tɨ³la³ uá¹jinh¹ tia³mii² tsá²mɨ³ ó³², má²lɨ́²cué³² bíh¹ tsú² la³jɨ́³² hi³ jmɨ́¹ raunh³²; quɨe³ hi³ jmɨ́¹ má²ma³hau³ hi³ ma³zian² bíh¹ tsú² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jmɨ́¹jáun² jmɨ́¹ zian² tsá² ná¹juáh²³ hi³ jlánh¹ re² ca³lɨ³ cuáh³² chín¹ cun³quionh³ quɨ́n¹ chú³² jniá³, jɨ³ la³ má²quionh³ la³jɨ́³² hi³ lɨ́¹ ca³cué³ tsáu² nɨ́². Jáun² Jesús ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Chau²¹ bíh¹ jmáɨ¹ hi³ hí¹ cá² máɨ³ quɨ́n¹ tiú²uú² ná¹juɨn¹ ñí¹ quɨ́n¹ raɨnh²¹; la³jɨ́³² bíh¹ juú¹ tsúnh¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jmɨ́¹jáun² ca³ngáɨh³ tsá² hí³ Jesús, hi³ ca³juáh³: ―Hnú² Tɨ³², ¿lɨ́h³ lɨ́¹³ la³ cun³ hi³ má²lɨ́²juah²¹ hnú² nɨ́²? ¿Ha³ dá² lánh³ rón³² lɨ³ lin¹ hi³ má²ja³quián³ lɨ́¹³ la³ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jáun² Jesús ca³juáh³ la³ lá²: ―Hua³hín¹³ lɨ́n³² hnoh² jmu³ hi³ tiá² lɨ́¹ lɨ³can² náh². Quí¹ juóun³² lɨ́n³² tsáu² ja³táunh¹ hi³ ja³jmú³ hi³ lɨ́n³ la³juah²¹ dú¹ jná¹³, hi³ ja³juah²¹: “Jná¹³ bíh¹ lɨ́n³ Cristo”; hi³ juáh³ tsú² siáh³: “Né³² má²cá²chó³² jmáɨ¹”. Tɨ³la³ ha³ lɨ́² tanh³ hnoh² ta²¹ tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Hi³ nɨ́¹ má¹ca³niéih² náh² hi³ zian² tsá² jmu² hniéi², hi³ tiáunh¹ tsáu² tiá³ siaun³² tɨ³ hlá² tɨ³ nɨ́², ha³ lɨ́² juenh³ náh². Quí¹ la³ jáun² ca³tɨ²¹ lɨ́¹³ bíh¹ la³ñí¹, tɨ³la³ jun³juáh¹³ má²tsa³hín³ yáh³ jaun³². ");
INSERT INTO csoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jáun² ca³juáh³ siáh³ la³ lá²: ―Tsá² zian² cáun² hué³² jmu³ hniéi² quionh³ tsá² zian² hué³² siáh³, jɨ³ tsá² hɨ́n¹³ hué³² ñí¹ hliáun³ quiu³ tɨ́n³ siáh³ quionh³ tsá²ján² tsá²ján². ");
INSERT INTO csoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Hi³ ñí¹ hliáun³ siáh³ qui³ jɨ́eh³ hué³² tiá³ lɨ́n³², hi³ lɨ³ zia³² siáh³ ho³cuóun³ jɨ³ hi³ hí³ tsáu¹ nɨ́² siáh³. Chi³cuú² siáh³ qui³ jnia³ hi³ cáu² hi³ jueh³². ");
INSERT INTO csoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Tɨ³la³ ñeh² bíh¹ hi³ lɨ́¹³ la³jɨ́³² hi³ má²lɨ́²juánh³² jná¹³ nɨ́² má¹ná¹, má¹jáun² hɨ³ tsa¹ tsú² hnoh², hi³ zaunh³ tsú²; hi³ tsa³jau² tsú² hnoh² hñu³ cuáh³² quiú¹³ dí², hi³ tsa³ma³re² tsú². Jau³ tsú² hnoh² hi³ táuh³² tsú² hñu³mí¹ñí², hi³ tsa³jau² tsú² siáh³ hnoh² ta³ ñí¹ tsá² ná¹ho² jáɨ¹³ jɨ³ ta³ ñí¹ tsá² ná¹lɨ́n³ re²¹ siáh³, cun³ñí¹ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Má¹jáun² má²lɨ́¹³ cuéh¹ hnoh² jú¹ tson² hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ñí¹ jɨ́²¹ la³ cháh¹³ náh² cáun² honh² bíh¹, hi³ tiá² quí¹ hnáuh¹³ náh² honh² hi³ he³ jáɨ¹³ cuá¹ngah³ náh² ta³ ñí¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Quí¹ jná¹³ bíh¹ Tsá² cué¹³ jáɨ¹³ hi³ hléh¹³ hnoh² jmáɨ¹ jáun², hi³ jmu¹ jná¹³ siáh³ hi³ jnia³ jmɨ́¹ honh² náh²; ca³la³ hí¹ jan² tsá² hau² hnoh² tiú²uú² ñi³² ha³ lánh³ rón³² nga³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hi³ hí¹ ca³la³ tɨ³ ñeh² mí²ziúh² yáh³ hnoh² tsa³jɨenh³ hnoh² ñí¹ta²¹, jɨ³ tsá² jan² ñeh² mí²ziúh² náh² quiúnh¹ nɨ́², jɨ³ jun³ renh² náh², jɨ³ tsá² juónh³² náh² re² quiúnh¹ nɨ́² siáh³; hi³ ma³ jan² hnoh² jngah³ tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tsá² zian² tá¹ cáun² hngá¹máh³ bíh¹ lɨ³hau² hnoh² cun³ñí¹ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tɨ³la³ hnoh² má¹ná¹, hí¹ cá² máɨh³² yáh³ jñú² chinh³² hnoh² tiá² lɨ́¹ tsa³háɨ³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Jáun² nɨ́¹juáh³ la³ má²nio² nɨ́² cáun² honh² hnoh², jáun² hián¹³ bíh¹ náh² hi³ lɨ́¹³ zian² náh² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”Nɨ́¹ má¹ca³jɨeh³ hnoh² hi³ juóun³² lɨ́n³² hliáu³ má²ná¹pɨ́² ná¹danh³² la³ cu³ la³ jéin³ juú² Jerusalén, jáun² má¹jáun² lɨ³ ñíh¹³ hnoh² hi³ má²janh² bíh¹ má²ja³² jmáɨ¹ hi³ tsa³hín³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Hi³ jáun² jmáɨ¹ jáun² má²hniáuh³² cuon³ tsá² hɨ́n¹³ tɨ³ Judea ñí¹ lɨ́³ máh³; hi³ tia³juɨ³² siáh³ cuɨ́¹ huén² tsá² zian² já¹ juú² Jerusalén, hi³ ha³ lɨ́² cuɨ́¹ cha³tánh¹ tsá² tiáunh¹ ñí¹náɨ² tɨ³ já¹ juú². ");
INSERT INTO csoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Quí¹ jmáɨ¹ jáun² cáun² jmáɨ¹ hi³ jlánh¹ ma³tson¹³ Dió³² tsáu² bíh¹, jmáɨ¹ hi³ hniáuh³² lɨ³tí³ ca³la³ jɨ́³² hi³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Jlánh¹ juo²³ tsá²mɨ³ tsá² ná¹quian² jon² jmáɨ¹ jáun², jɨ³ tsá² ná¹jan² dáɨn² tiúh²³ nɨ́² siáh³! Quí¹ jmáɨ¹ jáun² lɨ³ zia³² uu³mí²tsɨ³² huáh² tsɨ́³ cu³tí¹³ tá¹ cáun² hué³² lá², cáun² hi³ jlánh¹ ma³tso² tsá² hué³² lá² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jmáɨ¹ jáun² juóun³² bíh¹ tsáu² tsán¹³ ja¹ hniéi² jáun²; hi³ tsá² zian² hué³² ñí¹ hliáun³ siáh³ ma³tson¹³ tsá² hué³² lá². Hi³ *tsá²cá²jo²¹ né³, ha³ zónh³² tsá² juú² Jerusalén lá², ca³la³ tɨ³ ñí¹ ca³tsɨ́n¹³ jmáɨ¹ hi³ cue³² Dió³² jáɨ¹³ hi³ lɨ́¹³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","”Má¹jáun² jnia³ li²¹ chi³cuú², ñí¹ he¹ hiú², ñí¹ he¹ zɨ́h², jɨ³ ñí¹ haɨ²¹ chí¹jmaɨ²¹ nɨ́² siáh³. Má¹jáun² siáh³ hɨ́³² lɨ́n³² tsɨ́³ tsá² zian² ñí¹ hué²¹ lá², hi³ tsa³cáun² lɨ́n³² tsɨ́³ tsú² cun³ñí¹ hi³ jlánh¹ tiá³ hen³ má¹cá²quɨ́h³² ma³ quin³² ma³ cun³ tsɨn¹ jmɨ́²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ca³la³ hi³ tánh³² tsɨ́³ tsú² hi³ hɨ³² tsɨ́³ ca³tɨ²¹ la³jɨ́³² hi³ né³bí¹ lɨ́¹³ ñí¹ hué²¹ lá²; quí¹ hí¹ ca³la³ tɨ³ pí³ hi³ jniá³ chi³cuú² yáh³ ru³ juá³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Hi³ jáun² má¹jáun² máh³ má²jɨ́en³² tsú² Jon² tsá²mɨ³cuóun² hi³ cuá¹jáunh²³ juɨ³² já¹ jnie² quionh³ pí³ hi³ cáu² hi³ jueh³² quioh²¹, hi³ lin¹ hi³ quien² lɨ́n³² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nɨ́¹ má¹ca³lɨ³liau³ la³ cun³ hi³ má²lɨ́²juánh³² jná¹³ nɨ́², jáun² háun¹ náh² nó¹ tianh³ hi³ ziáuh¹ náh² máh¹ chi³cuú², quí¹ má²ja³quián³ cu³tí³ bíh¹ liáun³ náh². ");
INSERT INTO csoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́², ca³jmú³ siáh³ cáun² jáɨ¹³ hi³ lɨ́³ la³ lá²: ―Sá¹nɨ́² jɨe³ la³ cun³ lɨ́²³ hmá² sí² co², ho³ lɨ³ua³ cáun² hmá² siáh³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nɨ́¹juáh³ ca³jɨeh³ hnoh² hi³ hmá² jáun² má²ná¹hion² siáh³ mu²¹ zɨ́h³, hmóu³² bíh¹ hnoh² má²ná¹ñíh¹ hi³ má²janh² bíh¹ má²ja³² jmɨ́¹ ñí²hiú². ");
INSERT INTO csoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ja³bí¹ la³ jáun² bí¹ siáh³, nɨ́¹juáh³ má²jɨ́eh³² hnoh² hi³ má²lɨ́²³ la³jɨ́³² hi³ má²lɨ́²juánh³² jná¹³ nɨ́², jáun² má²ñíh¹ náh² hi³ má²ja³quián³ bíh¹ jáunh¹³ jná¹³ hi³ já¹hó³² jáɨ¹³ cun³quionh³ héih³² quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","”Jú¹ tson² juo³ jná¹³ hnoh², hi³ la³jɨ́³² hi³ nɨ́² lɨ́¹³, ñeh² bíh¹ hi³ hiá¹ tsán¹³ tsá² zian² jmáɨ¹ hi³ ziáun² dí² lá². ");
INSERT INTO csoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Chau²¹ jmáɨ¹ tsa³hín³ la³jɨ́³² hi³ jnia³ chi³cuú², la³ má²quionh³ hngá¹máh³ lá², tɨ³la³ jáɨ¹³ quion²¹ jná¹³ má¹ná¹, tiá² tón³² jmáɨ¹ tsa³hín³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”Hua³hín¹³ náh² jmu³, ha³ lɨ́² cué² náh² jáɨ¹³ hi³ lɨ́¹ jlɨ́²¹ honh² náh² cun³quionh³ hi³ cú² hi³ húh²³ náh² hliáun³, jɨ³ hi³ ma³heinh²¹ náh² nɨ́², jɨ³ cun³quionh³ hi³ jlánh¹ hɨ³² honh² náh² ca³tɨ²¹ lánh³ zian² náh² ñí¹ hué²¹ lá² nɨ́² siáh³. Nɨ́¹juáh³ hi³ jmúh¹³ náh² hua³hín¹³, jáun² tiá² lɨ́¹ hiá¹han¹ hnoh² nɨ́¹ má¹cá²chó³² jmáɨ¹ jáun², ");
INSERT INTO csoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","la³jmɨ́¹ tah³² cáun² liá³. Quí¹ ñí¹con² ca³la³ jɨ³lɨn² tsá² zian² tá¹ cáun² hngá¹máh³ bíh¹ chau²¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Jáun² tianh³ náh² hua³jan²¹, hi³ ná¹lienh¹ náh² Dió³², jáun² lɨ³ zia³² jáɨ¹³ hi³ liáun³ náh² ca³tɨ²¹ la³jɨ́³² hi³ né³bí¹ lɨ́¹³, hi³ jáun² lɨ́¹³ má¹jnia¹³ náh² siáh³ ta³ ñí¹ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jáun² Jesús ca³ma³tɨn² tsáu² ta³ jma² hñu³ cuáh³² chín¹, hi³ nɨ́¹ má¹ca³niéi² jáun² né³, tɨ́² tsa³jnioh² tɨ³ máh³ míh¹ Olivos. ");
INSERT INTO csoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hi³ jáun² jɨ³lɨn² tsáu² tɨ́² tsá²táunh¹ hñu³ cuáh³² chín¹ ta³ hú²niéi² hi³ tɨ́² tsá²niéi³ jë¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jmɨ́¹ má²ja³quián³ tɨ²¹ *Jmɨ́¹hɨ́en¹, jmáɨ¹ hi³ cúh² tsá² *judíos *hí³ cuú²miih²¹, la³ cun³ hí¹miih²¹ tiá² tie³ jan² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hi³ jáun² jmɨ́¹jáun² ca³hnauh² tsá² ná¹lɨ́n³ mi³jmú³ tsɨ́³ quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹, hi³ ha³ lánh³ lɨ́¹³ jngɨh³ dí² Jesús, quí¹hliá² jmɨ́¹ juénh² tsú² nɨ́¹ he³ ca³jmú³ tsáu² ñí¹con² tsú² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","La³ cun³ jmɨ́¹jáun² ca³hi³ *Satanás hñu³ tsɨ́³ Judas, tsá² ja³ juú² Queriot, tsá² jmɨ́¹ lɨ́n³ hí³ jan² tsá² quian³tun³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jáun² tsá² hí³ bíh¹ ca³ñí¹lienh¹³ tsá² ná¹lɨ́n³ mi³jmú³ jɨ³ tsá² ná¹chín¹ hi³ jmu² hua³hí¹³ cuáh³² chín¹ nɨ́² siáh³; hi³ ca³ñí¹juónh¹³ dí² quionh³ tsú² hi³ ha³ lánh³ rón³² lɨ́¹³ jɨenh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jáun² tsá² ná¹ngɨh³² hí³ né³, ca³lɨ³ hiún² lɨ́n³² bíh¹ tsɨ́³ cun³quionh³ jáɨ¹³ hi³ ca³juáh³ Judas, jáun² ca³jmú³ tsú² jáɨ¹³ hi³ cué³² quɨe³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jmɨ́¹jáun² ca³jmú³ Judas cá²hon³ quionh³ tsá² hí³, hi³ ca³hnauh² dí² tsɨ́³ ha³ lánh³ rón³² lɨ́¹³ tsa³jɨenh³ dí² Jesús, nɨ́¹juáh³ cáun² jmáɨ¹ hi³ tiá² hin² ná¹ngɨh³² quionh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jmɨ́¹ cá¹chó²¹ jmáɨ¹ hi³ cua³hlau³ Jmɨ́¹hɨ́en¹, jmáɨ¹ hi³ cúh² tsá² judíos hí³ cuú²miih²¹, la³ cun³ hí¹miih²¹ tiá² tie³ jan², jmáɨ¹ hi³ jngɨh² tsú² jáun² *já¹ziáh² míh¹, ");
INSERT INTO csoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","jmɨ́¹jáun² ca³zen³ Jesús Pé¹ quionh³ Juan², hi³ ca³záɨh³ dí²: ―Cuá²táunh¹ náh², cuá²jmu³ hua³jan²¹ má³² hi³ cúh¹³ dí² tá¹la³ Jmɨ́¹hɨ́en¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jáun² né³, tsá² hí³ ca³ngáɨh³ Jesús hi³ ca³juáh³: ―¿Ha³ jinh¹ hnáuh² hnú² hi³ tsá¹jmú¹³ jnoh¹ hua³jan²¹ má³²? ");
INSERT INTO csoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jáun² Jesús ca³juáh³: ―Nɨ́¹ má¹ca³tiónh³² hnoh² já¹ juú² Jerusalén, jenh¹³ náh² jan² tsá²ñuh² tsá² quiaun² tse³ ha²¹ jmáɨ². Jáun² cuá¹táunh¹ náh² cu³chin¹ cu³hna²¹ tsá² hí³ ca³la³ ñí¹ hein²¹ tsú² ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jáun² juoh¹ hnoh² tsá² hñú¹³ ñí¹ jáun²: “Tɨ³² Juo¹³ jnoh¹ ñí¹juah²¹: ¿Ha³ jinh¹ lɨ́³ ñéih³ ñí¹ cueh³² tsú² tsáu², ñí¹ lɨ́¹³ cuh²¹ jná¹³ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá², quiúnh¹ jná¹³ tsá² haɨn²¹ tɨ³ con² ná¹?” ");
INSERT INTO csoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hi³ jáun² tsá² hñú¹³ hí³ tsa³jau² hnoh² cáun² ñéih³ jueh³² ñí¹ tun³ tsɨn¹, ñí¹ má²lɨ́³ re². Ñí¹ jáun² bíh¹ cuá¹jmuh³ hnoh² hua³jan²¹ má³² quiú¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Hi³ jáun² né³, ja³taunh²¹ bíh¹ tsá² hí³, jáun² ca³lɨ³tí³ bíh¹ la³ cun³ rón³² hi³ má²lɨ́²juáh³ jáun² Jesús. Hi³ jáun² ñí¹ jáun² bíh¹ ca³jmú³ tsú² hua³jan²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jmɨ́¹ má²lɨ³² jáun² né³, ca³chó³² Jesús la³ má²quionh³ tɨ³² tsá² quian³² hí³ jë¹ dí², hi³ ca³tiánh³ ñí¹ mesa. ");
INSERT INTO csoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jáun² ca³záɨh³ dí² tsá² hí³: ―Má²ngau³² jmáɨ¹ bíh¹ hu²¹ tsɨn³² jná¹³ hi³ cuh²¹ má³² quioh²¹ Jmɨ́¹hɨ́en¹ lá² quiúnh¹ ná¹ hnoh², ta³ ñeh² bíh¹ hi³ má¹tso¹ jná¹³ tsɨn³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tɨ³la³ jná¹³ juanh³² ñí¹con² hnoh² hi³ tiú²uú² cuh²¹ yáh³ jná¹³ siáh³ má³² la³ lá² ñeh² bíh¹ hi³ lɨ³tí³ nóh³² lɨ́³ má³² lá² ñí¹ cuá¹quien² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jmɨ́¹jáun² ca³can³ dí² cáun² copa, hi³ ca³cuéh³ tiá¹hmah¹ Dió³², jáun² ca³záɨh³ dí² tsá² hí³: ―Quian² hnoh² copa lá², hi³ ngɨ²¹ náh² ja¹ ñí¹ tionh¹ náh² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Juanh²¹ jná¹³ ñí¹con² hnoh² hi³ tiú²uú² aɨh²¹ yáh³ jná¹³ mu² ráu³ mɨ³ uóun²jɨeh¹³ lá², ca³la³ tɨ³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ má²cuá¹ho² jná¹³ jáɨ¹³ cun³quionh³ héih³² quioh²¹ Ñuh³² máh³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jáun² ca³can³ dí² siáh³ hí³ cuú²miih²¹, hi³ jáun² ca³cuéh³ dí² siáh³ tiá¹hmah¹ Dió³². Jmɨ́¹ lɨ²¹ jáun² ca³ca³ dí², hi³ jáun² ca³tsóh³ dí² ñí¹con² tsá² hí³, hi³ ca³juáh³ la³ lá²: ―Hi³ lá² bíh¹ ngú³ quion²¹ jná¹³ hi³ cuen²¹ jná¹³ huen² cun³ñí¹ hi³ ca³tɨn¹ hnoh². Cun³quionh³ hi³ jmúh¹³ náh² la³ lá² jmɨ́¹ tsú² jmɨ́¹ ja³², chau¹³ honh² náh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ja³bí¹ la³ jáun² bí¹ siáh³ ca³jmú³ tsú² quionh³ copa jmɨ́¹ má²laɨh³² má³², jmɨ́¹jáun² ca³juáh³ la³ lá²: ―Cun³quionh³ copa lá² bíh¹ má²lin¹ hi³ má²ca³lɨ³quien² cáun² nió³² hmaɨ²¹ cun³quionh³ jmɨ́²hán¹ jná¹³, hi³ táɨn³² hi³ ca³tɨn¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","”Tɨ³la³ jan² tsá² cuá³ ñí¹ mesa lá² quiúnh¹ bíh¹ dí² tsa³jɨenh³ jná¹³, jan² tsá² jmu² la³jmɨ́¹ jmu² tsá² ná¹lɨ́³ dí² cá²hon³ quiúnh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quí¹ jná¹³ Jon² tsá²mɨ³cuóun², cuá¹tsau³² bíh¹ hná¹ he² juɨ³² hi³ ca³tɨn¹; tɨ³la³ ¡jlánh¹ juo²³ tsá² jɨenh³ tsá² hí³! ");
INSERT INTO csoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jmɨ́¹jáun² ca³juónh³ tsú² má²tún² hmóu³² hi³ hin² bíh¹ tsánh² jmu³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hi³ jáun² la³ cun³ jmɨ́¹jáun² né³, ca³quiu³ ca³táɨnh³ tsú² hi³ hin² bíh¹ tsánh² jlánh¹ quien². ");
INSERT INTO csoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tɨ³la³ Jesús ca³záɨ³ tsá² hí³: ―Tsá² ná¹lɨ́n³ re²¹ zian² ñí¹ hué²¹ lá² ná¹jmu² héih³² ñí¹con² tsá²cuú² tsá²ta³; hi³ jlánh¹ hniá¹ tsú² hi³ tsá² hí³ joh¹ dí² ma³quien². ");
INSERT INTO csoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Tɨ³la³ tiá² ca³tɨn¹ yáh³ hnoh² jmúh¹³ la³ jáun². Nɨ́¹juáh³ tsá² jlánh¹ quien² ñí¹con² hnoh², hniáuh³² jmu³ tsú² la³jmɨ́¹ lɨ́n³ jan² tsá² tsá¹ñú¹ bíh¹; ja³bí¹ la³ jáun² siáh³, nɨ́¹juáh³ tsá² ho² jáɨ¹³ ñí¹con² náh², hniáuh³² bíh¹ jmu³ tsú² la³jmɨ́¹ jmu² jan² tsá² lɨ́n³ quian²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Hi³ jáun² né³, ¿hin² bíh¹ tsánh² jlánh¹ quien², hí¹ tsá² cua³² hí³ ñí¹ mesa ho³ tsá² jmu² ta²¹ uá¹? ¿Haun¹³ tsá² cua³² hí³ ñí¹ mesa bíh¹ tsá² quien²? Tɨ³la³ jná¹³ zenh² ja¹ ñí¹ tionh¹ hnoh² la³jmɨ́¹ lɨ́n³ jan² tsá² jmu² ta²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","”Hnoh² tsá² má²lɨ́²tianh³ náh² cu³lɨ²¹ quiúnh¹ jná¹³ ja¹ la³jɨ́³² uu³mí²tsɨ³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jáun² la³jmɨ́¹ ca³hiáu³² jná¹³ Ñuh³² hi³ ho² jná¹³ jáɨ¹³, la³ jáun² bíh¹ hiau²¹ jná¹³ siáh³ hnoh² ");
INSERT INTO csoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","hi³ cuá¹jmuh³ hnoh² má³² ñí¹ mesa quion²¹ jná¹³, ñí¹ ñí¹jmú²¹ jná¹³ héih³²; hi³ lɨ́¹³ cuá¹tianh³ náh² siáh³ ñí¹ hmá²sɨ¹, hi³ cuá¹quiánh² náh² jú¹ tson² quioh²¹ tá¹ quia³tún³ tsoh³ tsá² *Israel. ");
INSERT INTO csoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jáun² Jesús ca³juáh³ siáh³: ―Hnú² Sí¹mu²¹, sá¹nɨ́² jɨe³, *Satanás má²ca³ma³ hnoh² hi³ hnió³ tsú² tu³ jua³ hnoh² la³jmɨ́¹ chi³² tsú² cuú²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Tɨ³la³ jná¹³ má²cá²mɨ́³ ñí¹con² Ñuh³² quián¹³ hnú², hi³ jáun² cu³tí³ tiá² tsa³con² hnú² hi³ táunh²³ hnú² jáun² ta²¹; hi³ jáun² nɨ́¹ má¹cá²jéinh³² jáun² honh² hnú², jmúh¹³ nú² hi³ niau²¹ tiá³ hñu³ tsɨ́³ renh² nú² ñí¹ hná¹ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jáun² Sí¹mu²¹ Pé¹ ca³juáh³: ―Hnú² Tɨ³², má²nio² bíh¹ tiá³ tsɨn³² jná¹³ hi³ ñe¹ quiúnh¹ hnú²; uá¹jinh¹ ñe¹ jná¹³ uá²jaɨ³² hñu³mí¹ñí², hi³ uá¹jinh¹ jún³ jná¹³ siáh³ quiúnh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jáun² Jesús ca³juáh³ siáh³: ―Hnú² Pé¹, juanh³² jná¹³ ñí¹con² hnú², ta³ ñeh² bíh¹ hi³ hau³ cá¹háu², hnaɨh³² jéin³² juáh¹³ hnú² hi³ tiá² cuóu³² nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hi³ jáun² jmɨ́¹jáun² ca³ngáɨ³ siáh³ Jesús ñí¹con² la³jɨ́n³² tsá² hí³, hi³ ca³juáh³: ―¿Hí¹ zia³² bíh¹ cáun² hi³ ca³lɨ³ hniáuh³² quián¹³ hnoh² jmɨ́¹ cá¹zéi²¹ jná¹³ jáun² hnoh² hi³ cuá¹hléh¹ náh² jáɨ¹³; jmɨ́¹ ca³juánh³² jná¹³ jáun² hi³ tiá² cánh¹³ náh² quɨe³, sa³jun³ cánh¹³ náh² tuh³² hu²¹ má³², sa³jun³ cánh¹³ náh² siáh³ tuh³² tioh³ tanh¹? Jáun² né³, tsá² hí³ ca³ngáɨ³: ―Ján¹han²¹, hí¹ cáun² yáh³ tiá² hi³ ca³lɨ³ hniáuh³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jáun² Jesús ca³juáh³ siáh³: ―Tɨ³la³ má²za¹³ bíh¹ ta³né³², nɨ́¹juáh³ tsá² nióh³² cáun² tuh³² quioh²¹ má³², cuɨ́¹ quián¹³ tsú², jɨ³ quɨe³ siáh³. Nɨ́¹juáh³ zian² tsá² tiá² zia³² mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ quioh²¹, hniáuh³² hnáɨh³² tsú² hmɨh³² cháu³ quioh²¹, hi³ jáun² cuɨ́¹ lia²¹ tsú² cáun² mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quí¹ juanh³² jná¹³ ñí¹con² hnoh², hi³ hniáuh³² lɨ³tí³ ñí¹con² jná¹³ la³ cun³ jáɨ¹³ hi³ má²rá¹lɨ́³ jáun² ñí¹ Sí² quioh²¹ Dió³², hi³ juáh³ la³ lá²: “Ca³jmú³ tsáu² hi³ lɨ́n³ tsú² cú²ren² quionh³ tsá² ren² tso³”. Quí¹ ca³la³ jɨ³lɨ³² hi³ rá¹juáh³ ca³tɨn¹ jná¹³, ca³tɨ²¹ lɨ³tí³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jáun² tsá² hí³ ca³juáh³: ―Tɨ³², lá² zia³² tun³ mí¹ñí² hmu³. Jáun² Jesús ca³ngáɨ³: ―¡Cuɨ́¹ lɨ́³ cu³ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús, hi³ ngau³ tɨ³ máh³ Olivos la³ cun³ qui³ tan² jmu², la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jmɨ́¹ ca³cha³táunh¹ tsú² ñí¹ qui³ tan² jáun² Jesús tsau³², jáun² ca³záɨh³ tsú² tsá² quionh³ hí³ la³ lá²: ―Mɨ́¹ náh² ñí¹con² Dió³², hi³ jáun² tiá² lɨ́¹ lɨ³can² náh². ");
INSERT INTO csoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hi³ jáun² jmɨ́¹jáun² ca³ma³uóunh³² Jesús ca³lá² ñí¹con² tsá² hí³, la³ cun³ ñí¹ chau³² cá² máɨ³ quɨ́n¹ hi³ tón³² tsú². Hi³ jáun² ñí¹ jáun² ca³di³jñí³² hi³ ca³liéinh³² Dió³² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","―Hnú² Tia²¹, nɨ́¹juáh³ hi³ hnáuh² hnú², liau¹ tiá³ jná¹³ hi³ ca³tɨ²¹ jmáɨ² tsɨ́h³² hi³ ca³tɨn¹ jná¹³ aɨh²¹, tɨ³la³ ha³ lɨ́² cuɨ́¹ lɨ́¹³ la³ cun³ hi³ hnó³² jná¹³ má¹ná¹, cuɨ́¹ lɨ́¹³ bíh¹ la³ cun³ hi³ hnáuh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jáun² jmɨ́¹jáun² cuan³ jan² tsá²cuú² tsá²ta³ Dió³² hi³ cua³cué² pí³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hi³ jáun² tɨ³ jlánh¹ pí³ ca³jmú³ bíh¹ tsú² hi³ ca³liéinh³² Jméi², quí¹hliá² jlánh¹ jmɨ́¹ cuá¹má²tso² tsú² tsɨ́³. Jáun² mí²cho¹ má²ná¹jan² jmɨ² bíh¹ ca³táɨn² ma³ cu³ táh¹ cáh¹ quioh²¹ tsú² la³ tɨ³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jmɨ́¹ ca³náu² tsú² jáun² ñí¹ jmɨ́¹ cuá¹liéinh³² Jméi² né³, ngah³ tɨ³ ñí¹ tionh¹ jáun² tsá² gáun³ haɨn²¹ hí³ tɨ³ con². Jmɨ́¹ cá¹chánh²¹ tsú² jáun² ñí¹ tionh¹ tsá² hí³ né³, má²ná¹cuóun¹ bíh¹ tsá² hí³, quí¹hliá² má²cá²huóh³² tsú² cun³quionh³ hi³ hlaɨh³ nio² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jáun² Jesús ca³záɨh³ tsá² hí³: ―¿He³ láɨh³² sa³ ná¹cuóun¹ bíh¹ hnoh²? Má²né³² nú¹ tianh³ náh² hi³ lienh¹ náh² siáh³ Dió³², hi³ jáun² tiá² lɨ́¹³ tánh³² náh² tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² bíh¹ Jesús, cuan³ Judas, hi³ má²hí¹quionh³ juóun³² tsáu². Tsá² hí³ jmɨ́¹ lɨ́n³ jan² tsá² quian³tun³ bíh¹; jáun² ca³ja³janh³², hi³ ca³hen³ ñí¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jáun² Jesús ca³záɨh³ Judas hí³: ―¿Hí¹ cun³quionh³ hi³ hen²³ hnú² ñí¹ Jon² Tsá²mɨ³cuóun² jɨenh²¹ nú²? ");
INSERT INTO csoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jmɨ́¹ ca³lɨ³tsɨn² jáun² tsá² jmɨ́¹ tionh¹ hí³ quionh³ Jesús hi³ he³ má²lɨ́¹³, jáun² ca³juáh³: ―Hnú² Tɨ³², ¿tiá¹ quiunh¹³ dí² tsá² nɨ́² cun³quionh³ mí¹táɨ³ hmu³ tá¹ tun³ jo²¹? ");
INSERT INTO csoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hi³ jáun² jan² tsá² hí³ ca³jmú³ cu³ ngá¹³ mí¹táɨ³ cuá¹ cuá² chu²¹ quioh²¹ *tsá² má²dí¹hlánh¹ joh¹ mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tɨ³la³ Jesús ca³juáh³: ―¡Cuɨ́¹ lɨ́³ cu³ nɨ́²! Jáun² ca³tí³ dí² cuo² cuá¹ tsá² hí³, jáun² la³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jmɨ́¹ lɨ²¹ jáun² né³, ca³hléh³ Jesús ñí¹con² tsá² ná¹lɨ́n³ mi³jmú³, jɨ³ tsá² jmu² hí³ hua³hí¹³ cuáh³² chín¹, jɨ³ tsá²daun³² tsá² ná¹ñí¹ juú² nɨ́² siáh³, tsá² ca³cha³táunh¹ hí³ hi³ má²caun³. Hi³ jáun² ca³záɨh³ dí² la³ lá²: ―¿Hí¹ má²ñá²taunh²¹ hnoh² hi³ ná¹quiánh¹ náh² mí¹táɨ³ jɨ³ hmá² hi³ jau¹³ náh² jná¹³ hi³ tson³, la³jmɨ́¹ lɨ́³ hi³ jná¹³ bíh¹ jan² tsá² háɨn²? ");
INSERT INTO csoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jmáɨ¹ ca³la³ jɨ́³², tá¹la³ ca³ñí³² jná¹³ ja¹ ñí¹ tionh¹ hnoh² hñu³ cuáh³² chín¹, hí¹ cu³ jéin³² yáh³ tiá² lɨ́¹ ca³tie² hnoh² cuonh² jmɨ́¹jáun². Tɨ³la³ né³² la³ ca³chó³² jmáɨ¹ quián¹³ hnoh², cáun² jmáɨ¹ ná¹niéih²¹ hi³ tsá² hláɨnh¹ jmu² pin³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","La³ cun³ jmɨ́¹jáun² ca³jan³ tsú² Jesús tson³ hi³ ca³ñí¹jan² tsú² la³ tɨ³ hñú¹³ tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹. Jáun² ngau³ ca³lá² Pé¹ sáh³ chí¹cáɨn² ñí¹ uóunh³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jmɨ́¹ ca³cha³táunh¹ tsú² jáun² ñí¹ jáun² né³, ca³jmú³ sɨ́² ñí¹hñú³ jáun². Hi³ jáun² ca³tiánh³ tsú² la³cu³ la³jéin³ sɨ́² jáun². Ja³bí¹ Pé¹ siáh³ ca³cuá³ ja¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jáun² né³, jan² tsá²mɨ³ lɨ́n³ quian²¹ ñí¹ jáun² ca³jɨ́e³ hi³ cuá¹tón²¹ Pé¹ ja¹ jáun², jáun² ca³jɨ́e³ chí¹tiá³ ñí¹ ñí¹ Pé¹, hi³ ca³juáh³: ―Ja³bí¹ tsá²ñuh² lá² jmɨ́¹ ngɨ³² quionh³ tsá² ó³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Tɨ³la³ Pé¹ ca³záɨh³ tsá² hí³: ―Hnú² tsá²mɨ³, hí¹juáh³ tiá² cuóun³² yáh³ jná¹³ tsá² ó³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jmɨ́¹ má²cu³lé³ míh¹ jáun² né³, ca³jɨ́e³² siáh³ jan² tsá² siánh³, hi³ jáun² ca³juáh³: ―Ja³bí¹ hnú² siáh³ jmɨ́¹ ngɨ́h¹ quiúnh¹ tsá² ó³². Tɨ³la³ Pé¹ né³, tiá² ca³ton³ yáh³, hi³ ca³juáh³: ―Hnú² tsá²ñuh², jun³juáh¹³ jná¹³ yáh³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jmɨ́¹ la³ má²cáun² o¹rá¹ jáun² né³, ca³juáh³ siáh³ jan² tsáu²: ―Cu³tí³ bíh¹ tsá²ñuh² lá² uá²jaɨ³² jmɨ́¹ ngɨ³² quionh³ tsá² ó³², quí¹ tsá² hɨ́n¹³ tɨ³ Galilea bíh¹ la³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tɨ³la³ Pé¹ má¹ná¹, la³ má²juáh³ jáun² bíh¹: ―Hnú² tsá²ñuh², hí¹juáh³ tiá² ño¹ yáh³ jná¹³ hi³ juáh³ hnú² nɨ́². Tá¹la³ jmɨ́¹ dí¹hleh³² jáun² bíh¹ Pé¹, ca³hó³ jan² cá¹tsó³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jmɨ́¹jáun² ca³jinh³ Tɨ³² Juo¹³ dí², hi³ ca³jɨ́e³ dí² tɨ³ ñí¹ zenh¹ Pé¹. Jáun² la³ cun³ jmɨ́¹jáun² tsau³ tsɨ́³ Pé¹ la³ cun³ hi³ má²lɨ́²juáh³ jáun² Jesús jmɨ́¹tin²: “Tɨ³ cu³lé³, ñeh² bíh¹ hi³ hau³ cá¹háu², hnú² juáh¹³ hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jmɨ́¹jáun² cua³han³ Pé¹ tɨ³ cheih³² hi³ ca³ñí¹hó² ñí¹jngɨh³² lɨ́n³². ");
INSERT INTO csoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jmɨ́¹ lɨ²¹ jáun² né³, tsá² jmɨ́¹ ná¹jmu² hí³ hua³hí¹³ Jesús ca³cónh³² Jesús cú²nga¹, hi³ ca³quiu³ ca³pan³ dí²; ");
INSERT INTO csoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ca³jnɨ́³ dí² ñí¹ hi³ jáun² ca³záɨh³ dí²: ―Chí³ jáɨ¹³ neh²¹, hin² tsánh² quiú² po²³ nú². ");
INSERT INTO csoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hi³ hliáun³ ñí¹ lɨ́n³² bíh¹ jú¹ hlaɨh³ ca³záɨh³ dí² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jmɨ́¹ má²já²jnia² jáun² né³, ca³ngɨh³² la³jɨ́n³² tsá²daun³² tsá² ná¹ñí¹ juú², jɨ³ tsá² ná¹lɨ́n³ mi³jmú³ quionh³ tsá² ná¹lɨ́n³ tɨ³² liei²¹. Jáun² jmɨ́¹jáun² ca³jan³ tsú² Jesús ñí¹ta²¹ ñí¹ ná¹ngɨh³² jáun² la³jɨ́n³² tsá² ná¹quien² hí³. Hi³ jáun² tsá² hí³ ca³ngáɨ³: ");
INSERT INTO csoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Juah²¹ neh²¹, ¿hí¹ tson² hnú² lɨ́n³ Cristo? Tɨ³la³ Jesús né³, ca³záɨh³ tsá² hí³ la³ lá²: ―Uá¹ cun³ ca³hɨ́e³ yáh³ jná¹³ hnoh² jú¹ tson², jun³ jáun² yáh³ táunh¹³ hnoh² ta²¹; ");
INSERT INTO csoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","hi³ sá¹ cun³ hi³ jmɨ́¹ nga¹ jná¹³ cáun² jáɨ¹³ ñí¹con² hnoh², hí¹juáh³ tiá² ngáɨh¹ bíh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tɨ³la³ nɨ́¹ má¹lɨ³² lá² má¹ná¹, jná¹³ Jon² tsá²mɨ³cuóun², ñí¹ñí²¹ jná¹³ tɨ³ cuá² chu²¹ quioh²¹ Dió³² Tsá² cú² Tsá² juenh². ");
INSERT INTO csoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jáun² ca³la³ jɨ³lɨn² tsú² ca³juáh³: ―¿Hí¹ Jon² Dió³² máh³ hnú²? Jáun² Jesús ca³ngáɨ³: ―Ján³, lɨ́n³ jná¹³ la³ cun³ má²lɨ́²juah²¹ hnoh² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Hi³ jáun² tsá² ná¹ngɨh³² hí³ ca³juáh³ siáh³: ―He³ láɨh³² sa³ ca³lɨ³í¹ máh³ tsá² zih³² jú¹ tson² hno³ dí², já² má²lɨ́²náɨ¹³ bíh¹ dí² hmóu³² jë¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ja³taunh²¹ tsú² ca³la³ jɨ³lɨn², hi³ ja³jan² tsú² Jesús ta³ ñí¹ Pilato. ");
INSERT INTO csoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ñí¹ jáun² ca³ñí¹hna¹³ tsú², hi³ ca³ñí¹juah²¹: ―Tsá² lá² má²ca³tsanh²¹ jnoh¹, hi³ hlianh²³ tsú² tsá² zian² hué³² lá² quiú¹³ jnoh¹; hi³ juáh³ tsú² hi³ tiú²uú² ca³tɨ²¹ má¹hmah²¹ jnoh¹ hmah²¹ hi³ chi² *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma ñí¹con² jnoh¹. Hi³ juáh³ siáh³, hi³ hnga² hí³ bíh¹ néh¹ ja³²lɨ³ quien², hi³ lɨ́n³ Cristo, tsá² lɨ́n³ re²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jmɨ́¹jáun² ca³ngáɨ³ Pilato: ―¿Hí¹ hnú² uá¹ lɨ́n³ nú² Re²¹ juo¹³ tsá² *judíos? Jáun² Jesús ca³juáh³: ―Ján³, tson² bíh¹ la³ juáh³ hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jáun² Pilato ca³záɨh³ tsá² ná¹lɨ́n³ hí³ mi³jmú³, la³ má²quionh³ la³jɨ́n³² tsá² tionh² ñí¹ jáun²: ―Hí¹ cáun² yáh³ tso³ quioh²¹ tsá² lá² tiá² choh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Tɨ³la³ tsá² hí³ má¹ná¹, lɨ³mí¹ tiá³ ca³hléh³ bíh¹, hi³ ca³juáh³: ―Tsá² nɨ́² jlánh¹ quí² zaɨ³² tsɨ́³ tsáu². Ñí¹ ca³ma³liáu³² tsú² hi³ hɨeh³² tsáu², ca³ma³liáu³² tsú² la³ tɨ³ ja¹ tsá² hɨ́n¹³ tɨ³ Galilea, hi³ ca³hɨ́eh³ siáh³ tsá² hɨ́n¹³ tɨ³ Judea, hi³ ca³la³ tɨ³ lá² siáh³ má²cuan². ");
INSERT INTO csoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jmɨ́¹ má²lɨ́²niéi³² jáun² Pilato jáɨ¹³ nɨ́² né³, ca³juáh³: ―¿Hí¹ tɨ³ Galilea hɨ́n¹³ tsá² lá²? ");
INSERT INTO csoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jmɨ́¹ ca³lɨ³ ñi³² tsú² hi³ tson² bíh¹ ñí¹ jáun² hɨ́n¹³ tsú², jáun² ca³zen³ dí² tsú² ñí¹con² Herodes, tsá² cuá¹chín¹ Galilea, quí¹hliá² jmáɨ¹ jáun² ti³tsóh³ jmɨ́¹ cuá³ Herodes hí³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jmɨ́¹ ca³jɨ́en³² jáun² Herodes Jesús jlánh¹ ca³lɨ³ hiún² lɨ́n³² tsɨ́³; quí¹hliá² má²ngau³² jmáɨ¹ bíh¹ hi³ hu²¹ tsɨ́³ tsú² hi³ jɨ́en³² Jesús. Quí¹hliá² má²ca³náɨ³² tsú² hliáun³ hi³ ca³tɨn¹ Jesús, hi³ jáun² cáun² jmɨ́¹ má²hu²¹ tsɨ́³ hi³ jɨ́e³ cáun² li²¹ bíh¹ tsú² hi³ jmu³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jáun² hliáun³ lɨ́n³² hi³ ca³ngáɨh³ dí², tɨ³la³ Jesús tiá² hi³ ca³juáh³ hí¹ cáun² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jáun² la³jɨ́n³² mi³jmú³ quionh³ tɨ³² liei²¹ jlánh¹ ca³qui³ ca³chá³ tso³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jáun² Herodes ca³jmúh³² Jesús, la³ má²quionh³ hliáu³ joh¹, la³juah²¹ dúh¹ jan² tsá² lɨ́¹ tsáu², hi³ cáun² lɨ́¹ ca³quí² ca³cónh³² dí² cú²nga¹, hi³ ca³quinh³ dí² cáun² hmɨh³² jlánh¹ chú³² jniá³, hi³ ca³jmú³ dí² la³jmɨ́¹ lɨ́³ hi³ quien² lɨ́n³² tsú². Jmɨ́¹ lɨ²¹ jáun² né³, ca³chanh³ dí² siáh³ ñí¹con² Pilato. ");
INSERT INTO csoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³juónh³ Pilato re² quionh³ Herodes, quí¹ jmɨ́¹tin² jmɨ́¹ ná¹háun³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Hi³ jáun² Pilato ca³ngɨh³ ca³la³ jɨ́n³² tsá² ná¹lɨ́n³ mi³jmú³, jɨ³ tsá²tan²¹ nɨ́² siáh³, la³ má²quionh³ tsá² juú², ");
INSERT INTO csoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","hi³ ca³záɨh³ dí²: ―Tsá² cua³jan³² hnoh² lá² ñí¹con² jná¹³, hi³ juáh³ hnoh² hi³ tsá² lá² hlianh²³ tsáu²; tɨ³la³ jná¹³ juanh³² ñí¹con² hnoh² hi³ hí¹ cáun² yáh³ tso³ hi³ chah³² hnoh² quioh²¹ tsá² lá² tiá² lin¹ tsoh¹ jná¹³ jmɨ́¹ lɨ́¹cán³ jná¹³ jáun² jú¹ tson² quioh²¹ tsú² ñí¹ ta³ máh¹ hnoh², ");
INSERT INTO csoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","sa³jun³ Herodes yáh³ tsoh³ siáh³. Hi³ jáun² dá² ñí¹con² jná¹³ bíh¹ lɨ́²chanh³ tsú² siáh³ tsá² lá². Já² tiá² lin¹ zia³² yáh³ he³ ca³tɨ²¹ jún³ tsá² lá². ");
INSERT INTO csoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jɨ́³²la³ ti³ quiú¹pan²¹ bíh¹ jná¹³ tsú² ca³lá², hi³ jáun² má¹jáun² lion¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Quí¹ tá¹la³ jmu² jáun² tsá² judíos jmáɨ¹ quioh²¹, ca³tɨn¹ Pilato hi³ lión³² jan² tsá² tson³, quí¹hliá² la³ jáun² jmɨ́¹ ná¹ngɨ²³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tɨ³la³ la³jɨ́n³² tsá² ná¹ngɨh³² hí³ ca³tɨ³ ca³hóh³² tiá³ lɨ́n³², hi³ ca³juáh³: ―¡Cuɨ́¹ jún¹³ tsá² nɨ́², hi³ jáun² cuɨ́¹ liáun¹³ Barrabás! ");
INSERT INTO csoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tsá² jmáɨ² hí³ Barrabás jmɨ́¹ cuá¹tson³ hñu³mí¹ñí², quí¹ cun³ñí¹ hi³ ca³ma³can² tsáu² hi³ tiánh³² tiá³ siaun³² já¹ juú² Jerusalén, hi³ ca³jngɨh³ siáh³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tɨ³la³ Pilato má¹ná¹, jmɨ́¹ hnió³ bíh¹ lión³² Jesús, hi³ jáun² jmɨ́¹ ca³liéinh³² dí² siáh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Tɨ³la³ tsá² ná¹ngɨh³² hí³ má¹ná¹, tɨ³ lɨ³mí¹ tiá³ ca³tɨ³ ca³hóh³² bíh¹, hi³ ca³juáh³ siáh³: ―¡Cuɨ́¹ taun¹ tsá² nɨ́² crei²¹! ¡Cuɨ́¹ taun¹ tsá² nɨ́² crei²¹! ");
INSERT INTO csoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jáun² ñí¹ má²hnaɨh³² jéin³² ca³juáh³ siáh³ Pilato la³ lá²: ―Tɨ³la³ ¿he³ dá² hi³ hlaɨh³ má²ca³jmú³ tsú² né³? Quí¹ hí¹ cáun² yáh³ tso³ quioh²¹ tsú² tiá² lin¹ tsoh¹ jná¹³ hi³ juáh¹³ hi³ ca³tɨn¹ tsú² jún³. Cáun² cuɨ́¹ pan²¹ jná¹³ tsú², hi³ jáun² má¹jáun² lion¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Tɨ³la³ la³ má²ná¹tɨ́² ná¹hóh³² jáun² bíh¹ tsú², hi³ ná¹hiú² ná¹mɨ³² hi³ taun³ Jesús crei²¹; ca³la³ ñí¹ ca³lɨ³ quien² hi³ ná¹juáh²³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Hi³ jáun² cáun² ca³jmú³ bíh¹ cú²jueh³² Pilato la³ cun³ hi³ ná¹hiú² ná¹mɨ³² jáun² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hi³ jáun² Barrabás tsá² tɨ³² hí³ tsɨ́³ bíh¹ tsú² ca³lión³², tsá² ca³ma³can² hí³ tsáu² hi³ tónh³² tiá³ siaun³², tsá² ca³jngɨh³ hí³ tsáu². Jáun² Jesús bíh¹ ca³jɨenh³ dí² hi³ jmúh³² tsú² la³ cun³ hi³ hnió³ tsú² jmúh³². ");
INSERT INTO csoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jmɨ́¹ jáun² ca³jan³ tsú² Jesús hi³ má²já²ton³ dí² crei²¹, hi³ jáun² hú¹ juɨ³² jáun² né³, ca³zanh³ tsú² jan² tsá²ñuh² tsá² juú² Cirene, tsá² jmáɨ² Sí¹mu²¹, hi³ jmɨ́¹ má²cuá¹hen² já¹ juú²; hi³ jáun² ca³di³quian³ dí² Sí¹mu²¹ hí³ jmáɨ¹ hi³ cán³ crei²¹ hi³ jmɨ́¹ quian³² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hi³ jáun² juóun³² lɨ́n³² bíh¹ tsáu² ja³taunh²¹ cu³chin¹, hi³ juóun³² lɨ́n³² siáh³ tsá²mɨ³ hí¹hóh³², hi³ hí¹ho² hi³ ca³tɨn¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tɨ³la³ Jesús ca³jɨ́e³ tɨ³ ñí¹ hí¹já²táunh¹ jáun² tsá² hí³, hi³ ca³juáh³: ―Hnoh² tsá²mɨ³, tsá² Jerusalén lá², ha³ lɨ́² uó² náh² hi³ ca³tɨn¹ jná¹³. Uo³ náh² hi³ ca³tɨn¹ náh² hmóu³² bíh¹, jɨ³ hi³ ca³tɨn¹ jónh³² náh² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Quí¹ chau²¹ jmáɨ¹ hi³ juáh³ tsáu²: “Hen³ ma³ jmɨ́¹ ren² tsá² tiá² jon² zian², tsá² cónh³ tiá² dáɨn² ca³can³, tsá² cónh³ tiá² dáɨn² ca³tiunh³”. ");
INSERT INTO csoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hi³ jáun² jmáɨ¹ jáun² hléh³² tsáu², hi³ záɨh³² máh³: “Cuɨ́¹ quɨh²¹ nú² ñí¹ quiú¹³ jnoh¹”; hi³ záɨh³² tsú² siáh³ ñí¹ lɨ́³ tsɨ³cuánh²: “Cuɨ́¹ jlaɨn²¹ jnoh¹ hnú²”. ");
INSERT INTO csoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Quí¹ nɨ́¹juáh³ ta³bí¹ ñí¹con² jná¹³ tsá² lɨ́n³ ná¹ la³jmɨ́¹ lɨ́³ cáun² hmá² réh¹ yáh³ má²ná¹jmu² tsá² *romanos la³ lá², tiá¹³ bíh¹ tiá³ ñí¹con² hnoh² tiá² jmu³ tsú², hnoh² tsá² juú² Jerusalén lá², tsá² ná¹lɨ́n³ náh² la³jmɨ́¹ lɨ́³ hmá² má²quiéin². ");
INSERT INTO csoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ja³bí¹ ca³jan³ tsú² siáh³ gon³ tsá² ca³jmú³ tso³ jueh³², hi³ jngɨh³ tsú² cu³tsa³² quionh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jmɨ́¹ ca³cha³táunh¹ tsú² jáun² tsɨ³ máh³ míh¹ téh²³ tsú² jáun² máh³ Mú³² Chí¹ Tsáu², ñí¹ jáun² ca³ton³ tsú² Jesús crei²¹, la³ má²quionh³ tsá² gon³ hí³, jan² tɨ³ cuá² chu²¹, hi³ jan² tɨ³ cuá² cáun¹ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hi³ jáun² tá¹la³ má²chí¹tón²¹ jáun² Jesús crei²¹, ca³juáh³: ―Tia²¹, juenh² jmu³ honh² quioh²¹ tsá² lá², quí¹ cáun² hi³ tiá² ñi³² bíh¹ tsú² ná¹jmu². Hi³ jáun² hliáu³ tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² né³, ca³chí² jáɨ¹³, hi³ jáun² jɨ́e³ dí² nɨ́¹juáh³ hin² joh¹³ ha¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tsá² jmɨ́¹ tionh¹ có³² jáun² né³, jmɨ́¹ ná¹jɨ́en³² Jesús. Hi³ tsá²tan²¹ né³, ca³hléh³ hlaɨh³ quioh²¹ Jesús, hi³ juáh³ la³ lá²: ―Ca³lión³² bíh¹ tsá² nɨ́² tsá² siánh³; jáun² ta³né³² né³, cuɨ́¹ lión²¹ siáh³ hnga² neh²¹, nɨ́¹juáh³ tson² bíh¹ cu³tí³ lɨ́n³ tsú² Cristo, Tsá² ca³quianh³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ja³bí¹ hliáu³ siáh³ ca³cónh³² cú²nga¹ Jesús, hi³ ca³jen³ dí² mu² má²zéih¹ lɨ́n²¹ quioh²¹ mɨ³ uóun²jɨeh¹³; ");
INSERT INTO csoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","hi³ ca³záɨh³ dí² siáh³: ―Nɨ́¹juáh³ tson² cu³tí³ hnú² lɨ́n³ Re²¹ Juo¹³ tsá² judíos, jáun² né³, lion¹ hnú² huen² neh²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hi³ jáun² hná¹³ crei²¹ jáun² jmɨ́¹ chí¹tón²¹ huéh³ hi³ juáh³: “Tsá² Lá² Lɨ́n³ Re²¹ Juo¹³ Tsá² Judíos”. Huéh³ jáun² jmɨ́¹ lɨ́³ jú¹ *griego, jú¹ *latín, jɨ³ jú¹ *hebreo nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hi³ jáun² jan² tsá² ná¹tón²¹ hí³ crei²¹ né³, ca³hléh³ hlaɨh³ quioh²¹ Jesús, hi³ ca³juáh³: ―Nɨ́¹juáh³ tson² hnú² la³ lɨ́n³ Cristo, lion¹ hnú² huen² neh²¹, hi³ jáun² má¹jáun² liau¹ nú² siáh³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tɨ³la³ ñí¹ tsá² jan² hí³ má¹ná¹, tiá³ bíh¹ ca³liéinh³² tsá² jan² hí³, hi³ ca³juáh³: ―¿Há¹ tiá² juénh² hnú² Dió³²? Já² cá²re² má²ta³tsa¹ bíh¹ dí² héih³². ");
INSERT INTO csoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tɨ³la³ tsá² lá² má¹ná¹, hí¹ cáun² yáh³ tiá² lin¹ hi³ ca³jmú³. Tɨ³la³ jnoh¹ né³, zia³² jáɨ¹³ bíh¹ hi³ ná¹má²tso¹ dí² tsɨ³², quí¹ cun³ñí¹ hi³ ná¹má²hmah²¹ dí² tso³ hi³ ca³jmú¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hi³ jáun² ca³záɨh³ dí² siáh³ Jesús: ―Hnú² Jesús, cháu¹ hnú² honh² quion²¹ jná¹³ nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ ñi³hauh³² hnú² jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² hí³: ―Jú¹ tson² cu³tí³ juanh³² jná¹³, hi³ né³² cuá¹ñíh³ hnú² quiúnh¹ jná¹³ ñí¹ chu²¹ ñí¹ má²nio² tie³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hi³ jáun² jmɨ́¹ má²tí³ cun³ chi³hiú² né³, ca³nieh² tá¹ cáun² hué³², ca³la³ ñí¹ tɨ́³ la³nió¹ hnɨ³² tɨ³ ca³hláu³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jmɨ́¹ ca³nieh² jáun² hiú² né³, ca³zen³ tɨ³ tun³ zaɨnh²¹ hmɨh³² hi³ jmɨ́¹ hí¹jnáɨ²³ ñí¹ jlánh¹ hɨ́en¹ hñu³ cuáh³² chín¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³hóh³² Jesús tiá³ lɨ́n³², hi³ ca³juáh³: ―Tia²¹, jo³cuonh² hnú² cuɨ́¹ nio² jmɨ́²chí³ quion²¹ jná¹³. Jmɨ́¹ má²lɨ́²juáh³ jáun² la³ nɨ́² né³, jun³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jmɨ́¹ ca³jɨ́e³ jáun² hliáu³ tsá² chín¹ tsá² *romano hi³ lɨ³ la³ jáun² né³, ca³ma³quien² Dió³², hi³ ca³juáh³: ―Tson² bíh¹ cu³tí³, tiá² tso³ la³ ca³jmú³ yáh³ tsá² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jmɨ́¹ má²lɨ́²jɨ́e³ jáun² la³jɨ́n³² tsá² ná¹ngɨh³² hí³ ñí¹ jáun² hi³ lɨ³ la³ jáun², jmɨ́¹jáun² já¹tanh²¹ ca³la³ quí² quien² ñí¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tɨ³la³ la³jɨ́n³² tsá² jmɨ́¹ cuóun²¹ hí³ Jesús má¹ná¹, jɨ³ tsá²mɨ³ tsá² má²ca³ñi³táunh¹ cu³hna²¹ tsú² ca³la³ tɨ³ hué¹³ Galilea, lɨ́¹ ca³ta³ná¹jɨ́e²³ ñí¹ uóunh³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Jáun² jmɨ́¹jáun² jmɨ́¹ zian² jan² tsá² jmáɨ² Sé³², tsá² chun¹, tsá² tɨ³² tsɨ́³ jmáh³la³ hi³ chu²¹. Tsá² hí³ jmɨ́¹ quionh³ tsá² ná¹lɨ́n³ ta²¹ hi³ chín¹; ");
INSERT INTO csoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","tɨ³la³ tsá² hí³ má¹ná¹, tiá² ca³jmú³ yáh³ cá²hon³ quionh³ tsá² ñí¹ hná¹ jáun². Tsá² hí³ né³, jan² tsá² zian² juú² Arimatea hɨ́n¹³ tɨ³ Judea bíh¹, hi³ jmɨ́¹ má²jan³² hi³ lɨ³ lin¹ hin² tsánh² má²ca³hión³² Dió³² hi³ hau³ jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hi³ jáun² Sé³² hí³ bíh¹ ñéi¹ hi³ ca³ñí¹ma¹³ hla¹ Jesús ñí¹con² Pilato. ");
INSERT INTO csoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jmɨ́¹ má²lɨ́²sión³² tsú² jáun² hla¹ né³, ca³tsáɨnh³² tsú² cáun² hmɨh³² jmuh³ tiáu²; hi³ jáun² ca³ñí¹hón²¹ dí² hñu³ tá²hláu² quioh²¹ hi³ jmɨ́¹ má²ca³hó³ dí², ñí¹ hí¹ jan² hla¹ tiá² jmɨ́¹ má²ca³tanh² tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jmáɨ¹ jáun² jmáɨ¹ hi³ jmu² tsá² judíos hua³jan²¹ la³jɨ́³² hi³ hniáuh³² quioh²¹ *jmáɨ¹ hi³ tionh² tsú² tie³. Quí¹ jmɨ́¹ má²ca³hláu³ lɨ́n³² bíh¹, má²ja³quián³ lɨ³liau³ cu³tí³ bíh¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hi³ jáun² tsá²mɨ³, tsá² jmɨ́¹ quionh³ hí³ Jesús jmɨ́¹ cuá¹han³ Galilea ja³taunh²¹ cu³chin¹ hi³ ca³ñí¹jɨ́e¹³ ñí¹ já¹haun³ Jesús, nɨ́¹juáh³ ha³ lánh³ quión³² tsú² hla¹. ");
INSERT INTO csoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jmɨ́¹ ca³cha³tánh¹ tsú² jáun² hñú¹³ né³, ca³jmú³ hua³jan²¹ háu² má²ró³² jɨ³ no¹ má²ró³² nɨ́² siáh³. Jmɨ́¹ cá¹chó²¹ jáun² jmáɨ¹ nio² tie³ né³, ca³tiánh³ bíh¹ tsú² tie³ la³ cun³ hi³ rá¹juáh³ liei²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Jmáɨ¹ hi³ ca³lɨ³liau³ jáun² sɨ́²ma¹ná¹, ja³taunh²¹ siáh³ tsá²mɨ³ hí³ hú²niéi² lɨ́n³² ñí¹ ca³ñí¹hón²¹ tsú² jáun² Jesús, hi³ má²ná¹quian³² hi³ má²ró³² má²ca³jmú³ jáun² hua³jan²¹. Ja³bí¹ zian² ma³ jan² tsá²mɨ³ siánh³ siáh³ ca³ñí¹quionh¹³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jmɨ́¹ ca³cha³táunh¹ tsú² jáun² ho³ tá²hón³² né³, ca³jɨ́e³ tsú² hi³ tiú²uú² dí¹jnáɨ²³ yáh³ quɨ́n¹ ho³ tá²hón³² jáun², quí¹ tɨ³ có³² bíh¹ la³ má²lɨ́²lɨ́h³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Jáun² ca³taunh³ tsú² hñu³ tá²hón³² jáun², tɨ³la³ tiá² tsanh²¹ yáh³ tsú² hla¹ Jesús Tɨ³² Juo¹³ dí². ");
INSERT INTO csoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Tá¹la³ má²ná¹hɨ³² lɨ́n³² jáun² tsɨ́³ tsú² né³, ca³jɨ́en³² gon³ tsá²ñuh² quih³² hmɨh³² tiáu² zɨ́n³ lɨ́n³² hi³ tionh² có³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jáun² tsá²mɨ³ hí³ né³, ca³yá²han¹ lɨ́n²¹ bíh¹, jáun² cáun² ca³hiéih³ hué³² bíh¹ tsú² ñí¹. Jáun² tsá²ñuh² hí³ né³, ca³juáh³: ―¿He³ láɨh³² sa³ ñí¹ ca³tɨn¹ tsá² má²cá²tsan³ yáh³ hnah²³ hnoh² jan² tsá² zian²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ha³ tiú²uú² hin² zian² yáh³ ñí¹ lá², tsá² má²ca³jenh¹³ bíh¹ hí³. Cháu¹ náh² tín² honh² jáɨ¹³ hi³ ca³juáh³ tsú² jáun² tá¹la³ jmɨ́¹ cuá³ tsú² jáun² Galilea, ");
INSERT INTO csoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","hi³ ca³juáh³ tsú² jáun² la³ lá²: “Ca³tɨn¹ Jon² tsá²mɨ³cuóun² hi³ jɨenh³ tsú² ñí¹con² tsá² jmu² tso³, hi³ lɨ³ hniáuh³² siáh³ ton³ tsú² ñí¹ crei²¹, hi³ ñí¹ cá²hnɨ́² jmáɨ¹ jáun² né³ ca³tɨn¹ jenh¹³”. ");
INSERT INTO csoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Hi³ jáun² jmɨ́¹jáun² ca³chau³ tsá²mɨ³ hí³ tsɨ́³ jáɨ¹³ hi³ ca³juáh³ jáun² Jesús jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jmɨ́¹ má²cuá²tanh²¹ tsú² jáun² hi³ ñí¹jɨ́e¹³ tá²hón³² né³, ca³chá³ ñí¹con² tsá² quian³jan² haɨn²¹ hí³ tɨ³ con² Jesús, jɨ³ ñí¹con² la³jɨ́n³² tsá² ñí¹ hná¹ jáun² nɨ́² la³ cun³ hi³ má²lɨ́²jɨ́e³, jɨ³ hi³ má²lɨ́²niéi³². ");
INSERT INTO csoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Tsá²mɨ³ tsá² ca³ñí¹can³² hí³ jáɨ¹³ jáun² ñí¹con² tɨ³² tsá² quian³² hí³ jë¹ Dió³², jmáɨ²: Má²réi³ tsá² ja³ juú² Magdalá, mɨ́¹ Juánh³, Má²réi³ mí¹ziú¹³ Jacobo, jɨ³ tsá²mɨ³ siánh³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Tɨ³la³ tɨ³² tsá² quian³² hí³ jë¹ Dió³² má¹ná¹, tiá² ta²¹ ca³taunh³ yáh³ jë¹ tsá²mɨ³ hí³, quí¹hliá² ca³lɨ́n¹³ tsú² hi³ lɨ́¹ ca³lɨ³can² bíh¹ tsá²mɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Tɨ³la³ cun³ jáun² la³juɨ³² ca³náu² bíh¹ Pé¹ hi³ ngau³ cú²hé² hi³ ja³jɨ́e³ tá²hón³². Jmɨ́¹ cá¹chó²¹ tsú² jáun² né³, ca³jmú³ hí¹sian², hi³ ca³jáɨh³ ñí¹ tɨ³ ñéih³, jáun² ca³jɨ́e³ tsú² hi³ tɨ³ có³² bíh¹ má²nio² hmɨh³² tiáu² hi³ jmɨ́¹ tsaɨnh³² jáun² hla¹ Jesús. Jmɨ́¹ lɨ²¹ jáun² ngah³ hñú¹³, ca³la³ má²hí¹tsá²cáun² lɨ́n³² tsɨ́³ ca³tɨ²¹ la³ cun³ hi³ má²lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ja³bí¹ jmáɨ¹ jáun² siáh³ ja³taunh²¹ gon³ tsá² hí³ cáun² juú² jmáɨ² Emaús. Juú² jáun² tí³ cun³ quia³cáun² kilómetros tɨ³la³ uóunh³ hi³ tionh² tsú² já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jáun² ca³chon¹ tsú² jáɨ¹³ tá¹la³ hí¹tiáunh¹ jáun² juɨ³², hi³ ca³juónh³ tsú² ca³tɨ²¹ la³jɨ́³² hi³ má²lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tá¹la³ jmɨ́¹ hí¹chon¹ tsú² jáun² jáɨ¹³ né³, ngau³ Jesús má²janh² ñí¹ hí¹tsá²táunh¹ tsá² hí³, jáun² ngau³ dí² cu³tsa³² quionh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Tɨ³la³ uá¹jinh¹ ca³jɨ́en³² tsú² tsá² cuá¹ja³² hí³ quionh³, cun³ jáun² ta²¹ lɨ³ bíh¹ hi³ tiá² ca³lɨ³tsɨn² tsú² hi³ Jesús bíh¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hi³ jáun² Jesús ca³ngáɨh³ tsá² hí³: ―¿He³ nɨ³² hí¹juónh³² hnoh²? Jáun² jmɨ́¹jáun² ca³ta³tonh¹ tsú² hú¹ juɨ³², hi³ má²ná¹haɨ²¹ hlaɨh³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Hi³ jáun² jan² tsá² hí³, tsá² jmáɨ² Cleofas, ca³ngáɨ³, hi³ ca³juáh³: ―¿Hí¹ huen² tán¹ nɨ́² uá¹ hnú² tsá² tiá² ca³lɨ³ ñíh¹ nú² la³jɨ́³² hi³ má²lɨ³² já¹ juú² Jerusalén cháu³ jau³ nɨ́², tá¹la³ hi³ ñéi¹ nú² nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Hi³ jáun² Jesús ca³ngáɨ³: ―¿He³ má²lɨ³² dúh¹? Hi³ jáun² tsá² hí³ ca³juáh³ siáh³: ―Zia³² hi³ má²lɨ³² ñí¹con² jan² tsá² jmáɨ² Jesús, tsá² ja³ juú² Nazaret. Tsá² hí³ tɨ́² lɨ́n³ jan² *tɨ³² jë¹ Dió³², tsá² tɨ́² jmu² hua³jueh³², hi³ ca³la³ hi³ pin³ lɨ́n³² jáɨ¹³ quioh²¹ tsú² tɨ́² hleh³²; jan² tsá² tɨ́² hniau³ lɨ́n³² Dió³², jɨ³ tsá²mɨ³cuóun² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tɨ³la³ tsá² ná¹lɨ́n³ mi³jmú³ má¹ná¹, la³ má²quionh³ tsá²tan²¹, ca³ma³tsón¹³ bíh¹ tsá² hí³, hi³ ca³ñí¹jɨenh¹³ dí² tsá² hí³ ñí¹con² tsá² *romanos tsá² chín¹; hi³ jáun² tsá² hí³ jngɨh³ Jesús, hi³ jáun² ca³ton³ tsú² crei²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jnoh¹ jmɨ́¹ má²hu²¹ tsɨ́³ hi³ tsá² hí³ jmɨ́¹ liáu²¹ dí² tsá² *Israel. Tɨ³la³ ta³né³² má²tí³ hnɨ³² jmáɨ¹ hi³ ca³lɨ³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tɨ³la³ zian² tsá²mɨ³, tsá² ja¹ hmóu²¹ jnoh¹, hi³ cuɨ́²ñí¹jɨ́e¹³ tá²hón³² jmɨ́¹ hú²niéi² lɨ́n³². Jmɨ́¹ cuá¹tanh²¹ tsú² jáun² né³, lɨ́²jmú³ tsú² hi³ tsa³cáun² lɨ́n³² tsɨ́³ jnoh¹, ");
INSERT INTO csoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","quí¹ lɨ́²chá³² tsú² hi³ tiá² hla¹ tsanh²¹ yáh³, hi³ jɨ́³²la³ tsá²cuú² tsá²ta³ Dió³² bí¹ néh¹ ca³jnia³ jéinh³² dí², hi³ lɨ́²juáh³ hi³ zian² bíh¹ néh¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jmɨ́¹ lɨ²¹ jáun² né³, cuɨ́²ñí¹jɨ́e¹³ siáh³ ma³ jan² tsá² quiúnh¹ jnoh¹ tá²hón³² jáun², hi³ jáun² la³ cun³ rón³² hi³ má²lɨ́²juáh³ jáun² tsá²mɨ³ hí³ bíh¹ lɨ́²jɨ́e³ tsú² siáh³, tɨ³la³ tiá² Jesús ca³jenh² yáh³ tsú² má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² hí³ la³ lá²: ―¡Jlánh¹ tiá² niuh¹ hnoh²! ¿Hín² máh³ jmáɨ¹ táunh¹³ hnoh² ta²¹ la³jɨ́³² jáɨ¹³ hi³ ca³juáh³ jáun² la³jɨ́n³² tsá² ca³lɨn³ hí³ tɨ³² jë¹ Dió³² jmɨ́¹tin²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Há¹ tiá² jmɨ́¹ hniáuh²¹ hi³ ma³tso² Tsá² lɨ́n³ Cristo tsɨ́³ la³ jáun² dúh¹; ñeh² bíh¹ hi³ lɨ³jnia² hi³ quien² tsú²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hi³ jáun² jmɨ́¹jáun² ca³jmú³ Jesús na²¹ la³jɨ́³² jáɨ¹³ hi³ rá¹juáh³ jáun² ñí¹ Sí² quioh²¹ Dió³² hi³ ca³tɨn¹ tsú² hnga². Jáun² ñí¹ Sí² quioh²¹ hla¹ Moisés tín² ca³ma³liáu³² tsú² hi³ jmu² na²¹; jmɨ́¹ lɨ²¹ jáun² né³, ca³chá³ siáh³ la³jɨ́³² jáɨ¹³ hi³ rá¹tioh³ jáun² ñí¹ Sí² quioh²¹ la³jɨ́n³² tsá² ca³lɨn³ hí³ tɨ³² jë¹ Dió³² jmɨ́¹tin². ");
INSERT INTO csoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jmɨ́¹ ca³cha³táunh¹ tsú² jáun² juú² ñí¹ tsa³táunh¹, jmɨ́¹jáun² ca³jmú³ Jesús la³jmɨ́¹ lɨ́³ hi³ cáun² tsó³² bíh¹ tɨ³ chí¹ján³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tɨ³la³ tsá² hí³ jlánh¹ chí¹tson³ ca³chan³ Jesús, hi³ ca³záɨh³ dí²: ―Ñí³ dá² quiúnh¹ jnoh¹; já² má²ca³hláu³ bíh¹, já² má²ñí¹zɨ³² bíh¹ dá² la³². Hi³ jáun² né³, ca³cuá³ bíh¹ Jesús quionh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jmɨ́¹ má²cuá³ tsú² jáun² ñí¹ mesa cu³tsa³² quionh³ tsá² hí³ né³, ca³can³ cáun² hí¹miih²¹, jáun² ca³ma³hɨen²¹ dí²; jmɨ́¹jáun² ca³tsunh³ dí² siáh³, hi³ ca³cuéh³ dí² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Hi³ jáun² la³ cun³ jmɨ́¹jáun² ca³niá³ ñí¹ tsá² hí³ hi³ ca³lɨ³ cuóun³² tsú² siáh³ Jesús. Tɨ³la³ la³ cun³ jmɨ́¹jáun² bíh¹ ca³yéin² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jmɨ́¹ lɨ²¹ jáun² né³, hi³ jan² hi³ jan² bí¹ tsú² ca³záɨh³ raɨnh²¹: ―¿Haun¹³ juáh¹³ re² lɨ́n³² bíh¹ tɨ́³ tsɨ́³ dí² jáɨ¹³ hi³ lɨ́²hléh³² tsú² jáun² jmɨ́¹ hí¹jau³² dí² jáun² hú¹ juɨ³² dúh¹, jmɨ́¹ lɨ́¹jmú³ tsú² jáun² na²¹ jáɨ¹³ hi³ rá¹tioh³ ñí¹ Sí² quioh²¹ Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ já¹tanh²¹ tsú² tɨ³ já¹ juú² Jerusalén. Hi³ jáun² ñí¹ jáun² ca³jenh² tsú² tá¹ quian³jan² tsá² lɨ́n³ hí³ *tɨ³² tsá² quian³² jë¹ Dió³², quionh³ tsá² siánh³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Hi³ jáun² tsá² ná¹ngɨh³² hí³ ca³juáh³: ―¡Tson² bíh¹ cu³tí³ ca³jenh¹³ Tɨ³² Juo¹³ dí², quí¹ ja³bí¹ ñí¹con² Sí¹mu²¹ Pé¹ yáh³ lɨ́²ma³jnia³² tsú² má²hmáɨ³! ");
INSERT INTO csoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Hi³ jáun² tsá² gon³ hí³ né³, ca³chá³ la³ cun³ hi³ ca³lɨ³ jáun² hú¹ juɨ³² tá¹la³ jmɨ́¹ hí¹tsá²táunh¹ tsú² jáun², jɨ³ ha³ lánh³ rón³² ca³lɨ³ cuóun³² dí² Jesús jmɨ́¹ ca³tsóh³ jáun² hí¹miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tá¹la³ jmɨ́¹ ná¹cha³² jáun² tsá² gon³ hí³ jáɨ¹³ jáun² bíh¹, ca³ma³jnia³² Jesús cu³diá²jan² la³ lá² ja¹ ñí¹ tionh¹ jáun² tsá² ná¹ngɨh³² hí³, hi³ jáun² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Cuɨ́¹ zian² náh² cáun² hi³ re² hi³ tɨn². ");
INSERT INTO csoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tɨ³la³ tsá² hí³ má¹ná¹, ca³yá²han¹ lɨ́n²¹ bíh¹, hi³ ca³lɨ́n¹³ tsú² hi³ jan² tsá² le¹ bíh¹ ná¹jɨ́en³². ");
INSERT INTO csoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tɨ³la³ Jesús ca³juáh³: ―¿He³ láɨh³² sa³ ná¹juenh²¹ hnoh², hi³ ná¹hɨ³² honh² náh²? ");
INSERT INTO csoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Sá¹nɨ́² jɨe³ hnoh² uón³² jná¹³, jɨ³ tán² jná¹³; jná¹³ bíh¹ la³². Sá¹nɨ́² ñá²tí³ náh² cuonh² quion²¹ jná¹³, jáun² lɨ³ ñíh¹³ náh² hi³ jná¹³ bíh¹ la³². Quí¹ tiá² zia³² yáh³ ngú³ sa³jun³ mú³² quioh²¹ jan² jmɨ́²chí³ la³ cun³ hi³ ná¹jɨ́eh³² hnoh² hi³ zia³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jmɨ́¹ má²lɨ́²juáh³ jáun² la³ nɨ́² tsú², ca³hɨ́eh³ tsá² hí³ cuo² jɨ³ ta³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jáun² tsá² hí³ ca³lɨ³ tsah³ lɨ́n³², tɨ³la³ cun³ jáun² tiá² re² jmɨ́¹ ná¹taunh³² bíh¹ tsú² ta²¹ quí¹ cun³ñí¹ hi³ jmɨ́¹ ná¹tsá²cáun² jáun² tsɨ́³. Tɨ³la³ Jesús la³juɨ³² ca³juáh³: ―¿Zia²¹ ca³lá² má³² hi³ lɨ³ cúh¹³? ");
INSERT INTO csoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jáun² tsá² hí³ ca³cué³ ca³lá² quioh²¹ jáh³ jmáɨ² hi³ má²lɨ́²tió³² ñí¹ sɨ́², la³ má²quionh³ ca³lá² ñí¹ ha²¹ jmɨ́²toh¹ quioh²¹ toh². ");
INSERT INTO csoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jáun² ca³héi³ dí² hi³ jáun², hi³ ca³cúh² ta³ ñí¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jmɨ́¹jáun² ca³záɨh³ dí² siáh³ tsá² hí³ la³ lá²: ―Má²ca³lɨ³tí³ bíh¹ ñí¹con² jná¹³ la³ cun³ hi³ ca³juánh³² jná¹³ jáun² jmɨ́¹tin², tá¹la³ ca³ngɨ́³ jná¹³ jáun² quiúnh¹ hnoh². Ca³juánh³² jná¹³ hi³ hniáuh³² lɨ³tí³ la³jɨ́³² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ liei²¹ quioh²¹ hla¹ Moisés hi³ ca³tɨn¹ jná¹³, ñí¹ Sí² quioh²¹ la³jɨ́n³² tsá² ca³lɨn³ hí³ tɨ³² jë¹ Dió³², jɨ³ ñí¹ Sí² salmos nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jmɨ́¹ lɨ²¹ jáun² né³, ca³nia³ dí² tsɨ́³ tsá² hí³, hi³ jáun² ngɨ¹³ tsú² la³jɨ́³² hi³ rá¹juáh³ jáun² ñí¹ Sí² quioh²¹ Dió³², ");
INSERT INTO csoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","hi³ ca³záɨh³ dí² la³ lá²: ―Ñí¹ Sí² rá¹juáh³ hi³ ca³tɨn¹ tsá² lɨ́n¹³ Cristo ma³tso² tsɨ́³; hi³ nɨ́¹ má¹jun² jáun² né³, ca³tɨn¹ siáh³ jenh¹³ ñí¹ cá²hnɨ́² jmáɨ¹ ja¹ tsá² má²cá²tsan³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Má¹lɨ³² jáun² né³, tsa³ngáɨ¹ tsáu² jú¹ chú³² cha¹³ tsú², hi³ tsa³juah²¹ tsú² hi³ zia³² uu³i³tso³ quioh²¹ tsá² záɨ³² jmɨ́¹ tsɨ́³, hi³ jinh²¹ tɨ³ ñí¹con² hí³ dí². Hi³ lɨ³ hniáuh³² tsa³táunh¹ tsú² tá¹ cáun² hngá¹máh³, hi³ ma³liáu³² tsú² já¹ juú² Jerusalén lá² tín². ");
INSERT INTO csoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hnoh² bíh¹ tsá² cuá¹ngáɨ¹ jáɨ¹³ ca³tɨ²¹ hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Sá¹nɨ́² niéi² náh², jná¹³ zein²¹ ñí¹con² hnoh² la³ cun³ lɨ́³ jáɨ¹³ hi³ má²ca³jmú³ jáun² Ñuh³² jná¹³. Tɨ³la³ tianh³ náh² tín² já¹ juú² Jerusalén lá², ca³la³ ñí¹ cá¹chó²¹ jmáɨ¹ hi³ hián¹³ náh² pí³ hi³ já³² hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hi³ jáun² Jesús ca³jan³ tsá² hí³ tɨ³ cheih³² juú² jáun², ca³la³ tɨ³ có³² juú² Betania; hi³ jáun² ñí¹ jáun² ca³háɨ³² dí² cuo² hi³ ca³ma³miih² dí² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jáun² la³ má²má²miih² jáun² bíh¹ dí² tsá² hí³, jmɨ́¹ cuá¹han³ dí² ja¹ ñí¹ tionh¹ tsú², hi³ ca³zanh³² dí² tɨ³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jmɨ́¹ má²lɨ́²ma³tsú² ma³jónh³² tsú² jáun² Jesús né³, hiún² lɨ́n³² bíh¹ tsɨ́³ tsú² já¹tanh²¹ tɨ³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Hi³ jáun² tsá² hí³ jmɨ́¹ tɨ́² ngɨh³² cun³ tsa³háu² hñu³ cuáh³² chín¹ quioh²¹ tsá² *judíos, hi³ má²quien² Dió³². Cun³ nɨ́² bíh¹ tí³ jáɨ¹³.");
INSERT INTO csoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jmɨ́¹ ca³lɨ³zia³² ca³la³ jɨ́³² hi³ zia³², jmɨ́¹ má²zian² bíh¹ Tsá² lɨ́n³ hí³ Jáɨ¹³. Tsá² hí³ né³ jmɨ́¹ má²cuá³ bíh¹ quionh³ Dió³², hi³ Tsá² lɨ́n³ hí³ Jáɨ¹³ né³, hnga² bíh¹ Dió³² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","La³ cun³ jmɨ́¹tin² jmɨ́¹ má²cuá³ bíh¹ tsú² quionh³ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cun³quionh³ hí³ bíh¹ dí² ca³jmú³ Dió³² ca³la³ jɨ́³² hi³ zia³², hí¹ cáun² yáh³ hi³ zia³² tiá² ca³lɨ³ ta³ tiá² quiéinh¹ hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hí³ bíh¹ lɨ́n³ mí¹zioh²¹ quioh²¹ pí³ hi³ lɨ́¹³ zian² ca³la³ jɨ³lɨ³² hi³ zia³². Hi³ Tsá² tsóh²³ hí³ pí³ jáun² né³ lɨn³ siáh³ joh¹ sɨ́² hi³ táɨ³ jáun² ñí¹con² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Joh¹ sɨ́² jáun² né³ taɨ³² ñí¹ já¹niéi², tɨ³la³ já¹niéi² jáun² né³ tiá² má²ca³cah¹³ yáh³ jmáɨ¹ hi³ jmu³ quien² ñí¹con² joh¹ sɨ́² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jáun² né³, ca³lɨ³zian² jan² tsá² zéi¹ Dió³² ñí¹ hué²¹ lá², tsá² hí³ jmáɨ² Juan². ");
INSERT INTO csoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tsá² hí³ cuan³ hi³ lɨ́n³ tsá² zih³² jú¹ tson² hi³ ca³tɨn¹ Tsá² lɨ́n³ hí³ joh¹ sɨ́² jáun², hi³ jáun² la³jɨ́n³² tsáu² jmɨ́¹ lɨ́¹³ tónh³² ta²¹ cun³quionh³ jáɨ¹³ hi³ juáh³ hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jun³juáh¹³ hí³ yáh³ jmɨ́¹ lɨ́n³ joh¹ sɨ́² má¹ná¹, tɨ³la³ hí³ dá² cuan³ hi³ cua³zíh² jú¹ tson² hi³ ca³tɨn¹ Tsá² lɨ́n³ hí³ joh¹ sɨ́² jáun² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Quí¹ né³bí¹ jmɨ́¹ má²ja³quián³ lɨ³jnia² yáh³ Tsá² hú¹tá¹ ti³tsóh³ lɨ́n³ mí¹zioh²¹ joh¹ sɨ́² ñí¹con² la³jɨ́n³² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Né³² né³, cuan³ bíh¹ Tsá² lɨ́n³ hí³ Jáɨ¹³ ñí¹ hué²¹ lá² jmɨ́¹ cuan¹, tɨ³la³ uá¹jinh¹ ñí¹ cuá¹ ñí¹ hué²¹ lá² ca³lɨ³zia³² cun³quionh³ hí³ dí², tɨ³la³ tsá² zian² hngá¹máh³ lá² má¹ná¹, tiá² ca³lɨ³ cuóun³² yáh³ Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Uá¹jinh¹ cuan³ tsú² ñí¹ cuá¹ ñí¹ hué²¹ lá² quioh²¹, tɨ³la³ tsá² tionh² hí³ jo³cuo² tsú² né³ tiá² ca³he³ yáh³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tɨ³la³ cun³ jáun², la³jɨ́n³² la³ cun³ tsá² ca³he³ tsú², tsá² hí³ bíh¹ hiauh³ jáɨ¹³ hi³ lɨ́n¹³ jon² Dió³², la³ cun³ la³jɨ́n³² tsá² ca³chá³ hí³ cáun² tsɨ́³ ñí¹con² tsú² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Hnga² Dió³² bíh¹ ca³ma³jniau² tsá² hí³ hi³ má²ná¹lɨ́n³ jon² Dió³², jun³juáh¹³ ca³lɨ³zian² tsú² cun³ñí¹ hi³ ca³tɨn¹ jméi² dí¹hio³ ñú¹deh³ yáh³, sa³jun³ cun³ñí¹ hi³hliá² ca³lɨ³ hniá¹ tsá²mɨ³cuóun² hi³ lɨ³ zian² jon² yáh³, sa³jun³ lɨ́n³ tsú² jon² Dió³² cun³ñí¹ hi³hliá² jméi² tsú² ca³lɨ³hnió³ hi³ hí³ lɨ́n³ jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hi³ jáun² Tsá² lɨ́n³ hí³ Jáɨ¹³ né³ ca³lɨn³ tsá² dí¹ngú³, hi³ ca³cuá³ tsú² ja¹ quiú¹³ jnoh¹; hí³ bíh¹ dí² jan² Tsá² cáun² ja³² la³ má²ja³² jáun² mií³ tsɨ́³, jɨ³ hi³ cá² ñí¹ ca³ma³li²¹ tsú² siáh³ hi³ ha³ lánh³ rón³² lɨ́³ jú¹ tson². Jnoh¹ má²ca³neh²¹, hi³ má²ca³lɨ³tsɨn² jnoh¹ siáh³ ha³ la³ cónh³ tí³ hi³ quien² tsú², la³ cun³ qui³ ca³tɨ²¹ hi³ quien² Tsá² jan² tán¹ Jon² Dió³² Jméi² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan² tsá² ca³zion³ hí³ jmáɨ² tsáu² ca³cué³ jú¹ tson² hi³ ca³tɨn¹ hí³ dí², jmɨ́¹ ca³juáh³ jáun² la³ lá², hi³ ca³hléh³ tiá³: ―Tsá² lá² bíh¹ Tsá² ca³hɨ́en³² jná¹³ hí³ jmɨ́¹ cá¹juáh²¹ jná¹³ jáun² la³ lá²: “Tsá² cuá¹ja³² chí¹cáɨn² cu³hna³² jná¹³ dá² jan² Tsá² tɨ³ quien² bíh¹ la³ cónh³ bíh¹ jná¹³; quí¹ Tsá² hí³ dá² jan² Tsá² jmɨ́¹ má²zian² bíh¹ la³ cun³ jmɨ́¹ ñeh² bí¹ hi³ lɨ³zian² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Hi³ cun³ñí¹ hi³ cáun² ja³² la³ má²ja³² jáun² mií³ tsɨ́³ Tsá² hí³ né³, jáun² la³jáɨ³² bíh¹ dí² ca³hiau³ hi³ má²hé² má²mieh² tsú² cun³ jmá² cun³ jnia³². ");
INSERT INTO csoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Quí¹ cun³quionh³ hla¹ Moisés bíh¹ ca³hiau³ dí² liei²¹ quioh²¹ Dió³², tɨ³la³ cun³quionh³ Jesús Tsá² lɨ́n³ Cristo má¹ná¹, ca³hiau³ dí² mií³ hi³ ja³² tsɨ́³ Dió³², la³ má²quionh³ jú¹ tson² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Hí¹ jan² yáh³ tiá² hin² má²ca³jɨ́en³² Dió³²; tɨ³la³ Tsá² qui³ cuá³ cu³héin¹ Jméi² bíh¹ dí² má²ca³ma³li²¹ ñí¹con² dí² hi³ ha³ lánh³ rón³² lɨ́n³ Dió³². Ja³bí¹ Tsá² hí³ siáh³ lɨ́n³ Dió³², Tsá² jan² tán¹ Jon² Dió³² Jméi² dí². ");
INSERT INTO csoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Hi³ jáun² né³, hi³ lá² bíh¹ jú¹ tson² hi³ ca³cué³ Juan² ñí¹con² mí²tsáu² jɨ³ *levitas, tsá² ca³zen³ hí³ tsá² *judíos tsá² ná¹ñí¹ zian² tɨ³ já¹ juú² Jerusalén, hi³ tsa³ngáɨ³ tsú² ñí¹con² Juan² jáɨ¹³ lá²: ―¿Hin² dá² tsánh² hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hi³ hí³ né³, tiá² ca³ma³zian³² yáh³, tɨ³la³ ca³juáh³ bíh¹ jú¹ tson², hi³ ca³juáh³ la³ lá²: ―Jun³juáh¹³ jná¹³ yáh³ Tsá² lɨ́n³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hi³ jáun² tsá² hí³ ca³ngáɨ³ siáh³: ―Hi³ jáun² né³ ¿hin² bíh¹ tsánh² hnú²? ¿Ho³ hnú² uá¹ Líh³ tsá² jmɨ́¹ lɨ́n³ *tɨ³² jë¹ Dió³² jmɨ́¹tin²? Jáun² ca³juáh³ Juan²: ―Jun³juáh¹³ tsá² hí³ yáh³ jná¹³. Jáun² tsá² hí³ siáh³ ca³ngáɨ³: ―¿Hí¹ hnú² uá¹ *tɨ³² jë¹ Dió³², tsá² qui³ cónh³ ca³tɨn¹ hi³ já³²? Hi³ jáun² ca³juáh³ siáh³ Juan²: ―Ján¹han²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jmɨ́¹jáun² ca³juáh³ tsá² hí³ la³ lá²: ―Jáun² né³, ¿hin² bíh¹ tsánh² hnú²? Quí¹ hniáuh³² tsá¹cáun¹ yáh³ jnoh¹ jú¹ tson² ñí¹con² tsá² lɨ́²ze³ jnoh¹. Jáun² né³, ¿he³ jú¹ tson² lɨ́¹³ cuéh¹ nú² hi³ ca³tɨn¹ nú² huen²? ");
INSERT INTO csoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jmɨ́¹jáun² né³ ca³hléh³ Juan² la³ cun³ hi³ ca³hléh³ hla¹ Isaías tɨ³² jë¹ Dió³², hi³ ca³juáh³ la³ lá²: ―Jná¹³ bíh¹ lɨ́n³ tsá² quian³² jáɨ¹³ hi³ ñi³hléh¹³ ná¹ ñí¹ lɨ́³ hué³² quiéin² hi³ juah³² ná¹ la³ lá²: “Jmóuh¹ náh² cú²tso² juɨ³² ñí¹ já²¹ Juo¹³ dí²”. ");
INSERT INTO csoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jmɨ́¹jáun² tsá² zéi¹ hí³ tsá² *fariseos hi³ tsa³lienh³ Juan² ");
INSERT INTO csoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ca³ngáɨ³ siáh³ la³ lá²: ―Jáun² né³, nɨ́¹juáh³ jun³juáh¹³ hnú² yáh³ la³ lɨ́n³ Cristo, sa³jun³ tɨ³² jë¹ Dió³² tsá² jmáɨ² Líh³, hi³ sa³jun³ tɨ³² jë¹ Dió³² tsá² ca³tɨ²¹ hi³ já³² hí³, jáun² né³ ¿he³ lɨ³ sa³ hnú² yáh³ zion²³ tsáu² jmáɨ²? ");
INSERT INTO csoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jáun² Juan² ca³ngáɨ³ la³ lá²: ―Tson² bíh¹ jná¹³ zion² tsáu² jmáɨ² cun³quionh³ jmɨ́² jma³ bíh¹; tɨ³la³ ja¹ quián¹³ náh² zenh² jan² Tsá² tiá² cuóun³² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tsá² hí³ já³² chí¹cáɨn² cu³hna³² jná¹³. Hí¹ cú¹pih²¹ yáh³ tiá² cunh³ jná¹³ quiúnh¹ Tsá² hí³, quí¹ ca³la³ hí¹juáh³ tiá² ca³tɨn¹ yáh³ jná¹³ hi³ zaɨh²¹ ná¹ láu² tsɨ³² ta³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Hi³ nɨ́² lɨ³ tɨ³ hué³² ñí¹ téh²³ tsú² Betania, can³² cua³ Jordán tɨ³ juɨ³² ñí¹ hia³² hiú², ñí¹ jmɨ́¹ zenh¹ Juan² hi³ dí¹zion² tsáu² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jmɨ́¹ cá¹jniá²¹ jáun² né³, ca³jɨ́en³² Juan² hí³ Jesús hi³ cuá¹ja³² tɨ³ ñí¹ zenh¹ dí², hi³ jáun² ca³záɨh³ dí² la³ lá² tsá² jmɨ́¹ tionh¹ quionh³: ―Sá¹nɨ́² jɨe³, Tsá² nɨ́² bíh¹ lɨ́n³ *Já¹ziáh² míh¹ joh¹ Dió³², Tsá² hin³ tso³ quioh²¹ tsá² zian² tá¹ cáun² hngá¹máh³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Tsá² nɨ́² bíh¹ hí³ ca³hɨ́en³² jná¹³ jáun², jmɨ́¹ cá¹juáh²¹ jná¹³ jáun² la³ lá²: “Cu³hna³² jná¹³ cuá¹ja³² jan² tsá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bí¹ jná¹³, quí¹ Tsá² hí³ dá² tɨ³ jmɨ́¹ má²zian² bíh¹ la³ cun³ jmɨ́¹ ñeh² bí¹ hi³ lɨ³zian² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ca³la³ hí¹juáh³ huen² yáh³ jná¹³ tiá² jmɨ́¹ ño¹ ná¹ hin² tsánh² jmɨ́¹ já²¹; tɨ³la³ cun³ñí¹ hi³ hnó³² jná¹³ hi³ lɨ³ jnia² Tsá² hí³ ñí¹con² tsá² *Israel, jáun² bíh¹ cuan³ jná¹³ hi³ cua³zion³ jná¹³ tsáu² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ja³bí¹ ca³juáh³ siáh³ Juan² la³ lá²: ―Ca³jɨen¹ jná¹³ Jmɨ́²chí³ Chun¹ hi³ ja³ hñu³mɨ³cuú² la³jmɨ́¹ ja³² jan² chi³ jáɨ², hi³ tɨnh³ ñí¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jná¹³ hí¹juáh³ tiá² jmɨ́¹ má²ño¹ yáh³ hi³ hin² tsánh² hí³ jmɨ́¹ já²¹, tɨ³la³ Tsá² ca³ze³ jná¹³ hi³ zion¹ ná¹ tsáu² jmáɨ² cun³quionh³ jmɨ́² jma³ né³ ca³záɨ³ jná¹³ la³ lá²: “Nɨ́¹ má¹ca³jɨeh³ hnú² hi³ son¹³ Jmɨ́²chí³ ñí¹ quioh²¹ jan² tsá²ñuh², jáun² Tsá² hí³ bíh¹ Tsá² ziau³ jmáɨ² cun³quionh³ Jmɨ́²chí³ Chun¹”. ");
INSERT INTO csoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jáun² jná¹³ né³ má²ca³jɨen¹ bí¹ ná¹, hi³ jáun² jná¹³ lɨ́n³ ná¹ tsá² nau³² jáɨ¹³ ta³né³² hi³ tson² bíh¹ hí³ lɨ́n³ Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jmɨ́¹ cá¹jniá²¹ jáun² jmɨ́¹ zenh¹ siáh³ Juan² tsá² zion² tsáu² jmáɨ² ñí¹ jáun² la³ má²quionh³ gon³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jáun² jmɨ́¹ ca³jɨ́e³ jáun² Juan² hi³ hí¹ngaɨ³² Jesús ñí¹ jáun², jáun² ca³juáh³ la³ lá²: ―Sá¹nɨ́² jɨe³ dúh¹, Tsá² ó³² bíh¹ lɨ́n³ Já¹ziáh² míh¹ joh¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Tá¹ gon³ bíh¹ tsá² jmɨ́¹ quionh³ hí³ Juan² ca³náɨ³² hi³ ca³juáh³ Juan² la³ jáun², hi³ jáun² já¹taunh²¹ cu³chin¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Hi³ jáun² jmɨ́¹jáun² ca³jinh³ Jesús tɨ³ cu³hna²¹, hi³ ca³jɨ́e³ dí² hi³ má²hí¹já²táunh¹ tsá² hí³ cu³chin¹ cu³hna²¹ dí², hi³ jáun² ca³záɨh³ dí² la³ lá²: ―¿He³ jmɨ́¹ hnáuh² náh²? Jáun² tsá² hí³ né³ ca³juáh³: ―Tɨ³², ¿ha³ jinh¹ ñíh³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Hi³ jáun² Jesús ca³ngáɨ³ la³ lá²: ―Sá¹nɨ́² ñá²táunh¹ náh² ñá²jɨe³. Jáun² ja³taunh²¹ tsú² hi³ ca³ñí¹jɨ́e¹³ ñí¹ jmɨ́¹ cuá³ Jesús, hi³ jáun² ca³tiánh³ tsú² ñí¹ jáun² jmáɨ¹ jáun², quí¹ cun³ la³ nió¹ quia³ tɨ³ hú²niéi² bíh¹ jmɨ́¹ má²tí³ jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tre²¹ raɨnh²¹ Sí¹mu²¹ Pé¹ bíh¹ jan² tsá² gon³ tsá² ca³náɨ³² hí³ jáɨ¹³ hi³ ca³juáh³ jáun² Juan², hi³ jáun² ja³taunh²¹ cu³hna²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jáun² la³juɨ³² ca³hnah² Tre²¹ Sí¹mu²¹ raɨnh²¹, hi³ ca³záɨh³ dí² la³ lá²: ―Má²lɨ́²neh²¹ jnoh¹ Tsá² lɨ́n³ Mesías (jú¹ *hebreo nɨ́² hnió³ juáh³ “Tsá² zéi¹ Dió³²”, la³ cun³ juáh³ tsú² jáun² cun³quionh³ jú¹ *griego “Tsá² lɨ́n³ Cristo”). ");
INSERT INTO csoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jmɨ́¹ lɨ²¹ jáun² ca³jan³ Tre²¹ Sí¹mu²¹ raɨnh²¹ tɨ³ ñí¹ zenh¹ Jesús, hi³ jáun² Jesús ca³záɨh³ Sí¹mu²¹ jmɨ́¹ ca³jɨ́en³²: ―Hnú² bíh¹ jon² Juan², tsá² jmáɨ² nú² Sí¹mu²¹, tɨ³la³ jná¹³ né³ juanh³² hi³ hnú² jmáɨ² Cefas (hi³ hnió³ juáh³ “Pé¹”, hi³ Pé¹ né³ hnió³ juáh³ “Quɨ́n¹”). ");
INSERT INTO csoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jmɨ́¹ cá¹jniá²¹ jáun² né³, Jesús ca³lɨ́n¹³ hi³ tsó³² tɨ³ hué¹³ Galilea, hi³ ñí¹ jáun² né³ ca³jenh² tsú² Pí²liéi¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Ña³² cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pí²liéi¹ hí³ jan² tsá² juú² Betsaida bíh¹, ñí¹ jmɨ́¹ zian² uá²jaɨ³² Tre²¹ quionh³ Pé¹ raɨnh²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Hi³ jáun² ca³ñí¹hniah² Pí²liéi¹ Natanael, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Má²lɨ́²neh²¹ jnoh¹ Tsá² ca³hɨen³ hí³ hla¹ Moisés ñí¹ Sí² liei²¹, Tsá² ca³hɨen³ hí³ tsá² ca³lɨn³ tɨ³² jë¹ Dió³² uá²jaɨ³². Jesús jon² Sé³² bíh¹ tsá² hí³, Tsá² ja³ tɨ³ juú² Nazaret. ");
INSERT INTO csoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tɨ³la³ Natanael né³ ca³juáh³: ―¿Hí¹ lɨ́¹³ lɨ³jnia² cáun² hi³ chu²¹ já¹ juú² Nazaret dúh¹? Hi³ jáun² Pí²liéi¹ ca³juáh³: ―Sá¹nɨ́² dú¹ ñá²neh²¹ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jmɨ́¹ ca³jɨ́en³² jáun² Jesús Natanael hi³ cuá¹ja³² tɨ³ ñí¹ zenh¹ dí², jáun² ca³juáh³ dí² la³ lá²: ―Há¹, nɨ́² má²cuá¹ja³² jan² tsá² cu³tí³ lɨ́n³ jón²zɨ́h¹ jón²cho¹ hla¹ Israel, jan² tsá² tiá² jú¹ tɨ́¹jáɨ² tɨn². ");
INSERT INTO csoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Hi³ jáun² jmɨ́¹jáun² ca³ngáɨ³ Natanael hi³ ca³juáh³: ―¡Hóh³²! ¿Lánh³ rón³² cuóu³² nú² jná¹³? Jáun² Jesús né³ ca³juáh³: ―Jmɨ́¹ ñeh² bí¹ hi³ té³ máh³ hnú² Pí²liéi¹ má²lɨ́²jɨe¹ jná¹³, tá¹la³ jmɨ́¹ ñíh³ nú² jáun² ñeh² hmá² sí² co². ");
INSERT INTO csoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jáun² jmɨ́¹jáun² ca³juáh³ Natanael la³ lá²: ―Tɨ³², hú¹tá¹ Jon² Dió³² bíh¹ hnú², hnú² bíh¹ lɨ́n³ nú² Re²¹ Juo¹³ tsá² Israel. ");
INSERT INTO csoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Hi³ Jesús né³ ca³ngáɨ³ la³ lá²: ―¿Hí¹ tá²chi²¹ má²táunh²³ hnú² ta²¹ quí¹ cun³ñí¹ hi³hliá² má²lɨ́²juáh³² jná¹³ hi³ lɨ́²jɨe¹ ná¹ tá¹la³ jmɨ́¹ ñíh³ nú² jáun² ñeh² hmá² sí² co²? Tɨ³la³ né³bí¹ jɨeh²¹ yáh³ hnú² hi³ tɨ³ jlánh¹ bí¹ cáu² jueh³² la³ cónh³ bíh¹ hi³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ja³bí¹ ca³juáh³ siáh³ Jesús la³ lá² ñí¹con² tsá² hí³: ―Jú¹ tson² cu³tí¹³ bíh¹ juah³² jná¹³ ñí¹con² hnoh², hi³ hnoh² lɨ́¹³ jɨeh²¹ náh² hi³ má²há²na²¹ hñu³mɨ³cuú², hi³ tsá² ná¹lɨ́n³ tsá²cuú² tsá²ta³ Dió³² né³ zá¹ son¹³ ñí¹ quioh²¹ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Jáun² né³, jmɨ́¹ la³ má²jau³ jáun² ca³jmú³ tsáu² jmáɨ¹ hi³ ca³jenh² cuo² já¹ juú² Caná, juú² hɨ́n¹³ tɨ³ Galilea. Ja¹ quioh²¹ tsá² hí³ né³, jmɨ́¹ dí¹cho¹ mí¹ziú¹³ Jesús, ");
INSERT INTO csoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ja³bí¹ ca³teh³ tsú² siáh³ Jesús la³ má²quionh³ tsá² haɨn²¹ hí³ tɨ³ con² ñí¹ ca³jenh² jáun² cuo² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jmɨ́¹jáun² ca³tsá³² mu² ráu³ mɨ³ uóun²jɨeh¹³ hi³ ná¹hɨ́nh²³ tsú² ñí¹ jáun², hi³ jáun² mí¹ziú¹³ Jesús né³ ca³juáh³ la³ lá²: ―Tiú²uú² zia³² yáh³ mu² ráu³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tɨ³la³ Jesús né³, ca³ngáɨ³ la³ lá²: ―La³ cun³ hi³ hɨ³² nɨ́² honh² hnú² mɨ́¹, tiá² ca³tɨn¹ jná¹³ hi³ hɨ́³² tsɨn³² hi³ nɨ́². Quí¹ tiá² má²ca³tsɨn¹³ yáh³ jmáɨ¹ quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tɨ³la³ mí¹ziú¹³ tsú² né³ ca³záɨh³ la³ lá² tsá² jmɨ́¹ ná¹jmu² ta²¹: ―Ma³ti²¹ náh² lɨ³ua³ cáun² hi³ juáh³ ñú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jáun² né³, ñí¹ jáun² jmɨ́¹ nio¹ jñéi³ tse³ cáh¹ hi³ lɨ́³ quɨ́n¹, tse³ hi³ la³ jmúh³² jáun² tsá² *judíos ta²¹ nɨ́¹juáh³ jmáɨ¹ hi³ má²jɨn² tsú². Ma³ quin³² ma³ caun³² tse³ jáun² tɨ́² héih²³ míh¹ tiá² cun³ hñá³láu³ lí¹³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Hi³ jáun² Jesús ca³záɨh³ tsá² ná¹jmu² hí³ ta²¹: ―Ma³conh²¹ náh² jmɨ́² jma³ tse³ lá². Hi³ jáun² tsá² hí³ né³ ca³táh³ jmáɨ² tse³ jáun² ca³la³ ca³canh². ");
INSERT INTO csoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jmɨ́¹ lɨ²¹ jáun² né³ ca³záɨh³ Jesús tsá² hí³ la³ lá²: ―Né³² né³, chin³² ca³lá² hi³ cuá²cuéh³ tsá² nio² jo³cuo² jmáɨ¹. Jáun² tsá² hí³ né³, ca³ma³tí³² bíh¹ héih³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jáun² tsá² nio² jo³cuo² jmáɨ¹ né³ ca³hɨnh³ cú¹pih²¹ jmáɨ² hi³ má²laɨn³² jáun² mu² ráu³ mɨ³ uóun²jɨeh¹³ ta³ tiá² ñi³² tsú² ha³ dá² jinh¹ ja³ hi³ jáun²; quí¹ jɨ́³²la³ tsá² ná¹jmu² ta²¹ bíh¹ má²ná¹ñi³², quí¹ hmóu³² bíh¹ tsá² hí³ ca³táh³ jmɨ́² jma³ tse³ jáun² hi³ jáun² ca³chin² ca³lá². Hi³ jáun² tsá² nio² jo³cuo² jmáɨ¹ né³ ca³teh³ tsá²ñuh² tsá² ca³jenh² cuo², ");
INSERT INTO csoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","hi³ ca³záɨh³ dí² la³ lá²: ―La³jɨ́n³² tsáu² bí¹ tsóh²³ tín² mu² ráu³ hi³ jlánh¹ bíh¹ chu²¹ ñí¹con² tsá² ná¹tén¹, hi³ jáun² nɨ́¹ má¹lɨ́²hính³ tsú² hliáun³ né³, má¹jáun² máh³ má²tsóh³ tsú² mu² ráu³ huen³. Tɨ³la³ hnú² má¹ná¹, má²lɨ́²hmáh¹ bí¹ nú² mu² ráu³ hi³ jlánh¹ bí¹ chu²¹, hi³ né³bí¹ tsóh³² máh³ nú² ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Hi³ nɨ́² bíh¹ li²¹ la³ñí¹ hi³ ca³jmú³ Jesús jmɨ́¹ ca³ma³jnia² pí³ quioh²¹ já¹ juú² Caná hɨ́n¹³ tɨ³ Galilea; hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, ca³chá³ cáun² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jmɨ́¹ lɨ²¹ jáun² né³ ja³tanh²¹ dí² tɨ³ já¹ juú² Capernaum la³ má²quionh³ mí¹ziú¹³, tsá¹ raɨnh²¹, jɨ³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² nɨ³² siáh³, hi³ ñí¹ jáun² né³ ca³tiánh³ dí² tun³ hnɨ³² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jáun² né³, má²janh² bíh¹ jmɨ́¹ má²hé² hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹ quioh²¹ tsá² judíos, hi³ jáun² Jesús né³ ngau³ tɨ³ já¹ juú² Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hi³ jáun² hñu³ cuáh³² chín¹ jáun² né³ ca³jɨ́en³² tsú² tsá² ná¹hna² cuá¹juɨ́², jɨ³ *já¹ziáh², jɨ³ tsá² hna² jáɨ² nɨ³² siáh³, la³ má²quionh³ tsá² jmɨ́¹ tionh¹ hi³ jmɨ́¹ ná¹quí² ná¹zaɨ³² quɨe³ quioh²¹ hué³² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jáun² jmɨ́¹ ca³jɨ́e³ Jesús hi³ jáun² né³, ca³jmú³ cáun² hñú¹jméi¹³ cun³quionh³ hñe¹³, hi³ jáun² ca³chi³ ca³huen³ dí² tɨ³ cheih³² cuáh³² la³jɨ́n³² tsá² hí³ la³ má²quionh³ já¹ziáh² jɨ³ cuá¹juɨ́² joh¹. Hi³ ca³ziu³ ca³súh³ dí² siáh³ quɨe³ quioh²¹ tsá² jmɨ́¹ ná¹zaɨ³² hí³ quɨe³ quioh²¹ hué³² siáh³, jɨ³ hi³ ca³ziu³ ca³cuɨ́³ dí² siáh³ mesas quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hi³ tsá² jmɨ́¹ ná¹hna² hí³ jáɨ² né³ ca³záɨh³ dí² la³ lá²: ―¡Huen³ náh² jáh³ nɨ́² ñéih³ lá²! ¡Ha³ lɨ́² uú² chá² náh² hmah²¹ ñéih³ hñú¹³ Ñuh³² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jmɨ́¹jáun² né³ tsau³ tsɨ́³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí², hi³ juáh³ jáun² la³ lá²: “Cun³ñí¹ hi³ jlánh¹ dí¹quiaunh²¹ tsɨn³² jná¹³ hi³ hñuh³² hnú² lɨ́¹³ ná¹chan¹ jmáh³la³ hi³ ca³tɨn¹ hnú², jáun² bíh¹ tsa³hín³ jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hi³ jáun² tsá² ná¹ñí¹ joh¹ tsá² judíos né³, ca³ngáɨh³ Jesús la³ lá²: ―¿He³ li²¹ lɨ́¹³ hɨ́eh¹ nú² jnoh¹ hi³ jáun² lɨ³ lin¹ hi³ tson² ca³tɨn¹ hnú² jmúh¹³ la³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jáun² Jesús né³, ca³ngáɨ³ la³ lá²: ―Sá¹nɨ́² tsunh²¹ dúh¹ náh² hñú³ hɨ́en¹ lá² neh²¹, hi³ jáun² ñí¹ cá²hnɨ́² jmáɨ¹ zéih¹ jná¹³ siáh³ hi³ hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jmɨ́¹jáun² né³, ca³juáh³ tsá² judíos hí³ la³ lá²: ―Tun³la³jñéi³ mii² yáh³ ca³lé³ hi³ ca³jmú³ tsú² hñú³ hɨ́en¹ lá²; ¿hí¹ hnɨ³² jmáɨ¹ uá¹ lɨ́¹³ hi³ zéih¹ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tɨ³la³ hñú³ hɨ́en¹ hi³ ca³hɨ́e³ jáun² Jesús má¹ná¹, hi³ ca³hɨen³ hnga² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hi³ jáun² jmɨ́¹ ca³jenh¹³ tsú² jáun² ja¹ hla¹ né³, tsau³ tsɨ́³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² jáɨ¹³ nɨ́², hi³ ca³taunh³ tsú² siáh³ ta²¹ la³ cun³ hi³ rá¹juáh³ ñí¹ Sí², jɨ³ la³jɨ́³² jáɨ¹³ hi³ jmɨ́¹ má²ca³juáh³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jáun² né³, jmɨ́¹ cuá³ Jesús já¹ juú² Jerusalén tá¹la³ Jmɨ́¹hɨ́en¹ jáun², jáun² juóun³² lɨ́n³² tsáu² ca³chá³ cáun² tsɨ́³ ñí¹con² tsú² jmɨ́¹ ca³jɨ́e³ li²¹ hi³ lɨ́³ hua³jueh³² hi³ jmu² dí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Tɨ³la³ Jesús má¹ná¹, tiá² cáun² lɨ́¹ jmɨ́¹ háɨ³² yáh³ tsɨ́³ ñí¹con² tsá² hí³, quí¹ jmɨ́¹ cuoh² bíh¹ tsú² jmɨ́¹ tsɨ́³ la³jɨ́n³² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Quí¹ tiá² hin² jmɨ́¹ lɨ³hniah²³ yáh³ hi³ chá³² ñí¹con² tsú² he³ lánh³ lɨ́n³ tsáu², quí¹ jmɨ́¹ má²ñi³² bíh¹ tsú² hnga² he³ lánh³ lɨ́³ hñu³ jmɨ́¹ hñu³ tsɨ́³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Jáun² né³, jmɨ́¹ zian² jan² tsá² ja¹ tsá² cu³ nió³ téh²³ tsú² *fariseo, tsá² jmáɨ² Nicodemo, tsá² hí³ jmɨ́¹ lɨ́n³ jan² tsá² quien² ja¹ quioh²¹ tsá² *judíos. ");
INSERT INTO csoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo hí³ né³ ca³ñí¹jɨen¹³ Jesús cáun² já¹niéi², hi³ ca³záɨh³ dí² la³ lá²: ―Tɨ³², né¹ jnoh¹ hi³ hnú² ca³ze³ Dió³² hi³ ña³ma³ta¹³ nú² jnoh¹, quí¹ hí¹ jan² yáh³ tiá² hin² lɨ́¹³ jmu³ li²¹ lɨ́³ hua³jueh³² la³jmɨ́¹ jmuh³² hnú² nɨ́² sá¹jmɨ́¹ hi³ tiá² Dió³² quionh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Hi³ jáun² Jesús ca³juáh³: ―Jú¹ tson² cu³tí¹³ juo³ jná¹³ hnú², hi³ nɨ́¹juáh³ tsá² tiá² ca³lɨ³zian² hi³ hmaɨ²¹, tiá² lɨ́¹³ yáh³ hí³ tsú² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jáun² Nicodemo né³ ca³ngáɨ³: ―Tɨ³la³, ¿lánh³ bíh¹ rón³² lɨ́¹³ hi³ jan² tsá² má²lieih²¹ lɨ́¹³ lɨ³zian² siáh³ cónh³í¹ cu³ jéin³²? ¿Hí¹ lɨ́¹³ hen¹³ tsú² hñu³ héin¹ mí¹ziú¹³ hi³ jáun² lɨ³zian² siáh³? ");
INSERT INTO csoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Hi³ jáun² Jesús né³ ca³ngáɨ³ la³ lá²: ―Jú¹ tson² cu³tí¹³ la³² juo³ jná¹³ hnú², hi³ nɨ́¹juáh³ tsá² tiá² ca³lɨ³zian² cun³quionh³ jmɨ́² jma³ jɨ³ cun³quionh³ Jmɨ́²chí³ joh¹ Dió³² nɨ́² siáh³, tiá² lɨ́¹³ yáh³ hí³ tsú² jo³cuo² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Quí¹ jmáh³la³ ngú³ bíh¹ lɨ́n³ tsá² ca³lɨ³zian² cun³quionh³ jméi² mí¹ziú¹³, tɨ³la³ lɨ³ua³ jan² tsá² ca³lɨ³zian² cun³quionh³ Jmɨ́²chí³ joh¹ Dió³² má¹ná¹, jáun² jmɨ́²chí³ bíh¹ má²lɨ́n³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ha³ lɨ́² cuɨ́¹ cha³cáun² honh² nú² hi³ juah²¹ jná¹³ la³ lá²: “La³jɨ́n³² bíh¹ tsáu² hniáuh³² lɨ³zian² hi³ hmaɨ²¹”. ");
INSERT INTO csoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Quí¹ chí³ dá² ja³² lɨ³ua³ cáun² juɨ³² hi³ hnió³ bíh¹; naɨh³² bí¹ hnú² mah¹ hi³ jmu² chí³, tɨ³la³ tiá² ñíh¹ yáh³ hnú² hín² dá² tɨ́h³ ja³² chí³ hi³ hín² dá² tɨ́h³ tsó³². Ja³bí¹ la³ nɨ́² bíh¹ uá²jaɨ³² lɨ́n³ tsá² má²ca³lɨ³zian² cun³quionh³ Jmɨ́²chí³ joh¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jmɨ́¹jáun² ca³ngáɨ³ siáh³ Nicodemo, hi³ ca³juáh³ la³ lá²: ―¿He³ bí¹ lánh³ rón³² lɨ́¹³ la³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―¿Hí¹ hí¹juáh³ hnú² uá¹ tiá² ngɨ²³ nú² jáɨ¹³ nɨ́², uá¹jinh¹ hnú² bíh¹ jan² tɨ³² chín¹ ñí¹con² tsá² *Israel? ");
INSERT INTO csoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jú¹ tson² cu³tí³ juah³² jná¹³ ñí¹con² hnú², hi³ jnoh¹ hléh¹ la³ cun³ hi³ né¹, jɨ³ hi³ láɨ³ jnoh¹ siáh³ tsá² nau³² jáɨ¹³ ca³tɨ²¹ la³jɨ́³² hi³ má²ca³neh²¹ jnoh¹; tɨ³la³ hnoh² né³, tiá² ta²¹ táunh²³ yáh³ náh² la³ cun³ hi³ juáh³ jnoh¹ ñí¹con² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nɨ́¹juáh³ hí¹juáh³ tiá² ta²¹ hun¹ bíh¹ hnoh² nɨ́¹ má¹ca³hléh³ jná¹³ jáɨ¹³ hi³ ca³tɨ²¹ la³ cun³ hi³ qui³ lɨ́³ jáun² ñí¹ hué²¹ lá², jáun² ¿tiá¹³ bíh¹ tiá³ táunh¹³ náh² ta²¹ nɨ́¹juáh³ hi³ lieh¹ jná¹³ hnoh² jáɨ¹³ hi³ ca³tɨ²¹ hi³ lɨ́³ hñu³mɨ³cuú²? ");
INSERT INTO csoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","”Hí¹ jan² yáh³ tiá² hin² má²ñéi¹ hñu³mɨ³cuú², jɨ́³²la³ Tsá² ja³ hí³ hñu³mɨ³cuú² bíh¹; Tsá² hí³ né³, Jon² tsá²mɨ³cuóun² bíh¹, Tsá² qui³ cuá³ hí³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hi³ jáun² la³jmɨ́¹ ca³ton³ jáun² hla¹ Moisés jáh³ hláɨnh¹ láɨn¹ tsoh² hmá² tá¹la³ jmɨ́¹ tionh¹ tsú² jáun² hué³² quiéin², ja³bí¹ la³ jáun² bí¹ siáh³ hniáuh³² quiunh²¹ Jon² tsá²mɨ³cuóun²; ");
INSERT INTO csoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","hi³ jáun² la³jɨ́n³² tsá² cha³² cáun² tsɨ́³ ñí¹con² tsú² lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","”Sá¹nɨ́² jɨe³, la³ lá² bíh¹ ca³ma³hnio³ Dió³² tsá² zian² ñí¹ hué²¹ lá², ca³la³ hi³ ca³cuen³ máh³ tsú² Jon² Tsá² jan² tán¹, hi³ jáun² lɨ³ua³ jan² tsá² cha³² cáun² tsɨ́³ ñí¹con² hí³ dí² tiá² lɨ́¹³ yáh³ hi³ tsa³háɨn³, tɨ³la³ lɨ́¹³ lɨ³ zian² tsú² cun³ jmɨ́¹hi³nio² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Quí¹ Dió³² tiá² ca³zen³ Jon² ñí¹ hué²¹ lá² hi³ ja³ra³tsɨn² tsáu² héih³², tɨ³la³ hí³ dá² ca³zen³ Jon² hi³ tɨ³ ja³lion³ bíh¹ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","”Hi³ jáun² bíh¹ tsá² tanh² ta²¹ Jon² Dió³² tiá² tá²tsɨn¹ yáh³ héih³², tɨ³la³ tsá² tiá² ñí¹chá²¹ cáun² tsɨ́³ ñí¹con² hí³ dí² né³, cun³ má²ca³ta³tsɨn¹ bíh¹ héih³², quí¹ cun³ñí¹ hi³ tiá² ta²¹ tanh² tsú² Tsá² jan² tán¹ Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Tsá² la³ hí³ má²ca³ta³tsɨn¹ héih³², quí¹ cun³ñí¹ hi³ jmɨ́¹ cuan¹ jáun² Tsá² lɨ́n³ joh¹ sɨ́² ñí¹ hué²¹ lá², tɨ³ jlánh¹ bíh¹ ca³tɨ́³ tsɨ́³ tsú² ñí¹ já¹niéi², quí¹ cun³ñí¹ hi³ tá¹³ tsú² lɨ́³ jmáh³la³ ta²¹ hlah³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","La³jɨ́n³² bíh¹ tsá² ná¹jmu² hi³ hlah³ hoh³ joh¹ sɨ́²; cun³ tiá² ñí¹ja³janh³² bíh¹ tsú² ñí¹con² joh¹, quí¹ jáun² tiá² lɨ³jnia² hi³ hlah³ hi³ ná¹jmu². ");
INSERT INTO csoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tɨ³la³ tsá² zian² la³ cun³ lɨ́³ jú¹ tson² né³, má²janh³² bíh¹ tsú² ñí¹con² joh¹ jáun², hi³ jáun² lɨ³jnia² hi³ tá¹³ tsú² lɨ́³ la³ cun³ rón³² hnió³ Dió³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jáun² né³, jmɨ́¹ lɨ²¹ jáun² ngau³ Jesús quionh³ tsá² haɨn²¹ hí³ tɨ³ con² tɨ³ hué¹³ Judea, hi³ jáun² ca³lén³ tsú² ca³lá² ué³ ñí¹ jáun² hi³ zion² tsáu² jmáɨ² quionh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja³bí¹ Juan² siáh³ jmɨ́¹ dí¹zion² jmáɨ² tsáu² tɨ³ Enón ñí¹ má²janh² Salim, quí¹hliá² ñí¹ jáun² jmɨ́¹ quí² jmɨ́¹ ñei³² jmáɨ² ñí¹ hliáun³; hi³ tsáu² né³ jmɨ́¹ ja³táunh¹ hi³ jáun² jmɨ́¹ zaun³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Hi³ nɨ́² ca³lɨ³ ñeh² bíh¹ hi³ tanh¹³ tsú² Juan² hí³ hñu³mí¹ñí². ");
INSERT INTO csoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jmɨ́¹jáun² né³, ma³ jan² tsá² haɨn²¹ hí³ tɨ³ con² Juan² tsá² zion² tsáu² jmáɨ² ca³ma³liáu³² hi³ quiú² táɨnh²³ jáɨ¹³ quionh³ jan² tsá² judío ca³tɨ²¹ hín² juɨ³² lɨ́¹³ lɨ³ jɨn² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Jmɨ́¹ lɨ²¹ jáun² né³, já¹taunh²¹ dí² tɨ³ ñí¹ zenh¹ Juan² hi³ ja³zeh¹ dí² la³ cun³ hi³ má²ca³lɨ³ ñi³² dí² jáun². Jáun² ca³záɨh³ dí² la³ lá²: ―Hnú² Tɨ³², sá¹nɨ́² niéi², tsá² jmɨ́¹ zenh¹ hí³ quiúnh¹ hnú² tɨ³ jo²¹ cua³ Jordán tɨ³ juɨ³² ñí¹ hia³² hiú², tsá² ca³ma³tsónh¹³ hnú² jáɨ¹³ hi³ ca³tɨn¹ já³², tsá² hí³ má²dí¹zion² jmáɨ² tsáu², hi³ la³jɨ́n³² bí¹ tsáu² má²tsá²táunh¹ tɨ³ ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jáun² Juan² né³ ca³ngáɨ³ la³ lá²: ―Hí¹ jan² yáh³ tiá² hin² lɨ́¹³ lɨ́n³ ta²¹ nɨ́¹juáh³ hi³ Dió³² tiá² la³ má²lɨ́²hiáu³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Má²ca³niéih² bíh¹ hnoh² hmóu³² re² lɨ́n³² jmɨ́¹ cá¹juáh²¹ jná¹³ cú²na²¹ jáɨ¹³ hi³ tiá² jná¹³ lɨ́n³ yáh³ Tsá² zéi¹ Dió³², tɨ³la³ jná¹³ dá² lɨ́n³ ná¹ jan² tsá² ja³ chí¹ján³ ta³ ñí¹ tsá² hí³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Jmú¹³ jáɨ¹³, nɨ́¹juáh³ jmɨ́¹ jmu² tsú² cáun² jmáɨ¹ hi³ jenh² cuo² tsáu², jáun² tsá²ñuh² tsá² má²ca³jenh² hí³ cuo² quionh³ bíh¹ tsá²mɨ³ má²lɨ́n³ ñí²cuo²; hi³ jáun² há²mei²¹ quioh²¹ tsá²ñuh² tsá² ca³jenh² cuo² hí³ né³ cuá¹tón²¹ có³² hi³ cuá¹náɨ³² jë¹ tsá² ca³jenh² hí³ cuo², hi³ jáun² né³ lɨ́²hiún² lɨ́n³² tsɨ́³ nɨ́¹ má¹ca³náɨ³² hi³ hleh³² tsá² hí³. Hi³ jáun² bí¹ jlánh¹ lɨ́²hiún² lɨ́n³² tsɨn³² jná¹³ ta³né³²; ");
INSERT INTO csoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","quí¹ Tsá² hí³ dá² cun³ ca³tɨn¹ bíh¹ hi³ tɨ³ lɨ³mí¹ lɨ³ quien², hi³ jáun² jná¹³ né³, cun³ ca³tɨ²¹ bíh¹ hi³ má²tsa³méih³ hi³ quien² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hi³ jáun² Tsá² ja³ tɨ³ hñu³mɨ³cuú² bíh¹ ho² jáɨ¹³ ñí¹con² ca³la³ jɨ³lɨn². Tɨ³la³ tsá² qui³ lɨ́n³ tsá²mɨ³cuóun² má¹ná¹, jan² tsá² lɨ́¹ tsáu² bíh¹ tsá² la³ hí³, hi³ hleh³² tsú² siáh³ la³ cun³ qui³ hleh³² tsá² zian² ñí¹ hué²¹ lá². Tɨ³la³ Tsá² ja³ hí³ hñu³mɨ³cuú² né³, ho² jáɨ¹³ ñí¹con² ca³la³ jɨ³lɨn² tsáu² bíh¹, ");
INSERT INTO csoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","hi³ jáun² hí³ bíh¹ dí² hleh³² ca³tɨ²¹ la³ cun³ hi³ má²ca³jɨ́e³ jɨ³ hi³ má²ca³náɨ³²; tɨ³la³ tiá² hin² nga³ ca³lɨ³hnió³ yáh³ tónh³² ta²¹ la³ cun³ hi³ juáh³ Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tɨ³la³ lɨ³ua³ jan² tsá² taunh³² ta²¹ jë¹ Tsá² hí³ má¹ná¹, hi³ jáun² tsá² la³ hí³ má²tson² jáɨ¹³ hi³ tson² bíh¹ Dió³² hleh³² jú¹ tson²; ");
INSERT INTO csoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","quí¹ Tsá² lɨ́²ze³ Dió³² dá² hleh³² jë¹ Dió³² bíh¹, quí¹ cun³ñí¹ hi³ Dió³² cuen² Jmɨ́²chí³ joh¹ ñí¹con² tsú² ca³la³ hi³ tiá² tsɨ³² héih³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dió³² hnio³ Jon², hi³ jáun² má²ca³chá³ tsú² jo³cuo² Jon² la³jɨ́³² hi³ zia³². ");
INSERT INTO csoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jáun² tsá² má²nio² cáun² tsɨ́³ ñí¹con² Jon² tsú² má²ná¹zian² la³ cun³ jmɨ́¹hi³nio² bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² tiá² hnió³ tanh¹³ ta²¹ Jon² tsú² né³, tiá² lɨ́¹³ yáh³ zian² la³ jáun², quí¹ la³ má²míh²³ jáun² bíh¹ tsɨ́³ Dió³² ñí¹con² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Hi³ jáun² né³, jmɨ́¹ ca³lɨ³ ñi³² Jesús hi³ tsá² *fariseos má²ca³náɨ³² hi³ tɨ³ má²juóun³² bíh¹ tsá² haɨn²¹ tɨ³ con² hí³ dí², jɨ³ hi³ tɨ³ jlánh¹ juóun³² tsáu² má²ca³zion³ dí² siáh³ jmáɨ² la³ cónh³ bí¹ Juan², ");
INSERT INTO csoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(uá¹jinh¹ jun³juáh¹³ hnga² yáh³ Jesús jmɨ́¹ zion² jmáɨ² tsáu², quí¹ hmóu³² tsá² haɨn²¹ hí³ tɨ³ con² bíh¹ tsú²), ");
INSERT INTO csoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","hi³ jáun² jmɨ́¹ ca³lɨ³ ñi³² Jesús jáɨ¹³ nɨ́² né³, cua³han³ hué¹³ Judea hi³ ngah³ tɨ³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jmɨ́¹ ngah²¹ jáun² tsú² ca³lɨ³ hniáuh³² tsa³nga¹ hué³² Samaria, ");
INSERT INTO csoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","hi³ jáun² ca³chó³² tsú² cáun² juú² jmáɨ² Sicar hɨ́n¹³ tɨ³ Samaria, có³² hué³² ñí¹ ca³cuéh³ hla¹ Jacob Sé³² jon². ");
INSERT INTO csoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ñí¹ jáun² jmɨ́¹ hó²¹ cáun² táu² ñí¹ jmɨ́¹ chí² tsáu² jmáɨ², hi³ jáun² né³ jmɨ́¹ téh²³ tsú² “Tá² jmáɨ² quioh²¹ hla¹ Jacob”. Jesús jmɨ́¹ má²cá²huóh³² lɨ́n³² bíh¹ hi³ hún¹ juɨ³², hi³ jáun² ca³cuá³ can³² ho³ tá² jmáɨ² jáun². Má²ñí¹tɨ²¹ la³ nio¹ jñéi³ tɨ³ ca³hláu³ bíh¹ jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jáun² ja³ jan² tsá²mɨ³ tsá² Samaria hi³ chí¹³ jmáɨ² ñí¹ jáun², hi³ jáun² Jesús ca³záɨh³ tsá²mɨ³ hí³ la³ lá²: ―¿Tiá¹ jmúh¹³ tiá³ hi³ chú³² cuéh¹ cú¹pih²¹ jmáɨ² quián¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tsá² haɨn²¹ hí³ tɨ³ con² Jesús né³, má²já²taunh²¹ hi³ má²já²lia³² má³² tɨ³ já¹ juú². ");
INSERT INTO csoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Tɨ³la³ cun³ñí¹ hi³ tsá² *judíos tiá² jmɨ́¹ jmúh³² yáh³ ta²¹ lɨ³ua³ cáun² hi³ cauh³² tsá² Samaria, hi³ jáun² lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³ tsá²mɨ³ hí³, jáun² ca³juáh³ la³ lá²: ―¿Lánh³ rón³² sa³ hnú² yáh³ mɨh³² jmáɨ² ñí¹con² jná¹³?, já² tsá² judío bíh¹ hnú², hi³ jná¹³ né³ tsá² Samaria bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jmɨ́¹jáun² ca³ngáɨ³ Jesús la³ lá²: ―Sá¹jmɨ́¹ hi³ lɨ́²tsɨn² bíh¹ hnú² la³ cun³ hi³ hnió³ Dió³² cué³², jɨ³ hi³ hin² tsánh² cuá¹mɨ³² jmáɨ² ñí¹con² nú², hi³ jáun² hnú² dá² tɨ³ jmɨ́¹ mɨ́h¹³ bíh¹ jmáɨ² ñí¹con² jná¹³, hi³ jáun² jná¹³ né³ jmɨ́¹ cué¹³ ná¹ jmáɨ² hi³ cue³² pí³ hi³ lɨ́¹³ zian² tsú² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jáun² tsá²mɨ³ hí³ né³ ca³záɨh³ Jesús la³ lá²: ―Hnú² Tɨ³², já² hí¹juáh³ tiá² quiánh¹ yáh³ hnú² he³ cun³quionh³ chíh¹ nú² jmáɨ², hi³ ñí¹ ñe¹ lɨ́n²¹ bíh¹ siáh³ hu²¹ jmáɨ². Hi³ jáun² né³, ¿lánh³ rón³² cánh¹³ hnú² jmáɨ² hi³ cue³² pí³ hi³ lɨ́¹³ zian² tsú² hi³ cuéh¹ nú² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Hí¹ jlánh¹ bí¹ quien² hnú² la³ cónh³ bíh¹ hla¹ Jacob dí¹hio³ ñú¹deh³ jnoh¹ tsá² jmɨ́¹ zian² jmɨ́¹tin²? Quí¹ hí³ bíh¹ ca³cué³ jnoh¹ tá² jmáɨ² lá²; jmáɨ² ha²¹ tá² jmáɨ² lá² bíh¹ jmɨ́¹ hɨ́nh²³ tsú² hnga² la³ má²quionh³ jón²zɨ́h¹ jón²cho¹, jɨ³ jáh³ joh¹ tsú² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Hi³ jáun² jmɨ́¹jáun² ca³ngáɨ³ siáh³ Jesús hi³ ca³juáh³ la³ lá²: ―La³jɨ́n³² bíh¹ tsá² hɨ́nh³ jmáɨ² lá² lɨ³ quiéin² siáh³ tsɨ́³; ");
INSERT INTO csoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","tɨ³la³ tsá² hɨ́nh³ jmáɨ² hi³ cue¹ jná¹³ má¹ná¹, jmɨ́¹lɨ́h³ bíh¹ tiú²uú² chau²¹ jmáɨ¹ hi³ lɨ³ quiéin² siáh³ tsɨ́³. Quí¹ cun³quionh³ jmáɨ² hi³ cué¹³ jná¹³ dá² lɨ́¹³ la³jmɨ́¹ lɨ́³ hi³ chí¹ñei³² bíh¹ jmáɨ² hñu³ tsɨ́³ tsú² hi³ cué³² pí³ hi³ lɨ́¹³ zian² tsú² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jáun² tsá²mɨ³ hí³ né³, ca³juáh³ la³ lá²: ―Hnú² Tɨ³², jmu³ hi³ chú³² cué¹ jná¹³ jmáɨ² jáun² aɨh²¹, hi³ jáun² tiú²uú² lɨ³ quiéin² tsɨn³² jná¹³, hi³ sa³jun³ uá² lɨ³ hniáuh³² já¹³ jná¹³ hi³ já¹chí³ jmáɨ² la³ tɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús né³ ca³záɨh³ tsá²mɨ³ hí³: ―Cuánh², cuá²tiéh³ ñí²cuonh², hi³ jáun² ña³² quiúnh¹ tsú² ñí¹ lá² má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jáun² tsá²mɨ³ hí³ né³ ca³ngáɨ³: ―Tiá² ñí²uó³² nia²¹ zian² yáh³. Hi³ jáun² Jesús né³ ca³juáh³: ―Tson² bíh¹ la³ juánh³ hnú² nɨ́², hi³ tiá² ñí²cuonh² nú² zian²; ");
INSERT INTO csoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","quí¹ hñá³ yáh³ ñí²cuonh² hnú² má²ca³lɨ³ zian², tɨ³la³ tsá² ñíh³ nú² quiúnh¹ ta³né³² né³, jun³juáh¹³ ñí²cuonh² yáh³ nú² hí³. Jáun² né³, jú¹ tson² cu³tí¹³ bíh¹ la³ cun³ hi³ má²lɨ́²juah²¹ hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jmɨ́¹ ca³náɨ³² jáun² tsá²mɨ³ hí³ jáɨ¹³ nɨ́² né³, ca³juáh³ la³ lá²: ―Hnú² Tɨ³², má²ca³lɨ³tsɨn² jná¹³ hi³ hnú² bíh¹ lɨ́n³ jan² *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Né³² né³, dí¹hio³ ñú¹deh³ jnoh¹ tsá² hɨ́n¹³ jnoh¹ hué³² Samaria lá² ca³ma³tsú² ma³jónh³² Dió³² tsɨ³ máh³ lá² jmɨ́¹tin²; tɨ³la³ hnoh² né³ tsá² judíos juáh³ náh² hi³ jmáh³la³ já¹ juú² Jerusalén bí¹ néh¹ lɨ́¹³ ma³tsu³ ma³jónh³² tsú² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jáun² Jesús ca³ngáɨ³ siáh³ la³ lá²: ―Hnú² tsá²mɨ³, tionh² ta²¹ jáɨ¹³ lá²: Hi³ má²chau²¹ bíh¹ jmáɨ¹ hi³ tiú²uú² lɨ³ hniáuh³² yáh³ hi³ ñá¹táunh¹ náh² tsɨ³ máh³ nɨ́², ho³ hi³ cuá¹táunh¹ náh² já¹ juú² Jerusalén hi³ cuá¹ma³tsú¹ ma³jonh²¹ náh² Dió³² Jméi² dí². ");
INSERT INTO csoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Hnoh², tsá² hɨ́n¹³ tɨ³ hué³² Samaria lá², hí¹juáh³ tiá² re² cuóun³² yáh³ náh² Dió³² Tsá² ma³tsú¹ ma³jonh²¹ náh²; tɨ³la³ jnoh¹ má¹ná¹, re² bíh¹ cuóun³² jnoh¹ Dió³² Tsá² ma³tsú¹ ma³jonh²¹ jnoh¹, quí¹ ja¹ quioh²¹ tsá² judíos bíh¹ cua³han³ Tsá² liáu³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Quí¹ má²ja³quián³ bíh¹ chau²¹ jmáɨ¹, hi³ ti³tsóh³dí¹ ta³né³² má²cá²chó³² jmáɨ¹ jáun², la³ cun³ jmáɨ¹ hi³ jɨ³lɨn² tsá² cu³tí³ má²tsú² má²jónh³² Dió³² má²lɨ́¹³ ma³tsu³ ma³jónh³² tsú² Jméi² dí² cáun² hi³ hú¹tá¹ tson² cu³tí³ cun³quionh³ hi³ ma³hau³ Jmɨ́²chí³ Chun¹; quí¹ tsá² la³ hí³ bí¹ ti³tsóh³ hnah² Jméi² dí² hi³ lɨ́¹³ ma³tsu³ ma³jáuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dió³² bíh¹ jan² Tsá² lɨ́n³ Jmɨ́²chí³; hi³ jáun² tsá² má²tsú² má²jáuh³² né³, hniáuh³² bíh¹ hi³ ma³tsu³ ma³jónh³² tsú² Dió³² cáun² hi³ hú¹tá¹ tson² cu³tí³, cun³quionh³ hi³ ma³hau³ Jmɨ́²chí³ Chun¹. ");
INSERT INTO csoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jáun² tsá²mɨ³ hí³ né³ ca³juáh³ la³ lá²: ―Né¹ jnoh¹ hi³ já³² jan² Tsá² zen³ Dió³², Tsá² téh³ tsú² Cristo; hi³ jáun² Tsá² hí³ lɨ́¹³ ma³ta² re² tɨn² la³jɨ́³² ñí¹con² jnoh¹ nɨ́¹ má¹cuán². ");
INSERT INTO csoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Jná¹³ bíh¹ la³², Tsá² má²dí¹hléh²³ ná¹ ñí¹con² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tá¹la³ jáun² né³, cua³tanh²¹ bíh¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú², hi³ jáun² lɨ́¹ ca³ta³ná¹jɨ́e³² bíh¹ tsú² jmɨ́¹ ca³jɨ́e³ hi³ cuá¹liéinh³² Jesús tsá²mɨ³ hí³. Tɨ³la³ hí¹ jan² yáh³ tiá² hin² ca³tia³ tsɨ́³ hi³ ngáɨh³² tsá²mɨ³ hí³ nɨ́¹juáh³ he³ dá² hnió³, sa³jun³ ca³chá³ tsú² siáh³ tiá³ tsɨ́³ hi³ ngáɨh³² Jesús: “¿He³ dá² ná¹juónh³² hnú² quiúnh¹ tsá²mɨ³ nɨ́²?” ");
INSERT INTO csoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Hi³ jáun² jmɨ́¹jáun² bíh¹ ca³zíh³ tsá²mɨ³ hí³ tsú¹liáh² quioh²¹, hi³ ngah³ tɨ³ já¹ juú², hi³ ca³ñí¹zeh¹ tsáu² la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ñá²táunh¹ náh², ñá²jɨen¹ náh² jan² tsá²ñuh² Tsá² má²lɨ́²zéi³² jná¹³ la³jɨ́³² la³ cun³ hi³ má²cá²jmú³² ná¹. Tiá² hin² ñi³² hí¹ Tsá² lɨ́n³ Cristo Tsá² ó³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jmɨ́¹jáun² ca³huén² tsá² juú² jáun², hi³ ja³taunh²¹ hi³ ca³ñí¹jɨen¹³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tá¹la³ jáun² né³, tsá² haɨn²¹ hí³ tɨ³ con² Jesús jein³² má³², hi³ juáh³ la³ lá²: ―Tɨ³², quɨéɨh³ ca³lá² má³² quiú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Tɨ³la³ Jesús má¹ná¹, ca³ngáɨ³ la³ lá²: ―Zia³² bíh¹ cáun² má³² hi³ lɨ́¹³ cuh²¹ jná¹³, cáun² hi³ tiá² cuɨn² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ma³liáu³² hi³ ngaɨh³² raɨnh²¹ tsá²ján² tsá²ján² hi³ juáh³ la³ lá²: ―¿Hí¹ zian² tsá² má²cuá²can³² má³² hi³ cuh³ tsú² juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tɨ³la³ Jesús ca³juáh³ la³ lá²: ―Má³² quion²¹ jná¹³ lɨ́³ la³ lá²: hi³ jmu¹ ná¹ la³ cun³ hi³ hnió³ Tsá² ca³ze³ bíh¹, jɨ³ hi³ má¹hián¹³ jná¹³ siáh³ ta²¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Hnoh² dá² juáh³ náh² la³ lá²: “Cónh³í¹ quiún³ zɨ́h² máh³ hniáuh³² hi³ ló³² la³ cun³ hi³ jná¹”; tɨ³la³ jná¹³ né³ juanh³²: Sá¹nɨ́² jéinh¹ dú¹ náh² máh¹ tɨ³ la³ ó³² neh²¹, ta³né³² bíh¹ má²ca³láu², jáun² má²lɨ́¹³ bíh¹ caun¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tsá² jmu² ta²¹ hi³ caun² hi³ ca³láu² jáun² né³ he² hmah²¹ quioh²¹, hi³ máɨ³ hi³ caun² tsú² jáun² né³ tsá²toh³ ñí¹ lɨ́¹³ zian² tsú² la³ cun³ jmɨ́¹hi³nio², hi³ jáun² tsá² jñi³² máɨ³ lɨ³ hiún² tsɨ́³ cu³lɨ²¹ la³ má²quionh³ tsá² jieih³². ");
INSERT INTO csoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quí¹ jú¹ tson² bíh¹ la³ cun³ hi³ juáh²³ tsú² jáun²: “Tsá² siánh³ bíh¹ jñi³², hi³ tsá² siánh³ bí¹ caun²”. ");
INSERT INTO csoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jná¹³ má²lɨ́²zéi³² hnoh² hi³ cuá¹quiaun² náh² cáun² hi³ tiá² huá² ta²¹ lɨ́²quiánh² náh²; la³ nɨ́² bíh¹ lɨ́³, hi³ tsá² siánh³ bí¹ ca³jmú³ ta²¹, hi³ jáun² hnoh² né³ cáun² má²tonh²¹ náh² hná¹ ta²¹ hi³ má²he² hná¹ quioh²¹ tsá² hí³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Juóun³² lɨ́n³² bíh¹ tsá² juú² zian² hué³² Samaria jáun² ca³tanh² ta²¹ Jesús cun³ñí¹ hi³ jlánh¹ ca³ma³tson² tsá²mɨ³ hí³ jë¹ jmɨ́¹ ca³juáh³ jáun² la³ lá²: “Má²lɨ́²zéi³² jná¹³ tsú² la³jɨ́³² la³ cun³ hi³ má²cá²jmú³² jná¹³”. ");
INSERT INTO csoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Hi³ jáun² jmɨ́¹ cuá¹taunh²¹ jáun² tsá² hɨ́n¹³ hí³ tɨ³ Samaria ñí¹ cuá¹tón²¹ jáun² Jesús né³, jlánh¹ ca³hiu³ ca³mɨ́³ dí² hi³ cuá³² tsú² juú²co¹ dí². Jáun² Jesús né³ ca³cuá³ tun³ jmáɨ¹ já¹ juú² jáun², ");
INSERT INTO csoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","hi³ jáun² tɨ³ lɨ³mí¹ juóun³² tsáu² ca³chá³ bíh¹ cáun² tsɨ́³ jmɨ́¹ ca³náɨ³² jáun² jáɨ¹³ hi³ hleh³² hnga² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hi³ jáun² tsá² hí³ né³ ca³záɨh³ tsá²mɨ³ hí³ la³ lá²: ―Jun³juáh¹³ jmáh³la³ hi³hliá² lɨ́²juah²¹ hnú² la³ jáun² yáh³ má²táunh²³ jnoh¹ ta²¹ ta³né³², quí¹ ja³bí¹ hmóu³² yáh³ jnoh¹ má²lɨ́²náɨ¹³ la³ cun³ hi³ má²lɨ́²juáh³ tsú², jɨ³ hi³ má²né¹ jnoh¹ siáh³ hi³ cu³tí³ bíh¹ Tsá² nɨ́² lɨ́n³ Tsá² lión³² tsá² zian² tá¹ cáun² hngá¹máh³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jmɨ́¹ la³ má²jau³ jáun² né³ cua³han³ siáh³ Jesús hué³² Samaria jáun², hi³ ngah³ siáh³ tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Quí¹ hnga² Jesús ca³juáh³ hi³ jan² tɨ³² jë¹ Dió³² tiá² hin² quiú² jéi²³ yáh³ juú²co¹. ");
INSERT INTO csoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hi³ jáun² jmɨ́¹ cá¹chánh²¹ dí² hué¹³ Galilea né³, ca³he³ bíh¹ tsá² hí³ re², quí¹ ja³bí¹ jmɨ́¹ má²ñí¹táunh¹ yáh³ tsá² hí³ *Jmɨ́¹hɨ́en¹ tɨ³ já¹ juú² Jerusalén, hi³ jáun² jmɨ́¹ má²ca³jɨ́e³ bíh¹ tsú² la³jɨ́³² hi³ ca³jmú³ Jesús tá¹la³ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jáun² jmɨ́¹ lɨ²¹ jáun² né³ ngah³ Jesús já¹ juú² Caná hɨ́n¹³ tɨ³ Galilea, ñí¹ ca³jmú³ tsú² jmɨ́¹tin² hi³ jmɨ́² jma³ lan³ mu² ráu³ mɨ³ uóun²jɨeh¹³. Hi³ já¹ juú² Capernaum né³, jmɨ́¹ zian² jan² tsá²cuú² tsá²ta³ re²¹; tsá² hí³ jmɨ́¹ tsáun¹ jan² jon². ");
INSERT INTO csoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jáun² jmɨ́¹ ca³lɨ³ ñi³² tsá² hí³ hi³ má²cuanh³² siáh³ Jesús hué¹³ Galilea hi³ jmɨ́¹ hún¹ tɨ³ Judea, jmɨ́¹jáun² ngau³ dí² hi³ ca³ñí¹jɨen¹³ dí² tsú², hi³ ca³ñí¹hiú² ñí¹mɨ́² dí² hi³ tsó³² Jesús hñú¹³ dí² hi³ tsa³jmah¹ jon² dí² tsá² jmɨ́¹ má²ñí¹jún³ cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―Jun³ tsá² zia³² hi³ táunh¹³ ta²¹ yáh³ hnoh² nɨ́¹juáh³ hi³ tiá² jɨeh²¹ náh² li²¹ jɨ³ hua³jueh³² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jáun² tsá² joh¹ re²¹ né³ ca³juáh³: ―Hnú² Tɨ³², ña³² tiá³ tia³juɨ³² ñeh² bíh¹ hi³ jún³ jón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jmɨ́¹jáun² né³, ca³juáh³ Jesús la³ lá²: ―Cuánh² hñuh³², zian² bíh¹ jónh³² hnú² re² tɨn². Jáun² tsá²ñuh² hí³ né³ ca³taunh³ ta²¹ la³ cun³ hi³ má²lɨ́²juáh³ jáun² Jesús, hi³ jáun² ngah³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Hú¹ juɨ³² jáun² né³, ca³jenh² tsú² *tsá² má²dí¹hlánh¹ joh¹, tsá² ca³huén² hí³ hi³ tsa³can³² jáɨ¹³ hi³ zian² bíh¹ jon² tsú² re² tɨn². ");
INSERT INTO csoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Hi³ jáun² tsá²ñuh² hí³ ca³ngáɨ³ hi³ hín² la³nió¹ lan³ jon², jáun² tsá² joh¹ tsú² hí³ né³ ca³juáh³: ―Jmɨ́¹ la³nió¹ quiau³ tɨ³ ca³hláu³ cháu³ bíh¹ ca³quin³ hi³ jmɨ́¹ chéin³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jáun² jmɨ́¹jáun² ca³lɨ³tsɨn² tsá²ñuh² hí³ hi³ ti³tsóh³dí¹ jmɨ́¹jáun² bíh¹ ca³juáh³ Jesús la³ lá²: “Zian² bíh¹ jónh³² hnú² re² tɨn²”; hi³ jáun² jmɨ́¹jáun² né³ ca³tanh² tsá² hí³ ta²¹ Jesús la³ má²quionh³ la³jɨ́n³² tsá² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Hi³ nɨ́² bíh¹ ñí¹ má²tun³ li²¹ hi³ lɨ́³ hua³jueh³² hi³ ca³jmú³ Jesús hué¹³ Galilea jmɨ́¹ cuanh²¹ hi³ ñéi¹ jáun² tɨ³ hué¹³ Judea. ");
INSERT INTO csoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jmɨ́¹ lɨ́¹cáɨn² jáun² né³ ca³jmú³ tsá² *judíos cáun² jmáɨ¹ quioh²¹, hi³ jáun² Jesús ñéi¹ tɨ³ Jerusalén. ");
INSERT INTO csoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Já¹ juú² jáun² né³, ñí¹ má²janh² ho³hñú¹³ ñí¹ téh²³ tsú² “Ho³hñú¹³ quioh²¹ *Já¹ziáh²”, ñí¹ jáun² jmɨ́¹ nio¹ cáun² jmɨ́²táu² hi³ téh²³ tsú² Betzata cun³quionh³ jú¹jma² *hebreo; ñí¹ jáun² jmɨ́¹ zia³² hñá³ ñí¹ lɨ́³ ñí¹hñú³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Juóun³² lɨ́n³² bíh¹ tsá² tsáun¹ jmɨ́¹ tionh¹ hué³² ñí¹ jáun², la³ cun³: tsá² ten³, tsá² hliánh², jɨ³ tsá² hma² nɨ́² siáh³, hi³ jmɨ́¹ ná¹jan³² tá¹la³ juá³ jmáɨ² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Quí¹ ma³ cónh³ la³ jáun² bíh¹ jmɨ́¹ ja³² jan² tsá²cuú² tsá²ta³ Dió³² hi³ ja³jua³² jmáɨ², hi³ jáun² nɨ́¹ má¹lɨ³² jáun² bíh¹ lɨ³ua³ jan² tsá² hí³ la³ñí¹ chu³ jmáɨ² lɨ́¹³ lan¹³ ca³tɨ²¹ lɨ³ua³ cáun² mɨ́¹uɨ́³ hi³ zian² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ñí¹ jáun² jmɨ́¹ rón²¹ jan² tsá²ñuh² tsá² má²tí³ quiú³quia³jña³ mii² hi³ tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jáun² Jesús ca³jɨ́en³² tsá² hí³ hi³ rón³² ñí¹ jáun², hi³ jáun² jmɨ́¹ ca³lɨ³tsɨn² dí² hi³ má²ngau³² mii² bíh¹ la³ tsáun¹ tsú², hi³ jáun² ca³ngáɨh³ dí² la³ lá²: ―¿Hnáuh¹ hnú² lan¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jáun² tsá² tsáun¹ hí³ né³ ca³juáh³: ―Hnú² Tɨ³², tiá² hin² zian² yáh³ hi³ taunh¹³ jná¹³ hñu³ jmɨ́²táu² nɨ́² nɨ́¹juáh³ nɨ́¹ má¹ca³juá³ jmáɨ². Quí¹ ma³ quin³² la³ ma³ cu³ jéin³² hi³ má²ca³lɨ³hnó³² jná¹³ hu²¹ chu³ jmáɨ², tsá² siánh³ bíh¹ tín² lɨ́²jan²¹ hi³ hí²³ la³ñí¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ Jesús ñí¹con² tsá² hí³: ―Náu², ziáuh¹ jmu² quián¹³, ngɨ́¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³lan³ tsá²ñuh² hí³, hi³ jáun² ca³caun² jmu² quioh²¹ hi³ ca³ma³liáu³² ngɨ́³². Tɨ³la³ *jmáɨ¹ hi³ tionh² tsú² tie³ bíh¹ jmáɨ¹ jáun²; ");
INSERT INTO csoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","hi³ jáun² tsá² judíos tsá² ná¹ñí¹ ca³záɨh³ tsá² má²laɨn³² hí³ la³ lá²: ―Hóh³², já² jmáɨ¹ nio² tie³ bíh¹ né³², cun³ tiá² ca³tɨn¹ bíh¹ hnú² hi³ ñí¹quiánh¹ jmu² quián¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jáun² tsá²ñuh² hí³ né³ ca³ngáɨ³, hi³ ca³juáh³: ―Tsá² lɨ́²jmú³ hi³ lan³ bíh¹ jná¹³ lɨ́²juáh³: “Quiaun² jmu² quián¹³, ngɨ́¹”. ");
INSERT INTO csoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Hi³ jáun² tsá² hí³ né³ ca³ngáɨh³ tsá² má²laɨn³² hí³ la³ lá²: ―¿Hin² tsánh² tsá² hí³ hi³ lɨ́²zéi³² hnú²: “Quiaun² jmu² quián¹³, ngɨ́¹”? ");
INSERT INTO csoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tɨ³la³ tsá² má²laɨn³² hí³ né³, tiá² jmɨ́¹ ñi³² yáh³ hin² dá² tsánh² lɨ́²jmú³ hi³ lan³ dí², quí¹ ca³quiónh³² bíh¹ Jesús ja¹ tsá² juóun³² lɨ́n³² jmɨ́¹ tionh¹ hí³ có³² jmɨ́²táu² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jmɨ́¹ lɨ́¹cáɨn² pih²¹ jáun² né³, ca³jenh² siáh³ Jesús tsá²ñuh² hí³ hñu³ cuáh³² chín¹, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Sá¹nɨ́² jɨe³, né³² má²láɨn¹ nú²; hi³ jáun² né³, ha³ lɨ́²uú² jmú² tso³, quí¹ nɨ́² lɨ́¹ cá¹quiúnh²¹ nú² cáun² hi³ tɨ³ jlánh¹ bíh¹ huáh² tsɨ́³ la³ cónh³ bíh¹ hi³ jmɨ́¹ zian² nú². ");
INSERT INTO csoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jáun² tsá² hí³ né³ ngah³ jmɨ́¹ lɨ²¹ jáun², hi³ ca³ñí¹zeh¹ tsá² judíos tsá² ná¹ñí¹ hi³ Jesús bíh¹ la³ ca³jmú³ hi³ lan³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cun³ñí¹ hi³ má²lɨ́²jmú³ jáun² hua³jueh³² jmáɨ¹ nio² tie³ bíh¹ Jesús, hi³ jáun² má²hnauh² tsá² judíos hí³ quioh²¹ tsú² hi³ ma³tsau¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tɨ³la³ Jesús né³ ca³záɨh³ tsá² hí³ la³ lá²: ―La³ má²jmu² jáun² bíh¹ Ñuh³² jná¹³ ta²¹, hi³ jáun² ja³bí¹ jná¹³ siáh³ jmu² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Hi³ jáun² né³, tɨ³ lɨ³mí¹ ca³lɨ³hnió³ bíh¹ tsá² judíos tsá² ná¹ñí¹ hi³ jngah³, quí¹ jun³juáh¹³ cun³ jmáh³la³ hi³ tiá² jmɨ́¹ má²tí³² tsú² liei²¹ hi³ ca³tɨ²¹ jmáɨ¹ nio² tie³ yáh³, quí¹ jɨ³ hi³hliá² jmɨ́¹ jmu² dí² jáun² cá²ren² quionh³ Dió³² bíh¹, hi³hliá² jmɨ́¹ juáh²³ dí² jáun² hi³ hnga² Dió³² lɨ́n³ Jméi² dí². ");
INSERT INTO csoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Hi³ jáun² Jesús né³ ca³záɨh³ tsá² hí³ la³ lá²: ―Jú¹ tson² cu³tí³ bíh¹ hi³ juah³² jná¹³ lá² ñí¹con² hnoh², hi³ hí¹ cáun² yáh³ tiá² hi³ lɨ́¹³ jmu³ Jon² Dió³² la³ cun³ hi³ lɨ́¹ cháunh²³ chí¹ hnga²; ñí¹ jɨ́²¹la³ ti³ jmu² tsú² la³ cun³ hi³ jɨ́e²³ hi³ jmu² Jméi² bíh¹. Quí¹ la³jɨ́³² la³ cun³ hi³ jmu² Jméi² tsú², la³ jáun² bíh¹ jmu² tsú² siáh³ hnga². ");
INSERT INTO csoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Quí¹ hnio³ bíh¹ Dió³² Jon², hi³ jáun² hɨeh³² dí² ca³la³ jɨ́³² hi³ jmu² dí² hnga²; hi³ né³bí¹ hɨ́eh²¹ dí² siáh³ ta²¹ hi³ tɨ³ jlánh¹ bíh¹ cáu² jueh³², hi³ ca³la³ hi³ lɨ́¹ tsa³cáun² lɨ́n³² bíh¹ honh² hnoh² lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Quí¹ hí¹ la³ tɨ³ tɨn² yáh³ tsú² jmu³ siáh³ hi³ jenh¹³ tsá² má²cá²tsan³ nɨ́¹juáh³ lɨ³ua³ jan² tsá² hnió³ tsú² hi³ zian² siáh³, la³jmɨ́¹ tɨn² jáun² Jméi² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Quí¹ jun³juáh¹³ Dió³² Jméi² yáh³ tsú² rá²tsɨ³² héih³² ñí¹con² tsáu², quí¹ tɨ³la³ jo³cuo² Jon² bíh¹ Dió³² má²ca³chá³ ta²¹ jáun², ");
INSERT INTO csoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","hi³ jáun² la³jɨ́n³² tsáu² lɨ́¹³ ma³quien² Jon² Dió³² la³jmɨ́¹ má²quien² tsú² hnga² Dió³² Tsá² lɨ́n³ Jméi². Jáun² nɨ́¹juáh³ tsá² tiá² má²quien² Jon² Dió³², hi³ jáun² sa³jun³ má²quien² yáh³ tsá² la³ hí³ Dió³² Tsá² ca³zen³ Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”Jú¹ tson² bíh¹ juo³ jná¹³ hnoh²: Lɨ³ua³ jan² tsá² náɨ³² re² jáɨ¹³ hi³ juah³² jná¹³, hi³ tanh² tsú² siáh³ ta²¹ Tsá² ca³ze³ jná¹³, tsá² la³ hí³ bíh¹ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio²; hi³ jáun² tiá² héih³² tá¹tsɨn¹ yáh³ tsú², quí¹ má²ca³nga² bíh¹ tsú² ñí¹ jmɨ́¹ lɨ́¹³ jún³, hi³ jáun² hú¹tá¹ má²zian² bíh¹ tsú² hi³ hmaɨ²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Juo³ jná¹³ siáh³ hnoh² jú¹ tson² lá², hi³ má²ja³quián³ bíh¹ chau²¹ jmáɨ¹, hi³ ti³tsóh³dí¹ ta³né³² má²cá²chó³² jmáɨ¹ jáun², hi³ tsá² ná¹jún¹ ne³ hi³ hléh³² Jon² Dió³²; hi³ jáun² tsá² ne³ né³, lɨ́¹³ zian². ");
INSERT INTO csoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Quí¹ la³jmɨ́¹ quian³² Dió³² Tsá² lɨ́n³ Jméi² pí³ hi³ jmu² hi³ lɨ́¹³ zian² tsáu², ja³bí¹ la³ jáun² ca³cuéh³ tsú² Jon² jáɨ¹³ hi³ quian³² siáh³ pí³ hi³ jmu³ hi³ lɨ́¹³ zian² tsáu²; ");
INSERT INTO csoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","hi³ jáun² má²ca³cuéh³ dí² siáh³ jáɨ¹³ hi³ ra³tsɨ³² héih³² ñí¹con² tsáu², quí¹ cun³ñí¹ hi³ hí³ bíh¹ lɨ́n³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ha³ lɨ́² cuɨ́¹ cha³cáun² honh² náh² hi³hliá² má²lɨ́²juáh³² jná¹³ la³ nɨ́², quí¹ chau²¹ bíh¹ jmáɨ¹ hi³ la³jɨ́n³² tsá² ná¹jún¹ ne³ hi³ hléh³² tsú², ");
INSERT INTO csoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hi³ jáun² tsá² hí³ né³, huén³² tá²hón³² quioh²¹. Lɨ³ua³ jan² tsá² ca³jmú³ hi³ chu²¹ né³, jenh¹³ hi³ lɨ́¹³ zian² cun³ jmɨ́¹hi³nio²; tɨ³la³ nɨ́¹juáh³ tsá² ca³jmú³ hi³ hlah³ má¹ná¹, jenh¹³ hi³ tá¹tsɨn¹ héih³² hlah³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”Tiá² lɨ́¹³ yáh³ jmu¹ jná¹³ hí¹ cáun² hi³ cháunh²³ chin³² huen². Jná¹³ dá² rá²tsɨ³² ná¹ héih³² la³ cun³ lɨ́³ héih³² hi³ ja³² ñí¹con² bíh¹ ná¹; hi³ la³ cun³ ca³tɨ²¹ bíh¹ siáh³ rá²tsɨ³² jná¹³ héih³², quí¹ tiá² jmu² yáh³ jná¹³ la³ cun³ hi³ hnó³² huen², tɨ³la³ jná¹³ dá² jmu² la³ cun³ hi³ hnió³ Ñuh³² ná¹ Tsá² ca³ze³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Sá¹jmɨ́¹ hi³ jɨ́³²la³ huen² bíh¹ jná¹³ no² jáɨ¹³ hi³ ca³tɨn¹ ná¹ huen², hi³ jáun² tiá² lin¹ ñí¹ quien² yáh³ la³ cun³ hi³ juah³² jná¹³ jáun²; ");
INSERT INTO csoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","tɨ³la³ zian² bíh¹ jan² tsá² siánh³ hi³ lɨ́n³ tsá² nau³² jáɨ¹³ hi³ ca³tɨn¹ jná¹³, hi³ jná¹³ ño¹ hi³ quien² bíh¹ la³ cun³ hi³ juáh³ tsá² hí³ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Hnoh² dá² ca³zen² náh² tsá² ca³ñí¹ngah¹ Juan² tsá² zion² hí³ tsáu² jmáɨ² nɨ́¹juáh³ hin² tsánh² dí², hi³ la³jɨ́³² la³ cun³ hi³ ca³ngáɨ³ hí³ né³, jú¹ tson² bíh¹ jaun³². ");
INSERT INTO csoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Tɨ³la³ uá¹ jáun² la³ jáun² jú¹ tson² hi³ jáun², tiá² jmu² yáh³ jná¹³ hi³ juáh¹³ hi³ quien² lɨ́n³² jú¹ tson² hi³ hleh³² tsá²mɨ³cuóun² hi³ ca³tɨn¹ jná¹³; jɨ́³²la³ ti³ juanh³² jná¹³ jáɨ¹³ nɨ́² hi³ jáun² lɨ́¹³ liáun³ hnoh² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan² hí³ dá² jmɨ́¹ lɨ́n³ la³jmɨ́¹ lɨ́³ cáun² sɨ́² hi³ jmɨ́¹ taɨ³² joh¹ quioh²¹, hi³ jáun² hnoh² né³ ca³lɨ́n¹³ hi³ má¹hiúnh¹³ cu³tiá³ honh² hi³ ca³tɨ²¹ joh¹ hi³ jmɨ́¹ quian³² tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Tɨ³la³ zia³² bíh¹ cónh³í¹ cáun² li²¹ hi³ hɨe³² jú¹ tson² hi³ ca³tɨn¹ jná¹³, hi³ jlánh¹ bíh¹ quien² la³ cónh³ bí¹ hi³ ca³juáh³ jáun² Juan². Quí¹ cun³quionh³ la³jɨ́³² ta²¹ hi³ jmu² bíh¹ jná¹³, la³ cun³ ta²¹ hi³ ca³cué³ Ñuh³² jná¹³ hi³ jmu¹, má²lɨ́²lin¹ hi³ tson² bíh¹ ca³ze³ jná¹³ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ja³bí¹ hnga² Ñuh³² jná¹³ Tsá² ca³ze³ hí³ má²ca³cué³ siáh³ jú¹ tson² hi³ ca³tɨn¹ jná¹³, uá¹jinh¹ hí¹ cónh³ tiá² má²ca³niéih² hnoh² ho³ tsú² hi³ hleh³², hi³ sa³jun³ má²ca³jɨen¹ náh² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cun³ tiá² má²cá²hɨ́enh³² bíh¹ jú¹ chú³² quioh²¹ tsú² hñu³ honh² hnoh², quí¹ cun³ñí¹ hi³ tiá² tanh²³ yáh³ hnoh² ta²¹ Tsá² ca³zen³ tsú² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jlánh¹ re² ná¹quí² ná¹hɨh³² hnoh² Sí² quioh²¹ Dió³² ca³la³ huán¹ táɨ³² cu³tí³, quí¹ hi³ hen² honh² náh² hi³ ñí¹ jáun² lɨ́¹³ chanh¹ náh² he³ lánh³ rón³² lɨ́¹³ zian² náh² la³ cun³ jmɨ́¹hi³nio²; tɨ³la³ ti³tsóh³dí¹ ñí¹ Sí² jáun² yáh³ rá¹hleh³² jáɨ¹³ hi³ ca³tɨn¹ jná¹³, ");
INSERT INTO csoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","hi³ má¹lɨ³² jáun² né³, sa³ tiá² hnáuh² bí¹ náh² hi³ ñá¹táunh¹ ñí¹con² jná¹³, hi³ jáun² jmɨ́¹ lɨ́¹³ zian² náh² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”Ha³ tiá² hniá¹ yáh³ jná¹³ hi³ tsáu² ma³quien² ná¹, ");
INSERT INTO csoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","quí¹ tɨ³la³ cuóu³² bíh¹ jná¹³ hnoh², hi³ ño¹ jná¹³ siáh³ hi³ jun³ tsá² hno³ Dió³² yáh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jná¹³ dá² cuan³ ná¹ cha¹³ Ñuh³², tɨ³la³ hnoh² né³, tiá² he²³ yáh³ hnoh² jná¹³; tɨ³la³ né³² né³, nɨ́¹juáh³ cuan³ jan² tsáu² hi³ ca³tɨn¹ hnga², né³² cánh³ bíh¹ hen¹³ náh² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nɨ́¹juáh³ cá² ñí¹ ná¹hen² honh² náh² hi³ má¹quien¹³ náh² tsá²ján² tsá²ján² bíh¹, hi³ nɨ́¹juáh³ tiá² la³ hnáuh²³ yáh³ náh² he³ lánh³ rón³² jmɨ́¹ lɨ́¹³ ma³quien² Dió³² hnoh², ¿lánh³ bíh¹ rón³² lɨ́¹³ táunh¹³ hnoh² ta²¹? ");
INSERT INTO csoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ha³ lɨ́² lɨ́¹ cuɨ́¹ lɨ́n¹³ náh² hi³ jná¹³ ñí¹chá³ tsáuh³ náh² ñí¹con² Ñuh³²; quí¹ hnga² bíh¹ hla¹ Moisés tsá² ca³héih³ náh² hí³ honh² ñí¹con² tɨ³ tsa³hna³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Quí¹ sá¹jmɨ́¹ hi³ táunh²³ hnoh² ta²¹ la³ cun³ jáɨ¹³ hi³ ca³juáh³ jáun² hla¹ Moisés dúh¹, hi³ jáun² ja³bí¹ jmɨ́¹ taunh¹³ bíh¹ náh² uá²jaɨ³² ta²¹ jná¹³, quí¹ hí³ bíh¹ ca³hléh³ hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Tɨ³la³ nɨ́¹juáh³ hí¹juáh³ jë¹ tsá² hí³ yáh³ tiá² ta²¹ táunh²³ hnoh², hi³ jáun² né³, tiá¹³ bíh¹ tiá³ táunh¹³ hnoh² ta²¹ la³ cun³ hi³ juah³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jmɨ́¹ lɨ²¹ jáun² né³, ngau³ siáh³ Jesús tɨ³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ hi³ téh²³ tsú² jáun² Galilea, hi³ ja³bí¹ téh²³ tsú² siáh³ Tiberias. ");
INSERT INTO csoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hi³ jáun² jmɨ́¹jáun² ja³taunh²¹ juóun³² lɨ́n³² tsáu² cu³chin¹ cu³hna²¹ Jesús, quí¹hliá² má²ca³jɨ́e³ tsú² hua³jueh³² hi³ jmu² dí², hi³ jmah²³ dí² tsá² tsáun¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jáun² jmɨ́¹jáun² ca³ñí¹uu³² Jesús cáun² máh³, hi³ jáun² ñí¹ jáun² ca³cuá³ quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Má²janh² bíh¹ má²he² jmáɨ¹ hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹ jmɨ́¹jáun², jmáɨ¹ hi³ jmu² jáun² tsá² *judíos. ");
INSERT INTO csoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hi³ jáun² jmɨ́¹ ca³jɨ́e³ Jesús hi³ juóun³² lɨ́n³² bíh¹ tsáu² hí¹ja³táunh¹ chí¹cáɨn² cu³hna²¹ dí², jáun² ca³záɨh³ dí² Pí²liéi¹ la³ lá²: ―¿Ha³ jinh¹ lɨ́¹³ lá¹³ dí² má³² hi³ cuh³ la³jɨ́n³² tsá² nɨ́² juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","La³ nɨ́² ca³juáh³ tsú² quí¹ cun³ñí¹ hi³hliá² hnió³ dí² hi³ ca³ hi³ lan³ Pí²liéi¹ bíh¹, quí¹ jmɨ́¹ má²ñi³² bíh¹ Jesús hnga² he³ lánh³ jmu³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Hi³ jáun² Pí²liéi¹ né³ ca³ngáɨ³ la³ lá²: ―Hí¹juáh³ tun³ nio² hñá³láu³ héih³² quɨe³ *cú¹tiáu² yáh³ tiá² laɨn²¹ hi³ lá¹³ dí² *hí³ cuú²miih²¹ hi³ cuh³ la³jɨ́n³² tsá² nɨ́², uá¹ cun³ hi³ jmɨ́¹ cuh³ tsú² ma³pih²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jáun² Tre²¹ raɨnh²¹ Sí¹mu²¹ Pé¹ né³, jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú², ca³juáh³ siáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Lá² zenh² jan² ñú²míh¹ hi³ dí¹quian³² hñá³ hí³ cuú²miih²¹ cebada, la³ má²quionh³ gon³ hma²¹. Tɨ³la³ ¿he³ dá² rón³² hi³ nɨ́² hi³ ca³tɨn¹ juóun³² lɨ́n³² tsá² tionh² lá²? ");
INSERT INTO csoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Hi³ jáun² jmɨ́¹jáun² né³ ca³juáh³ Jesús la³ lá²: ―Zéih³ ca³la³ jɨ́n³² tsá² nɨ́² hi³ cuɨ́¹ tiánh² hué³². Ñí¹ jáun² jmɨ́¹ tsɨ²¹ hliáun³ mí¹ñéi², hi³ jáun² ñí¹ jáun² ca³tiánh³ cun³ hñá³ mei²¹ jmáh³la³ tsá²ñuh². ");
INSERT INTO csoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jmɨ́¹jáun² ca³zanh³ Jesús hí³ cuú²miih²¹ jáun², hi³ jáun² ca³cuéh³ dí² tiá¹hmah¹ Dió³²; jmɨ́¹ lɨ²¹ jáun² né³ ca³cuéh³ dí² tsá² haɨn²¹ hí³ tɨ³ con², jáun² tsá² hí³ ca³tsóh³ ñí¹con² ca³la³ jɨ́n³² tsá² má²tionh² hí³. Ja³bí¹ la³ jáun² siáh³ ca³cuéh³ tsú² tiá¹hmah¹ Dió³² hi³ ca³tɨn¹ hma²¹ hí³, hi³ jáun² ca³tsóh³ tsú² siáh³ ñí¹con² tsáu² nɨ́¹juáh³ ha³ la³ cónh³ hnió³ tsú² cuh³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hi³ jáun² jmɨ́¹ má²lɨ́²cuh³ tsú² jáun² ca³la³ lah³ má³² né³, ca³záɨh³ siáh³ Jesús tsá² haɨn²¹ hí³ tɨ³ con² la³ lá²: ―Cuá²jiéih¹ náh² chí² juoh¹ hi³ má²ziau³², hi³ jáun² tiá² lɨ́¹ tsa³cuɨ́³² hí¹ cú¹pih²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ca³jieh³ bíh¹ tsú², hi³ jáun² ca³cónh³² quia³tún³ mɨ́²tá² chí² juoh¹ hi³ ziau³ quioh²¹ hñá³ hí³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Hi³ jáun² jmɨ́¹ ca³jɨ́e³ jáun² tsá² tionh² hí³ hua³jueh³² hi³ ca³jmú³ jáun² Jesús né³, ca³juáh³ la³ lá²: ―Tson² bíh¹ cu³tí³, tsá² nɨ́² bí¹ lánh³ *tɨ³² jë¹ Dió³², tsá² ca³tɨn¹ hi³ já³² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tɨ³la³ Jesús né³ ca³lɨ³tsɨn² hi³ tsá² hí³ jmɨ́¹ má²hnió³ jau³ chí¹tson³, hi³ jmu³ tsú² hi³ lɨ́n³ dí² re²¹, hi³ jáun² ngau³ dí² la³ tɨ³ tsɨ³ máh³ hi³ ja³cuá² dí² cú² hnga² tán¹ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hi³ jáun² jmɨ́¹ má²ca³zɨ³² né³, ca³son² tsá² haɨn²¹ hí³ tɨ³ con² Jesús máh³ jáun² hi³ ja³tanh²¹ siáh³ tɨ³ can³² jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jmɨ́¹ má²zɨ³² lɨ́n³² bíh¹, hi³ tiá² jmɨ́¹ má²jaunh³² yáh³ Jesús tsɨ³ máh³ jáun², hi³ jáun² taunh³ tsú² cú²jueh³² hñu³ mu² hi³ ca³han³ dí² tɨ³ jo²¹ jmáɨ² hi³ chá¹tánh¹ tɨ³ juú² Capernaum. ");
INSERT INTO csoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tá¹la³ jmɨ́¹ ná¹han³² tsú² jáun² jmáɨ² né³, ca³cua³tsɨ³² chí³ tiá³ lɨ́n³² hi³ ca³la³ hi³ cáu³ ma³ cu³ tsɨn¹ jmɨ́²miih²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jmɨ́¹ má²lɨ́²ngɨ́³² jáun² mu² ñí¹ tí³ cun³ hñá³ ho³ jñéi³ kilómetros né³, jáun² ca³jɨ́en³² tsú² Jesús hi³ cuá¹ngɨ³² ñí¹ jmáɨ², hi³ hí¹ja³² juɨ³² ñí¹ hí¹tsau³² jáun² mu², hi³ jáun² jmɨ́¹jáun² né³, ca³juénh² lɨ́n³² bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tɨ³la³ Jesús né³, ca³juáh³ la³ lá²: ―¡Ha³ lɨ́² juenh³ náh², quí¹ jná¹³ bíh¹ la³²! ");
INSERT INTO csoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Hi³ jáun² tsá² hí³ né³, ca³lɨ³ hiún² tsɨ́³ hi³ tanh¹³ Jesús hñu³ mu² jáun²; jmɨ́¹ lɨ²¹ jáun² né³, né³² cánh³ bíh¹ ca³cháuh³² mu² jáun² hué³² ñí¹ qui³ cuá¹tsauh³². ");
INSERT INTO csoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jmɨ́¹ cá¹jniá²¹ jáun² né³, tsá² ca³ta³tonh¹ hí³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun² ca³lɨ³tsɨn² hi³ la³ má²já²tanh²¹ bíh¹ tsá² haɨn²¹ hí³ tɨ³ con² Jesús quionh³ mu² cáun² tán¹ hi³ jmɨ́¹ rón²¹ jáun²; hi³ ca³lɨ³tsɨn² tsú² siáh³ hi³ tiá² la³ ngah³ yáh³ Jesús quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tá¹la³ jáun² né³ cua³toh³ siáh³ mu² siáh³, mu² jáun² ca³hué² juú² Tiberias hi³ cua³toh³ có³² ñí¹ má²lɨ́²cuh³ tsú² jáun² hí³ cuú²miih²¹ jmɨ́¹ má²lɨ́²cuéh³² jáun² Tɨ³² Juo¹³ dí² tiá¹hmah¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Hi³ jáun² dá² jmɨ́¹ ca³jɨ́e³ tsá² hí³ hi³ tiá² Jesús zenh² yáh³ ñí¹ jáun², hi³ sa³jun³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² tionh², hi³ jáun² ca³taunh³ tsá² hí³ hñu³ mu² jáun², hi³ já¹taunh²¹ tɨ³ já¹ juú² Capernaum hi³ hnah² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Jmɨ́¹ ca³cha³táunh¹ jáun² tsá² hí³ jo²¹ jmáɨ² lɨ́¹ ná¹ho³ jáun² né³, ca³jenh² dí² Jesús, hi³ jáun² ca³ngáɨh³ dí² hi³ ca³juáh³ la³ lá²: ―¿Lɨ́h³ dá² cuanh³ hnú² tɨ³ lá² Tɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tɨ³la³ Jesús né³ ca³juáh³: ―Hú¹tá¹ cu³tí³ ma³tson¹³ jná¹³ jáɨ¹³ lá² hi³ hnoh² dá² hnauh²³ jná¹³ quí¹hliá² cun³ñí¹ hi³hliá² ca³quɨéɨh³ náh² ca³la³ ca³cónh³² henh¹ bíh¹, jun³juáh¹³ hi³hliá² má²ca³há¹ ca³ngɨ¹³ náh² li²¹ hi³ ca³jmú³² jná¹³ jáun² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Cha³ jmɨ́¹ jmúh¹³ náh² ta²¹ hi³ lɨ³ zian² náh² má³² hi³ lɨ́¹ tsá², hniáuh³² jmúh¹³ náh² cú²jueh³² hi³ lɨ³ zian² náh² má³² hi³ jmɨ́¹lɨ́h³ tiá² tsá² bíh¹, hi³ jmu³ hi³ lɨ́¹³ zian² náh² la³ cun³ jmɨ́¹hi³nio² yáh³. Jná¹³ Jon² tsá²mɨ³cuóun² bíh¹ lɨ́¹³ cué¹³ má³² jáun², quí¹ jná¹³ bíh¹ má²ca³chau³ Dió³² Ñuh³² hi³ cuá¹chan¹ ná¹ ca³tɨ²¹ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jáun² né³, tsá² hí³ ca³ngáɨ³ la³ lá²: ―¿He³ lánh³ hniáuh³² jmú¹³ jnoh¹ hi³ jáun² lɨ́¹³ jmú¹³ jnoh¹ la³ cun³ ta²¹ hi³ hnió³ Dió³² jmú¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Hi³ jáun² Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―La³ lá² bíh¹ hnió³ Dió³² jmúh¹³ náh²: Hniáuh³² tanh¹³ náh² ta²¹ Tsá² má²lɨ́²zen³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jáun² tsá² hí³ ca³ngáɨ³ siáh³ hi³ ca³juáh³: ―¿He³ li²¹ lɨ́¹³ jmúh¹³ nú² hi³ neh²¹ jnoh¹, hi³ jáun² taunh¹³ jnoh¹ ta²¹? ¿He³ ñí¹ ta²¹ lɨ́¹³ jmúh¹³ hnú² la³ jmɨ́¹ ca³jmú³ jáun² hla¹ Moisés? ");
INSERT INTO csoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Quí¹ dí¹hio³ ñú¹deh³ jnoh¹ ca³cúh² má³² hi³ téh²³ tsú² jáun² maná tá¹la³ jmɨ́¹ tionh¹ tsú² jáun² hué³² quiéin², la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí², hi³ juáh³ la³ lá²: “Ca³súh³ tsú² má³² hñu³mɨ³cuú² hi³ ca³cúh² tsá² hí³”. ");
INSERT INTO csoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jáun² Jesús né³ ca³ngáɨ³ siáh³: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ jun³juáh¹³ hla¹ Moisés yáh³ tsá² ca³cué³ má³² hi³ ca³súh³² jáun² hñu³mɨ³cuú², quí¹ hnga² bíh¹ Ñuh³² jná¹³ Tsá² ca³cué³. Hi³ ta³né³² né³ cue³² tsú² hú¹tá¹ ti³tsóh³ má³² bíh¹ hi³ ja³ hñu³mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Quí¹ Tsá² ja³ hí³ hñu³mɨ³cuú² bíh¹ lɨ́n³ hí³ cuú²miih²¹ hi³ cue³² Dió³², hi³ jáun² Tsá² hí³ bíh¹ jmu³ hi³ hú¹tá¹ cu³tí³ lɨ́¹³ zian² tsá² zian² hngá¹máh³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hi³ jáun² tsá² hí³ né³ ca³juáh³ la³ lá²: ―Tɨ³², cué¹ tiá³ jnoh¹ hí³ cuú²miih²¹ jáun² la³jɨ́³² jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jáun² Jesús ca³juáh³: ―Jná¹³ bíh¹ lɨ́n³ ná¹ hí³ cuú²miih²¹ hi³ jmu³ hi³ lɨ́¹³ zian² tsú² cun³ jmɨ́¹hi³nio². Nɨ́¹juáh³ tsá² ja³² ñí¹con² jná¹³, jmɨ́¹lɨ́h³ bíh¹ tiá² lɨ́¹³ ñí¹cuóunh²¹ tsú²; hi³ nɨ́¹juáh³ tsá² nio² cáun² tsɨ́³ ñí¹con² jná¹³ né³, cun³ tiá² tón³² jmáɨ¹ lɨ́¹³ bíh¹ hí¹quiéin² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tɨ³la³ la³ cun³ má²lɨ́²juáh³² jná¹³ nɨ́² má¹ná¹, hnoh² dá² cun³ tiá² ta²¹ taunh²³ bíh¹ náh² jná¹³, uá¹jinh¹ má²lɨ́²jɨe¹ náh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Quí¹ la³jɨ́n³² tsá² chan² Ñuh³² jná¹³ jo³uón³² ja³táunh¹ ñí¹con² jná¹³; hi³ tsá² ja³táunh¹ hí³ ñí¹con² jná¹³ né³, jmɨ́¹lɨ́h³ yáh³ tiá² huen¹ jná¹³ tsú² cheih³². ");
INSERT INTO csoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Quí¹ tiá² ja³ yáh³ jná¹³ hñu³mɨ³cuú² hi³ ja³jmú³² la³ cun³ hi³ tɨ³² tsɨn³² huen², tɨ³la³ jná¹³ dá² ja³ hi³ jmu¹ ná¹ la³ cun³ hi³ hnió³ Ñuh³² ná¹ Tsá² ca³ze³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hi³ la³ cun³ hi³ hnió³ jáun² Ñuh³² jná¹³ Tsá² ca³ze³ né³, hi³ jmu¹ jná¹³ hua³hí¹³ la³jɨ́n³² tsá² má²ca³chan³ tsú² jo³uón³² bíh¹, hi³ jáun² tiá² lɨ́¹ tsa³háɨn³ hí¹ jan²; hi³ jáun² ñí¹ ca³táuh³ jmáɨ¹ né³ jmu¹ jná¹³ siáh³ hi³ jenh¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Quí¹ Ñuh³² bíh¹ jná¹³ hnió³ hi³ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio² ca³la³ jɨ́n³² tsá² jɨ́e²³ chí¹tiá³ ñí¹ ñí¹con² Jon² Dió³², jɨ³ hi³ tanh² tsú² siáh³ ta²¹; hi³ jáun² jná¹³ jmu¹ siáh³ hi³ jenh¹³ tsá² la³ hí³ ñí¹ ca³táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cun³ñí¹ hi³ jáun² né³, tsá² judíos ca³ma³liáu³² hi³ ziú² hɨen² Jesús quí¹hliá² ca³juáh³ la³ lá²: “Jná¹³ bíh¹ lɨ́n³ hí³ hi³ ja³ hñu³mɨ³cuú²”. ");
INSERT INTO csoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jmɨ́¹jáun² ca³juu³ ca³hlénh³ dí² la³ lá²: ―¿Haun¹³ juáh¹³ Jesús jon² hla¹ Sé³² bíh¹ nɨ³² dúh¹? Já² ná¹cuóun²¹ bíh¹ dí² jméi² mí¹ziú¹³ tsú², hi³ jáun² ¿ha³ bí¹ lánh³ rón³² juáh³ tsú² hi³ hí³ néh¹ ja³ hñu³mɨ³cuú²? ");
INSERT INTO csoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jmɨ́¹jáun² né³, ca³juáh³ Jesús la³ lá²: ―Ha³ lɨ́² ziú² lɨ́² hɨe³ náh². ");
INSERT INTO csoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Quí¹ hí¹ jan² yáh³ tiá² hin² lɨ́¹³ já³² ñí¹con² jná¹³ nɨ́¹juáh³ tiá² la³ má²lɨ́²tié³ yáh³ Ñuh³² jná¹³ Tsá² ca³ze³ ná¹; hi³ jáun² tsá² téh²³ hí³ Ñuh³² jná¹³ né³, jná¹³ bíh¹ jmu¹ hi³ jenh¹³ tsú² ñí¹ ca³táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ñí¹ Sí² hi³ ca³jmú³ tsá² ca³lɨn³ tɨ³² jë¹ Dió³² rá¹juáh³ la³ lá²: “Hnga² bíh¹ Dió³² ma³tɨn² ca³la³ jɨ́n³² tsáu²”. Jáun² la³ nɨ́² bíh¹ lɨ́³, hi³ la³jɨ́n³² tsá² náɨ³² la³ cun³ hi³ juáh³ Ñuh³² jná¹³, jɨ³ hi³ lɨ́²tɨn² tsú² siáh³ la³ cun³ hi³ má²ta² hí³, tsá² hí³ bíh¹ ja³táunh¹ ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","”Jun³juáh¹³ hliá² zian² tsá² má²ca³jɨ́en³² yáh³ Jméi² dí²; quí¹ jɨ́³²la³ hnga² Tsá² ja³ hí³ ñí¹con² bíh¹ Dió³² má²ca³jɨ́e³². ");
INSERT INTO csoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jú¹ tson² cu³tí¹³ juanh³² jná¹³, hi³ lɨ³ua³ jan² tsá² nio² cáun² tsɨ́³ ñí¹con² jná¹³, tsá² la³ hí³ bíh¹ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Quí¹ jná¹³ bíh¹ lɨ́n³ hí³ cuú²miih²¹ hi³ jmu³ hi³ lɨ́¹³ zian² tsú² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Uá¹jinh¹ dí²hioh³ ñú²deh³ hnoh² ca³cúh² má³² hi³ téh²³ tsú² jáun² maná ñí¹ lɨ́³ hué³² quiéin² jáun² jmɨ́¹tin², tɨ³la³ cu³ jáun² ca³tsan³ bíh¹ tsú²; ");
INSERT INTO csoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","tɨ³la³ jná¹³ dá² hléh²³ hi³ ca³tɨn¹ hí³ cuú²miih²¹ hi³ ja³ jáun² hñu³mɨ³cuú² bíh¹. Hi³ jáun² né³, lɨ³ua³ jan² tsá² cuh³ hí³ jáun² tiá² jún³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Huen² bíh¹ jná¹³ lɨ́n³ ná¹ hí³ cuú²miih²¹ hi³ jmu³ hi³ lɨ́¹³ zian² tsú², hi³ ja³ jáun² hñu³mɨ³cuú²; hi³ jáun² nɨ́¹juáh³ tsá² cuh³ hí³ lá² né³, lɨ³ zian² cun³ jmɨ́¹hi³nio² bíh¹. Ti³tsóh³dí¹ ngú³ quion²¹ bíh¹ jná¹³ lɨ́³ hí³ cuú²miih²¹ hi³ cué¹³ jná¹³ jáun² hi³ ca³tɨn¹ tá¹ cáun² hngá¹máh³, hi³ jáun² lɨ́¹³ zian² tsú² cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jmɨ́¹jáun² ca³ma³liáu³² tsá² judíos hi³ ca³juu³ ca³hlénh³ má²tún² hmóu³² hi³ juáh³ la³ lá²: ―¿Ha³ bí¹ lánh³ rón³² lɨ́¹³ cué³² tsá² nɨ́² ngú³ quioh²¹ hnga² hi³ cúh¹³ jnoh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús né³ ca³juáh³ siáh³ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ nɨ́¹juáh³ hnoh² tiá² cúh¹³ náh² ngú³ quion²¹ jná¹³ Jon² tsá²mɨ³cuóun², jɨ³ hi³ húh¹³ náh² siáh³ jmɨ́²hán¹ ná¹, hi³ jáun² tiá² lɨ́¹³ yáh³ zian² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Quí¹ cun³ jmɨ́¹hi³nio² bíh¹ zian² tsú² nɨ́¹juáh³ tsá² cúh² ngú³ quion²¹ jná¹³ jɨ³ hi³ hɨ́nh²³ tsú² siáh³ jmɨ́²hán¹ jná¹³; hi³ jáun² jná¹³ jmu¹ siáh³ hi³ jenh¹³ tsú² ñí¹ ca³táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Quí¹ ngú³ quion²¹ jná¹³ bíh¹ lɨ́³ hú¹tá¹ ti³tsóh³ má³², hi³ jmɨ́²hán¹ jná¹³ né³ lɨ́³ hú¹tá¹ ti³tsóh³ jmáɨ² hi³ lɨ́²cuoh² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Hi³ jáun² lɨ³ua³ jan² tsá² cúh² ngú³ quion²¹ jná¹³, jɨ³ hi³ hɨ́nh²³ tsú² siáh³ jmɨ́²hán¹ jná¹³, tsá² la³ hí³ bíh¹ má²cá²cunh³ quiúnh¹ jná¹³, hi³ jáun² jná¹³ né³ má²cá²cunh³ siáh³ quionh³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Quí¹ Ñuh³² jná¹³ Tsá² ca³ze³ dá², jan² Dió³² Tsá² juú²tsáun² bíh¹; hi³ jáun² jná¹³ né³ zian² cun³ñí¹ hi³ ca³tɨn¹ hí³ bíh¹. Hi³ jáun² la³ jáun² bí¹ siáh³ lɨ́³, hi³ nɨ́¹juáh³ tsá² lɨ³tú² lɨ³má³² jmɨ́¹ tsɨ́³ cun³quionh³ jná¹³, jáun² cun³ñí¹ hi³ ca³tɨn¹ jná¹³ bíh¹ lɨ́¹³ zian² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jná¹³ dá² hléh²³ hi³ ca³tɨ²¹ hí³ cuú²miih²¹ hi³ ja³ hñu³mɨ³cuú² bíh¹. Hí³ lá² tiá² lɨ́³ yáh³ la³jmɨ́¹ lɨ́³ má³² hi³ ca³cúh² jáun² dí²hioh³ ñú²deh³ hnoh² jmɨ́¹tin², hi³ jmɨ́¹ lɨ²¹ jáun² né³ cu³ jáun² ca³hiá² cá²tsan³ bíh¹ tsú²; tɨ³la³ nɨ́¹juáh³ tsá² cuh³ hí³ lá² má¹ná¹, lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ca³ma³ta² jáɨ¹³ nɨ́² hñu³ cuáh³² quioh²¹ tsá² judíos hi³ zeh² jáun² já¹ juú² Capernaum. ");
INSERT INTO csoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jmɨ́¹ ca³náɨ³² jáun² tsá² má²tsá²táunh¹ hí³ cu³hna²¹ Jesús jáɨ¹³ nɨ́² né³, jáun² juóun³² tsá² hí³ ca³juáh³ la³ lá²: ―Já² juóuh³² lɨ́n³² bíh¹ jáɨ¹³ hi³ má²lɨ́²juáh³ tsú² nɨ́²; jun³juáh¹³ hi³ tú¹ tsa¹³ jnoh¹ má¹tí²¹ yáh³ jáɨ¹³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Tɨ³la³ Jesús né³ ca³lɨ³tsɨn² bíh¹ hi³ tsá² hí³ ná¹juónh²³ hi³ ná¹má²tsan² tsɨ́³ ca³tɨ²¹ jáɨ¹³ jáun², jáun² ca³záɨh³ dí² la³ lá²: ―¿Hí¹ má²ja³tsan² honh² hnoh² cun³quionh³ jáɨ¹³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿He³ la³ lɨ́¹³ jaun³² nɨ́¹juáh³ hi³ la³ ca³jɨen¹ náh² Jon² tsá²mɨ³cuóun² hi³ cuá¹uɨnh³² siáh³ tɨ³ ñí¹ jmɨ́¹ cuá³ jmɨ́¹tin²? ");
INSERT INTO csoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Hnga² Jmɨ́²chí³ joh¹ Dió³² bíh¹ jmu² hi³ lɨ́¹³ zian² tsú²; quí¹ ha³ tiá² lin¹ ñí¹ jmu² ta²¹ yáh³ ngú³. Hi³ la³jɨ́³² jáɨ¹³ hi³ má²lɨ́²hléh³ jná¹³ nɨ́² né³, hɨ́e³² jú¹ tson² hi³ ca³tɨn¹ Jmɨ́²chí³ hí³ bíh¹, jɨ³ hi³ ca³tɨ²¹ ha³ lánh³ lɨ́¹³ zian² tsú² cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tɨ³la³ cun³ jáun² zian² bíh¹ ma³ jan² hnoh² hi³ tiá² má²nio² cáun² honh² náh². La³ nɨ́² ca³juáh³ Jesús quí¹ cun³ñí¹ hi³hliá² jmɨ́¹ má²ñi³² bíh¹ tsú² la³ cun³ jmɨ́¹tin² hin² tsánh² tiá² ta²¹ taunh³², hi³ hin² tsánh² tsa³jɨenh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jáun² ca³juáh³ dí² siáh³ la³ lá²: ―Já² jáun² yáh³ má²lɨ́²juáh³² jná¹³ ñí¹con² hnoh² hi³ hí¹ jan² yáh³ tiá² hin² lɨ́¹³ já³² ñí¹con² jná¹³ nɨ́¹juáh³ hi³ tiá² té³ hnga² Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","La³ cun³ jmɨ́¹jáun² bíh¹ juóun³² tsá² jmɨ́¹ haɨn²¹ hí³ tɨ³ con² Jesús ca³jính³² hi³ tiú²uú² ca³ñi³táunh¹ yáh³ quionh³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jmɨ́¹ lɨ²¹ jáun² né³ ca³ngáɨh³ Jesús tán¹ quian³tun³ tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³ la³ lá²: ―¿Hí¹ ja³bí¹ hnoh² uá²jaɨ³² hnáuh² cuá¹tánh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tɨ³la³ Sí¹mu²¹ Pé¹ né³ ca³ngáɨ³ la³ lá²: ―Hnú² Tɨ³², ¿hin² dá² tɨ³ ñí¹con² lɨ́¹³ tsáu¹³ jnoh¹? Quí¹ hnú² bíh¹ Tsá² quiánh¹ jáɨ¹³ hi³ jmu² hi³ lɨ́¹³ zian² tsú² la³ cun³ jmɨ́¹ hi³ nio². ");
INSERT INTO csoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hi³ jnoh¹ né³ má²ca³táunh¹³ ta²¹, hi³ má²ca³lɨ³ né¹ jnoh¹ siáh³ hi³ hnú² bíh¹ lɨ́n³ nú² Tsá² chun¹ joh¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jáun² né³ Jesús ca³ngáɨ³ la³ lá²: ―¿Há¹ jun³juáh¹³ huen² jná¹³ ca³quiánh³² hnoh² tán¹ quian³tun³ náh² dúh¹? Tɨ³la³ cun³ jáun² zian² bíh¹ jan² tsá² hláɨh¹ ja¹ quián¹³ hnoh² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jmɨ́¹ ca³hléh³ jáun² Jesús jáɨ¹³ nɨ́² né³, ca³hléh³ tsú² hi³ ca³tɨn¹ Judas jon² Sí¹mu²¹, tsá² ja³ hí³ tɨ³ juú² Queriot bíh¹, quí¹hliá² Judas hí³ bíh¹ tsá² jɨenh³ Jesús, uá¹jinh¹ hí³ jmɨ́¹ lɨ́n³ jan² tsá² quian³tun³ joh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jmɨ́¹ má²lɨ³² jáun² né³, jmɨ́¹ cuá¹ngɨ³² Jesús tɨ³ hué¹³ Galilea; tiá² jmɨ́¹ hnió³ yáh³ tsú² hi³ tsa³ngɨ́² siáh³ tɨ³ Judea, quí¹hliá² tsá² *judíos tsá² ná¹ñí¹ jmɨ́¹ hnauh² ñí¹ jáun² hi³ hnió³ jngah³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɨ³la³ má²janh² bíh¹ jmɨ́¹ má²he² hi³ tɨ²¹ jmáɨ¹ quioh²¹ hñú³reh³, cáun² jmáɨ¹ hi³ jmu² tsá² judíos. ");
INSERT INTO csoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jáun² né³, tsá¹ dá¹jon²¹ Jesús ca³juáh³ la³ lá² ñí¹con²: ―Ha³ lɨ́²uú² ñí³ ñí¹ lá², cua³² tɨ³ Judea, hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² hnú² tionh² ñí¹ zio¹ lɨ́¹³ jɨ́e³ uá²jaɨ³² la³ cun³ hi³ jmuh³² nú². ");
INSERT INTO csoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Quí¹ nɨ́¹juáh³ jan² tsá² hnió³ hi³ lɨ³ cuóu³² tsáu², jáun² tiá² jmu² yáh³ tsú² ñí¹ tiá² hin² nga³ jɨ́e³² la³ cun³ ta²¹ hi³ jmu². Hi³ cun³ñí¹ hi³ jmuh³² hnú² ta²¹ la³ nɨ́² né³, jáun² ñí¹ ta³ ñí¹ ca³la³ jɨ³lɨn² tsáu² bíh¹ hniáuh³² cuá¹jmuh³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ca³juáh³ tsá¹ dá¹jon²¹ tsú² la³ nɨ́², quí¹hliá² sa³jun³ jmɨ́¹ ná¹tanh² yáh³ tsá² hí³ ta²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jmɨ́¹jáun² né³ ca³záɨh³ Jesús tsá² hí³ la³ lá²: ―Ha³ tiá² má²cá²chó³² yáh³ jmáɨ¹ quion²¹ jná¹³, tɨ³la³ hi³ ca³tɨn¹ hnoh² má¹ná¹, cáun² chu²¹ bíh¹ lɨ³ua³ cáun² jmáɨ¹ lɨ́n²³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Quí¹ tiá² lɨ́¹³ yáh³ jmu³ tsá² zian² hngá¹máh³ lá² hau² hnoh²; tɨ³la³ jná¹³ bíh¹ hau² tsú², quí¹hliá² jná¹³ bíh¹ chú² jñéih³² ná¹ ñí¹ hó²¹ñí¹ tsú² la³jɨ́³² hi³ hlah³ hi³ jmu². ");
INSERT INTO csoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jáun² né³, cuá²táunh¹ dá² hnoh² jmáɨ¹; tɨ³la³ jná¹³ ha³ tiá² má²ñé¹ yáh³, quí¹ ha³ tiá² má²cá²chó³² yáh³ jmáɨ¹ quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hi³ jmɨ́¹ má²lɨ́²zéih³² dí² tsá² hí³ la³ nɨ́² né³, ca³ta³cua¹³ bíh¹ dí² hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tɨ³la³ jmɨ́¹ má²lɨ³² jáun² né³, ngau³ Jesús chí¹cáɨn² cu³hna²¹ tsá² hí³ raɨnh²¹, tɨ³la³ ta³ conh¹ bíh¹ ngau³ tsú² má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tá¹la³ jmáɨ¹ jáun² né³ jmɨ́¹ hnauh² tsá² judíos tsá² ná¹ñí¹ quioh²¹ tsú², hi³ ná¹juáh²³ la³ lá²: ―¿Ha³ bí¹ jinh¹ zenh² tsá²ñuh² hí³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hi³ ja¹ tsáu² né³ jmɨ́¹ zian² juóun³² tsá² jmɨ́¹ ná¹juónh²³ hi³ ca³tɨn¹ hí³ dí². Ma³ jan² tsáu² jmɨ́¹ ná¹juáh²³ la³ lá²: ―Jan² tsá² chun¹ bíh¹ hí³. Tɨ³la³ ma³ jan² né³ jmɨ́¹ ná¹juáh²³: ―Ha³ tiá² jáun² yáh³, ti³ lɨ́¹ má²can² tsáu² bíh¹ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tɨ³la³ hí¹ jan² yáh³ tiá² hin² jmɨ́¹ ja³² tsɨ́³ hi³ juónh³ chú¹ja²¹ jáɨ¹³ hi³ ca³tɨn¹ tsú², quí¹ cun³ñí¹ hi³ jmɨ́¹ juénh² tsú² tsá² judíos tsá² ná¹ñí¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Chu³jo² jmáɨ¹ jmɨ́¹ má²tí³ la³ cun³ jmɨ́¹ ca³hi³ Jesús hñu³ cuáh³² chín¹, hi³ ca³ma³liáu³² hi³ má²tɨn² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hi³ jáun² tsá² judíos tsá² ná¹ñí¹ né³, lɨ́¹ ca³ja³cáun² bíh¹ tsɨ́³, jáun² ca³qui³ ca³ngáɨh³ dí² tsá²ján² tsá²ján²: ―¿He³ bí¹ lánh³ rón³² lɨ́³, sa³ hliáun³ lɨ́n³² máh³ hi³ ñi³² tsá² nɨ́² ta³ tiá² lin¹ hi³ ca³ma³tɨn³²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jáun² Jesús né³ ca³ngáɨ³: ―Jáɨ¹³ quioh²¹ Tsá² ca³ze³ bíh¹ jná¹³ hi³ ma³tɨn¹³ ná¹ tsáu², jun³juáh¹³ jáɨ¹³ quion²¹ huen² yáh³ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nɨ́¹juáh³ zian² tsá² hún¹ hua³jan²¹ hi³ jmu³ la³ cun³ hi³ hnió³ Dió³², jáun² lɨ³tsɨn² bíh¹ tsú² nɨ́¹juáh³ jáun² bíh¹ jáɨ¹³ hi³ ja³ ñí¹con² Dió³² ma³tɨn¹³ jná¹³ tsáu² ho³lá²dá² jáɨ¹³ hi³ lɨ́¹ chin³² chin³² huen² uá¹ jná¹³ hléh²³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Quí¹ nɨ́¹juáh³ tsá² hleh³² la³ cun³ hi³ chin² chí¹ hnga², tsá² la³ hí³ hleh³² cun³ñí¹ hi³ hniá¹ tsú² hi³ ma³quien² tsáu² hnga² bíh¹ tsú²; tɨ³la³ nɨ́¹juáh³ tsá² jmu² tion³ hi³ lɨ³ quien² tsá² lɨ́²ze³ má¹ná¹, tsá² la³ hí³ bíh¹ ján¹ tson² quian³² jú¹ tson², hi³ ñí¹con² tsá² la³ hí³ né³, hí¹ cáun² tso³ tiá² cháuh³² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","”¿Tiá¹ tson² dúh¹ hi³ hla¹ Moisés bíh¹ ca³cué³ hnoh² liei²¹? Tɨ³la³ cun³ jáun² hí¹ jan² yáh³ hnoh² tiá² ná¹ma³tih²¹ náh² liei²¹ jáun². Quí¹ ¿he³ láɨh³² sa³ hnáuh² náh² jngah¹³ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jáun² tsá² jmɨ́¹ ná¹ngɨh³² ñí¹ jáun² né³ ca³ngáɨ³: ―Jmɨ́²chí³ hláɨnh¹ bíh¹ ján³ hnú², quí¹ ¿hin² dá² hnió³ jngah³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús né³ ca³juáh³ siáh³ la³ lá²: ―La³jɨ́n³² bíh¹ hnoh² ca³ja³cáun² honh² náh² cun³ñí¹ hi³ ca³tɨ²¹ cáun² pih²¹ ta²¹ hi³ ca³jmú³² jná¹³ jáun² jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tɨ³la³ sá¹nɨ́² jɨe³ dú¹ né³: Cun³ñí¹ hi³ jlánh¹ ñí¹má¹tih²¹ náh² héih³² quioh²¹ hla¹ Moisés, jáun² cáun² *tiuh³² bí¹ náh² chí² láu² hná¹³ ñí¹ zian² dáɨn² jónh³² uá¹jinh¹ ti³tsóh³dí¹ *jmáɨ¹ nio² tie³ bíh¹ ca³chó³² jmáɨ¹ hi³ hniáuh³² cué³² tsú² li²¹ jáun² quioh²¹ dáɨn² pih²¹. Ma³tih²¹ náh² héih³² jáun² quioh²¹ tsú² uá¹jinh¹ jun³juáh¹³ hí³ yáh³ ca³ma³liáu³², quí¹ hi³ jáun² dá² ca³ma³liáu³² tsá²haun³² dí²hioh³ ñú²deh³ bíh¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Né³² né³, re² bíh¹ nɨ́¹juáh³ cun³ñí¹ hi³ tiá² hnáuh² náh² hi³ tá¹tonh¹ hlah³ ñí¹con² liei²¹ quioh²¹ hla¹ Moisés, hi³ jáun² uá¹jinh¹ jmáɨ¹ nio² tie³, cun³ jáun² jmuh³² bíh¹ náh² lin¹ ñí¹con² dáɨn² jónh³² hi³ lin¹ hi³ taunh² Dió³² hó¹ñí¹ quioh²¹ tsú². Jáun² né³ ¿he³ láɨh³² sa³ míh²³ yáh³ honh² náh² ñí¹con² jná¹³ quí¹ cun³ñí¹ hi³ jná¹³ tɨ³ ca³jmah²¹ ná¹ re² tɨn² jan² tsá² hliánh² jmáɨ¹ nio² tie³? ");
INSERT INTO csoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ha³ lɨ́²uú² chú¹ uú² ñih²¹ náh² nɨ́¹juáh³ lánh³ jniá³ tsáu², tɨ³la³ chú¹ ñih²¹ náh² la³ cun³ ca³tɨ²¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Hi³ jáun² jmɨ́¹jáun² né³, ma³ jan² tsá² zian² juú² Jerusalén ca³ma³liáu³² hi³ ngaɨh³² tsá²ján² tsá²ján², hi³ juáh³ la³ lá²: ―¿Há¹ jun³ tsá² ó³² hnah² tsú² hi³ jngɨh³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Já² ó³² bíh¹ zenh² tsú² hi³ dí¹hleh³² chú¹ja²¹, hi³ hí¹ jan² yáh³ tiá² hin² hi³ juáh³ hí¹ cáun² ñí¹con² tsú². ¿Hí¹ la³ taunh³² uá¹ tsá²tan²¹ ta²¹ juáh¹³ hi³ tsá²ñuh² ó³² lɨ́n³ Tsá² zéi¹ Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Tɨ³la³ jnoh¹ má¹ná¹, né¹ bíh¹ dí² ha³ jinh¹ ja³ tsú²; tɨ³la³ nɨ́¹juáh³ nɨ́¹ má¹cuán² hú¹tá¹ Tsá² zéi¹ Dió³² né³, hí¹ jan² yáh³ tiá² hin² lɨ³ ñi³² hi³ ha³ jinh¹ ja³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jmɨ́¹ ca³náɨ³² Jesús jáɨ¹³ nɨ́² né³, ca³hléh³ tiá³ tá¹la³ dí¹má²tɨn² jáun² tsáu² hñu³ cuáh³² chín¹, hi³ ca³juáh³ la³ lá²: ―¡Háh³²! ¡Jlánh¹ re² la³ ñíh¹ hnoh² ha³ jinh¹ ja³ jná¹³ láh¹! Tɨ³la³ tiá² ja³ yáh³ jná¹³ hi³ ca³tɨn¹ ná¹ huen², tɨ³la³ jná¹³ dá² ja³ ná¹ hi³ zéi¹ ná¹ jan² Tsá² tson² jë¹ bíh¹, jan² Tsá² tiá² cuóun³² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tɨ³la³ jná¹³ má¹ná¹, cuóun³² bíh¹ ná¹ tsú², quí¹hliá² ñí¹con² hí³ bíh¹ ja³ ná¹; hí³ bíh¹ ca³ze³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hi³ jáun² jmɨ́¹jáun² né³ jmɨ́¹ hnió³ tsáu² jan³ Jesús hi³ tson³; tɨ³la³ hí¹ jan² yáh³ tiá² hin² ca³tie³ cuo², quí¹ tiá² jmɨ́¹ má²cá²chó³² yáh³ jmáɨ¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tɨ³la³ juóun³² lɨ́n³² bíh¹ tsá² ná¹ngɨh³² hí³ ca³taunh² ta²¹ quioh²¹ Jesús, hi³ ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ nɨ́¹ má¹cuán² Tsá² lɨ́n³ Cristo, ¿hí¹ tɨ³ jlánh¹ bíh¹ hliáun³ li²¹ hi³ lɨ́³ hua³jueh³² jmu³ nɨ́¹ má¹cuán² la³cónh³ bíh¹ tsá²ñuh² lá²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jáun² né³, tsá² *fariseos ca³náɨ³² la³ cun³ hi³ ná¹juáh²³ jáun² tsáu² hi³ ca³tɨn¹ Jesús; jáun² hí³ dí² la³ má²quionh³ tsá² ná¹lɨ́n³ mi³jmú³ ca³zen³ tsá²cuú² tsá²ta³ hi³ tsa³quian³ Jesús hi³ tson³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hi³ jáun² Jesús né³ ca³juáh³ la³ lá²: ―Cónh³í¹ cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ ñi²¹ jná¹³ quiúnh¹ hnoh², hi³ jáun² má¹jáun² má²ñih²¹ jná¹³ tɨ³ ñí¹ cuá³ Tsá² ca³ze³ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nɨ́¹ má¹jáun² né³ má²hnauh¹³ hnoh² jná¹³, tɨ³la³ tiá² chauh¹ yáh³ hnoh² jná¹³, quí¹ ha³ tiá² lɨ́¹³ yáh³ cuá¹táunh¹ hnoh² ñí¹ ñí¹ñí²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Hi³ jáun² jmɨ́¹jáun² né³ ca³juu³ ca³hlénh³ tsá² ná¹ñí¹ joh¹ tsá² judíos quionh³ tsá²ján² tsá²ján², hi³ ca³juáh³: ―¿Hín² máh³ dá² tɨ́h³ tsó³² tsá² nɨ́², hi³ jáun² jnoh¹ máh³ tiú²uú² chanh²¹ dí²? ¿Hí¹ tsó³² dí² ñí¹ tiáunh¹ tsá² judíos tsá² ná¹yanh³² ja¹ *tsá²cá²jo²¹ hi³ tsa³ma³tɨn² dí² tsá²cá²jo²¹ hí³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿He³ dá² hnió³ juáh³ hi³ lɨ́²juáh³ tsú² jáun² la³ lá²: “Hnauh¹³ hnoh² jná¹³, tɨ³la³ tiá² chauh¹ yáh³ náh² jná¹³, quí¹ tiá² lɨ́¹³ yáh³ hi³ cuá¹táunh¹ hnoh² ñí¹ ñí¹ñí²¹ jná¹³”? ");
INSERT INTO csoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jáun² jmáɨ¹ hi³ ná¹jueh³² jmáɨ¹ jáun² né³, ca³náu² Jesús hi³ ca³hléh³ tiá³, ca³la³ hi³ chi²¹ tiú² mah¹ tiú² jan³², hi³ ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ zian² tsá² hí¹quiéin² tsɨ́³, cuɨ́¹ ja³hính² jmáɨ² ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Quí¹ ñí¹con² tsá² má²taunh² ta²¹ jná¹³ lɨ́³ la³jmɨ́¹ lɨ́³ hi³ chí¹ñei³² bíh¹ jmɨ́² cua³ hñu³ tsɨ́³ tsú², jmáɨ² hi³ jmu³ hi³ hú¹tá¹ cu³tí³ zian² tsú², la³ cun³ qui³ rá¹juáh³ ñí¹ Sí² quioh²¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Cun³quionh³ jáɨ¹³ nɨ́² ca³lɨ³hnió³ Jesús juáh³ hi³ né³bí¹ hen³ tsú² Jmɨ́²chí³ Chun¹ la³jɨ́n³² tsá² taunh² dí² ta²¹; quí¹ tiá² hin² jmɨ́¹ má²ca³hián¹³ yáh³ Jmɨ́²chí³ Chun¹ jmɨ́¹jáun², quí¹hliá² tiá² jmɨ́¹ má²ca³lɨ³ lin¹ yáh³ hi³ quien² Jesús jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jmɨ́¹ ca³náɨ³² ma³ jan² tsá² jmɨ́¹ tionh¹ ja¹ tsá² juóun³² hí³ jáɨ¹³ nɨ́² né³, ca³juáh³ la³ lá²: ―Tson² bíh¹ cu³tí³ tsá² nɨ́² lɨ́n³ *tɨ³² jë¹ Dió³² tsá² qui³ ca³tɨ²¹ já³². ");
INSERT INTO csoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hi³ ma³ jan² tsáu² né³ ca³juáh³ la³ lá²: ―Tsá² nɨ́² bíh¹ Tsá² lɨ́n³ Cristo. Tɨ³la³ ma³ jan² siáh³, ca³juáh³ la³ lá²: ―Tiá² tson² yáh³, quí¹ ¿ha³ bí¹ lánh³ rón³² hi³ tɨ³ hué¹³ Galilea lɨ́¹ já²¹ tiá³ Tsá² lɨ́n³ Cristo? ");
INSERT INTO csoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Quí¹ ñí¹ Sí² rá¹juáh³, hi³ Cristo ca³tɨ²¹ lɨ́n¹³ jan² Tsá² jón²zɨ́h¹ jón²cho¹ hla¹ re²¹ Dá²vi²¹ bíh¹, hi³ já¹ juú² Belén ñí¹ ca³lɨ³zian² hnga² hla¹ Dá²vi²¹ bíh¹ lɨ³zian² tsú² siáh³ uá²jaɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hi³ jáun² né³, la³ nɨ́² bíh¹ lɨ³ hi³ ca³ta³ná¹tsoh³ tsáu² cun³ñí¹ hi³ ca³tɨn¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma³ jan² tsáu² jmɨ́¹ hnió³ hi³ jan³ dí² tson³, tɨ³la³ hí¹ jan² yáh³ tiá² hin² ca³tia³ tsɨ́³ hi³ tie³ cuo². ");
INSERT INTO csoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jáun² né³, ja³tanh²¹ bíh¹ siáh³ tsá²cuú² tsá²ta³ mí²tsáu² tɨ³ ñí¹ tionh¹ tsá² fariseos quionh³ tsá² ná¹lɨ́n³ mi³jmú³, jáun² tsá² hí³ né³ ca³ngáɨh³ tsá²cuú² tsá²ta³ hí³ la³ lá²: ―¿He³ láɨh³² tiá² lɨ́²jan³² náh² tsú²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Hi³ jáun² tsá²cuú² tsá²ta³ tsú² hí³ né³ ca³ngáɨ³ la³ lá²: ―¡Hí¹ jan² yáh³ tiá² hin² má²ca³hléh³ la³jmɨ́¹ hleh³² tsá² ó³²! ");
INSERT INTO csoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jáun² tsá² fariseos ca³juáh³ siáh³: ―¿Hí¹ ja³bí¹ hnoh² uá²jaɨ³² má²ca³lɨ³can² náh²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Hí¹ zian² ma³ jan² tsá² chín¹ joh² dí², jɨ³ lɨ³ua³ jan² jnoh¹ tsá² fariseos hi³ má²ca³hín¹³ jë¹ tsá² hí³ dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tɨ³la³ tsá² tiá² ná¹cuoh² ó³² liei²¹ má¹ná¹, má²ca³tɨn¹ tsa³tánh¹ quiu³juóu³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jáun² Nicodemo, jan² tsá² lɨ́n³ fariseo quionh³ tsú², tsá² ca³ñí¹jɨen¹³ hí³ Jesús cáun² já¹niéi² ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Haun¹³ juáh¹³ ñí¹ liei²¹ quiú¹³ dí² rá¹juáh³ hi³ tiá² ca³ta¹ yáh³ dí² hi³ cáun² lɨ́¹ má¹tson¹³ dí² jan² tsáu² ta³ tiá² lin¹ jú¹ tson² má²lɨ́²cán¹³ dí² quioh²¹ tsú²? ");
INSERT INTO csoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Hi³ jáun² tsá² ñí¹ hná¹ jáun² né³ ca³ngáɨ³ la³ lá²: ―¿Hí¹ tsá² Galilea hniu³² uá²jaɨ³² dúh¹? Sá¹nɨ́² dúh¹ hí³ ñí¹ Sí², hi³ jáun² má¹jáun² jɨeh²¹ nú² hi³ hí¹ jan² yáh³ tsá² lɨ́n³ tɨ³² jë¹ Dió³² tiá² cuá²han³ tɨ³ hué¹³ Galilea. ");
INSERT INTO csoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jmɨ́¹ lɨ²¹ jáun² né³, ma³ quin³² ma³ jan³² bíh¹ tsú² já¹tanh²¹ cú²jueh³² hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hi³ jáun² né³, jmɨ́¹ lɨ²¹ jáun² ngau³ Jesús tɨ³ máh³ Olivos. ");
INSERT INTO csoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hi³ jáun² jmɨ́¹ cá¹jniá²¹ jáun² né³ cuanh³ hú²niéi² ta³ ná¹juan³² hñu³ cuáh³² chín¹. Jmɨ́¹jáun² né³ ca³cuú² ca³ngɨh³² ca³la³ jɨ́n³² tsáu² cu³ jéin³ ñí¹ zenh¹ tsú², hi³ jáun² ca³cuá³ dí², hi³ ca³ma³liáu³² hi³ má²tɨn² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jmɨ́¹jáun² cua³taunh²¹ tsá² ná¹lɨ́n³ tɨ³² liei²¹ quionh³ tsá² *fariseos, hi³ ná¹jan² jan² tsá²mɨ³ tsá² ca³ñí¹zianh¹³ dí² ñí¹ jmɨ́¹ cuá¹jmu² tso³. Jáun² ca³zinh³ dí² ja¹ quioh²¹ tsá² tionh² hí³ ta³ ñí¹ Jesús; ");
INSERT INTO csoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Hnú² Tɨ³², tsá²mɨ³ lá² má²ca³jáun³ jnoh¹ ñí¹ jmɨ́¹ cuá¹jmu² tso³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Né³² né³, ñí¹ liei²¹ quioh²¹ hla¹ Moisés jmu² héih³² ñí¹con² jnoh¹ hi³ hniáuh³² jngɨh¹³ jnoh¹ tsá²mɨ³ la³ nɨ́² hi³ jlan¹ jnoh¹ quɨ́n¹. ¿Hi³ hnú² né³, he³ lánh³ juáh³ nú²? ");
INSERT INTO csoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","La³ nɨ́² ca³juáh³ tsá² hí³ quí¹ hi³ ca³lɨ³hnió³ tsú² hi³ ca³ hi³ lan³ Jesús, hi³ jáun² la³ jáun² lɨ́¹³ chá³² dí² tsáu¹³ tsú². Tɨ³la³ Jesús má¹ná¹, ca³cuá³ cuá¹hin³ hi³ cuá¹jmu² cú²jueh³² huéh³ ja¹ hliáu² cun³quionh³ zeih²¹ cuo². ");
INSERT INTO csoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tɨ³la³ la³ má²ná¹nga² jáun² bíh¹ tsá² hí³ la³ jáun², hi³ jáun² Jesús ca³jmú³ zenh² hi³ ca³juáh³ la³ lá²: ―Hnoh², lɨ³ua³ jan² tsá² tiá² tso³ ren² náh², tiáun² náh² cá² máɨ³ quɨ́n¹ la³ñí¹ hi³ jnah²¹ tsá²mɨ³ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jmɨ́¹jáun² ca³cuá³ siáh³ cuá¹hin³ hi³ ca³jmú³ siáh³ huéh³ ja¹ hliáu². ");
INSERT INTO csoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tɨ³la³ jmɨ́¹ ca³náɨ³² tsá² hí³ jáɨ¹³ nɨ́² né³, ma³ quin³² ma³ jan³² bíh¹ ca³huén² cheih³², quí¹hliá² ca³lɨ³lieih²¹ tsɨ́³ hi³ la³ ná¹ren² bíh¹ uá²jaɨ³² tso³ hmóu³²; tsá² má²lieih²¹ tín² ca³ma³liáu³² hi³ huen³², hi³ jáun² jmɨ́¹ má²ca³huén² tsú² jáun² la³jɨ́n³² né³, hnga² bíh¹ Jesús ca³ta³cua¹³ quionh³ tsá²mɨ³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hi³ jáun² jmɨ́¹ lɨ²¹ jáun² ca³náu² Jesús, hi³ ca³jɨ́e³ hi³ tiú²uú² hin² zian² yáh³, jɨ́³²la³ hnga² tsá²mɨ³ bíh¹ jéi³²í¹ cuá³, hi³ jáun² ca³záɨh³ dí² tsá²mɨ³ hí³ la³ lá²: ―Hnú² tsá²mɨ³, ¿né² dá² tsá² jmɨ́¹ cha³² tsáuh³ hnú²? ¿Hí¹ hí¹ jan² uá¹ tiú²uú² hin² lɨ́²ra³tsa² hnú² héih³²? ");
INSERT INTO csoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Jáun² tsá²mɨ³ né³ ca³ngáɨ³: ―Ján¹han²¹ Tɨ³², hí¹ jan² yáh³. Hi³ jáun² Jesús né³ ca³juáh³ siáh³: ―Sa³jun³ jná¹³ yáh³ rá¹tsa² ná¹ héih³²; né³² né³, cuánh², ha³ lɨ́²uú² cua³jmu³ siáh³ tso³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús ca³liéinh³² siáh³ tsáu² hi³ ca³juáh³ la³ lá²: ―Jná¹³ bíh¹ lɨ́n³ ná¹ joh¹ sɨ́² ñí¹con² tsá² zian² hngá¹máh³ lá²; hi³ nɨ́¹juáh³ tsá² ja³² cu³hna³² jná¹³ né³, hi³ jáun² hí¹ cónh³ yáh³ tiá² ngɨ́³² tsú² ñí¹ lɨ́³ já¹niéi², quí¹ lɨ³ zia³² bíh¹ joh¹ ñí¹con² tsú² hi³ jmu³ hi³ cu³tí³ lɨ́¹³ zian² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jáun² tsá² fariseos ca³juáh³ la³ lá²: ―Hnú² dá² cáun² lɨ́¹ cueh³² jú¹ tson² quián¹³ huen² bíh¹, tiá² lɨ́¹³ yáh³ hi³ lɨ³ tson² jëh² hnú² nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jmɨ́¹jáun² ca³ngáɨ³ Jesús: ―Quien² bíh¹ jú¹ tson² hi³ zíh²³ jná¹³ lá², uá¹jinh¹ huen² bíh¹ jná¹³ zíh²³ jú¹ tson² lá². Quí¹ jná¹³ bíh¹ ño¹ hi³ ha³ jinh¹ ja³ ná¹ hi³ ha³ jinh¹ ñih²¹ ná¹ siáh³; tɨ³la³ hnoh² né³ tiá² ñíh¹ yáh³ náh² ha³ jinh¹ ja³ jná¹³ hi³ ha³ jinh¹ ñih²¹ jná¹³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Quí¹ hnoh² dá² ra³tsɨh³² náh² héih³² la³ cun³ qui³ jmu² tsá² zian² ñí¹ hué²¹ lá² bíh¹. Tɨ³la³ jná¹³ má¹ná¹, hí¹ jan² yáh³ tsáu² tiá² ra³tsɨ³² jná¹³ héih³² la³ jáun² ñí¹con²; ");
INSERT INTO csoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","tɨ³la³ nɨ́¹juáh³ hi³ ra³tsɨ³² jná¹³ héih³², rá²tsɨ³² jná¹³ cú²tso² bíh¹, quí¹ jun³juáh¹³ huen² yáh³ jná¹³ ra³tsɨ³² héih³², quí¹ Ñuh³² jná¹³ Tsá² ca³ze³ bíh¹ rá²tsɨ³² héih³² cu³lɨ²¹ quiúnh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Há¹ jun³juáh¹³ ñí¹ liei²¹ quián¹³ hnoh² rá¹juáh³ hi³ nɨ́¹juáh³ ná¹lɨ́³ gon³ tsá² nau³² jáɨ¹³ hi³ juáh³ cá²ren² tán¹, jáun² bí¹ hniáuh³² táunh¹³ dí² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Né³² né³, huen² bíh¹ jná¹³ lɨ́n³ ná¹ jan² tsá² nau³² jáɨ¹³ hi³ ca³tɨn¹ ná¹ huen², hi³ jáun² Ñuh³² jná¹³ Tsá² ca³ze³ né³ lɨ́n³ siáh³ cónh³í¹ jan² tsá² nau³² jáɨ¹³ hi³ ca³tɨn¹ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hi³ jáun² tsá² hí³ né³ ca³ngáɨ³ la³ lá²: ―¿Jinh¹ dá² cuá³ ñeh² hnú² dúh¹? Jáun² Jesús né³ ca³ngáɨ³: ―Ha³ tiá² cuóu³² yáh³ hnoh² jná¹³, hi³ sa³jun³ cuóun³² yáh³ náh² Ñuh³² jná¹³ siáh³; quí¹ sá¹jmɨ́¹ hi³ cuóu³² náh² jná¹³ dúh¹, hi³ jáun² jmɨ́¹ má²cuóun³² bíh¹ náh² siáh³ Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús ca³hléh³ jáɨ¹³ nɨ́² tá¹la³ jmɨ́¹ dí¹má²tɨn² tsáu² hñu³ cuáh³² chín¹, ñí¹ jmɨ́¹ ná¹táun³ jáun² cuó² ñí¹ toh² tsáu² quɨe³. Tɨ³la³ hí¹ jan² yáh³ tiá² hin² ca³ma³tsau¹³ tsú², quí¹hliá² tiá² jmɨ́¹ má²cá²chó³² yáh³ jmáɨ¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús ca³juáh³ siáh³ cónh³ la³ lá²: ―Jná¹³ dá² ñih²¹ bíh¹, hi³ jáun² má¹jáun² né³ hnauh¹³ náh² jná¹³, tɨ³la³ hnoh² né³ hiá¹ tsán¹³ bíh¹ náh² ta³ ná¹quiánh¹ náh² jáun² tso³ quián¹³; quí¹ ñí¹ ñih²¹ jná¹³ jáun² dá², ha³ tiá² lɨ́¹³ yáh³ cuá¹tianh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Hi³ jáun² tsá² *judíos tsá² ná¹ñí¹ hí³ né³ ca³juáh³: ―¿Hí¹ jngɨ́h³² tsú² hnga² juáh¹³ hi³ jáun² sa³ la³ nɨ́² yáh³ juáh³ tsú² hi³ tiá² lɨ́¹³ tsáu¹³ jnoh¹ ñí¹ tsánh²¹ dí²? ");
INSERT INTO csoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jáun² ca³záɨh³ siáh³ Jesús tsá² hí³ la³ lá²: ―Tɨ³ la³ hué³² lá² bíh¹ hɨ́n¹³ hnoh², tɨ³la³ jná¹³ né³, hɨ́n¹³ ná¹ tɨ³ hñu³mɨ³cuú² bíh¹. Hnoh² dá² cáun² zian² náh² la³ cun³ tɨn² honh² náh² hmóu³² bíh¹; tɨ³la³ jná¹³ né³, ha³ tiá² zian² yáh³ jná¹³ la³ cun³ tɨn² tsɨn³² huen². ");
INSERT INTO csoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Hi³ jáun² bíh¹ lɨ́²juáh³² jná¹³ hi³ hnoh² hiá¹ tsán¹³ náh² ta³ ná¹quiánh¹ náh² jáun² tso³ quián¹³; quí¹ nɨ́¹juáh³ tiá² táunh²³ yáh³ hnoh² ta²¹ hi³ jná¹³ bíh¹ la³², hi³ jáun² dá² hiá¹ tsán¹³ bíh¹ hnoh² ta³ ná¹quiánh¹ la³ jáun² tso³ quián¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Hi³ tsá² hí³ né³ ca³juáh³ la³ lá²: ―¿Hin² dá² tsánh² hnú²? Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―La³ñí¹ tín² nga² jná¹³, ¿hí¹ lɨ³ quien² hi³ juoh²¹ dí² hliáun³ jáɨ¹³ quiúnh¹ tsá² la³ hnoh² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Quí¹ zia³² bí¹ siáh³ hliáun³ lɨ́n³² jáɨ¹³ hi³ jmɨ́¹ lɨ³ juah²¹ jná¹³ hi³ ca³tɨn¹ hnoh², jɨ³ hi³ jmɨ́¹ cué²¹ jáɨ¹³ hi³ rá¹tsa² jná¹³ hnoh² héih³². Tɨ³la³ Tsá² ca³ze³ jná¹³ má¹ná¹, jú¹ tson² bíh¹ hleh³²; hi³ jáun² né³, jáɨ¹³ jáun² bíh¹ juo³ jná¹³ tsá² zian² ñí¹ hué²¹ lá², la³ cun³ jáɨ¹³ hi³ má²cá²náɨ³² jná¹³ hi³ hleh³² hí³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Tɨ³la³ tsá² hí³ tiá² ca³ngɨ¹³ yáh³ hi³ Jesús hleh³² hi³ ca³tɨn¹ Jméi² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Hi³ cun³ñí¹ hi³ jáun² bíh¹ ca³juáh³ siáh³ Jesús la³ lá²: ―Nɨ́¹ má¹ca³ziau³ náh² jná¹³ Tsá² lɨ́n³ ná¹ Jon² tsá²mɨ³cuóun² chi³cuú², jáun² má¹jáun² bíh¹ má²lɨ³ ñíh¹³ náh² hi³ tson² bíh¹ jná¹³ la³², hi³ hí¹ cáun² yáh³ tiá² hi³ jmu² jná¹³ cun³quionh³ hi³ cháunh²³ chin³² huen², ñí¹ jɨ́²¹la³ ti³ hɨ́e²³ jná¹³ hnoh² la³ cun³ hi³ má²ca³ma³ta² Ñuh³² bíh¹ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Quí¹ Tsá² ca³ze³ jná¹³ zenh² bíh¹ quiúnh¹ jná¹³; tiá² huen² jná¹³ má²ca³zeh³ yáh³ tsú², quí¹ jmáɨ¹ ca³la³ jɨ́³² bíh¹ jmu² jná¹³ la³ cun³ hi³ tɨ³² tsɨ́³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, juóun³² lɨ́n³² bíh¹ tsáu² ca³taunh² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jmɨ́¹jáun² ca³záɨh³ Jesús tsá² judíos tsá² má²ca³hín¹³ hí³ ca³lá² jë¹ tsú² la³ lá²: ―Nɨ́¹juáh³ hi³ cu³tí¹³ zánh¹³ hnoh² tiá³ la³ cun³ jáɨ¹³ hi³ juanh³² jná¹³, hi³ jáun² bíh¹ hú¹tá¹ cu³tí³ má²lɨ́n³ náh² tsá² haɨn²¹ tɨ³ con² jná¹³; ");
INSERT INTO csoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","hi³ jáun² lɨ³ cuɨn² náh² jú¹ tson², hi³ jáun² jú¹ tson² jáun² né³ lɨ́¹³ liáu³². ");
INSERT INTO csoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jáun² tsá² hí³ né³ ca³ngáɨ³: ―Tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹ bíh¹ jnoh¹, hi³ hí¹ cónh³ yáh³ tiá² má²ca³lɨn³ jnoh¹ *tsá² má²dí¹hlánh¹ ñí¹con² hí¹ jan² tsáu². ¿Lánh³ bí¹ rón³² sa³ hnú² ya³ juáh³ hi³ jnoh¹ lɨ́¹³ liáu³? ");
INSERT INTO csoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús né³ ca³juáh³ la³ lá²: ―Jú¹ tson² juo³ jná¹³ hnoh², hi³ la³jɨ́n³² tsá² jmu² tso³ bíh¹ lɨ́n³ tsá² má²dí¹hlánh¹ ñí¹con² tso³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hi³ jan² tsá² má²dí¹hlánh¹ né³, cónh³ tiá² lɨ́¹³ bíh¹ lɨ́n³ hú¹tá¹ jan² tsá² hñú¹³ tsú², tɨ³la³ jon² tsá² hñú¹³ má¹ná¹, tiú²nio² bíh¹ lɨ́n³ jan² tsá² hñú¹³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hi³ jáun² né³, nɨ́¹juáh³ Tsá² qui³ lɨ́n³ hí³ Jon² tsú² la³ liáu³² hnoh², jáun² hú¹tá¹ cu³tí³ liáun³ bíh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Má²ño¹ bíh¹ jná¹³ hi³ hnoh² lɨ́n³ náh² tsá² jón²zɨ́h¹ jón²cho¹ hla¹ Há²bran²¹; tɨ³la³ uá¹ jáun² la³ jáun² né³, cu³ jáun² hnáuh² bíh¹ náh² jngah¹³ jná¹³, quí¹ tiá² chau³² yáh³ jë² jná¹³ la³ tɨ³ hñu³ honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jná¹³ dá² hléh²³ la³ cun³ hi³ má²ca³hɨ́e³ Ñuh³² bíh¹, jáun² ja³bí¹ hnoh² siáh³ jmuh³² la³ cun³ hi³ má²ca³hɨ́e³ ñeh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jáun² tsá² hi³ né³ ca³ngáɨ³ la³ lá²: ―¡Hla¹ Há²bran²¹ bíh¹ jméi² dí¹hio³ ñú¹deh³ jnoh¹! Tɨ³la³ Jesús né³, ca³juáh³ la³ lá²: ―Sá¹jmɨ́¹ hi³ tson² bíh¹ cu³tí³ hi³ jon²zɨ́h¹ tsá² hí³ hnoh², jáun² jmɨ́¹ hniáuh²¹ bíh¹ hi³ jmóuh¹ hnoh² la³ cun³ hi³ ca³jmú³ tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Tɨ³la³ cun³ jáun² hnáuh² bíh¹ hnoh² jngah¹³ jná¹³, uá¹jinh¹ má²lɨ́²juo³ ná¹ hnoh² jú¹ tson² la³ cun³ rón³² hi³ ca³hɨ́e³ jná¹³ Dió³². Tɨ³la³ ¡hí¹ cónh³ yáh³ tiá² ca³jmú³ hla¹ Há²bran²¹ la³ nɨ́² má¹ná¹! ");
INSERT INTO csoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Quí¹ hnoh² dá² jmóuh¹ náh² la³jmɨ́¹ jmu² hnga² ñeh² bíh¹ náh². Jáun² tsá² hí³ né³ ca³ngáɨ³ la³ lá²: ―Jun³juáh¹³ dún² lɨ́¹ zian² yáh³ jnoh¹, jan² tán¹ bíh¹ Dió³² Jméi² jnoh¹ zian². ");
INSERT INTO csoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jmɨ́¹ lɨ²¹ jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―Sá¹jmɨ́¹ hi³ tson² bíh¹ hi³ Dió³² ñeh² hnoh², jáun² jmɨ́¹ má¹hnau¹ bíh¹ hnoh² jná¹³ dúh¹, quí¹ jná¹³ bíh¹ jan² Tsá² ja³ ñí¹con² Dió³², hi³ jáun² lá² zenh² ná¹ ta³ máh¹ hnoh². Quí¹ jun³juáh¹³ lɨ́¹ ca³cháunh¹³ tsɨn³² huen² yáh³ jná¹³ hi³ ja³ ná¹, quí¹ tɨ³la³ Dió³² bíh¹ ca³ze³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Jáun² né³, ¿he³ láɨh³² sa³ tiá² ngɨ²³ hnoh² la³ cun³ hi³ juah³² jná¹³ juáh¹³? Quí¹ cun³ñí¹ hi³ tiá² tion²³ hnoh² honh² hi³ náɨh¹ jú¹ chú³² hi³ hléh²³ lá² jná¹³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Quí¹ tsá² hláɨnh¹ bíh¹ ñeh² hnoh²; hi³ jáun² la³ cun³ hi³ dí¹quiaunh²¹ tsɨ́³ hí³ bíh¹ hnáuh² hnoh² jmúh¹³. Quí¹ qui³ cónh³ jan² tsá² jngɨh² tsáu² bíh¹ tsá² hláɨnh¹ ca³la³ cun³ jmɨ́¹ ca³lɨ³liau³; hí¹ cónh³ yáh³ tiá² jmu² tsú² la³ cun³ lɨ́³ jú¹ tson², quí¹ tiá² jú¹ tson² hu²¹ yáh³ hñu³ tsɨ́³ tsú². Hi³ jáun² nɨ́¹ má¹ca³hléh³ tsú² jú¹ tɨ́¹jáɨ², cáun² hleh³² tsú² la³ cun³ rón³² lɨ́n³ bíh¹; quí¹ qui³ cónh³ hí³ bíh¹ jan² tsá² tɨ́¹ jáɨn², hi³ jáun² hí³ bíh¹ lɨ́n³ mí¹zioh²¹ jú¹ tɨ́¹jáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Tɨ³la³ cun³ñí¹ hi³ jná¹³ hléh²³ jú¹ tson² né³, hi³ jáun² tiá² ta²¹ táunh²³ yáh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Hin² tsánh² lɨ³ua³ jan² hnoh² lɨ́¹³ má¹jnia¹³ náh² cáun² tso³ quion²¹ jná¹³ juáh¹³? Né³² né³, nɨ́¹juáh³ jú¹ tson² bíh¹ la³ hléh²³ jná¹³, jáun² ¿he³ láɨh³² sa³ tiá² ta²¹ táunh²³ yáh³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Quí¹ nɨ́¹juáh³ tsá² tionh² jo³cuo² Dió³², jáun² tsá² la³ hí³ náɨ³² bíh¹ jáɨ¹³ quioh²¹ Dió³²; tɨ³la³ hnoh² má¹ná¹ tiá² hnáuh² yáh³ hnoh² náɨh¹, quí¹ jun³juáh¹³ tsá² joh¹ Dió³² yáh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Hi³ jáun² tsá² judíos hí³ ca³juáh³ la³ lá²: ―Tson² bí¹ la³ má²ca³juáh¹³ jnoh¹ jáun² hi³ jan² tsá² lín¹ tsá² Samaria bíh¹ hnú², hi³ ján³ nú² siáh³ jan² jmɨ́²chí³ hláɨnh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jáun² Jesús ca³ngáɨ³ la³ lá²: ―Hí¹ jan² yáh³ jmɨ́²chí³ hláɨnh¹ tiá² ján³ jná¹³. Jná¹³ dá² ma³quien¹³ ná¹ Ñuh³² bíh¹; tɨ³la³ hnoh² né³, huen³ cu³tí¹³ bíh¹ jná¹³ jmuh³² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jun³juáh¹³ hi³ dí¹quian¹ yáh³ jná¹³ hi³ ma³quien² tsáu²; tɨ³la³ zian² jan² Tsá² hnió³ bíh¹ hi³ lɨ³ quien² jná¹³, hi³ Tsá² hí³ né³ rá²tsɨn² héih³² tsá² hau² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jú¹ tson² bí¹ juo³ jná¹³ hnoh², hi³ nɨ́¹juáh³ tsá² cán²³ re² la³ cun³ jáɨ¹³ hi³ juah³² jná¹³, jmɨ́¹lɨ́h³ bíh¹ tiá² jún³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Hi³ jáun² tsá² judíos hí³ né³ ca³juáh³ la³ lá²: ―Ta³né³² tɨ³ jlánh¹ cáun² má²nio² bíh¹ tsɨ́³ jnoh¹ hi³ tson² bíh¹ ján³ hnú² jmɨ́²chí³ hláɨnh¹. Quí¹ jun³ bíh¹ hla¹ Há²bran²¹ la³ má²quionh³ la³jɨ́n³² tsá² ca³lɨn³ *tɨ³² jë¹ Dió³²; tɨ³la³ hnú² né³ juáh³: “Nɨ́¹juáh³ tsá² cán²³ re² la³ cun³ jáɨ¹³ hi³ juah³² jná¹³, jmɨ́¹lɨ́h³ bíh¹ tiá² jún³”. ");
INSERT INTO csoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Hí¹ tɨ³ jlánh¹ bíh¹ quien² hnú² la³cónh³ bíh¹ hla¹ Há²bran²¹ jméi² dí¹hio³ ñú¹deh³ jnoh¹? Quí¹ hí³ dá² jun³ bíh¹, hi³ ca³tsan³ bí¹ siáh³ tsá² ca³lɨn³ tɨ³² jë¹ Dió³². ¿Hin² ma³ dá² tsánh² hnú² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jáun² Jesús ca³ngáɨ³ siáh³ la³ lá²: ―Nɨ́¹juáh³ jná¹³ la³ ma³quien¹³ ná¹ huen², hi³ jáun² tiá² lin¹ ñí¹ lɨ³ quien² hí¹ cáun² yáh³ hi³ jáun². Tɨ³la³ Ñuh³² bíh¹ jná¹³ jmu² quien² jná¹³, Tsá² juáh³ hnoh² hí³ hi³ lɨ́n³ Dió³² Juóuh³² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tɨ³la³ tiá² má²ca³lɨ³ cuóun³² yáh³ hnoh² tsú² má¹ná¹. Jná¹³ bíh¹ ján¹ tson² cuóun³² tsú²; hi³ sá¹jmɨ́¹ hi³ juanh²¹ jná¹³ hi³ tiá² cuóun³² ná¹ tsú², jáun² la³ jáun² má²lɨ́n³ jná¹³ jan² tsá² tɨ́¹ jáɨn² la³ hnoh² bíh¹. Tɨ³la³ hú¹tá¹ tson² bíh¹ cuóun³² jná¹³ tsú² má¹ná¹, jɨ³ hi³ ma³ti²¹ jná¹³ siáh³ la³jɨ́³² hi³ juáh³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Hla¹ Há²bran²¹ dí²hio³ ñú²deh³ hnoh² hí³ ca³lɨ³ tsah³ lɨ́n³² quí¹hliá² jɨ́e³ jmáɨ¹ hi³ cuán¹³ jná¹³; ca³jɨ́e³ bí¹ tsú², hi³ jáun² ca³lɨ³ hiún² lɨ́n³² tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jmɨ́¹jáun² ca³juáh³ siáh³ tsá² judíos hí³ la³ lá² ñí¹con² Jesús: ―¡Ca³la³ hí¹juáh³ tu³la³quia³ mii² yáh³ tiá² má²hún¹ hnú², sa³ hnú² yáh³ jlánh¹ juáh³ hi³ ca³jɨen¹ máh³ hnú² hla¹ Há²bran²¹! ");
INSERT INTO csoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jáun² Jesús ca³záɨh³ siáh³ tsá² hí³ la³ lá²: ―Jú¹ tson² cu³tí¹³ bíh¹ la³² juo³ jná¹³ hnoh², hi³ la³ cun³ jmɨ́¹ ñeh² bí¹ hi³ lɨ³zian² hla¹ Há²bran²¹ máh³, jmɨ́¹ má²zian² bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Hi³ jáun² tsá² hí³ ca³can³ quɨ́n¹ hi³ jnah³ Jesús; tɨ³la³ Jesús, ha³ tiú²uú² ca³jnia³ yáh³, jáun² cua³han³ hñu³ cuáh³² chín¹ hi³ ca³nga² ja¹ ñí¹ tionh¹ tsá² hí³, hi³ ngah³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hi³ jáun² né³, tá¹la³ hí¹hún¹ jáun² Jesús juɨ³² hi³ má²cuá²han³ cuáh³², ca³jɨ́en³² dí² jan² tsá²ñuh² qui³ má²te³ ñí¹ la³ cun³ jmɨ́¹ ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, ca³ngáɨ³ ñí¹con² dí² hi³ ca³juáh³: ―Tɨ³², ¿he³ láɨh³² sa³ ten³ yáh³ tsá²ñuh² nɨ́² ca³lɨ³zian²? ¿Hí¹ cun³ñí¹ hi³ tsáu¹³ jméi² mí¹ziú¹³ tsú² juáh¹³, ho³ cun³ñí¹ hi³ tsáu¹³ hnga² uá¹? ");
INSERT INTO csoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jáun² Jesús né³ ca³ngáɨ³: ―Jun³juáh¹³ tsáu¹³ hnga² yáh³ tsú² hi³ ten³, hi³ sa³jun³ tsáu¹³ jméi² mí¹ziú¹³ tsú² siáh³; la³ nɨ́² dá² ca³lɨ³ hi³ jáun² lɨ³jnia² he³ tɨn² Dió³² jmu³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Hniáuh³² bíh¹ jmú¹³ dí² tá¹³ Tsá² ca³ze³ jná¹³ tá¹la³ jniá³, quí¹ nɨ́¹juáh³ nɨ́¹ má¹ca³zɨ³², jáun² hí¹ jan² yáh³ tiú²uú² hin² lɨ́¹³ jmu³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Quí¹ tá¹la³ cuon¹ jná¹³ lá² hngá¹máh³ lá², lɨ́n³ jná¹³ joh¹ sɨ́² quioh²¹ tsá² zian² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Hi³ jáun² jmɨ́¹ má²lɨ́²juáh³ Jesús la³ nɨ́² né³, ca³hñe³ hué³², hi³ ca³jmú³ cú¹pih²¹ jen² quionh³ mí¹héh³² quioh²¹, hi³ jáun² ca³yóh³ dí² mɨ́¹ñí¹ tsá² ten³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jáun² la³juɨ³² ca³záɨh³ dí² tsá² hí³ la³ lá²: ―Cua³², cuá²ráɨn² máh¹ tɨ³ ñí¹ nio¹ jmɨ́²táu² jmáɨ² Siloé (hi³ hnió³ juáh³ “Tsá² zéin¹”). Jáun² ngau³ bíh¹ tsá² ten³ hí³ hi³ ca³ñí¹ráɨn¹³ ñí¹ ñí¹ jáun², hi³ jáun² né³ jmɨ́¹ cá¹jính²¹ jáun² má²jniá³ ñí¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hi³ jáun² tsá² cuu³ tsá² jéin³ hñú¹³ tsú² ca³juu³ ca³hlénh³, la³ má²quionh³ tsá² jmɨ́¹ má²ca³jɨ́e³² hí³ hi³ lɨ́¹ mɨ³² tsú² cú¹dáɨn³ ñí¹con² tsáu² jmɨ́¹tin², hi³ ca³juáh³ la³ lá²: ―¿Há¹ jun³juáh¹³ tsá² nɨ́² tsá² jmɨ́¹ cua³² ñí¹ jáun² hi³ jmɨ́¹ mɨ³² cú¹dáɨn³ jmɨ́¹tin² juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jáun² ma³ jan² tsáu² ca³juáh³: ―Ján³, tsá² hí³ bí¹ nɨ³². Hi³ ma³ jan² né³ ca³juáh³ siáh³: ―Ján¹han²¹, jun³juáh¹³ tsá² hí³ yáh³ nɨ³², uá¹jinh¹ jniá³ la³ jáun². Tɨ³la³ hnga² tsú² né³, ca³juáh³ la³ lá²: ―Ján³, jná¹³ bíh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jmɨ́¹jáun² né³, ca³ngáɨh³ dí² tiáunh¹ la³ lá²: ―¿Ha³ bí¹ lánh³ rón³² ca³niá³ máh¹ nú² hi³ jáun² má²lɨ́²³ jɨe¹ nú² ta³né³²? ");
INSERT INTO csoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Hi³ jáun² tsá² hí³ né³ ca³ngáɨ³, hi³ ca³juáh³: ―Tsá²ñuh² Tsá² jmáɨ² hí³ Jesús bíh¹ lɨ́²jmú³ jen², hi³ jáun² lɨ́²yóh³ tsú² mɨ́¹ñi³² jná¹³, jáun² lɨ́²juáh³ la³ lá²: “Cua³² tɨ³ ñí¹ nio¹ jmɨ́²táu² jmáɨ² Siloé, ñí¹ jáun² cuá²ráɨn² máh¹”. Jáun² cuá²ñéi¹ jná¹³, hi³ jáun² jmɨ́¹ má²lɨ́²ráɨn³² jná¹³ jáun² mɨ́¹ñi³² né³, ca³niá³ bíh¹ hi³ ca³lɨ³ jɨe¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Hi³ jáun² ca³ngáɨ³ siáh³ tsáu² ñí¹con² tsá² jmɨ́¹ ten³ hí³ la³ lá²: ―¿Né² dá² tsá² hí³ né³? Jáun² tsá² jmɨ́¹ ten³ hí³ né³ ca³juáh³: ―Tiá² ño¹ nia²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jmɨ́¹jáun² ca³ñí¹jan² tsú² tsá² jmɨ́¹ ten³ hí³ tɨ³ ñí¹con² tsá² *fariseos; ");
INSERT INTO csoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","quí¹ *jmáɨ¹ nio² tie³ bíh¹ jaun³² jmɨ́¹ ca³jmú³ Jesús jen² hi³ ca³jñéi³ mɨ́¹ñí¹ tsá² jmɨ́¹ ten³ hí³, hi³ jáun² lan³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jáun² tsá² fariseos né³, ca³ngáɨ³ siáh³ ñí¹con² tsá² hí³ hi³ he³ lánh³ rón³² ca³niá³ mɨ́¹ñí¹, hi³ jáun² má²jɨ́e³². Jmɨ́¹jáun² ca³juáh³ tsá² jmɨ́¹ ten³ hí³ la³ lá²: ―Jen² bíh¹ lɨ́²jñéi³ tsú² mɨ́¹ñi³² jná¹³, hi³ jáun² lɨ́²ráɨn³² jná¹³, hi³ jáun² bíh¹ má²jniá³ mɨ́¹ñi³² jná¹³ ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ ma³ jan² tsá² fariseos la³ lá²: ―Jun³juáh¹³ tsá² ja³ ñí¹con² Dió³² yáh³ tsá²ñuh² tsá² lɨ́²jmú³ hi³ nɨ́², quí¹ jáun² sa³ tiá² ta²¹ tanh² yáh³ tsú² jmáɨ¹ nio² tie³. Tɨ³la³ ma³ jan² tsá² fariseos hí³ né³ ca³juáh³: ―¿He³ bí¹ lánh³ rón³² lɨ́¹³ jmu³ tsú² li²¹ hi³ lɨ́³ hua³jueh³² nɨ́², nɨ́¹juáh³ jan² tsá² ren² tso³ bí¹ lánh³? Jáun² la³ nɨ́² bíh¹ lɨ³ hi³ ca³ta³ná¹tsoh³ ja¹ quioh²¹ tsú² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Hi³ jáun² ca³ngáɨh³ tsú² siáh³ tsá² jmɨ́¹ ten³ hí³ la³ lá²: ―Hi³ hnú² né³, ¿he³ lánh³ juáh³ nú² hi³ ca³tɨn¹ tsá²ñuh² tsá² lɨ́²niá³² hí³ mɨ́¹máh¹ nú²? Jáun² tsá² hí³ né³ ca³juáh³: ―Jná¹³ len³ hi³ tsá² hí³ bíh¹ lɨ́n³ jan² *tɨ³² jë¹ Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jáun² tsá² *judíos tsá² ná¹ñí¹ tiá² ta²¹ ca³taunh³ yáh³ hi³ tson² jmɨ́¹ ten³ tsá² hí³, hi³ né³² né³ má²ca³niá³ ñí¹; ca³la³ ñí¹ ca³teh³ dí² jméi² mí¹ziú¹³ tsá² hí³, ");
INSERT INTO csoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","hi³ ca³ngáɨh³ dí² la³ lá²: ―¿Hí¹ tsá² lá² jónh³² hnoh², tsá² juáh³ hnoh² hi³ má²ten³ jmɨ́¹ ca³lɨ³zian²? ¿Ha³ lánh³ rón³² má²ca³niá³ mɨ́¹ñí¹ tsú² ta³né³² né³? ");
INSERT INTO csoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jáun² jméi² mí¹ziú¹³ tsá² hí³ ca³ngáɨ³ la³ lá²: ―Né¹ bíh¹ jnoh¹ hi³ jon² jnoh¹ tsá² nɨ́², hi³ tson² bíh¹ má²ten³ tsú² jmɨ́¹ ca³lɨ³zian²; ");
INSERT INTO csoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","tɨ³la³ tiá² né¹ jnoh¹ má¹ná¹ he³ lánh³ rón³² lɨ³ hi³ má²ca³niá³ mɨ́¹ñí¹ tsú² ta³né³², hi³ sa³jun³ né¹ jnoh¹ siáh³ hin² tsánh² lɨ́²jmú³ hi³ ca³niá³ mɨ́¹ñí¹ tsú². Ngáɨh³ dúh¹ tsú² hnga² neh²¹; quí¹ tsá² má²hún¹ tsɨ́³ bíh¹ nɨ³², hi³ jáun² hnga² bíh¹ tsú² má²lɨ́¹³ cué³² jú¹ tson² ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","La³ nɨ́² ca³juáh³ jméi² mí¹ziú¹³ tsú² quí¹ cun³ñí¹ hi³hliá² jmɨ́¹ juénh², quí¹hliá² tsá² judíos tsá² ná¹ñí¹ jmɨ́¹ má²ca³jmú³ cá²hon³ hi³ chin¹³ dí² cuáh³² lɨ³ua³ jan² tsá² juáh³ hi³ tson² bíh¹ Jesús lɨ́n³ Cristo. ");
INSERT INTO csoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Hi³ jáun² bíh¹ la³ nɨ́² ca³juáh³ jméi² mí¹ziú¹³ tsá² hí³: “Ngáɨh³ dúh¹ tsú² hnga² neh²¹, quí¹ tsá² má²hún¹ tsɨ́³ bíh¹ nɨ³²”. ");
INSERT INTO csoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jáun² tsá² ná¹ñí¹ hí³ ñí¹con² tsá² judíos ca³teh³ siáh³ tsá² jmɨ́¹ ten³ hí³, hi³ ca³záɨh³ dí² la³ lá²: ―Juah²¹ jú¹ tson² ñí¹con² jnoh¹ ñí¹ ta³ ñí¹ Dió³², quí¹ jnoh¹ né¹ hi³ tsá²ñuh² hí³ dá² jan² tsá² ren² tso³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jmɨ́¹jáun² né³, ca³juáh³ tsá² jmɨ́¹ ten³ hí³ la³ lá²: ―Tiá² ño¹ jná¹³ hí¹ ren² tsú² tso³ ho³ tiá² ren². Ñí¹ jɨ́²¹la³ cun³ hi³ ño¹ jná¹³, hi³ jná¹³ jmɨ́¹ lɨ́n³ jan² tsá² ten³ bíh¹, hi³ ta³né³² né³ má²jɨe¹ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hi³ jáun² ca³ngáɨ³ siáh³ tsá² fariseos la³ lá²: ―¿He³ lɨ́²jmú³ tsú²? ¿Ha³ lánh³ rón³² lɨ́²jmú³ tsú² hi³ ca³jnia³ mɨ́¹máh¹ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jáun² tsá² jmɨ́¹ ten³ hí³ ca³ngáɨ³: ―Má²lɨ́²juáh³² bíh¹ jná¹³, tɨ³la³ tiá² jáɨ¹³ canh³² yáh³ hnoh². ¿He³ láɨh³² hnáuh² hnoh² hi³ juah²¹ jná¹³ siáh³ cónh³? ¿Hí¹ hnáuh² hnoh² hi³ han³ uá²jaɨ³² tɨ³ con² tsú² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jmɨ́¹jáun² ca³jin³ dí² tsá² jmɨ́¹ ten³ hí³, hi³ ca³záɨh³ dí² la³ lá²: ―Hnú² bíh¹ tsá² hen² nú² tɨ³ con² tsá² lín¹ hí³, tɨ³la³ jnoh¹ má¹ná¹, haɨn²¹ jnoh¹ tɨ³ con² hla¹ Moisés bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jnoh¹ né¹ hi³ Dió³² ca³hléh³ ñí¹con² hla¹ Moisés, tɨ³la³ tsá²ñuh² nɨ́² má¹ná¹, ca³la³ hí¹juáh³ tiá² né¹ bíh¹ jnoh¹ ha³ jinh¹ ja³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jáun² tsá² jmɨ́¹ ten³ hí³ ca³záɨh³ tsá² hí³ la³ lá²: ―¡Hen³ ma³ hua³jueh³² lɨ́²³ hi³ hnoh² tiá² la³ ñíh¹ yáh³ náh² hi³ ha³ jinh¹ ja³ Tsá² hí³, tɨ³la³ Tsá² hí³ bíh¹ lɨ́²niá³² mɨ́¹ñi³² jná¹³! ");
INSERT INTO csoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Re² lɨ́n³² bí¹ né¹ dí² hi³ Dió³² tiá² náɨ³² yáh³ jë¹ jan² tsá² ren² tso³; jɨ́³²la³ jë¹ tsá² zian² hi³ ca³tɨn¹ bíh¹ Dió³² náɨ³², lɨ³ua³ jan² tsá² jmu² la³ cun³ hi³ hnió³ tsú² yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hí¹ cónh³ yáh³ tiá² lin¹ má²ca³náɨ¹³ dí² hi³ má²ca³lɨ³zian² jan² tsá² nia³² mɨ́¹ñí¹ tsá² má²ten³ má¹ca³lɨ³zian². ");
INSERT INTO csoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sá¹jmɨ́¹ tson² hi³ Tsá² hí³ tiá² ja³ ñí¹con² Dió³² dúh¹, jáun² hí¹ cáun² yáh³ tiá² hi³ jmɨ́¹ lɨ́¹³ jmu³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jáun² tsá² tionh² hí³ né³ ca³juáh³ siáh³ la³ lá²: ―Hnú² bíh¹ jan² tsá² ca³lɨ³zian² nú² hi³ ren² nú² tso³, ¿hí¹ hnáuh² hnú² má¹ta¹³ nú² jnoh¹? Jmɨ́¹jáun² ca³jmú³ tsú² héih³² ñí¹con² tsá² jmɨ́¹ ten³ hí³ hi³ tiú²uú² hniáuh³² tsó³² tsú² cuáh³². ");
INSERT INTO csoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jáun² né³, jmɨ́¹ ca³lɨ³ ñi³² Jesús hi³ má²lɨ́²jmú³ tsú² héih³² hi³ tiú²uú² tsó³² tsá² jmɨ́¹ ten³ hí³ cuáh³², jáun² ca³ñí¹hniah² dí² tsá² hí³, hi³ jáun² jmɨ́¹ ca³chanh²¹ dí² tsá² jmɨ́¹ ten³ hí³ né³, ca³záɨh³ dí² la³ lá²: ―¿Hí¹ má²lɨ́²cháh¹ hnú² cáun² honh² ñí¹con² Jon² tsá²mɨ³cuóun²? ");
INSERT INTO csoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jáun² tsá² jmɨ́¹ ten³ hí³ ca³juáh³: ―Tɨ³², juah²¹ tiá³ hin² tsánh² Tsá² hí³, hi³ jáun² tanh²¹ jná¹³ tsú² ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jmɨ́¹jáun² ca³ngáɨ³ Jesús la³ lá²: ―Má²lɨ́²jɨen¹ bí¹ nú² tsú², jná¹³ bíh¹ la³² Tsá² dí¹hléh²³ ná¹ quiúnh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hi³ jáun² jmɨ́¹jáun² ca³di³jñí³² tsá² hí³ ta³ ñí¹ Jesús, hi³ ca³juáh³ la³ lá²: ―Taunh³² bíh¹ jná¹³ ta²¹ hnú² Tɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jáun² la³ cun³ jmɨ́¹jáun² ca³juáh³ Jesús: ―Jná¹³ ja³ ná¹ ñí¹ hué²¹ lá² hi³ ja³ra³tsɨ³² ná¹ héih³² hi³ jáun² tsá² ten³ lɨ́¹³ niá³ ñí¹, hi³ jáun² tsá² jniá³ ñí¹ né³ lɨ³ lin¹ hi³ ná¹ten³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hi³ jáun² jmɨ́¹ ca³náɨ³² tsá² fariseos tsá² ma³ jan² jmɨ́¹ tionh¹ hí³ quionh³ tsú² jáɨ¹³ nɨ́² né³, ca³juáh³ la³ lá²: ―¿Hí¹ jáun² la³ ná¹ten³ uá¹ jnoh¹ uá²jaɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Sá¹jmɨ́¹ hi³ tson² bíh¹ ná¹ten³ hnoh², hi³ jáun² tiá² tso³ jmɨ́¹ hauh³² yáh³ náh² ca³tɨ²¹ tso³ quián¹³. Tɨ³la³ cun³ñí¹ hi³ juáh³ náh² hmóu³² hi³ tiá² ten³ ya³ náh², hi³ jáun² dá² hauh³² bí¹ náh² tso³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jmɨ́¹jáun² né³, ca³jmú³ Jesús cáun² jáɨ¹³ la³ lá²: ―Jú¹ tson² cu³tí³ bíh¹ la³² juo³ jná¹³ hnoh², hi³ nɨ́¹juáh³ tsá² tiá² hí²³ tɨ³ ñí¹ lɨ́³ ho³ jnɨ́¹³ quioh²¹ *já¹ziáh², jáun² tsá² la³ hí³ dá² lɨ́n³ jan² háɨn² bíh¹, tsá² lɨ́¹ can²³ jan² jáh³ tiá² joh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Tɨ³la³ tsá² hí²³ tɨ³ juɨ³² ñí¹ lɨ́³ ho³ jnɨ́¹³ má¹ná¹, hnga² tsá² qui³ jmu² hua³hí¹³ já¹ziáh² bíh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jáun² tsá² zenh² ho³ jnɨ́¹³ né³, nia³² ho³ jnɨ́¹³ hi³ jáun² hí³ tsá² hí³; hi³ já¹ziáh² né³ má²cuoh² bíh¹ ho³ juo¹³. Ma³ quin³² ma³ jan³² jáh³ hí³ téh²³ dí² cun³quionh³ hi³ jmáɨ², hi³ huen² dí² tɨ³ cheih³² jnɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hi³ jáun² nɨ́¹juáh³ nɨ́¹ má¹lɨ́²huen³ tsú² la³jɨ́n³² já¹ziáh² hí³ joh¹, tsau³² dí² chí¹ján³ ta³ ñí¹ jáh³ hí³, hi³ jáun² já¹ziáh² hí³ né³ tsá²táunh¹ cu³chin¹ cu³hna²¹ tsá² hí³, quí¹hliá² má²cuoh² bí¹ jáh³ ho³ juo¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Quí¹ cun³ tiá² lɨ́¹ tsá²táunh¹ bíh¹ jáh³ cu³hna²¹ jan² tsá² tiá² cuóun³²; jáh³ hí³ dá² tɨ³ cuon³ bíh¹ ñí¹con² tsá² tiá² má²cuóun³², quí¹ tiá² cuoh² ya³ jáh³ ho³ tsá² siánh³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Tɨ³la³ tsá² jmɨ́¹ ná¹náɨ³² hí³ né³, cun³ tiá² ca³ngɨ¹³ bíh¹ he³ dá² jmɨ́¹ hnió³ Jesús juáh³ cun³quionh³ jáɨ¹³ hi³ má²lɨ́²jmú³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jmɨ́¹jáun² né³ ca³juáh³ siáh³ Jesús la³ lá²: ―Jú¹ tson² bíh¹ juo³ jná¹³ hnoh², hi³ jná¹³ bíh¹ lɨ́n³ ná¹ la³jmɨ́¹ lɨ́³ ho³ jnɨ́¹³ juɨ³² ñí¹ taunh³² já¹ziáh². ");
INSERT INTO csoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","La³jɨ́n³² tsá² cuá²tú¹ cuá¹lɨn³ jmɨ́¹ ñeh² bíh¹ hi³ cuán¹³ jná¹³, tsá² háɨn² bíh¹ hí³, tsá² cáun² lɨ́¹ can²³ jáh³ tiá² joh¹; tɨ³la³ já¹ziáh² né³ tiá² ca³háɨn³² yáh³ tɨ³ con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jná¹³ bíh¹ lɨ́n³ ná¹ la³jmɨ́¹ lɨ́³ ho³ jnɨ́¹³; hi³ jáun² lɨ³ua³ jan² tsá² hí²³ hñu³ jnɨ́¹³ cun³quionh³ jná¹³ né³, lɨ́¹³ liáun³. Tsá² hí³ lɨ́n¹³ la³jmɨ́¹ lɨ́n³ jan² já¹ziáh² hi³ quí² chin² tsú² hñu³ jnɨ́¹³ quioh²¹ hi³ tsa³ñi³jan¹ tsú², hi³ jáun² choh²³ háu² cuh³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","”Tsá² háɨn² dá² ja³² hi³ han³ bíh¹, hi³ ma³tsan² jáh³, hi³ quí² hin²³ la³jɨ́³²; tɨ³la³ jná¹³ má¹ná¹, cuan³ ná¹ hi³ jáun² lɨ́¹³ zian² tsú² cáun² hi³ hmaɨ²¹ bíh¹, jɨ³ hi³ lɨ́¹³ zian² tsú² ca³la³ hi³ lɨ́¹ má²tú² má²ziun²³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jná¹³ bíh¹ lɨ́n³ ná¹ jan² tsá² hú¹tá¹ cu³tí¹³ jmu² hua³hí¹³ já¹ziáh². Tsá² qui³ jmu² hua³hí¹³ cun³ tán¹ já¹ziáh² né³, ca³la³ hi³ chá³² tsú² cáun² tsɨ́³ hi³ jún³ cun³ñí¹ hi³ ca³tɨn¹ já¹ziáh² joh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tɨ³la³ nɨ́¹juáh³ tsá² ti³ lɨ́¹ jmu² ta²¹ hi³ hlánh¹ má¹ná¹, cáun² cuon² bíh¹ tsú² hnga² nɨ́¹ má¹ja³² tsɨ́²náɨ¹ hi³ cunh¹³ já¹ziáh²; cáun² chan² hmóu³² bíh¹ tsú² já¹ziáh², quí¹ tiá² lɨ́n³ yáh³ tsú² jan² tsá² hú¹tá¹ jmu² hua³hí¹³ já¹ziáh², hi³ sa³jun³ joh¹ yáh³ tsú² jáh³. Jáun² tsɨ́²náɨ¹ né³ ja³² hi³ zanh²³ já¹ziáh², hi³ jmu² hi³ lɨ́¹ tiú¹ lɨ́¹ hán¹ tɨ³ hlá² tɨ³ nɨ́² jáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jáun² tsá² la³ hí³ dá² cáun² cuon² bíh¹, quí¹ ñí¹ jɨ́²¹la³ ti³ jmu² tsú² ta²¹ hi³ hlánh¹ bíh¹, hi³ jáun² tiá² hɨ³² yáh³ tsɨ́³ tsú² hi³ ca³tɨn¹ já¹ziáh². ");
INSERT INTO csoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","”Jná¹³ bíh¹ lɨ́n³ ná¹ jan² Tsá² hú¹tá¹ cu³tí¹³ jmu² hua³hí¹³ já¹ziáh². Cuóun³² bíh¹ jná¹³ já¹ziáh² joh², hi³ jáh³ hí³ né³ cuóu³² bí¹ siáh³ jná¹³ ");
INSERT INTO csoNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","la³jmɨ́¹ cuóu²¹ jná¹³ Ñuh³², hi³ jáun² jná¹³ né³ cuóun³² ná¹ Ñuh³²; hi³ jáun² bíh¹ chá²³ jná¹³ cáun² tsɨn³² hi³ jún³ ná¹ hi³ ca³tɨn¹ já¹ziáh². ");
INSERT INTO csoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ja³bí¹ zian² siáh³ já¹ziáh² joh² jná¹³, jáh³ tiá² má²tiáunh¹ hñu³ jnɨ́¹³ lá²; hniáuh³² bíh¹ ñí¹cón²¹ jná¹³ uá²jaɨ³² jáh³ hí³. Hi³ jáun² jáh³ hí³ siáh³ ne³ jáɨ¹³ quion²¹ jná¹³, hi³ jáun² lɨ́¹³ tiáunh¹ cu³tsa³² cáun² hñu³ jnɨ́¹³, hi³ jan² tán¹ bíh¹ Juo¹³ lɨ́¹³ zian². ");
INSERT INTO csoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”Hi³ jáun² bí¹ jlánh¹ hniau³ jná¹³ Ñuh³², quí¹ cun³ñí¹ hi³ chá²³ jná¹³ cáun² tsɨn³² hi³ jún³ ná¹ ca³tɨn¹ jáh³ hí³; hi³ jáun² má¹lɨ³² jáun² né³, jenh¹³ jná¹³ siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hí¹ jan² yáh³ tiá² hin² lɨ́¹³ jngah³ jná¹³, tɨ³la³ cué¹³ jná¹³ jmɨ́²chí³ quion²¹ ca³la³ hi³ hiún² tsɨn³² huen² bíh¹. Quí¹ jná¹³ dá² ho² ná¹ jáɨ¹³ hi³ cué¹³ ná¹ jmɨ́²chí³ quion²¹ jɨ³ hi³ caun²¹ ná¹ nɨ́² siáh³. Hi³ nɨ́² bíh¹ héih³² hi³ ca³cué³ jná¹³ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jmɨ́¹ ca³náɨ³² tsá² *judíos hí³ jáɨ¹³ nɨ́² né³, ca³ta³ná¹tsoh³ siáh³ ja¹ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Quí¹ juóun³² bíh¹ tsá² tionh² hí³ ñí¹ jáun² jmɨ́¹ ná¹juáh²³ la³ lá²: ―¿He³ láɨh³² sa³ naɨh³² máh³ náh² jë¹ tsá² nɨ́²? Já² tsá² ngo² jan² jmɨ́²chí³ hláɨnh¹ bíh¹ nɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tɨ³la³ ma³ jan² tsá² hí³ jmɨ́¹ ná¹juáh²³ la³ lá²: ―Já² hí¹ jan² yáh³ tsá² jan² jmɨ́²chí³ hláɨnh¹ tiá² lɨ́¹³ hléh³² la³ nɨ́². ¿Hí¹ lɨ́¹³ jmu³ jan² jmɨ́²chí³ hláɨnh¹ hi³ niá³ mɨ́¹ñí¹ jan² tsá² ten³ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hi³ jáun² né³, ca³chó³² jmáɨ¹ hi³ jmu² tsá² judíos jmáɨ¹ tɨ³ já¹ juú² Jerusalén ca³tɨ²¹ jmɨ́¹ ca³jmú³ dí¹hio³ ñú¹deh³ tsú² hi³ ná¹chan¹ cuáh³² chín¹ quioh²¹ cónh³í¹ cu³ jéin³² ñí¹con² Dió³²; jmɨ́¹ má²ñí²cuóu³ bíh¹ jmáɨ¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jmɨ́¹jáun² jmɨ́¹ cuá¹ngɨ³² Jesús hñu³ cuáh³² chín¹ ñí¹ lɨ́³ ñí¹hñú³, ñí¹ juáh³ tsú² jáun² “Quioh²¹ Salomón”; ");
INSERT INTO csoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","hi³ jáun² ñí¹ jáun² ca³cuú² ca³ngɨh³² tsá² judíos tsá² ná¹ñí¹ cu³ jéin³ ñí¹ jmɨ́¹ cuá¹ngɨ³² tsú², hi³ ca³záɨh³ dí² la³ lá²: ―¿Lɨ́h³ ma³ hɨ́eh¹ nú² jnoh¹ jú¹ tson²? Juah²¹ cú²na²¹ cu³tí³ nɨ́¹juáh³ tson² bíh¹ hi³ hnú² lɨ́n³ nú² Cristo. ");
INSERT INTO csoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Hi³ jáun² Jesús né³ ca³ngáɨ³ la³ lá²: ―Má²cá²juo³ bí¹ jná¹³ hnoh², tɨ³la³ tiá² ta²¹ táunh²³ yáh³ hnoh². Má²lɨ́²lin¹ bíh¹ re² lɨ́n³² cun³quionh³ la³jɨ́³² hi³ jmu² jná¹³ cun³quionh³ héih³² quioh²¹ Ñuh³²; ");
INSERT INTO csoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","tɨ³la³ tiá² ta²¹ táunh²³ yáh³ hnoh², quí¹ tiá² lɨ́n³ yáh³ hnoh² já¹ziáh² joh² jná¹³, la³ cun³ qui³ má²cá²juáh³² jná¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Quí¹ cuoh² bíh¹ já¹ziáh² joh² jná¹³ uen³², hi³ cuóun³² bí¹ siáh³ jná¹³ jáh³ joh², hi³ jáun² bíh¹ ja³táunh¹ jáh³ cu³hna³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Hi³ jná¹³ né³ jmu¹ hi³ lɨ́¹³ zian² tsá² la³ hí³ la³ cun³ jmɨ́¹hi³nio², hi³ jáun² cun³ tiá² tsa³hín³ bí¹ tsú², hi³ sa³jun³ hí¹ jan² yáh³ tiá² hin² lɨ́¹³ huen³ tsú² jo³uón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Quí¹ Ñuh³² jná¹³ Tsá² ca³cuen³ tsá² hí³ ñí¹con² jná¹³ jan² Tsá² tɨ³ jlánh¹ bí¹ pin³ bíh¹ la³ cónh³ bíh¹ ñí¹ la³jɨ́n³², hi³ jáun² hí¹ jan² yáh³ tiá² hin² lɨ́¹³ quin³ tsá² hí³ jo³cuo² hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Cá²hon³ cu³tí¹³ bíh¹ jnoh¹ tiáuh¹ quiúnh¹ ná¹ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Hi³ jáun² jmɨ́¹jáun² né³ ca³can³ siáh³ tsá² judíos hí³ quɨ́n¹, hi³ jmɨ́¹ jnah³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Hliáun³ bíh¹ ta²¹ chu²¹ má²cá²jmú³² jná¹³ cun³quionh³ pí³ quioh²¹ Ñuh³², hi³ jáun² né³, ¿he³ ñí¹ la³ cun³ ñí¹ la³jɨ́³² ta²¹ jáun² jmu² héih³² hi³ hnoh² lɨ́¹³ jnauh¹ náh² quɨ́n¹? ");
INSERT INTO csoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jáun² tsá² judíos tsá² ná¹ñí¹ hí³ né³ ca³juáh³ siáh³ la³ lá²: ―Jun³juáh¹³ hi³ jnauh¹ jnoh¹ quɨ́n¹ cun³ñí¹ hi³ ca³tɨ²¹ ta²¹ chu²¹ hi³ má²ca³jmuh³ yáh³ hnú², tɨ³la³ cun³ñí¹ hi³ má²lɨ́²chú¹ lɨ́²len¹ hnú² Dió³² cun³quionh³ jáɨ¹³ hi³ má²lɨ́²hléh¹ hnú² nɨ́² bíh¹. Quí¹ hnú² dá² jan² tsá²mɨ³cuóun² bíh¹, tɨ³la³ dí¹jmuh³² nú² hi³ lɨ́n³ nú² Dió³² má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jmɨ́¹jáun² ca³juáh³ siáh³ Jesús: ―Ñí¹ liei²¹ quián¹³ hnoh² rá¹juáh³ hi³ Dió³² ca³juáh³ la³ lá²: “Jná¹³ má²cá²juáh³² hi³ dió³² bíh¹ ná¹lɨ́n³ hnoh²”. ");
INSERT INTO csoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Hi³ né¹ bíh¹ dí² hi³ la³ cun³ hi³ rá¹juáh³ ñí¹ Sí², cáun² tson² la³ má²tson² jáun² bíh¹, quí¹ Dió³² dá² ca³teh³ siáh³ dió³² la³ cun³ tsá² ca³héi³ hí³ jáɨ¹³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Jáun² né³, nɨ́¹juáh³ Dió³² yáh³ la³ má²ca³jmú³ hi³ cuá¹chan¹ jná¹³, hi³ ca³ze³ ná¹ tsú² siáh³ ñí¹ hué²¹ lá², ¿lánh³ bí¹ rón³² lɨ́¹³ juáh¹³ hnoh² hi³ jná¹³ má²lɨ́²chú¹ lɨ́²len¹ ná¹ Dió³² quí¹hliá² lɨ́²juáh³² jná¹³ hi³ lɨ́n³ ná¹ Jon² Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nɨ́¹juáh³ tiá² jmu² jná¹³ la³ cun³ ta²¹ hi³ jmu² Ñuh³², jáun² ha³ lɨ́² taunh³ náh² jná¹³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Tɨ³la³ nɨ́¹juáh³ la³ jmu² bíh¹ jná¹³ tá¹³ tsú² né³, tionh² náh² ta²¹ la³ cun³ hi³ jmu² jná¹³ jáun², uá¹jinh¹ tiá² ta²¹ taunh¹³ náh² jná¹³ huen²; hi³ jáun² cu³tsa³² cuɨ́¹ lɨ³ ñíh¹³ náh² cú²jueh³² hi³ hún¹ bíh¹ Ñuh³² jná¹³ cá²hon³ quiúnh¹ jná¹³, hi³ jáun² jná¹³ né³ hún¹ ná¹ siáh³ cá²hon³ quiúnh¹ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hi³ jáun² jmɨ́¹jáun² jmɨ́¹ hnió³ siáh³ tsá² hí³ hi³ ma³tson¹³ Jesús, tɨ³la³ ca³liáun³ bíh¹ Jesús jo³cuo² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jmɨ́¹jáun² ngah³ Jesús tɨ³ juɨ³² ñí¹ hia³² hiú², can³² cua³ Jordán, ñí¹ ca³zion³ hla¹ Juan² tsáu² jmáɨ² jmɨ́¹tin², hi³ jáun² ñí¹ jáun² ca³cuá³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jáun² juóun³² lɨ́n³² bíh¹ tsáu² ca³ñí¹jɨe¹³ tsú² ñí¹ jáun², hi³ ná¹juáh²³ la³ lá² má²tún² hmóu³²: ―Uá¹jinh¹ hla¹ Juan² tiá² li²¹ ca³jmú³ yáh³ hí¹ cáun², tɨ³la³ la³jɨ́³² bíh¹ la³ cun³ hi³ ca³juáh³ tsú² hi³ ca³tɨn¹ tsá²ñuh² lá², la³ tson² bíh¹ cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hi³ juóun³² lɨ́n³² bíh¹ tsáu² ca³chá³ cáun² tsɨ́³ ñí¹con² Jesús ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Né³² né³, ca³chó³² cáun² jmáɨ¹ hi³ jmɨ́¹ zian² jan² tsá² tsáun¹, tsá² jmáɨ² Lá¹; tsá² zian² juú² Betania bí¹ tsá² hí³ la³ má²quionh³ tá¹ gon³ tsá²mɨ³ raɨnh²¹, Má²réi³ jɨ³ mɨ́¹ Marta. ");
INSERT INTO csoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Má²réi³ raɨnh²¹ Lá¹ tsá² jmɨ́¹ tsáun¹ hí³ bíh¹ ca³sé³ jmɨ́² má²ró³² ta³ Tɨ³² Juo¹³ dí², hi³ jáun² ca³ma³quiéin² tsú² siáh³ cun³quionh³ jñú² chí¹ hnga². ");
INSERT INTO csoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Hi³ jáun² né³, tá¹ gon³ bíh¹ tsá²mɨ³ má²tún² raɨnh²¹ hí³ ca³zen³ jáɨ¹³ ñí¹con² Jesús, hi³ juáh³ la³ lá²: ―Tɨ³², rá²tsáun¹ bíh¹ há²mei²¹ joh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jáun² jmɨ́¹ ca³náɨ³² Jesús jáɨ¹³ jáun² né³, ca³juáh³ la³ lá²: ―Ha³ tiá² jún³ yáh³ tsú² cun³quionh³ mɨ́¹uɨ́³ jáun²; quí¹ cun³quionh³ mɨ́¹uɨ́³ jáun² dá² lɨ́¹³ lɨ³jnia² pí³ quioh²¹ Dió³² bíh¹, hi³ ja³bí¹ la³ jáun² lɨ³jnia² siáh³ pí³ quioh²¹ Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Uá¹jinh¹ jmɨ́¹ hnio³ lɨ́n³² bíh¹ Jesús mɨ́¹ Marta la³ má²quionh³ raɨnh²¹, jɨ³ Lá¹ nɨ́² siáh³, ");
INSERT INTO csoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","cu³ jáun² ca³cuá³ bíh¹ tsú² cónh³í¹ tun³ jmáɨ¹ ñí¹ jmɨ́¹ cuá³ jáun² la³ cun³ jmɨ́¹ ca³lɨ³ ñi³² hi³ rá²tsáun¹ Lá¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jmɨ́¹ lɨ²¹ jáun² né³ ca³záɨh³ dí² tsá² haɨn²¹ hí³ tɨ³ con², hi³ ca³juáh³: ―Ma³tsáu¹³ cónh³í¹ cu³ jéin³² tɨ³ hué¹³ Judea. ");
INSERT INTO csoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³ ca³juáh³: ―Tɨ³², já² tá¹la³ nɨ́² bí¹ jaun³² cánh³² jmɨ́¹ hnió³ tsá² *judíos tsá² ná¹ñí¹ zian² hué³² jáun² hi³ jngah³ hnú² cun³quionh³ quɨ́n¹, ¿hí¹ siáh³ ma³ siáh³ hnáuh² nú² cuóh¹³ ñí¹ jáun²? ");
INSERT INTO csoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Hi³ jáun² Jesús né³ ca³ngáɨ³: ―¿Haun¹³ juáh¹³ quia³tún³ o¹rá¹ hu²¹ cú² jmáɨ¹ dúh¹? Jáun² né³, nɨ́¹juáh³ ngɨ³² tsú² ta³ jma², tiá² hính³² yáh³ tsú², quí¹ jniá³ bíh¹ joh¹ hi³ zia³² hngá¹máh³ lá²; ");
INSERT INTO csoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","tɨ³la³ nɨ́¹juáh³ jan² tsá² ngɨ³² já¹niéi² né³, hinh³² bíh¹ tsú², quí¹ cun³ñí¹ hi³ tiá² joh¹ zia³² yáh³ ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hi³ ca³juáh³ siáh³ Jesús la³ lá²: ―Lá¹ há²mei²¹ quiú¹³ dí² má²rá²cuóun¹ bíh¹, tɨ³la³ ñí¹ñí²¹ jná¹³ tsú² má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³, ca³juáh³: ―Tɨ³², nɨ́¹juáh³ la³ má²rá²cuóun¹ tsú², la³ jáun² má²lin¹ hi³ má²lan¹³ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tɨ³la³ Jesús dá² jmɨ́¹ hnió³ juáh³ hi³ má²jun² bíh¹ Lá¹; tɨ³la³ tsá² haɨn²¹ hí³ tɨ³ con² dí² né³, lɨ́¹ jmɨ́¹ ná¹lɨ́n²³ hi³ hí³ dí² dí¹juáh²³ hi³ hú¹tá¹ tson² rá²cuóun¹ bíh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jáun² jmɨ́¹jáun² ca³juáh³ Jesús hú¹tá¹ cú²na²¹ jáɨ¹³ cú²jueh³², hi³ ca³juáh³ la³ lá²: ―Má²jun² bíh¹ Lá¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Jlánh¹ hiún² tsɨn³² jná¹³ quí¹hliá² tiá² jmɨ́¹ cuon¹ jná¹³ ñí¹ jáun² jmáɨ¹ jáun², hi³ jáun² ta³né³² má²zia³² lánh³ rón³² lɨ́¹³ cháh¹ hnoh² cáun² tán¹ honh² ñí¹con² jná¹³. Jáun² ma³tsɨ́¹neh²¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Hi³ jáun² Tú¹ma²¹ tsá² téh²³ tsú² hí³ dún² gon³ né³, ca³záɨh³ tsá² ñí¹ hná¹ jáun² la³ lá²: ―Ma³tsáu¹³ uá²jaɨ³² jnoh¹, hi³ jáun² hiá¹ tsáu¹³ dí² cu³tsa³² quiúnh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jmɨ́¹ cá¹chó²¹ jáun² Jesús né³, ca³lɨ³ ñi³² hi³ quiún³ jmáɨ¹ máh³ la³ má²tí³ hi³ ja³haun³ Lá¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ñí¹ má²janh² juú² Jerusalén bíh¹ jmɨ́¹ nio¹ juú² Betania, míh¹ tiá² cun³ hnɨ³² kilómetros jmɨ́¹ tí³ tɨ³ la³ uóunh³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jáun² né³, juóun³² bíh¹ tsá² judíos jmɨ́¹ la³ má²ca³cha³táunh¹ hñú¹³ mɨ́¹ Marta quionh³ Má²réi³ raɨnh²¹, hi³ ja³jɨen³ dí² tsú² cun³ñí¹ hi³ jun³ jáun² Lá¹ raɨnh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jmɨ́¹ ca³lɨ³ ñi³² mɨ́¹ Marta hi³ má²cuá¹ja³² Jesús, jáun² cua³han³ dí² hi³ ca³ñí¹hen¹³ dí² tsú²; tɨ³la³ Má²réi³ né³ ca³ta³cua¹³ bí¹ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jáun² mɨ́¹ Marta ca³záɨh³ Jesús la³ lá²: ―Hnú² Tɨ³² Juóu³² jná¹³, sá¹jmɨ́¹ hi³ ñíh³ hnú² ñí¹ lá² dúh¹, tiá² jmɨ́¹ jun¹ yáh³ renh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tɨ³la³ jná¹³ ño¹ má¹ná¹, hi³ uá¹jinh¹ la³ tɨ³ ta³né³², cun³ cué³² bíh¹ Dió³² lɨ³ua³ cáun² hi³ mɨ́h¹³ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jáun² Jesús ca³juáh³: ―Jenh¹³ bí¹ renh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Hi³ jáun² mɨ́¹ Marta né³ ca³ngáɨ³: ―Ján³, ño¹ bíh¹ jná¹³ hi³ jenh¹³ tsú² ñí¹ cá¹táuh³ jmáɨ¹, nɨ́¹ má¹tɨ³ ñí¹ jenh¹³ la³jɨ́n³² tsá² má²cá²tsan³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jmɨ́¹jáun² ca³juáh³ siáh³ Jesús: ―Jná¹³ bíh¹ jmu¹ hi³ jenh¹³ tsú², jɨ³ hi³ lɨ́¹³ zian² tsú² siáh³. Nɨ́¹juáh³ tsá² taunh² ta²¹ jná¹³, uá¹jinh¹ jún³ tsú², cun³ jenh¹³ bí¹ tsú²; ");
INSERT INTO csoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","hi³ la³jɨ́n³² bíh¹ tsá² zian² ta³né³², cun³ jmɨ́¹lɨ́h³ bíh¹ tiá² jún³ nɨ́¹juáh³ hi³ taunh² ta²¹ jná¹³. ¿Táunh¹³ hnú² ta²¹ jáɨ¹³ lá²? ");
INSERT INTO csoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jáun² tsá²mɨ³ hí³ ca³ngáɨ³ la³ lá²: ―Ján³ Tɨ³², taunh³² bíh¹ jná¹³ ta²¹ hi³ hnú² bíh¹ lɨ́n³ Cristo Jon² Dió³², Tsá² ca³tɨ²¹ hi³ já³² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jmɨ́¹ má²lɨ́²juáh³ jáun² mɨ́¹ Marta la³ nɨ́² né³, ngah³ hi³ ca³ñí¹tieh¹ Má²réi³ raɨnh²¹ ta³ máɨh³, hi³ ca³juáh³ la³ lá²: ―Ó³² zenh² Tɨ³², hi³ jáun² dí¹té²³ tsú² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jáun² la³ cun³ jmɨ́¹ ca³náɨ³² Má²réi³ ca³náu² hi³ ngau³ hi³ ca³ñí¹jɨen¹³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Quí¹ tiá² jmɨ́¹ má²hi³² yáh³ Jesús já¹ juú² jmɨ́¹jáun², la³ cun³ rón³² ñí¹ ca³jenh² jáun² mɨ́¹ Marta bíh¹ tsú² jmɨ́¹ zenh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hi³ jáun² jmɨ́¹ ca³jɨ́e³ tsá² judíos tsá² jmɨ́¹ já¹jɨen³ hí³ Má²réi³ hi³ la³juɨ³² ca³náu² hi³ cua³han³, jáun² ja³taunh²¹ uá²jaɨ³² cu³chin¹, quí¹hliá² ca³lɨ́n¹³ dí² hi³ má²ngau³² ho³ tá²hón³² bíh¹ tsú² hi³ já¹háu³ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jáun² jmɨ́¹ cá¹chó²¹ Má²réi³ ñí¹ zenh¹ Jesús né³, ca³di³jñí³² ñí¹ hó²¹ñí¹ tsú², hi³ ca³juáh³ la³ lá²: ―Tɨ³², sá¹jmɨ́¹ hi³ ñíh³ hnú² ñí¹ lá² dúh¹, tiá² jmɨ́¹ jun¹ yáh³ renh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jmɨ́¹ ca³jɨ́e³ Jesús hi³ ca³hó³ Má²réi³ la³ má²quionh³ tsá² judíos tsá² ca³cha³táunh¹ hí³ quionh³ tsú², jáun² ca³hi³ cúh² tsɨ́³, hi³ ca³ja³ siáh³ mií³ tsɨ́³, ");
INSERT INTO csoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","hi³ jáun² ca³ngáɨ³ dí² ñí¹con² tsú² la³ lá²: ―¿Ha³ jinh¹ ca³ñí¹hón²¹ náh² tsú²? Hi³ jáun² tsá² tionh² hí³ ca³juáh³: ―Tɨ³², sá¹nɨ́² ña³² ñá²jɨe³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jmɨ́¹ lɨ²¹ jáun² né³, Jesús ca³sunh³ jmáɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ tsá² hí¹tsá²táunh¹ hí³ la³ lá²: ―Jɨe³ né³, ¡cónh³ bíh¹ tiá² jmɨ́¹ la³ hnio³ dí² hla¹ Lá¹! ");
INSERT INTO csoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma³ jan² tsá² hí³ ca³juáh³ siáh³: ―Já² tsá² nɨ́² yáh³ ca³jmú³ hi³ ca³jnia³ mɨ́¹ñí¹ tsá² jmɨ́¹ ten³ hí³, ¿tiá¹ hi³ jmɨ́¹ la³ lɨ́¹³ jmu³ tsú² ca³lá² quioh²¹ hla¹ Lá¹, hi³ jáun² tiá² jmɨ́¹ jún³? ");
INSERT INTO csoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jmɨ́¹jáun² ca³hi³ siáh³ cúh² tsɨ́³ Jesús, hi³ jáun² ca³ja³janh³² ho³ tá²hón³². Tá²hón³² jáun² dá² jmɨ́¹ lɨ́³ cáun² tá²hláu² bíh¹, hi³ jáun² jmɨ́¹ dí¹jnáɨ²³ cá² máɨ³ quɨ́n¹ ñí¹ lɨ́³ ho³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jáun² Jesús ca³juáh³ siáh³ la³ lá²: ―Quin³² náh² quɨ́n¹ nɨ́². Jmɨ́¹jáun² ca³juáh³ mɨ́¹ Marta raɨnh²¹ hla¹ la³ lá²: ―Tɨ³², já² má²hlah³ bíh¹ má²ja³², quí¹ má²quiún³ jmáɨ¹ máh³ jun³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Tɨ³la³ Jesús né³ ca³juáh³ la³ lá²: ―¿Tiá¹ má²lɨ́²juáh³² jná¹³ dúh¹, hi³ nɨ́¹juáh³ táunh²³ hnú² ta²¹, lɨ́¹³ bíh¹ jɨeh²¹ nú² pí³ quioh²¹ Dió³²? ");
INSERT INTO csoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Hi³ jáun² jmɨ́¹ lɨ²¹ jáun², ca³quin³ bíh¹ tsú² quɨ́n¹ jáun². Jmɨ́¹jáun² ca³ziauh³ Jesús ñí¹ tɨ³ chi³cuú², hi³ ca³juáh³: ―Tia²¹, tiá¹hmah¹ hnú² quí¹hliá² má²lɨ́²niéih² hnú² jáɨ¹³ quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ño¹ bíh¹ jná¹³ hi³ cun³ tiú²nio² bíh¹ naɨh³² hnú² jë² jná¹³, tɨ³la³ dí¹juanh³² jná¹³ la³ lá² cun³ñí¹ hi³ ca³tɨn¹ tsá² tionh² lá² bíh¹, hi³ jáun² lɨ́¹³ tónh³² tsú² ta²¹ hi³ hnú² bíh¹ ca³ze² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hi³ jáun² jmɨ́¹ má²lɨ́²juáh³ tsú² la³ nɨ́² né³, ca³hléh³ tiá³, hi³ ca³juáh³: ―¡Náu² Lá¹, cua³han² ñí¹ nɨ́²! ");
INSERT INTO csoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hi³ jáun² tsá² jmɨ́¹ má²jún¹ hí³ né³, cua³han³ bíh¹ ta³ ná¹tsáɨh³ hmɨh³² cuá² ta³, hi³ jáun² ñí¹ tsú² jmɨ́¹ tsáɨh³ siáh³ cáun² hmɨh³². Jáun² ca³záɨh³ Jesús tsá² tionh² hí³: ―Jen¹ tsú² hi³ jáun² cuɨ́¹ chánh¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jmɨ́¹jáun² juóun³² lɨ́n³² bíh¹ tsá² judíos tsá² jmɨ́¹ quionh³ hí³ Má²réi³ ca³tanh² ta²¹ Jesús jmɨ́¹ ca³jɨ́e³ la³ cun³ hi³ má²lɨ́²jmú³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tɨ³la³ ma³ jan² tsá² hí³ má¹ná¹, ñí¹con² tsá² *fariseos bíh¹ ja³taunh²¹, hi³ ca³ñí¹choh¹ dí² tsú² la³ cun³ hi³ má²lɨ́²jmú³ jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jmɨ́¹jáun² ca³cuú² ca³ngɨh³² tsá² fariseos quionh³ tsá² ná¹lɨ́n³ mi³jmú³, la³ má²quionh³ tsá² ná¹ho² ta²¹, hi³ ca³juónh³ la³ lá²: ―¿He³ dá² lánh³ jmú¹³ dí² juáh¹³? Quí¹ jlánh¹ ma³ hliáun³ li²¹ hi³ lɨ́³ hua³jueh³² jmu² tsá²ñuh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nɨ́¹juáh³ cáun² lɨ́¹ neh²¹ la³ nɨ́² bíh¹ dí², jáun² la³jɨ́n³² bíh¹ tsáu² taunh¹³ ta²¹ quioh²¹ tsú², hi³ jáun² tsá²tan²¹ tsá² *romanos né³, ja³táunh¹ hi³ ja³tsunh¹ cuáh³² chín¹ quiú¹³ dí², hi³ ja³ma³quí² ma³tsau² tsú² siáh³ jɨ³lá² dí². ");
INSERT INTO csoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tɨ³la³ jan² tsá² hí³, tsá² jmáɨ² Caifás, tsá² jmɨ́¹ lɨ́n³ mí²tsá² hɨ́en¹ jmáɨ¹ jáun² ca³juáh³ la³ lá²: ―Hí¹ cáun² yáh³ tiá² hi³ ñíh¹ hnoh², ");
INSERT INTO csoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","hi³ sa³jun³ canh³² bí¹ náh² hua³hí¹³, hi³ tɨ³ quien² bíh¹ jún³ jan² tsáu² cha¹³ jɨ³lɨn² tsáu² la³ cónh³ bíh¹ hi³ hiá¹ tsau¹³ dí² jɨ³lá². ");
INSERT INTO csoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tɨ³la³ Caifás má¹ná¹, tiá² ca³juáh³ yáh³ la³ nɨ́² cun³ñí¹ hi³ cháunh²³ chí¹ hnga²; la³ nɨ́² dá² ca³juáh³ tsú² quí¹ cun³ñí¹ hi³ hí³ jmɨ́¹ lɨ́n³ mí²tsá² hɨ́en¹ jmáɨ¹ jáun² bíh¹, hi³ jáun² bíh¹ ca³hléh³ tsú² jáɨ¹³ hi³ ca³cué³ jáun² Dió³² hñu³ tsɨ́³, hi³ Jesús bíh¹ ca³tɨn¹ jún³ cha¹³ la³jɨ́n³² tsá² judíos. ");
INSERT INTO csoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hi³ jun³juáh¹³ jmáh³la³ hi³ ca³tɨn¹ tsá² hí³ yáh³, quí¹ ja³bí¹ la³ jáun² lɨ́¹³ chan³ tsú² cu³lɨ²¹ jon² Dió³² bíh¹, tsá² lɨ́¹ má²tiú¹ má²hán¹ tɨ³ hlá² tɨ³ nɨ́² tá¹ cáun² hngá¹máh³. ");
INSERT INTO csoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Hi³ jáun² dá² la³ cun³ jmɨ́¹jáun² bíh¹ ca³ma³cú¹ ma³ren²¹ tsá² judíos tsá² ná¹ñí¹ jáɨ¹³ hi³ jngɨh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Cun³ñí¹ hi³ jáun² bíh¹ tiú²uú² cáun² lɨ́¹ jmɨ́¹ ngɨ³² Jesús chú¹jan¹ ja¹ tsá² zian² hué¹³ Judea, hi³ jáun² cua³han³ bíh¹ dí² cú²jueh³² hué¹³ Judea, hi³ ngau³ tɨ³ ñí¹ má²janh² hué³² quiéin², já¹ juú² jmáɨ² Efraín. Ñí¹ jáun² bíh¹ ca³ta³cua¹³ tsú² quionh³ tsá² haɨn²¹ hí³ tɨ³ con². ");
INSERT INTO csoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ jmɨ́¹ hniáuh²¹ hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹ quioh²¹ tsá² judíos; hi³ jáun² né³, juóun³² lɨ́n³² tsá² zian² ca³la³ jɨ́³² juú² míh¹ juú² siún¹ ja³tú¹ já¹lɨn³ tɨ³ já¹ juú² Jerusalén hi³ ja³ma³tí³² la³ cun³ hi³ ná¹ngɨ²³, hi³ má²jɨn² tsú² jáun² ñeh² bíh¹ hi³ tɨ²¹ Jmɨ́¹hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Tá¹la³ jmáɨ¹ jáun² né³ ca³quí² ca³hnah² tsá² hí³ Jesús, hi³ jáun² tá¹la³ tiáunh¹ dí² hñu³ cuáh³² chín¹ né³, ngaɨh³² dí² tsá²ján² tsá²ján², hi³ juáh³ la³ lá²: ―¿He³ lánh³ lɨ́n²³ hnoh²? ¿Hí¹ já³² tsú² jmáɨ¹ juáh¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hi³ tsá² fariseos né³, la³ má²quionh³ tsá² ná¹lɨ́n³ mi³jmú³ jmɨ́¹ má²ca³jmú³ héih³² hi³ hniáuh³² chá³² lɨ³ua³ jan² tsáu² nɨ́¹juáh³ hin² má²ca³lɨ³ ñi³² ha³ jinh¹ cuá³ Jesús, hi³ jáun² tsa³quian³ dí² hi³ tson³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","La³ñí¹ jñéi³ jmáɨ¹ hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹, ngau³ Jesús tɨ³ já¹ juú² Betania, juú² co¹ Lá¹ tsá² má²ca³jmú³ dí² hí³ hi³ ca³jenh¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hi³ jáun² cun³ñí¹ hi³ ca³lɨ³hnió³ tsú² ma³quien² Jesús né³, jáun² ca³jmú³ tsú² cáun² má³² tɨ³ ca³niéi² hi³ ca³tɨn¹ tsú²; jáun² mɨ́¹ Marta jmɨ́¹ cuá¹ná²tsɨ́³ má³², hi³ Lá¹ né³ jmɨ́¹ cuá³ ñí¹ mesa cu³tsa³² quionh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jáun² tá¹la³ tionh² tsú² jáun² ñí¹ mesa né³, ca³can³ Má²réi³ cá² tsá¹ cuah²¹ no¹ má²ró³² hngó³², hi³ jmu² tsú² quionh³ há² má²ró³² hi³ téh²³ tsú² nardo, hi³ jlánh¹ bí¹ hmuh²¹, hi³ jáun² né³ ca³sé³ dí² ta³ Jesús. Jmɨ́¹ lɨ²¹ jáun² ca³ma³quiéin² dí² siáh³ ta³ tsú² cun³quionh³ jñú² chí¹, jáun² ca³la³ tá¹ cáun² ñéih³ bíh¹ ca³cónh³² jie³ jmɨ́² má²ró³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hi³ jáun² Judas jon² Sí¹mu²¹ tsá² zian² juú² Queriot, jan² tsá² haɨn²¹ hí³ tɨ³ con² Jesús, tsá² tsa³jɨenh³ hí³ Jesús, ca³juáh³ la³ lá²: ");
INSERT INTO csoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿He³ láɨh³² sa³ tiá² ca³hnáɨ³ tsú² jmɨ́² má²ró³² nɨ́²? Quí¹ cun³ hnɨ³² nio² hñá³láu³ héih³² quɨe³ *cú¹tiáu² jmɨ́¹ lɨ́¹³ láɨh¹³ tsú² quioh²¹ hi³ nɨ², hi³ jáun² quɨe³ jáun² jmɨ́¹ lɨ́¹³ cuéh³² tsú² tsá² tia³mii². ");
INSERT INTO csoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tɨ³la³ jun³juáh¹³ ca³juáh³ Judas la³ nɨ́² quí¹hliá² juo²³ jéinh³² tsá² tia³mii² yáh³, ca³juáh³ tsú² la³ nɨ́² quí¹ cun³ñí¹ hi³ hí³ jmɨ́¹ lɨ́n³ jan² háɨn² bíh¹; quí¹ hí³ bíh¹ jmɨ́¹ nio² jo³cuo² tuh³² tioh³ quɨe³ quioh²¹ quionh³ tsá² quionh³, hi³ jáun² jmɨ́¹ han² bíh¹ dí² la³ cun³ hi³ hí²³ hñu³ tuh³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jáun² Jesús ca³juáh³ la³ lá²: ―Ha³ lɨ́² lɨ́¹ jmú² hnú² liúnh¹ ñí¹con² tsú², quí¹ tsá²mɨ³ nɨ́² dá² má²ca³hmá³ hi³ nɨ́² hi³ ca³tɨ²¹ jmáɨ¹ hi³ tsa³haun³ jná¹³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Quí¹ la³jɨ́³² jmáɨ¹ bíh¹ zian² tsá² tia³mii² ja¹ quián¹³ hnoh², tɨ³la³ jná¹³ né³, jun³juáh¹³ jmáɨ¹ ca³la³ jɨ́³² yáh³ cuon¹ jná¹³ ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jáun² né³, juóun³² lɨ́n³² tsá² *judíos ca³lɨ³ ñi³² hi³ Jesús má²cuá³ já¹ juú² Betania, hi³ jáun² ja³taunh²¹ dí² ñí¹ jáun², tɨ³la³ jun³juáh¹³ hi³ tsa³jɨen³ jmáh³la³ Jesús yáh³ tsú², quí¹ hi³ ta³ tsa³jɨen³ siáh³ Lá¹ bíh¹ tsú², tsá² ca³jmú³ Jesús hi³ ca³jenh¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hi³ jáun² tsá² ná¹lɨ́n³ mi³jmú³ ca³jmú³ cá²hon³ hi³ jngɨh³ uá²jaɨ³² Lá¹, ");
INSERT INTO csoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","quí¹ cun³ñí¹ hi³ ca³tɨn¹ hí³ bíh¹ juóun³² lɨ́n³² tsá² judíos jmɨ́¹ má²ná¹tiánh²³ tɨ³ có³² ñí¹con² dí², hi³ má²tanh² ta²¹ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Juóun³² lɨ́n³² bíh¹ tsáu² jmɨ́¹ má²tiáunh¹ Jmɨ́¹hɨ́en¹ já¹ juú² Jerusalén; hi³ jmɨ́¹ cá¹jniá²¹ jáun² né³, ca³lɨ³ ñi³² tsú² hi³ hí¹tsau³² Jesús já¹ juú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Hi³ jáun² ca³quieh³ tsá² hí³ mu²¹ hmá² zún³, jáun² ca³huén² hi³ ca³ñí¹hen¹³ Jesús ca³la³ hi³ tɨ́² hi³ hóh³², hi³ juáh³ la³ lá²: ―¡Hénh³ ma³ chun¹ Dió³²! ¡Cuɨ́¹ lɨ³quien² bíh¹ Tsá² cuá¹ja³² cun³quionh³ héih³² quioh²¹ Dió³² Juo¹³ dí²! ¡Hénh³ ma³ chun¹ Re²¹ Juo¹³ tsá² *Israel! ");
INSERT INTO csoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús ca³chanh²¹ jan² lo¹ búh¹ míh¹ hi³ ca³ñi³tsɨn¹, hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ jmɨ́¹ rá¹juáh³ jáun² ñí¹ Sí²: ");
INSERT INTO csoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Hnoh² tsá² zian² náh² tɨ³ ñí¹ zeh¹ máh³ Sión, ha³ lɨ́² juenh³; sá¹nɨ́² jɨeh³ hi³ Re²¹ Juóuh³² hnoh² cuá¹ja³² ñí¹con² hnoh² hi³ cuá¹tsɨn¹ jan² lo¹ búh¹ míh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Tiá² jmɨ́¹ ngɨ²³ yáh³ tsá² haɨn²¹ hí³ tɨ³ con² tsú² jmɨ́¹ lɨ²¹ la³jɨ́³² hi³ jáun²; tɨ³la³ la³ tɨ³ jmɨ́¹ má²ca³lɨ³quien² máh³ Jesús tsau³ tsɨ́³ tsú² hi³ la³jɨ́³² hi³ lɨ³ jáun² jmɨ́¹ má²rá¹juáh³ bíh¹ ñí¹ Sí² hi³ ca³tɨn¹ tsú², hi³ jáun² bíh¹ la³ lɨ³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jáun² né³, jmɨ́¹ zian² juóun³² lɨ́n³² tsá² ca³jɨ́e³ jmɨ́¹ ca³teh³ Jesús hla¹ Lá¹ hi³ cua³han² hñu³ tá²hón³², hi³ ca³jmú³ dí² hi³ ca³jenh¹³ tsú². Tsá² hí³ né³, jlánh¹ ca³qui³ ca³chá³ la³ cun³ hi³ ca³jɨ́e³ jáun², ");
INSERT INTO csoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","cun³ñí¹ hi³ jáun² bíh¹ ca³quí² ca³huén² tsáu² hi³ já¹hen³ Jesús, quí¹hliá² ca³lɨ³ ñi³² tsú² ca³tɨ²¹ li²¹ hi³ lɨ́³ hua³jueh³² hi³ ca³jmú³ dí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Hi³ jáun² tsá² *fariseos ca³juónh³ la³ lá² ja¹ hmóu³²: ―Jɨe³ né³, hí¹ cáun² tiá² hi³ la³ lɨ́¹³ jmú¹³ yáh³ dí². Jɨeh³ dúh¹, la³jɨ́n³² tsáu² bíh¹ má²tsá²tú¹ tsá²lɨn³ cu³hna²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ja¹ tsá² ca³cha³táunh¹ já¹ juú² Jerusalén hi³ ma³tsu³ ma³jónh³² Dió³² tá¹la³ jmáɨ¹, jmɨ́¹ ná¹tson¹ ma³ jan² tsá² hleh³² jú¹jma² *griego. ");
INSERT INTO csoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tsá² hí³ né³ ja³taunh²¹ ñí¹con² Pí²liéi¹ tsá² zian² juú² Betsaida hɨ́n¹³ tɨ³ Galilea, hi³ ca³záɨh³ dí² la³ lá²: ―Tɨ³², jmɨ́¹ hnáu² jnoh¹ neh²¹ tiá³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Hi³ jáun² Pí²liéi¹ né³ ngau³ hi³ ca³ñí¹zeh¹ Tre²¹, hi³ jáun² tá¹ gon³ dí² ja³taunh²¹ hi³ ca³ñí¹choh¹ dí² siáh³ Jesús jáɨ¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jáun² Jesús né³ ca³juáh³ la³ lá²: ―Má²cá²chó³² bíh¹ jmáɨ¹ hi³ lɨ́¹³ lɨ³ quien² jná¹³ Jon² tsá²mɨ³cuóun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jú¹ tson² juo³ jná¹³ hnoh², hi³ nɨ́¹juáh³ tiá² la³ jñí³² yáh³ tsú² cá² máɨ³ mɨ³ cuú², hi³ jáun² la³ má²lɨ́³ jáun² bíh¹ cá² máɨ³ tán¹; tɨ³la³ nɨ́¹juáh³ hi³ hin³ tsú² cá² máɨ³ né³, jáun² hliáun³ lɨ́n³² bíh¹ hi³ ló³². ");
INSERT INTO csoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jáun² né³, nɨ́¹juáh³ tsá² hnió³ lɨ³ zian² ué³ ñí¹ hué²¹ lá², tsá² la³ hí³ tɨ³ tsa³hín³ bíh¹; tɨ³la³ nɨ́¹juáh³ tsá² jmu² hi³ tiá² lin¹ quien² hi³ zian² ñí¹ hué²¹ lá² né³, tsá² la³ hí³ bíh¹ tɨ³ lɨ́¹³ zian² la³ cun³ jmɨ́¹hi³nio². ");
INSERT INTO csoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Lɨ³ua³ jan² tsá² hnió³ ma³cáu³² jná¹³, cuɨ́¹ já² tsú² cu³hna³² jná¹³; hi³ jáun² nɨ́¹juáh³ ñí¹ ñih²¹ jná¹³ né³, ja³bí¹ ñí¹ jáun² uá²jaɨ³² tsa³cuá² siáh³ tsá² má²cáu³² jná¹³. Hi³ lɨ³ua³ jan² tsá² má²cáu³² jná¹³ né³, Ñuh³² jná¹³ ma³quien² tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","”Tɨ³la³ ta³né³² né³, jlánh¹ hliáun³ ñéih³ má²hu²¹ tsɨn³² jná¹³. ¿He³ yáh³ juah²¹ jná¹³ ta³né³²? ¿Hí¹ juah²¹ jná¹³: “Tia²¹, liau¹ jná¹³ ca³tɨ²¹ jmáɨ¹ hi³ má²tón³² jáun²”? Tɨ³la³, já² hú¹tá¹ hi³ ca³tɨ²¹ hi³ nɨ́² yáh³ ja³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tia²¹, ¡ma³quien¹³ hnú² hi³ jmáɨ² nú²! Jmɨ́¹jáun² ca³náɨ³² tsú² cáun² mah¹ hñu³mɨ³cuú², hi³ ñí¹juah²¹ la³ lá²: ―Má²ca³ma³quien¹³ bíh¹ jná¹³, hi³ jáun² má¹quien¹³ bíh¹ jná¹³ siáh³ cónh³í¹ cu³ jéin³². ");
INSERT INTO csoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hi³ jáun² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² né³ ca³náɨ³², hi³ jáun² jmɨ́¹ ná¹juáh²³ hi³ miíh³² bíh¹ má²lɨ́²jmú³, tɨ³la³ ma³ jan² né³ jmɨ́¹ ná¹juáh²³ la³ lá²: ―Jan² tsá²cuú² tsá²ta³ Dió³² má²lɨ́²hléh³² ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jmɨ́¹ lɨ²¹ jáun² né³, Jesús ca³záɨh³ tsá² hí³ la³ lá²: ―La³ñí¹ la³ján³ hi³ ca³tɨn¹ hnoh² bíh¹ mah¹ hi³ má²lɨ́²hléh³² nɨ́², jun³juáh¹³ hi³ ca³tɨn¹ jná¹³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ta³né³² bíh¹ má²cá²chó³² jmáɨ¹ hi³ tá¹tsɨn¹ héih³² tsá² zian² hngá¹máh³ lá², hi³ ta³né³² bí¹ siáh³ má²cá²chó³² jmáɨ¹ hi³ cua³haɨn³² tɨ³ cheih³² tsá² cuá¹jmu² quien² ñí¹con² tsá² zian² hngá¹máh³ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hi³ jáun² nɨ́¹ má¹ca³ziau³ tsú² jná¹³ chi³cuú² né³, má¹jáun² con²¹ jná¹³ ca³la³ jɨ́n³² tsáu² ñí¹con² ná¹ huen². ");
INSERT INTO csoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cun³quionh³ hi³ ca³juáh³ jáun² la³ nɨ́² bíh¹ tsú², ca³lɨ³ lin¹ he³ lánh³ rón³² jún³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Hi³ jáun² tsá² tionh² hí³ né³ ca³juáh³ la³ lá²: ―Cun³quionh³ jáɨ¹³ hi³ rá¹tioh³ ñí¹ Sí² liei²¹ quiú¹³ jnoh¹ má²ca³lɨ³ né¹ hi³ Tsá² lɨ́n³ Cristo lɨ³ zian² cun³ jmɨ́¹hi³nio² bíh¹. ¿Ha³ bí¹ lánh³ rón³² juánh³ hnú² hi³ Jon² tsá²mɨ³cuóun² ca³tɨ²¹ zón³² chi³cuú²? ¿Hin² dá² tsánh² tsá² hí³ hi³ lɨ́n³ Jon² tsá²mɨ³cuóun²? ");
INSERT INTO csoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jáun² né³, Jesús ca³záɨh³ siáh³ tsá² hí³ la³ lá²: ―Lɨ³ zia³² bíh¹ joh¹ ja¹ quián¹³ hnoh², tɨ³la³ cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ má¹ná¹. Hi³ jáun² né³, ñi³táunh¹ náh² ñí¹ tie³ joh¹ tá¹la³ zia³² joh¹ ja¹ quián¹³ náh², quí¹ nɨ́² lɨ́¹ ca³jauh¹ náh² já¹niéi²; quí¹ nɨ́¹juáh³ jan² tsá² cuá¹ngɨ³² já¹niéi², ha³ tiá² ñi³² yáh³ tsú² ha³ jinh¹ cuá¹tsau³². ");
INSERT INTO csoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chá¹ náh² cáun² honh² ñí¹con² joh¹ jáun² tá¹la³ tie³ ja¹ quián¹³ náh², hi³ jáun² lɨ́¹³ lɨ́n³ náh² tsá² zia³² joh¹ ñí¹con². Jmɨ́¹ má²lɨ́²juáh³ Jesús la³ nɨ́² né³, ngau³ hi³ ca³ñí¹hinh² ñí¹con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hi³ jáun² né³, uá¹jinh¹ hliáun³ bíh¹ li²¹ hi³ lɨ́³ hua³jueh³² má²ca³jmú³ Jesús ñí¹ hó²¹ñí¹ tsá² hí³, tɨ³la³ cun³ jáun² bíh¹ tiá² jmɨ́¹ tanh² dí² ta²¹; ");
INSERT INTO csoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","quí¹ la³ jáun² ca³lɨ³tí³ la³ cun³ hi³ ca³juáh³ jáun² hla¹ Isaías tsá² jmɨ́¹ lɨ́n³ hí³ *tɨ³² jë¹ Dió³², hi³ ca³juáh³ la³ lá²: Hnú² Juóu³² jná¹³, ¿hin² dá² tsánh² má²ca³taunh³ ta²¹ jáɨ¹³ hi³ hléh¹ jnoh¹? ¿Hin² dá² ñí¹con² ca³ma³jnia¹³ hnú² pí³ quián¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","La³ nɨ́² bíh¹ lɨ́³, hi³ jáun² tiá² jmɨ́¹ lɨ́²³ yáh³ hi³ tónh³² tsú² ta²¹. Quí¹ ja³bí¹ la³ lá² siáh³ ca³juáh³ hla¹ Isaías hí³: ");
INSERT INTO csoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dió³² cu³tsa³² má²ca³jmú³ hi³ ná¹ten³ tsá² nɨ́², hi³ jáun² tiá² lɨ́¹³ jɨ́e³; jɨ³ hi³ cu³tsa³² má²ca³jmú³ dí² siáh³ huáh² chí¹ tsú², hi³ jáun² tiá² ngɨ¹³; quí¹ sá¹jmɨ́¹ hi³ tɨ³ jéinh³² tsú² jmɨ́¹ tsɨ́³, hi³ jáun² jná¹³ jmɨ́¹ lɨ́¹³ jmah²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","La³ nɨ́² ca³juáh³ Isaías quí¹hliá² jmɨ́¹ má²ca³jɨ́e³ bíh¹ tsú² hi³ Jesús bíh¹ jan² Tsá² quien² lɨ́n³², hi³ jáun² hi³ ca³tɨn¹ hí³ bíh¹ hi³ ca³hléh³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tɨ³la³ uá¹ jáun² la³ jáun² né³, cun³ jáun² juóun³² bíh¹ tsá² ná¹ñí¹ ca³tanh² ta²¹ Jesús; jɨ́³²la³ cáun² tiá² jmɨ́¹ má²li²¹ tsú² ñí¹con² tsáu² bíh¹, quí¹ cun³ñí¹ hi³ jmɨ́¹ juénh² tsú² tsá² fariseos, quí¹ nɨ́² lɨ́¹ ca³hue³ tsú² hñu³ cuáh³² quioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Quí¹ cun³ñí¹ hi³ tɨ³ jlánh¹ bíh¹ jmɨ́¹ hniá¹ tsú² hi³ tsáu² juáh³ hi³ hí³ dí² chun¹, cha³ jmɨ́¹ jmu³ dí² hniá¹ hi³ Dió³² juáh³ hi³ chun¹ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Hi³ jáun² né³, Jesús ca³hléh³ siáh³ cónh³í¹ cu³ jéin³² tiá³, hi³ ca³juáh³: ―Lɨ³ua³ jan² tsá² taunh² ta²¹ jná¹³, jun³juáh¹³ taunh² ta²¹ jmáh³la³ jná¹³ yáh³ tsú², tɨ³la³ tanh² tsú² ta²¹ la³ jɨ³ Ñuh³² jná¹³ Tsá² ca³ze³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hi³ nɨ́¹juáh³ tsá² má²cuóu³² jná¹³ siáh³, ja³bí¹ má²cuóun³² tsú² siáh³ Tsá² ca³ze³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jná¹³ bíh¹ má²cuán² ná¹ ja¹ quioh²¹ tsá² zian² ñí¹ hué²¹ lá², hi³ lɨ́n³ ná¹ joh¹ ñí¹con² tsú², hi³ jáun² tiá² já¹niéi² tá¹tonh¹ yáh³ nɨ́¹juáh³ tsá² taunh² ta²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tɨ³la³ nɨ́¹juáh³ tsá² náɨ³² jáɨ¹³ quion²¹ jná¹³, hi³ tiá² ta²¹ taunh³² má¹lɨ³² jáun², jun³juáh¹³ jná¹³ yáh³ tsá² rá¹tsɨn³² tsú² héih³²; quí¹ jun³juáh¹³ ja³ jná¹³ hi³ tɨ³ ja³ra³tsɨn³² ná¹ tsáu² héih³² yáh³, tɨ³la³ jná¹³ dá² ja³ hi³ ja³lion¹ bíh¹ tsá² zian² hngá¹máh³ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Zia³² bíh¹ he³ cun³quionh³ tá¹tsɨn¹ tsú² héih³² nɨ́¹juáh³ tsá² tiá² quiú² tiá² jéi²³ jná¹³, hi³ sa³jun³ jéih³² tsú² siáh³ jáɨ¹³ quion²¹ jná¹³: Cun³quionh³ jáɨ¹³ hi³ má²ca³hléh³ jáun² bíh¹ jná¹³ tá¹tsɨn¹ tsú² héih³² tɨ³ ñí¹ táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Quí¹ jun³juáh¹³ hléh²³ jná¹³ jáɨ¹³ hi³ lɨ́¹ chin³² chin³² huen² yáh³, quí¹ tɨ³la³ hnga² Ñuh³² jná¹³ Tsá² ca³ze³ bíh¹ jmu² héih³² nɨ́¹juáh³ he³ hléh¹³ jná¹³ ho³ he³ hɨ́e¹³ jná¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hi³ ño¹ ná¹ siáh³ hi³ héih³² quioh²¹ Ñuh³² bíh¹ jná¹³ jmu² hi³ lɨ́¹³ zian² tsú² la³ cun³ jmɨ́¹hi³nio²; hi³ jáun² bíh¹ la³jɨ́³² hi³ hléh²³ jná¹³ lɨ́³ tán¹ la³ cun³ rón³² hi³ ca³záɨ³ jná¹³ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Jáun² né³, ta³ ñeh² bíh¹ hi³ tɨ²¹ *Jmɨ́¹hɨ́en¹, jmɨ́¹ má²ñi³² bíh¹ Jesús hi³ má²cá²chó³² bíh¹ jmáɨ¹ hi³ cua³han² dí² ñí¹ hué²¹ lá², hi³ tsánh³² dí² ñí¹ cuá³ Jméi². Hi³ jáun² ca³ma³hnio³ dí² tsá² joh¹ tionh² ñí¹ hué²¹ lá² la³ má²hnio³ jáun² dí² ca³la³ ñí¹ cá¹táuh³ jmáɨ¹. ");
INSERT INTO csoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tá¹la³ jmɨ́¹ ná¹jmu² tsú² jáun² má³² bíh¹, hi³ tsá² hláɨnh¹ hñu³ tsɨ́³ Judas jon² Sí¹mu²¹, tsá² ja³ hí³ tɨ³ juú² Queriot, hi³ jáun² hí³ né³ ca³lɨ́n¹³ hi³ jɨenh³ dí² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hi³ jáun² né³, Jesús cun³ jmɨ́¹ má²ñi³² bíh¹ hi³ Jméi² dí² má²ca³chá³ ca³la³ jɨ́³² jo³cuo² hí³ dí², hi³ ñi³² tsú² siáh³ hi³ ñí¹con² Dió³² bíh¹ ja³, hi³ jáun² ñí¹con² Dió³² bíh¹ má²tsánh³² dí² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jáun² ca³náu² dí² ñí¹ jmɨ́¹ cuá¹jmu² má³², hi³ ca³chí² hmɨh³² tsɨ³² coh³, hi³ jáun² ca³can³ cáun² hmɨh³² teh¹ hi³ ca³hñéih³ hñeh². ");
INSERT INTO csoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jmɨ́¹jáun² né³ ca³táh³ dí² jmáɨ² cáun² hú³, hi³ jáun² ca³ráɨn³² dí² ta³ tsá² quian³tun³ hí³ joh¹, hi³ jáun² ca³ma³quiéin² dí² siáh³ ta³ tsú² cun³quionh³ hmɨh³² teh¹ hi³ má²hñéih¹ dí² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Tɨ³la³ jmɨ́¹ ca³tɨ³ ñí¹ ren³ dí² ta³ Sí¹mu²¹ Pé¹ né³, Pé¹ hí³ ca³juáh³ la³ lá²: ―Tɨ³², ¿he³ ca³tɨ²¹ sa³ hnú² máh³ ráɨnh¹³ tán² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jáun² Jesús né³ ca³ngáɨ³, hi³ ca³juáh³ la³ lá²: ―Ta³né³² ha³ tiá² ngɨ²³ yáh³ hnú² la³ cun³ hi³ cuá¹jmu² jná¹³ lá², tɨ³la³ ngɨ¹³ bíh¹ nú² nɨ́¹ má¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Tɨ³la³ Pé¹ né³ ca³juáh³ siáh³: ―¡Cun³ tiá² tón³² jmáɨ¹ cué¹³ bíh¹ jná¹³ jáɨ¹³ hi³ hnú² ráɨnh¹³ tán² jná¹³! Jáun² ca³juáh³ siáh³ Jesús: ―Nɨ́¹juáh³ tiá² la³ ren¹ jná¹³ tanh¹ hnú², hi³ jáun² tiú²uú² lɨ́n³ yáh³ hnú² tsá² joh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jmɨ́¹jáun² né³ ca³juáh³ cú²jueh³² Sí¹mu²¹ Pé¹ la³ lá²: ―Hi³ jáun² nɨ́¹juáh³ la³ nɨ́² né³ Tɨ³², jun³juáh¹³ hnó³² jná¹³ hi³ ráɨnh¹³ hnú² jmáh³la³ tán² yáh³ jná¹³, tɨ³la³ jná¹³ hnó³² hi³ ráɨnh¹³ nú² siáh³ la³ jɨ³ uón³² bíh¹ jná¹³ jɨ³ la³ jɨ³ chin³² jná¹³ nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Tɨ³la³ Jesús né³, ca³juáh³ la³ lá²: ―Nɨ́¹juáh³ tsá² cun³ lɨ́²liáuh³, tiú²uú² lin¹ hniáuh³² yáh³ lóh³² tsú² siáh³ cónh³, quí¹ má²jɨn² bíh¹ tsú², jáun² jɨ́³²la³ ta³ bí¹ tsú² jéi³²í¹ hniáuh³² quɨ́³². Quí¹ tsá² má²ná¹jɨn² bíh¹ hnoh², uá¹jinh¹ tiá² la³jɨ́n³² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ca³juáh³ tsú² la³ nɨ́² hi³ tiá² la³jɨ́n³² tsá² hí³ má²ná¹jɨn² yáh³, quí¹hliá² jmɨ́¹ má²ñi³² bíh¹ tsú² hi³ hin² tsánh² tsa³jɨenh³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jmɨ́¹ má²lɨ́²ráɨn³² jáun² Jesús ta³ tsú² né³, ca³quɨh³ siáh³ ha¹ hi³ ca³cuá³ siáh³ ñí¹ mesa, hi³ ca³juáh³ la³ lá²: ―¿Má¹ca³ngɨ¹³ hnoh² he³ hnió³ juáh³ la³ cun³ hi³ má²lɨ́²jmú³² jná¹³ nɨ́²? ");
INSERT INTO csoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Sá¹nɨ́² jɨe³, hnoh² dá² teh³² náh² jná¹³ Tɨ³² jɨ³ hi³ juáh³ náh² siáh³ hi³ Juóuh³² náh² jná¹³; re² bíh¹ la³ cun³ hi³ juáh³ hnoh², quí¹ tson² bíh¹ lɨ́n³ jná¹³ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jáun² né³, nɨ́¹juáh³ jná¹³ má²lɨ́²ráɨn³² ná¹ tanh¹ hnoh², Tsá² lɨ́n³ ná¹ Tɨ³² jɨ³ hi³ lɨ́n³ ná¹ siáh³ Juóuh³² náh², jáun² ja³bí¹ hnoh² uá²jaɨ³² hniáuh³² ráɨnh¹³ náh² ta³ tsá²ján² tsá²ján². ");
INSERT INTO csoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Quí¹ jná¹³ má²lɨ́²có³² cáun² nóh³², hi³ jáun² hnoh² lɨ́¹³ jmúh¹³ la³jmɨ́¹ má²lɨ́²jmú³² nɨ́² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jú¹ tson² juo³ jná¹³ hnoh², hi³ hí¹ jan² yáh³ tsá² lɨ́n³ quian²¹ tiá² tɨ³ jlánh¹ bí¹ quien² la³ cónh³ bíh¹ juo¹³, hi³ sa³jun³ hí¹ jan² yáh³ tsá² zéin¹ tiá² tɨ³ jlánh¹ bí¹ quien² la³ cónh³ bíh¹ tsá² lɨ́²ze³ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jáun² né³, jlánh¹ jmɨ́¹ ren² hnoh² nɨ́¹juáh³ hi³ má²ca³ngɨ¹³ náh² jáɨ¹³ nɨ́², jɨ³ hi³ má¹zián¹³ náh² siáh³ la³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","”Jun³juáh¹³ cuá¹hléh²³ jná¹³ jáɨ¹³ lá² hi³ ca³tɨn¹ la³jɨ́n³² yáh³ hnoh²; quí¹ ño¹ bíh¹ jná¹³ hin² tsánh² ca³quiánh³² ná¹. Quí¹ cun³ ca³tɨ²¹ lɨ³tí³ bíh¹ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí², ñí¹ juáh³ jáun² la³ lá²: “Tsá² cáun² uon² jmɨ́¹ cuh³² quiúnh¹ bíh¹ jná¹³ má²ca³ziáuh³² ta³”. ");
INSERT INTO csoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Juah³² jná¹³ jáɨ¹³ lá² ta³ ñeh³, hi³ jáun² nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ lɨ³tí³, jáun² má¹jáun² má²táunh¹³ náh² ta²¹ hi³ jná¹³ bíh¹ la³². ");
INSERT INTO csoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jú¹ tson² cu³tí³ bíh¹ la³² juah³² jná¹³, hi³ nɨ́¹juáh³ tsá² hen² lɨ³ua³ jan² tsá² zein³² jná¹³, hi³ he² jná¹³ bíh¹ tsú² jaun³²; hi³ jáun² nɨ́¹juáh³ tsá² he² jná¹³ né³, hen² tsú² la³ jɨ³ Tsá² ca³ze³ bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, ca³háuh³² tsɨ́³, hi³ jáun² ca³nia³ bíh¹ dí² cú²jueh³² jáɨ¹³, hi³ ca³juáh³ la³ lá²: ―Jú¹ tson² cu³tí³ bíh¹ juo³ jná¹³ hnoh², hi³ ja¹ quián¹³ náh² nɨ́² zian² jan² tsá² né³bí¹ jɨenh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jmɨ́¹ má²lɨ́²juáh³ tsú² jáun² la³ nɨ́² né³, cáun² lɨ́¹ ca³jɨ́en³ tsá²ján² tsá²ján² bíh¹ tsú², quí¹ tiá² jmɨ́¹ ñi³² yáh³ tsú² hi³ hin² dá² hɨen² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jáun² né³, jan² tsá² quian³tun³ hí³, tsá² jmɨ́¹ hnio³ lɨ́n³² Jesús jmɨ́¹ cuá¹tón²¹ cu³héin¹ hi³ jmɨ́¹ cuá¹jmu² má³², ");
INSERT INTO csoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","hi³ jáun² Sí¹mu²¹ Pé¹ ca³hméih³² ñí¹ tsá² hí³, hi³ hnió³ dí² liéinh³²; hi³ jáun² ca³záɨh³ dí²: ―Ngáɨh³ tiá³ tsú² neh²¹ hin² tsánh² hɨen² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jáun² tsá² hí³ né³ ca³hanh³ tá²cuá¹ Jesús, hi³ ca³juáh³ la³ lá²: ―¿Hin² dá² tsánh² tsá² hí³ né³ Tɨ³²? ");
INSERT INTO csoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jáun² Jesús né³ ca³juáh³ la³ lá²: ―Cuɨ́¹ má¹jlɨh²¹ ná³ cá² cuonh¹ pih²¹ *hí³ cuú²miih²¹, hi³ jáun² nɨ́¹juáh³ hin² tsánh² hiauh³, jáun² tsá² hí³ bíh¹. Ca³ma³jlɨh²¹ bíh¹ tsú² cá² cuonh¹ hí³, jmɨ́¹ lɨ²¹ jáun² né³ Judas jon² Sí¹mu²¹ bíh¹ ca³cuéh³ dí², tsá² ja³ hí³ juú² Queriot. ");
INSERT INTO csoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jáun² la³ cun³ jmɨ́¹ má²lɨ́²héi³ jáun² bíh¹ Judas hí³ jáun², ca³hi³ *Satanás hñu³ tsɨ́³. Jmɨ́¹jáun² né³ ca³juáh³ Jesús ñí¹con² tsú² la³ lá²: ―La³ cun³ hi³ ñi³lɨ́n²³ hnú² jmúh¹³, cuá²jmu³ tia³juɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tɨ³la³ hí¹ jan² yáh³ tsá² jmɨ́¹ ná¹jmu² hí³ má³² quionh³ tsú² tiá² jmɨ́¹ ñi³² he³ ca³tɨ²¹ hi³ ca³juáh³ tsú² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma³ jan² tsáu² cáun² ca³lɨ́n¹³ hi³ Jesús ca³juáh³ hi³ tsa³lia³² Judas la³ cun³ hi³ lɨ³ hniáuh³² jmáɨ¹ bíh¹, ho³lá²dá² hi³ zia³² hi³ cuéh³² tsú² ca³lá² tsá² tia³mii² quí¹ cun³ñí¹ hi³ hí³ bíh¹ jmɨ́¹ nio¹ jo³cuo² tuh³² tioh³ quɨe³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jáun² jmɨ́¹ má²lɨ́²héi³ Judas hí³ jáun² né³, la³juɨ³² cua³han³. Jmɨ́¹ má²niéi² bíh¹ jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jáun² né³, jmɨ́¹ cuá¹han³ Judas ca³juáh³ Jesús la³ lá²: ―Ta³né³² má²lɨ́²lin¹ hi³ quien² jná¹³ Jon² tsá²mɨ³cuóun², jɨ³ hi³ lɨ́²lin¹ siáh³ hi³ quien² Dió³² cun³quionh³ hí³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Hi³ nɨ́¹juáh³ Jon² tsá²mɨ³cuóun² la³ jmu² lin¹ hi³ quien² Dió³², hi³ jáun² ja³bí¹ Dió³² siáh³ ma³jnia² hi³ lin¹ hi³ quien² tsú²; hi³ tia³juɨ³² bíh¹ siáh³ jmu³ tsú² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hnoh² jón³, ha³ tiú²uú² ué³ jmáɨ¹ cuon¹ yáh³ jná¹³ quiúnh¹ hnoh². Má¹jáun² má²hnauh¹³ hnoh² jná¹³, tɨ³la³ la³ cun³ hi³ ca³juo³ jná¹³ jáun² tsá² *judíos tsá² ná¹ñí¹ bíh¹ juah³² jná¹³ siáh³ ñí¹con² hnoh² ta³né³²: Ha³ tiá² lɨ́¹³ yáh³ cuá¹táunh¹ hnoh² ñí¹ ñe¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jáun² jmu² jná¹³ cáun² héih³² hmaɨ²¹ lá² ñí¹con² hnoh²: Hi³ má¹hnáu³ náh² tsá²ján² tsá²ján². La³ nɨ́² bíh¹ hniáuh³² má¹hnáu³ náh² tsá²ján² tsá²ján², ca³la³ jmɨ́¹ hnau³ jná¹³ nɨ́² cu³tí³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Hi³ nɨ́¹juáh³ ca³ma³hnáu³ náh² la³ nɨ́² né³, jáun² tá¹ cáun² hngá¹máh³ bíh¹ lɨ³tsɨn² hi³ hnoh² lɨ́n³ náh² tsá² haɨn²¹ tɨ³ con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jáun² Sí¹mu²¹ Pé¹ né³ ca³ngáɨ³ ñí¹con² Jesús: ―Tɨ³², ¿ha³ dá² jinh¹ cuóh¹³ hnú²? Hi³ jáun² Jesús ca³juáh³: ―Ha³ tiá² lɨ́¹³ yáh³ ñeih²¹ hnú² cu³hna³² jná¹³ ta³né³²; tɨ³la³ tɨ³ chí¹cáɨn² bíh¹ má²lɨ́¹³ ñeih²¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jmɨ́¹jáun² ca³ngáɨ³ Pé¹ hi³ ca³juáh³: ―Tɨ³², ¿he³ láɨh³² tiá² má²lɨ́¹³ ñe¹ jná¹³ cu³hnah³² hnú² né³? Cáun² bíh¹ nio² tsɨn³² jná¹³ uá¹ hi³ jun³ jná¹³ cun³ñí¹ hi³ ca³tɨn¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jáun² Jesús né³ ca³juáh³: ―¿Hí¹ tson² má²nio² cáun² honh² hnú² hi³ jún³ nú² hi³ ca³tɨn¹ jná¹³? Jú¹ tson² cu³tí³ juo³ jná¹³ hnú², hi³ ñeh² bíh¹ hi³ hau³ cá¹háu² juáh¹³ hnú² hnaɨh³² jéin³² hi³ tiá² cuóu³² nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","”Jáun² né³, ha³ lɨ́² tianh³ náh² hi³ ná¹hɨ³² lɨ́n³² honh². Cáun² chá¹ náh² honh² ñí¹con² Dió³², hi³ cáun² chá¹ náh² siáh³ honh² ñí¹con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hliáun³ lɨ́n³² bíh¹ ñí¹ lɨ³ tauh¹³ zia³² hñú¹³ Ñuh³² jná¹³; sá¹jmɨ́¹ hi³ tiá² zia³² dúh¹, jáun² jmɨ́¹ má²lɨ́²juáh³² bíh¹ jná¹³ ñí¹con² hnoh². Jáun² né³, ñih²¹ bíh¹ jná¹³ hi³ ñí¹jmú²¹ hua³jan²¹ ñí¹ cuá¹tianh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nɨ́¹ má¹lɨ³² jáun² né³, jáunh¹³ jná¹³ hi³ já¹cáun³² ná¹ hnoh², hi³ jáun² hnoh² uá²jaɨ³² lɨ́¹³ cuá¹tianh³ ñí¹ ñí¹ñí²¹ jná¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Má²ñi²¹ bíh¹ hnoh² juɨ³² hi³ chau²¹ tɨ³ ñí¹ ñih²¹ jná¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jáun² Tú¹ma²¹ né³ ca³ngáɨ³ la³ lá²: ―Tɨ³², já² tiá² né¹ yáh³ jnoh¹ ha³ dá² jinh¹ cuánh¹³ hnú², ¿ha³ bí¹ lánh³ rón³² lɨ́¹³ né¹ jnoh¹ hín² juɨh³² jaun³²? ");
INSERT INTO csoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jáun² Jesús ca³juáh³ la³ lá²: ―Jná¹³ bíh¹ lɨ́n³ juɨ³², jɨ³ jú¹ tson², jɨ́³²la³ cun³quionh³ jná¹³ bíh¹ lɨ́¹³ zian² tsú² cu³tí³, jɨ³ hi³ lɨ́¹³ siáh³ chanh²¹ tsú² ñí¹ cuá³ Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nɨ́¹juáh³ hi³ má²ca³lɨ³ cuóu³² náh² jná¹³, jáun² lɨ³ cuóun³² bí¹ náh² uá²jaɨ³² Ñuh³² jná¹³; hi³ ta³né³² né³, má²ca³lɨ³ cuóun³² bíh¹ náh² tsú² quí¹ Tsá² má²ca³jɨen¹ bí¹ náh² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jáun² Pí²liéi¹ né³ ca³juáh³: ―Tɨ³², ma³jnia¹³ tiá³ Jméi² dí² ñí¹con² jnoh¹, hi³ jáun² cu³ jáun² bíh¹ má²tioh²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Hi³ jáun² jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Hnú² Pí²liéi¹, ¿jáh³ jmáɨ² tiá² má²tí³ hi³ ngɨ́²³ jná¹³ quiúnh¹ hnoh², hí¹ cun³ jáun² tiá² má²ca³lɨ³ cuóu³² máh³ náh² jná¹³? Quí¹ nɨ́¹juáh³ tsá² má²ca³lɨ³ cuóu³² jná¹³, jáun² má²ca³lɨ³ cuóun³² bíh¹ tsú² siáh³ Ñuh³² jná¹³; jáun² né³ ¿he³ yáh³ láɨh³² mɨh³² hnú² hi³ má¹jnia¹³ jná¹³ Jméi² dí² ñí¹con² náh²? ");
INSERT INTO csoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Há¹ tiá² má²táunh²³ hnoh² ta²¹ dúh¹ hi³ lɨ́n³ bíh¹ jná¹³ la³ cun³ qui³ lɨ́n³ Ñuh³², hi³ Ñuh³² jná¹³ né³, lɨ́n³ siáh³ la³jmɨ́¹ lɨ́n³ jná¹³? Jáun² Ñuh³² jná¹³, Tsá² qui³ lɨ́n³ la³jmɨ́¹ lɨ́n³ jná¹³ bíh¹ jmu² ta²¹ quioh²¹, hi³ jáun² jun³juáh¹³ jáɨ¹³ hi³ lɨ́¹ chin³² chin³² huen² yáh³ jná¹³ hléh²³ ñí¹con² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jáun² tionh² náh² ta²¹ hi³ lɨ́n³ bíh¹ jná¹³ la³ cun³ qui³ lɨ́n³ Ñuh³², hi³ Ñuh³² jná¹³ né³ lɨ́n³ siáh³ la³ jmɨ́¹ lɨ́n³ jná¹³. Tɨ³la³ nɨ́¹juáh³ tiá² la³ nio² cáun² honh² náh² ca³tɨ²¹ hi³ má²lɨ́²juáh³² jná¹³ nɨ́², jáun² tiaunh² náh² ta²¹ jná¹³ cun³ñí¹ hi³ ca³tɨ²¹ la³jɨ́³² hi³ jmu² bíh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jú¹ tson² cu³tí¹³ juo³ jná¹³ hnoh² hi³ lɨ³ua³ jan² tsá² taunh² ta²¹ jná¹³, ja³bí¹ tsá² la³ hí³ uá²jaɨ³² lɨ́¹³ jmu³ la³ cun³ ta²¹ hi³ jmu² jná¹³, hi³ hí¹ la³ tɨ³ ta²¹ hi³ jlánh¹ bí¹ cáu² jueh³² yáh³ lɨ́¹³ jmu³ tsú², quí¹ jná¹³ dá² má²ñih²¹ ñí¹con² Ñuh³² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lɨ³ua³ cáun² hi³ mɨh³² náh² ñí¹con² Ñuh³² jná¹³ cun³quionh³ héih³² quion²¹ jná¹³, jná¹³ bíh¹ cué¹³, hi³ jáun² cun³quionh³ jná¹³ bíh¹ lɨ³ lin¹ hi³ jlánh¹ quien² Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quí¹ jná¹³ bíh¹ tsá² lɨ́¹³ cué¹³ lɨ³ua³ cáun² hi³ mɨh³² náh² cun³quionh³ héih³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","”Nɨ́¹juáh³ hnau³ náh² jná¹³, jáun² ma³ti²¹ náh² héih³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hi³ jáun² jná¹³ né³ mɨ²¹ ñí¹con² Ñuh³² jan² Tsá² ma³hau³ hnoh², Tsá² lɨ́¹³ cuá³² quiúnh¹ hnoh² jmáɨ¹ ca³la³ jɨ́³². ");
INSERT INTO csoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Jmɨ́²chí³ Chun¹ Tsá² hɨe³² jú¹ tson² bíh¹ Tsá² hí³, jan² Tsá² tiá² lɨ́¹³ hen³ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², quí¹ jmɨ́¹lɨ́h³ yáh³ tiá² lɨ́¹³ jɨ́en³² tsú² Tsá² hí³, hi³ sa³jun³ lɨ́¹³ lɨ³ cuóun³² tsú² siáh³ Tsá² hí³. Tɨ³la³ hnoh² má¹ná¹, má²cuóun³² bíh¹ náh² tsú², quí¹hliá² cuá³ tsú² quiúnh¹ hnoh², hi³ la³ cun³ jmɨ́¹hi³nio² bíh¹ cuá³² tsú² siáh³ hñu³ honh² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","”Ha³ tiá² chau²¹ yáh³ jná¹³ hmóu³² hnoh²; jáunh¹³ bí¹ jná¹³ siáh³ hi³ já¹ñí³² quiúnh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ he² hi³ chau²¹ jmáɨ¹ hi³ tiú²uú² jɨ́e³² jná¹³ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², tɨ³la³ hnoh² má¹ná¹ cun³ chau²¹ jmáɨ¹ jɨe¹ bí¹ hnoh² siáh³ jná¹³; hi³ cun³ñí¹ hi³ zian² jná¹³ né³, ja³bí¹ hnoh² uá²jaɨ³² lɨ́¹³ zian² náh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jmáɨ¹ jáun² bíh¹ lɨ³tsɨn² hnoh² hi³ cu³tí³ bíh¹ lɨ́n³ jná¹³ la³jmɨ́¹ lɨ́n³ Ñuh³², hi³ hnoh² né³ lɨ́n¹³ náh² la³ cun³ qui³ lɨ́n³ jná¹³, hi³ jáun² jná¹³ né³ lɨ́n³ la³jmɨ́¹ má²lɨ́n¹³ hnoh² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Lɨ³ua³ jan² tsá² he² héih³² hi³ jmu² jná¹³, jɨ³ hi³ má²tí³² tsú² siáh³, jáun² tsá² la³ hí³ bíh¹ ján¹ tson² hniau³ jná¹³. Hi³ jáun² nɨ́¹juáh³ tsá² hniau³ jná¹³ né³, jáun² Ñuh³² jná¹³ ma³hnio³ siáh³ tsá² hí³; ja³bí¹ jná¹³ siáh³ má¹hno¹ tsú² uá²jaɨ³², jɨ³ hi³ má¹jnia¹³ jná¹³ siáh³ ñí¹con² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jáun² Judas ca³ngáɨ³ la³ lá² (tɨ³la³ jun³juáh¹³ tsá² ja³ hí³ tɨ³ juú² Queriot má¹na²¹): ―Tɨ³², ¿lánh³ bí¹ rón³² lɨ́³ hi³ ñí¹con² jnoh¹ bíh¹ má¹jnia¹³ nú², hi³ tiá² la³ má¹jnia¹³ yáh³ nú² ñí¹con² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³²? ");
INSERT INTO csoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―Nɨ́¹juáh³ tsá² hniau³ jná¹³, jáun² ma³tí³² bíh¹ tsú² la³ cun³ hi³ juah³² jná¹³; hi³ jáun² Ñuh³² jná¹³ né³ ma³hnio³ tsá² hí³, hi³ jná¹³ né³ jáunh¹³ ná¹ quiúnh¹ Ñuh³² hi³ já¹ma³ziáun¹³ jnoh¹ quiúnh¹ tsá² la³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tɨ³la³ lɨ³ua³ jan² tsá² tiá² hniau³ jná¹³, jáun² tiá² má²tí³² yáh³ tsú² jáɨ¹³ hi³ hléh²³ jná¹³. Jun³juáh¹³ quion²¹ huen² yáh³ jná¹³ jáɨ¹³ hi³ naɨh³² hnoh² lá², quí¹ jáɨ¹³ quioh²¹ Ñuh³² Tsá² ca³ze³ bíh¹ jná¹³ la³². ");
INSERT INTO csoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","”Né³² né³, la³jɨ́³² hi³ má²lɨ́²juo³ jná¹³ hnoh², má²lɨ́²hléh³ jná¹³ tá¹la³ cuon¹ jná¹³ lá² ja¹ quián¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Tɨ³la³ nɨ́¹ má¹cuán² jáun² Jmɨ́²chí³ Chun¹, Tsá² ma³hau³ náh², Tsá² zen³ hí³ Jméi² dí² chá³² jná¹³, hí³ bíh¹ ma³ta² hnoh² ca³la³ jɨ́³², jɨ³ hi³ cháu³² tsú² siáh³ honh² náh² la³jɨ́³² la³ cun³ hi³ má²lɨ́²juáh³² jná¹³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”Jáun² né³, la³jmɨ́¹ nio² tie³ hñu³ tsɨn³² jná¹³ jmu¹ jná¹³ hi³ niau²¹ tie³ hñu³ honh² hnoh² siáh³, jun³juáh¹³ la³ qui³ jmu² jáun² tsá² zian² hngá¹máh³ yáh³. Jáun² ha³ lɨ́² cuɨ́¹ hi²¹ honh² náh², hi³ sa³jun³ hniáuh³² lɨ́¹ hú¹ cóh²¹ honh² náh² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Má²lɨ́²niéih² bíh¹ hnoh² hi³ má²lɨ́²juáh³² jná¹³: Ñih²¹ jná¹³ hi³ jáun² jáunh¹³ jná¹³ siáh³ hi³ já¹ñí³² quiúnh¹ hnoh². Sá¹jmɨ́¹ hi³ cu³tí³ bíh¹ má²ca³ma³hnau¹ hnoh² jná¹³ dúh¹, jáun² jmɨ́¹ má²ca³ma³hiúnh¹³ bíh¹ náh² honh² hi³hliá² ñih²¹ jná¹³ ñí¹ cuá³ Ñuh³²; quí¹ hí³ bíh¹ jan² Tsá² tɨ³ jlánh¹ bíh¹ záu² tá¹³ la³ cónh³ bí¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hi³ jáun² bí¹ juanh³² jná¹³ jáɨ¹³ lá² ta³ ñeh³, quí¹ hi³ jáun² nɨ́¹ má¹lɨ³² la³ jáun² né³, má²taunh¹³ náh² ta²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","”Ha³ tiú²uú² hliáun³ jáɨ¹³ hléh¹³ yáh³ jná¹³ quiúnh¹ hnoh², quí¹ má²cuá¹ja³² bíh¹ juo¹³ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³². Tɨ³la³ uá¹jinh¹ hí¹ cáun² pí³ tiá² zia³² yáh³ quioh²¹ tsá² hí³ ñí¹con² jná¹³, ");
INSERT INTO csoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","la³ nɨ́² ca³tɨ²¹ lɨ́¹³ bíh¹, quí¹ hniáuh³² bíh¹ lɨ³tsɨn² tsá² zian² hngá¹máh³ lá² hi³ hno³ jná¹³ Ñuh³² jɨ³ hi³ má²ti²¹ jná¹³ siáh³ la³ cun³ hi³ ca³juáh³ tsú² hi³ jmu¹ ná¹. ”Jáun² nú¹ tianh³ náh², cuɨ́¹ hue¹³ dí² ñí¹ lá². Tá¹la³ hí¹tiáunh¹ tsú² jáun² juɨ³² né³, ca³juáh³ Jesús: ");
INSERT INTO csoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","―Jná¹³ bíh¹ lɨ́n³ la³jmɨ́¹ lɨ́³ hú¹tá¹ mí¹zioh²¹ mɨ³ uóun²jɨeh¹³, hi³ jáun² Ñuh³² jná¹³ né³ lɨ́n³ la³jmɨ́¹ lɨ́n³ tsá² jmu² hua³hí¹³ hi³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Jáun² nɨ́¹juáh³ zia³² cáun² chí² cuoh² quion²¹ jná¹³ hi³ tiá² máɨ³ háɨ³², hí³ bíh¹ quieih³²; tɨ³la³ nɨ́¹juáh³ hi³ háɨ³² máɨ³ né³, chú² huen² bíh¹ tsú² chí² cuoh² pih²¹ siún¹ hi³ lɨ́¹ hí¹quí² hí¹jnáɨ²³, hi³ jáun² tɨ³ hliáun³ máɨ³ ha³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Má²ná¹jɨn² bíh¹ hnoh² cun³quionh³ jáɨ¹³ hi³ má²ca³ma³ta¹³ jná¹³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Cuɨ́¹ ná¹quiun² náh² re² quiúnh¹ jná¹³ la³jɨ́³² jmáɨ¹, hi³ jáun² la³ má²chí¹cunh² jáun² bíh¹ jná¹³ quiúnh¹ hnoh² lɨ́¹³. Ha³ tiá² lɨ́¹³ yáh³ ha³ máɨ³ cáun² chí² cuoh² ta³ rón³² tɨ³ có³², quí¹ nɨ́¹juáh³ tiú²uú² la³ chí¹hma² yáh³ quionh³ mí¹zioh²¹; la³ jáun² bíh¹ uá²jaɨ³² lɨ́³ ñí¹con² hnoh², nɨ́¹juáh³ tiá² la³ ná¹cunh² yáh³ náh² tián³ quiúnh¹ jná¹³, jáun² tiá² lɨ́¹³ yáh³ lɨ́n³ hnoh² la³jmɨ́¹ lɨ́³ chí² cuoh² háɨ³² máɨ³ chu²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”Quí¹ jná¹³ bíh¹ lɨ́n³ ná¹ la³jmɨ́¹ lɨ́³ mí¹zioh²¹, hi³ jáun² hnoh² né³ lɨ́n³ náh² cuú²ñeh¹ uóun². Hi³ jáun² bíh¹ nɨ́¹juáh³ tsá² ná¹cunh² tián³ quiúnh¹ jná¹³, hi³ jná¹³ né³ ná¹cunh² ná¹ siáh³ quiúnh¹ tsú², hi³ jáun² tsá² la³ hí³ bíh¹ lɨ́n³ la³jmɨ́¹ lɨ́³ chí² cuoh² hi³ háɨ³² hliáun³ máɨ³ chu²¹; quí¹ hí¹ cáun² yáh³ tiá² hi³ lɨ́¹³ jmúh¹³ hnoh² nɨ́¹juáh³ tiá² quiúnh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Lɨ³ua³ jan² tsá² tiá² ná¹cunh² quiúnh¹ jná¹³, quiunh²¹ tsú² la³jmɨ́¹ quiunh³² jáun² chí² cuoh² tiá² máɨ³ háɨ³², tɨ³ cheih³² bíh¹ tsa³cuɨ́³², hi³ jáun² ñí¹ jáun² lɨ³ quiéin²; hi³ má¹lɨ³² jáun² né³, ziu³ liáuh³² tsú² siáh³ hi³ tóh³² ja¹ sɨ́², hi³ jáun² có³². ");
INSERT INTO csoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","”Nɨ́¹juáh³ la³ má²ná¹cunh² jáun² náh² quiúnh¹ jná¹³, jɨ³ hi³ hu²¹ siáh³ jáɨ¹³ quion²¹ jná¹³ hñu³ honh² náh², jáun² mɨ́¹ náh² lɨ³ua³ cáun² hi³ hnáuh², hi³ jáun² hian³ náh². ");
INSERT INTO csoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Quí¹ cun³quionh³ hi³ ná¹lɨ́n³ hnoh² la³jmɨ́¹ lɨ́³ chí² cuoh² háɨ³² hliáun³ máɨ³ chu²¹ bíh¹ ma³quien² tsáu² Ñuh³² jná¹³, hi³ jáun² la³ jáun² bíh¹ má²lɨ́n³ náh² tsá² cu³tí³ haɨn²¹ tɨ³ con² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hnau³ lɨ́n³² bíh¹ jná¹³ hnoh² la³jmɨ́¹ hniau³ jáun² jná¹³ Ñuh³²; jáun² ma³zián¹³ náh² la³ cun³ ca³tɨ²¹ ma³zian² tsá² hno³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Quí¹ nɨ́¹juáh³ má¹tih²¹ náh² la³ cun³ héih³² hi³ jmu² jná¹³, jáun² má¹zián¹³ bí¹ náh² la³ cun³ qui³ ca³tɨ²¹ hi³ ma³zian² tsá² hno³ jná¹³, la³jmɨ́¹ zian² jná¹³ la³ cun³ qui³ ca³tɨ²¹ hi³ zian² jan² tsá² hnio³ Ñuh³² jná¹³ hi³hliá² ma³ti²¹ jná¹³ héih³² hi³ jmu² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","”Hlɨ́¹ lieh¹ jná¹³ hnoh² la³ nɨ́² hi³ jáun² lɨ³ hiún² honh² náh² la³jmɨ́¹ hiún² tsɨn³² jná¹³, hi³ jáun² la³ nɨ́² bíh¹ lɨ́¹³ hi³ lɨ³ hiún² honh² náh² tán¹ hián² cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","La³ lá² bíh¹ lɨ́³ héih³² hi³ jmu² jná¹³: Ma³hno¹ náh² tsá²ján² tsá²ján² la³jmɨ́¹ hnau³ jná¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jáun² né³, jmɨ́¹lɨ́h³ bíh¹ tiá² chánh³² jan² tsá² tɨ³ jlánh¹ bíh¹ hnio³ há²mei²¹ joh¹ la³ cónh³ bíh¹ tsá² cué³² jmɨ́²chí³ quioh²¹ cun³ñí¹ hi³ ca³tɨn¹ há²mei²¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Hnoh² bíh¹ lɨ́n³ náh² há²mei²¹ joh² jná¹³ nɨ́¹juáh³ hi³ ma³tih²¹ náh² la³ cun³ héih³² hi³ jmu² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tiú²uú² juah²¹ yáh³ jná¹³ hi³ hnoh² ná¹lɨ́n³ náh² tsá² quian²¹, quí¹ tsá² lɨ́n³ quian²¹ tiá² hi³ ñi³² hí¹ cáun² yáh³ la³ cun³ hi³ jmu² juo¹³. Jáun² dá² há²mei²¹ joh² bíh¹ jná¹³ má²ná¹lɨ́n³ hnoh² juah³² jná¹³, quí¹ má²ca³ma³ta¹³ bíh¹ jná¹³ hnoh² ca³la³ jɨ³lɨ³² la³ cun³ hi³ má²ca³hɨ́e³ jná¹³ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Quí¹ jun³juáh¹³ hnoh² yáh³ ca³quianh²¹ náh² jná¹³, quí¹ jná¹³ bíh¹ tɨ³ ca³quiánh³² ná¹ hnoh², hi³ jáun² bíh¹ má²ca³cháu³² jná¹³ hnoh² hi³ má¹zián¹³ náh² hi³ chun¹ náh²; hi³ hi³ chun¹ náh² jáun² né³, lɨ³ quien² la³ má²quien² jáun². Hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ cué³² Ñuh³² jná¹³ lɨ³ua³ cáun² hi³ mɨ́h¹³ náh² cun³quionh³ héih³² quion²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Hi³ jáun² la³ nɨ́² bíh¹ lɨ́³ héih³² hi³ jmu² jná¹³, hi³ má¹hnáu³ náh² tsá²ján² tsá²ján² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","”Nɨ́¹juáh³ hi³ ca³lɨ³hau² náh² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², cháu¹ náh² honh² hi³ jná¹³ bíh¹ tín² ca³lɨ³hau² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tɨ³la³ sá¹jmɨ́¹ hi³ hnoh² lɨ́n³ náh² uá²jaɨ³² tsá² zian² náh² cun³ tɨn² tsɨ́³ hmóu³² dúh¹, hi³ jáun² jmɨ́¹ ma³hniau³ lɨ́n³² bíh¹ tsú² hnoh² la³ cun³ qui³ hnio³ tsú² tsá² raɨnh²¹. Tɨ³la³ jná¹³ bíh¹ ca³quiánh³² ná¹ hnoh² ja¹ quioh²¹ tsá² la³ hí³, hi³ jáun² dá² má²hau² bíh¹ tsú² hnoh² ta³né³², quí¹hliá² tiú²uú² lɨ́n³ yáh³ hnoh² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cháu¹ náh² honh² la³ cun³ hi³ má²lɨ́²juáh³² jná¹³ jáun²: Hí¹ jan² yáh³ tsá² lɨ́n³ quian²¹ tiá² tɨ³ jlánh¹ bíh¹ quien² la³ cónh³ bíh¹ juo¹³. Nɨ́¹juáh³ jná¹³ la³ jmoh²³ tsú² hian² tsɨ́³, ja³bí¹ la³ jáun² bíh¹ siáh³ jmoh³ tsú² hnoh²; nɨ́¹juáh³ la³ má²ca³ma³tí³² tsú² la³ cun³ jáɨ¹³ hi³ ca³ma³tɨn¹³ jná¹³, jáun² ja³bí¹ la³ jáun² bíh¹ siáh³ ma³tí³² tsú² jáɨ¹³ hi³ hɨeh¹ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","La³jɨ́³² hi³ nɨ́² né³ jmu³ tsú² cun³ñí¹ hi³ haɨn²¹ hnoh² tɨ³ con² jná¹³ bíh¹, quí¹hliá² tiá² cuóun³² yáh³ tsú² Tsá² ca³ze³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","”Tiá² tso³ jmɨ́¹ la³ ho² yáh³ tsú² sá¹jmɨ́¹ hi³ tiá² cuan³ jná¹³ hi³ cua³hlɨ́¹ cuá¹lienh¹ ná¹ tsú². Tɨ³la³ ta³né³² né³, tiú²uú² zia³² yáh³ he³ cun³quionh³ lɨ́¹³ jlɨ́³ tsú² tsáu¹³; ");
INSERT INTO csoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","quí¹ nɨ́¹juáh³ hau² tsú² jná¹³, jáun² la³ jɨ³ Ñuh³² bíh¹ jná¹³ hon² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tiá² tso³ jmɨ́¹ la³ ho² yáh³ tsú² sá¹jmɨ́¹ hi³ tiá² má²cá²jmú³² jná¹³ ja¹ quioh²¹ tsú² la³ cun³ hi³ hí¹ jan² tiá² hin² má²ca³jmú³; tɨ³la³ má²ca³jɨ́e³ bíh¹ tsú² la³jɨ́³² hi³ jáun², hi³ cun³ jáun² hau² bíh¹ tsú² jná¹³ quiúnh¹ Ñuh³². ");
INSERT INTO csoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Tɨ³la³ la³ nɨ́² dá² ná¹lɨ́²³ quí¹ jáun² lɨ³tí³ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ liei²¹ quioh²¹ tsú² hmóu³² bíh¹, ñí¹ rá¹juáh³ jáun² la³ lá²: “Cáun² lɨ́¹ ca³lɨ³hau² bíh¹ tsú² jná¹³ ta³ tiá² lin¹ hi³ lɨ³”. ");
INSERT INTO csoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","”Má²ja³quián³ já³² bíh¹ Jmɨ́²chí³ Chun¹, Tsá² já³² hí³ ñí¹con² Ñuh³² jná¹³, Tsá² qui³ má²hau³ hí³, jɨ³ hi³ hɨe³² siáh³ jú¹ tson². Jáun² nɨ́¹ má¹cuán² tsú² né³, lɨ́n¹³ tsú² Tsá² nau³² jáɨ¹³ hi³ ca³tɨn¹ jná¹³. Tsá² hí³ zein²¹ jná¹³ hi³ já³² la³ tɨ³ ñí¹con² Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ja³bí¹ hnoh² siáh³ cuéh¹ náh² jú¹ tson² hi³ ca³tɨn¹ jná¹³, quí¹ la³ cun³ jmɨ́¹ ca³lɨ³liau³ bíh¹ tionh² hnoh² quiúnh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","”Jáun² né³, má²lɨ́²juáh³² jná¹³ jáɨ¹³ nɨ́² hi³ jáun² tiá² lɨ́¹³ tá¹tonh¹ náh² tɨ³ có³² hi³ ca³tɨn¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Quí¹ chu³ hue³ tsú² hnoh² hñu³ cuáh³² quioh²¹ tsá² *judíos, hi³ hí¹ la³ tɨ³ chau²¹ jmáɨ¹ hi³ lɨ³ua³ jan² tsá² jngah³ hnoh² lɨ́n¹³ hi³ cun³quionh³ la³ jáun² jmu² cáun² ta²¹ chu²¹ ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","La³ nɨ́² bíh¹ jmu³ tsú² quí¹hliá² cun³ tiá² ca³lɨ³ cuóun³² bíh¹ tsú² Ñuh³² jná¹³, sa³jun³ jná¹³ yáh³ ca³lɨ³ cuóu³² tsú² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jáun² bíh¹ má²lɨ́²juáh³² jná¹³ la³ nɨ́² ta³ tin², quí¹ jáun² chau¹³ honh² náh² nɨ́¹ má¹cá²chó³² jmáɨ¹ hi³ jmoh³ tsú² hnoh² la³ má²lɨ́²juáh³² jná¹³ nɨ́². ”Jáun² bíh¹ tiá² cá²juáh³² jná¹³ jáɨ¹³ nɨ́² la³ cun³ jmɨ́¹tin², quí¹ jmɨ́¹ cuon¹ bíh¹ jná¹³ quiúnh¹ hnoh²; ");
INSERT INTO csoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","tɨ³la³ ta³né³² má¹ná¹, má²ñih²¹ bíh¹ jná¹³ hi³ ñí¹ñí²¹ ná¹ quiúnh¹ Tsá² ca³ze³. Hi³ uá¹jinh¹ má²lɨ́²juáh³² jná¹³ la³ nɨ́² né³, hí¹ jan² yáh³ hnoh² tiá² ngaɨh³² náh² hi³ ha³ jinh¹ ñih²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Hnoh² dá² cáun² lɨ́¹ má²lɨ́²cháh¹ hlah³ honh² bíh¹ quí¹hliá² lɨ́²juáh³² jná¹³ la³ nɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jáun² né³, juah³² jná¹³ cáun² jú¹ tson² lá²: Tɨ³ jlánh¹ re² bíh¹ quián¹³ hnoh² nɨ́¹juáh³ hi³ ñih²¹ jná¹³; quí¹ sá¹jmɨ́¹ hi³ tiá² ñih²¹ jná¹³, jáun² tiá² jmɨ́¹ lɨ́¹³ yáh³ já³² Tsá² ma³hau³ hnoh². Tɨ³la³ nɨ́¹ má¹ngah³² jná¹³ né³, jáun² ñí¹zéin²¹ bíh¹ jná¹³ Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hi³ jáun² nɨ́¹ má¹cuán² Tsá² hí³ né³, jmu³ hi³ lɨ³tsɨn² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³² hi³ tson² bíh¹ ná¹ren² tsú² tso³, hi³ lɨ³tsɨn² siáh³ hi³ zia³² cáun² juɨ³² chu²¹, jɨ³ hi³ lɨ³tsɨn² tsú² siáh³ hi³ tá¹tsɨn¹ héih³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jmu³ tsú² hi³ lɨ³tsɨn² tsá² hí³ hi³ ná¹ren² tso³, quí¹ tiá² ta²¹ taunh² yáh³ tsú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jáun² né³, lɨ³tsɨn² tsú² he³ lánh³ lɨ́³ juɨ³² chu²¹, quí¹ jná¹³ dá² má²ñih²¹ ñí¹ cuá³ Ñuh³² bíh¹, hi³ jáun² hnoh² né³ tiú²uú² lɨ́¹³ yáh³ jɨe¹ náh² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Lɨ³tsɨn² tsú² siáh³ hi³ tá¹tsɨn¹ héih³², quí¹ má²ca³ta³tsɨn¹ bíh¹ héih³² juo¹³ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”Zia³² bíh¹ hliáun³ lɨ́n³² hi³ jmɨ́¹ lɨ³ juah²¹ jná¹³ ñí¹con² hnoh², tɨ³la³ má²tioh²¹ bíh¹ cu³ nɨ́² ta³né³², quí¹ tiá² tú¹ tiá² tsɨn¹³ yáh³ hnoh² hi³ táunh¹³ chinh³² jɨ³lɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tɨ³la³ tiá² hi³ jmu³ yáh³, quí¹ nɨ́¹ má¹cuán² Jmɨ́²chí³ Chun¹, Tsá² hɨe³² hí³ jú¹ tson², hí³ bíh¹ hɨ́e³² la³jɨ́³² jú¹ tson² ñí¹con² hnoh²; quí¹ Tsá² hí³ tiá² hléh³² yáh³ hi³ lɨ́¹ chin² chí¹ hnga², tɨ³la³ hí³ dá² hléh³² la³ cun³ hi³ náɨ³² bíh¹, hi³ hɨ́e³² tsú² siáh³ la³jɨ́³² la³ cun³ hi³ né³bí¹ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tsá² hí³ dá² ma³quien² jná¹³ quí¹hliá² jë² jná¹³ bíh¹ cán³ tsú² hi³ záɨ³² tsú² siáh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Quí¹ la³jɨ́³² bíh¹ la³ cun³ hi³ quioh²¹ Ñuh³² jná¹³ quion²¹ jná¹³ uá²jaɨ³²; hi³ jáun² bíh¹ juah³² jná¹³ hi³ jë² jná¹³ bíh¹ cán³ Jmɨ́²chí³ Chun¹ hi³ jáun² zaɨ³² tsú² siáh³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","”Cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ he², hi³ jáun² má¹jáun² tiú²uú² lɨ́¹³ jɨe¹ hnoh² jná¹³; tɨ³la³ tɨ³ chí¹cáɨn² pih²¹ jáun² né³, lɨ́¹³ bíh¹ jɨe¹ náh² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jmɨ́¹jáun² ma³ jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú² ca³ngáɨh³ raɨnh²¹ tsá²ján² tsá²ján²: ―¿He³ dá² hnió³ niéih³ jáɨ¹³ hi³ ñí¹juah²¹ tsú² nɨ́² hi³ cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ he² hi³ jáun² má¹jáun² tiú²uú² neh²¹ dí² tsú², hi³ cú¹pih²¹ jmáɨ¹ bíh¹ siáh³ tsa³jau² hi³ jáun² má²neh²¹ dí² tsú² siáh³; hi³ ñí¹juah²¹ tsú² siáh³ hi³ ñí¹ cuá³ Jméi² néh¹ dí² má²ja³quián³ tsánh³²? ");
INSERT INTO csoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿He³ dá² hnió³ juáh³ jaun³²: “Ñí¹ cú¹pih²¹ jmáɨ¹”? Já² tiá² ngɨ²³ yáh³ dí² he³ dá² nɨ³² ñí¹juah²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ca³lɨ³lieih²¹ bíh¹ Jesús hi³ jmɨ́¹ hnió³ tsá² hí³ nga³ ñí¹con² dí², hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Jná¹³ má²lɨ́²juáh³² hi³ cú¹pih²¹ jmáɨ¹ bíh¹ jéi³²í¹ he² hi³ jáun² má¹jáun² tiú²uú² lɨ́¹³ jɨe¹ náh² jná¹³, hi³ tɨ³ chí¹cáɨn² pih²¹ jáun² né³ má²lɨ́¹³ jɨe¹ náh² siáh³. ¿Hí¹ hi³ nɨ́² uá¹ hi³ jlánh¹ ná¹quí² ná¹ngaɨh³² náh² ja¹ má²tún² hmóu³²? ");
INSERT INTO csoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jná¹³ juah³² hi³ cu³tí³ bíh¹ uóh¹ hnoh² hi³ niau²¹ hlah³ honh² náh², tɨ³la³ tsá² hau² jná¹³ né³, ma³hiún² tsɨ́³ bíh¹. Tɨ³la³ cun³ jáun² uá¹jinh¹ hnoh² niau²¹ hlah³ honh², chau²¹ bíh¹ jmáɨ¹ hi³ lɨ³ hiún² lɨ́n³² honh² náh² cha³ jmɨ́¹ niau²¹ hlah³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jmú¹³ jáɨ¹³: Nɨ́¹juáh³ jan² tsá²mɨ³ la³ má²cá²chó³² jmáɨ¹ hi³ lɨ³zian² jon², jáun² hlah³ lɨ́n²¹ bíh¹ má²nio² tsɨ́³ tsú² quí¹hliá² má²cá²chó³² jmáɨ¹ hi³ quɨeh² héin¹; tɨ³la³ nɨ́¹juáh³ má²ca³lɨ³zian² jon² tsú² né³, ca³la³ hí¹juáh³ tiú²uú² chau² bíh¹ tsɨ́³ tsú² hi³ ca³quɨeh² jáun² héin¹, quí¹hliá² jlánh¹ tsah³ tsú² hi³ má²ca³lɨ³zian² siáh³ cónh³í¹ jan² dáɨn² ñí¹ hué²¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","La³ jáun² bíh¹ siáh³ ná¹má²tsoh¹ hnoh² honh² ta³né³²; tɨ³la³ nɨ́¹ má¹já²jɨe¹ jná¹³ siáh³ hnoh² né³, má¹jáun² bí¹ jlánh¹ lɨ³ hiún² honh² náh² ca³la³ tán¹ hián² cu³tí³, cáun² hi³ hí¹ jan² tiú²uú² hin² lɨ́¹³ quin³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","”Má¹jáun² bí¹ ján¹ tson² hí¹ cáun² yáh³ tiú²uú² hi³ mɨ́h¹³ hnoh² ñí¹con² jná¹³. Quí¹ jú¹ tson² juah³² jná¹³, hi³ lɨ³ua³ cáun² hi³ mɨ́h¹³ náh² ñí¹con² Jméi² dí² cun³quionh³ héih³² quion²¹ jná¹³, hian³ bí¹ náh². ");
INSERT INTO csoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Quí¹ hí¹ cáun² bíh¹ hi³ tiá² má²lɨ́²mɨ́h¹ hnoh² cun³quionh³ héih³² quion²¹ jná¹³ la³ tɨ³ ta³né³²; mɨ́¹ náh² hi³ jáun² hian³ náh², hi³ jáun² lɨ́¹³ lɨ³ hiún² honh² náh² ca³la³ tán¹ hián² cu³tí³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”Né³² né³, jná¹³ má²ca³lieh¹ ná¹ hnoh² cun³quionh³ jú¹ jnɨ²; tɨ³la³ chau²¹ bíh¹ jmáɨ¹ hi³ tiú²uú² jmu¹ jná¹³ la³ nɨ́², má¹jáun² dá² má²hléh¹³ jná¹³ tá²na²¹ cu³tí¹³ bíh¹ hi³ ca³tɨn¹ Ñuh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Jmáɨ¹ jáun² né³, má²mɨ́h¹ hnoh² cun³quionh³ héih³² quion²¹ jná¹³; tɨ³la³ má¹jáun² né³ tiú²uú² mɨ́¹³ yáh³ jná¹³ ñí¹con² Ñuh³² hi³ ca³tɨn¹ hnoh², ");
INSERT INTO csoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","quí¹ qui³ cónh³ hniau³ lɨ́n³² bíh¹ hnga² Ñuh³² jná¹³ hnoh². Hniau³ tsú² quí¹ cun³ñí¹ hi³ hnau³ hnoh² jná¹³ bíh¹, jɨ³ hi³ má²ca³tionh² náh² siáh³ ta²¹ hi³ jná¹³ ja³ ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jmɨ́¹ ca³tɨ³ ñí¹ já¹³ jná¹³ ñí¹ hué²¹ lá², cua³han³ jná¹³ ñí¹con² Ñuh³² bíh¹, hi³ jáun² dá² ñí¹con² Ñuh³² bíh¹ jná¹³ má²ñih²¹ siáh³ ta³né³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Hi³ jáun² tsá² haɨn²¹ hí³ tɨ³ con² tsú² né³ ca³juáh³: ―Ta³né³² ján¹ tson² má²dí¹hléh¹ hnú² tá²na²¹ cu³tí¹³, hi³ tiú²uú² dí¹hléh¹ yáh³ nú² jú¹ jnɨ². ");
INSERT INTO csoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ta³né³² má²lɨ́²neh²¹ jnoh¹ hi³ la³jɨ́³² bíh¹ la³ ñíh¹ hnú², hi³ hí¹juáh³ tiá² lin¹ lɨ³hniauh²³ yáh³ hi³ zian² tsá² zia³² hi³ nga³ ñí¹con² hnú². Cun³ñí¹ hi³ jáun² bíh¹ má²nio² cáun² tsɨ́³ jnoh¹ hi³ hnú² ñeh³ nú² ñí¹con² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jmɨ́¹jáun² ca³ngáɨ³ Jesús la³ lá²: ―¿Hí¹ jáun² né³bí¹ má²táunh²³ máh³ hnoh² ta²¹? ");
INSERT INTO csoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Né³² né³, má²cá²chó³² bíh¹ jmáɨ¹ hi³ ta³né³² bíh¹ cánh³² má²han³ náh² ma³ quin³², hi³ ma³ quin³² ma³ jan³² náh² cuá¹táunh¹ náh² juɨ³² quián¹³, hi³ jáun² huen² bíh¹ jná¹³ má²zeh¹³ náh²; tɨ³la³ tiá² huen² jná¹³ zenh² yáh³ má¹ná¹, quí¹ zenh² bíh¹ Ñuh³² jná¹³ quiúnh¹ ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Juah³² jná¹³ la³jɨ́³² jáɨ¹³ nɨ́² ñí¹con² hnoh² hi³ jáun² lɨ́¹³ nio² tie³ hñu³ honh² náh² cun³ñí¹ hi³ ná¹cunh² náh² quiúnh¹ jná¹³. Hnoh² dá² ca³tɨn¹ má¹tsoh¹ honh² la³ cun³ hi³ jmu² tsá² hon² Dió³², tɨ³la³ tiá³ chá¹ náh² honh², quí¹ má²ca³cah¹ bíh¹ jná¹³ jmáɨ¹ ñí¹con² tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, ca³ziauh³ ñí¹ chi³cuú², hi³ ca³juáh³ la³ lá²: ―Tia²¹, má²cá²chó³² bíh¹ jmáɨ¹; ma³quien¹³ hnú² Jónh³², hi³ jáun² Jónh³² hnú² siáh³ lɨ́¹³ ma³quien² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Quí¹ huen² bíh¹ hnú² má²ca³jmuh³ hi³ Jónh³² hnú² ho² ta²¹ ñí¹con² la³jɨ́n³² tsáu², hi³ jáun² lɨ́¹³ jmu¹ jná¹³ hi³ lɨ́¹³ zian² tsáu² la³ cun³ jmɨ́¹hi³nio², ca³la³ jɨ́n³² tsá² má²ca³chan²¹ hnú² jo³uón³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hi³ zian² tsú² jáun² cun³ jmɨ́¹hi³nio² dá² lɨ́³ la³ lá²: hi³ cuóu³² tsú² hnú² bíh¹, Tsá² cú²huen² tán¹ nú², Tsá² hú¹tá¹ lɨ́n³ Dió³²; jɨ³ hi³ cuóu³² tsú² jná¹³ nɨ́² siáh³, Jesús, Tsá² lɨ́n³ ná¹ Cristo, Tsá² ca³zen² hnú² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","”Má²lɨ́²ma³quien¹³ bíh¹ jná¹³ hnú² ñí¹ hué²¹ lá², hi³ má²lɨ³² bí¹ siáh³ la³jɨ́³² hi³ ca³juah²¹ hnú² hi³ jmu¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Né³² né³ Tia²¹, ma³quien¹³ siáh³ jná¹³ ñí¹ hó²¹máh¹ nú² la³ cun³ qui³ jmɨ́¹ quien² jná¹³ jáun² jmɨ́¹tin², jmɨ́¹ ñeh² bíh¹ hi³ lɨ́¹³ tá¹ cáun² mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”Má²ca³ma³jnia¹³ bíh¹ jná¹³ hi³ hin² tsánh² hnú² ñí¹con² tsá² má²ca³quianh²¹ hnú² ja¹ tsá² zian² hngá¹máh³ lá², tsá² má²ca³chan²¹ hnú² jo³uón³² jná¹³. Tsá² jmɨ́¹ joh² bíh¹ hnú² hí³ hi³ ca³cuen²¹ nú² jná¹³, hi³ má²ca³ma³tí³² bíh¹ tsú² siáh³ jëh² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Hi³ jáun² dá² má²ñi³² bíh¹ tsú² ta³né³² hi³ la³jɨ́³² bíh¹ hi³ quion²¹ jná¹³ ja³ tɨ³ ñí¹con² hnú²; ");
INSERT INTO csoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","quí¹ má²ca³juo³ bíh¹ jná¹³ tsú² la³jɨ́³² jáɨ¹³ hi³ ca³cuéh¹ hnú² jáun² ñí¹con² jná¹³, jáun² má²ca³héi³ bíh¹ tsú². Hi³ jáun² má²ca³lɨ³tsɨn² bíh¹ tsú² hi³ tson² bíh¹ cu³tí³ ja³ jná¹³ ñí¹con² hnú², hi³ jáun² má²taunh³² tsú² ta²¹ hi³ hnú² bíh¹ ca³ze² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”Jáun² né³, jná¹³ hiú² mɨ́²³ ñí¹con² hnú² hi³ ca³tɨn¹ tsá² hí³ bíh¹, ha³ tiá² hiú² mɨ́²³ yáh³ jná¹³ hi³ ca³tɨn¹ tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², tɨ³la³ mɨ́²³ jná¹³ hi³ ca³tɨn¹ tsá² ca³chan²¹ hnú² jo³uón³² bíh¹ jná¹³, quí¹ tsá² joh² hnú² bíh¹ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Quí¹ la³jɨ́³² bíh¹ la³ cun³ hi³ quion²¹ jná¹³ quián¹³ hnú², hi³ jáun² la³jɨ́³² bíh¹ siáh³ la³ cun³ hi³ quián¹³ hnú² quion²¹ jná¹³ uá²jaɨ³². Hi³ jáun² né³, cun³quionh³ tsá² hí³ bíh¹ má²lin¹ hi³ quien² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","”Ha³ tiú²uú² ñi²¹ yáh³ jná¹³ ñí¹ hué²¹ lá², tɨ³la³ tsá² nɨ́² né³ tá¹tonh¹ bíh¹; quí¹ jná¹³ dá² má²jáunh¹³ bíh¹ hi³ ñí¹ñí²¹ quiúnh¹ hnú². Jáun² né³, hnú² Tia²¹ Tsá² chun¹, cun³quionh³ pí³ hi³ hauh³² nú² jmu³ hua³hí¹³ tsú² la³ cun³ hi³ ca³cuéh¹ nú² jáun² jná¹³ uá²jaɨ³², hi³ jáun² lɨ́¹³ tionh² tsú² cá²hon³ la³jmɨ́¹ tiauh² dí² quiúnh¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Quí¹ tá¹la³ ca³ngɨ́³ jná¹³ jáun² quiúnh¹ tsú², ca³jmú³² bíh¹ jná¹³ hua³hí¹³ tsú² cun³quionh³ jáɨ¹³ hi³ ho² jná¹³ hi³ ca³cuéh¹ hnú² jáun². La³ nɨ́² bíh¹ ca³jmú³² jná¹³ hua³hí¹³, hi³ jáun² hí¹ jan² yáh³ tiá² já²hín³, jɨ́³²la³ tsá² qui³ ca³tɨn¹ hi³ tsa³hín³ bíh¹ já¹hín³, hi³ jáun² ca³lɨ³tí³ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí². ");
INSERT INTO csoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”Jáun² ta³né³² má²jáunh¹³ jná¹³ ñí¹ ñíh³ hnú² bíh¹; tɨ³la³ juah³² jná¹³ jáɨ¹³ nɨ́² tá¹la³ cuon¹ ná¹ ñí¹ hué²¹ lá², hi³ jáun² tsá² tá¹tonh¹ lá² lɨ́¹³ lɨ³ hiún² tsɨ́³ ca³la³ tán¹ hián² cu³tí³ la³jmɨ́¹ hiún² tsɨn³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Má²ca³ma³tɨn¹³ bíh¹ jná¹³ tsú² jëh² hnú², tɨ³la³ tsá² zian² hí³ cun³ tɨn² tsɨ́³ hmóu³² né³, tiá² quiú² tiá² jéin²³ yáh³ tsú² quí¹ cun³ñí¹ hi³ tiú²uú² jmu² yáh³ tsú² la³jmɨ́¹ jmu² tsá² hí³, quí¹ sa³jun³ jná¹³ yáh³ zian² ná¹ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ha³ tiá² hiú² mɨ́²³ yáh³ jná¹³ hi³ huen¹³ nú² tsú² ja¹ quioh²¹ tsá² zian² ñí¹ hué²¹ lá², ñí¹ jɨ́²¹la³ mɨ́²³ jná¹³ hi³ jmúh¹³ nú² tsú² hua³hí¹³ ca³tɨn¹ tsá² hláɨnh¹ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Quí¹ la³jmɨ́¹ tiá² zian² jná¹³ la³ cun³ qui³ zian² jáun² tsá² jmu² cun³ tɨn² tsɨ́³ hmóu³², hi³ jáun² sa³jun³ tsá² nɨ́² yáh³ siáh³ zian² la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Hi³ jáun² né³, jmu³ hi³ lɨ́¹³ ná¹chan¹ tsú² ñí¹con² nú² huen² cun³quionh³ jú¹ tson², quí¹ jáɨ¹³ quián¹³ hnú² dá² lɨ́³ jmáh³la³ jú¹ tson² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jáun² né³, la³jmɨ́¹ ca³ze² nú² jná¹³ ja¹ tsá² zian² hngá¹máh³ lá², la³ jáun² bí¹ siáh³ zein³² jná¹³ tsá² lá² ja¹ tsá² hí³ uá²jaɨ³². ");
INSERT INTO csoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hi³ cun³ñí¹ hi³ ca³tɨn¹ tsá² lá² bíh¹ jmu² jná¹³ siáh³ cuá¹chan¹ ná¹ huen², quí¹ hi³ jáun² tsá² lá² uá²jaɨ³² lɨ́¹³ ná¹chan¹ cun³quionh³ jú¹ tson². ");
INSERT INTO csoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”Tɨ³la³ tiá² mɨ́²³ yáh³ jná¹³ jmáh³la³ hi³ ca³tɨn¹ tsá² lá², quí¹ mɨ́²³ jná¹³ la³ jɨ³ hi³ ca³tɨn¹ tsá² taunh¹³ jná¹³ ta²¹ nɨ́¹ má¹ca³náɨ³² jú¹ chú³² hi³ hléh³² tsá² lá² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mɨ́²³ jná¹³ ñí¹con² hnú² hi³ cu³tí³ cuɨ́¹ tionh¹ tsú² cá²hon³ jɨ³lɨn². Hnú² Tia²¹, cuɨ́¹ tionh¹ tsú² cá²hon³ quiúnh¹ dí² la³jmɨ́¹ ná¹tioh³ jáun² cáun² tsɨ́³ dí² quiúnh¹ hnú², hi³ jáun² lɨ́¹³ tónh³² tsá² zian² hngá¹máh³ lá² ta²¹ hi³ tson² bíh¹ hnú² ca³ze² nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","La³jmɨ́¹ má²ca³ma³quien¹³ hnú² jáun² jná¹³, má²ca³ma³quien¹³ jná¹³ tsú² siáh³ uá²jaɨ³², hi³ jáun² lɨ́¹³ ná¹tioh³ cáun² tsɨ́³ tsú² quiúnh¹ dí², la³jmɨ́¹ ná¹tioh³ cáun² tsɨ́³ dí² hmóu³². ");
INSERT INTO csoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Cáun² bíh¹ ná¹tioh³ tsɨn³² jná¹³ quiúnh¹ tsú² la³jmɨ́¹ ná¹tioh³ cáun² tsɨ́³ dí² hmóu³², hi³ jáun² la³ jáun² bíh¹ lɨ́¹³ hi³ ná¹tioh³ cáun² tán¹ tsɨ́³ tsú² má²tún² hmóu³² siáh³, hi³ jáun² la³ nɨ́² bíh¹ lɨ́¹³ lɨ³tsɨn² tsá² zian² hngá¹máh³ lá² hi³ hnú² bíh¹ Tsá² ca³ze² nú² jná¹³, jɨ³ hi³ hno³ lɨ́n³² nú² siáh³ tsá² joh² jná¹³ la³ cun³ rón³² hnau³ nú² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","”Tia²¹, hnú² bíh¹ ca³chan²¹ tsú² jo³uón³² jná¹³, hi³ jáun² bíh¹ hnó³² jná¹³ hi³ tsa³tiánh² tsú² ñí¹ ñí¹ñí²¹ jná¹³, hi³ jáun² lɨ́¹³ jɨ́e³ tsú² cónh³ tí³ hi³ quien² jná¹³, la³ cun³ hi³ ca³ma³quien¹³ nú² jáun² jná¹³; quí¹ hnú² bí¹ jlánh¹ ca³ma³hnau¹ nú² jná¹³ la³ cun³ jmɨ́¹ ñeh² bíh¹ hi³ lɨ́¹³ tá¹ cáun² mɨ³cuú². ");
INSERT INTO csoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Hnú² Tia²¹, Tsá² chun¹ nú², ha³ tiá² cuóu³² yáh³ hnú² tsá² zian² cun³ tɨn² tsɨ́³ hmóu³², tɨ³la³ jná¹³ má¹ná¹, cuóu³² bíh¹ ná¹ hnú², hi³ ja³bí¹ tsá² lá² siáh³ má²ca³lɨ³ ñi³² bíh¹ hi³ hnú² ca³ze² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jná¹³ má²ca³hɨe³ tsá² lá² hi³ hin² tsánh² hnú², hi³ la³ má²hɨe² jáun² jná¹³ tsú² siáh³, hi³ jáun² lɨ́¹³ ma³hnio³ tsú² tsá²ján² tsá²ján² rón³² la³ cun³ hnau³ nú² jáun² jná¹³, hi³ jáun² lɨ́¹³ ná¹tioh³ cáun² tsɨn³² jná¹³ quiúnh¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Hi³ jáun² jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús jáɨ¹³ nɨ́² né³, cua³han³ quionh³ tsá² haɨn²¹ hí³ tɨ³ con² hi³ ngau³ tɨ³ jo²¹ jëh³ ñí¹ téh²³ tsú² jáun² Cedrón. Ñí¹ jáun² jmɨ́¹ zia³² cáun² ñí¹ lɨ́³ ñí¹ jná¹ hmá²; ñí¹ jáun² né³, hi³ Jesús la³ má²quionh³ tsá² quionh³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ja³bí¹ Judas tsá² má²jɨenh³ hí³ Jesús jmɨ́¹ ñi² uá²jaɨ³² ñí¹ jáun², quí¹ hliáun³ jéin³² bíh¹ jmɨ́¹ má²ca³cuú² ca³ngɨh³² Jesús quionh³ tsá² haɨn²¹ hí³ tɨ³ con² ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Hi³ jáun² né³, ca³chó³² bíh¹ Judas ñí¹ jáun² la³ má²quionh³ hliáu³ tsá² *romanos, jɨ³ ma³ jan² tsá²cuú² tsá²ta³ tsá² ná¹lɨ́n³ mi³jmú³ hi³ ca³ze³ tsá² ná¹chín¹ joh¹ tsú² la³ má²quionh³ tsá² *fariseos. Tsá² hí³ né³ ná¹quian³² sɨ́² jmɨ́²cau³² jɨ³ sɨ́² ca² nɨ́² siáh³, la³ má²quionh³ mí¹táɨ³ mí¹jla² jɨ³ hmá² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Tɨ³la³ Jesús má¹ná¹, jmɨ́¹ má²ñi³² bíh¹ la³ cun³ la³jɨ́³² hi³ quiunh²¹, hi³ jáun² ja³ hi³ ca³ngáɨh³ tsá² hí³ la³ lá²: ―¿Hin² tsánh² hnah²³ hnoh²? ");
INSERT INTO csoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jáun² tsá² hí³ né³ ca³juáh³: ―Jesús tsá² Nazaret bíh¹ hnah²³ jnoh¹. Jmɨ́¹jáun² ca³juáh³ Jesús: ―Jná¹³ bíh¹ la³². Ja¹ quioh²¹ tsá² hí³ né³ jmɨ́¹ zenh¹ Judas tsá² má²lɨ́²jɨenh³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hi³ jáun² jmɨ́¹ ca³juáh³ Jesús: “Jná¹³ bíh¹ la³²”, jmɨ́¹jáun² né³ ca³yá²han¹ tsú² hi³ ca³quɨnh³ tɨ³ cu³hna²¹ hi³ ta³tonh¹ la³ tɨ³ hué³². ");
INSERT INTO csoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jmɨ́¹jáun² ca³ngáɨ³ siáh³ Jesús cónh³í¹ cu³ jéin³²: ―¿Hin² tsánh² hnah²³ hnoh²? Jáun² tsá² hí³ ca³ngáɨ³ siáh³: ―Jesús tsá² Nazaret bíh¹ hnah²³ jnoh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Hi³ jáun² ca³juáh³ siáh³ Jesús la³ lá²: ―Má²lɨ́²juáh³² bíh¹ jná¹³ hi³ jná¹³ bíh¹ la³². Nɨ́¹juáh³ jná¹³ la³ hnauh²³ náh², tɨ³la³ cué¹ jáɨ¹³ hi³ tsa³tánh¹ tín² tsá² ñí¹ hná¹ lá². ");
INSERT INTO csoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","La³ nɨ́² dá² ca³lɨ³ hi³ jáun² lɨ³tí³ la³ cun³ hi³ má²lɨ́²juáh³ tsú² jáun² hnga², jmɨ́¹ ca³juáh³ la³ lá²: “Tia²¹, tsá² ca³cuen²¹ hnú² hí³, hí¹ jan² yáh³ tiá² já²hín³”. ");
INSERT INTO csoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jmɨ́¹jáun² ca³chí² Sí¹mu²¹ Pé¹ mí¹táɨ³ hmu³ tá¹ tun³ jo²¹ quioh²¹, hi³ ca³jmú³ cu³ nga¹³ mí¹táɨ³ cuá¹ cuá² chu²¹ quioh²¹ jan² tsá² jmáɨ² Malco, jan² *tsá² má²dí¹hlánh¹ joh¹ tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Tɨ³la³ Jesús né³, ca³záɨh³ Pé¹ la³ lá²: ―Tiáunh¹ mí¹táɨh³ hñu³ láu² quioh²¹. Nɨ́¹juáh³ Ñuh³² jná¹³ hnió³ hi³ há¹ ngá¹³ jná¹³ uu³cha³tsɨ³² lá², ¿hí¹ lɨ́¹³ hi³ tiá² hen¹ jná¹³ hi³ quiunh²¹ jná¹³ la³ lá²? ");
INSERT INTO csoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Hi³ jáun² jmɨ́¹jáun² né³, hliáu³ tsá² chín¹, la³ má²quionh³ hliáu³ joh¹, jɨ³ tsá²cuú² tsá²ta³ tsá² *judíos tsá² ná¹ñí¹ nɨ́² siáh³ ca³ma³tson¹³ Jesús hi³ ca³hñéi³² dí². ");
INSERT INTO csoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Jmɨ́¹ lɨ²¹ jáun² né³, ca³ñí¹jan² dí² hñú¹³ Anás. Anás hí³ jmɨ́¹ lɨ́n³ tsa³jméi² Caifás, tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹ jmɨ́¹jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caifás hí³ bíh¹ jmɨ́¹ má²ca³záɨh³ tsá² judíos tsá² ná¹ñí¹ hi³ tɨ³ quien² bíh¹ jún³ jan² tsáu² cha¹³ jɨ³lɨn² tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Tɨ³la³ Sí¹mu²¹ Pé¹ né³, la³ má²quionh³ jan² tsá² ñí¹ hná¹ jáun², jmɨ́¹ hí¹tsá²táunh¹ chí¹cáɨn² cu³hna²¹ Jesús. Tsá² jan² hí³ né³ jmɨ́¹ cuóu²¹ bíh¹ tsá² cuá¹lɨ́n³ mí²tsá² hɨ́en¹, hi³ jáun² ca³hiauh³ jáɨ¹³ hi³ hí³ ñí¹hñú³ quioh²¹ mí²tsá² hɨ́en¹ hí³ quionh³ Jesús; ");
INSERT INTO csoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","tɨ³la³ Pé¹ né³, cheih³² bíh¹ ca³ta³zanh¹. Hi³ jáun² tsá² jmɨ́¹ cuóu²¹ hí³ mí²tsá² hɨ́en¹ né³ cua³han³ hi³ ñí¹mɨ́² jáɨ¹³ ñí¹con² tsá²mɨ³ tsá² jmɨ́¹ dí¹jmu² hua³hí¹³ ho³hñú¹³ hi³ hí³ Pé¹ ñéih³, jmɨ́¹jáun² ca³tanh² tsú² Pé¹ tɨ³ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jmɨ́¹jáun² ca³ngáɨ³ tsá²mɨ³ hí³ ñí¹con² Pé¹ la³ lá²: ―¿Há¹ jun³juáh¹³ hnú² lɨ́n³ nú² uá²jaɨ³² tsá² hen² tɨ³ con² tsá²ñuh² ó³² dúh¹? Jáun² ca³juáh³ Pé¹ la³ lá²: ―Já¹han²¹, ha³ tiá² lɨ́n³ yáh³ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jmɨ́¹ cuóu³ lɨ́n³² bíh¹ jmɨ́¹jáun², hi³ jáun² tsá² má²ná¹hlánh¹ quian²¹ mí²tsáu² la³ má²quionh³ tsá²cuú² tsá²ta³ tsú² la³ má²lɨ́²jmú³ sɨ́², hi³ jáun² má²ná¹táun³ hi³ ná¹chóh²³ sɨ́² jáun². Ja³bí¹ Pé¹ siáh³ jmɨ́¹ zenh¹ ñí¹ jáun² quionh³ tsá² hí³ hi³ dí¹chóh²³ sɨ́². ");
INSERT INTO csoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jáun² tsá² lɨ́n³ hí³ mí²tsá² hɨ́en¹ ca³ma³liáu³² hi³ nga² ñí¹con² Jesús hi³ ca³tɨn¹ tsá² haɨn²¹ tɨ³ con² dí², hi³ he³ ñí¹ jáɨ¹³ má²tɨn² tsú² siáh³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jáun² Jesús né³ ca³juáh³ la³ lá²: ―Jná¹³ dá² má²ca³hléh³ ná¹ chú¹ja²¹ bíh¹; tiú²nio² bí¹ hñu³ cuáh³² quiú¹³ dí² má²ca³ma³tɨn¹³ jná¹³ tsáu², jɨ³ hñu³ cuáh³² chín¹ nɨ́² siáh³, ñí¹ qui³ cuú² ngɨh³² ca³la³ jɨ́n³² tsá² judíos; hi³ jáun² né³, hí¹ cáun² yáh³ tiá² hi³ má²ca³hɨ́e³ jná¹³ ñí¹ ná¹conh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Jáun² ¿he³ yáh³ láɨh³² sa³ ñí¹con² huen² yáh³ jná¹³ ngaɨh³² hnú²? Ñí¹con² tsá² má²ca³náɨ³² jáɨ¹³ hi³ hléh²³ dá² jná¹³ nga³, quí¹ tsá² hí³ bíh¹ tsá² ná¹ñi³² la³ cun³ hi³ má²cá²juáh³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jmɨ́¹ má²lɨ́²juáh³ jáun² Jesús la³ nɨ́² né³, jáun² jan² tsá²cuú² tsá²ta³ mí²tsáu² jmɨ́¹ zenh¹ ñí¹ jáun² ca³pá³ ñí¹ Jesús, hi³ juáh³ la³ lá²: ―¿Hí¹ la³ nɨ́² máh³ ngaɨh³² hnú² ñí¹con² mí²tsá² hɨ́en¹? ");
INSERT INTO csoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jáun² ca³ngáɨ³ Jesús la³ lá²: ―Nɨ́¹juáh³ cáun² jú¹ hlah³ la³ lɨ́²hléh³ jná¹³, jáun² juah²¹ neh²¹ ha³ jinh¹ ti³tsóh³ lɨ́³ jú¹ hlah³; tɨ³la³ nɨ́¹juáh³ re² bíh¹ la³ lɨ́²hléh³ jná¹³ né³, jáun² ¿he³ ya³ láɨh³² sa³ po²³ yáh³ hnú² jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jmɨ́¹ lɨ²¹ jáun² né³, ca³zen³ Anás Jesús la³ má²hñe² jáun² bíh¹ ñí¹con² Caifás tsá² cuá¹lɨ́n³ siáh³ mí²tsá² hɨ́en¹. ");
INSERT INTO csoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tá¹la³ jmɨ́¹ dí¹chóh²³ jáun² Pé¹ sɨ́² né³, jáun² tsá² jmɨ́¹ tionh¹ hí³ ñí¹ jáun² ca³ngáɨh³ Pé¹ hi³ ca³juáh³: ―¿Há¹ jun³juáh¹³ hnú² uá²jaɨ³² lɨ́n³ jan² tsá² hen² tɨ³ con² tsá²ñuh² ó³²? Jáun² Pé¹ ca³juáh³: ―Já¹han²¹, jun³juáh¹³ jná¹³ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ñí¹ jáun² siáh³ jmɨ́¹ zenh² jan² tsá² má²dí¹hlánh¹ quian²¹ mí²tsá² hɨ́en¹, raɨnh²¹ tsá² ca³uóunh³ hí³ cuá¹ hi³ ca³quieh³ Pé¹, hi³ jáun² tsá² hí³ né³ ca³juáh³ la³ lá²: ―¿Há¹ jun³juáh¹³ hnú² lɨ́²jɨe¹ jná¹³ ja¹ hmá² jáun² quiúnh¹ nú² tsá² ó³² dúh¹? ");
INSERT INTO csoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Tɨ³la³ siáh³ bíh¹ siáh³ tiá² ca³ton³ Pé¹ jmɨ́¹jáun². Ti³tsóh³dí¹ jmɨ́¹jáun² né³ ca³hó³ jan² cá¹tsó³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jmɨ́¹ lɨ²¹ jáun² né³, cua³han³ Jesús hñú¹³ Caifás, hi³ ca³ñí¹jan² dí² ñí¹ta²¹ quioh²¹ tsá² ho² ta²¹ tsá² romano. Jmɨ́¹ má²já²jnia² bíh¹, hi³ jáun² né³ tsá² ná¹ñí¹ joh¹ tsá² judíos hí³ tiú²uú² taunh³ yáh³ ñéih³ ñí¹ta²¹ jáun², quí¹ hi³ jáun² tiá² lɨ́¹³ lɨ́n³ dí² tsá² tiá² jɨn². Quí¹ jɨ́³²la³ tsá² jɨn² bíh¹ lɨ́¹³ cuh³ má³² quioh²¹ *Jmɨ́¹hɨ́en¹ nɨ́¹ má¹ca³niéi² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Cun³ñí¹ hi³ jáun² bíh¹ cua³han³ Pilato tsá² ho² ta²¹ tɨ³ cheih³² hi³ ca³liéinh³² tsá² hí³, hi³ ca³juáh³ la³ lá²: ―¿He³ ñí¹ tso³ chah³² hnoh² quioh²¹ tsá²ñuh² lá²? ");
INSERT INTO csoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jáun² tsá² hí³ né³ ca³ngáɨ³: ―Sá¹jmɨ́¹ hi³ tiá² lɨ́n³ tsá²ñuh² nɨ́² jan² tsá² hláɨh¹ tsá² hon², jáun² tiá² jmɨ́¹ má²lɨ́²jɨenh²¹ yáh³ jnoh¹ tsú² ñí¹con² hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Tɨ³la³ Pilato né³ ca³juáh³ siáh³: ―Jon¹ náh² tsú², hi³ jáun² cuá²ra³tsɨ³² náh² héih³² la³ cun³ lɨ́³ liei²¹ quián¹³ náh² hmóu³². Jmɨ́¹jáun² ca³ngáɨ³ siáh³ tsá² ná¹ñí¹ hí³: ―Tɨ³la³ jnoh¹ tsá² judíos má¹ná¹, tiú²uú² jáɨ¹³ hau³² yáh³ jnoh¹ hi³ má¹ngɨ¹³ tsáu². ");
INSERT INTO csoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","La³ jáun² bíh¹ ca³lɨ³ hi³ jáun² lɨ́¹³ lɨ³tí³ la³ cun³ hi³ ca³juáh³ hnga² Jesús hi³ he³ lánh³ rón³² jún³ dí². ");
INSERT INTO csoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jáun² Pilato hen³ siáh³ ñéih³ ñí¹ta²¹ quioh²¹, jáun² ca³teh³ dí² Jesús hi³ ca³záɨh³ dí² la³ lá²: ―¿Hí¹ hnú² uá¹ lɨ́n³ nú² Re²¹ Juo¹³ tsá² judíos? ");
INSERT INTO csoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jmɨ́¹jáun² ca³juáh³ Jesús la³ lá²: ―¿Hí¹ ngaɨh³² hnú² jáɨ¹³ nɨ́² hi³ ca³tɨn¹ hnú² huen², ho³ hi³ zian² jan² tsá² má²lɨ́²juáh³ uá¹ hi³ ca³tɨn¹ jná¹³? ");
INSERT INTO csoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Hi³ jáun² Pilato né³, ca³juáh³ siáh³: ―¿Hí¹ lɨ́n³ jná¹³ tsá² judío dúh¹? Quí¹ tsá² coh¹ huen² bíh¹ hnú², la³ má²quionh³ tsá² ná¹lɨ́n³ mi³jmú³ joh¹ tsú² má²lɨ́²jɨenh³ hnú² ñí¹con² jná¹³. ¿He³ dá² ca³jmuh³ hnú²? ");
INSERT INTO csoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jáun² ca³ngáɨ³ siáh³ Jesús la³ lá²: ―Ha³ tiá² ñí¹ hué²¹ lá² ho² yáh³ jná¹³ jáɨ¹³. Quí¹ sá¹jmɨ́¹ hi³ ho² jná¹³ jáɨ¹³ ñí¹ hué²¹ lá² dúh¹, hi³ jáun² jmɨ́¹ lɨ́¹³ bíh¹ jmu³ tsá² tionh² jo³uón³² jná¹³ hniéi², hi³ jáun² tiá² jmɨ́¹ jɨenh³ yáh³ tsú² jná¹³ ñí¹con² tsá² judíos tsá² ná¹ñí¹. Tɨ³la³ tiá² ñí¹ lá² ho² yáh³ jná¹³ jáɨ¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Hi³ jáun² Pilato né³ ca³ngáɨ³ siáh³: ―¿Hí¹ jáun² lɨ́n³ uá¹ hnú² re²¹? Jáun² Jesús ca³juáh³: ―Lɨ́n³ bíh¹ jná¹³ la³ cun³ má²lɨ́²juah²¹ hnú² nɨ́². Jná¹³ dá² ca³lɨ³zian² ná¹, hi³ cuan³ ná¹ ñí¹ hué²¹ lá² hi³ hɨ́e¹³ ná¹ jú¹ tson². La³jɨ́n³² bíh¹ tsá² haɨn²¹ tɨ³ con² jú¹ tson² náɨ³² la³ cun³ hi³ juah³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jáun² Pilato ca³juáh³ la³ lá²: ―¿He³ dá² jaun³² jú¹ tson²? Jáun² jmɨ́¹ má²lɨ́²juáh³ Pilato jáɨ¹³ nɨ́² né³, cua³han³ siáh³ cheih³² hi³ ca³ñí¹lienh¹³ tsá² judíos tsá² ná¹ngɨh³² hí³, hi³ ca³ñí¹zeh¹ dí² la³ lá²: ―Hí¹ cáun² yáh³ tso³ quioh²¹ tsá² lá² tiá² choh¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tɨ³la³ hnoh² né³ ná¹hëh³ chinh³² hi³ hniáuh³² lion¹ jná¹³ jan² tsá² tson³ tá¹la³ Jmɨ́¹hɨ́en¹; jáun² né³ ¿hnáuh¹ náh² lion¹ jná¹³ Re²¹ Juóuh³² hnoh² tsá² judíos? ");
INSERT INTO csoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jmɨ́¹jáun² ca³la³ jɨ́n³² bíh¹ tsú² ca³tɨ́² ca³hóh³² hi³ ca³juáh³: ―¡Jun³juáh¹³ tsá² nɨ́² yáh³! ¡Barrabás bíh¹ lion¹ nú²! Tɨ³la³ Barrabás hí³ né³ jmɨ́¹ lɨ́n³ jan² tsá² háɨn² hian² tsɨ́³ bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Hi³ jáun² jmɨ́¹jáun² né³, ca³jmú³ Pilato héih³² hi³ jan³ tsú² Jesús, hi³ tsa³quiú² tsa³pan² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jáun² hliáu³ né³ ca³jmú³ cáun² chí² lɨh³² hi³ ca³tanh² dí² chí¹ Jesús la³juah²¹ dúh¹ cáun² *có²ron¹ná¹ hi³ quioh²¹ jan² tsá² ho² jáɨ¹³, tɨ³la³ hi³ jáun² né³ jmɨ́¹ lɨ́³ cun³quionh³ cuoh² hmá² ton² bíh¹; hi³ ca³quinh³ dí² siáh³ cáun² hmɨh³² zɨ́n¹³ la³ cun³ hi³ qui³ quɨh³² jan² tsá² quien². ");
INSERT INTO csoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jmɨ́¹ lɨ²¹ jáun² ca³ma³janh³² tsú² ma³ quin³² ma³ jan³² ñí¹ cuá¹tón²¹ Jesús, hi³ juáh³ la³ lá²: ―¡Cuɨ́¹ lɨ³quien² bíh¹ Re²¹ Juo¹³ tsá² *judíos! Ca³la³ hi³ má²quí² má²jnó³² bíh¹ dí² hó¹ñí¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jmɨ́¹ lɨ²¹ jáun² cua³han³ siáh³ Pilato hi³ ca³liéinh³² siáh³ tsá² ná¹ngɨh³² hí³ cheih³², hi³ ca³juáh³ la³ lá²: ―Sá¹nɨ́² jɨe³ náh², cuɨ́¹ chin²¹ jná¹³ tsú² tɨ³ cheih³² lá², hi³ jáun² lɨ³tsɨn² hnoh² hi³ hí¹ cáun² yáh³ tso³ tiá² lin¹ choh¹ jná¹³ quioh²¹ tsá² lá². ");
INSERT INTO csoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jmɨ́¹jáun² cua³han³ Jesús hi³ má²hun¹ chí² lɨh³² hi³ lɨ́³ cuoh² hmá² ton² chí¹, hi³ quih³² siáh³ hmɨh³² zɨ́n¹³ jáun². Hi³ jáun² ca³juáh³ Pilato la³ lá²: ―¡Lá² zenh² tsú²! ");
INSERT INTO csoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tɨ³la³ jmɨ́¹ ca³jɨ́en³² tsú² Jesús né³, jmɨ́¹jáun² ca³tɨ́² ca³hóh³² tsá² ná¹lɨ́n³ mi³jmú³ la³ má²quionh³ tsá²cuú² tsá²ta³, hi³ ca³juáh³ la³ lá²: ―¡Crei²¹ cuɨ́¹ taun¹ tsá² nɨ́²! ¡Crei²¹ cuɨ́¹ taun¹ tsá² nɨ́²! Jáun² Pilato ca³juáh³: ―Jon¹ náh² tsú², hmóu³² náh² cuá²ton³ náh² tsú² crei²¹, quí¹ hí¹ cáun² yáh³ tso³ tiá² choh¹ jná¹³ quioh²¹ tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tɨ³la³ tsá² judíos né³, ca³juáh³: ―Jnoh¹ zia³² cáun² liei²¹ quiú¹³, hi³ jáun² la³ cun³ lɨ́³ liei²¹ jáun² quiú¹³ bíh¹ jnoh¹ ca³tɨn¹ tsá² nɨ́² jún³, quí¹ sa³ tsá² nɨ́² yáh³ má²ca³juáh³ hi³ lɨ́n³ Jon² Dió³². ");
INSERT INTO csoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jmɨ́¹ ca³náɨ³² Pilato jáɨ¹³ nɨ́² né³, tɨ³ lɨ³mí¹ ca³ta³hú¹ cóh²¹ bíh¹ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jáun² hen³ siáh³ ñéih³ ñí¹ta²¹ quioh²¹, hi³ ca³ngáɨh³ siáh³ Jesús la³ lá²: ―¿Hín² tɨ́h³ ñeh³ hnú²? Tɨ³la³ Jesús né³ tiú²uú² hi³ ca³ngáɨ³ hí¹ cá² jon¹ yáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Hi³ jáun² Pilato ca³juáh³: ―¿Hí¹ cónh³ tiá² ngáɨh¹ uá¹ hnú² ñí¹con² jná¹³? ¿Há¹ tiá² ñíh¹ hnú² hi³ jná¹³ ho² ná¹ jáɨ¹³ hi³ taun¹ ná¹ hnú² crei²¹, ho³lá²dá² hi³ liau¹ ná¹? ");
INSERT INTO csoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jáun² Jesús ca³ngáɨ³ hi³ ca³juáh³: ―Hí¹ cáun² pí³ tiá² jmɨ́¹ zia³² yáh³ quián¹³ hnú² ñí¹con² jná¹³ sá¹jmɨ́¹ hi³ Dió³² tiá² ca³cué³ hnú² jáɨ¹³ hi³ ñi³hauh³²; cun³ñí¹ hi³ jáun² bíh¹ tɨ³ jlánh¹ bí¹ jueh³² tso³ ho² hnga² tsá² lɨ́²jɨenh³ jná¹³ ñí¹con² hnú² la³ cónh³ bí¹ hnú². ");
INSERT INTO csoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ jlánh¹ ca³hnauh² Pilato tsɨ́³ he³ lánh³ rón³² lɨ́¹³ lión³² dí² Jesús; tɨ³la³ tsá² judíos hí³ né³, ca³tɨ́² ca³hóh³² siáh³ hi³ ca³juáh³: ―¡Nɨ́¹juáh³ hi³ ca³lion¹ nú² tsá² nɨ́², jáun² tiú²uú² re² juónh³² yáh³ hnú² quiúnh¹ *tsá² cuá¹lɨ́n³ mɨ³chí¹ juú² Roma! ¡Quí¹ lɨ³ua³ jan² tsá² juáh³ hi³ lɨ́n³ re²¹, tsá² la³ hí³ ná¹hniei²¹ bíh¹ quionh³ tsá² cuá¹lɨ́n³ hí³ mɨ³chí¹! ");
INSERT INTO csoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jáun² jmɨ́¹ ca³náɨ³² Pilato jáɨ¹³ nɨ́² né³, ca³jmú³ héih³² hi³ chin¹³ tsú² Jesús tɨ³ cheih³², hi³ jáun² ca³cuá³ ñí¹ hmá²sɨ¹ quien² quioh²¹, ñí¹ jáun² jmɨ́¹ téh²³ tsú² Gabata quionh³ jú¹ *hebreo, la³ cun³ niéih³ “Ñí¹ rá¹já²³ quɨ́n¹”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Cua³hlau³ *Jmɨ́¹hɨ́en¹ bíh¹ jmɨ́¹jáun², hi³ jáun² ná¹jmu² tsú² hua³jan²¹ la³ cun³ hi³ lɨ³ hniáuh³²; míh¹ tiá² cun³ la³ nio¹ jñéi³ tɨ³ hú²niéi² jmɨ́¹ ca³juáh³ Pilato ñí¹con² tsá² judíos hí³ la³ lá²: ―¡Lá² zenh² re²¹ juóuh³² náh²! ");
INSERT INTO csoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Tɨ³la³ tsá² hí³ né³ ca³tɨ́² ca³hóh³² bíh¹ hi³ ca³juáh³: ―Chin³² tsá² nɨ́², chin³² tsá² nɨ́²; ma³jan³² ñí¹ taun³ crei²¹. Hi³ jáun² Pilato ca³juáh³ siáh³: ―¿Hí¹ lɨ́¹³ ton¹ jná¹³ crei²¹ re²¹ juóuh³² hnoh² dúh¹? Jáun² tsá² ná¹lɨ́n³ mi³jmú³ ca³juáh³ siáh³ la³ lá²: ―Jɨ́³²la³ jan² tsá² cuá¹lɨ́n³ mɨ³chí¹ bíh¹ lɨ́n³ re²¹ juo¹³ jnoh¹, ha³ tiú²uú² hin² zian² yáh³ tsá² siánh³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jáun² Pilato ca³jɨenh³ cú²jueh³² Jesús ñí¹con² tsá² hí³ hi³ cu³tsa³² cuɨ́¹ cha³ton³ tsú² cú²jueh³² crei²¹, hi³ jáun² ca³jón³² bíh¹ tsá² hí³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jmɨ́¹ má²lɨ³² jáun² né³, cua³han³ bíh¹ Jesús hi³ quian³² crei²¹ quioh²¹, hi³ ngau³ tɨ³ juɨ³² tsɨ³ máh³ ñí¹ téh²³ tsú² “Máh³ Mú³² Chí¹ Tsáu²”, hi³ cun³quionh³ jú¹jma² *hebreo né³, téh²³ tsú² “Gólgota”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ñí¹ jáun² bíh¹ ca³ton³ tsú² Jesús crei²¹. Ja³bí¹ ca³ton³ tsú² siáh³ crei²¹ cónh³í¹ gon³ tsáu², ma³ jan² la³ cá² jo²¹, hi³ jáun² chu³jo² né³ tón³² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jáun² Pilato ca³jmú³ héih³² hi³ tsa³ton³² tsú² huéh³ ta³ chí¹ crei²¹ ñí¹ tón²¹ jáun² Jesús, hi³ juáh³ la³ lá²: “Jesús Tsá² Nazaret, Re²¹ Juo¹³ Tsá² Judíos”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Juóun³² bíh¹ tsá² judíos ca³hɨ́³ huéh³ jáun², quí¹ ñí¹ má²janh² can³² juú² bíh¹ ca³ton³ tsú² Jesús crei²¹, hi³ huéh³ jáun² né³ jmɨ́¹ lɨ́³ cun³quionh³ jú¹jma² hebreo, jú¹ *latín jɨ³ jú¹ *griego nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Cun³ñí¹ hi³ jáun² né³, tsá² ná¹lɨ́n³ mi³jmú³ la³ má²quionh³ tsá² judíos tsá² ná¹ñí¹ ca³záɨh³ Pilato la³ lá²: ―Tiá² jmɨ́¹ hniáuh²¹ yáh³ jmúh¹ nú² huéh³ hi³ juáh³: “Re²¹ Juo¹³ Tsá² Judíos”; tɨ³ re² jmu³ huéh³ hi³ juáh³: “Tsá² Lá² Juáh³ Hi³ Lɨ́n³ Re²¹ Juo¹³ Tsá² Judíos”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tɨ³la³ Pilato né³, ca³ngáɨ³ hi³ ca³juáh³: ―Nɨ́² cuɨ́¹ lɨ́³ la³ cun³ hi³ má²lɨ́²jmú³² jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jáun² jmɨ́¹ má²lɨ́²ton³ jáun² hliáu³ crei²¹ Jesús né³, ca³caun² dí² ha¹ tsú², hi³ ca³chin² dí² quiún³ tsoh³, ma³ cáun² quioh²¹ la³ ma³ jan² hliáu³. Jáun² ca³can³ tsú² siáh³ hmɨh³² hu²¹ ñeh², tɨ³la³ hmɨh³² jáun² né³ tiá² lin¹ yáh³ ñí¹ jmɨ́¹ hmɨ³², cáun² bíh¹ jmɨ́¹ rá²láɨn¹ tá¹ cáun² chi³cuú² hi³ la³ tɨ³ há³². ");
INSERT INTO csoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jáun² hliáu³ hí³ ca³juónh³ má²tún² hmóu³² la³ lá²: ―Ha³ tiá² cáɨ¹³ yáh³ dí²; tɨ³ re² bíh¹ chí¹³ dí² jáɨ¹³ hi³ jáun² neh²¹ hin² tsánh² joh¹³. La³ jáun² bíh¹ ca³lɨ³tí³ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí², hi³ rá¹juáh³ la³ lá²: “Ca³tsáunh³ bíh¹ tsú² hán² jná¹³, hi³ ca³chí² tsú² siáh³ jáɨ¹³ ca³tɨ²¹ hmɨh³² quion²¹ ná¹”. La³ nɨ́² bíh¹ ca³jmú³ hliáu³ hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Có³² crei²¹ tón³² jáun² Jesús né³ jmɨ́¹ zenh¹ mí¹ziú¹³ tsú² la³ má²quionh³ tsá²mɨ³ raɨnh²¹; có³² jáun² jmɨ́¹ zenh¹ siáh³ Má²réi³ ñí²cuo² Cleofas la³ má²quionh³ Má²réi³ tsá² zian² juú² Magdalá. ");
INSERT INTO csoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jáun² jmɨ́¹ ca³jɨ́en³² Jesús mí¹ziú¹³, la³ má²quionh³ jan² tsá² haɨn²¹ hí³ tɨ³ con² tsú² hi³ jmɨ́¹ zenh¹ siáh³ có³² jáun², tsá² jlánh¹ jmɨ́¹ hnio³ tsú² hí³, jáun² ca³záɨh³ dí² mí¹ziú¹³ la³ lá²: ―Hnú² mɨ́¹, nɨ́² bíh¹ zenh² tsá² lɨ́¹³ jɨen¹ nú² la³jmɨ́¹ jɨen¹ nú² jónh³². ");
INSERT INTO csoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jmɨ́¹jáun² ca³záɨh³ dí² siáh³ tsá² hen² hí³ tɨ³ con² dí²: ―Jɨen¹ tiá³ tsá²mɨ³ nɨ́² la³jmɨ́¹ jɨen¹ nú² mí²ziúh². Hi³ jáun² la³ cun³ jmɨ́¹jáun² bíh¹ ca³jón³² tsá² hí³ Má²réi³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jmɨ́¹ má²lɨ³² jáun² né³, má²ñi³² bíh¹ Jesús hi³ la³jɨ́³² bíh¹ má²ca³lɨ³tí³, hi³ jáun² ca³juáh³ la³ lá²: ―Jlánh¹ má²quiéin² tsɨn³². Ca³juáh³ tsú² la³ nɨ́², quí¹ hi³ jáun² lɨ́¹³ lɨ³tí³ rón³² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí² bíh¹. ");
INSERT INTO csoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hi³ ñí¹ jáun² né³ jmɨ́¹ zeh¹ cáun² tse³ hi³ dí¹canh² mu² mɨ³ uóun²jɨeh¹³ hi³ má²zéih¹ lɨ́n²¹; hi³ jáun² ca³ma³jlɨh²¹ tsú² cáun² chí² náh² hɨnh²³ jmáɨ² quionh³ hi³ jáun², hi³ ca³di³chí³ dí² hná¹³ cáun² hmá²tiéi¹³ hi³ téh²³ tsú² hisopo, hi³ jáun² ca³hiéih³ dí² ho³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jáun² Jesús ca³yenh³ mu² jáun²; jmɨ́¹ lɨ²¹ jáun² né³, ca³juáh³ la³ lá²: ―La³jɨ́³² bíh¹ má²ca³lɨ³tí³. Hi³ jáun² jmɨ́¹jáun² ca³quɨ́h³² chí¹ hi³ ca³cua³ha³ tsɨ́³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Né³² né³, jmáɨ¹ jáun² má² cua³hlau³ Jmɨ́¹hɨ́en¹ bíh¹, hi³ jáun² tsá² judíos tsá² ná¹ñí¹ tiá² ca³lɨ³hnió³ hi³ la³ má²ná¹tón²¹ jáun² tsá² hí³ crei²¹ tá¹la³ *jmáɨ¹ nio² tie³, quí¹ jmáɨ¹ jáun² dá² cáun² jmáɨ¹ jueh³² bíh¹. Hi³ jáun² ca³hiu³ ca³mɨ́³ dí² ñí¹con² Pilato hi³ jmu³ tsú² héih³² hi³ tsa³jáu³ tsú² cú²jueh³² ta³ tsá² ná¹tón²¹ hí³ crei²¹, hi³ jáun² sión³² tsú² hla¹ má¹lɨ³² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jáun² jmɨ́¹jáun² já¹taunh²¹ siáh³ hliáu³, hi³ jáun² jmɨ́¹ ca³cha³táunh¹ jáun², ca³jó³ ta³ tsá² chí¹tón²¹ la³ñí¹, jmɨ́¹ lɨ²¹ jáun² ca³jó³ dí² siáh³ ta³ tsá² jan² hí³; ");
INSERT INTO csoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","tɨ³la³ jmɨ́¹ ca³ta³tonh¹ dí² ñí¹ chí¹tón²¹ Jesús má¹ná¹, jmɨ́¹jáun² ca³jɨ́e³ dí² hi³ má²hí¹jún¹ bíh¹ tsú², hi³ jáun² tiú²uú² ca³jó³ yáh³ dí² ta³ Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Tɨ³la³ cun³ jáun² ca³hɨ́h³ bíh¹ jan² hliáu³ ja¹ mɨ³hue¹³ Jesús cun³quionh³ hmá² zunh²¹ quioh²¹, hi³ jáun² jmɨ́¹ lɨ²¹ jáun² né³ ca³táɨn² jmɨ² jɨ³ jmáɨ² nɨ́² siáh³. ");
INSERT INTO csoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tsá² cha³² jáɨ¹³ lá² dá² hú¹tá¹ ca³jɨ́e³ bíh¹, hi³ jáun² la³jɨ́³² hi³ cha³² tsú² lɨ́³ hú¹tá¹ jú¹ tson² bíh¹; ñi³² bíh¹ tsú² hi³ jú¹ tson² bíh¹ hleh³², hi³ jáun² hnoh² uá²jaɨ³² lɨ́¹³ cháh¹³ cáun² honh². ");
INSERT INTO csoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Quí¹ la³ nɨ́² dá² ca³lɨ³ hi³ jáun² lɨ³tí³ la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí² bíh¹, hi³ juáh³ jáun² la³ lá²: “Hí¹ cáun² yáh³ mú³² quioh²¹ tsú² tiá² jau³ tsáu²”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ja³bí¹ zia³² siáh³ cáun² ñí¹ rá¹juáh³ la³ lá²: “Jɨ́en³² bíh¹ tsú² tsá² ca³hɨnh³”. ");
INSERT INTO csoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jmɨ́¹ má²lɨ³² jáun² né³, ngau³ Sé³² tsá² zian² juú² Arimatea hi³ ca³ñí¹mɨ́² jáɨ¹³ ñí¹con² Pilato hi³ tsa³quión³² dí² hla¹ Jesús. Quí¹ Sé³² hí³ dá² jmɨ́¹ lɨ́n³ bíh¹ tsá² hen² tɨ³ con² Jesús, uá¹jinh¹ ta³ conh¹ quí¹ cun³ñí¹ hi³ juénh² tsú² tsá² judíos tsá² ná¹ñí¹. Ca³cué³ bíh¹ Pilato jáɨ¹³, hi³ jáun² Sé³² né³ ca³ñí¹quión²¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ja³bí¹ Nicodemo tsá² ca³ñí¹lienh¹³ hí³ Jesús cáun² já¹niéi², ca³chó³² siáh³ hi³ quian³² míh¹ tiá² cun³ quiu³quia³hnɨ³² qui¹ló¹ no¹ má²ró³² hi³ lɨ́³ cun³quionh³ háu² téh²³ tsú² mirra má²ná¹jan² quionh³ háu² téh²³ tsú² áloes. ");
INSERT INTO csoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Hi³ jáun² Sé³² hí³ quionh³ Nicodemo ca³cón³² hla¹ Jesús, hi³ jáun² ca³tsáɨnh³² dí² cáun² hmɨh³² jmuh³ tiáu² lɨ́³ quionh³ mí²ñi³² lino jmɨ́¹ má²lɨ́²jñéi³² dí² jáun² no¹ má²ró³² jáun², la³ cun³ rón³² hi³ ná¹ngɨ²³ jáun² tsá² judíos hi³ hón³² hla¹ la³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Có³² ñí¹ cá¹taun³ jáun² Jesús crei²¹ jmɨ́¹ lɨ́³ cáun² ñí¹ jná¹ hmá² quioh²¹ tsáu², hi³ ñí¹ jáun² né³ jmɨ́¹ hó²¹ cáun² tá²hón³² hmaɨ²¹ ñí¹ hí¹ jan² hla¹ tiá² jmɨ́¹ má²ca³tanh² tsú². ");
INSERT INTO csoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jáun² ñí¹ jáun² bíh¹ ca³hón³² tsú² cú²jueh³² hla¹ Jesús, quí¹hliá² tá²hón³² jáun² bíh¹ jmɨ́¹ zeh¹ ca³lá² ñí¹ má²janh², quí¹ cun³ñí¹ hi³ jmɨ́¹ má²ñí¹tsá² bíh¹ jmáɨ¹ hi³ jmu² tsú² hua³jan²¹ hi³ hniáuh³² jmáɨ¹ nio² tie³ quioh²¹ tsá² judíos. ");
INSERT INTO csoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Hi³ jáun² né³, jmɨ́¹ la³ñí¹ jmáɨ¹ hi³ ca³lɨ³liau³ sɨ́²ma¹ná¹, ta³ ná¹juan³² lɨ́n³² ñéi¹ Má²réi³ tsá² zian² juú² Magdalá ñí¹ hó²¹ tá²hón³² jáun²; tɨ³la³ jmɨ́¹ cá¹chó²¹ tsú² jáun² ñí¹ jáun² né³, ca³jɨ́e³ tsú² hi³ sa³ tiú²uú² dí¹jnáɨ²³ yáh³ ho³ tá²hón³² quɨ́n¹ hi³ jmɨ́¹ dí¹jnáɨ²³ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jmɨ́¹jáun² ngah³ tsú² cú²hé² tɨ³ ñí¹ jmɨ́¹ cuá³ Sí¹mu²¹ Pé¹ quionh³ tsá² jan² hí³, tsá² jlánh¹ jmɨ́¹ hnio³ hí³ Jesús, hi³ ca³ñí¹zeh¹ dí² la³ lá²: ―La³ má²lɨ́²chin² bíh¹ tsú² Tɨ³² Juo¹³ dí² hñu³ tá²hón³², tiá² né¹ yáh³ ha³ dá² jinh¹ cuɨ́²ñí¹quion¹³ tsú² hla¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hi³ jáun² Pé¹ né³, la³ má²quionh³ tsá² jan² hí³ ja³taunh²¹ ñí¹ hó²¹ tá²hón³². ");
INSERT INTO csoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ca³la³ cú²hé² lɨ́n³² bíh¹ já¹taunh²¹ tsú² tá¹ gon³ cu³lɨ²¹, tɨ³la³ tɨ³ jlánh¹ bíh¹ cú²hé² ngau³ tsá² jan² hí³ má¹ná¹, hi³ jáun² ca³chó³² chí¹ján³ ho³ tá²hón³² la³ cónh³ bíh¹ Pé¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Jáun² jmɨ́¹jáun² ca³jmú³ hí¹sian², hi³ ca³jáɨh³ ñí¹ tɨ³ ñéih³, jáun² ca³jɨ́e³ tsú² hmɨh³² tiáu² jáun² hi³ ná¹tsɨ²¹ ñí¹ jáun², tɨ³la³ tiá² hi³ yáh³ tsú² la³ tɨ³ ñéih³ má¹ná¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tɨ³la³ jmɨ́¹ ca³chó³² Pé¹ né³, ca³la³ má²hún¹ la³ tɨ³ ñéih³ tá²hón³² bíh¹ ca³jmú³. Jáun² ja³bí¹ hí³ uá²jaɨ³² ca³jɨ́e³ hmɨh³² tiáu² hi³ ná¹tsɨ²¹ ñí¹ jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ja³bí¹ ca³jɨ́e³ tsú² siáh³ hmɨh³² hi³ jmɨ́¹ tsáɨh³ chí¹ Jesús. Tɨ³la³ hmɨh³² jáun² má¹ná¹, ha³ tiá² cu³tsa³² jmɨ́¹ nio¹ yáh³ quionh³ hmɨh³² hi³ jmɨ́¹ tsaɨnh³² tsú², cánh³ jmɨ́¹ nio¹ bíh¹ hi³ rá¹pan². ");
INSERT INTO csoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jáun² ca³hi³ siáh³ uá²jaɨ³² tsá² cá²chó³² hí³ la³ñí¹ tɨ³ ñéih³ hi³ ca³jɨ́e³ siáh³ uá²jaɨ³² la³ cun³ hi³ má²lɨ³², hi³ jáun² ca³taunh³ ta²¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Quí¹ tiá² re² jmɨ́¹ má²ca³ngɨ¹³ yáh³ tsú² la³ cun³ hi³ rá¹juáh³ jáun² ñí¹ Sí², hi³ ca³tɨn¹ bíh¹ Jesús hi³ jenh¹³ ja¹ hla¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jáun² jmɨ́¹ lɨ²¹ jáun² né³, ja³tanh²¹ bíh¹ tsá² hí³ hñú¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Tɨ³la³ Má²réi³ hí³ má¹ná¹, ca³ta³zanh¹ bíh¹ ho³ tá²hón³² hi³ dí¹ho², hi³ ta³ dí¹ho² jáun² né³ ca³jáɨh³ ñí¹ tɨ³ ñéih³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jmɨ́¹jáun² ca³jɨ́en³² tsú² gon³ tsá²cuú² tsá²ta³ Dió³² hi³ ná¹quih³² hmɨh³² tiáu², hi³ ná¹tsɨn¹ ñí¹ jmɨ́¹ rá²tsɨn² jáun² Jesús; jan² jmɨ́¹ cuá¹tón²¹ ñí¹ jmɨ́¹ lɨ́³ ta³ chí¹, hi³ cónh³ siáh³ jan² jmɨ́¹ cuá¹tón²¹ ñí¹ jmɨ́¹ lɨ́³ ta³ ta³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsá² hí³ né³ ca³ngáɨ³ hi³ ca³juáh³ la³ lá²: ―¿He³ lɨ³, jáun² uoh³² hnú² né³ tsá²mɨ³? Jáun² Má²réi³ hí³ ca³ngáɨ³: ―Quí¹hliá² la³ má²lɨ́²chin² bíh¹ tsáu² Tɨ³² Juóu³² jná¹³, hi³ tiá² ño¹ jná¹³ ha³ jinh¹ má²cuɨ́²ñí¹quion¹³ tsú² hla¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Cun³ dí¹juáh²³ la³ nɨ́² bíh¹ tsú² jmɨ́¹ ca³jinh³ tɨ³ cu³hna²¹, hi³ jáun² ca³jɨ́e³ hi³ zenh² Jesús ñí¹ jáun²; tɨ³la³ tiá² ca³lɨ³tsɨn² yáh³ tsú² hi³ Jesús bíh¹ la³ Tsá² hí³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Hi³ jáun² Jesús ca³ngáɨ³ ñí¹con² tsú² la³ lá²: ―¿He³ láɨh³² sa³ uoh³² hnú² né³ tsá²mɨ³? ¿Hin² dá² hnah²³ hnú²? Tɨ³la³ hí³ dí² né³ jmɨ́¹ lɨ́n²³ hi³ tsá² jmu² hua³hí¹³ ja¹ hmá² jáun² bíh¹ tsá² hí³, hi³ jáun² ca³záɨh³ dí² la³ lá²: ―Hnú² tsá²ñuh², nɨ́¹juáh³ hnú² bíh¹ cua³chin³² nú² hla¹, jáun² juah²¹ tiá³ ha³ jinh¹ cuɨ́²ñí¹quion¹³ nú², jáun² ñí¹cón²¹ jná¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jáun² ca³juáh³ Jesús: ―¡Má²réi³! Jáun² ca³jinh³ dí² tɨ³ ñí¹ hó²¹ñí¹ tsú² hi³ ca³záɨh³ dí² la³ lá² cun³quionh³ jú¹jma² *hebreo: ―¡Raboni! (hi³ hnió³ juáh³ “Tɨ³²”). ");
INSERT INTO csoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jáun² Jesús né³ ca³juáh³: ―Tú³ tín² tán² jná¹³, quí¹ tiá² má²cuá²ñíh¹ yáh³ jná¹³ ñí¹ cuá³ Ñuh³². Tɨ³la³ cuánh², cuá²zéih³ tsá² renh² jná¹³ hi³ ñih²¹ jná¹³ tɨ³ ñí¹ cuá³ Ñuh³², Tsá² lɨ́n³ hí³ siáh³ Ñeh² hnoh²; ñih²¹ jná¹³ tɨ³ ñí¹con² Dió³² Juóu³² jná¹³, Tsá² lɨ́n³ siáh³ Dió³² Juóuh³² hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Hi³ jáun² Má²réi³ hí³ né³ ngah³, hi³ ñí¹zeh¹ tsá² haɨn²¹ hí³ tɨ³ con² tsú², hi³ ca³ñí¹juah²¹ hi³ má²lɨ́²jɨ́en³² dí² Tɨ³² Juo¹³, jɨ³ hi³ ca³chá³ dí² siáh³ la³ cun³ hi³ ca³juáh³ tsú² jáun². ");
INSERT INTO csoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jmɨ́¹ ca³zɨ³² hi³ la³ñí¹ jmáɨ¹ hi³ ca³lɨ³liau³ sɨ́²ma¹ná¹ jáun² né³, jmɨ́¹ ná¹ngɨh³² tsá² haɨn²¹ hí³ tɨ³ con² tsú² cáun² ñéih³, hi³ má²dí¹jnaɨ³² tiá³ ho³hñú¹³ cun³ñí¹ hi³ juénh² tsú² tsá² *judíos tsá² ná¹ñí¹. Tɨ³la³ Jesús né³, hi³ bíh¹ ñéih³ hi³ ca³náu² chu³jo² ñí¹ tionh¹ tsá² hí³, hi³ ca³záɨh³ dí² tsú² la³ lá²: ―¡Cuɨ́¹ zian² náh² cáun² hi³ re² hi³ tɨn²! ");
INSERT INTO csoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jmɨ́¹ má²lɨ́²juáh³ jáun² la³ nɨ́² tsú² ca³hɨ́e³ cuo² la³ má²quionh³ ñí¹ ja¹hɨ́h¹ ja¹ mɨ³hue¹³. Hi³ jáun² tsá² hí³ né³ ca³lɨ³ hiún² lɨ́n³² tsɨ́³ jmɨ́¹ ca³jɨ́en³² Tɨ³² Juo¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jmɨ́¹ lɨ²¹ jáun² né³, ca³juáh³ siáh³ Jesús la³ lá²: ―¡Cuɨ́¹ zian² náh² cáun² hi³ re² hi³ tɨn²! La³jmɨ́¹ ca³ze³ jná¹³ Ñuh³², la³ jáun² bíh¹ má²zei²¹ jná¹³ hnoh². ");
INSERT INTO csoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jmɨ́¹jáun² ca³jie³ dí² ñí¹ quioh²¹ tsá² hí³, hi³ ca³záɨh³ dí² la³ lá²: ―Hen³ náh² Jmɨ́²chí³ Chun¹. ");
INSERT INTO csoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nɨ́¹juáh³ tsá² hin¹³ hnoh² tso³ quioh²¹, jáun² hin³ bíh¹ tsáu¹³ tsú²; hi³ nɨ́¹juáh³ tsá² tiá² hin¹³ náh² tso³ quioh²¹ né³, jáun² la³ má²ná¹ren² jáun² bíh¹ tsú² tsáu¹³ lɨ́¹³. ");
INSERT INTO csoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tɨ³la³ Tú¹ma²¹ má¹ná¹, jan² tsá² quian³tun³ hí³, tsá² jmɨ́¹ téh²³ tsú² hí³ dún² gon³, tiá² jmɨ́¹ cuá³ yáh³ quionh³ tsá² ñí¹ hná¹ jáun² jmɨ́¹ ca³ma³jnia³² jáun² Jesús. ");
INSERT INTO csoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jáun² ca³záɨh³ tsá² ñí¹ hná¹ jáun² Tú¹ma²¹ la³ lá²: ―Má²ca³neh²¹ bíh