﻿USE sofia;
DROP TABLE IF EXISTS sofia.crxNTpo_vpl;
CREATE TABLE crxNTpo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES crxNTpo_vpl WRITE;
INSERT INTO crxNTpo_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Soo 'udechoo whe'whudit'en whe Yak'usda (Elohim) ndi yun 'ink'ez yak'uz 'et 'uhóonla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Yun, ba ndo hoonli lhiloh 'ink'ez 'aw ook'ut 'et hooloh inle', yatoo k'ut tsaholhgus za hoonli inle'. Yak'usda (Elohim) ooyughi too k'ut nudults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","'Et Yak'usda (Elohim) 'en 'utni, “'Et njan be hoot'en-i hole'.” 'Et hoot'en whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","'Ink'ez Yak'usda (Elohim) be hoot'en-i yunilh'en, unzoo whe 'unt'oh 'ink'ez be hoot'en-i 'ink'ez tsaholhgus bulh lhulcho 'uyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Yak'usda (Elohim) ndi be hoot'en 'i dzin yulhni, 'ink'ez ndi tsalhgus, 'i 'ulhdzis yulhni, 'et whe hulhgha 'ink'ez bundada' 'et soo 'udechoo dzin whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","'Et Yak'usda (Elohim) ndutni, “Too toh yat hole' 'ink'ez ndo whutoo' 'ink'ez yun k'ut too cha lhulcho oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","'Et Yak'usda (Elohim) yat 'uhoonla, 'ink'ez ndi too lhk'eyalhdzo njan too 'ink'ez ndo yat cha, 'et ndúhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","'Ink'ez Yak'usda (Elohim) ndo yat 'et yak'uz whulhni. 'Et hulhgha 'ink'ez bundada' 'et whulh nat dzin whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","'Et Yak'usda (Elohim) 'utni, “Ndi too yak'uz ba nyo 'i 'ilho oole', 'ink'ez 'et yun dizgi hahoolts'it.” 'Et nduhóoja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","'Ink'ez Yak'usda (Elohim) ndi yun dizgi 'i yun k'ut whulhni, 'ink'ez ndi too 'ilhoh nedimbun 'i yatoo' yulhni. 'Et Yak'usda (Elohim) ooba hoonzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","'Et Yak'usda (Elohim) 'utni, “Ndi yun k'ut 'et tl'o, ndai 'ut'an hanuyeh ootse whulih. Mai chun oomai' whulih ts'iyawh dich'oh ooch'e' nawhudlih, 'i oole',” ni 'et whe nduhóoja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","'Et ndi yun k'ut tl'o, ndai 'ut'an hanuyeh ootse whulih whuk'un'a, 'ink'ez mai chun oomai' whulih ts'iyawh dich'oh ootse nawhudlih. 'Et Yak'usda (Elohim) ooba hoonzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","'Et hulhgha 'ink'ez bundada' 'et whulh tat dzin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","'Et Yak'usda (Elohim) 'utni, “Ndo yak'uz hoot'en oole', 'i be lhulhcho lhts'e hozit whe dzin 'ink'ez 'ulhdzis, 'i be nts'oh hoozulh, dzin 'ink'ez naoodizulh 'et cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","'Ink'ez 'et ndi yak'uz be hoot'en, 'i yun k'ut be hoot'en oole',” 'et nduhóoja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","'Et Yak'usda (Elohim) 'en nanki be hoot'en-i cho whulhtsi. 'Et ndi tube be hoot'en-i, 'i dzin huba suli' 'ink'ez dzohyaz be hoot'en-i, 'i 'ulhdzis huba suli'. 'Ink'ez ndi sum 'i cha 'uyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Yak'usda (Elohim) 'en ndo yak'uz ndi be hoot'en-i whulhtsi, 'i ndi yun k'ut hukw'edodi huba. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","'Ink'ez 'owhi dzin 'ink'ez 'ulhdzis bulh k'une' hool'en ha. 'Ink'ez lhulcho 'uhoonla be hoot'en-i 'ink'ez tsalhgus yo. 'Ink'ez Yak'usda (Elohim) whunilh'en 'ink'ez ooba hoonzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","'Et hulhgha 'ink'ez bundada' 'et whulh did dzin whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","'Et Yak'usda (Elohim) 'utni, “Too toh lhai cho lho ndunt'oh-i hole', 'ink'ez dut'ai yun ando yat ndulcho dut'ai be nuhoot'o”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","'Et Yak'usda (Elohim) toot lho cho 'ink'ez usjiz-i nuhutnah-i lhelhdoh didoh toot nuyeh-i 'ink'ez nut'o-i lhelhdoh didoh-i 'inla. 'Ink'ez 'owhi yunilh'en, unzoo whe 'unt'oh. 'Et Yak'usda (Elohim) ooba hoonzoo suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","'Et Yak'usda (Elohim) soo hoonzoo-un hubúlhni, 'ink'ez njan ndutni, “Lhk'uz whe lhai oohle' ndi too doolhbun yatoo' tuz, 'ink'ez dut'ai cha ndi yun k'ut lhk'uz teh lhai oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","'Et hulhgha 'ink'ez bundada' 'et kwulat dzin suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","'Et Yak'usda (Elohim) 'utni, “Ndai la khuna-i dich'oh didoh-i, khuna-i, musdoos te, yun nulh'as-i, 'uyoo khuna-i, ts'iyawh didutch'oh dudun dot'en, yun ts'u halh'as,” 'et whuz un'a 'uhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","'Et Yak'usda (Elohim) khuna-i yun k'ut nulh'as 'ilhoh didoh-i, musdoos 'ilhoh didoh-i 'ink'ez ts'iya-i yun nulh'as-i, 'ilhoh didoh-i 'ink'ez Yak'usda (Elohim) yan'en, unzoo whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","'Et Yak'usda (Elohim) 'utni, “Dune 'uts'ooleh, neundot'en-un, nek'un'a 'unt'oh-un, yatoo k'ut, lho, dut'ai ndo nudilh-i, musdoos, yun k'ut cha, yun k'ut nulh'as-i cha, 'owhi ts'iyawh yumoodih oole' sih”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","'Et Yak'usda (Elohim) dune 'inla, duk'un'a Yak'usda (Elohim) ndot'e', 'en dune 'ink'ez ts'ekoo cha 'en 'ubinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","'Et Yak'usda (Elohim) soo hoonzoo-un 'ubulhni 'ink'ez Yak'usda (Elohim) njan ndubulhni, “Lhane cho nohuzkeh oole', ndi yun doolhbun 'ink'ez oomoodih uhli, lho, dut'ai, nudilh-i cha 'ink'ez ndi yun k'ut usjiz-i cha ts'iyawh”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","'Et Yak'usda (Elohim) 'utni, “Whunulh'en, yun hanuyeh-i oomai' hoonli-i, 'ananukat-i yun k'ut hooni-i, duchun oomai' 'ananukat-i, nohni nohba ut'alh-i tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","'Ink'ez cha ndi yun k'ut usjiz-i, dut'ai ndo nudilh-i, 'ink'ez yun k'ut nulh'as-i cha, ndi yun k'ut hanuyeh-i yuti'ulh huba bugha ínus'ai,” 'ink'ez whuz un'a 'uhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yak'usda (Elohim) yane'yalh'en-i yunilh'en, ts'iyawh 'uyinla-i 'ink'ez 'alha tube unzoo. 'Et hulhgha 'ink'ez bundada' 'et bulh lhk'utat dzin. 'Et ts'iyawh whunalh'en whe tube ooba hoonzoo. 'Et hulhgha 'ink'ez bundada' 'et whulh lhk'utat dzin suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","'Awet yak'uz, yun k'ut, 'ink'ez ndai ts'iyawh 'uhoonla, 'i lhaoodinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","'Et whulh lht'ak'ant'it dzin suli', 'et Yak'usda (Elohim) be 'ut'en, 'i lhaidinla 'ink'ez whulh lht'ak'ant'it dzin 'et nalyiz. Ndi be 'ut'en 'i ts'iyawh lhaoodinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","'Ink'ez Yak'usda (Elohim) whulh lht'ak'ant'it dzin 'et soo hoonzoo-un whulhtsi 'ink'ez 'udun duba neooninla. Njan whulh lht'ak'ant'it dzin 'et nalyiz be 'ut'en 'i ts'iyawh lhaoodinla 'et huwa, Yak'usda (Elohim) ndi 'uyinla 'i lhaoodinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Njan 'et soo 'udechoo whe'whudit'en hukw'elh'az yak'uz 'ink'ez yun k'ut njan dzin Moodihti Yak'usda (Yahweh Elohim) 'en ndi yak'uz 'ink'ez yun k'ut 'uhoonla, ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","'awhuz yun whut'an 'ink'ez oomai' hooni-i, 'ink'ez dilht'an-i cha yun k'ut halhusye whe, Moodihti Yak'usda (Yahweh Elohim) nawhulhtih-un 'ink'ez dune yun gha oona' ha hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","'Et hoonts'i tootsul whuzdli' 'i be yun k'ut naooniltsul. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","'Ink'ez Moodihti Yak'usda (Yahweh Elohim) yun lez 'i dune yulhtsi 'ink'ez be ts'uhuna bulh yuni 'ainyulh 'ink'ez dune khuna suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Eden huwun ndaz de 'et Moodihti Yak'usda (Yahweh Elohim) 'en ha'nuyeh k'et newhunin'ai. 'Et 'a'nule ink'ez ndun dune yulhtsi, 'en 'et neinilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Njan yun k'ut Moodihti Yak'usda (Yahweh Elohim) ts'iya-i duchun nul'en huba nzoo-i 'ink'ez ut'alh huba nzoo-i 'ainanla. Duchun oogha ts'ukhuna-i cha whuniz hanuyeh yun 'et 'uyinla. 'Ink'ez ndi duchun be t'eoonudzun ndet hoonzoo 'ink'ez ndet hoontsi' 'et cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","'Et ndi took'oh Eden whuts'u hainli, 'i hanuyeh k'et be nawhunultsul, 'et 'ukoh didun lhk'einli whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Soo 'udechoo whuts'u hainli, 'i Pishon huyulhni, ndi 'i yun k'ut Havilah ndul cho whunadizdli, 'et gold hooni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","'Ink'ez njan yun k'ut gold 'i unzoo. Bdellium 'ink'ez onyx tse 'i 'et hooni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Njan whulhnat took'oh ye dinli, 'i Gihon hiyulhni, 'i 'unt'oh. Yun k'ut Cush, 'et ndulcho whunasuli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Bulh ta-i 'ukoh 'i Hiddekel huyulhni, 'i Assyria whanda' ts'e wheinli. Bulh dunghi 'ukoh 'i Euphrates 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","'Et Moodihti Yak'usda (Yahweh Elohim) hanuyeh k'et Eden 'et dune neninilhti, yughole' 'ink'ez yot'e' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","'Ink'ez Moodihti Yak'usda (Yahweh Elohim) ndun dune khuni yutl'a dan'ai whe nduyulhni, “Ndi duchun ts'iyawh njan hanuyeh 'i on'alh ndet hukwa' ninzin totsuk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","“Ndi duchun be t'eoonudzun-i, ndet hoonzoo-un, 'ink'ez ndet hoontsi'-un, 'i oomai 'aw lhuzon'al. Ndet dzin in'al-un, 'alha datantsah.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","'Et Moodihti Yak'usda (Yahweh Elohim) 'utni, “Dune dich'oh 'uhint'oh de 'aw lhe'hoozoo' whe' hoont'oh, yula' tit'elh-un yundult'oh-un ooba 'oosleh si.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ndi yun k'ut 'et Moodihti Yak'usda (Yahweh Elohim) ts'iyai khuna-i, dut'ai ndo yat nudilh, 'i ts'iyawh Adam ts'un nebuninla, 'et nts'en'a hubootazih ha. 'Ink'ez nts'en'a hubonzi', 'i huboozi suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","'Et Adam 'en ndi mudoos, dut'ai ndo yat nudilh, 'ink'ez tl'o k'ut khuna-i, 'i ts'iyawh huboozi' whulhtsi. 'Et 'ink'ez Adam yulh ndult'oh 'en yula 'oot'en hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","'Ink'ez 'et Moodihti Yak'usda (Yahweh Elohim) Adam bulh cho yuk'edin'ai, 'et Adam nanisti 'ink'ez oocha 'ilhoghi Yak'usda yuts'u haídantan 'ink'ez yutsung lhts'un be naíyunilhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Moodihti Yak'usda (Yahweh Elohim) ndi 'ucha dune ts'u haidantan, 'i ts'eke yulhtsi 'ink'ez dune yughi nilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","'Et Adam 'utni, “Ndi 'andit sts'un oots'un 'unt'oh 'ink'ez stsung ootsung 'unt'oh, ts'eke boozi' oole' si, dune ts'u halti 'et huwa”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","'Et huwa dune dubá 'ink'ez duloo bulh bula dootnih 'ink'ez du'at bulh 'oot'e 'ink'ez 'ilho yust'e hoole'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","'Ink'ez nahult'oh 'ust'et, dune 'ink'ez du'at bulh whe 'aw yooya cha lhuhiloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","'Et tl'ughus 'i lhelhdoh didoh-i Moodihti Yak'usda (Yahweh Elohim) 'uyinla-i unli 'ink'ez ts'eke 'ulhni, “Duchun yun k'ut whuduchun 'aw ts'iyawh lhuzooh'al, ni eh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","'Et ts'eke nyoon tl'ughus 'uyulhni, “Nyoo duchun mai' hanuyeh-i, 'i ts'oo'alh huba' hoont'oh, ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","'Et hoonts'i hanuyeh k'et whuduchun whuniz nadan'a-i, 'i Yak'usda (Elohim) 'utni, ‘Nyoo duchun mai' 'aw lhuzooh'al, k'us oot'aoohnalh junih, khun si daoohtsah,’” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","'Et ndi tl'ughus, ts'eke 'en 'uyulhni, “'Alha 'aw daoontsah ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Yak'usda (Elohim) t'eooninzun ndet dzin uh'alh-un, hooh'en tihleh 'ink'ez Yak'usda (Elohim) bundutilh'elh, hoonzoo-un 'ink'ez hoontsi'-un cha t'ewhuntahzin.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","'Et ts'eke duchun ts'u'alh huba unzoo, nul'en huba cha unzoo, duchun ts'uwhunih netilhtselh huba ooka' whuninzun, oomai' yilhchoot 'ink'ez yan'al, duki cha yuloh yutl'a nan'ai 'ink'ez 'en cha yan'al. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","'Et nahult'oh duna be huhon'en suli', 'ink'ez nahult'oh 'ust'et 'uhint'oh t'ehonanzin, mai “fig” huyulhni 'i oot'an lhuna' hidunilhka' 'i be be k'e'uzdla 'uhududulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","'Et nawhudunik'az whe Moodihti Yak'usda (Yahweh Elohim) hanuyeh k'et 'oh nuya whe hidits'o 'ink'ez Adam du'at bulh hanuyeh k'et duchun toh Moodihti Yak'usda (Yahweh Elohim) hich'a untilh'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","'Et Moodihti Yak'usda (Yahweh Elohim) Adam hahizya 'ink'ez 'uyulhni, “Nts'e 'int'oh”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","'Et 'utni, “Hanuyeh k'ez nyudasts'o 'ink'ez whenuzjut, 'ust'et 'ust'oh 'et huwa untiz'i.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","'Ink'ez 'uyulhni, “Mbe 'unyulhni 'ust'et 'int'oh, duchun oomai' uh'alh junih nohdusni-i eh uh'al?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","'Et dune 'utni, “Ts'eke sgha nilht'i-un duchun oomai' sgha inin'ai 'ink'ez 'i us'al.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","'Ink'ez Moodihti Yak'usda (Yahweh Elohim) ts'eke 'ulhni, “Dahoont'oh-un dainja?” 'Ink'ez ts'eke 'utni, “Tl'ughus nasunan'a 'ink'ez us'al.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","'Et Moodihti Yak'usda (Yahweh Elohim) tl'ughus 'ulhni, “'Et ndinja huwa 'uyoo khuna-i anus nk'ehida whe 'int'oh, 'ink'ez 'uyoo khuna-i chuntoh nulh'as-i anus, mbut tl'ah whe nukedutanzut, 'ink'ez lhez za tan'ulh, yunka tandalh nduwhulyiz whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","'Ink'ez nyun 'ink'ez ts'eke bulh lhazdatni nohtiselh, 'ink'ez nyuzkeh 'ink'ez buzkeh. Ntsi yayindunta'us 'ink'ez ookentsul duntalhdah.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","'Et ts'eke 'ulhni, “Ndzi unduda-un 'ink'ez datant'elh-un 'onus 'uwhulcho whutiselh, nyulh 'ults'ulh whe nyuzkeh whutaleh, nki ooka' untanzilh 'ink'ez nyumoodih tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","'Et Adam 'ulhni, “N'at oozalhts'ai' 'et huwa 'ink'ez ndi duchun oomai', ‘'On'alh junih,’ nyudusni, in'al 'et huwa, nyun mba ndi yun 'i ookehida, 'ut'en be oots'u huyukat-i tan'ulh yun ka tandalh ndwhulyiz whe.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Whuscho 'ink'ez whusyaz bulh nankilt'oh ook'ut mba hantiyeh, 'ink'ez yun hanuyeh-i tan'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Nyunin ts'u halhdzilh whe ut'alh-i on'alh, yun natandleh whuts'un. 'I oots'u hainzut. Lhez 'int'oh 'ink'ez lhez 'i ts'un natandleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","'Ink'ez Adam du'at Eve be yoozi, khunane ts'iyawh buloo 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","'Ink'ez Adam oo'at bulh Moodihti Yak'usda (Yahweh Elohim) 'en ndi zuz 'i buba 'uyinla hiye óoke' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","'Et Moodihti Yak'usda (Yahweh Elohim) 'utni, “Nulh'en, dune Neundult'oh suli', hoonzoo-un 'ink'ez hoontsi'-un t'ewhunozin ha. 'Ink'ez 'andit doo ka si dula be ndi duchun oomai' yolhchoot 'ink'ez yoo'alh 'ink'ez 'ilhiz whutinalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","'Et huwa Moodihti Yak'usda (Yahweh Elohim) njan hanuyeh k'et, Eden, 'et tenabunilh'a', 'ink'ez njan yun whut'as tileh 'i oots'u haits'alhti 'et, oot'e' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","'Et dune teininyoot 'ink'ez Eden ndaz ts'e 'et lizasne, Cherubne hubulhni, 'et nebunilhti, 'ink'ez saluzti kwun dunukw dot'en lhelhts'un nadighus-i duchun oogha ts'ukhuna-i yughole' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","'Et Adam du'at Eve, t'einanzin 'ink'ez oo'at ulchan 'ink'ez Cain 'en yulhtsi 'ink'ez 'utni, “Moodihti (Yahweh) ts'un dune sgha ninzut.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","'Et doo cha Eve 'ulhtsi, 'andit 'et bulhutsin Abel 'en 'usbai ghunli unli, 'et Cain 'en yun ghana-un suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","'Et whudizulh whutoh Cain yun whumai', Moodihti (Yahweh) gha italelh ha yughi ninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abel cha 'usbai 'udechoo whuzdli-i nilhk'a whe whuz wheyanla 'ink'ez Moodihti (Yahweh) Abel yudilhti' 'ink'ez yuba soo 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","'Et hoonts'i Cain yuba whusayanla-i ooba lhe' yizoo' 'ink'ez Cain tube hunilch'e 'ink'ez oonin ts'e 'uts'un un'a 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","'Et huwa Moodihti (Yahweh) 'en Cain 'uyulhni, “Ndet huwa hunilch'e 'ink'ez nyunin ts'e 'uts'un un'a 'inja?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","“Soo 'ant'en, 'aw lakw 'uyoo neba lhe'hootazoo'? 'Et 'aw soo lhe'zint'en de, 'ut'en untsi'-i dati us'ai whe 'unt'oh. 'Ink'ez nka' ninzun whe 'unt'oh, 'et hoonts'i whuch'a whumoodih onle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","'Et Cain dudulhutsin Abel yulh yailhduk, 'et 'uhooja nus tl'o k'ut 'uhint'oh whe, Cain dudulhutsin Abel yuch'az nedinja 'ink'ez yuzilhghi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","'Et whe Moodihti (Yahweh) Cain 'uyulhni, “Nyulhutsin Abel daja?” Cain 'utni, “T'eoonuzuszun, si eh sulhutsin ghusli?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","'Ink'ez 'utni, “Nts'en'a dainja?” Yun whuts'un nyulhutsin buzkai' sts'un huyih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","'Andit 'awet ndi yun mba whutátsi'. Yun dizts'o nla k'ez nyulhutsin buzkai' ook'eijul 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Yun gha itanelh te, daltus la hukw'un'a mba ook'ut halhe'untizye. Ndi yun k'ut tandalh whut'oh nunul'i-un 'ink'ez yoh lhuhoot'i'-un tanleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","'Et Cain 'en Moodihti (Yahweh) 'uyúlhni, “Be sba nahisda-i 'onus sba hoondaz k'et 'aw whulh 'oost'e' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","'Alha 'andit dzin whuts'un ndi yun k'ut suntinyoot nyunin ba whu'iz 'utist'elh, ndi yun k'ut nunul'i'-un 'ink'ez yoh lhuhoot'i'-un tisleh, 'ink'ez mbe nasilhti-un sutuzilhghelh whe 'unt'oh”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","'Et Moodihti (Yahweh) 'uyulhni, “Et huwa, mbe Cain silhghi-un lhtak'ant'it 'uwhultsuk-un ooba k'utitnelh.” Doo ka si Moodihti (Yahweh) 'en Cain ye hoodalh'en khun nahiyilhti 'ink'ez hizoolhghelh whuch'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","'Et Cain Moodihti (Yahweh) ch'a suya 'ink'ez yun k'ut Nod huwhutni-un 'et nenina, ha'nuyeh k'et Eden 'on daz ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","'Ink'ez Cain du'at t'einanzin, ulchan 'ink'ez Enoch ooyaz whuzdli. 'Ink'ez keyoh whuti 'uhoonla 'ink'ez duye' boozi', Enoch be hoozi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Irad 'en Enoch ooye' suli' 'ink'ez Irad, Mehujael ooye' suli' 'ink'ez Mehujail 'en Methushael, 'ink'ez Methushael, Lamech ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","'Et Lamech nane ts'ekoo ilhchoot, du'atke eni, 'ilhoghun oo'at, Adah boozi' 'ink'ez 'on 'at-un 'en Zillah huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","'Ink'ez Adah, 'en Jabal ooyaz suli'. 'En buzkehkene nimbali bet huwhut'i 'ink'ez khuna-i 'i nulhyeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Bulhutsin boozi' Jubal, 'en ndi harp 'ink'ez flute hiyulhni 'i be hujun, 'enne ts'iyawh hube 'abá. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah, 'en cha buzke hooni. 'Ilhoghun 'en Tubal-Cain hiyulhni. 'En mbe ndi 'utes 'ink'ez dulk'un te 'ink'ez lhuztih bulh yugha khuna 'enne ts'iyawh hubodulh'eh. 'Ink'ez Tubal-Cain bulhtus 'en Naamah ts'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","'Et Lamech du'atke 'ubulhni, “Adah 'ink'ez Zillah, soo zulhts'ai, dune ka sulhtsi huwa sisghi, chilh hoonts'i sundilhda' hukwa sisghi”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Cain k'utitnelh te, lhtak'ant'it tighan, 'et de Lamech lhtak'ant'it whunizyat 'on 'at lhtak'ant'it 'uwhultsuk-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam doo cha du'at t'enanzin whe ooyaz dune suli', 'en Seth yulhni. Eve 'utni, “Yak'usda (Elohim) 'uye' sgha nilhti, 'en Abel yuk'e naidalhti, Cain yuzilhghi-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth cha ooye' whuzdli', Enosh yulhni. 'Et ndoh dzin dunene Moodihti (Yahweh) boozi' be ka whehuninyih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ndi 'udustl'us, Adam ts'u haindene ghun 'unt'oh. Yak'usda (Elohim) ndet dzin 'uyinla dzin, Yak'usda (Elohim) ndot'en yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Dune 'ink'ez ts'eke bulh 'ubinla 'ink'ez soo hoonzoo-un hubulhni 'ink'ez yun ka dune'ne 'ubinla, dzin 'ubinla-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","'Ink'ez Adam 'ilho whunizyat whunizyat 'on 'at tat whunizyat (130) yus k'ut khuna' 'ink'ez ooye' yundot'en-un ooye' suli', Seth yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth ooye' suli' hukw'elh'az, Adam lhk'udit whunizyat whunizyai (800) be yus k'ut hukw'elh'az 'ink'ez ooye'ke, ootse'ke cha whuzdli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam khuna' 'uwhuldzoh hana'-un 'ilho hooloh whunizyat whunizyai 'on 'at tat whunizyat (930) yus k'ut khuna' 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth 'en 'ilhoh whunizyat whunizyai 'ink'ez kwulat be yus k'ut (105) khuna' whe Enosh ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosh ooye' suli' hukw'elh'az, Seth lhk'udit whunizyai lhk'udit 'on 'at lhtak'ant'it (807) be yus k'ut whe ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seth 'ilho hooloh whunizyat whunizyai 'on 'at 'ilho hooloh 'ink'ez 'on 'at nat be yus k'ut (912) whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh 'ilho hooloh whunizyat (90) 'ink'ez Cainan ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Cainan ooye' suli' hukw'elh'az lhk'udit whunizyat whunizyai 'on 'at whunizyat 'on 'at kwulat (815) be yus k'ut 'ink'ez ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh yinka inda' 'uwhulyiz-un 'ilho hooloh whunizyat whunizyai 'ink'ez kwulai' (905) be yus k'ut whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Cainan lhtak'antit whunizyat (70) khana' 'ink'ez Mahaleel ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Maheleel whuzdli hukw'elh'az, Cainan lhk'udit whunizyat whunizyai 'on 'at dit whunizyat (840) be yus k'ut 'ink'ez ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","'Et Cainan 'ilho hooloh whunizyat whunizyai 'ink'ez whunizyat (910) be yus k'ut 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahaleel lhk'utat whunizyat 'on 'at kwulat (65) be yus k'ut, 'ink'ez Jared ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared whuzdli hukw'elh'az Mahaleel lhk'udit whunizyat whunizyai 'ink'ez tat whunizyai (830) be yus k'ut 'ink'ez ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","'Et Mahaleel be yus k'ut lhk'udit whunizyat whunizyai 'ink'ez 'ilho hooloh 'ink'ez kwulat (895) be yus k'ut 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared yunka inda' 'ilho whunizyat whunizyai 'ink'ez lhk'utat whunizyat (162) be yus k'ut 'ink'ez nanki Enoch ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoch whuzdli hukw'elh'az Jared lhk'udit whunizyat whunizyai (800) be yus k'ut nahitna' 'ink'ez ooye'ke 'ink'ez oots'eke cha whuhuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared be yus k'ut 'ilho hooloh whunizyat whunizyai 'ink'ez lhk'utat 'ink'ez nat (962) be yus k'ut khana' 'ink'ez dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch lhk'utat whunizyat 'ink'ez kwulat (65) be yus k'ut khana' 'ink'ez Methuselah ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Methuselah whuzdli hukw'elh'az Enoch Yak'usda (Elohim) bulh nusa'az tat whunizyat whunizyai (300) be yus k'ut 'ink'ez ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enoch yun ka inda'-un tat whunizyat whunizyai 'on 'at kwulat (365) be yus k'ut 'et khana'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","'Ink'ez Enoch Yak'usda (Elohim) bulh nusa'az 'ink'ez hoolel, Yak'usda (Elohim) nayilhchoot huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah 'ilho hooloh whunizyai whunizyat 'ink'ez lhk'udit whunizyat 'on 'at lhtak'ant'it (187) be yus k'ut khuna 'et Lamech ooye' whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamech whuzdli hukw'elh'az, Methuselah lhtak'ant'it whunizyai whunizyat 'ink'ez lhk'udit whunizyat 'on 'at nanki (782) be yus k'ut whe khuna 'ink'ez ooye'ke 'ink'ez ootse'ke cha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","'Et Methuselah 'ilho hooloh whunizyat whunizyai 'ink'ez lhk'utat whunizyat whunizyai 'ink'ez lhk'utat whunizyai 'on 'at 'ilho hooloh (969) be yus k'ut whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamech 'en 'ilhoh whunizyai whunizyat 'ink'ez lhk'udit whunizyat 'on 'at nanki (182) be yus k'ut suli' 'ink'ez 'ilhoghun ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","'Ink'ez, Nowe be yoozi 'ink'ez 'utni, “Ndun 'en si k'unenunoo'ah neye 'ut'en ha 'ink'ez neba be oogha ts'ana-i, yun Moodihti (Yahweh) ye k'ehanya 'et huwa”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nowe yun ka neninya hukw'elh'az kwulat whunizyat whunizyai 'ink'ez 'ilho hooloh whunizyai 'ink'ez kwulat (595) be yus k'ut suli' 'et ooye'ke 'ink'ez ootse'ke cha whuhuzdli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech khana' nduwhulyiz-un lhtak'ant'it whunizyai whunizyat 'ink'ez lhtak'ant'it whunizyat 'on 'at lhtak'ant'it (777) be yus k'ut 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","'Ink'ez Nowe kwulat whunizyai whunizyat (500) be yus k'ut whe Shem, Ham 'ink'ez Japheth 'enne ooye'ke suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","'Et 'uhooja, ndi yun k'ut dune 'awet nus za 'uhuniltsuk whe 'ink'ez ts'ekoo bubuzkeh suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Yak'usda (Elohim) ooye'ke 'enne ndunne ts'ekoo dune ootse'kene huhinzooo hubo nilh'en. 'Ink'ez mbene la buka' huninzunne 'enne ts'ekoo bubu hilhchoot, bu'atke hole' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","'Et Moodihti (Yahweh) 'utni, “Syoghi 'aw 'ilhiz when dune bulh buch'az dotni ait'oh. 'Alha ndi yun k'ut dune unli 'et hoonts'i whunizyat whunizyai 'ink'ez nat whunizyai (120) be yus k'ut tileh whe ndi yun k'ut tidalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","'Et 'oh da' njan yun k'ut dunechone hanle'. 'Et hukw'elh'az Yak'usda (Elohim) ooye'ke 'enne ndi yun k'ut dune butse'ke buzisda 'ink'ez bubuzkehke yahonle'. 'Et ndunne dune whuzdli'ne, 'enne dune lhtuscho 'ink'ez nchane 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","'Et Moodihti (Yahweh) bunilh'en ndi yun k'ut dune huye untsi' tube ncha suli'. Ts'iyawh 'ahoolhyiz wheni ndune bubeni untsi', 'et whunilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","'Et Moodihti (Yahweh) tube huwu dzin unduda ndi yun k'ut dune 'inla-un, oodzi yo tube whunduda suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","'Et Moodihti (Yahweh) 'utni, “Mbene la dune ndi yun k'ut wheni 'ubuslane, soo ts'iyawh gak hubutiselh. Ndi dune 'ink'ez khuna-i, yun k'ut nulh'as-i 'ink'ez ndo dut'ai nudilh-i cha, 'i ts'iyawh. 'Et tube huwu sdzi unduda 'ubusdla 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","'Et hoonts'i Nowe 'en Moodihti (Yahweh) oonalh ndi ye nets'un unzoo-i 'et nahoon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nowe ts'u haindene hukw'eguz 'et 'uhoont'oh. Nowe 'en ts'ih'un dune unli, khuna da' whe 'aw ook'eholts'it hooloh. Nowe 'en Yak'usda (Elohim) bulh nuya inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nowe tane ooye'ke suli': Shem, Ham, 'ink'ez Japheth. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Yak'usda (Elohim) oonalh ndi yun k'ut ndulcho dune ninta' honilh'en 'ink'ez dune lhezudla-un, dulcho whe whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","'Et Yak'usda (Elohim) njan yun k'ut 'et whunilh'en whe 'alha tube ninta' whunt'en. Dunene, 'enne ts'iyawh soo ts'ih'un 'ants'i halhjut le'hint'oh suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Yak'usda (Elohim) 'en Nowe 'uyulhni, “Njan ts'iyawh ndai la usjiz-i, 'awet sba whulatoh suli'. Dunene 'enne bulagha ts'e ndi yun k'ut ts'iyawh be lhezudla-i be hodilhbun. 'Et whunilh'en, ndi yun ndulcho whe ndi khuna ts'iyawh yun k'ut husjiz-i, ts'iyawh bulh gak whutiselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ndi duchun gopher hiyulhni, 'i be ts'i cho 'ónleh. 'Ink'ez bez ts'e 'et lhelhdun whulai holhtselh. Dzeh 'i be bez ts'e 'ink'ez yoo'az ts'e cha be ondzeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","'Ink'ez 'et ndiz un'a ndi ts'i cho 'i 'onleh: 450 feet 'et 'uhoolhyiz, 'ink'ez 75 feet 'et 'uhooltel, 'ink'ez 45 feet naoodalhza'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Dadint'az cho ooba 'onleh. 'Ilho cubit ndo ooban whuts'un, 'et nenin'a holhtselh. Oozih k'ut 'et dati-un 'onleh. 'Udeyo-un yun cha 'onleh 'ink'ez 'on do cha 'udun 'uhoonleh, 'ink'ez bulh tad-un yun 'et 'uhonleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","'Et whunilh'en 'et si 'utisnelh, yun k'ut ndulhcho too hatadutisbilh. Yat whutah 'et gak whutiselh. Ts'iyawh ndai ndi usjiz be ts'ukhuna bulh 'unt'oh, 'i gak tileh. Ndi yun k'ut 'et ts'iyai yatadlah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","'Et hoonts'i nyun nts'un sghuni ntl'adutis'alh. 'Ink'ez ndi ts'i cho bez tonya', nyun, nye'keh, n'at, 'ink'ez nye'keh bu'atkeh cha, 'en dulh 'úbolneh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","'Ink'ez ndai la ndi yun k'ut usjiz-i, lhawh didoh 'ilho whe nawh didoh-i, 'i ndi 'i ts'i cho be onlelh. 'Et ts'iyawh khutinalh wheni ts'eke cha 'ink'ez dune cha unli-i didoh-i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Ndai la ndo nudilh-i dundult'oh-i, yun nulh'as-i dundult'oh-i cha, 'ink'ez yun nuts'eh-i dundult'oh-i cha, nanki dundult'oh-i ts'iyawh nts'un tidulh, khutinalh wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","'Ink'ez ndai la 'ut'alh-i ts'iyawh, tan'ulh-i ts'iyawh be 'onlelh, 'i ts'iyawh 'ulhonlelh. 'I la ooh'alh nyun 'ink'ez ndi khuna-i cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","'Et Nowe 'et nduja, nts'en'a Yak'usda (Elohim) yuba nahizya, 'et ts'iyawh nduja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","'Et whe Moodihti (Yahweh) 'en Nowe 'uyulhni, “Nyuzkeh cha, nyunch'oh cha, mbene la nyoh whut'ine ts'iyawh ndi ts'i cho behdilh, daint'oh la ts'ih'un dune inli, ndi 'andit dune toh ndoh whuya hoozulh dune toh daint'oh la ts'ih-un dune inli-un 'et whunus'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ndi yun k'ut khuna-i ootsun hooloh-i, lhtak'ant'i dune 'ink'ez ts'eke bulh 'ilhoh didoh-i nanki whe khuna-i tsiyawh. Ndi khuna-i dutsun-i cha, dune cha ts'eke cha, 'ohwhi 'i ts'iyawh olhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","'Ink'ez ndi yun k'ut ndai la nudilh-i dut'ai ts'iyawh cha lhtak'ant'i dune 'ink'ez ts'eke bulh cha, 'ohwhi ts'iyawh ndi yun k'ut khuna-i ndai la khutinalh-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Lhtak'ant'i dzin hukw'elh'az 'et ndi yun k'ut dit whunizyat (40) dzin 'ink'ez dit whunizyat 'ulhdzis whuts'un nawhutilhtilh. Ndai usla ndi yun k'ut usjiz-i ts'iyawh hooloh whutilhtselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","'Et Nowe nts'en'a Moodihti (Yahweh) yuba nahizya, ts'iyawh 'et nduja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nowe 'en 600 be nawhudizut yun k'ut inda whe ndi yun k'ut 'et dutadilt'o. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","'Et Nowe ooye'ke oo'at cha, 'ink'ez ooye'ke bu'atke cha ts'iyawh 'i nyoo ts'i cho huyeindil 'awet too ndo 'utinelh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ndai la khuna-i lhditsun-i 'ink'ez khuna-i dutsun 'i cha, dut'ai cha 'ink'ez ndi yun k'ut nulh'az-i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Nanki hinli whe ndi ts'i cho bez Nowe ts'un dahunilh'az, dune 'ink'ez ts'eke cha. 'Et nts'en'a Yak'usda (Elohim) 'en Nowe yuba nahizya, 'et nduhuja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","'Et hukw'elh'az lhtak'ant'i dzin inle' 'et 'awet ndi yun k'ut too whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nowe be yus k'ut-un, whunizyat lhk'utat whunizyat (600) 'et 'uhooja whulh nanki sanun (2) whunizyat 'on 'at lhtak'ant'it dzin (17) 'et 'uhooja ndi yun k'ut too ts'iyawh oodaha'dilts'ut, 'ink'ez ndo yak'uz whudadint'az cha whudaha'dankat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Dit whunizyat dzin 'ink'ez dit whunizyat 'ulhdzis 'et ndi yun k'ut yun chan honle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Soo 'et dzin za Nowe ooye'ke cha, Shem, Ham 'ink'ez Japheth, 'ink'ez Nowe oo'at, 'ink'ez ooyas'atke cha ts'iyawh ndi ts'i cho huyeindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","'Enne cha 'ink'ez ts'iyawh khuna-i lhelhts'un didoh, ts'iyawh musdoos lhelhts'un didoh, ts'iyai yun nulh'as lhelhts'un didoh, 'ink'ez yat whudut'ai lhelhts'un didoh cha, ts'iyai didoh lhelhch'a 'uwhut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nanki whe ts'iyawh Nowe bulh ndi ts'i cho huyeindil. Ndai la khuna-i ndi yun k'ut ooyiz hoonli-i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Et ndowhi ts'iyawh ts'ek'e dune tubulh. Ndi yun k'ut hoonli-i Yak'usda (Elohim) 'en yuba nahizya, whuz un'a ndi ts'i huye indil 'ink'ez buch'az na'din'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ndi hatadilt'o-i too dit whunizyat dzin (40) 'et 'ant'e' too ndo za lhe'inelh 'ink'ez ndi ts'i cho dudinlat yun ando ts'e whuz dudinlat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Too 'et za ndut'en 'ink'ez nus za lhe'itus ndi yun k'ut, 'ink'ez ndi ts'i cho 'oh nulat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","'Et ndi yun k'ut too tube takhulh suli'. Dzulh 'owhi cha ts'iyawh ba ndo hatadilt'o. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Ndo za 'ut'en (15 cubits) 'ink'ez ndi too dzulh ba ndo hatadilt'o. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","'Et ndi yun k'ut khuna-i nuhutnah-i, dut'ai cha, 'ink'ez musdoos ndunt'i-i cha, yun nulh'as-i cha, ts'iyawh dune cha ts'iyawh hooloh huzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Mbene la ooyiz hoonline husjizne, 'ink'ez hoonli husjiz-i 'ohwhi ts'iyawh yun k'ut 'unt'oh-i, ts'iyawh yaidla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","'Et ndi yun k'ut hoonli khuna-i ts'iyawh gak whulhtsi. Yun nulh'as-i cha, dune cha, 'ink'ez khuna-i cha, dut'ai cha, ts'iyawh gak whulhtsi. Nowe 'ink'ez yulh 'ut'enne 'enne za ndi ts'i cho bet hukhuna. ");
INSERT INTO crxNTpo_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","'Et whunizyat whunizyat 'ink'ez kwulat whunizyat dzin (150) 'et 'uwhulhyiz whe ndi yun k'ut too honle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","'Et Yak'usda (Elohim) Nowe 'ink'ez khuna-i ndai la usjiz-i ts'i bet ts'iyawh yulh 'unt'ohne whunalnih, 'ink'ez Yak'usda nilhts'i 'i 'uyinla 'i ndi yun k'ut nalhts'i, 'et too yo 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ndi yun k'ut too ts'iyawh 'ink'ez ndo yak'uz whudadint'az cha ts'iyawh yudana'dinla 'ink'ez yak'uz ts'un chan 'etsul 'uyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","'Ink'ez too ts'iyawh yo whe'ninle', whunizyat whunizyat 'ink'ez 'on 'at kwulat whunizyat dzin (150) 'et too yo 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","'Et ndi ts'i 'i nts'e ndi dzulh Ararat huyulhni 'unt'oh, 'i lhtak'ant'it sanun 'ink'ez whunizyat 'on 'at lhtak'ant'it dzin (17), 'i k'ut neninkez. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","'Ink'ez too yo 'uja 'ink'ez yo za lhe'inelh whunizyat sanun whuts'un, 'udechoo dzin 'et dzulh oolatoh hooltsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","''Et 'uhooja dit whunizyat dzin (40) 'etsul 'uhooja whe Nowe dadint'az 'i daha'idantan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Datsancho 'i yula ditni 'az ndulcho 'awh nut'o za ut'en, too gak tileh whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","'Et doo cha dut'aiyaz, 'imbin huyulhni, 'i yula ditni 'awet tila too yo 'uja ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","'Et ndi 'imbin 'aw noot'ah-un hooloh, 'et ka ndi ts'i cho yuts'un naoost'o, 'awhuz ndi yun ndulcho too hoonli. 'Et huwa Nowe dula be yuba tedilni 'ink'ez 'et danainilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","'Et doo cha lhtak'ant'i dzin 'et whubailh'e'. 'Et doo cha ndi 'imbin yuladitni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","'Et hulhgha 'et ndi 'imbin whusanat'o 'ink'ez duchun, olive hiyulhni, oot'an 'andit hanalhyai, 'i ooze yudiztan. 'Et 'awet Nowe t'eooninzin ndi yun k'ut 'awet too hooloh suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","'Et doo cha lhtak'ant'i dzin 'et huba ilh'e', 'et doo cha ndi 'imbin, 'i yuladitni 'ink'ez 'aw whusanalhit'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","'Et 'uhooja lhk'utat whunizyat yus k'ut 'ink'ez 'et 'udechoo yus k'ut (601), 'ink'ez 'udechoo sanun 'udechoo dzin sanun 'et yun k'ut naoodisgih. 'Ink'ez Nowe ndi ts'i ndo yudaha'dantan 'ink'ez whunilh'en ndulcho yun naoodisgih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","'Et whulh nanki sanun nat whunizyat dzin 'on 'at lhtak'ant'i dzin sanun (27), 'et yun naoodisgih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yak'usda (Elohim) 'en Nowe yulh yailhduk 'uyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nyoo ts'i tenanindaih ndai la n'at cha 'ink'ez nyuzkehke, du'atke tubulh tenanuhdilh ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ndai la tsi bet dalts'i'-i khuna-i usjiz-i ts'iyawh tenaninle, dut'ai cha 'ink'ez khuna-i 'ink'ez yun nulh'as-i cha, 'et si ndi yun k'ut lhai hoole'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","'Et Nowe teninya 'ink'ez buzke cha oo'at cha 'ink'ez bu'atke cha ts'iyawh bubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Khuna-i ndai la yun nulh'as-i cha, dut'ai cha, ts'iyawh lhulhdidoh-i, 'i ts'iyawh ndi ts'i huye haindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","'Et Nowe 'en Moodihti (Yahweh) ts'un loodel 'uzdilhk'un k'ut, 'i 'inla, 'ink'ez ndai la khuna-i 'aw lhditsun-i, 'ink'ez ndai la dut'ai 'aw lhditsun-i cha, 'ohwhi 'i k'ut yudalhk'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","'Et Moodihti (Yahweh) ndi sooltsun-i yunahoolhtsun. 'Ink'ez Moodihti (Yahweh) didutch'oh dudzi yo 'utni, “'Aw 'on 'at ndi yun dune gha 'aw ook'ehoosyih ait'oh. Dahint'oh la dune budzi ntsi' hintsool whuts'un, 'et hoonts'i 'aw doo cha 'on 'at khuna-i ndi yun k'ut gak hooselh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ndi yun hoonli whut'oh 'a' nukat-un 'ink'ez ha' nukat-un, whuzk'uz 'ink'ez whunulwus-un cha, khit cha 'ink'ez shin cha. 'Ink'ez dzenis cha 'ink'ez 'ulhdzis cha hoonli-un, 'aw 'etsul lhe'whutasnel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","'Et Yak'usda (Elohim) 'en Nowe 'ink'ez ooye'ke tucha ts'iyawh soo hoonzoo-un hubúlhni whe 'ubulhni, “Lhane cho oole' ndi yun doolhbun hubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ndi yun k'ut khuna-i ts'iyai huye ntiljut, dut'ai cha ndi yun nuhutnah-i 'ink'ez lho cha ts'iyawh nohla k'ez be huwant'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dant'i ts'iyawh usjiz 'i nukhutnah, 'i ut'alh-i nohba oole'. 'Et ndai ts'iyawh nohgha nusla, 'ut'an hanuyeh ts'u'alh-i hoonts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","'Et hoonts'i ndi khuna-i 'awhuz buzkai be khuna bulh 'unt'oh, 'i 'aw lhuzon'al. Ndi “be khutna”, 'i buzkai 'unt'oh ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","'Alha dune nyuzkai' hawhulhtsi de sbut hutiyin whe' hoont'oh. Khuna-i dune silhghi 'i hoonts'i whuz un'a za 'uhoont'oh. Dune 'uyoon dune silhghi-un mbe 'uja-un buzkai' ooka' nuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Mbe dune 'uyoon buzkai' whulhtsi-un, 'uyoon dune ndun dune 'uja-un yuzkai' whutilhtselh whe' hoont'oh, Yak'usda (Elohim) dune yulh ndult'oh yulhtsi 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","'Ink'ez nohni, lhane cho nohuzkeh oole'. Lhan'un cho ndi yun k'ut whut'enne lhane cho nohhuzke' hoole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","'Et Yak'usda (Elohim) Nowe 'ink'ez ooye'ke te 'enne 'ubulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“'Et si whunulh'en sghuni 'i bulh 'i nohbulh lhadusla. Mbene la nohts'u haindene nohk'elh'az 'enne cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","'Ink'ez khuna-i ts'iyawh nohbulh 'unt'oh-i, dut'ai cha, musdoos cha, 'ink'ez khuna-i ts'iyawh ndi yun k'ut hoonli-i nohbulh 'unt'oh-i, 'i ts'iyawh ts'i cho be nohbulh dehailh'az, yun k'ut khuna-i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Whuz un'a sghuni 'i bulh 'i nohbulh lhadusla. 'Aw doo cha za ndi yun k'ut ndai la khuna-i ts'iyawh usjiz-i, ts'iyawh 'aw too be 'aw huboosghan ait'oh. 'Aw doo cha za dutadilt'o whe ndi yun gak ooselh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","'Ink'ez Yak'usda (Elohim) 'utni, “Njan 'et si whehoodalh'eh khuni nohts'un lhadusla-i, si 'ink'ez nohni nohbulh, ndai ndi yun k'ut usjiz-i hoonli-i ts'iyawh 'ilhiz wheni khuni 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ditni na'anguz kw'us toh 'i 'usla. 'I gha whehoodat'en tileh si 'ink'ez ndi yun k'ut-i bulh khuna-i 'usla-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","'Et 'uhot'e, ndet yun k'ut, kw'us whulhlih teh, 'et ditni na'anguz 'i ts'unoolh'en kw'us toh 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ndai la nohni cha 'ink'ez khuna-i cha ts'iyawh 'i oonatiznih khuni nohts'un lhadusla-i, ts'iyawh 'aw doo cha 'on 'at too ndo hatadilt'o, yun k'ut hoonli-i gak ooselh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ditni kwun 'i kw'us toh hoonli de 'i nus'en de 'et whunatiznih, 'ilhiz wheni ndi khuni Yak'usda (Elohim) 'ink'ez ndi yun k'ut hoonli-i usjiz-i ts'iyawh khuni nohba lhadúsla, oonatiznih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","'Et Yak'usda (Elohim) Nowe 'ulhnni, “Njan whehoodat'en-un 'uhoont'oh, 'uwhusla-un, njan khuni nohba lhadúsla 'uhoont'oh, Si 'ink'ez ndi yun k'ut hoonli ts'iyawh usjiz-i bulh lhet'o khuni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","'Andit 'et Nowe ooye'ke 'en ndi ts'i cho be hahandil, 'en Shem, Ham, 'ink'ez Japheth. 'Ink'ez Ham, 'en Canaan be oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ndunne tane 'enne Nowe ooye'ke hinle, 'enne buts'u haidene. 'Enne bugha ndi yun k'ut whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","'Ink'ez Nowe hanuyeh-i ghana-un suli', duchun oomai' hoonli-i 'et 'uhoonla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","'Et ndi ts'ekoo too' 'uyinla-i yitnai' whe tanisnai' 'ink'ez ook'e'tizkat nimbali t'ah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","'Et Ham Canaan oobá 'en dubá ye 'ust'et yan'en 'ink'ez nane dulhusinke 'enne budani' 'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","'Et Shem 'ink'ez Japheth bulh naih hilhchoot 'ink'ez dut'a ts'e k'ehuyilhbal duwus k'ut 'ink'ez k'oh un'a hi'us whe dubá hik'ehuyin'oh 'aw dubá lhuhinilh'el, ye 'ust'et lhuhuyi'el. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","'Et Nowe ts'ekoo too' utnai' whe ts'eninzut, 'udek'oh-un duye' 'en dadudinla la 'et teoonanzin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","'Ink'ez 'utni, “Canaan ook'ehidih. Dune ba 'ut'en-un 'enne buba' tit'elh 'et la dudulhutsinke cha buba' titelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","'Ink'ez 'utni, “Moodihti (Yahweh) soo hoonzoo-un unli. Shem ooYak'usda (Elohim) 'unt'oh. 'Ink'ez Canaan yunat ne'ut'en-un oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yak'usda (Elohim) Japheth ncha yoolhts'elh, Shem oonimbali t'ah 'oh hoot'e', 'ink'ez Canaan yunat ne'oot'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","'Inkez Nowe butadilt'o hukw'elh'az 'et whunizyat tat whunizyat 'ink'ez kwulat whunizyat yus k'ut (350) 'et nakhitna'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","'Et Nowe 'alhgoh ndi yun k'ut inda'-un whunizyat 'ilho hooloh whunizyat 'ink'ez kwulat whunizyai yus k'ut (950) whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ndunne 'enne Nowe ooye'ke ts'u haindene Shem, Ham 'ink'ez Japheth, ts'iyawh buye'ke whuzdli' dutadilt'o hukw'elh'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth buzk'eh dunene, Gomer, Magog, Madai, Javan, Tubal, Meshech 'ink'ez Tiras. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomaer buzkeh dunene, Ashkenaz, Riphath, 'ink'ez Togarmah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan buzkeh dunene, Elishah, Tarshish, Kittim, 'ink'ez Dodanim. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Ndunne 'enne yatooba 'udun keyoh whut'enne buch'oh nehunindil didutch'oh duyun mbene la 'ilho khuni be za yalhdukne 'ink'ez dahint'oh la lhelhdoh hudidoh 'enne 'oh huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham buzkeh 'enne dunene, Cush, Misraim, Put, 'ink'ez Canaan 'uhant'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cush buzkeh 'enne dunene, Seba, Havilah, Sabtah, Raamah, 'ink'ez Sabtechah. Raamah buzkeh 'enne dunene, Sheba 'ink'ez Dedan 'uhant'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush 'en Nimrod ooye' suli', 'ink'ez Nimrod tube ulhtus ndi yun k'ut neninya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","'En 'unt'oh Moodihti (Yahweh) bunalh soo tube cho 'uka 'ut'en-un unli. 'Et huwa 'uwhutni, “Nimrod k'un'a Moodihti (Yahweh) bunalh soo tube cho 'uka 'ut'en-un unli.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","'Udechoo whu Lerwe suli'-un, 'en Babel, Erech, Accad 'ink'ez Calneh, Shinar yun k'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","'Et yun whuts'un Assyria 'ink'ez Nineveh huwhutni-un 'et cha 'uhoonla, Rehoboth Ir 'ink'ez Calah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","'Ink'ez Resen, Nineveh 'ink'ez Calah whulh eguz, 'et 'udechoo keyoh whuti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim buye'ke, 'enne Lud whut'enne, Anam whut'enne, Lehob whut'enne, Naphtuh whut'enne, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrus whut'enne, 'ink'ez Casluh whut'enne, 'enne Philistinene 'ink'ez Caphtor whut'enne hahande. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan 'en Sidon, 'udechoo ooye' yuzdli', 'ink'ez Heth; ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus whut'enne, Armor whut'enne, 'ink'ez Girgash whut'enne cha, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ndunne Hiv whut'enne, Ark whut'enne, 'ink'ez Sin whut'enne cha, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ndunne Arvad whut'enne, Zemar whut'enne, 'ink'ez Hanath whut'enne cha. 'Et hukw'elh'az Canaan ts'u haindene 'enne lhelhts'un yahandil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Canaan whut'enne whukeyoh whuban 'et Sidam, Girard ts'uwheti-un Gaza 'uwhuldzoh, Sodom ts'uwheti-un Gomorrah, Admah, Zeboim, Lasha ts'e 'uwhuldzoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ndunne, 'enne Ham ooye'ke ts'u haindene cha 'ilho khuni be yahulhduk 'ink'ez duyun 'ink'ez 'ilhoh hudidoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem 'en cha oobuzkeh whuzdli', Eber buzkeh, 'en ooba. Bulhutsin Japheth 'udetso whudilhdzulh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem ooye'ke, 'enne Elam, Assur, Arphaxad, Lud, 'ink'ez Aram. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ooye'ke, 'enne Uz, Hul, Gether, 'ink'ez Mash. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad 'en Shelah ooye' 'unt'oh, 'ink'ez Shelah 'en ooye' Eber 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber ooye'ke nane hinli. 'Ilhoghun boozi 'en Peleg. 'En khuna da' ndi yun k'ut lhts'e hoolts'ut 'et huwa. 'Ink'ez bulhutsin, 'en Joktan ts'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan ooye'ke 'enne Almodad, Sheleph, Hazarmaveth, Jerah, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Diklah, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Sheba, ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havilah, 'ink'ez Jobab. 'En ts'iyawh Joktan ooye'ke 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ndet la huwhut'i-un, Mesha, Sephar ts'uwheti-un nda' dzulh hoonli 'et huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","'Enne Shem ooye'ke ts'u haindene cha, 'ilho khuni yahulhduk. 'ilho hudidoh whe 'ilhoh huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ndunne 'enne Nowe ooye'ke ts'u haindene 'enne ts'iyawh lhk'ehidil ndi yun k'ut too whuzdli' hukw'elh'az. 'Ink'ez 'ilhoh huwhut'i ndi yun k'ut lhelhdoh 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ndi yun k'ut 'oh da' 'ilho khuni za hoonli ts'iyanne lhk'un'a yahulhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","'Et 'uhooja nda' ndaz de hutizdil whe yun, Shiner huyulhni, 'i hik'eindil 'et 'uhoont'oh duchun hooloh-un nahuhoon'ai 'et nehunina. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","'Et lhgha 'uhudutni, “'Anih, tse tl'us 'i 'uts'ooleh, 'ink'ez soo cho whe ts'oolht'es.” Tse tl'us 'i tse ba huyut'i 'ink'ez be ts'uwhudzeh, 'i hiye whutl'us ba. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","'Et 'uhutni, “'Anih njan keyoh whuti 'uts'odoolneh 'ink'ez ndo yak'uz nain'a-i nyiz-i cho 'i 'uts'ooleh. 'Et wheni si neoozi' hoonli hole', ndi 'uts'inla da, doo ka si ndulcho whe ndi yun k'ut yats'odilh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","'Et whe Moodihti (Yahweh) ndus de hainya 'ink'ez nyo keyoh whunilh'en 'ink'ez nyoo nain'a-i cho yoh huyulhtsi, 'i cha 'uhuyinla-i yunalh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","'Et Moodihti (Yahweh) 'utni, “A 'ilhune za hinli dune 'ink'ez lhk'un'a za yahulhduk. 'Et njan 'et azi whe'honilh'en ndai la 'uhitilelh hukwa' huninzun-un ts'iyawh si 'uhuhooleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","'Anih buts'un ts'utoodilh, 'ink'ez bughuni 'i buch'a lhtats'uholelh. 'Et si lhulh hoodosts'o.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","'Et whe Moodihti (Yahweh) lhch'a buninla, 'ink'ez njan yun k'ut ndulhcho nehunindil. 'Et whe dune whut'i whucho nehonin'ai 'et 'etsul 'uhuja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","'Et huwa nyo nain'a-i cho, 'i Babal huyulhni, ndai la huye yalhduk-i cha ts'iyawh Moodihti (Yahweh) lhelhts'un un'a yahulhduk hubulhtsi 'ink'ez ndulcho yahandil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Shem huyulhni-un, 'en oots'u hayandene ndi 'i 'unt'oh: whunizyat whunizyai 'et be yus k'ut (100) whe ooye' Arphaxad huyulhni, 'en ooye' suli' dutadilt'o hukw'elh'az nat yus k'ut 'et whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arphaxad ookelh'az whudli-un 'et Shem 500 yus k'ut 'et nahinda' whe 'et ooye'ke cha 'ink'ez ootse'ke cha nahodle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arphaxad 'en tat whunizyai 'on 'at kwulat be yus k'ut whe 'et Shelah huyulhni, 'en ooyaz suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelah whuzdli hukw'elh'az Arphaxad 403 be yus k'ut whe dune cha 'ink'ez ts'ekoo cha 'enne buzkeh nasdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah 'en tat whunizyat be yus k'ut (30) whe 'et ooye', Eber huyulhni, 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber hukw'elh'az 'et Shelah 403 yus k'ut whe 'et 'uyoonne dune cha 'ink'ez ts'ekoo cha buzkeh nasdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber tat whunizyat 'on 'at dit be yus k'ut (34) whe 'et Peleg huyulhni, 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","'Et Peleg ook'elh'az 'et Eber 430 yus k'ut 'uyoonne dune cha, ts'ekoo cha buzkeh nasdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg tat whunizyat be yus k'ut (30) whe 'et Reu huyulhni 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu whuzdli hukw'elh'az whe 'et Peleg nat whunizyat nat 'ink'ez 'ilho hooloh be yus k'ut (209) whe 'et 'uyoonne dune cha 'ink'ez ts'ekoo cha nawhusdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu tat whunizyat 'on 'at nat be yus k'ut (32) whe 'et ooye', Serug huyulhni, 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug whuzdli hukw'elh'az Reu 207 be yus k'ut whe 'et 'uyoonne, dune cha ts'ekoo cha buzkeh nawhusdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug tat whunizyat be yus k'ut (32) whe 'et Nahor huyulhni-un, 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor whuzdli hukw'elh'az Serug 200 be yus k'ut 'et 'uyoonne dune cha ootse'ke cha nawhusdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor nat whunizyat 'on 'at 'ilhohooloh be yus k'ut (29) whe 'et Terah huyulhni-un 'en ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah hukw'elh'az, Nahor 119 be yus k'ut ooye'ke 'ink'ez ootse'ke cha nawhuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","'Et Terah lhtak'ant'it whunizyat be yus k'ut (75) whe 'et Abram huyulhni-un, Nahor 'ink'ez Haran 'enne buzkeh suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","'Et Terah ts'u haindene: 'enne Abram, Nahor 'ink'ez Haran. Haran 'en Lot ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","'Ink'ez Haran 'en dubá yutso dazsai, didutch'oh dukeyoh 'et Chaldeanne bukeyoh 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","'Et Abram 'ink'ez Nahor bulh bu'at whuzdli'. Abram oo'at, 'en Sarai huyulhni, 'ink'ez Nahor oo'at, 'en Milcah huyulhni, Haran ootse', Milcah oobá 'ink'ez Iscah oobá. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","'Et Sarai 'en oochan danáwhudilts'ut, oobuzkeh hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","'Ink'ez Terah duye' Abraham, duchai Lot te, Haran ooye' 'ink'ez duyas'at, Sarai duye', Abram oo'at cha. Ur, Chaldean bukeyoh, 'et Canaan ts'e whehandil, keyoh Haran highu nindil 'ink'ez 'et huhoot'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","'Et whe Terah oodzin 'et 205 be yus k'ut yinka inda', 'ink'ez Terah 'en Haran keyoh ts'uwhutni, 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","'Et Moodihti (Yahweh) Abram 'ulhni, “Nkeyoh cha whuch'a sinyai', nyunatneke cha whuch'a sinyai', 'ink'ez mbá ooyoh cha teninyai', 'ink'ez yun whununtistun-un hoonli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tube didoh-un ncha-un nyutiselh, soo hoonzoon-un nts'un tiszoo' 'ink'ez nyoozi' cha ncha tiselh. 'Ink'ez 'uyoonne ba soo hoonzoo-un bugha hóotalts'ulh 'int'oh nyutiselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mbene la mba soo hoonzoo-un ngha hóotalts'ulh, 'enne cha soo hoonzoo-un bugha hóotalts'ulh, 'ink'ez mbe la nk'ehiyihne cha buk'ehutisyih, ndi yun k'ut dilhts'ine 'enne ts'iyawh nyun ngha soo hoonzoo-un bugha hóotalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","'Et Abram Moodihti (Yahweh) daja la 'et nduja whe tizya Lot 'en yulh tiz'az 'ink'ez Abram 'en lhtak'ant'it whunizyat 'on 'at kwulat be yus k'ut (75) whe 'et njan Haran huwutizya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","'Et Abram du'at yilhchoot 'ink'ez Lot oo'at cha hubilhchoot 'ink'ez ndai la huyut'i-i cha ts'iyawh nahuyalhdzoo 'ink'ez mbe la dune bugha nindene 'enne cha Haran, Canaan ts'e yun k'uz whehandil 'ink'ez Canaan nehunindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram 'oh whuya keyoh lhusuya 'ink'ez keyoh Shechem huwhutni-un Moreh duchun Terabim huyulhni, 'i nadan'a 'et whuts'un 'ink'ez Canaan whut'enne 'enne nyo yun k'ut hudilhts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","'Et Moodihti (Yahweh) Abram yunalh ts'et hainya 'ink'ez 'uyulhni, “Mbene la nts'u haindene 'enne ndi yun bugha ítas'alh.” 'Et Moodihti (Yahweh) yunalh ts'et hainya-un 'en yuts'un loodel 'inla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","'Et whuts'un Bethel huwhutni-un dzulh hoonli 'on da' whuz wheinya, 'et nimbali nenin'ai ba noo' 'et. Bethel 'ink'ez 'on da' 'et Ai 'et loodel nenin'ai. Moodiht (Yahweh) ts'un 'ink'ez Moodihti (Yahweh) yoozi' 'i yuka'dani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram 'et nyan za Negev lhoyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","'Et 'uhooja nyo keyoh dai whuzdli' 'inka Abram Egypt ts'e wheinya tube dai whuzdli' 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","'Et 'uhooja 'awet Egypt wheinghoh whe du'at Sarai 'uyulhni, “T'eoonuszun tube ts'eke inzoo' whe 'int'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","'Et huwa 'et la 'uhoneh Egypt nenit'az de nyo nilh'en whe 'et la 'uhudooni', ‘Ndun oo'at 'unt'oh,’ 'ink'ez la sozoolhghelh nyun 'aw nyozoolhghelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","'Et soo cho 'udoni' ndun 'en sulhutsin 'unt'oh 'et de la soo 'oost'e' nyun gha. 'Ink'ez la nyulh khoosna'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","'Et Abram Egypt neninya whe nyoonne Egypt whut'enne ts'eke hitilh'en whe tube ts'ekezoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Lerwe ooye'ke Pharaoh 'enne cha hinilh'en 'ink'ez dubá 'en hidani', “Ndun 'en tube ts'ekezoo',” 'ink'ez nyoon ts'eke 'en Pharaoh ooyoh ts'e huyoolhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Abram soo cho ne'huyulh'en nyoon oo'at 'en gha. 'Usbai cha musdoos dune cha donkey huyulhni, dune cha, ts'ekoo 'ink'ez dune cha hinat ne'ut'enne. Donkey ts'ekoo cha 'ink'ez camel huyulhni, 'i higha hininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","'Et hoontsi Pharaoh tube dada untsi'-i Pharaoh ooyoh cha 'et dinzut whulhtsi Sarai, Abram oo'at, 'en gha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","'Et Pharaoh Abram 'anih yudani', “Daneinla whe ne'inla? 'Et di ha lhunedinelh, ndun ts'eke n'at 'unt'oh? ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","'Et di ha 'une'dini, ‘Ndun sulht'us 'unt'oh?’ Nedini s'at eni da' 'oschoot oole'. 'Et huwa ndun n'at nailhchoot 'ink'ez nts'e tanyalh ts'e inyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","'Et Pharaoh dudune'ne 'ubulhni 'inka whenahuyalh'a' oo'at cha 'ink'ez ndai ts'iyawh yut'i cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","'Et Abram Egypt whuch'a huzdil, oo'at cha 'ink'ez Lot cha bubulh tiz'az whe ts'iyawh huyut'i-i tubulh nda' hutizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram tube hoonzoo' 'unt'oh, khuna-i cha lhai yut'i 'ink'ez silver ink'ez gold tubulh lhai yut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","'Et hutizdil Bethel whuts'un hutizdil ndet da' 'uda' nimbali nenin'ai inle' 'et 'udechoo whuts'un Bethel 'ink'ez Ai whulhetoh whuz hoozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","'Udechoo loodel nenin'ai inle' 'et whuts'un 'et whuz hoozdil. 'Et Abram Moodihti (Yahweh) yuts'un tenadidli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot 'en cha Abram bubulh tizya, khuna-i cha, musdoos cha, 'ink'ez nimbali cha, lhai cha ut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ndi yun 'aw soo lhe'ilcho hik'oh hutinalh huba 'aw lhzih huhoot'e' ait'oh, tube lhai hoonli ts'iyai hut'i k'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","'Et Abram bughunai' ghunline 'ink'ez Lot bughunai' ghunline 'enne 'aw 'ulhuholdzin ait'oh. 'Oh da' ndunne Canaan whut'enne 'ink'ez Periz whut'enne, 'enne cha njan yun k'ut huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","'Et Abram, Lot yulhni, “'Aw hoonli huwun nyun 'ink'ez si bulh lhdulhyoh 'udotni' ait'oh. 'Ink'ez si skhunai-i ghunline, 'ink'ez nyun nghunai-i ghunline, lhulh dulhyoh hudotni ait'oh. Lhulhlhutsinke ts'inli 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Nyoo yun lhe'ulcho-i nilh'en. Sch'a sinyai' 'intl'us ts'e whuz inyalh 'ink'ez si cha nailhni' ts'e toosya', k'us nyun nailhni' ts'e inyalh 'ink'ez si 'intl'us ts'e si toosya'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","'Et Lot whunilh'en Jordon keyoh duchun hooloh-un ts'iyawh yunilh'en. Too cha lhai whe' hoont'oh, (Moodihti (Yahweh) Sodom 'ink'ez Gomorrah bulh gak whutilhtselh whuts'o), Moodihti (Yahweh) hanuyeh k'et 'et nduhoont'oh inle', Egypt dahoont'oh la Zoar ts'u wheti ts'e, 'et nduhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","'Et Lot nyo yun k'ut Jordan whunat ts'iyawh 'et 'utahaoodit'ai, 'ink'ez nda' wheinya 'et 'ink'ez 'et lhch'a hust'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram 'en Canaan keyoh 'et nenina 'ink'ez Lot 'en keyoh whuti duchun hooloh-un 'ink'ez 'et nimbali nenin'ai Sodom whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","'Et hoonts'i nyoonne Sodom dunene tubeh hintsi', 'ink'ez Moodihti (Yahweh) ch'az lubeshi 'uhulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","'Et Moodihti (Yahweh) 'en Abram 'uyulhni Lot bulh lhch'a hust'az hukw'elh'az whe, “Whunilh'en ndet sinyin 'et whuts'un whunilh'en, no cha, nyan cha, nda' cha, 'ink'ez noo' cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ndai la yun nilh'en-i 'ilhiz wheni ts'iyawh nts'u haindene tubulh 'i nohgha nus'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","'Ink'ez nts'u hahande 'enne yun k'ut lhez k'un'a butiselh. 'Et whe dune yun k'ut lhez hodutilhto de, 'et si nts'u haindene 'enne cha si bulh olto. ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Dudinyaih 'ink'ez yun k'inyaih inyalh, dawhulhyiz la 'ink'ez dawhulhtel la ndi yun 'i ngha tis'alh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","'Et Abram dunimbali nanayan'ai 'ink'ez ndun Mamre ooduchun, Terabinth huyulhni, 'et nenina. Keyoh Hebron 'uhoont'oh 'ink'ez 'et loodel 'inla Yak'usda ts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","'Et 'uhooja Amraphel huyulhni, yun k'ut Shinar whulerwe Arioch, keyoh Ellasar whulerwe, Chedorlaomer, yun k'ut Elam whulerwe 'ink'ez Tidal Goiim whut'enne whulerwe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Bera huyulhni, Sodom whulerwe, Birsha huyulhni Gomorrah whulerwe, Shinab Admah whulerwe, Shemeber Zeboiim whulerwe, 'ink'ez Bela whulerwe, 'enne bubulh lhuwhehunigan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ndunne ts'iyawh lhts'u nehudindil 'ink'ez Siddim wheguz ('et 'uhoont'oh, lisel yatoo'). ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Whunizyat 'on 'at nat yus k'ut (12) 'et ndun Chedorlaomer huyulhni 'en ba' hit'en 'ink'ez whulh whinizyat 'on 'at tat yus k'ut (13) 'et hich'az nedindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Whulh whunizyat 'on 'at dunghi be yus k'ut (14) whe Chedorlaomer 'ink'ez nyoonne lerwe yulh 'ut'enne, 'enne hubulh whelhonigan, nyoonne Reph whut'enne, keyoh Ashteroth-Karnaim hudilhts'i, 'ink'ez nyoonne Zuz whut'enne, ndunne keyoh Ham hudilhts'i, 'ink'ez nyoonne Em whut'enne, 'enne keyoh Shaveh Kiriathaim hudilhts'i, ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","'ink'ez ndunne Hor whut'enne, 'enne dudzulh k'ut dzulh Seir 'et El Paran whuts'un 'uhoolhdzoh, chunt'oh 'uhoont'oh whenghoh 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","'Et lht'anahunisdil 'ink'ez keyoh En-mishpat (Kadesh 'uhoont'oh) whuz hutizdil Amalek whut'enne bukeyoh 'ink'ez Amor whut'enne bukeyoh 'enne Hazazon-tamar huwhut'en, 'enne bubulh whelhonigan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","'Ink'ez Sodom whulerwe, Gomorrah whulerwe, Admah whulerwe 'ink'ez Zeboi whulerwe 'ink'ez Bela whulerwe, Zoar huwhutni 'enne ts'iyawh lhts'u nehudindil 'ink'ez Sidom dzulh eguz whuz'ai-un 'et whelhonigan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","'Et Chedorlaomer, Elam whulerwe, Tidal, 'udun keyoh whut'enne bulerwe, Amraphel, Shinar whulerwe, 'ink'ez Arioch, Ellasar whulerwe, dine lerwe 'enne kwulane lerwe buch'az nehudindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","'Et njan Sidom dzulh eguz whuz'ai-un, asphalt huyulhni, lhai 'oh dunt'i 'ink'ez Sodom whulerwe 'ink'ez Gomorrah whulerwe bulh whe tse halhdil. Whulohne 'et yahadla, 'et mbene la lhch'u tizkatne 'enne ndo dzulh tuz whe tse halhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","'Et ndunne dine lerwene, 'enne Sodom 'ink'ez Gomorrah keyoh whuch'e' ts'iyawh huyilhchoot, ndai la hik'uhuna-i cha 'ink'ez whenahidil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot 'en cha huyilhchoot, Abram bulhutsin ooye' 'unt'oh. Sodom 'et whut'i, ndai la yut'i-i cha 'ink'ez ts'iyawh hiyulh whenadil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","'Et 'ilhoghun nintanalgai-un whe Abram, Hebrew whut'en-un, ghu ninya 'ink'ez yulhni. Abram 'en njan duchun, oak hiyulhni, 'et whut'i. Ndi duchun 'i ndun Amor whut'en, Mamre 'int'oh, 'en ye 'unt'oh-i 'unt'oh. Boono Eshcol 'ink'ez boono Aner 'en, Abram hits'u dutni 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","'Et Abram bulhutsin Lot huyulhna huyulhni whe dudune'ne 318 'enne hodil'e'ne yuba 'ut'enne, Abram hiyoh whuzdline, 'enne buba untizyoot keyoh Dan whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","'Enne ts'iyawh lhk'ebanla 'ink'ez 'ulhdzis whe yuba 'ut'enne tubulh ndunne bubulh whelhonigan Hobah whuts'un whenabonanyoot Damascus whano 'et 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","'Et ndai la huyilhchoot-i cha 'ink'ez bulhutsin Lot cha, highu huyilhchoot-i cha, ts'ekoo cha 'ink'ez dunene ts'iyawh nabuhilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","'Et Sodom whulerwe, Shaveh wheguz 'et, 'en Abram yududizya (Lerwe wheguz whuz'ai huwhutni), Chedorlaomer hich'a' nilhde hukw'elh'az 'ink'ez lerwe hiyulh 'ut'enne tubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","'Et Melchizedek Salem whulerwe, ut'alh-i cha 'ink'ez ts'ekoo too' cha 'i bubut neininla, 'en Yak'usda 'uk'enus dizti'-un (El Elyon) 'en oolubret 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Soo hoonzoo-un ubulh yalhduk whe 'utni “Yak'usda 'uk'enus dizti'-un (El Elyon) yak'uz 'ink'ez ndi yun k'ut cha ooch'e' hoonli-un 'en gha Abram soo hoonzoo-un oogha hootalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Yak'usda 'uk'enus dizti'-un (El Elyon) 'en soo hoonzoo-un 'unt'oh, nch'az ditnine nla k'ebanla.” 'Ink'ez 1/10th yut'i ts'iyawh yugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","'Et Sodom whulerwe Abram yulhni, “Dune 'enne sgha buninle 'ink'ez ndai la hoonli-i, 'i nyunch'oh ilhchoot.”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","'Et hoonts'i Abram Sodom whulerwe yulhni, “Ndi sla 'unt'oh usla Moodihti (Yahweh) Yak'usda 'uk'enus yoodo 'unt'oh (El Elyon) 'en oots'un duduzni, 'en yak'uz cha ndi yun k'ut cha ooch'e' hoonli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Aw hoonli lhituzaschulh 'ughabats'e' ntsool-i yaz k'us kenatl'oolh hoonts'i ndai la nch'e' 'aw hoschoot ait'oh, doo ka la 'udoni' ‘Abram hoonzoo' 'unt'oh susi doni' la,’. ");
INSERT INTO crxNTpo_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ndai la chilke hiyan'al-i 'ink'ez dune sulh tizdilne Aner, Eshcol 'ink'ez Mamre 'enne ooch'e' huyolhchoot dulhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","'Et nduhooja hukw'elh'az Moodihti (Yahweh) ooghuni Abram hon'en whe nduyulhni, “Abram, wheniljut ilhoh. Nyun mba kelatun usli, soo 'uk'enus mba k'elha whutale'-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","'Et hoonts'i Abram 'utni, “Moodihti Yak'usda (Adonai Yahweh) di sgha tan'alh? 'Aw suzkeh cha hooloh mbe la sk'edutiyalh 'en Eliezer Damascus whut'en-un eh 'unt'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","'Et Abram 'utni, “Whunilh'en 'aw suzkeh sghalhinlel. Mbe la syoh whuzdli-un 'en sk'edutiyalh-un tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","'Et whunilh'en, Moodihti (Yahweh) ooghuni weidilts'ut 'utni, “Ndun 'aw nk'elhdutisyal whe 'unt'oh nyunch'oh nyust'e ts'u hainzut-un 'en nk'edutiyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","'Et n'az teinilhti 'ink'ez 'uyulhni, “Ndo yak'uz ts'e whunilh'en sum hoolhto hukwa soo tila holhto.” 'Ink'ez 'et 'uyulhni, “Mbene la nts'u haindene 'et 'uhutiltsuk.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","'Et Moodihti (Yahweh) yuba 'alha 'udija, 'ink'ez ‘Ts'ih'un dune unli,’ 'uyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","'Et 'uyulhni, “Si, Moodihti (Yahweh) 'ust'oh. Ndunne Chaldea whut'en, 'et buyun k'ut Ur, 'et whuch'a njan yun k'ut nch'e' whutileh ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","'Et 'uyulhni, “SMoodihti Yak'usda (Adonai Yahweh), nts'en'a t'ewhuntazin stl'awhutikulh 'et?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","'Et nduyulhni, “Tat be yus k'ut-i musdoos ts'ekeyaz cha, tat be yus k'ut-i ts'eke 'usbai cha, 'ink'ez tat be yus k'ut-i dúbe cha, dut'ai 'imbin cha, turtle dove huyulhni, 'ink'ez dut'aiyaz cha, pigeon huyulhni, 'i ndiz sts'inlelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","'Et ndokhi ts'iyawh yughi ninla, ts'iyawh lhk'eyant'az lhzih neininla, 'et nyoo dut'ai 'i 'aw yut'alhanal. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","'Et whe dut'ai cho, vulture huyúlhni, 'i ndi khuna-i huyanghan, 'i yuk'endil whe Abram whenabunanyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","'Et hulhgha sa nain'ai whe soo bulh cho 'i Abram ookw'eidilts'ut 'ink'ez whunulh'en soo wheioonujut-un 'ink'ez tsaholhgus-un 'et ookw'eoodilts'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","'Et whe Yak'usda (Elohim) Abram 'uyulhni, “Soo soo cho t'eoononzeh, nts'u hainde 'en 'uyoo yun k'ut 'et 'aw t'elhonizun 'ink'ez 'aw hube' hoolhdzun chaíloh. 'Et ndunne yun k'ut whut'en, 'en dzoh ne'bulh'en 'ink'ez bunat ne'hoot'en whe 400 nawhudizut whuts'un buba' hutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","'Et mbene la buba' hit'enne hukw'elh'az buba nahutisyeh soo lhai hut'i whe whusahutidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","'Et hoonts'i, nyun mbákene soo ts'ih'un mba oodizghel le'hoont'oh 'et buts'un tanyalh. Soo yoo'un inzulh whe 'et 'anyotilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","'Et whulh dit dune nawhusdli-un, 'et ndiz nahutidulh. Amor whut'enne tank'us un'a 'uhut'en-un 'awhuz lhalhodusne.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","'Et 'uhooja, hulhgha sa yo whein'ai whe tsaholhgus whuzdli'. Whunulh'en lhes utes-un lhut oots'a hadan'a 'ink'ez dalt'ai bulh 'i ndi khuna-i lhts'elt'az-i beguz lhuyuzkat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","'Et dzin za Moodihti (Yahweh) Abram ts'un khuni ooba lhaidinla whe njan ndutni, “Nts'u haindene 'enne ndi yun bugha óonus'ai, Egypt whedinli ts'un 'ink'ez ndi 'uk'oh whucho, 'et Euphrates 'uk'oh whucho 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ken whut'enne cha, Kenez whut'enne cha, 'ink'ez Kadmon whut'enne cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitt whut'enne cha, Periz whut'enne cha 'ink'ez Reph whut'enne cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor whut'enne cha, Canaan whut'enne cha, Girgash whut'enne cha 'ink'ez Jebus whut'enne, 'enne cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","'Et Sarai, Abram oo'at 'aw buzkeh holoh inle', Egypt whut'en ts'eke yunatne'ut'en-un Hagar huyulhni 'en yut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","'Et Sarai Abram 'uyulhni, “Whunilh'en Moodihti (Yahweh) 'aw suzkeh hooloh sulhtsi, ndun sba ne'ut'en-un 'en 'inleh 'ink'ez 'et de tila ts'oodunne oost'e'.” 'Et Abram, Sarai yuk'un'a 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","'Et Sarai, Abram oo'at yuba ne'ut'en-un Hagar ilhchoot, Egypt whut'en-un unli 'ink'ez duki yugha inilhti, yu'at oole' ha. 'Et Abram whunizyat yus k'ut (10) 'et nyo Canaan keyoh inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","'Et Hagar t'einanzin 'ink'ez ulchan. 'Et ulchan t'eoonanzin, nyoon ts'eke yuba 'ut'en-un ooba yintsi' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","'Et Sarai, Abram 'uyulhni, “Whe ninta' nust'en-un nk'eholts'it! Ndun ts'eke ngha nusti 'ink'ez ulchan t'eoonanzin whe, oosts'u dutni suli'. Moodihti (Yahweh) nyun, si bulh neba nahutiyeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","'Et Abram, Sarai 'uyulhni, “A, 'alha nyun mba 'ut'en-un nyun nlak'et 'uhoont'oh, nts'en'a hukwa' ninzun-un k'un'a 'inleh.” 'Ink'ez Sarai yuba 'ut'en-un tubeh dzoh nayulhdzut, 'ink'ez Hagar yughu wheitselhya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","'Et Moodihti (Yahweh) oolizas nyo too naindli-un, chuntoh 'et whuzih, 'et nayilhti, nyo too naindli-un whuzih, Shur ts'u wheti-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","'Ink'ez 'uyulhni, “Hagar, Sarai ba 'ut'en-un, nts'ez de hainya 'ink'ez nts'e tinya whe 'int'en?” 'Et 'utni, “Sarai smoodih ooba 'ust'en-un ooch'a ts'e tisya whe ust'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","'Et Moodihti (Yahweh) oolizas 'uyulhni, “Ooba 'int'en-un oots'un naindalh 'ink'ez nts'e hukwa' ninzun-un k'un'a ne'nyoolh'en si.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","'Et Yak'usda (Yahweh) oolizas 'uyulhni, “Nts'u haindene lhane ngha tislelh. Huldlai k'et 'aw boots'olhto ait'oh tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","'Ink'ez Moodihti (Yahweh) oolizas, cha yulhni, “Whunilh'en 'awet ts'oodun bulh 'int'oh suli'. Dune nyaz tileh 'ink'ez boozi' Ishmael dutanelh. Njan tene'nilhdzun Moodihti (Yahweh) nyudants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Tube dune nzoodil'i-un tileh, ts'iyanne dune buch'az ditni tileh 'ink'ez ts'iyanne dune hich'az ditni tileh, 'ink'ez dulhutsinke butoh 'et dune tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","'Et Moodihti (Yahweh) yuts'u huyih whe 'en dulh yailhduk, “Nyun 'int'oh, ndun Yak'usda-Ndun-Sunilh'en (El Roi)” 'Ink'ez 'utni, “Mbe la si'en-un, si cha tila 'us'en eh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","'Et huwa njan too diz'ai-un 'et 'uwhuhutni Beer-La-Hai-Roi. Whunulh'en Kadesh 'ink'ez Bered bulh whetoh 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","'Et Hagar duneyaz 'en Abram yughu sulhtsi 'ink'ez Abram duye' yoozi Ishmael yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","'Et 'oh whuya whudizulh Abram 'en lhk'udit whunizyat 'on 'at lhk'utat be yus k'ut (86) whe Ishmael yughu yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","'Et Abram 'en 99 nawhudizut whe, Moodihti (Yahweh) yunalhts'et hainya 'ink'ez 'uyulhni, “Yak'usda 'Uk'enus 'Ultus-un (El Shaddai) ust'oh, stso inyalh 'ink'ez 'aw hoonli nk'elhuholhts'it. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","'Ink'ez sghuni nyun, si bulh lhadutalneh 'ink'ez 'onus lhane cha tihleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","'Et Abram yubut nachanitno 'ink'ez Yak'usda (Elohim) 'en yulh yalhduk, njan 'uyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“'Et si whunilh'en, khuni nts'un lhadasla-i 'udun keyoh whut'enne dune lhane 'enne bubá tanleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","'Aw 'on 'un Abram lhunyodutasnelh, nyoozi' Abraham nyo dutanelh, lhelhts'un whut'enne didoh lhane 'enne bubá nyuzusi 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Soo ts'ih'un lhane nts'u hakedande nyutiselh, lhelhdoh didohne dune nyutiselh, lerwene 'enne hoonts'i nts'u hahande tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","'Ink'ez khuni nyun bulh lhadilya-i, 'i 'et duta'alh nts'u haindene 'enne lhan'un te, ilhiz wheni ndi khuni lhadutalneh, Nyak'usda (Elohim) tisleh 'ink'ez nts'u haindene cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","'Ink'ez cha nyun cha 'ink'ez nts'u haindene nk'elh'az, ndi yun nohgha nus'ai, 'awhuz 'et t'enyuzinzun, Canaan yun ts'iyawh nohch'e' oole' 'ilhiz wheni, 'ink'ez buYak'usda tisleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","'Ink'ez Yak'usda (Elohim) Abraham 'uyulhni, “Nyun ndi khuni nts'un lhadasla-i ootahtun, nts'u haindene tubulh lhan'un te ndi khuni ootahtun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ndi 'i khuni nts'un lhadasla-i, 'i ootahtun, nyun 'ink'ez si bulh 'ink'ez nts'u haindene nk'elh'azne. Dune ts'oodunne whuzdline nohtoh 'enne ts'iyawh hika dune unli-un hubuhootat'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nyun ch'oh cha ooka dune inli-i nyo tit'us, 'et huwa t'entihdzeh ndi khuni lhadilya-i nyun, si bulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Mbe la lhk'udidzin be yus k'ut suli'-un, 'en cha hitit'us. Duneyaz 'andit whuzdline nyoh whuzdline, k'us sooniya be dune t'enuzuhzun ts'un ohket-un ts'oodun nts'u hainde lhilohne, 'en cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mbe la nyoh whuzdline 'ink'ez mbe la sooniya be ohketne, ts'iyawh ka dune unli-un hubotit'us, ndi sghuni nts'un lhadusla-i nus whe lhk'elh'az te 'et ndi 'i gha 'ilhiz wheni be hoodutaht'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","'Ink'ez dune ts'oodun 'aw lhuhuyit'us-un 'en 'udun nehuyolhtelh ndi khuni nts'un lhadasla-i k'eininyuz 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","'Et Yak'usda (Elohim) Abraham 'uyulhni, “N'at Sarai dini-un 'et 'etsul 'udonih 'ink'ez Sarah 'i boozi' tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","'Ink'ez soo hoonzoo-un ooba whutiselh 'ink'ez duneyaz 'en mba nyaz tileh. 'Ink'ez 'en soo hoonzoo-un ooba whutiselh 'ink'ez ndoh hidoh 'enne buloo tileh, 'ink'ez lerwene cha hits'u hatidoh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","'Et Abraham yubut nachanitno 'ink'ez udloh 'ink'ez dudzi yo ts'e 'utni, “Dune 100 be yus k'ut soo toleh ooye' whutaleh? 'Ink'ez Sarah 'en cha 90 be yus k'ut soo tilah ooyaz hole'?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","'Ink'ez Abraham Yakusda 'uyulhni, “Ishmael soo nyun ba khuna oole?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","'Et Yak'usda (Elohim) 'utni, “'Awundooh Sarah n'at nye' nghu tilhtsi 'ink'ez Isaac dutanelh. Sghuni lhadusla-i 'ilhiz wheni 'en cha oots'un lhadutisleh, mbene la oots'u haindene hukw'elh'az 'enne cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","'Ink'ez Ishmael 'en ghun nyudasts'o. Whunilh'en soo hoonzoo-un oogha whults'ut, 'ink'ez lhane oots'u hainde tileh. Whunizyane 'on 'at nane lerwe ye'ke oots'u hatidoh 'ink'ez 'en didoh-un ncha tíselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","'Et hoonts'i ndi sghuni Isaac ts'un lhadutisleh. Sarah ndo whuya whudizulh nat de, 'et nye' tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","'Et yulh yalhduk-un 'etsul 'udija 'ink'ez Yak'usda (Elohim) ndo whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","'Et Abraham duye' Ishmael yilhchoot 'ink'ez mbene la yuyoh whuzdline 'ink'ez mbene la sooniya k'elha bubonketne, dune ts'iyawh Abrahm ooyoh dilhts'ine 'et dzin za yuka dune unli-un hubuhuzt'us Yak'usda (Elohim) yulhni hukw'un'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham 'et 99 be yus k'ut whe yuka dune unli-un huyuzt'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","'Et ooye' Ishmael whunizyat 'on 'at tat be yus k'ut whe ooka dune unli-un huyuzt'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","'Et dzin za Abraham ooye' Ishmael 'en bulh hika dune unline hubuhuzt'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","'Ink'ez mbene la ooyoh dune 'et whut'ine, 'ink'ez sooniya be bubonketne, 'enne cha hika dune unli-un ts'iyawh hubuhuzt'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","'Et Moodihti (Yahweh) 'en Abraham yunalh hainya, njan ndun Mamre, duchun tah terebinth, oak huyulhni, whu'iz whunilghaz whe nimbali dati 'et usda. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ndo yutan'en 'ink'ez yutilh'en, tane dune yuzih nudilhya whe butilh'en. Nimbali dati ts'e dudilgai 'ink'ez bududilhgai 'ink'ez soo yun ts'e bubut nachaniti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","'Ink'ez 'utni, “SMoodih (Adonai) tube sba uszoo whe la 'usinla, 'andit khun te mba 'ut'en-un senghonya' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Sla'ineh whe tooyaz ntsool-iyaz whusaooskalh 'ink'ez sih nohke be tunaoohgus, 'ink'ez nyo duchun sa whus'ih 'et sih naoolhyis. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","'Ink'ez 'et ut'alh-iyaz nohba haóoslelh, 'et sih nohyust'e naóolhyis. 'Et hukw'elh'az sih 'oya lhohdilh. Nts'en'a nohba 'ut'en-un ts'un hahya 'et.” 'Et 'uhuyulhni, “Daja datanelh-un, 'et dineh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","'Et Abraham nimbali t'ah ts'e Sarah yughulgai 'ink'ez 'uyulhni, “Soo 'a tawh 'ultsuk-i lhes, 'i lhadinleh 'ink'ez nilhtlus 'ink'ez ilht'es.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","'Et Abraham khuna-i yughulgai 'ink'ez musdoosyaz soo unzoo-i yilhchoot 'ink'ez chilhyaz 'en yutl'ayalhti 'ink'ez soo 'ahoh lhaidutileh ha yilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","'Et butter cha 'ink'ez lilet cha 'ink'ez musdoosyaz lhadutja-i, 'i bubut neininla 'ink'ez buzih usyin whe nahuyit'al. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","'Et 'uyulhni, “N'at Sarah nts'e 'ut'en?” 'Ink'ez 'utni, “Nyo nimbali t'ah usda.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","'Ink'ez 'uyulhni, “Soo 'alha-i be ndo whuya whudizulh-un 'ink'ez 'et Sarah n'at dune ooyaz tileh.” 'Ink'ez Sarah nimbali dati usyin 'ink'ez yoozilhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","'Andit 'et Abraham 'ink'ez Sarah 'en tube hoonyan huzdli'. Yoo'un hizulh 'ink'ez Sarah en buzkeh whutaleh 'et tube 'on 'un hainzut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","'Et huwa Sarah duyo ts'e udloh 'ink'ez 'utni, “Nisjan hukw'elh'az 'ink'ez smoodih cha nisjan, 'et de sba hoonzoo whutaleh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","'Ink'ez Moodihti (Yahweh) Abraham 'uyulhni, “Di ha 'utni Sarah udloh, 'ink'ez 'utni, 'alha eh syaz whutaleh tube nisjan hoonts'i?’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","'Aw hoonli hoonts'i eh Moodihti (Yahweh) 'aw ooba hoolhtus eh? Ndet la 'et newhudizut-un 'et la nohghu naoosja' 'ink'ez Sarah dune ooyaz tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","'Et Sarah 'awundooh ni, “'Aw lhuzusdloh,” whenuljut. 'Ink'ez Moodihti (Yahweh) 'uyulhni, “'Awundooh, indloh inle'!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","'Et dune dunahudidil 'ink'ez Sodom keyoh ts'e whuz hunilh'en, 'ink'ez Abraham 'on 'un bubulh nunatit'us ha bubulh tiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","'Ink'ez Moodihti (Yahweh) 'utni, “Abraham ooch'a whuntis'ih eh datisnelh-un? ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Alha Abraham 'en didoh-un ncha 'ink'ez tube ulhtus tileh. 'Ink'ez 'en gha ts'iyawh didohne 'enne soo hoonzoo-un bugha hóotalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","T'eniszin duduzkeh buk'unuhilhye', yoh whut'ine cha buk'elh'az Moodihti (Yahweh) ookw'un'a huhoontun za' hint'oh ts'ih'un ne'hut'en, 'et de la Moodihti (Yahweh) Abraham daja yulhni-un 'et yugha whutalelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","'Ink'ez Moodihti (Yahweh) 'utni, “Sodom 'ink'ez Gomorrah bulh tube huwu yaduk hooni, hiye tank'us-i tube ntsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Whuz buts'un tisyalh 'andit 'ink'ez whuntis'elh daja hutni la sdabe cha hintsi'. 'Alha tila 'uhutni khuni sghu dinkat, 'et 'awundooh de la, 'et t'eoonooszeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","'Et nyoonne dune lht'anahunist'az 'ink'ez Sodom ts'e hutiz'az, 'et Abraham 'awhuz Moodihti (Yahweh) yubut usyin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","'Ink'ez Abraham yenghun neninya 'ink'ez 'uyulhni, “'Et whe eh ndunne ts'ih'un dune hinli 'ink'ez lubeshi 'uhulh'en bulh ts'iyawh gak butilhtselh? ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Khun te kwulat whunizyane (50) dune, 'enne ts'ih'un dune hinli njan keyoh whutoh 'et. 'Et cha eh ts'iyawh gak butalhtselh 'ink'ez buyun k'ut 'et cha eh gak whutalhtselh? Kwulat whunizyane 'et hudilhts'i hoonts'i? ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tube 'aw ndoneh ait'oh dune nzoone 'ink'ez ntsi'ne tubulh gak butalhtselh huba, ts'iyawh lhgha 'uhoot'e'! 'Aw ndi yun k'ut huwun nahiyilh-un, 'en ts'iyawh iloh lakw ts'ih'un un'a 'uhutit'elh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","'Et whe Moodihti (Yahweh) 'utni, “Sodom kwulat whunizyane ts'ih'un 'unt'ohne keyoh hoonli de, 'et de 'aw dalhubutuzislel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","'Et Abraham 'uyulhni, “Si 'ants'i yun lhez usli whe 'ust'oh, 'et hoonts'i Moodihti (Adonai) bulh yatisduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","'Et te kwulai' hukw'elh'ih whe whunizyane 'on 'at kwulane (50) ts'ih'un dune hooni te, 'et whe eh ts'ayawh gak whutalhts'elh ts'uwhut'i whucho 'et?” 'Et 'utni, “Dit whunizyai 'on 'at kwulane (45) nabinla te, 'aw ts'iyawh huboolhts'elh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","'Et doo cha za yulh yatilhduk 'ink'ez 'utni, “Dit whunizyane nabinla de?” 'Et 'utni, “'Enne bugha daboosleh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","'Ink'ez 'utni, “Moodihti (Adonai) khun te hunolch'eh junih, 'ink'ez yatisduk. Tat whunizyane 'enne ts'ih'un 'unt'ohne nainlane, 'et do'?” 'Et 'uyulhni, “'Et de 'aw gak lhubutuzissel tat whunizyane 'enne bugha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","'Et 'uyulhni, “'Ants'i sich'oh khanaoonust'ai whe 'udusni, Moodihti (Adonai) bulh yasduk, nat whunizyane 'enne nabinlane ts'ih'un 'unt'ohne?” 'Et 'utni, “'Et 'aw gak hubooselh ait'oh ndunne nat whunizyane 'enne bugha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","'Et 'utni, “Khun te Moodihti (Adonai) hunolch'eh junih 'ink'ez doo cha za yatisduk. Whunizyane nainla de 'et do'?” 'Et Moodihti (Yahweh) 'utni, “Whunizyane nasla de, 'enne bugha 'aw dalhubutuzislel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","'Et Moodihti (Yahweh) Abraham yalhduk-un 'etsul 'udija whe 'et 'awet yughu whenaja 'ink'ez Abraham dunimbali bez whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","'Et hulhgha nyoonne lizas nane Sodom ts'e hooz'az. Lot Sodom dati-un 'et usda, Lot hubutilh'en dudinya 'ink'ez bubut nachaniti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","'Ink'ez 'utni, “Njan whunulh'en smoodihne nohba 'ut'en-un ooyoh ts'e uh'us 'ink'ez 'ulhdzis 'et oohtez sih 'ink'ez nohke tunaoohgus 'ink'ez bundada' 'uda' cho duduh'az 'ink'ez sih tooh'as.” 'Et 'uhuyulhni, “'Awundooh 'et hoonts'i 'andit 'ulhdzis 'et 'az uztitez.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","'Et tube cho 'ubulhni, 'et huwa hiyoh highu danin'az 'ink'ez hiyu'alh-i bugha nin'ai ut'alh-i bulh yuntuldoh-i yit 'ink'ez 'i cha buba' yinla 'ink'ez 'uhan'al. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","'Et yun nehutilgwulh whuts'o nyo keyoh whudune'ne ts'iyawh dunetine cha 'ink'ez chilke cha ts'iyawh nyo yoh whunahusguz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","'Ink'ez Lot hits'uhuyih 'ink'ez 'uhuyulhni, “Nyoonne dune 'andit nghu danin'azne nts'e 'uhint'oh ndiz t'ebunilhtih 'et 'ink'ez sih t'ebuznoozeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","'Et Lot dati buts'u teninya yoh dana'dintan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","'Ink'ez 'utni, “'Awundooh sulhtsinke, tube hoontsi' 'et dohneh junih! ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Whunulh'en 'andit nane stse'ke 'aw dune t'enuszunne ust'i, 'enne nohghu tebostelh 'ink'ez nts'e hukwa' nuhzun k'un'a ne'boolh'en sih. 'Ants'i ndunne dune 'enne buts'ahalhuzoh'ai, njan 'et huwa 'andit syoh dahunin'az whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","'Et 'uhutni, “'Udun sinyin!” 'Et 'uhutni, “Ndun 'andit 'ants'iya whusainya 'ink'ez 'ants'i nahiyilh-un le' 'utni sih! Nyun 'onus nts'itilelh k'at ndune dune lhabuzdinla de!” 'Ink'ez Lot tube cho n'un hinilht'i 'ankw'us dati dahidanyuz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","'Et hoonts'i nyoonne dune nane 'az tehudilne 'ink'ez Lot danahinilhtsus 'ink'ez dana'hudintan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","'Ink'ez nyoonne 'az dati higha nane ts'iyawh huhoos̱'en hubuhulhtsi nchane 'ink'ez ntsoolne tubulh, nyoo dati nahuyotan ait'oh k'et nehunintsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","'Ink'ez nyoonne dune Lot 'uhuyulhni, 'Aw eh 'uyoonne cha njan hooloh? Nghundan, nye'ke, ntse'ke 'ink'ez mbe njan keyoh dilhts'i ts'iyawh whusabinle!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Sdabe cha 'uwhudija njan keyoh hoontsi' huwuyaduk, 'et huwa njan gak ts'otilhtselh. Moodihti (Yahweh) whunilh'en whe, 'en Moodihti (Yahweh) 'en ndiz netilh'a' njan gak ts'otilhtselh ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","'Et Lot teninya 'ink'ez dughundankene ootse'ke ghu dilhts'ine, 'ink'ez 'ubulhni, “Duduhdilh, njan whuch'asuhdilh! Moodihti (Yahweh) njan keyoh gak whutilhtselh!” 'Et ooghundankene 'enne buba 'ants'i la 'utni huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bundada' yulhkai whe nyoonne lizasne Lot huyulhni, “Soo 'a! Dudinyaih 'ink'ez n'at cha, ntse' nane cha, njan nzih 'unt'ohne, doo ka sih njan nohbulh whudok'un 'ink'ez dzoh notizut!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","'Et sa' ne'ut'en 'et nyoonne dune hila ilhchoot, oo'at cha hila ilhchoot, 'ink'ez ootse'ke nane 'enne cha bula ilhchoot, Moodihti (Yahweh) bugha te'ninzun whe, 'ink'ez teboninla keyoh yoo'az ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","'Et 'uhooja ts'iyawh teboninla hiyulhni, “Soo 'a tulhghas 'ududoolhyih sih! Khun te k'oh naitoht'en junih, k'us njan 'et te dolhts'i' junih, dzulh k'uz ts'e uhdulh doo ka sih gak oohle'!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","'Et Lot 'ubulhni, “Sla'uhneh whe, 'awundooh smoodihne! ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","'Andit nohba 'ut'en-un nohba unzoo be te'nuhzun-i be 'onus whusunilhtan be khusna-i ba sulhyi', 'et hoonts'i 'aw ndo dzulh k'uz toosya' ait'oh doo ka si hoontsi' sulh 'uhoneh 'ink'ez la daoosah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","'Andit whunulh'en njan keyoh whuyaz 'et nilhdukw whe' hoont'oh, whuz toosya', 'et de la szul khoona'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","'Ink'ez 'et 'uyulhni, “Whunilh'en tube nla 'usja whe' hoont'oh nja keyoh whuyaz 'aw gak hooselh ait'oh huwu yailhduk-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Soo 'a 'ududilyih! 'Aw hoonli 'oosneh ait'oh ndet la keyoh ninya whuts'un.” 'Et huwa nyo keyoh Zoar huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","'Awet sa hain'ai 'et Lot Zoar ts'e oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","''Et Moodihti (Yahweh) tse dunizk'un-i 'ink'ez kwun tubulh 'i Sodom 'ink'ez Gomorrah bulh nayalhtan ndo yak'uz whuts'un, Moodihti (Yahweh) 'en 'uhoonla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","'Et whuz un'a nyo keyoh gak whulhtsi, whunat cha 'et whut'ine cha, yun hanuyeh-i cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","'Et hoonts'i Lot oo'at k'oh whunalh'en whe lisel tse nain'a-i suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","'Ink'ez Abraham bundada' 'uda' 'et nyo whutsoda' Moodihti (Yahweh) yubut inyin-un, whuz oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","'Ink'ez Sodom 'ink'ez Gomorrah whulh yun tubulh nyo whulut yun cha oolut 'ants'i dizk'un-i cho le'hoont'oh whe ndo whein'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","'Et 'uhooja Yak'usda (Elohim) nyo keyoh gak whulhtsi hukw'elh'az 'et Yak'usda (Elohim) Abraham nalnih 'ink'ez Lot nyo hoot'e'-un keyoh gak whulhtsi 'uch'anayulh'a 'ink'ez 'uts'un whe yalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","'Et Lot Zoar whuch'a nasja 'ink'ez dzulh toh ts'e nenina, ootse'ke nane cha huyulh 'ut'en. Zoar whutit'elh-un whenuljut, 'ink'ez dutse' bulh nyo tse 'an 'et huwhuti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","'Et 'udetso whuzdli-un 'en dulhtus 'uyulhni, “Ndun nebá tube duneti unli 'ink'ez 'aw ndi yun k'ut dune hooloh suli' bubulh 'uts'oot'en-un hooloh, ndi yun huk'une'whuten. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","'Anih nebá ts'ekoo too' buts'oolhnai' 'ink'ez sih oozih ts'ootez, 'et de la nets'u haindene hoole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","'Et 'ulhdzis dubá ts'ekoo too' higha nilhdzo 'ink'ez 'udetso whuzdli-un 'en dubá yuchant'elget 'aw t'eoonuszun ndet yuchant'elget, 'ink'ez dunadija-un cha t'eoonuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Et 'uhooja 'om bun 'udetso 'udek'oh 'uyulhni, “'Alha sbá 'ulhdzis da' oobulh huste' inle'. Hulhgha doo cha za ts'ekoo too' buts'oolhnai' 'ink'ez nyun bulh hont'e. 'Et de la nets'u haindene hoole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","'Et 'ulhdzis dubá doo cha za ts'ekoo too' higha nilhdzo 'ink'ez 'udek'oh-un 'en dubá yuchant'inte', 'aw t'eoonuszun ndet yuchant'elget 'ink'ez dunadija-un cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","'Et whe Lot ootse'ke nahult'oh dubá higholchan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","'Udechoo whuzdli-un ooyaz dune suli', ink'ez boozi' Moab yulhni. 'En Moab dunene didohne, 'enne 'andit dzin whuts'un bubá unli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","'Ink'ez 'udek'oh-un 'en cha dune ooyaz suli' 'ink'ez boozi' Ben-Ammi yulhni. 'Enne Ammon dunene bubá unli 'andit dzin whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","'Ink'ez Abraham 'et whedinya whe nyan wheinya, Kadesh 'ink'ez Shur bulh 'et whulh eguz 'et hoot'e', ink'ez Gerar howhutni whuz cha whuloh te whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","'Et Abraham nyoon Sarah du'at, 'en 'ubulhni, “Sulhtus 'unt'oh.” 'Ink'ez Abimelech, Gerar whulerwe, 'en Sarah yilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","'Et hoonts'i Yak'usda (Elohim) Abimelech 'ulhdzis nute whe yughu ninya 'ink'ez 'uyulhni, “A, dune dazsai-un inli whe 'int'oh ndun ts'eke ilhchoot-un uyoon dune 'at 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","'Et hoonts'i Abimelech 'aw yuzih nulhiyal 'ink'ez 'uyulhni, “Moodihti (Adonai) dune ts'ih'un 'unt'ohne didohne ts'iyawh eh butanghan? ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","'Aw lakw sulhdinel, ‘Sulhtus 'unt'oh sulhdinel? 'Ink'ez didutch'oh cha 'utni, ‘Sulhutsin 'unt'oh,’ ni. Sdzi ts'ih'un 'unt'oh 'ink'ez sla cha 'aw lhditsun whe njan 'et dusja.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","'Ink'ez Yak'usda (Elohim) 'uyulhni nute whe, “A, t'eoonuszun ndzi ts'ih'un 'unt'oh whe 'inja 'ink'ez si cha ninta' tant'elh-un whuch'a nyostun whe 'ust'oh 'et huwa 'aw ootalhanal. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","'Andit 'et huwa ndun ts'eke ootl'a nayilhtih, nus hoo'en-un dune 'unt'oh, 'ink'ez si mba tenadoodli 'ink'ez khona'. 'Aw ootl'analhuyilhtel de, 'alha dantantsah whe 'int'oh 'ink'ez mbene la nch'e' unline 'enne cha ts'iyawh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","'Et 'om bun Abimelech 'uda' dudinya 'ink'ez mbene la yuba 'ut'enne ts'iyawh 'anih budani' 'ink'ez ts'iyawh daja ni la ts'iyawh bubudani', 'ink'ez dune ts'iyawh hunilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","'Ink'ez Abimelech, Abraham 'anih yudani' 'ink'ez 'uyulhni, “Dane inla whe 'int'oh? Ndet whe tank'us 'unyusla ha lhe'hoont'oh-un sk'ehoon'ai 'ink'ez njan whulerwe usli-un cha 'ut'en untsi'-i cha? 'Aw ndusonle' huba' lhe'hoot'oh whuz un'a 'usinla.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","'Et Abimelech 'en Abraham 'uyulhni, “Daja ninzun whe 'inja 'et dinja yulhni?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","'Ink'ez Abraham 'utni, “Dune Yak'usda (Elohim) ehunuljut-un njan keyoh 'aw hooloh nuszun, 'et huwa 'usja 'ink'ez s'at en gha tila sozoolhghelh nuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","'Et hoonts'i 'alha sulhtus 'unt'oh. Sbá ootse' unt'oh, 'aw sloo ooyaz iloh unt'oh 'ink'ez s'at suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","'Ink'ez 'et 'uhooja Yak'usda (Elohim) sbá ooyoh huwutisya whe 'et ndun ts'eke dusni, ‘Njan whe inzoo whe 'et ts'iyants'uk sba 'et doneh ntsoh te nit'as te, sulhutsin 'unt'oh doni'.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","'Et Abimelech 'usbai 'ink'ez musdoos dune cha, ts'eke 'ink'ez dune bulh, yunatne' 'ut'enne 'enne cha, ts'iyawh Abraham gha buninla, 'ink'ez yu'at cha yutl'anayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","'Ink'ez Abimelech 'utni, “Whunilh'en ndi syun njan mbut whuz'ai, ndet hukwa' ninzun-un, 'et hoont'i.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","'Ink'ez Sarah 'en cha 'uyulhni, “Whunilh'en nyulhutsin 1000 silver nukat-i 'i cha oogha inusla. 'I gha mbene la nyulh 'ut'enne cha 'ink'ez 'uyoonne nalh cha, 'awet ts'ih'un mba nawhúsdli' whe' hoont'oh!” 'Et whe hukwa' yudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","'Et Abraham Yak'usda (Elohim) ts'un tenadidli 'ink'ez Yak'usda (Elohim) Abimelech soo na'yinla, yu'at cha 'ink'ez ts'ekoo yunat ne'ut'enne cha, 'ink'ez bubuzke' whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","'Et whe Moodihti (Yahweh) ndunne Abimelech ooyoh dilhtsine ts'ekoo ts'iyawh buchan whudana'dinla, ndun Sarah 'en gha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","'Ink'ez Moodihti (Yahweh) 'en Sarah yughu ninya 'et whe ndutínelh ni da', 'ink'ez Moodihti (Yahweh) 'en Sarah ba nduja, nts'e datni 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sarah 'en ba Abraham ba ooye' tit'elh 'en duneyaz tileh. Hoonyan whe 'et ndet Yak'usda (Elohim) yuba yulhni-un 'et nduhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","'Ink'ez Abraham ndun ts'oodun yughu yulhtsi-un, duneyaz, Sarah yulhtsi, Isaac yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","'Ink'ez Abraham duye' Isaac hukwa dune unli-un yuzt'us lhk'udit dzin be, be inle' whe daja ni la Yak'usda (Elohim) ndoneh yulhni 'et nduja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","'Et Abraham whunizyat whunizyat be yus k'ut (100) whe 'et Isaac yughu yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","'Ink'ez Sarah 'utni, “Yak'usda (Elohim) usdlo-un sgha oonin'ai. Mbene la sudits'one ts'iyawh la sulh hoodloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","'Ink'ez cha 'utni, “Mbe suba Abraham yudoni' Sarah ts'oodun e'tilhtuk hidoni', duneti unli, 'et whe dune ooyaz ba 'ust'i suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","'Et ts'oodun nuye 'ink'ez 'ulhtuk-un 'etsul 'uja 'et dzin 'et Abraham dune ghu nusuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","'Et Sarah yunilh'en nyoon ts'eke Egypt whut'en ooye' 'unt'oh, Abraham dune ghu yulhtsi-un, yughudloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","'Et huwa Abraham 'uyulhni, “Ndun ts'ekoo 'ulhna 'ink'ez buyaz bulh tenabuninyoot. Ndun 'ulhna buyaz 'en 'aw syaz Isaac ts'iyai nk'elh'az yolhchoot ait'oh” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","'Ink'ez daja 'utni whe, 'et Abraham ooba nek'e'hoot'oh nyoon ooye' 'en ghun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","'Et hoonts'i Yak'usda (Elohim) 'en Abraham 'uyulhni, “Khun te mba dzoh 'uhoot'e' junih, ndun ts'eke k'us duyaz bulh 'en bughun, Sarah daja nyulhni la oozilhts'ai, Isaac 'en la toh ts'e dune whutaleh 'en, nyun nts'u haindene uhutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","'Et hoonts'i ndun ts'eke 'ulhna ooyaz, 'en gha didoh-un tiselh, nts'u hainzut 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","'Et Abraham bundada' 'uda' dudinya 'ink'ez ut'alh-i 'ink'ez too cha, duwus k'eyinla 'ink'ez duye', Hagar ooyaz 'en yugha ininla, 'ink'ez whenayalh'a'. 'Ink'ez whenaja ts'eke, Beersheba chunt'oh, dune lhuhóot'ih, 'oh nuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","'Ink'ez nyoo too cha haidalhde, 'ink'ez nyoon duyaz dune 'ilhoghun duchun sa whus'ih-un 'et neinilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","'Ink'ez yanch'az ts'ihyan natl'adida', k'aza be 'uhututsoh-un 'et 'uwhuldzoh, 'ink'ez didutch'oh 'ududutni, “Ndun syaz datitsah-un 'aw lhozoos'en.” 'Ink'ez yanch'az netladida' 'ink'ez whenintse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","'Et Yak'usda (Elohim) ndun ts'oodun utso yuduzts'ai. 'Et whe Yak'usda (Elohim) oolizas 'en Hagar yuts'un huyih yak'uz ts'un, 'ink'ez 'uyulhni, “Hagar, dainja whe 'udini? 'Aw whenilhjut iloh! Yak'usda (Elohim) ndun duneyaz yudants'o whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Dudinyaih 'ink'ez ts'oodun dudilhtih, 'ink'ez oola oontun, tube dune oots'u hatidoh whutiselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","'Ink'ez Yak'usda (Elohim) ts'eke hoon'en yulhtsi le'yinla 'ink'ez nyo too diz'ai-un ka k'et 'et whutilh'en, 'ink'ez nyoo 'uzuz be too sulhdzo-i nuya'a-i, 'i yudilhbun 'ink'ez duyaz cha too yugha nilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","'Et Yak'usda (Elohim) ndun duneyaz yulh 'unt'oh 'ink'ez nizyai. 'Ink'ez nyo chuntoh 'et whut'i 'ink'ez k'aza be' tutsoh suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Keyoh Paran huwhutni-un chuntoh 'et whuti 'ink'ez ooloo Egypt whut'en-un ts'eke 'en yuba yilhchoot oo'at yutaleh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","'Et 'uhooja 'owhuya whudizulh Abimelech 'ink'ez Phicol, lhuganne bumoodih, Abraham huyulh yailduk 'ink'ez 'uhuyulhni, “Nts'oh tila ne'int'en-un ts'iyawh Yak'usda (Elohim) nyulh 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","'Et huwa Yak'usda (Elohim) nalh sudini sts'u haindene cha ndun syaz cha, danyusla la ngha te'nuszun whe ne'nyuzus'en whe nyun cha whuz un'a ne'solh'en ndi yun k'ut cha, ookw'ut ninya-i cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","'Et Abraham 'utni, “A whuz un'a nahutisyeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","'Et Abraham, Abimelech hukwa' yudani', di ha Abimelech oonatne'ut'enne ndi too diz'ai-un ooghu huhoolhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","'Et Abimelech 'utni, “'Aw t'eoonuzuzun njan duhooja-un 'aw sulhdinel, 'andit dzin 'et 'andits'iya t'eooniszin.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","'Et Abraham 'usbai cha, musdoos dune cha, 'i Abimelech gha ininla 'ink'ez nahult'oh lhba khuni be ba lhaoodulya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","'Ink'ez Abraham lhtak'anti 'usbaiyaz, ts'ekoo 'usbaiyaz 'i udun neininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","'Et Abimelech Abraham yoodulhkut, “Dahoont'oh huwa ndi lhtak'ant'i 'usbaiyaz 'udun neninla?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","'Et 'uyulhni, “Ndi lhtak'ant'i 'usbaiyaz sla k'ez olhchoot 'i gha t'eoonudzun, njan too diz'ai-un si 'uwhusla whe' hoont'oh” ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","'Et huwa njan 'et Beersheba whulhni nahult'oh lhts'un nahuhisda-un 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","'Et njan Beersheba 'et khuni buba lhaoodulya, 'et Abimelech dunadija, Phicol lhuganne bumoodih bulh 'ink'ez Philistinene bukeyoh ts'e whuz whenahit'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","'Et Abraham nyo Beersheba 'et tamarisk duchun 'i nyoh 'et 'ainanla, 'ink'ez 'et Moodihti (Yahweh Olam) yuka huyih, 'en 'ilhiz wheni Yak'usda (El) unli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","'Ink'ez Abraham nyo Philistine bukeyoh 'et lhat dzin 'et usda. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","'Et njan hukw'elh'az 'et 'uhooja, Yak'usda (Elohim), Abraham yoolhdzai 'ink'ez 'uyulhni, “Abraham!” 'Et Abraham 'utni, “Njan 'ust'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","'Ink'ez 'utni, “Nye' ilhchoot, nye' 'aw 'ilhogun Isaac ilhchoot ook'eintsi', 'ink'ez yun k'ut Moriah ts'e whuz ilhtelh. 'Ink'ez dolhk'un nyo dzulh nyu dutasnelh-un, 'et si sts'un dolhk'un sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","'Et Abraham 'ombun 'uda' dudinya, donkey hik'e 'inla 'ink'ez nane chilke 'enne cha dudulh hubutilh'az, 'ink'ez ooye' Isaac cha. Tsuz cha lhts'uneidilhnat yudutalhk'un wheni, 'ink'ez dudinya. Whuz Yak'usda (Elohim) whuyuntilhtun-un ts'e whuz whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","'Et whulh tat dzin Abraham 'et Abraham ndo yutan'en, 'et nyo nilhdza' 'et whutilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","'Ink'ez Abraham nyoonne chilkeyaz 'ubulhni, “Njan donkey oozih suhke ndun tsoodun 'ink'ez n'un tat'us 'ink'ez Yak'usda (Elohim) oots'u teni'uznilhdzun, 'ink'ez sih nohghu naoot'as.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","'Et Abraham nyoo tsuz lhts'e nidilhnat-i yilhchoot 'ink'ez Isaac 'en yut'uyuz'ai yutooghe' ha. Didut kwun 'i yutiz'ai 'ink'ez lhuzti' cha 'ink'ez whehan'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","'Ink'ez Isaac, Abraham dubá yulh yatilhduk 'ink'ez 'utni, “'Ubá!” 'Ink'ez Abaraham 'utni, “Sye', njan si 'ust'oh.” 'Ink'ez Isaac utni, “Whunilh'en! Kwun cha tit'ai 'ink'ez tsuz cha, 'ink'ez 'usbaiyaz dutalhk'un-i daja?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","'Ink'ez Abraham 'utni, “Sye' Yak'usda (Elohim) didutch'oh la ndi 'usbaiyaz netla yoolhtelh,” 'ink'ez nahult'oh whehan'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","'Et ndet Yak'usda (Elohim) whenilhtan-un 'et nehunin'az 'ink'ez Abraham loodel 'inla 'ink'ez tsuz cha yuk'edinla 'ink'ez duye' Isaac yulhghel 'ink'ez tsuz yuk'eyilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","'Ink'ez Abraham lhuztih yilhchoot 'ink'ez duye' yutuzilhghelh ha do dutilhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","'Et hoonts'i Moodihti (Yahweh) oolizas yak'uz whuts'un yukahizya 'ink'ez 'utni, “Abraham! Abraham!” 'Et Abraham 'utni, “Njan 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","'Ink'ez 'uyulhni, “Nye' ook'edolnih junih k'us hoonli 'onle' junih! 'Andit t'eooniszin Yak'usda (Elohim) be niljut, nye' 'en hoonts'i ooch'a lhuyoontun 'aw 'ilhoghun nye', si sch'a lhoontun.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","'Et Abraham ndo yutan'en 'ink'ez whunilh'en njan oot'a 'et 'usbai dune whutoh ts'uldílhtan, 'et oode be usdlooh. 'Et Abraham whuz whenya 'ink'ez 'usbai dune yílhchoot 'ink'ez 'i be yuts'e' dalhk'un ooye' yuk'edalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham nyo hoozi' whulhtsi, “Moodihti 'En Negha 'oo'alh (Yahweh-Yireh),” whulhni. 'Et 'andit whuts'un 'i boozi unli, “Moodihti (Yahweh) oodzulh k'ut 'et la negha 'oo'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","'Et Moodihti (Yahweh) oolizas 'en ndo yak'uz ts'un whulh nat hikahuyih, ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","'et 'utni, “Sich'oh ooghu nahizusya,” ni Moodihti (Yahweh), njan 'et dinja-un huwa, 'aw nye' 'en hoonts'i 'aw 'ilhoghun nye' 'en hoonts'i sch'a lhoontun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Be soo hoonzoo-un 'i 'utisdlilh, mba soo hoonzoo-un tileh. 'Ink'ez nts'u haindene lhane whutaleh, sum k'un'a huldlai tileh, sai taba usdzai-i cha 'et 'ultsuk-i hutileh nts'u haindene, 'ink'ez nch'az ditnine bukeyoh 'i huyootatun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Nts'u hainde-un ndi yun k'ut dune ts'iyawh soo hoonzoo-un bugha hóotalts'ulh, sk'un'a 'inja 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","'Et Abraham chilkeyaz bughu nahunt'az, dunahudit'az 'ink'ez keyoh Beersheba ts'e whehandil, 'ink'ez Abraham keyoh Beersheba 'et whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","'Et 'uhooja hukw'elh'az Abraham hidani', “'Alha Milkah 'en cha buzkeh hooni Nahor nyulhutsin 'en buzkeh: ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","'Udetso ooyaz Uz huyulhni, bulhutsin Buz 'ink'ez Aram oobá Kemuel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed, Hazo, Pildash, Jidlaph, 'ink'ez Bethuel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","'Ink'ez Bethuel 'en Rebekah ooyaz suli', ndune lhk'udine 'enne Milcah, Nahor bubulhtsi, Abraham bulhutsin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nahor ndun oo'at 'en yugha yulhtsi 'unt'oh, 'en boozi' Reumah, 'en cha buzkeh hooni: Tebah, Gaham, Thahash, 'ink'ez Maachah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah 'en 127 be yus k'ut whe dazsai. 'Et njan duwhuldzoh Sarah khana'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","'Et Sarah 'en keyoh Kirjath Arba, (Hebron 'uhoont'oh) Canaan keyoh 'et dazsai 'ink'ez Abraham whusainya 'ink'ez Sarah yuk'enudleh 'ink'ez yuk'etso. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","'Et Abraham ooch'a dazsai-un oobut dudinya 'ink'ez Heth buzkeh 'ubulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“'Udun keyoh whut'en-un usli 'ink'ez ants'i nohtoh nusya. Yun sgha nuh'aih, ts'unk'ut wheni nohtoh sghu yaidlane 'et si 'abooslelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","'Ink'ez Heth ooye'ke 'uhuyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Nemoodih, neoozilhts'ai, lerwe ye' dune uncha-un inli whe 'int'oh netoh, ndet hukwa' ninzun-un hoonzoo-un 'et nghu yaidlane 'abinle, 'aw nch'a ts'uhotun ait'oh. Dune 'atanlelh-un 'et si nghu yaidlane 'abonlelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","''Et Abraham dudinya 'ink'ez Heth buzkeh soo yun bubut nachaniti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","'Ink'ez 'ubulhni, “Hukwa' nahzun de njan snanto 'et 'abuhoolelh, soo zulhts'ai, Ephron, Zohar ooye' 'en bulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Njan nyun k'ut whuz'ai-un ts'e'an Machpelah ooch'e', 'et sgha ho'alh, ndet 'ultsuk-un 'et la hosket 'ink'ez dune 'atislelh-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","'Et Ephron, Heth buye'ke butoh whut'i 'ink'ez Ephron Hitt whut'en-un 'unt'oh, 'en Abraham 'uyulhni. Heth buzkeh bunalh, njan keyoh whuti dati-un dandilhne 'uyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“'Awundooh smoodih! Soo zilhts'ai, njan yun 'ink'ez tse'an hukw'uh whuz'ai, nduwhulcho ngha oonus'ai ndune sdune'ne buzkeh bunalh ngha oonus'ai 'et nghu yaidlahne 'abinle.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","'Et Abraham ts'iyawh yun k'ut whut'enne bubut nachanitno, ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","'Ink'ez Ephron bulh yalhduk nyoonne dune bunalh ubulh 'uyulhni, “'Et sgha oonin'aih de soo zilhts'ai, sooniya hukw'elha tiselh njan yun, sooniya ilhchoot 'ink'ez 'et si sghu yaidlane 'abooslelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","'Ink'ez Ephron, Abraham 'uyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Smoodih soo zilhts'ai, ndi yun dit whunizyat whunizyai (400) 'ultsuk-i silver 'et di whutaleh da' nyun si bulh eguz, 'et nghu yaidlane 'abinle.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","'Ink'ez Abrham Ephron yoozilhts'ai, 'ink'ez Abraham nyoo silver nuyulhdaz Ephron yuts'iyoozi-i nyoonne Heth buzkeh bunalh, dit whunizyat whunizyai (400) silver 'et 'ultsuk-i, 'oh da' 'i yutl'ayandzai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","'Et Ephron ooyun Machpelah 'uhoont'oh inle', Mamre whuzih, yun 'ink'ez tse'an cha 'ink'ez duchun cha nanudiz'a-i ts'iyawh yuyonket. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","'Et Abraham nyoonne Heth buzkeh bunalh, 'ink'ez keyoh whuti dati 'et dandilhne cha, 'enne bunalh 'i oogha ininkat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","'Et hukw'elh'az Abraham du'at Sarah nyo tse'an 'et 'ayalhti, Machpelah ooyun k'ut, Mamre whuzih (Hebron 'unt'oh), Canaan keyoh 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","'Et nyo yun k'ut 'ink'ez tse'an cha ook'ut whuz'ai, 'i Abraham yonket, Heth buzkeh 'enne bubuyonket dune 'adutilalh wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham 'awet tube yoo'un uzulh 'ink'ez Moodihti (Yahweh) ts'iyaitsuk Abraham soo hoonzoo-un ba whulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","'Et Abraham yuba 'uten-un yoo'un uzulh-un, 'en yoh yuba huwunli-un ts'iyants'uk whumoodih yilh'i-un, 'en 'uyulhni, “'Anih njan swuz t'ah nedilnih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","'Ink'ez Moodihti (Yahweh) yak'uz whuYak'usda (Elohim), 'ink'ez yun k'ut whuYak'usda (Elohim) cha, 'en nalh sts'un nahitanyeh, 'aw njan Canaan whut'enne, 'enne butoh whust'ine buyaz ts'eke 'en sye' dune 'aw 'enne butoh 'aw oo'at sba tizulalhchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","'Et hoonts'i sich'oh skeyoh 'ink'ez sich'oh snatneke 'enne butoh 'et sye' Isaac oo'at ooba yitalhchulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","'Et nyoon yuba 'uten-un 'uyulhni, “'Ink'ez nyoon ts'eke 'aw ndiz hukwa lhe'nizun tila, 'et nye' whuz eh tistelh nts'ez de hakedanzut ts'e?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","'Et Abraham 'utni, “Huwinli 'aw sye' whuz tolhte' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yak'uz whuMoodihti Yak'usda (Yahweh Elohim) 'en sbá ooyoh 'ink'ez ookeyoh whuz de hasalhti, sulh yailhduk 'ink'ez sts'un nahizya 'usulhni, ‘Mbene la nts'u haindene ndi yun bugha inus'ai.’ 'En la oolizas ntso yutilh'alh 'ink'ez sye' oo'at yutaleh-un 'en whuz de hatalhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","'Et ndun ts'eke 'aw ndiz nyulh natit'us hukwa lhe'nizun de, 'et de ndi khuni be sts'un nahizinya-i gak natidleh, 'et hoonts'i 'aw sye' whuz tolhte' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","'Et nyoon hiba 'uten-un yuwuz t'ah nedilni Abraham 'ink'ez 'uyulhni, yutsu nahizya daja yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","'Et nyoon yuba 'ut'en-un, whunizyai oomoodih ooch'e' khuna-i, camel huyulhni, yilhchoot 'ink'ez whenya. Ndai la oomoodih ooch'e' ts'iyawh didut oola k'et yuzdla whe' hoont'oh 'ink'ez dudinya. 'Ink'ez yun k'ut Mesopotamia, Nahor ookeyoh, 'et whuz whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","'Ink'ez nyo keyoh whughu ninya whe tadiz'ai, too k'et whuz'ai, 'et nyoo camel dugwut ts'i be 'et nebuninla, 'owhuya whudizulh 'et ts'ekoo too huhudilh ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","'Ink'ez 'utni, “O Abraham smoodih ooMoodihti Yak'usda (Yahweh Elohim), soo ts'ih-un un'a lhaoodoosleh-un 'et sgha oonin'aih 'ink'ez smoodih Abraham soo te'ninzun-i be ne'olh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Whunilh'en njan too diz'ai-un 'et whuzih susyin, 'ink'ez njan keyoh whudune'ne butse'ke, too huhutidulh 'awet nilhdukw. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","'Et lhaoodonleh mbe la ts'ekeyaz 'udutasnelh-un, nyoo too be silhdzo-i yun nenin'aih oosnai' sih dusni-un, 'en sih dooni', ‘Too intnai 'ink'ez nyoo camel 'i cha si oogha taoo'alh,’ sulhni-un, 'en 'oot'e', mba 'ut'en-un Isaac oo'at wheni 'et si t'eoonoszin, 'awet smoodih oogha t'e'ninzun hukw'un'a 'inla.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","'Et 'uhooja 'awhuz yalhduk whe 'et Rebekah huyulhni-un, Bethuel ootse', Milcah ooyaz, Nahor oo'at, Abraham bulhutsin, 'en 'owhuya too ha tizya 'oosa' duwus k'ut yulh'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","'Et nyoon t'etyaz, tube ts'ekezoo' 'aw dune yat'alhasnai 'awhuz unli, 'et nyooz too ha tizya nyoo dude 'oosa' yudilhbun 'ink'ez nyus de hanaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","'Ink'ez nyoon Abraham yuba 'ut'en-un yududilhgai 'ink'ez 'uyulhni, “Sla 'ineh whe nyoo nye'oosa' be sulhdzo-i, too oosnai'-un sgha oonin'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","'Et ts'ekeyaz 'uyulhni, “Too intnai smoodihti.” 'Ink'ez 'aho dude 'oosa' duwus k'eitiz'ai 'ink'ez dula ts'un ye neinin'ai, 'ink'ez yugha tanilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","'Et hukw'elh'az too utnai lhadutja whe 'et 'utni, “Nyoon camel 'i cha sih too nahootnai'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","'Et soo 'aho 'et nyoo huye tatnai-i duchun 'i too huba idilhbun, 'ink'ez too diz'ai-un whuz whenalgih whe ndi camel ts'iyawh hititnelh huba. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","'Ink'ez nyoon dune t'edusnih 'et la Moodihti (Yahweh) whusainya-un, ts'iyawh lhaoodutneh tila k'us gak tila. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","'Et doo cha nyoo khuna-i camel tanatnai' hukw'elh'az 'et nyoon dune nyoo gwul dult'oh-i bunintsis huba, 'ilho shekel huyulhni, 'ilhudzin dune yuk'elha 'ut'ih-i 'uldaz lhulcho 'ink'ez nanki lachun huyulhya-i, 'i whunizyai shekel, 'i cha ts'iyawh gold 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","'Ink'ez 'utni, “Mbe ootse' inli whe 'int'oh? Sudini, mbá ooyoh neba soo' whulcho tilah 'et uztitez huba.?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","'Et 'uyulhni, “Si Bethuel ootse' Milcah ooyaz, 'en Nahor ooghu yulhtsi-un 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","'Ink'ez 'on 'un cha 'uyulhni, ‘Tl'o cha lhai ts'ut'i, 'ink'ez tihtez-un cha soo' whulcho.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","'Et dune yo nenint'ai 'ink'ez Modihti (Yahweh) yuts'un teni' nalhdzin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","'Ink'ez 'utni, “Ooba 'ust'en-un Abraham ooYak'usda (Elohim) 'ink'ez ooMoodihti (Yahweh) cha 'en doti'. 'Aw ndun ooba 'ust'en-un ye yugha te'ninzun 'ink'ez ye ts'ih'un 'unt'oh-i cha yulalhditnih. 'Et si 'owhuya usyalh Moodihti (Yahweh) 'en ndun ooba 'ust'en-un oonatneke 'en whusunilhtan, 'et whuz oozusya.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","'Et nyoon t'etyaz yoh ts'u whelgai 'ink'ez duloo ooyoh ts'e hubudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","'Et Rebekah bulhutsin, Laban huyulhni, 'ink'ez Laban 'en n'az yuts'un telhgai 'ink'ez nyoon dune too diz'ai-un yuzih usyin-un, 'en yuzih neninya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","'Et 'uhooja nyoo yuni wheni yugha ininla 'ink'ez nyoo lachun wheni gha ininla 'i cha yunilh'en 'ink'ez nyoon dulhtus ooghuni yudants'o 'et 'ink'ez 'utni, ‘Whuz un'a dune sulh yalhduk,’ 'ink'ez nyoon dune yubut neninya 'ink'ez 'et yubut usyin nyoo camel oozih cha too k'et whuzih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","'Et 'uyulhni, “Daninyaih Moodihti (Yahweh) dawhuldzoo'-un oogha whults'ut! Di ha dati sinyin? Yoh lhaoodusla 'ink'ez khuna-i, Camel, cha ba lhaoodusla.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","'Et nyoon dune yoh daninya 'ink'ez nyoo khuna-i camel, 'i cha yuk'e' tizdla 'ink'ez tl'o cha yuti'ulh-i cha yubut neidilhdze. 'Ink'ez too duke ye tunatigus-i cha 'ink'ez nyoonne dune yulh nudilhne, 'enne cha buke huye tunatigus inle' buba 'et neininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","'Ink'ez ut'alh-i cha bubut nehuninla 'ink'ez 'utni, ‘Ndet huwa njan whusasya-un 'awhuz lhunoduzusnih whe 'oos'alh ait'oh.” 'Ink'ez 'uyulhni, “A, yailhduk!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","'Et 'utni, “Abraham ba 'ut'en-un usli whe 'ust'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Moodihti (Yahweh) 'en smoodih tube soo hoonzoo-un yuba whulhtsi 'ink'ez dune ncha-un suli'. Khuna-i didoh-i ts'iyawh 'ink'ez silver 'ink'ez dizti'-i gold dunt'i-i, 'ink'ez dune cha, ts'ekoo yuba 'ut'enne cha 'ink'ez ndi camel cha 'ink'ez donkey cha lhai yugha ninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","'Ink'ez Sarah, smoodih oo'at, 'en dune ooyaz suli', tube hoonyan unli, 'et hoonts'i. 'Ink'ez 'en huye ts'iyai ut'i ts'iyawh yugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","'Et smoodih nahinyeh sulhni, 'inka nahizusya, ‘'Aw Canaan whut'enne buyun k'ut whust'ine 'enne buts'u hainzut-un sye' oo'at olhchoot juni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","'Et hoonts'i sba ooyoh 'ink'ez snatneke butoh 'et sye' ba oo'at olhchoot.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","'Et smoodih 'udusni, ‘Ndun ts'eke 'aw sulh natit'us hukwa lhe'nizun de?’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","'Et hoonts'i 'usulhni, ‘Moodihti (Yahweh) mbe la ootso nusya-un, 'en lizas yulh ti'us ha yutl'aitilhtelh 'ink'ez inyalh whe soo' hoont'oh whe sye' ba oo'at snatneke butoh 'ink'ez sbá ooyoh whuts'un, whuz de hainzut-un 'en ooba yutalhchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ndet la snatneke butoh ninya de, ndun ts'eke 'aw hukwa lhe'hunizun de, be ts'u nahizinya-i gak natidleh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","'Et 'andit dzin nyo too diz'ai-un 'et nenusya whe 'udusni, ‘O Moodihti (Yahweh), ooba 'ust'en-un Abraham ooYak'usda (Elohim), soo sba lhaoodonleh nts'e usyalh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nulh'en too diz'ai-un whuzih susyin whe 'et de la 'uhoneh t'et oot'alhe'asnai-un, too ha tiyalh 'ink'ez 'udusni, “Tooyaz sgha nilhdzeh nyoo nye 'oosa' be.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","'Ink'ez 'usudutanelh, “Too intnai 'ink'ez nyoo nghuna', Camel, 'i cha sih too ooba 'oosleh ititnelh-i,” Moodihti (Yahweh), 'en ts'eke 'oot'e' smoodih ooba 'ust'en-un, ooye' 'en ba oot'e'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","'Et hoonts'i 'awhuz sdzi bez yasduk whe Rebekah 'owhuya uyalh dude 'oosa' duwus k'uyulh'ai 'ink'ez too diz'ai-un ts'e tainkai 'ink'ez 'udusni, ‘Awe' too sgha nilhdzeh tisnelh-i.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","'Ink'ez soo 'ahoh 'et dude 'oosa' duwus k'etiz'ai 'ink'ez 'usulhni, ‘Too intnai 'ink'ez nghuna' 'enne cha sih too buba 'oosleh.’ 'Ink'ez too usnai' 'ink'ez sghuna', 'i cha too yutitnelh-i ba lhaidinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","'Et ooduskut 'ink'ez 'udusni, ‘Mbe oots'e' inli whe 'int'oh?’ 'Ink'ez 'utni, ‘Bethuel ootse', Nahor ooye' Milcah ghu yulhtsi-un inle'-un.’ 'Et nyo ooni huba cha 'ink'ez lachun huba cha 'i oogha inusla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","'Et stsi be yo 'usja 'ink'ez Moodihti (Yahweh) ts'un tení' nalhdzin, 'ink'ez smoodih Abraham 'en ooMoodihti Yak'usda (Yahweh Elohim) 'en ooba soo hoonzoo-un whulhtsi, 'en whuz be nts'e ts'ihnus ts'un 'utisnelh whe smoodih be 'ilhoghun 'en ootse', 'en 'utahatálhtelh smoodih ooye' ba. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","'Et soo te'nuzun whe ts'ih'un 'un'a smoodih 'utilelh suduhni, 'et 'awundooh de, 'et de natisdalh nailhnih ts'unk'us tila toosya', k'us 'intl'us ts'e tila natooja', 'et sudohni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","'Et Laban 'ink'ez Bethuel bulh 'uhuyulhni, “Moodihti (Yahweh) ts'u hahoolts'ut whe' hoont'oh, 'aw hoonzoo-un hukw'un'a k'us hoontsi' k'un'a nyulh yats'oolhduk ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Njan Rebekah, mbut usyin ilhchoot 'ink'ez naindalh. 'En ooba 'int'en-un ooye', oo'at ooleh sih, Moodihti (Yahweh) yatilhduk hukw'un'a.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","'Et hukw'elh'az Abraham ba ne'ut'en-un ndi khuni yudants'o whe, 'awet yun nachaniti 'ink'ez Moodihti (Yahweh) yuts'un teni' nalhdzin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","'Et nyoon Abraham yuba 'ut'en-un, dizti'-i khuts'ulhya-i, silver cha, 'ink'ez gold cha 'unt'oh 'ink'ez naih cha, 'i Rebekah yugha ininla, 'ink'ez dizti'-i bulhutsin cha 'ink'ez ooloo cha 'i bugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","'Et whe didut 'ink'ez dune hiyulh nudilh 'enne 'uhan'alh 'ink'ez tahitnai'. 'Et 'ulhdzis nduhoolhyiz 'et hantez. 'Et whe bundada' duhudindil 'ink'ez 'et 'utni, “Sumoodih ts'un nasalh'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","'Et hoonts'i Rebekah bulhutsin 'ink'ez ooloo cha 'uhutni, “Whute ndet t'et 'atsul nezih naooda' whunizyat dzin at'en, 'et de hukw'elh'az 'et sih nyulh natoo'as.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","'Et 'ubulhni, “Dah sudohni' junih! Moodihti (Yahweh) 'en lhe'whuldzoo'-un sba whulhtsi. Sk'oh ndiz nutisyalh-un, whute nasilh'alh smoodih ts'un natoosja'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","'Et 'uhuyulhni, “Ndun t'etyaz 'anih ts'udoni' 'ink'ez didutch'oh ts'oodolhkut.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","'Et Rebekah, 'anih, hidani', 'ink'ez 'uhuylhni, “Ndun dune bulh tan'us eh?” 'Et 'utni, “A, whuz toosya' lah.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","'Et 'inka Rebekah dudulhtus 'ink'ez yughunli-un ts'eke, 'ink'ez Abraham yuba 'ut'en-un 'ink'ez dune tubulh ubulh whe huyalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","'Ink'ez Rebekah soo hoonzoo-un hiba tenadidli 'ink'ez 'uhuyulhni, “Neulhtus, lhez te whunizyai lhk'uz te (100,000,000) dune buloo onle' sih 'ink'ez nts'u haindene mbene la buts'u dutnine hukwuti-un dati 'i himoodih oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","'Et Rebekah 'ink'ez mbene la yuba 'ut'enne ts'ekoo, dodindil 'ink'ez nyoo Camel hik'etl'adiltsi', nyoon dune huyuntizdil 'ink'ez Abraham hiba 'uten-un, Rebekah hubilhchoot 'ink'ez nahutisdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","'Et Isaac nyan whut'i Beer-lahai-Roi huwhutni, nts'un tsun whuz whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","'Et Isaac hulhgha nus 'a yun k'ut nuninuzut ha whuz oozya. Ndo yutan'en 'ink'ez whunilh'en, 'et nyo camel whuz de nal'us. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","'Et Rebekah ndo yutan'en 'ink'ez Isaac yunilh'en whe camel yuk'utizya, nyoo khuna-i k'usda-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","'Et nyoon ba 'ut'en-un yoodulhkut, “Nyoon dune nets'oyalh-un, mbe whe 'ut'en?” 'Et ndun ba 'ut'en-un 'uyulhni, “Smoodih 'ut'en.” 'Et Rebekah dunin k'e'nilhbal. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","'Et nyoon Abraham yuba 'ut'en-un nts'oh tila dat'en-un 'et Isaac yudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","'Et Isaac duloo Sarah oonimbali t'ah ts'e Rebekah dainilhti 'ink'ez Rebekah yu'at suli', 'ink'ez yuk'entsi'. 'Et Isaac ooloo dazsai whe tube k'enainin'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","'Et Abraham oo'at cha, Kuturah huyulhni, 'en yughu nasda. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","'En cha yuba buzkeh hooni, Zimran, Jokshan, Medan, Midian, Ishbak, 'ink'ez Shuah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan 'en Sheba 'ink'ez Dedan bulh buzkeh suli', 'ink'ez Dedan ooye'ke 'enne Asshurim Lutushim 'ink'ez Leumim. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","'Ink'ez Midian ooye'ke, 'enne Ephah, Epher, Hanoch, Abida 'ink'ez Eldaah 'enne ts'iyawh Kuturh buzkeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","'Ink'ez Abraham ndai la yut'i-i ts'iyawh Isaac gha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","'Et hoonts'i Abraham 'uyoonne ts'ekoo oo'at bugha nyus 'uhint'ohne, 'enne bubuzkeh 'enne cha buts'e'tilhdil, butl'a'andla 'ink'ez ooye' Isaac yuch'az nda' 'uts'un keyoh ts'e whuz whe balh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Njan duwhultsuk yus k'ut 'et ndi yun k'ut inda' Abraham 175 yus k'ut 'et ndi yun k'ut inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","'Et Abraham 'en 'udek'ez hanaji 'ink'ez soo hoonyan suli' whe dazsai. Tube hoonyan 'ink'ez ndi yinka inda' 'et ba whudizbun. 'Et whe dudune' 'enne buts'un whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","'Ink'ez ooye'ke Isaac 'ink'ez Ishmael, 'enne nyo Machpelah tse'an 'et 'ahuyalhti. Mamre whutso Ephron ootl'o k'ut, Zohar Hitt whut'en-un, 'en ooye', 'et nyo tse'an 'et 'ahuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Nyoo tl'o k'ut Abraham Heth buzkeh buts'un yonket-i, 'et Sarah oozih 'et Abraham 'ahuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","'Et whe lhuwhuzut Abraham dazsai hukw'elh'az, 'et Yak'usda (Elohim) 'en ooye' Isaac soo hoonzoo-un yuba' hoonla. 'Ink'ez Isaac 'en Beer Lahai Roi 'et whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ndunne 'enne Ishmael ts'u haindene: Ishmael 'en Abraham ooye', Hagar Egypt whut'en-un, 'en Sarah yunatne'ut'en-un, 'en ooyaz, 'en Abraham yughulhtsi-un ooye'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ndowhi 'i Ishmael ooye'ke buboozi': 'udechoo Nabaioth, 'et hukw'elh'az Kedar, Adbeel 'ink'ez Mibsam, ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Dumah, Massa, ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Naphish, 'ink'ez Kedemah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","'Enne Ishmael ooye'ke 'uhint'oh. Ndi 'i buboozi nts'e bukeyoh 'ink'ez hudilhts'i 'et. Whunizyai 'on 'at nanki (12) budayiyaz, 'enne nts'e hahande hukwa sih boozi'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmael ndi yun k'ut inda-un, 137 be yus k'ut 'et dazai. 'En cha whutsoda' yulh 'unt'ohne buts'un whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Yun k'ut Havilah 'ink'ez Shur 'et 'uwhuldzoh, Egypt whanda', Assyria ts'u wheti, 'oh huwhut'i 'ink'ez Ishmael dunatneke butoh 'et dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ndi 'i Abraham ooye' Isaac oots'u hayandene. Abraham 'en Isaac oobá. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac 'en dit whunizyai (40) naoodizut whe oo'at Rebekah 'en yughusda. Bethuel ootse' 'en Syria whut'en, Padan Aram keyoh, 'et Laban, 'en Syria whut'en 'en bulhtus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","'Et Isaac 'en Moodihti (Yahweh) yuts'u tedudlih du'at ba, 'aw buzkeh hole' ait'oh. 'Et Moodihti (Yahweh) 'et yugha oonin'ai 'ink'ez Rebekah ulchan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","'Et nyo oochan ts'e nane nukahulhoh, “Soo 'ust'oh 'et hoonts'i 'et di ha njan dust'oh?” ni, 'ink'ez Moodihti (Yahweh) yoodalhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","'Et Moodihti (Yahweh) 'en Rebekah 'uyulhni, “Nawh didohne 'enne nchan 'uhint'oh. Nawh didohne 'enne hubutalhtsi, 'ilhoh didoh-un 'en onghun-un hanus 'ulhtus, 'ink'ez 'udetso whutileh-un 'en duk'oh-un yuba ne'tit'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","'Et 'awet ooba newhults'ut ooyaz whutaleh ha, 'et nane lht'udinke oochan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","'Udetso whuzdli-un 'en dulk'un 'ink'ez ants'i naih 'ugha unli 'i yesda le'unt'oh ndulcho whe ooyust'e, 'en Esau huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","'Et hukw'elh'az bulhutsin en whuzdli, 'ink'ez Esau ookentsul 'i yilhchoot. 'En Jacob huyulhni. Isaac lhk'utat whunizyat be yus k'ut (60) 'et nyoon ts'oodunne huwhuzdli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","'Et nyoonne duneyaz huniyilh, Esau 'en tube 'uka 'ut'en-un 'ink'ez chuntoh whudune' whe 'uyoo unli. 'Et hoonts'i Jacob 'en t'edusnih-un dune unli, nimbali t'ah za whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","'Ink'ez Isaac 'en Esau yuk'entsi', ndai yughan-i yu'alh, 'ink'ez Rebekah 'en Jacob yuk'entsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","'Aw 'et Jacob tazul inla 'ink'ez Esau 'en chuntoh ts'un hanaja 'ink'ez tube nenintsai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","'Et Esau 'en Jacob 'uyulhni, “Sla'inle whe nyutazul dulk'un, 'i za sunail'alh, tube nenisai 'et huwa.” 'Et huwa boozi' 'i Edom ts'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","'Et hoonts'i Jacob utni, “Ndai la mba ootadzilh-i k'at le, 'i 'andit be sts'e 'oonket.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","'Ink'ez Esau 'utni, “Whunilh'en 'awet datisah! Be daoost'e' suba ndi sba huyoozi-i?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","'Et Jacob 'utni, “'Andit dzin sts'un nahinyeh.” 'Et huwa yuts'u nahizya 'ink'ez ndai la k'at le oogha itakulh-i, 'i Jacob 'en ye ts'un 'onket. ");
INSERT INTO crxNTpo_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","'Ink'ez Jacob, Esau ut'alh-i 'ink'ez nyoo yuzdliz-i hanuyeh, 'i yugha ininla 'ink'ez 'i yan'al, 'ink'ez dunadija 'ink'ez 'az whenaja. 'Et Esau ndai la k'at le oogha itakulh-i ts'iyawh 'aw yukalhe'nizun, 'un yutilhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","'Et nyo keyoh dai dinzut, whutso da' Abraham khuna whe 'et cha dai dinzut inle' 'ink'ez Isaac, Abimelech huyulhni, Philistine whut'enne buba lerwe, Gerar whut'i, 'en buts'un whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","'Et Moodihti (Yahweh) yunalhts'et hainya 'ink'ez 'uyulhni, “'Aw Egypt ts'u tonya' junih. Ndet la yun nyudutasnelh-un 'et sih hont'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ndi yun 'i k'ut hont'e 'ink'ez nyulh 'utistelh, 'ink'ez mba soo hoonzoo-i ubooselh. Nyun cha 'ink'ez nts'u haindene cha ndi yun bugha inus'ai, ndet la mbá Abraham oots'u nahizusya-i, 'i lhadutisleh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","'Ink'ez nts'u haindene, 'enne yak'uz whusum k'un'a lhk'uz te huldlai hubutilhtselh. 'Ink'ez nts'u hainde 'en ts'iyawh njan yun k'ut bugha óotas'alh. 'Ink'ez nts'u haindene, 'enne bugha ndi yun k'ut dune ts'iyawh huba soo hoonzoo-i 'i butilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Abraham 'en sghuni oontun 'ink'ez sk'oh ts'e ant'e, sghuni 'i yuk'une'ust'en, dadusni, 'et cha hont'un, 'ink'ez nts'en'a ba newhunin'ai, 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","'Et Isaac nyo keyoh Gerar howhutni-un 'et hoot'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","'Et nyoonne dune 'et whudune'ne hi'at ka huyoodulhkut 'ink'ez 'ubulhni, “Sulhtus 'unt'oh.” “S'at 'unt'oh” hubulhni de, doo ka la sozoolhghelh ninzun 'awhuz ndun Rebekah ts'eke zoo' 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","'Et 'uhooja sa' nyo 'et keyoh hoot'e' whe Abimelech, Philistinene bulerwe, dadint'az k'et 'az whunilh'en whe Isaac, Rebekah yughu dzedzi' whe yunulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","'Et Abimelech Isaac, “'Anih!” yudani', “'Alha 'uhoont'oh whe ndun ts'eke n'at 'unt'oh 'ink'ez nts'en'a 'udini ‘Sulhtus 'unt'oh,’ dini?” 'Ink'ez Isaac 'uyulhni, “Doo ka sih ook'uz daoosah 'inka 'udusni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","'Ink'ez Abimelech 'utni, “'Et dane'inla whe ne'inla? Nyoonne dune 'ilhoghun te da', nyoon n'at yuchan t'eoote' oole'! Njan lhe'hoont'oh-un 'et da' nek'eholts'it oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","'Et Abimelech mbene la dudune'ne 'ubulhni, “Ndun dune k'us oo'at te oot'aizahnai de, datihtsah.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","'Et Isaac nyo yun k'ut 'a' nanla 'ink'ez yus k'ut ha'nanla. Lhai ha'nanla, 100 'et 'uwhultsuk, 'ink'ez Moodihti (Yahweh) soo hoonzoo-un yuba whulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","'Et ndun dune 'awet hoonzoo wheninle' 'ink'ez lhk'uz te whe tube hoonzoo suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","'Usbai 'i yulh lhai suli', musdoos 'i cha lhai whe yut'i suli', 'ink'ez hinatne'ut'en 'enne cha huldlai. 'Et whe Philistine whut'enne highe 'oolnih huzli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","'Et nyoonne Philistinene nyo too dizdla-un 'uhuhoonla-un, ts'iyawh lhez buch'a 'ananuhulhkat, Abraham yuba 'ut'enne, 'enne hahuhonkai, Abraham khuna whe, 'ink'ez nyoonne sai dizbun whe 'ananulhkat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","'Ink'ez Abimelech, Isaac 'uyulhni, “Nech'a naindalh! Neanus 'ilhtus whe 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","'Et Isaac nyo huwu natisja 'ink'ez dzulh eguz, Gerar, 'et nimbali nenin'ai 'ink'ez 'et whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","'Ink'ez Isaac doo cha nyo too k'et na'hoonla, mbe la oobá 'ulhuhoonla-un inle'-un. 'Oh da' ts'iyawh nyoonne Philistinene ts'iyawh lhez 'anunahulhkat inle'. 'Ink'ez ndai la nyo too dizdla-un oobá ye honzi'-un, whuz un'a hoozi' nawhulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","'Ink'ez Isaac yuba 'ut'enne nyo dzulh eguz ha huhonkai, 'et doo cha too unzoo hoonli-un 'et nahuhoon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","'Et hoonts'i nyoonne Gerar whut'enne khuna ghunline, Isaac khuna' ghunline tube hube hududulh. Nyoonne Gerar whut'enne hutni, “Ndi too nech'e' 'unt'oh!” hutni, 'et nyo too k'et, 'et Esek yoozi', hiye dindil 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","'Et doo cha 'udun too diz'ai-un 'uhuhoonla. 'Et nyo 'et cha hukwa lhehudindil, 'et cha hoozi' whulhtsi, Sitnah whulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","'Et nyo tizna 'ink'ez doo cha 'udun too k'et 'uhuhoonla. 'Et 'aw hukwa lhelhdulhyoh lhe'huditnelh 'et huwa, Rehoboth whulhni. 'Et 'utni, “'Andit njan Moodihti (Yahweh) hooncha neba whulhtsi, soo lhai cho la 'uts'ooleh ndi yun k'ut.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","'Ink'ez 'et whedinya ndo Beersheba ts'un whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","'Et 'ulhdzis za Moodihti (Yahweh) yunalhts'et hainya 'ink'ez 'utni, “Mbá Abraham ooYak'usda (Elohim) 'ust'oh. Whenilhjut iloh, nyulh 'ust'en 'ink'ez soo hoonzoo-un mba whutiselh 'ink'ez nts'u haindene cha lhane hutileh, ndun sba 'ut'en-un Abraham 'en gha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","'Et nyo loodel 'inla 'ink'ez Moodihti (Yahweh) yukahuyih 'ink'ez 'et nimbali nenin'ai. 'Et doo cha Isaac yuba 'ut'enne too k'et hahonkai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","'Et Abimelech yughu ninya keyoh Gerar ts'e hainya, ook'eke 'ilhoghun Ahuzzah huyulhi, 'ink'ez Phichol lhuganne bumoodih 'en tubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","'Ink'ez Isaac 'ubulhni, “'Et di ha sghu nuhdil, sts'u duhni 'ink'ez whenasuniyoot inle'?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","'Et hoonts'i uhuyulhni, “Soo ts'ih'un 'alha t'ets'onanzin Moodihti (Yahweh) nyulh 'unt'oh. 'Et' uts'utni, ‘Nats'uhooyeh nyun 'ink'ez wheni tubulh nats'uhooyeh,’ huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","'Aw hoonli hoontsi' hukw'un'a ne'onleh ait'oh, 'aw nt'alhts'inalh 'et huwa. Hoonzoo-un te za ne'unts'uyulh'en, dalhts'inelh whe za whenants'uyalh'a'. Moodihti (Yahweh) soo hoozoo-un ngha óonin'ai inli.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","'Et bughu nusuya 'ink'ez 'uhan'alh 'ink'ez tahitnai'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","'Et bunda' 'uda' duhudindil 'ink'ez lhts'unahuhisda whe Isaac 'un whenabalh'a 'ink'ez budzi dizghel whe whenahidil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","'Et nyoonne 'et dzin za Isaac yuba 'ut'enne, doo cha za too hoonli hahonkai 'ink'ez highu nindil 'ink'ez 'uhuyulhni, “Too k'et 'et 'uts'uhoonla!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","'Et nyo too k'et 'et Shibah whulhni, 'et huwa nyo keyoh whuti 'andit dzin whuts'un Beersheba huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","'Et Esau dit whinizyat (40) be yus k'ut whe ts'ekoo nane 'enne bughusda. 'Ilhoghun Judith, Beeri ootse', Hitt whut'en-un 'unt'oh, 'ink'ez Basemath, Elon, Hitt whut'en-un, 'en ootse' bulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","'Ink'ez nyoonne ts'ekoo, Isaac 'ink'ez Rebekah bulh budzi hundulhda. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","'Et 'uhooja Isaac duneti suli' 'ink'ez oona cha 'awet tetsun suli' whe, Esau, ooye' 'udetso-un 'en yuka' dani', “Sye',” yulhni. 'Et 'utni, “Njan 'ust'oh.” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","'Et 'utni, “Whunilh'en 'andit duneti susli', ndet dzin datisah-un 'aw t'eoonuzuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","'Andit whe sla'ineh, be 'uka 'int'en, k'aza zus, 'ink'ez k'aza bulh 'i tonla. 'Et tl'o k'uz ts'e tonya', 'ink'ez khuna-i sba ka' 'ont'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","'Ink'ez nyoo ndai la oonust'i'-i, 'i sba 'inleh, 'ink'ez sts'u tonka', 'et de sih oos'alh. 'Et de sih szul be soo hoonzoo-un nts'un tizoo' datisah whutso. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","'Et Rebekah yoozilhts'ai whe 'utni Esau bulh yalhduk, 'ink'ez Esau whenya 'uka' tit'elh ha 'ink'ez whusaitilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","'Et Rebekah 'en duye' Jacob 'uyulhni, “'Ilhiz soo oozolhts'ai' mbá 'en Esau 'uyulhni, njan ndi yulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Silhghe-i sts'inlelh 'ink'ez nzoo-i sba 'inleh, tis'ulh ha datisah whutso Moodihti (Yahweh) oonalh 'et sih soo hoonzoo-un nts'un tiszoo'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","'Et huwa sye' daja nyudusni la 'et soo zilhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","'Az inyalh 'ink'ez khuna-iyaz toh ts'e nanki dúbe uzkehyaz soo unzoo-i, 'i si mba 'oosleh, mbá oogha itankalh wheni, nts'en'a yoont'i', whuz un'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","'Ink'ez ndi mbá oogha ininkaih 'ink'ez yoo'alh sih 'ink'ez datitsah whutso 'et 'en gha soo hoonzoo-un ngha hootalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","'Et Jacob ooloo Rebekah 'en 'uyulhni, “Whunilh'en sulhutsin Esau tube dughai whe 'unt'oh 'ink'ez 'aw si ndulhust'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ndun sbá ndi sla tila yukunudoolnih 'ink'ez nanis'a 'ink'ez sich'oh, sk'e hooyeh tila 'ink'ez 'aw soo hoonzoo-un sgha holts'it ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","'Et hoonts'i ooloo 'uyulhni, “Whute ye nk'ehizya-i si sih sk'uz'ooneh! Sye', 'ants'i soo zilhts'ai 'ink'ez ndi khuna-iyaz sba ookainyalh!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","'Ink'ez ndi khuna-iyaz yilhchoot 'ink'ez duloo gha ininla 'ink'ez ooloo yuba yuzdliz, ndai la oobá ooba yinzoo-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","'Et Rebekah duyaz 'udetso-un Esau, 'en oonaih k'us unzoo-i yoh yuzdla-i, 'i Jacob 'udek'oh-un, 'en ye yalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","'Ink'ez nyoo dúbe buzkeh oozuz 'i yula yugha iyozduz, oots'ilchun cha yugha iyozduz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","'Ink'ez nyoo yuzdliz-i 'ink'ez ut'alh-i cha 'i duyaz Jacob yutl'ayanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","'Ink'ez dubá yuts'u yoozdla 'ink'ez 'uyulhni, “'Ubá.” “Njan 'ust'oh. Sye', mbe inli whe 'int'oh?” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","'Et Jacob dubá 'uyulhni, “Nye', 'udetso whuzdli-un, Esau 'ust'oh. Daja sudani' la whuz un'a 'usja. Dudinyaih 'ink'ez njan sinda 'ink'ez ndi sisghi-i in'alh, 'et de sih nzul be soo hoonzoo-un sgha hoolts'it.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","'Et hoonts'i Isaac duye' 'uyulhni, “Sye', 'et nts'en'a 'a cho naindla 'i silhghi?” 'Ink'ez 'uyulhni, “Moodihti nYak'usda (Yahweh Elohim) 'en sgha ininla 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","'Et Isaac, Jacob 'uyulhni, “Njan szih neninyaih 'ink'ez sih nk'unudooznih, sye' 'alha Esau tila 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","'Et Jacob dubá Isaac yuzih neninya 'ink'ez yuk'unudilhni 'ink'ez 'utni, “Nyiz yailhduk, 'et Jacob ooyiz 'utni, 'et hoonts'i ndi nla 'i Esau oola 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","'Ink'ez 'aw nalhuyóolts'ulh, nyoo oola dughai Esau oola k'un'a, 'inka soo hoonzoo-un be ubulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Ink'ez 'utni, “'Alha eh sye' Esau 'int'oh?” “A,” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","'Ink'ez 'utni, “Szih nenin'aih nyoo sye' yanghan-i, 'i sih oos'alh 'ink'ez ndi szul be soo hoonzoo-un ngha hóotalts'ulh sih.” Yuzih neninkai 'ink'ez yan'al 'ink'ez ts'ekoo too' cha yugha nilhdzo 'ink'ez 'i cha yitnai'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","'Et oobá Isaac 'uyulhni, “Sye' szih neninyaih 'ink'ez nasudints'oos.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","'Ink'ez yuzih neninya 'ink'ez naidits'ooz 'ink'ez nyoo naih yunahoolhtsun 'ink'ez soo hoonzoo-un ootl'aookat, 'ink'ez 'uyulhni, “'Alha soo ts'ih'un sye' 'aw hukw'un'a oonawhultsun, ndai la Moodihti (Yahweh) tl'o k'ut soo hoonzoo-un whulhtsih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","'Et huwa Yak'usda (Elohim) yak'uz nanaduldzoh-i, 'i ngha yolhdzeh 'ink'ez ndi yun k'ut ndai la nzoo-i ts'iyawh cha, hanuyeh cha 'ink'ez ts'ekoo too' cha lhai 'i ngha yolelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dune cha nyunat ne'hoot'en 'ink'ez didohne cha mba nacha hunooldulh. Nyulhutsinke cha bumoodih onle', 'ink'ez nloo buzkeh, 'enne cha mbut nachahunooldulh. Mbene la nk'ehuyihne 'enne cha buk'ehoodeh, mbene la soo hoonzoo-un nts'un hutizoo', 'enne cha soo hoonzoo-un bugha hóotalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","'Et 'uhooja Isaac, Jacob yuba soo hoonzoo-un za ootl'aookat 'etsul 'udija, 'ink'ez Jacob 'awhuz n'az nalhtusdai, 'et Esau bulhutsin daninya ndai la yuka 'it'en-i bulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","'En cha ndi t'alh-i nzoo-i 'uyinla 'ink'ez dubá yughu daininkai 'ink'ez dubá 'uyulhni, “Sbá dudoya' 'ink'ez ndi ooye' yuzilhghi-i yoo'alh, 'et la nzul be soo hoonzoo-un sgha hóotalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","'Ink'ez oobá Isaac 'uyulhni, “Mbe inli whe 'int'oh?” 'Et 'uyulhni, “Nye' 'ust'oh. Nye' 'udetso-un Esau.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","'Et Isaac soo tube cho 'et ditlut 'ink'ez 'utni, “Mbe 'uja khuna-i yuzilhghi-i 'ink'ez sghu daininkai? Ts'iyawh us'al dantanyalh whutso 'ink'ez 'en soo hoonzoo-un oots'un uszoo'. 'Ink'ez 'alha 'en soo cho oobulh 'uwhutat'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","'Et Esau dubá ooghuni yudants'o whe soo 'ultus-un intse 'ink'ez dubá 'uyulhni, “Sbá si cha O sbá soo hoonzoo-un sghá holts'it!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","'Et hoonts'i 'uyulhni, “Nyulhutsin whunut'i' 'i be sghu daninya 'ink'ez ndi mba soo hoonzoo-un ngha hóotalts'ulh, 'i yilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","'Ink'ez Esau 'utni, “'Alha 'i be Jacob 'uyulhni, 'awet nat 'usinla, 'udechoo ndi sts'u oozinzi-i cha sghu yilhchoot 'ink'ez whunilh'en 'andit be soo hoonzoo-un sgha hóotalts'ulh, 'i cha yilhchoot!” 'Ink'ez 'utni, “'Aw eh 'uyoo soo hoonzoo-un sgha hóotalts'ulh sba lhint'ih?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","'Et Isaac 'en Esau 'uyulhni, “A, nyumoodih susi. Bulhutsinke 'enne cha hibut ne'tit'en whuzusi. Hanuyeh cha 'ink'ez ts'ekoo too' cha ts'iyawh 'i oogha inusla. Sye', ndet mba dawhutislelh'?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","'Ink'ez Esau dubá 'uyulhni, “Sbá, 'ilho soo hoonzoo-un za int'i eh? Sbá si cha O sbá soo hoonzoo-un sgha hóotalts'ulh!” 'Ink'ez Esau tube cho whenintse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","'Et Isaac oobá 'uyulhni, “Whunilh'en hoont'i-un ndi yun k'ut nzoo-i whutaleh, 'ink'ez ndo yak'uz naduldzoh-i 'i cha tant'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nla luzti 'i be hutanalh 'ink'ez nyulhutsin ooba 'utant'elh. 'Ink'ez 'uwhutanelh mba whe' hoont'oh hooloh suli' de, ndai la nts'ilchun ye yoontun-i k'utanyus.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","'Et huwa Esau, Jacob yuts'u dutni ndai la yube soo hoonzoo-un oogha whútilts'ulh, yilhchoot, 'ink'ez Esau dudziyo ts'e 'utni, “Sbá ook'eni whuntidleh-un 'awet nilhdukw, 'et de Jacob sulhutsin tuzisghelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","'Ink'ez Esau ooghuni 'udetso ooyaz-un Rebekah hidani'. 'Et Rebekah Jacob 'anih yudani' 'ink'ez 'uyulhni, “'Alha nyulhutsin Esau nyutuzilhghelh 'et whe hazih k'ena'dunit'ah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","'Et huwa syaz sghuni ook'oh ts'e 'ineh. Dudinyaih 'ink'ez sulhutsin Laban, Haran whut'i-un, 'en oots'ilgih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","'Ink'ez oozih sinda, 'atsulyaz nyulhutsin ye hunilch'e-i gak naoodleh sih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Nyulhutsin ye hunilch'e-i nch'az na'ootneh, dainla la whunaoodilhnoh de, 'et sih nka nawhutoos'a 'ink'ez whusanaoonja'. 'Et di ha nyun cha nk'eni untisleh 'ilhudzin za?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebekah 'en Isaac 'uyulhni, “'Awet tube be khúsna-un be nenisai, be khúsna-un be nenisai ndunne Heth butse'ke k'uz. Ndunne ndi yun k'ut whut'enne whutse' le'hint'oh. 'Et Jacob, 'en Heth butse' ghusda te, 'et dant'i whe be khúsna-un sba oole' ha?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","'Et Isaac, Jacob 'anih yudani' 'ink'ez soo hoonzoo-un yuba whulhtsi, 'ink'ez 'uyulhni, “'Aw Canaan whuts'eke' 'ilhoghun, 'en n'at wheni olhchoot junih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Dudinyaih 'ink'ez Paddan Aram, Bethuel ooyoh ts'e inyalh, nloo oobá, 'ink'ez 'et ts'eke n'at wheni ilhchoot, Laban buzkeh 'ilhoghun nloo bulhutsin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Yak'usda 'Uk'enus 'Ultus-un 'Ust'oh (El Shaddai) soo cho-un cha mba hoonzoo-un ngha hóotalts'ulh 'ink'ez lhane hooleh dune huldlaine oohleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Abraham ye soo hoonzooo-un whusaínkat, 'i cha nts'un tookat, nyun cha 'ink'ez nts'u hahande nyulh 'uhint'oh 'enne cha. 'Et sih njan yun k'ut nohch'e' oole', 'et 'uts'un hoont'en inli. Njan 'et Yak'usda (Elohim) 'en Abraham yugha óoni'ai inle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","'Et Isaac, Jacob wheyalh'a 'ink'ez yun k'ut Paddan Aram ts'e whenya, Laban, Bethuel ooye', Syria whut'en, 'en Rebekah bulhutsin Jacob 'ink'ez Esau buloo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","'Et Esau, Isaac, Jacob 'en soo hoonzoo-un ubulhni 'ink'ez wheyalh'a' yun k'ut Paddan Aram, oo'at yutaleh-un yolhchoot ha, 'ink'ez yuba soo hoonzoo-un whulhtsih whe 'et njan 'uyulhni, “Nyun Canaan whut'enne ts'ekoo butoh, 'enne n'at wheni olhchoot junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","'Ink'ez Jacob dubá yuk'oh ts'e 'uja, duloo cha yuk'oh ts'e 'uja, 'ink'ez yun k'ut Paddan Aram ts'e whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","'Ink'ez cha Esau, Canaan whut'enne whuts'ekoo dubá 'aw hukwa' alhe'nizun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","'Et Esau, Ishmael, Abraham ooye', 'en ts'u whenya, 'ink'ez Ishmael, 'en ootse' Mahalath, 'en du'at wheni yilhchoot. Ishmael ootse' Nabaioth, 'en bulhtus 'unt'oh, Mahalath, 'en cha oo'at yole', 'uyoonne oo'atke tubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","'Andit 'et Jacob 'en Beersheba whuz de hanaja 'ink'ez keyoh Haran ts'un whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","'Et 'utsun whenya 'ink'ez 'ulhdzis nduwhulhyiz whe 'et inda', sa yo whin'ai 'et huwa, 'ink'ez nyoo tse, 'et diz'ai-i 'ilho 'i yuk'ut tse nilh'ai nantitelh wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","'Et nusuti 'ink'ez whunilh'en, kw'ut dughaiti-i ndi yun k'ut whedin'a, ndo yak'uz ts'e whein'a, 'et Yak'usda (Elohim) oolizasne ndo cha whehudulh 'ink'ez nyo cha whenahudulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","'Ink'ez whunilh'en ndo Moodihti (Yahweh) 'en usyin 'ink'ez 'utni, “Si Moodihti (Yahweh) Abraham ooYak'usda (Elohim) mbá cha 'ink'ez Isaac ooYak'usda (Elohim) cha 'ust'oh. Ndi yun ookw'ut sinti-i 'andit ngha tis'alh nts'u haindene cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","'Ink'ez cha mbene la nts'u haindene ndi yun k'ut lhez lhe'unt'oh. Lhai whuz un'a hutildlai', noo' cha 'ink'ez nda' cha, whuz netihnelh, no cha, nyan 'ink'ez ntsu hainde-un cha, 'en gha ndi yun k'ut dilhts'ine, 'enne ts'iyawh soo hoonzoo-un bugha hóotalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Whunilh'en nyulh 'ust'oh, ntsoh te ninya te, nyulh 'utistelh 'ink'ez ndi yun k'ut nenyutastelh. 'Et 'awet nghu natisdulh datisnelh la nyudusni-un, 'et 'awhusla whuts'un.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","'Et Jacob ts'enandzut 'ink'ez 'utni, “'Alha la Moodihti (Yahweh) njan 'et usda 'ink'ez 'aw azi t'eoonuzuszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","'Ink'ez nuljut 'ink'ez 'utni, “Tube usla njan huwa 'it'en! 'Alha 'et Yak'usda (Elohim) ooyoh 'ink'ez njan 'et azi yak'uz ti ts'e whudatih!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","'Ink'ez Jacob 'uda' dudinya 'ink'ez nyoo tse yuk'utsenalh'a'-i, 'i nyo whedin'a yulhtsi, 'ink'ez khe yuk'eilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","'Ink'ez nyo 'et boozi' huwadin'ai, Bethel whulhni, 'et keyoh whutso da' 'et Luz huwhutni inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","'Et Jacob nahizya whe ndutni, “Yak'usda (Elohim) sulh 'unt'oh de, 'ink'ez ndiz un'a 'usilhdzun, 'ink'ez tisyalh ts'e ut'alh-i cha sgha ti'alh, 'ink'ez naih be dune tisleh-i cha, ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","'Et de sbá ooyoh ts'e soo ts'ih'un sdzi dizghel whe whuz natoosja', 'et de Moodihti (Yahweh) 'en sih Yak'usda (Elohim) sba oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","'Et ndi tse njan nadan'a k'un'a silhtsi, 'i Yak'usda (Elohim) ooyoh hole', 'ink'ez ndai sgha ninla, 'i whunizyai 'on 'un (10%) nts'un na'óotneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","'Et Jacob tizya ts'e whenya, nda' keyoh whut'enne bukeyoh ts'e oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","'Ink'ez whunalh'en 'ink'ez tl'o k'ut whuniz 'et too diz'ai 'ink'ez whunulh'en tawh didoh-i 'usbai, 'i nus ustez nyo too diz'ai-un 'et whutoo'-i higha huyulhdzoh, nyo too diz'ai-un too k'et whudah 'et ats'o tse diz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","'Ink'ez nyoo 'usbai ts'iyawh nyo 'et 'ilho ulh'us 'ink'ez nyoo tse 'i ts'o sanahidunulhgih, 'ink'ez 'usbai too highalhdzoh, 'ink'ez nyoo tse 'et nenahidu'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","'Ink'ez Jacob 'ubulhni, “Sulhutsinke nts'ez de hahdil whe 'uht'oh?” 'Ink'ez 'uhutni, “Haran ts'e hats'andil.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","'Ink'ez 'ubulhni, “Nahor ooye', Laban, t'enuhzun eh?” 'Ink'ez 'uhutni, “T'ezninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","'Et 'ubulhni, “Soo 'unt'oh eh?” 'Ink'ez 'uhutni, “Soo 'unt'oh 'ink'ez whunilh'en ootse' Rachel 'usbai bugha tatilhdzoh ha whuz de uyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","'Ink'ez 'utni, “Whunulh'en 'awhuz dzetniz whenghoh, 'awhuz khuna-i 'ilhunahuyoontayulh 'ink'ez 'usbai cha higha tatilhdzoh 'ink'ez bugha' huti'alh-un cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","'Et hoontsi' 'uhutni, “'Aw 'et duts'ooneh ait'oh. 'Usbai tsi'yawh 'ilhunaoolh'az whutso 'ink'ez tse cha too k'et whusanahidunti lhgih, 'et de 'usbai oogha tats'ulhdzoh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","'Awhuz yalhduk whe Rachel dubá be 'usbai bulh whusainanyoot, 'usbai ghunli-un ts'eke 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","'Ink'ez 'uhooja Jacob, Rachel, Laban ootse', ooloo bulhutsin, yutilh'en whe 'ink'ez Laban be 'usbai, ooloo bulhutsin, Jacob 'et nyoo tse whusanaidunalhgai 'ink'ez ooloo bulhutsin Laban be 'usbai 'i yugha tanilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","'Ink'ez Jacob, Rachel naidits'ooz 'ink'ez tube cho whenintse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","'Ink'ez Jacob, Rachel yulhni, oobá oonadun 'ust'oh, 'ink'ez Rebekah ooyaz 'ust'oh, yulhni. 'Et Rebekah whelgai 'ink'ez dubá yudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","'Et 'uhooja Laban ndi khuni yudants'o Jacob, bulhtus ooyaz, whuz oolhgai 'ink'ez shih be' yilchoot, 'ink'ez naidits'ooz. 'Ink'ez duyoh dainilhti. 'Et Jacob Laban ndi ts'iyawh yudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","'Ink'ez Laban 'uyulhni, “'Alha syust'e 'ink'ez sts'un cha inli.” 'Ink'ez 'ilhoh sanun yuzih inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","'Et Laban, Jacob 'uyulhni, “Snadun inli, 'et huwa 'aw eh 'ants'i 'et sba' tant'elh? Sudini, daltsuk k'elha la 'int'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban nane ootse'ke hoonli, 'udetso-un 'en Leah huyulhni, 'ink'ez 'udek'o-un 'en Rachel huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leah oona soo lhe'íltus, 'et hoonts'i Rachel tubeh soo 'ot'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","'Et Jacob, Rachel yuk'entsi' 'ink'ez 'uyulhni, “Lhtak'antit whunizyat (7) yus k'ut 'et mba 'oost'en, Rachel 'udek'oh-un 'en k'elha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","'Ink'ez Laban 'uyutni, “'Uyoon dune gha tistelh whutso, 'et 'onus soo' hoont'oh nyun ngha tistelh. Szih sinda.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","'Et Jacob lhtak'antit yus k'ut 'et Rachel yuk'elha 'it'en. 'Ants'i 'atsulyaz ooba le'hoont'oh, tube yuk'entsi' ket. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","'Et Jacob, Laban 'uyulhni, “S'at sgha nilhtih, 'awet dzin lhaoodusla 'ink'ez la oost'e'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","'Ink'ez Laban dune ts'iyawh oodune'ne 'ilhubozdla 'ink'ez dune ghu nusuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","'Et 'uhooja 'et hulhgha dutse' Leah yilhchoot 'ink'ez Jacob ghi nilhti, 'en cha oo'at yuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","'Ink'ez Laban yuba 'ut'en-un, Zilpah huyulhni, 'en dutse' Leah yuba 'oot'en ha yugha inilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","'Et 'uhooja bundada' Leah ats'o 'unt'oh, 'ink'ez Laban 'uyulhni, “Dainja whe 'inja, whe' sinla? Rachel iloh lakw mba 'ist'en 'ink'ez di ha nasunan'a?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","'Ink'ez Laban 'utni, “Njan nekeyoh, 'aw 'udek'oh-un, 'en, 'udetso-un ootso dune gha buts'olhtelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","'Andit lisman lhaoodinleh, 'ink'ez ndun 'en cha 'ant'en hukw'elha ngha ts'oolhtelh. 'Ink'ez doo cha 'on 'un lhtak'ant'it yus k'ut, 'et sih sba 'ont'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","'Ink'ez Jacob 'et lisman lhaoodinla, 'ink'ez dutse' Rachel 'en cha oo'at yutaleh ha yugha inilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","'Ink'ez Laban, yuba 'ut'en-un ts'eke, Bilhah, 'en dutse' Rachel yuba 'oot'en ha yugha inilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","'Et Jacob, Rachel 'en cha oo'at yuzdli', 'ink'ez 'en Leah anus yuk'entsi'. 'Ink'ez Laban doo cha lhtak'ant'it (7) yus k'ut 'et yuba 'it'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","'Et Moodihti (Yahweh), Leah 'aw dune yuk'elhitsi' 'inka oochan yudaha'dan'ai, 'ink'ez Rachel 'en 'aw buzkeh hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","'Et Leah ulchan 'ink'ez dune ooyaz suli'. Ruban 'i be yoozi 'ink'ez 'utni, “Moodihti (Yahweh) 'alha njan whe undusda-un whunalh'en, 'et huwa ski sk'eootsi' la.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","'Et doo cha za ulchan 'ink'ez dune ooyaz suli'. 'Ink'ez 'utni, “Dune sk'elhitsi', Moodihti (Yahweh) whudants'o, 'et huwa dune 'en syaz sgha inilhti.” 'Ink'ez 'en Simeon yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","'Et doo cha za ulchan 'ink'ez dune ooyaz suli'. 'Ink'ez 'utni, “'Andit 'et la ski sk'eootsi' oole', 'awet tane ooye' susi 'et huwa.” 'Et huwa duneyaz boozi, Levi, yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","'Ink'ez doo cha za ulchan 'ink'ez dune ooyaz suli'. 'Ink'ez 'utni, “'Andit 'et Moodihti (Yahweh) dutásti'!” 'Et huwa yoozi', Judah, yulhni. 'Et hukw'elh'az 'et 'awet buzkeh hoonli-un 'etsul 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","'Et 'awet Rachel 'aw Jacob ts'oodunne yughalhilel t'eoonanzin, dulhtus 'en hukwa yughe 'oolnih 'ink'ez Jacob 'uyulhni, “Ts'oodunne sgha ninle k'us datisah!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","'Et Jacob, Rachel yulh hunilch'e 'ink'ez 'utni, “Si eh Yak'usda ook'edusda? Si 'unyusla 'aw nyuzkeh hole' ait'oh nyuzusi?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","'Et Rachel 'utni, “Ndun sba 'ut'en-un, Bilhah, 'en oozih sinti 'ink'ez la 'olhtsi, 'ink'ez sgwut k'ut da' ts'oodun 'ink'ez 'enne suzkeh hole', nghu bulhtsine.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","'Ink'ez Bilhah, Jacob gha inilti oo'at yole' ha 'ink'ez Jacob yuchant'inte'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","'Ink'ez Bilhah ulchan 'ink'ez Jacob duneyaz yughu yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","'Et Rachel 'utni, “Yak'usda (Elohim) sba nahizya 'ink'ez syiz cha yudants'o 'ink'ez duneyaz, syaz oole' ha sgha inilhti.” 'Et huwa Dan yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","'Ink'ez Rachel yuba 'ut'en-un, Bilhah, 'en doo cha 'ulchan, 'ink'ez Jacob bulh whulh nat-un ooye' ut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","'Et Rachel 'utni, “Sulhtus Leah bulh lhch'a 'oldeh hukwa 'it'en, soo 'iltus whe 'ink'ez si whucha' nusde.” 'Ink'ez nyoon ts'oodun Naphtali yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","'Et Leah 'awet buzkeh hoonli-un 'etsul 'uja, 'et yuba 'ut'en-un, Zilpah, 'en Jacob oo'at yole' ha yugha inilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","'Ink'ez Leah yuba 'ut'en-un, Zilpah, Jacob duneyaz yughu sulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","'Et Leah 'utni, “Dune lhuganene 'az de hidulh!” 'Inka nyoon ts'oodun Gad yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","'Ink'ez Leah yuba 'ut'en-un, Zilpah, whulhnat Jacob yughe 'ulhtsi, duneyaz ooyaz suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","'Et Leah 'utni, “Hoonúst'i', ts'ekoo 'enne soo hoonzoo-un sgha whults'ut-un sodoni' lah.” 'Ink'ez nyoon duneyaz Asher yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","'Et Reuban ha'nuyeh-un whuz 'ut'en whe 'et nyoo 'ilho hanuyeh-i duchunyoo cha ootoh hoonli-i (nedoh k'oh ts'e mandrakes huyulhni) 'i ngha ininla 'ink'ez duloo Leah yughi ninla. 'Et Rachel, Leah 'uyulhni, “Nyoo nyaz ngha ininla-i, ooloh sgha ninle.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","'Et hoonts'i 'uyulhni, “Tube hoontsool-un 'inja ski ilhchoot ninzun eh? Doo cha syaz ndi mandrake sgha ininla-i, 'i cha sghi talhchulh hukwa' ninzun? 'Ink'ez Rachel 'uyutni, “'Andit 'ulhdzis ndi 'i k'elha, 'andit 'ulhdzis nzih tidalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","'Et Jacob hulhgha nus 'ut'en-un ts'e hanaja, Leah yududizya 'ink'ez 'uyutni, “'Andit 'ulhdzis szih onte', ndi syaz naininla-i mandrake, 'i k'elha.” 'Et 'ulhdzis yuchant'inte'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","'Ink'ez Yak'usda (Elohim) Leah yudants'o 'ink'ez ulchan, 'ink'ez Jacob whulh kwulane dune ooyaz suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leah 'utni, “Yak'usda (Elohim) 'en sba k'elhla whulhtsi. Sba 'ut'en-un, 'en ski butl'ayalhti 'et huwa.” 'Et 'en boozi' 'i Issachar yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","'Ink'ez Leah doo cha ulchan 'ink'ez Jacob bulh lhk'utan-un ooye' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","'Et Leah 'et 'utni, “Tube Yak'usda (Elohim) hoonzoo-un sgha oonin'ai. 'Awet 'andit ski szih la ooda', lhk'utane dune ooghu susi.” 'Ink'ez nyoon ts'oodun Zebulun yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Et hukw'elh'az ts'eke ooyaz suli', 'en Dinah yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","'Awet Yak'usda (Elohim) 'en Rachel yunalnih 'et neoodelhdzut 'ink'ez Yak'usda (Elohim) 'en yoozalhts'ai whe oochan 'ants'i yudaha'dan'ai le'yinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","'Ink'ez ulchan whe dune ooyaz suli'. 'Et 'utni, “Yak'usda (Elohim) 'en sba yooya 'i n'un na'yinla.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","'Ink'ez 'en Joseph yulhni, 'ink'ez 'utni, “Moodihti (Yahweh) doo cha sih 'uye' sugha oolhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","'Et 'uhooja Rachel, Joseph sulhtsi hukw'elh'az Jacob, Laban 'uyulhni, “Nasalh'alh, sich'oh whust'i-un skeyoh ts'e whuz si natoosja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","S'atke cha 'ink'ez suzkeke cha buk'elha 'ist'en, 'ink'ez slanaditnih, daja la mba 'ist'en 'et t'eooninzin.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","'Ink'ez Laban 'en 'uyulhni, “'Et sinda, mba uszoo de! T'eooniszin 'awet nyun ngha Moodihti (Yahweh) soo hoonzoo-un sgha oonin'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","'Ink'ez 'uyulhni, “Daltsuk k'elha 'utant'elh-un sudini 'ink'ez la ngha oos'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","'Ink'ez Jacob 'uyulhni, “T'eooninzun nts'en'a la mba 'ist'en 'ink'ez nghuna' 'i cha ghosle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nghu tisyalh whutso tube ntsool-i int'i inle', 'andit ts'iyawh 'onus lhai suli'. Moodihti (Yahweh) soo hoonzoo' mba whulhtsi, si nghu nusya whuts'un 'ink'ez nkede sich'oh syoh dilhts'ine buba' tistelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","'Et 'uyulhni, “Di ngha tis'alh?” 'Ink'ez Jacob 'utni, “'Aw hoonli sgha lhtuzan'a. Njan 'et dusinleh, 'et de doo cha sih nghuna' cha ghosle' 'ink'ez oogha 'oos'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","'Andit dzin nyoo int'i-i, ts'iyawh ootununoosta'. Ndai la ookw'e'nizdla-i ts'iyawh 'usbai 'i cha 'udun neooslelh, 'ink'ez dulba-i cha 'usbaiyaz toh 'i cha ts'iyawh, 'ink'ez dúbe ootoh 'i cha ookw'e'nizdla-i, 'i ts'iyawh 'udun neooslelh 'i k'elha 'ist'en whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","'Et de nts'en'a la whe tsih'un 'ust'oh-un, 'et la t'eoonoodzeh. Ndai la ook'elha mba 'ist'en-i, doo cha ooghu yatalduk de, ndai la dúbe ookw'ulhe'niloh-i 'ink'ez 'usbai dulba-i cha 'i ts'iyawh nghu hidunist'i oole' sih, sba whuz un'a 'uhoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","'Et Laban 'utni, “'Et whuz un'a ncha nghuni k'un'a 'uhooja.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","'Et dzin Laban 'en dune dúbe ookw'e'nizdla-i 'ink'ez ts'eke dúbe ookw'e'nizdla-i cha, lhyul-i ook'ut ut'en-i 'ink'ez ndai la dulba-i usbaiyaz toh, 'i ts'iyawh duye'ke bugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","'Et Laban tat dzin 'uwhuldzoh Jacob yuch'a suya 'ink'ez Jacob nyoo Laban ooghuna' ts'iyawh bube ulh'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","'Ink'ez Jacob t'ughus duli-i 'ink'ez nyoo duchun almond 'ink'ez chesnut huyulhni, 'i yudilhchoot oot'ooz yuk'eitilhchul 'ink'ez nyo dulyul suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Nyoo duchun yuk'e'tilhchul-i, 'i nyo 'usbai dilhts'i-un yananuyuz sih, ndet la tatnai-un, 'et de sih nyo yuzih nyoo duchun tatnai de oolchan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","'Et nyo yuzih nyoo duchun tatnai te, 'et ulchan ts'iyawh, 'et nyo ts'iyawh 'usbai ook'e'nizdla 'ink'ez lhyul-i bulh 'uts'un 'ot'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","'Et Jacob nyoo 'usbaiyaz ts'iyawh 'udun nebuninla, 'ink'ez nyoo 'usbai 'on yoghi Laban ooghuna' ts'iyawh lhelhts'un 'ot'en ookw'e'nizdla te 'unt'oh, whuntilh'eh wheni. 'Ink'ez didutch'oh ooghuna' 'i 'udun nebuninla 'aw Laban ooghuna' yutalhuyilel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","'Et 'uhooja ndet la nyoo k'us ulhtus-i khuna-i ulchan te, nyoo duchun 'uyinla-i, 'i nyoo khuna-i yubut neidinla, 'et de nyo duchun ootoh 'et oolchan 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","'Et hoonts'i nyoo khuna-i tetsun de, kwa nyoo duchun yuzih nelhubilel. Ndai la tetsun-i, 'i Laban ooghuna' 'unt'oh, 'ink'ez ndai la lhtus-i, 'i Jacob ooghuna' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","'Et dune tube hoonzoo' 'unt'oh suli'. Ndai la khuna yut'i-i lhai suli'. Ts'ekoo 'ink'ez dune yuba 'ut'enne cha 'ink'ez nyoo khuna-i camel huyulhni, 'i cha 'ink'ez donkey huyulhni, 'ohwhi cha lhai suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","'Et Jacob, nyoonne Laban buzkeh yalhulhduk budants'o, njan nduhutni, “Jacob ndai la 'ubá ooch'e' ts'iyawh yilhchoot 'ink'ez ndai la 'ubá ooch'e' 'i be hoonzoo' 'unt'oh suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","'Ink'ez Jacob, Laban oonin yutilh'en 'aw whutso da' yuts'un unzoo-un k'un'a ilhoh yunilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","'Et Moodihti (Yahweh) Jacob 'uyulhni, “Mbá ooyun k'ut ts'e naindalh, nyunch'oh nyunatneke butoh ts'e 'ink'ez nyulh 'utist'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","'Et Jacob, Rachel 'ink'ez Leah bulh nus 'ut'en ts'e khuna-i cha 'et dilhts'i whuz buka' dani', ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","'Ink'ez 'ubulhni, “Mbá oonin nus'en whutsoda' hukw'un'a ilhoh sulhnilh'en, 'et hoonts'i sbá ooYak'usda (Elohim) 'en sulh 'ant'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","'Ink'ez t'eoonuhzun ndet 'ust'oh-un 'et nohbá oonat ne'zust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","'Et hoonts'i nohbá nasunan'a 'ink'ez kw'elha 'ust'en-i cha 'uts'un un'a na'hoonla, whunizyat at'en 'et hoonts'i Yak'usda (Elohim) 'aw mbá sundolhdah whuch'a sghunli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Nja dutni de, ‘Ndi ookw'e'nizdla-i ook'elha 'utant'elh,’ 'ink'ez khuna-i uzkehyaz ts'iyawh ookw'e'nizdla. 'Ink'ez nja dutni de, ‘Ndai la lhents'un-un 'ot'en-i ts'iyawh ook'elha 'utant'elh,’ 'ink'ez nyoo khuna-i uzkehyaz ts'iyawh lhents'un 'ot'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","'Et whe Yak'usda ndai la mbá ooghuna' ts'iyawh yilhchoot 'ink'ez sgha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","'Et 'uhooja ndet la ndi khuna-i ulchan whe ndo yutas'en 'et 'ink'ez nususti 'ink'ez whunulh'en dúbe dune nyoo 'usbai ye k'eilhuk ts'iyawh nyoo ook'e'nizdla 'ink'ez ooka dulgi be nodelhgus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","'Et Yak'usda (Elohim) oolizas sulh yatilhduk nuste whe 'ink'ez 'utni, ‘Jacob,’ 'et 'udusni, ‘Njan 'ust'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","'Ink'ez 'usulhni, ‘Do yutin'en 'ink'ez nyoo dúbe dune 'usbai yuk'eilhuk ts'iyawh lhelhts'un 'ot'en 'ink'ez ook'e'nizdla cha 'unt'oh. Nus'en Laban danyalh'en la ts'iyawh whunus'en 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Bethel whuYak'usda (El) 'en 'ust'oh. Ndet da' tse whedintsi'-i soo 'inla 'ink'ez sts'un nahuzinya 'awet dudinyaih 'ink'ez njan keyoh whuch'a nasindaih 'ink'ez nyunatneke bukeyoh ts'e naindalh.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","'Et Rachel 'ink'ez Leah bulh hiyulh yatilhduk 'ink'ez 'uhuyulhni, “'Awhuz tole 'ubá ooch'e' 'ink'ez neba yootazilh-i cha neba hoonli? ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Wheni cha 'uts'un keyoh neninzun 'ink'ez neye'onket 'ink'ez nezooniya gak yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ndai be hoonzoo' hoont'oh-i Yak'usda (Elohim) 'ubá yughu yilhchoot, 'i ts'iyawh nech'e' 'unt'oh neuzkehne ba cha, 'et 'andit Yak'usda (Elohim) daja nyulhni la 'et whuz un'a 'et ndoneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","'Et Jacob dudinya 'ink'ez duye'ke 'ink'ez du'atke cha 'enne ts'iyawh nyoo camel k'ebinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","'Ink'ez ndai la khuna-i yut'i-i 'ink'ez oogha ininkat-i cha, njan keyoh Paddan Aram ndi khuna-i oogha ininkat-i, oobá Isaac, Canaan keyoh ts'e, whuz whe naja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","'Et Laban nus 'usbai hatit'us whe 'et Rachel ndai la nyo yoh ba 'uk'eltsi hits'u tenadudli-i, oobá ooch'e', 'i ts'iyawh yundunist'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","'Ink'ez Jacob whenanil'i', 'aw Laban t'eoonuszun yuch'a nintanatilgih-un, 'aw lhidinel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ndai la yuti-i ts'iyawh bulh dudinya 'ink'ez 'ukoh yaninya nts'e la yun k'ut Gilead whudzulh, whuz whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Whutat dzin-un 'et 'andit ts'iya Laban hidani' Jacob whenatselya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","'Et dulhutsinke dulh hubutilhdil 'ink'ez huyuntizyoot. Lhtak'ant'it dzin la hidulh 'ink'ez Gilead whudzulh toh 'et yutasuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","'Et hoonts'i 'uldzis 'et Laban, Syria whut'en-un, nusuti whe Yak'usda (Elohim) be hóodiltsai 'ink'ez 'uyulhni, “Huwa'oonli Jacob bulh yatalhdih te, hoontsi' te k'us hoonzoo k'un'a te bulh yaoolhduk junih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","'Et Laban, Jacob yut'asuya nyo Jacob nimbali nenin'ai dzulh toh, 'ink'ez Laban dulhutsinke tubulh nyo 'et nimbali nehunin'ai Gilead whudzulh whutoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","'Ink'ez Laban Jacob 'uyulhni, “Daint'en whe 'int'en whe nanalh'i'? T'eoonuzuszun whe 'ink'ez stse'ke cha 'ants'i 'ulhnane hubilhchoot saluzti be k'un'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Di ha 'inja snanto 'et whenatseilya? Soo hoonust'i' 'ink'ez shun be tubulh da', be ts'ujun-i cha nanyutoos'a' oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","'Aw sye'ke 'ink'ez stse'ke cha 'aw nalhubudusts'oos? 'Et whe tube whuzini whe 'inja 'et ndinja! ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Soo 'ustus whe 'ust'oh nyunduntasdoh wheni. 'Et hoonts'i mbá ooYak'usda (Elohim) 'ulhdzis da' sulh yailhduk 'ink'ez 'usulhni, ‘Huwinli 'aw ts'ih'un un'a 'uhoont'oh k'us hoonts'i' hukw'un'a te Jacob bulh yaoolhduk junih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","'Et 'andit 'alha mbá ooyoh kw'eni inli 'inka whenainja. 'Et hoonts'i di ha nyoo 'uk'eltsi ts'u tenadusdli-i, ts'iyawh 'i dunint'i?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","'Et Jacob 'uyulhni, “Whenuzjut 'et huwa 'usja. 'Et 'udusni, ‘Doo ka la ntse'ke nut'i be sgha hanabolyelh,’ dusni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ndun nyak'usda bulh nainla, khun hoona' junih. Nyulhutsinke bunalh ndai la nch'e' nusle-i, ts'iyawh nahuyolts'it 'ink'ez nailhchoot!” 'Aw Jacob t'eoonuszun Rachel dubá ooyak'usdane yundunist'i-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","'Ink'ez Laban, Jacob oonimbali t'ah ts'e whenya, 'ink'ez Leah oonimbali t'ah cha nane yuba 'ut'enne ts'ekoo bunimbali t'ah cha, ts'iyawh nusuya 'ink'ez gak, 'aw nalhe'ileh 'ink'ez Leah oonimbali t'ah tenanja 'ink'ez Rachel oonimbali t'ah daninya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","'Et whutsoda' Rachel nyoo oobá 'uk'eltsi yuts'utenadudli-i yilhchoot, 'ink'ez ndi camel yuk'usda-i, 'i ookw'uyuz'ai-i, 'i ye yanla 'ink'ez yuk'etl'adida'. 'Ink'ez Laban dulcho nimbali t'ah nuniztai 'ink'ez 'aw nalhuyilel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","'Ink'ez dubá 'uyulhni, “Khun te smoodihti whuts'un dooni' junih, 'aw mbut dudosya' ait'oh, whuz un'a ts'ekoo 'et nduhoont'oh nek'un'a 'ink'ez nuniztai.” 'Ink'ez gak 'aw nyoo 'uk'eltsi yuts'u tenadudli-i nalhuyilel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","'Et Jacob hunilch'e 'ink'ez Laban hukwa yidani' 'ink'ez Jacob Laban 'ulyuhni, “Ndet whe tank'us 'usja ha sdabe soo hunilch'e whe suntinyoot? ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","'Et ndinja, snaih toh whe dulcho nunintai. Dant'i nyoh usla 'i nainla? 'I njan nohbut neninle sih, sulhutsin 'ink'ez nyun, nyulhutsin bunalh! 'Et 'enne sih neba nahooyeh nyun 'ink'ez si bulh! ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nat whunizyat (20) yus k'ut whuts'un nyulh 'ist'en, 'usbai ts'eke 'ink'ez dúbe ts'eke, 'aw 'ilhoh hoonts'i lhuhiyat 'ink'ez 'usbai dune cha 'aw lhus'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ndai la khuna-i yayidalhch'ulh-i, 'aw ntl'a lhuslel ts'iyawh ook'elha whuzusi, mba k'elha susi-i slak'et whe ntl'a us'ai, dune yudunist'i tila k'us 'ulhdzis tila hidunist'i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","'Et 'ust'oh dzenis whunulwus, chan yit cha 'ink'ez 'ulhdzis cha yaootullhuk 'ink'ez 'aw lhustoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nyoh nat whunizyat (20) yus k'ut 'et 'ist'en, whunizyat 'on 'at dit (14) yus k'ut 'et ntse' buk'elha 'ist'en, 'ink'ez lhk'utat (6) yus k'ut cha ndi khuna-i cha ook'elha 'ist'en. Whunizyat (10) 'et ook'elha 'ust'en-un lhelhts'un un'a na'hoonla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sbá ooYak'usda (Elohim) 'ink'ez Abraham ooYak'usda (Elohim) 'ink'ez Isaac be nuzjut-un sulh 'uhoont'oh de, 'et de soo ts'ih'un 'aw slak'et hoonli hooloh whuda' nasutolh'a' oole'. Yak'usda (Elohim) ndet la hukw'endusda-un 'ink'ez sla be 'ist'en-un ts'iyawh hon'en 'ink'ez 'ulhdzis da' hukwa' nyudani'!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","'Ink'ez Laban, Jacob 'uyulhni, “Ndunne stse' 'uhint'oh 'ink'ez bubuzkeh cha suzkeh 'uhint'oh, 'ink'ez ndi khuna-i cha sch'e' 'unt'oh. Ndai la nilh'en-i, ts'iyawh sch'e' 'unt'oh, 'et daoosneh subah stse'ke k'us bubuzkeh te? ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","'Et huwa 'anih khuni 'olneh, nyun si bulh daja datni' lah, 'et t'eoonodzin.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","'Et Jacob tse 'ilho dilhchoot 'ink'ez 'et neidin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","'Et Jacob dulhutsinke 'ubulhni, “Tse nadulhdzooh 'ink'ez tse nahadalhdzoo' 'ink'ez lhk'ehidinla.” 'Ink'ez nyo tse ook'ut 'et na'hit'al. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban nyoo tse 'uwhulhni, “Jegar Sahadutha,” 'et hoonts'i Jacob 'en “Galeed,” whulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","'Et Laban 'en 'utni, “Ndi tse lhk'udizdla-i, 'i nyun si bulh khuni 'ilya-i, 'i oonalh 'uhoont'oh.” 'Et huwa Galeed hidoni'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Mizpah 'i cha 'et njan 'uwhulhni, 'et huwa ndutni, “Moodihti (Yahweh) nyun, si bulh ne-eguz nenilh'en lhch'oh 'it'oh te cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Stse' dzoh nubilhdzut de, k'us 'uyoonne 'atke te ilhchoot de, 'et hoonts'i Yak'usda 'en nyun, si bulh ne-eguz hoonilh'en whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","'Et Laban, Jacob 'uyulhni, “Ndi tse lhk'udizdla-i, 'i 'ink'ez njan nain'a-i cha nyun, si bulh ne-eguz 'usla-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ndi tse lhk'udizdla-i, 'i t'eooninzun 'ink'ez ndi nain'ai-i cha t'eooninzun ndi 'aw ba n'un toosya' ait'oh 'ink'ez nyun cha ndiz un'a 'on 'un tonya' ait'oh lhunduntaldah hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham ooYak'usda (Elohim), Nahor ooYak'usda (Elohim) 'ink'ez bubá buYak'usda (Elohim) cha, 'en ne-eguz nahotiyeh.” 'Ink'ez Jacob dubá, k'us mbe ye nuljut-un, 'en 'i be nahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","'Et Jacob nyoo dzulh k'ut 'et khuna-iyaz dalhk'un 'ink'ez dulhutsinke 'uhoo'alh hubulhni. Nyoo ut'alh-i han'al 'ink'ez 'ulhdzis dulyiz whe dzulh k'ut 'et hudalts'i'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","'Et bundada' 'et 'uda' Laban dudinya 'ink'ez duchaike, dutse'ke tubulh nabudits'ooz, 'ink'ez soo hoonzoo-i za butl'aookat 'i be soo hoonzoo-un be ubulh yalhduk 'ink'ez whenaja, 'ink'ez duyoh ts'e whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","'Et Jacob whenya nts'e tizya ts'e 'ink'ez Yak'usda (Elohim) oolizasne hidudizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","'Et hubutilh'en whe 'utni, “Njan 'et Yak'usda whut'i-un 'uhoont'oh,” 'ink'ez nyo hoozi' 'et Mahanaim whulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","'Et Jacob dutso khuni nu'ane 'enne dulhutsin Esau whuz whe balh'a', yun k'ut Seir huwhutni-un Edom keyoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","'Ink'ez 'ubulhni, “Smoodih Esau nja dudohni', ‘Nyunatne 'uten-un Jacob nja dutni, “Laban 'en 'oozih hoost'e' 'ink'ez 'et usda 'andit whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Khuna-i lhai ust'i, musdoos cha, donkey cha, 'ink'ez dune 'ink'ez ts'ekoo sba 'ut'enne cha, hoonint'i' whe la son'en 'inka nts'un whebis'a'.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","'Et nyoonne nukhuni nu'ane Jacob highu nandil 'ink'ez 'uhuyulhni, “Nyulhutsin Esau ooghuznindil. Didut cha ndiz nyudutiyalh, dit whunizyat whunizyat (400) 'et 'enne dune hiyulhtidulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","'Et Jacob tubeh nilhjoot 'ink'ez huwuni suli', dudune' ts'iyawh nawh hidulh whe lhk'ebanla, ndai la khuna-i 'ink'ez musdoos cha ts'iyawh nyokhi camel 'i cha nawh ukulh whe lhk'eyanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","'Ink'ez 'utni, “Esau njan 'ilhoh udulhne bughu ninya 'ink'ez whe buninghan de, 'onghuni 'udun ulh'usi 'ila yuch'a nintaoolhghas.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","'Ink'ez Jacob 'utni, “O sbá Abraham ooYak'usda (Elohim), sbá Isaac ooYak'usda Moodihti (Elohim Yahweh) 'usulhni, ‘Nkeyoh ts'e naindalh 'ink'ez nyunatneke buts'un 'et whuz hoonzoo whe 'utanelh mba ootiselh’. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","'Aw sgha te'ninzun 'ink'ez ts'ih'un khuni be cha sulh yailduk, 'i aw soo ba lhe'uzdzoo' whe 'ust'oh. Mba 'ut'en-un whunilhtan njan 'ukoh Jordan yanusya ndai la stuz cha nustun 'ink'ez nawh udulhne ts'uzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nts'u tenadusdli sulhuts'in Esau, 'en oola 'i ch'a. 'En be nuzjut doo ka sih ndiz sghu ninya 'ink'ez seooya' 'ink'ez suzkeh buloo tubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","'Usudini inle', ‘Hoonzoo mba ootiselh sudini inle'. Mbene la nts'u haindene yatooba sai 'et 'uhultsuk, 'aw butsolhto ait'oh butalhtselh.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","'Et 'ulhdzis nyo 'et hantez 'ink'ez ndai la yula k'eyankat-i, 'i dulhutsin Esau yuts'i yilhdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Nat whunizyai whunizyai (200) ts'eke dúbe, 'ink'ez nat whunizyai (20) dune dúbe, 'ink'ez nat whunizyai whinizyai (200) 'i 'usbai ts'eke, 'ink'ez nat whunizyai (20) 'usbai dune cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Tat whunizyai (30) nyoo camel uljas-i ooyazke cha, dit whunizyai (40) musdoos, 'ink'ez whunizyai (10) musdoos dune, nat whunizyai (20) donkey ts'eke, whunizyai (10) buzkeh cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","'I nyokhi yuba 'ut'enne tl'ayanla dich'oh whe 'ink'ez yuba 'ut'enne 'ubulhni, “Senghoozuhdilh 'ink'ez nilhdza' beguz whuzdla whe ndi whuz nihyulh khunai uh'ulh whe.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","'Ink'ez 'udechoo khuni yutl'ayan'ai 'uyulhni, “Ndet la sulhutsin Esau nohdudizya 'ink'ez nohoodulhkut de, ‘Mbe ch'e' uhli whe 'uht'oh?’ nohulhni de, 'ink'ez, ‘Nts'e tihdil?’ ni de, ‘Mbe ooch'e' 'unt'oh ndi nohtso usdla-i?’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","'Et 'udoohni', ‘Mba 'ut'en-un Jacob ooch'e' unt'oh. Oomoodihti Esau ts'otl'ayanla, 'ink'ez whunilh'en 'udek'oh nehuniyalh.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","'Et 'ulhnane bulh nat, bulh tane cha 'ink'ez khuna-i yunidulhne 'ubulhni, “'Et whuz un'a Esau bulh yatilhduk nalhti de. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","'Ink'ez 'et cha ndudoohni', ‘Whunilh'en nyunatne'ut'en Jacob 'en nek'oh uyalh.’ 'Et 'uninzun, “Ndi stso ulh'us, 'i bugha ininla 'ink'ez 'et hukw'elh'az oonin nilh'en de, 'et de sih soo sulh neho'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","'Et huwa ndi yuts'i tilhdil-i yutso 'uja, 'et hoonts'i didut nyo 'et 'ulhdzis 'et nimbali nenin'ai 'ink'ez 'et hantez. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","'Ink'ez 'et 'ulhdzis dudinya 'ink'ez du'at nahult'oh cha, buba 'ut'enne cha 'ink'ez whunizyane 'on 'at 'ilhune (11) ooye'ke cha, 'et nyo yahunindil 'ukoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","'Enne hubilhchoot 'ink'ez 'ukoh whuyaz yahunindil, ndai la yuts'i tilhdulh-i cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","'Et Jacob dich'oh za 'et nelts'ut 'ink'ez Dune bulh nulhuhulte, 'et 'ulhdzis nduhoolhyiz yukaih whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","'Et nyoon Dune t'eooninzun 'aw Jacob ch'a lhe'ilhdoh, 'et nyoon Dune Jacob bulh nulhuhulte whe Jacob ook'i lhghu nawhudulhghuz-un, 'et yut'aiznai 'ink'ez 'et nyoo Jacob ook'i 'i k'ulkut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","'Ink'ez ndun Dune, 'en 'et 'utni, “Slanadintnih 'awet hoot'en.” 'Et hoonts'i 'uyulhni, “'Aw nlanadoosnih ait'oh soo hoonzoo-un bulh 'usinla 'andit za.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","'Et 'uyulhni, “Ndai la nyoozi'?” 'Ink'ez 'utni, “Jacob.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","'Et 'utni, “'Aw nyoozi' on 'un Jacob lhunyodutasnel. Israel nyo dutanelh. Yak'usda (Elohim) 'en bulh nulhuzilti', dune cha, ink'ez 'enne buch'a' nilhde.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","'Et Jacob yoodulhkut, “Nts'u tedusdlih, nyoozi' 'i sudini?” 'Ink'ez 'et 'utni, “Di ha soozi 'i ooka 'oodilhkut?” 'Ink'ez 'awet whe soo hoonzoo-un oogha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","'Ink'ez Jacob nyoo boozi, “Penuel,” whulhni, “Yak'usda soo oonin ts'e us'en 'ink'ez 'aw dalhusnel,” ni 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","'Et soo nyo Penuel yaninya whe 'et sa hain'ai 'ink'ez nunulk'i suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","'Andit dzin whuts'un Israel oots'u haindene, 'enne nyoo 'uk'i ts'eh tsung 'aw lhuhayus'al, ndun Dune ook'i yut'aiznai 'et huwa, 'ink'ez nyoo oots'eh sugi suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","'Et Jacob ndo yutan'en whe dulhutsin Esau 'az de uyalh yutilh'en, dit whunizyai whunizyat (400) dune 'et 'uhultsuk, 'enne hiyulh udulh whe 'et duduzkeh lhk'ebanla, Leah cha, Rachel cha 'ink'ez nyoonne nane buba 'utenne cha butabuninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","'Ink'ez ndune ts'ekoo yuba 'utenne 'ink'ez ts'oodunne cha dubut nebuninla 'ink'ez Leah duduzkeh te ooniz de nebuninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","'Et whe butso neninya 'ink'ez yubut nachaniti, lhtak'ant'it 'et yubut nachaniti 'et dulhutsin yuzih neninya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","'Et hoonts'i Esau 'az de tilhgai, yududilhgai 'ink'ez yilhchoot 'ink'ez yuts'ilchun k'et 'et naidits'ooz 'ink'ez nahult'oh hantse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","'Ink'ez ndo yutan'en, 'et nyoonne t'sek'oo 'ink'ez ts'oodunne te, 'enne butilh'en 'ink'ez utni, “Ndunne 'enne mbene whe' hint'oh?” 'Et 'uyulhni, “Yak'usda (Elohim) ye unzoo-i gha mba 'ut'en-un bugha buninla 'uhint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","'Et nyoonne ts'ekoo natne'ut'enne 'ink'ez ts'oodunne tubulh nus hutizdil 'ink'ez yubut yo 'untutsulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","'Ink'ez Leah cha duduzkeh tubulh hibut nenindil 'ink'ez hibut yo 'untutsulh, 'et hukw'elh'az Joseph 'ink'ez Rachel bulh hizih nenin'az, 'enne cha hibut yo untizsel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","'Et Esau 'utni, “Daja ninzun whe ndi lheltsuk-i nyulh 'uhint'oh?” 'Et 'uyulhni, “'I bududisya, 'et de la soo cho sunolh'en smoodih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","'Et hoonts'i Esau 'utni, “Soo 'ultsuk-i ust'i sulhutsin, ndai la int'i-i nyunch'oh int'i.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","'Et Jacob 'utni, “'Awundooh! Slaineh, 'andit 'awet soo sunalh'en, 'et de ndi nts'u tisdil-i ilhchoot ndet la nyis'en whe 'ants'i Yak'usda (Elohim) oonin nus'en sba le'hoont'oh 'ink'ez tubeh hoonint'i' whe sunilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ndi soo hoonzoo-i sgha whults'ut ngha nus'ai-i ilhchoot, Yak'usda (Elohim) tube sts'un nzoo inle' 'ink'ez ts'iyai lhai ust'i.” 'Et doo cha 'uyulhni, 'inka yilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","'Et Esau 'utni, “Dugwe' 'awet uztoodilh 'ink'ez ntso sih natoosja'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","'Et hoonts'i Jacob 'en 'uyulhni, “Smoodih t'eooninzun ts'oodunne tehutsun, 'ink'ez ndi khuna-i whulukhi be 'udulhtuk whe 'unt'oh, 'i cha sulh 'unt'oh, 'ink'ez dune tube 'ilhudzin hiniyulh de nyoo khuna-i yaoodlah lah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Whute smoodih! Stso inyalh, mba 'ut'en-un ootso inyalh, 'ink'ez ndune butso toosya' sih nanilhtsulya, khuna-i cha 'ink'ez ts'oodunne cha, ndet la buba soo' hoont'oh-un 'ink'ez smoodih keyoh Seir 'et la ooghosya'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","'Ink'ez Esau 'utni, “Ndunne sulh nudilhne, oolohne nzih neboslelh.” 'Et hoonts'i 'utni, “Smoodih, 'awundooh, soo' hoont'oh! Soo cho sunoolh'en sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","'Et Esau 'et dzin whenaja keyoh Seir whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","'Ink'ez Jacob keyoh, Succoth huwhutni, ts'e whuz hoozdil. Yoh 'uhoonla 'ink'ez khuna-i ba cha dilhts'i-un 'uhoonla, 'et huwa nyo 'et 'andit Succoth huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","'Et Jacob soo dalhinel whe nyo keyoh whuti, Shechem huwhutni, whuz oozya, Canaan yun k'ut 'et whuz'ai Paddan Aram ts'e hainya, 'ink'ez nyo keyoh whuti 'et yoo 'az ts'e dunimbali nenin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","'Ink'ez nyo nimbali nenin'ai-un yun, 'i Hamor buzkeh 'enne bubuyonket. Shechem oobá, whunizyai whunizyat (1000) sooniya 'i k'elha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","'Et nyo loodel 'inla 'ink'ez El Elohe Israel whulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","'Et Dinah, Leah ooyats'e, Jacob ghu yulhtsi inle'-un, nyo ts'ekoo nyoh whut'ine, 'oh whut'ine, 'enne buts'u tizya ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","'Ink'ez Shechem, Hamor ooye', nyo keyoh lerwe ye' unli, yutilh'en whe yilhchoot 'ink'ez yuchant'inte' 'ink'ez ninta' yunilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Oozul tubeh nyoon Dinah ooba yinzoo, Jacob ootse', 'ink'ez tube yuk'entsi' 'ink'ez soo cho yulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","'Et Shechem dubá Hamor yulh yalduk 'uyulhni, “Ndun ts'ekeyaz 'en s'at tileh wheni sba ilhchoot.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","'Et Jacob whulh 'udants'o yutse' Dinah ninta' yunilh'en, 'et whulh 'udants'o 'et nyoonne ooye'ke nus khuna-i bulh 'uhut'en 'ink'ez Jacob 'aw whusanahidil whuts'un lhubudinel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","'Et Hamor, Shechem oobá, Jacob yughu ninya yulh yatilhduk huba. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","'Ink'ez Jacob ooye'ke nus 'uhut'en whe whuz de hanahidil 'ink'ez whulh 'uhudants'o tube buba dzoh suli' 'ink'ez honilch'e. Lhe'hoont'oh whe k'un'a hukwaya hoonli 'uja, Israel ootse' yuchant'inte', 'aw nduhoneh huba lhe'hoot'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","'Et hoonts'i Hamor bubulh yalhduk 'ink'ez 'ubulhni, “Sye' Shechem oozul ntse' tube yuk'eni unli oo'at yutaleh wheni oogha inilhtih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","'Ink'ez nebulh lhgho dolhts'i'. Ntse'kene 'enne negha buninle 'ink'ez wheni netse'ke 'enne hubilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","'Et de sih nezih hooht'e' 'ink'ez nyo yun cha 'et us'ai, 'i k'ut hoont'i 'ink'ez hoohket 'ink'ez 'e'oohket. Te'aht'en 'ink'ez nohnich'oh eni nohgha 'oozit sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","'Et Schechem 'en cha Dinah oobá 'ink'ez bulhutsinke 'enne 'ubulhni, “Nohba uszoo oole'. Daja suduhni-un 'et la nohgha ooslelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Daltsuk ha'nuhzun 'ink'ez nohts'u tisdulh-i. Daja duhni daltsuk-i 'ink'ez ndun ts'ekeyaz s'at tileh huba sgha nulhtih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","'Et hoonts'i Jacob ooye'ke Shechem 'ink'ez Hamor bulh 'ubuhutni 'ink'ez whunut'ih 'i be bubulh yahulhduk, nyoon dudulhtus Dinah ninta' inilh'en 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","'Ink'ez 'ubuhutni, “'Aw 'et duts'ooneh ait'oh, 'aw neulhtus 'aw yuka dune lhitus-un gha ts'oolhtelh ait'oh. Wheni neba hukwaya hoonli whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","'Et njan 'ilhughun huwa 'et de a'ah usdutinelh nek'un'a 'utant'elh, dune ts'iyawh yuka dune unli-un hubotitus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","'Et de la netse'ke nohgha buts'olelh 'ink'ez nohtse'ke hubuts'italhchulh 'ink'ez nohzih ts'otitelh 'ink'ez 'ilhoghun yinka dune'ne uztileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","'Et 'aw lhunedahts'il de, 'ink'ez nohka dune uhli-i nohuzt'us de, 'et de ndun neulhtus nats'italhchulh 'ink'ez naztidulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","'Et ndi khuni 'i tube buba yinzoo Hamor 'ink'ez ooye' Shechem 'en cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","'Et nyoon chilh 'ahoh 'et duja nyoon Jacob ootse' ooba yinzoo 'inka 'onus huwa 'it'en-un 'uja oobá ooyoh dilhts'ine buba nus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","'Ink'ez Hamor 'ink'ez Shechem ooye' te nyo keyoh whudatih 'et nehunindil 'ink'ez nyo keyoh whudune'ne bubulh yahulhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Ndunne dune nebulh soo dune hinli whe' hint'oh, 'et huwa njan yun k'ut huhoot'e' 'ink'ez 'uhooket te'hoot'en, ndi yun soo 'ulcho whe 'unt'oh. Butse'ke 'enne buts'olhchoot ne'atke wheni, 'ink'ez wheni netse'ke bugha buts'olelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Njan 'ilhoghun 'et za nduts'uja te, 'andit za dune neulh dune hutileh, whe 'ilho ts'utileh. 'Et ndun nedune 'enne ts'iyawh hika dune unli 'i ook'ut ts'oot'us, 'et didut ts'iyawh nduhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ndi bughuna' huyut'i-i cha 'ink'ez khuna-i ts'iyawh nech'e' tileh? 'Ants'i a'ah uzdoonih 'et de la nebulh dune hoole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","'Et nyo keyoh whuti tenindilne ts'iyawh Hamor, Shechem bulh ooye', hubodants'o, dune ts'iyawh yuka dune unli-i bubuhuzt'us, nyo keyoh tenindilne. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","'Et 'uhooja whulh tat dzin ts'iyawh bubulh 'ults'ulh, nane Jacob ooye'ke Simeon 'ink'ez Levi bulh Dinah bulhutsin, saluzti huyilhchoot 'ink'ez soo ts'et 'et nyo keyoh whuti dune ts'iyawh hubuhanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","'Ink'ez Hamor 'ink'ez Shechem ooye', 'enne cha saluzti be bubozilhghi 'ink'ez Dinah Shechem ooyoh 'et tenahinilhti 'ink'ez tenahundil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jacob ooye'ke ndunne huba hanghanne buzih nehunindil 'ink'ez nyo keyoh cha ts'iyai hilhchoot, bubulhtus ninta' hinilh'en 'et hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","'Et nyoo dude'usbai, musdoos dune cha 'ink'ez khuna-i donkey cha, 'ink'ez nyo keyoh usla-i cha nus yun k'ut usla-i cha ts'iyawh huyilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","'Ink'ez huye hoonzoo' 'unt'oh-i cha ts'iyawh huyilhchoot. Ntsoolneyaz 'ink'ez bu'atke cha hubuhilhchoot, 'ink'ez ndai la yoh usla-i cha ts'iyawh huyilhchoot ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","'Et Jacob 'en Simeon 'ink'ez Levi 'en ndo 'ubulhni, “Tube sba dzoh 'uhja! Ndunne dune ndoh whut'ine buba skalh'ehunizun suli'. Canaan whut'enne 'ink'ez Perizz whut'enne, tube wheni ts'intsool whe' ts'int'oh, ts'iyawh 'ilhohozdil 'ink'ez la sch'az nehudindil 'ink'ez la sozoolhghelh. Gak sotilhtselh syoh whut'ine cha, si cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","'Et hoonts'i 'uhutni, “Neulhtus 'ants'i 'ul'enne k'un'a ne'uztilh'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","'Et Yak'usda (Elohim) 'en Jacob 'uyulhni, “Dudinyaih 'ink'ez Bethel ts'e inyalh 'ink'ez 'et hont'e' sih. 'Ink'ez Yak'usda (El) nyunalh hainya inle', 'en ts'un loodel 'onleh, nyulhutsin Esau ooch'a tse tilya whe.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","'Et Jacob, yulh dune unline yulh whut'ine, 'et 'ubulhni, “Nyo 'udun keyoh lhelhyoo 'uyak'usdane buts'u tenaduhdli, 'udun nenuhle, nohtsun hooloh nadudulhtsih 'ink'ez nohnaih cha lhk'enaduhle. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","'Ink'ez duzdodilh, 'ink'ez Bethel ts'e uztoodilh. 'Et Yak'usda (El) ts'un loodel 'oosleh sih, mbe la dzin dzoh nuzut-un sulh 'ut'en whe whesya.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","'Ink'ez nyoo 'uts'un keyoh whut'enne, dant'i 'uk'eltsi yak'usda hitsun tenadudli-i nuhuyule-i, 'i ts'iyawh Jacob tl'ahuyanla, 'ink'ez dudzo gwul cha ts'iyawh 'ink'ez Jacob nyo duchun, oak huyulhni, 'i yucheh 'ahuyanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","'Ink'ez nahutisdil 'ink'ez Yak'usda oonujut-i, 'i ts'iyawh nyo keyoh whuti bukeidilts'ut, 'aw Jacob ooye'ke lhubontiyulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","'Et Jacob 'et Luz (Bethel huwhutni-un) whuz oozya, Canaan yun k'ut mbene la yulh nudilhne cha ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","'Ink'ez 'et loodel 'inla, 'ink'ez nyo 'et El Bethel whulhni, 'et Yak'usda nghu ninya inle', bulhutsin ch'a tse tilhya whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","'Et Deborah, Rebekah yuba ne'ut'en-un, dazsai. Nyo Bethel 'on yo nyoo duchun oak ndi 'i hicheh 'ahuyalhti. 'Et Allon Bacuth huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","'Et Yak'usda (Elohim) Jacob doo cha yunalhts'et hainya, whutso da' Padan Aram ts'e hainya whe soo hoonzoo-un oogha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","'Ink'ez Yak'usda (Elohim) 'uyulhni, “Nyoozi' Jacob ts'utni, 'aw 'on 'un Jacob be nts'iyozi' ait'oh, Israel 'i nyoozi' tileh.” 'Et whe boozi' 'i Israel yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","'Ink'ez 'et cha Yak'usda (Elohim) 'uyulhni, “Si Yak'usda 'Uk'enus 'Ultus-un (El Shaddai) 'en 'ust'oh. Lhai cho nts'u haookat 'ink'ez lhai cho oole' didohne 'ink'ez dune didohne ts'iyawh 'enne nts'u hahutidoh, 'ink'ez lerwene 'enne nyust'e ts'u hahutidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Yun Abraham 'ink'ez Isaac bulh bugha inus'ai-i, 'i ngha nus'ai. Nts'u haindene nk'elh'azne, ndi yun nohgha nus'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","'Et whe Yak'usda (Elohim) 'en ndo yuch'a whenaja, nts'e yulh yailhduk inle' 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","'Et Jacob tse whedintsi Yak'usda (Elohim) bulh yailduk-un, tse lhk'eidinla-i 'i nayantsi. 'Ink'ez ts'utnai-i 'i ook'ut 'i yuk'eyilhdzo 'ink'ez khe cha yuk'eyilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","'Ink'ez nyo 'et Yak'usda yulh yailhduk-un, Bethel whulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","'Et hutizdil Bethel whuch'a usdil 'ink'ez Ephrath 'awet nilhdukwyaz, 'et Rachel 'awet ooyaz whutaleh bulh 'utilhtsul 'ink'ez tube ooba hoontsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","'Et 'uhooja bulh 'ults'ulh whe nyoon yughunli-un 'uyulhni, “Wheniljut ilhoh, ndun 'en cha dune nyaz tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","'Et 'uhooja 'awet dawhenintsai whe 'et ndun duneyaz Ben-Oni yulhni, 'et hoonts'i oobá 'en Benjamin yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","'Et Rachel dazsai 'ink'ez Ephrath ts'u wheti-un ('et Bethlehem 'uhoont'oh), 'et 'ahuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","'Ink'ez tse lhk'edinla nyo yunts'un k'ut, 'et 'andit dzin whuts'un Rachel oots'un k'ut huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","'Et Israel tizya 'ink'ez Eder whuzih nain'a zih, 'et dunimbali neinin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","'Et 'uhooja Israel nyo yun k'ut hoot'e' whe Reuban 'en Bilhah nyoon oobá oo'at 'en yugha nyus 'unt'oh, 'en yuchant'inte' 'ink'ez Israel whulh 'udants'o. 'Ink'ez Jacob ooye'ke ts'iyawh whunizyane 'on 'at nane hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leah ooye'ke, 'enne Reuben, Jacob 'udechoo ooye', 'ink'ez Simeon, Levi cha, Judah, Isaachar 'ink'ez Zebulun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rachel ooye'ke, 'enne Joseph 'ink'ez Benjamin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilhah ooye'ke, Rachel yuba 'ut'en-un, Dan 'ink'ez Naphtali. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpah, Leah yuba 'ut'en-un, ooye'ke dune Gad 'ink'ez Asher hubuhutni. 'Enne ts'iyawh Jacob ooye'ke, Paddan Aram whut'i whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","'Et Jacob, dubá Isaac, yughu ninya. Mamre k'ut Kirjath Arba huwhutni, (Hebron 'uhoont'oh), ndet la Abraham 'ink'ez Isaac bulh huhoot'en-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","'Et Isaac 'en 180 yus k'ut yinka inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","'Et Isaac 'udek'ez hanaji 'ink'ez dazsai, 'ink'ez whutsoda' hubulh 'ant'e'ne, 'enne buts'un whenya. Tube duneti 'ink'ez lhat dzin cha be yus k'ut. 'Ink'ez ooye'ke Esau 'ink'ez Jacob bulh 'ahuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ndi 'i Esau ts'u haindene ghun, Edom huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ts'ekoo Canaan whut'enne but'oh 'enne du'at eni hubilhchoot. Adah 'en Elon ootse', Hitt whut'en-un 'unt'oh, Aholibamah, Anah ootse' Zebeon, Hiv whut'en-un 'en ootse', ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","'ink'ez Basemath, Ishmael ootse', Nabajoth bulhtus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","'Et Adah, Eliphaz yulhtsi, Esau ghu yulhtsi 'ink'ez Basemath, Reuel sulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","'Ink'ez Aholibamah, Jeush sulhtsi, Jalam 'ink'ez Korah cha, 'en Esau ooye'ke, Canaan yun k'ut whut'i whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","'Et Esau du'atke, duye'ke, dutse'ke 'enne mbene la yuyoh whut'ine, ts'iyawh musdoos cha 'ink'ez khuna-i, ndai la yut'i-i oogha ininde-i Canaan okhi yilhchoot 'ink'ez dulhutsin Jacob yughu whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ndai la huyut'i-i sdabe 'onus lhai suli', 'aw lhzih huhoot'e' ait'oh 'ink'ez nyo yun t'ehonuszun-un huwhut'i-un 'et cha 'aw nahult'oh hik'uhuna-i 'uhoolh'en ait'oh, khuna-i lhai huti k'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","'Inka Esau 'en Mt Seir 'et whut'i, Esau 'en Edom 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","'Ink'ez ndi 'i Esau ts'u haindene Edom whut'enne bubá, Mount Seir huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ndi 'i Esau ooye'ke buboozi', Eliphaz, Adah ooyaz Esau oo'at 'ink'ez Reuel, Basemath, Esau oo'at cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","'Ink'ez Eliphaz ooye'ke, 'enne Teman, Omar, Zepho, Gatam 'ink'ez Kenaz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","'Et Timna 'en Eliphaz oo'at 'en yugha nyus 'unt'oh, 'en Esau ooye', 'ink'ez 'en Amelek yughu sulhtsi, 'enne Adah, Esau oo'at buzkeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ndunne 'enne Reuel ooye'ke: Nehath, Zerah, Shammah 'ink'ez Mizzah. 'Enne Basemath Esau oo'at buzkeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ndunne 'enne Aholibamah ooye'ke, Esau oo'at, Anah ootse', Zibeon ootse'. 'En Esau, Jeush, Jalam 'ink'ez Korah 'en yughu bulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ndunne 'enne Esau ooye'ke moodih hubuhilh'i, Eliphaz ooye'ke, Esau 'udechoo ooye' inle', 'en dayi Teman, dayi Omar, dayi Zepho 'ink'ez dayi Kenaz, ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","dayi Korah, dayi Gatam 'ink'ez dayi Amalek. 'Enne Eliphaz oodayi hinli, Edom yun k'ut. 'Enne Adah oots'u hainzutne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ndunne 'enne Reuel ooye'ke, Esau ooye': dayi Nahath, dayi Zerah, dayi Shammah ink'ez dayi Mizzah. 'Enne Reuel oodayi Edom yun k'ut ndunne 'enne Basemath Esau oo'at buzkeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ndunne 'enne Aholibamah Esau oo'at buzkeh: dayi Jeush, dayi Jalam 'ink'ez dayi Korah 'enne Aholibamah ts'u hahande Esau oo'at, Anah ootse'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ndunne 'enne Esau ooye'ke Edom 'unt'oh, 'ink'ez ndunne 'enne budayi hanle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ndunne 'enne Seir, Hor whut'i-un ooye'ke 'enne ndi yun k'ut huwhut'i: Lotan, Shobal, Zibeon 'ink'ez Anah, ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezar 'ink'ez Dishan. 'Enne Hor whut'enne budayi, Seir ooye'ke Edom yun k'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","'Ink'ez Lotan ooye'ke: 'enne Hori 'ink'ez Heman, Lotan bulhtus 'en Timna huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ndunne 'enne Shobal ooye'ke: Alvan, Manahath, Ebal, Shepho 'ink'ez Onam. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ndune 'enne Zibeon ooye'ke: Aiah 'ink'ez Anah bulh, ndun Anah 'en 'uja chunt'oh duba donkey nulhyeh whe too k'et nahoon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ndunne Anah buzkeh: Dishon 'ink'ez Aholibamah, Anah ootse'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ndunne 'enne Dishon ooye'ke: Hemdan, Eshban, Ithran 'ink'ez Cheran. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ndunne 'enne Ezer ooye'ke: Bilhan, Zaavan 'ink'ez Akan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ndune 'enne Dishan ooye'ke: Uz 'ink'ez Aran. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ndune 'enne Hor whut'enne whudayi: dayi Lotan, dayi Shobal, dayi Zibeon, dayi Anah, ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","dayi Dishon, dayi Ezer, 'ink'ez Dishan, 'enne Hor whut'enne whudayi hinli, Seir yun k'ut 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","'Et ndunne 'enne lerwene Edom yun k'ut 'et hudalts'i', 'aw Israel buzkeh whutsoda'ne bulerwe hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beor ooye' Edom 'et whulerwe inle', 'et nyo keyoh whuti 'et Dinhabah huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","'Ink'ez Bela dazsai whe Jobab, Zerah, Bozrah whut'en-un ooye', 'en lerwe inle' yuk'edanya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","'Et Jobab dazsai whe Teman whut'enne bulerwe Husham huyulhni, 'en yuk'edanya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","'Et Hasham dazsai whe Hadad, Bedad ooye' 'en la Midian neninya whe whelhonigan Moab yun k'ut, ha'nuyeh-un, whe hubuch'a' nilhde, 'en yuk'edanya nyo 'et keyoh Avith huwhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","'Et Hadad dazsai whe Samlah, Masrekah whut'en-un, 'en yuk'edanya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","'Ink'ez Samlah dazsai whe Saul, Rehoboth-'Ukoh-Taba whut'en-un, 'en yuk'edanya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","'Et Saul dazsai whe Baal-Hanaan, Achbor ooye' 'en yuk'edanya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","'Et Baal-Hanaan, 'Achbar ooye', dazsai whe Hadar 'en yuk'edanya. Nyo 'et keyoh 'et Pau huwhutni. Oo'at boozi' 'i Mehetabal, Matred ootse' 'en Mezahab ootse' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Ndi 'i Esau oodayine buboozi' nts'en'a lah didohne 'ink'ez huwhut'ine buboozi': dayi Timnah, dayi Alvah, dayi Jetheth. ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","dayi Aholibamah, dayi Elah, dayi Pinon, ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","dayi Kenaz, dayi Teman, dayi Mibzar, ");
INSERT INTO crxNTpo_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","dayi Magdiel, 'ink'ez Iram. 'Enne Edom whudayi 'ink'ez nyo yun k'ut huwhut'ine 'ink'ez buch'e' cha, Esau 'en Edom whut'enne bubá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","'Et Jacob nyo Canaan yun k'ut 'et whut'i 'et 'aw oobá t'enuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Jacob nts'oh tune'ust'en: Joseph 'en whunizyat 'on 'at lhtak'ant'it be yus k'ut (17) 'et nus khuna-i gha' un'aih dulhutsinke tubulh, bubulh 'ut'en nyoonne bulhutsinke 'enne Bilhah buzkeh 'ink'ez Zilpah buzkeh cha, oobá oo'atke, 'enne bubulh 'ut'en 'ink'ez Joseph dubá 'en yulh nahoolnuk tank'us ne'hut'en huwun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","'Et Israel, Joseph 'onghunne duzkeh buba nus yuk'entsi'. 'Udek'oh ooye' 'ink'ez duneti whe ooye' yuzdli' 'et huwa, 'ink'ez dzoot yuba 'inla, lhelhts'un 'ot'en-i 'i dzoot yuba' yinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","'Et bulhutsinke dalcho-i be la bubá Joseph yuk'entsi' huwhunilh'en, 'inka hits'u dutni 'ink'ez 'aw soo cho hiyulh yalhulhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","'Et Joseph nusuti 'ink'ez dulhutsinke bubulh nahoolnuk. 'Et 'onus hits'u dutni suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","'Et 'ubulhni, “Ndi oowanususti-i oozulhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","'Et ats'o nus lhes hananyai-i, 'aw lhdunilt'o whe be ne'ts'udulhch'uz 'ink'ez ndi lhadusla-i 'i ats'o do 'uja 'ink'ez ants'i usyin le'unt'oh, 'ink'ez be ne'dilhchus-i nohch'e' 'i ndi lhadusla-i 'i hinadilhya 'ink'ez hibut yo untutsulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","'Ink'ez bulhutsinke 'et 'uhuyulhni, “Nelerwe tanleh whe 'udini 'ink'ez nemoodih tanleh whe 'udini?” 'Et ts'o 'onus hits'u dutni nute-un huwa 'ink'ez ooghuni cha huwa ts'iyawh hits'u dutni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","'Et doo cha 'udun huwunusuti 'ink'ez dulhutsinke hubudani' 'ink'ez 'utni, “Whunulh'en doo cha 'udun huwunususti. 'Andit ndi dzenis ooza' 'ink'ez 'ulhdzis ooza' cha 'ink'ez whunizyai 'on 'at 'ilho sum, 'i cha sbut yo 'uhuntutsulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","'Et dubá yudani' 'ink'ez dulhutsinke cha budani' 'ink'ez oobá hukwa' yundani' 'ink'ez 'uyulhni, “Dainja whe 'inja? Ndiz un'a nusinti nloo 'ink'ez si cha 'ink'ez nyulhutsinke ts'iyawh mbut yo untitsulh whe' dini?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","'Ink'ez bulhutsinke highe 'oolnih 'ink'ez oobá 'en 'ants'i huwu nuninuzut za 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","'Et bulhutsinke bubá ooghuna' Shechem ts'e higha' ti'alh ha whuz whehandil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","'Ink'ez Israel, Joseph 'ulhni, “Nyulhutsinke Shechem ts'e whuz khuna-i gha' hu'aih. 'Anih whuz nyutoos'a sih!” 'Et 'uyulhni, “A, njan susda.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","'Et whe Israel 'uyulhni, “Sla 'ineh whe, inyalh nyulhutsinke soo 'uhint'oh whe, khuna-i cha soo 'unt'oh whe, 'ink'ez khuni 'i whuz sba naton'alh.” 'Et whe njan Hebron whenkoh 'et wheyalh'a' 'ink'ez Shechem ts'e whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","'Et 'uyoon dune Joseph nayilhti 'ants'i nus 'et ats'o nus lhelhts'oyalh 'ink'ez dune 'uyulhni, “Di huninta whe 'int'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","'Et utni, “Sulhutsinke bukunusta whe 'ust'en. Sudini nts'e suba khuna-i gha' hun'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","'Et dune 'utni, “'Utsun whehandil whe' hint'oh. ‘Dothan nts'ez uztoodilh,’ hutni whe 'et hubudasts'o.” 'Et Joseph whuz buba whenanya 'ink'ez Dothan 'et nabinla ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","'Et 'az de uyalh hitilh'en whe lhahodinla hituzilhghelh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","'Et 'ulhodutni, “Nyoon nute-un 'az de uyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","'Et huwa 'andit ts'uzoolhghelh 'ink'ez tsak'et 'ats'ooneh! 'Ink'ez la 'uzdooni', ‘Khuna-i yellhoh,’ uzdooni' la, huwunute-un dahoneh subah!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","'Et hoonts'i Reuban budants'o 'ink'ez bula k'ehayalhti 'ink'ez 'utni, “'Aw lhts'uzoolhghelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","'Ink'ez Reuban 'ubulhni, “'Aw buzkaih hoolhtselh junih! 'Ants'i njan tsak'et 'et 'atsoolhtelh, chunt'oh 'uhoont'oh, 'aw ootalhizohnal.” 'Et de la yoolhyih 'ink'ez dubá ts'un naitoolhtelh, 'inka 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","'Et 'uhooja Joseph dulhutsinke bugha ninya whe nyoo dzoot huye hayalhti, nyoo dzoot lhelhtsun 'ot'en-i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","'Et huyilhchoot 'ink'ez nyo tsak'et 'et 'ahuyano, nyo tsak'et 'aw too hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","'Ink'ez natl'ahudilts'i' 'uhuti'ulh wheni, 'et do hitan'en whe 'az de Ishmael whut'enne 'az de hidulh, Gilead ts'e hahandil. Camel dunt'i-i khuna-i cha ts'iyawh bulh, bulh buta'whut'en-i, lhai cha huyilelh, 'ink'ez balm 'ink'ez myrrh huyulhni, ndunt'i-i cha Egypt ts'e huyutizdla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","'Et Judah dulhutsinke 'ubulhni, “Di suba negha ookat neulhutsin ts'uzilhghi 'ink'ez buzkai' ts'untilh'i de? ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","'Anih nyoonne Ismael whut'enne 'az de udulhne, 'enne be buts'e' ts'oket, 'aw kw'elhts'udolhni, neulhutsin 'unt'oh, 'ink'ez neyust'e cha unli.” 'Et bulhutsinke huyoozalhts'ai'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","'Et ndunne Medianne 'ooketne 'owhuya hidulh, 'et bulhutsinke Joseph nyo tsak'et hanahuyalhti 'ink'ez nyoonne Ismail whut'enne, 'enne nat whunizyai (20) silver, 'i k'elha huye 'onket 'ink'ez nyoonne Joseph huyilhchoot 'ink'ez Egypt ts'e whehuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","'Et Reuban nyo tsak'et whuz naoosja 'ink'ez Joseph 'aw nyo tsak'et hooloh, 'et dunaih yayidalhch'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","'Ink'ez dulhutsinke bughu nanja 'ink'ez 'utni, “Duneyaz 'awet hooloh suli'! Nts'e subah toosya?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","'Et nyoo Joseph oodzoot huyilhchoot 'ink'ez dúbe ntsool-iyaz, 'i hizilhghi 'ink'ez nyoo dzoot 'i buzkaih hiye tunahuyulhchooz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","'Et ndi dzoot lhelhts'un 'ot'en-i, 'i bubá hits'u nahuyoolhchooz 'ink'ez 'uhutni, “Ndi nats'ilhchooz nye' oodzoot tila 'unt'oh k'us 'awundooh tilah?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","'Et nayoolhts'it 'ink'ez 'utni, “Sye' oodzoot 'unt'oh! Khuna-i 'ants'i yellhoh, 'aw nawh lhe'hoot'oh Joseph yabe' yidalhch'ul.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","'Et Jacob dunaih yayidalhch'ul 'ink'ez doso 'i duts'itoh nayuzguz, 'ink'ez duye' lhatdzin whe yuk'eninudleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","'Et ooye'ke 'ink'ez ootse'ke cha ts'iyawh k'enahino'ah kwa' hut'en. 'Et hoonts'i 'aw k'enahino'ah ait'oh 'ink'ez 'utni, “Nyo sts'un k'ut ts'e tisyalh, sye' ook'eni untislelh.” 'Ink'ez oobá yuk'etso. ");
INSERT INTO crxNTpo_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","'Et nyoonne Median whut'enne, yun k'ut Egypt ts'e, nyoon Potiphar huyulhni, 'en ts'un huye 'onket. 'En Pharaoh lhuganne moodih, nyo huwunline bumoodih cha unli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","'Et owhuya whudizulh whe Judah dudulhutsin bughu tizya 'ink'ez dune Adullam whut'en-un, Hirah huyulhni, 'en yughu hato ts'e whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","'Et nyo Judah Canaan whut'en-un, 'ilhoghun ootse', 'en yunilh'en, Shua huyulhni, 'ink'ez yughusda 'ink'ez yuchant'inte'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","'Et ulchan 'ink'ez duneyaz sulhtsi 'ink'ez boozi' Er yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Doo cha za ulchan 'ink'ez doo cha za dune ooyaz suli'. 'Et boozi' Onan yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","'Et doo cha za ulchan 'ink'ez duneyaz ooyaz suli'. 'En boozi' Shelah yulhni. Chezib keyoh huwhutni-un, 'et nyoon ooba 'et 'ut'en whe yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","'Et Judah duyaz 'udetso-un, 'en ba ts'eke yughu tidalh ha yilhchoot. Ndun ts'eke boozi' Tamar huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","'Et hoonts'i Judah ooye' 'udetso Er, 'en Moodihti (Yahweh) bunalh whe ninta' 'ut'ih, 'ink'ez Moodihti (Yahweh) 'en Er yuzilhghi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","'Ink'ez Judah 'en Onan 'uyulhni, “Nyulhutsin oo'at ilhchoot 'ink'ez ooghu sinda, 'ink'ez nyulhutsin yuk'edutiyalh-un oole' sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","'Et Onan t'eooninzun 'et ndun-un ts'oodun hotileh de, 'en 'aw didut ooyaz lhiloh. 'Ink'ez Er ndai yut'i 'i 'aw oogha ílhtaskulh. 'Et huwa 'et njan duhooja whe hukw'elh'az dulhutsin oo'at ts'un daninya whe yuchantinte'. 'Ink'ez ooch'a 'uhooja, 'i yun k'uz ts'e whenluz, dulhutsin yuba ts'oodun tit'elh whuch'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","'Ink'ez njan 'et duja-un, Moodihti (Yahweh) tube whuts'u dutni 'inka 'en cha yuzilhghi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","'Et Judah duyas'at Tamar 'uyulhni, “Mbá ooyoh 'et sinda 'ink'ez tsandilh za inli, ndun sye' Shelah untiyeh whuts'un.” 'Ink'ez 'utni, “Doo ka sih dulhutsinke k'un'a daootsah.” 'Ink'ez Tamar dubá ooyoh ts'e whuz whutitelh ha whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","'Et whe nduhooja hukw'elh'az Shua ootse', 'en Judah oo'at, 'en dazsai 'ink'ez Judah k'enahinu'ah. 'Ink'ez be 'usbai hat'asne buts'un keyoh Timnah 'et, didut 'ink'ez yulh dune Hirah, 'en Adullam whut'en, 'en bulh, ndo whuz whe han'az. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","'Et Tamar hiyulh nahoolnuk, 'uhuyulhni, “Whunilh'en nzaz, Timnah ts'e tiyalh 'usbai hatit'us wheni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","'Et nyoo tsandilh naih ye dune unli-i, ye hanaja 'ink'ez ne'dilbal, 'ink'ez kha'osduz. 'Ink'ez ts'et, Timnah ts'uwhuti-un, 'et usda. Shelah 'awet nizyai yunilh'en 'ink'ez 'awhuz oo'at tileh wheni yugha lhiyulhti 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","'Et Judah yutilh'en, 'ul'en-un 'unt'oh yuninzun, dunin k'e'nilhbal 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","'Et yughu ninya 'ink'ez 'utni, “Nzih ooste'.” 'Aw nyoon duyas'at 'unt'oh 'aw t'eoonuszun. 'Et ts'eke 'utni, “Di sgha tan'alh 'et de szih tantelh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","'Ink'ez 'utni, “Dúbe ntsool-i 'ilho 'i nts'o tl'atistelh.” 'Ink'ez ts'eke 'utni, “Sts'u nahitanyeh eh, sts'otl'atalhtelh whuts'un?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","'Et Judah 'utni, “Di suba 'et ngha oos'alh be nts'un nahitasyeh-i?” 'Et nyoon ts'eke 'utni, “Nyoo latult'o nyoozi' be, 'ink'ez nyoo tuz nintun-i cha.” 'I ts'iyawh yugha ininla 'ink'ez yuzih inte' 'ink'ez ulchan. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","'Et dudinya 'ink'ez 'uts'un whenya. Dunin k'einizbal-i cha k'unaitilhbalh, 'ink'ez doo cha tsandilh unli-i naih ye naja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","'Ink'ez Judah dúbe ntsool-i dut'eke Adallam whut'en-un, 'en whuz yuts'u wheyalhti ts'eke 'ink'ez ye yuts'u nahizya-i cha 'et hoonts'i 'aw nayolhtelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","'Et nyoonne 'et whudune'ne buboodulhkut, “Nyoon 'ul'en-un, nyoo ti whuzih usda-un, nts'e whenya?” 'Et 'uhuyulhni, “'Aw njan 'aw 'ul'enne hooloh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","'Ink'ez Judah ts'un naoosja 'ink'ez 'uyulhni, “'Aw naoostelh ait'oh 'ink'ez nyo 'et whut'enne 'enne 'uhutni, ‘'Aw nyo 'ul'enne hooloh,’ hutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","'Et Judah 'utni, “Whute, duba yoolhchoot, ndi doo ka sih yooya ts'oole'. Ndi dúbe oots'otl'ayisti 'ink'ez 'aw nalhilhtel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","'Et whudizulh whutoh ta sanun inle' at'en, 'et Judah hiyulh nawhulnuk, “Tamar nyas'at 'ul'en-un na'dudalhtsi 'ink'ez 'ul'en whe ulchan.” 'Et Judah 'utni, “Tenulhtih 'ink'ez hidolhk'un!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","'Et tenhinilhti whe 'et duzaz yuts'o tl'ahunin'ai, “Ndi mbe dune oowuzchan-un, 'en ooch'e' 'unt'oh, ndi latult'oh, boozi' be tl'oolhyaz 'ink'ez tuz cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","'Et Judah 'utni, “A, sch'e' 'unt'oh. Sanus ts'ih'un ne'ut'en, 'aw sye' Shelah oogha lhuyustel 'et huwa.” 'Ink'ez 'on 'at 'aw t'enalhinidzil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","'Et 'awet whudizulh whe 'awet 'ulhtsi whe nane ts'oodunne bulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","'Et nyo 'awet whe bulh utiltsut whe ilhoghun 'en oola cho iltsai. 'I nyoo ts'eke yughunli-un 'ugha batse' dulk'un-i, 'i yulasga ye yulchuz 'ink'ez 'utni, “Ndun 'en 'udechoo whuzdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","'Et 'uhooja dulayaz 'udun nenadilni whe bulhutsin ookwatselhuhoodli whe 'en cha whuzdli. 'Et nyoon ts'eke 'utni, “Dainja whe 'inja! Whuzinli nyunch'oh za mba 'uhoont'oh!” 'Et huwa 'en boozi' Perez huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Hukw'elh'az bulhutsin whuzdli, 'et nyoon gha batse' dulk'un-i oolasga be yulchuz, 'en Zerah huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","'Andit whe Joseph ntsun Egypt ts'e whehiyalhti, 'ink'ez Potiphar, 'en budayi cho Pharaoh lhuganne 'en huba ne'duni', 'en 'ilhoghun bumoodih unli, 'en Egypt whut'en 'en yonket. Ishmael whut'enne ts'un 'en nts'un whehuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","'Et Moodihti (Yahweh) Joseph yulh 'unt'oh 'ink'ez tube soo din'a suli'. Nyoon Egypt whut'en oomoodih yinli-un 'en ooyoh usda. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","'Ink'ez oomoodih yunilh'en 'ahoolhyiz Moodihti (Yahweh) yulh 'unt'oh 'ink'ez oolak'ez ts'iyawh be unzoo yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","'Ink'ez Joseph tube ooba yinzoo 'ink'ez yuba 'ut'en. 'Et ooyoh dulcho whumoodih unli yulhtsi, 'ink'ez ndai la yut'i-i cha ts'iyawh yula k'enyanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","'Et yoh moodih yulhtsi 'et whuts'un 'ink'ez ndai la yuti'-i cha ts'iyawh yutl'ayanla. 'Et huwa Moodihti (Yahweh) nyoo Egypt whut'en ooyoh dilhts'ine soo hoonzoo-un bugha whults'ut. 'Ink'ez ndai la yuti-i cha, yoh yut'i-i cha 'ink'ez ootl'o k'uz cha yut'i-i, ts'iyawh Moodihti (Yahweh) soo hoonzoo-un oogha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","'Et ndai la yut'i-i, ts'iyawh Joseph yula k'eyanla, 'aw didut t'eoonuszun di ut'i, ut'alh-i yu'alh-i, 'i yu'alh. 'Ink'ez Joseph dunezoo', ooyust'e dulcho whe unzoo, soo 'ot'en cha 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","'Et hukw'elh'az whudizulh, 'et nyoon oomoodih oo'at, Joseph 'en yuka' ninzun hukw'un'a yunilh'en 'ink'ez 'uyulhni, “Schan t'esinti.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","'Et hoonts'i yuch'a tse disnih, 'ink'ez nyoon oomoodih oo'at 'uyulhni, “Whunilh'en smoodih 'aw njan yoh dast'en 'et t'eoonuszun. Ndai la yut'i-i cha ts'iyawh sla k'eyanla. 'Et 'ink'ez ndi yut'i, 'i ts'iyawh stl'ahonla slak'ez ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","'Aw njan yoh 'aw sanus 'ulchone hooloh. 'Aw hoonli cha sch'a nulhonulh'i'. 'Et 'andit nyun 'en oo'at inli, 'et huwa nts'en'a utisnelh lhe'whulcho-un, lhe'whultsi'-un 'et 'utisnelh 'ink'ez Yak'usda ooch'az lubeshi nedutasdalh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","'Et dzin totsuk yulh yalhduk, 'et hoontsi 'aw lhidusts'o, yuchan t'eoote' yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","'Et 'uhooja 'oh whuya whudizulh at'en, 'et Joseph yoh ts'e whenaja 'utit'elh huba, dune cha yoh hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ts'eke yunaih yilhchoot 'ink'ez 'uyulhni, “Schan t'esinti!” Ndi naih yoontun-i, 'i yoontun whe yuch'a tilhgai 'ink'ez 'az telgai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","'Et ndi oonaih oolak'et yulhchooz, nyoon ts'eke yunilh'en, 'en cha 'az whelgai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Nyoonne dune 'enne whuyoh dunene buts'ahanyih 'ink'ez 'ubulhni, “Whunulh'en, ndun Hebrew whut'en-un 'en neghi nilhti neghodloh ha, 'ink'ez yoh daninya 'ink'ez duchan t'eooste' sulhni, 'ink'ez tube cho 'asuzdzul! ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","'Et 'awet hisyih 'et sudants'o whe 'et 'ink'ez uso, ndi oonaih 'i ndi slak'ez yula ditni 'ink'ez 'az whelgai!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","'Et ndi naih yoontun, Joseph oomoodih dananja whuts'un yoontun, 'ink'ez yulh yatilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","'Ink'ez 'uyulhni, “Nyoon Hebrew dune ba 'ut'en-un njan danilhti-un, szih neninya 'ink'ez sghudloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","'Et ooch'a 'azdzul whe ndi oonaih 'i szih yula ditni 'ink'ez 'az whelgai.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","'Et Joseph oomoodih whulh 'udants'o ndi khuni yudants'o oo'at daja yulhni la, “Mba 'ut'en-un njan 'et dusinla,” 'et hunilch'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","'Et Joseph oomoodih yilhchoot 'ink'ez dune 'ahudin'ai-un, ndet lerwe be 'ulhnane 'adinlane, 'et 'ayan'ai, 'ink'ez nyo tsak'et 'et 'adin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","'Et hoonts'i Moodihti (Yahweh) Joseph yulh 'unt'oh, 'ink'ez yugha te'ninzun, nyo 'adin'ai-un humoodih 'en yuba unzoo suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","'Ink'ez nyo tsak'et 'ahudinla-un humoodih, nyo 'adinlane ts'iyawh Joseph tl'abanla. Nts'oh dahut'en-un 'et Joseph ba 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","'Et nyo 'ahudinla-un whumoodih, Joseph ndai la yughana-i 'aw lhinilh'en, Moodihti (Yahweh) yulh 'unt'oh 'et huwa. 'Ink'ez ntsoh dat'en ndai la yughana ts'iyawh Moodihti (Yahweh) dizti' yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","'Et hukw'elh'az 'et nduhooja whe ndunne Egypt whutenne lerwe ooyoh 'uhut'en, dayi ne'ut'en, 'ink'ez nyo yoh lhes ulht'es-un cha, bumoodih lerwe hiba dzoh 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","'Ink'ez lerwe Pharaoh 'en ndunne nane yuba ne'ut'enne, 'enne dayi ne'ut'en 'ink'ez dayi 'ulht'es, 'enne tube whe bubulh hunilch'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","'Ink'ez nahult'oh 'aban'ai, nyoon Pharaoh lhuganne oodayi cho ooyoh, 'en tl'abalhti, Joseph 'adin'ai-un 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","'Ink'ez nyo Pharaoh lhuganne oodayi cho, Joseph 'en tl'abalhti 'ink'ez buba ne'ut'en. 'Ink'ez 'atsul 'et 'ahudan'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","'Et nyoon yoh 'ut'en moodih 'ink'ez nyoon lhes ulht'es-un lerwe ba 'ut'enne nyo 'ahudin'ai, nahult'oh nuhuztez, 'ilhe 'ulhdzis za, lhelhts'un un'a nuhuztez. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","'Ink'ez Joseph bugha daninya bundada', 'ink'ez bunilh'en, 'ink'ez nahult'oh ni hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","'Et Pharaoh oomoodihne hubulh 'uhut'enne 'ubulhni, “Di ha 'uht'oh nohdzi unduda 'andit dzin?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","'Ink'ez 'uhuyulhni, “Nanílt'oh 'andit 'ulhdzis nusítez 'ink'ez daja ni whe 'utni-un, 'aw nedoni'ne hooloh.” 'Ink'ez Joseph 'ubulhni, “Ndet huwa 'et nusuhtez-un, Yak'usda 'en za iloh lakw ba 'uhoont'oh. T'ewhuntihzeh hukwa' nuzun de, sudúhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","'Et nyoon yoh 'ut'en moodih, Joseph daja la nusuti 'et yadani' 'ink'ez 'utni, “Whunilh'en njan nuste-un 'ants'i duchun 'i sbut nadan'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","'Et ndi duchun 'i ta oozooschum hoonli 'ink'ez oots'u ha'nulhyeh. Oots'aha' nalhyai 'ink'ez mai ts'ekoo too' huyilh'i, 'i mai 'i oots'aha inalhyai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","'Ink'ez Pharaoh oolubot 'i sla k'es'ai 'ink'ez nyoo mai uschoot 'ink'ez nyo Pharaoh oolubot 'et dunisni 'ink'ez Pharaoh oola k'eyiskai.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","'Ink'ez Joseph 'uyulhni, “Daja ni whe 'utni nyudutasnelh. Ndi ta 'uzooschum 'i tat dzin 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tat dzin inle' de, Pharaoh whutso da' daint'en la, 'et nenyanutalhtelh, ntsi ndo 'uyutilelh ink'ez oolubot 'i ootl'aitankalh, whutso da' dailh'en lah ba 'int'en da'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","'Et hoonts'i snaoolnih 'awet mba soo' hooja de, 'ink'ez sts'un onzoo', Pharaoh sba oobulh yaoolhduk 'ink'ez njan tenaoosja'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","'Alha Hebrew whut'enne bukeyoh 'et whuts'un sgho ndunist'i whe 'ust'oh. 'Aw hoonli lhe'usnel whe njan 'aw 'asuhoo'alh huba lhe'hoot'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","'Et nyoon lerwe ba lhes ulht'es-un, nyoon 'onghun-un huwu nusuti-un hoonzoo, 'et Joseph 'uyulhni, “Si cha whuz un'a nususti 'ink'ez njan 'et ta lhyul lhests'ai, 'i stsi k'usla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","'Udedo telh 'i lhelhdoh-i lhes sut'e-i te, 'i Pharaoh ba 'unt'oh, 'ink'ez dut'aiyaz ndo stsi k'uskai whe ts'iyawh huyan'al.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","'Et Joseph 'uyulhni, “Daja ni whe 'utni nyudutasnelh. Ta telh, 'i tat dzin 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tat dzin inle', 'et Pharaoh ntsi 'i nch'a ndo 'itilelh, 'ink'ez duchun k'ez 'et nze'tigus 'ink'ez dut'ai 'i nyust'e hiti'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","'Et 'uhooja whulh tat dzin inle' whe, 'et Pharaoh whuzdli dzin 'ink'ez dune ghu nusuya duba 'ut'enne ba, 'ink'ez nyoon yoh huwunli, 'ut'en ghunli-un whumoodih, 'ink'ez nyoon lhes ulht'es-un bulh, 'enne butsi do 'uyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","'Et ndun 'ut'en moodih yilh'i-un, cha za 'et nenainilhti 'ink'ez lubot 'i Pharaoh oola k'eyan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","'Et hoonts'i nyoon lhes ulht'es-un, 'en yuze'uzguz, Joseph daja yulhni la whuz 'un'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","'Et hoonts'i nyoon 'ut'en moodih-un, 'aw Joseph yunaoodilhnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","'Et 'uhooja soo nat yus k'ut inle' whe Pharaoh nusuti, 'ink'ez whunilh'en, 'ukoh taba usyin 'et huwun nusuti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Khuntsul 'et nyo 'ukoh lhtak'ant'i musdoos 'i too halghaz, nilhk'a 'unt'oh unzoo 'ink'ez nyo tl'o k'ut 'et 'u'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","'Et whunulh'en, 'uyoo musdoos lhtak'ant'i 'i cha yunilh'us, 'ukoh ts'e hailh'az. Ntsi' 'ink'ez oodanusugi 'ink'ez nyo 'uyoo musdoos 'i yuzih taba nudilhya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","'Ink'ez nyoo musdoos ntsi'-i oodanusagi-i, nyoo lhtak'ant'i musdoos nilhk'a nzoo-i, 'i ts'iyawh yan'alh. 'Et Pharaoh ts'enandzut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","'Et doo cha nanisti 'et whulhnat nusuti. Khuntsul lhtak'ant'i nyoo hunuyeh, lhes te, ooghu hoonli-i, 'i 'ilho hanalhyai-i, 'i yuts'u hanalhyai ncha 'ink'ez nzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","'Et 'ink'ez lhtak'ant'i dindot-iyaz ndaz nilhts'i be 'utsi' suli', 'i hukw'elh'az hanalhyai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","'Ink'ez nyoo lhtak'ant'i hanalhyai-i, 'i nyo lhtak'ant'i nzoo cha 'unt'oh 'ink'ez ncha, 'i yan'alh. 'Et Pharaoh ts'eninzut 'ink'ez 'alha nusuti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","'Et 'uhooja bundada' ndi ooyughi tube 'uts'un un'a ooba 'uhooja, 'ink'ez Egypt whut'en keyoh-un mbene ne'dulhdeh cha 'ink'ez mbene la whunihne cha, 'enne buka' dani' 'ink'ez Pharaoh daja la nusuti-un 'et hubudani'. 'Ink'ez ts'iyawh 'aw gak ndet 'uhoont'oh-un 'et 'aw lhuhidusnih, t'ehonuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","'Et nyoon yoh 'ut'en moodih-un, 'en Pharaoh yulh yailhduk 'ink'ez 'uyulhni, “'Andit dzin whe tank'us 'ust'oh-un 'et whunaznih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","'Et Pharaoh yuba 'ut'enne bubulh hunilch'e' 'ink'ez si 'ink'ez lhes ulht'es-un moodih cho bulh nanilt'oh whe nyo Pharaoh lhuganne budayi cho ooyoh, 'en zih 'anean'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nanilt'oh nusítez 'ilhe 'ulhdzis 'ink'ez whenich'oh nek'un'a 'et nusitez nanilt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","'Et nyo 'ilhoghun Hebrew chilhyaz, 'en nebulh 'adin'ai nyo Pharaoh lhuganne budayi cho, 'en ba ne'ut'en-un, 'ink'ez 'en datni' 'ink'ez nedani' nusitez-un, ts'iyawh nedani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","'Ink'ez 'et 'uhooja nts'en'a lah nedani' nusitez-un, whuz un'a 'uhooja. Si njan se'ut'en 'et nenasunilhti 'ink'ez nyoon yuze'uzguz.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","'Et Pharaoh, Joseph yuka' dani' 'ink'ez 'ahoh yughu dahinilhti. Na'dunidzo cha 'uja 'ink'ez dunaih cha lhk'enaidanla, 'ink'ez Pharaoh yughu ninya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","'Et Pharaoh 'en Joseph 'uyulhni, “Nususti 'ink'ez 'aw dune sudoni'ne hooloh. Dasja whe 'ust'en nyun nyulh 'udasts'o t'eooninzun, dune nutes-un 'ink'ez hubudini.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","'Et Joseph 'en Pharaoh 'uyulhni, “'Aw si syo ts'e 'ilho 'uhoont'oh. Yak'usda 'en la Pharaoh hoonzoo hukw'un'a yudoni'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","'Et Pharaoh 'en Joseph 'uyulhni, “Whunilh'en, nuste whe 'ukoh taba susyin 'et huwun nususti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Khuntsul lhtak'ant'i musdoos 'i tooz hail'az. Nzoo cha 'unt'oh 'ink'ez nilhk'a cha 'unt'oh, 'ink'ez nyo tl'ok'et 'et 'u'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","'Et whunilh'en, 'uyoo musdoos 'i yunilh'us. Tel'en 'ink'ez 'utsi' 'ink'ez oodanusugi, 'aw whutsoda' ndultsi'-un lhuzis'en Egypt whukeyoh 'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","'Ink'ez nyoo danusugi 'ink'ez 'utsi'-i musdoos, 'i nyoo lhtak'ant'i 'udechoo hailh'az-i nilhk'a-i ts'iyawh yan'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","'Et nyoo musdoos ts'iyawh yan'al, 'aw dune t'eooninzunne hooloh nts'en'a ts'iyawh yan'al. Whutsoda' dant'oh la, 'utsi' 'et za 'edunt'oh. 'Et ts'enuszut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","'Ink'ez cha nuste-un, khuntsul lhtak'ant'i lhes k'ut, 'ilho hanuye'-i, 'i nyus de haki tube nzoo 'ink'ez dincha cha 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","'Et whunilh'en, lhtak'ant'i nyoo mai hunuyeh-i dindat 'ink'ez ndaz nilhts'i-i be ninta 'unt'en, 'i hukwelh'az 'i haki. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Nyoo lhtak'ant'i 'utsi'-i dindat-iyaz, 'i nyoo 'udechoo lhtak'ant'i dincha-i ts'iyawh yan'al. 'Ink'ez ne'dulhdehne budasni', 'et hoonts'i 'aw daja ni whe 'utni 'aw sulhodinel.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","'Et Joseph 'en Pharaoh 'uyulhni, “Ndi Pharaoh ooghun nusinti-i, 'ilho za unli whe 'unt'oh, Yak'usda (Elohim) Pharaoh 'en wheinilhtan datinelh lah. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nyoo musdoos lhtak'ant'i nzoo-i, 'i lhtak'ant'it yus k'ut 'unt'oh. 'Ink'ez nyoo hanalhyeh-i lhtak'ant'i nzoo-i, 'i cha lhtak'ant'it yus k'ut 'unt'oh. 'I 'ilho be nusinti whe 'int'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","'Ink'ez lhtak'ant'i musdoos daningi 'ink'ez 'utsi'-i, nyoo musdoos unzoo-i yuk'elh'az too hailh'az-i, 'i cha lhtak'antit yus k'ut 'unt'oh. 'Ink'ez ndi hananyai-i lhtak'ant'i ndaz nilhtsi whe 'utsi' suli'-i, 'i cha lhtak'ant'i yus k'ut dai whutaleh-i, 'i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ndi 'i Pharaoh ooghun bulh yasduk, Yak'usda (Elohim) Pharaoh wheinilhtan datit'elh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tube lhtak'ant'it yus k'ut soo ts'iyaitsuk lhai hoonli whe 'et Egypt yun k'ut whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","'Et hoonts'i, hukw'elh'az lhtak'ant'it yus k'ut 'et dai whutaleh 'ink'ez daltsuk iloh hoonli inle', Egypt 'et dune whunaoodutilnoh 'ink'ez nyoo dai yun dulcho gak yutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Lhai hoonli-un nyo yun k'ut whunaoodutitnoh nyoo dai niz de dutizulh tube hoontsi' whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","'Ink'ez Pharaoh oonusute nat 'et hidani', Yak'usda (Elohim) 'uhoonla 'et huwa. 'Ink'ez 'atsulyaz inle' de, 'et de Yak'usda (Elohim) 'et nduwhutalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“'Et huwa Pharaoh soo dune 'unt'oh-un, whunih-un, 'en 'uhutayoolhtelh 'ink'ez Egypt yun k'ut ndulcho whe whumoodih yoolhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","'Et Pharaoh 'et doneh dune moodihne ndulcho whe yun k'ut 'et 'utahaboolelh. Ndai la 'uhuyulh'en-i, ts'iyawh ilhoh kwulai' (⅕) 'ul'en-i ts'iyawh 'ilhunahuyolelh lhtak'ant'it yus k'ut whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","'Ink'ez ndai la ut'alh-i 'i cha nyo ho hoonzoo'-un 'ulya-i, 'i ts'iyawh 'udun nehuyolelh. Pharaoh 'en whumoodih hoole', 'ink'ez ndi t'alh-i nyo ho lhelhdoh keyoh whuti, 'et az oola'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","'Et de ndi ut'alh-i 'i ts'iyawh 'et tilalh, ndet la lhtak'ant'it yus k'ut dai whutalelh, 'et wheni Egypt 'et za tilalh. Doo ka la nyo dai whuzdli' de, dune yaoodlah 'et whuch'a.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","'Et ndi khuni Pharaoh 'en ooba hoonzoo 'ink'ez yuba 'ut'enne cha buba hoonzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","'Ink'ez Pharaoh duba 'ut'enne 'ubulhni, “'Aw njan ndunt'oh-un dune naoots'olhtelh ait'oh, Yak'usda (Elohim) ooyughi bulh 'unt'oh-un?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","'Et Pharaoh, Joseph 'uyulhni, “'Et 'alha Yak'usda ts'iyawh njan whunyunilhtan. 'Aw nyun dult'ohne whunihne hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Syoh 'et ndulcho whumoodih tanleh. Nyun daja dini, whuz un'a sdune'ne cha ne'hutit'en. Njan lerwe kw'uts'uzda cho k'ususda-un, 'et 'awet za nyando 'utist'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","'Ink'ez Pharaoh Joseph 'uyulhni, “Whunilh'en, Egypt yun k'ut nduwhulcho-un 'et whumoodih tanleh nyuzusi.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","'Et Pharaoh dulasgayaz latult'o nidil'ai-i, 'i ts'ahayit'ai 'ink'ez Joseph oola 'i yuneidan'ai. 'Ink'ez soo naih dizti'-i nzoo-i be dune yulhtsi 'ink'ez gold 'unt'oh-i ulh'ool-i, 'i yuts'ilchun neidanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","'Ink'ez bulh nanki nyoo luwagin huyilh-i, chariot huyulhni, ndai la yut'i-i, 'i ye noya' yulhni, 'ink'ez ntso uyalh-un 'en dugwut nyo yuntootsih yubut 'ink'ez Egypt yun k'ut nduwhulcho whe whumoodih unli yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","'Ink'ez cha Pharaoh, Joseph 'uyulhni, “Pharaoh 'ust'oh. 'Aw nyun a'ah lhduzinih de, 'aw dune dula cha do huyolhchoot 'ink'ez duke cha do 'uhuyooleh-un hooloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","'Ink'ez Pharaoh, Joseph yoozi' yugha din'ai, Zaphnath-Paaneah yulhni. 'Ink'ez oo'at yole' ha Asenath, Poti-Phera, On whulubret ootse', 'en yugha inilhti. 'Et Joseph nyo Egypt yun k'ut ndulcho whe nuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph tat whunizyat (30) be yus k'ut Pharaoh Egypt whulerwe but inyin whe 'ink'ez Joseph nyo tenanja 'ink'ez Egypt keyoh ndulcho whe nuya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","'Et nyo lhtak'ant'it lhai hoonli, ts'iyai lhai hoonli-un 'owhuya whudizulh whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ndai la ut'alh-i Egypt yun k'ut hoonli-i, ts'iyawh nayalhdzoo, 'ink'ez keyoh whuti totsuk neininla. Ndai la hanuyeh-i cha ts'iyawh keyoh whuti totsuk 'et neininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph hanuyeh-i ut'alh-i lhai yulhtsi, yatoo taba sai k'un'a 'et 'ultsuk-i, 'udek'ez 'awet 'ulhto-un cha 'etsul 'udija 'aw yoolhto ait'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","'Ink'ez Joseph nyo dai whutaleh whutso, 'et nane duneyaz ooye' suli'. Nyoon ts'eke Asenath, Poti-Phera ootse', On bulubret, 'en yughu bulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph 'en 'udetsoh whuzdli-un, 'en Manasseh yulhni: “Yak'usda (Elohim) nts'en'a la te'iz'en 'ink'ez sba ooyoh cha whunaoodiznoh 'inka.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","'Ink'ez whulh nat ooye', 'en Ephraim yulhni: “Njan yun k'ut dzoh nusuzut inle', 'andit whe Yak'usda (Elohim) 'en sba whulai whulhtsi 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","'Et lhtak'ant'it yus k'ut ts'iyai tsuk lhai dai hooloh-un, Egypt yun k'ut 'et etsul 'uhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","'Ink'ez lhtak'ant'it yus k'ut dai hoonli-un whe' whudit'en. Joseph daja ni la whuz un'a, ndulcho whe dai whuzdli'. 'Et hoonts'i Egypt yun k'ut 'et ut'alh-i hoonli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","'Et tube 'awet Egypt dai whuzdli' whe Pharaoh 'en dune hits'un tedudlih ut'alh-i ha. 'Et Pharaoh hubulhni, “Joseph ootsohdulh. Daja nohulhni la 'et nduht'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ndi yun k'ut ndulcho whe dai whuzdli' 'ink'ez Joseph 'uzdla bayoh Egypt 'et daha'danla. 'Ink'ez Egypt whut'en ye buts'e 'ooket. Tube dai be oonujut suli' Egypt yun k'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Yun k'ut totsuk whut'enne 'enne Egypt yun k'ut whuz Joseph hits'un lhgha dindel, hanuyeh hootakulh ha. Dai cho 'i yun k'ut nduhoolhcho whe be 'uhooja 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","'Et Jacob yun k'ut Egypt 'et lhes mai' hoonli whunilh'en 'et duye' 'ubulhni, “Di ha 'ants'i lhunulh'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","'Ink'ez 'et 'utni, “Egypt 'et lhes mai' hoonli 'et whulh 'udasts'o, whuz uhdulh 'ink'ez 'et neba 'oohk'et 'et de sih ts'uhoona' 'ink'ez yats'ilhosdla.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","'Et Joseph bulhutsinke whunizyane, Egypt ts'e whenandil lhes mai' hootakulh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","'Et hoonts'i Jacob 'aw Joseph bulhutsin Benjamin, 'en 'aw bubulh whelhuyilh'alh, “Doo ka sih hoontsi'-un bulh 'uhoneh,” ni 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","'Et Israel ooye'ke whuz lhes mai' hootakulh ha whuz whehandil, Canaan 'et cha dai hoonli 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","'Et Joseph nyo usda-un dulcho whe bumoodih unli. 'En za ndi lhes mai' ye 'ooket keyoh whudune'ne ts'un. 'Et Joseph bulhutsinke whusahandil 'ink'ez hibut soo yooyo cho yo 'uhuntutsulh 'ankw'us yun nonut'a whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","'Et Joseph dulhutsinke bunilh'en 'ink'ez naboolhts'it, 'et hoonts'i t'ebunuzun hukw'un'a ne'ut'en 'ink'ez khuni ulhtus 'i be bubulh yalhduk 'ink'ez 'ubulhni, “Nts'ez de hahdil?” 'Et 'uhutni, “Canaan yun k'ut ts'e hats'andil t'alh-i ts'ootakulh ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","'Et Joseph dulhutsinke naboolhts'it 'ink'ez didut 'aw nalhuhuyoolts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","'Et Joseph nts'en'a la bughu nusuti-un 'et whunalnih 'ink'ez 'ubulhni, “Nunut'i'ne 'uht'oh! Dats'int'oh la tets'ul'en neuntilh'elh ha 'uhja, ndiz tihdil.!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","'Et 'uhuyulhni, “'Awundooh nemoodih, mba 'ut'enne njan ut'alh-i hootakulh ha 'uhuja whusahandil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ts'iyawh 'ilhoghun dune ooye'ke za 'uts'int'oh, 'aw dune 'undunut'ihne lhts'iloh. Mba 'ut'enne 'aw nulhdulh'enne iloh 'uhint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","'Et hoonts'i 'ubulhni, “'Awundooh! 'Et hoonts'i njan dats'int'oh la tets'ul'en, 'et whuntilh'elh ha 'uhja!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","'Et 'uhuyulhni, “Mba 'ut'enne 'enne whunizyane 'on 'at nane lhulhutsinke hinli. 'Ilhoghun dune za ooye' Canaan whut'en-un, 'udekoh-un 'en 'ubá yuzih netl'adida', 'ink'ez 'ilhoghun cha hooloh suli' inle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","'Et hoonts'i Joseph 'ubulhni, “Daja dusni la, 'et 'alha 'udusni, nulhdulh'enne unli whe 'uht'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Ndiz un'a 'et ootalhdzih. Pharaoh ye khuna-i njan 'aw whuch'a nalhtuzihdulh, 'udek'oh-un nohulhutsin whusainya de za. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","'Ilhoghun whuz nalh'alh 'ink'ez 'udek'oh-un nohulhutsin whusayoolhtelh. 'Ink'ez nohni 'adutilalh, 'et de nohghun ootalhdzih ts'ih'un un'a 'uduhni tilah. Pharaoh ye khuna-i be nulhdulh'enne uhli tilah 'uht'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","'Et ts'iyawh 'abanla tat dzin whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","'Et Joseph 'ubulhni whulhtat dzin-un, “'Et nduhneh 'ink'ez hoohna', Yak'usda (Elohim) be nuzjut 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ts'ih'un dunene uhli de, nohni nohtoh 'ilhoghun 'en 'adoo'a' 'ink'ez nohni lhes mai' bulh whuz nohyoh ts'e nahdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","'Ink'ez 'udek'oh-un nohulhuts'in, 'en sba whusalhtih. Nohghuni ootalhdzih 'et huwa 'ink'ez 'aw yaoohdlah ait'oh.” 'Inka 'et nduhuja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","'Et 'ulhodutni, “'Alha nek'ehoonkatne ts'inli. Neulhutsin oozul nets'utedudlih inle' 'ink'ez 'aw lhts'udits'il, 'et huwa njan nek'ehoolts'ut.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","'Ink'ez Reuben bubulh yatilduk 'ink'ez 'ubulhni, “'Aw lakw lhunodusnel inle'! ‘Ndun duneyaz oots'un ninta 'ooht'en junih!’ nohdusni, 'ink'ez 'aw lhusoozulhts'ai. 'Et huwa whunulh'en buzkaih 'awet nets'un hukwa' whutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","'Et hoonts'i 'aw t'ehonuszun Joseph t'ewhuninzun, yuba yalhduk-un 'en yuba yalhduk whe bubulh yalhduk 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","'Ink'ez buch'az nalh'a 'ink'ez intse. 'Et doo cha buts'un nalh'a bubulh yalhduk 'ink'ez Simeon yilhchoot 'ink'ez bubut 'et yulhghel ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","'Et Joseph 'ubulhni, 'uyoonne dune ndi 'e'uzdla-i ts'iyawh lhes mai' be buba idulhbun 'ink'ez ndai la hik'elha hitilhtselh-i, 'i ts'iyawh sooniya 'e'uzdla-i be nayuhdzai' 'ink'ez nahidutilyelh-i cha butl'ahle. 'Et whuz un'a 'ubinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","'Et nyoo budonkey cha ts'iyawh hit'una'uzdla lhes mai' be 'ink'ez whenahidil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","'Et nahunina 'ilhoghun nyoo 'e'uzdla-i k'unayan'uk, nyoon dughuna' yugha' ti'alh ha, nehunina-un soo 'udedo nyoo sooniya 'et usdzai yutilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","'Et dulhutsinke 'ubulhni, “Szooniya stl'anahuyan'ai, njan 'et 'unt'oh, s'ezdla-i bet! 'Et budzin soo ts'ih'un yo 'uja 'ink'ez hunilhjoot 'ink'ez 'ilhodutni “Dahoont'oh-un 'et Yak'usda (Elohim) negha oonin'ai?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","'Et Jacob dubá 'en hits'u naoosdil Canaan yun k'ut, 'ink'ez hiyulh nahoolnuk nts'oh te bubulh dahoot'en-un 'uhuyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Mbene la nyo yun whumoodih unli-un, tubeh khuni duts'un 'i be nebulh yalhduk, 'ink'ez nulhdulh'enne keyoh honilh'en ooba le'ts'int'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","'Et hoonts'i 'uts'utni, ‘Ts'ih'un dunene ts'inli, 'aw nulhdulh'enne lhts'iloh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Whunizyane 'on 'at nane lhulhutsinke ts'inli, 'ubá ooye'ke 'uts'int'oh. 'Ilhoghun hooloh suli', 'ink'ez 'udek'oh-un 'en 'ubá yuzih usda, Canaan yun k'ut 'et,’ ts'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","'Et dune nyo keyoh whumoodih unli neulhni, ‘Njan whe la tsih'un dune uhli t'eoonoohzeh, 'ilhoghun nohulhutsin njan nenulhtih, 'ink'ez ut'alh-i nohyoh ts'e t'alh-i hooloh ts'e nahlelh 'ink'ez nahdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","'Ink'ez 'udek'oh-un nohulhutsin, ndiz toolhte'. 'Et de la t'eoonooszin 'aw nulhdulh'enne lhuhloh, ts'ih'un dune uhli 'ink'ez ndun nohulhutsin nohtl'anatistelh 'ink'ez njan 'et sih 'ohket.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","'Et 'uhooja, du'ezdla-i huye ha'alhkat whe 'ilhoghun dune buzooniya yuk'elha yulhtsi-i, 'i be 'uzdla-i be yuzdzai 'et hitilh'en. Bubá cha yunilh'en. Tube hunilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","'Ink'ez Jacob bubá 'ubulhni, “Tube ts'odi suzulhtsi nohtoh. Joseph 'en hooloh suli', Simeon cha hooloh suli', 'ink'ez 'andit Benjamin 'en natilhtelh hukwa' nuhzun. 'I ts'iyawh sdach'e 'uhoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","'Et Reuben dubá yulh yatilhduk 'ink'ez 'uyulhni, “Sye'ke nahult'oh bubuzolhghelh 'aw Simeon nts'u nalhtustel de. Sla k'elhtih 'ink'ez whusunaoostelh lah.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","'Et hoonts'i 'uyulhni, “'Aw sye' nohbulh too'as ait'oh. Ndun nohulhutsin 'en dazsai. Dich'oh 'et ndun sye' hoonli bulh 'uhooja de uhdulh whe, 'et de stsi dulgi-i ts'odi bulh nyo ts'un k'ut ts'e tisyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tubeh nyo yun k'ut dai be oonisjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","'Et 'uhooja ndi lhes mai' gak huyulhtsi whe Egypt huyonket-i, bubá 'ubulhni, “Whuz nahdulh 'ink'ez 'ut'alh-iyaz oohket.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","'Et hoonts'i Judah 'en 'uyulhni, “Nyoon dune soo tsih'un negha dani' njan dune neulhni, ‘'Aw snin doo cha noolh'en ait'oh nohulhutsin nohbulh e'ust'en de.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Neulhutsin nebulh whelh'a' de, 'et de za whuz uztidulh 'ink'ez ut'alh-i mba ts'ootakulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","'Et 'aw ndun nebulh tolh'a' ait'oh de, 'aw whuz uztoodilh ait'oh. Nyoon dune njan dune neulhni, ‘'Aw snin ooh'en ait'oh noulhutsin nohbulh whusalhiyal de.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","'Ink'ez Israel 'utni, “'Et dahoont'oh huwa sdabe tank'us un'a 'usuhla nyoon dune dahni', 'awhuz 'uyoon cha nohulhutsin 'et dahni'?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","'Et 'uhutni, “Dune soo ts'ih'un neoodalhkut, wheni 'ink'ez nenatneke cha 'ink'ez 'utni, ‘Nohbá khuna eh? 'Uyoon cha eh nohulhutsin?’ 'Ink'ez 'et ts'udani'. Nts'en'a t'ets'ontazin, ‘Nyulhutsin ookwa nahdulh,’ nedutanelh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","'Et Judah, oobá Israel 'uyulhni, “Nyoon duneyaz, si stl'ailhtih 'ink'ez sih whuz naztoodilh 'ink'ez ts'uhoona'. 'Aw yats'odlah ait'oh, wheni cha 'ink'ez nyun cha 'ink'ez neuzkehkeyaz cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Si sich'oh 'et ndun ookw'edutisyalh, soo sla k'ez 'et oola dutanih. 'Et 'aw mba whusanalhustel 'ink'ez mbut nenalhustel de, 'ilhiz wheni si sk'eholts'it. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","'Et 'aw sa' nulhe'ts'it'el de, 'andit 'awet whulhnat da' whusanats'idil oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","'Ink'ez bubá Israel hubulhni, “Whuz un'a sih 'uhot'e'. 'Ink'ez nja duhneh, ndoho hanuyeh-i, mai 'uk'enus unzoo-i buba deyulhle, 'ink'ez dune oots'itilhdulh 'i cha bahlelh. Be 'uzdudultlo-i na'ulhyeh-i, ntsool-iyaz cha, 'ink'ez ts'ihna tl'uz ntsool-iyaz cha bulh buta'whut'en-i cha 'ink'ez myrr huyulhni, 'i cha, 'ink'ez duchun k'ut hanuyeh-i pistachio 'ink'ez almond huyulhni, 'i cha ooba yihlelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Sooniya nawh 'uniltsuk-i, 'i toohdzaih 'ink'ez nyoo sooniya nohba denahuyandzai inle'-i, 'i cha toohdzaih, nahunit'a whutilah 'uhuja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Nohulhutsin cha nohbulh too'as. Dugw'e' duduhdilh 'ink'ez dune oots'u nahdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","'Ink'ez Yak'usda 'Uk'enus 'Ultus-un 'unt'oh (El Shaddai), 'en nohgha te'nozeh nyoon oobut. 'Ink'ez si 'ilhoghun nohulhutsin 'en cha yuladootnih 'ink'ez Benjamin. 'Et 'awet ts'odi susli' de, 'awet ts'odi susli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","'Et nyoonne dune nyoo hits'u hitilhdulh-i cha 'ink'ez Benjamin cha, 'en cha hubulh tiz'az, sooniya nawh 'uniltsuk-i cha, 'ink'ez Egypt ts'e whehandil. 'Ink'ez Joseph hibut nenindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","'Et Joseph, Benjamin bubulh nu'as yutilh'en whe nyoon ooyoh huwunli-un 'uyulhni, “Ndunne dune syoh ts'e hubulh in'us, 'ink'ez khuna-i nasilghe 'ink'ez lhadinleh. Dzetniz 'et ndunne dune sulh na'hutit'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","'Et dune Joseph daja yulhni la whuz un'a 'uja. 'Ink'ez nyoonne dune Joseph ooyoh ts'e dabuninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","'Et nyoonne dune whehunuljut, Joseph ooyoh ts'e dabunila, 'ink'ez uhutni, “Nyoo sooniya 'i k'a la ne'inla ne'uzdla-i be nahuyandzai-i 'udechoo njan daneuninla. Nech'az nedutadalh-un 'et hukwunuta 'ulhnane k'un'a neutalhchulh nyoo ghuna', donkey cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","'Et nyoon Joseph buyoh whumoodih yuzih nenindil nyo dati 'et hiyulh yailhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","'Et 'uhiyulhni, “O dune ncha-un, 'alha 'udecho whusats'andil whe ut'alh-i ts'ootakulh ha' ts'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","'Et 'uhooja, nenats'untatus naztisdil whe ndi 'e'uzdla-i ookw'unats'un'uk 'ink'ez 'ilhoghun ts'inli whe nezoonuya' nyo 'ezdla-i be yuzdzai whe, 'inka ndi sooniya whusanats'andzai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","'Ink'ez 'uyoo sooniya cha whusats'an'ai, 'ut'alh-i be ts'ootakulh ha. 'Aw t'ets'onuszun mbe subah nyoo sooniya ne'ezdla-i be nayandzai.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","'Et hoonts'i 'utni, “Nohbulh whudoghel. 'Aw whenulhjut iloh. NohYak'usda (Elohim) 'en nohbá ooYak'usda (Elohim) ndi 'en noh'ezdla-i ye yan'ai whe 'unt'oh. Nohzooniya nus'a whe.” 'Ink'ez Simeon butl'anayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","'Et ndun dune Joseph ooyoh dabuninla, 'ink'ez too bugha nilhdzo 'i be duke tanahuzguz 'ink'ez bughuna' cha yutl'a'dantsut. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","'Ink'ez nyoo Joseph hits'u hitilhdulh-i lhahidinla, dzetniz wheni nyo 'et ut'alh-i nahutit'ulh 'et t'ehonanzin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","'Et Joseph duyoh dananja whe nyoo hits'u hitilhdulh-i hitl'ahuyanla, 'ink'ez hibut yo huntizsel soo yun whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","'Et dahint'oh lah 'et hukwa boodulhkut 'ink'ez 'utni, “Nohbá soo 'unt'oh eh, duneti ooghu yalhduk-un, 'awhuz eh khuna?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","'Et 'uhuyulhni, “Mba 'ut'en-un nebá tube soo 'unt'oh. 'Awhuz khuna.” 'Ink'ez yubut yo 'untizsel 'ink'ez nyo na'hududilhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","'Et ndo yutan'en 'ink'ez dudulhutsin Benjamin yutilh'en, ooloo ooye', 'ink'ez 'utni, “Ndun 'en 'udek'oh nohbulhutsin, ooghun sulh yalhduk inle'?” 'Ink'ez 'utni, “Yak'usda (Elohim) soo cho nts'un oozoo' sye'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","'Et oodzi tubeh dulhutsin yuk'eni unli 'ink'ez 'uts'un whenaja soo 'a cho. 'Ink'ez 'et whenintse, 'ink'ez usti ts'e whuz dananja 'ink'ez 'et utso. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","'Et nena'nilde 'ink'ez tenanja 'ink'ez k'oh 'ududootun 'ink'ez 'utni, “Ut'alh-i 'et nenuhle bubut neinuhle.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","'Et didutch'oh 'uti'ulh-un hiba ne'ninla, 'ink'ez nyoonne cha didutch'oh 'et 'uhuti'ulh-un buba ne'ninla. 'Ink'ez Egypt whut'enne 'enne cha didutch'oh duba ne'huninla. 'Aw Egypt whut'enne, Hebrew whut'enne 'aw bubulhe'hus'al, Egypt whut'enne buba hoontsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","'Et hibut natl'adilts'i'. 'Udetso whuzdli-un, 'udechoo 'ink'ez 'udek'oh whuzdli-un, 'en 'udek'ez, 'ink'ez nyoonne dune tube buba hooncha lhonul'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","'Et ts'iyawh bubut ne'ninkai, 'et hoonts'i Benjamin yuba deyanla, 'i kwulat 'i be 'onus 'ultsuk, 'i yugha inin'ai. 'Ink'ez too hitnai' 'ink'ez hiyulh whunalhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","'Ink'ez nyoon duyoh whumoodih unli-un 'en 'uyulhni, “Dune ts'iyawh 'ezdla-i ut'alh-i buba idilhbun, soo nahitilelh-un 'et 'uldaz-i, 'ink'ez sooniya huye huyonket, 'i cha 'ezdla-i buba denayin'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","'Ink'ez slubot silver 'unt'oh-i, 'i 'udek'oh-un 'en 'ezdla-i ooba deyin'aih, 'ink'ez lhes mai' huye onket-i cha buba denayin'aih.” 'Et daja Joseph yulhni la, whuz un'a 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Soo bundada' yulhkai 'et 'awet dune whenabuhalh'a' dudonkey tucha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","'Et nyo keyoh whuti 'awet whan'unyaz hanahidil, 'et Joseph nyoon yuba 'ut'en-un 'uyulhni, “Dudinyai', nyoonne buba nanyalh 'ink'ez but'asinya de, 'et 'ubudini, ‘'Et di ha hoonzoo-un 'et hoontsi' hukw'un'a kw'elha whuzulhtsi? ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ndi lubot 'i iloh eh smoodih ye 'utnai-i 'ink'ez 'i be nus whunilh'en yutnai te? Hoontsi' hukw'un'a uhja 'et dahja.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","'Et butasuya 'ink'ez ndi khuni 'i be bubulh yailhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","'Ink'ez 'uhuyulhni, “'Et di ha smoodih ndi khuni 'i be nebulh yailhduk? 'Aw mba 'utenne 'aw whuz un'a ndulhuts'ut'en whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nilh'en ndi sooniya yun k'ut Canaan ts'e ha nats'andzai, ne'ezdlai-i bet nats'in'ai'-i. Nts'en'a silver k'us gold bulh 'i nemoodih ooyoh 'et ts'uduntit'ih? ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Mbe la mba 'uten-un ooghu nayinla-un de, 'en daootsah 'ink'ez wheni cha nemoodih be 'ulhna ts'ooleh sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","'Ink'ez 'utni, “'Et daja duhni la, mbe ooch'e' toh nats'inla de, 'en si se'ulhna tileh 'ink'ez nohni 'aw nohk'elhoowhutalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","'Et soo 'a cho 'et 'ilhone hinli ndai la be 'uzdla-i yun nahuyanla 'ink'ez hik'una'an'uk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","'Et nyoon dune 'udetso whudilhdzulh-un, 'en ooch'e' 'i cho yet nuniztai, 'udek'oh-un whuts'un, 'ink'ez nyoo lubot 'i Benjamin oo'ezdla-i bet nayin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","'Et dunaih ye yidalhch'ul 'ink'ez nyoo dudonkey hik'ena 'inla, 'ink'ez keyoh whuti ts'e nahoosdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","'Et Judah 'ink'ez dulhutsinke Joseph ooyoh ts'u nahoosdil, 'awhuz 'et 'ut'en, hibut 'et yun nachaniti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","'Ink'ez Joseph 'ubulhni, “Dant'i 'ut'en i' 'uhla? 'Aw eh t'eoonuzuhzun dant'oh-un 'ust'oh, 'en dune nus whunilh'en whe 'unt'oh t'eooninzin!” ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","'Et Judah 'utni, “Nemoodih daja uzdutanelh? K'us nts'en'a 'aw nek'elhuholhts'it hukw'un'a na'ts'uhooleh? Yak'usda (Elohim) mba 'ut'enne 'ut'en nts'ih-i bulh nabinla. Njan nuzdilhya, moodihti be 'ulhna wheni cha 'ink'ez mbe ndi lubot oo'ezdlai-i be yuz'ai 'en cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","'Et hoonts'i 'utni, “'Aw 'et ndosneh ait'oh. 'Et hoonts'i mbe slubot nuyu'a-un, 'en se'ulhna tileh. 'Et nohni, nohdzi whudooghel whe nohbá oots'u nahdulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","'Et Judah yuzih neninya 'ink'ez 'utni, “'Aw smoodihti si mbut yatisduk 'et sgha oonin'aih, 'ink'ez be hunilch'e-i mba 'ut'en-un bulh hunolch'eh junih. Pharaoh dilt'oh whe 'int'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Smoodih mba 'ut'enne budini, ‘Nohbá hoonli k'us nohulhutsin?’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","'Et nemoodih 'uts'utni, ‘Nebá hoonli, duneti 'ink'ez duneti suli' whe ooyaz whuzdli', ts'oodun unli, 'en bulhutsin dazsai, 'ink'ez ndun ts'oodun ooloo buzkeh 'enne didutch'oh gaih 'unli, 'ink'ez oobá yuk'entsi.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","'Et mba 'ut'enne 'ubudini, ‘Ndiz sts'olhtelh. Noos'en sih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","'Et smoodihti 'uts'utni, ‘'Aw ndun duneyaz dubá yuch'a ooya' ait'oh. Dubá yuch'a suya de, oobá datitsah.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","'Et hoonts'i mba ut'enne 'ubudini, “Ndun 'udek'oh-un nohulhutsin, 'aw ndiz lhtulhtel de, 'aw snin 'aw naooht'en ait'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","'Et whuz un'a mba 'ut'en-un oozih neznindil, 'ubá 'ink'ez daja dini la, nemoodih inli uzdani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","'Ink'ez 'ubá 'une'ulhni, ‘Whuz nahdulh 'ink'ez ut'alh-iyaz oohket.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","'Et hoonts'i 'uts'utni, ‘'Aw whuz naztoodilh ait'oh, 'udek'oh-un neulhutsin nebulh 'ut'en de, 'et de za whuz naztidulh. 'En ooyit de 'aw nyoon dune oonin nalhts'utist'el.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","'Et mba 'ut'en-un, 'ubá 'une'ulhni, ‘T'eoonuhzun s'at nane dune sghu sulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","'Ink'ez 'ilhoghun 'en sgho whenya 'ink'ez 'udusni, “'Alha la yabe' yudalhch'ul.” 'Et whuts'un 'aw nalhuzist'en. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","'Et hoonts'i ndun 'en cha sghulhchoot de, 'ink'ez hoonli hoonts'i-un bulh 'uhooja de, ndi sts'egha' dulgi-i ts'odi be nyo ts'un k'ut ts'e tisyalh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","'Et huwa mba 'ut'en-un, hukwa ndun ts'oodun 'aw nebulh lhe'ust'en, tube nzih utitelh-un hukwa' ninzun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","'Et 'uwhutanelh, ndun dune-un nebulh lhe'ust'en de, datitsah. 'Et mba 'ut'enne, wheni gha, mba 'ut'en-un nebá, 'en ootsigha' dulgi suli' k'et ts'un k'ut ts'e tiyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","'Et ndun mba 'ut'en-un, ndun duneyaz yuk'edanya whe 'unt'oh. ‘'Aw whusanalhustel de, 'en sbá ghun 'ilhiz sk'ewhutalts'ulh whe' hoont'oh,’ dasni'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","'Et huwa si nyo ndun duneyaz 'en ook'et nye'usna oosle', 'ink'ez nyoon duneyaz dudulhutsinke bubulh natoot'as. ");
INSERT INTO crxNTpo_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","'Et huwa nts'en'a suba, sbá oots'u toosya' ndun duneyaz sulh lhe'ust'en de, 'et sih ntis'elh dawhultsi' lah sbá ook'ewhutalts'ulh 'et huwa?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","'Et Joseph 'aw 'on 'un 'oodudotun ait'oh, nyoonne yunat nudilhyane bunalh, 'ink'ez 'udija, “Ts'iyanne n'az nahutoodilh!” 'Et Joseph nyoonne dudulhutsin mbe 'unt'oh-un hubudani'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","'Ink'ez soo 'ultus-un intse 'ink'ez nyoonne Egypt whut'enne 'ink'ez Pharaoh ooyoh cha ts'iyawh whulh hidants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","'Et Joseph bubulhtsinke 'enne 'ubulhni, “Si Joseph 'ust'oh. Sbá 'awhuz eh khuna?” 'Et hoonts'i bulhutsinke 'aw hiyulh yatoolhdih ait'oh. Whuz tube buba nek'e'hoonil k'et. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","'Et Joseph dudulhutsinke 'ubulhni, “'Anih szih nenuhdilh. 'Ink'ez hizih nenindil 'ink'ez 'utni, “Joseph 'ust'oh! Nohulhutsin Egypt ts'e be 'ohk'et inle'-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","'Ink'ez 'andit nohdzi undooda' k'us dulh nahunolhch'eh junih. Njan se'ohket 'et huwa, Yak'usda 'en ndiz sutilh'a' dune yalhosdla ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Nat yus k'ut whuts'un njan dai hone'. 'Awhuz kwulat yus k'ut 'et 'aw dune 'a' noolelh cha ait'oh, ha' hunoolelh cha ait'oh tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","'Ink'ez Yak'usda (Elohim) nohtso ndiz whe salh'a', Ndi yun k'ut nohts'u haindene huhoona, 'aw dalhuhoosa. Hooncha whe bula'tinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","'Et 'andit nohni iloh ndiz whe silh'a'. Yak'usda (Elohim) 'en Pharaoh cha oobá sulhtsi 'ink'ez ooyoh cha whumoodih usli. 'Ink'ez Egypt yun k'ut ndulcho whucha whumoodih usli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Soo 'a 'ink'ez 'ubá oots'un nahdulh 'ink'ez 'uduhni, ‘Nye' Joseph 'utni, “Yak'usda (Elohim) 'en Egypt whumoodih sulhtsi. Ndiz sts'inyalh, sa' 'ont'en junih! ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Njan Goshen yun k'ut 'et sih hont'e'. Soo szih 'utant'elh, nyun cha 'ink'ez nyuzkeh cha, nyuzkeh bubuzkeh cha, nghuna', 'usbai bulh cha 'ink'ez ndai int'i ts'iyawh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","'Et njan ookw'ut yinka dutalhts'ilh-i 'i nohgha tis'aih doo ka sih nyun cha 'ink'ez nyoh dilhts'ine cha, ndai int'i-i cha telh'en oole' 'awhuz kwulat yus k'ut dai whutaleh whe' hoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","'Ink'ez whunilh'en nohna cha 'ink'ez sulhutsin Benjamin oona be nanulht'oh sze 'uwhutni, nohbulh yasduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","'Et de sih 'ubá dast'oh la njan Egypt dust'i', ndet hooh'en-un cha 'ink'ez soo 'a 'ubá ndiz ulhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","'Et dulhutsin Benjamin yuts'ilchun k'et yilhchoot 'ink'ez intse 'ink'ez Benjamin cha yuts'ilchun k'ut 'et intse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","'Et 'on 'un cha dulhutsinke ts'iyawh nabuditsooz 'ink'ez bughintse. 'Et hukw'elh'az bulhutsinke yulh yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","'Et ts'iyawh dawhudani' lah Pharaoh ooyoh bulh 'uhudantso 'ink'ez 'uhutni, “Joseph bulhutsinke whusahandil,” 'ink'ez Pharaoh cha 'ink'ez yuba 'ut'enne cha ts'iyawh huhoont'i. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","'Ink'ez Pharaoh Joseph 'ulhni, “Nyulhutsinke budini, ‘Nohghuna' buna'ilhghelh 'ink'ez nahdulh Canaan yun ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Nohbá ndiz ulhtelh 'ink'ez nohyoh whut'ine cha, ts'iyawh ndiz sts'un uhdulh. Ndai la k'us unzoo-i njan yun Egypt 'i si nohgha ooslelh 'ink'ez njan yun k'ut whuk'o, 'i sih ooh'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","'Et whuz un'a khuni mba 'ulya, 'et dineh, ‘Njan Egypt yun k'ut mbene 'ulgoo-i ts'iyawh ilhchoot. Nohuzkehyaz 'ink'ez noh'atke cha 'ink'ez nohbá cha 'ink'ez whusahdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","'Ink'ez ndai la njan uht'i-i ooghuni oohle' junih. Ndai la Egypt yun k'ut 'uk'enus nzoo-i, 'i nohch'e 'unt'oh.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","'Et Israel ooye'ke 'et nduhuja, 'ink'ez Joseph be ne'ulgoo-i cha ts'iyawh butl'ayanla. Daja Pharaoh daja yulhni la hukw'un'a 'ink'ez nuhudilh-un hiti'ulh-i cha butl'anayanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ts'iyawh 'ilhoghun hinli whe naih lhk'enahidutilelh-i cha 'ink'ez Benjamin 'en tat whunizyai tat 'ultsuk-i (300) 'i silver yugha inindzai, 'ink'ez kwulat k'enaidutilelh-i naih, 'i cha yugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","'Ink'ez dubá 'en ndi donkey 'i yuts'otl'ayanla, whunizyai donkey, Egypt ndai la unzoo-i ts'yawh 'i hik'enahuyinla, 'ink'ez whunizyai ts'eke donkey, 'i cha lhes mai' cha, lhes cha 'ink'ez ut'alh-i cha, oobá yuti'ulh ha cha, ndiz nahatidulh huba, 'i hik'enahuyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","'Et dudulhutsinke whenabalh'a 'ink'ez whenahidil 'ink'ez 'ubulhni, “Khun te nyo nuhdil whute dzoh nohdeh junih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","'Et Egypt whenahidil 'ink'ez Canaan yun k'enahidil, dubá Jacob 'en oots'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","'Ink'ez hidani', “Joseph 'awhuz khuna 'ink'ez Egypt yun k'ut ndulcho whe moodih unli.” 'Et Jacob oodzi 'ankw'us 'etsul 'uja, 'aw hiba 'alha lhe'dusnih 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","'Et Joseph daja hubulhni la hidani', 'ink'ez nyoo be ne'ulgoo-i cha hinilh'en Joseph buts'o tl'ayanla-i, 'et Jacob ooyughi ndo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","'Et Israel 'utni, “'Awet soo' hooja. Sye' Joseph 'awhuz khuna, whuz toosya ink'ez sih naoost'en datisah whutso.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","'Et Israel ndai la yut'i-i tubulh tizya, Beersheba keyoh ts'e oozya 'ink'ez oobá Isaac ooYak'usda (Elohim) ts'un khuna-i dalhk'un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","'Et Yak'usda (Elohim) 'en Israel 'ulhdzis yunalhts'et hainya 'ink'ez 'utni, “Jacob, Jacob” ni, 'et 'uyulhni, “Njan 'ust'oh”. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","'Ink'ez 'utni, “Yak'usda (El) 'ust'oh, mbá ooYak'usda (Elohim). 'Aw wheniljut whe Egypt ts'e tonya' junih, nyun tube didoh-un ncha-un 'et nyutiselh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Egypt ts'e nyulh 'utisnelh 'ink'ez ndo na'nyutislelh. 'Ink'ez 'alha Joseph 'en nyuna k'edutalni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","'Et whe Jacob 'en Beersheba 'et dudinya, 'ink'ez Israel whuye'ke 'en hube 'ubá whuz hitilhti, bubuzkehyaz cha, 'ink'ez bu'atke cha, 'en ndi nulbas be buhanla, 'i Pharoaoh hubuts'otl'ayanla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","'Ink'ez khuna-i cha 'ink'ez ndai la huyut'i-i cha, Canaan bugha ininkat-i, 'i tubulh Egypt ts'e whehandil, Jacob 'ink'ez ts'u haindene bubulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ooye'ke 'ink'ez ooye'ke 'on 'un ooye'ke, ootse'ke 'ink'ez buye'ke butse'ke, ts'iyawh Egypt ts'e boozdla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","'Et ndi Israel buzkeh buboozi': Jacob ooye'ke, 'ink'ez Egypt ts'e whendilne, Reuben 'en 'udetso ooye', Jacob ooye'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben ooye'ke 'enne: Hanock, Pallu, Hezron 'ink'ez Carmi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ooye'ke 'enne: Jemuel, Jamin, Ohad, Jachin, Zohar 'ink'ez Shaul, Canaan whut'en-un ts'eke ooye'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ooye'ke 'enne: Gershon, Kohath 'ink'ez Merari. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah ooye'ke 'enne: Er, Onan, Shelah, Perez 'ink'ez Zerah ('et hoonts'i Er 'ink'ez Onan bulh 'enne Canaan keyoh dahuzsai). Perez ooye'ke 'enne: Hezron 'ink'ez Hamul bulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar ooye'ke 'enne: Tola, Puvvah, Iob 'ink'ez Shimron. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun ooye'ke 'enne: Sered, Elon 'ink'ez Jahleel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ndunne Leah ooye'ke, 'enne Jacob ghu bulhts'i Paddan Aram ts'e. Ootse' Dinah, 'en cha. Mbene la ooye'ke 'ink'ez oots'eke cha tat whunizyai 'on 'at tane (33) hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ooye'ke 'enne: Zipheon, Haggi, Shuni, Ezbon, Eri, Arodi 'ink'ez Areli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher ooye'ke 'enne: Imnah, Ishvah, Ishvi, Beriah 'ink'ez Serah bubulhtus. 'Ink'ez Beriah ooye'ke 'enne: Heber 'ink'ez Malchiel. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ndunne 'enne Zilpah ooye'ke: Laban, Leah dutse' gha inilhti, 'en Jacob ghu bulhtsine whunizyane 'on 'at lhk'utane (16) hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Rachel ooye'ke, Jacob oo'at: Joseph 'ink'ez Benjamin. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","'Et Joseph oots'un keyoh Egypt hooni, 'enne Manasseh 'ink'ez Ephraim. 'Enne Asenath Poti-Pherah whutse', keyoh On lubret, 'en buzkeh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin buzkeh 'enne: Bela, Becher, Ashbel, Bera, Naaman, Ehi, Rosh, Muppin, Huppim 'ink'ez Ard. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ndunne 'enne Rachel ooye'ke, 'alhgoh whunizyane 'on 'at dine (14), 'en Jacob ghu bulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ooye' 'en Hushim huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naphtali ooye'ke 'enne: Jahzeel, Guni, Jezer 'ink'ez Shillem. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ndunne 'enne Bilhah ooye'ke, 'en Laban ootse', Rachel, gha inilhti, 'en ndunne Jacob ghu bulhtsi lhtak'ant'ine hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","'Et Jacob yulh whendilne Egypt ts'e, ts'iyawh hits'u hainde, Jacob ooye'ke, bu'atke, 'aw 'enne iloh, 'alhgoh lhk'utat whunizyai 'on 'at lhk'utane (66) hinli ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","'Ink'ez Joseph ooye'ke, Egypt 'enne nane hinli, Jacob bulh whusahandilne Egypt ts'e hoozdil whe lhtak'ant'it whunizyane (70) hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","'Et Judah 'en butso yutilh'a' Joseph ts'un nts'e la Goshen ts'e whuz'ai 'ink'ez Goshen yun k'uz ts'e hoozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","'Et Joseph nyoo ye nuya-i, 'i lhaidinla, 'ink'ez Goshen ts'e whenya, dubá Israel yudutizya 'ink'ez yubut neninya. 'Ink'ez yuts'ilchun k'et yuk'ilhts'ut 'ink'ez sa' whe 'et yuts'ilchun k'et intse. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","'Ink'ez Israel, 'en Joseph 'uyulhni, “'Awet whute daoosah-un sgha oonin'aih, nyunin us'en 'awhuz khina 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","'Et Joseph dulhutsinke 'ink'ez dubá ooyoh dilhts'ine cha 'ubulhni, “Toozya' 'ink'ez Pharaoh dosni', njan dudoosni' sih, ‘Sulhutsinke 'ink'ez sbá ooyoh dilhts'ine cha, Canaan huwhut'ine sgho nindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","'Ink'ez dune 'enne 'usbai ghunline, whuz un'a khuna-i gha 'aihne hinli, 'ink'ez dughuna' cha ts'iyawh ndai la huyut'i-i cha ts'iyawh sahuyanla.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","'Et 'uhoneh Pharaoh nohkahizya 'ink'ez 'utni de, ‘Dahoont'oh-un la huwahna?’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","'Et 'udoohni', ‘Mba 'ut'enne bube 'ut'en dak'ez whuts'un, khuna-i gha hana ts'oodunne ts'inli whuts'un 'andit whuts'un, wheni cha 'ink'ez netsoda' nebáke 'enne cha.’ 'Et de sih ndi yun k'ut Goshen yun k'ut hooht'e', 'usbai ghunline ts'iyawh 'ilhoghun hinli whe Egypt whut'enne buba' huninzun 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","'Et Joseph Pharaoh ts'u whenya 'ink'ez 'uyulhni, “Sbá 'ink'ez sulhutsinke, bughuna' te 'ink'ez ts'iyai huyut'i-i cha, Canaan ts'e hahandil 'andit Goshen yun k'ut 'uhint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","'Ink'ez kwulane dudulhutsinke 'enne butizdla 'ink'ez Pharaoh ghu buninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","'Et Pharaoh bulhutsinke 'ubulhni, “Ndet la huwahna?” 'Et 'uhuyulhni, “Mba 'ut'enne, 'usbai ghunline ts'inli, wheni cha 'ink'ez nebákene cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","'Ink'ez cha Pharaoh 'ubulhni, “Ndi yun k'ut ts'otit'elh ha whusats'andil. Mba 'ut'enne 'aw bughuna' yoo'alh-i hooloh Canaan yun k'ut dai tube 'uja, 'et huwa mba 'ut'enne Goshen yun k'ut huhoot'en-un 'et negha oonin'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","'Et Pharaoh, Joseph bulh yalhduk 'ink'ez 'utni, “Mbá 'ink'ez nyulhutsinke ngho nindil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egypt yun k'ut mbut whuz'ai, mbá 'ink'ez nyulhutsinke 'uk'enus ndi yun unzoo-i Goshen yun k'ut, 'et huwhutit'elh. 'Et 'enne butoh soo 'uk'enus ts'ih'un ne'ut'en-i 'ink'ez 'uyoo unline, 'enne butoh hoonli de, 'enne ndi sghuna', ts'iyawh himoodih oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","'Et Joseph dubá Jacob sayalhti 'ink'ez Pharaoh yubut neinilhti, 'ink'ez Jacob Pharaoh soo hoonzoo-un oots'un tizoo' yuba tenadidli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaoh Jacob yoodulhkut, “Dawhultsuk nyeyus k'ut?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","'Et Jacob 'en Pharaoh 'uyulhni, “Sunawhudizut whe dzin whe lhususya, 'et 130 nawhudizut. 'Aw whulai iloh 'ink'ez hoontsi' whe nawhudizut whudzin whe syust'e 'ant'e'. 'Et hoontsi 'aw sbáke ndi yun k'ut nuhuzdil-un ndoh whulhdzoh ilhoh 'et khisna'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","'Et Jacob, Pharaoh 'uk'enus soo hoonzoo-un ubulh yalhduk 'ink'ez yughu tenanja. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","'Ink'ez Joseph, dubá 'ink'ez dulhutsinke Egypt yun ooloh 'i bugha inin'ai, soo 'uk'enus hoonzoo-un, Rameses whuyun k'ut 'et, Pharaoh daja yulhni la, whuz un'a. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","'Et Joseph dubá 'ink'ez dulhutsinke 'ink'ez mbene la buyoh whut'ine cha, lhes dawhultsuk huwa 'i bugha ininla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","'Et 'aw njan yun k'ut ut'alh-i hooloh, tube dai be oonisjoot 'et huwa. Egypt yun k'ut cha 'ink'ez Canaan yun k'ut cha tube tehul'en ndi dai 'i gha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","'Ink'ez Joseph ndai la Egypt sooniya, ts'iyawh nayalhdzoo. Canaan yun k'ut cha ndai la lhes hanuyeh-i huyonket-i, 'ink'ez ndi Joseph, Pharaoh ooyoh ts'e wheyan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","'Et Egypt yun k'ut cha sooniya hooloh Canaan yun k'ut cha sooniya hoolel. 'Et Egypt whut'enne ts'iyawh Joseph highu nindil 'ink'ez 'uhutni, “Lhes negha nin'aih. Diha 'et nyunalh yats'itadlah? Sooniya gak suli' 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","'Et Joseph 'utni, “Nohghuna' 'et nenuhle 'ink'ez 'i k'elha sih ut'alh-i nohgha ooslelh, sooniya hooloh suli' de.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","'Et dughuna' ts'iyawh Joseph highu hininla 'ink'ez Joseph ut'alh-i bugha ninla ndi yeztli khuna-i te, budonkey te, ts'iyawh, 'i k'elha lhes huyu'alh-i bugha ininla, ndi khuna-i ts'iyawh 'et nawhudizut whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","'Et nawhudizut whe 'on 'at yus k'ut 'et 'uhuyulhni, “'Aw nemoodih nch'a nuznoot'i' ait'oh, nezooniya' gak whuzdli'. Ndai la khuna-i ts'ut'i-i ts'iyawh nemoodih nyun za int'i suli', 'aw neyun k'ut 'aw hoonli ngha ts'oolelh-i hooloh, neyust'e' 'ink'ez neyun bulh za 'et neninkat. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","'Et di ha nenilh'en whe yats'itadlah, wheni 'ink'ez neyun bulh cha neoonk'et 'ink'ez neyun cha oonk'et lhes k'elha. 'Ink'ez wheni 'ink'ez neyun bulh 'et sih Pharaoh ba 'ut'enne ts'oole'. 'Ats'untilelh-i negha ninle, 'et de la ts'ukhoona' 'ink'ez yalhits'osdla, 'et de ndi yun 'aw gak uztisle.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","'Et Joseph Egypt whuyun ts'iyawh ndulcho whe Pharaoh ba yonk'et. Egypt whut'enne dune ndai la yun huyut'i, ts'iyawh huye 'onket tubeh dai be oonujut huba suli'. 'Et huwa 'et ndi yun ts'iyawh Pharaoh ooch'e' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","'Et nyoonne dune 'enne ts'iyawh keyoh whuti ts'e nebuninla, Egypt keyoh nduwhulcho whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mbene la lubret unline, 'enne buyun 'i za 'aw lhuyookulh. Pharaoh 'uda' butl'a'dantsut, 'et huwa nyoo butl'aidantsut-i, 'i huyu'alh, 'et huwa duyun 'aw huye lhe'ookulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","'Et Joseph dune 'ubulhni, “Nohyun ts'iyawh osket. 'Andit dzin Pharaoh ba whunulh'en ndi 'antilelh-i nohba hooni, 'i sih yun k'ut 'anoolelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","'Et de si ha'nule de (⅕) ndai la 'anihla-i, 'i Pharaoh oogha yohlelh. (⅘) 'i nohch'e' tileh, 'antilelh wheni 'ink'ez tih'ulh-i wheni cha, mbene la nohyoh whut'ine 'ink'ez nohuzkehkeyaz ba cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","'Et 'uhutni, “Be ts'ukhuna-i silhyih. Nemoodih ba soo ts'inzoo ts'oole' 'ink'ez ba 'ut'enne ts'oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","'Ink'ez Joseph 'i khuni yulhtsi, Egypt yun k'ut wheni 'andit dzin whuts'un Pharaoh 'en (⅕) 'i ooch'e' yutaleh, lubretne buyun 'i ooyit, 'i 'aw Pharaoh ooch'e' lhilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","'Et Israel, Egypt yun k'ut 'et hit'e', keyoh Goshen huwhutni-un 'et hoot'e', lhai huyut'i-i 'ut'i suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","'Ink'ez Jacob Egypt yun k'ut 'et whut'i, whunizyai 'on 'at lhtak'ant'it (17) yus k'ut. Jacob ndi yun k'ut inda', 'et 147 yus k'ut 'et hoot'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","'Et 'awet Israel datitsah whenghoh neooninzut, duye' Joseph 'anih yudani' 'ink'ez 'uyulhni, “'Alha mba uszoo nahoon'ai de, nla swuz t'oh nedilnih 'ink'ez soo cho ne'solh'en, 'aw Egypt 'et 'asolhtelh junih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","'Ants'i sbáke 'enne bubulh 'oost'e'. Egypt whuch'a nasolhtelh 'ink'ez la 'ahudinla-un 'et 'asoltelh.” 'Et 'uyulhni, “Daja dini-un 'et si ndosneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","'Ink'ez 'utni, “Sts'u nahinyeh.” 'Ink'ez yuts'u nahizya. 'Et Israel tse nilh'al-un hukw'ut 'et yo nenint'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","'Et hukw'elh'az njan duhooja whe Joseph 'uhuyulhni, “Mbá nduda,” 'ink'ez duye'ke nane Manasseh 'ink'ez Ephraim 'enne hubilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","'Ink'ez Jacob huyulhni, “Whunilh'en nye' Joseph nts'un tizya.” 'Ink'ez Israel do 'uja 'ink'ez lili k'ut ndo netl'adinda'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","'Et Jacob, Joseph 'uyulhni, “Yak'usda 'Uk'enus 'Ultus-un 'ust'oh (El Shaddai) snalhts'et hainya Canaan whu yun k'ut Luz whe 'ink'ez soo hoonzoo-un sts'un tizoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","'Ink'ez 'usulhni, “Whunilh'en lhane nts'u hatidoh dune lhane whe nts'u hahutidoh, 'ink'ez ndi yun 'i nts'u haindene nk'elh'az de 'ilhiz wheni bugha itas'alh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","'Andit 'et nane nye'ke Ephraim 'ink'ez Manesseh, Egypt 'et nyuzkeh huzdli', nghu tisyalh whutso 'enne sch'e 'uhint'oh. Reuben 'ink'ez Simeon bulh buk'un'a sch'e' hutileh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Nyuzkeh njan hukw'elh'az nyuzkeh hutilehne, 'enne ndunne dudulhutsin be nabootanzi, ndai la buch'e' yutaleh-i 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","'Et si keyoh Padden ts'e hasya, Rachel szih 'et Canaan yun k'ut dazsai, ts'idulh whe keyoh Ephrath 'awet nilhduk suli' whe 'et, 'ink'ez Ephrath ts'u ti (Bethlehem ts'uwhutni-un) 'et 'asti.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","'Et Israel, Joseph ooye'ke bunilh'en 'ink'ez 'utni, “Ndunne 'enne mbene whe' hint'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","'Ink'ez Joseph dubá 'ulhni, “Sye'ke 'uhint'oh. Njan yun k'ut Yak'usda (Elohim) sgha bunilhtine.” 'Ink'ez 'utni, “De' ndiz sts'u bilhtelh 'ink'ez si soo hoonzoo-un buts'un tiszoo'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","'Ink'ez Israel oona 'awet njan be tetsun suli' tube hoonyan 'et huwa 'aw soo cho lhubis'en. 'Et Joseph hizih nebunilhti 'ink'ez nabudits'ooz 'ink'ez bubontun. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","'Ink'ez Israel, Joseph 'ulhni, “'Aw nyunin ntis'elh 'aw huwuni lhnuzuszut, 'et hoonts'i 'alha Yak'usda (Elohim) nyuzkeh bubusunilhtan.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","'Et Joseph dugwut zih uzyin whuz de habalhti 'ink'ez soo yun ts'e nenint'ai yubut nachaninti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","'Ink'ez Joseph nahult'oh hubilhchoot, Ephraim 'en nailhnih ts'unk'us yilhchoot, Israel 'intl'us ts'e oola ts'un 'ink'ez Manesseh 'en 'intl'us ts'e dula be Israel nailhnih ts'unkus hubilhchoot 'ink'ez hizih nebunilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","'Ink'ez Israel dula nailhnih be Ephraim ootsi k'ut nedilni, 'en 'udek'oh-un 'unt'oh, 'ink'ez 'intl'us ts'e 'et Manesseh ootsi k'ut 'et nedilni, 'ink'ez yuk'unudulnih-un Manesseh 'en 'udetso-un whuzdli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","'Ink'ez Joseph soo hoonzoo-un be ubulh yalhduk 'ink'ez 'utni, “Yak'usda (Elohim) mbe la sbáke Abraham 'ink'ez Isaac bulh hitso nusu'azne, Yak'usda (Elohim) mbe la 'andit dzin whuts'un yinka susda nduwhulhyiz whe sgha 'an'aih, ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ndun Lizas mbe la hoonts'i'-un whuch'a nasonket-un, 'en ndunne duneyaz soo hoonzoo-i be za tl'aookat. Ndai soozi' 'i be bubohozi, 'ink'ez sbáke Abraham 'ink'ez Isaac buboozi' be cha, 'ink'ez soo ndi yun k'ut 'et lhane cho hoole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","'Et Joseph dubá nailhnih ts'unk'us 'et Ephraim k'edilni 'et whunilh'en, 'et whuts'udutni 'ink'ez dubá oola yilhchoot Ephraim ootsi k'udilhni whe 'ink'ez Manesseh ootsi k'edilhni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","'Ink'ez Joseph dubá 'ulhni, “'Awundooh sbá, ndun 'en 'udetso-un whuzdli whe 'unt'oh, nailhnih ts'unk'us 'et ootsi k'edilni.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","'Et hoonts'i oobá hukwa lhe'nizun 'ink'ez 'utni, “T'eoonuszun sye', t'eoonuszun 'en cha ndi yun k'ut dune tileh 'ink'ez ncha tileh. 'Et hoonts'i ndun ook'oh-un, 'en yanus 'ulcho tileh 'ink'ez soo keyoh whudizbun whe yuts'u hayandene hutileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","'Et nahult'oh soo hoonzoo-un be ubulh yalhduk whe 'utni, “Nohni nohbá Israel soo hoonzoo-un be nohbulh yalhduk 'ink'ez 'udutinelh, ‘Yak'usda (Elohim), Ephraim 'ink'ez Manesseh buk'un'a 'ooht'e'’.” 'Et whuz un'a Ephraim 'en Manesseh tso nenilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","'Et Israel, Joseph 'uyulhni, “Whunilh'en 'awet dassah whe 'ust'oh, 'et hoonts'i Yak'usda (Elohim) nyulh 'utit'elh mbáke bukeyoh ts'e whuz nanyutilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","'On 'un cha ndai la nyulhutsinke bugha inusla-i, yun 'ilhoh 'ultsuk 'i be nyun ngha nusla. 'I Amor whut'enne ooghu yuschoot inle', saluzti be 'ink'ez sk'aza be.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","'Ink'ez Jacob duye'ke buka'dani 'ink'ez 'utni, “'Ilhoozahdilh 'et de sih nohbulh dawhutanelh la 'udek'ez dzin nohudutasnelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","'Ilhozahdilh 'ink'ez oozulhts'ai Jacob ooye'ke 'ink'ez nohbá Israel oozulhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben nyun 'udetso sye' whuzdli-un inli. Ndai la be ustus-i 'ink'ez 'udechoo be ustus suli'-i, ndai la ilhoh tune' zust'en-un 'ink'ez dalcho-i be be ustus-i cha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Too nudutunne oot'aniuznootan ait'oh. 'Aw hoonzoo lhotuzan'el mbá oolili k'ut 'et inte' 'ink'ez whudutsun whuzilhtsi. Ndai la ook'oste'-i 'i ookw'ut inte' 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon 'ink'ez Levi bulh lhulhutsinke hudli. Be dzoh ne'udzut-i bubulh 'unt'oh, ndet la huwhut'i-un. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","'Aw szul buzih neooya' junih. Be dasti'-i, ndet la huwhut'i-un bubulh 'uyot'e' junih. Huhunilch'e whe dune huzilhghi 'et huwa, 'ink'ez k'une' hut'en whe musdoos dune kechun dugha hininguz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bube huske-i ookw'ehoodeh, tube be oonujut 'et huwa. Huye huske-i tube ookw'ehunduda. Jacob 'et lhk'e butistelh 'ink'ez Israel 'et lhelhdun nebutastelh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Judah nyun 'utant'elh, nyulhutsinke nyuhudutalhti'. Nla 'i mbene la nch'az ditnine buk'udutalni, mbá buzkeh 'enne mbut yo 'uhuntitsulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Judah 'i khuna-iti lion huyulhni, 'i ooyaz 'unt'oh. Ndai la inghan-i sye', 'i bulh ndo 'inja. Yo untut'aih 'ink'ez khuna-iti lion huyulhni, 'i k'un'a usti 'ink'ez khuna-iti lion unli de, mbe suba hinolhch'eh? ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ndai la lerwene tuz nuhidutun-i, 'i Judah yuyit lhe'tist'el. 'Ink'ez keyoh huwuni ook'une' whut'en-i, 'i 'aw ooke eguz whuch'a naoodzit ait'oh, Shiloh whusainya 'et whuts'un. 'Ink'ez dunene 'en buk'oh ts'e hik'une' oot'en ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Oodonkey 'i nyoo duchun nudunulhye 'idutaguz, 'ink'ez donkey ooyaz 'i duchun nudunulhye 'i soo 'uk'enus unzoo yuzih neitalhtelh. Dunaih 'i ts'ekoo too' be tunayuzguz, 'ink'ez dunaih 'i mai ts'ekoo too' huyilh-i, i ootoo' 'i be tunayuzguz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Oona 'i ts'ekoo too' anus dunulhgus, 'ink'ez ooghoo lilet anus 'ulhyul ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun 'en yatooba hoonzoo-un 'et whutit'elh. Ndai la ts'i yanakuk-i, 'i ba, 'ink'ez keyoh Sidon 'et whuzih whutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issachar 'en donkey ulhtus-i 'unt'oh. Ndai ndaz-i yeguz nanki, 'i 'et tit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nats'ulyiz-un hoonzoo-un 'et hon'en 'ink'ez yun k'ut hoonzoo 'utighelh wheni yo 'utinelh. 'Ink'ez 'ulhna didohne huzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan 'en dudune'ne buba nahutiyeh. Israel 'ilhoh didohne oots'u haindene 'enne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan 'en ti whuzih tl'ughus, viper, tileh. Tl'ughus 'oolch'oolh-i ti whuzih, 'ink'ez yeztl'i k'ents'ul cha oolhch'oolh. 'Ink'ez mbe la yuk'usda-un 'en k'oh un'a yuk'udutildus. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","O Moodihti (Yahweh) ndet la whesutalhyih-un hubas'e'! ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad 'en lhuganne didohne 'enne hik'ut nutidulh, 'et hoonts'i 'udek'oh 'et whuch'a' tilhdoh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asher ut'alh-i oots'u hayults'uk-i, 'i tube dutati', 'ink'ez nzoo-i oots'u hatikulh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naphtali 'en yezts'e oolazditni-i le'unt'oh, khuni nzoo-i za huwa'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph 'en duchun zooschum cho oots'a ha'ukat-i unli. Too k'et whuzih 'et oots'a hakat-i 'uzooschum unli. 'Ink'ez be 'uzoozchum nyo sih hukw'ut ndulcho whe hoonli. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Mbene la k'aza be lhuganne tube hidzi undalhda'. Nuhinulhtso 'ink'ez huts'uditni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","'Et hoonts'i ook'aza ulhtus-un 'et za 'unt'oh inle'. 'Ink'ez oogan 'i cha 'onus oonut'i lhtus suli'. Jacob ooYak'usda (Elohim) be oonujut-un ulhtus-un, oola 'i be 'unt'oh ('en 'Usbai Ghunli-un unli, Israel Whutse' 'unt'oh). ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mbá ooYak'usda (El), 'en nla'utinelh. 'Ink'ez 'Uk'enus 'Ultus-un (EL Shaddai), 'en soo hoonzoo-i za ntl'aookat. Yak'uz ts'e hakat-i, 'i be mba soo hoonzoo-i ntl'aookat. Yatoo t'ah ts'e hoonli 'i be cha mba soo hoonzoo-i whutaleh. Ts'ekoo buts'oo' ts'oodunne huye 'ulhtuk-i be 'ink'ez ts'ekoo buchan cha mba soo hoonzoo-i ntl'aookat whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Mbá soo hoonzoo-i nohtl'aookat, 'i stsoda'ne 'onus soo hoonzoo-i za butl'ayilts'ut, whanus unzoo suli'. Ndo yak'uz 'ilhiz wheni nodist'ai-un soo 'uk'enus nilhdza'-un 'et whuts'un, 'i Joseph ootsi k'ut 'utit'elh 'ink'ez ootsit'ah hukw'ut, 'i bulhutsinke anus 'utit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin 'en yus tube ooye'ilts'ul-i unli, bundada' 'et si yuzilhghi-i yoo'alh, 'ink'ez 'ulhdzis 'et ndai la yughan-i, oogha yunkat-i lhk'eyulih. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ndunne 'enne ts'iyawh Israel ts'u haindene whunizyane 'on 'at nane didohne, 'et ndi khuni 'i be buba hubulh yailhduk 'ink'ez soo hoonzoo-i buts'un tizoo', lhoghun hinli whe nts'en'a la didutch'oh soo hoonzoo-i be ubulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","'Et 'ink'ez 'ubulhni, “'Awet sulh dune'ne, ubulh 'ist'e'ne 'enne 'awet buts'un tisyalh. Ndet la tse'an Ephron yun k'ut 'i Hitt whut'en-un 'unt'oh, 'en ootse'an 'et sbákene bubulh 'asoolhtelh, ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","tse'an 'et Machpelah yun k'ut 'et 'uhoont'oh, Mamre whutso Canaan yun k'ut 'i Abraham, Ephron, Hitt whut'en-un unli-un, 'en ooyun, ts'unk'ut wheni 'et honket. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","'Et Abraham 'ink'ez Sarah oo'at bulh cha 'abuhalhti, 'et Isaac 'ink'ez oo'at Rebekah bulh cha 'abuhalhti, 'ink'ez si cha 'et Leah 'asti. ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ndai la yun 'ink'ez tse'an ook'uwhuz'ai-i, 'i Heth ooye'kene ts'un huyonket.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","'Ink'ez Jacob 'awet buzkeh hubulh yalhduk-un 'etsul 'udija whe, lili k'enadil'ez 'ink'ez 'udek'ez hanajiz. 'Ink'ez whutsoda' oonatneke bubulh 'unt'ohne 'enne buts'un whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","'Et Joseph dubá yunin k'echaniti 'ink'ez yuk'ut intse 'ink'ez naidits'ooz. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","'Ink'ez Joseph yuba 'ut'enne, yoo be duyunne, 'enne dubá oozi lhahidooleh hubulhni. 'Et yoo be duyunne, 'enne Israel oozi yesa' soo' tit'elh-i, 'i be highaizna. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Dit whunizyat dzin (40) 'et whuz un'a huba' hoont'oh ts'et ubuhulhti, 'ink'ez buk'enihunudleh. Whuz un'a buzih lhadulyanne, 'ink'ez Egypt whut'enne, 'enne lhtak'ant'it whunizyat dzin (70) 'et hik'enudleh whe inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","'Et 'awet ndi dzin lhaoodinla 'et Joseph, Pharaoh ooyoh whut'ine hubulhni, “'Andit nohna soo ts'ih'un sulh newhuna'ai de, 'et Pharaoh soo nehoozulhts'ai, 'en dudoohni', ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘'Ubá oots'un nahizusya whe njan dudusni, “Whunilh'en 'awet datisah. Ndet la sts'un k'ut, Canaan yun k'ut 'uwhusla-un 'et 'asolhtelh,” sulhni. 'Et huwa sladinih, 'ubá 'atistelh 'ink'ez la whusanaoosja.”’ ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","'Ink'ez Pharaoh 'utni, “Whuz inyalh 'ink'ez mbá 'ailhtih, khuni daja dini la oots'u nahizinya-i k'un'a.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","'Et Joseph whuz dubá whenayalhti 'aitilhtelh ha, mbene la Pharaoh yuba 'ut'enne cha ts'iyawh hiyulh whendil. Ooyoh 'udetso whudilhdzulhne, 'enne cha 'ink'ez Egypt yun k'ut 'udetso whudilhdzulhne, 'enne cha hiyulh whendil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph ooyoh whut'ine, bulhutsinke 'ink'ez oobá ooyoh dilhts'ine cha ts'iyawh hiyulh whendil. Ts'oodunne 'ink'ez bughuna' cha, musdoos cha, 'ink'ez ts'iyawh nyo Goshen whuyun k'ut 'et neboninla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","'Et yeztl'i 'ink'ez nyowhi huye nudilh-i huye 'uzdla-i cha tubeh lhane dune 'ilhozdil ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","'Et nyo Atad ooch'e' lhes mai' dunuldus-un, 'et nehunindil, Jordan whanoo' 'uhoont'oh, 'ink'ez soo tube 'et hik'eniudle. 'Et Joseph 'en lhtak'ant'it dzin 'et dubá yuk'enudleh whe inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","'Et nyo Canaan whut'enne dune nyo lhes mai' dunuldus-un 'et hik'enudleh whunilh'en, 'et huwhuhunilh'en 'ink'ez 'uhutni, “Njan 'et tube Egypt whut'enne hukw'ehunduda whe hik'enudleh.” 'Et huwa ooboozih Abel Mizraim, Jordan whanoo' whuz'aih 'i hoozi' huyulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","'Et duye'ke daja hubulhni la, whuz un'a 'uhuyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ooye'ke Canaan keyoh ts'e nahuyoolhti 'ink'ez nyo Machpelah yun 'et tse'an 'et 'ahayalhti, Mamre whutso 'et Abraham nyoo yun Ephron, Hitt whut'en-un, 'en ts'un yonket ts'unk'ut wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","'Et Joseph dubá 'ayalhti whe 'et Egypt ts'u naoosja, bulhutsinke cha, yulh nusudilne 'enne cha ts'iyawh whuz nahoosdil. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","'Et Joseph bulhutsinke bubá 'awet dazsai 'et 'uhutni, “Joseph nets'u dootni tilah, dats'inla la hoonts'i hukw'un'a 'uts'inla 'et tilah neba k'elha hoolhtselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","'Et Joseph hits'otl'a khuni in'ai 'uhuyulhni, “Mbá datitsah whutso njan ndutni, ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘'Et Joseph dohni',’ “Nts'u tezdudlih, nyulhutsinke buba whunahodolnoh 'ink'ez wheninta' hunt'en cha tube hoonts'i k'un'a 'unyuhinla, 'et huwa mbá ooYak'usda (Elohim) ba 'ut'enne, 'enne buba whunahoodolnoh.” 'Ink'ez Joseph intse hiyulh yailhduk whe. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","'Et bulhutsinke 'enne cha hinin ts'e 'et hibut nahankat 'ink'ez 'uhutni, “Whunilh'en mba 'ut'enne ts'inli.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph 'ubulhni, “Whenulhjut iloh. Yak'usda (Elohim) 'en la ook'edusda whe' duhni? ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","'Et nohni tube hoontsi' hukw'un'a 'usutilelh k'un'a 'usuhla, 'et hoonts'i Yak'usda (Elohim) 'en ooba hoonzoo hukw'una 'uhoonla, 'andit dzin wheni dune lhane hubutisyih ha. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","'Et huwa whenulhjut iloh, nohuzkehyaz cha nohni cha ts'iyai be lhanohdutisleh.” 'Ink'ez k'enabunin'a 'ink'ez soo cho khuni nzoo-i be bubulh yailhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","'Et Joseph Egypt yun k'ut 'et hoot'e', dich'oh cha 'ink'ez oobá ooyoh whut'ine inle'ne, 'enne cha 'ink'ez Joseph whunizyat whunizyai 'on 'at whunizyai (110) yus k'ut 'et khana. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph 'et Ephraim buzkeh tawh whudidoh whuts'un bunalh'en, Machir buzkeh Manasseh ooye', 'enne cha Joseph oogw'ut k'ut 'et hunizyai. ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","'Ink'ez Joseph dulhutsinke 'ubulhni, “'Awet datisah, 'et hoonts'i Yak'usda (Elohim) 'alha nohts'un nutiyalh 'ink'ez ndi yun ch'a nanohtalelh, 'ink'ez Abraham, Isaac 'ink'ez Jacob cha yun buts'i yoozi'-i, whuz nanohtilelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","'Et Joseph, Israel buzkeh hits'u nahizya 'et 'ubulhni, “'Alha Yak'usda (Elohim) nohts'un nutiyalh 'ink'ez usts'un 'i njan whuch'a naoolelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","'Et Joseph dazsai, 110 be yus k'ut 'ink'ez hizi sa' soo' tit'elh huba lhahidinla 'ink'ez Egypt 'et chunkelh 'et hitalhtelh ha.");
INSERT INTO crxNTpo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ndi 'udustl'us 'uk'eguz-un 'et dutni, 'i be Sizi Gri 'en ubé dinzutne 'uhínt'oh, 'i Sizi David ts'u hainzut-un 'unt'oh. David 'en Abraham ts'u hainzut-un 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham 'en Isaac oobá 'unt'oh. Isaac 'en Jacob oobá 'unt'oh. Jacob 'en Judah 'ink'ez bulhutsinke bubá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judah 'en nyoon ts'eke Tamar 'en be Perez 'ink'ez Zerah bubá 'unt'oh. Perez Hezron oobá 'ink'ez Hezron Ram oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram 'en Amminadab oobá. Amminadab Nashon oobá, 'ink'ez Nashon Salmon oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon oo'at Rahab 'en be Boaz oobá. Boaz Ruth 'en be Obed oobá. 'Ink'ez Obed Jesse oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesse lerwe David oobá. 'Et lerwe David, mbe la Uriah oo'at inle'-un, 'en be Solomon oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon Rehoboam oobá. Rehoboam Abijah oobá, 'ink'ez Abijah Asa oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Jehoshaphat oobá. Jehoshaphat Joram oobá, 'ink'ez Joram Uzziah oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzziah Jotham oobá. Jotham Ahaz oobá, 'ink'ez Ahaz Hezekiah oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiah Manasseh oobá. Manasseh Amon oobá, 'ink'ez Amon Josiah oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","'Oh da' 'oh whuya whudizulh whe ts'iyanne dune keyoh whuti Babylon ts'e whebuhanla, 'et Josiah 'en Jeconiah 'ink'ez bulhutsinke 'enne bubá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Keyoh whuti Babylon whuz whebuhanla hukw'elh'az 'et Jaconiah Shealtiel oobá 'unt'oh. Shealtiel Zurubbabel oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubbabel Abiud oobá. Abiud Eliakim oobá, 'ink'ez Eliakim Azor oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Zadok oobá. Zadok Achim oobá, 'ink'ez Achim Eliud oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazor oobá. Eleazor Matthan oobá, 'ink'ez Matthan Jacob oobá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob Joseph oobá 'unt'oh. 'En Mary ooki 'ink'ez Mary 'en be Sizi whuzdli. 'En Christ huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","'Inka Abraham David whuts'un, 'enne ts'iyawh whunizyat 'on 'at dit-un bubé dindene 'uhint'oh. 'Ink'ez David 'oh da' whudizulh whe ts'iyanne keyoh whut'enne Babylon ts'e whebuhanla whuts'un, 'enne ts'iyawh whunizyat 'on 'at dit-un bubé dindene hinli. 'Ink'ez 'oh da' whudizulh whe ts'iyanne keyoh Babylon ts'e whebuhanla 'et hukw'elh'uz dich'oh dukeyoh yun k'ut Judah, whuz whenáhidil, Christ 'et whuts'un, 'enne ts'iyawh whunizyat 'on 'at dit-un bubé dindene hinli whe hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","'Et 'awet Sizi Gri whuzdli-un, ndiz un'a 'uhooja. Ooloo Mary 'en Joseph 'en yughu tidalh ha lhahódinla, 'ink'ez yughu tidalh whutso whe 'et nahoon'ai 'uda' ts'oodun ba 'unt'oh. Ndoni, 'i be 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","'Et ndun Joseph 'en ts'ih'un dune unli, 'et huwa lhgho tikelh ts'iyanne toh yooya yoolhtselh whuch'a dudeni lhaidinla. 'Ink'ez whu'iz yuch'a natidalh hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","'Et howu nuni nuzut whe 'et huwu nusúti whe neMoodihti oolizas 'en yulhni, “Joseph David oots'u hainzut-un inli whe' 'int'oh. Wheniljut iloh whe Mary n'at tileh. Ndun ts'oodun Ndoni be chainya whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","'Et 'awet ooyaz, duneyaz tileh. Nyunch'oh boozi' oogha ídon'alh. Sizi dóni'. 'En 'utinelh ts'iyanne lubeshi ch'a ubutilhyih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","'Et ndiz un'a 'uhooja, neMoodihti nyoon nus hoo'en-un, 'en be daja ni la, whunilhchoh 'oh túne'whust'en. 'Et nyoon nus hoo'en-un ndiz un'a nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Soo zulhts'ai ndun ts'eke 'aw dune t'enuszun-un 'et hoonts'i khunsul ts'oodun ba 'uja, 'ink'ez ooyaz dune tileh, boozi' Emmanuel hidutánelh, Yak'usda nebulh 'únt'oh, ni whe utni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","'Inka Joseph ts'enanzut whe neMoodihti oolizas daja yulhni la, 'oh tune' 'ust'en 'ink'ez 'awet Mary yilhchoot oo'at yutáleh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","'Udechoo ooyaz whutileh t'eoonanzin 'et whuts'un 'aw yut'álhasnai. 'Et 'awet ooye' whuzdli, 'et 'andit za soo yughusda. 'Inka boozi' yugha ídin'ai Sizi yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","'Et 'awet yun k'ut Judea, keyoh Bethlehem whuz'ai-un, 'et Sizi whuzdli. 'Oh da' whuz un'a Herod lerwe unli whe 'et 'uhooja. 'Et 'awet whuzdli hukw'elh'az khunsul nda' whut'enne keyoh Jerusalem ts'e hoozdil. 'Enne whunihne Majine hubuhútnine, 'enne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","'Ink'ez dune hoodulhkut, “Lizwifne bulerwe 'andit whuzdli-un, 'en nts'e whuzdli? 'Et ndi sum cho ts'an'en, 'i gha lhuts'úzdil. 'Et huwa ndaz de ndun ts'oodun 'en oots'un teni' ts'untilhdzilh ha whusats'ándilh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Et hoonts'i lerwe Herod whulh udants'o whe ooba dzoh 'uhutni. Jerusalem whut'enne, 'enne cha whuz un'a za buba dzoh 'uhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","'Ink'ez ts'iyanne ba lubret bumoodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'enne ts'iyawh Herod 'anih ubudani'. 'Et 'enne buts'un nahootá'alh Christ ndet whutileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","'Ink'ez huyulhni, “Yun k'ut Judea, keyoh Bethlehem whuz'ai-un, 'et whutileh. Ndet la nus hoo'en-un 'et 'uk'ehónguz-un, 'et whuz un'a nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yun k'ut Judea ts'e keyoh Bethlehem whut'enne, 'et nohkeyoh hoontsool-unyaz hoonli, 'et hoonts'i tube whudizti' tileh. 'Alha nohkeyoh 'et whuts'un 'ilhoghun moodih ncha-un, 'et whusatiyalh. 'Ink'ez sdune'ne, Israel oots'u haindene, 'enne 'usbai ghunline k'un'a bughu tileh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Et Herod whu'iz whe ndunne whunihne 'anih ubudáni'. 'Enne buts'un nahootá'alh ha 'et soo ndet dzin nts'oya hoozulh whe ndi sum be hóodiltsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","'Et hukw'elh'az keyoh Bethlehem ts'e whebalh'a' 'ink'ez ndúbulhni, “Ahdulh 'ink'ez howa 'óohli whe ts'oodun nalhtih. 'Et nawhah'ai de, nts'e 'unt'oh 'et sts'ótl'a khuni ooh'alh. Si cha whuz tisyalh oots'u teni' ntisdzilh ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","'Et lerwe 'et ndúbulhni whe 'aho whehándil. 'oh whuya hidulh whe khunsul ndai la ndi sum ndaz ts'e hinalh'en-i, 'i hitilh'en 'ink'ez 'ants'i butso ults'ulh. 'Et nts'e la ts'oodun usda-un 'on do, 'et lhghá nelts'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","'Et ndet la sum hinalh'en da' 'uk'enus huhóont'i' k'et 'aw 'uhoot'e' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'Et 'ink'ez yoh dahunindil whe ndun ts'oodun hitilh'en. Ooloo Mary 'en cha 'et usda. Hibut nachánilya 'ink'ez hits'un teni' nalhdzun. Unzoo-i huye 'úzdla-i hidah lhch'az hiyilhchoot whe ndai la unzoo-i hiyé hahúyanla 'ink'ez hits'u hítilhdil. Gold, yoo sooltsun-i frankencense huyulhni, 'ink'ez yoo Myrrh huyulhni cha, 'i ts'iyawh hits'u hítilhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","'Ink'ez Yak'usda bubul be bugha dáni' 'et 'aw Herod 'en ookw'unaoohdilh junih budáni' 'Et huwa 'uts'o whuya dukeyoh ts'e whenáhidilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'Et 'awet whunáhidil hukw'elh'az neMoodihti oolizas Joseph nute whe benghun whe hóodiltsai. 'Et 'uyulhni, “Dudinyaih, ndun ts'oodun ooloo bulh ubilhchoot 'ink'ez yun k'ut Egypt 'a cho whuz ubalhtelh! 'Et nohdutásnelh 'et whuts'un 'et dólhts'i'! 'Et 'awet 'áho Herod ts'oodun yuka it'á'elh yutuzilhghelh ha!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Inka 'ulhdzis dunadija 'ink'ez ts'oodun ooloo bulh ubilhchoot 'ink'ez yun k'ut Egypt ts'outni whuz whehándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Et Herod datitsah whuts'un 'et 'udutálts'ilh. 'Et ndúhut'en whe neMoodihti nyoon nus hoo'en-un, 'en be daja ni la 'et whunilhchoh 'oh tune' whust'en whe nja dutni, “Sye' 'anih dasni' yun k'ut Egypt whuch'a naooja' ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","'Et 'awet Herod t'eoonanzin ndunne whunihne, Majine huyulhni, nahinan'a, 'et huwa tube hunilch'e. 'Inka nts'oya hoozulh Majine hidáni' whe whulohne lhuganne keyoh Bethlehem ts'e whebalh'a'. 'Et 'ubulhni, 'et keyoh whut'enne ts'iyawh 'ink'ez whunat whut'enne cha mbene la duneyaz nat yus k'ut be suli'ne 'ink'ez whuts'un whudilhdzulhne cha, 'enne ts'iyawh huboohghan. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Et whuz un'a nyoon nus hoo'en-un Jeremiah huyulhni, daja ni la 'et ts'iyawh whunilhchoh 'oh tune' whust'en whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“'Et keyoh Ramah buyiz dahts'o da' tso yahalhduk 'ink'ez duduzkeh k'ehúnintai. Rachel ts'oodunne buk'etso yahalhduk. 'Aw budzi do na'otneh ait'oh, bubuzkehke gak huzdli' 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'Awet Herod dazsai whe' hoont'oh. 'Et 'awet Egypt yun k'ut ts'e neMoodihti oolizas Joseph huwunute whe benghun néwhults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","'Et ndúyulhni, “Dudinyaih! Ts'oodun duloo bulh nabilhchoot. Israel yun k'ut whuz nahdulh. 'Et whutso da' mbene la ts'oodun yukúniztaine hituzilhghelh ha, ts'iyawh yahadla.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","'Inka dudinya. Ts'oodun duloo bulh nabílhchoot 'ink'ez Israel yun k'ut ts'e whenáhidil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","'Et hoonts'i Joseph whulh udants'o Herod ooye' Archelaus huyulhni, 'en dubá k'edanya 'ink'ez 'andit Judea yun k'ut whulerwe unli. 'Et whuz tiyalh whe nuljut whe howu nusúti 'et Yak'usda yugha dáni'. 'Et huwa Galilee yun k'ut ts'e whuz whehándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Whuz hoozdil whe keyoh Nazareth huwhútni, 'et hudutálts'ilh. 'Et whuz un'a nus hoo'enne daja hutni la, 'oh túne'whust'en whe nja duhútni, “'En Nazareth whut'en-un hidutánelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","'Et 'oh whuya hoozulh whe John dune too be 'ulh'en-un Judea yun k'ut dune lhuhoot'i ts'e, whuz whinya 'ink'ez dune bulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","'Et 'ubulhni, “Noheni náhandunoohleh. Mbe la yak'uz k'une' whul'en-un nohtoh 'utit'elh-un, 'awet nilhdukw.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ndun 'en nus hoo'en-un Isaiah yughu yalhduk whe nja dutni, “Dune lhuhoot'ih ts'e dune yiz dusts'ai whe 'ultus-un huyih whe nja dutni, ‘NeMoodihti ooti lhaoodahleh! Ooti soo lhts'eoodiz'a ooba whulhtsi.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","'Ink'ez John dich'oh khuna-i gha, camel huyulhni, 'i ye dune unli 'ink'ez 'uzus se be ts'udilh'oo. Tulk'us cho 'ink'ez ts'ihnatl'uz 'ohwhi ya'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","'Et 'oh da' dunene ts'iyawh ndunne Jerusalem whut'enne cha, Judea yun k'ut whut'enne cha, 'ink'ez dunene 'et 'ukoh Jordan whut'enne, 'enne ts'iyawh John gho nindil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'Ink'ez dulubeshi ghun hunahuhoolnuk whe 'et nyo 'et 'ukoh Jordan John 'en too be' balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","'Et hoonts'i lhane Phariseene 'ink'ez Sadduceene cha, 'enne too be' hutilnelh ha highu nindil. 'Et hubunilh'en whe ndúbulhni, “Nohni lubezo tl'ughus buzkehke le'áht'oh! Yak'usda lubeshi 'ulh'enne bubulh huntalch'oh-un, 'et whuz de hóolts'ulh, mbe 'unohulhni whuch'a úlhwus? ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Whute lubeshi ch'a noheni nahandunoohleh de, ndaht'en-un ts'iyanne t'ehonózin ndaht'oh la. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","'Ink'ez khun lhts'un njan dudoohtni' junih, wheni Abraham oots'u haindene 'uts'int'oh. 'Alha ts'ih'un un'a nohdusni Yak'usda soo 'ultus whe 'unt'oh, ndi tse 'i hoonts'i 'i be Abraham oots'u haindene ubutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Njan soo cho whunulh'en, nohni duchun lé'aht'oh. 'Awet tsetselh be lhadínt'oh-un. 'Et nohni whulohne duchun oomai' hooloh-i, 'et ndaht'oh. 'Andit hoonts'i ndai la oomai' hooloh-i, tsetselh ooghih tubulh tsuhídantsel 'ink'ez hidutálhk'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Noheni nahunduníhla 'et huwa too za-i be too be' nohúsdla. 'Et whuz un'a za 'unohus'en. 'Et hoonts'i 'ilhoghun sk'elh'az whusatiyalh-un, 'en sanus dizti' whe 'unt'oh. 'Aw ookegon 'i hoonts'i ooba nétisdlelh huba soo lhe'usdzoo'. Ndun 'en Ndoni 'ink'ez kwun bulh 'i be too be' nohtilh'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Lufoos tl'o mai' be tahawhúlts'ih-i, 'i 'ahoolhyiz nuyútun. 'Ink'ez ndi tl'o mai' yutahawhúlhts'ih-i, 'ink'ez yuk'ut 'ut'en-i cha yuk'ut lhadút'ih de, 'ink'ez yuna'ulhdoh. 'Ink'ez ndi mai ndai la lhaduja-i, 'i ts'iyawh deínudzih 'ink'ez mai bayoh ts'e wheyúli. 'Et hoonts'i ndai la ndi kwun 'aw nalhnusne, ndi oot'ooz, 'i be duták'un,” ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","'Et 'awet Sizi Galilee yun k'ut huwhutni ts'e hainya. 'Et Jordan koh ts'oozya John too be' yutilelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","'Et hoonts'i John dah yúlhni. “Nyun too be' sonleh huba' hoont'oh. 'Ink'ez di ha si sts'ú tinya too be' nyoosdleh ha?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","'Et hoonts'i Sizi 'uyulhni, “Whute soo cho nilh'en, be ts'ih'un 'uhoont'oh-i, 'et ts'iyawh lhaoodutanelh whe' hoont'oh.” 'Et 'awet whute 'et dúyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Sizi too be' yinla whe tooz hanája ibulh 'et 'aho 'en ba 'aho yak'uz daha' dankez 'ink'ez Yak'usda Ooyughi yunilh'en whe ndus de dut'ai, 'i dove huyúlhni, 'i k'un'a Sizi ookw'édinde. ");
INSERT INTO crxNTpo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Khunsul ndus de 'uwhutni, “Ndun 'en sYe' ook'esi' 'en 'unt'oh, 'ink'ez tube 'en bulh hoonúst'i',” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'Awet Sizi nts'e la dune lhuhoot'ih ts'e Ndoni 'onilha Sizi whuz wheyálh'a' netsudule yootálhdzih ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Dit whunizyat dzin sóo honih, 'et hukw'elh'az 'awet ooye'ílts'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Et yóolhdzih-un, 'en yughu ninya 'ink'ez 'uyúlhni, “'Alha Yak'usda ooYe' inli de, ndi tse lhes oole' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","'Et hoonts'i Sizi yulhni, “Ndiz un'a Yak'usda ooghuni k'ut 'uk'usgus whe nja dutni, ‘'Aw lhes za iloh dune yuk'ukhuna, 'et khuni ts'iyawh Yak'usda daja ni, 'i cha hik'ukhuna.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Et netsudule keyoh whudizti' ts'e yulh whin'az, 'ink'ez njan lugliz whucho 'udedo hukw'ut, 'et soo whuban nenilhya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","'Ink'ez 'uyulhni, “'Alha Yak'usda ooYe' inli de, njan whenghe' dudintneh! 'Alha 'uk'ehooguz whe nja dutni, ‘Yak'usda oolizas butl'ahon'ai whe 'enne nyun nka huwuhinli, 'ink'ez dula be do nyuhóotatun, 'et huwa 'aw nke tse t'aoonalh ait'oh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","'Et Sizi nduyulhni, “Cha za njan 'uk'ehooguz whe nja dutni, ‘Khun te Moodihti nYak'usda 'en nantan'ah hukwa ólhdzih junih!’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","'Et doo cha za netsudule ndi dzulh 'udedo hadít'ai ts'e whuz yulh whin'az. 'Et ndi yun k'ut ndulcho whe whenulhtun lerwene bube 'ut'en k'oh 'ink'ez huyé dizti'-i, 'i cha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","'Ink'ez 'uyulhni, “Ngwutsi be neninya 'ink'ez sts'u téni' nilhdzun de, 'et de ndi ts'iyawh, nch'e' tileh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","'Ink'ez Sizi yulhni, “Satan naindalh! 'Et 'uk'ehooguz whe nja dutni, ‘Moodihti nYak'usda, 'aw 'en za oobut negwutsi be nets'iyaih, 'ink'ez oots'u téni' uznilhdzun, 'ink'ez 'en za ba né'ts'ut'en.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Et 'awet netsudule whenaja 'ink'ez khunsul lizasne whusahándil 'ink'ez hiba ne'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","'Awet Sizi whulhúdants'o John 'ahuyan'ai. 'Et huwa Galilee yun k'ut ts'u whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","'Et keyoh Nazareth whuch'a séya 'ink'ez keyoh Capernaum whuz oozya 'ink'ez 'et tidalh. Njan keyoh 'et taba whuz'ai. 'Et lhendun yun k'ut Zebulun 'ink'ez Naphtali lhodin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","'Et Isaiah nus hoon'en-un, 'et howu yailhduk-un lhaóodotneh whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yun k'ut Zebulun 'ink'ez yun k'ut Naphtali, ya too' k'uz wheti 'et whuz'ai. 'Et njan Galilee yun k'ut, 'i 'udun yun k'ut whut'enne, 'enne buba 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Mbene la tsalhgus yo dilhts'ine, 'enne kwun uncha-i hitilh'en. Nts'e la yun k'ut sa whus'ih whuz'ai-un, ndi sa whus'ih, 'i be daztitsah-i, 'i 'unt'oh. Mbene la 'et whut'enne, 'enne be hóot'en unli-i, 'i be buba yulhkai le'hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","'Et whuts'un Sizi dune bubulh yawhénilhduk whe ubúlhni, “Noheni náhandunoohleh! Yak'uz k'une' whul'en-un 'awet nilhdukw suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","'Awet bunghun Galilee taba Sizi 'oh whuya uyalh 'et nane dune lhulhutsinke ubutilh'en. 'Ilhoghun 'en Simon cha huyulhni Peter cha huyulhni, 'et 'ilhoghun bulhutsin 'en Andrew huyulhni. 'Enne lhembilh tahúyalhdil lho ha 'ut'enne hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","'Ink'ez 'ubulhni, “Nanúlht'oh sunih'us. Dune ha 'ut'enne nohtiselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","'Et 'aho dulembil hiladitni 'ink'ez hik'oh ts'e oot'en ha huyuntiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","'Et 'on 'un hidulh 'et doo cha za nane dune tilh'en. 'Enne cha lhulhutsinke Zebedee ooye'ke. 'Ilhoghun James huyulhni 'ink'ez 'ilhoghun John huyulhni. Dubá te ts'i cho be húdilhts'i 'ink'ez dulembil nahuyutl'oo. 'Et Sizi bukahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","'Et 'aho dubá bughu déhain'az 'awet ye usda whe 'ink'ez Sizi hik'oh ts'e oot'en ha hiyuntiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","'Et 'awet Galilee yun k'ut Sizi ndulcho nuya whe Lizwifne bulugliz 'et dune bubulh yálhduk. Mbe la yak'uz k'une' whul'en-un, 'en ghun khuni unzoo-i be bubulh yálhduk. Dune toh mbe la ndudane 'ink'ez ooyust'e tétsunne, 'enne cha ts'iyawh soo na'bulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","'Et Syria yun k'ut whut'enne, 'enne cha ts'iyawh hiyulh údits'o. 'Et huwa mbene la lhenyoo dada bé undudane, 'ink'ez mbe la 'on nus bulh 'últs'ulhne cha, mbe la ntsi'-i nudúde ooyudindane cha, whusnine cha 'ink'ez ookaootuzukne 'ink'ez delh dusnine cha, 'enne ts'iyawh Sizi ts'u buhoozdla whe ts'iyawh soo ná'binla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","'Ink'ez Galilee yun k'ut whut'enne, Decapolis yun k'ut whut'enne cha, 'ink'ez keyoh Jerusalem whut'enne, Judea yun k'ut whut'enne cha, 'ink'ez Jordan koh 'on yah whéya whut'enne cha, 'enne ts'iyawh 'et huldlai k'et 'aw 'uzdooni' ait'oh. 'Et 'ultsukne 'ilhunaoosdil 'enne ts'iyawh hiyuntizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","'Awet Sizi 'ilhunaoosdilne ubunilh'en whe ndo dzulh enun ts'e ndo whinya 'ink'ez 'et nátl'adida'. Mbene yugha hódul'ehne, 'enne hits'oozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'Et 'awet whuwhebondunilh'e', 'et nja dúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mbene la ndunne lubeshi 'ulh'enne, 'enne bugha budzi tel'en unline, 'enne yak'uz k'une' whul'en-un ooch'e' huzdli', 'et huwa 'uk'enus hoonzoo-un bugha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mbene la dulubeshi ghu ni unline, 'enne 'uk'enus k'enánit'ane hutileh. 'Enne 'uhuja 'uk'enus hoonzoo-un bugha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mbene la yo údudildzunne, 'enne ndi yun k'ut buch'e' whutale 'et huwa 'enne 'uk'enus hoonzoo-un bugha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mbe la Yak'usda ye ts'ih'un 'unt'oh-i tube yuka' ninzunne, 'enne ndet hukwa' whuninzun-un, 'et bugha óotalts'ulh. 'Et huwa 'enne 'uk'enus hoonzoo-un bughá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mbe la 'uyoonne gha te'ninzunne, 'enne Yak'usda cha bugha te'untazeh, 'et huwa 'enne 'ukenus hoonzoo-un bughá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mbene la oodzi dutsun lhilohne, 'enne k'at le Yak'usda huti'elh 'et huwa 'enne 'uk'enus hoonzoo-un bughá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mbe la ts'ih'un lhts'un 'uhoot'e'ne, 'enne Yak'usda buzkeh ubodutánelh. 'Et huwa 'uk'enus hoonzoo-un bughá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mbene la ts'ih'un 'uhint'oh huwa dzoh nubuhulhdehne, 'enne yak'uz k'une' whul'en-un, 'et buch'e' hinli. 'Et huwa 'uk'enus hoonzoo-un bughá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nkede suba dune nohch'az yahutilhduk 'ink'ez dzoh nunohotilhdzut, 'ink'ez ts'iyaitsuk whuts'it khuni dutsun-i be nohch'a 'uts'un un'a yahutilhduk, 'et si sgha whuz un'a dune dzoh nunohulhdzut de, 'et 'uk'enus hoonzoo-un nohghá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","'Et 'andit whuts'un k'udada whunúlhni 'ink'ez 'uk'enus hoonáht'i'! 'Alha yak'uz hooncha whe nohba k'elha whutaleh. Soo cho whunulh'en, njan mbe la nohtso nus hoo'en inle'ne, 'enne cha whuz un'a za bube huzula inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nohni ndi yun k'ut lubeshi 'ulh'enne buba lisel leaht'oh. 'Et hoonts'i lisel 'aw nalhuwhúlhnih 'ulhih te, nts'en'a suba doo cha lisel oonawhúlni' naoodle'? 'Et whuz un'a 'aw hoonli ba lhe'ízoo' whe 'unt'oh. 'I 'ants'i dune tehúyulhkuk 'ink'ez hik'unúdilh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ndi yun k'ut dunene buba be hoot'en-i le'aht'oh. 'Aw keyoh whuti dzulh k'ewhah'ai de, 'aw whuntoolh'ih ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","'Et whuz un'a za dune ndi too dizk'un naidulhk'an 'ink'ez 'aw chalhyal yunedóo'alh ait'oh. 'Et k'us lutab k'eyíta'alh 'ink'ez kwun 'i gha ts'iyanne huwhuntilh'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","'Et whuz un'a za nts'en'a la dune ba be hoot'en-i unli, 'et whuz un'a nohni cha nohedútadi. 'I be nohe'ut'en unzoo-i daldzoo' la, 'et whuz un'a dune yuntilh'elh 'ink'ez nohBá yak'uz usda-un, 'en 'uk'enus hidutálhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moses be 'udustl'us 'ink'ez nus hoo'enne bube' 'udustl'us 'i gak natiselh 'et hukwa whusásya noohzin junih. 'I ts'iyawh lhadútisdleh 'et hukwa whusásya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Alha' dusni whe nohdusni, Moses be 'udustl'us Hebrew bughuni k'un'a hoont'um-unyaz whe 'uk'eguz-un 'ink'ez hoont'um-unyaz usgus-un, ndet 'uwhulhni, 'et ts'iyawh 'et ndúhooja de, 'et whuts'un 'aw ndi yun 'ink'ez yak'uz cha 'etsul 'uhóneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndai khuni neghalts'ut-i, 'i k'une' ts'oot'en huba' hoont'oh, 'aw hoontsool-unyaz hoonts'i dune k'uhinínyuz de, 'ink'ez 'uyoonne cha whuz un'a za whubodutilh'eh, dune ndut'en de, 'et nts'e la yak'uz k'úne' whul'en-un, 'en 'aw hoonli lhiloh-un hidutánelh. 'Et hoonts'i ndi khuni netl'adilts'ut-i, dune ts'iyawh hik'une' 'ut'en de, 'ink'ez 'uyoonne cha whuz un'a 'az whubodutilh'eh, dune ndut'en de, 'et nts'e la yak'uz k'úne' whul'en-un, 'et 'i be ncha-un 'unt'oh hidutánelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ts'ih'un nohdusni ndunne Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene cha, 'enne hiye ts'ih'un un'a 'unt'oh-i 'ink'ez nohni be ts'ih'un un'a aht'oh-i, 'i buba nus ahzoo de, 'et de za nts'e la yak'uz k'une' whul'en-un ts'e ts'u tíhdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“'Et whutso da' whulh udahts'o nts'en'a dune daja hutni whe nja duhutni, ‘Dune solhghelh junih,’ 'ink'ez mbe la dune silhghi-un, 'et hukw'un'a buba nahutiyeh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Et hoonts'i sich'oh 'unohdusni, mbene la 'ants'et dulh dune bulh hunilch'e de, 'enne ts'iyawh buba nahutideh whe' hoont'oh. 'Et mbe la dudulh dunene ‘Raca!’ 'ulhníne de, 'et ndi khuni dakelh k'un'a ‘ntsi'!’, ni whe 'utni, 'i gha nahiyilh-un but hutiyin. 'Ink'ez cha za mbe la dune, ‘Whuzini dune inli whe 'int'oh!’ yulhni de, mbe la ndutnine, 'enne tube whewhúnujut-un kwuncho yo ts'u buhutinoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Et huwa hoonliyaz loodel k'ut howa' tán'alh-i, 'ink'ez nyulh dune hoonli-unyaz whe nch'az ditni t'eoonínzun de, ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'et whutso nyulh dune bulh k'eke nalhoolhtselh. 'Et hukw'elh'az 'et 'andit za ndai la loodel k'ut huwa' tan'alh-i, 'et huwa óon'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Et khun dune hoonli-unyaz whe nch'az ditni de, 'aho oots'un ts'ih'un na'honleh. 'Et nahiyilh-un but nényutalhtelh 'et whutso ndóneh. 'Et 'aw ndúlhinel de, 'en mbe la nch'az ditni-un, 'en nahiyilh-un but nényutalhtelh. 'Et nahiyilh-un, 'en neilhchuk-un tl'anyutilhtelh 'ink'ez nch'az dána'duta'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ts'ih'un un'a nohdusni, ndai la ts'iyaitsuk ook'elha whutilhtselh 'et whuts'un, nts'en'a suba whuch'a naoohja'? 'Aw oohneh ait'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“'Et whutso da' whulh udahts'o nts'en'a dune daja hutni whe nja dúhutni, ‘'Uyoon ts'eke bulh ninta' ont'en junih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","'Et hoonts'i sich'oh 'unohdusni mbe la ts'eke yunilh'en whe dudzi yo whe nja duninzun, ‘Bulh nínta' tist'elh hukwa' nuszun,’ 'et 'uda' yulh ninta' ant'en whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Et nailhni ts'e nyuna 'i be lubeshi inla de, hanón'alh 'ink'ez 'un ntolh'is. 'Et 'on nus soo' hoont'oh nohyust'e ndulcho dutágun-un whanus soo' hoont'oh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Ink'ez nailhni ts'e nla be nínta' nint'en de, k'ont'as 'ink'ez 'un tolh'is. 'Et 'on nus soo' hoont'oh nohyust'e ndulcho dutágun-un whanus soo' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“'Ink'ez 'et cha ndutni ‘Mbe la du'at 'etsul 'utilelh-un, 'et du'at 'udustl'us ye 'etsul itilelh-i yutl'ayóolhchoos huba' hoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","'Et hoonts'i sich'oh 'unohdusni oo'at 'uyoon dune bulh ninta' 'ant'en hukw'elh'az 'et huwa za ndi 'udustl'us dai la ye 'etsul itilelh-i yutl'ayóolhchoos huba' hoont'oh. 'Et whuz un'a ndúlhinel whe du'at 'etsul 'uyinla de, 'et de dich'oh du'at ninta' 'ant'en-un yulhtsih. 'Ink'ez ndun ts'eke 'uyoon dune ghu nasda de, 'et ndun dune 'en cha ninta' ut'ih-un unli whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“'Et doo cha za niz de whudizulh da' ts'iyawh t'eoonáhzun 'uda' dune daja hutni whe nja duhutni, ‘Khun nyunch'oh nghuni k'ónyis junih. 'Et k'us neMoodihti whe oots'u nahizinya 'et whunilhchoh hukw'un'a 'ont'en huba' hoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","'Et hoonts'i sich'oh 'unohdusni, khun whuz un'a te ndudóohni junih. Khun ‘Yak'uz whunalh 'udusni,’ doohtni' junih. 'Alha yak'uz ts'e Yak'usda kw'uts'uzda cho dizti'-i, 'i 'et us'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","K'us ‘Ndi yun k'ut whunalh dusni,’ doohtni' junih. Yak'usda duke yuk'udílh'ez-i, 'i 'unt'oh 'et huwa. K'us khun te ‘Keyoh Jerusalem whunalh 'udusni,’ doohtni' junih. Lerwe k'us dizti'-un ookeyoh whucho 'uhoont'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","K'us khun te ‘Whe khusna-un whenahoosyeh,’ junih. 'Aw 'ilhudzin hoonts'i 'aw huwa naoodooh'ah ait'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Et k'us ndiz un'a nja dúdoohtni, 'et 'awet ‘A,’ dahni, ‘A,’ 'unt'oh. 'Ink'ez ‘'Awúndooh,’ dahni de cha, ‘'Awúndooh,’ 'uhoont'oh. 'Et 'uts'un un'a 'udutihnelh de, 'et de ntsi'-un ts'u hadutídoh whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“'Et whutso da' whulh udahts'o nts'en'a dune daja hutni inle' whe nja duhutni, ‘Dune oona hoos̱'en silhtsi de, nyunch'oh nyúna be hoos̱'en tanleh. 'I be kw'elha whutalhtselh. 'Et ooghu dádilhchus de, nyunch'oh nghoo be kw'elha whutalhtselh,’ hutni inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","'Et hoonts'i sich'oh 'unohdusni, dune ntsi'-un k'ól'en junih. 'Et k'us mbe la nailhni ts'e nohnizkuk de, 'et 'intl'us ts'e oots'un nándunont'ah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Khun mbe la nts'oot'an nahiyilh-un but nts'u yuka 'utni de, ndzoot 'i cha ooghá yolhchoos. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","'Et mbe la dune dawhuldzoh la ha tányalh nyulhni de, 'et nat 'et 'uwhuldzoh ts'e bulh haóonya'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","'Et mbe la hoonliyaz nts'u há' 'utni de, 'i ooghá yon'alh. Hoonliyaz dughu sinla-un yulhni de, khun ooch'az naool'ah junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Njan cha whulh údahts'o nts'en'a dune daja hutni whe 'et nduhutni, ‘Nyenghoh whut'i-un ook'eoontsi' 'ink'ez nch'az ditni-un, 'en oots'u doni'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","'Et hoonts'i sich'oh 'unohdusni, nohch'az ditnine hoonts'i buk'eoohtsi'. Mbene la denóhdulene, 'enne khuni unzoo-i be bubulh yaóolhduk. Mbene la nohts'u dutnine, 'enne buts'un oohzoo'. 'Et mbene la hoontsi'-un nohts'un ne'hut'en 'ink'ez dzoh nunohulhdzutne, 'enne cha buba tenadoohdli huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","'Et whuz un'a ts'iyanne whunúlhtun nohBá yak'uz usda-un, 'en buzkeh ahli whe 'aht'oh. 'Alha Yak'usda ndi sa ntsi'ne 'ink'ez unzoone lhgha ndi sa buk'idindi. 'Ink'ez ts'ih'un 'unt'ohne 'ink'ez ts'ih'un lhe'it'ohne, 'enne cha lhgha buk'ut nawhúlhtih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ndiz un'a nja duhoont'oh, mbene nohk'entsi'ne, 'enne za buk'ehtsi' de, di suba nohgha óokat? Gak! Ndunne sooneya nalhdzoohne, 'enne cha whuz un'a za nduhut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Ink'ez nohulhutsinke, 'enne za hadih budahni de, 'et 'uyoonne anus ahzoo na'dunáhzun eh? Gak! Ndunne sooneya nalhdzoohne, 'enne cha whuz un'a za nduhut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ndiz un'a nja dútiht'elh, nohBá yak'uz usda-un, 'en dant'oh whe ts'ih'un 'unt'oh, 'et nohni cha whuz un'a za 'ooht'e' huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Soo cho huwahli! Khun tel'enne gha' tih'alh de, ts'et whucho ndóht'en junih. 'Et whuz un'a ndaht'en de, nohBá yak'uz usda-un, 'en 'aw nohba k'elha hoolhtselh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'Et huwa tel'enne gha' tih'alh de, khun ts'iyanne nalh tube cho whe' 'ududolhti' junih. Ndunne duba na'udzoo'ne, 'enne 'et whuz un'a 'et duhút'en. Lizwif bulugliz k'us ti whulheguz-un 'et ts'iyanne ubunoolh'en ha, 'et nduhut'en. 'Alha' dusni, mbene la ba k'elha whutalehne, 'uda' buba k'elha whuzdli' whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","'Et hoonts'i tel'enne gha' tih'alh de, mbene la 'uk'enus nohts'un unzoone, 'enne hoonts'i bunanto 'oohneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","'Et whuz un'a 'uyoonne t'ehonúszun 'et daht'en whe tel'enne gha 'áh'aih. 'Ink'ez nohBá yak'uz usda-un, 'en dahoont'oh huwa 'et ndaht'en-un, 'et ts'iyawh nohnilh'en whe 'unt'oh. 'Et huwa dich'oh ts'iyanne but hoonzoo whe nohba k'elha whutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“'Et tenadahdli de, khun duba na'udzoo'ne k'oh ts'e tenadoohdli junih. 'Enne whuz un'a lizwif bulugliz cha nódilhya, k'us ti whulhetoh cha, 'ants'i huhóont'i' whe whuz un'a tenahududli ts'iyanne ubunoolh'en ha. 'Alha' whe nohdúsni, mbe la ndut'enne buba k'elha yutáleh, 'i 'uda' buba k'elha yuzdli' whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","'Et nohni tenadutihdli de, nohnich'oh whaht'i-un, 'et danaoohdilh 'ink'ez dána'dihtan whe tenadoohdli. 'Et ndaht'en de 'et la nohBá lhist'en-un, 'en 'unt'oh, 'et nts'en'a la 'et ndaht'en de, ts'iyawh nohnilh'en. 'Et huwa dich'oh ts'iyanne nalh nohba k'elha whutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","'Et tenadahdli de, lhat cho 'oh lhunahoohdeh junih. Whuz un'a lhendun keyoh whut'enne k'un'a tenahududli. 'Enne lhai khuni be tenahududli de, 'i be Yak'usda budutáts'o huninzun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Khun te 'enne buk'un'a 'udoohtni' junih. NohBá ndet hukwa oodutalhkut-un, nohtso da' t'ewhunínzun whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","'Inka ndiz un'a tenadoohdli, ‘NeBá yak'uz sinda. Nyoozi' dóti'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dahoont'oh whe lerwe inli, 'et cha nets'ó toolts'it. Nts'en'a la hukwa' ninzun, 'et ndo honeh. 'Ink'ez ndet la yak'uz ts'e hukwa' ninzun dahooja la, ndi yun k'ut cha, 'et whuz un'a za 'et dúhoneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ndai 'andit dzin uzti'ulh-i, negha nín'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Uyoonne bulh dulhyoh ts'uwhulh'ai de, buba whunats'odoolnoh. 'Et whuz un'a za nelubeshi neba oonaoodolnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Ink'ez ntsi'-un, 'en ch'a neghinli. 'Et yak'uz k'une' 'int'en-un 'int'oh, 'ink'ez be ilhtus-i cha, 'ink'ez bé dinti'-i cha, 'i 'ilhiz wheni 'i ts'iyawh nch'e' 'unt'oh. 'Et ndo honeh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","'Et dune nohdulhyoh né'hut'en de, 'ink'ez buba whunaoodúlhnoh de, 'et de nohBá yak'uz usda-un, 'en cha nohba whunaoodutilnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","'Et hoonts'i dune nohdulhyoh né'hut'en de, 'ink'ez buba whunalhoduzulhnoh de, 'aw nohBá yak'uz usda-un, 'en cha nohba whunaoodoolnoh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“'Et ndet soo hóotahnih de, mbe la duba na'udzoo'ne, 'enne buk'un'a 'ooht'e' junih. 'Et dut'enne, 'enne dudzi yo 'uhilhdzun na'hududil'i whe' hint'oh. 'Ink'ez dunin be te'hududil'en 'ink'ez dzoh nuhuzut na'hududil'i. 'Et whuz un'a 'uyoonne whúbonulhtun nts'en'a la soo huhooni hukw'un'a. 'Alha' whe nohdusni, mbe la ndut'enne buba k'elha yutaleh-i, 'uda' buba k'elha whuzdli' whe' hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","'Et hoonts'i nohni soo hóotahni de, soo cho nena'noolhdeh 'ink'ez nohtsegha cha naoolhtlo. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","'Et whuz un'a soo hóotahni de, 'et 'onghohne buch'a nonah'i'. 'Et hoonts'i nohBá lhuhoost'en ts'e hoonts'i whunilh'en, 'en ts'iyanne nalh nohba k'elha whutilhtselh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ndi yun k'ut oonáht'i'-i 'ilhoozáhle iloh. Ndulh'en de, 'ants'i k'enaditsih 'ink'ez musdziyaz cha gak yutilhtselh. 'Undunut'ihne, 'enne cha nohghu dá'hutiyus 'ink'ez hiduntit'ih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","'Et k'us ndai la yak'uz be hoonzoo' hoont'oh-i, 'i yak'uz ts'e 'et whuz 'ilhoozáhla. 'Et whuz un'a 'aw k'enádotsih ait'oh. 'Ink'ez musdziyaz cha 'aw gak yoolhtselh ait'oh. 'Ink'ez 'aw nohghu da'hooyis 'ink'ez nohghe' hundunoot'ih ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","'Et huwa ndet la oonáht'i'-i 'ilhoozáhla, ndet 'usdla-un, nohdzi cha 'et za dutá'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“'Et nena 'ants'i neyust'e ba too dizk'un le'unt'oh. 'Et nohna soo 'unt'oh de, 'et nohyust'e be hoot'en-i dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","'Et hoonts'i dune na lubeshi be untsi' de, 'et ooyust'e ndulcho whe tsalhgus be dutabun. 'Et huwa ndi be hoot'en nohbulh 'unt'oh tsalhgus k'un'a be hoodat'en de, 'et dáhoolcho-i be suba tsahólhgus oole'? ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'Aw 'ilhoghun dune nane moodih ba 'oot'en ait'oh. 'Et 'ilhoghun 'en yuts'u dutitni 'ink'ez 'ilhoghun yuk'etitsi'. K'us 'ilhoghun yuk'úne' tit'en 'ink'ez 'ilhoghun yuch'az dútatni. 'Aw Yak'usda cha k'une' 'int'en 'ink'ez sooneya cha k'une' 'ont'en ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“'Et huwa njan dunóhdusni, yinka dúlhts'i-un huwu ni oohle' junih. Ndai la tih'ulh-i 'ink'ez ndai la tihnelh-i cha, 'ink'ez nohyust'e soo naidutihleh, 'i cha, 'i ts'iyawh khun ooghu ni oohle' junih. Ndi tih'ulh-i be kháhna-i anus dizti' nahzun eh? K'us naih 'i nohuyust'e anus dizti' nahzun eh? ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ndo dut'ai núdilh-i nulh'en! 'Aw 'alhe' nusdloh 'ink'ez 'aw khit huba ilhe'osdle iloh. 'Et hoonts'i nohBá yak'uz usda-un, 'en bugha 'á'aih. 'I iloh lakw buba nus dáhti'? ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Nohni nohtoh mbe 'unt'oh dalcho tileh howu ni unli? 'Aw 'et huwa 'on nus 'ulyiz oole' ait'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","'Et huwa di ha be dune tihleh wuni ahli? 'Indaiyaz nts'en'a haniyeh, 'et howu nuni nahzut. 'Aw lhe'hust'en 'ink'ez 'aw naih cha lhe'hulh'en hiye dune tileh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","'Et nohdusni Solomon 'en hoonts'i soo nadut'ih te, 'aw 'indaiyaz anus lhe'ildzoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","'Et Yak'usda tl'o unzoo-i yilh'i. 'I 'andit dzin tl'o k'ut haniyeh 'ink'ez bunde 'i tsehidutilhkut 'ink'ez duták'un. 'Et dáhoolcho-i be nohni 'on nus soo nanohdutileh? Nohni 'aw soo cho ooba 'alha lhe'hoot'ohne 'unohdúsni! ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'Et huwa khun lhoodolhkut junih, di suba ts'oo'alh, k'us di suba ts'ootnai', k'us di suba be dune ts'oole', noohzin junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","'Alha 'udun yun k'ut whut'enne 'et za hukwa hitís'en. 'Ink'ez 'alha 'i be nohBá yak'uz usda-un, ndai hoonliyaz be ts'uwhulhdoh-i, 'et ts'iyawh t'eooninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","'Et hoonts'i nts'en'a Yak'usda nohba lerwe tileh 'ink'ez be ts'ih'un un'a 'uhoont'oh-i nohch'e' tileh cha, 'et za hukwa' nahzun de, 'et de 'on 'un-i cha njan ts'iyawh nohgha tíkulh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","'Et huwa bunde dawhútanelh, 'et howu ni oohle' junih. Bunde whusahoolts'ut de, 'et de la howu ni oohle'. Dzin totsuk soo' hoolcho hoontsi'-un whutih'elh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“'Uyoonne ba nahoohyeh junih. Doo ka si nohba nahoodeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nts'en'a 'uyoonne ba nahahyeh, 'et soo whuz un'a nohba nahutideh. 'Ink'ez nts'en'a 'uyoonne ghu nuni nahdzut, whuz un'a za nohghu nuní huntizut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'Et di ha nyulhutsin lhusyaz oona k'et diztan, 'i nilh'en, 'et hoonts'i 'aw t'eoonuzinzun nyunch'oh duchun cho nyuna k'et diztan? ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nts'en'a nyulhutsin 'udutánelh, ‘Nyuna k'elts'ut-i nyuna k'ehanaóos'alh,’ 'ink'ez nyunch'oh lhelcho-i nyuna k'et 'us'ai-i 'aw lhnílh'en? ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nyunch'oh duba na'indzoo'! 'Udechoo lhelcho-i nyuna k'élts'ut-i, 'i cho nyuna k'éhanain'aih. 'Et de la soo whunilh'en whe oona k'élts'ut-i oona k'ehanáyon'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Yak'usda ooghuni lubeshi ooghu hooloh-un, khun te lhike dult'ohne gha óoh'alh junih. K'us Yak'usda ye whúneodulh'eh-i, 'i kw'usul dizti'-i, pearl huyulhni 'et dult'oh-i, khun gugoos dult'ohne butso naóolhdilh junih. 'Et ndahja de, dulcho hik'unutílh'us 'ink'ez 'aho nohts'u náhulhya 'ink'ez yanohodutálhch'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“'Et nohdusni Yak'usda ndai la ookayoodulhkut-i nohgha íta'alh. Ookunáhta 'ink'ez nahootáh'alh. Dati dunulhkw'uz 'ink'ez nohba dáha'dutikwus. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","'Et 'oodulhkutne, 'enne Yak'usda bugha whúta'alh. Mbene la hoonliyaz hukunútane, 'enne nahahootá'alh. 'Ink'ez mbene la dati dunulkw'uzne, 'enne Yak'usda buba dáha' dutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Mbene nohbáke nohtoh, ooye' lhes yuts'u ha 'utni de, 'aw tse yughá nduno'alh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","K'us lho yuts'u ha 'utni de, 'aw 'i k'et tl'ughus yugha óot'elh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","'Et ndiz un'a nja duhoont'oh, nohni lubeshi 'ulh'enne ahli, 'et hoonts'i t'eoonahzun nts'en'a unzoo-i nohuzke gha tíh'alh. 'Et dáwhulcho-i be 'on nus ndo yak'uz nohBá, mbene la yoodulhkutne, unzoo-i bugha ti'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","'Et huwa nts'en'a hukwa' nahzun dune danohotilh'elh-un, 'et whuz un'a za nohni cha 'et ndúboolh'en. 'Alha Moses be 'udustl'us cha 'ink'ez nus hoo'enne bube' 'udustl'us cha, 'et náhoolt'oh 'et duwhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Njan datí-un hoondat-un 'et hukohdilh huba' hoont'oh. 'Et datí-un 'ink'ez ti hoontel-un, 'et kwuncho yo ts'u ti 'uhoont'oh 'ink'ez lhane whuz whedilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Njan 'et huwa 'et nduhut'en, njan datí-un hoondat 'ink'ez njan ti 'ilhiz be ts'ukhuna-un 'et howa whulna' whe' hoont'oh. 'Aw lhane iloh nahuhóo'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Mbene la whuts'it be nus hoo'enne na'dudil'i, 'enne buka huwahli! 'Usbai zuz be soo dint'ohne, 'enne buyo ts'e yus soo 'uk'enus ntsi'-i 'enne lé'hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'Et huwa dahút'en-un, 'et 'i be t'ebuntihzeh. 'Et duje isdloo whus chun gha huyoonuyin eh? K'us ndi mai, figs huyulhni, chuntoh whuduts'ul-un whutoh huyoonuyin eh? 'Awúndooh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","'Et whuz un'a za duchun unzoo-i, 'i mai unzoo-i ooghu haniyeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Ink'ez duchun dalhjut-i, 'aw mai unzoo-i ooghu hanóoyeh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ts'iya-i duchun 'aw mai unzoo-i ooghu hanooyeh ait'oh, 'i nánuhidutselh 'ink'ez hidilhk'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'Et huwa dune cha whuz un'a duhint'oh. 'Et huwa la t'ebunohzin. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“'Aw ts'iyanne, ‘SMoodihti, sMoodihti,’ sulhnine, 'aw nts'e la yak'uz k'une' ts'uwhul'en-un whuz hutooya' ait'oh. Mbene la 'uBá buts'o hukwa' ninzun tune' 'ut'enne, 'aw 'enne za yak'uz ts'e hutidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","'Et mbene la njan dzin whusahoolts'ut de, ‘SMoodihti sMoodihti, 'alha iloh lakw nyoozi' be nus ts'úhoo'en? Nyoozi' be ntsi'-i nududeh-i 'uyoonne bughu whe náts'inanyoot! 'Ink'ez nyoozi' 'i be huwa 'ít'en tune' ts'ut'en.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","'Et ndunt'ohne dune ts'iyawh budutásnelh, ‘'Aw t'enohnuzúszun. Sch'a nasahdilh! Nohni 'aw 'uk'unulhe'ust'enne aht'oh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“'Et huwa mbene la sghuni yoozilhts'aine, 'ink'ez daja dusni-un hukw'une' hut'en, mbe la dune whunih-un duyoh tse k'ut neoonin'ai, 'en k'un'a 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","'Et 'awet náhoonilhtan 'ink'ez too 'awet ulhtus suli', 'i njan yoh whut'aiznai. Nilhtsi ulhtus-i cha whudilhts'uk. 'Et hoonts'i njan yoh 'aw dalhúhoonel. Njan yoh tse k'ut whuz'ai 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","'Et hoonts'i mbene la sghuni yudits'one 'ink'ez 'aw hik'unulhe'ust'en de, mbe la dune whusni-un, 'en yoh 'ants'i sai k'ut neoonin'aih, 'en duhúlt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","'Et 'awet náhoonilhtan 'ink'ez too 'awet ulhtus suli', 'i njan yoh whut'aiznai. Nilhtsi ulhtus-i cha whudilhts'uk. 'Ink'ez njan yoh nahóolts'ut. 'Ink'ez wheóonujut whe nahóolts'ut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Et Sizi ndi khuni ye bubulh yailhduk, 'i lhaduja whe 'ilhunaoosdilne tube buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","T'eoonínzun daja ni whe whubodalh'e'. Nyoonne mbe la Moses be 'udustl'us k'ut 'uk'ununáguzne, 'aw whuz un'a hubulhodílh'el. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","'Et 'awet Sizi ndus de shus k'uz hanaja whe lhane dune yunantisdil, ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","whe dune ooka whulhjut-un, 'i leprosy huyúlhni, 'en yududizya 'ink'ez yubut nachaniti 'ink'ez 'uyulhni, “SMoodihti nyun hukwa' ninzun de, ndi ndai la be ilhtus-i 'int'i-i, 'i be suna'ilhdeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","'Et Sizi dula be yut'aiznai 'ink'ez, “A, hukwa' nuszun. Nyuna'isdeh!” yúlhni. 'Et ooka whulhjut-un, 'et 'aho soo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'Et Sizi 'uyulhni, “Khun te 'uyoonne doni' junih! 'Et k'us lubret oots'inyalh 'ink'ez ts'ih'un un'a díni nyust'e nts'en'a whe soo na'uja 'ink'ez nyunoolh'en. 'Et la Moses be 'udustl'us yuk'uyaoolhduk. 'I gha la ndai huwa tan'alh-i nyudóni'. 'Et whuz un'a ts'iyanne whubuntalhtun dainja whe soo na'inja-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","'Awet Sizi keyoh Capernaum ts'u whutni-un ts'oozya whe 'ilhoghun Rome whut'enne saldanne bumoodih, 'en yududizya whe yuts'u tedudli, ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“SMoodihti se'ustlen k'us unsool-un, 'en njan yoh yun sulhti 'aw delhdusni whe tube dzoh nuzut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","'Et Sizi yulhni, “Oots'u tisyalh 'ink'ez soo na'tisdlelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","'Et hoonts'i ndun saldanne bumoodih yulhni, “SMoodihti syoh ts'u tanyalh huba 'aw soo lhe'uzdzoo'. 'Ants'i nghuni be 'et ndúdinja de, 'et hoonts'i se'ustlen-un k'us unsool-un soo na'ootnelh la. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Alha si cha 'onghohne sando 'uhint'oh whe hukwa' huninzun tune' suhulh'en. 'Et si cha whuz un'a za saldanne buba ndo 'ust'oh. 'Et 'ilhoghun, ‘Inyalh!’ dusni de, 'et 'aho whe yaih. 'Et 'uyoon ‘'Anih,’ dúsni de, 'et 'aho sghu yaih. 'Et se'ulhna-un, ‘Nja dineh!’ dúsni de, 'et 'aho 'et ndút'ih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sizi ndun dune ndet 'uwhúlhni whulhúdants'o whe tube ba hooncha. 'Et huwa ndunne yunidulhne ubúlhni, “Israel ndulcho whe keyoh, 'aw ndun dune whuz un'a ooba 'alha' hoont'oh-un nalhizústi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'Et nohdusni ndaz de 'ink'ez nooz de lhane whusatidulh whe yak'uz k'une' whul'en-un ts'e 'et Abraham cha, Isaac cha, 'ink'ez Jacob cha, 'enne 'alhgoh lhla ná'hutit'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","'Et hoonts'i mbene la yak'uz k'une' hool'en huba 'unt'oh inle'ne, 'enne 'az tsahólhgus ts'e hubotilhdulh. 'Et ts'iyawh hutso 'ink'ez dughoo lhehídutik'us.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","'Et Sizi ndun saldanne bumoodih 'en 'uyulhni, “'Awet inyalh! 'Et nts'e whula mba 'alha' 'ust'oh, whuz un'a za mba whutánelh.” 'Et soo 'oh whuya 'uwhunit'o whe be' ustlen k'us untsool-un soo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","'Et Sizi Peter ooyoh daninya whe oo'at ooloo yunilh'en. 'Et lili k'ut sulhti dada nulwus-i be nduda. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yuzih neninya 'ink'ez yula t'aiznai. 'Et 'aho nulwus nduda oots'u hanaidide. 'Et 'aho dunadija 'ink'ez bugha ná'unt'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","'Et 'awet sa yo tiz'ai whe lhane ntsi'-i nududeh ooyudúlts'ine, 'enne Sizi highu bunínla. Dughuni be ntsi'-i nududeh-i buyáhanainanyoot. 'Et ts'iyawh mbe la ndudane, 'enne ts'iyawh soo na'binla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","'Et whuz un'a Isaiah nus hon'en whe ndutni, 'et ts'iyawh 'et ndúhooja. 'Et huwa njan nja dutni, “Ndai la tetsun neilh'i-i, 'i ts'iyawh neghu nayílhchoot. 'Ink'ez nedada' cha 'et ts'iyawh nets'u hanáhonla.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","'Et 'ilhunaoosdilne ts'iyawh hinasguz. 'Et Sizi whunalh'en whe 'et mbene la yulh 'ut'enne, 'enne ts'iyawh ubulhni, “Nyan uztooke'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","'Et 'ilhoghun Moses be 'udustl'us 'uk'ununáguz-un, 'en yughu ninya whe 'uyulhni, “Nehodulh'eh-un nts'oh tula nutányalh, 'et dulcho nyunún tisyalh hukwa' nuszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","'Et Sizi 'uyulhni, “Soo cho howu nuní ninzut! Nanguz 'enne cha 'an whut'i whe' 'unt'oh 'ink'ez dut'aiyaz cha t'o ut'i. 'Et hoonts'i yinka dune ye', 'aw hukw'ut tsén tal'alh-un 'et hoonts'i lhuhóot'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","'Et 'uyoon yugha hodul'eh-un, 'en 'uyulhni, “SMoodihti sba silh'i. 'Udechoo 'ubá 'aoostelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","'Et hoonts'i Sizi 'uyulhni, “K'at whute, sunanyalh. Dudulh yaidlanne didutch'oh 'analhuhoolyelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","'Et 'awet ts'i beinya 'ink'ez yugha hodul'ehne, 'enne ts'iyawh hiyulh 'úja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nus huzki ibulh bubulh taoodilts'ut 'ink'ez 'awet ts'i be tawhendunitih, 'et hoonts'i Sizi 'en nanisti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'Ink'ez yugha hodul'ehne, 'enne hits'u whindil ts'enahuyulhts'it. “NeMoodihti netalhyis! 'Awet too netighan!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","'Et 'ubulhni, “Di ha whénulhjut? 'Aw bé 'alha' whut'en-i soo 'últus-i lhaht'i' whe' dahni.” Dudinya whe khuniti be hukwa' yudáni' too 'ink'ez nilhtsi bulh yatilhduk, 'ink'ez 'awet dinghel. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","'Et nyoonne dune buba hooncha whe 'ulhodutni, “Ndun dant'oh-un dune suba 'unt'oh? Nilhtsi 'ink'ez tatsi bulh 'i hoonts'i hik'une' 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","'Et 'awet nyan hoozki whe ndunne Gergesene buyun k'ut huwhutni, whuz hoozdil. 'Et nane dune highu nin'az. 'Enne ntsi'-i nududeh-i buyudinda. Ndet la nezi 'ahule-un, 'et whuz de hahán'az. Soo ts'ih'un 'uhuninzun k'et 'aw dune buzih noya' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","'Et khunsul tube cho 'uhutni, “Sizi nyun Yak'usda ooYe' inli whe 'int'oh! Ndet nets'u hukwa' ninzun? Nkede neba whusaóotilts'ulh-un whutso, dzoh nunetalhdzut ha 'inja whusainya?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Et njan howu nilhdza'-un, gugoos huldlai ndi ndai la butl'ahidantsut-i, 'i huyu'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","'Inka ntsi'-i nududehne, 'enne hits'u tedudlih whe huyulhni, “Whusanáneuntanyulh de, 'et de nghuz gugoos yúzdoodilh-un netl'ahón'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","'Et “Ahdulh!” ubulhni. 'Et 'awet ntsi'-i nududeh-i ndunne dune buts'u haídande whe gugoos yudande. 'Aho gugoos bubulh whenghu hilghaz 'ink'ez too ubanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","'Et ndunne gugoos ghunline, ts'iyawh 'aho keyoh ts'e whehílghaz. 'Ink'ez keyoh whut'enne ts'iyawh bubodáni' dahooja la. Nyoonne nane mbene la ntsi'-i nududeh-i ooyudande inle'ne, 'et dahuja la whunilhchoh hubodáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'Aho za 'et keyoh whut'enne, ts'iyawh 'az whehilghaz 'ink'ez Sizi dodizdil. Hitilh'en ibulh njan buyun k'ut whuch'a naóoja', 'et hukwa hits'u tedudli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Sizi 'et 'awet ts'i benya 'ink'ez nyan yahúzkih nts'e la dich'oh dukeyoh ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","'Aho 'awet ndun delhdusni-un, 'en lili be whusaháyankai. Sizi ubunilh'en 'ink'ez t'eooninzun buba 'alha' hoont'oh. 'Et délhdusni-un yulhni, “Hadih ts'oodun, do 'un dunilt'i! Nlubeshi ts'iyawh mba hooloh suli'!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","'Et 'aho za whulohne Moses be 'udustl'us 'uk'ununáguzne 'ulhodutni, “Ndun dune Yak'usda ch'az yalhduk whe 'utni!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","'Et daja huninzun za Sizi 'et ts'iyawh t'eooninzun. 'Inka ubulhni, “Di ha nohdzi yo whe ntsi'-i za ghu nuni nahzut? ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nts'en'a suba huwa lhúhoolna' k'un'a uzdooni'? ‘Lubeshi mba hooloh suli',’ k'us, ‘Dudinyaih 'ink'ez inyalh’? ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","'Et njan t'eoonóhzin yinka dune ye', 'en ndi yun k'ut ooba' hoont'oh whe 'unt'oh lubeshi 'un toolhdilh huba' hoont'oh whe 'unt'oh,” ubúlhni. 'Ink'ez ndun delhdusni-un, “Dudinyaih 'ink'ez kw'usinti-i nailhchoot 'ink'ez nyoh ts'e naindalh!” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","'Et 'aho za dunadija 'ink'ez duyoh ts'e whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","'Et 'ilhunaoodúlhne ts'iyawh buba hooncha 'ink'ez Yak'usda hudílhti', dunene, 'enne cha butl'ahon'ai whe buba hót'e' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","'Et hukw'elh'az Sizi 'oh whuya lhuseya whe ndet la sooneya naldzooh-un, 'et 'ilhoghun dune Matthew huyulhni, 'et usda whe yunilh'en. “Sunanyalh,” yulhni. 'Et dudinya 'ink'ez hik'oh ts'e oot'en ha yuntizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sizi yeyoh ts'e daninya 'ink'ez buzih usda bula na'utit'ulh. Sooneya 'ilhunaoos'aihne 'ink'ez lubeshi 'ulh'enne, 'enne cha yoh dahunindil 'ink'ez Sizi 'ink'ez yugha hodul'ehne bubulh bulanahut'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","'Ink'ez nyoonne Phariseene hinilh'en whe yugha hodul'ehne bubuhoodulhkut, “Nohodulh'eh-un, 'et di ha sooneya 'ilhunaoos'aihne 'ink'ez lubeshi 'ulh'enne cha bubulh na'ut'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","'Et Sizi bubulh údants'o daja huyulhni-un 'et ubúlhni, “Mbene la soo 'únt'ohne 'aw yoo be duyun halhe'hunizun. Ndudáne, 'enne za yoo be duyun ha' huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","'Et huwa ahdulh ndet la hodulh'eh-un 'et noheni toh neoonahle 'et 'uk'uwhusguz whe nja dutni, ‘'Uyoonne gha te'ntihzilh 'et nohts'o hukwa' nuszun. Ndai loodel k'ut hidutalhk'un-i, 'i ooka lhe'núszun.’ Si cha whuz un'a za 'aw ts'ih'un 'unt'ohne, 'enne bubeni naháhundunooleh huba iloh sásya. 'Et lubeshi 'ulh'enne, 'enne dulubeshi ch'a bubeni naháhundunooleh ubudutásnilh ha, 'et huba whusásya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","'Et 'awet John yugha hodul'ehne, 'enne Sizi ts'u hoozdil whe huyoodulhkut, “Dáhoont'oh huwa wheni cha 'ink'ez Phariseene, 'enne cha lhat soo ts'úhoni. 'Ink'ez nyun ngha hoodulh'ehne, 'enne gak?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","'Et Sizi ubulhni, “Mbe la oo'at whutaleh-un, 'en ook'ekene, 'awhuz huyulh 'unt'oh, 'enne cha eh soo húhootanih? 'Awundooh! 'Et hoonts'i 'oh de de ook'ekene buch'a nahuyitálhtelh, 'et de za soo húhootanih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","'Ink'ez cha, 'aw 'uda'-i dzoot 'aw 'andidi-i naih be naoolhkut ait'oh. 'Et nyoo 'andidi-i naih naootáltsulh 'ink'ez oots'u hanaitich'ulh. 'Et de 'on nus hootátsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","'Et doo cha, 'aw ts'ekoo too' 'andidi-i 'aw 'ujut-i 'uzus be yóolhdzeh ait'oh. 'Et déyinla de, 'aho la bulh hóok'uholtalh. 'Et nyoo 'andidi-i ts'ekoo too' ts'iyawh nadutijulh, 'ink'ez ndi 'uzus 'i cha ninta' tit'elh. 'Et 'andidi-i ts'ekoo too', 'andidi-i 'uzus be húyalhdzo de, 'aw whe ninta' oot'en-un hooloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","'Et nja dahooja la 'awhuz howu yalhduk whe khunsul 'ilhoghun moodih yughu ninya 'ink'ez yubut nachániti. 'Et ndúyulhni, “Stse' 'andit za dazsai. 'Et hoonts'i soo tilah syoh ts'e tónya', 'ink'ez nla be ookw'édolni, 'et de la nakhátna'!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","'Et Sizi dudinya 'ink'ez yuntizya. Yugha hodul'ehne, 'enne cha ts'iyawh huyulh 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","'Et 'oh whuya hidulh whe khunsul 'ilhoghun ts'eke, 'en whunizyat 'on 'at nat yus k'ut inle' whe 'uskai' 'uyulh'en. Ndun ts'eke Sizi yut'a ts'e gha ninya 'ink'ez nayits'uz-i nyus ts'e yuban whut'aiznai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","'Et njan 'et dutinelh whuts'o dich'oh na'dudútni, “'Ants'i oonaih oot'aizasnai de, 'et de la soo ná'tisnelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sizi yuts'u nálh'a 'ink'ez yunilh'en 'ink'ez 'uyulhni, “Stse' do 'un dunilt'i! Be 'alha' hoont'oh-i mba 'alha' 'unt'oh 'et huwa soo na'inja.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","'Et 'awet Sizi ndun moodih ooyoh ts'e daninya whe ndi be ts'ujun-i, flute huyulhni, 'i hiye ujun whe bunilh'en. 'Et 'onghohne tube tahúditni whe tso yahalhduk whe ubúlhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","“'Az náhdulh! Ndun ts'ekeyaz 'aw dálhitsal, 'ants'i nanisti whe 'unt'oh.” 'Et highudloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","'Et dune ts'iyawh 'az whenábahalh'a'. Sizi yoh ts'e daninya whe ts'oodun yula ilhchoot ibulh dunadija. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","'Et dahooja la, 'et yun k'ut ndulcho whe 'et hukw'u nahuwhulnuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","'Et 'awet Sizi natisja whe nane dune hoos̱'enne hiyuntiz'az 'ink'ez hikazulh, “NeMoodihti David oots'u hainzut-un negha te'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","'Et Sizi yoh ts'e daninya whe nyoonne hoos̱'enne huyudánin'az. 'Et Sizi ubúlhni, “Nohba 'alha' hoont'oh eh njan 'et dutísnelh huba?” 'Et 'uhuyulhni, “A, neMoodihti!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Buna yut'aíznai 'ink'ez ndúbulhni, “Nts'en'a la nohba 'alha' hoont'oh, whuz un'a 'uhóneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'Et 'aho nahitát'en 'ink'ez honilh'en. Sizi khuni ulhtus-i be ndúbulhni, “Khun 'uyoonne dóhni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","'Et hoonts'i tenáhunt'az 'ink'ez ndi 'oh keyoh ndulcho whe ts'iyanne hudáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","'Et tenáhundil whe 'ilhoghun dune 'aw yalhulhduk-un, ntsi'-i nududeh-i ooyudinda 'et huwa. 'En Sizi highu hinílhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","'Et ndun ntsi'-i nududeh-i ye yáhanainanyoot. Nyoon dune 'aho yawhénilhduk. 'Et 'ilhunaoosdilne 'ulhodutni, “Israel yun k'ut ndulcho whe 'aw ndiz un'a lhe'whusne 'et 'andit ts'iya 'et 'udechoo ndúhooja!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","'Et nyoonne Phariseene nduhutni, “'Ants'i ntsi'-i nududeh-un, 'en bumoodih ye ulhtus-i, 'i gha ndi nududeh ntsi'-i yuts'u hanaínanyoot!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","'Et 'awet Sizi njan keyoh whuti 'ink'ez keyoh whuyaz cha whunilhchoh nusiya. 'Ink'ez lizwifne bulugliz ndi khuni unzoo-i be yak'uz k'úne' whul'en-un, 'en ghun whubodulh'eh. 'Et dunene mbene la ooyust'e ndudane 'ink'ez tetsunne, 'enne ts'iyawh soo na'bulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","'Ink'ez 'ilhunaoodilhne ubunilh'en. 'Enne ts'iyawh nehunintsai dóhot'en, 'aw 'uhooneh ait'oh. 'Ink'ez ts'iyaitsuk laditnine dohot'en. 'Ants'i 'usbaiyaz lhane 'aw bughunli-un hooloh le'hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","'Ink'ez yugha hodul'ehne, 'enne ubulhni, “'Alha 'awet ha' nukat-un newhúninzut 'ink'ez tl'o mai' lhai suli', 'et hoonts'i 'ut'enne 'aw soo lhe'huniltsuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'Inka Yak'usda ha' nukat-un whumoodih, dich'oh 'a'dudinla-un, 'uyoonne 'ut'enne cha whusáboolh'a', 'et huba tenadoohdli,” ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","'Et whunizyane 'on 'at nane Sizi yugha hodul'ehne, 'enne 'alhgoh 'anih ubudáni'. Ntsi'-i nududeh-i 'enne ts'iyawh ndet la whehílhtus-un cha, 'ink'ez k'une' bool'en ha, 'et cha, 'ink'ez ndet hukw'e húndudá-un cha, 'et ts'iyawh 'et whuch'a soo na'botilh'elh, 'et cha ts'iyawh butl'ahón'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Njan 'et whunizyane 'on 'at nane whel'a'ne buboozi' 'uk'eítagus; 'udechoo Simon, 'en Peter cha huyulhni; 'en bulhutsin 'en Andrew huyulhni; 'et doo cha James cha Zebedee ooye', 'ink'ez John 'en cha 'en bulhutsin 'unt'oh; ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Philip 'ink'ez Bartholomew; Thomas 'ink'ez sooneya nalhdzooh-un Matthew huyulhni; James 'en cha Alphaeus ooye' 'unt'oh, 'ink'ez Lebbaeus 'en ooboozi' 'udek'ez-un Thaddaeus huyulhni; ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'et Simon cha, 'en Canaanite yun k'ut whut'en-un 'unt'oh, 'ink'ez Judas Iscariot 'en 'uja Sizi be 'onket-un 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","'Et 'awet ndunne whunizyane 'on 'at nane, 'enne nts'e la 'uhutit'elh Sizi whuz ubutilh'alh. 'Et la khuni ulhtus-i butl'adan'ai whe ndubulhni, “Khun 'udun yun k'ut whut'enne buti ts'u te toohdilh junih. 'Ink'ez Samaritan bukeyoh ts'uti whuz te toohya' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","'Et k'us Israel oots'u haindene, 'enne 'ants'i 'usbai ninta nilh'az-i lé'hint'oh, 'enne za buts'un toohdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Et 'awet ahdulh whe butoh lhohdilh, njan 'et budutáhnelh, ‘Nts'en'a la yak'uz k'úne' whul'en-un 'awet nilhdukw.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ndudáne 'ink'ez ooka whulhjutne, leprosy huyúlhni, 'enne cha ts'iyawh soo na'boolh'en. Yaidlanne cha dunabudóhlelh. Ntsi'-i nududehne, dune buts'a hanábunuhyukw. Ndai la 'ants'i nohgha nkat-i, 'i cha 'ants'i huwaóohle. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Khun te sooneya nohsooneya zus be óohdzaih junih! ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Khun tihdulh de hoonliyaz toohla' junih. Lhook'ez 'ink'ez be kélh'a-i cha 'ink'ez nanki ts'oozt'an 'ink'ez nohtuz. 'Alha 'ut'en-un nts'en'a la ne'ut'en, 'et whuz un'a za nohni cha ooh'alh huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ndet la keyoh ts'u tihdulh 'et keyoh whuyaz k'us keyoh whuti, 'et ndunne keyoh whut'enne, 'enne hukwa boodolhkut k'us mbe suba dune oodzi unzoo, 'en ooyoh dólhts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Et ooghu danáhdil de, mbene la yoh dilhts'ine ts'iyawh hoonzoo-un nohghá holts'it-un, nohba hukwa' nídzun, 'et whuz un'a 'et dubúdohni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Et ndunne yoh 'et dilhts'ine, 'enne huhóont'i' whe bughu danáhdilh de, 'et nohdzi dant'oh la, ts'iyawh buts'ú be holhnih. 'Et 'aw 'et ndulhúhit'oh de, daja ubudáhni-un, 'aw whe la'hootneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Et mbene la 'aw nohghu nulhúhiyal 'ink'ez lhunoh huhoozilhts'ai de, 'et yoh tenaoohdilh 'et nyoh keyoh whuti 'et cha whuch'a naoohdilh. 'Ink'ez nohke ts'iyawh lhez ch'a naoohghat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Alha nohdusni ndet dune ba nahidzilh-un whusahoolts'ut de, ndunne Sodom whut'enne 'ink'ez Gomorrah whut'enne cha, njan keyoh whut'enne mbene la nohghu núlhiyalne, 'enne 'on nus 'uwhultsi'-un bugha óotalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Soo zulhts'ai, 'ants'i 'usbai yus yugha óolh'az le'hoont'oh ts'e whuz nohtis'a'. 'Et huwa tl'ughus k'un'a duwhunih áhlih 'ink'ez ndi dut'ai, dove huyulhni, 'i k'un'a nohbulh dune ndólhda' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Whulohne dune buch'a kháhdli. 'Enne Lizwif nahiyilhne, 'enne bubut nenóhotalelh. 'Ink'ez Lizwif lugliz whambez ts'e 'et nohohóotalhtsus. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","'Et 'ants'i yun k'ut whumoodihne 'ink'ez lerwene cha si sgha 'enne bubut nenóhotalelh. 'Ink'ez si sghun whubuntilhtun. 'Udun yun k'ut whut'enne, 'enne cha si sghun whubuntilhtun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Et 'awet whutl'anohuhanla de, nts'en'a la daja dutihnelh, 'et huwu ni oohle' junih. Nts'oya hoozulh whu la ndai la be yátilhduk-i, 'et la t'ewhunoohzeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","'Alha 'aw nohnich'oh iloh yatilhduk. NohBá ooyughi 'i 'udutinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","'Et dune dulhutsin datítsah ha whutl'aítilhtelh. Bubá 'en duduzkeh cha whuz ubutilelh. Bubuzkeh dudusneke cha buch'az nehúdutadulh 'et whe dahutitsah-un huwá botalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","'Ink'ez si soozi' gha ts'iyanne nohts'o dutitni. 'Et hoonts'i mbene la 'udek'ez whuts'un 'et whulh núdalya'ne, 'aw 'enne za hudutijih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","'Et hoonts'i njan keyoh 'enne dzoh nanóhahulhdzut de, 'et 'udun keyoh ts'e buch'a tóohdilh. 'Et keyoh whuti 'et cha dzoh nunohohulhdeh de, doo cha 'on 'un keyoh buch'a tóohdilh. 'Alha' dusni 'et yinka dune ye' whusatiyalh whutso, 'aw njan Israel oots'u haindene, 'enne bukeyoh ts'iyawh whutulhóhdilh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Dune yugha hodul'eh-un, 'aw yuba dune hodulh'eh-un ando lhe'it'oh. 'Ink'ez be 'ulhna-un, 'en cha 'aw dumoodih ando lhe'it'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Dune yugha hodul'eh-un, whuyodulh'eh-un k'un'a 'oot'e' huba' hoont'oh, 'ink'ez be 'ulhna-un, 'en dumoodih k'un'a 'oot'e' huba' hoont'oh. 'Et si Beelzebul suhútni de 'et nohni sgha hodul'ehne, nohni cha whuz un'a za 'et dunohodutánelh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","'Et huwa 'enne bube noolhjut junih! Ts'iyaitsuk lubeshi whu'iz 'unt'oh 'ink'ez ntilh'i-i, 'i ts'iyawh ts'et haóotikulh 'ink'ez ts'iyanne t'ehuntizeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Njan daja nohdusni-un tsaholhgus-un ts'et whucho howu yaoolhduk. Ndet la whu'iz whudahts'o-un, 'et bun k'ut whuts'un khuniti be howu yaoolhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mbe la neyust'e hughanne 'et 'aw nezul 'i hizoolhghelh ait'oh, 'et ndunt'ohne, 'enne bube noolhjut junih. 'Et hoonts'i Yak'usda mbe la nohzul nohyust'e bulh kwuncho yo ts'e nohtinoh, 'en za bé noolhjut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","'Alha iloh lakw ndi nanki 'uchas, 'i 'ilho sooneya ts'uditi'-i, 'et 'ultsuk 'i be oohket? A, 'alha' 'uhoont'oh. 'Et hoonts'i neBá 'aw hukwa lhe'nizun de, 'aw 'ilhoghun ndi yun k'ut naoolts'it ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","'Ink'ez nohtsigha', 'i ts'iyawh 'ilho whe t'eininzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","'Et huwa khun whenoolhjut junih. Nohni 'uchas anus dáhti' whe aht'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“'Et huwa mbe la dune nalh 'et ndutni-un, Sizi, 'en si sch'e' 'unt'oh, mbe la 'et ndutnine, 'uBá yak'uz usda-un, 'en dutasnelh, nyoon 'en sch'e' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","'Et hoonts'i mbene la dune nalh sts'ooditdlaine, si cha 'uBá yak'uz usda-un ndunne, 'enne 'aw sch'e' lhuhiloh dósni' la. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Ts'iyanne lhts'un ts'ih'un 'uhoot'e', 'et hukwa ndi yun k'ut whusásya noohzin junih! 'Aw lhts'un ts'ih'un 'uhoot'e' bugha ootas'alh hukwa iloh whusásya. 'Et ndi saluzti le'únt'oh-i, 'i bugha tís'alh 'et huba whusásya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Dune dubá ch'az nedútadalh 'ink'ez ootse' 'en duloo ch'az nedútadalh. 'Ink'ez 'en ooyas'at 'en dubiz ch'az nedútadalh, 'et huba whusásya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mbene la dune hiyoh whut'ine, 'enne cha hich'azne dutadulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Mbe la dubá k'us duloo, si sanus buk'entsi' de, ndunt'ohne, 'enne 'aw sba soo lhe'hildzoo'! 'Ink'ez mbe la duye' 'ink'ez dutse' bulh, si sanus buk'entsi' de, 'en 'aw sba soo lhe'ildzoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","'Ink'ez cha mbene la dutulalhgus lhodistel de, 'ink'ez sulhonisdulh de, 'enne ts'iyawh sba soo lhe'hildzoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mbe la dich'oh whe khuna-un, 'et hoolhyih hukwa 'ut'en, 'en whe khuna-un ts'iyawh ninta ootá'alh whe 'unt'oh. 'Et hoonts'i mbe la si sgha dich'oh ye khuna-i ninta inín'ai, 'en ndai ye khuna-i nayitá'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mbe la hoont'i' whe danyunilhti-un, 'en si cha hoont'i' whe dasúnilhti le'hoont'oh. Mbe la whesalh'a'-un, 'en cha hoont'i' whe daínilhti whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mbe la nus hoo'en-un, 'en 'et huwa dune hoont'i' whe daínilhti. 'Et nts'en'a ooba k'elha whutale, 'et ndun cha whuz un'a za ooba k'elha whutale. 'Et whuz un'a za mbe la ts'ih'un dune-un, 'en 'et huwa dune hoont'i' whe daínilhti, 'en ndet whe ooba k'elha whutale, 'et whuz un'a za ndun cha ba k'elha whutale. ");
INSERT INTO crxNTpo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Ink'ez mbene la si sgha hodul'ehne, 'ink'ez mbe la butoh k'us hukw'e'ih 'unt'oh-un, 'en sgha hodul'eh-un 'unt'oh 'et huwa dune too suk'uz yubainkai de, 'alha' nohdusni, 'en hoonts'i ooba k'elha whutale whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","'Awet Sizi whunizyane 'on 'at nane yugha hodul'ehne, ts'iyantsuk ubudáni'-un 'etsul 'udija, 'et bughu whínya. 'Uts'un keyoh ts'e whinya dune hodutilh'eh 'ink'ez bubulh yatilhduk wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","'Awet John 'alts'ut whe 'et Christ be 'ut'en k'oh whulh udants'o. 'Et huwa nane yugha hodul'ehne, 'enne John Sizi ts'u whébalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","'Et huyoodulhkut, “Nyun eh whusatíyalh-un inli, k'us 'uyoon tilah ha ts'itó'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","'Et Sizi nja dúbulhni, “John ooghu nanaht'az de, ndet hooh'en 'ink'ez ndet whudáhts'o-un, 'et ts'iyawh dóhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","'Et hoos̱'enne cha 'et huhoo'en nasdli'. Dzoh nudilhne, 'enne soo nahudilh nasdli'. Ooka whulhjutne cha leprosy huyúlhni, butsun hooloh nasdli', 'ink'ez lhe'dústs'one cha 'uhudits'o nasdli'. Yaidlanne cha dunahudidil 'ink'ez tel'enne cha khuni unzoo-i be bubulh yainduk whe' hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","'Et mbene la si sgha 'aw buba dzoh lhilel de, 'enne 'uk'enus hoonzoo-un bughá whults'ut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","'Et ndunne nane whehán'az whe Sizi ndunne 'ilhunaoosdilne, 'enne njan John ghun bubulh yawhenilhduk whe ndúbulhni, “Di tih'elh ha dune lhuhóot'ih ts'e whéhdil? Tl'o ghazilh nonulhts'i, 'i tilah tih'elh nahzun eh? ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndet suba hukwa tse hoohli whutih'elh-un? Dune naih duchut-i be soo naduja, 'en tilah tih'elh nahzun eh? Soo zulhts'ai mbene la naih duchut-i be dune unline, 'aw 'enne za lerwe yoh hudilhts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","'Et ndet whutih'elh-un hukwa tse hóohli? Nus hoo'en-un tilah? A, 'alha' hoont'oh. 'Et 'ink'ez nohdusni, nus hoo'en-un anus hoonzoo-un whunalh'en! ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ndun 'en ghun 'uk'unusguz-i 'et ndutni, ‘Soo zulhts'ai 'uyoon khuni sba na'a-un, 'en ntso tis'alh. Nts'oya la lhutányalh-un mba lhaoodutileh ha.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ts'ih'un un'a nohdusni, ts'iyanne whuzdline, 'aw John dune too be 'ulh'en-un anus dízti'-un hooloh. 'Et hoonts'i nts'e la yak'uz k'úne' whul'en-un, mbe la 'uk'enus dizti' lhiloh-un, 'en anus uncha whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Et 'oh da' John dune too be 'ulh'en-un be whe' whudit'en, 'et 'andit dzin whuts'un, yak'uz nts'e la k'úne' whul'en-un, 'et yak'uz huhoolhdil, 'ink'ez huhoolhdilne, 'enne ts'iyawh yak'uz da'hudolhdis hukwa' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","John whusatiyalh whuts'un, nus hoo'enne bube' 'udustl'us cha, 'ink'ez Moses be 'udustl'us cha, ndet daóotanelh 'et hudani', 'et 'uwhulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","'Et daja nohdúsni-un, soo nohba 'alha' whutat'elh de, ndun nus hoo'en-un Elijah whusatiyalh-un, John 'en 'unt'oh, 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mbe la oodzo hoonine, 'enne huhoozólhts'ai' huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","'Et yuk'edúdehne nts'en'a suba nohba lhzih nebosdlelh? Ndiz un'a nja duhínt'oh whe ts'oodunneyaz duhúlt'oh 'ink'ez nts'e la t'alh-i be 'ooket-un 'et hudilhts'i whe duk'ekene buts'u hahuyih whe ndúbotni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nohba ts'ujun be ts'ujun be, 'et hoonts'i neba lhnuzahdai. 'Ink'ez nohni nohba ts'odi ts'inli, 'et hoonts'i 'aw oohtso ait'oh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","'Et John dune taninya whe 'aw lhe'us'al 'ink'ez 'aw talhusnai'. 'Et highu yalhduk whe' hutni, ‘Nududeh-i ntsi'-i ooyudinda,’ dahni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Et yinka dune ye', 'en dune butaninya whe bula whé'nin'al 'ink'ez bula tawhénitnai', 'et 'uhutni, ‘Ndun 'en oocha hooncha 'ink'ez ts'ekoo too' cha 'utnai. Sooneya nalhdzoohne 'ink'ez lubeshi 'ulh'enne, 'enne buk'eke 'unt'oh,’ dáhni. 'Et hoonts'i mbene la Yak'usda gha whunih suli'ne, 'enne ts'iyawh ndi hiye whunih-i, 'i be ts'ih'un 'uhint'oh suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Et hukw'elh'az nts'e la keyoh whuti totsuk 'ut'en ncha-i ba' yílya-i, ndut'enne hukwa' budáni'. 'Aw dubeni nahándunoolelh hukwa lhe'hunízun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","'Et huwa 'utni, “Nohni Chorazin whut'enne, 'ink'ez nohni Bethsaida whut'enne, nohni cha, dawhultsi'-un 'et nohts'u hóolts'ulh! Soo cho soo zúlhts'ai! 'Uda' ndet la whunilhchoh hoolhtus-un nohnat ne'whust'en-un, ndunne Tyre 'ink'ez Sidon whut'enne, 'enne cha bunat 'et dúhooja de, 'uda' da' bubeni naháhundunooleh oole' da', 'et hoonts'i 'aw ndulhúhinel. Doso naih be húdilhts'i de 'ink'ez lhez k'ehidzih, 'et whuz un'a 'et nduhóoneh uhóoneh oole' da'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Et hoonts'i nohdusni, ndet dzin nohba whusaootilts'ulh nts'en'a la nohba nahutideh ha, 'et ndunne bubulh dawhutanelh la, 'et nohni 'on nus 'uwhultsi-un 'et nohts'u hoolts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Ink'ez nohni Capernaum whut'enne ndo yak'uz huba soo áht'oh nahzun eh? 'Awúndooh! 'Et k'us kwuncho yo ts'u nohotilhdulh! 'Alha 'uda' ndet la hoolhtus-un nohnat ne'whust'en-un, ndunne Sodom whut'enne, 'enne cha bunat 'et dúhooja de, 'enne dudzi nahondunizdla de, 'awhuz da' bukeyoh 'et whuz'ai oole' da'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'Et hoonts'i ts'ih'un 'unohdusnih, dahoont'oh-un la nohba whusaootilts'ulh-un, nts'en'a whe nohba nahutideh ha, 'et ndunne Sodom whut'enne bubulh dawhutanelh la, 'et nohni 'on nus 'uwhultsi'-un 'et nohts'u hoolts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sizi 'awhuz bubulh yalhduk whe 'et ndutni, “'UBá nyun nyudústi'. Yak'uz 'ink'ez yun k'ut huMoodihti inli. Whunihne 'ink'ez hodul'ehne, ndi 'i ts'iyawh buch'a whuntin'i. 'Et hoonts'i ts'oodunyaz le'unt'ohne, 'enne bunalhts'et hahon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Et hoonts'i 'uBá ndet 'uhóonla-un hoonínt'i'. Ndo honeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'UBá ts'iyawh stl'ahónla, 'ink'ez 'en ooYe' mbe unli ts'iyanne t'ehonúszun. OoBá 'aw 'en za t'eininzun. 'Ink'ez mbe ooBá unli, ooYe' 'aw 'en za t'eininzun. 'Ink'ez mbe la ooYe' 'onghohne ts'iyawh whubuntilhtun hukwa' ninzun de, 'en za ooba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Nohni ts'iyawh mbe la 'ut'en ulhtus-i 'ulh'enne 'ink'ez mbe la ndaz-i nulene le'aht'oh, nohni ts'iyawh diz ahdulh 'ink'ez natilhyis-un nohgha óotas'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ndai la se' 'ut'en-i, 'i ulhchoot 'ink'ez nedúht'aih le'ahleh 'ink'ez si sghun hodulh'eh. 'Aw dune dach'e nulhe'zust'en 'ink'ez ts'iyanne toh te'duduz'en 'et huwa. 'Et whuz un'a la nohzul whe nátilyis-un ooba nahóh'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ndi la úlhchoot-i, 'aw nohba oogha lhúhoolna' tileh, 'ink'ez se' 'ut'en k'oh cha hoondza tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","'Et 'awet 'ilhoh dzin 'et la lizwifne buba nalyis dzin huhoolh'i. 'Oh da' Sizi tl'o k'ut uyalh, 'ink'ez yugha hodul'ehne, 'enne cha huyulh udulh whe buye'ílts'ul. 'Et tl'o mai' huyoonuyin 'ink'ez huya'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Et ndunne Phariseene bubotilh'en ibulh Sizi huyoodulhkut, “Ngha hodul'ehne dahút'en ubunilh'en eh? 'Andit dzin nats'ulyis dzin 'uhoont'oh. 'Aw 'et nduhóot'en huba lhe'hoot'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","'Et Sizi 'ubúlhni, “'Et lerwe David daja-un 'aw lakw hukw'u yalhuzulhduk? 'Et 'oh da' David 'ink'ez yulh 'ut'enne buye'ílts'ul? ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'Et 'awet Yak'usda ooyoh daninya whe ndi lhes ndai la Yak'usda gha t'aih-i, 'i yu'alh 'ink'ez yulh 'ut'enne, 'enne cha huyan'al. Lubretne 'aw 'enne za huyoo'alh huba' hoont'oh, 'et hoonts'i David 'ink'ez yulh 'ut'enne cha nduhuja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Moses be 'udustl'us do', 'aw ook'uyalhuzulhduk whe eh dahni? Ndiz un'a nja dutni, lubret nats'ulyis-un dzin lugliz whucho dahunindil 'ink'ez 'et 'uhut'en. Nts'en'a la 'uhuhoolhdzun-un, 'et k'uhoninyuz, 'et hoonts'i 'aw buk'elhúhoolts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Whuz un'a nohdusni njan lugliz whucho 'et nohtoh 'ilhoghun whanus 'ulcho-un hoonli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","'Et 'uk'uwhusguz 'et ndutni, ‘'Uyoonne gha te'ntihzilh, 'et nohts'o hukwa' nuszun. Ndai loodel k'ut hidutalhk'un-i, 'i ooka lhe'nuszun,’ ni. 'Et ndi nja dutni-un, 'et t'eoonahzun de, 'et de mbe la ookw'elhúwhulhts'itne, 'enne 'aw buk'ehoh'alh hukwa aht'en iloh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Et huwa yinka dune ye' nats'ulyis dzin 'et hoonts'i humoodihti whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","'Et 'awet hukw'elh'az bugho whinya whe ndunne Lizwifne bulugliz ts'e daninya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Ilhoghun dune 'en 'et usda 'ink'ez 'aw oola 'aw ye nulhé'ust'en. 'Et Sizi huyoodulhkut, “'Et nats'ulyis dzin soo na'uztitnelh huba' hoont'oh eh?” 'Et whe hoonliyaz highu nahootá'alh hukwa' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","'Et ndúbulhni, “Mbe nohtoh 'utinelh 'usbaiyaz tsak'et 'álts'ut whe hanaítilhtelh nats'ulyis-un dzin 'et hoonts'i? ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","'Et dawhulcho-i be dune 'usbai anus dizti' whe 'unt'oh? 'Et huwa netl'ahóolts'ut nats'ulyis dzin 'ut'en unzoo-i 'uts'ulh'en whuba.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","'Et ndun dune ndúyulhni, “Nla lhts'e nadíntsih!” 'Et 'awet lhts'e naidizsi whe ookw'uz ts'e k'un'a sóo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","'Et Phariseene 'az whuhandil 'ink'ez huwu yahalhduk nts'en'a hituzilhghelh hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","'Et Sizi hituzilhghelh huwu yahalhduk, 'et t'ewhunanzin ibulh bugho whenaja. Lhane ndudáne hiyuntizdil, 'et ts'iyawh soo ná'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Khuni ulhtus-i be ubulhni, “'Uyoonne khun sghu yahoolhduk junih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","'Et whe la nus hoo'en-un Isaiah, daja ni-un, 'oh te ne'whust'en. Ndi khuni nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ndun sYe' se'ustlen-un, 'en 'utahásti-un 'unt'oh. 'En 'aw 'en za ookw'esi'. 'En gha szul tube yé hoont'i'. Syughi ookw'édutasdoh. 'Et nts'en'a dahoont'oh dune ba nahisyilh, sYe' whuz un'a za 'udun yun k'ut whut'enne ubódutánelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","'Aw dune budulhyoh 'udooni' ait'oh. 'Aw bubúlh 'aooldzul ait'oh. Ti nuya de, 'aw bubulh dóoltul ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","'Aw tl'oghazilh nisdus-i, 'i hoonts'i k'idóch'as ait'oh. 'Aw too dizk'un 'awet nanutneh-i, 'i hoonts'i, 'aw nainoolhneh ait'oh. 'Et 'awet Yak'usda lubeshi ba nahuyeh 'et whuch'a' nilhde de, whuz un'a za sYe' 'utit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","'Ink'ez 'udun yun k'ut whut'enne ndun sYe' se'ustlen-un, 'en boozi', 'i be 'et whut'aníhuntatan.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Et 'ilhudzin whe 'ilhoghun ntsi'-i nududeh ooyudinda-un, 'en hoos̱'en 'ink'ez yaoolhduk cha ait'oh. 'En Sizi ts'u huyoolhti whe soo na'yinla. 'Ink'ez ndun hoos̱'en-un 'ink'ez yaoolhduk cha ait'oh, 'en 'aho hoo'en 'ink'ez yawhenilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","'Et 'ilhunaoosdilne ts'iyawh tube buba hooncha 'ink'ez dich'oh lhulh yáhalduk, “'En 'alha David oots'u hainzut-un toleh 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","'Et Phariseene whulhódants'o whe 'et 'uhuyulhni, “Ndun Sizi, 'en Beelzebul, ntsi'-i nududehne bumoodih 'unt'oh, 'en be za ntsi'-i nududeh-i dune ts'u hanahinuyukw,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Daja huninzun-un Sizi t'eooninzun 'inka 'et dúbulhni, “Nts'e la yak'uz k'une' whul'en-un, 'enne lhch'a nehúdindil de, 'enne ts'iyawh gak hutileh. 'Ink'ez keyohti whudune'ne k'us yoh dilhts'ine cha, ts'iyawh lhch'az nehúdindil de, 'enne cha gak hutileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Whuz un'a za Satan didutch'oh dune ts'u hanainuyukw de, 'et 'alha didutch'oh lhch'az ditni whe 'unt'oh. 'Ink'ez nts'en'a la whulerwe unli-un, 'ilhiz whutat'elh? ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","'Et si Beelzebul 'en be 'ust'en de, 'et de sudahni nohni nohye'ke, k'us mbe suba ntsi'-i nududeh-i dune ts'u hanábonuyukw? 'Et huwa 'enne bugha t'ewhuntihzeh tank'us údahni! ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","'Et hoonts'i Yak'usda ooyughi be ntsi'-i nududeh-un dune ts'u hanánusyukw de, 'et 'alha' hoont'oh whe nts'e la Yak'usda whe lerwe unli-un, 'et 'awet nohghu whults'ut whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","'Et nts'en'a 'utinelh 'ilhoghun dune 'et dune ulhtus-un ooyoh daninya 'ink'ez hoonli yughi tálhchulh? 'Aw ooneh ait'oh. Ndun dune 'udechoo yulhghel de, 'et de za ts'iyaitsuk yughi tálhchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mbene la sulh lhe'it'ohne, 'enne sch'az huditni whe' hint'oh. 'Ink'ez mbene la 'aw dune sla 'ilhulhósdlene, 'enne ts'iyawh 'ants'i yahitákulh le'hutinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“'Et huwa 'unohdusni, lubeshi ts'iyawh 'ink'ez Yak'usda ch'az yalhdukne, 'et ts'iyawh nohba whunaoowhudutilnoh. 'Et hoonts'i Ndoni ch'az ditni be yalhdukne, 'aw buba whunaoodootnoh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ink'ez mbene la yinka dune ye' ch'az yalhdukne, daja hutni-un, soo buba 'un whutilhdulh. 'Et hoonts'i mbene la Ndoni ch'az yalhdukne, 'aw buba 'un whutoolhdilh ait'oh. 'Andit dzin k'us nus de hoonts'i 'aw 'uhoneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ndiz un'a 'uhoont'oh, mai chun unzoo-i hanálhyai de, oomai' unzoo tileh. 'Et mai chun 'utsi'-i hanálhyai de, oomai' ntsi' tileh. 'Et oomai' whuzdli' de, dant'oh-i duchun 'unt'oh, oomai' gha t'entidzeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Nohni ts'iyawh lubezo tl'ughus buzkeh le'aht'oh! Nts'en'a ahtsi' 'ink'ez khuni unzoo-i be yalhduk? 'Alha nohdzi ndai be dizbun 'i be yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Dune unzoo-un ndai la unzoo-i dudzi bez 'ilhunayodle-i, 'aw 'i za oots'u hanaídukat. 'Et dune untsi'-un, 'en ndai untsi'-i dudzi bez 'ilhunayosdle de, yalhduk te, 'aw 'i za oots'u hanaídukat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'Et nohdusni mbene la 'aw khuni lhe'it'oh-i be yalhdukne, dune ba nahidilh-un dzin whusahóolts'ut de, nts'en'a khuni 'i be yalhduk-un, whuz un'a buba nahutideh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'Et huwa nohghuni gha Yak'usda nalh ts'ih'un dune tihleh, k'us nohghuni gha kwuncho yo ts'u tihdulh k'un'a, whuz un'a nohba nahutideh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","'Awet whulohne Moses be 'udustl'us 'uk'ununáguzne cha 'ink'ez Phariseene, 'enne cha huyulhni, “Dune hodulh'eh-un neba huwa 'it'en tune' tant'en nts'u hukwa' uzninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","'Et ubulhni, “'Andit whudizulhne dune hintsi', 'ink'ez 'ahoolhyiz dune ts'eke bulh ninta' hut'ih. 'Et hoonliyaz hooncha tune' whut'en-un, 'et za hukwa ihitis'en. 'I gha la t'ehonózin. 'Et hoonts'i huhoo'en-un bughá holts'it ait'oh. 'Et nts'en'a la nus hoo'en-un Jonah bulh dahooja-un, 'et za hoti'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndiz un'a nja dúhooja, tat dzin 'ink'ez tat 'ulhdzis Jonah lho cho chandanda'. 'Et whuz un'a za yinka dune ye' 'en tat dzin 'ink'ez tat 'ulhdzis yun yo ts'e tidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","'Ink'ez 'oh whuya hoozulh-un dzin dune ba nahutideh de, Nineveh whut'enne nohni 'andit whudizulhne nohtoh do dutádulh 'ink'ez nohba nohotiyeh. Soo cho whunulh'en, 'oh da' Jonah bubulh yailhduk da', ts'iyawh dudeni nahondunizdla. 'Et 'awet soo zulhts'ai, 'ilhoghun 'en Jonah anus 'unt'oh-un 'andit nohtoh usyin. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","'Et 'oh whuya hoozulh-un dzin dune ba nahutideh de, 'et whe nyaz de whulerwe ts'eke 'en nohtoh dudutáyalh 'et whe nohk'ehóotalts'ulh. Ndi yun k'ut nilhdzaz de hainya Solomon ye whunih-i yudutáts'o ha 'et huwa. 'Et hoonts'i 'ilhoghun Solomon anus whunih-un 'andit nohtoh usyin.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","'Ink'ez 'ubúlhni, “'Et ntsi'-i nududeh-un dune ts'u hanádide whe yun whudizgih-un, 'et whuz nududeh natilyis-un hukwu núta. 'Et 'aw ndoohóont'oh-un nalhuhoo'al. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","'Inka dich'oh na'dudútni, ‘'Et mbe la ooyudísda'-un, 'en oots'un za nátoosja',’ ni. 'Et whuz naoosja whe 'aw hoonli hooloh. 'Et ndun dune dudzi yo lhodítsun nawhulhtsi 'ink'ez ts'ih'un na'uja, 'et 'uwhulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","'Ink'ez 'et 'uts'un whedande 'ink'ez lhtak'ant'ine ntsi'-i nududeh-i, 'enne yanus 'ultsi'ne, 'enne 'et dune hiyéndil 'ink'ez 'et nehunina. 'Et ndun dune mbe la hiyudalts'i'-un, 'en 'et whutsoda' whanus 'ultsi' suli'. Nohni 'andit ndo whuya whudizulhne, nohni dune tube untsi'ne aht'oh, 'et whuz un'a za nohba 'uwhutánelh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Sizi 'awhuz 'ilhunaoosdilne bubulh yalhduk whe ooloo 'ink'ez bulhutsinke te, 'az nódilhya 'et hiyulh yatilhduk hukwa' huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","'Et 'ilhoghun dune yulhni, “Nilh'en! Nloo 'ink'ez nyulhutsin 'az nódilhya nyulh yahutilhduk hukwa' huninzun!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","'Et mbe la 'et nduyulhni-un, 'et Sizi 'uyulhni, “Mbe la sloo? 'Ink'ez mbe la sulhutsinke? Mbene hinli whe' dini?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'Et Sizi mbene la yugha hodul'ehne, 'enne butune'úlhga, “Nilh'en ndunne, 'enne sloo 'ink'ez sulhutsinke 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","'Et huwa sBá 'en yak'uz usda, hik'une' 'ut'enne, 'enne sulhutsin, 'ink'ez sulhtus, 'ink'ez sloo te 'uhint'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","'Et dzin za Sizi yoh teninya whe bun bá natl'adida'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","'Et 'awet dune lhane higha oozdil 'inka ts'i beinya, 'ink'ez ts'i bet natl'adida'. 'Et ts'iyawh taba 'et nódilhya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndai la khuni be whuts'odul'eh-i 'et whe lhelhdun huwa bubulh yalhduk whe ndúbulhni, “Soo zulhts'ai, 'ilhoghun 'a'nule-un 'a'ntilelh ts'u whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","'Et 'a'nule whe ooloh ti nanánkat. 'I dut'aiyaz whusahándil 'ink'ez ts'iyawh hinildil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","'Et ooloh tse toh nanánkat, 'et huwa 'i 'aho hánuski, 'ankw'us yun hooloh huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ooghih hooloh 'et huwa hasain'ai whe ts'iyawh yanúdizgi 'ink'ez gak suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","'Et ooloh cha whus toh nanánkat. 'I cha whus cho whutoh bulh dúduninyai 'ink'ez bulh lhéwhultloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","'Et 'onghoh-i yun unzoo-i k'ut nanánkat whe soo hananyai. Oomai whulukhi whunizyat whunizyai (100) oomai' suli', whulukhi lhk'utat whunizyai (60) oomai' suli', 'ink'ez whulukhi tat whunizyai (30) oomai' suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mbene la budzo hoonline, 'enne soo cho huyoozólhts'ai' huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","'Et 'awet yugha hodul'ehne highu nindil, 'et huyoodulhkut, 'ink'ez 'uhuyúlhni, “Di ha ndi khuni be whuts'odul'eh-i be za bubulh yaílhduk?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","'Et ndúbulhni, “Yak'uz be k'úne' whul'en-un be whe hoont'oh hooyoh-i, daja ni-un, nohni za nohghá whunt'ai. 'Et 'onghohne 'aw bugha lhúhoolts'ulh. 'Et huwa whuz un'a za bubulh yasduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","'Et huwa ndiz un'a nja duhoont'oh, mbene la hoontsool-unyaz t'ehonínzunne, 'enne 'on nus lhat-un t'ehonínzun-un, 'et bugha whútalts'ulh. 'Et mbene la hoonli t'ewhunúszunne, hoontsool-unyaz, hodits'o ndai la 'aw 'í huyut'i-i, 'i hoonts'i bughu nayitálchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","'Et huwa ndi khuni be whuts'odul'eh-i, 'i be za bubulh yasduk. 'Et whe doo ka la honalh'en 'et hoonts'i 'aw lhuhonilh'en. 'Ink'ez hodits'o-un 'et hoonts'i 'aw lhuhodústs'o, 'aw t'ehonoozeh cha ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","'Et Isaiah nus hon'en whe daja ni 'enne bughun ts'iyawh lhaóodulya 'oh da' za. Ndiz un'a njan dutni, ‘'Ahoolhyiz whudahts'o 'et hoonts'i 'aw t'elhonuzahze. 'Ahoolhyiz whunulh'en 'et hoonts'i 'aw ts'ih'un nelhózah'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ndunne dune budzi 'ants'i buba' hoont'oh suli'ne 'et huwa, 'ink'ez 'aw hoonli hodóts'o-un hooloh, 'ink'ez ndai la be 'alha' hoont'oh-i, 'aw hinoolh'en hukwa lhe'hunínzun. 'Et huwa hoohoos̱'en lé'hint'oh. 'Et whula gha ts'e huhoo'en ait'oh, 'ink'ez dudzo be 'aw hodóts'o ait'oh. 'Ink'ez dudzi be 'aw t'ehonoozeh-un hooloh. 'Et whuz un'a ndulhúhit'oh de, 'uda' da' dulubeshi ch'az nahulhya oole' da', 'ink'ez da' Yak'usda uboolhyih,’ ni Isaiah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","'Et hoonts'i nohni ndai la nohna be whunulh'en-un, ts'ih'un un'a whunulh'en. 'Ink'ez nohdzeh whe soo whúdahts'o, 'et huwa 'uk'enus hoonzoo-un nohghá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ts'ih'un 'unohdusni, 'oh da' lhane nus hoo'enne 'ink'ez ts'ih'un 'unt'ohne, ndai la nulh'en-i, 'i huyuntilh'elh hukwa' huninzun, 'et hoonts'i 'aw lhuhuyí'el! Ndet la whudahts'o-un, 'et soo ts'ih'un hodutats'o hukwa' huninzun, 'et hoonts'i 'aw lhuhodíts'il. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“'Et huwa ndi khuni be whuts'odul'eh-i be 'a'nulih-un, 'en ghun, ndiz un'a nja dutni whe 'utni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","mbene la yak'uz nts'en'a 'uhuhoolhdzun-un whulh 'úhudits'o ndi khuni daja ni whe 'utni 'et hoonts'i dudeni be 'aw t'ehonuszun. Ndai la dune dudzi bez 'ahinanla-i, mbe la ntsi'-un whusayaih 'ink'ez budzi be hanaídan'ai! Ndi 'i 'unt'oh ti 'anilya-i, 'i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndi ndai da' tse toh 'anilya-i, ndunne 'i k'un'a za 'uhint'oh. Ndi khuni hidits'o te, 'ink'ez soo 'aho huhóont'i' whe huyilhchuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'Et hoonts'i didutch'oh 'aw bughih hooloh le'hint'oh. 'Et huwa 'atsulyaz za buba 'alha' hoont'oh. 'Ink'ez ndi khuni 'i gha dzoh nuhudeh 'ink'ez 'onghohne buch'az huditni. 'Et huwa 'aho whulahudutnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndai la whus toh 'anankat-i le'unt'ohne, 'enne ndiz un'a 'uhint'oh. 'Enne khuni hidits'o, 'et hoonts'i ndi yun k'ut huwu ni ts'inli-un, ndi yun k'ut hoonzoo' hoont'oh-un, 'et 'i ts'iyawh whus cho 'i be bulh lheyúllhuk dult'oh. 'Et huwa 'aw lhadúlyane hoole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","'Et hoonts'i ndet la yun unzoo-i k'éninkat-i le'unt'ohne, 'enne ndiz un'a nja duhint'oh. Ndi Yak'usda ooghuni hidits'o-i, t'ehinuzih te daja ni whe 'utni. 'Et huwa bumai' lhai lhih le'hint'oh. Whulukhun whunizyat whunizyai (100) suli'. 'Et doo cha whulukhun lhk'utat whunizyai (60) suli'. 'Et doo cha whulukhun tat whunizyai (30) suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Doo cha 'uyoo khuni be nawhutnuk-i be whuts'odul'eh-i, 'i be bubulh yalhduk 'et whe nja dúbulhni, “Nts'en'a la yak'uz lerwe 'uhuhoolhdzun-un, 'et diz un'a nja duhoont'oh. Dune ndi yun ookw'ut 'a'nukat. 'Uzoo'-i 'anukat-i 'ananla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Awhuz huztez whe dune yuch'az ditni-un whusainya. 'Et ndi 'ainanla-i 'uzoo'-i toh, ndi 'anukat-i, 'ut'antsi' ts'utni, 'i yutoh 'ananla, 'ink'ez whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","'Et ts'iyawh hanányai whe ndi 'ut'antsi', 'i cha bulh hainanyai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","'Et yoh whumoodih be 'ulhnane highu nindil 'ink'ez 'uhuyulhni, ‘Hadih nemoodih di whe inla ndi unzoo-i hunuyeh ootoh 'ainanla? Di whe 'unt'oh ndi 'ut'antsi' dult'oh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","'Et ubulhni, ‘Sch'az ditni-un la 'uja.’ 'Et be 'ulhnane huyulhni, ‘Ndi 'ut'an untsi'-i ootoh hananyai-i, 'i hats'úntilelh hukwa' ninzun eh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","'Et ubulhni, ‘'Awúndooh! Whute 'unt'oh doo ka la ndi unzoo-i cha bulh 'óohneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Whute 'et ndulhdzun ha' úntikulh whuts'un. 'Et 'awet ha' nukat-un neooninzut de, ha' untilelhne, 'enne si budósni', 'udechoo 'ut'antsi' hanálhle 'ink'ez ulhghel duták'un huba. 'Ink'ez ndai la unzoo-i ts'iyawh hanáhle 'ink'ez haníyeh-i ba yoh whuz danáhle.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Doo cha 'uyoo khuni be nawhutnuk-i be whuts'odul'eh-i, 'i be bubulh yalhduk 'et whe nja dúbulhni, “Nts'en'a la yak'uz lerwe 'uhuhoolhdzun-un, 'et ndiz un'a nja duhoont'oh. Ndi mai, mustard huyulhni, 'i k'un'a 'unt'oh. 'I dune yílhchoot 'ink'ez duhanuyeh k'et 'ainanla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ndi mai soo 'uk'enus nint'um-i, 'i hanányai 'ink'ez oochun 'uk'enus dincha suli'. Ndi mustard huyulhni oochun, mai chun 'i ts'iyawh ba ndo idilyiz suli'. 'Et 'i dut'aiyaz 'i duchun dut'aiyaz yuzischum toh t'o nenínla. 'Et whuz un'a yak'uz lerwe 'uhuhoolhdzun-un 'on nus hooncha tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Doo cha 'uyoo khuni be nawhutnuk-i be whuts'odul'eh-i, 'i be bubulh yalhduk 'et whe nja dúbulhni, “Nts'en'a la yak'uz lerwe 'uhuhoolhdzun-un, 'et ndiz un'a nja duhoont'oh, lhes ntuldoh-i dult'oh. Ndai la ts'eke yílhchoot 'ink'ez lhes nudzaih-i, 'i ta tsetsai be únde'ooldzih-i dizbun. 'I ntuldoh-i bulh 'ilho be yándzai, 'ink'ez yunilhtlus. 'Et hukw'elh'az 'udun neíninkai whe untílhdo. Ts'iyawh ntuldoh lhih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ndi ts'iya-i khuni be nawhutnuk-i be whuts'odul'eh-i, 'et whuz un'a za Sizi 'ilhunaoodulhne bubulh yailhduk. 'Aw 'uts'un un'a lhe'budínel. 'Et diz un'a za budáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","'Et whuz un'a nyoon nus hoo'en-un daja dani' la, 'et ts'iyawh lhaóoduja whe nja dutni, “Khuni be nawhutnuk-i be whuts'odul'eh-i, 'i be bubulh yatisduk. Nts'oya hoozulh whe ndi yun 'uyinla 'et whuts'un, ndai la buch'a yuntiz'i-i, 'i ghun budutásnelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","'Et Sizi 'ilhozdilne, 'enne ts'iyawh whenábalh'a' 'ink'ez yoh danínya. 'Et yugha hodul'ehne highu nindil 'ink'ez huyúlhni, “Ndi khuni be nawhutnuk-i be whuts'odul'eh-i, ts'ih'un un'a nedini ndi haniyeh-i unzoo-i toh 'ut'antsi' hanányai-i, 'et daja ni whe 'utni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","'Et ndúbulhni, “Ndai unzoo-i hanányai oomai' 'i, mbe la 'ainanla-un, 'en yinka dune ye' 'en 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Haniyeh k'et, 'et ndi yun k'ut whunduwhult'oh whe' hoont'oh. Ndi mai unzoo-i, 'i yak'uz whulerwe buzkehne, 'enne duhúlt'oh. 'Et hoonts'i ndi 'ut'antsi', 'i ntsi'-un buzkeh duhúlt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","'Ink'ez mbe la yuch'az ditni-un, ndi 'ut'antsi' 'ainanla-un, 'en netsudule. Ha'nukat-un 'et 'andit ndóya whudizulh-un 'et whulatoh. Mbene la ha' úntilelhne, 'enne lizas duhult'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","'Et huwa nts'en'a la ndi 'ut'antsi' nahidulhdzooh 'ink'ez hidilhk'un, whuz un'a za njan 'andit whudizulh-un whulatoh de cha, nduwhutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","'Ink'ez yinka dune ye', 'en oolizas whunilhchoh ts'e whutl'abutilelh. Nts'e la whulerwe unli-un, mbene hukwaya hooni tune' 'úst'enne, 'enne 'ink'ez yuk'unulhe'ust'enne, 'enne ts'iyawh 'ilhunabotálelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Nts'e la kwun dizk'un huba' hoont'oh-un, 'et whuz hubotilhdulh. 'Ink'ez tso yahutilhduk 'ink'ez dughoo lhuhidutik'us. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","'Et dzin nts'en'a la sa hadánat, mbene la ts'ih'un un'a 'unt'ohne, nts'e la buBá lerwe unli-un, 'enne cha whuz un'a za sa k'un'a buts'u haítiduz whe' hoont'oh. Mbene la budzo hoonline, 'enne soo cho huyoozólhts'ai' huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Doo cha za nohdusni, yak'uz k'úne' whul'en-un, dáwhudizti' la 'et diz un'a nja dúhoont'oh. Ndun dune njan yun k'ut hoonzoo-un, 'et 'oh ho nunúta whe hoonliyaz dizti'-i, 'i la nayin'ai. 'Ink'ez 'on yo nayuntilh'i. 'Et hoont'i' k'et ndun dune ndai hoonli yut'i-i, 'i ts'iyawh ye 'ónket 'ink'ez ndi yun yuk'ut nayin'ai-i, 'i yun ndulcho whe yonket. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Doo cha za nohdusni, yak'uz k'úne' whul'en-un, dáwhudizti' la 'et ndiz un'a nja duhoont'oh. 'Et doo cha 'uyoon dune, 'en hoonliyaz 'i ts'iyawh yooket. 'Et 'on 'un doo cha ye ná'ooket. 'En kw'usul k'us dunizti'-i, 'i hunúta. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","'En 'ilho kw'usul k'us dunizti'-i, 'i la nainin'ai. Ndun dune ndai hoonli yut'i-i, 'i ts'iyawh ye 'ónket whe ndi kw'usul k'us dunizti'-i, 'i yoonanket. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“'Et doo cha za nohdusni, yak'uz k'úne' whul'en-un, 'et ndiz un'a nja dúhoont'oh. Ndiz un'a 'uhut'en, lhembilh tahúyalhdil 'ink'ez nonáhuyigus lhawh didowh-i huzdlooh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","'Et nohúyigus whe ts'iyawh lhtahaháyule. Ndai la lho 'utsi'-i, 'i ts'iyawh tanáhuyulhdilh. 'Ink'ez ndai la unzoo-i ts'iyawh nts'e 'uhitilh'elh ts'ú whehuyulhdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","'Et 'awet nts'oya hoozulh whe buba neóonin'ai-un, 'et buba whusahóolts'ut de, 'et hukw'un'a za 'uwhutánelh. Lizas whusahutidulh, 'enne ts'iyawh unzoone dune 'ink'ez ntsi'ne dune lhtahábotilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ntsi'ne, 'enne nts'e la kwun dizk'un huba' hoont'oh-un, 'et whuz hubotilhdulh. 'Ink'ez tso yahutilhduk 'ink'ez dughoo lhuhidutik'us.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","'Et 'awet Sizi ubúlhni, “Njan ndunóhdusni-un, 'et ts'iyawh eh t'eoonáhzun?” 'Et 'uhuyulhni, “A, neMoodihti, ts'iyawh t'ets'oninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","'Et 'ubulhni, “'Et huwa mbe la Yak'usda ooghuni 'uk'eguz-i 'ink'ez yak'uz k'une' whul'en-un 'et huwun wheyodalh'e', ndun dune 'en yoh whumoodih-un, 'en dult'oh. 'Ink'ez ndai la yut'i-i toh ts'iyawh ts'et hayúle, 'andidi-i 'ink'ez 'uda'-i cha. 'Et whuz un'a dune hodulh'eh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","'Et ndi khuni be nawhutnuk-i be whuts'odul'eh-i, 'et 'awet Sizi ts'iyantsuk lhaoodinla whe nyo usda-un whuch'a nasja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'Ink'ez dich'oh dukeyoh ts'e naoosja whe Lizwif bulugliz 'et whewhúbondunilh'e'. 'Et whe ts'iyanne buba hooncha suli', 'ink'ez 'et 'ulhodutni, “Ndun dune nts'ez de hahón'ai ndi khuni whutnih-i be yalhduk? 'Ink'ez hooncha tune' 'ut'en nts'en'a dat'en whe 'ut'en? ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","'Alha iloh lakw yoh 'uwhulh'en-un, 'en ooye' 'unt'oh? 'Ink'ez 'en iloh lakw ooloo Mary? K'us bulhutsinke iloh lakw 'enne James, Joses, Simon, 'ink'ez Judas? ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'Et bulhtuske 'aw lakw ts'iyawh nebulh lhe'hit'oh? 'Et ndun dune ndi ts'iyawh nts'ez de hahónla whe 'utni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Et huwa ts'iyawh hits'u disnih. 'Et Sizi ndúbulhni, “Mbe la nus hoo'en unli-un, 'en ts'iyanne yudilhti'. 'Et hoonts'i dich'oh ookeyoh whut'enne 'ink'ez dich'oh ooyoh, 'enne cha 'aw lhuhidílhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Et Sizi 'en 'aw buba 'alha lhe'yit'oh. 'Et huwa dich'oh dukeyoh 'aw lhat-un hooncha tunulhé'it'el. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","'Et 'oh da' 'oh whuya whudizulh whe lerwe Herod 'en Sizi yulh údants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","'Et Herod de 'ustlene 'ubulhni, “Ndun 'en John dune too be 'ulh'en-un, 'en 'unt'oh. Yaidlanne toh nahitna'. 'Et huwa 'ut'en hoolhtus te ne'út'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ndiz un'a 'uhooja whe 'oh da' Herod John huyílhchoot 'ink'ez huyulhghel 'ink'ez 'ahúyan'ai. Oobulhutsin Philip huyulhni, 'en oo'at Herodias huyulhni, 'en la toh ts'e yinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","'Et John Herod ndúyulhni, “'Aw nyun mba ts'ih'un un'a lhe'hoot'oh whe 'uyoon oo'at oozih sinda.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","'Et Herod yutuzilhghelh hukwa' ninzun. 'Et hoonts'i dunene John 'en nus hoo'en-un 'unt'oh huninzun, 'et huwa Herod whenilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","'Et 'ilhoh dzin 'et Herod whuzdli dzin 'uhoont'oh whe Herodia ootse' 'en bubut nídai. Herod tube ooba hoonzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","'Et 'aho hits'u náhizya whe 'uyulhni, “Ndet sts'o hukwa' ninzun-un sts'o hukwa' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","'Et nyoon ts'eke ooloo, 'en, “Herod oodilhkut 'ink'ez John dune too be 'ulh'en-un ootsi lusyet be stl'ainkaih dóni',” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","'Et huwun lerwe oodzi únduda suli'. 'Et ts'iyanne mbene la yuzih dilhts'ine, 'enne ts'iyawh hidánts'o, 'et whe ts'ekeyaz dughuni yutl'aidan'ai. 'Et huwa 'et whuz un'a 'uhuyooleh huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","'Et 'awet nts'e la 'adin'ai ts'e whuz wheyálh'a', 'ink'ez 'adinlane ghunline, John hitsi k'únintsel. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'Ink'ez lusyet be whusahúyankai, 'ink'ez ndun ts'ekeyaz tl'ahúyankai. 'Ink'ez duloo yughi nínkai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yugha hodul'ehne, 'enne whusahandil. Hizi huyilhchoot 'ink'ez 'ahúyalhti. 'Et hukw'elh'az Sizi ts'u whehandil 'ink'ez hidáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","'Et Sizi whulh udants'o whe buch'a násja 'ink'ez ts'i be inya 'ink'ez nts'e la disoh ts'e whuz nehúninki. 'Et hoonts'i lhane dune t'ehonanzin ibulh nts'e la nehúninki ts'e, whuz lhelhdun keyoh whut'enne hiyuwhenándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","'Et Sizi ts'i bé hainya whe dune soo ts'ih'un huldlai k'et 'aw 'uzdooni' ait'oh, 'enne bunilh'en. 'Et 'aho bugha té'nanzin 'ink'ez ndudane cha ts'iyawh soo na'binla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","'Andit 'awet hulhgha 'uhoont'oh 'et huwa yugha hodul'ehne, 'enne highu nindil 'ink'ez huyulhni, “Njan disoh 'uhoont'oh. 'Awet yoo 'un hoozulh. Ndunne ts'iyawh 'uts'un keyoh ts'e nabalh'alh, 'et whuz la huya'alh-i hoket.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","'Et hoonts'i Sizi ndubulhni, “'Aw nahutoodilh huba lhe'hóot'oh. Nohnich'oh bugha naínuht'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","'Et 'uhuyulhni, “'Aw hoonli lhts'it'ih. Lhes kwulai' 'ink'ez lho nanki, 'aw 'i za ts'ut'i.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","'Et ndubulhni, “Diz sts'óhlelh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'Et mbene la 'ilhunaoosdilne, 'enne ts'iyawh tl'oyaz k'ut natl'ahudoolts'ih ubúlhni. 'Et ndi kwulai' lhes 'ink'ez nanki lho cha, 'i hitl'ahúyanla whe ndo whúnalh'en whe musi ni whe tenadidli. Lhes taidanyuz 'ink'ez lho cha 'et diyinla 'ink'ez yugha hodul'ehne butl'ayánla, 'ilhozdilne bugha húyo'alh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","'Et ts'iyawh 'uhan'al 'ink'ez 'uhunisdai. Ndai la ch'utizkat-i ts'iyawh nahuyalhdzoo whe whunizyai 'on 'at nanki chalhyal dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","'Et nyoonne dunene, 'enne 'ankw'us 5000ne 'uhan'al. 'Et ts'oodunne 'ink'ez ts'ekoo 'enne cha 'uhan'al. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","'Et 'aho Sizi yugha hodul'ehne ts'i bez whenábalh'a' whe, “Stso nyan ahkelh,” ubulhni. 'Ink'ez 'ilhunaoosdilne, 'enne cha dukeyoh ts'e whenábalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","'Et 'awet ndunne ts'iyawh whenábalh'a' whe didutch'oh ndo dzulh k'uz whinya tenadutidli ha. Dich'oh únli whe bé nadalhghel. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Et 'awet ts'i bun k'ut taniz 'oh whuya ukwus nilhts'i tube búdudizts'i, 'ants'i lhents'ó dildus. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","'Et 'awet bundada' yutilhkai whe Sizi too k'ut buts'u tizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","'Et khunsul yugha hodul'ehne hitilh'en whe hunílhjoot, “Dune tsin 'ut'en!” hutni ibulh tsoya whehúnilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","'Et 'aho Sizi buts'u yatilhduk, “Nohdzi ulhtus úlhtsi! Si 'ust'en! Whenulhjut íloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter diz un'a yoodulhkut, “SMoodihti 'alha nyun 'int'en de, too k'ut nts'u toosya'-un stl'ahóon'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","'Et 'aho 'uyulhni, “'Anih!” 'Et 'awet Peter ts'i be hainya 'ink'ez Sizi too k'ut yuts'u tiyalh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","'Et nyo whunilh'en whe nilhtsi tube ulhtus 'ink'ez whenilhjoot 'ink'ez yo útizdlat whe, “SMoodihti, sla 'ineh!” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","'Et 'aho Sizi yula súgooh whe ndi yulhni, “'Aw soo 'ultsuk-i be 'alha' hoont'oh-i lhint'ih. 'Et dahoont'oh huwa mba nawh 'uhoont'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","'Et ts'i be náhit'az whe 'aho nilhts'i k'oh 'úja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Et mbene la ts'i bet dilhts'ine, ts'iyawh hibut nachánilya 'ink'ez 'uhuyulhni, “'Alha nyun Yak'usda ooYe' 'int'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","'Et 'awet nyan Gennesaret ts'e yahuzki whe, ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","'et keyoh whut'enne Sizi hitilh'en ibulh, nahuyóolhts'it whe lhtunuhúnihust'ai. 'Ink'ez ts'iyawh ndudane hits'ú boozdla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“Ndai la nyunaih naints'uz-i 'ants'i yus ts'e oot'áts'onalh,” huyulhni. Ts'iyawh mbene yut'aiznaine, 'enne soo ts'iyawh ts'ih'un un'a soo ná'huja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","'Et 'awet Jerusalem keyoh whuts'un ndunne Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene, 'enne cha ts'iyawh Sizi highu nindil 'ink'ez 'uhutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“'Et di ha ngha hodul'ehne, netsoda'ne 'uda' ne'whust'en hukw'un'a 'aw hukw'unulhe'hust'en? Whunilh'en, ndunne ngha hodul'ehne, 'aw lanalhe'hulhde 'uhuti'ulh whutso!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","'Et dúbulhni, “'Et di ha nohnich'oh nohk'oh ts'e huwa Yak'usda ooghuni ook'unulhe'zaht'en? ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Whunulh'en, nohni nts'en'a daht'en! Yak'usda dughuni nohtl'aidan'ai whe nja dutni, ‘Mbá 'ink'ez nloo bulh hubudólhti'.’ 'Et doo cha 'udun 'et nja dutni, ‘Mbe la duloo 'ink'ez dubá bulh dzoh ts'e bughu yatilhduk-un, 'en daootsa huba 'unt'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","'Et hoonts'i nohni ndiz un'a 'udahni, ‘Mbe la dubá k'us duloo nja dúbulhni-un, ndai 'ust'i-i, 'i be da' nohla 'oost'en oole', 'et hoonts'i 'i ts'iyawh Yak'usda gha núsdla.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","'Et whuz un'a nohe'ut'en k'oh be 'aw duloo 'ink'ez dubá bulh lhubudílhti'. 'I be Yak'usda ooghuni nohtl'aidan'ai-i, 'i 'aw hoonliyaz lhiloh sulhtsi! ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nohni duba na'udzoo'ne ahli! Ndun nus hoo'en Isaiah, 'en 'uda' hon'en 'ink'ez ts'ih'un un'a 'utni nohni nohghun. Njan 'et nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ndunne dune dughuni be be za sodílhti'. 'Et hoonts'i budzi, sughun nilhdza' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ndunne doo ka la 'ants'et sts'un teni 'uhunoolhdzin. 'Ink'ez ndet la dune bube 'ut'en k'oh, 'i Yak'usda ooghuni netl'aidan'ai-i 'i k'un'a 'uyoonne hubuhodoolh'eh hukwa' hut'en.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","'Et Sizi 'ilhunaoodulhne, “'Anih! Diz áhdulh!” ubulhni, 'ink'ez 'et ndúbulhni, “Soo zúlhts'ai 'ink'ez soo cho t'eoonahzeh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ndai la dune buza yúkat-i, 'aw 'et whe íloh hintsi' hulhih. 'Et hoonts'i ndai khuni 'aw lhizoo'-i dune ye yalhduk-i, 'i be dune hintsi' lhih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","'Et yugha hodul'ehne higho nindil whe 'uhuyulhni, “T'eoonínzun eh ndunne Phariseene nyodants'o whe daja dini-un, 'et ndúwhulcho whe buba dzoh 'údinja?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","'Et Sizi ubulhni, “'UBá yak'uz usda, ndai la 'aw 'alhinilel-i, 'i ooghih tubulh hahitilhch'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Whute! Ndunne 'aw buts'áhalhozah'ai! 'Enne moodih hoos̱'enne le'hint'oh. 'Et ndiz un'a nja duhoont'oh, 'ilhoghun hoos̱'en-un 'ink'ez 'ilhoghun hoos̱'en-un ghunli de, nahúlt'oh tsa k'et 'áhatilts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","'Et Peter yoodulhkut, “Ndi be nawhutnuk 'i be whuts'odul'eh-i, nts'en'a daja ni, 'et ts'iyawh whunénilhtun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","'Et 'uyulhni, “'Aw eh noheni talhodulhts'it whe eh dahni? ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Awhuz eh ts'ih'un nelhózah'ai? Dune ndai la ooza yúkat-i, 'i ts'iyawh oobut za be yukat. 'Ink'ez ooyust'e ts'u hanáyukat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","'Et ndai la dune khuni be yailhduk-i, 'i budzi ts'u hayúkat 'i 'unt'oh, 'ink'ez 'i dune dilhtsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Soo cho whunulh'en, ndi 'et ndunt'oh-i, 'i dune budzi bez hayúkat, be ne-eni untsi'-i, dune hutuzilhghelh, 'uyoon dune oo'at k'us 'uyoon ts'eke ooki bulh ninta' ant'en-un, 'ink'ez 'aw lhghulhdilts'ine hoonts'i whuz un'a za ne'hut'en. 'Uduntit'ih-un, 'uyoonne ba whuts'it-un, 'ink'ez Yak'usda ch'az yalhduk-un cha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","'Et njan 'et dúhoont'oh-un, whunilhchoh whe dune hintsi' lhih. 'Et 'aw lanalhe'zulhde whe 'ah'alh-un, 'aw 'et huwa iloh hintsi' lhih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Et 'awet Sizi nyo usda-un whuch'a nasja whe Tyre keyoh 'ink'ez Sidon keyoh 'oh ho whenghoh ts'u naóosja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Et whuts'un 'ilhoghun ts'eke, 'en Canaan whut'en-un 'unt'oh, 'en yughu ninya. Tso bulh yalhduk whe' yulhni, “SMoodihti sgha te'ninzeh, t'enyunúszun David oots'u hainzut-un 'int'oh! Syaz ts'ekeyaz 'en tube hoontsi' hukw'un'a ntsi'-i nududeh-i ooyudinda!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","'Et 'aw daja lhidínel. 'Et yugha hodul'ehne highu nindil 'ink'ez 'uhuyulhni, “N'un nailh'alh, 'et la tso bulh yalhduk-un 'etsul udónih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","'Et 'ubulhni, “Mbene la Israel ooyoh whut'ine, 'enne 'ants'i 'usbai ninta nih'az-i le'unt'ohne, 'enne za buts'ú tiz'a'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ndun ts'eke 'en yughu ninya whe yubut nachaniti 'ink'ez, “SMoodihti, sla 'ineh!” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","'Et Sizi diz un'a 'uyulhni, “Ndai la ts'oodunne yu'alh-i lhikeyaz gha óoh'alh junih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","'Et ts'eke 'uyulhni, “SMoodihti 'alha' dini. 'Et hoonts'i ndai la moodihti ludab k'ut tukat-i, 'i lhikeyaz huyuldil.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","'Et Sizi 'uyulhni, “'Ooh ts'eke hooncha whe mba 'alha' hoont'oh-un, 'et hooncha whe' hoont'oh. 'Et huwa hukwa' ninzun k'un'a 'uhoneh.” 'Et soo 'oh whuya hoozulh-un, ooyats'e soo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","'Et 'awet Sizi bughu natisja whe Galilee bun 'oh ho neninya. Ndo dzulh k'uz whinya, 'et natl'adida'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","'Et khunsul lhane dune, 'enne highu nindil. Mbene la nulhúsdilne, hoos̱'enne, yalhulhdukne, ooyust'e bodin'aine, 'ink'ez 'uyoonne cha, 'enne ts'iyawh hits'u botule. Hibut neboninla 'ink'ez ts'iyawh soo ná'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yalhulhdukne cha yawhehunilhduk, ooyust'e bodin'aine, 'enne cha soo na'huja. Nulhúsdilne cha nahúdilh nahusdli', hoos̱'enne cha huhoo'en nahusdli'. Ts'iyanne bunalh'en whe tube buba hooncha 'ink'ez Israel oodune'ne, 'enne buYak'usda 'en 'on nus hidálhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sizi yugha hodul'ehne, 'enne 'anih budáni' 'ink'ez ndúbulhni, “Ts'iyawh ndunne dunene bugha té'nuszun. Tat dzin whuts'un nja szih hudilhts'i 'ink'ez 'aw huya'alh-i lhuhít'i'. 'Et 'aw lhe'hus'al whe bukeyoh ts'e nabutoos'a' ait'oh. 'Et dúbusdla de, nahidulh ts'e la bukaootoozit.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Yugha hodul'ehne huyulhni, “Njan keyoh 'aw dune hooloh-un 'uhoont'oh. Nts'ez de suba soo 'últsuk-i t'alh-i nats'ólelh lhe'ultsukne dune gházti'alh-i?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","'Et Sizi ubúlhni, “Daltsuk lhes sut'e aht'i?” “Lhtak'ant'i lhes sut'e 'ink'ez lho nt'umiyaz bulh,” huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","'Et 'ilhozdilne natl'adulhts'ih ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'Et ndi lhes lhtak'ant'i lho bulh yílhchoot 'ink'ez musi ni whe tenadidli. Taidanyuz 'ink'ez yugha hodul'ehne butl'ayánkai. 'I ts'iyawh natl'adilts'ine butahinínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ts'iyawh na'hit'al 'ink'ez 'uhunisdai. 'Et yugha hodul'ehne lhtak'ant'i chalhyal dizbun 'i highá 'oz'al-i nahuyalhdzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","4,000ne dunene at'en 'uhan'al. Ts'oodunne 'ink'ez ts'ekoo 'enne cha 'uhan'al. ");
INSERT INTO crxNTpo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","'Et 'awet Sizi 'ilhunaoosdilne bukeyoh ts'e whuz whenábalh'a' whe 'et ts'i be naja 'ink'ez yun Magdala huwhutni ts'e whuz whehánki. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","'Awet ndunne Phariseene 'ink'ez Sadduceene cha, 'enne highu nindil 'ink'ez huyóolhdzih whe huyoodulhkut, “'Aw yak'uz whuts'un hooncha tune' whut'en-un, whunénolhtun ait'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","'Et ndúbulhni, “'Et hulhgha ts'e ndo yat whunulh'en. 'Et whudulk'un de, 'et dzin hoonzoo tileh dahnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","'Et bundada' yat kw'us bulh dulk'un suli' whunulh'en de, 'awet azih whudutitsi' dahni. Nohni duba na'udzoo'ne ahli! 'Et ndo yat dawhut'en la, 'et t'eoonáhzun. 'Et hoonts'i ndoyá whudizulh dawhut'en la, 'et ndet 'uwhulhni, 'aw t'eoonuzáhzun! ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Njan 'andit whudizulhne, 'enne lubeshi ts'u nint'ine za' 'uhint'oh. 'Ink'ez 'ahoolhyiz dune ts'eke bulh ninta' hutit'elh-un, 'et za whuts'ónint'i. 'Ink'ez hooncha huwa 'ít'en-un whuntilh'elh hukwa' nahzun. 'Et hoonts'i 'aw hooh'en-un nohghá holts'it ait'oh. 'Et nts'en'a la Jonah bulh dáhooja inle' la, 'et za whutih'elh whe' hoont'oh!” ubúlhni, 'ink'ez bughu whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","'Et 'awet nyan nahooski whe yugha hodul'ehne lhes nahodilhnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","'Et Sizi ndúbulhni, “'Ahoolhyiz wheni khahdli ndunne Phariseene 'ink'ez Sadduceene cha, 'enne bules untuldoh-i ch'a.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","'Et 'aho lhulh yawhehunilhduk, “'Et 'aw lhes lhts'ít'ih 'et huwa 'utni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","'Et Sizi t'eoonanzin whe 'et dúbulhni, “Nohni be 'alha' nahzun-i unsool! 'Et huwa' 'udahni. 'Aw lhes sálhah'al, 'et huwa eh 'et howu yalhduk? ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","'Awhuz eh 'aw ts'ih'un t'eoonuzahzun? 'Aw whunalhuzulhni whe kwulai' lhes 'i be 5,000ne gha náh'ai, 'ink'ez daltsuk chalhyal ch'utizkat-i, 'i nalhdzoo? ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'Et doo cha lhtak'ant'i lhes 'i be 4,000ne gha náh'ai, 'et daltsuk chalhyal ch'utizkat-i, 'i nalhdzoo? ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Et nts'en'a aht'oh t'eoonuzahzun, 'aw lhes ghun nohbulh yalhuzusduk? 'Uda' nohdasni, ndunne Phariseene 'ink'ez Sadduceene cha, 'enne bules untuldoh-i huwohle', 'i ooghu yasduk whe' dusni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","'Et 'aho t'ehoninzun ndunne Phariseene 'ink'ez Sadduceene cha, dune huhodulh'eh-un, 'et whuch'a buch'a huwahli, 'et 'uwhulhni. Ndi lhes bulh untuldoh-i, 'i ch'a huwahli ni iloh whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","'Et Sizi Caesarea Philippi buyun k'uz whinya whe yugha hodul'ehne, 'enne uboodulhkut, “Si yinka dune ye' 'ust'oh. 'Et hoonts'i n'awh dunene, mbe whe 'ust'oh hutni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","'Et 'uhuyulhni, “Whulohne, 'enne nyun John dune too be 'ulh'en-un 'int'oh hutni. 'Et whulohne cha, nyun Elijah 'int'oh hutni. 'Et 'onghohne cha, nyun Jeremiah 'int'oh hutni. 'Ink'ez whulohne nyun nus hoo'en-un 'ilhoghun 'int'oh hutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","'Et 'ubulhni, “Nohni do', mbe 'ust'oh dahni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","'Et Simon Peter yatilhduk whe 'uyulhni, “Nyun Christ, Yak'usda khuna-un, 'en ooYe' 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","'Et Sizi 'uyulhni, “Simon Jonah ooye', 'uk'enus hoonzoo-un nghá whults'ut! Ndet sudini-un, 'et 'aw ndi yun k'ut dune, 'enne iloh nyunalhts'et hahúhon'ai. 'UBá yak'uz usda-un, 'en nyunalhts'et hahon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'Ink'ez nyun Peter 'int'oh. 'Et ndi tse 'i k'ut slugliz neootas'alh. Njan mbe la kwuncho ulhtus-i yo ts'u haindilne, 'enne hoonts'i 'aw whuch'a hoolhdeh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nts'e la yak'uz whulerwe usda-un, whulugli ntl'atis'alh. 'Et ndi yun k'ut ndai la whedinguz-i, 'et 'uda' yak'uz cha whuz un'a za whedint'i. 'Et ndai la ndi yun k'ut k'unain'uk-i, 'et yak'uz cha 'uda' whuz un'a za k'unatit'uk.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","'Et yugha hodul'ehne khuniti be 'ubúlhni, “Khun te 'uyoonne dóhni' junih si Sizi mbe la Christ, 'en 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","'Et 'oh whuya hoozulh whuts'un Sizi yugha hodul'ehne, 'enne whubunulhtun nus daootanelh la. Nts'en'a whe Jerusalem ts'u tiyalh. 'Et keyoh ndunne 'utso whudilhdzulhne, 'ink'ez lubret bumoodihne cha, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'enne bube lhat-un whe dzoh nuhítilhdzut, 'ink'ez hituzilhghelh. 'Et whulh tát dzin, 'et dunadutádalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","'Et Peter Sizi yílhchoot 'ink'ez 'udun neínilhti 'ink'ez hukwa' yudáni', “SMoodihti nyun Yak'usda ngha te'untazeh! 'Aw nyulh 'et dúhoneh ait'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Peter yuts'u nálh'a 'ink'ez 'uyulhni, “Satan st'a nenínyaih! Nyun yooya suzilhts'i! Yak'usda nts'en'a la dat'en-un, 'et 'aw howu nuni lhnuzinzut. Ndi yun k'ut dune nts'oh tula ne'hut'en-un, 'et hukw'un'a za nuni ninzut!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","'Et Sizi yugha hodul'ehne ndúbulhni, “Mbe la dune se' 'ut'en k'oh oot'en ha suntiyalh hukwa' ninzun de, ndi yun k'ut dats'ínt'oh-un, 'et ts'iyawh whula dootni, 'ink'ez dutulalhgus yólhchoot 'ink'ez suntooya'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","'Et huwa mbene la whe khuna-un hotilhyihne, 'enne 'et hoonts'i ninta huhúta'alh. 'Et hoonts'i mbe la whe khuna-un si sgha ninta oonin'ai de, 'en whe khuna-un nahootá'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","'Et huwa dune ndi yun 'i ndulcho whe ooch'e' yúzdli' de, 'ink'ez duzul 'i ninta inín'ai de, ndet whe ooba whutázoo'? 'Ink'ez dich'oh duzul nayitalhchulh hukwa' ninzun de, di k'elha suba duzul nayoket? ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Et huwa yinka dune ye' whusatiyalh, ndai la ooBá ye dizti'-i 'ink'ez oolizas, 'enne bubulh, 'et whusainya de, nts'en'a la ts'iyanne dahit'en, whuz un'a 'ilhone whe buba k'elha whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Soo ts'ih'un un'a nohdusni, whulohne njan núdilhyanne, 'enne ndet la dahutitsah-un 'et whuts'un yinka dune ye' nts'en'a la whe lerwe unli-un, 'et whuz un'a whuz de uyalh de, ndunne dahútitsa whuts'o huyuntilh'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","'Et 'awet whulh lhk'utat dzin inle' whe Sizi 'en Peter, James cha, 'ink'ez dulhutsin John, 'enne ndo dzulh k'uz dulh ubílya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Khunsul bubut 'uts'un ot'en suli'. Oonin 'ants'i sa k'un'a oots'u ha'ánduz, 'ink'ez oonaih 'i cha khunsul 'ulhyul suli', 'ink'ez 'i cha oots'u ha' 'ánduz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","'Et khunsul Moses 'ink'ez Elijah bulh bube hóodilts'ai 'ink'ez Sizi hibulh yáwhenilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter Sizi ndúyulhni, “NeMoodihti njan uzdilhts'i hoonzoo. Hukwa' ninzun de, tat-un whut'ah uztitez-un 'uts'otilelh. 'Ilhoghun nyun mba, 'et 'ilhoghun Moses ba, 'ilhoghun cha Elijah ba.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Peter yalhduk whe khunsul kw'us be tidat'en whe buk'einde. Kw'us toh ts'e khunsul 'uwhutni, “Ndun sYe' 'uk'enus ook'esi'-un 'unt'oh. 'En bulh hóonust'i'. 'En za 'oozúlhts'ai!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yugha hodul'ehne hídants'o whe hibut nachánildil, 'ink'ez tube whehúnilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Sizi bughu ninya 'ink'ez but'aiznai whe ubulhni, “Dunadahdilh 'ink'ez whénulhjut iloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","'Et ndo nahítat'en whe 'aw 'uyoonne hooloh. Sizi didutch'oh za hiyan'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndet la dzulh k'ut whenáhudidil whe, 'et yo nahidulh whe Sizi khuni ulhtus-i be bubulh yalhduk whe 'et ndúbulhni, “Yinka dune ye' yaidlanne toh dunadutádalh whuts'un ndet hooh'en-un, khun 'uyoonne dóhni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","'Et yugha hodul'ehne, 'enne huyoodulhkut, “Ndunne Moses be 'udustl'us 'uk'ununáguzne, 'et di ha' hutni, Elijah 'en cho whusatiyalh huba' hoont'oh hutni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","'Et Sizi ndúbulhni, “'Et 'alha Elijah 'en cho whusatiyalh 'ink'ez ndai hoonliyaz ts'iyawh lhanaidutileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Et hoonts'i nohdusni, Elijah 'uda' whusainya whe 'unt'oh. 'Ink'ez 'en 'aw t'ehinúszun. 'Et hukwa' huninzun k'un'a 'uhuyinla. 'Et whuz un'a za 'enne bula be yinka dune ye' dzoh nutizut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","'Et yugha hodul'ehne, 'enne ts'iyawh John dune too be 'ulh'en-un, 'en ghu yalhduk t'ehonanzin. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","'Awet 'ilhozdilne butanahundil whe 'ilhoghun dune yughu ninya 'ink'ez yubut dugwutsi be nenínya. 'Ink'ez 'utni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“SMoodihti sye' 'en oogha te'ninzeh! Ookaootuzuk 'ink'ez tube dzoh nuzut. Lhat tsudúlts'uk 'ink'ez talts'uk cha 'ut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'Et ngha hodul'ehne bughi nústih hoonts'i 'aw soo na'huyooleh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","'Et Sizi ndutni, “Nohni 'andit whudizulhne, nohni 'aw be 'alha hoont'oh-i lhaht'ih, 'ink'ez tank'us za' 'iht'elh. 'Et dawhuldzoh nohtoh tisdalh? 'Ink'ez dawhuldzoh nohba 'et ndutist'elh? De', nye' 'en sghu nilhtih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","'Et ntsi'-i nududeh-i ooyudinda-un, Sizi 'en ts'un khuni ulhtus-i be hukwa' yudáni'. 'Et whulh hulhgha za yuts'u hanája 'ink'ez ndun ts'oodun soo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","'Et Sizi yugha hodul'ehne, 'enne disoh ts'e highu nindil whe 'uhuyulhni, “'Et dahoont'oh huwa whe ndun ts'oodun ntsi'-i nududeh-i oots'u hanáts'inooyoot ait'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","'Et Sizi ndúbulhni, “'Aw nohba 'alha lhe'hoot'oh 'et huwa 'aw 'oohleh ait'oh. 'Alha nohdusni ndi 'anukat-i lhe'niltsool-i, 'i mustard huyulhni, 'i k'un'a be nohba 'alha' hoont'oh-i, 'et 'ulcho de, 'et ndiz 'un'a da' 'udoohtni'. Ndi dzulh njan whuts'un, 'et nguz nailts'ut dahni de, 'aho 'et dutínelh. 'Et whuz un'a ts'iyaitsuk whuz un'a 'udahni de, 'et ndutít'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Et hoonts'i ndi ntsi'-i nududeh-i, netenadudli-i, 'ink'ez soo ts'úhoonih, 'et de za dune buts'u hanáts'iyuntiyulh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","'Et 'awet Sizi 'ink'ez yugha hodul'ehne, 'enne Galilee yun k'ut hudilhts'i whe ndúbulhni, “'Awet nilhdukw yinka dune ye', 'en 'uyoonne dune tl'ahítilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Hituzilhghelh 'ink'ez whulh tat dzin inle' de, dunadutádalh.” 'Et hodánts'o whe ts'iyawh tube ts'odi huzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","'Awet keyoh Capernaum whuz hoozdil whe 'ilhoghun sooneya 'ilhunaoo'aih-un, 'en Peter yughu ninya whe yoodulhkut, “Whunohodulh'eh-un 'en cha iloh lakw lugliz whucho whuzooneya yuk'elha hoolh'i?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","'Et, “A,” ni. 'Et Peter yoh ts'u whinya. 'Et Sizi yutso yatílhduk 'ink'ez 'et dúyulhni, “Simon, daja ninzun? Ndi ndai la sooneya dune buba k'elha yutaleh-i, ndi yun k'ut whulerwene, 'enne ndi sooneya 'ilhunahos'aih? Dich'oh bubuzkeh tilah k'us n'awh whut'enne tilah?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","'Et Peter ndúyulhni, “'Aw n'awh whut'enne, 'aw 'enne za.” Sizi 'uyúlhni, “'Et 'alha' dini. Lerwene dich'oh bubuzkeh 'enne 'aw buba k'elha hole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","'Et hoonts'i ndunne Capernaum whut'enne, 'enne nebulh hónilch'e hukw'un'a 'ubuts'oolh'en ait'oh. 'Et huwa ndi lugliz whucho whuzooneya', 'i la buba k'elha ts'uyoolhtselh. Dugwe', bun guz ts'inyalh 'ink'ez oolhjas. Soo 'udechoo lho silhjus-i, 'i ooze lhch'az 'uhoonleh. 'Et sooneya naitán'alh. 'I ilhchoot 'ink'ez neba bugha ínin'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","'Et 'oh da' za Sizi yugha hodul'ehne, 'enne highu nindil 'ink'ez huyoodulhkut, “Yak'uz whulerwe dilhts'i-un mbe suba k'us dízti'?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","'Et Sizi ndun ts'oodunyaz 'anih yulhni, 'ink'ez butoh neínilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","'Ink'ez 'et ndúbulhni, “'Et soo ts'ih'un un'a 'unohdusni, 'et 'aw 'uts'un un'a nalhe'zahne de, 'ink'ez ts'oodunneyaz k'oh ts'e aht'oh nasahdli' de, 'et de za nts'e la yak'uz whulerwe unli-un whuz tihdulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","'Et huwa ndun ts'oodunyaz, mbe la yuk'oh ts'e 'unt'oh-un, whuz un'a dich'oh te'dudil'en, 'et ndunt'oh-un, 'en nts'e la yak'uz k'une' whul'en-un, 'enne butoh k'us hidilhti'-un tileh whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Ink'ez mbe la ndun ts'oodunyaz, mbe la yuk'oh ts'e 'unt'oh-un, huhóont'i' 'i bulh highu nuseya, si cha whuz un'a za 'usuhinla.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“'Et ndunne ts'oodunne buba 'alha' 'ust'ohne, ts'oodunne hoontsi' ts'e ubonilht'ine, mbe la dune edújane, 'enne tse cho buts'ilchun ehudinguz 'ink'ez k'us takhulh-un 'et tábuhano de, 'et 'on nus hootázoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ndi yun k'ut dilhts'ine, 'enne mbene la hukwaya hooni tune' 'ut'enne, 'enne dawhultsi'-un, 'et buts'u hóolts'ulh whe' hint'oh. 'Alha njan hukwaya hooni tune' hutit'en whe' hoont'oh. 'Et hoonts'i mbe la oogha 'et 'úhooja-un, 'enne dawhultsi'-un, 'et hoti'elh whe' hoont'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Et nla k'us nke 'i be hukwaya hooni tune' 'ínt'en de, k'unint'as 'ink'ez 'un tilh'is! 'Et dzoh ninya k'us nyust'e bodin'ai de, 'et whuz un'a 'ilhiz be ts'ukhuna-i nghalts'ut de, 'et whuz un'a 'uk'enus mba hootázoo'. 'Et hoonts'i nke nankult'oh cha 'ink'ez nla nankult'oh cha bulh 'ínt'oh whe kwun nalhnusne-i tanyoníno de, 'uk'enus mba hootátsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Ink'ez nyuna be hukwaya hooni tune' whut'en-un whunilh'en de, nyuna hanín'aih 'ink'ez 'un ntilh'is! 'Et nyuna 'ilho bulh za, 'et whuz un'a 'ilhiz be ts'ukhuna-i ngha nínzut de, 'uk'enus mba hootazoo'. 'Et hoonts'i nyuna nankult'oh bulh kwun nalhnusne-i tanyoníno de, 'uk'enus mba hootatsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“'Et ndunne ts'oodunne khun buka lhe'nuzoohzin junih! 'Alha lizas yak'uz dilhts'ine, 'enne bughu hinli 'ink'ez 'uBá yak'uz usda-un, bulizas 'enne 'ahoolhyiz hinalh ne'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'Et huwa mbene la ninta ninkatne, 'enne yinka dune ye' 'ubutilhyih ha, 'et huba whusainya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nts'en'a daja nahzun? 'Et dune 'en whunizyat whunizyai (100) 'usbai 'ut'i whe 'enne butoh 'ilhoghun ninta nílhget whe yuloh 'et nébuninla 'ink'ez ndun 'ilhoghun ninta nilhget-un, 'en dzulh k'uz yukawhenántai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Et nayilhti de, ts'ih'un un'a nohdusni ndunne yuloh 'et nébuninlane, 'enne bugha whunilhni. 'Et hoonts'i ndun 'ilhoghun ninta nilhget-un, nayilhti de, 'en gha dahoolcho 'i be suba 'on nus whuntálhnih! ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","'Et whuz un'a za ndunne ts'oodunne, 'et 'ilhoghun hoonts'i kwuncho yo ts'u tiyalh de, nohBá yak'uz usda-un, 'en 'aw hukwa lhe'nizun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“'Et nyulhutsin lubeshi be ndulhyo 'uja de, 'et oozih neninya 'ink'ez daja whe ndulhyo 'uja-un, 'et dóni'. 'Et nyun 'ink'ez nyulhutsin bulh nohnich'oh lhanaóodoohle. 'Et nghuni yílhchoot de, nyulhutsin whuch'a nanilde whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","'Et 'aw lhunyoozílhts'ai de, 'ilhoghun k'us nane te ilhchoot 'ink'ez 'et ooyoh ts'u natoohdilh. Nane k'us tane te mba lhgha 'úhudija de, 'et whuz un'a la 'uhót'e'. 'Et 'i be la daja hutni, ts'iya-i khuni ts'ih'un un'a 'uhoneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","'Et hoonts'i 'et cha 'aw lhunoh oozílhts'ai de, 'et de Yak'usda ba 'ilhunaoodulhne, 'enne cha budóhni. 'Et 'enne cha 'aw lhuboozílhts'ai de, 'et de mbe la 'aw ooba 'alha lhe'hoot'oh-un k'us mbe la sooneya 'ilhunaoos'aih-un, 'et ndun lubeshi be ndulhyo 'uja-un, 'en 'enne buk'un'a noolh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","'Alha' dusni whe' dusni, nohni ndai la ndi yun k'ut ooladihni de, 'i ndo yak'uz cha oolaoodutitnih. 'Et ndi yun k'ut ndai lhgha 'úhudija de, 'i ndo yak'uz cha lhgha 'úwhutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Doo cha za nohdusni, ndai la ookwa oodutalhkut-i, 'ink'ez nane k'us tane ndi yun k'ut lhgha nohba soo' hoont'oh de, 'et mbe la yak'uz usda-un sBá, 'en nohba whutilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","'Et huwa nts'e la soozi' gha nane k'us tane 'ilhunaoodilh de, 'et de si cha nohtoh 'ust'oh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","'Et Peter yughu ninya whe yoodulhkut, “SMoodihti mbe la sulhutsin 'en lubeshi be sdulhyoh 'uja-un. Dawhultsuk sdulhyoh lubeshi 'utilelh 'ink'ez ooba whunaoodutiznoh? Lhtak'ant'it tilah 'et 'uwhultsuk-un?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","'Et Sizi ndúyulhni, “'Aw lhtak'ant'it lhduzusnih. 'Et lhtak'ant'it whunizyat (70) k'us 'on 'un tilah 'et 'uwhultsuk dusni whe' dusni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","'Et yak'uz k'úne' whul'en-un, 'et ndiz un'a nja duhoont'oh. Ilhoghun lerwe unli da', 'et be 'ulhnane, 'enne daltsuk be buts'ú whulh'ai, 'i ts'iyawh ye bubúlh lhanaoodutile, 'et hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","'Et whe' whunilh'en whe 'ilhoghun be 'ulhna-un dahinilhti. Ndai la ye yuts'ú whulh'ai-i, 'i 10,000 sooneya dizti'-i, 'et 'ultsuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Gak! Yuk'elha yoolhtselh-i hooloh. 'Et ndun lerwe dughuni be 'et ndi yulhni, 'et ndun dune, du'at, duduzkeh, 'ink'ez ndai yut'i-i cha, ts'iyawh ye 'óket. 'Et de soo sba k'elha whutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","'Et huwa ndun be 'ulhna-un yubut nachániti 'ink'ez yuts'un tedudli whe 'uyulhni, ‘Smoodih k'at, huba silh'i! Ts'iyawh mba k'elha whutiselh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Oomoodih tube yugha te'nanzin. 'Et ndai la ye yuts'u whulh'ai-i, ts'iyawh yuba whunaoodilhnoh, 'ink'ez whenayalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","'En 'ulhna za 'az whinya whe doo cha 'ilhoghun dudulh 'ulhna-un, 'en nayilhti. 'En whunizyat whunizyai (100) sooneya ts'uditi'-i, 'et 'ultsuk yuts'u whulh'ai. Yuzool ílhchoot whe 'uyúlhni, ‘Ndai la bé nts'o zus'ai-i, sba ook'elha hoolhtsi!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ndun yubut dugwutsi be neninya 'ink'ez yuts'u tedudlih whe 'uyulhni, ‘K'at, huba silh'i. Ts'iyawh mba k'elha whutiselh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","'Et hoonts'i 'aw lhuyoozilhts'ai. 'Et k'us 'ayan'ai ndai la ye yuts'u whulh'ai-i, ts'iyawh yuba k'elha whutilhtselh 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","'Et 'onghoh 'ulhnane, 'enne ts'iyawh honalh'en 'et dahooja la. 'Et ts'iyawh howu ni huzdli'. 'Et huwa dumoodih ts'u whehandil 'ink'ez ts'iyawh hidani'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","'Et mbe la 'et dúja-un, 'en oomoodih 'anih yudani' 'ink'ez 'et ndúyulhni, ‘Nyun 'ulhna-un k'us ntsi'-un azih 'int'oh! Sts'u tedindli ha 'et huwa ndai la be sts'o zilh'ai-i, ts'iyawh mba oonawhudizno! ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nts'en'a la ngha te'niszin, 'et whuz un'a za 'oneh huba' hoont'oh, nyulh 'ulhna-un ts'un!’ yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","'Et oomoodih yulh hunilch'e. 'Et mbene la dune dzoh nulhdehne, 'enne butl'ayálhti. 'Et ndai la ye yuts'u whulh'ai-i, 'i ts'iyawh yuba k'elha whutilhtselh whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","'Et nohni cha nohulhutsinke ninta' hant'en de, 'ink'ez nohdzi ndulcho-i be 'aw buba whunalhodulhnoh de, 'et de sBá yak'uz usda-un, 'en cha whuz un'a za 'aw nohba whunaoodoolnoh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","'Et 'awet ndi khuni Sizi 'i be bubulh yalhduk-un 'etsul 'udija whe njan Galilee yun k'ut whuch'a nasja. 'Et Judea yun k'ut Jordan koh 'on ch'az whuz oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lhane dune 'et whuz huyoonizdil. 'Et soo na'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","'Et ndunne Phariseene, 'enne cha highu nindil hiyootálhdzih ha. 'Et huyoodulhkut, “'Et ndet huwa ne'atke 'ants'i 'oh huwun buch'a naztidalh de, 'et Moses khuni netl'aidan'ai-i, 'i ook'un'a eh 'uhoont'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","'Et Sizi ubulhni, “'Et ndi 'udustl'us k'ut 'uk'eguz-i, 'i 'aw lakw ook'uyalhuzulhduk? Njan 'et, 'et ndutni, 'udechoo whe' whudit'en da' mbe dune inla-un, 'en dune 'ink'ez ts'eke bulh 'ubínla da'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","'Et 'ink'ez 'et ndutni, ‘Nja huwa dune dubá 'ink'ez duloo bulh buch'a ooya' huba' hoont'oh, 'ink'ez du'at bulh lhulh za hoot'e' huba' hoont'oh. 'Et whuz un'a nahúlt'o 'ilho hutileh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","'Et whuz un'a 'aw 'on 'un nane lhihiloh, 'ilho za hinli suli'. 'Et huwa mbe la Yak'usda lhgha bunilhtine, 'aw dune lhch'a nabólhtelh huba lhe'hoot'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","'Et huyulhni, “'Et di ha Moses 'oh da' whuz un'a netl'ahón'ai 'ink'ez 'udustl'us cha neba inla inle' whe dune, 'i du'at tl'ayóolhchoos 'ink'ez naitoolh'a'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","'Et ndúbulhni, “Nohni nohnich'oh nohdzi dulhts'un, 'et huwa Moses noh'at whuch'a naoohja-un nohtl'ahón'ai. 'Et hoonts'i whe'whudit'en whuts'un, 'aw 'et dulhúhoot'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Inka 'unohdusni, dune oo'at 'en 'uyoon dune bulh ninta' 'ant'en t'eoonanzin de, 'et de za ndi 'udustl'us ndai la ye 'etsul itilelh-i, 'i du'at tl'ayóolhchoos. 'Et oo'at 'aw edúlhinel 'et hoonts'i ndi 'udustl'us yutl'ayálhchooz de, 'ink'ez 'uyoon ts'eke ghu nasda de, 'et de dune ts'eke bulh ninta' 'ant'en-un suli'. 'Ink'ez ndun dune oo'at 'etsul 'uyinla-un 'ink'ez 'uyoon dune ghu nasda de, ndun dune 'en cha dune ts'eke bulh ninta' 'ant'en-un tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","'Et Sizi yugha hodul'ehne, 'enne 'uhuyulhni, “'Et dune du'at bulh whuz un'a 'uhutit'elh de, 'aw lhghu lhuhíkoh de, 'et 'on nus soo' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","'Et ndúbulhni, “Ndi khuni, 'i 'aw ts'iyanne ba lhe'it'oh. Mbe la ooghá whunt'aine, 'aw 'enne za buba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","'Et whulohne dune 'aw bughez hoonuloh whe huwhuzdli. 'Et 'onghohne 'et whuz un'a dune 'ubinla. 'Ink'ez whulohne yak'uz whulerwe-un, 'en ba whuz un'a soo whulh 'utit'elhne, 'enne whuz un'a la whulh 'úhoot'e'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","'Et 'awet ts'oodunneyaz highu bunínla. Khun tilah buk'édolnih 'ink'ez buba tenadoodli ha. 'Et hoonts'i yugha hodul'ehne, 'enne dah hubuhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","'Et Sizi ndúbulhni, “Whute ts'oodunneyaz sts'ó toodilh. Khun te dah budóhni' junih! Mbene la yak'usda whe lerwe unli-un whuz dilhts'ine, 'enne ndunne ts'oodunneyaz ubunduhúlt'oh whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Dula be buk'udalni, 'ink'ez buch'a nasja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'Et 'awet 'ilhoghun dune Sizi yughu ninya 'ink'ez yoodulhkut, “Dune hodulh'eh-un unzoo-un, nts'en'a hoonzoo k'un'a 'utist'elh whe 'ilhiz khutisnalh-un whuch'a ootásdoh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","'Et Sizi ndúyulhni, “'Et di ha sudini, unzoo-un sudini? 'Aw 'ilhoghun unzoo-un hooloh. Yak'usda 'aw 'en za unzoo whe 'unt'oh. 'Et hoonts'i 'ilhiz be ts'otinalh-un hukwa' ninzun de, ndai la Yak'usda khuni dune tl'aidan'ai-i, 'i ook'une' 'int'en da.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","'Et 'uyulhni, “'Et k'us ndai whe' dini?” 'Ink'ez Sizi ndúyulhni, “Dune sólhghelh junih! Ts'ekoo bulh ninta' 'ont'en junih! Undunont'ih junih! 'Uyoonne ba honts'it junih! ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mbá 'ink'ez nloo bulh ubudólhti'! Nts'en'a la nyunch'oh k'enaintsi', whuz un'a za nyulh dune buk'eontsi'!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","'Et ndun chilh ndúyulhni, “Usool da' whuts'un, ndi ts'iyawh ook'une' zust'en. Nts'en'a 'on 'un datíst'elh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sizi ndúyulhni, “Lhadulya-un tant'elh hukwa' ninzun de, ndai la 'int'i-i, 'i ts'iyawh be 'oonket, 'ink'ez tel'enne butainínle. 'Et de la ndo yak'uz ndai 'ilhoozanla-i, 'et mba tilalh. 'Ink'ez 'anih se' 'ut'en k'oh tune' ónt'en ha sunanyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","'Et ndun chilh ndi khuni yudánts'o whe tube oodzi unduda whe yuch'a nasja. Tube hoonzoo' 'unt'oh-un 'unt'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","'Et Sizi yugha hodul'ehne ubúlhni, “Ndi 'i be soo ts'ih'un un'a nohdusni, yak'uz ts'e, nts'e lerwe unli-un, tube howa whulna' whe hoonzoo' 'unt'oh-un whuz tiyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Doo cha za 'unohdúsni, ndi khuna ncha-i, camel huyulhni, 'i ooba howa whulna' whe ughabátsulh oola toh ookonín'a-un hukwa tílgwulh. 'Et hoonts'i whanus howa whulna' whe hoonzoo' 'unt'oh-un, 'en Yak'usda whe lerwe unli-un whuz datíyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","'Et yugha hodul'ehne, 'enne hidants'o whe buba hooncha 'ink'ez 'et duhutni, “Mbe za dutijih ha' dini?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sizi ubunilh'en 'ink'ez ndúbulhni, “Dunene, 'aw ndet la 'uhuhooleh ait'oh-un, 'et hoonts'i Yak'usda ba huwa lhúhoolna' whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","'Et Peter yatilhduk whe Sizi nja dúyulhni, “Whunilh'en, ndai la ts'ut'i-i, 'i ts'iyawh oolazditni, 'ink'ez nye 'ut'en k'oh ts'e ts'oot'en ha nyuts'un tizdil. 'Et huwa ndi la negha nínkat?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sizi ndúbulhni, “Ts'ih'un un'a nohdusni, nts'oya hoozulh whe ts'iyaitsuk 'andidi-i natidleh, 'et 'oh whuya hoozulh whe yinka dune ye', yukw'uts'uzda cho dizti'-i, 'i yuk'etl'adutadalh. 'Et nohni suntizdil inle'ne, nohni cha whunizyai 'on 'at nanki kw'uts'uzda-i dune buba nahutiyeh ha, 'et dutálhts'ilh. 'Et whe la Israel oots'u haindene, 'enne whunizyat 'on 'at nane lhendoh didowhne, 'enne buba nahutihyeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","'Ink'ez mbe la si soozi' gha duyoh huwu tizya de, k'us dulhutsinke te, k'us dulhtuske te, k'us dubá cha 'ink'ez duloo cha te, k'us du'at te, k'us duzkehke te, k'us dukeyoh cha, njan si soozi' gha huwu tizya de, 'en la whunizyat whunizyai (100) 'et 'uwhultsuk-un ootl'anaóotikulh. 'Ink'ez 'ilhiz whe ts'ukhuna-un, 'et cha oogha óotalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","'Et hoonts'i lhane mbene la 'udechoo 'unt'ohne 'udek'ezne nahutidleh. 'Ink'ez lhane mbene la 'udek'ez unline, 'enne 'udetsone nahutidleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ndiz un'a yak'uz whulerwe ts'iyawh k'une' whul'en, 'Ilhoghun dune 'en ndi yun k'ut yun ut'i-un. 'Et ts'ekoo too' mai chun haniyeh k'et, 'et huba 'utit'elhne ha' ninzun. Bundada 'uda' 'et dune tilh'alh ha whuz whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","'Et ndunne ubalh'a'ne 'ilho sooneya ts'uditi' 'i dzin dulyiz whe hik'elha utit'elh-un, huhóost'et. 'Et huwa oots'ekoo too' mai chun haniyeh k'ez whebalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","'Et hukw'elh'az 9:00 at'en t'alh-i be 'óoket-un daninya whe dune bunilh'en 'ants'i 'oh nodilhya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","'Et nja dúbulhni, ‘Nohni cha nghuz ts'ekoo too' mai chun haniyeh ts'e ahdulh. 'Ink'ez nts'en'a la sooneya ts'ih'un 'unt'oh-i, 'i nohba k'elha tiselh.’ 'Ink'ez whuz whe handil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","'Et doo cha hukw'elh'az ts'etniz at'en k'us 3:00 at'en cha whuz whinya. 'et whuz un'a za doo cha za 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Doo cha za hulhgha ts'e at'en whuz whinya 'ink'ez 'uyoonne cha 'ants'i 'oh nodilhya whe bunilh'en. 'Enne cha ndúbulhni, ‘'Et di ha dzin dúwhulyiz whe 'ants'i 'óh nudulhya?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘'Et 'aw dune lhuneulh'oh 'et huwa ts'int'oh,’ huyulhni. 'Et ndúbulhni, ‘Nohni cha ghuz ts'ekoo too' mai chun haniyeh ts'e ahdulh. 'Ink'ez nts'en'a la sooneya ts'ih'un 'unt'oh-i, 'i nohba k'elha tiselh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Et 'awet hulhgha ts'e dune 'etsul ut'ih-un whe ndun ts'ekoo too' mai chun 'ut'i-un, 'en bughunli-un 'anih yudani' 'ink'ez 'uyulhni, ‘'It'enne ts'iyawh whusábinle, 'ink'ez buba k'elha hoolhtsi. 'Et mbe la 'udek'ez whe'dit'en-un, 'en cho ooba k'elha hoolhtsi.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Mbene la hulhgha ts'e at'en ul'a'ne whusahandil whe 'ilhone hinli 'ilho sooneya ts'uditi'-i buba k'elha yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","'Et ndunne 'udechoo ul'a'ne, 'enne cha whusahandil. 'On nus lhai duba k'elha tileh huninzun. 'Et hoonts'i whuz un'a za 'ilhone hinli 'ilho sooneya ts'uditi'-i buba k'elha yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","'Enne ts'iyawh buba 'uk'elha whuzdli' hukw'elh'az, 'et ndun yun ut'i-un hich'az yawhenilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","'Et 'uhuyúlhni, ‘Ndunne 'udek'oh ubalh'a'ne, 'enne 'ilhoh sadzi hukw'uhoonist'oh-un za' hit'en. 'Ink'ez wheni dzin ndúwhulyiz whe sa ulhtus-i niz 'uts'it'en. 'Et hoonts'i 'enne neulh húlhgha za buba 'uk'elha whuzílhtsi.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","'Et yun ut'i-un 'et ubúlhni, ‘Sk'ekene 'aw hoonliyaz whe 'aw tank'us un'a lhenohúsdli. 'Et ts'iyawh nohba soo' hoont'oh 'ilho sooneya ts'uditi'-i k'elha nohis'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'Et 'awet ndai la nohch'e' ulhchoot 'ink'ez nahdulh. 'Et mbene la ndunne 'udek'oh 'ubis'a'ne, 'enne nohni nohk'un'a za 'et 'ultsuk 'i za buba k'elha tiselh 'et hukwa' nuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","'Alha iloh lakw ndai la ust'i-i nts'en'a hukwa' nuszun tune' 'ús'en? 'Uszoo' 'et huwa eh sghe oolhnih?’ ubúlhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","'Et 'awhuz Sizi njan howu yalhduk whe ubúlhni, “Mbene la 'udek'oh unline, 'enne 'udechoo nahutidleh. 'Ink'ez mbene la 'udechoo unline, 'enne 'udek'oh nahutidleh. 'Et huwa Yak'usda lhane 'anih dáni', 'et hoonts'i ntsoolneyaz za 'utahaínla.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","'Et 'awet Sizi Jerusalem ts'u tizya. 'Ink'ez ndunne whunizyanne 'on 'at nane mbene la yugha hodul'ehne, 'enne 'udun nebuninla 'ink'ez ndúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Soo zúlhts'ai, Jerusalem ts'uztidulh 'ink'ez yinka dune ye', 'en ndunne lubret moodihne, 'enne cha, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'et 'awet butl'ahitilhtelh, datitsah ha hiba nahutiyeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Ink'ez 'udun yun k'ut whut'enne butl'ahitilhtelh. 'Et butl'ahúyalhti de, highu tidloh, huyootalhtsus, 'ink'ez 'et tulalhgus k'ehuyitalhtelh. 'Ink'ez hukw'elh'az whulh tat dzin dunadutádalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","'Et 'awet Zebedee buzkeh duloo te, 'et 'awet Sizi ts'o tizdil huyoodutalhkut ha. Buloo yubut nachaniti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","'Et Sizi ndi yulhni, “Ndet sts'o hukwa' ninzun?” 'Et ts'eke 'utni, “Nts'e whulerwe inli-un, ndunne nane suzkeh, 'enne 'ilhoghun nailhni ts'unk'us tidalh 'ink'ez 'ilhoghun intl'us ts'unk'us tidalh, sgha óonin'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","'Et Sizi nja dutni, “Ndet hukwa' oodulhkut-un 'aw t'eoonuzahzun. Ndi lubot 'awet be' tisnelh-i, nohni cha be' tihnelh nahzun eh? 'Ink'ez ndai la dune be too be 'ul'en-i, 'i be 'usotilelh. Nohni cha whuz un'a za eh too be' tilhnelh?” 'Et nduhúyulhni, “A, 'et la 'et nduts'óoneh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","'Et ndúbulhni, “'Alha slubot be' tihnelh, 'ink'ez be too be úzya-i, 'i be too be' tilhnelh. 'Et 'aw doosni' ait'oh mbe nailhni ts'e sts'unk'us tidalh 'ink'ez mbe intl'us ts'e sts'unk'us tidalh. Mbene la 'uBá buba lhaóodinlane, 'aw 'enne za buba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","'Et 'onghohne whunizyanne hidants'o whe, 'awet ndunne nane lhulhutsinke buba dzoh 'uhudija. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","'Et Sizi ndunne ts'iyawh 'anih ubudani' 'ink'ez 'ubulhni, “Nohni t'eoonahzun ndunne 'udun yun k'ut whut'enne bumoodihne, 'enne dunene k'une' buhul'en. 'Ink'ez mbene la nchane, 'enne ndunne bumoodihne buba ando 'uhint'oh. 'Et whuz un'a bube 'ut'en k'oh hooni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","'Et hoonts'i nohni nohtoh whuz un'a 'utiht'elh noohzin junih. 'Et mbe la nohtoh ncha tileh hukwa' ninzun-un, 'en nohba ne'út'en-un oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","'Et mbe la nohtoh 'udechoo tileh hukwa' ninzun-un, 'en nohe'ulhna-un oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Whuz un'a za yinka dune ye', 'aw ba ne'whutit'en hukwa whusálhiyal. 'Et k'us dune buba ne'ut'en-un tileh 'ink'ez buba datitsah, 'et whuz un'a lhane naootakulh. 'Et hukwa whusainya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","'Et 'awet hukw'elh'az Jericho keyoh whuch'a náhusdil whe lhane dune hiyuntizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nane hoos̱'enne ti whuzih huzkeh. 'Et Sizi 'oh whuya uyalh whe hiduzts'ai. 'Et 'ultus-un hika huyih, “Moodihti, David oots'u haínzut-un, negha te'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","'Et 'ilhunaoodilhne, “T'eduzahnih!” hubuhútni. 'Et hoonts'i 'on nus 'uhutni, “Moodihti, David oots'u haínzut-un, negha te'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","'Et Sizi lhgha neninya 'ink'ez ubulhni, “Diz áh'us. Ndet nohba 'uwhutisdlelh hukwa' nahzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“NeMoodihti nena be ts'ontilh'elh hukwa' uzninzun,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Ink'ez Sizi bugha te'nanzin whe dula be buna yut'aíznai. 'Et 'aho huhoo'en suli'. 'Et 'awet huyuntiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","'Et 'awet Jerusalem whenghoh hidulh whe keyoh whuyaz Bethphage huwhutni-un, 'et whuz hoozdil. 'I dzulh enun, Olive huwhutni. 'Et Sizi nane yugha hodul'ehne, 'enne dutso whébalh'a' ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","whe ubulhni, “Njan keyoh whuyaz nohanch'az whuz ah'us. 'Et whuz oozah'az de, 'et 'aho yeztliyaz, donkey huyulhni, ooyaz bulh whehudint'i, 'et la ubunoolh'en. k'unabooh'uk 'ink'ez diz sts'ún 'ubutoolhdlooh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","'Et dune nohoodulhkut de, ‘Di ha 'ubulh'en?’ nohuwhútni de, ‘NeMoodihti yuka' ninzun,’ dóhni'. 'Et 'aho sts'un bula dutitnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","'Et whuz un'a ndi ts'iyawh 'oh tune' whust'en. 'I be nus hon'en-un daja ni la, 'et ndulcho 'et dúhooja. Njan 'et nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Zion ookeyoh whuti whut'enne, whunulh'en! Nohlerwe te'dudil'en whe nohts'u tiyalh. Donkey ooyaz, 'en yuk'usda. 'En be nohts'u tiyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","'Et ndiz un'a nja dúhooja, Sizi yugha hodul'ehne whuz whehan'az, 'ink'ez Sizi daja ubúlhni la, 'oh te né'hust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'Et whuz un'a Donkey ooyaz bulh hits'u boolhti. Dunaih hik'ehíyinla 'ink'ez 'on dus de Sizi hik'etl'ahidilhda'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Lhane dune dunaih ti hiba néhinilhbal nts'oya la lhutiyalh-un. 'Ink'ez 'onghohne, 'enne cha 'uzischum nanehidutselh 'ink'ez ti hiba nehídinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","'Et 'awet 'ilhunaoodilhne whulohne ootso 'ink'ez whulohne ook'oh ts'e hidulh 'ink'ez tube cho huhuyih whe hutni, “David oots'u haínzut-un ba ts'odilhti'! NeMoodihti boozi' be whuz de úyalh. 'En 'uk'enus hoonzoo-un ooba whults'ut. 'Et soo yoodughi hidílhti'!” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","'Et 'awet Sizi keyoh Jerusalem whuz oozya whe ndunne keyoh whut'enne khunahuntisdil whe 'ulhodutni, “Ndun mbe whe 'unt'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","'Et 'ilhunaoosdilne hubuhútni, “Ndun 'en Sizi nus hoo'en-un, 'en 'unt'oh. Keyoh Nazareth yun k'ut Galilee whuz'ai-un, whuz de hainya-un 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","'Et 'awet Jerusalem bulugliz whucho whuna'niztl'oo-un daninya whe mbene la 'ooketne 'ink'ez 'e'óoketne, 'enne ts'iyawh tenabuninyoot. Sooneya lhk'enadulene bulutab 'i cha ts'iyawh buch'a yuntiz'ai. Mbene la dut'aiyaz, dove huyulhni, be 'óoketne, 'enne bukw'uts'uda 'i cha buch'a yuntiz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","'Et ubúlhni, “'Uk'ehóoguz whe nja dutni, ‘'Et njan syoh tenadudli ba yoh dahni,’ 'et hoonts'i 'et cha nja dutni, ‘'Undunut'ihne, 'enne buyoh whuzúlhtsi.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","'Et lugliz whucho 'et hoos̱'enne 'ink'ez ookechun ndudane, 'enne highu nindil, 'et soo na'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","'Et ndunne lubret bumoodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'enne njan huwa 'ít'en tune' 'ust'en whe hinalh'en. 'Ink'ez ts'oodunne, 'enne cha lugliz whucho sulyahalhduk whe nja duhutni, “David oots'u haínzut-un ooba ts'odilhti'!” 'Et njan ts'iyawh honalh'en whe hukwa honilch'e. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'Ink'ez Sizi 'et nduhúyulhni, “Ndi daja hutni la uboozílhts'ai eh?” 'Et ubulhni, “A, 'ink'ez dahúja-un 'aw hukw'uyalhuzusduk whe eh dahni? Ndiz un'a 'uk'ehonguz whe nja dutni, ‘Ts'oodunne 'ink'ez ts'oodunne nulhyehne cha, 'enne bughuni 'i be' hutni, ts'ih'un un'a sba hodilhti' ubulhtsi.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","'Et ndunne 'awet buch'a nasja 'ink'ez keyoh whuti huwu whenája. 'Ink'ez keyoh whuyaz Bethany ts'oozya whe 'et usda. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Et 'om bun 'uda' 'et keyoh whuti whuts'u hídulh whe khunsul ooye'ílts'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","'Et ti whuzih khunsul ndi mai chun, fig huyulhni, yutilh'en. 'Et yuts'oozya whe 'et 'aw oomai' ooghu hooloh. 'Ut'an za ooghu hoonli whe 'uyulhni, “'Et 'aw 'ilhiz nyumai' hootáloh.” Ni ibulh ndi duchun uyulhni-i dizgi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Mbene la yugha hodul'ehne huyan'en whe tube buba hooncha. 'Et 'uhutni, “Nyoo mai chun, fig huyulhni, daja whe 'uja 'á stla dizgi?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","'Et Sizi ndúbulhni, “'Alha nohdusi, bé 'alha' hoont'oh-i aht'i de, 'ink'ez 'aw nohba nawh lhe'whutást'el whe ndi mai chun cha 'á dizgi, nohni cha whuz un'a za 'et dutihnelh. 'Ink'ez 'aw 'et za iloh, njan shus 'i la' dóhni, ‘Dudilhts'ih 'ink'ez bunghun whucho ts'e tailhts'ih,’ dahni de, 'et whuz un'a 'et duwhútanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Et ndai la ooka' dahni tenadudli be, nohba 'alha' hoont'oh de, 'i ts'iyawh nohgha tíkulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","'Et 'awet lugliz whucho daninya whe 'et dilhts'ine whe whúbondunilh'e'. 'Et 'udedo lubretne 'ink'ez dune 'utso whudilhdzulhne cha, 'enne highu nindil 'ink'ez 'uhuyúlhni, “Nedini ndai gha dune ando 'int'oh whe nja dint'en-un. K'us mbe ntl'ahon'ai whe dune ando 'int'oh-un?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","'Et Sizi 'ubulhni, “Si cha 'ilhoghun hukwa nohoodutaskut. 'Et sudahni de, 'et nohdutasnelh ndai gha dune ando 'ust'oh whe nja dust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nts'en'a John dune too be 'úlh'en? Mbe yutl'ahon'ai dune too be tilh'elh huba? Yak'uz ts'e tilah hahóolts'ut, k'us dune tilah ts'u hahóolts'ut?” Dich'oh lhtoh howu yahalhduk 'ink'ez 'uhutni, “'Et yak'uz ts'e hahóolts'ut ts'utni de, 'et la 'unedóne', ‘'Et diha John nohba 'alha' lhe'dusni?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","'Et hoonts'i, ‘Dune ts'u hahóolts'ut whutilah 'uhoont'oh,’ ts'utni de, 'aw uzdooni' ait'oh, dune bubeznuljut, ts'iyawh John 'en nus hoo'en-un 'unt'oh huninzun 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","'Inka Sizi nduhuyulhni, “'Aw nts'ez de hahóolts'ut t'ets'onuszun.” 'Ink'ez Sizi ndúbulhni, “Ndai be dune ando 'ust'oh whe ndi nja duwhús'en-un, 'et si cha 'aw nohdósni' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nja huwun daja nahzun? 'Ilhoghun dune nane buzkeh. 'Enne 'udechoo-un yughu ninya 'ink'ez yulhni, ‘Sye' ts'ekoo too' mai chun haniyeh ts'e whuz inyalh 'ink'ez sba 'int'en.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","'Et yuch'a tsédisnih inle'. 'Et hoonts'i hukw'elh'az ndunát'e' 'ink'ez whuz whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","'Et bulh nat-un ooye', 'en cha yughu ninya 'ink'ez yulhni. ‘A, whuz toosya' 'ink'ez 'oost'en la!’ yulhni. 'Et hoonts'i 'aw whuz lhtiyal.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","'Et Sizi 'utni, “Ndunne nane k'us mbe ndet oobá buba hukwa' ninzun 'oh te hukw'une' hust'en?” “'Et 'udechoo-un, 'en za,” hutni. 'Et Sizi ndúbulhni, “Ts'ih'un nohdusni ndunne sooneya nalhdzoohne 'ink'ez ts'ekoo 'ul'enne cha, nts'e la Yak'usda lerwe unli-un, whuz nohtso hutidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndiz un'a nja duhoont'oh, be ts'ih'un un'a 'uhoont'oh-i, 'i be John dune too be 'ulh'en-un nohts'ó whusainya, 'ink'ez 'aw nohba 'alha lhe'hoot'oh. 'Et hoonts'i sooneya nalhdzoohne 'ink'ez ts'ekoo 'ul'enne, 'enne ts'iyawh buba 'alha' hoont'oh 'et huwa. 'Et nohni whunulh'en 'et hoonts'i 'aw noheni k'oh nálhe'uhlel. Whuz un'a za nohba 'alha lhe'hoot'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nja 'uyoo be nawhutnuk-i be nohdutásnelh. Soo zólhts'ai'! 'Ilhoghun yoh whumoodih-un, 'en haniyeh k'et 'uhoonla, 'ink'ez mai ts'ekoo too' chun 'ananla. 'Ink'ez whuna'niztl'oo. 'Et tsak'et hahónkai mai too' 'utahahúlhtsus-un, 'et cha neóonin'ai. 'Ink'ez ook'ut yutist'en-i cha wheni 'uhinla. 'En la njan haniyeh k'et ndunne ha' nulhyehne butl'ahón'ai, 'ink'ez nilhdza' keyoh ts'e whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","'Et 'awet 'oonujin-un neooninzut whe yoh whumoodih de 'ulhnane, 'enne whuz whebalh'a' 'ink'ez ndunne 'ut'enne, 'enne buts'un mai hitalhchulh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","'Et ndunne ha' nulhyehne, 'enne yoh whumoodih de 'ulhnane hubílhchoot. 'Ilhoghun soo 'uzi 'unhitizno. 'Ilhoghun cha hizilhghi. 'Ilhoghun cha tse be hizilhghi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","'Et doo cha za 'onghohne 'ulhnane 'on nus 'ultsukne whuz whebalh'a'. 'Enne cha whuz un'a za 'et dúbuhinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","'Et 'udek'ez-un duye' whuz buts'ú wheyalh'a'. ‘'En tilah hidólhti',’ ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","'Et hoonts'i ndunne bughu whulh'aine hitilh'en whe 'et 'ulhodutni, ‘Ndun 'en nyoo haníyeh k'et ooch'e'-un, 'en ooye' 'út'en. Ts'uzoolhghelh! 'Et de la ndet la oots'ó tilts'ulh-un ts'iyawh 'et ndúwhulcho whe la ts'ohólhchoot!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'Inka huyílhchoot 'ink'ez njan haníyeh k'et tenáhinino 'ink'ez hizilhghi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","'Et huwa 'et njan mai ts'ekoo too' chun haniyeh-un, 'en ooch'e', 'en whusatiyalh. Whusainya de, 'et dábooleh suba?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","'Et nduhúyulhni, “'Et ndunne untsi'ne, 'enne hooncha hukw'un'a musai ubutilhtselh 'ink'ez njan haniyeh k'et 'uyoonne ha' úntilhyehne bugho tálh'alh. 'Et whuz un'a newhúzuk totsuk ndi mai higha hitalelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","'Et Sizi ndúbulhni, “'Aw eh hukw'u yalhuzulhduk Yak'usda ooghuni daja ni inle' da'? 'Et diz 'uk'ehooguz, ‘Ndi tse yoh 'uwhulh'enne 'ún hidutilh'uz-i, 'i yoh ook'uwhuz'ai-un huba soo 'uk'enus tse 'unt'oh-i suli'. 'Et la Moodihti whuz un'a 'uhoonla. 'Ink'ez wheni tube neba hooncha whe' hoont'oh,’ ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","'Et huwa nohdúsni, nts'e la Yak'usda lerwe unli-un, 'et ts'iyawh nohghu nahootálhchulh 'ink'ez 'udoh didowhne butl'aóoti'alh. 'Enne la 'ut'en unzoo-i buts'u haóokat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","'Ink'ez mbene la ndi tse hik'ilts'utne, 'enne ts'iyawh yahidutátih. 'Ink'ez mbene la ndi tse buk'édilts'utne, 'enne ts'iyawh musai hutileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","'Et ndunne Lizwif lubret bumoodihne 'ink'ez Phariseene cha, 'enne ndi khuni be nawhutnuk-i whulh 'úhudants'o whe t'ehonanzin Sizi 'enne didut bughu yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nts'en'a suba Sizi huyitálhchulh-un 'et hukwa' hut'en. 'Et hoonts'i dune éhunuljut. 'Enne Sizi 'en nus hoo'en-un 'unt'oh huninzun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","'Et doo cha za Sizi be nawhutnuk-i, 'i be whuts'odul'eh-i, 'i be bubulh yalhduk whe 'et dúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“'Et yak'uz k'úne' whul'en-un, ndiz un'a nja dóohoont'oh, 'ilhoghun lerwe ooye' oo'at whutaleh, 'et huba lhadútitneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'Ink'ez mbene la bughu nuséyane, dude'ulhnane buts'u whebalh'a', 'anih ubuhudóni' ha, 'et hoonts'i buch'a tséhudisnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","'Et doo cha za 'uyoonne cha dude'ulhnane whuz whilh'a'. Mbene la ooghu nusjane sba budohni', ‘'Awet t'alh-i lhadínt'oh. Njan musdoos ts'iyawh ndai la nilhk'a-i ts'iyawh sba huyanghan dune yuti'ulh whuba. Ts'iyai lhadínt'oh. 'Et 'awet ndunne lhghuskene bubulh na'uztit'ulh. Soo 'a dizáhdulh! sba budóhni'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","'Et hoonts'i ndunne bugha nusjane buba 'ants'i 'uhoont'oh. Ts'iyawh lhents'un whehándil. Whulohne cha há' hunulhyeh ts'e whenáhidil. 'Et whulohne cha bube 'ut'en k'oh whuz'ai ts'e whenáhidil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Whulohne lerwe be 'ulhnane ubihílhchoot 'ink'ez dzoh ne'buhalh'en 'ink'ez ubuhanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","'Et lerwe whulh údants'o whe tube hunílch'e. Mbene la lhuganne ubut'ine ts'iyawh whuz whebalh'a'. Mbene la be 'ulhnane inghanne, 'enne ts'iyawh musai ubulhtsi 'ink'ez bukeyoh ts'iyawh hodálhk'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","'Et hukw'elh'az 'uyoonne cha be 'ulhnane, 'enne ubulhni, ‘'Awet na'tit'úlh-un lhaoodint'oh, 'et hoonts'i ooghu nusjane 'aw huba soo lhe'hildzoo.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","'Et huwa 'et 'awet ti ts'óhdulh. 'Ants'i lhane cho nahla de, 'enne ts'iyawh bughu nóhdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","'Et ndunne be 'ulhnane ti ts'e whehandil. Mbene la nabuhinlane, ntsi'ne 'ink'ez unzoone tubulh 'alhgoh ts'iyawh whusábahanla. 'Et 'awet na'hutit'ulh-un yoh whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","'Et 'awet lerwe buts'ó whusainya ooghu nusjane ubuntilh'elh ha. 'Et 'ilhoghun dune 'en 'aw naih dune lhghu dilhts'i whunaih be dune lhiloh whe yutilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","'Et 'uyulhni, ‘Sk'eke 'aw dune lhghu dilhts'i whunaih be dune lhinloh. 'Ink'ez nts'en'a danínya?’ 'Et ndun dune 'aw whé 'oodoni'-un hoolel. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","'Et lerwe duba ne'ut'enne ubúlhni, ‘Ndun dune ulhchoot 'ink'ez ulhghel. 'Ink'ez 'az tsalhgus yo ts'e táhneh! 'Et whuz la titso 'ink'ez dughoo lhudook'us.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Njan 'et ndutni whe 'utni, lhane ghu nusja 'et hoonts'i whulohne za 'utahálya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","'Et 'awet ndunne Phariseene 'udun nehúnindil 'ink'ez howu yahalhduk, nts'en'a la Sizi ye yalhduk-i, 'i be hitilhgooh hukwa' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","'Et whe Phariseene bugha hodilh'e'ne 'ink'ez Herod didowhne cha, 'enne Sizi ts'e whebuhalh'a'. 'Et duhúyulhni, “Dune hodulh'eh-un t'ets'oninzun nyun ts'ih'un dune 'int'oh 'ink'ez khuni 'alha' 'unt'oh-i be Yak'usda k'un'a dune hodilh'eh. Ts'iyanne mba lhgha 'únt'oh. Nts'en'a la dune dahót'en 'et hoonts'i mba 'ants'i 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","'Et huwa nedini, ndi yun hik'elha huyilh'i-i, 'et ts'ih'un tilah 'uhoont'oh whe lerwe Caeser 'en tilah ooba k'elha ts'uyoolhtselh, k'us 'awúndooh tilah? Daja ninzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","'Et Sizi t'eooninzun nts'en'a la hoontsi' k'oh ts'e hoont'oh, 'et huwa ubulhni, “'Et di ha soo zúlhts'i? Nohni ts'iyawh duba na'udzoo'ne aht'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","De' la nyoo sooneya snalh ts'et nah'a!” 'Ilho sooneya ts'uditi'-i hitl'ahúyan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","'Et ubulhni, “Mbe oonin 'ink'ez boozi' cha ook'usguz?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Lerwe Caesar,” huyulhni. 'Et ndúbulhni, “'Et huwa ndai la lerwe Caeser ooch'e', 'i ootl'anáyahle. 'Ink'ez ndai la Yak'usda ooch'e', 'i Yak'usda ootl'anáyahle.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","'Et hidants'o whe ts'iyawh buba hooncha 'ink'ez hich'a nasdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Et dzin za ndunne Sadduceene, 'enne highu nindil. 'Enne la 'uhutni dats'úzsai 'ink'ez 'aw nats'uhótnah aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","'Et nduhúyulhni, “Dune hodulh'eh-un Moses ndiz un'a nja dutni, 'et dune 'aw buzkeh hooloh whe dazsai 'ink'ez oo'at za khuna de, 'et bulhutsin 'en yughu naooda' huba' hoont'oh. 'Et ndun bulhutsin 'en dughe yughu nasda de, 'en ts'un dulhutsin ba buzkeh whutaleh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","'Et netoh lhtak'ant'ine lhulhutsinke, 'en 'udetso whudilhdzulh-un, 'en 'at ut'i. 'Ink'ez 'aw buzkeh hooloh whe dazsai. 'En du'at dulhutsin ba nayoosdzi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Whúlh nane whuz un'a za dazsai. 'Et whulh tat-un, 'en cha whuz un'a za 'uja. 'Et dúwhulyiz whe lhtak'ant'ine ts'iyawh yahadla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","'Et 'udek'ez ndun ts'eke 'en cha dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Et huwa nedini 'ilhudzin whusaootilts'ulh whe ts'iyanne dunadutádulh, 'et 'oh de de ndun ts'eke mbe oo'at tileh? 'Et whunulh'en lhtak'ant'ine ts'iyawh highinda'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","'Et Sizi ndúbulhni, “Nohnich'oh na'dunaht'ah! 'Aw Yak'usda ooghuni t'enuzahzun. Ye ulhtus-i cha 'aw t'enuzahzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","'Et ndet dzin dune dunadidil de, 'aw lhghu lhodutalhts'il 'et huwa. Dune dunadidilne, 'enne Yak'usda oolizas k'un'a 'uhutit'elh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Et daja sudini yaidlanne toh dunadutádulh-un huwun, Yak'usda daja ni, 'aw eh hukw'u yalhuzulhduk? Njan nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Si Abraham, Isaac, 'ink'ez Jacob, buYak'usda 'ust'oh.’ 'Aw yaidlanne buYak'usda iloh 'unt'oh. Khunane buYak'usda unli 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","'Et 'ilhunaoosdilne dahoont'oh huwun budani' whe tube buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","'Et Phariseene whulh 'úhudants'o nts'en'a la Sizi ubudani'-un, 'et hukwa Sadduceene 'aw yahutoolhdih ait'oh whe hinat 'ilhunahosdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Et 'awet 'ilhoghun butoh-un, ni moodih unli-un, 'en Sizi yóolhdzih whe yoodulhkut, ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Dune hodulh'eh-un k'us undai khuni k'us dizti'-i neba yutulhúhizye'?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","'Et Sizi ndúyulhni, “ ‘Yak'usda nyuMoodihti ndzi ndulcho-i be cha, nzul ndulcho-i be cha, nyunut'i ts'iyawh 'i be cha, nyeni ts'iyawh 'i be cha, 'et whuz un'a 'en ook'eoontsi'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ndi ndai la nohba yutulhuhizye'-i, 'i 'udechoo 'ink'ez 'uk'enus dizti'-i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","'Et bulh nanki, 'i 'udechoo-i k'un'a 'unt'oh whe ndiz un'a nja dutni, ‘'Et dahoont'oh hukw'un'a nyunch'oh k'enaintsi', 'et whuz un'a za 'onghohne cha buk'eoontsi'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ndi nanki khuni nohtl'adílts'ut-i, 'i be Moses be 'udustl'us cha 'ink'ez nus hoo'enne bube' 'udustl'us cha, 'i ts'iyawh 'ants'i yoh ook'ut whuz'ai-i, 'i le'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","'Et 'awhuz ndunne Phariseene 'ilhunahosdil whe Sizi uboodulhkut, ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Christ mbe unli-un 'unt'oh nahzun? K'us mbe oots'u hainzut-un suba 'unt'oh?” “'En David oots'u hainzut-un 'unt'oh,” huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","'Et 'ubúlhni, “Nts'en'a 'unt'oh David Ndoni be nyun sMoodihti 'int'oh nyudúsni ni whe 'et ndiz un'a nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Moodihti 'en sMoodihti 'uyulhni, nailhni ts'ungus sinda 'oh de la nch'az ditnine buk'ut nke naóolhyis mba ubooselh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","'Et whuz un'a David, ‘SMoodihti,’ yulhni. Nts'en'a suba 'en oots'u hainzut-un oole'?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","'Aw dune yuts'u yatoolhdihne hooloh. 'Et ts'iyanne whehunuljut whe 'aw 'on 'un huyoodolhkut ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'Et 'awet Sizi 'ilhunaoosdilne 'ink'ez yugha hodul'ehne cha bubulh yawhenilhduk whe ndutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mbe la Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene, 'enne cha 'enne dune hodutilh'eh 'et wheni Moses yuk'usda-i k'ut natl'ahudilts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'Et huwa ndai la khuni hiye nohbulh yalhduk-i, 'et ts'iyawh hólhchoot 'ink'ez buk'úne' 'ooht'en. 'Et hoonts'i khun buk'un'a ne'óoht'en junih. 'Et 'alha daja hutni-un, 'oh te nulhé'hust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","'Et diz un'a né'hut'en, lhai cho lhunuhúlhtl'oo tube howa whulna' dune neyúghe huba. Dune buwus k'ehúyile. 'Et didutch'oh dulasga 'ilho hoonts'i nahayoolhna' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ndai la 'uhuyulh'en-i, 'i 'uyoonne yunoolh'en huba za 'uhuyulh'en. 'Ink'ez ndi Yak'usda ooghuni zus, Phylacteries huyulhni, 'on nus ncha huyilh'i ts'iyanne hinoolh'en ha. 'Ink'ez ndi luglok tenahududli te nahuyits'uz-i, 'i cha ootso 'on nus 'udilyiz nahuyulhtsih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","'Et 'uhat'alh-un 'ink'ez lugliz cha soo k'us hoonzoo-un 'et za hudutálts'ilh hukwa' huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Ink'ez ndet la t'alh-i be 'óoket-un, 'et ts'iyanne hubodílhti' whe hadih buhutni, 'et huhóont'i'. 'Ink'ez ts'iyawh 'ilhone hinli whe, ‘Rabbi! Nehodulh'eh-un!’ hubodóni' hukwa' huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","'Et hoonts'i khun te 'uyoonne ‘Rabbi’ nohodóni' junih! 'Aw 'ilhoghun za whunohodulh'eh-un hoonli 'et huwa, Christ 'en 'unt'oh. 'Et nohni ts'iyawh lhulhutsinke ahli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","'Et ndi yun k'ut 'ants'i 'ohne ‘'ubá’ budohne' junih. 'Aw 'ilhoghun za nohBá unli 'et huwa, Yak'uz usda-un, 'en 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","'Ink'ez khun te 'uyoonne ‘nemoodih’ nohodóni' junih. 'Aw 'ilhoghun za nohMoodihti hoonli 'et huwa, 'en Christ 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mbene la nohtoh unchane, 'enne nohba ne'út'enne oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","'Ink'ez mbe la dich'oh ncha nadudil'i'-un, 'en 'udeyo tel'en-un tileh. 'Et mbe la 'udeyo 'ududildzun-un, 'en 'udedo ncha-un tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","'Et nohni Moses be 'udustl'us 'uk'ununáguzne nohni Phariseene cha, nohni duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh. Ndiz un'a nja daht'en, nts'e la lerwe yak'uz usda-un, 'et whudáti dune ch'a dána'dihtan. Nohnich'oh hoonts'i daóohya' ait'oh. 'Ink'ez mbene la whuz udulhne, 'enne cha 'aw dábohlelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Nohni Moses be 'udustl'us 'uk'ununáguzne, nohni Phariseene cha, nohni duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh! Tsandilhne buyoh bugha haoondunaht'ah. 'Et ndi tenadudli 'i be whuz un'a za 'onilha sa' cho tenadahdli. 'Et huwa 'on nus 'uwhulcho whe nohba nahutideh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Nohni Moses be 'udustl'us 'uk'ununáguzne, nohni Phariseene cha, nohni duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh! Ndi yun k'ut ndulcho whe náhdilh 'ink'ez too k'ut ndulcho whe nahke, 'ilhoghun tilah nohnich'oh nohk'un'a 'unt'oh oolhtselh. 'Et whuch'a nulhde de, 'et de ndun nat 'uwhultsi' whe nohanus kwuncho yo whuye' tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nohni hoos̱'enne lé'aht'oh, dawhultsi'-un nohts'u hóolts'ulh. Lhe'aht'oh whuzih'en 'et hoonts'i dune ti whubuntilhtun hukwa' aht'en. 'Et ndiz un'a dune whubodulh'eh, njan lugliz whucho hoozi' be dune nahuhizya de, 'et 'ants'i 'uhoont'oh. 'Et hoonts'i lugliz whucho 'et gold 'ink'ez silver bulh 'uhoolya, 'et 'i be whuz un'a nahuhizya de, 'et whuz un'a 'uhuhooleh huba' hoont'oh, dahni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nohni whusnine 'ink'ez hoos̱'enne ahli! K'us ndet 'uk'enus whudizti'? Lugliz whucho k'us gold bulh 'úhoolya-i, 'et tilah? 'Et lugliz whucho 'et 'uk'enus whudizti'. 'Et gold bulh 'uhoolya-i, 'i 'ants'i Yak'usda ba 'udun nenínkat-i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ndi 'i cha dune whubodulh'eh, mbe la loodel 'i be hoonliyaz whe yuts'u nahizya, 'et 'ants'i 'uhoont'oh. 'Et hoonts'i ndai la 'ants'i huwa t'aih-i, 'i loodel k'eyin'ai, 'et 'i be dune yuts'u nahizya de, 'et nduyóoleh huba' hoont'oh. 'Et whuz un'a dune whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Nohni whusnine 'ink'ez hoos̱'enne ahli. K'us ndet 'uk'enus whudizti'? 'Ants'i huwa t'aih-i tilah k'us loodel tilah? Ndi loodel 'i 'uk'enus dizti'! Ndi 'ants'et huwa t'aih-i, 'i loodel 'i gha Yak'usda ooch'e' suli' 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'Et huwa mbe la loodel 'i be hoonliyaz whe yuts'u nahizya, ndi loodel 'ink'ez ook'uyuzdla-i, 'i ts'iyawh 'i be yuts'u nahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","'Ink'ez mbe la lugliz whucho 'et whe yuts'u nahizya-un, lugliz whucho 'ink'ez Yak'usda 'et usda-un, 'et ts'iyawh whe yuts'u nahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","'Ink'ez mbe la yak'uz whe yuts'u nahizya, Yak'usda yukw'uts'uzda cho dizti'-i, 'ink'ez mbe la yuk'usda-un, 'en be yuts'u nahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Nohni Moses be 'udustl'us 'uk'ununáguzne, nohni Phariseene cha, nohni duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh! Ndiz un'a nja daht'en, ndai la haníyeh-i, 'ut'an sooltsun-i cha, anise huyulhni, 'i cha, 'ink'ez cummin huyulhni, 'i cha, 'i ooloh za, 10%, 'i Yak'usda ghah'aih. 'Et hoonts'i Moses be 'udustl'us k'ut 'uk'enus whudízti'-un, 'et ts'iyawh whuladihtnih. Ndiz un'a ts'ih'un 'uhoont'oh. Njan ndet la ts'ih'un un'a neáht'en-un, ye negha te'untazeh-i cha, 'ink'ez be néba 'alha' hoont'oh-i, 'i cha, njan 'et ts'iyawh whuladihtnih, 'et hoonts'i whuz un'a ndóht'en huba' hoont'oh, 'ink'ez 'onghun-i cha 'aw lhálhduzahle whe oola doohtnih junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Lhe'aht'oh whuzih'en 'et hoonts'i dune, ti whúbuntilhtun hukwa' aht'en. Lhe'aht'en, ndai ahnai-i nizghes yé tat'o de, 'i 'ukutilhsus, 'et hoonts'i nohni ndi khuna-i cho, camel huyulhni, 'ants'i le'hoont'oh tilhnoh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Nohni Moses be 'udustl'us 'uk'ununáguzne, nohni Phariseene cha, nohni duba na'udzoo'ne aht'oh. Dawhultsi'-un 'et nohts'u hóolts'ulh! Lusyet 'ink'ez lubot cha yoo'az ts'e tunáhgus. 'Et hoonts'i bez ts'e 'et whe ndai la 'uyoonne be bé' whulhts'it-i, 'ink'ez nts'en'a la hukwa' nahzun tune' aht'en 'et whe 'i be nohlusyet 'ink'ez nohlubot te dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Nohni Phariseene hoos̱'enne ahli! Ndi lusyet 'ink'ez lubot bulh 'udechoo bez ts'e tunáwhahgus 'et de la yoo'az cha 'aw lhditsun oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Nohni Moses be 'udustl'us 'uk'ununáguzne, Phariseene nohni cha, duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh! 'Ants'i ts'un k'ut whuduchun 'udustl'us-i lé'aht'oh. Yoo'az ts'e tube soo ot'en, 'ink'ez bez ts'e whudutsun 'ink'ez dune ts'un be whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","'Et whuz un'a za dune nalh nohyust'e yoo'az ts'e ts'ih'un dune unline dóht'en. 'Et hoonts'i nohyo ts'e ts'ih'un lhe'aht'oh. Ndai la duba na'udzoo' 'ink'ez 'uk'únulhe'ust'en-i cha, 'i be whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Nohni Moses be 'udustl'us 'uk'ununáguzne, Phariseene nohni cha, duba na'udzoo'ne aht'oh! Dawhultsi'-un 'et nohts'u hóolts'ulh! Nohni nus hoo'enne, 'enne buba tse bet 'ahudutilhtelh-un 'uwhulh'en. 'Ink'ez ts'ih'un 'unt'ohne, 'enne buts'un k'ut hoonzoo whulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'Ink'ez ndiz un'a nja dudáhni, ‘'Uwhe 'oh da' netsoda'ne bubúlh ts'ukhuna inle' ndúcha. 'Oh da' ts'ukhuna de, 'et nus hoo'enne buhughan da', 'aw bula' ts'oot'en ait'oh inle'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","'Et ndi nja dudáhni, 'i be nohnich'oh ch'az dahtni. Ts'iyanne whubunulhtun 'aw 'uyoonne mbene la nus hoo'enne bubanghanne, nohni 'enne buts'u haíndene ahli! ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'Et 'awet ndai la 'ut'en untsi'-i nohbáke whe'hidilh'en-un, 'et ts'iyawh lhaóodahla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tl'ughus lubezo buzkehke lé'aht'oh! Njan kwuncho yo wheni nohba nahutideh-un, nts'en'a 'utihnelh whenghoo táhdulh? Soo gak! ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Et hukwa soo cho soo zulhts'ai, 'et nus hoo'enne cha, 'ink'ez dune whunihne cha, 'ink'ez Yak'usda ooghuni hodulh'ehne cha, 'enne ts'iyawh nohts'ú butis'alh. 'Enne whulohne butihghan. 'Et whuz un'a tulalhgus ubunduntálht'oh. Whulohne nohlugliz bez ts'e 'et ubootalhtsus. 'Et whuz un'a lhendun keyoh whut'enne nubuntihyulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","'Ink'ez 'et huwa 'et ndiz un'a nohk'ehootalts'ulh. Mbene la ts'ih'un 'unt'oh buzkai' yun k'ut nájul, 'enne bughá 'utihnelh nohk'ehootalts'ulh. 'Oh da' Abel 'en 'uja buzkai' yun k'ut nájul. 'Et njan Zechariah buzkai' yun k'ut nájul 'et whuts'un. 'En 'unt'oh Berechiah ooye'. Ndun 'en njan lugliz whucho 'et loodel eguz 'et nohtsoda'ne, 'enne hizilhghi inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ts'ih'un un'a be nohdusni 'andit whudilhdzulhne, 'et nohni hukw'elha whutilhtselh whe' aht'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Nohni Jerusalem whut'enne, dáwhultsi'-un nohts'u hóolts'ulh! Nohni aht'en nus hoo'enne ahghan. 'Ink'ez mbene la nohts'u tílh'a'ne, 'enne cha tse be bubahghan. Dant'oh la lugok duduzkeh dudints'un be buboontun, whuz un'a nohni cha lhat-un whe 'ilhunanohootásdlelh hukwa' nuszun, 'et hoonts'i 'aw hukwa lhe'nahzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Soo cho whunulh'en, 'awet nohni Jerusalem whut'enne nohkeyoh 'aw hoonli hooloh suli' whe nohba 'et nenáwhults'ut, 'et whuz un'a Yak'usda nohladutitnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'Inka 'aw 'on 'un sulhtuzih'el. 'Et ndet la whusaootilts'ulh, 'et whusahóolts'ut de, 'et ndudútihnelh, ‘Mbe la Yak'usda boozi' be whusatíyalh-un, 'en 'uk'enus hoonzoo-un oots'ó tilts'ulh,’ 'et de sutih'elh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","'Et 'awet njan lugliz whucho Sizi 'az whenaja whe yugha hodul'ehne highu nindil. Njan lugliz whucho nts'en'a 'uhóolya 'et whuhínulhtun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","'Et Sizi ndúbulhni, “Njan ts'iyawh 'áw lhonúlh'en? Ts'ih'un un'a nohdusni, 'aw 'ilho tse lhk'ulhdutásdlal, ts'iyawh nadúntijulh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","'Et 'awet haoodit'ai-unyaz dzulh Olive huyulhni, 'et usda. 'Et mbene la yugha hodul'ehne ts'iyawh highu nindil, 'ink'ez whu'izyaz huyoodulhkut, “Njan nkede 'uwhutánelh? Nts'owhuya hoozulh whe whusanátandalh, 'ink'ez nts'owhuya whudizulh whe whulatoh whutaleh? Ndet whe hóodutaltsilh-un, 'et huwa la t'ets'onoozeh? 'Et nedíni!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","'Et 'awet Sizi ndúbulhni, “Soo cho howahli. Khun te dune nanohnoo'ah junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","'Alha lhane soozi' gha whusahutidulh 'ink'ez 'uhudutinelh, mbe la Christ unli-un, si 'ust'oh, duhutni whe lhane nahunti'ah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dune lhugan-un whulh 'údutahts'o. 'Ink'ez dune lhutigan-un cha howu yahutilhduk. 'Et cha whudutáhts'o. Khun te whénoolhjut junih. Njan dawhutanelh la 'et ts'iyawh nduwhutanelh, 'et hoonts'i 'awhuz whulatoh iloh 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Et huwa lhelhdowh didowhne lhch'az nehúdutadulh. 'Ink'ez yinka ndulcho lerwe be 'ustlene, 'enne cha lhehútidulh. 'Et dai whútaleh, 'ink'ez dada cha whutáleh. 'Et lhelhdun yun nukhutitnah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Njan dzoh nuts'udeh-un 'andit ts'iya whe'whudit'en whe'whutat'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","'Oh de 'et neooninzut de, 'et dzoh nunohotilhdeh ha whutl'anohotilelh. Whulohne nohotighan. 'Ink'ez si soozi' gha 'udun yun k'ut whut'enne nohts'o dutitni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","'Et hukw'elh'az 'et lhane la buba dzoh tileh, 'ink'ez nohnich'oh nohtoh lhgha hawhútilhyeh 'ink'ez lhts'udutihtni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Lhane whuts'it be nus hoo'en unline, 'enne lhane dune nahunti'ah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Ink'ez mbene la 'uk'unulhe'ust'enne, 'enne 'on nus 'uhultsi' tileh. Dune ye lhk'etsi'-i, 'i cha k'oh 'utinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","'Et hoonts'i mbene la soo whulatoh whuts'un whulh úsyinne, 'aw 'enne za hudutijih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","'Et yak'uz k'une' whul'en-un, 'en ghun khuni unzoo-i yun k'ut ndulcho whe be yatiduk. 'I be 'udun yun k'ut whut'enne, 'enne buba whubuntilhtun tileh. 'Et de 'awet whulatoh whusaóotilts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“'Et huwa ndi 'uk'enus be whunujut-un, 'en musai yutilhtselh-un, 'en 'uk'enus whudizti' ts'e usyin whe nulh'en de, ndun Daniel nus hoo'en-un 'oh da' howu yalhduk inle'. (Hadi' ndi mbe la yuk'uyalhdukne, 'enne soo cho bubeni taóodolts'it). 'Et nkede la nulh'en de, ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","'et mbe la Judea yun k'ut dilhts'ine, shus k'uz tsehutoolhdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mbe la duyoh hukw'usda-un khun te nanaóoja' 'ink'ez duyoh ts'e na'ólhchoot junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mbe la haníyeh k'et 'ut'en-un, 'en khun duyoh ts'e dunaih kunaóoda' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","'Et 'oh de de, mbe la ts'ekoo buzkeh whutalehne, 'ink'ez duzkeh e'úlht'ukwne, 'enne buba tube 'on nus hootátsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nkede whuch'a tsétilhdulh-un, khit k'us nats'ulyis dzin, 'et te 'uhoneh junih, 'et huba tenadahdli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","'Et 'alha 'oh de whusahoolts'ut de, hooncha whe dune dzoh nuhutide. 'Et ndi yun k'ut whe'whudit'en da', 'ink'ez 'andit dzin whuts'un, 'aw whuz un'a doo cha za ndó honeh ait'oh, 'ilhoh za' whutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","'Oh de hoondukw nalhuhóodlel de, 'aw dune doojihne hooloh. 'Et hoonts'i 'utahályane, 'enne bugha hoondukw whutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","'Et 'oh de de, ndun Christ nja usda k'us nguz usda, 'et nohoútni de, khun nohba 'alha' hudooni' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","'Alha whuts'it be Christne 'ink'ez whuts'it be nus hoo'enne, 'enne lhane nohtoh whutaleh. 'Ink'ez nohtoh tube hooncha te ne'hutit'en. 'Ink'ez huwa 'it'en-un cha nohtoh ne'hutit'en. 'Et ndi nja dótit'elh-un, khun tilah 'utahályane nabonoo'ah huninzun, 'et hukwa' hutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'Et soo zulhts'ai, whutsoda' 'uda' nohdásni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Et huwa dune nohúlhni de, ‘Nulh'en nda 'at dune lhuhoot'ih-un 'et usda!’ hutni de, khun whuz toohdilh junih. K'us, ‘'Et yoh bez ts'e usda,’ hutni de, khun nohba 'alha' hudooni' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndiz un'a nja duwhútanelh, 'et ditni kwun ndaz de hadánat 'ink'ez noo' whe dánat. 'Et ts'iyanne dune yunoolh'en ha, 'et whuz un'a yinka dune ye' whusatiyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","'Et huwa nts'e la nezi súlht'i-un, 'et la tsibalyan huwe' 'ulhozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“'Et 'oh de de dune dzoh nuhutideh-un, 'et 'oh de ndúhooja de, hukw'elh'az 'aho sa dulhgus tileh. 'Ulhdzis ooza' cha 'aw be lhóohoost'en tileh. Sum cha ts'iyawh ndus de hatíkulh. 'Ink'ez ndai la yak'uz whelhtus-un dulcho whe nuhótitnah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","'Et 'awet ts'iyanne dune yunoolh'en ha yinka dune ye' yak'uz ts'e be hóodutaltsilh. 'Et 'oh whuya hoozulh de, 'et dune ndi yun k'ut ndulcho whe tso yahutilhduk. 'Et yinka dune ye' whuz de yalh whe huyuntilh'elh. Kw'us k'ut yak'uz ts'e hatíyalh. Ye dizti'-i 'ink'ez ye ulhtus-i, 'i be tinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Be ts'ujih-i tube cho be' duts'o whe oolizas whuz ubutilh'alh. 'Utahályanne, 'enne ts'iyawh 'ilhunaboohootálelh. Diwh hukw'un'a hutidulh 'ink'ez yat dulcho nótidulh. 'Et ndulcho whe 'ilhunaboohootálelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ndi mai, fig huyulhni, ooduchun, 'i be nawhutnuk be whuts'odul'eh-i, soo ts'ih'un un'a cho bodulh'eh. Ndi 'i 'unt'oh, oozischum ulughih te, 'et 'awet oot'an whulih, 'i gha t'ewhunáhzun 'awet shin nilhdukw suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nohni cha whuz un'a za ndi ts'iyawh nohdasni'. 'Et whe nkede la nulh'en 'et 'awet t'ewhunóhzin, 'en nohenghoh. 'Ants'i dati usyin le'hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Alha ts'ih'un un'a nohdusni, 'andit whudizulhne 'aw yalhihitásdla, 'et ndi dótanelh-un ts'iyawh 'et lhawhúdutanelh, 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yat 'ink'ez ndi yun k'ut cha gak whutaleh. 'Et hoonts'i ndi sghuni 'aw gak lhtisdleh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ndet dzin 'ink'ez nts'oya hoozulh whe whutanelh, 'aw t'eoonínzunne hooloh. Lizas yak'uz dilhts'ine, 'enne hoonts'i 'aw t'ehonúszun. 'UBá yak'uz usda-un, 'aw 'en za t'eooninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","'Et 'oh da' Noah khuna da', dune dahínt'oh la, 'et whuz un'a za 'uwhutát'elh whe yinka dune ye' whusanátidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Soo cho whunulh'en, yunka too be' whutanelh da', whutso da', ts'iyanne 'a'alh 'ink'ez 'uhutnai. Dune 'ink'ez ts'ekoo bulh lhgho dilhts'i, Noah ts'i cho be tiyalh 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dunene 'aw t'ehonuszun nkede too dudutált'o. 'Et 'awet dutadilt'o whe ts'iyawh too ubanghan. 'Et whuz un'a za yinka dune ye' whusainya de, 'et ndó tanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","'Et dzin nane, 'enne haniyeh k'et 'uhut'en. Lizasne, 'enne 'ilhoghun hitalhchulh 'ink'ez 'ilhoghun 'awet tidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nane hiti'ulh-i hundunulhdus. 'Ilhoghun hitalhchulh 'ink'ez 'ilhoghun 'awet tidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'Et huwa soo cho huwahli! Nts'oya hoozulh whe nohMoodihti whusatiyalh 'aw t'eoonuzahzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","'Et ndi noheni taoonahle, mbe la yoh moodih-un, nts'owhuya la whudizulh-un undunut'ih-un whusatiyalh, 'et t'ewhuninzun de, 'et soo ts'ih'un da' huwole', 'ink'ez 'aw hiyoh da'óoyis ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","'Et huwa nohni cha lhadóoht'e'. 'Alha nts'owhuya whudizulh-un, 'et ookwa tse lhúwhahlih-un, 'et yinka dune ye' 'et whusatiyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“K'us mbe 'ulhna-un, 'en ts'ih'un 'unt'oh 'ink'ez whunih-un 'unt'oh? Oomoodih dich'oh de 'ulhna-un, 'en 'onghohne de 'ulhnane duyoh humoodih yutilhtselh. 'Oh de de 'awet 'et neooninzut de, 'et 'andit za 'onghohne hiti'ulh-i bugha ita'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'Et oomoodih whusanaja de 'ink'ez de 'ulhna-un whuz un'a nduja-un 'et whunilh'en de, 'en 'uk'enus hoonzoo-un oots'u hóolts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Alha nohdusni ndai la yut'i-i, 'i cha ts'iyawh k'une' yul'en yutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","'Et hoonts'i ndun be 'ulhna-un ntsi'-un dich'oh dudzi yo whe 'et nduninzun, ‘SMoodih sa' sla whusanádaih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'Et khunsul 'onghohne dudulh 'ulhnane bube whe ninyaih, 'ink'ez tatnaine cha bula whe'nin'al 'ink'ez bula tawhénitnai'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ndet dzin ndun oomoodih whusanátidalh 'ink'ez nts'oya 'uhunit'oh-un utinelh 'aw t'ewhunúszun, 'et 'oh whuya 'uhunit'oh whe whusanátidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Et k'ube' yutálht'oh 'ink'ez ndai la oots'itikulh-i, 'i ts'iyawh ndai la duba na'udzoo'ne buts'itikulh-i, 'enne buk'un'a 'i za oots'itikulh. 'Et whuz un'a tso bulh dughoo lhidutik'us.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Yak'uz nts'e la lerwe usda-un ndi yun k'ut whusahóolts'ut de, 'et whuz un'a ndótanelh, whunizyanne t'edukoo 'enne dune t'enuszunne, ndi kwun be hoot'en-i huyilhchoot 'ink'ez mbe la dune 'at tit'elh-un 'az 'et hiba sulh'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kwulane, 'enne huwhunih 'ink'ez kwulane, 'enne huwhusni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ndunne whusnine ndi too dizk'un hut'i 'et hoonts'i ndi too dizk'un hiye náhitilhdzoh-i hiyit 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Et whunihne too dizk'un denáhitilhdzoh-i cha hutiz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","'Et 'at tit'elh-un sa' sla whusayaih. 'Et ts'iyawh nehunintsai 'ink'ez ts'iyawh bulh buk'édilts'ut, whe nahunistez. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tuzniz at'en 'ilhoghun huyih, ‘'Awet 'at tit'elh-un 'az de yalh. Dunadahdilh 'ink'ez oodudíhdilh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","'Et ndunne t'edukoo ts'iyawh dodindil 'ink'ez too dizk'un-i ts'iyawh nahidulhk'an. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Whusnine, 'enne ndunne whunihne hubuhutni, ‘Too dizk'un negha núlhdzeh, netoo dizk'un 'awet bé ha' duk'aih!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","'Et whunihne, ‘'Awúndooh!’ hutni ‘Nohgha uznilhdzo de, nohni cha 'ink'ez wheni cha 'aw neba soo lhé'iltsuk.’ 'Et ubuhutni, ‘'E'óoket ts'e whuz ahdulh, 'ink'ez nohnich'oh 'oohket.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","'Et whuz whehandil whe 'at tit'elh-un buk'elh'o whusaínya. 'Ink'ez ndune yuba lhadint'ohne, 'enne na'hutit'ulh ts'e huyúlh danindil, 'ink'ez dati dánahidintan, 'ink'ez dánahidin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","'Et hukw'elh'az ndunne t'edukoo whusnine sanáhidil whe, ‘NeMoodih, nemoodih, neba dáhana'dintih!’ huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","'Et ndúbulhni, ‘'Alha 'aw t'enohnuzúszun!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","'Et whuz un'a nohni cha soo cho huwahli! 'Alha ndet dzin 'ink'ez nts'oya hoozulh whe yinka dune ye' whusanatidalh, 'aw dune t'eoonúszunne hooloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Yak'uz ndet la lerwe usda-un, ndi yun k'ut whusahóolts'ut de, 'et whuz un'a ndótanelh, ndun dune dukeyoh huwu tiyalh. 'Et tiyalh whutso dude 'ulhnane 'anih ubudani'. Ndai la yut'i-i, 'i butl'ayánla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'Ilhoghun kwulai' sooneya dizti'-i yutl'ainla. 'Et 'ilhoghun cha nanki sooneya dizti'-i yutl'ainla. 'Et doo cha 'ilhoghun 'en 'ilho za yutl'ain'ai. 'Ilhone hinli whe nts'en'a la soo hoonzoo hukw'un'a hiye' whutilelh, 'et wheni butl'ayánla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","'Et hukw'elh'az 'awet whinya. 'Et 'ilhoghun kwulai' yutl'ainla-un, 'en 'on 'un kwulai' uniltsuk-i ye' 'ínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","'Et whuz un'a za 'ilhoghun 'en nanki yutl'ainla whe nanki ye yúba na'yinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","'Et hoonts'i 'ilhoghun 'ilho za yutl'ain'ai-un, 'en yun hahónkai 'ink'ez whuz dumoodih oozooneya yuntilh'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","'Et hukw'elh'az sa' inle' whe ndunne 'ulhnane bumoodih whusanaja. 'Et nahootá'alh hukwa' ninzun nts'en'a la dahúyinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","'Et ndun kwulai' yutl'ainla-un, 'en kwulai' be 'on 'un 'uniltsuk-i, 'i yuba whusanáyanla. 'Et ndúyulhni, ‘Smoodih kwulai' sooneya dizti'-i stl'ainla. Nah! Nilh'en kwulai' be 'on nus mba na'usdla.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","'Et oomoodih ndúyulhni, ‘Tube soo 'inja! Nyun tube inzoo. Whunilhchoh whe k'une' nyutis'en. Nyun tube 'ulhna-un unzoo-un inli. 'Et hoontsool-unyaz whe k'une' nyutis'en inle'. 'Et 'andit n'un whe lhai ghu tanleh. 'Anih, ndai la nyumoodih ye hoont'i'-i, nyun cha be hóotant'e'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","'Et 'ilhoghun nanki sooneya dizti'-i yutl'ainla-un, 'en cha whusainya. 'Et ndúyulhni, ‘Smoodih nanki sooneya dizti'-i stl'ainla. Nah! Nilh'en nanki be 'on nus mba na'usdla.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","'Et oomoodih ndúyulhni, ‘Tube soo 'inja! Nyun cha tube inzoo. Whunilhchoh whe k'une' nyutis'en. Nyun cha tube 'ulhna unzoo-un inli. 'Et nyun cha hoontsool-unyaz whe k'une' nyutis'en inle'. 'Et 'andit nyun cha n'un whe lhai ghu tanleh. 'Et nyun cha 'anih, ndi ndai la nyumoodih ye hoont'i'-i, nyun cha be hootant'e'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","'Et doo cha 'ilhoghun 'ilho sooneya dizti' yutl'ain'ai-un, 'en cha whusainya 'ink'ez yúlhni, ‘Smoodih t'eoonuszun nyun 'aw t'elhe'nínzun-un 'int'oh. Nts'e la alhe'nuzinloh-un 'et hoonts'i 'et na'ilhdzooh. Nts'e la haníyeh 'ulhe'nínlel-un 'et hoonts'i 'et cha ha' ninlih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tube whenuzjut 'et huwa ndi sooneya dizti' yun yo ts'e ntís'i'. Nah! Nilh'en ndi stl'ain'ai-i ntl'anás'aih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","'Et oomoodih yulhni, ‘Nyun untsi'-un 'ink'ez tsedutni-un 'ulhna 'int'oh. 'Alha t'eooninzun nts'e la alhe'nuzusdloh-un, 'et hoonts'i 'et cha na'usdzooh. 'Ink'ez nts'e la haníyeh 'ulhnúsdlel-un, 'et hoonts'i 'et cha ha' nusdle. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'Et huwa 'oh da' ndiz un'a nja dónleh huba' hoont'oh. Ndi uszooneya ntl'as'ai-i, sooneya lhk'enada'aihne, 'enne butl'alhizin'ai. 'Et de da' szooneya 'on nus 'uniltsuk-i be ná'oozneh oole' da'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","'Et huwa ubulhni, ‘Ndun ndi uszooneya dizti'-i, ooghu nayulhchoot. Mbe la whunizyai sooneya dizti'-i yut'i-un, 'en oogha ínah'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Et mbe la yuloh za 'ut'i-un, 'en 'on nus lhai oogha tílts'ulh. 'Et whuz un'a lhai tit'elh. 'Et hoonts'i mbe la ntsool-iyaz ut'i-un, 'i hoonts'i ooghu nayitálchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","'Et 'awet ndun 'ulhna-un ntsi'-un, ulhchoot 'ink'ez 'az tsaholhgus yo ts'e táhneh.’ 'Et whuz la tso bulh la dughoo lhudook'us si.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“'Et 'awet yinka dune ye' nkede oots'u ha' 'ánduz whe whusanátidalh, 'et nyoonne lizas lubeshi ooghu hoolohne, 'enne huyulh whusanátidulh. 'Et 'ink'ez 'oh de de, yukw'uts'uzda cho dizti'-i, 'i k'ut nanátl'adutidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","'Et 'ink'ez yinka dune'ne, 'enne ts'iyawh hibut 'ilhunabuhootálelh. 'Et 'usbai ghunli-un k'un'a 'usbai, 'i dube tahanaítilelh, 'et whuz un'a ndótanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","'Usbaiyaz 'enne nailhni ts'unk'us nebutalelh. 'Et dube 'enne 'intl'us ts'unk'us nebutalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Et lerwe 'et ndunne nailhni ts'unk'us 'unt'ohne 'et whuz un'a ndubudutanelh, ‘Nohni 'uBá 'uk'enus hoonzoo-un la nohghá whults'utne ahli. 'Et huwa 'anih! Ndi yun 'utilnelh whutso, ndet la lerwe yak'uz úsda-un, 'et ndet nohba lhaoodinla, 'et 'andit za nohtl'aootilts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Soo cho whunulh'en, sye'ílts'ul whe tis'ulh-i sgha náh'ai. Ta'oosda whe ndai la tisnelh-i sgha náhkai. 'Uts'un whút'en-un usdli 'et hoonts'i nohyoh ts'e dásunulhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","'Aw naih lhúst'i whe 'enásalhti. Ndusda whe sts'un nusahdil. 'Adus'ai whe sts'un nusahdil.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","'Ink'ez ndunne ts'ih'un 'unt'ohne huyoodutalhkut, ‘NeMoodihti nkeda' nye'ílts'ul whe nts'uyan'en 'ink'ez tan'ulh-i ngháznin'aih? 'Ink'ez ta'óonda whe tantnelh-i nghá uzninkai? ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","'Et nkeda' 'uts'un whút'en-un inli whe dánts'inilhti inle'? K'us naih lhint'i' whe naih ngházninla inle'? ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Nkeda' ndinda whe nts'inálh'en k'us 'adin'ai whe nts'un nuts'uzdil inle'?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","'Et lerwe nja dúbudutanelh, ‘'Alha-i be nohdusni, ndunne sulhutsinke, mbene la 'aw nchane lhiloh, 'enne 'ilhoghun hoonts'i whuz un'a 'et dúbahla de, 'et si 'usáhla whe' hoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Et 'awet ndunne 'intl'us ts'ungus 'unt'ohne diz un'a ubudutánelh, ‘Ndai la Yak'usda ye hunilch'e-i nohbulh 'unt'ohne sahli'! Sch'a nasahdilh! 'Et 'awet ndi kwun 'aw nalhnusne-i netsudule dulizasne te buba' hóolya-un, 'et nohni cha whuz tihdulh! ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sye'ílts'ul inle' 'et hoonts'i 'aw tis'ulh-i sgha lhah'al. Ta'óosda 'et hoonts'i 'aw tisnelh-i sgha lhahkal. ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","'Uts'un whut'en-un usdli, 'aw 'et dasúlhulhtel. 'Oh da' 'aw naih lhust'i' 'et hoonts'i 'aw be oosda'-i hooloh naih sgha lhahlel. 'Oh da' ndusda whe 'ink'ez adus'ai-i whe 'aw sts'un nulhahdulh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","'Et diz un'a 'uhidutanelh, ‘NeMoodihti nkeda da' nts'uyan'en whe dini? Nkeda' nye'ilts'ul 'ink'ez ta'oonda? K'us 'uts'un whut'en-un inle', k'us be dune onle'-i lhínt'i'? K'us ndinda 'ink'ez 'adan'a'? 'Et whuz un'a nts'uyan'en 'et hoonts'i 'aw hoonliyaz whe nlalhe'ts'ínel dini?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","'Et la budutanelh, ‘'Alha-i be 'unohdusni, ndunne mbene la sulhutsinke 'aw ncha lhilohne, 'et 'aw 'ilhoghun hoonts'i whuz un'a lhebáhlel. 'Et huwa si cha 'aw ndusúlhahlel le'hoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","'Et ndunt'ohne, 'enne 'ilhiz wheni dzoh notideh ts'o tidulh. 'Et hoonts'i ndunne ts'ih'un 'unt'ohne, 'enne 'ilhiz whe ts'ukhuna-un bugha óotakulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","'Et 'awet Sizi ts'iyantsuk whe lhadúja whe yugha hodul'ehne 'et ndúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“'Et t'eoonahzun 'awet nat dzin whuz'ai whe butus lhuseya-un 'et whunahutilnih. 'Et 'oh de de yinka dune ye' 'awet butl'ahitilhtelh 'ink'ez tulalhgus k'ehúyitalhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","'Et soo 'oh whuya hoozulh whe za, 'et lubret 'udedone, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'ink'ez dune 'utso whudilhdzulhne cha, 'enne ts'iyawh lubret 'uk'enus dízt'i'-un, 'en Caiaphas huyulhni, ooyoh soo' whulcho 'inka 'et 'ilhunahootádulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","'Et 'alhgoh yahalhduk 'ink'ez howhuts'it whe hoonli hiba' hoonla whe Sizi huyitálhchulh 'ink'ez hituzilhghelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","“'Et hoonts'i njan butus lhuseya-un 'et whutoh 'uts'inla de kwa la dunene lhtahahót'alh.” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","'Et 'awet keyoh whuyaz Bethany huwhútni-un, 'et Simon ooka whulhjut ínle'-un, leprosy huyúlhni, ooyoh 'en Sizi yuzih usda. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","'Et 'ilhoghun ts'eke bughu daninya whe 'en ndi tse dízti'-i, Alabaster huyúlhni, 'i be ndi luboodai 'ulya, 'i yi'alh. Ndi yoo sooltsun-i, 'i tube dizti' whe 'unt'oh. 'Et lutab k'ut na'ut'alh whe yutsi k'eyilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","'Et ndunne yugha hodul'ehne hinilh'en whe hukwa lhe'hunizun. 'Ink'ez 'enne ndúlhodutni, “'Et di ha ndi 'ants'i ninta' yulh'ih? ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ndi yoo dizti'-i bé' ts'onket de, 'i ts'iyawh tel'enne gha ts'oodzaih oole' da'!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","'Et Sizi t'eoonanzin whe 'et ndúbulhni, “Ndun ts'eke oots'áhalhozah'ai. 'Ut'en unzoo-i sba inla whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","'Ahoolhyiz tel'enne bubulh áht'oh, 'et hoonts'i si 'ahoolhyiz 'aw nohbulh lhe'tuzist'el. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","'Alha ndi yoo sooltsun-i 'adutistelh huba syust'e yuk'éyilhdzo whe 'ut'en. 'Et whuz un'a lhasúdinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Alha nohdusni ndi yun k'ut ndulcho whe ndi khuni unzoo-i nudútikat, ndun ts'eke ndet 'uhoonla-un, 'et hukw'u naootitnuk 'et whe dune yunatilnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","'Et 'awet ndunne whunizyanne 'on 'at nane, 'enne butoh 'ilhoghun Judas Iscariot huyulhni, 'en lubret bumoodihne buts'u whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","'Et ndúbulhni, “Daltsuk sgha tíh'alh ndun dune nohtl'ásti de?” “'Et tat whunizyai sooneya, silver,” huyulhni, 'et 'ultsuk hiba huyolhto. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","'Et whuts'un nts'en'a butl'aitilhtelh-un 'et hukwunúta. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","'Et 'andit 'awet ndi lhes lhuntildoh-un dzin whusahóolts'ut whe mbene Sizi yugha hodul'ehne, 'enne highu nindil 'ink'ez huyoodulhdut, “Njan butus lhuseya-un 'uta'úlh-un, nts'e mba lhats'odutileh hukwa ninzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","'Et ubúlhni, “Nghuz keyoh whuti whuz ahdulh. 'Ilhoghun dune sba dáhni, ‘Nehodulh'eh-un nja dutni, 'awet sba nilhdukw hoozulh. Nyoh ts'e ndunne sgha hodul'ehne nja butus lhuseya-un, 'et 'alhgoh bubulh whunatiznih.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'Ink'ez yugha hodul'ehne Sizi daja ubudani', 'et whuz un'a nduhuja. 'Ink'ez njan butus lhuseya-un 'et wheni lhaháduja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","'Et 'awet hulhgha whusahonzut whe whunizyanne 'on 'at nane yugha hodul'ehne, 'enne bubulh natl'adida' bula natit'ulh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","'Et 'uha'alh whutoh 'et ndúbulhni, “'Alha nohdusni njan nohtoh 'ilhoghun whutl'asutilhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","'Et ts'iyawh ni huzdli', 'ink'ez 'ilhone hinli whe huyoodulhkut, “SMoodihti si tilah sudini?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","'Et ndúbulhni, “Mbe la dules sulh tunayuz'ai-un, 'en 'utinelh whutl'asútilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Alha yinka dune ye' nts'en'a la ba 'uk'ehooguz, whuz un'a 'utinelh datitsah. 'Et dune mbe la whutl'ayálhti-un, 'en dune 'uk'enus hoontsi'-un oogha óotalts'ulh. Ndun dune 'aw lhuhóolel de, 'et de da' 'on nus ooba hózoo' oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","'Et Judas, mbe la whutl'aitilhtelh-un, 'en Sizi yoodulhkut, “Rabbi si eh sudíni?” 'Et 'uyulhni, “Nyunch'oh údini.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","'Et 'awet 'uhan'al whe Sizi lhes yilhchoot. Musi ni whe tenadidli. Lhts'e danyuz 'ink'ez yugha hodul'ehne butl'ayán'ai. 'Et ndúbulhni, “Ulhchoot 'ink'ez ah'alh. Ndi syust'e 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","'Et lubot 'i cha yilhchoot 'ink'ez musi ni whe tenadidli. 'Et ndúbulhni, “Nohni ts'iyawh 'i be ahnai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","'Et huwa ndi suzkai' 'i be 'andidi be nohts'u nahizusya, 'et huba 'ulya. Lhane ba nadútilt'ih. 'Et 'i be bulubeshi buba gak natidleh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Njan 'et nohdusni, ndi mai too' 'aw doo cha za oosnai' ait'oh. 'Et hoonts'i ndi mai too' 'andidi-i, 'i nohbulh tisnelh. Nts'e la 'uBá lerwe unli-un, 'et whuz oozahdil-un, 'et dzin nohbulh tisnelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","'Et Yak'usda ooyun be híjun 'ink'ez ndo shus k'us Olive huyulhni, whuz whehandil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","'Et 'awet Sizi ndúbulhni, “'Andit 'ulhdzis nohni ts'iyawh skayátihleh. Diz un'a 'uk'ehoogus whe ndutni, ‘'Usbai ghunli-un, tuzilghelh huba whutl'atístelh. 'Et de 'usbai ts'iyawh yahitalh'us.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","'Et dunadusja hukw'elh'az de, 'et yun k'ut Galilee ts'e nohtso tisyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","'Et Peter 'uyúlhni, “'Et ts'iyawh nyun nkayahutileh 'et hoonts'i si 'aw nkayálhtuzisdle.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","'Et Sizi nja dúyulhni, “'Alha-i be nyudusni, 'et 'andit 'ulhdzis lugok dune 'udutinelh whutso, 'et tat t'esunuzínzun dutanelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","'Et Peter 'utni, “Nyúlh datisah de, 'et hoonts'i 'aw t'enyunuzúszun doosni' ait'oh.” 'Et 'onghohne yugha hodul'ehne, 'enne cha whuz un'a za 'uhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","'Et la 'ilhoghun haniyeh k'et Gethsemane huwhútni-un ts'e whuz hoozdil whe Sizi yugha hodul'ehne ubúlhni, “Nohni njan dulhts'i. 'Et si nda 'at tenadutisdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Peter 'ink'ez Zebedee buzkeh, nane, 'enne ubilhchoot 'ink'ez dulh whebildilh. 'Et 'awet ts'odi cho ook'édilts'ut 'ink'ez oodzi tube yo 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","'Ink'ez ubulhni, “Szul tube ts'odi suli' k'et 'awet datisah le'ust'oh. Nja dúlhts'i 'ink'ez sla huwahli.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'On 'unyaz le whinya whe 'et nachániti 'ink'ez tenawhendunidli 'ink'ez nja dutni, “'UBá ndi lubot be dzoh nutiszut-i, whuz un'a 'unt'oh de, 'et whute senghólts'it. 'Et hoonts'i 'aw si hukwa' nuszun k'un'a iloh. Nyun hukwa' ninzun hukw'un'a 'et 'uhóneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","'Et nyoonne yugha hodul'ehne nahunistez whe bughu nanja. 'Et Peter ndúyulhni, “'Aw eh 'ilhoh sadzi hukw'uhunist'o whe sulh huwonle' ait'oh? ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tank'us nínt'i-un whuch'a howinli 'ink'ez tenadinli! 'Alha dune yughi whuz un'a hukwa' ninzun, 'et hoonts'i ooyust'e tetsun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","'Et doo cha za whulh nat bugho whenaja tenadutidli ha. 'Et nja dutni, “'UBá ndi lubot 'aw sghu naóolhchoot ait'oh, 'i ts'iyawh usnai' 'et de za. 'Et whuz un'a za hukwa' ninzun de, 'et ndó honeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","'Et doo cha za nahuniztez whe bughu nanja. Bulh buba yilhtus k'et 'aw hitó'en ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","'Et 'awet bugho whenaja 'ink'ez whulh tat-i khuni 'i be za tenadidli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","'Et 'awet yugha hodul'ehne bughu nanja 'ink'ez 'ubulhni, “'Awhuz nalhyis 'ink'ez sahtez whé eh aht'oh? Soo zulhts'ai 'awet sba whusahóolts'ut. Yinka dune ye' ndunne mbene la lubeshi 'ulh'enne, 'enne butl'ahítilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Soo 'ah dunadahdilh! 'Awet uztoodilh sih! Whunulh'en mbe la whutl'asútilhtelh-un, 'awet senghoh uyalh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","'Awhuz yalhduk whe 'et khunsul Judas, 'en whusainya whe 'en ndunne whunizyanne 'on 'at nane whel'a'ne, 'enne ndun 'ilhoghun 'unt'oh. 'En bulh lhane dune yulh whusaindil. Whulohne saluzti nuhúle, 'ink'ez whulohne tut'oh nódule. Lubret bumoodihne 'ink'ez dune 'utso whudilhdzulhne, 'enne whusahábahalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","'Et 'awet mbe la Sizi whutl'aitilhtelh-un, 'en 'ilhunaoosdilne ubulhni, “Mbe la nadists'ooz-un, 'en 'udúsni. 'En 'aho ólhchoot!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","'Et 'aho 'en Sizi yughu ninya whe “Hadih Rabbi,” yulhni 'ink'ez naidits'ooz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","'Et Sizi ndutni, “Syadan di ha whusainya?” 'Et 'awet whusahandil Sizi 'aho huyilhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","'Et khunsul 'ilhoghun Sizi yulh 'unt'oh-un ndi saluzti hayálhtsus 'ink'ez lubret 'uk'enus dizti'-un be 'ulhna-un, 'en yudzo yuts'a ha bé' yalht'o. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","'Et Sizi ndúyulhni, “Nyoo saluzti t'unádint'aih! 'Alha mbene la 'et dut'enne, 'enne 'et hukw'e dahutitsah. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","'Et si hukwa' nuszun de, 'uBá ooduskut de 'ink'ez 'andit 'aho 70,000ne lizas 'on 'un 'ultsukne, 'enne da' sts'o tl'aboolelh oole' da' sla hutinelh ha. 'Et 'aw t'eoonuzínzun whe 'int'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","'Et za ndust'en de, nts'en'a Yak'usda ooghuni lhadútineh? Nts'en'a la sts'un dawhut'ih-un, 'et whuz un'a 'uhóneh huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","'Et 'awet 'oh whuya 'uhunit'oh whe Sizi 'ilhunaoosdilne ndúbulhni, “'Et di ha saluzti cha 'ink'ez tut'oh cha nuhle 'ink'ez 'undunust'ih hukw'un'a skatíhdil? Dzin totsuk lugliz whucho 'et nohtoh susda 'ink'ez whunohodus'eh. 'Et hoonts'i 'aw sulhúlhchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","'Et huwa, nus hoo'enne bube' 'udustl'us ook'ehooguz-un, 'et ts'iyawh lhawhúdutanelh.” 'Et 'awet higha hodul'ehne, 'enne highu whetsélhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Et 'awet mbene la Sizi yilhchootne, 'enne lubret 'uk'enus dizti'-un, Caiaphas huyulhni, ghu hinílhti. Moses be 'udustl'us 'uk'ununáguzne, 'ink'ez dune tso whudilhdzulhne cha, whuz 'ilhunahosdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","'Et Peter 'on niz de bubuniyalh whe lubret 'uk'enus dizti'-un ooyoh whuna'niztl'oo-un whuz bubunéninya. Whuz bughu daninya whe neilhchukne buzih natl'adida' 'ink'ez naldzilh, daootanelh whuntilh'elh 'et hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Et lubret bumoodihne, 'ink'ez 'utso whudilhdzulhne cha, 'ink'ez nahiyilhne cha, 'enne ts'iyawh hoonli-unyaz whuts'it huwun highu nahó'alh hukwa' hut'en whe hituzilhghelh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","'Et hoonts'i 'aw hiyulh náho'alh-un hooloh. Lhane dune whusahándilh 'ink'ez huwhuts'it be highu yalhduk. 'Et hoonts'i 'awhuz hoonli hiyulh nalhuwhus'ai. 'Et khunsul nane dune whuts'itne whusain'az ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","whe nduhútni, “'Et ndun dune 'utni Yak'usda oolugliz whucho hooloh whutilhtselh 'ink'ez tat dzin whutoh 'udun na'whutilelh ni,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","'Et 'awet lubret 'uk'enus dizti'-un duninya 'ink'ez Sizi yoodulhkut, “'Aw eh daja lhdutuzanel? Daja hutni-un 'et huwun daja ninzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","'Et Sizi 'aw t'edusnih. 'Et lubret 'uk'enus dizti'-un, 'en yulhni, “Mbe la Yak'usda khuna-un, 'en be nyudusni yatolhdih huba' hoont'oh. 'I be mba nahutideh. Nedini Christ Yak'usda ooYe', 'en eh 'int'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","'Et Sizi ndúyulhni, “Nyunch'oh 'et 'údini. 'Et njan huwun nohbulh yasduk, k'at le de yinka dune ye', 'en mbe la ulhtus-un, 'en nailhni ts'unk'us yughu usda, 'et whutih'elh. 'Ink'ez kw'us k'ut ndus de hatiyalh, 'et cha whutih'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","'Et lubret 'uk'enus dizti'-un ye usda-i dubut ka lhts'e yalhch'ul 'ink'ez 'utni, “Yak'usda ch'az ditni whe yalhduk. 'Aw 'uyoonne nedóni' hukwa lhe'uznízun. 'Andit whunulh'en Yak'usda ch'az ditni-un ts'iyawh nohni nohnalh 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Daja nahzun?” 'Et 'uhutni, “Daóotsah huba 'unt'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Hinin ts'e huyoonuzo. Huyoolhchis 'ink'ez whulohne huyoonukat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","'Et whuz un'a nduhúyulhni, “Neba nus whutan'elh. Nyun 'int'oh Christ inli de, mbe nyinla nyunízkuk?” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","'Et Peter n'az whuna'niztl'oo-un whez ts'e usda whe ts'ekeyaz yughu ninya. 'Ink'ez ndúyulhni, “Ndun Sizi Galilee whut'en-un, nyun cha bulh 'int'en inle'!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","'Et ts'iyawh bubut whuts'oodidlai whe ndutni, “Daja dini-un 'aw t'eoonuzúszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'Inka 'az tenánja. 'Uyoon ts'eke cha yunilh'en, 'ink'ez 'oh nudilhyanne, 'enne ndúbulhni, “Ndun 'en cha Sizi Nazareth whut'en-un bulh 'unt'oh inle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","'Et doo cha za Ndoghi nalh whuts'oodísdlat whe ndutni, “Ndun dune 'aw t'enuzuszun!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hukw'elh'az mbene la yuzih nudalya'ne, 'enne highu nindil whe huyúlhni, “'Alha mbene la yulh ant'e'ne, 'enne nyun cha 'ilhoghun 'int'oh. Nts'en'a la yailhduk-un, 'et huwa t'ets'unyunínzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","'Et Peter 'et ndutni, “Yak'usda sts'e'tilhtsus 'aw ts'ih'un lhe'duzusnih de, ndun dune 'udáhni-un, 'aw t'enuzuszun.” 'Et 'aho lugok dune 'udíja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","'Et Sizi daja ni la 'et Peter whunalni whe nja dutni, “'Et lugok dune 'udutinelh whutso, tat 'aw t'esunuzinzun dutanelh.” 'Et 'az whenaja 'ink'ez tube cho howintse. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","'Et 'om bun bundada 'uda' lubret bumoodihne, 'enne ts'iyawh, dune 'utso whudilhdzulhne, 'enne cha, 'enne Sizi hich'az ditni whe howu yahalhduk hituzilhghelh hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","'Et Sizi hiyulhghel 'ink'ez yun k'ut whumoodih, 'en Pontius Pilate huyulhni, hits'u hayoolhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","'Et mbe la whutl'ayálhti-un, 'en Judas huyúlhni-un, 'et 'awet Sizi datitsah huba ba nahisda whe, 'et t'eoonanzin whe tube oodzi nduda suli'. 'Et ndi tat whunizyai sooneya silver huyulhni, ndunne lubret bumoodihne 'ink'ez dune 'utso whudilhdzulhne cha, buba whusanáyandzai. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","'Et ndúbulhni, “Ndun dune ninta lhe'ust'í-un, 'en whutl'ásti-un 'et whe ninta' nust'en.” 'Et 'uhuyúlhni, “Wheni neba lhe'hóot'oh. Nyunch'oh za mba' hoont'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","'Et ndi tat whunizyai silver ts'utni-i sooneya lugliz whucho yun bubut nayántsut. 'Et 'ink'ez 'az whenaja 'ink'ez tsená'usguz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Et ndunne lubret bumoodihne ndi sooneya silver ts'utni-i, 'i huyilhchoot 'ink'ez 'uhutni, “Dune buzkai' suli'-i 'unt'oh. 'Et huwa 'aw Yak'usda ba be 'úzdla-i be náts'oodzaih ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","'Et dich'oh dutoh howu yahalhduk. 'Ink'ez mbe la lhez oosa' 'ulh'en-un, ndi sooneya 'i be 'en yun hiyónket. 'I k'ut 'uts'un whut'enne, 'enne 'uhule 'et wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","'Et huwa soo 'andit njan dzin 'et whuts'un ndi yun boozi' 'i 'uskai' yun huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Et whuz un'a 'oh da' ndun nus hoo'en-un Jeremiah daja ni la 'et whunilhchoh 'oh túne' whust'en whe lhaóoduja whe nja dutni, “Ndi sooneya silver ts'utni, 'et tat whunizyai 'et 'ultsuk uschoot. 'Et 'ultsuk whe hiyolhto 'et ndunne Israel oots'u haindene, 'enne buba k'elha huyulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'Ink'ez lhez oosa' 'ulh'en-un, 'en ooyun hiyónket. 'Et whuz un'a Moodihti sudani'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","'Et 'awet Sizi mbe la yun moodih 'en yubut usyin. 'Et yun moodih yoodulhkut, “Nyun eh 'int'oh Lizwif bulerwe inli?” 'Et Sizi 'uyulhni, “A, 'alha' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","'Ink'ez ndunne Lizwif bumoodihne 'ink'ez dune 'utso whudilhdzulhne cha, 'enne hik'eho'alh hukwa' hut'en. 'Et hoonts'i 'aw hoonliyaz lhe'dínel. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","'Et Pilate yoodulhkut, “'Aw eh lhubuduzínts'o lhe'whultsuk-un whe nch'az yáhalhduk?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","'Et 'aw 'ilho khuni be hoonts'i daja lhdinel. 'Et whe yun k'ut whumoodih tube ooba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","'Et nawhudizulh totsuk lizwif butus lhuseya 'et whunahulnih, 'et whutoh yun moodih mbe la 'adin'ai-un 'ilhoghun hika' ninzun-un, 'en ts'iyanne buts'u lanadutitnih. 'Et whuz un'a buk'oh ts'e 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","'Ilhoghun 'adin'ai-un, 'en Barabbas huyulhni, ts'iyanne t'ehinínzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","'Et ts'iyawh 'ilhunahosdil whe Pilate uboodulhkut, “Mbe nohba oolanadutisnih hukwa' nahzun, Barabbas k'us Sizi, 'en Christ huyulhni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","T'eooninzun 'oonih gha butl'ahayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","'Et Pilate dune ba nahidilh-i, kw'uts'uzda k'usda whe oo'at 'en khuni yuts'ó tl'ain'ai, 'et ndúyulhni, “Ndun dune 'en ts'ih'un 'unt'oh-un. Hoonliyaz onleh junih! 'Alha 'andit dzin 'en oogha huwu nusústi 'et whe dzoh nusúszut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","'Et ndunne lubret bumoodihne 'ink'ez 'utso whudilhdzulhne cha, 'enne 'ilhunaoodilhne ba hunint'i 'et whuz un'a 'uhóoneh ha, 'enne Pilate Barabbas yulanadootni 'ink'ez Sizi hooloh huyoolhtselh ha. Whuz un'a 'uhudooni' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","'Et 'awet yun moodih 'en uboodulhkut, “Ndunne nane, 'enne k'us mbe nohba oolanadutisnih hukwa' nahzun?” 'Ink'ez 'et 'uhuyúlhni, “Barabbas.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","'Et ndun Pilate ndúbulhni, “'Et ndun do', Sizi mbe la Christ huyúlhni-un, 'en nts'en'a cha daóosdlih ha la?” 'Et 'ilhunaoosdilne nduhúyulhni, “Tulalhgus kélhtih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","'Et yun moodih 'et ndutni, “Di ha? Ndet whe ninta' 'ant'en?” ubulhni. 'Et hoonts'i sul'ehúdilya, “Tulalhgus kélhtih!” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","'Et ndun Pilate t'ewhunínzun 'aw hoonliyaz 'uhooleh ait'oh. Ndunne 'ilhunaoosdilne 'awet lhtahotát'alh le'hoont'oh. 'Ink'ez 'ilhozdilne bubut too be lana'ilde 'ink'ez ubúlhni, “Ndun ts'ih'un dune buzkai' oot'aóosnalh hukwa lhe'núszun. Nohnich'oh za nohba 'uhoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ts'iyanne dune 'et nduhutni, “Wheni ts'iyawh neuzkeh tubulh buzkai' whutaleh-un, 'et nek'éholts'it!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","'Et 'awet Barabbas buba yulanaditni 'ink'ez Sizi huyolhtsus. 'Et hukw'elh'az butl'ayálhti tulalhgus k'ehíyolhtelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","'Et 'awet yun moodih 'en la lhuganne ubut'ine, 'enne Sizi huyilhchoot 'ink'ez duyoh ts'e whehúyalhti, 'i Praetorium huwhútni. 'Et ts'iyawh ndunne lhuganne Sizi higha óosguz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","'Et hinaih hits'u húnuhuyulhch'ul whe luglok dulk'un-i hit'uháyulhchooz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Whus cho nahinílhjaz-i, 'i hitsi nehídan'ai. 'Ink'ez tl'oghazilh nailhni ts'e hila k'ehídantan. Lerwe k'un'a yot'e' ha hitl'ahídantan. Hibut nachánuldulh cha' huyulh'en. 'Et whuz un'a highudloh. 'Ink'ez “Lizwif bulerwe sa' cho hona'!” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Highá dizoh, 'ink'ez tl'oghazilh be hitsi oonulht'a. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","'Et highudloh-un 'etsul 'uhudija whe ndi luglok highun náhuyílhchoot 'ink'ez dich'oh oonaih be náhuyalhti. 'Et 'awet tulalhgus k'ehuyítalhtelh ts'e hítilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","'Awet Sizi tehínilhti whe 'ilhoghun dune Cyrene whut'en-un 'unt'oh, 'en Simon huyulhni, 'en hidudizdil whe ndi Sizi ootulalhgus ooba idantelh huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","'Et 'awet njan Golgotha ts'uwhútni-un whuz hoozdil. 'Et ndi khuni 'utsints'un niz'ai ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'Et ts'ekoo too' dunink'oz-i 'ink'ez yoo, gall ts'utni, hitadínla. 'I yulh yootnai' hukwa' huyinla. 'Et hoonts'i yunawhúzdlih 'ink'ez 'aw yootnai' hukwa lhe'nízun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","'Et tulalhgus 'uhidunilht'o hukw'elh'az hinaih higha 'áinli. Dahuja-un 'et 'oh da' nus hoo'en-un nts'en'a 'udani', 'et ts'iyawh hukw'un'a 'uhooja. Ndiz un'a nja dudani', “Ndi snaih dich'oh lhtahuyulya. 'Ink'ez ooloh higha 'ainli cha' huyinla.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Et 'awet nátl'ahudilts'i 'ink'ez highunli. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ootsi 'an dus ts'e dzihtelyaz hodunilht'o. 'Ink'ez ndet la hik'ehoon'ai-un 'et 'uk'ehuhoonguz. 'Et ndutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nane undunut'ihne, 'enne cha hiyulh tulalhgus k'ebuhilhti. 'Ilhoghun nailhni ts'e, 'ink'ez 'ilhoghun 'intl'us ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mbene la 'oh whuya whedilhne nodunul'us 'ink'ez hich'az ditni whe yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","'Et 'uhuyúlhni, “Nyun 'int'oh lugliz whucho nanaóodutanlelh 'ink'ez tat dzin za na'whutanlelh dini! Nyunch'oh 'ududílyih! Yak'usda ooYe' inli de, ndi tulalhgus k'ut ook'ut nanaíndaih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","'Et ndunne lubret bumoodihne, 'enne cha whuz un'a za highudloh. Moses be 'udustl'us 'uk'ununáguzne, 'enne cha 'ink'ez dune 'utso whudilhdzulhne cha, ts'iyawh whuz un'a za 'uhutni whe ndiz un'a nja duhutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“'Uyoonne ulhyis 'et hoonts'i dich'oh 'aw 'ududoolyih ait'oh. Israel oots'u haindene, 'enne ba lerwe unli de, 'et de ndi tulalhgus yuk'ut nanaóoja' oole' da'. 'Et de da' neba 'alha' 'oot'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","'En Yak'usda t'anínintan. 'Et huwa Yak'usda yuka' ninzun de, 'andit 'aho da' yoolhyih. 'En 'utni si Yak'usda ooYe' 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndunne 'undunut'ihne yuzih tulalhgus k'usulhtine, 'enne cha whuz un'a za 'et duhúyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dzetniz hukw'elh'az 3:00 at'en 'ink'ez hulhgha 6:00 at'en 'et whuts'un ndi yun k'ut ndúwhulcho whe tsahólhgus suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","'Et 6:00 at'en Sizi tube cho ka' dija whe, “Eli, Eli, lama sabachthani?” Ndi khuni, “SYak'usda, SYak'usda di ha sla dantnih,” ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Whulohne dune 'et núdilhyane hidánts'o 'ink'ez 'uhutni, “'Ah! Elijah hahayih whe 'utni!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Et 'aho 'ilhoghun whusalgai, 'ink'ez duchun oola'dul'oo-i ts'ekoo too' dunink'oz-i ye tunayuzsi 'ink'ez ndo Sizi yuze yunaóonulhtsul. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","'Onghohne “K'at oots'ú ha lhozah'ai! Elijah yughu ninya 'ink'ez tilah yoolhyih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Cha za Sizi tube cho 'udíja 'ink'ez duyughi yula ditni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Khunsul lugliz whucho dutai-i hukwa dímbal-i lhulcho lhk'ench'ul. 'Et yun cha núhisnai, 'ink'ez tse cho lhts'edankat. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ts'un k'ut dune 'adinla-un dáhana'dankat. 'Ink'ez lhane Yak'usda ooch'e'ne nahunistez inle', 'enne dunahudidil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'Et 'awet tse be tsa k'et ts'e hanáhidil, 'ink'ez keyoh Jerusalem ts'e whehandil. 'Et lhane nalhts'et bube hóodiltsai, 'et whe whúbunilhtan. Sizi nakhitna' hukw'elh'az ndulcho whe 'et dúhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Et 'awet ndun lhuganne bumoodih 'en, 'ink'ez yulh 'ut'enne, 'enne mbene la Sizi yughunline, yun núkhisnai 'ink'ez nts'oh te ne'whust'en-un, 'et honalh'en, 'et whe tube whehúnilhjoot 'ink'ez 'et 'uhutni, “'Alha azih ndun dune, 'en Yak'usda ooYe' 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ts'ekoo cha 'et núdilhya whe yoo 'az de whuts'un honilh'en. 'Enne Galilee ts'u haindilne 'uhut'en. 'Enne Sizi huyuwhusanándilne 'ink'ez hiba ne'úst'enne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'Enne butoh Mary Magdala whut'en-un, 'en cha 'ut'en, 'ink'ez Mary James 'ink'ez Joses bulh 'enne buloo, 'en cha 'ut'en, 'et Zebedee ooye'ke 'enne buloo cha, 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","'Et 'awet hulhgha whenghoh hoozulh whe 'ilhoghun Arimathea whut'en-un, dune hoonzoo' 'unt'oh-un, 'en Joseph huyulhni. 'En cha Sizi yugha hodul'eh-un 'ilhoghun suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","'En Pilate ts'u whinya, 'ink'ez Sizi oozi yuts'u yuka 'utni dutl'ayóolhtelh ha. 'Et Pilate ubulhni, “Sizi oozi ndun dune ootl'ayúlhtih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","'Et Joseph Sizi oozi ndus de hanáyalhti 'ink'ez naih dizti'-i, 'aw lhditsun, 'i yugha íyozduz. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'Et dich'oh ootse be tsa k'et 'andit-un 'uhoonla, 'et whambez ts'e 'et neínilhti. 'Et tse cho whudanádan'ai 'ink'ez whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mary Magdala whut'en-un, 'en cha 'et usda. Njan tsa k'et whanch'az, 'et 'uyoon Mary cha 'et usda. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","'Et njan dzenis whutih 'et wheni lhazdutneh-un dzin 'uhoont'oh. 'Et 'om bun dzin ndunne lubret bumoodihne 'ink'ez Phariseene cha, 'enne ts'iyawh Pilate ts'u whehandil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","'Et nduhúyulhni, “Nemoodih ndun nenan'a-un 'awhuz khuna whe daja neúlhni la, 'et whunats'ilni whe ‘Tat dzin inle' de dunádutásdalh,’ ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'Et whe nghuni be budóni' njan tsa k'et da'duta'alh whulh tat dzin 'et whuts'un. 'Et 'aw ndúlhinel de ndunne yugha hodul'ehne 'ulhdzis whusahándil 'ink'ez tilah hizi hidunoot'ih. 'Ink'ez la ts'iyanne hudóni' ndunne yaidlanne butoh dunadija whé 'unt'oh. 'Et whuz un'a 'udek'ez whuts'it-i, 'udechoo-i anus 'ultsi' whutáleh,” huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","'Et Pilate ndúbulhni, “Nohni cha huwunline aht'i whe aht'oh. 'Awet nahdulh 'ink'ez nohnich'oh soo duts'o cho whe dána'dih'aih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'Et whehándil 'ink'ez ndi tse k'ut whuduná'hudilhdze. 'I be duts'o cho whuzdli'. 'Et 'ink'ez huwunline 'et nehúninla. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nats'ulyis dzin hukw'elh'az lisman 'udechoo dzin-un, soo yutilhkai-un, 'et Mary Magdala whut'en-un 'ink'ez 'uyoon Mary bulh ts'un k'uz hooz'az 'ink'ez honilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Khunsul 'ilhoghun neMoodihti oolizas yak'uz hainya-un. 'Et huwa yun cha núhisnai. Whusainya 'ink'ez ndi tse whudahaidunalhgai, 'ink'ez yuk'étl'adida. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Oonin 'ants'i ditni kwun duwhút'en. Oonaih yus k'un'a 'ulhyul. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Et huwa nyoonne huwunline nujut k'et hudutlut, 'ink'ez 'ants'i dune dazsaine lhe'huja. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Lizas ndunne ts'ekoo ubúlhni, “Nulhjut íloh. T'eoonuszun Sizi mbe la tulalhgus k'ut dazai-un, 'en ookwunáhta whé 'aht'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","'Aw njan hooloh! Dunadija whe 'unt'oh. Nts'en'a la datínelh ni, whuz un'a dunadija whé 'unt'oh. 'Anih, njan whunulh'en, ndet la neMoodihti ilhte'-un! ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'Et 'a cho whuz ah'us 'ink'ez mbene la yugha hodul'ehne ubudáhni yaidlanne toh dunadija whé 'unt'oh. Soo zulhts'ai nohtso Galilee ts'oyalh. 'Et tih'elh. Soo cho soo zulhts'ai 'uda' nohdásni'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'A cho tse be tsa k'et whuch'a nahust'az. Whehunuljut 'et hoonts'i 'on nus huhóont'i' cha' hint'oh. 'Ink'ez mbene la yugha hodul'ehne buts'u whuhilgaih ubodutánelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","'Et mbene la yugha hodul'ehne ts'u hí'us whe khunsul Sizi buts'u dizya 'ink'ez, “Whunúlhnih,” ubulhni. Hizih nenin'az 'ink'ez hike óontun 'ink'ez hits'u téni' nalhdzin. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","'Et Sizi ndúbulhni, “'Aw whénulhjut iloh. Sulhutsinke buts'oh'us 'ink'ez sba budúhni, nohni ts'iyawh Galilee ts'u toohdilh. 'Et la sooh'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","'Et 'awet hutizdil whe 'et huwunline oolune Jerusalem ts'ú hoozdil. 'Et whuz hoozdil whe 'et ndunne lubret bumoodihne, 'enne ts'iyantsuk bubodáni' njan ndet la dahooja-un huwun. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","'Et 'awet lubret bumoodihne 'ink'ez dune 'utso whudilhdzulhne, 'enne ts'iyawh 'ilhunahozdil 'ink'ez howu yahalhduk. 'Ink'ez lhai sooneya 'i saldanne bugha hinindzai 'ink'ez 'ubuhútni, ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“'Et nohni diz un'a 'udutihnelh, ‘'Et 'ulhdzis 'awhuz ts'uztez whe mbene la yugha hodul'ehne whusahánil'i 'ink'ez oozi neghu hitilhti.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","'Et yun moodih whulh 'údants'o de, soo kháznint'a whe yats'oolhduk si. 'Et de la whuz un'a 'aw hoonli nohts'u lhe'hosne.” ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'Et huwa ndunne saldanne ndi sooneya huyilhchoot, 'ink'ez nts'en'a la ubodáni', 'et whuz un'a za 'onghohne cha budáni'. 'Et soo 'andit dzin 'et whuts'un, 'et whuz un'a lizwifne dich'oh dutoh howu yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'Et 'awet ndunne whunizyanne 'on 'at 'ilhoghun 'enne yugha hodul'ehne, 'enne Galilee ts'e whehandil. Ndi dzulh k'uz Sizi ubudani', whuz whehandil. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hiyan'en whe hits'u teni' nalhdzin. 'Et hoonts'i whulohne buba nawh 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Sizi buts'o whusainya whe bubulh yalhduk 'ink'ez nja dúbulhni, “Yak'uz 'ink'ez ndi yun k'ut 'et ts'iyawh whando 'ust'oh-un, 'et stl'ahóolts'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","'Et huwa lhelhts'un keyoh whut'enne, 'enne ts'iyawh buts'óhdulh 'ink'ez si sgha hodul'ehne ubulhts'i. 'UBá 'ink'ez 'uYe' 'ink'ez Ndoni, ndi boozi' be 'i be too be' butilh'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ndai khuni nohtl'adís'ai-i, 'i ts'iyawh hik'une' 'oot'en-un hubodoolh'eh. 'Ink'ez soo zulhts'ai, 'et dzin whulatoh lhaooduja de, 'et whuts'un 'ahoolhyiz nohbulh 'útist'elh whe' hoont'oh.” 'Et ndo honeh.");
INSERT INTO crxNTpo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ndi khuni unzoo-i, 'i khuni 'udechoo-i Sizi Gri, Yak'usda ooYe' ghun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","'Uda' Yak'usda be nus hoo'enne, ndi Yak'usda ooghuni ghun uk'unuhíyuzguz-i, 'et nja dutni, “‘Yak'usda 'ust'oh, soo zílhts'ai, 'uyoon khuni sba na'á-un ntsó tis'alh, mba lhawhúdutileh 'et wheni.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Et 'oho keyoh, 'aw dune lhuhóot'ih-un, dune 'ultus-un huyih whe, ‘NeMoodihti whuz de úyalh, ooti ooba lháoodahleh. Lhutíyalh-un hoonzoo 'ink'ez lhts'e whudiz'a ooba whulhtsi,’” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","'Et 'uhóoja John dune too be 'ulh'en-un, 'aw dune lhuhóot'ih ts'e oozya 'ink'ez tube' budáni', “Nohlubeshi 'ulh'en-un noheni náhandunoohleh, 'ink'ez too be' 'úlhneh, 'aw 'et de za Yak'usda nohlubeshi nohba 'ún yutilhdulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ts'iyanne Judea whunat whut'enne 'ink'ez Jerusalem whut'enne cha tehúnindil 'ink'ez John dune too be 'ulh'en-un huyoozílhts'ai. 'Ink'ez dulubeshi ghun hunahuhoolnuk whe nyo 'et 'ukoh Jordan huwhútni-un toot 'et John dune too bé' balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","'Ink'ez John dune too be 'ulh'en-un khuna-i gha stl'oo-i ye dune unli 'ink'ez 'uzus se be tsúdilh'oo. Tulk'us cho 'ink'ez ts'ihnatl'uz 'ohwhi za ya'alh inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","'Et 'ubúlhni, “Dune sk'élh'az whusatíyalh-un sanus dízti' whe 'unt'oh. 'Aw ookechun natl'ool ooba k'unaítís'uk 'et hoonts'i huba soo lhé'uzdzoo'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Too be' nohus'en 'et hoonts'i ndun dune 'en Ndoni be too be' nohtilelh 'ink'ez Ndoni nohyéduti'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","'Et sa' iloh hukw'elh'az Sizi Gri Nazareth ts'e hainya 'ink'ez 'ukoh Jordan huwhútni-un toot 'et John dune too be 'ulh'en-un Sizi too be' yínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Soo Sizi tooz hanaja ibulh, ndo yak'uz dáha' dankez whutílh'en, 'ink'ez Ndoni dut'ai k'un'a ndus de Sizi ook'édilts'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'Et 'uwhútni, “Nyun sich'oh sYe' inli. Tube nk'esi', 'ink'ez tube nyulh hoonúst'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","'Et 'ahoh Ndoni 'en Sizi n'un 'aw dune lhuhóot'ih-un ts'e wheyálh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","'Et dit whunizyat dzin Sizi 'aw dune lhuhóot'ih-un inda' 'ink'ez Satan tank'us 'óoneh-un hukwa yóolhdzih. Ts'ant'i 'i cha 'oh ho hoonli. 'Et lizasne whusahándil, 'ink'ez hiba ne'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","John dune too be 'ulh'en-un, 'ahúyan'ai hukw'elh'az, Sizi Galilee ts'e oozya 'ink'ez bubulh yálhduk nts'en'a Yak'usda ook'úne' whut'en-un, 'et huwun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","'Ink'ez 'et 'utni, “Ndi khuni unzoo-i 'unt'oh. 'Andit 'awet whusahónzut. 'Awet nilhdukw Yak'usda ook'úne' whutit'en whe' hoont'oh. Lubeshi 'ulh'en-un noheni náhandunoohleh, 'ink'ez ndi khuni unzoo-i nohba 'alha' 'oot'e' 'ink'ez ulhchoot!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","'Et Sizi bunghun Galilee taba nuya whe nane lho ha 'ut'enne uban'en, Simon 'ink'ez bulhutsin Andrew bulh lhembilh tahúyalhdil lho ha' 'ut'enne hinli 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","'Et 'ubúlhni Sizi, “Sunih'us, dune ha 'ooht'én-un whunohdoos'eh si.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","'Et 'aho dulembil hiladitni 'ink'ez hik'oh ts'e oot'en ha huyuntiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","'Et 'on 'unyaz hahándil 'et 'uyoonne nane lhulhutsinke James 'ink'ez John bulh Zebedee ooye'ke 'enne ubutilh'en duts'i bet dulembil na'hulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Soo Sizi ubutilh'en ibulh, “'Anih,” 'ubúlhni. 'Et 'awet Zebedee ooye'ke Sizi bulh whehán'az. Zebedee 'ink'ez yuba 'ut'enne cha 'awet ts'i bet húdilhts'i whe bughu whehán'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Keyoh Capernaum huwhútni-un whuz hoozdil. 'Om bun dzin Lizwif nahulyis dzin, 'et Sizi Lizwif bulugliz 'et bughu danínya 'ink'ez whewhúbondunilh'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dune yudánts'one tube buba hooncha, soo ooba' hoont'óh-un k'un'a whe dune whubodulh'eh, 'aw Moses be 'udustl'us 'uk'ununáguzne buk'un'a iloh 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","'Et 'ilhoghun dune butoh usda-un, 'en ntsi'-i nududeh-i k'úne' 'ut'en-un, 'aldzul whe 'utni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Sizi Nazareth whut'en-un ndet nets'ú hukwa' ninzun? Gak netalhtselh ha whusaínya? Mbe inli t'enyunúszun, nyun Yak'usda ba lubeshi ooghu hooloh-un, 'en 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","'Et Sizi hukwa' yudani' whe 'uyúlhni, “T'eduzinih whe ooyáhanaindaih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'Et ntsi'-i nudúdeh-i ndun dune yukaootilhdzut, 'alhdzul, 'ink'ez yuyáhanaja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ts'iyanne buba hooncha k'et 'et 'ulhodútni, “Dant'óh-un dune 'unt'oh, whutso da' lhts'odústs'o-un 'et whuneoodulh'eh? Ooghuni be whúnujut k'et ntsi'-i nudúdeh-i hoonts'i hik'úne' 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","'Ahoh Galilee keyoh whuti whunat whut'enne Sizi huyulh údants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","'Et 'awet Lizwif lugliz tenáhundil. Simon 'ink'ez Andrew buyoh ts'e hoozdil, James 'ink'ez John bulh cha whuz hooz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon oobiz lili k'ut sulhti. Ooyust'e nulwus-i be únduda. Sizi whuz oozya ibulh hidáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","'Et yughu ninya 'ink'ez yula t'az do yilhchoot. 'Ahoh ts'eke soo 'úja 'ink'ez bugha ná'unt'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Hulhgha sa yó whin'ai hukw'elh'az, ndudáne 'ink'ez mbene la ntsi'-i nudúdeh-i k'úne' 'ut'enne cha Sizi ghu bonínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ts'iyanne 'et keyoh whut'enne dati 'ílhuhózdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Lhawh didowh dada-i be undudáne, 'enne Sizi soo ná'balh'en 'ink'ez ntsi'-i nudúdeh-i k'úne' 'ut'enne, 'enne cha dune yé hanabunanyoot. Ntsi'-i nudúdeh-i 'aw yahoolhduk-un butl'alhúhoo'al t'ehinínzun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","'Om bun 'uda' 'awhuz lhuyulhkoh da' 'et Sizi dudinya 'ink'ez 'az whenya. 'Et nyo keyoh whuch'a suya, ndet la soo disoh ts'e, whuz oozya. 'Et tenadudli. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon 'ink'ez duk'ekene te Sizi hikunuta. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nahayilhti whe 'et 'uhuyúlhni, “Ts'iyanne nkunúta.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","'Et Sizi 'ubulhni, “'Uts'un keyoh ts'e cha uztoodilh huba' hoont'oh 'oh cha dune bulh yátisduk 'et huba whusásya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilee ndulcho nukéhudizde lugliz totsuk bubulh yálhduk 'ink'ez ntsi'-i nudúdeh-i dune ye hanábunuyukw. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Ilhoghun dune, ooká whulhjut-un, leprosy huyulhni, 'en Sizi ghu ninya, dugwutsi bé nenínya 'ink'ez yuts'u tédudli dula 'ooneh ha. “Nyun hukwa' ninzun de, be ilhtus-i 'int'i-i, 'i be suná'ilhdeh,” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sizi yugha té'ninzin yuts'ú nudilhni 'ink'ez yut'aíznai. “Hukwa' nuszun soo na'íntneh,” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","'Et za nyoon dune ulhjutun soo ná'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sizi khuniti be yulh yálhduk 'ink'ez 'et za whenáyalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Nyoon dune natisja whe 'et Sizi 'uyulhni, “Soo zilhts'ai, 'uyoonne dóni' junih! Inyalh ts'e lubret 'en oots'ínyalh 'ink'ez nyunoolh'en. 'Et 'ants'íya soo na'ínja hukw'élha ndet la Moses ooghuni k'un'a lubret nts'u húkwa' utni-un, 'i oogha íon'alh. 'Et ts'iyanne whúntalhtun ts'ih'un soo na'ínja.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","'Et hoonts'i ndun dune whenája 'ink'ez ts'iyanne dáni' 'on nus huwe yalhduk k'et Sizi 'aw keyoh dune tunóya' ait'oh. 'Inka n'awh dune lhuhóot'i 'oh dune unli. Lhelhts'iz de whut'enne whuz highu lhk'esúdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","'Et hukw'elh'az whutizútya whe Sizi duyoh Capernaum ts'e naoosja. Ts'iyanne whulh 'úhuduzts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Et 'ahoh dune 'ilhuhozdil. Whuz dune lhane 'alhgoh daníndil k'et 'aw whuz'ái-un hooloh, dati 'i bulh whudizbun. 'Et Sizi Yak'usda ooghuni ghun ubulh yálhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yalhduk whe dine dune, 'enne 'ilhoghun dune délhdusni-un Sizi ts'un hítizkai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Whuz dune lhai k'et 'aw Sizi híyénghun neóodilh ait'oh. 'Inka ndo bun 'i k'ihinílhti 'ink'ez soo ndet la Sizi 'unt'oh-un at'en, whuz ndun dune délhdusni-un ndus de yuk'usti-i, 'i bulh hukwu huyankai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","'Et Sizi dalcho-i be hit'anínintan t'eoonínzun 'et huwa ndun dune délhdusni-un 'ulhni, “Hadih ts'oodun nlubeshi ts'iyawh mba hooloh suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Whulohne Moses be 'udustl'us 'uk'unáguzne, 'enne nyo 'et hudilhts'i 'ink'ez 'uhinínzun, ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mbe na'dunúdzun whe 'utni, Yak'usda ch'az yalhduk. 'Aw 'oh dunene lubeshi n'un hutoolhdilh aít'oh, Yak'usda 'en za lubeshi n'un tulhdilh whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","'Et Sizi duyughi be daja huninzun t'ewhunínzun 'et 'ahoh 'ubulhni, “Dáhoont'oh huwa 'oh te nuní nahzut? ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndet 'uk'enus huwa lhúhoolna' ndun dune délhdusni-un 'udutásnelh, ‘Nlubeshi mba n'un tisdil,’ k'us ‘Dunadindaih 'ink'ez ninya?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Whunoh untistun, yinka dune ye', 'en njan ndi yun k'ut lubeshi n'un tulhdilh-un ooba hoont'oh.” 'Inka ndun dune délhdusni-un 'ulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nyudúsni, ookw'usinti-i ilhchoot 'ink'ez nyoh ts'e naíndalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ts'iyawh hinilh'en whe 'a ho dunadija, yuk'usti-i yilhchoot 'ink'ez ts'iyanne nalh whenája. Soo ts'iyawh buba hooncha 'ink'ez Yak'usda hidálhti' 'ink'ez 'uhútni, “'Aw whutsoda' 'et duhoont'oh-un lhts'uhoos̱'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","'Et cha za Sizi taba ts'e naóosja. 'Ilhozdílne highu nindil whe 'et whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","'Et Sizi 'oh whuya uyalh whe Alphaeus ooye' Levi, Capernaum whenkuti huwunli ha sooneya nálhdzooh-un, 'en Sizi yutilh'en 'et 'uyúlhni, “Sunanyalh.” 'Et Levi dudinya 'ink'ez hik'oh ts'e oot'en ha yuntizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Hukw'elh'az 'et Levi ooyoh lhanne ndunne sooneya nalhdzóohne 'ink'ez lubeshi 'ulh'enne, Sizi yugha hodul'ehne cha 'et bula na'ut'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","'Et Moses be' 'udustl'us 'uk'ununáguzne 'ink'ez Pharisee didowhne, Sizi hinilh'en nyoonne lubeshi 'ulh'enne, 'ink'ez sooneya nalhdzóohne bula na'ut'alh. Nyoonne Phariseene Sizi yugha hodul'ehne hubuhoodulhkut, “Dáhoont'oh huwa ndunt'óhne bula 'a'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sizi budánts'o 'ink'ez 'ubulhni, “Mbene la soo 'únt'ohne 'aw yoo be duyun-un halhe'hunízun, mbene la ndudáne, 'enne za yoo be dúyun-un ka' huninzun. 'Et whuz un'a si cha dune ts'ih'un 'unt'oh na'dunúdzunne ba whusálhusyal, lubeshi 'ulh'énne lht'anahunoodilh hubudutásnelh 'et wheni whusásya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","'Et John dune too be 'ulh'en-un yugha hodul'ehne 'ink'ez Phariseene bugha hodul'ehne cha soo húhoonih whe 'uyoonne Sizi highu nindil 'ink'ez 'uhuyúlhni, “'Et dáhoont'oh huwa John dune too be 'ulh'en-un yugha hodul'ehne 'ink'ez Pharisee bugha hodul'ehne soo húhoonih 'et hoonts'i nyun ngha hodul'ehne, 'enne gak?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sizi 'ubúlhni, “'Andit lhghuskéne ba nóye 'ul'en de, ndunne bughu nusdílne soo húhoonih la nahzun eh? Ndun dune oo'at whuzdli'-un, 'et butoh usda de, 'aw nduhóoneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","'Et hoonts'i whusaóotilts'ulh ndet la ndun dune 'at ut'í-un bughu nayitálchulh. 'Et dzin whusahóolts'ut de, 'oh de za soo húhootanih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“'Aw 'ilhoghun naih 'andidi-i naih jut be naoolhkut ait'oh. 'Et ndúja de, ndi naih 'andidi-i be nalhkut-i, nyoo naih jut nalhkut-i bulh hanaitich'ulh 'ink'ez 'on nus hooncha tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","'Et whuz un'a 'aw 'ilhoghun ts'ekoo too', 'awhuz 'ut'en-i, 'uzus 'ujut-i be húyoolhdzeh huba lhe'hóot'oh. 'Et nduhúyinla de nyoo ts'ekoo too' zus 'ujut-i ook'otáltulh 'ink'ez nankilt'oh ts'ekoo too' 'ink'ez oozus bulh ninta' tit'elh. Ts'ekoo too' 'awhuz 'ut'en-i 'uzus 'andidi-i be óoldzeh huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","'Et doo cha nahulyis dzin 'uhoont'oh whe, Sizi 'ink'ez yugha hodul'ehne tubulh tl'o k'ut 'oh whuya hidulh whe, tl'o mai' hoonuyin. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Et Phariseene Sizi 'uhuyúlhni, “Nilh'en dáhoont'oh huwa ngha hodul'ehne nats'ulyis dzin 'et 'uhut'en? 'Aw 'et nduhóot'en huba lhe'hoot'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sizi 'ubúlhni, “'Aw lakw hukw'u yalhúlhdih David dája 'oh da', yoo'alh-i hooloh whe yulh 'út'enne te buye'ílts'ul whe 'et 'uja, ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yak'usda ooyoh 'et danínya 'ink'ez nyoo lhes Yak'usda gha t'aih-i, 'i yu'alh 'ink'ez yulh 'ut'enne, 'enne cha huyan'al. Lubretne 'aw 'enne za huyoo'alh huba' hoont'oh, 'et hoonts'i David 'inkez yulh 'ut'enne cha nduhuja. 'Oh da' Abiathar 'en lubretne bumoodih unli whe' hooja.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","'Et Sizi 'ubúlhni, “Nahulyis dzin dune whe soo' hoot'e' ha 'oohoolya, 'ink'ez dune, 'enne 'aw nahulyis dzin huba lhe'hílnel. ");
INSERT INTO crxNTpo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","'Et huwa yinka dune ye', nahulyis dzin 'et hoonts'i hukwa' ninzun k'un'a 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","'Et Sizi Lizwif bulugliz ts'e naóosja. 'Ilhoghun dune oola 'aw ye nulhé'ust'en-un, 'et usda. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","'Et Phariseene tube Sizi highunli nahulyis dzin tilah nyoon dune ka únli-un nayoolhyih, hukwa hik'ého'alh-un, 'et hukwa highunli. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sizi nyoon dune oola ka únli-un 'ulhni, “Dunadindaih 'ink'ez ndiz nus ínyalh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","'Et Sizi uboodulhkut, “Neghá whunt'ai eh nahulyis dzin, 'ula' ts'utinelh k'us 'uts'uduntálhda, uztilhyih k'us gak uztilhtselh?” 'Aw dája lhodinel. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sizi tube hunílch'e whe butunuyú'en 'et hoonts'i whudulhyoh bugha té'ninzun, stabe butsi dunuts'un. 'Et nyoon dune ka únli-un yulhni, “Lhts'edílnih!” Nyoon dune lhts'edilhni ibulh 'ilhoghi oola k'un'a soo ná'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Et 'ahoh Phariseene nyo lugliz tenáhundil 'ink'ez Herod didowhne bulh highu yalhduk nts'en'a Sizi hituzilhghelh 'et wheni lhahóduleh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","'Et cha za Sizi yugha hodul'ehne tubulh Galilee bun ts'e náhoosdil. Galilee keyoh whut'enne whuz huyoonizdíl 'ink'ez lhelhts'iz de keyoh ts'e haíndilne tubulh. Judea ts'e haíndilne cha, ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem whut'enne cha, Idumea ts'e haíndilne cha, Jordan koh whanyan whut'enne cha, 'ink'ez ndunne Tyre 'ink'ez Sidon whut'enne, 'enne cha, ts'iyawh Sizi highe' 'ilhozdil lhat te ne'út'en huyulh 'údants'o 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","'Ilhozdílne huldlai 'ink'ez Sizi huyulh lhedindil 'et whuch'a yugha hodul'ehne, “Ts'i sba lhadáhleh,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Lhane ndudáne soo na'binla 'ink'ez 'uyoonne hit'aóonalh hukwa' hut'en ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'ink'ez mbene la ntsi'-i nudúdeh-i buyudíndane, Sizi hitulh'ih te, hibut nachánuldulh, 'ink'ez hahúzulh whe 'uhutni, “Nyun Yak'usda ooYe' inli whe 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","'Et Sizi khuniti be ndunne ntsi'-i nudúdeh-i 'ubúlhni, “Khun mbe 'ust'oh doohtni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Shus k'ut ndo whenya whe mbene la buka' ninzun 'enne buka' dani' 'ink'ez hits'o whúsaindil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Whunizyáne 'on 'at nane, 'enne 'utahábanla. “Sulh 'óoht'e' ha 'utahanóhisdla,” 'ubúlhni, “Dune bulh yátilhduk ha nohtis'alh ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","'ink'ez ntsi'-i nudúdeh-i dune yáhananoohyoot 'ink'ez dune soo na'boolh'en-un, 'et nohtl'ahóos'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ndunne whunizyane 'on 'at nane, 'enne 'utahábanla Simon, 'en Sizi “Peter” naidútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","James 'ink'ez bulhutsin John Zebedee ooye'ke 'enne Sizi Boanerges nabudátni, ndi 'oozí'-i “huskéne” ni whe 'utni; ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James Alphaeus ooye', Thaddaeus, Simon huwu daóodit'owh-un, ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","'ink'ez Judas cha 'en Sizi be ná'oodutakulh-un. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Et yoh ts'u náhoosdil. 'Et doo cha za 'ilhozdilne huldlai k'et Sizi 'ink'ez yugha hodul'ehne bulh 'uhuti'ulh, 'et hoonts'i 'aw 'uhooneh aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lhane dune 'uhutni, “Beni hoolel” hutni 'ink'ez ook'ekene huyulh údants'o whe hika natisdil dudeni yit ninta' 'oot'en whuch'a. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moses be 'udustl'us 'uk'ununáguzne, Jerusalem ts'u haíndilne, 'enne 'uhutni, “Beelzebul ooyudínda 'en yugha óonin'ai huwa 'ut'en ntsi'-i nududeh-i bughu whenábunuyukw.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","'Inka Sizi, “'Anih,” hubúlhni, 'ink'ez bubulh náwhulnuk higha hodool'eh ha, “Nts'en'a netsudule dich'oh nadudúntíjulh? ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Keyoh whut'enne lhch'az nehúdindil 'ink'ez lhehúndil de, 'et keyoh gak whutale, ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","k'us 'ilhoghun yoh whut'enne lhch'az nehúdindil de, 'et yoh whut'enne ts'iyawh yahitádulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","'Et ntsi'-i nududeh-i lhch'az nehúdindil de, 'aw sa' 'uhoot'e' aít'oh lhch'á náhúsdil 'ink'ez la gak hoole'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Dune ulhtus-un ooyoh dahá' danyuz 'ink'ez te'óolelh nehooloh, 'udechoo dune ulhtus-un yulhghel de, 'et de za yughu té'tilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Soo ts'ih'un nohdúsni, ts'iyanne dune bulubeshi cha 'ink'ez Yak'usda ch'az yáduk-un cha ts'iyawh buba n'ún whutildulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","'Et hoonts'i mbene la Ndoni ch'az yálhdukne, 'enne 'aw bulubeshi buba n'un yutoolhdilh ait'oh, 'ilhiz wheni lubeshi hut'i.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sizi ubudani'-un, 'et huwa ndunne Moses be 'udustl'us 'uk'ununáguzne 'uhútni, “Ntsi'-i nudúdeh-i ooyudínda!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","'Et Sizi ooloo 'ink'ez bulhutsinke te whusahándil yoh yoo 'az ts'e, 'et nódilhya whe yoh ts'e khuni hits'o tl'ain'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Dune 'ilhozdílne Sizi hinat dilhts'i 'ink'ez 'et 'uhuyúlhni, “Nilh'en nloo 'ink'ez nyulhutsinke n'at 'az 'uhut'en 'ink'ez nka' hoodulhkut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","'Et Sizi 'ubúlhni, “Mbe la sloo k'us mbene la sulhutsinke?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ts'iyawh dilhts'íne butunúyuz'en 'ink'ez 'utni, “Whunulh'en njan ndunne, 'enne sloo 'ink'ez sulhutsinke cha 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mbene la Yak'usda k'úne' 'ut'en unli-un, 'en sulhutsin, sulhtus, 'ink'ez sloo 'uhint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","'Et bunghun Galilee huwhútni-un, 'et doo cha za 'ilhozdilne Sizi higha óozdil 'ink'ez hubodulh'eh. 'Ilhozdilne huldlai k'et ts'i bet tl'adida'. 'Et ndanus le dodikelh whe 'et whuts'un 'ilhozdilne taba nódilhya whe hubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Lhat-un whe hukw'u bubulh nawhulhnuk huwa há hodool'eh 'et wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Soo zúlhts'ai 'ilhoghun 'a'nule-un, 'á'untilelh ts'u whenya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","'Et 'a'nule whe ooloh ti nanánkat. 'I dut'aiyaz whusahándil 'ink'ez ts'iyawh hinildil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","'Et ooloh tse toh nanánkat, 'ankw'us yunyaz hooloh-un, 'et huwa 'ahoh hánuski. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ooghih hooloh 'et huwa hasain'ai whe ts'iyawh yanúdizgi 'ink'ez gak suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","'Et ooloh cha whus cho tanínkat. 'I cha whus cho whutoh bulh hainanyai bulh lhéwhultloh 'ink'ez 'aw hálhniyil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","'Et 'onghoh-i yun unzoo-i k'ut nanánkat whe soo hananyai 'ink'ez oomai' whulukhi tat whunizyai (30) oomai' suli', whulukhi lhk'utat whunizyai (60) oomai' suli', 'ink'ez whulukhi whunizyat whunizyai (100) oomai' suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","'Et Sizi 'ubulhni, “Mbe la oodzo hoonine, 'enne huyoozólhts'ai' huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","'Et Sizi dich'oh 'únt'oh whe whulohne yoozálhts'ai'ne whel'a'ne bulh Sizi higha óozdil 'ink'ez 'uhuyúlhni, “Dája dani'-un, 'et neba hukw'u nuhílhye'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sizi ndúbulhni, “Nts'en'a 'utinelh Yak'usda dudune'ne hik'úne' 'ut'en-un, 'andit whuts'un dune ch'á nona'i'. 'Et 'andit ts'iyawh nohba hahónla t'eoonoohzeh ha, 'et hoonts'i 'uyoonne dune, 'enne higha hódool'eh k'un'a za bubulh yáduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","'Et huwa: ‘Honilh'en 'et hoonts'i la 'aw lhuhuhoos̱'en oole'. 'Uhoozílhts'ai 'et hoonts'i la 'aw t'elhuhonoosze. 'Et bubeni taóodilts'ut 'ink'ez Yak'usda ts'u náhulh'a de 'et bulubeshi buba 'ún yutilhdulh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Et Sizi 'ubúlhni, “Ndi oogha hódulh'eh-un, 'aw ts'ih'un nelhúwhu'al de, 'et nts'en'a suba 'oohne 'uyoo oogha hódutilh'eh-un ts'ih'un neootah'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","'Et Sizi ndúbulhni, “Yak'usda ooghuni 'i 'uyulh'en 'á'nule-un 'aínule, 'et whuz un'a Yak'usda ooghuni 'uhuyulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Whuloh te Yak'usda ooghuni ti nanúkat, 'i hidits'o te, 'et 'ahoh Satan khuni budzi bughu yílhchuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndi ndai da' tse toh 'anilya, ndunne 'i k'un'a za 'uhint'oh. Ndi Yak'usda ooghuni hidits'o 'ink'ez soo 'ahoh huhóont'i' whe huyilhchuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'Et hoonts'i didutch'oh 'aw bughih hooloh le'hint'oh. 'Et huwa 'atsulyaz za buba 'alha' hoont'oh. 'Ink'ez ndi khuni 'i gha dzoh nuhudeh 'ink'ez 'onghohne buch'az huditnih. 'Et huwa 'aho ndi khuni hiladutnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ndai la whus toh 'anankat-i le'unt'ohne, 'enne ndiz un'a 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","'Enne khuni hidits'o, 'et hoonts'i ndi yun k'ut huwu ni udli-un, ndi yun k'ut hoonzoo' hoont'oh-un, 'ink'ez ndai la ndi yun k'ut huhóont'i' tune' hut'en-un, 'et 'i ts'iyawh whus cho 'i be bulh lhe'ullhuk. 'Et huwa 'aw lhadúlyane hoole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","'Et whulohne yun unzoo-i k'ut nanánkat 'i unduhúlt'oh Yak'usda ooghuni hidits'o, huyílhchuk, 'ink'ez dudzi yo-un nehídi'aih, 'et oomai' whulih. Whulohne tat whunizyai (30), whulohne lhk'utat whunizyai (60), 'ink'ez whulohne cha whunizyat whunizyai (100).” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'On 'un Sizi ndúbulhni, “Too dízk'un dune daínin'ai 'ink'ez yuk'uz yoná'diz'ai tilah k'us lili t'a tilah 'aiyan'ai? 'Awundooh! Hukw'us'ai-un, 'et hukw'éyi'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","'Et huwa ndai la whu'iz 'unt'oh-i, ts'iyawh ts'et hatíkulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","'Et Sizi 'ubúlhni, “Mbe la oodzo hoonine, 'enne huyoozólhts'ai' huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","'Et cha ndúbulhni, “Huwahli 'ink'ez soo cho soo zúlhts'ai de, soo la oogha hódoolh'eh whuz un'a za Yak'usda 'on 'un cha la nohla 'ooneh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mbene la sghuni soo cho huyoozílhts'aine, 'enne 'on 'un cha huyootuzálhts'ilh 'ink'ez higha hódutil'eh. 'Et bugha whútat'alh 'ink'ez mbene la lhuhuyootuzálhts'ilhne, 'enne sghuni hidánts'o 'i hoonts'i hinaoodutilnoh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","'Et Sizi 'utni, “Nohbulh naóowhutiznuk Yak'usda ook'úne' whut'en-un, 'et huwun dune lhé'ut'en 'anulye-i 'anúle whuz un'a 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","'Et hukw'elh'az 'ulhdzis usti 'ink'ez dzenis 'et n'awh ne'út'en, 'et ndulyiz whe 'ainanla-i ook'unónultalh 'ink'ez haníyeh 'et hoonts'i 'aw t'eoonúszun dat'en whe hanúlhyih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","'Et yun 'i gha hanúlhyih 'ink'ez oomai' whulih. 'Udechoo yun ghu nuki 'et nuyih 'ink'ez dinyiz lhih te oomai' whulih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","'Et oomai' nut'ih te 'et dune lufoo be yut'us 'awet há' nukat newhúninzut 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","'Et Sizi 'utni, “Daja uzdutinelh whe Yak'usda ook'úne' whut'en-un, 'et hukw'u nuts'úhulhye' whe hígha hódool'eh 'i ook'únats'otilnuk? ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","'Uk'enus 'anulye-i nintsool-i, 'i mustard huyúlhni. 'I dune yilhchuk 'ink'ez 'ainulih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","'Et hanúlhyih te, 'ink'ez dilhtán-i 'uk'enus 'udilcho lhih oozischum dincha whe lhts'enunúlhye' 'et dut'aiyaz yutoh net'o ulih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Lhat-un higha hódool'eh ha bubulh yálhduk dáhoolcho-i be t'ehontizeh-un, 'et za hukw'u bubulh náwhulnuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Higha hódool'eh-i, 'i be za bubulh yálhduk 'et hoonts'i dich'oh 'úhint'oh te yugha hodul'ehne, 'enne soo cho buba hukw'ú nuhúlhye'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","'Et hulhgha za Sizi yugha hodul'ehne 'úbulhni, “Nyan tadatus ts'e uztooke'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'Inka 'ilhozdilne buch'a nahusdil yugha hodul'ehne ts'i be hándil, Sizi 'uda' ye usda-i, 'i be nyan hutizki 'uyoo ts'iyaz cha bubulh tizkat. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Khunsul nilhts'i ulhtus tizts'i whe tatsi dincha k'et ts'i be tádutih 'ink'ez 'ankw'us too be whendunimbun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","'Et Sizi ts'i niz ts'e 'et tse'alh k'ut tsenilh'al 'ink'ez nanisti. 'Et yugha hodul'ehne ts'e nahinílhdzut 'ink'ez 'uhuyulhni, “Nehodulh'eh-un, 'awet yats'itádla 'aw neghu ni lhínloh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Sizi dudinya whe too k'ut nilhtsi khuni ulhtus-i be hukwa' yudáni', “Nilhts'i, 'etsul 'ineh,” 'ink'ez, “Tatsi nulhózina,” 'ink'ez 'et 'awet dínghel. ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","'Et Sizi yugha hodul'ehne ndúbulhni, “Dahoont'oh huwa stabe nulhjut, 'aw eh bé 'alha' hoont'oh-i lhuht'ih whé aht'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'Et tube whéhunilhjoot 'ink'ez 'ulhodútni, “Dant'oh-un dune unli whe 'unt'oh? Nilhts'i 'ink'ez tatsi bulh hoonts'i yuk'úne' 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Et bun k'ut nyan hoozki whuz Gadarenne bukeyoh 'et 'úhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Soo Sizi ts'i bé hainya ibulh 'ilhoghun dune tse bet dune 'adinla-un whuz de haínya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ndun dune tel'en ntsi'-i nudúdeh-i, 'i ooyudínda 'ink'ez ts'un k'ut 'et whut'i. 'Aw dune lhuztih tl'ool be hoonts'i whehídolht'i ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Lhat whe oola 'ink'ez ooke bulh huyulhghelh 'et hoonts'i 'oh totsuk lhuztih tl'ool k'unuyúch'us 'ink'ez lhuztih ooke be lhulh'oo-i, 'i cha yayalh'us. Ulhtus k'et 'aw dune hich'a' oolhdeh aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Dzin 'ink'ez 'ulhdzis 'i bulh ts'un k'ut whutoh 'ink'ez nódist'ai-un, 'oh nuya whe 'aldzul 'ink'ez tse be oodudut'as. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Dzoh nilhdza'-un, 'et yughusyin whe Sizi yutilh'en. 'Ahoh yuts'u tílhgai 'ink'ez dugwut si be yubut nachánitno, ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","'ink'ez soo 'ultus-un 'aldzul whe 'utni, “Sizi 'uk'enus Yak'usda ooYe' ndet sts'u húkwa' ninzun. Yak'usda 'int'oh 'inka nts'u tédusdlih dzoh nusílhdzut iloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","'Et ndutni whe Sizi ndúyulhni ntsi'-i nudúdeh-i ndun dune ooyáhanaindaih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","'Et Sizi yoodulhkut, “Ndai la nyoozi'?” yúlhni. 'Et 'utni, “Legion, 'i soozi' 'unt'oh. 'I lhane lhuganne 'uts'int'oh ni whe 'utni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","'Et ntsi'-i nudúdeh-i Sizi soo yuts'u tédudlih, “Njan keyoh whuch'a netolh'a' junih,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Dzulh enghoh 'et gugoos lhai 'et 'a'álh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","'Et ntsí'-i Sizi ts'u tehududlih n'únne gugoos 'enne buts'u néilh'alh 'et de la buyúzdoodeh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","'Et huwa 'ahoh Sizi butl'ahón'ai ntsi'-i nudúdeh-i dune yuts'a hanádide 'ink'ez gugoos 'i yudande. Gugoos 'ankw'us 2,000 'unt'oh, 'i ts'iyawh whenghólghaz 'ink'ez too yanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","'Et nyoonne gugoos ghunline whehílghaz 'ink'ez keyoh whutakhuni hunin'ai. 'Et lhane whusaíndil dáhooja hontilh'elh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","'Et Sizi highu nindil 'ink'ez dune hinilh'en ntsi'-i nudúdeh-i ooyudúlts'i inlé'-un, 'et hukw'usda beni oogha nádilts'ut 'ink'ez soo dint'oh cha 'unt'oh. Buba hooncha k'et tube whéhunilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","'Et mbene la hon'énne, 'enne dune hudáni' ndun dune ntsi'-i nudúdeh-i ooyudúlts'i inlé'-un dája la 'ink'ez gugoos ghun cha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","'Et Sizi highu tedudli bukeyoh whuch'a naóoja' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","'Et Sizi ts'i be nádaih 'et ndun dune mbe la ntsi'-i nudúdeh-i ooyudúlts'i inle'-un, 'en Sizi yuts'u tédudlih, “Nyulh 'óosneh,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","'Et Sizi, “'Awundooh,” yúlhni 'ink'ez 'uyúlhni, “Nyoh ts'un naíndalh 'ink'ez nk'ekene te hubudíni dalcho 'i be la nyuMoodihti nts'un oodzi únzoo 'ink'ez dalcho 'i be nla 'uja.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","'Et ndun dune whenája 'ink'ez whunizyat-un keyoh 'et whutulhuséya Sizi daíyinla whe yula 'uja 'ubúlhni. 'Et mbene la yudits'one ts'iyawh buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Et Sizi nyan tadatus ts'e whenáhiki 'ink'ez bunghun whuzih lhane dune higha óozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","'Et Lizwif bulugliz whumoodih Jairus huyúlhni 'en yughu ninya 'et Sizi yutilh'en whe yubut nachániti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'Ink'ez tube cho yuts'u tédudlih, “Ustse'yaz 'awet datítsa, sulh naínt'us 'ink'ez ook'udólni sih soo ná'ootne 'ink'ez khoona' sih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","'Et 'awet Sizi yulh nátist'az. 'Et whuz lhane dune yulh tizdil k'et lhts'un ún'a huyúlhedindil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","'Ilhoghun ts'eke tube dzoh nuzut whunizyat 'on 'at nat yus k'ut 'et duwhulyiz whe 'uskai' 'uyulh'en-un, ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","yoo be dúyunne lhane cha hukwa' huyalh'en. Duzooneya ts'iyawh gak yulhtsi 'et hoonts'i nus za lhe'ínelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","'Et Sizi yulh údants'o 'et huwa dune toh Sizi yut'a ts'e yugha nínya 'ink'ez oonaih yut'aíznai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“'Ants'i oonaih 'i te oot'aízasnai de 'et de la soo ná'oosneh,” dich'oh 'et ndunínzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","'Inka Sizi yunaih 'i yut'aíznai ibulh 'et 'ahoh 'uskai' 'uyulh'en-un 'etsul 'uja 'ink'ez 'ahoh t'éoonanzin whe dzoh nuzut-un soo ná'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","'Et 'ahoh Sizi t'éoonanzin yé ulhtus ye dune la'ut'en-i ooloh oots'ahadílts'ut. 'Et 'ilhozdílne buts'u nálh'a 'ink'ez 'utni, “Mbe whe 'uja snaih yut'aíznai?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","'Ink'ez yugha hodul'ehne huyúlhni, “Dadíni whe' dini? Lhe'ultsuk 'ilhozdilne lhane whe nyan do hahúnildo 'ink'ez, ‘Mbe 'uja snaih yut'aíznai dini?’” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","'Et hoonts'i Sizi mbe 'uja-un yukuyú'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","'Et nyoon ts'eke daja whe soo ná'uja t'eoonanzin whe butahaínya whenuljut k'et dutlut 'ink'ez Sizi yubut nachániti 'ink'ez khuni 'alha' 'unt'oh-i be ts'iyawh yulh náhoolnuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sizi 'uyúlhni, “Stse' be 'alha' hoont'oh-i int'i 'et huwa soo ná'inja. Ndzi hóont'i' whe natonja' 'ink'ez ndai la be dzoh ninzut-i soo ná'ontneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","'Et 'awhuz Sizi nusíyilh whe khuni na'áne Jairus ooyoh ts'e haíndilne 'uhuyúlhni, “Ntse'yaz dazsai, ndun dune hodulh'éh-un di ha 'on 'un ooghu tédínlih?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","'Et Sizi 'aw 'oh cha lhnízun daja hutni whe ndun lugliz whumoodih 'uyúlhni, “'Aw whéniljut hoonts'i 'ants'i mba 'alha hot'e'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Aw 'uyoonne dune dulhúlhtildulh ndunne Peter cha, James cha 'ink'ez bulhutsin John cha, 'enne za hiyulh tizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","'Et 'awet Lizwif lugliz whumoodih ooyoh ts'e hoozdil 'et Sizi whunilh'en ndulcho whe tahuditni 'ink'ez tso yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sizi yoh danínya 'ink'ez 'ubúlhni, “Di ha sdabe tádahtni 'ink'ez ahtso? Ndun ts'oodun 'aw dálhitsal 'ants'i usti whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","'Et 'awet ts'iyawh highudloh. 'Inka ts'iyawh tenábunilh'a'. Ts'oodun oobá 'ink'ez ooloo bulh hubílhchoot, yugha hodul'ehne tane cha 'ink'ez ts'oodun sulhti ts'e danínya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","'Et ts'ekeyaz yula ílhchoot 'ink'ez 'uyúlhni, “Talitha koumi,” 'et dakelh k'un'a, “Ts'ekeyaz dunadindaih nyudúsni,” ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","'Et 'ahoh dunadija 'ink'ez nádinya. Nyoon ts'ekeyaz whunizyat 'on 'at nat be yus k'ut 'et ndúhooja whe soo ts'ih'un buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Sizi soo khuni ulhtus-i be 'ubúlhni, “'Et dune dóhni' junih, 'ink'ez hoonliyaz yuti'úlh-i oogha óoh'alh,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","'Et Sizi nyo usda-un whuch'a nasja 'ink'ez dukeyoh ts'e whenája. Yugha hodul'ehne cha huyulh whenadil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nahulyis dzin 'et Lizwif bulugliz whubodulh'eh whe lhane dune 'et dilhts'íne hidánts'o whe tube buba hooncha 'ink'ez 'uhútni, “Ndun dune nts'ez de hahónla whe 'utni? Ndi whunih-i be nts'ez dehahónla whe 'utni? 'Et nts'en'a 'ut'en sdabe huwa 'ít'en te ne'út'en? ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yoh 'uwhulh'en-un, 'en iloh lakw 'unt'oh? Mary ooye' 'et bulhutsinke cha James, Joses, Judas, Simon, 'ink'ez bulhtuske cha iloh nja huwhut'i?” 'Et 'inka hits'u disnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","'Et Sizi 'ubúlhni, “Yak'usda be nus hóo'en-un yalhduk te ndulcho whe hidílhti', 'et hoonts'i ookeyoh whut'enne, soo didutch'oh oonadneke 'ink'ez ooyoh whut'ine cha, 'enne za lhuhidílhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'Et huwa nyo 'et Sizi 'aw huwa 'ít'en te ne'óot'en aít'oh, 'et hoonts'i whulohne ndudáne, 'enne za buk'udílhni whe soo ná'bulh'ih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","'Et ndunne 'aw be 'alha' hoont'oh-i lhahuyít'ih, 'et Sizi ooba hooncha. 'Ink'ez whunat keyoh 'oh nuya 'ink'ez dune hubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","'Et 'awet nyoonne whunizyane 'on 'at nane, “'Anih,” hubudáni' 'ink'ez nane hinli whe lhelhts'un whebalh'a'. 'Ink'ez hiye úlhtus-i bugha nín'ai ntsi'-i nudúdeh-i dune yudúlts'ine buts'a hanáhinooyoot ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","'Ink'ez khuni ulhtus-i butl'adán'ai, “Tih'us ts'e hoonli te toohla' junih! T'alh-i cha, 'ézdla-i cha, k'us sooneya te bulh ts'údolh'oo junih! Tuz 'i za dutóohtan. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Be kets'alh'a-i 'ink'ez dzoot'an 'ilhiz be súhke-i, 'i za be 'óohneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","'Et 'udun cha 'ubúlhni, “Keyoh nah'az de dune duyoh danoh honilhti de, 'et yoh 'et 'oohke' 'uts'un keyoh ts'e tíh'us whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Et keyoh nenáh'az-un dune nohts'u hódilh'oh de k'us lhunohodústs'o de huwu nátóoht'as 'ink'ez whulez ch'a nohke naóohghat. 'Et la dahúja-un t'ehonoozeh. Ts'ih'un nohdúsni Sodom 'ink'ez Gomorrah whut'enne sdabe hintsi'. 'Udék'ez dzin de huyé dzoh nutízut-i ba nús 'et mbe la lhunohdústs'one dzoh notizut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","'Et 'awet whehándil 'ink'ez dune Yak'usda ooghuni be bubulh yáhulhduk, “Nohlubeshi ch'a lht'ananoohdilh,” hubuhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Lhane ntsi'-i nudúdeh-i ooghu dilhts'íne bughu whenábonanyoot 'ink'ez dune lhane undudáne khe be 'ubuhulho whe soo ná'buhalh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","'Et 'awet bulerwe Herod huyúlhni-un yulh údants'o Sizi dulcho whe búlh nukhuni uzut. 'Ink'ez 'utni, “John dune too be 'ulh'en-un 'ut'en. Dazsai inle' 'ink'ez nahítna' 'et huwa Yak'usda ye ulhtus-i ooghi diz'ai whe 'út'en whunul'en te ne'út'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","'Et whulohne cha, “Elijah 'ut'en,” hutni. 'Et 'uyoonne cha 'uhutni, “'Uda' hukw'un'a Yak'usda be nus hóo'en-un 'ut'en,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","'Et bulerwe Herod whulh 'údants'o whe 'et 'utni, “John dune too be 'ulh'en-un 'ut'en. Ootsi sba k'uhiníntsel inle' da', 'et hoonts'i la nakhítna',” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herod dich'oh John dune too be 'ulh'en-un 'ahuyoo'alh huwá bulh'a ínle'. Há yulhghel 'ink'ez 'ahuyán'ai. Ndun ts'eke Herodias huyúlhni-un, 'en yughusda. 'En gha' yinla ínle'. Dulhutsin Phillip oo'at lhch'a nijoot bulh hoonts'i yughusda. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","John dune too be 'ulh'en-un Herod lhk'uzte yulhni, “Yak'usda ooghuni k'uninyis whe 'int'oh nyulhutsin oo'at zih silda.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","'Et huwa oo'at Herodias John dune too be 'ulh'en-un yuts'u dutni 'ink'ez yuzoolhghelh hukwa' ninzun. 'Et hoonts'i duki, Herod, 'en gha 'aw yuzoolhghelh aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","'Et Herod 'en cha John dune too be 'ulh'en-un yé nuljut, t'eoonínzun John dune too be 'ulh'en-un, ts'ih'un dune unli, 'ink'ez Yak'usda oodune' 'unt'oh. 'Et huwa yugha 'óoli yoozílhts'ai hóont'i', 'et hóonts'i yoozílhts'ai totsuk oodzi dútults'uk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","'Et 'ilhudzin Herodias ooghá whults'ut Herod whuzdli dzin 'et dune dízti'ne 'ink'ez lhuganne moodih cha 'ink'ez Galilee whut'enne dizti'ne tubulh ts'iyawh bughu nusúya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodias ootse' danínya 'ink'ez buba nidai. Herod 'ink'ez ooghu nusjáne tubulh buba hoonzoo. 'Et Lerwe Herod Ndun ts'eke 'uyúlhni, “Ndai sts'o ooka' dini, 'i ngha tísdlelh,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lhat whe yuts'u náhizya whe 'uyúlhi, “Ndai sts'o ooka' dini-i ngha tísdlelh ndai lerwe be usdli-i lhulcho 'i hoonts'i ngha tísdlelh,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","'Inka nyoon ts'ekeyaz 'az whenája 'ink'ez duloo 'en yoodalhkut, “Di suba oots'u ka' doosni'?” yúlhni, “John dune too be 'ulh'en-un ootsi,” yúlhni, ooloo. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Et ts'eke 'ahoh lerwe yuts'u naóosja 'ink'ez 'uyúlhni, “John dune too be 'ulh'en-un ootsi 'andit 'ahoh tsets'ai be sgha nín'aih,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","'Et lerwe 'ahoh ni suli' 'et hoonts'i 'aw yuch'a tsédootni ait'oh, ooghu nusjáne bunalh yuts'u náhizya 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","'Inka 'ahoh 'ilhoghun huwunli-un, 'adinlane dilhts'i ts'e wheyálh'a' John dune too be 'ulh'en-un ootsi whusaínoo'alh wheni. Huwunlí-un, 'adinlane dilhts'i ts'e whénya 'ink'ez John dune too be 'ulh'en-un yutsi k'únintsel. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Tsets'ai bé nan'ai 'ink'ez ts'eke yutl'ayánkai. 'On 'un ts'eke duloo tl'ayánkai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","'Et John dune too be 'ulh'en-un yugha hodul'ehne huyulh 'údants'o oozi hikunásdil 'ink'ez 'ahayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","'Et 'awet whel'a'ne whusanáhidil 'ink'ez Sizi te 'ilhuhozdil 'et hidáni' nts'oh te né'hust'en 'ink'ez ndet za dune whubuhodalh'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lhane dune whusahúdulh 'ink'ez whenáhudilh 'et huwa Sizi 'ink'ez yugha hodul'ehne tubulh 'uhútí'ulh 'et hoonts'i búgha lhúwhulhts'it 'inka ndúbulhni, “'Uts'un uztoodilh nts'e la whenich'oh úztit'elh-un, 'et la 'atsul naoolhyis.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","'Et 'awet nus ts'i be hutizki disoh ts'e whuz nehúninki. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","'Et hoonts'i lhane dune huban'en hutizki whe 'ink'ez 'ahoh t'ehonínzun mbe 'unt'oh 'et huwa keyoh totsuk whut'enne lhane hilwus whe Sizi 'ink'ez yugha hodul'ehne tubulh butso 'et whuz hoolhghaz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","'Et Sizi ts'i be hainya whe lhane 'ilhozdil 'et ubunilh'en tube bugha té'ninzun 'ants'i 'usbaiyaz ooghulhídloh-i lé'hint'oh 'inka lhat-un 'et whubuwhéoodunilh'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","'Et 'awet yoo 'ún hoozulh whe yugha hodul'ehne highu nindil 'ink'ez 'uhuyúlhni, “'Awet tube yoo 'ún hoozulh 'ink'ez njan disoh cha 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nyoonne dune ts'iyawh nabalh'alh n'aho keyoh hoontsool-un, 'ink'ez khuna-i nuyéh-un whutoh 'oho t'alh-i náhoodoket huyoo'alh-i hooloh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","'Et Sizi 'ubúlhni, “Nohnich'oh hiti'ulh-i bugha náh'aih dah.” 'Et huyoodulhkut, “Whuz uztidulh hukwa' ninzun 'ink'ez $200.00 k'oh t'alh-i ts'onket 'ink'ez eh bugha 'úzti'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","'Et hoonts'i Sizi uboodulhkut, “Lhes dáltsuk aht'i 'et whunulh'en.” 'Et nahuhoon'ai whe 'et 'uhuyúlhni, “Kwulai' liba 'ink'ez nanki lho cha.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Sizi 'et yugha hodul'ehne 'ubúlhni, “Ts'iyawh dune lhendun nébunulhle 'ink'ez tl'oyaz k'ut hudólts'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'Et 'awet dune nétl'ahudilts'i' tl'oyaz k'ut whunizyat whunizyai 'ink'ez kwulat whúnizyai whe lhaniwh te lhuhúsguz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","'Et 'awet Sizi nyoo liba 'ink'ez lho bulh yílhchoot ndo yak'uz ts'e yután'en 'ink'ez, “Musi,” ni whe tenadidli. 'Et lhes taidanyuz whe yugha hodul'ehne whutahayólelh ha butl'ayánla. 'Et nanki lho cha 'et dúyinla whe za butainínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ts'iyawh 'uhan'al 'ink'ez 'uhunisdai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","'Et yugha hodul'ehne whunizyat 'on 'at nanki chalhyal dizbun-i lho 'ink'ez lhes bulh 'et nenínkat-i nahúyalhdzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","5,000ne dunene buts'ekoo' 'ink'ez bubuzkeh cha 'enne ndi lhes huyan'al. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","'Ahoh Sizi yugha hodul'ehne ts'i be nábalh'a' 'ink'ez Bethsaida huwhútni keyoh whuz dutso whebalh'a' nyan tadatus ts'e whuz'ai. 'Et didut nyoonne 'ilhozdílne whenábalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","'Et whenáhidil whe tenadutidli ha 'awet buch'a násja 'ink'ez dzulh k'uz ts'e whénya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","'Awet húlhgha suli' 'et la nyoo ts'i be 'andit za taniz hikelh 'ink'ez la Sizi 'en dich'oh 'awhuz nyo yun k'ut 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yugha hodul'ehne ubunilh'en nilhts'i dulhyo hikelh tube hunint'i, 'aw hoot'o cha aít'oh. 'Et bundada' yutilhkaí-un, 'et Sizi too k'ut uyalh whe nus whuz bughu ninya bube nghootáyalh inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","'Et hóonts'i hitilh'en too k'ut uyalh whe, “Dune tsin 'ut'en,” huninzun. Tube whéhunilhjoot 'ink'ez 'uhúldzul. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","'Et Sizi 'ahoh bubulh yátilhduk, “Nohdzi ulhtus úlhtsi! Si 'ust'en. Whenulhjut íloh,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Et ts'i bet bughu dénya. 'Et 'awet oozts'i 'ink'ez yugha hodul'ehne tube buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Whutsoda' liba dáyinla la 'et 'aw ts'ih'un nelhúhohoo'al, 'et huwa njan lhes ghun dahóoja-un bubeni taóodolts'it aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","'Et 'awet nyan bun k'ut yahúninki 'ink'ez keyoh Gennesaret huwhútni-un, 'et ts'i whehídinguz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ts'i hich'az údulh whuz za 'ahoh Sizi 'en nahuyóolhts'it. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'Et huwa ndulcho whe nahúlhghaz 'ink'ez nts'oh la Sizi usda huyulh 'údits'o 'oh ndudáne hik'ustez whe 'i be hits'ú butule. ");
INSERT INTO crxNTpo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Ink'ez nts'oh la Sizi nuya keyoh whuyaz k'us keyoh whuti k'us khuna-i nuyéh-un 'e'óoket-un whutoh dune 'ilhodúlh-un whuz ndudáne nébuhunle 'ink'ez Sizi híghu tédudlih, “Nyunaih 'ants'i ooban 'et ndudáne hit'aóonalh,” huyúlhni. 'Et mbene la yut'aíznaine ts'iyawh soo ná'huja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","'Et 'awet Phariseene 'ink'ez Moses be 'udustl'us 'uk'ununáguzne tubulh Jerusalem ts'e haíndilne Sizi higha óozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Et hubonilh'en whulohne Sizi yugha hodul'ehne dula tsun bulh 'uha'alh. 'Uda' Phariseene, 'enne 'et, “Me” huwhútni inle' 'inka buts'ú hahuhon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Phariseene 'ink'ez 'on 'awh Lizwifne ts'iyawh butsoda'ne whubuhodalh'e' whuz un'a 'uhint'oh soo ts'ih'un un'a dula tunáhugus te za 'uhá'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","'Ooket bayoh ts'e hanahudulh te la'huldoh 'et 'ants'iya 'uha'alh. Lhat-un buba hoosdzi te né'hut'en, dulubot, dude 'oosa', 'ink'ez 'uyoo huyé buta'ut'en-i cha, dulili cha, soo buba' hoont'oh k'un'a za tunáhuyugus. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Et huwa Phariseene 'ink'ez Moses be 'udustl'us 'uk'ununáguzne Sizi huyoodulhkut, “'Et dáhoont'oh huwa ngha hodul'ehne netsodá'ne whuneodalh'e' k'un'a lhe'hust'en 'ink'ez dula tunálhuhusgus whe 'uha'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","'Et Sizi 'ubúlhni, “'Alha azi Isaiah nohghun nus hón'en whe 'unohúlhni, ‘Dune duba 'uzoo' na'dudil'íne,’ whuz un'a nohghun 'uk'e'ánguz inle' Yak'usda 'utni, ‘Ndunne dughuni be sba hodílhti', 'et hoonts'i 'aw budzi yo whe buba 'alha lhe'úst'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Sts'un téni hunilhdzun doo ka 'uhutni, ndi yun k'ut dune yugha néulh'ai-i, 'i Yak'usda ooghuni huyilh'i whe dune whubuhodulh'eh’.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","'Et Sizi 'utni, “Yak'usda dughuni nohtl'aídan'ai, 'i 'aw lhoozúlhts'ai 'ink'ez yinka dune' whubuhodalh'e'-un, 'et za ook'úne' 'uht'en, tsets'ai, lubot, 'ink'ez 'uyoo be buta'whut'en-i tunáhgus-un, 'oh dúhoont'oh-un, 'et dune whubodulh'eh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","'Et 'on 'un cha Sizi 'utni, “Tube 'uyoo ahli Yak'usda dughuni nohtl'aídan'ai ooladíhtni, 'ink'ez nohnich'oh be dune hodulh'eh-i, 'i za nulht'i whe whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Et Moses 'uk'unéyuzguz-i nja dutni, ‘Mbá 'ink'ez nloo bulh hubudólhti',’ 'ink'ez ‘Mbá la duloo k'us dubá dzoh ts'e bughu yatílhduk-un 'en daóotsa huba 'unt'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","'Et hoonts'i hoonli duloo 'ink'ez dubá ye búla tit'elh-i dune yut'i de 'ink'ez 'en ‘Corban 'uhoont'oh,’ ní de (ndi ‘Corban’ Lizwifne bughuni 'et dakelh k'un'a ‘Yak'usda ooch'e',’ ni whe 'utni), ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","'et whe la 'aw duloo 'ink'ez dubá bulh bula oot'en whuch'a whubodulh'e whe' dahni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","'Et njan huwa Yak'usda ooghuni 'aw lhoozúlhts'ai 'ink'ez ook'únulhe'zaht'en. Whuz un'a dune whúbunulhtun lhat-un whe 'udun cha nohnich'oh nohk'un'a whe whuz un'a whúbunulhtun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","'Et 'ilhozdílne Sizi doo cha za, “'Anih! Soo zúlhts'ai ts'iyanne 'ink'ez noheni taóodolts'it,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","“Ndai la dune hiyilhchúk-i 'aw oogha lubeshi ólhchoot aít'oh, 'et hoonts'i ndai la dune buts'u haídults'it-i, 'i gha lubeshi hilhchuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Mbe la oodzo hoonine, 'enne huyoozólhts'ai' huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","'Ilhozdílne butáhanája 'ink'ez yoh danánja whe yugha hodul'ehne ndi hígha hódul'eh yé yaílhduk-i hikwa huyoodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","'Et 'ubulhni, “Nohni cha eh 'uyoonne k'un'a, noheni hooloh? 'Aw noheni taóodolts'it aít'oh. Ndai la dune yu'alh-i, 'i gha lubeshi olhchoot aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","'Aw oodzi be lhéyuskat oobut za be yúkuk 'ink'ez ooyust'e ts'ahanáyakat, 'et whuz un'a 'utsi'-i neyust'e táhanakat.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","'Et 'on 'un cha 'ubúlhni, “Ndai la dune oodzi yo whuts'ahadúlts'it-i, 'i gha lubeshi ilhchuk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","'Et dune budzi yo ts'e whuz de 'aw beni lhe'ízoo' 'et huwa 'ut'en, 'uyoon dune oo'at bulh lubeshi hilhchuk, dune ts'eke bulh ninta' hut'ih, nehughan cha, ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'uhundunut'ih cha, 'uyoonne ch'e' ha' huninzun, hoontsi' k'un'a túne' hut'en, dune nahuna'ah cha 'uhut'en, yooyá lhilohne, 'uhoolnih cha, Yak'usda ch'az yahalhduk, 'ududílti', 'ink'ez hoonts'i tune' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'I ts'iyawh ndi dune budzi yo ts'e hadúlts'it-i, 'i gha lubeshi hilhchuk.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","'Et Sizi whenája whe Tyre 'ink'ez Sidon huwhútni-un keyoh 'et whunat whuz naoosja. 'Et 'ilhoghun yoh danínya 'ink'ez 'et usda 'uyoonne t'ehonózin hukwa lhe'nízun, 'et hoonts'i 'aw buch'a ntool'ih aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","'Ilhoghun ts'eke ooyats'e ntsi'-i nudúdeh-i ooyudínda Sizi yulh údits'o whe yughu ninya 'ink'ez yubut nachánitno. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ndun ts'eke 'uts'iz de haínya 'ink'ez 'en Greekne buk'uyálhduk 'ink'ez Phonecia, Syria whuz'ai, 'et whuzdli-un 'unt'oh. 'Et Sizi yughu tédudlih whe yúlhni, “Ntsi'-i nudúdeh-i syats'e oots'u hanaíninyoot.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","'Et hoonts'i Sizi ts'eke 'uyúlhni, “Ts'oodunne, 'enne cho bubé' ts'oolh'alh. 'Aw ts'ih'un lhe'hóot'oh ts'oodunne huya'alh-i ts'ílhchoot 'ink'ez lhike gha ts'óo'alh aít'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","'Et yúlhni, “Moodih, 'alha' dini, 'et hoonts'i whuloh te lhike 'enne hoonts'i ludab t'ah yun nakat-i ts'oodunne yughá 'oo'ulh-i huya'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","'Et Sizi ndúyulhni, “'Et ndúdinja-un huwa nyoh ts'e naíndalh ntsi'-i nudúdeh-i nyaz yuyáhanadidzut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","'Et duyoh ts'u whenaja 'ink'ez ooyaz lili k'ut usti ntsi'-i nudúdeh-i yuyáhanadidzut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","'Et 'awet Sizi keyoh Tyre huwhútni whunat 'ut'en inle' 'ink'ez Sidon huwhútni 'oh whuya lhuséya whe whunizyat-un bukeyoh whutulh lhuséya 'ink'ez Galilee Bun whuz oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","'Ilhoghun dune lhe'dústs'o 'ink'ez yalhulhduk cha 'unt'oh, 'en Sizi highu hinílhya 'ink'ez Sizi highu tédudlih yuk'udólni ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","'Et Sizi bughe'udunyaz nénilhya whe yudzeh 'ádilga, 'úntizo, 'ink'ez dune yutsoola t'aíznai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sizi ndo yak'uz ts'e yután'en, yughudzoh 'úja whe tenadudli 'ink'ez dune yulhni, “Ephphatha!” ndi lizwif bughuni 'et “Mba dáha' doolts'it” ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","'Et 'ahoh dune 'udits'o nasdli' 'ink'ez soo yálhduk cha nasdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","“Khun te dune dóhni' junih!” 'ubúlhni. 'Awet, “Dah” 'ubúlhni, 'et hoonts'i 'on nus huwu yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","'Ink'ez mbene la ubodits'óne ts'iyawh buba hooncha, “Sóo usdla ts'iyantsuk né'whulh'en, lhe'dústs'one 'uhudits'o 'ink'ez yalhulhdúkne cha yahalhduk ubulhtsi,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","'Aw sa' iloh hukw'elh'az doo cha za dune lhane 'ilhuhozdil 'awet ut'alh-i gak suli' whe Sizi yugha hodul'ehne, “'Anih,” ubudáni' 'ink'ez 'ubúlhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndunne dune bugha' te'nuszun. 'Awet tat dzin sulh 'úhit'en 'ink'ez huyoo'alh-i hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Et duhínt'oh whe buyoh ts'e whenábis'a' de nahidulh whe la bukaootoodeh. Whulohne tube nilhdzaz de hahándil 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","'Et yugha hodul'ehne huyoodulhkut, “Ndo ho dune cha lhuhoot'ih, nts'e suba t'alh-i nats'ólelh lhe'hultsukne dune gházti'alh wheni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","'Et Sizi uboodulhkut, “Daltsuk lhes sut'e aht'i?” 'Et huyúlhni, “Lhtak'ant'i lhes sut'e.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","'Et 'ilhozdílne yun hudólts'i' huwa bulh'a. 'Et lhtak'ant'i lhes yílhchoot 'ink'ez, “Musi,” ni whe tenadidli. Tánidizyuz 'ink'ez yugha hodul'ehne butainínla whutahayólelh ha, 'ink'ez dilhts'íne butahinínla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","'Et lho cha ntsool-iyaz hut'i, 'i cha Sizi “Musi,” ni whe yuba tenadidli 'ink'ez 'i cha yugha hodul'ehne, “Whutahayólelh,” 'ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ts'iyanne 'ahan'al 'ink'ez 'uhunisdai. 'Et yugha hodul'ehne lhtak'ant'i chalhyal dizbun 'i highá 'ozal-i nahuyalhdzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","4,000ne at'en 'enne 'ahan'al. 'Et 'awet Sizi whe nábalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","'Et 'ahoh yugha hodul'ehne bulh ts'i be náhidil 'ink'ez keyoh Dalmanutha huwhútni-un whuz yanáhuski. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","'Et whulohne Phariseene Sizi highu nindil 'ink'ez hidulhyoh whe' dunini' huyóolhdzih whe huyóodúlhkut, “Huwa 'ít'en-un 'uhóonleh 'alha Yak'usda ntl'ahón'ai de huwa t'éts'onoozeh ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sizi tube hibadzo 'údija 'ink'ez 'ubúlhni, “Di ha 'andit dunene huwa 'ít'en-un hukwa' hutni? 'Alha nohdúsni 'aw ndi yun k'ut whudune'ne ndúhoont'oh-un huhoo'en ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","'Et 'ahoh buch'a nasja ts'i be nája 'ink'ez bun k'ut nyan whenáki. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yugha hodul'ehne lhes nahodilhnoh 'ilho liba za ts'i be húlh'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","'Et Sizi bugha utni whe, “Huwohle', 'ahoolhyiz khuhdli Phariseene 'ink'ez Herod bulhes untuldoh-i ch'a,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","'Et 'awet lhulh yáwhehunilhduk, “'Et 'aw lhes ulhts'ít'ih 'inka 'utni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","'Et Sizi whe daja hutni la 'uda' t'eoonínzun 'et 'úbulhni, “'Et di ha lhes lháht'ih-un 'et huwa yalhduk, 'awhuz t'eoonuzúhzun k'us noheni t'alhodúlhts'it nohdzi 'awhuz eh duts'un whe' dahni? ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nohna hoonli be lhózih'en, nohdzo hóonli be lhe'duzahts'o. 'Aw eh whunalhuzulhni? ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","5,000ne dune kwulai' liba butaidísyuz whe daltsuk chalhyal dizbun 'i dune yughá'oz'al-i nalhdzoo ínle'?” “Whunizyai 'on 'at nanki,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“'Ink'ez lhtak'ant'i liba 4,000ne dune butaidísyuz, daltsuk chalhyal dizbun-i highá 'oz'al-i nalhdzoo ínle'?” 'ubúlhni. “Lhtak'ant'i,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","'Ink'ez 'ubúlhni, “'Et 'awhuz eh noheni talhodúlhts'it?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","'Et Sizi yugha hodul'ehne bulh keyoh Bethsaida huwhútni-un whuz hoozdil whe 'ilhoghun dune hoos̱'én-un, 'en Sizi highu hinílhya 'ink'ez highu tedudlih yuk'udólni ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Sizi hoos̱'én-un yula ilhchoot 'ink'ez keyoh whuch'a yúlhya whe lhch'az dune yuna k'énzo 'ink'ez yuna k'údilhni whe 'uyúlhni, “Hadih hon'en eh?” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Dune yután'en 'ink'ez 'utni, “A, dune nus'en 'et hoonts'i 'aw ts'ih'un lhozis'en, dune 'ants'i duchun lé'hint'oh 'oh nuhúdilh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sizi doo cha za lhch'az dune yuna k'údalni 'ink'ez 'on nus yutís'en. 'Et 'ahoh hoo'en nasdli' 'ink'ez ts'iyaitsuk ooba hooltsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","'Et Sizi yuyoh ts'e whenáyalh'a' 'ink'ez khuni ulhtus-i be 'uyúlhni, “Bethsaida ts'e nátonja' junih 'ink'ez Bethsaida whut'enne budóni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","'Ink'ez yugha hodul'ehne bulh Caesarea Philippi 'et keyoh whuz whehándil. Hidulh whe uboodulhkut, “N'awh dune sghu yahulhduk te, mbe usdli hutni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","'Et yugha hodul'ehne huyúlhni, “Whulohne 'uhutni John dune too be' 'ulh'en-un inle'-un 'int'oh. 'Et 'uyoonne 'uhutni Elijah 'en Yak'usda whusaítilh'alh-un 'int'oh. 'Et 'uyoonne cha Yak'usda be nus hóo'enne 'ilhoghun 'int'oh hutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","'Ink'ez yugha hodul'ehne 'ubúlhni, “Nohni do' mbe 'ust'oh dahni'?” 'Et Peter 'utni, “Nyun Christ 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Sizi khuni ulhtus 'i be 'ubúlhni, “Si sghun dune dóhni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","'Et 'awet Sizi yugha hodul'ehne whubodulh'eh 'ink'ez 'ubúlhni, “Yinka dune ye' tube cho dzoh nuhítilhdzut. 'Et netso whudilhdzúlhne, lubret moodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha ts'iyawh 'aw huyoozólhts'ai aít'oh. Hituzilhghelh 'ink'ez whulh tát dzin dunádutádalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Soo ts'et cho ubúlhni, 'et huwa Peter Sizi 'udun nénilhti 'ink'ez hukwa' yudáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sizi yugha hodul'ehne buts'un nálh'a whe Sizi Peter hukwa' yúlhni whe yúlhni, “Satan st'a nenínyalh! Ndi yun k'ut hoonli za ghu nuní ninuzut. 'Aw Yak'usda ooch'e' ooghu nuní lhnuzinzut.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","'Et Sizi 'ilhozdilne 'ink'ez yugha hodul'ehne tubulh, “'Anih,” ubúlhni, “Mbene la sulh tídulh hukwa' ninzunne dich'oh duba moodih nahoodle' ait'oh. Dutulalhgus hídutootan 'ink'ez suntooya'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","'Et mbene la si sanus duk'un'a za hukwa' ninzunne, 'enne 'aw 'ilhiz wheni hukhoona' ait'oh. 'Et hoonts'i mbene la si sba, 'ink'ez khuni unzoo-i gha 'et huwa daházsai de, 'enne 'ilhiz wheni hukhutinalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","'Et dune yinka ndulcho 'uhoolhdzun 'ink'ez dazsai de, ndet suba whuch'a hólhdeh? Soo gak! ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Dats'úzsai de, 'aw hoonli be hoonts'i 'ilhiz ts'otinalh-un nats'uhoket ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Et 'andit yuk'edinzutne lhane dune ts'eke bulh ninta' hut'ih, 'ink'ez Yak'usda nahodilhno whe' hint'oh. 'Et huwa 'ilhoghun dune si 'ink'ez sghuni bulh hukwaya unli de, yinka dune ye', 'en yukaya oole' la 'oh de lizas bulh ooBá oots'u hayánduz-i toh whusanája de.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","'Et 'on 'un cha ndutni, “Njan whunaoolhni, ndet la ts'iyanne Yak'usda ye úlhtus-i be hik'úne' 'ut'en-i whusáwhutilts'ulh, whulohne dune njan dilhts'ine hoti'elh dahútitsa whutso.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Lhk'utat dzin inle' whe 'et Sizi, Peter, James 'ink'ez John dulh húbutilhdil ndo dzulh k'uz dulh ubílya. 'Et hinilh'en whe 'uts'un un'a be hóodiltsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'Ink'ez oonaih be hóodiltsai ulhyul k'et soo yus 'et nduja 'uk'enus ndi yun k'ut soo tunasguz-i ba nus ulhyul suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nyoonne tane yugha hodul'ehne khunsul Elijah 'ink'ez Moses bulh Sizi hizih usyin 'ink'ez huyulh yálhduk whe hubotilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","'Ahoh Peter Sizi bulh yátilhduk, “Nehodulh'eh-un hoonzoo whe' hoont'oh njan uzdilhts'i. Ta nimbali nohba nets'oolelh, 'ilho nyun mba, 'ilho Moses ba, 'ink'ez 'ilho Elijah ba.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Peter ndi khuni be yalhduk whe daja dutinelh 'aw t'éwhunúszun tane hult'oh bugha 'únjaz k'et 'et huwa 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Khunsul kw'us buk'índe 'ink'ez ndo kw'us toh ts'e yaztílhduk, “Ndun sich'oh sYe' 'unt'oh, tube ook'esi'. 'En soo oozúlhts'ai,” whutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","'Et 'ahoh dunat nuhúyuz'en 'aw 'uyoonne lhuhí'elh, Sizi 'en za bubulh 'út'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","'Et 'awet dzulh k'ut nyo nanáhidil whe Sizi khuni ulhtus-i be 'ubúlhni, “Khun te 'uyoonne dóhni' junih! Ndet la hooh'én-un, yinka dune ye' dunadutádalh 'et whuts'un.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Hik'un'a 'uja 'ink'ez dich'oh 'alhgoh howu yawhehúnilhduk, “Ndi khuni ‘Dazsai 'ink'ez dunadutádalh?’ di ni whe 'utni?” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","'Ink'ez Sizi huyoodulhkut, “'Et Moses be 'udustl'us 'uk'ununáguzne di ha ubodulh'eh Elijah 'en 'udechoo whusatíyalh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sizi 'et 'ubúlhni, “Elijah 'alha 'udechoo whusaínya ts'iyantsuk lhaóodutileh ha. 'Et hoonts'i di ha Yak'usda ooghuni 'uk'unusgúz-i 'et ndutni ‘Yinka dune ye' dzoh nutízut 'ink'ez hits'o dilh'oh tileh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","'Et hoonts'i nohdúsni Elijah 'uda' whusaínya 'ink'ez dune nts'en'a hukwa' huninzun te, 'oh te né'huyulh'en. 'Et Yak'usda be 'udustl'us k'ut whuz un'a 'uk'unúwhusguz ínle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","'Et la Sizi 'onghunne yugha hodul'ehne butananja whe, dune bughu 'ilhozdil 'et ubunilh'en 'ink'ez whulohne Moses be 'udustl'us 'uk'ununáguzne yugha hodul'ehne budulhyo 'uhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","'Ilhozdílne Sizi hitilh'en ibulh buba hooncha whe hidudílhghaz 'ink'ez, “Hadih,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","'Et Sizi Moses be 'udustl'us 'uk'ununáguzne uboodulhkut, “Di ghun budulhyoh 'udahni?” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Ilhozdílne 'ilhoghun dune butahaínya, “Nehodulh'eh-un sye' ntsi'-i nudúdeh-i ooyudínda 'et huwa 'aw yaoolhduk aít'oh 'inka nts'o whúsasya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Et ndet la ndi ntsi'-i ooyédinda 'i gha ooba hoolhtus de, 'et yun nadúldus, huwus ooza hanúldoh, dughoo lhúduk'us, 'ink'ez lhts'edunukw. Ngha hodul'ehne ntsi'-i nudúdeh-i hiyáhanahinooyoot, ubudúsni 'et hoonts'i 'aw 'uhuyooleh aít'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","'Ink'ez Sizi 'uyúlhni, “'Aw nohni dune nohba 'alha' hot'e' aít'oh! Dáwhuldzoh nohzih tisdalh? Dawhuldzoh nohtoh tisdalh sudutáhts'o whuts'un 'ink'ez nohba 'alha' tist'elh? Ts'oodun ndiz sts'u túlhtih!” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'Inka highu hinílhti. 'Et ndi ntsi'-i nududeh-i yuyudínda-un Sizi yutilh'en ibulh, 'ahoh ts'oodun ookaootizut 'ink'ez nadílduz, 'ink'ez huwus ooza hanuldoh whe núkallhoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","'Et Sizi oobá yoodulhkut, “Dáwhuldzoh ndun ts'oodun 'et dunt'oh?” yúlhni. “Ntsool da' whuts'un,” ní oobá. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Lhat whe ts'oodun yuzoolhghelh hukwa' yulh'en. Too be cha yuzoolhghelh hukwa' yulh'en 'ink'ez tsídunoh cha' yulh'en. Soo' tanelh de, negha té'ninzeh 'ink'ez nela 'ineh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“A,” yúlhni, “Soo 'úlcho 'i be be 'alha' hoont'oh int'i de, mbene la be 'alha' hoont'oh ut'íne ts'iyantsuk ne'hutit'en-un buba huwa lhótilhna'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","'Ahoh oobá oonatsultoo' hoonli whe 'utni, “SMoodihti be 'alha' hoont'oh 'ust'i, 'et hoonts'i 'aw soo lhé'uztus. 'Et huwa sla 'ineh, 'on nus 'ultus-i be 'alha' hoont'oh-i oost'e' ha, 'et hukwa' nuszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","'Et Sizi whutilh'en 'ilhozdílne 'awet bughá holhghaz whe 'ahoh khuni ulhtus-i be ntsi'-i nudúdeh-i hukwa' yudáni', “Ntsi'-i nudúdeh-i lhe'hudústs'o 'ink'ez yalhuhulhduk 'ilh'í-un, ndun ts'oodun ooyáhanaindaih nyudúsni, 'ink'ez doo cha 'on 'at ooyunádondzit junih!” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","'Et ntsi'-i nudúdeh-i ndun ts'oodun yukaootilhdzut, 'ink'ez tube cho yudalhtlut, 'alhdzul, 'ink'ez yuyáhanaja. Nyoon ts'oodun 'ants'i dazsai 'et ndúja. 'Et huwa lhane, “Dazsai whe 'unt'oh,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","'Et hoonts'i Sizi ts'oodun yula ílhchoot 'ink'ez ndo 'úyinla. 'Et ts'oodun dich'oh dunadija. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","'Et hukw'elh'az Sizi yoh danínya whe yugha hodul'ehne whu'iz huyoodulhkut, “'Et dáhoont'oh huwa wheni ntsi'-i nudúdeh-i 'aw oots'u hanáts'inooyoot ait'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","'Et Sizi 'ubúlhni, “Mbene la tenadudline, 'ink'ez soo hóonihne, 'aw 'enne za ntsi'-i nudúdeh-i ndi k'un'a 'unt'oh-i nahuyuntuyukw.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","'Et 'awet keyoh whuch'a nahusdil 'ink'ez 'et keyoh Galilee huwhútni-un 'oh whuya lhunáhusdil. Sizi nts'e la whénya ts'e dune t'éoonózin hukwa lhe'nízun, ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","yugha hodul'ehne hubodulh'eh 'et huwa. 'Ink'ez 'ubúlhni, “Yinka dune ye', 'uyoonne dune tl'ahitilhtelh 'ink'ez hituzilhghelh. Hizilhghi hukw'elh'az whulh tat dzin 'et dunadutádalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","'Aw daja ni whe 'utni t'ehonuszun 'ink'ez huyé nuljut 'aw huyoodolhkut aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","'Et keyoh Capernaum huwhútni ts'e whuz nahóosdil. Yoh danáhandil whe 'et Sizi yugha hodul'ehne uboodulhkut, “Ndanit ti ts'idulh whe, di za ghu yalhduk whe dahni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ti 'et lhdulhyo 'uhutni, “Mbe suba netoh 'uk'enus dune uncha-un unli?” Daja hutni-un hukwayá hinli 'et huwa t'ehudusni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sizi nátl'adida' ndunne whunizyane 'on 'at nane yugha hodul'ehne, “'Anih,” 'ubudáni' 'ink'ez 'ubúlhni, “Mbene la 'uk'enus dune uncha-un tileh hukwa' ninzun de, 'en 'udek'oh oole' huba' hoont'oh, 'ink'ez ts'iyanne natné'tit'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","'Et Sizi 'ilhoghun ts'oodunyaz yílhchoot 'ink'ez bubut nénilhya 'ink'ez yunasúni whe 'ubúlhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mbe la si sgha ndun ts'oodun dult'óh-un danílhti de, si dasúnilhti 'et za hoont'oh, 'ink'ez mbe la dasúnilhti-un, si za iloh dasútalhtelh. Mbe la sutílh'a'-un, 'en cha dahinilhti whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","'Et John 'uyúlhni, “Nehodulh'eh-un, 'ilhoghun dune nyoozi' be ntsi'-i nudúdeh-i dune buts'u hanaídulhdoh, 'en uznilh'en. ‘'Etsul ooneh ts'utni,’ 'aw nebulh lhe'ust'en 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sizi 'ubúlhni, “'Aw whuch'a nahyoot iloh, mbe la soozi' gha huwa 'ít'en 'uwhulh'en-un, 'en 'aw hukw'elh'az de dzoh k'un'a sghu yaoolhduk aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mbene la nech'az úlhditnine, 'enne wheni nets'ó ditni whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","'Ink'ez 'utni, “Njan whunalhnih, nohni Christ ooch'e'ne ahli huwa dune too hoonts'i nohgha nílhdzo de, 'enne Yak'usda buba k'elha whutilhtselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“'Et la 'ilhoghun ts'oodun ooba 'alha' 'ust'oh de, 'ink'ez 'ilhoghun dune lubeshi be sch'a itálhtelh de, ndun dune ts'oodun tank'us un'a wheyúntilhtun 'et whutso huyúlh tatse oolh'is 'on nus soo hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Et nla 'i gha lubeshi inla de, nla k'unint'as! 'Et nla k'uz za int'i whe yak'uz whénya de whuz 'ilhiz hutanalh, 'et 'uk'enus mba hootázoo'. 'Et lhch'az nla bulh kwuncho yo ts'e whénya de 'uk'enus mba hootátsi', whuz kwun nalhnusne whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Whuz 'ilhiz wheni dune dzoh notizut 'ink'ez buyust'e 'usgo yuti'ulh, 'et whuz 'usgo 'aw yalhitásdla 'ink'ez kwun nalhnusnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Et nke 'i gha lubeshi inla de, nke k'unint'as! 'Et nke k'uz za int'i whe yak'uz whénya de whuz 'ilhiz khutanalh, 'uk'enus mba hootázoo'. 'Et lhch'az nke bulh kwuncho yo ts'e whénya de 'uk'enus mba hootátsi', whuz kwun nalhnusne whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","'Et 'ilhiz wheni dune dzoh notizut 'ink'ez buyust'e 'usgo yuti'ulh 'et whuz 'usgo 'aw yalhitásdla 'ink'ez kwun nalhnusnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Et nyuna 'i gha lubeshi inla de, hanín'aih! 'Et nyuna k'uz za int'i whe Yak'usda ook'úne' whut'en-un whénya de, 'et 'uk'enus mba hootázoo'. 'Et lhch'az nyuna bulh kwuncho yo ts'e whényuhano de, 'uk'enus mba hootátsi', whuz kwun nalhnusnoh whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","'Et 'ilhiz wheni dune dzoh notizut 'ink'ez buyust'e 'usgo yuti'ulh 'et whuz 'usgo 'aw yalhitásdla 'ink'ez kwun nalhnusnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Lizwifne Yak'usda ts'un khuna-i hudílhk'un whe 'udechoo lisel hik'unúdzih. 'Et whuz un'a ts'iyanne dzoh nutizut whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lisel unzoo whe 'unt'oh, 'et hooonts'i lisel oonalhuwhúlhni 'ulhih te, nts'en'a doo cha lisel oonawhúlnih uztílhtselh? Whuz un'a nohdzi ootsi' junih 'ink'ez nyulh dune ts'un nohdzi dóghel.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","'Et Sizi whuch'a nasja 'ink'ez Judea 'oho nenínya 'et 'ukoh Jordan huwhútni-un, 'et yanínya. 'Et lhane dune yugha óozdil. 'Et whutso da' datni la 'ahoolhyiz whuz un'a doo cha za hubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","'Et whulohne Phariseene highu nindil 'ink'ez huyóolhdzih whe huyoodulhkut, “Nedíni dune, 'enne eh bughá whunt'ai du'at lahudootnih ha?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","'Et Sizi 'utni, “Daja ni whe Moses khuni nohtl'aídan'ai inle'-i?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","'Et 'uhuyúlhni, “Moses bugha óonin'ai dune 'udustl'us 'uk'unéyuzguz-i, 'i be du'at duch'a nayólhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","'Et Sizi 'ubúlhni, “Stabe nohdzih duts'un 'et huwa ndi khuni Moses nohba 'uk'eyánguz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","'Et hoonts'i 'udechoo Yak'usda ts'iyaitsuk inla whe dune cha 'ink'ez ts'eke cha inla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","'Et la njan huwa dune dubá 'ink'ez duloo bulh buch'a óoya', 'ink'ez du'at 'en za zih ooda'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","'Et la nuhult'oh 'ilho hutileh, 'et 'on 'un whe nane lhuhíloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mbe la Yak'usda lhghá buninlane, 'enne 'aw dune lhch'a nabohólelh huba lhe'hóot'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","'Et yoh danáhandil whe yugha hodul'ehne Sizi njan dáhoont'oh la 'et hukwa huyoodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","'Et 'ubúlhni, “Dune mbe la du'at 'úntizno 'ink'ez 'uyoon ts'eke ghu nasda de, 'en 'uyoon ts'eke bulh ninta' tit'elh whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","'Et whuz un'a za ts'eke duki 'úntizno 'ink'ez 'uyoon dune ghu nasda de, 'en cha 'uyoon dune ninta' tit'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Whulohne dune ts'oodunne Sizi ts'un ubúhoozdla buk'udólni ha, 'et yugha hodul'ehne nyoonne ts'oodunne whusaínlane hukwa' bodáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","'Et Sizi whunalh'en whe hunílch'e 'ink'ez yugha hodul'ehne 'ubúlhni, “Whute ts'oodunne sts'ó toodilh. Khun te dah budóhni' junih. Mbene la Yak'usda whe lerwe unli-un whuz dilhts'ine, 'enne ndunne ts'oodunneyaz ubunduhúlt'oh whe' hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Soo ts'ih'un 'alha' nohdúsni, ndet la Yak'usda whulerwe unli ts'e, mbene la Yak'usda bulerwe unli-un 'aw ts'oodunneyaz k'un'a lhuhuhóolhchulh de, ndunne 'aw whuz dahóoya' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","'Et ts'oodunne ts'iyawh bunasuni 'ink'ez 'ilhone hinli whe buk'událni 'ink'ez buba tenadidli. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","'Et Sizi doo cha za natísja whe dune yududílhgai 'ink'ez yubut dugwutsi be nenínya 'ink'ez yoodalhkut, “Dune hodulh'eh-un unzoo-un, nts'en'a dast'en whe 'ilhiz khutisnalh-un whuch'a ootásdoh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","'Et Sizi yúlhni, “Di ha sudíni, unzóo-un sudíni? 'Aw 'ilhoghun unzoo-un hooloh. Yak'usda 'aw 'en za unzoo whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ndi khuni Yak'usda nohtl'aídan'ai-i 'et t'eninzun: nezolhghelh junih, dune k'us ts'eke bulh ninta' 'ont'en junih, 'undunont'ih junih, honts'it junih, 'e'holhts'it junih, 'ink'ez mbá cha nloo cha hubudólhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","'Et dune 'utni, “Nehodulh'eh-un ndet la chilh usdli da' whuts'un, ndi khuni ts'iyawh ook'úne' zust'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","'Et Sizi soo yuk'entsi' whe yunalh'en 'ink'ez 'uyúlhni, “'Ilhoghun za whuyit 'int'oh, inyalh 'ink'ez ndai la int'i-i ts'iyawh be 'óonket 'ink'ez sooneya tel'enne gha níndzaih, tulalhgus ilhchoot 'ink'ez 'anih, se' 'ut'en k'oh tune' ónt'en ha sunanyalh. 'Et de ndo yak'uz hoonzoo-un, 'et whuch'a ootálhdoh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","'Et ndun dune ndi khuni whudánts'o whe ni suli', 'ink'ez ts'odi unli whe yughu natisja tube hoonzoo' 'unt'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sizi yugha hodul'ehne bunilh'en 'ink'ez 'ubulhni, “Dáhoont'oh la huwa whúlna' whe ndunne hoonzoo' 'unt'ohne, 'enne Yak'usda whe lerwe unli-un, 'et dahútidulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","'Et yugha hodul'ehne ndi khuni hudánts'o whe buba hooncha. 'Et Sizi whuz hiyilh whe ndutni, “Suzkehke dahoont'oh la huwa whúlna' whe 'enne duzooneya hit'az 'unt'ohne Yak'usda whe lerwe unli-un, 'et dahútidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Dant'oh la khuna-i cho, camel huyúlhni-i, 'aw 'ughabátsulh 'aw yukaóolget ait'oh. 'Et whuz un'a dune hoonzoo' 'unt'oh-un, 'on nus ooba huwa whúlna Yak'usda whe lerwe unli-un datíyalh huba.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","'Et yugha hodul'ehne tube buba hooncha 'ink'ez lhoohoodulkut, “Mbe suba doojih?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","'Et Sizi ubunalh'en 'ink'ez 'ubúlhni, “Njan 'et dune ba 'uhóneh aít'oh, 'et hoonts'i Yak'usda ba ts'iyantsuk huwa lhúhoonlna' whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","'Et Peter yatílhduk, “Soo cho whunilh'en, ts'iyaitsuk oolazditni 'ink'ez nyuts'un tizdil.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","'Et Sizi 'ubúlhni, “A, ts'ih'un nohdúsni, mbe la duyoh huwu tizya-un 'ink'ez dulhutsinke, k'us dulhtuske, duloo, dubá, du'at, duzkehke, k'us duyun k'ut te, si sgha 'ink'ez ndi khuni unzoo-i k'uz ts'iyantsuk whuladitni de, 'ink'ez suntizya de, nus de 'on nus ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lhai únli whe ootl'anaítikulh: yoh 'ink'ez bulhutsinke, bulhtuske, ooloo, buzkehke, 'ink'ez ooyun k'ut cha 'ink'ez dune huye túzilalh cha 'et nus de 'ilhiz hutinalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","'Et hoonts'i lhane 'udechoo 'unt'ohne 'udek'ez hutileh, 'ink'ez lhane mbene la 'udek'ez unline, 'enne 'udechoo hutileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Et 'awet Jerusalem ts'u ti hidulh Sizi 'en yugha hodul'ehne butso uyalh whe 'enne bugha 'únjaz, 'ink'ez hidulh whe hunílhjoot. 'Et doo cha Sizi yugha hodul'ehne whunizyane 'on 'at nane 'udun nébuninla 'ink'ez nus de bulh daóotanelh-un, 'et huwun bubulh yálhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Soo zúlhts'ai, Jerusalem ts'uztidulh 'ink'ez yinka dune ye', 'en Lizwif lubret moodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'enne butl'aihítilhtelh. 'Et datítsa wheni hiba nahutiyeh 'ink'ez ndunne 'udun yun k'ut whut'enne, 'enne butl'aihítilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","'Et 'enne highu tidloh, highu dútazoh, huyootálhtsus 'ink'ez hituzilhghelh. 'Et tat dzin inle' de, dunadutádalh,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","'Et James 'ink'ez John bulh Zebedee ooye'ke Sizi highu nin'az 'ink'ez huyoodulhkut, “Nehodul'éh-un ndai nts'o ookwa' ts'utni-i, 'et neba whutanlelh hukwa' uzninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sizi uboodulhkut, “Ndet nohba 'uwhutisdlelh hukwa' nahzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","'Et 'uhutni, “Ndet la yak'uz 'uk'enus dínti' ts'e sinda de, nzih tákelh 'et hukwa' nítzun, 'ilhoghun 'en nailhni ts'e 'ink'ez 'ilhoghun 'en 'intl'us ts'e 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","'Et Sizi 'ubúlhni, “Ndet sts'u hukwa' dahni 'aw t'éoonuzúhzun k'us ndi lubot be tísnelh-i soo tilah oohnai' 'ink'ez nts'en'a la too bé' uzya soo tilah whuz un'a too be' óolhneh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Soo la 'uts'ooneh,” huyúlhni. 'Et Sizi 'ubúlhni, “Ndai la lubot be tisnelh-i nohni cha tíhtnelh whe' 'unt'oh. 'Ink'ez too bé' uzya whuz un'a nohni cha too bé' tilhnelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","'Et hoonts'i mbe la nailhni ts'e sghu tidalh, 'ink'ez 'intl'us ts'e sghu tidalh, 'aw si huwá hos'alh ait'oh, mbene la buba lhawhúdulyane, 'enne buba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","'Et la 'on 'unne whunizyane yugha hodul'ehne, 'enne la James 'ink'ez John bulh bubulh hónilch'e. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","'Inka Sizi soo ts'iyawh, “'Anih,” hubudáni' 'ink'ez 'ubúlhni, “'Et t'eoonáhzun 'udun yun k'ut whut'enne butoh, mbene la dune tso whudilhdzulh unlíne, 'enne dune buk'ut moodih hinli. 'Ink'ez mbene la bumoodih unline, 'enne cha bumoodih hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","'Et hoonts'i 'aw whuz un'a iloh nohni aht'oh. 'Ilhoghun nohtoh dune uncha-un tileh hukwa' ninzun de, 'on 'awhne buba ne'út'en-un cha oole' whuba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","'Et nohtoh 'ilhoghun 'udetso tileh hukwa' ninzun de ts'iyanne e'ulhna oole' huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yinka dune ye', 'en hoonts'i 'aw ba né'whutit'en huba whusálhiyal 'et huwa. Dune buba né'tit'en 'ink'ez dune buba datítsa 'et whe dune ts'iyawh nabootakulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jericho ts'e hoozdil whe Sizi yugha hodul'ehne tubulh nahutisdil whe, lhane 'ilhozdílne cha 'ut'en. Dune hoos̱'en-un Bartimaeus huyúlhni-un, Timaeus ooye', 'en ti whuzih usda datso whe whudánts'o, ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Sizi Nazareth whut'en-un 'óh whuya uyalh. 'Ahoh hazulh whe 'utni, “Sizi David oots'u hainzut-un sgha té'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lhane t'edoosnih huyulhni 'ink'ez whuch'a híniyoot. 'Et hoonts'i 'on nus 'aldzul whe 'utni, “Sizi David oots'u hainzut-un sgha té'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Sizi lhgha nenínya 'ink'ez, “'Anih dúhni,” 'ubúlhni. 'Et dune hoos̱'en-un hika huyih, “Hoonínt'i 'ink'ez dudinyaih, 'anih nyúlhni,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Duluglok ts'ahayít'oh, dudillhoh, 'ink'ez Sizi yuts'óozya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","“'Et dányutisdlelh 'et sts'u hukwa' ninzun?” ni whe Sizi yoodulhkut. “Nehodulh'eh-un doo cha hoo'en-un, 'et sgha holts'it,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Naindalh, si sts'un be 'alha' hoont'oh-i, 'i be soo ná'inja,” yúlhni. 'Et 'ahoh dune hoo'en nasdli' 'ink'ez Sizi ti yuntizya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","'Awet Jerusalem whénghun hidulh whe nat-un keyoh Bethphage 'ink'ez Bethany whulh 'et la shus Olive be hóodzi-un, 'et whuz nehúnindil. 'Et Sizi nane yugha hodul'ehne whébalh'a' whe 'ubúlhni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Keyoh whuyaz nohda ts'e whuz'ai-un whuz ah'us. Whuz oozah'az, yeztliyaz, donkey huyúlhni, whutso da' dune yak'ulhídoh-i, 'et whédint'i, 'i k'unaooh'uk 'ink'ez sts'u toolhdlooh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Dune, ‘Di ha 'et ndaht'en?’ nohúlhni de, ‘NeMoodihti yuka' ninzun’ doohtni'. 'Ahoh la nohtlayoolhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","'Et whehán'az 'ink'ez keyoh 'et yeztliyaz nahuyilhti 'ilhoghun yoh dati 'et whédint'i. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","K'unáhúyú'uk whe 'et núdilhne hubuhoodulhkut, “'Et daht'en whe aht'en yeztliyaz k'unah'uk?” hubuhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","'Et Sizi buba náhizye' k'un'a ubuhútni 'et 'ants'i t'ehudínel 'ink'ez bula huditni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'Et Sizi yeztliyaz highu hinílhti whe whulohne duluglok hiba hik'élhbal 'ink'ez Sizi yuk'étl'adida'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Lhane dune cha duluglok ti 'et hinulhbulh. Whulohne cha 'ul k'us 'ut'an k'unuhídut'as-i, 'i ti nahídulhdilh Sizi yuk'ut lhutíyalh 'et wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mbene la dune Sizi hitso udulhne 'ink'ez hik'oh údulhne ts'iyawh húzulh whe 'uhutni, “Yak'usda ba whudílhti'! NeMoodihti boozi' gha whusaínya-un, 'en 'uk'enus hoonzoo-un ooghá whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Netsoda'-un David oolerwe keyoh 'et dúhoont'oh-un cha za whusawhútilts'ulh 'inka Yak'usda ba ts'odólhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","'Et 'awet Sizi Jerusalem keyoh neninya whe Lizwif bulugliz whucho ts'e danínya 'ink'ez dulcho núyuz'en. 'Awet náwhendunilhghel 'et huwa Bethany huwhútni-un ts'e whuz whunizyane 'on 'at nane yugha hodul'ehne whuz bubulh wheín'az. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","'Om bun Bethany ts'e whuz de náhidulh whe 'et la Sizi ooye'ílts'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nilhdza' 'et la mai cho chun nílh'en oot'an cha hoonli. 'Et la yughu nínya mai ntálhchulh ha. Yughu ninya whe 'ut'an za 'unt'oh 'awhuz oomai' hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","'Et la Sizi ndi mai chun 'uyúlhni, “'Aw 'on 'at dune nyumai' hoo'alh aít'oh!” 'Et ndutni whe yugha hodul'ehne hidánts'o. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","'Et la Jerusalem ts'e hoozdil. Sizi Lizwif bulugliz whucho 'et daninya. Mbene la 'e'óoketne 'ink'ez 'ooketne ts'iyawh tenábuninyoot. Sooneya lhk'enádudzaihne buludab cha náneniz'ai, 'ink'ez dut'ai be 'óoketne cha, ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","'aw lugliz hoonli nuhóole' hukwa lhe'nizun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","'Ink'ez Sizi dune whubodulh'eh whe 'ubúlhni, “Yak'usda be 'udustl'us k'ut 'uk'uwhusguz, ‘Njan syoh ts'iyanne tenadudli bayoh 'úhoont'oh,’ ni. 'Et 'uwhúhla undunut'íhne 'ink'ez nanúl'i'ne bayoh whuzúlhtsi!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","'Et lubret moodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne hodánts'o whe hizoolhghelh-un hukónuta tube huyé nilhjoot ts'iyanne 'ilhozdílne hubodulh'eh buba hooncha 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Soo nadálhghel ibulh Sizi yugha hodul'ehne bubulh Jerusalem whuch'a nahusdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","'Om bun bundada' 'uda' 'et la ti hidulh whe nyoo mai cho chun hinilh'en. Soo ts'ih'un ooghih tubulh ats'o disuz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter 'en la whunalni whe Sizi bulh yátilhduk, “Nehodulh'eh-un nilh'en nyoo mai cho chun bulh ookw'ehanya disuz,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","'Et Sizi 'ubúlhni, “Njan whunaoolhnih, Yak'usda nohba 'alha' 'unt'oh de, ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ndi shusyaz 'i la' dóhni', ‘Dudilts'it 'ink'ez bunghun whucho ts'e tailts'it.’ 'Et soo nohdzi yo whe 'aw nawh lhe'hoot'oh de 'ink'ez nohba 'alha' hoont'oh de, dawhútanelh dahni, ts'iyawh nohba 'edótanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","'Et huwa' nohdúsni, be 'alha' hoont'oh-i be tenadahdli de, 'ink'ez hoonli ha' dahni te 'alha' nahzun whe nohgha tíkulh nahzun de, ndai la ooka' dahni-i nohgha tíkulh whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","'Et sahyin whe tenadahdli de, 'ink'ez 'uyoonne ts'un nohba dzoh de buba n'ún whutulhdilh 'et la nohBá, yak'uz úsda-un, 'en nohni cha nohlubeshi nohba 'un yutoolhdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","'Et 'uyoonne buba n'ún lhotulhdulh de, nohBá, yak'uz úsda-un, 'en 'aw nohlubeshi nohba 'un yutoolhdilh aít'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","'Et Jerusalem ts'e nahoosdil Sizi Lizwif bulugliz whucho nuya whe lubret moodihne, Moses be 'udustl'us 'uk'ununáguzne, 'ink'ez dune tso whudilhdzulhne, 'enne la Sizi highu nindil, ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","'ink'ez hiyoodulhkut, “Nedini ndai gha dune ando int'oh whe njan dint'en-un? Mbe nghá whunin'ai whe 'int'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","'Et la Sizi 'ubúlhni, “'Ilhoghun za hukwa nohoodutaskut. 'Et sudáhni de, 'et la nohdutasnelh ndai gha dune ando 'ust'oh whe nja dust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Sudáhni mbe John dune too be' 'ulh'en-un mbe yutl'ahón'ai whe dune too be 'úlh'en inle', Yak'usda tilah k'us dune tilah yugha óonin'ai?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","'Et 'ahoh didutch'oh dutoh hukw'u nahúhulhye' whe nja duhútni, “Daja cha uzdooni', ‘Yak'usda yugha óonin'ai,’ ts'utni de, 'et la dooni', ‘Di ha John nohba 'alha lhe'dusni?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","'Et, ‘Dune yugha óonin'ai ts'utni de,’” 'et nja dudune'ne be bé hunuljut huwa, ts'iyawh dune t'ehonínzun John dune too be 'ulh'en-un, 'en Yak'usda be nus hoo'en-un unli inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","'Et huwa Sizi huyúlhni, “'Aw t'ets'onúszun.” Sizi 'et 'ubúlhni, “Si cha mbe sghá whunin'ai-un 'aw nohdósni' aít'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","'Et 'awet Sizi huwa húhodool'eh-un huwun bubulh yálhduk, “'Ilhoghun dune, 'en la mai haníyeh-un, mai ts'ekoo too' lhih-i, 'ananla. Yuna'niztl'oo tsak'et hahónkaih mai tahawhúndunutnih-un huba, 'ink'ez la yutíst'en-un cha 'uhóonla. 'Et la dune bughu whulh'ai 'ink'ez la whenádija. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","'Et la 'awet mai oontajin néwhuninzut whe de 'ulhná-un 'ilhoghun 'en la mai haníyeh k'et butl'ahónlane buts'ú wheyalh'a', ndai la oonajin-i ooloh oots'itookat huba' hoont'oh-i, 'i ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","'Et la 'uhuyínla nyoonne mai k'et butl'ahónlane 'ulhna huyílhchoot yahúyalht'o 'ink'ez la hoonli highálhilel whe whenáhinanyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nyoon dune ooch'e'-un, 'en la doo cha 'uyoon 'ulhna whuz whelh'a'. 'En la tse be nahínilh'uz hitsi ts'e nalh'uz whe ka húyulhtsi, 'ink'ez hukwa yáhoonli k'un'a 'uhuyínla whe whenáhinanyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Doo cha la 'uyoon 'ulhna whuz whelh'a'. 'En la hizilhghi. Lhane 'uyoonne cha 'et ndúbuhinla whulohne ubuhoolht'ah 'ink'ez whulohne cha ubuhanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","'Ilhoghun za whuz yutilh'alh-un, 'et usda suli' duye' yuk'entsí'-un, 'en la 'udek'ez whuz buts'un wheyálh'a', ‘Sye', 'en la hidólhti',’ ni 'inka. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nyoonne dune mai k'et butl'ahónlane 'et la 'ulhodútni, ‘Ndun njan mai k'et ooch'e'-un, 'en ooye' 'únt'oh. 'Anih, ts'uzoolhghelh. 'Et la ndun ooye' oots'ítikulh-i ts'iyawh nech'e' oole'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'Inka ndun ooye' huyílhchoot, hizílhghi 'ink'ez hizi 'i la nyo haníyeh k'et tenáhinino.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","'Et Sizi uboodulhkut, “Daóoneh suba ndun mai k'et whulh'aí-un? Whusanája, 'ink'ez la ndunne dune ts'iyawh hubooghan, 'ink'ez la mai k'et 'uyoonne ghu hólh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","'Aw whutsoda' ndi Yak'usda ooghuni 'uk'unusgúz-i 'aw eh ook'uyálhuzulhduk? 'Et ndutni, ‘Ndi tse yoh 'uwhulh'énne 'ún hidutilh'uz-i, 'i la 'uja 'uk'enus ookadáhotni-i suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","'Et la Moodihti whuz un'a 'uhóonla. Tube buba hooncha k'un'a ubínla, whe' hoont'oh.’ 'Et whuz un'a Yak'usda be 'udustl'us k'ut ndutni,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Et Lizwif bumoodihne Sizi huyólhchoot hukwa' hut'en t'ehonínzun didut buch'az yálhduk whe dune hodalh'e', 'et hoonts'i dune 'ilhozdílne ehunuljut 'inka Sizi dalhúhuyilel whe whenáhidil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","'Et la whulohne Phariseene 'ink'ez Herod oodune'ne cha 'enne Sizi khuni be huyoolhgooh ha hits'ú whe bahalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","'Et Sizi highu nindil 'ink'ez 'uhutni, “Dune hodulh'éh-un t'ets'onínzun ts'ih'un za' danelh. 'Aw 'uyoonne daja huntizilh-un huwu ni lhínlo whe dune dant'óhne hoonts'i lhubunílh'en whe Yak'usda beni k'oh ts'e huwun khuni 'alha' 'unt'oh-i be whúbodilh'eh. 'Et nedíni wheni khuni netl'ahon'ai-i, 'i whudulhyoh 'uts'oot'en eh tilah Roman keyoh whumoodih oots'un yun k'elha ts'uhoolh'i buba ook'elha ts'uholh'e' tilah k'us 'awundooh tilah?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","'Et hoonts'i Sizi huyoolhgooh hukwa' huyulh'en t'eoonanzin, 'ink'ez 'ubulhni, “'Et di ha sóolhdzih? Sooneya stl'ah'aih noos'en si,” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'Ahoh 'ilhoghun sooneya yutl'aín'ai. 'Et Sizi uboodulhkut, “Mbe whe' 'unt'oh oonin 'ink'ez boozi' ook'usguz?” 'Et 'uhuyúlhni, “Keyoh whumoodih Caesar huyúlhni-un, 'en 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","'Et Sizi 'ubúlhni, “Ndai la Caesar ooch'e'-i oots'un ook'elha whulh'i, 'ink'ez ndai la Yak'usda ooch'e'-i, Yak'usda ts'un ook'elha whulh'i.” 'Et soo tube buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","'Awet Sadducee ubuhútnine, 'enne la Sizi highu nindil. 'Enne la 'uhutni, “Dats'úzsai 'ink'ez 'aw nats'ukhótnah aít'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","'Enne huyoodulhkut whe 'uhutni, “Nehodulh'eh-un Moses 'en khuni higha néilh'ai-i neba 'uk'unéyuzguz, ‘Dune oo'at hoonli-un dazsai de, 'ink'ez buzkeh hooloh de, ndun dune dazsaí-un bulhutsin 'en la ndun tsandilh yughu nooda' ndun dune dazsaí-un, 'en ba buzkeh hole' ha.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","'Ilhoh 'et la lhtak'ant'ine lhulhutsinke hónle', 'udetso whudilhdzulh-un, 'en la 'at ut'i 'awhuz buzkeh hooloh whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'Et la yuk'oh whúdilhdzulh-un, 'en tsandilh doo cha yughu nasda. 'En cha buzkeh hooloh whe dazsai. 'Et whulh tat-un cha la whuz un'a za 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ts'iyawh lhtak'ant'ine lhodunildzulhne whe highu dálts'i', ts'iyawh bubuzkeh hooloh whe yahádla. 'Udek'ez ndun ts'eke dich'oh cha dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Mbene la yaidláne ts'iyawh dunazdutádulh dzin dunahudidil de, k'us mbe suba oo'at tileh, ts'iyawh lhtak'ant'ine 'uhultsuk highu dálts'i'?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","'Et Sizi buts'u yátilhduk, “Tube 'uts'un un'a 'uduhni. Ndet huwa' dahni t'eoonuzáhzun eh? Yak'usda ye ulhtus-i 'ink'ez ooghuni k'eguz-i t'énuzuhzun, 'et huwa whuz un'a 'uduhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ndet la yaidlánne dunahudidil de, ndo yak'uz lizas le'hint'oh. 'Et ndó tit'elh dune cha 'ink'ez ts'ekoo cha 'aw lhgho dólts'i' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Ink'ez ndunne yaidlánne dunáhudutádulh huwun, ndi Moses 'uk'unéyuzguz-i 'aw eh ook'uyalhúlhdih whus dilhtán-i toh whudizk'un whe Yak'usda yulh yalhduk inle'? 'Et 'uk'unusgúz-i ndutni ndun Moses Yak'usda ndéyulhni, ‘Si 'ust'oh Abraham 'en ooMoodihti 'ust'oh, Isaac cha ooMoodihti 'ust'oh, 'ink'ez Jacob cha ooMoodihti 'ust'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","'Et huwa khunane buYakusda 'unt'oh, 'aw yaidlánne buYak'usda iloh whe 'unt'oh. 'Et 'uts'un un'a gaih 'udahni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Moses be 'udustl'us 'uk'ununáguz-un, 'en la 'et 'ut'en, 'ink'ez ubudánts'o 'ink'ez 'en t'éoonínzun la Sizi Sadduceene soo 'ubudáni'. 'Inka la didut cha Sizi yoodulhkut, “K'us ndai khuni neba yutulhúhizye'-i k'us dízti'?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","'Et Sizi uyúlhni, “Ndi 'uk'enus dízti'-i, ‘Israel oodune'ne, oozúlhts'ai, neMoodihti 'en Yak'usda unli. 'En za 'ilhoghun Moodihti 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yak'usda nyuMoodihti ndzi ndulcho-i be cha, nzul ndulcho-i be cha, nyeni ts'iyawh ndulcho whe cha.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Bulh nanki khuni higha néulh'a-i 'uk'enus dizti'-i, ‘Nts'en'a la nyunch'oh k'enaintsi', whuz un'a nyulh dune cha buk'eoontsi'.’ 'Aw 'uyoo khuni higha néulh'ai-i ndi nanki ba nus yudízti'-i hooloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","'Et Moses ooghuni 'uk'unéyuzguz-un, 'en Sizi 'ulhni, “Nehodulh'eh-un soo' dinja! Khuni 'alha' 'unt'oh-i be yailhduk! 'Udédoh Moodihti 'en za Yak'usda unli, 'aw 'uyoonne Yak'usda lhíloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","'Ink'ez dune dudzi ndulcho 'i be Yak'usda k'eootsi' huba' hoont'oh, dudeni ts'iyawh 'i be cha, duzul be cha, oonut'i ts'iyawh whe cha 'ink'ez dich'oh k'enatsi' whuz un'a dulh dunene buk'eootsi'. 'Et 'uk'enus neba hooncha ndi nanki khuni higha néulh'ai-i ook'úne' ts'oot'en. Khuna-i 'ink'ez 'uyoo hoonliyaz loodel k'ut Yak'usda gha dizk'un, 'i ba nus whudízti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sizi t'éoonanzin dalcho 'i be whunih k'un'a 'udíja 'et 'uyúlhni, “'Awet nilhdukw Yak'usda k'úne' nyul'en-un tileh.” 'Et hukw'elh'az 'aw 'udun hukwa lhúhuyoodílhkulh huyéntsaz 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","'Et la Sizi Lizwif bulugliz whucho dune hodulh'eh whe huboodulhkut, “Nts'en'a Moses be 'udustl'us 'uk'ununáguzne, ‘Christ 'en David oots'u hainzut-un tileh whe 'unt'oh,’ hutni? ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","'Et la David Ndoni 'i gha la 'et dutni, ‘Moodihti 'en sMoodihti 'úyulhni njan nailhni ts'unghus sinda. 'Oh de la nch'az ditnine buk'ut nke naóolhyis mba ubooselh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","David dich'oh, ‘Smoodihti,’ yúlhni, 'et nts'en'a Christ 'en David ts'u haínzut-un oole'?” 'Ants'i 'oh dunene huhoont'i' whe hidants'o ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","'Et Sizi hubodulh'eh whe 'et 'ubúlhni, “Moses be 'udustl'us 'uk'ununáguzne, 'enne buch'a kháhdli. 'Enne e'óoket-un dune toh nahúchun tl'asus yiz be húdilhts'i, 'ink'ez dune ubudólhti'-un hukwa húdúdúl'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Njan lugliz ndet la huntil'elh-un, 'et 'utahaoodit'aih, 'ink'ez dune dahúlih te, 'et cha k'us whúdizti'-un, 'et didut nátl'ahududaih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Tsandilh cha khábonit'oh, 'ink'ez buyoh bugha hawhúhut'aih. 'Ink'ez ncha ná'hadudil'i whe sa' cho tenahududli. 'Enne 'et hukw'elha 'on nus dzoh notizut whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Lizwif bulugliz whucho sooneya dekat-un, 'et la Sizi usda, 'ink'ez ubunilh'en sooneya dehúle. Lhane hoonzoo' 'unt'ohne, 'enne la sooneya lhai whe dehúya'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","'Et la 'ilhoghun tsandilh tel'en-un, 'en la 'óh whuya uyalh, 'ink'ez nanki sooneyayaz dénalhdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","'Et la Sizi yugha hodul'ehne ts'un bé' buntilhni 'ink'ez 'ubúlhni, “Nohdúsni ndun tsandilh tel'en-un, ndunne ts'iyawh buba nus lhai 'i deyán'ai whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ndunne 'uyoonne, 'enne ndai la huye hóonzoo' 'unt'oh-i, ujutukat-i, 'i 'uhuyulh'en dehúyule. 'Et ndun lhe'unt'oh tel'en ndai la 'aw 'i yut'i-i yuk'otinalh, 'i hoonts'i ts'iyawh deyán'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","'Et Sizi Lizwif bulugliz whucho tenánja whe 'ilhoghun yugha hodul'eh-un 'uyúlhni, “Nehodulh'eh-un whunilh'en, njan lugliz whucho 'et cha 'ink'ez tse cha 'ink'ez lhé'uldzoo' 'i be 'uhóolya.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","'Et Sizi 'utni, “Njan yoh whucho whuzdla whunilh'en eh? 'Aw 'ilho tse 'i hoonts'i lhk'ulhdutásdlal ts'iyawh nadúntijulh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","'Et 'awet Lizwif bulugliz whucho whanch'az shus Olive huyúlhni, 'i k'ut, 'et la Sizi usda. Peter, James, John, 'ink'ez Andrew te 'enne disoh Sizi huyoodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","'Et la huyúlhni, “Nedíni nkede 'uwhutánelh? 'Ink'ez nedíni ndet huwa t'ets'ontázin daóotanelh whe 'et neóotalts'ulh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sizi 'ubúlhni, “Huwuhli dune nanohnoo'ah junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Lhane dune whusahúdulh 'ink'ez soozi' gha 'uhudutinelh, ‘Christ 'ust'oh!’ 'Et nduhutni whe dune lhane nahunti'oh whe ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","nohgha 'óojas junih. Nilhdukw dune lhutigan whulhudahts'o de, 'ink'ez nilhdza' lhuhugan whulh 'údahts'o de, 'et ndo honeh huba' hoont'oh. 'Et hoonts'i 'awhuz whulatoh iloh whe' hoont'oh, 'awhuz 'udun cha whusawhútikulh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lhelhts'un keyoh whut'enne, 'enne lhch'az nehúdutadulh, 'ink'ez lhelhts'un lerwe be 'ustlénne, 'enne cha lhch'az nehúdutadulh. Ndulcho whe yun cha nótitnah, 'ink'ez dai cha whutáleh 'ink'ez ndulcho whe dune dzoh nulhotildeh. 'Et nduwhút'en suli' de, t'ewhuntáhzin 'on nus hooncha tune' whutit'en. 'Et dzoh nutideh-un 'andit whe' whudit'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nohnihch'oh cha huwohle'. Keyoh huwunline but nenóhotalelh 'ink'ez lugliz cha la nohoohootalht'oh. 'Et si sgha la mbene la moodihne 'ink'ez lerwene cha bubut nenóhotalelh whe, khuni unzoo-i be bubulh yaoolhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","'Ink'ez 'udechoo ndi yun k'ut ndulcho whe dune ts'iyawh khuni unzoo-i ghun bubulh yatiduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'Anóhuhanla 'ink'ez nahiyílh-un but nenóhnilhti de dája dutihnelh-un huwu ni oohle' junih 'ink'ez nohdzi dóghel. 'Et neóoninzut de, 'ants'i ndai la nohza dánkat, 'i be yaoolhduk. Ndoni ooghuni 'i be yatilhduk 'aw nohghuni be iloh 'udutihnelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Dune, 'enne dulhutsinke dahútitsah-un huwá botalelh. 'Et bubáke 'enne cha, duduzkeh 'et ndúbotilh'elh, 'ink'ez ts'oodunne, 'enne cha, dudusne buch'az náhulhya 'ink'ez dahátitsah-un huwá botalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Si sgha sunihdulh huwa ts'iyanne nohts'o dutitni. 'Et hoonts'i mbene la 'udek'ez whuts'un whulh nudalya'ne, 'aw 'enne za hudutijih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ndun 'uk'enus bé whunjut-un, 'aw ooba lhehóot'oh-un 'et usyin nulh'en de, (Ndi yuk'ú yalhdúkne soo cho noheni taóodolts'it. Daniel, Yak'usda be nus hóo'en-un, 'en la 'uda' húwu yailhduk ínle'). Judea dilhts'ine shus k'uz ts'e tse hutoolhdilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Dune duyoh bun k'ut usda de, 'aw duyoh ts'e nunátidalh 'ink'ez ndi ndai la duch'e' yutilelh-i nayitálhchulh 'et hoonts'i ooneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","'Ink'ez dune haníyeh k'et 'ut'en-un cha 'aw yoh ts'e duluglok hunaóoda' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dalcho 'i be whéwhunujut tileh, 'oh de ts'ekoo, yazba 'unt'ohne ba, 'ink'ez duzkeh e'ulht'úkwne cha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Njan dzoh nutihzut-un whuch'a ténadoohdli khit nohbe' honeh whuch'a. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","'Et la Yak'usda yun inla 'andit dzin whuts'un 'aw lhe'whúsne 'ink'ez 'aw 'et 'ulcho 'i be whutso da' hiye dzoh nulhuzut-i, 'i be dzoh notieh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","'Et hoonts'i Moodihti lhat dzin whe k'oh ná'hoonla. 'Et ndúlhinel de, 'aw 'ilhoghun hoonts'i doojih ait'oh. 'Et ndunne 'utahábanlane, 'enne bugha' hoonla 'oh de hoondukw whutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","'Et la 'oh de dune ndunóhohutni de, ‘Nulh'en njan Christ 'en njan usda!’ K'us, ‘Ngut usda!’ nohoútni de, khun te nohba 'alha' 'uhudooni' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","'Et hoonts'i ndunne Christ na'dudil'íne, 'ink'ez nus hóo'enne na'dudil'íne cha, 'enne lhane hutileh whe lhat te huwa 'ít'en 'ink'ez hooncha túne' hutit'en ndunne Yak'usda 'utáhabanlane, 'enne hoonts'i nahunoo'a hukwa hutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'Ahoolhyiz tse hóohli! Ts'iyantsuk whutso da' nohdásni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“'Et 'oh de dune dzoh nuhuzde, hukw'elh'az de, sa 'i cha dulhgus tileh, 'ink'ez 'ulhdzis ooza' cha 'aw be lhoohoost'en tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sum cha nántikulh 'ink'ez ndo yat be hóolhtus-i, 'i be nuhótitnah. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","'Oh de la yinka dune ye', 'en ndo kw'us toh bé whunujut ye ulhtus-i bulh 'ink'ez Yak'usda oots'u hayánduz-i, 'i be ndo be hóodutaltsilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'Ink'ez la dulizas 'enne butilh'alh nus de, n'az de, nooz de, 'ink'ez ndaz de, ndi yun k'ut ndulcho whe Yak'usda 'utahábanlane 'ilhúbuhootálelh 'et wheni.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ndi mai, fig huyulhni, ooduchun, 'i be nawhutnuk be whuts'odul'eh-i, soo ts'ih'un un'a cho bodulh'eh. Ndi 'i 'unt'oh, oozischum ulughih te, 'et 'awet oot'an whulih, 'i gha t'ewhunáhzun 'awet shin nilhdukw suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","'Et ndi whuz un'a nohdúsni né'whutit'en-un whunulh'en de, 'et la whuz un'a za t'eoonóhzin 'awet nilhdukw whe' whudutat'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Alha ts'ih'un un'a nohdusni, 'andit whudizulhne 'aw yalhihitásdla, 'et ndi dótanelh-un ts'iyawh 'et lhawhúdutanelh, 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yat 'ink'ez ndi yun k'ut cha gak whutaleh. 'Et hoonts'i ndi sghuni 'aw gak lhtisdleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“'Aw dune t'eoonúszun ndet dzin k'us nts'owhuya 'uhunit'oh-un, 'et whusaóotilts'ulh. 'Aw lizas yak'uz dilhts'íne k'us Yak'usda ooYe' cha t'ehonúszun, 'uBá dich'oh za t'eoonínzun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","'Ahoolhyiz huwahli 'ink'ez tenadahdli. 'Aw t'eoonuzúhzun nts'oh de whusaóotilts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'Et ndiz un'a 'uwhutánelh, 'ilhoghun dune duyoh huwu tizya 'ink'ez yuba 'ut'énne 'et nébuninla 'ilhone hinli whe dude 'ut'en 'uhoolh'en ha, 'ink'ez 'et dati ghunli-un 'uyúlhni, ‘Soo cho huwonle'!’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'Et whuz un'a nohdúsni, huwahli'! 'Et nts'oh de yoh humoodih whusanátidalh 'aw t'éoonuzúhzun, hulhgha tilah, tuzniz tilah, yukaihts'un tilah, k'us sa haín'ai de tilah. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Et huwa 'ahoolhyiz lhadáht'oh. 'Aw hukwa tse lhúwhuhlih 'ink'ez naníhtez de, nohche tilah nohmoodih nohghu naooja'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","'Et daja nohdúsni-un, 'et ts'iyanne cha budúsni, huwahli!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","'Awhuz nat dzin whuz'ai Lizwifne butus lhuseya-un whewhúnahulni 'ink'ez lhes lhuntíldoh-i ut'alh-un, whewhúnahulnih cha, 'et lubret moodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, Sizi yooyoh whútsul hikunúta hituzilhghelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","'Et 'uhutni, “Njan butus lhuséya-un, 'et whutoh iloh uts'ooleh doo ka la dunene lhtahohót'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","'Ilhoghun keyoh wheyaz Bethany huwhútni-un, 'et Simon ooka whulhjut ínle'-un, leprosy huyúlhni, ooyoh 'en Sizi yuzih usda. 'Et la na'ut'alh whe ts'eke k'unútsútjul dízti'-i tse bé hahoogaz-i be súlhdzo 'ink'ez oodé' duldze yi'alh whe danínya. Ndi 'i yayányuz 'ink'ez k'unutsútjul 'i Sizi yutsi k'eyilhdzo. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Whulohne dune hukwa hunílch'e 'ink'ez 'ulhodútni, “'Et di ha nyoo k'unutsútjul 'ants'et ninta' yulh'ih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Dizti' whe da' be 'óket 'ink'ez da' sooneya tel'enne gha húyodzaih,” 'ink'ez duyoh ts'e ts'eke tube cho hich'az yálhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Et Sizi 'ubúlhni, “Oots'áhalhozah'ai! Di ha teduhle? 'Ut'en unzóo-i sba inla whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","'Ahoolhyiz tel'enne nohnat whutáleh. Hukwá' nahzun de totsuk bula 'aht'en. 'Et si 'ahoolhyiz huba nohbulh lhé'tuzist'el whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","K'unuts'útjul-i syust'e yuk'éyilhdzo 'adutistelh wheni lhasúdinla. Ndun ts'eke 'aw 'on 'un ooneh ait'oh-un, 'et 'uhóonla whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Alha nohdusni ndi yun k'ut ndulcho whe ndi khuni unzoo-i nudútikat, ndun ts'eke ndet 'uhoonla-un, 'et hukw'u naootitnuk 'et whe dune yunatilnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Whunizyane 'on 'at nane yugha hodul'ehne, 'ilhoghun Judas Iscariot huyúlhni-un, 'en Lizwif bulubret bumoodih buts'ú whinya Sizi butl'aítilhtelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dája 'ubúlhni-un huhóont'i' 'ink'ez sooneya hits'óozi. 'Et Judas Sizi ye 'óotakulh-un, 'et hukwa itís'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","'Et 'udechoo dzin lhes lhuntíldoh-i nahut'úlh-un, 'et dzin 'usbaiyaz na'hitit'ulh-i naihizulghih, ndi 'usbaiyaz Lizwifne butus lhuséya-un huba 'unt'oh. 'Et Sizi yugha hodul'ehne 'uhuyúlhni, “Nts'e netalh'alh ndi natant'ulh-i, 'i mba lházdutileh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","'Et Sizi nane, 'enne whébalh'a' 'ink'ez 'ubúlhni, “Jerusalem ts'e ah'us 'ink'ez dune too na'á-un, 'en la nohdudóya'. Nts'e la yoh ts'ú tizya ts'e whuz bun tooh'as, ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'ink'ez yoh ooch'e'-un nja dúdohni', ‘Dune hodulh'éh-un nja dutni ndet la sgha hodul'ehne bulh butus lhuséya-un huwa na'uztit'úlh-un yoh negho tálh'alh eh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","'Et la dohyoh hooncha-un lháoodint'oh-un whunóhnoolhtun, 'et la naztit'úlh-i lhadóohleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Et 'awet yugha hodul'ehne Jerusalem ts'e whehán'az 'ink'ez Sizi soo daja ubulhni-un ts'iyawh whuz un'a nahoohóon'ai 'ink'ez butus luséya-un wheni lhahodinla. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","'Et hulhgha 'awet Sizi whunizyane 'on 'at nane te whusahándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","'Et na'hut'alh whe Sizi 'ubúlhni, “'Et njan dunóhdusni 'ilhoghun nohtoh sulh ná'ut'alh-un, 'en se'óotakulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","'Et yugha hodul'ehne budzi únduda whe 'ilhoghun hinli whe huyoodulhkut, “Si eh 'usudíni,” huyúlhni. 'Et 'uyoon cha ndutni, “Si eh 'usudíni?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","'Et Sizi 'ubúlhni, “'Et whunizyane 'on 'at nane njan netoh mbe la dules sulh tunayuz'ai-un, 'en 'utinelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ndi Yak'usda ooghuni 'uk'unusgúz-i 'et ndutni, ‘Yinka dune ye', 'en datítsa. 'Et ndun ye 'ónket-un, dalcho-i be ooba wheóonujut tileh.’ Ndun dune 'aw lhuhóolel de, 'et da' 'on nus soo' hot'e' oole'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","'Et na'hut'alh whe Sizi lhes yílhchoot yuba tenadidli 'ink'ez lhts'edanyuz. 'Et yugha hodul'ehne bugha íninla 'ink'ez 'ubúlhni, “Ndi ulhchoot, 'ink'ez ah'álh. Ndi syust'e 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","'Et lubot yílhchoot, 'ink'ez duBá “Músi,” yúlhni. Butl'ayánkai 'ink'ez ts'iyawh huyitnai'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","'Ink'ez 'ubúlhni, “Ndi 'i suzkai' 'unt'oh. Lhane buba nadútilt'ih 'ink'ez 'i gha 'andit nohts'u nahizúsya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Et nohdúsni, ndi ts'ekoo too' 'aw doo cha za oosnai' ait'oh 'ink'ez ndet dzin 'uyoo 'andidi-i ts'ekoo too' tisnelh de, ndet la ts'iyanne Yak'usda ook'úne' hutit'en 'et whuts'un.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","'Et Yak'usda ooyun be híjun 'ink'ez ndo shus k'uz Olive be hóodzi whuz whehándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","'Ink'ez Sizi 'ubúlhni, “'Andit 'ulhdzis nohni ts'iyawh skayátilhleh, 'ink'ez ninta tilhwus, ndi Yak'usda ooghuni ndutni, ‘'Et huwa Yak'usda 'en 'usbai ghunlí-un yutuzilhghelh 'ink'ez ndi 'usbai ts'iyawh yaitálh'us.’ ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","'Et dunadusja hukw'elh'az de, 'et yun k'ut Galilee ts'e nohtso tisyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter 'uyúlhni, “Ts'iyanne nkayá tileh, 'et hoonts'i 'aw si íloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","'Et Sizi 'uyúlhni, “Peter, njan whunaoolnih, 'andit 'ulhdzis lugok dune nat 'udutinelh whutso, tat 'et ‘t'esunuzínzun’ dutanelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","'Et Peter soo khuni ulhtus-i be ndutni, “Nyulh datísah 'et hoonts'i 'aw t'enyunuzúszun doosní' ait'oh.” 'Onghunne yugha hodul'ehne cha ts'iyawh whuz un'a nduhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","'Et la 'ilhoghun haníyeh k'et Gethsemane huwhútni ts'e whehándil 'ink'ez Sizi yugha hodul'ehne 'ubúlhni, “Njan dulhts'i. Si n'un tenadutisdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","'Et Peter James 'ink'ez John te 'on 'un bubulh when'az. 'Et 'awet ts'odi be tewhéndunilne ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","'ink'ez 'ubulhni, “Szul tube ts'odi suli' k'et 'awet datisah le'ust'oh. Nja dúlhts'i 'ink'ez howahli.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","'Et 'on 'unyaz whenya 'ink'ez nachánitno. 'Et tenadudli whe ndutni, “'UBá njan whusawhútilts'ulh-un, whuz un'a 'unt'oh de, 'et whute senghóltsit. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","'UBá, nyun za ts'iyantsuk nk'úne' whut'en. Ndi dzoh nutiszut-un sba hooloh nahoolhtsi, 'et hoonts'i si hukwa' nuszun íloh, nyun hukwa' ninzun hukw'un'a 'et 'uhóneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","'Et nyoonne tane yugha hodul'ehne nahunistez whe bughu nanja 'ink'ez Peter 'ulhni, “Simon nanínti whe 'int'oh. 'Aw eh 'atsulyaz honih ait'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","'Ink'ez 'úbulhni, “Howahli tank'us-un tiht'i whuch'a tenadoohdli. Nohyughi be tihzoo' hukwa' nahzun, 'et hoonts'i nohyust'e tetsun whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","'Et doo cha 'on 'un whenaja 'ink'ez whutso da' tenadidli whuz un'a za tenadudli. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Doo cha za yugha hodul'ehne nahunistez whe bughu nanja 'aw huhoonih ait'oh 'ink'ez 'aw whé' hidoni' hooyoh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Whulh tat-un bughu nanja 'et 'ubúlhni, “Whute sahtez 'ink'ez nalhyis. 'Awet whusahóolts'ut, soo cho whunulh'en, yinka dune ye', 'en dune ntsi'ne butl'ahítilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dunadahdilh uztoodilh, nulh'en ndun dune se'óotakulh-un, 'awet 'oh whuya uyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","'Et 'awhuz Sizi yalhduk whe Judas 'en whusaínya. Ndun Judas 'en whunizyane 'on 'at nane whel'a'ne, 'ilhoghun-un 'unt'oh. Dzoh sa' inle' Lizwif lubret bumoodihne, Moses be 'udustl'us 'uk'ununáguzne cha, 'ink'ez dune tso whudilhdzulhne cha, 'uda' buts'ú nuséya, 'ink'ez Sizi ye búts'e'onket. 'Enne Judas buts'ó whenáhiyalh'a', 'ink'ez dune lhane yulh údulh saluzti cha 'ink'ez tut'oh cha hilelh whe whusahándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Hídulh whe Judas 'ubúlhni, “Ilhoghun dune oonimbus k'ut nadists'ooz-un, 'en oohgooh 'ink'ez oogha 'óohli whe tóolhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","'Et huwa Judas Sizi yughu ninya ibulh 'uyúlhni, “Hadih, Rabbi,” 'ink'ez naidits'ooz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","'Et 'awet Sizi huyílhchoot 'ink'ez duts'o cho huyoontun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","'Et hoonts'i 'ilhoghun Sizi zih usyin-un saluzti hayálhtsus 'ink'ez Lizwif lubret 'uk'énus dízti'-un be 'ulhna-un yudzo k'uz haílht'o. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","'Et Sizi yatilhduk 'ink'ez 'ubúlhni, “'Et di ha saluzti cha 'ink'ez tut'oh cha nuhle 'ink'ez 'undunust'ih hukw'un'a skatíhdil? ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dzin totsuk nohbulh 'úst'oh 'ink'ez lugliz whucho whunohodus'eh, 'et di ha 'oh da' sulhúlhchulh inle'. 'Et hoonts'i Yak'usda ooghuni dája ni whuz un'a 'ohóneh huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Et ts'iyawh yugha hodul'ehne hich'a sudil 'ink'ez nintahulghaz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","'Ilhoghun chilh naih ts'ut'an-i za khaóosduz, 'en Sizi uniyalh. Ndun chilh 'en 'uyoonne chilke huyílhchoot. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","'Ust'et bula k'éhalgai whe naih za bula k'eyáno. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Et Sizi huyílhchoot 'ink'ez Lizwif lubret 'uk'enus dízti'-un ooyoh ts'e whehúyalhti. 'Et Lizwif lubret bumoodihne, dune tso whudilhdzulhne cha, Moses be 'udustl'us 'uk'ununáguzne cha 'ilhuhozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter yoo niz de bubuniyalh. Lizwif lubret 'uk'enus dízti'-un ooyoh 'et whuna'nistl'óo-un whuz bughu danínya. 'Et howunline buzih natl'adida' 'ink'ez naldzilh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Lizwif lubret bumoodihne 'ink'ez nahíyilhne cha 'enne bubut Sizi néhinilhti hukwá hituzilhghelh-un highu nahó'alh hukwa' hut'en, dune yuch'az yaoolhdukne nahólhtelh hukwa' hut'en, 'et hoonts'i 'aw 'ilhoghun nalhihilhtel. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Lhane dune huwhuts'it whe hich'az yálhduk, 'et hoonts'i ts'iyawh lhelhts'un un'a 'uhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Whulohne dune dodindil 'ink'ez Sizi hiba whuts'it whe njan duhútni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Njan dutni whe nenalh 'útni, ‘Njan lugliz whucho dune 'uhóonla-un, 'et nanaóoduntisyus. 'Et hukw'elh'az tat dzin inle' de, 'aw dune whut'álhanal whe 'udun na'whutisdlelh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","'Et hoonts'i 'aw ts'ih'un lhgha 'úhudootni' aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","'Et lizwif bulubret 'uk'enus dízti'-un butoh dudinya 'ink'ez Sizi 'ulhni, “Ndun dune nch'az yáhulhduk daja datanelh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","'Et hoonts'i Sizi t'edusni 'ink'ez 'aw yalhtílhdih. 'Et doo cha za lubret yoodulhkut, “Nyun eh Christ 'int'oh? Yak'usda dízti'-un ooYe' inli?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sizi uyúlhni, “A, 'en 'ust'oh, 'ink'ez nohni ts'iyawh si, yinka dune ye', huyuntilh'elh Yak'usda ooghu nailhni ts'unk'us usda whe ndus de kw'us toh hanátidalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","'Et nyoon lubret tube hunílch'e k'et dunaih lhts'e yalhch'ul 'ink'ez nja dutni, “'Aw 'on 'un 'uyoonne ts'oodolhkut aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ndi ooghuni Yak'usda yech'az yálhduk-i dahts'o! Nohba dáhoont'oh?” 'Et ts'iyawh úhutni, “Daóotsah huba' 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","'Et whulohne highá whenduninzo, hinak'ená'uzguz 'ink'ez huyoonukat cha' huyulh'en 'ink'ez, “Mbe nyunízkuk?” huyúlhni. 'Et nyoonne dune ghunline huyílhchoot 'ink'ez 'enne cha huyoonankat. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","'Et 'awhuz Peter 'on yo nanistl'oo bet 'ut'en whe Lizwif bulubret 'uk'enus dízti'-un ts'ekeyaz yuba 'ut'en-un, 'oh whuya uyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Peter naldzilh yutilh'en 'ink'ez 'uyúlhni, “Nyun cha Sizi Nazareth whut'en-un bulh 'ínt'en inle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","'Et Peter 'utni, “Tilah, ndet 'uwhudíni 'aw t'éoonuzúszun,” 'ink'ez 'az whenya. Soo 'et 'ahoh lugok dune 'udíja. ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","'Et ts'ekeyaz cha za nyo 'et yan'en nyoonne 'oh nudilhyanne cha za 'ubúlhni, “Nyoon 'en cha 'ilhoghun 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","'Et hoonts'i Peter cha za, “'Awundooh!” ni. 'Et 'atsulyaz inle' nyoonne 'oh nudilhyanne cha za Peter 'et duhúyulhni, “'Alha nyun cha 'ilhoghun 'int'oh. Nyun cha Galilee hoont'en whe 'int'oh whuz un'a yailhduk 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","'Et Peter 'utni, “Ndughi nalh, 'alha' dusni whe' dusni, ndun dune 'udáhni-un, 'aw t'enuzuszun!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","'Et lugok dune whulh nat 'udija. 'Et Peter Sizi dája yulhni la whunalni, “Lugok dune nat 'udutinelh whutso 'et tat t'esunuzínzun dutanelh.” 'Et huwu nuni nuzut 'ink'ez intse. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","'Et 'om bun bundada' 'uda' Lizwif lubret moodihne, dune tso whudilhdzulhne, Moses be 'udustl'us 'uk'ununáguzne cha, 'ink'ez dune ba nahiyilhne cha, ts'iyawh yahalhduk. 'Et Sizi hiyulhghel 'ink'ez Pilate tl'ahúyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","'Et Pilate 'uyulhni, “Nyun eh Lizwif bulerwe inli?” 'Et Sizi 'utni, “'Alha' dini whe' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Lizwif lubret moodihne lhat-un Sizi hich'az yalhduk, 'ink'ez hiba honts'it, 'et hoonts'i Sizi t'edusnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","'Inka Pilate doo cha za Sizi yoodulhkut, “Dáwhultsuk-un nk'ehúhoon'ai, 'et huwun 'aw eh dája lhdutuzanel?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","'Et doo cha za Sizi 'aw yalhtílhdih. 'Et Pilate ooba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nawhúdizulh totsuk Lizwifne butus lhuséya whunahulníh-un, 'et 'ilhoghun dune 'adin'aí-un Lizwif 'utahahúyulhtih, 'en Pilate yula nadutnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","'Et 'oh da' mbene la lhtahuwhunt'ai da' dune inghanne ts'iyawh 'abahanla. Barabbas 'en cha butoh 'adin'ai dune silhghi hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ts'iyanne 'ilhozdil 'ink'ez Pilate 'uhuyúlhni, “Nawhudizulh totsuk 'ilhoghun dune 'adin'aí-un, 'en oolanadintnih. Doo cha za 'et dineh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","'Et 'ubulhni, “Lizwif bulerwe, 'en oolanadutistnih hukwa' nahzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Didutch'oh soo t'eoonínzun Lizwif lubret bumoodihne 'oonih gha Sizi hitl'aháyalhti 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","'Et hoonts'i Lizwif lubret bumoodihne dune buba nus hónilht'i, Barabbas 'en Pilate yulanadootnih hidóni' ha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","'Et Pilate doo cha za dune 'ilhozdílne 'ubúlhni, “Ndun Lizwif bulerwe dáhni-un datísdlelh hukwa' nahzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","'Et tube cho 'uhuyúlhni, “Tulalhgus undunilht'ah!” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","'Et Pilate 'ubulhni, “Ndet whe tank'us 'úja?” 'Et hoonts'i 'on nus 'uhutni, “Tulalhgus undunilht'ah!” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","'Et 'ilhozdílne hohót'e' ha Barabbas 'en Pilate buba yulanaditni. 'Et Sizi yahuyalhtsus, 'ink'ez tulalhgus k'ehíyolhtelh ha butl'ayálhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","'Et lhugánne moodih ooyoh whunanistl'oo-i bez ts'e Sizi dáhinilhti 'ink'ez 'onghunne lhugánne ts'iyawh buka' hudáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Luglok dulk'ún-i, 'i Sizi hit'ahúyalhbal. Whus n'awh nahínilhjaz, 'i hitsi nehídan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","'Et hidílhti' nahoohoolh'i, 'ink'ez 'uhuyúlhni, “Lizwif bulerwe-un sa' cho hona'.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Duchun be hitsi ts'e' nalht'o, highá dizoh, hibut dugwútsi be nehúdulh, 'ink'ez hibut nachánuldulh cha' huyulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sizi highu núwhulhya 'etsul 'uhayínla hukw'elh'az luglok dulk'ún-i highu nahuyílhchoot, 'ink'ez dich'oh hinaih be náhayalhti. 'Et 'awet tulalhgus k'ehuyitalhtelh ts'e hítilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","'Et hidulh whe 'ilhoghun dune, Simon huyúlhni-un, Jerusalem ts'e tizya. 'En hidudizdil 'ink'ez Sizi ootulalhgus yuba idutitelh ha 'et néhininyoot, ndun Simon Cyrene whut'en-un, 'en Alexander 'ink'ez Rufus 'enne bubá 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","'Et Sizi Golgotha huwhútni ts'e huyoolhti. Ndi Golgotha 'utsints'un niz'ai hutni whe' hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","'Et ts'ekoo too' 'ink'ez yoo, myrrh huyúlhni, hitadínla, 'i Sizi huyúhuyoolhnai' hukwa' huyínla, 'et hoonts'i 'aw lheyílhchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","'Et tulalhgus k'ehúyilhti 'ink'ez hinaih 'i 'uhúntúlhdulh whe higha 'aínlih whe hinaih lhtáhayulya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Bundada' whe 9:00 'uhunit'oh at'en Sizi tulalhgus k'ehíyilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ndet la hukwa' huyínla hutni-un, 'et 'uk'ehúhoonguz, 'i hiyando whahidin'ai. Ndi khuni 'uk'ehúyinguz-i ndutni, ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nane 'undunut'íhne cha huyulh tulalhgus k'ébihilhti, 'ilhoghun ooghu naílhni ts'ungus 'ink'ez 'ilhoghun ooghe 'intl'us ts'e. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","'Uda' Yak'usda ooghuni 'uk'unusgúz-i whuz un'a 'uhóoja ndutni whe, “Dune ntsi'ne dult'oh huninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dune 'oh whúya 'oh nudilhne nóndunul'us 'ink'ez Sizi highudloh, “Hee! Nyun lakw 'udini, ‘Lugliz whucho yanahootányus 'ink'ez tat dzin na'whutanlelh,’ dini? ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'Andit 'ahoh nanaíndaih, 'ink'ez 'ududílyih,” huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Whuz un'a za Lizwif lubret bumoodihne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'enne cha, Sizi highudloh 'ink'ez njan dúlhodutni, “'Uyoonne ilhyiz, 'et hoonts'i didutch'oh 'andit 'ududoolyih aít'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Andit Christ, Lizwif bulerwe ts'unoolh'-en nanaóoja', 'et la neba 'alha' oot'e'.” 'Et nyoonne nane hizih tulalhgus k'ut sulhtíne, 'enne cha highudloh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dzetniz 'et whuts'un n'un whe 3:00 at'en 'uhúnit'oh keyoh ndulcho whe tsalhgus naki. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Whulh 'ilho hooloh sadzi ook'oh 'uhoonist'oh, 'et Sizi soo tube cho haínzul whe, dughuni k'un'a 'utni, “Eloi, Eloi, lama sabachthani,” “SYak'usda, sYak'usda, di ha sladantni?” ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","'Et whulohne dune 'et núdilhyane hidánts'o, 'ink'ez 'uhutni, “Hadih Elijah hahuyih.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Ilhoghun whusálgai, 'ink'ez duchun oolá'dul'oo-i ts'ekoo too' dunink'oz-i ye tunayuzsi, 'ink'ez ndo Sizi yuza bé yunintan, 'ink'ez 'utni, “K'at Elijah whusaínya 'ink'ez tilah tulalhgus k'ut nanáyoolhtelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","'Et Sizi tube cho haínzul 'ink'ez dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Lizwif bulugliz whucho chunkelh dizti'-i oo'ih yúnant'i, 'i cha soo lhóohoolcho yo ún'a lhts'ench'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Lhuganne moodih tulalhgus yubut usyin. Sizi nts'en'a la haínzul, 'ink'ez dazsai 'et yunalh'en. “Ndun dune 'alha azi Yak'usda ooYe' unli,” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ts'ekoo cha 'et núdilhya yoo 'az de whuts'un huwhunilh'en. Butoh Mary Magdalene cha, 'ink'ez Mary Jamesyaz, 'ink'ez Joses bulh buloo, 'ink'ez Salome cha. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","'Enne Sizi Galilee 'et 'ut'en whe hiyunúnizdil 'ink'ez hila 'ít'en. 'Uyoonne ts'ekoo lhane cha 'et 'uhut'en. 'Enne Jerusalem ts'e heyuhanándil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","'Et 'awet hulhgha ts'ótizut whe Joseph Arimathea whut'en-un whusaínya. 'En nahíyilhne toh boozi' unzoo-un 'unt'oh. 'En, 'oh de Yak'usda ook'úne' whut'en-un, 'et hukwa itís'en. 'Et dzin nats'ulyis dzin huba lhahúdutneh-un 'óohoont'oh. Soo Joseph oodzi hooni whe Pilate yubut nenínya, 'ink'ez Sizi oozi yuts'u yúka' dani'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","'Et Pilate ooba hooncha Sizi 'uda' dazsai. Lhugan moodih, 'en yuka' dani' 'ink'ez 'uyulhni, “Sizi 'uda' tilah dazsai?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","'Et hukw'elh'az lhugánne moodih, “'Alha dazsai,” ni. 'Et Pilate Joseph, “Sizi oozi nayólhchoot,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph naih dizti'-i onket, 'ink'ez yuzi nanáyalhti, 'ink'ez nyoo naih dizti'-i yughá yozduz. 'Et tse 'an whuz 'ayalhti, 'ink'ez tse cho whudunaídan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene 'ink'ez Mary Joses ooloo bulh 'enne bunalh, Sizi 'et nehínilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Lizwif nahulyis dzin hukw'elh'az hulhgha ts'e Mary Magdalene, 'ink'ez Salome cha, 'ink'ez Mary James ooloo cha, yoo sooltsun-i honket, Sizi ooyust'e hiye hítilho huba. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Om bun bundada' 'uda' lisman 'udechoo dzin, 'et sa haín'ai whe ts'un k'uz hutizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Whuz hidulh whe 'ulhodútni, “Tse cho ts'un k'ut whudándunin'ai-i mbe suba neba whusaídoo'alh?” ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Tse 'uda' whusandunilgai whe hotilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","'Et tse 'an 'uhandil whe chilh ulhyul-i be dune unli, 'en naílhni ts'unk'us usda whe hitilh'en. 'Et bugha 'ánjaz. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","'Et 'ubúlhni, “Nulhjut iloh! T'eoonúszun Sizi Nazareth whut'en-un, tulalhgus k'ehíyilhti-un, 'en ookunáhta whe 'aht'en. Hooloh! Dunadija whe 'unt'oh! Njan whunulh'en ilhté'-un. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'Awet nahdulh, Peter 'ink'ez 'onghunne Sizi yugha hodul'ehne cha ubudúhni, Sizi dája nohúlhni da' nohtso Galilee ts'e tíyalh 'et la ooh'en,” 'ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","'Et 'awet tse 'an tenáhalghaz 'ink'ez nahutílhghaz tube bughá ne'usjaz 'ink'ez 'aw dune lhodínel hunuljut 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'Et Sizi dunadija hukw'elh'az, Lizwif nahulyis dzin 'om bun bundada' 'uda' 'et Sizi 'udechoo Mary Magdalene, 'en cho yunalhts'et hainya. 'En la lhtak'ánt'i ntsi'-i nudúdeh-i ye yáhanananyoot ínle'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Sizi yulh 'út'en inle'ne hík'enudle, 'ink'ez hutso whe bughu ninya 'ink'ez 'ubudáni', ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sizi khuna whe yan'en, 'et hoonts'i 'aw buba 'alha lhe'dusnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","'Et hukw'elh'az Sizi 'uts'un un'a be hóodat'en whe nane 'uts'un keyoh ts'e hi'us whe bunalhts'et hainya. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Whusanáhit'az whe, 'onghunne bubulh náwhuhulnuk whe 'aw buba 'alha lhe'hudusnih. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","'Et hukw'elh'az Sizi yugha hodul'ehne whunizyane 'on 'at 'ilhoghun na'hut'alh whe bunalhts'et hainya. 'Et 'aw be 'alha' hoont'oh-i lhuhít'i 'ink'ez 'uts'un 'oninzun. 'Et huwa mbene la yan'enne 'aw buba 'alha lhe'hudusnih, 'et Sizi hukwa' budáni', ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","'ink'ez 'ubulhni, “Yinka ndulcho whe náhdilh, 'ink'ez khuni unzoo-i yinka dune'ne whubunulhtun. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mbe ooba 'alha hoont'oh-un, 'ink'ez too be 'úlya de, 'en dutijih. Mbe la ooba 'alha lhe'hoot'oh-un, 'en hoontsi' hukw'un'a ooba nahutideh. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mbene la ooba 'alha' 'ust'ohne, 'enne la be úlhtus-un bugha óotas'alh. Si soozi' gha ntsi'-i nududeh-i dune ts'u hanáhuyuntiyulh. 'Uyoo khuni be cha yahatilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nahunit'a whe tl'ughus ntsi'-i hílhchoot, k'us lubezo whe hítnai' de, 'et hoonts'i 'aw dalhótisnel. 'Ink'ez undudáne butsi k'ehudilnih, 'enne cha soo ná'hutitnelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'Et hukw'elh'az 'et Sizi neMoodihti dune bubulh yálhduk 'etsul 'udíja whe, 'et yak'uz whenája 'ink'ez Yak'usda ooghu naílhnih ts'unk'us nátl'adida'. ");
INSERT INTO crxNTpo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yugha hodul'ehne ndulcho nahúdilh, 'ink'ez dune bulh yáhalhduk. 'Et neMoodihti bubulh 'út'en 'ink'ez be úlhtus-i butl'adán'ai, 'et huwa ooghuni be yahulhduk-un, 'alha' hutni whe' hutni. 'Et ndo honeh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Lhane 'uda' hoolhtus whe hit'en ndi be nawhutnuk-i ts'ih'un un'a ookwa' ditni'-i, 'i ts'iyawh 'uk'ehuyanguz. 'Et 'uk'ehuyanguz whutso, 'i ts'iyawh ndi whenich'oh netoh neba 'alha' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Soo 'udechoo whe' whudit'en 'et dich'oh duna be honalh'en 'ink'ez Yak'usda ooghuni be ne'úst'enne huzdli', 'enne nduwhi khuni netl'ahídanla-i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'Et Theophilus nyun dune uncha-un inli. 'Ink'ez si cha ndi 'uk'unutísguz whe 'unt'oh. 'Udechoo whe' whudit'en-un whuts'un nts'en'a la dahooja-un 'ink'ez ndet 'uwhulhni, 'et ts'iyawh soo ts'ih'un un'a t'eoonúszun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'Et whe la ndet la 'onghohne whunyohodalh'e'-un, 'et tank'us un'a 'uhoont'oh k'us ts'ih'un un'a 'uhoont'oh-un, 'et la ts'ih'un un'a t'ewhuntanzeh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","'Et 'oh da' Herod 'en Judea yun k'ut whulerwe inle', 'et 'oh da' 'ilhoghun lubret, 'en Zacharias huyulhni, 'en Abijah bulh didowh-un 'unt'oh. Oo'at Elizabeth huyulhni, 'en Aaron yé dinzut-un 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","'Et nahult'oh Yak'usda nalh ts'ih'un dune 'uhint'oh. Ndet la Yak'usda ooghuni buba yutulhúhizye'-i 'ink'ez ndet buts'u hukwa' ninzun hik'une' tit'en ha, 'et ts'iyawh hukw'ú ne'hut'en. 'Aw hoonli-unyaz buk'eho'alh áit'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","'Et hoonts'i Elizabeth 'aw ooyaz hole' ait'oh 'ink'ez nahult'oh yoo'un hizulh, 'et huwa cha 'aw buyaz hole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","'Et 'awet Zacharias bulh 'únt'ohne k'un'a whe Yak'usda nalh lubret be 'ut'en k'oh huwana, ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","nts'en'a la 'ilhone hinli whe lubret k'un'a né'hutilelh, 'et whuz un'a Zacharias, 'en cha lubretne 'utahahúyalhti yoo sooltsun-i dutálhk'un ha. 'Inka neMoodihti oolugliz whucho ts'e danínya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","'Et yoo sooltsun-i yudilhk'un whe 'et nduwhulyiz lhane 'az ts'e tenahududli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","'Et loodel k'ut yoo sooltsun-i dilhk'un, 'et nailhni ts'e, 'et lizas be hoodiltsai 'et ts'eyin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacharias khun yutilh'en 'i be oogha únjaz 'ink'ez whenilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","'Et lizas 'uyulhni, “Zacharias wheniljut iloh. Yak'usda ntenadudli yudánts'o. N'at Elizabeth ooyaz duneyaz tileh, 'ink'ez boozi' John be ootanzilh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'En gha dawhulcho be hootánt'e' 'ink'ez whuntálhni. 'Ink'ez whuzdli de, lhane cha huwhuntálhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","'Alha neMoodihti oonalh dune uncha-un tileh. Ts'ekoo too' k'us too ulhtus-i cha lhitisnel. Whutileh whutso 'et hoonts'i Ndoni be dutibun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","'Ink'ez Israel oots'u hainzutne, 'enne lhane neMoodihti buYak'usda ts'u butilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","'Et nus hoo'en-un Elijah huyulhni, 'en k'un'a 'et whuz un'a Ndoni ye ulhtus-i be neMoodihti yutso tiyalh. Ndiz un'a nja dotat'elh, lhane ts'oodunne bubáke budzi buts'un tizoo' nabutilhtselh. Mbene la 'uk'unulhe'ust'enne, 'enne lhane ts'ih'un 'unt'ohne ye whunih-i hitálhchulh. 'Ink'ez dune, 'enne lhane neMoodihti buts'u tiyalh-un, 'et wheni lhábudutileh,” lizas 'uyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Et Zacharias nyoon lizas yoo dulhkut, “Nts'en'a t'ewhuntiszeh? Nilh'en duneti 'ust'oh 'ink'ez s'at 'en cha yoo 'un uzulh whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","'Et lizas 'uyulhni, “Si Gabriel 'ust'oh. Yak'usda zih usyin-un 'ust'oh. Nts'u whúsaz'a' whe 'ust'oh nyulh yatisduk ha. Ndi khuni unzoo-i nyudutásnelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Soo zilhts'ai! Sghuni daja dusni, soo 'et néwhults'ut de, 'et ts'iyawh 'et dótanelh. 'Et hoonts'i daja dusni-un 'aw mba 'alha lhe'hoot'oh. 'Inka ndet dzin 'uwhutanelh whuts'un, 'aw yalhtuzalhduk!” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","'Ink'ez dune, 'enne ts'iyawh Zacharias hika tse hooli, 'ink'ez daja whusuba 'unt'oh sa' whe lugliz whucho ts'e 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tenanja whe 'aw bubulh yaóolhduk ait'oh. 'Ink'ez t'ehoninzun hoonliyaz benghun néwhults'ut whe 'unt'oh. 'Ink'ez 'ants'i buba núlhni whe bubulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","'Et hukw'elh'az ne'úle-un 'etsul 'uhooja whe, 'et 'awet duyoh ts'e whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","'Et hukw'elh'az oo'at Elizabeth ooyaz 'ucháinya whe kwulat sanun 'et duwhulyiz 'et 'ilhoghun inda'. 'Et nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“'Et whuz un'a azih neMoodihti sulh 'ut'en. 'Oh da' dzin sunalni inle' whe ndet la hukwaya usdli-un, ts'iyawh sts'u hanáhonla.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","'Et 'awet bulh lhk'utat sanun whe Yak'usda ndun lizas Gabriel huyulhni, 'en keyoh Nazareth ts'e wheyalh'a'. Njan keyoh 'et yun k'ut Galilee whuz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Whuz ts'e 'ilhoghun ts'eke sak'úsda unli-un, 'en ts'un whel'a'. 'Ilhoghun dune, Joseph huyúlhni, 'et David ts'u haindene, 'en 'ilhoghun 'unt'oh. 'En yughu tidalh-un yuts'u lhaoodinla. 'Et ndun sak'úsda-un, 'en Mary huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Lizas yuts'o whusainya de, 'et nja dúyulhni, “Whunílhni! Yak'usda nts'un unzoo! Nemoodihti nyulh 'unt'oh 'et huwa ts'ekoo toh 'uk'enus hoont'i'-un inli!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Et yutilh'en whe 'et tube oogha únjaz. 'Ink'ez 'et howu nuni nuzut ooghuni daja ni whe 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","'Ink'ez lizas 'en 'uyúlhni, “Mary niljut iloh! Yak'usda nyulh hoont'i'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Hadi' ts'oodun ba' tanelh. Duneyaz nyaz tileh. 'En Sizi dutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","'En ncha-un tileh. 'En 'uhidutanelh soo 'udedo-un ooYe' tileh. 'Ink'ez Yak'usda neMoodihti David ootsoda'-un, ndet la hukw'inda'-un, 'et yutl'aóoti'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","'Et whuz un'a Jacob oots'u haindene 'ilhiz wheni buba lerwe tileh. 'Ink'ez njan lerwe tileh-un, 'aw whutoh hootáloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","'Et Mary lizas 'ulhni, “Nts'en'a 'uwhutanelh, 'aw dune t'enuzuszun whe 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","'Et lizas yulh yalhduk, “Ndoni nk'edinde 'ink'ez 'udedo-i ye ulhtus-i, 'i nk'ut sawhus'ih be whútaleh. 'Et huwa ndi yust'e lubeshi ooghu hooloh-i, 'i whuzdli de, 'en Yak'usda ooYe' hidutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'Andit 'awet nyunat-un Elizabeth yoo'un uzulh-un, 'en hoonts'i duneyaz oochainya. Ndun 'aw buzkeh hole' ait'oh huyulhni, 'et hoonts'i 'en 'awet whulh lhk'uta sanun be suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","'Alha 'i be Yak'usda 'en 'aw hoonli-unyaz ooba hoolhtus-un hooloh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","'Et Mary 'uyúlhni, “Hadi', si neMoodihti be 'ulhna-un 'ust'oh! Nts'en'a la nghuni k'un'a daootanelh dini, whuz un'a sulh 'úhoneh.” 'Et lizas yugho whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","'Et hukw'elh'az Mary lhadúja. 'Et yun k'ut nódist'ai, whuz Judea yun k'ut 'ilhoghun keyoh whuz'ai, 'aho whuz whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacharias ooyoh daninya 'ink'ez Elizabeth hadih yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","'Et Elizabeth Mary daja ni yuduzts'ai ibulh ts'oodun oochan ts'e tilhtloh. 'Ink'ez 'aho Ndoni be dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeth soo tube cho 'uyúlhni “Ts'ekoo toh 'uk'enus hoonzoo-un nyulh 'uhooja. 'Ink'ez nyaz whutáleh-un, 'en dawhuldzoo'-un nghá whults'ut! ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nts'en'a whe sgha whults'ut sMoodihti ooloo 'en sghu ninya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'Alha, hadih 'usudini whe nyuduzústs'ai ibulh, ts'oodun schan ts'e hoont'i' k'et tilhtloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mbe la ts'eke ooba 'alha' hoont'oh-un, 'en 'uk'enus hoonzoo-un oogha whults'ut. Nts'en'a la neMoodihti daja yulhni-un, ooba 'alha' hoont'oh, 'et huwa 'oh te ooba ne'whutit'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","'Et Mary nja dutni, “Szul, 'i be neMoodihti ye uncha-i yudílhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'Ink'ez Yak'usda súlh yih-un. 'En be syughi whunílhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","'Alha ndun be 'ulhna-un, nts'en'a yo 'ududildzun-un, 'et t'ewhuninzun. Soo cho whunulh'en, 'andit whuts'un, nus de cha, 'ilhiz wheni ndi yun k'ut ts'iyanne soo 'uk'enus hoonzoo-un bulh 'úhooja sodutánelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","'Alha mbe la hooncha whe tune' sulh'en-un, 'en be óonujut-un 'unt'oh 'ink'ez boozi', 'i 'uk'enus dizti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ndi yun k'ut didohne, 'ink'ez 'on 'un 'ubundunidohne, mbene la 'unt'oh-un k'un'a hidólhti', 'ink'ez ye nuljutne, 'enne ts'iyawh bugha te'ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dugan oonut'i be hoolhtus tune' 'ut'en. Mbene la dudzi be 'ududílti'ne, 'enne ts'iyawh yabanla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Mbene la dune nchane huk'odálts'i', 'et 'enne nanábanla. 'Et mbene la 'aw soo 'unt'oh lhilohne, 'enne hincha ubulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Mbene la ooye'últs'ilhne, 'enne unzoo-i be ubudilhbun. 'Ink'ez mbene la hoonzoo' 'unt'ohne, 'aw hoonliyaz bughá lhi'al whe whenábalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Be 'ustlene Israelne, 'enne bugha te'ninzun, 'et whunalnih whe bula 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","'Et whuz un'a la nebáke ubulh yailhduk whe Abraham 'ink'ez yuts'u haindene, 'enne 'ilhiz wheni 'uhint'oh, 'et whuz un'a ubudáni'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","'Et Mary ta sanun at'en whe Elizabeth yuzih inda'. 'Et hukw'elh'az duyoh ts'e whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","'Et 'awet Elizabeth ooyaz whutaleh 'et neóodilhdzut 'ink'ez ooye' whúzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Et yenghoh dilhts'ine 'ink'ez oonatneke whulh 'úhuduzts'ai nts'en'a la neMoodihti yugha te'ninzin. 'Ink'ez ts'iyawh hiyulh whunílhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","'Et 'awet whulh lhk'udit dzin whe ts'oodun 'en yuka dune unli-i k'ut hitit'us. 'Ink'ez oobá boozi' Zacharias 'i be huyootázilh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","'Et hoonts'i ooloo, “'Awundooh! Ndi boozi' John be huyootázilh,” ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","'Et huyúlhni, “'Aw nyunatneke butoh 'aw John boozi'ne hooloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'Et oobá di oozí' higha dúta'alh 'et t'ehontizeh hukwa' huninzun. 'Inka dula be hiba núlhni whuz un'a huyoodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Dula be núlhnih whe 'udustl'us buts'u ha' dani', 'ink'ez 'uk'une'uzguz, “Boozi' John hidutanelh.” 'Ink'ez ts'iyawh buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","'Et khunsul yanawhénilduk whe Yak'usda dálhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Yunat whut'enne, 'enne ts'iyawh nujut bughu nédilts'ut. 'Ink'ez Judea yun k'ut nodist'ai-un dulcho 'et whut'enne, 'enne ts'iyawh howu yahalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","'Et mbene la whulh udants'one, ts'iyawh dudzi be hódanla 'ink'ez 'ulhodutni, “Ndun ts'oodun dant'oh-un suba oole'?” hutni. 'Ink'ez neMoodihti dula be yula 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","'Et 'awet oobá Zacharias, Ndoni be dizbun 'ink'ez nus hóo'en whe yailhduk whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Israelne buYak'usda 'ink'ez neMoodihti, 'en dalzoo' la! Oodune'ne, 'enne buts'oozya nabootakulh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","David 'en Yak'usda be 'ustle-un, 'en yuts'u haindene, 'enne bugha neulhyis-un hooncha-un, 'en neba yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","'Uda' whe' whudit'en whuts'un, 'et whuz 'un'a Yak'usda be nus hoo'enne, 'enne bube yailhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","'Et whe nech'az yalhdukne 'ink'ez mbene nets'u dutnine, 'enne ts'iyawh bula k'éhaoodilts'ut, 'et whe neulhyis. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nebáke 'enne Yak'usda bugha te'ninzun. 'Ink'ez ndi khuni buba lhaídinla-i, 'et yunalnih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Netso da'-un Abraham nts'en'a Yak'usda dughuni yutl'adan'ai whe 'ink'ez yuts'u náhizya, njan 'et wheni neba' whutilelh ha, ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","'et whe nech'az ditnine bula k'ehaoodilts'ut 'et whe neulhyis. 'Ink'ez 'aw whelhts'uniljut whe Yak'usda ba' uztit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Lubeshi lhe'ulh'enne uztileh 'ink'ez ts'ih'un un'a uztit'elh, 'et whuz un'a Yak'usda oonalh dzin totsuk ts'ukhuna whe 'en ba' ts'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Ink'ez nyun ts'oodunyaz, 'en mbe la k'us 'udedo-un, 'en ba nus hoo'en-un nyodutanelh. NeMoodihti 'en ti hoonzoo ooba whutalhtselh ha ootso tanyalh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","'Ink'ez wheni oodune'ne soo cho t'ets'onózin dahoont'oh whe uzditijih-un 'ink'ez nelubeshi cha neba gak yutilhtselh, 'et huwun nedutanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","'Et whutso neYak'usda nek'entsi' whe negha te'nanzin. 'Inka mbe la sa yo tá'aih ts'utni-un, 'en ndus de whuts'un nets'ú k'unadaih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mbene la tsalhgus yo dilhts'ine 'ink'ez datsah huba 'unt'ohne cha, 'enne ts'iyawh ubeídutadih. 'Ink'ez lhutiyalh-un whe nedzi soo' hot'e', 'et nts'e whehon'a-un, 'et whuneuntilhtun. 'Et huwa Yak'usda be nus hon'en-un nyodutanelh,” ni Zacharias. ");
INSERT INTO crxNTpo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Et ndun ts'oodun John, 'en nizyai 'ink'ez ooyughi ulhtus suli'. 'Ink'ez nkede suba Israel oodune'ne bunalhts'et haooya' dunábuntiltun ha, 'et whuts'un nts'e la dune lhuhoot'ih ts'e inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","'Et 'oh da' 'ilhoghun dune Caesar Augustus huyulhni-un, 'en whunilhchoh keyoh dilhts'ine, 'enne ndi khuni bunalh yutulhuhizye'. Ts'iyanne oozi' 'i ts'iyawh uk'ehitagus ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","'Et 'oh da' 'oh whuya whudizulh whutoh, 'ilhoghun dune Cyrenius huyulhni, 'en yun k'ut Syria whumoodih inle'. 'Et 'oh whuya whudizulh 'et whuts'un buboozi' 'uk'ewhehininguz. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","'Inka ts'iyanne dich'oh dukeyoh whuz whehandil buboozi' uk'ehuyitagus ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","'Et Joseph 'en yun k'ut Galilee 'ink'ez keyoh Nazareth, 'et whehúdin'az 'ink'ez David ookeyoh, Bethlehem huwhutni, whuz whehan'az Joseph David ts'u hainzut-un 'unt'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mbe la Mary yughu tidalh whe yuts'u nahizya-un, 'en njan Mary ts'oodun ba 'unt'oh whe yulh whin'az buboozi' 'uk'ehuyítagus-un ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","'Awet 'et huzke whe ooyaz whutaleh-un bulh 'et neoodinzut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","'Et 'awet 'udechoo ooyaz whuzdli'. 'Et nyoo layin naih yughá ozduz 'ink'ez musdoos yez a'alh-i, 'i be yalhti. 'Aw ts'uztez bayoh nahuhó'alh ait'oh, ts'iyantsuk whudizbun 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Ilhoghun yun k'ut dzoh nilhdza'yaz, 'et 'usbai ghunline tl'o k'ut 'et huwhut'i, 'ink'ez 'ulhdzis nduwhulyiz whe dughuna' highunli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","'Ink'ez nilh'en, 'awet neMoodihti oolizas bubut usyin. 'Ink'ez neMoodihti oots'u hayanduz-i, ndulcho whe bunat bube dindi. 'Ink'ez 'awet tube whe hunilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","'Et lizas ubulhni, “Whenoolhjut junih! Nulh'en ndi khuni unzoo-i soo ts'iyanne dune ye hóotat'e'-i, 'i nohts'ú tis'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'Andit dzin David ookeyoh, nohtilhyis-un nohba whuzdli. 'En Christ neMoodihti ts'utni-un, 'en 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndiz un'a whe t'ewhuntihzeh ha nohba whe hoodal'en nts'en'a la dahooja, lhe'unt'oh layin oogha ósduz 'ink'ez musdoos yez a'alh-i, 'i bet usti.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Khunsul lizas 'ink'ez lhane lizas lhuganne, 'enne ndus de hahandil. 'Et whe Yak'usda 'on nus hiba oodílhti' whe nduhutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Yak'usda 'udedo yak'ut, 'en uzdilhti'. 'Ink'ez ndi yun k'ut nedzi doghel, 'i be ts'iyanne dune buts'un hoonzoo hole'!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'Et 'awet ndunne lizasne yak'uz ts'e bugho whenáhidil. 'Usbai ghunline 'ilhodutni, “Dugwe' Bethlehem ts'uztoodilh. 'Ink'ez nts'en'a la dahooja 'et neMoodihti nedani', 'et la ts'onoolh'en!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","'Et 'a cho n'az de hidulh. 'Aho Mary 'ink'ez Joseph 'ink'ez ts'oodun musdoos yez a'alh-i bet usti whe bugho hunindil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hiyan'en hukw'elh'az, nts'en'a ts'oodun ghun lizas 'en ubudáni', 'et whunat ts'iyanne ut'ehonalhdzin whe ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","mbene la yudants'one 'usbai ghunline daja hubulhni, 'enne ts'iyawh buba hooncha suli', ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","'Et Mary dahooja-un, dudzi be oodanla 'ink'ez 'ahoolhyiz howu nuni nuzut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","'Et 'awet 'usbai ghunline de 'usbai hits'u whenadil. 'Et ndet hodants'o-un, 'ink'ez huhon'en-un cha, 'ink'ez nts'en'a bubulh yahalhduk, 'et huwun Yak'usda hidílhti' 'ink'ez 'on nus hoonzoo k'un'a highu yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Whulh lhk'udit dzin lhaóoduja whe ts'oodun yuka dune unli-i k'ut hitit'us, 'ink'ez huyoozi' be huyootázilh, Sizi huyulhni. 'Awhuz 'ucha dinda whe 'et ndi boozi', 'i lizas yugha ídin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","'Et Moses be 'udustl'us k'ut daja ni whe ts'ekoo buyaz whulih hukw'élh'az soo ná'hut'ih te za lugliz danáhadaih, 'et ndúwhulcho whe Mary lhaóodinla. 'Ink'ez ts'oodun Jerusalem ts'e whehíyalhti neMoodihti oonalh ts'et hahúyoolhtelh 'et hukwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","NeMoodihti dughuni butl'aidan'ai-i whuz un'a 'uk'ehúhonguz whe nja dutni, “Mbene la duneyaz 'udechoo whuzdline, 'enne ts'iyawh neMoodihti ba 'udun neltine hinli whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Ink'ez ndai la loodel k'ut hidutálhk'un-i, “'I nanki dut'ai dove huyulhni, k'us nanki dut'aiyaz 'i cha pigeon huyulhni.” NeMoodihti dughuni butl'aidan'ai-i, 'i cha whuz un'a za 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","'Et 'ilhoghun dune Simeon ts'utni-un, Jerusalem whut'i-un. Ts'ih'un un'a 'unt'oh 'ink'ez 'ahoolhyiz Yak'usda be 'ut'en k'oh 'uwhulh'en-un. Mbe la Israel oodune'ne k'enábunta'oh-un, 'en yuka tse hóolih. 'Ink'ez Ndoni cha yulh 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Datitsah whutso neMoodihti ooChrist ts'utni-un, 'en yuti'elh. 'Et whuz un'a Ndoni 'en whut'einalhdzin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","'Et whe Ndoni gha lugliz whucho daninya. 'Ink'ez ts'oodunyaz Sizi, 'en oodusneke, 'enne hik'uz dahinilhti. NeMoodihti dughuni butl'aidan'ai-i, ndet la buts'u hukwa' ninzun-un, 'et hukw'u ne'hutit'en ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Et 'aho Simeon yilhchoot 'ink'ez nja dutni whe Yak'usda yudílhti', ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“SMoodihti si nye 'ulhna-un usdli. 'Ink'ez nts'en'a nghuni k'un'a, 'et 'uhoont'oh sdzi dizghel whe daóosa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","'Alha sna be be nétalhyis-un hoos'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ts'iyanne dune bunalh lhaoodinla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","'Udun yun k'ut whut'enne, 'enne cha buba be hoot'en-i 'unt'oh. 'En be hiti'elh. 'Ink'ez ndune'ne Israel oodune'ne, 'enne cha buba idizti'-un 'en 'unt'oh,” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nts'en'a yughu yatilhduk-un 'et huwa Joseph 'ink'ez ts'oodun ooloo bulh buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","'Et Simeon Yak'usda ts'u hukwa' dani' buts'un óozoo' ha. 'Ink'ez ooloo Mary 'en nja ndi yulhni, “Ndet huba ndun ts'oodun Yak'usda 'en buba 'utahayálhti-un 'unt'oh, 'et nyudutasnelh. Israel oots'u hainzutne, 'en gha lhane natikulh 'ink'ez lhane dunahudutádulh. 'Ink'ez highu t'eooninzun 'et hoonts'i hich'az yatilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'Ink'ez nyunch'oh nzul saluzti be huyuzgwut le'tinelh. 'Ink'ez lhane dudzi be daja huninzun, 'et ts'iyawh ts'iyanne nalh ts'et haootilts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","'Et 'awet 'ilhoghun ts'eketi, Anna huyulhni, Yak'usda be nus hoo'en. Phanuel ootse', 'ink'ez Asher bubulh didowh-un, 'ilhoghun 'unt'oh. Tube yoo 'un uzulh. 'Udechoo ki tit'elh whutso, 'aw dune t'enuszun-un 'unt'oh. Lhtak'ant'it yus k'ut duki zih inda'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ndun tsandilh, 'en lhk'udit whunizyat 'on 'at dit be yus k'ut at'en (84). 'Et 'aw lugliz whucho whuch'a lhiyal. 'Et hoonts'i dzenis 'ink'ez 'ulhdzis ibulh soo hooni 'ink'ez tenadudli, 'i be Yak'usda ba ne'ut'en-un unli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","'Et ndun 'oh whuya hoozulh whe daninya 'ink'ez Yak'usda dílhti'. Jerusalem dilhts'ine, mbe la nabootakulh-un, 'en hika ítis'en, 'et 'en ghun Anna budáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","'Et 'awet Joseph 'ink'ez Mary neMoodihti dughuni butl'aidan'ai-un, 'et ts'iyantsuk whe lhahuduja whe yun k'ut Galilee 'ink'ez bukeyoh Nazareth ts'e whenahit'az. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Et ts'oodun 'awet nuyeh 'ink'ez ooyughi be ulhtus súli'. Ye whunih-i be dizbun 'ink'ez Yak'usda ye unzoo-i bulh 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'Awet oodusneke naoodizulh totsuk Jerusalem ts'e k'unáhut'us. Na'hutit'ulh whe whunahutilnih butus lhusiya-un, 'et hukwa whuz whehán'az ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","'Oh da' ndun ts'oodun 'en whunizyat 'on 'at nat be yus k'ut (12) whe Jerusalem ts'e k'unáhudulh, butus lhusiya da' hukw'un'a 'et huwa 'uhut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nkeda' la 'etsul hooja whe k'oh nahutist'az. 'Et hoonts'i 'awhuz ts'oodun Sizi Jerusalem usda. Joseph Sizi ooloo bulh 'aw t'ehonúszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","'Uyoonne bulh la 'ut'en huninzun. 'Ilhudzin at'en nuhúz'az 'et 'andit za hika itís'en. 'Et oonatnéke 'ink'ez ook'ekene, 'enne butoh hikunúta. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","'Et 'aw nalhuhuyílhtel 'et doo cha Jerusalem ts'e whenáhit'az. 'Ink'ez 'et hikunúta. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tat dzin hukw'elh'az 'et 'andit za nahuyilhti. Lugliz whucho 'et whubodulh'ehne butoh usda. Uboozílhts'ai 'ink'ez uboodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Mbe la yudits'one tube buba hooncha suli'. Ts'iyantsuk t'ewhunínzun 'ink'ez ts'iyawh ts'ih'un un'a ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Oodusneke ngut ndet la 'ut'en-un 'et usda whe hinilh'en whe buba hooncha. 'Et ooloo yúlhni, “Neye' di ha whuz un'a une'ilh'en? Mbá 'ink'ez si tube nghu ni ídli whe nkúnita.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","'Et ubúlhni, “Di ha skunahta? 'Aw lawk t'ewhunuzúhzun 'uBá be 'ut'en k'oh huwa óosna' huba' hoont'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Et daja ni whe 'utni, 'et 'aw t'ehonúszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'Enne bubulh whenát'az. Nazareth ts'e whenáhidil 'ink'ez butl'a'dudilti. 'Et ooloo ndi ndet 'uwhulhni-un, dudzi yo danla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","'Ink'ez Sizi 'on nus whunih cha lheh 'ink'ez nus lhuniyelh. Yak'usda yuba hoont'i', 'ink'ez dunene, 'enne cha hiba hoont'i'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","'Et 'awet Caesar Tiberius, 'en yun k'ut ndulcho whe lerwe inle'. Whunizyat 'on 'at kwulat yus k'ut (15) ant'e'. 'Et Pontius Pilate, 'en Judea yun k'ut whumoodih unli. Herod, 'en Galilee yun k'ut whumoodih unli. Bulhutsin Philip, 'en Iturea 'ink'ez Trachonitis yun k'ut whumoodih unli. 'Ink'ez Lysanius, 'en Abilene yun k'ut whumoodih unli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas 'ink'ez Caiaphas, 'enne 'udedo lubretne 'uhint'oh. 'Et 'oh whuya whudizulh whutoh 'et John Zacharias ooye' 'en dune lhuhoot'ih ts'e usda whe Yak'usda ooghuni ookw'édilts'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","'Et Jordan koh 'et whunat 'oh nuya whe dune ubulh yalhduk too be' hoolneh ha hukwa. 'Et whe whubunulhtun dulubeshi ch'a dudeni náhoondunooleh ha. 'Et whe lubeshi buba hooloh yutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","'Et whuz un'a Isaiah ooghuni 'uk'eguz whe nja dutni, “Dune lhuhoot'ih ts'e dune yiz dusts'ai whe 'ultus-un huyih whe nja dutni, ‘NeMoodihti ooti lhaoodahleh! Ooti soo lhts'e oodiz'a ooba whulhtsi! ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Deyo totsuk naoodutibun. Dzulh 'ink'ez shus bulh ts'iyawh lhgha yo na'titnelh. Whuduzoh-un 'et cha lhts'enaoodutákih. Yun núdist'ai-un 'et cha lhgha na'whutátnelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","'Ink'ez nts'en'a la Yak'usda dune ulhyis-un, 'et ts'iyanne whuti'elh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Dune lhane yughu nindil too be' hutilnelh hukwa' huninzun. 'Et 'ubulhni, “Nohni lubezo tl'ughus buzkehke le'áht'oh. Yak'usda lubeshi 'ulh'enne bubulh húntalch'oh-un 'et whuz de hoolts'ulh, mbe 'unohúlhni whuch'a úlhwus? ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Whute, nohlubeshi ch'a noheni náhandunoohleh de, ndaht'en-un ts'iyanne t'ehonózin ndaht'oh la. 'Ink'ez khun lhts'un njan dudoohni' junih wheni Abraham oots'u haindene 'uts'int'oh. 'Alha ts'ih'un un'a nohdusni, Yak'usda soo 'ultus whe 'unt'oh, ndi tse 'i hoonts'i 'i be Abraham oots'u haindene ubutilhtselh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Njan soo cho whunulh'en, nohni duchun lé'aht'oh. 'Awet tsetselh be lhadínt'oh-un. 'Et nohni whulohne duchun oomai' hooloh-i, 'et ndaht'oh. 'Andit hoonts'i ndai la oomai' hooloh-i, tsetselh be ooghih tubulh tsuhidantsel 'ink'ez hidutálhk'un.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","'Ink'ez dunene ts'iyawh huyoodulhkut, “'Ink'ez nts'en'a suba dats'óoneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","'Et ubulhni, “Mbe la ts'oot'an nanki 'ut'i-un, mbe la ts'oot'an lhitíh-un, 'en 'ilho yugha óolhchoos. 'Ink'ez mbe la t'alh-i 'ut'i-un, 'en cha whuz un'a za edóneh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ndunne sooneya 'ilhunaoos'aihne, 'enne cha too be' hutilnelh ha hits'u whusaindil whe huyoodulhkut, “Whuneodulh'eh-un nts'en'a daztinelh” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","'Et 'ubulhni, “Ndet 'ultsuk italhchulh huba' hoont'oh-un, 'et 'aw 'on lhe'izólhchoot.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Lhuganne, 'enne cha huyoodulhkut, “Wheni do' daztinelh.” 'Et ndúbulhni, “Khun nohni dune sooneya nohgha hoo'alh uboolhtselh junih! Khun dune whuts'it be buk'éhoh'alh junih! 'Ink'ez daltsuk nohba k'elha whutaleh-un, 'et 'awet hóht'e' huba' hoont'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ts'iyanne hoonli-unyaz hukwa tse huhooli. 'Et dudzi be dahoont'oh suba John 'en ghun. Mbe la Christ ts'utni-un, 'en tilah 'unt'oh k'us 'awundooh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John ts'iyawh 'et 'ubúlhni, “Too za-i be too bé' nohus'en. 'Et hoonts'i sk'elh'az whusatiyalh-un, 'en sanus dizti' whe 'unt'oh. 'Aw ookechun natl'oolh ooba k'unatis'uk 'et hoonts'i huba soo lhe'ust'oh. Ndun 'en Ndoni 'ink'ez kwun bulh 'i be too be' nohtilh'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Lufoos tl'o mai' be tahawhúlts'ih-i, 'i lhaídilhdzun. 'Ink'ez ndi ndai la tl'o mai' yuk'ut tahawhúlhts'ih-i, 'i cha yuk'ut lhadút'ih de, 'ink'ez yuna'ulhdoh. 'Ink'ez ndi mai ndai la lhaduja-i, 'i ts'iyawh dénudzih 'ink'ez mai bayoh ts'e wheyúli. 'Et hoonts'i ndai la ndi kwun 'aw nalhnusne, ndi oot'ooz 'i be duták'un,” ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndi Khuni 'ink'ez 'uyoo khuni 'i bulh 'et whuz un'a khuni unzoo-i be budáni'. 'Et whuz un'a khuni ulhtus-i be ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","'Et 'awet ndi yun yumoodih Herod, 'en 'ilhoghun 'unt'oh. 'En dulhutsin Philip oo'at 'en yuzih usda. John yulhni, “Lubeshi 'ilh'en.” 'Udun tank'us un'a cha 'ut'en. 'Et cha ts'iyawh lubeshi 'uhoont'oh yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","'Et ndi ndai la lubeshi 'uyulh'en-i, 'i 'uyoo cha yuts'u na'ul'ih. Ndiz un'a nja duja, John 'en 'azdinla-un 'aiyan'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","'Et 'awet ts'iyanne dune too be 'úlya. Sizi 'en cha too be' yinla. Tenawhéndunidli 'i bulh yat dáha' dankez, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","'ink'ez Ndoni dut'ai, dove huyulhni, 'i k'un'a ndus de hát'oh 'ink'ez yuk'ítoh. 'Et ndo yak'uz khuni huduzts'ai, 'i njan dutni, “Nyun sYe' ook'esi'-un 'int'oh. Tube nyulh hoonúst'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","'Et Sizi tat whunizyat at'en be suli' (30) 'et 'awet whé'nit'en. Ts'iyannetsuk 'en Joseph ooye' huninzun. 'Ink'ez 'en Heli ooye'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","'En Matthat ts'u hainzut-un, 'en Levi ts'u hainzut-un, 'en Melchi ts'u hainzut-un, 'en Janna ts'u hainzut-un, 'en Joseph ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","'En Mattathiah ts'u hainzut-un 'en Amos ts'u hainzut-un, 'en Nahum ts'u hainzut-un, 'en Esdli ts'u hainzut-un, 'en Naggai ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","'En Maath ts'u hainzut-un, 'en Mattathiah ts'u hainzut-un, 'en Semei ts'u hainzut-un, 'en Joseph ts'u hainzut-un, 'en Judah ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","'En Joannas ts'u hainzut-un, 'en Rhesa ts'u hainzut-un, 'en Zerubbabel ts'u hainzut-un, 'en Shealtiel ts'u hainzut-un, 'en Neri ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","'En Melchi ts'u hainzut-un, 'en Addi ts'u hainzut-un, 'en Cosam ts'u hainzut-un, 'en Elmodam ts'u hainzut-un, 'en Er ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","'En Jose ts'u hainzut-un, 'en Eliezer ts'u hainzut-un, 'en Jorim ts'u hainzut-un, 'en Matthat ts'u hainzut-un, 'en Levi ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","'En Simeon ts'u hainzut-un, 'en Judah ts'u hainzut-un, 'en Joseph ts'u hainzut-un, 'en Jonan ts'u hainzut-un, 'en Eliakim ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","'En Melea ts'u hainzut-un, 'en Menan ts'u hainzut-un, 'en Mattatha ts'u hainzut-un, 'en Nathan ts'u hainzut-un, 'en David ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","'En Jesse ts'u hainzut-un, 'en Obed ts'u hainzut-un, 'en Boaz ts'u hainzut-un, 'en Salmon ts'u hainzut-un, 'en Nahshon ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","'En Amminadab ts'u hainzut-un, 'en Ram ts'u hainzut-un, 'en Hezron, ts'u hainzut-un, 'en Pharez ts'u hainzut-un, 'en Judah ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","'En Jacob ts'u hainzut-un, 'en Isaac ts'u hainzut-un, 'en Abraham ts'u hainzut-un, 'en Terah ts'u hainzut-un, 'en Nahor ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","'En Serug, ts'u hainzut-un, 'en Reu ts'u hainzut-un, 'en Peleg ts'u hainzut-un, 'en Eber ts'u hainzut-un, 'en Salah ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","'En Cainan ts'u hainzut-un, 'en Arphaxad ts'u hainzut-un, 'en Sem ts'u hainzut-un, 'en Noah ts'u hainzut-un, 'en Lamech ts'u hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","'En Methuselah ts'u hainzut-un, 'en Enoch ts'u hainzut-un, 'en Jared ts'u hainzut-un, 'en Mahalaleel ts'u hainzut-un, 'en Cainan ts'u, hainzut-un, ");
INSERT INTO crxNTpo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","'En Enos ts'u hainzut-un, 'en Seth ts'u hainzut-un, 'en Adam ts'u hainzut-un, 'ink'ez 'en Yak'usda ts'u hainzut-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","'Et Sizi Ndoni dizbun whe Jordan koh ts'e hanája. 'Ink'ez dune lhuhóot'ih ts'e Ndoni whuz wheyalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","'Et whulh dit whunizyat (40) dzin 'et dzin totsuk netsudule tank'us ooneh hukwa' yulh'en 'et whe yoolhdzih. 'Et duwhulyiz whe 'aw hoonli lhus'al. 'Et lhaóodinla hukw'elh'az ooye'ílts'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","'Et netsudule yúlhni, “'Alha Yak'usda ooYe' inli de, ndi tse lhes oole' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","'Et Sizi nja dúyulhni, “Ndiz un'a Yak'usda ooghuni k'ut 'uk'usguz whe nja dutni, ‘'Aw lhes za iloh dune yuk'ukhuna. 'Et ndai la Yak'usda ooghuni 'i ts'iyawh dune yuk'ukhuna.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","'Et netsudule 'udedo-i dzulh k'ut yulh whin'az. 'Et 'aho yun k'ut nts'oh tula dune whut'i, 'ink'ez lerwene bube 'ut'en k'oh, 'oh nduwhulcho whinulhtun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Netsudule yulhni, “'Et nyun ndi ts'iyawh humoodih tanleh, 'ink'ez hiye dizti'-un 'et cha ngha ootas'alh. Njan sgha whulya. 'Et huwa mbe la ooka' nuszun-un tl'aootis'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'Inka ngwutsi be neninya 'ink'ez sts'u téni' nilhdzun de, 'et de ndi ts'iyawh nch'e' tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","'Et Sizi nduyulhni, “Satan st'áts'inyalh! 'Et 'uk'ehóoguz whe nja dutni, ‘Moodihti nYak'usda 'aw 'en za oobut negwutsi be nets'iyaih, 'ink'ez 'en za oots'u teni' uznilhdzun. 'Ink'ez 'en za ba nets'ut'en.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","'Et Jerusalem ts'e yulh whin'az 'ink'ez njan lugliz whucho 'udedo hukw'ut 'et soo whuban nénilhya 'ink'ez 'uyúlhni, “'Alha Yak'usda ooYe' inli de, 'et njan whenghe' dudintneh! ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","'Alha 'et 'uk'ehooguz whe njan dutni, ‘Yak'usda oolizas ngho hoole' ha 'ink'ez nyuhotun 'ink'ez wheni butl'ahón'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Dula be do nyuhóotatun, 'et huwa 'aw nke tse t'aoonalh ait'oh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","'Ink'ez Sizi ndúyulhni, “Njan 'et 'uk'ehooguz whe nja duwhutni, ‘Khun te Moodihti nYak'usda 'en nantan'ah hukwa ólhdzih junih.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'Et netsudule ts'iyantsuk whe tank'us ooneh hukwa yóolhdzai, 'et 'awet lhaooduja whe 'atsulyaz whuba yugho whenája. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","'Et Sizi Ndoni ye ulhtus-i be yun k'ut Galilee ts'e whenaja. 'Ink'ez ndai la yughu yalhduk-i Galilee yun k'ut dilhts'ine ndulcho whe huyulh údants'o, 'ink'ez ts'iyawh highu yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'Et ts'iyawh Lizwif lugliz totsuk whubehóndunilh'e' 'ink'ez ts'iyanne hidílhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","'Et ndet la keyoh nizyai-un Nazareth huwhutni, whuz whinya. 'Et dzin dune nalyis-un dzin 'uhoont'oh, 'et Lizwifne bulugliz whuz oozya. 'Et whuz un'a dich'oh be 'ut'en k'oh 'uhoont'oh. 'Ink'ez buba 'uk'uyatilhduk ha dudinya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'Ink'ez nus hoo'en-un Isaiah be 'udustl'us 'i hitl'ahúyan'ai. Lhk'eyuntílhghal 'ink'ez ndet la hukw'uyatilhduk-un 'et nahoon'ai. 'Et buba k'uyawhénilhduk whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Moodihti ooyughi 'i sulh 'unt'oh. 'I be 'utahasalhti, tel'enne khuni unzoo-i bugha tis'alh ha. Mbene la whe oodzi undudane, 'enne nabutisye ha buts'ó sasya. Mbene la ílchootne, 'enne whubuntistun nts'en'a la oolanaditnine hutileh. 'Ink'ez hubuntistun mbene la hoos̱'enne, 'enne cha huhoo'en nahutidleh. Mbene la dune 'abo'en, 'enne cha doná'butisdlelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","'Et ndet la nawhudizulh-un soo 'et neMoodihti ooba hoonzoo-un, 'et ts'iyanne budutasnelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","'Et 'Awet 'udustl'us nainílhghal 'ink'ez 'et 'ut'en-un yutl'anayán'ai 'ink'ez nanátl'adida'. 'Ink'ez mbene la Lizwif lugliz dilhts'ine, ts'iyawh 'en za hinilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","'Ink'ez 'awet bubulh yawhenilhduk, “'Et nohni ndi Yak'usda ooghuni dáhts'o-un, 'et 'andit dzin ts'iyawh lhaooduja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ts'iyanne soo highu yalhduk. Khuni unzoo-i ye yailhduk-i ts'iyanne buba hooncha. Dich'oh 'ulhodutni, “Ndun 'en Joseph ooye' 'en iloh eh 'unt'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","'Et ubúlhni, “'Aw nawh lhe'hoot'oh ndi khuni 'ahoolhyiz 'et dudáhni-un whe nja dutni, ‘Yoo be duyun nyunch'oh cho soo na'dudilneh,’ 'et whuz un'a si cha 'et ndusúdutahnelh. 'Inka ndiz un'a dutihnelh, ‘Ndet la keyoh Capernaum howhútni-un, dawhut'en-un whulh úzdits'o, 'et njan nyunch'oh nkeyoh 'et cha whuz un'a za ndint'en.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","'Ink'ez 'et ndutni, “'Alha ts'ih'un nohdusni, nus hoo'en-un dich'oh dukeyoh ts'oozya whe 'aw 'ilhoghun hoonts'i yuka lhe'nizun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ndet la nohdutásnelh-un soo ts'ih'un 'et 'alha' hoont'oh. 'Et 'oh da' ndun Elijah, 'en yun k'ut Israel nus hoo'en-un buba unli inle'. 'Et lhane tsandilh hoonli inle'. 'Oh da' tat yus k'ut 'on 'at lhk'utat sanun whe 'et dúwhulyiz 'aw chan hooloh. 'Et 'uhooja yun k'ut ndulcho whe dai whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","'Et Elijah 'aw 'ilhoghun hoonts'i ts'ú whelhil'al. 'Et 'ilhoghun za tsandilh. 'Et yun k'ut Sidon nts'e la keyoh Zerepath 'et whut'en-un, 'en za ts'u whel'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Et doo cha za 'oh da' nkeda' Elisha nus hoo'en-un buba unli inle', 'et 'oh da' yun k'ut Israel ooká whulhjutne, leprosy huyulhni, huldlai. 'Aw 'ilhoghun hoonts'i soo nálhe'ilel, k'us Naman, mbe la Syria whut'en-un, 'en za soo na'yinla,” ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","'Et Lizwif lugliz dilhts'ine hidánts'o whe dahoolcho-i be huyulh húnilch'e. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ts'iyawh dodindil huyílhchoot 'ink'ez njan keyoh hukw'un'a hitilhya. 'Ink'ez ndo ndet la shus k'ut keyoh whuzdla-un, 'et néhinilhya whunoh ts'e whenghi hitinoh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","'Ink'ez ts'iyawh butoh lhuseya 'ink'ez nts'e la hukwa' ninzun ts'u whínya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","'Et 'awet Galilee yun k'ut 'et keyoh Capernaum whuz'ai whuz whinya. Nats'ulyis dzin totsuk whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","'Et njan hubodulh'eh-un tube buba hooncha. Dughuni hoolhtus whe ook'une' 'oot'en k'un'a bubulh yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","'Et nyo Lizwif lugliz 'et 'ilhoghun dune, 'en ntsi'-i nududeh-i yudínda. Ndun ntsi'-i ndudeh-i tube cho 'alhdzul ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","'ink'ez 'utni, “Ah! Nyun Sizi Nazareth whut'en-un 'int'oh. Ndet nets'u hukwa' ninzun? Gak netalhtselh ha eh whusainya? Mbe inli t'enyunúszun! Yak'usda ba lubeshi ooghu hooloh-un, 'en 'int'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","'Et Sizi hukwa' yudáni' whe 'uyulhni, “T'eduzinih whe ooyáhanaindaih!” Ntsi'-i nududeh-i nyoon dune butoh nayáno 'ink'ez yuts'u hanaja. 'Ink'ez 'aw lhuyundílhdal. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ts'iyawh bugha 'únjaz 'ink'ez whehúnilhjoot 'ink'ez 'ulhodutni, “Ndi khuni ndai whe 'unt'oh? Ulhtus 'ink'ez ookw'une' whut'en. Ndun ntsi'-i nududeh-i, 'et ndúyulhni ibulh 'et yuts'u hanaja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","'Et yun k'ut ndulcho whe huyulh údants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","'Et Sizi Lizwif lugliz dunadija 'ink'ez Simon ooyoh ts'e whuz whinya. 'Et Simon oobiz dada nulwus-i be nduda. 'Et Sizi hidani' khun tilah yula 'ooneh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Et lili zih neninya 'ink'ez yutus cha nuti. 'Ink'ez dada hukwa' yudáni' whe ndi nulwus-i ye nduda-i yuts'ahanádoolts'it yulhni, 'ink'ez oots'ahanaídilts'ut. 'Et 'aho dunadija 'ink'ez bugha ná'unt'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","'Awet sa yo tá'aih whe mbene la ook'ekene lhelhdowh didowh-i dada be ndudane ts'iyawh Sizi highu bonínla. 'Ink'ez ts'iyawh buk'událni 'ink'ez 'et whuz un'a soo ná'binla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'Ink'ez whulohne dune ntsi'-i nududeh-i 'ahúlzul whe buts'u hanáhudide, 'ink'ez 'uhutni, “Nyun Yak'usda ooYe' mbe la Christ huyulhni-un, 'en 'int'oh!” T'eduzahnih 'ubúlhni 'aw yahutilhdih hoonts'i butl'alhúhoo'al, t'ehonínzun Christ 'en 'unt'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'Et 'om bun bundada sa há whenin'ai whe 'et disoh ts'e whinya. 'Et dune ts'iyawh hikunúta. 'Et nts'e la usda-un highu nindil, bughu tooya' whuch'a né'huyulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","'Ink'ez 'et 'ubúlhni, “'Udun keyoh cha ndi khuni unzoo-i be yatisduk, dant'oh whe nts'e la whuba Yak'usda lerwe unli budutasnelh. 'Et huba whusáz'a'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","'Et yun k'ut ndulcho Galilee Lizwifne whulugliz whuz oozya 'ink'ez ubulh yalhduk ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","'Et 'ilhoh dzin Gennesaret bun taba usyin whe dunene ts'iyawh hinat 'ilhozdil, Yak'usda ooghuni 'i hidutáts'o ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ts'i cho nanki yasá'a yunilh'en. 'Et hoonts'i lho ha 'ut'enne 'udun dulembil tunáhugus. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Ink'ez 'ilhoghi ts'i bénya. 'I Simon oots'i 'unt'oh. 'Ink'ez 'uyulhni, “Nusyaz le inleh.” 'Ink'ez 'et ts'i bet natl'adida' 'ink'ez dunene, 'enne whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","'Et ubulh yalhduk-un 'etsul lhiduja whe Simon ulhni, “Nts'e soo takhulh-un 'et nlembil ts'iyawh teninle 'utanlooh huba.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon nduyulhni, “Smoodih wheni 'ulhdzis doohoolyiz whe 'uts'it'en 'et hoonts'i 'aw hoonliyaz lhets'ilooh. Dini de 'et lhembilh 'ilho tenaoosdlelh la.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Te'huninla whe lho lhai whe huyuzdlooh. Lhai huzdlooh k'et bulembil 'awet lhk'enuch'oolh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'Et 'onghohne lubaz bet 'ut'enne 'anih buhutni bula 'hooneh ha. 'Enne cha whusahanki 'ink'ez nankilt'oh ts'i cho hidilhbun k'et 'awet tewhéninlat. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Peter whunalh'en whe Sizi oobut dugwutsi be neninya 'ink'ez, “Smoodihti sch'az naindalh, si lubeshi 'ulh'en-un usdli,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Peter 'ink'ez yulh 'ut'enne, 'enne ts'iyawh bugha 'únjaz 'ink'ez whe húnilhjoot ndi lho lheltsuk whe huyuzdlooh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","'Et James 'ink'ez John Zebedee ooye'ke 'enne Simon ts'uditnine, 'enne cha bugha 'únjaz 'ink'ez whehúnilhjoot. 'Et Sizi yulhni, “Simon khun whenoljut junih. 'Andit whuts'un dune ha' tant'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","'Et 'awet yanáhuski whe ts'iyaitsuk 'et hiladitni. 'Ink'ez hik'oh ts'e oot'en ha huyuntizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","'Et hukw'elh'az Sizi 'ilhoghun keyoh 'ut'en. 'Ink'ez 'ilhoghun dune ndulcho whe ooka whulhjut-un, 'i leprosy huyulhni, 'i be nduda, 'en cha 'et keyoh whut'en. Sizi yutilh'en whe yubut nachaniti, yuts'u tedudli, “SMoodihti nyun hukwa' ninzun de be ilhtus-i 'int'i-i, 'i be suna'ilhdeh,” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","'Et Sizi dula be yut'aíznai 'ink'ez 'uyulhni, “A, hukwa' nuszun whe nyuna'isde.” 'Et yuka whulhjut-un 'et 'aho soo na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","'Et Sizi khuniti be nja dúyulhni, “Khun te 'uyoonne dóni' junih! 'Et k'us lubret oots'inyalh 'ink'ez nyulh dahooja-un, 'et nyunoolh'en. 'Et Moses be 'udustl'us k'ut daja ni whe 'aw ts'ih'un lhe'it'oh, 'et ooba gak whutaleh, 'et whuz un'a loodel k'ut hoonliyaz dutálhk'un. 'Et whe la whubunolhtun dainja whe soo na'inja,” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","'Et hoonts'i be nawhutnuk-i Sizi Gri 'en ghun lhan'un te whulh 'úhudits'o. 'Et whu la toh ts'e 'on nus huldlai 'ink'ez nus za lhe'hiltsuk whe highudulh, ndai la hiye unduda-i ts'iyawh naitilhyeh hits'u hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","'Et didutch'oh lhat disoh ts'e tenadutidli ts'u wheyaih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","'Et 'ilhoh dzin dune hodulh'eh whe 'ink'ez Phariseene cha 'ink'ez Moses be 'udustl'us hodulh'ehne, 'enne cha, yun k'ut Galilee 'ink'ez Judea cha, 'ink'ez Jerusalem cha 'enne ts'iyawh Sizi hiyenghoh dilhts'i. 'Ink'ez neMoodihti ye ulhtus-i ndudane soo ná'tilh'elh ha, 'i cha yulh 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","'Et 'awet ndun dune delhdusni-un, 'en lili be whusahúyankai. 'Ink'ez Sizi yoh ts'e hits'u hitoolhtelh hukwa' huyulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","'Et hoonts'i dune lhai k'et 'aw 'uhuyooleh ait'oh. 'Inka bun k'ehuyinkai. Bun hikonintsi 'ink'ez whuz hukwuhinínkai. 'Ink'ez soo buniz Sizi oobut yun néhininkai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndo ts'iyawh ubunilh'en 'et t'eooninzun buba 'alha' 'uhoont'oh 'ink'ez delhdusni-un 'uyulhni, “Hadih dune nlubeshi ts'iyawh mba hooloh suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","'Et Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene, didutch'oh 'et ndoninzun, “Ndun dune 'en Yak'usda ch'az yalhduk. Mbe na'dunúdzun whe 'utni? Mbe la lubeshi 'untulhdulh? Yak'usda didutch'oh za lubeshi 'un tulhdilh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","'Et Sizi t'ewhunínzun daja huninzun, 'ink'ez ndúbulhni, “'Et di ha nohdzi yo whe 'et ndunahzun? ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nts'en'a suba huwa lhúhoolna' k'un'a uzdooni', ‘Lubeshi mba hooloh suli',’ k'us, ‘Dudinyaih 'ink'ez ninya?’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","'Et njan t'eoonóhzin yinka dune ye', 'en ndi yun k'ut ooba' hoont'oh whe 'unt'oh lubeshi 'un toolhdilh huba' hoont'oh whe 'unt'oh,” ubulhni. 'Ink'ez ndun delhdusni-un, “Dudinyaih, ookw'usinti-i nailhchoot, 'ink'ez nyoh ts'e naindalh!” yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","'Et 'aho ts'iyanne nalh dudinya 'ink'ez yuk'usti-i cha náilhchoot 'ink'ez Yak'usda dilhti' whe duyoh ts'e whenaja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","'Ink'ez 'et ts'iyanne buba hooncha. 'Enne cha Yak'usda hidálhti'. Tube whe hunuljut, “Njan tube huwa 'it'en-un ts'onalh'en,” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","'Et hukw'elh'az Sizi 'az whinya 'ink'ez 'ilhoghun sooneya nalhdzooh-un, Levi huyulhni-un, 'en 'ut'en-un usda whe yunilh'en, 'ink'ez 'uyúlhni, “Sunanyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","'Et dudinyai, 'ink'ez ts'iyaitsuk yula ditni whe yuk'oh ts'e oot'en ha yuntizya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","'Et Levi duyoh ts'e Sizi ba hooncha whe dune gha nátit'alh. 'Et sooneya 'ilhunaoos'aihne, 'enne cha huldlai. 'Ink'ez 'uyoonne cha lhane bubulh 'et dilhts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","'Et ndunne Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene, 'enne didutch'oh highu yalhduk 'ink'ez Sizi yugha hodul'ehne, 'enne ubuhútni, “'Et nyoonne mbene sooneya 'ilhunaoos'aihne 'ink'ez lubeshi 'ulh'enne, 'enne di ha bubulh áh'alh 'ink'ez bubulh 'áhtnai?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sizi 'et ndúbulhni, “Mbene la soo 'únt'ohne, 'aw yoo be duyun ha lhe'hunizun. Ndudane, 'enne za yoo be duyun ha' huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Si cha whuz un'a za 'aw ts'ih'un 'unt'ohne, 'enne dulubeshi ch'a dudeni naháhunduntileh huba iloh sásya. 'Et lubeshi 'ulh'enne, 'enne dulubeshi ch'a dudeni naháhundunooleh ubudutásnelh ha, 'et huba whusásya.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","'Et huyoodulhkut, “Dahoont'oh huwa John yugha hodul'ehne, 'enne lhat soo hóohoonih 'ink'ez tenahududli? 'Ink'ez Phariseene hiye hodul'ehne, 'enne cha 'et za nduhút'en. 'Et hoonts'i nyun ngha hodul'ehne, 'uha'alh cha' hut'en 'ink'ez 'uhutnai cha' hut'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","'Et ubulhni, “Mbe la oo'at whutáleh-un, 'en ook'ekene, 'enne 'awhuz huyulh 'ut'en, 'enne do' soo húhootanih eh? 'Awundooh! ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","'Oh de whusaootilts'ulh, 'oh de de oo'at whutaleh-un bughu nayitálchulh. 'Oh de la soo hoohoonih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","'Et be nawhutnuk 'i be whuts'o dul'eh-i, 'i be bubulh yalhduk whe nja ndutni, “'Aw 'ilhoghun naih 'andit-i ts'u hayalhch'ul 'ink'ez 'ujut-i yunaidunókalh ait'oh. 'Et whuz un'a 'et nduja de, 'et 'andit naih-i tooch'oolh la, 'ink'ez ndi 'andit-i naih, 'ink'ez naih jut bulh 'aw lhk'un'a oot'e' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","'Et doo cha, 'aw 'ilhoghun 'andit-i ts'ekoo too' 'i 'aw 'ujut-i ts'ekoo too' zus be yóolhdzeh ait'oh. 'Et ndúja de, 'andidi-i ts'ekoo too' ndi 'ujut-i ts'ekoo too' zus ook'ohóltalh la. 'Et whe ts'iyawh ts'ekoo too' bé haitijulh. 'I 'uzus 'i cha ninta' tit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","'Et hoonts'i 'andit-i ts'ekoo too', 'andidi-i ts'ekoo too' zus be naooldzeh huba' hoont'oh. 'Et whuz un'a nankilt'oh soo' tit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","'Aw 'ilhoghun ts'ekoo too' 'ujut-i utnai' de, 'aho 'andit-i ts'ekoo too' ha' noozin ait'oh. ‘'Ujut-i, 'i za 'on nus 'uzoo',’ hutni,” 'et ubúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","'Andit whulhnat dune nalyis dzin. 'Udechoo-un 'et hukw'elh'az 'uhoont'oh. Sizi 'ink'ez higha hodul'ehne, 'enne bulh tl'o k'ut 'oh whuya hidulh whe, tl'o mai' huhoonuyin. 'Ink'ez dula k'et hinulhguk 'ink'ez huya'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Et whulohne Phariseene hubuhútni, “Daht'en whe aht'en? 'Andit dzin nats'ulyis-un dzin 'uhoont'oh! 'Aw 'et nduhóot'en huba lhe'hoot'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sizi 'ubúlhni, “Lerwe David daja-un 'aw lawk hukw'u yalhuzulhduk. 'Et 'oh da' David 'ink'ez yulh 'ut'enne buye'ílts'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'Et 'úja, Yak'usda ooyoh daninya. Lhes 'i Yak'usda oogha yut'aih-i, ndi lhes lubretne 'aw 'enne za huyoo'alh huba' hoont'oh. 'Ink'ez 'i yilhchoot 'ink'ez yan'al. 'Ink'ez dulh 'ut'enne, 'enne cha yuloh bugha nín'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","'Ink'ez Sizi 'ubulhni, “Yinka dune ye', 'en njan nats'ulyis dzin, 'et cha huMoodihti unli whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","'Et hukw'elh'az 'on 'at nats'ulyis dzin Lizwif lugliz daninya 'ink'ez whubodulh'eh. 'Et 'ilhoghun dune 'en cha 'et usda. Ndun oola nailhni ts'e 'aw yé nulhe'ust'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mbene la Moses be 'udustl'us 'uk'ununáguzne 'ink'ez Phariseene cha soo cho highunli 'ink'ez hinilh'en daoonelh suba. 'Et dune nalyis-un dzin 'et tilah soo na'yooleh. 'Et whe hoonliyaz highu nahootá'alh hukwa' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","'Et daja huninzun t'eooninzun. 'Et dune oola yunulhe'ust'en-un 'uyulhni, “Dudinyaih 'ink'ez taniz sinyin.” 'Inka dudinya 'ink'ez buniz suyin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","'Ink'ez Sizi 'ubulhni, “Hoonli-unyaz hukwa nohoodutaskut. 'Et nats'ulyis-un dzin, nts'en'a netl'ahóolts'ut, 'et ts'ih'un un'a uztinelh, k'us hoontsi' k'un'a uztinelh? Dune ye khuna-i uztilhyih k'us daztilhtsa?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'Ink'ez 'et ts'iyawh bunilh'en. 'Et ndun dune 'uyulhni, “Nla lhts'eh nadíntsih!” 'Et ndúja 'ink'ez oola kw'uz ts'e dalhit'oh, 'et whuz un'a za ndunája. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","'Et 'onghohne tube soo ts'ih'un howunílch'e, 'ink'ez didutch'oh howu yahalhduk Sizi dahítileh-un 'et huwun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","'Oh da' 'et dzin nja dúhooja, Sizi shus k'ut tenadutidli ha whuz whinya. 'Ulhdzis nduwhulyiz Yak'usda ts'un tenadudli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","'Et yulhkai-un higha hodul'ehne, 'anih ubulhni. 'Et butoh whunizyanne 'on 'at nane, 'enne 'utahábanla. 'Enne whel'a'ne buboozi' súlhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simon, 'en ndi oozi' Peter, 'i cha yugha ídin'ai. 'Ink'ez bulhutsin Andrew, James 'ink'ez John, Philip 'ink'ez Bartholomew. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew 'ink'ez Thomas. James Alphaeus ooye', 'ink'ez Simon 'en huwu daóodit'oh-un huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas James ooye', 'ink'ez cha Judas Iscariot, 'en 'utinelh whu'iz buch'az nedutadalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","'Et whududlun-un ndus de yugha hodul'ehne bubulh hainya 'ink'ez lhts'e oodiz'a-un nenáhundil. Yun k'ut Judea whut'enne, Jerusalem whut'enne cha, 'ink'ez yatoo ba keyoh Tyre 'ink'ez Sidon whut'enne, 'enne cha huldlai k'et 'aw uzdooni' ait'oh. Hiyootuzálhts'ilh 'ink'ez soo na'butilh'elh, 'et hukwa 'ilhuhozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","'Ink'ez mbene la ntsi'-i nududeh-i be dzoh nudehne, 'enne cha 'et hudilhts'i, 'ink'ez soo na'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ts'iyanne hit'aoonalh hukwa' hut'en. Ye ulhtus-i oots'u haidults'uk, 'i be ts'iyawh budada' 'et whe soo na'binla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sizi 'et yugha hodul'ehne, 'enne ts'iyawh butunuyú'en whe njan dúbulhni, “Nohni tel'enne ndet la Yak'usda whe lerwe unli, 'et nohni nohch'e' 'uhoont'oh. 'Et huwa 'uk'enus hoonzoo-un nohgha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nohni mbene la ooye'últs'ilhne, untihdai 'et huwa 'uk'enus hoonzoo-un nohgha whults'ut. Mbene la 'andit utsone tihdloh 'et huwa dawhuldzoo'-un nohgha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Oh de dune nohts'o dutitni 'ink'ez 'aw bubulh óoht'e' ait'oh nohohulhtsi. 'Ink'ez nohch'az yahutilhduk whe yinka dune ye', 'en gha 'et huwa nohoozi' dutsun hitilhtselh 'ink'ez 'un hitilhdulh. 'Et whuz un'a ndunóhuhulh'en de, 'et de 'uk'enus hoonzoo-un nohgha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","'Et dzin ndóohooja de, 'et hootaht'i' 'ink'ez hoonaht'i' k'et do tóolhuk. 'Alha 'uhoont'oh ndo yak'uz hooncha whe nohba k'elha whutaleh. 'Oh de whusawhutilts'ulh mbene la whuz un'a za ndunohotilh'elh, 'et ndunt'ohne butsoda'ne, 'enne cha niz dak'ez nus hoo'en inle'ne, whuz un'a za ndubuhalh'en 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“'Et hoonts'i nohni hoonzoo' 'unt'ohne soo cho howahli! Ndai la be hoonaht'i'-i, 'i be 'uda' ts'iyawh nohba 'uk'elha whuzdli'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nohni mbene la soo a'alhne, nohni cha soo cho howahli! Nohyé'tilts'ulh! Mbene la udlóhne howahli! Nohdzi dúntida' 'ink'ez tihtso! ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Et huwahli mbene la sóo nohghu yalhdukne. 'Oh da' nus hoo'enne na'dudil'ine, 'enne cha butsoda'ne 'et za ndúbuhutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“'Et hoonts'i ndiz un'a nohdusni, nohch'az ditnine buk'ehtsi'. Mbene la nohka lhe'nizunne, 'enne cha sóo ne'bulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mbene la nohk'ehuyihne, Yak'usda buts'un óozoo' ha buba tenadoohdli. 'Et mbene la dzoh ne'nohulh'enne, 'enne cha buba tenadoohdli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Mbene la nohnimbus k'ut nohnizkukne, buba 'awh nandunaht'ah 'ink'ez ookw'uz ts'u cha 'unohuhooleh. Mbe la ndzoot nghu halchooz-un, ndzoozt'an cha ooch'a yóntun junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ts'iyanne hoonliyaz ha nohts'u ka 'utni de, bugha íyohlelh. Ndai la nohch'e' 'uyoonne yílhchoot de, buts'o kwana' doohni' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Nts'en'a hukwa' nahzun dune danohotilh'elh-un, 'et whuz un'a za nohni cha 'et né'boolh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mbene la nohk'entsi'ne, 'enne za buk'ehtsi' de, whuz un'a hoonzoo nahzun eh? 'Awundooh! Lubeshi 'ulh'enne, 'enne hoonts'i mbene la buk'entsi'ne, ts'iyawh buk'ehintsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Mbene la soo ne'nohulh'enne, 'enne za soo ne'bulh'en de, whuz un'a hoonzoo nahzun eh? 'Awundooh! 'Et lubeshi 'ulh'enne cha whuz un'a za 'et duhút'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Et mbene la nohtl'anáti'alh nahzun de, 'enne za bughe zulh'ai, whuz un'a hoonzoo nahzun eh? 'Awundooh! 'Et lubeshi 'ulh'enne, 'enne hoonts'i lubeshi 'ulh'enne ghe' hulh'ai 'ink'ez 'et 'ultsuk za butl'anáha'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","'Et hoonts'i nohch'az ditnine buk'eoohtsi', 'ink'ez soo ne'boolh'en. Bughe 'oolhla' 'ink'ez hoonliyaz nohtl'unátilts'ulh hukwa tse hólhle' junih. 'Et whuz un'a ndaht'en de, hooncha whe nohba k'elha whutaleh. 'Et la mbe la yak'uz soo 'udedo 'unt'oh-un, 'en k'un'a tihleh. 'Alha mbene la musi lhdusnine 'ink'ez ntsi'ne cha, ts'iyawh buts'un unzoo. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","'Inka nohBá nts'en'a la te'ninzun, nohni cha whuz un'a za te'noohzin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“'Uyoonne ba nahoohyeh junih, doo ka si 'aw nohba nahoodeh ait'oh. 'Uyoonne k'ehoh'alh junih, 'et de 'aw nohk'eholts'it ait'oh. 'Uyoonne ba whunaoodolnoh, 'et de nohni cha nohba whunaoodutitnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","'Uyoonne gha náh'a-i, 'i nohtl'anátikulh whe 'unt'oh. Lht'usúkat 'ink'ez lhai cho tileh. 'Et la nudúl'us whe bé haitikat. 'Et 'ultsuk whe nohbut nehítakalh. Daltsuk oogha náh'a-i 'et 'ultsuk za nohtl'anátikulh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Be nawhutnuk-i be whúts'odul'eh-i, 'i be bubulh yailhduk, “Soo eh hoos̱'en-un 'uyoon hoos̱'en-un nutíguz? 'Alha nahúlt'oh la ha hóokai-un 'ahoolts'it! ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Hodul'eh-un 'ink'ez whuyodulh'eh-un, 'en 'aw yando lhe'ít'oh. 'Et hoonts'i mbene la soo ts'ih'un un'a hodul'ehne, 'et la hubodulh'e'-un 'en k'un'a 'uhutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","'Et di ha nyulhutsin lhusyaz oona k'et diztan, 'i nilh'en, 'et hoonts'i 'aw t'eoonuzinzun nyunch'oh duchun cho nyuna k'et diztan? ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nts'en'a nyulhutsin 'udutanelh, ‘Sulhutsin nyo lhusyaz nyuna k'ehanádoostan.’ 'Et hoonts'i nyunch'oh duchun cho nyuna k'et diztan-i 'aw lhuzan'en. Nyunch'oh duba naindzoo! 'Udechoo duchun cho nyuna k'ehanadintih. 'Et de la soo hón'en whe nyulhutsin nyoo lhusyaz 'i oona k'éhanaidontan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“'Et la duchun dinzoo-i 'aw mai 'utsi'-i ooghu noot'ai ait'oh. 'Et whuz un'a za duchun dintsi'-i mai unzoo-i ooghu noot'ai ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","'Et whuz un'a za oomai' gha duchun dant'oh-i 'unt'oh t'enudzun. 'Et whuz un'a za ndi mai unzoo-i, figs huyulhni, 'aw whus chun ghun huyoonoyin ait'oh. 'Ink'ez whuz un'a za whuscho chun, 'aw duje do 'ut'en-i ooghu oononyin ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","'Et whuz un'a za dune unzoo-un, ndai unzoo-i dudzi yo hoonli-i, 'i gha khuni unzoo-i be yalhduk. 'Ink'ez dune untsi'-un, ndai untsi'-i oodzi yo hoonli-i, 'i be khuni untsi'-i be yalhduk. Ndiz un'a nja duwhutni, dune di la oodzi yo be whudizbun, 'i be yatilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“'Ink'ez di ha ‘SMoodihti, sMoodihti,’ sudahni, 'ink'ez daja nohdusni la, 'aw húkw'u nulhe'zaht'en? ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mbene la sts'un túyaih 'ink'ez soo zilhts'ai 'ink'ez hukw'ú ne'ut'enne, 'et mbene 'uhint'oh 'enne bunóhuntistun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ndiz whuz un'a 'et duhint'oh. Dune yoh 'uwhutilelh whe, soo yoo yo cho hahónkai 'ink'ez yoh ook'uwhuz'ai-i 'et tse k'ut newhúta'alh. 'Et ndet la too tilht'o de, 'et ninli ulhtus-i yoh whut'aiznai, 'et hoonts'i yoh 'aw dalhuhoonel. Tse k'ut neoonin'ai 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","'Et hoonts'i mbene la sghuni yoozilhts'aine 'ink'ez 'aw hik'unulhe'ust'en de, 'et diz un'a nja duhint'oh. Dune yun k'ut yoh 'uhoonla. 'Ink'ez yoh ook'uwhuz'ai-i 'aw lhe'ílel. 'Et ninli ulhtus-i yoh whut'aiznai whe 'aho naóonit'ai. Tube wheóonujut whe musai whuzdli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","'Et dune Sizi yoozilhts'aine ndet huwun ubulhni-un, 'et 'awet ts'iyawh lhaoodinla. 'Ink'ez keyoh Capernaum huwhutni-un whuz oozya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Ink'ez nja 'et keyoh whut'en-un 'et 'ilhoghun lhuganne whumoodih-un yuba ne'út'en-un. Tube yúk'entsi'-un, 'en tube unduda 'ink'ez 'awet datitsah. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","'Et ndun lhugan whumoodih-un Sizi yulh údants'o 'ink'ez Lizwif tso whudilhdzulhne, 'enne whuz whebalh'a'. Sizi huyoodutalhkut ha lhugan whumoodih yuba ne'ut'en-un soo na'yooleh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","'Et Sizi highu nindil whe soo tube cho hits'u tedudli 'ink'ez 'uhuyulhni ndun lhuganne whumoodih-un, 'en soo 'uldzoo' whe 'unt'oh yuba ne'ut'en-un, 'en soo na'yooleh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","“Nedune'ne, 'enne buk'entsi' 'ink'ez 'en gha lizwifne nelugliz neba' hóonla,” huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Inka bubulh tizya. 'Et Sizi yoh whenghoh uyalh whe, 'et ndun lhugan whumoodih 'en ook'ekene Sizi hits'ú whebalh'a'. Hidudizdil 'ink'ez Sizi huyúlhni, “Lhugan whumoodih njan dunyúlhni, ‘SMoodihti 'ants'et dzoh ne'dudoldzut junih. Syoh datányalh huba 'aw soo lhe'uzdzoo' 'et huwa.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","'Et si cha 'et ndunuszun 'aw soo lhe'uzdzoo' ndudutásyalh huba. 'Et hoonts'i 'ants'i nghuni be dini de, 'et la sba ne'út'en-un soo na'óotneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Alha si cha 'onghohne sando 'uhint'oh whe hukwa' huninzun tune' sotilh'en. 'Et si cha whuz un'a za lhuganne buba ando 'ust'oh. 'Et 'ilhoghun, ‘Inyalh!’ dúsni de, 'et 'aho 'awet tiyalh. 'Et 'uyoon, ‘'Anih!’ dúsni de, 'et 'aho sts'u tuyaih. 'Et sba ne'út'en-un, ‘Nja dineh!’ dúsni de, 'et 'aho 'et ndút'ih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sizi ndun dune daja ni la yulh údants'o whe tube ooba hooncha. 'Et ndunne yunidulhne buts'ú nalh'a 'ink'ez ubúlhni, “Israel ndulcho whe keyoh ndun dune 'en k'un'a 'aw 'ilhoghun ndulcho-i be ooba 'alha' hoont'oh-un nalhizústi.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Mbene la yuts'un whel'a'ne ndun lhugan whumoodih hiyoh ts'u naóosdil whe, 'et ndun yuba ne'út'en-un ndida' 'aw dálhit'oh whe highu danándil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","'Et 'om bun dzin Sizi njan keyoh Nain huwhutni-un, yugha hodul'ehne bulh, 'ink'ez hooncha whe lhanne unidulhne, 'enne cha ts'iyawh whuz whe hándil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","'Et njan keyoh nanistl'oo ghu ti-un whenghoh nehúnindil whe khunsul dazsai-un hiduhidizkai. 'Et ooloo tsandilh, 'aw 'ilhoghun za ooye' 'unt'oh. 'Et keyoh whut'enne, 'enne lhane yulh údulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","'Et neMoodihti yan'en whe yugha te'ninzin whe 'uyúlhni, “Intso iloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","'Ink'ez nezi chunkelh yughu ninya 'ink'ez yut'aiznai. Mbene la yilhtelhne, 'enne cha 'ilhiz nehunindil. 'Ink'ez 'et 'utni, “Chilh dune dudinyaih nyudúsni!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","'Ink'ez ndun dune dazsai-un donetl'adinda' 'ink'ez yawhénilhduk. 'Ink'ez Sizi ooloo tl'anayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ts'iyanne hunílhjoot, 'ink'ez Yak'usda hidílhti' whe nja duhutni, “Njan netoh nus hoo'en-un hooncha-un whusainya.” 'Ink'ez 'et cha nduhútni, “Yak'usda dudune'ne buzih nunasja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","'Et Judea yun k'ut dulcho whe 'ink'ez 'et whunat keyoh dulcho whe cha, ts'iyanne huyulh údants'o. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","John yugha hodul'ehne ts'iyawh hidutánelh dahooja la. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'Ink'ez nane 'anih ubulhni 'ink'ez Sizi ts'un whebalh'a' huyoodutalhkut ha, “Nyun eh whusatíyalh-un inli, k'us 'uyoon tilah ha ts'itó'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","'Inka Sizi highu nin'az 'ink'ez 'uhuyúlhni, “John dune too be 'ulh'en-un, 'en nts'u nétilh'a' nts'u yoodutaskut ha, nyun eh whusatányalh-un inli, k'us 'uyoon tilah hats'itó'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","'Et 'aho mbene la ndudane 'ink'ez ooka cha, 'ink'ez ntsi'-i nududeh-i ooyudindane, 'enne cha lhane whe soo na'balh'en. Hoos̱'enne, 'enne cha huhoo'en-un butl'anáhon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","'Et Sizi John yugha hodul'ehne ubulhni, “John ts'u naht'us. Ndet whunilh'en-un 'ink'ez whudáhts'o-un 'et dóhni', nts'en'a la hoos̱'enne huhoo'en nasdli'. Nulhúsdilne, 'enne nahúdilhne nahusdli'. Buka nódutsi', leprosy huyulhni, 'enne cha butsun hooloh nasdli'. Lhe'dusts'one, 'enne cha 'ahudits'o nahusdli'. Yaidlanne cha dunahudidil. Tel'enne, 'enne cha khuni unzoo-i, 'i be bubulh yaínduk whe' hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","'Ink'ez mbene la si sgha ooba dzoh lhúhoolohne, 'enne 'uk'enus hoonzoo-un bughá whutalts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'Et John khuni yuba na'áne whenáhit'az whe 'et 'awet Sizi John ghu yatilhduk whe 'ilhunaoosdilne nja dúbulhni, “Dune lhuhoot'ih ts'e ndet hukwa tse hoohli whutih'elh-un? Tl'o ghazilh nónulhts'i, 'i tilah tih'elh nahzun eh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ndet suba hukwa tse hoohli whutih'elh-un? Dune naih duchut-i be soo naduja, 'en tilah tih'elh nahzun eh? 'Alha ndiz whuz un'a soo nadut'ihne, 'enne lhai sooneya ts'iya hulhtsih 'ink'ez lerwe ooyoh huwhut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","'Et ndet suba hukwa tse hoohli whutih'elh-un? Nus hoo'en-un tilah? A! 'Alha nohdusni nus hoo'en-un ba nus unzoo-un 'et nulh'en! ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","'En ghun 'uk'une'usguz inle' whe nja dutni, ‘Soo zilhts'ai, khuni sba na'a-un, 'en ntso tis'alh. 'En ntso ti lhutanyalh-un, mba lhaoodutileh 'et wheni.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Alha nohdusni, nus hoo'enne mbene la whuzdline, 'enne butoh John dune too be 'ulh'en-un, 'en 'uk'enus ncha-un 'unt'oh. 'Et hoonts'i nts'e la Yak'usda whulerwe unli-un, mbe la 'udeyo 'unt'oh-un, 'en yanus uncha-un unli.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ts'iyanne dune 'ink'ez sooneya nalhdzoohne, Sizi daja ni hidants'o whe Yak'usda buba 'alha' yija, John 'enne too be' balh'en 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","'Et hoonts'i ndunne Phariseene 'ink'ez Moses be 'udustl'us k'ut daja ni whe 'uyoo unli be yalhdukne, 'enne ts'iyawh Yak'usda nts'e la buts'u hukwa' ninzun-un, 'ants'i 'un huhutilhdil. 'Enne 'aw John too be lhé'bilel 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","'Et neMoodihti diz un'a ubúlhni, “Dunene 'andit yuk'edúdehne nts'en'a suba nohba lhzih nebosdlelh, k'us dant'ohne dune hinli, 'et nohdutásnelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Diz un'a nja duhínt'oh, ts'oodunneyaz duhúlt'oh whe huya'alh-i be 'óoket-un 'et hudilhts'i. 'Ink'ez lhts'u háhudih whe nja dulhódutni, ‘Be ts'ujun-i be nohba ts'ujun, 'et hoonts'i 'aw lhnuzahdai. 'Ink'ez nohba ts'odi ts'inli, 'et hoonts'i 'aw lhuzahtso!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Soo cho whunulh'en, John dune too be 'ulh'en-un whusainya whe 'aw lhes lhus'al 'ink'ez ts'ekoo too' cha lhusnai'. 'En udáhni ‘Ntsi'-i nududeh-i ooyudinda,’ dahni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Et yinka dune ye' whusainya, 'a'alh 'ink'ez 'utnai. 'Et 'udáhni, ‘Ndun dune 'en oocha hooncha 'ink'ez tanutnai. Sooneya 'ilhunaoos'aih-un 'ink'ez lubeshi 'ulh'enne, 'enne buk'eke,’ dáhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","'Ink'ez ndunne hiye whunih-i na'dudil'ine, 'enne bugha ndi be whútnih-i, 'i ts'ih'un un'a 'uhóoja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","'Et Pharisee 'ilhoghun yughu nusíya dudulh ná'oot'alh yulhni. 'Inka whuz ooyoh ts'e yughu danínya. 'Et lutab yooyo 'unt'oh-i yuzih nelget uti'ulh wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Et 'ilhoghun keyoh whut'en-un, 'en lubeshi 'ulh'en-un ts'eke. 'Et Pharisee ooyoh ts'e 'et Sizi 'a'alh yulh údants'o whe whuz whinya. Ndi sooltsun-i dizti'-i, 'i alabaster luboodai bé yulhdzo, 'i whuz yooz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'Et yut'a suyin. Utso 'ink'ez oonatsultoo' ooke k'eidilt'ih. 'I dutsigha' be yuna'ulhdeh, 'ink'ez yuke nadits'ooz. 'Ink'ez ndi sooltsun-i dizti'-i, 'i be yuke yulhtlo. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","'Et ndun Pharisee, mbe la 'anih yudani'-un, dich'oh na'dudutni, “'Et ndun nus hoo'en-un unli de, t'eoonózin da' dant'oh-un ts'eke 'unt'oh yut'ainaih-un. 'En lubeshi 'ulh'en-un 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","'Et Sizi 'uyúlhni, “Simon, hoonliyaz nyudutásnelh.” “Nehodulh'eh-un dini,” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","'Et Sizi 'uyulhni, “'Ilhoghun sooneya 'ughu sulh'ai-un nane dune ghe 'ulh'ai. 'Ilhoghun 'en 500 'ilho unli sooneya, 'ink'ez 'ilhoghun 50 'ilho unli sooneya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","'Aw hiba k'elha hitilhtselh lhihít'ih. 'Inka nahúlt'oh buba whuladitni. 'Et sudini, k'us mbe 'uk'enus yuk'entsi'?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","'Et Simon 'utni, “Si ndunúszun, mbe la 'uk'enus lhai yuba laditni-un, 'en la 'uk'enus yuk'entsi'.” 'Et Sizi 'uyúlhni, “Soo ts'ih'un un'a 'udinja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","'Et ndun ts'eke ts'u nalh'a 'ink'ez Simon 'ulhni, “Ndun ts'eke nilh'en eh? Nyoh danusya whe 'aw too sba 'et nélhinkal ske be tunatisgus huba. 'Et hoonts'i ndun ts'eke dunatsúltoo' be ske nainilhtsul 'ink'ez dutsigha' be yuna'alhde. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nyun 'aw na'duts'oos be hadih sulhdínel. 'Et hoonts'i ndun ts'eke 'udechoo danínya whuts'un 'aw ske naduts'oos-un 'etsul lhe'ínel. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","'Aw stsi khe be lhilhlhoh 'et hoonts'i ndun ts'eke ndi khe be ske yulhtlo. ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'Et huwa nyudusni, oolubeshi lhai ts'iyawh ooba whunaoodízno. Nilh'en eh lhetube skentsi' whe 'unt'oh? 'Et hoonts'i mbene la ntsool-iyaz lubeshi buba hooloh unline, 'enne hoonts'i dzoh ts'ulya skehintsi'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","'Ink'ez Sizi ts'eke ndúyulhni, “Nlubeshi ts'iyawh mba hooloh suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","'Et ndunne 'onghohne lutab k'ut na'ut'alhne, 'enne dich'oh 'ulhodutni, “Ndun mbe whe 'unt'oh? Lubeshi 'i hoonts'i yuna'alhdeh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","'Ink'ez ts'eke ndúyulhni, “Mba 'alha' hoont'oh-i, 'i be dinjih. 'Et 'awet ndzi dizghel whe naindalh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","'Et hukw'elh'az 'et Sizi kedutizut keyoh whucho 'ink'ez keyoh whuyaz totsuk, ndet whe la Yak'usda lerwe unli, 'et huwun khuni unzoo-i be yatilhduk. 'Et ndunne whunizyat 'on 'at nane, 'enne cha huyulh 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","'Ink'ez ndunne ts'ekoo 'enne cha huyulh 'ut'en whe ntsi'-i nududeh-i buyudinda 'ink'ez buka nódutsi, 'enne ts'iyawh soo na'binla. Mary Magdala whut'en-un, 'en cha 'ut'en. 'En 'unt'oh lhtak'ant'i ntsi'-i nududeh-i 'en ooyáha naidide. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","'Ink'ez Joanna, Chuza oo'at, 'et Chuza, 'en Herod yoh dilhts'ine bumoodih unli, 'en oo'at 'ink'ez Susanna cha 'ink'ez 'uyoonne lhane cha, ndai la huyut'i-i, 'i be hila 'ut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'Et njan dulcho keyoh whut'enne 'ilhuhozdil 'ink'ez Sizi nawhutnuk-i be whuts'odul'eh-i, 'i be yatilhduk, ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“'Ilhoghun 'a'nule-un 'en 'a'untilelh ha. 'Et 'a'nule whe 'et ndi ninutsut whe 'et ooloh tinch'oh nanánkat. 'Ink'ez hik'ut nusúdil 'ink'ez 'et dut'aiyaz cha ts'iyawh yunildil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","'Et ooloh cha tse toh nanánkat. 'Et ndet la hánuski whe 'et ndi hanulhyeh-i too hooloh 'et huwa yanúdizgi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","'Et 'onghoh-i cha whus cho tanínkat. 'I cha whus cho bulh dúduninyai 'ink'ez bulh lhéwhultloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","'Et 'onghoh-i yun unzoo-i k'ut nanánkat, 'ink'ez hánuski. 'Ink'ez oomai' 'i lhan'un te lhai suli' whunizyat whunizyai 'et 'ultsuk suli'.” 'Et hukw'elh'az 'et tube cho 'ubulhni, “Mbene la oodzo hoonine, 'enne huyoozólhts'ai' huba' hoont'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","'Et yugha hodul'ehne huyoodulhkut, “Ndi be whuts'odul'eh-i, 'i daja ni whe 'utni?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","'Et 'ubúlhni, “Ndi buba whe' hoont'oh hooyoh-un Yak'usda lerwe unli-i, 'i ghun, t'eoonoohzeh ha 'uda' nohtl'ahóolts'ut. 'Et hoonts'i 'onghohne be whuts'odul'eh-i, 'et whuz un'a za bubulh yasduk. 'Et whe doo ka la, ‘Honalh'en 'et hoonts'i 'aw lhuhuhoos̱'en. 'Et hodits'o 'et hoonts'i 'aw t'ehonuszun daja ni.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ndi be nawhutnuk-i be whuts'odul'eh-i, ndi 'et ndutni. Ndi 'anukat-i, 'i Yak'usda ooghuni 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mbene la ti 'unt'ohne, 'enne Yak'usda ooghuni hidits'o 'ink'ez netsudule ndi khuni budzi be hanaídan'aih. 'Et whuz un'a 'aw buba 'alha lhe'hoot'oh 'ink'ez 'aw hudoojih ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndai la tse toh nanánkat-i le'unt'ohne hodits'o 'ink'ez huhóont'i' whe khuni huyilhchuk. 'Et hoonts'i 'aw bughih hooloh. 'Et huwa 'atsulyaz buba 'alha' hoont'oh. 'Et 'aho bé tank'us uznint'i-i, 'i be tinch'u nahuskat, 'enne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndai la ndi whus cho toh nanánkat-i 'et nja duwhutni, dune Yak'usda ooghuni hidits'o 'et hoonts'i ndi yun k'ut huwu ni ts'inli-un, ndi yun k'ut hoonzoo' hoont'oh-un, 'ink'ez ndai la ndi yun k'ut huhoont'i' tune' hut'en-un, 'i ts'iyawh whus cho 'i be bulh lhellhoh dult'oh. 'Et huwa 'aw lhadúlyane hoole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","'Et hoonts'i ndai la yun unzoo-i k'ut nanánkat-i, ndiz un'a nja duwhutni, 'enne huhóont'i' whe khuni hidants'o 'ink'ez budzi unzoo whe huyoontun. Nts'oh dahoont'oh hoonts'i 'ilhiz huyilhchoot. 'Et whuz un'a bumai' lhai tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Dune too dizk'un 'ink'ez 'i nahidilhk'aih 'ink'ez 'aw oosa' yuk'uz yo nádoo'ah ait'oh. K'us lili t'a ts'e ayoo'alh ait'oh. 'Et nts'e la too dizk'un-i hukw'us'ai-un, 'et hukw'e yin'ai. 'Et de mbene la dandílhne ts'iyawh hinoolh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ndiz un'a 'et dúhoont'oh, di la nist'i-i, 'i hoonts'i nus de 'et ts'iyawh haootikulh. Di la whu'iz 'uts'ulh'en hukwa' ts'ut'en-i, 'et hoonts'i ts'iyanne t'ewhuntizeh. 'I ts'iyawh ndet la hoot'en-un, nus de ts'et haootikulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","'Inka soo cho howahli nts'en'a la ndi khuni dutáhts'o. Soo ts'ih'un 'alha mbene la hoontsool-unyaz t'ehonínzunne, 'enne 'on 'us lhat-un t'ehonínzun-un, 'et bugha whútalts'ulh. 'Ink'ez mbene la hoonli t'ewhunúszunne, hoonts'ool-unyaz hodits'o, ndai la 'aw 'i huyut'i-i huninzun, 'i hoonts'i bughu nayitálchulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Et 'awet ooloo 'ink'ez bulhutsinke te, hits'u hukwa' hut'en. Dune lhai k'et 'aw hiyenghoh neooya' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Whulohne 'et ndúhuyulhni, “Nloo 'ink'ez nyulhutsinke te 'az nodilhya, nyoti'elh hukwa' huninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","'Et 'ubúlhni, “Mbene la Yak'usda ooghuni yoozílhts'aine 'ink'ez hik'une' 'ut'enne, 'enne sloo 'ink'ez sulhutsinke hinli, whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","'Et hukw'elh'az 'ilhoh dzin yugha hodul'ehne bulh ts'i be handil. 'Ink'ez “Nyan uztooke',” ubúlhni. 'Et 'awet nus huzki. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nus huzki whe Sizi 'aho nanisti. Khunsul bubulh taoodilts'ut 'ink'ez 'awet ts'i too be tádutih. 'Ink'ez tube howa óodli wheninle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'Inka ts'enahuyulhts'it, “NeMoodihti, neMoodihti, 'awet too netighan!” huyúlhni. 'Et ts'enandzut, 'ink'ez dudinya whe too k'ut nilhts'i khuni ulhtus-i be hukwa' yulhni. 'Et 'aho k'oh 'úhooja 'ink'ez dínghel. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","'Et “Nohba 'alha' 'ust'oh-un, dáhooja?” ubúlhni. Ts'iyawh whehunilhjoot 'ink'ez buba hooncha. 'Et 'ulhodutni, “Ndun dune, 'en mbe unli whe 'unt'oh? Nilhts'i 'ink'ez tatsi 'i hoonts'i ndahne yulhni te yuk'une' 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Et 'awet Gadarene yun k'ut yahuzki. 'Et njan 'et Galilee whanch'az whuz'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","'Et dehainya 'et 'aho dune 'et keyoh whut'en-un yududizya. 'En sa' whuts'un ntsi'-i nududeh-i lhai ooyudúlts'i. 'En tsan yit nuya, 'ink'ez 'aw yoh lhiloh, 'et ts'un k'ut whut'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","'Et Sizi yutilh'en whe yuts'u huyih 'ink'ez yubut nachániti. 'Ink'ez tube cho yuts'u tédudli, “Sizi nyun soo 'udedo Yak'usda ooYe' 'int'oh! Ndet sts'u hukwa' ninzun? Nts'u tedusdlih, dzoh nusilhdzut iloh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","'Et 'uda' ndi ntsi'-i ndudeh-i khuniti be ubulhni ndun dune ye yáhanadoodeh ha. 'Oh da' lhuztih tl'ool be huyulhghel oola 'ink'ez ookechun cha, 'et whuz un'a highunli inle'. 'Et hoonts'i lhat whe ndi ntsi'-i ndudeh-i yilhchuk whe ndi lhuztih tl'ool tániduch'as 'ink'ez ndi ntsi'-i nududeh-i, 'en dune lhuhoot'ih ts'e whuz whéneyukw. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","'Ink'ez Sizi 'en yoodulhkut, “Ndai la nyoozi'?” “Legion,” yulhni. Lhane ntsi'-i nududeh-i ye yudúlts'i 'inka 'utni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ntsi'-i nudúdeh-i Sizi hits'u tedudli 'et nyo tsak'et whucho whutl'ah hooloh-un, whuz te netolh'a' junih, huyúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","'Et lhai nilhdukw-un gugoos whenun núlh'as. 'Et ntsi'-i nududeh-i Sizi hits'u tedudli gugoos ooyúdoodeh ha. 'Inka 'et butl'ahon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'Et ntsi'-i nududeh-i dune, 'i oots'u haídande whe gugoos yudánde. 'Aho gugoos bubulh whenghu hílghaz 'ink'ez too ubanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","'Et ndunne gugoos ghunline dahooja-un honalh'en whe ts'iyawh whehílghaz. Hidulh whe 'et keyoh whunat whut'enne 'ink'ez 'et keyoh whut'enne ts'iyawh hubodáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Et ndunne dune hodánts'o whe 'et whuz whehándil 'ink'ez honalh'en. 'Et Sizi highu nindil whe 'et ndun dune mbe la ntsi'-i nududeh-i oots'u hanaídide-un, 'en Sizi yuk'etl'a usda whe hinalh'en. Naih be dune unli 'ink'ez beni cha oogha nádilts'ut whe soo 'unt'oh. Ts'iyawh hinalh'en 'ink'ez hunílhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","'Et mbene la dahooja-un honalh'enne, 'uyoonne cha hudáni' 'et dahooja la ndun ntsi'-i nududeh-i ooyudinda-un 'awet dujih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","'Et la ndunne Gadarene whut'enne 'et whunat whut'enne ndulcho whe hunílhjoot. 'Et huwa Sizi buch'a naooja' huyúlhni. 'Inka ts'i be naja 'ink'ez nahutikelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","'Et ndun dune mbe la ntsi'-i nududeh-i oots'u hanádide-un, 'en Sizi yuts'u tedudli yulh útinelh hukwa' ninzun. 'Et hoonts'i Sizi whenáyalh'a' 'ink'ez 'uyulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nyoh ts'e naindalh 'ink'ez dáhoolcho whe Yak'usda mba daja la, ts'iyawh budóni'.” 'Inka whenaja 'ink'ez keyoh ndulcho whe ts'iyanne Sizi dahoolcho yuba' hóonla-un ts'iyawh 'et huwun dune dáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","'Et 'awet nyan whenaki. Ts'iyanne Sizi hónuta whe whusanaki ts'iyanne hóont'i' hinilh'en whe. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Soo yanáski ibulh 'aho dune Jairus yughu ninya. 'En Lizwif bulugliz whumoodih 'unt'oh. Yubut nachaniti 'ink'ez yuts'u tedudli duyoh ts'e yulh nátoot'as ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","'Ilhoghun za ootse', whunizyat 'on 'at nat be yus k'ut at'en-un. 'En 'awet dáwhenintsai. Sizi Jairus ooyoh ts'e yulh nátist'az. 'Et 'awet 'ilhozdilne lhane higha óozdil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","'Ilhoghun ts'eke tube dzoh nuzut whunizyat 'on 'at nat yus k'ut 'et dúwhulyiz whe 'uskai' 'uyulh'en-un, yoo be dúyunne lhane cha hukwa' huyalh'en. 'Et hukw'uz duzooneya ts'iyawh gak yulhtsi, 'et hoonts'i nus za lhe'ínelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ndun 'en ts'eke Sizi yut'a ts'e yughu ninya 'ink'ez nayits'uz-i yus ts'e ooban 'et yut'aiznai. 'Et 'aho uskai' 'uyulh'en-un 'etsul 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","'Et Sizi 'utni, “Mbe 'uja st'aiznai?” “Ts'iyawh wheni iloh 'uts'uja,” hutni. Peter 'ink'ez mbene la yulh 'ut'enne, 'enne 'uhutni, “Nemoodih lheltsukne nyando hahuníldo 'ink'ez nyuhoolhkalh. 'Ink'ez di ha dini ‘Mbe st'aiznai?’ dini?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","'Et Sizi 'utni, “T'eoonuszun 'ilhoghun st'aiznai. Be stus-i sts'u hadílts'ut t'eoonuszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","'Et ndun ts'eke t'eoonanzin 'aw yuch'á ntool'ih ait'oh. Dutlut whe yughu ninya 'ink'ez yubut nachaniti. 'Et ts'iyanne nalh Sizi 'uyulhni ndet huwa yut'aiznai 'ink'ez daja whe 'aho soo ná'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","'Ink'ez 'uyulhni. “'Ustse' mba 'alha hoont'oh 'et huwa soo na'inja. 'Awet ndzi dizghel whe 'int'oh naindalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","'Et 'Awhuz ndun ts'eke yulh yalhduk whe Lizwif bulugliz whumoodih ooyoh usda-un, 'en yughu ninya 'ink'ez 'uyulhni, “Ntse' dazsai. Whute ndun dune hodulh'eh-un, 'aw 'on 'un dzoh nilhdzut iloh. 'Awet dazsai whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Et Sizi yulh údants'o whe Jairus 'uyulhni, “Whenoljut junih, 'ants'i mba 'alha' hot'e', 'ink'ez la soo na'titnelh whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","'Ink'ez yeyoh ts'e daninya. 'Et 'aw 'uyoonne cha dalhoosya'. Peter, 'ink'ez James, 'ink'ez John, 'ink'ez ndun ts'oodun oobá cha 'ink'ez ooloo cha, 'enne za dahóodilh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","'Et ts'iyanne tso yahalhduk 'ink'ez hik'etedudli. 'Et Sizi 'ubulhni, “Ahtso iloh! 'Aw dalhitsal 'ants'i nanisti whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","'Ink'ez ts'iyawh highudloh, t'ehonínzun dazsai whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sizi ts'iyawh tenábunilh'a', 'ink'ez ts'oodun yula ilhchoot 'ink'ez, “Ts'oodun dudinyaih,” yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ooyughi ooyunaídide 'ink'ez 'aho dudinya. 'Ink'ez oodusneke ubulhni, “Hoonliyaz yuti'ulh-i oogha náh'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Oodusneke tube buba hooncha, 'ink'ez khuni ulhtus-i be ubulhni, “'Uyoonne dóhni' junih njan bulh dáhooja-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","'Et whunizyane 'on 'at nane yugha hodul'ehne Sizi 'alhgoh buka' dani'. Ntsi'-i nududeh-i, 'i ts'iyawh ndet la whehílhtus-un cha, 'ink'ez himoodih hoole' ha, 'et bugha óonin'ai. 'Ink'ez dune ndet hukw'e hunduda-un, 'et cha soo na'boohoolh'en, 'et cha bugha óonin'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'Uyoonne nts'en'a la Yak'usda lerwe unli-un 'et huwun ubulh yalhduk 'ink'ez ndudane soo na'boohooleh, 'et wheni whebalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","'Ink'ez ubulhni, “Nts'e la tihdulh ts'e khun hoonliyaz toohla' junih. Nohtuz, 'ink'ez lhook'ez, 'ink'ez lhes cha, 'ink'ez sooneya cha, 'et ndunt'oh-i toohla' junih. Nanki dzoozt'an nyiz-i ooht'e' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndet yoh danáh'az-un, 'et za oohke', 'ink'ez 'et yoh za whenádoht'as. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Et mbene la danáh'as lhuhonohdúsnine, 'et keyoh howu natiht'us whuts'o, 'et whulez ch'a nohke naóohghat. 'I gha la t'ehonózin buk'ehóotalts'ulh-un 'et buts'u hóolts'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","'Inka whenáhidil 'ink'ez keyoh totsuk whutulh lhunáhusdil. 'Et whuz un'a dune khuni unzoo-i be bubulh yahulhduk. 'Ink'ez keyoh totsuk dune soo na'hulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","'Et 'awet lerwe Herod huyulhni-un whulh udants'o nts'oh te Sizi ne'ut'en. Whulohne nduhutni, “John yaidlanne butoh nahitna', 'en 'unt'oh,” hutni. 'Et huwa ba nawh 'uhooja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","'Ink'ez 'uyoonne cha 'uhutni, “Ndun 'en Elijah 'unt'oh whe nenalhts'et hainya.” 'Et 'onghohne cha nduhutni, “'En 'uda' yinka Yak'usda be nus hoo'enne, 'ilhoghun nakhítna'-un 'ink'ez 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","'Et Herod 'utni, “John ootsi k'únist'o inle'. 'Et hoontsi' mbe whe 'ut'en ndun lhe'hoont'oh te ne'ut'en-un bulh 'údusts'o?” 'Ink'ez yuti'elh hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","'Et ndunne whel'a'ne whusanáhidil whe dahít'en-un, 'et ts'iyawh hidani'. 'Ink'ez “Dugwe', uztoodilh!” ubulhni, 'ink'ez njan Bethsaida keyoh whunat disoh ts'e whébanla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","'Et hoonts'i 'ilhozdilne nahoohoon'ai whe huyuntizdil. 'Et Sizi hoont'i' whe highu nindil 'ink'ez nts'en'a la Yak'usda lerwe unli hukw'un'a huwun ubulh yalhduk. 'Ink'ez mbene la soo na'titnelh hukwa' ninzunne, 'enne cha ts'iyawh soo ná'balh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","'Awet ts'etniz hukw'elh'az yoo'un hoozulh-un 'ink'ez ndunne whunizyat 'on 'at nane, 'enne highu nindil 'ink'ez 'uhuyulhni, “Ndunne 'ilhozdilne nabalh'alh njan disoh-un 'uts'int'oh. 'Et la ndoho keyoh whunat huya'alh-i hoket 'ink'ez 'et la hutitez-un cha nahohólelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","'Et hoonts'i Sizi ndúbulhni, “Hoonliyaz huyoo'alh-i bugha nánuht'aih.” 'Et 'uhuyulhni, “Lho nanki 'ink'ez lhes kwulai' cha, 'aw 'i za ts'ut'i. 'Et ndunne 'ilhozdilne t'alh-i buba ts'onket de, 'et de za soo bugha ná'uztit'ulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Et njan 'ilhozdilne 'ankw'us 5,000ne dune hinli. 'Et Sizi yugha hodul'ehne ubulhni, “Kwulat whunizyanne hinli whe lhendun natl'ahudoolts'ilh budáhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","'Et whuz un'a huja. 'Et 'awet ts'iyawh natl'ahudilts'i whe ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","'et kwulai' lhes yilhchoot 'ink'ez lho nanki cha, 'et ndo whunalh'en 'ink'ez musi ni whe yuba tenadidli. 'Et taidanyuz 'ink'ez yugha hodul'ehne butl'ayánla, 'ilhozdilne bugha húyo'alh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ts'iyawh 'uhan'al 'ink'ez soo' huja. Ndai la ch'utizkat-i ts'iyawh nahuyalhdzoo whe whunizyai 'on 'at nanki chalhyal dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","'Et hukw'elh'az Sizi didutch'oh gaih tenadudli 'ink'ez yugha hodul'ehne huyulh 'ut'en 'ink'ez uboodulhkut, “'Ilhozdilne, mbe usdli hutni?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","'Ink'ez 'uhuyulhni, “John dune too be 'ulh'en-un 'int'oh hutni. 'Et 'onghohne cha Elijah 'int'oh hutni. 'Ink'ez 'onghohne cha hutni 'uda' nus hoo'enne, 'ilhoghun dunadija-un, 'en 'int'oh, hutni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","'Et, “Nohni do'?” ubulhni, “Mbe usdli dahni?” Peter yatilhduk whe 'uyulhni, “Mbe la Yak'usda ooChrist ts'utni-un, 'en 'int'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","'Et khuniti be 'ubulhni, “Khun te 'uyoonne te dóhni' junih!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","'Ink'ez 'ubulhni, “Yinka dune ye' lhat-un whé dzoh nutizut ooba' hoont'oh. 'Ink'ez ndunne tso whudilhdzulhne cha, 'udedo lubretne cha, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'enne ts'iyawh hich'az dútatni whe' hint'oh 'ink'ez 'et hituzilhghelh. 'Ink'ez whulh tat dzin dunadutádalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","'Ink'ez ts'iyawh úbulhni, “Mbe la dune se' 'ut'en k'oh ts'e oot'en ha hukwa' ninzun-un, 'et ndunt'oh-un ndai la dats'ínt'oh-un, ts'iyawh whuladootnih 'ink'ez dzin totsuk dutulalhgus yólhchoot 'ink'ez suntooya'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","'Et huwa mbene la whe húkhuna-un hotilhyihne, 'enne 'et hoonts'i ninta huhúta'alh. 'Et hoonts'i mbe la whe khuna-un si sgha ninta oonin'ai de, 'en whe hukhuna-un hotilhyih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","'Et dune ndi yun k'ut ndulcho whuch'a oonilhde de, 'et hoonts'i didutch'oh ye khuna-i ninta nín'ai k'us ye khuna-i yugha nahootálhchulh de, 'et ndet suba whuch'a hólhdeh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Et mbene la dune si cha 'ink'ez sghuni cha yukayá unli-un, 'et de yinka dune ye', nts'o de dich'oh ye dizti'-i cha, ooBá ye dizti'-i cha, 'ink'ez Yak'usda oolizas hiye dizti'-i cha, 'et whuz un'a whusanaja de, 'et 'oh de bukayátileh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Alha nohdusni, whulohne njan nudilhyanne ndet la dahutitsah-un 'et whuts'un ndet la Yak'usda whe lerwe unli-un, 'et dahutitsa whutso hoti'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Lhk'udit dzin at'en hukw'elh'az 'et nja dutni-un, 'et Peter, John, 'ink'ez James ndo dzulh k'uz dulh úbilya, whuz tenadutidli ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","'Et 'awhuz tenadudli whe 'et oonin ts'e 'uts'un oonat'en suli'. 'Ink'ez oonaih cha soo ts'ih'un 'ulhyul suli', 'ink'ez oots'u ha' 'ánduz cha 'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Khunsul nane dune, 'enne hiyulh yálhduk. 'Ilhoghun Moses 'ink'ez 'ilhoghun Elijah. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Busaoolkalh 'ink'ez be hóodat'en. 'Et Jerusalem ts'e datinelh whe datítsah-un lhaóodutileh, 'et huwun huyulh yálhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","'Et Peter 'ink'ez yulh 'ut'enne sa' tube hantez. 'Et ts'ih'un un'a t'enawhehunide whe 'et Sizi oots'u hayánduz-i, nane dune yuzih usyin whe hitilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","'Et hukw'elh'az 'ink'ez highu whin'az whe Peter Sizi 'uyulhni, “Nemoodih hoonzoo njan uzdilhts'i. Tat-un whut'ah uztitez-un 'uts'oohooleh. 'Ilhoghun nyun mba, ilhoghun Moses ba, 'ink'ez 'ilhoghun cha Elijah ba.” 'Et hoonts'i Peter daja dutinelh 'aw t'eoonuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yalhduk whe kw'us buk'einde. 'Et kw'us bunasut'i whe 'et whe hunilhjoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Kw'us toh ts'e khuni huduzts'ai, “Ndun sYe' 'en ookw'esi'-un 'unt'oh. 'En oozóolhts'ai,” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","'Et yaduk-un 'etsul 'uwhudija whe Sizi dich'oh za 'unt'oh whe hinilh'en. 'Et 'aw hoonliyaz lhe'hudínel ndet hohon'en-un. 'Et 'oh da' dzin 'aw dune lhodínel nts'en'a hinalh'en-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","'Et 'om bun dzin shus k'ut ts'e hanáhidil whe 'ilhozdilne Sizi hidudizdil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Ilhoghun dune 'ilhozdilne butoh Sizi 'últus-un yuts'u háyih whe nja dúyulhni, “Hodulh'eh-un nts'u tédusdlih sye' nolh'en. 'En 'aw 'ilhoghun syaz 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","'Et khunsul ntsi'-i nududeh-i yilhchuk ibulh hazulh, ookaootuzuk, 'ink'ez huwus oozá hanúldoh. 'Ink'ez tube howa whúlna whe ye yáhanadudoh. 'Et huwa ndulcho whe ooka hootsulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'Inka nye hódil'e'ne buts'u tédusdli hits'u hanáhidoolhdeh ha 'et hoonts'i 'aw 'uhooneh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","'Et sizi 'utni, “Nohni 'andit whudizulhne 'alha 'aw nohba 'alha lhe'hoot'oh. Nohni dune 'aw ts'ih'un lhe'it'ohne ahli. Dawhuldzoh nohtoh 'utist'elh whe nohbulh óosyin? Nye' sts'ílhtelh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","'Et 'awhuz Sizi ts'u yilhtelh whe ndi ntsi'-i nududeh-i nayáno 'ink'ez yukaootilhzut. 'Ink'ez Sizi ntsi'-i nududeh-i khuniti be 'uyulhni 'et whe khuniti be hukwa' yudáni', 'ink'ez ts'oodun soo na'uja whe oobá tl'anáyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","'Ink'ez Yak'usda daltus la 'et huwa ts'iyanne buba hooncha suli'. 'Ink'ez Sizi nts'oh tula ne'ust'en-un buba hooncha k'et, 'aw buk'ohoodózit ait'oh. 'Oh da' za yugha hodul'ehne 'et 'úbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ndi khuni be nohbulh yatisduk-un, soo cho nohdzi be whudoolts'it. 'Awet nilhdukw yinka dune ye', 'en dune ntsi'ne tl'atiltelh k'une' hitil'en ha.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","'Et hoonts'i njan daja ni-un 'aw ts'ih'un t'elhehonízil. 'Aw buba ts'et ha lhúhoolts'ulh. 'Et huwa daja ni, 'aw ts'ih'un nelhúhuhoo'al. 'Et hoonts'i whehúnuljut, 'aw hukwa huyoodolhkut ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","'Ink'ez dich'oh dutoh lhdulhyoh 'ahudutni k'us mbe 'uk'enus uncha-un tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Dudzi yo whe daja huninzun Sizi t'eooninzun. 'Et huwa 'ilhoghun ts'oodunyaz yílhchoot 'ink'ez duzih neyulti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","'Ink'ez ubulhni, “'Et soo ts'ih'un un'a 'unohdusni, mbene la soozi' gha ndun ts'oodunyaz hik'esutsitne, 'enne sk'ehintsi' whe' hint'oh. 'Ink'ez mbene la sk'esutsitne, 'enne mbe la whuz de sútilh'a'-un, 'en cha hik'esutsit whe' hoont'oh. 'Et huwa, mbe la nohtoh-un 'uk'enus dune ba tel'en-un, 'en 'uk'enus ncha tileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","'Et John 'uyulhni, “NeMoodihti 'ilhoghun dune nyoozi' be ntsi'-i nududeh-i dune buts'u hanaídulhdoh, 'et ts'uhon'en. 'En 'aw nebulh 'ilhoghun lhiloh, 'et huwa 'et dut'en-un whuch'az níyoot.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","'Et hoonts'i Sizi 'uyulhni, “Whuch'a nahyoot iloh! 'Alha mbe la 'aw nech'az úlhditni-un, 'en nets'ú ditni-un 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","'Et 'awet Sizi ooba whusaóodanzut ndo yak'uz nátidalh-un huba, 'et 'awet Jerusalem whuts'u nalh'a 'ink'ez whuz natidalh-un howun nanínuzut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Khuni yuba na'ane dutso whe balh'a'. 'Enne hutizdil whe 'et 'awet 'ilhoghun Samaria keyoh ts'u hoozdil hiba lhaoodutileh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","'Et hoonts'i Jerusalem ts'u tizya-un 'et nahuhoon'ai whe njan keyoh Samaritan whut'enne 'aw hikalhe'nízun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","'Et yugha hodul'ehne James 'ink'ez John honalh'en bulh dahooja la whe Sizi huyoodulhkut, “NeMoodihti Elijah k'un'a ndi kwun ndus de yak'uz ts'e hadóonat 'ink'ez ts'iyawh hadók'un uzdooni', 'et eh neba hukwa' ninzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","'Et hoonts'i buts'u nálh'a 'ink'ez hukwa' budani', 'ink'ez 'utni, “'Aw daja nahzun t'ewhunuzáhzun 'et huwa' dahni! ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Soo cho soo zúlhts'ai, yinka dune ye', dune ye khuna-i musai yutilhtselh ha iloh whusainya, ubutilhyih ha whusainya.” 'Ink'ez 'et 'udun keyoh whuyaz ts'e whehándil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","'Awet ti hidulh whe 'ilhoghun dune Sizi yughu ninya 'ink'ez 'uyulhni, “SMoodihti nts'e la tínya ts'e ts'iyawh nyun tisyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","'Et Sizi 'uyulhni, “Nanguz 'enne cha 'an whut'i whe' 'unt'oh 'ink'ez dut'aiyaz cha t'o ut'i. 'Et hoonts'i yinka dune ye', 'aw tsén tal'al-un 'et hoonts'i lhuhóot'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","'Et 'uyoon cha 'ulhni, “Nyun cha sunanyalh.” 'Et hoonts'i 'uyulhni, “SMoodihti, k'at 'udechoo sbá oozi 'aóostelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","'Et hoonts'i Sizi 'uyulhni, “Whute dudulh yaidlanne didutch'oh 'analhuhoolyelh. 'Et hoonts'i nyun ndulcho whe nónya' 'ink'ez ndet la Yak'usda lerwe unli-un, ts'iyanne 'et huwun budóni'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","'Et 'uyoon cha 'utni, “SMoodihti nyun tisyalh, 'et hoonts'i 'udechoo snatneke syoh ts'e buts'ú nunatisdalh-un 'ink'ez 'ilhiz wheni nohghu tisyalh budutásnelh, 'et stl'ahóon'aih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","'Et hoonts'i Sizi 'uyulhni, “Mbe la wheoonilhch'ul-un 'ink'ez k'oh naidutut'ih de, ndunt'ohne ndet la Yak'usda whulerwe unli-un, 'et 'aw huba soo lhé'hit'oh whe' hint'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Et hukw'elh'az neMoodihti lhtak'ant'it whunizyane (70) 'enne 'utahábanla keyoh whuti totsuk nutiyalh-un, nane hinli whe dutso whebalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","'Et 'ubulhni, “'Alha 'awet há' nukat-un newhúninzut 'ink'ez tl'o mai' lhai suli', 'et hoonts'i 'ut'enne 'aw soo lhe'huniltsuk. 'Et huwa Yak'usda ha' nukat-un whumoodih, dich'oh 'a'duninla-un 'uyoonne cha 'ut'enne whusáboolh'a', 'et huba tenadahdli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","'Awet ahdulh 'ink'ez soo zúlhts'ai! Lhe'hoont'oh yus 'usbai talgok te howaóodli, 'et whuz un'a nohni cha nohba howaóodli, 'usbai k'un'a yús toh ts'e nohtís'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Aw sooneya zus cha, 'ink'ez lhook'ez cha, k'us kegon cha, 'i dunt'oh-i toohla' junih. 'Ink'ez ti dune dudíh'az de, khun te hadih hoonts'i budóhni' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndet yoh danáhya de, 'et yoh dilhts'ine njan dúbudohni', nohyoh whudóghel oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","'Et dune t'edusni-un 'et usda de, 'et de nohdzi dizghel-un 'et dutá'alh. 'Et 'aw ndunt'oh-un hooloh de, be nohdzi dizghel-i nohts'u nádutilts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","'Et yoh za oohke'. Ndai nohgha húya'aih 'i za ooh'alh 'ink'ez oohnai'. 'Alha 'ut'enne bube 'ut'en k'elha hole' huba' hoont'oh. 'Ink'ez lhelhdun yoh te danaóohdaih junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ink'ez nts'e la 'udun keyoh ts'óozah'az de, 'et 'anih nohuwhútni de, 'et ndai la nohbut nehininla-i, 'i ooh'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","'Et mbe la 'et yoh ndudane, 'enne cha soo na'boohle 'ink'ez 'ubudóhni', ‘Ndet la Yak'usda lerwe unli-un, 'awet nohenghoh 'uhoont'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","'Et nts'e la keyoh ts'oozah'az-un, 'et 'aw nohghu nulhíhiyal de, 'et ti k'enaoohja, 'ink'ez 'udoohni', ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘'Et njan nohkeyoh whulez ndai la neke ghu hoonli-i, 'i hoonts'i, nohch'a búna'ts'alhde. 'Et hoonts'i t'ewhunóhzin huba' hoont'oh, ndet la Yak'usda whulerwe-un, 'et nohenghoh 'uhoont'oh,’ 'et budóhni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Alha ts'ih'un nohdusni, 'et dzin whusaootilts'ulh-un, 'et keyoh Sodom whut'enne, 'oh da' nts'en'a la bubulh dahooja la inle', 'et nja keyoh whut'enne, mbene la nohka lhe'nízunne, 'enne 'on nus hoontsi'-un bugha óotalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“'Et nohni Chorazin whut'enne, 'ink'ez nohni Bethsaida whut'enne, nohni cha 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Soo cho soo zúlhts'ai, ndet la hoolhtus-un nohnat 'uhooja-un, ndunne Tyre 'ink'ez Sidon whut'enne, 'enne bunat 'et cha 'et ndúhooja de, 'uda' da' dudeni náhondunizdla oole' da'. 'Ink'ez da' doso be hudilhts'i 'ink'ez da' kwun lez k'éhidzi. 'Et whuz un'a da' 'uhooneh oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'Et dzin nohba whuz de hoolts'ulh nohba nahutideh ha, 'et ndunne bubulh dawhutanelh-un, nohni 'on nus nohba hootatsi'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Et nohni Capernaum whut'enne ndo yat huba soo áht'oh nahzun eh? 'Awundooh! 'Et k'us kwuncho yo ts'e nóhotilhdulh! ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","'Ink'ez nohni stso tihdulh mbene la nohoozilhts'aine, si cha soo hoozilhts'ai. Mbe la ch'a nohnísjoot-un, si cha ch'a sunísjoot whe' hoont'oh. 'Ink'ez mbe la ch'a sunísjoot-un, mbe la whuz de sútilh'a'-un, 'en cha ch'a inísjoot whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","'Et hukw'elh'az lhtak'ant'it whunizyane huhoont'i' whe whusanáhidil. 'Et nduhúyulhni, “NeMoodihti ndunne ntsi'-i nududeh-i, 'enne hoonts'i, nyoozi' gha nek'une' hut'en!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","'Ink'ez 'ubulhni, “Ditni kwun k'un'a ndus hadúnat, 'et whuz un'a Satan ndus de yak'uz ts'e hadílduz, 'et nus'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Soo zúlhts'ai, tl'ughus 'ink'ez lubezo unli-i, scorpion huyulhni, tube cho ook'unahya. 'Ink'ez ndai la nohch'az ditnine hiye ulhtus-i, 'et ts'iyawh ndi bando 'ooht'e'-un, 'et nohtl'ahóos'ai 'ink'ez 'aw hoonli nohundólhda ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","'Et hoonts'i ntsi'-i nududeh-i nohk'une' 'oot'en huba 'unt'oh, 'aw 'et huwa iloh whunúlhni. 'Et k'us ndo yak'uz nohoozi' ts'iyawh 'uk'usguz, 'et huwa za whunólhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","'Et 'oh whuya 'uhunit'oh Sizi Ndoni be whunílhni whe nja dutni, “'UBá nyun nyudústi'! Yak'uz 'ink'ez yun k'ut huMoodihti inli. Whunihne 'ink'ez hodul'ehne, ndi 'i ts'iyawh buch'á whuntin'i. 'Et hoonts'i ts'oodunyaz le'unt'ohne, 'enne bunalhts'et hahon'ai. 'Alha 'uBá dainja la hoonint'i'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'UBá ts'iyawh stl'ahónla, 'ink'ez 'en ooYe' mbe unli ts'iyanne t'ehonúszun. OoBá 'aw 'en za t'eininzun. 'Ink'ez mbe ooBá unli, ooYe' 'aw 'en za t'eininzun. 'Ink'ez mbe la ooYe' 'onghohne whubuntilhtun hukwa' ninzun de, 'en za ooba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","'Ink'ez yugha hodul'ehne buts'u nálh'a 'ink'ez yooyo whútsul 'ubúlhni, “Ndet la hooh'en-un 'uyoonne duna be honilh'en, 'enne 'uk'enuz hoonzoo-un bugha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nohdusni lhane nus hoo'enne cha 'ink'ez lerwene cha 'enne dalcho-i be ndet hooh'en-un hoti'elh hukwa' huninzun, 'et hoonts'i 'aw lhuhuhóo'el. 'Ink'ez ndet la whudáhts'o-un 'enne cha hidutáts'o hukwa' huninzun 'et hoonts'i 'aw lhohodits'il.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","'Et hukw'elh'az 'ilhoghun Moses be' 'udustl'us 'uyoo unli be yalhduk-un, 'en dudinya 'ink'ez Sizi 'onilha yoodulhkut, “Nehodulh'eh-un datist'elh whe 'ilhiz be ts'ukhuna-i hootáschulh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","'Et Sizi 'utni, “Ndet 'uk'uwhusguz Moses be 'udustl'us k'ut? Ookw'uyailhduk whe nts'en'a mba daja ni?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","'Et ndúyulhni, “Ndiz un'a nja dutni, ‘Yak'usda nyuMoodihti ndzi ndulcho-i be cha, nzul ndulcho-i be cha, nyunut'i ts'iyawh 'i be cha, nyeni ts'iyawh 'i be cha, 'et whuz un'a 'en ook'eoontsi'. 'Et dáhoont'oh hukw'un'a nyunch'oh k'enaintsi', 'et whuz un'a za nyenghoh whut'i-un 'en cha ook'eoontsi'.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sizi ndúyulhni, “Soo ts'ih'un 'udini. 'Et ndint'en de, 'et de 'ilhiz wheni khutanalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","'Et hoonts'i ndun dune ts'ih'un 'unt'oh-un na'dudil'i. 'Et huwun Sizi yoodulhkut, “Mbe la senghoh whut'i-un?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","'Et Sizi nja dúyulhni, “'Ilhoghun dune Jerusalem whe dinya 'ink'ez Jericho ts'u tizya whe 'undunut'ihne huyílhchoot. Oonaih ts'iyawh higha haháyulya 'ink'ez ka huyulhtsi, 'ink'ez 'et nehinilhti, 'ink'ez higho whenádil, 'awet dátsa whe. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Soo 'oh da' za 'ilhoghun lubret ti 'oh whuya uyalh whe ndun 'en yutilh'en. Yutilh'en whe 'ants'i yanch'az lhusiya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","'Ink'ez soo whuz un'a za 'ilhoghun dune Levi ts'u hainzut-un, 'en cha 'oh whuya uyalh whe yunalh'en 'ink'ez 'ants'i yanch'az lhusiya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","'Et hoonts'i 'ilhoghun Samaria whut'en-un, 'en cha 'oh whuya uyalh whe yutilh'en 'ink'ez 'aho yugha te'ninzin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yughu ninya 'ink'ez khe cha yukailhdzo 'ink'ez ts'ekoo too' cha, 'ink'ez yuka' dalh'oo. 'Ink'ez dughuna' k'éyilhti 'ink'ez dune ts'uztez bayoh ts'ú yoolhti 'ink'ez 'et yughunli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","'Et 'om bun dzin tiyalh whutso nanki sooneya ts'uztez whumoodih tl'ayan'ai 'ink'ez 'uyulhni, ‘Ooghonle'. 'Ink'ez ndai la 'on 'un ookw'uz ts'iya-i yilh'i-i whusanásja de mba ookw'elha whutiselh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Et Sizi 'uyoo unli be yalhduk-un 'en yoodulhkut, “'Et ndun mbe la dune untsi'ne 'ankw'us hizilhghi whe ndunne tane dune hinalh'en da', 'et k'us mbe soo ts'ih'un un'a yenghoh whut'i-un 'unt'oh ninzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","'Et 'uyulhni, “Mbe la yugha te'ninzit-un, 'en 'unt'oh!” 'Et Sizi 'uyulhni, “'Awet inyalh 'ink'ez nyun cha whuz un'a za 'et ndónt'en!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","'Et hukw'elh'az hidulh whe Sizi 'udun keyoh ts'oozya 'ink'ez ts'eke Martha huyulhni, duyoh ts'e ghu nuseya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","'Ink'ez bulhtus Mary huyulhni, 'en cha Sizi yucheh usda 'ink'ez yughuni yoozilhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","'Et hoonts'i Martha nts'en'a la bugha ná'tit'alh-un 'et tube 'uníst'et. 'Et Sizi yughu ninya 'ink'ez 'uyulhni, “SMoodihti 'ants'i mba hoont'oh eh sulhtus sich'oh za 'et nesunilhti butaoost'en ha? 'Ink'ez sla oot'en dini!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","'Et hoonts'i Sizi 'uyulhni, “Martha Martha lhat-un la hoot'oh-un howu nuni ninzut! ");
INSERT INTO crxNTpo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","'Et hoonts'i 'aw 'ilhoghun za 'uk'enus nduts'ooneh huba' hoont'oh. 'Et Mary 'uk'enus hoonzoo-un 'utahahón'ai whe' hoont'oh 'ink'ez 'aw oola k'éhahoolts'it ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","'Et 'ilhoh dzin, 'ants'i 'oh ho Sizi tenadudli. 'Etsul 'udija whe 'ilhoghun yugha hodul'eh-un yulhni, “John nts'en'a la yugha hodul'ehne whubodalh'e', nyun cha whuz un'a tenazdutidli-un whuneoodilh'eh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","'Et ndubulhni, “Nja dudahni whe tenadoohdli, ‘NeBá yak'uz sinda. Nyoozi' dóti'. Dahoont'oh whe lerwe inli, 'et cha nets'ó toolts'it. 'Ink'ez ndet la yak'uz ts'e hukwa' ninzun dahooja la, ndi yun k'ut cha, 'et whuz un'a za 'et dúhoneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ndai la 'andit dzin uzti'ulh-i, negha nín'aih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","'Ink'ez 'uyoonne bulh dulhyoh ts'uwhulh'ai de, buba whunats'odoolnoh. 'Et whuz un'a za nelubeshi neba oonaoodolnoh. Nts'e la tank'us uznint'i-un whuch'a neghinli. 'Ink'ez ntsi'-un 'en ch'a néghinli.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","'Ink'ez Sizi 'ubulhni, “Nohni nohtoh mbe 'unt'oh ook'eke hoonli 'ink'ez tuzniz oots'u tíhyalh 'ink'ez 'udutáhnelh, ‘Sk'eke lhes ta sghu sinla! ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Njan sk'eke-un 'ilhoghun sghu ninya. Nilhzaz de hainya, 'aw oogha íyos'alh-i hooloh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","'Ink'ez la yoh whuts'un idóni', ‘'Aw sgha ínai iloh. Dati 'awet dánadilts'ut whe 'unt'oh. Suzkeh te ts'iyawh naznistez. 'Aw dunadósja' ait'oh. 'Ink'ez hoonliyaz ngha óos'alh ait'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","'Et nohdusni, 'aw dunadoja' ait'oh 'ink'ez hoonliyaz yugha óo'alh ait'oh, ook'eke-un 'unt'oh 'et hoonts'i. 'Et hoonts'i whuz yoodulhkut za 'uyulhni, 'et huwa dunadutádalh 'ink'ez ndai yuka' ninzun ts'iyawh yugha ítalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'Et whuz un'a za nohdusni, Yak'usda ndai la ooka yoodulhkut-i nohgha íta'alh. Ookunáhta 'ink'ez nahootáh'alh. Dati dunulhkw'uz 'ink'ez nohba dáha' dutikwus. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'Et mbene la Yak'usda hoonli hits'u hukwa 'utni de, 'enne 'et bugha whútakulh. Mbene la hoonliyaz hukwunútane, 'enne nahuhootá'alh. 'Ink'ez mbene la dati dunulkw'uzne, 'enne cha buba dáha' dutikwus. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Mbene nohbáke nohtoh, ooye' lhes yuts'u ha 'utni de, 'aw tse yutl'adóo'alh ait'oh. K'us lho yuts'u ha 'utni de, 'aw 'i k'et tl'ughus yutl'a oolelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","K'us lugok ghez yuts'u ha 'utni de, 'aw 'i k'et ntsi'-i neoolht'ah-i, scorpion huyulhni, 'i yutl'ayóolhtelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ndiz un'a nja duhoont'oh, nohni lubeshi 'ulh'enne ahli, 'et hoonts'i t'eoonáhzun nts'en'a unzoo-i nohuzkeh gha tíhlelh. 'Et dáwhulcho-i be 'on nus ndo yak'uz nohBá, mbene la yoodulhkutne, Ndoni bugha tí'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","'Et 'awet ndi ntsi'-i nududeh ooyudinda-un 'aw yaoolhduk ait'oh whe Sizi dune ts'u hanaínanyoot. 'Et ts'u hanaínanyoot whe dune yalhduk-un 'awet yawhenilhduk. 'Et 'ilhozdilne ts'iyawh buba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","'Et whulohne nduhutni, “Beelzebul mbe la ntsi'-i nududehne bumoodih, 'en be ntsi'-i nududeh-un dune yuts'u hanainanyoot.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","'Et 'uyoonne huyoolhdzih whe huyoodulhkut, “Yak'uz ts'e whuts'un neba huwa 'it'en tune' tant'en eh, 'et whunenilhtun?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Daja huninzun-un t'eooninzun 'inka 'et dúbulhni, “Nts'e la whulerwe hinli-un, 'enne lhch'az nehúdindil de, 'enne ts'iyawh gak hutileh. 'Et whuz un'a za 'ilhoghun yoh dilhts'ine, 'enne cha lhch'az nehúdindil de, 'enne cha gak hutileh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'Et whuz un'a za nts'e la Satan lerwe unli, 'et didutch'oh lhch'az nedinja de, nts'en'a ookw'úne' whut'en za tileh? Lhe'dahni Beelzebul 'en be ntsi'-i nududeh-i dune ts'u hanánusyukw dahni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Et si Beelzebul 'en be 'ust'en de, 'et de sudahni nohni nohye'ke k'us mbe be suba ntsi'-i nududeh-i dune ts'u hanábonuyukw? 'Et huwa 'enne bugha t'ewhuntihzeh tank'us údahni! ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","'Et hoonts'i Yak'usda oolasga be ntsi'-i nududeh-i dune ts'u hanánusyukw de, 'et 'alha' hoont'oh whe nts'e la Yak'usda whe lerwe unli-un, 'et 'awet nohghu whults'ut whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","'Et dune ulhtus-un lhutigan-un huba lhadint'oh whe, 'et duyoh huwunli 'ink'ez ndai la 'et yuzdla-i, 'aw oot'á'onalh ait'oh de. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","'Et 'uyoon yanus 'ultus-un yundílhda' 'et whe yuch'a' nilhde. 'Et dune ye lhutigan-i yut'aninintan-i ts'iyawh yugha hayulya. 'Et hukw'elh'az mbe la ooch'a' ninde-un ndai la 'et yuzdla-i, 'i cha ts'iyawh 'uyoonne ba lhk'eyanla 'ink'ez butainínla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mbene la sulh lhe'it'ohne, 'enne sch'az huditni whe' hint'oh. 'Ink'ez mbene la 'aw dune sla 'ilhulhósdlene, 'enne ts'iyawh 'ants'i yahitákulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“'Et ntsi'-i nududeh-i dune ts'u hanádide whe, yun whudizgih-un 'et whuz nududeh natilyis-un hukwu núta. 'Et 'aw ndoohóont'oh-un nalhuhoo'al 'inka dich'oh na'dudútni, ‘'Et mbe la ooyudisda'-un, whuz za natoosja'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Et whuz naoodaih te 'ink'ez 'et nahoo'aih ndun dune dudzi yo lhodítsun nawhulhtsi 'ink'ez ts'ih'un na'uja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","'Ink'ez 'et 'uts'un whedudoh 'ink'ez lhtak'ant'ine ntsi'-i nududeh-i 'enne yanus 'ultsi'ne, 'enne 'et dune hiye nádudoh 'ink'ez 'et nehúnih. 'Et ndun dune mbe la hiyudúlts'i-un, 'en 'et whutsoda' whanus 'ultsi' suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","'Et Sizi nja dutni-un hukw'elh'az, 'ilhozdilne butoh 'ilhoghun ts'eke yuts'u huyih, “Mbe la oochan ts'u hainzut-un 'ink'ez mbe la nye 'alht'ukw-un, 'en ts'eke 'uk'enus hoonzoo-un oogha whults'ut,” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","'Et hoonts'i Sizi 'uyulhni, “'Et 'uk'enus hooncha-un 'uhoont'oh, mbene la Yak'usda ooghuni yudits'one 'ink'ez yoontunne, 'enne 'uk'enus hoonzoo-un bubulh 'uhooja!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","'Et 'ilhozdilne lhan'un te nus za lhe'huniltsuk 'ink'ez 'ubulhni, “Njan 'andit whudizulhne dune, 'enne hintsi'. 'Et hoonliyaz hooncha tune' whut'en-un 'et za huwhuntilh'elh hukwa' huninzun. 'I gha la t'ehonózin. 'Et hoonts'i 'aw huhoo'en-un bughá holts'it ait'oh. 'Et nts'en'a la nus hoo'en-un Jonah bulh dahooja-un, 'et za hoti'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Alha nts'en'a la Nineveh whut'enne, 'enne Jonah be buba whehóodal'en-un inle', 'et whuz un'a za 'en k'un'a 'andit whudizulhne dune, yinka dune ye', 'en be buba whehoodal'en-un tileh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","'Oh whuya hoozulh-un dzin dune ba nahutideh de, 'et whe nyaz de whulerwe ts'eke 'en buniz dudutáyalh, 'et whe buba nahutideh. Soo cho whunulh'en, ndi yun k'ut nilhdzaz de hainya lerwe Solomon ye whunih-i yudutáts'o ha. 'Et hoonts'i 'ilhoghun lerwe Solomon anus 'unt'oh-un 'andit nohtoh usyin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","'Ink'ez 'oh whuya hoozulh-un dzin dune ba nahutideh de, Nineveh whut'enne nohni 'andit whudizulhne nohtoh do dutádulh 'ink'ez nohba nahotiyeh. Soo cho whunulh'en, 'oh da' Jonah bubulh yailhduk da', ts'iyawh dudeni náhundunizdla. 'Et 'awet soo zulhts'ai, 'ilhoghun 'en Jonah anus 'unt'oh-un 'andit nohtoh usyin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Dune 'aw too dizk'un naidulhk'an 'ink'ez whunist'i-un k'us chalhyal t'ah te 'aw néyo'alh ait'oh. 'Et k'us too dizk'un hukw'us'ai-un, hukw'eyi'aih. 'I gha la ts'iyanne dándilhne ndi be hóot'en-i hinoolh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","'Et whuz un'a nohni nohna 'i 'ants'i nohyust'e ba too dizk'un le'unt'oh. 'Et nohna soo 'unt'oh de, 'et nohyust'e dulcho whe be hoot'en-i be whudizbun. 'Et hoonts'i nohna lhe'ízoo' de, 'et nohyust'e 'i cha tsalhgus be dizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'Et huwa ndai be la nohyust'e be hoot'en-i ahli, khun te nohyust'e tsalhgus naoodle' junih. 'Et whuch'a soo cho huwohle'! ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Et huwa nohyust'e ndulcho whe be hoot'en-i dizbun, 'ink'ez 'aw hoontsool-unyaz hoonts'i tsalhgus ooghu hooloh de, 'et de la ndulcho-i be be hoot'en oole'. 'Et whuz un'a soo ts'ih'un be hoot'en-i ulhtus-i k'un'a whedindi, 'i gha la soo whunoolh'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Sizi 'awhuz yalhduk whe 'ilhoghun Pharisee yoodulhkut, “Sdlanaint'alh syoh ts'e.” 'Et Sizi yoh daninya 'ink'ez natl'adida' 'uti'ulh wheni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","'Uti'ulh whutso lanalhe'ildoh. 'Et Pharisee yunilh'en 'ink'ez tube ooba hooncha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","'Ink'ez neMoodihti 'et nduyulhni, “Nohni Phariseene soo cho whunulh'en, nohlusyet 'ink'ez lubot bulh, ooka za tunáwhahgus. 'Et hoonts'i nohdzi yo whe dátni-i cha 'ink'ez 'ut'en ntsi'-i bulh, 'i ts'iyawh 'i be nohyo ts'e whudizbun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Whusnine ahli! 'Aw eh t'eoonuzáhzun? Mbe la yoo'az ts'e 'uhoonla 'ink'ez bez ts'e cha, 'en za 'uhoonla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","'Et hoonts'i ndai la aht'i-i, 'i be 'i ooloh tel'enne be la 'ooht'en. 'Et de la ts'iyantsuk nohba whuna'oodeh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'Et hoonts'i nohni Phariseene 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Ndiz un'a nja daht'en, ndai la hanúlhyeh-i, 'ut'an sooltsun-i cha, rue cha huyulhni, 'ink'ez 'onghoh-i, 'i 'ooloh, 10%, 'i Yak'usda ghah'aih. 'Et ndóht'en huba' hoont'oh. 'Et hoonts'i ndet la ts'ih'un un'a ne'áht'en-un, 'ink'ez Yak'usda ye nek'entsi'-i, 'aw ndulhúzaht'en. 'Et whuz un'a cha ndóht'en huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Nohni Phariseene 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Lizwif lugliz dahyaih de, 'uhoont'oh-un natl'adahdaih, 'et za hukwa' nahzun! 'Ink'ez ndet la 'e'óoket-un, soo ts'iyanne nohodólhti' hukwa' nahzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Et nohni Moses be 'udustl'us 'uk'ununáguzne 'ink'ez nohni Phariseene, dune nalh duba na'ahdzoo'. 'Awet dawhultsi'-un 'et nohts'u hóolts'ulh! Nohni ts'un k'ut 'adahla-un, 'aw dune lhunohis'en le'aht'oh. 'Ink'ez 'adahla-un dune t'ehonúszun whe nohk'unuhudilh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","'Et 'ilhoghun Moses be 'udustl'us k'ut daja ni whe beni hoonli be yalhduk-un, 'en Sizi yulhni, “Nehodulh'eh-un njan 'udini-un, wheni cha nebulh 'udini, 'et huwa neba dzoh 'udínja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","'Et 'uyulhni, “Nohni cha Moses be 'udustl'us k'ut daja ni whe beni hoonli be yalhdukne, 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Nohni nohgha dune 'ut'en howa whúlna'-un butl'awhahle, 'aw hoontsool-unyaz whe hoonts'i bula 'oohneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Nohni 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Nohtso da' nus hoo'enne, 'enne buba tse bet 'ahudutilhtelh-un 'uwhulh'en. 'Ink'ez nohbáke 'enne bubuhanghan inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","'Et 'alha nohbáke 'et dahája, 'et nohni nohba ts'ih'un 'uhoont'oh nahzun. 'Et soo cho whunulh'en, nohbáke nus hoo'enne ubuhanghan 'ink'ez nohni 'ahudutilalh-un buba 'uwhulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","'Et huwa njan Yak'usda ye whunih-i, 'i be 'et dutni, ‘Nus hoo'enne 'ink'ez whel'a'ne, 'enne nohts'u butis'alh. 'Enne whulohne dzoh nubotilhdzut 'ink'ez 'onghohne cha hubotighan.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'Et ndi yun 'udechoo 'ulya 'et whuts'un ndunne nus hoo'enne bubuzkai' whúzdli'ne, nohni 'andit whudizulhne dune nohni hukw'elha whutilhtselh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","'Et huwa la 'oh da' Abel buzkai' whuzdli'-un whuts'un 'ink'ez Zacharias buzkai' whuzdli' da', ndun 'en 'unt'oh Zacharias njan lugliz whucho 'et loodel eguz 'et hizilhghi, 'alha ts'ih'un nohdusni, 'oh da' dahooja la, 'et 'andit whudizulhne dune, 'et nohni hukw'elha whutilhtselh whe' aht'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Et nohni Moses be 'udustl'us k'ut daja ni whe beni hoonli be yalhdukne, 'awet dawhultsi'-un 'et nohts'u hóolts'ulh! Nts'en'a la dune t'ehonózin-un, 'et bughu nawhúlhchoot! Nohnich'oh 'aw lhuwhúlhchulh. 'Et mbene la hóolhdzihne, 'enne cha k'oh úboohtun!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","'Et 'awhuz 'oh whúya hiyilh whe, ndunne Moses be 'udustl'us 'uk'ununáguzne, 'ink'ez Phariseene, 'enne tube huyóolhdzi. Khun tilah hoonliyaz 'uts'un un'a 'udooni' 'inka lhelhdun hukwa huyoodulhkut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","'Ahoolhyiz hinilh'en 'onilha khun tilah tank'us 'údooni'. Khunsul hoonliyaz 'udija de, 'et hik'ehóota'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","'Oh da' whe lhane dune 'ilhuhozdil. Huldlai k'et lhk'unuhúdilh cha' hut'en. Mbene la yugha hodul'ehne, 'enne cho ndubulhni, “Ndunne Phariseene bules be untuldoh-i, 'i ch'a soo cho howahli. 'I dune nalh ye dúba na'udzoo'-i, 'i 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","'Alha ndai la ts'iyawh whunist'i-un, ts'iyawh ts'et haóotikulh. 'Et ndai la whu'iz 'unt'oh-i, 'i cha ts'iyawh t'entidzeh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Et huwa ndet la tsalhgus yo ts'e yalhduk, 'et hoot'en-un hidutats'o. 'Et ndet la yoh whez ts'e 'uyoon yudze khuni in'aih daja dani'-un, 'et bun k'ut whuts'un khuniti be howu yatilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“'Ink'ez sk'ekene nohdusni, mbene la nohyust'e ughanne, 'et hoonts'i 'aw 'on 'un hoonliyaz 'uhooneh ait'oh, ndunt'ohne bube noolhjut junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","'Et hoonts'i mbe la be ntilhjut-un, 'en bunóhuntistun. Mbe la nohyust'e silhghi-un, 'et hukw'elh'az, 'en za ooba' hoont'oh whe kwuncho yo ts'e cha nohtinoh, 'en za be noolhjoot! 'Alha nohdusni, soo ts'ih'un un'a 'en be noolhjut! ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","'Alha eh 'uhoont'oh kwulai' 'uchas, 'i nanki sooneya tsuditi'-i be 'óket? 'Ink'ez ndi dut'aiyaz Yak'usda 'aw 'ilho hoonts'i yunalhodulhnoh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","'Ink'ez daltsuk nohtsigha' 'i hoonts'i ts'iyawh t'einínzun. 'Et huwa whenoolhjut junih! Nohni 'uchasanus dáhti' whé aht'oh! ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“'Ink'ez 'et cha nohdusni, mbe la dune nalh, Sizi Gri 'en ooch'e' usdli ni-un, 'en yinka dune ye' Yak'usda oolizas ubudutánelh, ndun 'en sch'e' unli whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","'Et hoonts'i mbene la dune nalh sts'ooditdlaine, 'enne Yak'usda oolizas bunalh buts'oodutásdlai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Ink'ez mbene la yinka dune ye' ch'az ditni be yalhdukne, daja hutni-un, soo buba 'un whutilhdulh. 'Et hoonts'i mbene la Ndoni ch'az ditni be yalhdukne, 'aw buba 'un whutookat ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Ink'ez lizwifne lugliz, k'us nahiyilhne, k'us moodihne cha, 'enne bubut nenohonilhya de, daja dutihnelh-un, 'et huwu ni oohle' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","'Et soo 'et whudizulh-un Ndoni whunohuntilhtun daja dutihnelh-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","'Et 'awet dune toh 'ilhoghun dune 'utni, “Whuneoodulh'eh-un nedusneke buk'élhutizkat-i, 'i sulhutsin ndai la sch'e' unli, 'i stl'ayóolelh sba dini!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","'Et Sizi 'uyulhni, “Dune, mbe usinla nohba nahiyilh-un, k'us nohba yatilhduk-un sulhtsi?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","'Ink'ez Sizi 'ubulhni, “Nohni soo cho khahdli! 'Uyoon dune ch'e' ha' noohzin junih! Dune daltsuk hoonli yut'i ndi yun k'ut, 'ohwhi 'ants'i 'únt'oh whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Ink'ez 'et khuni oogha whuts'odul'eh huwun ubulh yalhduk whe nja dutni, “'Ilhoghun dune hoonzoo 'unt'oh-un, ooyun k'ut ts'iyaitsuk soo haníyeh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","'Ink'ez didutch'oh 'uninzun, ‘Nts'en'a cha la daoosneh? Haníyeh-i bayoh whudizbun k'et. 'Aw 'on 'un cha 'uyoo dánosdzaih ait'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","'Ink'ez 'et dutni, ‘Nja dutísnelh lhat-un haniyeh-i yoh naná'whuduntisyus 'ink'ez 'on nus 'uhoolcho-un na'whutisdlelh. 'Ink'ez 'et la ndai la hanísyai-i 'ink'ez ndai la ust'i-i, ts'iyawh datísdlelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Ink'ez la na'dudóstni', lhai unzoo-i mba 'ulhozkat, lhat yus k'ut whuba. 'Inka nailyis, 'in'alh, taintnai, 'ink'ez whunílhni.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","'Et hoonts'i Yak'usda 'uyulhni, ‘Tube whusni-un inli! 'Andit 'úlhdzis nzul naitálchulh. 'Ink'ez ndai la int'i-i, mbe ts'u tíkulh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","'Et whuz un'a mbe la lhai duba 'ilhozdla-un 'ink'ez Yak'usda ba hoonli lhit'i'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","'Ink'ez yugha hodul'ehne 'ubulhni, “'Et huwa nohdúsni, yinka dúlhts'i-un, ndai la tih'ulh-i 'ink'ez be sóo nadutihneh-i, 'i ts'iyawh ooghu ni oohle' junih! ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ndai la 'ut'alh-i, 'ink'ez naih cha, 'ohwhi 'ants'i unli whe 'unt'oh. Yinka sahda-un cha, 'ink'ez nohyust'e cha 'i 'on nus dízti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ndunne datsancho dahint'oh la bughu nuni nahzut. 'Aw 'alhé'hunusdle 'ink'ez 'aw halhé'hunusdle cha' hint'oh. 'Ink'ez 'aw uzdla bayoh 'ink'ez haníyeh-i yoh cha lhuhuhóot'i'. 'Et hoonts'i Yak'usda bugha 'á'aih. 'Ink'ez nohni ndi dut'ai anus dáhti' whe aht'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nohni nohtoh mbe 'unt'oh dalcho tileh howu ni unli? 'Aw 'et huwa 'on nus 'ulyiz oole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndi hoontsool-unyaz hoonts'i 'oohoohleh ait'oh de, 'et di ha 'udun cha howu ni ahli? ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","'Ink'ez 'indaiyaz unzoo-i, nts'en'a haníyeh, howu nuni nahzut. 'Aw lhe'ust'en 'ink'ez 'aw hoonliyaz hiye soo nadootnih-i cha lhe'husdle. 'Et lerwe Solomon naih dizti' 'i be soo nadut'ih te, 'et hoonts'i 'aw 'indaiyaz anus lhe'íldzoo' whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","'Et Yak'usda tl'o unzoo-i yilh'i. 'I 'andit dzin tl'o k'ut haníyeh 'ink'ez bunde 'i tsehidutilhkulh 'ink'ez duták'un. 'Et nohni dalcho-i be suba 'on nus soo nanohdooleh. Tube ustla ntsool-i be nohba 'alha hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndai la tih'ulh-i 'ink'ez tihtnelh-i cha, 'ahoolhyiz tube cho ooka daóohtni 'ink'ez ooghuni oohle' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","'Et ndi yun k'ut 'udun yun k'ut whut'enne 'et za hukónuta. 'Et hoonts'i Yak'usda nohBá ndai la be ndunahdzit-i ts'iyawh t'einínzun whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","'Et hoonts'i nts'en'a Yak'usda whe lerwe unli-un, 'et za hukwaitah'en de, 'et ndi cha 'on nus nohghá' tikulh whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Nohni se 'usbai 'ilhoh núlhas-i, 'aw noolhjut junih! Soo cho whunulh'en, nohBá nts'en'a whe lerwe unli-un, 'et hoont'i' whe nohgha óota'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ndai la aht'i-i ts'iyawh be 'óhket 'ink'ez tel'enne, 'enne bugha yohlelh. 'Et whuz un'a 'et daht'en de, 'ants'i sooneya zus ninta lhe'ust'i-i, 'i 'udulhneh. 'Ink'ez ndai la unzoo-i 'ilhiz wheni oola toh hoolóh-i, 'i ts'iyawh be yóohlelh, 'i la yak'uz ts'e neóohlelh. 'Aw whuz undunut'ih-un daooya' ait'oh 'ink'ez 'aw yun nulh'as-i hoonts'i ninta' yolh'en ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Et ndet la oonáht'i'-i ulhoozáhla, ndet la usdla-un, nohdzi cha 'et za dutá'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Nohni nohnaih be 'áht'en-i ts'iyawh be náhdilh 'ink'ez nohtoo dizk'un-i cha dók'un ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","'Et nohni nohnich'oh dune mbene la dumoodih ba sulh'ine, 'enne buk'un'a 'ooht'e'. Nts'e la dune lhghuske ts'e hanája, 'ink'ez dati dunulkw'uz de, 'aho la hiba dáha' dootan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Et ndet la ndun moodih whusanaja de, 'ink'ez be 'ulhnane hika tse hooli, 'ink'ez hika ítis'en, mbene la ndun moodih ndut'enne bunilh'en de, 'enne 'uk'enus hoonzoo-un bugha whults'ut. 'Alha nohdúsni, bumoodih soo nadutitneh ha, 'ink'ez dude 'ulhnane nátl'adulhts'ih budutánelh, 'ink'ez bubut né'tilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Ink'ez moodih tuzniz at'en k'us tuzniz hukw'elh'az at'en, 'et sanatidalh 'ink'ez be 'ulhnane hika tse hooli, 'ink'ez hika ítis'en, 'et whuz un'a moodih ndut'enne bunilh'en de, 'enne 'uk'enus hoonzoo-un bugha whults'ut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","'Ink'ez soo cho t'eoonahzeh, mbe la yoh whumoodih nts'owhuya la whudizulh-un undunut'ih-un whusatíyalh, 'et t'ewhuninzun de, 'et soo ts'ih'un da' huwole', 'ink'ez 'aw hiyoh da'óoyis ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","'Et huwa nohni cha lhadóoht'e'. 'Alha nts'owhuya 'uhunit'o-un 'et ookatselhúwhahlih-un, 'et yinka dune ye' 'et whusanátidalh,” ni Sizi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","'Ink'ez 'et Peter 'uyulhni, “NeMoodihti, ndi khuni oogha whuts'odul'eh-i be yailhduk, 'i wheni za tilah k'us ts'iyanne ba tilah 'udini?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","'Ink'ez neMoodihti 'utni, “K'us mbe ts'ih'un 'unt'oh 'ink'ez whunih-un unli whe yoh huwunli-un? 'En oomoodih duyoh whumoodih yutilhtselh. 'Et 'oh de de, soo 'et neooduzuk de, 'et de la 'onghohne hiti'ulh-i bugha ná'tit'aih. K'us mbe 'utinelh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'Et oomoodih whusanaja de, 'ink'ez hibe 'ulhna-un whuz un'a ndut'en yunilh'en de, 'et de ndun yoh whumoodih yulhtsi-un, 'en 'uk'enus hoonzoo-un bulh 'uwhútanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Alha nohdusni ndun oomoodih ndai la yut'i-i, ts'iyawh k'une' yul'en-un yutl'aóoti'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","'Et hoonts'i ndun be 'ulhna-un dich'oh dudzi yo whe 'et duninzun de, ‘Smoodih sa' sla whusanádaih.’ 'Ink'ez 'et dune oomoodih yuba 'ut'enne 'ink'ez ts'ekoo yuba 'ut'enne cha whéboonilhtsus. 'Ink'ez whé'nin'ulh 'ink'ez tanutnai, 'ink'ez tanutnih, ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","'oh de ndet dzin 'et ndun be 'ulhna-un 'aw yuka ts'e lhúhooli 'ink'ez nts'owhuya 'uhunit'oh-un utinelh 'aw t'eoonuszun, 'et 'oh whuya 'uhunit'oh whe oomoodih whusanátidalh. Tube ye'whutilhyah, 'ants'i lhulcho k'eitat'us le'yutilelh 'ink'ez ndai la Yak'usda k'unulhe'ust'enne buts'ítikulh-i 'et didut cha whuz un'a za oogha óotat'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","'Ink'ez mbe la 'ulhna-un 'en oomoodih ndet la yuts'u hukwa' ninzun-un, 'et ts'iyawh t'eooninzun, 'et hoonts'i 'aw wheni lhálhdit'oh 'ink'ez yuk'unulhe'ust'en, 'et huwa lhat whe ootaltsus. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","'Et hoonts'i mbe la t'eoonúszun dumoodih ndet la yuts'u hukwa' ninzun-un, 'ink'ez dude 'ut'en k'oh huwa ootaltsus huba, dzoh tsulyaz za ootaltsus, 'aw lhat iloh. 'Et mbe la dune lhai oogha nt'ai-un, 'en lhat-un yuts'u hukwa' ntizilh. 'Ink'ez mbe la lhat-un ootl'ahoolya, 'en 'on nus lhat-un yuts'u hukwa' untizilh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ndi yun kwun ookw'ítas'alh ha whusasya. 'Uda' ncha duzk'an. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","'Et hoonts'i be dune too be 'ul'en-i, 'i be too be' tiznelh huba' hoont'oh. 'Et lhaoodutanelh 'et whuts'un 'et huwa tube dzoh nuszut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ts'iyanne lhts'un ts'ih'un 'úhoot'e', 'et hukwa ndi yun k'ut whusasya nahzun eh? 'Awundooh! 'Et nohdusni, dune lhch'az nehúdutadulh 'et hukwa whusasya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","'Et 'andit njan whuts'un kwulane 'ilhughun yoh dilhts'ine, 'enne lhch'az nehúdutadulh. Tane, 'enne nane ch'az nehudutadulh, 'ink'ez nane, 'enne tane ch'az nehúdutat'us. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bubá duye' ch'az nédutadalh, 'ink'ez ooye' 'en dubá ch'az nedutadalh. Buloo 'en cha dutse' ch'az nedutadalh, 'ink'ez ootse' duloo ch'az nedutadalh. 'Ink'ez oobiz 'en cha duyas'at ch'az nedutadalh, 'ink'ez ooyas'at 'en cha dubiz ch'az nedutadalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","'Et lhane 'ilhozdilne, 'et cha 'ubulhni, “'Et ndet la nooz de kw'us whúzdli' nulh'en de, 'et 'aho 'udahni', ‘Ts'oh tselyaz naootilhtelh.’ 'Ink'ez 'et nduwhút'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","'Ink'ez n'az tizts'i te 'et 'udahni, ‘Tube whúntalwus whe' whut'en,’ 'ink'ez 'et nduwhút'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Nohni dune nalh duba na'udzoo'ne aht'oh! Ndi yun k'ut 'ink'ez yat cha dawhutanelh-un, 'et t'eoonahzun. 'Et hoonts'i dáhoont'oh huwa 'andit dawhutanelh 'aw t'eoonuzáhzun? ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","'Ink'ez nohnich'oh dahoont'oh huwa nts'en'a ts'ih'un un'a 'uhoont'oh-un, 'et 'aw t'eoonuzáhzun? ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","'Et mbe la nch'az ditni-un, 'en nahiyilh-un but nenyutalhtelh, 'et whuz ah'us whe 'et tube oots'un lhanaoodonleh hukwa' ont'en. Doo ka la nahiyilh-un but nényutalhtelh 'ink'ez nahiyilh-un neilhchuk-un tl'anyutilhtelh, 'ink'ez neilhchuk-un 'anyuti'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Et nohdusni ndi sooneya nt'um-iyaz hoonts'i, 'i ts'iyawh ookw'elha whutalhtselh, 'et whuts'un 'adutan'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","'Et 'oh da' whulohne dune, 'enne Sizi 'uhuyulhni nts'en'a la Galilee whut'enne ubanghanne bubulh dahooja la. 'Enne 'uhint'oh Galilee whut'enne Yak'usda ba 'uhudílhk'un whe Pilate ubanghan 'ink'ez bubuzkai' nyoo hidílhk'un-i ootayunjut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","'Et Sizi 'ubulhni, “Ndunne Galilee whut'enne, 'enne nts'en'a 'uhuja dzoh nuhuzde, 'et huwa 'uyoonne Galilee whut'enne anus lubeshi 'uhulh'en nahzun eh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Awundooh nohdusni! 'Et hoonts'i nohni cha noheni náhandunoohleh 'et dúlhahnel de, 'et de nohni cha ts'iyawh, whuz un'a za ts'iyawh yaitáhdlah! ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Et keyoh Siloam huwhútni, 'et tse whedin'ai-i, 'i ndunne whunizyanne 'on 'at lhk'udine, 'enne buk'éningez whe ts'iyawh higan. 'Et Jerusalem whut'enne, 'enne buba nus lubeshi 'uhulh'enne 'uhint'oh nahzun eh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Awundooh nohdusni! 'Et hoonts'i nohni cha noheni náhandunoohleh 'et dúlhahnel de, 'et de nohni cha ts'iyawh, whuz un'a za ts'iyawh yaitáhdlah!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","'Et doo cha Sizi huwa whuts'odul'eh-i be bubulh yalhduk whe nja dutni, “'Ilhoghun dune 'en mai chun, figs huyulhni-i, 'i oomai' haníyeh-i k'ut, 'et 'ilho há inulhyeh. 'Ink'ez 'ilhoh dzin mai yughun ha itís'en. 'Ink'ez gak 'aw mai ooghu hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","'Ink'ez 'et oomai haníyeh-un huwunli-un 'uyulhni, ‘Whunilh'en eh? Tat yus k'ut whuts'un ndi mai chun, figs huyulhni-i, oomai' kaitús'en 'ink'ez 'aw oomai' ooghu hooloh. Di ha yun k'ut bulh hóonsool? Ntintselh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","'Ink'ez 'utni, ‘Moodih whute 'andit yus k'ut za oots'ú halhozin'aih. K'at oonat naootiskulh 'ink'ez oogha soo ha' nuyeh-i bulh oogha ítasnalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Et soo oomai' whúzdli' de, 'et soo' hoont'oh. 'Et dúlhinel de, 'et de la ntooselh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","'Et 'awet dzin nats'ulyis-un 'et 'ilhoghun Lizwifne lugliz 'et whubodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Khunsul 'et 'ilhoghun ts'eke whunizyat 'on 'at lhk'udit yus k'ut 'et la ntsi'-i nududeh-i tetsun yulhtsi whe 'en yudinda. 'Et huwa chanuti 'ink'ez didutch'oh 'aw do na'ootneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sizi yutilh'en ibulh, yuka huyih 'ink'ez 'anih yulhni, 'ink'ez 'uyulhni, “Ts'eke whe teintsun-un 'awet mba hukw'una'it'oh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'Et yuk'edilni 'ink'ez 'aho lhts'e nadiski 'ink'ez Yak'usda dílhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","'Et hoonts'i ndun Lizwifne lugliz whumoodih 'en hunílch'e. Nats'ulyis dzin 'et Sizi ndun ts'eke soo na'yinla 'et hukwa hunílch'e. 'Ink'ez 'ilhozdilne bumoodih, 'en 'utni, “Lhk'utat dzin 'et dune 'uhoot'en huba' hoont'oh. 'Et huwa 'uts'ut'en dzin 'et 'awet za soo na'nohohooleh huba' hoont'oh. 'Et nats'ulyiz dzin 'et 'aw soo na'nohotilelh 'et huba whusaóohya' huba lhe'hoot'oh,” ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","'Et neMoodihti 'uyulhni, “Nyun dune nalh duba na'udzoo'-un 'int'oh! 'Alha lawk nohni ilohghun ahli whe nats'ulyis-un dzin nohmusdoos dune k'us nohmuyool te musdoos bayoh 'adultsi'-un, k'unawh'uk 'ink'ez too k'ez toolhdlooh ait'oh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndun ts'eke 'ilhoghun Abraham oots'u haínzut-un 'ink'ez Satan whunizyat 'on 'at lhk'udit yus k'ut whe yulhghel. Soo cho howu nuni nahzut! 'Alha lawk nats'ulyis-un dzin 'et 'aw k'unaoot'uk ait'oh whe' dahni?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","'Et Sizi ndi khuni 'et dudáni' whe yuch'az ditnine, 'enne ts'iyawh yooya huzdli'. 'Ink'ez 'onghohne lhane 'en gha hoonzoo tune' 'ust'en-un 'et huwa howu nálhni whe huhoont'i'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","'Et Sizi 'ubulhni, “Yak'usda whe lerwe unli-un, 'et nts'en'a nohba dahoont'oh? 'Ink'ez nts'en'a suba di bulh nohba lhundúwhult'oh nahzun? ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ndiz un'a nja duhoont'oh, ndi mai nint'um-i mustard huyulhni, 'i k'un'a 'unt'oh. 'I dune yunílhchoot 'ink'ez haníyeh k'et 'ainan'ai 'ink'ez hanányai. 'Ink'ez tube duchun dincha suli'. 'Ink'ez dut'aiyaz oozischum k'ut t'o nenínla.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","'Ink'ez doo cha 'ubulhni, “Nts'en'a suba whunohuntistun Yak'usda whe lerwe unli? ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Lhes ntuldoh-i dult'oh. Ndai la ts'eke yílhchoot 'ink'ez lhes núdzaih-i, 'i ta tsetsai be únde'ooldzih-i dizbun. 'I ntuldoh-i bulh 'ilho be yandzai, 'ink'ez yunilhtlus. 'Et hukw'elh'az 'udun neíninkai whe untílhdo.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","'Et hukw'elh'az Sizi Jerusalem whuz tizya. 'Ink'ez keyoh whuti 'ink'ez keyoh whuyaz 'et dune toyalh 'ink'ez dune hodulh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","'Et 'ilhoghun 'uyulhni, “Nemoodihti oolune za eh hudutijih?” 'Ink'ez Sizi 'ubulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Hoondat-un datí-un hukwa daóohtni. 'Et nohdusni lhane 'et datí-un dahátidulh hukwa' huntizilh, 'et hoonts'i 'aw 'uhooneh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","'Et 'ilhoh yoh whumoodih dudinya 'ink'ez dati dánaidintan, 'et nohni 'az nudulhya 'ink'ez dati dunulhkw'uz 'ink'ez 'udahni, ‘Moodihti, moodihti neba dáha' dintih!’ 'Et la' nohdóni', ‘'Aw t'enohnuzúszun nts'ez de háhdil.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","'Ink'ez la' 'udoohni', ‘Nyulh 'uts'u'alh 'ink'ez nyulh 'úts'utnai'. 'Ink'ez nekeyoh whuti 'et da' whuneoodilh'e inle'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","'Et hoonts'i la' dooni', ‘Nohdusni nts'ez de háhdil 'aw t'enohnuzúszun. Sch'a nasahdilh! Nohni ts'iyawh tank'us ne'zaht'en!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob, 'ink'ez nus hoo'enne, 'enne ts'iyawh, ndet la Yak'usda whe lerwe unli-un, 'et hudutálts'ilh 'ink'ez 'et la bunoolh'en. 'Et 'oh de nohni tenanohonilhdil. 'Et de tihtso 'ink'ez nohghoo lhudutihk'us. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","'Oh de de lhane la ndaz de 'ink'ez nyooz de, 'ink'ez nus de, 'ink'ez nyaz de, whuz de hahátidulh 'ink'ez ndet la Yak'usda whe lerwe unli-un, 'et la nátl'ahudutilts'ilh 'uhuti'ulh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","'Et ndóohoont'oh, whulohne 'udechoo unline, 'enne la 'udek'oh hutileh. 'Ink'ez whulohne 'udek'oh unline, 'enne la 'udechoo unline nahutidleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","'Et dzin za whulohne Phariseene, 'enne Sizi highu nindil 'ink'ez 'uhuyúlhni, “Naindalh 'ink'ez njan whuch'a nasindaih. Herod nyutuzilhghelh hukwa' ninzun!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","'Ink'ez 'ubulhni, “Nyoon 'uyoo unli-un, ndiz un'a sba dáhni, ‘Soo zolhts'ai'! 'Andit dzin 'ink'ez bunde cha ntsi'-i nududeh-i dune ch'a hanánusyoot 'ink'ez dune soo ná'us'en, 'ink'ez whulh tat dzin 'et la hukwa whusásya-un 'et lhadúlya-un tisdleh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","'Et hoonts'i 'andit dzin, 'ink'ez bunde dzin 'ink'ez 'om bun dzin kedutooszit huba' hoont'oh. 'Alha' hoont'oh whe 'aw nus hoo'en-un, 'en 'aw keyoh Jerusalem whan'az daóotsah huba lhe'hóot'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Nohni Jerusalem whut'enne, Jerusalem whut'enne, nohni aht'en nus hoo'enne ahghan. 'Ink'ez mbene la nohts'u whel'a'ne, 'enne cha tse be bubahghan. Dant'oh la lugok duduzkeh duts'unt'a' ubudilhts'i, whuz un'a nohni cha dáwhultsuk whe 'ilhunanohootásdlelh hukwa' nuszun, 'et hoonts'i 'aw hukwa lhe'náhzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Soo cho whunulh'en, 'awet nohni Jerusalem whut'enne nohkeyoh 'aw hoonli hooloh suli' whe nohba 'et nenáwhults'ut, 'et whuz un'a Yak'usda nohladutitnih. 'Ink'ez 'alha' nohdusni, ndet la whusaóotilts'ulh, 'et 'oh de 'et ndudútihnelh, ‘Mbe la Moodihti boozi' be whusatiyalh-un, 'en 'uk'enus hoonzoo-un oogha whults'ut.’ 'Et ndudútihnelh 'et whutso, 'aw sooh'en ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","'Et 'awet 'ilhoh dzin 'ilhoghun Pharisee bumoodih ooyoh, 'et nats'ulyis-un dzin, 'et Sizi lhes natit'ulh ha danínya. 'Et soo cho hinilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","'Et khunsul 'ilhoghun dune ooyust'e toh too whudizbun suli', 'et hukw'é unduda, 'en Sizi but usyin. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","'Ink'ez Sizi ndunne Moses be 'udustl'us k'ut, daja ni whe beni hoonli be yalhdukne, 'ink'ez Phariseene, 'enne cha 'ubulhni, “'Et neba ts'ih'un 'uhoont'oh eh nats'ulyis-un dzin dune soo na'ts'oolh'en?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","'Et ts'iyawh t'ehudusnih. 'Ink'ez nyoon dune yílhchoot 'ink'ez soo na'yinla, 'ink'ez yulanaditni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","'Et 'ubulhni, “Mbene 'unt'oh nohtoh muyool 'ut'i-un k'us oomusdoos dune tsa k'et 'alts'ut de, 'aw nats'ulyis dzin 'uhoont'oh 'et huwa eh 'aho 'aw hanálhuhitilhtelh nahzun eh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Njan 'et huwun uboodulhkut-un, 'aw daja hudooni' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Mbene la ooghu nusjane k'us hoonzoo-un 'utahahódit'ai 'ink'ez bunilh'en whe' hut'en. 'Inka huwa whuts'odul'eh-i be bubulh yalhduk whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nts'e la dune lhghu tikelh ts'e nohghu nusja de, k'us hoonzoo-un te natl'adoohdalh junih. Doo ka la nohan do 'unt'oh-un tilah highu nóya'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'Et de mbe la nohghu nusiya-un, 'en la 'unyudóni', ‘Sinda-un ootl'ahóon'aih, ndun 'et ooda'.’ 'Ink'ez 'et la yooya sinli' whe 'uk'enus 'udeyo 'et la nanátl'adondalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","'Et hoonts'i nts'e nohghu nuhúzya-un whuz toohya' 'ink'ez 'ants'i dati whenghoh nátl'adondalh. 'Et de la mbe nohghu nusiya-un 'en tilah 'unohdóni', ‘Sk'eke 'uhoont'oh-un natl'adindaih.’ 'Et mbene la lutab k'ut nyulh dilhts'ine, 'enne la nyodólhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Soo cho whunulh'en, mbe la ncha na'dudil'i-un, 'en yooya tileh. 'Ink'ez mbe la te'dudil'en-un, 'en la 'unt'oh-un huyoolhtselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mbe la yughu nusiya-un, 'en Sizi 'uyulhni, “Ndet la dzetniz k'us hulhgha huwa' tan'alh de, khun te nk'eke, k'us nyulhutsinke, k'us nyunatneke, k'us nyenghoh whut'ine mbene la hoonzoo' 'unt'ohne, 'enne ts'iyawh bughu nónya' junih. 'Et bughu nusinya de, 'enne tilah nghu nunáhooda' whe mba k'elha whutale. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Et hoonts'i huwa' tan'alh de, 'et mbe la tel'enne, 'ink'ez dzoh nudilhne, 'ink'ez ooyust'e bodin'aine, 'ink'ez hoos̱'enne cha, 'enne ndunt'ohne, 'enne za bughu nonya'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Et la nyun 'uk'enus hoonzoo-un nyulh 'úhoneh. 'Enne 'aw mba k'elha hoohoolhtselh ait'oh. 'Ink'ez nyun tsih'un 'unt'ohne dunahudidil de, 'et de mba k'elha whutaleh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","'Et 'ilhoghun dune lutab k'ut yulh usda-un, 'en yudants'o, 'en 'uyulhni, “Ndet la Yak'usda whe lerwe unli-un, mbene la 'et 'a'alhne, 'enne 'uk'enus hoonzoo-un bugha whutalts'ulh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","'Ink'ez Sizi 'uyulhni, “'Ilhoghun dune hulhgha hooncha whe huwa' nin'ai. 'Ink'ez lhane ghu nusiya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","'Et hulhgha na'hutit'ulh-un dude 'ulhna-un whe yálh'a' 'ink'ez mbene la bughu nusjane ubudóni', ‘'Awet ts'iyai lhadúja, diz ahdulh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ts'iyawh 'ilhone hinli whe 'onilha 'aw 'uhooneh ait'oh hutni. 'Et 'udechoo-un nja dutni, ‘Si yun osket 'ink'ez whuz tisyalh ntis'elh ha, 'et huwa 'aw oosneh ait'oh sba dóni'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","'Et 'uyoon dune 'en cha nja dutni, ‘Kwulai' lhghuske musdoos dune osket. Ts'iyawh ubootásdzih 'ink'ez nabuduntiz'elh dahóot'e' suba, 'et huwa 'aw oosneh ait'oh sba doni'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","'Uyoon cha 'et dutni, ‘'Ants'iya 'at ust'i 'et huwa 'aw whuz toosya' ait'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","'Et be 'ulhna-un yughu nanja 'ink'ez dumoodih 'et huwun ts'iyawh yudáni'. 'Ink'ez ndun yoh whumoodih 'awet hunilch'e 'ink'ez dude 'ulhna-un 'uyulhni, ‘Soo 'a cho! Keyoh whuti ts'ínyalh 'ink'ez tiyaz ndulcho whe ninya 'ink'ez tel'enne cha, 'ink'ez dzoh nudilhne cha, 'ink'ez hoos̱'enne cha 'ink'ez ooyust'e bodinlane cha, 'enne ts'iyawh sabinle!’ 'Ink'ez wheyálh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","'Ulhna-un whusanája 'ink'ez 'utni, ‘Smoodih nts'en'a 'udini-un, hukw'un'a 'usja, 'et hoonts'i 'awhuz hooncha-un whuz'ai.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","'Ink'ez moodih dude 'ulhna-un 'ulhni, ‘'Awet ti whucho ts'inyalh 'ink'ez ti whuyaz cha ts'inyalh 'ink'ez dune ts'iyawh diz hutoodilh hukwa' bilh'en, syoh whudoobun ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Alha' dusni whe nyudusni, ndunne 'udechoo bughu nusúsyane, 'aw 'ilhoghun hoonts'i ndi tit'ulh-i 'aw hinalhuhootásdli.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","'Ink'ez 'et lhane 'ilhozdilne huyulh tizdil. 'Ink'ez buts'u nálh'a 'ink'ez 'ubulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Mbe la sts'u tiyalh se' 'ut'en k'oh 'uwhutilh'elh-un 'ink'ez dubá 'ink'ez duloo, du'at cha, 'ink'ez duzkeh, dulhutsinke, 'ink'ez dulhtuske, 'alha 'ink'ez dich'oh whe yinka usda-un cha, ndi njan ts'iyawh hukwa lhe'hunizun de, 'en 'aw sgha hodil'e'-un oole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","'Ink'ez cha mbe la dutulalhgus lhudistel-un 'ink'ez sulh untiyal-un, 'en 'aw sgha hodil'e'-un oole' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Soo cho whunulh'en, mbe 'unt'oh nohtoh-un, whedin'ai-i 'utilelh de, 'alha lawk 'aw 'udechoo nátl'adida 'ink'ez daltsuk tileh 'aw lhuyóolhtoh daltsuk tileh nja whenin'ai-i bé lhaoodutaneh-i? ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Doo ka la 'aw ndulhinel de, 'ink'ez yoh ook'uwhuz'ai-i inla, 'et 'aw soo 'ultsuk ye lhaoodutileh-i lhit'i' de, 'et mbene la whunilh'enne, ts'iyawh highu tidloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","'Ink'ez la 'uhudooni', ‘Ndun dune whedin'ai-i whe'yuninle' 'ink'ez 'aw lhai dooleh ait'oh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","K'us mbe lerwe 'utinelh 'uyoon lerwe bulh lhutigan hukwa' ntizilh. 'Alha lawk 'aw 'udechoo nátl'adida 'ink'ez hukw'u nuni noolhdzut datinelh. 'Et soo tilah 10,000ne dudune'ne, 'enne be ndun 'uyoon lerwe 'en 20,000ne lhuganne, 'enne soo tilah ndunne 10,000ne be bududóya'? ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Et k'us ndun 'uyoon lerwe 'en 'awhuz nilhdza' 'az de hídulh whe, 'et khuni yuba na'ane yuts'u whébalh'a', nts'en'a suba ts'ih'un nenáhoho'alh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Et huwa nohni nohtoh 'ilhone ahli whe, ts'iyawh aht'i-i, 'aw oolahduzahni de, 'aw sgha hodil'e'ne oohle' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lisel 'i 'uzoo' whe 'unt'oh. 'Et hoonts'i 'aw oonalhuwhúlhnih suli' de, nts'en'a suba doo cha oonawhúlni' naoodle'? ");
INSERT INTO crxNTpo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lisel oonalhuhóolni de, 'aw hoonli huba lhe'ízoo' whe 'unt'oh. 'Aw yun ba hoonts'i lhe'izoo'. 'Ink'ez 'aw musdoos dálts'i'-un 'et hoonts'i huba lhe'ízoo' whe 'unt'oh. 'I 'ants'i dune tehúyulhkuk, huba 'unt'oh. Mbe la oodzeh hoonine hohoozólhts'ai'!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","'Et 'awet ndunne sooneya nalhdzoohne 'ink'ez lubeshi 'ulh'enne, 'enne cha ts'iyawh Sizi huyootuzálhts'ilh ha highu nindil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","'Ink'ez ndunne Phariseene 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha highu yawhenilhduk whe nja duhutni, “Nulh'en ndun dune 'en lubeshi 'ulh'enne, 'enne bubulh ne'ut'en 'ink'ez bubulh á'alh cha 'ut'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","'Et huwa oogha whuts'odul'eh-i be bubulh yalhduk whe nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Mbe 'unt'oh nohtoh dune 'en 'usbai 100 ut'i whe 'ilho ninta nilhti. 'Aw 99 'enne chuntoh 'awet nébuninla 'ink'ez 'ilhoghun ninta inilhti-un nayitálhtelh whuts'un yukunúta? ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Ink'ez ndet la nayilhti whe duwus k'eyilhti 'ink'ez hootát'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","'Et 'oh da' duyoh ts'u naóosja duk'ekene 'ink'ez yenghoh whut'ine, 'enne ts'iyawh 'anih budani' 'ink'ez 'ubulhni, ‘Sulh hoonaht'i'. Ndun se'usbaiyaz ninta nusti inle', 'en nasti!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","'Et nohdusni, whuz un'a za ndun 'ilhoghun dune dudeni nahunduniz'ai, 'en 99 ts'ih'un 'unt'ohne, 'enne 'uda' dulubeshi ch'a dudeni nahundunizdla. 'Et hoonts'i ndun 'ilhoghun dune 'en gha ndo yak'uz dilhts'ine, 'enne buba nus 'on nus howun tálhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“'Et doo cha za 'ilhoghun ts'eke whunizyai silver ut'i 'ink'ez 'ilho ninta nin'ai. 'Aw eh too dizk'un nadulhk'an 'ink'ez yoh tunáwhulhtsas, 'ink'ez nayitá'alh whuts'un yukunúta? ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Ink'ez ndet la nayin'ai de duk'ekene 'ink'ez yenghoh whut'ine, 'enne 'alhgoh 'anih budani' 'ink'ez 'ubudútanelh, ‘Sulh hóonaht'i! Ndi sooneya 'ilho ninta nus'ai-i nas'ai!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Whuz un'a za nohdusni, 'ilhoghun dudeni nahunduniz'ai de, 'et de Yak'usda oolizasne, 'enne ts'iyawh howun tálhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sizi 'et 'utni, “'Ilhoghun dune, nane ooye' hooni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Udek'oh-un 'et dubá ndúyulhni, ‘'Ubá ndai la sba naootándzilh-i 'andit ts'iyawh stlainle.’ 'Inka ndun oobá ndai la duye' buba nayootádzilh-i, ts'iyawh buba lhk'éyanla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","'Et hukw'elh'az 'aw lhat dzin lhiloh, 'et 'udek'oh-un yugha ininlai-i, ts'iyawh soo neninla. 'Ink'ez keyoh nilhdza' ts'e ts'u whinya. 'Et whuz oozya whe ndai la yut'i-i, 'i ts'iyawh ye nzóodal'e' 'ink'ez gak yulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","'Oh da' 'et ndai la yuts'u yoozi-i ts'iyawh gak yulhtsi whe, 'et nyo yun k'ut dai cho whúzdli'. 'Ink'ez ndun chilh ts'iya-i ye ndunidzit suli'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","'Inka 'ilhoghun dune 'et yun ut'í-un, 'en 'ut'en yugha nín'ai. 'Ink'ez hanulhyeh ts'e wheyálh'a', 'et gugoos ghá ti'aih ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","'Et ooye'ílts'ul k'et 'et dunínzun, nyoo gugoos yu'alh-i, 'i uncha us'alh, ninzun. 'Et hoonts'i 'aw dune yugha lhé'us'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","'Et beni oogha nadilts'ut le'uja 'ink'ez 'utni, ‘Daltsukne 'ubá ba 'ut'enne huya'alh-i buba nus-i niltsuk, 'ink'ez si njan lhe'ust'oh! 'Awet dai súzulhghe! ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Dunadósja' 'ink'ez 'ubá oots'u nátoosja' 'ink'ez la 'udósni', 'ubá yak'uz whudulhyoh cha lubeshi usdla 'ink'ez nyun mbut cha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'Aw 'on 'at sye' sudutanelh huba soo lhe'uzdzoo'. 'Et huwa ndunne mba 'ut'enne k'un'a 'usolhdzin.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'Inka 'et 'awet dubá ts'u nátisja. 'Awhuz yoo 'az de nádalh, oobá yutilh'en whe 'aho yugha te'ninzin. Yududílhgaih 'ink'ez duye' dushih be' yilchoot 'ink'ez naidits'ooz. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'Ink'ez ooye' 'uyúlhni, ‘'Ubá yak'uz whudulhyoh lubeshi usdla 'ink'ez nyun mbut cha. 'Aw 'on 'at nye' sodutánelh huba soo lhé'uzdzoo'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","'Et hoonts'i oobá dude 'ustlenne buts'un 'et dutni, ‘Naih 'uk'enus unzoo-i whusalhchoos 'ink'ez be sóo naidulhleh, 'ink'ez la tult'o cha oola nedah'aih 'ink'ez kegon cha belh'es. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","'Ink'ez musdoosyaz nilhk'a-i ulhchoot 'ink'ez nasulhghe! 'Et la 'uts'oo'alh 'ink'ez ts'onólhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sye' dazsai inle' 'ink'ez 'andit nahítna' le'hoont'oh. Ninta nusti inle', 'ink'ez 'andit nasti.’ 'Et la 'awet ts'iyanne hiyulh whúnilhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","'Et ooye', 'udetso whudilhdzulh-un, 'en haníyeh ts'e 'ut'en. 'Et yoh ts'u natisja. 'Awet whenghoh nadalh whe 'et shun cha 'ink'ez hanudaih-un 'et whuduzts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'Ink'ez 'ilhoghun ts'oodun ye 'ulhna-un 'anih yulhni 'ink'ez yoodulhkut, ‘Dawhutni whe' whutni?’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","'Ink'ez 'uyúlhni, ‘Nyulhutsin whusanája. Soo 'unt'oh 'ink'ez dálhit'oh whe whusanája. 'Et huwa mbá musdoosyaz nilhk'a-i nasilhghi.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","'Et hoonts'i bulhutsin 'udetso-un hunilch'e. 'Ink'ez 'aw yoh ts'u nátooja' hukwa lhe'nizun. 'Et oobá tenínya 'ink'ez yughu tedudli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","'Ink'ez dubá 'uyúlhni, ‘Nilh'en lhe'whuldzoh mba 'ust'en. 'Ink'ez 'aw nghuni 'ilho hoonts'i k'ulhúsyus. 'Et hoonts'i 'aw 'usbai t'umyaz hoonts'i sgha lhilhtel sk'ekene bubulh whúnosni ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","'Et hoonts'i ndun nye', 'en, ndai oogha ínin'ai-i, 'i ts'ekoo 'ul'enne, 'enne buk'uz ts'iya-i yulhtsi 'ink'ez musdoosyaz nilhk'a-i ooba nasílghi!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","'Ink'ez 'uyulhni, ‘Sye' 'ahoolhdzin sulh 'ínt'oh. 'Ink'ez ndai la ust'i-i, ts'iyawh nyun nch'e' 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","'Et ts'ih'un un'a 'uhoont'oh ts'onólhni 'ink'ez ts'ohót'e' huba' hoont'oh. Nyulhutsin dazsai inle', 'en nakhitna'. Nintalts'ut inle', 'awet nasti.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","'Ink'ez 'et cha yugha hodul'ehne, 'enne 'ubulhni, “'Ilhoghun dune hoonzoo' 'unt'oh-un, 'en yoh whumoodih ut'i. 'Et 'uyoonne 'uhuyulhni, ‘Nyoh whumoodih-un ndai la int'i-i, ye únzoodil'i.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","'Inka 'anih yudani' 'ink'ez 'uyulhni, ‘Daja hutni-un nyulh udusts'o? Nts'en'a syoh whumoodih inli-un, 'et ts'iyawh sba 'uk'ehóonges. 'Awet syoh whumoodih inli-un 'etsul 'inja whe' hoont'oh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","'Et ndun yoh whumoodih inle'-un dich'oh na'dudutni, ‘Daoosneh cha há la? Smoodih 'awet se' 'ut'en sghu naílhchoot. 'Aw soo lhe'uztus yun whutiskaih whuba. 'Ink'ez datisó-un cha hukwayá usdli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Datísnelh-un howu nuni níszut. Ndet la se' 'ut'en njan ninta nus'ai de, dunene buyoh ts'e soo la dasóholhtelh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","'Inka mbene la oomoodih 'ilhone hinli whe buts'ú whulh'aine, ts'iyawh 'anih budáni'. 'Ink'ez 'udechoo-un 'en yoodulhkut, ‘Smoodih daltsuk nts'u whulh'ai?’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","'Et 'uyúlhni, ‘Khe 100 bundé'oolhdzai-i.’ 'Ink'ez 'uyulhni, ‘Soo 'a natl'adindaih 'ink'ez bé nts'u whuz'ai-i 50 za 'uk'einges!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","'Et 'ilhoghun cha 'uyulhni, ‘Nyun do', daltsuk nts'ú whuz'ai?’ 'Ink'ez 'uyúlhni, ‘Tl'o mai' 100 bundé'oolhdzai-i.’ 'Et 'uyulhni, ‘Bé nts'u whuz'ai-i, 80 za 'uk'e'inges!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndun ts'ih'un lhe'it'oh-un yoh whumoodih, tube 'uyoo unli whe 'uja. 'Inka 'uyulhni oomoodih, ‘'Aw soo ts'ih'un un'a lhe'inel, 'et hoonts'i 'uyoo inli whe 'inja!’” 'Et Sizi 'ubulhni, “Ndiz un'a nja duhoont'oh, mbene la ooba 'alha lhe'hoot'ohne, 'enne 'uyoo unline 'unt'oh 'ink'ez mbene la Yak'usda ba be hoot'en unline, 'enne buba nus 'uyoo hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","'Ink'ez nohdusni, ndi sooneya, 'i be k'eke nahultsih. 'Ink'ez datíhtsah de, 'et de si, ndo yak'uz 'ilhiz 'uhoont'oh ts'e, whuz la danóhoholelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ndai la 'aw hoonli lhuhóloh-un, 'et ts'ih'un ne'whulh'en de, ndai hooncha-un 'et cha ts'ih'un ne'whutilh'en. 'Et mbe la hoontsool-unyaz be tank'us 'unt'oh-un, 'en hooncha cha whuz un'a za 'et ndutit'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'Et huwa ndi sooneya, 'i be ts'ih'un nulhé'zaht'en de, nts'en'a suba ndai la soo be hoonzoo' hoont'oh-i, nohtl'ayóo'alh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Et nohni ndai la 'uyoonne ch'e' 'i be ts'ih'un lhe'áhnel de, 'et mbe suba ooneh ndi nohch'e' unli-i nohtl'ayóo'alh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","'Aw 'ilhoghun 'ustlé-un 'en 'aw nane moodih ba 'oot'en ait'oh. 'Et 'ilhoghun 'en yuts'u dutitni 'ink'ez 'ilhoghun yuk'etitsi'. K'us 'ilhoghun yuk'úne'tit'en 'ink'ez 'ilhoghun yuch'az dútatni. 'Aw Yak'usda cha k'une' 'int'en 'ink'ez sooneya cha k'une' 'ont'en ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","'Et nyoonne Phariseene, 'enne sooneya buba dizti'ne 'uhint'oh. 'Enne cha soo nts'en'a la daja ni ts'iyawh hidants'o, 'ink'ez highudloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","'Inka 'ubulhni, “Nohni ndiz un'a nja daht'oh. dunene toh nohnich'oh soo ts'ih'un 'unt'ohne na'dudulh'i, 'et hoonts'i Yak'usda nohdzi dant'oh la ts'iyawh soo ts'ih'un t'eooninzun. Ndai la dune ba dízti'-i, 'i Yak'usda yuts'u dutni whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Moses be 'udustl'us cha 'ink'ez nus hoo'enne bube' 'udustl'us cha ndet whuts'un la John dune too be 'ulh'en-un khuna da', 'et whuts'un dune hik'une' 'oot'en huba' hoont'oh. 'Et whuts'un whudutizut ndet la Yak'usda whe lerwe unli-un, 'et huwun khuni unzoo-i dunene hiye yalhduk. 'Ink'ez ts'iyanne 'et whuz un'a húkwa' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","'Et tube howa whulna' whe ndo yat'ah 'ink'ez ndi yun cha hooloh whutaleh. 'Et hoonts'i 'on nus howa whulna' whe Moses be 'udustl'us k'ut 'uk'enus hoontsool-unyaz 'uk'ehóoguz-un, 'et hoonts'i 'aw hooloh hóle' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Et mbe la dune du'at 'etsul 'inla-un 'ink'ez 'uyoon ts'eke ghu nasda de, ndun dune 'en lubeshi 'ulh'en. 'Ink'ez mbe la ts'eke duki ch'a nasja-un 'ink'ez 'uyoon dune ghu nasda de, ndun dune 'en cha lubeshi 'ulh'en whe 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“'Et 'awet 'ilhoghun dune hoonzoo' 'unt'oh-un, 'en naih dulk'un-i dizti'-i 'ink'ez laiyin dizti'-i cha, 'i ye dune unli. Dzin totsuk unzoo-i za duyeyul'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","'Ink'ez 'ilhoghun dune tel'en-un, 'en Lazarus huyulhni, 'en ooyust'e ndulcho whe ooka whulhjut. 'Ink'ez nyoon dune hoonzoo' 'unt'oh-un yudati 'et huyulhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ndai hoonzoo' 'unt'oh-un oolutab k'ut whenghukat-i, 'i uncha us'alh ninzun. Lhike 'enne hoonts'i highulgok whe hika k'et whúdlat. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Et ndun dune tel'en-un dazsai. 'Ink'ez lizasne, 'enne Abraham zih nehinilhti. 'Ink'ez nyoon hoonzoo' 'unt'oh-un cha dazsai. 'Ink'ez 'ahuyalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","'Et ndun 'en yaidlanne toh usda 'ink'ez tube dzoh nuzut. 'Et ndo yútan'en whe nilhdza' 'et Lazarus, Abraham yuzih usda whe 'ubutilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","'Et tube soo cho yuts'u huyih 'ink'ez yulhni, ‘'Ubá, Abraham, sgha te'ninzeh! Lazarus 'en sts'ilh'alh! Dzohtsulyaz dulasga be toot nudoolga 'ink'ez 'i be la stsoola k'ut nawhunoolhtsul, 'i be la nanósk'as! Ndi kwun 'i be dzoh nuszut!’ yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","'Et hoonts'i Abraham 'uyulhni, ‘Sye' yinka sinda da' whunailnih eh? Ts'iyaitsuk unzoo-i nghánkat. 'Et hoonts'i Lazarus ntsi'-i za ooghankat. 'Ink'ez 'et 'awet 'en hoonzoo-un ooghá whults'ut, 'ink'ez nyun 'andit dzoh ninzut. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","'Ink'ez 'aw 'et za iloh, nyun 'ink'ez wheni neulh eguz tube yádalhdza' whe' hoont'oh. 'Et huwa njan whuts'un 'aw nts'ó tooya' ait'oh k'us nyun nts'ungus whuts'un cha 'aw diz hutooya' ait'oh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","'Et 'uyúlhni, ‘'Ubá Abraham nts'u tedusdli, Lazarus 'en 'ubá ooyoh ts'e ilh'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kwulane sulhutsinke hooni. Khun tilah khuni bugha óo'alh. Doo ka si njan dune dzoh nudeh ts'e hutoodilh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","'Et Abraham 'uyulhni, ‘Moses be 'udustl'us cha 'ink'ez nus hoo'enne bube' 'udustl'us cha hut'i. 'I huyoozólhts'ai' da.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","'Ink'ez 'uyulhni, ‘'Awundooh 'ubá Abraham. 'Et 'ilhoghun yaidlanne toh ts'e hanája de 'ink'ez buts'u tizya de, 'et huwa la dudeni nahondunooleh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","'Ink'ez 'uyulhni, ‘Moses be 'udustl'us cha 'ink'ez nus hoo'enne bube' 'udustl'us cha, daja ni la 'aw huyoozólhts'ai hukwa lhe'hunizun de, 'et nts'en'a 'ilhughun dazsai-un yaidlanne tuz hanaja de, 'en hoonts'i 'aw bubeni 'uts'un ná'yooleh ait'oh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","'Ink'ez Sizi yugha hodul'ehne 'et ndubulhni, “Whe tank'us uznint'i-un 'ahoolhyiz 'et whuzdla whe' hoont'oh. 'Et hoonts'i mbe la dune oogha tank'us 'úwhut'en-un, 'et dawhultsi'-un oots'u hóolts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ndunne ts'oodunneyaz 'ink'ez ndun dune 'en gha tank'us 'úhut'en suli' de, 'en dune tse cho hits'ilchun edinguz 'ink'ez soo takhulh-un tahúyano de, 'et da' 'on nus hózoo' oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","'Et huwa soo cho khahdli. 'Et nohulhutsinke nohdulhyoh 'uhuja de, 'et de hukwa' budóhni'. 'Et dudeni náhunduniz'ai de, 'et de buba whunaoodoolhnoh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Et 'ilhoh dzin lhtak'ant'it ndulhyoh 'uja de, 'et 'oh totsuk nghu nadaih 'ink'ez, ‘Seni náhandunis'ai,’ nyúlhni de ooba whunaoodolnoh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","'Ink'ez whel'a'ne neMoodihti huyulhni, “Be néba 'alha' hoont'oh-i, 'on nus 'ultus neba ilhtsi.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","'Et neMoodihti 'ubulhni, “'Uk'enus haníyeh mai' nint'um-i, mustard huyulhni, 'et nohba 'alha' hoont'oh-un, 'et 'uwhulcho de, nyoo duchun haníyeh-i, mulberry huyulhni, 'et Yak'usda oodolhkut, ‘Ndi duchun ooghih tubulh hanaílhch'oolh 'ink'ez nyo bun cho k'et 'et 'anain'aih.’ 'Et la Yak'usda nohk'oh ts'e 'ooneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","'Ink'ez nohni nohtoh 'ilhoghun nohe'ulhna-un unli. 'Et ndun 'en haníyeh k'et nawhulhch'ul k'us 'usbai ghunli. 'Et ndi hanúlhyeh k'us whuz de hanája. 'Et diz un'a tilah 'udóni', ‘Soo 'a! Natl'adindaih 'ink'ez na'int'alh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Awundooh! K'us ndiz un'a njan dúdoni', ‘Hulhgha natist'ulh-i sba lhadinle, 'ink'ez soo cho soo nadintneh! 'Ink'ez sba hukw'e'inle, bulh na'tist'ulh-i cha sba hukw'eínkaih. 'Ink'ez na'ist'al hukw'elh'az 'et la na'ont'alh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","'Et nyoon be 'ulhna-un ndet la yutl'ahonla-un 'et ts'iyantsuk lhaoodinla. 'Et duja-un 'et huwa eh musi yudutanelh? 'Awundooh nuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","'Et whuz un'a za nohni cha, ndet la daooht'en-un nohodani', 'et ts'iyawh lhaoodahla de, 'et 'ink'ez nja dudútihnelh, ‘'Aw whulukhun za huba ts'inzoo-un hoonli. Daja nehutni, 'oh te za ne'ts'ut'en.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","'Et 'awet Sizi Jerusalem tizya whe yun k'ut Samaria 'ink'ez yun k'ut Galilee cha whulheguz lhuseya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","'Et whuz uyalh whe keyoh whuyaz nenínya. 'Et whunizyane ndulcho whe buka whulhjut-i, 'i leprosy huyúlhni, 'í be undudane, hidudizdil. 'Ink'ez highu nilhdza' nódilhya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'Et whuts'un hits'u huyih, “Sizi neMoodih, negha te'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","'Et Sizi ubunilh'en 'ink'ez 'ubulhni, “Lubret ts'ohdulh. 'En nohnoolh'en hoonli-unyaz tilah nohghu nahó'alh.” 'Et 'awhuz whuz hidulh whe soo na'huja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","'Et 'ilhoghun soo na'uja t'ewhunanzin whe 'et nohundunizya 'ink'ez yuts'u naoosja. 'Et soo tube cho Yak'usda dálhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","'Et Sizi yubut yun 'et nachániti, 'ink'ez lhk'uz te musi yulhni. 'En dune Samaria whut'en-un 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","'Et Sizi 'uyúlhni, “Whunizyane lakw eh soo na'huja? Ndunne 'ilho hoolohne nts'e whehándil? ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Et ndun 'udun keyoh ts'u hainya-un, 'en za whusanaja 'ink'ez Yak'usda musi yulhni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","'Ink'ez Sizi 'uyulhni, “Dudinyaih 'ink'ez naindalh. Mba 'alha' hoont'oh-i, 'i be soo na'inja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","'Et whulohne Phariseene, 'enne Sizi huyoodulhkut, “Nkede 'uwhutanelh Yak'usda whulerwe unli-un whusaootilts'ulh?” 'Et 'ubulhni, “Yak'usda whulerwe unli-un, 'aw nts'en'a whusaootilts'ulh-un, 'et 'aw whunoolh'en ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","'Aw 'ilhoghun hoonts'i dooni' ait'oh, ‘Njan whunulh'en 'et 'uhoont'oh,’ k'us, ‘Nghut 'uhoont'oh.’ 'Et Yak'usda whulerwe unli-un 'uda' nohbulh 'oohoont'oh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","'Ink'ez 'et yugha hodul'ehne ubulhni, “'Et 'oh dzin whusaóotikulh 'ink'ez yinka dune ye', 'ilhoh dzin whutih'elh hukwa' ntihzilh, 'et hoonts'i 'aw hooh'en ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","'Et la 'onghohne dune 'et la ndunóhodoni', ‘'On 'un whunulh'en!’ k'us ‘Njan whunulh'en!’ Khun buts'u toohdilh junih 'ink'ez bubun toohdilh junih! ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nts'en'a la ditni kwun 'oolhges te ndulcho whe bé hooltsih, 'et whuz un'a za yinka dune ye', oodzin de ndulcho whe ts'iyanne ba be hoodutaltsilh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","'Et hoonts'i 'udechoo lhat-un whe dzoh nutizut huba' hoont'oh. 'Ink'ez 'andit whudizulhne dune hikalhe'untiszil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","'Et nts'en'a la 'oh da' Noah oodzin whudizulh da', dahoont'oh inle' la, 'et whuz un'a za yinka dune ye' dzin 'et duwhútat'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","'Et ts'iyanne 'uha'alh za' hut'en, 'ink'ez tahunutnai. Dunene cha 'ink'ez ts'ekoo cha lhgho dilhts'i. 'Ink'ez 'oh da' nts'en'a la Noah ts'i cho be ínya 'ink'ez 'et too dudilt'o 'ink'ez ts'iyanne too hubanghan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","'Ink'ez ndun Lot 'en khuna da' whuz un'a 'et dúhooja. 'Et ts'iyanne 'uha'alh za' hut'en 'ink'ez tahunutnai. 'Oohooket 'ink'ez 'e'hooket. 'A'hunule 'ink'ez yoh 'uhuwhulh'en cha' hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","'Et 'oh da' dzin Lot keyoh Sodom huwhutni-un huwu whenaja whe kwun 'ink'ez tse dizk'un-i ndus de yak'uz ts'e náilhtan, 'ink'ez ts'iyawh gak hubulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","'Ink'ez ndet dzin 'uwhutanelh whe yinka dune ye' be hóodutaltselh, 'et whuz un'a ndó tanelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","'Et 'oh de dzin, mbe dune dubun k'ut nalyis whe, 'en 'aw yo natooja' 'ink'ez duyoh ts'e ye 'unt'oh-i 'aw nayólhchoot ait'oh. 'Et whuz un'a za mbe la dune haníyeh k'et 'ut'en-un, 'en duyoh ts'e 'aw ye 'unt'oh-i hanaóoja' ait'oh. Khun 'uwhutánelh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot oo'at 'en oonalhnih! ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mbe la dich'oh whe khuna-un, 'et 'ududoolyih hukwa 'ut'en-un, 'en ye khuna-i ninta itá'alh. 'Ink'ez mbe la dich'oh whe khuna-un ninta oonin'ai de, 'en 'udutilyih whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Et nohdusni ndiz un'a nja duwhútanelh, 'et 'ulhdzis nane 'ilho lili k'uhuztez. 'Ilhoghun itálchulh, 'ink'ez 'ilhoghun 'awet ndutít'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nane hiti'ulh-i hundunulhdus. 'Ilhoghun itálchulh, 'ink'ez 'ilhoghun 'awet ndutít'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nane, 'enne haníyeh k'et 'uhut'en. 'Ilhoghun itálchulh, 'ink'ez 'ilhoghun 'awet ndutít'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","'Ink'ez, “NeMoodihti nts'e 'udini?” 'et hukwa huyoodulhkut. 'Ink'ez 'ubulhni, “Ndet la nezi usula-un, 'et la tsibalyan huwe' 'ilhootádulh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","'Et Sizi be whuts'odul'eh-i, 'i ghun 'ubulhni. 'Et diz un'a whunehodulh'eh whe nja dutni, dune 'ahoolhyiz tenazdoodli 'ink'ez whulazdootnih junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","'Inka 'ubulhni, “'Et la 'ilhoghun keyoh, 'et ndun nahíyilh-un, 'en 'aw Yak'usda élhniljut, 'ink'ez 'aw dune lhe'ílh'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Et keyoh za 'ilhoghun tsandilh, 'en 'ahoolhyiz yughu ninya 'ink'ez 'uyulhni, ‘Ndun sch'az ditni-un, dásinla-un sba ts'ih'un na'hoonleh!’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Et 'atsulyaz hoont'i 'aw yoozólhts'ai' ait'oh. 'Et 'udek'ez na'dudútni ‘'Aw Yak'usda be lhnuzjut 'ink'ez dune cha 'ants'i sba hinli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","'Et hoonts'i ndun tsandilh sdabe tesudule 'et huwa ooba ts'ih'un na'whutisdlelh, doo ka si nasúdoolhdzas!’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","'Ink'ez neMoodihti 'ubulhni, “Ndun nahiyilh-un ts'ih'un lhe'it'oh-un, daja ni oozúlhts'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Et whuz un'a za mbene la Yak'usda oodune'ne, mbene la dzin 'ink'ez 'ulhdzis-i bulh hits'u tedudlihne, 'enne 'aw talhúbudini. 'Et hoonts'i soo eh buba k'utítnelh? Whuz un'a buba' whutilelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Ink'ez 'unohdusni, 'a cho buba k'utítnelh! 'Et hoonts'i yinka dune ye' ndi yun k'ut whusanája de, soo eh dune ooba 'alha' hoont'ohne naitálelh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Whulohne ts'ih'un un'a 'ust'oh na'hundunúdzun, 'ink'ez 'onghohne, 'enne hintsi' ubunínzun. 'Et huwa Sizi 'enne ndi nawhutnuk 'i be whúts'odul'eh 'i be 'ubulh yalhduk whe nja dúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nane dune Lizwifne bulugliz whucho tenahudutidli ha whuz whehan'az. 'Ilhoghun 'en Pharisee 'unt'oh, 'ink'ez 'ilhoghun sooneya 'ilhunaoos'aih-un 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ndun Pharisee 'en dich'oh usyin 'ink'ez tenadudli whe nja dutni, ‘Yak'usda musi nyudusni. 'Aw 'uyoonne dune dúlhuzt'oh. 'Uyoonne e'whuhalhts'it sooneya be, 'enne 'aw ts'ih'un lhe'it'ohne 'uhint'oh, 'ink'ez ts'ekoo k'us dunene bulh nínta' 'ut'ihne. 'Ink'ez ndun sooneya 'ilhunaoos'aih-un, 'en hoonts'i bundúlh uzt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Lisman totsuk nat sóo hoosnih. 'Ink'ez ndai la sba k'elha unli-i, 'i cha ooloh, 10%, lugliz huwas'aih,’ ni Pharisee. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Et ndun sooneya 'ilhunaoos'aih-un, 'en cha 'udun usyin. 'Aw ndo hoonts'i yutó'en ait'oh 'ink'ez yo nilh'ai. 'Ink'ez dudzi k'ut hoolhchis, ‘Yak'usda sgha te'ninzeh! Lubeshi 'ulh'en-un 'ust'oh,’ ni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","'Et Sizi 'ubulhni, “Nohdusni ndun sooneya 'ilhunaoos'aih-un, 'en Yak'usda nalh ts'ih'un na'uja whe duyoh ts'e naoosja. 'Et 'ilhoghun 'aw ndúlhinel. 'Et ndiz un'a nja dúhoont'oh, mbe la duba na'udzoo'-un, 'en yooya yutilhtselh. 'Ink'ez mbe la yo 'údudildzun-un, 'en Yak'usda ndo ná'yutilelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","'Et 'awet chalhts'ulne highu ninla khun tilah buk'udólni ha. 'Et yugha hodul'ehne honilh'en whe dah buhutni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","'Et hoonts'i Sizi yugha hodul'ehne 'anih 'ubulhni, “Whute ts'oodunneyaz sts'ó toodilh. Khun te dah budóhni' junih. Mbene la Yak'usda whe lerwe unli-un whuz dilhts'ine, 'enne ndunne ts'oodunneyaz ubunduhúlt'oh whe' hint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Soo ts'ih'un 'alha' nohdusni, ndet la Yak'usda whulerwe unli ts'e, mbene la Yak'usda bulerwe unli-un 'aw ts'oodunneyaz k'un'a lhuhuhóolhchulh de, ndunne 'aw whuz dahóoya' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","'Et 'awet 'ilhoghun dune moodih uncha-un 'en Sizi yoodulhkut, “Dune hodulh'eh-un unzoo-un, nts'en'a la datisnelh whe 'ilhiz khutisnalh-un whuch'a ootásdoh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","'Inka Sizi 'uyulhni, “Di ha sudini, unzoo-un sudini? 'Aw 'ilhoghun unzoo-un hooloh. Yak'usda 'en za unzoo whé 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ndai Yak'usda khuni dune butl'aidan'ai-i, 'i t'eninzun. Khun te ts'ekoo bulh ninta ooht'en junih. Dune soolhghelh junih. 'Undunooht'ih junih. 'Uyoonne ba hoohts'it junih. Nohbá 'ink'ez nohloo bulh budólhti'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","'Et 'uyulhni, “Usool da' whuts'un, ndi ts'iyawh ook'une' zust'en.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","'Et Sizi njan whudants'o whe 'et 'uyulhni, “'Awhuz 'ilhoghun mba 'et whuz'ai. Ndai la int'i-i ts'iyawh be 'óonket, 'ink'ez tel'enne gha nín'aih. 'Et de la ndo yak'uz dizti'-i, 'et mba oola'. 'Ink'ez 'anih se' 'ut'en k'oh tune' ónt'en ha sunanyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","'Et whudánts'o whe tube oodzi yo 'úja. Ndun dune tube hoonzoo' 'unt'oh-un 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","'Et Sizi yunilh'en whe ndun dune tube oodzi unduda suli', 'et 'utni, “Hoonzoo' 'unt'ohne dawhulcho whe buba howa whulna' whe Yak'usda whe lerwe unli ts'e hutidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","'Et ndi khuna ncha-i, camel huyulhni, 'i ooba howa whulna' whe ughabatsulh oolatoh ookonín'a-un hukwutilgwulh. 'Et whuz un'a whanus howa whulna' whe hoonzoo' 'unt'oh-un Yak'usda lerwe unli-un datíyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","'Et mbe la whudants'one 'uhutni, “Mbe za suba doojih?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","'Et hoonts'i 'ubulhni, “Dunene ndai bulh 'uhuhooleh ait'oh, 'et hoonts'i Yak'usda ba huwa lhúhoolna' whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","'Et Peter yatilhduk whe Sizi nja dúyulhni, “Whunilh'en ndai la ts'ut'i-i, 'i ts'iyawh oolazditni 'ink'ez nye'ut'en k'oh ts'e ts'oot'en ha nyuts'un tizdil.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","'Ink'ez 'ubulhni, “'Alha nohdusni, ndet Yak'usda whe lerwe unli-un, 'et huwa dune duyoh huwu tizya de, k'us dudusneke, k'us dulhutsinke te, k'us du'at, duzkeh cha, ndi ts'iyawh huwu tizya de, ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","'et mbe la 'et ndúja-un, 'en 'on nus lhat-un ootl'anaóotikulh. 'Et nus de whusahóolts'ut de, 'et de 'ilhiz khutinalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","'Et 'awet ndunne whunizyanne 'on 'at nane, 'enne 'udun nebuninla 'ink'ez 'ubulhni, “Soo zulhts'ai, Jerusalem ts'uztidulh 'ink'ez yinka dune ye', ndunne nus hoo'enne, 'en ghun 'uk'ehuyanguz-i, 'i ts'iyawh lhawhudutaneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Lizwifne 'udun yun k'ut whut'enne butl'ahítilhtelh. 'Enne highu notilyeh, 'ink'ez highu tidloh, 'ink'ez higha dútazoh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Huyootalhtsus 'ink'ez hituzilhghelh. 'Et whulh tat dzin dunadutádalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","'Ink'ez njan ubúlhni-un, 'aw bubeni tálhodulhts'it. Ooghuni daja ni buch'a whuntist'i whe' hoont'oh. 'Aw daja ni whe 'utni-un, 'aw t'ehonúszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","'Et hukw'elh'azyaz Sizi keyoh Jericho whenghoh uyalh whe, dune hoos̱'en-un ti whuzih usda, 'ink'ez datso. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","'Et dune lhane 'oh whuya udulh whe 'et buduzts'ai. “'Et dawhut'en whe' whutni?” ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","'Et 'uhuyulhni, “Sizi Nazareth whut'en-un 'oh whuya uyalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","'Et huyih, “Sizi, David oots'u hainzut-un, sgha te'ninzeh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","'Et 'udetso udulhne khuni ulhtus-i be, “T'eduzinih!” huyúlhni. 'Et hoonts'i 'on nus nint'i whe huyih, “David oots'u hainzut-un, sgha te'ninzeh!” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","'Et Sizi 'ilhiz neninya 'ink'ez dune hoos̱'en-un duts'e' hítoolhtelh ubúlhni. 'Et Sizi hizih nehinilhti whe yoodulhkut, ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ndet mba 'uwhutisdlelh hukwa' ninzun?” “Moodihti doo cha za hoos'en nasilhtsi!” ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","'Et Sizi 'uyulhni, “Hon'en naoodle'! Mba 'alha' 'ust'oh-un 'et huwa soo na'inja.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","'Et 'aho hoo'en nasdli', 'ink'ez Sizi yuntizya 'ink'ez Yak'usda dilhti'. 'Et ts'iyanne, mbene la whunalh'enne, 'enne cha ts'iyawh Yak'usda hudílhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","'Et Sizi 'awet Jericho ts'oozya 'ink'ez 'oh whuya lhuseya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Ink'ez 'et la 'ilhoghun dune 'en 'et usda, Zacchaeus huyulhni. 'En sooneya 'ilhunaoos'aihne bumoodih, 'ink'ez soo din'a-un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","'Ink'ez Sizi mbe 'unt'oh yuntilh'elh hukwa' ninzun. 'Et hoonts'i 'ilhunaoosdilne, 'enne bugha 'aw yoo'en ait'oh. Ndun dune tube ndukw 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","'Inka butso tilhgai 'ink'ez duchun, Sycamore huyulhni yuntilh'elh ha, 'et hukwa 'i k'ut dugailget. Whuz un'a Sizi 'oh whuya lhutiyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Et Sizi 'et neninya, 'et ndo yútan'en whe yutilh'en, 'ink'ez 'uyulhni, “Zacchaeus 'a cho 'andit 'aho nanáindaih! 'Andit dzin nyoh tisdalh huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Inka 'a cho nanája. 'Ink'ez hoont'i' whe duyoh ts'e yughu nuséya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","'Et ts'iyanne hinalh'en whe whuts'o disnih, 'ink'ez howu yahalhduk whe 'ulhodutni, “Ndun lubeshi 'ulh'en-un, 'en zih tidalh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Et hoonts'i Zacchaeus dudinya 'ink'ez Moodihti 'uyulhni, “SMoodihti whunilh'en, ndai la ust'i-i ts'iyawh lhulcho tel'enne gha tisdlelh. 'Ink'ez mbene la bube' hoosts'itne, 'enne dit 'et 'uniltsuk-i butl'anátis'alh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","'Et Sizi 'uyulhni, “'Andit dzin dune hiye dujis-i whe njan yoh dilhts'ine bugha íyults'ut. Ndun 'en cha Abraham ts'u hainzut whe 'unt'oh 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Alha mbene la ninta ninkatne, 'enne yinka dune ye', 'en bukúntitalh 'ink'ez 'ubutilhyih ha, 'et whuba whusainya.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","'Et njan hidants'o whe ndai la 'uyoo khuni be whúts'odul'eh-i be bubulh yawhénilhduk. Jerusalem whenghoh hidulh 'ink'ez ts'iyanne 'uhuninzun ndet Yak'usda whe lerwe unli-un, 'awet soo 'aho whe óodutaltsilh huninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","'Et huwa ndiz un'a 'ubulhni, “'Ilhoghun dune ncha-un, 'en nilhdza' keyoh ts'u tiyalh. 'Et whuz oozya de, 'et ndun nts'ez de dukeyoh ts'u hainya-un, 'et whuz whulerwe hitilhtselh. 'Ink'ez 'et dukeyoh ts'e nátidalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tiyalh whutso whunizyanne dude 'ulhnane 'anih ubudani'. 'Ink'ez ilhoghun hinli whe sooneya dizti'-i, 'ilho butl'ain'ai, 'ink'ez 'ubulhni, ‘Whusanátisdalh whuts'un be óoht'en 'ink'ez be 'é'oohleh,’ ubulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","'Et hoonts'i bulh keyoh whut'enne hika lhe'nizun. 'Inka whinya hukw'elh'az 'aho njan keyoh whudune'ne, 'enne whulohne 'utahábahanlane, 'enne keyoh whunat whuz whebahalh'a' buba yahutilhduk ha, ‘'Aw ndun dune 'aw nelerwe oole' hukwa lhe'uznízun,’ hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","'Et ndun dune lerwe suli' whe whusanája, 'et ndunne dude 'ulhnane, mbene la sooneya butl'ain'aine, 'enne 'anih ubúlhni. 'Ilhone hinli whe daltsuk hiba inla-un 'et nahootá'alh hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","'Et 'udechoo-un yughu ninya 'ink'ez 'uyulhni, ‘SMoodih ndi sooneya dizti'-i szih nenín'ai-i, 'i be whunizyai 'uniltsuk-i be mba 'usdla.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","'Ink'ez 'uyulhni, ‘Se 'ulhna-un, tube soo 'ínja! Ntsool-iyaz ntl'as'ai-i, ts'ih'un un'a be ne'zint'en. 'Et huwa whunizyat-un keyoh whuti whumoodih tanleh 'et ntl'ahóos'ai.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Et bulh nane whusainya 'ink'ez 'uyulhni, ‘SMoodih nzooneya dizti'-i szih nenín'ai-i, 'i be kwulat 'uniltsuk-i be mba 'usdla,’ yúlhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","'Et ndun 'uyulhni, ‘'Et huwa nyun cha kwulat-un keyoh whuti whumoodih tanleh, 'et ntl'ahóos'ai.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","'Et 'uyoon cha yughu ninya 'ink'ez 'uyulhni, ‘SMoodih soo zilhts'ai. Nah njan nzooneya dizti'-i szih nenín'ai-i. 'I dzezoh be be' zuschuz 'inkez mba 'et 'us'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Aw dune te'ninzun-un lhínloh t'enyunúszun, 'et huwa nyenuzjut. Ndai la nch'e' lhiloh, 'i hoonts'i nailhchuk. Ndai la 'alhnuzinloh-i, 'i hoonts'i hanínle,’ yulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","'Inka 'uyulhni, ‘Nyunch'oh nze whe dája dini-un, 'et whe mba nahutisyeh. Se'ulhna-un intsi', 'aw huba inzoo-un hooloh. T'eooninzun dant'oh-un dune usdli. Ndai la dalhúzus'ai-i, 'i hoonts'i uschuk. 'Ink'ez ndai la 'alhnúsdlel-i, 'i hoonts'i hanúsdlih 'ink'ez be sooneya us'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'Et 'oh da' di ha nyoonne sooneya lhk'unáda'aihne uszooneya 'enne butl'alheyin'al? 'Et de da', whusanasja de, 'on 'un be 'é'oosdleh?’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Et de 'onghoh nudilhyanne 'ubulhni, ‘Ndi sooneya dizti'-i ooghu nayulhchoot. 'Ink'ez mbe la whunizyai inla-un, 'en oogha ínah'aih.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","'Et hoonts'i 'uhuyulhni, ‘Moodih 'uda' 'awet whunizyai ut'i.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Et huwa nyoon dune dizti'-un 'en 'utni, ‘Mbene la hoonliyaz 'ut'i-un, 'en 'on 'un lhai oogha tít'alh. 'Ink'ez mbe la hoonliyaz lhit'ih-un, ndai 'aw 'i yut'i, 'i hoonts'i ooghu nayitálchulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Et ndunne mbene la sch'az ditnine, skalhe'hunízun whe bulerwe tisdleh, 'enne ts'iyawh sábahle 'ink'ez soo sbut 'et bubahghan.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","'Et ndubúdani'-un hukw'elh'az Sizi Jerusalem ts'o tizdil whe butso tizya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","'Et 'awet shusyaz, Olive huyulhni, 'et la keyoh whuyaz Bethphage 'ink'ez Bethany huwhutni shusyaz zih whuzdla. 'Et shusyaz whenghoh hidulh whe nane yugha hodul'ehne ubutílh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","'Ink'ez 'utni, “Keyohyaz nohanch'az ts'e whuz ah'us. 'Et 'awet keyoh whuyaz nenah'az de, 'et la 'ilhoghun yeztliyaz, donkey huyúlhni, whédint'i, 'i 'aw whutso da' 'awhuz dune yuk'ulhídoh-i, 'i tih'elh. K'unaooh'uk 'ink'ez ndiz tóolhdlooh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Et dune nohoodulhkut de, di ha 'ulh'en k'unah'uk? 'Et njan dúdohni' la, neMoodihti yuka' ninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","'Et ndunne whebalh'a'ne whuz hooz'az whe, soo nts'en'a la daja ni-un, 'et whuz un'a nahuhoon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'Et 'awet nyoo yeztliyaz k'unuháyu'uk whe ooch'e'ne 'ubuhutni, “Di ha 'ulh'en ndi yeztliyaz k'unah'uk?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","'Ink'ez 'et 'ubuhútni, “NeMoodihti yuka' ninzun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'Et 'awet Sizi highu hinílhdlukw. 'Ink'ez dich'oh dunaih yeztliyaz hik'ehúyinla, 'ink'ez Sizi hik'ehúyilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","'Et 'awet tizya whe dunaih ti yun hiba nehínilhbal. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","'Et 'awet njan shusyaz, Olive huyúlhni, 'awet whuduhándil whe 'et huwu nilhdukw whe, 'et lhane yugha hodul'ehne huhóost'et. 'Et ndet da' dáhooltus-un 'uhóoja-un 'et honalh'en da', 'et huwa soo tube cho Yak'usda hudilhti'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","'Ink'ez 'uhutni, “Lerwe 'en Moodihti boozi' be whusainya-un, 'en 'uk'enus hoonzoo-un oogha whults'ut! Ndo yak'uz 'et soo whudutághel, 'ink'ez 'et soo 'udedo 'et k'us whudutati'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Et la whulohne Phariseene butoh whuts'un hits'u huyih, “Dune hodulh'eh-un, nye hódil'e'ne hukwa' budini!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","'Et hoonts'i 'ubulhni, “Nohdusni, njan t'ewhudusnih de, tse 'i hoonts'i da' 'aho la yatoolhdih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","'Et keyoh whuti whenghoh uyalh, 'et Jerusalem whutilh'en whe howintse. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","'Ink'ez 'et ndutni, “Nohni Jerusalem whut'enne, nohni hoonts'i, 'andit dzin soo cho uncha t'eoonahzun nohdzin 'uhoont'oh. 'Et huwa da' t'eoonóhzin nts'en'a whe nohba whudutághel-un. 'Et hoonts'i 'andit whuts'un nohna ch'a whuntist'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Et 'oh de dzin whusaootilts'ulh ndet la nohch'az ditnine nohnahutigus. 'Ink'ez lhez lhk'ehitalhkulh nohnat ndulcho whe, 'ink'ez whez ts'e nohuhootatun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","'Ink'ez njan keyoh whuti-un lhk'unahuhootálhkulh. 'Ink'ez mbene la whez ts'e dilhts'ine, 'enne cha ts'iyawh bubulh 'uwhútanelh. 'Aw 'ilho tse lhk'udiz'ai-i nohba 'et nenálhodutas'al. Nts'oh whuya whudizulh-un 'uhooja nohulhyis-un nohts'ó whusatiyalh-un, 'aw t'elhonáhzil, 'et huwa whuz un'a 'uwhutánelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","'Et lugliz whucho whuna'niztl'oo-un daninya 'ink'ez 'óoketne 'ink'ez 'e'óoketne, 'enne ts'iyawh tenábuninyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","'Ink'ez 'ubulhni, “'Uk'ehóoguz whe' nja dutni, ‘Syoh 'et tenadudli bayoh 'úhoont'oh.’ 'Et hoonts'i 'et cha nja dutni, ‘'Undunut'ihne bayoh whuzúlhtsi.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","'Ink'ez 'et nyoo lugliz whucho dzin totsuk dune hodulh'eh. 'Et hoonts'i soo 'udedo lubretne, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'ink'ez dune tso whudilhdzulhne cha, ts'iyawh nts'en'a hituzilhghelh-un 'et hukwa hitís'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","'Et hoonts'i 'ilhunaoosdilne, ts'iyawh hinat nódilhya 'ink'ez soo cho huyoozílhts'ai. 'Et huwa 'aw nyoonne hizoolhghelh ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","'Et 'oh da' 'et 'ilhudzin diz un'a 'et dúhooja. Lugliz whucho Sizi dune hodulh'eh whe khuni unzoo-i be bubulh yalhduk whe 'udedo lubretne, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'ink'ez 'alhgoh 'utso whudilhdzulhne, 'enne hik'udugháhinya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","'Ink'ez 'uhuyulhni, “Nedini ndai gha dune ando 'int'oh whe ndowhi 'ut'en oowaina? K'us mbe ntl'ahón'ai whe 'udini?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","'Et hoonts'i 'ubulhni, “Si cha 'ilhoghun hukwa nohoodutaskut, 'et sudáhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nts'en'a John dune too be 'úlh'en? Mbe yutl'ahon'ai dune too be tilh'elh huba? Yak'uz ts'e tilah hahóolts'ut, k'us ndi yun k'ut dune tilah ts'u hahóolts'ut?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dich'oh lhtoh howu yahalhduk 'ink'ez 'uduhutni, “'Et yak'uz whuts'un tilah hahóolts'ut ts'utni de, 'Et la di ha John nohba 'alha' lhe'dusni, nedóni' la. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","'Et hoonts'i dune ts'u hahóolts'ut, ts'utni de, 'et dune ts'iyanne la tse be nehooghan. John 'en nus hoo'en-un 'unt'oh 'et buba 'alha' 'uhoont'oh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Inka Sizi nduhuyulhni, “'Aw nts'ez de hahóolts'ut t'ets'onúszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","'Ink'ez Sizi ndubulhni, “Ndai be dune ando 'ust'oh whe ndi nja duwhús'en-un, 'et si cha 'aw nohdósni' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'Et 'awet 'uyoo khuni be whúts'odul'eh-i be bubulh yawhénilhduk whe nja dutni, “'Ilhoghun dune haniyeh k'et ts'ekoo too' mai 'ananla. 'En la njan haniyeh k'et ndunne há' nulhyehne bughu whulh'ai, 'ink'ez sa' wheni nilhdza' keyoh ts'e whinya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","'Et la 'awet mai oontajin néwhuninzut whe 'ilhoghun de 'ulhna-un buts'ú whe yalh'a'. 'Et la ndai mai oots'ítikulh-i, 'i la ooloh highá nodzaih. 'Et hoonts'i nyoonne haníyeh k'et bughu whulh'aine, ndun 'ulhna-un yahíyalhchus 'ink'ez la za-i whe whenáhinanyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","'Inka doo cha 'uyoon de 'ulhna-un buts'ú whilh'a'. 'En cha yahíyalhchus, 'ink'ez yooya hiyulhtsi, 'ink'ez 'en cha la za-i whe whenáhinanyoot. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Et búlh tane dude 'ustlen-un buts'ú whilh'a'. 'En cha ka húyulhtsi 'ink'ez tenáhinino. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'Et la haníyeh k'et whut'i-un 'utni, ‘Daoosneh cha há la? Sich'oh sye' ookw'esi'-un, 'en la buts'ítoos'a'. 'En tilah hiyan'en de, 'unt'oh-un k'un'a né'yiyoolh'en,’ ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","'Et hoonts'i ndunne bughu whulh'aine hitilh'en whe 'et 'ulhodutni, ‘Ndun 'en nyoo haníyeh k'et ooch'e'-un 'en ooye' 'út'en. Ts'uzoolhghelh! 'Et de la ndet la oots'ó tilts'ulh-un ts'iyawh 'et ndúwhulcho whe nets'ó toolts'it.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Inka njan haníyeh k'et tenáhinino 'ink'ez hizilhghi. 'Et huwa soo cho nohdusni, nyoon haníyeh k'et ooch'e' hoonli-un, dábooleh suba? ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ndiz un'a nja dutínelh, whusanátidalh 'ink'ez ndunne mai k'et bughu whulh'aine, 'enne ts'iyawh gak ubutilhtselh. 'Ink'ez dumai' haníyeh k'et 'uyoonne gha óotalh'alh.” 'Et dune hohodánts'o whe 'uhutni, “'Aw uncha 'et dulhúhoonel!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","'Et Sizi ubunilh'en 'ink'ez 'utni, “Ndi Yak'usda ooghuni daja ni whe 'uk'eguz, ‘Ndi tse yoh 'uwhulh'enne 'ún hidutilh'uz-i, 'i yoh 'ook'uwhuz'ai-un huba soo 'uk'enus tse 'unt'oh-i suli'.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Mbene la ndi tse hik'ilts'utne, ts'iyawh yahidutátih. 'Ink'ez mbene la ndi tse buk'édilts'utne, ts'iyawh musai hutileh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndunne Lizwif lubret bumoodihne, 'ink'ez ndunne Moses be 'udustl'us 'uk'ununáguzne, 'enne cha, 'et soo 'et sadzi hunit'oh-un, 'enne Sizi hiyólhchoot hukwa' hut'en. 'Et hoonts'i ndunne dune bubé hunuljut 'et huwun 'aw 'uhooneh ait'oh. T'ehoninzun ndi khuni bé whuts'odul'eh-i, 'i be didut buch'az yalhduk whe 'utni 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","'Ink'ez highunli, 'ink'ez ts'ih'un 'unt'oh na'dudil'i nunúl'i'ne, 'enne hits'un whílh'a'. 'Enne khun tilah Sizi ye yalhduk-i, 'i gha la huyoolhgooh. 'Et de la yun k'ut whut'enne bumoodih yutl'ahúyoolhtelh. 'En 'unt'oh hoolhtus te ne'ut'en, 'ink'ez ts'iyanne k'une' 'ul'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","'Et nunúl'i'ne huyoodulhkut, “Whunehodulh'eh-un t'ets'oninzun ts'ih'un un'a yailhduk. Ts'iyanne mba lhgha 'únt'oh. 'Et ts'ih'un un'a Yak'usda k'un'a dune hodilh'eh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nedini ndi yun hik'elha huyilh'i-i, tax huyúlhni-i, 'et ts'ih'un tilah 'uhoont'oh whe lerwe Caesar 'en ooba k'elha ts'uyoolhtselh, k'us 'awundooh tilah?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","'Et hoonts'i Sizi t'eooninzun 'onilha 'uhutni. 'Ink'ez 'ubulhni, “Di ha sóolhdzih? ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","De' nyoo sooneya snalhts'et nah'a! Mbe oonin 'ink'ez boozi' cha ook'usguz?” 'Et 'uhuyulhni, “Lerwe Caesar 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","'Et Sizi 'utni, “'Et huwa ndai la Lerwe Caesar ooch'e', 'i ootl'anáyahle. 'Ink'ez ndai la Yak'usda ooch'e', 'i cha Yak'usda tl'anáhle.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ndai khuni be la dunene bubulh yailhduk, 'i gha 'aw huyoolhgooh ait'oh. 'Et njan ts'iyanne nalh bubudáni' whe tube buba hooncha suli', 'ink'ez ndunne nunúl'i'ne, 'enne ts'iyawh t'ehudínel. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Et oolune Saduceene Sizi highu nindil. 'Enne la 'uhutni dats'úzsai 'ink'ez 'aw nats'ukhótnah aít'oh. 'Ink'ez huyoodulhkut, ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Dune hodulh'eh-un njan Moses daztit'elh-un neba 'uk'ehonguz whe' hoont'oh. 'Et 'ilhoghun dune buzkeh hooloh whe dazsai 'ink'ez oo'at khuna de, ndun dune bulhutsin 'en dughe inle'-un yughu naooda' huba' hoont'oh. 'Ink'ez bubuzkeh whúzdli' de, 'et de la ndunne ts'oodunne ndun dazsai-un, 'en boozi' huyólhchoot huba' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","'Et 'uhoont'oh lhtak'ant'ine lhulhutsinke hoonli. 'En 'udetso whudilhdzulh-un, 'en 'at ut'i. 'Ink'ez 'aw buzkeh hooloh whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'Et bulh náne 'en ndun ts'eke yughu nasda. 'En cha ndun dune buzkeh hooloh whe dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","'Et bulh tane, 'en cha yughu nasda. 'Et whuz un'a za ts'iyawh lhtak'ant'ine, 'enne ts'iyawh ndun ts'eke highu dálts'i'. 'Ink'ez ts'iyawh bubuzkeh lhuhóolel whe yahadla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","'Et 'udek'ez ndun ts'eke 'en cha dazsai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Et ndet la dune dunadidil de, ndun ts'eke mbe oo'at tileh? Ndunne lhtak'ant'ine ts'iyawh ndun ts'eke 'enne bughinda'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","'Et Sizi 'ubulhni, “Dune 'ink'ez ts'ekoo te ndi yun k'ut ts'iyawh lhgho dilhts'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","'Et ndet la 'oh de de whusawhútilts'ulh whe mbene la Yak'usda ba hoonzoo whe bughá whults'utne yaidlanne toh dunahudutádulh 'ink'ez yak'uz hutidulh. Whuz 'aw dune lhghu lhdílts'ih whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","'Aw doo cha yahódlah ait'oh. 'Enne Yak'usda buzkeh huzdli' 'ink'ez lizasne ubulh hulhgha 'uhint'oh. 'Enne dujihne 'uhint'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","'Ink'ez Moses 'en ts'ih'un newhunin'ai yaidlanne dunahudutádulh whe' hoont'oh. 'Et 'oh da' njan dahooja la dilhtan-i toh whudizk'un 'et hoonts'i 'aw whudók'un ait'oh. 'En Moodihti ghu yalhduk whe nja dutni, ‘Abraham ooYak'usda, Isaac cha ooYak'usda, 'ink'ez Jacob cha ooYak'usda 'unt'oh,’ ni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nohni 'uts'un un'a unahzun. 'Aw yaidlanne buYak'usda lhiloh, khunane buYak'usda 'unt'oh. Soo cho whunulh'en, 'en be ts'iyanne khuna.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","'Ink'ez whulohne Moses be 'udustl'us 'uk'ununáguzne 'uhuyúlhni, “Dune hodulh'eh-un tube soo' dinja!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","'Et whehunilhjoot k'et 'aw 'on 'un huyoodolhkut ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","'Ink'ez 'ubulhni, “Nts'en'a oolohne nduhutni, Christ dahni-un, 'en David oots'u hainzut-un 'unt'oh? ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David dich'oh 'et dutni njan Yak'usda ooghuni Shun be 'udustl'us k'ut, ‘Moodihti 'en SMoodihti 'uyulhni, Snailhni ts'unk'us sinda, ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","'oh de la nch'az ditnine buk'ut nke naóolhyis mba ubooselh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","'Et huwa David, ‘SMoodihti,’ yulhni, nts'en'a suba Christ 'en oots'u hainzut-un oole'?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","'Et ts'iyanne dune huyoozilhts'ai whe Sizi yugha hodul'ehne 'et ndúbulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Moses be 'udustl'us 'uk'ununáguzne, 'enne la naih nyiz-i be húdilhts'i, 'ink'ez ndet la t'alh-i be 'óoket-un, 'et ts'iyanne hubodílhti' whe hadih buhútni, 'et huhóont'i'. 'Ink'ez lizwif bulugliz soo k'us hoonzoo-un hudutálts'ilh hukwa' huninzun. 'Ink'ez dune ghunuda-un, soo k'us hoonzoo-un hutidalh whuka' huninzun. 'Et ndunt'ohne soo cho buka tse hoohli! ");
INSERT INTO crxNTpo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Enne 'uhint'oh tsandilhne buyoh bugha hahódunit'ah 'ink'ez bughu huhoolhchuk. 'Ink'ez 'onilha sa' cho tenahududli hoohoolh'i. Ndunne, 'enne 'on nus 'uwhulcho whe buba nahutideh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","'Et doo cha ndo yútan'en whe hoonzoo' 'unt'ohne ndai sooneya howa híta'alh-i, 'enne sooneya be kát-i be húya'aih, 'et 'ubunilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","'Ink'ez 'ilhoghun tsandilh tel'en-un, 'en ndai la 'aw 'iyaz yut'i-i, nanki sooneya tsuditi'-i, 'i deyán'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","'Ink'ez 'ubulhni, “'Alha nohdusni, ndun tsandilh tel'en-un, ndunne ts'iyawh buba nus lhai deín'ai whe 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Soo cho whunulh'en, ndunne hoonzoo' 'unt'ohne ndai la lhai huyut'i-i, 'i Yak'usda ba hiloh za dehúyan'ai. 'Et ndun tsandilh tel'en-un 'aw 'i yuk'ehútinalh-i, 'i ts'iyawh deyán'ai.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","'Et oolune 'awet lugliz whucho howu yahalhduk 'ink'ez hutni, “Lhe'whuldzoo'yaz tse lhe'uldzoo' 'i be 'uhoolya. 'Ink'ez Yak'usda gha t'aih 'i cha 'i be 'uhoolya.” 'Et Sizi 'ubulhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ndai la ndi ts'iyawh nulh'en-i, 'oh de whusaóotilts'ulh whe 'aw 'ilho tse lhk'ulhdutásdlal, ts'iyawh nadúntijulh whe' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","'Ink'ez huyoodulhkut, “Whuneoodulh'eh-un, nts'o whúde 'uwhutánelh? 'Ink'ez 'awet nilhdukw suli' de, dant'i-i be whe hóodutaltsilh, 'et la huwa t'ets'onoozeh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","'Ink'ez 'ubulhni, “Soo cho howahli. Khun te dune nanohonoo'ah junih. Lhane soozi' gha whusahútidulh 'ink'ez 'uhudutinelh, ‘Si 'en 'ust'oh,’ 'ink'ez 'awet whusawhútikulh, hutni de, khun te ubuntoohya' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dune lhugan-un whulhúdahts'o de, 'ink'ez dune lhdulhyoh nehóninla de, njan 'et 'udechoo whusawhútikulh whe' hoont'oh. Khun te whénoolhjut junih. 'Awhuz whulatoh-un, 'aw whenghoh iloh 'uhoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","'Et 'ubulhni, “Lhelhdowh didowhne lhch'az nehúdutadulh. 'Ink'ez yinka ndulcho lerwe be 'ustlene, 'enne cha lhch'az nehúdutadulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Lhelhdun ndulcho whe wheóonujut whe yun nuhútitnah. 'Ink'ez dai cha 'ink'ez lhane lhelhdun cha dada whutáleh. 'Et ndo yat dune whehunuljut-un hoti'elh, 'ink'ez hooncha-un whe hóodutaltsilh-un cha hoti'elh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","'Et ndoho nduwhútanelh-un whutso, 'et nohotálhchulh 'ink'ez dzoh nunóhotilhdeh. Lizwif bulugliz whumoodihne, 'enne butl'anóhotilelh 'ink'ez 'anohotilelh. 'Ink'ez lerwene 'ink'ez yun humoodihne si soozi' gha 'enne bubut nenohotalelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Et 'oh de si sghun khuni unzoo-i be yátilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'Et huwa 'oh de, ‘Daja doosni' suba’ noohzin junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Khuni 'ink'ez be wháhnih-i nohtl'adutis'alh. 'Et de la mbene la nohch'az ditnine 'aw nohts'oohoodódlai ait'oh. 'Awet buch'a' nilhde 'ink'ez 'aw 'on 'un hoonliyaz 'uhudooni' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'Ink'ez nohdusneke, 'ink'ez nohulhutsinke, 'ink'ez nohnatneke, 'ink'ez nohk'ekene, 'enne whutl'anóhotilelh 'ink'ez whulohne nohtoh nohotighan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","'Ink'ez si soozi' gha ts'iyanne nohts'u dutitni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","'Et hoonts'i Yak'usda 'aw nohla dootnih ait'oh. Nohtsigha' 'aw 'ilho hoonts'i ninta dókes ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Yak'usda ba soo cho núdulhya. 'I gha la nohzul ohtun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ndet la Jerusalem lhuganne whunasguz de, 'et whunulh'en de, 'et huwa la t'eoonoohzeh 'awet nilhdukw suli' nyo keyoh whuti teoodutálneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Et dúhooja de, 'et Judea whut'enne shus k'uz tse hutoolhdilh. 'Et mbene la 'et keyoh whuti 'et dilhts'ine, ts'iyawh whuch'az hoodilh. 'Ink'ez mbene la whunat whut'ine, 'enne cha khun te keyoh whuti-un ts'ó tooya' junih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","'Alha nohdusni 'awet dzoh nutiszut-un whusawhutilts'ulh whe' hoont'oh. 'Et huwun 'uk'ehooguz-un, 'et ts'iyawh lhaóodutaneh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","'Et 'oh de dzin mbene la ulchanne cha, 'ink'ez mbene la duyaz e'úlht'ukwne cha, 'enne buba tube 'on nus hootátsi'. Ndi yun hoontsi'-un ook'e whudutalts'ulh 'et huwa. 'Ink'ez tube Yak'usda ye húnilch'e-i, 'i cha ndunne dune buk'eidutalts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","'Et whulohne saluzti ook'a be ts'iyawh hútigan. 'Ink'ez 'onghohne hitálchulh 'ink'ez lhelhdun keyoh ts'e hubotilhna. 'Ink'ez 'udun yun k'ut whut'enne, buba ne'unguz-un, 'et whuts'un, Jerusalem 'et dulcho whe hukw'unótidulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sa cha 'ink'ez 'ulhzis ooza' cha, 'ink'ez sum cha, 'i ts'iyawh hoonli be hóodutaltsilh. 'Et ndi yun k'ut ndulcho whe lhenyoone dunene, 'enne ts'iyawh tube dzoh notideh 'aw dahútinelh-un ts'iyawh t'ehonúszun. 'Oh de de yatoo' 'i cha tatsi taditni whe taba ndulcho yántighus. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndi yun k'ut daóotanelh la, hukwa tse húhooli 'ink'ez whe hunuljut k'et, whulohne budzi 'etsul 'utinelh. Ndo yat'ah ts'e be hóolhtus-i ts'iyawh ndulcho nohótitnah 'et huwa. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Oh de de, yinka dune ye' kw'us toh ye ulhtus-i be 'ink'ez oots'u hayánduz-i cha, 'et whuz un'a huyuntilh'elh whe whusatíyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","'Et ndiz un'a nja duwhewhúnit'en de, ndo yutoh'en 'ink'ez whunólhni. Nohlaoodutitnih-un 'awet nilhdukw suli'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Et be náwhutnuk 'i be whuts'odul'eh 'i be ubulh yalhduk whe nja ndúbulhni, “Nyoo fig huyulhni ooduchun 'ink'ez 'uyoo duchun cha nulh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Bindai 'awet hawhenilh'az 'i gha la t'eoonohzin danghun 'awet nilhdukw whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","'Et nohni cha whuz un'a nohnalh 'et duwhút'en de, 'et huwa la t'eoonoohzeh Yak'usda whe lerwe unli-un 'awet nilhdukw whe' hoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Alha ts'ih'un un'a nohdusni, 'andit whudizulhne 'aw yalhihitásdla 'et ndi ndótanelh-un ts'iyawh 'et lhawhúdutanelh 'et whuts'un. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yat 'ink'ez ndi yun k'ut cha ts'iyawh gak whutáleh, 'et hoonts'i ndi sghuni 'aw hooloh lhtisdle. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“'Et hoonts'i soo cho khahdli. Khun te stabe zoodulh'i, 'ink'ez tanahtnai, 'ink'ez ndi yun k'ut hooni 'et za huwu nuní nahzut, ndi ts'iyawh 'i be nohdzi be whudoobun junih. Doo ka si 'et dzin soo hukwa tse lhúwhulhlih whe whusahóolts'it. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","'Oh de de, ndi yun k'ut ndulcho whe whudune'ne 'ants'i hulhgooh le'hutinelh whuz un'a khun whusaóotilhts'ulh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","'Et huwa 'ahoolhyiz hukwa tse hóhle' 'ink'ez nts'oh whude daóotanelh-un nohyit 'uwhutánelh-un huba soo 'úlhdzoo' 'ink'ez yinka dune ye' 'en oobut tihyin, 'et huba tenadoohdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","'Awet dzin totsuk Sizi lugliz whucho dune hubodulh'eh. 'Ink'ez hulhgha totsuk ndo shusyaz, Olive huwhútni, 'et whuz wheyaih, titelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","'Et ts'iyanne soo 'uda' cho lugliz whucho dahúdulh huyootuzalhts'ilh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Et 'awet ndi lhes lhuntulhdoh-i, 'i nahitit'ulh, 'awet whenghoh hoozulh. 'Et butus lhuseya-un dzin huwhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","'Ink'ez nyoonne 'udedo lubretne, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, 'enne Sizi whe hituzilhghelh-un, 'et hukónuta. 'Et dunene bube hunuljut 'et huwa whunist'i be né'hut'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Ink'ez Satan Judas ye yínya. 'En 'unt'oh Iscariot huyulhni. Whunizyanne 'on 'at nane, 'enne butoh 'ilhoghun 'en 'unt'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","'Et lubret bumoodihne 'ink'ez saldan bumoodihne cha 'enne buts'u whinya 'ink'ez bubulh hukw'unótilhye' nts'en'a la Sizi butl'aitilhtelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Ink'ez 'awet huhóost'et whe ts'ih'un huyúlhni whunin'ai 'ink'ez sooneya higha tí'alh huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","'Awet Judas buts'u náhizya nts'en'a la dune ch'oh butl'aitilhtelh, 'et hukwunúta. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndet la 'awet lhes lhuntildoh-i, 'i nahitit'ulh dzin whusahóolts'ut. 'Et butus lhuseya-un 'et whunahilni whe ndi 'usbai k'us unzoo-i hituzilhghelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","'Ink'ez 'et Sizi, Peter 'ink'ez John bulh whe balh'a' 'ink'ez 'ubulhni, “Ah'us 'ink'ez neba lhaoodahleh nts'e la butus lhuseya-un 'et na'uztit'ulh-un.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","'Ink'ez 'uhuyúlhni, “Nts'e hukwa' ninzun mba lhats'ódutileh-un?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","'Ink'ez 'ubulhni, “Soo zulhts'ai, ndet la keyoh whuti nenáh'az de, 'et dune nohdudutáyalh. 'En too be sulhdzo-i na'a. 'En nts'e la yoh danátidalh ts'e budánoh'as. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","'Ink'ez 'et la ndun yoh whumoodih 'en la 'udóhni', ‘Whuneodulh'eh-un nja dúnyulhni, ndet la 'uhoont'oh nyoh dune 'ilhodulh-un 'uha'alh wheni? 'Et la sgha hodul'ehne ndi butus lhuseya-un bubulh ná'tist'ulh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","'Ink'ez 'et la doh yo hooncha-un lhaoodint'oh-un whunóhnoolhtun. 'Et lhaoodahleh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Inka whehán'az whe soo nts'en'a la ubudáni', whuz un'a nahahoon'ai. 'Ink'ez 'et butus lhuseya-un 'et wheni lhaháduja. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","'Et 'awet 'oh whuya whudizulh-un whusahóolts'ut, 'et ndunne whunizyanne 'on 'at nane whel'a'ne bubulh natl'adida'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","'Ink'ez ubulhni, “Dzoh nutiszut-un whutso sdzi ndulcho-i be njan butus lhuseya-un 'et nohbulh ná'tist'ulh tube hukwa' nuszun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","'Alha nohdusni, Yak'usda whe lerwe unli-un, ndi butus lhuseya-un lhaoodutaneh, 'et whuts'un, 'aw ndi 'on 'at oos'alh ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","'Et 'awet lubot yilhchoot 'ink'ez duBá musi yulhni 'ink'ez 'utni, “Ulhchoot 'ink'ez ts'iyawh alhgoh ahtnai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nohdusni, Yak'usda whe lerwe unli-un, 'et whusaootilts'ulh 'et whuts'un, doo cha 'aw ndi mai too' oosnai' ait'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'Et 'ink'ez lhes yilhchoot. 'Ink'ez duBá musi yulhni, 'ink'ez taídanyuz 'ink'ez butainínla, 'ink'ez 'ubulhni, “Ndi syust'e 'unt'oh. Nohni nohba huwalti. 'Et ndaht'en de, 'et whe la snaoolhnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'Uhan'al hukw'elh'az 'et whuz un'a za lubot yílhchoot 'ink'ez 'utni, “Ndi lubot 'i suzkai' be 'andidi khuni nohba lhadúsdla-i, 'i 'unt'oh. Nohni nohba nadútilt'ih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","'Ink'ez soo cho whunulh'en, mbe la whu'izyaz dune ch'az ditni-un, 'en njan lutab ba sulh usda. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Alha' hoont'oh yinka dune ye', nts'en'a ooba 'et néwhults'ut, 'et whuz un'a 'et 'uwhutánelh. 'Et hoonts'i ndun dune mbe la whu'izyaz dune tl'aitilhtelh-un ndun dune dáwhultsi'-un oots'u hóolts'ulh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","'Ink'ez didutch'oh dutoh lhoohoodulkut, “K'us mbe suba yulhni, mbe 'utinelh whe 'utni?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","'Et cha 'alhgoh didutch'oh dulhyoh 'uhudutni butoh k'us mbe suba 'uk'enus 'unt'oh-un oole'? ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","'Ink'ez Sizi 'ubulhni, “Lerwe dune k'une' bul'en-un 'unt'oh. 'Ink'ez mbene la buba ndo 'unt'ohne, 'enne nets'un unzoone 'uhint'oh hubuhútni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","'Et hoonts'i nohni nohtoh 'edóht'e' junih! 'Et k'us nohtoh mbe 'uk'enus 'unt'oh-un oole' la, 'en 'udek'oh-un k'un'a oole'. Mbe la nohtso whudilhdzulh-un, nohba ne'út'en-un k'un'a oole'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Daja nahzun? K'us mbe 'uk'enus 'unt'oh-un 'unt'oh? Mbe la lutab k'usda uti'ulh ha, k'us yuba ne'út'en-un? 'Alha 'uhoont'oh mbe la lutab k'usda 'ink'ez 'uti'ulh-un 'en 'unt'oh. 'Et hoonts'i nohni nohtoh nohba ne'út'en-un 'ust'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nohni aht'oh ndet la dzoh nususzut-un, 'et ndulyiz whe sulh 'íht'e'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","'Inka nts'en'a la sBá stl'ahón'ai whe lerwe usdli-un, whuz un'a za nohni cha lerwe tihleh-un nohgha óotas'alh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'Et la nts'e la whe lerwe usdli-un, 'et slutab k'ut sulh utih'ulh 'ink'ez sulh utihtnelh. Ndet la kw'uts'uzda cho dizti'-i, 'et hukw'u dutálhts'ilh 'ink'ez whunizyat-un 'on 'at nat-un Israel oots'u hainzutne bulh didowhne, 'enne buba nahutihyeh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","'Ink'ez neMoodihti 'utni, “Simon, Simon, soo zilhts'ai! Satan tube nohka' ninzun. Tl'o mai' k'un'a ukunohtálhkulh hukwa' ninzun. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","'Et hoonts'i mba tenadisdli, ndet la whe mba 'alha 'ust'oh-un, 'et 'aw nla k'éhahoolts'it ait'oh. 'Ink'ez ndet la sts'u naóozinja de, nyulhutsinke 'enne hilhtusne nabolhtselh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","'Et hoonts'i 'uyulhni, “SMoodihti lhadúst'oh nyulh tisyalh, 'adutis'alh k'us mba datísah.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","'Ink'ez 'uyulhni, “Nyudusni Peter, 'andit dzin lugok dune 'udutinelh whutso, tat, ‘'Aw ndun t'enuzuszun,’ dutanelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","'Ink'ez 'ubulhni, “'Oh da' whenóhis'a' whe, sooneya zus, lhook'ez cha, 'ink'ez neketl'a whulh tl'oo-i ts'iyawh ooyit. 'Aw eh hoonliyaz lhundunuzáhdzit?” 'Ink'ez, “Gak!” huyulhni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","'Ink'ez 'ubulhni, “'Et 'andit mbe la sooneya zus ut'i-un, whute yólhchoot. 'Ink'ez whuz un'a za bé ne'uge-i cha ólhchoot. 'Ink'ez mbe la saluzti lhit'i'-un, 'en duluglok ye 'óket 'ink'ez saluzti 'ilho oket. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Et huwa 'unohdusni, ndet la Yak'usda ooghuni k'ut si sghun 'uk'unúsguz-i, 'i ts'iyawh lhawhúdoneh huba' hoont'oh. Ndiz un'a nja duwhutni, ‘Ndunne 'uk'únulhe'ust'enne, 'en bubun dult'oh hudooni',’ ni. 'Et huwa si sghun 'uk'uneusguz-un 'et lhawhúdoneh huba' hoont'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","'Ink'ez 'uhuyulhni, “NeMoodihti njan whunilh'en nanki saluzti 'et 'us'ai.” 'Ink'ez 'ubulhni, “'I 'awet soo 'últsuk.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","'Et 'awet tenánja whe whutsoda' hukw'un'a nyoo shusyaz Olive huyulhni, 'i k'uz whenaja. 'Ink'ez yugha hodul'ehne, 'enne cha hiyuwhenándil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Whuz hoozdil whe 'et 'ubulhni, “Tank'us úntiht'i-un whuch'a ténadahdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nts'e la tse nazdulh'us-un, 'et 'uwhuldzoh ts'e bughu nenínya. 'Ink'ez dugwutsi be nenínya 'ink'ez tenadudli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","'Et njan dutni, “'UBá hukwa' ninzun de, ndi be dzoh nutiszut-i sghu nahoolhchoot. 'Et hoonts'i 'aw si hukwa' nuszun k'un'a iloh. Nyun hukwa' ninzun k'un'a 'uhóneh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","'Et Khunsul ndus de yak'uz lizas be hoodiltsai. 'En ulhtus náyulhtsi. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tube oodzi unduda whe 'on nus ulhtus whe tenadudli. 'Ants'i uskai' k'un'a oots'u halhdzilh whe yun nadúlt'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tenadudli-un 'etsul 'udija 'ink'ez dunadija whe yugha hodul'ehne ts'odi k'et nahunistez whe bughu nanja, ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","'ink'ez 'ubulhni, “Di ha sahtez? Doo ka si tank'us nóoht'i dunadahdilh 'ink'ez whuch'a tenadahdli.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","'Awhuz ubulh yalhduk whe khunsul lhane dune whuz de údulh. Nyoon mbe la Judas huyulhni, 'en butso uyalh. 'En whunizyanne 'on 'at nane, 'enne bubulh 'ilhoghun 'unt'oh. 'Et Sizi yenghoh neninya naidutits'oos ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","'Ink'ez Sizi 'uyulhni, “Judas, yinka dune ye' nadutánts'oos 'i be eh whunist'i whe whutl'atálhtelh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sizi oonat núdilhyanne, dawhútanelh la 'et honilh'en, 'et 'uhuyulhni, “NeMoodihti saluzti be eh lhts'utigan?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Et 'ilhoghun yuzih usyin-un, 'en Lizwif lubret 'uk'enus dizti'-un be 'ulhna-un nailhni ts'unk'us yudzo yuts'a ha be' yalht'o. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","'Ink'ez Sizi 'ubúlhni, “Ndiz un'a njan dutísnelh, 'et stl'awháh'aih.” 'Ink'ez nyoon 'en oodzo yut'aiznai 'ink'ez soo na'yinla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","'Ink'ez nyoonne lubret bumoodihne, lugliz whucho whusaldanne bumoodih, 'ink'ez butso whudilhdzulhne cha, 'enne la highu nindil, 'ink'ez Sizi 'udubúlhni, “'Et di ha saluzti cha 'ink'ez tut'oh cha nuhle 'ink'ez 'undunust'ih hukw'un'a skatíhdil? ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Et dzin totsuk lugliz whucho nohtoh susda whe, 'aw 'oh da' 'aw sólhchoot hukwa lhe'zaht'en inle'. 'Et hoonts'i 'andit netsudule, tsalhgus yo usda-un, 'en nohmoodih tileh, 'et 'awet nohba né'hunint'o.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Et 'awet Sizi huyilhchoot 'ink'ez lubret 'uk'enus dizti'-un highu dáhinilhti. 'Ink'ez Peter yooniz de yuniyalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Et naniztl'oo bez ts'e whuniz ts'e kwun húdulhk'an 'ink'ez 'alhgoh nátl'ahudilts'i'. Peter 'en cha butoh usda. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Et kwun zih usda whe 'ilhoghun ustlen-un ts'ekeyaz 'en soo yunin ts'e yunilh'en 'ink'ez 'uyulhni, “Ndun dune 'en cha yulh 'ut'en inle'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","'Et hoonts'i yuts'oodildlai 'ink'ez 'uyulhni, “Ts'eke, ndun dune 'aw t'enuzuszun.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","'Et hukw'elh'az 'atsulyaz inle' whe 'et cha 'ilhoghun dune 'uyulhni, “Nyun cha bubulh 'ilhoghun 'int'oh.” 'Et hoonts'i Peter 'utni, “'Awundooh!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","'Et doo cha 'ilho sadzi hukw'uhoonist'o 'et doo cha 'ilhoghun 'uyulhni, “'Alha' hoont'oh ndun 'en cha yulh 'ut'en. 'En cha Galilee whut'enne 'ilhoghun 'unt'oh 'et huwa.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","'Et Peter ndun dune 'en 'uyulhni, “'Aw daja dini-un 'aw t'ewhunuzúszun!” 'Et 'awhuz yalhduk whe lugok dune 'udija. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","'Et neMoodihti Peter ts'u nálh'a 'ink'ez soo yunin ts'e yunalh'en. 'Et Peter 'aho neMoodihti yughuni yunalni daja yudani' inle' whe nja dúyulhni, “Lugok dune 'udutinelh whutso tat t'esunuzínzun dutanelh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","'Et Peter 'az whinya 'ink'ez tube cho intse. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ndunne dune Sizi huyilhchootne, 'enne highudloh 'ink'ez huyoolhchis. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","'Ink'ez hina k'úna'uzguz 'ink'ez huyoonukat 'ink'ez huyoodulhkut, “Neba nus hóon'en, 'ink'ez nedini mbe 'unyinla nyunízkuk?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","'Ink'ez lhat-un hoontsi' whe hich'az yalhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","'Awet yulhkai ibulh dune tso whudilhdzulhne, ndunne 'udedo lubretne nahúlt'oh, 'ink'ez Moses be 'udustl'us 'uk'ununáguzne cha, 'enne 'ilhuhozdil 'ink'ez buba nahíyilhne but nehinilhti. 'Ink'ez 'uhuyúlhni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nyun Christ inli de, nedíni!” 'Et hoonts'i 'ubulhni, “Nohdasni' de, 'aw nohba 'alha' doosni' ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Si cha hoonliyaz nohooduskut de, 'aw sudóhni' ait'oh 'ink'ez 'aw sla nadoohtnih ait'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","'Et 'ink'ez 'andit whuts'un yinka dune ye' 'et la nailhni ts'e Yak'usda whelhtus-un ooda'.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","'Ink'ez ts'iyawh 'uhutni, “Nyun Yak'usda ooYe' eh 'int'oh?” 'Ink'ez 'ubulhni, “Ts'ih'un 'udahni si, 'en 'ust'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","'Ink'ez 'uhutni, “'Aw 'on ghun hoonliyaz highun nedóni' hukwa lhe'ts'unízun. 'Awet whenich'oh ooze ts'odánts'o.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","'Et ndunne dune 'ilhozdilne ts'iyawh dunáhudidil 'ink'ez Pilate but néhinilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'Ink'ez 'awet hik'e whehonin'ai 'ink'ez 'uhutni, “Ndun dune 'en lizwifne tank'us úbunilht'i 'et bulh náts'uhoon'ai. 'Ink'ez lerwe Caesar ts'un ndi yun hik'elha huyilh'i-i, 'i tax huyulhni, 'et cha whuch'a bunízyoot. 'Ink'ez didut mbe la lerwe Christ ts'utni-un, 'en usdli na'dudútni.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","'Et Pilate yoodulhkut, “Nyun eh 'int'oh Lizwif bulerwe inli?” 'Et Sizi 'utni, “A, 'alha' dini.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","'Ink'ez 'et Pilate Lizwif bumoodihne, 'ink'ez 'ilhozdilne ts'iyawh 'ubulhni, “Ndun dune 'aw hoonliyaz ninta' 'ant'en-un ooghu nalhuwhus'al.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","'Ink'ez 'et 'on nus huhunílch'e 'ink'ez 'uhutni, “Yun k'ut Judea ndulcho whe 'ink'ez Galilee yun k'ut cha 'ink'ez njan cha, dune nohni nohch'az nehudodilh whuz un'a whubodulh'eh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","'Et Pilate njan whudants'o whe, 'et uboodulhkut, “'Alha eh ndun dune Galilee whut'en-un 'unt'oh?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","'Et Pilate Sizi lerwe Herod ookeyoh whuch'e' unli t'eoonanzin, 'et 'aho yuts'u wheyálh'a'. Ndun lerwe 'en cha 'oh da' soo 'et Jerusalem 'ut'en inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","'Et la Herod tube hoont'i' whe Sizi yutilh'en. 'Et tube sa' whuts'un yuti'elh hukwa' ninzun 'et huwa. 'Et lhat-un whe yulh údits'o inle'. 'Et huwa khun tilah huwa 'ít'en dunalh 'óohooleh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","'Ink'ez khuni lhai be yoodulhkut. 'Et hoonts'i Sizi 'aw yuts'u t'édusnih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","'Et 'oh da' za nja dúwhut'en whe nyoonne 'udedo lubretne 'ink'ez Moses be 'udustl'us 'uk'ununáguzne, ts'iyawh dunahúdidil 'ink'ez soo tube cho huske be hik'éhoon'ai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","'Ink'ez 'et Herod 'ink'ez yuba lhuganne, 'enne bubulh ts'iyawh hoonliyaz buba lhíloh hinínzun 'ink'ez highudloh. 'Et lerwe nayits'uz-i be húyalhti 'ink'ez Pilate ts'un whe náhuyalh'a'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","'Et soo 'et dzin Pilate 'ink'ez Herod bulh k'eke lhuhulhtsi. 'Et whutso da' lhch'az huditni inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","'Et 'awet Pilate nyoonne 'udedo lubretne, dune k'une' 'ul'enne cha, 'ink'ez ts'iyanne dune, 'enne ts'iyawh 'alhgoh ilhubozdla, ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","'ink'ez 'ubulhni, “Ndun dune, 'en dune tank'us ubunilht'i-un k'un'a, 'en sghu nulhti. 'En nohbut soo ts'ih'un un'a ooghu núnistai. 'Et hoonts'i ndet ook'éwhah'ai-un 'aw hoonliyaz ooghu nalhuwhus'al. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","'Ink'ez Sizi Herod ts'un nohbulh whés'a'. 'En cha whe tank'us 'unt'oh-un yughu nalhuhóo'al. 'Alha' hoont'oh ndun dune 'aw hoonli hukwa daóotsah-un hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'Inka huyootalhtsus 'ink'ez oolanadutisnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Et la njan butus lhuseya na'hut'alh-un 'et 'oh totsuk 'ilhoghun 'adin'ai-un lanahudutni. 'Et whuz un'a buk'oh ts'e 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","'Et 'alhgoh hits'u háyih 'ink'ez 'uhutni, “Ndun Barabbas neba oolanadintnih, 'ink'ez ndun dune sulhghe!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ndun Barabbas 'en gha lhtahuwhunt'ai whe 'ilhoghun dune silhghi 'et hukwa 'ahuyan'ai inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","'Et hoonts'i Pilate 'en Sizi lanadutitnih hukwa' ninzun, 'inka 'ilhozdilne doo cha za bubulh yáilhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","'Et hoonts'i 'on nus hits'u huyih, “Tulalhgus k'eílhtih! Tulalhgus k'eílhtih!” hutni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","'Ink'ez 'et 'awet whulh tat ubulhni, “'Et di ha? Ndet dáhoont'oh whe hoontsi'-un whe ninta' 'unt'en? 'Aw hukw'elha daootsah-un ooghu nalhuwhús'al! 'Et huwa 'ants'i huyootalhtsus 'ink'ez oolanadutisnih.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","'Et hoonts'i 'aw huyoozólhts'ai' ait'oh. 'Ink'ez 'et 'on nus hits'u huyih, “Tulalhgus k'eílhtih!” Daja hutni-un 'ink'ez ndunne 'udedo lubretne, 'enne cha, daja hutni 'et whe Pilate hich'a' nilhde. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","'Inka Pilate nts'en'a hukwa' huninzun hukw'un'a yuba nahizya. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","'Ink'ez ndun Barabbas 'en gha lhtahuwhunt'ai whe 'ilhoghun dune silhghi, 'et hukwa 'ahuyan'ai, 'en Pilate buts'un yulanaditni. 'Et hoonts'i Sizi 'en nts'en'a hukwa' huninzun k'un'a 'uhitilelh ha butl'ayálhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","'Awet Sizi hitilhti whe 'ilhoghun dune Simon huyulhni, 'en Cyren whut'en-un 'unt'oh, 'en whenghoh keyoh ts'e hainya, 'en Sizi ootulalhgus yuba idutootan ha hiwus k'ehídintan. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Lhane dune hiyuntizdil, ts'ekoo cha. 'En gha ts'odi hinli 'ink'ez hutso. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","'Ink'ez Sizi buts'u nalh'a 'ink'ez 'ubulhni, “Nohni Jerusalem whuts'ekoo', si sghahtso iloh. 'Et k'us nohnich'oh khunahtso, 'ink'ez nohuzkehke cha ghahtso. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Soo cho whunulh'en, dzin whuz de hóokulh whe' hoont'oh, 'et la 'uhudooni', ‘Mbene la buzkeh hoolohne, mbene la 'aw lhe'ílhtsilne, 'ink'ez mbene la chalhts'ul 'ulhe'ílht'ukwne, 'enne 'oh de de 'on nus buba soo' whutat'elh.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","'Oh de de 'et la dune 'uhudooni' ‘Ndi dzulh 'i uncha nek'énit'ai 'ink'ez ndi shusyaz 'i cha dulcho be nek'enáhokat.’ ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'Alha' hoont'oh, duchun 'awhuz duli whe 'et hoonts'i 'awhuz njan 'et duhút'en. Duchun disuz de, dawhútanelh nahzun?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Et nane untsi'ne, 'enne cha, huyulh bubotuzilhghelh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","'Ink'ez ndet la shusyaz Calvary huwhútni, 'i 'utsints'un niz'ai huwhutni-un, whuz huyoolhti whe, 'ink'ez tulalhgus k'ehuyilhti. Nyoonne dune ntsi'ne, 'enne 'ilhoghun nailhni ts'e 'ink'ez 'ilhoghun 'intl'us ts'e, 'enne cha tulalhgus k'ébihilhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","'Et 'awet Sizi 'utni, “'UBá buba whunaoodilnoh. 'Aw dahút'en-un t'ehonuszun, 'et huwa 'uhut'en.” 'Ink'ez 'et 'awet lhk'ehuyilya 'ink'ez hinaih higha 'aínli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","'Et dunene 'et nódilhya 'ink'ez honilh'en. Nyoonne bumoodihne, 'enne cha buzih nodilhya 'ink'ez highudloh whe nduhutni, “'Uyoonne, 'enne ubulhyis inle'. 'Et huwa ndun 'en Christ mbe la Yak'usda 'utahayálhti-un 'unt'oh de, dich'oh 'ududoolyih da!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Lhuganne, 'enne cha highudloh. Hizih neníndil 'ink'ez ts'ekoo too' dunink'oz-i, 'i hits'u dúhidinkai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","'Ink'ez 'uhúyulhni, “Lizwifne bulerwe inli de, nyunch'oh 'ududílyih!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Dzihtelyaz hik'une'úzguz. 'udechoo Greek bughuni k'un'a, Latin bughuni k'un'a cha, 'ink'ez Hebrew bughuni k'un'a cha whe 'et 'awet tulalhgus k'ut sulhti, hiyandus ts'e tulalhgus 'uhidunilht'o. Ndiz un'a nja dutni, ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Nyoonne nane untsi'ne, hizih tulalhgus k'ut hulhti, 'ilhoghun hich'á 'uts'un 'utni whe 'et dúyulhni, “Nyun Christ inli de, 'et nyunch'oh 'ududílyih 'ink'ez wheni cha neílhyih!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","'Et 'ilhoghun untsi'-un hukwa' yudáni' whe 'uyúlhni, “'Aw eh Yak'usda hoonts'i bé lhniljut whe eh 'udini? 'Aw t'eoonuzínzun nts'en'a la ooba nahisda, 'et whuz un'a za wheni cha neba nahisda. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","'Ink'ez wheni ts'ih'un un'a neba nahisda. Daít'en la, 'et huwa 'andit tulalhgus k'ut neba k'elha sílti. 'Et huwa neba 'uk'elha whuzdli'. 'Et hoonts'i ndun dune 'aw hoonliyaz whe ninta lhe'ít'el. 'Et hoonts'i wheni nek'un'a za ooba nahisda.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","'Et ndun dune untsi'-un 'et Sizi 'ulhni, “SMoodihti nts'e la whulerwe inli, whuz naoozinja de, snaoolnih!” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","'Et Sizi 'uyúlhni, “Ts'ih'un un'a nyudusni, nts'e la 'uk'enus hoonzoo-un, 'et soo 'andit dzin sulh 'útant'elh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Dzetniz hukw'elh'az 3:00 at'en 'et whuts'un ndi yun k'ut ndúwhulcho whe tsahólhgus inle'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sa cha 'aw lhist'en suli'. 'Ink'ez lugliz whucho dutai-i hukwa dímbal-i, 'i cha lhulcho lhk'ench'ul. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","'Ink'ez 'et Sizi tube cho 'utni, “'UBá, syughi 'i nts'o la disni.” 'Ink'ez 'et dúdija 'et 'awet 'udek'ez hanájiz. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","'Et dahooja la ndun lhuganne bumoodih whunalh'en whe Yak'usda yudilhti' whe 'utni, “Ndun 'alha soo ts'ih'un dune azi 'unt'oh.” ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","'Et 'ilhozdilne ts'iyawh 'et nehunindil huwhuntilh'elh ha, ndet la ndulcho-un dáhooja la huwhunalh'en, ts'odi k'et 'et dudzi k'ut hoohoolhchis 'ink'ez whusanáhidil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mbene la t'eininzunne, 'ink'ez mbene la ts'ekoo Galilee whuts'un hiyuwhusanándilne, 'enne cha nilhdza'yaz highu núdilhya whe ndi ndulcho dawhut'en-un honilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","'Et 'awet 'ilhoghun dune Joseph huyulhni-un, 'en cha Lizwifne ook'úne' whut'enne, 'en 'ilhoghun 'unt'oh. 'En dune unzoo 'ink'ez ts'ih'un dune unli. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nyoonne ook'úne' whut'enne, dahuja-un, 'aw ooba ts'ih'un lhe'hoot'oh. Joseph 'en Arimathea whut'en-un 'unt'oh. 'Et njan keyoh whucho Lizwifne bukeyoh, 'et 'ilhoghun 'uhoont'oh. Joseph 'en cha ndet la Yak'usda whe lerwe unli-un, 'et cha huba sulh'i. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","'Et Joseph Pilate ts'u whinya 'ink'ez Sizi oozi yuts'u yúka 'utni dutl'anáyoolhtelh ha. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","'Et 'awet oozi nanáyalhti whe ndi naih dizti'-i, layin huyulhni-i, 'i be yugha 'ozduz. 'Et tse be hahuhontsel-un, 'et whuts'o da', 'aw 'uyoonne 'et 'alhdílhtoh, 'et 'ayalhti. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","'Et 'awet 'et dzin wheni lhahúdutneh-un 'uhoont'oh. 'Et 'awet lizwifne nats'ulyis-un dzin yutilhkai. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","'Ink'ez nyoonne ts'ekoo Galilee whuts'un yuwhusanándilne, 'enne Joseph hiyuntizdil whe 'et oozi 'et 'ayulhtih whe hinilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","'Et whenáhidil. Yoo sooltsun-i, khe sooltsun-i cha ts'iyawh lhahídinla. 'Et nats'ulyis dzin, 'et Yak'usda ooghuni be buba' hóonla, 'et dzin nahilyiz. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","'Et 'awet ndi lisman 'udechoo dzin 'uhoont'oh. Bundada 'uda', nyoonne ts'ekoo 'ink'ez 'uyoonne cha bulh 'et ts'un k'uz ts'e hutizdil. Ndi yoo sooltsun-i lhahídinla-i, 'i cha hitizdla. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tse 'uda' 'udun diz'ai whe hotilh'en. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","'Et dahúnindil 'ink'ez gak Sizi oozi hooloh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","'Et ts'iyawh buba whe' hooja hooyoh 'et dáhooja whusuba 'uhoont'oh. 'Et khunsul nane dune buzih usyin. Bunaih soo ts'ih'un busaoolkalh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Ink'ez ndunne ts'ekoo tube whehunuljut whe yun nacháhunilya. 'Ink'ez ndunne dune 'uhutni, “'Et di ha yaidlanne toh khuna-un, 'en ookunáhtah? ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","'Aw njan hooloh, dunadija whe 'unt'oh! 'Awhuz Galilee 'ut'en whe, daja nohulhni-un, 'aw whunalhuzulhni? ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nja dunóhulhni, ‘Ndiz un'a nja dótanelh, yinka dune ye', 'en lubeshi 'ulh'enne tl'ahitilhtelh 'ink'ez tulalhgus k'ehúyitalhtelh ha. 'Ink'ez whulh tat dzin dunadutádalh.’” ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","'Ink'ez 'aho highuni hinalni. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Et ts'unk'uz hanáhidil, 'et ndi ts'iyawh whunizyanne 'on 'at 'ilhoghun, 'ink'ez 'onghohne cha, ts'iyanne hudáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Mbene la ubodáni'ne, 'enne Mary Magdala whut'en-un, Joanna cha, Mary James ooloo cha, 'ink'ez 'uyoonne ts'ekoo bulh 'ut'enne, 'enne 'uhuja ndunne whel'a'ne 'ubodáni'. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","'Et hoonts'i nyoonne whel'a'ne, 'ants'i 'oh ne'huduni' whula 'uhutni ubonínzun 'ink'ez 'aw buba 'alha lhe'hudusnih. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","'Et hoonts'i Peter dudillhoh 'ink'ez ts'un k'uz ts'e oolhgai. Yo le 'uja 'ink'ez tsa k'et whunilh'en. 'Et naih dizti'-i za 'et sulhchooz whe yutilh'en. 'Et duyoh ts'e whenaja. 'Et howu nuní nuzut 'ink'ez ooba hooncha dahooja whusuba 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","'Et 'awet 'et dzin za keyoh whuyaz, Emmaus ts'outni, nane dune whuz hutiz'az. Jerusalem whuts'un 7 miles at'en 'uhoont'oh. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","'Et whuz hi'us whe 'et ndóohool cho dahóot'en la 'oh howu yahulhduk. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","'Awhuz 'et howu yahulhduk dahóot'en la ne'whust'en-un, 'et Sizi bughu ninya 'ink'ez bubulh tiz'az. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Duna be hinilh'en 'et hoonts'i 'aw butl'alhúhoo'al 'et huwa 'aw t'elhihinízil. ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","'Ink'ez 'ubulhni, “'Et 'oh whuya ah'us whe, ndet whe' whudahni? Stabe huwun nohdzi unduda whe howu yalhduk?” ");
INSERT INTO crxNTpo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","'Et ndun 'ilhoghun, Cleopas huyulhni, 'en 'uyulhni, “'Aw nyun za iloh eh nts'oh te 'andit ne'whust'en-un, 'aw eh t'ewhunuzínzun. 'Aw Jerusalem whut'en-un lhinloh whe la' dini?” ");
INSERT INTO crx