﻿USE sofia;
DROP TABLE IF EXISTS sofia.crnNT_vpl;
CREATE TABLE crnNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES crnNT_vpl WRITE;
INSERT INTO crnNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ vaújsimuaꞌameꞌen aꞌɨ́jna ɨ́ Jesús, tɨ ajta iꞌi Cɨríistuꞌu ɨ́ tɨ aꞌɨ́mej jetze airáane aꞌɨ́jna ɨ́ David teecan, ajta aꞌɨ́jna ɨ́ Abraham teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Isaac. Ajta aꞌɨ́jna ɨ́ Isaac, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Jacobo. Ajta aꞌɨ́jna ɨ́ Jacobo, aꞌɨ́ɨ pu títɨꞌɨríjmuaꞌa jáꞌaraa aꞌɨ́jna ɨ́ Judá, majta seica ɨ́ mej ihuáamuaꞌameꞌen púꞌeen ɨ́ Judá. ");
INSERT INTO crnNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ajta Judá aꞌɨ́mej pu títɨꞌɨríjmuaꞌa jáꞌaraa, ɨ́ mej miyen ánteꞌaruajcaꞌa tɨjɨ́n Fares, ajta aꞌɨ́jna ɨ́ seɨ́j Zara. Ajta ɨ́ huaꞌanáànacɨꞌɨ, ayée pu ántehuaacaꞌa tɨjɨ́n Tamar. Ajta aꞌɨ́jna ɨ́ Fares, aꞌɨ́j pu típeꞌeri jáꞌaraa ɨ́ Esrom. Ajta Esrom pu rapeꞌericaꞌa ɨ́ Aram. ");
INSERT INTO crnNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Aminadab. Ajta Aminadab pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Naasón. Tɨꞌɨj jí Naasón típeꞌeri jáꞌaraa tɨ ayén ántehuaacaꞌa tɨjɨ́n Salmón. ");
INSERT INTO crnNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ajta aꞌɨ́jna ɨ́ Salmón, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Booz. Ayee pu ántehuaacaꞌa ɨ́ náànajraꞌan ɨ́ Booz tɨjɨ́n Rahab. Ajta aꞌɨ́jna ɨ́ Booz, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Obed. Ajta ayén ántehuaacaꞌa ɨ́ náànajraꞌan aꞌɨ́jna ɨ́ Obed tɨjɨ́n Rut. Ajta aꞌɨ́jna ɨ́ Obed, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Isaí. ");
INSERT INTO crnNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ David, ɨ́ tɨ ajta teꞌenteájrupi ɨ́ rey jɨmeꞌe. Aꞌɨ́jna ɨ́ David teecan, jamuan aꞌɨ́jna tɨ ajta ɨ́raꞌaraꞌan púꞌeeneꞌe aꞌɨ́jna ɨ́ Urías, aꞌɨ́ɨ mú típeꞌeri muáꞌaraa aꞌɨ́jna tɨ ayén ántehuaa jáꞌaraa tɨjɨ́n Salomón. ");
INSERT INTO crnNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Roboam. Ajta aꞌɨ́jna ɨ́ Roboam, aꞌɨ́ɨ pu péꞌericɨraꞌan púꞌeeneꞌe ɨ́ Abías. Ajta aꞌɨ́jna ɨ́ Abías, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Asa. ");
INSERT INTO crnNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa pu rapeꞌericaꞌa ɨ́ Josafat. Tɨꞌɨj jí Josafat típeꞌeri jáꞌaraa tɨ ayén ántehuaacaꞌa tɨjɨ́n Joram. Ajta aꞌɨ́jna ɨ́ Joram, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Uzías. ");
INSERT INTO crnNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ajta aꞌɨ́jna ɨ́ Uzías, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Jotam. Ajta Jotam pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Acaz. Ajta áꞌiyen aꞌɨ́jna ɨ́ Acaz típeꞌeri jáꞌaraa aꞌɨ́jna ɨ́ Ezequías. ");
INSERT INTO crnNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Manasés. Ajta Manasés pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Amón. Ajta aꞌɨ́jna ɨ́ Amón, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Josías. ");
INSERT INTO crnNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ajta aꞌɨ́jna ɨ́ Josías, aꞌɨ́mej pu títɨꞌɨríjmuaꞌa jáꞌaraa ɨ́ Jeconías, majta aꞌɨ́mej ɨ́ mej ihuáamuaꞌameꞌen púꞌeeneꞌe aꞌɨ́jna ɨ́ Jeconías. Tɨ́ꞌɨj Josías títɨꞌɨríjmuaꞌa jáꞌaraa, seica mú mú aꞌuvéꞌejuꞌun. Matɨ́ꞌɨj mi aꞌɨ́mej aꞌuvíꞌitɨ́ ɨ́ mej Israél aꞌuchéjmeꞌecaa. Aꞌuu mú jáꞌahuaꞌa huajaꞌuvíꞌitɨ seɨ́j chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Babilonia. ");
INSERT INTO crnNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Matɨ́ꞌɨj miyen huajaꞌuvíꞌitɨ, aj puꞌi Jeconías seɨ́j típeꞌeri jáꞌaraa tɨ ayén ántehuaacaꞌa tɨjɨ́n Salatiel. Ajta aꞌɨ́jna ɨ́ Salatiel, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Zorobabel. ");
INSERT INTO crnNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Abiud. Tɨ́ꞌɨjtáꞌi aꞌɨ́ɨn Abiud rapeꞌeri jáꞌaraa aꞌɨ́jna ɨ́ Eliaquim. Ajta aꞌɨ́jna ɨ́ Eliaquim, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Azor. ");
INSERT INTO crnNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajta aꞌɨ́jna ɨ́ Azor, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Sadoc. Ajta aꞌɨ́jna ɨ́ Sadoc, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Aquim. Ajta aꞌɨ́jna ɨ́ Aquim, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Eliud. ");
INSERT INTO crnNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ajta aꞌɨ́jna ɨ́ Eliud, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Eleazar. Tɨ́ꞌɨjtaꞌi aꞌɨ́jna ɨ́ Eleazar típeꞌeri jáꞌaraa aꞌɨ́jna ɨ́ Matán. Ajta, aꞌɨ́jna ɨ́ Matán, aꞌɨ́ɨ pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ Jacobo. ");
INSERT INTO crnNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobo pu rapeꞌericaꞌa aꞌɨ́jna ɨ́ José, aꞌɨ́jna tɨ María téviꞌitɨneꞌe. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ náànajraꞌan púꞌeeneꞌe aꞌɨ́jna ɨ́ Jesús, ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Cɨríistuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aꞌɨ́j mú jɨ́n miyen aráꞌasecaꞌa aꞌachú cumu tamuáamuataꞌa japuan muáacua ɨ́ mej jetzen airáane aꞌɨ́jna ɨ́ Abraham teecan. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tuꞌuvéꞌeteajtɨ aꞌɨ́jna ɨ́ David. Majta miyen cheꞌatá menaꞌa aráꞌaxcaa aꞌɨ́ɨme ɨ́ mej huáꞌa jetze airáane aꞌɨ́jna ɨ́ David teecan. Aꞌɨ́mej mú aꞌuvíꞌitɨ́ aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecantacaꞌa aꞌujna jáꞌahuaꞌa Babilonia. Ayee mú cheꞌatá menaꞌa aráꞌaxcaa tamuáamuataꞌa japuan muáacua tɨ́ꞌɨj huanúꞌihuacaꞌa aꞌɨ́jna ɨ́ Cɨríistuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ayee pu éeniꞌicɨꞌe huanúꞌihuacaꞌa aꞌɨ́jna ɨ́ Jesús tɨ ajta iꞌi Cɨríistuꞌu. Aꞌɨ́ɨ pu náànajraꞌan, aꞌɨ́jna ɨ́ María, puꞌuri huataúraꞌacaa ɨ́ runiuuca jɨmeꞌe tɨ ij huatévicheꞌen aꞌɨ́jna jamuan ɨ́ José. Matɨ́ꞌɨj caí xɨ naímiꞌi huatéꞌecaꞌa, aj pu i aꞌutaseíjre ɨ́ paꞌarɨꞌɨ jucáaraꞌan jetze. Aꞌɨ́ɨ pu ayén ráaruu jɨ́meꞌen ɨ́ muárɨꞌeriꞌireꞌaraꞌan aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ajta nuꞌu aꞌɨ́ɨn tɨ ratéviꞌitɨ́néꞌe aꞌame, aꞌɨ́jna ɨ́ José, rɨ́ꞌɨ pu tíꞌitevistacaꞌa. Capu raxɨ́ꞌeveꞌecaꞌa tɨ ayén puaíjtzi raatáꞌan mé jéjreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte. Mɨ́ ajta, aꞌɨ́ɨ pu ayén raxɨ́ꞌeveꞌecaꞌa tɨ mé rúurɨeni avíitzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tɨ́ꞌɨj raaxɨ́ꞌepɨꞌɨntare tɨ ayén huárɨni, aj puꞌi seɨ́j tevi huataseíjre ɨ́ jemin ɨ́ cutzí tzajtaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen seɨ́j tɨ tíꞌivaɨreꞌe ɨ́ ta japua. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―José, múꞌee pej iꞌi huáacɨxaꞌaraꞌan ɨ́ David teecan, capej rátziɨɨneꞌe pej ráꞌanviꞌitɨn aꞌu pe éꞌeche aꞌiné ɨ́ tɨ aꞌutaseíjre ɨ́ jucáaraꞌan jetze, aꞌɨ́j pu jɨ́meꞌen huanéj ɨ́ muárɨꞌeriꞌireꞌaraꞌan ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aꞌɨ́ɨ pu teáatacan tiyaúj aꞌame. Ayee xu nuꞌu raatámuaꞌati tɨjɨ́n JESUS, aꞌiné aꞌii pu aꞌɨ́ɨn puꞌéeneꞌe aꞌame ɨ́ tɨ huáꞌa japua niuuni ɨ́ ruteɨ́testemuaꞌa ɨ́ mej meri auteájturaa ɨ́ Dios jemi. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ayee tiujuꞌurɨ́j tɨ ij ayén teꞌaraúrasten aꞌij tɨ ajmíꞌi tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ tíꞌixaxaꞌataꞌa ɨ́ tavástaraꞌa jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ayen tɨjɨ́n: Paꞌarɨꞌɨ pu nuꞌu huataseíjreꞌesin ɨ́ jucaatzeꞌen aꞌɨ́jna jetze ɨ́ ꞌɨ́itaꞌa tɨ caí xɨ jaꞌatɨ́ ratéviꞌitɨn. Tiyaúj pu nuꞌu aꞌame teáatacan. Aj mú mi miyen raatámuaꞌatzi tɨjɨ́n Emanuel. Aꞌíjna niuucarijraꞌa tɨjɨ́n Emanuel, ayée pu huataújmuaꞌa tɨjɨ́n: Dios pu ta jamuan yé huaca. ");
INSERT INTO crnNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tɨ́ꞌɨj huájɨ aꞌɨ́jna ɨ́ José, aj pu i ayén huarɨ́j aꞌij tɨ tiraatáꞌixaa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ta japua tíꞌivaɨreꞌe. Tɨꞌɨj jí yaꞌuvíꞌitɨ ɨ́ ruche. ");
INSERT INTO crnNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mɨ́ ajta, capu jamuan huáhuii ajta caí huanúꞌihuacaꞌa aꞌɨ́jna ɨ́ paꞌarɨꞌɨ tɨ teáataꞌa. Matɨ́ꞌɨj mi miyen raatamuáꞌa tɨjɨ́n JESUS. ");
INSERT INTO crnNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Aꞌuu pu jaꞌunúꞌihuacaꞌa aꞌɨ́jna ɨ́ Jesús, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Belén. Aꞌuu pu ajtémeꞌecan aꞌɨ́jna ɨ́ chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Judea. Aꞌájna aꞌu tɨ aꞌɨ́ɨn jaꞌunúꞌihuacaꞌa ɨ́ Jesús, aꞌɨ́ɨ pu tiꞌitéveecaꞌa ɨ́ rey jɨmeꞌe aꞌɨ́jna ɨ́ Heródes. Matɨ́ꞌɨj mi seica Jerusalén eꞌiréꞌene ɨ́ mej jeíhua támuaꞌarejcaꞌa. U jetze pújmeꞌen mú eꞌeráacɨ aꞌutɨ́ ꞌeíjninei ɨ́ xɨcaj. ");
INSERT INTO crnNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi ɨ́ Heródes miyen tɨjɨ́n: ―¿Aꞌuné aꞌij ꞌeen aꞌɨ́jna ɨ́ huáꞌa rey ɨ́ mej Israél jetze ajtémeꞌecan, aꞌɨ́jna tɨ auchén huanúꞌihuacaꞌa? Aꞌájna jáꞌahuaꞌa aꞌutɨ́ ꞌeíjninei ɨ́ xɨcaj, aꞌujna aꞌu tej éꞌeche, xuꞌuraꞌave tu huaseíj tɨ aꞌutátzaareajraa aꞌɨ́jna jɨmeꞌe tɨ huanúꞌihuacaꞌa. Aꞌɨ́j tu jɨ́n teꞌuun mú aꞌuvéꞌejuꞌun tej ti rɨ́ꞌɨ tíraatéanajche. ");
INSERT INTO crnNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tɨ́ꞌɨj ráamuaꞌareeriꞌi aꞌɨ́jna ɨ́ rey, aꞌɨ́jna ɨ́ Heródes, jéꞌecan pu tiꞌijmuaꞌastɨ́ jáꞌaraa aꞌɨ́jna jɨmeꞌe. Majta, ɨ́ teɨte ɨ́ mej Jerusalén aꞌuchéjmeꞌecaa, naímiꞌi mú tíꞌitziɨɨneꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tɨꞌɨj jí Heródes huaꞌutajé naíjmiꞌica ɨ́ mej tihuáꞌaijteꞌe aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe huaꞌatéyujtaꞌa, majta ɨ́ mej tihuáꞌamuaꞌatehuaꞌa ɨ́ teɨte aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné nuꞌu áꞌanuꞌihuan aꞌɨ́jna ɨ́ Cɨríistuꞌu? ");
INSERT INTO crnNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: ―Aꞌujna Belén, ɨ́ chajtaꞌa tɨ aꞌuun ajtémeꞌecan aꞌujna jáꞌahuaꞌa u Judea, aꞌiné ayée pu ajmíꞌi raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ayen tɨjɨ́n: Múꞌeen mɨ sej Belén aꞌuchéjme, aꞌujna chuéjraꞌa japua tɨ aꞌuun auucáꞌa u Judá, íjii, múꞌeen xu xaa seꞌɨ́ɨn púꞌeen ɨ́ sej jaítzeꞌe cɨ́lieen jɨ́n tíꞌaijta. Mɨ́ ajta, méjcaꞌi huáyee, seɨ́j pu aꞌamua jetze nuꞌihuan tɨ veꞌecán jɨ́n tiuꞌutaꞌaíjta. Aꞌɨ́ɨ pu antiújmuaꞌaréere aꞌame huáꞌa jɨmeꞌe ɨ́ neteɨ́testemuaꞌa, aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Aj pu i Heródes huajaꞌutajé avíitzi jɨmeꞌe aꞌɨ́mej ɨ́ mej jeíhua támuaꞌarejcaꞌa. Tɨꞌɨj jí ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌachúni ari áꞌatee tɨ huajaꞌutaseíjra aꞌɨ́jna ɨ́ xuꞌuraꞌave? ");
INSERT INTO crnNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ajta áꞌiyen huaꞌutaꞌaíj mej áꞌucɨɨne aꞌujna u Belén. Ayen tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu, setáꞌaj yáꞌuhuauni temuaꞌa naa seꞌɨ́jna ɨ́ paꞌarɨꞌɨ. Setɨ́ꞌɨj raateún, aj xu si mú aꞌuvéꞌejuꞌun setáꞌaj naatáꞌixaateꞌen, neatáꞌaj neajta inee áꞌumeꞌen, neatáꞌaj rɨ́ꞌɨ tiraateájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Matɨ́ꞌɨj ráanamuajriꞌi meꞌɨ́jna ɨ́ rey, aj mú mi aꞌucɨ́j. Ajta aꞌɨ́ɨn xuꞌuraꞌave tɨ aꞌutaseíjre aꞌɨ́mej jemi aꞌujna seɨ́j chuéjraꞌa japua aꞌu tɨ ꞌeíjninei ɨ́ xɨca, aꞌɨ́ɨ pu amuacaí huaméꞌecaa. Tɨꞌɨj jí án aꞌujcháxɨ ɨ́ chiꞌij japua aꞌu tɨ aꞌij éꞌeneꞌe aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jéꞌecan mú huataújtemuaꞌave matɨ́ꞌɨj raaseíj meꞌɨ́jna ɨ́ xuꞌuraꞌave. ");
INSERT INTO crnNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Muaꞌantenéesimeꞌecaa mú u chiꞌita, matɨ́ꞌɨj mi raaseíj ɨ́ paꞌarɨꞌɨ jamuan ɨ́ náànajraꞌan. Aj mú mi títunutaxɨ. Temuaꞌa mú naa rɨ́ꞌɨ tiraatáꞌa. Matɨ́ꞌɨj mi teꞌentícuunaxɨ tiuꞌujcáaja, aꞌɨ́ɨ mú raatapuaíjve tiꞌitɨ́j oro, majta tiꞌitɨ́j cɨ́tziveꞌeri, majta tiꞌitɨ́j cuaaneꞌe tɨ ayén ántehuaa tɨjɨ́n mirra. ");
INSERT INTO crnNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Majta áꞌiyen tiúꞌumaaracaꞌa tɨ nuꞌu Dios huaꞌutáꞌijmɨijriꞌi mej nuꞌu caí huaréꞌecɨɨne aꞌɨ́jna jemi ɨ́ Heródes. Aꞌɨ́j mú jɨ́n seɨ́j jetze aꞌucɨ́ ɨ́ juye mej mi aꞌuréꞌenen meꞌújna chuéjraꞌa japua aꞌu mej éꞌechejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Matɨ́ꞌɨj aꞌucɨ́j aꞌɨ́ɨme ɨ́ mej jeíhua támuaꞌarejcaꞌa, jaꞌatɨ́ pu huataseíjre aꞌɨ́jna jemi ɨ́ José tɨ́ꞌɨj tíꞌimaaracaꞌa. Aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌii pu aꞌɨ́ɨn púꞌeeneꞌe seɨ́j tɨ tíꞌivaɨreꞌe u ta japua. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Ájchesi. Patáꞌaj ráꞌanviꞌitɨn peꞌɨ́jna ɨ́ paꞌarɨꞌɨ, pajta ɨ́ náànajraꞌan. Áꞌuraꞌa patáꞌaj raatéꞌavaa mɨ paꞌarɨꞌɨ, pajta ɨ́ náànajraꞌan. Huáꞌanviꞌitɨchi aꞌujna Egipto. Setáꞌaj seꞌuun aꞌutéꞌen ajta nenaꞌa caí neajtahuaꞌa amuaatáꞌixaateꞌen jaꞌanáj tɨ huatárɨꞌɨristari sej yé uvéꞌenen seyajna. Ayee xu huárɨni aꞌiné aꞌɨ́jna ɨ́ Heródes, aꞌɨ́ɨ pu rahuauni ɨ́ paꞌarɨꞌɨ tɨ i raajéꞌica. ―Ayee pu tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tɨꞌɨj jí ájchee ɨ́ José. Yaꞌuvíꞌitɨ aꞌɨ́jna ɨ́ paꞌarɨꞌɨ, ajta náànajraꞌan. Ajta aꞌɨ́ɨn huáꞌa jamuan pu áꞌuraa aꞌájna tɨ́caꞌari tzajtaꞌa. Aꞌuu mú aꞌaráꞌa aꞌujna Egipto. ");
INSERT INTO crnNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Aꞌuu mú éꞌetee ajta caí huamɨ́ꞌɨ aꞌɨ́jna ɨ́ Heródes. Ayee pu aꞌɨ́jna jɨ́n huarɨ́j tɨ́ꞌij araúrasten ɨ́ niuucari tɨ jɨ́meꞌen ayén ajmíꞌi tiuꞌutaxájtacaꞌa seɨ́j tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan tɨjɨ́n: “U nu yaꞌutajé ɨ́ niyauj aꞌujna Egipto.” ");
INSERT INTO crnNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Tɨ́ꞌɨj Heródes ráamuaꞌareeriꞌi mej raatémuaꞌitɨ aꞌɨ́ɨme ɨ́ mej jeíhua támuaꞌarejcaꞌa, jéꞌecan pu huataniúꞌucacaꞌa. Tɨ́ꞌɨj jí raꞌutámuaꞌareeriꞌi aꞌij mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme, aj pu i Heródes tiuꞌutaꞌaíjtacaꞌa mej nuꞌu huáꞌucuiꞌini naíjmiꞌica ɨ́ tɨꞌɨríi mej teteca ɨ́ mej miyen raachaꞌɨ́jmee huaꞌapua nineꞌiraꞌa múucɨ pújmeꞌen. Naíjmiꞌica mú huajáꞌucuii aꞌúu mej Belén éꞌechejcaꞌa, majta ɨ́ seica ɨ́ mej aꞌɨmuá antachéejmeꞌecaa. ");
INSERT INTO crnNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ayee pu teꞌaraúraste aꞌɨ́jna ɨ́ niuucarijraꞌa tɨ jɨ́meꞌen ayén ajmíꞌi raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayee pu ántehuaacaꞌa tɨjɨ́n Jeremías. ");
INSERT INTO crnNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ayen tɨjɨ́n: Ayee pu tiúꞌunamuajriꞌi aꞌujna jáꞌahuaꞌa u Ramá, mej ruyeinecaꞌa, majta jeíhua ruxɨeemɨjteꞌecaꞌa. Aꞌɨ́jna ɨ́ Raquel, aꞌɨ́ɨ pu seɨ́j aꞌɨ́ɨn púꞌeen ɨ́ mej ruyeinecaꞌa. Ruyaujmuaꞌa pu jɨ́meꞌen ruyeinecaꞌa. Capu raxɨ́ꞌeveꞌecaꞌa mej rɨ́ꞌɨ tiraatéjeeve aꞌɨ́jna jɨmeꞌe ɨ́ mej caí chéꞌe mé jéꞌe jáꞌahuaꞌa ɨ́ yaújmuaꞌameꞌen. Ayee puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aru tɨ́ꞌɨj ari huamɨ́ꞌɨ aꞌɨ́jna ɨ́ Heródes, seɨ́j pu ajta huataseíjre aꞌɨ́jna jemi ɨ́ José tɨ́ꞌɨj tíꞌimaaracaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen seɨ́j tɨ tíꞌivaɨreꞌe ta japua ɨ́ tavástaraꞌa jemi. Ayee pu aꞌɨ́ɨn tiraatáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ájchesi. Ánviꞌitɨchi hui aꞌɨ́jna ɨ́ paꞌarɨꞌɨ, pajta ɨ́ náànajraꞌan. Setáꞌaj jáꞌucɨɨne seꞌújna chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Israél. Puꞌuri huamɨ́ꞌɨ ɨ́ tɨ rajéꞌicatamɨꞌɨcaꞌa aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. ―Ayee pu tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tɨꞌɨj jí ájchee aꞌɨ́jna ɨ́ José. Aj puꞌi yaꞌuvíꞌitɨ aꞌɨ́jna ɨ́ paꞌarɨꞌɨ, ajta náànajraꞌan. Aꞌuu mú aꞌaráꞌa meꞌújna Israél. ");
INSERT INTO crnNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mɨ́ ajta aꞌɨ́ɨn José, ayée pu ráamuaꞌareeriꞌi tɨ nuꞌu aꞌɨ́ɨn Arquelao tíꞌaijtacaꞌa ruyáꞌupuacɨꞌɨ jetze meꞌecan, aꞌɨ́jna ɨ́ Heródes teecan. Ajta pu Dios raatáꞌixaa tɨ́ꞌɨj tíꞌimaaracaꞌa. Aꞌɨ́j pu jɨ́n tíꞌitziɨɨneꞌecaꞌa tɨ aꞌuun eꞌaráꞌasti, aꞌujna Judea. Tɨꞌɨj jí aꞌuun aꞌaráꞌa tɨ jetzen ajtémeꞌecan aꞌujna Galileeye. ");
INSERT INTO crnNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tɨ́ꞌɨj aꞌuun aꞌaráꞌa, aꞌúu pu eꞌehuaújchejte, chajtaꞌa jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Nazarét. Aꞌuu pu huayeíjxɨ. Ayee pu tiujuꞌurɨ́j tɨ ij ayén araúrasten aꞌij mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej mejmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Miyen tɨjɨ́n: “Ayee mú raatámuaꞌatzi tɨjɨ́n Nazarét tɨ éꞌemeꞌecan.” ");
INSERT INTO crnNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Aꞌájnáꞌɨmua aj pu aꞌutaseíjre aꞌu tɨ caí éꞌe tiꞌitɨ́j aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuacareꞌe. Aꞌuu pu tihuáꞌaꞌixaateꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj seɨcɨé tiúꞌumuaꞌati ɨ́ ru tzajtaꞌa aꞌiné puꞌuri hui tɨ́n aꞌájna tejaꞌuréꞌenejsin tɨ Dios íiyen tiuꞌutaꞌaíjta nainjapua ɨ́ chaanaca. ");
INSERT INTO crnNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aꞌɨ́jna ɨ́ Juan, aꞌii pu aꞌɨ́ɨn púꞌeeneꞌe tɨ jɨ́meꞌen raataxájtacaꞌa ajmíꞌi aꞌɨ́jna ɨ́ jaꞌatɨ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayee pu ántehuaacaꞌa tɨjɨ́n Isaías. Ayen tɨjɨ́n: Jaꞌatɨ́ pu u eꞌejíihuá aꞌame aꞌujna jáꞌahuaꞌa aꞌu tɨ caí éꞌe tiꞌitɨ́j. Yee pu tiꞌixa tɨjɨ́n: “Naa xu rɨ́ꞌɨ huaujjéjcuareꞌen, mɨ ru tzajtaꞌa, múꞌeen, aꞌiné tavástaraꞌa pu yé uvéꞌenejsin. Caxu aꞌij yáꞌunamuajra.” ");
INSERT INTO crnNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ajta aꞌɨ́jna ɨ́ Juan, ayée pu éeneꞌe tiꞌitéchejcaꞌa cɨ́ɨxuri tɨ itzíjhua, cameeyuꞌu juꞌuxaꞌa jɨmeꞌe. Ajta típuaasicaꞌa, navij tu rumuaꞌatɨ́. Ajta nuꞌu huátunaꞌise cuaꞌacareꞌe, ajta searate, ꞌɨtzitá mej xuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Majta meꞌɨ́n ɨ́ mej aꞌɨmuá aꞌuchéjmeꞌecaa, naíjmiꞌi mú eꞌiréꞌenineicaꞌa aꞌu tɨ aꞌutéveecaꞌa ɨ́ Juan. Aꞌuu mú eꞌerácɨꞌɨcaꞌa tɨ́j naꞌa aꞌu tɨ huatacáꞌa aꞌujna chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Judea, majta seica ɨ́ mej meꞌuun éꞌeche aꞌujna chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jerusalén, majta ɨ́ seica ɨ́ mej meꞌuun éꞌemeꞌecan aꞌu tɨ aꞌatamɨ́ꞌɨye ɨ́ játeꞌana tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jordán. Aꞌuu mú aꞌuréꞌenineicaꞌa mej mi ráanamua. ");
INSERT INTO crnNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jɨ́meꞌen muꞌu tiuꞌutétzaahuate ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi, aj puꞌi Juan huáꞌamuaɨꞌɨhuacaꞌa ɨ́ játeꞌanaraꞌan jetze ɨ́ Jordán. ");
INSERT INTO crnNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mɨ́ ajta ɨ́ Juan, tɨ́ꞌɨj aꞌɨ́mej huaseíj ɨ́ mej miyen ánteꞌarua tɨjɨ́n fariseos, majta ɨ́ mej miyen ánteꞌarua tɨjɨ́n saduceos, tɨ́ꞌɨj aꞌɨ́ɨn huaꞌuseíj ɨ́ mej jeíhua eꞌevéꞌejuꞌucaꞌa mej mi huaújmuaɨꞌɨhua, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen mɨ sej tíꞌihuaꞌitaca, ¿ni tzaa seri tíꞌiteseꞌe tɨ caí Dios puaíjtzi amuaatáꞌan? ¿Aꞌataani amuaatáꞌixaa sej si siyen rɨcɨ? ");
INSERT INTO crnNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rɨ́ꞌɨ xuꞌu seꞌíjna jɨmeꞌe mej mi ráamuaꞌaree ɨ́ teɨte sej seri tzáahuatiꞌiraꞌa jɨ́n tíꞌimuaꞌatze. ");
INSERT INTO crnNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Caxu siyen tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa yee: “Ayej tiꞌayajna tɨ naa titaatévaɨreꞌen aꞌiné teen tu iꞌi huáacɨxaꞌastemuaꞌameꞌen aꞌɨ́jna ɨ́ Abraham teecan.” Ayee nu tejáꞌamuaꞌixaateꞌe. Ayej tiꞌayajna tɨ Dios raayɨ́ꞌɨtɨ tɨ rɨ́ꞌɨ raaráꞌatza ɨ́ tete matɨ́j ɨ́ huáacɨxaꞌastemuaꞌameꞌen aꞌɨ́jna ɨ́ Abraham teecan. Capu tiꞌitɨ́j aꞌij tejámuaatévaɨreꞌesin sej siyen tíꞌimuaꞌajca rujɨ́ɨmuaꞌa sino sej siyen huanén tɨ́j Abraham teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Puꞌuri tejaꞌuréꞌenejsin vejliꞌi aꞌájna xɨcájraꞌa jetze jaꞌanáj tɨ puaꞌa amuaꞌajteáꞌaxɨꞌɨsin ɨ́ Dios caꞌanín jɨmeꞌe. Ayee pu áꞌamuaruuren cumu tɨ́j jaꞌatɨ́ cɨyej téꞌijveichixɨꞌɨn tepuaij jɨmeꞌe. Nain ɨ́ cɨyej tɨ caí tíꞌitaaca, aꞌɨ́ɨ pu téꞌijveichixɨꞌɨsin. Tɨꞌɨj jí raꞌanteátaira. Ayee pu cheꞌatá naꞌa tejamuaꞌajteáꞌaxɨꞌɨsin múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aru inee, nee nu amuáamuaɨꞌɨhuacaꞌa jaj jɨmeꞌe mej mi ráamuaꞌaree ɨ́ teɨte sej seri seɨcɨé tiuꞌumuáꞌaj ɨ́ ru tzajtaꞌa. Mɨ́ ajta, aꞌɨ́ɨn tɨ hui nehuáritaꞌa yé eꞌevéꞌeme, aꞌɨ́ɨ pu jaítzeꞌe raayɨ́ꞌɨtɨ necaí inee. Aꞌiné nee nu cɨ́lieeneꞌen jɨ́n tiꞌitéjvee ɨ́ jemin, capu ayén tínaavíjteꞌe ineetzi nej rajtaɨ́ꞌɨpɨꞌɨn ɨ́ caꞌacairaꞌan. Mɨ́ ajtáꞌi aꞌɨ́ɨn, seɨ́j pu huataꞌíti tɨ huateáturan múꞌejmi jemi. Ajta aꞌɨ́ɨn ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu utéꞌaꞌasin mɨ aꞌamua tzajtaꞌa. Ajta aꞌɨ́jna tɨ hui nehuáritaꞌa yé eꞌevéꞌeme, aꞌɨ́ɨ pu rɨ́ꞌɨ áꞌamuaruuren. ");
INSERT INTO crnNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ayee pu téꞌeme. Xɨee tɨ jaꞌatɨ́ ari ruꞌiteꞌɨ́ ɨ́ tɨ jɨ́n raꞌanácaꞌatzi ɨ́ triigu. Aꞌɨ́ɨ pu ruꞌirátuꞌisin ɨ́ xaɨɨri puaꞌacɨé. Ajta aꞌɨ́jna ɨ́ imueꞌeri, rájseɨreꞌesin u chiꞌita. Ajta ɨ́ xaɨɨri, taij jetze pu án yáꞌurɨeexɨjsin ɨ́ tɨ caí jaꞌanáj áꞌamɨꞌɨni. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aj pu i Jesús huataseíjre. Aꞌuu pu aꞌarájraa aꞌujna chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Galileeye tɨ́ꞌij Juan ráamuaɨꞌɨhua játeꞌana jetze tɨ ayén ántehuaa tɨjɨ́n Jordán. ");
INSERT INTO crnNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ajta aꞌɨ́jna ɨ́ Juan, ayée pu tíꞌimuaꞌajca tɨ raatáꞌijmɨi. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―¿Ni múꞌee piyen yé véꞌeme inee jemi? Jaítzeꞌe pu raavíjteꞌe pej piyen náamuaɨꞌɨhua ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mɨ́ ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiraataꞌixaa tɨjɨ́n: ―Chéꞌe ayén ꞌeeneꞌen. Ayee pu hui tiraavíjteꞌe tej tiyen huárɨni tej raꞌaráꞌastijreꞌen teꞌɨ́jna jɨmeꞌe aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Aj pu i Juan ráamuaɨꞌɨhuacaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tɨ́ꞌɨj ráamuaɨꞌɨhuacaꞌa, aj puꞌi Jesús aꞌitáraa á jaataꞌa. Jɨ́meꞌen puꞌu aꞌitáraa, tɨ́ꞌɨj jí antácuunarecaꞌa ɨ́ ta japua tɨ aꞌutéjmuaa. Tɨꞌɨj jí iiraaseíj tɨ aꞌicaméꞌecaa aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. Ayee pu seijreꞌecaꞌa tɨ́j cucuiꞌi. Tɨꞌɨj jí japuan aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ajta áꞌiyen niuucari huánamuajriꞌi tɨ júteꞌe uj eꞌicánamuajreꞌe. Ayen tɨjɨ́n: ―Niyauj pej pɨ́rɨcɨ ɨ́ nej muáꞌixeꞌeveꞌe. Jéꞌecan pej hui naa rɨ́ꞌɨ naatáꞌa i ne tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tɨꞌɨj jí aꞌɨ́ɨn ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu yaꞌuvíꞌitɨ aꞌɨ́jna ɨ́ Jesús ɨ́ jɨrí jetze tɨ́ꞌij aꞌɨ́ɨn tiyaaruꞌu tiuꞌutéseꞌen tɨ raamuáꞌitɨn aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ajta aꞌɨ́ɨn Jesús, aꞌúu pu éꞌetee aꞌachú cumu huaꞌapuate xɨcaj tɨ caí tíꞌicuaꞌa. Aj pu i huataꞌíꞌicuatacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ajta áꞌiyen aꞌɨ́ɨn tiyaaruꞌu eꞌiréꞌene aꞌɨ́jna ɨ́ Jesús jemi tɨ ij raamuáꞌitɨn. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa hui yaujraꞌan pej púꞌeen ɨ́ Dios. Patáꞌaj raataꞌaíjteꞌen amɨ́jna mɨ tetej tɨ́ꞌij pan huateújtaahua. ");
INSERT INTO crnNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ajta Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Capu aꞌɨ́ɨ naꞌa ruxeꞌeveꞌe ɨ́ pan tɨ jɨ́n teꞌutáviicuaꞌi ɨ́ tevi, sino ajta pu aꞌɨ́ɨn ruxeꞌeveꞌe nain ɨ́ niuucari tɨ éꞌemeꞌecan ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Tɨꞌɨj jí aꞌɨ́ɨn tiyaaruꞌu ajtahuaꞌa yaꞌuvíꞌitɨ aꞌɨ́jna ɨ́ Jesús aꞌánna Jerusalén. Teyuu pu japuan raꞌantítuaa aꞌu tɨ eꞌevéꞌepaꞌatzaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ajta ayén tiraatáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa hui yaujraꞌan pej púꞌeen ɨ́ Dios, ancájvetzi, aꞌiné ayée pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: Dios pu huajaꞌutaꞌíti ɨ́ mej títetateí ɨ́ jemin mej mi muáachaꞌɨn. Majta múꞌeetzi memuáꞌatɨni rumuájcaꞌa jɨmeꞌe. Aꞌɨ́ɨme mú á muaatéchajtza tɨ́ꞌij caí tiꞌitɨ́j aꞌij muaruure. ");
INSERT INTO crnNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús pu ayén tiraatáꞌixaa tɨjɨ́n: ―Mɨ́ ajta, ayée pu cheꞌatá naꞌa ayén téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: “Capej piyen tiráꞌaxɨeehuariꞌira tiꞌitɨ́j jɨmeꞌe tɨ Dios ayén tiꞌitɨ́j jɨ́n huárɨni.” ");
INSERT INTO crnNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ajta aꞌɨ́ɨn ɨ́ tiyaaruꞌu, ajtahuaꞌa pu yaꞌuvíꞌitɨ jáꞌahuaꞌa yee jɨrí jetze tɨ ájtee. Aj pu i raataseíjra nainjapua, tɨ́j naꞌa seɨ́j chuéjraꞌa japua aꞌu mej aꞌuchéjme ɨ́ teɨte. Raataseíjra aꞌachú tɨ veꞌetɨ́ aꞌuun huatacáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Nain nu muatapuaíjveꞌesin neꞌíjna tɨ puaꞌa piyen huárɨni pej títunuta, pej pi naateánajche. ");
INSERT INTO crnNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Aricu, múꞌee pej iꞌi tiyaaruꞌu, aꞌiné ayée pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: “Setáꞌaj raateánajche seꞌɨ́jna ɨ́ tavástaraꞌa ɨ́ aꞌamua Dios. Aꞌɨ́j xuꞌu huatévaɨreꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aj pu i áꞌuraa aꞌɨ́jna ɨ́ tiyaaruꞌu. Capu chéꞌe aꞌij ráaruu. Matɨ́ꞌɨj mi huataseíjre ɨ́ mej títetateí ɨ́ ta japua mej mi raatévaɨreꞌen meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tɨ́ꞌɨj Jesús ráamuaꞌareeriꞌi tɨ aiteánamiꞌihuacaꞌa aꞌɨ́jna ɨ́ Juan, aj puꞌi áꞌuraa aꞌujna chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Galilea. ");
INSERT INTO crnNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Aꞌuu pu eꞌerájraa aꞌujna Nazarét. Tɨꞌɨj jí aꞌuun aꞌucáane aꞌujna Capernaúm, chajtaꞌa tɨ aꞌutacáꞌa aꞌujna tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ aꞌutacáꞌa aꞌájna vejliꞌi seɨ́j chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Zabulón, ajtahuaꞌa seɨ́j chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Neftalí. ");
INSERT INTO crnNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ayee pu tiujuꞌurɨ́j tɨ ij ayén araúrasten aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan aꞌɨ́jna ɨ́ Isaías. ");
INSERT INTO crnNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ayen tɨjɨ́n: Ayee pu téꞌeme aꞌujna chuéjraꞌa japua aꞌu mej éꞌeche ɨ́ teɨte ɨ́ mej caí Israél jetze ajtémeꞌecan, aꞌujna tɨ huatacáꞌa u Zabulón, ajta ɨ́ seɨ́j chuéjraꞌa japua u Neftalí, ajta seɨ́j ɨ́ juye tɨ aꞌuun eꞌetéeneana aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ veꞌée, ajta utavén pújmeꞌen ɨ́ Jordán, ajta u Galileeye aꞌu mej aꞌuchéjme ɨ́ mej caí Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Aꞌɨ́ɨme ɨ́ teɨte, aꞌiné capu huáꞌa jemi raateájtuaa ɨ́ mej seijreꞌecaꞌa ɨ́ tɨ́caꞌari tzajtaꞌa, aꞌɨ́ɨ mú raaseíj tɨ u ajtátzacaꞌa, temuaꞌa naa, majta aꞌɨ́ɨme ɨ́ mej aꞌuchéjmeꞌecaa aꞌu mej yéꞌejpuaíjtzicaꞌa, ayée mú ꞌeeneꞌe, xɨee mej cuj mɨ́ꞌɨchicaꞌa, aꞌiné ayée pu huaꞌéꞌeneꞌe, xɨee tɨ huatɨ́caꞌa. Aj puꞌi huáꞌa jetze huatátzareajraa. Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tɨꞌɨj jí aꞌɨ́ɨn Jesús aꞌutéjche tɨ tihuáꞌamuaꞌaten. Ayee pu tihuáꞌatixáateꞌajraa tɨjɨ́n: ―Setáꞌaj seɨcɨé tiúꞌumuaꞌati ɨ́ ru tzajtaꞌa aꞌiné puꞌuri tɨ́n tejaꞌuréꞌenejsin tɨ tiuꞌutaꞌaíjta ɨ́ Dios íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ajta ɨ́ Jesús, áa pu ꞌejtémeꞌecaꞌa aꞌájna vejliꞌi tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Galilea. Tɨ́ꞌɨj i aꞌɨ́mej huaseíj ɨ́ mej huaꞌapua ɨ́ mej ruꞌihuaamuaꞌa púꞌeen. Aꞌɨ́ɨme mú aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Simón, ajta juutzeájraꞌan aꞌɨ́jna ɨ́ Andrés. Ajta aꞌɨ́jna ɨ́ Simón, ayée mú majta ratamuáꞌamua tɨjɨ́n Pedro. Aꞌɨ́ɨ mú xɨéjmuaꞌari jɨ́n huaꞌité viviꞌiracaꞌa. Ayee muꞌu tíꞌijrɨꞌɨrejcaꞌa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Mú seꞌutáuruyiꞌi neetzi jemi. Nee nu tejáꞌamuamuaꞌaten sej si caí chéꞌe siyen huaꞌité tíꞌiviiviꞌiraꞌan sino teɨte xuꞌu si tíseɨreꞌesin ineetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jɨ́meꞌen puꞌu ayén tihuaꞌutáꞌixaa, aj mú mi raatapuáꞌajtacaꞌa. Matɨ́ꞌɨj mi atejaꞌupí ɨ́ xɨéjmuaꞌari, Matɨ́ꞌɨj mi aꞌucɨ́ jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tɨ́ꞌɨj ijtáꞌi áꞌayee aꞌuréꞌene. Ajtahuaꞌa pu huaꞌapuaca huaseíj ɨ́ mej ruꞌihuaamuaꞌa púꞌeen. Seɨ́j pu ayén ántehuaa tɨjɨ́n Jacobo. Ajta ɨ́ juutzeájraꞌan, ayée pu ántehuaa tɨjɨ́n Juan. Aꞌɨ́ɨ pu huáꞌapeꞌeri ɨ́ Zebedeo. Aꞌuu mú aꞌaráteꞌecaꞌa ɨ́ canuuhuaꞌa jetze. Huáꞌa jamuan pu arácatii ɨ́ huaꞌatáàta. Xɨéjmuaꞌari mú rɨ́ꞌɨ tíꞌiruurejcaꞌa tɨ tíꞌisiujtzaꞌani. Tɨ́ꞌɨj i Jesús huaꞌutajé mej mi jamuan áꞌujujhuaꞌaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aj mú mi raatapuáꞌajtacaꞌa. Matɨ́ꞌɨj mi aitacɨ́j ɨ́ canuuhuaꞌa jetze. A mú yaúurɨe ɨ́ rutáàta. Matɨ́ꞌɨj mi aꞌucɨ́j jamuan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tɨ́ꞌɨj aꞌɨ́ɨn ɨ́ Jesús aꞌutéjche tɨ áꞌucheꞌecaneꞌen nainjapua tɨ́j naꞌa aꞌúu tɨ huatacáꞌa u Galileeye, aꞌɨ́ɨ pu tihuáꞌamuaꞌatehuaꞌa ɨ́ teɨte tɨ́j naꞌa tɨ seijreꞌe huaꞌateyuu tzajtaꞌa. Aꞌɨ́ɨ pu jɨ́n tihuáꞌaꞌixaꞌatehuaꞌa ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ tíꞌaijta nainjapua ɨ́ chaanaca. Ajta Jesús tihuáꞌuhuaa naíjmiꞌica ɨ́ mej tíꞌicucuiꞌi. Capu tíꞌiseicaj naꞌa ɨ́ cuíꞌiniꞌiraꞌa. Aꞌɨ́ɨ pu nain jɨ́n tiúꞌuhuaatacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Aj mú mi ráamuaꞌareeriꞌi tɨ́j naꞌa aꞌuun tɨ huatacáꞌa seɨ́j ɨ́ chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Siria. Aꞌɨ́j mú huámuaꞌareeriꞌi aꞌij tɨ tiꞌitɨ́j huáruu aꞌɨ́jna ɨ́ Jesús. Matɨ́ꞌɨj mi u huajaꞌaráaviꞌitɨ ɨ́ mej tíꞌicucuiꞌi, tɨ tiꞌimuꞌíi ɨ́ cuíꞌiniꞌiraꞌa. Seica mú huápɨꞌɨ tíꞌicucuiꞌicaa, ajta seica, capu huáꞌacaꞌanistiꞌiracaꞌa. Ajta seica, tiyaaruꞌu pu huáꞌa tzajtaꞌa seijreꞌecaꞌa, majta seica ɨ́ tɨ huaꞌacáteuunéjmeꞌecaa, majta seica mú cɨyáaxaviꞌi. Naíjmiꞌica pu tihuáꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jéihua mú ajteáxɨɨrecaꞌa ɨ́ teɨte, ɨ́ mej meꞌuun eꞌeráacɨ aꞌujna chuéjraꞌa japua u Galileeye. Majta seica, aꞌúu mú eꞌeráacɨ tɨ ayén téjaꞌarájtehuaa tɨjɨ́n tamuáamuataꞌa tɨ chájtaꞌajme, majta seica meꞌújna jáꞌahuaꞌa u Jerusalén, majta seica tɨ́j naꞌa aꞌuun tɨ huatacáꞌa u Judea. Seica mú majta aitacɨ́j ɨ́ mej utavén pújmeꞌen eꞌechéjmeꞌe u Jordán. Jéihua mú jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tɨ́ꞌɨj huaꞌuseíj ɨ́ teɨte mej jeíhua muꞌiicáa, aj puꞌi antíraa ɨ́ Jesús ɨ́ jɨrí japua. An pu aꞌujyeíjxɨ. Matɨ́ꞌɨj mi aꞌɨ́ɨme ɨ́ mej áꞌujujhuaꞌaneꞌe jamuan, aꞌɨ́ɨ mú ajteáxɨɨrecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Aj pu i aꞌutéjche tɨ tihuáꞌumuaꞌaten. ");
INSERT INTO crnNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ayen tɨjɨ́n: ―Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej tirúꞌumuaꞌaree ɨ́ ru tzajtaꞌa mej caí aꞌij tíꞌijviicuaꞌi ɨ́ Dios jemi, aꞌiné aꞌɨ́ɨ mú meꞌuun huatéꞌuu muáꞌajuꞌun ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej ruxɨeemɨ́jteꞌe meꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi aꞌiné Dios pu rɨ́ꞌɨ tihuaꞌutáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej rɨ́ꞌɨ téꞌumuajcaa ɨ́ ru tzajtaꞌa ɨ́ Dios jemi, aꞌiné aꞌɨ́ɨ mú raꞌancuréꞌasin aꞌɨ́jna chuéjraꞌa tɨ jɨ́meꞌen Dios teꞌateújratziiriꞌi tɨ huaꞌutáꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej rahuauca, majta ɨ́ mej jeíhua raxɨ́ꞌeveꞌe, mej mi miyen huárɨni aꞌij tɨ tiraavíjteꞌe ɨ́ Dios jemi, aꞌiné Dios pu ayén huáꞌaruuren mej mi miyen raꞌaráꞌastijreꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej huáꞌacuꞌuve ɨ́ seica ɨ́ ruꞌihuaamuaꞌa, aꞌiné Dios pu huáꞌancuꞌuvajxɨꞌɨsin aꞌɨ́mej. ");
INSERT INTO crnNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej urarɨ́ꞌen seijreꞌe ɨ́ ruxɨ́ejniuꞌuca jetze, aꞌiné aꞌɨ́ɨ mú raseijran ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej rahuauhuau mej caí neꞌuseꞌe, aꞌiné ayée pu Dios huaꞌutámuaꞌatzi tɨjɨ́n: “Niyaujmuaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Micheꞌe huaújtemuaꞌaveꞌen jeíhua ɨ́ mej rajpuaíitzi muáꞌayeꞌi meꞌɨ́jna jɨmeꞌe mej miyen rɨcɨ aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Nain pu xaa tihuáꞌacɨꞌɨti aꞌujna aꞌu tɨ éꞌeseijreꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Setáꞌaj huaújtemuaꞌaveꞌen setɨ́j senaꞌa puaꞌamé múꞌeen, tɨ puaꞌa meꞌɨ́n ɨ́ teɨte miyen aꞌij puaꞌa tejáꞌamuaxajta, majta aꞌij puaꞌa áꞌamuaruure naꞌari huaꞌitzi jɨ́n tejáꞌamuaxajtziꞌi meꞌɨ́jna jɨmeꞌe sej tíꞌixaxaꞌa neetzi jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Setáꞌaj huaújtemuaꞌaveꞌen. Caxú ruxɨeemɨsteꞌe, aꞌiné jeíhua pu tejáꞌamuacɨꞌɨti ɨ́ ta japua Dios tɨ éꞌeseijreꞌe. Ayee mú cheꞌatá menaꞌa huáꞌuruu aꞌɨ́mej ɨ́ mej mejmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Ayee xu hui tíꞌivaɨreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte tɨ́j ajta tíꞌivaɨreꞌe ɨ́ unaj ɨ́ mej jɨ́n tíꞌicacare ɨ́ cuaꞌira japua. Aꞌɨ́jna ɨ́ unaj tíꞌivaɨreꞌe tɨ́ꞌij caí huatépete ɨ́ huaꞌiraꞌa. Mɨ́ ajta, tɨ puaꞌa huateáruꞌuna, aj puꞌi ráxɨꞌɨsin ɨ́ tɨ aꞌancacá. ¿Aꞌiné auj tíꞌirɨꞌɨri tɨ́ꞌij ajtahuaꞌa ancacá áꞌaraꞌani? Capu chéꞌe aꞌij tíꞌirɨꞌɨri, aꞌiné puꞌuri ráaxɨꞌɨ ɨ́ tɨ ancacá. Ayee puꞌu qui tíꞌivaɨreꞌe mej mi mé rúurɨeexɨn, mej mi majta ratzíinajyeꞌican ɨ́ teɨte. Rɨ́ꞌɨ xuꞌu múꞌeen tɨ́ꞌij caí ayén cheꞌatá naꞌa tejamuáaruuren múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Ayee xu seijreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte tɨ́j tatzari tɨ jaꞌatɨ́ án yáꞌujche tɨ ij aꞌɨmuá aꞌatáneeriꞌicɨj nainjapua íiyen chaanaca japua. Ajta, chajtaꞌa tɨ aꞌutáca ɨ́ jɨrí jetze, capu rɨꞌɨrí tɨ huateúravaa. ");
INSERT INTO crnNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ajta, capu jaꞌatɨ́ ayén cantiiraꞌa antítaiira tɨ ij aꞌuun yaꞌuteárujteꞌen ɨ́ utaatzi jete, sino án pu yaꞌujchájtza ánɨmua tɨ́ꞌij aꞌɨmuá aꞌatáneeriꞌicɨj huáꞌa tzajtaꞌa ɨ́ mej uráatei u chiꞌita. ");
INSERT INTO crnNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Aꞌɨ́j pu jɨ́n, tɨ puaꞌa tiꞌitɨ́j aꞌij seruure múꞌeen, setáꞌaj hui siyen ráaruuren mé jéjreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte mej mi ráamuaꞌaree sej siyen rɨcɨ seꞌɨ́jna jɨmeꞌe ɨ́ tɨ íꞌixɨꞌepɨꞌɨn. Aj mú mi xaa rɨ́ꞌɨ tiraateájtuaani ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Caxu siyen tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa yee nee nu raꞌantipuáꞌajteꞌesin neꞌɨ́jna ɨ́ niuucari tɨ raateájtuaa itejmi jemi aꞌɨ́jna ɨ́ Moisés teecan, ajta ɨ́ mej raataxájtacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Canu neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej nej ni raꞌantipuáꞌajteꞌen neꞌɨ́jna ɨ́ niuucari. Canu xaa neꞌu. Ayee nu ꞌeen jɨ́n mú aꞌuvéꞌemej nej ni raanaíjmireꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, tɨ́ꞌɨj auj seijreꞌe tɨ yen seijreꞌe íiyen chaanaca japua, ajta ɨ́ tɨ éꞌeseijreꞌe júteꞌe u ta japua, capu hui tiꞌitɨ́j aꞌuvaɨ́jtzi aꞌɨ́jna jetze ɨ́ mej raꞌuyúꞌuxacaꞌa ɨ́ yuꞌuxari jetze, capu tiꞌitɨ́j, tɨ puaꞌa leetra naꞌa, naꞌari ɨ́ tɨ raꞌavéꞌeraráatzajme. ");
INSERT INTO crnNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","’Aꞌɨ́j pu jɨ́n, tɨ puaꞌa jaꞌatɨ́ caí raꞌaráꞌastijreꞌen seɨ́j ɨ́ niuucari tɨ ayén téꞌeyuꞌusiꞌihuacaꞌa ɨ́ yuꞌuxari jetze, tɨ puaꞌa ajta aꞌɨ́ɨn tiráamuaꞌaten seɨ́j ɨ́ jaꞌatɨ tɨ ayén cheꞌatá naꞌa caí raꞌaráꞌastijreꞌen aꞌɨ́jna, Dios pu jemi ayén ámitɨeereꞌe tɨ caí tiꞌitɨ́j vaɨreꞌe aꞌɨ́jna ɨ́ jaꞌatɨ aꞌujna u ta japua. Capu amɨ́n aꞌij tɨ puaꞌa caí raꞌaráꞌastijre ɨ́ niuucari tɨ jaítzeꞌe caí ruxeꞌeveꞌe; aúcheꞌe pu veꞌecán jɨ́n auteáturaasin ɨ́ Dios jemi. Mɨ ajta, tɨ puaꞌa jaꞌatɨ́ tɨ naꞌa tɨ ayén ráꞌatzaahuateꞌe aꞌɨ́jna ɨ́ niuucari, ajta seica tiúꞌumuaꞌaten mej mi miyen cheꞌatá menaꞌa rɨjca, Dios pu jemi ámitɨeereꞌe tɨ aꞌɨ́ɨn xaa tíꞌivaɨreꞌe jeíhua u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","’Aꞌɨ́j pu jɨ́n, ayée nu tejáꞌamuaꞌixaateꞌe, tɨ puaꞌa secaí siyen tihuaꞌutémuaꞌitɨn aꞌɨ́mej ɨ́ mej tihuáꞌumuaꞌaten ɨ́ yuꞌuxari jetze, majta aꞌɨ́mej ɨ́ fariseos, tɨ puaꞌa secaí huaꞌutémuaꞌitɨn seꞌɨ́jna jɨmeꞌe ɨ́ sej raꞌaráꞌastijreꞌen aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze, ca xu jaꞌanáj aꞌuteáruti aꞌájna Dios tɨ éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Xuꞌuri siyen ráanamuajriꞌi mej miyen tihuaꞌutáꞌixaa ɨ́ áꞌamuayaꞌupuacɨꞌɨstemuaꞌa tɨjɨ́n: “Caxu tíꞌitecuiꞌica. Naꞌari caí, tɨ puaꞌa jaꞌatɨ́ seɨ́j huajéꞌica, ruxeꞌeveꞌe mej puaíjtzi raatáꞌan.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","’Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe, tɨ puaꞌa jaꞌatɨ́ ayén huataniúꞌucan jemin ɨ́ ruxɨ́ꞌej tevi, ayée pu tiúꞌujxeꞌeveꞌe tɨ Dios ayén puaíjtzi raatáꞌan aꞌɨ́jna ɨ́ jaꞌatɨ. Neajta niyen tejáꞌamuaꞌixaateꞌe, tɨ puaꞌa jaꞌatɨ́ ayén aꞌij puaꞌa tiraatájeeve aꞌɨ́jna ɨ́ ruxɨ́ꞌej tevi tɨjɨ́n: “Múꞌee pej caí tiꞌitɨ́j huayɨ́ꞌɨtɨ”, ayée pu tiúꞌujxeꞌeveꞌe mej ráꞌanviꞌitɨn aꞌɨ́mej jemi ɨ́ jueesi. Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe, tɨ puaꞌa jaꞌatɨ́ ayén aꞌij puaꞌa tiraatájeeve ɨ́ ruxɨ́ꞌej tevi tɨjɨ́n: “Múꞌee pej caí tiꞌitɨ́j muaꞌaree”, ayée pu Dios ayén tiraatáꞌixaateꞌesin tɨjɨ́n: “Aricu, áa pej aꞌutevée puáꞌaraꞌani ɨ́ taij tzajtaꞌa tɨ caí jaꞌanáj áꞌamɨꞌɨni.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Aꞌɨ́j pu jɨ́n, tɨ puaꞌa peri tiꞌitɨ́j tíꞌimuaɨꞌɨvajta aꞌɨ́jna japua aꞌu sej yéꞌanaꞌamiche ɨ́ Dios, tɨ puaꞌa peri raꞌutámuaꞌaree ɨ́ pej jɨ́n auteájturaa jemin ɨ́ axɨ́ꞌej tevi, ayée pej huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Aꞌuu pej yeꞌutécan ɨ́ pej tiuꞌutámuaɨꞌɨvejta aꞌɨ́jna japua aꞌu sej yéꞌanaꞌamiche ɨ́ Dios. Patáꞌaj amuacaí u áꞌumeꞌen aꞌɨ́jna jemi ɨ́ axɨ́ꞌej tevi patáꞌaj tiuꞌutáꞌuuniꞌi ɨ́ pej jɨ́n aꞌuteájturaa ɨ́ jemin. Aj pu xaa ari rɨꞌɨrí pej mú aꞌuvéꞌemeꞌen patáꞌaj tiuꞌutámuaɨꞌɨvejta. ");
INSERT INTO crnNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Setáꞌaj caꞌanacan raaxɨ́ꞌepɨꞌɨntareꞌen aꞌɨ́jna jamuan ɨ́ tɨ muájchaꞌɨɨreꞌe, tɨ́ꞌɨj auj muáꞌanviꞌitɨn huáꞌa jemi ɨ́ jueesi. Setáꞌaj siyen raaxɨ́ꞌepɨꞌɨntareꞌen setɨ́ꞌɨj seuj huajúꞌun ɨ́ juye jetze. Naꞌari tɨ puaꞌa pecaí piyen huárɨni, aꞌɨ́ɨ pu múꞌeetzi tiuꞌutátuiireꞌesin ɨ́ juees jemi. Ajta aꞌɨ́jna múꞌeetzi pu tiuꞌutátuiireꞌesin jemin aꞌɨ́jna ɨ́ tɨ ravaɨreꞌe. Ajta aꞌɨ́ɨn tɨ ravaɨreꞌe, aꞌɨ́ɨ pu muaꞌiteánajsin. ");
INSERT INTO crnNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ayee nu hui tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, camu jaꞌanáj muaꞌirátuaasin ajta penaꞌa caí tihuaꞌunájchiteꞌen nai jɨmeꞌe aꞌachú mej muáꞌijijveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Xuꞌuri ráanamuajriꞌi ɨ́ mej mejmíꞌi miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: “Capej ꞌɨ́itaꞌa jamuan huiꞌica ɨ́ pej caí ratéviꞌitɨn.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","’Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe tɨjɨ́n: Aꞌatɨ́ tɨ naꞌa tɨ ayén ꞌɨ́itaꞌa seijra temuaꞌa naa tɨ ij ayén raatáꞌasti ɨ́ ru tzajtaꞌa tɨ jamuan huáhuiꞌini, ayée nu tejáꞌamuaꞌixaateꞌe tɨ aꞌɨ́jna ɨ́ jaꞌatɨ ari tiúꞌujxanaꞌacɨraꞌate ɨ́ ru tzajtaꞌa aꞌɨ́jna jamuan ɨ́ ꞌɨ́itaꞌa tɨ caí ratéviꞌitɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Neajta nu niyen tejáꞌamuaꞌixaateꞌe tɨjɨ́n: Tɨ́ puaꞌa piyen éeneꞌen pej jetzen rapuaꞌajteꞌe mɨ áꞌajɨꞌɨ tɨ arɨꞌɨríintaꞌa pújmeꞌen seijreꞌe peꞌɨ́jna jɨmeꞌe ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi, aitátɨchi muáꞌajɨꞌɨ tɨ arɨꞌɨríintaꞌa pújmeꞌen seijreꞌe. Aa pej yaúurɨeni. Ayee pej huárɨni, aꞌiné jaítzeꞌe pu timuaatévaꞌɨri pej tiꞌitɨ́j áꞌurɨeni tɨ cɨ́lieen caí pej nain eꞌehuáꞌarɨeni matɨ́ꞌɨj án muajáꞌurɨeeni ɨ́ taij tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ajta tɨ puaꞌa piyen éeneꞌen pej jetzen rapuaꞌajteꞌe mɨ áꞌamuajcaꞌa arɨꞌɨríintaꞌa pújmeꞌen seijreꞌe, patáꞌaj raꞌajtaveíjche amɨ́jna mɨ áꞌa muájcaꞌa. Pajta aꞌɨmuá yaúurɨeni aꞌiné jaítzeꞌe pu timuaatévaꞌɨri pej tiꞌitɨ́j áꞌurɨeni tɨ cɨ́lieen caí pej nain eꞌehuáꞌarɨeni matɨ́ꞌɨj án mú jáꞌurɨeni ɨ́ taij tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Majta hui mejmíꞌi miyen tíꞌixaxaꞌataꞌa tɨjɨ́n: “Jaꞌatɨ́ tɨ raxɨ́ꞌeveꞌe tɨ ruꞌɨ́j mé úurɨeni, chéꞌe aꞌɨ́ɨn cuapée raatapíjteꞌen ɨ́ ruꞌɨ́j ɨ́ tɨ jɨ́n mé rúurɨeni.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe. Tɨ́ puaꞌa jaꞌatɨ́ ruꞌɨ́j mé úurɨeni, caí ayén tiꞌitɨ́j jɨ́n huarɨ́n aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ xanaꞌacɨreꞌe, tɨ puaꞌa caí seɨ́j jamuan huáhuiꞌini, seɨ́j puꞌu ɨ́ tɨ jɨ́n tiuꞌutáꞌa tɨ ij jaꞌatɨ́ ruꞌɨ́j mé úurɨeni. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ iꞌi ɨ́ɨraꞌaraꞌantacaꞌa tihuaújxanaꞌacɨraꞌate seɨ́j jamuan ɨ́ teáataꞌa. Aj pu xaa íꞌirɨꞌɨri tɨ mé rúurɨeni. Ajta aꞌɨ́jna ɨ́ teáataꞌa tɨ seɨ́j ancuréꞌeviꞌitɨn ɨ́ ꞌɨ́itaꞌa tɨ jaꞌatɨ́ ari mé rúurɨe, aꞌɨ́jna ɨ́ jaꞌatɨ ajta pu tihuaújxanaꞌacɨraꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Seajta xuꞌuri ráanamuajriꞌi seꞌíjna i niuucari ɨ́ mej mejmíꞌi tihuaꞌutáꞌixaa ɨ́ teɨte tɨjɨ́n: “Capej yáꞌujɨpuan ɨ́ pej jɨ́n teꞌatáꞌaratziira niuucajtzeꞌen ɨ́ Dios.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","’Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe tɨjɨ́n: Caxu aꞌatzu teꞌataújratziꞌiraꞌan niuucajtzeꞌen ɨ́ Dios, caxu aꞌatzu. Caxu seajta teꞌataújratziꞌiraꞌan niuucajtzeꞌen ɨ́ ta japua, aꞌiné aꞌɨ́ɨ pu japuan án áꞌujca ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Caxu seajta teꞌataújratziꞌiraꞌan niuucajtzeꞌen i chaanaca aꞌiné aꞌɨ́ɨ pu yen raꞌɨ́ɨcajme ɨ́ Dios. Caxu seajta teꞌataújratziꞌiraꞌan ɨ́ niuucajtzeꞌen ɨ́ Jerusalén, aꞌiné aꞌɨ́ɨ pu antiújmuaꞌaree íiye chajtaꞌa aꞌɨ́jna ɨ́ Rey tɨ veꞌée. ");
INSERT INTO crnNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Caxu seajta teꞌataújratziꞌiracareꞌen niuucajtzeꞌen mɨ aꞌamuamuꞌúu jetze, aꞌiné caxu rujɨ́ɨmuaꞌa senaꞌa raayɨ́ꞌɨtɨ sej raatéxuꞌumuareꞌen naꞌari sej raatécuainareꞌen seɨ́j mɨ aꞌamua cɨpua. ");
INSERT INTO crnNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","’Chéꞌe ayén éeneꞌen, tɨ puaꞌa piyen raataxáj yee “¡Jee!”, chéꞌe ayén éeneꞌen tzáahuatiꞌiraꞌa jɨmeꞌe yee “¡Jee!” Ajta, ayén cheꞌatá naꞌa, tɨ puaꞌa piyen yee “¡Capu!”, chéꞌe ayén éeneꞌen tzáahuatiꞌiraꞌa jɨmeꞌe yee “¡Capu!” Tiꞌitɨ́ tɨ aꞌij seɨcɨé ꞌeen, aꞌɨ́jna jetze pu avéꞌemeꞌecan aꞌɨ́jna ɨ́ tɨ aꞌij puaꞌa ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Xuꞌuri siyen tiúꞌunamuajriꞌi ɨ́ mej mejmíꞌi miyen tíꞌixaxaꞌataꞌa tɨjɨ́n: “Tɨ́ puaꞌa jaꞌatɨ́ raꞌitátɨni ɨ́ jɨꞌɨseáaraꞌan ɨ́ ruxɨ́ꞌej tevi, ruxeꞌeveꞌe tɨ aꞌɨ́jna ɨ́ jaꞌatɨ ayén cheꞌatá naꞌa tiuꞌunájchita rujɨ́ꞌɨ jɨmeꞌe.” Ajta ayén tɨjɨ́n: “Tɨ́ puaꞌa jaꞌatɨ́ seɨ́j raꞌantácuura ɨ́ tamaaraꞌan, ruxeꞌeveꞌe tɨ aꞌɨ́jna jaꞌatɨ́ ayén cheꞌatá naꞌa tiuꞌunájchita rutamej jɨmeꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","’Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe yee: Caxu siyen cheꞌatá senaꞌa raruure ɨ́ tɨ aꞌij puaꞌa ꞌeen aꞌij tɨ aꞌɨ́ɨn ari ayén amuáaruu múꞌejmi. Tɨ́ puaꞌa jaꞌatɨ́ muꞌitéjveeni muaꞌɨpée jetze arɨꞌɨríintaꞌa pújmeꞌen, patáꞌaj pajta raatáꞌan tɨ muꞌitéjveeni ɨ́ seɨ́jtaꞌa ɨ́ muaꞌɨpée jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tɨ́ puaꞌa jaꞌatɨ́ caꞌanéeri jɨ́n muájhuavii mɨ áꞌasiicuꞌu tɨ ij aꞌɨ́ɨn múꞌijchueeni, patáꞌaj raatáchuiteꞌen pajta mɨ pej jɨ́meꞌen raꞌitévajra mɨ áꞌahuareꞌetzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ajta, tɨ puaꞌa jaꞌatɨ́ muaꞌáijteꞌe pej tiꞌáꞌaraꞌan téꞌentɨni seɨ́j viꞌiraꞌa ɨmuá tɨ huatátee, patáꞌaj huaꞌapua viꞌiraꞌa ɨmuá téꞌentɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Pajta, patáꞌaj raatáꞌan, tɨ puaꞌa jaꞌatɨ́ tiꞌitɨ́j muáhuaviira, capej ramuaireꞌe ɨ́ jaꞌatɨ tɨ muaneɨ́ɨriꞌira aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ayee xu seri ráanamuajriꞌi ɨ́ mej mejmíꞌi miyen tíꞌixaxaꞌataꞌa tɨjɨ́n: “Patáꞌaj raxɨ́ꞌeveꞌe puáꞌaraꞌani peꞌɨ́jna ɨ́ áꞌamiigu.” Ajta ayén tɨjɨ́n: “Patáꞌaj rájchaꞌɨɨreꞌe puáꞌaraꞌani peꞌɨ́jna ɨ́ tɨ muájchaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe yee: Patáꞌaj raxɨ́ꞌeveꞌe puáꞌaraꞌani aꞌɨ́jna ɨ́ tɨ muájchaꞌɨɨreꞌe. Pajta rahuaviira ɨ́ Dios jemi aꞌɨ́mej jɨ́meꞌen ɨ́ mej aꞌij puaꞌa áꞌamuaruure sej si siyen ruxɨ́ꞌej éeneꞌen xáꞌaraꞌani aꞌujna, áꞌamuayaꞌupua tɨ éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","’Aꞌɨ́ɨ pu hui huatáꞌaca tɨ aꞌɨ́ɨn xɨca huaꞌutétatzaviꞌiteꞌe huáꞌa japua ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte, ajta huáꞌa japua ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte. Ajta aꞌɨ́ɨ pu huatáꞌaca mej mi víjviꞌiyej huáꞌa japua ɨ́ mej xɨ́ꞌepɨꞌɨn rɨcɨ, majta huáꞌa japua ɨ́ mej aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tɨ́ puaꞌa siyen huáꞌaxeꞌeveꞌe senaꞌa aꞌɨ́mej ɨ́ mej jáꞌamuaxeꞌeveꞌe múꞌejmi, ¿ni secaí siyen tíꞌimuaꞌatze sej si seꞌɨ́jna jɨ́n tiꞌitɨ́j huamuáꞌitɨn ɨ́ Dios jemi? Mɨ́ seajta caí, caxu. Casiꞌi, ayée mú cheꞌatá menaꞌa rɨcɨ aꞌɨ́ɨme ɨ́ mej áꞌujujhuaꞌan ɨ́ mej huaꞌujíjveꞌe ɨ́ mej tíꞌitɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ajta, tɨ puaꞌa siyen huaꞌutateújte senaꞌa seꞌɨ́mej ɨ́ mej áꞌamuaꞌihuaamuaꞌa púꞌeen, ¿ni qui caí ayén tejamuáꞌamitɨejteꞌe sej siyen huaꞌutémuaꞌitɨn ɨ́ seica? Mɨ́ seajta caí, caxu. ¿Ni qui mecaí miyen rɨcɨ aꞌɨ́ɨme ɨ́ mej caí ramuaꞌate ɨ́ Dios tzáahuatiꞌiraꞌa jɨmeꞌe? Ayee mú rɨcɨ xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","’Aꞌɨ́j pu jɨ́n, setáꞌaj siyen raanaíjmireꞌen aꞌachú tɨ tejamuáꞌaturaateꞌe, sej si siyen ruxɨ́ꞌej ꞌeeneꞌen temuaꞌa naa aꞌujna aꞌu tɨ áꞌamuayaꞌupua éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Rɨ́ꞌɨ xuꞌu múꞌeen sej caí siyen huárɨni ɨ́ tɨ xɨ́ꞌepɨꞌɨn ꞌeen mé jéjreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte mej mi amuaaséij. Tɨ́ puaꞌa siyen senaꞌa rɨjca, capu tiꞌitɨ́j tejáꞌamuacɨꞌɨti aꞌɨ́jna jemi ɨ́ sej rájyaꞌupua tɨ aꞌɨ́ɨn tejámuaatapuaíjveꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aꞌɨ́j pu jɨ́n, setɨ́ꞌɨj tihuáꞌapuaijveꞌe aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, caxu raxájta mé jéjreꞌe yee ayée tu huarɨ́j. Ayee mú xaa rɨcɨ seica ɨ́ ruteyujtaꞌa, majta caaye jetze aꞌɨ́ɨme ɨ́ mej raꞌaráꞌastijreꞌe huaꞌayeꞌira jéjreꞌecɨtzeꞌe. Aꞌɨ́ɨ mú miyen rɨcɨ mej mi aꞌɨ́ɨn teɨte rɨ́ꞌɨ tihuaꞌutáꞌixaateꞌen. Ayee nu tejáꞌamuaꞌixaateꞌe tɨjɨ́n aꞌɨ́ɨ mú meri nain huamuáꞌitɨ meꞌɨ́jna jɨmeꞌe ɨ́ mej teɨte rɨ́ꞌɨ tiuꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mɨ́ pajta múꞌee, tɨ puaꞌa tiꞌitɨ́j paraatapuaíjveꞌen ɨ́ tɨ caí aꞌij tíꞌijviicuaꞌi, ayée pej huárɨni tɨ ij caí jaꞌatɨ́ ráamuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ayee pej huárɨni, tɨ puaꞌa petiuꞌutapuaíjveꞌen avíitzi jɨmeꞌe, aj pu xaa, aꞌɨ́ɨn ɨ́ pej rájyaꞌupua, aꞌɨ́ɨ pu raseíj ɨ́ tɨ rúꞌavaa. Ajta, aꞌɨ́ɨ pu timuaatáꞌasin aꞌɨ́jna ɨ́ pej raamuáꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Ajta, setɨ́ꞌɨj múꞌeen téniuusimeꞌen ɨ́ Dios jemi, caxu siyen jéjreꞌecɨtzeꞌe rɨjca matɨ́j ɨ́ seica ɨ́ mej nuꞌu raꞌaráꞌastijreꞌe huaꞌayeꞌira ɨ́ mej miyen tíꞌijrɨꞌɨre. Yee pu tihuaꞌaráanajche mej uteáruꞌipi u teyujtaꞌa mej huatéjniuuni ɨ́ Dios jemi, naꞌari mej miyen eꞌejcáacɨꞌɨca aꞌujna caaye jetze mej mi seica huaꞌuseíj. Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, amɨ́ muꞌu huamuáꞌitɨ, xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","’Mɨ́ pajta múꞌee, patɨ́ꞌɨj téniuusimeꞌen ɨ́ Dios jemi, pauj miꞌi uteárutén aꞌujna ꞌachiꞌitá. Pajta teꞌiteanán ɨ́ taꞌanténineꞌi jɨmeꞌe. Aj pej xaa pi huatéjniuuni aꞌɨ́jna jemi ɨ́ pej rájyaꞌupua ɨ́ tɨ caí seijreꞌe. Ajta áꞌiyen aꞌɨ́jna ɨ́ pej rájyaꞌupua ɨ́ tɨ tíꞌisiseꞌij naíjmiꞌi tɨ́j naꞌa aꞌu tɨ éꞌeruuriꞌihuacaꞌa avíitzi jɨmeꞌe, aꞌɨ́ɨ pu hui muaatáꞌasin ɨ́ pej raamuáꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Ajta, patɨ́ꞌɨj téniuusimeꞌen ɨ́ Dios jemi, capej piyen áꞌateeviꞌin pej téniuusimeꞌen ɨ́ niuucari jɨmeꞌe tɨ caí aꞌij huataújmuaꞌa. Ayee mú xaa rɨcɨ aꞌɨ́ɨme ɨ́ mej caí ramuaꞌate ɨ́ Dios. Ayee pu tihuáꞌamitɨejteꞌe tɨ Dios ayén huáꞌunamua tɨ puaꞌa miyen áꞌateeviꞌin mej téniuusimeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Caxu siyen cheꞌatá senaꞌa rɨjca matɨ́j aꞌɨ́ɨme, aꞌiné ayée pu i tíꞌeen sej caí xɨ huatéeniu jemin ɨ́ sej rájyaꞌupua, aꞌɨ́ɨ pu ari rúꞌumuaꞌaree tiꞌitɨ́j tɨ aꞌij tejamuáꞌaturaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ayee xu si tíꞌijhuaviira. Siyen tɨjɨ́n: Múꞌee, ɨ́ pej táꞌiyaꞌupua, aꞌúu pej éꞌeseijreꞌe u ta japua, michéꞌe rɨ́ꞌɨ yáꞌunamuajra aꞌij pej ántehuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chéꞌe tejaꞌuréꞌenen aꞌájna xɨcájraꞌa jetze patɨ́ꞌɨj nainjapua tiuꞌutaꞌaíjta íiyen chaanaca japua. Michéꞌe raꞌaráꞌastijreꞌen aꞌij pej tíꞌijxeꞌeveꞌe íiyen chaanaca japua mej mi miyen cheꞌatá menaꞌa raꞌaráꞌastijreꞌen u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Patáꞌaj pajta taatáꞌan ɨ́ tɨ tíꞌicuaꞌiriꞌi ɨ́ tɨ ruxeꞌeveꞌe nain xɨcaj tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Titaatáꞌuuniꞌiriꞌi ɨ́ tej jɨ́n auteájturaa múꞌeetzi jemi aꞌiné ayée tu cheꞌatá tenaꞌa rɨ́ꞌɨ tíhuaꞌutáꞌuuniꞌira aꞌɨ́mej ɨ́ mej auteájturaa itejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pajta, capej piyen titaatáꞌacareꞌen ti ayén titáacɨꞌɨti ɨ́ tej jɨ́meꞌen caí ráꞌaviicuaꞌi sino patáꞌaj piyen ta japua huániuuni tɨ ij caí taatémuaꞌitɨn aꞌɨ́jna tɨ aꞌij puaꞌa ꞌeen. Ayee tu tíꞌimuahuavii aꞌiné múꞌee pej tíꞌitaꞌaijteꞌe nainjapua, múꞌee pej antíꞌamuaꞌaree nain jɨmeꞌe, michéꞌe naímiꞌi rɨ́ꞌɨ timuaatatémuaꞌavisteꞌen tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe. Tɨ́ puaꞌa siyen tihuaꞌutáꞌuuniꞌi ɨ́ teɨte ɨ́ mej jɨ́n auteájturaa múꞌejmi jemi, aꞌɨ́ɨ pu ajta tejámuaatáꞌuuniꞌira múꞌejmi aꞌɨ́jna ɨ́ sej rájyaꞌupua tɨ aꞌuun éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mɨ́ ajta, tɨ puaꞌa secaí siyen tihuaꞌutáꞌuuniꞌi ɨ́ teɨte ɨ́ mej jɨ́n auteájturaa múꞌejmi jemi, aꞌɨ́jna ɨ́ sej rájyaꞌupua, capu ajta tejámuaatáꞌuuniꞌira múꞌejmi ɨ́ sej jɨ́n auteájturaa ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Tɨ́ puaꞌa seúruꞌitziꞌiveꞌe, caxu siyen acaújtzaahuateꞌe ɨ́ runéerime jetze matɨ́j aꞌɨ́ɨme ɨ́ seica ɨ́ mej miyen rɨcɨ jéjreꞌecɨtzeꞌe. Aꞌɨ́ɨme ɨ́ teɨtejraꞌa, ayée mú acaújtzaahuateꞌe ɨ́ runéerime jetze mej mi seica teɨte ráamuaꞌaree yee mej rúꞌitziꞌiveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Muꞌuri meꞌɨ́jna jɨ́meꞌen raamuáꞌitɨ nain ɨ́ tɨ tihuáꞌacɨꞌɨti. Mɨ́ pajta múꞌee, patɨ́ꞌɨj áꞌitziꞌiveꞌe, patáꞌaj acáꞌajɨstaꞌanteꞌen, pajta teꞌaváꞌahuaateꞌen áꞌamuꞌuutzeꞌe aceite jɨmeꞌe, mej mi caí ráamuaꞌaree ɨ́ teɨte yee peꞌáꞌitziꞌiveꞌe. Aꞌɨ́ɨ puꞌu ayáꞌupua ɨ́ pej caí rasiseꞌi, aꞌɨ́ɨ pu ramuaꞌaree. Ajta aꞌɨ́jna ɨ́ ayáꞌupua tɨ rasiseꞌi ɨ́ tɨ rúꞌavaa, aꞌɨ́ɨ pu muaatáꞌasin ɨ́ pej raamuáꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Caxu siyen téꞌuseɨreꞌe u ruchiꞌitá jeíhua ɨ́ tɨ huápɨꞌɨ tíꞌijnajche sej si seꞌuun teꞌuráchaꞌɨɨca. Tɨ́ puaꞌa siyen huárɨni, aj mú mi tejpuási raatéteꞌeneajxɨꞌɨsin ɨ́ caanari. Ajta ɨ́ tepúustiꞌi, temuaꞌa pu tiuꞌuteújchuitaamuaꞌasin. Majta aꞌɨ́ɨme ɨ́ nahuaꞌari, aꞌúu mú uteáruti caꞌanéeri jɨmeꞌe. Matɨ́ꞌɨj mi téꞌunahuaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mɨ́ seajta múꞌeen, setáꞌaj teꞌuhuáseɨreꞌen u ta japua jeíhua ɨ́ tɨ huápɨꞌɨ ruxeꞌeveꞌe ɨ́ Dios jemi. Capu tiꞌitɨ́j ruchuitáamuaꞌaca aꞌujna, capu ajta tiꞌitɨ́j aꞌuvaɨ́jtzi. Camu majta uteáruꞌipi ɨ́ nahuaꞌari meꞌújna. ");
INSERT INTO crnNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ayee pu téꞌeme: tiꞌitɨ́j tɨ naꞌa tɨ múꞌejmi tejáꞌamuaꞌa, tɨ jaítzeꞌe timuaatévaꞌɨri, múꞌeen xu tiújmuaꞌatzíiteꞌe xáꞌajuꞌun seꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Ajta hui, amɨ́jna mɨ áꞌajɨꞌɨ, aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ pej jɨ́n áꞌucheꞌecan. Tɨ́ puaꞌa rɨꞌéeneꞌen puáꞌajjɨꞌɨsíjmeꞌeni, temuaꞌa pej naa meteúunee. ");
INSERT INTO crnNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mɨ́ ajta, tɨ puaꞌa caí tiꞌitɨ́j vaɨreꞌe muaꞌa jɨ́ꞌɨ, ayée pu huaꞌéen cumu tɨ́j huatɨ́caꞌa. Ajta muaꞌaxɨejniuꞌuca, tɨ puaꞌa piyen rɨ́ꞌɨ raatéꞌavaa, ayée pu cheꞌatá naꞌa tíꞌivaɨreꞌe ɨ́ pej jɨ́n huáyeꞌiven huáꞌa tzajtaꞌa ɨ́ teɨte. Ajta tɨ puaꞌa piyen caí rɨ́ꞌɨ tiraatéꞌavaa ɨ́ muaꞌaxɨejniuꞌuca tɨ ij caí chéꞌe mú áꞌayee mú áꞌuviꞌitɨjcareꞌen, ¿ni caí ayén teꞌiráame cumu tɨ́j huatɨ́caꞌa? Capu aꞌatzu huáneeriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Capu jaꞌatɨ́ raayɨ́ꞌɨtɨ tɨ huaꞌapuaca jemi tiuꞌutévaɨreꞌen. Tɨ́ puaꞌa tiuꞌutatéseꞌen tɨ ayén huárɨni, seɨ́j pu tichaꞌɨ́ɨreꞌe aꞌame tɨ tíꞌiraꞌaijteꞌe, ajta ɨ́ seɨ́j, aꞌɨ́ɨ pu raxɨ́ꞌeveꞌe aꞌame tɨ tiraataꞌaíjteꞌen. Naꞌari caí, nain pu jɨ́n tiraatévaɨreꞌesin ɨ́ seɨj, ajta aꞌɨ́ɨ pu caí raꞌaráꞌastijreꞌe ɨ́ seɨj tɨ tíꞌiraꞌaijteꞌe. Jɨ́meꞌen aꞌɨ́jna ɨ́ Dios, ajta jɨ́meꞌen aꞌɨ́jna ɨ́ tumin, capu jaꞌatɨ́ ayén raayɨ́ꞌɨtɨ tɨ tiuꞌutaꞌaíjtiꞌireꞌen ruxɨ́ꞌej naꞌa aꞌɨ́mej jemi ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe jɨ́meꞌen aꞌɨ́jna yee: Caxu seꞌɨ́jna jɨ́n tíꞌimuajca yee: “¿Aꞌiquí tetíꞌicuaꞌani?”, nusu yee: “¿Aꞌiquí tetíꞌiteyeꞌen?”, naꞌari yee: “¿Tiꞌitaqui jɨ́n tetiuꞌutétachejteꞌesin?” ¿Ni caí jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi sej ruuri xáꞌaraꞌani, caí ɨ́ cuaꞌira? ¿Ni caí ayén cheꞌatá naꞌa jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi áꞌamuahuaꞌiraꞌa tɨ ruuri, caí ɨ́ sej jɨ́n tiuꞌuteújchejteꞌen? A niꞌijtá neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","’Casiꞌi, hui sehuaꞌuseíj mɨ pinaꞌase ɨ́ mej júteꞌe ráꞌaraꞌa. Camu aꞌatzu tíꞌihuasteꞌe, camu majta tíꞌitzaꞌanaca, camu majta raseꞌɨri ɨ́ imueꞌeri ɨ́ ruchiꞌitá. Mɨ́ ajta, aꞌɨ́ɨ pu tihuáꞌamiꞌicuaca aꞌɨ́jna ɨ́ áꞌamuayaꞌupua aꞌuun tɨ éꞌeseijreꞌe u ta japua. Ajta jeíhua xu jaítzeꞌe jetzen ruxeꞌeveꞌe mecaí aꞌɨ́ɨme mɨ pinaꞌase. Aꞌɨ́ɨ pu rɨ́ꞌɨ tejáꞌamuachaꞌɨ́ɨ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Capu aꞌatzu tíꞌivaɨreꞌe tɨ jaꞌatɨ́ ayén áꞌucheꞌecaneꞌen ayén teꞌentímuaꞌastɨ́ aꞌɨ́jna jɨmeꞌe yee aꞌiquí téꞌeme. Capu aꞌatzu raatévaꞌɨri tɨ jaítzeꞌe áꞌateeviꞌin. ");
INSERT INTO crnNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Ajta, ¿aꞌiné ꞌeen jɨ́n siyen tíꞌitziɨɨneꞌe seꞌɨ́jna jɨmeꞌe yee tiꞌitájqui jɨ́n tetiuꞌutétachejteꞌesin? ’Casiꞌi múꞌeen, xaaseíj mɨ xuuxuꞌu aꞌij tɨ téꞌejvivausi mé jáꞌahuaꞌa tɨ huapáꞌatza. Capu tíꞌimɨjhuaca mɨ xuuxuꞌu, capu ajta tíꞌitzaca. ");
INSERT INTO crnNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe, aꞌɨ́jna ɨ́ rey, aꞌɨ́jna ɨ́ Salomón teecan, jéꞌecan pu huápɨꞌɨ tíꞌijchaꞌɨɨcaꞌa. Mɨ́ ajta, capu jaꞌanáj naa éeneꞌen tiuꞌuteújchejte tɨ́j mɨ xuuxuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","’Ayee puꞌu, Dios pu ayén naa éeneꞌen rɨ́ꞌɨ tíꞌiruure mɨ ɨxaj tɨ íjii aꞌuun éꞌeseijreꞌe aꞌúu tɨ aꞌupáꞌatza. Ajta áꞌiyen, aréꞌapuaꞌa rasijchen. Tɨ́ꞌɨj huatéehuan, aj mú mi raateátaiira chuej tzajtaꞌa táꞌajtaavijhua. Dios pu xaa jaítzeꞌe rɨ́ꞌɨ áꞌamuaruure caí aꞌɨ́jna tɨ rɨ́ꞌɨ ráaruu mɨ ɨxaj. Múꞌeen xu hui caí aꞌatzu téꞌatzaahuateꞌe xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe. Caxu siyen tíꞌimuajca seꞌɨ́jna jɨmeꞌe yee: “¿Tiꞌitájqui tecuaꞌani?”, nusu yee: “¿Tiꞌitájqui teyéꞌen?”, naꞌari yee: “¿Tiꞌitájqui jɨ́n tetiuꞌutétachejteꞌesin?” ");
INSERT INTO crnNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","’Aꞌɨ́ɨme ɨ́ mej caí ramuaꞌate ɨ́ Dios tzáahuatiꞌiraꞌa jɨmeꞌe, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej jɨ́n rahuauca. Mɨ́ ajta, aꞌɨ́ɨn ɨ́ áꞌamuayaꞌupua ta japua tɨ éꞌeseijreꞌe, aꞌɨ́ɨ pu ari ramuaꞌaree nain tɨ́j naꞌa ɨ́ tɨ tejamuáꞌaturaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ayee puꞌu, seuj miꞌi raatahuaún tɨ Dios tejamuaꞌaíjteꞌen, seajta sej raꞌaráꞌastijreꞌen aꞌij tɨ aꞌɨ́ɨn tíꞌijxeꞌeveꞌe. Tɨ́ puaꞌa siyen huárɨni, Dios pu ajta tejámuaatáꞌasin naíjmiꞌi aꞌíjna ɨ́ tɨ tejamuáꞌaturaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","’Ayej xaa neꞌu tiꞌayajna. Caxu tíꞌimuajca seꞌɨ́jna jɨmeꞌe yee aꞌiquí téꞌeme ruijmuaꞌa. Ruijmuaꞌa xu sijta tíꞌiteseꞌe xáꞌajuꞌun seꞌɨ́jna jɨmeꞌe ɨ́ tɨ tejáꞌamuacɨꞌɨti aꞌájna. Amɨ́ puꞌu aúcheꞌe ɨ́ sej jɨ́n tíꞌiteseꞌen íjii. ");
INSERT INTO crnNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Caxu chéꞌe senaꞌa seica jetze tíꞌijpuaꞌajteꞌe ɨ́ seɨ́j tɨ i caí Dios ayén múꞌejmi jetze teꞌujpuáꞌajteꞌen caꞌanín jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ayee puꞌu, setɨ́j siyen tíꞌijxajtziꞌira ɨ́ ruxɨ́ꞌej tevi, ayée pu cheꞌatá naꞌa Dios múꞌejmi tejáꞌamuaxajtziꞌi. Aꞌachú sej caj tiraatáꞌan ɨ́ seɨ́j, ayén cheꞌatá naꞌa tejáꞌamuacɨꞌɨti. ");
INSERT INTO crnNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Aꞌiné ꞌeen jɨ́n siyen rasiseꞌi áꞌamuaꞌihuaaraꞌa ɨ́ tɨꞌɨrí cɨ́lieen jɨ́n teꞌutéjturaa ɨ́ Dios jemi? Mɨ́ seajta múꞌeen caxu rusiseꞌij ɨ́ sej veꞌecán jɨ́n auteájturaa jemin ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ajta, tɨ puaꞌa peri veꞌecán jɨ́n auteájturaa ɨ́ Dios jemi, ¿aꞌiné tíꞌirɨꞌɨri pej piyen tiraatáꞌixaateꞌen pemɨ́jna tɨ cɨ́lieen jɨ́n aꞌuteájturaa aꞌij tɨ tiꞌitɨ́j jɨ́n teꞌuteájturaa? ");
INSERT INTO crnNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Múꞌee, ɨ́ pej caí piyen mé teuúmuaꞌaree, pauj miꞌi nain jɨ́n tiuꞌutetzáahuateꞌen aꞌɨ́mej jemi ɨ́ pej jɨ́n auteájturaa. Aj pu xaa raavíiteꞌe aꞌame pej piyen tiraataꞌixaateꞌen ɨ́ seɨj aꞌij tɨ tiꞌitɨ́j jɨ́n teꞌuteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Caxu siyen tihuáꞌixaateꞌe ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios huáꞌa tzajtaꞌa aꞌɨ́mej ɨ́ mej tiúꞌuxanaꞌaviꞌisteꞌe mej mi caí áꞌamuaxɨeehuariꞌira matɨ́j ɨ́ tzɨꞌɨcɨ mej tiúꞌucheꞌeveca. Ajta caxu siyen tihuáꞌijcateꞌe ɨ́ tɨ Dios jemi éꞌemeꞌecan aꞌɨ́mej ɨ́ mej caí tíꞌiteviꞌiraꞌa. Naꞌari caí, ayée mú rɨni matɨ́j ɨ́ tuiixu ɨ́ xarij tzajtaꞌa aꞌutɨ́ jéꞌejmuaa. Aꞌij mú puaꞌa tejámuaataxájta, mej núꞌu amuajchaꞌɨ́ɨreꞌe mú muáꞌajuꞌun huápɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Setáꞌaj siyen seuj rahuauca ɨ́ Dios jemi, aꞌiné aꞌɨ́ɨ pu tejámuaatáꞌasin. Tɨ́ puaꞌa siyen rahuauca ɨ́ jemin, aj xu xaa ráateuni jemin ɨ́ Dios. Seucheꞌe seajta teꞌejteátuꞌasixɨꞌɨn ɨ́ puéerta jetze. Dios pu xaa teꞌantácuuna, amuaatáꞌasin ɨ́ sej jɨ́meꞌen rahuauhuau. ");
INSERT INTO crnNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ayee pu téꞌeme aꞌiné tɨ puaꞌa jaꞌatɨ́ ayén tíꞌijhuauca, aꞌɨ́ɨ pu ajta raꞌancuréꞌasin. Tɨ́ puaꞌa jaꞌatɨ́ tiꞌitɨ́j huauca, aꞌɨ́ɨ pu ráateuni. Ajta tɨ puaꞌa jaꞌatɨ́ ayén teꞌejteátuꞌasixɨꞌɨn táꞌapueerta, Dios pu xaa teꞌantácuuna. ");
INSERT INTO crnNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? Tɨ́ puaꞌa muáꞌayauj ayén tíꞌimuahuaviira ɨ́ pan pej raataꞌɨ́ꞌɨteꞌen, ¿ni mɨ tetej paraatátɨstejsin? Capej xaa neꞌu tetej raatátɨstejsin sino pan pej raataꞌɨ́ꞌɨteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naꞌari, tɨ puaꞌa ayén tíꞌimuahuaviira pej huaꞌité raatáꞌan, ¿ni qui cuꞌucuꞌu paraatapíjteꞌesin? Capej xaa neꞌu cuꞌucuꞌu raatapíjteꞌesin sino huaꞌité pej raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","’Jee sein, ayej tiꞌayajna, múꞌeen xu caí urarɨ́ꞌen ɨ́ ru tzajtaꞌa. Mɨ́ seajta múꞌeen, seúcheꞌe xu ramuaꞌaree aꞌij sej yeꞌí huárɨni sej si huaꞌutapuaíjveꞌen ɨ́ ruyaujmuaꞌa tiꞌitɨ́j tɨ iꞌirɨ́ꞌen. Ajta ɨ́ áꞌamuaꞌiyaꞌupua, jeíhua pu jaítzeꞌe huaꞌutáꞌasin ɨ́ tɨ tiꞌirɨ́ꞌeen aꞌɨ́mej ɨ́ mej rahuaviira muáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Aꞌɨ́j xu jɨ́n siyen huárɨni nain jɨmeꞌe. Setáꞌaj siyen cheꞌatá senaꞌa huáꞌuruuren ɨ́ ruxɨ́ꞌej teɨte aꞌij sej tíꞌijxeꞌeveꞌe mej miyen amuáaruuren múꞌejmi. Ayee pu huataújmuaꞌa nain tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze Moisés tɨ raꞌuyúꞌuxacaꞌa, ajta ɨ́ seica jetze ɨ́ mej raꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Sej si eꞌaráꞌasti aꞌúu tɨ Dios éꞌeseijreꞌe, ayée xu huárɨni. Aꞌuun xu aꞌuteárute ɨ́ puéerta jetze tɨ cɨ́j antéeyauj. Jee xaa, seɨ́j pu seijreꞌe ɨ́ puéerta tɨ antéeyauj. Aꞌuu pu pújmeꞌen eꞌenténineꞌi ɨ́ juye tɨ ajta auuyaúj. Muꞌiitɨ́ mú meꞌuun aꞌuteáruꞌipi, majta aꞌɨ́j mú japuan cɨɨne ɨ́ juye tɨ auuyaúj. Matɨ́ꞌɨj meꞌuun aꞌuréꞌenen aꞌu tɨ aupuáꞌari, naímiꞌi mú jéꞌe huaújpuaꞌarixɨꞌɨsin, micu. Miyáꞌujɨsin ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mɨ́ ajta ɨ́ seɨ́j ɨ́ puéerta, aꞌɨ́ɨ pu hui cɨ́j antéeyauj, ajta aꞌɨ́ɨn ɨ́ juye tɨ aꞌuun eꞌenténineꞌi, cɨ́j pu auuyaúj. Ajta jéꞌecan pu muárɨꞌeri tɨ jaꞌatɨ́ japuan huaméꞌen tɨ ij aꞌuun eꞌaráꞌasti Dios tɨ éꞌeseijreꞌe tɨ ij ruurican aꞌuteáturan ɨ́ Dios jemi. Ajta, camu muꞌíi ɨ́ mej miyen tíꞌirateuni. ");
INSERT INTO crnNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Rɨ́ꞌɨ xuꞌu, múꞌeen, huáꞌa jemi ɨ́ mej tíꞌihuaꞌitaca. Ayee mú tíꞌixaxaꞌa tɨjɨ́n: “Dios jetze meꞌecan tu hui tíꞌixaxaꞌa.” Mé mú veꞌeréꞌene mé muáꞌacanta. Ayee mú áꞌujujhuaꞌan aꞌamua tzajtaꞌa. Cu xɨee mé caí tiꞌitɨ́j aꞌij ruure. Mɨ́ ajta, capu ayén tiꞌayajna. Jee xaa neꞌu ayén tiꞌayajna. Ayee mú ꞌeen matɨ́j ɨ́ ɨ́ɨraꞌavete ɨ́ mej tíꞌitecuiꞌica. Jéꞌecan mú tihuáꞌariꞌiraca ɨ́ teɨte ɨ́ tihuaꞌáa. Majta huáꞌacuanamuáj. ");
INSERT INTO crnNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Rɨꞌɨrí sej si siyen tihuáꞌumuaꞌati seꞌɨ́jna jɨmeꞌe aꞌij mej yeꞌí rɨcɨ. Ayee xu cheꞌatá senaꞌa tihuáꞌumuaꞌati setɨ́j tíꞌijmuaꞌate seɨ́j ɨ́ cɨyej tɨ puaꞌa caí rɨꞌéeneꞌen tacaꞌa. Casiꞌi, jetzen aꞌɨ́jna ɨ́ tɨ tétzicareꞌe, capu aꞌɨ́jna jetze taaca ɨ́ uuva; capu ajta aꞌɨ́jna jetze tacaꞌa ɨ́ huaréj, jetzen aꞌɨ́jna ɨ́ cɨyej tɨ tétzicareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","’Ayee pu tíꞌeen, nain ɨ́ cɨyej tɨ tiꞌirɨ́ꞌeen, rɨꞌéeneꞌen pu tíꞌitacaꞌa. Ajta, nain ɨ́ cɨyej tɨ caí tiꞌirɨ́ꞌeen, capu ajta rɨꞌéeneꞌen tíꞌitacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Capu aꞌatzu aꞌij tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn cɨyej tɨ tiꞌirɨ́ꞌeen, ayén tacaꞌa aꞌɨ́jna tɨ caí rɨ́ꞌen. Ajta, jɨ́meꞌen aꞌɨ́jna ɨ́ cɨyej tɨ caí rɨ́ꞌen, capu ajta íꞌirɨꞌɨri tɨ rɨꞌéeneꞌen tiuꞌutácaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mɨ́ ajta aꞌɨ́ɨme ɨ́ teɨte, ayée mú ꞌeen tɨ́j ɨ́ cɨyej tɨ caí tiꞌirɨ́ꞌeen. Dios pu ayén cheꞌatá naꞌa huáꞌaruuren matɨ́j ɨ́ teɨte miyen tíꞌiruure ɨ́ cɨyej tɨ caí rɨ́ꞌen. Aꞌɨ́ɨ mú téꞌijveichixɨꞌɨsin, majta raꞌanteátaira. ");
INSERT INTO crnNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe tɨjɨ́n: Ayee xu ꞌéeniꞌicɨꞌe huáꞌumuaꞌati seꞌɨ́jna jɨmeꞌe aꞌij mej yeꞌí rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Mɨ́ majta meꞌɨ́n ɨ́ mej miyen tíꞌinejee tɨjɨ́n: “Nevástaraꞌa, casiꞌi nevástaraꞌa”, camu naímiꞌi meꞌuun aꞌuteáruti aꞌu tɨ tejéꞌaijta ɨ́ Dios. Aꞌii muꞌu meꞌuun aꞌuteáruti ɨ́ mej miyen rɨcɨ aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ayee pu téꞌeme aꞌájna xɨcájraꞌa jetze tɨ́ꞌɨj Dios ayén huáꞌaxɨjteꞌen ɨ́ teɨte. Muꞌiitɨ́ mú miyen tinaatáꞌixaateꞌesin meꞌɨ́jna jɨmeꞌe yee: “Nevástaraꞌa, casiꞌi nevástaraꞌa, teen tu tiuꞌutaxájtacaꞌa aniúucajtzeꞌen tetɨ́ꞌɨj teuj ruurica. Teajta aniúucajtzeꞌen jɨ́n huaꞌutamuári ɨ́ tiyaaruꞌu mej huáꞌa tzajtaꞌa seijreꞌecaꞌa. Ayee tu cheꞌatá tenaꞌa, jeíhua tiuꞌumuárɨej teꞌɨ́jna jɨmeꞌe tej múꞌeetzi jetzen arátacaꞌanejcaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","’Mɨ́ neajta inee, ayée nu hui tihuaꞌutáꞌixaateꞌesin tɨjɨ́n: “Canu jaꞌanáj amuaamuáꞌa aꞌatéenni sej púꞌeen. Caxu aꞌatzu neteɨ́testemuaꞌa púꞌeen. Sericu, sej hui iiyecuí inee jemi, mɨ sej aꞌij puaꞌa rɨcɨ.” ");
INSERT INTO crnNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Aꞌɨ́j pu jɨ́n, jaꞌatɨ́ tɨ naꞌa tɨ ayén nenamua, ajta tɨ ayén raꞌaráꞌastijreꞌe aꞌij nej tíꞌixaxaꞌa, ayée pu hui cheꞌatá naꞌa mé teuúmuaꞌaree tɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huateújchiꞌite tetej japua. ");
INSERT INTO crnNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Aj mú mi huatéviiyecaꞌa. Ajta cámɨꞌɨyixɨ ɨ́ jaj. Ajta huatáꞌeecarecaꞌa. Ajta aꞌɨ́ɨn ɨ́ chiꞌiraꞌan, capu áꞌave aꞌiné tetej japua pu ráꞌajtaahuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mɨ́ ajta, aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén nenamua, ajta capu ayén raꞌaráꞌastijreꞌe aꞌij nej tíꞌixaxaꞌa, ayée pu cheꞌatá naꞌa ꞌeen tɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí tiꞌitɨ́j muaꞌaree. Aꞌɨ́jna ɨ́ jaꞌatɨ huateújchiꞌite aꞌu tɨ áꞌuseaataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Aj mú mi huatéviiyecaꞌa. Ajta cámɨꞌɨyixɨ ɨ́ jaj. Ajta huatáꞌeecarecaꞌa. Caꞌanacan pu áꞌave ɨ́ chiꞌiraꞌan. Jéꞌecan pu yáꞌurɨe aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huateújchiꞌite aꞌu tɨ áꞌuseaataꞌa. Ayee pu cheꞌatá naꞌa tíꞌijruuren ɨ́ jaꞌatɨ tɨ caí raꞌaráꞌastijreꞌe aꞌij nej tíꞌixaxaꞌa. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Tɨ́ꞌɨj Jesús raꞌantipuáꞌajte tɨ tihuaꞌutáꞌixaa, jeíhua mú huajɨ́jxɨcaꞌa meꞌɨ́jna jɨmeꞌe aꞌij tɨ tihuaꞌumuáꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Capu chaꞌa naꞌa tihuaꞌumuáꞌate matɨ́j ɨ́ seica ɨ́ mej tihuáꞌamuaꞌatehuaꞌa ɨ́ yuꞌuxari jetze, sino ayée puꞌu cumu seɨ́j tɨ tiꞌitéjvee tiꞌitɨ́j jɨmeꞌe tɨ veꞌée. ");
INSERT INTO crnNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tɨ́ꞌɨj acájraa ɨ́ Jesús jɨrí jetze, jeíhua mú teɨte aꞌucɨ́j jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tɨꞌɨj jí seɨ́j aveꞌeréꞌene ɨ́ Jesús jemi. Tíꞌicuiꞌicaa aꞌɨ́jna jɨmeꞌe tɨ tinéj ɨ́ ꞌatzaj huáꞌireꞌaraꞌan jetze. Ayee mú ratamuáꞌamua tɨjɨ́n lepra. Tɨ́ꞌɨj i aꞌɨ́ɨn títunutacaꞌa jemin ɨ́ Jesús. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa hui muaꞌaráanajche pej tináahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Aj pu i Jesús raꞌajtamuárɨej. Ayen tɨjɨ́n: ―Naꞌaráanajche pej huarún. Jɨ́meꞌen puꞌu ayén raataxájtacaꞌa, aj pu i tiraacáꞌariꞌiriꞌi ɨ́ tɨ jɨ́meꞌen tíꞌicuiꞌicaa. Tɨꞌɨj jí huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Casiꞌi, capej jaꞌatɨ́ ixaateꞌe sino aricu, aꞌɨ́jna jemi tɨ tíꞌivaꞌɨri teyujtaꞌa. Chéꞌe muaaseíj. Pajta tiuꞌutámuaɨꞌɨvejta aꞌij tɨ tiuꞌuxájtacaꞌa ɨ́ Moises teecan. Ayee mú éeniꞌicɨꞌe ramuaꞌaréeren tɨjɨ́n pepuꞌuri huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Aj pu i Jesús aꞌuteájrupi aꞌujna Capernaúm. Tɨ́ꞌɨj aꞌuun aꞌuteájrupi, seɨ́j pu u aꞌuvéꞌemej tɨ iꞌi xantaaruꞌu. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ anxɨ́te tíꞌaijta. Jéꞌecan pu rájhuaviiriꞌi aꞌɨ́jna ɨ́ jaꞌatɨ. Ayen tɨjɨ́n: ―Nevástaraꞌa, jéꞌecan pu tíꞌicuiꞌi aꞌɨ́jna tɨ nevaɨreꞌe. An pu aꞌujcáꞌa ɨ́ utaatzi japua. Cɨyáaxaraꞌa. Nainjapua pu racuiꞌi huápɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Née nu xaa aꞌuméꞌe naꞌame nej ni tiráahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Aj pu i ayén tiuꞌutaniú aꞌɨ́jna tɨ anxɨ́te tíꞌaijta tɨjɨ́n: ―Nevástaꞌaraꞌa, capu ayén muaavíjteꞌe pej piyen uteárute u niche, aꞌiné canu Israél jetze ajtémeꞌecan. Ayee pepuꞌu huárɨni, patáꞌaj piyen tiraataxáj ɨ́ niuucari jɨmeꞌe. Aj pu xaa rujni aꞌɨ́jna tɨ nevaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ayee nu tíꞌimuaꞌixaateꞌe neꞌɨ́jna jɨmeꞌe ɨ́ mej seica tíꞌineꞌaijteꞌe ineetzi. Neajta inee, nee nu seica tíꞌaijteꞌe. Tɨ́ puaꞌa niyen tiraataꞌixaateꞌen seɨ́j tɨjɨ́n: “Aricu, u páꞌumeꞌen”, aꞌɨ́ɨ pu xaa aꞌuméꞌe aꞌame. Naꞌari, tɨ puaꞌa niyen tiraataꞌixaateꞌen ɨ́ seɨj tɨjɨ́n: “Yé véꞌexɨjriꞌi”, aꞌɨ́ɨ pu ajta yé veꞌeréꞌenejsin. Neajta niyen tiraataꞌaíjteꞌesin ɨ́ tɨ nevaɨreꞌe tɨjɨ́n: “Aisí múꞌee, pɨ́ huarɨ́chi.” Ajta aꞌɨ́ɨn, ayée pu rɨni. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ xantaaruꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tɨ́ꞌɨj Jesús ráanamuajriꞌi, jéꞌecan pu huataújtemuaꞌave. Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej ráꞌajaahuateꞌe tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Huáꞌa tzajtaꞌa ɨ́ teɨte ayujna mej huachéjme tɨ́j naꞌa tɨ huatacáꞌa íiyu Israél, canu jaꞌanáj seɨ́j huatéꞌuu íiyu Israél, jaꞌatɨ́ tɨ ayén cheꞌatá naꞌa téꞌatzaahuateꞌe tɨ́j aꞌíjna i teáataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Neajta niyen tejáꞌamuaꞌixaateꞌe, aꞌɨ́jna jɨmeꞌe yee jeíhua mú u aꞌuvéꞌejuꞌu muáꞌajuꞌun mej mi aꞌujráꞌase meꞌɨ́jna jamuan ɨ́ Abraham teecan, majta meꞌɨ́jna ɨ́ Isaac teecan, majta meꞌɨ́jna jamuan ɨ́ Jacobo teecan. Aꞌuu mú hui aꞌuvéꞌejuꞌu muáꞌajuꞌun aꞌu tɨ xɨcaj ꞌeíjninei, majta aꞌu tɨ xɨcaj eꞌeteáruꞌipi. Aj mú mi tíꞌicuaꞌani huáꞌa jamuan ɨ́ mé huaíca tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna xɨcájraꞌa jetze tɨ Dios nain jɨ́n tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mɨ́ majta aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan, Dios pu huaꞌiráꞌiti á puaꞌacɨé aꞌu tɨ aꞌutɨ́caꞌa. Jéihua mú huateujyéineajraꞌasin, majta jeíhua mú ancuréꞌujcɨꞌɨmée muáꞌajuꞌun ɨ́ rutamej jɨmeꞌe aꞌɨ́jna jɨmeꞌe mej jeíhua rajpuaíitzi. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Aj Jesús ayén tiraatáꞌixaa aꞌɨ́jna tɨ anxɨ́te tíꞌaijta tɨjɨ́n: ―Aricu, ayée pu téꞌeme patɨ́j peri téꞌantzaahua. Jɨ́meꞌen puꞌu ayén tiraatáꞌixaa, aj pu i huarúj aꞌɨ́jna tɨ tíꞌivaɨreꞌe aꞌɨ́jna jemi ɨ́ xantaaruꞌu. Tɨꞌɨj jí áꞌuraa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Aj pu i Jesús aꞌuun aꞌaráꞌa Pedro tɨ éꞌeche. Aꞌuu pu i aꞌɨ́ɨn huaseíj aꞌɨ́jna ɨ́ muꞌuneáraꞌan ɨ́ Pedro. An pu jáꞌujcaꞌatii ɨ́ utaatzi japua. Tíꞌicuiꞌicaa. Pɨ́stacaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aj pu i Jesús rajvíꞌi muájcaꞌareꞌaraꞌan jetze. Jɨ́meꞌen pu ayén huarɨ́j, aj puꞌi huarúj. Ajta aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu ájchee. Ajta áꞌiyen aꞌutéjche tɨ tiraamí. ");
INSERT INTO crnNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tɨ́ꞌɨj huateátɨcaꞌarecaꞌa, jeíhua mú huajeꞌeráaviꞌitɨ Jesús jemi aꞌɨ́mej ɨ́ mej tiyaaruꞌu huáꞌa tzajtaꞌa seijreꞌecaꞌa. Aꞌɨ́ɨ pu huaꞌutaꞌaíj aꞌɨ́mej ɨ́ tiyáaruꞌuse mej nuꞌu huirácɨɨne ɨ́ teɨte tzajtaꞌa. Ajta naíjmiꞌica pu tiúꞌuhuaa ɨ́ mej tíꞌicucuiꞌicaa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ayee pu tiujuꞌurɨ́j tɨ ij araúrasten aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Isaías, ɨ́ tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayen tɨjɨ́n: “Aꞌɨ́ɨ pu titáꞌariꞌiriꞌi aꞌɨ́jna ɨ́ tɨ jɨ́n caí chéꞌe túꞌucaꞌanistiꞌiracaꞌa. Ajta aꞌɨ́ɨ pu yáꞌutɨɨ ɨ́ tej jɨ́n tíꞌicucuiꞌicaa.” ");
INSERT INTO crnNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tɨ́ꞌɨj Jesús huaꞌuseíj ɨ́ teɨte ɨ́ mej jeíhua ajteáxɨɨrecaꞌa ɨ́ jemin, aj pu i ayén tíhuaꞌutaꞌaíjte mej nuꞌu antácɨɨne antavén pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Aj pu i seɨ́j tɨ tiújmuaꞌate ɨ́ yuꞌuxari jetze, aꞌɨ́ɨ pu aveꞌeréꞌene jemin ɨ́ Jesús. Ayee pu tirájhuaviiriꞌi tɨjɨ́n: ―Maestru, nichéꞌe á jamuan áꞌucheꞌecaneꞌen aꞌu tɨ naꞌa pej aꞌuméꞌe puaꞌamé. ");
INSERT INTO crnNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Canu muꞌu aꞌuméꞌe naꞌame. Aꞌɨ́ɨme ɨ́ arachuíjse, aꞌúu mú hui uꞌuche cuunístaꞌa, majta aꞌɨ́ɨme ɨ́ pinaꞌase aꞌúu mú tiꞌitítuꞌa aꞌu mej éꞌeꞌaseca. Mɨ́ neajta inee, i nej neajta teáataꞌa jetze airáane, canu aꞌatzu huatéechiꞌi ɨ́ nej tzajtaꞌan huácuti. ―Ayee pu tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ajta seɨ́j tɨ áꞌucheꞌecaneꞌe jamuan, aꞌɨ́ɨ pu ayén rájhuaviiriꞌi tɨjɨ́n: ―Nevástaraꞌa, nichéꞌe yé huácatii íiye niche asta naꞌa caí huámɨꞌɨni ɨ́ nitáàta. Netɨ́ꞌɨj raꞌavaꞌanán, aj nu ni yé veꞌeréꞌenejsin nej ni áꞌucheꞌecaneꞌen á jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ayee pu tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Micheꞌe mɨ seica raꞌaváꞌanan ɨ́ huaꞌaxɨ́ꞌej mɨꞌɨchi aꞌɨ́ɨme ɨ́ mej caí ramuaꞌate ɨ́ Dios. Mɨ́ pajta múꞌee, patáꞌaj caꞌanacan yé veꞌeréꞌenen. ");
INSERT INTO crnNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Aj puꞌi Jesús ateájraa ɨ́ baarcu jetze, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Aj pu i temuaꞌa caꞌanín jɨ́n tiuꞌutáꞌeecarecaꞌa ɨ́ jaj japua. Jéꞌecan puꞌi tiújtaꞌahuaꞌa vivejméꞌe. Tɨꞌɨj jí ateáxɨɨreꞌaxɨ ɨ́ baarcu jetze. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu íꞌicujcaa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Majta meꞌɨ́n ɨ́ mej áꞌujujhuaꞌaneꞌe jamuan, aꞌɨ́ɨ mú aveꞌeréꞌene jemin. Aj mú mi raajɨ́ste. Miyen tɨjɨ́n: ―¡Maeestru, ta japua huániuuchi! ¡Tuꞌuri hui cuiꞌini! ");
INSERT INTO crnNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Aj puꞌi ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Mɨ́ sej caí aꞌatzu téꞌatzaahuateꞌe, ¿aꞌiné sej si huápɨꞌɨ tíꞌitziɨɨneꞌe? Aj pu i ájchee. Tɨꞌɨj jí huaꞌutáꞌijmɨijriꞌi ɨ́ eeca, ajta ɨ́ jaj. Aj pu i huatéepuaꞌaj ɨ́ eeca, ajta aꞌureújéꞌiye jáꞌaraa ɨ́ jaj, temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jéꞌecan mú aꞌij raꞌutaseíj aꞌɨ́ɨme ɨ́ teteca. Ayee mú tíꞌiruꞌihuaꞌuracaꞌa tɨjɨ́n: ―¿Tiꞌitáani téviraꞌa púꞌeen amɨ́jna? Amɨ́ pu tihuáꞌaijteꞌe ɨ́ eeca, ajta ɨ́ jaj. Majta mú hui ráꞌaste. ");
INSERT INTO crnNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tɨ́ꞌɨj táꞌi Jesús aꞌuun aꞌaráꞌa utavén pújmeꞌen jáꞌahuaꞌa Gadara tɨ ajtémeꞌecan. Matɨ́ꞌɨj mi aitacɨ́j ɨ́ baarcu jetze. Aj mú mi seica huaꞌantinájchecaꞌa. Ma huaꞌapua aꞌɨ́ɨme. Aꞌuu mú eꞌeráacɨ aꞌu mej mɨꞌɨchite éꞌenaamuaca. Tiyáaruꞌuse pu huáꞌa tzajtaꞌa seijreꞌecaꞌa. Jéihua mú simuáruunicaꞌa. Aꞌɨ́j pu jɨ́n caí rɨꞌɨríistacaꞌa tɨ jaꞌatɨ́ aꞌuréꞌenen aꞌujna juye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Matɨ́ꞌɨj mi miyen titeejíjhuacaꞌa. Miyen tɨjɨ́n: ―¿Aꞌiné hui tiꞌitɨ́j peteáruuren itejmi jemi, Jesús, pej iꞌi yaujraꞌan ɨ́ Dios? ¿Ni piyen mú aꞌuvéꞌemej pej pi puaíjtzi taatáꞌan? Aru capu xɨ tejaꞌuréꞌene aꞌájna xɨcájraꞌa tej jetzen rajpuaíitzi táꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Majta aꞌɨmuá seica huatéꞌuu ɨ́ tuiixute. Mé muꞌíi. A mú áꞌujujhuaꞌan meteꞌenticuáa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Matɨ́ꞌɨj mi meꞌɨ́n ɨ́ tiyáaruꞌuse tɨ huáꞌa tzajtaꞌa seijreꞌecaꞌa, aꞌɨ́ɨ mú miyen rájhuaviiriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Tɨ́ puaꞌa piyen titaatamuáriteꞌen itejmi, taataꞌítechi itejmi aꞌu mej aꞌutéꞌuu mɨ tuiixu. ");
INSERT INTO crnNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu. Matɨ́ꞌɨj mi huiráacɨ. Aj mú mi huáꞌa tzajtaꞌa aꞌuteájrupi ɨ́ tuiixute. Majta meꞌɨ́n ɨ́ tuiixu, matɨ́ꞌɨj mi huataúruu aꞌuun pújmeꞌen játeꞌana tɨ aꞌatamɨ́ꞌɨye. Matɨ́ꞌɨjtá mi atéavatzɨ á jaataꞌa. Aj mú mi aujámɨ naíjmiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Majta meꞌɨ́n ɨ́ mej tuiixu chaꞌɨɨcaꞌa, aꞌɨ́ɨ mú huataúruu. Matɨ́ꞌɨj mi meꞌuun aꞌucɨ́j chajtaꞌa mej mi tiuꞌutaxáj. Aꞌɨ́j mú huaꞌutáꞌixa aꞌij tɨ tiꞌitɨ́j huáꞌuruu ɨ́ tuiixu, majta aꞌij tɨ tiꞌitɨ́j huáꞌuruu aꞌɨ́mej ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Matɨ́ꞌɨj mi aꞌɨ́ɨme aꞌuun mej huachéjmeꞌecaa aꞌujna, naímiꞌi mú aveꞌeréꞌene ɨ́ Jesús jemi mej mi jamuan tiuꞌuxáj. Matɨ́ꞌɨj raaseíj, jeíhua mú rájhuaviiriꞌi meꞌɨ́jna ɨ́ Jesús tɨ nuꞌu áꞌuraꞌani u jáꞌahuaꞌa yee. ");
INSERT INTO crnNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aj pu i Jesús ateájraa ɨ́ baarcu jetze. Aj mú mi antacɨ́j után pújmeꞌen. Tɨꞌɨj jí aꞌuun aꞌaráꞌa aꞌujna chajtaꞌa aꞌu tɨ éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Majta meꞌɨ́n ɨ́ seica, aꞌɨ́ɨ mú jaꞌatɨ́ aveꞌeréꞌeneijte ɨ́ Jesús jemi seɨ́j tɨ cɨyáaxaraꞌacaꞌa. Aꞌɨ́j pu jáꞌujcaꞌatii ɨ́ utaatzi aꞌɨ́jna ɨ́ jaꞌatɨ. Tɨ́ꞌɨj Jesús huaꞌuseíj aꞌɨ́mej ɨ́ teɨte, aj pu xaa ráamuaꞌareeriꞌi tɨjɨ́n metéꞌatzaahuateꞌe aꞌɨ́ɨme. Aj puꞌi ayén tiraatáꞌixaa aꞌɨ́jna tɨ tíꞌicuiꞌi tɨjɨ́n: ―Niyauj, uhuateáꞌacaꞌane ɨ́ áꞌa tzajtaꞌa. Puꞌuri timuaatáꞌuuniꞌiriꞌi ɨ́ Dios ɨ́ pej jɨ́n auteájturaa ɨ́ jemin. ―Ayee pu tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Majta á vejliꞌi huiiráteꞌecaꞌa seica ɨ́ mej téꞌeyuꞌuxaca ɨ́ ruyeꞌirá jɨmeꞌe. Matɨ́ꞌɨj mi miyen tiuꞌumuáꞌaj ɨ́ ru tzajtaꞌa tɨjɨ́n: “Amɨ́ pu aꞌij puaꞌa tiratáꞌaca ɨ́ Dios ɨ́ runiuuca jɨmeꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ajta Jesús, aꞌɨ́ɨ pu ruseɨ́j rúꞌumuaꞌareerecaꞌa aꞌij mej yeꞌí téꞌumuaꞌatzejcaꞌa ɨ́ ru tzajtaꞌa. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n siyen aꞌij puaꞌa téꞌumuaꞌatze ɨ́ ru tzajtaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tiꞌitáani caí jaítzeꞌe muárɨꞌeri, ni nej niyen tiraatáꞌixaateꞌen ɨ́ tɨ cɨyáaxaraꞌa yee: “Puꞌuri timuaatáꞌuuniꞌiriꞌi ɨ́ Dios ɨ́ pej jɨ́n auteájturaa ɨ́ jemin”, naꞌari yee: “Ájchesi, ajta anchuée muaꞌa utaatzi?” ");
INSERT INTO crnNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","’Aru, ayée nu hui rɨni sej si ráamuaꞌaree ɨ́ nej neajta ɨ́ teáataꞌa jetze airáane, nee nu xaa neꞌɨ́jna jɨ́n antínmuaꞌaree íiyen chaanaca japua nej ni tihuaꞌutáꞌuuniꞌi ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi. Aj pu i ayén tiraatáꞌixaa ɨ́ tɨ cɨyáaxaraꞌa tɨjɨ́n: ―Ájchesi, tipíi muaꞌa utaatzi. Aricu áꞌuraꞌa aꞌu pe éꞌeche. ");
INSERT INTO crnNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa ɨ́ Jesús, aj puꞌi ájchee aꞌɨ́jna tɨ tíꞌicuiꞌicaa. Tɨ́ꞌɨj i áꞌuraa u ruche. ");
INSERT INTO crnNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Majta meꞌɨ́n ɨ́ teɨte, matɨ́ꞌɨj tiuꞌuséij aꞌij tɨ tiꞌitɨ́ huarɨ́j, jéꞌecan mú huataújtemuaꞌave. Rɨ́ꞌɨ mú tiraatajé ɨ́ Dios, meꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn Dios ari raatáꞌa aꞌɨ́jna ɨ́ muárɨꞌeriꞌiraꞌa ɨ́ mej jɨ́n miyen rɨcɨ ɨ́ teteca. ");
INSERT INTO crnNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aj pu i Jesús áꞌuraa. Tɨꞌɨj jí áꞌayee aꞌuréꞌene tɨ́ꞌɨj aꞌɨ́ɨn huaseíj aꞌɨ́jna ɨ́ jaꞌatɨ, Mateo tɨ ántehuaa. Aꞌuu pu huiracatii chiꞌita mej tzajtaꞌan huáꞌajijveꞌecaꞌa ɨ́ mej tíꞌitɨꞌɨcɨca. Aj pu i ayén tiraatáꞌixaa tɨjɨ́n: ―Patáꞌaj ne jamuan áꞌucheꞌecaneꞌen. Ajta áꞌiyen, Mateo ájchee. Tɨꞌɨj jí áꞌuraa jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tɨꞌɨj jí ayén tiujuꞌurɨ́j. Matɨ́ꞌɨj meꞌuun aꞌaráꞌa aꞌutɨ́ Mateo eꞌechéjmeꞌe. Tɨ́ꞌɨj Jesús tíꞌicuaꞌacaa, matɨ́ꞌɨj mi u aꞌuvéꞌejuꞌu jeíhua ɨ́ mej tíꞌitejijveꞌe, majta seica ɨ́ mej miyen cheꞌatá menaꞌa aꞌij puaꞌa tíꞌiteteɨte. Naíjmiꞌi mú tíꞌicuaꞌacaa ɨ́ meesa japua jamuan ɨ́ Jesús, majta jamuan aꞌɨ́mej ɨ́ mej áꞌujujhuaꞌaneꞌe ɨ́ Jesús jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Majta meꞌɨ́n ɨ́ fariseos, aꞌɨ́ɨme ɨ́ mej jeíhua huápɨꞌɨ raxɨ́ꞌeveꞌe ɨ́ ruyeꞌirá, matɨ́ꞌɨj miyen raaseíj aꞌij tɨ rɨjcaa ɨ́ Jesús, ayée mú tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Miyen tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n amɨ́n aꞌamua maestro tíꞌicuaꞌaca, ajta yeꞌeca huáꞌa jamuan ɨ́ mej huáꞌajijveꞌe ɨ́ mej tíꞌitɨꞌɨcɨca, ajta jamuan ɨ́ mej caí xɨ́ꞌepɨꞌɨn titetiújchaꞌɨɨ? ");
INSERT INTO crnNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tɨ́ꞌɨj ayén tiúꞌunamuajriꞌi ɨ́ Jesús, aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́mej jɨmeꞌe ɨ́ teɨte ɨ́ mej aꞌucɨ́ꞌɨcaꞌa jemin tɨ yaꞌanaca, capu ruxeꞌeveꞌe mej u áꞌujuꞌun ɨ́ mej rɨ́ꞌen aꞌɨ́jna jemi ɨ́ tɨ yaꞌanaca, sino aꞌɨ́ɨ mú xaa aꞌuréꞌenineꞌi ɨ́ tɨ yaꞌanaca jemi ɨ́ mej tíꞌicucuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sericu, setáꞌaj tihuaújmuaꞌaten seꞌɨ́jna jɨmeꞌe sej si yaúꞌitɨee xáꞌaraꞌani aꞌij tɨ huataújmuaꞌa aꞌíjna i niuucari aꞌɨ́jna jɨmeꞌe mej raxɨ́ꞌeveꞌe mej mi áꞌujcuꞌuve rujɨ́ɨmuaꞌa. Mɨ́ neajta, canu aꞌatzu raxɨ́ꞌeveꞌe mej tiuꞌutámuaɨꞌɨvejta. Ayee pu cheꞌatá naꞌa ꞌeen ineetzi jemi, canu neꞌɨ́jna jɨ́n yé véꞌeme nej aꞌɨ́mej huatáꞌinen ɨ́ tɨ ayén tihuáꞌamitɨejteꞌe mej xɨ́ꞌepɨꞌɨn rɨcɨ sino aꞌɨ́mej ɨ́ mej miyen tirúꞌumuaꞌaree ɨ́ ru tzajtaꞌa ɨ́ mej caí xɨ́ꞌepɨꞌɨn rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Matɨ́ꞌɨj mi seica aveꞌeréꞌene. Aꞌɨ́ɨme mú aꞌɨ́ɨn púꞌeen ɨ́ mej Juan jamuan áꞌujujhuaꞌaneꞌe. Aꞌɨ́ɨ mú aveꞌeréꞌene ɨ́ Jesús jemi. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n tiyen tíꞌitaꞌitziꞌiveꞌe iteen, majta aꞌɨ́ɨme ɨ́ fariseos? Aru ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan, camu hui miyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús, tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ huaténeɨche, aj pu i ruꞌamiigustemuaꞌa huatáꞌineesin mej mi tiúꞌuyesten. Aj pu i tihuáꞌimin. ¿Ni tzaa miyen tíꞌiruꞌitziꞌiveꞌen tɨ puaꞌa huáꞌa jamuan tíꞌiyeste ɨ́ jaꞌatɨ? Capu xaa neꞌu. Mɨ́ ajta xaa, aj pu tejaꞌuréꞌenejsin ɨ́ xɨcájraꞌa mej jetzen ráꞌaviꞌitɨn ɨ́ jaꞌatɨ. Aj mú xaa ɨ́ amiigustemuaꞌameꞌen ruꞌítziꞌiveꞌen, aꞌiné capu chéꞌe éꞌe jáꞌahuaꞌa ɨ́ huaꞌamiigu. Aꞌiné naúcheꞌe nu yé huatéjvee, camu ruꞌítziꞌiveꞌen ɨ́ neꞌamiigustemuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Nicheꞌe seɨ́j amuaatáꞌixaateꞌen ɨ́ niuucari. Tɨ́ puaꞌa jaꞌatɨ́ aꞌɨ́jna jɨ́n tíꞌicuꞌuneꞌepua cɨ́ɨxuri jɨmeꞌe tɨ míꞌimeꞌecan, capu ayén tíꞌijcuꞌuneꞌepuan aꞌɨ́jna jɨmeꞌe ɨ́ cɨ́ɨxuri tɨ caí xɨ jaꞌanáj jáꞌusiniꞌi. Naꞌari caí, huatétzuꞌuta puꞌu aꞌɨ́jna ɨ́ cɨ́ɨxuri tɨ jéjcua tɨ́ꞌɨj huatéjaꞌusiniꞌihua. Raꞌatésiujtzaꞌanaxɨꞌɨsin ɨ́ tɨ míꞌimeꞌecan. Aj pu i ɨ́ tɨ anásiujtzaꞌani, jaítzeꞌe pu veꞌetɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","’Ajta, camu miyen raruure mej ruꞌucájtuꞌani navij limeetajraꞌa tzajtaꞌa tɨ racuaꞌiríihuajme ɨ́ viinu ɨ́ mej mauchén ráataahuacaꞌa. Tɨ́ puaꞌa miyen ráaruuren, aꞌɨ́jna ɨ́ viinu tɨ jéjcua, aꞌɨ́ɨ pu rajtésiujtzaꞌana ɨ́ navij tɨ racuaꞌiríihuajme. Tɨꞌɨj jí aꞌuvaɨ́jtzi ɨ́ navij, ajta ɨ́ viinu. Aꞌɨ́j pu jɨ́n ayén ruxeꞌeveꞌe tɨ iruꞌucájtuꞌani navij tzajtaꞌa tɨ jéjcua aꞌɨ́jna ɨ́ viinu tɨ ajta jéjcua. Ayee pu ꞌéeniꞌicɨꞌe teꞌutáviicuaꞌira tɨ ruxɨ́ꞌej tiꞌijéjcua. Aꞌɨ́ɨ pu aꞌɨ́jna jɨ́n téꞌeviicuaꞌi ɨ́ tɨ huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Aúcheꞌe pu tihuaúꞌixáateꞌecaꞌa tɨ́ꞌɨj seɨ́j aveꞌeréꞌene, tɨ tíꞌaijta u huáꞌa teyujtaꞌa. Aj pu i títunutacaꞌa jemin aꞌɨ́jna ɨ́ Jesús. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Niyauj pu hui áꞌameꞌere. Mu aꞌutáꞌiyiꞌi patáꞌaj raꞌajtamuárɨꞌen, tɨꞌij aꞌɨ́ɨn auj ruuri áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús pu ájchee. Tɨꞌɨj jí aꞌuun yáꞌume jamuan aꞌɨ́jna ɨ́ yaꞌupuáaraꞌan aꞌɨ́jna tɨ áꞌameꞌere. Majta mú áꞌujuꞌun aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa aꞌuun aꞌutéveecaꞌa tɨ ari ayén áꞌatee tɨ tíꞌicuiꞌi aꞌachú cumu tamuáamuataꞌa nineꞌiraꞌa japuan huaꞌapua. Tɨ́ꞌɨj pɨ́ naꞌa pu uvéꞌexujxuꞌure. Aꞌɨ́ɨ pu aveꞌeréꞌene ɨ́ Jesús jemi. Aj pu i raꞌajtamuárɨej tɨ́j naꞌa teꞌuvíjpiꞌi ɨ́ cɨ́ɨxureꞌaraꞌan jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Aꞌɨ́j pu jɨ́n ayén huarɨ́j, aꞌiné ruseɨ́j pu ayén tiuꞌumuáꞌaj tɨjɨ́n: “Tɨ́ puaꞌa aꞌɨ́ɨ nenaꞌa caj teꞌajtamuárɨꞌen tɨ́j naꞌa teꞌuvíjpiꞌi ɨ́ cɨ́ɨxureꞌaraꞌan jetze, aj nu xaa rujni.” ");
INSERT INTO crnNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aj pu i Jesús pɨ́ɨ aꞌuréꞌeve tɨ́ꞌij raaseíj ɨ́ ꞌɨ́itaꞌa. Aj pu i ayén tiraatáꞌixaa tɨjɨ́n: ―Niyauj, huatéꞌacaꞌane muaꞌa tzajtaꞌa. Petéꞌatzaahuateꞌe nej timuáahuaate. Aꞌɨ́j pej jɨ́n peri huarúj. Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj pu i huarúj aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tɨꞌɨj jí aꞌuun aꞌaráꞌa aꞌu tɨ éꞌeche ɨ́ yaꞌupuáaraꞌan ɨ́ tɨ áꞌameꞌerejcaꞌa. Tɨ́ꞌɨj uteájrupi u chiꞌita, aj pu i huaꞌuseíj ɨ́ teɨte, aꞌɨ́mej ɨ́ mej tíꞌicɨꞌɨsiteꞌe jamuan ɨ́ seica ɨ́ mej jeíhua ruyein. ");
INSERT INTO crnNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu, xuꞌirácɨɨni múꞌeen, aꞌiné capu mɨꞌɨchi mɨ temuaij, sino cutzú puꞌu. Mɨ́ majta, aꞌɨ́ɨ mú raateꞌatzeájraa meꞌɨ́jna jɨmeꞌe aꞌij tɨ tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aj pu i Jesús huaꞌiráꞌitecaꞌa á puaꞌacɨé. Aꞌuu pu uteájrupi aꞌu tɨ auucáꞌa aꞌɨ́jna ɨ́ temuaij. Aj pu i raꞌajvíꞌi muájcaꞌareꞌaraꞌan jetze. Ajta aꞌɨ́ɨn ɨ́ temuaij, tɨꞌɨquí aꞌɨ́ɨn ájchee. ");
INSERT INTO crnNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tɨꞌɨj jí nainjapua aꞌu tɨ naꞌa mej aꞌuchéjmeꞌecaa, naímiꞌi mú ráamuaꞌareeriꞌi aꞌij tɨ tiꞌitɨ́ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tɨ́ꞌɨj Jesús aꞌuun aꞌarájraa, mé huaꞌapua mú raatavén ɨ́ mej aracúcuꞌunijmeꞌecaꞌa, muaꞌantijíihua. Miyen tɨjɨ́n: ―Múꞌee pej iꞌi yaujraꞌan aꞌɨ́jna ɨ́ David teecan, táꞌancuꞌuvajxɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tɨ́ꞌɨj Jesús uteájrupi u chiꞌita, aj mú mi aveꞌeréꞌene ɨ́ jemin. Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni senáꞌantzaahuateꞌesin nej tejáꞌamuahuaateꞌen? Matɨ́ꞌɨj mi miyen tɨjɨ́n: ―Aꞌii neꞌu tecaí, tavástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Aj pu i huaꞌarámuarɨꞌejxɨ ɨ́ huáꞌa jɨ́ꞌɨ jetze. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́jna jɨmeꞌe sej téꞌantzaahua, ayée pu téꞌeme. Xuꞌuri huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj mú mi mé uunéjneꞌerecaꞌa aꞌɨ́ɨme ɨ́ mej huaꞌapua. Jéihua pu tihuauꞌíjca aꞌɨ́jna ɨ́ Jesús mej nuꞌu caí jaꞌatɨ́ ixaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mɨ́ majta, matɨ́ꞌɨj aꞌucɨ́j, aj mú mi autéjhuii mej raataxáj mé jéjreꞌe nainjapua aꞌij tɨ Jesús huáꞌuruu. ");
INSERT INTO crnNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Matɨ́ꞌɨj huiirajúꞌuncaa u chiꞌita, seica mú tɨ tíꞌicuiꞌi á yeꞌiréꞌenejtiꞌire. Capu téꞌanrɨꞌɨrejcaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Aj pu i Jesús raatamuári ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa. Ajta áꞌiyen aꞌutéjche tɨ tiuꞌutaxáj aꞌɨ́jna tɨ tíꞌicuiꞌicaꞌa. Majta meꞌɨ́n ɨ́ teɨte, jeíhua mú huataújtemuaꞌave. Miyen tɨjɨ́n: ―Jee xaa neꞌu. Catu jaꞌanáj tiꞌitɨ́j tiyen tiuꞌuséij tɨ́j naꞌa íiyen tɨ huatacáꞌa Israél, tetɨ́j teuchén teri tiuꞌuséij íjii tɨ jaꞌatɨ́ ayén tiraayɨ́ꞌɨtɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mɨ́ majta aꞌɨ́ɨme ɨ́ fariseos, ayée mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Aꞌɨ́jna ɨ́ Jesús, aꞌɨ́ɨ pu aꞌɨ́jna jetze araújcaꞌane tɨ tihuáꞌaijteꞌe ɨ́ tiyáaruꞌuse tɨ́ꞌij ayén huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse ɨ́ mej teɨte tzajtaꞌa seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nain japua pu áꞌucheꞌecaneꞌe ɨ́ Jesús aꞌu tɨ naꞌa mej aꞌuchéjmeꞌecaa, chajtaꞌa, tɨ vivéj nusu tɨ cɨ́liéeneꞌejmee. Tihuáꞌamuaꞌatehuaꞌa pu áꞌayeꞌi huáꞌa teyujtaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ nainjapua tíꞌaijta. Ajta naíjmiꞌica pu tiúꞌuhuaa, nain ɨ́ mej jɨ́n tíꞌicuiꞌicaa nusu ɨ́ tɨ caí huáꞌacaꞌanistiꞌiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tɨ́ꞌɨj aꞌɨ́mej huaseíj ɨ́ teɨte, jéꞌecan pu huataújxɨeemɨste huáꞌa jemi aꞌiné jeíhua mú huamuáꞌitɨche meꞌɨ́jna jɨmeꞌe ɨ́ mej rajpuaíjtzicaꞌa. Majta ruxɨeemɨ́jteꞌe. Ayee mú éeneꞌe matɨ́j cáneꞌaxɨ ɨ́ tɨ caí jaꞌatɨ́ huáꞌacujtaꞌa áꞌucheꞌecaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Jee xaa neꞌu, ayej tiꞌayajna, muꞌuri muꞌiitɨ́ ɨ́ mej meri rɨ́ꞌɨ huaújruu tɨ Dios tíhuaꞌutaꞌaíjteꞌen. Mɨ́ ajta, ɨ́ mej tíꞌimɨjhuaca huáꞌa jɨ́meꞌen, camu muꞌíi. ");
INSERT INTO crnNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Aꞌɨ́j pu jɨ́n, ayée pu tiúꞌujxeꞌeveꞌe. Setáꞌaj siyen tíꞌijhuaviira seꞌɨ́jna ɨ́ tavástaraꞌa tɨ ayén huáꞌuruuren mej mi teɨtestemuaꞌameꞌen puꞌéeneꞌen muáꞌaraꞌani, tɨ i aꞌɨ́ɨn tavástaraꞌa huaꞌuréꞌeꞌitixɨꞌɨn ɨ́ mej tíꞌimɨjhuaca mej mi huáꞌajseɨreꞌen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Aj pu i Jesús huaꞌutajé aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Aꞌɨ́ɨ pu antiújmuaꞌareerecaꞌa aꞌɨ́jna jɨmeꞌe mej mi huaꞌutamuáriteꞌen ɨ́ tiyaaruꞌu mej huáꞌa tzajtaꞌa seijreꞌecaꞌa ɨ́ teɨte, ajta mej mi nain tihuáꞌuhuaateꞌen ɨ́ mej jɨ́n tíꞌicucuiꞌicaa, cuíꞌiniꞌiraꞌa jɨmeꞌe nusu tɨ caí huáꞌacaꞌanistiꞌiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ayee mú ánteꞌarua aꞌɨ́ɨme ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́mej ɨ́ tɨ Jesús huaꞌutaꞌítecaꞌa. Amuacaícan, aꞌɨ́jna ɨ́ Simón, ɨ́ mej majta miyen ratamuáꞌamua tɨjɨ́n Pedro. Aꞌɨ́ɨ pu ajta huatajé aꞌɨ́jna ɨ́ juutzeájraꞌan ɨ́ Simón. Ayee pu ántehuaa tɨjɨ́n Andrés. Ajta aꞌɨ́mej pu huatajé aꞌɨ́jna ɨ́ Jacobo, ajta juutzeájraꞌan tɨ ayén ántehuaa tɨjɨ́n Juan. Aꞌii mú meꞌɨ́n púꞌeen yaújmuaꞌameꞌen ɨ́ Zebedeo. ");
INSERT INTO crnNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ajta seica huatajé, aꞌɨ́jna ɨ́ Felipe, ajta aꞌɨ́jna ɨ́ Bartolomé, ajta aꞌɨ́jna ɨ́ Tomás, ajtahuaꞌa seɨ́j, tɨ ayén ántehuaa Mateo, tɨ tíꞌitejiꞌivihuaꞌa aꞌɨ́mej ɨ́ mej tíꞌitɨꞌɨcɨca. Seɨ́j pu ajta huatajé. Aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Jacobo, Alfeo tɨ rapeꞌeri, ajtahuaꞌa seɨ́j, aꞌɨ́jna ɨ́ Lebeo, ɨ́ mej majta miyen ratamuáꞌamua tɨjɨ́n Tadeo. ");
INSERT INTO crnNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Aꞌɨ́ɨ pu ajta huatajé aꞌɨ́jna ɨ́ Simón ɨ́ tɨ ajtémeꞌecan huáꞌa jetze ɨ́ mej miyen huataújmuaꞌa tɨjɨ́n cananista, ajta aꞌɨ́jna ɨ́ Judás tɨ ayén teꞌentímuꞌutaca tɨjɨ́n Iscariotes. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ avíitzi jɨ́n huaꞌutátuii aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase ɨ́ tɨ Jesús huaꞌutaꞌítecaꞌa. Ayee pu aꞌɨ́jna jɨ́n tihuaꞌuꞌíjca, ayén tihuáꞌixaateꞌe yee: ―Caxu seꞌuun áꞌucɨꞌɨcaꞌan seꞌújna á mej aꞌuchéjme ɨ́ mej seɨ́j chuéjraꞌa japua ajtémeꞌecan, caxu seajta uteáruꞌipicheꞌen chajtaꞌa aꞌu mej éꞌeche aꞌɨ́ɨme ɨ́ mej Samaria jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mɨ́ seajta múꞌeen, setáꞌaj seꞌuun áꞌujuꞌun huáꞌa jemi ɨ́ mej iꞌi yaújmuaꞌameꞌen aꞌɨ́jna ɨ́ Israél teecan. Yee mú ꞌeen aꞌɨ́ɨme tɨ́j cáneꞌaxɨ ɨ́ mej áꞌuvej. ");
INSERT INTO crnNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Setáꞌaj áꞌujuꞌun, seraꞌantixáata yee puꞌuri tɨ́n tejaꞌuréꞌenejsin tɨ Dios ayén tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Setáꞌaj seajta tihuáꞌuhuaateꞌen ɨ́ mej tíꞌicucuiꞌi. Seajta siyen huáꞌuruuren ɨ́ mej mauchén huácuii mej mi ruuri muáꞌaraꞌani majtáhuaꞌa menaꞌa. Setáꞌaj seajta huaꞌurújteꞌen aꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n tíꞌicucuiꞌi aꞌɨ́jna ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n “tɨ́ tineájxɨ ɨ́ ru jetze”. Seajta huaꞌutamuáriteꞌen aꞌɨ́mej ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌe ɨ́ teɨte. Múꞌeen, caxu tíꞌinajchitan aꞌɨ́jna jɨmeꞌe sej raꞌancuréꞌa seꞌɨ́jna ɨ́ muárɨꞌeriꞌiraꞌa ɨ́ sej jɨ́n tihuáꞌumuaꞌaten. Aꞌɨ́j pu jɨ́n, caxu huáꞌajijveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Caxu seajta tiꞌitɨ́j anúꞌan tzajtaꞌan ɨ́ puaasi ɨ́ sej jɨ́n avéꞌujjɨ́ꞌɨcɨꞌejme, tiꞌitɨ́j tumin, tɨ puaꞌa oro naꞌari plata nusu cobre. ");
INSERT INTO crnNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Caxu caꞌaní pijca ɨ́ sej jɨ́n huateújvaɨreꞌen ɨ́ juye jetze. Seajta seꞌɨ́ɨn ajtácaꞌacaiméꞌe ɨ́ tɨ anátápiꞌihuajmeꞌe, seajta ucaújchejteꞌaxɨꞌɨn seexuꞌijméꞌen seɨ́j jɨmeꞌe ɨ́ saꞌahua ɨ́ sej raꞌiteváarajme ɨ́ ruhuaréꞌetzeꞌe. Caxu seajta itzɨ́j chueeca. Ayee xu huárɨni aꞌiné ayej tíꞌixɨꞌepɨꞌɨn mej tejamuaamín meꞌɨ́jna jɨmeꞌe ɨ́ sej tíꞌimɨjhuaca. ");
INSERT INTO crnNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Aꞌu tɨ naꞌa mej aꞌuchéjme, setɨ́ꞌɨj aꞌuteárute seꞌújna, aj xu si seɨ́j huahuauni tɨ caí tiꞌitɨ́j jɨ́n ateáturaaveca. Aꞌuu xu aꞌutéꞌe xáꞌajuꞌun u chiꞌiraꞌan tzajtaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ aꞌachú sej caj áꞌateere seꞌújna chajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Setɨ́ꞌɨj aꞌuteárute seꞌújna u chiꞌita, aj xu huaꞌutateújteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tɨ́ puaꞌa miyen amuaꞌancuréꞌeviꞌitɨn temuaꞌa naa, chéꞌe ayén éeneꞌen aꞌij sej seri tihuaꞌutateújte. Naꞌari caí, setáꞌaj seɨ́j jemi raateájtuaani ɨ́ runiuuca ɨ́ sej jɨ́n seri tihuaꞌutateújte aꞌɨ́mej ɨ́ mej mauchén amuaatíite. ");
INSERT INTO crnNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","’Ajta tɨ puaꞌa jaꞌatɨ́ caí amuaꞌancuréꞌeviꞌitɨn, naꞌari tɨ puaꞌa mecaí ranamuajracu aꞌij sej tihuaúꞌixaateꞌen, setɨ́ꞌɨj huirácɨɨnen seꞌújna chiꞌita, seraꞌatécaꞌatzɨjxɨꞌɨn ɨ́ rucaꞌacai tɨ i cávatziɨn ɨ́ chuej. Aj mú mi ramuaꞌaréeren ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, aꞌájna xɨcájraꞌa tɨ jetzen huáꞌaxɨjteꞌen ɨ́ Dios ɨ́ mej jɨ́n auteájturaa ɨ́ jemin, jeíhua pu puaíjtzi huaꞌutáꞌasin. Jaítzeꞌe mú rajpuaíitzi muáꞌajuꞌun aꞌujna chajtaꞌa mecaí ɨ́ mej mejmíꞌi meꞌuun éꞌechejcaꞌa aꞌujna tɨ ayén tejaꞌarájtehuaacaꞌa tɨjɨ́n Sodoma, ajta aꞌujna u Gomorra. ");
INSERT INTO crnNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Casiꞌi múꞌeen, ayée nu tejámuaataꞌaíjteꞌesin sej si áꞌujujhuaꞌaneꞌen huáꞌa tzajtaꞌa ɨ́ teɨte ɨ́ mej miyen áꞌamuaruuren tɨ́j ɨ́ɨraꞌave ɨ́ mej tíꞌitecɨꞌɨmeca. Setáꞌaj siyen mé titeumuámuaꞌareꞌen matɨ́j aꞌɨ́ɨme ɨ́ cuꞌucuꞌuse ɨ́ mej jeíhua raayɨ́ꞌɨtɨ. Setáꞌaj huamuáꞌajcantare sej si caí tiúꞌɨtzíiteꞌe mé séꞌujujhuaꞌaneꞌen matɨ́j majta rɨcɨ aꞌɨ́ɨme ɨ́ cucuiꞌise. ");
INSERT INTO crnNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","’Rɨ́ꞌɨ xuꞌu huáꞌa jemi ɨ́ teteca. Aꞌɨ́ɨ mú múꞌejmi aꞌuteátuaasin aꞌu mej teꞌáijta huáꞌa jueesi jemi. Aj mú mi amuaꞌajvájxɨꞌɨsin aꞌamua huari jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Majta mú múꞌejmi áꞌaviꞌitɨn ɨ́ tajtúhuaani jemi naꞌari ɨ́ rey jemi meꞌɨ́jna jɨmeꞌe sej siyen tíꞌivaɨreꞌe ne jetze meꞌecan. Ayee mú áꞌamuaruuren sej si huaꞌutáꞌixaateꞌen aꞌɨ́jna jɨmeꞌe aꞌij sej ꞌeen jɨ́n náꞌastijreꞌen ineetzi. Ayee xu cheꞌatá senaꞌa tihuaꞌutáꞌixaateꞌesin aꞌɨ́mej ɨ́ mej caí Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aru, aꞌájna xɨcájraꞌa jetze matɨ́ꞌɨj áꞌamuaviviꞌiran, caxu siyen tíꞌimuajca yee aꞌii qui yeꞌí tetiuꞌutaxájta, naꞌari yee tiꞌitajqui niuucarijraꞌa taataxájta. Matɨ́ꞌɨj miyen amuáaruuren, aj pu i Dios amuaatáꞌasin aꞌij sej yeꞌí tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ayee xuꞌu, caxu tíꞌitziɨɨneꞌe aꞌiné ɨ́ sej huaꞌutáꞌixaateꞌesin, caxu rujɨ́ɨmuaꞌa rájteusin sino aꞌɨ́ɨn ɨ́ xɨéjniuꞌucareꞌaraꞌan aꞌɨ́jna ɨ́ sej rájyaꞌupua, aꞌɨ́ɨ pu amuaataꞌítɨira aꞌij sej yeꞌí tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Jaꞌatɨ́ pu hui huaꞌitzi jɨ́n tíꞌijxajtziꞌiran ɨ́ ruꞌihuaaraꞌa mej mi raajéꞌica. Ayee pu cheꞌatá naꞌa téꞌeme ɨ́ yaꞌupuáaraꞌan huaꞌitzi pu huáꞌataaven ɨ́ ruyaujmuaꞌa. Majta meꞌɨ́n ɨ́ yaújmuaꞌameꞌen, aꞌɨ́ɨ mú cheꞌatá menaꞌa ájhuiixɨꞌɨn. Ayee mú tihuaꞌutaꞌaíjta mej huáꞌucuiꞌini. ");
INSERT INTO crnNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Majta ɨ́ teɨte, naímiꞌi mú amuáꞌajchaꞌɨ́ɨreꞌe muáꞌajuꞌun meꞌɨ́jna jɨmeꞌe sej náꞌastijreꞌe ineetzi. Ajta aꞌɨ́ɨn ɨ́ tɨ teꞌutáviicuaꞌi ajta naꞌa caí nain teꞌentipuáꞌare, Dios pu ruꞌirátuaasin aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Matɨ́ꞌɨj aꞌij puaꞌa áꞌamuaruure íiye chajtaꞌa, setáꞌaj caꞌanacan huirácɨɨne. Sej si seɨ́j chajtaꞌa jetze aꞌuteárute. Ayee nu tejáꞌamuaꞌixaateꞌe, setɨ́ꞌɨj seuj áꞌujujhuaꞌaneꞌen seɨj seajta seɨj jetze ɨ́ chajtaꞌa aꞌu mej aꞌuchéjme aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, i nej neajta teáataꞌa jetze airáane, nee nu xaa yé veꞌecánejsin. ");
INSERT INTO crnNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Aꞌɨ́jna ɨ́ tɨ tihuáꞌamuaꞌate, jaítzeꞌe pu ruxeꞌeveꞌe caí aꞌɨ́mej ɨ́ mej tiúꞌujmuaꞌate. Ajta, aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe, jaítzeꞌe pu ruxeꞌeveꞌe aꞌɨ́jna caí aꞌɨ́ɨn tɨ ravaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aꞌɨ́j pu jɨ́n, ayén tiúꞌujxeꞌeveꞌe. Aꞌɨ́jna tɨ tihuáꞌamuaꞌaten, chéꞌe aꞌɨ́ɨn ayén cheꞌatá naꞌa éeneꞌen tɨ́j aꞌɨ́jna tɨ tiúꞌujmuaꞌate. Ajta aꞌɨ́jna tɨ tíꞌivaɨreꞌe, chéꞌe aꞌɨ́ɨn ajta ayén cheꞌatá naꞌa ꞌeeneꞌen tɨ́j aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe. Ayee mú cheꞌatá menaꞌa áꞌamuaruuren múꞌejmi aꞌij mej meri náaruu ineetzi. Aꞌiné ayée mú meri naatamuáꞌa tɨ jɨ́meꞌen yee: “Múꞌee pej iꞌi Beelzebú aꞌɨ́jna tɨ tihuáꞌaijteꞌe ɨ́ tiyáaruꞌuse”, ayée mú cheꞌatá menaꞌa áꞌamuaruuren múꞌejmi, mɨ sej hui níꞌiteɨtestemuaꞌa. Jee xaa neꞌu, majta mú jaítzeꞌe aꞌij puaꞌa áꞌamuaruuren múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Aꞌɨ́j xu jɨ́n, ca xu huáꞌatziɨɨneꞌe ɨ́ teɨte. Tiꞌitɨ́ tɨ aꞌij avíitziꞌi ɨ́ sej jɨ́n rajpuaíjtzi, Dios pu raataseíjrata mé jéjreꞌe, naꞌari tiꞌitɨ́j tɨ aꞌij tɨ rúꞌavaa ɨ́ sej jɨ́n tíꞌimuarɨꞌe, Dios pu huaꞌutáꞌasin mej mi ráamuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Aꞌɨ́jna ɨ́ nej jáꞌamuaꞌixaateꞌe avíitzi jɨmeꞌe, ayée xu huárɨni, setáꞌaj raataxáj mé jéjreꞌe. Ajta ɨ́ nej jáꞌamuaꞌixaateꞌe xahuaaniꞌi jɨmeꞌe, ayée xu raataxáj caꞌanín jɨmeꞌe, án xuꞌu ɨmuá aꞌutiúu ɨ́ aꞌamuachiꞌi japua. ");
INSERT INTO crnNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","’Caxu huáꞌatziɨɨneꞌe aꞌɨ́mej ɨ́ mej ruxɨ́ꞌej teɨte cuiꞌica aꞌiné camu raayɨ́ꞌɨtɨ mej áꞌamuaxɨejniuꞌuca antipuáꞌajteꞌen. Mɨ́ seajta múꞌeen, aꞌɨ́j xu xaa tziɨɨneꞌe aꞌɨ́jna ɨ́ Dios tɨ ayén raayɨ́ꞌɨtɨ tɨ raꞌantipuáꞌajteꞌen mɨ sej siyen cheꞌatá ratéhuaꞌiraꞌa. Ajta aꞌɨ́ɨ pu raayɨ́ꞌɨtɨ tɨ raꞌantipuáꞌajteꞌen ɨ́ áꞌamuaxɨejniuꞌuca ɨ́ sej jɨ́n seuj ruuricaꞌa ɨ́ taij jetze tɨ caí jaꞌanáj áꞌamɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’Ayee pu huáꞌanajche aꞌɨ́mej mɨ pinaꞌase, aꞌachú cumu seɨ́j tumin seɨ́j. Ayee pu i ꞌeen aꞌɨ́jna ɨ́ áꞌamuayaꞌupua, aúcheꞌe pu huáꞌachaꞌɨɨ mɨ pinaꞌase. Capu seɨ́j mɨꞌɨni ɨ́ pinaꞌa tɨ puaꞌa aꞌɨ́ɨ caí xɨ ayén tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Dios pu ajta ramuaꞌaree aꞌachú tɨ puaꞌamé cáꞌuu ɨ́ áꞌamuacɨpua. ");
INSERT INTO crnNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Aꞌɨ́j pu jɨ́n, caxu tíꞌimuajca. Jaítzeꞌe xu ruxeꞌeveꞌe ɨ́ Dios jemi mecaí mɨ pinaꞌase. ");
INSERT INTO crnNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Jaꞌatɨ́ tɨ naꞌa tɨ ayén teꞌanxájta huáꞌa jemi ɨ́ teɨte aꞌɨ́jna jɨmeꞌe yee nej nuꞌu ráꞌastijreꞌe neꞌɨ́jna ɨ́ Jesús, ayée nu hui cheꞌatá nenaꞌa teꞌanxájta jemin ɨ́ tɨ ajta níꞌiyaꞌupua ta japua tɨ éꞌeseijreꞌe tɨ jɨ́meꞌen yee aꞌɨ́ɨ pu xɨ́ꞌepɨꞌɨn huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ajta, jaꞌatɨ́ tɨ ayén huáꞌa jemi ayén teꞌanxájta ɨ́ teɨte tɨ nuꞌu caí nemuaꞌate, ayée nu cheꞌatá nenaꞌa teꞌanxájta jemin ɨ́ tɨ ajta níꞌiyaꞌupua, ta japua tɨ éꞌeseijreꞌe. Ayee nu xáahuí tiraatáꞌixaateꞌesin tɨ jɨ́meꞌen yee nej caí ramuaꞌate neꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Caxu siyen tíꞌimuajca ɨ́ nej neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej mej mi rɨ́ꞌɨ temuaꞌa naa titeeteáturan íiyen chaanaca japua. Canu neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej mej mi rɨ́ꞌɨ titeeteáturan temuaꞌa naa sino mej mi jáꞌitaꞌa aꞌutácɨɨne meꞌɨ́jna jɨmeꞌe aꞌij nej rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ayee nu neꞌɨ́jna jɨ́n aꞌuvéꞌemej tɨ ij jaꞌatɨ́ autéjcheni tɨ raaténeꞌusiꞌiteꞌen ɨ́ rutáàta. Ajta aꞌɨ́ɨn tɨ temuaij ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu ajta raaténeꞌusiꞌiteꞌesin ɨ́ runáàna. Ayen cheꞌatá naꞌa tihuáꞌaruuren, ɨ́ ꞌɨ́itaꞌa tɨ ari timúꞌun tɨ ꞌɨ́itaꞌa; aꞌɨ́ɨ mú huateújneꞌusiꞌiteꞌesin aꞌɨ́mej rumúunimuaꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Aꞌɨ́j mú jɨ́n, aꞌɨ́ɨ mú rájchaꞌɨ́ɨreꞌe muáꞌajuꞌun ɨ́ seica aꞌɨ́mej ɨ́ ruxɨ́ꞌej teɨtestemuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Tɨ́ puaꞌa jaꞌatɨ́ jaítzeꞌe raxɨ́ꞌeveꞌe ɨ́ rutáàta, ajta ɨ́ runáàna caí ineetzi, capu ayén tiraavíjteꞌe tɨ aꞌɨ́ɨn neetzi jemi huateáturan tɨ́j naꞌa rusén jɨmeꞌe. Ajta tɨ puaꞌa jaꞌatɨ́ jaítzeꞌe raxɨ́ꞌeveꞌe ɨ́ ruyauj tɨ teáataꞌa, ajta tɨ ꞌɨ́itaꞌa, tɨ puaꞌa jaítzeꞌe raxɨ́ꞌeveꞌe caí ineetzi, capu ajta ayén tiraavíjteꞌe tɨ aꞌɨ́ɨn neetzi jemi seíireꞌe áꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ajta, tɨ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ áꞌucheꞌecaneꞌen neetzi jamuan, chéꞌe aꞌɨ́ɨn huataúraꞌan tɨ rajpuaíjtzi áꞌaraꞌani neniúucajtzeꞌe, capu amɨ́n aꞌij tɨ puaꞌa huámɨꞌɨni ɨ́ cúruu jetze. Naꞌari caí, capu ayén tejaꞌuréꞌenejsin tɨ aꞌɨ́ɨn ayén huateáturan neetzi jemi aꞌutɨ́ Dios éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tɨ́ puaꞌa jaꞌatɨ́ tíꞌiteseꞌe tɨ ij caí huámɨꞌɨni, aúcheꞌe pu xaa neꞌu mɨꞌɨni. Aꞌij pu áꞌujɨsin ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa. Mɨ́ ajta, aꞌɨ́ɨn tɨ huataúraꞌan tɨ huámɨꞌɨni aꞌɨ́jna jɨmeꞌe tɨ tiuꞌutévaɨ neetzi jetze meꞌecan, aꞌɨ́ɨ pu ajtahuaꞌa huatarújsin. Rateuní ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuri tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Aꞌɨ́jna ɨ́ jaꞌatɨ tɨ amuaꞌancuréꞌeviꞌitɨ u ruchiꞌitá, aꞌɨ́ɨ pu ajta naꞌancuréꞌeviꞌitɨ ineetzi. Ajta, aꞌɨ́jna ɨ́ tɨ naꞌancuréꞌeviꞌitɨ ineetzi, ayée pu cheꞌatá naꞌa raꞌancuréꞌeviꞌitɨ aꞌɨ́jna tɨ nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ajta aꞌɨ́jna tɨ raꞌancuréꞌeviꞌitɨ seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa, ayée pu cheꞌatá naꞌa tíꞌiracɨꞌɨti ɨ́ Dios jemi tɨ́j ajta tíꞌiracɨꞌɨti aꞌɨ́jna tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. Naꞌari, tɨ puaꞌa jaꞌatɨ́ raꞌancuréꞌeviꞌitɨn jaꞌatɨ́ tɨ xɨ́ꞌepɨꞌɨn rɨcɨ, ayée pu cheꞌatá naꞌa tíꞌiracɨꞌɨti ɨ́ Dios jemi tɨ́j ajta tíꞌiracɨꞌɨti aꞌɨ́jna ɨ́ jaꞌatɨ tɨ xɨ́ꞌepɨꞌɨn rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ajta, tɨ puaꞌa jaꞌatɨ́ raatáꞌan cɨ́j caj ɨ́ jaj, vaasu tzajtaꞌa seɨ́j ɨ́ tevi tɨ caí tiꞌitɨ́j jɨ́n antiújmuaꞌaree, tɨ puaꞌa ayén tiraatáꞌan aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn tevi náꞌastijreꞌe, ayej tiꞌayajna, tiꞌitɨ́j pu tíꞌiracɨꞌɨti ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tɨ́ꞌɨj Jesús raatapuáꞌajtacaꞌa tɨ huaꞌutáꞌixa ɨ́ tɨ jɨ́n tihuauꞌíjca, aj pu i áꞌuraa. Aꞌáyee pu aꞌaráꞌa chajtaꞌa aꞌɨmuá aꞌu mé aꞌitechéjme tɨ ij tihuáꞌumuaꞌaten, tɨ ij ajta tihuaꞌutáꞌixaateꞌen ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ajta aꞌɨ́jna ɨ́ Juan, aꞌúu pu jáꞌahuaꞌa áꞌanamiꞌihuacaꞌa. Aj pu i yáꞌumuaꞌareeriꞌi aꞌij tɨ Jesús rɨjcaa. Tɨꞌɨj jí huaꞌutaꞌítecaꞌa seica ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe mej mi u yaꞌutéeseij, majta mej mi tiraataꞌíhuaꞌu meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni múꞌee pej peꞌɨ́n pɨ́rɨcɨ peꞌɨ́jna ɨ́ pej jee iꞌi Cɨríistuꞌu pej múꞌee íiyen ruxeꞌeveꞌe, pej nuꞌu yen veꞌecáanen? Naꞌari caí, ¿ni ayén tiúꞌujxeꞌeveꞌe tej seɨ́j huachúꞌeveꞌen? ");
INSERT INTO crnNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Sericu, setáꞌaj siyen tiraataꞌixaateꞌen seꞌɨ́jna ɨ́ Juan aꞌij sej yeꞌí tíꞌiseij, seajta tíꞌinamua. ");
INSERT INTO crnNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Setáꞌaj raatáꞌixaateꞌen yee muꞌuri atanéjneꞌe ɨ́ mej aracúcuꞌunijmeꞌecaꞌa; ajta yee muꞌuri á áꞌujujhuaꞌan aꞌɨ́ɨme ɨ́ mej anacɨyáaxaviꞌijmeꞌecaa ruɨ́ɨca jetze; majta yee muꞌuri huarúj meꞌɨ́jna jɨmeꞌe cuíꞌiniꞌiraꞌa tɨ tineájxɨ ɨ́ huáꞌahuaꞌiraꞌa jetze. Majta hui aꞌɨ́ɨme ɨ́ mej nácuxaꞌitajmeꞌecaa, muꞌuri huiteájnamua. Majta seica, aꞌɨ́ɨme ɨ́ mej huácuii, muꞌuri majtáhuaꞌa menaꞌa huatarúj. Neajta tihuaꞌutáꞌixaateꞌesin aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi ɨ́ niuucari tɨ jɨ́n Dios huaꞌirátuaasin. ");
INSERT INTO crnNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Chéꞌe huaújtemuaꞌaveꞌen aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí ruhuáritaꞌa huaréꞌeyeꞌican ineetzi jemi aꞌɨ́jna jɨmeꞌe tɨ caí chéꞌe téꞌeviicuaꞌi neetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Matɨ́ꞌɨj aꞌucɨ́j aꞌɨ́ɨme ɨ́ mej Juan jamuan áꞌujujhuaꞌaneꞌe, Jesús pu aꞌutéjche tɨ tihuaꞌutáꞌixaateꞌen ɨ́ seica jɨ́meꞌen aꞌɨ́jna ɨ́ Juan. Ayen tɨjɨ́n: ―¿Tiꞌitáani senaꞌa u aꞌutéeseij seꞌújna u muꞌutzitá? ¿Ni qui siyen tiraaseíj ɨ́ huiini tɨ eeca raruꞌuxanteꞌe? Caxu xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tɨ́ puaꞌa secaí siyen huarɨ́j, ¿tiꞌitáani senaꞌa aꞌutéeseij? ¿Ni jaꞌatɨ́ seꞌutéeseij tɨ teꞌucáaviɨj rɨꞌéeneꞌen jɨmeꞌe? Caxu xaa neꞌu, aꞌiné xuꞌuri ramuaꞌaree tɨjɨ́n aꞌɨ́ɨme ɨ́ mej miyen rɨꞌéeneꞌen jɨ́n teꞌucáaviɨj, aꞌúu mú éꞌeche huáꞌachiꞌita ɨ́ rey. ");
INSERT INTO crnNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ari tɨ puaꞌa secaí siyen huarɨ́j, ¿tiꞌitájni neꞌu? ¿Ni secaí siyen aꞌɨ́ɨn aꞌutéeseij jaꞌatɨ́ tɨ Dios jetze meꞌecan tíꞌixaxaꞌa? Ayee nu tejáꞌamuaꞌixaateꞌe tɨ aꞌɨ́ɨn púꞌeen tzɨ́teꞌe aꞌɨ́jna ɨ́ Juan. Ayej xaa neꞌu tiꞌayajna, jeíhua pu jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee aꞌɨ́jna ɨ́ Juan caí seɨ́j tɨ ayée naꞌa aꞌɨ́jna jɨ́n tiꞌitéjvee tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ jɨ́meꞌen ráꞌaxa ɨ́ yuꞌuxari jetze. Tɨjɨ́n: Nee nu jaꞌatɨ́ huataꞌíti tɨ amuájca múꞌeetzi jemi mej mi rɨ́ꞌɨ huaújruuren ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, huáꞌa tzajtaꞌa naíjmiꞌi ɨ́ teɨte ɨ́ mej huanéj íiyen chaanaca japua, capu jaꞌatɨ́ jaꞌanáj teꞌenteájrupi tiꞌitɨ́j jɨmeꞌe tɨ jaítzeꞌe veꞌée caí ɨ́ tɨ jɨ́n tiꞌitéjvee aꞌɨ́jna ɨ́ Juan. Mɨ́ ajta, aꞌɨ́ɨn tɨ jaítzeꞌe cɨ́lieen jɨ́n seijreꞌe jɨ́n tiꞌitéjvee ɨ́ Dios jemi, jaítzeꞌe pu veꞌée aꞌɨ́jna ɨ́ jaꞌatɨ caí aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Tɨ́j naꞌa aꞌájnáꞌɨmua tɨ huataseíjre aꞌɨ́jna ɨ́ Juan, tɨ yú eꞌiréꞌene, teɨte mú caꞌanéeri jɨ́n rahuauca mej mi meꞌuun aꞌuteárute aꞌájna Dios tɨ éꞌeseijreꞌe. Majta caꞌanéeri mú jɨ́n tíꞌiteseꞌe aꞌɨ́ɨme ɨ́ teteca ɨ́ mej rucaꞌané mej mi huataúraꞌan meꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, ajta aꞌɨ́jna ɨ́ yuꞌuxari jetze tɨ Moisés teecan raꞌuyúꞌuxacaꞌa, naímiꞌi mú tiuꞌutaxájtacaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ Dios tɨ nainjapua tíꞌaijta íiyen chaanaca japua. Maúcheꞌe raaxájtacaꞌa ajta naꞌa caí yé huataseíjre aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ajta, tɨ puaꞌa siyen titeꞌehuaújcaꞌanen sej ráꞌantzaahuateꞌen, aꞌɨ́jna ɨ́ Juan, aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna tɨ nuꞌu ruxeꞌeveꞌe tɨ yé uvéꞌenen, aꞌɨ́jna ɨ́ tɨ ayén ántehuaa tɨjɨ́n Elías. ");
INSERT INTO crnNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Aꞌɨ́ɨme ɨ́ mej huiteánajcaꞌamua, michéꞌe rɨ́ꞌɨ tiráanamua. ");
INSERT INTO crnNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Aꞌiné nenaꞌa tiraataxáj yee aꞌiné méꞌeen aꞌɨ́ɨme ɨ́ teɨte ɨ́ mej aꞌíjna nineꞌiraꞌa jetze yen huachéjme íjii? Ayee mú ꞌéꞌen matɨ́j ɨ́ tɨꞌɨríi ɨ́ mej vejliꞌi aꞌujteí aꞌu mej tejáꞌatua. Aꞌɨ́ɨ mú huaꞌatéjiꞌivihuaꞌa ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Miyen tɨjɨ́n: “Tetiuꞌutacɨ́ꞌɨsite sej si tiuꞌutéeneꞌen. Mɨ́ seajta caí, caxu tiuꞌutéenei. Teajta tu tiuꞌutáchuiicacaꞌa ɨ́ chuiicari jɨmeꞌe ɨ́ mej jɨ́n tíꞌichuicaca tɨ puaꞌa seɨ́j huámɨꞌɨni, mɨ seajta, caxu seꞌɨ́jna jɨ́n huataújxɨeemɨste.” ");
INSERT INTO crnNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","’Ayee nu hui ꞌeen jɨ́n niyen tejáꞌamuaꞌihuaꞌu aꞌiné ayée pu tíꞌirɨneca. Aꞌɨ́jna ɨ́ Juan, ayée pu mú aꞌuvéꞌemej. Aꞌɨ́ɨ pu rúꞌitziꞌiveꞌecaꞌa. Ajta, capu rayeꞌecaꞌa ɨ́ nahuáj. Aꞌɨ́j xu jɨ́n siyen tiuꞌutaxájtacaꞌa yee tiyaaruꞌu pu tzajtaꞌan seijreꞌe amɨ́jna mɨ tevi. ");
INSERT INTO crnNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Neajta áꞌiyen inee yé uvéꞌene, i nej neajta teáataꞌa jetze airáane. Canu néꞌitziꞌivi. Neajta rayeꞌeca ɨ́ nahuáj. Múꞌeen xu si siyen tíꞌinexa yee huápɨꞌɨ nu tíꞌicuaꞌa, neajta nuꞌu netahuaive, majta miyen neꞌamiigustemuaꞌa púꞌeen aꞌɨ́ɨme ɨ́ mej nuꞌu jeíhua atéꞌɨtzeaꞌara ɨ́ Dios jemi, majta aꞌɨ́ɨme ɨ́ huáꞌajijveꞌe ɨ́ mej tíꞌitɨꞌɨcɨca. Ayee xu ramuaꞌaree tej rɨ́ꞌɨ mé titeumuámuaꞌaree aꞌɨ́mej jemi ɨ́ mej taꞌaráꞌastijreꞌe itejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aj pu i Jesús aꞌutéjche tɨ huaꞌajteáꞌaxɨꞌɨn aꞌɨ́mej ɨ́ mej meꞌuun antachéejmeꞌecaa aꞌu tɨ ayén tejaꞌurɨ́j ɨ́ muárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe muꞌiicáca ɨ́ mej jɨ́n rɨ́ꞌɨ teꞌutaseíj. Aꞌɨ́ɨ pu huaꞌajteáꞌaxɨ seɨj ajta seɨj ɨ́ teɨtejraꞌa ɨ́ mej meꞌuun aꞌuchéjmeꞌecaa u chajtaꞌa jetze aꞌiné camu autéjhuii mej seɨcɨé tiúꞌumuaꞌati. ");
INSERT INTO crnNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ayen tɨjɨ́n: ―Chéꞌe aꞌij tɨ naꞌa, múꞌeen mɨ sej Corazín éꞌeche. Chéꞌe aꞌij tɨ naꞌa, múꞌeen mɨ sej Betsaída éꞌeche. Tɨ́ puaꞌa niyen cheꞌatá nenaꞌa huárɨniicheꞌe nemuárɨꞌeriꞌiraꞌa jɨmeꞌe neꞌújna u Tiro, neajta neꞌújna u Sidón, aꞌij nej neri yeꞌí huarɨ́j nemuárɨꞌeriꞌiraꞌa jɨmeꞌe múꞌejmi jemi, mejmíꞌi mú seɨcɨé tiúꞌumuaꞌatíjcheꞌen. Aꞌɨ́ɨ mú majta mej miꞌi raataseíiratacheꞌe meꞌɨ́jna jɨmeꞌe mej tiuꞌuteújchejteꞌen xuꞌumuaviꞌin jɨmeꞌe, majta mejmíꞌi nasij avéꞌujhuaꞌatehuaꞌancheꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén téꞌeme aꞌájna xɨcájraꞌa jetze tɨ́ꞌɨj Dios huáꞌaxɨjteꞌen matɨ́j menaꞌa puaꞌamé teɨtejraꞌa. Jaítzeꞌe xu rajpuaíitzi xáꞌajuꞌun mecaí aꞌɨ́ɨme ɨ́ mej aꞌuun aꞌuchéjmeꞌecaa meꞌújna u Tiro, majta meꞌújna u Sidón. ");
INSERT INTO crnNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","’Seajta múꞌeen mɨ sej Capernaúm aꞌuchéjme, ¿aꞌiné tejamuáꞌamitɨejteꞌe? ¿Ni qui ayén yee tejamuáꞌamitɨejteꞌe sej nuꞌu rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios? Caxu xaa neꞌu. Dios pu puaíjtzi amuaatáꞌasin. Aꞌuu xu aꞌuteáturaasin mɨꞌɨchite jamuan. Tɨ́ puaꞌa niyen cheꞌatá nenaꞌa huárɨniicheꞌe neꞌújna Sodoma aꞌij nej neri tiúꞌuruu nemuárɨꞌeriꞌiraꞌa jɨmeꞌe múꞌejmi jemi, aꞌujna u chajtaꞌa u Sodoma, aꞌɨ́ɨ pu auj eꞌetéericheꞌen tɨ́j naꞌa aꞌájnáꞌɨmua tɨ yú eꞌiréꞌene. ");
INSERT INTO crnNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mɨ́ ajta, ayée nu tejáꞌamuaꞌixaateꞌe, aꞌájna xɨcájraꞌa tɨ jetzen Dios huáꞌaxɨjteꞌen aꞌɨ́mej ɨ́ mej japuan aꞌuchéjme íiyen chaanaca japua, múꞌeen xu jaítzeꞌe rajpuaíitzi xáꞌajuꞌun seꞌájna, mecaí aꞌɨ́ɨme ɨ́ mej meꞌuun aꞌuchéjmeꞌecaa aꞌujna tɨ́j naꞌa tɨ Sodoma eꞌejtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Aꞌájna xɨcájraꞌa jetze tɨ Jesús ayén tiuꞌutaxájtacaꞌa, aj pu i ayén raatéjhuau ɨ́ ruyáꞌupua jemi tɨjɨ́n: ―Múꞌee ɨ́ pej níꞌiyaꞌupua, ɨ́ pej tíꞌaijta peꞌújna u ta japua, pajta íiyen chaanaca japua, rɨ́ꞌɨ nu timuaatáꞌaca neꞌɨ́jna jɨmeꞌe pej huaꞌutáꞌa mej mi yaúꞌitɨee muáꞌaraꞌani aꞌij tɨ ꞌeen múꞌeetzi jemi aꞌɨ́ɨme ɨ́ mej caí jeíhua tiúꞌujmuaꞌate. Mɨ́ pajta, capej piyen huaꞌutáꞌa mej mi yaúꞌitɨee muáꞌaraꞌani aꞌɨ́ɨme ɨ́ mej támuaꞌaree, majta aꞌɨ́ɨme ɨ́ mej raayɨ́ꞌɨtɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aꞌiné pijta, ayée pej tíꞌijxeꞌeveꞌecaꞌa múꞌee, ɨ́ pej níꞌiyaꞌupua. ―Ayee pu tiraatéjhuau. ");
INSERT INTO crnNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Aj pu i ajtahuaꞌa ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Nain pu tinaatátui aꞌɨ́jna tɨ níꞌiyaꞌupua mej mi ráamuaꞌati tzáahuatiꞌiraꞌa jɨmeꞌe. Capu jaꞌatɨ́ nemuaꞌate nain jɨmeꞌe aꞌij nej ꞌeen sino aꞌɨ́ɨ puꞌu tɨ níꞌiyaꞌupua, aꞌɨ́ɨ pu xaa nemuaꞌate. Ajta, capu jaꞌatɨ́ ramuaꞌate nain jɨmeꞌe ɨ́ tɨ níꞌiyaꞌupua sino inee i nej yaujraꞌan púꞌeen, nee nu xaa ramuaꞌate. Majta, aꞌɨ́ɨ mú ramuaꞌate aꞌɨ́ɨme ɨ́ tɨ huaꞌaráanajche nej tihuaꞌutaseíjrateꞌen aꞌij tɨ ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Setáꞌaj yé veꞌeréꞌenen neetzi jemi, setɨ́j senaꞌa puaꞌamé múꞌeen, mɨ sej cuaꞌana seꞌɨ́jna jɨmeꞌe ɨ́ sej rahuauca sej rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios, seajta seꞌɨ́jna jɨ́n tíꞌiteseꞌe ɨ́ sej raꞌaráꞌastijreꞌen nain jɨmeꞌe. Nee nu xaa amuaatáꞌasin sej huaújseꞌupeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Setáꞌaj teꞌenteárute seꞌɨ́jna jɨmeꞌe ɨ́ nej jɨ́n tejáꞌamuaꞌíjcateꞌe. Seajta tiúꞌurɨꞌɨren neetzi jemi, aꞌiné nee nu neꞌɨ́n púꞌeen seɨ́j tɨ muaꞌacan, canu neajta áꞌantzaahuateꞌe. Tɨ́ puaꞌa siyen yé veꞌeréꞌenen neetzi jemi, nee nu amuaatáꞌasin sej rɨ́ꞌɨ huárɨni ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Capu muárɨꞌeri sej raanaíjmireꞌen seꞌɨ́jna jɨmeꞌe ɨ́ nej jɨ́n amuaatáꞌasin. Ajta, ɨ́ nej jɨ́n tejáꞌamuaꞌíjcateꞌe, capu ajta muárɨꞌeri sej siyen huárɨni aꞌij nej tíꞌijxeꞌeveꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ajta aꞌájnáꞌɨmua ayée pu tiujuꞌurɨ́j. Aꞌuu pu auméꞌecaa ɨ́ Jesús jáꞌitaꞌa ɨ́ víꞌiraꞌajapua. Aj pu pɨ́tíꞌirɨjca jaꞌanáj xɨcájraꞌa mej jetzen ruseꞌupi. Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú meri jeíhua tɨejcucaꞌa. Aj mú mi autéjhuii mej raꞌantítzaanaxɨꞌɨn tiꞌitɨ́j jatzi tɨ triigu jetze meꞌecan. Méjcuaꞌa meꞌɨ́jna ɨ́ atzi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Majta meꞌɨ́n ɨ́ mej jee iꞌi fariseos, matɨ́ꞌɨj huaꞌuseíj mej miyen rɨjcaa, aj mú mi miyen tiraatáꞌixaa meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Casiꞌi, ayée mú hui rɨcɨ aꞌɨ́ɨme ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan. Ayee mú rɨcɨ aꞌij tɨ caí tiuꞌutáꞌaca tɨ jaꞌatɨ́ ayén rɨjca ɨ́ xɨcájraꞌa jaꞌanáj mé jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ fariseos tɨjɨ́n: ―¿Ni secaí múꞌeen jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze aꞌij tɨ yeꞌí huarɨ́j aꞌɨ́jna ɨ́ David teecan tɨ́ꞌɨj huataꞌíꞌicuatacaꞌa, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Aꞌuu pu aꞌuteájrupi u teyujtaꞌa, ɨ́ tɨ jee chiꞌiraꞌan púꞌeen ɨ́ Dios. Ajta áꞌiyen aꞌɨ́ɨ pu ráacua aꞌɨ́jna ɨ́ pan ɨ́ mej Dios huatámuaɨꞌɨvejte, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú majta ráacua. Aꞌɨ́jna ɨ́ pan, aꞌɨ́ɨ muꞌu racuaꞌaca aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe meꞌújna teyujtaꞌa. Capu amɨ́n aꞌij, capu tiꞌitɨ́j jɨ́n auteájturaa aꞌɨ́jna ɨ́ David. ");
INSERT INTO crnNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","’¿Caꞌɨ́n ni secaí jaꞌanáj raꞌujíjve aꞌij tɨ raꞌuyúꞌuxacaꞌa ɨ́ yuꞌuxari jetze aꞌɨ́jna ɨ́ Moisés teecan mej nuꞌu aꞌɨ́ɨme ɨ́ mej títetéꞌuꞌupuꞌu u teyujtaꞌa, aꞌɨ́ɨ mú tíꞌivaɨreꞌe aꞌájna xɨcájraꞌa mé jetzen ruseꞌupi? Mɨ́ majta, camu tiꞌitɨ́j jɨ́n áꞌatura ɨ́ Dios jemi meꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ayee nu tejáꞌamuaꞌixaateꞌe. Inee, i nej yé huaca múꞌejmi jemi, jaítzeꞌe nu veꞌecán jɨ́n tiꞌitéjvee mecaí aꞌɨ́ɨme ɨ́ mej títetéꞌuꞌupuꞌu teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","’Caxu aꞌatzu yaúꞌitɨee xaꞌaraa aꞌij tɨ huataújmuaꞌa aꞌíjna tɨ ayén téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ jɨ́meꞌen yee Dios tɨ raataxájtacaꞌa tɨjɨ́n: “Ayee nu tíꞌijxeꞌeveꞌe mej mi huáꞌancuꞌuvajxɨꞌɨn ɨ́ ruxɨ́ꞌej teɨte. Canu raxɨ́ꞌeveꞌe mej tiuꞌutámuaɨꞌɨvejta.” Naꞌari caí, tɨ puaꞌa siyen tiyaúꞌitɨée xáꞌaraꞌaníicheꞌen, caxu siyen tihuaꞌuxájtziꞌirancheꞌe aꞌɨ́mej ɨ́ mej caí tiꞌitɨ́j jɨ́n auteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","’Aꞌɨ́j pu jɨ́n, inee i nej neajta teáataꞌa jetze airáane, ayée nu ꞌeen jɨ́n antínmuaꞌaree neajta neꞌíjna xɨcájraꞌa jaꞌanáj mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Aj puꞌi Jesús áꞌuraa. Tɨꞌɨj jí aꞌuun teyujtaꞌa aꞌuteájrupi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Aꞌuu pu seɨ́j aꞌutéveecaꞌa tɨ anácɨyaaxaraꞌacaꞌa ɨ́ rumuájcaꞌa jetze. Majta meꞌɨ́n ɨ́ fariseos, aꞌɨ́ɨ mú majta aꞌutéꞌuucaꞌa. Aꞌɨ́ɨ mú rahuaucaꞌa aꞌij mej yeꞌí tiraaxájtziꞌi ɨ́ Jesús. Aꞌɨ́j mú jɨ́n miyen tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús. Miyen tɨjɨ́n: ―¿Ni caí rɨꞌɨrí tej tiyen tiráahuaateꞌen seɨ́j tɨ tíꞌicuiꞌi aꞌájna xɨcájraꞌa tej jetzen taseꞌupi? ");
INSERT INTO crnNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa seɨ́j jaꞌatɨ́ cáneꞌa tícɨitzi, tɨ puaꞌa aꞌɨ́ɨn cáneꞌa atéjveti taꞌatécun aꞌájna matɨ́ꞌɨj puaꞌa ruseꞌupi, ¿ni caí ayén rɨni ɨ́ jaꞌatɨ tɨ u áꞌumeꞌen tɨ́ꞌij raꞌitaján? Jee xaa, ayée xu cheꞌatá senaꞌa rɨcɨ, múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Jéꞌecan pu jaítzeꞌe tíꞌivaɨreꞌe seɨ́j ɨ́ tevi caí ɨ́ cáneꞌa. Aꞌɨ́j pu jɨ́n íꞌirɨꞌɨri tɨ jaꞌatɨ́ ayén tiꞌitɨ́j jɨ́n rɨjca ɨ́ tɨ iꞌi xɨ́ꞌepɨꞌɨn aꞌájna matɨ́ꞌɨj puaꞌa ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aj pu i Jesús ayén tiraatáꞌixaa aꞌɨ́jna tɨ anácɨyaaxaraꞌa ɨ́ rumuájcaꞌa jetze tɨjɨ́n: ―Huatátzeaara muáꞌamuajcaꞌa. Aj pu i aꞌɨ́ɨ pu raatátzeaaracaꞌa ɨ́ rumuájcaꞌa. Jɨ́meꞌen puꞌu ayén huarɨ́j, aj pu i nain jɨ́n huarúj. Ayee pu éeneꞌe jáꞌaraa rɨꞌéeneꞌen tɨ́j ɨ́ seɨj ɨ́ muájcaꞌareꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Matɨ́ꞌɨj mi huiráacɨ aꞌɨ́ɨme ɨ́ fariseos. Aj mú mi autéjhuii mej raaxɨ́ꞌepɨꞌɨntareꞌen aꞌij mej yeꞌí huárɨni mej mi raajéꞌica ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tɨ́ꞌɨj aꞌɨ́ɨn huámuaꞌareeriꞌi aꞌɨ́jna ɨ́ Jesús aꞌij mej tiraaxɨ́ꞌepɨꞌɨntare, aꞌɨ́ɨ pu huirájraa aꞌujna. Jéihua mú teɨte aꞌucɨ́j jamuan. Ajta aꞌɨ́jna ɨ́ Jesús, naíjmiꞌica pu tiúꞌuhuaa ɨ́ mej tíꞌicucuiꞌicaa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ajta ayén tíhuaꞌutaꞌaíj mej mi caí raxájta yee jaꞌatɨ́ tɨ pɨ́rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ayee pu ráaruu ɨ́ Jesús tɨ ij araúrasten aꞌij tɨ ajmíꞌi tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Isaías teecan, ɨ́ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ayen tɨjɨ́n: Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ nevaɨreꞌe ineetzi. Nee nu raꞌantíhuaꞌu. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ nej raxɨ́ꞌeveꞌe, ajta rɨ́ꞌɨ pu tínetáꞌaca. Nexɨejniuꞌuca nu huataꞌíti tɨ áꞌumeꞌen aꞌɨ́jna jamuan. Ajta aꞌɨ́ɨ pu tihuaꞌutáꞌixaateꞌesin aꞌɨ́mej ɨ́ mej caí Israél jetze ajtémeꞌecan tɨ tihuáꞌacɨꞌɨti nainjapua ɨ́ tɨ iꞌi xɨ́ꞌepɨꞌɨn neetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Capu ajta aꞌɨ́ɨn ruhuavíiraꞌa aꞌame; capu ajta jiihua aꞌame. Camu ranamuajran tɨ tiꞌixáata aꞌame aꞌájna caaye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Capu huaꞌutamuárɨꞌeristeꞌesin aꞌɨ́mej ɨ́ mej huápɨꞌɨ tirajpuaíjtzicaꞌa tɨ́j piꞌista mej raꞌavéꞌetzi nainjapua. Capu huápɨꞌɨ puaíjtzi huaꞌutáꞌasin ɨ́ mej caí chéꞌe téꞌeviicuaꞌi aꞌɨ́mej ɨ́ mej miyen ꞌeen tɨ́j taij tɨ cɨ́j caj áꞌataꞌa. Aꞌɨ́ɨ pu huáꞌa japua huatániuusin ajta naꞌa caí tiuꞌutémuaꞌitɨn aꞌɨ́jna jɨmeꞌe tɨ naíjmiꞌica ruxɨ́ꞌej tiuꞌutaꞌaíjteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Majta matɨ́j menaꞌa puaꞌamé ɨ́ teɨtejraꞌa ɨ́ mej yen japuan seijreꞌe íiyen chaanaca japua, naímiꞌi mú tíꞌijchuꞌeveꞌen niuucajtzeꞌen. Ayee pu jɨ́meꞌen tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Isaías teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Matɨ́ꞌɨj mi seɨ́j mú aꞌaráaviꞌitɨ ɨ́ Jesús jemi tɨ tiyaaruꞌu tzajtaꞌan seijreꞌecaꞌa. Aꞌɨ́j pu jɨ́n caí atáneericaꞌa, ajta caí téꞌanrɨꞌɨrejcaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. Tɨꞌɨj jí Jesús tiráahuaa tɨ́ꞌij teꞌanrɨꞌɨrée áꞌaraꞌani, ajta tɨ́ꞌij huiteánamuáara áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Majta meꞌɨ́n ɨ́ teɨte, naímiꞌi mú rɨ́ꞌɨ teꞌutaseíj. Miyen tɨjɨ́n: ―¿Ni qui amɨ́ aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan? ");
INSERT INTO crnNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Majta meꞌɨ́n ɨ́ fariseos, matɨ́ꞌɨj ráanamuajriꞌi, ayée mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Amɨ́jna mɨ jaꞌatɨ́, Beelzebú pu jetzen araújcaꞌane tɨ́ꞌij ayén huaꞌutamuáriteꞌen aꞌɨ́mej ɨ́ tiyáaruꞌuse, aꞌɨ́ɨme ɨ́ tɨ ajta Beelzebú tihuáꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ajta aꞌɨ́jna ɨ́ Jesús, aꞌɨ́ɨ pu ramuaꞌareerecaꞌa aꞌij mej tíꞌimuaꞌatzejcaꞌa. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa aꞌɨ́ɨme ɨ́ mej meꞌuun seɨ́j chuéjraꞌa japua aꞌuchéjme jáꞌitaꞌa maꞌutácɨɨne, tɨ puaꞌa miyen huárɨni aj mú mi huaténeꞌuseꞌesin, ajta aꞌɨ́jna ɨ́ chuéjraꞌa, capu chéꞌe áꞌateeri. Ajta tɨ puaꞌa miyen cheꞌatá menaꞌa jáꞌitaꞌa aꞌutácɨɨne aꞌɨ́ɨme ɨ́ mej seɨ́j japua ɨ́ chajtaꞌa aꞌuchéjme, naꞌari teɨtestemuaꞌameꞌen seɨ́j ɨ́ jaꞌatɨ, camu chéꞌe áꞌateeri. ");
INSERT INTO crnNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","’Ayee pu cheꞌatá naꞌa ꞌeen, tɨ puaꞌa aꞌɨ́ɨn Satanás huaꞌutamuáriteꞌen ɨ́ ruteɨ́testemuaꞌa, tɨ puaꞌa majta miyen huaꞌuténeꞌusiꞌiteꞌesin ɨ́ ruteɨ́testemuaꞌa, aꞌɨ́ɨ pu ajta caí chéꞌe áꞌateere, sino teꞌentipuáꞌari. ");
INSERT INTO crnNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ari inee, tɨ puaꞌa niyen yee Beelzebú nu jetze aráncaꞌane nej huaꞌutamuáriteꞌen ɨ́ tiyaaruꞌu, ¿ni tzaa miyen cheꞌatá menaꞌa Beelzebú jetze rucaꞌané aꞌɨ́ɨme ɨ́ áꞌamuaxɨꞌej teɨte mej mi miyen cheꞌatá menaꞌa huaꞌutamuáriteꞌen? Aꞌɨ́ɨme ɨ́ áꞌamuaxɨꞌej teɨte mú miyen raataxáj yee múꞌeen xu seajta siyen rɨcɨ seꞌɨ́jna jɨmeꞌe aꞌij sej tíꞌinexajtziꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Naꞌari caí, tɨ puaꞌa niyen neꞌɨ́jna jetze aráncaꞌane ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, nej ni tiyaaruꞌu huatamuáriteꞌen, puꞌuri aꞌájna tejaꞌuréꞌene tɨ Dios tiuꞌutaꞌaíjta ɨ́ aꞌamua tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Ajta, tɨ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ tiraanáhuaꞌi tiꞌáꞌaraꞌan á táꞌache ɨ́ jaꞌatɨ tɨ rucaꞌané, ayée pu ruxeꞌeveꞌe tɨ amuacaícan raꞌatéjɨꞌɨcɨꞌen aꞌɨ́jna tɨ rucaꞌané. Aj pu i xaa rɨꞌɨrí tɨ aꞌuteárute á aꞌutɨ́ éꞌeche tɨ ij tiraanáhuaꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Aꞌɨ́jna tɨ caí ne jamuan áꞌucheꞌecan, aꞌɨ́ɨ pu néjchaꞌɨɨreꞌe. Ajta, aꞌɨ́ɨn tɨ caí huaꞌajséꞌɨri ɨ́ teɨte neetzi jemi, aꞌɨ́ɨ pu huaꞌuréꞌeꞌiteca. ");
INSERT INTO crnNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Aꞌɨ́j nu jɨ́n, ayée nu tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna aꞌɨ́jna jɨmeꞌe ɨ́ teteca. Iꞌirɨꞌɨri tɨ tihuaꞌutáꞌuuniꞌi naíjmiꞌica ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi, ajta naíjmiꞌica jemi ɨ́ mej aꞌij puaꞌa tiꞌixa. Aru tɨ puaꞌa aꞌij puaꞌa tíꞌixajta aꞌɨ́jna jetze ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, capu xaa neꞌu jaꞌanáj tiraatáꞌuuniꞌira aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","’Jaꞌatɨ́ tɨ naꞌa tɨ ayén aꞌij puaꞌa tíꞌinexajta ineetzi i nej neajta teáataꞌa jetze airáane, aꞌɨ́ɨ pu xaa tiraatáꞌuuniꞌira. Mɨ́ ajta, jaꞌatɨ́ tɨ naꞌa tɨ aꞌij puaꞌa tíꞌixajta aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, capu jaꞌanáj tiraatáꞌuuniꞌira, sino aꞌɨ́ɨ pu ruꞌitéꞌaa aꞌame nain xɨcaj tzajtaꞌa tɨ yú aucaꞌitɨ́ aꞌame tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tɨ́ puaꞌa hui tɨ rɨ́ꞌen ɨ́ cɨyej, rɨꞌéeneꞌen pu tacaꞌa, ajta tɨ puaꞌa caí rɨ́ꞌen ɨ́ cɨyej, capu rɨꞌéeneꞌen tacaꞌa. Ayee xu ꞌeen jɨ́n ramuaꞌareere tɨ puaꞌa cɨyej rɨꞌéeneꞌen nusu caí seꞌɨ́jna jɨmeꞌe aꞌij tɨ éeneꞌen tacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Múꞌeen xu seꞌíjna jetze huanéj aꞌɨ́jna ɨ́ cuꞌucuꞌu tɨ tíꞌihuaꞌitaca, aꞌiné huápɨꞌɨ xu aꞌij puaꞌa tíꞌiteteɨte. Capu xaa neꞌu aꞌij tíꞌirɨꞌɨri sej siyen tiꞌitɨ́j huataxáj aꞌij tɨ tiraavíjteꞌe. Ayee puꞌu, aꞌiné seɨ́j pu ayén tíꞌixaxaꞌa aꞌij tɨ ayén tíꞌimuaꞌatze ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ajta aꞌɨ́ɨn tɨ rɨ́ꞌɨ tíꞌitevij, aꞌɨ́ɨ pu ayén tíꞌixaxaꞌa ɨ́ tɨ iꞌi xɨ́ꞌepɨꞌɨn jɨmeꞌe aꞌiné rúꞌumuaꞌaree ɨ́ ru tzajtaꞌa jeíhua ɨ́ tɨ iꞌi xɨ́ꞌepɨꞌɨn. Ayen cheꞌatá naꞌa, ɨ́ tɨ aꞌij puaꞌa tíꞌitevij, aꞌɨ́ɨ pu aꞌij puaꞌa tíꞌixaxaꞌa aꞌiné jeíhua pu tirúꞌumuaꞌaree ɨ́ ru tzajtaꞌa ɨ́ tɨ aꞌij puaꞌa ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén téꞌeme aꞌájna xɨcájraꞌa tɨ jetzen Dios huáꞌaxɨjteꞌen matɨ́j menaꞌa puaꞌamé yé aꞌuchéjme íiyen chaanaca japua. Ayee pu ruxeꞌeveꞌe aꞌame mej miyen tiuꞌutetzáahuateꞌen ɨ́ Dios jemi nain ɨ́ mej jɨ́n tiuꞌutaxájtacaꞌa cháꞌa menaꞌa, seɨj majta seɨj. ");
INSERT INTO crnNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dios pu rɨ́ꞌɨ tíꞌimuaxɨꞌepɨꞌɨntareꞌe aꞌɨ́jna jɨmeꞌe aꞌij pej tíꞌixaxaꞌataꞌa, naꞌari caí, aꞌɨ́ɨ pu muáꞌaxɨjteꞌen aꞌɨ́jna jɨmeꞌe aꞌij pej tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Aj mú mi meꞌɨ́n ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, aꞌɨ́ɨ mú miyen tiraatáꞌixaa tɨjɨ́n: ―Maeestru, ayée tu tíꞌijxeꞌeveꞌe pej tiꞌitɨ́j taataseíjrateꞌen ɨ́ tej jɨ́n ráamuaꞌaree tɨ júteꞌe éꞌemeꞌecan ɨ́ Dios jemi aꞌij pej yeꞌí rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨme i teɨtejraꞌa ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte, ayée mú tíꞌinehuavii nej tiꞌitɨ́j huaꞌutaseíjrateꞌen ɨ́ mej jɨ́n rɨ́ꞌɨ teꞌutaseíj matáꞌaj nuꞌu ráamuaꞌaree nej Dios jetze aráncaꞌane. Ayee mú cheꞌatá menaꞌa rɨcɨ tɨ́j ɨ́ jaꞌatɨ tɨ ruꞌɨ́j mé úurɨe. Canu tiꞌitɨ́j huaꞌutaseíjrateꞌesin sino aꞌii nuꞌu aꞌij tɨ tiráaruu aꞌɨ́jna ɨ́ Jonás teecan, aꞌɨ́jna tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","’Tɨ́ꞌɨj aꞌɨ́jna ɨ́ Jonás aꞌuun éꞌejve aꞌu tɨ aúnee ɨ́ huaꞌí, aꞌɨ́ɨ pu huaꞌí yáꞌunɨjcua. Aꞌuu pu u éꞌetee huaíca xɨcaj tzajtaꞌa, ajta huaíca tɨ́caꞌari tzajtaꞌa tɨ arájca ɨ́ jucáaraꞌan tzajtaꞌa aꞌɨ́jna ɨ́ huaꞌí tɨ yáꞌunɨjcua. Ayee pu cheꞌatá naꞌa tíꞌineruuren ineetzi i nej neajta teáataꞌa jetze airáane. Aꞌuu nu aracaꞌitɨ́ naꞌame chuej tzajtaꞌa huaíca xɨcaj tzajtaꞌa, neajta huaíca tɨ́caꞌari tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","’Ayee nu hui tejáꞌamuaꞌixaateꞌe, aꞌájna xɨcájraꞌa tɨ jetzen Dios amuáꞌaxɨjteꞌen yee xɨ́ꞌepɨꞌɨn xu huarɨ́j nusu yee caxu xɨ́ꞌepɨꞌɨn huarɨ́j, aꞌɨ́ɨme ɨ́ mej u Nínive éꞌechejcaꞌa, aꞌɨ́ɨ mú aꞌuun aꞌutéhuiixɨꞌɨsin múꞌejmi jamuan, majta tejáꞌamuaxɨꞌepɨꞌɨntariꞌireꞌen múꞌeen mɨ sej uꞌuche íjii. Ayee pu téꞌeme aꞌɨ́jna jɨmeꞌe ɨ́ mej seɨcɨé tiuꞌumuáꞌaj aꞌɨ́ɨme ɨ́ mej Nínive éꞌechejcaꞌa matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa meꞌɨ́jna ɨ́ Jonás teecan. ’Mɨ́ neajta inee, i nej yé huaca múꞌejmi jemi, jaítzeꞌe nu veꞌecán jɨ́n tiꞌitéjvee caí aꞌɨ́jna ɨ́ Jonás teecan. Mɨ́ seajta múꞌeen, caxu naꞌaráꞌastijreꞌesin ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ajta hui, aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa teecan tɨ ajmíꞌi tíꞌaijtacaꞌa úute pújmeꞌen, aꞌɨ́ɨ pu ajta huatéchaxɨjsin múꞌejmi jemi, ajta aꞌɨ́ɨ pu ajta tejáꞌamuaxɨꞌepɨꞌɨntariꞌireꞌen múꞌeen, mɨ sej uꞌuche íjii aꞌájna xɨcájraꞌa jetze mej aꞌutájeeviꞌihua teɨte. Ayee pu téꞌeme aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn aꞌɨmuá aꞌuvéꞌemej tɨ́ꞌij ayén ráanamua aꞌɨ́jna ɨ́ Salomón teecan tɨ nuꞌu huápɨꞌɨ rɨ́ꞌɨ mé teuúmuaꞌaree. ’Mɨ́ neajta inee, i nej yé huaca múꞌejmi jemi, jaítzeꞌe nu veꞌecán jɨ́n tiꞌitéjvee caí aꞌɨ́jna ɨ́ Salomón teecan. Mɨ́ seajta múꞌeen, caxu naꞌaráꞌastijreꞌesin ineetzi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ajta ayée pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Tɨ́ puaꞌa seɨ́j xɨéjniuꞌucari tɨ tiúꞌujxanaꞌacɨraꞌate, tɨ puaꞌa huiirájraꞌani tzajtaꞌan seɨ́j ɨ́ tevi, aꞌɨ́ɨ pu áꞌucheꞌecaneꞌe aꞌame tɨ rahuauhuau aꞌu tɨ aꞌuhuáchi tɨ́ꞌij huaújseꞌupeꞌen. Tɨ́ꞌɨj caí rateuveꞌen, ayée pu tíꞌimuaꞌati tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nicheꞌe huaréꞌaraꞌani nehuáritaꞌa u niche aꞌu nej aꞌarájraa.” Tɨ́ꞌɨj aveꞌeréꞌenen, ayée pu éeneꞌen teuni aꞌɨ́jna ɨ́ jaꞌatɨ, tɨ naa uhuaꞌéꞌeneꞌe aꞌame ɨ́ ru tzajtaꞌa. Cu xɨee mej mauchén uhuaréꞌeꞌichaꞌutacaꞌa u chiꞌita, majta naa rɨ́ꞌɨ ruꞌuhuáruu. ");
INSERT INTO crnNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","’Aj pu i aꞌɨ́ɨn ɨ́ xɨéjniuꞌucari, aꞌɨ́ɨ pu hui huajaꞌuvéꞌeviꞌitɨ ɨ́ seica, ɨ́ mej aráhuaꞌapua aráꞌase, aꞌɨ́mej ɨ́ mej jaítzeꞌe aꞌij puaꞌa ꞌéꞌen caí ɨ́ seɨj. Aj mú mi uteáruti naímiꞌi mej mi meꞌuun huatéꞌe muáꞌaraꞌani meꞌɨ́jna tzajtaꞌa ɨ́ tevi. Ajta áꞌiyen, ayén teꞌiráame tɨ jaítzeꞌe aꞌij puaꞌa ꞌéeneꞌe áꞌaraꞌani aꞌɨ́jna ɨ́ tevi caí tɨ́j ajmíꞌi ꞌéeneꞌe. Ayee pu tihuáꞌacɨꞌɨti aꞌímej i mej aꞌij puaꞌa tíꞌiteteɨte ɨ́ mej uꞌuche íjii. ");
INSERT INTO crnNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Aúcheꞌe pu tíꞌixajtacaꞌa aꞌɨ́jna ɨ́ Jesús matɨ́ꞌɨj meꞌuun aꞌaráꞌa aꞌɨ́jna ɨ́ náànajraꞌan, majta ɨ́ ihuáamuaꞌameꞌen. Aa mú aꞌutéhuiixɨ puaꞌacɨé. Méjxeꞌeveꞌecaꞌa mej tiuꞌutaxáj jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aj pu i seɨ́j ayén tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―A mú puaꞌacɨé aꞌutéꞌuu aꞌanáàna, majta aꞌihuáamuaꞌa. Mémuahuahuau mej nuꞌu tiuꞌuxáj á jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Aj pu i ayén tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Aꞌataani mej púꞌeen ɨ́ nináàna, nusu ɨ́ neꞌihuaamuaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aj pu i rumuájcaꞌa jɨ́n huaꞌutaseíjra ɨ́ mej aiitecaíjme. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej jee nináàna púꞌeen naꞌari neꞌihuaamuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ayee puꞌu hui tíꞌeen, aꞌiné aꞌachú mej puaꞌamé miyen rɨcɨ aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej jee nináàna nusu aꞌɨ́ɨme ɨ́ nejaꞌatzimuá, naꞌari necuꞌutzimuá o nejúutzimuaꞌa. Yee puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Aꞌájna xɨcájraꞌa jetze, Jesús pu huirájraa u chiꞌita. Aꞌuu pu aꞌaráꞌa aꞌájna tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj. Aa pu aꞌutayeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Aj mú mi jeíhua ajteáxɨɨrecaꞌa ɨ́ teɨte aꞌu tɨ aꞌij éꞌeneꞌe. Temuaꞌa mú tíꞌitemuꞌiicaa ɨ́ teɨte. Aꞌɨ́j pu jɨ́n ateájraa baarcu jetze tɨ jaataꞌa eꞌecáveꞌecaꞌa. Aꞌuu pu i eꞌerácatii. Majta meꞌɨ́n ɨ́ teɨte, áa mú aꞌucaíjmeꞌecaa jaꞌapuaíri japua á vejliꞌi aꞌu tɨ ɨ́ jaj. ");
INSERT INTO crnNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ajta áꞌiyen tihuaꞌajmuáꞌate seɨ́j chuijtari jɨmeꞌe. Ayen tɨjɨ́n: ―Jaꞌatɨ́ hui tɨ tíꞌihuastehuaꞌa, u pu áꞌume tɨ tejéꞌehuasteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aa pu auméꞌecaa ratáhuaꞌanáa imueꞌeri. Seica pu i imueꞌeri juye jetze huavatzɨ́jraa. Aj mú mi pinaꞌase júteꞌɨmua aveꞌecáane, meraaréꞌejeꞌipɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ajta seica pu huavatzɨ́jraa tetej tzajtaꞌa aꞌu tɨ caí jeíhua chuej áꞌuca. Aj puꞌi huaréꞌehuaa, aꞌiné capu huatétee ɨ́ chuej tɨ aꞌucárutixɨꞌɨn ɨ́ naanaꞌaraꞌan. Tɨ́ꞌɨj huaréꞌepɨstacaꞌa ɨ́ chuej, aj pu i caꞌanacan ajnéj ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ajta tɨ́ꞌɨj u eꞌiréꞌene ɨ́ xɨca, aj puꞌi huaréꞌehuaa ɨ́ xɨcaj jɨmeꞌe ɨ́ tɨ huanéj. Aꞌɨ́j pu jɨ́n jij huaréꞌehuaa aꞌiné capu ajtanáanaꞌajmeꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","’Ajta seica ɨ́ imueꞌeri, aꞌúu pu aꞌuvatzɨ́jraa aꞌu tɨ aꞌutzícareꞌeme. Tɨ́ꞌɨj aꞌɨ́ɨn tzicareꞌe huavaújse, aꞌɨ́ɨ pu i raꞌaváꞌana ɨ́ tɨ tíꞌihuastiꞌihuacaꞌa. Aꞌɨ́j pu jɨ́n caí huácɨɨrecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","’Aru seica pu huavatzɨ́jraa aꞌu tɨ aꞌurɨ́ꞌen ɨ́ chuej. Aꞌɨ́ɨ pu xaa i ajnéj. Tɨꞌɨj jí huavaújse. Temuaꞌa puꞌi tiúꞌucɨɨrecaꞌa. Seica pu imueꞌeri, ayén airájraa tɨ huácɨɨrecaꞌa seɨj ajta seɨj tɨ ajnéj aꞌachú cumu anxɨ́te ɨ́ atzi tɨ catéꞌetejmeꞌecaa. Ajta seica, ayén tiúꞌucɨɨrecaꞌa aꞌachú cumu huaícate. Ajta seica, seité japuan tamuáamuataꞌa pu catéꞌetejmeꞌecaa seɨj ajta seɨj. ");
INSERT INTO crnNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","’Mɨ́ sej huiteánajcaꞌamua, xáanamuajriꞌi hui temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aj mú mi ajteáxɨɨrecaꞌa á vejliꞌi jemin ɨ́ Jesús aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n piyen tihuaúꞌixaateꞌe ɨ́ teɨte chuijtari jɨmeꞌe tɨ caí jaꞌatɨ́ yaúꞌitɨe? ");
INSERT INTO crnNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aj pu i ayén tiuꞌutaniú tɨjɨ́n: ―Múꞌejmi pu Dios tejáꞌamuaꞌixaateꞌe eꞌehuauritɨéecan jɨmeꞌe aꞌɨ́jna tɨ rúꞌavaa aꞌɨ́jna jɨmeꞌe tɨ Dios ari tíꞌaijta nainjapua íiyen chaanaca japua, ajta u ta japua. Mɨ́ majta aꞌɨ́ɨme ɨ́ seica, capu aꞌatzu rɨꞌɨrí mej mi yaúꞌitɨée muáꞌaraꞌani aꞌiné capu Dios ayén huaꞌutáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","’Ayee pu tíꞌeen: jɨ́meꞌen aꞌɨ́jna ɨ́ jaꞌatɨ tɨ áꞌujcaꞌane tɨ ayén cɨ́j caj tiyaúꞌitɨée áꞌaraꞌani ɨ́ Dios jemi, Dios pu jeíhua huápɨꞌɨ raatáꞌasin aꞌɨ́jna. Ajta aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí áꞌujcaꞌane tɨ jaítzeꞌe yaúꞌitɨée áꞌaraꞌani ɨ́ Dios jemi, Dios pu ráꞌariꞌira aꞌachú tɨ caj ari tirúꞌumuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe chuijtari jɨmeꞌe mej mi caí yaúꞌitɨée muáꞌaraꞌani. Ayee pu tíꞌeen aꞌɨ́mej jemi. Aꞌɨ́ɨ mú mé uunéjneꞌe, aru camu tiꞌitɨ́j seɨj. Majta mú tíꞌinamua, aru camu tiꞌitɨ́j namua. Camu majta yaúꞌitɨe. ");
INSERT INTO crnNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","’Ayee pu ari araúraste huáꞌa jemi aꞌij tɨ raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Isaías teecan, ɨ́ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan tɨjɨ́n: Múꞌeen xu xaa ráanamua tɨ́j naꞌa tɨ i yú auumé. Mɨ́ seajta múꞌeen, caxu yaúꞌitɨée xáꞌajuꞌun. Múꞌeen xu xaa mé uunéjneꞌeri xáꞌajuꞌun. Mɨ́ seajta, caxu tiꞌitɨ́j seijran. ");
INSERT INTO crnNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ayee tíꞌeen, aꞌiné aꞌɨ́ɨ mú jemin antaújnaamua ɨ́ ru tzajtaꞌan. Cɨ́j muꞌu caj títeꞌiteánajcaꞌamua. Camu áꞌujcaꞌane mej aꞌatanéjneꞌere mej raaseíj tiꞌitɨ́j tɨ pɨ́rɨcɨ. Naꞌari caí, aꞌɨ́ɨ mú yaúꞌitɨée muáꞌajuꞌun. Majta mú mé uunéjneꞌeri muáꞌajuꞌun mej raaseíj tiꞌitɨ́j tɨ pɨ́rɨcɨ. Majta mi ráꞌastijreꞌe muáꞌajuꞌun ɨ́ mej ranamua. Majta mú neetzi jemi yé veꞌeréꞌeninéica muáꞌajuꞌun nej ni tihuaꞌutáꞌuuniꞌi. Ayee pu jɨ́meꞌen raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Isaías teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Mɨ́ seajta múꞌeen i sej áꞌujujhuaꞌan ne jamuan, setáꞌaj huataújtemuaꞌaveꞌen seꞌɨ́jna jɨmeꞌe ɨ́ sej huiteánajcaꞌamua sej si raꞌaráꞌastijreꞌen ɨ́ sej ranamua, seajta ahuaújcaꞌanen sej aꞌatanéjneꞌere sej si raaseíj tiꞌitɨ́j tɨ pɨ́rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, muꞌiitɨ́ ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨtestacaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan, jeíhua mú raxɨ́ꞌeveꞌecaꞌa mej miyen tiuꞌuséij aꞌij sej seri tíꞌiseij inee jemi. Mɨ́ majta, camu aꞌatzu raaseíj. Ayee mú cheꞌatá menaꞌa tíꞌijxeꞌeveꞌecaꞌa mej miyen ráanamua aꞌij sej seri tíꞌinamua inee jemi. Mɨ́ majta, camu xaa neꞌu ráanamuajriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Casiꞌi, xáanamuajriꞌi aꞌij tɨ huataújmuaꞌa i chuijtari tɨ jɨ́meꞌen raxa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ raahuáste ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tɨ́ puaꞌa jaꞌatɨ́ ráanamua ɨ́ niuucari tɨ jɨ́meꞌen raxa Dios tɨ tíꞌaijta nainjapua íiyen chaanaca japua, ajta u ta japua, tɨ puaꞌa aꞌɨ́ɨn caí yaúꞌitɨee, aꞌɨ́jna tɨ aꞌij puaꞌa ꞌeen, aꞌɨ́ɨ pu tzajtaꞌan huataseíjreꞌesin. Aj pu i ráꞌariꞌira ɨ́ niuucari tɨ rúꞌumuaꞌareerecaꞌa. Aꞌɨ́jna ɨ́ jaꞌatɨ, ayée pu ꞌeen tɨ́j ɨ́ imueꞌeri tɨ huavatzɨ́jraa aꞌájna juye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","’Ajta, aꞌɨ́jna ɨ́ imueꞌeri tɨ huavatzɨ́jraa ɨ́ tete tzajtaꞌa, ayée pu ꞌeen tɨ́j ɨ́ jaꞌatɨ tɨ amuacaí raꞌaránajchecaꞌa ɨ́ tɨ ráanamuajriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Aru capu tiꞌitɨ́j japuan ninei aꞌɨ́jna ɨ́ jaꞌatɨ. Tɨ́ puaꞌa aꞌatzu rajpuaíitzi aꞌɨ́jna jɨmeꞌe mej seica ráꞌaxɨeehuariꞌira meꞌɨ́jna jɨmeꞌe tɨ naꞌaráꞌastijreꞌe ineetzi, naꞌari tɨ puaꞌa seica aꞌij puaꞌa méraruure, cɨ́j puꞌu teꞌevíicuaꞌira aꞌame. Caꞌanacan pu mé nejaúujɨsin. ");
INSERT INTO crnNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","’Aꞌɨ́jna tɨ hui huavatzɨ́jraa aꞌu tɨ aꞌutzícareꞌeme, aꞌɨ́ɨ pu ayén ꞌeen tɨ́j seɨ́j ɨ́ tevi tɨ xaa ranamua ɨ́ niuucari. Aru jeíhua pu tíꞌimuajca aꞌɨ́jna jɨmeꞌe aꞌij tɨ téꞌeme íiyen chaanaca tej japuan seijreꞌe. Ajta, nain tɨ tíꞌijchaꞌɨɨ, aꞌɨ́ɨ pu raamuáꞌitɨ aꞌɨ́jna ɨ́ tevi. Aꞌɨ́j pu jɨ́n, caí chéꞌe raꞌutámuaꞌareeriꞌi aꞌij tɨ tiráanamuajriꞌi. Capu ajta chéꞌe rɨꞌɨrí tɨ aꞌɨ́ɨn tevi ayén raatévaɨreꞌen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","’Ajta aꞌɨ́jna ɨ́ imueꞌeri tɨ huavatzɨ́jraa japuan ɨ́ chuej tɨ huarɨ́ꞌen, ayée pu ꞌeen tɨ́j ɨ́ jaꞌatɨ tɨ yaúꞌitɨe tɨ́ꞌɨj ráanamua ɨ́ niuucari. Jéihua pu tíꞌijvaɨreꞌe ɨ́ Dios. Yee pu tiraatátuiireꞌesin ɨ́ Dios jemi tɨ́j aꞌɨ́jna ɨ́ imueꞌeri tɨ huácɨɨrecaꞌa aꞌachú cumu anxɨ́te tɨ catéꞌetejmeꞌecaa, naꞌari huaícate caꞌɨ́n seité japuan tamuáamuataꞌa ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ajtahuaꞌa seɨ́j ayén tihuaꞌutáꞌixaa ɨ́ chuijtari jɨmeꞌe aꞌɨ́jna ɨ́ Jesús. Ayen tɨjɨ́n: ―Ayee pu tíꞌirɨneca íjii Dios tɨ tíꞌaijta íiyen chaanaca japua, ajta u ta japua. Jaꞌatɨ́ pu imueꞌeri huahuáste japuan ɨ́ ruchuej tɨ huarɨ́ꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ajta áꞌiyen matɨ́ꞌɨj naíjmiꞌi tícuꞌutzucaꞌa, seɨ́j pu hui aveꞌeréꞌene tɨ rájchaꞌɨɨreꞌe aꞌɨ́jna tɨ chuej tíchaꞌɨɨ. Ajta aꞌɨ́ɨn tɨ rájchaꞌɨɨreꞌe, aꞌɨ́ɨ pu ɨxaj huahuáste tzajtaꞌan aꞌɨ́jna ɨ́ triigu. Aj pu i áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","’Aj pu i ajnéj aꞌɨ́jna ɨ́ triigu, ajta aꞌɨ́jna ɨ́ ɨxaj. Tɨ́ꞌɨj huavaújse, aj pu i huíjmuaiyuxɨ aꞌɨ́jna ɨ́ triigu. Aj mú mi ráamuaꞌareeriꞌi tɨ ajta seɨ́j huáviviihuacaꞌa ɨ́ imueꞌeri aꞌiné capu huíjmuaiyuxɨ aꞌɨ́jna ɨ́ ɨxaj. ");
INSERT INTO crnNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Majta meꞌɨ́n ɨ́ mej tíꞌimuarɨꞌe, aꞌúu mú hui áꞌujuꞌun mej mi tiraataꞌixaateꞌen aꞌɨ́jna tɨ chuej tíchaꞌɨɨ. Miyen tɨjɨ́n: “Tavastaraꞌa, tɨ puaꞌa peꞌɨ́n huahuáste imueꞌeri tɨ rɨ́ꞌen aꞌujna áꞌa chuej japua, ¿aꞌuné eꞌejnéj aꞌɨ́jna ɨ́ ɨxaj?” ");
INSERT INTO crnNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","’Aj pu i aꞌɨ́jna tɨ chuej tíchaꞌɨɨ, ayén tihuaꞌutáꞌixaa tɨjɨ́n: “Seɨ́j tɨ néjchaꞌɨɨreꞌe ayée pu náaruu.” Majta miyen tiraataꞌíhuaꞌuriꞌi aꞌɨ́ɨme ɨ́ mej tíꞌimuarɨꞌe miyen tɨjɨ́n: “¿Ni muaꞌaráanajche tej u áꞌujuꞌun tej ráꞌijcuuxɨn teꞌɨ́jna ɨ́ ɨxaj?” ");
INSERT INTO crnNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","’Aj pu i ayén tiuꞌutaniú tɨjɨ́n: “Capu ruxeꞌeveꞌe sej racuta seꞌɨ́jna ɨ́ ɨxaj, aꞌiné tɨ puaꞌa seri ráꞌijcuunan aꞌɨ́jna ɨ́ ɨxaj, ajta pu áijcuuxɨjsin aꞌɨ́jna ɨ́ triigu aꞌiné ru jetze pu huáꞌuu. ");
INSERT INTO crnNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chéꞌe ayén éeneꞌen tɨ naíjmiꞌi huavaújseꞌen ajta caí tejaꞌuréꞌenen tɨ teꞌentiꞌáꞌasin. Aj nu ni huaꞌutaꞌaíjteꞌesin aꞌɨ́mej ɨ́ mej tíꞌimɨjhuaca mej mi amuacaí ráꞌijcuuxɨn meꞌɨ́jna ɨ́ ɨxaj, matáꞌaj raajɨ́ꞌɨcɨꞌen mej mi rájseɨreꞌen matáꞌaj raꞌanteátaira. Majta áꞌiyen, meꞌɨ́n meruꞌuteátuaasin meꞌɨ́jna ɨ́ triigu u chiꞌita, aꞌu mej téjéꞌeyuuhuaca.” ");
INSERT INTO crnNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús pu ajtahuaꞌa seɨ́j huaꞌutáꞌixa ɨ́ chuijtari. Ayen tɨjɨ́n: ―Ayee pu tíꞌeen Dios tɨ tíꞌaijta íiyen chaanaca japua, ajta u ta japua. Ayee pu ꞌeen tɨ́j tuꞌupi tiꞌitɨ́j tɨ ayén ántehuaa tɨjɨ́n mostasa. Jaꞌatɨ́ pu raahuáste ɨ́ játzeꞌaraꞌan aꞌájna jáꞌahuaꞌa aꞌu tɨ téꞌatachuej. ");
INSERT INTO crnNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Aꞌɨ́jna ɨ́ mostasa, ayée pu ꞌeeneꞌen téjatzeꞌe tɨ jaítzeꞌe iꞌi cɨ́lieen caí seica ɨ́ jatzi. Mɨ́ ajta, tɨ́ꞌɨjtá huavaújseꞌen, jaítzeꞌe pu ajtɨ́tɨꞌɨ aꞌame caí seica ɨ́ tuꞌupi tɨ íiyen seijreꞌe chaanaca japua. Yee pu ajtɨ́tɨꞌɨ aꞌame tɨ́j cɨyej. Aj mú mi aveꞌeréꞌenejsin ɨ́ pinaꞌase mej ráꞌaraꞌa mej mi án téjaꞌuteúruꞌituꞌajteꞌen án cɨ́yeꞌaraꞌan jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ajtahuaꞌa seɨ́j chuijtari huaꞌutáꞌixa. Ayen tɨjɨ́n: ―Ayee pu ajta tíꞌeen jɨ́meꞌen Dios tɨ tíꞌaijta íiyen chaanaca japua, ajta u ta japua. Ayee pu ꞌeen tɨ́j aꞌɨ́jna ɨ́ levadura. Aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu huaíca medida ruꞌuteájraa ɨ́ hariina. Aj pu i rajcuaíjtzitacaꞌa levadura jamuan. Ajta aꞌɨ́ɨn ɨ́ levadura, aꞌɨ́ɨ pu tzajtaꞌan huaneájxɨ nainjapua ɨ́ cuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tiꞌitɨ́j tɨ naꞌa tɨ tihuáꞌaꞌixaꞌatehuaꞌa ɨ́ teɨte, Jesús pu nain tihuaꞌutáꞌixaa chuijtari jɨmeꞌe. Capu tiꞌitɨ́j huáꞌaꞌixaateꞌecaꞌa tɨ éꞌehuáuritɨe sino chuijtari puꞌu jɨ́meꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ayee pu tiúꞌuruu tɨ ij ayén araúrasten aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan tɨjɨ́n: Nee nu tihuaꞌutáꞌixaateꞌesin neꞌɨ́jna jɨmeꞌe ɨ́ chuijtari. Nee nu neꞌɨ́jna huataxájta, aꞌɨ́jna tɨ rúꞌavaa nain xɨcaj tzajtaꞌa tɨ yú eꞌiréꞌene tɨ́ꞌɨj Dios raatétaahuacaꞌa aꞌíjna i chaanaca tej japuan yen seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aj pu i Jesús airájraa ɨ́ teɨte jemi. Aj pu i uteájrupi u chiꞌita. Aꞌuu mú ajteáxɨɨrecaꞌa jemin aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: ―Aisí, taatáꞌixaateꞌe aꞌij tɨ huataújmuaꞌa aꞌɨ́jna ɨ́ chuijtari aꞌɨ́jna tɨ jɨ́meꞌen raxa ɨ́ ɨxaj tɨ huavaújse aꞌu tɨ eꞌejnéj taséehua japua. ");
INSERT INTO crnNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́jna ɨ́ tɨ raahuáste ɨ́ imueꞌeri tɨ rɨ́ꞌen, nee nu neꞌɨ́n púꞌeen, inee i nej neajta teáataꞌa jetze airáane. ");
INSERT INTO crnNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ajta aꞌɨ́jna ɨ́ taséehua, ayée pu huataújmuaꞌa tɨjɨ́n ɨ́ chaanaca i tej japuan yen iꞌi seijreꞌe. Aꞌɨ́jna ɨ́ imueꞌeri tɨ rɨ́ꞌen, ayée pu ꞌeen tɨ́j aꞌɨ́ɨme ɨ́ mej ahuaújcaꞌane tɨ Dios tíhuaꞌutaꞌaíjteꞌen. Ajta aꞌɨ́jna ɨ́ ɨxaj, ayée pu ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej íꞌiteɨtestemuaꞌameꞌen aꞌɨ́jna ɨ́ tiyaaruꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","’Ajta hui aꞌɨ́jna tɨ rájchaꞌɨɨreꞌe, aꞌɨ́jna tɨ raahuáste ɨ́ ɨxaj, aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ tiyaaruꞌu. Ajta, aꞌɨ́jna ɨ́ xɨcájraꞌa mé jetzen tíꞌitzaanan, ayée pu huataújmuaꞌa tɨjɨ́n aꞌájna xɨcájraꞌa tɨ jetzen teꞌentipuáꞌajte i chaanaca japua. Majta meꞌɨ́n ɨ́ mej tíꞌitzaanan, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej tíꞌivaɨreꞌe u ta japua Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","’Ayee pu cheꞌatá naꞌa téꞌeme aꞌájna xɨcájraꞌa tɨ jetzen nain teꞌentipuáꞌajte aꞌij mej titetiújchaꞌɨɨ matɨ́ꞌɨj ráꞌijcuuxɨɨ meꞌɨ́jna ɨ́ ɨxaj mej mi raꞌanteátaira. ");
INSERT INTO crnNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Neajta inee, i nej neajta teáataꞌa jetze airáane, nee nu huaꞌutaꞌaíjteꞌesin aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe u ta japua mej mi áꞌucɨɨne nainjapua tɨ́j naꞌa ɨ́ nej jɨ́n antínmuaꞌaree mej mi aꞌuun huaꞌirájtuaani aꞌɨ́mej ɨ́ mej aꞌij puaꞌa tiratáꞌaca ɨ́ Dios, aꞌɨ́mej ɨ́ mej aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aꞌuu mú huájaꞌucáhuaꞌaxɨjsin aꞌɨ́jna tzajtaꞌa aꞌu tɨ anúꞌutaa. Aꞌuu mú ruyeinixɨꞌɨn jeíhua, majta ancuréꞌujcɨꞌɨmée muáꞌajuꞌun ɨ́ rutamej jɨmeꞌe meꞌɨ́jna jɨmeꞌe mej huápɨꞌɨ rajpuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","’Majta meꞌɨ́n ɨ́ mej miyen rɨcɨ aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, ayée mú meꞌuun eꞌeseíireꞌe muáꞌajuꞌun aꞌujna huáꞌayaꞌupua tɨ tíꞌaijta. Ayee mú seíireꞌe muáꞌajuꞌun tɨ́j ɨ́ xɨcaj tɨ aiiráxɨꞌɨxɨre ɨ́ jaitɨri jetze. Ajta, jaꞌatɨ́ tɨ naꞌa tɨ huiteájnamua, chéꞌe aꞌɨ́ɨn ráanamua temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Aꞌujna aꞌu tɨ Dios teꞌáijta, íiyen chaanaca japua, ajta u ta japua, ayée pu tíꞌirɨni tɨ́j ɨ́ jaꞌatɨ tɨ tiꞌitɨ́j huáteu tɨ rúꞌavaa, tɨ ajta huápɨꞌɨ tíꞌijnajche. Aꞌuu pu ráateu taséehua japua. Aj pu i ajtahuaꞌa raatéꞌavaata aꞌujna cheꞌatá miijmu. Jéꞌecan pu rutémuaꞌaveꞌe aꞌɨ́jna jɨmeꞌe tɨ ráateu. Aꞌɨ́j pu jɨ́n, nain tuaani aꞌachú tɨ caj tíꞌijchaꞌɨɨ. Aj pu i áꞌiyen, aꞌɨ́ɨ pu ráananan aꞌɨ́jna ɨ́ chuej. ");
INSERT INTO crnNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ajta, ayée mú rɨcɨ aꞌɨ́ɨme ɨ́ mej rahuauhuau mej mi meꞌuun aꞌuteárute Dios tɨ éꞌeseijreꞌe, ayée mú cheꞌatá menaꞌa rɨcɨ tɨ́j jaꞌatɨ́ tɨ tíꞌituꞌaraca. Aꞌɨ́ɨ pu áꞌucheꞌecan tɨ aꞌɨ́ɨn rahuauni tiꞌitɨ́j perla tɨ naa ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tɨ́ꞌɨj seɨ́j huáteu, tɨ huápɨꞌɨ tíꞌijnajche, u pu áꞌume tɨ ij nain tiúꞌutuaani aꞌachú tɨ caj tíꞌijchaꞌɨɨ. Aj pu i aꞌɨ́jna nanan ɨ́ perla. ");
INSERT INTO crnNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ajtahuaꞌa seɨ́j ɨ́ chuijtari: ayée pu ꞌeen Dios tɨ tíꞌaijta íiyen chaanaca japua, ajta u ta japua. Dios pu ayén rɨcɨ matɨ́j aꞌɨ́ɨme ɨ́ mej huaꞌité viviꞌiraca xɨéjmuaꞌari jɨmeꞌe tɨ vivéj. Matɨ́ꞌɨj raꞌatéhuaꞌaxɨn á jaataꞌa, aj pu i chaꞌa naꞌa huaꞌitáseɨreꞌesin ɨ́ huaꞌité. ");
INSERT INTO crnNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Matɨ́ꞌɨj caí chéꞌe úꞌuvejri ɨ́ xɨéjmuaꞌari tzajtaꞌa, aj mú mi raꞌitapíjsin á jaataꞌa meꞌɨ́jna ɨ́ xɨéjmuaꞌari. Matɨ́ꞌɨj mi huáchijteꞌe á yaupíjsin aꞌɨ́mej ɨ́ mej huaꞌité viviꞌiraca. Aꞌuu mú aꞌuráaseɨjráꞌɨn. Aj mú mi huaꞌavéꞌeꞌɨꞌɨxɨꞌɨsin ɨ́ huaꞌité ɨ́ mej rɨ́ꞌen. Majta meꞌɨ́n ɨ́ huaꞌité ɨ́ mej rɨ́ꞌen, sicɨ́ri jetze mú huaꞌateátuaasin. Majta ɨ́ mej caí rɨ́ꞌen, á mú huaúuhuaꞌaxɨjsin. ");
INSERT INTO crnNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","’Ayee pu cheꞌatá naꞌa téꞌeme aꞌájna xɨcájraꞌa tɨ jetzen nain teꞌentipuáꞌajte íiyen chaanaca japua. Aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe ɨ́ ta japua Dios tɨ éꞌeseijreꞌe, aꞌɨ́ɨ mú huiráajuꞌun mej mi huaꞌavéꞌejajpuaxɨꞌɨn rujɨ́meꞌen ɨ́ teɨte ɨ́ mej aꞌij puaꞌa rɨcɨ, majta ɨ́ mej xɨ́ꞌepɨꞌɨn rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Matɨ́ꞌɨjtá mi meꞌuun huauucáhuaꞌaxɨjsin ɨ́ hoorno tzajtaꞌa aꞌɨ́mej ɨ́ mej aꞌij puaꞌa rɨcɨ mej mi rajpuaíjtzi muáꞌaraꞌani taij jɨmeꞌe. Aꞌuu mú ruyeinixɨꞌɨn, majta ancuréꞌujcɨꞌɨmée muáꞌajuꞌun ɨ́ rutamej jɨmeꞌe aꞌɨ́jna jɨmeꞌe mej rajpuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni secaí nain auꞌitɨée xaꞌaraa múꞌeen? Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: ―Jee. ");
INSERT INTO crnNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́j pu jɨ́n, tɨ puaꞌa seɨ́j tɨ tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, tɨ puaꞌa aꞌɨ́ɨn ajta autéjcheni aꞌɨ́jna jetzen tiꞌihuaújmuaꞌaten aꞌij tɨ tíꞌirɨꞌɨri tɨ Dios tiraꞌaíjteꞌen nain jɨmeꞌe, ayée pu éeneꞌe aꞌame aꞌɨ́jna ɨ́ jaꞌatɨ tɨ́j seɨ́j tɨ huatéechiꞌi. Jéihua pu teꞌurájchaꞌɨɨ aꞌujna ruchiꞌitá. Ajta, jaꞌanáj tɨ naꞌa pu teꞌiráatɨꞌɨcɨ aꞌɨ́jna tɨ tiꞌijéjcua, ajta tɨ tiꞌimíꞌimeꞌecan. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tɨ́ꞌɨj Jesús raꞌantipuáꞌajte tɨ tihuaúꞌixaateꞌe chuijtari jɨmeꞌe, aj pu i áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Aꞌuu pu aꞌaráꞌa aꞌu tɨ aꞌuvéꞌese. Aj pu i aꞌutéjche tɨ tihuaꞌumuáꞌate huaꞌatéyujtaꞌa. Majta meꞌɨ́n ɨ́ mej ráanamuajriꞌi, jéꞌecan mú aꞌij raꞌutaseíj. Ayee mú tíꞌiruixaateꞌecaꞌa tɨjɨ́n: ―¿Aꞌuquí yaꞌurɨ́ꞌɨre amɨ́jna tɨ ayén temuaꞌa naa tirúꞌumuaꞌaree? ¿Tiꞌitájni muárɨꞌeriꞌiraꞌa púꞌeen ɨ́ tɨ jɨ́n ayén rɨcɨ aꞌɨ́jna ɨ́ tej jɨ́meꞌen aꞌij yaꞌuseíj? ");
INSERT INTO crnNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Amɨ́jna, aꞌɨ́ɨ pu hui yaujraꞌan aꞌɨ́jna tɨ tíꞌisiꞌicheca. Ajta náànajraꞌan, aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ María. ¿Ni mecaí meꞌɨ́n púꞌeen ɨ́ júutzimuaꞌameꞌen aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ José, ajtahuaꞌa seɨ́j aꞌɨ́jna tɨ ayén ántehuaa tɨjɨ́n Simón, ajta aꞌɨ́jna ɨ́ Judás? ");
INSERT INTO crnNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ni mecaí majta yé che ta jamuan, aꞌɨ́ɨme júutzimuaꞌameꞌen ɨ́ mé ꞌuuca? Tɨ́ puaꞌa ayén tiꞌayajna, ¿aꞌuné éꞌemeꞌecan aꞌɨ́jna ɨ́ muaꞌatzíireꞌaraꞌan tɨ yé raateájtuaa amɨ́jna mɨ Jesús? ");
INSERT INTO crnNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Matɨ́ꞌɨj mi ráꞌanchueere meꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j mú jɨ́n, miraatamuári. Ajta, ayée pu tihuaꞌutáꞌixaa ɨ́ Jesús tɨjɨ́n: ―Naímiꞌi mú rɨ́ꞌɨ tiratáꞌaca aꞌɨ́jna jemi ɨ́ tɨ tíꞌixaxaꞌa ɨ́ Dios jetze meꞌecan. Mɨ́ majta, aꞌɨ́ɨme ɨ́ mej huacaíjme aꞌu mé éꞌeche, majta aꞌɨ́ɨme ɨ́ teɨtestemuaꞌameꞌen ɨ́ mej éꞌeche jamuan, camu rɨ́ꞌɨ tiratáꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aꞌɨ́j pu i jɨ́n caí jeíhua ayén tiúꞌuruu aꞌɨ́jna jɨmeꞌe ɨ́ muárɨꞌeriꞌireꞌaraꞌan aꞌujna aꞌiné camu ráꞌatzaahuateꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Aꞌájna xɨcájraꞌa jetze, aꞌɨ́jna ɨ́ Heródes, ɨ́ tɨ iꞌi rey, aꞌɨ́ɨ pu ráanamuajriꞌi aꞌij tɨ rɨjcaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌecaꞌa ɨ́ jemin tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Juan tɨ tíꞌitemuaɨꞌɨhuacareꞌe. Puꞌuri aꞌitáraa aꞌu mej yeꞌaváꞌana. Aꞌɨ́j pu jɨ́n raayɨ́ꞌɨtɨ tɨ ayén rɨcɨ aꞌɨ́jna jɨmeꞌe ɨ́ muárɨꞌeriꞌiraꞌa ɨ́ tej jɨ́n aꞌij yaꞌuseíj. ");
INSERT INTO crnNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ajta aꞌɨ́ɨn ɨ́ Heródes, aꞌɨ́ɨ pu ajmíꞌi raatéeviꞌi aꞌɨ́jna ɨ́ Juan. Raꞌamuajɨ́ꞌɨcɨꞌe pu aiteújna. Ayee pu ꞌeen jɨ́n ráaruu aꞌiné Juan pu raꞌajteáꞌaxɨ aꞌɨ́jna jɨmeꞌe tɨ Heródes raꞌancuréꞌeviꞌitɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ Felipe raatéviꞌitɨneꞌe. Aꞌɨ́jna ɨ́ Felipe, aꞌii pu aꞌɨ́ɨn puꞌéeneꞌe ɨ́ juutzeájraꞌan ɨ́ rey. Ajta aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, ayée pu ántehuaacaꞌa tɨjɨ́n Herodías. ");
INSERT INTO crnNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ayee pu teꞌirájraa tɨ Juan ayén tiraatáꞌixaa aꞌɨ́jna ɨ́ Heródes tɨjɨ́n: ―Capu aꞌij tíꞌirɨꞌɨri pej ratéviꞌitɨneꞌen muáꞌihuaaraꞌa tɨ ratéviꞌitɨneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Heródes pu rajéꞌicatamɨꞌɨcaꞌa aꞌɨ́jna ɨ́ Juan. Aru huáꞌatziɨɨneꞌecaꞌa ɨ́ teɨte, aꞌiné aꞌɨ́ɨ pu ramuaꞌareerecaꞌa mej miyen tíꞌixaxaꞌataꞌa tɨ nuꞌu aꞌɨ́ɨn púꞌeen seɨ́j tɨ tíꞌixaxaꞌa Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna xɨcájraꞌa tɨ jetzen huanúꞌihuacaꞌa aꞌɨ́jna ɨ́ Heródes, ꞌɨ́itaꞌa pu uteájrupi u chiꞌita tɨ ij tiuꞌutéeneꞌen ruseɨ́j huáꞌa vejliꞌipua. Aꞌii pu aꞌɨ́ɨn púꞌeen yaujraꞌan aꞌɨ́jna Herodías. Jéꞌecan pu raꞌaránajchecaꞌa aꞌɨ́jna ɨ́ rey tɨ ayén tiuꞌutéenei. ");
INSERT INTO crnNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Aꞌɨ́j pu jɨ́n aꞌɨ́ɨn teꞌataújratziiriꞌi runiuuca jɨmeꞌe tɨ ayén raatáꞌan aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa aꞌij tɨ tiꞌitɨ́j tíꞌixeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ajta aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu ayén tiraataꞌíhuaꞌuriꞌi ɨ́ runáàna tɨjɨ́n: ―¿Tiꞌitájni neraatáhuavii? Aj pu i aꞌɨ́ɨn náànajraꞌan ayén tɨjɨ́n: ―Huatáhuaviiriꞌi ɨ́ muꞌúuraꞌan ɨ́ Juan tɨ tíꞌitemuaɨꞌɨhuaca. Aj pu i, aꞌɨ́ɨn ꞌɨ́itaꞌa ayén tiraatáꞌixaa: ―Patáꞌaj naataꞌɨ́ꞌɨteꞌen tuxaꞌa jetze ɨ́ muꞌúuraꞌan aꞌɨ́jna ɨ́ Juan tɨ tíꞌitemuaɨꞌɨhuaca. ");
INSERT INTO crnNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Aꞌij pu puaꞌa raatáꞌa aꞌɨ́jna ɨ́ rey. Mɨ́ ajta, ari ayén teꞌataújratziiriꞌi tɨ ayén huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe. Majta aꞌɨ́ɨme tɨ huaꞌutáꞌinee, aꞌɨ́ɨ mú majta ráanamuajriꞌi tɨ tiuꞌutáꞌa ɨ́ runiuuca. Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨn tiuꞌutaꞌaíjtacaꞌa mej mi miyen huárɨni aꞌij tɨ tiraatáhuaviiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ajta áꞌiyen aꞌɨ́ɨ pu xantaaruꞌu huataꞌáitecaꞌa tɨ u áꞌumeꞌen aꞌu tɨ aiteánamiꞌi aꞌɨ́jna ɨ́ Juan tɨ ij ruꞌijveíjche ɨ́ muꞌúuraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tɨ́ꞌɨj ayén huarɨ́j, aj pu i yeꞌeráꞌɨꞌɨte aꞌɨ́jna ɨ́ muꞌúuraꞌan ɨ́ tuxaꞌa jetze tɨ ij Herodías ayén raamuaree tɨjɨ́n raajéꞌica, tzɨ́teꞌe, aꞌɨ́jna ɨ́ Juan. Ajta aꞌɨ́jna ɨ́ rey, aꞌɨ́ɨ pu raataꞌɨ́ꞌɨte aꞌɨ́jna jemi ɨ́ yaujraꞌan ɨ́ Herodías. Aj pu i aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa raataꞌɨ́ꞌɨte ɨ́ runáàna. ");
INSERT INTO crnNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Majta meꞌɨ́n ɨ́ mej áꞌujujhuaꞌaneꞌe ɨ́ Juan jamuan, aꞌɨ́ɨ mú á veꞌereꞌenée, miyáꞌutɨɨ meꞌɨ́jna ɨ́ mɨꞌɨchi. Matɨ́ꞌɨj mi raꞌaváꞌana. ");
INSERT INTO crnNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ajta aꞌɨ́jna ɨ́ Jesús, tɨ́ꞌɨj ráamuaꞌareeriꞌi tɨjɨ́n meraajéꞌica aꞌɨ́jna ɨ́ Juan, tɨꞌɨquí ateájraa ɨ́ baarcu jetze. Ruseɨ́j pu áꞌuraa. Aꞌuu pu aꞌaráꞌa aꞌu tɨ caí jéꞌe tiꞌitɨ́j. Majta ɨ́ teɨte, aꞌɨ́ɨ mú ráamuaꞌareeriꞌi aꞌu tɨ aꞌij ꞌeeneꞌe. Aꞌɨ́j mú jɨ́n, curéꞌecɨjxɨ mej aꞌuchéjme. Aj mú mi ruꞌɨcán raatavén. ");
INSERT INTO crnNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tɨ́ꞌɨj i Jesús aꞌitáraa ɨ́ baarcu jetze. Tɨ́ꞌɨj huaꞌuseíj ɨ́ teɨte ɨ́ mej muꞌíi, aꞌɨ́ɨ pu huáꞌancuꞌuvajxɨ. Ajta tihuáꞌuhuaa ɨ́ mej tíꞌicucuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tɨ́ꞌɨj huateáchumuaꞌarecaꞌa, aj mú mi aveꞌeréꞌene jemin ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: ―Puꞌuri téchumuaꞌari, ajta capu jaꞌatɨ́ yeꞌe éꞌeche ayajna. Patáꞌaj huaꞌaréꞌeꞌitixɨꞌɨn mej mi aꞌucɨ́jxɨꞌɨn mé jáꞌahuaꞌa chajtaꞌa matáꞌaj tiꞌitɨ́j huánanan ɨ́ mej ráacuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ajta aꞌɨ́jna ɨ́ Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Capu ruxeꞌeveꞌe mej aꞌucɨ́jxɨꞌɨn. Setáꞌaj tihuaꞌumín múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aj mú mi miyen tɨjɨ́n: ―Ayee tuꞌu puaꞌaméca tíchaꞌɨɨ anxɨ́vica ɨ́ pan, teajta huaꞌapuaca ɨ́ huaꞌité. ");
INSERT INTO crnNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Aj pu i Jesús ayén tɨjɨ́n: ―Mé senejeꞌevéꞌeꞌɨꞌɨpɨꞌiteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aj pu i aꞌɨ́ɨn huaꞌutaꞌaíj mej aꞌujráꞌase ɨ́ tuꞌupi tzajtaꞌa. Aj pu i Jesús raꞌancuréꞌeꞌɨꞌɨpɨꞌɨ pan, ajta ɨ́ huaꞌité. Aj pu i júteꞌe ájneerecaꞌa. Tɨꞌɨj jí rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Aj pu i raꞌantítaaraxɨ ɨ́ pan. Tɨꞌɨj jí huaꞌuréꞌeꞌɨꞌɨpɨꞌite aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majta meꞌɨ́n, aꞌɨ́ɨme mú huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Naíimiꞌi mú tiúꞌucuaa. Jéihua mú huájuꞌuxai. Ajta jeíhua pu avéꞌeturaa ɨ́ pan, majta ɨ́ huaꞌité. Tamuáamuataꞌa japuan huaꞌapua mú teꞌevéꞌejɨste sicɨ́ri jetze meꞌɨ́jna jɨmeꞌe ɨ́ tɨ teꞌaváꞌaturaa. ");
INSERT INTO crnNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Majta meꞌɨ́n ɨ́ mej tiúꞌucuaa, ayée mú aráꞌasecaꞌa aꞌachú cumu anxɨ́j viꞌiraꞌa ɨ́ teteca. Majta ɨ́ mé ꞌuuca, majta ɨ́ tɨꞌɨríi, aꞌɨ́ɨ mú majta tiúꞌucuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aj pu i huaꞌutaꞌaíj aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe mej nuꞌu atécɨɨne ɨ́ baarcu jetze mej mi antácɨɨne után pújmeꞌen, mej mi meꞌɨ́n amuacaí meꞌuun eꞌaráꞌasti. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌúu pu aꞌuteájturaa tɨ ij huaꞌaréꞌeꞌitixɨꞌɨn ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tɨ́ꞌɨj huaꞌaréꞌeꞌitixɨ, aꞌúu pu aꞌuteájraa ɨ́ jɨrí jetze ruseɨ́j tɨ ij raatéjhuauni ɨ́ Dios jemi. Tɨ́ꞌɨj huateátɨcaꞌarecaꞌa, aꞌúu pu aꞌutéveecaꞌa ruseɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ajta aꞌɨ́jna ɨ́ baarcu, puꞌuri aꞌɨmuá auméꞌecaa jáꞌitaꞌa ɨ́ jaj japua. Aj pu i huatáꞌeecarecaꞌa caꞌanín jɨmeꞌe. Temuaꞌa pu teꞌateáxɨjrihuaꞌa ɨ́ jaj ɨ́ baarcu jetze aꞌɨ́jna ɨ́ eeca jɨmeꞌe tɨ auj ráruuréjveecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aréꞌapuaꞌa, tɨ́ꞌɨj tapuáꞌarijmeꞌeca, Jesús pu aveꞌeréꞌene aꞌájna vejliꞌi huáꞌa jemi. Jaj japua pu huaméꞌecaa. ");
INSERT INTO crnNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj raaseíj, jéꞌecan mú tiuꞌutátziɨn. Temuaꞌa mú titeejíjhuacaꞌa meꞌɨ́jna jɨmeꞌe mej tiuꞌutátziɨn. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Chéjcan pu púꞌeen amɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ajta áꞌiyen, Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Xuꞌuhuateújcaꞌane mɨ ru tzajtaꞌa. Nee nu neꞌɨ́n pɨ́rɨcɨ ɨ́ Jesús. Caxu tíꞌitziɨɨneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ajta aꞌɨ́jna ɨ́ Pedro, aꞌɨ́ɨ pu ayén tiraatajé tɨjɨ́n: ―Tavastaraꞌa, tɨ puaꞌa múꞌee peꞌɨ́n púꞌeen, naataꞌáijteꞌe nej nemánna urarɨ́ꞌeneꞌen múꞌeetzi jemi aꞌɨ́jna ɨ́ jaj japua. ");
INSERT INTO crnNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Mú paꞌuvéꞌemeꞌen. Aj pu i aꞌitáraa ɨ́ baarcu jetze. Tɨꞌɨquí rájraa ɨ́ jaj japua. Aa pu vejliꞌi auméꞌecaa aꞌu tɨ aꞌij ꞌeeneꞌe ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Tɨ́ꞌɨj ráamuaꞌareeriꞌi tɨ caꞌanín jɨ́n huatáꞌeecarecaꞌa, aꞌɨ́ɨ pu tiuꞌutátziɨn. Aj pu aꞌutéjche tɨ aꞌucárute ɨ́ jaj tzajtaꞌa. Aj pu i ayén huajíjhuacaꞌa tɨjɨ́n: ―Tavastaraꞌa, ne japua huániuuchi. ");
INSERT INTO crnNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jɨ́meꞌen pu ayén tiuꞌujíjhuacaꞌa, aj pu i Jesús ajmeíjcaꞌatacaꞌa. Rajvíꞌi aꞌɨ́jna ɨ́ Pedro. Aj pu i ayén tiraatáꞌixaa tɨjɨ́n: ―Capej aꞌatzu téꞌatzaahuateꞌe múꞌee. ¿Aꞌiné ꞌeen jɨ́n pecaí náꞌatzaahuateꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Matɨ́ꞌɨj atéecɨ ɨ́ baarcu jetze, aj pu i huateápuaꞌarecaꞌa aꞌɨ́jna ɨ́ eeca. ");
INSERT INTO crnNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Matɨ́ꞌɨj mi meꞌɨ́n ɨ́ mej aráatei baarcu jetze, aꞌɨ́ɨ mú títunutaxɨ ɨ́ Jesús jemi. Aj mú miyen rɨ́ꞌɨ tiraatajé tɨjɨ́n: ―Múꞌee pej tzɨ́teꞌe peꞌɨ́n púꞌeen i yaujraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Matɨ́ꞌɨj antacɨ́j, aj mú mi aitacɨ́j ɨ́ baarcu jetze ajnaꞌa jáꞌahuaꞌa, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Genesaret. ");
INSERT INTO crnNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Majta meꞌɨ́n ɨ́ teɨte, matɨ́ꞌɨj raamuáꞌa meꞌɨ́jna ɨ́ Jesús, aj mú mi tihuaꞌaréꞌeꞌitiꞌiraxɨ nainjapua ɨ́ mej aꞌɨmuá antachéejmeꞌecaa. Aj mú mi huaꞌeráaviꞌitɨ naíjmiꞌica ɨ́ mej tíꞌicucuiꞌi ɨ́ Jesús jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jéihua mú rájhuaviiriꞌi tɨ huaꞌutáꞌan mej mi raꞌajtamuárɨꞌen aꞌájna cɨ́ɨxureꞌaraꞌan jetze tɨ́j naꞌa tɨ uvíjpiꞌi. Majta meꞌɨ́n ɨ́ mej miyen raꞌajtamuárɨej, naíjmiꞌi mú huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Matɨ́ꞌɨj mi seica aveꞌeréꞌene ɨ́ Jesús jemi. Aꞌɨ́ɨme mú aꞌɨ́ɨn púꞌeen ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze. Aꞌuu mú eꞌeráacɨ u Jerusalén. Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Aꞌiné ꞌeen jɨ́n mecaí ráꞌaste ɨ́ tavaújsimuaꞌa teeca tihuáꞌayeꞌira aꞌɨ́ɨme ɨ́ mé á jamuan áꞌujujhuaꞌan? Camu miyen ráꞌaste meꞌɨ́jna jɨmeꞌe ɨ́ mej caí anaújmuaijteꞌaxɨꞌɨn metíꞌicuaꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Seajta múꞌeen, ¿aꞌiné ꞌeen jɨ́n siyen mé rúujɨpua ɨ́ tɨ tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios sej si seꞌɨ́jna aráꞌasten ɨ́ ruyeꞌirá ɨ́ sej senaꞌa rájteu rujɨ́ɨmuaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Aꞌiné Dios pu ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨ jɨ́meꞌen yee: “Patáꞌaj ráꞌatzaahuateꞌe aꞌatáàta, pajta aꞌanáàna.” Ajta ayén tɨ jɨ́meꞌen yee: “Setáꞌaj raajéꞌica aꞌɨ́jna ɨ́ jaꞌatɨ aꞌij puaꞌa tiꞌijteáꞌaxɨꞌɨ ɨ́ rutáàta naꞌari ɨ́ runáàna.” ");
INSERT INTO crnNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mɨ́ seajta múꞌeen, ayée xu tíꞌixaxaꞌa tɨ iꞌi xɨ́ꞌepɨꞌɨn tɨ puaꞌa jaꞌatɨ́ ayén tihuaꞌutáꞌixaateꞌen ɨ́ ruvaújsimuaꞌa tɨjɨ́n: “Nain aꞌachú nej caj tíꞌijchaꞌɨɨ, aꞌɨ́j nu neri raatámuaɨꞌɨvejte ɨ́ Dios. Aꞌɨ́j nu jɨ́n caí chéꞌe tíꞌijchaꞌɨɨ ɨ́ nej jɨ́n amuaatévaɨreꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","’Tɨ́ puaꞌa jaꞌatɨ́ ayén tihuaꞌutáꞌixaateꞌen ɨ́ ruvaújsimuaꞌa, ayée cheꞌatá tíꞌixaxaꞌa jɨ́meꞌen aꞌɨ́jna ɨ́ jaꞌatɨ yee capu chéꞌe ruxeꞌeveꞌe tɨ aꞌɨ́ɨn huaꞌutévaɨreꞌen ɨ́ ruvaújsimuaꞌa. Ayee xu mé tirúujɨpua seꞌɨ́jna tɨ Dios jɨ́n tiuꞌutaꞌaíjtacaꞌa sej si raꞌaráꞌasten seꞌɨ́jna jɨmeꞌe ɨ́ yeꞌirá sej siyen rujɨ́ɨmuaꞌa senaꞌa tirájteu. ");
INSERT INTO crnNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","’Múꞌeen, mɨ sej aꞌij puaꞌa tíꞌiteteɨte, mɨ sej siyen ráꞌaste jéjreꞌecɨtzeꞌe, ayée pu tiuꞌutaxájtacaꞌa múꞌejmi jɨmeꞌe aꞌɨ́jna ɨ́ Isaías teecan, ɨ́ tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Ayee pu teꞌuyúꞌuxacaꞌa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Naa pu namuajreꞌe tɨ puaꞌa metíꞌixajta neetzi jemi, mɨ majta, aꞌɨ́ɨ mú meri mé núurɨe. ");
INSERT INTO crnNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Capu tiꞌitɨ́j vaɨreꞌe tɨ puaꞌa menaateánajche aꞌiné matɨ́j menaꞌa mej tíꞌimuaꞌata, ɨ́ mej jɨ́n tihuáꞌaijteꞌe, rujɨ́ɨmuaꞌa menaꞌa rájteuve. ");
INSERT INTO crnNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aj pu i aꞌɨ́ɨn huaꞌutajé ɨ́ teɨte. Tɨꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu temuaꞌa naa tiráanamua múꞌeen sej si yaúꞌitɨée xáꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tiꞌitɨ́j tɨ naꞌa tɨ tíꞌicuaꞌiriꞌi, tɨ puaꞌa jaꞌatɨ́ ráacuaꞌani, capu aꞌatzu raxanaꞌaveꞌe, sino aꞌɨ́ɨ pu raxanaꞌaveꞌe ɨ́ tɨ ꞌaíjninei ɨ́ téneꞌetzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Aj mú mi ajteáxɨɨrecaꞌa jemin aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni tzaa pe caí ramuaꞌaree ɨ́ tɨ caí huaꞌaránajchecaꞌa aꞌɨ́mej ɨ́ fariseos matɨ́ꞌɨj ráanamuajriꞌi aꞌij pej tiuꞌutaxájtacaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee mú ꞌeen tɨ́j tuꞌupi tɨ caí jaꞌatɨ́ raahuáste, ruseɨ́j pu ajnéj. Ayee pu cheꞌatá naꞌa huáꞌaruuren ɨ́ Dios tɨ́j ajta rúꞌuriꞌi ɨ́ tuꞌupi tɨ ruseɨ́j ajnéj aꞌɨ́jna ɨ́ jaꞌatɨ tɨ tiuꞌuhuáste, aꞌiné aꞌɨ́ɨ pu ráꞌijcuuxɨjsin, ajta meteúrɨeexɨjsin ɨ́ tuꞌupi, Dios pu ayén cheꞌatá naꞌa mé huauuhuáꞌaxɨjsin aꞌɨ́mej. ");
INSERT INTO crnNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","’Micheꞌe miyen éeneꞌen. Ayee mú ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej arácucuꞌun ɨ́ mej huáꞌuviꞌitɨ. Tɨ́ puaꞌa seɨ́j taꞌarácun ayén raꞌanavíꞌiraꞌa tɨ ajta arácun mej mi jáꞌahuaꞌa eꞌaráꞌasti naímiꞌi, naímiꞌi mú atévatzɨjsin aꞌu tɨ eꞌetécun. ");
INSERT INTO crnNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Aj pu i Pedro ayén tiraatáꞌixaa tɨjɨ́n: ―Taatáꞌixaateꞌe aꞌij tɨ huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari ɨ́ pej pauchén raataxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ajta Jesús ayée pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni tzaa secaí seajta múꞌeen yaúꞌitɨe? ");
INSERT INTO crnNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ni tzaa secaí yaúꞌitɨe seꞌɨ́jna? Tɨ́ puaꞌa jaꞌatɨ́ tiꞌitɨ́j huácuaꞌani tɨ cuáꞌiriꞌi, aꞌɨ́jna tɨ racuaꞌani, puaꞌacɨé pu meꞌecan. Aj pu i ancajrupi ɨ́ téneꞌetzeꞌe, aꞌúu pu aꞌaráyeijxa ɨ́ jucáaraꞌan jetze. Ajta áꞌiyen íꞌirachuꞌitan ɨ́ tɨ tiúꞌucuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","’Mɨ́ ajta, aꞌɨ́jna tɨ ꞌaíjninei ɨ́ téneꞌetzeꞌen ɨ́ jaꞌatɨ, aꞌúu pu aꞌuvéꞌeyeꞌi ɨ́ ru tzajtaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ raxanaꞌaveꞌe aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ayee puꞌu xaa neꞌu aꞌiné tzajtaꞌan pu aꞌuvéꞌeyeꞌi naíjmiꞌi ɨ́ muaꞌatzíiraꞌa tɨ aꞌij puaꞌa ꞌeen, tɨ caꞌaníjraꞌa ratáꞌaca tɨ jaꞌatɨ́ ayén huárɨni ɨ́ tɨ aꞌij puaꞌa ꞌeen, tɨ puaꞌa tíꞌitecuiꞌica naꞌari seɨ́j jamuan tiꞌihuaújxanaꞌacɨraꞌaten. Ajta ɨ́ ru tzajtaꞌa pu ajta tásiseiiri tɨ ayén caꞌaníjraꞌa ratáꞌaca tɨ ayén tiúꞌumuaꞌati tɨ tiuꞌunáhuaꞌan, nusu tɨ ráacuanamua naꞌari tɨ aꞌij puaꞌa tiúꞌujxajtaveꞌe huáꞌa jemi ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","’Naíjmiꞌi tɨ́j naꞌa tɨ hui ayén aꞌij puaꞌa ꞌeen, tɨ tásiseiiri ɨ́ ta tzajtaꞌa, aꞌɨ́ɨ pu xaa raxanaꞌaveꞌe ɨ́ tevi. Ajta aꞌɨ́jna tɨ caí anaujmuaíteꞌen tiúꞌucuaꞌani, capu tiꞌitɨ́j aꞌij huataújmuaꞌa ɨ́ Dios jemi. Capu tiꞌitɨ́j jɨ́n auteájturaa ɨ́ Dios jemi aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí anaujmuaíteꞌen tiúꞌucuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Aj pu i Jesús áꞌuraa. Aꞌuu pu aꞌaráꞌa aꞌájna jáꞌahuaꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Tiro, ajtahuaꞌa seɨ́j tɨ ayén tɨjɨ́n Sidón. ");
INSERT INTO crnNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ajta, seɨ́j pu aveꞌeréꞌene ɨ́ Jesús jemi. ꞌƗ́itaꞌa pu púꞌeen tɨ seɨj chuéjraꞌa japua éꞌemeꞌecan. Ayee mú huaꞌatamuáꞌamua tɨjɨ́n Sirofenicia aꞌuun tɨ huacáꞌa pu éꞌechejcaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. A pu eꞌevéꞌeme antijíihua tɨjɨ́n: ―Nevástaraꞌa, múꞌee pej iꞌi yaujraꞌan aꞌɨ́jna ɨ́ David teecan, patáꞌaj náꞌancuꞌuvajxɨꞌɨn. Jéꞌecan pu rajpuaíjtzi ɨ́ niyauj tɨ ꞌɨ́itaꞌa aꞌɨ́jna jɨmeꞌe tɨ tiyaaruꞌu tzajtaꞌan seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ajta aꞌɨ́jna ɨ́ Jesús, capu aꞌatzu huataniú. Aj mú mi aveꞌeréꞌene aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee mú tirájhuaviiriꞌi tɨjɨ́n: ―Patáꞌaj raataꞌíte tɨ áꞌuraꞌani, aꞌiné ta cujtaꞌan pu eꞌevéꞌeme antijíihua. ");
INSERT INTO crnNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Aj pu i Jesús ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee pu Dios nejaꞌutaꞌítecaꞌa nej áꞌuraꞌani huáꞌa jemi ɨ́ mej Israél jetze ajtémeꞌecan ɨ́ mej miyen seijreꞌe tɨ́j cáneꞌaxɨ ɨ́ mej áꞌuvej. Capu nejaꞌutaꞌítecaꞌa aꞌɨ́mej jemi ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Aj pu i aꞌɨ́ɨn ꞌɨ́itaꞌa aveꞌeréꞌene á vejliꞌi jemin. Ajta títunutacaꞌa. Aj pu i ayén tiraatáꞌixaa tɨjɨ́n: ―Nevástaraꞌa, naatévaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Capu ayén tiraavíjteꞌe nej huáꞌaꞌɨꞌɨpɨꞌɨriꞌiraꞌacareꞌen ɨ́ pan ɨ́ mej racuaꞌaca ɨ́ tɨꞌɨríi nej ni chiicate huataꞌɨ́ꞌɨpɨꞌiteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Aj pu i aꞌɨ́ɨn ꞌɨ́itaꞌa ayén tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, nevástaraꞌa. Aru, casiꞌi, aꞌɨ́ɨme ɨ́ chiicate, ayée mú racuaꞌaca meꞌɨ́jna ɨ́ tɨ teꞌení ɨ́ pan tɨ acajvitze meesa japua aꞌu mej tejéꞌecuaꞌaca aꞌɨ́ɨme ɨ́ mej tihuáꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Múꞌee ꞌɨ́itaꞌa, jéꞌecan pej téꞌatzaahuateꞌe. Puꞌuri muaatáꞌa aꞌij pej tíꞌijxeꞌeveꞌe. Jɨ́meꞌen puꞌu ayén tiraataxájtacaꞌa aꞌɨ́jna ɨ́ Jesús, aj pu i huarúj aꞌɨ́jna ɨ́ yaujraꞌan ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aj pu i Jesús áꞌuraa. Aꞌuu pu ejtéenee aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ jéꞌejmuaa aꞌujna jáꞌahuaꞌa u Galilea. Aj pu i antíraa ɨ́ jɨrí jetze. An pu aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jéihua mú eꞌiréꞌene ɨ́ teɨte. Aꞌɨ́mej mú eꞌeráaviꞌitɨ ɨ́ mej tzareꞌe ráatuaatɨme ɨ́ ruɨ́ɨca, majta seica ɨ́ mej arácucuꞌun, majta seica ɨ́ mej caí téꞌanrɨꞌɨréjmee, majta seica ɨ́ mej tiꞌipuaíjtiꞌihuacaꞌa. Majta muꞌiicáca mú eꞌeráaviꞌitɨ ɨ́ seica ɨ́ mej tíꞌicucuiꞌi. Aa mú huáꞌajtuaa aꞌu tɨ aꞌutéjvee aꞌɨ́jna ɨ́ Jesús. Ajta aꞌɨ́ɨn, aꞌɨ́ɨ pu naíjmiꞌica pu tiúꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jéꞌecan mú aꞌij teꞌutaseíj ɨ́ teɨte ɨ́ mej huajeꞌiréꞌeneijte matɨ́ꞌɨj huaꞌuseíj ɨ́ tɨ ari rɨꞌɨríistacaꞌa mej tiuꞌutaxáj aꞌɨ́ɨme ɨ́ mej mejmíꞌi caí teꞌanrɨꞌɨréjmeꞌecaa; majta aꞌɨ́ɨme ɨ́ mej tiꞌipuaíjtiꞌihuacaꞌa, muꞌuri rɨꞌéeneꞌen nainjapua; majta aꞌɨ́ɨme ɨ́ mej tzareꞌe ráatuaatɨme ɨ́ ruɨ́ɨca, muꞌuri áꞌujujhuaꞌaneꞌe; majta aꞌɨ́ɨme ɨ́ mej aracúcuꞌunijmeꞌecaꞌa, muꞌuri tiꞌiseíjracaꞌa. Majta meꞌɨ́n ɨ́ teɨte, aꞌɨ́ɨ mú autéjhuii ɨ́ mej rɨ́ꞌɨ tiraatáꞌan meꞌɨ́jna ɨ́ Dios tɨ tihuáꞌaijteꞌe aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Aj pu i Jesús huaꞌutajé aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Naaténxɨemɨste amɨ́mej teɨtejraꞌa jemi, aꞌiné puꞌuri huaíca xɨca teuumé mej áꞌujujhuaꞌan nee jamuan. Camu majta tiꞌitɨ́j tíchaꞌɨɨ mej ráacuaꞌani. Canu raxɨ́ꞌeveꞌe mej caí xɨ tiuꞌucuáꞌan nehuaꞌaréꞌeꞌitixɨꞌɨn. Naꞌari caí, temuaꞌa mú tíꞌitemuaꞌitɨcheꞌen ɨ́ juye japua. ");
INSERT INTO crnNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné jetze éꞌerɨꞌɨri tej ráahuauni ɨ́ pan tɨ́j naꞌa tɨ ruxeꞌeveꞌe tɨ ij tihuáꞌucɨꞌɨti naíjmiꞌica ɨ́ teɨte? Capu sein iꞌi rɨꞌɨrí ayajna aꞌu tɨ caí éꞌe jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌachúni puaꞌaméca séjchaꞌɨɨ ɨ́ pan, múꞌeen? Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: ―Aráhuaꞌapua pu puaꞌamé i pan. Teajta cɨ́j caj i huaꞌité mej cɨ́lieen. ");
INSERT INTO crnNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aj pu i huaꞌutaꞌaíj ɨ́ teɨte mej aꞌujráꞌase á chuaataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Raꞌancuréꞌeꞌɨꞌɨpɨꞌɨ ɨ́ pan, ajta ɨ́ huaꞌité, aj pu i Jesús rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Ajta áꞌiyen raꞌantítaaraxɨ ɨ́ pan. Aj pu i huaꞌuréꞌeꞌɨꞌɨpɨꞌɨ ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majta meꞌɨ́n, aꞌɨ́ɨ mú mijta mi huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Naímiꞌi mú tiúꞌucuaa. Temuaꞌa mú titéejuꞌuxai. Majta áꞌiyen, aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú raaréꞌeseɨj meꞌɨ́jna tɨ avéꞌeturaa ɨ́ pan tɨ raꞌantítaaraxɨ. Sicɨ́ri mú jetze teꞌevéꞌejɨsteꞌaxɨ meꞌɨ́jna jɨmeꞌe tɨ avéꞌeturaa. Aráhuaꞌapua sicɨ́ri pu teꞌaráꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Majta meꞌɨ́n ɨ́ mej tiúꞌucuaa, ayée mú aráꞌasecaꞌa aꞌachú cumu muáacua viꞌiraꞌa ɨ́ teteca. Majta rujɨ́ɨmuaꞌa mú tiúꞌucuaa aꞌɨ́ɨme ɨ́ ꞌuuca, majta ɨ́ tɨꞌɨríi. ");
INSERT INTO crnNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tɨ́ꞌɨj Jesús huaꞌaréꞌeꞌitixɨ ɨ́ teɨte, aj pu i ateájraa baarcu jetze. Tɨꞌɨj jí áꞌuraa. Aꞌuu pu aꞌaráꞌa aꞌujna jáꞌahuaꞌa aꞌu tɨ eꞌejtémeꞌecan u Magdala. ");
INSERT INTO crnNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Majta aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ saduceos, aꞌɨ́ɨ mú á eꞌiréꞌene aꞌu tɨ aꞌutéveecaꞌa ɨ́ Jesús, mej mi raatémuaꞌitɨn huaꞌitzi jɨmeꞌe. Aꞌɨ́j mú jɨ́n miyen raatáhuaviiriꞌi tɨ aꞌɨ́ɨn huaꞌutaseíjrateꞌen ɨ́ mej jɨ́n ráamuaꞌaree tɨ júteꞌe éꞌemeꞌecan ɨ́ tɨ jetzen araújcaꞌane. ");
INSERT INTO crnNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen xu raayɨ́ꞌɨtɨ aꞌij sej yeꞌí tiuꞌutaxáj aꞌij tɨ tiꞌitɨ́j rɨni u júteꞌe. Tɨ́ꞌɨj huatechuíixare, ayée xu tíꞌixaxaꞌa tɨ nuꞌu naa huaꞌéꞌeneꞌe aꞌame aꞌiné huaréꞌepáꞌuviꞌi pu jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Naꞌari caí, tɨ́ꞌɨj huatapuáꞌare, ayée xu seajta siyen jɨ́meꞌen tíꞌixaxaꞌa yee íjii mú huatéviiyi, aꞌiné huaréꞌepáꞌuviꞌi pu jáꞌaraa, majta nuꞌu raꞌutanáa. ’Múꞌeen xu xaa raayɨ́ꞌɨtɨ aꞌij sej yeꞌí tiuꞌutaxáj aꞌij tɨ tiꞌitɨ́j rɨni u júteꞌe. Mɨ́ seajta múꞌeen, caxu aꞌatzu raayɨ́ꞌɨtɨ aꞌij sej yeꞌí tiuꞌutaxáj aꞌɨ́jna jɨmeꞌe tɨ ari tejaꞌuréꞌenejsin ɨ́ xɨcájraꞌa, tɨ jetzen Dios raꞌantipuáꞌajteꞌen nain. ");
INSERT INTO crnNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","’Múꞌeen mɨ sej aꞌij puaꞌa tíꞌiteteɨte, mɨ sej jeíhua jɨ́n autéꞌɨtzeaara, ayée xu rahuauca ɨ́ sej jɨ́n ráamuaꞌaree tɨ júteꞌe éꞌemeꞌecan ɨ́ nej jetzen aráncaꞌane. Canu xaa neꞌu tiꞌitɨ́j amuaataseíjrateꞌesin sino ayée nuꞌu, ɨ́ tɨ éꞌeseijreꞌe jɨ́meꞌen aꞌɨ́jna ɨ́ Jonás. Aj pu i Jesús á huajaꞌutéhuii. Tɨꞌɨj jí iyáꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Matɨ́ꞌɨj antacɨ́j utavén pújmeꞌen aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú yaꞌuhuáꞌaxɨ ɨ́ mej yeꞌeraꞌɨ́ꞌɨpɨꞌɨn ɨ́ pan mej ráacuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen, seꞌɨ́jna jɨmeꞌe fariseos mej ruꞌuteáaratzaca ɨ́ pan tzajtaꞌa tɨ ij ájcuꞌustaa, seajta seꞌɨ́jna jɨmeꞌe saduceos mej majta ruꞌuteáaratzaca. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Majta aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú tíꞌiruꞌixaateꞌecaꞌa rujɨ́ɨmuaꞌa. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee tiuꞌutaxájtacaꞌa amɨ́jna, aꞌiné catu yeꞌeráꞌɨꞌɨpɨ ɨ́ pan. ");
INSERT INTO crnNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Aj pu i Jesús ráamuaꞌareeriꞌi aꞌij mej yeꞌí tíꞌixajtacaꞌa. Tɨꞌɨj jí ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Múꞌeen, mɨ sej caí aꞌatzu téꞌatzaahuateꞌe, ¿aꞌiné ꞌeen jɨ́n siyen tíꞌiruꞌixaateꞌe yee sej caí pan tíchaꞌɨɨ? ");
INSERT INTO crnNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ni secaí xɨ yaúꞌitɨe? ¿Ni seri yaꞌuhuáꞌaxɨ aꞌachú tɨ puaꞌan sicɨ́ri teꞌirájraa ɨ́ pan tɨ teꞌaváꞌaturaa netɨ́ꞌɨj huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ mej anxɨ́j viꞌiraꞌa aráꞌasecaꞌa ɨ́ teɨte neꞌɨ́jna jɨmeꞌe ɨ́ taꞌanxɨ́vi ɨ́ pan? ");
INSERT INTO crnNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","’¿Ni seajta seri yaꞌuhuáꞌaxɨ aꞌachú sej puaꞌamé caj teꞌevéꞌejɨste ɨ́ sicɨ́ri jetze netɨ́ꞌɨj huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ mej muáacua viꞌiraꞌa aráꞌasecaꞌa ɨ́ teɨte neꞌɨ́jna jɨmeꞌe ɨ́ taꞌaráhuaꞌapua ɨ́ pan? ");
INSERT INTO crnNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","’¿Aꞌiné auj tíꞌirɨꞌɨri sej caí yaúꞌitɨe seꞌɨ́jna, ɨ́ nej caí jáꞌamuaꞌixaateꞌe neꞌɨ́jna jɨmeꞌe ɨ́ pan sino rɨ́ꞌɨ xuꞌu múꞌeen seꞌɨ́jna ɨ́ mej caí jéꞌiyecan jɨ́n tíꞌixaxaꞌa aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ saduceos? ");
INSERT INTO crnNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Aj mú xaa mi yaúꞌitɨée muáꞌaraa tɨ ayén tihuáꞌixaateꞌe aꞌɨ́jna jɨmeꞌe aꞌij mej yeꞌí tíꞌimuaꞌataca aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ saduceos. Capu xaa neꞌu ayén aꞌɨ́jna jɨ́n tihuaꞌutáꞌixaa yee rɨ́ꞌɨ xuꞌu múꞌeen seꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n ruꞌuteáaratzaca ɨ́ pan tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tɨꞌɨj jí Jesús aꞌuun aꞌaráꞌa aꞌujna jáꞌahuaꞌa aꞌuun tɨ eꞌejtémeꞌecan tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Cesarea de Filipo. Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―¿Aꞌiquí metíꞌixa ɨ́ teɨte jaꞌatɨ́ nej púꞌeen i nej neajta teáataꞌa jetze airáane? ");
INSERT INTO crnNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Seica mú miyen tiꞌixa pej nuꞌu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Juan teecan tɨ tíꞌitemuaɨꞌɨhuacareꞌe, majta seica miyen tiꞌixa pej nuꞌu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Elías, majta seica miyen tɨjɨ́n pej nuꞌu aꞌɨ́ɨn púꞌeen aꞌɨ́jna Jeremías teecan naꞌari pej nuꞌu seɨ́j púꞌeen aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Ari múꞌeen, ¿aꞌiné tejamuáꞌamitɨejteꞌe aꞌatani nej púꞌeen? ");
INSERT INTO crnNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ajta aꞌɨ́jna ɨ́ Simón, tɨ ajta iꞌi Pedro, aꞌɨ́ɨ pu ayén tiraatáꞌixaa tɨjɨ́n: ―Muꞌée pej peꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ Cɨríistuꞌu tɨ Dios án yáꞌujra ɨ́ ɨpuari japua, múꞌee pej peꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ yaujraꞌan ɨ́ Dios tɨ iꞌi ruuri. ");
INSERT INTO crnNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesús pu ayén tiraatáꞌixaa tɨjɨ́n: ―Patáꞌaj huáꞌatemuaꞌaveꞌen múꞌee, Simón, i pej iꞌi yaujraꞌa aꞌɨ́jna ɨ́ Jonás. Huáꞌatemuaꞌaveꞌe aꞌɨ́jna jɨmeꞌe, aꞌiné capu jaꞌatɨ́ ayén timuaatáꞌixaa tɨ íiyen seijreꞌe chaanaca japua, sino aꞌɨ́jna tɨ níꞌiyaꞌupua tɨ júteꞌe éꞌeseijreꞌe u ta japua, aꞌɨ́ɨ pu xaa ayén timuaatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","’Neajta inee, ayée nu hui tíꞌimuaꞌixaateꞌe pej múꞌee peꞌɨ́n púꞌeen ɨ́ Pedro, ɨ́ pej pajta piyen ántehuaa tɨjɨ́n ɨ́ tɨ iꞌi tetej. Neajta inee, neꞌíjna japua i tetej, nee nu ráꞌajtaahua ɨ́ neteyuu. Ajta, capu rɨꞌɨríista aꞌame tɨ aꞌɨ́ɨn tiyaaruꞌu raatémuaꞌitɨn aꞌɨ́jna ɨ́ tɨ aꞌɨ́jna jɨ́n antiújmuaꞌaree mej mi huácuiꞌini ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","’Nee nu muaatáꞌasin pej peꞌɨ́jna jɨ́n antíꞌamuaꞌaréere pej tihuaꞌantácuuneꞌen ɨ́ teɨte mej mi aꞌuteárute aꞌájna Dios tɨ tejéꞌaijta. Patɨ́j penaꞌa pej teꞌiteanán íiyen chaanaca japua, Dios pu ayén cheꞌatá naꞌa teꞌiteánajsin u ta japua. Ajta patɨ́j penaꞌa pej teꞌantácuuna íiyen chaanaca japua, Dios pu ajta ayén cheꞌatá naꞌa teꞌantácuuna u ta japua. ―Ayee pu tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aj pu i Jesús ayén tihuauꞌíjca aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe mej nuꞌu caí jaꞌatɨ́ ixaateꞌe tɨ aꞌɨ́ɨn púꞌeen aꞌɨ́jna tɨ Dios án yáꞌujra ɨ́ ɨpuari japua. ");
INSERT INTO crnNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Aꞌájnáꞌɨmua, Jesús pu aꞌutéjche tɨ tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨ nuꞌu ayén ruxeꞌeveꞌe tɨ áꞌuraꞌani aꞌánna Jerusalén. Aꞌuu pu nuꞌu jeíhua rajpuaíitzi aꞌame. Majta nuꞌu aꞌɨ́ɨme ɨ́ mej huaꞌavaujsi ɨ́ mej Israél jetze ajtémeꞌecan, majta nuꞌu aꞌɨ́ɨme ɨ́ mej tíꞌaijta huaꞌatéyujtaꞌa, majta nuꞌu aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, naímiꞌi mú aꞌij puaꞌa raruuren. Ruxeꞌeveꞌe nuꞌu mej raajéꞌica. Aj pu ijta huatarújsin huaíca xɨcájraꞌa jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ajta aꞌɨ́ɨn ɨ́ Pedro, aꞌɨ́ɨ pu raꞌiráaviꞌitɨ ꞌáꞌayee. Aj pu i aꞌutéjche tɨ raꞌajteáꞌaxɨꞌɨn aꞌɨ́jna ɨ́ Jesús. Ayee pu tiraatáꞌixaa tɨjɨ́n: ―Chéꞌe aꞌij tíꞌimuavaɨreꞌe tɨ ij caí ayén tíꞌimuaruure, nevástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Aj pu i pɨ́ ancuréꞌejvej aꞌɨ́jna ɨ́ Jesús. Ayee pu tiraatáꞌixaa aꞌɨ́jna ɨ́ Pedro tɨjɨ́n: ―Aricu áꞌuraꞌa, mɨ pej iꞌi Satanás. Jéꞌecan pej tinaꞌantiúꞌuuniꞌi nej ni auteáturan ɨ́ Dios jemi aꞌiné capej piyen tíꞌimuaꞌatze aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, sino aꞌij mej tíꞌijxeꞌeveꞌe ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ nee jamuan áꞌucheꞌecaneꞌen, ruxeꞌeveꞌe tɨ aꞌɨ́ɨn caí chéꞌe ayén rɨjca aꞌij tɨ tíꞌijxeꞌeveꞌe ruseɨ́j, sino ayée pu tiúꞌujxeꞌeveꞌe tɨ aꞌɨ́ɨn rajpuaíitzi áꞌaraꞌani nee jamuan ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","’Ayee puꞌu, jaꞌatɨ́ tɨ naꞌa tɨ tíꞌiteseꞌe tɨ caí huámɨꞌɨni, aꞌɨ́ɨ pu xaa neꞌu mɨꞌɨni. Aꞌɨ́j pu áꞌujɨsin ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa. Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ́ tɨ ayén éeniꞌicɨꞌe huámɨꞌɨni aꞌɨ́jna jɨmeꞌe tɨ naꞌaráꞌastijre ineetzi, aꞌɨ́ɨ pu xaa neꞌu rateuni ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","’Ahuii, tɨ puaꞌa jaꞌatɨ́ nain huamuáꞌitɨn naíjmiꞌi tɨ íiyen seijreꞌe chaanaca japua, ¿ni qui tiraatévaꞌɨri aꞌɨ́jna tɨ raamuáꞌitɨ tɨ puaꞌa yáꞌurɨeeni ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa? Capu xaa neꞌu aꞌatzu tiraatévaꞌɨri. Ari, ¿tiꞌitáani jɨ́n tíꞌipuataꞌatan aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ij Dios ajtahuaꞌa raatátɨsten ɨ́ xɨéjniuꞌucareꞌaraꞌan tɨ auj ruuricaꞌa? Capu tiꞌitɨ́j jɨ́n tíꞌipuataꞌatan xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","’Neajta inee, i nej neajta teáataꞌa jetze airáane, nee nu neajtahuaꞌa yé veꞌecánejsin. Ayee nu cheꞌatá nenaꞌa huataseíjreꞌesin nain jɨmeꞌe tɨ́j ajta seijreꞌe ɨ́ Dios tɨ níꞌiyaꞌupua. Huáꞌa jamuan nu hui neajta huataseíjreꞌesin aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe ɨ́ ta japua. Neajta nu tihuaꞌutáꞌasin seɨ́j neajta seɨ́j naíjmiꞌica aꞌij tɨ tihuaꞌuvíjteꞌe aꞌij mej tiꞌitɨ́j huáruu, seɨ́j ajta mɨ seɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, seica mej yé huatéꞌuuca ayajna, aꞌɨ́ɨ mú caí huácuiꞌini ajta menaꞌa caí amuacaícan naaseíj ɨ́ nej neajta teáataꞌa jetze airáane nej ni yé tanén nej ni tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Teuuméꞌeca aꞌachú cumu arájsevi xɨca, aj puꞌi Jesús antíraa jɨrí japua. Aꞌɨ́mej pu aꞌuvíꞌitɨ aꞌɨ́jna ɨ́ Pedro, ajta aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan, ɨ́ tɨ juutzeájraꞌan púꞌeen aꞌɨ́jna ɨ́ Jacobo. ");
INSERT INTO crnNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Matɨ́ꞌɨj meꞌuun aꞌutéꞌuucaꞌa, aj puꞌi seɨcɨé tiuꞌutaújseijratacaꞌa aꞌɨ́jna ɨ́ Jesús mej seijraca. Ayee pu temuaꞌa tiꞌitémastacareꞌe ɨ́ néerimeꞌaraꞌan tɨ́j xɨcaj. Temuaꞌa pu tiuꞌutécuainarecaꞌa ɨ́ cɨ́ɨxureꞌaraꞌan. Ayee pu tiꞌitetáatɨyeꞌicaa tɨ́j taij. ");
INSERT INTO crnNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Majta áꞌiyen, huaꞌapua huataseíjre huáꞌa tzajtaꞌa. Aꞌii mú aꞌɨ́ɨn púꞌeeneꞌe aꞌɨ́jna ɨ́ Moisés teecan, ajta aꞌɨ́jna ɨ́ Elías tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Aꞌɨ́ɨ mú tíꞌixajtacaꞌa ɨ́ Jesús jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ajta aꞌɨ́ɨn ɨ́ Pedro, aꞌɨ́ɨ pu ayén tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Tavastaraꞌa, naa pu xɨ́ꞌepɨꞌɨn tej yé huatéꞌuu tiyajna. Tɨ́ puaꞌa muaꞌaráanajche, tej huaícaca huátaahuaa ɨ́ ɨnaamua. Seɨ́j pu muacɨꞌɨti múꞌeetzi, ajta seɨ́j, amɨ́jna mɨ Moisés. Ajta seɨ́j pu racɨꞌɨti amɨ́jna mɨ Elías. ");
INSERT INTO crnNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aúcheꞌe pu tiꞌixáatacaꞌa tɨ́ꞌɨj jaitɨri eꞌecáviꞌirixɨ huáꞌa japua. Huáꞌa tzajtaꞌa pu rájrupi aꞌɨ́jna ɨ́ jaitɨri tɨ naa tiꞌitetáatɨyeꞌi. Aj pu i tzajtaꞌan eꞌicánamuajre tɨ jaꞌatɨ́ ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ niyauj, ɨ́ nej raxɨ́ꞌeveꞌe. Jéꞌecan pu rɨ́ꞌɨ tineetáꞌaca ineetzi. Xáanamuajriꞌi seꞌíjna. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Matɨ́ꞌɨj ráanamuajriꞌi meꞌɨ́jna, aj mú mi eꞌeráavatzɨ á chuaataꞌa aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌiné temuaꞌa mú tiuꞌutátziɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Aj pu i Jesús á veꞌeréꞌene huáꞌa jemi. Tɨꞌɨj jí huaꞌajtamuárɨej. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Xáꞌajhuiixɨꞌɨ múꞌeen. Caxu tíꞌitziɨɨneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Majta meꞌɨ́n, Matɨ́ꞌɨj mé uunéjneꞌerecaꞌa, capu chéꞌe méꞌe éꞌejaꞌatɨjcaꞌa. Aꞌii puꞌu án jéꞌeseijreꞌecaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Matɨ́ꞌɨj jáꞌitaꞌa aꞌucajúꞌuca ɨ́ jɨrí japua, Jesús pu ayén tihuaꞌutáꞌijmɨijriꞌi tɨjɨ́n: ―Caxɨ́ɨ xu jaꞌatɨ́ ixaateꞌe aꞌij sej tiuꞌuséij. Seucheꞌe rachúꞌeveꞌe ajta nenaꞌa caí inee, i nej neajta teáataꞌa jetze airáane, aitáraꞌani huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ");
INSERT INTO crnNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n miyen tíꞌixaxaꞌa aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze miyen tɨjɨ́n amuacaí pu nuꞌu ruxeꞌeveꞌe tɨ yé uvéꞌenen aꞌɨ́jna ɨ́ Elías? ");
INSERT INTO crnNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej tiꞌayajna. Elías pu xaa yé uvéꞌenejsin tɨ ij nain tiuꞌujéjcuareꞌen mej mi majtáhuaꞌa raꞌaráꞌastijreꞌen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe tɨ aꞌɨ́ɨn Elías ari yé uvéꞌene. Majta meꞌɨ́n, camu raamuáꞌa sino ayée mú ráaruu aꞌij mej tíꞌijxeꞌeveꞌecaꞌa. Ayee mú majta cheꞌatá menaꞌa neruuren ineetzi, i nej neajta teáataꞌa jetze airáane. Puaíjtzi mú majta naatáꞌasin ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj mú mi ráamuaꞌareeriꞌi tɨ aꞌɨ́ɨn aꞌɨ́jna jɨ́meꞌen tiuꞌutaxájtacaꞌa ɨ́ Juan teecan tɨ huáꞌamuaɨꞌɨhuacareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Matɨ́ꞌɨj meꞌuun aꞌaráꞌa aꞌu mej eꞌetiújseɨreꞌecaꞌa jeíhua ɨ́ teɨte, seɨ́j pu aveꞌeréꞌene ɨ́ Jesús jemi. Aj pu i eꞌevéꞌetunutacaꞌa vejliꞌipuan. ");
INSERT INTO crnNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ayee pu tirájhuaviiriꞌi tɨjɨ́n: ―Nevástaraꞌa, patáꞌaj ráꞌancuꞌuvajxɨꞌɨn ɨ́ niyauj. Aꞌɨ́ɨ pu rutɨ́muaꞌi. Aꞌɨ́j pu jɨ́n rajpuaíjtzi huápɨꞌɨ. Muꞌiitɨ́ pu anájve taij tzajtaꞌa, ajta á jaataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nee nu yeꞌeráaviꞌitɨ aꞌɨ́mej jemi ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan mej mi tiráahuaateꞌen. Majta meꞌɨ́n, camu raayɨ́ꞌɨtɨhuaꞌa muáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Múꞌeen mɨ sej caí aꞌatzu téꞌatzaahuateꞌe, mɨ sej caí mé úumuaꞌaree, ¿aꞌachúni puaꞌan nineꞌiraꞌa aúcheꞌe ruvɨꞌeꞌeveꞌe nej niyen huatevée náꞌaraꞌani múꞌejmi jemi? ¿Ni ayén ruxeꞌeveꞌe nej áꞌateeviꞌin tɨ́j naꞌa rusén jɨmeꞌe nej niyen múꞌejmi jemi yé huatéveeca nej ni rɨ́ꞌɨ amuáaruuren? Mé seꞌevéꞌeviꞌitɨchi mɨ paꞌarɨꞌɨ. Matɨ́ꞌɨj mi á yeꞌevéꞌeviꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Aj pu i Jesús raꞌajtéꞌaxɨ aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ paꞌarɨꞌɨ tzajtaꞌa seijreꞌecaꞌa. Aj pu i huirájraa. Jɨ́meꞌen puꞌu huirájraa, tɨꞌɨquí huarúj aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Matɨ́ꞌɨjtá mi, aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, rujɨ́ɨmuaꞌa mú tiuꞌuxájtacaꞌa aꞌɨ́jna jamuan ɨ́ Jesús. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n tecaí raayɨ́ꞌɨtɨhuaꞌa taꞌaraa tej raatamuáriteꞌen teꞌɨ́jna ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee puꞌu tiꞌayajna, aꞌiné caxu aꞌatzu téꞌatzaahuateꞌe. Ayee nu tejáꞌamuaꞌixaateꞌe jéꞌiyecan jɨmeꞌe, temuaꞌa pu tíꞌivaɨreꞌe sej siyen téꞌatzaahuateꞌe ɨ́ ru tzajtaꞌa tɨ ayén tejaꞌuréꞌenen aꞌij tɨ tejamuáꞌamitɨejteꞌe. Aꞌɨ́ɨ puꞌu ruxeꞌeveꞌe sej siyen téꞌatzaahuateꞌe cɨ́j caj. Tɨ́ puaꞌa siyen cɨ́j caj téꞌatzaahuateꞌe, aj pu xaa rɨꞌɨrí sej si siyen tiraataꞌaíjteꞌen amɨ́jna mɨ jɨrí tɨjɨ́n: “Tíchesi, ateájraꞌa á jaataꞌa jáꞌahuaꞌa játeꞌana jetze tɨ veꞌée.” Ajta aꞌɨ́ɨn mɨ jɨrí, ayée xaa neꞌu rɨni. Ayee puꞌu xaa neꞌu, tɨ puaꞌa siyen téꞌatzaahuateꞌe, nain xu jɨ́n raayɨ́ꞌɨtɨhuaꞌa xáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ajta, setáꞌaj siyen raatamuáriteꞌen seꞌɨ́jna ɨ́ tiyaaruꞌu tɨ ayén ꞌeen tɨ́j amɨ́jna, ayée pu tiúꞌujxeꞌeveꞌe sej raatáhuavii ɨ́ Dios, seajta huaúruꞌitziꞌiveꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Matɨ́ꞌɨj mauj naíjmiꞌi áꞌujujhuaꞌaneꞌe meꞌújna jáꞌahuaꞌa tɨ jetzen eꞌejtémeꞌecantacaꞌa u Galilea, Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu jaꞌatɨ́ tiuꞌutátuiireꞌesin ineetzi jɨmeꞌe i nej neajta teáataꞌa jetze airáane. Aꞌɨ́ɨ pu neetzi jɨmeꞌe huaꞌutátuiireꞌesin aꞌɨ́mej jemi ɨ́ teteca. ");
INSERT INTO crnNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Majta meꞌɨ́n, ayée mú neejéꞌicatan. Mɨ́ neajta inee, ayée nu hui huatarújsin huaíca xɨca jetze. Yee puꞌu xaa neꞌu tejaꞌuréꞌenejsin. Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, jeíhua mú huataújxɨeemɨste matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Matɨ́ꞌɨj mi chajtaꞌa aꞌaráꞌa aꞌujna Capernaúm. Matɨ́ꞌɨj mi seica eꞌiréꞌene jemin aꞌɨ́jna ɨ́ Pedro. Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej tiúꞌujijveꞌe meꞌɨ́jna jɨmeꞌe ɨ́ huaꞌapua tumin ɨ́ tɨ jɨ́n tiuꞌutévaɨreꞌesin huáꞌa teyujtaꞌa. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni caí tíꞌinajchitan aꞌamua maestro aꞌɨ́jna ɨ́ huaꞌapua tumin ɨ́ tɨ tiuꞌutévaɨreꞌesin u tatéyujtaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aa niꞌijtá neꞌu. Aj pu i Pedro uteájrupi u chiꞌita. Capu xɨ tiꞌitɨ́j aꞌij tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro, sino Jesús pu amuacaí ayén tiraatáꞌixaa tɨjɨ́n: ―¿Aꞌiné timuáꞌamitɨejteꞌe, Simón? ¿Aꞌatéenqui mejíjveꞌe aꞌɨ́mej ɨ́ rey ɨ́ mej tíꞌaijta íiyen chaanaca japua? ¿Aꞌatéenqui mejíjveꞌe caꞌɨ́n aꞌɨ́ɨme ɨ́ mej tíꞌituaꞌaraca ɨ́ mej teꞌiráatɨꞌɨcɨ, naꞌari meꞌɨ́jna jɨmeꞌe aꞌachú tɨ caj seɨ́j tíꞌijchaꞌɨɨ? ¿Ni qui aꞌɨ́mej mejíjveꞌe ɨ́ ruyaujmuaꞌa caꞌɨ́n qui aꞌɨ́mej ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro pu ayén tiuꞌutaniú tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan. Ajta Jesús pu ayén tiraatáꞌixaa tɨjɨ́n: ―Aꞌɨ́j pu jɨ́n, capu ruxeꞌeveꞌe ɨ́ mej tiuꞌutanájchita aꞌɨ́ɨme ɨ́ huáꞌayaujmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","’Mɨ́ ajta, tetáꞌaj caí tiyen huaꞌutaníniuꞌucasteꞌen, ayée pej huárɨni. Patáꞌaj hui u áꞌumeꞌen aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj. Pajta raꞌateáhuaꞌaxɨn ɨ́ cuaꞌitzɨꞌɨpua á jaataꞌa. Pajta, peꞌɨ́jna ɨ́ huaꞌí, ɨ́ taꞌamuájca pej raatéviꞌira, patáꞌaj raꞌacánaꞌaxɨn, án pej pi yéꞌeteuni ɨ́ téneꞌetzeꞌen seɨ́j ɨ́ tumin tɨ ayén tíꞌijnajche aꞌachú cumu muáacua tumin. Patáꞌaj yeꞌeráꞌɨn ɨ́ tumin patáꞌaj tihuaꞌunájchiteꞌen, pajta ineetzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Aꞌájnáꞌɨmua, aꞌɨ́ɨ mú aveꞌeréꞌene ɨ́ Jesús jemi aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌataani jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi seɨ́j ɨ́ tɨ ta jetze ajtémeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aj pu i Jesús seɨ́j huatajé ɨ́ paꞌarɨꞌɨ. A jáꞌitaꞌa yaꞌutára aꞌu mej eꞌeréꞌetei ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Jee xaa, ayée nu tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna. Tɨ́ puaꞌa secaí seɨcɨé tiúꞌumuaꞌati, tɨ puaꞌa secaí siyen rahuauca sej siyen cheꞌatá senaꞌa jéꞌiyecan jɨ́n tíꞌimuaꞌajca matɨ́j mɨ tɨꞌɨríi, caxu jaꞌanáj aꞌuteáruti ɨ́ ta japua Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","’Aꞌɨ́j pu jɨ́n ayén tíꞌeen, jaꞌatɨ́ tɨ naꞌa tɨ ayén huataújseijrata tɨ caí tiꞌitɨ́j jɨ́n ruxeꞌeveꞌe, ayée pu xaa éeneꞌe aꞌame tɨ́j aꞌíjna i paꞌarɨꞌɨ. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ajta, jaꞌatɨ́ tɨ naꞌa tɨ ayén raꞌancuréꞌeviꞌitɨ neniúucajtzeꞌe seɨ́j ɨ́ paꞌarɨꞌɨ tɨ́j aꞌíjna, aꞌɨ́jna ɨ́ tevi, aꞌɨ́ɨ pu ajta naꞌancuréꞌeviꞌitɨ ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Jaꞌatɨ́ tɨ naꞌa tɨ aꞌij puaꞌa tiruꞌutéꞌan ɨ́ ru tzajtaꞌa ɨ́ ruxɨ́ꞌej paꞌarɨꞌɨ tɨ ayén náꞌatzaahuateꞌe tɨ́j aꞌíjna, ayée pu tɨꞌɨjtzú aꞌɨ́ɨn ɨ́ jaꞌatɨ́, amuacaí mej meꞌuun u raꞌacáaviꞌire ɨ́ tete seꞌuníjraꞌa tɨ veꞌée matáꞌaj raꞌateájrɨeeni á jaataꞌa tɨ ij aꞌɨ́ɨn aꞌujámɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","’Cuiꞌi xaa huáꞌa jemi, aꞌɨ́mej ɨ́ mej yen huachéjme íiyen chaanaca japua, ɨ́ mej majta caꞌaníjraꞌa huaꞌatáꞌaca ɨ́ seica mej mi auteáturan ɨ́ Dios jemi. Ayee pu tiujúꞌujxeꞌeveꞌe mej mi ɨ́ seica ayén auteáturan ɨ́ Dios jemi. Mɨ́ ajta, cuiꞌi xaa neꞌu aꞌɨ́jna jemi tɨ ayén caꞌaníjraꞌa huaꞌatáꞌaca mej mi miyen huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Patɨ́ꞌɨj auteáturan ɨ́ Dios jemi, tɨ puaꞌa piyen tiruꞌujpuáꞌajteꞌen ɨ́ á jetze, piyen tɨjɨ́n nemuajcaꞌa pu púꞌeeneꞌe, naꞌari neꞌɨ́ɨca pu púꞌeeneꞌe, ayée nu tíꞌimuaꞌixaateꞌe. Paraꞌantiveíjche, pej pi mé rúurɨeni. Jéꞌecan pu jaítzeꞌe timuaatévaꞌɨre pej aꞌuteáturan seɨ́j jɨmeꞌe ɨ́ amuájcaꞌa, naꞌari seɨ́j jɨmeꞌe ɨ́ aꞌɨ́ɨca aꞌájna Dios tɨ éꞌeseijreꞌe, aꞌájna pej eꞌerúuri puaꞌamé jemin. Naꞌari pecaí piyen huárɨni, huaꞌapuaca pej jɨ́n ɨ́ amuájcaꞌa naꞌari huaꞌapuaca jɨ́n ɨ́ aꞌɨ́ɨca pej aꞌuteáruti aꞌájna jáꞌahuaꞌa aꞌu tɨ caí éꞌemɨꞌɨni ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","’Ajta, tɨ puaꞌa piyen jetzen tiruꞌujpuáꞌajteꞌen muaꞌa jɨ́ꞌɨ peꞌɨ́jna ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi, aitátɨchi. Mé pej rúurɨeeni. Jéꞌecan pu timuaatévaꞌɨre pej piyen aꞌuteárute seɨ́j jɨmeꞌe ɨ́ ꞌajɨ́ꞌɨ aꞌájna Dios tɨ tejéꞌaijta. Naꞌari caí, ayée pej huaꞌapuaca jɨ́n ájjɨꞌɨsi tɨ́ꞌɨj aꞌɨ́ɨn muajáꞌujɨsin aꞌu tɨ caí jaꞌanáj éꞌemɨꞌɨni ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Rɨ́ꞌɨ xuꞌu múꞌeen sej si caí aꞌij puaꞌa huajáꞌuseijra seɨ́j tɨ auj cɨ́lieen. Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe u ta japua, ɨ́ mej majta huáꞌachaꞌɨɨ muáꞌaraꞌani, jaꞌanáj tɨ naꞌa, aꞌɨ́ɨ mú huatéꞌuu jemin ɨ́ tɨ níꞌiyaꞌupua tɨ éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ayee nu ꞌeen jɨ́n mú aꞌuvéꞌemej inee, i nej neajta teáataꞌa jetze airáane nej ni huáꞌa japua huániuuni aꞌɨ́jna tɨ áꞌuvej. ");
INSERT INTO crnNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Aꞌiné tejamuáꞌamitɨejteꞌe aꞌij tɨ huárɨni ɨ́ jaꞌatɨ tɨ anxɨ́te huáꞌajyeꞌemua ɨ́ cáneꞌaxɨ? Tɨ́ puaꞌa seɨ́j áꞌuveti mé jáꞌahuaꞌa, ¿ni caí ayén rɨni? Aꞌɨ́ɨ pu huajaꞌutéhuiiteꞌesin naíjmiꞌica ɨ́ seica aꞌánna jɨrí jetze. U pu aꞌuméꞌe aꞌame tɨ ij raaréꞌehuauni aꞌɨ́jna tɨ áꞌuvej. ");
INSERT INTO crnNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ajta, ayée nu tejáꞌamuaꞌixaateꞌe. Ayee pu tiꞌayajna, tɨ puaꞌa aꞌɨ́ɨn méꞌe yéꞌuteuni, jaítzeꞌe pu rɨ́ꞌɨ tiraatáꞌixaa aꞌɨ́jna jɨmeꞌe tɨ ráateu ɨ́ tɨ áꞌuvej, caí mɨ seica ɨ́ tɨ ari huájaꞌutéhuiiteꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","’Ayee pu cheꞌatá naꞌa ꞌeen aꞌɨ́jna jemi aꞌɨ́jna ɨ́ tɨ áꞌamuaꞌiyaꞌupua tɨ ta japua éꞌeseijreꞌe. Capu aꞌatzu raxɨ́ꞌeveꞌe tɨ seɨ́j áꞌuveti tɨ cɨ́lieen tɨ́j aꞌíjna i paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tɨ́ puaꞌa aꞌihuáaraꞌa tiꞌitɨ́j jɨ́n autéꞌɨtzen múꞌeetzi jemi, ayée pej huárɨni. Aricu, u aꞌutáꞌixaateꞌe avíitzi jɨmeꞌe ɨ́ tɨ jɨ́n autéꞌɨtze múꞌeetzi jemi. Tɨ́ puaꞌa aꞌɨ́ɨn muáꞌantzaahuateꞌen, múꞌee pej xaa raamuáꞌitɨ ɨ́ aꞌihuáaraꞌa sej si seajtáhuaꞌa ruꞌihuaamuaꞌa xáꞌaraꞌani temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mɨ́ ajta, tɨ puaꞌa caí muáꞌantzaahuateꞌen, patáꞌaj seica ánviꞌitɨn aꞌɨ́jna jemi, huaꞌapuaca mej mi ráamuaꞌaree tɨ puaꞌa muáꞌantzaahuateꞌen nusu caí. Tɨ́ puaꞌa aꞌihuáaraꞌa caí muáꞌantzaahuateꞌen, aꞌɨ́ɨme ɨ́ mej huaꞌapua, ayée mú tiuꞌutaxájta tɨ ayén tiꞌayajna ɨ́ pej jɨ́n jetzen tíꞌijpuaꞌajteꞌe aꞌɨ́jna ɨ́ aꞌihuáaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ajta áꞌiyen, tɨ puaꞌa caí huáꞌantzaahuateꞌen ɨ́ mej huaꞌapua, patáꞌaj huaꞌutáꞌixaateꞌen naíjmiꞌica ɨ́ mej tiújseꞌɨri. Ajta, tɨ puaꞌa aꞌihuáaraꞌa caí huáꞌantzaahuateꞌen aꞌɨ́mej, ayée pej cheꞌatá penaꞌa raruuren patɨ́j huáꞌaruure aꞌɨ́mej ɨ́ mej caí ajtémeꞌecan múꞌejmi jetze nusu aꞌɨ́ɨme ɨ́ mej tiúꞌujijveꞌe ɨ́ gobierno jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, setɨ́j senaꞌa sej tíꞌijmɨi íiyen chaanaca japua, Dios pu ayén cheꞌatá naꞌa téꞌijmɨ u ta japua. Ajta setɨ́j senaꞌa sej huatáꞌaca íiyen chaanaca japua, Dios pu ayén cheꞌatá naꞌa huatáꞌaca u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Neajta nu niyen tejáꞌamuaꞌixaateꞌe mɨ sej íiyen chaanaca japua huatéꞌuu, tɨ puaꞌa siyen cheꞌatá senaꞌa tirúꞌumuaꞌareere mɨ sej huaꞌapua seꞌɨ́jna jɨmeꞌe aꞌij sej yeꞌí tíꞌijhuaviiran ɨ́ Dios jemi, aꞌɨ́jna tɨ níꞌiyaꞌupua, ayée pu cheꞌatá naꞌa áꞌamuaruure aꞌij sej tíꞌijhuavii. ");
INSERT INTO crnNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ayee pu hui téꞌeme, aꞌiné aꞌu tɨ naꞌa mej eꞌetiújseꞌɨri neniúucajtzeꞌe, aꞌúu nu aꞌutevée naꞌame huáꞌa tzajtaꞌa. Capu amɨ́n aꞌij tɨ puaꞌa mehuaꞌapuáj menaꞌa naꞌari mehuaíca menaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ajta aꞌɨ́ɨn ɨ́ Pedro, aꞌɨ́ɨ pu aveꞌeréꞌene ɨ́ Jesús jemi. Ajta ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Nevástaraꞌa, ¿aꞌachúni puaꞌamé ruxeꞌeveꞌe nej tiraatáꞌuuniꞌi ɨ́ neꞌihuaaraꞌa tɨ puaꞌa tiꞌitɨ́j jɨ́n autéꞌɨtzen neetzi jemi? ¿Ni qui aráhuaꞌapua puaꞌamé? ");
INSERT INTO crnNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús pu ayén huataniú tɨjɨ́n: ―Canu niyen raataxájta yee aráhuaꞌapua, sino aráhuaꞌapuájetze huaícate japuan tamuáamuataꞌa japuan aráhuaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ayee pu tíꞌijxeꞌeveꞌe ɨ́ Dios mej mi tiꞌihuaúruuniꞌi seɨj majta seɨj. Naꞌari caí, ayée pu cheꞌatá naꞌa huáꞌaruuren tɨ́j aꞌɨ́jna ɨ́ rey tɨ ayén tíꞌijxeꞌeveꞌecaꞌa tɨ raaxɨ́ꞌepɨꞌɨntareꞌen aꞌachú mej caj téꞌechaꞌɨɨcaꞌa aꞌɨ́ɨme ɨ́ mej ravaɨreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Puꞌuri aꞌutéjche tɨ ayén tiraaxɨ́ꞌepɨꞌɨntareꞌen, matɨ́ꞌɨj seɨ́j aꞌuréꞌeneijte jemin tɨ jeíhua téꞌechaꞌɨɨcaꞌa, aꞌachú cumu tamuáamuataꞌa viꞌiraꞌa tumin. ");
INSERT INTO crnNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ajta aꞌɨ́jna tɨ téꞌechaꞌɨɨcaꞌa, capu tíꞌituaaveꞌecaꞌa ɨ́ tɨ jɨ́n tiraanájchiteꞌen. Aꞌɨ́j pu jɨ́n, ɨ́ rey ayén tiuꞌutaꞌaíjtacaꞌa mej nuꞌu huáꞌutuaani aꞌɨ́jna ɨ́ teáataꞌa, ajta ɨ́ ɨ́raꞌaraꞌan, majta ɨ́ tɨꞌɨríi ajta nain tɨ tíꞌijchaꞌɨɨ. Ayee pu tiuꞌutaꞌaíjtacaꞌa tɨ ij tiraanájchiteꞌen nain aꞌachú tɨ téꞌechaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","’Aj pu i aꞌɨ́ɨn tɨ téꞌechaꞌɨɨ títunutacaꞌa á vejliꞌipua ɨ́ rey jemi. Jéihua pu rajjé tɨjɨ́n: “Paúcheꞌe nechuꞌeveꞌe. Nee nu xaa tíꞌimuanajchiteꞌen nain jɨmeꞌe aꞌachú nej timuáꞌachaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","’Ajta aꞌɨ́jna tɨ rajíjveꞌe, aꞌɨ́ɨ pu ráꞌancuꞌuvajxɨ. Tiraatáꞌuuniꞌiriꞌi nain jɨmeꞌe ɨ́ tɨ téꞌechaꞌɨɨcaꞌa. Aj pu i raatátuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","’Jɨ́meꞌen puꞌu huirájraa aꞌɨ́jna tɨ ravaɨreꞌe, aj pu i seɨ́j huáteu tɨ ayén ajta tiráꞌachaꞌɨɨreꞌecaꞌa. Anxɨ́te tumin puꞌu téꞌechaꞌɨɨcaꞌa. Aꞌɨ́ɨ pu raatéeviꞌi. Tɨꞌɨj jí aꞌutéjche tɨ raꞌantéeviꞌi ɨ́ cɨjpáaraꞌan jetze. Caꞌanín pu jɨ́n ayén tiraataꞌaíjte tɨjɨ́n: “Tinaanájchiteꞌe aꞌachú pej tináꞌachaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","’Aj pu i títunutacaꞌa aꞌɨ́jna tɨ ajta ayén ravaɨreꞌecaꞌa aꞌɨ́jna ɨ́ rey. Ayee pu tiraatajé tɨjɨ́n: “Paúcheꞌe nechuꞌeveꞌe. Nee nu tíꞌimuanajchiteꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","’Mɨ́ ajta aꞌɨ́jna ɨ́ seɨ́j, capu raataxɨ́ꞌeve, sino iyáꞌuraa. Ajta áꞌiyen tíraataꞌaíjtacaꞌa mej nuꞌu raꞌiteáanan ajta naꞌa caí tiraanájchiteꞌen nain aꞌachú tɨ téꞌechaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","’Majta meꞌɨ́n ɨ́ seica ɨ́ mej ravaɨreꞌe aꞌɨ́jna ɨ́ rey, matɨ́ꞌɨj tiuꞌuséij aꞌij tɨ tiꞌitɨ́j huarɨ́j, matɨ́ꞌɨj mi u áꞌujuꞌun jemin ɨ́ tɨ tihuáꞌaijteꞌe. Nain mú raatáꞌixaa aꞌij tɨ tiꞌitɨ́j huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","’Ajta aꞌɨ́ɨn ɨ́ rey, tɨꞌɨquí raataꞌaíjtacaꞌa aꞌɨ́jna ɨ́ tɨ ravaɨreꞌe. Ayee pu tiraatáꞌixaa tɨjɨ́n: “Múꞌee pej nevaɨreꞌe, huápɨꞌɨ pej aꞌij puaꞌa tíꞌitevij. Nee nu timuaatáꞌuuniꞌiriꞌi nain jɨmeꞌe aꞌachú pej tináꞌachaꞌɨɨreꞌecaꞌa neꞌɨ́jna jɨmeꞌe ɨ́ pej piyen tinéjhuaviiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Ni caí ayén tiraavíjteꞌecaꞌa pej piyen cheꞌatá penaꞌa ráꞌancuꞌuvajxɨꞌɨn ɨ́ axɨ́ꞌej tevi tɨ nevaɨreꞌe netɨ́j neajta inee timuáꞌancuꞌuvajxɨ múꞌeetzi?” ");
INSERT INTO crnNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","’Ajta aꞌɨ́ɨn tɨ tíꞌiraꞌaijteꞌe, jéꞌecan pu huataniúꞌucacaꞌa aꞌɨ́jna jemi. Aj pu i aꞌuun tiuꞌutátui aꞌɨ́mej jemi ɨ́ mej huáꞌanaamuaca mej mi raꞌiteáanan ajta naꞌa caí nain tiraanájchiteꞌen aꞌachú tɨ téꞌechaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","’Ajta aꞌɨ́ɨn tɨ níꞌiyaꞌupua tɨ ta japua éꞌeseijreꞌe, ayée pu cheꞌatá naꞌa áꞌamuaruuren seɨj ajta seɨj tɨ puaꞌa pecaí tiraatáꞌuuniꞌi ɨ́ aꞌihuáaraꞌa tzáahuatiꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tɨ́ꞌɨj Jesús raatapuáꞌajtacaꞌa tɨ ayén tihuaúꞌixaateꞌe, tɨꞌɨquí aꞌuun eꞌerájraa aꞌuun tɨ huatacáꞌa u Galilea. Ajta antáraa után pújmeꞌen ɨ́ játeꞌana jetze u Jordán. Aꞌuu pu aꞌaráꞌa tɨ́j naꞌa aꞌúu tɨ huacáꞌa u Judea. ");
INSERT INTO crnNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jéihua mú teɨte aꞌucɨ́j jamuan. Ajta aꞌúu pu tihuáꞌuhuaa ɨ́ mej tíꞌicucuiꞌicaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aj mú mi seica eꞌiréꞌene ɨ́ Jesús jemi. Fariseos mú púꞌeen aꞌɨ́ɨme. Aꞌɨ́ɨme méjhuaucaꞌa mej raatémuaꞌitɨn tɨ ij autéꞌɨtzen tiꞌitɨ́j jɨmeꞌe. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni qui aꞌij tíꞌirɨꞌɨri tɨ jaꞌatɨ́ ayén mé rúurɨeeni ɨ́ ruꞌɨ́j tiꞌitɨ́j jɨmeꞌe, tiꞌitɨ́j tɨ naꞌa, capu amɨ́n aꞌij? ");
INSERT INTO crnNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―¿Ni qui secaí jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze tɨ jɨ́meꞌen yee aꞌɨ́ɨn tɨ nuꞌu amuacaí huáꞌutaahuacaꞌa ɨ́ teɨte, ayée pu naíjmiꞌi huáꞌutaahuacaꞌa ɨ́ teáataꞌa, ajta ɨ́ ꞌɨ́itaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ajta ayén tiuꞌuxájtacaꞌa aꞌájnáꞌɨmua tɨjɨ́n: “Aꞌɨ́j pu jɨ́n aꞌɨ́ɨn teáataꞌa ajtaméj ɨ́ ruvaújsimuaꞌa jemi. Ruꞌɨ́j pu nuꞌu jamuan huateáturaasin. Majta meꞌɨ́n ɨ́ mej huaꞌapua, ayée mú huataújruurejsin cumu seɨ́j puꞌu ɨ́ tevi.” ");
INSERT INTO crnNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ayee puꞌi tíꞌeen, camu chéꞌe huaꞌapua menaꞌa sino cumu seɨ́j puꞌu. Aꞌɨ́j pu jɨ́n, ɨ́ tɨ Dios huaꞌanténajchi, michéꞌe caí ajtaújhuaꞌanan ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tɨ́ puaꞌa ayén tiꞌéeneꞌen, ¿aꞌiné ꞌeen jɨ́n tiuꞌutaꞌaíjtacaꞌa aꞌɨ́jna ɨ́ Moisés teecan tɨ nuꞌu jaꞌatɨ́ ruꞌɨ́j aꞌɨ́ɨn huatapíjteꞌen ɨ́ cuapée tiꞌitɨ́j ɨ́ tɨ jɨ́n mé rúurɨeni? ");
INSERT INTO crnNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu ꞌeen jɨ́n Moisés ayén amuaatáꞌa tɨ jaꞌatɨ́ ruꞌɨ́j ɨ́ cuapée huatapíjteꞌen mej mi ráamuaꞌaree tɨ mé rúurɨe ɨ́ ruꞌɨ́j aꞌiné capu tiꞌitɨ́j aꞌamua jetze tásiseiiri sej si rɨ́ꞌɨ tihuáꞌajchaꞌɨɨ ɨ́ seica. Ayee pu xaa Moisés amuaatáꞌa. Mɨ́ ajta, capu ayén éeneꞌe ɨ́ ꞌajmíꞌɨmua. ");
INSERT INTO crnNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","’Ayee nu hui tejáꞌamuaꞌixaateꞌe. Capu rɨꞌɨrí tɨ jaꞌatɨ́ chaꞌa naꞌa mé rúurɨeni ɨ́ ruꞌɨ́j. Aꞌii puꞌu aꞌɨ́ɨn púꞌeen ɨ́ tɨ jɨ́n rɨꞌɨrí tɨ jaꞌatɨ́ mé rúurɨeni ɨ́ ruꞌɨ́j. Tɨ́ puaꞌa aꞌɨ́ɨn ɨ́raꞌaraꞌan seɨ́j jamuan tiꞌihuaújxanaꞌacɨraꞌaten, aj pu xaa íꞌirɨꞌɨri tɨ mé rúurɨeeni. Ajta aꞌɨ́ɨn cɨ́naꞌaraꞌan tɨ ayén chaꞌa naꞌa mé rúurɨe ɨ́ ruꞌɨ́j, tɨ puaꞌa áꞌiyen seɨ́j ancuréꞌeviꞌitɨn ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu tiúꞌujxanaꞌacɨraꞌaten aꞌɨ́jna jemi ɨ́ tɨ mé rúurɨe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú tiraatáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa ayén ꞌeen aꞌɨ́mej jemi ɨ́ mej néjneꞌɨche, ayée pu titáꞌamitɨejteꞌe itejmi aꞌɨ́jna jɨmeꞌe, ayée pu tíꞌixɨꞌepɨꞌɨn mej caí néjneꞌɨche. ");
INSERT INTO crnNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ajta Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Camu naíjmiꞌi miyen yaúꞌitɨée muáꞌajuꞌun, sino aꞌɨ́ɨ muꞌu ɨ́ tɨ Dios huaꞌutáꞌa mej mi miyen teꞌutáviicuaꞌi ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ayee puꞌu ꞌeen aꞌiné ayée pu tihuaꞌucɨ́ꞌɨ seica tɨ́j naꞌa mej huanúnuꞌihuacaꞌa. Majta seica, ayée mú ꞌeen aꞌiné teteca mú miyen huáꞌuruu. Majta seica, aꞌɨ́ɨ mú raaxɨ́ꞌepɨꞌɨntare rujɨ́ɨmuaꞌa mej mi teꞌenteárute ɨ́ Dios jemi. Aꞌatɨ́ tɨ naꞌa tɨ ayén tiraayɨ́ꞌɨtɨ, chéꞌe aꞌɨ́ɨn ayén huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Majta meꞌɨ́n ɨ́ seica, tɨꞌɨríi mú á eꞌevéꞌeviꞌitɨ ɨ́ Jesús jemi tɨ ij aꞌɨ́ɨn huaꞌajtamuárɨꞌen, ajta tɨ ij Dios jemi raatéjhuauni aꞌɨ́mej jɨmeꞌe. Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú autéjhuii mej huaꞌajteáꞌaxɨꞌɨn aꞌɨ́mej ɨ́ mej tɨꞌɨríi avéꞌeviꞌitɨxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj huaꞌutáꞌan mɨ tɨꞌɨríi mej yé veꞌeréꞌenen neetzi jemi. Caxu huáꞌijmɨijra, aꞌiné aꞌɨ́ɨme ɨ́ mej aꞌutéꞌuu ɨ́ Dios jemi, naímiꞌi mú miyen ꞌeen matɨ́j meꞌɨ́mej mɨ tɨꞌɨríi. ");
INSERT INTO crnNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aj pu i huáꞌamuꞌuutzeꞌe huaꞌavéꞌemuarɨꞌejxɨ aꞌɨ́jna ɨ́ Jesús. Ajta iyáꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ajta seɨ́j pu eꞌiréꞌene ɨ́ Jesús jemi. Teáataꞌa aꞌɨ́jna. Aj pu i ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maeestru mɨ pej rɨ́ꞌɨ mé teuúmuaꞌaree, ¿tiꞌitáani iꞌi xɨ́ꞌepɨꞌɨn tɨ ruxeꞌeveꞌe nej ni niyen huárɨni tɨ i ayén náacɨꞌɨti nej ruuri náꞌaraꞌani ɨ́ Dios jemi tɨ́j naꞌa rusén jɨmeꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n piyen tíꞌinejee peꞌɨ́jna jɨmeꞌe nej rɨ́ꞌɨ mé teuúmuaꞌaree caꞌɨ́n qui inee rɨ́ꞌɨ netiꞌitevi? Seɨ́j puꞌu aꞌɨ́ɨn púꞌeen tɨ rɨ́ꞌɨ mé teuúmuaꞌaree; aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Dios. Tɨ́ puaꞌa piyen tíꞌijxeꞌeveꞌe tɨ muáacɨꞌɨti pej piyen ruuri puáꞌaraꞌani ɨ́ Dios jemi, patáꞌaj piyen raꞌaráꞌastijreꞌen aꞌij tɨ tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Aj pu i ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: ―¿Tiꞌitáani niuucarijraꞌa naꞌaráꞌastijreꞌen? Jesús pu ayén tiraatáꞌixaa tɨjɨ́n: ―Aꞌijna neꞌu tɨ ayén huataújmuaꞌa yee “capej tíꞌitecuiꞌica”, ajta aꞌɨ́jna tɨ jɨ́meꞌen yee “capej tíꞌaxanaꞌacɨraꞌate”, ajtahuaꞌa seɨ́j tɨ ayén yee “capej tíꞌinahuaꞌaj, capej pajta jaꞌatɨ́ huaꞌitzi jɨ́n tiꞌixáateꞌe”. ");
INSERT INTO crnNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ajta pu hui ayén tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios aꞌɨ́jna jɨmeꞌe pej nuꞌu huáꞌajtzaahuatiꞌireꞌe ɨ́ aꞌatáàta, pajta ɨ́ anaanaj. Pajta, piyen huárɨni pej pi piyen rɨ́ꞌɨ tirájchaꞌɨɨ ɨ́ axɨ́ꞌej tevi patɨ́j aseɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ajta aꞌɨ́jna ɨ́ temuaij, ayée pu tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Nain nu jɨ́n teꞌaráꞌaste tɨ́j naꞌa tiꞌipuaꞌamé. ¿Tiꞌitáani auj náꞌaturaateꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa ayén timuaꞌaráanajche pej nain jɨ́n teꞌaráꞌasten, ayée pej huárɨni. Aricu, nain tiuꞌutuáa ɨ́ tiáꞌa. Pajta huaꞌuréꞌan ɨ́ tumin aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. Tɨ́ puaꞌa piyen huárɨni, jéꞌecan pepuꞌu raꞌancuréꞌasin ɨ́ ta japua ɨ́ Dios jemi. Aj pepuꞌu xaa, mú aꞌutáꞌiyiꞌi patáꞌaj neetzi jamuan áꞌucheꞌecaneꞌen. ―Ayee pu tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tɨ́ꞌɨj ayén tiráanamuajriꞌi aꞌij tɨ Jesús tiuꞌutaxájtacaꞌa, aj pu i utéevatzɨ ɨ́ ru tzajtaꞌa aꞌɨ́jna ɨ́ temuaij. Huatáujxɨeemɨjte aꞌiné jeíhua pu tíꞌijchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Temuaꞌa pu tíꞌimuarɨꞌeri mej aꞌuteárute aꞌájna Dios tɨ éꞌeseijreꞌe aꞌɨ́ɨme ɨ́ chíjteaani. ");
INSERT INTO crnNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Neajta niyen tejáꞌamuaꞌixaateꞌe. Jaítzeꞌe pu muárɨꞌeri tɨ chíjteaani aꞌuteárute aꞌájna Dios tɨ éꞌeseijreꞌe caí tɨ cameeyuꞌu anaarute tiꞌitɨ́j pɨ́ꞌɨseꞌe jetze tɨ anacun. ");
INSERT INTO crnNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Majta aꞌɨ́ɨme, matɨ́ꞌɨj miyen tiráanamuajriꞌi, jéꞌecan mú aꞌij teꞌutaseíj. Majta miyen tíꞌiruꞌihuaꞌu tɨjɨ́n: ―¿Tɨ́ puaꞌa ayén tíꞌeeneꞌen, aíi táꞌuj naꞌa tíꞌirɨꞌɨri tɨ jaꞌatɨ́ aꞌuun aꞌuteáturan aꞌu tɨ Dios éꞌeseijreꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Aj pu i Jesús huaꞌuseíj. Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́mej jemi ɨ́ teteca, capu xaa aꞌij tíꞌirɨꞌɨri. Mɨ́ ajta, aꞌɨ́ɨ pu xaa raayɨ́ꞌɨtɨ ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ajta aꞌɨ́jna ɨ́ Pedro, ayée pu tiuꞌutaniú tɨjɨ́n: ―Teajta iteen, nain tu teri mé teuhuáꞌaxɨ ɨ́ tej tíꞌijchaꞌɨɨcaꞌa tej ti áꞌujujhuaꞌaneꞌen áꞌa jamuan. ¿Tiꞌitáani tacɨꞌɨti itejmi? ");
INSERT INTO crnNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Aꞌájna xɨcájraꞌa jetze tɨ Dios nain jɨ́n tiꞌijéjcuareꞌen, inee, i nej neajta teáataꞌa jetze airáane, aꞌájna netɨ́ꞌɨj aujyeíjxɨꞌɨsin japuan ɨ́ neꞌɨpuá, ayée pu seíireꞌe aꞌame temuaꞌa naa mej mi atanéjneꞌere. Seajta múꞌeen mɨ sej ne jamuan áꞌujujhuaꞌan, ayée xu cheꞌatá senaꞌa títeujráꞌasixɨꞌɨn japuan ɨ́ áꞌamuaꞌɨpua, seɨj seajta seɨj. Tamuáamuataꞌa japuan huaꞌapua xu aráꞌase múꞌeen, ajta ayén teꞌaráꞌase ɨ́ áꞌamuaꞌɨpua. Aj xu si siyen tíhuaꞌuxɨ́ꞌepɨꞌɨntariꞌireꞌen aꞌɨ́mej teɨtejraꞌa ɨ́ mej Israél jetze ajtémeꞌecan, aꞌɨ́mej teɨtejraꞌa mej miyen tamuáamuataꞌa japuan huaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","’Neajta niyen tejáꞌamuaꞌixaateꞌe, jaꞌatɨ́ tɨ naꞌa tɨ tiꞌitɨ́j áꞌurɨeeni aꞌɨ́jna jɨmeꞌe tɨ áꞌucheꞌecaneꞌen neetzi jamuan, tɨ puaꞌa chiꞌij, nusu rujaꞌatzimuá naꞌari rucuꞌutzimuá o rujúutzimuaꞌa, caꞌɨ́n rutáàta, runáàna naꞌari tɨ puaꞌa yáꞌurɨeeni ɨ́ chuej tɨ japuan tíꞌihuasteꞌe, ayée pu tíꞌijcɨꞌɨti. Tɨ́ puaꞌa seɨ́j naꞌa ɨ́ tɨ yáꞌujɨsin, ayée pu tíꞌiracɨꞌɨti aꞌachú cumu anxɨ́te ɨ́ tiꞌitɨ. Ajta, ayén tíꞌiracɨꞌɨti tɨ ruuri áꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe aꞌájna Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","’Ajta, ayée pu hui ajta téꞌeme: muꞌiitɨ́ ɨ́ mej nuꞌu veꞌecán jɨ́n títetateí ɨ́ Dios jemi íjii, aꞌɨ́ɨ mú cɨliéeneꞌe jɨ́n títetatée muáꞌajuꞌun jemin ɨ́ Dios. Majta muꞌiitɨ́ ɨ́ mej nuꞌu cɨ́lieeneꞌen jɨ́n títetateí ɨ́ Dios jemi íjii, aꞌɨ́ɨ mú veꞌecán jɨ́n títetatée muáꞌajuꞌun aꞌájna xɨcájraꞌa jetze tɨ jetzen Dios tiuꞌutaꞌaíjta. ");
INSERT INTO crnNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Ayee pu ajta tíꞌaijta ɨ́ Dios aꞌɨ́jna tɨ jɨ́n antiújmuaꞌaree. Ayee pu rɨcɨ tɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ráahuii ɨ́ uuva Tapuáꞌarijmeꞌeca pu nuꞌu huirájraa tɨ ij huaꞌutáꞌinen aꞌɨ́mej ɨ́ mej tiuꞌumuárɨꞌen aꞌu tɨ tejéꞌehuasteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ayee pu tíhuaꞌuxɨ́ꞌepɨꞌɨntariꞌiriꞌi tɨ ayén tihuaꞌunájchiteꞌen aꞌachú cumu seɨ́j tumin. Aj pu i huaꞌutaꞌítecaꞌa mej aꞌucɨ́ɨne aꞌu tɨ eꞌeréꞌevee ɨ́ uuva. ");
INSERT INTO crnNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","’Ajtahuaꞌa pu huirájraa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ́ꞌɨj ari jáꞌitaꞌa huateméꞌeca ɨ́ xɨca. Seica pu ajta huáteu aꞌájna aꞌu mej áꞌujseꞌupi. Camu tiꞌitɨ́j muarɨꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: “Sericu múꞌeen, sej si yeehui tejaꞌuvéꞌemuarɨꞌen aꞌu nej uuva áꞌuuhuii, neajta niyen tejamuaanájchiteꞌen aꞌachú tɨ raavíjteꞌe.” Matɨ́ꞌɨj mi áꞌujuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’Ayee pu cheꞌatá naꞌa huarɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ. Ajtahuaꞌa pu nuꞌu huirájraa aꞌatzaj cumu tacuarixpua. Ajtahuaꞌa, tɨ́ꞌɨj ari vejliꞌi cáame ɨ́ xɨca, ayej cheꞌatá naꞌa rɨjcaa. ");
INSERT INTO crnNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ajtahuaꞌa pu huirájraa tɨ́ꞌɨj ari jeꞌincáruti ɨ́ xɨca. Ajtahuaꞌa pu seica áꞌuteu ɨ́ mej eꞌetiúꞌuucaꞌa. Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: “¿Aꞌiné ꞌeen jɨ́n siyen huatéꞌuu tɨ́j naꞌa aréꞌapuaꞌa ɨmuá? ¿Ni secaí tiꞌitɨ́j mej eꞌejmuárɨꞌe?” ");
INSERT INTO crnNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ayee mú tiuꞌutaniú tɨjɨ́n: “Capu yee jaꞌatɨ́ taꞌinee.” Ayee pu ij tihuaꞌutáꞌixaa tɨjɨ́n: “Sericu seajta múꞌeen, sej si tejaꞌuvéꞌemuarɨꞌen aꞌu nej uuva áꞌuuhuii.” ");
INSERT INTO crnNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","’Tɨ́ꞌɨj huateáchumuaꞌarecaꞌa, aj pu i raatajé ɨ́ seɨ́j tɨ tihuáꞌaijteꞌe ɨ́ mej tíꞌimɨjhuaca. Ayee pu tiraatáꞌixaa tɨjɨ́n: “Patáꞌaj u huájaꞌutájeeve aꞌɨ́mej ɨ́ mej tíꞌimɨjhuaca patáꞌaj tihuaꞌunájchiteꞌen. Pajta, patáꞌaj yeehui piyen autéjcheni aꞌɨ́mej jemi ɨ́ mej caí íiyaꞌata autéjhuii. Pajta piyen raꞌantipuáꞌajteꞌen aꞌɨ́mej jemi ɨ́ mej amuacaí autéjhuii.” ");
INSERT INTO crnNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","’Aj mú mi eꞌiréꞌene aꞌɨ́ɨme ɨ́ mej anteájrupi tɨ́ꞌɨj ari jeꞌincáruti ɨ́ xɨca. Aꞌɨ́ɨ pu tihuaꞌunájchi seɨj ajta seɨj nain jɨmeꞌe ɨ́ seɨj tumin. ");
INSERT INTO crnNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ajta áꞌiyen tɨ́ꞌɨj huaꞌucɨ́ꞌɨ tɨ aꞌɨ́mej tiuꞌunájchiteꞌen ɨ́ mej amuacaí anteájrupi, ayée mú tíꞌiruꞌixaateꞌecaꞌa tɨjɨ́n: “Jaítzeꞌe pu tíꞌitacɨꞌɨti itejmi.” Mɨ́ ajta caí, capu. “Aꞌɨ́ɨ pu ajta ayén tihuaꞌunájchi sei tumin cheꞌatá naꞌa, seɨj ajta seɨj.” ");
INSERT INTO crnNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","’Matɨ́ꞌɨj raꞌancuréꞌa, aꞌɨ́ɨ mú autéjhuii mej huaújniuusteꞌen meꞌɨ́jna jemi ɨ́ tɨ tíchuej. ");
INSERT INTO crnNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ayee mú tiraatáꞌixaa tɨjɨ́n: “Aꞌɨ́ɨme ɨ́ mej caí íiyaꞌata anteájrupi, seɨ́j hora muꞌu tiuꞌumuárɨej. Mɨ́ pajta múꞌee, ayée pej cheꞌatá penaꞌa tihuaꞌunájchi patɨ́j titaanájchi itejmi. Teajta iteen, nain tu yee jɨ́n teꞌutáviicuaꞌiriꞌi, teajta tíꞌimuarɨꞌista, teajta nain tu jɨ́n tɨ́j naꞌa tiúꞌuxɨɨrecaꞌa tɨ́j naꞌa aréꞌapuaꞌa ɨmuá.” ");
INSERT INTO crnNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","’Ajta aꞌɨ́ɨn, ayée pu tiraatáꞌixaa seɨ́j tɨ amuacaí anteájrupi tɨjɨ́n: “Casiꞌi, neꞌamiigu. Canu aꞌij puaꞌa muaruure. ¿Ni qui pecaí piyen tiuꞌutáꞌa muáꞌaniuuca jɨmeꞌe pej piyen tiuꞌumuárɨꞌen seɨ́j tumin jɨmeꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Meꞌecui icu, ancuréꞌa ɨ́ pej raamuáꞌitɨ. Aricu. Ayee nuꞌu yee raxɨ́ꞌeveꞌe nej niyen cheꞌatá nenaꞌa timuaanájchiteꞌen múꞌeetzi netɨ́j tiraanájchi neꞌɨ́jna ɨ́ jaꞌatɨ tɨ anteájrupi tɨ́ꞌɨj ari jeꞌincáruti ɨ́ xɨca. ");
INSERT INTO crnNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ni caí ayén yee tíꞌinecɨꞌɨti nej niyen huárɨni aꞌij nej tíꞌijxeꞌeveꞌe neꞌɨ́jna jɨmeꞌe ɨ́ nej tíꞌituaave, caꞌɨ́n piyen chueereꞌe peꞌɨ́jna jɨmeꞌe nej rɨ́ꞌɨ tihuáꞌajchaꞌɨɨ?” ―Ayee pu nuꞌu tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Aj pu i Jesús ayén tɨjɨ́n: ―Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨme ɨ́ mej caí amuacaí anteájrupi, aꞌɨ́ɨ mú anaráꞌasi, majta meꞌɨ́n ɨ́ mej amuacaí anteájrupi, aꞌɨ́ɨ mú uvéꞌeteajtɨri. ");
INSERT INTO crnNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tɨ́ꞌɨj ari Jesús án aꞌujnéjsin aꞌánna Jerusalén, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aj pu i huaꞌutajé rujɨ́ɨmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Tuꞌuri aꞌujnéjsin aꞌánna Jerusalén. Ajta seɨ́j pu hui neetzi tiuꞌutátuiireꞌesin i nej neajta teáataꞌa jetze airáane. Huaꞌutatuiireꞌesin aꞌɨ́mej ɨ́ mej tíꞌaijta u huaꞌatéyujtaꞌa, ajta aꞌɨ́mej ɨ́ mej téꞌeyuꞌuxaca. Aꞌɨ́ɨ mú tiuꞌutáꞌasin mej mi naajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Majta náꞌaviꞌitɨn aꞌɨ́mej jemi ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan mej mi náꞌuxɨeehuariꞌi. Majta meꞌɨ́n, ayée mú tinaatévajxɨꞌɨsin. Majta náꞌatatan ineetzi cúruu jetze. Neajta mɨꞌɨni, aru huaíca xɨca jetze nu neajta huatarújsin. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ajta aꞌɨ́ɨn huaꞌanáànaj aꞌɨ́mej ɨ́ yaújmuaꞌameꞌen aꞌɨ́jna ɨ́ Zebedeo, ruyaujmuaꞌa pu jamuan eꞌiréꞌene ɨ́ Jesús jemi. Aj pu i títunutacaꞌa á vejliꞌi jemin tɨ i tiꞌitɨ́j raatáhuavii. ");
INSERT INTO crnNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné petíꞌijxeꞌeveꞌe nej niyen huárɨni múꞌeetzi jɨmeꞌe? Ajta aꞌɨ́ɨn huaꞌanáànaj, ayée pu tiraatáꞌixaa tɨjɨ́n: ―Patáꞌaj piyen huaꞌutáꞌan mɨ niyaujmuaꞌa tɨ ij seɨ́j aꞌujyeíjxɨꞌɨn arɨꞌɨríintaꞌa, ajta ɨ́ seɨ́j tɨ aꞌujyeíjxɨꞌɨn aꞌúutataꞌa pújmeꞌen aꞌájna xɨcájraꞌa jetze patɨ́ꞌɨj yé uvéꞌenen pej tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu aꞌatzu ramuaꞌaree tiꞌitɨ́j sej nehuavii. ¿Ni siyen ráꞌaviicuaꞌi sej rajpuaíitzi xáꞌaraꞌani netɨ́j inee tirajpuaíitzi naꞌame? Ayee mú tiuꞌutaniú tɨjɨ́n: ―Aꞌiné tijtá neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Múꞌeen xu rajpuaíitzi xáꞌaraꞌani netɨ́j tirajpuaíitzi naꞌame inee. Mɨ́ ajta, capu ayén tíꞌinecɨꞌɨpua ineetzi nej jaꞌatɨ́ huatáꞌan tɨ aꞌujyeíjxɨꞌɨn nerɨꞌɨríintaꞌa, naꞌari neꞌúutataꞌa. Ayee puꞌu tihuáꞌacɨꞌɨti mej mi uhuaráꞌasixɨꞌɨn aꞌujna aꞌɨ́mej tɨ Dios ari huaꞌantíhuau. ");
INSERT INTO crnNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Majta meꞌɨ́n ɨ́ seica, ɨ́ mej tamuáamuataꞌa aráꞌase, matɨ́ꞌɨj ráanamuajriꞌi, jéꞌecan mú huataníniuꞌucacucaꞌa aꞌɨ́mej jemi ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Aj pu i Jesús huaꞌutajé naíjmiꞌica. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Xuꞌuri ramuaꞌaree múꞌeen aꞌij mej yeꞌí rɨ́ɨj muáꞌayeꞌi ɨ́ mej tíꞌaijta nain chuéjraꞌa japua. Caꞌanéeri mú jɨ́n tihuáꞌaijteꞌe ɨ́ teɨte. Majta meꞌɨ́n ɨ́ mej títetateí, aꞌɨ́ɨ mú tihuáꞌaijteꞌe ɨ́ seica aꞌij mej yeꞌí meꞌɨ́n tíꞌijxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mɨ́ ajta, capu ayén tiraavíjteꞌe múꞌejmi jemi. Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ veꞌecán jɨ́n tiꞌitevée áꞌaraꞌani, ayée pu ruxeꞌeveꞌe tɨ aꞌɨ́ɨn cɨliéeneꞌe jɨ́n tiꞌitevée áꞌaraꞌani tɨ i amuaatévaɨreꞌen naíjmiꞌica múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","’Aꞌatɨ́ tɨ naꞌa tɨ ayén raxɨ́ꞌeveꞌe tɨ teꞌenteárute aꞌɨ́jna jɨmeꞌe tɨ jaítzeꞌe veꞌée, aꞌɨ́ɨ pu amuacaí ruxeꞌeveꞌe tɨ teꞌenteárute aꞌɨ́jna jɨmeꞌe ɨ́ tɨ jaítzeꞌe cɨ́lieen tɨ ij huaꞌutévaɨreꞌen naíjmiꞌica ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Michéꞌe miyen huárɨni netɨ́j rɨcɨ inee, i nej neajta teáataꞌa jetze airáane. Canu neꞌɨ́jna jɨ́n mú iyaꞌuvéꞌeme mej naatévaɨreꞌen ineetzi, sino neatáꞌaj huaꞌutévaɨreꞌen ɨ́ seica. Ayee nu ꞌeen jɨ́n mú iyaꞌuvéꞌeme nej ni huámɨꞌɨni huáꞌa jetze meꞌecan, neajta nej ni tiraanájchiteꞌen ɨ́ Dios ɨ́ tɨ jɨ́n huáꞌajijveꞌe ɨ́ mej áꞌapuaꞌaren muꞌiicáca ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Aj pu i áꞌuraa aꞌɨ́jna ɨ́ Jesús, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj huiráacɨ meꞌújna Jericó, jeíhua mú teɨte aꞌucɨ́j jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Majta meꞌɨ́n ɨ́ mej huaꞌapua ɨ́ mej aracúcuꞌunijmeꞌecaꞌa, aꞌúu mú eꞌejtéꞌecaꞌa juye jetze. Matɨ́ꞌɨj ráanamuajriꞌi tɨ nuꞌu á aꞌatamé aꞌɨ́jna ɨ́ Jesús, ayée mú titeejíjhuacaꞌa tɨjɨ́n: ―Tavastaraꞌa, mɨ pej hui iꞌi huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan, táꞌancuꞌuvajxɨꞌɨ itejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Majta meꞌɨ́n teɨte, aꞌɨ́ɨ mú huaꞌajteáꞌaxɨ. Miyen tihuáꞌaꞌijmɨira mej mi caí miyen tíꞌijijhua. Mɨ́ majta aꞌɨ́ɨme ɨ́ mej aracúcuꞌunijmeꞌecaꞌa, jaítzeꞌe mú caꞌanín jɨ́n huajíjhuacaꞌa. Miyen tɨjɨ́n: ―Tavastaraꞌa, mɨ pej iꞌi huáacɨxaꞌaraꞌan ɨ́ David teecan, táꞌancuꞌuvajxɨꞌɨ itejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Aj pu i Jesús huatéechaxɨ. Ajta huaꞌutajé. Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe nej ni tiꞌitɨ́j aꞌij huáruuren múꞌejmi jemi? ");
INSERT INTO crnNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ayee mú titeetaniú tɨjɨ́n: ―Tavastaraꞌa, ayée tu tíꞌijxeꞌeveꞌe tej atanéjneꞌere. ");
INSERT INTO crnNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Aj puꞌi aꞌɨ́ɨn Jesús huáꞌancuꞌuvajxɨ. Ajta huaꞌarámuarɨꞌejxɨ ɨ́ huaꞌajɨ́ꞌɨ jetze. Jɨ́meꞌen puꞌu huaꞌarámuarɨꞌejxɨ, aj mú mi huarúj. Matɨ́ꞌɨj mi atanéjneꞌeri muáꞌaraa. Majta aꞌucɨ́j jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aj mú mi meꞌuun aꞌaráꞌa aꞌájna jáꞌahuaꞌa vejliꞌi u Jerusalén aꞌu tɨ aꞌuchájtaꞌajme tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betfagé. Aꞌuu pu éꞌechajtaꞌa jɨrí jetze mej miyen ratamuáꞌamua tɨjɨ́n Aceituunajemi. Aj pu i Jesús huaꞌapuaca huataꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ayen tɨjɨ́n: ―Sericu, setáꞌaj aꞌatanén aꞌájna vejliꞌi chajtaꞌa tɨ éꞌeseijreꞌe. Setɨ́ꞌɨj aꞌuteárute seꞌújna, aꞌuun xu hui yéꞌeteuni ɨ́ puuruꞌu tɨ ajtatápiꞌi jamuan ɨ́ yaujraꞌan. Setáꞌaj ráꞌijxɨjta. Seajta mú huájeꞌerajápuan neetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tɨ́ puaꞌa jaꞌatɨ́ ayén tejáꞌamuaꞌihuaꞌura aꞌɨ́jna jɨmeꞌe, aj xu si siyen tiraataꞌixaateꞌen tɨ jɨ́meꞌen yee tavástaraꞌa pu nuꞌu raxɨ́ꞌeveꞌe, seajtáhuaꞌa xu caꞌanacan raatátuiireꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ayee pu tiujuꞌurɨ́j tɨ ij ayén teꞌaraúrasten aꞌij tɨ ajmíꞌi tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Ayen tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Patáꞌaj piyen tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej aꞌuchéjme aꞌúu tɨ huatacáꞌa aꞌɨ́jna ɨ́ chajtaꞌa u Sión tɨ jɨ́meꞌen yee: “Casiꞌi múꞌeen, puꞌuri mú aꞌuvéꞌemej múꞌejmi jemi aꞌɨ́jna ɨ́ aꞌamua Rey. Capu aꞌij tíꞌijviicuaꞌi. Ajta aveꞌecaí puuruꞌu japua tɨ cɨ́lieen tɨ yaujraꞌan púꞌeen seɨ́j ɨ́ mej japuan tíꞌitɨꞌɨcɨca.” ");
INSERT INTO crnNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Majta meꞌɨ́n ɨ́ mej huaꞌapua, aj mú mi aꞌucɨ́j. Majta miyen huarɨ́j aꞌij tɨ Jesús tíhuaꞌutaꞌaíj. ");
INSERT INTO crnNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Aj mú yeꞌeráaja ɨ́ Jesús jemi meꞌɨ́jna ɨ́ puuruꞌu, majta ɨ́ yaujraꞌan. Matɨ́ꞌɨj mi raꞌitéechejte ɨ́ puuruꞌu rucɨɨxu jɨmeꞌe. Aj pu i Jesús avéꞌeyeijxɨ japuan ɨ́ puuruꞌu tɨ cɨ́lieen. ");
INSERT INTO crnNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Majta meꞌɨ́n ɨ́ teɨte, jeíhua mú ajteáxɨɨrecaꞌa. Majta cɨ́ɨxuri teꞌepíijraa juye jetze. Majta seica, piꞌista teꞌentiveíchixɨꞌɨ, aꞌɨ́ɨ mú majta aꞌapíijraa meꞌájna juye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Majta meꞌɨ́n ɨ́ mej anáatéꞌee huajúꞌucaa, majta meꞌɨ́n ɨ́ mej cujtaꞌan huajúꞌucaa, aꞌɨ́ɨ mú huatajíjhuaxɨ tɨjɨ́n: ―Ayee tu hui tíꞌimuahuavii pej tuꞌirájtuaani mɨ pej iꞌi huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ rey, ɨ́ David teecan. Dios pu rɨ́ꞌɨ tiraateájtuaa temuaꞌa naa aꞌíjna tɨ yé véꞌeme niuucajtzeꞌen ɨ́ tavástaraꞌa. Chéꞌe aꞌɨ́ɨn tuꞌirájtuaani aꞌɨ́jna tɨ aꞌuun éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Aj pu i Jesús aꞌuteájrupi u Jerusalén. Tɨ́ꞌɨj aꞌuteájrupi, aj mú mi tiúurɨꞌɨtzii naíjmiꞌi ɨ́ mej aꞌuun aꞌuchéjmeꞌecaa. Jéihua mú tíꞌiruꞌixaateꞌecaꞌa. Miyen tɨjɨ́n: ―¿Aꞌataani púꞌeen amɨ́jna? ");
INSERT INTO crnNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Majta meꞌɨ́n ɨ́ teɨte, ayée mú tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Jesús tɨ Nazarét éꞌemeꞌecan, tɨ ajta Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ajta áꞌiyen, Jesús aꞌuteájrupi u teyujtaꞌa tɨ eꞌeráyaujtaꞌa. Aj pu i huaꞌutamuári naíjmiꞌica aꞌɨ́mej ɨ́ mej meꞌuun tíꞌituꞌaracareꞌe, ajta aꞌɨ́mej ɨ́ mej meꞌuun tíꞌinanaavecareꞌe. Tihuaꞌameesa pɨ́ pu téꞌejhuaꞌaxɨ aꞌɨ́mej ɨ́ mej japuan tumin huáꞌapuataꞌatiꞌiracareꞌe, ajta tihuáꞌɨpua aꞌɨ́mej ɨ́ mej cucuiꞌise túꞌaaracareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ Dios ayén tiraataxájtacaꞌa tɨ jɨ́meꞌen yee, ayée pu nuꞌu tejaꞌarajtehuaá aꞌame ɨ́ chiꞌiraꞌan tɨjɨ́n: “Chiꞌi mej tzajtaꞌan tíꞌixaxaꞌa ɨ́ Dios jemi.” Mɨ́ seajta múꞌeen, ayée xu seɨcɨé raruure ɨ́ chiꞌij tɨ́j teástaꞌa aꞌu mej tzajtaꞌan éꞌeruꞌavaꞌataca ɨ́ nahuaꞌari. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Majta seica meꞌuun eꞌeréꞌeteꞌecaa aꞌujna teyujtaꞌa. Seica mú muaꞌarácucuꞌun, majta seica, tzareꞌe mú huaꞌɨ́ɨcajme. Aꞌɨ́ɨ mú eꞌiréꞌene ɨ́ Jesús jemi. Ajta aꞌɨ́ɨn tihuáꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Majta meꞌɨ́n ɨ́ mej tíꞌaijta teyujtaꞌa, majta ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, matɨ́ꞌɨj raaseíj aꞌij tɨ Jesús huarɨ́j mej mi miyen rɨ́ꞌɨ teꞌutaseíj ɨ́ teɨte, matɨ́ꞌɨj majta huaꞌuseíj ɨ́ tɨꞌɨríi ɨ́ mej rujíjhuaveꞌecaa tɨjɨ́n: “Tichéꞌe nuꞌu rɨ́ꞌɨ tiraateájtuaani temɨ́jna tɨ David teecan jetze airáane”, jéꞌecan mú huataníniuꞌucacucaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Ni tzaa pecaí tíꞌinamua aꞌij mej tiꞌixa amɨ́ɨme mɨ tɨꞌɨríi? Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Aa niꞌijtá neꞌu. ¿Ni tzaa secaí siyen raꞌujíjve ɨ́ yuꞌuxari jetze tɨ ayén téꞌeyuꞌusiꞌi? Ayen tɨjɨ́n: Aꞌɨ́ɨ mú nuꞌu majta rɨ́ꞌɨ tiratáꞌaca aꞌɨ́mej ɨ́ tɨꞌɨríi, majta aꞌɨ́ɨme ɨ́ uneecaꞌise. Aꞌɨ́ɨ mú Dios jetze araújcaꞌane mej mi miyen huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aj pu i Jesús huaꞌutátuaa. Ajta iyáꞌuraa. Aꞌuu pu aꞌaráꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betania. Aꞌuu pu huatáxaꞌai. ");
INSERT INTO crnNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Yee ruijmuaꞌa yee tɨ́ꞌɨj ajtahuaꞌa pɨ́ꞌájve, puꞌuri íꞌicuatacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Aꞌɨ́ɨ pu huaréj huaseíj tɨ eꞌetávee aꞌájna vejliꞌi juye jetze. Aj pu i aꞌuréꞌene aꞌu tɨ eꞌetávee aꞌɨ́jna ɨ́ huaréj. Capu aꞌatzu tacaꞌacaa sino téxamuaꞌicaa puꞌu. Aj pu i Jesús ayén tiraatáꞌixaa aꞌɨ́jna ɨ́ huaréj tɨjɨ́n: ―Capej chéꞌe jaꞌanáj tacaꞌan. Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj pu i huatéehua aꞌɨ́jna ɨ́ huaréj. ");
INSERT INTO crnNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj raaseíj, jéꞌecan mú aꞌij teꞌutaseíj. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ ayén caꞌanacan huatéehuan amɨ́jna mɨ huaréj? ");
INSERT INTO crnNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu huarɨ́j. Ayee nu tejáꞌamuaꞌixaateꞌe. Tɨ́ puaꞌa siyen téꞌatzaahuateꞌe tɨ ij ayén tejaꞌuréꞌenen aꞌij tɨ tejamuáꞌamitɨejteꞌe, ajta tɨ puaꞌa caí aꞌij áꞌamuaꞌase sej caí aꞌij huárɨni ayée xu cheꞌatá senaꞌa raayɨ́ꞌɨtɨhuaꞌa xáꞌaraꞌani sej siyen raruuren semɨ́jna mɨ huaréj netɨ́j neri ráaruu. Seajta siyen raayɨ́ꞌɨtɨhuaꞌa xáꞌaraꞌani sej siyen raataꞌaíjteꞌen semɨ́jna mɨ jɨrí tɨjɨ́n: “Tíchesi yee, ateájraꞌa á jaataꞌa, jáꞌahuaꞌa ɨ́ mar jetze.” Aj pu i xaa ayén tejaꞌuréꞌenejsin, tɨ ayén huárɨni ɨ́ jɨrí. ");
INSERT INTO crnNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","’Setɨ́j senaꞌa sej siyen tíꞌijhuavii ɨ́ Dios, tɨ puaꞌa siyen téꞌatzaahuateꞌe, aj xu xaa raꞌancuréꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aj pu i Jesús aꞌuteájrupi teyujtaꞌa aꞌu tɨ eꞌeráyaujtaꞌa Tɨ́ꞌɨj aꞌɨ́ɨn tihuáꞌumuaꞌaten ɨ́ teɨte, aꞌɨ́ɨme ɨ́ mej tíꞌaijta u teyujtaꞌa, majta ɨ́ vaujsi, aꞌɨ́ɨ mú eꞌiréꞌene ɨ́ Jesús jemi. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni hui jɨ́n petiꞌitéjvee pej pi piyen rɨcɨ? ¿Aꞌataani muaatáꞌa pej piyen huárɨni? ");
INSERT INTO crnNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Nicheꞌe seɨ́j tejámuaataꞌíhuaꞌu. Tɨ́ puaꞌa siyen tinaatáꞌixaateꞌen seꞌɨ́jna jɨmeꞌe, aj nu xaa niyen tejámuaatáꞌixaateꞌesin tiꞌitɨ́j ɨ́ nej jɨ́n tiꞌitéjvee nej ni niyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Aꞌɨ́jna ɨ́ tɨ jɨ́n tiꞌitéveecaꞌa aꞌɨ́jna ɨ́ Juan tɨ ij huáꞌumuaɨꞌɨhua ɨ́ teɨte, ¿aꞌuné jetze aꞌuvéꞌemej? ¿Ni u ta japua, Dios tɨ éꞌeseijreꞌe, naꞌari íiyen chaanaca japua, huáꞌa tzajtaꞌa ɨ́ teɨte? Matɨ́ꞌɨj mi tiꞌitiúrixaa rujɨ́ɨmuaꞌa. Miyen tɨjɨ́n: ―Tɨ́ puaꞌa tiyen tiraataꞌixaateꞌen yee Dios pu yaꞌutaꞌítecaꞌa, aꞌɨ́ɨ pu ayén titaatáꞌixaateꞌesin yee aꞌiné ꞌeen jɨ́n tecaí ráꞌatzaahuateꞌe teꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mɨ́ teajta iteen, capu hui rɨꞌɨrí tej tiyen raataxáj yee teteca mú yaꞌutaꞌítecaꞌa aꞌiné tehuáꞌatziɨɨneꞌe ɨ́ teɨte. Naíjmiꞌi mú miyen ráꞌatzaahuateꞌe tɨ aꞌɨ́ɨn Juan tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aj mú mi miyen tiraatáꞌixaa meꞌɨ́jna ɨ́ Jesús. Miyen tɨjɨ́n: ―Catu ramuaꞌaree. Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu neajta inee amuaatáꞌixaateꞌesin tiꞌitɨ́j ɨ́ nej jɨ́n tiꞌitéjvee nej ni niyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ajta Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Casiꞌi, aꞌiné tejamuáꞌamitɨejteꞌe aꞌíjna jɨmeꞌe i niuucari. Jaꞌatɨ́ pu huaꞌapuaca tiyaúumuaꞌa. Aj pu i eꞌiréꞌene ɨ́ seɨ́j jemi. Ayee pu tiraataꞌítecaꞌa tɨjɨ́n: “Niyauj, aricu patáꞌaj tejaꞌumuárɨꞌen íjii aꞌu nej uuva áꞌuuhuii.” ");
INSERT INTO crnNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Aj pu i aꞌɨ́ɨn yaujraꞌan ayén tiraatáꞌixaa tɨjɨ́n: “Canu niyen rɨni.” Mɨ́ ajta aꞌɨ́ɨn, seɨcɨé pu tiuꞌumuáꞌaj. Aj pu i xaa u áꞌume tɨ tejaꞌumuárɨꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ajta áꞌiyen, aꞌɨ́ɨn yaꞌupuáaraꞌan eꞌiréꞌene ɨ́ seɨ́j jemi. Ayee pu cheꞌatá tiraataꞌaíj aꞌɨ́jna tɨ́j ajta ari ɨ́ seɨ́j tiuꞌutaꞌaíj ɨ́ taꞌamuájca. Ajta aꞌɨ́ɨn yaujraꞌan, ayée pu tiraatáꞌixaa tɨjɨ́n: “Aa niꞌijtá, ayée nu rɨni.” Mɨ́ ajta caí, capu. Capu áꞌume tɨ tejaꞌumuárɨꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","’Nichéꞌe aꞌatzu tejámuaataꞌíhuaꞌu. Aꞌɨ́ɨme ɨ́ mej huaꞌapua, ¿aꞌataani ayén huarɨ́j aꞌij tɨ tíꞌijxeꞌeveꞌecaꞌa ɨ́ yaꞌupuáaraꞌan? Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Aꞌɨ́jna, ɨ́ taꞌamuájca. Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, aꞌɨ́ɨme ɨ́ mej huáꞌajijveꞌe ɨ́ gobierno jetze meꞌecan, majta aꞌɨ́ɨme ɨ́ ꞌuuca ɨ́ mej huataúraꞌan tumin jɨmeꞌe, aꞌɨ́ɨ mú áꞌamuamuaꞌitɨn meꞌɨ́jna jɨmeꞌe mej mi aꞌuun aꞌuteárute Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","’Ayee puꞌu tíꞌeen, aꞌiné ayée pu hui ꞌeen jɨ́n mú aꞌuvéꞌemej aꞌɨ́jna ɨ́ Juan tɨ i ayén tejámuaatáꞌixaateꞌen aꞌij sej yeꞌí huárɨni ɨ́ Dios jemi. Mɨ́ seajta múꞌeen, caxu ráꞌantzaahuate. Majta meꞌɨ́n ɨ́ mej huáꞌajijveꞌe, majta aꞌɨ́ɨme ɨ́ ꞌuuca ɨ́ mej huataúraꞌa tumin jɨmeꞌe, aꞌɨ́ɨ mú xaa ráꞌantzaahuate. Múꞌeen xu ráamuaꞌareeriꞌi seꞌɨ́jna. Capu amɨ́n aꞌij, aúcheꞌe pu caí tiꞌitɨ́j aꞌamua jetze tásiseiiri sej si seɨcɨé tiúꞌumuaꞌati, sej si ráꞌantzaahuateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xáanamuajriꞌi seɨ́j i niuucari. Jaꞌatɨ́ tɨ nuꞌu ayén uuva huáhuii. Ajta raaréꞌana tejcuá jɨmeꞌe. Aj pu ꞌi tiꞌitɨ́j atéꞌijche tɨ tzajtaꞌan rámɨꞌɨye jáꞌaraꞌaraꞌan ɨ́ uuva. Ajta nuꞌu tiꞌitɨ́j ájtaahuacaꞌa mej japuan huaꞌíxɨꞌereꞌen mej mi raaseíj nainjapua aꞌutɨ́ jaꞌuꞌástɨme mej tíꞌimɨjhuaca. ’Ayee pu aꞌɨ́jna jɨ́n huarɨ́j, aj pu i huaꞌutáneɨ́jte ɨ́ chuej mej mi tiraanájchiteꞌen caj jeꞌicáca. Aj pu i áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ seɨ́j chuéjraꞌa japua. ");
INSERT INTO crnNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","’Tɨ́ꞌɨj nuꞌu tejaꞌuréꞌene matɨ́ꞌɨj puaꞌa rajuꞌuraca aꞌɨ́jna ɨ́ uuva, seica pu huataꞌítecaꞌa aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe mej mi huaꞌutáhuavii aꞌachú tɨ caj tíꞌijcɨꞌɨti aꞌɨ́jna tɨ tíchuej. ");
INSERT INTO crnNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Majta meꞌɨ́n ɨ́ chuej mej huataújneɨj, aꞌɨ́ɨ mú huaꞌuvíviꞌi aꞌɨ́mej ɨ́ mej huataꞌítiꞌihuacaꞌa. Seɨ́j mú huatéevajxɨ. Majta seɨ́j mú huajéꞌica, majta ɨ́ seɨj, meraateátuꞌasixɨ tetej jɨmeꞌe. Camu tiꞌitɨ́j huaꞌutáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","’Ajta nuꞌu aꞌɨ́ɨn ɨ́ tɨ tíꞌiraꞌaijteꞌecaꞌa, seica pu ajtahuaꞌa huataꞌáitecaꞌa. Muꞌuri jaítzeꞌe iꞌi muꞌiicáa. Majta meꞌɨ́n ɨ́ chuej mej huataújneɨj, ayée mú cheꞌatá menaꞌa huáꞌuruu aꞌɨ́mej ɨ́ mej huataꞌítiꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Yee pu nuꞌu teuuméꞌeca. Tɨꞌɨj jí, aꞌɨ́ɨ huataꞌítecaꞌa aꞌɨ́jna ɨ́ ruyauj. Ayee pu tiuꞌumuáꞌaj tɨjɨ́n: “Meráꞌantzaahuateꞌesin sein.” ");
INSERT INTO crnNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","’Majta meꞌɨ́n ɨ́ chuej mej huataújneɨj, matɨ́ꞌɨj raaseíj meꞌɨ́jna ɨ́ yaujraꞌan, ayée mú tiraaxɨ́ꞌepɨꞌɨntare rujɨ́ɨmuaꞌa tɨjɨ́n: “Aꞌii pu aꞌɨ́ɨn púꞌeen, ɨ́ tɨ nain tíꞌijcɨꞌɨti. Cheꞌeré, tichéꞌe raajéꞌica tɨ ij téjmi taꞌáa áꞌaraꞌani.” ");
INSERT INTO crnNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aj mú nuꞌu mi rajvíꞌi meꞌɨ́jna ɨ́ yaujraꞌan. Matɨ́ꞌɨj mi ruꞌirájrɨe á puaꞌacɨé. Majta raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Meꞌecui ariꞌicu, ¿aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? Tɨ́ꞌɨj mú aꞌuvéꞌemeꞌen aꞌɨ́jna ɨ́ áꞌaraꞌan ɨ́ chuej, ¿aꞌiné tiꞌitɨ́j huáꞌaruuren aꞌɨ́mej ɨ́ chuej mej huataújneɨj? ");
INSERT INTO crnNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨ pu caí huaꞌacuꞌuvée huaꞌantipuáꞌajteꞌesin aꞌɨ́mej ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte. Ajta, aꞌɨ́ɨ pu hui seica huataniɨ́jteꞌesin ɨ́ chuej. Majta meꞌɨ́n, ayée mú xaa raatáꞌasin ɨ́ tɨ ráacɨꞌɨti tɨ́ꞌɨj aꞌájna tejaꞌuréꞌenen matɨ́ꞌɨj puaꞌa tíꞌijuꞌuraca. ");
INSERT INTO crnNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni secaí jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze seꞌíjna i niuucari tɨ ayén jɨ́meꞌen yee: Aꞌíjna i tetej i mej raatéꞌuu, ájcaꞌi mej yaꞌuhuáꞌaxɨ ɨ́ mej chiꞌij taꞌahuaca; ayén pu teꞌirájraa tɨ aꞌɨ́ɨn púꞌeeneꞌe jáꞌaraa tɨ iꞌi esquineero? Tavástaraꞌa pu ayén ráaruu, ajta rɨ́ꞌɨ teꞌutéevatzɨ ɨ́ tatzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","’Aꞌɨ́j pu jɨ́n, ayée nu tejáꞌamuaꞌixaateꞌe, Dios pu amuáꞌariꞌira aꞌɨ́jna tɨ tejaꞌamuacɨꞌɨtíicheꞌe júteꞌe tɨ éꞌemeꞌecan ɨ́ Dios jemi. Aꞌɨ́ɨ pu huaꞌutáꞌasin seica ɨ́ mej miyen rɨni aꞌij tɨ tiraavíjteꞌe. Aꞌɨ́ɨ mú raꞌaráꞌastijreꞌesin xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ajta aꞌíin i tetej, tɨ puaꞌa jaꞌatɨ́ japuan tíveti, aꞌɨ́jna ɨ́ jaꞌatɨ huaténaꞌaxɨjsin aꞌíjna i tetej japua. Naꞌari caí, tɨ puaꞌa aꞌíin tetej án éꞌejveti japuan seɨ́j ɨ́ tevi, aj pu i aꞌíin raꞌiráxayeepeꞌesin ɨ́ tevi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Majta meꞌɨ́n ɨ́ mej tíꞌaijta teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ fariseos, matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ Jesús tíꞌixajtacaꞌa niuucari jɨmeꞌe, aj mú mi ráamuaꞌareeriꞌi tɨ aꞌɨ́ɨn aꞌɨ́mej téxajtaꞌajmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Matɨ́ꞌɨj mi ráahuau aꞌij mé yeꞌí huárɨni mej mi raatéeviꞌi. Mɨ́ majta, camu miyen huarɨ́j aꞌiné mehuáꞌatziɨɨneꞌecaꞌa aꞌɨ́mej ɨ́ teɨte ɨ́ mej meꞌuun eꞌetiújseɨreꞌecaꞌa. Aꞌɨ́ɨme ɨ́ teɨte, naímiꞌi mú miyen ramuaꞌareerecaꞌa tɨ Jesús aꞌɨ́ɨn púꞌeeneꞌe seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ajtahuaꞌa pu Jesús ayén tihuaꞌutáꞌixaa niuucari jɨmeꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Ayee pu Dios huáꞌaruure ɨ́ teteca mej íiyen japuan cɨɨne ɨ́ chaanaca tɨ Dios teꞌáijta. Ayee pu cheꞌatá naꞌa huáꞌaruuren tɨ́j aꞌɨ́jna ɨ́ rey tɨ tiúꞌuyeste aꞌɨ́jna jɨmeꞌe tɨ yaujraꞌan huaténeꞌɨchecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","’Ajta aꞌɨ́ɨn ɨ́ rey, aꞌɨ́ɨ pu nuꞌu huaꞌutaꞌítecaꞌa aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe mej nuꞌu u huaꞌutájeeve aꞌɨ́mej ɨ́ tɨ ari huaꞌutáꞌinee. Mɨ́ majta aꞌɨ́mej ɨ́ mej huatáꞌiniihuacaꞌa, camu áꞌujcaꞌanejcaꞌa mej á aꞌireꞌenen. ");
INSERT INTO crnNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","’Ajtahuaꞌa, seica huataꞌítecaꞌa mej mi majta huaꞌutájeeve. Ayee pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe tɨjɨ́n: “Ayee xu yeehui tihuaꞌutáꞌixaateꞌen aꞌɨ́mej nej neri huaꞌutáꞌinee tɨjɨ́n puꞌuri tiuꞌutéꞌatɨme ɨ́ cuaꞌira, puꞌuri ajta tiuꞌutaꞌaíjtacaꞌa mej huáꞌucuiꞌini ɨ́ yeꞌemuaate tɨ tihuáꞌucɨꞌɨmite, huáacasi, majta puuyesi. Nain pu yeehui ari huaxɨ́ꞌepɨꞌɨn tej ti tiúꞌuyesten.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","’Majta meꞌɨ́n ɨ́ mej huatáꞌiniihuacaꞌa, camu aꞌatzu huáꞌutzaahua. Maꞌucɨ́jxɨ micu. Seɨ́j pu aꞌuun áꞌume aꞌu tɨ tejéꞌehuasteꞌe. Ajta seɨ́j, aꞌúu pu áꞌume aꞌu tɨ tejáꞌatua. ");
INSERT INTO crnNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Majta ɨ́ seica, aꞌɨ́ɨ mú nuꞌu huaꞌuvíviꞌi ɨ́ mej tíꞌijvaɨreꞌe meꞌɨ́jna ɨ́ rey. Majta aꞌij puaꞌa huáꞌuruu. Majta huáꞌucuii seica. ");
INSERT INTO crnNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","’Jéꞌecan pu nuꞌu huataniúꞌucacaꞌa aꞌɨ́jna rey. Aꞌɨ́ɨ pu huaꞌutaꞌítecaꞌa aꞌɨ́mej ɨ́ xantaaruꞌu. Matɨ́ꞌɨj mi huáꞌucuii naíjmiꞌica ɨ́ teɨte. Majta raaréꞌatai ɨ́ huáꞌachiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","’Aj pu i aꞌɨ́ɨn ɨ́ rey ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe tɨjɨ́n: “Puꞌuri huaxɨ́ꞌepɨꞌɨn tej tíꞌiyesten. Mɨ́ ajta, aꞌɨ́mej ɨ́ nej neri huaꞌutáꞌinee, capu ayén huaꞌucɨ́ꞌɨ mej mú mú aꞌuvéꞌejuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Sericu múꞌeen, tɨ́j naꞌa tɨ cureꞌenéjme ɨ́ caaye, setáꞌaj huaꞌutáꞌinen matɨ́j menaꞌa ɨ́ teɨte aꞌachú sej puaꞌaméca jéꞌeteuni.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","’Matɨ́ꞌɨj mi huiráacɨ caaye jetze aꞌɨ́ɨme ɨ́ mej tíꞌijvaɨreꞌe. Jéihua mú huáꞌajseɨj ɨ́ teɨte aꞌachú mej puaꞌaméca áꞌuteu, ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte, majta ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte. Ayee muꞌu puaꞌamé aꞌuteájrupi u chiꞌita aꞌachú mej úꞌuve. ");
INSERT INTO crnNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Aj pu nuꞌu i aꞌɨ́ɨn rey, aꞌuteájrupi aꞌujna tɨ́ꞌij aꞌɨ́mej huaseíj ɨ́ tɨ huaꞌutáꞌinee. Aj pu i jaꞌatɨ́ huaseíj tɨ caí ayén tiꞌitéechen aꞌij tɨ tiraavíjteꞌe tɨ puaꞌa seɨ́j huaténeɨche. ");
INSERT INTO crnNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ayee pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: “Casiꞌi, neꞌamiigu, ¿aꞌiné tiuꞌutárɨꞌɨristarecaꞌa pej caí piyen éeneꞌe tiꞌitéechen aꞌij tɨ tiraavíjteꞌe, pej uteárute peyujna?” Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ́, capu nuꞌu aꞌatzu huataniú. ");
INSERT INTO crnNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","’Aj pu i aꞌɨ́ɨn rey ayén tíhuaꞌutaꞌaíj aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe tɨjɨ́n: “Setáꞌaj yeehui raꞌamuájɨꞌɨcɨꞌen muájcaꞌareꞌaraꞌan jetze, seajta ɨɨcájraꞌan jetze. Seajta, mé puaꞌacɨé yaꞌurájrɨeeni aꞌu tɨ aꞌutɨ́caꞌa. Aꞌuu mú yeehui ruyeíne muáꞌajuꞌun, majta rutamej jɨ́n ancuréꞌujcɨꞌɨmée muáꞌajuꞌun meꞌɨ́jna jɨmeꞌe ɨ́ mej rajpuaíjtzi.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Majta meꞌɨ́n tɨ Dios huáꞌajee, aꞌɨ́ɨ mú muꞌíi. Mɨ́ majta, meꞌɨ́n tɨ Dios huaꞌavéꞌehuau, camu muꞌíi, sino cɨ́j muꞌu, micu. ");
INSERT INTO crnNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Majta meꞌɨ́n ɨ́ fariseos, aꞌɨ́ɨ mú aꞌucɨ́j. Majta miyen raaxɨ́ꞌepɨꞌɨntare mej mi raatémuaꞌitɨn meꞌɨ́jna ɨ́ Jesús tɨ ij aꞌɨ́ɨn ayén autéꞌɨtzen mej mi meꞌɨ́jna jɨ́n jetzen teꞌujpuáꞌajteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Matɨ́ꞌɨj mi seica huataꞌáitecaꞌa mej mi tiuꞌuxáj jamuan ɨ́ Jesús. Aj mú mi aꞌucɨ́j, majta seica jamuan ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe aꞌɨ́jna ɨ́ Heródes. Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Maeestru, aꞌij tu muaꞌaree tɨ caí tiꞌitɨ́j timuáꞌaturaateꞌe, pajta hui piyen tzáahuatiꞌiraꞌa jɨ́n tíꞌimuaꞌata aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Múꞌee pej caí tíꞌajaahuateꞌe ɨ́ teɨte jemi aꞌiné capu múꞌeetzi jetze ruxeꞌeveꞌe jaꞌatén mej púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Patáꞌaj piyen titaatáꞌixaateꞌen yee: ¿Ni qui xɨ́ꞌepɨꞌɨn tej teꞌɨ́ɨn tiuꞌunájchi aꞌɨ́jna jɨmeꞌe ɨ́ mej huáꞌajijveꞌe ɨ́ gobierno jetze meꞌecan nusu tecaí? ¿Ni qui tiyen tiraanájchiteꞌen teꞌɨ́jna tɨ tíꞌitaꞌaijteꞌe tɨ ayén ántehuaa tɨjɨ́n César? ");
INSERT INTO crnNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ajta aꞌɨ́ɨn ɨ́ Jesús, puꞌuri ramuaꞌareerecaꞌa mej caí miyen tíꞌiraꞌihuaꞌu jéꞌiyecan jɨmeꞌe sino ayée mú raxɨ́ꞌeveꞌecaꞌa mej aꞌij puaꞌa ráaruuren. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen xu caí siyen tíꞌijrɨꞌɨre jéꞌiyecan jɨmeꞌe. ¿Aꞌiné ꞌeen jɨ́n siyen tíꞌiteseꞌe sej naateeviꞌi? ");
INSERT INTO crnNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tumin senaataseíjrateꞌe ɨ́ mej jɨ́n tíꞌinajchita meꞌɨ́jna ɨ́ mej jɨ́n huáꞌajijveꞌe. Aj mú mi seɨ́j yeꞌevéꞌeꞌɨꞌɨte, ɨ́ tumin. ");
INSERT INTO crnNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌataani ɨ́ néerimeꞌaraꞌan aꞌaseijreꞌe? ¿Aꞌiné ántehuaa yéj tɨ áꞌayuꞌusiꞌi? ");
INSERT INTO crnNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Amɨ́jna neꞌu ɨ́ tej tiyen ratamuáꞌamua tɨjɨ́n César. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj siyen huárɨni. Seraatáꞌan seꞌɨ́jna ɨ́ César aꞌachú tɨ caj tíꞌiracɨꞌɨti, seajta raatáꞌan ɨ́ Dios aꞌachú tɨ caj tíꞌiracɨꞌɨti aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Matɨ́ꞌɨj miyen tiráanamuajriꞌi, jéꞌecan mú naa rɨ́ꞌɨ tiraꞌutaseíj. Matɨ́ꞌɨj mi á yaúurɨe. Majta aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Aꞌájna xɨcájraꞌa jetze, aꞌɨ́ɨ mú majta á eꞌiréꞌene aꞌɨ́ɨme ɨ́ saduceos. Ayee mú tíꞌixaxaꞌa aꞌɨ́ɨme tɨ jɨ́meꞌen yee camu chéꞌe huatarújsin ɨ́ mej huácuii. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Maeestru, ayée pu raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan. Tɨ́ puaꞌa nuꞌu jaꞌatɨ́ tɨ neɨche, tɨ puaꞌa aꞌɨ́ɨn caí títɨꞌɨríjmuaꞌa huámɨꞌɨni, ruxeꞌeveꞌe nuꞌu tɨ aꞌɨ́ɨn ihuáareꞌaraꞌan raꞌancuréꞌeviꞌitɨn aꞌɨ́jna tɨ ratéviꞌitɨneꞌe ɨ́ tɨ huamɨ́ꞌɨ tɨ ij títɨꞌɨríjmuaꞌa áꞌaraꞌani aꞌɨ́jna jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","’Ayee pu hui jaꞌanáj tiujuꞌurɨ́j téjmi tzajtaꞌa. Muaꞌaráhuaꞌapuacaꞌa meꞌɨ́jna ɨ́ ruꞌihuaamuaꞌa. Ajta aꞌɨ́ɨn tɨ iꞌivastaꞌa, aꞌɨ́ɨ pu huaténeꞌɨchecaꞌa. Ajta áꞌiyen huamɨ́ꞌɨ. Aru capu títɨꞌɨrijmuáꞌa jáꞌaraa aꞌɨ́jna tɨ ratéviꞌitɨneꞌe. Aꞌɨ́ɨ pu jemi huateájturaa aꞌɨ́jna tɨ raꞌitéꞌase. ");
INSERT INTO crnNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ayee pu cheꞌatá naꞌa tiráaruu aꞌɨ́jna ɨ́ juutzeájraꞌan ɨ́ tɨ raꞌitéꞌase ɨ́ tɨ vástaꞌa meꞌecan, aꞌɨ́ɨ pu ajta caí títɨꞌɨrijmuáꞌa jáꞌaraa, huamɨ́ꞌɨ. Ajta áꞌiyen ɨ́ seɨj, ɨ́ tɨ iꞌi huaíca, aꞌɨ́ɨ pu raꞌanténexcacaꞌa. Ajta, ayée pu cheꞌatá naꞌa tiráaruu. Ajta áꞌiyen, ayén teꞌirájraa tɨ ayén tihuáꞌuruu naíjmiꞌica ɨ́ mej aráhuaꞌapua. Capu jaꞌatɨ́ títɨꞌɨrijmuáꞌa jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tɨꞌɨj jí, aꞌɨ́ɨn ꞌɨ́itaꞌa ajta huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","’Ari íjii, ¿aꞌataani hui ɨ́raꞌaraꞌan púꞌéeneꞌe aꞌame, aꞌájna xɨcájraꞌa mej jetzen majtáhuaꞌa huatarújsin? Naíimiꞌi mú xaa ratéviꞌitɨneꞌe, aꞌɨ́ɨme ɨ́ mej aráhuaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Seteꞌuteújxua múꞌeen aꞌiné caxu ramuaꞌaree aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Caxu seajta ramuaꞌaree aꞌij tɨ ꞌeen ɨ́ muárɨꞌeriꞌireꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aꞌájna xɨcájraꞌa mej jetzen huatarújsin ɨ́ mɨꞌɨchite, camu miyen néjneꞌɨchen ɨ́ teteca. Majta ɨ́ ꞌuuca, camu majta viɨchen, sino ayée mú éeneꞌe muáꞌajuꞌun matɨ́j aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe u ta japua Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","’Mɨ́ seajta múꞌeen, jɨ́meꞌen aꞌájna xɨcájraꞌa mej jetzen huatarújsin aꞌɨ́ɨme ɨ́ mej huácuii, ¿ni tzaa secaí jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze aꞌij tɨ Dios tejáꞌamuaꞌixaateꞌe tɨjɨ́n: “Nee nu nauj huáꞌa Dios púꞌeen aꞌɨ́mej ɨ́ áꞌamuayaꞌupua, aꞌɨ́jna ɨ́ Abraham, ajta aꞌɨ́jna ɨ́ Isaac, ajta aꞌɨ́jna ɨ́ Jacobo”? Dios pu tihuaúꞌixaa cumu mej mauj ruuricaꞌa. Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeen ɨ́ huáꞌa Dios aꞌɨ́mej ɨ́ mej ruuri. Capu huáꞌa Dios púꞌeen aꞌɨ́mej ɨ́ mej mɨꞌɨchite. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Majta meꞌɨ́n ɨ́ teɨte ɨ́ mej eꞌetiújseɨj ɨ́ jemin, jéꞌecan mú naa rɨ́ꞌɨ tiraꞌutaseíj meꞌɨ́jna jɨmeꞌe aꞌij tɨ aꞌɨ́ɨn tihuáꞌamuaꞌatejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Majta meꞌɨ́n ɨ́ fariseos, matɨ́ꞌɨj ráamuaꞌareeriꞌi tɨ Jesús ayén huaꞌutémuaꞌitɨ aꞌɨ́mej ɨ́ saduceos, aj mú mi tiújseɨj. ");
INSERT INTO crnNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ajta seɨ́j tɨ huáꞌa jetze ajtémeꞌecantacaꞌa, temuaꞌa pu tiraayɨ́ꞌɨtɨhuaꞌa aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Aꞌɨ́ɨ pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maeestru, ¿tiꞌitájni niuucarijraꞌa jaítzeꞌe ruxeꞌeveꞌe ɨ́ tɨ raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan? ");
INSERT INTO crnNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","38","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ niuucarijraꞌa ɨ́ taꞌamuájca, tɨ jaítzeꞌe ruxeꞌeveꞌe caí máàj seɨ́j niuucarijraꞌa, tɨ ayén tɨjɨ́n: “Patáꞌaj piyen rɨ́ꞌɨ teꞌutáꞌamuaꞌati ɨ́ áꞌa tzajtaꞌa ɨ́ Dios jemi, nain ɨ́ pej jɨ́n rɨ́ꞌɨ teꞌutáꞌamuaꞌati, aꞌachú pej caj téꞌacaꞌane ɨ́ áꞌaxɨejniuꞌuca jetze, pajta nain jɨ́n áꞌaxeꞌeviꞌiraꞌa jɨmeꞌe, ajta áꞌamuaꞌatziiraꞌa jɨmeꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","’Ajta, ayée pu hui cheꞌatá naꞌa ꞌeen ɨ́ tɨ raꞌitéꞌase tɨjɨ́n: “Patáꞌaj nuꞌu piyen cheꞌatá penaꞌa rɨ́ꞌɨ tirájchaꞌɨɨ ɨ́ axɨ́ꞌej tevi patɨ́j aseɨ́j tiꞌitiꞌáꞌachaꞌɨ́ɨ.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nain aꞌij tɨ raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, ajta nain aꞌij mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, nain pu jɨ́n ayén tirájteusin aꞌɨ́jna jɨmeꞌe i tɨ tíꞌihuaꞌapua i niuucari. ―Ayee pu Jesús tiraatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Maúcheꞌe mú eꞌeréꞌeteꞌecaa aꞌɨ́ɨme ɨ́ fariseos. Tɨꞌɨj jí Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi jɨ́meꞌen aꞌɨ́jna ɨ́ Cɨríistuꞌu, tɨ Dios án yáꞌujra ɨ́ ɨpuari japua? ¿Aꞌataani yaujraꞌan púꞌeen? Ayee mú titeetaniú tɨjɨ́n: ―Aꞌɨ́ɨ pu hui rayauj aꞌɨ́jna ɨ́ David teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tɨ́ puaꞌa ayén tiꞌayajna, tɨ́ꞌɨj aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios raatáꞌa tɨ David tiuꞌutaxáj aꞌɨ́jna jɨmeꞌe ɨ́ Cɨríistuꞌu, ¿aꞌiné ꞌeen jɨmeꞌe David ayén raatamuáꞌa tɨjɨ́n nevástaraꞌa? Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ David teecan tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tavástaraꞌa pu ayén tiraatáꞌixaa aꞌíjna i nevástaraꞌa tɨ jɨ́meꞌen yee: “Aꞌujyeíjxɨꞌɨ ɨpuari japua íiye nerɨꞌɨríintaꞌa. Paúcheꞌe huatéjcatii ajta nenaꞌa caí huaꞌutémuaꞌitɨn ɨ́ mej muájchaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","’Aꞌɨ́j pu jɨ́n, tɨ puaꞌa David ayén raatamuáꞌa tɨjɨ́n nevástaraꞌa, ¿aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn Cɨríistuꞌu ayén aꞌɨ́ɨn puꞌéeneꞌe áꞌaraꞌani ɨ́ yaujraꞌan? Capu aꞌij tíꞌirɨꞌɨri xaa neꞌu, aꞌiné Cɨríistuꞌu pu jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee caí David teecan ayén tiꞌitéveecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Majta meꞌɨ́n ɨ́ mej ráanamuajriꞌi, camu aꞌatzu aꞌij tirájteu aꞌij mej tiuꞌutániuuni. Tɨ́j naꞌa aꞌájnáꞌɨmua, capu chéꞌe jaꞌatɨ́ áꞌucaꞌanejcaꞌa tɨ ayén tiraataꞌíhuaꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Aj pu i Jesús huaꞌutáꞌixa aꞌɨ́mej ɨ́ teɨte mej jemin eꞌetiújseɨreꞌecaꞌa, ajta aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayen tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Aꞌɨ́ɨme, ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, majta aꞌɨ́ɨme ɨ́ fariseos, aꞌɨ́ɨ mú títetéꞌuꞌupuꞌu teyujtaꞌa mej mi miyen cheꞌatá menaꞌa tihuáꞌumuaꞌaten ɨ́ teɨte ɨ́ yuꞌuxari jetze aꞌij tɨ rɨjcaꞌa aꞌɨ́jna ɨ́ Moisés teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Aꞌɨ́j pu jɨ́n ayén ruxeꞌeveꞌe sej si huaꞌaráꞌastijreꞌen, seajta siyen huárɨni nain jɨmeꞌe aꞌij mej tejáꞌamuaꞌixaateꞌe. ’Mɨ́ seajta múꞌeen, caxu siyen cheꞌatá senaꞌa rɨjca aꞌij mej yeꞌí rɨcɨ aꞌiné camu miyen jéꞌiyecan jɨ́n tíꞌijrɨꞌɨre aꞌij mej tejáꞌamuaꞌixaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ayee mú veꞌecán jɨ́n tihuaꞌaꞌíjcateꞌe ɨ́ teɨte aꞌɨ́jna jɨmeꞌe tɨ ayén huápɨꞌɨ muárɨꞌeri tɨ caí jaꞌatɨ́ raayɨ́ꞌɨtɨ tɨ ayén huárɨni. Majta áꞌiyen, aꞌɨ́ɨ mú huaꞌutaꞌaíjteꞌesin ɨ́ teɨte mej nuꞌu mi meꞌɨ́jna jɨ́n raꞌaráꞌastijreꞌen. Mɨ́ majta meꞌɨ́n, camu aꞌatzu taúraꞌaca tɨ ij ayén cheꞌatá naꞌa tihuáꞌucɨꞌɨti. ");
INSERT INTO crnNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","’Matɨ́j menaꞌa mej miyen rɨcɨ, ayée muꞌu rɨcɨ jéjreꞌecɨtzeꞌe mej mi teɨte huaꞌuseíj. Antajíyaꞌujmeꞌen mú ratáꞌahuaca meꞌɨ́jna ɨ́ mej jɨ́n antéujjɨ́ꞌɨcɨꞌejme ɨ́ rumuꞌúu jetze, majta tɨ́tɨꞌɨjméꞌen teꞌejviɨ́jxɨ aꞌutɨ́ tɨ aucástɨmee ɨ́ huaꞌasiicuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Jéꞌecan mú raxɨ́ꞌeveꞌe tɨ tihuáꞌucɨꞌɨti mej aꞌujráꞌase ɨpuari japua jamuan aꞌɨ́jna ɨ́ tɨ antiújmuaꞌaree aꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n tíꞌiyeste. Ajta huaꞌatéyujtaꞌa, ayée mú raxɨ́ꞌeveꞌe mej aꞌujráꞌase ɨ́ taꞌamuájca ɨ́ ɨpuari japua aꞌuj mej áꞌararaase ɨ́ huáꞌavaujsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jéꞌecan pu huaꞌaráanajche mej meꞌɨ́n teɨte huaꞌutateújte aꞌájna aꞌu mej tíꞌituꞌaraca. Ajta, ayée pu huaꞌaráanajche mej teɨte miyen tihuáꞌajeeve tɨjɨ́n nevástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Mɨ́ seajta múꞌeen, caxu siyen rahuauca tɨ ij jaꞌatɨ́ ayén tejamuaatájeeve tɨjɨ́n nevástaraꞌa. Caxu xaa neꞌu, aꞌiné naíjmiꞌi xu ruꞌihuaamuaꞌa, ajta seɨ́j puꞌu púꞌeen ɨ́ áꞌamuavastaraꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Seajta múꞌeen, caxu siyen jaꞌatɨ́ huatámuaꞌati tɨjɨ́n niyáꞌupua, aꞌiné seɨ́j puꞌu púꞌeen ɨ́ sej seri rájyaꞌupua. An pu éꞌeseijreꞌe u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","’Caxu seajta rahuauca mej miyen tejáꞌamuajeeve tɨjɨ́n nemaeestro. Caxu aꞌatzu, aꞌiné seɨ́j puꞌu púꞌeen ɨ́ tɨ iꞌi áꞌamuamaestru, inee i nej iꞌi Cɨríistuꞌu, tɨ Dios án nejaꞌujyeíjtza ɨ́ ɨpuari japua. ");
INSERT INTO crnNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","’Ajta, aꞌɨ́jna tɨ jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee aꞌamua tzajtaꞌa, aꞌɨ́ɨ pu hui amuaatévaɨreꞌesin naíjmiꞌica múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ayee puꞌu, aꞌiné jaꞌatɨ́ tɨ naꞌa tɨ áꞌujtzaahuateꞌe tɨ nuꞌu veꞌecán jɨ́n tiꞌitéjvee, Dios pu raatáꞌasin tɨ cɨliéeneꞌe jɨ́n teꞌenteárute. Mɨ́ ajta, jaꞌatɨ́ tɨ naꞌa tɨ jéꞌiyecan jɨ́n ruseijrata tɨ cɨliéeneꞌe jɨ́n tiꞌitéjvee, Dios pu ayén raatáꞌasin tɨ teꞌenteárute tiꞌitɨ́j jɨmeꞌe tɨ veꞌée. ");
INSERT INTO crnNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Setáꞌaj huataújxɨeemɨsteꞌen múꞌeen mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, seajta múꞌeen mɨ sej iꞌi fariseos. Caxu siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe aꞌiné caxu araúraste rujɨ́ɨmuaꞌa. Ayee xu tihuaꞌaténaamua ɨ́ teɨte mej mi caí aꞌuteárute aꞌu tɨ Dios éꞌeseijreꞌe u ta japua. Caxu áꞌujcaꞌane sej siyen huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Caxu seajta huaꞌatáꞌaca mej mi miyen huárɨni mɨ seica ɨ́ mej tíꞌiteseꞌe mej mi meꞌuun aꞌuteárute. ");
INSERT INTO crnNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’Seajta, setáꞌaj siyen huataújxɨeemɨsteꞌen, múꞌeen mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, seajta múꞌeen mɨ sej iꞌi fariseos. Caxu siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe aꞌiné caxu araúraste rujɨ́ɨmuaꞌa. Ayee xu tihuáꞌariꞌira ɨ́ huáꞌa chiꞌij aꞌɨ́mej ɨ́ mej ꞌuuca, mɨ mej majta rujɨ́ɨmuaꞌatajme. Seajta áꞌiyen, aꞌuun xu aꞌuteáruꞌipi u teyujtaꞌa; seajta aꞌateeviꞌi jɨ́n rahuavíiraca ɨ́ Dios jemi. Múꞌeen xu siyen ruseijrata sej nuꞌu caí tiꞌitɨ́j jɨ́n auteájturaa. Aꞌɨ́j pu jɨ́n jaítzeꞌe xu rajpuaíitzi xáꞌajuꞌun. ’Seajta, setáꞌaj siyen cheꞌatá senaꞌa huataújxɨeemɨsteꞌen múꞌeen mɨ sej caí rɨ́ꞌɨ mé titeumuámuaꞌaree. Capu tiꞌitɨ́j tásiseiiri áꞌamuatzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen, mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, seajta múꞌeen mɨ sej iꞌi fariseos. Caxu siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe aꞌiné caxu araúraste rujɨ́ɨmuaꞌa. Ayee xu íiyen cɨɨne nainjapua ɨ́ chaanaca, seajta yen cɨɨne ɨ́ jaj japua sej si seɨ́j huatémuaꞌitɨn tɨ ij aꞌɨ́ɨn ayén tiꞌitiújchaꞌɨɨ setɨ́j múꞌeen. Seajta, setɨ́ꞌɨj raatémuaꞌitɨn, ayée xu tihuáꞌumuaꞌaten tɨ ij áꞌiyen jaítzeꞌe amuaatémuaꞌitɨn jeíhua aꞌɨ́jna jɨmeꞌe tɨ aꞌij puaꞌa tíꞌitevistan, ajta tɨ́ꞌij aꞌɨ́ɨn jeíhua pu jaítzeꞌe rajpuaíitzi aꞌame secaí múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Ayee xu si éeneꞌe seuj tihuáꞌamuaꞌate. Ayee xu tíꞌixaxaꞌa múꞌeen tɨjɨ́n: “Capu tiꞌitɨ́j vaɨreꞌe tɨ puaꞌa jaꞌatɨ́ ayén teꞌataújratzii niuucajtzeꞌen ɨ́ teyuu, sino tɨ jɨ́meꞌen yee tɨ puaꞌa jaꞌatɨ́ ayén teꞌataújratzii niuucajtzeꞌen aꞌɨ́jna ɨ́ oro tɨ teyuu jetze seijreꞌe, aj pu xaa ayén ruxeꞌeveꞌe tɨ aꞌɨ́ɨn jaꞌatɨ́ ayén araúrasten aꞌɨ́jna jɨmeꞌe tɨ teꞌataújratzii.” ");
INSERT INTO crnNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","’Múꞌeen xu caí tiꞌitɨ́j úꞌumuaꞌaree, mɨ sej caí tivejáuꞌitɨe. ¿Tiꞌitáani jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi? ¿Ni aꞌɨ́jna ɨ́ oro tɨ teyuu jetze seijreꞌe naꞌari ɨ́ teyuu tɨ tzajtaꞌan Dios huateúraꞌateꞌen aꞌɨ́jna ɨ́ oro? ");
INSERT INTO crnNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jee xaa neꞌu, jaítzeꞌe pu ruxeꞌeveꞌe ɨ́ teyuu. Ayee xu seajta tíꞌixaxaꞌa múꞌeen tɨjɨ́n: “Tɨ́ puaꞌa jaꞌatɨ́ ayén teꞌataújratzii niuucajtzeꞌen aꞌɨ́jna tɨ japuan tiuꞌutámuaɨꞌɨvejta, capu tiꞌitɨ́j aꞌij tíꞌivaɨreꞌe.” Mɨ́ seajta siyen tíꞌixaxaꞌa tɨjɨ́n: “Tɨ́ puaꞌa jaꞌatɨ́ ayén teꞌataújratzii niuucajtzeꞌen ɨ́ muaɨꞌɨvéjri tɨ án yáꞌujra japuan aꞌɨ́jna tɨ japuan tiuꞌutámuaɨꞌɨvejta, aj pu xaa ayén aꞌɨ́jna jɨ́n ruxeꞌeveꞌe tɨ araúrasten.” Capu tiꞌitɨ́j aꞌamua tzajtaꞌa tásiseiiri. ");
INSERT INTO crnNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","’Múꞌeen, mɨ sej caí rɨ́ꞌɨ mé titeumuámuaꞌaree, ¿tiꞌitáani jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi? ¿Ni aꞌɨ́jna ɨ́ muaɨꞌɨvéjri naꞌari aꞌɨ́jna tɨ japuan raatámuaɨꞌɨvajtacaꞌa, aꞌɨ́jna tɨ japuan Dios huateúraꞌateꞌen aꞌɨ́jna ɨ́ muaɨꞌɨvéjri? ");
INSERT INTO crnNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jee xaa neꞌu, jaítzeꞌe pu ruxeꞌeveꞌe aꞌɨ́jna sej japuan án yáꞌujra ɨ́ tɨ tiuꞌutámuaɨꞌɨvejta. ’Ayee puꞌu tíꞌeen, aꞌɨ́jna tɨ teꞌateújratziira niuucajtzeꞌen aꞌɨ́jna tɨ japuan tiuꞌutámuaɨꞌɨvejta, ayée pu ꞌeen jɨ́n teꞌateújratziira niuucajtzeꞌen aꞌɨ́jna ɨ́ tiꞌitɨ́j, ajta niuucajtzeꞌen naíjmiꞌi tɨ́j naꞌa tɨ án japuan yáꞌujra. ");
INSERT INTO crnNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ajta aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén teꞌateújratziira niuucajtzeꞌen ɨ́ teyuu, aꞌɨ́ɨ pu teꞌateújratziira niuucajtzeꞌen aꞌɨ́jna ɨ́ teyuu, ajta niuucajtzeꞌen Dios tɨ ari huiirájca aꞌujna. ");
INSERT INTO crnNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","’Ajta, tɨ puaꞌa jaꞌatɨ́ ayén teꞌateújratziira niuucajtzeꞌen u ta japua, ayée pu cheꞌatá naꞌa teꞌateújratziira niuucajtzeꞌen aꞌɨ́jna ɨ́ ɨpuari Dios tɨ án japuan ꞌéꞌe yéꞌixaca. Aꞌɨ́j pu jɨ́n, ayée pu cheꞌatá naꞌa teꞌateújratziira niuucajtzeꞌen aꞌɨ́jna ɨ́ Dios tɨ án ꞌéꞌe yéꞌixaca japuan aꞌɨ́jna ɨ́ ɨpuari. ");
INSERT INTO crnNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen, mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, seajta múꞌeen mɨ sej iꞌi fariseos. Caxu siyen tíꞌijrɨꞌɨre jéꞌiyecan jɨmeꞌe aꞌiné caxu siyen raꞌaráꞌastijreꞌen nain jɨmeꞌe aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Múꞌeen xu xaa raatáꞌan jaꞌicáj tɨ ruxeꞌeveꞌe aꞌɨ́jna jɨmeꞌe ɨ́ sej jɨ́n ráꞌancacareꞌen ɨ́ sej racuaꞌaca seꞌɨ́jna ɨ́ menta, seajta seꞌɨ́jna tɨ naa teáarɨ́ꞌe, anis tiꞌitɨ́j, seajta seꞌɨ́jna ɨ́ cumiinu. ’Mɨ́ seajta, caxu aꞌatzu raꞌaráꞌastijreꞌen seꞌɨ́jna jɨmeꞌe ɨ́ tɨ jaítzeꞌe ruxeꞌeveꞌe tɨ ayén tɨ jɨ́meꞌen yee: “setáꞌaj siyen raaxɨ́ꞌepɨꞌɨntariꞌireꞌen aꞌij tɨ tiraavíjteꞌe”, ajtahuaꞌa seɨ́j tɨ ayén yee: “setáꞌaj huáꞌancuꞌuvajxɨꞌɨn ɨ́ ruxɨ́ꞌej teɨte”, ajtahuaꞌa iꞌi tɨ jɨ́meꞌen yee: “setáꞌaj caí teꞌutéꞌɨtzeaaraꞌan seɨ́j jemi.” Ayee pu xɨ́ꞌepɨꞌɨn éeneꞌe áꞌameꞌencheꞌe sej caí yáꞌuhuaꞌanan seꞌɨ́jna tɨ jaítzeꞌe ruxeꞌeveꞌe, múꞌeen xu seajta siyen huárɨniicheꞌe ɨ́ tɨ cɨliéeneꞌe seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Capu hui tiꞌitɨ́j aꞌamua japua nineꞌi, múꞌejmi, mɨ sej tihuáꞌamuaꞌaten ɨ́ seica. Jéꞌecan xu tíꞌiteseꞌecaꞌa sej si siyen raꞌaráꞌastijreꞌen seꞌɨ́jna jɨmeꞌe ɨ́ niuucari tɨ caí jeíhua ruxeꞌeveꞌe. Mɨ́ seajta múꞌeen, xuꞌuri mé rúurɨe seꞌɨ́jna ɨ́ Dios tɨ raaxájtacaꞌa aꞌɨ́jna ɨ́ niuucari. ");
INSERT INTO crnNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’Setáꞌaj huataújxɨeemɨsteꞌen múꞌeen, mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze. Caxu siyen tíꞌijrɨꞌɨre jéꞌiyecan jɨmeꞌe. Ayee xu tíꞌiteɨꞌɨhuaca, seajta naa éeneꞌen tiuꞌuteujchéeteꞌen sej si naa éeneꞌen xáꞌaraꞌani mé jéjreꞌe. Mɨ́ seajta, ɨ́ ru tzajtaꞌa, jéꞌecan xu aꞌij puaꞌa tíꞌiteteɨte, aꞌɨ́jna jɨmeꞌe sej seri tihuáꞌurɨiiriꞌi ɨ́ tihuaꞌáa ɨ́ seica, seajta sej caí áꞌujcuꞌuvejcaꞌa ɨ́ sej jɨ́n tiuꞌutémuaꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Mɨ́ pej iꞌi fariseo tɨ caí tiꞌitɨ́j aꞌatzajtaꞌa tásiseiiri, pauj miꞌi rɨ́ꞌɨ uhuáꞌaruuren ɨ́ tɨ úꞌuseijreꞌe ɨ́ áꞌa tzajtaꞌa. Aj pu xaa, naa seíireꞌe aꞌame ɨ́ tɨ éꞌeseijreꞌe mé jéjreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","’Setáꞌaj huataújxɨeemɨsteꞌen múꞌeen, mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze. Caxu siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe. Múꞌeen xu siyen naa seijreꞌe mé jéjreꞌe. Seajta múꞌeen, aꞌij xu puaꞌa tíꞌiteteɨte ɨ́ ru tzajtaꞌa. Ayee xu ꞌeen tɨ́j huáꞌachiꞌi ɨ́ mej tzajtaꞌan huajéꞌenaamuaca ɨ́ mej meri huácuii. Aꞌiné ayée mú racácuainareꞌen mé jéjreꞌe, aꞌɨ́j pu jɨ́n naa seijreꞌe aꞌɨ́jna ɨ́ huáꞌachiꞌi. Mɨ́ ajta, u tzajtaꞌan, jeíhua pu teꞌuráꞌa ɨ́ tihuáꞌacari, ajta ɨ́ tihuáꞌahuaꞌiraꞌa tɨ ari tíꞌipeti. Ayee xu cheꞌatá senaꞌa aꞌij puaꞌa ꞌeen ɨ́ ru tzajtaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ sej caí siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe, seajta aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen mɨ sej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze, seajta múꞌeen mɨ sej iꞌi fariseos. Aꞌiné caxu siyen tíꞌijrɨꞌɨre tzáahuatiꞌiraꞌa jɨmeꞌe. Ayee xu ráꞌajtaꞌahuaca ɨ́ huáꞌachiꞌi ɨ́ mej tzajtaꞌan huaꞌateájtuaani ɨ́ mej meri huácuii, ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Seajta siyen tiracámeijra mé jéjreꞌe temuaꞌa naa aꞌɨ́jna huáꞌachiꞌi mej tzajtaꞌan huaꞌateájtuaani aꞌɨ́mej ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨtestacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","’Seajta siyen tíꞌixaxaꞌa tɨjɨ́n: “Tɨ́ puaꞌa tiyen ruuri táꞌaraꞌanicheꞌe aꞌájnáꞌɨmua matɨ́ꞌɨj yé chejcaꞌa aꞌɨ́ɨme tavaújsimuaꞌa teeca, catu xaa neꞌu tiyen cheꞌatá tenaꞌa huaꞌucuiꞌiníicheꞌe aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa matɨ́j tihuáꞌucuii ɨ́ tavaújsimuaꞌa teeca.” ");
INSERT INTO crnNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Aꞌɨ́j xu jɨ́n siyen téꞌantzaahuateꞌen ɨ́ ru jetze ɨ́ sej seꞌɨ́ɨn púꞌeen huáꞌahuaacɨxaꞌastemuaꞌa aꞌɨ́mej ɨ́ mej huáꞌucuii aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ayee xuꞌu i, setáꞌaj raanaíjmireꞌen aꞌɨ́jna ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi aꞌɨ́ɨme ɨ́ ruvaújsimuaꞌa teeca. ");
INSERT INTO crnNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’Múꞌeen xu aꞌij puaꞌa tíꞌiteteɨte, mɨ sej aꞌɨ́jna jetze airáane ɨ́ cuꞌucuꞌu tɨ tíꞌihuaꞌitaca, ¿aꞌiné tejamuáꞌamitɨejteꞌe? ¿Ni qui ayén yee múꞌeen xu huateújvaɨreꞌesin tɨ ij caí Dios amuaatáꞌan ɨ́ puaíjtzi? Ayej xaa neꞌu tiꞌayajna, puaíjtzi pu áꞌamuacɨꞌɨti tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Aꞌɨ́j nu jɨ́n niyen tejámuaataꞌítiꞌira aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌa, neajta seica ɨ́ mej rɨ́ꞌɨ mé titeumuámuaꞌaree, neajtahuaꞌa seica ɨ́ mej tíꞌimuaꞌata. Mɨ́ seajta múꞌeen, seica xu cuiꞌini, seajta seica siyen huáꞌatatan ɨ́ cúruu jetze, seajta seica, ayée xu tihuaꞌutévajxɨꞌɨsin u áꞌamuateyujtaꞌa. Seajta seica, ayée xu huaꞌutamuáriteꞌesin aꞌu tɨ éꞌechajtaꞌa, seajta méyee. ");
INSERT INTO crnNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","’Ayee puꞌi ꞌéen jɨ́n tejáꞌamuacɨꞌɨti nain jɨ́n ɨ́ puaíjtzi ɨ́ mej jɨ́n titéecui íiyen chaanaca japua tɨ́j naꞌa mej raajéꞌica aꞌɨ́jna ɨ́ Abel teecan tɨ yú eꞌiréꞌene matɨ́ꞌɨj raajéꞌica meꞌɨ́jna ɨ́ Zacarías ɨ́ tɨ yaujraꞌan púꞌeeneꞌe aꞌɨ́jna ɨ́ Berequías. Aꞌuu mú yaꞌujéꞌica jáꞌitaꞌa tɨ aꞌutéjvee ɨ́ huaꞌateyuu, ajta aꞌɨ́jna ɨ́ mej japuan tiuꞌutámuaɨꞌɨvejta. ");
INSERT INTO crnNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","’Ayee nu hui tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna. Naíjmiꞌi jɨmeꞌe ɨ́ mej miyen aꞌij puaꞌa rɨjcaꞌa, puaíjtzi pu tihuáꞌacɨꞌɨti aꞌɨ́mej íjii mej yéchej aꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’Seajta múꞌeen, mɨ sej Jerusalén huachéjme, naímiꞌi múꞌeen mɨ sej Jerusalén jetze ajtémeꞌecan, jéꞌecan nu huatánxɨeemɨjteꞌe múꞌejmi jemi, aꞌiné ayée xu huáꞌacuiꞌica aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌa. Seajta múꞌeen, siyen huaꞌuteátuꞌasixɨ aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tejáꞌamuaꞌaijteꞌe múꞌejmi. Muꞌíi nu niyen tíꞌijxeꞌeveꞌecaꞌa nej niyen rɨ́ꞌɨ tejamuáachaꞌɨɨn, nej ni amuaꞌirájtuaani. Néjxeꞌeveꞌecaꞌa nej niyen amuáaruuren tɨ́j tecuaaraꞌi tɨ huaꞌantéseɨreꞌe ɨ́ chɨ́ɨpɨliꞌise tɨ huaꞌavaꞌana ɨ́ ruꞌana jɨmeꞌe. Mɨ́ seajta múꞌeen, caxu siyen tíꞌijxeꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","’Casiꞌi múꞌeen, puꞌuri tɨ́n nej yé rúurɨeeni aꞌɨ́jna xɨcájraꞌa nej jetzen raatátuaani ɨ́ aꞌamuachiꞌi. Muáꞌaviꞌin pu aꞌutéchaxɨjsin. ");
INSERT INTO crnNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ayee puꞌu, aꞌiné caxu chéꞌe jaꞌanáj neseijran ajta senaꞌa caí siyen raataxáj yee: “Chéꞌe huaújtemuaꞌaveꞌen aꞌɨ́jna tɨ yeꞌevéꞌeme niuucajtzeꞌen aꞌɨ́jna ɨ́ tavástaraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Aj pu i Jesús huirájraa teyujtaꞌa. Tɨ́ꞌɨj huiiraméꞌeca, aꞌɨ́ɨ mú á eꞌiréꞌene aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aj mú mi raatajé tɨ nuꞌu raaseíj ɨ́ seica ɨ́ chiꞌij tɨ huáꞌuu jetzen ɨ́ teyuu. ");
INSERT INTO crnNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Casiꞌi múꞌeen, ¿ni seri nain tíꞌiseij tɨ huáꞌuu iiyecuí? Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna. Aꞌájna xɨcájraꞌa mej jetzen nain huatéꞌuuna ɨ́ chiꞌij tɨ yé curéꞌevee, capu chéꞌe seíireꞌe aꞌame jaxuꞌu jetze tetej tɨ ru japua ticaíjme. Nain mú huatéꞌuuna temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Aj mú mi aꞌucɨ́j. Aꞌuu mú aꞌaráꞌa jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Aꞌuu pu aꞌutacaíca aꞌɨ́jna ɨ́ Jesús. Matɨ́ꞌɨj mi á eꞌiréꞌene jemin aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe mej mi tiuꞌutaꞌíhuaꞌu avíitzi jɨmeꞌe. Miyen tɨjɨ́n: ―Patáꞌaj taatáꞌixaateꞌen jaꞌanáj tɨ ayén tíꞌirɨni. ¿Tiꞌitáani aꞌij tíꞌiseijreꞌe aꞌame tɨ́ꞌɨj tejaꞌuréꞌenen aꞌájna xɨcájraꞌa pej jetzen pajtáhuaꞌa áveꞌecánesin, ajta tɨ́ꞌɨj aꞌájna pɨ́ tíꞌirɨjca tɨ teꞌentipuáꞌari nain ɨ́ tɨ tíꞌiseijreꞌe íiyen chaanaca japua? ");
INSERT INTO crnNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen, tɨ ij caí jaꞌatɨ́ amuaacuanamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muꞌiitɨ́ mú hui huataseíjreꞌesin neniúucajtzeꞌe, miyen tɨjɨ́n: “Nee nu neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu, tɨ Dios á neꞌujyeíjtza ɨ́ ɨpuari japua.” Ayee mú huaꞌutémuaꞌitɨ́ muáꞌajuꞌun jeíhua teɨte huaꞌitzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","’Seajta siyen tíꞌinamuajran mej nuꞌu meri tinéꞌuseꞌesin á jáꞌahuaꞌa naꞌari mej nuꞌu meri tɨ́muaꞌa autéhuijsin mej tinéꞌuseꞌen. Rɨ́ꞌɨ xuꞌu múꞌeen, sej si caí tíꞌitziɨɨneꞌe, aꞌiné ruxeꞌeveꞌe tɨ ayén tiúꞌurɨni. Mɨ́ ajta, caxɨ́ɨ pu aꞌájna tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌa tɨ jetzen nain teꞌentipuáꞌari. ");
INSERT INTO crnNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","’Seica mú hui teɨtejraꞌa, majtáhuaꞌa seica teɨtejraꞌa, aꞌɨ́ɨ mú naímiꞌi huateújneꞌusiꞌiteꞌesin. Majta ɨ́ mej seica chuéjraꞌa japua aꞌuchéjme, majtáhuaꞌa ɨ́ mej majta seica chuéjraꞌa japua aꞌuchéjme, aꞌɨ́ɨ mú naímiꞌi huateújneꞌusiꞌiteꞌesin. Muꞌiicacɨé mú majta huatatɨéjcu. Ajta huateújcaꞌatzɨjxɨꞌɨsin ɨ́ chuej muꞌiicacié íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ taꞌamuájca ɨ́ mej jɨ́n rajpuaíitzi muáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Aj mú mi miyen amuaavíviꞌiran seica jemi mej mi meꞌɨ́n aꞌij puaꞌa amuáaruuren, majta mej mi amuaacuiꞌini. Matɨ́j menaꞌa mej aꞌuchéjme íiyen chaanaca japua, aꞌɨ́ɨ mú amuajchaꞌɨ́ɨreꞌe muáꞌajuꞌun meꞌɨ́jna jɨmeꞌe sej múꞌeen naꞌaráꞌastijreꞌe ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","’Aꞌájna xɨcájraꞌa jetze, muꞌiitɨ́ mú mé nejaúujɨsin, majta seica maujtzeɨ́raꞌamuaꞌa muáꞌajuꞌun seɨj ajta seɨj. Majta tiúꞌujchaꞌɨ́ɨreꞌe muáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Majta muꞌiitɨ́ mú huataseíjreꞌesin aꞌɨ́ɨme ɨ́ mej tíꞌihuaꞌitaca meꞌɨ́jna jɨmeꞌe mej nuꞌu Dios jetze meꞌecan tíꞌixaxaꞌa. Mehuáꞌacuanamuan jeíhua ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aꞌiné muꞌuri jaítzeꞌe aꞌij puaꞌa rɨcɨ ɨ́ teɨte, camu chéꞌe ruꞌihuaamuaꞌa temuaꞌa naa mú muáꞌajuꞌun. Muꞌiitɨ́ mú muárɨꞌerista muáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","’Mɨ́ ajta, Dios pu japuan niuuni aꞌɨ́jna tɨ ayén téꞌeviicuaꞌi ajta naꞌa caí huámɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ajta, ayée pu amuacaí ruxeꞌeveꞌe sej si aꞌucɨ́jxɨꞌɨn nainjapua seɨ́j chuéjraꞌa japua sej si huaꞌutáꞌixaateꞌen ɨ́ teɨte ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ nainjapua tíꞌaijta. Aj pu xaa teꞌentipuáꞌari nain. ");
INSERT INTO crnNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ayee pu ajmíꞌi raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Daniel teecan mej nuꞌu tiꞌitɨ́j huatéchajtza aꞌu tɨ Dios huateúraꞌate nain. Aꞌii pu nuꞌu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ tiꞌitɨ́j tɨ aꞌij puaꞌa ꞌeen, tɨ xánaꞌaviꞌireꞌe, tɨ tziɨ́ɨniꞌireꞌe. Ajta aꞌɨ́jna tɨ ráꞌajijveꞌe, chéꞌe aꞌɨ́ɨn yaúꞌitɨée áꞌaraꞌani aꞌɨ́jna. ’Setɨ́ꞌɨj raaseíj, ayée xu huárɨni múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Meꞌɨ́ɨn ɨ́ mej Judea aꞌuchéjme, michéꞌe aꞌucɨ́jxɨꞌɨn caꞌanacan aꞌu tɨ áꞌujɨ́rime. ");
INSERT INTO crnNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ajta, aꞌájna xɨcájraꞌa jetze, tɨ puaꞌa jaꞌatɨ́ án áꞌujcatii ɨ́ ruchiꞌi japua taꞌavéꞌenamiꞌi, chéꞌe aꞌɨ́ɨn caꞌanacan acájraꞌani. Chéꞌe caí tiꞌitɨ́j huiiráꞌan ɨ́ ruchiꞌitá, sino chéꞌe áꞌuraꞌani caꞌanacan. ");
INSERT INTO crnNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Naꞌari tɨ puaꞌa jaꞌatɨ́ tejéꞌemuarɨꞌe u ruvíꞌiraꞌataꞌa, chéꞌe caí aꞌuréꞌenineꞌicaꞌan ɨ́ ruche tɨ ij rucɨɨxu huiráapin, sino chéꞌe áꞌuraꞌani caꞌanacan. ");
INSERT INTO crnNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","’Cuiꞌi xaa neꞌu, jéꞌecan mú rajpuaíitzi muáꞌajuꞌun aꞌájna xɨcájraꞌa jetze ɨ́ uuca mej aꞌutájucájme, majta aꞌɨ́ɨme ɨ́ mej huáꞌatziꞌitéjmee ɨ́ ruyaujmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Setáꞌaj siyen tiraatáhuavii ɨ́ Dios jemi tɨ ij caí ayén ruxeꞌeveꞌe sej aꞌucɨ́jxɨꞌɨn tɨ́ꞌɨj huáseeviꞌin, naꞌari aꞌájna xɨcájraꞌa mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","’Aꞌájna xɨcájraꞌa jetze, jaítzeꞌe mú rajpuaíitzi muáꞌajuꞌun mej caí jaꞌanáj miyen tirajpuaíjtzicaꞌa tɨ́j naꞌa tɨ Dios raatétaahuacaꞌa ɨ́ chaanaca. Capu ajta chéꞌe huáꞌacɨꞌɨti ɨ́ puaíjtzi aꞌij tɨ tihuáꞌacɨꞌɨti aꞌájna xɨcájraꞌa jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","’Ajta, tɨ puaꞌa aꞌɨ́ɨn tavástaraꞌa ɨ́ Dios caí ayén ráaruuréncheꞌe tɨ ij caí chéꞌe ayén iraꞌatéeviꞌi tɨ teuuméꞌen aꞌachú puaꞌan xɨca, capu jaꞌatɨ́ ruuri áꞌameꞌencheꞌe. Mɨ́ ajta, huáꞌa jɨmeꞌe ɨ́ teɨte tɨ Dios ari huaꞌuréꞌeseɨreꞌe ɨ́ jéjcua, aꞌɨ́ɨ pu xaa ari ayén ráaruurée tɨ́ꞌij caí chéꞌe ayén iráꞌateeviꞌin. ");
INSERT INTO crnNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Seajta múꞌeen, caxu siyen ráꞌatzaahuateꞌe tɨ puaꞌa jaꞌatɨ́ ayén tejámuaatáꞌixaateꞌen aꞌájna xɨcájraꞌa jetze tɨjɨ́n: “Casiꞌi, íiye pu jáꞌitaꞌa éꞌen aꞌɨ́jna ɨ́ Cɨríistuꞌu.” Caxu seajta ráꞌatzaahuateꞌe tɨ puaꞌa seɨ́j ayén tíꞌixajta yee: “Meꞌecui, amée pu jáꞌitaꞌa éꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","’Muꞌiitɨ́ mú hui huataseíjreꞌesin aꞌɨ́ɨme ɨ́ mej nuꞌu iꞌi Cɨríistuꞌu, majta aꞌɨ́ɨme ɨ́ mej nuꞌu Dios jetze meꞌecan tíꞌixaxaꞌa. Mɨ́ majta, camu. Metíꞌihuaꞌitaca muꞌu. Ayee mú meꞌɨ́jna jɨ́n aꞌij mej tiraayɨ́ꞌɨtɨ mej mi seica aꞌij teꞌutaseíj ɨ́ teɨte. Ayee mú majta tiuꞌutaseíjrata tɨ júteꞌe éꞌemeꞌecan Dios jemi aꞌij mej yeꞌí rɨcɨ. Ayee pu naa seíireꞌe aꞌame mej mi huaꞌutémuaꞌitɨ huaꞌitzi jɨmeꞌe aꞌɨ́mej ɨ́ tɨ Dios huaꞌuréꞌeseɨj, tɨ puaꞌa ayén tíꞌirɨꞌɨristan mej huaꞌutémuaꞌitɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","’Casiꞌi múꞌeen, nuꞌuri amuacaí amuáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Aꞌɨ́j pu jɨ́n, caxu siyen ráꞌatzaahuateꞌe tɨ puaꞌa jaꞌatɨ́ ayén tejámuaatáꞌixaateꞌen tɨ jɨ́meꞌen yee: “Amée pu nuꞌu áꞌuyeꞌi ꞌɨtzitá aꞌu tɨ caí méꞌe jaꞌatɨ”, naꞌari ayén yee: “Iiyu pu huiirájca avíitzi jɨmeꞌe yú chiꞌita.” ");
INSERT INTO crnNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","’Mɨ́ ajta, ayée pu téꞌeme aꞌájna xɨcájraꞌa nej jetzen neajtahuaꞌa yé veꞌecáanen i nej neajta teáataꞌa jetze airáane. Ayee nu jéjreꞌecɨtzeꞌe seíireꞌe naꞌame tɨ́j mej témaxcavaꞌaraꞌan. Amuacaí pu u eꞌijnéeriꞌicɨ́ aꞌame aꞌu tɨ ꞌeíjninei ɨ́ xɨca, ajta áꞌiyen ayén cheꞌatá naꞌa huanéeriꞌicɨ́ aꞌame aꞌu tɨ eꞌeteáruꞌipi. ");
INSERT INTO crnNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ajta ayée pu cheꞌatá naꞌa téꞌeme tɨ́j tiꞌitɨ́j tɨ huamɨ́ꞌɨ. Tɨ́ꞌɨj tiꞌitɨ́j huámɨꞌɨni, aj mú curéꞌecɨjxɨꞌɨsin aꞌɨ́ɨme ɨ́ muáꞌaraꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Jɨ́meꞌen puꞌu teꞌentipuáꞌari nain ɨ́ mej jɨ́n rajpuaíitzi muáꞌajuꞌun aꞌájna xɨcájraꞌa jetze, aj pu xaa ayén seíireꞌe aꞌame u júteꞌe tɨ jɨ́meꞌen yee: Anaaruti ɨ́ xɨca, capu huanéeriꞌicɨ́ aꞌame ɨ́ máxcɨraꞌi jɨmeꞌe. Majta meꞌɨ́n ɨ́ xuꞌuraꞌave, aꞌɨ́ɨ mú u eꞌecávatzɨjxɨꞌɨsin u júteꞌe. Muaateúvivájraꞌasin aꞌɨ́ɨme ɨ́ mej tíꞌaijta ɨ́ mej majta éꞌeseijreꞌe u ta japua, matɨ́j menaꞌa puaꞌamé. ");
INSERT INTO crnNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","’Aꞌájna xɨcájraꞌa jetze, aꞌɨ́j pu huataseíjreꞌesin u júteꞌe ɨ́ mej jɨ́n ramuaꞌaréeren tɨjɨ́n nee nu neajtahuaꞌa yé veꞌecánejsin inee, i nej neajta teáataꞌa jetze airáane. ’Majta meꞌɨ́n ɨ́ teɨtejraꞌa mej íiyen seijreꞌe chaanaca japua, matɨ́j menaꞌa puaꞌamé huataújxɨeemɨsteꞌesin naímiꞌi ɨ́ ru jetze. Ayee mú tiꞌineseíira muáꞌajuꞌun netɨ́ꞌɨj aveꞌecáanen ɨ́ jaitɨri jetze. Ayee pu seíireꞌe aꞌame temuaꞌa naa mej mi miyen huateújtzaahuateꞌen. Aj mú xaa ramuaꞌaréeren ɨ́ nej nain jɨ́n antínmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Neajta nu teꞌucácɨꞌɨsiteꞌesin caꞌanín jɨmeꞌe, neajta huaꞌutaꞌaíjteꞌesin aꞌɨ́mej ɨ́ mej nevaɨreꞌe u ta japua mej aꞌucɨ́jxɨꞌɨn nainjapua ɨ́ chaanaca mej mi huaꞌuréꞌeseɨreꞌen aꞌɨ́mej ɨ́ nej neri huaꞌavéꞌehuau. Aꞌu tɨ jaꞌuꞌástɨmee ɨ́ chaanaca, aꞌúu mú huaúuviꞌitɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Setáꞌaj siyen yaúꞌitɨée xáꞌaraꞌani seꞌɨ́jna jɨmeꞌe aꞌij tɨ yeꞌí rɨ́ɨj áꞌayeꞌi aꞌɨ́jna ɨ́ huaréj. Tɨ́ꞌɨj antineájxɨꞌɨn tɨ cuaꞌati aꞌɨ́jna ɨ́ cɨ́yeꞌaraꞌan jetze, tɨ puaꞌa ajta ari huataxútaꞌan, aj xu si siyen ramuaꞌaréeren tɨ ari vejliꞌi ɨ́ víitaꞌari. ");
INSERT INTO crnNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aꞌiné ayée xu ramuaꞌaree jaꞌanáj tɨ puaꞌa pɨ́tíꞌirɨcɨ seꞌɨ́jna jɨmeꞌe ɨ́ sej rasiseꞌi, ayée xu cheꞌatá senaꞌa tiráamuaꞌaree tɨ ari vejliꞌi jaꞌanáj tɨ jetzen antipuáꞌari nain seꞌɨ́jna jɨmeꞌe sej raseijran nain aꞌij nej neri tejámuaatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, majta mauj ruuri naímiꞌi ɨ́ teɨte ɨ́ mej íiyen seijreꞌe íjii, nain pu xaa araúrastejsin. ");
INSERT INTO crnNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ayej xaa tiꞌayajna, aꞌɨ́ɨ pu antipuáꞌari naíjmiꞌi tɨ́j naꞌa tiꞌipuaꞌamé tɨ íiyen seijreꞌe chaanaca japua, ajta u ta japua. Ajta aꞌɨ́ɨn ɨ́ niuucari aꞌij nej neri tejamuáꞌixaa, capu jaꞌanáj antipuáꞌari xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Capu jaꞌatɨ́ ramuaꞌaree jaꞌanáj tɨ teꞌentipuáꞌajte naꞌari aꞌatzaj tɨ ayén tíꞌirɨni. Camu ramuaꞌaree aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe u ta japua. Canu neajta ramuaꞌaree inee sino, aꞌɨ́ɨ pu xaa ramuaꞌaree aꞌɨ́jna ɨ́ nej rájyaꞌupua. ");
INSERT INTO crnNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Aꞌájna xɨcájraꞌa nej jetzen neajtahuaꞌa yé veꞌecánejsin inee, i nej neajta teáataꞌa jetze airáane, ayée pu téꞌeme. Ayee mú cheꞌatá menaꞌa tíꞌijrɨꞌɨrée muáꞌajuꞌun ɨ́ teɨte matɨ́j tíꞌijrɨꞌɨrejcaꞌa aꞌájna tɨ́ꞌɨj auj ruurica aꞌɨ́jna ɨ́ Noé teecan. ");
INSERT INTO crnNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ayee mú rɨjcaa, tɨ́ꞌɨj caí xɨ antipuáꞌarecaꞌa ɨ́ chaanaca jaj jɨmeꞌe, metíꞌicuaꞌacareꞌe ɨ́ teɨte, majta yéꞌecareꞌe. Aꞌɨ́ɨ mú néjneꞌɨche, majta viɨcheꞌecareꞌe. Maúcheꞌe mú miyen rɨjcaa ajta caí aꞌɨ́ɨn Noé ateájraa ɨ́ baarcu jetze tɨ veꞌée. ");
INSERT INTO crnNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Majta meꞌɨ́n ɨ́ teɨte, camu aꞌatzu ramuaꞌareerecaꞌa aꞌij tɨ tiꞌitɨ rɨníicheꞌen. Aj mú xaa ráamuaꞌareeriꞌi tɨ́ꞌɨj huatámɨꞌɨyecaꞌa. Huajaꞌujaújte naíjmiꞌica ɨ́ teɨte. Ayee pu cheꞌatá naꞌa tihuáꞌaruuren aꞌájna xɨcájraꞌa nej jetzen yé veꞌecánejsin, i nej teáataꞌa jetze airáane. ");
INSERT INTO crnNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","’Aꞌájna aꞌúu mú huatéꞌuu muáꞌajuꞌun víꞌiraꞌataꞌa, mé huaꞌapua ɨ́ teteca. Seɨ́j pu áꞌaviꞌitɨchiꞌihuan tɨ́ꞌij teꞌentipuáꞌare. Ajta ɨ́ seɨ́j, aꞌúu pu aꞌuteáturaasin. ");
INSERT INTO crnNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Majta meꞌɨ́n ɨ́ ꞌuuca, aꞌúu mú aꞌutéꞌuu muáꞌajuꞌun, mé huaꞌapua. Metéꞌatɨꞌɨxɨ́j mú muáꞌajuꞌun. Seɨ́j pu ajta áꞌaviꞌitɨchiꞌihuan tɨ́ꞌij teꞌentipuáꞌare, ajta ɨ́ seɨ́j, aꞌúu pu aꞌuteáturaasin. ");
INSERT INTO crnNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Aꞌɨ́j pu jɨ́n, ayée nu tejáꞌamuaꞌixaateꞌe, setáꞌaj atanéjneꞌere temuaꞌa naa, aꞌiné caxu ramuaꞌaree jaꞌanáj tɨ xɨcájraꞌa jetze uvéꞌenejsin ɨ́ áꞌamuavastaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","’Setáꞌaj siyen yaúꞌitɨée xáꞌaraꞌani seꞌíjna. Aꞌɨ́jna jɨmeꞌe ɨ́ jaꞌatɨ tɨ huatéechiꞌi, tɨ puaꞌa aꞌɨ́ɨn ramuaꞌareere aꞌatzaj tɨ puaꞌa ɨ́ tɨ́caꞌari tzajtaꞌa aꞌuteáruti aꞌɨ́jna ɨ́ nahuaꞌari, ayée pu rɨni aꞌɨ́jna tɨ huatéechiꞌi. Aꞌɨ́ɨ pu atanéeri aꞌame, ajta capu raatáꞌasin tɨ aꞌɨ́ɨn nahuaꞌari raꞌantánaꞌaca ɨ́ puéerta, tɨ́ꞌij uteárute u chiꞌita. ");
INSERT INTO crnNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ayee pu hui cheꞌatá naꞌa ruxeꞌeveꞌe sej siyen atanéjneꞌeri aꞌiné inee, i nej neajta teáataꞌa jetze airáane, ayée nu uvéꞌenejsin aꞌatzaj sej caí puaꞌa nechuꞌeveꞌe múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌihuaꞌuran. ¿Aꞌataani téviraꞌa ayén caí jaꞌanáj áꞌɨtzee, tɨ ajta rɨ́ꞌɨ mé teuúmuaꞌaree tɨ puaꞌa aꞌɨ́ɨn vástareꞌaraꞌan ayén tiraaꞌíjcateꞌen aꞌɨ́jna jɨmeꞌe tɨ tihuáꞌaijteꞌe ɨ́ seica ɨ́ mej tíꞌijvaɨreꞌe tɨ ij aꞌɨ́ɨn tihuaꞌumín aꞌatzaj tɨ puaꞌa ari huaxɨ́ꞌepɨꞌɨntariꞌihuacaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ajta aꞌɨ́jna ɨ́ tevi, naa pu tiraatévaɨreꞌesin tɨ puaꞌa ayén rɨjca aꞌij tɨ tiraataꞌaíj tɨ́ꞌɨj ajtahuaꞌa uvéꞌenen aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","’Ayee nu tejáꞌamuaꞌixaateꞌe, tzáahuatiꞌiraꞌa jɨmeꞌe tɨ puaꞌa auj ayén rɨjca tɨ́ꞌɨj uvéꞌenen ɨ́ vástareꞌaraꞌan, aꞌɨ́ɨ pu xaa ayén tíꞌiraꞌíjcateꞌen nain jɨmeꞌe aꞌachú tɨ caj tíꞌijchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","’Mɨ́ ajta, tɨ puaꞌa aꞌij puaꞌa tíꞌitevistan aꞌɨ́jna ɨ́ jaꞌatɨ, ayée pu rɨni. Ayee pu tíꞌimuaꞌatze ɨ́ ru tzajtaꞌa tɨjɨ́n: “Jéꞌecan pu áꞌateeri mé jáꞌahuaꞌa ɨ́ nevástaraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aj pu i autéchesin tɨ aꞌij puaꞌa tihuaꞌutéꞌaxɨꞌɨn ɨ́ ruxɨ́ꞌej teɨte ɨ́ mej tíꞌijvaɨreꞌe. Ajta huáꞌa jamuan tíꞌicuaꞌani, ajta yeꞌen aꞌɨ́mej jamuan ɨ́ mej rutáꞌaruaijveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","’Ajta aꞌɨ́ɨn vástareꞌaraꞌan uvéꞌenejsin aꞌájna xɨcájraꞌa tɨ jetzen caí rachúꞌeveꞌe aꞌɨ́jna tɨ tíꞌijvaɨreꞌe, ajta aꞌatzaj tɨ puaꞌa caí ramuaꞌaree tɨ ari uvéꞌene. ");
INSERT INTO crnNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Aj pu i vástareꞌaraꞌan jeíhua puaíjtzi raatáꞌasin. Ajta raataꞌaíjteꞌesin tɨ aꞌuun aꞌutéveeca aꞌu mej aꞌuteáturaasin aꞌɨ́ɨme ɨ́ mej caí tzáahuatiꞌiraꞌa jɨ́n miyen tíꞌijrɨꞌɨre. Jéꞌecan pu ruyeinixɨꞌɨn aꞌujna, ajta rutamej pu jɨ́n ancuréꞌujcɨꞌɨmée aꞌame aꞌɨ́jna jɨmeꞌe tɨ rajpuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Aꞌájna xɨcájraꞌa jetze, ayée pu Dios huaꞌutáꞌasin ɨ́ teɨte mej mi meꞌuun aꞌuteárute aꞌu tɨ aꞌɨ́ɨn éꞌeseijreꞌe u ta japua. Ayee pu cheꞌatá naꞌa tihuáꞌaruuren aꞌij tɨ tihuáꞌuruu ɨ́ teemua mé ꞌuuca, tamuáamuataꞌa mej nuꞌu aráꞌasecaꞌa. Aꞌɨ́ɨ mú tejáꞌutɨɨ ɨ́ tiúꞌujlaampara mej mi meꞌuun raꞌantinájche aꞌɨ́jna tɨ huaténeɨchi. ");
INSERT INTO crnNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Camu rɨ́ꞌɨ mé titeumuámuaꞌareꞌecaꞌa seica, ɨ́ mej anxɨ́vi. Majta meꞌɨ́n ɨ́ seica, ɨ́ mej majta anxɨ́vi, aꞌɨ́ɨ mú nuꞌu xaa rɨ́ꞌɨ mé titeumuámuaꞌareꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Majta meꞌɨ́n ɨ́ mej caí rɨ́ꞌɨ mé titeumuámuaꞌareꞌecaꞌa, aꞌɨ́ɨ mú tejáꞌutɨɨ ɨ́ tiúꞌujlaampara. Aru camu yaꞌujáj meꞌɨ́jna ɨ́ aceite ɨ́ mej jɨ́n ráꞌajtaira. ");
INSERT INTO crnNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","’Majta meꞌɨ́n ɨ́ mej rɨ́ꞌɨ mé titeumuámuaꞌareꞌecaꞌa, aꞌɨ́ɨ mú xaa limeeta tzajtaꞌa ruꞌucájtuaa ɨ́ aceite. Aꞌɨ́j mú aꞌujáj, jamuan ɨ́ tiúꞌujlaampara. ");
INSERT INTO crnNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Aꞌiné jeíhua pu nuꞌu éꞌetee aꞌɨ́jna tɨ huaténeɨchi, temuaꞌa pu cutzi tihuaꞌumuáꞌitɨ aꞌɨ́mej ɨ́ teemua. Muaatácuꞌutzucaꞌa micu. ");
INSERT INTO crnNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","’Puꞌuri nuꞌu teuuméꞌeca aꞌatzaj jáꞌitaꞌa tɨ́caꞌa, tɨ́ꞌɨj seɨ́j ayén huajíjhuacaꞌa tɨjɨ́n: “Puꞌuri yé véꞌeme aꞌɨ́jna tɨ huaténeɨchi. Xuꞌirácɨɨnichi sej si raꞌantinájche.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Matɨ́ꞌɨj mi huajɨ́jxɨcaꞌa aꞌɨ́ɨme ɨ́ teemua. Áꞌiyen mú rɨ́ꞌɨ tiúꞌuruu ɨ́ tiúꞌujlaampara. ");
INSERT INTO crnNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","’Aj mú mi aꞌɨ́ɨme ɨ́ mej caí rɨ́ꞌɨ huaújruu, ayée mú tihuaꞌutajé ɨ́ seica tɨjɨ́n: “Aisí, cɨ́j caj setitaatáꞌa ɨ́ aceite aꞌiné puꞌuri huitáxɨꞌɨsin téjmi ɨ́ taꞌáa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","’Majta meꞌɨ́n ɨ́ mej rɨ́ꞌɨ mé titeumuámuaꞌareꞌecaꞌa, ayée mú tihuaꞌutáꞌixaa tɨjɨ́n: “Catu xaa neꞌu, aꞌiné ayej neꞌase capu cɨꞌɨti tɨ́j naꞌa itejmi. Capu ajta cɨꞌɨpe tɨ́j naꞌa múꞌejmi. Mɨ́ seajta múꞌeen, setáꞌaj áꞌucɨɨne huáꞌa jemi ɨ́ mej aceite tuꞌaraca sej si ráananan tɨ́j naꞌa múꞌejmi.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","’Aj mú mi miyen huarɨ́j. U mú nuꞌu mi áꞌujuꞌun. Maúcheꞌe mú huajúꞌucaa, tɨ́ꞌɨj aꞌɨ́ɨn aꞌaráꞌa aꞌɨ́jna tɨ huaténeɨchi. Majta meꞌɨ́n ɨ́ teemua ɨ́ mej rɨ́ꞌɨ huaújruu, aꞌɨ́ɨ mú aꞌucɨ́j jamuan aꞌu mej tejéꞌeyeste meꞌɨ́jna jɨmeꞌe tɨ huaténeɨchi. Aj pu i teꞌiteánamiꞌihuacaꞌa ɨ́ puéerta jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","’Aꞌatzu nuꞌu áꞌateeviꞌica, majta ɨ́ seica aꞌaráꞌa ɨ́ teemua. Aj mú mi miyen tiraatáꞌixaa tɨjɨ́n: “Tavastaraꞌa, múꞌee ɨ́ pej iꞌi tavástaraꞌa, titaꞌantácuuneꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: “Ayee nu tejáꞌamuaꞌixaateꞌe, ayej tiꞌayajna. Canu aꞌatzu áꞌamuamuajte.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj siyen atanéjneꞌeri aꞌiné caxu ramuaꞌaree jaꞌanáj tɨ xɨcájraꞌa jetze nej inee uvéꞌenejsin. ");
INSERT INTO crnNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ajta, ayée pu cheꞌatá naꞌa Dios huáꞌaruuren aꞌájna xɨcájraꞌa jetze tɨ́j ɨ́ jaꞌatɨ ayén tihuáꞌuruu ɨ́ mej tíꞌivaɨreꞌecaꞌa. Tɨ́ꞌɨj nuꞌu ari aꞌuyeꞌimɨ́ɨca mé jáꞌahuaꞌa yee, amuacaí pu huaꞌutajé aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌecaꞌa. Tihuaꞌuꞌíjca aꞌɨ́jna jɨmeꞌe ɨ́ tɨ aꞌɨ́ɨn tíꞌijchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Ayee pu tiraatáꞌa seɨ́j aꞌachú cumu anxɨ́j viꞌiraꞌa ɨ́ tumin. Ajta ɨ́ seɨ́j, ayée pu tiraatáꞌa aꞌachú cumu huaꞌapua viꞌiraꞌa. Ajtahuaꞌa ɨ́ seɨ́j, seɨ́j viꞌiraꞌa pu tiraatáꞌa. Ayee pu tihuaꞌutáꞌa aꞌij mé tiraayɨ́ꞌɨtɨ. Tɨꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","’Ajta nuꞌu aꞌɨ́ɨn tɨ anxɨ́j viꞌiraꞌa ancuréꞌa, aꞌɨ́ɨ pu aꞌutéjche tɨ tiuꞌumuárɨꞌen tumin jɨmeꞌe. Ajta áꞌiyen, raamuáꞌitɨ anxɨ́j viꞌiraꞌa aꞌɨ́jna jɨmeꞌe tɨ ajmíꞌi raꞌancuréꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ayee pu cheꞌatá naꞌa huarɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ raꞌancuréꞌa aꞌachú cumu huaꞌapua viꞌiraꞌa. Raamuáꞌitɨ huaꞌapua viꞌiraꞌa, icu. ");
INSERT INTO crnNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","’Ajta nuꞌu aꞌɨ́ɨn tɨ raꞌancuréꞌa aꞌɨ́jna ɨ́ seɨ́j viꞌiraꞌa, capu tiraamuárɨꞌiste. Aꞌáa pu jáꞌahuaꞌa aꞌaráꞌa. Raꞌateíchajraa á chuaataꞌa. Aꞌuu pu raꞌaváꞌana ɨ́ tumin tɨ raatániɨjte ɨ́ ɨ́ tɨ tihuáꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Puꞌuri nuꞌu áꞌateeviꞌicaꞌa, ajta aꞌɨ́ɨn ɨ́ tɨ tihuáꞌaijteꞌe, uvéꞌene. Ajta aꞌutéjche tɨ raaxɨ́ꞌepɨꞌɨntareꞌen ɨ́ tumin jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","’Ajta aꞌɨ́ɨn tɨ anxɨ́j viꞌiraꞌa ancuréꞌa, aꞌɨ́ɨ pu ajta aꞌaráꞌa ɨ́ seica ɨ́ anxɨ́j viꞌiraꞌa. Ayee pu tiraatáꞌixaa tɨjɨ́n: “Nevástaraꞌa. Ayee pepuꞌu caj tinaatáꞌa anxɨ́j viꞌiraꞌa jɨmeꞌe. Casiꞌi, aꞌij nu jɨ́n raamuáꞌitɨ seica tɨ ayén cheꞌatá naꞌa teꞌaráꞌase anxɨ́j viꞌiraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","’Ayee pu tiraatáꞌixaa aꞌɨ́jna ɨ́ vástareꞌaraꞌan tɨjɨ́n: “Xɨ́ꞌepɨꞌɨn pej huarɨ́j, múꞌee ɨ́ pej caí jaꞌanáj áꞌɨtze. Rɨ́ꞌɨ pej tíꞌitevij. Aꞌɨ́j pej jɨ́n teꞌaráꞌaste. Aꞌɨ́j nu jɨ́n niyen tíꞌimuaꞌijcateꞌen jeíhua jɨmeꞌe, íiye ineetzi jemi tetáꞌaj huátatemuaꞌaveꞌen naímiꞌi.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","’Ajta aꞌɨ́ɨn tɨ huaꞌapua viꞌiraꞌa ancuréꞌa, aꞌɨ́ɨ pu ajta yé raꞌáa. Ayee pu ajta tiraatáꞌixaa tɨjɨ́n: “Nevástaraꞌa, múꞌee pej piyen tinaaꞌíjca peꞌɨ́jna jɨmeꞌe huaꞌapua viꞌiraꞌa ɨ́ tumin. Casiꞌi, aꞌij nu jɨ́n raamuáꞌitɨ seica tɨ ayén cheꞌatá naꞌa teꞌaráꞌase huaꞌapua viꞌiraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","’Ajta aꞌɨ́ɨn ɨ́ vástareꞌaraꞌan, ayée pu tiraatáꞌixaa tɨjɨ́n: “Xɨ́ꞌepɨꞌɨn pej huarɨ́j, múꞌee ɨ́ pej caí jaꞌanáj áꞌɨtzee. Rɨ́ꞌɨ pej tíꞌitevij. Aꞌɨ́j pej jɨ́n raꞌaráꞌaste. Aꞌɨ́j nu jɨ́n niyen tíꞌimuaꞌijcateꞌen jeíhua jɨmeꞌe, íiye ineetzi jemi tetáꞌaj huátatemuaꞌaveꞌen naímiꞌi.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","’Ajta nuꞌu aꞌɨ́ɨn tɨ seɨ́j viꞌiraꞌa ancuréꞌa, aꞌɨ́ɨ pu ajta yé raꞌáa. Ayee pu tiraatáꞌixaa tɨjɨ́n: “Nevástaraꞌa. Nee nu niyen ráamuaꞌareeriꞌi pej piyen téꞌejaaxɨejveꞌe. Ayee pej tihuáꞌaijteꞌe mɨ seica mej mi tiuꞌuhuásteꞌen, matáꞌaj tiuꞌutzaana. Aru nain pu tíꞌimuacɨꞌɨti múꞌeetzi. Ayee pej tihuauꞌaíjteꞌen mej mi ráahuastɨraꞌani ɨ́ imueꞌeri, matáꞌaj raaréꞌeseɨreꞌen tɨ́ꞌɨj tíꞌicɨɨre. Ajta áꞌiyen nain timuáacɨꞌɨti múꞌeetzi. ");
INSERT INTO crnNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Aꞌɨ́j nu jɨ́n tíꞌitziɨɨneꞌecaꞌa inee. Aj nu jɨ́n neꞌuun á jáꞌahuaꞌa aꞌaráꞌa. Neraꞌateíichejraa. Netɨ́ꞌɨj ni raꞌaváꞌana á chuaataꞌa. Yeꞌecui neꞌu, múꞌeetzi tɨ aꞌaa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","’Ajta aꞌɨ́ɨn vástareꞌaraꞌan, ayée pu tiraatáꞌixaa tɨjɨ́n: “Múꞌee, mɨ pej aꞌij puaꞌa tíꞌitevij, jéꞌecan pej huáꞌɨnaꞌaseꞌe. Capej tiꞌitɨ́j jɨ́n nevaɨreꞌe. Tɨ́ puaꞌa piyen ramuaꞌaree nej niyen tihuaꞌaꞌaíjteꞌen mej mi tiuꞌuhuásteꞌen tɨ i ayén nain tináacɨꞌɨti ineetzi, ¿ni tzaa pajta piyen ramuaꞌareere nej neajta niyen tihuaꞌaꞌaíjteꞌen mej mi raaréꞌeseɨreꞌen tɨ ij ajta nain tináacɨꞌɨti ineetzi? ");
INSERT INTO crnNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tɨ́ puaꞌa piyen tiꞌijmuaꞌaréere, ¿aꞌiné ꞌeen jɨ́n pecaí piyen huarɨ́j pej pi caí peꞌuun yaúutuaa ɨ́ tumin huáꞌa jemi ɨ́ mej tumin tíꞌineꞌɨjte nej ni aꞌatzu raamuáꞌitɨn? Tɨ́ puaꞌa piyen huárɨniicheꞌe, aj nu xaa raꞌancuréꞌaniicheꞌen ɨ́ tɨ neetzi neꞌáa netɨ́ꞌɨj yé uvéꞌenen. Peꞌutéꞌɨtzee huápɨꞌɨ.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","’Aj pu nuꞌu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ seica ɨ́ mej vejliꞌi huatéꞌuu tɨjɨ́n: “Setáꞌaj yeehui ráꞌariꞌi seꞌɨ́jna ɨ́ seɨj viꞌiraꞌa, seajta raatáꞌan seꞌɨ́jna tɨ tamuáamuataꞌa viꞌiraꞌa tíꞌituaave. ");
INSERT INTO crnNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Matɨ́j menaꞌa puaꞌamé ɨ́ mej jeíhua tíꞌijchaꞌɨɨ, jaítzeꞌe pu tihuáꞌacɨꞌɨti. Ayee pu téꞌeme mej miyen tíꞌijchaꞌɨ́ɨ muáꞌaraꞌani nain aꞌachú tɨ caj ruxeꞌeveꞌe. Majta meꞌɨ́n ɨ́ mej caí tiꞌitɨ́j tíchaꞌɨɨ, aꞌɨ́ɨ mú tihuáꞌariꞌira aꞌɨ́mej ɨ́ mej cɨ́j menaꞌa tíꞌijchaꞌɨɨ mej mi caí chéꞌe tíꞌijchaꞌɨ́ɨ muáꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Seajta múꞌeen, setáꞌaj mé yaꞌurájrɨeni seꞌɨ́jna ɨ́ tɨ caí tiꞌitɨ́j vaɨreꞌe mé puaꞌacɨé aꞌu tɨ aꞌutɨ́caꞌa. Aꞌuu pu ruyeinixɨꞌɨn, ajta ancuréꞌujcɨꞌɨxɨjsin aꞌɨ́jna jɨmeꞌe tɨ rajpuaíjtzi.” Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ vástareꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Aꞌájna xɨcájraꞌa nej jetzen yéveꞌecánejsin inee, i nej neajta teáataꞌa jetze airáane, netɨ́ꞌɨjtáhuaꞌa huataseíjreꞌen aꞌɨ́mej jamuan ɨ́ mej tíꞌivaɨreꞌe u ta japua, naa pu seíireꞌe aꞌame mej mi rɨ́ꞌɨ teꞌutaseíj ɨ́ teɨte, temuaꞌa naa. Nee nu huatéyeijxa ɨ́ ɨpuari japua mej mi ráamuaꞌaree ɨ́ nej inee nain jɨ́n antínmuaꞌaree íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","’Matɨ́ꞌɨj mi neetzi jemi huáꞌajseɨreꞌesin naíjmiꞌica ɨ́ teɨtejraꞌa i mej íiyen seijreꞌe ɨ́ chaanaca japua. Neajta inee, ayée nu cheꞌatá nenaꞌa huaꞌapuacɨé huáꞌajseɨreꞌesin tɨ́j ajta jaꞌatɨ́ ayén huaꞌapuacɨé tihuáꞌajseɨ ɨ́ ruyeꞌemua. Aꞌuu pu huáꞌajseɨj ɨ́ cáneꞌaxɨ seɨ́jtaꞌa, ajta aꞌɨ́ɨme ɨ́ caurasi, ajta seɨ́jtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","’Majta meꞌɨ́n ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte, ayée mú ꞌeen matɨ́j ɨ́ cáneꞌaxɨ. Nerɨꞌɨríintaꞌa nu huáꞌajseɨreꞌesin. Majta aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte, ayée mú ꞌeen matɨ́j ɨ́ caurasi. Neꞌúutataꞌa nu huáꞌajseɨreꞌesin neꞌɨ́mej. ");
INSERT INTO crnNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","’Neajta inee, i nej iꞌi Rey, ayée nu tihuaꞌutáꞌixaateꞌesin neꞌɨ́mej ɨ́ mej eꞌejteí nerɨꞌɨríintaꞌa tɨjɨ́n: “Iíyeꞌe xuꞌu ij múꞌeen, mɨ sej rɨ́ꞌɨ tiraatáꞌa ɨ́ niyáꞌupua, setáꞌaj siyen raꞌancuréꞌan ɨ́ tɨ ayén tejáꞌamuacɨꞌɨti, aꞌij tɨ tiúꞌuxɨꞌepɨꞌɨntariꞌihuacaꞌa tɨ́j naꞌa tɨ Dios raatétaahuacaꞌa ɨ́ chaanaca, sej si seꞌuun aꞌuteárute aꞌu tɨ Dios éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ayee pu téꞌeme aꞌiné múꞌeen xu tinaamí netɨ́ꞌɨj huataꞌíꞌicuatacaꞌa. Múꞌeen xu seajta jaj naatáꞌa netɨ́ꞌɨj huataꞌíꞌimɨ. Múꞌeen xu seajta naꞌancuréꞌeviꞌitɨ ɨ́ ruchiꞌitá tɨ́ꞌɨj caí jaꞌatɨ́ nexɨ́ꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ayee xu tinaatéechejte netɨ́ꞌɨj caí tiꞌitéchejcaꞌa. Netɨ́ꞌɨj tijcuíꞌinecaꞌa, múꞌeen xu seajta naatéeseij. Ajta, netɨ́ꞌɨj aiteánamiꞌihuacaꞌa, múꞌeen xu seajta náamuaarecaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","’Majta meꞌɨ́n ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte, ayée mú tinaatáꞌixaateꞌesin tɨjɨ́n: “Tavastaraꞌa, ¿aꞌanajni tiyen timuaamí tetɨ́ꞌɨj muaaseíj ɨ́ pej íꞌicuatacaꞌa? ¿Aꞌanajni tiyen jaj timuaatáꞌa tetɨ́ꞌɨj muaaseíj pej íꞌimɨꞌɨcaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Aꞌanajni tiyen timuaꞌancuréꞌeviꞌitɨ ɨ́ tachiꞌitá iteen tetɨ́ꞌɨj ráamuaꞌareeriꞌi pej caí aꞌij tamuari? Ari iꞌi, ¿aꞌanajni tej tiyen huarɨ́j tej timuaatéechejte patɨ́ꞌɨj caí tiꞌitɨ́j jɨ́n tiꞌitéchejcaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Aꞌanajni tiyen muáamuaarecaꞌa patɨ́ꞌɨj aiteánamiꞌihuacaꞌa naꞌari tej tiyen muaatéeseij patɨ́ꞌɨj tíꞌicuiꞌicaꞌa?” ");
INSERT INTO crnNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","’Neajta inee, i nej iꞌi Rey, ayée nu tihuaꞌutáꞌixaateꞌesin tɨjɨ́n: “Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna, setɨ́j senaꞌa sej siyen huáꞌuruu aꞌɨ́mej ɨ́ neꞌihuaamuaꞌa, ayée xu cheꞌatá senaꞌa náaruu ineetzi. Capu amɨ́n aꞌij tɨ puaꞌa siyen raatévaɨ seɨ́j ɨ́ neꞌihuaaraꞌa tɨ caí tiꞌitɨ́j jɨ́n tiꞌitéjvee, tɨ caí aꞌatzu ruxeꞌeveꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Aj nu ni niyen tihuaꞌutáꞌixaateꞌesin aꞌɨ́mej ɨ́ mej eꞌejteí neꞌúutataꞌa tɨjɨ́n: “Sericu múꞌeen, mɨ tɨ Dios aꞌij puaꞌa tejámuaatáꞌasin. Sej hui ineetzi jemi sej si seꞌuun aꞌuteárute taij tzajtaꞌa tɨ Dios ayén rɨ́ꞌɨ ráaruurijtze aꞌɨ́jna ɨ́ tiyaaruꞌu, majta aꞌɨ́mej ɨ́ mej tíꞌijvaɨreꞌe, aꞌɨ́ɨme ɨ́ xɨéjniuꞌucari ɨ́ mej aꞌij puaꞌa ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sericu múꞌeen, aꞌiné caxu tinaamí netɨ́ꞌɨj huataꞌíꞌicuatacaꞌa. Múꞌeen xu seajta caí jaj naatáꞌa netɨ́ꞌɨj íꞌimɨꞌɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Capu jaꞌatɨ naamuáꞌa. Ayee pu i ꞌeeneꞌe, caxu náꞌanviꞌitɨ á ruchiꞌitá. Canu tiꞌitéchejcaꞌa. Mɨ́ seajta múꞌeen, caxu tinaatéechejte. Netɨ́ꞌɨj tijcuíꞌinecaꞌa, caxu seajta naatéeseij, caxu seajta náamuaarecaꞌa netɨ́ꞌɨj aiteánamiꞌihuacaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","’Aꞌɨ́ɨ mú majta miyen tinaatáꞌixaateꞌesin tɨjɨ́n: “Tavastaraꞌa, ¿aꞌanajni tiyen timuaaseíj pej huataꞌíꞌicuatacaꞌa, nusu pej íꞌimɨꞌɨcaꞌa, naꞌari pej caí jaꞌatɨ́ muaꞌatejcaꞌa, naꞌari pej tíꞌicuiꞌicaꞌa, caꞌɨ́n pej aiteánamiꞌihuacaꞌa, teajta caí muaatévaɨ iteen?” ");
INSERT INTO crnNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","’Aj nu ni niyen tiuꞌutániuusin tɨjɨ́n: “Aꞌiné caxu siyen raatévaɨ seɨ́j ɨ́ neꞌihuaaraꞌa tɨ caí tiꞌitɨ́j jɨ́n tiꞌitéjvee, seɨ́j tɨ caí ruxeꞌeveꞌe, caxu seajta naatévaɨ ineetzi.” ");
INSERT INTO crnNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","’Majta meꞌɨ́n, aꞌúu mú áꞌujuꞌun tɨ ij puaíjtzi huáꞌucɨꞌɨti tɨ́j naꞌa rusén jɨmeꞌe. Majta meꞌɨ́n ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte, aꞌúu mú áꞌujuꞌun aꞌu tɨ Dios éꞌeseijreꞌe mej mi ruuri muáꞌaraꞌani jemin tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tɨ́ꞌɨj Jesús raatapuáꞌajtacaꞌa tɨ nain tiuꞌutaxájtacaꞌa aꞌíjna i niuucari, aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ayen tɨjɨ́n: ―Xuꞌuri ramuaꞌaree tɨ ari vejliꞌi aꞌájna mej tíꞌiyesten meꞌɨ́jna jɨmeꞌe tɨ Dios tihuaꞌutáꞌuuniꞌi. Aꞌatura aúcheꞌe huaꞌapua xɨca. Jaꞌatɨ́ pu ajta tiuꞌutátuiireꞌesin ɨ́ nejɨ́meꞌe i nej neajta teáataꞌa jetze airáane mej mi náꞌutatan cúruu jetze. ―Yee puꞌu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Majta meꞌɨ́n ɨ́ mej tihuáꞌaijteꞌe teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ niuucari jɨmeꞌe tɨ tíꞌaijta, majta ɨ́ huaꞌavaujsi ɨ́ mej Israél jetze ajtémeꞌecan, aꞌúu mú eꞌetiújseɨj u chiꞌiraꞌan jetze aꞌɨ́jna tɨ nain jɨ́n antiújmuaꞌaree u huaꞌatéyujtaꞌa. Ayee pu ántehuaa aꞌɨ́jna tɨjɨ́n Caifás. ");
INSERT INTO crnNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aꞌɨ́ɨ mú tiúꞌujmuaꞌatziiteꞌecaꞌa aꞌij mej yeꞌí huárɨni mej mi huaꞌitzi jɨ́n raatéeviꞌi meꞌɨ́jna ɨ́ Jesús mej mi raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Majta miyen tíꞌiruꞌixaateꞌecaꞌa tɨjɨ́n: ―Catu raatéviꞌira matɨ́ꞌɨj tíꞌiyeste ɨ́ teɨte mej mi caí huataníniuꞌucacu. Tɨ́ puaꞌa tiyen huárɨni, aꞌɨ́ɨ mú taaténeꞌusiꞌiteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ajta aꞌɨ́jna ɨ́ Jesús, aꞌúu pu aꞌutéveecaꞌa u Betania aꞌu tɨ éꞌeche aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Simón. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ mej majta miyen ratamuáꞌamua tɨjɨ́n Tɨ́ Cáꞌatzaj. ");
INSERT INTO crnNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Aj pu i seɨ́j á eꞌiréꞌene jemin aꞌɨ́jna ɨ́ Jesús. ꞌƗ́itaꞌa pu pɨ́rɨcɨ tɨ limeeta huátɨsimeꞌecaꞌa. Tetej limeetajraꞌa pu púꞌeeneꞌe. Naa pu teꞌevéꞌejɨsticaꞌa tɨ naa teáarɨ́ꞌe, tɨ ajta huápɨꞌɨ tíꞌijnajche. Tɨ́ꞌɨj Jesús huatecaíca meesa jetze, aꞌɨ́ɨn ꞌɨ́itaꞌa án pu yéꞌajtuaa án muꞌúutzeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj raaseíj aꞌij tɨ huarɨ́j, jéꞌecan mú huataníniuꞌucacucaꞌa ɨ́ ꞌɨ́itaꞌa jemi. Aj mú mi miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n áꞌuvej amɨ́jna ɨ́ aceite? ");
INSERT INTO crnNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Rɨꞌɨríistacaꞌancheꞌe pu mej ráatuaanijcheꞌen mej mi raamuáꞌitɨncheꞌe jeíhua ɨ́ tumin mej mi huaꞌutáꞌan aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu ráamuaꞌareeriꞌi aꞌij mej yeꞌí tíꞌixajtacaꞌa. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n siyen rájaaxɨejviꞌi seꞌíjna i ꞌɨ́itaꞌa? Aꞌij tɨ náaruu, temuaꞌa pu naa iꞌi xɨ́ꞌepɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́ɨme ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, maúcheꞌe mú múꞌejmi jemi seíireꞌe muáꞌajuꞌun tɨ́j naꞌa rusén jɨmeꞌe. Jaꞌanáj tɨ naꞌa pu i íꞌirɨꞌɨriista aꞌame sej siyen tihuaꞌutévaɨreꞌen. Mɨ́ neajta inee, canu chéꞌe múꞌejmi jemi seíireꞌe naꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","’Ayee puꞌu, tɨ́ꞌɨj aꞌíin ꞌɨ́itaꞌa naꞌavéꞌemeijriꞌi ineetzi, ayée pu ꞌeen jɨ́n ayén náaruu aꞌɨ́jna jɨmeꞌe tɨ naꞌaváꞌanan. ");
INSERT INTO crnNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna, íiyen chaanaca japua, aꞌu tɨ naꞌa mej tihuaꞌutáꞌixaateꞌen ɨ́ teɨte aꞌij tɨ Dios tihuaꞌirájtuaani aꞌɨ́ɨ mú majta huaꞌutáꞌixaateꞌesin aꞌij tɨ huarɨ́j aꞌíjna i ꞌɨ́itaꞌa mej mi jeíhua raꞌutámuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ajta seɨ́j tɨ huáꞌa jetze ajtémeꞌecan ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́jna tɨ ayén ántehuaa tɨjɨ́n Judás Iscariotes, aꞌɨ́ɨ pu ajtáraa huáꞌa jemi. Aꞌuu pu áꞌuraa tɨ ij tiuꞌuxáj huáꞌa jamuan ɨ́ mej tíꞌaijta teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌachúni setíꞌineanajchiteꞌen tɨ puaꞌa nejamuaatátuiireꞌen neꞌɨ́jna ɨ́ Jesús? Maraatéꞌitɨee ɨ́ tumin. Majta raatáꞌa aꞌachú cumu seité japuan tamuáamuataꞌa ɨ́ tumin, rumuaꞌatɨ́ plata. ");
INSERT INTO crnNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ajta iyáꞌuraa aꞌɨ́jna ɨ́ Judás. Tɨ́j naꞌa aꞌájnáꞌɨmua, aꞌɨ́ɨ pu aꞌutéjche tɨ ráahuauni jaꞌanáj tɨ iꞌi xɨ́ꞌepɨꞌɨn tɨ ij huaꞌutátuiireꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna xɨcájraꞌa ɨ́ taꞌamuájca mej jetzen tíꞌiyestehuaꞌa matɨ́ꞌɨj pan cuaꞌacareꞌe tɨ caí cujchiraꞌa, aj mú mi á eꞌiréꞌene ɨ́ Jesús jemi aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné jetze muaꞌaráanajche tej áꞌujuꞌun tej ti rɨ́ꞌɨ tejáꞌuruuren ɨ́ pej ráacuaꞌani ɨ́ pan tej jɨ́n raꞌutámuaꞌaree aꞌájna xɨcájraꞌa tɨ jetzen Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ tayaujmuaꞌa ɨ́ mej anáatéꞌee muaanúnuꞌihuacaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu múꞌeen seꞌájna chajtaꞌa. Aa xu jaꞌatɨ́ éꞌeteuni. Setáꞌaj siyen tiraataꞌixaateꞌen yee: “Yee pu tiꞌixa ɨ́ maestro tɨjɨ́n puꞌuri aꞌájna tejaꞌuréꞌene nej nain jɨ́n raanaíjmireꞌen, neajta nej raꞌutámuaꞌaree aꞌájna xɨcájraꞌa tɨ jetzen Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ tayaujmuaꞌa mej anáatéꞌee muaanúnuꞌihuacaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, ayée mú huarɨ́j aꞌij tɨ Jesús tiuꞌutaꞌaíjtacaꞌa. Nain mú rɨ́ꞌɨ tiúꞌuruu ɨ́ mej tíꞌicuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Tɨ́ꞌɨj huachúmuaꞌancaa, Jesús pu huatecaíca ɨ́ meesa jetze huáꞌa jamuan ɨ́ mej tamuáamuataꞌa japuan huaꞌapua muaꞌaráꞌaxcaa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Muꞌuri tíꞌicuaꞌacáa, tɨ́ꞌɨj ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, seɨ́j tɨ aꞌamua jetze ajtémeꞌecan, aꞌɨ́ɨ pu nejɨ́meꞌe tiuꞌutátuiireꞌesin huáꞌa jemi ɨ́ mej tíꞌaijta teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Aj mú mi huataújxɨeemɨste ɨ́ ru tzajtaꞌa. Maꞌutéjhuii mej raataꞌíhuaꞌu meꞌɨ́jna ɨ́ Jesús, seɨj ajta seɨj. Miyen tɨjɨ́n: ―¿Aꞌataani aꞌɨ́ɨn púꞌeen? ¿Ni qui inee? Ajtahuaꞌa seɨ́j ayén tɨjɨ́n: ―¿Aꞌataani aꞌɨ́ɨn púꞌeen? ¿Ni qui inee? ");
INSERT INTO crnNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Aꞌijna tɨ pan cuaꞌa aꞌíjna jetze i tuxaꞌa nee jamuan, aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ nejɨ́meꞌe tiuꞌutátuiireꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ayee pu tejaꞌuréꞌenejsin ineetzi jemi i nej neajta teáataꞌa jetze airáane aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Mɨ́ ajta, aꞌɨ́jna jemi tɨ nejɨ́meꞌe tiuꞌutátuiireꞌesin, jaítzeꞌe pu raatévaɨreꞌencheꞌe tɨ caí huanúꞌihuancheꞌe aꞌiné rajpuaíitzi pu aꞌame huápɨꞌɨ. Chéꞌe aꞌɨ́ɨn huataújxɨeemɨsteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ajta aꞌɨ́ɨn ɨ́ Judás, ɨ́ tɨ huaꞌutátuiireꞌemɨꞌɨcaꞌa, ayée pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maestru, canu xaa neꞌɨ́n púꞌeen, ¿ni qui necaí? Jesús pu ayén tiraatáꞌixaa tɨjɨ́n: ―Muꞌée pej aseɨ́j piyen tiraataxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Maúcheꞌe mú tíꞌicuaꞌa tɨ́ꞌɨj Jesús pan tiꞌɨ́j. Rɨ́ꞌɨ pu tiraatáꞌa ɨ́ Dios, ajta raꞌantítaaraxɨ. Aj pu i huaꞌuréꞌeꞌɨꞌɨpɨꞌɨ. Ayen tihuáꞌixaateꞌe tɨjɨ́n: ―Xaꞌancuréꞌeꞌɨꞌɨpɨꞌɨ. Xáacuaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen i nehuáꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ajta áꞌiyen, vaasu tijáj. Tɨ́ꞌɨjtaꞌi rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios, aꞌɨ́ɨ pu huaꞌuréꞌiꞌite. Ayen tiꞌixáata tɨjɨ́n: ―Xaꞌantiꞌí, naíjmiꞌi múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Aꞌíjna tɨ urajmuaa, aꞌii pu aꞌɨ́ɨn púꞌeen i nexuureꞌe nej raꞌiráxɨreꞌesin neꞌɨ́jna jɨmeꞌe nej ni raanaíjmireꞌen aꞌɨ́jna tɨ jɨ́n Dios ruseɨ́j ayén teꞌataújratziiriꞌi ɨ́ jéjcua ɨmuá. Aꞌɨ́j nu jɨ́n huáꞌa japua niuuni muꞌiicáca tɨ ij Dios ayén tihuaꞌutáꞌuuniꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","’Ayee nu tejáꞌamuaꞌixaateꞌe. Ayej xaa neꞌu ayén tiꞌayajna, íjii tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame, canu chéꞌe raꞌantíꞌisin neꞌíjna i jáꞌaraꞌa uuva jetze tɨ meꞌecan sino aꞌájna xɨcájraꞌa tɨ Dios jetzen huateúraꞌateꞌesin nainjapua ɨ́ chaanaca. Aj nu xaa aꞌamua jamuan raꞌantíꞌisin neajtahuaꞌa rujéjcuatzeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aj mú mi seɨ́j tiuꞌutáchuiicacaꞌa ɨ́ mej jɨ́n rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Aj mú mi aꞌucɨ́j. Aꞌuu mú aꞌaráꞌa Aceituunajemi, jɨrí tɨ áꞌutaaca. ");
INSERT INTO crnNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ijii, tɨ tɨ́caꞌaren, mé xu núujɨsin. Setiuꞌutatéviꞌiraꞌata neetzi jemi. Ayee pu téꞌeme tɨ́j téꞌeyuꞌusiꞌi tɨ Dios ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: “Nee nu i nej iꞌi Dios, aꞌɨ́j nu jéꞌicatan cáneꞌaxɨ tɨ tiseíj. Majta meꞌɨ́n aꞌucɨ́jxɨꞌɨsin ɨ́ cáneꞌaxɨ.” ");
INSERT INTO crnNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mɨ́ neajta inee, netɨ́ꞌɨj huatarún, áa nu aꞌuméꞌe naꞌame u Galilea. Amuacaí nu aráꞌaiixa, seajta áꞌiyen múꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiuꞌutaniú tɨjɨ́n: ―Capu amɨ́n aꞌij tɨ puaꞌa naíjmiꞌi metiuꞌutatéviꞌiraꞌata mɨ seica múꞌeetzi jemi. Canu jaꞌanáj niyen rɨni inee. ");
INSERT INTO crnNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Aj pu i Jesús ayén tiraatáꞌixaa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe tɨ ayén tiꞌayajna, íjii tɨ́caꞌa, tɨ́ꞌɨj caí xɨ huajíjhuan ɨ́ gallo, huaíca pej piyen tínaꞌavéꞌavaata yee pej núꞌu caí nemuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Mɨ́ ajta aꞌɨ́ɨn Pedro, ayée pu tiraatáꞌixaa caꞌanín jɨmeꞌe tɨjɨ́n: ―Tɨ́ puaꞌa ayén tiúꞌujxeꞌeveꞌe nej á jamuan huámɨꞌɨni, capu amɨ́n aꞌij. Canu jaꞌanáj niyen tímuaꞌavéꞌavaata yee nej caí muamuaꞌate. Majta meꞌɨ́n ɨ́ seica, ayée mú cheꞌatá menaꞌa tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Aj pu i áꞌuraa aꞌɨ́jna ɨ́ Jesús, majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aꞌuu mú aꞌaráꞌa, huastari jemi, cɨyej tɨ eꞌeréꞌevee tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Getsemaní. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Yé xuꞌu titéꞌen múꞌeen, iiyecuí. Neajta inee, mé nuꞌu vejliꞌi aꞌatanéjsin nej ni raatéjhuauni ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aj pu i áꞌuraa. Huajaꞌuvíꞌitɨ aꞌɨ́mej, aꞌɨ́jna ɨ́ Pedro, ajta aꞌɨ́mej ɨ́ mej huaꞌapua, ɨ́ mej yaújmuaꞌameꞌen púꞌeen aꞌɨ́jna ɨ́ Zebedeo. Ajta áꞌiyen aꞌij puaꞌa raatáꞌa ɨ́ ru tzajtaꞌa. Jéꞌecan pu huataújxɨeemɨste. ");
INSERT INTO crnNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Jéꞌecan pu caí núꞌucaꞌanistiꞌi yú ne tzajtaꞌa. Huápɨꞌɨ nu nexɨeemɨsteꞌe. Cu xɨee nej cuj mɨꞌɨni. Yé xu huateáturan múꞌeen íiye. Seucheꞌe xu atanéjneꞌere nee jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aꞌatzu pu aꞌɨmuá ájcaꞌi yee aꞌuréꞌene. Tɨ́ꞌɨj i éꞌejtunutacaꞌa á chuaataꞌa. Aj pu i ayén tirájhuaviiriꞌi ɨ́ Dios tɨjɨ́n: ―Dios pej níꞌiyaꞌupua, naíjmiꞌi pu rɨꞌɨrí múꞌeetzi jemi. Tɨ́ puaꞌa petiꞌitáꞌacareꞌen tɨ caí ayén tíꞌinecɨꞌɨti aꞌíjna tɨ aꞌij puaꞌa ꞌeen, ɨ́ nej jɨ́n rajpuaíitzi naꞌame. Naꞌari caí, chéꞌe caí ayén ꞌeeneꞌen netɨ́j tíꞌijxeꞌeveꞌe inee, sino patɨ́j múꞌee tíꞌijxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aj pu i á eꞌiréꞌene aꞌu mej aꞌutéꞌuucaꞌa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Muꞌuri íꞌicuꞌutzucaꞌa. Tɨ́ꞌɨj huaꞌujɨ́ste, aj pu i ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Pedro tɨjɨ́n: ―¿Ni tzaa pecaí téꞌeviicuaꞌi pej atáneere nee jamuan aꞌachú cumu sei hora? ");
INSERT INTO crnNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Seucheꞌe xu atanéjneꞌere, seajta setáꞌaj raatéjhuauni ɨ́ Dios jemi tɨ́ꞌij caí tejamuáacɨꞌɨti tiꞌitɨ́j ɨ́ sej jɨ́n auteáturan ɨ́ Dios jemi. Ayee nu tejáꞌamuaꞌixaateꞌe. Múꞌeen xu xaa huateújcaꞌanen ɨ́ ru tzajtaꞌa. Mɨ́ ajta caí, capu áꞌamuacaꞌanistiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ajta áꞌuraa. Ajtahuaꞌa ayén tirájhuaviiriꞌi ɨ́ Dios tɨjɨ́n: ―Dios pej níꞌiyaꞌupua, tɨ puaꞌa caí aꞌij tíꞌirɨꞌɨri tɨ i caí ayén tíꞌinecɨꞌɨti aꞌɨ́jna ɨ́ nej jɨ́n rajpuaíitzi naꞌame, chéꞌe ayén ꞌeeneꞌen patɨ́j tíꞌijxeꞌeveꞌe múꞌee. ");
INSERT INTO crnNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tɨ́ꞌɨjtáhuaꞌa á eꞌiréꞌene. Ajtahuaꞌa pu huáꞌuteu, mecuꞌutzúcaꞌa, aꞌiné jeíhua pu huáꞌamuaꞌitɨjcaꞌa ɨ́ cutzi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Aa mú aꞌuteájturaa aꞌɨ́mej ɨ́ mej cuꞌutzucaꞌa. Huaícacajetze pu ajtahuaꞌa u áꞌume ɨ́ Jesús. Ajtahuaꞌa pu raatéjhuau ɨ́ Dios jemi. Ayee pu cheꞌatá naꞌa tirájhuaviiriꞌi aꞌij tɨ amuacaícan tiraatáhuaviiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tɨ́ꞌɨj ajtahuaꞌa á eꞌiréꞌene aꞌu mej aꞌutéꞌuucaꞌa aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Puꞌuri íjii, sej huápɨꞌɨ rucuꞌutziveꞌe. Puꞌuri íjii sej huácuꞌutzu, seajta huaújseꞌupeꞌen. Casiꞌi, puꞌuri aúcheꞌe. Puꞌuri aꞌájna tejaꞌuréꞌene tɨ ij aꞌɨ́ɨn huaꞌutátuiireꞌesin ɨ́ ne jɨ́meꞌen, i nej neajta teáataꞌa jetze airáane mej mi naateeviꞌi aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","’Xáꞌajhuiixɨꞌɨ. Cheꞌeré ticu. Puꞌuri eꞌevéꞌeme aꞌɨ́jna tɨ ne jɨ́meꞌen tiuꞌutátuiireꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Aúcheꞌe pu tíꞌixajtacaꞌa tɨ́ꞌɨj aꞌɨ́ɨn Judás á eꞌiréꞌene. Aꞌɨ́jna ɨ́ Judás, aꞌɨ́ɨ pu huáꞌa jetze ajtémeꞌecan aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua muaꞌaráꞌaxcaa. Jéihua mú teɨte jamuan huajúꞌucaa. Seica mú tiuꞌɨ́ꞌɨsimeꞌe ɨ́ nahuaa tɨ ruxɨ́ꞌejtaꞌa teꞌejcamɨ́ɨmɨjmee, majta seica cɨyej tiuꞌɨ́ɨ ɨ́ mej jɨ́n huáꞌucuiꞌini. Naíjmiꞌica mú huataꞌáijtacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta ɨ́ huáꞌavaujsimuaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ajta aꞌɨ́ɨn tɨ huaꞌutátuii aꞌɨ́jna ɨ́ Jesús, amuacaí pu tiꞌihuaújmuaꞌatzii aꞌij tɨ yeꞌí huárɨni mej mi ráamuaꞌaree jaꞌatɨ́ tɨ aꞌɨ́ɨn púꞌeen ɨ́ Jesús. Ayen tɨjɨ́n: ―Aꞌɨ́jna neꞌu, ɨ́ nej ruꞌitépɨꞌɨtzeꞌesin netɨ́ꞌɨj raatateújteꞌen, aꞌii pu aꞌɨ́ɨn pɨ́rɨcɨ. Setáꞌaj hui raatéeviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jɨ́meꞌen puꞌu aꞌaráꞌa, aj pu i ajteáxɨɨrecaꞌa aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Ayee pu tiraatateújte tɨjɨ́n: ―¿Aꞌiné penaꞌa, Maeestru? Ajta ruꞌitépɨꞌɨtze. ");
INSERT INTO crnNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Aj pu i ayén tiraatáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Neꞌamiigu, ¿ni peꞌɨ́jna jɨ́n piyen yé véꞌeme? ―Yee puꞌu tiraataꞌíhuaꞌuriꞌi. Majta meꞌɨ́n ɨ́ seica, aꞌɨ́ɨ mú ajteáxɨɨrecaꞌa jemin. Matɨ́ꞌɨj mi raatéeviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Matɨ́ꞌɨj raatéeviꞌi, aj pu i seɨ́j tɨ Jesús jamuan áꞌucheꞌecaneꞌe, aꞌɨ́ɨ pu rúꞌijcupi ɨ́ runahuaa tɨ ruxɨ́ꞌejtaꞌa teꞌejcamɨ́ɨmɨjmee. Aj pu i ruꞌitéjtze aꞌɨ́jna ɨ́ tɨ ravaɨreꞌe aꞌɨ́jna tɨ tihuáꞌaijteꞌe u teyujtaꞌa. Tɨꞌɨj jí raꞌajtaveíjchecaꞌa ɨ́ naxairaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ajta Jesús ayén tiraataꞌaíj aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: ―Ucárujteꞌe muaꞌanáhuaa, aꞌiné tɨ puaꞌa piyen ruíjcuta muaꞌanáhuaa, aꞌɨ́ɨ mú majta muaajéꞌicatan nahuaa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ni ayén timuáꞌamitɨejteꞌe múꞌeetzi tɨ ayén ruxeꞌeveꞌe pej piyen huárɨni? ’Casiꞌi, tɨ puaꞌa niyen raatáhuavii ɨ́ tɨ níꞌiyaꞌupua, aꞌɨ́ɨ pu raayɨ́ꞌɨtɨ tɨ huaꞌutaꞌaíjteꞌen aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe u ta japua mej mi aveꞌecanén menaatévaɨreꞌen. Majta meꞌɨ́n, aꞌɨ́ɨ mú miyen aꞌaráꞌaxcan aꞌachú cumu huaícate viꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","’Aru tɨ puaꞌa hui niyen huárɨni, capu chéꞌe huatárɨꞌɨristari tɨ ij ayén araúrasten aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ nuꞌu ayén ruxeꞌeveꞌe mej miyen náaruuren. ");
INSERT INTO crnNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi ɨ́ teɨte tɨjɨ́n: ―¿Ni siyen yé véꞌejuꞌun seꞌɨ́jna jɨmeꞌe ɨ́ nej niyen huaꞌuréꞌeseɨreꞌesin ɨ́ teɨte mej mi huaténeꞌuseꞌen ɨ́ gobierno jemi? ¿Ni seꞌɨ́jna jɨ́n tiuꞌɨ́ꞌɨsin ɨ́ nahuaa tɨ ruxɨ́ꞌejtaꞌa teꞌejcamɨ́ɨmɨjmee, seajta cɨyej tiuꞌɨ́ꞌɨsin sej si naateeviꞌi? ’Nain tújcaꞌari tzajtaꞌa tɨ yú eꞌiréꞌene, aꞌúu nu aꞌutéveecaꞌa teyujtaꞌa. Netejáꞌamuamuaꞌatehuaꞌa nu náꞌayeꞌi. Mɨ́ seajta múꞌeen, caxu jaꞌanáj naateeviꞌi seꞌújna. ¿Aꞌiné ꞌeen jɨ́n siyen rɨcɨ íjii? ");
INSERT INTO crnNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ayee pu nain tiujuꞌuméꞌe aꞌame tɨ i ayén araúrasten aꞌij mej mejmíꞌi tiraꞌuyúꞌuxacaꞌa ɨ́ yuꞌuxari jetze aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Majta meꞌɨ́n ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌaxcaa, naímiꞌi muꞌu mi á yaúurɨe. Matɨ́ꞌɨj mi huataúruu. ");
INSERT INTO crnNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Majta meꞌɨ́n ɨ́ mej raatéeviꞌi meꞌɨ́jna ɨ́ Jesús, aꞌúu mú yaꞌuvíꞌitɨ meꞌɨ́jna jemi ɨ́ Caifás, aꞌɨ́jna tɨ nain jɨ́n antiújmuaꞌaree teyujtaꞌa. Majta meꞌɨ́n ɨ́ mej tiúꞌujmuaꞌate ɨ́ niuucari tɨ tíꞌaijta, majta meꞌɨ́n ɨ́ huáꞌavaujsimuaꞌa, aꞌúu mú majta eꞌetiújseɨreꞌecaꞌa aꞌutɨ́ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Caifás. ");
INSERT INTO crnNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ajta aꞌɨ́jna ɨ́ Pedro, aꞌatzu pu aꞌɨmuá raavájrajmeꞌe aꞌɨ́jna ɨ́ Jesús. Aꞌuu pu vejliꞌi aꞌaráꞌa aꞌu tɨ jáꞌitaꞌa eꞌeráyaujtaꞌa, aꞌu tɨ eꞌirájca aꞌɨ́jna tɨ nain jɨ́n antiújmuaꞌaree teyujtaꞌa. Aꞌuu pu ajta aꞌuteájrupi. Aj pu i huáꞌa jamuan aꞌujyeíjxɨ aꞌɨ́mej ɨ́ mej tíꞌichaꞌɨɨ tɨ ij ráamuaꞌaree aꞌij tɨ tejauuméꞌe aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Majta meꞌɨ́n mej tíꞌaijta teyujtaꞌa jamuan naímiꞌi ɨ́ huaꞌajueesi, aꞌɨ́ɨ mú rahuaucaꞌa ɨ́ huaꞌitzi ɨ́ mej jɨ́n Jesús jetze teꞌujpuáꞌajteꞌen tɨ ayén huaꞌutáꞌan mej mi raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Muꞌiitɨ́ mú áꞌujcaꞌanejcaꞌa mej huaꞌitzi jɨ́n téꞌantzaahuateꞌen. Capu amɨ́n aꞌij. Camu tiꞌitɨ́j huáteu ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajteꞌen. Aꞌatzu áꞌateeviꞌica tɨ ayén tíꞌirɨcɨ. Aj mú xaa meꞌɨ́n ɨ́ mej huaꞌapua mú á eꞌiréꞌene. ");
INSERT INTO crnNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ayee mú tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu yeehui tiuꞌutaxájtacaꞌa amɨ́jna mɨ tevi aꞌɨ́jna jɨ́meꞌen yee: “Nee nu raayɨ́ꞌɨtɨ nej raatéꞌuuna aꞌíjna i teyuu tɨ chiꞌiraꞌan púꞌeen ɨ́ Dios, ajta nuꞌu ajta ráꞌajtaahua huaíca xɨcaj tzajtaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Aj pu i seɨ́j ájchee. Aꞌii pu aꞌɨ́ɨn púꞌeeneꞌe ɨ́ tɨ nain jɨ́n antiújmuaꞌaree u teyujtaꞌa. Ayee pu aꞌɨ́ɨn tiuꞌutaꞌíhuaꞌuriꞌi ɨ́ Jesús tɨjɨ́n: ―¿Ni pecaí aꞌij penaꞌa tiuꞌutániuusin? ¿Tiꞌitájni púꞌeen aꞌíjna ɨ́ mej jɨ́n téꞌantzaahuateꞌe múꞌeetzi jemi? ");
INSERT INTO crnNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ajta aꞌɨ́ɨn ɨ́ Jesús, capu tiꞌitɨ́j aꞌij tiuꞌutaxájtacaꞌa. Ajta aꞌɨ́ɨn tɨ nain jɨ́n antiújmuaꞌaree ɨ́ teyujtaꞌa, ayée pu tiraatáꞌixaa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌaijteꞌe niuucajtzeꞌen ɨ́ Dios patáꞌaj taatáꞌixaateꞌen jaꞌatɨ́ pej púꞌeen. ¿Ni múꞌee peꞌɨ́n pɨ́rɨcɨ aꞌɨ́jna ɨ́ tɨ íꞌiyaujraꞌan ɨ́ Dios? ");
INSERT INTO crnNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús pu ayén tiuꞌutataniú tɨjɨ́n: ―Muꞌée pej piyen raataxájtacaꞌa. Mɨ́ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe tɨ ayén tejauuméꞌe aꞌame. Múꞌeen xu neseíraꞌa xáꞌajuꞌun ineetzi i nej neajta teáataꞌa jetze airáane netɨ́ꞌɨj án huatéyeijxa rɨꞌɨríintaꞌan aꞌɨ́jna ɨ́ tɨ nain jɨ́n antiújmuaꞌaree u ta japua, seajta neseíraꞌa xáꞌajuꞌun netɨ́ꞌɨjtáhuaꞌa yé veꞌecáanen ɨ́ jaitɨri jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ajta aꞌɨ́ɨn ɨ́ tɨ nain jɨ́n antiújmuaꞌaree ɨ́ teyujtaꞌa, aꞌɨ́ɨ pu raꞌantisiújtzaꞌan ɨ́ rusiicuꞌu mej mi ráamuaꞌaree tɨ aꞌɨ́ɨn huataniúꞌucacaꞌa. Ayen tɨjɨ́n: ―Aꞌij pu puaꞌa tiꞌixa ɨ́ Dios jemi. Capu chéꞌe ruxeꞌeveꞌe mej mi seica téꞌantzaahuateꞌen jemin. ¿Ni caí ayén tiꞌayajna? Casiꞌi, xuꞌuri ráanamuajriꞌi tɨ ayén aꞌij puaꞌa tiꞌixa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","’¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? Majta meꞌɨ́n ɨ́ seica, miyen tɨjɨ́n: ―Ayee pu tiraavíjteꞌe tɨ huámɨꞌɨni aꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aj mú mi raꞌarátzijmuaꞌaxɨ á néerimeꞌaraꞌan jetze, majta raꞌitéevajxɨ ɨ́ rumuájcaꞌa jɨmeꞌe. Seica mú majta ruꞌitévaꞌaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Majta miyen tiraatáꞌixaa tɨjɨ́n: ―Taatáꞌixaateꞌe múꞌee mɨ pej nuꞌu iꞌi Cɨríistuꞌu, ¿aꞌataani muꞌiitéjvee? ");
INSERT INTO crnNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ajta aꞌɨ́ɨn ɨ́ Pedro, aꞌúu pu anuꞌuhuátacatii jáꞌitaꞌa tɨ eꞌeráyaujtaꞌa ɨ́ chiꞌita. Ajta seɨ́j uteájrupi, ɨ́ tɨ ravaɨreꞌe aꞌɨ́jna ɨ́ teyujtaꞌa tɨ antiújmuaꞌaree. ꞌƗ́itaꞌa aꞌɨ́jna. Aj pu i á eꞌiréꞌene jemin. Ayee pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Muꞌée pej pajta áꞌucheꞌecaneꞌe peꞌɨ́jna jamuan, tɨ Galilea éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ajta aꞌɨ́ɨn Pedro, seɨcɨé pu tiraatáꞌixaa mej seíiracaꞌa ɨ́ seica, ayén tɨjɨ́n: ―Canu ramuaꞌaree aꞌij pej yeꞌí tiꞌixa. ");
INSERT INTO crnNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Aj pu i ájchee. Puꞌuri huiiraméꞌeca táꞌapueerta. Aa pu aꞌutéechaxɨ. Ajtahuaꞌa seɨ́j raaseíj ꞌɨ́itaꞌa. Aj pu i ayén tihuaꞌutáꞌixaa ɨ́ teɨte ɨ́ mej aꞌuun aꞌuráteꞌecaꞌa tɨjɨ́n: ―Amɨ́jna mɨ tevi, aꞌɨ́ɨ pu xaa áꞌucheꞌecaneꞌe jamuan aꞌɨ́jna ɨ́ Jesús, Nazarét tɨ éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ajtahuaꞌa pu seɨcɨé tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro. Niuucajtzeꞌen pu jɨ́n ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu ramuaꞌate neꞌɨ́jna ɨ́ tevi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aꞌatzu áꞌateeviꞌica, majta meꞌɨ́n ɨ́ mej eꞌeréꞌeteꞌecaa, aꞌɨ́ɨ mú á eꞌiréꞌene vejliꞌi jemin. Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Múꞌee pej xaa huáꞌa jetze ajtémeꞌecan. Tuꞌuri ramuaꞌaree teꞌɨ́jna jɨmeꞌe aꞌij pej yeꞌí teꞌenrúꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ajta áꞌiyen Pedro ayén aꞌutéjche tɨ ayén rájhuavii ɨ́ Dios tɨ nuꞌu Dios ayén puaíjtzi raatáꞌan tɨ puaꞌa caí ayén tiꞌayajna. Aj pu i ayén tihuaꞌutáꞌixaa niuucajtzeꞌen ɨ́ Dios tɨjɨ́n: ―Canu ramuaꞌate nemɨ́jna mɨ tevi. Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj pu i huajíjhuacaꞌa aꞌɨ́jna ɨ́ tecuaaraꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tɨꞌɨj jí áꞌiyen Pedro raꞌutámuaꞌareeriꞌi aꞌij tɨ Jesús amuacaí tiraatáꞌixaa tɨ jɨ́meꞌen yee: “Tɨ́ꞌɨj nuꞌu caí xɨ huajíjhuaꞌa ɨ́ gallo, ayée pej nuꞌu huaíca piyen tínaꞌavéꞌavaata yee capej nemuaꞌate.” Aj puꞌi huirájraa. Jéꞌecan pu aꞌij puaꞌa raatáꞌa. Tiujyeínejraa huápɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Yee ruijmuaꞌa yee, aréꞌapuaꞌa, aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta huáꞌa vaújsimuaꞌa ɨ́ teɨte, aꞌɨ́ɨ mú raaxɨ́ꞌepɨꞌɨntare rujɨ́ɨmuaꞌa aꞌij mej yeꞌí huárɨni mej mi raajéꞌica ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maraꞌanáajɨꞌɨcɨꞌe ɨ́ muájcaꞌareꞌaraꞌan jetze, matɨ́ꞌɨj mi yaꞌuvíꞌitɨ. Aj mú mi raatátui aꞌɨ́jna ɨ́ tajtuhuan, tɨ ayén ántehuaa tɨjɨ́n Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ajta aꞌɨ́jna ɨ́ Judás, tɨ́ꞌɨj ráamuaꞌareeriꞌi tɨjɨ́n puaíjtzi mú raatáꞌasin ɨ́ Jesús, jéꞌecan pu aꞌij puaꞌa raatáꞌa. Ajta, yaúutuaa huáꞌa jemi aꞌɨ́jna ɨ́ tumin tɨ seité japuan tamuáamuataꞌa aráꞌase. Ayee pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌaijta, ajta aꞌɨ́mej ɨ́ huáꞌa vaújsimuaꞌa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","―Nee nu auteájturaa ɨ́ Dios jemi aꞌiné nejámuaatátui jaꞌatɨ́ tɨ caí tiꞌitɨ́j jɨ́n atéꞌɨtzeaꞌara sej si raajéꞌica. Majta miyen tiraatáꞌixaa tɨjɨ́n: ―Capu aꞌatzu ta jetze ruxeꞌeveꞌe itejmi. Múꞌee pej púꞌeeneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Aj pu i Judás á yeꞌejhuáꞌaxɨ ɨ́ tumin á chuaataꞌa aꞌujna teyujtaꞌa. Tɨꞌɨj jí áꞌuraa. Tɨ́ꞌɨj i mé jáꞌahuaꞌa eꞌecaújcuaꞌimin. ");
INSERT INTO crnNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Majta meꞌɨ́n ɨ́ mej tíꞌaijta teyujtaꞌa, aꞌɨ́ɨ mú raaréꞌejeꞌipɨ meꞌɨ́jna ɨ́ tumin. Majta miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Capu aꞌij tiuꞌutáꞌaca tej yeúutuaani aꞌɨ́jna ɨ́ tumin aꞌu tɨ áꞌujseɨreꞌe ɨ́ tumin teyujtaꞌa tɨ meꞌecan, aꞌiné aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tej jɨ́n tiuꞌunájchitacaꞌa tej ti yáꞌurɨeeni ɨ́ xúureꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Matɨ́ꞌɨj mi miyen raaxɨ́ꞌepɨꞌɨntare aꞌij mej yeꞌí huárɨni meꞌɨ́jna jɨmeꞌe ɨ́ tumin. Ayee mú meꞌɨ́jna jɨ́n chuej huánanai mej miyen ratamuáꞌamua tɨjɨ́n chuej tɨ japuan tíꞌimɨjhuaca aꞌɨ́jna tɨ xaꞌari tíꞌitaꞌahuaca. Ayee mú raxɨ́ꞌeveꞌecaꞌa mej mi meꞌuun huaꞌaváꞌanaamuan aꞌɨ́mej ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ayee mú majta ratamuáꞌamua tɨ́j naꞌa aꞌájnáꞌɨmua tɨ yú eꞌiréꞌene tɨjɨ́n chuej mej japuan raꞌuréꞌexɨre ɨ́ xúureꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Aꞌájnáꞌɨmua pu araúraste aꞌij tɨ ajmíꞌi tiraataxájtacaꞌa aꞌɨ́jna ɨ́ Jeremías teecan tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa tɨjɨ́n: “Aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, ayée mú raaxɨ́ꞌepɨꞌɨntare mej tiraanájchiteꞌen aꞌachú cumu seité japuan tamuáamuataꞌa tumin tɨ iꞌi plata tɨ ij aꞌɨ́ɨn huaꞌutátuiireꞌen aꞌɨ́jna ɨ́ jaꞌatɨ. Majta áꞌiyen raaréꞌejeꞌipɨ meꞌɨ́jna ɨ́ tumin. ");
INSERT INTO crnNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ayee mú majta huarɨ́j tɨ́j tinaataꞌaíj ɨ́ tavástaraꞌa. Chuej mú huánanai aꞌu tɨ tíꞌimɨjhuacareꞌe aꞌɨ́jna tɨ xaꞌari tíꞌitaꞌahuaca.” ");
INSERT INTO crnNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌúu pu aꞌutéveecaꞌa jemin aꞌɨ́jna ɨ́ tajtuhuan. Aj pu i aꞌɨ́ɨn tajtuhuan ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni múꞌee peꞌɨ́n púꞌeen ɨ́ pej huaꞌarey aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan? Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús: ―Aa niꞌijtá neꞌu, aꞌij pej yeꞌí tiꞌixa múꞌee. ");
INSERT INTO crnNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mɨ́ ajta aꞌɨ́ɨn Jesús, matɨ́ꞌɨj jetzen teꞌujpuáꞌajte aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta huáꞌavaujsimuaꞌa, capu tiꞌitɨ́j xajtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Aj pu i Pilato ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni pecaí piyen huáꞌunamuajriꞌi ɨ́ mej jeíhua múꞌeetzi jetze teꞌujpuáꞌajte? ");
INSERT INTO crnNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ajta aꞌɨ́ɨn Jesús, capu tiꞌitɨ́j xajtacaꞌa. Capu ajta seɨcɨé tiuꞌutaxájtacaꞌa, ni seɨ́j jɨmeꞌe ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajte. Aꞌɨ́j pu jɨ́n, jéꞌecan pu aꞌij yáꞌuseijracaꞌa aꞌɨ́jna ɨ́ tajtuhuan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ajta aꞌájna matɨ́ꞌɨj tíꞌiyestejcaꞌa ɨ́ teɨte, ayée pu tíꞌijrɨꞌɨrejcaꞌa aꞌɨ́jna ɨ́ tajtuhuan tɨ ayén seɨ́j huatátuaani tɨ aiteánamiꞌi, jaꞌatɨ́ tɨ naꞌa mej raatáhuavii. ");
INSERT INTO crnNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ajta seɨ́j aiteánamiꞌihuacaꞌa tɨ ayén ántehuaa tɨjɨ́n Barrabás. Naímiꞌi mú ramuaꞌatejcaꞌa meꞌɨ́jna ɨ́ Barrabás, tɨ aꞌij puaꞌa tíꞌitevistacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Matɨ́ꞌɨj ajteáxɨɨrecaꞌa jeíhua ɨ́ teɨte, Pilato pu ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe múꞌeen? ¿Ni qui neraatátuaani neꞌɨ́jna ɨ́ Barrabás, naꞌari nemɨ́jna mɨ Jesús, ɨ́ tɨ jee iꞌi Cɨríistuꞌu? ");
INSERT INTO crnNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi aꞌiné ayée pu ráamuaꞌareeriꞌi tɨjɨ́n maráꞌachueereꞌecaꞌa ɨ́ Jesús. Aꞌɨ́j mú jɨ́n raatátuiiriꞌi ɨ́ tajtuhuan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Aúcheꞌe pu huatecaíca ɨ́ ɨpuari japua aꞌɨ́jna ɨ́ Pilato tɨ́ꞌɨj ɨ́raꞌaraꞌan ayén tiraataꞌítiꞌiriꞌi tɨjɨ́n: “Aꞌij nu puaꞌa tiúꞌumaaracaꞌa neꞌɨ́jna jɨmeꞌe ɨ́ tevi tɨ caí jaꞌanáj tiꞌitɨ́j jɨ́n auteájturaa. Jéihua nu rajpuaíjtzicaꞌa íjii neꞌɨ́jna jɨmeꞌe. Capej tiꞌitɨ́j jɨ́n jetzen tíꞌijpuaꞌajteꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Majta meꞌɨ́n ɨ́ mej tíꞌaijta u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ huáꞌavaujsimuaꞌa, aꞌɨ́ɨ mú caꞌaníjraꞌa huaꞌutáꞌa ɨ́ teɨte mej mi miyen rájhuavii ɨ́ tajtuhuan tɨ ij aꞌɨ́ɨn huatátuaani aꞌɨ́jna ɨ́ Barrabás. Ayee mú majta tirájhuaviiriꞌi tɨ ij aꞌɨ́ɨn tiuꞌutáꞌan mej mi raajéꞌica meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ajtahuaꞌa pu ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe múꞌeen? ¿Aꞌatajni naatátuaani aꞌɨ́mej ɨ́ mej huaꞌapua? Ayee mú tiuꞌutaniú tɨjɨ́n: ―Barrabás. ");
INSERT INTO crnNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Aj pu i Pilato ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ari mɨ Jesús, aꞌiné tiꞌitɨ́j jɨ́n neráaruuren? Naímiꞌi mú miyen tiuꞌutaniú tɨjɨ́n: ―Patáꞌaj ráꞌutatan cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato pu ajtahuaꞌa ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨmeꞌe? ¿Tiꞌitájni jɨ́n auteájturaa tej ti tiyen ráaruuren? Aj mú mi jaítzeꞌe caꞌanín jɨ́n huajíjhuacaꞌa tɨjɨ́n: ―Patáꞌaj ráꞌutatan cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato pu rúꞌumuaꞌareerecaꞌa tɨ caí aꞌij tíꞌirɨꞌɨri huáꞌa jemi, sino muꞌuri tɨ́n autéhuijsimeꞌe mej tiúꞌujneꞌusiteꞌesin cháꞌa menaꞌa. Aꞌɨ́j pu jɨ́n anaújmuaijte jaj jɨmeꞌe mej seíiracaꞌa ɨ́ teɨte. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu neꞌɨ́n púꞌeen ɨ́ tɨ raajéꞌicatan amɨ́jna mɨ teáataꞌa, sino múꞌeen xuꞌu púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Naímiꞌi mú miyen tiuꞌutaniú tɨjɨ́n: ―Chéꞌe ayén éeneꞌen tɨ titáacɨꞌɨti itejmi, ajta tɨ tihuáꞌucɨꞌɨti ɨ́ tayaujmuaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ tej raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aj pu i Pilato raatátuaa aꞌɨ́jna ɨ́ Barrabás huáꞌa jemi. Ajta raataꞌaíjtacaꞌa mej raꞌitévajxɨꞌɨn meꞌɨ́jna ɨ́ Jesús. Aj pu i huaꞌutátuii mej mi ráꞌutatan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aj mú mi meꞌɨ́n xantaaruꞌu yaꞌujáj aꞌájna tɨ tajtuhuan eꞌirájca. Majta huaꞌutajé naíjmiꞌica ɨ́ ruxɨ́ꞌej xantaaruꞌu mej mi tiújseɨreꞌen jemin ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Matɨ́ꞌɨj mi tiraacáꞌariꞌiriꞌi nain ɨ́ tɨ tiꞌitéchejcaꞌa. Majta síicuꞌuri mú ruꞌucáachejte tɨ páꞌuviꞌi, tɨ neána jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Majta curuun mú raateátaave tɨ tzicareꞌe jɨmeꞌe cɨstíjhuacaꞌa. Aꞌɨ́j mú raꞌavéꞌerujtiꞌiriꞌi. Majta, itzɨ́j mú ruꞌitéechuite rɨꞌɨríintaꞌan. Aj mú mi títunutaxɨ jemin. Ayee mú tiráꞌuxɨeehuariꞌiriꞌi tɨjɨ́n: ―¿Aꞌiné penaꞌa, múꞌee pej tihuáꞌaijteꞌe aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Majta raꞌatétzijmuaꞌaxɨ, majta rajvíꞌi meꞌɨ́jna ɨ́ itzɨ́j. Muꞌíi mú raꞌavéꞌevajxɨ án muꞌúutzeꞌen meꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Matɨ́ꞌɨj ráꞌuxɨeehuariꞌira, aj mú mi rúꞌijchuiiriꞌi meꞌɨ́jna ɨ́ síicuꞌuri tɨ páꞌuviꞌi, tɨ neána jɨmeꞌe. Majta ruꞌucáachejte ɨ́ síicuꞌureꞌaraꞌan. Matɨ́ꞌɨj mi yaꞌujáj mej mi ráꞌutatan ɨ́ cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Matɨ́ꞌɨj aujúꞌucaa, seɨ́j mú antinájchecaꞌa tɨ seɨj chuéjraꞌa japua éꞌemeꞌecan tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Cirene. Ajta aꞌɨ́ɨn ɨ́ teáataꞌa, ayée pu ántehuaa tɨjɨ́n Simón. Aj mú mi raataꞌaíjte tɨ aꞌɨ́ɨn ráꞌanchueeni cúrujraꞌan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌu tɨ ayén téjaꞌarájtehuaa huaꞌaniuuca jɨmeꞌe tɨjɨ́n Gólgota. Gólgota, ayée pu huataújmuaꞌa tɨjɨ́n Mɨꞌɨchí Muꞌuta. ");
INSERT INTO crnNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Aꞌuu mú raatáꞌa tiꞌitɨ́j tɨ raayéꞌen, viinu tɨ antzináj tɨ ranaxca. Tɨ́ꞌɨj raꞌajtamuáꞌa, capu raꞌíꞌimɨꞌɨ jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Matɨ́ꞌɨj mi ráꞌutatai ɨ́ cúruu jetze. Majta, huáhuajcacaꞌa mej tiꞌihuaújmuaꞌitɨn tetej jɨmeꞌe mej mi ráamuaꞌaree tiꞌitɨ́j tɨ aꞌij racɨꞌɨti seɨj ajta seɨj ɨ́ cɨ́ɨxureꞌaraꞌan ɨ́ Jesús. Ayee mú titeeréꞌujpijte. ");
INSERT INTO crnNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Majta aꞌujráꞌasecaꞌa mej mi ráachaꞌɨɨn. ");
INSERT INTO crnNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Majta taabla cɨ́lieeneꞌen aúutatai aꞌutɨ́ áꞌujmuꞌu ɨ́ Jesús. Ayee mú amuacaí raꞌuyúꞌuxacaꞌa ɨ́ taabla jetze aꞌíjna ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajte tɨjɨ́n: “Aꞌii pu aꞌɨ́ɨn púꞌeen i Jesús, ɨ́ tɨ huaꞌarey aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan.” ");
INSERT INTO crnNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Majta jamuan huáꞌutatai huaꞌapuaca ɨ́ nahuaꞌari. Seɨ́j mú aúutatai rɨꞌɨríintaꞌan ɨ́ Jesús, majta ɨ́ seɨj, úutataꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Majta meꞌɨ́n ɨ́ mej aꞌuréꞌenineicaꞌa, matɨ́ꞌɨj raaseíj, aꞌɨ́ɨ mú aicámuꞌuvajra mej caí ráꞌacuꞌuvejcaꞌa. Aꞌij mú puaꞌa tíꞌijjeevecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Miyen tɨjɨ́n: ―Múꞌee, mɨ pej nuꞌu raatéꞌuuna ɨ́ teyuu, pajta nuꞌu huaíca xɨca jɨ́n pajtáhuaꞌa ráꞌajtaahua, aisí neꞌu, patáꞌaj aseɨ́j ajapua huániuuni. Tɨ́ puaꞌa múꞌee pe peꞌɨ́n púꞌeen ɨ́ yaujraꞌan ɨ́ Dios, acájraꞌa hui amɨ́jna jetze mɨ cúruu. ");
INSERT INTO crnNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ayee mú cheꞌatá menaꞌa tiráꞌuxɨeehuariꞌiriꞌi aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ niuucari jɨmeꞌe tɨ tíꞌaijta, majta huáꞌavaujsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Amɨ́ pu ari huáꞌa japua huaniú ɨ́ seica. Mɨ́ ajta amɨ́n, capu raayɨ́ꞌɨtɨ tɨ rujapua huániuuni. Amɨ́ pu nuꞌu tarey itejmi i tej Israél jetze ajtémeꞌecan; chéꞌe amɨ́n acájraꞌani mɨ cúruu jetze. Aj tu xaa ráꞌantzaahuateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","’Aꞌɨ́ɨ pu hui nuꞌu ráꞌatzaahuateꞌe ɨ́ Dios. Chéꞌe Dios japuan huániuuni íjii tɨ puaꞌa ayén raxɨ́ꞌeveꞌe aꞌiné ayée pu amɨ́n tiuꞌutaxájtacaꞌa tɨ jɨ́meꞌen yee: “Nee nu neꞌɨ́n púꞌeen ɨ́ yaujraꞌan Dios.” ");
INSERT INTO crnNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Majta meꞌɨ́n ɨ́ mej jamuan huajúꞌucaa, aꞌɨ́ɨ mú miyen cheꞌatá ráꞌuxɨeehuariꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tɨ́ꞌɨj aꞌájna tejaꞌuréꞌene aꞌatzaj tacuarixpua, aj puꞌi huateátɨcaꞌarecaꞌa nainjapua ɨ́ chuej. ");
INSERT INTO crnNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna jáꞌitaꞌa tacuarixpua, aj pu i Jesús caꞌanín jɨ́n huajíjhuacaꞌa ɨ́ runiuuca jɨmeꞌe tɨjɨ́n: ―Eloi, eloi, ¿lama sabactani? Aꞌíjna i niuucari, ayée pu huataújmuaꞌa tɨjɨ́n: “Mɨ́ pej niꞌi Dios, mɨ pej niꞌi Dios, ¿aꞌiné ꞌeen jɨ́n pi nejaúurɨe?” ");
INSERT INTO crnNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Seica mej meꞌuun huatéꞌuucaꞌa meráanamuajriꞌi. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Aꞌɨ́ɨ pu hui huatajé aꞌɨ́jna ɨ́ Elías tɨ ajmíꞌi Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jɨ́meꞌen muꞌu miyen tiuꞌutaxájtacaꞌa, aj pu i seɨ́j aꞌutɨéechejraa. Tiꞌitɨ́j pu u aꞌuvéꞌetɨɨ tɨ urájtaꞌati. Ajta raateáruꞌune nahuáj jɨmeꞌe taꞌantzíjviꞌi. Raꞌantijɨ́ꞌɨcɨꞌe cɨyej jetze, aj pu i ráꞌajchui tɨ ij Jesús huayéꞌen aꞌɨ́jna jetze. ");
INSERT INTO crnNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Majta seica, ayée mú tiraatáꞌixaa tɨjɨ́n: ―Chéꞌe ayén éeneꞌen. Aisí tɨ puaꞌa yé tanén aꞌɨ́jna ɨ́ Elías tɨ ij aꞌɨ́ɨn raꞌacájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ajta aꞌɨ́jna ɨ́ Jesús, ajtahuaꞌa pu caꞌanín jɨ́n huajíjhuacaꞌa. Aj pu i huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ajta aꞌɨ́jna ɨ́ cɨ́ɨxuri tɨ itzíjhua, aꞌuun tɨ huatáviviɨjmeꞌeca teyujtaꞌa, jɨ́meꞌen puꞌu huamɨ́ꞌɨ aꞌɨ́jna ɨ́ Jesús, aj pu i jáꞌitaꞌa acásiujtzaꞌan. Ajta huateújcaꞌatzɨjxɨ ɨ́ chuej, ajta jáꞌitaꞌa aꞌutátapuaj ɨ́ tete. ");
INSERT INTO crnNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ajta teꞌentaújcuunaxɨ aꞌu mej eꞌeveꞌenámiꞌihuajmeꞌecaa ɨ́ mej huácuii. Dios pu ajtahuaꞌa huaꞌutatɨ́ste ɨ́ huáꞌaxɨejniuꞌuca muꞌiicáca ɨ́ mej huácuii, aꞌɨ́mej ɨ́ mej mejmíꞌi raꞌaráꞌastijre. Majtahuaꞌa mú iꞌirúuri muáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Majta aitacɨ́j aꞌu mej eꞌeveꞌenámiꞌihuajmeꞌecaa. Majta meꞌɨ́n, tɨ́ꞌɨj huatarúj aꞌɨ́jna ɨ́ Jesús, aꞌɨ́ɨ mú aꞌuteájrupi u chajtaꞌa. Aꞌuu mú aꞌutaseíjre jemin ɨ́ teɨte ɨ́ mej muꞌíi. ");
INSERT INTO crnNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ajta aꞌɨ́jna huaꞌacapítan ɨ́ xantaaruꞌu ɨ́ mej anxɨ́te aráꞌaxcaa, majta ɨ́ mej jamuan tíꞌichaꞌɨɨcaꞌa, nain mú tiuꞌuséij aꞌij tɨ tiuꞌurɨ́j, ajta tɨ huateújcaꞌatzɨjxɨ ɨ́ chuej. Jéꞌecan mú tiuꞌutáatziɨn. Majta miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Tarɨ́ꞌɨ pu aꞌɨ́ɨn púꞌeeneꞌe yaujraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Majta seica, á muꞌu ɨmuá aꞌutéꞌuu metiꞌiseíiracaꞌa ɨ́ mej ꞌuuca. Miꞌi muꞌíi. Aꞌɨ́ɨ mú áꞌujujhuaꞌaneꞌe meꞌɨ́jna ɨ́ Jesús jamuan tɨ́j naꞌa tɨ u aꞌarájraa u Galilea, majta ɨ́ mej ravaɨreꞌecaꞌa tɨ́j naꞌa tɨ ayén ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Aꞌii mú aꞌɨ́ɨn púꞌeen: aꞌɨ́jna ɨ́ María, Magdala tɨ éꞌemeꞌecan, ajta seɨ́j tɨ ayén cheꞌatá ántehuaa tɨjɨ́n María. Huaꞌanaana pu púꞌeen aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ José. Seɨ́j pu ajta huáꞌa jamuan aꞌutéveecaꞌa, aꞌɨ́jna tɨ huaꞌanáànaj aꞌɨ́mej yaújmuaꞌameꞌen aꞌɨ́jna ɨ́ Zebedeo. ");
INSERT INTO crnNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tɨ́ꞌɨj ari huachúmuaꞌancaa, seɨ́j pu á eꞌiréꞌene tɨ Arimatea éꞌemeꞌecan. Chíjteaani pu pɨ́rɨcɨ aꞌɨ́jna. Ayee pu ántehuaa tɨjɨ́n José. Aꞌɨ́ɨ pu ajta ráꞌatzaahuateꞌecaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Aꞌɨ́ɨ pu á eꞌiréꞌene jemin aꞌɨ́jna ɨ́ Pilato. Ajta rájhuaviiriꞌi tɨ aꞌɨ́ɨn raatátuiireꞌen téviraꞌan ɨ́ Jesús teecan. Ajta aꞌɨ́ɨn Pilato tiuꞌutaꞌaíjtacaꞌa mej nuꞌu raatátuiireꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ajta José, tɨꞌɨquí raꞌacájtɨ ɨ́ téviraꞌan. Ajta raꞌiréꞌeꞌijcatacaꞌa saavana jɨmeꞌe tɨ jéjcua. ");
INSERT INTO crnNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Aꞌɨ́ɨ pu auchén ruuréꞌijche u téteꞌe ɨ́ tete tzajtaꞌa. Aꞌɨ́ɨ pu íꞌaꞌaraꞌan mej mi meꞌuun raꞌaváꞌanan tɨ́ꞌɨj huámɨꞌɨni. Mɨ́ ajta, aꞌúu pu ruꞌutéete téviraꞌan ɨ́ Jesús teecan. Ayee pu aꞌɨ́jna jɨ́n huarɨ́j, aj pu i ruꞌujná tetej jɨmeꞌe tɨ sicɨ́ɨraraꞌa. Ajta áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ajta aꞌɨ́jna ɨ́ María, Magdala tɨ éꞌemeꞌecan, ajta ɨ́ seɨ́j, ɨ́ María, aꞌúu mú aꞌutéꞌuucaꞌa aꞌájna vejliꞌi taꞌiráninei aꞌu mej yaꞌutéete. ");
INSERT INTO crnNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Yee ruijmuaꞌa yee, matɨ́ꞌɨj meri rɨ́ꞌɨ huaújruu mej mi huaújseꞌupeꞌen, aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta meꞌɨ́n ɨ́ fariseo, aꞌɨ́ɨ mú á eꞌiréꞌene jemin aꞌɨ́jna ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ayee mú tiraatáꞌixaa tɨjɨ́n: ―Tavastaraꞌa, ayée tu raꞌutámuaꞌareeriꞌi tɨ ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ tɨ tíꞌihuaꞌitacareꞌe. Tɨ́ꞌɨj auj ruurica, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: “Huaíca xɨcaj nu jetze huatarújsin.” ");
INSERT INTO crnNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","’Aꞌɨ́j pu jɨ́n, ayée tu tíꞌijxeꞌeveꞌe pej raataꞌaíjta mej mi tiúꞌuchaꞌɨɨn aꞌu tɨ eꞌevéꞌenamiꞌi ajta caí mú áꞌumeꞌen huaíca xɨca. Naꞌari caí, íꞌirɨꞌɨri mej eꞌireꞌenén, meraanáhuaꞌan ɨ́ téviraꞌan aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. Aj mú xaa miyen huaꞌitzi jɨ́n tihuaꞌutáꞌixaateꞌesin ɨ́ teɨte tɨjɨ́n puꞌuri huatarúj. Ajta jaítzeꞌe pu aꞌij puaꞌa téꞌeme caí tɨ́ꞌɨj amuacaí ayén tiuꞌuhuáꞌitacaꞌa aꞌɨ́jna jɨmeꞌe tɨ ayén nuꞌu yaujraꞌan púꞌeen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Pilato tɨjɨ́n: ―Ayee pu téꞌeme. Metíꞌichaꞌɨ́j mú muáꞌajuꞌun. Sericu múꞌeen, seajta ruꞌujjáxuꞌumuaꞌan xarij jɨmeꞌe, ajta júmiꞌinari jɨmeꞌe, aꞌij sej tiraayɨ́ꞌɨtɨ tɨ ij caí jaꞌatɨ́ ramuarɨꞌe ɨ́ téviraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Matɨ́ꞌɨj mi aꞌucɨ́j. Majta rɨ́ꞌɨ ráaruu xarij jɨmeꞌe, majta júmiꞌinari jɨmeꞌe tɨ ij caí jaꞌatɨ́ raꞌantácuuna. Majta u huaꞌutehuii aꞌɨ́mej ɨ́ mej tíꞌichaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tɨ́ꞌɨj mú áꞌume aꞌɨ́jna ɨ́ xɨca mej jetzen ruseꞌupi, tapuáꞌarijmeꞌeca, aꞌɨ́jna ɨ́ María, Magdala tɨ éꞌemeꞌecan, ajta ɨ́ seɨ́j tɨ ajta María, u mú áꞌujuꞌun mej mi yaꞌutéeseij aꞌu mej yeꞌaváꞌana. ");
INSERT INTO crnNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Caꞌanín pu jɨ́n huateújcaꞌatzɨjxɨ ɨ́ chuej aꞌiné seɨ́j tɨ tíꞌivaɨreꞌe u ta japua, aꞌɨ́ɨ pu eꞌicaanej u júteꞌe. Aa pu eꞌiréꞌene aꞌu mej yeꞌaváꞌana. Antárɨiihuacaꞌa aꞌɨ́jna ɨ́ tete tɨ jɨ́n ujnámiꞌihuacaꞌa tɨ únúꞌujcun. Ajta japuan aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Jéꞌecan pu tétaaveꞌe cuaiínaviꞌin jɨmeꞌe i tɨ jɨ́n tiꞌitéechen temuaꞌa naa aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Majta meꞌɨ́n ɨ́ mej tíꞌichaꞌɨɨcaꞌa, huápɨꞌɨ mú ruviveecaꞌa, majta aꞌitavátzɨ meꞌɨ́jna jɨmeꞌe mej huápɨꞌɨ tiuꞌutátziɨn. Cu xɨee mej cuj huácuii. ");
INSERT INTO crnNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe u ta japua, ayée pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ ꞌuuca tɨjɨ́n: ―Caxu tíꞌitziɨɨneꞌe, aꞌiné néjmuaꞌaree sej u yeꞌevéꞌehuau seꞌɨ́jna ɨ́ Jesús ɨ́ mej ráꞌutatai. ");
INSERT INTO crnNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Capu hui yeꞌe jáꞌahuaꞌa aꞌiné puꞌuri huatarúj tɨ́j ajmíꞌi tiuꞌutaxájtacaꞌa. Casiꞌi, mú séꞌujuꞌun setáꞌaj yaꞌuseíj aꞌu mej yeꞌetéete. ");
INSERT INTO crnNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","’Seajta, setáꞌaj áꞌucɨɨne jíyeꞌitzi jɨmeꞌe sej si huajaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨ jɨ́meꞌen yee: “Aꞌɨ́ɨ pu ari huatarúj, ajta amuacaí pu nuꞌu aꞌuméꞌe aꞌame aꞌujna Galilea tɨ ij aꞌɨ́ɨn huajáꞌuchuꞌeveꞌen aꞌujna. Aꞌuu xu nuꞌu yéꞌeseijran.” Nuꞌuri amuaatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Majta meꞌɨ́n ɨ́ ꞌuuca, caꞌanacan mú aꞌucɨ́j. Maúcheꞌe mú tíꞌitziɨɨneꞌecaꞌa. Mɨ́ majta, muaataújtemuaꞌave jeíhua. Aꞌuu mú aꞌuruáachejraa mej mi tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ajta, jíyeꞌitzi jɨ́n, Jesús huáꞌuteu. Ayee pu tihuaꞌutateújte tɨjɨ́n: ―¿Aꞌiné senaꞌa? Majta meꞌɨ́n, á mú eꞌiréꞌene jemin. Majta raꞌavéꞌeviꞌiraxɨ ɨɨcájraꞌan jetze. Majta rɨ́ꞌɨ tiraatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu tíꞌitziɨɨneꞌe. Sericu múꞌeen, setáꞌaj tihuaꞌutáꞌixaateꞌen ɨ́ neꞌihuaamuaꞌa mej áꞌucɨɨne meꞌújna Galilea. Aꞌuu mú hui nejéꞌeseijran. ");
INSERT INTO crnNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Maúcheꞌe mú huajúꞌucaa aꞌɨ́ɨme ɨ́ ꞌuuca, seica mú aꞌuun áꞌujuꞌun u chajtaꞌa. Aꞌii mú aꞌɨ́ɨn púꞌeen seica ɨ́ mej tíꞌichaꞌɨɨcaꞌa. Majta miyen tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌaijta teyujtaꞌa nain aꞌij tɨ tiꞌitɨ́ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Majta meꞌɨ́n ɨ́ mej tíꞌaijta teyujtaꞌa, aꞌɨ́ɨ mú tiújseɨj huáꞌa jamuan ɨ́ vaujsi mej mi raaxɨ́ꞌepɨꞌɨntareꞌen aꞌij mej yeꞌí huárɨni. Aj mú mi tumin huaꞌutáꞌa ɨ́ xantaaruꞌu, jeíhua. ");
INSERT INTO crnNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ayee mú tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee xu huárɨni múꞌeen. Setáꞌaj siyen tihuaꞌutáꞌixaateꞌen yee: “Seica mú mú aꞌuvéꞌejuꞌun tɨ́caꞌɨmua aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe tetɨ́ꞌɨj cuꞌutzucaꞌa iteen. Aꞌɨ́ɨ mú yáꞌutɨɨ ɨ́ téviraꞌan avíitzi jɨmeꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ajta tɨ puaꞌa ráamuaꞌaree ɨ́ tajtuhuan aꞌij tɨ tiꞌitɨ́ huarɨ́j, teen tu tiyen tiraatáꞌixaateꞌesin tɨ ij caí tiꞌitɨ́j jɨ́n aꞌij amuáaruuren múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Majta tumin mú áꞌutɨɨ aꞌɨ́ɨme ɨ́ xantaaruꞌu. Majta miyen cheꞌatá menaꞌa huarɨ́j matɨ́j meꞌɨ́n seica huaꞌutaꞌítecaꞌa. Tɨ́j naꞌa tɨ yú eꞌiréꞌene, ayée mú tíꞌixaxaꞌa nainjapua aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan tɨ ayén tiꞌayajna. ");
INSERT INTO crnNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Majta meꞌɨ́n ɨ́ mej tamuáamuataꞌa japuan seɨ́j muaꞌaráꞌaxcaa, aꞌúu mú áꞌujuꞌun aꞌujna Galilea. Aꞌuu mú aꞌaráꞌa jɨrí jetze tɨ́j amuacaí tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús mej nuꞌu meꞌuun aꞌatanén. ");
INSERT INTO crnNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Matɨ́ꞌɨj raaseíj, aj mú mi rɨ́ꞌɨ tiraatáꞌa. Mɨ́ majta meꞌɨ́n, camu rɨ́ꞌɨ ráꞌatzaahuateꞌecaꞌa tɨ aꞌɨ́ɨn púꞌeeneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aj pu i Jesús eꞌiréꞌene vejliꞌi huáꞌa jemi. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Puꞌuri naatáꞌa nej niyen nain jɨ́n antínmuaꞌaree tɨ́j naꞌa tɨ aꞌuun éꞌeseijreꞌe u ta japua, ajta tɨ́j naꞌa tɨ íiyen seijreꞌe chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","’Aꞌɨ́j xu jɨ́n aꞌucɨ́jxɨꞌɨn nainjapua seɨ́j chuéjraꞌa japua sej si huaꞌutémuaꞌitɨn ɨ́ teɨte mej mi naꞌaráꞌastijreꞌen. Seajta huáꞌumuaɨꞌɨhuan niuucajtzeꞌen ɨ́ tɨ níꞌiyaꞌupua, seajta niuucajtzeꞌen ɨ́ nej iꞌi yaujraꞌan, seajta niuucajtzeꞌen ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","’Seajta múꞌeen, setihuáꞌamuaꞌatehuaꞌan mej mi nain jɨ́n naꞌaráꞌastijreꞌen aꞌij nej neri tejamuaataꞌaíj múꞌejmi. Neajta inee, rɨ́ꞌɨ nuꞌu yé huatevée naꞌame aꞌamua jemi tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame asta naꞌa caí nain teꞌentipuáꞌare. Ayee puꞌu.");
INSERT INTO crnNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yee pu éeniꞌicɨꞌe aꞌutéjche ɨ́ niuucari tɨ jɨ́meꞌen ráꞌaxa aꞌɨ́jna ɨ́ Jesús ɨ́ Cɨríistuꞌu tɨ ajta yaujraꞌan pɨ́rɨcɨ ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ayee pu teꞌuyúꞌuxacaꞌa ɨ́ jaꞌatɨ tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayee pu ántehuaacaꞌa tɨjɨ́n Isaías. Ayee pu tiraꞌuyúꞌuxacaꞌa ayén tɨjɨ́n: Yee pu Dios tiꞌixa aꞌɨ́jna jɨmeꞌe tɨ án yáꞌujra ɨ́ ɨpuari japua ayén tɨjɨ́n: “Meꞌecui xaa neꞌu, nuꞌuri jaꞌatɨ́ huataꞌíti tɨ́ꞌij amuacaí huataseíjreꞌen pecaí múꞌee. Aꞌɨ́ pu aꞌɨ́ɨn púꞌeen tɨ amuacaí tihuaꞌutáꞌixaateꞌesin ɨ́ teɨte mej nuꞌu muaꞌijchúꞌeveꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ajta nuꞌu ɨ́ Dios ayén tɨjɨ́n: “Aꞌɨ́jna ɨ́ tɨ amuacaí tihuaꞌutáꞌixaateꞌesin, aꞌɨ́ɨ pu nuꞌu u eꞌejíihuá aꞌame jáꞌahuaꞌa ɨtzitá.” Ayen tɨjɨ́n: “Naa xu rɨ́ꞌɨ huaújruuren múꞌeen, aꞌiné aꞌɨ́ɨ pu yé uvéꞌenejsin ɨ́ tavástaraꞌa. Caxu raꞌantánaamuan ɨ́ juyáaraꞌan jetze.” ");
INSERT INTO crnNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Aꞌɨ́jna ɨ́ tɨ nuꞌu amuacaí huataseíjreꞌesin, aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Juan ɨ́ tɨ huáꞌamuaɨꞌɨhuacareꞌe. Aa pu aꞌutéveecaꞌa aꞌu tɨ caí tiꞌitɨ́ éꞌe jáꞌahuaꞌacaꞌa. Ayee pu tihuáꞌaꞌixaateꞌecaꞌa tɨ ayén tiúꞌujxeꞌeveꞌe mej seɨcɨé tiúꞌumuaꞌati mej mi miyen huárɨni aꞌij tɨ yeꞌí tíꞌijxeꞌeveꞌe ɨ́ Dios. Tɨ́ꞌɨj jí aꞌɨ́ɨn huáꞌamuaɨꞌɨhuan ɨ́ Juan tɨ ij Dios tihuaꞌutáꞌuuniꞌi ɨ́ mej jɨ́n auteájturaa ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Matɨ́ꞌɨj mi naíjmiꞌi eꞌiréꞌene aꞌu tɨ aꞌutéveecaꞌa ɨ́ Juan. Aꞌuu mú eꞌerácɨꞌɨcaꞌa tɨ́j naꞌa aꞌu tɨ huatacáꞌa aꞌujna chuéjraꞌa japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Judea, majta aꞌɨ́ɨme ɨ́ mej aꞌuun aꞌuchéjme aꞌujna chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jerusalén. Aꞌuu pu eꞌejtémeꞌecan u Judea. Jɨ́meꞌen muꞌu raataxájtacaꞌa ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi, aj pu i aꞌɨ́jna ɨ́ Juan huáꞌumuaɨꞌɨhuacaꞌa ɨ́ játeꞌana jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jordán. ");
INSERT INTO crnNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ajta Juan, ayée pu éꞌeneꞌe tiꞌitéchejcaꞌa cɨ́ɨxuri jɨmeꞌe tɨ itzíjhua tiꞌitɨ́j cameeyuꞌu juꞌuxaꞌa tɨ púꞌeen. Ajta navij típuaasicaꞌa. Aꞌɨ́ɨ pu jɨ́n aváꞌujɨꞌɨcɨeꞌecaꞌa. Ajta huátunaꞌise pu cuaꞌacareꞌe, ajta searate ꞌɨtzitá mej huáxuaavi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ayee pu tihuáꞌihuaꞌixáateꞌe tɨjɨ́n: ―Seɨ́j pu yé éꞌe véꞌeme aúcheꞌe. Jaítzeꞌe pu hui veꞌecán jɨ́n tiꞌitéjvee aꞌɨ́jna necaí inee. Aꞌɨ́j pu jɨ́n caí naavíjteꞌe ineetzi nej tiꞌitɨ́ jɨ́n tiꞌitevée náꞌaraꞌani tɨ cɨ́lieen jɨ́n seijreꞌe jemin aꞌɨ́jna tɨ yé éꞌe véꞌeme, capu xaa neꞌu naavíjteꞌe ineetzi nej ni yejtaꞌɨ́ꞌɨpɨꞌɨn ɨ́ caꞌacairaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ayee nu xaa neꞌu neri amuáamuaɨꞌɨhuacaꞌa jaj jɨmeꞌe. Mɨ́ ajtáꞌi aꞌɨ́ɨn, seɨj pu huataꞌíti tɨ huateáturan múꞌejmi jemi. Xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios pu uteáꞌasin mɨ aꞌamua tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yee pu tiujuꞌurɨ́j aꞌájna tɨ́ꞌɨj huáꞌamuaɨꞌɨhuacaꞌa ɨ́ Juan. Tɨ́ꞌɨj jí i á eꞌiréꞌene ɨ́ Jesús. Aꞌuu pu eꞌerájraa u Nazarét, chajtaꞌa tɨ eꞌejtémeꞌecan aꞌujna jáꞌahuaꞌa Galilea. Aj pu i aꞌɨ́ɨ Juan ráamuaɨꞌɨhuacaꞌa ɨ́ Jesús u játeꞌana jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jordán. ");
INSERT INTO crnNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jɨ́meꞌen puꞌu Jesús aꞌitáraa á jaataꞌa, aj pu i raaseíj tɨ antaújcu ɨ́ ta japua tɨ aꞌutéjmuaa. Ajta áꞌiyen Xɨéjniuꞌucareꞌaraꞌan huaseíj ɨ́ Dios tɨ eꞌicámeꞌecaꞌa. Yee pu seijreꞌecaꞌa tɨ́j cucuiꞌi. Aj puꞌi muꞌúutzeꞌen japua aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ajta áꞌiyen niuucari huánamuajriꞌi tɨ uj eꞌicánamuajre u ta japua. Ayee pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Niyauj pej pɨ́rɨcɨ ɨ́ nej muaxeꞌeveꞌe. Jéꞌecan pej rɨ́ꞌɨ tinaatáꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tɨ́ꞌɨj jí aꞌɨ́ɨn Xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios caꞌanéeri jɨ́n yaꞌuvíꞌitɨ ɨ́ Jesús áa jáꞌahuaꞌa ɨtzitá aꞌu tɨ caí tiꞌitɨ́ eꞌeréꞌevee. ");
INSERT INTO crnNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aꞌujna ɨtzitá, ayée pu u éꞌetee sei máxcɨraꞌi japuan tamuáamuataꞌa xɨca. Aꞌuu pu aꞌutéveecaꞌa aꞌu mej tiꞌitén aꞌucɨ́ꞌɨca mej simuáruuni. Tɨ́ꞌɨj jí aꞌɨ́ɨn ɨ́ tiyaaruꞌu tiꞌihuaújtesiꞌijre tɨ ꞌij caꞌaníjraꞌa raatáꞌan aꞌɨ́jna ɨ́ Jesús tɨ́ꞌij tiꞌitɨ́j jɨ́n autéꞌɨtzen ɨ́ Dios jemi. Aru capu ayén tejaꞌuréꞌene. Aꞌɨ́ɨ mú raatévaɨ ɨ́ Jesús ɨ́ mej títetateí u ta japua ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tɨ́ꞌɨj aiteánamiꞌihuacaꞌa ɨ́ Juan, aj puꞌi Jesús u aꞌutanéj u Galilea. Aꞌɨ́ɨ pu huaꞌutáꞌixa jɨ́meꞌen aꞌɨ́jna tɨ jɨ́n Dios tiraaꞌíjca ɨ́ Juan, aꞌɨ́jna ɨ́ Dios tɨ teꞌáijta nain japua ɨ́ chaanaca. ");
INSERT INTO crnNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ayen tɨjɨ́n: ―Puꞌuri araúraste tɨ aꞌájna tejaꞌuréꞌenejsin tɨ tiuꞌutaꞌaíjta ɨ́ Dios naíjmiꞌicɨꞌe chaanaca japua. Setáꞌaj hui seɨcɨé huárɨni, setáꞌaj siyen seɨcɨé tiúꞌumuaꞌati seꞌɨ́jna jɨmeꞌe aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Setáꞌaj seajta ráꞌantzaahuateꞌen ɨ́ niuucari tɨ jɨ́n Dios amuaꞌirájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tɨ́ꞌɨjtáꞌi ɨ́ Jesus aꞌujna eꞌejtémeꞌecaa aꞌujna vejliꞌi aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Galilea. Aj puꞌi aꞌɨ́mej huaseíj ɨ́ Simón, ajta ɨ́ Andrés tɨ juutzeájraꞌan púꞌeen ɨ́ Simón. Aꞌɨ́ɨ mú xɨéjmuaꞌari áuuhuaꞌanaa á jaataꞌa. Ayee mú tíꞌijrɨꞌɨrejcaꞌa aꞌɨ́ɨme ɨ́ mej huaꞌité huavíviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Aj puꞌi ayén tihuaꞌutáꞌixaa ɨ́ Jesús tɨjɨ́n: ―Mú seꞌutáuruyiꞌi ineetzi jemi setáꞌaj nej jamuan áꞌujujhuaꞌaneꞌen. Nee nu tejáꞌamuamuaꞌaten sej si caí chéꞌe siyen huaꞌité tíꞌiviviꞌiraꞌa, sino aꞌɨ́mej xuꞌu si caꞌaníjraꞌa huaꞌutáꞌasin ɨ́ teɨte mej mi neetzi náꞌantzaahuateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aj mú mi raatapuáꞌajtacaꞌa. Matɨ́ꞌɨj mi á téjaupíi ɨ́ xɨéjmuaꞌari meꞌájna. Matɨ́ꞌɨj mi aꞌucɨ́j jamuan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aj pu ijtáꞌi áꞌayee aꞌuréꞌene. Tɨꞌɨquí seɨj huaseíj ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Jacobo. Yaujraꞌan ɨ́ Zebedeo. Aꞌɨ́ɨ pu ajta raaseíj aꞌɨ́jna ɨ́ Juan, ɨ́ tɨ juutzeájraꞌan púꞌeen ɨ́ Jacobo. Aꞌuu mú baarcu jetze eꞌeráateꞌeca. Majta rɨ́ꞌɨ tíꞌiruurejcaꞌa ɨ́ xɨéjmuaꞌari tɨ tíꞌisiujtzaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ajta áꞌiyen Jesús huaꞌutajé. Aj mú mi raatapuáꞌajtacaꞌa ɨ́ mej xɨéjmuaꞌari rɨ́ꞌɨ tíꞌiruurejcaꞌa. Aa muꞌu yaúurɨe ɨ́ rutáàta ɨ́ baarcu jetze, ajta tɨ jemin tíꞌimuarɨꞌecaꞌa. Matɨ́ꞌɨj mi Jesús jamuan aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aj mú mi meꞌuun chajtaꞌa aꞌuteájrupi, tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Capernaúm. Tɨ́ꞌɨj teꞌaráꞌa aꞌatzaj tɨ puaꞌa eꞌireꞌenén aꞌɨ́jna xɨcájraꞌa jetze ɨ́ mej jetzen ruséꞌupihuaꞌa, aj puꞌi Jesús teyujtaꞌa aꞌuteájrupi. Aꞌuu pu tihuaꞌuhuamuáꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Aꞌɨ́jna ɨ́ Jesús, capu cháꞌanaꞌa naꞌa tihuáꞌamuaꞌatehuaꞌa matɨ́j ɨ́ seica ɨ́ mej majta aꞌuun tihuáꞌamuaꞌatehuaꞌa ɨ́ mej téꞌeyuꞌuxaca, sino ayée pu tɨ́j seɨj tɨ tiꞌitéjvee tiꞌitɨ́j jɨmeꞌe tɨ veꞌée. Aꞌɨ́j mú jɨ́n aꞌij teꞌutaseíj matɨ́ꞌɨj ráanamuajriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ajta pu seɨj aꞌutéveecaꞌa u teyujtaꞌa, tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa. Aꞌij pu puaꞌa tejaꞌuxáatayeꞌicaa aꞌɨ́jna ɨ́ tiyaaruꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Ayen tɨjɨ́n: ―Aa qui carai jéꞌecan, ¿aꞌiné hui tiꞌitɨ́j petéꞌumuaꞌaree itejmi jemi, Jesús pej piyen ántehuaa tɨjɨ́n ɨ́ pej Nazarét éꞌemeꞌecan? ¿Ni piyen mú aꞌuvéꞌemej pej taꞌantipuáꞌajteꞌen? Némuamuaꞌate jaꞌatɨ́ pej hui pɨ́rɨcɨ. Aꞌuu pej aꞌuvéꞌemej Dios jemi, ɨ́ pej yaujraꞌan púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Aj puꞌi Jesús raꞌajtéꞌaxɨ ɨ́ tiyaaruꞌu. Ayen tɨjɨ́n: ―Pecáj yee tiꞌitɨ́j xajta. Huirájraꞌa mɨ tevi jetze. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Aj aꞌɨ́ɨn ɨ́ tiyaaruꞌu raatécaꞌatzɨjxɨ ɨ́ tevi caꞌanín jɨmeꞌe. Tɨ́ꞌɨj jí huajíjhuacaꞌa aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa aꞌɨ́jna ɨ́ tevi. Aj puꞌi huirájraa ɨ́ tevi jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aj aꞌij teꞌutaseíj aꞌɨ́ɨme ɨ́ mej eꞌetiújseɨreꞌecaꞌa. Jéꞌecan mú tiújꞌixaateꞌecaꞌa seɨj ajta seɨj. Miyen tɨjɨ́n: ―¿Tiꞌitájni púꞌeen tɨ jéjcuacan jɨ́n tiꞌitéjvee? ¿Aꞌuquí éꞌemeꞌecan? Xɨee tɨ cuj tiꞌitéjvee tiꞌitɨ́j jɨmeꞌe tɨ veꞌée. Amɨ́ pu tihuáꞌaijteꞌe ɨ́ tiyáaruꞌuse. Majta meꞌɨ́n ráꞌatzaahuateꞌe aꞌij tɨ yeꞌí tihuaꞌutáꞌixaateꞌesin. ―Yee mú tiújꞌixaateꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Majta mú áꞌiyen nain japua ráamuaꞌareeriꞌi tɨ́j naꞌa u Galilea aꞌij tɨ tiꞌitɨ́ jɨ́n huarɨ́j ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Aj mú mi huiráacɨ u teyujtaꞌa. Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa Simón tɨ éꞌeche, ajta ɨ́ Andrés. Majta aꞌɨ́ɨme ɨ́ Jacobo, ajta ɨ́ Juan, aꞌɨ́ɨ mú huáꞌa jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Aꞌɨ́ɨ pu án jáꞌujcaꞌatii ɨ́ muꞌuneáraꞌan ɨ́ Simón. Aꞌɨ́ɨ pu tíꞌicuiꞌicaa. Pɨ́stacaꞌa. Matɨ́ꞌɨj mi miyen tiraataꞌixaa ɨ́ Jesús tɨjɨ́n: ―Tiꞌicuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aj puꞌi ajteáxɨɨrecaꞌa ɨ́ jemin aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj i rajvíꞌi muájcaꞌareꞌaraꞌan jetze. Tɨ́ꞌɨj jí raꞌajjáj. Aj puꞌi caꞌanacan huarúj. Ajta áꞌiyen aꞌɨ́ɨn tɨ tíꞌicuiꞌicaꞌa tihuaꞌumí. ");
INSERT INTO crnNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chumuaꞌan, tɨ́ꞌɨj ari u eꞌeteárutij ɨ́ xɨca, naíjmiꞌica mú curéꞌeviꞌitɨxɨ ɨ́ mej tíꞌicucuiꞌi, majta ɨ́ mej tiyaaruꞌu huáꞌa tzajtaꞌa seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Naíimiꞌi mú eꞌetiújseɨreꞌecaꞌa á puaꞌacɨé taꞌiténinei, matɨ́j menaꞌa mej meꞌuun eꞌechéjmeꞌe, majta u áꞌahuaꞌayee. ");
INSERT INTO crnNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Aꞌɨ́ɨ tihuáꞌuhuaa muꞌiicáca ɨ́ mej tíꞌicucuiꞌicaꞌa. Capu seica naꞌa ɨ́ cuíꞌiniꞌiraꞌa. Tɨ́ꞌɨj i Jesús huaꞌutamuári ɨ́ tiyaaruꞌu ɨ́ mej seijreꞌecaꞌa seica ɨ́ teɨte tzajtaꞌa. Jesús pu ajta caí huaꞌatáꞌacareꞌe aꞌɨ́mej ɨ́ tiyaaruꞌu mej tiuꞌutaxáj, aꞌiné méjmuaꞌatejcaꞌa jaꞌatɨ́ tɨ púꞌeeneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tapuáꞌarijmeꞌeca, tɨ́ꞌɨj auj huachuíjxa, Jesús pu ájchee. Aj puꞌi mú aꞌij huárupi. Aa pu aꞌaráꞌa jáꞌahuaꞌa ɨtzitá, aꞌutɨ́ caí tiꞌitɨ́ eꞌeréꞌevee. Aꞌuu pu huatéeniu ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ajta ɨ́ Simón, ajta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú raꞌavéꞌehuau ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Matɨ́ꞌɨj ráateu, aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Naíjmiꞌi mú muahuauhuau. ");
INSERT INTO crnNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aj puꞌi ayén tihuaꞌutáꞌixaa ɨ́ Jesús tɨjɨ́n: ―Cheꞌeré, tichéꞌe áꞌucɨɨne aꞌuun tɨ huatacáꞌa ɨ́ seica chajtaꞌaraꞌa jetze. Aꞌuu nu neajta huaꞌutáꞌixaateꞌesin ɨ́ niuucari tɨ jɨ́n Dios huaꞌirátuaasin. Ayee nu een jɨ́n u eꞌerájraa u Capernaúm. ―Ayee pu tihuaꞌutáꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tɨ́ꞌɨjí huaꞌatéyujtaꞌa tíhuaꞌihuáꞌixaa nainjapua tɨ́j naꞌa u Galilea. Ajta aꞌɨ́mej ɨ́ tiyáaruꞌuse, Jesús pu huaꞌutamuári ɨ́ mej huáꞌa tzajtaꞌa úꞌuseijreꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tɨ́ꞌɨj jí seɨ́j ajteáxɨɨrecaꞌa ɨ́ Jesús jemi. Tíꞌicuiꞌicaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. Xánaꞌaviꞌireꞌecaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ cuíꞌiniꞌiraꞌa jɨmeꞌe tɨ tineájxɨ ɨ́ huáꞌireꞌaraꞌan jetze tɨ́ꞌij huatépete ɨ́ huáꞌireꞌaraꞌan. Ayee mú ratamuáꞌamua tɨjɨ́n lepra. Tɨ́ꞌɨj i aꞌɨ́ɨn títunutacaꞌa. Rájhuaviiriꞌi ɨ́ Jesús tɨ tiráahuaateꞌen. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa muaꞌaráanajche, pej tináahuaateꞌen. ―Yee pu tiuꞌutaxájtacaꞌa ɨ́ jaꞌatɨ tɨ títunutacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Aj puꞌi Jesús huataújxɨeemɨste aꞌɨ́jna jemi tɨ́ꞌɨj raaseíj. Tɨ́ꞌɨj jí raꞌajtamuárɨej. Ayen tɨjɨ́n: ―Naꞌaráanajche pej huarún. ");
INSERT INTO crnNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ayee pu tejaꞌuréꞌene. Jɨ́meꞌen puꞌu raataxájtacaꞌa ɨ́ Jesús, tiraacáꞌariꞌiriꞌi ɨ́ tɨ jɨ́n tíꞌicuiꞌicaꞌa. Aj puꞌi huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Tɨ́ꞌɨj i aꞌɨ́ɨn Jesús jeíhua raꞌíjca tɨ nuꞌu caí raxájta aꞌij tɨ tiꞌitɨ́ huarɨ́j. Aj puꞌi áꞌuraa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Aru amuacaí pu ayén tiraataꞌixaa tɨjɨ́n: ―Casiꞌi, pecáj jaꞌatɨ́ íꞌixaateꞌe ni cɨ́j caj, sino aricu, u páꞌumeꞌen jamuan ɨ́ tɨ tíꞌivaɨreꞌe teyujtaꞌa, táꞌaj muaaseíj, pajta tiuꞌutámuaɨꞌɨvejta aꞌij tɨ tiuꞌuxájtacaꞌa ɨ́ Moisés teecan. Aꞌɨ́ɨ mú jɨ́n ramuaꞌaréeren mej tíꞌivaɨreꞌe teyujtaꞌa tɨjɨ́n pepuꞌuri huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mɨ́ ajta aꞌɨ́jna ɨ́ tevi, tɨ́ꞌɨj áꞌuraa, aꞌɨ́ɨ pu aꞌutéjche tɨ raataxáj jeíhua aꞌij tɨ tiꞌitɨ́ huarɨ́j. Nainjapua pu huaꞌuréꞌixaa seɨj ajta seɨj. Aꞌɨ́j pu jɨ́n caí chéꞌe huatárɨꞌɨristarecaꞌa tɨ Jesús aꞌuteárute ɨ́ chajtaꞌa, sino ɨtzitá puꞌu jí huáyeꞌicaa aꞌutɨ́ caí tiꞌitɨ́ eꞌeréꞌevee. Aru jaꞌanáj tɨ naꞌa, aꞌɨ́ɨ mú teɨte éꞌecɨꞌɨcaꞌa aꞌutɨ́ aꞌij éꞌeneꞌe ɨ́ Jesús. Aꞌuu mú eꞌerácɨꞌɨcaꞌa aꞌu tɨ naꞌa mej huachéjme. ");
INSERT INTO crnNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Teuuméꞌeca huaꞌapua xɨcaj, huaíca xɨcaj, ajtahuaꞌa pu aꞌɨ́ɨn Jesús aꞌuteájrupi u Capernaúm. Matɨ́ꞌɨj mi ráamuaꞌareeriꞌi ɨ́ teɨte tɨjɨ́n: “U pu nuꞌu jáꞌahuaꞌa eꞌirájca ruche.” ");
INSERT INTO crnNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Aj mú mi caꞌanacan tiújseɨj jeíhua ɨ́ teɨte, matɨ́j menaꞌa caí chéꞌe titéꞌuve u chiꞌita. Camu majta áꞌavejricaꞌa taꞌiténinei. Ajta aꞌɨ́ɨn ɨ́ Jesús, u pu ánuꞌuhuatéveecaꞌa u chiꞌita. Aꞌɨ́ɨ pu tihuáꞌaꞌixaateꞌecaꞌa aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Aꞌɨ́ɨ mú jaꞌatɨ́ aꞌuréꞌeneijte ɨ́ Jesús jemi seɨj tɨ tíꞌicuiꞌi. Cɨyáaxaraꞌacaa nainjapua ɨ́ jaꞌatɨ. Memuáacua mú mé ráachuisimeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Aru capu huatárɨꞌɨristarecaꞌa mej ruꞌuteárujteꞌen u téteꞌe aꞌutɨ́ Jesús ánuꞌuhuatéveecaꞌa, aꞌiné temuaꞌa mú tíꞌitemuꞌiicaa ɨ́ teɨte. Aꞌɨ́j mú jɨ́n, anticɨ́j án ɨmuá ɨ́ chiꞌij japua, matɨ́ꞌɨj mi raꞌanáacu ɨ́ chiꞌij. Aj mú mi ruꞌucájtuaa ɨ́ tɨ tíꞌicuiꞌi aꞌutɨ́ ánuꞌuhuatéveecaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Aj puꞌi huaꞌuseíj, ajta ayén tiuꞌumuáꞌaj tɨjɨ́n: “Metéꞌatzaahuateꞌe, micu.” Aꞌɨ́j pu jɨ́n ayén tiraataꞌixaa ɨ́ tɨ tíꞌicuiꞌi tɨjɨ́n: ―Niyauj, puꞌuri hui timuaatáꞌuuniꞌiriꞌi ɨ́ Dios ɨ́ pej jɨ́n auteájturaa ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Majta á vejliꞌi seica meꞌuun eꞌiráꞌuu ɨ́ mej téꞌeyuꞌuxaca ɨ́ ruyeꞌirá jɨmeꞌe. Matɨ́ꞌɨj meꞌɨ́jna huánamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa ɨ́ Jesús, matɨ́ꞌɨj mi miyen tiuꞌumuáꞌaj ɨ́ ru tzajtaꞌa tɨjɨ́n: “¿Aꞌiquí een jɨ́n ayén tiꞌixa amɨ́jna mɨ tevi? Aꞌij pu puaꞌa, xaa neꞌu, tiꞌixa. Capu hui aꞌɨ́jna jɨ́n antiújmuaꞌaree amɨ́jna tɨ seɨj tiuꞌutáꞌuuniꞌi ɨ́ tɨ jɨ́n auteájturaa ɨ́ Dios jemi. Aꞌɨ́ɨ puꞌu ɨ́ Dios antiújmuaꞌaree tɨ ayén seɨj tiuꞌutáꞌuuniꞌi.” Yee mú téꞌumuaꞌatzejcaꞌa aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca ɨ́ ruyeꞌirá jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu ru tzajtaꞌa rúꞌumuaꞌareerecaꞌa aꞌij mej yeꞌí tíꞌimuaꞌatzejcaꞌa ɨ́ ru tzajtaꞌa. Tɨ́ꞌɨj i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné een jɨ́n siyen téꞌumuaꞌatze ɨ́ ru tzajtaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tiꞌitájni caí muárɨꞌeri? ¿Ni qui nej niyen tiraataꞌixaateꞌen ɨ́ tɨ cɨyáaxaraꞌa yee: “Puꞌuri timuaatáꞌuuniꞌiriꞌi ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi”, naꞌari yee: “Ájchesi, patáꞌaj ráꞌanchueni muáꞌutaatzi; pajta yee áꞌuraꞌani”? ");
INSERT INTO crnNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Ayee nu xaa neꞌu rɨni tɨ́j ɨ́ nevástaraꞌa, ɨ́ tɨ jíꞌi Dios, setáꞌaj ráamuaꞌaree, i nej neajta teáataꞌa jetze airáane, neajta nu neꞌíjna jɨ́n antínmuaꞌaree íiyen chaanaca japua nej ni tihuaꞌutáꞌuuniꞌi ɨ́ mej jɨ́n ateáturaaveca ɨ́ Dios jemi. ―Yee pu tihuaꞌutáꞌixaa ɨ́ Jesús. Aj puꞌi ayén tiraataꞌixaa ɨ́ tɨ cɨyáaxaraꞌa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe. Ájchesi, pajta ráꞌanchueeni muáꞌutaatzi. Aricu aꞌu pej éꞌeche. ");
INSERT INTO crnNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ajta áꞌiyen aꞌɨ́ɨn tɨ tíꞌicuiꞌicaꞌa, aꞌɨ́ɨ pu ájchee. Ráꞌajchui ɨ́ rúꞌutaatzi. Tɨ́ꞌɨj i áꞌuraa, metiꞌiseíiracaꞌa ɨ́ teɨte. Aꞌɨ́j mú jɨ́n naímiꞌi aꞌij teꞌutaseíj. Rɨ́ꞌɨ mú tiraatáꞌa ɨ́ Dios. Miyen tɨjɨ́n: ―Catu jaꞌanáj tiꞌitɨ́j huaseíj tetɨ́j íjii. Yee mú tiuꞌutaxájtacaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tɨ́ꞌɨj jí ajtahuaꞌa Jesús aꞌuun áꞌume aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj. Aa mú aꞌuréꞌenineicaꞌa naímiꞌi ɨ́ teɨte jemin ɨ́ Jesús. Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu huáꞌaꞌixaateꞌecaꞌa ɨ́ niuucari tɨ jɨ́n Dios huaꞌirájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Aj puꞌi ayée aꞌuréꞌene. Tɨ́ꞌɨj jí aꞌuun ɨ́ Leví huaseíj, ɨ́ tɨ iꞌi yaujraꞌan aꞌɨ́jna ɨ́ Alfeo. Aꞌuu pu anúꞌujcatii chiꞌita mej tzajtaꞌan tíꞌitejiꞌivi ɨ́ mej tíꞌitɨꞌɨcɨca. Aj puꞌi Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj nee jamuan áꞌucheꞌecaneꞌen. Aj puꞌi aꞌɨ́ɨn ájchee ɨ́ Leví. Tɨ́ꞌɨj jí áꞌume jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tɨ́ꞌɨj jí ayén tiujuꞌurɨ́j matɨ́ꞌɨj aꞌaráꞌa ɨ́ Leví tɨ éꞌeche. Jesús pu aꞌɨ́mej jamuan tíꞌicuaꞌacaa ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte. Aꞌɨ́ɨ mú aꞌɨ́ɨn pɨ́rɨcɨ ɨ́ mej huáꞌajijveꞌe ɨ́ mej tíꞌitɨꞌɨcɨca, majta ɨ́ mej caí xɨ́ꞌepɨꞌɨn rɨjca. Aꞌɨ́ɨ mú tíꞌicuaꞌacaa meesa japua jamuan ɨ́ Jesús, majta seica ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Naíjmiꞌi mú tíꞌicuaꞌacaa aꞌiné memuꞌiicáa ɨ́ mej áꞌujujhuaꞌaneꞌe ɨ́ Jesús jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Majta seica áꞌa vejliꞌi cɨɨnecaꞌa. Aꞌɨ́ɨ mú aꞌɨ́ɨn púꞌeen ɨ́ mej tiúꞌujmuaꞌate aꞌij tɨ tiuꞌuxájtacaꞌa ɨ́ Moisés teecan. Jeíhua mú nuꞌu raxɨ́ꞌeveꞌe ɨ́ ruyeꞌirá. Ayee mú ánteꞌarua aꞌɨ́ɨme tɨjɨ́n fariseo. Aꞌɨ́ɨ mú miyen tiuꞌuséij jaꞌatén mej jamuan tíꞌicuaꞌacaa ɨ́ Jesús. Aj mú mi miyen aꞌɨ́mej tiuꞌutáꞌixaa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―¿Aꞌiné een jɨ́n aꞌɨ́ɨn áꞌamuamaestru tíꞌicuaꞌaca, ajta yeꞌeca huáꞌa jamuan ɨ́ mej tíꞌitejiꞌivi, ajta huáꞌa jamuan ɨ́ mej caí xɨ́ꞌepɨꞌɨn rɨcɨ? Ayee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate yúꞌuxareꞌaraꞌan jetze ɨ́ Moisés, aꞌɨ́ɨme ɨ́ mej huáꞌa jetze ajtémeꞌecantacaꞌa ɨ́ fariseo. ");
INSERT INTO crnNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tɨ́ꞌɨj aꞌɨ́ɨn huáꞌunamuajriꞌi ɨ́ Jesús, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe. Ayee pu tíꞌeen jɨ́meꞌen ɨ́ teɨte ɨ́ mej meꞌuun aꞌuréꞌenineꞌi jemin ɨ́ tɨ yaꞌanaca. Capu ruxeꞌeveꞌe mej meꞌɨ́n aꞌuréꞌenineꞌicaꞌan ɨ́ jemin aꞌɨ́ɨme ɨ́ mej rɨ́ꞌen, sino aꞌɨ́ɨ mú xaa aꞌuréꞌenineꞌi ɨ́ tɨ yaꞌanaca jemi ɨ́ mej tíꞌicucuiꞌi. Ayee pu cheꞌatá naꞌa een ineetzi jemi. Canu neꞌíjna jɨ́n yevéꞌeme nej neꞌíjme huatáꞌinen ɨ́ mej miyen tiúꞌujseijrata yee mej xɨ́ꞌepɨꞌɨn rɨcɨ, sino aꞌímej nu jemi yé véꞌeme ɨ́ mej miyen tirúꞌumuaꞌaree ɨ́ ru tzajtaꞌa mej caí xɨ́ꞌepɨꞌɨn rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tɨ́ꞌɨj jí ayén tiujuꞌurɨ́j. Aꞌɨ́ɨ mú rúꞌitziꞌiveꞌecaꞌa ɨ́ mej Juan jamuan áꞌujujhuaꞌaneꞌe, majta ɨ́ fariseo. Matɨ́ꞌɨj mi seica eꞌiréꞌene ɨ́ Jesús jemi. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné een jɨ́n maúrɨitziꞌivij ɨ́ mej Juan jamuan áꞌujujhuaꞌan, majta aꞌɨ́ɨme ɨ́ fariseo? Mɨ majta, ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan, camu miyen rɨcɨ. ―Yee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Aj puꞌi Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ huaténeɨche, aj puꞌi aꞌɨ́mej huatáꞌineesin ɨ́ mej ráꞌajaahuateꞌe mej mi tiúꞌuyesten. Aj puꞌi aꞌɨ́ɨn tihuáꞌamin. ¿Ni qui rɨꞌɨrí mej rúꞌitziꞌiveꞌeca tɨ puaꞌa huáꞌa jamuan auj tíꞌiyeste ɨ́ jaꞌatɨ? Capu xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Aru jee, aj pu tejaꞌuréꞌenejsin ɨ́ xɨca ɨ́ mej jetzen ráꞌaviꞌitɨn ɨ́ jaꞌatɨ. Aj mú xaa meꞌɨ́n ɨ́ mej ráꞌajaahuateꞌe ruꞌítziꞌiveꞌen aꞌiné capu chéꞌe huáꞌa jamuan aꞌutéjvee ɨ́ mej ráꞌajaahuateꞌe. Aꞌiné inee, naúcheꞌe nu yé huatéjvee, camu ruꞌítziꞌiveꞌen ɨ́ mej náꞌajaahuateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Nicheꞌe seɨj amuaatáꞌixaateꞌen ɨ́ chuijtari. Tɨ́ puaꞌa jaꞌatɨ́ aꞌɨ́jna huaújcuꞌuneꞌepeꞌen ɨ́ cɨ́ɨxuri tɨ míꞌimeꞌecan, capu aꞌɨ́jna jamuan rucúꞌuneꞌepeꞌen ɨ́ cɨ́ɨxuri jɨmeꞌe tɨ caí xɨ jaꞌanáj jáꞌusiniꞌi. Huatétzuꞌuta aꞌɨ́jna ɨ́ cɨ́ɨxuri tɨ jéjcua tɨ́ꞌɨj huatéjaꞌusiniꞌihua. Tɨ́ꞌɨj i rasiújtzaꞌanan ɨ́ tɨ míꞌimeꞌecan. Aj puꞌi aꞌɨ́jna tɨ anásiujtzaꞌani, jaítzeꞌe pu veꞌetɨ́ anásiujtzaꞌani aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","’Ajta, capu tiꞌitɨ́ vaɨreꞌe tɨ puaꞌa jaꞌatɨ́ ruꞌucájtuꞌani navij limeetajraꞌa tzajtaꞌa tɨ racuaꞌiríihuajme nahuáj ɨ́ mej mauchén ráataahuacaꞌa. Tɨ́ puaꞌa miyen ráaruuren aꞌɨ́jna ɨ́ nahuáj tɨ jéjcua, aꞌɨ́ɨ pu huatéveꞌeri, ajta raꞌanasiújtzaꞌana ɨ́ navij tɨ racuaꞌiríihuajme. Tɨ́ꞌɨj jí aꞌuvaɨ́jtzi ɨ́ navij, ajta ɨ́ nahuáj. Aꞌɨ́j pu jɨ́n ayén tiúꞌujxeꞌeveꞌe tɨ ruꞌucájtuꞌani ɨ́ navij tzajtaꞌa tɨ jéjcua aꞌɨ́jna ɨ́ nahuáj tɨ ajta jéjcua. ");
INSERT INTO crnNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tɨ́ꞌɨj jí ayén tiujuꞌurɨ́j. Aꞌɨ́jna xɨcájraꞌa jetze mej ruséꞌupihuaꞌa, aꞌúu pu auméꞌecaa jáꞌitaꞌa ɨ́ viꞌiraꞌa japua ɨ́ Jesús. Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨme mú autéjhuii mej rúꞌijtzaanaxɨꞌɨn tiꞌitɨ́ teuuri jatzeꞌe aꞌiné jeíhua mú tɨejcucaꞌa. Aꞌuu mú aꞌatajúꞌucaꞌa meruꞌijtzáꞌana. ");
INSERT INTO crnNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Majta meꞌɨ́n ɨ́ fariseo, matɨ́ꞌɨj huaꞌuseíj mej miyen rɨjcaꞌa, aj mú mi miyen tiraataꞌixaa ɨ́ Jesús. Miyen tɨjɨ́n: ―Casiꞌi, ¿aꞌiné een jɨ́n miyen rɨcɨ aꞌɨ́ɨme ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan? Capu hui aꞌij tíꞌirɨꞌɨri tɨ jaꞌatɨ ayén rɨjca aꞌɨ́jna ɨ́ xɨcájraꞌa jetze mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Aj puꞌi huaꞌutáꞌixa ɨ́ Jesús. Ayen tɨjɨ́n: ―Nicheꞌe aꞌatzu tejamuáꞌixaateꞌen. ¿Ni secaí múꞌeen jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze aꞌij tɨ yeꞌí huarɨ́j ɨ́ David teecan tɨ́ꞌɨj huatáꞌicuatacaꞌa, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe? Tɨ́ꞌɨj nuꞌu tiꞌitéveecaꞌa ɨ́ Abiatar teecan aꞌɨ́jna jɨmeꞌe tɨ tihuáꞌaijteꞌe ɨ́ mej tíꞌivaɨreꞌecaꞌa teyujtaꞌa, aꞌúu pu aꞌuteájrupi ɨ́ David. Ajta aꞌɨ́ɨn ɨ́ pan ɨ́ mej Dios huatámuaɨꞌɨvejte u teyujtaꞌa, aꞌɨ́ɨ muꞌu nuꞌu racuaꞌaca ɨ́ mej tíꞌivaɨreꞌe aꞌujna teyujtaꞌa. Capu máa jaꞌatɨ́ racuaꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","’Mɨ́ ajta aꞌɨ́ɨn ɨ́ David, aꞌii pu caí teyujtaꞌa tíꞌivaɨreꞌecaꞌa. Capu aꞌij tiꞌitɨ́ huarɨ́j. Aꞌɨ́ɨ pu nuꞌu ráacua aꞌɨ́jna ɨ́ pan ɨ́ mej Dios huatámuaɨꞌɨvejte. Ajta tihuaꞌumí ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Capu aꞌatzu auteájturaa ɨ́ David teecan ɨ́ Dios jemi. ―Ayee pu tihuaꞌutáꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Ajta Jesús ayén tihuaꞌutáꞌixaa. Ayen tɨjɨ́n: ―Aꞌɨ́jna xɨcájraꞌa jetze ɨ́ mej jetzen ruseꞌupi, ayée pu Dios tiraaxɨ́ꞌepɨꞌɨntare tɨ́ꞌij huaꞌutévaɨreꞌen ɨ́ teɨte. Capu ayée naꞌa ayén tiraaxɨ́ꞌepɨꞌɨntare ɨ́ Dios mej mi araúrasten menaꞌa aꞌɨ́jna xɨcájraꞌa ɨ́ mej jetzen ruseꞌupi. Aꞌɨ́j nu jɨ́n, inee i nej neajta teáataꞌa jetze airáane, ayée nu een jɨ́n antínmuaꞌaree neajta neꞌɨ́jna xɨcájraꞌa jetze matɨ́ꞌɨj ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tɨ́ꞌɨj jí ajtahuaꞌa aꞌuteájrupi teyujtaꞌa ɨ́ Jesús. Seɨ́j pu únuꞌuhuatéveecaꞌa. Tiꞌicuiꞌi aꞌɨ́jna, cɨyáaxaraꞌa ɨ́ rumuájcaꞌa jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Majta mú meꞌɨ́n unuꞌuhuatéꞌuucaꞌa ɨ́ fariseo. Aꞌɨ́ɨ mú ráꞌeeveꞌecaꞌa ɨ́ Jesús, aisí tɨ puaꞌa aꞌɨ́ɨn caí tiráahuaateꞌen ɨ́ tɨ tíꞌicuiꞌi. Aj pu ajtahuaꞌa pɨ́tíꞌirɨjca ɨ́ xɨcájraꞌa ɨ́ mej jetzen ruseꞌupi. Aꞌɨ́ɨ mú fariseo rumuaꞌatzíiteꞌecaꞌa ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Aj puꞌi Jesús ayén tiraataꞌixaa ɨ́ tɨ cɨyáaxaraꞌa ɨ́ rumuájcaꞌa jetze, tɨjɨ́n: ―Ájchesi. Huatéechaxɨ íiye jáꞌitaꞌa. ―Yee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ajta áꞌiyen huaꞌutáꞌixa ɨ́ seica. Ayen tɨjɨ́n: ―¿Tiꞌitáni íꞌirɨꞌɨri tɨ jaꞌatɨ ayén huárɨni tɨ́ꞌɨj aꞌájna tejaꞌuréꞌenen, aꞌɨ́jna xɨcájraꞌa mej jetzen ruseꞌupi? ¿Ni ayén tiraavíjteꞌe tɨ jaꞌatɨ ayén huárɨni ɨ́ tɨ xɨ́ꞌepɨꞌɨn jɨ́n seijreꞌe, naꞌari ɨ́ tɨ tiraacuíꞌinteꞌen? Ajta, ¿ni qui iꞌi xɨ́ꞌepɨꞌɨn nej niyen huárɨni aꞌɨ́jna xɨcájraꞌa jetze mej jetzen ruseꞌupi nej ni iráarujteꞌen nemɨ́jna mɨ jaꞌatɨ tɨ́ꞌij caí huámɨꞌɨni, naꞌari nej ni raatáꞌan tɨ huámɨꞌɨni? ―Yee pu tiuꞌutaxájtacaꞌa ɨ́ Jesús. Mɨ́ majta meꞌɨ́n ɨ́ seica, camu aꞌij tiuꞌutaxájtacaꞌa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Aj puꞌi Jesús huaꞌuseíirajraa. Acaujtzáahuateꞌe yee cumu tɨ́j niuꞌucamɨꞌɨ. Ajta huataújxɨeemɨste huáꞌa jemi aꞌiné camu raxɨ́ꞌeveꞌecaꞌa mej ráanamua. Aj puꞌi aꞌɨ́ɨn ayén tiuꞌutáꞌixaa aꞌɨ́jna tɨ tíꞌicuiꞌi tɨjɨ́n: ―Huatátzeaara mɨ áꞌamuajcaꞌa. Aj puꞌi aꞌɨ́ɨn ɨ́ teáataꞌa, raatátzeaaracaꞌa ɨ́ rumuájcaꞌa. Jɨ́meꞌen puꞌu raatátzeaaracaꞌa, aj puꞌi huarúj ɨ́ jaꞌatɨ ɨ́ rumuájcaꞌa jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aj mú mi huiráacɨ aꞌɨ́ɨme ɨ́ fariseo. Matɨ́ꞌɨj mi autéjhuii mej raaxɨ́ꞌepɨꞌɨntareꞌen seica jamuan aꞌij mej yeꞌí huárɨni mej mi raajéꞌica ɨ́ Jesús. Aꞌɨ́ɨme ɨ́ seica, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej áꞌujujhuaꞌan jamuan ɨ́ tajtuhuan tɨ veꞌée. Ayee pu ántehuaa aꞌɨ́jna tɨjɨ́n Heródes. ");
INSERT INTO crnNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Tɨ́ꞌɨj jí áꞌuraa ɨ́ Jesús. Aa pu aꞌaráꞌa aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj. Majta mú jamuan aꞌucɨ́j ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Jeíhua mú majta teɨte aꞌucɨ́j jamuan ɨ́ mej meꞌuun aꞌuchéjmeꞌecaa u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Matɨ́ꞌɨj ráamuaꞌareeriꞌi aꞌij tɨ tiꞌitɨ́ huáruu ɨ́ Jesús, tɨ ayén jaítzeꞌe raayɨ́ꞌɨtɨhuaꞌa caí máa jaꞌatɨ́, jeíhua mú majta meꞌuun aꞌarácɨꞌɨcaꞌa aꞌujna u Judea, majta aꞌujna u Jerusalén. Aꞌuu mú majta aꞌarácɨꞌɨcaꞌa u Idumea. Majta seica mej aꞌuchéjmeꞌecaa u Tiro, majta u Sidón. Seica mú majta aꞌitacɨ́ꞌɨcaꞌa utavén pújmeꞌen ɨ́ Jordán. ");
INSERT INTO crnNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Aꞌiné puꞌuri tihuáꞌuhuaꞌateꞌecaꞌa jeíhua ɨ́ mej tíꞌicucuiꞌicaꞌa, jeíhua mú ɨ́ mej tiꞌicúcuiꞌijme ajteáxɨɨrecaꞌa aꞌu tɨ aꞌutéveecaꞌa ɨ́ Jesús. Muaꞌitávatzɨjxɨ aꞌájna vejliꞌi jemin. Jeíhua mú raꞌajtamɨ́jhuaꞌa aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j pu jɨ́n aꞌɨ́ɨn huaꞌutaꞌaíj mej jamuan áꞌujujhuaꞌaneꞌe mej baarcu ráahuaviitzeꞌen tɨ jetzen atéeyeijxɨꞌɨn mej mi caí ratzíinajyeꞌican ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Majta meꞌɨ́n tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌecaꞌa, matɨ́ꞌɨj raaseíj ɨ́ Jesús, aj mú mi títunutaxɨ vejliꞌi jemin. Ayee mú titeejíjhuacaꞌa tɨjɨ́n: ―Múꞌee pej hui iꞌi yaujraꞌan ɨ́ Dios. ―Yee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Aru Jesús, tɨ́ꞌɨj huaꞌajtéꞌaxɨ, aj puꞌi ayén tíhuaꞌutaꞌaíj mej caí miyen rɨjca, mej raxájta jaꞌatɨ́ tɨ pɨ́rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Aj puꞌi án aꞌujnéj ɨ́ jɨrí jetze, aꞌiné puꞌuri rúꞌumuaꞌareerecaꞌa aꞌachú mej puaꞌamé ɨ́ tɨ tíhuaꞌutaꞌaíjteꞌesin. Aj puꞌi huaꞌutajé. Matɨ́ꞌɨj mi á veꞌeréꞌene ɨ́ tɨ huaꞌavéꞌejajpuaxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tamuáamuataꞌa japuan huaꞌapua mú aꞌaráꞌaxcan ɨ́ tɨ huaꞌavéꞌejajpuaxɨ. Aj puꞌi aꞌɨ́ɨn tihuaꞌuꞌíjca aꞌɨ́jna jɨmeꞌe mej áꞌujujhuaꞌaneꞌen jamuan, majta huaꞌutáꞌixaateꞌen ɨ́ teɨte ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aꞌɨ́ɨ pu ajta huauꞌíjca aꞌɨ́jna jɨmeꞌe mej antiújmuaꞌareere mej mi miyen tihuáꞌuhuaateꞌen ɨ́ mej tíꞌicucuiꞌi, ajta mej majta huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌe ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Jesús pu aꞌɨ́ɨn huatajé ɨ́ Simón. Tɨ́ꞌɨj jí ayén raatamuáꞌa tɨjɨ́n Pedro. ");
INSERT INTO crnNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ajta pu aꞌɨ́ɨn ɨ́ Jacobo, ajta juutzeájraꞌan ɨ́ Juan. Aꞌii mú meꞌɨ́n pɨ́rɨcɨ yaújmuaꞌameꞌen ɨ́ Zebedeo. Tɨ́ꞌɨj jí aꞌɨ́jna ɨ́ Jesús ayén huaꞌutamuáꞌa ɨ́ runiuuca jɨmeꞌe tɨjɨ́n Boanerges. Ayee pu huataújmuaꞌa aꞌɨ́jna tɨjɨ́n Yaújmuaꞌameꞌen ɨ́ mej Téjniuuve. ");
INSERT INTO crnNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Seica pu ajta huatajé. Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ Andrés, ajta aꞌɨ́ɨn ɨ́ Felipe, ajta ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Bartolomé, ajtahuaꞌa seɨj ɨ́ Mateo, ajta ɨ́ Tomás, ajta aꞌɨ́jna ɨ́ Santiago, ɨ́ tɨ yaujraꞌan púꞌeen aꞌɨ́jna ɨ́ Alfeo, ajta ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Tadeo. Aꞌɨ́j pu ajta huatajé aꞌɨ́jna ɨ́ Simón ɨ́ tɨ áꞌucheꞌecaneꞌe huáꞌa jamuan mej miyen huataújmuaꞌa tɨjɨ́n cananista. ");
INSERT INTO crnNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Aꞌɨ́j pu ajta huatajé ɨ́ Judás tɨ ayén teꞌentímuꞌutaca tɨjɨ́n Iscariotes. Aꞌɨ́jna ɨ́ Judás, aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeen tɨ avíitzi jɨ́n huaꞌutátuire aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tɨ́ꞌɨj jí áꞌuraa ɨ́ Jesús. Aj puꞌi chiꞌita áꞌa aꞌuteájrupi, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majtahuaꞌa mú jeíhua ajteáxɨɨrecaꞌa ɨ́ teɨte, ca chéꞌe huatárɨꞌɨristarecaꞌa mej tiúꞌucuaꞌani aꞌɨ́jna jɨmeꞌe mej jeíhua teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Aj mú mi ráamuaꞌareeriꞌi ɨ́ ihuáamuaꞌameꞌen ɨ́ Jesús aꞌu tɨ aꞌɨ́ɨn aꞌij éꞌeneꞌe. Aj mú mi aꞌuréꞌene mej mi ráꞌanviꞌitɨn. Ayee mú een jɨ́n huarɨ́j aꞌɨ́jna jɨmeꞌe tɨ nuꞌu huateújtɨmuaꞌiriꞌi ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Majta meꞌɨ́n ɨ́ mej téꞌeyuꞌuxaca teyujtaꞌa, ɨ́ mej meꞌuun eꞌeráacɨ u Jerusalén, ayée mú tíꞌixajtacaꞌa aꞌɨ́ɨme. Miyen tɨjɨ́n: ―Beelzebú pu hui jetze araújcaꞌane amɨ́jna mɨ tevi. Beelzebú ɨ́ tɨ tihuáꞌaijteꞌe naíjmiꞌica ɨ́ tiyáaruꞌuse, aꞌɨ́jna Beelzebú pu caꞌaníjraꞌa ratáꞌaca amɨ́jna tɨ huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse. ―Ayee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu huaꞌutajé aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca mej mi ráanamua ɨ́ niuucari tɨ jɨ́n tihuáꞌamuaꞌaten. Ayen tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ Satanás ruseɨ́j huaꞌutamuáriteꞌen ɨ́ ruteɨ́testemuaꞌa? Capu aꞌij tíꞌirɨꞌɨri. ");
INSERT INTO crnNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ayej cheꞌatá naꞌa, tɨ puaꞌa chajtaꞌaraꞌa jáꞌitaꞌa maꞌutácɨɨne, tɨ puaꞌa miyen huárɨni, aj mú mi tiújneꞌusiꞌiteꞌesin. Matɨ́ꞌɨj aꞌutácɨɨne jáꞌitaꞌa aꞌɨ́jna ɨ́ chajtaꞌaraꞌa, capu chéꞌe áꞌateere. ");
INSERT INTO crnNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ajta, tɨ puaꞌa teɨtestemuaꞌameꞌen ɨ́ jaꞌatɨ, miyen cheꞌatá menaꞌa jáꞌitaꞌa aꞌutácɨɨne, camu chéꞌe áꞌateere ɨ́ teɨtestemuaꞌameꞌen aꞌájna aꞌu tɨ éꞌeche ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","’Ayej cheꞌatá naꞌa, tɨ puaꞌa Satanás ayén huárɨni aꞌutɨ́ éꞌeche, tɨ puaꞌa aꞌɨ́ɨn huaꞌuténeꞌusiꞌiteꞌen ɨ́ ruteɨ́testemuaꞌa, aꞌɨ́ɨ pu ajta caí chéꞌe áꞌateere, sino aꞌɨ́ɨ pu teꞌentipuáꞌajteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Seɨj nu neajtahuaꞌa huataxájta ɨ́ niuucari. Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ tiraanáhuaꞌi tiꞌáꞌaraꞌan tɨ á éꞌeche ɨ́ tɨ rucaꞌané, amuacaí pu ruxeꞌeveꞌe tɨ raꞌatéjɨꞌɨcɨꞌen ɨ́ tɨ rucaꞌané. Aj pu xaa rɨꞌɨrí tɨ uteárute aꞌu tɨ éꞌeche tɨ́ꞌij tiraanáhuaꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ayej xaa neꞌu tiꞌayajna, aꞌɨ́mej jɨmeꞌe ɨ́ teteca, rɨꞌɨrí tɨ tihuaꞌutáꞌuuniꞌi naíjmiꞌica ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi, ajta naíjmiꞌica ɨ́ mej aꞌij puaꞌa tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Aru, tɨ puaꞌa jaꞌatɨ́ aꞌij puaꞌa tíꞌixajta aꞌɨ́jna jetze ɨ́ Xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, capu xaa neꞌu jaꞌanáj tiraatáꞌuuniꞌira aꞌɨ́jna. Aꞌɨ́ɨ pu ruꞌitéꞌaa aꞌame tɨ́j naꞌa rusén jɨmeꞌe. ―Yee pu tiuꞌutaxájtacaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ayee pu Jesús tihuaúꞌixaa aꞌɨ́jna jɨmeꞌe mej miyen tíꞌixajtacaꞌa tɨ nuꞌu tiyaaruꞌu tzajtaꞌan seijreꞌecaꞌa, mej mi miyen tiráamuaꞌaree tɨ aꞌɨ́ɨn Jesús aꞌɨ́jna jetze aráujcaꞌanejcaꞌa ɨ́ Xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, tɨ́ꞌij ayén huárɨni tiꞌitɨ́j jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ajta aꞌɨ́ɨn náànajraꞌan, majta aꞌɨ́ɨme ɨ́ júutzimuaꞌameꞌen, aꞌɨ́ɨ mú u aꞌaráꞌa. Aa mú aꞌutéhuiixɨ menaꞌa puaꞌacɨé. Aj mú mi raatachúꞌeve. ");
INSERT INTO crnNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Majta meꞌɨ́n ɨ́ mej huiiráteꞌecaꞌa jamuan ɨ́ Jesús, aꞌɨ́ɨ mú raatáꞌixaa, miyen tɨjɨ́n: ―Mé mú aꞌutéꞌuu puaꞌacɨé anaanaj, majta áꞌajuutzimuaꞌa. Mémuahuahuau, micu. ―Ayee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aj puꞌi ayén tiuꞌutaniú ɨ́ Jesús. Ayen tɨjɨ́n: ―¿Aꞌataani meꞌɨ́n púꞌeen ɨ́ mej nináàna nusu neꞌihuaamuaꞌa? ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tɨ́ꞌɨj jí huaꞌuseíirajraa ɨ́ teɨte ɨ́ mej aꞌitecaíjmeꞌeca ɨ́ jemin. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej nináàna, majta ɨ́ nejúutzimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Aꞌachú mej puaꞌamé miyen tiráꞌaste aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej nináàna, majta aꞌɨ́ɨme ɨ́ nejúutzimuaꞌa. ―Ayee pu tihuaꞌutáꞌixaa. Tɨ́ꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aj puꞌi Jesús aj aꞌucáane aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj tɨ́ꞌij ajtahuaꞌa tihuáꞌumuaꞌaten. Aj mú mi jeíhua ajteáxɨɨrecaꞌa ɨ́ teɨte aꞌu tɨ aꞌutéveecaꞌa. Temuaꞌa mú tíꞌitemuꞌiicaa ɨ́ teɨte. Aꞌɨ́j pu jɨ́n ateájraa ɨ́ baarcu jetze tɨ jaataꞌa eꞌecáveꞌecaꞌa. Majta meꞌɨ́n ɨ́ teɨte, áa mú aꞌucaíjmeꞌecaa jaꞌapuaíri japua. ");
INSERT INTO crnNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Jéihua pu tihuáꞌaꞌixaateꞌecaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ chuijtari. Ayee pu tihuaúꞌixaa seɨj jɨmeꞌe ɨ́ niuucari. Ayen tɨjɨ́n: ―Xaanamuajriꞌi múꞌeen. Jaꞌatɨ́ tɨ nuꞌu tíꞌihuastehuaꞌa, u pu áꞌume tɨ tejéꞌehuasteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aa pu auméꞌecaa ratáhuaꞌanáa ɨ́ imueꞌeri. Seica pu juye jetze aꞌuvatzɨ́jraa. Aj mú mi pinaꞌase júteꞌe ɨmuá aveꞌecáane, meraaréꞌejeꞌipɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","’Ajta nuꞌu seica huavatzɨ́jraa tetej tzajtaꞌa aꞌu tɨ caí jeíhua chuej áꞌuca. Yee puꞌi tejaꞌuréꞌene, aꞌiné capu huatétee ɨ́ chuej tɨ tzajtaꞌan iruꞌucárutixɨꞌɨn ɨ́ jíineꞌaraꞌan, caꞌanacan pu huaréꞌepɨstacaꞌa ɨ́ chuej. Aj puꞌi caꞌanacan ajneájxɨ ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ajta tɨ́ꞌɨj u eꞌiréꞌene ɨ́ xɨcaj, tɨ́ꞌɨjí huaréꞌehuaa xɨcaj jɨmeꞌe ɨ́ tɨ tiuꞌunéj. Aꞌiné capu ajtanáanaꞌajmeꞌecaꞌa, aꞌɨ́j pu jɨ́n huaréꞌehuaa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","’Ajta seica ɨ́ imueꞌeri, aꞌúu pu aꞌuvatzɨ́jraa aꞌu tɨ tzicareꞌe aꞌuvéjmeꞌecaa. Tɨ́ꞌɨj aꞌɨ́ɨn tzicareꞌe huavaújse, tɨ́ꞌɨjí aꞌɨ́ɨn tzicareꞌe raꞌaváꞌana aꞌɨ́jna tɨ tiuꞌunéj. Aꞌɨ́j pu jɨ́n caí huácɨɨrecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","’Aru seica pu nuꞌu aꞌuun aꞌuvatzɨ́jraa aꞌu tɨ aꞌurɨ́ꞌen ɨ́ chuej. Aꞌɨ́ɨ pu huanéj. Tɨ́ꞌɨj huavaújse, aj puꞌi temuaꞌa tiúꞌucɨɨrecaꞌa. Seica ɨ́ imueꞌeri, ayée pu catéꞌetejmeꞌecaa ɨ́ cuuxaꞌa jetze seɨj tɨ ajtanéj ɨ́ ꞌicɨɨri aꞌachú cumu seité japuan tamuáamuataꞌa ɨ́ jatzi. Ajta seica ayén catéꞌetejmeꞌecaa aꞌachú cumu huaícate. Ajta seica, anxɨ́te pu catéꞌetejmeꞌecaa seɨj ajta seɨj. ―Yee pu tiuꞌutaxájtacaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ajta ayén tihuaúꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ rarɨ́ꞌɨrejmɨꞌɨ, chéꞌe aꞌɨ́ɨn huaruitɨejteꞌen temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Matɨ́ꞌɨj mi aꞌucɨ́j ɨ́ teɨte. Aru camu naíjmiꞌi. A pu aꞌuteájturaa ɨ́ Jesús, majta seica ɨ́ mej naímiꞌi áꞌujujhuaꞌaneꞌe huáꞌa jamuan ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi aꞌij tɨ huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨ raaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ajta aꞌɨ́ɨn Jesús, ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌejmi pu Dios tiúꞌixaa eꞌehuaruitɨéecan jɨmeꞌe aꞌɨ́jna ɨ́ tɨ huateúꞌavaatacaꞌa ɨ́ Dios jemi aꞌiquí tíꞌiseijreꞌe aꞌame aꞌɨ́jna xɨcájraꞌa jetze tɨ́ꞌɨj Dios tíꞌitaꞌaíiteꞌe aꞌame íiyen chaanaca japua. Aru amɨ́mej mej mé aꞌutéꞌuu puaꞌacɨé puaꞌacɨé, nain pu tihuáꞌitɨiiran chuijtari jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ayee pu tihuáꞌaruure. Tɨ́ꞌɨj tihuaúꞌixaateꞌe ɨ́ niuucari jetze, seica mú miyen tiúꞌumuaꞌati tɨjɨ́n: “Cu xɨee teyaúꞌitɨe iteen.” Ajta matɨ́ꞌɨj ranamuajran, miyen tɨjɨ́n: “Tuꞌiteájnamua iteen.” Aru capu xaa neꞌu. Camu yaúꞌitɨe, camu majta tanamuaj. Dios pu tihuáꞌitɨii chuijtari jɨmeꞌe mej mi caí yaúꞌitɨée muáꞌaraꞌani, mej mi caí ráanamua, aꞌiné camu xaa neꞌu raxɨ́ꞌeveꞌe mej seɨcɨé tirájteuni aꞌij mej yeꞌí huárɨni, tɨ́ꞌij aꞌɨ́ɨn caí tihuaꞌutáꞌuuniꞌi ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ajta Jesús pu ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni tzaa secaí yaúꞌitɨée xaꞌaraa aꞌɨ́jna ɨ́ niuucari? Tɨ́ puaꞌa secaí yaúꞌitɨée xaꞌaraa, ¿aꞌiné tíꞌirɨꞌɨri sej si siyen yaúꞌitɨée xáꞌaraꞌani ɨ́ seica ɨ́ niuucari? Nuꞌuri íjii amuaatáꞌixaateꞌesin amitɨéereꞌecan jɨmeꞌe aꞌij tɨ huataújmuaꞌa ɨ́ niuucari tɨ jɨ́meꞌen raxa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ nuꞌu tíꞌihuastehuaꞌa imueꞌeri jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","’Aꞌɨ́jna ɨ́ imueꞌeri tɨ huastiꞌi, ayée pu seijreꞌe tɨ́j ɨ́ jaꞌatɨ tɨ á eꞌetécheꞌecaneꞌe huáꞌaꞌixaateꞌe ɨ́ niúucareꞌaraꞌan jɨmeꞌe tɨ Dios jemi aꞌuvéꞌemej. ");
INSERT INTO crnNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ajta seica ɨ́ teɨte, yee mú eꞌen cumu ɨ́ imueꞌeri tɨ aꞌuun aꞌuvatzɨ́jraa juye jetze. Aꞌɨ́ɨ mú naa tíꞌijnamua ɨ́ niúucareꞌaraꞌan tɨ raaxájtacaꞌa ɨ́ jaꞌatɨ. Aru, matɨ́ꞌɨj ráanamuajriꞌi, aꞌɨ́ɨ pu tiyaaruꞌu huaꞌiráꞌaꞌariꞌiracareꞌe ɨ́ niuucari ɨ́ mej rúꞌumuaꞌareerecaꞌa ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Majta seica, yee mú eꞌen tɨ́j aꞌɨ́jna ɨ́ imueꞌeri tɨ huahuástiꞌihuacaꞌa ɨ́ tetej tzajtaꞌa. Amuacaí pu huaꞌaránajchecaꞌa ɨ́ niuucari ɨ́ mej ráanamuajriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Aru cumu caí jeíhua ajtanáanaꞌajme, aꞌɨ́j mú jɨ́n rajpuaíitzi muáꞌayeꞌi meꞌɨ́jna jɨmeꞌe mej seica huáꞌaxɨeehuasti ɨ́ niuucari, naꞌari tɨ puaꞌa seica aꞌij puaꞌa mehuáꞌaruure, cɨ́j muꞌu téꞌeviicuaꞌi. Caꞌanacan mú mé rúujɨsin. ");
INSERT INTO crnNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","’Majta seica ɨ́ teɨte, ayée mú ꞌeen tɨ́j ɨ́ imueꞌeri tɨ huahuástiꞌihuacaꞌa aꞌu tɨ aꞌutzícareꞌeme. Aꞌɨ́ɨ mú ranamua ɨ́ niuucari. ");
INSERT INTO crnNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Aru jeíhua pu huáꞌa jetze ruxeꞌeveꞌe aꞌij mej rujɨ́ɨmuaꞌa menaꞌa tirájteuve íiyen chaanaca japua tej japuan seijreꞌe. Ayee mú huaújmuaꞌamua mej tíꞌituaaveꞌen. Majta miyen tíꞌinecuaꞌatze mej chíjteaani púꞌeeneꞌen. Aꞌiné tɨ́ꞌɨj pɨ́ naꞌa mú miyen tíꞌimuaꞌatze aꞌiné ayée mú tíꞌixeꞌeveꞌe, capu chéꞌe téꞌuve ɨ́ huáꞌa tzajtaꞌa mej japuan tiúꞌumuaꞌati ɨ́ niuucari. Aꞌɨ́j pu jɨ́n caí chéꞌe rɨꞌɨrí tɨ huaꞌutévaɨreꞌen ɨ́ niuucari ɨ́ huáꞌa tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","’Majta seica, ayée mú ꞌeen cumu aꞌɨ́jna ɨ́ imueꞌeri tɨ huavatzɨ́jraa japuan ɨ́ chuej tɨ aꞌurɨ́ꞌen. Aꞌɨ́ɨ mú xaa ranamua ɨ́ niuucari, majta ɨ́ ru tzajtaꞌa raateátuaasin ɨ́ rumuaꞌatzíiraꞌa jɨmeꞌe. Ayee pu ꞌeen tɨ́j ꞌeen ɨ́ imueꞌeri tɨ huácɨɨrecaꞌa jeíhua. Seica mú tiuꞌutévaɨreꞌesin jeíhua. Seica mú tiuꞌutévaɨreꞌesin cumu ɨ́ imueꞌeri tɨ huácɨɨrecaꞌa aꞌachú cumu seité japuan tamuáamuataꞌa tɨ catéꞌetejme, seɨj ajta seɨj. Majta seica cumu ɨ́ tɨ huácɨɨrecaꞌa aꞌachú cumu huaícate tɨ catéꞌetejme, majta seica miyen ꞌeen cumu ɨ́ tɨ huácɨɨrecaꞌa aꞌachú cumu anxɨ́te, seɨj ajta seɨj. ");
INSERT INTO crnNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? Tɨ́ puaꞌa jaꞌatɨ́ yé véꞌemeꞌen, lámpara tɨ tijájna, ¿aꞌuné jetze yáꞌaruuren aꞌɨ́jna ɨ́ lámpara? ¿Ni sicuꞌuj jetze ruꞌutéeyeijtza, naꞌari utaatzi jete yeꞌiráchajtza? Capu xaa neꞌu áa yaꞌutéꞌavaata, sino án pu jéjreꞌe yaꞌujchájtza, án ɨmuá tɨ́ꞌij aꞌɨmuá aꞌatáneeriꞌicɨj. ");
INSERT INTO crnNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Tiꞌitɨ́ tɨ aꞌij tíꞌaviitziꞌi, capu ayén éeneꞌen aꞌame tɨ́j naꞌa rusén jɨmeꞌe, sino huataújseijrata á jéjreꞌe. Naꞌari tiꞌitɨ́ tɨ aꞌij avíitzi jɨ́n tíꞌimuariꞌihua, aj puꞌi muáꞌareeriꞌihuan. ");
INSERT INTO crnNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Múꞌeen, mɨ sej rarɨ́ꞌɨrejve, xáanamuajriꞌi. ―Ayee pu tihuaúꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ajta ayén tihuaúꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu tiráanamua i sej tíꞌinamua. Aꞌachú sej caj tíꞌijnamua ɨ́ niuucari, ayée pu cheꞌatá naꞌa Dios tejámuaatáꞌasin múꞌejmi sej si jaítzeꞌe yaúꞌitɨée xáꞌaraꞌani. Ajta aꞌɨ́ɨn, aúcheꞌe pu jaítzeꞌe tejámuaatáꞌasin i sej ranamua. ");
INSERT INTO crnNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ayee pu téꞌeme. Tɨ́ puaꞌa jaꞌatɨ́ rɨ́ꞌɨ tíꞌijnamuajraveꞌen, Dios pu raatáꞌasin tɨ jaítzeꞌe yaúꞌitɨée áꞌaraꞌani. Ajta, tɨ puaꞌa jaꞌatɨ́ caí rɨ́ꞌɨ tíꞌijnamuajraveꞌen, Dios pu ráꞌariꞌira aꞌachú tɨ caj ari tiyaúꞌitɨée jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ajta ayén tɨjɨ́n: ―Ayee pu tíꞌirɨneca matɨ́ꞌɨj miyen rɨjca aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Yee muꞌu huatámuꞌiireca tɨ́j huavaújseꞌen ɨ́ imueꞌeri tɨ jaꞌatɨ raahuáste. Aꞌɨ́jna ɨ́ jaꞌatɨ ratáhuaꞌanáa pu auméꞌecaa ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tɨ́ꞌɨj jí huatácutzi aꞌɨ́jna ɨ́ jaꞌatɨ. Aj pu ijtáꞌi íꞌijɨstin, tɨ́ꞌɨjtáꞌi ájchesin. Aꞌateeri tɨ huatéꞌa aꞌame. Aj puꞌi ajnéjsin, tɨ́ꞌɨj i vaujseꞌen. Aru aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌɨ́ɨ pu caí ramuaꞌaree aꞌij tɨ yeꞌí teꞌejnéj ɨ́ imueꞌeri. ");
INSERT INTO crnNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Aꞌɨ́jna ɨ́ chuej pu hui ruseɨ́j rɨ́ꞌɨ raruuren tɨ huavaújseꞌen ɨ́ imueꞌeri. Amuacaí pu ajnéjsin ɨ́ huáacɨxaꞌa. Aj puꞌi ɨ́ huíjmuaiyu. Tɨ puaꞌa ari huijmuaíiyuren, tɨ́ꞌɨjí ajtanéjsin tɨ jetzen catéꞌete aꞌame ɨ́ jatzi. ");
INSERT INTO crnNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tɨ́ꞌɨj aꞌɨ́ɨn huácaꞌanáan ɨ́ jatzi, aj mú mi u yáꞌatzaanan. Puꞌuri íjii tejaꞌuréꞌene aꞌájna xɨcájraꞌa jetze mej jetzen tíꞌitzaꞌanaca. ");
INSERT INTO crnNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ajta ayén tiuꞌutaxájtacaꞌa ɨ́ Jesús tɨjɨ́n: ―¿Aꞌiné yeꞌí tíꞌirɨꞌɨri tej ti tiyen raataxáj aꞌij tɨ yeꞌí tejéꞌaijta ɨ́ Dios? ¿Tiꞌitájqui niuucarijraꞌa ruxeꞌeveꞌe tej raataxáj aꞌij tɨ yeꞌí tíꞌirɨneca Dios tɨ éꞌeseijreꞌe? ");
INSERT INTO crnNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","’Ayee pu ꞌeen cumu tiꞌitɨ́ tuꞌupi tɨ ayén ántehuaa tɨjɨ́n mostaasa. Ayee pu ꞌeen tɨ jaítzeꞌe cɨ́lieen caí máàj seica jatzíjraꞌa tɨ yen seijreꞌe íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tɨ́ꞌɨj huastiꞌihua aꞌɨ́jna ɨ́ jatzi, aj puꞌi vaujseꞌen. Tɨ́ꞌɨj huavaújseꞌen, jaítzeꞌe pu uratɨ́tɨꞌɨj áꞌayeꞌi caí ɨ́ piꞌista tɨ yen seijreꞌe íiyen chaanaca japua. Temuaꞌa pu tiꞌipuápuaꞌamee ɨ́ cɨ́yeꞌaraꞌan. Ajta ɨ́ xamuaꞌiraꞌan, temuaꞌa pu teꞌantajíyaꞌume. Aꞌɨ́j pu jɨ́n rɨꞌɨrí mej pinaꞌase jetzen tihuaúrituꞌateꞌen tɨ huácɨen tzajtaꞌa. ―Ayee pu tihaúꞌixa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ayee pu tihuáꞌamuaꞌatehuaꞌa ɨ́ niúucareꞌaraꞌan jɨmeꞌe tɨ Dios jemi éꞌemeꞌecan. Jeíhua pu tihuáꞌaꞌixaꞌatehuaꞌa niuucari jɨmeꞌe aꞌachú mej caj téꞌeviicuaꞌiracaꞌa mej ráanamua. ");
INSERT INTO crnNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Tiꞌitɨ́ tɨ aꞌij tɨ tihuáꞌaꞌixaꞌatehuaꞌa ɨ́ teɨte, Jesús pu ayén tihuáꞌaꞌixaꞌatehuaꞌa niuucari jɨmeꞌe tɨ caí eꞌehuáuritɨiiricɨ. Aru aꞌɨ́ɨ pu tihuáꞌaꞌixaꞌatehuaꞌa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe aꞌij tɨ huataújmuaꞌa naíjmiꞌi ɨ́ niuucari amitɨéereꞌecan jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Aꞌɨ́jna xɨcájraꞌa jetze, tɨ́ꞌɨj ari téchumuaꞌarijmeꞌe, Jesús pu huaꞌutáꞌixa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayen tɨjɨ́n: ―Tichéꞌe antácɨɨne után pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Matɨ́ꞌɨj mi á huajauhuáꞌaxɨ ɨ́ teɨte. Aj mú mi yáꞌutɨɨ ɨ́ Jesús jetzen ɨ́ baarcu aꞌuun tɨ aꞌutéveecaꞌa. Majta seica aꞌucɨ́j seɨj jetze ɨ́ baarcu. ");
INSERT INTO crnNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Aj puꞌi huatáꞌeecarecaꞌa temuaꞌa caꞌanín jɨmeꞌe. Japuutzari pu temuaꞌa téꞌuxɨjveꞌe. Ajta vivejméꞌen tiújtaꞌahuaꞌa ɨ́ jaj. Tɨ́ꞌɨj i ateáxɨɨreꞌaxɨ ɨ́ baarcu jetze. Puꞌuri tɨ́n avéꞌejɨstijmeꞌe ɨ́ jaj. ");
INSERT INTO crnNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ajta aꞌɨ́ɨn Jesús, aꞌúu pu éꞌecujcaa cɨ́tzataꞌan pújmeꞌen ɨ́ baarcu. Timuꞌutzi pu huaméꞌecaa. Aj mú mi raajɨ́ste. Miyen tɨjɨ́n: ―Maeestru, ¿ni caí á jetze ruxeꞌeveꞌe tej teri tɨ́n cuiꞌini? ");
INSERT INTO crnNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Aj pu ꞌi caꞌanacan ájchee ɨ́ Jesus. Tɨ́ꞌɨj jí raatépuaꞌajte ɨ́ eeca. Ajta ayén tiraataꞌixaa ɨ́ jaj, tɨjɨ́n: ―Pecaj chéꞌe sihuájna. Xaatapuáꞌajta. ―Yee pu tiuꞌutaxájtacaꞌa. Aj puꞌi huateápuaꞌarecaꞌa ɨ́ eeca. Ajta aꞌuréujéꞌiyerecaj ɨ́ jaj temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aj pu ijtáꞌi Jesús huaꞌutáꞌixa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayén tɨjɨ́n: ―¿Aꞌiné een jɨ́n huápɨꞌɨ setiuꞌutátziɨn? ¿Aꞌiné een jɨ́n secaí téꞌatzaahuateꞌe? ―Yee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Temuaꞌa mú mi jeíhua tiuꞌutátziɨn. Majta miyen tiújꞌixaateꞌecaꞌa meꞌɨ́jna jɨmeꞌe mej tiuꞌutátziɨn. Miyen tɨjɨ́n: ―¿Tiꞌitájni téviraꞌa púꞌeen? Amɨ́ pu hui tihuáꞌaijteꞌe ɨ́ eeca, ajta ɨ́ jaj. Naímiꞌi mú ráꞌastijreꞌe. ―Yee mú tiújꞌixaateꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aj mú mi antacɨ́ɨ antavén pújmeꞌen. Ayee pu téjaꞌarájtehuaa tɨjɨ́n Gadara. ");
INSERT INTO crnNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Aj puꞌi Jesús aꞌitáraa ɨ́ baarcu jetze. Tɨ́ꞌɨj jí áꞌiyen seɨj aveꞌeréꞌene tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa. Aꞌuu pu huirájraa aꞌɨ́jna ɨ́ jaꞌatɨ aꞌu mej mɨꞌɨchite eꞌevéꞌenaamuaca. ");
INSERT INTO crnNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aꞌuu pu éꞌechejcaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. Jéꞌecan pu simuárun. Capu rɨꞌɨríistacaꞌa tɨ jaꞌatɨ raꞌamuájɨꞌɨcɨꞌen caujnari jɨmeꞌe, ni alaambre jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Muꞌíi mú raatatése. Maraꞌamuajɨ́ꞌɨcɨꞌihuaꞌa muájcaꞌareꞌaraꞌan jetze, majta ɨɨcájraꞌan jetze alaambre jɨmeꞌe. Aru aꞌɨ́ɨn, tɨ́ꞌɨj pɨ́ naꞌa pu tijtzáꞌanaꞌa cɨ́lieeneꞌen, ajta méjcaꞌi iyaúhuaꞌaxɨjsin. Capu huatárɨꞌɨristarecaꞌa tɨ jaꞌatɨ aꞌij ráaruuren tɨ raamuáꞌacanteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nain tújcaꞌari tzajtaꞌa, ajta nain tɨ́caꞌari tzajtaꞌa, aꞌɨ́ɨ pu áꞌucheꞌecaneꞌe, anjiihua aꞌájna jɨrí jetze. Ajta aꞌájna aꞌu mej mɨꞌɨchite eꞌevéꞌenaamuaca, á pu ij ayén huaꞌuteátuꞌasixɨ tetej jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tɨ́ꞌɨj raaseíj ɨ́ Jesús, áꞌiyen púu aꞌutatɨ́ej. Aj puꞌi títunutacaꞌa aꞌájna vejliꞌi aꞌutɨ́ aꞌutéveecaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ajta huajíjhuacaꞌa caꞌanín jɨmeꞌe. Ayen tiraataꞌixaa tɨjɨ́n: ―¿Aꞌiné tiꞌitɨ́j peteáruuren neetzi jemi, Jesús ɨ́ pej iꞌi yaujraꞌan ɨ́ Dios tɨ nainjapua tíꞌaijta? Aꞌij nu muahuavii ɨ́ Dios jemi pej caí puaíjtzi neetáꞌacareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌiné ayée pu tiraatáꞌixaateꞌecaꞌa ɨ́ Jesús tɨjɨ́n: ―Tiyaaruꞌu pej tzajtaꞌan seijreꞌe mɨ tevi, pej aꞌij puaꞌa meteúumuaꞌaree, huirájraꞌa mɨ tevi jetze. ―Yee pu tiraataꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ajta ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné puaꞌantehuaa múꞌee? Ajta ayén tiuꞌutaniú tɨjɨ́n: ―Ayee nu ántehuaa tɨjɨ́n I tej arájsevi viꞌiraꞌa taꞌaráꞌase. Ayee tu tiꞌitamuáꞌamua aꞌɨ́jna jɨmeꞌe tej iꞌi muꞌíi. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aj puꞌi aꞌɨ́jna ɨ́ jaꞌatɨ jeíhua rájhuaviiriꞌi ɨ́ Jesús tɨ aꞌɨ́ɨn huaꞌutaꞌíte mej áꞌucɨɨne mé áꞌahuaꞌayee ɨ́ mej tzajtaꞌan seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Majta meꞌɨ́n tuiixute, á vejliꞌi teꞌantácuaꞌatɨyeꞌicaa jɨrí jetze, memuꞌiicáa ɨ́ tuiixute aꞌachú mú aráꞌaxca huaꞌapua viꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Aj mú mi meꞌɨ́n tiyáaruꞌuse miyen tirájhuaviiriꞌi tɨjɨ́n: ―Taatáꞌa itejmi tej aꞌuteárute mɨ tuiixute tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Tɨ́ꞌɨj jí aꞌɨ́ɨn huaꞌutáꞌa. Matɨ́ꞌɨj mi huiráacɨ meꞌɨ́jna ɨ́ tiyáaruꞌuse ɨ́ mej tzajtaꞌan seijreꞌecaꞌa aꞌɨ́jna ɨ́ tevi. Aj mú mi tiyáaruꞌuse huataseíjre ɨ́ tuiixute tzajtaꞌa. Majta meꞌɨ́n ɨ́ tuiixute, muaatauruj aꞌuun pújmeꞌen u jateꞌe. Aj mú mi atéevatzɨ á jaataꞌa. Matɨ́ꞌɨj mi aujamɨ́, naíjmiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Majta meꞌɨ́n ɨ́ mej tuiixute chaꞌɨɨcaꞌa, aꞌɨ́ɨ mú temuaꞌa tiuꞌutátziɨn. Matɨ́ꞌɨj mi aꞌucɨ́j mej huaꞌutáꞌixaateꞌen mej chajtaꞌa aꞌuchéjmeꞌe, majta matɨ́j menaꞌa mej aꞌuchéjmeꞌe aꞌɨmuá. Aj mú mi eꞌiréꞌene ɨ́ teɨte mej mi ráamuaꞌaree aꞌij tɨ tiꞌitɨ́ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Matɨ́ꞌɨj mi aveꞌeréꞌene aꞌu tɨ aꞌij éꞌeneꞌe ɨ́ Jesús. Aj mú mi meꞌɨ́n huaseíj ɨ́ tevi ɨ́ mej tiyáaruꞌuse tzajtaꞌan seijreꞌecaꞌa. A pu aꞌutácatii. Capu chéꞌe muaꞌaviꞌi. Capu chéꞌe rutɨ́muaꞌi. Puꞌuri huarúj aꞌɨ́jna ɨ́ tevi. Aj mú mi tiuꞌutátziɨn. ");
INSERT INTO crnNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Majta meꞌɨ́n ɨ́ mej raaseíj aꞌij tɨ tiꞌitɨ́j huarɨ́, nain mú huaꞌutáꞌixa ɨ́ teɨte aꞌij tɨ tiráaruu ɨ́ tevi ɨ́ tiyáaruꞌuse mej tzajtaꞌan seijreꞌecaꞌa, aꞌij tɨ tihuáꞌuruu ɨ́ tuiixute. ");
INSERT INTO crnNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Aj mú mi aꞌuteájhui ɨ́ teɨte mej rahuavii ɨ́ Jesús tɨ áꞌuraꞌani u áꞌahuaꞌayee. ");
INSERT INTO crnNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tɨ́ꞌɨj jí áꞌuraa ɨ́ Jesús. Aꞌuun pu ateájraa ɨ́ baarcu jetze. Tɨ́ꞌɨj i aꞌíjna i tɨ tzajtaꞌan seijreꞌecaꞌa ɨ́ tiyaaruꞌu, aꞌɨ́ɨ pu rájhuaviiriꞌi tɨ Jesús raatáꞌan tɨ áꞌuraꞌani jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ajta aꞌɨ́ɨn ɨ́ Jesús, capu raatáꞌa aꞌɨ́jna ɨ́ tevi tɨ áꞌuraꞌani jamuan. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Aricu aꞌu pej éꞌeche huáꞌa jamuan aꞌihuáamuaꞌa. Patáꞌaj huaꞌutáꞌixaateꞌen nain aꞌij tɨ timuáaruu ɨ́ tavástaraꞌa jemi, aꞌij tɨ yeꞌí rɨ́ꞌɨ timuájchaꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Aj pu i iyáꞌuraa ɨ́ jaꞌatɨ. Ajta áꞌiyen aꞌɨ́ɨn aꞌutéjche tɨ huaꞌutáꞌixaateꞌen ɨ́ mej meꞌuun aꞌuchéjme aꞌájna tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Tamuáamuataꞌa tɨ Chájtaꞌajme. Nain pu huaꞌutáꞌixa aꞌij tɨ tiúꞌuruu aꞌɨ́jna ɨ́ Jesús. Aꞌu tɨ naꞌa rɨ́ꞌɨ mú tiráanamuajracaꞌa ɨ́ teɨte aꞌiné jéjcua meꞌecan ɨ́ niuucari. ");
INSERT INTO crnNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aj pu ijtáꞌi huaréꞌaraa ɨ́ Jesús ɨ́ baarcu jetze. Tɨ́ꞌɨj ii aꞌuun aꞌaráꞌa aꞌuun jetze pújmeꞌen vejliꞌi aꞌu tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj. Matɨ́ꞌɨj mi aveꞌeréꞌene jeíhua ɨ́ teɨte aꞌu tɨ aꞌutéveecaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Aj puꞌi seɨj aꞌaráꞌa jaꞌatɨ́ tɨ tíꞌivaɨreꞌecaꞌa huaꞌatéyujtaꞌa. Veꞌecán pu jɨ́n tiꞌitéveecaꞌa. Ayee pu ántehuaacaꞌa tɨjɨ́n Jairo. Tiyaúj, ɨ́iitacan. Tíꞌicuiꞌicaꞌa aꞌɨ́jna ɨ́ yaujraꞌan. Tɨ́ꞌɨj aꞌɨ́ɨn Jairo raaseíj ɨ́ Jesús, aj puꞌi títunutacaꞌa á chuaataꞌa Jesús tɨ jéꞌejvee. ");
INSERT INTO crnNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jeíhua pu rájhuaviiriꞌi, ayén tɨjɨ́n: ―Niyauj pu áꞌameꞌere. Mu aꞌutáꞌiyiꞌi patáꞌaj raꞌajtamuárɨꞌen, táꞌaj huarún, táꞌaj auj ruuri áꞌaraꞌani. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Aj puꞌi Jesús u áꞌume jamuan. Majta jeíhua teɨte aꞌucɨ́j huáꞌa jamuan aꞌɨ́mej ɨ́ mej huaꞌapua. Matɨ́ꞌɨj mi ajteáxɨɨrecaꞌa ɨ́ teɨte. Temuaꞌa mú huápɨꞌɨ titéꞌucatacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ajta huáꞌa tzajtaꞌa aꞌutéveecaꞌa ɨ́ ꞌɨ́itaꞌa tɨ tíꞌicuiꞌi. Puꞌuri aꞌateeviꞌi aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua nineꞌiraꞌa tɨ tíꞌicuiꞌi aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨ́ꞌɨj pɨ́ naꞌa pu uvéꞌemɨꞌɨyecaꞌa. Jeíhua pu xuurecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Puꞌuri jeíhua huaúꞌaijtacaꞌa ɨ́ mej tíꞌihuaꞌataca jemi. Puꞌuri téjeꞌehuáujrɨe nain tɨ́j naꞌa tɨ́j caj tíꞌituaaveꞌecaꞌa. Ajtáꞌi, capu tiꞌitɨ́j aꞌij tiraatévaɨ. Mɨ́ ajtáꞌi, ayée pu i éeneꞌe ajtahuaꞌa jaítzeꞌe tijcuíꞌinecaꞌa. Aꞌɨ́j pu jɨ́n, rajpuaíjtzicaꞌa jeíhua aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tɨ́ꞌɨj jí tiúꞌunamuajriꞌi aꞌij tɨ tiꞌitɨ́j huáruu ɨ́ Jesús. Ayen tɨjɨ́n: “Aꞌij nu jɨ́n niyen rɨni nej raꞌajtamuárɨꞌen cɨ́ɨxureꞌaraꞌan jetze, aj nu run.” Yee pu tiuꞌumuáꞌaj aꞌɨ́jna tɨ tíꞌicuiꞌi. Aꞌɨ́j pu jɨ́n á aúurupi teɨte tzajtaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨ́ꞌɨj i á eꞌiréꞌene huaritaꞌan ɨ́ Jesús. Aj puꞌi raꞌajtamuárɨej cɨ́ɨxureꞌaraꞌan jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jɨ́meꞌen puꞌu raꞌajtamuárɨej, aj puꞌi huatépuaa tɨ uvéꞌexuuricaꞌa. Tɨ́ꞌɨj i ayén raatáꞌa ɨ́ tzajtaꞌan cumu puꞌuri huarúj. ");
INSERT INTO crnNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aj pu i ráamuaꞌareeriꞌi ɨ́ Jesús ɨ́ ru tzajtaꞌa tɨ jaꞌatɨ́ tiúꞌuhuaa cumu tɨ caí chéꞌe racáꞌanistiꞌi. Aj pu i pɨ́ɨ aꞌuréꞌeve, huaꞌuseíirajraa ɨ́ teɨte. Ayen tɨjɨ́n: ―¿Aꞌataani naꞌajtamuárɨej i necɨ́ɨxu jetze? ―Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Aj mú mi miyen tiraataꞌixaa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Miyen tɨjɨ́n: ―Múꞌee pej huáꞌaseij ɨ́ teɨte mej áꞌacata. ¿Aꞌiné een jɨ́n piyen tiuꞌutaꞌíhuaꞌu? yee: “¿Aꞌataani naꞌajtamuárɨej?” ―Yee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mɨ́ ajtáꞌi aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu huaꞌuseíirajyeꞌicaa matɨ́j menaꞌa titeꞌanavéejmeꞌeca. Ayee pu aꞌɨ́ɨn rɨjcaa tɨ́ꞌij raaseíj jaꞌatɨ́ tɨ raꞌajtamuárɨej. ");
INSERT INTO crnNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Aj pu i aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, temuaꞌa tiuꞌutátziɨn. Temuaꞌa pu tiúꞌujviveecaꞌa ɨ́ ru tzajtaꞌa aꞌiné rúꞌumuaꞌareerecaꞌa tiꞌitɨ́ tɨ aꞌij huáruu. Aj pu i ajteáxɨɨrecaꞌa aꞌu tɨ aꞌij eꞌen aꞌɨ́jna ɨ́ Jesús. Títunutacaꞌa á vejliꞌi jemin. Tɨ́ꞌɨj jí nain raatáꞌixaa aꞌij tɨ tiꞌitɨ́ ráaruu tzáahuatiꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Niyauj, petéꞌantzaahua nej timuáahuaateꞌencheꞌe. Aꞌɨ́j pej jɨ́n peri huarúj. Aricu, rɨ́ꞌɨ pej teꞌamuaꞌastɨ́. Paúcheꞌe pej rɨꞌéeneꞌe puaꞌamé. ");
INSERT INTO crnNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aúcheꞌe pu tíꞌixajtacaꞌa aꞌɨ́jna matɨ́ꞌɨj seica aꞌaráꞌa. Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej éꞌeche jamuan ɨ́ tɨ veꞌecán jɨ́n tiꞌitéjvee huaꞌatéyujtaꞌa. Aj mú mi miyen tiraataꞌixaa ɨ́ yaꞌupuáaraꞌan ɨ́ temuaij tɨ tíꞌicuiꞌi. Miyen tɨjɨ́n: ―Puꞌuri huamɨ́ꞌɨ aꞌayauj. ¿Aꞌiné een jɨ́n péraꞌɨtziiteꞌe mɨ maestro? ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mɨ́ ajtáꞌi aꞌɨ́ɨn Jesús, capu huáꞌantzaahua aꞌij mej yeꞌí tíꞌixajtacaꞌa. Ayee pu tiraataꞌixaa ɨ́ yaꞌupuáaraꞌan tɨjɨ́n: ―Pecaj tíꞌitziɨɨneꞌe. Aꞌii puꞌu ruxeꞌeveꞌe pej téꞌatzaahuateꞌe. ―Yee pu tiraataꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aj pu i huajaꞌuviꞌitɨ́ aꞌu tɨ éꞌeche ɨ́ yaꞌupuáaraꞌan. Aru Jesús capu huaꞌutáꞌa naíjmiꞌica ɨ́ teɨte mej áꞌujuꞌun jamuan. Aꞌɨ́mej puꞌu, ɨ́ Pedro, ajta ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan, tɨ iꞌi juutzeájraꞌan ɨ́ Jacobo. ");
INSERT INTO crnNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aa mú aꞌaráꞌa aꞌu tɨ éꞌeche ɨ́ yaꞌupuáaraꞌan ɨ́ tɨ huamɨ́ꞌɨ. Aj mú mi huaꞌuseíj ɨ́ teɨte mej chiꞌita huiráatei. Jeíhua mú uꞌuteújyeinijmeꞌe. Maújyeinecaꞌa. Caꞌanín mú jɨ́n uꞌuteújyeinijmeꞌe meꞌɨ́jna jɨmeꞌe ɨ́ tɨ huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Aj puꞌi chiꞌita aꞌuteájrupi. Tɨ́ꞌɨj jí huaꞌutáꞌixa ɨ́ Jesús. Ayen tɨjɨ́n: ―¿Aꞌiné sej si caꞌanín jɨ́n jijhua? ¿Aꞌiné sej si ruyein? Capu mɨꞌɨchi mɨ temuaij, sino cutzú puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ yeꞌí tiuꞌutaxájtacaꞌa, aj mú mi raꞌutéxɨeehuatacaꞌa aꞌiné méjmuaꞌareerecaꞌa tɨ aꞌɨ́ɨn paꞌarɨꞌɨ huamɨ́ꞌɨ. Aj puꞌi aꞌɨ́ɨn huaꞌutaꞌaíj mej huirácɨɨne. Aj mú mi huiráacɨ. Tɨꞌɨquí yaꞌuvíꞌitɨ ɨ́ yaꞌupuáaraꞌan, ajta ɨ́ náànajraꞌan, ajta aꞌɨ́mej ɨ́ mej áꞌujujhuaꞌaneꞌe jamuan. Aꞌuu mú uteájrupi aꞌu tɨ auucáꞌa ɨ́ temuaij. ");
INSERT INTO crnNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Aj puꞌi rajvíꞌi muájcaꞌareꞌaraꞌan jetze. Ayee pu tiraatajé runiuuca jɨmeꞌe tɨjɨ́n: ―Taliita, cuumi. Taliita, cuumi, ayee pu huataújmuaꞌa tɨjɨ́n: Temuaij, ayée nu tíꞌimuaꞌixaateꞌe, ájchesi. ");
INSERT INTO crnNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jɨ́meꞌen puꞌu ayén huarɨ́j ɨ́ Jesús, aj pu i xaa ájchee ɨ́ temuaij. Tɨ́ꞌɨj jí aꞌutéjche tɨ á áꞌucheꞌecaneꞌen. Majta meꞌɨ́n ɨ́ teɨte, jéꞌecan mú u huateújtzaahuate. Ajta aꞌɨ́ɨn ɨ́ paꞌarɨꞌɨ, ayée pu rájchaꞌɨɨcaꞌa aꞌachú cumu tamuáamuataꞌa nineꞌiraꞌa japuan huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ajta aꞌɨ́ɨn Jesús, jeíhua pu huaꞌuꞌíjca mej caí jaꞌatɨ́j ixaateꞌe, ajta mej nuꞌu tiraamín ɨ́ temuaij. ");
INSERT INTO crnNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Aꞌuu pu áꞌuraa ɨ́ Jesús, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi aꞌucɨ́ aꞌuun pújmeꞌen aꞌu tɨ aꞌuvéꞌese aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tɨ́ꞌɨj tejaꞌuréꞌene aꞌɨ́jna xɨcájraꞌa mej jetzen ruseꞌupi, tɨ́ꞌɨjí aꞌutéjche tɨ tihuáꞌumuaꞌaten huaꞌatéyujtaꞌa. Jeíhua mú teɨte ráanamuajriꞌi. Jéꞌecan mú aꞌij teꞌutaseíj. Ayee mú tíꞌiraꞌihuaꞌuracaꞌa tɨjɨ́n: ―¿Aꞌuné yaꞌurɨ́ꞌɨre amɨ́n niuucarijraꞌa? ¿Tiꞌitáani muaꞌatzíireꞌaraꞌan púꞌeen aꞌíjna tɨ raateájtuaa amɨ́jna jemi mɨ Jesús tej caí xɨ jaꞌanáj méꞌe yáꞌunamuajriꞌi? ");
INSERT INTO crnNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Amɨ́ pu yeehui aꞌɨ́ɨn púꞌeen ɨ́ yaujraꞌan ɨ́ tɨ tíꞌisiꞌicheca. Aꞌɨ́ pu náànajraꞌan ayén ántehuaa tɨjɨ́n María. Aꞌɨ́ mú júutzimuaꞌameꞌen púꞌeen aꞌɨ́ɨme ɨ́ Jacobo, ajta ɨ́ José, ajta ɨ́ Judás, ajta aꞌɨ́jna ɨ́ Simón. Majta seica ɨ́ júutzimuaꞌameꞌen ɨ́ mé ꞌuuca, aꞌɨ́ɨ mú yéchej ta jamuan. ―Ayee mú tiújꞌixaateꞌecaꞌa. Aꞌɨ́j mú jɨ́n ráꞌachueereꞌecaa meꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j mú jɨ́n caí raxɨ́ꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ajta, ayée pu Jesús tihuaꞌutáꞌixaa tɨjɨ́n: ―Naíimiꞌi mú rɨ́ꞌɨ tiraꞌutaseíj temuaꞌa naa ɨ́ tɨ tiꞌixa ɨ́ niuucari tɨ Dios jemi meꞌecan. Mɨ́ ajtáꞌi, ɨ́ mej huacaíjme ruche, majta ɨ́ mej iꞌivaujsimuaꞌameꞌen, majta ɨ́ mej jamuan éꞌeche, camu tɨ́n rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ayee puꞌu caí tiuꞌutárɨꞌɨristarecaꞌa tɨ aꞌɨ́ɨn Jesús tiꞌitɨ́ aꞌij huáruuren ɨ́ mej jɨ́n aꞌij raꞌutaseíj tɨ́j ari tiúꞌuruu puaꞌamecɨé. Ayee puꞌu huarɨ́j; huaꞌajtamuárɨꞌexɨ seica ɨ́ teɨte. Tɨ́ꞌɨj i xaa tihuáꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aꞌɨ́j puꞌi jɨ́n aꞌij tiraꞌutaseíj ɨ́ tzajtaꞌan mej caí ráꞌatzaahuateꞌecaꞌa. Tɨ́ꞌɨj jí áꞌuraa ɨ́ Jesús. Aꞌuu pu áꞌuyeꞌicaa aꞌɨmuá aꞌu tɨ aꞌuchájtaꞌajmee. Ajta tihuáꞌamuaꞌatejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tɨ́ꞌɨj jí Jesús pu huaꞌutajé aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Aj puꞌi huaꞌaréꞌeꞌitixɨ huaꞌapuacajméꞌen. Ajta tihuaꞌuꞌíjca aꞌɨ́jna jɨmeꞌe mej mi huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ajta ayén tihuaꞌuꞌíjca mej caí tiꞌitɨ́ antiáꞌa ɨ́ mej jɨ́n huateújvaɨreꞌen ɨ́ juye jetze. Aꞌɨ́ muꞌu nuꞌu aꞌachueeni tiꞌitɨ́ itzɨ́j ɨ́ mej jɨ́n raújcaꞌaníhuaꞌa. Capu nuꞌu aꞌij tíꞌirɨꞌɨri mej tiꞌitɨ́j antiáꞌa caꞌaní naꞌari tiꞌitɨ́ ínɨeꞌe nusu tumin. ");
INSERT INTO crnNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Majta, ajtaújcaꞌacaíiteꞌaxɨꞌɨn. Majta seexuꞌijméꞌen teꞌucaujchéeteꞌaxɨꞌɨn seɨj ajta seɨj. Capu nuꞌu aꞌij tíꞌirɨꞌɨri mej huaꞌapuacajméꞌen teꞌentipíi ɨ́ tiúꞌujsiicuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa hui chiꞌita xuꞌuteárute mé jáꞌahuaꞌa chajtaꞌa, aꞌúu xu huateáturaasin tɨ́j naꞌa aꞌachú sej áꞌateere aꞌájna chajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","’Ajta tɨ puaꞌa mé jáꞌahuaꞌa mecaí amuaatáꞌacareꞌen sej uteárute, naꞌari tɨ puaꞌa mecaí ranamuajracu ɨ́ sej tihuáꞌaꞌixaateꞌen, ayée xu huárɨni, sej huirácɨɨne seꞌújna. Seraꞌatécaꞌatzɨjxɨꞌɨn ɨ́ rucaꞌacai tɨ́ꞌij cáaxɨn ɨ́ chuej. Ayee xu huárɨni mej mi ráamuaꞌaree ɨ́ teɨte tɨjɨ́n maꞌuteájturaa ɨ́ Dios jemi. Michéꞌe ráamuaꞌaree mej auteájturaa ɨ́ Dios jemi aꞌachú mej puaꞌamé mej caí áꞌamuanamuajracucaꞌa. ’Ayee nu tejáꞌamuaꞌixaateꞌe, aꞌɨ́jna xɨcájraꞌa tɨ jetzen huaꞌuxɨ́jteꞌen ɨ́ Dios ɨ́ mej jɨ́n auteájturaa ɨ́ jemin, jeíhua pu puaíjtzi huaꞌutáꞌasin. Jaítzeꞌe mú rajpuaíitzi muáꞌajuꞌun aꞌujna chajtaꞌa mecaí ɨ́ mej meꞌuun éꞌechejcaꞌa aꞌujna tɨ ayén tejaꞌarájtehuaacaꞌa tɨjɨ́n Sodoma, ajta tɨjɨ́n Gomorra. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Matɨ́ꞌɨj mi aꞌucɨ́j. Metihuáꞌihuaꞌixaateꞌe ɨ́ teɨte tɨ nuꞌu ayén tiúꞌujxeꞌeveꞌe mej nuꞌu seɨcɨé tiúꞌumuaꞌati ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Majta meꞌɨ́n ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́ɨ mú jeíhua huaꞌutamuári ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌecaꞌa ɨ́ teɨte. Majta jeíhua tihuaꞌavéꞌehuaateꞌaxɨ aceite jɨmeꞌe huáꞌa muꞌúutzeꞌen ɨ́ mej tíꞌicucuiꞌi. Naíjmiꞌica mú tiúꞌuhuaate. ");
INSERT INTO crnNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iraꞌatéeviꞌi, matɨ́ꞌɨj ráanamuajriꞌi nain japua, tɨ́j naꞌa aꞌuun mej aꞌuchéjmeꞌecaa ɨ́ teɨte aꞌij tɨ tiúꞌuruu ɨ́ Jesús. Ajta aꞌɨ́jna ɨ́ tajtuhuan tɨ veꞌée, aꞌɨ́ɨ pu ajta ráamuaꞌareeriꞌi. Ayee pu ántehuaacaꞌa ɨ́ tajtuhuan tɨjɨ́n Heródes. Aj puꞌi ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Heródes tɨjɨ́n: ―Aꞌɨ́jna ɨ́ Juan teecan, ɨ́ tɨ huáꞌamuaɨꞌɨhuacareꞌe, aꞌɨ́ɨ pu hui huatarúj. Aꞌitáraa aꞌu mej yeꞌaváꞌana. Aꞌɨ́j pu jɨ́n raayɨ́ꞌɨtɨ tɨ ayén tiúꞌuruuren. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ tajtuhuan. ");
INSERT INTO crnNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Majta seica, miyen tɨjɨ́n: ―Aꞌi pu aꞌɨ́ɨn púꞌeen ɨ́ Elías ɨ́ tɨ aꞌɨ́jna jɨ́n tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Majta seica miyen tɨjɨ́n: ―Aꞌi pu aꞌɨ́ɨn pɨ́rɨcɨ jaꞌatɨ́ tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayee pu cheꞌatá naꞌa tiꞌitéjvee ɨ́ Dios jemi matɨ́j ɨ́ seica ɨ́ mej mejmíꞌi miyen tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mɨ́ ajta aꞌɨ́ɨn Heródes, tɨ́ꞌɨj ráamuaꞌareeriꞌi, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Aꞌi pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna teecan ɨ́ Juan ɨ́ nej raataꞌaíjtacaꞌa mej ruꞌijveíjche ɨ́ muꞌúuraꞌan. Aꞌɨ́ pu hui huatarúj huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Heródes. ");
INSERT INTO crnNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Aru seɨ́j pu púꞌeeneꞌe, ꞌɨ́itaꞌa tɨ ayén ántehuaacaꞌa tɨjɨ́n Herodías. Aꞌɨ́ pu ɨ́raꞌaraꞌan puꞌéeneꞌe ɨ́ Felipe. Ajta aꞌɨ́ɨn Felipe, aꞌɨ́ɨ pu juutzeájraꞌan púꞌeeneꞌe ɨ́ tajtuhuan ɨ́ Heródes. Tɨ́ꞌɨj jí Heródes aꞌɨ́ɨn ancuréꞌeviꞌitɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨn tɨ Felipe raatéviꞌitɨneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Aj puꞌi aꞌɨ́ɨn ɨ́ Juan ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Heródes tɨjɨ́n: ―Capu aꞌij tíꞌirɨꞌɨri pej ratéviꞌitɨneꞌen muáꞌihuaaraꞌa tɨ yáꞌuviꞌitɨneꞌe. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tɨ́ꞌɨj jí huataniúꞌucacaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Aꞌɨ́j pu jɨ́n aꞌɨ́ɨn Heródes, raataꞌaíjtacaꞌa mej raꞌanján aꞌɨ́jna ɨ́ Juan. Majta raꞌamuáajɨꞌɨcɨe alaambre jɨmeꞌe aꞌu tɨ aiteánamiꞌihuacaꞌa. Jéꞌecan pu rájchaꞌɨɨreꞌecaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Aꞌɨ́ pu jɨ́n rajéꞌicatamɨꞌɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mɨ́ ajtáꞌi aꞌɨ́ɨn ɨ́ Heródes, aꞌɨ́ɨ pu ráamuaꞌareeracaꞌa tɨ rɨ́ꞌɨ tíꞌitevistacaꞌa aꞌɨ́jna ɨ́ Juan, ajta tɨ ayén rɨjca aꞌij tɨ tíꞌijxeꞌeveꞌecaꞌa ɨ́ Dios. Ajta aꞌɨ́ɨ pu tíꞌimuaꞌajca aꞌɨ́jna jemi ɨ́ Juan. Aúcheꞌe pu raꞌaránajchecaꞌa aꞌɨ́jna ɨ́ Heródes tɨ ráanamua aꞌij tɨ tiuꞌuxájtacaꞌa aꞌɨ́jna ɨ́ Juan. Capu aꞌij íꞌirɨni tɨ caí temuaꞌa tiyaúꞌitɨeecaꞌa aꞌij tɨ tíꞌixajtacaꞌa. Aꞌɨ́j pu jɨ́n Heródes caí raatáꞌacareꞌe aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tɨ́ꞌɨj aꞌájna teꞌaráꞌa ɨ́ xɨcáaraꞌan jaꞌanáj tɨ meꞌecan aꞌɨ́jna ɨ́ Heródes, aj pu xaa aꞌɨ́ɨn ꞌɨ́itaꞌa ráꞌamitɨejteꞌecaꞌa aꞌij tɨ yeꞌí huárɨni tɨ raajéꞌica ɨ́ Juan. Tɨ́ꞌɨj jí Heródes, aꞌɨ́jna tɨ tíꞌiyesten tɨ teꞌaráꞌa ɨ́ xɨcáaraꞌan jaꞌanáj tɨ meꞌecan, jeíhua pu teɨte huatáꞌinee, xantaaruꞌu, matɨ́j menaꞌa huáꞌa capitanme, majta mej títetéꞌuꞌupuꞌu meꞌɨ́jna jɨmeꞌe mej tihuáꞌaijteꞌe ɨ́ teɨte, majta ɨ́ mej meꞌuun aꞌuchéjme aꞌujna Galilea, ɨ́ mej jeíhua ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Aj puꞌi yaujraꞌan aꞌɨ́jna ɨ́ Herodías, aꞌɨ́ɨ pu aꞌuteájrupi u chiꞌita aꞌu mej tejanúꞌucuaꞌacaꞌa. Aꞌɨ́jna ɨ́ yaujraꞌan, ꞌɨ́itaꞌa pu pɨ́rɨcɨ. Aj puꞌi aꞌɨ́ɨn tiuꞌutéenei ruseɨ́j huáꞌa vejliꞌipua. Temuaꞌa pu jeíhua tiraꞌaránajchecaꞌa aꞌɨ́jna ɨ́ Heródes ɨ́ tɨ tiuꞌutéenei, majta aꞌɨ́mej ɨ́ mej jamuan tíꞌicuaꞌacaa. Aj puꞌi ayén tiraataꞌixaa aꞌɨ́jna ɨ́ tajtuhuan tɨjɨ́n: ―Naatáhuaviiriꞌi tiꞌitɨ́j pej aꞌij tíꞌixeꞌeveꞌe. Nemuaatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jeíhua pu teꞌataújratziiriꞌi ruseɨ́j tɨ ayén tiraatáꞌan tiꞌitɨ́j tɨ raatáhuaviira. Capu nuꞌu aꞌij rɨni tɨ puaꞌa raatáhuavii jáꞌitaꞌa aꞌu tɨ tihuajéꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Aj puꞌi áꞌuraa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨ́ꞌɨj i ayén tíyaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ runáàna tɨjɨ́n: ―¿Tiꞌitájni neraatáhuavii ɨ́ tajtuhuan? ―Yee pu tiraataꞌíhuaꞌuriꞌi. Aj pu i ayén tiuꞌutaniú aꞌɨ́jna ɨ́ náànajraꞌan tɨjɨ́n: ―Huatáhuaviiriꞌi hui ɨ́ muꞌúuraꞌan aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuaca. ");
INSERT INTO crnNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Aj pu i ajtahuaꞌa caꞌanacan uteájrupi aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ tajtuhuan tɨ veꞌée. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Ayee nu tíꞌijxeꞌeveꞌe pej naataꞌɨ́ꞌɨteꞌen tuxaꞌa jetze ɨ́ muꞌúuraꞌan ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuaca tej ti ramuaꞌareere tɨjɨ́n puꞌuri huamɨ́ꞌɨ. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ yaujraꞌan ɨ́ Herodías. ");
INSERT INTO crnNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Temuaꞌa pu aꞌij puaꞌa tiraatáꞌa aꞌɨ́jna ɨ́ tajtuhuan tɨ ruseɨ́j ayén teꞌataújratziiriꞌi tɨ ayén nuꞌu huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa ɨ́ yaujraꞌan ɨ́ Herodías. Majta aꞌɨ́ɨme tɨ huaúꞌinee, aꞌɨ́ɨ mú majta ráanamuajriꞌi tɨ́ꞌɨj raatáꞌa ɨ́ runiuuca. Aꞌɨ́j pu jɨ́n rutéviꞌiraꞌacaꞌa huáꞌa jemi aꞌɨ́jna ɨ́ tajtuhuan. Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨn raꞌaráꞌaste ɨ́ runiuuca. ");
INSERT INTO crnNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ajta áꞌiyen xantaaruꞌu huataꞌáitecaꞌa tɨ raajéꞌicatan, ajta nuꞌu áꞌiyen yeꞌaráꞌɨꞌiteꞌen ɨ́ muꞌúuraꞌan ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ajta áꞌuraa ɨ́ xantaaruꞌu. Tɨ́ꞌɨj jí aꞌuun aꞌaráꞌa áa tɨ aiteánamiꞌihuacaꞌa aꞌɨ́jna ɨ́ Juan. Aj puꞌi ruꞌijveíjchecaꞌa ɨ́ muꞌúuraꞌan ɨ́ Juan. Tɨ́ꞌɨj jí yaꞌaráꞌɨꞌite ɨ́ tuxaꞌa jetze. Ajta aꞌɨ́ɨn ɨ́ tajtuhuan, aꞌɨ́ɨ pu raatáꞌɨꞌite aꞌɨ́jna ɨ́ yaujraꞌan ɨ́ Herodías. Tɨ́ꞌɨjtáꞌi aꞌɨ́ɨn raatáꞌɨꞌite ɨ́ runáàna. ");
INSERT INTO crnNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Majta meꞌɨ́n ɨ́ mej áꞌujujhuaꞌaneꞌe jamuan ɨ́ Juan, matɨ́ꞌɨj ráamuaꞌareeriꞌi, aj mú mi aꞌuréꞌene jemin Heródes, meyaꞌutɨ́ɨ aꞌɨ́jna ɨ́ mɨ́ꞌɨchi. Matɨ́ꞌɨj mi raꞌaváꞌana. Yee pu éeniꞌicɨꞌen huamɨ́ꞌɨ aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Majta meꞌɨ́n ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́ɨ mú tiújseɨj aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Aj mú mi raatáꞌixaa nain aꞌij mej tiꞌitɨ́j huáruu, nain aꞌij mej yeꞌí tihuaꞌumuáꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aj puꞌi ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Mú seꞌutáuruyiꞌi. Tichéꞌe huátaseꞌupeꞌen mé jáꞌahuaꞌa aꞌu tɨ caí tiꞌitɨ́ eꞌeréꞌevee. ―Ayee pu tiuꞌutaxájtacaꞌa. Aru jeíhua mú aꞌuréꞌenineicaꞌa ɨ́ teɨte aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Majta aꞌucɨ́ꞌɨcaꞌa jemin mé muꞌiitɨ́ ɨ́ teɨte. Aꞌɨ́j pu jɨ́n camu huatácɨꞌɨpejcaꞌa mej tiúꞌucuaꞌani aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Aj mú mi aꞌucɨ́j rujɨ́ɨmuaꞌa baarcu jetze. Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌu tɨ caí éꞌe jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Majta meꞌɨ́n ɨ́ teɨte, aꞌɨ́ɨ mú huaꞌaseíiracaꞌa matɨ́ꞌɨj aꞌucɨ́j. Jeíhua mú raamuáꞌa ɨ́ Jesus. Aꞌɨ́j mú jɨ́n ruꞌɨcán aꞌiréꞌeneajxɨ aꞌu tɨ naꞌa mej aꞌuchéjme. Aꞌɨ́ mú mi amuacaí aꞌaráꞌa aꞌu tɨ eꞌeráꞌastiicheꞌe aꞌɨ́jna ɨ́ Jesús, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ajta, tɨ́ꞌɨj aꞌɨ́ɨn aꞌitaméꞌecaꞌa ɨ́ baarcu jetze, jeíhua pu teɨte huaséijracaꞌa. Tɨ́ꞌɨj jí ii huataújxɨeemɨste tɨ́ꞌɨj huaꞌuseíj. Yee mú titejaꞌuvátzɨj cumu cáneꞌaxɨ tɨ caí jaꞌatɨ́ huáꞌa cujtaꞌa huaméꞌecaa. Aꞌɨ́j puꞌi jɨ́n aꞌutéjche aꞌɨ́jna ɨ́ Jesús tɨ tihuáꞌumuaꞌaten jeíhua. ");
INSERT INTO crnNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Tɨ́ꞌɨj huateáchumuaꞌarecaꞌa, aj mú mi aveꞌeréꞌene jemin ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Puꞌuri téchumuaꞌari. Ajta caí jaꞌatɨ́ yeꞌeche ayajna vejliꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Teajta caí tiꞌitɨ́j tíchaꞌɨɨ mej ráacuaꞌani mɨ teɨte. Patáꞌaj huaꞌuréꞌitixɨꞌɨn, mej mi aꞌucɨ́jxɨꞌɨn mé jáꞌahuaꞌa chajtaꞌa, aꞌu mej aꞌuchéjme teɨte mej mi pan huánanan. ");
INSERT INTO crnNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús, tɨjɨ́n: ―Múꞌeen xu tihuáꞌamin rujɨ́ɨmuaꞌa senaꞌa. Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―¿Ni rɨꞌɨrí tej áꞌujuꞌun tej pan aꞌuvéꞌenanan tej ti tihuaꞌumín? Tɨ́ puaꞌa tiyen tíꞌituaaveꞌe aꞌachú tɨ caj jaꞌatɨ́ tíꞌijmuaꞌitɨcɨ tɨ puaꞌa tiuꞌumuárɨꞌen aꞌachú cumu huaꞌapua ciento xɨca jɨmeꞌe, capu ajta tiꞌicɨꞌɨpée aꞌame ɨ́ tumin tej ti tiyen huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aj puꞌi aꞌɨ́ɨn ɨ́ Jesús, ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu, xaaréꞌixɨꞌereꞌe aꞌachúni caj mé tirájchaꞌɨɨ ɨ́ pan. Matɨ́ꞌɨj mi ráamuaꞌareeriꞌi. Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Aꞌi puꞌu caj tíꞌixuaavi. Anxɨ́vi ɨ́ pan. Majta huaꞌité, caj mú tíꞌitehuaꞌapua. ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tɨ́ꞌɨj jí huaꞌutaꞌaíjtacaꞌa mej aꞌujráꞌase áa tɨ áꞌutuꞌupi mé muꞌiitɨ́ méꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Aj mú mi aꞌujráꞌasecaꞌa, seica anxɨ́te mé arástɨméj, majta seica huaꞌapuate japuan tamuáamuataꞌa mú arástɨméj. ");
INSERT INTO crnNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Aj puꞌi aꞌɨ́ɨn ɨ́ Jesús, raꞌancuréꞌeꞌɨꞌɨpɨꞌɨ ɨ́ pan, ajta aꞌɨ́mej ɨ́ huaꞌité. Tɨ́ꞌɨjtaꞌi raꞌantítaaraxɨ ɨ́ pan, aj mú mi huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ teɨte. Majta ɨ́ huaꞌité, aꞌɨ́ɨ mú huatámuꞌiirecaꞌa. Aj puꞌi huaꞌutáꞌɨ́ꞌɨpɨꞌi aꞌɨ́jna ɨ́ Jesús ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe mej mi huaꞌuréꞌeꞌɨꞌɨpɨꞌiteꞌen ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Naíjmiꞌi mú tiúꞌucuaa ɨ́ teɨte. Temuaꞌa mú jeíhua titéejuꞌuxai. ");
INSERT INTO crnNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ajta jeíhua pu aváꞌaturaa ɨ́ pan, majta ɨ́ huaꞌité. Tamuáamuataꞌa japuan huaꞌapua mú teꞌevéꞌejɨste tiꞌitɨ́ sicɨ́ri jetze aꞌɨ́jna jɨmeꞌe ɨ́ tɨ aváꞌaturaa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Majta meꞌɨ́n ɨ́ mej tiúꞌucuaa ɨ́ teteca, ayée mú aráꞌaxcaa aꞌachú cumu anxɨ́j viꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tɨ́ꞌɨj jí Jesús pu huaꞌutaꞌaíj mej atécɨɨne ɨ́ baarcu jetze mej antácɨɨne utavén pújmeꞌen, mej nuꞌu amuáatée eꞌaráꞌasti aꞌájna Betsaída. Mɨ́ ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu aꞌuun aꞌuteájturaa tɨ́ꞌij huaꞌaréꞌeꞌitixɨꞌɨn ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Tɨ́ꞌɨj huaꞌuréꞌitixɨ, aj puꞌi áꞌuraa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí aꞌuun aꞌaráꞌa aꞌu tɨ áꞌujɨ́rime tɨ́ꞌij raatéjhuauni ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tɨ́ꞌɨj huateátɨcaꞌarecaꞌa, áa mú meri aꞌujuꞌucaa jáꞌitaꞌa ɨ́ jaj japua, jetzen muaꞌaraatéꞌee ɨ́ baarcu. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu ruseɨ́j aꞌutácatii jɨrí jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Tɨ́ꞌɨj jí raaseíj tɨ huáꞌamuarɨꞌeristeꞌecaꞌa mej antácɨɨne jaj japua aꞌiné á pu eꞌevéꞌeecacaꞌa. Tɨ́ꞌɨj tapuáꞌarijmeꞌeca, aꞌɨ́ɨ pu á eꞌiréꞌene aꞌájna vejliꞌi mej huajúꞌucaa baarcu jetze. Aꞌɨ́ pu huaméꞌecaa ɨ́ jaj japua. Puꞌuri huaꞌantinájchijmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Majta meꞌɨ́n, matɨ́ꞌɨj raaseíj, metiuꞌutátziɨn. Muaajíjhuacaꞌa naíjmiꞌi aꞌiné naíjmiꞌi mú raaseíj tɨ huaméꞌecaa ɨ́ jaj japua. Ayee mú tiuꞌumuáꞌaj tɨjɨ́n: “Chéjcan pu púꞌeen.” Aj puꞌi ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Xaateújcaꞌane ɨ́ ru tzajtaꞌa. Caxu tíꞌitziɨɨneꞌe. Nee nu neꞌɨ́n pɨ́rɨcɨ ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aj puꞌi ateájraa ɨ́ baarcu jetze aꞌu mej aꞌaráteꞌecaꞌa. Tɨ́ꞌɨj jí huateápuaꞌarecaꞌa tɨ huáꞌeecacaꞌa. Aj mú mi aꞌij teꞌutaseíj. Tɨ́ꞌɨj jí utéevatzɨ́ ɨ́ huáꞌa tzajtaꞌa ɨ́ mej tíꞌimuaꞌajca. ");
INSERT INTO crnNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jéꞌecan mú tíꞌimuaꞌajca aꞌiné camu yaúꞌitɨée muáꞌaraa aꞌij tɨ ꞌéen jɨ́n raayɨ́ꞌɨtɨ tɨ aꞌɨ́ɨn raatámuꞌiiren ɨ́ pan, aꞌiné rujɨ́ɨmuaꞌa muaꞌanteújnaamua ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Matɨ́ꞌɨj mi antacɨ́j jaj japua. Aꞌuu mú mi aꞌaráꞌa aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Genesaret. Aa tɨ eꞌeveꞌeꞌástɨme ɨ́ jaj, áa mú raꞌijtápe ɨ́ baarcu. ");
INSERT INTO crnNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jɨ́meꞌen muꞌu aitacɨ́j ɨ́ baarcu jetze, áꞌiyen mú raamuáꞌa aꞌɨ́jna ɨ́ Jesús ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aꞌɨ́j mú mi jɨ́n caꞌanacan meruaachijméꞌe, á mé veꞌeréꞌene ɨ́ jemin. Matɨ́ꞌɨj mi autéjhuii mej huáꞌajseɨreꞌen utaatzi japua ɨ́ mej tíꞌicucuiꞌi aꞌájna aꞌu mej yéꞌemuaꞌareerecaꞌa tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ajta aꞌu tɨ naꞌa tɨ aꞌuréꞌenineicaꞌa raanchu tzajtaꞌa tɨ huachájtaꞌajme naꞌari tɨ chajtaꞌa tɨ vivéjme, aꞌu tɨ naꞌa neꞌu, mehuaꞌuráatzajyeꞌicaa caaye jetze. Aj mú mi rájhuaviiriꞌi aꞌɨ́jna tɨ huaꞌutáꞌan mej raꞌajtamuárɨꞌen cɨ́ɨxureꞌaraꞌan jetze, aꞌɨ́jna jetze tɨ uvíjpiꞌi ɨ́ síicuꞌureꞌaraꞌan tɨ́ꞌij aꞌachú mej puaꞌamé raꞌajtamuárɨꞌen, mej mi huarún. Ayee puꞌu xaa neꞌu tiúꞌuruu aꞌájna u Genesaret. ");
INSERT INTO crnNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Matɨ́ꞌɨj mi meꞌɨ́n ɨ́ fariseo, jamuan majta seica ɨ́ mej téꞌeyuꞌuxaca teyujtaꞌa mej mi meꞌɨ́jna huaruitɨejteꞌen aꞌij mej yeꞌí rɨ́ɨj muáꞌayeꞌi, aꞌúu mú eꞌeráacɨ u Jerusalén, majta meꞌuun aꞌaráꞌa aꞌutɨ́ aꞌutéveecaꞌa ɨ́ Jesús mej mi rájjaahuate. Matɨ́ꞌɨj mi huaꞌuseíj aꞌɨ́mej ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe mej caí amuaújmuaijteaꞌaxɨ mej tiúꞌucuaa aꞌij mej tíꞌijrɨꞌɨrejcaꞌa ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Majta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, ɨ́ mej majta miyen ánteꞌarua tɨjɨ́n fariseo, aꞌɨ́ɨ mú ráꞌatzaahuateꞌe ɨ́ ruvaújsimuaꞌa teecan tíꞌiyeꞌira. Ayee mú cheꞌatá menaꞌa rɨjca naíjmiꞌi ɨ́ mej Israél jetze ajtémeꞌecan. Capu tíꞌiseicaj naꞌa ɨ́ tihuáꞌayeꞌira ɨ́ mej jɨ́n amuaújmuaijteꞌaxɨꞌɨn. Tɨ́ puaꞌa jaꞌatɨ́ tiúꞌucuaꞌani, amuacaí pu nuꞌu ruxeꞌeveꞌe tɨ aꞌɨ́ɨn jaꞌatɨ́ jeíhua amuaújmuaijteꞌen, naꞌari caí, ayée muꞌu tíꞌixaxaꞌa tɨjɨ́n xánaꞌavisiꞌi pu seijreꞌe aꞌɨ́jna ɨ́ jaꞌatɨ ɨ́ tayeꞌirá jemi. Ajta, tɨ puaꞌa jaꞌatɨ́ tejaꞌuvéꞌenanan aꞌujna aꞌu mej tejáꞌatua aꞌɨ́ɨ pu caí tíꞌicuaꞌani tɨ puaꞌa caí amuacaí amuaújmuaijteꞌen. Ajta tiꞌimuꞌíi tɨ ayén jɨ́n teꞌaváꞌujmuaꞌaree ɨ́ ruvaújsimuaꞌa teeca tihuáꞌayeꞌira. Ayee mú rɨjca: metíꞌijaꞌusica ɨ́ vaasu ɨ́ mej jɨ́n yeꞌeca. Aꞌɨ́j mú majta tíꞌijaꞌusica ɨ́ tiꞌitɨ́ xaꞌari, majta ɨ́ casueela. ");
INSERT INTO crnNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Matɨ́ꞌɨj mi meꞌɨ́n fariseo, majta aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca teyujtaꞌa, aꞌɨ́ɨ mú miyen tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Aꞌiné ꞌéen jɨ́n mecaí ráꞌaste ɨ́ tavaújsimuaꞌa teeca tíꞌiyeꞌira ɨ́ mej ajamuan áꞌujujhuaꞌan? Ayee muꞌu rɨcɨ mej xánaꞌavisiꞌi tíꞌicuaꞌa ɨ́ rumuájcaꞌa jɨmeꞌe. ―Yee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ fariseo. ");
INSERT INTO crnNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tɨ́ꞌɨj jí ayén tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Temuaꞌa pu tejámuaavíjteꞌe ɨ́ tɨ ayén ajmíꞌi tiraꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Isaías teecan, aꞌɨ́jna tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Aꞌɨ́ pu raꞌuyúꞌuxacaꞌa temuaꞌa aꞌij sej ꞌeen mɨ sej caí huataújcɨꞌɨpuáacan jɨ́n tihuáꞌaijteꞌe ɨ́ teɨte sino ayée xu tiúꞌujseijrata ɨ́ teɨte jemi sej nain jɨ́n ráꞌastijreꞌe. Ayee pu raꞌuyúꞌuxacaꞌa aꞌɨ́jna tɨjɨ́n: Rɨ́ꞌɨ mú tineeteátuꞌaraca tɨ puaꞌa metíꞌixajta ineetzi jɨmeꞌe. Mɨ́ ajtáꞌi, muꞌuri ajtacɨ́j ineetzi jemi rumuaꞌatzíiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Capu tiꞌitɨ́j vaɨreꞌe tɨ puaꞌa metiuꞌuteánajche ineetzi jemi. Ayee mú tiꞌihuáꞌamuaꞌatehua tɨjɨ́n: “Dios pu raateájtuaa i tayeꞌirá itejmi jemi.” Mɨ́ ajtáꞌi caí, capu, rujɨ́ɨmuaꞌa menaꞌa mú rájteu ɨ́ ru tzajtaꞌa. Yee pu hui raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Isaías teecan. ");
INSERT INTO crnNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","’Ayee xuꞌu rɨcɨ. Múꞌeen sej seri yaꞌuhuáꞌaxɨ aꞌij tɨ ajmíꞌi tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios, sej si siyen huárɨni aꞌij mej tíꞌijxeꞌeveꞌe ɨ́ teɨte. Aꞌɨ́ pu amuaꞌaráanajche ɨ́ tihuáꞌayeꞌira, tɨ ayén tiúꞌujxeꞌeveꞌe tɨ xaꞌari tiuꞌujáꞌusin naꞌari tɨ tiuꞌujáꞌusin ɨ́ vaasu ɨ́ sej jɨ́n yeꞌeca. Jeíhua pu ajta tiúꞌujxeꞌeveꞌe tɨ ayén tíꞌeen. Ayee pu neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","’Temuaꞌa xu seri yaꞌuhuáꞌaxɨ aꞌij tɨ tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios, setáꞌaj raꞌaráꞌasten ɨ́ huaꞌayeꞌira ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ayee pu tíꞌeen, aꞌiné ayej tiraataxájtacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, tɨjɨ́n: “Patáꞌaj ráꞌatzaahuateꞌe aꞌatáàta, ajta aꞌanáàna.” Ajta ayén tɨjɨ́n: “Setáꞌaj raajéꞌica aꞌɨ́jna ɨ́ jaꞌatɨ tɨ aꞌij puaꞌa tíꞌixaxaꞌa ɨ́ rutáàta jemi naꞌari ɨ́ runáàna jemi.” ");
INSERT INTO crnNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","’Mɨ́ seajta múꞌeen, ayée xu tiratáꞌaca tɨ jaꞌatɨ ayén tihuaꞌutáꞌixaateꞌen ɨ́ ruvaújsimuaꞌa ɨ́ runiuuca jɨmeꞌe tɨjɨ́n Corbán. (Ayee pu huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨjɨ́n muaɨꞌɨvéjri pu pɨ́rɨcɨ.) Ajta ayén tɨjɨ́n: “Naíjmiꞌi, aꞌachú nej caj tíꞌijchaꞌɨɨ, aꞌɨ́j nu neri raatámuaɨꞌɨvejte ɨ́ Dios. Aꞌɨ́j nu jɨ́n necaí chéꞌe tíꞌijchaꞌɨɨ ɨ́ nej jɨ́n amuaatévaɨreꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Tɨ́ puaꞌa hui jaꞌatɨ́ ayén tihuaꞌutáꞌixaateꞌen tɨjɨ́n: “Corbán”, ca xu chéꞌe raatáꞌacareꞌen tɨ aꞌɨ́ɨn huaꞌutévaɨreꞌen ɨ́ ruvaújsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Aꞌɨ́j xu jɨ́n, siyen á tirúurɨeeni ɨ́ tɨ jɨ́n tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios aꞌɨ́jna jɨmeꞌe ɨ́ áꞌamuayeꞌira sej seica huatátuꞌireꞌen. Jeíhua xu siyen tíꞌijrɨꞌɨre. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tɨ́ꞌɨj jí ajtahuaꞌa huaꞌutajé ɨ́ teɨte. Aj pu i ayén tihuaꞌutáꞌixaa. Tɨjɨ́n: ―Múꞌeen xu ráanamua naíjmiꞌi, sej si yaúꞌitɨée xáꞌaraꞌani: ");
INSERT INTO crnNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tiꞌitɨ́ tɨ aꞌij ɨ́ tɨ tíꞌicuaꞌiriꞌi, tɨ puaꞌa jaꞌatɨ́ ráacuaꞌani, capu aꞌatzu raxanaꞌaveꞌe. Capu raxanaꞌaveꞌe aꞌiné mé puaꞌacɨé pu meꞌecan. Mɨ́ ajta ɨ́ tɨ tzajtaꞌan meꞌecan, aꞌɨ́ɨ pu xaa raxanaꞌaveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Múꞌeen xu rarɨ́ꞌɨrejve, rɨ́ꞌɨ xu tiráanamua. ");
INSERT INTO crnNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tɨ́ꞌɨj caí chéꞌe méꞌe aꞌatɨ́jcaꞌa, aj pu i aꞌɨ́ɨn aꞌuteájrupi u chiꞌita. Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi aꞌij tɨ huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨ jɨ́meꞌen aꞌɨ́jna tɨ nuꞌu raxanaꞌaveꞌe ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Aj puꞌi ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni tzaa secaí seajta yaúꞌitɨée xaꞌaraa? ¿Ni tzaa secaí yaúꞌitɨe seꞌɨ́jna? Tɨ́ puaꞌa jaꞌatɨ́ tiꞌitɨ́j huácuaꞌani tɨ tíꞌicuaꞌiriꞌi, aꞌɨ́jna tɨ ráacuaꞌani, mé puaꞌacɨé pu éꞌemeꞌecan. Aj pu i ucáruti ɨ́ jucáaraꞌan jetze. Ajta áꞌiyen huiráame ɨ́ chuitɨreáaraꞌan jetze. Aꞌɨ́j pu jɨ́n caí raxanaꞌaveꞌe aꞌiné capu rájrupi ɨ́ tzajtaꞌan, ɨ́ xɨéjniuꞌucareꞌaraꞌan jetze. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Ajta ayén tihuaꞌutáꞌixaa tɨ iꞌi rɨ́ꞌen naíjmiꞌi tɨ́j naꞌa tɨ tíꞌicuaꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́jna tɨ tzajtaꞌan airáninei, amɨ́ pu xaa raxanaꞌaveꞌe ɨ́ tevi. ");
INSERT INTO crnNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Aꞌuu pu huiráayeꞌi ɨ́ tzajtaꞌan ɨ́ tevi naíjmiꞌi ɨ́ muaꞌatzíiraꞌa tɨ aꞌij puaꞌa eꞌen, tɨ ajta caꞌaníjraꞌa ratáꞌaca ɨ́ tevi tɨ́ꞌij aꞌij puaꞌa tiúꞌumuaꞌati, tɨ́ꞌij tiúꞌujxanaꞌacɨraꞌaten seɨj jamuan tɨ caí ratéviꞌitɨn, naꞌari ꞌɨ́itaꞌa ayén huaújxanaꞌacɨraꞌaten seɨj jamuan tɨ caí cɨ́naꞌaraꞌan púꞌeen. ’Aꞌuu pu hui tzajtaꞌan ajta huiráayeꞌi ɨ́ muaꞌatzíiraꞌa tɨ caꞌaníjraꞌa ratáꞌaca ɨ́ tevi tɨ tiuꞌunáhuaꞌan naꞌari tɨ tiuꞌujéꞌica naꞌari tɨ chéꞌe naꞌa tiúꞌuxanaꞌacɨraꞌaten huáꞌa jamuan ɨ́ tɨꞌɨríi. ");
INSERT INTO crnNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","23","’Ajta aꞌúu pu huiráayeꞌi ɨ́ tzajtaꞌan aꞌíjna tɨ caꞌaníjraꞌa ratáꞌaca tɨ jaꞌatɨ tɨ ayén tiꞌitɨ́ tíꞌijmuaireꞌe ɨ́ tɨ tíꞌijchaꞌɨɨ ɨ́ seɨj naꞌarɨ́ tɨ jaꞌatɨ aꞌij puaꞌa rɨjca, nusu tɨ seɨj huácuanamuan. Ayee pu cheꞌatá naꞌa een tɨ puaꞌa jaꞌatɨ́ ayén aꞌij puaꞌa tiúꞌujepeꞌeveꞌen, naꞌari tɨ puaꞌa jaꞌatɨ́ seɨj ánchueereꞌen, nusu tɨ puaꞌa jaꞌatɨ́ aꞌij puaꞌa tiuꞌutájeeve, naꞌari áꞌujtzaahuateꞌe, caꞌɨ́n aꞌɨ́ɨn ayén rɨcɨ ɨ́ tɨ caí xɨ́ꞌepɨꞌɨn. Naíjmiꞌi tɨ́j naꞌa tɨ ayén een, aꞌúu pu huiráayeꞌi ɨ́ tzajtaꞌan ɨ́ tevi. Ayee nu hui tejáꞌamuaꞌixaateꞌe, aꞌɨ́ɨ pu xaa aꞌɨ́ɨn púꞌeen ɨ́ tɨ ruꞌuráchueemuareꞌe ɨ́ tevi ɨ́ ru tzajtaꞌa. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aj pu i Jesús áꞌuraa aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Tiro, amájna vejliꞌi u Sidón. A pu jáꞌahuaꞌa chiꞌita aꞌuteájrupi, aꞌiné capu raxɨ́ꞌeveꞌecaꞌa tɨ jaꞌatɨ ráamuaꞌaree tɨ aꞌuun aꞌutéveecaꞌa. Mɨ́ꞌajtáꞌi caí, capu huatárɨꞌɨristarecaꞌa tɨ huateuravajtáa. ");
INSERT INTO crnNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Capu xaa neꞌu, aꞌiné seɨj pu caꞌanacan ráamuaꞌareeriꞌi. ꞌƗ́itaꞌa pu puꞌeeneꞌe aꞌɨ́jna tɨ seɨj chuéjraꞌa japua éꞌemeꞌecan. Seɨ́j pu téviraꞌa puꞌeeneꞌe. Ayee mú huaꞌatamuáꞌamua tɨjɨ́n Sirofenicia, ɨ́ mej nuꞌu chiicate púꞌeen. Ajta aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu tiyáujcaꞌa, ɨ́iitacan tɨ tiyaaruꞌu tzajtaꞌan seijreꞌe. Aj pu i eꞌiréꞌene aꞌɨ́jna ɨ́ náànajraꞌan. Títunutacaꞌa aꞌájna vejliꞌi aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Aj pu i ayén tirájhuaviiriꞌi tɨ ruꞌirámuariteꞌen ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌe ɨ́ yaujraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Aj pu i ayén seɨj niuucari jɨ́n tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús, ayén tɨjɨ́n: ―Micheꞌe amuacaí tiúꞌucuaꞌani mɨ tɨꞌɨríi. Capu ayén tiraavíjteꞌe tɨ huaꞌaꞌɨ́ꞌɨpuiꞌi ɨ́ pan tɨ́ꞌij chiicate huataꞌɨ́ꞌɨpɨꞌiteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Aj puꞌi ayén tiuꞌutaniú aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, nevástaraꞌa. Aru casiꞌi, tɨ puaꞌa meꞌɨ́n tɨꞌɨríi raꞌacáhuaꞌanan tɨ teꞌení ɨ́ pan ɨ́ meesa japua, ¿ni qui mecaí racuaꞌani ɨ́ chiicate ɨ́ mej meesa jete eꞌiráꞌuu? ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Ayej xaa neꞌu tiraavíjteꞌe patɨ́j peri tiraataxájtacaꞌa. Patáꞌaj áꞌuraꞌani. Puꞌuri huirájraa ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa muáꞌayauj. ");
INSERT INTO crnNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Aj pu i áꞌuraa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨ́ꞌɨj jí aꞌaráꞌa ɨ́ ruche. Tɨ́ꞌɨj aꞌɨ́ɨn raaseíj aꞌɨ́jna ɨ́ ruyauj, tɨ án aꞌujcáꞌa utaatzi japua. Aj pu i aꞌɨ́ɨn ꞌɨ́itaꞌa ráamuaꞌareeriꞌi tɨ ari huirájraa ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ajtahuaꞌa pu huirájraa aꞌɨ́jna ɨ́ Jesús aꞌájna jáꞌahuaꞌa Tiro. Aj pu i u aꞌuréꞌene aꞌájna jáꞌahuaꞌa Sidón. Aꞌuu pu jáꞌitaꞌa aꞌatanéj aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Tamuáamuataꞌa tɨ Chájtaꞌajme. Tɨ́ꞌɨj jí aꞌuun aꞌaráꞌa aꞌájna jaj tɨ jéjmuaa, ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Galilea. ");
INSERT INTO crnNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Aj mú mi seɨj aꞌarájtɨ tɨ tíꞌicuiꞌi. Capu huiteájnamua aꞌɨ́jna ɨ́ jaꞌatɨ. Ajta capu téꞌanrɨꞌɨre. Aj mú mi rájhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús, tɨ raꞌajtamuárɨꞌen ɨ́ tɨ tíꞌicuiꞌi tɨ́ꞌij tiráahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Aj pu i aꞌatzu aꞌɨmuá raꞌiráaviꞌitɨ aꞌájna teɨte tzajtaꞌa. Tɨ́ꞌɨj jí aꞌɨ́ɨn Jesús, ɨ́ ruxɨté urújteꞌaxɨꞌɨ ɨ́ naxaitaꞌa ɨ́ tɨ tíꞌicuiꞌi. Tɨ́ꞌɨj jí ajta aꞌɨ́ɨn á chuaataꞌa á éꞌejtzitze. Aj puꞌi raꞌantiméijriꞌi neanureáaraꞌan jetze aꞌɨ́jna jɨmeꞌe ɨ́ ruꞌíjcɨꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tɨ́ꞌɨj jí júteꞌe áꞌujneerecaꞌa. Ajta ucayáatɨraa. Aj puꞌi ayén tiuꞌutaxájtacaꞌa ɨ́ runiuuca jɨmeꞌe tɨjɨ́n: ―¡Efata! ―Yee pu tiuꞌutaxájtacaꞌa. (Aꞌijna i niuucari, ayée pu huataújmuaꞌa tɨjɨ́n: “Teꞌantácuuna.” Ayee pu huataújmuaꞌa aꞌíjna tɨjɨ́n: “Efata.”) ");
INSERT INTO crnNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús, aj pu i aꞌɨ́ɨn huarúj ɨ́ tɨ tíꞌicuiꞌicaꞌa. Puꞌuri xaa aꞌájna huitenamuáaraꞌa jáꞌaraa. Ajta, ari téꞌanrɨꞌɨrejcaꞌa. Capu chéꞌe cáꞌachiraꞌacaꞌa ɨ́ neanureáaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ajta Jesús raatáꞌijmɨijriꞌi tɨ caí jaꞌatɨ́ huatáꞌixaateꞌen. Mɨ́ majta, camu miyen huarɨ́j. Aꞌachú tɨ caj ayén tíhuaꞌutaꞌaíteꞌencheꞌe, ayée mú cheꞌatá caj tíhuaꞌutaꞌixáateꞌencheꞌe ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Matɨ́ꞌɨj mi temuaꞌa aꞌij teꞌutaseíj ɨ́ teɨte. Miyen tɨjɨ́n: ―Rɨ́ꞌɨ pu tíꞌijrɨꞌɨre aꞌɨ́jna ɨ́ Jesús nain jɨmeꞌe. Aꞌɨ́ pu hui raayɨ́ꞌɨtɨ tɨ tihuáꞌuhuaateꞌen mej mi huitenamuáaraꞌa muáꞌaraꞌani, ajta mej mi teꞌanrɨꞌɨrée muáꞌaraꞌani ɨ́ mej caí téꞌanrɨꞌɨréjme. ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tɨ́ꞌɨj áꞌajaꞌa aꞌuun aꞌutéveecaꞌa aꞌujna Galilea ɨ́ Jesús, jeíhua mú teɨte tiújseɨj. Camu tiꞌitɨ́j tíchaꞌɨɨcaꞌa mej ráacuaꞌani. Tɨ́ꞌɨj jí aꞌɨ́ɨn Jesús huaꞌutajé aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Neánxɨeemɨsteꞌe amɨ́ɨme jemi mɨ teɨte, aꞌiné puꞌuri huaíca xɨca teuumé mej áꞌujujhuaꞌan nee jamuan. Camu majta tiꞌitɨ́j tíchaꞌɨɨ ɨ́ mej ráacuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Seica mú ɨmuá curéꞌecɨjxɨ. Aꞌɨ́j pu jɨ́n tɨ puaꞌa nehuaꞌuréꞌitixɨꞌɨn ɨ́ ruche mecaí xɨ tiuꞌucuáꞌan, camu teꞌutáviicuaꞌira ɨ́ juye japua. ");
INSERT INTO crnNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi, tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri pej tihuaꞌumín ayajna aꞌu tɨ caí jaꞌatɨ́ éꞌeche? ―Ayee mú tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌachúni puaꞌaméca xaꞌɨ́ꞌɨpɨꞌɨsin ɨ́ pan? Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Arahuaꞌapuáca. ―Yee mú tiraataꞌixaa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Aj pu i raataꞌaíjtacaꞌa mej aꞌujráꞌasen ɨ́ teɨte á chuaataꞌa. Tɨ́ꞌɨj jí raatiɨ́ꞌɨpɨi ɨ́ pan júteꞌe aꞌɨ́jna ɨ́ Jesús. Aj pu i rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios jemi, ajta raꞌantítaaraxɨ. Aꞌɨ́j pu i huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majta meꞌɨ́n, aꞌɨ́ɨme mú huaꞌuréꞌeꞌɨꞌɨpɨꞌite ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Majta mú, seica huájchaꞌɨɨcaꞌa ɨ́ huaꞌité. Ajta pu raatáhuau ɨ́ Dios jemi. Tɨ́ꞌɨj jí huaꞌutaꞌaíj mej huaꞌuréꞌataꞌareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Naíjmiꞌi mú tiúꞌucuaa. Majta temuaꞌa titéejuꞌuxai. Ajta aváꞌaturaa ɨ́ pan tɨ raꞌantítaaraxɨ. Sicɨ́ri mú jetze raꞌavéꞌejɨsteꞌaxɨ aꞌɨ́jna tɨ aváꞌaturaa. Aráhuaꞌapua sicɨ́ pu teꞌaráꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Majta meꞌɨ́n ɨ́ teɨte ɨ́ mej tiúꞌucuaa, muaaráꞌasecaꞌa cumu muáacua viꞌiraꞌa. Aj pu i aꞌɨ́ɨn Jesús huaꞌaréꞌeꞌitixɨ ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tɨ́ꞌɨj jí ateájraa baarcu jetze, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi aꞌucɨ́j. Aꞌuu mú aꞌaráꞌa aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Dalmanuta. ");
INSERT INTO crnNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Matɨ́ꞌɨj mi fariseo á eꞌiréꞌene, majta áꞌiyen autéjhuii mej tíꞌiraꞌihuaꞌun meꞌɨ́jna ɨ́ Jesús. Meraatatése mej caꞌaníjraꞌa raatáꞌan tɨ ij aꞌɨ́ɨn autéꞌɨtzen. Meraatáhuaviiriꞌi tɨ huaꞌutaseíjrateꞌen ɨ́ mej jɨ́n aꞌij teꞌutaseíj mej nuꞌu mi jɨ́n ráamuaꞌaree aꞌɨ́jna tɨ jetzen araújcaꞌane aꞌɨ́jna ɨ́ Jesús, tɨ puaꞌa aꞌuun paꞌuvéꞌemej aꞌɨ́jna jemi tɨ júteꞌe éꞌeseijreꞌe tɨ ij ayén huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Aj pu i aꞌɨ́ɨn caí chéꞌe aꞌij teꞌanrɨꞌɨrée jáꞌaraa. Tɨ́ꞌɨj jí ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―¿Aꞌiné een jɨ́n ménehuavii aꞌímej teɨtejraꞌa nej tiꞌitɨ́ huaꞌutaseíjrateꞌen ɨ́ mej jɨ́n ráamuaꞌaree aꞌu tɨ éꞌemeꞌecan ɨ́ nej jɨ́n tíꞌimɨjhuaca? Ajta ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee nu xaa neꞌu tejáꞌamuaꞌixaateꞌe múꞌejmi, canu tiꞌitɨ́j amuaataseíjrateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aj pu i huajauhuáꞌaxɨ ɨ́ teɨte. Tɨ́ꞌɨj jí ajtahuaꞌa ateájraa ɨ́ baarcu jetze. Aj mú mi aꞌucɨ́j utavén pújmeꞌen pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Majta meꞌɨ́n ɨ́ mej áꞌujujhuaꞌaneꞌe jamuan ɨ́ Jesús, aꞌɨ́ɨ mú yaꞌuhuáꞌaxɨ mej yaꞌaraꞌɨ́ꞌɨpɨ́n ɨ́ pan mej ráacuaꞌani. Seɨj muꞌu caj tiuꞌɨ́ꞌɨsimeꞌe aꞌɨ́jna ɨ́ baarcu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Aj pu i ayén tíhuaꞌutaꞌaíj tɨjɨ́n: ―Xaanamuajriꞌi múꞌeen. Rɨ́ꞌɨ xuꞌu seꞌɨ́jna jɨmeꞌe ɨ́ fariseo mej rajnájchi ɨ́ pan jetze tɨ́ꞌij huacúꞌusta, seajta seꞌíjna jɨmeꞌe mej majta rajnájchi ɨ́ mej Heródes jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Matɨ́ꞌɨj mi autéjhuii mej tiꞌitiúrixaateꞌen ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Miyen tɨjɨ́n: ―Yee pu aꞌɨ́jna jɨ́n tiuꞌutaxájtacaꞌa aꞌiné catu pan tíchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aj pu i ráamuaꞌareeriꞌi aꞌij mej yeꞌí tíꞌixajtacaꞌa. Tɨ́ꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné een jɨ́n siyen tiꞌixa yee sejcaí pan tíchaꞌɨɨ? ¿Ni tzaa secaí xɨ yaúꞌitɨée, caꞌɨ́n secaí xɨ tihuáuritɨejte? ¿Ni caí tiꞌitɨ́ aꞌamua jetze tásiseiiri? ");
INSERT INTO crnNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ni tzaa secaí tíꞌiseij, caꞌɨ́n secaí tíꞌinamua? ¿Ni secaí ramuaꞌaree? ");
INSERT INTO crnNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Aꞌachúni puaꞌan sicɨ́ri aváꞌaturaa ɨ́ pan tɨ teꞌaváꞌaturaa netɨ́ꞌɨj huaꞌuréꞌeꞌɨꞌɨpɨꞌi ɨ́ mej anxɨ́j viꞌiraꞌa aráꞌaxcaa ɨ́ teɨte aꞌɨ́jna jɨmeꞌe tɨ anxɨ́vi aráꞌaxcaa ɨ́ pan? ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Tamuáamuataꞌa japuan huaꞌapua pu aváꞌaturaa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Aj pu i aꞌɨ́ɨn Jesús, ayén ajtahuaꞌa tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Ajta ¿aꞌachúni puaꞌan sicɨ́ri sétéꞌeveꞌejɨ́steꞌaxɨ seꞌɨ́jna mé tíꞌiveꞌaa taꞌaráhuaꞌapua tɨ aráꞌaxcaa netɨ́ꞌɨj tihuaꞌumí ɨ́ mej muáacua viꞌiraꞌa aráꞌaxcaa? Aj mú mi miyen titeetaniú tɨjɨ́n: ―Arahuaꞌapua sicɨ́ri. ");
INSERT INTO crnNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Ni tzaa secaí xɨ yaúꞌitɨée, múꞌeen? ");
INSERT INTO crnNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Matɨ́ꞌɨjtá mi meꞌuun aꞌaráꞌa aꞌájna jáꞌahuaꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betsaída. Matɨ́ꞌɨj mi seɨj jeꞌiréꞌeneijte tɨ arácuunicaꞌa. Aj mú mi rájhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús tɨ raꞌajtamuárɨꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tɨ́ꞌɨj jí aꞌɨ́ɨn Jesús rajvíꞌi muájcaꞌareꞌaraꞌan jetze aꞌɨ́jna ɨ́ tɨ arácun. Yaꞌuviꞌitɨ́ á puaꞌacɨé ɨmuá aꞌujna aꞌu tɨ éꞌechajtaꞌa. Aꞌɨ́ pu ruꞌíjcɨꞌe raꞌarámeijraxɨ á jɨꞌɨseáaraꞌan jetze. Ajta raꞌavéꞌemuarɨej. Tɨ́ꞌɨj jí raataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni hui peri mé úunee? ");
INSERT INTO crnNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Aj pu i aꞌɨ́ɨn ɨ́ taꞌarácun, antanéerejyeꞌicaa, ayén tɨjɨ́n: ―Ahuii, teteca nu seɨj. Cɨ xɨee cɨyej menaꞌa púꞌeen mej mú áꞌujujhuaꞌan. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ tɨ arácun. ");
INSERT INTO crnNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ajta aꞌɨ́ɨn Jesús, ajtahuaꞌa pu raꞌaráamuarɨe á jɨꞌɨseáaraꞌan jetze ɨ́ taꞌarácun. Ajtahuaꞌa pu rɨ́ꞌɨ meteúuneerecaꞌa. Puꞌuri xaa aꞌájna icu huarúj. Naíjmiꞌi pu tiꞌiseíjracaꞌa temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Aj pu i aꞌɨ́ɨn Jesús raataꞌítecaꞌa aꞌɨ́jna tɨ arácuunicaꞌa tɨ nuꞌu áꞌuraꞌani ɨ́ ruche. Ajta ayén tiraataꞌixaa tɨjɨ́n: ―Pecaj uteáruꞌipicheꞌen u chajtaꞌa. Ni pecáj pajta jaꞌatɨ́ ixaateꞌe aꞌíjna jɨmeꞌe aꞌij nej timuáahuaa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tɨ́ꞌɨj ayén tiujuꞌurɨ́j, aj puꞌi Jesús, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌúu mú aꞌaráꞌa aꞌu tɨ aꞌuchájtaꞌajmee, aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Cesarea de Filipo. Juye jetze mú aujúꞌucaa. Tɨ́ꞌɨj i ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―¿Aꞌiquí metíꞌixa ɨ́ teɨte yee aꞌatani nej pɨ́rɨcɨ inee? ");
INSERT INTO crnNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aj mú mi miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Seica mú miyen tiꞌixa tɨjɨ́n múꞌee pej peꞌɨ́n pɨ́rɨcɨ aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuacaꞌa, majta seica miyen tɨjɨ́n pej aꞌɨ́ɨn pɨ́rɨcɨ ɨ́ Elías. Majta seica, miyen tiꞌixa tɨjɨ́n pej nuꞌu aꞌɨ́ɨn pɨ́jíꞌirɨcɨ seɨj ɨ́ tɨ tiꞌitéjvee ɨ́ Dios jemi. ―Yee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tɨ́ꞌɨjtaꞌi aꞌɨ́ɨn ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Ari múꞌeen, ¿aꞌiné tejamuáꞌamitɨejteꞌe aꞌatani nej púꞌeen inee? Tɨ́ꞌɨj jí ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro, tɨjɨ́n: ―Múꞌee pej aꞌɨ́ɨn pɨ́jíꞌirɨcɨ aꞌɨ́jna ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n ɨ́ Cɨríistuꞌu, ɨ́ tɨ Dios án yaꞌujyeíjtza ɨ́ ɨpuari japua. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro. ");
INSERT INTO crnNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Aj pu i aꞌɨ́ɨn huaꞌutáꞌijmɨijriꞌi mej caí jaꞌatɨ́ ixaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tɨ́ꞌɨj jí aꞌutéjche tɨ tihuáꞌumuaꞌaten. Ayee pu tihuaꞌutáꞌixaa tɨ aꞌɨ́ɨn ruseɨ́j, ɨ́ tɨ ajta teáataꞌa jetze airáane, aꞌɨ́ɨ pu nuꞌu jeíhua rajpuaíjtzi aꞌame. Ajta tɨ nuꞌu ayén ruxeꞌeveꞌe aꞌame mej caí raxɨ́ꞌeveꞌe muáꞌajuꞌun ɨ́ mej Israél jetze ajtémeꞌecan, majta ɨ́ mej veꞌecán jɨ́n títetateí u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca. Naíjmiꞌi mú nuꞌu caí raxɨ́ꞌeveꞌe muáꞌajuꞌun. Ajta ayén tihuaꞌutáꞌixaa mej nuꞌu raajéꞌicatan. Tɨ́ꞌɨj nuꞌu huamɨ́ꞌɨn, aj pu ijtáꞌi huatarújsin huaíca xɨcaj tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Temuaꞌa pu tihuaúꞌixaa eꞌehuauritɨéecan jɨmeꞌe. Ajta aꞌɨ́ɨn ɨ́ Pedro, aꞌɨ́ɨ pu raꞌiráaviꞌitɨ ayée. Aj puꞌi tiraatixáateꞌajraa tɨ nuꞌu caí ayén tiꞌitaúꞌaꞌacareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mɨ́ ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu ruhuáritaꞌa caꞌacheecajraa. Huaꞌuseíirajraa aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aj pu i aꞌɨ́ɨn ɨ́ Pedro titéꞌaxɨ. Ayen tɨjɨ́n: ―Aricu. Ajtáraꞌa ineetzi jemi, mɨ pej piyen tíꞌixaxaꞌa tɨ́j aꞌɨ́jna ɨ́ tiyaaruꞌu. Múꞌee pej caí piyen tíꞌimuaꞌatze aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios sino aꞌij mej tíꞌijxeꞌeveꞌe ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tɨ́ꞌɨj jí Jesús huaꞌutajé aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ajta ɨ́ teɨte. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ ne jamuan áꞌucheꞌecaneꞌen, ayée pu tiúꞌujxeꞌeveꞌe tɨ caí chéꞌe ayén rɨjca aꞌij tɨ ruseɨ́j tíꞌijxeꞌeveꞌe. Mɨ́ ajta, tɨ puaꞌa jaꞌatɨ́ áꞌucheꞌecaneꞌen ne jamuan, ayée pu tiúꞌujxeꞌeveꞌe tɨ rajpuaíjtzi áꞌaraꞌani ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. Ajta tɨ puaꞌa aꞌɨ́ɨn huámɨꞌɨni, capu aꞌij íꞌirɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","’Ayee nu tejámuaatáꞌixaateꞌesin. Tɨ́ puaꞌa jaꞌatɨ́ tiúꞌujtesiꞌireꞌe tɨ caí huámɨꞌɨni, aúcheꞌe pu mɨꞌɨni aꞌɨ́jna ɨ́ jaꞌatɨ. Aꞌij pu áꞌujɨsin ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuri. Mɨ́ ajta, tɨ puaꞌa jaꞌatɨ́ huámɨꞌɨni aꞌɨ́jna jɨmeꞌe tɨ áꞌucheꞌecaneꞌen neetzi jamuan, naꞌari aꞌɨ́jna jɨmeꞌe ɨ́ niúucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu ajtahuaꞌa huatarújsin. Ajtahuaꞌa pu rateuni ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuri. ");
INSERT INTO crnNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","’Ajta, tɨ puaꞌa jaꞌatɨ́ tiuꞌumuáꞌitɨn naíjmiꞌi tɨ́j naꞌa tɨ íiyen tíꞌiseijreꞌe chaanaca japua, ¿aꞌiquí tiraatévaꞌɨre aꞌɨ́jna tɨ raamuáꞌitɨ tɨ puaꞌa aꞌɨ́ɨn yáꞌurɨeeni ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuri? Capu tiꞌitɨ́ aꞌij tiraatévaꞌɨre, ¿ni caí? ");
INSERT INTO crnNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ni caí aꞌij tíꞌirɨꞌɨri tɨ huaújnanai ɨ́ ruxɨ́ejniuꞌuca tɨ ari yáꞌurɨe aꞌɨ́jna jɨmeꞌe ɨ́ tɨ tíꞌijchaꞌɨɨcaꞌa? Capu aꞌatzu aꞌij tíꞌirɨꞌɨri, icu. ");
INSERT INTO crnNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","’Ayee nu neajta tejáꞌamuaꞌixaateꞌe. Aꞌíjna i teɨtejraꞌa, jeíhua mú auteájturaa ɨ́ Dios jemi. Ayee mú eꞌen ɨ́ Dios jemi matɨ́j aꞌɨ́ɨme ɨ́ mej tiúꞌujxanaꞌacɨraꞌate ꞌɨ́itaꞌa jamuan. ’Tɨ́ puaꞌa setíꞌiteviꞌiraꞌa seꞌɨ́jna jɨmeꞌe mej ráamuaꞌaree ɨ́ teɨte sej ne jamuan áꞌujujhuaꞌan, naꞌari mej ráamuaꞌaree tɨ aꞌamuaráanajche i neniuuca, tɨ puaꞌa siyen tíꞌiteviꞌiraꞌa huáꞌa jemi, aj nu neajta inee i nej neajta teáataꞌa jetze airáane, nee nu niyen cheꞌatá nenaꞌa tíꞌiteviꞌiraꞌa naꞌame múꞌejmi jemi. Netíꞌiteviꞌiraꞌa nu naꞌame múꞌejmi jemi aꞌɨ́jna xɨcájraꞌa jetze netɨ́ꞌɨj neajtahuaꞌa yatanéjsin íiyen chaanaca japua. Veꞌecán nu jɨ́n tiꞌitevée naꞌame jemin ɨ́ Dios tɨ niyáꞌupua aꞌájna netɨ́ꞌɨj yatanéjsin huáꞌa jamuan ɨ́ mej tíꞌivaɨreꞌe ta japua ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, ayée nu tejáꞌamuaꞌixaateꞌe. Seica ɨ́ mej yé huatéꞌuu ayajna, aꞌɨ́ɨ mú caí xɨ cuiꞌini aꞌajtá menaꞌa caí amuacaí raaseíj tɨ́ꞌɨj yatanéjsin ɨ́ Dios tɨ́ꞌij tiuꞌutaꞌaíjta íiyen chaanaca japua aꞌɨ́jna jɨmeꞌe ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Teuuméꞌeca aꞌachú cumu arájsevi xɨca, aj puꞌi aꞌɨ́ɨn Jesús án aꞌujnéj jɨrí japua. Aꞌɨ́mej pu aꞌuvíꞌitɨ́ aꞌɨ́jna ɨ́ Pedro, ajta ɨ́ Jacobo, ajta ɨ́ seɨ́j, aꞌɨ́jna ɨ́ Juan. Ajta áꞌiyen seɨcɨé huaújruu aꞌɨ́jna ɨ́ Jesús, á mú aꞌunéjneꞌericaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tatzari pu jɨ́n seijreꞌecaꞌa aꞌɨ́jna. Temuaꞌa pu tiuꞌutécuainarecaꞌa ɨ́ cɨ́ɨxureꞌaraꞌan. Yee pu éeneꞌe seijreꞌecaꞌa tɨ́j seeri. Iíyen chaanaca japua capu máꞌa jaꞌatɨ́ tɨ raayɨ́ꞌɨtɨ tɨ cɨ́ɨxuri tiuꞌujáꞌusin tɨ́ꞌij ayén tiꞌicuáinaviꞌi áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Majta aꞌɨ́mej huaseíj aꞌɨ́jna ɨ́ Elías tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan, majta meꞌɨ́jna ɨ́ Moisés teecan. Aꞌɨ́ mú tíꞌixajtacaꞌa meꞌɨ́jna jamuan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aj pu i aꞌɨ́ɨn Pedro, ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. Ayen tɨjɨ́n: ―Maeestru, xɨ́ꞌepɨꞌɨn pu naa tej yé huatéꞌuu tiyajna. Tichéꞌe huaícaca huátaahuaa ɨnaamua. Seɨ́j tɨ múꞌeetzi huácɨꞌɨti, ajta seɨj aꞌɨ́jna ɨ́ Moisés, ajta seɨ́j aꞌɨ́jna ɨ́ Elías. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro. ");
INSERT INTO crnNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aꞌiné aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe ɨ́ Jesús metiuꞌutátziɨn huápɨꞌɨ. Ajta aꞌɨ́ɨn Pedro, capu aꞌij ráꞌamitɨejteꞌecaꞌa aꞌij tɨ yeꞌí tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tɨ́ꞌɨj jí jaitɨri eꞌecáviꞌirixɨ huáꞌa japua. Huáꞌa tzajtaꞌa pu rájrupi. Aj mú mi ráanamuajriꞌi tɨ jaꞌatɨ ayén tiuꞌutaxájtacaꞌa, tɨjɨ́n: ―Aꞌi pu Niyauj pɨ́rɨcɨ ɨ́ nej rachúꞌeveꞌe. Xáanamuajriꞌi seꞌíjna. ―Ayee pu tiuꞌutánamuajre. ");
INSERT INTO crnNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Matɨ́ꞌɨj huanéereajraa nain japua, capu chéꞌe éꞌe aꞌatɨ́jcaꞌa. Aꞌɨ́ puꞌu aꞌutéveecaꞌa huáꞌa jamuan aꞌɨ́jna ɨ́ Jesús. Aj mú mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Matɨ́ꞌɨj eꞌiicájuꞌucaa, aꞌɨ́ɨ pu tihuaꞌuꞌíjca aꞌɨ́jna jɨmeꞌe mej caí jaꞌatɨ́ ixaateꞌe aꞌij mej tiuꞌuséij, aꞌiné seica mú nuꞌu raajéꞌicatan aꞌɨ́jna tɨ ajta teáataꞌa jetze ajtémeꞌecan. Tɨ́ꞌɨj nuꞌu huamɨ́ꞌɨn, aj pu nuꞌu ijtáꞌi huatarújsin. Aj pu nuꞌu i huatárɨꞌɨristari mej raataxáj. ");
INSERT INTO crnNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aꞌɨ́j mú jɨ́n, avíitziꞌi jɨ́n tíꞌixajtacaꞌa aꞌij mej tiuꞌuséij. Ayee mú tiúꞌurihuaꞌuracaꞌa aꞌij tɨ huataújmuaꞌa aꞌíjna tɨ nuꞌu ajtahuaꞌa nuꞌu huatarún ɨ́ tɨ mɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi ɨ́ Jesús tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca, ¿aꞌiné een jɨ́n miyen tíꞌixaxaꞌa tɨ amuacaí yé nuꞌu uvéꞌenejsin aꞌɨ́jna ɨ́ Elías? ");
INSERT INTO crnNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Aꞌɨ́jna Elías amuacaí pu aꞌɨ́ɨn yé uvéꞌenejsin. Aꞌɨ́ pu nain tiꞌijéjcuareꞌen. Neajta inee, nichéꞌe aꞌatzu tejámuaataꞌíhuaꞌu. ¿Aꞌiné téꞌaxa ɨ́ yuꞌuxari jetze aꞌɨ́jna jɨmeꞌe i nej neajta teáataꞌa jetze airáane? Ayee pu téꞌaxa nej nuꞌu jeíhua rajpuaíjtzi naꞌame. Majta nuꞌu naꞌaxɨéehuariꞌira muáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","’Ayee nu tejáꞌamuaꞌixaateꞌe. Puꞌuri yé uvéꞌene aꞌɨ́jna ɨ́ Elías. Puꞌuri ayén teꞌaraúraste aꞌij tɨ yeꞌí téꞌeyuꞌusiꞌihuacaꞌa aꞌɨ́jna yuꞌuxari jetze. Seica mú miyen aꞌij puaꞌa ráaruuren aꞌij mej yeꞌí tíꞌijxeꞌeveꞌe. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Ajta áꞌuraa aꞌɨ́ɨme jamuan, aꞌɨ́jna ɨ́ Pedro, ajta ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Matɨ́ꞌɨj u eꞌiréꞌene aꞌu mé éꞌaij éꞌeneꞌe ɨ́ seica ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj mi huaꞌuseíj mej jeíhua eꞌetiújseɨreꞌecaꞌa ɨ́ teɨte huáꞌa jamuan meꞌɨ́jna ɨ́ seica. Aꞌɨ́ɨme mú majta huaseíj ɨ́ mej téꞌeyuꞌuxaca teyujtaꞌa. Aꞌɨ́ mú miyen tiúꞌurihuaꞌuracaꞌa. Majta mú tɨ́n níniuꞌucacucaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Majta meꞌɨ́n ɨ́ teɨte, matɨ́ꞌɨj raaseíj aꞌɨ́jna ɨ́ Jesús, jeíhua mú huataújtemuaꞌave. Matɨ́ꞌɨj mi aꞌuruáachejraa jemin mej mi raatateújteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tɨ́ꞌɨj jí aꞌɨ́ɨn ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni jɨ́n setiúꞌurihuaꞌu? ");
INSERT INTO crnNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Aj pu i seɨ́j tɨ aꞌutéveecaꞌa huáꞌa tzajtaꞌa, aꞌɨ́ɨ pu ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Maeestru, yee nu ravéꞌeviꞌitɨ ɨ́ niyauj, tiyaaruꞌu tɨ tzajtaꞌan seijreꞌe. Aꞌɨ́jna ɨ́ tiyaaruꞌu, aꞌɨ́ɨ pu caí ratáꞌaca tɨ huatáaniuni. ");
INSERT INTO crnNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Aꞌiné jaꞌanáj tɨ naꞌa tɨ aꞌɨ́ɨn tiyaaruꞌu rájviiviꞌi, ajta á yaꞌarájrɨeesin á chuaataꞌa. Ajta jeíhua áijjaamɨxcueꞌireꞌe áꞌayeꞌi aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. Ajta ancuréꞌujcɨꞌɨmee ɨ́ rutamej jɨmeꞌe. Ajta huatécɨyaaxari nain japua ɨ́ ru tzajtaꞌa. Nuꞌuri huaꞌutáhuaviiriꞌi ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan mej raatamuáriteꞌen meꞌɨ́jna ɨ́ tiyaaruꞌu. Mɨ́ majta meꞌɨ́n, camu raayɨ́ꞌɨtɨhuaꞌa muáꞌaraa. ―Yee pu tiraataꞌixaa aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aj puꞌi ayén tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús, tɨjɨ́n: ―¿Ni tzaa secaí raayɨ́ꞌɨtɨ múꞌeen? ¿Ni secaí xɨ́ɨ téꞌatzaahuateꞌe? ¿Aꞌachúni puaꞌan nineꞌiraꞌa ruxeꞌeveꞌe nej aꞌamua jɨmeꞌe huáviicuaꞌireꞌen sej si huaruitɨejteꞌen? ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Aj pu i ayén tíhuaꞌutaꞌaíjte tɨjɨ́n: ―Mé seꞌevéꞌeviꞌitɨchi mɨ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aj mú mi áa yeꞌevéꞌeviꞌitɨ. Ajta aꞌɨ́ɨn ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa ɨ́ paꞌarɨꞌɨ, tɨ́ꞌɨj aꞌɨ́ɨn huaseíj ɨ́ Jesús, aꞌɨ́ɨ pu raatécaꞌatzɨjxɨ ɨ́ paꞌarɨꞌɨ. Aj pu i aitáve á chuaataꞌa. Tɨ́ꞌɨj jí pɨ́ tavaɨ́jtzixɨ́, áijjaamɨxcueꞌireꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aj pu i Jesús ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ táàtajraꞌan ɨ́ paꞌarɨꞌɨ tɨjɨ́n: ―¿Aꞌachúni ari áꞌatee tɨ ayén tíꞌiruure? Ajta aꞌɨ́ɨn táàtajraꞌan, ayén tiuꞌutaniú tɨjɨ́n: ―Tɨ́j naꞌa tɨ páꞌarɨꞌɨstacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ajta aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa, jeíhua pu hui án yáꞌujɨ́puaa taij tzajtaꞌa, ajta á jaataꞌa tɨ́ꞌij raajéꞌica. Tɨ́ puaꞌa peraayɨ́ꞌɨtɨhuaꞌan pej tiráahuaateꞌen, táꞌancuꞌuvajxɨꞌɨ, pajta taatévaɨreꞌen. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna táàtajraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Naíjmiꞌi pu tíꞌirɨꞌɨri jemin ɨ́ tɨ téꞌatzaahuateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aj pu i aꞌɨ́ɨn táàtajraꞌan ɨ́ paꞌarɨꞌɨ ayén tiꞌihuaújyeinecaꞌa tɨjɨ́n: ―Netéꞌatzaahuateꞌe inee. Naatévaɨreꞌe neatáꞌaj jaítzeꞌe téꞌantzaahuateꞌen. ―Yee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Aj mú mi ajteáxɨɨrecaꞌa jeíhua ɨ́ teɨte meruaachijméꞌe. Tɨ́ꞌɨj aꞌɨ́ɨn Jesús huaꞌuseíj, aj puꞌi raꞌajtéꞌaxɨ ɨ́ tiyaaruꞌu tɨ paꞌarɨꞌɨ tzajtaꞌa seijreꞌecaꞌa. Ayen tɨjɨ́n: ―Múꞌee tiyaaruꞌu, pej caí huiteájnamua, pej caí atániuuve, ayée nu tíꞌimuaꞌaijteꞌe, pej raatátuaani mɨ paꞌarɨꞌɨ. Pecaj chéꞌe tzajtaꞌan uteáruꞌipicheꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Aj pu i huajíjhuacaꞌa aꞌɨ́jna ɨ́ tiyaaruꞌu. Temuaꞌa pu tiraatécaꞌatzɨjxɨ aꞌɨ́jna ɨ́ paꞌarɨꞌɨ caꞌanín jɨmeꞌe. Aj puꞌi huirájraa ɨ́ tzajtaꞌan. Ajta aꞌɨ́ɨn ɨ́ paꞌarɨꞌɨ, áa puꞌu aucaꞌitɨ́ jáꞌaraa. Xɨee tɨ cuj huamɨ́ꞌɨ. Aꞌɨ́j mú jɨ́n miyen tíꞌimuaꞌatzejcaꞌa ɨ́ teɨte tɨ nuꞌu huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mɨ́ ajtáꞌi caí capu. Jesús pu raꞌajvíꞌi muájcaꞌareꞌaraꞌan jetze. Aj puꞌi raꞌajjáj. Tɨ́ꞌɨj jí huatéechaxɨ aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. Aj mú mi aꞌucɨ́jxɨ naíjmiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tɨ́ꞌɨj jí Jesús chiꞌita uteájrupi, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi avíitzi jɨ́n tiraꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Jesús, miyen tɨjɨ́n: ―¿Aꞌiné een jɨ́n tecaí raayɨ́ꞌɨtɨhuaꞌa taꞌaraa tej tiyen tiraatamuáriteꞌen aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ tzajtaꞌan seijreꞌecaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Seꞌej raatamuáriteꞌen seꞌɨ́jna tiyaaruꞌujraꞌa, ayée pu tiúꞌujxeꞌeveꞌe sej raatéjhuauni ɨ́ Dios jemi, seajta rúꞌitziꞌiveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Matɨ́ꞌɨj mi aꞌucɨ́j. Aꞌuu mú aꞌaráꞌa aꞌájna jáꞌahuaꞌa u Galilea. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu tihuáꞌamuaꞌatehuaꞌa avíitzi jɨmeꞌe ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu aꞌɨ́jna jɨ́n huarɨ́j aꞌiné capu raxɨ́ꞌeveꞌecaꞌa mej ráamuaꞌaree ɨ́ teɨte aꞌu tɨ aꞌij jeeꞌin. Ayee pu tihuáꞌaꞌixaateꞌecaꞌa tɨ nuꞌu jaꞌatɨ́ jɨ́meꞌen tiuꞌutátuiireꞌesin aꞌɨ́jna tɨ ajta teáataꞌa jetze airáane aꞌɨ́ɨme jemi ɨ́ teteca. Aj mú nuꞌu mi raajéꞌicatan. Aru huaíca xɨca jetze pu huatarújsin, ruuri pu nuꞌu ajtahuaꞌa aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌen, camu yaúꞌitɨée muáꞌaraa aꞌij tɨ tihuáꞌaꞌixaateꞌecaꞌa. Majta tíꞌitziɨɨneꞌecaꞌa. Camu áꞌujcaꞌanejcaꞌa mej raatáhuavii tɨ huaꞌutáꞌixaateꞌen temuaꞌa naa eꞌehuauritɨéecan jɨmeꞌe. Matɨ́ꞌɨj mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aꞌuu mú aꞌaráꞌa jáꞌahuaꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Capernaúm. Matɨ́ꞌɨj mi chiꞌita aꞌuteájrupi. Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni aꞌij setiúꞌurihuaꞌuracaꞌa aꞌájna juye jetze? ");
INSERT INTO crnNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Camu huataniú, aꞌiné metíꞌiteviꞌiraꞌacaꞌa aꞌɨ́jna jɨmeꞌe mej tiúꞌurihuaꞌuracaꞌa meꞌɨ́jna jɨmeꞌe tɨjɨ́n aꞌatani jaítzeꞌe ruxeꞌeveꞌe aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aj pu i aꞌujyeíjxɨ aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí huaꞌutajé ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ ayén tiraꞌaráanajche tɨ aꞌɨ́ɨn puꞌéeneꞌen tɨ jaítzeꞌe veꞌecán jɨ́n tiꞌitéveecaꞌa, aꞌɨ́ɨ pu ruxeꞌeveꞌe tɨ aꞌɨ́ɨn puꞌéeneꞌen tɨ jaítzeꞌe cɨ́lieeneꞌecan jɨ́n tiꞌitéveecaꞌa. Ruxeꞌeveꞌe tɨ huaꞌutévaɨreꞌen naíjmiꞌica ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aj pu i paꞌarɨꞌɨ aj auvíꞌitɨ. A jáꞌitaꞌa yaꞌutára aꞌu mej eꞌeréꞌetei ɨ́ seica. Aj pu i raꞌavéꞌevii ɨ́ muꞌúutzeꞌen. Tɨ́ꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ayee pu tíꞌeen, jaꞌatɨ́ tɨ naꞌa tɨ paꞌarɨꞌɨ jamuan huayeíjxɨꞌɨn, ajta ráachaꞌɨɨn neetzi jetze meꞌecan seɨj ɨ́ paꞌarɨꞌɨ tɨ́j aꞌíjna, aꞌɨ́jna téviraꞌa ajta pu nechaꞌɨj ineetzi. Ajta aꞌíin ɨ́ téviraꞌa, capu ineetzi naꞌa ancuréꞌeviꞌitɨ sino ajta pu raꞌancuréꞌeviꞌitɨ ɨ́ Dios, ɨ́ tɨ nejaꞌutaꞌítecaꞌa nej yé tanén. ");
INSERT INTO crnNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ajta aꞌɨ́jna ɨ́ Juan, aꞌɨ́ɨ pu ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Maeestru, seɨj tu huaseíj tɨ huáꞌamuariteꞌecaꞌa aniúucajtzeꞌen jɨmeꞌe ɨ́ tiyaaruꞌu ɨ́ mej huáꞌa tzajtaꞌa seijreꞌecaꞌa ɨ́ teɨte. Aꞌiné capu áꞌucheꞌecaneꞌe ta jamuan, aꞌɨ́j tu jɨ́n raatáꞌijmɨijriꞌi tɨ caí ayén rɨjca. ―Yee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Aj pu i aꞌɨ́ɨn Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu siyen tíꞌiraꞌijmɨijra. Tɨ́ puaꞌa jaꞌatɨ́ ayén rɨjca ɨ́ mej jɨ́n aꞌij tiraꞌutaseíjra, aꞌɨ́jna ɨ́ jaꞌatɨ pu xaa áꞌucheꞌecaneꞌe aꞌame ne jamuan. Ajta aꞌɨ́ɨn, capu jaꞌanáj aꞌij puaꞌa tiꞌinexáata aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tɨ́ puaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ caí ta jemi niuu, aꞌɨ́ɨ pu xaa tavaɨreꞌe itejmi. ");
INSERT INTO crnNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ayee nu xaa neꞌu tejáꞌamuaꞌixaateꞌe, jaꞌatɨ́ tɨ naꞌa, tɨ puaꞌa aꞌɨ́ɨn cɨ́j caj tejamuaatáꞌan ɨ́ jaj sej huayéꞌen aꞌɨ́jna jɨmeꞌe sej ne jamuan áꞌujujhuaꞌan, Dios pu xaa tiraatanájchiteꞌesin aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ajta ayén tɨjɨ́n: ―Naꞌari puaꞌa jaꞌatɨ́ tɨ naꞌa, tɨ puaꞌa aꞌɨ́ɨn ɨ́ jaꞌatɨ aꞌij puaꞌa tiruꞌutérɨiira ɨ́ paꞌarɨꞌɨ tɨ cɨ́lieen, tɨ ajta náꞌatzaahuateꞌe ineetzi tɨ́j aꞌíjna, jéꞌecan pu puaíjtzi tíchesin aꞌɨ́jna ɨ́ jaꞌatɨ japua. Capu ayén tirajpuaíjtzi áꞌameꞌencheꞌe aꞌɨ́jna ɨ́ jaꞌatɨ tɨ puaꞌa amuacaí mú raꞌacáviꞌireꞌen ɨ́ tetej seꞌuníjraꞌa tɨ veꞌée, majta áꞌiyen raꞌateájrɨeeni á jaataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","’Matɨ́ꞌɨj auteáturan ɨ́ Dios jemi, seica mú miyen ru jetze teꞌujpuáꞌajteꞌe. Ayee nu tíꞌimuaꞌixaateꞌe, tɨ puaꞌa piyen jetzen tiruꞌujpuáꞌajteꞌen ɨ́ amuájcaꞌa peꞌɨ́jna jɨmeꞌe ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi, ayée pej huárɨni. Paraꞌantiveíjche ɨ́ amuájcaꞌa, pej pi seɨj panaꞌa jɨ́n aꞌuteáturan ɨ́ amuájcaꞌa aꞌájna tɨ éꞌeseijreꞌe ɨ́ Dios, aꞌájna pej eꞌerúuri puaꞌamé jemin. Naꞌari pecáj piyen huárɨni, huaꞌapuaca pej jɨ́n aꞌuteáruti ɨ́ áꞌamuajcaꞌa aꞌájna jáꞌahuaꞌa aꞌu pej antipuáꞌari, aꞌu tɨ caí éꞌerɨꞌɨri tɨ raꞌujéꞌica ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Aꞌuu mej caí éꞌecuiꞌini ɨ́ chuꞌinute ɨ́ mej muaatécɨꞌɨmee muáꞌajuꞌun. Capu ajta jaꞌanáj áꞌamɨꞌɨni ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","’Naꞌari tɨ puaꞌa piyen muaꞌa jetze tiruꞌujpuáꞌajteꞌen peꞌɨ́jna jɨmeꞌe ɨ́ muáꞌɨɨca ɨ́ pej auteájturaa ɨ́ Dios jemi, aꞌɨ́ɨ pu ajta muaatévaꞌɨre pej raꞌataveíjche pemɨ́jna muáꞌɨɨca. Jéꞌecan pu muaatévaꞌɨre pej múꞌee aꞌuteáturan seɨj jɨmeꞌe ɨ́ aꞌɨ́ɨca aꞌájna tɨ éꞌeseijreꞌe ɨ́ Dios. Naꞌari tɨ puaꞌa pecáj piyen huárɨni, amée pepuꞌu aꞌumé aꞌu tɨ Dios áa muajáꞌujɨsin aꞌu tɨ áꞌataa. Capu timuaatévaꞌɨre pej huaꞌapuaca jɨ́n áꞌumeꞌen aꞌujna aꞌu tɨ caí jaꞌanáj éꞌerɨꞌɨri pej raꞌujéꞌica ɨ́ taij, aꞌájna aꞌu mej caí jaꞌanáj éꞌecuiꞌini ɨ́ chuꞌinute ɨ́ mej muaatécɨꞌɨmee. Capu ajta jaꞌanáj áꞌamɨꞌɨni ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","’Naꞌari tɨ puaꞌa múꞌee á jetze paruꞌujpuáꞌajteꞌen muaꞌa jɨ́ꞌɨ peꞌɨ́jna jɨmeꞌe ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi, aitátɨchi. Jéꞌecan pu timuaatévaꞌɨre pej pi piyen aꞌuteárute seɨj jɨmeꞌe muaꞌa jɨ́ꞌɨ aꞌájna chajtaꞌa aꞌu tɨ teꞌáijta ɨ́ Dios. Mɨ́ ajta, capu tiꞌitɨ́ aꞌij timuaatévaꞌɨre pej huaꞌapuaca ájɨꞌɨsijméꞌe peꞌuun aꞌuteárute tɨ puaꞌa piyen éeneꞌen aꞌɨ́ɨ pu muajáꞌujɨsin aꞌujna tɨ áꞌataa, aꞌu mej caí jaꞌanáj éꞌecuiꞌini ɨ́ chuꞌinute mej muaatécɨꞌɨmee, ajta capu jaꞌanáj áꞌamɨꞌɨni ɨ́ taij. ");
INSERT INTO crnNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ayee nu tejáꞌamuaꞌixaateꞌe. Naímiꞌi xu rajpuaíjtzi xáꞌajuꞌun, múꞌeen, mɨ sej ne jamuan áꞌujujhuaꞌan sej si siyen titeeteáturan temuaꞌa naa ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ayee pu tíꞌivaɨreꞌe aꞌɨ́jna ɨ́ unaj tɨ tiꞌitɨ́ tícacaren. Mɨ́ ajta, tɨ puaꞌa huateáruꞌuna aꞌɨ́jna ɨ́ unaj tɨ́ꞌɨj rajxɨ́ꞌɨni ɨ́ taꞌancacá, aꞌiné auj tíꞌirɨꞌɨri tɨ́ꞌij ajtahuaꞌa ancacáa áꞌaraꞌani. Capu chéꞌe aꞌij tíꞌirɨꞌɨri. Aꞌíjna i niuucari i nej jáꞌamuaꞌixaateꞌe, ayée pu cheꞌatá tíꞌivaɨreꞌe múꞌejmi tzajtaꞌa tɨ́j ɨ́ unaj. Chéꞌe aꞌíin amuájcacaren aꞌamua tzajtaꞌa tɨ ij rɨ́ꞌɨ amuáaruuren. Rɨ́ꞌɨ xuꞌu titéꞌujmuajte ɨ́ ru tzajtaꞌa. Rɨ́ꞌɨ xuꞌu seajta eꞌehuaújmuaꞌaraa rujɨ́ɨmuaꞌa senaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús pu huirájraa aꞌujna u Capernaúm. Tɨ́ꞌɨj jí aꞌuun aꞌaráꞌa aꞌájna jáꞌahuaꞌa Jerusalén. Ayuu pu pújmeꞌen áꞌucheꞌecaneꞌe aꞌu tɨ ɨ́ játeꞌana ayée huataújmuaꞌa tɨjɨ́n ɨ́ Jordán. Majtahuaꞌa mú tiújseɨj ɨ́ teɨte aꞌu tɨ aꞌutéveecaꞌa ɨ́ Jesús. Ajta aꞌɨ́ɨ pu áꞌiyen aꞌutéjche tɨ tihuáꞌumuaꞌaten aꞌij tɨ ari tíꞌijrɨꞌɨrejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Aj mú mi seica eꞌiréꞌene. Fariseo mú pɨ́rɨcɨ aꞌɨ́ɨme. Aꞌɨ́ɨ mú tíꞌiteseꞌecaꞌa mej miyen caꞌaníjraꞌa tiraatáꞌan tɨ ij autéꞌɨtzen aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j mú jɨ́n miyen tiraataꞌíhuaꞌuriꞌi tɨ puaꞌa nuꞌu aꞌɨ́ɨn ayén tiꞌitáꞌaca tɨ jaꞌatɨ mé rúurɨeni ɨ́ ruꞌɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Tiꞌitáani amuaataꞌaíj aꞌɨ́jna ɨ́ Moisés teecan? ");
INSERT INTO crnNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Aꞌɨ́ pu hui Moisés tiuꞌutáꞌa tɨ cuapée raatapíjteꞌen ɨ́ tɨ jɨ́n jaꞌatɨ́ mé rúurɨeni ɨ́ ruꞌɨ́j. ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tɨ́ꞌɨj jí Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌij xu puaꞌa tirájteu ɨ́ ru tzajtaꞌa. Moisés pu tiuꞌutáꞌa tɨ jaꞌatɨ mé rúurɨeni ɨ́ ruꞌɨ́j. Aꞌɨ́ pu xaa ayén cuapée tiraatapíjteꞌen aru capu ayén tiraatáꞌa ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. Aꞌii puꞌu een jɨ́n ayén huarɨ́j aꞌɨ́jna aꞌiné ayée xu tíꞌijxeꞌeveꞌecaꞌa senaꞌa rujɨ́ɨmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","’Mɨ́ ajta, tɨ́ꞌɨj Dios raatétaahuacaꞌa ɨ́ chaanaca te japuan yen seijreꞌe, “aꞌɨ́ɨ pu nuꞌu aꞌɨ́ɨme huátaahuacaꞌa ɨ́ teáataꞌa jamuan ɨ́ ꞌɨ́itaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Aꞌɨ́j pu jɨ́n aꞌɨ́ɨn teáataꞌa mé huauuhuáꞌaxɨjsin ɨ́ ruvaújsimuaꞌa. Ruꞌɨ́j pu nuꞌu jamuan aꞌutevée aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Matɨ́ꞌɨj mi miyen éeneꞌe muáꞌajuꞌun ɨ́ mej huaꞌapua, cumu seɨ́j puꞌu ɨ́ tevi.” Camu chéꞌe huaꞌapua, sino seɨ́j puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","’Ayee nu tejáꞌamuaꞌixaateꞌe. Dios pu ayén tiraataxájtacaꞌa tɨ seɨ́j naꞌa ɨ́ tevi. Aꞌɨ́j pu jɨ́n, capu ayén tiraavíjteꞌe sej siyen mé tihuaúuhuaꞌanan ɨ́ ruꞌɨ́jtaꞌamuaꞌa, cuapée sehuaꞌutapíiteꞌen ɨ́ rucɨ́naꞌastemuaꞌa. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí áꞌuraa, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Matɨ́ꞌɨjtáhuaꞌa mi chiꞌita aꞌaꞌuteájrupi, majtáhuaꞌa mú miyen tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna jɨmeꞌe ɨ́ cuapée tɨ jɨ́n jaꞌatɨ́ ruꞌɨ́j mé úurɨeeni. ");
INSERT INTO crnNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ́ ruꞌɨ́j mé úurɨeeni, aꞌɨ́ɨ pu tíꞌijxanaꞌacɨraꞌa tɨ puaꞌa áꞌiyen seɨj teꞌencuréꞌeviꞌitɨ ɨ́ ꞌɨ́itaꞌa. Aꞌɨ́j pu jɨ́n auteáturaasin jemin ɨ́ ruꞌɨ́j ɨ́ tɨ mé rúujɨsin. ");
INSERT INTO crnNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Naꞌari tɨ puaꞌa ꞌɨ́itaꞌa rucɨ́n mé úurɨeeni, aꞌɨ́ɨ pu ajta tíꞌijxanaꞌacɨraꞌa tɨ puaꞌa ajta áꞌiyen seɨj antéenaxca ɨ́ teáataꞌa. Aꞌɨ́ pu ajta auteáturaasin jemin ɨ́ rucɨ́n ɨ́ tɨ mé rúujɨsin. ");
INSERT INTO crnNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Matɨ́ꞌɨj mi tɨꞌɨríi ayauvíꞌitɨ́che ɨ́ Jesús tɨ́ꞌij huaꞌajtamuárɨꞌen. Aj mú mi meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú huaꞌutáꞌijmɨijriꞌi ɨ́ tɨꞌɨríi mej nuꞌu caí huajaꞌuvéꞌeviꞌitɨ́jcareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tɨ́ꞌɨj Jesús huaꞌuseíj aꞌij mej yeꞌí rɨjcaa, aꞌɨ́ɨ pu huataniúꞌucacaꞌa. Tɨ́ꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Micheꞌe yéj huaveꞌeréꞌeneijteꞌen mɨ tɨꞌɨríi ineetzi jemi. Matɨ́j menaꞌa puaꞌamé ɨ́ mej áꞌujcaꞌane tɨ Dios tíhuaꞌutaꞌaíjteꞌen, naíjmiꞌi mú miyen eꞌen matɨ́j i tɨꞌɨríi. Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe. Caxu huáꞌijmɨijra. ");
INSERT INTO crnNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ayej xaa neꞌu tiꞌayajna. Naa pu huaꞌase mɨ tɨꞌɨríi tɨ tíhuaꞌutaꞌaíjteꞌen ɨ́ Dios. Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ aꞌuteárute aꞌujna aꞌu tɨ Dios teꞌáijta, ayée pu tiúꞌujxeꞌeveꞌe tɨ ayén cheꞌatá naꞌa tíꞌiraxeꞌeveꞌe tɨ tiraataꞌaíjteꞌen ɨ́ Dios tɨ́j seɨj paꞌarɨꞌɨ, mɨ tɨ yee seijreꞌe. Naꞌari caí, capu jaꞌanáj aꞌuteáruti aꞌujna aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aj pu i aꞌɨ́ɨn Jesús huaꞌancuréꞌeviꞌitɨ ɨ́ tɨꞌɨríi. Seexuꞌijméꞌen pu ancaújtɨsteajxɨ ɨ́ ru jetze. Ajta huaꞌavéꞌemuarɨꞌexɨ, aj puꞌi raatéjhuau ɨ́ Dios jemi tɨ́ꞌij aꞌɨ́ɨn huáꞌuchaꞌɨɨn. Tɨ́ꞌɨj jí áꞌuraa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tɨ́ꞌɨj Jesús ari huiiraméꞌeca, seɨ́j pu aveꞌeréꞌene, temuaꞌa tɨꞌéechijraꞌa. Aj pu i títunutacaꞌa vejliꞌipuan ɨ́ Jesús. Tɨ́ꞌɨj jí ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maeestru, nee nu ramuaꞌaree pej rɨ́ꞌɨ tíꞌitevij. ¿Tiꞌitájni aꞌij tiúꞌujxeꞌeveꞌe tɨ ayén tináacɨꞌɨti nej ruuri náꞌaraꞌani ɨ́ Dios jemi tɨ́j naꞌa rusén jɨmeꞌe matɨ́ꞌɨj aꞌitácɨɨne á chuaataꞌa ɨ́ mej meri huácuii? ");
INSERT INTO crnNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―¿Aꞌiné een jɨ́n piyen tíꞌinexa yee nej rɨ́ꞌɨ tíꞌitevij? Seɨ́j puꞌu seijreꞌe tɨ rɨ́ꞌɨ tíꞌitevij. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Múꞌee pej peri rúꞌumuaꞌaree aꞌij tɨ tiuꞌutaꞌaíjtacaꞌa ɨ́ Dios. Ayee pej éeneꞌen: “Pecaj tíꞌixanaꞌacɨreꞌe.” Ajtahuaꞌa seɨj, ayén tɨjɨ́n: “Pecaj tíꞌitecuiꞌica.” Ajtahuaꞌa aꞌíjna tɨ ayén tɨjɨ́n: “Pecaj tíꞌinahuaꞌaj.” Ajta seɨ́j tɨ ayén tɨjɨ́n: “Pecaj jaꞌatɨ́ huaꞌitzi jɨ́n tiꞌixáateꞌe.” Ajta ayén tɨjɨ́n: “Pecaj jaꞌatɨ́ tzeɨ́jrajmuaꞌa.” Ajta ayén tɨjɨ́n: “Peráꞌatzaahuateꞌen aꞌatáàta, pajta aꞌanáàna.” Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ raataꞌaíjtacaꞌa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Aj pu aꞌɨ́ɨn jaꞌatɨ́ ayén tiraataꞌixaa tɨjɨ́n: ―Maeestru, jɨ́meꞌen ɨ́ pej pauchén raataxájtacaꞌa, nain nu jɨ́n téꞌaste i niuucari netɨ́j nenaꞌa tiuꞌuvéꞌese. ");
INSERT INTO crnNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Tɨ́ꞌɨj raaseíj, rɨ́ꞌɨ pu teꞌutaújmuaꞌa ɨ́ ru tzajtaꞌa aꞌɨ́jna ɨ́ Jesús. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Tiꞌitɨ́ pu auj muáꞌaturaateꞌe pej caí xɨ jɨ́n teꞌaráꞌaste. Aricu. Nain tiuꞌutuáa ɨ́ pej tíꞌijchaꞌɨ́. Patáꞌaj huaꞌuréꞌeꞌaꞌateꞌen ɨ́ tumin ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. Tɨ́ puaꞌa piyen huárɨni, jeíhua pej raꞌancuréꞌasin aꞌujna jáꞌahuaꞌa u ta japua. Chíjteaani pej puꞌéeneꞌe puaꞌamé aꞌujna tɨ éꞌeseijreꞌe ɨ́ Dios. Ajta patáꞌaj mú aꞌarájraꞌani pej pi neetzi jamuan áꞌucheꞌecaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tɨ́ꞌɨj ráanamuajriꞌi aꞌɨ́jna ɨ́ niuucari, tɨ́ꞌɨj i utéevatzɨ́ ɨ́ tzajtaꞌan. Huataújxɨeemɨste aꞌiné jeíhua pu tíꞌijchaꞌɨɨcaꞌa. Tɨ́ꞌɨj jí áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Aj pu i Jesús ruhuáritaꞌa aꞌanéereajraa. Ajta ayén tihuaꞌutáꞌixaa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Temuaꞌa pu tihuaꞌamuárɨꞌeristeꞌe mej aꞌuteárute aꞌujna tɨ éꞌeseijreꞌe ɨ́ Dios ɨ́ chíjteaani. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Aj pu i utéevatzɨ́ ɨ́ huáꞌa tzajtaꞌa aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe aꞌɨ́jna jɨmeꞌe aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Ajtahuaꞌa ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Niyaujmuaꞌa, temuaꞌa pu tihuaꞌamuárɨꞌeristeꞌe ɨ́ mej jeíhua tíꞌijchaꞌɨɨ. Jeíhua pu huáꞌa jetze ruxeꞌeveꞌe ɨ́ mej caj tíꞌijchaꞌɨɨ. Aꞌɨ́j pu jɨ́n muárɨꞌeri mej meꞌaun aꞌuteárute aꞌujna tɨ éꞌeseijreꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Capu xaa neꞌu ayén tíꞌimuarɨꞌeri tɨ amuájraꞌani cameeyuꞌu tiꞌitɨ́ pɨ́ꞌɨseꞌe jetze, tɨ́j tɨ puaꞌa chíjteaani tiuꞌutéseꞌen tɨ ruseɨ́j aꞌuteárute aꞌájna tɨ éꞌeseijreꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Matɨ́ꞌɨj ráanamuajriꞌi, jéꞌecan mú aꞌij tiraꞌutánamuajriꞌi. Aj mú mi tiꞌitiúrihuaꞌuriꞌi rujɨ́ɨmuaꞌa. Miyen tɨjɨ́n: ―Tɨ́ puaꞌa ayén tiꞌayajna, ¿aꞌii táꞌuj naꞌa tíꞌirɨꞌɨri tɨ jaꞌatɨ aꞌuun aꞌuteáturan ɨ́ Dios jemi? ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ajtahuaꞌa Jesús huaꞌuseíj. Ayen tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨme jemi ɨ́ teteca, capu xaa aꞌij tíꞌirɨꞌɨri. Mɨ́ ajta, aꞌɨ́ɨ pu raayɨ́ꞌɨtɨ ɨ́ Dios. Nain jɨmeꞌe pu jemin tíꞌirɨꞌɨri. ");
INSERT INTO crnNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Aj pu i aꞌɨ́ɨn Pedro aꞌutéjche tɨ raatáꞌixaateꞌen. Ayen tɨjɨ́n: ―¡Tavástaraꞌa, meꞌecui xaa!, nain tu teri tejáꞌurɨe ɨ́ tej tíꞌijchaꞌɨɨcaꞌa tej ti áꞌujujhuaꞌaneꞌen áꞌa jamuan. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro. ");
INSERT INTO crnNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Ayee nu tejáꞌamuaꞌixaateꞌe, tɨ puaꞌa jaꞌatɨ́ tiꞌitɨ́j jáꞌurɨeeni ineetzi jemi, naꞌari jemin ɨ́ niuucari tɨ jɨ́n huaujjéjcuareꞌen ɨ́ Dios jemi, tiꞌitɨ́ tɨ naꞌa tɨ yáꞌurɨeeni, aꞌɨ́ɨ pu cheꞌatá naꞌa ancuréꞌasin tɨ́ꞌɨj auj ruuri íiyen chaanaca japua. Tɨ́ puaꞌa seɨ́j naꞌa ɨ́ tɨ yáꞌurɨe, ayée pu cheꞌatá naꞌa raꞌancuréꞌasin aꞌachú cumu anxɨ́te tiꞌitɨ́ tɨ aꞌij, tɨ puaꞌa chiꞌij, naꞌari rujaꞌatzimuá naꞌari rucuꞌutzimuá naꞌari rujúutzimuaꞌa. Ajta ayén huaꞌancuréꞌeviꞌitɨ ɨ́ ruteɨ́testemuaꞌa, aꞌɨ́ɨme rutáàta naꞌari runáàna nusu ruꞌɨ́j, naꞌari ruyaujmuaꞌa. Ajta pu raꞌancuréꞌasin ɨ́ chuej mej japuan vaujse ɨ́ teɨte. Nain pu teꞌancuréꞌasin. Ajta rajpuaíjtzi aꞌame. Aru capu amɨ́n aꞌij. Tɨ́ꞌɨj aꞌɨ́ɨn aꞌuteárute aꞌujna Dios tɨ éꞌeseijreꞌe, Dios pu raatáꞌasin tɨ ruuri áꞌaraꞌani jemin tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ajta ayén tɨ jɨ́meꞌen yee: ―Memuꞌií ɨ́ mej vivejméꞌen jɨ́n títetateí íjii, aꞌɨ́ɨ mú cɨ́lieeneꞌen jɨ́n títetatéꞌe muáꞌajuꞌun. Majta muꞌiitɨ́ ɨ́ mej cɨ́lieeneꞌen jɨ́n títetateí íjii, aꞌɨ́ɨ mú vivejméꞌen jɨ́n títetatéꞌe muáꞌajuꞌun. Ayej xaa neꞌu téꞌeme. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tɨ́ꞌɨj jí áꞌuraa ɨ́ Jesús, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. An mú aꞌucɨ́ jáꞌahuaꞌa Jerusalén. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu amuacaí huaméꞌecaa. Jeíhua mú rutemuaꞌaveꞌeca ɨ́ seica. Majta tíꞌitziɨɨneꞌecaꞌa ɨ́ mej huáꞌa cujtaꞌa huajúꞌucaa. Tɨ́ꞌɨj jí ajtahuaꞌa Jesús huaꞌutajé rujɨ́ɨmuaꞌa. Aj pu i aꞌutéjche tɨ tihuaꞌutáꞌixaateꞌen aꞌij tɨ tiꞌitɨ́j raruuren. ");
INSERT INTO crnNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Casiꞌi, xáanamuajriꞌi múꞌeen. Tuꞌuri áꞌujuꞌun aꞌánna Jerusalén. Seɨ́j pu tiuꞌutátuiireꞌesin ɨ́ nejɨ́meꞌe, i nej neajta teáataꞌa jetze airáane aꞌɨ́mej jemi ɨ́ mej tíhuaꞌuꞌaíjteꞌe teyujtaꞌa, ajta aꞌɨ́mej jemi ɨ́ mej téꞌeyuꞌuxaca. Aꞌɨ́ mú tiuꞌutáꞌasin mej neejéꞌica. Aj mú mi meꞌɨ́n tiuꞌutátuiireꞌesin aꞌɨ́mej jemi ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Matɨ́ꞌɨj mi naꞌaxɨeehuástiꞌira muáꞌajuꞌun, majta naatévajxɨꞌɨsin. Majta naatetzíꞌijmuaꞌaxɨꞌɨsin ɨ́ ne jetze. Majta neejéꞌicatan. Netɨ́ꞌɨj hui huámɨꞌɨni, huaíca xɨcaj tzajtaꞌa nu neajtahuaꞌa á aꞌitaméj huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ");
INSERT INTO crnNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aj mú mi ajteáxɨɨrecaꞌa Jesús jemi aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan. Aꞌii mú meꞌɨ́n púꞌeen yaújmuaꞌameꞌen aꞌɨ́jna ɨ́ Zebedeo. Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Maeestru, ayée tu tíꞌijxeꞌeveꞌe pej piyen huárɨni aꞌij tej yeꞌí timuaatáhuaviira. ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe nej niyen huárɨni múꞌejmi jɨmeꞌe? ―Yee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Ahuii, ayée tu tíꞌijxeꞌeveꞌe aꞌɨ́jna xɨcájraꞌa jetze patɨ́ꞌɨj yatanéjsin pej titaataꞌaíjteꞌen íiyen chaanaca japua. Patáꞌaj taatáꞌan tej uhuaráꞌasixɨꞌɨn seɨ́j aꞌarɨꞌɨríntaꞌa, ajta seɨ́j áꞌutataꞌa. ―Yee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen, caxu ramuaꞌaree aꞌij sei tiꞌitɨ́j éeneꞌe huauhuau. ¿Ni siyen ráꞌaviicuaꞌi sej rajpuaíjtzi xáꞌaraꞌani netɨ́j inee tirajpuaíjtzi naꞌame? ¿Naꞌari secaí ráꞌaviicuaꞌi ɨ́ teɨte mej aꞌij puaꞌa amuáaruuren múꞌejmi matɨ́j majta aꞌij puaꞌa tíꞌineruure ineetzi? ―Yee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ ɨ́ Jesus. ");
INSERT INTO crnNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aj mú mi miyen tɨjɨ́n: ―Nétiꞌijtá neꞌu, ayée tu tiráꞌaviicuaꞌiran. Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Múꞌeen xu rajpuaíjtzi xáꞌajuꞌun netɨ́j tirajpuaíjtzi naꞌame inee. Ajta, múꞌejmi, aítzeꞌe mú aꞌij puaꞌa amuáaruuren matɨ́j aꞌij puaꞌa tíꞌineruuren ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mɨ́ ajta, canu neꞌɨ́jna jɨ́n antínmuaꞌaree nej amuaatáꞌan sej uhuaráꞌasixɨꞌɨn seɨ́j nejrɨꞌɨríntaꞌa, ajta seɨ́j neꞌúutataꞌa. Aꞌɨ́mej puꞌu cɨꞌɨti ɨ́ mej ayén huaújxɨꞌepɨꞌɨntariꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Matɨ́ꞌɨj mi ráamuaꞌareeriꞌi ɨ́ seica ɨ́ mej tamuáamuataꞌa mej aráꞌase aꞌij mej yeꞌí tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan. Aj mú mi tiníniuꞌucacucaꞌa aꞌɨ́mej jemi ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Aj pu i Jesús huaꞌutajé naíjmiꞌica. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Xuꞌuri ramuaꞌaree, múꞌeen, aꞌij mej yeꞌí rɨcɨ ɨ́ mej tíꞌitaꞌaijteꞌe nain chuéjraꞌa japua. Caꞌanín mú jɨ́n tíhuaꞌuꞌaíjteꞌe ɨ́ teɨte. Aꞌɨ́ɨme ɨ́ mej vivéjme jɨ́n títetateí, aꞌɨ́ɨ mú huaꞌuꞌáijteꞌe aꞌij mej yeꞌí huárɨni ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","’Mɨ́ ajta, capu ayén téꞌeme múꞌejmi jemi. Tɨ́ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ veꞌecán jɨ́n tiꞌitevée áꞌaraꞌani, ayée pu tiúꞌujxeꞌeveꞌe tɨ aꞌɨ́ɨn cɨliéeneꞌe jɨ́n tiꞌitevée áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ajta tɨ puaꞌa jaꞌatɨ́ raxɨ́ꞌeveꞌe tɨ aꞌɨ́ɨn puꞌéeneꞌen ɨ́ tɨ jaítzeꞌe ruxeꞌeveꞌe, ayée pu tiúꞌujxeꞌeveꞌe tɨ aꞌɨ́ɨn huaꞌutévaɨreꞌen naíjmiꞌica ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","’Ayej cheꞌatá naꞌa tíꞌeen ineetzi jemi, inee i nej neajta teáataꞌa jetze airáane. Canu neꞌɨ́jna jɨ́n yé uvéꞌene mej mi naatévaɨreꞌen ineetzi, sino neatáꞌaj huaꞌutévaɨreꞌen muꞌiicáca ɨ́ teɨte. Ayee nu xaa een jɨ́n yé uvéꞌene nexɨ́ꞌeviꞌiraꞌa jɨmeꞌe neatáꞌaj huáꞌa japua huániuuni, neꞌaꞌɨjna jɨmeꞌe nej huámɨꞌɨni huáꞌa jetze meꞌecan. Netiraatanájchiteꞌen ɨ́ Dios ɨ́ tɨ jɨ́n aꞌɨ́ɨn huáꞌajijveꞌe ɨ́ mej jɨ́n áꞌapuaꞌaren ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌájna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Jericó. Matɨ́ꞌɨj mi huiráacɨ meꞌújna. Puꞌuri huiiraméꞌeca aꞌɨ́jna ɨ́ Jesús, majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, majta muꞌiitɨ́ ɨ́ teɨte. Aꞌuu pu seɨ́j jeꞌitécatii vejliꞌi juye jetze. Ayee pu ántehuaacaꞌa tɨjɨ́n Bartimeo. Yaujraꞌan pu púꞌeeneꞌen aꞌɨ́jna ɨ́ Timeo. Ajta arácuunicaꞌa aꞌɨ́jna ɨ́ Bartimeo. Aꞌɨ́j pu vaɨ́riꞌira huáꞌahuaviiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tɨ́ꞌɨj i huáꞌunamuajriꞌi mej á vejliꞌi eꞌevéꞌejuꞌucaꞌa. Jɨ́meꞌen puꞌu huáꞌunamuajriꞌi, tɨ́ꞌɨj jí aꞌɨ́ɨn taꞌarácun aꞌutéjche tɨ huajíjhua. Ayen tɨjɨ́n: ―Jesús, mɨ pej íꞌihuaacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ tajtuhuan teecan ɨ́ David, náꞌancuꞌuvajxɨꞌɨ ineetzi. ―Ayee pu tiraatajé. ");
INSERT INTO crnNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Majta meꞌɨ́n ɨ́ teɨte, temuaꞌa mú tiraꞌajteáꞌajxɨ. Meraatáꞌijmɨijriꞌi tɨ́ꞌij caí ayén tíꞌijijhua. Ajta aꞌɨ́ɨn, jaítzeꞌe pu caꞌanín jɨ́n huajíjhuacaꞌa, ayén tɨjɨ́n: ―Mɨ́ pej íꞌihuaacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan, náꞌancuꞌuvajxɨꞌɨ ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Aj pu i Jesús aꞌutéechaxɨ. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu, seꞌutáje. Aj mú mi yaꞌutajé. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Huatéꞌacaꞌane ɨ́ áꞌa tzajtaꞌa. Ájchesi. Aꞌɨ́ pu muachuꞌeveꞌe ɨ́ Jesús. ―Yee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aj pu i aꞌɨ́ɨn aireújchuiriꞌi ɨ́ rucɨɨxu caꞌanín jɨmeꞌe. Tɨ́ꞌɨj jí ájtzucu. Aj pu i eꞌiréꞌene ɨ́ Jesús jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aj pu i aꞌɨ́ɨn Jesús ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné petíꞌijxeꞌeveꞌe nej tiꞌitɨ́ aꞌij huáruuren múꞌeetzi jemi? Tɨ́ꞌɨj jí ayén tiraataꞌixaa aꞌɨ́jna ɨ́ tɨ arácun tɨjɨ́n: ―Maeestru, ayée nu tíꞌijxeꞌeveꞌe nej atáneere. ");
INSERT INTO crnNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Puꞌuri pejáꞌuraꞌani múꞌee. Petéꞌatzaahuateꞌe nej inee timuáahuaateꞌen. Aꞌɨ́j pej jɨ́n peri huarúj. Jɨ́meꞌen puꞌu ayén tiraataꞌixaa ɨ́ Jesús, aꞌɨ́jna ɨ́ tɨ arácun, aj pu i atáneerecaꞌa. Tɨ́ꞌɨj jí, aꞌɨ́ɨ pu ɨ́ Jesús jamuan áꞌucheꞌecaneꞌe jáꞌaraa, aꞌu tɨ naꞌa tɨ huáyeꞌicaa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Matɨ́ꞌɨj meri vejliꞌi meꞌánna autenéesimeꞌecaa u Jerusalén, aꞌúu mú aꞌatanéj aꞌu tɨ chájtaꞌajme tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betfagé, ajta Betania. Aꞌuu pu éꞌechajtaꞌa jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Tɨ́ꞌɨj jí Jesús huaꞌapuaca huataꞌáitecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ayen tɨjɨ́n: ―Sericu, setáꞌaj seꞌuun aꞌatanén aꞌájna vejliꞌi chajtaꞌa tɨ éꞌeseijreꞌe. Tɨ́ puaꞌa seri eꞌaráꞌasti, aꞌúu xu puuruꞌu éꞌeteuni tɨ caí xɨ jaꞌanáj jaꞌatɨ́ japuan avéꞌeca. Aꞌuu pu aꞌijtápiꞌihuá aꞌame. Setáꞌaj ráꞌijxɨjta, seajta mú yeꞌeráajan. ");
INSERT INTO crnNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tɨ́ puaꞌa jaꞌatɨ́ ayén tejámuaataꞌíhuaꞌu yee: “¿Aꞌiné een jɨ́n seráꞌijxɨjta mɨ puuruꞌu?”, ayée xu tiraataꞌixaateꞌen yee: “Aꞌɨ́ pu raꞌucupadu ɨ́ tavástaraꞌa”, seajta siyen tiraataꞌixaateꞌen yee: “Seajtahuaꞌa xu caꞌanacan seraatátuiireꞌesin ɨ́ tɨ racɨi.” ");
INSERT INTO crnNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Matɨ́ꞌɨj mi u áꞌujuꞌu. A mú puaꞌacɨé caaye jetze yáꞌuteu meꞌɨ́jna ɨ́ puuruꞌu. Aꞌuu pu aꞌijtápiꞌihuacaꞌa puéerta jetze. Matɨ́ꞌɨj mi raꞌijxɨ́jtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Seica mú meꞌuun aꞌutéꞌuucaꞌa aꞌujna. Aꞌɨ́ mú tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni aꞌij seruure? ¿Aꞌiné een jɨ́n seráꞌijxɨjta mɨ puuruꞌu? ");
INSERT INTO crnNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ayee mú tihuaꞌutáꞌixaa aꞌij tɨ yeꞌí Jesús tihuaꞌutáꞌixaa. Majta meꞌɨ́n ɨ́ seica, aꞌɨ́ɨ mú huaꞌutáꞌa mej raꞌanján. ");
INSERT INTO crnNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Matɨ́ꞌɨj mi yaꞌujáj ɨ́ Jesús jemi aꞌɨ́jna ɨ́ puuruꞌu. Metiraꞌitéꞌitajte rucɨɨxu jɨmeꞌe. Tɨ́ꞌɨj jí avéꞌeyeijxɨ ɨ́ Jesús ɨ́ puuruꞌu japua. ");
INSERT INTO crnNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Majta meꞌɨ́n ɨ́ teɨte, jeíhua mú cɨ́ɨxuri teꞌepíijraa juye jetze. Majta seica piꞌista teꞌentiveíchixɨꞌɨ, aꞌɨ́j mú majta aꞌupíijraa aꞌájna juye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Majta meꞌɨ́n mej amuaatéꞌee muaajúꞌucaa, aꞌɨ́ɨ mú autéjhuii mej huajíjhua, majta meꞌɨ́n ɨ́ mej huajúꞌucaa cujtaꞌan aꞌɨ́jna ɨ́ Jesús. Yee mú tíꞌijijhuacaꞌa tɨjɨ́n: ―Puꞌuri iꞌi xɨ́ꞌepɨꞌɨn. Chéꞌe Dios ráaveꞌesi aꞌíjna tɨ yevéꞌeme niuucajtzeꞌen ɨ́ tavástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Puꞌuri iꞌi xɨ́ꞌepɨꞌɨn. Chéꞌe Dios ráaveꞌesi temuaꞌa naa, aꞌíjna tɨ á yevéꞌeme tɨ́ꞌij tiuꞌutaꞌaíjta tɨ́j ajmíꞌi tiuꞌutaꞌaíjtacaꞌa ɨ́ tahuáacɨxaꞌa, aꞌɨ́jna ɨ́ David teecan. Ajta hui meꞌɨ́n ɨ́ mej tíꞌivaɨreꞌe u ta japua, michéꞌe miyen tiraataxáj yee temuaꞌa pu íꞌixɨꞌepɨꞌɨn. ―Yee mú mi tiuꞌutaxájtacaꞌa, aꞌujna caaye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tɨ́ꞌɨj i Jesús aꞌuteájrupi aꞌánna Jerusalén. Ajta áꞌiyen aꞌaꞌuteájrupi aꞌujna teyujtaꞌa. Tɨ́ꞌɨj tiuꞌuséij nainjapua, tɨ́ꞌɨjí áꞌuraa, majta ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Puꞌuri téchuijxarijmeꞌeca, matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌájna Betania. ");
INSERT INTO crnNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Yee ruijmuaꞌa yee majta u eꞌeráacɨ aꞌujna Betania. Puꞌuri íꞌicuatacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tɨ́ꞌɨj i aꞌɨ́ɨn huaréj piꞌista huaseíj tɨ aꞌɨmuá aꞌatáveecaꞌa. Jeíhua pu téxamuaꞌi. Tɨ́ꞌɨj jí u áꞌume tɨ́ꞌij raaseíj tɨ puaꞌa tacaꞌa. Mɨ́ ajtáꞌi caí, capu tacaꞌacaa. Aꞌɨ́ puꞌu, xamuaꞌiraꞌan seijreꞌecaꞌa aꞌiné capu aꞌájna pɨ́tíꞌirijcaa tɨ́j puaꞌa taaca. ");
INSERT INTO crnNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Aj pu i Jesús ayén tiraataꞌixaa aꞌɨ́jna ɨ́ huaréj, tɨjɨ́n: ―Capu chéꞌe jaꞌatɨ́ mú aꞌuvéꞌeméꞌe aꞌame tɨ ráacuaꞌani mɨ áꞌatacaꞌi. ―Yee pu tiraataꞌixaa. Majta meꞌɨ́n ɨ́ mej áꞌujujhuaꞌaneꞌe ɨ́ Jesús jamuan, aꞌɨ́j mú ráanajmuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa. Matɨ́ꞌɨjtá mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aꞌuun mú aꞌaráꞌa aꞌánna Jerusalén. Tɨ́ꞌɨjtaꞌi aꞌɨ́ɨn Jesús aꞌaꞌuteájrupi aꞌujna teyujtaꞌa. Ajta aꞌutéjche tɨ huaꞌirámuariteꞌen ɨ́ mej meꞌuun teꞌutuꞌaca, ajta ɨ́ mej meꞌuun titeꞌunanáave. Temuaꞌa pu teꞌijhuáꞌaxɨjxɨ ɨ́ tihuáꞌameesa ɨ́ mej tumin jetzen tihuáꞌapuataꞌatiꞌiraca, ajta aꞌu mej cucuiꞌise eꞌetuꞌaracareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ajta caí huaꞌutáꞌa tɨ jaꞌatɨ tiꞌitɨ́ aútɨsimeꞌen á jáꞌitaꞌa teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ajta áꞌiyen tihuáꞌamuaꞌateajraa, ayén tɨjɨ́n: ―¿Ni caí ayén téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ ayén tiraataxájtacaꞌa ɨ́ Dios tɨjɨ́n: “Ayee pu nuꞌu tejaꞌarajtehuaá aꞌame ɨ́ chiꞌiraꞌan tɨjɨ́n chiꞌij mej tzajtaꞌan rɨ́ꞌɨ tiratáꞌaca ɨ́ Dios ɨ́ mej curéꞌecɨꞌɨca nain japua ɨ́ chuej tɨ seijreꞌe”? Mɨ́ ajta, capu aꞌɨ́jna jɨ́n tíꞌivaɨreꞌe. Ayee xu ráaruu ɨ́ chiꞌij tɨ́j teástaꞌa aꞌu mej aꞌiráatei ɨ́ nahuaꞌari. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Majta meꞌɨ́n ɨ́ teɨte, naíjmiꞌi mú aꞌij tiraꞌutaseíj aꞌɨ́jna jɨmeꞌe aꞌij tɨ yeꞌí tihuáꞌamuaꞌate. Majta meꞌɨ́n ɨ́ mej teꞌáijta teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca, aꞌɨ́ɨ mú rátziɨɨneꞌecaꞌa matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ yeꞌí tihuaꞌumuáꞌate. Aj mú mi ráahuau aꞌij mej yeꞌí huárɨni mej mi raajéꞌica meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ajta aꞌɨ́ɨn ɨ́ Jesús, tɨ́ꞌɨj huatétɨcaꞌareꞌecaꞌa, aj puꞌi huirájraa aꞌujna chajtaꞌa, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Yee ruijmuaꞌateꞌe yee, tɨ́ꞌɨj huateapuáꞌarecaꞌa, aꞌúu mú aꞌuréꞌene aꞌutɨ́ aꞌatáveecaꞌa aꞌɨ́jna ɨ́ huaréj. Puꞌuri temuaꞌa tíꞌihuachicaꞌa nainjapua, ajta téteꞌɨmua ɨ́ runáanaꞌa jetze huateáhuaa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tɨ́ꞌɨj jí aꞌɨ́ɨn ɨ́ Pedro raꞌutámuaꞌareeriꞌi aꞌij tɨ een jɨ́n huateáhuaa. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Maeestru, casiꞌi. Puꞌuri temuaꞌa tiꞌihuáchi mɨ huaréj pej aꞌij puaꞌa tiraateájtuaa. ");
INSERT INTO crnNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu tiúꞌujxeꞌeveꞌe sej ráꞌatzaahuateꞌen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu xaa neꞌu tejáꞌamuaꞌixaateꞌe. Ayej tiꞌayajna tɨ puaꞌa jaꞌatɨ́ téꞌatzaahuateꞌe ɨ́ ru tzajtaꞌa tɨ ayén teꞌaráꞌasti aꞌij tɨ aꞌɨ́ɨn tiráꞌamitɨejteꞌe, ayée pu téꞌeme. Naꞌari, tɨ puaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ ayén tiraataꞌaíjteꞌen aꞌɨ́jna ɨ́ jɨrí tɨjɨ́n: “Tíchesi, ateáruti mé jaataꞌa aꞌájna jáꞌahuaꞌa el mar”, ayée puꞌi rɨni, rɨꞌɨrí. Naꞌari caí, tɨ puaꞌa utévatziɨn ɨ́ tzajtaꞌan aꞌíjna i muáꞌariiraꞌa tɨjɨ́n: “Ayej neꞌase capu aꞌij tíꞌirɨꞌɨri”, capu ayén téꞌeme tɨ ayén huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","’Aꞌɨ́j nu jɨ́n, niyen tejáꞌamuaꞌixaateꞌe. Aꞌij sej yeꞌí tiraatáhuaucu ɨ́ Dios jemi, tɨ puaꞌa siyen téꞌatzaahuateꞌe sej si raꞌancuréꞌasin, ayée pu téꞌeme, tiꞌitɨ́ sej aꞌij tiuꞌutáhuausin. ");
INSERT INTO crnNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ajta, patɨ́ꞌɨj raatéjhuauni ɨ́ Dios jemi, tɨ puaꞌa jaꞌatɨ́ auteáturan múꞌeetzi jemi, ayée pu tiúꞌujxeꞌeveꞌe pej tiraatáꞌuuniꞌi. Tɨ́ puaꞌa piyen huárɨni, aꞌɨ́ɨn ɨ́ ayáꞌupua tɨ aꞌuun éꞌeseijreꞌe u ta japua, aꞌɨ́ɨ pu timuaatáꞌuuniꞌira múꞌeetzi nain jɨmeꞌe ɨ́ pej jɨ́n auteájturaa ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Naꞌari tɨ puaꞌa pej caí tiraatáꞌuuniꞌi ɨ́ tɨ á jemin auteájturaa, capu ajta timuaatáꞌuuniꞌira ɨ́ Dios ɨ́ pej jɨ́n auteájturaa ɨ́ jemin. ―Yee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Matɨ́ꞌɨj mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aj mú mi majtáhuaꞌa u Jerusalén áꞌujuꞌun. Aj pu i Jesús aꞌuun vejliꞌi áꞌucheꞌecaneꞌecaꞌa teyujtaꞌa matɨ́ꞌɨj seica á eꞌiréꞌene. Aꞌɨ́ mú púꞌeen ɨ́ mej teꞌáijta teyujtaꞌa, majta ɨ́ mej téꞌeyuꞌuxaca, majta seica vaujsi. ");
INSERT INTO crnNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni jɨ́n petiꞌitéjvee pej pi piyen rɨcɨ? ¿Aꞌataani ayén tímuaataꞌaíj pej pi piyen rɨjca? ");
INSERT INTO crnNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Neajta nu inee seɨj tejámuaataꞌíhuaꞌura. Tɨ́ puaꞌa senaatáꞌixaateꞌen seꞌíjna, aj nu ni amuaatáꞌixaateꞌesin tiꞌitɨ́ ɨ́ nej jɨ́n tiꞌitéjvee nej ni niyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Aꞌataani raatáꞌa aꞌɨ́jna ɨ́ Juan tɨ́ꞌij huáꞌumuaɨꞌɨhua ɨ́ teɨte? ¿Ni Dios, caꞌɨ́n mɨ teteca? Xaatániuuchi. ");
INSERT INTO crnNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Matɨ́ꞌɨj mi aꞌuteájhui mej rujɨ́ɨmuaꞌa tiꞌihuaúrihuaꞌu. Miyen tɨjɨ́n: ―Tɨ́ puaꞌa tiyen tiraataꞌixaateꞌen yee: “Dios pu yaꞌutaꞌítecaꞌa”, ayée pu titaatáꞌixaateꞌesin yee: “¿Aꞌiné een jɨ́n tecaí ráꞌatzaahuateꞌe aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna?” ");
INSERT INTO crnNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mɨ́ ajta, capu hui rɨꞌɨrí tej tiyen tiraataꞌixaateꞌen yee: “Teteca mú yaꞌutaꞌítecaꞌa.” Yee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme, aꞌiné muꞌuri ramuaꞌareerecaꞌa mej naíjmiꞌi miyen ráꞌatzaahuateꞌecaꞌa tɨ aꞌɨ́ɨn ɨ́ Juan tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Aꞌɨ́j mú jɨ́n huáꞌatziɨɨneꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Aꞌɨ́j mú mi jɨ́n miyen tiraataꞌixaa meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Catu hui ramuaꞌaree. Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu neajta nee tejámuaatáꞌixaateꞌesin ɨ́ nej jɨ́n tiꞌitéjvee nej ni niyen rɨcɨ. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ajta áꞌiyen aꞌutéjche ɨ́ Jesús tɨ tihuaꞌutáꞌixaateꞌen seɨj jɨmeꞌe ɨ́ niuucari. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌatɨ́ tɨ yee ráahuii ɨ́ uuva cɨyeꞌe. Tejcuáa pu nuꞌu jɨ́n raaréꞌana. Aj pu i tiꞌitɨ́ huatétaahuacaꞌa tɨ jɨ́n raajáꞌaraꞌapeꞌen ɨ́ uuva. Ajta tiꞌitɨ́ ájtaahuacaꞌa ájteeviꞌi, ɨ́ mej japuan utiúu huaꞌíxɨꞌereꞌen ɨ́ mej tíꞌimɨjhuaca. ’Tɨ́ꞌɨj jí ayén huarɨ́j, seica pu huatániɨjte ɨ́ chuej mej mi tiraanájchiteꞌen cɨ́j caj. Aj pu i áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ seica chuéjraꞌa japua. ");
INSERT INTO crnNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Tɨ́ꞌɨj nuꞌu aꞌájna tejaꞌuréꞌene jaꞌanáj mej puaꞌa rajuꞌuraca aꞌɨ́jna ɨ́ uuva, seɨj pu huataꞌáitecaꞌa tɨ i huaꞌutáhuavii aꞌachú tɨ racɨ́ꞌɨcɨpua aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Majta meꞌɨ́n ɨ́ mej tíꞌimɨjhuaca, aꞌɨ́ɨ mú yeehui rajvíꞌi aꞌɨ́jna tɨ tiuꞌutaꞌaíjtiꞌire. Temuaꞌa mú tiraatéevajxɨ. Ayee muꞌu tiraataꞌítecaꞌa. Camu tiꞌitɨ́ raatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","’Ajta aꞌɨ́ɨn tɨ áꞌareꞌaraꞌan púꞌeen ɨ́ chuej, ajtahuaꞌa pu seɨj huataꞌáitecaꞌa. Majta mú meꞌɨ́n huateátuꞌasixɨ tetej jɨmeꞌe. Matɨ́ꞌɨj mi temuaꞌa tiraꞌaváꞌatuꞌa ɨ́ muꞌúuraꞌan jetze. Majta temuaꞌa aꞌij puaꞌa tiraꞌajteáꞌajxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ajtahuaꞌa nuꞌu seɨj huataꞌáitecaꞌa. Majta mú amɨ́n temuaꞌa tiuꞌujéꞌica. Aꞌatzu ayée teuuméꞌeca. Ajtahuaꞌa seica huataꞌáitecaꞌa. Seica mú huatéevajxɨ, majta seica huácuii. Ayee mú huáꞌuruu aꞌɨ́ɨme ɨ́ mej tíꞌimɨjhuaca. ");
INSERT INTO crnNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Aúcheꞌe pu yeehui seɨ́j turaacaꞌa. Yaujraꞌan nuꞌu aꞌɨ́jna ɨ́ jaꞌatɨ. Jeíhua pu huápɨꞌɨ raxɨ́ꞌeveꞌecaꞌa. Ayee pu tíꞌimuaꞌatzejcaꞌa ayén tɨjɨ́n: “Ayej neꞌase yeehui meráꞌantzaahuateꞌesin, meꞌɨ́jna.” Tɨ́ꞌɨj jí aꞌɨ́ɨn huataꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","’Mɨ́ ajta, capu ayén teꞌirájraa. Ayee mú tiꞌihuaúꞌixaa aꞌɨ́ɨme ɨ́ mej tíꞌimɨjhuaca. Miyen tɨjɨ́n: “Aꞌi pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ nain tíꞌijcɨꞌɨti. Cheꞌeré, tichéꞌe yeehui raajéꞌica, tɨ́ꞌij téjmi taꞌáa áꞌaraꞌani.” Ayee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aj mú mi rajvíꞌi aꞌɨ́jna ɨ́ yaujraꞌan. Matɨ́ꞌɨj mi raajéꞌica. Aj mú mi ruꞌirájrɨe á puaꞌacɨé aꞌɨ́jna ɨ́ mej raajéꞌica. Yee pu tihuáꞌuruu. Antipuáꞌarecaꞌa icu. ");
INSERT INTO crnNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌíjna i niuucarijraꞌa jetze tɨjɨ́n: ―¿Aꞌiné tejamuáꞌamitɨejteꞌe? ¿Aꞌiné tiꞌitɨ́j ruuren aꞌɨ́jna ɨ́ jaꞌatɨ tɨ áꞌareꞌaraꞌan puꞌeeneꞌe ɨ́ uuva? Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́ pu mú aꞌuvéꞌeméꞌe aꞌame. Tɨ́ꞌɨj jí huáꞌacuiꞌini ɨ́ mej tíꞌimɨjhuacareꞌe aꞌájna. Ajta aꞌɨ́ɨn ɨ́ chuej, aꞌɨ́ɨ pu seica huatapuaíjveꞌesin. Ayej xaa neꞌu téꞌeme. ");
INSERT INTO crnNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Ni secaí jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze seꞌíjna i niuucari tɨ ayén aꞌɨ́jna jɨ́n ráꞌaxa? Ayen tɨjɨ́n: Aꞌíjna ɨ́ tetej ɨ́ mej ayaúuhuaꞌaxɨ ɨ́ mej chiꞌij taꞌahuaca, ayée pu teꞌirájraa tɨ aꞌɨ́ɨn puꞌéeneꞌe jáꞌaraa tɨ iꞌi esquineero. ");
INSERT INTO crnNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ayee pu ráaruu ɨ́ tavástaraꞌa, ɨ́ tɨ jaítzeꞌe íꞌixɨꞌepɨꞌɨn. Rɨ́ꞌɨ pu teꞌutéevatzɨ ɨ́ tatzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Majta meꞌɨ́n ɨ́ teɨte ɨ́ mej teꞌáijta u teyujtaꞌa, majta ɨ́ seica, aꞌij pu puaꞌa huáꞌuruu aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús tɨ ayén huaꞌaj jɨmeꞌe tiuꞌutaxájtacaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ niuucari. Aj mú mi raatatése mej raatéeviꞌi, mej mi raꞌiteáanan. Mɨ́ majta, camu miyen ráaruu. Mehuáꞌatziɨɨneꞌecaꞌa ɨ́ teɨte. Aꞌɨ́j mú jɨ́n raatátuaa. Matɨ́ꞌɨj mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Matɨ́ꞌɨj mi seica huataꞌáitecaꞌa mej mi tiuꞌuxáj jamuan aꞌɨ́jna ɨ́ Jesús. Fariseo mú pɨ́rɨcɨ, majta seica ɨ́ mej jetzen ajtémeꞌecan aꞌɨ́jna ɨ́ Heródes. Aꞌɨ́ mú raatatése mej caꞌaníjraꞌa raatáꞌan tɨ́ꞌij aꞌɨ́ɨn autéꞌɨtzen niuucari jɨmeꞌe tɨ tiuꞌutaxáj, mej mi raatéehuaꞌita. ");
INSERT INTO crnNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Matɨ́ꞌɨj mi eꞌiréꞌene, miyen tiraataꞌixaa tɨjɨ́n: ―Maeestru, aꞌij tu muaꞌaree pej tzáahuatiꞌiraꞌa jɨmeꞌe tíꞌixaxaꞌa. Capu á jetze ruxeꞌeveꞌe aꞌij mej yeꞌí tíꞌixaxaꞌa ɨ́ teɨte. Múꞌee pej caí titeꞌajáahuateꞌe sino ayée pej tíꞌimuaꞌata puáꞌayeꞌi tzáahuatiꞌiraꞌa jɨmeꞌe aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Tichéꞌe seɨj muaataꞌíhuaꞌu. ¿Ni qui xɨ́ꞌepɨꞌɨn tej tiuꞌunajchitáa aꞌij tɨ yeꞌí tíꞌitajijveꞌe aꞌɨ́jna tɨ tíꞌitaꞌaijteꞌe tɨ ayén ántehuaa tɨjɨ́n César? ¿Ni qui tetiuꞌunájchitáa caꞌɨ́n tecaí? ―Yee mú tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Mɨ́ ajta, aꞌɨ́jna ɨ́ Jesús, aꞌɨ́ɨ pu ramuaꞌareerecaꞌa mej caí jéꞌiyecan jɨ́n tíꞌiraꞌihuaꞌuracaꞌa. Aꞌɨ́j pu jɨ́n ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné sej si siyen tíꞌineteseꞌe sej naateeviꞌi niuucari jɨmeꞌe? Seɨj mɨ tumin mé senejeꞌeveꞌɨ́ꞌiteꞌe. Nichéꞌe raꞌuseíj. ");
INSERT INTO crnNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Matɨ́ꞌɨj mi yeꞌeveꞌɨ́ꞌite. Tɨ́ꞌɨj raꞌuseíj, tɨ́ꞌɨj jí ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―¿Aꞌataani néerimeꞌaraꞌan aꞌaseijreꞌe? ¿Aꞌiné ántehuaa ɨ́ tɨ áꞌayuꞌusiꞌi? Aj mú mi miyen tiuꞌutaniú tɨjɨ́n: ―Aꞌɨ́jna ɨ́ tɨ tíꞌitaꞌaijteꞌe, aꞌɨ́jna tɨ ayén ántehuaa tɨjɨ́n César. ");
INSERT INTO crnNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee xu seꞌɨ́jna jɨ́n huárɨni. Setáꞌaj raatáꞌan seꞌɨ́jna tɨ tíꞌitaꞌaijteꞌe tiꞌitɨ́j tɨ racɨ́ꞌɨcɨpua. Seajta siyen tiraatáꞌan ɨ́ Dios tiꞌitɨ́ tɨ ajta ayén tíꞌijcɨpua. ―Ayee pu tihuaꞌutáꞌixaa. Majta meꞌɨ́n, temuaꞌa mú titeeteújtzaahua meꞌɨ́jna jɨmeꞌe aꞌij tɨ yeꞌí tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Matɨ́ꞌɨj mi seica á eꞌiréꞌene ɨ́ mej miyen ánteꞌarua tɨjɨ́n Saduceo. Aꞌii mú miyen tíꞌixaxaꞌa mej nuꞌu caí chéꞌe huatarújsin ɨ́ mej meri huácuii. Seɨj mú jɨ́n niuucari tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesus. ");
INSERT INTO crnNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Miyen tɨjɨ́n: ―Maeestru, ayée pu tiraꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés. Tɨ́ puaꞌa nuꞌu jaꞌatɨ́ neɨche, tɨ puaꞌa aꞌɨ́ɨ caí títɨꞌɨríjmuaꞌa huámɨꞌɨni, ruxeꞌeveꞌe nuꞌu tɨ ihuáareꞌaraꞌan raꞌancuréꞌeviꞌitɨ aꞌɨ́jna tɨ ratéviꞌitɨneꞌe ɨ́ tɨ huamɨ́ꞌɨ. Ajta ayén ruxeꞌeveꞌe tɨ aꞌɨ́ɨn tiyaúumuaꞌa áꞌaraꞌani aꞌɨ́jna jetze meꞌecan ɨ́ tɨ huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","’Ayee puꞌu nuꞌu tiujuꞌurɨ́j. Muaꞌaráhuaꞌapua mú aráꞌasecaꞌa aꞌɨ́ɨme ɨ́ mej ruꞌihuaamuaꞌa. Tɨ́ꞌɨj jí aꞌɨ́ɨn tɨ vástaꞌa huaténeꞌɨchecaꞌa. Capúu xɨ títɨꞌɨríjmuaꞌa huamɨ́ꞌɨ aꞌɨ́jna tɨ iꞌivastaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tɨ́ꞌɨj jí aꞌɨ́ɨn tɨ raꞌitéꞌase, aꞌɨ́ɨ pu raꞌancuréꞌeviꞌitɨ aꞌɨ́jna tɨ ratéviꞌitɨ́néꞌe aꞌɨ́jna tɨ huamɨ́ꞌɨ. Ajta aꞌɨ́jna juutzeájraꞌan ajta pu huamɨ́ꞌɨ. Capu ajta títɨꞌɨríjmuaꞌa jáꞌaraa. Ajtahuaꞌa seɨ́j juutzeájraꞌan raꞌancuréꞌeviꞌitɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Ayee pu cheꞌatá naꞌa huarɨ́j. Ajta pu huamɨ́ꞌɨ. Capu ajta títɨꞌɨríjmuaꞌa jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","’Ayee pu cheꞌatá naꞌa tihuáꞌuruu naíjmiꞌica ɨ́ mej aráhuaꞌapua aráꞌasecaꞌa ɨ́ ruꞌihuaamuaꞌa. Capu jaꞌatɨ́ títɨꞌɨríjmuaꞌa jáꞌaraa. Tɨ́ꞌɨjtaꞌi nuꞌu huamɨ́ꞌɨ ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Aꞌiquí téꞌeme matɨ́ꞌɨj aꞌitácɨɨne aꞌu mej eꞌevéꞌenamiꞌi ɨ́ mej huácuii? Naíjmiꞌi mú huácuii ɨ́ mej ratéviꞌitɨneꞌe. ¿Aꞌataani ɨ́raꞌaraꞌan puꞌéeneꞌe aꞌame aꞌɨ́jna xɨcájraꞌa jetze matɨ́ꞌɨj huatarún? ");
INSERT INTO crnNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen xu caí ramuaꞌaree aꞌij tɨ téꞌeyuꞌusiꞌihuacaꞌa ɨ́ yuꞌuxari jetze. Seajta caí ramuaꞌaree aꞌij tɨ rɨcɨ ɨ́ Dios ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe. Aꞌɨ́j xu jɨ́n, múꞌeen seteꞌuteújxua jeíhua huápɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","’Ayee nu tejáꞌamuaꞌixaateꞌe. Matɨ́ꞌɨj huatarún ɨ́ mej huácuii, camu chéꞌe néjneꞌɨche muáꞌajuꞌun. Majta ɨ́ ꞌuuca, camu majta viɨ́che muáꞌajuꞌu. Ayee muꞌu éeneꞌe muáꞌajuꞌu matɨ́j eꞌen ɨ́ xɨéjniuꞌucari ɨ́ mej tíꞌivaɨreꞌe aꞌujna ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","’Aꞌɨ́jna jetze ɨ́ xɨcájraꞌa mej jetzen aꞌitajúꞌun ɨ́ mej huácuii, ayée nu aꞌatzu tejáꞌamuaꞌixaateꞌe. ¿Ni secaí jaꞌanáj raꞌujíjve aꞌɨ́jna yuꞌuxari jetze tɨ raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan aꞌij tɨ téꞌaxa ɨ́ niuucari tɨ́ꞌɨj aꞌɨ́ɨn Moisés tuꞌupi huaseíj tɨ vivéj, tɨ ajta teátaasimeꞌe? Aꞌɨ́ pu jetzen Dios raatajé. Ayen tɨjɨ́n: “Nee nu naúcheꞌe huáꞌa Dios púꞌeen ɨ́ mej áꞌamuayaaxustemuaꞌa, aꞌɨ́jna ɨ́ Abraham, ajta aꞌɨ́jna ɨ́ Isaac, ajta aꞌɨ́jna ɨ́ Jacobo.” ");
INSERT INTO crnNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","’Ayee nu tejáꞌamuaꞌixaateꞌe. Ayee pu tiuꞌutaxájtacaꞌa ɨ́ Dios aꞌɨ́mej jɨmeꞌe ɨ́ mej meri huácuii. Tihuaúꞌixaa cumu mej mauj ruuri. Tɨ́ puaꞌa mecaí chéꞌe rúuricajcheꞌe jemin ɨ́ Dios, capu huáꞌa Dios áꞌameꞌencheꞌe. ―Ayee pu Jesús tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Seɨ́j pu ajta aꞌaráꞌa ɨ́ tɨ téꞌeyuꞌuxaca yuꞌuxari jetze. Huaꞌunamuajriꞌi aꞌij mej yeꞌí tíꞌiruixaateꞌecaꞌa. Raꞌaranájchecaꞌa aꞌij tɨ yeꞌí tiuꞌuxájtacaꞌa ɨ́ Jesús. Aj pu i ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitáani niuucarijraꞌa jaítzeꞌe ruxeꞌeveꞌe ɨ́ tɨ raaxájtacaꞌa aꞌɨ́jna ɨ́ Moisés teecan? ―Yee puꞌu tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨ téꞌeyuꞌuxaca ɨ́ yuꞌuxari jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Aꞌi pu aꞌɨ́ɨn púꞌeen ɨ́ niuucari tɨ jaítzeꞌe ruxeꞌeveꞌe caí méèj seɨj ɨ́ niuucari, tɨ ayén een: “Xaanamuajriꞌi mɨ sej íiyen huachéjme aꞌíjna chuéjraꞌa japua yú Israél. Aꞌíjna tɨ taꞌivástaraꞌa, ɨ́ Dios, aꞌɨ́ɨ pu seɨ́j naꞌa púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ayee pu nuꞌu tiúꞌujxeꞌeveꞌe pej rɨ́ꞌɨ tiraateájtuaani aꞌatzajtaꞌa ɨ́ Dios jemi, nain pej jɨ́n rɨ́ꞌɨ tiraateájtuaani, áꞌaxeꞌeviꞌiraꞌa jɨmeꞌe, pajta áꞌamuaꞌareereꞌe jɨmeꞌe, pajta nain ɨ́ aꞌacaꞌaníjraꞌa, pajta ɨ́ áꞌaxɨejniuꞌuca jɨmeꞌe.” Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ niuucari tɨ jaítzeꞌe ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ajta ɨ́ niuucari tɨ raꞌitéꞌase, ayej cheꞌatá naꞌa tɨ́n een. Aꞌii pu aꞌɨ́ɨn pɨ́rɨcɨ tɨ jɨ́meꞌen raxa yee: “Patáꞌaj piyen cheꞌatá penaꞌa rɨ́ꞌɨ tirájchaꞌɨ́ɨ ɨ́ axɨ́ꞌej tevi patɨ́j aseɨ́j.” Capu méèj niuucari tɨ ayén jaítzeꞌe tiúꞌujxeꞌeveꞌe caí aꞌíjna i niuucari ɨ́ tɨ tíꞌihuaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Aj pu i aꞌɨ́ɨn ɨ́ tɨ téꞌeyuꞌuxaca ayén tiraataꞌixaa tɨjɨ́n: ―Maeestru, temuaꞌa pej naa xɨ́ꞌepɨꞌɨn tiraataxájtacaꞌa. Ayej xaa neꞌu tiꞌayajna patɨ́j pauchén tiraataxájtacaꞌa. Seɨ́j puꞌu i Dios. Camu muꞌíi. ");
INSERT INTO crnNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ajta pu tíꞌivaɨreꞌe tɨ puaꞌa rɨ́ꞌɨ petiraateájtuaani ɨ́ Dios jemi nain jɨmeꞌe ɨ́ aꞌatzajtaꞌa, pajta ɨ́ áꞌaxeꞌeviꞌiraꞌa jɨmeꞌe, pajta áꞌamuaꞌareereꞌe jɨ́meꞌen. ’Ayen cheꞌatá naꞌa tíꞌivaɨreꞌe pej rɨ́ꞌɨ tirájchaꞌɨɨ axɨ́ꞌej tevi patɨ́j aseɨ́j. Jeíhua pu hui tíꞌivaɨreꞌe ɨ́ Dios jemi tɨ puaꞌa jaꞌatɨ́ teꞌaráꞌasten aꞌíjna jɨmeꞌe ɨ́ niuucari tɨ tíꞌihuaꞌapua. Jaítzeꞌe pu tíꞌivaɨreꞌe ɨ́ Dios jemi aꞌíjna caí tɨ jaꞌatɨ teꞌaráꞌasten nain jɨmeꞌe ɨ́ muaɨꞌɨvéjri mej tíꞌitecuiꞌica naꞌari nain jɨmeꞌe aꞌu mej huajaꞌataꞌiraca ɨ́ yeꞌemuaate. ");
INSERT INTO crnNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tɨ́ꞌɨj Jesús ráamuaꞌareeriꞌi aꞌij tɨ yeꞌí tiuꞌutaniú aꞌɨ́jna ɨ́ tɨ téꞌeyuꞌuxaca, aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa ehuauritɨ́éecan jɨmeꞌe, aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Pepuꞌuri tɨ́muaꞌa áꞌacaꞌane tɨ huataseíjreꞌen mɨ aꞌatzajtaꞌa nain aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. ―Ayee pu tiraataꞌixaa. Aj pu xaa caí chéꞌe jaꞌatɨ́ aꞌujcaꞌanée jáꞌaraa tɨ ayén tiraaꞌíhuaꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ajtahuaꞌa pu aꞌaꞌuteájrupi ɨ́ Jesús aꞌujna teyujtaꞌa. Tihuaꞌuhuamuáꞌate. Ayen tɨjɨ́n: ―Ayee mú tíꞌixaxaꞌa ɨ́ mej téꞌeyuꞌuxaca tɨ aꞌɨ́ɨn ɨ́ Cɨríistuꞌu tɨ nuꞌu aꞌɨ́ɨn púꞌeen ɨ́ huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan. ");
INSERT INTO crnNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Mɨ́ ajta, aꞌɨ́ɨn Xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu caꞌaníjraꞌa raatáꞌa aꞌɨ́jna ɨ́ David teecan tɨ ayén tiuꞌutaxáj tɨjɨ́n: Tavástaraꞌa pu ayén tiraataꞌixaa aꞌíjna i nevástaraꞌa tɨjɨ́n: “Antiyeíjxɨꞌɨ i ɨpuari japua, íiye nerɨꞌɨríintaꞌa. Paúcheꞌe antícatii aꞌajtá necaí huaꞌutémuaꞌitɨn ɨ́ mej muájchaꞌɨɨreꞌe.” Ayee puꞌu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ David teecan. ");
INSERT INTO crnNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","’Aꞌijna ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Cɨríistuꞌu, aꞌii pu aꞌɨ́ɨn púꞌeen tɨ aváꞌujyaꞌupuateꞌecaꞌa ɨ́ David teecan ayén tɨjɨ́n: “Nevástaraꞌa.” Huaꞌapua pu jɨ́n raatámuaꞌatzi David teecan aꞌɨ́jna ɨ́ Cɨríistuꞌu. Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌihuaꞌu, ¿aꞌiquí tɨ ayén huaꞌapuaca jɨ́n raatamuáꞌa aꞌɨ́jna ɨ́ David teecan? ¿Aꞌiquí huataújmuaꞌa tɨ aꞌɨ́ɨn Cɨríistuꞌu tɨ jetzen airáane aꞌɨ́jna ɨ́ David teecan, ayée pu ajta tijíꞌivastareꞌaraꞌan? Majta meꞌɨ́n teɨte ɨ́ mej ráanamuajriꞌi, jeíhua mú aꞌutéꞌuucaꞌa. Huaꞌaránajchecaꞌa jeíhua aꞌij tɨ yeꞌí tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ajta Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu aꞌɨ́mej jemi ɨ́ mej téꞌeyuꞌuxaca. Huaꞌaránajche mej tíꞌitechejca ɨ́ síicuꞌuri jɨmeꞌe tɨ tɨ́tɨꞌɨjme mej mi huataújseijrata mé jéjreꞌe. Ajta huaꞌaráanajche mej huáꞌajtzaahuatiꞌireꞌe ɨ́ teɨte jeíhua mej mi meꞌɨ́n teɨte huaꞌutateújteꞌen aꞌu tɨ naꞌa caaye jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","’Majta meꞌɨ́jna ɨ́ mej téꞌeyuꞌuxaca, matɨ́ꞌɨj teyujtaꞌa uteáruꞌipicheꞌe, aj mú mi rahuau aꞌu mej jeꞌecáaraꞌase ɨ́ mej veꞌecán jɨ́n títetateí. Naꞌari tɨ puaꞌa metíꞌiyeste jáꞌahuaꞌa chiꞌita, aꞌɨ́ɨ mú rahuauni aꞌu tɨ aꞌɨ́ɨn aꞌujcáꞌa ɨ́ tɨ tihuáꞌamicua mej mi tiúꞌucuaꞌani meesa japua á vejliꞌi jemin. ");
INSERT INTO crnNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","’Aꞌɨ́ mú hui majta tihuáꞌariꞌiracareꞌe nain aꞌachú mej caj tíꞌijchaꞌɨɨ ɨ́ mej antiujseɨ́jtacareꞌe ɨ́ ucarijse. Ayee mú meꞌɨ́jna jɨ́n huárɨni, majta meꞌuun aꞌuteáruꞌipicheꞌe u teyujtaꞌa. Majta áꞌateeren mej téniuusimeꞌe muáꞌajuꞌun ɨ́ Dios jemi. Ayee mú tiúꞌujseijrata mej caí tiꞌitɨ́j jɨ́n autéꞌɨtzen. Ayee nu tejáꞌamuaꞌixaateꞌe, jaítzeꞌe mú rajpuaíjtzi muáꞌajuꞌu aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca caí méèj jaꞌatɨ́. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ajtahuaꞌa, Jesús pu aꞌuun aꞌutéveecaꞌa teyujtaꞌa, aꞌájna vejliꞌi cajun jetze aꞌu mej tumin tzajtaꞌan aucájhuaꞌanaa muáꞌayeꞌi. Jesús pu huáꞌaseijracaꞌa ɨ́ teɨte mej ruꞌucáhuaꞌanaa ɨ́ tumin ɨ́ cajun jetze. Majta meꞌɨ́n chíjteaani mej muꞌiicáa, jeíhua mú tumin ucahuaꞌanáa. ");
INSERT INTO crnNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Matɨ́ꞌɨj tumin ucahuaꞌanáa, aj puꞌi ucarij eꞌiréꞌene tɨ ruseɨ́jtacaꞌa. Tɨ́ꞌɨj jí aꞌíin huaꞌapuaca ucáahuaꞌaxɨ ɨ́ tumin tɨ cɨ́j arástɨme. ");
INSERT INTO crnNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tɨ́ꞌɨj raaseíj ɨ́ Jesús, aꞌɨ́ɨ pu huaꞌutajé aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe. Ayej tiꞌayajna. Jaítzeꞌe pu tíꞌivaɨreꞌe ɨ́ Dios jemi aꞌachú tɨ caj tiuꞌutáꞌa amɨ́jna mɨ ucarij caí nain ɨ́ mej caj tiuꞌutáꞌa ɨ́ seica mɨ chíjteaani. ");
INSERT INTO crnNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","’Amɨ́me chíjteaani, aꞌɨ́ɨ muꞌu uꞌucájhuaꞌanáa ɨ́ tumin tɨ huaꞌavéꞌeturaate. Mɨ́ ajta amɨ́jna mɨ ucarij, ayée pu caj éeneꞌe tɨ caí aꞌij tíꞌijviicuaꞌi, nain pu caj teꞌucáahuaꞌaxɨ tɨ́j naꞌa tɨ caj tíꞌituaaveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Matɨ́ꞌɨj mi huiráacɨ aꞌujna teyujtaꞌa. Puꞌuri huiiraméꞌeca aꞌɨ́jna ɨ́ Jesús, tɨ́ꞌɨj jí seɨ́j tɨ jamuan áꞌucheꞌecaneꞌe ayén tiraataꞌixaa tɨjɨ́n: ―Maeestru, casiꞌi. Huaseíj. Temuaꞌa pu tiꞌivivéjme mɨ tetej tɨ ticaíjme íiyej jaxuꞌu jetze. Ajta mɨ chiꞌij, naa pu een. ");
INSERT INTO crnNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Aj pu i ayén tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Casiꞌi, múꞌeen. Xaaseíj. Naíjmiꞌi tɨ vivejméꞌe huavéjme ɨ́ chiꞌij, nain pu huatéꞌuuniꞌihuaꞌa tɨ aréꞌevee ɨ́ chiꞌij. Capu chéꞌe seíireꞌe aꞌame ɨ́ jaxuꞌu jetze ɨ́ tetej tɨ rujapua ticaíjme. ");
INSERT INTO crnNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Matɨ́ꞌɨj mi aꞌucɨ́j. Aꞌuun mú aꞌaráꞌa aꞌájna teyuu tɨ jéꞌejnee jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Tɨ́ꞌɨj jí á aꞌujyeíjxɨ aꞌɨ́jna ɨ́ Jesús, majta seica, aꞌɨ́jna ɨ́ Pedro, ajta ɨ́ Jacobo, ajta ɨ́ Juan, ajta ɨ́ Andrés. Aꞌii mú avíitzi jɨ́n miyen tirájhuaviiriꞌi tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Patáꞌaj titaatáꞌixaateꞌen jaꞌanáj tɨ ayén tíꞌirɨni. ¿Tiꞌitájni aꞌij tíꞌiseijreꞌen tɨ́ꞌɨj aꞌájna pɨ́ tejaꞌuréꞌenen tɨ teꞌaráꞌasten nain patɨ́j peri tiuꞌutaxájtacaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen, tɨ́ꞌij caí jaꞌatɨ́ amuaacuanamuan. ");
INSERT INTO crnNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ayee nu tejáꞌamuaꞌixaateꞌe. Muꞌiitɨ́ mú huataseíjreꞌesin mej nuꞌu neniuuca jɨmeꞌe tiꞌixáata muáꞌajuꞌun. Miyen tɨjɨ́n: “Nee nu Cɨríistuꞌu pɨ́rɨcɨ.” Jeíhua mú huáꞌacuanamuan ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Tɨ́ puaꞌa seri siyen tínamuajra mej nuꞌu neꞌuseꞌen á jáꞌahuaꞌa, naꞌari mej nuꞌu meri tɨ́muaꞌa autéhuijsin mej neꞌuseꞌen, caxu tíꞌitziɨɨneꞌe. Capu amɨ́n aꞌij. Ayee pu tiúꞌujxeꞌeveꞌe tɨ ayén tejaꞌuréꞌenen. Caxɨ́ɨ pu aꞌájna tejaꞌuréꞌenejsin aꞌɨ́jna xɨcájraꞌa jetze tɨ jetzen teꞌaráꞌasti nain jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","’Ayee pu téꞌeme. Seica mú teɨtejraꞌa, majta seica teɨtejraꞌa, aꞌɨ́ɨ mú naíjmiꞌi huateújneꞌusiꞌiteꞌesin. Majta ɨ́ mej seica chuéjraꞌa japua aꞌuchéjme, majta mej seɨj chuéjraꞌa japua aꞌuchéjme, aꞌɨ́ɨ mú naíjmiꞌi huateújneꞌusiꞌiteꞌesin. Ajta huateújcaꞌatzɨjxɨꞌɨsin ɨ́ chuej puaꞌamecɨé íiyen chaanaca japua. Muꞌiitɨ́ mú majta huatatɨéjcu. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ taꞌamuájca ɨ́ mej jɨ́n rajpuaíjtzi muáꞌajuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Sehuaújchaꞌɨn múꞌeen, aꞌiné mejamuáꞌanviꞌitɨ́n huáꞌa jemi ɨ́ mej teꞌáijta. Majta teyujtaꞌa mú amuaꞌatévajxɨꞌɨsin. Mejamuaatájeevi sej si tiuꞌuxáj jamuan ɨ́ tajtuhuan, seajta jamuan ɨ́ rey. Mejamuaatájeevi meꞌɨ́jna jɨmeꞌe ɨ́ neniúucajtzeꞌe ineetzi. Ayee mú meꞌɨ́jna jɨ́n rɨni, múꞌeen xu neetzi jetze meꞌecan tihuaꞌutáꞌixaateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Amuacaí, aꞌii pu ruxeꞌeveꞌe sej tihuaꞌutáꞌixaateꞌen nainjapua ɨ́ chuéjraꞌa aꞌij tɨ een jɨ́n Dios tíhuaꞌutáꞌuuniꞌira. Ayee xu seꞌɨ́jna jɨ́n huarɨ́n, aj pu xaa teꞌentipuáꞌari nain. ");
INSERT INTO crnNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","’Tɨ́ puaꞌa seica mejamuáꞌanviꞌitɨ́n aꞌɨ́mej jemi ɨ́ mej tíꞌitaꞌaijteꞌe, caxu siyen tíꞌimuaꞌajca aꞌij sej yeꞌí tihuaꞌutáꞌixaateꞌesin. Ayee xuꞌu huárɨni aꞌɨ́jna xɨcájraꞌa jetze. Aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu amuaatáꞌasin aꞌij sej yeꞌí tiuꞌutaxáj. Aꞌɨ́j pu jɨ́n, aꞌij tɨ tejamuaatámitɨejteꞌesin, aꞌɨ́j xuꞌu huaꞌutáꞌixaateꞌen. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ tiꞌixa aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","’Ayee pu ajta téꞌeme aꞌɨ́jna xɨcájraꞌa jetze. Seica mú rujúutzimuaꞌa áꞌaviꞌitɨn aꞌɨ́jme jemi ɨ́ mej teꞌáijta mej mi huáꞌucuiꞌini. Ayee mú cheꞌatá menaꞌa huáꞌaruuren ɨ́ rujaꞌatzimuá. Majta seica ayén cheꞌatá menaꞌa huáꞌaruuren ɨ́ ruyaujmuaꞌa. Majta meꞌɨ́n yaújmuaꞌameꞌen, aꞌɨ́ɨ mú huaꞌuténeꞌusiꞌiteꞌesin ɨ́ ruvaújsimuaꞌa. Aꞌɨ́ mú majta tiuꞌutáꞌasin mej seica huáꞌucuiꞌini. ");
INSERT INTO crnNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Naíjmiꞌi ɨ́ teɨte, múꞌejmi jemi camu jáꞌamuaxeꞌeveꞌe muáꞌajuꞌu aꞌɨ́jna jɨmeꞌe sej ineetzi jetze ajtémeꞌecan; aꞌɨ́ɨ mú naímiꞌi amuajchaꞌɨ́ɨreꞌe muáꞌajuꞌu. Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ tɨ ayén teꞌutáviicuaꞌira aꞌajtá caí huámɨꞌɨni, Dios pu raꞌancuréꞌeviꞌitɨ aꞌájna tɨ tejéꞌaijta. ");
INSERT INTO crnNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Aꞌɨ́jna xɨcájraꞌa jetze tiꞌitɨ́j xu seijran tɨ aꞌij puaꞌa een, tɨ xánaꞌaviꞌireꞌe, tɨ tziɨ́ɨniꞌireꞌe. Aꞌuu mú raatéchajtza aꞌu tɨ caí ayén tiraavíjteꞌe. (Aꞌɨ́ pu yaúꞌitɨée aꞌame tɨ raꞌajíjveꞌen aꞌíjna jetze i yuꞌuxari.) ’Setɨ́ꞌɨj raseijran, ayée xu huárɨni. Aꞌɨ́ɨ ɨ́ mej Judea huachéjme, michéꞌe meꞌɨ́n aꞌucɨ́jxɨꞌɨn caꞌanacan aꞌu tɨ áꞌujɨ́rime. ");
INSERT INTO crnNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tɨ́ puaꞌa aꞌɨ́jna xɨcájraꞌa jetze, jaꞌatɨ́ án áꞌujcatii ɨ́ ruchiꞌi japua taꞌavéꞌenamiꞌi, chéꞌe aꞌɨ́ɨn caꞌanacan acájraꞌani. Ajta caí ayén rɨjca, tɨ tiꞌitɨ́j huiráꞌavecareꞌen ɨ́ ruchiꞌitá. ");
INSERT INTO crnNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Naꞌari tɨ puaꞌa seɨ́j tejéꞌemuarɨꞌe ɨ́ ruvíꞌiraꞌataꞌa, chéꞌe caí aꞌuréꞌenineꞌicaꞌan ɨ́ ruche tɨ́ꞌij rucɨɨxu huiráapin. ");
INSERT INTO crnNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","’Cuiꞌi xaa aꞌɨ́ɨme, ɨ́ mej rajpuaíjtzi muáꞌajuꞌu aꞌɨ́jna xɨcájraꞌa jetze aꞌɨ́ɨme ɨ́ ꞌuuca ɨ́ mej aꞌutájucájme, majta aꞌɨ́ɨme ɨ́ mej huáꞌatziꞌite ɨ́ ruyaujmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Múꞌeen xu siyen tíꞌijhuaviira ɨ́ Dios tɨ́ꞌij caí ayén aꞌájna tejaꞌuréꞌenen tɨ́ꞌɨj huáseeviꞌin. ");
INSERT INTO crnNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","’Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén téꞌeme aꞌɨ́jna xɨcájraꞌa jetze. Jaítzeꞌe mú rajpuaíjtzi muáꞌajuꞌu mecaí ɨ́ mej meri rajpuaíjtzi muáꞌaraa tɨ yú eꞌiréꞌene. Capu ajta chéꞌe ayén tejaꞌuréꞌenejsin seɨj xɨcájraꞌa jetze tɨ́j aꞌájna. ");
INSERT INTO crnNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ajta tɨ puaꞌa aꞌɨ́ɨn tavástaraꞌa caí aꞌɨ́ɨn ayén raruuren tɨ́ꞌij caí chéꞌe ayén áꞌateeviꞌin tɨ teuuméꞌen aꞌachú puaꞌan xɨca, capu jaꞌatɨ́ ruuri áꞌameꞌencheꞌe. Mɨ́ ajta, huáꞌa jɨmeꞌe ɨ́ teɨte tɨ Dios ari huaꞌantíhuau ɨ́ jéjcua ɨmuá, aꞌɨ́ɨ pu ari ayén raruure tɨ́ꞌij caí chéꞌe ayén áꞌateeviꞌin. ");
INSERT INTO crnNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ayee nu tejáꞌamuaꞌixaateꞌe, aꞌɨ́jna xɨcájraꞌa jetze, ayée pu téꞌeme. Aꞌatɨ́ pu ayén tejámuaatáꞌixaateꞌesin yee: “Casiꞌi, íiye pu jáꞌitaꞌa een aꞌɨ́jna ɨ́ Cɨríistuꞌu”, naꞌari seɨ́j ayén yee: “Aꞌacuí, áa pu jáꞌitaꞌa een.” Tɨ́ puaꞌa miyen tejámuaatáꞌixaateꞌen aꞌɨ́jna xɨcájraꞌa jetze, caxu ráꞌatzaahuateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Seica mú yé uvéꞌenejsin ɨ́ mej tíꞌihuaꞌitaca. Miyen tɨjɨ́n: “Nee nu neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu.” Majta seica miyen tɨjɨ́n: “Netiꞌitéjvee neꞌɨ́jna jɨmeꞌe niuucajtzeꞌen ɨ́ Dios.” Aꞌii mú huaꞌutaseíjrateꞌesin ɨ́ teɨte aꞌij mej yeꞌí tiꞌitɨ́j tiuꞌuyɨ́ꞌɨtɨ mej mi huáꞌucuanamuan, tɨ puaꞌa huatárɨꞌɨristare mej huáꞌucuanamuan ɨ́ teɨte tɨ Dios ari huaꞌantíhuau ruseɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","’Aru, xáanamuajriꞌi temuaꞌa naa. Caxu xaa neꞌu yáꞌuhuaꞌanan nej amuacaí neri amuáꞌixaa nain jɨmeꞌe ɨ́ niuucari. ");
INSERT INTO crnNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ajta hui aꞌɨ́jna xɨcájraꞌa jetze, aꞌájna mej rajpuaíjtzi muáꞌajuꞌun, capu chéꞌe airáxɨri ɨ́ xɨcaj. Ajta ɨ́ máxcɨraꞌi jɨmeꞌe, capu chéꞌe ajta huanéeriꞌicɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Majta ɨ́ mej tátatzaviꞌi ɨ́ ta japua, aꞌɨ́ɨ mú huateújcaꞌatzɨjsin. Aj mú mi cávatzɨ́jxɨꞌɨsin ɨ́ xuꞌuraꞌave aꞌujna ɨ́ ta japua. ");
INSERT INTO crnNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aj xu xaa si neseijran ineetzi, i nej neajta jetzen airáane ɨ́ teáataꞌa. Yé nu veꞌecánejsin jaitɨri tzajtaꞌa. Naa pu temuaꞌa tiuꞌunéeriꞌicɨ́j aꞌame. Nain nu jɨ́n antínmuaꞌareere naꞌame aꞌɨ́jna xɨcájraꞌa jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","’Matɨ́ꞌɨj mi huaꞌaréꞌeꞌitixɨꞌɨsin ɨ́ mej nevaɨreꞌe mej mi huáꞌajseɨreꞌen naíjmiꞌica ɨ́ teɨte tɨ Dios ari huaꞌantíhuau ɨ́ jéjcua ɨmuá. Aꞌu tɨ naꞌa mú huaꞌuréꞌeseɨreꞌesin íiyen chaanaca japua aꞌu mej aꞌucaíjmee ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Sej si jaítzeꞌe yaúꞌitɨée xáꞌaraꞌani aꞌij nej tejáꞌamuaꞌixaateꞌe, aꞌij xu jetze huaruitɨejteꞌen ɨ́ piꞌista aꞌɨ́jna ɨ́ huaréj. Tɨ́ꞌɨj antícuaꞌatíjmeꞌeni ánɨmua tɨ antipíꞌistáreꞌejmee, ajta tɨ́ꞌɨj ajtaxámuaꞌitaxɨꞌɨn, ayée xu éeniꞌicɨꞌe ramuaꞌaréeren tɨ ari vejliꞌi ɨ́ víitaꞌari. ");
INSERT INTO crnNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ayee pu cheꞌatá naꞌa tíꞌiseijreꞌen tɨ ari tíꞌirɨcɨ aꞌij nej neuchén tejamuáꞌixaa. Ayee xu éeniꞌicɨꞌe ramuaꞌaréeren tɨ ari vejliꞌi aꞌɨ́jna xɨcájraꞌa jetze tɨ jetzen teꞌentipuáꞌari naíjmiꞌi. Puꞌuri xaa neꞌu vejliꞌi tɨ́muaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","’Ayej xaa neꞌu tiꞌayajna, ayée nu tejáꞌamuaꞌixaateꞌe ɨ́ mej mauj ruuri ɨ́ teɨte mej íiyen seijreꞌe chaanaca japua, aꞌɨ́ɨ mú caí cuiꞌini asta caí naíjmiꞌi ayén tiúꞌurɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Naíjmiꞌi pu teꞌentipuáꞌari aꞌíjna i chaanaca japua, ajta ɨ́ ta japua. Mɨ́ ajta, aúcheꞌe teꞌaraúrastejsin aꞌíjna i nej neri tejamuáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Jɨ́meꞌen aꞌɨ́jna xɨcájraꞌa tɨ jetzen teꞌentipuáꞌari naíjmiꞌi, capu jaꞌatɨ́ ramuaꞌaree jaꞌanáj tɨ ayén téꞌeme. Capu ajta jaꞌatɨ́ ramuaꞌaree aꞌatzaj tɨ puaꞌa ayén téꞌeme. Aꞌɨ́ɨ ɨ́ mej tíꞌivaɨreꞌe u ta japua, camu majta ramuaꞌaree. Neajta inee, i nej íꞌiyaujraꞌan ɨ́ Dios, canu neajta ramuaꞌaree. Aꞌɨ́ puꞌu ramuaꞌaree ɨ́ niyáꞌupua ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Múꞌeen, caxu seajta ramuaꞌaree jaꞌanáj tɨ aꞌájna tejaꞌuréꞌenejsin. Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe. Rɨ́ꞌɨ xuꞌu huaújruuren múꞌeen. Seucheꞌe xu atanéjneꞌere. Seajta nejchúꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","’Aꞌatɨ́ tɨ huápuaseaaruveꞌen á jáꞌahuaꞌa ɨmuá. Amuacaí pu ruchiꞌi huaꞌíjcateꞌen ɨ́ mej tíꞌimɨjhuaca aꞌujna chiꞌita. Aꞌɨ́ pu huaꞌíjcateꞌe seɨj ajta seɨj mej tiuꞌumuárɨꞌen tiꞌitɨ́j tɨ seɨ́j huayɨ́ꞌɨtɨ. Ajta seɨ́j pu tíꞌijcateꞌen aꞌɨ́jna jɨmeꞌe tɨ tíꞌichaꞌɨcaꞌa á taꞌiténinei. ");
INSERT INTO crnNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ayee nu cheꞌatá nenaꞌa tejáꞌamuaꞌíjcateꞌe múꞌejmi, setáꞌaj atanéjneꞌere aꞌiné caxu ramuaꞌaree jaꞌanáj nej uvéꞌenejsin, inee yé nej iꞌichej. Capu aꞌij ámuaatámitɨejteꞌesin jaꞌanáj nej uvéꞌenejsin, tɨ puaꞌa huatechuíixaren, naꞌari tɨ jáꞌitaꞌa tɨ́caꞌa nusu matɨ́ꞌɨj huajíjhuan ɨ́ tecuaaraꞌise, naꞌari aꞌatzaj tapuáꞌarijmeꞌeca. ");
INSERT INTO crnNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","’Tɨ́ puaꞌa caꞌanacan nuꞌuvéꞌenen, caxu taúraꞌacareꞌen nej amuáateuni secuꞌutzúcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aꞌíjna i nej jáꞌamuaꞌixaateꞌe, aꞌij nu neajta huáꞌaꞌixaateꞌe naíjmiꞌica ɨ́ seica niyen tɨjɨ́n: Seucheꞌe xu atanéjneꞌeri. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Puꞌuri tɨ́n aꞌájna tejaꞌuréꞌenejsimeꞌeca matɨ́ꞌɨj puaꞌa tíꞌiyestehuaꞌa meꞌɨ́jna jɨmeꞌe cáneꞌaxɨ mej huáꞌacuiꞌini, majta mej pan cuaꞌaca tɨ caí levadura ranaxca. Ayee pu téꞌaturaacaꞌa huaꞌapua xɨcaj. Majta meꞌɨ́n ɨ́ mej tíhuaꞌuꞌaíjteꞌe teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej téꞌeyuꞌuxaca, aꞌɨ́ɨ mú tihuaúrixaa aꞌij mej yeꞌí avíitzi jɨ́n tiraatéeviꞌi ɨ́ Jesús mej mi raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ayee mú tíꞌiruixaateꞌecaꞌa tɨjɨ́n: ―Ijii catu raatéviꞌira. Aj tu ti tiyen rɨni matɨ́ꞌɨj tiúꞌuyesten ɨ́ teɨte. Tɨ́ puaꞌa tiyen huárɨni íjii, ayée tu huaꞌutájaaxɨejteꞌesin ɨ́ teɨte. Aj mú mi huataníniuꞌucacu téjmi jemi. Aꞌɨ́j pu jɨ́n tamuárɨꞌeristeꞌe aꞌame tɨ puaꞌa teraatéeviꞌi teꞌaꞌájna. ―Ayee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Meenti aꞌɨ́ɨn ɨ́ Jesús, aꞌujna aꞌutéveecaꞌa u Betania. Aꞌuu pu aꞌutéveecaꞌa aꞌu tɨ éꞌeche aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Simón. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Tɨ́ tineájxɨ huáꞌireꞌaraꞌan jetze ɨ́ atzaj. Tɨ́ꞌɨj aꞌɨ́ɨn Jesús huatecaíca meesa jetze, seɨj pu aveꞌeréꞌene. ꞌƗ́itaꞌa pu púꞌeen aꞌɨ́jna. Aꞌɨ́ pu limeeta huajáasimeꞌe rumuájcaꞌa jetze. Huíjpiticaꞌa aꞌɨ́jna ɨ́ tiꞌitɨ́. Tetej limeetajraꞌa pu puꞌeeneꞌe. Ajta aceite pu avéꞌejɨsti, nardu jetze tɨ meꞌecan, tiꞌitɨ́ tuꞌupi. Naa pu teáarɨ́ꞌe aꞌɨ́jna ɨ́ aceite, ajta jeíhua tíꞌijnajche. Aj pu i aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, raꞌantítapua aꞌɨ́jna ɨ́ limeeta. Tɨ́ꞌɨj jí án yáꞌajtuaa aꞌɨ́jna ɨ́ aceite muꞌúutzeꞌen aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Aj mú mi seica ɨ́ mej aꞌutéꞌuucaꞌa aꞌujna, aꞌɨ́ɨ mú huataníniuꞌucacucaꞌa meꞌɨ́jna jemi ɨ́ ꞌɨ́itaꞌa. Ayee mú tíꞌiruixaateꞌecaꞌa tɨjɨ́n: ―¿Aꞌiné een jɨ́n huaújhuajcacaꞌa amɨ́jna ɨ́ aceite tɨ iꞌicáujmeijra? ");
INSERT INTO crnNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iꞌirɨꞌɨriistacaꞌa pu mej ráatuaanijcheꞌen mej mi raamuáꞌitɨncheꞌe aꞌachú caj huaíca cientos tumin naꞌari jaítzeꞌe, tɨ́ꞌɨj ii tiuꞌutévaɨreꞌencheꞌe ɨ́ tumin mej huaꞌutévaɨreꞌen ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. ―Yee mú tiuꞌutaxájtacaꞌa. Aj mú mi raatájaaxɨejviꞌiriꞌi aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tɨ́ꞌɨj jí Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Xaatapuáꞌajta sej níniuꞌucacu. ¿Aꞌiné een jɨ́n jáꞌitaꞌa xuꞌuráninei? Aꞌíjna tɨ jɨ́meꞌen ayén náaruu mɨ ꞌɨ́itaꞌa, temuaꞌa pu naa xɨ́ꞌepɨꞌɨn huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́ɨme ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, aꞌɨ́ɨ mú múꞌejmi jemi seíireꞌe muáꞌajuꞌu tɨ́j naꞌa rusén jɨmeꞌe. Jaꞌanáj tɨ naꞌa puꞌi íꞌirɨꞌɨriista aꞌame sej huaꞌutévaɨreꞌen tɨ puaꞌa siyen tíꞌijxeꞌeveꞌe. Mɨ́ ajta inee, canu chéꞌe múꞌejmi jemi seíireꞌe naꞌame. ");
INSERT INTO crnNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","’Aꞌijna i ꞌɨ́itaꞌa, ayée pu huarɨ́j aꞌachú tɨ caj tiuꞌutárɨꞌɨristarecaꞌa ɨ́ jemin. Nej caí xɨ huamɨ́ꞌɨ, aꞌɨ́ɨ pu amuacaí necámeijriꞌi ineetzi matɨ́j tíꞌijrɨꞌɨre tɨ puaꞌa jaꞌatɨ́ huámɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ayej xaa neꞌu tiꞌayajna, ayée nu tejáꞌamuaꞌixaateꞌe, aꞌu tɨ naꞌa mej tihuaꞌutáꞌixaateꞌen ɨ́ teɨte niuucajtzeꞌen ɨ́ Dios, naíjmiꞌicɨꞌe íiyen chaanaca japua, aꞌɨ́ɨ mú majta huataxájta aꞌij tɨ huarɨ́j aꞌíjna i ꞌɨ́itaꞌa mej mi jeíhua raꞌutámuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ajta seɨ́j ajtáraa aꞌu mej aꞌutéꞌuucaꞌa ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Ayee pu ántehuaa tɨjɨ́n Judás Iscariotes. Aꞌɨ́ pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna tɨ Jesús jetze ajtémeꞌecan. Ayee pu een jɨ́n ajtáraa tɨ i avíitzi jɨ́n tejáꞌuxa huáꞌa jamuan ɨ́ mej teꞌáijta teyujtaꞌa. Raxɨ́ꞌeveꞌecaꞌa mej naíjmiꞌi raaxɨ́ꞌepɨꞌɨntareꞌen aꞌij mej yeꞌí huárɨni tɨ i aꞌɨ́ɨn huaꞌutátuiireꞌen ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Matɨ́ꞌɨj meꞌɨ́n huánamuajriꞌi, jéꞌecan pu rɨ́ꞌɨ huaꞌutáꞌa. Aj mú mi teꞌataújratziiriꞌi mej mi tiraanájchiteꞌen aꞌɨ́jna ɨ́ Judás. Tɨ́ꞌɨj jí áꞌuraa. Tɨ́ꞌɨj ji raachúꞌeve jaꞌanáj tɨ íꞌirɨꞌɨri tɨ́ꞌij huaꞌutátuiireꞌen aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tɨ́ꞌɨj jí tejaꞌuréꞌene aꞌɨ́jna xɨcájraꞌa jetze, ɨ́ mej jetzen pan cuaꞌaca tɨ caí cuꞌusti, ajta aꞌɨ́jna xɨcájraꞌa mej jetzen mehuáꞌamuaɨꞌɨvajtacareꞌe ɨ́ cáneꞌaxɨ. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ áꞌamuajcaꞌa ɨ́ mej tíꞌiyeste. Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌen, aꞌɨ́ɨ mú mi miyen tiraataꞌíhuaꞌuriꞌi ɨ́ ɨ́ Jesus tɨjɨ́n: ―¿Aꞌuné jetze muaꞌaráanajche tej áꞌujuꞌun tej ti rɨ́ꞌɨ tejáꞌuruuren teꞌɨ́jna jɨmeꞌe ɨ́ pan tej ráacuaꞌani, tej ti raꞌutámuaꞌaree aꞌij tɨ titáachaꞌɨɨ ɨ́ Dios, aꞌɨ́jna xɨcájraꞌa jetze tɨ huáꞌucuii ɨ́ huáꞌayaujmuaꞌa ɨ́ mej amuáatée huanúnuꞌihuacaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tɨ́ꞌɨj jí huaꞌapuaca huataꞌítecaꞌa mej jamuan áꞌujujhuaꞌaneꞌen. Ayen tihuáꞌaꞌixaateꞌe tɨjɨ́n: ―Sericu aꞌájna chajtaꞌa. Aa xu jaꞌatɨ́ éꞌeteuni tɨ xaꞌari huátɨsin, jaj tuꞌurájmuaa. Aj xu si jamuan áꞌujuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Aꞌu tɨ aꞌɨ́ɨn aꞌuteáruti, aꞌájna xu ráahuauni chiꞌiraꞌan jetze ɨ́ jaꞌatɨ. Aj xu si siyen tiraataꞌixaateꞌen ayén tɨjɨ́n: “Yee pu tiꞌixa aꞌɨ́jna ɨ́ Maeestru yee: ¿Aꞌuné neꞌatáꞌaca nej tzajtaꞌan tiúꞌucuaꞌani huáꞌa jamuan ɨ́ neteɨ́testemuaꞌa?” Seajta siyen: “Tetaꞌaj raꞌutámuaꞌaree aꞌɨ́jna xɨcájraꞌa jetze matɨ́ꞌɨj huácuii ɨ́ huáꞌayaujmuaꞌa ɨ́ mej amuáatée huanúnuꞌihuacaꞌa.” Ayee xu tiraatáꞌixaateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Tɨ́ꞌɨj jí aꞌɨ́ɨn hui amuaataseíjrateꞌesin ánɨmua tɨ rujapua tiveꞌéjme cuaartu tɨ veꞌée. Puꞌuri rɨ́ꞌɨ tiúꞌuruu temuaꞌa naa. Aꞌuu xu si rɨ́ꞌɨ teꞌuhuáruuren ɨ́ tej ráacuaꞌani ɨ́ pan. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Matɨ́ꞌɨj mi u áꞌujuꞌu ɨ́ mej huaꞌapua. Ayee pu tejaꞌuréꞌene naíjmiꞌi tɨ tihuaꞌutáꞌixaa ɨ́ Jesús. Aj mú mi rɨ́ꞌɨ ráaru ɨ́ mej ráacuaꞌani mej mi raꞌutámuaꞌaree aꞌɨ́jna xɨcájraꞌa jetze tɨ Dios huáꞌuchaꞌɨj. ");
INSERT INTO crnNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɨ́ꞌɨj ari huachúmuaꞌancaa, aj pu i aꞌuteájrupi u chiꞌita ɨ́ Jesús, majta ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Matɨ́ꞌɨj meri tíꞌicuaꞌacaa meesa japua, aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu xaa neꞌu tejáꞌamuaꞌixaateꞌe. Seɨ́j tɨ aꞌamua jetze ajtémeꞌecan múꞌeen mɨ sej tíꞌicuaꞌa ne jamuan, aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌɨ́ɨ pu neetzi jɨmeꞌe tiuꞌutátuiireꞌesin huáꞌa jemi ɨ́ mej teꞌáijta teyujtaꞌa. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Tɨ́ꞌɨj jí utéevatzɨ́ ɨ́ huáꞌa tzajtaꞌa. Aj mú mi autéjhuii mej raataꞌíhuaꞌu meꞌɨ́jna ɨ́ Jesús, seɨ́j ajta seɨ́j. Miyen tɨjɨ́n: ―¿Aꞌataani púꞌeen? ¿Ni qui inee? Ajtahuaꞌa seɨ́j ayén tɨjɨ́n: ―¿Aꞌataani, caꞌɨ́n inee? ");
INSERT INTO crnNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen, ɨ́ seɨ́j ɨ́ sej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Aꞌii pu pan cuaꞌa aꞌíjna jetze i tuxaꞌa ne jamuan. ");
INSERT INTO crnNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ayej xaa neꞌu tiꞌayajna. Ayee pu tejaꞌuréꞌenejsin ineetzi jemi nej neajta ɨ́ teáataꞌa jetze airáane aꞌij tɨ yeꞌí téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. ’Mɨ́ ajta, aꞌɨ́jna tɨ nejɨ́meꞌen tiuꞌutátuiireꞌesin huáꞌa jemi, ayée nu tejáꞌamuaꞌixaateꞌe, aꞌii pu huápɨꞌɨ rajpuaíjtzi aꞌame. Jaítzeꞌe pu raatévaɨreꞌencheꞌe tɨ caí núꞌihuaacheꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Maúcheꞌe mú tíꞌicuaꞌacaa. Aj pu i Jesús pan tɨ́ꞌɨj. Aj pu i rɨ́ꞌɨ tiuꞌutáꞌa ɨ́ Dios jemi, ajta raꞌantítaaraxɨ, aꞌɨ́ɨ pu huaꞌuréꞌeꞌɨꞌɨpɨꞌɨ. Ayen tɨjɨ́n: ―Xáacuaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen i nehuáꞌiraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ajta áꞌiyen vaasu tijáj. Ajta rɨ́ꞌɨ tiuꞌutáꞌa ɨ́ Dios jemi, aꞌɨ́ɨ pu ajta huaꞌuréꞌijte. Naíjmiꞌi mú raꞌantiꞌí ɨ́ jaj ɨ́ vaasu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌijna tɨ urajmuaa i vaasu tzajtaꞌa, aꞌii pu aꞌɨ́ɨn púꞌeen i nexuureꞌe ɨ́ nej raꞌiráxɨreꞌesin nej ni huaꞌutévaɨreꞌen muꞌiicáca jemi, ajta tɨ ij Dios raꞌantipuáꞌajteꞌen ɨ́ tɨ jéjcuacan jɨ́n teꞌataújratziiriꞌi ruseɨ́j aꞌɨ́mej jemi tɨ aꞌɨ́ɨn tihuaꞌutáꞌuuniꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","’Ayee nu tejáꞌamuaꞌixaateꞌe. Ayej xaa neꞌu tiꞌayajna. Ijii, canu chéꞌe raꞌantíꞌisin aꞌíjna i uuva jáꞌaraꞌa. Mɨ́ ajta, aꞌɨ́jna xɨcájraꞌa jetze tɨ́ꞌɨj Dios avéuraꞌateꞌe nainjapua ɨ́ chaanaca, aꞌájna xɨcájraꞌa jetze nu xaa raꞌantíꞌisin jéjcuacan jɨmeꞌe ɨ́ jáꞌaraꞌaraꞌan ɨ́ uuva. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Matɨ́ꞌɨj mi seɨj tiuꞌutáchuiicacaꞌa chuiicari ɨ́ mej jɨ́n rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios. Matɨ́ꞌɨj mi aꞌucɨ́j. Aj mú meꞌuun aꞌaráꞌa Aceituunajemi, jɨrí tɨ aꞌutacáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ Dios ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: “Nee nu i nej iꞌi Dios, aꞌɨ́j nu jéꞌicatan ɨ́ tɨ cáneꞌaxɨ tiseíj. Majta aꞌucɨ́jxɨꞌɨsin ɨ́ cáneꞌaxɨ.” Yee puꞌu téꞌeyuꞌusiꞌi. Ayee pu tíꞌineruuren ineetzi. Seajta múꞌeen, setiuꞌutatéviꞌiraꞌata ineetzi jemi. Aj xu si aꞌucɨ́jxɨꞌɨsin cumu ɨ́ cáneꞌaxɨ tɨ caí jaꞌatɨ́ huáꞌajyeꞌemua. ");
INSERT INTO crnNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mɨ́ neajta inee, netɨ́ꞌɨj huatarún, áa nu aꞌuméꞌe naꞌame aꞌájna Galilea. Amuacaí nu neꞌuun aráꞌaiixa. Seajta áꞌiyen múꞌeen. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Aj pu i aꞌɨ́ɨn Pedro ayén tiraataꞌixaa tɨjɨ́n: ―Capu amɨ́n tɨ puaꞌa metiuꞌutatéviꞌiraꞌata mɨ seica múꞌeetzi jemi. Canu niyen rɨni inee. ");
INSERT INTO crnNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe. Ayee pu téꞌeme íjii tɨ́caꞌa, tɨ caí xɨ huajíjhuaꞌa ɨ́ tecuaaraꞌi, huaíca pej piyen tiuꞌitéhuaꞌita tɨjɨ́n pecáj nemuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mɨ́ ajta aꞌɨ́ɨn Pedro, caꞌanín pu jɨ́n ayén tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa ayén tiúꞌujxeꞌeveꞌe nej huámɨꞌɨni á jamuan, canu cuiꞌi niyen tihuaꞌutáꞌixaateꞌesin yee canu muamuaꞌate. ―Yee puꞌu tiuꞌutaxájtacaꞌa. Majta ɨ́ seica, ayée mú cheꞌatá tíꞌixajtacaꞌa seɨj ajta seɨj aꞌij tɨ Pedro tíꞌixajtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Matɨ́ꞌɨj mi aꞌucɨ́j. Aa mú aꞌaráꞌa huastari tzajtaꞌa, cɨyej tɨ eꞌeréꞌevee tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Getsemaní. Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Xaꞌujráꞌasi múꞌeen iiyecuí, meenti nee, neraatéhuauusin ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Tɨ́ꞌɨj i á aúurupi. Aꞌɨ́mej pu aꞌuvíꞌitɨ́ aꞌɨ́jna ɨ́ Pedro, ajta ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan. Tɨ́ꞌɨj jí aꞌij puaꞌa ruꞌuhuatáꞌa ɨ́ tzajtaꞌan. Jéꞌecan pu uhuateújxɨemɨste ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌij pu puaꞌa neꞌase, huápɨꞌɨ. Xɨee nej cuj mɨꞌɨni. Yee xu huateáturan múꞌeen íiye. Seucheꞌe atanéjneꞌeri. ―Ayee puꞌu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tɨ́ꞌɨj jí aꞌirájraa aꞌatzu ꞌáꞌayee. Aj pu i aicaújtutzi á chuaataꞌa. Rájhuaviiriꞌi ɨ́ Dios tɨ puaꞌa nuꞌu íꞌirɨꞌɨristan tɨ caí ayén tejaꞌuréꞌenen aꞌɨ́jna xɨcájraꞌa tɨ nuꞌu jetzen tirajpuaíitzi áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ayee pu aꞌɨ́ɨn tirájhuaviiriꞌi tɨjɨ́n: ―Dios, ɨ́ pej niyáꞌupua púꞌeen. Naíjmiꞌi pu íꞌirɨꞌɨri múꞌeetzi jemi. Tɨ́ puaꞌa petiꞌitáꞌacareꞌen tɨ caí náacɨꞌɨti aꞌíjna tɨ aꞌij puaꞌa een nej jɨ́n rajpuaíitzi naꞌame. Aru tɨ puaꞌa íꞌirɨꞌɨristan, chéꞌe caí ayén tejaꞌuréꞌenineicaꞌan netɨ́j tíꞌijxeꞌeveꞌe inee, sino patɨ́j múꞌee tíꞌijxeꞌeveꞌe. ―Yee puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aj pu ijtáꞌi u yaꞌuvéꞌeme. Aa pu aꞌaráꞌa aꞌu mej aꞌutéꞌuucaꞌa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Muꞌuri íꞌicuꞌutzucaꞌa. Aj pu i huaꞌujɨ́ste aꞌɨ́ɨme. Tɨ́ꞌɨj jí ayén tiraataꞌixaa ɨ́ Pedro tɨjɨ́n: ―Simón, ¿ni pecáj téꞌeviicuaꞌi pej atáneere aꞌatzu caj sei hora? ");
INSERT INTO crnNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Seucheꞌe atanéjneꞌeri. Seajta raatéjhuauni ɨ́ Dios jemi tɨ ij caí tejamuáacɨꞌɨti tiꞌitɨ́ ɨ́ sej jɨ́n auteáturan ɨ́ Dios jemi. Ayee nu tejáꞌamuaꞌixaateꞌe. Rɨ́ꞌɨ xu títeꞌuhuateújcaꞌanen ɨ́ ru tzajtaꞌa. Mɨ́ ajta caí, capu áꞌamuacaꞌanistiꞌi sej atanéjneꞌeri. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ajtahuaꞌa pu áꞌume. Ayee pu cheꞌatá naꞌa tirájhuaviiriꞌi ɨ́ Dios tɨ caí rajpuaíjtzi áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tɨ́ꞌɨj jí u aꞌuvéꞌemej. Ajtahuaꞌa pu huáꞌuteu mecuꞌutzúcaꞌa aꞌiné cutzi pu huaꞌamuaꞌitɨ́jcɨ́caꞌa jeíhua. Aj pu i Jesús huaꞌutajé. Capu aꞌij huáꞌamitɨejteꞌecaꞌa aꞌij mej yeꞌí tiraataꞌixaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Huaícaca tzajtaꞌa, ajtahuaꞌa pu áꞌume. Ajtahuaꞌa pɨ́ aꞌuréꞌeve tɨ puaꞌa meriꞌijtáhuaꞌa íꞌicuꞌutzu. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni seuj íꞌicuꞌutzu? ¿Ni seújseꞌupeꞌe? Puꞌuri aúcheꞌe. Puꞌuri aꞌájna tejaꞌuréꞌene mej meri nejɨ́meꞌen tiuꞌutátuiireꞌesin, i nej neajta ɨ́ teáataꞌa jetze airáane, aꞌɨ́mej jemi ɨ́ mej aꞌij puaꞌa tíꞌiteteɨte. ");
INSERT INTO crnNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xáꞌajhuiixɨꞌɨ. Cheꞌeré ticu. Puꞌuri eꞌevéꞌeme aꞌɨ́jna tɨ tiuꞌutátuiireꞌesin ineetzi jɨ́meꞌen aꞌɨ́mej jemi ɨ́ mej teꞌáijta. ");
INSERT INTO crnNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Aúcheꞌe pu tiꞌixáatacaꞌa aꞌɨ́jna ɨ́ Jesús, tɨ́ꞌɨj seɨ́j eꞌiréꞌene tɨ aꞌɨ́mej jetze ajtémeꞌecan ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Judás pu ántehuaa. Jeíhua mú teɨte eꞌevéꞌejuꞌucaꞌa jamuan aꞌɨ́jna ɨ́ Judás. Huáꞌaniuucajtzeꞌe mú jɨ́n huajúꞌucaa meꞌɨ́jna ɨ́ mej teꞌáijta teyujtaꞌa, majta meꞌɨ́jna ɨ́ mej téꞌeyuꞌuxaca, majta meꞌɨ́jna ɨ́ vaujsi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aꞌɨ́jna ɨ́ Judás, tɨ huaꞌutátuiireꞌesin ɨ́ Jesús, aꞌɨ́ɨ pu teꞌataújratziiriꞌi aꞌɨ́jna jɨmeꞌe tɨ ayén huárɨni mej mi ráamuaꞌaree jaꞌatɨ́ tɨ pɨ́rɨcɨ aꞌɨ́jna ɨ́ Jesús. Ayen tɨjɨ́n: ―Aꞌɨ́jna ɨ́ nej ruꞌitépɨꞌɨtzeꞌe, ajta ɨ́ nej raatateújteꞌesin, aꞌii pu aꞌɨ́ɨn pɨ́rɨcɨ. Setáꞌaj raatéeviꞌi, seajta raꞌanján, amuajɨ́ꞌɨcɨꞌihuacan temuaꞌa naa. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Judás. ");
INSERT INTO crnNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jɨ́meꞌen puꞌu aꞌaráꞌa, aj pu i ajteáxɨɨrecaꞌa aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí ayén tiraataꞌixaa tɨjɨ́n: ―Maeestru. Aꞌɨ́ pu ayén huataújseijratacaꞌa tɨ́j ɨ́ tɨ rajaahua aꞌɨ́jna ɨ́ Jesús. Ayen tɨjɨ́n: ―Maeestru. Ajta ruꞌitépɨꞌɨtzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Majta meꞌɨ́n ɨ́ teɨte, aꞌɨ́ɨ mú raatéeviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Seɨ́j pu ajta aꞌájna huatéveecaꞌa. Aꞌɨ́ pu ruchun huíjcupi. Aj pu i raꞌajtaveíjchecaꞌa ɨ́ naxairaꞌan jetze ɨ́ tɨ ravaɨ́reꞌe aꞌɨ́jna tɨ tíhuaꞌuꞌaíjteꞌe ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa. Aꞌɨ́ pu tiraapuaíj. ");
INSERT INTO crnNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tɨ́ꞌɨj jí Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ teɨte tɨjɨ́n: ―¿Aꞌiné een jɨ́n yé sevéꞌejuꞌu? ¿Aꞌiné sej si yé cɨyej tiꞌivéꞌɨꞌɨsin, seajta tepúustiꞌi chuumiraꞌa? ¿Ni qui nahuaꞌari nej púꞌeen sej si siyen tinaatevíꞌira? ");
INSERT INTO crnNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nain tújcaꞌari tzajtaꞌa nu tejáꞌamuamuaꞌatehuaꞌa náꞌayeꞌi aꞌujna teyujtaꞌa. Caxu jaꞌanáj naateeviꞌi aꞌujna, aꞌiné ayée xu neruuren tɨ ij araúrasten aꞌij tɨ yeꞌí téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú huataúruu. Aa mú yaúurɨe naímiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ajta seɨ́j pu raavájrajmeꞌe cujtaꞌan ɨ́ Jesús. Temuaij pu púꞌeen tɨ saavana jɨ́n aꞌiréꞌechejcaꞌa tɨ jetzen aꞌiréꞌecaꞌitɨ́ cúꞌucutzu. Seica ɨ́ teɨte mú raatéeviꞌi aꞌɨ́jna ɨ́ temuaij. ");
INSERT INTO crnNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ajta aꞌɨ́ɨn, aꞌɨ́ɨ pu aꞌiréujchui. A yaúuhuaꞌaxɨ aꞌɨ́jna ɨ́ rucɨɨxu. Aj pu i mú aꞌij huárupi. Aꞌutɨéechejraa muaꞌaviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Matɨ́ꞌɨj mi yaꞌuvíꞌitɨ́ aꞌɨ́jna ɨ́ Jesús aꞌɨ́jna jemi ɨ́ tɨ tíhuaꞌuꞌaíjteꞌe naíjmiꞌica ɨ́ mej tíꞌimɨjhuaca u teyujtaꞌa. Naíjmiꞌi mú tiújseɨj, ɨ́ mej tíꞌimɨjhuaca u teyujtaꞌa, majta ɨ́ mej téꞌeyuꞌuxaca, majta ɨ́ huáꞌavaujsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ajta aꞌɨ́ɨn ɨ́ Pedro, á pu auméꞌecaa aꞌatzu ɨmuá huáꞌacujtaꞌan aꞌɨ́ɨme ɨ́ mej yaꞌuvíꞌitɨ́ ɨ́ Jesús. Aa pu aꞌaráꞌa aꞌu tɨ éꞌeche aꞌɨ́jna tɨ tíhuaꞌuꞌaíjteꞌe ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa. Aꞌuu pu aꞌuteájrupi jáꞌitaꞌa tɨ eꞌeráyaujtaꞌa. Aj pu i aꞌujyeíjxɨ huáꞌa jamuan ɨ́ xantaaruꞌu. A pu aꞌutacái jáꞌaraa. Aꞌujpɨ́steꞌe pu jáꞌaraa ɨ́ taij jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Majta meꞌɨ́n ɨ́ mej tíhuaꞌuꞌaíjteꞌe ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa, majta huaꞌajueesi, aꞌɨ́ɨ mú tíꞌihuaꞌucaꞌa mej mi ráateuni tiꞌitɨ́j ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajteꞌen, tiꞌitɨ́j ɨ́ mej jɨ́n raajéꞌica aꞌɨ́jna ɨ́ Jesús. Camu tiꞌitɨ́j huáteu. ");
INSERT INTO crnNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aꞌii muꞌu huáteu: Mej jeíhua raahuáꞌitacaꞌa ɨ́ teɨte. Mɨ́ ajta, camu ramuaꞌareerecaꞌa ɨ́ seica, majta ɨ́ seica, tiꞌitɨ́j ɨ́ mej xajtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Seica mú huatéhuiixɨ. Huaꞌitzi mú jɨ́n tiuꞌutaxájtacaꞌa aꞌɨ́jna jetze ɨ́ Jesús. Miyen tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ayee tu tiráanamuajriꞌi tɨ ayén tiꞌixa tɨ jɨ́meꞌen yee: “Nee nu raatéꞌuuna aꞌíjna i teyuu teteca mej ráꞌajtaahuacaꞌa. Huaica xɨcaj tzajtaꞌa nu seɨj ájtaahua teyuu mej nuꞌu caí ráꞌajtaahua ɨ́ teteca.” Ayee pu yeehui tiuꞌutaxájtacaꞌa amɨ́jna mɨ Jesús. ―Ayee mú tíꞌixajtacaꞌa meꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mɨ́ ajta meꞌɨ́n, camu ramuaꞌareerecaꞌa ɨ́ seica, majta ɨ́ seica, tiꞌitɨ́j ɨ́ mej xajtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Aj pu i seɨj ájchee huáꞌa tzajtaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ tíhuaꞌuꞌaíjteꞌe naíjmiꞌica ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa. Aj pu i aꞌɨ́ɨn ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Ni pecáj huatániuusin aꞌɨ́jna jɨmeꞌe ɨ́ mej múꞌeetzi jetze tíꞌijpuaꞌajteꞌe? ¿Tiꞌitájni jɨ́n paꞌuteájturaa ɨ́ Dios jemi mej mi miyen tíꞌimuahuaꞌita? ");
INSERT INTO crnNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ajta aꞌɨ́ɨn Jesús, capu tiꞌitɨ́ huataxájtacaꞌa. Áꞌatee aꞌatzu tɨ ayén caí teꞌevéꞌeniuucaꞌa. Aj pu ijta aꞌɨ́ɨn tɨ tíhuaꞌuꞌaíjteꞌe ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa, ajtahuaꞌa pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni múꞌee peꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu, ɨ́ tɨ yaujraꞌan púꞌeen ɨ́ tej rɨ́ꞌɨ tiraatáꞌan iteen? ―Yee pu tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Nee nu neꞌɨ́n púꞌeen. Ajta xu neseij i nej neajta teáataꞌa jetze airáane. An nu eꞌecacaí naꞌame rɨꞌɨríintaꞌa ɨ́ tɨ nain jɨ́n antiújmuaꞌaree. Seajta, múꞌeen xu neseijran netɨ́ꞌɨj aꞌicaaméꞌen jaitɨri tzajtaꞌa. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tɨ́ꞌɨj jí aꞌɨ́ɨn tɨ tíhuaꞌuꞌaíjteꞌe ɨ́ mej tíꞌimɨjhuaca teyujtaꞌa, aꞌɨ́ɨ pu raꞌantisiújtzaꞌan ɨ́ rusiicuꞌu mej mi ráamuaꞌaree tɨjɨ́n aꞌɨ́ɨ pu huataniúꞌucacaꞌa. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Meꞌecui xaa neꞌu. ¿Ni caí neꞌu icu? Capu chéꞌe ruxeꞌeveꞌe tɨ jaꞌatɨ jɨ́meꞌen teꞌanxájta. ");
INSERT INTO crnNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Múꞌeen xu seri ráanamuajriꞌi tɨ aꞌij puaꞌa tiuꞌuxájtacaꞌa ɨ́ Dios jemi. ¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Tiꞌitájni ayén tiraavíjteꞌe? ―Ayee pu tihuaꞌutáꞌixaa. Aj mú mi naíjmiꞌi tiuꞌutáꞌa tɨ huámɨꞌɨni aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Matɨ́ꞌɨj mi seica autéjhuii mej raꞌatétzijmuaꞌaxɨꞌɨn, majta raꞌutanán. Majta ruꞌitévaꞌaraꞌa rumuájcaꞌan jɨmeꞌe. Miyen tɨjɨ́n: ―Huataxáj, ¿aꞌatani muꞌitéjvee? ―Yee mú tiraataꞌixaa. Majta meꞌɨ́n ɨ́ xantaaruꞌu, aꞌɨ́ɨ mú majta ruꞌitéevajxɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ajta aꞌɨ́ɨn Pedro, aꞌɨ́ɨ pu u aꞌutéveecaꞌa aꞌujna jáꞌitaꞌa tɨ eꞌeráyaujtaꞌa u chiꞌita. Aj pu i seɨj aꞌuteájrupi tɨ ravaɨ́reꞌe ɨ́ tɨ tíhuaꞌuꞌaíjteꞌe mej tíꞌimɨjhuaca u teyujtaꞌa. ꞌƗ́itaꞌa pu pɨ́rɨcɨ aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Aꞌɨ́ pu aꞌuteájrupi aꞌu tɨ anúꞌujcatii aꞌɨ́jna ɨ́ Pedro aꞌu tɨ áꞌujpɨsteꞌecaꞌa ɨ́ taij jetze. Tɨ́ꞌɨj aꞌɨ́ɨn raaseíj, áa puꞌu aꞌutéechaxɨ rajseíiraꞌajraa. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Peajtá pej múꞌee áꞌucheꞌecaneꞌe jamuan Jesús tɨ Nazarét éꞌemeꞌecan. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Aj pu i seɨcɨé tiraataxájtacaꞌa aꞌɨ́jna ɨ́ Pedro tɨjɨ́n: ―Canu ramuaꞌate. Canu neajta ramuaꞌaree aꞌij pej yeꞌí tíꞌineꞌixaateꞌe múꞌee. Aj pu i aꞌɨ́ɨn huirájraa. Aa pu aꞌitéechaxɨ á tɨ eꞌiténineꞌi. Aj pu i tecuaaraꞌi huajíjhuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tɨ́ꞌɨj i ajtahuaꞌa aꞌɨ́ɨn ꞌɨ́itaꞌa raaseíj. Aj pu i ayén tihuáꞌitixaa aꞌɨ́mej ɨ́ mej eꞌeréꞌeteꞌecaa aꞌujna. Ayen tɨjɨ́n: ―Amɨ́jna mɨ jaꞌatɨ, aꞌii pu seɨ́j púꞌeen tɨ huáꞌa jetze ajtémeꞌecan ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ajtahuaꞌa seɨcɨé tiraataꞌixaa aꞌɨ́jna ɨ́ Pedro. Aꞌatzu áꞌateeviꞌica matɨ́ꞌɨj eꞌeréꞌeteꞌecaa, majtáhuaꞌa miyen tiraataꞌixaa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, múꞌee pe aꞌɨ́ɨn púꞌeen ɨ́ Galilea pej éꞌemeꞌecan. Ayee pej tíꞌixaxaꞌa matɨ́j aꞌɨ́ɨme ɨ́ mej aꞌuun aꞌuhuachéjme. ―Yee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aj pu i Pedro aꞌutéjche tɨ niuucajtzeꞌen ɨ́ Dios ayén tihuáꞌaꞌixaateꞌen tɨjɨ́n capu ramuaꞌate. Ajta, tɨ puaꞌa nuꞌu caí ayén tiꞌayájnacaꞌa, chéꞌe nuꞌu Dios raatáꞌan ɨ́ puaíjtzi. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu aꞌatzu ramuaꞌate aꞌɨ́jna ɨ́ jaꞌatɨ sej raxa. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj pu i huaꞌapuaca jetze huajíjhuacaꞌa ɨ́ tecuaaraꞌi. Tɨ́ꞌɨj jí Pedro raꞌutámuaꞌareeriꞌi aꞌij tɨ tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: “Tɨ́ caí xɨ huaꞌapuaca jetze huajíjhua ɨ́ tecuaaraꞌi, múꞌee pe huaícacajetze piyen tiraataxáj yee pecáj nemuaꞌate.” Ayee pu tiraatáꞌixaateꞌecaꞌa aꞌɨ́jna. Aj pu i aꞌij puaꞌa raatáꞌa, tiujyeínejraa huápɨꞌɨ aꞌɨ́jna ɨ́ Pedro. ");
INSERT INTO crnNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Yee ruijmuaꞌateꞌe yee, tɨ́ꞌɨj huatapuáꞌare, naíjmiꞌi mú tiújseɨj ɨ́ mej tíhuaꞌuꞌaíjteꞌe u teyujtaꞌa, majta huáꞌavaujsimuaꞌa, majta ɨ́ mej téꞌeyuꞌuxaca, majta ɨ́ seica ɨ́ mej majta iꞌijuéesi. Naíjmiꞌi mú tíꞌiruixaateꞌecaꞌa aꞌij mej yeꞌí huárɨni. Aj mú mi raꞌamuáajɨꞌɨcɨe meꞌɨ́jna ɨ́ Jesús. Meyeꞌujáj. Matɨ́ꞌɨj mi raatátui aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén ántehuaa tɨjɨ́n Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Aj pu i Pilato ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni múꞌee peꞌɨ́n púꞌeen ɨ́ huaꞌatajtuhuan ɨ́ mej Israél jetze ajtémeꞌecan? Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Nee nu neꞌɨ́n púꞌeen aꞌij pej yeꞌí tiꞌixa múꞌee. ―Yee puꞌu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Majta meꞌɨ́n ɨ́ mej tíhuaꞌuꞌaíjteꞌe u teyujtaꞌa, jeíhua mú tiraaxájtziꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ajta aꞌɨ́ɨn Pilato, ajtahuaꞌa pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni pecáj naatáꞌixaateꞌe peꞌɨ́jna jɨmeꞌe? Pepuꞌuri huáꞌunamuajriꞌi mej jeíhua tiꞌimuaxájtziꞌi. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Mɨ́ ajta aꞌɨ́ɨn Jesús, capu tiꞌitɨ́j xajtacaꞌa. Aꞌɨ́j pu jɨ́n, caí aꞌij ráꞌamitɨejteꞌecaꞌa aꞌɨ́jna ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ayee pu tíꞌijrɨꞌɨrejcaꞌa aꞌɨ́jna ɨ́ Pilato matɨ́ꞌɨj meꞌɨ́n tíꞌiyestehuaꞌa. Tɨ́ puaꞌa meraatáhuavii ɨ́ teɨte tɨ aꞌɨ́ɨn raatátuaani seɨj tɨ aiteánamiꞌi, jaꞌatɨ́ tɨ naꞌa ɨ́ mej raatáhuavii, aj pu i raateátuaasin. ");
INSERT INTO crnNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Aꞌájna jáꞌahuaꞌa seica mú aiteánamiꞌihuacaꞌa ɨ́ mej néꞌuseꞌecaꞌa ɨ́ uꞌuviernu jemi. Aꞌii mú huáꞌucuii ɨ́ teɨte. Ajta seɨj aꞌujna aiteánamiꞌihuacaꞌa tɨ ayén ántehuaa tɨjɨ́n Barrabás. ");
INSERT INTO crnNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Aj mú mi eꞌiréꞌene ɨ́ teɨte ɨ́ Pilato jemi. Aꞌɨ́ mú autéjhuii mej raatáhuavii tɨ aꞌɨ́ɨn ayén huárɨni aꞌɨ́mej jemi aꞌij tɨ yeꞌí tíꞌijrɨꞌɨre. ");
INSERT INTO crnNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe múꞌeen? ¿Ni qui neraatátuaani neꞌíjna tɨ áꞌamuatajtuhuan púꞌeen, múꞌeen mɨ sej Israél jetze ajtémeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi aꞌiné aꞌɨ́ɨ pu ráamuaꞌareeriꞌi mej ráꞌachueereꞌecaa ɨ́ Jesús aꞌɨ́ɨme ɨ́ mej tíhuaꞌuꞌaíjteꞌe u teyujtaꞌa. Aꞌɨ́j mú jɨ́n raatátui meꞌɨ́jna ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mɨ́ majta meꞌɨ́n ɨ́ mej tíhuaꞌuꞌaíjteꞌe u teyujtaꞌa, aꞌɨ́ɨ mú raatáꞌa ɨ́ caꞌaníjraꞌa jeíhua ɨ́ teɨte mej mi raatáhuavii aꞌɨ́jna ɨ́ Pilato tɨ aꞌɨ́ɨn huatátuaani aꞌɨ́jna ɨ́ Barrabás jetzen meꞌecan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ajtahuaꞌa ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné náarɨni nemɨ́jna jemi, mɨ tɨ áꞌamuatajtuhuan púꞌeen, mɨ sej Israél jetze ajtémeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aj mú mi caꞌanín jɨ́n huajíjhuacaꞌa. Miyen tɨjɨ́n: ―Patáꞌaj ráꞌutatan cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Aj pu i Pilato ayén tɨjɨ́n: ―¿Aꞌiné een jɨmeꞌe? ¿Tiꞌitájni aꞌij puaꞌa huáruu? Matɨ́ꞌɨj ráanamuajriꞌi, jaítzeꞌe mú caꞌanín jɨ́n huajíjhuacaꞌa. Miyen tɨjɨ́n: ―Aútataichi cúruu jetze. ―Yee muꞌu titeejíjhuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ajta aꞌɨ́ɨn Pilato, aꞌɨ́ɨ pu raxɨ́ꞌeveꞌecaꞌa tɨ rɨ́ꞌɨ tihuaꞌutáꞌan ɨ́ teɨte. Aꞌɨ́j pu jɨ́n raatátuaa aꞌɨ́jna ɨ́ Barrabás. Ajta raataꞌaíjtacaꞌa mej raꞌiréꞌavajxɨꞌɨn aꞌɨ́jna ɨ́ Jesús. Aj pu ijtáꞌi huaꞌutátuii mej mi ráꞌutatan ɨ́ cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Matɨ́ꞌɨj mi meꞌɨ́n xantaaruꞌu yaꞌujáj aꞌájna tɨ teꞌáijta tɨ éꞌeche. Aꞌuu mú yaꞌuteárujte jáꞌitaꞌa tɨ u eꞌeráyaujtaꞌa. Aj mú mi naíjmiꞌica tiseɨ́j ɨ́ seica, xantaaruꞌu. ");
INSERT INTO crnNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Síicuꞌuri mú ruꞌucáachejte tɨ páꞌuviꞌin jɨ́n, raxúꞌumuaviꞌimeꞌecaa. Majta curuun raateátaave tɨ tzicareꞌe jɨmeꞌe cɨstíjhuacaꞌa. Aꞌɨ́j mú raꞌavéꞌerujtiꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Matɨ́ꞌɨj mi autéjhuii mej raatejíivajra, yee cumu rɨ́ꞌɨ mú tiraatáꞌa. Miyen tɨjɨ́n: ―Ayajna neꞌu. Temuaꞌa pu íꞌixɨꞌepɨꞌɨn. Chéꞌe aꞌateeviꞌi tɨ ruuri amɨ́jna tɨ huaꞌatajtuhuan púꞌeen ɨ́ mej Israél jetze ajtémeꞌecan. ―Ayee mú tiráꞌuxɨeehuariꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Majta raꞌavéꞌevajxɨ án muꞌúutzeꞌen itzɨ́j jɨmeꞌe. Majta raꞌatétzijmuaꞌaxɨ. Majta mú títunutaxɨ. Ayee cumu rɨ́ꞌɨ mú tiratáꞌacareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Matɨ́ꞌɨj ráꞌuxɨeehuariꞌiraꞌa, aj mú mi rúꞌijchuiiriꞌi aꞌɨ́jna ɨ́ síicuꞌuri tɨ páꞌuviꞌin jɨ́n, raxúꞌumuaviꞌimeꞌecaa. Matɨ́ꞌɨjtá mi ruꞌucáachejte ɨ́ síicuꞌureꞌaraꞌan. Aj mú mi yaꞌujáj mej mi ráꞌutatan ɨ́ cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Aꞌájna, seɨj pu huaꞌantinájchecaꞌa aꞌujna aꞌu mej yeꞌevéꞌejajsimeꞌe aꞌɨ́jna ɨ́ Jesús. Ayee pu ántehuaa aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n Simón. Aꞌuu pu éꞌemeꞌecan tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Cirene. Aꞌii pu yaꞌupuáaraꞌan aꞌɨ́jna ɨ́ Alejandro, ajtahuaꞌa seɨj ɨ́ Rufo. Aꞌuu pu eꞌerájraa aꞌájna jáꞌahuaꞌa aꞌu tɨ caí jaꞌatɨ́ áꞌa éꞌeche. Tɨ́ꞌɨj aꞌɨ́ɨn Simón huaꞌantinájchecaꞌa, aꞌɨ́ɨ mú huataꞌáij tɨ aꞌɨ́ɨn ráꞌanchueni cúrujraꞌan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aꞌuu mú yaꞌujáj aꞌɨ́jna ɨ́ Jesús, aꞌájna jáꞌahuaꞌa, jɨrí jetze tɨ ayén téjaꞌarájtehuaa huaꞌaniuuca jɨmeꞌe tɨjɨ́n Gólgota. Gólgota, ayée pu huataújmuaꞌa tɨjɨ́n Mɨ́ꞌɨchí naꞌa jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Matɨ́ꞌɨj mi raatanéste tiꞌitɨ́ nahuáj, cuaaneꞌe tɨ ranaxca. Ayee mú ratamuáꞌamua aꞌɨ́jna ɨ́ cuaaneꞌe tɨjɨ́n mirra. Ajta aꞌɨ́ɨn Jesús, capu raꞌantiꞌí aꞌɨ́jna ɨ́ nahuáj. ");
INSERT INTO crnNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Matɨ́ꞌɨj mi rúꞌijchuiiriꞌi ɨ́ síicuꞌureꞌaraꞌan. Majta tiraacáꞌariꞌiriꞌi ɨ́ tíꞌicɨɨxureꞌaraꞌan. Matɨ́ꞌɨjtá mi ráꞌutatai ɨ́ cúruu jetze. Aj mú mi tiꞌihuaújmuaꞌitɨ́ tetej jɨmeꞌe mej mi ráamuaꞌaree jaꞌatɨ́ tɨ racɨꞌɨti ɨ́ cɨ́ɨxureꞌaraꞌan ɨ́ Jesús seɨj ajta seɨj. Ayee mú titeeréꞌujpijte aꞌɨ́jna ɨ́ tíꞌicɨɨxureꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Puꞌuri jáꞌitaꞌa ujméꞌeca ɨ́ xɨca matɨ́ꞌɨj ráꞌutatai ɨ́ cúruu jetze. ");
INSERT INTO crnNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Majta tiꞌitɨ́ taabla aúutatai cúruu japua. Ayee pu téꞌeyuꞌusiꞌihuacaꞌa aꞌɨ́jna jetze ɨ́ taabla ɨ́ mej tiꞌitɨ́j jɨ́n jetzen teꞌujpuáꞌajte tɨjɨ́n: “Huaꞌatajtuhuan ɨ́ mej Israél jetze ajtémeꞌecan.” ");
INSERT INTO crnNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Majta jamuan ɨ́ Jesús, mehuáꞌutátaixɨ cúruu jetze huaꞌapuaca ɨ́ nahuaꞌari mej púꞌeen. Seɨj mú aꞌutéjche ɨ́ cúruu rɨꞌɨríintaꞌa pújmeꞌen, majta seɨj áꞌutataꞌa pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ayee puꞌu éeneꞌecan jɨ́n araúraste aꞌíjna ɨ́ niuucari tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Ayen tɨjɨ́n: “Yee mú yáꞌumuaꞌarejcaꞌa tɨ́j aꞌij puaꞌa tíꞌitevijcaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Majta meꞌɨ́n ɨ́ mej á aꞌatánineicaꞌa, matɨ́ꞌɨj raaseíj, aꞌɨ́ɨ mú aicámuꞌuvajra mej caí ráꞌacuꞌuvejcaꞌa. Ayee mú aꞌij puaꞌa tíꞌixajtacaꞌa tɨjɨ́n: ―¿Ni caí icu, múꞌee pe aꞌɨ́ɨn púꞌeen ɨ́ pej nuꞌu raatéꞌuuna ɨ́ teyuu, pajta nuꞌu huaíca xɨca jetze ráꞌajtaahua? ");
INSERT INTO crnNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ijii múꞌee aseɨ́j á japua huániuuchi pej pi caí huámɨꞌɨni. Acájraꞌa yeehui amɨ́jna jetze mɨ cúruu. ―Ayee mú tiráꞌaxɨeehuastiꞌiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aꞌɨ́ majta ɨ́ mej tíhuaꞌuꞌaíjteꞌe u teyujtaꞌa, majta ɨ́ mej téꞌeyuꞌuxaca, aꞌɨ́ɨ mú naíjmiꞌi ráꞌaxɨeehuastiꞌiracaꞌa. Miyen tíꞌiruixaateꞌecaꞌa rujɨ́ɨmuaꞌa tɨjɨ́n: ―Amɨ́ pu ari huáꞌa japua huaniú ɨ́ seica. Mɨ́ ajta, capu raayɨ́ꞌɨtɨ tɨ ruseɨ́j rujapua huániuuni. ");
INSERT INTO crnNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Amɨ́jna tɨ nuꞌu iꞌi Cɨríistuꞌu tɨ nuꞌu tatajtuhuan i tej Israél jetze ajtémeꞌecan, chéꞌe amɨ́n acájraꞌani amɨ́jna jetze mɨ cúruu tej ti raaseíj, tetáꞌaj téꞌantzaahuateꞌen. ―Ayee mú tíꞌiruixaateꞌecaꞌa. Majta meꞌɨ́n ɨ́ mej jamuan huáꞌutatai ɨ́ cúruu jetze, aꞌɨ́ɨ mú majta ráꞌuxɨeehuastiꞌiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tɨ́ꞌɨj aꞌájna tejaꞌuréꞌene aꞌatzaj tacuarixpua, aj pu i huateátɨcaꞌarecaꞌa nainjapua ɨ́ chuej aꞌuun tɨ huatacáꞌa u Israél. Ajta áꞌatee tɨ ayén huatɨ́caꞌa jáꞌitaꞌa tacuarixpua. ");
INSERT INTO crnNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jɨ́meꞌen puꞌu tejaꞌuréꞌene aꞌájna jáꞌitaꞌa tacuarixpua, aj pu i Jesús caꞌanín jɨ́n huajíjhuacaꞌa runiúucajtzeꞌen. Ayen tɨjɨ́n: ―¿Eloi, eloi, lama sabactani? ―Ayee pu tiuꞌujíjhuacaꞌa. Aꞌíjna i niuucari, ayée pu huataújmuaꞌa tɨjɨ́n: “Niyaꞌupua, ¿aꞌiné een jɨ́n penejaꞌuhuáꞌaxɨ múꞌee, pej níꞌiyaꞌupua?” Ayee pu huataújmuaꞌa aꞌíjna i niuucari. ");
INSERT INTO crnNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Seica ɨ́ mej meꞌuun aꞌutéꞌuucaꞌa meráanamuajriꞌi. Matɨ́ꞌɨj mi miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Xaanamuajriꞌi, aꞌɨ́j pu huatajé aꞌɨ́jna ɨ́ Elías tɨ ajmíꞌi tiꞌitéveecaꞌa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Aj pu i seɨj eꞌiréꞌene rutɨéchijméꞌen. Tiꞌitɨ́j pu autɨ́ɨ tɨ uꞌurájtaꞌati. Aꞌɨ́j pu huateáruꞌune nahuáj jɨmeꞌe tɨ antzíjviꞌi. Tɨ́ꞌɨj jí raꞌantijɨ́ꞌɨcɨꞌe cɨyej jetze. Aj pu i aꞌɨ́ɨn ráꞌajchui tɨ́ꞌij Jesús raꞌantiyéꞌen aꞌɨ́jna jetze ɨ́ tiꞌitɨ́. Tɨ́ꞌɨj ayén huarɨ́j, aj puꞌi ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: ―Xaachúꞌeveꞌe. Tɨ́ puaꞌa yatanéjsin aꞌɨ́jna ɨ́ Elías tɨ ij raꞌacájtuaani. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aj pu i Jesús caꞌanín jɨ́n huajíjhuacaꞌa. Tɨ́ꞌɨj jí huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Aꞌájna teyujtaꞌa, tiꞌitɨ́ pu huatáviviɨjmeꞌeca cɨ́ɨxuri tɨ itzíjhua. Jɨ́meꞌen puꞌu huamɨ́ꞌɨ ɨ́ Jesús, aj pu i jáꞌitaꞌa acásiujtzaꞌan aꞌɨ́jna ɨ́ cɨ́ɨxuri. ");
INSERT INTO crnNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ajta aꞌɨ́ɨn ɨ́ huaꞌacapítan ɨ́ xantaaruꞌu ɨ́ mej anxɨ́te aráꞌase, áa pu aꞌutéveecaꞌa aꞌájna vejliꞌi taꞌavéꞌenee aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́ pu ráanamuajriꞌi aꞌij tɨ yeꞌí tiuꞌujíjhuacaꞌa ɨ́ Jesús. Ajta raaseíj aꞌij tɨ yeꞌí tiuꞌumɨ́ꞌɨ. Aj pu i ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ capitán tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Aꞌii pu aꞌɨ́ɨn púꞌeeneꞌen ɨ́ yaujraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Majta seica, á muꞌu ɨmuá aꞌutéꞌuu mejseíiracaꞌa aꞌɨ́ɨme mej ꞌuuca. Seɨj pu ayén ántehuaacaꞌa tɨjɨ́n María, tɨ Magdala éꞌemeꞌecan. Ajta, seɨj tɨ ajta ayén ántehuaacaꞌa tɨjɨ́n María. Huaꞌanaana aꞌɨ́jna ɨ́ Jacobo tɨ cɨ́lieen, ajta aꞌɨ́jna ɨ́ José. Ajtahuaꞌa seɨj ꞌɨ́itaꞌa huáꞌa jamuan pu aꞌutéveecaꞌa tɨ ayén ántehuaacaꞌa tɨjɨ́n Salomé. ");
INSERT INTO crnNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aꞌii mú áꞌujujhuaꞌaneꞌecaꞌa ɨ́ Jesús jamuan. Majta raatévaɨreꞌecaꞌa tɨ́ꞌɨj aꞌɨ́ɨn aꞌutéveecaꞌa aꞌujna jáꞌahuaꞌa Galilea. Mé muꞌiitɨ́ mú majta aꞌutéꞌuucaꞌa ɨ́ mej jamuan aꞌujnéj aꞌánna Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tɨ́ꞌɨj huateáchumuaꞌarecaꞌa, puꞌuri tejaꞌuréꞌene aꞌɨ́jna xɨcájraꞌa jetze matɨ́ꞌɨj rɨ́ꞌɨ huaújruuren. Yee ruijmuaꞌa yee pu tejaꞌuréꞌenejsin aꞌɨ́jna xɨcájraꞌa mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Aj pu i jaꞌatɨ́ aꞌuréꞌene jemin aꞌɨ́jna ɨ́ Pilato. Ayee pu ántehuaacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n José. Aꞌuu pu jáꞌahuaꞌa éꞌemeꞌecantacaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Arimatea. Aꞌɨ́ pu ajta huáꞌa jetze ajtémeꞌecan aꞌɨ́ɨme ɨ́ mej iꞌijuéesi. Jéꞌecan pu veꞌecán jɨ́n tiꞌitéveecaꞌa aꞌɨ́jna ɨ́ José. Aꞌɨ́ pu ajta rachúꞌeveꞌecaꞌa aꞌɨ́jna xɨcájraꞌa jetze tɨ́ꞌɨj Dios autéjcheni tɨ tiuꞌutaꞌaíjta nainjapua íiyen chaanaca japua. Aꞌɨ́ pu uhuateújcaꞌane ɨ́ ru tzajtaꞌa. Aꞌuu pu a aꞌuteájrupi aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Pilato. Aj pu i rájhuaviiriꞌi tɨ aꞌɨ́ɨn raatáꞌan tɨ raꞌacájtɨni ɨ́ Jesús, tɨ ari mɨ́ꞌɨchi. ");
INSERT INTO crnNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ajta aꞌɨ́ɨn ɨ́ Pilato, jéꞌecan pu aꞌij teꞌutaseíj tɨ Jesús ari huamɨ́ꞌɨ. Aj pu i raatajé ɨ́ huaꞌacapítan ɨ́ mej ráꞌutatai ɨ́ cúruu jetze. Raataꞌíhuaꞌuriꞌi tɨ puaꞌa ayén tiꞌayájnacaꞌa tɨ ari huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Aj puꞌi aꞌɨ́ɨn huaꞌacapítan ayén tiraataꞌixaa tɨ ayén tiꞌayájnacaꞌa. Tɨ́ꞌɨj jí Pilato raatáꞌa aꞌɨ́jna ɨ́ José tɨ aꞌɨ́ɨn raꞌacájtɨni. ");
INSERT INTO crnNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tɨ́ꞌɨj jí áꞌuraa aꞌɨ́jna ɨ́ José tɨ cɨ́ɨxuri áꞌunanan tɨ rɨ́ꞌen, tɨ naa tíꞌicuaina. Aj pu i raꞌacájchuii aꞌɨ́jna ɨ́ mɨ́ꞌɨchi. Tɨ́ꞌɨj jí raꞌiréꞌeꞌijcatacaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ cɨ́ɨxuri. Ajta áꞌiyen aꞌuun yaꞌutéete aꞌujna aꞌu mej ruꞌuréꞌijche u téteꞌe ɨ́ tetej tzajtaꞌa. Ayee pu huarɨ́j, tɨ́ꞌɨj jí tetej aitéjmuaa tɨ sicɨ́ɨraraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Majta meꞌɨ́n ɨ́ ꞌuuca, ɨ́ María tɨ Magdala éꞌemeꞌecan, ajta aꞌɨ́jna María tɨ iꞌináànajraꞌan aꞌɨ́jna ɨ́ José, aꞌɨ́ɨ mú raaseíj aꞌu tɨ yeꞌetéete. ");
INSERT INTO crnNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tɨ́ꞌɨj mú áꞌume aꞌɨ́jna xɨcájraꞌa mé jetzen ruseꞌupi, aꞌɨ́ɨme ɨ́ ꞌuuca, aꞌɨ́jna ɨ́ María tɨ Magdala éꞌemeꞌecan, ajta aꞌɨ́ɨn María tɨ iꞌináànajraꞌan aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́ɨn Salomé, aꞌɨ́ɨ mú tiꞌitɨ́j huánanai tɨ naa teáarɨ́ꞌe, tuꞌupi aꞌaráꞌa. Matɨ́ꞌɨj meꞌɨ́n huánanai, aj mú mi áꞌujuꞌun mej mi raꞌacáameijra aꞌɨ́jna ɨ́ mɨ́ꞌɨchi. ");
INSERT INTO crnNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yee ruijmuaꞌateꞌe yee, tɨ́ꞌɨj auchén eꞌiréꞌeneesimeꞌeca ɨ́ xɨca, aꞌúu mú aꞌaráꞌa aꞌu tɨ eꞌevéꞌenamiꞌihuacaꞌa. Aꞌij pu jetze pɨ́tíꞌirɨcɨ i xɨca taꞌamuájca ɨ́ itɨeeri. ");
INSERT INTO crnNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ayee mú tiúꞌurihuaꞌuracaꞌa tɨjɨ́n: ―¿Aꞌataqui seɨ́jtaꞌa yaꞌanxɨ́ɨra ɨ́ tetej tɨ jɨ́n ujnámiꞌi ɨ́ tɨ úucun tej ti uteárute? ");
INSERT INTO crnNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Matɨ́ꞌɨj mauj ɨmuá eꞌevéꞌejuꞌucaꞌa meraaseíj tɨ puaꞌa aꞌɨ́ɨn tetej caí chéꞌe aitéjmuaa. Temuaꞌa pu tiꞌiveꞌecaa aꞌɨ́jna tɨ aꞌitémuaacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aj mú mi a aꞌuteájrupi aꞌájna tɨ aúucun matɨ́ꞌɨj mi seɨj huaseíj tɨ anúꞌujcatii rɨꞌɨríintaꞌa. Temuaij pu pɨ́rɨcɨ aꞌɨ́jna. Tɨ́tɨꞌɨcan pu teꞌucáviɨjcaa unúꞌujcatii. Naa pu tiꞌicuáinaviꞌi teꞌucáviɨjcaa aꞌɨ́jna ɨ́ temuaij. Matɨ́ꞌɨj mi temuaꞌa jeíhua tiuꞌutátziɨn. ");
INSERT INTO crnNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aj pu i aꞌɨ́ɨn ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu tíꞌitziɨɨneꞌe. Múꞌeen xu yáꞌuhuaunen seꞌɨ́jna ɨ́ Jesús tɨ Nazarét éꞌemeꞌecan, ɨ́ tɨ áꞌutataihuacaꞌa ɨ́ cúruu jetze. Capu yuꞌu jáꞌahuaꞌa. Puꞌuri huatarúj. Casiꞌi. Xaaseíj íiyen mej yaꞌujté. ");
INSERT INTO crnNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sericu, setáꞌaj huaꞌutáꞌixaateꞌen ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, seajta aꞌɨ́jna ɨ́ Pedro. Múꞌeen xu huaꞌutáꞌixaateꞌen yee: “Tɨ́ nuꞌu aꞌɨ́ɨn amuacaí aꞌuméꞌe aꞌame aꞌánna Galilea tɨ́ꞌij huaꞌuchúꞌeveꞌen. Ayen cheꞌatá naꞌa téꞌeme tɨ́j aꞌɨ́ɨn ari tihuaꞌutáꞌixaa mej nuꞌu aꞌuun yéꞌeseijran.” ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ temuaij. ");
INSERT INTO crnNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Majta meꞌɨ́n ɨ́ ꞌuuca, temuaꞌa mú tiúꞌujviveecaꞌa, majta mej aꞌij titéꞌujmuajca. Aj mú mi huiráruáachejraa. Camu majta jaꞌatɨ́ huatáꞌixaa, aꞌiné metíꞌitziɨɨneꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ayee pu tiujuꞌurɨ́j aꞌɨ́jna xɨcájraꞌa jetze ɨ́ taꞌamuájca ɨ́ itɨeeri tɨ́ꞌɨj aꞌɨ́ɨn Jesús huatarúj tɨ tapuáꞌarijmeꞌeca aꞌɨ́jna xɨcaj jetze tɨ amuájca. Amuacaí pu huataseíjre aꞌɨ́jna jemi ɨ́ María tɨ Magdala éꞌemeꞌecan. Aꞌii pu aꞌɨ́ɨn púꞌeeneꞌen ɨ́ mej tzajtaꞌan seijreꞌecaꞌa ɨ́ tiyáaruꞌuse ɨ́ mej aráhuaꞌapua aráꞌaxca tɨ huaꞌutamuári ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ajta aꞌɨ́ɨn María, aꞌɨ́ɨ pu u áꞌume tɨ tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌecaꞌa ɨ́ Jesús, ɨ́ mej ruxɨeemɨjteꞌecaꞌa aꞌɨ́jna jɨmeꞌe tɨ Jesús huamɨ́ꞌɨ. Majta ruyeinecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Majta aꞌɨ́ɨme, matɨ́ꞌɨj ráamuaꞌareeriꞌi tɨ ari nuꞌu aꞌɨ́ɨn María raaseíj aꞌɨ́jna ɨ́ Jesús, camu ráꞌatzaahuateꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tɨ́ꞌɨj jí Jesús ajtahuaꞌa huataseíjre huaꞌapuaca jemi matɨ́ꞌɨj meꞌuun aujúꞌucaa aꞌájna jáꞌahuaꞌa aꞌu tɨ caí áꞌuchajtaꞌa. Capu chéꞌe aꞌɨ́ɨ púꞌeeneꞌen ɨ́ mej amuacaí ramuaꞌajcaa. Mɨ́ ajta, aꞌii pu púꞌeeneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Matɨ́ꞌɨj mi aꞌucɨ́j mej mi huaꞌutáꞌixaateꞌen ɨ́ seica. Camu majta huáꞌantzaahuate aꞌɨ́mej ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tɨ́ꞌɨj ari jaítzeꞌe huachúmuaꞌancaa, matɨ́ꞌɨj huatéteꞌecaꞌa ɨ́ meesa jetze ɨ́ mej tamuáamuataꞌa japuan seɨj aráꞌase, ajtahuaꞌa pu huataseíjre aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj jí huaꞌajtéꞌaxɨ aꞌɨ́jna jɨmeꞌe mej raꞌantánaamua ɨ́ ruxɨ́ejniuꞌuca, ajta aꞌɨ́jna jɨmeꞌe mej caí téꞌatzaahuateꞌecaꞌa. Ajta huaꞌajtéꞌaxɨ aꞌɨ́jna jɨmeꞌe mej caí huáꞌatzaahuateꞌecaꞌa ɨ́ mej raaseíj tɨ́ꞌɨj ari huatarúj. ");
INSERT INTO crnNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Sericu múꞌeen. Seꞌucɨ́jxɨꞌɨn nain japua ɨ́ chaanaca. Setihuaꞌutáꞌixaateꞌe naíjmiꞌica ɨ́ teɨte aꞌíjna i niuucari tɨ jɨ́n huaꞌirátuaasin. ");
INSERT INTO crnNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aꞌatɨ́ tɨ ráꞌatzaahuateꞌe aꞌíjna i niuucari, ajta huámuaɨꞌɨvijhua, Dios pu ruꞌirátuaasin. Mɨ́ ajta, tɨ puaꞌa jaꞌatɨ́ caí ráꞌatzaahuateꞌe ɨ́ niuucari, aꞌɨ́ɨ pu rajpuaíjtzi aꞌame. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee mú tiuꞌuyɨ́ꞌɨtɨhuaꞌa muáꞌajuꞌu ɨ́ mej téꞌatzaahuateꞌe. Neniúucajtzeꞌe mú huaꞌutamuáriteꞌesin ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌe ɨ́ teɨte. Majta tíꞌixaxaꞌataꞌa muáꞌajuꞌu seica jɨmeꞌe ɨ́ niuucari ɨ́ mej caí xɨ raayɨ́ꞌɨtɨ. ");
INSERT INTO crnNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Cuꞌucuꞌuse mú muarɨꞌen ɨ́ mej tiúꞌucheꞌeveca ɨ́ rumuájcaꞌa jɨmeꞌe; meꞌɨ́n cuꞌucuꞌuse camu aꞌij huáꞌaruuren. Naꞌari tɨ puaꞌa huáꞌaveꞌeri muaꞌantiyéꞌen, capu ajta aꞌij huáꞌaruuren. Ajta tɨ puaꞌa meꞌɨ́n huaꞌajtamuárɨꞌen aꞌɨ́mej mej tíꞌicucuiꞌi, majta mú rujni. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jɨ́meꞌen puꞌu ayén tihuaꞌutáꞌixaa ɨ́ tavástaraꞌa, aꞌɨ́jna ɨ́ Jesús, aj pu i Dios yaꞌuvíꞌitɨ u ta japua. An pu aꞌujyeíjxɨ rɨꞌɨríintaꞌa aꞌɨ́jna ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌecaꞌa, matɨ́ꞌɨj mi aꞌucɨ́jxɨ nain japua ɨ́ chaanaca. Metihuáꞌaꞌixaa nain jɨmeꞌe ɨ́ niuucari tɨ jɨ́n Dios huaꞌirátuaasin. Ajta aꞌɨ́ɨn ɨ́ tavástaraꞌa, aꞌɨ́ɨ pu huaꞌatévaꞌɨrihuaꞌa. Ayee puꞌu aꞌɨ́ɨn huaꞌatáꞌacareꞌe mej jaítzeꞌe raayɨ́ꞌɨtɨhuaꞌan caí méèj jaꞌatɨ́. Aꞌɨ́j mú jɨ́n ráamuaꞌareeriꞌi ɨ́ teɨte tɨ ayén tiꞌayájnacaꞌa aꞌij mej yeꞌí tíꞌixajtacaꞌa meꞌɨ́jna ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌecaꞌa. Ayee pu upuáꞌaracaꞌa ɨ́ yuꞌuxari tɨ ayén ántehuaa tɨjɨ́n Marcos.");
INSERT INTO crnNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Muꞌiitɨ́ mú meri meꞌɨ́jna jɨ́n autéjhuii mej ráꞌusiɨɨmuaꞌan temuaꞌa naa tiꞌitɨ́j tɨ aꞌij huarɨ́j itejmi jemi, mej mi miyen titaatáꞌixaateꞌen aꞌij tɨ éeneꞌe jáꞌaraa. Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej rujɨ́ꞌɨ jɨ́n raaseíj, aꞌii mú majta meꞌɨ́n púꞌeen ɨ́ mej tiuꞌutévaɨ mej huaꞌutáꞌixaateꞌen ɨ́ teɨte ɨ́ niuucari tɨ Dios jemi éꞌemeꞌecan. Aꞌɨ́ɨ mú majta meꞌuun aꞌutéꞌuucaꞌa tɨ́ꞌɨj huataseíjre aꞌɨ́jna ɨ́ Jesús tɨ́j naꞌa yú tɨ eꞌiréꞌene. ");
INSERT INTO crnNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Aꞌɨ́ɨ mú majta raateájtuaa itejmi jemi meꞌɨ́jna ɨ́ niuucari. Mɨ́ neajta inee, aꞌiné nuꞌuri áꞌatee nej niyen tíꞌinemuaꞌate temuaꞌa naa neꞌɨ́jna jɨmeꞌe, ayée pu tináꞌamitɨejteꞌecaꞌa ineetzi tɨ íꞌixɨꞌepɨꞌɨn nej timuaataꞌítiꞌi yuꞌuxari jetze naíjmiꞌi tɨ́j naꞌa tiꞌitɨ́j tɨ aꞌij huarɨ́j pej pi ráamuaꞌaree, múꞌee Teófilo, mɨ pej veꞌecán jɨ́n tiꞌitéjvee, pej pi piyen tiráamuaꞌaree tɨ ayén tiꞌayajna aꞌij mej meri timuaatáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Tɨ́ꞌɨj aꞌɨ́ɨn Heródes auj tiꞌitéveecaꞌa rey jɨmeꞌe tɨ́j naꞌa aꞌuun tɨ huatacáꞌa u Judea, áa pu jáꞌahuaꞌa eꞌechéjmeꞌe seɨ́j tɨ tíꞌivaɨreꞌe teyujtaꞌa. Ayee pu ántehuaacaꞌa tɨjɨ́n Zacarías. Aꞌɨ́mej jetze pu ajtémeꞌecan Abiatar mej jetzen huanéj. Ajta aꞌɨ́ɨn ɨ́raꞌaraꞌan, ayée pu ántehuaacaꞌa tɨjɨ́n Elizabét. Ajta, aꞌɨ́ɨn, aꞌɨ́mej jetze pu ajtémeꞌecan Aaron mej jetzen huanéj. ");
INSERT INTO crnNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rɨ́ꞌɨ mú tíꞌiteteɨtestacaꞌa ɨ́ Dios jemi aꞌɨ́ɨme ɨ́ mej huaꞌapua. Nain mú jɨ́n teꞌaraúraste ɨ́ tɨ tiuꞌutaꞌaíjtacaꞌa ɨ́ tavástaraꞌa, ajta ɨ́ tɨ jɨ́n tihuaꞌíjca. Capu tiꞌitɨ́j aꞌij huáꞌaturaateꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mɨ́ majta, camu seɨ́j tiyáujcaꞌa aꞌiné capu chéꞌe rɨꞌɨríistacaꞌa tɨ Elizabét tiyaúj áꞌaraꞌani, aꞌiné muꞌuri jeíhua váujsicɨraꞌicaa aꞌɨ́ɨme ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ayee puꞌu jaꞌanáj tiráaruu aꞌɨ́jna tɨ́ꞌɨj auj veꞌecán jɨ́n tíꞌivaɨreꞌecaꞌa ɨ́ Dios jemi aꞌɨ́jna ɨ́ Zacarías, tɨ́ꞌɨj raacɨ́ꞌɨ tɨ tiuꞌutévaɨreꞌen u teyujtaꞌa seica jamuan mej tiraatámuaɨꞌɨvejteꞌen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Matɨ́ꞌɨj mi raꞌantíhuaꞌu meꞌɨ́jna ɨ́ Zacarías tɨ ij aꞌɨ́ɨn uteárute u teyujtaꞌa tɨ́ꞌij aꞌuun cuaaneꞌe huátaira ɨ́ tavástaraꞌa jemi aꞌij mej tíꞌijrɨꞌɨrejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tɨ́ꞌɨj ari tejaꞌuréꞌene aꞌatzaj mej puaꞌa ratáꞌiraca ɨ́ cuaaneꞌe, áa mú eꞌetiúꞌuucaꞌa ɨ́ teɨte á puaꞌacɨé, meténiuusimeꞌe ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Aj pu i seɨ́j huataseíjre ɨ́ Zacarías jemi tɨ́ꞌɨj aꞌuun teyujtaꞌa unúꞌujveecaꞌa. Aꞌuu pu rɨꞌɨríintaꞌa pújmeꞌen aꞌutéveecaꞌa aꞌɨ́jna jetze mej japuan ratáꞌiraca ɨ́ cuaaneꞌe aꞌɨ́jna ɨ́ tevi tɨ huataseíjre ɨ́ Zacarías jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tɨ́ꞌɨj raaseíj, temuaꞌa pu tiuꞌutátziɨn aꞌɨ́jna ɨ́ Zacarías. Jéꞌecan pu rátziɨɨneꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ajta aꞌɨ́ɨn tɨ huataseíjre, aꞌúu pu ta japua tíꞌivaɨreꞌecaꞌa ɨ́ tavástaraꞌa jemi. Aj puꞌi ayén tiraataꞌixaa tɨjɨ́n: ―Zacarías, capej tíꞌitziɨɨneꞌe. Dios pu ráanamuajriꞌi aꞌij pej tiuꞌutéjniuu ɨ́ jemin. Ayee pu hui téꞌeme íjii, mɨ sej naíjmiꞌi, aꞌɨ́jna ɨ́ Elizabét, aꞌɨ́ɨ pu tiyaúj aꞌame múꞌeetzi jemi. Ayee pu nuꞌu ruxeꞌeveꞌe pej nuꞌu piyen tiraatámuaꞌati tɨjɨ́n Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","’Jéꞌecan rɨ́ꞌɨ timuaatáꞌasin, pajta huatáꞌatemuaꞌaveꞌesin peꞌɨ́jna jɨmeꞌe ɨ́ paꞌarɨꞌɨ. Majta ɨ́ teɨte, jeíhua mú huataújtemuaꞌaveꞌesin meꞌɨ́jna jɨmeꞌe tɨ́ꞌɨj huanúꞌihuan ɨ́ paꞌarɨꞌɨ, aꞌiné veꞌecán pu jɨ́n tiꞌitevée aꞌame ɨ́ tavástaraꞌa jemi. Chéꞌe nuꞌu caí nahuáj yeꞌe nusu tejuin. Tɨ́ꞌɨj hui huanúꞌihuan tɨ yú aucaꞌitɨ́ aꞌame, aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu jetzen ruꞌutéꞌaa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ayee pu caꞌaníjraꞌa huaꞌutáꞌasin muꞌiicáca aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan mej mi majtáhuaꞌa raataxɨ́ꞌeveꞌen ɨ́ ruvástaraꞌa ɨ́ Dios ɨ́ mej mejmíꞌi mé rúurɨe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","’Aꞌɨ́ɨ pu hui amuacaí huaméꞌe aꞌame caí ɨ́ tavástaraꞌa. Ayee pu cheꞌatá naꞌa aꞌɨ́jna jetze pu araujcaꞌanée aꞌame ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios tɨ́j aꞌɨ́ɨn teꞌaraújcaꞌanejcaꞌa ɨ́ Elías aꞌɨ́jna tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ajta ayée pu cheꞌatá naꞌa teꞌentiújmuaꞌaréere aꞌame tɨ́j teꞌentiújmuaꞌareerecaꞌa ɨ́ Elías. Aꞌɨ́ɨ pu rɨ́ꞌɨ huáꞌaruuren aꞌɨ́mej ɨ́ mej huáꞌavaujsimuaꞌa púꞌeen ɨ́ tɨꞌɨríi mej mi majtáhuaꞌa huaꞌutaxɨ́ꞌeveꞌen ɨ́ ruyaujmuaꞌa. Majta aꞌɨ́ɨme ɨ́ mej caí huáꞌatzaahuateꞌe ɨ́ ruvaújsimuaꞌa, aꞌɨ́ɨ pu rɨ́ꞌɨ huáꞌaruuren mej mi miyen rɨ́ꞌɨ mé titeumuámuaꞌaree muáꞌaraꞌani matɨ́j aꞌɨ́ɨme ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte. Ayee pu huárɨni tɨ́ꞌij rɨ́ꞌɨ huáꞌuruuren ɨ́ teɨte mej mi raꞌancuréꞌeviꞌitɨn ɨ́ tavástaraꞌa. ―Ayee puꞌu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aj pu i Zacarías ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna tɨ jemin huataseíjre tɨjɨ́n: ―Aꞌiné yeꞌí tíꞌirɨꞌɨri nej ráamuaꞌaree tɨ puaꞌa ayén tiꞌayajna nusu caí, aꞌiné nuꞌuri vástacɨraꞌi inee. Ajta, aꞌɨ́ɨn tɨ nee jamuan, puꞌuri ajta ucarij. ");
INSERT INTO crnNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Aj pu i aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe ɨ́ tavástaraꞌa jemi, ayée pu tiraataꞌixaa tɨjɨ́n: ―Ayee nu ántehuaa inee tɨjɨ́n Gabriel. Aꞌuu nu aꞌutéjvee Dios tɨ éꞌeseijreꞌe. Aꞌɨ́ɨ pu nejaꞌutaꞌítecaꞌa nej yetanén, nej ni timuáꞌixaateꞌen neꞌíjna jɨmeꞌe ɨ́ niuucari ɨ́ pej jɨ́n huatáꞌatemuaꞌaveꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","’Tɨ́j íjii, ɨ́ pej caí téꞌantzaahua aꞌij nej timuaatáꞌixaa, capej chéꞌe ataniúuveꞌe puaꞌamé. Ni capu chéꞌe rɨꞌɨríista aꞌame pej tiuꞌutaxáj tɨ yú aucaꞌitɨ́ aꞌame ajta naꞌa caí huanúꞌihuan ɨ́ paꞌarɨꞌɨ. Aj pu araúrastejsin aꞌij nej timuaatáꞌixaa. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Gabriel. ");
INSERT INTO crnNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Majta meꞌɨ́n ɨ́ teɨte, méjchuꞌeveꞌecaꞌa meꞌɨ́jna ɨ́ Zacarías aꞌatzaj tɨ huiráame u teyujtaꞌa. Ayee mú tíꞌiruꞌihuaꞌuracaꞌa aꞌiquí ꞌeen jɨ́n ari áꞌatee tɨ mú anúꞌujvee. ");
INSERT INTO crnNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tɨꞌɨj jí xaa huirájraa. Tɨ́ꞌɨj huirájraa, capu chéꞌe rɨꞌɨríistacaꞌa tɨ tiuꞌutaxáj. Ayee puꞌu rumuájcaꞌa jɨ́n tihuáꞌaꞌixaateꞌecaꞌa aꞌiné capu chéꞌe rɨꞌɨríistacaꞌa tɨ huatániuni. Aꞌɨ́j mú jɨ́n ráamuaꞌareeriꞌi tɨ tiꞌitɨ́j huataseíjre ɨ́ jemin u teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tɨ́ꞌɨj raꞌantipuáꞌajte tɨ raacɨ́ꞌɨ tɨ tiuꞌutévaɨreꞌen u teyujtaꞌa, tɨꞌɨquí áꞌuraa ɨ́ ruche. ");
INSERT INTO crnNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tɨꞌɨj jí autájucatacaꞌa aꞌɨ́jna ɨ́ ɨ́raꞌaraꞌan ɨ́ Elizabét. Aj pu i huateúravaatacaꞌa aꞌujna u ruche. Ayee pu áꞌatee tɨ caí huiráayeꞌicaa ɨ́ ruchiꞌitá aꞌachú cumu anxɨ́j máxcɨraꞌi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ayee pu tíꞌimuaꞌajca tɨjɨ́n: ―Tavastaraꞌa pu hui ayén náaruu ineetzi. Puꞌuri ayén tiraꞌaránajchecaꞌa ayén náaruuren nej ni caí chéꞌe tíꞌiteviꞌiraꞌa ɨ́ teɨte jemi neꞌɨ́jna jɨmeꞌe nej caí tiyaúj náꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Tɨ́ꞌɨjta tejauuméꞌeca arájsevi máxcɨraꞌi, Dios pu raataꞌítecaꞌa aꞌɨ́jna ɨ́ Gabriel tɨ u aꞌatanén aꞌujna Nazarét, chajtaꞌa tɨ jetzen ajtémeꞌecan aꞌúu tɨ huatacáꞌa Galilea. ");
INSERT INTO crnNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Raataꞌítecaꞌa tɨ u aꞌatanén áa tɨ éꞌeche aꞌɨ́jna ɨ́ María ɨ́ tɨ ari tɨ́muaꞌa huatévicheꞌesin aꞌɨ́jna jamuan ɨ́ José, aꞌɨ́j tɨ jetzen huanéj ɨ́ David teecan. Capu xɨ jaꞌatɨ jamuan huáhuii aꞌɨ́jna ɨ́ María. ");
INSERT INTO crnNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tɨꞌɨj jí aꞌuun aꞌuteájrupi aꞌu tɨ éꞌeche. Aj pu i aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe ɨ́ tavástaraꞌa jemi, ayée pu tiraatateújte tɨjɨ́n: ―Ajaꞌɨmɨ́, María, mɨ pej Dios jemi teꞌancuréꞌasin. Tavástaraꞌa pu á jemi huatéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jéꞌecan pu utéevatzɨ ɨ́ tzajtaꞌan tɨ́ꞌɨj ayén tiraataꞌixaa. Jéihua pu tíꞌimuaꞌajca aꞌiquí huataújmuaꞌa ɨ́ niuucari tɨ raataxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tɨꞌɨj jí ayén tiraataꞌixaa aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: ―Capej tíꞌitziɨɨneꞌe, María. Múꞌee pe rɨ́ꞌɨ raatáꞌa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Múꞌee pe aꞌutájucata. Múꞌee pe tiyaúj puaꞌamé, teáatacan. Ayee pej raatámuaꞌati tɨjɨ́n Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ajta, aꞌɨ́ɨ pu veꞌecán jɨ́n tiꞌitevée aꞌame. Ayee mú hui majta raatamuáꞌamuateꞌe muáꞌajuꞌun tɨjɨ́n Yaujraꞌan ɨ́ Dios tɨ nain jɨ́n antiújmuaꞌaree. Ajta, Dios tɨ taꞌivástaraꞌa, aꞌɨ́ɨ pu raatáꞌasin tɨ teꞌenteárute aꞌɨ́jna jɨmeꞌe tɨ David teecan jɨ́n tiꞌitéveecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ajta aꞌɨ́ɨn pu tíhuaꞌutaꞌaíjteꞌesin tɨ́j naꞌa rusén jɨmeꞌe aꞌɨ́mej jemi ɨ́ mej Jacobo jetze huanéj. Ajta capu jaꞌanáj íraꞌantipuáꞌari tɨ aꞌɨ́ɨn tihuaíteꞌe aꞌame. ―Ayee puꞌu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tɨꞌɨj jí ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ María tɨjɨ́n: ―Aꞌiné tíꞌirɨꞌɨri tɨ ayén tejaꞌuréꞌenen aꞌiné canu jaꞌanáj teáataꞌa jamuan huáhuii. ");
INSERT INTO crnNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe ɨ́ ta japua, ayée pu tiraataꞌixaa tɨjɨ́n: ―Aꞌɨ́n xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu á jetze rávaɨjtzi. Ajta aꞌɨ́jna jɨmeꞌe tɨ muaacánajsin, aꞌɨ́j pu jɨ́n, aꞌɨ́jna ɨ́ paꞌarɨꞌɨ tɨ nuꞌihuan, tavástaraꞌa pu huateúraꞌateꞌesin. Ayee mú majta raatamuáꞌamuateꞌe muáꞌajuꞌun tɨjɨ́n Yaujraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","’Ajta aꞌɨ́ɨn aꞌihuáaraꞌa, aꞌɨ́jna ɨ́ Elizabét, aꞌɨ́ɨ pu hui tiyaúj aꞌame tɨ́j ajta ari ucarij. Ayee pu tiuꞌutaxájtacaꞌa tɨjɨ́n yee tɨ caí chéꞌe rɨꞌɨrí tiyaúj áꞌaraꞌani. Mɨ́ ajta, puꞌuri áꞌatee arájsevi máxcɨraꞌi tɨ autájuca. ");
INSERT INTO crnNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","’Ayee puꞌu, aꞌiné nain pu tíꞌirɨꞌɨri ɨ́ Dios jemi. Capu méꞌe éꞌe tiꞌitɨ́j tɨ muárɨꞌeri ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tɨꞌɨj jí María ayée tiuꞌutaniú tɨjɨ́n: ―Nain nu jɨ́n tiraatévaɨreꞌesin ɨ́ nevástaraꞌa. Chéꞌe ayén tejaꞌuréꞌene aꞌij pej peri tinaatáꞌixaa. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ María. Tɨꞌɨj jí áꞌuraa aꞌɨ́jna ɨ́ tɨ tíꞌivaɨreꞌe ɨ́ ta japua. ");
INSERT INTO crnNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Aꞌájnáꞌɨmua, caꞌanacan pu áꞌume ɨ́ María jáꞌahuaꞌa chajtaꞌa jetze jɨrí tɨ eꞌevéꞌeca aꞌúu tɨ huatacáꞌa u Judea. ");
INSERT INTO crnNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tɨꞌɨj jí aꞌuun aꞌaráꞌa aꞌu tɨ éꞌeche aꞌɨ́jna ɨ́ Zacarías. Tɨ́ꞌɨj jí aꞌuteájrupi u chiꞌita, aj pu i raatateújte aꞌɨ́jna ɨ́ Elizabét. ");
INSERT INTO crnNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ajta aꞌɨ́ɨn ɨ́ Elizabét, tɨ́ꞌɨj ráanamuajriꞌi tɨ raatateújte ɨ́ María, tɨꞌɨquí huataújruureajxɨ ɨ́ paꞌarɨꞌɨ ɨ́ jucaatzeꞌen. Tɨꞌɨj jí aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, jemin pu huateájturaa ɨ́ Elizabét jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tɨ́ꞌɨj ayén huarɨ́j, Elizabét pu aꞌujcaꞌanéecan jɨ́n raatáꞌixaa aꞌɨ́jna ɨ́ María. Ayen tɨjɨ́n: ―Dios pu rɨ́ꞌɨ timuaatáꞌa múꞌeetzi mecaí ɨ́ seica ɨ́ ꞌuuca. Ajta pu rɨ́ꞌɨ tiraatáꞌa ɨ́ paꞌarɨꞌɨ tɨ arájca ɨ́ muáꞌajucaatzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","’¿Aꞌiné tɨ i Dios ayén rɨ́ꞌɨ tinaatáꞌa tɨ ayén mú aꞌuvéꞌemej neetzi jemi ɨ́ náànajraꞌan ɨ́ nevástaraꞌa? ");
INSERT INTO crnNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jɨ́meꞌen nuꞌu ráanamuajriꞌi pej naatateújte, aj pu i huataújruureajxɨ ɨ́ paꞌarɨꞌɨ tɨ arájca ɨ́ nejucáatzeꞌe. Aꞌɨ́ɨ pu huataújtemuaꞌave. ");
INSERT INTO crnNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","’Rɨ́ꞌɨ pu timuaatáꞌa aꞌiné múꞌee pe ráꞌatzaahuateꞌe tɨ ayén araúrasten aꞌij tɨ tavástaraꞌa timuaatáꞌixaa. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Elizabét. ");
INSERT INTO crnNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ajta aꞌɨ́ɨn ɨ́ María, ayée pu tiuꞌutaniú tɨjɨ́n: Jéꞌecan pu rɨ́ꞌɨ tinaateájtuaa ɨ́ ne tzajtaꞌa ɨ́ nevástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Ajta nexɨ́ejniuꞌuca pu rutémuaꞌaveꞌe ɨ́ Dios jemi tɨ nuꞌirájtuaa aꞌiné aꞌɨ́ɨ pu ramuaꞌareerecaꞌa ɨ́ nej caí aꞌij tíꞌijviicuaꞌi, inee i nej ravaɨreꞌe. Ijii tɨ yú aucaꞌitɨ́ aꞌame, naíjmiꞌi ɨ́ mej teemua, ayée mú tiuꞌutaxájta neetzi jɨmeꞌe yee Dios pu rɨ́ꞌɨ tinaatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ayee mú tiꞌixáata muáꞌajuꞌu meꞌɨ́jna jɨmeꞌe tɨjɨ́n puꞌuri Dios jeíhua ayén tiꞌitɨ́j jɨ́n náaruu tɨ iꞌirɨ́ꞌen aꞌɨ́jna jɨmeꞌe ɨ́ tɨ raayɨ́ꞌɨtɨ ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe. Chéꞌe rɨ́ꞌɨ méꞌe tejjuáꞌa áꞌaraꞌani ɨ́ tɨ jɨ́n ántehuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aꞌɨ́ɨ pu huáꞌacuꞌuve naíjmiꞌica ɨ́ teɨte aꞌachú mej caj puaꞌamé ɨ́ mej ráꞌaste. Tɨ́j menaꞌa mej amuacaí huataseíjre, tɨ yú aucaꞌitɨ́ aꞌame, aꞌɨ́ɨ pu huáꞌancuꞌuvajxɨꞌɨsin. ");
INSERT INTO crnNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Veꞌecán pu jɨ́n tiuꞌumuárɨej ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe. Aꞌɨ́ɨ pu huaꞌantimuáꞌitɨ aꞌɨ́mej ɨ́ mej áꞌujtzaahuateꞌe ɨ́ rutevij jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ajta aꞌɨ́ɨme ɨ́ mej tíꞌaijta, aꞌɨ́ɨ pu huáꞌariꞌiriꞌi ɨ́ mej jɨ́n títetatéꞌecaꞌa. Mɨ́ majta aꞌɨ́ɨme ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, aꞌɨ́ɨ pu tihuaꞌanteárujte veꞌecán jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ajta aꞌɨ́ɨme ɨ́ mej tɨejcucaꞌa, aꞌɨ́ɨ pu rɨ́ꞌɨ tihuaꞌutáꞌa tiꞌitɨ́j jɨmeꞌe tɨ rɨ́ꞌen. Majta aꞌɨ́ɨme ɨ́ mej chíjteaani púꞌeen, aꞌɨ́ɨ pu huaꞌutaꞌítecaꞌa mej áꞌucɨɨne mecaí tiꞌitɨ́j anúꞌaꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Aꞌɨ́ɨ pu huaꞌutévaɨ aꞌɨ́mej ɨ́ mej Israél jetze éꞌemeꞌecan, aꞌɨ́ɨme ɨ́ mej ravaɨreꞌe. Aꞌɨ́ɨ pu raꞌutámuaꞌareeriꞌi ɨ́ tɨ jɨ́n teꞌataújratziiriꞌi nuꞌu huáꞌancuꞌuvajxɨꞌɨn tɨ́j naꞌa rusén jɨmeꞌe aꞌɨ́mej ɨ́ mej Abraham jetze airáane. ");
INSERT INTO crnNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ayee pu tiujuꞌurɨ́j aꞌij tɨ ajmíꞌi tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ tavaújsimuaꞌa teecan. Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ María. ");
INSERT INTO crnNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ajta, aꞌɨ́ɨn ɨ́ María, aꞌúu pu á aꞌuteájturaa aꞌachú cumu huaíca máxcɨraꞌi jamuan ɨ́ Elizabét. Tɨꞌɨj jí áꞌuraa ɨ́ ruche. ");
INSERT INTO crnNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tɨ́ꞌɨjta tejaꞌuréꞌene tɨ tiyaúj áꞌaraꞌani ɨ́ Elizabét, teáatacan pu tiyaúj jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Majta ɨ́ teɨte ɨ́ mej vejliꞌi antachéejmeꞌecaa, majta ihuáamuaꞌameꞌen ɨ́ paꞌarɨꞌɨ vaújsimuaꞌa, aꞌɨ́ɨ mú curéꞌecɨjxɨ matɨ́ꞌɨj ráamuaꞌareeriꞌi tɨ ráꞌancuꞌuvajxɨ ɨ́ tavástaraꞌa. Aj mú mi huataújtemuaꞌave ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Tɨ́ꞌɨj tejauuméꞌeca aráhuaica xɨca jetze tɨ huanúꞌihuacaꞌa, aꞌɨ́ɨ mú áꞌujuꞌun mej mi raꞌantisíjche ɨ́ naviiraꞌan ɨ́ paꞌarɨꞌɨ. Majta, ayée mú raatamuáꞌamuacujcaꞌa tɨ́j ántehuaacaꞌa ɨ́ táàtajraꞌan ɨ́ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ajta aꞌɨ́ɨn náànajraꞌan, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Capu ayén ántehuaa aꞌame tɨjɨ́n Zacarías, ayée puꞌu ántehuaa aꞌame tɨjɨ́n Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Aꞌiné tɨ i. Capu méꞌe jaꞌatɨ tɨ ayén ántehuaa tɨ ajtémeꞌecan múꞌejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Matɨ́ꞌɨj mi rumuájcaꞌa jɨ́n raataꞌíhuaꞌuriꞌi ɨ́ táàtajraꞌan mej mi ráamuaꞌaree aꞌij tɨ yeꞌí tíꞌijxeꞌeveꞌe tɨ ayén ántehuaa áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ajta aꞌɨ́ɨn táàtajraꞌan, aꞌɨ́ɨ pu tiꞌitɨ́j taabla huaꞌutáhuaviiriꞌi tɨ jetzen raꞌuyúꞌuxan aꞌij tɨ ántehuaa aꞌame. Aj pu i ayén tiraꞌutéyuꞌuxacaꞌa tɨjɨ́n: “Ayee pu ántehuaa tɨjɨ́n Juan.” Jéꞌecan mú naa rɨ́ꞌɨ tiraꞌutaseíj ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jɨ́meꞌen puꞌu ayén tiraꞌutéyuꞌuxacaꞌa, aj pu i huatárɨꞌɨristarecaꞌa tɨ tiuꞌutaxáj. Tɨ́ꞌɨj i aꞌutéjche tɨ huatéjniuuni ɨ́ Dios jemi; rɨ́ꞌɨ pu tiraatáꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tɨ́ꞌɨj ayén tiujuꞌurɨ́j, jéꞌecan pu utéevatzɨ ɨ́ huáꞌa tzajtaꞌa aꞌɨ́mej ɨ́ mej á vejliꞌi antachéejmee. Ajta nainjapua aꞌuun tɨ jɨrí aꞌucaíjmee, Judea tɨ jetzen ajtémeꞌecan, jeíhua mú tíꞌiruꞌixaateꞌecaꞌa aꞌij tɨ tiꞌitɨ́ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jaꞌatɨ tɨ naꞌa tɨ ráamuaꞌareeriꞌi, ayée pu tíꞌihuaꞌucaꞌa tɨjɨ́n: ―¿Tiꞌitaqui puꞌéeneꞌe aꞌame aꞌɨ́jna ɨ́ paꞌarɨꞌɨ? Ayee mú tíꞌihuaꞌucaꞌa, aꞌiné tavástaraꞌa pu ravaɨreꞌecaꞌa ɨ́ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ajta aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, Zacarías pu jemin huateájturaa, ɨ́ tɨ táàtajraꞌan púꞌeen ɨ́ paꞌarɨꞌɨ. Tɨꞌɨj jí ayén tiuꞌutaxájtacaꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ayen tɨjɨ́n: Micheꞌe rɨ́ꞌɨ tiraatáꞌan ɨ́ tavástaraꞌa, ɨ́ huáꞌa Dios aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, aꞌɨ́jna jɨmeꞌe tɨ ari huataseíjre, ajta ari huaꞌirájtuaa ɨ́ ruteɨ́testemuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Aꞌɨ́ɨ pu hui seɨ́j teꞌenteárute, seɨ́j tɨ huáꞌa jetze ajtémeꞌecan ɨ́ teɨtestemuaꞌameꞌen ɨ́ David teecan. Aꞌɨ́ɨ pu tuꞌirátuaasin itejmi ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ayee pu Dios ajmíꞌi teꞌataújratziiriꞌi. Ayee mú tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, aꞌɨ́ɨme ɨ́ tɨ Dios huateúraꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ayee pu hui huarɨ́j tɨ ij tuꞌirájtuaani, mej mi caí taamuáꞌitɨn aꞌɨ́mej ɨ́ mej tájchaꞌɨɨreꞌe, naíjmiꞌi aꞌachú mej puaꞌamé ɨ́ mej caí taseíjracu. ");
INSERT INTO crnNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ayee pu ajta huarɨ́j tɨ ij huaꞌacuꞌuvée ɨ́ tavaújsimuaꞌa teecan, ajta tɨ ij raꞌutámuaꞌaree ɨ́ niuucari tɨ huaꞌutáꞌa tzáahuatiꞌiraꞌa jɨmeꞌe, tɨ méꞌe jauuꞌáꞌa ɨ́ tɨ jɨ́n tiꞌihuaúrijca. ");
INSERT INTO crnNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Ayee pu teꞌataújratziiriꞌi tzáahuatiꞌiraꞌa jɨmeꞌe aꞌɨ́jna jemi ɨ́ tayáꞌupuacɨꞌɨ, aꞌɨ́jna ɨ́ Abraham teecan, tɨ ij tuꞌirájtuaani aꞌɨ́mej jemi ɨ́ mej tájchaꞌɨɨreꞌe, mej mi caí taꞌantipuáꞌajteꞌen, tej tij raatévaɨreꞌen tej caí tíꞌitziɨɨneꞌe, tej ti tiyen urarɨ́ꞌeneꞌe táꞌaraꞌani ɨ́ tatzajtaꞌa, tetáꞌaj tiyen xɨ́ꞌepɨꞌɨn rɨjcaa ɨ́ Dios jemi nain xɨcaj tzajtaꞌa, aꞌachú tej puaꞌa áꞌateeri. ");
INSERT INTO crnNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pajta múꞌee niyauj, ayée mú muaatámuaꞌatzi tɨjɨ́n Tɨ́ tíꞌixaxaꞌa aꞌɨ́jna jetze meꞌecan ɨ́ tɨ nain jɨ́n antiújmuaꞌaree. Aꞌiné múꞌee pe amuacaí huaméꞌe puaꞌamé caí ɨ́ tavástaraꞌa patáꞌaj rɨ́ꞌɨ huáꞌuruuren ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Múꞌee pe tihuaꞌutáꞌixaateꞌesin aꞌɨ́mej ɨ́ teɨtestemuaꞌameꞌen ɨ́ tavástaraꞌa aꞌij tɨ aꞌɨ́ɨn tihuaꞌirátuaasin, aꞌɨ́jna jɨmeꞌe tɨ tíhuaꞌutáꞌuuniꞌira ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Ayee pej rɨni aꞌiné jéꞌecan pu táꞌacuꞌuve ɨ́ taDioj. Amɨ́ pu yé veꞌecánejsin íiyen chaanaca japua tɨ́ꞌij táamuaare itejmi. Aꞌuu pu hui nain xɨcaj tzajtaꞌa tátzaveꞌe aꞌame tɨ ij huanéeriꞌicɨ́ áꞌaraꞌani temuaꞌa naa aꞌɨ́mej jemi ɨ́ mej huachéjme tɨ́caꞌamisteꞌe, aꞌɨ́mej jemi ɨ́ mej tíꞌitziɨɨneꞌe aꞌájna xɨcájraꞌa mej jetzen cuiꞌini, mej yee cumu tɨ́caꞌamisteꞌe mú seijreꞌe. Aꞌɨ́ɨ pu ajta taatáꞌitɨira tej ti rɨ́ꞌɨ tíꞌitechejca. Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Zacarías. ");
INSERT INTO crnNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ajta aꞌɨ́ɨn ɨ́ paꞌarɨꞌɨ, aꞌɨ́ɨ pu huavéꞌese. Ajta ru tzajtaꞌa huateújcaꞌane. Aꞌuu pu éꞌechejcaꞌa aꞌu tɨ caí méꞌe éꞌe tiꞌitɨ́j ajta naꞌa caí huataseíjreꞌen jéjreꞌe aꞌɨ́mej jemi ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Aꞌájnáꞌɨmua, tɨ́ꞌɨj aꞌɨ́ɨn tiꞌitéveecaꞌa ɨ́ rey jɨmeꞌe aꞌɨ́jna ɨ́ Augusto tɨ ajta ayée ántehuaacaꞌa tɨjɨ́n César, aꞌɨ́ɨ pu tíraataꞌaíjtacaꞌa mej mi ahuaujyuꞌuxan mej mi huaꞌutéꞌitɨen naíjmiꞌica mej aꞌuun aꞌuchéjme tɨ́j naꞌa aꞌu tɨ tejéꞌaijta. ");
INSERT INTO crnNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ayee pu tiuꞌurɨ́j tɨ́ꞌɨj auj Cirenio tiꞌitéveecaꞌa tajtuhuan jɨmeꞌe aꞌájna u Siria. Aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeeneꞌe tɨ huaꞌutaꞌítecaꞌa ɨ́ mej amuacaí huaꞌutéꞌitɨee. ");
INSERT INTO crnNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Majta meꞌɨ́n ɨ́ teɨte, naímiꞌi mú aꞌucɨ́jxɨ aꞌu mej éꞌemeꞌecan mej mi aꞌahuaújyuꞌuxa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨn José pu huirájraa aꞌujna Nazarét, Galilea jetze tɨ ajtémeꞌecan. Aꞌuu pu aꞌaráꞌa u Judea, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Belén. Aꞌuu pu jaꞌunúꞌihuacaꞌa aꞌɨ́jna ɨ́ David teecan, aꞌɨ́jna tɨ ajmíꞌi tiꞌitéveecaꞌa ɨ́ rey jɨmeꞌe. Aꞌiné aꞌɨ́j pu jetze huanéj aꞌɨ́jna ɨ́ José, aꞌɨ́j pu jɨ́n aꞌuun áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ajta pu aꞌɨ́ɨn áꞌuraa ɨ́ María aꞌɨ́jna jamuan ɨ́ José tɨ raꞌancuréꞌeviꞌitɨ. Ajta aꞌɨ́jna ɨ́ María, puꞌuri autájucacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Aꞌuu mú aꞌutéꞌuucaꞌa tɨ́ꞌɨj tejaꞌuréꞌene ɨ́ xɨca tɨ jetzen huanúꞌihuacaꞌa ɨ́ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Aꞌɨ́j pu jɨ́n tiyaúj jáꞌaraa amuacaícan jɨmeꞌe. Teáatacaꞌa ɨ́ paꞌarɨꞌɨ. Cɨ́ɨxuri pu jɨ́n racáꞌijcatacaꞌa tɨ́ꞌɨj huanúꞌihuacaꞌa. Aꞌɨ́j pu jetze raꞌatéete tiꞌitɨ́j jetze cɨyej tɨ atécun aꞌu mej yeꞌemuaate tejéꞌecuaꞌaca aꞌiné camuchéꞌe úꞌuvejricɨcaꞌa cuaartu tzajtaꞌa mej meꞌuun aꞌuteárute. ");
INSERT INTO crnNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Aꞌujna vejliꞌi u Belén, seica mú aꞌutéꞌuucaꞌa cáneꞌaxɨ mej tiseíjracaꞌa. Aꞌuu mú eꞌetáxaꞌiirihuaꞌa huáꞌa jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tɨꞌɨj jí seɨ́j pu huataseíjre tɨ ta japua tíꞌivaɨreꞌe tavástaraꞌa jemi. Jɨ́meꞌen puꞌu huataseíjre, aj pu i aꞌɨ́ɨn tavástaraꞌa á eꞌetatátzavajraa huáꞌa jemi ɨ́ mej eꞌejteí. Majta meꞌɨ́n cáneꞌaxɨ mej seɨreꞌe, temuaꞌa mú jeíhua tiuꞌutátziɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ajta ayén tihuaꞌutáꞌixaa aꞌɨ́jna tɨ ta japua tíꞌivaɨreꞌe tɨjɨ́n: ―Caxu tíꞌitziɨɨneꞌe. Ayee nu ꞌeen jɨ́n mú aꞌuvéꞌemej neatáꞌaj niuucari amuaatáꞌixaateꞌen ɨ́ sej jɨ́n huataújtemuaꞌaveꞌesin jeíhua, tɨ tiꞌivaɨ́reꞌe aꞌame para naíjmiꞌica jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","’Ijii, aꞌájna chajtaꞌa David teecan tɨ jetzen éꞌemeꞌecan, múꞌejmi jɨmeꞌe pu hui jaꞌunúꞌihuacaꞌa aꞌɨ́jna tɨ amuaꞌirátuaasin. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Cɨríistuꞌu, ɨ́ tavástaraꞌa, aꞌɨ́jna tɨ Dios raꞌantíhuaꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","’Ayee xu éeniꞌicɨꞌe ramuaꞌaréeren aꞌij tɨ éeneꞌe aꞌɨ́ɨn púꞌeen. Aꞌuun xu yéꞌeteuni ɨ́ paꞌarɨꞌɨ, cɨ́ɨxuri jɨ́n caícatziꞌihua. Aꞌuu pu aracaꞌitɨ́ aꞌame cɨyej jetze taꞌatécun, yeꞌemuaate mej jetzen téꞌecuaꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jíyeꞌitzi mú jɨ́n jeíhua huataseíjre aꞌɨ́ɨme ɨ́ mej ta japua tíꞌivaɨreꞌe meꞌɨ́jna jemi ɨ́ seɨ́j. Matɨ́ꞌɨj mi naíjmiꞌi rɨ́ꞌɨ tiraateájtuaa ɨ́ tavástaraꞌa. Ayee mú tiuꞌuxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Miyen tɨjɨ́n: Tichéꞌe rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios tɨ huápɨꞌɨ naa seijreꞌe ɨ́ ta japua. Ajta íiyen chaanaca japua, michéꞌe rɨ́ꞌɨ tíꞌitechéjmeꞌeni ɨ́ teɨte ɨ́ tɨ Dios rɨ́ꞌɨ tihuaꞌutáꞌasin. Ayee muꞌu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Matɨ́ꞌɨj mi aꞌucɨ́j aꞌɨ́ɨme ɨ́ mej ta japua tíꞌivaɨreꞌe. Majta meꞌɨ́n ɨ́ mej cáneꞌaxɨ tiseíjracaꞌa, ayée mú tiuꞌutaúꞌixaa tɨjɨ́n: ―Tichéꞌe u áꞌujuꞌun aꞌujna Belén tetáꞌaj yaꞌuseíj aꞌɨ́jna aꞌij tɨ huarɨ́j ɨ́ tɨ taataꞌixaa ɨ́ tavástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Matɨ́ꞌɨj mi caꞌanacan u áꞌujuꞌun. Aꞌuu mú yáꞌuteu meꞌɨ́jna ɨ́ José, majta María, majta ɨ́ uneecaꞌi. Aꞌuu pu cɨyej jetze arácaꞌatii, yeꞌemuaate mej jetzen téꞌecuaꞌaca. ");
INSERT INTO crnNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Matɨ́ꞌɨj raaseíj ɨ́ paꞌarɨꞌɨ, aj mú mi huaꞌutáꞌixa ɨ́ teɨte aꞌij tɨ aꞌɨ́ɨn tihuaꞌutáꞌixaa tɨ huáꞌa jemi huataseíjre, aꞌij tɨ tihuaꞌutáꞌixaa aꞌɨ́jna jɨmeꞌe ɨ́ paꞌarɨꞌɨ tɨ huanúꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Majta meꞌɨ́n ɨ́ mej huáꞌunamuajriꞌi aꞌij mej tíꞌixajtacaꞌa aꞌɨ́ɨme cáneꞌaxɨ mej tiseíjracaꞌa, naímiꞌi mú rɨ́ꞌɨ naa tihuaꞌutaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ajta aꞌɨ́ɨn ɨ́ María, aꞌɨ́ɨ pu rúꞌavaatacaꞌa ɨ́ ru tzajtaꞌa. Jéihua pu tíꞌimuaꞌajca aꞌij tɨ tiꞌitɨ́ huarɨ́j huáꞌa jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Matɨ́ꞌɨj mi aꞌucɨ́j aꞌɨ́ɨme cáneꞌaxɨ mej tiseíjracaꞌa. Jéꞌecan maújtemuaꞌaveꞌe ɨ́ Dios jemi, majta rɨ́ꞌɨ tiraatáꞌa niuucari jɨmeꞌe aꞌɨ́jna jɨmeꞌe ɨ́ mej ráanamuajriꞌi, majta ɨ́ mej raaseíj. Naímiꞌi pu ayén tejaꞌuréꞌene aꞌij tɨ tihuaꞌutáꞌixaa ɨ́ tavástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tɨ́ꞌɨjta tejauuméꞌeca aráhuaica xɨca jetze, tɨ́ꞌɨj i tejaꞌuréꞌene ɨ́ xɨca mej jetzen raꞌantisíjchi ɨ́ naviiraꞌan ɨ́ tɨ jetzen teꞌeviꞌi ɨ́ paꞌarɨꞌɨ. Matɨ́ꞌɨj mi miyen raatamuáꞌa tɨjɨ́n Jesús, tɨ́j ayén amuacaícan tiraataꞌixaa aꞌɨ́jna ɨ́ seɨ́j tɨ ta japua tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tɨ́ꞌɨjta ari tejaꞌuréꞌene jaꞌanáj matɨ́j puaꞌa ɨ́ꞌɨhuaca aꞌij tɨ yeꞌí téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze Moisés tɨ raꞌuyúꞌuxacaꞌa, matɨ́ꞌɨj mi meꞌájna yaꞌuvíꞌitɨ meꞌájna Jerusalén mej mi u yaꞌutaseíjrata ɨ́ paꞌarɨꞌɨ u teyujtaꞌa ɨ́ tavástaraꞌa jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ayee mú huarɨ́j, aꞌiné ayée pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: “Ayee pu tiúꞌujxeꞌeveꞌe mej yaꞌutaseíjrata ɨ́ tavástaraꞌa jemi naíjmiꞌica aꞌachú mej puaꞌaméca ɨ́ mej amuaatéꞌee muaanúnuꞌihuacaꞌa ɨ́ tɨꞌɨríi ɨ́ mej teteca.” ");
INSERT INTO crnNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Majta tiuꞌutámuaɨꞌɨvejtan aꞌij tɨ ajta téꞌeyuꞌusiꞌi aꞌɨ́jna jetze tɨ jɨ́n tihuáꞌuꞌitɨiiriꞌi ɨ́ tavástaraꞌa. Ayen tɨjɨ́n: “Micheꞌe huaꞌapuaca huatámuaɨꞌɨvejta ɨ́ cucuiꞌise naꞌari huaꞌapuaca ɨ́ jáamuaꞌise.” ");
INSERT INTO crnNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Aꞌájnáꞌɨmua, seɨ́j pu aꞌuun eꞌechéjmeꞌe aꞌájna Jerusalén. Ayee pu ántehuaacaꞌa tɨjɨ́n Simeón. Rɨ́ꞌɨ pu tiꞌitiújchaꞌɨɨcaꞌa ɨ́ Dios jemi. Ajta jeíhua pu ráꞌastejcaꞌa ɨ́ ruyeꞌirá. Aꞌɨ́j pu tíꞌijchuꞌeveꞌecaꞌa aꞌájna xɨcájraꞌan jetze tɨ jetzen Dios huáꞌancuꞌuvajxɨꞌɨsin aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan. Ajta aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu jemin huateájturaa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Aꞌɨ́n xɨéjniuꞌucareꞌaraꞌan ayén tiraataꞌixaa tɨ nuꞌu caí mɨꞌɨni caí xɨ huataseíjreꞌen ɨ́ Cɨríistuꞌu, tɨ tavástaraꞌa yeꞌutaꞌítiꞌi. Aꞌɨ́ɨ pu nuꞌu Simeón raseijran. ");
INSERT INTO crnNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tɨꞌɨj jí ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios caꞌaníjraꞌa raatáꞌa aꞌɨ́jna ɨ́ Simeón tɨ aꞌuun aꞌatanén u teyujtaꞌa aꞌu tɨ eꞌeráyaujtaꞌa. Majta meꞌɨ́n ɨ́ vaújsimuaꞌameꞌen ɨ́ paꞌarɨꞌɨ, aꞌúu mú majta aꞌaráꞌa u teyujtaꞌa mej mi miyen ráaruuren ɨ́ paꞌarɨꞌɨ aꞌij tɨ tiúꞌujxeꞌeveꞌe mej mi raꞌaráꞌasten ɨ́ ruyeꞌirá. ");
INSERT INTO crnNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Aj pu i aꞌɨ́ɨn Simeón raꞌancuréꞌechui aꞌɨ́jna ɨ́ paꞌarɨꞌɨ. Tɨꞌɨj jí rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Nevástaraꞌa, puꞌuri rɨꞌɨrí pej naatáꞌan nej nexɨéehua huámɨꞌɨni, aꞌiné pepuꞌuri raꞌaráꞌaste aꞌɨ́jna ɨ́ pej jɨ́n teꞌatáꞌaratziiriꞌi ineetzi jemi i nej muavaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Aꞌiné nejɨ́ꞌɨ nu jɨ́n raaseíj aꞌíjna ɨ́ pej jɨ́n tuꞌirátuaasin, aꞌíjna ɨ́ pej yen raateájtuaa metiꞌiseíiracaꞌa naíjmiꞌi ɨ́ teɨte aꞌachú mej puaꞌamé yen huachéjme íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Aꞌɨ́ɨ pu huaꞌatátzaviꞌira aꞌame temuaꞌa naa aꞌɨ́mej ɨ́ mej caí Israél jetze ajtémeꞌecan mej mi caí chéꞌe miyen ꞌeeneꞌen matɨ́j aꞌɨ́ɨme ɨ́ mej huachéjme tɨ́caꞌamisteꞌe. Ajta aꞌɨ́ɨ pu hui veꞌecán jɨ́n tíhuaꞌutaꞌaíjteꞌesin ɨ́ áꞌateɨtestemuaꞌa, aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan. Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Simeón. ");
INSERT INTO crnNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jéꞌecan mú naa rɨ́ꞌɨ tiraꞌutaseíj ɨ́ vaújsimuaꞌameꞌen ɨ́ paꞌarɨꞌɨ aꞌɨ́jna jɨmeꞌe aꞌij tɨ tiuꞌutaxájtacaꞌa ɨ́ paꞌarɨꞌɨ jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tɨꞌɨj jí Simeón rɨ́ꞌɨ tihuaꞌuteájtuaa. Tɨꞌɨj jí ayén tiraataꞌixaa ɨ́ María, ɨ́ náànajraꞌan ɨ́ paꞌarɨꞌɨ tɨjɨ́n: ―Casiꞌi, ayée pu tiúꞌuxɨꞌepɨꞌɨntariꞌihuacaꞌa tɨ aꞌɨ́jna paꞌarɨꞌɨ jɨmeꞌe. Muꞌiitɨ́ mú veꞌecán jɨ́n titeꞌenteárutixɨꞌɨsin aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, ajta muꞌiicáca pu téꞌariꞌira ɨ́ mej jɨ́n títetateí. Aꞌɨ́j xu jɨ́n siyen tiráamuaꞌaree tɨ ayén téꞌeme aꞌiné jeíhua mú ratíti. ");
INSERT INTO crnNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","’Ayee pu téꞌeme tɨ́ꞌij mé jéjreꞌe seijreꞌe aꞌij mej tíꞌimuaꞌatze ɨ́ teɨte mémuꞌiitɨ́. Ajta múꞌeetzi, ayée pu cheꞌatá naꞌa tímuꞌuhuatacuíꞌini ɨ́ áꞌa tzajtaꞌa cumu tɨ jaꞌatɨ muaꞌantéjtzeti nahuaa jɨmeꞌe. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Seɨ́j pu ajta vejliꞌi huatéveecaꞌa tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ꞌƗ́itaꞌa pu púꞌeen tɨ ayén ántehuaa tɨjɨ́n Ana. Puꞌuri ucarij. Aꞌɨ́ɨ pu yaujraꞌan púꞌeen aꞌɨ́jna ɨ́ Fanuel, ɨ́ tɨ Aser jetze ajtémeꞌecan. Aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, ayée pu áꞌatee tɨ viɨ́cheꞌe aꞌachú cumu aráhuaꞌapua nineꞌiraꞌa. Tɨꞌɨj jí huamɨ́ꞌɨ ɨ́ cɨ́naꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tɨꞌɨj jí ruséɨjta jáꞌaraa. Jéihua pu ari áꞌatee tɨ ayén ruseɨ́j. Ajta puꞌuri ayén ucarij naꞌa cumu muáacuate japuan muáacua nineꞌiraꞌa. Capu ajta jaꞌanáj huiráayeꞌicaa u teyujtaꞌa sino aꞌúu pu rɨ́ꞌɨ tiratáꞌacareꞌe ɨ́ Dios jemi nain xɨcaj tzajtaꞌa, ajta nain tɨ́caꞌari tzajtaꞌa. Ajta pu rúꞌitziꞌiveꞌecaꞌa, ajta téniúuveꞌe ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jɨ́meꞌen puꞌu raatapuáꞌajtacaꞌa ɨ́ Simeón tɨ tiuꞌutaxájtacaꞌa, aj pu i aꞌɨ́ɨn aꞌuréꞌene aꞌɨ́mej jemi. Tɨꞌɨj jí rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Tɨꞌɨj jí aꞌutéjche tɨ huaꞌutáꞌixaateꞌen ɨ́ teɨte aꞌɨ́jna jɨmeꞌe ɨ́ paꞌarɨꞌɨ. Aꞌɨ́ɨme ɨ́ teɨte, aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ mej rachúꞌeveꞌecaꞌa tɨ Dios huaꞌirájtuaani naímiꞌi aꞌuun mej Jerusalén huachéjme. ");
INSERT INTO crnNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Majta meꞌɨ́n ɨ́ vaújsimuaꞌameꞌen ɨ́ paꞌarɨꞌɨ, matɨ́ꞌɨj nain jɨ́n teꞌaráꞌaste aꞌij tɨ téꞌeyuꞌusiꞌi aꞌɨ́jna jetze tɨ jetzen tihuáꞌuꞌitɨiiriꞌi ɨ́ tavástaraꞌa, matɨ́ꞌɨj mi aꞌucɨ́j aꞌájna jáꞌahuaꞌa Galilea. Aꞌuu mú aꞌutanéj u Nazarét, aꞌu mej éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ajta aꞌɨ́ɨn ɨ́ paꞌarɨꞌɨ, aꞌɨ́ɨ pu huavéꞌese, ajta huateújcaꞌane. Jéꞌecan pu rɨ́ꞌɨ mé teúumuaꞌarejcaꞌa. Ajta pu Dios rɨ́ꞌɨ tiratáꞌacareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Majta aꞌɨ́ɨme ɨ́ vaújsimuaꞌameꞌen ɨ́ paꞌarɨꞌɨ, tɨ́ꞌɨj pɨ́ naꞌa nineꞌiraꞌa jetze, aꞌúu mú aꞌatánineicaꞌa aꞌánna Jerusalén mej mi raꞌutámuaꞌaree aꞌájna xɨcájraꞌa tɨ jetzen Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌa yaujmuaꞌa mej anáatéꞌee muaanúnuꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tɨ́ꞌɨj ari rájchaꞌɨɨcaꞌa aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua nineꞌiraꞌa aꞌɨ́jna ɨ́ paꞌarɨꞌɨ, aꞌɨ́ɨme vaújsimuaꞌameꞌen, aꞌúu mú áꞌujuꞌun mej mi tiúꞌuyesten ɨ́ ruyeꞌirá jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tɨ́ꞌɨj teꞌupuáꞌarecaꞌa ɨ́ mej tiuꞌuyéꞌeste, matɨ́ꞌɨj mi huaréꞌacɨ para aꞌujna mé éꞌeche. Ajta aꞌɨ́ɨn ɨ́ paꞌarɨꞌɨ, aꞌúu pu aꞌuteájturaa aꞌájna Jerusalén. Majta meꞌɨ́n ɨ́ vaújsimuaꞌameꞌen, camu ramuaꞌareerecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ayee mú tíꞌimuaꞌajca tɨjɨ́n: Huáꞌa jamuan pu huaméj ɨ́ seica ɨ́ mej ta jamuan huajúꞌucaa. Muꞌuri seɨ́j xɨcaj áꞌatee mej miyen titeejúꞌucaa. Matɨ́ꞌɨj mi autéjhuii mej ráahuauni huáꞌa tzajtaꞌa ɨ́ teɨte, ajta aꞌɨ́mej jemi ɨ́ mej huáꞌa jamuan huajúꞌucaa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Matɨ́ꞌɨj caí ráateu, matɨ́ꞌɨj aꞌuun huaréꞌacɨ aꞌájna Jerusalén mej mi ráahuauni. ");
INSERT INTO crnNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Miráꞌatee aꞌachú cumu huaíca xɨcaj mej rahuauhuau. Matɨ́ꞌɨj mi xaa ráateu. Aꞌuu pu unúꞌujcatii u teyujtaꞌa aꞌu tɨ eꞌeráyaujtaꞌa. Aꞌuu pu aꞌutácatii huáꞌa jamuan ɨ́ mej tíꞌimuaꞌata. Aꞌɨ́mej pu namuajracaꞌa, ajta tihuaꞌíhuaꞌura. ");
INSERT INTO crnNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Majta meꞌɨ́n ɨ́ mej ráanamuajriꞌi, naímiꞌi mú naa rɨ́ꞌɨ tiraꞌutaseíj meꞌɨ́jna jɨmeꞌe tɨ temuaꞌa naa tiyaúꞌitɨée jáꞌaraa aꞌij mej tiraataꞌixaa, majta meꞌɨ́jna jɨmeꞌe aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Majta meꞌɨ́n ɨ́ vaújsimuaꞌameꞌen matɨ́ꞌɨj raaseíj tɨ huáꞌa tzajtaꞌa jéꞌejvee, jeíhua mú aꞌij raꞌutaseíj. Tɨꞌɨj jí ayén tiraataꞌixaa ɨ́ náànajraꞌan tɨjɨ́n: ―Niyauj, ¿aꞌiné ꞌeen jɨ́n piyen taruure? Tuꞌuri áꞌatee tej muahuauhuau inee, ajta aꞌatáàta. Jéꞌecan tu aꞌij puaꞌa teꞌetamuaꞌate múꞌeetzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tɨꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n siyen tíꞌinehuauhuau? ¿Ni qui secaí ramuaꞌaree tɨ ayén tiúꞌujxeꞌeveꞌe nej niyen teꞌevéꞌenmuaꞌareere íiyu niTáàta chiꞌij jetze? ");
INSERT INTO crnNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Majta meꞌɨ́n, camu aꞌatzu meꞌɨ́n yaúꞌitɨée muáꞌaraa aꞌij tɨ tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tɨꞌɨj jí áꞌuraa huáꞌa jamuan ɨ́ ruvaújsimuaꞌa. Matɨ́ꞌɨj mi meꞌuun aꞌucáane u Nazarét. Ajta aꞌɨ́ɨn, aꞌɨ́ɨ pu huáꞌantzaahua ɨ́ ruvaújsimuaꞌa. Ajta aꞌɨ́ɨn náànajraꞌan, aꞌɨ́ɨ pu nain teúꞌavaatacaꞌa ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu huavéꞌese, ajta jaítzeꞌe ari tiúꞌumuaꞌareerecaꞌa. Dios pu rɨ́ꞌɨ tiraatáꞌa, majta ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ayee pu nuꞌu tiujuꞌurɨ́j tɨ́ꞌɨj teuuméꞌeca aꞌachú cumu tamuáamuataꞌa japuan anxɨ́j nineꞌiraꞌa tɨ tíꞌaijtacaꞌa aꞌɨ́jna ɨ́ César, ɨ́ mej majta miyen ratamuáꞌamua tɨjɨ́n Tiberio. Aꞌájnáꞌɨmua, tɨ́ꞌɨj auj tiꞌitéveecaꞌa tajtuhuan jɨmeꞌe aꞌɨ́jna ɨ́ Póncio Pilato aꞌujna Judea, ajtahuaꞌa seɨ́j pu tiꞌitéveecaꞌa tajtuhuan jɨmeꞌe aꞌujna Galilea. Ayee pu ántehuaacaꞌa tɨjɨ́n Heródes. Ajta juutzeájraꞌan aꞌɨ́jna ɨ́ Heródes, aꞌɨ́ɨ pu tiꞌitéveecaꞌa tajtuhuan jɨmeꞌe aꞌujna Iturea, ajta aꞌujna Traconite. Ayee pu ántehuaacaꞌa aꞌɨ́jna tɨjɨ́n Felipe. Ajta aꞌɨ́ɨn ɨ́ Lisanias, aꞌɨ́ɨ pu tajtuhuan jɨmeꞌe tiꞌitéveecaꞌa aꞌujna Abilene. ");
INSERT INTO crnNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Aꞌájnáꞌɨmua, matɨ́ꞌɨj mauj veꞌecán jɨ́n titetatéꞌacaa u teyujtaꞌa aꞌɨ́jna ɨ́ Anás, ajta aꞌɨ́jna ɨ́ Caifás, aꞌúu pu áꞌucatii aꞌɨ́jna ɨ́ Juan, jáꞌahuaꞌa aꞌu tɨ caí jéꞌe tiꞌitɨ́j. Aꞌɨ́jna ɨ́ Juan, aꞌɨ́ɨ pu rayauj aꞌɨ́jna ɨ́ Zacarías. Aꞌuu pu aꞌucaíca tɨ́ꞌɨj Dios raatajé. ");
INSERT INTO crnNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nainjapua pu yéꞌivejcaꞌa tɨ́j naꞌa aꞌuun tɨ huatacáꞌa ɨ́ játeꞌana jetze, ɨ́ Jordán. Ayee pu tihuáꞌaꞌixaateꞌecaꞌa tɨ nuꞌu ayén tiúꞌujxeꞌeveꞌe mej nuꞌu seɨcɨé tiúꞌumuaꞌati tɨ ij nuꞌu Dios tihuaꞌutáꞌuuniꞌi ɨ́ mej jɨ́n auteájturaa ɨ́ jemin. Aj pu i Juan huáꞌumuaɨꞌɨhuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ayee pu cheꞌatá naꞌa rɨjcaa aꞌij tɨ teꞌuyúꞌuxacaꞌa ɨ́ yuꞌuxari jetze aꞌɨ́jna ɨ́ Isaías, ɨ́ tɨ ajmíꞌi tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Ayen tɨjɨ́n: Jaꞌatɨ pu u eꞌejíjhua aꞌujna jáꞌahuaꞌa aꞌu tɨ caí éꞌe tiꞌitɨ́j. Ayee pu tejéꞌexa aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: “Naa xu rɨ́ꞌɨ huaújcaten múꞌeen sej si rɨ́ꞌɨ tiraꞌancuréꞌeviꞌitɨn ɨ́ tavástaraꞌa, sej si caí raatamuárɨꞌeristeꞌen seꞌɨ́jna tɨ yen huataseíjreꞌesin tɨ́ꞌij amuaꞌirájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Michéꞌe miyen rɨ́ꞌɨ huaújcaten matɨ́j aꞌɨ́ɨme ɨ́ mej juyeta. Michéꞌe teꞌevéꞌejɨ́steꞌaxɨꞌɨn aꞌu tɨ eꞌetécúcuꞌunijmee. Michéꞌe majta raatéꞌuunaxɨꞌɨn nain ɨ́ jɨrí tɨ tíꞌitacaíjmee. Ajta ɨ́ juye tɨ tiújtutájme, michéꞌe raatajéꞌiyiteꞌaxɨꞌɨn. Ajta aꞌu tɨ caí aꞌupáꞌatza, michéꞌe raꞌuréꞌepaꞌatzareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ajta, tɨ́ꞌɨj uvéꞌenen ɨ́ tavástaraꞌa, naímiꞌi ɨ́ teɨte ɨ́ mej yen huachéjme íiyen chaanaca japua, aꞌɨ́ɨ mú raseijran ɨ́ tɨ jɨ́n Dios huaꞌirátuaasin.” Aii puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ajta aꞌɨ́jna ɨ́ Juan, ayée pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ teɨte ɨ́ mej aꞌuréꞌenineicaꞌa. Ayen tɨjɨ́n: ―Mɨ́ sej siyen seijreꞌe. Cu xɨee sej aꞌuruáachejyeꞌi matɨ́j ɨ́ cuꞌucuꞌuse tɨ ij caí huáꞌutaiixɨꞌɨ ɨ́ taij. ¿Ni tzaa seri tíꞌiteseꞌe sicu, tɨ ij caí Dios amuaꞌuxɨ́jteꞌen? ¿Aꞌataani caꞌaníjraꞌa amuaatáꞌa sej si siyen huárɨni? ");
INSERT INTO crnNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Naꞌari caí, tɨ puaꞌa múꞌeen rujɨ́ɨmuaꞌa yé seveꞌeréꞌenen tzáahuatiꞌiraꞌa jɨmeꞌe, ayée xu huárɨni aꞌij tɨ yeꞌí tiraavíjteꞌe seꞌɨ́jna jɨmeꞌe sej seri seɨcɨé tiuꞌumuáꞌaj. Caxu siyen tíꞌimuaꞌatze mɨ ru tzajtaꞌa yee ayée pu tiꞌayajna tɨ naa tejámuaatévaɨreꞌen ɨ́ Dios jemi aꞌiné múꞌeen xu iꞌi huáacɨxaꞌastemuaꞌameꞌen aꞌɨ́jna ɨ́ Abraham teecan. ’Ayee nu hui tejáꞌamuaꞌixaateꞌe aꞌiné ayée pu tiꞌayajna tɨ Dios ayén tiraayɨ́ꞌɨtɨ tɨ ayén ráaruuren ɨ́ tetej tɨ ij seɨcɨé huaújruuren tɨ́j tɨ ayén seíireꞌe áꞌaraꞌani matɨ́j teɨte, matɨ́j aꞌɨ́ɨme ɨ́ mej Abraham teecan jetze huanéj. Capu tiꞌitɨ́j aꞌij tejamuatévaɨre ɨ́ Dios jemi sej iꞌi huáacɨxaꞌastemuaꞌameꞌen aꞌɨ́jna ɨ́ Abraham teecan. ");
INSERT INTO crnNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","’Puꞌuri hui vejliꞌi aꞌájna xɨcájraꞌan jetze jaꞌanáj tɨ puaꞌa Dios amuáꞌaxɨjteꞌen caꞌanín jɨmeꞌe. Ayee pu áꞌamuaruuren cumu jaꞌatɨ tɨ cɨyej áꞌijveichixɨꞌɨsin tepuaij jɨmeꞌe. Naíjmiꞌi ɨ́ cɨyej tɨ caí tíꞌitaaca, aꞌɨ́ɨ pu tiuꞌuréꞌeveijchi, ajta tíꞌitairan. Ayee pu cheꞌatá naꞌa amuáꞌaxɨjteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Matɨ́ꞌɨj meꞌɨ́n teɨte miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tenaꞌaqui rɨni? ");
INSERT INTO crnNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tɨꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ huaꞌapuaca tísiicuꞌu, chéꞌe seɨ́j raatapíjteꞌen aꞌɨ́jna tɨ caí tísiicuꞌu. Ayen chaꞌa tanaꞌa, tɨ puaꞌa jaꞌatɨ tíꞌijchaꞌɨɨca ɨ́ tɨ tíꞌicuaꞌiriꞌi, chaꞌa aꞌɨ́ɨn raatáꞌan ɨ́ tɨ caí tiꞌitɨ́j tíchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Majta mú eꞌiréꞌene seica ɨ́ mej huáꞌajijveꞌecaꞌa ɨ́ mej tíꞌitɨcɨ tɨ ij aꞌɨ́ɨn huáꞌumuaɨꞌɨhua. Ayee mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maestro, ¿aꞌiné táarɨni iteen? ");
INSERT INTO crnNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tɨꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌij xu ancuréꞌan aꞌachú tɨ caj tiraaxɨ́ꞌepɨꞌɨntare. Caxu hui jaítzeꞌe huáꞌajijveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Majta meꞌɨ́n ɨ́ xantaaruꞌu, ayée mú majta tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Carij iteen, ¿aꞌiné táarɨni? Tɨꞌɨj jí ayén tiuꞌutaniú tɨjɨ́n: ―Caxu huáꞌanahuaꞌira ɨ́ huaꞌatúmin. Caxu huaꞌitzi jɨ́n tihuáꞌaxajtziꞌira ɨ́ teɨte. Seajta, seꞌɨ́jna jɨ́n rɨ́ꞌɨ titéꞌujmuajte aꞌachú mej caj tejáꞌamuanajchiteꞌen. ―Ayee tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Majta meꞌɨ́n ɨ́ teɨte, ayée mú tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa yee tij caí aꞌɨ́ɨ pɨ́rɨcɨ ɨ́ Cɨríistuꞌu aꞌɨ́jna ɨ́ Juan, ɨ́ mej rachúꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tɨꞌɨj jí Juan ayén tihuaꞌutáꞌixaa naíjmiꞌica tɨjɨ́n: ―Aru inee, jaj nu jɨ́n áꞌamuamuaɨꞌɨhua. Mɨ́ ajta, seɨ́j pu aꞌúu mé eꞌevéꞌeme tɨ jaítzeꞌe raayɨ́ꞌɨtɨ necaí inee. Aꞌiné nee nu cɨliéeneꞌe jɨ́n tiꞌitéjvee, ineetzi, capu ayén tiraavíjteꞌe nej raꞌajtaꞌɨ́ꞌɨpɨꞌɨn ɨ́ caꞌacairaꞌan. Mɨ́ ajtáꞌi amɨ́n, xɨéjniuꞌucari pu huataꞌíti tɨ huateáturan múꞌejmi jemi. Aꞌɨ́ɨ pu pɨ́rɨcɨ Dios tɨ raxɨ́ejniuꞌuca. Ajta aꞌɨ́jna tɨ mé eꞌevéꞌeme, aꞌɨ́ɨ pu pɨ́rɨcɨ tɨ rɨ́ꞌɨ áꞌamuaruuren mɨ aꞌamua tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","’Ayee pu téꞌeme aꞌájna tɨ aꞌɨ́ɨn yé uvéꞌenen, cu xɨee tɨ cu jaꞌatɨ ruꞌitéchueeca ɨ́ tɨ jɨ́n jetzen raꞌanáacaꞌatze ɨ́ játzeꞌaraꞌan ɨ́ triigu. Ajta aꞌɨ́ɨn ruꞌirátuꞌisin ɨ́ xaɨɨri á puaꞌacɨé. Ajta aꞌɨ́jna ɨ́ imueꞌeri, rájseɨreꞌesin u chiꞌita. Ajta ɨ́ xaɨɨri, á puaꞌacɨé pu yéꞌetairan ɨ́ taij jetze tɨ caí jaꞌanáj éꞌemɨꞌɨca. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aꞌɨ́jna jɨmeꞌe ɨ́ niuucari, ajta seica jɨmeꞌe, aꞌɨ́j pu jɨ́meꞌen tihuáꞌuꞌitɨiiriꞌi mej mi ráamuaꞌaree aꞌij tɨ ꞌeen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tɨꞌɨj jí Juan raꞌajtéꞌaxɨ aꞌɨ́jna ɨ́ Heródes, aꞌɨ́jna jɨmeꞌe tɨ yáꞌuviꞌitɨn aꞌɨ́jna ɨ́ Herodías, tɨ amuacaí viɨ́cheꞌecaꞌa aꞌɨ́jna jemi ɨ́ juutzeájraꞌan ɨ́ Heródes. Ajta pu aꞌɨ́jna jɨ́n raꞌajtéꞌaxɨ aꞌij tɨ tiꞌitɨ́j huáruu. ");
INSERT INTO crnNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Tɨꞌɨj jí Heródes aꞌij puaꞌa huarɨ́j tiꞌitɨ́j jɨmeꞌe tɨ caí xɨ́ꞌepɨꞌɨn ꞌeen, aꞌɨ́ɨ pu raꞌiteáana aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tɨ́ꞌɨj aꞌɨ́ɨn Juan huáꞌamuaɨꞌɨhuacaꞌa ɨ́ teɨte, aꞌɨ́ɨ pu ajta aꞌɨ́j huámuaɨꞌɨhuacaꞌa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj Jesús téniuusimeꞌe ɨ́ Dios jemi, tɨ́ꞌɨj i antaújcuunarecaꞌa u ta japua tɨ aꞌuteájmuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ajta aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu aveꞌecámeꞌecaa. Ayee pu seijreꞌecaꞌa tɨ́j cucuiꞌi. Aj pu i japuan ꞌujyéijxɨ án muꞌúutzeꞌen. Ajta áꞌiyen niuucari huánamuajriꞌi tɨ uj eꞌicánamuajreꞌe júteꞌe. Ayen tɨjɨ́n: ―Niyauj pej hui pɨ́rɨcɨ ɨ́ nej jeíhua muáꞌixeꞌeveꞌe. Jéꞌecan pej rɨ́ꞌɨ naatáꞌa i ne tzajtaꞌa. Ayee pu tejeꞌijcánamuajre. ");
INSERT INTO crnNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu rájchaꞌɨɨcaꞌa aꞌachú cumu seité japuan tamuáamuataꞌa nineꞌiraꞌa tɨ́ꞌɨj aꞌutéjche tɨ tihuaꞌutáꞌixaateꞌen ɨ́ teɨte. Ajta aꞌɨ́ɨn, aꞌɨ́ɨ pu nuꞌu jetze airaújneijte ɨ́ José. Ajta aꞌɨ́ɨn José, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Elí. ");
INSERT INTO crnNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ajta aꞌɨ́ɨn ɨ́ Elí, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matat. Ajta aꞌɨ́ɨn ɨ́ Matat, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Leví, ajta aꞌɨ́ɨn Leví aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Melqui. Ajta aꞌɨ́ɨn Melqui, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jana. Ajta aꞌɨ́jna ɨ́ Jana, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ José. ");
INSERT INTO crnNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ajta aꞌɨ́jna ɨ́ José, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matatías. Ajta aꞌɨ́ɨn ɨ́ Matatías, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Amós. Ajta aꞌɨ́jna ɨ́ Amós, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Nahum. Ajta aꞌɨ́jna ɨ́ Nahum, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Esli. Ajta aꞌɨ́jna ɨ́ Esli, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Nagai. ");
INSERT INTO crnNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ajta aꞌɨ́ɨn Nagai, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Maat. Ajta aꞌɨ́jna Maat, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matatías. Ajta aꞌɨ́ɨn ɨ́ Matatías, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Semei. Ajta aꞌɨ́ɨn ɨ́ Semei, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ José. Ajta aꞌɨ́ɨn ɨ́ José, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Judá. ");
INSERT INTO crnNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ajta aꞌɨ́ɨn Judá, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jonán. Ajta aꞌɨ́ɨn ɨ́ Jonán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Resa. Ajta aꞌɨ́ɨn ɨ́ Resa, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Zorobabel. Ajta aꞌɨ́ɨn ɨ́ Zorobabel, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Salatiel. Ajta aꞌɨ́ɨn ɨ́ Salatiel, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Neri. ");
INSERT INTO crnNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ajta aꞌɨ́ɨn ɨ́ Neri, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Melqui. Ajta aꞌɨ́ɨn ɨ́ Melqui, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Adi. Ajta aꞌɨ́ɨn ɨ́ Adi, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Cosam. Ajta aꞌɨ́ɨn ɨ́ Cosam, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Elmodam. Ajta aꞌɨ́ɨn ɨ́ Elmodam, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Er. ");
INSERT INTO crnNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ajta aꞌɨ́ɨn Er, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Josué. Ajta aꞌɨ́ɨn ɨ́ Josué, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Eliezer. Ajta aꞌɨ́ɨn ɨ́ Eliezer, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jorim. Ajta aꞌɨ́ɨn ɨ́ Jorim, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matat. Ajta aꞌɨ́ɨn Matat, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Leví. ");
INSERT INTO crnNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ajta aꞌɨ́ɨn Leví, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Simeón. Ajta aꞌɨ́ɨn Simeón, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Judá. Ajta aꞌɨ́ɨn ɨ́ Judá, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ José. Ajta aꞌɨ́ɨn ɨ́ José, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jonán. Ajta aꞌɨ́ɨn ɨ́ Jonán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Eliaquim. ");
INSERT INTO crnNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ajta aꞌɨ́ɨn ɨ́ Eliaquim, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Melea. Ajta aꞌɨ́ɨn ɨ́ Melea, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Mainán. Ajta Mainán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matata. Ajta aꞌɨ́ɨn ɨ́ Matata, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Natán. Ajta aꞌɨ́ɨn ɨ́ Natán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ David. ");
INSERT INTO crnNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ajta aꞌɨ́ɨn ɨ́ David, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Isaí. Ajta aꞌɨ́ɨn ɨ́ Isaí, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Obed. Ajta aꞌɨ́ɨn ɨ́ Obed, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Booz. Ajta aꞌɨ́ɨn ɨ́ Booz, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Salmón. Ajta aꞌɨ́ɨn ɨ́ Salmón, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Naasón. ");
INSERT INTO crnNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ajta aꞌɨ́ɨn ɨ́ Naasón, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Aminadab. Ajta aꞌɨ́ɨn Aminadab, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Aram. Ajta aꞌɨ́ɨn ɨ́ Aram, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Esrom. Ajta aꞌɨ́ɨn ɨ́ Esrom, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Fares. Ajta aꞌɨ́ɨn Fares, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Judá. ");
INSERT INTO crnNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ajta aꞌɨ́ɨn ɨ́ Judá, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jacobo. Ajta aꞌɨ́ɨn ɨ́ Jacobo, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Isaac. Ajta aꞌɨ́ɨn ɨ́ Isaac, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Abraham. Ajta aꞌɨ́ɨn ɨ́ Abraham, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Taré. Ajta aꞌɨ́ɨn ɨ́ Taré, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Nacor. ");
INSERT INTO crnNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ajta aꞌɨ́ɨn ɨ́ Nacor, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Serug. Ajta aꞌɨ́ɨn ɨ́ Serug, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Ragau. Ajta aꞌɨ́ɨn ɨ́ Ragau, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Peleg. Ajta aꞌɨ́ɨn Peleg, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Heber. Ajta aꞌɨ́ɨn ɨ́ Heber, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Sala. ");
INSERT INTO crnNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ajta aꞌɨ́ɨn ɨ́ Sala, aꞌɨ́ɨ pu jetze airaújneijte Cainán. Ajta aꞌɨ́ɨn ɨ́ Cainán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Arfaxad. Ajta aꞌɨ́ɨn Arfaxad, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Sem. Ajta aꞌɨ́ɨn ɨ́ ɨ́ Sem, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Noé. Ajta aꞌɨ́ɨn ɨ́ Noé, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Lamec. ");
INSERT INTO crnNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ajta aꞌɨ́ɨn ɨ́ ɨ́ Lamec, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Matusalén. Ajta aꞌɨ́ɨn ɨ́ Matusalén, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Enóc. Ajta aꞌɨ́ɨn ɨ́ Enóc, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Jared. Ajta aꞌɨ́ɨn ɨ́ Jared, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Mahalaleel. Ajta aꞌɨ́ɨn ɨ́ Mahalaleel, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Cainán. ");
INSERT INTO crnNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ajta aꞌɨ́ɨn ɨ́ Cainán, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Enós. Ajta aꞌɨ́ɨn ɨ́ Enós, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Set. Ajta aꞌɨ́ɨn ɨ́ Set, aꞌɨ́ɨ pu jetze airaújneijte ɨ́ Adán. Ajta aꞌɨ́ɨn ɨ́ Adán, Dios pu jetzen airáane. ");
INSERT INTO crnNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tɨ́ꞌɨjí Jesús jemi huateájturaa ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. Tɨ́ꞌɨj ji aꞌuun u eꞌerájraa u Jordán. Tɨꞌɨj jí xɨéjniuꞌucareꞌaraꞌan pu yaꞌuvíꞌitɨ aꞌu tɨ caí éꞌe tiꞌitɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Aꞌuu pu éꞌetee aꞌachú cumu huaꞌapuate xɨcaj. Ajta aꞌɨ́ɨn tiyaaruꞌu, aꞌɨ́ɨ pu i tiúꞌujtesiꞌireꞌecaꞌa tɨ raamuáꞌitɨn tɨ́ꞌij autéꞌɨtzen ɨ́ Dios jemi. Ajta aꞌɨ́ɨn Jesús, capu tíꞌicuaꞌacáa tɨ́j naꞌa tɨ aꞌuun éꞌetee. Tɨ́ꞌɨj jí teꞌeraꞌastéesimeꞌeca ɨ́ huaꞌapuate xɨcaj, temuaꞌa pu jeíhua tiuꞌutáꞌicuatacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tɨꞌɨj jí ayén tiraataꞌixaa ɨ́ tiyaaruꞌu tɨjɨ́n: ―Tɨ́ puaꞌa hui yaujraꞌan pej púꞌeeneꞌen ɨ́ Dios, patáꞌaj raataꞌaíjteꞌen mɨ tetej tɨ pan huateújtaahua. ");
INSERT INTO crnNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: “Ɨ́ teáataꞌa, capu pan naꞌa jɨ́n ruuri aꞌame.” ");
INSERT INTO crnNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tɨꞌɨj jí tiyaaruꞌu pu yaꞌuvíꞌitɨ ɨ́ jɨrí japua. Tɨ́ꞌɨj i tiraataseíjra nainjapua tɨ́j naꞌa veꞌetɨ́ yen huatacáꞌa ɨ́ chaanaca japua, matɨ́j menaꞌa puaꞌamecɨé yen huachéjme i chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa piyen huárɨni pej títunuta ineetzi jemi, pajta naateánajche, nain nu muaatapuaíjveꞌesin pej múꞌee tíhuaꞌutaꞌaíjteꞌen, tɨ ij timuáacɨꞌɨti naíjmiꞌi tɨ́j naꞌa tɨ naa seijreꞌe tɨ huáꞌa jetze seijreꞌe. Ayee nu hui rɨni aꞌiné aꞌɨ́j nu jɨ́n antínmuaꞌaree, nej niyen raatapuaíjveꞌen ɨ́ jaꞌatɨ nej áꞌapuaijveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi tɨjɨ́n yee: “Setáꞌaj siyen senaꞌa rateáanajche ɨ́ tavástaraꞌa ɨ́ Dios. Aꞌɨ́j xuꞌu huatévaɨreꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","10","Tɨꞌɨj jí ajtahuaꞌa aꞌɨ́ɨn ɨ́ tiyaaruꞌu yaꞌuvíꞌitɨ jáꞌahuaꞌa yee, aꞌájna Jerusalén. An pu raꞌantivíꞌitɨ japuan u teyujtaꞌa, japuan ɨ́ tɨ jaítzeꞌe antípiti. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa hui pe yaujraꞌan pepúꞌeeneꞌen ɨ́ Dios, ancájvetzi múucɨ, aꞌiné ayée pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨjɨ́n: Dios pu á huajaꞌutaꞌíti ɨ́ mej jemin tíꞌivaɨreꞌe mej mi muáachaꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Memuaꞌancuréꞌeviꞌira múꞌeetzi pej pi caí á eꞌejváꞌɨtzɨꞌɨn. Aj mú mi muatétatza tɨ ij caí tiꞌitɨ́j aꞌij muáaruure. ");
INSERT INTO crnNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Tɨꞌɨj jí Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi tɨjɨ́n: “Capej tiꞌitɨ́j jɨ́n aꞌij tíꞌiraꞌihuaꞌura ɨ́ áꞌa Dios aisí tɨ puaꞌa ayén huárɨni aꞌij pej tíꞌijxeꞌeveꞌe múꞌee.” ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tɨ́ꞌɨj nain antipuáꞌari ɨ́ tiyaaruꞌu, tɨ tiꞌihuaújtesiꞌijre, aj pu i áꞌuraa. Capu chaꞌa aꞌuréꞌenineicaꞌa jemin ajta caí tejaꞌureꞌenén jaꞌanáj tɨ puaꞌa raaxɨ́ꞌepɨꞌɨntare tɨ ajtahuaꞌa huataújteseꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tɨꞌɨj jí Jesús áꞌuraa aꞌujna Galilea. Ajta ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios jemin pu huateájturaa. Ajta nainjapua tɨ aꞌuun huatacáꞌa, jeíhua mú teɨte ráamuaꞌareeriꞌi aꞌij tɨ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aꞌɨ́ɨ pu tihuaꞌumuáꞌate aꞌujna huaꞌatéyujtaꞌa. Majta meꞌɨ́n ɨ́ teɨte, aꞌɨ́ɨ mú rɨ́ꞌɨ tiraatáꞌa meꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tɨꞌɨj jí aꞌuun aꞌaráꞌa u Nazarét, aꞌu tɨ aꞌuvéꞌese. Tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna xɨcájraꞌan jetze mej puaꞌa ruseꞌupi, aꞌúu pu teyujtaꞌa aꞌuteájrupi tɨ́j tíꞌijrɨꞌɨrejcaꞌa. Tɨꞌɨj jí aꞌutéechaxɨ tɨ ij huaꞌutánamuajristeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Matɨ́ꞌɨj mi raatapíj ɨ́ yuꞌuxari tɨ jíriꞌi tɨ Isaías teecan raꞌuyúꞌuxacaꞌa, aꞌɨ́jna tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Tɨꞌɨj jí raatáxɨjtacaꞌa, aj pu ráꞌuteu aꞌij tɨ téꞌeyuꞌusiꞌi tɨ ayén tɨ jɨ́meꞌen yee: ");
INSERT INTO crnNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌúu pu hui huateáturaasin neetzi jemi, aꞌiné aꞌɨ́ɨ pu naꞌantíhuau, nej ni tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi ɨ́ niuucari jɨmeꞌe ɨ́ mej jɨ́n huataújtemuaꞌaveꞌesin. Aꞌuu pu hui nejaꞌutaꞌítecaꞌa nej nuꞌu tihuaꞌutáꞌixaateꞌen aꞌɨ́mej ɨ́ mej námiꞌi tɨjɨ́n yee nuꞌuri amuaꞌirátuaasin. Ajta nej nuꞌu tihuáꞌuhuaateꞌen ɨ́ mej aracúcuꞌunijmee mej mi majtáhuaꞌa mé uunéjneꞌeri, ajta nej nuꞌu huáꞌa japua huániuuni aꞌɨ́mej ɨ́ mej rajpuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ajta nej nuꞌu huaꞌutáꞌixaateꞌen tɨjɨ́n: “Ijii puꞌuri xaa tejaꞌuréꞌene aꞌɨ́jna ɨ́ nineꞌiraꞌa jetze ɨ́ tɨ hui tavástaraꞌa rɨ́ꞌɨ tihuaꞌutáꞌasin.” Ayee pu tiraꞌujíjve ɨ́ yuꞌuxari jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Tɨꞌɨj jí ratéejire ɨ́ yuꞌuxari, tɨ́ꞌɨj i raatapíj ɨ́ tɨ tíꞌivaɨreꞌe u teyujtaꞌa. Ajta aꞌujyeíjxɨ. Naímiꞌi matɨ́j menaꞌa aꞌúu mej huiiráteꞌecaꞌa, aꞌɨ́ɨ mú raseíjracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aj pu i aꞌutéjche tɨ ayén tihuaꞌutáꞌixaateꞌen tɨjɨ́n: ―Ijii pu hui ayén teꞌaraúraste múꞌejmi jemi aꞌij tɨ téꞌeyuꞌusiꞌi aꞌíjna jetze ɨ́ sej seri ráanamuajriꞌi. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Naíjmiꞌica pu huaꞌaránajchecaꞌa. Aꞌɨ́ɨj mú jɨ́n naa rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́jna jɨmeꞌe tɨ naa namuajreꞌe ɨ́ niuucari tɨ raataxájtacaꞌa. Ayee mú tiúꞌurihuaꞌuracaꞌa tɨjɨ́n: ―¿Ni caí aꞌɨ́ɨn púꞌeen ɨ́ yaujraꞌan ɨ́ José? ¿Aꞌiné hui auj tíꞌirɨꞌɨri? ");
INSERT INTO crnNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tɨꞌɨj jí Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Jee tzɨ́teꞌe, ayée pu hui tináꞌamitɨejteꞌe ineetzi sej siyen tinaatáꞌixaateꞌesin aꞌíjna i niuucari tɨ ayén namuajreꞌe tɨjɨ́n: “Mɨ́ pej tíꞌihuaꞌataca, patáꞌaj tihuáꞌahuaateꞌen aseɨ́j. Patáꞌaj piyen cheꞌatá penaꞌa huárɨni ayajna pej éꞌemeꞌecan aꞌij pej nuꞌu peri tiúꞌuruu aꞌujna jáꞌahuaꞌa Capernaúm ɨ́ tej teri ráamuaꞌareeriꞌi.” ");
INSERT INTO crnNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","’Ayee nu hui tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, camu jaꞌanáj raꞌancuréꞌeviꞌitɨ jaꞌatɨ tɨ Dios jetze meꞌecan tíꞌixaxaꞌa aꞌɨ́ɨme ɨ́ mej meꞌuun huachéjme aꞌujna tɨ éꞌemeꞌecan aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","’Jee tzɨ́teꞌe, ayén tiꞌayajna, ajmíꞌi tɨ auj seijreꞌecaꞌa aꞌɨ́jna ɨ́ Elías, muꞌiitɨ́ mú hui seijreꞌecaꞌa íiye Israél aꞌɨ́ɨme ɨ́ ꞌuuca mej ruséɨjta muáꞌaraa. Aꞌájnáꞌɨmua, puꞌuri mú auuméꞌe aꞌachú cumu huaíca nineꞌiraꞌa japuan jáꞌitaꞌa mej caí chéꞌe viiye. Ajta, jeíhua pu huatújriꞌihuacaꞌa nainjapua tɨ́j naꞌa aꞌuun tɨ huatacáꞌa u Israél. ");
INSERT INTO crnNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","’Mɨ́ ajta, aꞌɨ́ɨn Dios capu hui raataꞌítecaꞌa aꞌɨ́jna ɨ́ Elías tɨ huáꞌa jemi áꞌumeꞌen aꞌɨ́mej jemi ɨ́ ꞌuuca ɨ́ mej Israél jetze éꞌemeꞌecan sino ayée pu tiraataꞌaíj tɨ aꞌuun áꞌumeꞌen aꞌɨ́jna jemi ɨ́ ꞌɨ́itaꞌa tɨ ruséɨjta jáꞌaraa, aꞌɨ́jna tɨ aꞌuun éꞌechejcaꞌa u Sarepta, chajtaꞌa tɨ aꞌuun seɨ́j chuéjraꞌa japua eꞌejtémeꞌecantacaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Sidón. ");
INSERT INTO crnNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","’Ajta tɨ́ꞌɨj auj tiꞌitéveecaꞌa aꞌɨ́jna ɨ́ Eliseo tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, muꞌiitɨ́ mú hui tíꞌicucuiꞌicaꞌa ɨ́ teɨte aꞌɨ́jna jɨmeꞌe ɨ́ tɨ tineájxɨ huáꞌahuaꞌiraꞌa jetze. Muꞌiitɨ́ mú seijreꞌecaꞌa íiyen Israél. Mɨ́ ajta, capu jaꞌatɨ tihuáꞌuhuaa sino aꞌɨ́ɨ puꞌu, aꞌɨ́jna ɨ́ Naamán, Siria tɨ éꞌemeꞌecan. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jɨ́meꞌen muꞌu ráanamuajriꞌi ɨ́ teɨte mej teyujtaꞌa huiráatei, matɨ́ꞌɨj mi naímiꞌi huataníniuꞌucacucaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Caꞌanacan mú ájhuiixɨ. Matɨ́ꞌɨj mi yaꞌuvíꞌitɨ caꞌanéeri jɨmeꞌe, mej á puaꞌacɨé ruꞌirájtuaani u chajtaꞌa jetze. An mú yaꞌuréꞌeneijte aꞌu tɨ eꞌencátee ɨ́ jɨrí jetze ɨ́ tɨ japuan huachájtaꞌa. An mú raꞌancarɨénicheꞌe aꞌu tɨ eꞌencátee. ");
INSERT INTO crnNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mɨ́ ajta aꞌɨ́ɨn Jesús, jáꞌitaꞌa pu huáꞌa jetze tanéj. Tɨꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tɨꞌɨquí aꞌuun aꞌucáane u Capernaúm, chajtaꞌa tɨ aꞌuun jetze ajtémeꞌecan u Galilea. Tɨ́ꞌɨj tejaꞌuréꞌene aꞌájna xɨcájraꞌa mé jetzen ruseꞌupi, aꞌɨ́ɨ pu tihuaꞌumuáꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jéihua pu huáꞌa jetze ráavatzɨ ɨ́ niuucari aꞌiné tɨ́j ayén tihuaꞌutáꞌixaa, yee pu tihuaꞌutámitɨejteꞌe tɨjɨ́n: ―Xɨee tɨ cu veꞌecán jɨ́n tiꞌitéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Meenti seɨ́j ɨ́ teáataꞌa, aꞌúu pu aꞌutéveecaꞌa u teyujtaꞌa. Tiyaaruꞌu pu tzajtaꞌan seijreꞌecaꞌa, tɨ aꞌij puaꞌa ꞌeen. Caꞌanín pu jɨ́n raatajé aꞌɨ́jna ɨ́ jaꞌatɨ aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ayen tɨjɨ́n: ―Múꞌee, ¿aꞌiné tiꞌitɨ́j pej téꞌumuaꞌaree itejmi jemi, múꞌee Jesús, mɨ pej hui Nazarét éꞌemeꞌecan? ¿Ni piyen een jɨ́n yé taméj pej pi téjmi antipuáꞌajteꞌen? Némuamuaꞌate inee, jaꞌatɨ pej pɨ́rɨcɨ, mɨ pej Dios jemi rɨ́ꞌɨ tíꞌiseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Aj pu i Jesús jeíhua raꞌajtéꞌaxɨ ɨ́ tiyaaruꞌu tɨjɨ́n: ―Capej tiꞌitɨ́j xajta. Huirájraa hui mɨ tevi jetze. Ajta aꞌɨ́ɨn tiyaaruꞌu, aꞌɨ́ɨ pu ráꞌarɨe á chuaataꞌa mejseíiracaꞌa ɨ́ teɨte. Tɨꞌɨj jí, caí aꞌij ráaruu ɨ́ tevi, aj pu i huirájraa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Naímiꞌi mú rɨ́ꞌɨ tiraꞌutaseíj ɨ́ teɨte. Matɨ́ꞌɨj mi miyen tiuꞌutaúꞌixaa tɨjɨ́n: ―¿Tiꞌitáani niuucarijraꞌa jɨ́n tiꞌixa? Aꞌɨ́ɨ pu hui tihuáꞌaijteꞌe ɨ́ tiyáaruꞌuse. Xɨee tɨ cu aꞌɨ́jna jɨ́n antiújmuaꞌareere, aꞌiné rumuárɨꞌeriꞌireꞌaraꞌan pu jɨ́n tíꞌimuarɨꞌe mej mi huirácɨɨne ɨ́ tiyáaruꞌuse ɨ́ teɨte tzajtaꞌa. ―Ayee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ajta nainjapua tɨ aꞌuun huatacáꞌa, naímiꞌi mú ráamuaꞌareeriꞌi aꞌij tɨ Jesús tiꞌitɨ́j huáruu. ");
INSERT INTO crnNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tɨ́ꞌɨj jí huirájraa aꞌɨ́jna ɨ́ Jesús aꞌujna u teyujtaꞌa. Tɨꞌɨj jí aꞌuun aꞌaráꞌa ɨ́ Simón tɨ éꞌeche. Ajta aꞌɨ́ɨn ɨ́ muꞌuneáraꞌan ɨ́ Simón, aꞌɨ́ɨ pu tíꞌicuiꞌicaꞌa. Pɨ́stacareꞌe aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Matɨ́ꞌɨj mi raatáhuaviiriꞌi meꞌɨ́jna ɨ́ Jesús tɨ nuꞌu tiráahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Tɨ́ꞌɨj ji Jesús aicaújtutzi aꞌɨ́jna jemi. Tɨꞌɨj jí raꞌajtéꞌaxɨ ɨ́ tɨ jɨ́n tíꞌicuiꞌi. Aj pu i huateápuaꞌarecaꞌa ɨ́ cuíꞌiniꞌiraꞌa. Jɨ́meꞌen puꞌu huateápuaꞌarecaꞌa ɨ́ cuíꞌiniꞌiraꞌa, aj pu i ájchee aꞌɨ́jna tɨ tíꞌicuiꞌicaꞌa. Tɨꞌɨj jí aꞌɨ́ɨn tihuaꞌumí. ");
INSERT INTO crnNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tɨ́ꞌɨj huaréꞌecɨeenarecaꞌa ɨ́ xɨcaj, aꞌɨ́ɨme ɨ́ teɨte huaꞌuréꞌenejteꞌaxɨ ɨ́ Jesús jemi naíjmiꞌica ɨ́ mej tiꞌicúcuiꞌijme. Capu tíꞌiseicaj naꞌa ɨ́ cuíꞌiniꞌiraꞌa. Aꞌɨ́ɨ pu huaꞌajtamuárɨꞌexɨ seɨj ajta seɨj. Tɨꞌɨj jí naíjmiꞌica tiúꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Majta meꞌɨ́n ɨ́ tiyáaruꞌuse ɨ́ mej teɨte tzajtaꞌa seijreꞌecaꞌa, naíjmiꞌi mú huiráacɨ. Matɨ́ꞌɨj mi miyen caꞌanín jɨ́n tiraatajé tɨjɨ́n: ―Múꞌee pe yaujraꞌan púꞌeen ɨ́ Dios. Mɨ́ ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu huaꞌajtéꞌaxɨ. Capu huaꞌutáꞌa mej tiuꞌutaxáj aꞌiné méjmuaꞌareerecaꞌa tɨjɨ́n aꞌɨ́ɨ pu aꞌɨ́ɨn pɨ́rɨcɨ Dios tɨ án yáꞌujra ɨ́ ɨpuari japua. ");
INSERT INTO crnNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tɨ́ꞌɨj tapuáꞌarijmeꞌeca, aj pu i huirájraa u chiꞌita ɨ́ Jesús. Aꞌuu pu aꞌaráꞌa aꞌu tɨ caí éꞌe tiꞌitɨ. Majta meꞌɨ́n ɨ́ teɨte, aꞌɨ́ɨ mú ráahuausimeꞌe. Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌu tɨ aꞌij éeneꞌe. Méjxeꞌeveꞌecaꞌa tɨ caí áꞌuraꞌani, tɨ aꞌuun aꞌuteáturan aꞌɨ́mej jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mɨ́ ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu ajta tiúꞌujxeꞌeveꞌe nej tihuaꞌutáꞌixaateꞌen ɨ́ seica ɨ́ teɨte mej méyee huachéjme neꞌɨ́jna jɨmeꞌe ɨ́ niuucari tɨ rɨ́ꞌɨ tihuaꞌutáꞌasin, ɨ́ tɨ ajta jɨ́meꞌen raxájta tɨ aꞌɨ́ɨn Dios yen huataseíjreꞌesin íiyen chaanaca japua tɨ i yen tiuꞌutaꞌaíjta tɨ́j naꞌa veꞌetɨ́ yen seijreꞌe. Ayee nu hui ꞌeen jɨ́n mú aꞌuvéꞌemej. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ajta aꞌɨ́ɨn Jesús, aúcheꞌe pu tihuáꞌaꞌixaateꞌecaꞌa u tihuaꞌatéyujtaꞌa jetze tɨ́j naꞌa aꞌuun tɨ huatacáꞌa u Judea. ");
INSERT INTO crnNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jaꞌanáj tɨ ayén tiujuꞌurɨ́j tɨ aꞌɨ́ɨn Jesús aꞌuun aꞌutéveecaꞌa aꞌu tɨ jaj eꞌeveꞌeꞌástɨme tɨ ayén téjaꞌarájtehuaa tɨjɨ́n: Genesaret. Jéihua mú teɨte ajteáxɨɨrecaꞌa aꞌɨ́jna jemi. Aꞌɨ́ɨ mú ranamuájracaꞌa ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tɨꞌɨj jí Jesús huaꞌapuaca huaseíj ɨ́ baarcu mé eꞌecáviviɨ́jmeꞌecaꞌa ɨ́ mej huaꞌité jetze viviꞌi. Majta aꞌɨ́ɨme, muꞌuri tíꞌijaꞌusicaꞌa ɨ́ tiúꞌujxɨejmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tɨꞌɨj jí Jesús ateájraa ɨ́ seɨ́j jetze ɨ́ baarcu, aꞌɨ́jna Simón tɨ racɨi. Tɨꞌɨj jí ayén tiraatáhuaviiriꞌi aꞌɨ́jna ɨ́ Simón tɨ aꞌatzu ɨmuá huatéchaxɨn á jaataꞌa. Tɨꞌɨj jí aꞌujyeíjxɨ. A pu aracaíi tihuáꞌamuaꞌate ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tɨ́ꞌɨj raatapuáꞌajtacaꞌa tɨ tihuáꞌixaateꞌe, aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Simón tɨjɨ́n: ―Patáꞌaj jaítzeꞌe aꞌɨmuá huatéchaxɨn aꞌu tɨ jaítzeꞌe auutɨ́ꞌɨ ɨ́ jaj. Pajta raꞌatéhuaꞌaxɨn mɨ áꞌaxɨejmuaꞌa patáꞌaj huaꞌité huavíviꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón pu ayén tiuꞌutaniú tɨjɨ́n: ―Maestro, tuꞌuri huatáxaꞌai tej tíꞌimuarɨꞌe. Catu tiꞌitɨ́j huatéeviꞌi. Capu amɨ́n aꞌij, aꞌiné múꞌee pe hui piyen tinaatáꞌixaa, ayée nu rɨni. ");
INSERT INTO crnNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Matɨ́ꞌɨj mi raꞌatéehuaꞌaxɨ ɨ́ ruxɨejmuaꞌa. Ayee mú jɨ́n huarɨ́j, jeíhua mú huápɨꞌɨ huaꞌitátɨɨ. Tɨ́n pu huatésiujtzaꞌanixɨ ɨ́ huáꞌaxɨejmuaꞌa ɨ́ huaꞌité jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Matɨ́ꞌɨj mi huaꞌutajé ɨ́ ruꞌamiigustemuaꞌa ɨ́ mej aráatei ɨ́ seɨ́j jetze ɨ́ baarcu, mej mi mú aꞌuréꞌenen matáꞌaj huaꞌutévaɨreꞌen. Matɨ́ꞌɨj mi aꞌuréꞌene. Matɨ́ꞌɨj mi huaꞌavéꞌejɨ́steꞌaxɨ ɨ́ huaꞌité ɨ́ baarcu jetze. Tɨ́n mú ateárutixɨ aꞌɨ́jna jɨmeꞌe mej avéꞌejɨstecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ajta aꞌɨ́ɨn Simón, jɨ́meꞌen puꞌu raaseíj, aj pu i títunutacaꞌa ɨ́ Jesús jemi. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Áꞌuraꞌa ineetzi jemi, nevástaraꞌa, aꞌiné jeíhua nu auteájturaa múꞌeetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ayee pu tiuꞌutaxájtacaꞌa aꞌiné jeíhua pu naa rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́jna jɨmeꞌe mej huápɨꞌɨ jeíhua huaꞌuvíviꞌi ɨ́ huaꞌité. ");
INSERT INTO crnNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ayee mú cheꞌatá menaꞌa naa rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan. Aꞌɨ́ɨ pu huaꞌatáàta aꞌɨ́jna ɨ́ Zebedeo. Majta aꞌɨ́ɨme, aꞌɨ́ɨ mú jemin tíꞌimuarɨꞌe jamuan ɨ́ Simón. Tɨꞌɨj jí aꞌɨ́ɨn Jesús, ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Simón tɨjɨ́n: ―Capej tíꞌitziɨɨneꞌe. Ijii tɨ yú aucaꞌitɨ́ aꞌame, neetzi jemi pepuꞌu hui teɨte tíseɨreꞌesin. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Matɨ́ꞌɨj mi huaꞌitajájpuaxɨ ɨ́ baarcu aꞌu tɨ aꞌuhuáchi. Matɨ́ꞌɨj mi nain tejeꞌetiáꞌa. Matɨ́ꞌɨj mi aꞌucɨ́j jamuan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Aꞌájnáꞌɨmua, tɨ́ꞌɨj Jesús aꞌuun aꞌutéveecaꞌa aꞌájna jáꞌahuaꞌa chajtaꞌa, seɨ́j pu eꞌiréꞌene jemin. Temuaꞌa pu jeíhua tiꞌicáꞌatza aꞌɨ́jna jɨmeꞌe tɨ tineájxɨ ɨ́ huáꞌireꞌaraꞌan jetze. Tɨ́ꞌɨj raaseíj, aj pu i títunutacaꞌa jemin ɨ́ Jesús. Aa pu chuáataꞌɨmua éꞌetia runéerime jɨmeꞌe. Ayee pu tíꞌijree tɨjɨ́n: ―Nevástaraꞌa, tɨ puaꞌa hui muaꞌaráanajche pej tináahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tɨꞌɨj jí Jesús huatamuájcaꞌatacaꞌa. Ayee pu tiraataꞌixaa tɨjɨ́n: ―A niꞌijtá neꞌu, naꞌaráanajche nej timuáahuaateꞌen. Pepuꞌuri hui huarúj. Jɨ́meꞌen puꞌu ayén tiraataꞌixaa, aj pu i xaa huarúj icu. ");
INSERT INTO crnNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tɨꞌɨj jí Jesús ayén tiraataꞌaíj tɨjɨ́n: ―Capej jaꞌatɨ ixaateꞌe sino aꞌuun pej áꞌumeꞌen jemin ɨ́ tɨ tíꞌivaɨreꞌe u teyujtaꞌa. Patáꞌaj jaꞌutáꞌaseijrata jemin aꞌɨ́jna. Pajta piyen tiuꞌutámuaɨꞌɨvejta aꞌij tɨ tiuꞌutaꞌaíjtacaꞌa aꞌɨ́jna ɨ́ Moisés teecan mej mi ráamuaꞌaree tɨjɨ́n pepuꞌuri huarúj. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Majta meꞌɨ́n ɨ́ teɨte, nainjapua mú ráamuaꞌareeriꞌi aꞌij tɨ Jesús huarɨ́j. Tɨ́j naꞌa tiꞌitápuaapuaꞌare, jaítzeꞌe mú ranamuájracaꞌa. Aꞌɨ́j mú jɨ́n, jeíhua mú ajteáxɨɨrecaꞌa ɨ́ teɨte ɨ́ Jesús jemi tɨ aꞌɨ́ɨn tihuáꞌuhuaateꞌen aꞌɨ́jna jɨmeꞌe ɨ́ mej tíꞌicucuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ajta aꞌɨ́ɨn Jesús, jaꞌanáj tɨ naꞌa pu aꞌuun eꞌetánineicaꞌa aꞌu tɨ caí éꞌe tiꞌitɨjcaꞌa tɨ́ꞌij ruseɨ́j huatéjniuuni. ");
INSERT INTO crnNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ayee pu tiujuꞌurɨ́j aꞌajnáꞌɨmua. Muꞌiitɨ́ mú á eꞌiréꞌene ɨ́ teɨte tɨ́j naꞌa aꞌuun mej aꞌuchéjme aꞌujna u Galilea, ajta aꞌujna u Judea, ajta aꞌujna u Jerusalén. Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata aꞌij tɨ téꞌeyuꞌusiꞌi jetzen ɨ́ yuꞌuxari jetze ɨ́ Moisés teecan tɨ raꞌuyúꞌuxacaꞌa. Aꞌɨ́ɨ mú huiiráteꞌecaꞌa ɨ́ Jesús jamuan. Ajta ɨ́ muárɨꞌeriꞌireꞌaraꞌan ɨ́ tavástaraꞌa, aꞌɨ́ɨ pu jemin huateájturaa tɨ́ꞌij tihuáꞌuhuaateꞌen ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Majta seica aꞌuun eꞌiréꞌene. Tevij mú huáchuisimeꞌe, itari japua meraꞌujtéca. Nainjapua pu cɨyáaxaraꞌacaꞌa ɨ́ ru jetze aꞌɨ́jna ɨ́ jaꞌatɨ. Aꞌɨ́ɨ mú huataújtese mej ruꞌuteájtuaani u chiꞌita mej mi yenuꞌuhuaréꞌeten ɨ́ Jesús jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mɨ́ ajta caí capu huatárɨꞌɨristarecaꞌa aꞌiné jeíhua mú teɨte aitéujseɨreꞌecaꞌa táꞌapueerta. Matɨ́ꞌɨj mi anticɨ́j japuan ɨ́ chiꞌij. Matɨ́ꞌɨj mi raꞌanáacu. Aꞌɨ́ɨ mú jɨ́n ayén huarɨ́j, matɨ́ꞌɨj ruꞌucájtuaa japuan meruꞌujtéca ɨ́ itari. Aꞌuu mú ruꞌucájtuaa huáꞌa tzajtaꞌa ɨ́ teɨte aꞌu tɨ Jesús aꞌutéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tɨ́ꞌɨj Jesús huaꞌuseíj aꞌɨ́mej, aj pu i xaa ráamuaꞌareeriꞌi tɨjɨ́n metéꞌatzaahuateꞌe, tzɨ́teꞌe. Tɨꞌɨj jí ayén tiraataꞌixaa aꞌɨ́jna tɨ cɨyáaxaraꞌa tɨjɨ́n: ―Neꞌamiigu, nuꞌuri timuaatáꞌuuniꞌiriꞌi ɨ́ pej hui jɨ́n auteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Majta meꞌɨ́n ɨ́ fariseos, majta meꞌɨ́n ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, aꞌɨ́ɨ mú autéjhuii mej miyen tíꞌimuaꞌatze ɨ́ ru tzajtaꞌa tɨjɨ́n: ―¿Aꞌataqui hui pɨ́rɨcɨ amɨ́jna mɨ jaꞌatɨ tɨ ayén aꞌij puaꞌa tiꞌixa ɨ́ Dios jemi? Seɨ́j puꞌu naꞌa aꞌɨ́ɨn púꞌeen tɨ tihuaꞌutáꞌuuniꞌi ɨ́ teɨte ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi. Dios pu aꞌɨ́ɨn púꞌeen tɨ ayén tihuaꞌutáꞌuuniꞌi. Ajta amɨ́n, capu hui aꞌɨ́jna jɨ́n antiújmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu ruseɨ́j rúꞌumuaꞌareerecaꞌa aꞌij mej tíꞌimuaꞌajca. Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné hui ꞌeen jɨ́n siyen tíꞌimuaꞌatze ɨ́ ru tzajtaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tiꞌitáani jaítzeꞌe muárɨꞌeri? ¿Ni jaítzeꞌe muárɨꞌeri nej niyen tiraataꞌixaateꞌen neꞌɨ́jna tɨ cɨyáaxaraꞌa yee: “Nuꞌuri timuaatáꞌuuniꞌiriꞌi ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi”, naꞌari yee: “Ájchesi, mé pej taméꞌen”? Jee xaa neꞌu, ayée nu tejáꞌamuaꞌixaateꞌe neꞌíjna jɨmeꞌe tɨ jaítzeꞌe muárɨꞌeri nej niyen tiraataꞌixaateꞌen yee: “Ájchesi, mé pej taméꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","’Aru sej si ráamuaꞌaree ɨ́ nej hui xaa neꞌɨ́jna jɨ́n antínmuaꞌaree íiyen chaanaca japua nej ni tihuaꞌutáꞌauuniꞌi ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi, ayée nu huárɨni inee i nej neajta huáꞌa jetze airáane ɨ́ teɨte. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna tɨ cɨyáaxaraꞌa tɨjɨ́n: ―Neꞌamiigu, ayée nu tíꞌimuaꞌixaateꞌe tɨjɨ́n, ajchesi hui, pajta raꞌanchuén mɨ áꞌutaatzi. Aricu áꞌuraa u áꞌache. ");
INSERT INTO crnNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jɨ́meꞌen puꞌu ayén tiraataꞌixaa, aj pu i aꞌɨ́ɨn tɨ cɨyáaxaraꞌa, ájchee, yáꞌuchuii ɨ́ rúꞌutaatzi. Tɨꞌɨj jí rɨ́ꞌɨ tiraatajé ɨ́ tavástaraꞌa. Tɨ́ꞌɨj i áꞌuraa ɨ́ ruche. ");
INSERT INTO crnNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Naímiꞌi mú naa rɨ́ꞌɨ tiraꞌutaseíj. Jéꞌecan mú rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios jemi. Majta caí chaꞌa aꞌij tirájteuveꞌe. Ayee muꞌu tɨjɨ́n: ―Ijii tu xaa tiꞌitɨ́j huaseíj tɨ huápɨꞌɨ ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aꞌatzu aꞌateeviꞌi, aj pu i Jesús áa aꞌuréꞌene. Seɨ́j pu jaꞌatɨ huaseíj tɨ tíꞌitejiꞌivi. Ayee pu ántehuaa tɨjɨ́n Leví. Aꞌuu pu eꞌirájca u chiꞌita aꞌu mej titejéꞌejiꞌivi. Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Patáꞌaj hui nee jamuan áꞌucheꞌecaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Tɨꞌɨj jí aꞌɨ́ɨn Leví ájchee. Naímiꞌi pu tejeꞌetiáꞌa. Tɨꞌɨquí jamuan áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tɨꞌɨquí aꞌɨ́ɨn Leví tiuꞌuyéꞌeste ɨ́ ruche aꞌɨ́jna jɨmeꞌe tɨ ari Jesús jamuan áꞌucheꞌecan. Majta meꞌɨ́n ɨ́ mej tíꞌitejiꞌivi, majta seica, aꞌɨ́ɨ mú huáꞌa jamuan tíꞌicuaꞌacaa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Majta aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌataca ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa, aꞌɨ́ɨ mú autéjhuii mej tihuaꞌuxájtziꞌi aꞌɨ́mej jemi ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. Ayee mú tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n siyen huáꞌa jamuan tíꞌicuaꞌaca, seajta hui yeꞌeca jamuan ɨ́ mej tíꞌitejiꞌivi, seajta huáꞌa jamuan ɨ́ mej aꞌij puaꞌa rɨjcaa? ");
INSERT INTO crnNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe. Ayee pu hui ꞌeen jɨ́meꞌen ɨ́ teɨte ɨ́ mej áꞌucɨꞌɨcaꞌan jemin ɨ́ tɨ yaꞌanaca. Capu ruxeꞌeveꞌe mej áꞌucɨꞌɨcaꞌan jemin ɨ́ mej rɨ́ꞌen sino aꞌɨ́ɨme muꞌu hui ɨ́ mej tíꞌicucuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mɨ́ neajta inee, canu hui neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej nej ni neꞌɨ́mej huatájeeve aꞌɨ́mej ɨ́ tɨ ayén tihuáꞌamitɨejteꞌe yee xɨ́ꞌepɨꞌɨn mú rɨcɨ sino aꞌɨ́mej nuꞌu ɨ́ mej rúꞌumuaꞌaree ɨ́ ru tzajtaꞌa ɨ́ mej caí xɨ́ꞌepɨꞌɨn rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi ɨ́ Jesús tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ mej hui Juan jamuan áꞌujujhuaꞌan, jeíhua mú rúꞌitziꞌivi, majta huatéjniuuve ɨ́ Dios jemi. Ayee mú cheꞌatá menaꞌa rɨcɨ aꞌɨ́ɨme ɨ́ fariseos. Mɨ́ majta, aꞌɨ́ɨme hui ɨ́ mej á jamuan áꞌujujhuaꞌan, metijíꞌicuaꞌaca, majta yeꞌeca, micu. ");
INSERT INTO crnNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ huaténeꞌɨche, aꞌɨ́ɨ pu ajta ruꞌamiigustemuaꞌa huatáꞌinen mej mi tiúꞌuyesten. Aj pu i tihuáꞌamicuan. ¿Ni qui miyen tiúꞌuritziꞌiveꞌe tɨ́ꞌɨj auj huáꞌa jamuan aꞌutéveeca? Camu xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","’Mɨ ajta, aúcheꞌe pu hui tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌa tɨ jetzen raꞌajján aꞌɨ́jna tɨ huaténeꞌɨche. Aj mú xaa amiigustemuaꞌameꞌen ruꞌítziꞌiveꞌen aꞌiné capu chéꞌe méꞌe jáꞌahuaꞌa ɨ́ huaꞌamiigu. Aꞌiné naúcheꞌe nu yé huatéjvee, camu hui ruꞌítziꞌiveꞌen ɨ́ neꞌamiigustemuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Seɨ́j pu tihuaꞌutáꞌixaa ɨ́ niuucari tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ ráꞌacuꞌuneꞌepua ɨ́ cɨ́ɨxuri tɨ míꞌimeꞌecan, capu aꞌɨ́jna jɨ́n ráꞌacuꞌuneꞌepua cɨ́ɨxuri jɨmeꞌe tɨ caí xɨ jaꞌanáj jáꞌusiniꞌi. Tɨ́ puaꞌa ayén aꞌɨ́jna jɨ́n ráꞌacuꞌuneꞌepua, aꞌɨ́ɨ pu huatétzuꞌuta aꞌɨ́jna ɨ́ cɨ́ɨxuri tɨ jéjcua tɨ́ꞌɨj huatéjaꞌusiniꞌihua. Tɨꞌɨj jí raꞌatésiujtzaꞌanaxɨꞌɨsin ɨ́ tɨ míꞌimeꞌecan. Aj pu i, ɨ́ tɨ anásiujtzaꞌani, jaítzeꞌe pu hui veꞌetɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","’Ajta camu miyen rɨjcaa mej ruꞌucájtuꞌani navij limeetajraꞌa tzajtaꞌa tɨ cáraꞌajchiraꞌa viinu tiꞌitɨ́j mej mauchén ráataahuacaꞌa. Tɨ́ puaꞌa miyen ráaruuren, aꞌɨ́jna ɨ́ viinu tɨ jéjcua, aꞌɨ́j pu jetze huiitaxɨ́jsin ɨ́ eeca, ajta autasiújtzaꞌani ɨ́ navij tɨ cáraꞌajchiraꞌa. Aj pu i aꞌuvaɨ́jtzi ɨ́ navij, ajta hui ɨ́ viinu. ");
INSERT INTO crnNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Aꞌɨ́j pu hui jɨ́n ayén tiúꞌujxeꞌeveꞌe tɨ iruꞌucájtuꞌani navij tzajtaꞌa tɨ jéjcua aꞌɨ́jna ɨ́ viinu tɨ ajta jéjcua, icu. ");
INSERT INTO crnNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","’Ajta, matɨ́ꞌɨj raꞌantiꞌí ɨ́ viinu tɨ míꞌimeꞌecan, capu jaꞌatɨ ayén raxɨ́ꞌeveꞌe tɨ raꞌantiyéꞌen ɨ́ tɨ jéjcua aꞌiné ayée pu tiráꞌamitɨejteꞌe tɨ jɨ́meꞌen yee jaítzeꞌe pu hui ajmeꞌiraꞌa ɨ́ tɨ míꞌimeꞌecan caí ɨ́ tɨ jéjcua. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ayee pu ajta tiujuꞌurɨ́j aꞌájna ɨ́ xɨcájraꞌa mej jetzen ruseꞌupi. Aa pu auméꞌecaa jáꞌitaꞌa u víꞌiraꞌataꞌa ɨ́ Jesús. Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú autéjhuii mej rúꞌijtzaanaxɨꞌɨn tiꞌitɨ́j atzi tɨ triigu jetze huijneájxɨ. Matɨ́ꞌɨj mi raatémuatɨꞌɨsixɨ ɨ́ rumuájcaꞌa jetze. Majta autéjhuii mej ráacuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Majta aꞌɨ́ɨme ɨ́ fariseos, seica mú á vejliꞌi aꞌutéꞌuucaꞌa. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Jesús. Miyen tɨjɨ́n: ―¿Aꞌiné hui ꞌeen jɨ́n piyen tíꞌimuarɨꞌe tiꞌitɨ́j tɨ nuꞌu caí rɨꞌɨrí tɨ ayén tiꞌitɨ́j úꞌuruuren aꞌájna xɨcájraꞌa mej jetzen puaꞌa ruseꞌupi? ");
INSERT INTO crnNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni secaí múꞌeen jaꞌanáj raꞌujíjve ɨ́ yuꞌuxari jetze aꞌij tɨ huarɨ́j aꞌɨ́jna ɨ́ David teecan tɨ́ꞌɨj huataꞌíꞌicuatacaꞌa, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aꞌuu pu hui aꞌuteájrupi u teyujtaꞌa, ɨ́ tɨ jee chiꞌiraꞌan púꞌeen ɨ́ Dios. Ajta áꞌiyen, aꞌɨ́ɨ pu ruꞌirájɨꞌɨpɨ ɨ́ pan mej Dios huatámuaɨꞌɨvejte. Tɨꞌɨj jí ráacua. Ajta aꞌɨ́mej tiuꞌumí ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aꞌɨ́jna ɨ́ pan, aꞌɨ́ɨ muꞌu racuaꞌaca aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe aꞌujna teyujtaꞌa. Capu hui tiꞌitɨ́j aꞌij huarɨ́j aꞌɨ́jna jemi ɨ́ David teecan. ");
INSERT INTO crnNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ajta ayén tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, ayée nu hui ꞌeen jɨ́n antínmuaꞌaree neajta neꞌɨ́jna xɨcájraꞌan mej jetzen ruseꞌupi. ―Ayee pu tihuaꞌutáꞌixaa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ajtahuaꞌa, seɨ́j jetze ɨ́ xɨcáaraꞌan mej jetzen ruseꞌupi, aꞌúu pu aꞌuteájrupi u teyujtaꞌa. Aꞌuu pu tihuáꞌamuaꞌatejcaꞌa. Ajta seɨ́j aꞌúu pu unúꞌujveecaꞌa tɨ cɨyáaxaraꞌa ɨ́ rumuájcaꞌa jetze, rurɨꞌɨríintaꞌan pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Majta meꞌɨ́n ɨ́ fariseos, majta meꞌɨ́n ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze tɨ raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, aꞌɨ́ɨ mú rajeevecaꞌa tiꞌitɨ́j mej jɨ́meꞌen jetzen teꞌujpuáꞌajteꞌen. Ayee mú tíꞌimuaꞌajca yee aisí tɨ puaꞌa caí seɨ́j tiúꞌuhuaateꞌen, aꞌíjna xɨcájraꞌa tej jetzen taseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mɨ́ ajta Jesús, aꞌɨ́ɨ pu rúꞌumuaꞌareerecaꞌa aꞌij mej tíꞌimuaꞌajca. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna tɨ rumuájcaꞌa jetze cɨyáaxaraꞌa tɨjɨ́n: ―Ájchesi. Mé huatéchaxɨ mé jáꞌitaꞌa. Aj pu i ájchee. Aa pu aꞌutéechaxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tɨꞌɨj jí Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejámuaataꞌíhuaꞌura tiꞌitɨ́j tɨ íꞌirɨꞌɨri aꞌíjna xɨcájraꞌa tej jetzen taseꞌupi. ¿Ni qui íꞌirɨꞌɨri tɨ jaꞌatɨ ayén ráaruuren ɨ́ tɨ íꞌixɨꞌepɨꞌɨn naꞌari ɨ́ tɨ aꞌij puaꞌa ꞌeen? ¿Ni qui ajta íꞌirɨꞌɨri tɨ seɨ́j huiirájtuaa tɨ ij aꞌɨ́ɨn caí huámɨꞌɨni naꞌari hui tɨ raajéꞌica? ");
INSERT INTO crnNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tɨꞌɨj jí Jesús huaꞌuseíirajraa aꞌɨ́mej ɨ́ mej áa eꞌenvéjmeꞌecaa. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna tɨ cɨyáaxaraꞌa ɨ́ rumuájcaꞌa jetze tɨjɨ́n: ―Huatátzeaara hui muaꞌa muájcaꞌa. Aj pu i raatátzeaaracaꞌa. Jɨ́meꞌen puꞌu ayén huarɨ́j, aj pu i huarúj. ");
INSERT INTO crnNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Majta meꞌɨ́n ɨ́ fariseos, jéꞌecan mú huataníniuꞌucacucaꞌa meꞌɨ́jna jɨmeꞌe mej caí aꞌij tirájteu aꞌij mej yeꞌí jɨ́meꞌen jetzen teꞌujpuáꞌajteꞌen. Matɨ́ꞌɨj mi autéjhuii mej tiꞌitiúrixaateꞌen yee aꞌij mej yeꞌí ráaruuren meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Aꞌájnáꞌɨmua, Jesús pu áꞌume jɨrí tzajtaꞌa tɨ́ꞌij huatéjniuuni ɨ́ Dios jemi. Huatáxaꞌii tɨ huatéeniu. ");
INSERT INTO crnNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tɨ́ꞌɨj tapuáꞌarijmeꞌeca, aꞌɨ́ɨ pu huaꞌutajé aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Tɨꞌɨj jí huaꞌavéꞌejajpuaxɨ aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua mej aráꞌase. Ayee pu huaꞌutamuáꞌa tɨjɨ́n apóstoles, tɨ ayén huataújmuaꞌa tɨjɨ́n seɨ́j tɨ tiuꞌutaꞌaíjtiꞌire. Ayee mú huataújmuaꞌa aꞌɨ́ɨme ɨ́ mej tiuꞌutaꞌaíjtiꞌire. ");
INSERT INTO crnNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15","Aꞌii mú aꞌɨ́ɨn púꞌeen ɨ́ tɨ huaꞌavéꞌejajpuaxɨ. Amuacaícan, aꞌɨ́j pu huatajé aꞌɨ́jna ɨ́ Simón, ɨ́ mej majta miyen raatamuáꞌa tɨjɨ́n Pedro. Aj pu ijtáꞌi aꞌɨ́jna huatajé ɨ́ Andrés. Juutzeájraꞌan pu púꞌeen aꞌɨ́jna ɨ́ Simón. Seica pu ajta huatajé. Aꞌɨ́ɨme mú aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan, ajta aꞌɨ́jna ɨ́ Felipe. Aꞌɨ́j pu ajta huatajé aꞌɨ́jna ɨ́ Bartolomé, ajta aꞌɨ́jna ɨ́ Mateo, ajta aꞌɨ́jna ɨ́ Tomás, ajta aꞌɨ́jna ɨ́ Jacobo. Aꞌɨ́ɨ pu yaujraꞌan púꞌeen ɨ́ Alfeo. Jesús pu ajta aꞌɨ́jna huatajé ɨ́ Simón. Aꞌɨ́mej pu jetze ajtémeꞌecan aꞌɨ́ɨme ɨ́ mej miyen huaꞌatamuáꞌamua tɨjɨ́n ɨ́ mej raayɨ́ꞌɨtɨ mej huanéꞌuseꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Aꞌɨ́mej pu ajta huatajé aꞌɨ́jna ɨ́ Judás tɨ yaujraꞌan púꞌeen ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Judás tɨ ayén teꞌentímuꞌutaca tɨjɨ́n Iscariotes. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ tiuꞌutátui ɨ́ Jesús. Aꞌɨ́mej puꞌu avéꞌejajpuaxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tɨꞌɨj jí Jesús acájraa ɨ́ jɨrí japua, majta ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aꞌuu pu aꞌaráꞌa aꞌu tɨ aꞌupáꞌatza. Aꞌuu mú jeíhua ajteáxɨɨrecaꞌa ɨ́ teɨte, ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, majta seica. Jéihua mú majta ajteáxɨɨrecaꞌa ɨ́ mej aꞌuchéjme aꞌúu tɨ huatacáꞌa u Judea, majta meꞌɨ́n ɨ́ mej aꞌuun aꞌuchéjme u Jerusalén. Aꞌɨ́ɨ mú majta ajteáxɨɨrecaꞌa ɨ́ mej aꞌuun aꞌuchéjme aꞌujna la coosta, aꞌájna jáꞌahuaꞌa u Tiro, ajta aꞌájna jáꞌahuaꞌa u Sidón. ");
INSERT INTO crnNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ayee mú ꞌeen jɨ́n mú eꞌiréꞌene mej mi ráanamua, tɨ ij aꞌɨ́ɨn tihuáꞌuhuaateꞌen ɨ́ mej jɨ́n tiꞌicúcuiꞌijme. Majta meꞌɨ́n ɨ́ mej rajpuaíjtzicaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ tiyáaruꞌuse tɨ huáꞌa tzajtaꞌa seijreꞌe, Jesús pu ajta tihuáꞌuhuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Naíjmiꞌi matɨ́j menaꞌa meꞌuun aꞌutéꞌuucaꞌa, ayée mú tíꞌiteseꞌecaꞌa mej raꞌajtamuárɨꞌen aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn jetze eꞌiraayeꞌi ɨ́ muárɨꞌeriꞌireꞌaraꞌan tɨ jɨ́n tihuáꞌuhuaateꞌen naíjmiꞌica. ");
INSERT INTO crnNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tɨꞌɨj jí huaꞌantaseíirajraa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Tɨꞌɨj jí Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj hui huataújtemuaꞌaveꞌen, múꞌeen mɨ sej caí aꞌij tíꞌijviicuaꞌi, aꞌiné múꞌejmi pu ari tiuꞌucɨ́ꞌɨ tɨ Dios tejáꞌamuaꞌaijteꞌe sej si jamuan tiuꞌutaꞌaíjta tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Setáꞌaj hui huataújtemuaꞌaveꞌen, múꞌeen mɨ sej tɨejcu. Dios pu tejámuaatáꞌasin ɨ́ sej jɨ́n huateújvaɨreꞌen. ’Setáꞌaj huataújtemuaꞌaveꞌen mɨ sej ruyein seꞌɨ́jna jɨmeꞌe tɨ aꞌij puaꞌa tíꞌiseijreꞌe íiyen chaanaca japua. Múꞌeen xu naꞌanaa xáꞌajuꞌun seꞌɨ́jna jɨmeꞌe tɨ Dios ari amuáꞌancuꞌuvajxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Setáꞌaj hui huataújtemuaꞌaveꞌen tɨ puaꞌa seica teɨte mejamuájchaꞌɨɨreꞌe, naꞌari tɨ puaꞌa mejamuaatamuáriteꞌen, naꞌari tɨ puaꞌa mej aꞌij puaꞌa áꞌamuaruuren nusu tɨ puaꞌa metejáꞌamuaxajtziꞌira meꞌɨ́jna jɨmeꞌe sej náꞌastijreꞌe ineetzi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Tɨ́ꞌɨj tejaꞌuréꞌenen aꞌájna mej miyen aꞌij puaꞌa áꞌamuaruuren ɨ́ teɨte, setáꞌaj hui huataújtemuaꞌaveꞌen aꞌiné jeíhua pu huápɨꞌɨ tejáꞌamuacɨꞌɨti aꞌɨ́jna jɨmeꞌe tɨ aꞌuun tejéꞌemeꞌecan aꞌu tɨ Dios éꞌeseijreꞌe. Setáꞌaj tiuꞌutéeneꞌen seꞌɨ́jna jɨmeꞌe sej rutémuaꞌaveꞌe, aꞌiné huáꞌavaujsimuaꞌacɨꞌɨ, ayée mú hui cheꞌatá menaꞌa aꞌij puaꞌa huáꞌuruu aꞌɨ́mej ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Seajta múꞌeen, mɨ sej chíjteaani, setáꞌaj hui huataújxɨeemɨsteꞌen aꞌiné xuꞌuri raꞌancuréꞌa íiyen chaanaca japua ɨ́ tɨ rɨ́ꞌɨ tejámuaatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen mɨ sej nain tíꞌijchaꞌɨɨ, aꞌiné capu hui tiꞌitɨ́j huateáturaasin múꞌejmi jemi tɨ́j naꞌa rusén jɨmeꞌe. ’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen mɨ sej naꞌana, chaꞌa senaꞌa, aꞌiné múꞌeen xu ruyeinixɨꞌɨn, seajta huataújxɨeemɨsteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Setáꞌaj hui huataújxɨeemɨsteꞌen tɨ puaꞌa naímiꞌi miyen tejáꞌamuaꞌixaateꞌe yee xɨ́ꞌepɨꞌɨn xu huarɨ́j, aꞌiné huáꞌavaujsimuaꞌacɨꞌɨ, ayée mú cheꞌatá menaꞌa tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej caí tzáahuatiꞌiraꞌa jɨmeꞌe tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Mɨ neajta inee, ayée nu tejáꞌamuaꞌixaateꞌe mɨ sej níꞌinamua: Setáꞌaj hui huáꞌuxeꞌeveꞌen seꞌɨ́mej ɨ́ mej amuájchaꞌɨɨreꞌe, setáꞌaj seajta rɨ́ꞌɨ huáꞌuruuren seꞌɨ́mej ɨ́ mej aꞌij puaꞌa áꞌamuaruure. ");
INSERT INTO crnNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","’Setáꞌaj rɨ́ꞌɨ tihuaꞌutáꞌan aꞌɨ́mej ɨ́ mej aꞌij puaꞌa tejáꞌamuaxa. Setáꞌaj hui seajta ɨ́ Dios jemi huáꞌa jɨ́meꞌen huatéjniuuni aꞌɨ́mej ɨ́ mej aꞌij puaꞌa áꞌamuaruure. ");
INSERT INTO crnNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","’Tɨ́ puaꞌa jaꞌatɨ muꞌitéjveeni aꞌɨpée jetze, patáꞌaj hui pajta u jetze pújmeꞌen raatániɨjteꞌen tɨ́ꞌij ajtahuaꞌa muꞌitéjveeni aꞌuun jetze. Tɨ́ puaꞌa jaꞌatɨ muáꞌachuira mɨ aꞌachamaara, patáꞌaj pajta mɨ asiicuꞌu raatapíjteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","’Patáꞌaj pajta tihuaꞌutáꞌan naíjmiꞌica aꞌachú mej hui puaꞌamé tiꞌitɨ́j muahuavii. Ajta tɨ puaꞌa jaꞌatɨ tiꞌitɨ́j ántɨni ɨ́ tɨ múꞌeetzi aꞌaa, capej hui rahuaviira caꞌanéeri jɨmeꞌe tɨ muaatátuiireꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","’Patáꞌaj pajta hui piyen huáꞌuruuren ɨ́ seica aꞌij pej tíꞌijxeꞌeveꞌe mej miyen muáaruuren múꞌeetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Nicheꞌe seɨ́j tejámuaataꞌíhuaꞌu. Tɨ́ puaꞌa siyen huáꞌixeꞌeveꞌe senaꞌa aꞌɨ́mej ɨ́ mej amuáꞌixeꞌeveꞌe múꞌejmi, ¿aꞌiné hui tejamuáꞌamitɨejteꞌe aꞌɨ́jna jɨmeꞌe ɨ́ niuucari? ¿Ni qui tiꞌitɨ́j semuáꞌitɨn ɨ́ Dios jemi? Caxu xaa neꞌu tiꞌitɨ́j huamuáꞌitɨn aꞌiné aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa rɨcɨ, aꞌɨ́ɨ mú majta hui huáꞌixeꞌeveꞌe aꞌɨ́mej ɨ́ seica ɨ́ mej majta huáꞌixeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","’Ajta, tɨ puaꞌa siyen rɨ́ꞌɨ tihuaꞌatáꞌacareꞌen senaꞌa aꞌɨ́mej ɨ́ mej rɨ́ꞌɨ tejaamuaatáꞌaca, ¿ni tzaa ayén tejamuáꞌamitɨejteꞌe sej seꞌɨ́jna jɨ́n tiꞌitɨ́j huamuáꞌitɨn ɨ́ Dios jemi? Ayee nu tejáꞌamuaꞌixaateꞌe yee caxu hui aꞌatzu tiꞌitɨ́j huamuáꞌitɨn aꞌiné ayée mú cheꞌatá menaꞌa rɨcɨ aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","’Ajta, tɨ puaꞌa hui siyen tihuaꞌutániɨ́jteꞌen tiꞌitɨ́j tɨ naꞌa seꞌɨ́jna jɨmeꞌe mej mi áꞌiyen amuaatátuiireꞌen, ¿ni ayén tejamuáꞌamitɨejteꞌe sej seꞌɨ́jna jɨ́n tiꞌitɨ́j huamuáꞌitɨn ɨ́ Dios jemi? Capu ayén téꞌeme. Caxu hui aꞌatzu tiꞌitɨ́j huamuáꞌitɨn aꞌiné aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa rɨcɨ, aꞌɨ́ɨ mú huaꞌutániɨ́jte ɨ́ seica, majta miyen rachúꞌeveꞌen mej mi áꞌiyen tíhuaꞌutátuiireꞌen nain ɨ́ mej caj tihuaꞌutániɨjte. ");
INSERT INTO crnNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","’Ayee xuꞌu huárɨni. Setáꞌaj hui huáꞌaxeꞌeveꞌe aꞌɨ́mej ɨ́ mej amuáꞌajchaꞌɨɨreꞌe. Setáꞌaj rɨ́ꞌɨ tihuáꞌajchaꞌɨɨ. Setáꞌaj seajta tiꞌitɨ́j tɨ naꞌa huaꞌutániɨ́jteꞌen. Caxu huáꞌahuaviira caꞌanéeri jɨmeꞌe mej mi amuaatátuiireꞌen. Ayee nu tejáꞌamuaꞌixaateꞌe tɨ puaꞌa siyen huárɨni, jeíhua pu hui tejáꞌamuacɨꞌɨti. Seajta xu yaújmuaꞌameꞌen púꞌeeneꞌe xáꞌajuꞌun aꞌɨ́jna ɨ́ Dios ɨ́ ta japua tɨ éꞌeseijreꞌe, aꞌiné aꞌɨ́ɨ pu rɨ́ꞌɨ tihuáꞌajchaꞌɨɨ aꞌɨ́mej ɨ́ mej caí rɨ́ꞌɨ tihuaꞌatáꞌaca, ajta aꞌɨ́mej ɨ́ mej aꞌij puaꞌa rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","’Setáꞌaj siyen huáꞌancuꞌuvajxɨꞌɨn, aꞌiné aꞌɨ́ɨn ɨ́ tɨ áꞌamuaꞌiyaꞌupua, aꞌɨ́ɨ pu hui ajta huáꞌancuꞌuvajxɨꞌɨsin. ");
INSERT INTO crnNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Caxu aꞌij tihuáꞌajeeve ɨ́ seica; tɨ ij caí Dios aꞌij tejáꞌamuajeeve múꞌejmi. Caxu seajta huáꞌaxɨjteꞌe ɨ́ seica, tɨ ij caí Dios amaꞌuxɨ́jteꞌen múꞌejmi. Setáꞌaj hui tihuaꞌutáꞌuuniꞌi ɨ́ seica. Tɨ́ puaꞌa siyen huárɨni, Dios pu ajta tejámuaatáꞌuuniꞌira. ");
INSERT INTO crnNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","’Setáꞌaj tíhuaꞌutapuaíjveꞌen ɨ́ seica. Tɨ́ puaꞌa siyen huárɨni, jeíhua pu ajta múꞌejmi tejámuaatapuaíjveꞌesin. Ayee pu téꞌeme tɨ́j jaꞌatɨ raꞌavéꞌejɨsteꞌen ɨ́ medida jetze. Aꞌɨ́jna ɨ́ jaꞌatɨ, miꞌi pu rɨ́ꞌɨ raꞌureꞌeruurén, ajta raatéruureajxɨꞌɨn tɨ́ꞌij rɨ́ꞌɨ huaújraꞌatza. Temuaꞌa pu naa tiraꞌavéꞌejɨsteꞌesin tɨ ij caí avéꞌevitzen. Aj pu i, amuaꞌancáraꞌatziꞌira ɨ́ áꞌamuasiicuꞌu jetze. Ayee pu áꞌamuaruuren aꞌiné aꞌachú sej hui caj tiuꞌutapuaíjveꞌe, ayée pu cheꞌatá naꞌa Dios pu amuaatapuaíjveꞌesin múꞌejmi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ajtahuaꞌa seɨ́j niuucari pu jɨ́n tihuáꞌuꞌitɨiiriꞌi. Ayen tɨjɨ́n: ―Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi aꞌɨ́jna jɨ́meꞌen ɨ́ tɨ arácun. ¿Ni rɨꞌɨrí tɨ aꞌɨ́ɨn tɨ arácun ráꞌanviꞌitɨn ɨ́ juye jetze seɨ́j tɨ ajta arácun? Ayee nu tejáꞌamuaꞌixaateꞌe. Capu aꞌatzu rɨꞌɨrí, tɨ aꞌɨ́ɨn ráꞌanviꞌitɨn, aꞌiné tɨ puaꞌa aꞌɨ́ɨn ráꞌanviꞌitɨn, naímiꞌi mú hui atévatzɨjsin aꞌu tɨ eꞌetécun. ");
INSERT INTO crnNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","’Ajta ayée pu hui ꞌeen aꞌɨ́jna jɨmeꞌe ɨ́ mej nee jamuan áꞌujujhuaꞌan. Aꞌɨ́n ɨ́ jaꞌatɨ tɨ ayén tiúꞌujmuaꞌate capu ayén cheꞌatá naꞌa ruxeꞌeveꞌe tɨ́j aꞌɨ́ɨn tɨ tíꞌijmuaꞌate, sino tɨ́ꞌɨj ari raꞌantipuáꞌariteꞌen ɨ́ tɨ tiúꞌujmuaꞌate, aj pu hui xaa ayén éeneꞌe aꞌame tɨ́j aꞌɨ́jna ɨ́ tɨ tiraamuáꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’Pajta múꞌee, aꞌiné hui ꞌeen jɨ́n piyen raseíj ɨ́ aꞌihuáaraꞌa aꞌɨ́jna tɨ cɨ́j caj teꞌuteájturaa ɨ́ Dios jemi. Mɨ́ pajta múꞌee, capej aseɨ́j ɨ́ pej hui jɨ́n jeíhua áꞌatura ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tɨ́ puaꞌa peri jeíhua jɨ́n auteájturaa ɨ́ Dios jemi, ¿aꞌiné hui tíꞌirɨꞌɨri pej piyen tiraataꞌixaateꞌen peꞌɨ́jna ɨ́ aꞌihuáaraꞌa tɨ cɨ́j caj teꞌuteájturaa aꞌij tɨ tiꞌitɨ́j jɨ́n teꞌuteájturaa ɨ́ Dios jemi? Capu aꞌatzu aꞌij tíꞌirɨꞌɨri, aꞌiné capej hui aseɨ́j múꞌee aseɨ́j aꞌij pej tiꞌitɨ́j jɨ́n teꞌuteájturaa ɨ́ Dios jemi. ’Múꞌee mɨ pej aꞌij puaꞌa tíꞌijrɨꞌɨre mé jéjreꞌe, pauj miꞌi seɨcɨé tiúꞌumuaꞌati, pajta nain jɨ́n tihuaꞌutáꞌixaateꞌen ɨ́ teɨte ɨ́ pej hui jɨ́n auteájturaa ɨ́ Dios jemi. Aj pu hui xaa ayén tiraavíjteꞌe ɨ́ pej piyen tiraataꞌixaateꞌen ɨ́ seɨ́j aꞌij tɨ tiꞌitɨ́j jɨ́n teꞌuteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ayee puꞌu ajta ꞌeen, tɨ́j ɨ́ cɨyej, nain tɨ tiꞌirɨ́ꞌeen, rɨꞌéeneꞌen pu tíꞌitaaca. Ajta nain ɨ́ cɨyej tɨ caí tiꞌirɨ́ꞌeen, capu ajta rɨꞌéeneꞌen tíꞌitaaca. ");
INSERT INTO crnNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ajta naíjmiꞌi ɨ́ cɨyej tɨ tíꞌitaaca, ayée mú hui tíꞌimuaꞌamua meꞌɨ́jna ɨ́ tɨ tíꞌitaaca, aꞌiné aꞌɨ́jna ɨ́ huaréj tacaꞌi, capu aꞌɨ́ɨn ratacaꞌi ɨ́ cɨyej tɨ tétzicareꞌe sino aꞌij pu jetze meꞌecan ɨ́ rucɨyeꞌe. Ajta aꞌɨ́jna ɨ́ uuva tacaꞌi, capu ajta aꞌɨ́ɨn ratacaꞌi ɨ́ jɨ́ꞌɨtzijcaꞌixaꞌa jetze sino aꞌij pu ajta jetze meꞌecan ɨ́ rucɨyeꞌe. Ayee xu cheꞌatá senaꞌa seajta tíꞌijmuaꞌareeren jaꞌatɨ tɨ téviraꞌa púꞌeen tij rɨ́ꞌɨ tíꞌitevij nusu caí seꞌɨ́jna jɨmeꞌe aꞌij tɨ rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","’Aꞌɨ́jna ɨ́ jaꞌatɨ tɨ rɨ́ꞌɨ tíꞌitevij, aꞌɨ́ɨ pu hui rɨ́ꞌɨ tíꞌixaxaꞌa, ajta aꞌɨ́jna tɨ rɨ́ꞌɨ tíꞌixaxaꞌa, aꞌúu pu meꞌecan tzajtaꞌan aꞌu tɨ jeíhua yáꞌavaa tɨ xɨ́ꞌepɨꞌɨn ꞌeen. Ajta aꞌɨ́ɨn tɨ aꞌij puaꞌa tíꞌitevij, aꞌɨ́ɨ pu aꞌij puaꞌa tíꞌixaxaꞌa, ajta aꞌɨ́jna tɨ aꞌij puaꞌa tíꞌixaxaꞌa, aꞌúu pu hui meꞌecan tzajtaꞌan aꞌu tɨ jeíhua yáꞌavaa tɨ aꞌij puaꞌa ꞌeen. Ayee nu tejáꞌamuaꞌixaateꞌe. Jaꞌatɨ tɨ naꞌa, aꞌɨ́ɨ pu hui tíꞌixaxaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ tɨ ráꞌavaa ɨ́ ru tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’Seajta múꞌeen, mɨ sej hui caí siyen tíꞌiruure aꞌij nej tejáꞌamuaꞌixaateꞌe, aꞌiné ꞌeen jɨ́n siyen tíꞌinejee tɨjɨ́n: “Nevástaraꞌa, nevástaraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","’Ayee nu hui tejámuaatáꞌixaateꞌesin aꞌiné ꞌeen aꞌɨ́jna ɨ́ jaꞌatɨ tɨ neetzi jemi mú aꞌuvéꞌemej tɨ ij neetzi huanamua, ajta ayén tiúꞌuruuren aꞌij nej tiꞌixa. ");
INSERT INTO crnNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ayee pu hui ꞌeen tɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ chiꞌi ájtaahuacaꞌa. Aꞌɨ́jna ɨ́ jaꞌatɨ, jéꞌecan pu ruꞌucáꞌijche téteꞌɨmua. Tɨꞌɨj jí ráꞌajtaahuacaꞌa ɨ́ jaxuꞌu ɨ́ tete japua. Matɨ́ꞌɨj mi huatéviiyecaꞌa. Ajta huatámɨꞌɨyecaꞌa ɨ́ játeꞌana. Aj pu i jetzen ajtéꞌa ɨ́ játeꞌana ɨ́ chiꞌij. Ajta aꞌɨ́ɨn ɨ́ chiꞌij, capu hui áꞌave aꞌiné temuaꞌa pu naa rɨ́ꞌɨ tiráꞌajtaahuacaꞌa ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","’Mɨ ajta, aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén tíꞌinenamua, tɨ puaꞌa caí ayén tiúꞌuruuren aꞌij nej tiꞌixa, ayée pu hui ꞌeen tɨ́j ɨ́ seɨ́j tɨ ajta chiꞌij ájtaahuacaꞌa. Capu ruꞌucáꞌijche téteꞌɨmua aꞌɨ́jna ɨ́ jaꞌatɨ. Matɨ́ꞌɨjtá mi huatéviiyecaꞌa. Ajta huatámɨꞌɨyecaꞌa ɨ́ játeꞌana. Tɨ́ꞌɨj jetzen ajtéꞌa, aj pu i ráꞌarɨe. Nain pu hui tejáꞌurɨe aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tɨ́ꞌɨj Jesús raatapuáꞌajtacaꞌa tɨ tihuáꞌaꞌixaateꞌecaꞌa ɨ́ teɨte, aj pu i aꞌuun áꞌuraa u Capernaúm. ");
INSERT INTO crnNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Aꞌuu pu seɨ́j aꞌutéveecaꞌa xantaaruꞌu tɨ anxɨ́te tíꞌaijta. Aꞌɨ́jna jemi, seɨ́j pu tíꞌicuiꞌi tɨ jemin tíꞌivaɨreꞌe. Puꞌuri áꞌameꞌerejcaꞌa. Ajta ɨ́ xantaaruꞌu, jeíhua pu raxɨ́ꞌeveꞌecaꞌa aꞌɨ́jna tɨ jemin tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tɨꞌɨj jí aꞌɨ́ɨn anxɨ́te tɨ tíꞌaijta, aꞌɨ́ɨ pu ráamuaꞌareeriꞌi aꞌij tɨ tiꞌitɨ́ ruurejcaꞌa ɨ́ Jesús. Aj pu i teɨte huataꞌáij mej mi yaꞌutájeeve. Aꞌɨ́ɨme ɨ́ teɨte, aꞌii mú aꞌɨ́ɨn puꞌéeneꞌe ɨ́ mej Israél jetze ajtémeꞌecantacaꞌa, majta ɨ́ mej tíꞌaijtacaꞌa u teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Matɨ́ꞌɨj mi aꞌuun eꞌiréꞌene aꞌu tɨ Jesús aꞌutéveecaꞌa. Jéihua mú raatéeje. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Jéꞌecan pu raavíjteꞌe pej áꞌumeꞌen jemin aꞌu tɨ éꞌeche pej pi piyen huárɨni aꞌij tɨ timuaatáhuaviira. ");
INSERT INTO crnNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","’Jéꞌecan pu hui rɨ́ꞌɨ titájchaꞌɨɨ aꞌɨ́jna. Ajta aꞌɨ́ɨ pu ráꞌajtaahuacaꞌa ɨ́ teyuu. ―Ayee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tɨꞌɨj jí Jesús u áꞌume huáꞌa jamuan. Aa pu vejliꞌi auméꞌecaa, tɨ́ꞌɨj aꞌɨ́ɨn tɨ anxɨ́te tíꞌaijta, ajta pu ruꞌamiigustemuaꞌa huataꞌáij mej mi miyen tiraataꞌixaa tɨ nuꞌu caí aꞌuun eꞌaráꞌasti aꞌujna tɨ éꞌeche. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, capu hui rɨ́ꞌɨ tiraavíjteꞌe pej anúꞌasti. ");
INSERT INTO crnNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Aꞌɨ́j pu jɨ́n, capu ayén tináꞌamitɨejteꞌecaꞌa tɨ raavíjteꞌe nej neꞌuun aꞌatanén aꞌu pej aꞌutéveecaꞌa. Tɨ́ ij caí muamuárɨꞌeristeꞌe, ayée pepuꞌu hui huárɨni pej raataxáj yee puꞌuri huarúj ɨ́ tɨ ajemi tíꞌivaɨreꞌe. Tɨ́ puaꞌa piyen tiuꞌutaxáj, aj pu aꞌɨ́ɨn rujni ɨ́ tɨ ne jemi tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","’Aꞌɨ́j nu hui jɨ́n niyen tíꞌimuaꞌixaateꞌe aꞌiné seɨ́j pu tíꞌineꞌaijteꞌe ineetzi. Nee nu neajta tiꞌitɨ́j jɨ́n antínmuaꞌaree; neajta tihuáꞌaijteꞌe ɨ́ xantaaruꞌu. Tɨ́ puaꞌa seɨ́j netiuꞌutaꞌáijteꞌen yee aricu, aꞌɨ́ɨ pu ayén rɨni tɨ áꞌumeꞌen. Naꞌari tɨ puaꞌa seɨ́j niyen tiuꞌutáꞌixaateꞌen yee mú aꞌutáꞌiyiꞌi, ayée pu rɨni tɨ mú aꞌuvéꞌemeꞌen. Ayee nu hui tiraataꞌixaateꞌen aꞌɨ́jna tɨ nej jemi tíꞌivaɨreꞌe yee ayée pej huárɨni. Ajta aꞌɨ́ɨn, ayée pu rɨni. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ xantaaruꞌu aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ajta aꞌɨ́ɨn Jesús, tɨ́ꞌɨj ayén tiráanamuajriꞌi, jéꞌecan pu naa rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́jna jemi. Tɨꞌɨj jí pɨ́ɨ aꞌuréꞌeve tɨ ij huaꞌuseíirajraꞌani ɨ́ teɨte ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe, aꞌu tɨ huatacáꞌa íiye Israél, canu hui jaꞌanáj jaꞌatɨ huáteu tɨ ayén cheꞌatá naꞌa téꞌatzaahuateꞌe tɨ́j aꞌɨ́jna ɨ́ xantaaruꞌu. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Majta meꞌɨ́n ɨ́ mej tiuꞌutaꞌaíjtiꞌire, aꞌɨ́ɨ mú aꞌuréꞌacɨ aꞌu tɨ éꞌeche aꞌɨ́jna ɨ́ xantaaruꞌu. Matɨ́ꞌɨj aꞌuréꞌene, puꞌuri huarújcaa aꞌɨ́jna tɨ jemin tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Aꞌatzu aꞌateeviꞌi, Jesús pu aꞌuun aꞌaráꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Naín. Majta mú aꞌucɨ́j jamuan aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majta seica ɨ́ teɨte, muꞌiitɨ́ mú aꞌucɨ́j jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Muꞌuri vejliꞌi aujúꞌucaa taꞌanténineꞌi chajtaꞌa jetze matɨ́ꞌɨj seica antinájchecaꞌa mej mɨ́ꞌɨchi huáchuisimeꞌe. Aꞌɨ́jna ɨ́ mɨ́ꞌɨchi, aꞌɨ́ɨ pu púꞌeeneꞌe yaujraꞌan ɨ́ ꞌɨ́itaꞌa tɨ ruseɨ́j. Aꞌɨ́ɨ puꞌu caj pɨ́tíꞌiyaujraꞌantacaꞌa tɨ teáatacan. Jéihua mú teɨte jamuan huajúꞌucaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tɨ́ꞌɨj Jesús raaseíj, jeíhua pu huataújxɨeemɨste jemin ɨ́ ꞌɨ́itaꞌa. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Capej ayeine. ");
INSERT INTO crnNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Tɨꞌɨj jí ajteáxɨɨrecaꞌa. Aj pu i raꞌajtamuárɨej ɨ́ cɨyej tɨ japuan ꞌujcáꞌa aꞌɨ́jna tɨ huamɨ́ꞌɨ. Majta meꞌɨ́n ɨ́ mej ráachuisimeꞌe, aꞌɨ́ɨ mú huatéhuiixɨ. Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Múꞌee, temuaij, ayée nu tíꞌimuaꞌixaateꞌe yee: Ájchesi. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ajta aꞌɨ́ɨn tɨ huamɨ́ꞌɨ, aꞌɨ́ɨ pu aꞌujyeíjxɨ. Aj pu i aꞌutéjche tɨ tiuꞌutaxáj. Tɨꞌɨj jí Jesús raatátui ɨ́ náànajraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Matɨ́ꞌɨj mi naímiꞌi naa rɨ́ꞌɨ tiraꞌutaseíj aꞌij tɨ tiꞌitɨ́j huáruu ɨ́ Jesús. Jéꞌecan pu utéevatzɨ ɨ́ huáꞌa tzajtaꞌa. Matɨ́ꞌɨj mi rɨ́ꞌɨ tiuꞌutáꞌa ɨ́ Dios jemi. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Jaꞌatɨ pu hui huataseíjre itejmi jemi tɨ veꞌecán jɨ́n tiꞌitéjvee, ajta tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. Puꞌuri mú aꞌuvéꞌemej ɨ́ Dios tɨ ij huaꞌutévaɨreꞌen ɨ́ ruteɨ́testemuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nainjapua mú ráamuaꞌareeriꞌi aꞌij tɨ tiꞌitɨ́ huarɨ́j aꞌɨ́jna ɨ́ Jesús. Nainjapua tɨ́j naꞌa aꞌuun tɨ huatacáꞌa u Judea, ajta ꞌáꞌayee tɨ huacáꞌa, naímiꞌi mú ráamuaꞌareeriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuaca, aꞌɨ́ɨ mú raatáꞌixaa aꞌij tɨ Jesús rɨjcaa. Tɨꞌɨj jí huaꞌapuaca huatajé aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Aj pu i huaꞌutaꞌítecaꞌa mej mi raataꞌíhuaꞌu aꞌɨ́jna ɨ́ Jesús yee ni qui múꞌee peꞌɨ́n púꞌeen aꞌɨ́jna tɨ nuꞌu méꞌe véꞌeme, naꞌari ayén tiúꞌujxeꞌeveꞌe tej seɨ́j huachúꞌeveꞌen. Matɨ́ꞌɨj mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Matɨ́ꞌɨj mi meꞌuun eꞌiréꞌene aꞌu tɨ aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuaca, aꞌɨ́ɨ pu hui tajaꞌutaꞌítecaꞌa tej ti tiyen timuaataꞌíhuaꞌu yee: “¿Ni qui múꞌee peꞌɨ́n púꞌeen aꞌɨ́jna tɨ méꞌe véꞌeme naꞌari teuj seɨ́j chuꞌeveꞌe?” ―Ayee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ajta aꞌɨ́ɨn ɨ́ Jesús, auchén pu muꞌiicáca tiúꞌuhuaa ɨ́ mej tíꞌicucuiꞌicaꞌa, ajta seica ɨ́ mej caí rɨꞌéeneꞌe ɨ́ ru jetze, ajta ɨ́ mej tiyaaruꞌu huáꞌa tzajtaꞌa seijreꞌecaꞌa. Ajta aꞌɨ́ɨme ɨ́ mej aracúcuꞌunijmee, aꞌɨ́ɨ pu tihuáꞌuhuaa mej mi majtáhuaꞌa atanéjneꞌere. ");
INSERT INTO crnNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tɨꞌɨj jí Jesús ayén tihaꞌutáꞌixaa aꞌɨ́mej ɨ́ tɨ Juan huaꞌutaꞌítecaꞌa tɨjɨ́n: ―Sericu múꞌeen. Setáꞌaj áꞌujuꞌun ɨ́ Juan jemi, setáꞌaj tiraataꞌixaateꞌen aꞌij sej seri tiuꞌuséij, aꞌij sej seri tiúꞌunamuajriꞌi yee aꞌɨ́ɨme ɨ́ mej aracúcuꞌunijmee, aꞌɨ́ɨ mú hui meri majtáhuaꞌa mé uunéjneꞌe. Majta aꞌɨ́ɨme ɨ́ mej anacɨyáaxaviꞌijmee, aꞌɨ́ɨ mú meriꞌijtáhuaꞌa áꞌujujhuaꞌan. Majta aꞌɨ́ɨme ɨ́ mej tijcúcuiꞌinecaꞌa meꞌɨ́jna jɨmeꞌe tɨ tineájxɨ huáꞌahuaꞌiraꞌa jetze, tɨ ayén ántehuaa tɨjɨ́n lepra, muꞌuri huarúj. Majta aꞌɨ́ɨme, ɨ́ mej nácuxaꞌitacaꞌa, muꞌuriꞌitáhuaꞌa huiteánajcaꞌamua. Majta aꞌɨ́ɨme ɨ́ mej meri huácuii, muꞌuri majtáhuaꞌa menaꞌa huatarúj. Neajta hui tihuaꞌutáꞌixaateꞌesin aꞌɨ́ɨme ɨ́ mej caí aꞌij téꞌeviicuaꞌi aꞌɨ́jna jɨmeꞌe ɨ́ niuucari ɨ́ mej jɨ́n huataújtemuaꞌaveꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","’Rɨ́ꞌɨ pu hui tiraatáꞌasin aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí aꞌij puaꞌa tiraatáꞌan mé núurɨeeni, aꞌɨ́jna jɨmeꞌe tɨ caí chéꞌe téꞌeviicuaꞌi neetzi jemi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Matɨ́ꞌɨj mi aꞌucɨ́j aꞌɨ́ɨme ɨ́ mej Juan jamuan áꞌujujhuaꞌaneꞌe. Tɨꞌɨj jí Jesús aꞌutéjche tɨ tihuáꞌitɨii ɨ́ teɨte aꞌɨ́jna jɨmeꞌe ɨ́ Juan. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Tiꞌitájni sej aꞌutéeseij seꞌújna ɨ́ ꞌɨtzitá? ¿Ni qui huiini xámuaꞌij u seꞌuseíj tɨ eeca raruꞌuxanteꞌe? Caxu xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Caꞌɨ́n, ¿tiꞌitájni senaꞌa hui aꞌutéeseij? ¿Caꞌɨ́n jaꞌatɨ senaꞌa u aꞌutéeseij tɨ rɨꞌéeneꞌen teꞌucáaviɨj? Caxu xaa neꞌu, aꞌiné xuꞌuri ramuaꞌaree tɨjɨ́n aꞌɨ́ɨme ɨ́ mej miyen rɨꞌéeneꞌen teꞌucaviɨ́jmee, majta aꞌɨ́ɨme tɨ huaꞌaráanajche naíjmiꞌi tɨ́j naꞌa tɨ tíꞌijnajche, aꞌúu mú éꞌeche aꞌu mej rey éꞌeche. ");
INSERT INTO crnNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","’Ari tɨ puaꞌa secaí seꞌɨ́jna aꞌutéeseij, ¿tiꞌitájni senaꞌa aꞌutéeseij? ¿Ni qui hui seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa? Jee tzɨ́teꞌe, ayée nu tejáꞌamuaꞌixaateꞌe yee aꞌɨ́ɨ pu pɨ́rɨcɨ. Ajta aꞌɨ́ɨn, jaítzeꞌe pu veꞌecán jɨ́n tiꞌitéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aꞌii pu hui aꞌɨ́ɨn púꞌeen ɨ́ tɨ jɨ́meꞌen ráꞌaxa ɨ́ yuꞌuxari jetze tɨjɨ́n: Nee nu hui seɨ́j amuacaí huataꞌíti tɨ huataseíjreꞌesin pecaí múꞌee. Aꞌɨ́ɨ pu rɨ́ꞌɨ huáꞌaruuren ɨ́ teɨte mej mi muaꞌancuréꞌeviꞌitɨn múꞌeetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","’Ayee nu tejáꞌamuaꞌixaateꞌe yee aꞌɨ́ɨme tzajtaꞌa naíjmiꞌi ɨ́ teɨte ɨ́ mej huataseíjre íiyen chaanaca japua, capu jaꞌatɨ jaꞌanáj teꞌenteájrupi tiꞌitɨ́j jɨmeꞌe ɨ́ tɨ jaítzeꞌe veꞌée caí ɨ́ tɨ jɨ́n tiꞌitéjvee aꞌɨ́jna ɨ́ Juan. Mɨ́ ajta, aꞌɨ́ɨn tɨ jaítzeꞌe cɨliéeneꞌe jɨ́n tiꞌitéjvee ɨ́ Dios jemi, jaítzeꞌe pu hui veꞌecán jɨ́n tiꞌitevée aꞌame aꞌɨ́jna ɨ́ jaꞌatɨ caí aꞌɨ́jna ɨ́ Juan aꞌájna xɨcájraꞌa jetze tɨ Dios ayén autéchesin tɨ tiuꞌutaꞌaíjta nainjapua. ");
INSERT INTO crnNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","’Majta naímiꞌi ɨ́ mej ráanamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan, aꞌɨ́ɨ mú hui raꞌancuréꞌa aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios meꞌɨ́jna jɨmeꞌe tɨ Juan huáꞌumuaɨꞌɨhua. Ayee mú cheꞌatá menaꞌa raꞌancuréꞌa aꞌɨ́ɨme mej tíꞌitejiꞌivi. ");
INSERT INTO crnNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","’Majta hui aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tiúꞌujmuaꞌate ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa, aꞌɨ́ɨ mú hui ratítecaꞌa aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios aꞌiné camu huaújmuaɨꞌɨhuacaꞌa ɨ́ Juan jemi. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ajtahuaꞌa seɨcɨé pu ayén tihuaꞌutaꞌíhuaꞌuriꞌi ɨ́ Jesús tɨjɨ́n: ―¿Aꞌiné nenaꞌa tiraataxáj yee ayée mú ꞌeen aꞌɨ́ɨme ɨ́ teɨte íjii mej huáteemua? ¿Ni caí méꞌe tiꞌitɨ́j tɨ ayén ꞌeen cumu aꞌíime? ");
INSERT INTO crnNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","’Ayee mú hui eꞌen matɨ́j ɨ́ tɨꞌɨríi mej á vejliꞌi aꞌujteí aꞌu mej tejáꞌatua. Aꞌɨ́ɨ mú miyen tihuaꞌatajíꞌivi ɨ́ seica tɨjɨ́n: “Tetiuꞌutacɨ́ꞌɨsite sej si tiuꞌutéeneꞌen, mɨ seajta caí, caxu tiuꞌutéenei. Teajta tu tiuꞌutáchuiicacaꞌa tɨ tiúꞌuxɨeemɨsteꞌe jɨmeꞌe, mɨ seajta caí, caxu huaújyeinecaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","’Ayee nu tejáꞌamuaꞌixaateꞌe aꞌiné aꞌɨ́jna ɨ́ Juan, tɨ́ꞌɨj aꞌɨ́ɨn yé uvéꞌene, capu hui pan cuaꞌaca, capu ajta viinu yeꞌeca. Seajta múꞌeen, ayée xu eꞌen matɨ́j aꞌɨ́ɨme ɨ́ tɨꞌɨríi seꞌɨ́jna jɨmeꞌe sej siyen tiꞌixa seꞌɨ́jna jɨ́meꞌen ɨ́ Juan tɨjɨ́n: “Tiyaaruꞌu pu tzajtaꞌan seijreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","’Neajta inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, nee nu tíꞌicuaꞌa, neajta yeꞌeca. Seajta múꞌeen, ayée xu tiꞌixa neetzi jɨ́meꞌen yee huápɨꞌɨ nu tíꞌicuaꞌa, neajta netahuaive. Ayee xu seajta tiꞌixa tɨjɨ́n yee yeꞌecui huatéjvee huaꞌamiigu aꞌɨ́ɨme mej tíꞌitejiꞌivi, ajta aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa titetiújchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Aꞌɨ́jna tɨ Dios jemi rɨ́ꞌɨ meteúumuaꞌaree, aꞌɨ́ɨ mú hui ramuaꞌaréeren ɨ́ yaújmuaꞌameꞌen ɨ́ mej rɨ́ꞌɨ metíteumuámuaꞌaree ɨ́ Dios jemi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ayee pu jaꞌanáj tiujuꞌurɨ́j. Seɨ́j pu raatáꞌinee aꞌɨ́jna ɨ́ Jesús tɨ jamuan tiúꞌucuaꞌani. Aꞌɨ́jna ɨ́ jaꞌatɨ, fariseo pu púꞌeen. Ayee pu ántehuaa tɨjɨ́n Simón. Aj pu i Jesús á aꞌuréꞌehuiꞌixɨ aꞌu tɨ meesa vejliꞌi aꞌutéjvee aꞌij mej tiraaxɨ́ꞌepɨꞌɨntariꞌiriꞌi aꞌɨ́jna tɨ raatáꞌinee. ");
INSERT INTO crnNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa, aꞌúu pu aꞌutéveecaꞌa. Jéihua pu aꞌij puaꞌa tiꞌitiújchaꞌɨɨcaꞌa aꞌɨ́jna ɨ́ Dios jemi. Tɨꞌɨj jí aꞌɨ́ɨ ráamuaꞌareeriꞌi tɨjɨ́n aꞌúu pu tejéꞌecuaꞌa fariseo tɨ éꞌeche aꞌɨ́jna ɨ́ Jesús. Aj pu i tetej limeetajraꞌa pu eꞌevéꞌejaj. Tiꞌitɨ́ pu urajmuaa tɨ naa teáarɨ́ꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tɨꞌɨj jí á vejliꞌi aꞌutéechaxɨ aꞌu tɨ Jesús anuꞌuhuaréꞌecaꞌa ɨ́ meesa aꞌutéjvee. Ruyeinecaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨꞌɨj jí Jesús ɨ́ɨca jetze títzutixɨ ɨ́ tɨ aꞌitajáꞌaraꞌatajyeꞌicaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Tɨꞌɨj jí rucɨpuá jɨ́n racáhuatziꞌiriꞌi, ajta raꞌanáapɨꞌɨtze. Tɨꞌɨj jí ɨɨcájraꞌan jetze racáaxɨre aꞌɨ́jna tɨ naa teáarɨ́ꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ajta aꞌɨ́ɨn fariseo tɨ Jesús huatáꞌinee, tɨ́ꞌɨj raaseíj aꞌij tɨ rɨjcaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, ayée pu tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa tɨjɨ́n: “Tɨ́ puaꞌa amɨ́n púꞌeeneꞌen tevi seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa, aꞌɨ́ɨ pu hui ramuaꞌaréeren tiꞌitɨ́j tɨ téviraꞌan pɨ́rɨcɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ aꞌij puaꞌa tiꞌitiújchaꞌɨɨ ɨ́ Dios jemi.” ");
INSERT INTO crnNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Simón, tiꞌitɨ́j nu muaatáꞌixaateꞌesin. Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Simón tɨjɨ́n: ―Maeestru, patáꞌaj naatáꞌixaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Seica mú nuꞌu hui tiráꞌachaꞌɨɨreꞌecaꞌa meꞌɨ́jna ɨ́ jaꞌatɨ tɨ tumin huaꞌutániɨ́jte, aꞌɨ́mej mej huaꞌapua. Seɨ́j pu nuꞌu ayén tiráꞌachaꞌɨɨreꞌecaꞌa aꞌachú cumu anxɨ́j ciento ɨ́ tumin. Ajta ɨ́ seɨ́j, ayée pu nuꞌu tiráꞌachaꞌɨɨreꞌecaꞌa aꞌachú cumu muáacua jetze ɨ́ tumin. ");
INSERT INTO crnNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","’Jaꞌiné camu aꞌatzu tíꞌituaaveꞌe ɨ́ mej jɨ́n tiraanájchiteꞌen, aꞌɨ́ɨ pu nuꞌu hui tihuaꞌutáꞌuuniꞌiriꞌi aꞌɨ́mej ɨ́ mej huaꞌapua aꞌachú mej caj tiráꞌachaꞌɨɨreꞌecaꞌa. Meꞌecui xaa, ¿aꞌiné timuáꞌamitɨejteꞌe? ¿Aꞌataani hui jaítzeꞌe raxɨ́ꞌeveꞌe aꞌame aꞌɨ́jna ɨ́ tɨ huaꞌutáꞌuniꞌiriꞌi? ―Ayee pu Jesús tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ajta aꞌɨ́ɨn ɨ́ Simón, ayée pu tiuꞌutaniú tɨjɨ́n: ―Ayee pu tináꞌamitɨejteꞌe ineetzi aꞌɨ́jna jɨmeꞌe tɨ tihuaꞌutáꞌuuniꞌiriꞌi, aꞌɨ́ɨ pu hui jaítzeꞌe raxɨ́ꞌeveꞌe aꞌame aꞌɨ́jna tɨ jaítzeꞌe tiráꞌachaꞌɨɨreꞌecaꞌa aꞌiné jaítzeꞌe pu tiraatáꞌuuniꞌiriꞌi. Jesús pu ayén tiraataꞌixaa tɨjɨ́n: ―Xɨ́ꞌepɨꞌɨn pej hui tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aj pu i pɨ́ɨ aꞌuréꞌeve tɨ ij raaseíj aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Simón tɨjɨ́n: ―¿Ni pecaí raseíj peꞌíjna i ꞌɨ́itaꞌa? Nee nu uteájrupi íiyu pe éꞌeche. Capej racáaxɨre ɨ́ jaj ɨ́ neꞌɨ́ɨca jetze. Mɨ́ ajtáꞌi amɨ́n ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu hui naꞌanaɨ́ɨriꞌi neꞌɨ́ɨca jetze aꞌɨ́jna jɨmeꞌe tɨ aꞌitajáꞌaraꞌatajyeꞌicaa. Ajta naꞌanáhuatziꞌiriꞌi ɨ́ rucɨpuá jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","’Múꞌee pej hui caí nuꞌitépɨꞌɨtze. Mɨ́ ajtáꞌi amɨ́n mɨ ꞌɨ́itaꞌa, tɨ́j naꞌa tɨ huiiteájrupi yú chiꞌita, aꞌɨ́ɨ pu naꞌanáapɨꞌɨtze ɨ́ neꞌɨ́ɨca jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Múꞌee pej caí naꞌavéꞌexɨriꞌiriꞌi tiꞌitɨ́j aceite yen nemuꞌuutzeꞌe. Mɨ́ ajtáꞌi amɨ́n, aꞌɨ́ɨ pu hui naꞌanáxɨriꞌiriꞌi ɨ́ neꞌɨ́ɨca jetze tiꞌitɨ́j tɨ naa teáarɨ́ꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","’Aꞌɨ́j nu jɨ́n niyen tíꞌimuaꞌixaateꞌe. Aꞌɨ́ɨ pu jeíhua auteájturaa ɨ́ Dios jemi. Neajta nu nain tiraatáꞌuuniꞌiriꞌi aꞌiné jeíhua pu nexɨ́ꞌeveꞌe jáꞌaraa. Mɨ́ pajta múꞌee, mɨ nej cɨ́j caj timuaatáꞌuuniꞌiriꞌi, múꞌee pej hui cɨ́j caj tíꞌinexeꞌeveꞌe. ― Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ajta Jesús pu ayén tiraataꞌixaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n: ―Nuꞌuri hui timuaatáꞌuuniꞌiriꞌi ɨ́ pej jɨ́n auteájturaa ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Majta meꞌɨ́n ɨ́ seica ɨ́ tɨ huaꞌutáꞌinee, matɨ́ꞌɨj miyen tiráanamuajriꞌi, matɨ́ꞌɨj mi autéjhuii mej tiꞌihuaúrihuaꞌu, tɨjɨ́n: ―¿Aꞌataani púꞌeen amɨ́jna mɨ tɨ tíhuaꞌutáꞌuuniꞌira aꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n auteájturaa ɨ́ Dios jemi? ―Ayee mú tiuꞌuteáurihuaꞌuracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ajta Jesús ayén tiraataꞌixaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n: ―Puꞌuri Dios muaꞌirájtuaa aꞌiné petéꞌatzaahuateꞌe múꞌee. Aricu hui áꞌuraꞌa axɨéehua. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tɨ́ꞌɨj ayén tiujuꞌurɨ́j, aꞌúu pu áꞌucheꞌecaneꞌe tɨ́j naꞌa aꞌuun mej aꞌuchéjme ɨ́ chajtaꞌa jetze, ajta aꞌɨmuá mej aꞌuchéjme. Jesús pu tihuáꞌuꞌitɨiiriꞌi aꞌɨ́jna ɨ́ niuucari ɨ́ mej jɨ́n huataújtemuaꞌaveꞌesin, tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ nainjapua tíꞌaijta. Majta mú áꞌujujhuaꞌaneꞌe aꞌɨ́ɨme ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Majta seica jamuan áꞌujujhuaꞌaneꞌe mé ꞌuuca, ɨ́ tɨ Jesús tihuáꞌuhuaa, ajta aꞌɨ́ɨme ɨ́ tɨ huáꞌa jetze tiyáaruꞌuse huatamuári. Aꞌii mú aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ María, mej miyen ratamuáꞌamua tɨjɨ́n Magdala tɨ éꞌemeꞌecan. Aꞌɨ́jna jetze ɨ́ ꞌɨ́itaꞌa, aꞌɨ́j mú jetze huiráacɨ ɨ́ tiyáaruꞌuse ɨ́ mej aráhuaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Seɨ́j pu ajta áꞌucheꞌecaneꞌe tɨ ayén ántehuaa tɨjɨ́n Juana, ɨ́raꞌaraꞌan pu púꞌeen aꞌɨ́jna ɨ́ Chuza, ɨ́ tɨ tiꞌitéjvee ɨ́ Heródes jemi. Ajtahuaꞌa seɨ́j, aꞌɨ́jna ɨ́ Susana, majta jeíhua, mé muꞌiitɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aꞌɨ́ɨ mú majta ravaɨreꞌecaꞌa meꞌɨ́jna ɨ́ Jesús, majta aꞌɨ́mej ɨ́ seica ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase meꞌɨ́jna jɨmeꞌe ɨ́ mej tíꞌijchaꞌɨɨcaꞌa aꞌɨ́mej ɨ́ ꞌuuca. ");
INSERT INTO crnNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Majta ɨ́ teɨte mej aꞌɨmuá aꞌuchéjme, maúcheꞌe mú ajteáxɨɨrijmeꞌecaa. Aꞌuu mú aꞌarácɨꞌɨcaꞌa seɨ́j chajtaꞌa jetze, ajtahuaꞌa seɨ́j, ajtahuaꞌa seɨ́j. Matɨ́ꞌɨj mauj eꞌevéꞌecɨ́ꞌɨcaꞌa, Jesús pu ayén tiuꞌutámuaritacaꞌa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Jaꞌatɨ tɨ nuꞌu hui tíꞌihuastehuaꞌa, u pu nuꞌu áꞌume tɨ tejéꞌehuasteꞌen. Aa pu auméꞌecaa ratáhuaꞌanáa ɨ́ imueꞌeri. Seica pu nuꞌu juye jetze huavatzɨ́jraa. Matɨ́ꞌɨj mi japuan huachéecajraa aꞌɨ́ɨme ɨ́ teɨte. Majta pinaꞌase, júteꞌɨmua mú aꞌicáraꞌaraveꞌe. Aa maꞌuráaseajráꞌa meráacuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","’Ajta seica ɨ́ imueꞌeri, aꞌúu pu nuꞌu hui huavatzɨ́jraa tetej tzajtaꞌa. Tɨ́ꞌɨj ajneájxɨ, aj pu i huaréꞌataa ɨ́ xɨcaj jɨmeꞌe aꞌiné capu huarɨéenajyeꞌicaa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","’Ajta seica ɨ́ imueꞌeri, aꞌúu pu nuꞌu huavatzɨ́jraa aꞌu tɨ aꞌutzícareꞌeme. Ajta aꞌɨ́ɨn ɨ́ tzicareꞌe, aꞌɨ́ɨ pu nuꞌu huavaújse jamuan ɨ́ imueꞌeri. Capu tiuꞌutáꞌa ɨ́ imueꞌeri tɨ teꞌejneájxɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","’Ajta seica ɨ́ imueꞌeri, áa pu nuꞌu huavatzɨ́jraa aꞌu tɨ aꞌurɨ́ꞌen ɨ́ chuej. Naímiꞌi pu hui huanéj. Jéihua pu nuꞌu tiúꞌucɨɨrecaꞌa. Jéihua pu jaítzeꞌe airájraa caí ɨ́ seica tɨ raahuáste. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. Tɨ́ꞌɨj raatapuáꞌajtacaꞌa tɨ tiuꞌutaxájtacaꞌa, aj pu i ayén tihuaꞌutáꞌixaa caꞌanín jɨmeꞌe, tɨjɨ́n: ―Mɨ́ sej huiteánajcaꞌamua, xáanamuajriꞌi hui temuaꞌa naa. Yee puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú raataꞌíhuaꞌuriꞌi aꞌij tɨ huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨ raatamuáritacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Dios pu amuaatáꞌa sej yaúꞌitɨée xaꞌaraa ɨ́ tɨ rúꞌavaa ɨ́ Dios jemi aꞌɨ́jna jɨmeꞌe aꞌij tɨ aꞌɨ́ɨn tíꞌaijta. Mɨ́ ajta ɨ́ seica, canu hui eꞌehuauritɨéecan jɨ́n tihuaꞌutáꞌixaateꞌesin, sino chuijtari nuꞌu jɨ́meꞌen tihuaꞌutáꞌixaateꞌesin tɨ ij ayén tihuáꞌuruuren aꞌij tɨ téꞌeyuꞌusiꞌi tɨjɨ́n: Múꞌeen xu nuꞌu xaa mé uunéjneꞌeri xáꞌajuꞌun. Aru, caxu tiꞌitɨ́j seijran. Múꞌeen xu xaa ranamua. Aru caxu hui yaúꞌitɨée xáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Aꞌɨ́jna ɨ́ niuucari nej raataxájtacaꞌa, ayée pu hui huataújmuaꞌa. Ɨ́ imueꞌeri, ayée pu ꞌeen tɨ́j ɨ́ niuucari tɨ Dios jemi éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","’Ajta ɨ́ imueꞌeri tɨ huavatzɨ́jraa juye jetze, ayée pu ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej ranamua ɨ́ niuucari tɨ Dios jemi éꞌemeꞌecan. Ajta aꞌɨ́ɨn tiyaaruꞌu, aꞌɨ́ɨ pu hui aꞌureꞌenén, tihuáꞌariꞌira ɨ́ niuucari tɨ huáꞌa tzajtaꞌa huateájturaa. Ayee pu rɨcɨ mej mi caí ráꞌantzaahuateꞌen, tɨ ij caí Dios huaꞌirájtuaani. ");
INSERT INTO crnNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","’Ajta aꞌɨ́jna ɨ́ tɨ tetej tzajtaꞌa huavatzɨ́jraa, ayée pu hui ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej huataújtemuaꞌave matɨ́ꞌɨj amuacaí ráanamuajriꞌi. Mɨ́ majta aꞌɨ́ɨme, camu aꞌatzu téꞌeviicuaꞌi. Aꞌatzu mú áꞌatee mej téꞌatzaahuateꞌe. Aru tɨ́ꞌɨjtá tejaꞌureꞌenén aꞌájna xɨcájraꞌa mej jetzen tirajpuaíitzi, camu chaꞌa teꞌutáviicuaꞌi. Caꞌanacan mú mé rúujɨsin. ");
INSERT INTO crnNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","’Ajta aꞌɨ́jna ɨ́ imueꞌeri tɨ aꞌuun huavatzɨ́jraa tzicareꞌe tzajtaꞌa, ayée pu hui ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej ranamua ɨ́ niuucari. Aru aꞌɨ́ɨme, ɨ́ mej mauj yen huatéꞌuu íiyen chaanaca japua, jéꞌecan mú aꞌij téꞌujmuaꞌate meꞌɨ́jna jɨmeꞌe ɨ́ tɨ huáꞌamuarɨꞌeristeꞌe naꞌari aꞌɨ́jna jɨmeꞌe ɨ́ mej jeíhua tíꞌijchaꞌɨɨ caꞌɨ́n aꞌɨ́jna jɨmeꞌe ɨ́ tɨ huaꞌaráanajche tɨ naa seijreꞌe. Aꞌɨ́j pu jɨ́n camu araúraste mej jeíhua rɨ́ꞌɨ tiuꞌutátuiireꞌen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","’Ajta aꞌɨ́jna ɨ́ imueꞌeri tɨ aꞌuun nuꞌu huavatzɨ́jraa ɨ́ chuej japua aꞌutɨ́ aꞌurɨ́ꞌen, ayée pu ꞌeen tɨ́j aꞌɨ́ɨme ɨ́ mej urarɨ́ꞌeneꞌejme ɨ́ ru tzajtaꞌa, majta áꞌujcaꞌane ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe tɨ Dios huaꞌutaꞌaíj nain jɨmeꞌe. Aꞌɨ́ɨ mú hui ranamua ɨ́ niuucari, majta ruꞌutéꞌan ɨ́ ru tzajtaꞌa. Majta teꞌutáviicuaꞌi. Ayee mú ꞌeen jɨ́n huarɨ́n, jeíhua mú rɨ́ꞌɨ tiuꞌutátuiireꞌesin ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi aꞌɨ́jna jɨ́meꞌen ɨ́ jaꞌatɨ tɨ hui aparaatu tiꞌitɨ́j tíchaꞌɨɨ? Tɨ́ꞌɨj ráꞌajtaira, ¿aꞌuné jetze iyéꞌeruuren? ¿Ni qui xaꞌari tzajtaꞌa ruutéchajtza naꞌari caama jete yeꞌiráchajtza? Capu xaa neꞌu. Jaꞌatɨ tɨ naꞌa án pu ɨmuá yaꞌujchájtza mej mi atáneere ɨ́ taij jɨmeꞌe ɨ́ mej aꞌuteáruꞌipi. ");
INSERT INTO crnNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ajta, naíjmiꞌi tɨ́j naꞌa mej avíitziꞌi jɨ́n miyen rɨcɨ ɨ́ teɨte, capu hui ayén éeneꞌe aꞌame. Aꞌɨ́ɨ mú xaa hui ramuaꞌaréeren tɨ́ꞌɨj Dios mé jéjreꞌe raataseíjrata. ");
INSERT INTO crnNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Rɨ́ꞌɨ xuꞌu múꞌeen sej si temuaꞌa naa tiráanamua, aꞌiné tɨ puaꞌa jaꞌatɨ tiꞌitɨ́j tíchaꞌɨɨ ɨ́ Dios jemi, Dios pu jaítzeꞌe tiraatáꞌasin. Ajta aꞌɨ́ɨn tɨ caí tiꞌitɨ́j tíchaꞌɨɨ ɨ́ Dios jemi, Dios pu hui ráꞌariꞌira aꞌɨ́jna ɨ́ tɨ ayén tiráꞌamitɨejteꞌe tɨ nuꞌu tíꞌijchaꞌɨɨ. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ajta aꞌɨ́ɨn náànajraꞌan ɨ́ Jesús, majta ihuáamuaꞌameꞌen, aꞌɨ́ɨ mú eꞌiréꞌene mej mi raaseíj. Aru, capu huatárɨꞌɨristarecaꞌa mej ajteáxɨɨre á vejliꞌi jemin aꞌiné jeíhua mú teɨte aitéꞌuucaꞌa táꞌapueerta. ");
INSERT INTO crnNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jaꞌatɨ pu ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Mé puaꞌacɨé mú aꞌutéꞌuu aꞌanáàna, majta aꞌihuáamuaꞌa. Méjxeꞌeveꞌe mej muaaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Aꞌii mú hui aꞌɨ́ɨn púꞌeen ɨ́ nináàna, majta ɨ́ neꞌihuaamuaꞌa, aꞌɨ́ɨme ɨ́ mej ranamua ɨ́ niuucari tɨ Dios jemi éꞌemeꞌecan, majta miyen rɨ́ꞌɨ tiráꞌastijreꞌe aꞌij tɨ tiúꞌujxeꞌeveꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jaꞌanáj tɨ ayén tiujuꞌurɨ́j. Jesús pu ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Tichéꞌe antácɨɨne u jetze pújmeꞌen aꞌu tɨ aꞌalaguun. Matɨ́ꞌɨj mi atéecɨ ɨ́ baarcu jetze. Matɨ́ꞌɨj mi aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Maúcheꞌe mú jaj japua huajúꞌucaa, tɨꞌɨquí huatácu aꞌɨ́jna ɨ́ Jesús. Tɨꞌɨj jí huatáꞌeecarecaꞌa, ajta jeíhua pu ateáxɨjrihuaꞌa ɨ́ jaj ɨ́ baarcu jetze. Muꞌuri tɨ́n aꞌucárutijmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú yaꞌujɨ́ste aꞌɨ́jna ɨ́ Jesús. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Maeestru, Tuꞌuri hui tɨ́n áꞌajamɨn. Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu ájchee. Tɨꞌɨj jí raatáꞌijmɨijriꞌi ɨ́ eeca, ajta japuutzari tɨ tiújtaꞌahuaꞌa. Jɨ́meꞌen puꞌu raatáꞌijmɨijriꞌi, aj pu i huateápuaꞌarecaꞌa. Tɨꞌɨj jí naa huaꞌéꞌeneꞌe jáꞌaraa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tɨꞌɨj jí ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n secaí téꞌatzaahuateꞌe? Ajta aꞌɨ́mej jemi, jéꞌecan utéevatzɨ ɨ́ huáꞌa tzajtaꞌa. Jéꞌecan mú majta aꞌij puaꞌa tiraꞌutaseíj. Ayee mú tíꞌiruꞌihuaꞌuracaꞌa tɨjɨ́n: ―¿Tiꞌitáani téviraꞌa púꞌeen amɨ́jna? Aꞌɨ́ɨ pu hui tihuáꞌaijteꞌe ɨ́ eeca, ajta ɨ́ jaj, majta hui ráꞌantzaahua. ");
INSERT INTO crnNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Matɨ́ꞌɨj antacɨ́j, aꞌúu mú aꞌaráꞌa aꞌúu tɨ huatacáꞌa u Gadara. U jetze pújmeꞌen tɨ éꞌeseijreꞌe u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tɨꞌɨj jí Jesús aꞌitáraa ɨ́ baarcu jetze. Aj pu i seɨ́j raꞌantinájchecaꞌa. Aꞌuu pu éꞌemeꞌecan ɨ́ chajtaꞌa jetze aꞌɨ́jna ɨ́ jaꞌatɨ. Tiyáaruꞌuse pu tzajtaꞌan seijreꞌe. Puꞌuri áꞌatee tɨ caí tiꞌitéchejcaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. Capu ajta chiꞌij jetze chejcaꞌa. Aꞌuu puꞌu eꞌechéjmeꞌe aꞌu mej mɨꞌɨchite eꞌevéꞌenaamuaca. ");
INSERT INTO crnNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Tɨ́ꞌɨj raaseíj aꞌɨ́jna ɨ́ Jesús, án pu eꞌerájve ɨɨcájraꞌan jetze ɨ́ Jesús. Jéꞌecan pu huajíjhuacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ. Aj pu i ayén tiraatajé caꞌanín jɨmeꞌe tɨjɨ́n: ―¿Aꞌiné tiꞌitɨ́j peteáruuren ineetzi jemi, Jesús, ɨ́ pej yaujraꞌan pɨ́rɨcɨ ɨ́ Dios tɨ ta japua éꞌeseijreꞌe? Ayee nu hui tíꞌimuahuavii. Capej hui puaíjtzi neetáꞌacareꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ayee pu aꞌɨ́ɨn jaꞌatɨ tiraatáhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn Jesús ari tiraataꞌaíj aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ nuꞌu huiirájraꞌani ɨ́ tevi jetze. Muꞌíi pu tiyaaruꞌu raatéeviꞌi aꞌɨ́jna ɨ́ jaꞌatɨ. Majta aꞌɨ́ɨme ɨ́ teɨte ɨ́ mej aꞌuun eꞌechéjmeꞌe, aꞌɨ́ɨ mú raꞌamuájɨꞌɨquihuaꞌa muájcaꞌareꞌaraꞌan jetze, majta ruꞌɨ́ɨca jetze alaambre jɨmeꞌe. Matɨ́ꞌɨj mi raatéꞌavaata. Ajta aꞌɨ́ɨn ɨ́ tevi, tɨ́ꞌɨj pɨ́ naꞌa pu rajtzáꞌanaꞌa ɨ́ꞌalaambre, ajta mé iyaúuruti aꞌu tɨ caí éꞌe tiꞌitɨ́j aꞌiné tiyaaruꞌu pu tzajtaꞌan seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tɨꞌɨj jí Jesús ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné puaꞌantehuaa múꞌee? Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: ―I tej sei viꞌiraꞌa aráꞌase. Ayee pu tiraataꞌixaa aꞌɨ́jna jɨmeꞌe ɨ́ mej muꞌiitɨ́ tzajtaꞌan seijreꞌe ɨ́ tiyáaruꞌuse. ");
INSERT INTO crnNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Majta aꞌɨ́ɨme ɨ́ tiyáaruꞌuse, jeíhua mú rájhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús tɨ ꞌij aꞌɨ́ɨn caí huaꞌutaꞌíte mej áꞌucɨɨne tɨ eꞌetécun aꞌu mej áꞌanamiꞌi ɨ́ tiyáaruꞌuse. ");
INSERT INTO crnNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Majta á vejliꞌi, ɨ́ tuiixu éꞌecɨɨne, áa mú tejáꞌucuaꞌanen jɨrí jetze. Majta aꞌɨ́ɨme tiyáaruꞌuse, ayée mú tiraatáhuaviiriꞌi meꞌɨ́jna ɨ́ Jesús tɨ huaꞌutáꞌan mej mi ɨ́ tuiixu tzajtaꞌa aꞌuteárute. Aj pu i huaꞌutáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Matɨ́ꞌɨj huiráacɨ ɨ́ tevi jetze, matɨ́ꞌɨj mi aꞌuruáachejraa caꞌanín jɨmeꞌe. Matɨ́ꞌɨj mi aꞌuteájrupi ɨ́ ɨ́ tuiixu tzajtaꞌa. Majta meꞌɨ́n ɨ́ tuiixu aꞌuruáachejraa. Matɨ́ꞌɨj mi ancáavatzɨ aꞌu tɨ eꞌencátee. Matɨ́ꞌɨj mi áataꞌa atéevatzɨ. Matɨ́ꞌɨj mi aꞌujámɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Majta aꞌɨ́ɨme ɨ́ mej huáꞌachaꞌɨɨcaꞌa ɨ́ tuiixu, matɨ́ꞌɨj raaseíj aꞌij tɨ tiꞌitɨ́j huarɨ́j, aꞌɨ́ɨ mú aꞌuruáachejraa. Matɨ́ꞌɨj mi huaꞌutáꞌixa ɨ́ teɨte chajtaꞌa mé éꞌeche, majta aꞌɨmuá mej aꞌuchéjme aꞌij tɨ tiꞌitɨ́j huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Matɨ́ꞌɨj mi aꞌɨ́ɨme ɨ́ teɨte, aꞌúu mú eꞌiréꞌene mej mi raaseíj. Matɨ́ꞌɨj aꞌuun eꞌiréꞌene aꞌu tɨ Jesús aꞌutéveecaꞌa, aꞌúu mú yáꞌuteu aꞌɨ́jna ɨ́ jaꞌatɨ ɨ́ mej jetzen huiráacɨ aꞌɨ́ɨme ɨ́ tiyáaruꞌuse. Aꞌuu pu aꞌutácatii ɨ́ Jesús jemi. Puꞌuri tiꞌitéchejcaꞌa. Capu chéꞌe rutɨ́muaꞌiracaꞌa. Matɨ́ꞌɨj mi tiuꞌutátziɨn temuaꞌa jeíhua. ");
INSERT INTO crnNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Majta aꞌɨ́ɨme ɨ́ mej raaseíj, aꞌɨ́ɨ mú tihuaꞌutáꞌixaa ɨ́ teɨte aꞌij tɨ Jesús tiráahuaa aꞌɨ́jna ɨ́ jaꞌatɨ tiyáaruꞌuse mej tzajtaꞌan seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Matɨ́ꞌɨj mi naímiꞌi ɨ́ mej aꞌuun aꞌuchéjme tɨ́j naꞌa tɨ aꞌuun huatacáꞌa u Gadara, aꞌɨ́ɨ mú rájhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús, tɨ nuꞌu áꞌuraꞌani aꞌiné jeíhua mú tiuꞌutátziɨn. Aꞌɨ́j pu jɨ́n Jesús ateájraa ɨ́ baarcu jetze. Tɨꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ tiyáaruꞌuse mej jetzen huiráacɨ, jeíhua pu rájhuaviiriꞌi aꞌɨ́jna ɨ́ Jesús tɨ raatáꞌan tɨ jamuan áꞌuraꞌani. Mɨ́ ajta i caí, capu raatáꞌa tɨ jamuan áꞌuraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Ayee pu tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj hui huaréꞌaraꞌani aꞌu pej éꞌeche patáꞌaj huaꞌutáꞌixaateꞌen aꞌij tɨ muáaruu ɨ́ Dios, aꞌɨ́jna jɨmeꞌe tɨ huápɨꞌɨ ruxeꞌeveꞌe. Aj pu i áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ. Tɨꞌɨj jí nainjapua tɨ́j naꞌa aꞌuun tɨ huatacáꞌa ɨ́ chajtaꞌa jetze, aꞌɨ́ɨ pu huaꞌutáꞌixa aꞌij tɨ tiꞌitɨ́ ráaruu tɨ huápɨꞌɨ ruxeꞌeveꞌe aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tɨ́ꞌɨj Jesús aꞌuréꞌaraa yú jetze pújmeꞌen, jeíhua mú teɨte raꞌancuréꞌeviꞌitɨ. Muaateújtemuaꞌave aꞌiné aꞌɨ́ɨ mú rachúꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Jɨ́meꞌen puꞌu Jesús aꞌuun aꞌaráꞌa, aj pu i seɨ́j ɨ́ jaꞌatɨ éꞌejtunutacaꞌa á vejliꞌi jemin ɨ́ Jesús. Ayee pu ántehuaa tɨjɨ́n Jairo. Aꞌɨ́ɨ pu tíꞌaijta u teyujtaꞌa. Tɨꞌɨj jí aꞌɨ́ɨn raatáhuaviiriꞌi tɨ Jesús aꞌuréꞌenen jemin chajnan aꞌiné puꞌuri nuꞌu áꞌameꞌere ɨ́ yaujraꞌan. Ajta, aꞌɨ́ɨ puꞌu caj pɨ́tíꞌijyauj, ɨ́iitacan. Ajta aꞌɨ́jna ɨ́ yaujraꞌan, ayée pu rájchaꞌɨɨ aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua nineꞌiraꞌa. Tɨꞌɨj jí Jesús áꞌuraa jamuan. Majta ɨ́ teɨte, jeíhua mú ajteáxɨɨrecaꞌa jemin. Temuaꞌa mú titéꞌecatacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa, áa pu ajta aꞌutéveecaꞌa. Puꞌuri áꞌatee aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua nineꞌiraꞌa tɨ ayén aꞌɨ́jna jɨ́n tíꞌicuiꞌi aꞌɨ́jna jɨmeꞌe tɨ tíꞌiraꞌasecareꞌe ɨ́ xúureꞌe. Capu méꞌe aꞌatɨ́jcaꞌa tɨ raayɨ́ꞌɨtɨhuaꞌa tɨ tiráahuaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tɨꞌɨj jí aꞌɨ́ɨn ꞌɨ́itaꞌa, huaritaꞌan aꞌuréꞌene. Aj pu i raꞌajtamuárɨej ɨ́ cɨ́ɨxureꞌaraꞌan jetze. Jɨ́meꞌen puꞌu raꞌajtamuárɨej, aj pu i huateápuaꞌarecaꞌa tɨ uvéꞌemɨꞌɨye ɨ́ xúureꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tɨꞌɨj jí Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌataani hui naꞌajtamuárɨej? Naímiꞌi mú miyen tiuꞌutaniú tɨjɨ́n: ―Canu nee. Matɨ́ꞌɨj miyen tiuꞌutaxájtacaꞌa, aꞌɨ́jna ɨ́ Pedro, aꞌɨ́ɨ pu ayén tiraataꞌixaa tɨjɨ́n: ―Maeestru, jeíhua mú ajteáxɨɨri ɨ́ teɨte múꞌeetzi jemi. Majta áꞌujtajche. ");
INSERT INTO crnNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mɨ́ ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Jaꞌatɨ pu xaa naꞌajtamuárɨej. Nee nu hui ráamuaꞌareeriꞌi tɨ́ꞌɨj nemuárɨꞌeriꞌiraꞌa huirájraa. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ajta aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu ráamuaꞌareeriꞌi tɨ caí rɨꞌɨrí tɨ huateúravaa. Tɨꞌɨj jí eꞌiréꞌene. Ruvivée. Aj pu i éꞌejtunutacaꞌa jemin ɨ́ Jesús. Tɨꞌɨj jí ayén tiuꞌutaxájtacaꞌa aꞌiné ꞌeen jɨ́n raꞌajtamuárɨej mé jéjreꞌe mejseíiracaꞌa ɨ́ teɨte. Ajta ayée pu tiuꞌutaxájtacaꞌa aꞌɨ́jna jɨmeꞌe tɨ huarúj. ");
INSERT INTO crnNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Niyauj, pepuꞌuri hui huarúj peꞌɨ́jna jɨmeꞌe pej téꞌatzaahuateꞌe. Aricu, áꞌuraꞌa axɨéehua. ");
INSERT INTO crnNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aúcheꞌe pu tiꞌixáatacaꞌa tɨ́ꞌɨj seɨ́j eꞌiréꞌene tɨ huáꞌa jetze ajtémeꞌecan ɨ́ mej aꞌuun éꞌeche ɨ́ Jairo jemi, aꞌɨ́jna tɨ tíꞌaijta u teyujtaꞌa. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Puꞌuri huamɨ́ꞌɨ ayauj. Aꞌɨ́j pej hui jɨ́n caí chaꞌa tiraꞌantiúꞌuuniꞌiraꞌan mɨ maestro. ");
INSERT INTO crnNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tɨ́ꞌɨj Jesús ayén tiráanamuajriꞌi, ayée pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jairo tɨjɨ́n: ―Capej tíꞌitziɨɨneꞌe. Patáꞌaj téꞌantzaahuateꞌen penaꞌa. Aúcheꞌe pu hui rujni. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Matɨ́ꞌɨj mi aꞌucɨ́j. Matɨ́ꞌɨj meꞌuun aꞌaráꞌa Jairo tɨ éꞌeche. Matɨ́ꞌɨj meꞌuun aꞌuréꞌene, capu huaꞌutáꞌa ɨ́ teɨte mej aꞌuun aꞌuteárute u chiꞌita. Aꞌɨ́mej puꞌu huatáꞌa aꞌɨ́jna ɨ́ Pedro, ajta aꞌɨ́jna ɨ́ Juan, ajta aꞌɨ́jna ɨ́ Jacobo. Ajta aꞌɨ́ɨme ɨ́ vaújsimuaꞌameꞌen ɨ́ tɨ huamɨ́ꞌɨ, aꞌɨ́mej pu ajta huatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Majta meꞌɨ́n ɨ́ teɨte á puaꞌacɨé mej aꞌutéꞌuucaꞌa, naímiꞌi mú caꞌanín jɨ́n ruyeinecaꞌa. Máujxɨeemɨsteꞌecaa micu. Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu ruyeine. Capu hui mɨꞌɨchi. Cutzú puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Matɨ́ꞌɨj mi raateꞌatzeájraa aꞌiné méjmuaꞌareerecaꞌa tɨjɨ́n huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tɨꞌɨj jí Jesús raꞌajtamuárɨej ɨ́ paꞌarɨꞌɨ ɨ́ muájcaꞌareꞌaraꞌan jetze. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Niyauj, ájchesi. ");
INSERT INTO crnNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tɨꞌɨj jí xɨéjniuꞌucareꞌaraꞌan huaréꞌaraa ɨ́ jemin. Jɨ́meꞌen puꞌu huaréꞌaraa ɨ́ jemin, aj pu i ájchee. Tɨꞌɨj jí Jesús ayén tíhuaꞌutaꞌaíj ɨ́ vaújsimuaꞌameꞌen mej nuꞌu tiraamín. ");
INSERT INTO crnNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Jéꞌecan mú naa rɨ́ꞌɨ tiraꞌutaseíj ɨ́ vaújsimuaꞌameꞌen. Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu huaꞌutáꞌijmɨijriꞌi mej caí jaꞌatɨ ixaateꞌe aꞌij tɨ tiꞌitɨ́j huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jaꞌanáj pu núꞌu ayén huarɨ́j aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́ɨ pu huaꞌutajé aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Aj pu tihuaꞌuꞌíjca aꞌɨ́jna jɨmeꞌe mej mi huaꞌutamuáriteꞌen aꞌɨ́mej ɨ́ tiyáaruꞌuse ɨ́ mej teɨte tzajtaꞌa seijreꞌe, majta mej nuꞌu tihuáꞌuhuaateꞌen tɨ́j naꞌa tiꞌipuaꞌamé ɨ́ cuíꞌiniꞌiraꞌa ɨ́ mej jɨ́n tíꞌicucuiꞌi ɨ́ teɨte. Jesús pu ajta huaꞌutáꞌa ɨ́ muárɨꞌeriꞌireꞌaraꞌan ɨ́ mej jɨ́n miyen tiúꞌuruuren. ");
INSERT INTO crnNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tɨꞌɨj jí huaꞌutaꞌítecaꞌa mej mi aꞌucɨ́jxɨꞌɨn mej mi tihuaꞌutáꞌixaateꞌen ɨ́ teɨte aꞌɨ́jna jɨmeꞌe ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ nainjapua tíꞌaijta. Ajta pu huaꞌutaꞌítecaꞌa mej mi tihuáꞌuhuaateꞌen ɨ́ mej tíꞌicucuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Caxu tiꞌitɨ́j anúꞌan ɨ́ sej jɨ́n huateújvaɨreꞌen ɨ́ juye jetze, ni tiꞌitɨ́j itzɨ́j, caꞌɨ́n tiꞌitɨ́j caꞌaní naꞌari tiꞌitɨ́j pan o tumin. Seajta hui, seɨ́j xuꞌu anpiín ɨ́ síicuꞌuri. Caxu huaꞌapuaca téꞌepiin. ");
INSERT INTO crnNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","’Aꞌuu tɨ naꞌa sej aráꞌaiixa aꞌájna aꞌu tɨ chiꞌij aꞌutéjvee, aꞌúu xu u áꞌateere ajta senaꞌa caí áꞌucɨɨne aꞌujna u chajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ajta, ayée xu hui huárɨni tɨ puaꞌa mecaí amuaꞌancuréꞌeviꞌitɨn. Setɨ́ꞌɨj áꞌucɨɨne seꞌújna u chajtaꞌa, xajtaújrɨ́ꞌɨpɨꞌɨn ɨ́ sej ajtácaꞌacaiméꞌe, seajta raatécaꞌatzɨjxɨꞌɨn tɨ ij cáaxɨn ɨ́ chuej. Ayee xu aꞌɨ́jna jɨ́n huarɨ́n, aj mú mi ramuaꞌaréeren mej auteájturaa ɨ́ Dios jemi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Matɨ́ꞌɨj mi aꞌucɨ́jxɨ nainjapua tɨ́j naꞌa aꞌuun tɨ huatacáꞌa. Nainjapua mú huaꞌutáꞌixa ɨ́ niuucari tɨ jɨ́n Dios huaꞌirátuaasin. Majta tihuáꞌuhuaa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ajta aꞌɨ́ɨn ɨ́ Heródes, aꞌɨ́jna tɨ tajtuhuan jɨ́n tiꞌitéveecaꞌa, aꞌɨ́ɨ pu ráamuaꞌareeriꞌi aꞌij mej tiꞌitɨ́j ruurejcaꞌa. Capu aꞌij tiráꞌamitɨejteꞌecaꞌa aꞌiné seica mú miyen tíꞌixajtacaꞌa tɨjɨ́n: ―Puꞌuri ajtahuaꞌa aꞌitáraa aꞌɨ́jna ɨ́ Juan aꞌujna mej yeꞌaváꞌana. ");
INSERT INTO crnNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Majta seica miyen tɨjɨ́n: ―Puꞌuri ajtahuaꞌa huataseíjre aꞌɨ́jna ɨ́ Elías. Majta seica miyen tíꞌixajtacaꞌa tɨ nuꞌu seɨ́j pu aꞌitáraa huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ajta aꞌɨ́ɨn Heródes, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Teajta hui raꞌantiveíjchecaꞌa ɨ́ muꞌúuraꞌan neꞌɨ́jna ɨ́ Juan. Aꞌɨ́j pu jɨ́n caí aꞌɨ́ɨn púꞌeen. ¿Aꞌatajqui naꞌa púꞌeen aꞌɨ́jna ɨ́ nej jɨ́meꞌen niyen tíꞌinamua? ―Ayee pu tiuꞌutaxájtacaꞌa. Ajta huataújtese tɨ raaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Majta meꞌɨ́n ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, matɨ́ꞌɨj muꞌu pɨ́jaꞌuréꞌavatzɨ, matɨ́ꞌɨj mi miyen tiraataꞌixaa meꞌɨ́jna ɨ́ Jesús aꞌij mej tiꞌitɨ́j huáruu. Tɨꞌɨj jí aꞌɨ́ɨn huáꞌuviꞌitɨ aꞌɨ́mej. Matɨ́ꞌɨj mi aꞌucɨ́j rujɨ́ɨmuaꞌa aꞌujna jáꞌahuaꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betsaída. ");
INSERT INTO crnNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Majta meꞌɨ́n ɨ́ teɨte, matɨ́ꞌɨj ráamuaꞌareeriꞌi, aꞌúu mú eꞌiréꞌene aꞌu tɨ aꞌutéveecaꞌa ɨ́ Jesús. Aꞌɨ́ɨ pu huaꞌancuréꞌeviꞌitɨ. Ajta tihuaꞌutáꞌixaa aꞌij tɨ ꞌeen aꞌɨ́jna jɨmeꞌe tɨ Dios tíꞌaijta nainjapua. Ajta tihuáꞌuhuaa ɨ́ mej tiꞌicúcuiꞌimeꞌecaa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tɨ́ꞌɨj huaréꞌechuijxarecaꞌa, aꞌɨ́ɨme ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́ɨ mú eꞌiréꞌene ɨ́ Jesús jemi. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj huaꞌaréꞌeꞌitixɨꞌɨn ɨ́ teɨte mej mi aꞌucɨ́jxɨꞌɨn tɨ́j naꞌa aꞌuun mej huachéjme u chajtaꞌa, ajtahuaꞌa ayée ɨmuá mej aꞌuchéjme, mej mi meꞌuun tiúꞌunanan tiꞌitɨ́j mej ráacuaꞌani, mej mi majta meꞌuun aꞌucuꞌutzu aꞌiné capu hui yeꞌe tiꞌitɨ́j ayajna aꞌu tej aꞌutéꞌuu. ");
INSERT INTO crnNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj múꞌeen tihuaꞌumín. Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Aii tuꞌu tíchaꞌɨɨ aꞌachú cumu anxɨ́vica ɨ́ pan, teajta huaꞌapuaca ɨ́ huaꞌité, caꞌɨ́n tej tejaꞌuvéꞌenanan ɨ́ mej jɨ́n tiúꞌucuaꞌani naíjmiꞌi. ―Ayee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Majta aꞌɨ́ɨme ɨ́ teteca, ayée mú aráꞌase aꞌachú cumu anxɨ́j viꞌiraꞌa. Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Micheꞌe aꞌujráꞌase ɨ́ teɨte, muáacua jetze muaꞌarástɨméꞌe, méyee majta méyee. ");
INSERT INTO crnNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Matɨ́ꞌɨj mi miyen huarɨ́j. Majta ɨ́ teɨte, naímiꞌi mú aꞌujráꞌasecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aj pu i Jesús, raꞌancuréꞌeꞌɨꞌɨpɨ ɨ́ pan, ajta ɨ́ huaꞌité. Aj pu i júteꞌe áꞌujneerecaꞌa. Rɨ́ꞌɨ pu tiraatáꞌa ɨ́ Dios. Ajta, aꞌutéjche tɨ raꞌantítaaraxɨꞌɨn ɨ́ pan, ajta ɨ́ huaꞌité. Aj pu i huaꞌutáꞌɨ́ꞌɨpɨꞌi aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi autéjhuii mej haꞌuréꞌeꞌɨꞌɨpɨiteꞌen ɨ́ teɨte. Aꞌatzu mú áꞌatee mej huaꞌuréꞌeꞌɨꞌɨpɨiteꞌesin ɨ́ pan, majta ɨ́ huaꞌité. ");
INSERT INTO crnNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Naímiꞌi mú tiúꞌucuaa. Temuaꞌa mú titéejuꞌuxai. Majta aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, maúcheꞌe majta teꞌevéꞌejɨsteꞌaxɨ sicɨ́ri jetze meꞌɨ́jna tɨ teꞌaváꞌaturaa. Ajta aꞌɨ́ɨn ɨ́ sicɨ́ri, ayée pu teꞌaráꞌasecaꞌa aꞌachú cumu tamuáamuataꞌa japuan huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jaꞌanáj pu ayén tiujuꞌurɨ́j. Aꞌuu pu jáꞌahuaꞌa Jesús téniuusimeꞌe ruseɨ́j. Aꞌɨ́ɨ mú raseíjracaꞌa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné metíꞌixa ɨ́ teɨte jaꞌatá núꞌu ne púꞌeen inee? ");
INSERT INTO crnNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ayee mú tiraataꞌixaa tɨjɨ́n: ―Seica mú miyen tiꞌixa tɨjɨ́n múꞌee pe nuꞌu peꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ Juan tɨ huáꞌamuaɨꞌɨhuacareꞌe. Majta seica miyen tɨjɨ́n múꞌee pe nuꞌu peꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ Elías tɨ ajmíꞌi seijreꞌecaꞌa. Majta seica miyen tɨjɨ́n seɨ́j pej nuꞌu aꞌitáraa huáꞌa jemi ɨ́ mɨꞌɨchite tɨ Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―Ari múꞌeen, ¿aꞌiné setíꞌimuaꞌatze jaꞌatá ne púꞌeen? Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiraataꞌixaa tɨjɨ́n: ―Múꞌee pe hui peꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu tɨ Dios án mú jáꞌujra ɨ́ ɨpuari japua. ");
INSERT INTO crnNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ajta aꞌɨ́ɨn ɨ́ Jesús, jeíhua pu huauꞌíjca mej nuꞌu caí jaꞌatɨ ixaateꞌe jaꞌatɨ tɨ púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ajta Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu tiúꞌujxeꞌeveꞌe ineetzi jemi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte nej ni inee jeíhua rajpuaíitzi náꞌaraꞌani. Majta aꞌɨ́ɨme ɨ́ huaꞌavaujsi, majta aꞌɨ́ɨme ɨ́ mej tíꞌaijta u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa, naímiꞌi mú hui netíti. Majta neejéꞌicatan. Ajta, tɨ́ꞌɨj teuuméꞌeca huaíca xɨcaj, naꞌitaméj huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite nej ni ruuri náꞌaraꞌani. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tɨꞌɨj jí ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa jaꞌatɨ raxɨ́ꞌeveꞌe tɨ áꞌucheꞌecaneꞌen nee jamuan, ayée pu ruxeꞌeveꞌe tɨ aꞌɨ́ɨn amuacaícan mé rúurɨeni aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ ru tzajtaꞌa. Ajta áꞌiyen chaꞌa aꞌɨ́ɨn huataúraꞌan tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame tɨ ayén cheꞌatá naꞌa tirajpuaíitzi áꞌaraꞌani netɨ́j hui inee tirajpuaíitzi naꞌame. Chéꞌe aꞌɨ́ɨn ajta ayén huárɨni aꞌij nej tíꞌiraxeꞌeveꞌe inee, tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","’Ayee puꞌu, tɨ puaꞌa jaꞌatɨ aꞌɨ́jna jɨ́n tíꞌiteseꞌe tɨ nain tíꞌijseɨreꞌen tɨ́j naꞌa puaꞌamé yen tíꞌiseijreꞌe tɨ́ꞌij ruxɨéehua chée áꞌaraꞌani, aru tɨ puaꞌa ari huámɨꞌɨni, capu chaꞌa aꞌij tiraatévaɨreꞌesin aꞌɨ́jna tɨ tíꞌijchaꞌɨɨ. Ajta tɨ puaꞌa jaꞌatɨ huámɨꞌɨni aꞌɨ́jna jɨmeꞌe tɨ naꞌaráꞌastijre ineetzi, aꞌɨ́ɨ pu xaa hui aúcheꞌe rateuni ɨ́ ruxɨ́ejniuꞌuca tɨ auj ruuricaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","’Ahuii, ¿aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Aꞌiné tiꞌitɨ́j tiraatévaꞌɨri ɨ́ jaꞌatɨ tɨ nain huamuáꞌitɨn tɨ ayén seijreꞌe íiyen chaanaca japua tɨ puaꞌa áꞌiyen yáꞌurɨeeni aꞌɨ́jna ɨ́ jaꞌatɨ ɨ́ ruxɨ́ejniuꞌuca tɨ aúcheꞌe ruuricaꞌa? Capu hui aꞌatzu tiꞌitɨ́j aꞌij tiraatévaꞌɨri, tzɨ́teꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","’Tɨ́ puaꞌa jaꞌatɨ tíꞌiteviꞌiraꞌa ineetzi jemi naꞌari tíꞌiteviꞌiraꞌa aꞌij nej tiꞌixa, inee i nej neajta huáꞌa jetze airáane ɨ́ teɨte, ayée nu hui cheꞌatá nenaꞌa tiuꞌutatéviꞌiraꞌata ɨ́ jemin aꞌájna xɨcájraꞌa nej jetzen yé veꞌecánejsin. ’Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌájna nu xaa yé veꞌecánejsin, netiꞌitevée nu naꞌame tiꞌitɨ́j Rey jɨmeꞌe. Ayee nu cheꞌatá nain jɨ́n teꞌentínmuaꞌaréere naꞌame tɨ́j ɨ́ niyáꞌupua. Neajta nu huataseíjreꞌesin huáꞌa jamuan ɨ́ mej tíꞌivaɨreꞌe ɨ́ ta japua. Huápɨꞌɨ pu hui naa seíireꞌe aꞌame mej mi naa rɨ́ꞌɨ tínaꞌutaseíj ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","’Ayee nu hui tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, seica mej yé huatéꞌuu ayajna, camúu xɨ cuiꞌini sino matɨ́ꞌɨj amuacaícan raseijran tɨ Dios tiuꞌutaꞌaíjta íiyen chaanaca japua. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Teuuméꞌeca aꞌachú cumu aráhuaica xɨcaj tɨ Jesús ayén tiuꞌutaxájtacaꞌa, aj pu i aꞌɨ́mej aꞌuvíꞌitɨ, aꞌɨ́jna ɨ́ Pedro, ajta aꞌɨ́jna ɨ́ Juan, ajta aꞌɨ́jna ɨ́ Jacobo. Matɨ́ꞌɨj mi anticɨ́j ɨ́ jɨrí japua. Tɨꞌɨj jí Jesús aꞌutéjche tɨ huatéjniuuni. ");
INSERT INTO crnNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tɨ́ꞌɨj auj téniuusimeꞌe, aj pu i seɨcɨé huaújruu aꞌɨ́jna ɨ́ Jesús ɨ́ runéerime jetze. Temuaꞌa pu naa tiuꞌutécuainarecaꞌa ɨ́ cɨ́ɨxureꞌaraꞌan. Ayee pu tiꞌitétaaveꞌe cumu metémaxcavaꞌara. ");
INSERT INTO crnNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Matɨ́ꞌɨj mi huaꞌapua huataseíjre jamuan ɨ́ Jesús. Aꞌii mú meꞌɨ́n púꞌeen, aꞌɨ́jna ɨ́ Moisés teecan, ajta aꞌɨ́jna ɨ́ Elías. ");
INSERT INTO crnNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huápɨꞌɨ mú naa seijreꞌecaꞌa. Majta jamuan tíꞌixajtacaꞌa aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j mú jɨ́n tiúꞌurixaateꞌecaa aꞌɨ́jna ɨ́ tɨ jɨ́n araúrastejsin aꞌájna Jerusalén, tɨ aꞌɨ́ɨn huámɨꞌɨni aꞌájna. ");
INSERT INTO crnNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ajta aꞌɨ́ɨn ɨ́ Pedro, majta ɨ́ mej huaꞌapua ɨ́ mej aꞌutéꞌuucaꞌa jamuan, jeíhua mú cuꞌutzícucaꞌa. Matɨ́ꞌɨj huájɨ, matɨ́ꞌɨj mi huaꞌuseíj aꞌɨ́mej ɨ́ teteca ɨ́ mej áa huatéꞌuucaꞌa jamuan ɨ́ Jesús. Majta raaseíj aꞌij tɨ éeneꞌe ɨ́ Jesús tɨ jeíhua huápɨꞌɨ naa seijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Matɨ́ꞌɨj meri áꞌucɨɨnicu aꞌujna tɨ aꞌutéjvee ɨ́ Jesús aꞌɨ́ɨme mej huaꞌapua ɨ́ teteca, aj pu i ayén Pedro tiraataꞌixaa tɨjɨ́n: ―Maestro, naa pu xɨ́ꞌepɨꞌɨn tej yé huatéꞌuu. Tichéꞌe hui huaícaca huátaahuaa, ɨ́ ɨnaamua, seɨ́j tɨ múꞌeetzi aꞌáa aꞌame, ajta seɨ́j, Moisés tɨ raꞌáa áꞌaraꞌani, ajta seɨ́j, Elías tɨ raꞌáa áꞌaraꞌani. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Pedro aꞌiné capu aꞌij ráꞌamitɨejteꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Tɨ́ꞌɨj auj tiꞌixáatacaꞌa, aj pu i jaitɨri huataseíjre. Aj pu i huáꞌa jetze rájrupi. Tɨ́ꞌɨj huáꞌa jetze rájrupi, matɨ́ꞌɨj mi tiuꞌutátziɨn aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tɨꞌɨj jí niuucari eꞌicánamuajre ɨ́ jaitɨri tzajtaꞌa, ayén tɨjɨ́n: ―Aꞌii pu hui aꞌɨ́ɨn púꞌeen ɨ́ niyauj, ɨ́ nej raꞌantíhuaꞌu. Setáꞌaj ráanamua. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tɨ́ꞌɨj ayén tiuꞌutaxájtacaꞌa, án pu aꞌutevée jáꞌaraa ruseɨ́j aꞌɨ́jna ɨ́ Jesús. Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú ruꞌutéꞌaa ɨ́ ru tzajtaꞌa. Camu jaꞌatɨ huatáꞌixaa aꞌij mej tiuꞌuséij. ");
INSERT INTO crnNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Yee ruijmuaꞌa yee, matɨ́ꞌɨj meri acáacɨ ɨ́ jɨrí japua, jeíhua mú teɨte raꞌantinájchecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ajta seɨ́j pu aꞌutéveecaꞌa huáꞌa tzajtaꞌa ɨ́ teɨte. Aꞌɨ́ɨ pu raatajé tɨjɨ́n: ―Maeestru, jeíhua nu hui muahuavii pej yaꞌutéeseij ɨ́ niyauj, aꞌiné aꞌɨ́ɨ nuꞌu caj tiꞌijyaúj. ");
INSERT INTO crnNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Xɨ́ejniuꞌucari tɨ aꞌij puaꞌa ꞌeen, aꞌɨ́ɨ pu hui rájviiviꞌi. Aꞌɨ́j pu jɨ́n, jeíhua rujíjhuaveꞌe ɨ́ paꞌarɨꞌɨ. Ajta jeíhua pu huáꞌaruri ratáꞌaca ɨ́ jetzen. Aꞌɨ́j pu jɨ́n, áijjaamɨxcueꞌireꞌe ɨ́ ruteneꞌe jetze. Cɨ́j puꞌu tiratáꞌaca tɨ ruxɨéehua rɨ́ꞌɨ mé tejáꞌucheꞌecaneꞌen. Puꞌuri ráꞌapuaꞌajteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nehuáꞌuhuaviiriꞌi hui neꞌɨ́mej ɨ́ mej á jamuan áꞌujujhuaꞌan mej raatamuáriteꞌen tɨ tzajtaꞌan seijreꞌe. Majta caí raayɨ́ꞌɨtɨhuaꞌa. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaniú: ―Múꞌeen mɨ sej iiji huáteemua, caxu hui téꞌatzaahuateꞌe, mɨ sej aꞌij puaꞌa tíꞌiteteɨte. ¿Aꞌachúni ruxeꞌeveꞌe nej aꞌateeviꞌi múꞌejmi jemi nej ni rɨ́ꞌɨ amuáaruuren? Mé jeꞌevéꞌeviꞌitɨchi mɨ paꞌarɨꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Tɨ́ꞌɨj auj eꞌevéꞌemeꞌecaa, aꞌɨ́ɨ pu tiyaaruꞌu raꞌitárɨe á chuaataꞌa, ajta huáꞌaruri raatáꞌa. Aru aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu raꞌajtéꞌaxɨ ɨ́ tiyaaruꞌu. Aj pu i tiráahuaa ɨ́ paꞌarɨꞌɨ. Ajta raatátui ɨ́ táàtajraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Majta naímiꞌi mú naa rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́jna jɨmeꞌe tɨ Dios ayén ráaruu aꞌɨ́jna tɨ huápɨꞌɨ ruxeꞌeveꞌe. Matɨ́ꞌɨj mauj aꞌij tejáꞌuseijracaꞌa ɨ́ teɨte meꞌɨ́jna jɨmeꞌe aꞌij tɨ Jesús huarɨ́j, ayée pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Ayen tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen tiráanamua. Ayee pu hui tíꞌineruuren ineetzi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. Avíitzi mú jɨ́n neetzi tiuꞌutátuiireꞌesin huáꞌa jemi ɨ́ teɨte. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, camu yaúꞌitɨée muáꞌaraa aꞌij tɨ huataújmuaꞌa ɨ́ niuucari tɨ raataxájtacaꞌa aꞌɨ́jna ɨ́ Jesús, sino huateúravaatacaꞌa mej mi caí yaúꞌitɨée muáꞌaraꞌani. Majta mú tíꞌitziɨɨneꞌecaꞌa. Aꞌɨ́j mú jɨ́n caí raataꞌíhuaꞌuriꞌi meꞌɨ́jna jɨmeꞌe aꞌij tɨ huataújmuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jaꞌanáj pu ayén tiujuꞌurɨ́j. Aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú autéjhuii mej tiúꞌujeeve aꞌɨ́jna jɨmeꞌe yee aꞌatani jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee iteen tej tamuáamuataꞌa japuan huaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu ramuaꞌareerecaꞌa aꞌij mej tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa. Aj pu i paꞌarɨꞌɨ avéꞌeviꞌitɨ. Tɨ́ꞌɨj i á vejliꞌi raatéjche aꞌu tɨ aꞌutéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Jaꞌatɨ tɨ naꞌa tɨ raꞌancuréꞌeviꞌitɨn aꞌíjna i paꞌarɨꞌɨ neniúucajtzeꞌe, aꞌɨ́ɨ pu hui ajta naꞌancuréꞌeviꞌitɨn ineetzi. Ajta aꞌɨ́ɨn tɨ naꞌancuréꞌeviꞌitɨn ineetzi, aꞌɨ́ɨ pu ajta raꞌancuréꞌeviꞌitɨn aꞌɨ́jna tɨ tinaataꞌaíj. Ayee puꞌu tíꞌeen aꞌiné aꞌɨ́jna tɨ jaítzeꞌe cɨ́lieeneꞌen jɨ́n tiꞌitéjvee múꞌejmi mɨ sej nee jamuan áꞌujujhuaꞌan, ɨ́ Dios jemi, aꞌɨ́ɨ pu hui jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee caí máàj jaꞌatɨ. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ajta aꞌɨ́ɨn ɨ́ Juan, ayée pu tiraataꞌixaa tɨjɨ́n: ―Maeestru, jaꞌatɨ tu aꞌuséij tɨ huáꞌamuariteꞌecaꞌa ɨ́ tiyáaruꞌuse mej huáꞌa tzajtaꞌa seijreꞌe ɨ́ teɨte. Aniúucajtzeꞌe pu jɨ́n huáꞌamuariteꞌecaꞌa. Teajta iteen, teen tu hui raatáꞌijmɨijriꞌi tɨ caí ayén rɨjcaa, aꞌiné capu téjmi jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Tɨꞌɨj jí ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Caxu ráꞌijmɨijra, aꞌiné jaꞌatɨ tɨ naꞌa tɨ caí aꞌij áꞌamuaruure, aꞌɨ́ɨ pu xaa áꞌamuavaɨreꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tɨ́ꞌɨj ari vejliꞌitacaꞌa tɨ tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌa tɨ jetzen Dios ráꞌaviꞌitɨn ɨ́ ta japua, Jesús pu raaxɨ́ꞌepɨꞌɨntare nain jɨmeꞌe tɨ aꞌuun aꞌujnén ánti Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Seica pu huataꞌítecaꞌa mej mi amuacaí aꞌujnén. Aa mú aꞌaráꞌa chajtaꞌa aꞌu mej aꞌuchéjme aꞌɨ́ɨme ɨ́ Samaria tɨ éꞌemeꞌecan. Aꞌuu mú aꞌatanéj mej mi rɨ́ꞌɨ tiúꞌuruuren aꞌu mej aráꞌaiixa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Majta aꞌɨ́ɨme ɨ́ mej aꞌuun éꞌechejcaꞌa, camu raꞌancuréꞌeviꞌitɨ meꞌɨ́jna ɨ́ Jesús, aꞌiné muꞌuri ramuaꞌareerecaꞌa tɨjɨ́n Jerusalén pu aꞌujnéjsin. ");
INSERT INTO crnNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Majta aꞌɨ́ɨme ɨ́ mej huaꞌapua, aꞌɨ́jna ɨ́ Jacobo, ajta aꞌɨ́jna ɨ́ Juan, matɨ́ꞌɨj ráamuaꞌareeriꞌi, ayée mú tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Tavastaraꞌa, ¿aꞌiné hui petíꞌijxeꞌeveꞌe tej ti tiyen huárɨni? ¿Ni teraataꞌáijteꞌen ɨ́ Dios tɨ júteꞌe yeꞌicáxɨreꞌen ɨ́ taij tɨ jɨ́n huáꞌucuiꞌini naíjmiꞌica, matɨ́j menaꞌa ayén mej huachéjme? ―Ayee mú tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Aj pu i Jesús pɨ́ aꞌuréꞌeve. Aj pu i huaꞌajtéꞌaxɨ. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ca xu hui ramuaꞌaree tiꞌitɨ́j tɨ xɨéjniuꞌucareꞌaraꞌan ayén caꞌaníjraꞌa tejamuaatáꞌaca sej si siyen tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aꞌiné inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, canu hui neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej nej ni huaꞌantipuáꞌajteꞌen ɨ́ teɨte, sino aꞌɨ́j nu jɨ́n mú aꞌuvéꞌemej nej ni huaꞌirájtuaani. ―Ayee pu tihuaꞌutáꞌixaa. Majta aꞌucɨ́j. Majta seɨ́j chajtaꞌa jetze aꞌatanéj. ");
INSERT INTO crnNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Matɨ́ꞌɨj mauj huajúꞌucaa ɨ́ juye jetze, seɨ́j pu ayén tiraataꞌixaa tɨjɨ́n: ―Nee nu hui á jamuan aꞌuméꞌe naꞌame aꞌu tɨ naꞌa pe áꞌume. ");
INSERT INTO crnNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ arachuíjse, aꞌúu mú hui uꞌuche aꞌu tɨ aucúcuꞌunijmee. Majta aꞌɨ́ɨme ɨ́ pinaꞌase, piꞌista jetze mú tiúꞌurituꞌaate. Mɨ́ neajta inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, canu huatéechiꞌi aꞌu nej aꞌutácuti. ");
INSERT INTO crnNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús pu seɨ́j huataꞌáij ɨ́ tevi tɨjɨ́n: ―Patáꞌaj áꞌucheꞌecaneꞌen nee jamuan. Ajta aꞌɨ́ɨn teáataꞌa, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nicheꞌe neꞌu yé huatácati ajta caí huámɨꞌɨni ɨ́ nitáàta nej ni raꞌaváꞌanan aꞌij tej tíꞌijrɨꞌɨre iteen. Aj nu xaa á jamuan áꞌucheꞌecaneꞌe naꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús pu ayén tiraataꞌixaa tɨjɨ́n: ―Micheꞌe meꞌɨ́n raꞌaváꞌanan ɨ́ mɨꞌɨchi aꞌɨ́ɨme ɨ́ huaꞌaxɨ́ꞌej mɨꞌɨchite meꞌɨ́jna jɨmeꞌe ɨ́ mej caí ramuaꞌate ɨ́ Dios. Pajta múꞌee, aricu áꞌuraꞌa pej pi ɨ́ niuucari huaꞌutáꞌixaateꞌen tɨ jɨ́meꞌen raxa ɨ́ Dios tɨ nainjapua tíꞌaijta. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ajtahuaꞌa seɨ́j pu ayén tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, nee nu hui á jamuan áꞌucheꞌecaneꞌe naꞌame, aru nauj miꞌi u aꞌatanén ne éꞌeche nej ni huaꞌutateújteꞌen ɨ́ neꞌihuaamuaꞌa, neajta ɨ́ nevaújsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Aꞌɨ́jna ɨ́ jaꞌatɨ tɨ aꞌutéjche tɨ tíꞌimuarɨꞌe, tɨ puaꞌa ari jáꞌitaꞌa uméꞌeca ajta raatéxɨeehua, aꞌɨ́ɨ pu hui caí tiꞌitɨ́j vaɨreꞌe jemin ɨ́ Dios tɨ nainjapua tíꞌaijta. ");
INSERT INTO crnNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Aꞌatzu aꞌateeviꞌi, Jesús pu ajtahuaꞌa seica avéꞌejajpuaxɨ ɨ́ mej ayén puaꞌaméca aꞌachú cumu huaícate japuan tamuáamuataꞌa aráꞌase. Aꞌɨ́ɨ pu huaꞌutaꞌítecaꞌa huaꞌapuacajméꞌen mej mi anáatéꞌee u eꞌaráꞌasti nainjapua aꞌu tɨ naꞌa mej aꞌuchéjme, aꞌu tɨ Jesús huájeꞌemuáarencheꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Muꞌiitɨ́ muꞌuri tɨ́n áꞌujcaꞌane tɨ Dios tíhuaꞌutaꞌaíjteꞌen, aru camu muꞌíi aꞌɨ́ɨme ɨ́ mej aꞌɨ́jna jɨ́n tíꞌivaɨreꞌe mej tihuaꞌutáꞌixaateꞌen ɨ́ niuucari tɨ jɨ́n Dios huaꞌirájtuaani. Aꞌɨ́j xu hui jɨ́n siyen tiraatáhuavii ɨ́ tavástaraꞌa ɨ́ tɨ jemin tiuꞌutátuiireꞌesin naíjmiꞌica jɨmeꞌe ɨ́ mej téꞌatzaahuateꞌe, tɨ aꞌɨ́ɨn tejámuaataꞌaíjteꞌen sej aꞌucɨ́jxɨꞌɨn nainjapua aꞌu mej éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","’Sericu múꞌeen. Ayee nu hui tejámuaataꞌaíjteꞌesin sej si huáꞌa tzajtaꞌa áꞌujujhuaꞌaneꞌen ɨ́ teɨte. Ayee xu seíireꞌe xáꞌajuꞌun matɨ́j cáneꞌaxɨ mej huáꞌa tzajtaꞌa áꞌujujhuaꞌan ɨ́ jɨ́ɨraꞌave. ");
INSERT INTO crnNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Caxu hui caꞌaní téꞌepiin sej tumin tzajtaꞌa ucáꞌan, caxu seajta caꞌaní téꞌepiin sej tiúꞌujcɨɨxu teꞌucáꞌan, caxu seajta tiúꞌucaꞌacái téꞌɨꞌɨpɨꞌɨn. Caxu jaꞌatɨ teujteꞌe ɨ́ juye jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Setɨ́ꞌɨj chiꞌita uteárute, miꞌi sej siyen tiraatateújteꞌen yee: “Rɨ́ꞌɨ xu yee tíꞌitechejca.” ");
INSERT INTO crnNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","’Seajta tɨ puaꞌa aꞌuun éꞌeseijreꞌe seɨ́j ɨ́ tevi tɨ xaa rɨ́ꞌɨ tíꞌiche, aꞌɨ́ɨ xu hui huateáturaasin jemin ɨ́ sej jɨ́n raatateújte. Naꞌari caí, ajtahuaꞌa huateáturaasin múꞌejmi jemi ɨ́ sej jɨ́n raatateújte. ");
INSERT INTO crnNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","’Aꞌuu xu áꞌateere aꞌájna chiꞌij jetze aꞌu sej aráꞌaiixa. Tiꞌitɨ́j tɨ naꞌa mej tejáꞌamuamin, aꞌɨ́j xu hui huácuaꞌani, seajta raayéꞌen. Ayee xu huárɨni aꞌiné ayée pu tiraavíjteꞌe mej tiraanájchiteꞌen aꞌɨ́jna ɨ́ tɨ tíꞌimɨjhuaca. Caxu áꞌujujhuaꞌaneꞌen méyee seajta méyee huáꞌache. ");
INSERT INTO crnNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Setɨ́ꞌɨj seꞌuun aꞌuteárute seɨ́j jetze ɨ́ chajtaꞌa, tɨ puaꞌa aꞌɨ́ɨme amuaꞌancuréꞌeviꞌitɨn, ayée xu huárɨni. Tiꞌitɨ́ mej án amuaajáꞌujmuaniira, aꞌɨ́j xu huácuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Setáꞌaj seajta tihuáꞌuhuaateꞌen aꞌɨ́mej ɨ́ mej tiꞌicúcuiꞌijme. Seajta hui siyen huaꞌutáꞌixaateꞌen yee puꞌuri tɨ́muaꞌa tejaꞌuréꞌenejsin tɨ Dios nainjapua tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","’Naꞌari, tɨ puaꞌa mecaí amuaꞌancuréꞌeviꞌitɨn setɨ́ꞌɨj eꞌaráꞌasti seɨ́j jetze ɨ́ chajtaꞌa, ayée xu caaye jetze áꞌujujhuaꞌaneꞌen. Ayee xu hui tihuaꞌutáꞌixaateꞌen yee: “Aꞌɨ́jna ɨ́ chuej, tɨ muiini tɨ ajtáviꞌitaxɨ ɨ́ tacaꞌacai jetze, íiye tɨ chajtaꞌa meꞌecan, aꞌɨ́j tu huatécaꞌatzɨjxɨꞌɨsin sej si ráamuaꞌaree sej veꞌecán jɨ́n auteájturaa ɨ́ Dios jemi. Capu amɨ́n aꞌij sej seri tiúꞌuruu. Aúcheꞌe pu yeráꞌaiixa jaꞌanáj tɨ tejaꞌuréꞌenejsin tɨ Dios tiuꞌutaꞌaíjta nainjapua íiyen chaanaca japua.” Ayee xu hui tihuaꞌutáꞌixaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","’Ayee nu hui tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Aꞌájna xɨcájraꞌa jetze tɨ́ꞌɨj yeráꞌaiixa ɨ́ Dios tɨ ij aꞌɨ́ɨn huáꞌaxɨjteꞌen, jaítzeꞌe mú hui rajpuaíitzi muáꞌajuꞌun aꞌɨ́ɨme ɨ́ mej caí amuaꞌancuréꞌeviꞌitɨ aꞌujna chajtaꞌa mej caí aꞌɨ́ɨme ɨ́ mej Sodoma eꞌechéjmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Mɨ sej hui Corazín éꞌemeꞌecan, setáꞌaj huataújxɨeemɨsteꞌen. Seajta múꞌeen, mɨ sej Betsaída éꞌemeꞌecan, setáꞌaj seajta huataújxɨeemɨsteꞌen, aꞌiné múꞌejmi tzajtaꞌa, jeíhua nu niyen huarɨ́j tɨ huápɨꞌɨ ruxeꞌeveꞌe. Mɨ́ seajta múꞌeen, caxu naꞌancuréꞌeviꞌitɨ. ’Aru tɨ puaꞌa niyen huárɨniicheꞌe huáꞌa tzajtaꞌa aꞌɨ́ɨme ɨ́ mej mejmíꞌi Tiro aꞌuchéjmeꞌecaa o huáꞌa tzajtaꞌa aꞌɨ́ɨme ɨ́ mej mejmíꞌi Sidón éꞌechejcaꞌa aꞌij nej neri huarɨ́j múꞌejmi jemi, aꞌɨ́ɨ mú hui mejmíꞌi seɨcɨé tiuꞌumuáꞌaj áꞌameꞌencheꞌe. Aꞌɨ́ɨ mú miyen ucaújchejteꞌaxɨꞌɨncheꞌe meꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n custaa tíꞌitaꞌahuaca. Aꞌɨ́ɨ mú hui majta nasij cáujhuaateꞌencheꞌe, majta miyen éeneꞌe mej aꞌujráꞌasecheꞌe mej mi ráamuaꞌaree ɨ́ seica ɨ́ teɨte mej meri seɨcɨé tiuꞌumuáꞌaj. ");
INSERT INTO crnNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","’Silu múꞌeen, jaítzeꞌe xu hui rajpuaíitzi xáꞌajuꞌun mecaí aꞌɨ́mej aꞌájna xɨcájraꞌa jetze tɨ Dios ayén tihuáꞌaxɨjteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","’Ari múꞌeen, mɨ sej Capernaúm éꞌemeꞌecan. ¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Ni qui Dios pu amuáꞌaviꞌitɨn u júteꞌe? Capu hui tzɨ́teꞌe, sino Dios pu amuajaꞌucáhuaꞌaxɨjsin téteꞌɨmua ɨ́ chaanaca jete aꞌɨ́jna jɨmeꞌe sej caí naꞌancuréꞌeviꞌitɨ. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ajtahuaꞌa pu ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ tɨ huaꞌutaꞌítecaꞌa tɨjɨ́n: ―Aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén áꞌamuanamua, aꞌɨ́ɨ pu hui ajta nenamua ineetzi. Ajta aꞌɨ́jna ɨ́ jaꞌatɨ tɨ amuaataꞌíti, aꞌɨ́ɨ pu ajta netaꞌíti ineetzi, ajta, aꞌɨ́ɨ pu hui raataꞌíti aꞌɨ́jna tɨ tinaataꞌaíj ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Matɨ́ꞌɨj mi aꞌucɨ́jxɨ aꞌɨ́ɨme ɨ́ mé huaícate japuan tamuáamuataꞌa aráꞌase. Matɨ́ꞌɨj uvéꞌeneajxɨ, jeíhua mú rútemuaꞌaveꞌecaꞌa. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Tavastaraꞌa, majta aꞌɨ́ɨme ɨ́ tiyaaruꞌu, aꞌɨ́ɨ mú majta teꞌaráꞌastijre tetɨ́ꞌɨj iteen tíhuaꞌutaꞌaíj aniúucajtzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Nee nu raaseíj neꞌɨ́jna ɨ́ Satanás tɨ́ꞌɨj aꞌɨ́ɨn u eꞌicájve u júteꞌe. Ayee pu hui tejeꞌicájve cumu mej témaxcavaꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","’Neajta inee, nuꞌuri tejámuaꞌíjca neꞌɨ́jna jɨmeꞌe sej huaꞌavéꞌetziinaxɨꞌɨn seꞌɨ́mej ɨ́ cuꞌucuꞌuse, ajta seꞌɨ́mej ɨ́ teaxcáte sej si tiuꞌutémuaꞌitɨn. Neajta nu hui tejámuaꞌíjca sej si tiuꞌutémuaꞌitɨn nain jɨmeꞌe ɨ́ huáꞌamuarɨꞌeriꞌiraꞌa aꞌɨ́mej ɨ́ mej amuájchaꞌɨɨreꞌe. Capu tiꞌitɨ́j aꞌij áꞌamuaruuren. ");
INSERT INTO crnNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","’Mɨ seajta múꞌeen, caxu hui seꞌɨ́jna jɨ́n huataújtemuaꞌaveꞌen ɨ́ mej amuaꞌaráꞌastijreꞌesin ɨ́ tiyáaruꞌuse sino ayée xu seꞌɨ́jna jɨ́n titeetáujtemuaꞌaveꞌen, jee xaa neꞌu, tɨ ari áꞌayuꞌusiꞌi ɨ́ ta japua aꞌij sej hui anteꞌaruá sej si seꞌuun auteáturan tɨ́j naꞌa rusén jɨmeꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Aꞌájnáꞌɨmua, jeíhua pu huataújtemuaꞌave aꞌɨ́jna ɨ́ Jesús aꞌíjna jɨmeꞌe tɨ huateájturaa jemin ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. Ayee pu tiuꞌutéjniuu tɨjɨ́n: ―Jeíhua nu rɨ́ꞌɨ timuaatáꞌasin, mɨ pej niyáꞌupua, mɨ pej tíꞌaijta u ta japua, pajta íiyen chaanaca japua. Ayee nu hui ꞌeen jɨ́n rɨ́ꞌɨ timuaatáꞌasin aꞌiné múꞌee pe raatéꞌavaata aꞌíjna ɨ́ niuucari mej mi caí yaúꞌitɨée muáꞌaraa aꞌɨ́ɨme ɨ́ mej jeíhua raayɨ́ꞌɨtɨ, majta aꞌɨ́ɨme ɨ́ mej jeíhua tiúꞌujmuaꞌate. Pajta múꞌee tíhuaꞌutaseíjrateꞌe aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. Jee xaa neꞌu, mɨ pej niyáꞌupua, ayée pu hui muaꞌaránajchecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Nain pu jɨ́n tinaaꞌíjca ɨ́ niyáꞌupua. Capu jaꞌatɨ ramuaꞌaree jaꞌatɨ nej yaujraꞌan púꞌeen. Aꞌɨ́ɨ puꞌu ramuaꞌaree ɨ́ niyáꞌupua. Capu jaꞌatɨ ajta ramuaꞌaree jaꞌatɨ tɨ púꞌeen ɨ́ niyáꞌupua. Nee nuꞌu hui ramuaꞌaree i nej yaujraꞌan púꞌeen. Majta aꞌɨ́ɨme ramuaꞌaréeren ɨ́ nej huaꞌutaseíjrateꞌesin nexɨ́ꞌeviꞌiraꞌa jɨmeꞌe. ―Ayee pu tiuꞌutéjniuu. ");
INSERT INTO crnNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tɨꞌɨj jí huaꞌantaseíirajraa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Rujɨ́meꞌe pu huaꞌutáꞌixa tɨjɨ́n: ―Jéꞌecan pu hui rɨ́ꞌɨ tejamuaatáꞌa aꞌɨ́jna jɨmeꞌe ɨ́ sej seri tíꞌiseij. ");
INSERT INTO crnNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan, majta aꞌɨ́ɨme ɨ́ mej títetatéꞌecaꞌa rey jɨmeꞌe, muꞌiitɨ́ mú raxɨ́ꞌeveꞌecaꞌa mej raaseíj aꞌij sej tíꞌiseij múꞌeen. Majta jeíhua mú raxɨ́ꞌeveꞌecaꞌa mej ráanamua aꞌij sej seri tíꞌinamua. Aru capu hui ayén tihuaꞌucɨ́ꞌɨ. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jaꞌanáj pu ayén huarɨ́j. Seɨ́j pu ájchee, tɨ tíꞌimuaꞌata ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa. Ayee pu tíꞌiteseꞌecaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén tiráacuanamuan tɨ ij aꞌɨ́ɨn Jesús tiꞌitɨ́j jɨ́n autéꞌɨtzen. Ayen tɨjɨ́n: ―Maeestru, ¿tiꞌitáni ruxeꞌeveꞌe nej niyen huárɨni tɨ ij náacɨꞌɨti ineetzi nej ruuri náꞌaraꞌani rusén jɨmeꞌe aꞌujna aꞌu tɨ Dios éꞌeseijreꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Aꞌiné téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze? ¿Tiꞌitáani paꞌujíjveꞌe peꞌɨ́jna jetze ɨ́ yuꞌuxari? ");
INSERT INTO crnNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj nuꞌu piyen rɨ́ꞌɨ tirájchaꞌɨɨ aꞌɨ́jna ɨ́ tavástaraꞌa ɨ́ taDioj nain jɨmeꞌe ɨ́ áꞌa tzajtaꞌa, pajta nain jɨmeꞌe aꞌachú pej caj téꞌacaꞌane ɨ́ áꞌaxɨejniuꞌuca jetze, pajta nain áꞌaxeꞌeviꞌiraꞌa jɨmeꞌe, ajta áꞌamuarɨꞌeriꞌiraꞌa jɨmeꞌe. Ajtahuaꞌa pu seɨ́j seijreꞌe tɨ jɨ́n ayén yee patáꞌaj nuꞌu hui piyen cheꞌatá penaꞌa rɨ́ꞌɨ tirájchaꞌɨɨ ɨ́ axɨ́ꞌej tevi patɨ́j múꞌee aseɨ́j tiꞌitiꞌáꞌachaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús pu ayén tiraataꞌixaa tɨjɨ́n: ―Xɨ́ꞌepɨꞌɨn pej tiraataxájtacaꞌa. Tɨ́ puaꞌa piyen huárɨni, aꞌij pej hui tiraataxájtacaꞌa, peruuri pej puaꞌamé rusén jɨmeꞌe aꞌu tɨ Dios éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ajta aꞌɨ́ɨn tɨ tíꞌimuaꞌataca, aꞌɨ́ɨ pu raxɨ́ꞌeveꞌecaꞌa mej mi ráamuaꞌaree ɨ́ teɨte tɨ caí jaꞌanáj auteájturaa ɨ́ Dios jemi. Aꞌɨ́j pu jɨ́n, ayén tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Aꞌataani púꞌeen ɨ́ nexɨ́ꞌej tevi? ");
INSERT INTO crnNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Jaꞌatɨ pu nuꞌu Jerusalén eꞌerájraa. Aꞌuu pu nuꞌu hui aꞌucaméꞌeca u Jericó. Matɨ́ꞌɨj nuꞌu mi nahuaꞌari raꞌantinájchecaꞌa. Metiráꞌariꞌiriꞌi ɨ́ cɨ́ɨxureꞌaraꞌan. Majta raatéevajxɨ. Matɨ́ꞌɨj nuꞌu mi yauutéj ɨ́ juye jetze. Puꞌuri áꞌameꞌerejcaꞌa. Majta nuꞌu meꞌɨ́n nahuaꞌari aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","’Aꞌatzu aꞌateeviꞌi, tɨ́ꞌɨj nuꞌu i seɨ́j aꞌucaméꞌeca juye jetze. Puaarij pu hui púꞌeen aꞌɨ́jna. Tɨꞌɨj jí raaseíj tɨ áꞌameꞌerejcaꞌa. Aa pu nuꞌu ɨmuá aꞌatanéj ɨ́ juye. Ajta nuꞌu mú áꞌume. ");
INSERT INTO crnNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","’Ajtahuaꞌa pu nuꞌu seɨ́j aꞌájna aꞌucaméꞌeca. Aꞌɨ́ɨ pu nuꞌu aꞌɨ́ɨn púꞌeen seɨ́j tɨ Leví teecan jetze ajtémeꞌecan. Aꞌɨ́ɨ pu ajta tíꞌivaɨreꞌecaꞌa huaꞌatéyujtaꞌa. Tɨ́ꞌɨj aꞌuun aꞌucáane aꞌu tɨ auucáꞌa ɨ́ tɨ áꞌameꞌerejcaꞌa, aꞌɨ́ɨ pu ajta nuꞌu hui raaseíj. Ayee pu cheꞌatá naꞌa huarɨ́j. Aa pu nuꞌu ɨmuá aꞌatanéj. Ajta nuꞌu mú áꞌume. ");
INSERT INTO crnNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","’Ajtahuaꞌa pu nuꞌu seɨ́j aꞌucaméꞌeca. Aꞌii pu nuꞌu aꞌɨ́ɨn púꞌeen seɨ́j tɨ seɨj chuéjraꞌa japua éꞌemeꞌecan tɨ ayén téjaꞌarájtehuaa tɨjɨ́n ɨ́ Samaria. Tɨ́ꞌɨj aj aꞌucaméꞌeca, aꞌɨ́ɨ pu nuꞌu aꞌucáane aꞌu tɨ auucáꞌa aꞌɨ́jna tɨ áꞌameꞌere. Tɨ́ꞌɨj raaseíj, aꞌɨ́ɨ pu nuꞌu ráꞌancuꞌuvajxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","’Tɨ́ꞌɨj nuꞌu i jemin á eꞌiréꞌene. Aj pu i racájaꞌusi á jetzen aꞌu tɨ tejéꞌepuaijtiꞌihuacaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ aceite, ajta u viinu. Ajta nuꞌu raacáꞌijcataxɨ aꞌu tɨ tejéꞌepuaijtiꞌihuacaꞌa. Aj pu nuꞌu i raꞌaváꞌara rucɨ́i japua ɨ́ puuruꞌu. Tɨ́ꞌɨj nuꞌu i yaꞌuvíꞌitɨ, aꞌájna jáꞌahuaꞌa aꞌu mej éꞌeꞌaseca ɨ́ mej puaseaaruveꞌe. Aꞌuu pu nuꞌu yaúutuaa. Temuaꞌa pu nuꞌu hui rɨ́ꞌɨ tiraaxáꞌapuairiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","’Yee ruijmuaꞌa yee, aꞌɨ́ɨ pu nuꞌu hui ruꞌitaꞌɨ́ꞌɨpɨ huaꞌapuaca ɨ́ tumin. Ajta raataꞌɨ́ꞌɨpɨi aꞌɨ́jna tɨ antiújmuaꞌaree aꞌɨ́jna jɨmeꞌe ɨ́ chiꞌij. Ayee pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Patáꞌaj rɨ́ꞌɨ tiraaxáꞌapuai. Neajta inee, netɨ́ꞌɨj uvéꞌenen, aj nu yeehui muaatáꞌasin nain aꞌachú pej caj tiraaxɨ́jte huaatari jɨmeꞌe, ajta tiꞌitɨ́j tɨ huácuaa.” Ayee pu nuꞌu hui tiraataꞌixaa, aꞌɨ́jna ɨ́ Samaria tɨ éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ajta aꞌɨ́ɨn Jesús, ayée pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné timuáꞌamitɨejteꞌe, aꞌíime ɨ́ mej huaíca, aꞌatani éeneꞌe aꞌɨ́ɨn pɨ́rɨcɨ tɨ rɨ́ꞌɨ tíꞌitevistáa jáꞌaraa amɨ́jna jemi ɨ́ ruxɨ́ꞌej tevi ɨ́ mej tiraanáhuaꞌiriꞌi ɨ́ nahuaꞌari? ");
INSERT INTO crnNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ajta aꞌɨ́ɨn tɨ tíꞌimuaꞌataca ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa, ayée pu tiraataꞌixaa tɨjɨ́n: ―Ayej neꞌase tɨ aꞌɨ́ɨn tɨ ráꞌancuꞌuvajxɨ, aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ xɨ́ꞌepɨꞌɨn tíꞌitevij aꞌɨ́jna jemi ɨ́ ruxɨ́ꞌej tevi. Jesús pu ayén tiraataꞌixaa tɨjɨ́n: ―Aricu hui, patáꞌaj piyen huárɨni aꞌij tɨ aꞌɨ́ɨn huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ajta aꞌɨ́ɨn Jesús, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj mauj huajúꞌucaa, aꞌúu pu aꞌaráꞌa aꞌu tɨ jaꞌatɨ eꞌechéjmeꞌe. Ayee pu ántehuaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n Marta. Tɨ́ꞌɨj i aꞌɨ́ɨn raꞌancuréꞌeviꞌitɨ ɨ́ ruche. ");
INSERT INTO crnNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Seɨ́j pu tiꞌihuaaraꞌa, ɨ́iitacan. Ayee pu ántehuaa tɨjɨ́n María. Ajta aꞌɨ́ɨn María, án pu vejliꞌi aꞌujyeíjxɨ jamuan ɨ́ Jesús. Ranamuájracaꞌa aꞌij tɨ tíꞌixajtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ajta aꞌɨ́ɨn ɨ́ Marta, capu aꞌij tiráꞌateuveꞌe aꞌij tɨ huárɨni aꞌiné jeíhua pu tíꞌimuarɨꞌecaꞌa tɨ ij tihuaꞌumín. Tɨ́ꞌɨj i eꞌiréꞌene jemin ɨ́ Jesús. Ayee pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Nevástaraꞌa, ¿ni caí á jetze ruxeꞌeveꞌe tɨ neꞌihuaaraꞌa ruséɨjtacan yé naatéjtuaa nej ni neseɨ́j tíꞌimuarɨꞌe? Patáꞌaj hui raatáꞌixaateꞌen tɨ naatévaɨreꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tavástaraꞌa pu ayén tiuꞌutaniú tɨjɨ́n: ―Marta, Marta, jeíhua pej tíꞌimuaꞌatze, pajta jeíhua aꞌij téꞌamuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Seɨ́j puꞌu hui ruxeꞌeveꞌe pej piyen huárɨni. Aꞌɨ́jna ɨ́ María, aꞌɨ́ɨ pu raꞌavéꞌehuau ɨ́ tɨ jaítzeꞌe rɨ́ꞌen. Neajta inee, canu hui ráꞌaꞌariꞌira nemɨ́jna. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jaꞌanáj pu ayén tiujuꞌurɨ́j. Aa pu jáꞌahuaꞌa aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Jesús. Téniuusimeꞌe ɨ́ Dios jemi. Tɨ́ꞌɨj raatapuáꞌajtacaꞌa tɨ huatéeniu, seɨ́j mej jamuan áꞌujujhuaꞌaneꞌe, ayée pu tiraataꞌixaa tɨjɨ́n: ―Tavastaraꞌa, patáꞌaj piyen titáamuaꞌaten tej huatéjniuuni ɨ́ Dios jemi tɨ́j Juan tihuaꞌumuáꞌate aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tɨ́ꞌɨj i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setɨ́ꞌɨj huatéjniuuni, ayée xu hui tiuꞌutaxá yee: Múꞌee ɨ́ pej táꞌiyaꞌupua, Michéꞌe rɨ́ꞌɨ méꞌe tiyauꞌáꞌan ɨ́ pej jɨ́n ántehuaa. Chéꞌe ayén tejaꞌuréꞌenen aꞌájna xɨcájraꞌa pej jetzen tiuꞌutaꞌaíjta íiyen chaanaca japua. Michéꞌe miyen cheꞌatá menaꞌa tiraꞌaráꞌasten aꞌij pej tíꞌijxeꞌeveꞌe aꞌɨ́ɨme ɨ́ mej yen huachéjme íiyen chaanaca japua matɨ́j aꞌɨ́ɨme tiraꞌaráꞌaste ɨ́ mej ta japua aꞌutéꞌuu. ");
INSERT INTO crnNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Patáꞌaj titaatáꞌan ɨ́ tɨ tíꞌicuaꞌiriꞌi ɨ́ tej jɨ́n teꞌutáviicuaꞌi íjii tɨ́j naꞌa yú tɨ aucaꞌitɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Patáꞌaj titaatáꞌuuniꞌi ɨ́ tej jɨ́n auteájturaa múꞌeetzi jemi aꞌiné ayée tu cheꞌatá tiraatáꞌuuniꞌira jaꞌatɨ tɨ naꞌa tɨ auteájturaa itejmi jemi. Patáꞌaj pajta caí raatáꞌacareꞌen ɨ́ tiyaaruꞌu tɨ aꞌɨ́ɨn caꞌaníjraꞌa taatáꞌacareꞌen tej ti caí tiyen huárɨni tiꞌitɨ́j jɨmeꞌe tɨ aꞌij puaꞌa ꞌeen. Yee puꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tichéꞌe tiyen raataxáj yee seɨ́j xu múꞌeen tíꞌamigo. Ajta áꞌiyen aꞌɨ́jna ɨ́ jaꞌatɨ, tɨ́ꞌɨj ari jáꞌitaꞌa tɨ́caꞌa pɨ́tíꞌirɨcɨ, aꞌúu pu hui aꞌumé aꞌu tɨ éꞌeche ɨ́ amiiguraꞌan. Aj pu i ayén tiraatáꞌixaateꞌesin tɨjɨ́n: “neꞌamiigu, huaícaca naataniɨ́jteꞌe ɨ́ pan, aꞌiné auchén pu yeehui uvéꞌene seɨ́j ɨ́ neꞌamiigu tɨ muꞌu aꞌataméꞌecaa. Mɨ́ neajta inee, canu tiꞌitɨ́j tíchaꞌɨɨ ɨ́ nej raamíin.” ");
INSERT INTO crnNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","’Tɨ́ꞌɨqui ayén hui tiuꞌutániuusin aꞌɨ́jna tɨ huiirájca tɨjɨ́n: “Capej néꞌɨtziiteꞌe. Puꞌuri yeehui aiteánamiꞌi ɨ́ puéerta, majta meꞌɨ́n ɨ́ tɨꞌɨríi, muꞌuri huatéejeꞌe. Neajta inee, nuꞌuri huatéecaꞌa. Capu chaꞌa rɨꞌɨrí nej ájcheni nej tiꞌitɨ́j jamuaatáꞌan.” Ayee pu tiraatáꞌixaateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","’Mɨ neajta inee, ayée nu hui tejáꞌamuaꞌixaateꞌe. Capu xaa ájchesin tɨ tiꞌitɨ́j raatáꞌan aꞌɨ́jna jɨmeꞌe tɨ amiiguraꞌan púꞌeen, sino, aꞌɨ́ɨ pu ájchesin aꞌɨ́jna jɨmeꞌe tɨ i caí méꞌe ráꞌɨtziiteꞌe ɨ́ amiiguraꞌan. Aj pu i raatáꞌasin, tzɨ́teꞌe, aꞌachú tɨ caj tiꞌitɨ́j tiraatáhuaviira. ");
INSERT INTO crnNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","’Aꞌɨ́j nu hui jɨ́n niyen tejáꞌamuaꞌixaateꞌe yee setáꞌaj seuj rahuaviira ɨ́ Dios jemi aꞌiné aꞌɨ́ɨ pu xaa tejámuaatáꞌasin. Seajta, seuj rahuauca ɨ́ jemin. Aꞌɨ́ɨ xu jemi rateuni ɨ́ Dios. Seajta seuj teꞌejteátuꞌasixɨꞌɨn táꞌapueerta. Aj pu i xaa Dios teꞌantácuuna. Tɨꞌɨj jí amuaatáꞌasin ɨ́ sej rahuauhuau. ");
INSERT INTO crnNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","’Ayee xu hui huárɨni aꞌiné tɨ puaꞌa jaꞌatɨ ayén tiꞌitɨ́j tíꞌijhuaviira, aꞌɨ́ɨ pu raꞌancuréꞌasin. Tɨ́ puaꞌa jaꞌatɨ tiꞌitɨ́j huauca, aꞌɨ́ɨ pu hui rateuni. Ajta tɨ puaꞌa jaꞌatɨ ayén teꞌejteátuꞌasixɨꞌɨn táꞌapueerta, Dios pu xaa tiraꞌantácuuneꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’Casiꞌi múꞌeen, ¿ni qui seɨ́j ayén huárɨni múꞌeen, mɨ sej huayaujmuaꞌa? Tɨ́ puaꞌa ayauj ayén huaꞌité muáhuaviira, ¿ni qui cuꞌucuꞌu paraatapíjteꞌesin? Capej xaa neꞌu. Huaꞌité pepuꞌu hui raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naꞌari tɨ puaꞌa táꞌu muáhuaviira, ¿ni qui teáxca paratáchuiteꞌesin? Capej xaa neꞌu. Táꞌu pepuꞌu raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","’Ayee xu múꞌeen, mɨ sej aꞌij puaꞌa ꞌeen ɨ́ ru tzajtaꞌa, xuꞌuri ramuaꞌaree sej huaꞌutapuaíjveꞌen ɨ́ ruyaujmuaꞌa tiꞌitɨ́j tɨ rɨ́ꞌen. Ajta aꞌɨ́ɨn ɨ́ tɨ áꞌamuayaꞌupua ɨ́ ta japua tɨ éꞌeseijreꞌe, jeíhua pu hui jaítzeꞌe raayɨ́ꞌɨtɨ tɨ huaꞌutáꞌan tɨ aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan aꞌuun aꞌuteáturan aꞌɨ́mej jemi ɨ́ mej rahuauhuau. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jaꞌanáj pu ayén tiujuꞌurɨ́j. Jesús pu tiyaaruꞌu huatamuáriteꞌecaꞌa tɨ tevi tzajtaꞌa seijreꞌecaꞌa. Ajta aꞌɨ́ɨn ɨ́ tiyaaruꞌu, capu raatáꞌacareꞌe tɨ aꞌɨ́ɨn tevi tiuꞌutaxáj. Jɨ́meꞌen puꞌu Jesús raatamuári, aj pu i tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ tevi. Majta meꞌɨ́n ɨ́ teɨte, jeíhua mú naa rɨ́ꞌɨ tiraꞌutaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Majta seica miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Amɨ́jna mɨ tevi, mɨ Jesús, Beelzebú pu hui jetze araújcaꞌane tɨ ij ayén tihuaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse, aꞌiné aꞌɨ́jna ɨ́ Beelzebú, aꞌɨ́ɨ pu tihuáꞌaijteꞌe ɨ́ seica ɨ́ tiyáaruꞌuse. Beelzebú pu caꞌaníjraꞌa ratáꞌaca tɨ ij ayén amɨ́n tíhuaꞌutaꞌaíjteꞌen ɨ́ tiyáaruꞌuse. ―Ayee mú tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Majta seica, ayée mú rɨ́ꞌɨ tíꞌiraꞌihuaꞌu meꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn huaꞌutaseíjrateꞌen tiꞌitɨ́j tɨ huápɨꞌɨ ruxeꞌeveꞌe, tɨ ajta ɨ́ ta japua éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu rúꞌumuaꞌareerecaꞌa aꞌij mej tíꞌimuaꞌajca. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Matɨ́j menaꞌa ɨ́ mej seɨ́j chuéjraꞌa japua tíꞌaijta, tɨ puaꞌa jáꞌitaꞌa maꞌutácɨɨne, aj mú mi huateújneꞌusiꞌiteꞌesin. Majta hui, camu chaꞌa áꞌateeri mej tiaíita muáꞌajuꞌun. Ajta tɨ puaꞌa miyen cheꞌatá menaꞌa jáꞌitaꞌa aꞌutácɨɨne aꞌɨ́ɨme ɨ́ mej seɨcɨé menaꞌa á éꞌeche, camu majta chaꞌa áꞌateeri á mechée meꞌájna. ");
INSERT INTO crnNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","’Ajta aꞌɨ́ɨn Satanás, tɨ puaꞌa miyen jáꞌitaꞌa aꞌutácɨɨne aꞌɨ́ɨme ɨ́ tɨ tihuáꞌaijteꞌe, ¿aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn áꞌateere tɨ tihuáꞌaijteꞌe naíjmiꞌica? Capu hui aꞌatzu aꞌij tíꞌirɨꞌɨri. Ayee nu tiꞌixa neꞌɨ́jna jɨmeꞌe sej siyen tíꞌinexa yee nej nuꞌu Beelzebú jetze aráncaꞌane nej ni huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse. ");
INSERT INTO crnNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","’Nicheꞌe aꞌatzu tejámuaataꞌíhuaꞌu. Tɨ́ puaꞌa hui niyen Beelzebú jetze aráncaꞌane nej ni huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse, majta aꞌɨ́ɨme ɨ́ mej aꞌamua jamuan áꞌujujhuaꞌan, aꞌɨ́ɨ mú majta huaꞌutamuáriteꞌen ɨ́ tiyáaruꞌuse. ¿Aꞌataani jetze muaꞌaraújcaꞌane? Aꞌɨ́ɨ mú hui miijmu raataxájta yee múꞌeen xu autéꞌɨtze. ");
INSERT INTO crnNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","’Naꞌari caí, tɨ puaꞌa nee xɨéjniuꞌucareꞌaraꞌan jetze naꞌaráncaꞌane ɨ́ Dios, ayée pu huataújmuaꞌa tɨ ari hui xaa aꞌájna tejaꞌuréꞌene múꞌejmi jemi tɨ aꞌɨ́ɨn Dios nainjapua tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ tɨ rucaꞌané, tɨ jeíhua tíꞌijchaꞌɨɨ ɨ́ tɨ jɨ́n huaténeꞌuseꞌen, tɨ́ꞌɨj auj jɨ́meꞌen rájchaꞌɨɨ ɨ́ ruchiꞌi, naa pu temuaꞌa tíꞌaviitziꞌi tɨ́j naꞌa tɨ teꞌiráꞌa. Capu jaꞌatɨ tíꞌijnahuaꞌiran. ");
INSERT INTO crnNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","’Mɨ ajta, tɨ puaꞌa seɨ́j mú aꞌuvéꞌemeꞌen tɨ jaítzeꞌe rucaꞌané caí aꞌɨ́jna, tɨ puaꞌa raaténeꞌusiꞌiteꞌen, ajta raatáviicuaꞌi, ayée pu rɨni aꞌɨ́jna tɨ mú aꞌuvéꞌeméꞌe aꞌame. Nain pu hui tiráꞌariꞌira ɨ́ tɨ jɨ́n néꞌuseꞌecaꞌa. Aj pu i tihuaꞌuréꞌaꞌasin tɨ́j naꞌa tɨ tíꞌijchaꞌɨɨcaꞌa ɨ́ tɨ tihuaꞌunáhuaꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Ayee nu tejáꞌamuaꞌixaateꞌe. Jaꞌatɨ tɨ naꞌa tɨ caí nevaɨreꞌe ineetzi, aꞌɨ́ɨ pu hui néjchaꞌɨɨreꞌe ineetzi. Ajta jaꞌatɨ tɨ naꞌa tɨ caí teɨte tíseꞌɨri ineetzi jemi, aꞌɨ́ɨ pu hui huaꞌuréꞌeꞌiteca. ");
INSERT INTO crnNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ajta ayén tɨjɨ́n: ―Ayee pu rɨcɨ ɨ́ xɨéjniuꞌucari tɨ aꞌij puaꞌa ꞌeen. Tɨ́ꞌɨj aꞌuun huirájraa tzajtaꞌan seɨ́j ɨ́ tevi, aꞌɨ́ɨ pu áꞌucheꞌecaneꞌen tɨ rahuauhuau aꞌu tɨ eꞌehuaújseꞌupeꞌen, aꞌu tɨ aꞌuhuáchi. Aru capu hui rateuve. Ayee pu tíꞌimuaꞌatze tɨjɨ́n: “Nicheꞌe yeehui huaréꞌaraꞌani u niche aꞌu nej eꞌerájraa.” ");
INSERT INTO crnNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","’Tɨ́ꞌɨj uvéꞌenen, ayée pu hui ꞌeen aꞌɨ́jna ɨ́ jaꞌatɨ. Naa pu ꞌeen ɨ́ ru tzajtaꞌa. Cu xɨee mej mauchén uhuaréꞌeꞌichaꞌutacaꞌa. Nain pu rɨ́ꞌɨ huáruu. ");
INSERT INTO crnNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aj pu i aꞌɨ́ɨn xɨéjniuꞌucari huaúuviꞌitɨn ɨ́ seica ɨ́ mej aráhuaꞌapua aráꞌase. Aꞌɨ́ɨ mú majta jaítzeꞌe aꞌij puaꞌa ꞌeen caí ɨ́ seɨ́j. Matɨ́ꞌɨj mi aꞌuteárute naímiꞌi mej mi huatéꞌe muáꞌaraꞌani meꞌɨ́jna tzajtaꞌa ɨ́ tevi. Ajta áꞌiyen, ayée pu hui teꞌiráame tɨ jaítzeꞌe aꞌij puaꞌa éeneꞌe aꞌame aꞌɨ́jna ɨ́ tevi caí tɨ ajmíꞌi éeneꞌe. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tɨ́ꞌɨj Jesús auj tíꞌixajtacaꞌa, ajta seɨ́j ꞌɨ́itaꞌa aꞌujna aꞌutéveecaꞌa huáꞌa tzajtaꞌa ɨ́ teɨte. Aj pu i ayén tiuꞌutaxájtacaꞌa caꞌanín jɨmeꞌe tɨjɨ́n: ―Rɨ́ꞌɨ pu tiraatáꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa pej jetzen huanúꞌihuacaꞌa, pej pajta jetzen huátzii. ");
INSERT INTO crnNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Mɨ́ ajta aꞌɨ́ɨme, jaítzeꞌe pu hui rɨ́ꞌɨ tihuaꞌatáꞌaca aꞌɨ́mej ɨ́ mej ranamua ɨ́ niuucari tɨ jɨ́meꞌen raxa ɨ́ Dios, majta miyen raꞌaráꞌastijreꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Majta aꞌɨ́ɨme ɨ́ teɨte, maúcheꞌe mú máàj ajteáxɨɨrijmeꞌe ɨ́ Jesús jemi. Ajta aꞌɨ́ɨn, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Jeíhua mú aꞌij puaꞌa tíꞌiteteɨte ɨ́ mej íjii huáteemua. Ayee mú hui raxɨ́ꞌeveꞌe nej tihuaꞌutaseíjrateꞌen tiꞌitɨ́j tɨ huápɨꞌɨ ruxeꞌeveꞌe. Aru canu tiꞌitɨ́j huaꞌutaseíjrateꞌesin. Aꞌij nuꞌu huaꞌutáꞌixaateꞌesin tɨ jɨ́meꞌen raxa ɨ́ Jonás teecan tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","’Jaꞌiné aꞌɨ́ɨ pu hui aꞌɨ́ɨn púꞌeeneꞌe ɨ́ tɨ huápɨꞌɨ ruxeꞌeveꞌe ɨ́ mej raaseíj aꞌɨ́ɨme mej Nínive eꞌechéjmeꞌe, ayée nu cheꞌatá nenaꞌa nej aꞌɨ́ɨn púꞌeen ɨ́ tɨ huápɨꞌɨ ruxeꞌeveꞌe ɨ́ mej raseíj aꞌɨ́ɨme íjii mej huáteemua. ");
INSERT INTO crnNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","’Ayee nu tejáꞌamuaꞌixaateꞌe, aꞌájna xɨcájraꞌa jetze tɨ jetzen Dios huáꞌaxɨjteꞌen ɨ́ teɨte, aꞌɨ́jna tɨ ajmíꞌi tiꞌitéveecaꞌa reyna jɨmeꞌe aꞌujna antánɨmua huaritaꞌan ɨ́ jaj tɨ veꞌée, aꞌɨ́ɨ pu hui aꞌánna aꞌutéchaxɨjsin huáꞌa jamuan aꞌímej íjii mej huáteemua. Aꞌɨ́ɨ pu ajta huáꞌa jetze teꞌujpuáꞌariteꞌesin tiꞌitɨ́j jɨmeꞌe. Aꞌuu pu ɨmuá aꞌuvéꞌemej tɨ ij ráanamua aꞌɨ́jna ɨ́ Salomón teecan tɨ rɨ́ꞌɨ mé teúumuaꞌarejcaꞌa. Neajta inee, i nej yee huatéjvee ɨ́ teɨte tzajtaꞌa, jaítzeꞌe nu hui veꞌecán jɨ́n tiꞌitéjvee caí aꞌɨ́jna ɨ́ Salomón. Aꞌɨ́j pu jɨ́n, aꞌɨ́jna ɨ́ reyna huáꞌa jetze teꞌujpuáꞌajteꞌesin aꞌiné camu nenamua ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","’Majta aꞌɨ́ɨme ɨ́ mej Nínive eꞌechéjmeꞌe, ayée mú rɨni aꞌájna xɨcájraꞌan ɨ́ Dios tɨ jetzen huáꞌaxɨjteꞌen ɨ́ teɨte. Aꞌɨ́ɨ mú huatéhuiixɨꞌɨsin aꞌɨ́mej jamuan ɨ́ mej íjii huáteemua. Matɨ́ꞌɨj mi teꞌujpuáꞌajteꞌesin tiꞌitɨ́j jɨmeꞌe. Seɨcɨé mú hui tiuꞌumuáꞌaj matɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jonás teecan. Neajta inee, jaítzeꞌe nu hui veꞌecán jɨ́n tiꞌitéjvee caí aꞌɨ́jna ɨ́ Jonás. Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨme ɨ́ teteca Nínive mej eꞌechéjmeꞌe, aꞌɨ́ɨ mú teꞌujpuáꞌajteꞌesin tiꞌitɨ́j jɨmeꞌe ɨ́ mej íjii huáteemua aꞌiné camu seɨcɨé tiuꞌumuáꞌaj netɨ́ꞌɨj tihuaꞌutáꞌixaa inee. ");
INSERT INTO crnNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Jɨ́meꞌen hui aꞌɨ́jna ɨ́ aparaatu tiꞌitɨ ɨ́ mej ráꞌajtaira, capu jaꞌatɨ aꞌájna yeꞌutéꞌavaata. Capu ajta xaꞌari tzajtaꞌa ruꞌutéchajtza. Capu xaa neꞌu, sino án pu ɨmuá yaꞌujchájtza mej mi raaseíj ɨ́ mej meꞌuun aꞌuteáruti. ");
INSERT INTO crnNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","’Ayee pu hui tíꞌivaɨreꞌe áꞌajɨꞌɨ tɨ́j taij tɨ áꞌataa ɨ́ áꞌajetze. Aꞌɨ́j pu jɨ́n, tɨ puaꞌa rɨ́ꞌen áꞌajɨꞌɨ, ayée pu ꞌeen, cu xɨee tɨ huanéeriꞌicɨ́ nainjapua ɨ́ áꞌajetze. Naꞌari caí, tɨ puaꞌa pecaí rɨꞌéeneꞌen áꞌajɨꞌɨ jetze, ayée pu ꞌeen, cu xɨee tɨ huatɨ́caꞌa ɨ́ áꞌajetze. ");
INSERT INTO crnNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","’Setáꞌaj siyen huárɨni tɨ ij caí aúumɨꞌɨni tɨ áꞌataa ɨ́ áꞌajetze. ");
INSERT INTO crnNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tɨ́ puaꞌa naa pu áꞌataa ɨ́ áꞌajetze, ajta caí aꞌatzu áꞌamɨꞌɨca, nainjapua pu hui huanéeriꞌicɨ́ aꞌame. Ayee pu téꞌeme, cu xɨee aparaatu á jetze ráatatza. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jɨ́meꞌen puꞌu raatapuáꞌajtacaꞌa tɨ tihuaꞌutáꞌixaa, aj pu i seɨ́j pu raatáꞌinee tɨ tejáꞌucuaꞌani áa tɨ éꞌeche. Aꞌɨ́jna ɨ́ jaꞌatɨ, fariseo pu pɨ́rɨcɨ. Aꞌuu pu aꞌuteájrupi. Tɨ́ꞌɨj i á vejliꞌi aꞌuréꞌehuiꞌixɨ aꞌu tɨ meesa aꞌutéjvee. ");
INSERT INTO crnNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ajta aꞌɨ́ɨn fariseo, aꞌɨ́ɨ pu raaseíj tɨ caí Jesús amuacaí anaújmuaijte aꞌij mej tíꞌijrɨꞌɨre ɨ́ mej ráꞌastijreꞌecaꞌa meꞌɨ́jna ɨ́ Moisés teecan. Jéꞌecan pu aꞌij puaꞌa tiraꞌutaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aj pu i tavástaraꞌa ayén tiraataꞌixaa tɨjɨ́n: ―Múꞌeen mɨ sej fariseos púꞌeen. Ayee xuꞌu tíꞌitetei sej anaújmuaijteꞌaxɨꞌɨn mɨ rumuájcaꞌa jetze. Mɨ́ ajta caí aꞌatzu aꞌij amuáꞌamitɨejteꞌe sej rɨ́ꞌɨ huaújruuren mɨ ru tzajtaꞌa. Ayee xu ꞌeen, cu xɨee tɨ́j jaꞌatɨ raacájaꞌusin mé jéjreꞌe mɨ vaasu, ajta amɨ́jna mɨ xaꞌari. Ayee xuꞌu ruseijrata huáꞌa tzajtaꞌa mɨ teɨte sej rɨ́ꞌɨ tíꞌiteteɨte. Mɨ́ seajta múꞌeen, ayée xu ꞌeen mɨ ru tzajtaꞌa. Aꞌij xu puaꞌa tíꞌiteteɨte seꞌɨ́jna jɨmeꞌe sej tihuaꞌunáhuaꞌiriꞌi, seajta aꞌij puaꞌa huáꞌuruu. ");
INSERT INTO crnNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","’Mɨ sej hui caí tiꞌitɨ́j úꞌumuaꞌaree. Aꞌɨ́jna tɨ raatétaahuacaꞌa ɨ́ sej mé jéjreꞌe ratéhuaꞌiraꞌa, ¿ni caí aꞌɨ́ɨn ajta raatétaahuacaꞌa ɨ́ áꞌamuatzajtaꞌa tɨ seijreꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Setáꞌaj siyen huaꞌutáꞌan ɨ́ mej caí aꞌij tíꞌijviicuaꞌi seꞌíjna tɨ uráꞌaa ɨ́ áꞌamuatzajtaꞌa. Ayee xu aꞌɨ́jna jɨ́n huárɨni, tɨ ij temuaꞌa teꞌirájraꞌani múꞌejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen, mɨ sej fariseos púꞌeen. Ayee xu tíꞌitetei sej raatátuiireꞌen ɨ́ Dios jemi, seɨ́j tamuáamuataꞌa anxɨ́te jetze tɨ ajtémeꞌecan aꞌɨ́jna ɨ́ tuꞌupi, tiꞌitɨ́j menta, seajta seꞌɨ́jna ɨ́ tuꞌupi, tiꞌitɨ́j ɨ́ tɨ ayén huataújmuaꞌa tɨjɨ́n ruda, seajta nain tɨ́j naꞌa puaꞌamé tíꞌixuaavi ɨ́ tuꞌupi. Múꞌeen xu hui raꞌutámuaꞌaree naíjmiꞌi tɨ́j naꞌa tiꞌipuaꞌamé. ’Mɨ seajta múꞌeen, seyaꞌuhuáꞌaxɨ ɨ́ tɨ jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi, sej si siyen rɨ́ꞌɨ huáꞌuruuren ɨ́ áꞌamuaxɨꞌej teɨte aꞌij tɨ tiraavíjteꞌe, seajta sej si rɨ́ꞌɨ tirájchaꞌɨɨ ɨ́ Dios. Senaꞌatzɨ́ caí yéꞌuhuaꞌanancacheꞌe sej siyen araúrasten seꞌíjna jɨmeꞌe ɨ́ tɨ jaítzeꞌe ruxeꞌeveꞌe. Ajta, ayén tiúꞌujxeꞌeveꞌe sej tiuꞌutáꞌan seꞌɨ́jna jɨmeꞌe tɨ cɨ́j naꞌa caj tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Setáꞌaj huataújxɨeemɨsteꞌen, múꞌeen, mɨ sej fariseos púꞌeen. Jéꞌecan xu hui raxɨ́ꞌeveꞌe tɨ tiꞌitɨ́j amuáacɨꞌɨti sej aꞌujráꞌasen ɨpuari japua aꞌu mej áꞌujraarase ɨ́ áꞌamuavaujsi u teyujtaꞌa. Jéꞌecan pu amuaꞌaráanajche mej meꞌɨ́n teɨte amuaatateujteꞌen aj mej tejáꞌatua. ");
INSERT INTO crnNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Setáꞌaj huataújxɨeemɨsteꞌen aꞌiné ayée xu ꞌeen cumu aꞌu mej huaꞌavaꞌana ɨ́ mɨꞌɨchite. Majta hui aꞌɨ́ɨme ɨ́ teɨte, ɨ́ mej japuan áꞌujujhuaꞌaneꞌe, camu hui ramuaꞌaree aꞌij tɨ ꞌeen téteꞌe aꞌiné capu á éꞌe tiꞌitɨ́j ɨ́ mej jɨ́n ráamuaꞌaree mej meꞌájna huaꞌaváꞌanaxɨ. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tɨ́ꞌɨj i seɨj tɨ tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés teecan tɨ raꞌuyúꞌuxacaꞌa, ayée pu tiraataꞌixaa tɨjɨ́n: ―Maeestru, pej piyen tiꞌixa, aꞌɨ́j pej jɨ́n aꞌij puaꞌa tíꞌitajepeꞌe itejmi. ");
INSERT INTO crnNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesús pu ayén tiraataꞌixaa tɨjɨ́n: ―Seajta múꞌeen, mɨ sej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze tɨ Moisés raꞌuyúꞌuxacaꞌa, setáꞌaj huataújxɨeemɨsteꞌen. Ayee xu hui veꞌecán jɨ́n tihuauꞌíjcateꞌen ɨ́ teɨte aꞌɨ́jna jɨmeꞌe tɨ ayén huápɨꞌɨ muárɨꞌeri, tɨ caí jaꞌatɨ raayɨ́ꞌɨtɨ tɨ ayén huárɨni. Seajta áꞌiyen, múꞌeen xu tíhuaꞌutaꞌaíjteꞌen ɨ́ teɨte mej nuꞌu mi meꞌɨ́jna jɨ́n raꞌaráꞌastijreꞌen. Mɨ́ seajta múꞌeen, caxu aꞌatzu huataúraꞌasin sej si tiꞌitɨ́j jɨ́n huaꞌutévaɨreꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Setáꞌaj huataújxɨeemɨsteꞌen aꞌiné múꞌeen xu ráꞌajtaꞌahuaca ɨ́ mej tzajtaꞌan huaꞌuteátuꞌasin aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Majta aꞌɨ́ɨme aꞌamuahuáacɨxaꞌastemuaꞌacɨꞌɨ, aꞌɨ́ɨ mú hui huáꞌucuii. ");
INSERT INTO crnNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","’Aꞌɨ́j xu jɨ́n siyen múꞌeen tiuꞌutaxájta yee amuaꞌaránajchecaꞌa aꞌij mej huáꞌuruu ɨ́ aꞌamuahuáacɨxaꞌastemuaꞌacɨꞌɨ. Aꞌɨ́ɨ mú hui huáꞌucuii aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Seajta múꞌeen, xuꞌuri ramuaꞌaree temuaꞌa naa aꞌij mej huáꞌuruu. Ayee pu ajta tejámuaꞌaránajchecaꞌa. Seajta, ayée xu ráꞌajtaahuacaꞌa aꞌu mej huajeꞌeteátuꞌasin. Seajta, ayée xu cheꞌatá senaꞌa neruuren ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Aꞌɨ́j pu jɨ́n ayén Dios rumuaꞌatzíiraꞌa pu jɨ́n tiraataxájtacaꞌa tɨjɨ́n: “Nehuaꞌutaꞌítiꞌira huáꞌa jemi ɨ́ teɨte seica mej neetzi jetze meꞌecan tíꞌixaxaꞌa, neajta seica ɨ́ nej huaꞌantíhuau mej mi nevaɨreꞌe. Jeꞌicáca mú cuiꞌini aꞌɨ́ɨme ɨ́ teɨte. Aꞌɨ́ɨ mú huáꞌacuiꞌini. Majta seica, aꞌij puaꞌa mú huáꞌaruuren.” ");
INSERT INTO crnNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","’Aꞌɨ́j pu jɨ́n, ayée pu hui tiráꞌamitɨejteꞌe ɨ́ Dios jemi, aꞌɨ́ɨ mú puꞌéeneꞌe aꞌɨ́ɨme íjii mej huáteemua meꞌɨ́jna jɨmeꞌe matɨ́j menaꞌa puaꞌamé huácuii aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, naíjmiꞌi matɨ́j puaꞌamé huácuii tɨ́j naꞌa tiúꞌuseijre ɨ́ chaanaca, naíjmiꞌi tɨ́j naꞌa Abel tɨ huamɨ́ꞌɨ ajta aꞌɨ́jna ɨ́ Zacarías, aꞌɨ́jna mej raꞌupuáꞌajte jáꞌitaꞌa aꞌu tɨ aꞌutéjvee aꞌɨ́jna ɨ́ mej japuan tíꞌimuaɨꞌɨvajtaca, aꞌu tɨ teyuu áꞌijnee. Jee xaa neꞌu, ayée nu tejáꞌamuaꞌixaateꞌe, xaa neꞌu. Ayee pu hui tiráꞌamitɨejteꞌe ɨ́ Dios jemi, aꞌɨ́ɨ mú puꞌéeneꞌe nain jɨmeꞌe aꞌɨ́ɨme íjii mej huáteemua. ");
INSERT INTO crnNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Setáꞌaj huataújxɨeemɨsteꞌen mɨ sej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze Moisés teecan tɨ raꞌuyúꞌuxacaꞌa. Múꞌeen xu rujɨ́ɨmuaꞌa senaꞌa antiújmuaꞌareerecaꞌa seꞌɨ́jna jɨmeꞌe ɨ́ mej jɨ́n ráamuaꞌaree aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. Seajta múꞌeen, caxu hui huataúraꞌa tɨ Dios tejáꞌamuaꞌaijteꞌen. Seajta huáꞌijmɨi aꞌɨ́mej ɨ́ seica mej mi caí miyen huataúraꞌan tɨ Dios tihuauꞌaíjteꞌen. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Tɨ́ꞌɨj Jesús aꞌuun huirájraa, aꞌɨ́ɨme ɨ́ fariseos, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze Moisés tɨ raꞌuyúꞌuxacaꞌa, aꞌɨ́ɨ mú autéjhuii mej aꞌij puaꞌa tirájeeve caꞌanín jɨmeꞌe. Jéꞌecan mú jeíhua tiraꞌíhuaꞌuriꞌi mej mi ráateuni ɨ́ mej jɨ́n jetzen teꞌujpuáꞌajteꞌen meꞌɨ́jna jɨmeꞌe aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Majta meꞌɨ́n ɨ́ teɨte, jeíhua mú ajteáxɨɨrecaꞌa. Ayee mú aráꞌaxcaa aꞌachú huaꞌapua viꞌiraꞌa, huaíca viꞌiraꞌa, aꞌachú mej menaꞌa puaꞌamé. Aꞌɨ́j mú jɨ́n áꞌacatacaꞌa jeíhua. Ajta aꞌɨ́ɨn ɨ́ Jesús, aꞌɨ́ɨ pu amuacaí tihuáꞌatixáateꞌajraa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayen tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu hui múꞌeen aꞌɨ́jna jɨmeꞌe fariseos mej ranájchiteꞌe ɨ́ pan jetze. Ayee pu huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨjɨ́n ɨ́ tɨ huáꞌa tzajtaꞌa uraninei, ɨ́ tɨ caí jéꞌiyecan jɨ́n seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","’Ayee puꞌu, tiꞌitɨ́j tɨ naꞌa tɨ rúꞌavaa avíitziꞌi jɨmeꞌe, aꞌɨ́ɨ pu hui huataseíjreꞌesin mé jéjreꞌe mej mi raaseíj ɨ́ teɨte. Ajta tiꞌitɨ́j mej ráꞌavaatacaꞌa, aꞌɨ́ɨ pu antícuuniꞌihua mej mi ráamuaꞌaree aꞌij tɨ ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","’Aꞌɨ́jna ɨ́ pej raataxájtacaꞌa tɨ́caꞌamisteꞌe, Dios pu raataxájta tújcaꞌari tzajtaꞌa. Ajta aꞌɨ́ɨn ɨ́ pej raataxájtacaꞌa xahuaanin jɨmeꞌe u chiꞌita u téteꞌe, Dios pu hui raataxájta caꞌanín jɨmeꞌe aꞌánna ɨ́ chiꞌij japua taꞌavéꞌepaꞌatza. ");
INSERT INTO crnNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Ayee nu tejáꞌamuaꞌixaateꞌe mɨ sej neꞌamiigustemuaꞌa púꞌeen, caxu huáꞌatziɨɨneꞌe aꞌɨ́mej ɨ́ mej menaꞌa raayɨ́ꞌɨtɨ mej raajéꞌica ɨ́ sej ratéhuaꞌiraꞌa, sino camu raayɨ́ꞌɨtɨ mej raꞌupuáꞌajteꞌen ɨ́ aꞌamua tzajtaꞌa tɨ seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","’Mɨ neajta inee, ayée nu tejámuaatáꞌixaateꞌesin jaꞌatɨ sej xaa tziɨɨneꞌe. Setáꞌaj rátziɨɨneꞌe aꞌɨ́jna tɨ ayén raayɨ́ꞌɨtɨ tɨ raajéꞌica ɨ́ sej ratéhuaꞌiraꞌa, tɨ ajta raayɨ́ꞌɨtɨ tɨ yáꞌurɨeeni ɨ́ aꞌamua tzajtaꞌa tɨ seijreꞌe aꞌujna taij jetze tɨ caí jaꞌanáj áꞌamɨꞌɨni. Jee tzɨ́teꞌe, ayée nu hui tejáꞌamuaꞌixaateꞌe tɨjɨ́n: Setáꞌaj rátziɨɨneꞌe seꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Aru, caxu aꞌij titéꞌujmuajca. ¿Ni secaí siyen tiuꞌutanájchita aꞌachú cumu huaꞌapua centaavo anxɨ́vica jɨmeꞌe ɨ́ pinaꞌase ɨ́ mej cɨ́lieen? Camu jeíhua tíꞌijnajche. Mɨ́ ajta aꞌɨ́ɨn Dios, aꞌɨ́ɨ pu naíjmiꞌica autámuaꞌareeriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jee xaa neꞌu, ayée pu tiꞌayajna. Dios pu hui ari raatéꞌitɨeexɨ mɨ áꞌamuacɨpua aꞌachú tɨ puaꞌaméjme. Caxu tíꞌitziɨɨneꞌe aꞌiné múꞌeen xu jeíhua jaítzeꞌe jetzen ruxeꞌeveꞌe ɨ́ Dios mecaí ɨ́ pinaꞌase, aꞌiné aꞌɨ́ɨ pu xaa amuáꞌancuꞌuvajxɨꞌɨsin. ");
INSERT INTO crnNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Ayee nu tejáꞌamuaꞌixaateꞌe, jaꞌatɨ tɨ naꞌa tɨ ayén tiuꞌutaxájta aꞌɨ́mej jemi ɨ́ teɨte yee naꞌaráꞌastijreꞌen ineetzi, inee i nej neajta huáꞌa jetze airáane ɨ́ teɨte, ayée nu neajta raataxájta aꞌɨ́mej jemi ɨ́ mej ta japua tíꞌivaɨreꞌe ɨ́ Dios jemi yee naatévaɨ ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ajta aꞌɨ́ɨn tɨ tiꞌixa aꞌɨ́mej jemi ɨ́ teɨte yee capu nemuaꞌate, ayée nu hui cheꞌatá raataxájta aꞌɨ́mej jemi mej ta japua tíꞌivaɨreꞌe ɨ́ Dios jemi yee canu ramuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Neajta nu tíhuaꞌutáꞌuuniꞌira aꞌɨ́mej, aꞌachú mej menaꞌa puaꞌamé aꞌij puaꞌa tíꞌinexa ineetzi i nej neajta huáꞌa jetze airáane ɨ́ teɨte. Aru aꞌɨ́ɨme, aꞌachú mej menaꞌa puaꞌamé aꞌij puaꞌa tíꞌijxa aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, canu jaꞌanáj tíhuaꞌutáꞌuuniꞌira aꞌɨ́mej. ");
INSERT INTO crnNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","’Seajta múꞌeen, matɨ́ꞌɨj u amuaꞌaráviꞌitɨn aꞌɨ́mej jemi ɨ́ mej teyujtaꞌa tíꞌaijta, nusu aꞌɨ́mej jemi ɨ́ mej tiꞌitɨ́j jɨ́n antiújmuaꞌaree, ayée xu huárɨni. Caxu hui aꞌij titéꞌujmuajca aꞌij sej yeꞌí titeeteújnan naꞌari aꞌij sej yeꞌí tiuꞌutaxáj, aꞌiné aꞌájna xɨcájraꞌan jetze, aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu tejáꞌamuamuaꞌaten aꞌij sej yeꞌí tiuꞌutaxá. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ajta seɨ́j huáꞌa tzajtaꞌa aꞌutéveecaꞌa. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Maeestru, patáꞌaj piyen tiraataꞌixaateꞌen ɨ́ nejáꞌa yee tɨ jáꞌitaꞌa tinaatáꞌan aꞌɨ́jna tɨ titaacɨ́ꞌɨ aꞌɨ́jna jɨmeꞌe tɨ seɨ́j huamɨ́ꞌɨ, aꞌiné capu tinaatáꞌasin ɨ́ neetzi tɨ neꞌáa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Hoombi xaa, ¿aꞌataani tinaaꞌíjca juees jɨmeꞌe? ¿Aꞌataani naatáꞌa nej niyen tiuꞌuxɨ́ꞌepɨꞌɨntareꞌen múꞌejmi jemi? ―Ayee puꞌu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen, setáꞌaj áꞌujcuꞌuvée senaꞌa temuaꞌa naa. Chéꞌe secaí huápɨꞌɨ senaꞌa tíꞌinecuaꞌatze sej jeíhua tiuꞌuchaꞌɨ́ɨmeꞌeni, tiꞌitɨ́j tɨ naꞌa, aꞌiné tɨ puaꞌa jaꞌatɨ jeíhua tiꞌitɨ́j tíchaꞌɨɨ, capu hui tiꞌitɨ́j aꞌij tiraatévaɨreꞌesin tɨ ij caí chéꞌe tiꞌitɨ́j aꞌij ráaruuren. ");
INSERT INTO crnNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Tɨ́ꞌɨj i seɨ́j niuucari jɨ́n tihuáꞌuꞌitɨiiriꞌi tɨjɨ́n: ―Aa pu nuꞌu jáꞌahuaꞌa chíjteaani éꞌeche. Chuej pu nuꞌu tíchaꞌɨɨ tɨ japuan tiuꞌuhuáste. Temuaꞌa pu nuꞌu hui jeíhua tiúꞌucɨɨrecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","’Tɨ́ꞌɨj i ayén tiuꞌumuáꞌaj aꞌɨ́jna ɨ́ chíjteaani tɨjɨ́n: “¿Aꞌiné yeehui náarɨni? Capu chéꞌe méꞌe éꞌerɨꞌɨri aꞌu nee yeehui yáꞌaruuren ɨ́ tɨ huácɨɨrecaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tɨ́ꞌɨj nuꞌu i ayén tiuꞌumuáꞌaj tɨjɨ́n: “Ayee nu rɨni. Neraatéꞌuuna ɨ́ nechiꞌi mé tɨ huavéjme. Neajta seica nu ájtaahuaxɨꞌɨsin tɨ jaítzeꞌe vivejméꞌe áꞌaraꞌani. Netɨ́ꞌɨj ni neꞌuun ruꞌutéꞌaasin ɨ́ tɨ tiúꞌucɨɨrecaꞌa, ajta nain i nej tíꞌijchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Neajta nu yeehui niyen tiuꞌutaxájta ɨ́ ne tzajtaꞌa yee nuꞌuri neꞌuun rɨ́ꞌɨ tiúꞌuruu u chiꞌita. Jéꞌecan pu áꞌateeri tɨ rɨ́ꞌɨ tinaatévaɨreꞌesin. Nuꞌuri yeehui neséꞌupeꞌen. Nichéꞌe tíꞌicuaꞌaca, neajta yeꞌeca, neajta netémuaꞌaveꞌe.” ―Ayee pu nuꞌu tiuꞌumuáꞌaj aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","’Ajta aꞌɨ́ɨn ɨ́ Dios, ayée pu hui tiraataꞌixaa tɨjɨ́n: “Múꞌee, mɨ pej caí tiꞌitɨ́j muaꞌaree. Ijii, tɨ́caꞌa pej mɨꞌɨni. Patɨ́ꞌɨj huamɨ́ꞌɨn, ¿aꞌataani tíꞌijcɨꞌɨti aꞌɨ́jna ɨ́ pej múꞌee rɨ́ꞌɨ ráaruu pej pi aseɨ́j huatáꞌatemuaꞌaveꞌencheꞌe?” ―Ayee pu Dios tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Neajta niyen tejáꞌamuaꞌixaateꞌe. Ayee pu hui téꞌeme aꞌɨ́mej jemi matɨ́j menaꞌa puaꞌamé ɨ́ mej rujɨ́ɨmuaꞌa rajséꞌɨri tiꞌitɨ́j tɨ naꞌa mej mi jeíhua tíꞌijchaꞌɨɨ, majta, camu tiꞌitɨ́j tíchaꞌɨɨ ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tɨ́ꞌɨj i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Aꞌɨ́j nu jɨ́n niyen tejáꞌamuaꞌixaateꞌe. Caxu seꞌɨ́jna jɨ́n tíꞌimuaꞌajca yee aꞌiquí yeꞌí tetíꞌicuaꞌani nusu yee aꞌiquí yeꞌí tetíꞌiyeꞌen naꞌari yee aꞌiquí yeꞌí tetiuꞌutétachejteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","’¿Ni caí jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi sej ruuri xáꞌaraꞌani caí ɨ́ tɨ sej ráacuaꞌani? ¿Ni caí ayén cheꞌatá naꞌa jaítzeꞌe ruxeꞌeveꞌe ɨ́ Dios jemi tɨ ruuri aꞌame ɨ́ sej ratéhuaꞌiraꞌa caí tɨ naa seíireꞌe aꞌame ɨ́ sej jɨ́n tiuꞌuteújchejteꞌen? Aa niꞌijtá xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","’Casiꞌi, xaaseíj amɨ́mej cuaꞌatza ɨ́ mej júteꞌe ráꞌaraꞌa. Camu hui aꞌatzu tíꞌihuasteꞌe, camu majta tíꞌitzaꞌanaca. Camu majta huatéechiꞌi ɨ́ mej tzajtaꞌan rɨ́ꞌɨ yéꞌuruuren ɨ́ mej meri rájseɨj. Capu amɨ́n aꞌij, aúcheꞌe pu Dios tihuáꞌamicua. Mɨ́ seajta múꞌeen, jaítzeꞌe xu jemin ruxeꞌeveꞌe ɨ́ Dios mecaí aꞌɨ́ɨme ɨ́ cuaꞌatza. ");
INSERT INTO crnNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","’¿Aꞌataani raayɨ́ꞌɨtɨ tɨ áꞌateeren tɨ jaítzeꞌe ruuri aꞌame aꞌɨ́jna jɨmeꞌe ɨ́ tɨ tíꞌiramuaꞌatziiteꞌe? Capu jaꞌatɨ xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tɨ́ puaꞌa secaí raayɨ́ꞌɨtɨhuaꞌan sej si siyen huárɨni seꞌɨ́jna jɨmeꞌe ɨ́ tɨ caí muárɨꞌeri, ¿aꞌiné hui ꞌeen jɨ́n siyen tíꞌimuaꞌajca seꞌɨ́jna jɨmeꞌe ɨ́ tɨ tíꞌijturaa? ");
INSERT INTO crnNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Casiꞌi, xaaseíj amɨ́jna mɨ caiipiꞌi, aꞌij tɨ yeꞌí tíꞌivaujseꞌe. Capu tíꞌimɨjhuaca amɨ́jna mɨ caiipiꞌi, capu ajta tíꞌitzaca. Capu amɨ́n aꞌij. Dios pu hui ayén ráaruu tɨ jaítzeꞌe naa seijreꞌe caí Salomón tɨ naa seijreꞌecaꞌa tɨ́ꞌɨj auj tiꞌitéveecaꞌa rey jɨmeꞌe. Capu jaꞌanáj ayén tiuꞌuteújchejte tiꞌitɨ́j jɨmeꞌe tɨ ayén naa seijreꞌe tɨ́j mɨ caiipiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","’Casiꞌi, múꞌeen, Dios pu ayén rɨ́ꞌɨ tirájchaꞌɨɨ mɨ tuꞌupi tɨ aꞌuun éꞌevaujseꞌe aꞌu mej áꞌataseꞌehuaca. Ajta aꞌɨ́ɨn tuꞌupi, capu áꞌateeri sino yee ruijmuaꞌa yee, aꞌɨ́ɨ mú raaréꞌeveijchi, matɨ́ꞌɨj mi ratairan. Tɨ́ puaꞌa hui Dios ayén rɨ́ꞌɨ tirájchaꞌɨɨ mɨ tuꞌupi, ¿ni caí jaítzeꞌe amuaatáꞌasin ɨ́ sej jɨ́n tiuꞌuteújchejteꞌen, múꞌejmi mɨ sej caí aꞌatzu téꞌatzaahuateꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","’Caxu aꞌij tíꞌixajta yee aꞌiquí yeꞌí tetíꞌicuaꞌani nusu aꞌiquí yeꞌí tetíꞌiteyeꞌen. Ayee xuꞌu, caxu tíꞌimuajca seꞌɨ́jna jɨmeꞌe, aꞌiné naímiꞌi matɨ́j menaꞌa puaꞌamé yen mej aꞌuchéjme íiyen chaanaca japua, ayée mú meꞌɨ́jna jɨ́n rahuauhuau. Mɨ́ ajta aꞌɨ́ɨn áꞌamuayaꞌupua, ta japua tɨ éꞌeseijreꞌe, aꞌɨ́ɨ pu hui ari rúꞌumuaꞌaree tiꞌitɨ́j tɨ amuáꞌaturaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","’Setáꞌaj miꞌi rájhuauuni tɨ Dios tejáꞌamuaꞌaijteꞌen, seajta raꞌaráꞌastijreꞌen aꞌij tɨ aꞌɨ́ɨn tíꞌijxeꞌeveꞌe. Tɨ́ puaꞌa siyen huárɨni, Dios pu hui tejámuaatáꞌasin tɨ́j naꞌa tɨ tejamuáꞌaturaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Caxu tíꞌitziɨɨneꞌe múꞌeen, mɨ sej siyen mé áꞌujujhuaꞌan. Cu xɨee cáneꞌaxɨ senaꞌa ɨ́ mej rujɨ́ɨmuaꞌa menaꞌa mé áꞌujujhuaꞌan. Ayee pu tiraꞌaránajchecaꞌa ɨ́ sej rájyaꞌupua tɨ ij aꞌɨ́ɨn amuaatáꞌan sej seꞌuun aꞌuteárute aꞌu tɨ aꞌɨ́ɨn tejéꞌaijta. ");
INSERT INTO crnNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","’Setáꞌaj tiúꞌutuaani nain aꞌachú sej caj tíꞌijchaꞌɨɨ, seajta tihuaꞌuréꞌan aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. Ayee xu aꞌɨ́jna jɨ́n huárɨni, tɨ ꞌij aꞌɨ́jna téjéꞌeseɨreꞌen ɨ́ Dios jemi ɨ́ tɨ tejáꞌamuacɨꞌɨti. Ayee pu éeneꞌe aꞌame tɨ́j tiꞌitɨ́j caꞌaní tɨ caí jaꞌanáj huataújtuaasin. Aꞌuu pu eꞌetiáꞌa aꞌame múꞌejmi jemi tiꞌitɨ́j tɨ huápɨꞌɨ tíꞌijnajche. Ajta capu hui jaꞌanáj huatéxɨjsin, aꞌiné camu aꞌuun aꞌuteáruꞌipi ɨ́ nahuaꞌari. Camu majta racɨ́ꞌɨn aꞌɨ́ɨme ɨ́ tejpuási. ");
INSERT INTO crnNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","’Ayee xu éeneꞌe xáꞌajuꞌun aꞌiné aꞌɨ́j xu jetzen tíꞌimuaꞌastɨ́ xáꞌajuꞌun seꞌɨ́jna jetze tɨ jaítzeꞌe amuaꞌaráanajche, tɨ jaítzeꞌe aꞌamua jetze ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Rɨ́ꞌɨ xuꞌu titehuaújcaten sej si tiuꞌutévaɨreꞌen. Seucheꞌe xu hui atanéjneꞌeri tɨ́j jaꞌatɨ tɨ taij huitéchueecaꞌa táꞌataa. ");
INSERT INTO crnNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","’Ayee xu éeneꞌe xáꞌajuꞌun matɨ́j aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe jaꞌatɨ jemi tɨ aꞌuun áꞌume aꞌu mej tejéꞌeyeꞌeste aꞌɨ́jna jɨmeꞌe tɨ seɨ́j huaténeꞌɨche. Majta aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe, maúcheꞌe mú tíꞌijchuꞌeveꞌen aꞌatzaj tɨ puaꞌa uvéꞌenejsin aꞌɨ́jna tɨ tihuáꞌaijteꞌe mej mi caꞌanacan tiraꞌantácuuneꞌen tɨ́ꞌɨj aꞌɨ́ɨn teꞌejteátuꞌasixɨꞌɨn ɨ́ puéerta jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","’Rɨ́ꞌɨ pu tihuaꞌutévaɨreꞌesin aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe tɨ́ꞌɨj aꞌɨ́ɨn huaꞌuseíj mej rachúꞌeveꞌe aꞌatzaj tɨ puaꞌa uvéꞌene aꞌɨ́jna tɨ tihuáꞌaijteꞌe. Ayee nu hui tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, ayée pu rɨni aꞌɨ́jna tɨ tihuáꞌaijteꞌe. Aꞌɨ́ɨ pu rucaten tɨ ij huaꞌutévaɨreꞌen. Ajta tíhuaꞌutaꞌaíjteꞌesin mej aúuhuiixɨꞌɨn ɨ́ meesa jetze. Ajta tihuáꞌamin. ");
INSERT INTO crnNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","’Capu amɨ́n aꞌij aꞌatzaj tɨ puaꞌa uvéꞌenejsin aꞌɨ́jna tɨ tihuáꞌaijteꞌe, tɨ puaꞌa jáꞌitaꞌa tɨ́caꞌa uvéꞌene nusu tapuáꞌarijmeꞌeca. Rɨ́ꞌɨ pu hui tihuaꞌutévaɨreꞌesin aꞌɨ́mej ɨ́ mej ravaɨreꞌe tɨ puaꞌa mauj rachúꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huatéechiꞌi, tɨ puaꞌa aꞌɨ́ɨ ramuaꞌareere aꞌatzaj tɨ puaꞌa ánúꞌaiixa ɨ́ nahuaꞌari, capu raatáꞌasin tɨ anúꞌasti tɨ tiuꞌunáhuaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Seajta hui múꞌeen, rɨ́ꞌɨ xuꞌu sej si rɨ́ꞌɨ huaújcaten aꞌiné inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, nee nu uvéꞌenejsin aꞌatzaj sej puaꞌa caí nechuꞌeveꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tavastaraꞌa, ¿ni téjmi penaꞌa huatáꞌixaa i niuucari caꞌɨ́n naíjmiꞌica puaatáꞌixaa? ");
INSERT INTO crnNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ajta aꞌɨ́ɨn tavástaraꞌa, aꞌɨ́ɨ pu ayén tiuꞌutaniú tɨjɨ́n: ―¿Aꞌataani púꞌeen, aꞌɨ́jna tɨ tíꞌivaɨreꞌe, tɨ ajta rɨ́ꞌɨ mé teuúmuaꞌaree, tɨ ajta caí jaꞌanáj tiꞌitɨ́j jɨ́n autéꞌɨtze? Ajta aꞌɨ́ɨn tɨ tíꞌiraꞌaijteꞌe, aꞌɨ́ɨ pu hui tiraaꞌíjcateꞌen tɨ ij aꞌɨ́ɨn aꞌɨ́jna jɨ́n antiújmuaꞌareere aꞌɨ́mej ɨ́ seica ɨ́ mej majta tíꞌivaɨreꞌe. Aꞌɨ́ɨ pu tihuáꞌamin aꞌatzaj mej puaꞌa raaxɨ́ꞌepɨꞌɨntareꞌen mej tiúꞌucuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","44","’Tɨ́ puaꞌa ayén rɨjcaa tɨ́ꞌɨj uvéꞌenen aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe, rɨ́ꞌɨ pu tiraatévaɨreꞌesin aꞌɨ́jna tɨ tíꞌivaɨreꞌe aꞌiné nain pu tiraataꞌíjcateꞌesin aꞌachú tɨ́j tiꞌitɨ́j tíchaꞌɨɨ aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe. Ayee pu téꞌeme. Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","’Mɨ ajta, aꞌɨ́ɨn tɨ hui tíꞌivaɨreꞌe, tɨ puaꞌa ayén tíꞌimuaꞌajca yee jéꞌecan pu u áꞌateere aꞌɨ́jna tɨ tinaaꞌíjca, ayée pu ajta tiráꞌamitɨejteꞌe aꞌame tɨ caí íiyaꞌata uvéꞌenejsin. Tɨ́ꞌɨj i autéjcheni tɨ huaꞌutévajxɨꞌɨn aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe, ɨ́ mej teteca, ajta ɨ́ mé ꞌuuca. Ajta pu hui autéchesin tɨ tiúꞌucuaꞌani, ajta tɨ nahuáj antiyéꞌen. Tɨ́ꞌɨj i huatétahuaisin. ");
INSERT INTO crnNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","’Ajta aꞌɨ́ɨn tɨ tíꞌiraꞌaijteꞌe, aꞌɨ́ɨ pu uvéꞌenejsin jaꞌanáj tɨ puaꞌa caí rachúꞌeveꞌe. Aꞌɨ́ɨ pu xaa uvéꞌenejsin aꞌatzaj tɨ puaꞌa caí pɨ́téjmuaꞌaree. Aꞌɨ́ɨ pu hui ajta puaíjtziꞌiraꞌa raatáꞌasin, jeíhua huápɨꞌɨ. Ayee pu cheꞌatá tíꞌijcɨꞌɨti aꞌij tɨ tihuáꞌacɨꞌɨti ɨ́ seica ɨ́ mej majta autéꞌɨtzeaara ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Aꞌɨ́jna tɨ tíꞌivaɨreꞌe, tɨ ajta tirúꞌumuaꞌaree aꞌij tɨ tíꞌijxeꞌeveꞌe aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe, jeíhua pu raꞌiréꞌevejsin navij cuaartaraꞌa jɨmeꞌe tɨ puaꞌa caí rɨ́ꞌɨ huaújruuren naꞌari caí ayén huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe tɨ ajta caí rúꞌumuaꞌareerecaꞌa aꞌij tɨ tíꞌijxeꞌeveꞌecaꞌa aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe, cɨ́j puꞌu raꞌiréꞌevejsin navij cuaartaraꞌa jɨmeꞌe tɨ puaꞌa ayén huárɨni tɨ aꞌij puaꞌa ꞌeen jɨmeꞌe aꞌiné capu rúꞌumuaꞌareerecaꞌa aꞌij tɨ yeꞌí huárɨni. Capu ayén tíꞌijcɨꞌɨti aꞌij tɨ tiraavíjteꞌe. ’Ayee puꞌu xaa neꞌu, jaꞌatɨ tɨ naꞌa mej miyen tiraatáꞌa tɨ veꞌecán jɨ́n antiújmuaꞌareere áꞌaraꞌani, tɨ puaꞌa ayén veꞌecán jɨ́n tiꞌitéꞌijcatiꞌihua, ayée pu hui tiúꞌujxeꞌeveꞌe tɨ jaítzeꞌe tiuꞌutátuiireꞌen meꞌɨ́jna jemi ɨ́ mej tíraaꞌíjcate. Ajta, jaꞌatɨ tɨ naꞌa mej miyen tiraatáꞌa tɨ cɨliéeneꞌe jɨ́n antiújmuaꞌareere áꞌaraꞌani, tɨ puaꞌa ayén cɨliéeneꞌe jɨ́n tiꞌitéꞌijcatiꞌihua, ayée pu cheꞌatá naꞌa tiúꞌujxeꞌeveꞌe tɨ cɨ́j tiuꞌutátuiireꞌen meꞌɨ́jna jemi ɨ́ mej tíraaꞌíjcate. ");
INSERT INTO crnNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ayee nu ꞌeen jɨ́n mú aꞌuvéꞌemej nej ni puaíjtzi huaꞌutáꞌan neꞌɨ́mej ɨ́ mej aꞌij puaꞌa ꞌeen ɨ́ ru tzajtaꞌa matɨ́j menaꞌa puaꞌamé yen mé seijreꞌe íiyen chaanaca japua. Ajta ayée pu tinaꞌaráanajche ineetzi tɨ ari autéjcheni. ");
INSERT INTO crnNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ayee pu ajta tíꞌinecɨꞌɨti ineetzi, ɨ́ nej jɨ́n rajpuaíjtzi naꞌame. Jéihua pu hui aꞌij puaꞌa neꞌase, ajta jeíhua pu aꞌij puaꞌa neꞌastɨ́ aꞌame ajta naꞌa caí nain teꞌentipuáꞌare. ");
INSERT INTO crnNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","’¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Ni qui neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej mej mi rɨ́ꞌɨ tíꞌitechejca ɨ́ mej yen huachéjme íiyen chaanaca japua? Canu aꞌatzu. Ayee nu tejáꞌamuaꞌixaateꞌe yee canu neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej sino mej mi jáꞌitaꞌa aꞌutácɨɨne. ");
INSERT INTO crnNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ajta íjii tɨ yú aucaꞌitɨ́ aꞌame, ayée pu hui téꞌeme. Aꞌɨ́mej jɨmeꞌe ɨ́ mej anxɨ́vi ɨ́ teɨte, ɨ́ mej seɨcɨé menaꞌa che, ayée pu téꞌeme aꞌɨ́ɨ mú jáꞌitaꞌa aꞌutajúꞌun. Majta áꞌiyen ɨ́ mej huaíca, aꞌɨ́ɨ mú huáꞌajaaxɨéeviꞌira muáꞌajuꞌun aꞌɨ́mej ɨ́ mej huaꞌapua. Majta aꞌɨ́ɨme ɨ́ mej huaꞌapua, ayée mú cheꞌatá menaꞌa tihúaꞌajaaxɨejviꞌira muáꞌajuꞌun ɨ́ mej huaíca. ");
INSERT INTO crnNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","’Ayee mú jáꞌitaꞌa aꞌutajúꞌun. Aꞌɨ́ɨ pu yaꞌupuáaraꞌan rájaaxɨéeviꞌira aꞌame aꞌɨ́jna ɨ́ ruyauj, ajta aꞌɨ́ɨn yaujraꞌan ayée pu cheꞌatá naꞌa tíꞌijjaaxɨéeviꞌira aꞌame ɨ́ rutáàta. Ajta aꞌɨ́ɨn ɨ́ náànajraꞌan, ayée pu cheꞌatá naꞌa tíꞌijjaaxɨéeviꞌira aꞌame aꞌɨ́jna ɨ́ ruyauj tɨ ꞌɨ́itaꞌa. Ajta aꞌɨ́ɨn yaujraꞌan tɨ ꞌɨ́itaꞌa, ayée pu cheꞌatá naꞌa tíꞌijjaaxɨéeviꞌira aꞌame aꞌɨ́jna ɨ́ runáàna. Ajta aꞌɨ́jna ɨ́ muꞌuneáraꞌan ɨ́ tɨ ꞌɨ́itaꞌa ɨ́ tɨ ucarij, aꞌɨ́ɨ pu ajta rájaaxɨéeviꞌira aꞌame ɨ́ rumuꞌun ɨ́ tɨ ꞌɨ́itaꞌa tɨ temuaij. Ajta aꞌɨ́jna ɨ́ muꞌuneáraꞌan tɨ temuaij, aꞌɨ́ɨ pu hui ajta rájaaxɨéeviꞌira aꞌame ɨ́ rumuꞌun tɨ ucarij. ");
INSERT INTO crnNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Tɨ́ꞌɨj i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ teɨte ɨ́ mej aꞌuun ajteáxɨɨrecaꞌa tɨjɨ́n: ―Jɨ́meꞌen xuꞌu jaitɨri huaseíj tɨ aꞌijnéj, yéncɨ pújmeꞌen, setɨ́ꞌɨj si siyen tíꞌixaxaꞌa yee muꞌuri huatéviiyi. Ajta, ayée pu tíꞌirɨneca. ");
INSERT INTO crnNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Naꞌari tɨ puaꞌa huatáꞌeecare tɨ yeete pújmeꞌen eꞌitáninei, ayée xu hui tíꞌixaxaꞌa tɨjɨ́n teájxɨcaj pu aꞌame. Ajta, ayée pu tíꞌirɨneca. ");
INSERT INTO crnNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","’Múꞌeen, mɨ sej caí mé uumuámuaꞌaree, múꞌeen xu siyen raayɨ́ꞌɨtɨ aꞌij sej yeꞌí tiuꞌutaxáj aꞌij tɨ tiꞌitɨ́ rɨni ɨ́ júteꞌe nusu íiyen chaanaca japua. Mɨ́ seajta múꞌeen, caxu hui aꞌatzu raayɨ́ꞌɨtɨ aꞌij sej yeꞌí tiuꞌutaxáj aꞌɨ́jna jɨmeꞌe aꞌij tɨ tiꞌitɨ́ rɨni itejmi jemi aꞌíjna xɨcájraꞌa jetze nej yé huatéjvee inee múꞌejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Nicheꞌe seɨj tejámuaataꞌíhuaꞌu. ¿Aꞌiné ꞌeen jɨ́n secaí raaxɨ́ꞌepɨꞌɨntareꞌen rujɨ́ɨmuaꞌa aꞌij tɨ tiraavíjteꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","59","Patɨ́ꞌɨj pauj huaméꞌen juye jetze jamuan aꞌɨ́jna tɨ muájchaꞌɨɨreꞌe sej raaxɨ́ꞌepɨꞌɨntareꞌen aꞌɨ́jna jemi ɨ́ juees, patáꞌaj raatáhuavii temuaꞌa naa sej seuj juye jetze raaxɨ́ꞌepɨꞌɨntareꞌen. Naꞌari tɨ puaꞌa pecaí piyen huárɨni, aꞌɨ́ɨ pu hui muáꞌaviꞌitɨn ɨ́ jueesi jemi. Tɨꞌɨquí aꞌɨ́ɨn juees, aꞌɨ́ɨ pu tiuꞌutátuiireꞌesin múꞌeetzi aꞌɨ́jna jemi ɨ́ polisiiya. Ajta aꞌɨ́ɨn polisiiya, aꞌɨ́ɨ pu muaꞌiteánajsin. Ayee nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, camu hui íiyaꞌata muaꞌirátuaasin ajta penaꞌa caí tiuꞌunájchita nain jɨmeꞌe aꞌachú mej muajíjveꞌen. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Aꞌajnáꞌɨmua, seica mú eꞌiréꞌene ɨ́ Jesús jemi. Matɨ́ꞌɨj mi miyen tiraataꞌixaa meꞌɨ́jna jɨmeꞌe ɨ́ mej Galilea eꞌechéjmeꞌe, Pilato tɨ nuꞌu huáꞌucuii matɨ́ꞌɨj mauj cáneꞌaxɨ muaɨ́ꞌɨvejtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús pu ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Ni qui mecaí jaítzeꞌe aꞌij puaꞌa tíꞌiteteɨtestacaꞌa sej caí múꞌeen aꞌɨ́jna jɨmeꞌe mej miyen tirajpuaíjtzicaꞌa? ");
INSERT INTO crnNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","’Ayee nu tejáꞌamuaꞌixaateꞌe. Capu ayén tiꞌayajna. Mɨ́ ajta, tɨ puaꞌa secaí seɨcɨé tiúꞌumuaꞌati ɨ́ Dios jemi, múꞌeen xu hui seajta antipuáꞌari. ");
INSERT INTO crnNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","’Ari aꞌɨ́ɨme ɨ́ mej tamuáamuataꞌa japuan aráhuaica aráꞌase, ɨ́ tɨ huáꞌa japua rájve tiꞌitɨ́j tɨ ájtee tɨ aꞌuun aꞌutéveecaꞌa aꞌájna jáꞌahuaꞌa Siloé, ¿aꞌiné tejamuáꞌamitɨejteꞌe? ¿Ni qui jaítzeꞌe aꞌij puaꞌa metíꞌiteteij mecaí aꞌɨ́ɨme ɨ́ seica ɨ́ mej Jerusalén aꞌuchéjme? ");
INSERT INTO crnNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","’Ayee nu tejáꞌamuaꞌixaateꞌe tɨjɨ́n: capu hui ayén tiꞌayajna. Mɨ́ ajta, tɨ puaꞌa secaí seɨcɨé tiúꞌumuaꞌati ɨ́ Dios jemi, múꞌeen xu seajta antipuáꞌari. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tɨ́ꞌɨj i seɨ́j niuucari pu jɨ́n tihuáꞌuꞌitɨiiriꞌi tɨjɨ́n: ―Jaꞌatɨ pu nuꞌu hui huaréj taꞌíteaꞌɨcaꞌa. Aa pu nuꞌu yeꞌateáhuii aꞌu tɨ uuva aꞌuvéjme. Tɨꞌɨj jí u yaꞌutéeseij avée si ari tacaꞌa. Capu nuꞌu aꞌatzu tacaꞌacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tɨꞌɨj jí ayén tiraataꞌixaa aꞌɨ́jna tɨ aꞌuun tíꞌichaꞌɨcaꞌa tɨjɨ́n: “Puꞌuri yeehui áꞌatee aꞌachú cumu huaíca nineꞌiraꞌa ne yee raatésiseꞌij á vee si ari tacaꞌa. Aru, capu aꞌatzu tacaꞌa. Patáꞌaj raꞌijveíjche, aꞌiné amɨ́n mé tiꞌitávee, capu tiꞌitɨ́j vaɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","’Ajta aꞌɨ́ɨn tɨ tíꞌichaꞌɨcaꞌa, ayée pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Nevástaraꞌa, chéꞌe auj mé táveeca seɨ́j nineꞌiraꞌa. Nee nu yeehui raatéꞌijcheꞌesin, neajta tiꞌitɨ́j atarɨéjraꞌasin chuej jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tɨ́ puaꞌa huatácaꞌan ruꞌusí, chaꞌa ayén mé tiꞌitávee. Naꞌari tɨ puaꞌa caí huatácaꞌan, aj pej xaa yeehui pi raꞌijveíjche.” ");
INSERT INTO crnNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ayee pu jaꞌanáj tiujuꞌurɨ́j tɨ aꞌájna pɨ́tíꞌirɨjcaa jaꞌanáj xɨcájraꞌan mej jetzen ruseꞌupi. Jesús pu tihuáꞌamuaꞌatejcaꞌa u teyujtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ajta seɨ́j ꞌɨ́itaꞌa, aꞌúu pu ánuꞌuhuatéveecaꞌa. Puꞌuri teuuméꞌeca tamuáamuataꞌa japuan aráhuaica nineꞌiraꞌa tɨ tíꞌicuiꞌicaꞌa aꞌɨ́jna jɨmeꞌe tiyaaruꞌu tɨ tzajtaꞌan seijreꞌe. Aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, jéꞌecan pu áꞌajtɨpu. Capu aꞌatzu rɨꞌɨríistacaꞌa tɨ huataújsiuuraren. ");
INSERT INTO crnNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Tɨ́ꞌɨj Jesús raaseíj, aj pu i raatajé tɨ jemin á veꞌeréꞌenen. Ayee pu tiraataꞌixaa tɨjɨ́n: ―ꞌƗ́itaꞌa, nuꞌuri timuáꞌariꞌiriꞌi ɨ́ pej jɨ́n tíꞌicuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tɨ́ꞌɨj i raꞌajtamuárɨej. Jɨ́meꞌen puꞌu raꞌajtamuárɨej, aj pu i aꞌɨ́ɨn ꞌɨ́itaꞌa huataújsiuurare. Aj pu i rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ajta aꞌɨ́ɨn tɨ tíꞌaijta u teyujtaꞌa, jéꞌecan huataniúꞌucacaꞌa aꞌiné Jesús pu tiráahuaa aꞌájna xɨcájraꞌan jetze matɨ́ꞌɨj puaꞌa ruseꞌupi. Ayee pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ teɨte tɨjɨ́n: ―Ayee pu hui teꞌaráꞌase ɨ́ mej jetzen tíꞌimɨjhuaca arájsevi xɨcaj. Setáꞌaj mú aꞌuvéꞌejuꞌun setáꞌaj seꞌájna tihuaújhuaateꞌen. Caxu mú aꞌuvéꞌecɨꞌɨcaꞌan seꞌájna xɨcájraꞌa mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Mɨ́ sej caí jéꞌiyecan jɨ́n tíꞌivaɨreꞌe ɨ́ Dios jemi, jɨ́meꞌen aꞌájna xɨcájraꞌa mé jetzen ruseꞌupi, ¿ni secaí siyen tíꞌimɨjhuaca naíjmiꞌi múꞌeen? ¿Ni secaí huáꞌixɨɨxɨ ɨ́ ruyeꞌemua, tɨ puaꞌa tiꞌitɨ́j puꞌéeneꞌen puuya naꞌari puuruꞌu sej si huajaꞌuvéꞌiteꞌen aꞌájna xɨcájraꞌa mej jetzen ruseꞌupi? Niꞌijtá xaa neꞌu. Ayee xu tíꞌimɨjhuaca. ");
INSERT INTO crnNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","’Ari amɨ́jna mɨ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu hui jetzen huanéj aꞌɨ́jna ɨ́ Abraham teecan. Ajta puꞌuri tejauume aꞌachú cumu tamuáamuataꞌa japuan aráhuaica nineꞌiraꞌa tɨ Satanás raꞌatéejɨꞌɨcɨe cuíꞌiniꞌiraꞌa jɨmeꞌe. ¿Ni caí ayén tiraavíjteꞌe nej tiráahuaateꞌen nej ni ruꞌirájtuaani aꞌɨ́jna jɨmeꞌe tɨ tíꞌicuiꞌi? ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tɨ́ꞌɨj ayén tiuꞌutaxájtacaꞌa, aꞌɨ́ɨme ɨ́ mej rájchaꞌɨɨreꞌecaꞌa meꞌɨ́jna ɨ́ Jesús, jéꞌecan mú tiuꞌutatéviꞌiriꞌi ɨ́ jemin. Majta aꞌɨ́ɨme ɨ́ seica ɨ́ teɨte, jéꞌecan pu rɨ́ꞌɨ huaꞌutáꞌa nain jɨmeꞌe aꞌij tɨ tiꞌitɨ́ huarɨ́j tɨ huápɨꞌɨ ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tíꞌirɨneca íiyen chaanaca japua tɨ Dios tíꞌaijta? ¿Aꞌiné tíꞌiseijreꞌe tɨ jɨ́meꞌen Dios tíꞌaijta? ");
INSERT INTO crnNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","’Ayee pu seijreꞌe tɨ́j mustaaza tiꞌitɨ, tɨ ayén tiꞌitéjatzeꞌe tɨ́j jɨ́ɨcan. Jaꞌatɨ pu nuꞌu hui yáꞌutɨɨ aꞌɨ́jna ɨ́ jatzi. Tɨ́ꞌɨj nuꞌu i raahuáste aꞌu tɨ tejeꞌeréꞌana. Tɨꞌɨj jí huanéj aꞌɨ́jna ɨ́ jatzi. Aj pu nuꞌu i huavaújse. Tɨꞌɨj jí ayén áꞌajtɨtɨꞌɨj jáꞌaraa tɨ́j cɨyej. Majta meꞌɨ́n pinaꞌase ɨ́ mej ráꞌaraꞌa, aꞌɨ́ɨ mú nuꞌu eꞌireꞌenée, án mú nuꞌu aꞌujráꞌasecaꞌa ɨ́ piꞌistáareꞌaraꞌan jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ajtahuaꞌa seɨ́j huaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné seijreꞌe tɨ jɨ́meꞌen Dios tíꞌaijta? ");
INSERT INTO crnNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","’Ayee pu hui ꞌeen tɨ́j aꞌɨ́jna ɨ́ levadura tɨ́ꞌɨj aꞌɨ́ɨn ꞌɨ́itaꞌa ruꞌiteájtɨcɨ, ajta nuꞌu rajnájchi cuaíjtzi jetze tɨ huaíca medida aráꞌase. Jéihua pu nuꞌu rajcuaíjtzitacaꞌa. Ajta aꞌɨ́ɨn ɨ́ levadura, aꞌɨ́ɨ pu nuꞌu tzajtaꞌa huaneájxɨ nainjapua ɨ́ cuaíjtzi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tɨꞌɨj jí Jesús aꞌuun aꞌumeꞌeca ɨ́ juye jetze tɨ Jerusalén áꞌuyeꞌiri. Aꞌu tɨ naꞌa tɨ aꞌuréꞌenineicaꞌa, tɨ huachájtaꞌajme, naꞌari aꞌɨmuá mé antachéejmee, aꞌúu pu tihuáꞌamuaꞌatehuaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jaꞌatɨ pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tavastaraꞌa, ¿ni cɨ́j menaꞌa titeꞌeráꞌase ɨ́ tɨ Dios huaꞌirátuaasin? Ajta aꞌɨ́ɨn Jesús, ayée pu tiraataꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Setáꞌaj huateújcaꞌanen sej si seꞌɨ́jna jetze aꞌuteáruti táꞌapueerta tɨ cɨ́j antéeyauj. Ayee nu tejáꞌamuaꞌixaateꞌe tɨjɨ́n muꞌiitɨ́ mú miyen huataújcaꞌanejsin mej mi meꞌuun aꞌuteárute. Mɨ́ ajta caí, capu huaꞌutáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","’Tɨ́ꞌɨqui aꞌɨ́jna tɨ á éꞌeche, tɨ́ꞌɨj i ájchesin, ajta teꞌiteánajsin táꞌapueerta. Seajta múꞌeen, amée xu puaꞌacɨé huatéꞌuu xáꞌajuꞌun. Seajta teꞌejteátuꞌasixɨꞌɨsin ɨ́ puéerta jetze. Ayee xu caꞌanín jɨ́n tiraatájeeve aꞌɨ́jna tɨ huatéechiꞌi. Ayee xu tɨjɨ́n: “Tavastaraꞌa, titaꞌantácuuneꞌe.” Ajta aꞌɨ́ɨn ayée pu tejámuaatáꞌixaateꞌesin tɨjɨ́n: “Canu hui áꞌamuamuajte aꞌateén sej pɨ́rɨcɨ. Canu neajta ramuaꞌaree aꞌu sej eꞌeráacɨ.” ");
INSERT INTO crnNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","’Seajta múꞌeen, ayée xu tiuꞌutaxájta tɨjɨ́n: “Teen tu tiúꞌucuaa á jamuan, teajta á jamuan huaꞌí. Pajta múꞌee tiꞌitamuáꞌatehuaꞌa aꞌu tɨ juye aꞌuréꞌenineꞌi.” ");
INSERT INTO crnNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ajta aꞌɨ́ɨn, ayée pu tejámuaatáꞌixaateꞌesin tɨjɨ́n: “Canu hui ramuaꞌaree inee aꞌu sej éꞌemeꞌecan. Sericu múꞌeen, mɨ sej aꞌij puaꞌa tíꞌiteteɨte.” ");
INSERT INTO crnNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","29","’Ayee pu téꞌeme aꞌájna xɨcájraꞌan jetze. Múꞌeen xu huáꞌaseijran aꞌɨ́mej ɨ́ mej meꞌuun aꞌuráatéꞌa muáꞌajuꞌun aꞌujna Dios tɨ éꞌeseijreꞌe. Aꞌɨ́mej xu hui seijran seꞌɨ́mej ɨ́ mej mejmíꞌi eꞌechéjmeꞌe, seꞌɨ́jna ɨ́ Abraham, seajta seꞌɨ́jna ɨ́ Isaac, seajta seꞌɨ́jna ɨ́ Jacobo. Majta seica mú á aꞌireꞌenejsin mej mi aꞌujráꞌase aꞌutɨ́ meesa aꞌutéjvee mej mi tiúꞌucuaꞌani aꞌujna Dios tɨ éꞌeseijreꞌe. Seajta múꞌeen, áa xu puaꞌacɨé aꞌutéꞌuu xáꞌajuꞌun. Jéihua xu ruyeine xáꞌajuꞌun, seajta ancuráꞌujcɨꞌɨme yeꞌicáa xáꞌajuꞌun mɨ rutamej jɨmeꞌe seꞌɨ́jna jɨmeꞌe sej seri rajpuaíitzi xáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","’Ee xaa neꞌu, ayée pu hui tiꞌayajna. Seica ɨ́ mej nuꞌu vivejméꞌen jɨ́n títetateí íjii, aꞌɨ́ɨ mú cɨliéeneꞌe jɨ́n titetatéꞌa muáꞌajuꞌun aꞌájna xɨcájraꞌa jetze. Majta seica ɨ́ mej nuꞌu cɨliéeneꞌe jɨ́n títetateí íjii, aꞌɨ́ɨ mú vivejméꞌen jɨ́n titetatéꞌa muáꞌajuꞌun aꞌájna xɨcájraꞌa jetze. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tɨ́ꞌɨj Jesús auchén raatapuáꞌajtacaꞌa tɨ tihuáꞌaꞌixaateꞌecaꞌa ɨ́ teɨte, matɨ́ꞌɨj mi seica jemin á eꞌiréꞌene. Aꞌɨ́ɨ mú púꞌeeneꞌe ɨ́ fariseos. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj tícheni peyajna aꞌiné amɨ́ pu nuꞌu Heródes muajéꞌicatamɨꞌɨ múꞌeetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Setáꞌaj hui seꞌuun áꞌujuꞌun seꞌɨ́jna jemi ɨ́ Heródes tɨ avíitzi jɨ́n netzeɨ́jraꞌajmuaꞌa ineetzi. Setáꞌaj seajta siyen tiraataꞌixaateꞌen seꞌɨ́jna yee puꞌuri íjii nehuaꞌutamuáriteꞌesin neꞌɨ́mej ɨ́ tiyáaruꞌuse ɨ́ mej huáꞌa tzajtaꞌa seijreꞌe ɨ́ teɨte, neajta yee tihuáꞌahuaateꞌen ɨ́ teɨte íjii, neajta ruijmuaꞌa. Neajta yee, aaruijmuaꞌa nu aráneastejreꞌesin neꞌɨ́jna jɨmeꞌe ɨ́ nej jɨ́n antínmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","’Capu amɨ́n aꞌij. Ayee pu hui tiúꞌujxeꞌeveꞌe nej nauj huaméꞌen íjii, neajta ruijmuaꞌa, neajta aaruijmuaꞌa, aꞌiné capu ayén tiraavíjteꞌe tɨ huámɨꞌɨni ayajna puaꞌacɨé u Jerusalén seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’Múꞌeen mɨ sej Jerusalén éꞌeche, mɨ sej Jerusalén éꞌemeꞌecan, múꞌeen xu huáꞌacuiꞌica aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌa. Seajta huáꞌatuꞌaxaca tetej jɨmeꞌe aꞌɨ́mej tɨ Dios huajaꞌutaꞌítecaꞌa múꞌejmi jemi. Muꞌíi nu hui niyen raxɨ́ꞌeveꞌecaꞌa nej huáꞌaseɨreꞌen ɨ́ aꞌamuayaujmuaꞌa nej ni huáꞌuchaꞌɨɨn cumu ɨ́ tecuaaraꞌi tɨ huáꞌachaꞌɨɨ ɨ́ ruyaujmuaꞌa, tɨ huaꞌicánaamua ɨ́ ruꞌana jɨmeꞌe. Seajta múꞌeen, caxu siyen raꞌutéecaꞌane. ");
INSERT INTO crnNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","’Casiꞌi, xaaseíj. Nuꞌuri hui mé amuuhuáꞌaxɨ múꞌejmi mɨ sej Jerusalén éꞌeche. Ayee nu tejáꞌamuaꞌixaateꞌe. Caxu chaꞌa neseijran ajta naꞌa caí tejaꞌureꞌenén aꞌájna xɨcájraꞌan jetze sej puaꞌa siyen tiuꞌutaxájta yee chaꞌa rɨ́ꞌɨ tiraateájtuaani aꞌɨ́jna ɨ́ tɨ mé eꞌevéꞌeme niúucareꞌaraꞌan ɨ́ tavástaraꞌa. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ayee pu jaꞌanáj tiujuꞌurɨ́j tɨ aꞌájna pɨ́tíꞌirɨjcaa aꞌɨ́jna xɨcájraꞌan mej jetzen ruseꞌupi. Aꞌuu pu aꞌaráꞌa aꞌu tɨ éꞌeche ɨ́ seɨ́j ɨ́ fariseo tɨ veꞌecán jɨ́n tiꞌitéjvee, tɨ ij tiúꞌucuaꞌani jemin. Majta aꞌɨ́ɨme ɨ́ teɨte, jeíhua mú ráꞌeeveꞌecaꞌa meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ajta seɨ́j á vejliꞌi úuveecaꞌa jemin ɨ́ Jesús. Tiꞌicuiꞌi aꞌɨ́jna ɨ́ jaꞌatɨ. Nainjapua pu cajaa ɨ́ ru jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ fariseos, ajta aꞌɨ́mej ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze Moisés tɨ raꞌutéyuꞌuxacaꞌa. Ayen tɨjɨ́n: ―¿Ni caí aꞌij tíꞌirɨꞌɨri nej tiráahuaateꞌen aꞌíjna xɨcájraꞌan tej jetzen taseꞌupi nusu caí? ");
INSERT INTO crnNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Majta aꞌɨ́ɨme, camu tiꞌitɨ́j aꞌij tiuꞌutaxájtacaꞌa. Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu raꞌajtamuárɨej aꞌɨ́jna tɨ tíꞌicuiꞌi. Ajta tiráahuaa. Aj pu i raataꞌítecaꞌa tɨ áꞌuraꞌani ruxɨéehua. ");
INSERT INTO crnNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tɨ́ꞌɨj i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni caí rɨꞌɨrí tɨ jaꞌatɨ ayén huárɨni aꞌájna xɨcájraꞌan jetze mej jetzen ruseꞌupi? Tɨ́ puaꞌa puuruꞌu atéjveti aꞌu tɨ eꞌetécun, naꞌari puuya atéjveti, ¿ni pecaí hui piyen caꞌanacan rɨni pej raꞌitátuaani aꞌu tɨ eꞌetéjve? ");
INSERT INTO crnNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Majta aꞌɨ́mej jemi, capu úꞌu anúꞌuꞌaꞌahuaꞌacaꞌa huáꞌa tzajtaꞌa aꞌij tɨ tiuꞌutaxáj. ");
INSERT INTO crnNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tɨ́ꞌɨj i Jesús raaseíj aꞌij mej rɨjcaa aꞌɨ́ɨme ɨ́ tɨ huáꞌaꞌinee mej tiúꞌucuaꞌani. Aꞌɨ́ɨ mú rahuaucaꞌa vejliꞌi mej aꞌujráꞌase jemin ɨ́ tɨ tihuáꞌamicua. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","―Tɨ́ puaꞌa hui jaꞌatɨ muáꞌineen pej tiúꞌucuaꞌani huáꞌa jamuan ɨ́ mej tíꞌiyeste aꞌɨ́jna jɨmeꞌe tɨ seɨ́j huaténeꞌɨchecaꞌa, capej peꞌánna aꞌujyéꞌixaꞌan aꞌájna vejliꞌi jemin ɨ́ tɨ muaatáꞌinee pej tiúꞌucuaꞌani, sino aꞌatzu pe aꞌɨmuá aꞌutayeíjxɨꞌɨn. Naꞌari caí, tɨ puaꞌa seɨ́j uvéꞌenen tɨ jaítzeꞌe ruxeꞌeveꞌe pecaí múꞌee tɨ ajta raatáꞌinee, aj pu i aꞌɨ́ɨn muaatáꞌixaateꞌesin yee ájchesi, táꞌaj amanna aꞌujyeíjxɨꞌɨn aꞌíjna i jaꞌatɨ. Aj pej pi tiuꞌutatéviꞌiraꞌata, aꞌánna pej aꞌujyeíjxɨꞌɨn peꞌɨ́jna japua ɨ́ tɨ jaítzeꞌe caí ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","’Mɨ pajta múꞌee, ayée pepuꞌu hui huárɨni tɨ puaꞌa jaꞌatɨ muaatáꞌineen, án pej aꞌujyeíjxɨꞌɨn japuan ɨ́ tɨ jaítzeꞌe caí ruxeꞌeveꞌe tɨ i ayén aꞌɨ́ɨn tɨ muaatáꞌinee timuaatáꞌixaateꞌen tɨ́ꞌɨj uvéꞌenen aꞌu pej aꞌujyeíjxɨꞌɨn. Ayee pu timuaatáꞌixaateꞌesin tɨjɨ́n: “Neꞌamiigu, patáꞌaj ájcheni peyajna patáꞌaj aꞌujyeíjxɨꞌɨn yé vejliꞌi aꞌu tɨ jaítzeꞌe áꞌujxeꞌeveꞌe.” Ayee pej peꞌɨ́jna jɨ́n huarɨ́n, ayée pej hui rɨ́ꞌɨ tiraꞌancuréꞌasin huáꞌa jemi ɨ́ teɨte mej á jamuan aꞌujteí. ");
INSERT INTO crnNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","’Jaꞌiné jaꞌatɨ tɨ naꞌa tɨ áꞌujtzaahuateꞌe, aj pu i aꞌij puaꞌa raatáꞌixaa tɨ caí jeíhua ruxeꞌeveꞌe. Ajta aꞌɨ́ɨn tɨ caí áꞌujcaꞌane tɨ tiꞌitɨ́j jɨ́n teꞌenteárute tɨ veꞌée, aj pu i tiraatáꞌasin tɨ ayén teꞌenteárute tiꞌitɨ́j jɨmeꞌe tɨ jaítzeꞌe veꞌée. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aj pu i ayén tiraataꞌixaa aꞌɨ́jna tɨ raatáꞌinee tɨ tiúꞌucuaꞌani tɨjɨ́n: ―Ayee pej hui huárɨni patɨ́ꞌɨj huaꞌutáꞌinen mej tiúꞌucuaꞌani aꞌatzaj chumuaꞌan nusu tɨ́caꞌa. Capej huáꞌinen aꞌɨ́mej ɨ́ áꞌa amiigustemuaꞌa, caꞌɨ́n aꞌihuáamuaꞌa nusu áꞌajuutzimuaꞌa, o aꞌɨ́mej ɨ́ chíjteaani mej á éꞌeche vejliꞌi á jemi. Tɨ́ puaꞌa piyen huaꞌutáꞌinen aꞌɨ́mej, matɨ́ꞌɨj mi majta meꞌɨ́n muaatáꞌineesin múꞌeetzi. Ayee mú huarɨ́n, aꞌɨ́ɨ mú hui tíꞌimuanajchiteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","’Mɨ pajta múꞌee, patɨ́ꞌɨj huaꞌutáꞌinen mej tiúꞌucuaꞌani, aꞌɨ́mej pepuꞌu huatáꞌinen ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, pajta aꞌɨ́mej ɨ́ mej jeíhua rajpuaíjtzi cuíꞌiniꞌiraꞌa jɨmeꞌe, pajta aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa titéecɨꞌɨca, pajta aꞌɨ́ɨme ɨ́ mej aracúcuꞌunijmee. ");
INSERT INTO crnNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ayee pej huarɨ́n, rɨ́ꞌɨ mú timuaatáꞌasin, aꞌiné camu tíꞌituaave ɨ́ mej jɨ́n timuaanájchiteꞌen. Mɨ́ ajta, aꞌɨ́ɨ pu Dios hui timuaatanájchiteꞌesin aꞌájna xɨcájraꞌan jetze mé jetzen aꞌitajúꞌun huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ajta seɨ́j tɨ ajta aꞌuun huatéjca huáꞌa jamuan, tɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús, ayée pu tiraataꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ pu tiraatáꞌasin aꞌɨ́jna tɨ tiúꞌucuaꞌani aꞌájna xɨcájraꞌan jetze tɨ jetzen Dios huataseíjreꞌesin tɨ ij tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Jaꞌatɨ pu nuꞌu hui rɨ́ꞌɨ huaújruurejcaꞌa tɨ ij tihuaꞌumín. Muꞌiicáca pu nuꞌu huatáꞌinee. ");
INSERT INTO crnNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tɨ́ꞌɨj aꞌájna tejaꞌuréꞌene tɨ tihuaꞌumín, tɨꞌɨquí aꞌɨ́ɨn raataꞌítecaꞌa ɨ́ tɨ jemin tíꞌivaɨreꞌe tɨ ij huaꞌutájeeve aꞌɨ́mej ɨ́ mej huatáꞌiniihuacaꞌa. Ayen tɨjɨ́n: “Setáꞌaj yeehui aꞌuréꞌenen aꞌiné puꞌuri huaxɨ́ꞌepɨꞌɨn.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","’Majta aꞌɨ́ɨme, naímiꞌi mú nuꞌu miyen autéjhuii mej tiuꞌutaúruuniꞌi. Ajta aꞌɨ́ɨn ɨ́ tɨ amuacaí raatáꞌinee, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: “Neuchén nu chuej huánanai nej japuan tiuꞌumuárɨꞌen. Ruxeꞌeveꞌe nej yeꞌutéeseij. Ayee nu tíꞌimuahuavii múꞌeetzi pej tinaatáꞌuuniꞌi.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","’Ajta seɨ́j, ayée pu nuꞌu tiuꞌutaxájtacaꞌa tɨjɨ́n: “Neuchén nu puuyesi huánanai. Anxɨ́j paari mú aráꞌase. Nuꞌuri áꞌuraa nej ni huáꞌucalaadu. Patáꞌaj tinaatáꞌuuniꞌi pajta ineetzi.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","’Ajtahuaꞌa ɨ́ seɨj, ayée pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Neuchén nu huaténeꞌɨchecaꞌa. Aꞌɨ́j pu jɨ́n caí rɨꞌɨrí nej neꞌuun áꞌumeꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","’Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe tɨ huajaꞌutajé, tɨꞌɨquí aꞌuréꞌaraa. Ajta nuꞌu ayén tiraataꞌixaa aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe aꞌij mej tiuꞌutaxájtacaꞌa. Ajta, aꞌɨ́ɨn tɨ huatéechiꞌi, jeíhua pu nuꞌu hui huataniúꞌucacaꞌa. Tɨ́ꞌɨj i raataꞌítecaꞌa aꞌɨ́jna tɨ tíꞌivaɨreꞌe tɨjɨ́n: “Patáꞌaj yeehui caꞌanacan peꞌuun áꞌumeꞌen caaye jetze, ajta juye jetze tɨ cɨ́j antayaúj, tɨ́j naꞌa taꞌuténinei u chajtaꞌa. Patáꞌaj huaꞌeráviꞌitɨn aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, pajta aꞌɨ́mej ɨ́ mej rajpuaíjtzi cuíꞌiniꞌiraꞌa jɨmeꞌe, pajta aꞌɨ́mej ɨ́ mej aracúcuꞌunijmee, pajta aꞌɨ́mej ɨ́ mej náꞌachijmee ɨ́ ruꞌɨ́ɨca jetze.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","’Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe, ayée pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Nevástaraꞌa, nuꞌuri niyen huarɨ́j aꞌij pej tinaataꞌaíj. Aru maúcheꞌe mú úꞌuve mej seica mú aꞌuvéꞌejuꞌun.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","’Ajta aꞌɨ́ɨn tɨ huatéechiꞌi, aꞌɨ́ɨ pu núꞌu hui ayén tiraataꞌixaa aꞌɨ́jna tɨ jemin tíꞌivaɨreꞌe tɨjɨ́n: “Patáꞌaj yeehui peꞌuun áꞌumeꞌen ɨ́ juye jetze aꞌɨmuá tɨ aꞌataneáatɨmee, pajta méyee aꞌɨmuá mej huachéjme. Patáꞌaj caꞌanéeri jɨ́n huaꞌutájeeve mej mú aꞌuvéꞌejuꞌun, mej mi u huájɨste yú nechiꞌita. ");
INSERT INTO crnNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ayee nu tíꞌimuaꞌixaateꞌe. Aꞌɨ́ɨme ɨ́ nej amuacaí huaꞌutáꞌinee, aꞌɨ́ɨme, capu seɨ́j yé tíꞌicuaꞌani íiyu i nej tihuáꞌamin.” Ayee pu hui tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨ huatéechiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jéihua mú teɨte áꞌujujhuaꞌaneꞌe meꞌɨ́jna jamuan ɨ́ Jesús. Tɨꞌɨj jí aꞌɨ́ɨn huaꞌuseíirajraa aꞌɨ́mej ɨ́ teɨte. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Jaꞌatɨ tɨ naꞌa tɨ mú aꞌuvéꞌemeꞌen ineetzi jemi, ayée pu hui tiúꞌujxeꞌeveꞌe tɨ aꞌɨ́ɨn jaítzeꞌe rɨ́ꞌɨ tinájchaꞌɨɨca ineetzi caí rɨ́ꞌɨ tirájchaꞌɨɨca ɨ́ rutáàta, ajta ɨ́ runáàna nusu ɨ́ ruꞌɨ́j, ajta ɨ́ ruyaujmuaꞌa nusu ɨ́ ruꞌihuaamuaꞌa, ajta ɨ́ rucuꞌutzimuá nusu ɨ́ rujúutzimuaꞌa. Naꞌari caí, canu raatáꞌasin tɨ nee jamuan áꞌucheꞌecaneꞌen. ’Ee xaa neꞌu, canu jaꞌatɨ huatáꞌasin tɨ neetzi jamuan áꞌucheꞌecaneꞌen tɨ puaꞌa caí jaꞌatɨ áꞌujcaꞌane tɨ naꞌaráꞌastijreꞌen, tɨ aꞌɨ́ɨn jaꞌatɨ huámɨꞌɨni neetzi jetze meꞌecan, tɨ ayén teꞌehuaújcaꞌanen ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","’Ayee nu hui tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna nej caí jaꞌatɨ huatáꞌan tɨ neetzi jamuan áꞌucheꞌecaneꞌen tɨ puaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ caí ruxɨ́ꞌeviꞌiraꞌa jɨ́n naꞌaráꞌasten, tɨ puaꞌa caí ayén cheꞌatá naꞌa tirajpuaíjtzi áꞌaraꞌani netɨ́j inee tirajpuaíitzi naꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","’Tɨ́ puaꞌa seɨ́j múꞌeen ayén tiráꞌajtaahuamɨꞌɨ chiꞌij tɨ ájtee, ni caí jaꞌatɨ ayén rɨni tɨ autéjcheni tɨ ráꞌajtaahuan. Amuacaícan aꞌɨ́ɨ pu aꞌujyeíjxa tɨ́ꞌij raatéꞌitɨen aꞌachú tɨ tiꞌitɨ́j huataújxeꞌeveꞌesin tɨ ij ráamuaꞌaree tɨ puaꞌa cɨꞌɨpée ɨ́ tumin tɨ ij ráꞌajcɨꞌɨti, nusu caí. ");
INSERT INTO crnNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","’Ee xaa, ayée pu rɨni. Naꞌari caí, tɨ puaꞌa auchén autéechen, ajta huaxɨ́n ɨ́ tumin, capu chéꞌe raꞌantícɨꞌɨtzi. Majta meꞌɨ́n ɨ́ teɨte, matɨ́ꞌɨj raseijra, aꞌɨ́ɨ mú autéhuijsin mej raꞌutéxɨeehuariꞌira. ");
INSERT INTO crnNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","’Ayee mú tiuꞌutaxájta tɨjɨ́n: “Amɨ́jna mɨ teáataꞌa, aꞌɨ́ɨ pu yeehui aꞌutéjche tɨ ráꞌajtaahua mɨ chiꞌij, aru capu chaꞌa tíꞌituaaveꞌe ɨ́ tɨ jɨ́n raꞌantícɨꞌɨti.” ");
INSERT INTO crnNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","’Naꞌari seɨ́j tɨ tiꞌitéjvee rey jɨmeꞌe, tɨ puaꞌa meri áꞌujuꞌun mej huateújneꞌusiꞌiteꞌen, ¿aꞌiné rɨni aꞌɨ́jna? ¿Ni caí amuacaí aꞌujyeíjxa tɨ ij tiúꞌumuaꞌati aisí tɨ puaꞌa caí rɨꞌɨrí tɨ huaꞌutémuaꞌitɨn aꞌɨ́mej jɨmeꞌe ɨ́ mej tamuáamuataꞌa viꞌiraꞌa aráꞌase? Ajta aꞌɨ́ɨn ɨ́ seɨ́j tɨ tiꞌitéjvee rey jɨmeꞌe, ayée pu huaꞌitéviꞌitɨcɨ aꞌachú cumu seité viꞌiraꞌa ɨ́ xantaaruꞌu. Aa niꞌijtá xaa neꞌu, ayée pu hui rɨni. ");
INSERT INTO crnNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","’Ajta tɨ puaꞌa ayén tiraꞌatámitɨejteꞌen tɨ caí huatárɨꞌɨristare tɨ huaꞌutémuaꞌitɨn, ayée pu rɨni. Tɨ́ꞌɨj auj aꞌɨmuá eꞌevéꞌevee ɨ́ seɨj, aꞌɨ́ɨ pu seica huataꞌíti mej mi áꞌujuꞌun ɨ́ seɨ́j jemi ɨ́ rey mej mi raatáhuavii mej raaxɨ́ꞌepɨꞌɨntareꞌen mej mi caí runéꞌusiꞌiteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","’Ayee pu hui cheꞌatá naꞌa ꞌeen múꞌejmi jemi. Jaꞌatɨ tɨ naꞌa tɨ ayén tíꞌijxeꞌeveꞌe tɨ nee jamuan áꞌucheꞌecaneꞌen, ayée pu tiúꞌujxeꞌeveꞌe tɨ nain mé teuúhuaꞌaxɨn aꞌachú tɨ tíꞌijchaꞌɨɨ. Naꞌari caí, canu raatáꞌasin tɨ nee jamuan áꞌucheꞌecaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Seajta múꞌeen, ayée xu hui tíꞌivaɨreꞌe sej rɨ́ꞌɨ huáꞌuruuren ɨ́ seica ɨ́ teɨte ɨ́ niuucari jɨmeꞌe mej mi rɨ́ꞌɨ rɨꞌéeneꞌe muáꞌaraꞌani ɨ́ ru tzajtaꞌa. Seajta, ayée xu cheꞌatá senaꞌa tíꞌivaɨreꞌe tɨ́j unaj mej raꞌuréꞌeviváaraꞌa muáꞌayeꞌi ɨ́ teɨte ɨ́ huaꞌiraꞌa japua aꞌiné naa pu taꞌancacá ɨ́ unaj. Aru tɨ puaꞌa huateáruꞌuna, tɨꞌɨquí ráxɨꞌɨsin ɨ́ taꞌancacá, ¿aꞌiné tejamuáꞌamitɨejteꞌe? ¿Niqui ajtahuaꞌa rɨꞌɨrí tɨ ancacá áꞌaraꞌani? Capu hui xaa neꞌu aꞌatzu. ");
INSERT INTO crnNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Capu chéꞌe tiꞌitɨ́j vaɨreꞌe, ni ɨ́ chuej japua, capu ajta tíꞌivaɨreꞌe tɨ rajnájchiteꞌen ɨ́ yeꞌemuaate chuita japua. Ayee muꞌu raruꞌujca mé mú rúurɨeexɨjsin. ’Ayee puꞌu hui, jɨ́meꞌen ɨ́ jaꞌatɨ tɨ huiteájnamua, chéꞌe aꞌɨ́ɨn ráanamua temuaꞌa naa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Majta aꞌɨ́ɨme ɨ́ mej huáꞌajijveꞌecaꞌa ɨ́ teɨte mej tíꞌitɨcɨ, majta aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa titetiújchaꞌɨɨ, aꞌɨ́ɨ mú ajteáxɨɨrecaꞌa mej mi ráanamua. ");
INSERT INTO crnNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mɨ́ ajta aꞌɨ́ɨme ɨ́ fariseos, ajta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze Moisés tɨ raꞌutéyuꞌuxacaꞌa, aꞌɨ́ɨ mú miyen tíꞌixajtacaꞌa tɨjɨ́n: ―Amɨ́jna mɨ teáataꞌa, amɨ́ɨ pu hui rɨ́ꞌɨ tihuaꞌancuréꞌeviꞌitɨ ɨ́ mej aꞌij puaꞌa titetiújchaꞌɨɨ, ajta huáꞌa jamuan tíꞌicuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Aj pu i Jesús ayén seɨ́j niuucari jɨ́n tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tichéꞌe tiyen tiraataxáj. Tɨ́ puaꞌa seɨ́j múꞌeen cáneꞌaxɨ tíyeꞌemua aꞌachú cumu anxɨ́te mej aráꞌase. ¿Ni caí ayén rɨni tɨ puaꞌa seɨ́j áꞌuveti? Aa pu huaꞌutéhuiiteꞌesin ɨ́ seica ꞌɨtzitá. Ajta raaréꞌehuausin ɨ́ seɨ́j tɨ áꞌuvej ajta naꞌa caí ráateuni. ");
INSERT INTO crnNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","’Tɨ́ꞌɨj ráateuni, aj pu i huataújtemuaꞌaveꞌesin. Tɨ́ꞌɨj ji uhuateújratziira. ");
INSERT INTO crnNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tɨꞌɨj jí u aꞌumé ɨ́ ruche. Aj pu i ruꞌamiigustemuaꞌa huatájeevi. Majta meꞌɨ́n, ajteáxɨɨri, aj pu i ayén tihuaꞌutáꞌixaateꞌesin tɨjɨ́n: “Setáꞌaj huataújtemuaꞌaveꞌen. Nuꞌuri yeehui ráateu ɨ́ cáneꞌa tɨ áꞌuvej.” ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ajta ayén tɨjɨ́n: ―Ayee nu hui tejáꞌamuaꞌixaateꞌe tɨ ayén tíꞌeen aꞌuun ta japua tɨ Dios éꞌeseijreꞌe, tɨ puaꞌa jaꞌatɨ seɨcɨé tiúꞌumuaꞌati tɨ ij caí chaꞌa aꞌij puaꞌa tiꞌitiújchaꞌɨɨ, tɨ ij ajta ayén huárɨni aꞌij tɨ Dios tíꞌijxeꞌeveꞌe, aꞌɨ́ɨ mú ɨ́ mej meꞌuun éꞌeseijreꞌe jemin ɨ́ Dios, jaítzeꞌe mú rutémuaꞌaveꞌe meꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn jaꞌatɨ ayén seɨcɨé tiuꞌumuáꞌaj ɨ́ Dios jemi mecaí aꞌɨ́mej jɨmeꞌe ɨ́ seica, ɨ́ mej muꞌíi, ɨ́ mej rɨ́ꞌɨ tíꞌiteteɨte, ɨ́ tɨ caí huáꞌaturaateꞌe mej seɨcɨé tiúꞌumuaꞌati. ");
INSERT INTO crnNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Tichéꞌe tiyen tiraataxáj. Tɨ́ puaꞌa hui ꞌɨ́itaꞌa ayén tíꞌituaaveꞌe aꞌachú cumu tamuáamuataꞌa tumin. ¿Ni qui caí ayén rɨni tɨ puaꞌa seɨ́j áꞌurɨeni? Aꞌɨ́ɨ pu tiꞌitɨ́j aparaatu ájtairan. Tɨꞌɨj jí uhuaréꞌeꞌichaꞌuta u ruchiꞌitá. Rɨ́ꞌɨ pu tíꞌihuauuni ajta naꞌa caí ráateuni. ");
INSERT INTO crnNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tɨ́ꞌɨj raateún, ruꞌamiigustemuaꞌa pu huatájeevi, aꞌɨ́mej ɨ́ mej vejliꞌi antachéejmee. Majta meꞌɨ́n ajteáxɨɨri. Aj pu i ayén tihuaꞌutáꞌixaateꞌesin tɨjɨ́n: “Setáꞌaj huataújtemuaꞌaveꞌen neetzi jemi, aꞌiné nuꞌuri ráateu yeehui ɨ́ tumin nej yáꞌurɨe.” ");
INSERT INTO crnNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","’Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ayén tíꞌirɨneca u ta japua ɨ́ Dios jemi, ajta aꞌɨ́mej jemi ɨ́ mej ravaɨreꞌe. Aꞌuu mú hui rutémuaꞌaveꞌe meꞌɨ́jna jɨmeꞌe tɨ seɨ́j tɨ aꞌij puaꞌa tiꞌitiújchaꞌɨɨcaꞌa ɨ́ jéjcua ɨmuá, aj pu i aꞌutéjche tɨ seɨcɨé tiúꞌumuaꞌati ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús pu ajtahuaꞌa seɨ́j niuucari jɨ́n tihuaꞌutáꞌixaa tɨjɨ́n: ―Aa pu nuꞌu jáꞌahuaꞌa jaꞌatɨ eꞌechéjmeꞌe. Huaꞌapuaca pu nuꞌu tiyaúumuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ajta aꞌɨ́ɨn yaujraꞌan tɨ paꞌarɨꞌɨ, ayée pu nuꞌu tiraataꞌixaa ɨ́ rutáàta tɨjɨ́n: “Patáꞌaj yee tinaatáꞌan ineetzi ɨ́ tɨ tináacɨꞌɨti patɨ́ꞌɨj caí chaꞌa méꞌehuaꞌatan múꞌee.” Ajta aꞌɨ́ɨn táàtajraꞌan, aꞌɨ́ɨ pu nuꞌu jáꞌitaꞌa tihuaꞌutáꞌa nain aꞌachú tɨ tíꞌijchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","’Aꞌatzu puꞌu áꞌateeviꞌica aꞌɨ́jna tɨ paꞌarɨꞌɨ. Tɨꞌɨj jí nuꞌu tíꞌijseɨj ɨ́ tɨ tíꞌijchaꞌɨɨcaꞌa ɨ́ táàtajraꞌan. Ajta áꞌuraa aꞌɨ́jna ɨ́ yaujraꞌan. Aa pu nuꞌu aꞌɨmuá aꞌaráꞌa seɨ́j chuéjraꞌa japua. Aꞌuu pu nuꞌu caꞌanacan tiuꞌuxɨ́jte nain tɨ́j naꞌa tɨ tiraacɨ́ꞌɨ aꞌɨ́jna jɨmeꞌe tɨ aꞌij puaꞌa tiꞌitiújchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","’Tɨ́ꞌɨj nain tiuꞌuxɨ́jte, aj pu nuꞌu i jeíhua huatatújritze aꞌujna seɨ́j chuéjraꞌa japua. Aj pu i tiraꞌutéturaate tiꞌitɨ́j tɨ huácuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aj pu i áꞌuraa. Aj pu nuꞌu i seɨ́j jemi aꞌuréꞌene tɨ ij aꞌɨ́ɨn ɨ́ jaꞌatɨ raatáꞌan tɨ tiuꞌumuárɨꞌen. Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ, ayée pu nuꞌu hui tiraamuáriste tɨ aꞌuun áꞌumeꞌen aꞌu mej tuiixu aꞌuráꞌuu tɨ ij tihuaꞌumín. ");
INSERT INTO crnNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","’Jéꞌecan pu nuꞌu huataꞌíꞌicuatacaꞌa aꞌɨ́jna tɨ paꞌarɨꞌɨ. Ayee pu nuꞌu tirajpuaíjtzicaꞌa. Ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe tiúꞌucuaꞌaníicheꞌe aꞌɨ́jna ɨ́ cutzapeꞌe tiꞌitɨ́j, tuiixu mej racuaꞌaca. Mɨ́ ajta i caí, capu jaꞌatɨ raatáꞌacareꞌe tɨ tiꞌitɨ́j huácuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","’Aj pu nuꞌu i u huaújmuaꞌatzɨ. Ayee pu nuꞌu tiuꞌumuáꞌaj tɨjɨ́n: “Majta aꞌɨ́ɨme yeehui ɨ́ mej ravaɨreꞌe ɨ́ nitáàta, matɨ́j menaꞌa puaꞌamé ruxɨéehua mú tíꞌicuaꞌa. Ajta teꞌaváꞌaturaave huáꞌa jemi. Mɨ́ neajta inee, íiye nu huatéjvee neꞌicuata. Ayej neꞌase nemɨ́ꞌɨni tujri jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ayej neꞌase yeehui náꞌuraa neyajna. A nu aꞌumé ɨ́ nitáàta jemi. Ayee nu tiraatáꞌixaateꞌesin yee: Táàta, jeíhua nu auteájturaa ɨ́ Dios jemi, neajta múꞌeetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Capu chaꞌa ayén tiraavíjteꞌe pej piyen naatámuaꞌati yee niyauj. Patáꞌaj piyen náaruuren ineetzi patɨ́j huáꞌaruure ɨ́ mej áꞌa jemi tíꞌimuarɨꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","’Tɨ́ꞌɨqui áꞌuraa. Aj pu i aꞌuun eꞌiréꞌene ɨ́ rutáàta jemi. Tɨ́ꞌɨj aꞌɨmuá auuméꞌeca, aꞌɨ́ɨ pu nuꞌu hui táàtajraꞌan raaseíj. Jéꞌecan pu ráꞌancuꞌuvajxɨ. Tɨ́ꞌɨj i aꞌutɨéechejraa aꞌu tɨ eꞌevéꞌeme ɨ́ yaujraꞌan. Aj pu nuꞌu i ruꞌiréꞌechuixɨ, ajta ruꞌitépɨꞌɨtze. ");
INSERT INTO crnNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","’Ajta aꞌɨ́ɨn yaujraꞌan, ayée pu tiraataꞌixaa tɨjɨ́n: “Táàta, jeíhua nu yeehui auteájturaa ɨ́ Dios jemi, neajta múꞌeetzi jemi. Capu chéꞌe yeehui ayée tiraavíjteꞌe pej piyen tinaatájeeve yee niyauj.” ");
INSERT INTO crnNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","’Mɨ ajta aꞌɨ́ɨn táàtajraꞌan, ayée pu nuꞌu tihuaꞌutáꞌixaa ɨ́ mej jemin tíꞌimuarɨꞌe tɨjɨ́n: “Caꞌanacan mé seꞌavéꞌechui ɨ́ síicuꞌuri tɨ jaítzeꞌe naa ꞌeen sej si seꞌɨ́jna ruꞌucáchejteꞌen. Seajta ɨ́ aniira setáꞌaj ruꞌucárujtiꞌi ɨ́ xɨteáaraꞌan jetze, seajta raꞌajtácaꞌacaiteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Setáꞌaj seajta yeehui siyen huárɨni, sej seꞌɨ́jna ɨ́ viseáaruꞌu ɨ́ tej teri rajrújte, setáꞌaj u yaꞌuvéꞌejan, setáꞌaj ráameꞌeni. ’Tichéꞌe yeehui tiúꞌuyesten, teajta tiúꞌucuaꞌani taxɨéehua. ");
INSERT INTO crnNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Aꞌiné i niyauj, puꞌuri ajtahuaꞌa muꞌu eꞌejnéj. Pueere yee ari muꞌu aꞌumɨ́ꞌɨ. Ajta áꞌuvej, aru tuꞌuri teajtáhuaꞌa ráateu.” Ayee pu tihuaꞌutáꞌixaa. Aꞌɨ́j mú nuꞌu hui jɨ́n maꞌutéjhuii mej tiúꞌuyesten. ");
INSERT INTO crnNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Ajta aꞌɨ́ɨn yaujraꞌan tɨ vástaꞌa, áa pu jáꞌahuaꞌa tejéꞌemuarɨꞌecaꞌa aꞌu tɨ aꞌupáꞌatza. Tɨ́ꞌɨj ari á eꞌevéꞌemeꞌecaa á vejliꞌi aꞌu tɨ aꞌutéjvee ɨ́ chiꞌij, aꞌɨ́ɨ pu ráanamuajriꞌi mej tíꞌicuiina, majta tíꞌineꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tɨ́ꞌɨj nuꞌu i seɨ́j huatajé ɨ́ tɨ ravaɨreꞌe ɨ́ táàtajraꞌan. Aj pu nuꞌu i ayén tiraataꞌíhuaꞌuriꞌi aꞌij mej rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","’Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe, ayée pu hui tiraataꞌixaa tɨjɨ́n: “Puꞌuri yeehui uvéꞌene ɨ́ áꞌajuu. Ajta aꞌatáàta, aꞌɨ́ɨ pu ráameꞌiriꞌi ɨ́ viseáaruꞌu ɨ́ tej rajrújte aꞌɨ́jna jɨmeꞌe tɨ ajtahuaꞌa uvéꞌene jemin ɨ́ rutáàta. Capu yeehui aꞌij éeneꞌe. Rɨ́ꞌɨ pu naa teꞌuvéꞌene.” Ayee pu nuꞌu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","’Ajta aꞌɨ́ɨn tɨ vástaꞌa, tɨ́ꞌɨj ayén tiráanamuajriꞌi, tɨ́ꞌɨj nuꞌu i huataniúꞌucacaꞌa. Capu raxɨ́ꞌeveꞌecaꞌa tɨ uteárute u chiꞌita. Ajta aꞌɨ́ɨn táàtajraꞌan, aꞌɨ́ɨ pu nuꞌu huirájraa tɨ ij yaꞌutajé. Jéihua pu raatéeje tɨ uteárute u chiꞌita. ");
INSERT INTO crnNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","’Ajta aꞌɨ́ɨn tɨ vástaꞌa, ayée pu nuꞌu tiraataꞌixaa ɨ́ rutáàta tɨjɨ́n: “Casiꞌi. Tɨ́j naꞌa nej yé huaca múꞌeetzi jemi, jeíhua nu tíꞌimuarɨꞌe. Canu yeehui jaꞌanáj tiꞌitɨ́j jɨ́n auteájturaa múꞌeetzi jemi. Nain nu yeehui jɨ́n teꞌaráꞌaste aꞌij pej tinaataꞌaíj. Pajta múꞌee, capej yeehui jaꞌanáj tiꞌitɨ́j naatáꞌa ɨ́ nej jɨ́n tiúꞌuyesten huáꞌa jamuan ɨ́ neꞌamiigustemuaꞌa, ni tiꞌitɨ́j caura. ");
INSERT INTO crnNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mɨ́ pajta múꞌee, ayée pu huarɨ́j, amɨ́jna muáꞌayauj, aꞌɨ́ɨ pu ꞌuuca jamuan raaxɨ́jte nain ɨ́ pej tiraatáꞌa. Ajta tɨ́ꞌɨj uvéꞌene, múꞌee pej raajéꞌicatze ɨ́ viseáaruꞌu ɨ́ tej rajrújte.” ");
INSERT INTO crnNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Ajta aꞌɨ́ɨn táàtajraꞌan, ayée pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Niyauj, tɨ́j penaꞌa peri puaꞌan xɨcaj yé huaca ineetzi jemi. Ajta tɨ́j naꞌa tiꞌipuaꞌamé ɨ́ nej tíꞌijchaꞌɨɨ, múꞌeetzi pu tiꞌaꞌáa. ");
INSERT INTO crnNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Aru amɨ́jna muáꞌajuu, ayée pu éeneꞌe cumu tɨ mɨ́ꞌɨchicaꞌa aꞌiné capu méꞌe jáꞌahuaꞌacaꞌa. Ayee pu ꞌeen íjii cumu tɨ ajtahuaꞌa huatarún. Aꞌɨ́ɨ pu yeehui áꞌuvejcaa, aru puꞌuri ajtahuaꞌa huataseíjre. Aꞌɨ́j pu jɨ́n ayén tiúꞌujxeꞌeveꞌe tej huatátatemuaꞌaveꞌen, teajta tiúꞌuyesten.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús pu ajta ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Aa pu nuꞌu hui jáꞌahuaꞌa chíjteaani éꞌechejcaꞌa. Seɨ́j pu ravaɨreꞌecaꞌa aꞌɨ́jna jɨmeꞌe tɨ antiújmuaꞌareerecaꞌa nain aꞌachú tɨ tíꞌijchaꞌɨɨcaꞌa ɨ́ chíjteaani. Matɨ́ꞌɨj nuꞌu mi seica jetzen teꞌujpuáꞌajte aꞌɨ́jna tɨ antiújmuaꞌaree aꞌɨ́jna jɨmeꞌe tɨ caꞌanacan raaxɨ́jteꞌe chaꞌa naꞌa tɨ tíꞌiseijreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","’Tɨ́ꞌɨj i chíjteaani raatajé. Ayee pu nuꞌu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: “¿Aꞌiné naꞌa qui nej neri tiúꞌunamuajriꞌi aꞌij pej rɨcɨ múꞌee? Patáꞌaj yeehui raꞌuyúꞌuxan nain aꞌachú pej jɨ́n antíꞌamuaꞌaréere nej ni ráamuaꞌaree aꞌachú tɨ caj teꞌaráꞌase, ɨ́ pej caí yeehui chéꞌe piyen antíꞌamuaꞌaréere puaꞌamé.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","’Ajta aꞌɨ́ɨn tɨ ravaɨreꞌecaꞌa, ayée pu tiuꞌumuáꞌaj tɨjɨ́n: “¿Aꞌiquí nerɨni? Aꞌɨ́jna tɨ tíꞌineꞌaijteꞌe, aꞌɨ́ɨ pu nuꞌu tináꞌariꞌira ɨ́ nej jɨ́n antínmuaꞌaree. Mɨ́ neajta inee, canu necaꞌane nej teꞌatéꞌijcheꞌen. Ajta netíꞌiteviꞌiraꞌa nej yeehui vaɨ́riꞌira huatáhuauni. ");
INSERT INTO crnNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nuꞌuri yeehui ramuaꞌaree aꞌij nej rɨni, mej mi teɨte naꞌancuréꞌeviꞌitɨn temuaꞌa naa aꞌujna huáꞌache netɨ́ꞌɨj caí chaꞌa tíꞌimuarɨꞌe neyajna.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","’Tɨ́ꞌɨj nuꞌu i huaꞌutajé seɨj ajta seɨj ɨ́ mej tiráꞌachaꞌɨɨreꞌecaꞌa aꞌɨ́jna ɨ́ chíjteaani. Ayee pu nuꞌu tiraataꞌíhuaꞌuriꞌi ɨ́ seɨj tɨ amuacaí veꞌeréꞌene tɨjɨ́n: “¿Aꞌachúni yeehui petiráꞌachaꞌɨɨreꞌe ɨ́ tɨ tíꞌineꞌaijteꞌe?” ");
INSERT INTO crnNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","’Aj pu i ayén tiuꞌutaniú aꞌɨ́jna ɨ́ jaꞌatɨ tɨjɨ́n: “Anxɨ́te puaꞌaméca ɨ́ taampu aꞌɨ́jna ɨ́ aceite tɨ aceituuna jetze meꞌecan.” ’Ajta aꞌɨ́ɨn tɨ antiújmuaꞌaree, ayée pu nuꞌu hui tiraataꞌixaa tɨjɨ́n: “Yeꞌecui i cuapée tɨ jetzen téꞌeyuꞌusiꞌi aꞌachú pej caj tiráꞌachaꞌɨɨreꞌe. Aꞌujyeíjxɨ múꞌee, caꞌanacan. Patáꞌaj seɨ́j auyúꞌuxa tɨ jetzen áꞌayuꞌusiꞌi aꞌachú cumu anxɨ́j tamuáamuataꞌa taampu tɨ aráꞌase.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","’Tɨ́ꞌɨj nuꞌu i ajta seɨ́j ayén tiuꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: “Carij múꞌee, ¿aꞌachúni yeehui petiráꞌachaꞌɨɨreꞌe?” ’Ajta aꞌɨ́ɨn, ayée pu hui tiraataꞌixaa tɨjɨ́n: “Anxɨ́te puaꞌaméca medida ɨ́ triigu.” ’Ayee pu tiraataꞌixaa tɨjɨ́n: “Yeꞌecui, i cuapée. Patáꞌaj seɨ́j auyúꞌuxa tɨ jetzen áꞌayuꞌusiꞌi tɨjɨ́n: muáacuate pej nuꞌu ráꞌachaꞌɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","’Ajta nuꞌu aꞌɨ́ɨn tɨ tíꞌiraꞌaijteꞌe, aꞌɨ́ɨ pu hui rɨ́ꞌɨ tiraatáꞌa aꞌiné rɨ́ꞌɨ pu tiuꞌumuáꞌaj aꞌɨ́jna jɨmeꞌe aꞌij tɨ yeꞌí huárɨni. Majta aꞌɨ́ɨme ɨ́ mej aꞌuchéjme seɨ́j chuéjraꞌa japua íiyen chaanaca japua, jaítzeꞌe mú raayɨ́ꞌɨtɨ aꞌij mej yeꞌí huárɨni ɨ́ seica ɨ́ ruxɨ́ꞌej teɨte mecaí aꞌɨ́ɨme ɨ́ mej meꞌɨ́jna jetze ajtémeꞌecan ɨ́ tɨ huaꞌatátzaviꞌijteꞌe ɨ́ tavástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Ayee nu tejáꞌamuaꞌixaateꞌe. Caxu chéꞌe senaꞌa raaxɨ́jteꞌe ɨ́ tumin íiyen tɨ meꞌecan chaanaca japua. Chéꞌe ayén tejámuaatévaɨreꞌen méjcaꞌi huáyee sej si ruꞌamiigustemuaꞌa jɨ́n antimuáꞌitɨn mej mi meꞌɨ́n amuaꞌancuréꞌeviꞌitɨn temuaꞌa naa aꞌájna xɨcájraꞌan jetze tɨ́ꞌɨj caí chaꞌa méꞌe áꞌa túmintan. Aꞌuu mú hui amuaꞌancuréꞌeviꞌitɨn aꞌu tɨ caí jaꞌanáj éꞌevatzɨjsin ɨ́ huáꞌachiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Aꞌɨ́jna tɨ xɨ́ꞌepɨꞌɨn rɨcɨ aꞌɨ́jna jɨmeꞌe tɨ cɨliéeneꞌe jɨ́n tiꞌitéjvee, aꞌɨ́ɨ pu ajta xɨ́ꞌepɨꞌɨn rɨni tɨ puaꞌa tiꞌitevée áꞌaraꞌani veꞌecán jɨmeꞌe. Ajta aꞌɨ́ɨn tɨ hui caí xɨ́ꞌepɨꞌɨn rɨcɨ aꞌɨ́jna jɨmeꞌe tɨ cɨliéeneꞌe jɨ́n tiꞌitéjvee, aꞌɨ́ɨn capu ajta xɨ́ꞌepɨꞌɨn rɨni tɨ puaꞌa tiꞌitevée áꞌaraꞌani veꞌecán jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","’Aꞌɨ́j pu jɨ́n, tɨ puaꞌa secaí téꞌaste ɨ́ sej jɨ́n antiújmuaꞌaree sej rajmuárɨꞌe ɨ́ tumin tɨ yen seijreꞌe íiyen chaanaca japua, ¿ni qui siyen tíꞌimuaꞌatze tɨ jaꞌatɨ ayén tejamuaꞌíjcateꞌesin sej raamuárɨꞌen tɨ huápɨꞌɨ tíꞌijnajche tɨ́j naꞌa rusén jɨmeꞌe? Capu xaa neꞌu ayén téꞌeme. ");
INSERT INTO crnNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","’Tɨ́ puaꞌa secaí téꞌaste sej rajmuárɨꞌen seꞌɨ́jna jɨmeꞌe tɨ Dios amuaatapuaíjve, capu jaꞌanáj amuaatáꞌasin tɨ múꞌejmi áaꞌamuaꞌáa puꞌéeneꞌe áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Capu hui rɨꞌɨrí tɨ jaꞌatɨ huaꞌapuaca huávaɨreꞌen aꞌɨ́mej jemi ɨ́ mej tíꞌaijta. Tɨ́ puaꞌa ayén huárɨni, ayée pu téꞌeme. Jéihua pu rájchaꞌɨɨreꞌe aꞌame ɨ́ seɨ́j, ajta jeíhua pu rɨ́ꞌɨ tirájchaꞌɨ́ɨ aꞌame ɨ́ seɨ́j. Naꞌari, aꞌɨ́ɨ pu rɨ́ꞌɨ tiráꞌatzaahuateꞌe aꞌame ɨ́ seɨ́j. Ajta ɨ́ seɨj, aꞌɨ́ɨ pu ráꞌaxɨeehuariꞌira aꞌame. Capu aꞌatzu rɨꞌɨrí sej huataúraꞌan tɨ Dios tejámuaataꞌaíjteꞌen, tɨ puaꞌa hui seꞌɨ́jna jɨ́n huataúraꞌan sej tumin tíseɨreꞌen. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Majta aꞌɨ́ɨme ɨ́ fariseos, jeíhua mú ranecuaꞌatzecaꞌa ɨ́ tumin. Matɨ́ꞌɨj miyen tiráanamuajriꞌi, jeíhua mú raꞌutéxɨeehuariꞌiriꞌi meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Múꞌeen xu aꞌɨ́ɨn pɨ́rɨcɨ ɨ́ sej siyen tiúꞌujseijrata sej si rɨ́ꞌɨ títetéturaave ɨ́ teɨte jemi. Mɨ́ ajta Dios, aꞌɨ́ɨ pu tirúꞌumuaꞌaree aꞌij sej ꞌeen mú ru tzajtaꞌa. Aꞌɨ́jna tɨ nuꞌu ayén naa seijreꞌe ɨ́ teɨte jemi, aꞌɨ́ɨ pu hui aꞌij puaꞌa seijreꞌe ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Tɨ́j naꞌa hui aꞌajnáꞌɨmua ajta caí huataseíjre ɨ́ Juan, aꞌɨ́ɨ puꞌu tihuáꞌaꞌixaateꞌecaꞌa aꞌij tɨ tiraꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, ajta aꞌij mej tiraꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. Tɨ́j naꞌa tiuꞌutaseíjre ɨ́ Juan, aꞌɨ́j mú tihuáꞌaꞌixaateꞌe ɨ́ niuucari jɨmeꞌe ɨ́ mej jɨ́n huaújtemuaꞌaveꞌen aꞌij tɨ ꞌeen ɨ́ Dios jemi aꞌu tɨ tejéꞌaijta. Majta naímiꞌi tíꞌiteseꞌe mej meꞌuun aꞌuteárute caꞌanéeri jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Ajta aꞌɨ́ɨn yuꞌuxari, Moisés teecan tɨ raꞌuyúꞌuxacaꞌa, aúcheꞌe pu hui nain jɨ́n teꞌaráꞌastejsin. Jaítzeꞌe pu áꞌateere mej raꞌaráꞌasten caí nain tɨ́j naꞌa tɨ tíꞌiseijreꞌe íiyen chaanaca japua, ajta ɨ́ ta japua tɨ tejéꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ajtahuaꞌa seɨ́j niuucari huaꞌutáꞌixa tɨjɨ́n: ―Jaꞌatɨ tɨ mé rúurɨeni ɨ́ ruꞌɨ́j, tɨ puaꞌa áꞌiyen seɨ́j ancuréꞌeviꞌitɨn, aꞌɨ́ɨ pu raxánaꞌacɨraꞌaten aꞌɨ́jna jemi ɨ́ ꞌɨ́itaꞌa. Ajta, tɨ puaꞌa jaꞌatɨ raꞌancuréꞌeviꞌitɨn seɨ́j ɨ́ ꞌɨ́itaꞌa tɨ amuacaí mé rúurɨe ɨ́ rucɨ́n, aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌɨ́ɨ pu hui ajta raxánaꞌacɨraꞌaten. ");
INSERT INTO crnNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ajtahuaꞌa pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aa pu nuꞌu jáꞌahuaꞌa chíjteaani eꞌechéjmeꞌe, tɨ naa éeneꞌen tiꞌiteújcheꞌetehuaꞌa, cɨ́ɨxuri jɨmeꞌe tɨ tíꞌinacamua, ajta tɨ tiꞌirɨ́ꞌeen. Tɨ́ꞌɨj pɨ́ naꞌa pu tíꞌiyestehuaꞌa. Jéihua pu hui tíꞌinaꞌachitaꞌa aꞌɨ́jna jɨmeꞌe tɨ ruxɨéehua éꞌechejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","’Ajta nuꞌu aꞌɨ́ɨn tɨ caí aꞌij tíꞌijviicuaꞌi, áa pu aꞌitéjca táꞌapueerta aꞌu tɨ éꞌeche ɨ́ chíjteaani. Ayee pu nuꞌu ántehuaacaꞌa aꞌɨ́jna ɨ́ jaꞌatɨ tɨ caí aꞌij tíꞌijviicuaꞌi tɨjɨ́n Lázaro. Aꞌɨ́ɨ pu tíꞌicuiꞌi. Nainjapua nuꞌu hui cáꞌatza ɨ́ ru jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","’Jéꞌecan pu raxɨ́ꞌeveꞌecaꞌa tɨ ráacuaꞌani ɨ́ cuaꞌira tɨ tíꞌiteꞌení tɨ teꞌecájvitze meesa japua aꞌu tɨ tejéꞌecuaꞌa ɨ́ chíjteaani. Majta aꞌɨ́ɨme ɨ́ tzɨꞌɨcɨ, aꞌɨ́ɨ mú aꞌuréꞌenineicaꞌa, majta raacánaɨjxɨ ɨ́ tɨ hui cáꞌatza japua. ");
INSERT INTO crnNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","’Tɨ́ꞌɨqui aꞌájna xɨcájraꞌan tɨ jetzen huamɨ́ꞌɨ aꞌɨ́jna ɨ́ Lázaro, matɨ́ꞌɨj nuꞌu mi aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe ɨ́ ta japua, aꞌɨ́ɨ mú yaꞌuvíꞌitɨ ɨ́ Abraham jemi aꞌu tɨ Dios éꞌeseijreꞌe. Ajta aꞌɨ́ɨn ɨ́ chíjteaani, tɨ́ꞌɨj nuꞌu i aꞌɨ́ɨn huamɨ́ꞌɨ. Majta hui raꞌaváꞌana. ");
INSERT INTO crnNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","’Aꞌuu pu aꞌuteájturaa aꞌu tɨ áꞌataa ɨ́ taij. Jéihua pu rajpuaíjtzicaꞌa aꞌɨ́jna ɨ́ chíjteaani teecan. Tɨ́ꞌɨj i ájneerecaꞌa. Aj pu i raaseíj aꞌɨ́jna ɨ́ Abraham, ajta aꞌɨ́jna ɨ́ Lázaro tɨ aꞌutéveecaꞌa ɨ́ Abraham jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","’Aj pu i raatajé tɨjɨ́n: “Abraham, mɨ pej níꞌiyaꞌupua, náꞌancuꞌuvajxɨꞌɨ. Patáꞌaj mú yeꞌutaꞌíte pemɨ́jna mɨ Lázaro tɨ ij amɨ́n raꞌantíruꞌunen ɨ́ ruxɨté tɨ ij naatécɨmuajteꞌen ɨ́ neneanú jetze, aꞌiné jeíhua nu rajpuaíjtzi íiye taij tzajtaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","’Ajta aꞌɨ́ɨn Abraham, ayée pu nuꞌu hui tiuꞌutaniú tɨjɨ́n: “Niyauj, ni pecaí ramuaꞌaree aꞌij tɨ timuáavaɨj patɨ́ꞌɨj pauj ruurica ɨ́ chaanaca japua. Jéihua pu yeehui rɨ́ꞌɨ timuáavaɨj. Ajta amɨ́jna mɨ Lázaro, jeíhua pu aꞌij puaꞌa tirajpuaíjtzicaꞌa. Mɨ́ ajta íjii, aꞌɨ́ɨ mú yeehui ráꞌancuꞌuvajxɨꞌɨsin meyajna. Pajta múꞌee, íjii parajpuaíitzi pej puaꞌamé. ");
INSERT INTO crnNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ajta íjii, ayée pu yeehui ꞌeen, puꞌuri ayén huaújruu tɨ ayén teꞌatácuuniꞌin. Aꞌɨ́j pu jɨ́n caí rɨꞌɨrí mej antácɨɨne amun pújmeꞌen múꞌejmi jemi aꞌɨ́ɨme ɨ́ mej miyen raxɨ́ꞌeveꞌe. Ajta caí rɨꞌɨrí mej aꞌu tɨ pújmeꞌen aꞌitácɨɨne téjmi jemi aꞌɨ́ɨme ɨ́ mej majta miyen raxɨ́ꞌeveꞌe.” Ayee pu nuꞌu tiraataꞌixaa aꞌɨ́jna ɨ́ Abraham. ");
INSERT INTO crnNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","’Tɨ́ꞌɨj i ayén tiuꞌutaniú tɨjɨ́n: “Tɨ́ puaꞌa ayén tíꞌeeneꞌen, niyáꞌupua, ayée nu yeehui muahuavii, pej amɨ́jna Lázaro huataꞌíte tɨ aꞌuun aꞌatanén nitáàta tɨ éꞌeche, aꞌiné anxɨ́vica nu tiꞌihuaamuaꞌa. Chéꞌe yeehui amɨ́n rɨ́ꞌɨ tihuajaꞌutáꞌixaateꞌen mej mi caí miyun pújmeꞌen aꞌuvéꞌecɨꞌɨcaꞌan mej mi caí rajpuaíjtzi muáꞌaraꞌani meyajna.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","’Abraham pu nuꞌu ayén tiraataꞌixaa tɨjɨ́n: “Aꞌɨ́ɨ pu aꞌuteájturaa aꞌɨ́ɨme jemi aꞌɨ́jna Moisés teecan tɨ raꞌuyúꞌuxacaꞌa, ajta ɨ́ mej raꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Michéꞌe yeehui aꞌɨ́jna huanamua.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","’Ajta aꞌɨ́ɨn chíjteaani teecan, ayée pu tiraataꞌixaa tɨjɨ́n: “Niyáꞌupua, mɨ pej Abraham púꞌeen. Capu tiꞌitɨ́j vaɨreꞌe. Aru tɨ puaꞌa yeehui jaꞌatɨ tɨ ari huamɨ́ꞌɨ aj pu huataseíjreꞌesin aꞌɨ́mej jemi, aj mú mi seɨcɨé tíꞌimuaꞌati ɨ́ Dios jemi.” ");
INSERT INTO crnNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","’Aj pu nuꞌu i ayén tiraataꞌixaa tɨjɨ́n: “Tɨ́ puaꞌa mecaí ráanamua aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, ajta aꞌɨ́mej ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, camu yeehui majta ráꞌantzaahuateꞌesin tɨ puaꞌa huataseíjreꞌen huáꞌa jemi ɨ́ jaꞌatɨ tɨ aꞌitáraa ɨ́ mɨꞌɨchite tzajtaꞌa.” ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús pu ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Ayee pu téꞌeme tɨ tiꞌitɨ́j huataseíjreꞌen ɨ́ mej jɨ́n auteáturan ɨ́ Dios jemi. Chéꞌe aꞌij tɨ naꞌa jéꞌecan jemin aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén caꞌaníjraꞌa huaꞌutáꞌan mej mi tiꞌitɨ́j jɨ́n autéꞌɨtzen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","’Naꞌajtzɨ́ aꞌɨ́jna ɨ́ jaꞌatɨ mej amuacaícan raꞌacátapiꞌiran cɨjpáaraꞌan jetze ɨ́ tetej seꞌuníjraꞌa tɨ veꞌée mej mi raꞌateájrɨeeni á jaataꞌa tɨ ij án aujámɨn aꞌu tɨ autɨ́ꞌɨj. Jaítzeꞌe pu hui tiraatévaꞌɨrihuaꞌan caí ayén tiraatévaꞌɨrihuaꞌan tɨ puaꞌa aꞌɨ́ɨn caꞌaníjraꞌa tihuaꞌutáꞌan aꞌɨ́mej ɨ́ mej cɨ́lieen mej mi meꞌɨ́n auteáturan ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","’Aꞌɨ́j pu jɨ́n, rɨ́ꞌɨ xuꞌu múꞌeen. Tɨ́ puaꞌa aꞌɨ́ɨn aꞌihuáaraꞌa auteáturan múꞌeetzi jemi, patáꞌaj raꞌajteáꞌaxɨꞌɨn. Tɨ́ puaꞌa seɨcɨé tiúꞌumuaꞌati múꞌeetzi jemi, aj pej xaa tiraatáꞌuuniꞌira. ");
INSERT INTO crnNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","’Tɨ́ puaꞌa seɨ́j xɨcaj, jaꞌatɨ auteáturan múꞌeetzi jemi arahuaꞌapuáca jetze, ajta tɨ puaꞌa aꞌɨ́ɨn á aꞌuréꞌenen múꞌeetzi jemi ayén puaꞌamé arahuaꞌapuáca jetze tɨ́ꞌij ajtahuaꞌa ayén timuaatáhuavii yee tinaatáꞌuuniꞌiriꞌi ɨ́ nej jɨ́n auteájturaa múꞌeetzi jemi, ayée pej hui huárɨni pej tiraatáꞌuuniꞌi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Majta aꞌɨ́ɨme ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, ayée mú tiraataꞌixaa meꞌɨ́jna ɨ́ tavástaraꞌa tɨjɨ́n: ―Taatévaɨreꞌe tetáꞌaj téꞌantzaahuateꞌen jaítzeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨ pu tiúꞌujxeꞌeveꞌe sej cɨ́j caj téꞌantzaahuateꞌen. Tɨ́ puaꞌa siyen cɨ́j caj senaꞌa téꞌantzaahuateꞌen, ayée pu tiuꞌutárɨꞌɨriistari sej siyen tiraataꞌaíjteꞌen seꞌɨ́jna ɨ́ huaréj tɨ aꞌitiújcuta, tɨ á jáꞌitaꞌa jaataꞌa eꞌeteújhuiiteꞌen ruseɨ́j. Ajta aꞌɨ́ɨn huaréj, ayée pu rɨni aꞌij sej tiraataꞌaíjteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","’Tichéꞌe tiyen tiraataxáj. Tɨ́ puaꞌa jaꞌatɨ tíꞌimuarɨꞌe múꞌejmi jemi aꞌɨ́jna jɨmeꞌe tɨ taséehua naꞌari cáneꞌaxɨ chaꞌɨɨ, ¿aꞌiné yeꞌí setiraatájeevi tɨ́ꞌɨj aꞌɨ́ɨn uvéꞌenen aꞌu tɨ tejéꞌemuarɨꞌe? ¿Ni qui hui siyen tiraatájeevi yee: “Mu aꞌutáꞌiyiꞌi, aꞌujyeíjxɨꞌɨ patáꞌaj tiúꞌucuaꞌani?” Caxu xaa neꞌu siyen tiraatájeevi, sino ayée xuꞌu tiraatájeevi tɨjɨ́n: “Patáꞌaj yee rɨ́ꞌɨ tiúꞌuruuren ɨ́ tej tiúꞌucuaꞌani. Pajta, patáꞌaj rɨ́ꞌɨ huáꞌaruuren pej pi titaamín, aj pu yee xaa huatárɨꞌɨristari pej tiúꞌucuaꞌani, pajta pej huayéꞌen.” ");
INSERT INTO crnNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","’Ajta aꞌɨ́ɨn, tɨ́ꞌɨjtá ari ayén tiúꞌuruurén aꞌij sej tiraataꞌaíj, ¿ni secaí chaꞌa aꞌij tiraatáꞌixaateꞌesin yee chaꞌa Dios timuaatanájchiteꞌen? Caxu xaa neꞌu aꞌatzu, aꞌiné ayée pu tiúꞌuruu aꞌij sej tiraataꞌaíj. ");
INSERT INTO crnNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","’Ayee xu cheꞌatá senaꞌa huárɨni. Setɨ́ꞌɨj seri raacɨ́ꞌɨ nain jɨmeꞌe ɨ́ tɨ jɨ́n Dios tejámuaꞌíjca, ayée xuꞌu tiuꞌutaxájta yee catu hui tiꞌitɨ́j vaɨreꞌe iteen. Ayee tuꞌu huarɨ́j aꞌii tɨ tiúꞌujxeꞌeveꞌecaꞌa itejmi jemi. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Aúcheꞌe pu huaméꞌecaa ɨ́ juye jetze Jerusalén tɨ aꞌuréꞌenineꞌi. Aꞌuu pu aꞌumeꞌeca aꞌu tɨ eꞌeveꞌeꞌástɨme aꞌuun tɨ huatacáꞌa u ɨ́ Samaria, ajta u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tɨ́ꞌɨj aꞌuun aꞌuterutíjmeꞌecaa, aꞌúu mú raꞌantinájchecaꞌa ɨ́ teteca ɨ́ mej tamuáamuataꞌa aráꞌase. Aꞌɨ́ɨme metíꞌicucuiꞌi meꞌɨ́jna jɨmeꞌe ɨ́ tɨ tineájxɨ huáꞌahuaꞌiraꞌa jetze, ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n: lepra. Aꞌatzu mú ɨmuá aꞌutéhuiixɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Matɨ́ꞌɨj mi caꞌanín jɨ́n raatajé tɨjɨ́n: ―Jesús, mɨ pej maestro púꞌeen. Patáꞌaj táꞌancuꞌuvajxɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tɨ́ꞌɨj Jesús huaꞌuseíj, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj u áꞌujuꞌun huáꞌa jemi ɨ́ mej tíꞌivaɨreꞌe u teyujtaꞌa sej si huataújseijrata mej meꞌɨ́n ráamuaꞌaree tɨjɨ́n xuꞌuri huarúj. Matɨ́ꞌɨj mi u áꞌujuꞌun. Muꞌuri á aujúꞌucaa, aj mú mi huarúj. ");
INSERT INTO crnNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tɨ́ꞌɨj i seɨ́j huaréꞌaraa tɨ́ꞌɨj ráamuaꞌareeriꞌi tɨjɨ́n puꞌuri huarúj. Aj pu i aꞌatzu caꞌanín jɨ́n tiuꞌutaxájtacaꞌa ɨ́ Dios jemi tɨjɨ́n: ―Rɨ́ꞌɨ nu timuaatáꞌasin nevástaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Aj pu i eꞌerájve á chuaataꞌa á vejliꞌi jemin ɨ́ Jesús. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Chéꞌe Dios timuaatanájchiteꞌen. Aꞌɨ́jna ɨ́ jaꞌatɨ, ɨ́ Samaria pu éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni mecaí aráꞌase aꞌachú cumu tamuáamuataꞌa aꞌɨ́ɨme ɨ́ mej huarúj? ¿Aꞌuné aꞌij méꞌeen ɨ́ seica ɨ́ mej aramuáacua? ");
INSERT INTO crnNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ni amɨ́ naꞌa ruseɨ́j huaréꞌaraa tɨ ij rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios jemi, amɨ́jna tɨ seɨj chuéjraꞌa japua éꞌemeꞌecan? ");
INSERT INTO crnNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aj pu i ayén tiraataꞌixaa aꞌɨ́jna tɨ tíꞌicuiꞌicaꞌa tɨjɨ́n: ―Ájchesi. Pepuꞌuri huarúj, aꞌiné petéꞌantzaahua. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jaꞌanáj pu ayén tiujuꞌurɨ́j. Aꞌɨ́ɨ mú fariseos miyen tiraataꞌíhuaꞌuriꞌi meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―¿Aꞌanajni rɨ́ꞌɨ tejaꞌuréꞌenejsin tɨ Dios tiuꞌutaꞌaíjta íiyen chaanaca japua? Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Jaꞌanáj tɨ tejaꞌuréꞌenejsin tɨ Dios tiuꞌutaꞌaíjta íiyen chaanaca japua, capu ayén huataseíjreꞌesin aꞌɨ́jna jɨmeꞌe ɨ́ sej jɨ́n ráamuaꞌaree, ajta ɨ́ sej jɨ́n raaseíj yee puꞌuri yen huataseíjre. ");
INSERT INTO crnNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","’Camu hui miyen tiraataxájta ɨ́ teɨte yee: “Yeꞌecui seijreꞌe”, naꞌari yee “Aꞌacuí seijreꞌe.” Camu aꞌatzu, aꞌiné puꞌuri yé seijreꞌe aꞌɨ́jna jɨmeꞌe nej nee yé huatéjvee múꞌejmi tzajtaꞌa. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Puꞌuri aꞌájna tejaꞌuréꞌenejsin ɨ́ xɨcájraꞌa sej jetzen siyen raxɨ́ꞌeveꞌe xáꞌajuꞌun huápɨꞌɨ sej raaseíj netɨ́ꞌɨj amuacaí teꞌenteárute neꞌɨ́jna jɨmeꞌe nej nain jɨ́n antínmuaꞌareere. Aru, caxu hui raseijran. ");
INSERT INTO crnNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","’Teteca mú miyen tejámuaatáꞌixaateꞌesin tɨ jɨ́meꞌen yee puꞌuri aꞌájna tejaꞌuréꞌene tɨ Dios tiuꞌutaꞌaíjta íiyen chaanaca japua aꞌiné yé pu nuꞌu huatéjvee naꞌari yee mé pu nuꞌu huatéjvee naꞌari yee áa pu nuꞌu éꞌeseijreꞌe. Caxu hui u áꞌucɨꞌɨcaꞌan huáꞌa jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aꞌiné, ayée nu hui seíireꞌe naꞌame neꞌájna xɨcájraꞌan nej jetzen amuacaícan teꞌenteárute neꞌɨ́jna jɨmeꞌe nej nain jɨ́n antínmuaꞌareere naꞌame. Ayee nu cheꞌatá nenaꞌa seíireꞌe naꞌame matɨ́j ɨ́ mej témaxcavaꞌaraꞌa u júteꞌe. Tɨ́ꞌɨj huatátaaxɨꞌɨn, caꞌanacan pu huanéeriꞌicɨrej yeꞌicáa aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","’Aru miꞌi pu hui ayén tiúꞌujxeꞌeveꞌe nej jeíhua rajpuaíitzi náꞌaraꞌani inee. Ayee pu ajta tiúꞌujxeꞌeveꞌe mej netíte aꞌɨ́ɨme iiji mej huáteemua. ");
INSERT INTO crnNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","’Ayajna tɨ́j tiuꞌurɨ́j ajcaꞌihuáꞌɨmua tɨ́ꞌɨj auj ruuricaꞌa aꞌɨ́jna ɨ́ Noé teecan, ayée pu cheꞌatá naꞌa téꞌeme aꞌájna xɨcájraꞌan jetze nej jetzen yé uvéꞌenejsin inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","’Metíꞌicuaꞌacareꞌe ɨ́ teɨte, majta yéꞌecareꞌe. Seica mú néjneꞌɨjcheꞌecareꞌe, majta seica víjviɨꞌɨcheꞌecareꞌe. Camu aꞌij menaꞌa. Ayee mú rɨjcaa ajta naꞌa caí Noé aꞌuun pu aꞌuteájrupi ɨ́ baarcu jetze. Ajta pu i jeíhua tíjɨstecaꞌa ɨ́ jaj. Aꞌɨ́ɨ pu hui naíjmiꞌica antipuáꞌari. ");
INSERT INTO crnNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","’Ayee pu cheꞌatá tiráaruu ajcaꞌihuáꞌɨmua tɨ́ꞌɨj auj ruuricaꞌa aꞌɨ́jna ɨ́ Lot teecan. Aꞌɨ́ɨ mú tíꞌicuaꞌacareꞌe ɨ́ teɨte. Majta yéꞌecareꞌe. Majta tíꞌinanaavecareꞌe. Majta tíꞌituaacareꞌe. Majta tíꞌihuiitehuaꞌa mú mi, majta chiꞌij táꞌahuacareꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","’Aru aꞌájna xɨcájraꞌan jetze tɨ́ꞌɨj Lot huirájraa aꞌujna u Sodoma, taij pu hui u jeꞌicáaxɨre, tɨ azufre jɨ́n áꞌataacaꞌa. Naíjmiꞌica pu antipuáꞌajte. ");
INSERT INTO crnNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ayee pu cheꞌatá naꞌa tihuáꞌaruuren aꞌájna xɨcájraꞌan jetze nej huataseíjreꞌesin inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Ayee xu hui huárɨni aꞌájna xɨcájraꞌan jetze. Tɨ́ puaꞌa jaꞌatɨ án áꞌujveeca ɨ́ ruchiꞌi japua tɨ avéꞌejaxuꞌumuaꞌi, tɨ puaꞌa aꞌuun teꞌuráꞌaca ɨ́ tiꞌáꞌaraꞌan u chiꞌita, chaꞌa caí aꞌuun uteáruꞌipicheꞌen tɨ ij teꞌiráꞌɨn. Ajta aꞌɨ́ɨn tɨ tejéꞌemuarɨꞌe ɨ́ ruvíꞌiraꞌataꞌa, chaꞌa ajta aꞌɨ́ɨn caí u áꞌuyeꞌican u ruche tɨ ij tiꞌitɨ́j aꞌuvéꞌaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","’Setáꞌaj hui raꞌutámuaꞌaree aꞌij tɨ tiráaruu ɨ́ ɨ́raꞌaraꞌan ɨ́ Lot teecan. ");
INSERT INTO crnNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jaꞌatɨ tɨ naꞌa, tɨ puaꞌa aꞌɨ́ɨn ayén huárɨni aꞌij tɨ tirájteu ruseɨ́j tɨ́j naꞌa nain xɨcaj tzajtaꞌa, aꞌɨ́ɨ pu xaa aꞌuvaɨ́jtzi. Ajta aꞌɨ́ɨn tɨ taúraꞌaca tɨ huámɨꞌɨni ineetzi jetze meꞌecan, aꞌɨ́ɨ pu xaa huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Ayee nu tejáꞌamuaꞌixaateꞌe, aꞌájna tɨ́caꞌari tzajtaꞌa, mé huaꞌapua mú huatéjeꞌitɨ́ muáꞌajuꞌun ɨ́ utaatzi japua. Dios pu hui seɨ́j áꞌaviꞌitɨn. Ajta ɨ́ seɨj, áa pu aꞌuteáturaasin. ");
INSERT INTO crnNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","’Majta huaꞌapua ꞌuuca, mé naímiꞌi mú teꞌáꞌatɨꞌɨxɨ́n mú muáꞌajuꞌun. Dios pu seɨ́j áꞌaviꞌitɨn. Ajta ɨ́ seɨj, áa pu aꞌuteáturaasin. ");
INSERT INTO crnNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","’Majta huaꞌapua teteca, mé naímiꞌi mú tejéꞌemuarɨꞌe muáꞌajuꞌun u víꞌiraꞌataꞌa. Dios pu hui ajta seɨ́j áꞌaviꞌitɨn. Ajta ɨ́ seɨj, áa pu aꞌuteáturaasin. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Majta meꞌɨ́n ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tavastaraꞌa, ¿aꞌuné jetze ráꞌaviꞌitɨn ɨ́ Dios? Ayee pu tiuꞌutaniú tɨjɨ́n: ―Aꞌuu mej eꞌetiújseɨreꞌesin ɨ́ muáꞌaraꞌica aꞌu tɨ tiꞌitɨ́j auucáꞌa tɨ mɨ́ꞌɨchi. ");
INSERT INTO crnNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Aj pu i Jesús seɨ́j niuucari jɨ́n tihuaꞌutáꞌixaa mej mi ráamuaꞌaree tɨ ayén nuꞌu tiúꞌujxeꞌeveꞌe mej téniuucaꞌan jaꞌanáj tɨ naꞌa. Ajta ayén tiúꞌujxeꞌeveꞌe mej nuꞌu caí ruxɨeemɨ́jteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aa pu nuꞌu jáꞌahuaꞌa seɨ́j chajtaꞌa jetze jaꞌatɨ pu éꞌechejcaꞌa tɨ juees jɨ́n tiꞌitéveecaꞌa. Capu nuꞌu hui ráꞌateseꞌecaꞌa ɨ́ Dios aꞌɨ́jna ɨ́ juees, capu ajta jetzen ruxeꞌeveꞌecaꞌa aꞌij tɨ tiꞌitɨ́ huáꞌaruure ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","’Ajta nuꞌu seɨ́j aꞌuun aꞌutéveecaꞌa ꞌɨ́itaꞌa tɨ huaújseɨstarecaꞌa. Ajta aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, jaꞌanáj tɨ naꞌa pu aꞌuréꞌenineicaꞌa ɨ́ juees jemi. Ayee pu nuꞌu hui tíꞌijhuaviiracaꞌa tɨjɨ́n: “Patáꞌaj yeehui piyen náaruuren pej neꞌuxɨ́jteꞌen peꞌɨ́jna jɨmeꞌe tɨ jaꞌatɨ néjchaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ajta aꞌɨ́ɨn ɨ́ juees, aꞌɨ́ɨ pu nuꞌu ráꞌijmɨijracaꞌa. Puꞌuri aꞌateeviꞌi tɨ ayén raruurejcaꞌa. Aj pu i ayén tiuꞌumuáꞌaj tɨjɨ́n: “Jee xaa neꞌu, canu yeehui ráꞌateseꞌe ɨ́ Dios, capu ajta neetzi jetze ruxeꞌeveꞌe aꞌij tɨ tiꞌitɨ́j huáꞌaruure ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Aru amɨ́jna mɨ ꞌɨ́itaꞌa, tɨ́ꞌɨj pɨ́ naꞌa pu yeehui yé táninei. Jéꞌecan pu nejaaxɨejteꞌe. Tij caí nee nu yeehui ráꞌaxɨjteꞌen neꞌɨ́jna jɨmeꞌe tɨ jaꞌatɨ rájchaꞌɨɨreꞌe. Naꞌari caí, ajtahuaꞌa pu yeehui yé táninéicaꞌa aꞌame ajta nenaꞌa caí tácuaꞌanaxɨꞌɨn neꞌɨ́jna jɨmeꞌe.” Ayee pu nuꞌu tiuꞌumuáꞌaj. ");
INSERT INTO crnNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ajta tavástaraꞌa pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Xaanamuajriꞌi múꞌeen aꞌij tɨ tiꞌixa aꞌɨ́jna ɨ́ juees tɨ aꞌij puaꞌa tiꞌitiújchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ajta aꞌɨ́ɨn ɨ́ Dios ɨ́ sej rájyaꞌupua, ¿aꞌiné tejamuáꞌamitɨejteꞌe aꞌij tɨ huárɨni múꞌejmi jɨmeꞌe ɨ́ tɨ amuaꞌantíhuaꞌu? ¿Ni caí amuáꞌaxɨjteꞌen aꞌɨ́jna jɨmeꞌe ɨ́ mej amuájchaꞌɨɨreꞌe ɨ́ áꞌamuaxɨꞌej teɨte, ɨ́ tɨ Dios amuaꞌantíhuaꞌu? Aꞌii neꞌu caí. Nain xɨcaj tzajtaꞌa, ajta nain tɨ́caꞌari tzajtaꞌa, múꞌeen xu rahuauhuau tɨ ayén huárɨni. ¿Ni qui áꞌateere tɨ áꞌamuaꞌijmɨíira aꞌame? Capu xaa neꞌu aꞌatzu. ");
INSERT INTO crnNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","’Ayee nu hui tejáꞌamuaꞌixaateꞌe. Dios pu ayén téꞌujcaꞌane tɨ amaꞌuxɨ́jten aꞌɨ́jna jɨmeꞌe ɨ́ mej amuájchaꞌɨɨreꞌe. Ajta caꞌanacan pu ayén rɨni. Mɨ́ ajta, netɨ́ꞌɨj uvéꞌenen inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, ¿ni qui mecaí chaꞌa téꞌatzaahuateꞌe aꞌɨ́ɨme ɨ́ mej yen chaanaca japua aꞌuchéjme? Camu aꞌatzu, tzɨ́teꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús pu ajtahuaꞌa seɨ́j niuucari jɨ́n tihuaꞌutáꞌixaa aꞌɨ́mej jɨ́meꞌen ɨ́ mej miyen tiuꞌumuáꞌaj ɨ́ ru tzajtaꞌa tɨjɨ́n rɨ́ꞌɨ mú nuꞌu tíꞌiteteɨte, ɨ́ mej majta huáꞌaxɨeehuata ɨ́ seica ɨ́ ruxɨ́ꞌej teɨte. Tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Aꞌɨ́ɨme ɨ́ teɨte, ɨ́ mej huaꞌapua, aꞌúu mú nuꞌu aꞌuteájrupi teyujtaꞌa mej mi meꞌuun huatéjniuuni. Seɨ́j pu fariseo púꞌeeneꞌe. Ajta ɨ́ seɨ́j, aꞌɨ́ɨ pu hui pɨ́rɨcɨ tɨ huáꞌajijveꞌecaꞌa ɨ́ mej tíꞌitɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","’Ajta aꞌɨ́ɨn ɨ́ fariseo, aꞌɨ́ɨ pu nuꞌu huatéechaxɨ. Aꞌɨ́ɨ pu i aꞌutéjche tɨ ayén tiuꞌutéjniuuni ɨ́ ru tzajtaꞌa tɨjɨ́n: “Dios, jéꞌecan nu huatántemuaꞌaveꞌe múꞌeetzi jemi, aꞌiné canu yeehui niyen ꞌeen matɨ́j ꞌeen ɨ́ seica ɨ́ teɨte. Aꞌɨ́ɨ mú yeehui tíꞌinahuaꞌaj naꞌari aꞌij mú puaꞌa titetiújchaꞌɨɨ, majta metíuꞌuxanaꞌacɨraꞌate ꞌúucate jamuan. Canu yeehui neajta niyen ꞌeen tɨ́j amɨ́jna tɨ huáꞌajijveꞌe aꞌɨ́mej ɨ́ mej tíꞌitɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Huaꞌapuaca jetze nu yeehui néꞌitziꞌivi seɨj itɨeeri jɨmeꞌe. Neajta niyen tiraatáꞌaca seɨ́j tamuáamuataꞌa tɨ anxɨ́te meꞌecan ɨ́ tɨ tinaacɨ́ꞌɨ.” ");
INSERT INTO crnNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","’Ajta aꞌɨ́ɨn tɨ huáꞌajijveꞌe ɨ́ mej tíꞌitɨcɨ, áa pu nuꞌu hui aꞌatzu ɨmuá aꞌutevée. Capu nuꞌu ajta áꞌujcaꞌanejcaꞌa tɨ júteꞌe áꞌujneere, sino anteújtuꞌasixɨ ɨ́ rútaviitzeꞌe ɨ́ rumuájcaꞌa jɨmeꞌe. Ayee pu nuꞌu tiuꞌutéjniuu tɨjɨ́n: “Dios, patáꞌaj yeehui náꞌancuꞌuvajxɨꞌɨn ineetzi, aꞌiné aꞌij nu puaꞌa tiꞌitínchaꞌɨɨ.” Ayee puꞌu hui tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","’Ayee nu tejáꞌamuaꞌixaateꞌe aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huáꞌajijveꞌe ɨ́ mej tíꞌitɨcɨ, aꞌɨ́ɨ pu xaa rɨꞌéeneꞌecán jɨ́n huateájturaa ɨ́ ru tzajtaꞌa ɨ́ Dios jemi tɨ́ꞌɨj aꞌaráꞌa ɨ́ ruche. Ajta ɨ́ seɨ́j ɨ́ fariseo, capu hui aꞌatzu xɨ́ꞌepɨꞌɨn tiuꞌuteájturaa ɨ́ Dios jemi. Ayee puꞌu tieeneꞌe jáꞌaraa, aꞌiné tɨ puaꞌa jaꞌatɨ tɨ naꞌa áꞌujtzaahuateꞌe, aꞌɨ́ɨ pu tiuꞌutatéviꞌiraꞌata. Ajta tɨ puaꞌa jaꞌatɨ tɨ́j naꞌa caí ayén téꞌujtzaahuateꞌe, Dios pu veꞌecán jɨ́n tíꞌiraꞌíjcateꞌen. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Majta seica ɨ́ teɨte, tɨꞌɨríi mú á jeꞌevéꞌeviꞌitɨxɨ ɨ́ Jesús jemi tɨ ij aꞌɨ́ɨn hueꞌiréꞌechuiixɨꞌɨn tɨ ij Dios ayén aꞌɨ́jna jɨ́n rɨ́ꞌɨ tihuaꞌutáꞌan. Matɨ́ꞌɨj meꞌɨ́n huaꞌuseíj aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj mi huaꞌajtéaꞌaxɨ ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mɨ́ ajta aꞌɨ́jna ɨ́ Jesús, aꞌɨ́ɨ pu huaꞌutajé ɨ́ tɨꞌɨríi mej mi aꞌireꞌenen ɨ́ jemin. Ayee pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Micheꞌe memɨ́n mé huajeꞌevéꞌeviꞌitɨ́n ineetzi jemi mɨ tɨꞌɨríi. Caxu huáꞌijmɨijra, aꞌiné amɨ́mej pu hui tíꞌicɨꞌɨti mej mi meꞌuun aꞌuteárute aꞌujna Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, jaꞌatɨ tɨ naꞌa tɨ hui caí ayén cheꞌatá naꞌa áꞌujcaꞌane tɨ Dios tiraataꞌaíjteꞌen aꞌij mej titéꞌujcaꞌane mɨ tɨꞌɨríi, capu xaa neꞌu aꞌájna aꞌuteáruti aꞌu tɨ Dios éꞌeseijreꞌe. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ, aꞌúu pu aꞌutéveecaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen seɨ́j tɨ tíꞌaijta. Ayee pu tiraataꞌíhuaꞌuriꞌi aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Maeestru, mɨ pej urarɨ́ꞌen ɨ́ áꞌa tzajtaꞌa, aꞌiné tiúꞌujxeꞌeveꞌe nej niyen huárɨni tɨ ij tináacɨꞌɨti nej ruuri náꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n piyen tíꞌinexa yee nej urarɨ́ꞌen yú ne tzajtaꞌa? ¿Ni pecaí ramuaꞌaree tɨ seɨ́j naꞌa aꞌɨ́ɨn púꞌeen tɨ urarɨ́ꞌen ɨ́ ru tzajtaꞌa? Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","’Pepuꞌuri hui tirúꞌumuaꞌaree aꞌij tɨ Dios tiuꞌutaꞌaíjtacaꞌa yé capej tíꞌaxanaꞌacɨraꞌate, capej yee tíꞌitecuiꞌica, capej ajta yee tíꞌinahuaꞌaj, capej ajta yee tíꞌihuaꞌitacareꞌen. Pajta yee rɨ́ꞌɨ tihuáꞌuchaꞌɨn aꞌatáàta, pajta aꞌanáàna. ");
INSERT INTO crnNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ajta aꞌɨ́ɨn tɨ tíꞌaijta, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nain nu jɨ́n tiraꞌaráꞌastijre tɨ́j naꞌa nej naúcheꞌe páꞌarɨꞌɨsta. ");
INSERT INTO crnNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tɨ́ꞌɨj Jesús ráanamuajriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa, aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Seɨ́j puꞌu hui muáꞌaturaateꞌe. Patáꞌaj nain tiúꞌutuaani aꞌachú pej caj tíꞌijchaꞌɨɨ. Aj pej pi huaꞌuréꞌan ɨ́ tumin aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi. Tɨ́ puaꞌa piyen huárɨni, aj pej xaa raꞌancuréꞌasin ɨ́ tɨ ta japua éꞌeseijreꞌe aꞌɨ́jna tɨ huápɨꞌɨ tíꞌijnajche. Aj pej hui pijtáꞌi mú aꞌarájraꞌani neetzi jamuan. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ajta aꞌɨ́ɨn tɨ tíꞌaijta, tɨ́ꞌɨj ráanamuajriꞌi aꞌij tɨ Jesús tiuꞌutaxájtacaꞌa, jéꞌecan pu huataújxɨeemɨste, aꞌiné jeíhua pu tíꞌijchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Aj pu i Jesús raꞌaráaseij. Tɨ́ꞌɨj i ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Jéꞌecan pu huápɨꞌɨ huáꞌamuarɨꞌeristeꞌe aꞌɨ́mej chíjteaani mej mi meꞌuun aꞌuteárute u ta japua Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","’Ee xaa neꞌu, ayée nu hui tejáꞌamuaꞌixaateꞌe tɨ ayén tiꞌayajna, jaítzeꞌe pu muárɨꞌeri tɨ chíjteaani aꞌuun aꞌuteárute u ta japua Dios tɨ éꞌeseijreꞌe caí tɨ cameeyuꞌu tiꞌitɨ́j anaarute ɨ́ pɨ́ꞌɨseꞌe jetze. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Majta meꞌɨ́n ɨ́ mej ráanamuajriꞌi, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné yeꞌí tíꞌirɨꞌɨri tɨ jaꞌatɨ aꞌuun huateáturan Dios tɨ éꞌeseijreꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́mej jemi ɨ́ teteca, capu xaa aꞌij tíꞌirɨꞌɨri. Mɨ́ ajta Dios, aꞌɨ́ɨ pu xaa raayɨ́ꞌɨtɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiraataꞌixaa tɨjɨ́n: ―Maeestru, nain tu hui teri tejaꞌuhuáꞌaxɨ ɨ́ tej tíꞌijchaꞌɨɨcaꞌa tej ti áꞌujujhuaꞌaneꞌen á jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, ayée pu hui tihuáꞌacɨꞌɨti jaꞌatɨ tɨ naꞌa tɨ ari jaítzeꞌe rɨ́ꞌɨ tinájchaꞌɨɨ ineetzi caí máàj jaꞌatɨ aꞌɨ́jna jɨmeꞌe tɨ nee jamuan áꞌucheꞌecan. Tɨ́ puaꞌa hui jaꞌatɨ ayén jaítzeꞌe tíꞌijxeꞌeveꞌe tɨ nee jamuan áꞌucheꞌecaneꞌen caí ayén tíꞌijxeꞌeveꞌe tɨ aꞌuun huateáturan ɨ́ ruchiꞌitá, nusu tɨ puaꞌa jaítzeꞌe rɨ́ꞌɨ tinájchaꞌɨɨ ineetzi caí ɨ́ ruꞌɨ́j nusu ɨ́ rujaꞌatzimuá nusu ɨ́ rucuꞌutzimuá nusu ɨ́ rujúutzimuaꞌa nusu ɨ́ ruvaújsimuaꞌa, jeíhua pu jaítzeꞌe raꞌancuréꞌasin íjii tɨ yú auumé aꞌíjna jetze i chaanaca, ajta, aꞌɨ́ɨ pu hui ruuri aꞌame tɨ́j naꞌa rusén jɨmeꞌe tɨ́ꞌɨj méjcaꞌi huáyee tɨ yé eꞌevéꞌeme. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tɨ́ꞌɨj i rujɨ́ɨmuaꞌa huaꞌutajé aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Tuꞌuri hui tɨ́muaꞌa á aꞌujnéjsin ántivi Jerusalén. Ajta naíjmiꞌi pu teꞌaraúrastejsin aꞌij mej yeꞌí tiraꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan ineetzi jɨmeꞌe, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","33","’Aꞌɨ́ɨ mú tiuꞌutátuiireꞌesin ineetzi aꞌɨ́mej jemi ɨ́ mej seɨj chuéjraꞌa japua éꞌemeꞌecan. Majta aꞌɨ́ɨme, aꞌɨ́ɨ mú naꞌaxɨéehuariꞌira muáꞌajuꞌun, majta aꞌij puaꞌa tíꞌinexajtan. Aꞌɨ́ɨ mú hui majta naatetzíꞌijmuaꞌaxɨꞌɨsin, majta naatévajxɨꞌɨsin. Matɨ́ꞌɨj mi nejéꞌicatan. Tɨ́ꞌɨj hui ari huaíca xɨcaj jetze teuuméꞌen, aj nu ni aitamé huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Majta meꞌɨ́n ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, camu aꞌatzu yaúꞌitɨée muáꞌaraa. Aꞌɨ́ɨ pu ráꞌavaatacaꞌa aꞌij tɨ huataújmuaꞌa. Aꞌɨ́j pu jɨ́n caí aꞌij tihuáꞌamitɨejteꞌecaꞌa aꞌij tɨ huataújmuaꞌa ɨ́ tɨ raataxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aa mú vejliꞌi aꞌucajúꞌuca aꞌájna jáꞌahuaꞌa u Jericó. Ajta seɨ́j, áa pu aꞌutácatii juye tɨ aꞌatánineꞌi, tɨ vaɨ́riꞌira huaucaꞌa. Arácun aꞌɨ́jna ɨ́ jaꞌatɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tɨ́ꞌɨj aꞌɨ́ɨn huáꞌunamuajriꞌi ɨ́ mej jeíhua teɨte u áꞌucɨꞌɨcaꞌan, tɨ́ꞌɨj i aꞌɨ́ɨ tiuꞌutaꞌíhuaꞌu tiꞌitɨ́j tɨ aꞌij rɨjcaa. ");
INSERT INTO crnNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Yé pu eꞌicáame aꞌɨ́jna ɨ́ Jesús, Nazarét tɨ éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Tɨ́ꞌɨj i ayén tiraatajé tɨjɨ́n: ―Jesús, mɨ pej iꞌi huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan, patáꞌaj hui náꞌancuꞌuvajxɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Majta meꞌɨ́n ɨ́ mej amuaatéꞌee muaajúꞌucaa, aꞌɨ́ɨ mú raꞌajtéꞌaxɨ, majta raatáꞌijmɨijriꞌi tɨ nuꞌu caí tíꞌixajta. Mɨ́ ajta aꞌɨ́ɨn caí, capu raatapuáꞌajtacaꞌa. Jaítzeꞌe pu caꞌanín jɨ́n tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Mɨ́ pej huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ David teecan, patáꞌaj náꞌancuꞌuvajxɨꞌɨn ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Ajta aꞌɨ́ɨn ɨ́ Jesús, áa pu aꞌutéechaxɨ. Ajta huaꞌutaꞌaíj mej yeꞌevéꞌeviꞌitɨn jemin. Tɨ́ꞌɨj á vejliꞌi eꞌevéꞌemeꞌecaa, Jesús pu ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tiꞌitɨ́j petíꞌijxeꞌeveꞌe nej niyen muáruuren múꞌeetzi? Aj pu i aꞌɨ́ɨn taꞌarácun, ayén tiuꞌutaniú tɨjɨ́n: ―Nevástaraꞌa, ayée nu hui tíꞌijxeꞌeveꞌe nej neajta atáneere. ");
INSERT INTO crnNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Nee nu muaatáꞌasin pej pajtáhuaꞌa atáneere. Pepuꞌuri huarúj aꞌiné petéꞌatzaahuateꞌe múꞌee. ");
INSERT INTO crnNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jɨ́meꞌen puꞌu ayén tiraataꞌixaa, aj pu i aꞌɨ́ɨn taꞌarácuunicaꞌa, atáneerecaꞌa. Ajta áꞌuraa jamuan ɨ́ Jesús. Ajta rɨ́ꞌɨ pu tiraatáꞌacareꞌe ɨ́ Dios. Majta aꞌɨ́ɨme ɨ́ teɨte, matɨ́ꞌɨj raaseíj, aꞌɨ́ɨ mú majta rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tɨ́ꞌɨj i Jesús aꞌuun pu aꞌuteájrupi u Jericó. Aꞌuu pu jáꞌitaꞌa auméꞌecaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ajta seɨ́j aꞌuun aꞌutéveecaꞌa tɨ ayén ántehuaa tɨjɨ́n Zaqueo. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ tihuáꞌaijteꞌe aꞌɨ́mej ɨ́ mej huáꞌajiꞌivi ɨ́ mej tíꞌitɨcɨ. Chíjteaani pu púꞌeen aꞌɨ́jna ɨ́ Zaqueo. ");
INSERT INTO crnNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Aꞌɨ́ɨ pu raseijramɨꞌɨcaꞌa jaꞌatɨ tɨ pɨ́rɨcɨ aꞌɨ́jna ɨ́ Jesús. Aru capu rɨꞌɨríistacaꞌa aꞌiné jeíhua mú teɨte, ajta iꞌitzapuátuun aꞌɨ́jna ɨ́ Zaqueo. ");
INSERT INTO crnNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aꞌɨ́j pu jɨ́n anayeíxɨꞌɨ aꞌutɨéechejraa. Aj pu i antíraa ɨ́ mejchi jetze tɨ ij raaseíj temuaꞌa naa aꞌiné puꞌuri ramuaꞌareerecaꞌa tɨjɨ́n áa pu aꞌireꞌenejsin. ");
INSERT INTO crnNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tɨ́ꞌɨj Jesús aꞌuun eꞌiréꞌene. Aj pu i ájneerecaꞌa ɨ́ cɨyej jetze. Aj pu i ayén tiraataꞌixaa tɨjɨ́n: ―Zaqueo, patáꞌaj caꞌanacan acájraꞌani. Ayee pu hui tiúꞌujxeꞌeveꞌe nej neꞌuun anúꞌasti íjii neꞌájna aꞌu pe éꞌeche. ");
INSERT INTO crnNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tɨ́ꞌɨj i caꞌanacan acájraa. Aj pu i raꞌancuréꞌeviꞌitɨ temuaꞌa naa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Majta aꞌɨ́ɨme ɨ́ teɨte, matɨ́ꞌɨj raaseíj, matɨ́ꞌɨj mi autéjhuii mej miyen aꞌij puaꞌa tíꞌixajta tɨjɨ́n: ―Aꞌuu pu aꞌumé tɨ aꞌuun anúꞌasti aꞌu tɨ éꞌeche seɨ́j tɨ aꞌij puaꞌa tiꞌitiújchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ajta aꞌɨ́ɨn Zaqueo, á pu aꞌutéechaxɨ. Aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Casiꞌi, nevástaraꞌa, nuꞌuri jáꞌitaꞌa huaꞌutapuaíjveꞌesin aꞌɨ́mej ɨ́ mej caí aꞌij tíꞌijviicuaꞌi, jáꞌitaꞌa ɨ́ nej tíꞌijchaꞌɨɨ. Ayee nu hui neajta rɨni. Tɨ́ puaꞌa necaí jaꞌanáj jaꞌatɨ tiuꞌunáhuaꞌiriꞌi, ayée nu muáacuaca puaꞌaméca raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Aj pu i Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Ijii pu xaa Dios huaꞌirájtuaa aꞌɨ́mej íiye mej che aꞌiné aꞌíjna ɨ́ jaꞌatɨ, aꞌii pu ajta aꞌɨ́ɨn púꞌeen huáacɨxaꞌaraꞌan aꞌɨ́jna ɨ́ Abraham teecan. ");
INSERT INTO crnNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","’Ayee pu tíꞌeen aꞌiné inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, ayée nu hui ꞌeen jɨ́n mú aꞌuvéꞌemej nej ni huaꞌavéꞌehuauni, neajta huaꞌirájtuaani aꞌɨ́mej ɨ́ mej miyen áꞌujujhuaꞌan cu xɨee mej meri áꞌuveti. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Maúcheꞌe mú tíꞌinamuajracaꞌa ɨ́ teɨte, tɨ́ꞌɨj Jesús seɨ́j niuucari jɨ́n tihuaꞌutáꞌixaa aꞌiné puꞌuri vejliꞌi antenéesimeꞌeca ánti Jerusalén. Majta aꞌɨ́ɨme ɨ́ teɨte, ayée mú tíꞌimuajca tɨjɨ́n puꞌuri tɨ́muaꞌa huataseíjreꞌesin tɨ Dios autéjcheni tɨ tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Aꞌɨ́j pu jɨ́n ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu nuꞌu hui jaꞌanáj tiujuꞌurɨ́j aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huáꞌa jetze airáane ɨ́ teɨte ɨ́ mej tíꞌaijtacaꞌa. Tɨꞌɨj jí u aꞌuméꞌe aꞌame seɨ́j chuéjraꞌa japua mej mi meꞌuun yeꞌentíhuauni rey jɨmeꞌe. Tɨ́ꞌɨjtaꞌi nuꞌu uvéꞌenejsin. ");
INSERT INTO crnNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","’Tɨ́ꞌɨj caí xɨ u áꞌume, amuacaícan pu nuꞌu aꞌɨ́mej huatajé ɨ́ mej tíꞌimuarɨꞌe ɨ́ jemin. Tamuáamuataꞌa mú hui aráꞌasecaꞌa. Aj pu i tumin huaꞌutáꞌa seɨj ajta seɨj, tɨ ayén tíꞌijnajche ayén puaꞌamé aꞌachú mej ramuáꞌitɨcɨ huaíca máxcɨraꞌi jɨmeꞌe. Ayee pu nuꞌu tihuaꞌutáꞌixaa tɨjɨ́n: “Setáꞌaj seꞌɨ́jna jɨ́n tiraamuáristeꞌen tɨ jaítzeꞌe raamuáꞌitɨn, ajta nenaꞌa caí uvéꞌenen.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","’Mɨ majta meꞌɨ́n ɨ́ tɨ tihuáꞌaijteꞌe, aꞌɨ́ɨ mú nuꞌu hui rájchaꞌɨɨreꞌecaꞌa. Matɨ́ꞌɨj mi seica huataꞌítecaꞌa mej mi miyen tiraataꞌixaateꞌen yee mej caí raxɨ́ꞌeveꞌe tɨ aꞌɨ́ɨn teꞌenteárute ɨ́ rey jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Mɨ ajta aꞌɨ́ɨn tiraꞌanteájrupi rey jɨmeꞌe. Ajta nuꞌu uvéꞌene aꞌájna tɨ éꞌeche. Aj pu i huaꞌutajé aꞌɨ́mej ɨ́ tɨ huaꞌutáꞌa ɨ́ tumin tɨ ij ráamuaꞌaree aꞌachú mej caj raamuáꞌitɨ seɨ́j ajta seɨj. ");
INSERT INTO crnNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","’Ajta aꞌɨ́ɨn tɨ amuacaí á eꞌiréꞌene, ayée pu nuꞌu hui tiraataꞌixaa tɨjɨ́n: “Nevástaraꞌa, aꞌɨ́jna ɨ́ tumin múꞌeetzi tɨ aꞌáa, ayée pu yeehui tamuáamuataꞌa puaꞌaméca huamuáꞌitɨ.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","’Ayee pu nuꞌu tiuꞌutaniú aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe tɨjɨ́n: “Xɨ́ꞌepɨꞌɨn pej huarɨ́j mɨ pej rɨ́ꞌɨ nevaɨreꞌe. Aꞌiné capej tiꞌitɨ́j jɨ́n aꞌutéꞌɨtzee peꞌɨ́jna jɨmeꞌe tɨ caí veꞌée, nee nu yeehui tíꞌimuaꞌijcateꞌen patáꞌaj tiuꞌutaꞌaíjta tamuáamuataꞌa puaꞌamecɨé ɨ́ chajtaꞌa jetze.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","’Ajta aꞌɨ́ɨn tɨ tíꞌivaɨreꞌe tɨ raꞌitéꞌasi, aꞌɨ́ɨ pu ajta á eꞌiréꞌene. Ayee pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Nevástaraꞌa, aꞌɨ́jna ɨ́ tumin, múꞌeetzi tɨ ꞌaꞌáa, anxɨ́vica puaꞌaméca huamuáꞌitɨ.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","’Ajta aꞌɨ́ɨn tɨ tíꞌiraꞌaijteꞌe, ayée pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Ayee nu yeehui tíꞌimuaꞌijcateꞌen patáꞌaj tiuꞌutaꞌaíjta anxɨ́vica puaꞌamecɨé ɨ́ chajtaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","’Tɨꞌɨj jí seɨ́j á eꞌiréꞌene tɨ tíꞌivaɨreꞌe ɨ́ jemin. Ayee pu nuꞌu tiraataꞌixaa tɨjɨ́n: “Nevástaraꞌa, yeꞌecui yeehui múꞌeetzi tɨ aꞌáa ɨ́ tumin. Ayuu nu jetze raꞌancáajɨꞌɨcɨe cɨ́ɨxuri jetze. Netɨ́ꞌɨj ni yeehui raatéꞌavaata. ");
INSERT INTO crnNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ayee nu yeehui huarɨ́j aꞌiné nemuaatátziɨn. Muárɨꞌeri tɨ jaꞌatɨ rɨ́ꞌɨ tiuꞌuteáturan múꞌeetzi jemi. Múꞌee pej raaréꞌeseꞌɨri ɨ́ pej caí tiuꞌutáꞌa. Pajta múꞌee tíꞌitzaꞌanaca aꞌu pej yeehui caí tejéꞌehuasteꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","’Aj pu nuꞌu i ayén tiuꞌutaniú aꞌɨ́jna tɨ tíꞌiraꞌaijteꞌe tɨjɨ́n: “Nee nu yeehui puaíjtzi muaatáꞌasin neꞌɨ́jna jɨmeꞌe aꞌij pej tiuꞌutaxájtacaꞌa, mɨ pej aꞌij puaꞌa tíꞌivaɨreꞌe. Múꞌee pe rúꞌumuaꞌareerecaꞌa tɨjɨ́n netiꞌáijtaca caꞌanéeri jɨmeꞌe. Neajta raaréꞌeseꞌɨri ɨ́ nej caí tiuꞌutáꞌa. Pajta piyen tíꞌinexa yee netíꞌitzaꞌanaca aꞌu nej caí tejéꞌehuasteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","’Tɨ́ puaꞌa yeehui piyen tíꞌimuajca, ¿aꞌiné ꞌeen jɨ́n pecaí piyen huarɨ́j pej á yaúutuaa ɨ́ tumin huáꞌa jemi ɨ́ mej tíꞌineꞌɨjte tɨ i aꞌatzu raamuáꞌitɨn? Ayee pepuꞌu jɨ́n huárɨniicheꞌe, nee nu raꞌancuréꞌaniicheꞌen neetzi tɨ neꞌáa, neajta ɨ́ tɨ raamuáꞌitɨ netɨ́ꞌɨj uvéꞌene.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","’Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej á vejliꞌi aꞌutéꞌuucaꞌa tɨjɨ́n: “Setáꞌaj yeehui ráꞌariꞌi ɨ́ tumin tɨ ruꞌitéꞌaa, sej si raatáꞌan seꞌɨ́jna tɨ tamuáamuataꞌa ruꞌitéꞌaa.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","’Majta aꞌɨ́ɨme, ayée mú nuꞌu tiraataꞌixaa tɨjɨ́n: “Tavastaraꞌa, ¿aꞌiné tɨ i? Amɨ́ pu yeehui ari ruꞌitéꞌaa tamuáamuataꞌa puaꞌaméca ɨ́ tumin.” ");
INSERT INTO crnNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","’Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: “Ayee nu yeehui tejáꞌamuaꞌixaateꞌe. Jaꞌatɨ tɨ naꞌa tɨ jeíhua tíꞌijchaꞌɨɨ aꞌɨ́jna jɨmeꞌe tɨ rɨ́ꞌɨ tiuꞌutévaɨ, jaítzeꞌe pu yeehui tíꞌijcɨꞌɨti aꞌɨ́jna. Ajta jaꞌatɨ tɨ naꞌa tɨ caí tiꞌitɨ́j tíchaꞌɨɨ aꞌɨ́jna jɨmeꞌe tɨ aꞌij puaꞌa tiuꞌutévaɨ, Dios pu ráꞌariꞌira ɨ́ tɨ cɨ́j caj tíꞌijchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Majta aꞌɨ́ɨme ɨ́ mej néjchaꞌɨɨreꞌe, majta mej caí raxɨ́ꞌeveꞌecaꞌa nej rey jɨ́n teꞌenteárute nej ni tíhuaꞌutaꞌaíjteꞌen, mé xu yeehui huajeꞌevéꞌeviꞌitɨ́n, seajta huáꞌucuiꞌini íiye vejliꞌi ne jemi.” Ayee pu nuꞌu hui tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ rey. ");
INSERT INTO crnNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tɨ́ꞌɨj Jesús raatapuáꞌajtacaꞌa tɨ tihuáꞌaꞌixaateꞌen, aj pu i anayeíxɨꞌɨ áꞌuraa. Aj pu aꞌujnéesimeꞌeca ánti Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Tɨ́ꞌɨj jí aꞌuun vejliꞌi aꞌuréꞌene aꞌujna jáꞌahuaꞌa Betfagé, ajta aꞌujna jáꞌahuaꞌa Betania, chajtaꞌa tɨ aꞌuun aꞌutacáꞌa ájcaꞌi jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Aꞌuu pu huaꞌapuaca huataꞌítecaꞌa ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj seꞌuun aꞌuteárute aꞌájna chajtaꞌa, aꞌɨ́ɨn tɨ éꞌeseijreꞌe ɨ́ juye jetze. Aꞌájna vejliꞌi aꞌu sej aꞌuteáruti, áa xu puuruꞌu éꞌeteuni tɨ aꞌijtápiꞌi, tɨ caí xɨ jaꞌanáj jaꞌatɨ japuan avéꞌeyeijxɨ. Setáꞌaj ráꞌijxɨjta. Seajta yeꞌeráajan. ");
INSERT INTO crnNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tɨ́ puaꞌa hui jaꞌatɨ ayén tejáꞌamuaꞌihuaꞌura yee aꞌiné ꞌeen jɨ́n seráꞌijxɨjta, setáꞌaj siyen tiraataꞌixaateꞌen yee tavástaraꞌa pu nuꞌu hui raxɨ́ꞌeveꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Matɨ́ꞌɨj mi meꞌuun u áꞌujuꞌun ɨ́ tɨ huaꞌutaꞌítecaꞌa. Ayee pu teꞌirájraa tɨ́j tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Matɨ́ꞌɨj mauj ráꞌijxɨjtajmeꞌecaꞌa ɨ́ puuruꞌu, matɨ́ꞌɨj mi huaꞌuseíj aꞌɨ́ɨme ɨ́ tɨ huáꞌacɨi. Aj mú mi tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n seráꞌijxɨjta mɨ puuruꞌu? ");
INSERT INTO crnNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Matɨ́ꞌɨj mi miyen tiuꞌutaniú tɨjɨ́n: ―Tavastaraꞌa pu nuꞌu hui raxɨ́ꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Matɨ́ꞌɨj mi yaꞌujáj ɨ́ Jesús jemi. Matɨ́ꞌɨj mi tiúꞌujcɨɨxu tiraꞌitéꞌitate. Aj mú mi raꞌantítuaa meꞌɨ́jna ɨ́ Jesús ɨ́ puuruꞌu jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Tɨ́j naꞌa tiuꞌuméꞌecaa ɨ́ Jesús, teɨte mú cɨ́ɨxuri tiuꞌuteváarajyeꞌicaa ɨ́ juye jetze aꞌu tɨ auméꞌecaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tɨ́ꞌɨj i aj auméꞌecaa aꞌájna Aceituunajemi, aꞌu tɨ aꞌucaújcɨjmeꞌen. Naímiꞌi ɨ́ mej jamuan huajúꞌucaa, aꞌɨ́ɨ mú autéjhuii mej rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios meꞌɨ́jna jɨmeꞌe mej huataújtemuaꞌave aꞌiné jeíhua mú tiuꞌuséij tɨ huápɨꞌɨ tiúꞌujxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ayee mú tíꞌixajtacaꞌa tɨjɨ́n: Rɨ́ꞌɨ pu tiraatáꞌa aꞌɨ́jna tɨ rey jɨmeꞌe tiꞌitéjvee tɨ ajta méꞌe véꞌeme niuucajtzeꞌen ɨ́ tavástaraꞌa, amɨ́jna tɨ Dios raꞌantíhuaꞌu. Michéꞌe rɨ́ꞌɨ hui tiꞌitechée muáꞌaraꞌani aꞌɨ́ɨme ɨ́ mej ta japua éꞌeseijreꞌe. Michéꞌe majta rɨ́ꞌɨ tiraatáꞌan aꞌɨ́jna tɨ aꞌuun áꞌujca antiɨ́ꞌɨmua. ");
INSERT INTO crnNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Majta seica ɨ́ fariseos, matɨ́ꞌɨj ráanamuajriꞌi, ayée mú tiraataꞌixaa meꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Maeestru, huaꞌutáꞌijmɨijriꞌi mej mi caí chaꞌa miyen tíꞌixajta aꞌɨ́ɨme ɨ́ mej á jamuan áꞌujujhuaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe. Tɨ́ puaꞌa aꞌɨ́ɨme mecaí miyen tíꞌixajta, aꞌɨ́ɨ pu hui tetej ayén cheꞌatá naꞌa tiꞌixáata aꞌame caꞌaníjraꞌa jɨmeꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tɨ́ꞌɨj á vejliꞌi auméꞌecaa u Jerusalén, aj pu i raaseíj ɨ́ chajtaꞌana. Tɨ́ꞌɨj i huaújyeinecaꞌa aꞌɨ́jna jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ayee pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Tɨ́ puaꞌa múꞌeen séjmuaꞌareere, íjii, aꞌíjna xɨcájraꞌa jetze tiꞌitɨ́j tɨ púꞌeen tɨ rɨ́ꞌɨ tejámuaatáꞌasin sej si rɨ́ꞌɨ tiꞌitechée xáꞌaraꞌani ɨ́ Dios jemi. Aru caxu raamuáꞌa. Aꞌɨ́j pu hui jɨ́n ari rúꞌavaa sej si caí raaseíj. ");
INSERT INTO crnNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Puꞌuri tejaꞌuréꞌenejsin múꞌejmi jemi aꞌájna xɨcájraꞌan jetze mej jetzen amuaaténeꞌusiꞌiteꞌesin aꞌɨ́ɨme ɨ́ mej amuájchaꞌɨɨreꞌe. Aꞌɨ́ɨ mú hui raꞌatanájsin ɨ́ jaxuꞌu jetze meꞌɨ́jna jɨmeꞌe ɨ́ ɨnaamua mej ráꞌajtaahuacaꞌa. Majta amuaꞌiteánajsin. Majta nainjapua teꞌiteánaxɨꞌɨsin ɨ́ sej jetze huiráacɨꞌɨca. ");
INSERT INTO crnNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","’Majta, naíjmiꞌica mú hui aꞌantipuáꞌariteꞌe múꞌejmi, majta ɨ́ aꞌamuayaujmuaꞌa, ɨ́ mej meꞌuun aꞌuchéjme aꞌu tɨ jaxuꞌu jɨ́n tejeꞌeréꞌanamiꞌi. Nain mú huatéꞌuuna ɨ́ tetej tɨ rujapua ticaíjme, meꞌɨ́jna jɨmeꞌe sej hui caí ramuaꞌareerecaꞌa jaꞌanáj tɨ Dios huataseíjre múꞌejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Aj pu i aꞌuun aꞌuteájrupi u teyujtaꞌa. Tɨ́ꞌɨj i aꞌutéjche tɨ huaꞌirámuariteꞌen aꞌɨ́mej ɨ́ mej meꞌuun tíꞌituaá muáꞌayeꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze yee: “Ayee pu tíꞌivaɨreꞌe ɨ́ nechiꞌi mej mi meꞌuun huatéjniuuni ɨ́ Dios jemi.” Mɨ́ seajta múꞌeen, ayée xu hui raruure tɨ tíꞌivaɨreꞌe tɨ́j teástaꞌa aꞌu mej tzajtaꞌan éꞌeruꞌavaꞌataca ɨ́ nahuaꞌari. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nain xɨcaj tzajtaꞌa pu tihuáꞌamuaꞌatehuaꞌa ɨ́ teɨte u teyujtaꞌa. Majta aꞌɨ́ɨme ɨ́ mej tíꞌaijta u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze Moisés tɨ raꞌuyúꞌuxacaꞌa, majta ɨ́ mej jaítzeꞌe vivejméꞌen jɨ́n títetateí huáꞌa tzajtaꞌa ɨ́ teɨte, aꞌɨ́ɨ mú tíꞌiteseꞌecaꞌa ɨ́ ru tzajtaꞌa aꞌij mej yeꞌí huárɨni mej mi raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aru camu aꞌij tirájteu aꞌij mej yeꞌí huárɨni aꞌiné naímiꞌi ɨ́ teɨte, aꞌɨ́ɨ mú rɨ́ꞌɨ tiꞌijnamuajracaa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Aꞌájnáꞌɨmua pu ayén tiujuꞌurɨ́j. Aꞌuu pu tihuáꞌamuaꞌatejcaꞌa u teyujtaꞌa aꞌu tɨ eꞌeráyaujtaꞌa. Ajta pu huáꞌaꞌixaateꞌecaꞌa ɨ́ teɨte ɨ́ niuucari tɨ jɨ́n Dios huaꞌirátuaasin. Matɨ́ꞌɨj mi seica á eꞌiréꞌene, aꞌɨ́ɨme ɨ́ mej teyujtaꞌa tíꞌaijta, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa, majta ɨ́ huáꞌavaujsimuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ayee mú tiraataꞌixaa tɨjɨ́n: ―¿Tiꞌitáni jɨ́n petiꞌitéjvee pej pi piyen rɨcɨ? ¿Aꞌataani hui aꞌɨ́jna jɨ́n timuaꞌíjca? ");
INSERT INTO crnNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Aj pu i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Nee nu neajta tejámuaataꞌíhuaꞌura sej si seajta múꞌeen siyen tinaatáꞌixaateꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Aꞌɨ́jna tɨ jɨ́n huáꞌumuaɨꞌɨhuacaꞌa ɨ́ Juan teecan, ¿aꞌataani hui tiraꞌíjca aꞌɨ́jna? ¿Ni ɨ́ Dios caꞌɨ́n ɨ́ teɨte? ");
INSERT INTO crnNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Matɨ́ꞌɨj mi miyen tiꞌitiúrihuaꞌuriꞌi tɨjɨ́n: ―Tɨ́ puaꞌa tiyen tiraataꞌixaateꞌen yee Dios tɨ júteꞌe éꞌeseijreꞌe, aꞌɨ́ɨ pu tiraꞌíjca, aj pu xaa ayén titaatáꞌixaateꞌesin yee aꞌiné tej tij caí ráꞌatzaahuateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Naꞌari, tɨ puaꞌa hui tiyen raataxáj yee teteca mú tiraꞌíjca, aj mú mi teɨte taateátuꞌasixɨꞌɨsin tetej jɨmeꞌe, aꞌiné ayée pu tihuáꞌamitɨejteꞌe tɨ Juan aꞌɨ́ɨn púꞌeeneꞌe seɨ́j tɨ tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aꞌɨ́j mú jɨ́n miyen tiraataꞌixaa tɨjɨ́n: ―Catu ramuaꞌaree jaꞌatɨ tɨ jemin tiꞌitéveecaꞌa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ajta aꞌɨ́ɨn Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu neajta nee amuaatáꞌixaateꞌesin jaꞌatɨ nej jemin tiꞌitéjvee nej ni niyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ajta áꞌiyen, Jesús pu seɨ́j niuucari jɨ́n huaꞌutáꞌixa ɨ́ teɨte ayén tɨjɨ́n: ―Jaꞌatɨ pu nuꞌu hui jeíhua uuva huáhuii. Tɨꞌɨj jí, seica huatáꞌa ɨ́ teɨte mej meꞌuun tiuꞌumuárɨꞌen ɨ́ huastari tzajtaꞌa. Aj pu nuꞌu i áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ. Jéihua pu muꞌu éꞌetee. ");
INSERT INTO crnNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","’Tɨ́ꞌɨj aꞌájna tejaꞌuréꞌene matɨ́ꞌɨj puaꞌa rajuꞌuraca, seɨ́j pu nuꞌu u aꞌutaꞌítecaꞌa huáꞌa jemi ɨ́ tɨ huaꞌutániɨ́jte mej mi raatátuiireꞌen jeꞌicáca tɨ tiúꞌucɨɨrecaꞌa. Majta aꞌɨ́ɨme ɨ́ teɨte, aꞌɨ́ɨ mú nuꞌu raatéevajxɨ meꞌɨ́jna tɨ tíꞌivaɨreꞌe. Majta nuꞌu caí tiꞌitɨ́j raatáꞌa, ayée muꞌu tiraataꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","’Ajtahuaꞌa nuꞌu seɨ́j huataꞌítecaꞌa tɨ jemin tíꞌivaɨreꞌe. Majta aꞌɨ́ɨme tɨ huaꞌutániɨ́jte, majta mú nuꞌu raatéevajxɨ. Aꞌij mú puaꞌa ráaruu. Majta caí tiꞌitɨ́j raatáꞌa, ayée muꞌu nuꞌu tiraataꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Huaícaca jetze, aꞌɨ́ɨ pu nuꞌu hui seɨ́j ajtahuaꞌa huataꞌítecaꞌa. Majta nuꞌu meꞌɨ́n tɨ tihuaꞌutániɨjte, aꞌɨ́ɨ mú tiraapuaíj. Majta raaréꞌitecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Tɨ́ꞌɨqui nuꞌu ayén tiuꞌumuáꞌaj aꞌɨ́jna ɨ́ jaꞌatɨ tɨ áꞌareꞌaraꞌan púꞌeen ɨ́ chuej, tɨjɨ́n: “¿Aꞌiquí yeehui náarɨni inee? Niyauj nu hui huataꞌíti ɨ́ nej huápɨꞌɨ raxɨ́ꞌeveꞌe. Ayej neꞌase, aꞌɨ́ɨ mú xaa aráteseꞌesin meꞌɨ́jna.” ");
INSERT INTO crnNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","’Mɨ majta aꞌɨ́ɨme, matɨ́ꞌɨj nuꞌu raaseíj, aj mú mi tiuꞌutaúꞌixaa. Ayee mú tiraaxɨ́ꞌepɨꞌɨntare tɨjɨ́n: “Aꞌii pu yeehui aꞌɨ́ɨn púꞌeen ɨ́ tɨ tíꞌijcɨꞌɨti. Tichéꞌe raajéꞌica tɨ ij téjmi huácɨꞌɨti.” ");
INSERT INTO crnNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","’Aꞌɨ́j mú nuꞌu jɨ́n raaréꞌitecaꞌa. Matɨ́ꞌɨj nuꞌu mi raajéꞌica. ’¿Aꞌiné hui tejamuáꞌamitɨejteꞌe múꞌejmi? ¿Aꞌiquí huáꞌaruuren aꞌɨ́jna tɨ áꞌareꞌaraꞌan púꞌeen aꞌu tɨ uuva éꞌehuiitiꞌi? ");
INSERT INTO crnNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ayee nu tejáꞌamuaꞌixaateꞌe. Aꞌɨ́ɨ pu aꞌuun aꞌuréꞌenejsin. Ajta áꞌiyen, aꞌɨ́ɨn huáꞌacuiꞌini aꞌɨ́mej ɨ́ tɨ huaꞌutániɨ́jte. Aj pu i xaa seica huatapuaíjveꞌesin mej mi meꞌuun hui tejaꞌumuárɨꞌen. Matɨ́ꞌɨj miyen tiráanamuajriꞌi ɨ́ teɨte, ayée mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Chéꞌe caí jaꞌanáj ayén tíꞌirɨjca. ");
INSERT INTO crnNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Aj pu i Jesús huaꞌuseíirajraa. Tɨꞌɨj jí ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Naꞌari caí ayén tiꞌayajna aꞌij nej tejámuaatáꞌixaa, ¿aꞌiné ꞌeen jɨ́n ayén téꞌesiɨɨmuaꞌi ɨ́ yuꞌuxari jetze? Ayee pu, tɨjɨ́n: Aꞌɨ́jna ɨ́ tetej ɨ́ mej méjcaꞌi rúurɨe aꞌɨ́ɨme ɨ́ mej chiꞌij taꞌahuaca, ayée pu teꞌirájraa tɨ aꞌíin aꞌɨ́ɨn púꞌeen ɨ́ mej raꞌatéchajtza u esquiina aꞌu mej yéꞌejtaahua ɨ́ chiꞌij. ");
INSERT INTO crnNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jaꞌatɨ tɨ naꞌa tɨ puaꞌa seɨ́j ɨ́ jaꞌatɨ aꞌɨ́jna japua rájveti ɨ́ tetej ɨ́ mej meri raꞌatéjche u isquiina, aꞌɨ́ɨ pu huaténaꞌaxɨjsin nainjapua u ru jetze. Naꞌari, jaꞌatɨ tɨ naꞌa ɨ́ mej tíꞌimuarɨꞌe, tɨ puaꞌa seɨ́j japua rájveti aꞌɨ́jna ɨ́ tetej, aꞌɨ́ɨ pu tiraꞌiráxayeepeꞌesin. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌatacaꞌa ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌaijtacaꞌa u teyujtaꞌa, jeíhua mú tiuꞌumuáꞌaj aꞌij mej yeꞌí huárɨni mej mi caꞌanacan raatéeviꞌi, aꞌiné ayée mú tirúꞌumuaꞌareerecaꞌa tɨ huáꞌa jemi huatéeniu aꞌɨ́jna jɨmeꞌe ɨ́ niuucari tɨ raataxájtacaꞌa. Aru aꞌɨ́ɨme, aꞌɨ́ɨ mú huáꞌatziɨɨneꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jéihua mú ráꞌeeveꞌecaꞌa. Aꞌɨ́j mú jɨ́n seica huataꞌítecaꞌa ɨ́ mej miyen ruseíjratacaꞌa mej miyen tíꞌixaxaꞌa tzáahuatiꞌiraꞌa jɨmeꞌe. Ayee mú tíꞌijxeꞌeveꞌecaꞌa mej tiraataꞌíhuaꞌu tiꞌitɨ́j jɨmeꞌe tɨ i aꞌɨ́ɨn aꞌɨ́jna jɨ́n autéꞌɨtzen mej mi tiuꞌutátuiireꞌen ɨ́ tajtuhuan jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Majta aꞌɨ́ɨme ɨ́ mej ráꞌeeveꞌecaꞌa, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maeestru, teen tu ramuaꞌaree tɨjɨ́n pej piyen tíꞌixaxaꞌa tzáahuatiꞌiraꞌa jɨmeꞌe, pajta tihuáꞌamuaꞌate aꞌij tɨ tiraavíjteꞌe. Ayee pepuꞌu cheꞌatá huáꞌaruuren ɨ́ teɨte. Múꞌee pej tzáahuatiꞌiraꞌa jɨmeꞌe tihuáꞌamuaꞌate aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Ni qui xɨ́ꞌepɨꞌɨn tej tiyen tiuꞌunájchita aꞌɨ́jna jemi tɨ tíꞌitaꞌaijteꞌe, aꞌɨ́jna tɨ ayén ántehuaa tɨjɨ́n César? ");
INSERT INTO crnNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu rúꞌumuaꞌareerecaꞌa mej caí miyen tíꞌiraꞌihuaꞌuracaꞌa tzáahuatiꞌiraꞌa jɨmeꞌe. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Seɨj senaataseíjrateꞌe ɨ́ tumin. ¿Aꞌataani néerimeꞌaraꞌan pɨ́rɨcɨ tɨ jetzen acájvee? ¿Aꞌiné téꞌaxa tɨ jetzen éꞌeseijreꞌe? ¿Aꞌiné hui ántehuaa? ");
INSERT INTO crnNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Matɨ́ꞌɨj mi miyen tiuꞌutaniú tɨjɨ́n: ―Aꞌɨ́ɨ pu pɨ́rɨcɨ ɨ́ César. Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj siyen raatáꞌan seꞌɨ́jna ɨ́ César, tiꞌitɨ́j tɨ áꞌareꞌaraꞌan púꞌeen. Setáꞌaj seajta raatáꞌan ɨ́ Dios tiꞌitɨ́j tɨ áꞌareꞌaraꞌan púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Majta aꞌɨ́ɨme, camu aꞌij tirájteuveꞌecaꞌa aꞌij mej yeꞌí huárɨni mej raatémuaꞌitɨn meꞌɨ́jna jɨmeꞌe aꞌij tɨ aꞌɨ́ɨn tihuaꞌutáꞌixaa á jéjreꞌe huáꞌa tzajtaꞌa ɨ́ teɨte. Majta aꞌɨ́ɨme ɨ́ teɨte, naa mú rɨ́ꞌɨ tiraꞌutaseíj aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa. Aj mú mi raatapuáꞌajtacaꞌa mej tíꞌixajtacaꞌa aꞌɨ́ɨme ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Aꞌatzu áꞌateeviꞌica, seica mú eꞌiréꞌene. Aꞌɨ́ɨme mú pɨ́rɨcɨ ɨ́ saduceos. Ayee mú tíꞌixaxaꞌa aꞌɨ́ɨme yee camu chaꞌa huatarújsin ɨ́ mej meri huácuii. Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Maeestru, ayée pu raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan tɨ ayén téꞌeme itejmi jemi. Tɨ́ puaꞌa nuꞌu jaꞌatɨ tɨ neɨche, tɨ puaꞌa aꞌɨ́ɨn caí títɨꞌɨríjmuaꞌa huámɨꞌɨni, ruxeꞌeveꞌe nuꞌu tɨ aꞌɨ́ɨn ihuáareꞌaraꞌan raꞌancuréꞌeviꞌitɨn aꞌɨ́jna tɨ ratéviꞌitɨneꞌe ɨ́ tɨ huamɨ́ꞌɨ tɨ ij aꞌɨ́jna jetze meꞌecan tiyaúj áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","’Ayee pu hui jaꞌanáj tiujuꞌurɨ́j itejmi jemi. Ayee mú aráꞌaxcaa aꞌachú cumu aráhuaꞌapua ɨ́ teɨte ɨ́ mej ruꞌihuaamuaꞌatacaꞌa. Tɨꞌɨj jí aꞌɨ́ɨn tɨ vástaꞌa, aꞌɨ́ɨ pu huaténeꞌɨchecaꞌa. Ajta áꞌiyen huamɨ́ꞌɨ. Capu xɨ tiyaúuca. Ayee pu hui cheꞌatá naꞌa tiráaruu ɨ́ seɨ́j tɨ raꞌitéꞌasi. Muꞌuri iꞌi huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","’Ajta aꞌɨ́ɨn ɨ́ seɨ́j tɨ raꞌitéꞌasi, aꞌɨ́ɨ pu raꞌancuréꞌeviꞌitɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ raatéviꞌitɨneꞌe aꞌɨ́jna ihuáareꞌaraꞌan teecan. Muꞌuri iꞌi huaíca. ");
INSERT INTO crnNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ajtahuaꞌa seɨ́j tɨ raꞌitéꞌasi, aꞌɨ́ɨ pu ajta raꞌancuréꞌeviꞌitɨ. Ayee pu cheꞌatá naꞌa tihuáꞌuruu naíjmiꞌica ɨ́ mej aráhuaꞌapua, mej caí jetzen tiyaúj muáꞌaraa, naímiꞌi mú huácuii. ");
INSERT INTO crnNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ajta áꞌiyen, aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa pu huamɨ́ꞌɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","’Meꞌecui xaa, matɨ́ꞌɨj aꞌitácɨɨne huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite, ¿aꞌataani ɨ́raꞌaraꞌan puꞌéeneꞌe aꞌame?, aꞌiné naíjmiꞌi mú raꞌancuréꞌeviꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ teɨte ɨ́ mej íjii huáteemua, aꞌɨ́ɨ mú néjneꞌɨche, majta víviɨche. ");
INSERT INTO crnNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Majta aꞌɨ́ɨme tɨ ayén tihuaꞌuvíjteꞌe mej aꞌájna eꞌaráꞌasti mej aꞌitácɨɨne huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite, majta meꞌájna eꞌaráꞌasti aꞌájna xɨcájraꞌan jetze tɨ Dios nainjapua tiuꞌutaꞌaíjta, aꞌɨ́ɨ mú caí chaꞌa néjneꞌɨchen, camu majta víviɨchen. ");
INSERT INTO crnNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Camu majta chéꞌe cuiꞌini, aꞌiné ayée mú ꞌeen matɨ́j aꞌɨ́ɨme ɨ́ mej ta japua tíꞌivaɨreꞌe. Aꞌɨ́ɨ mú yaújmuaꞌameꞌen púꞌeen ɨ́ Dios aꞌiné muꞌuri huanéj huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ");
INSERT INTO crnNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","’Ajta aꞌɨ́ɨn ɨ́ Moisés, aꞌɨ́ɨ pu hui titaatáꞌixaa aꞌɨ́jna jɨmeꞌe tɨ́ꞌɨj raꞌuyúꞌuxacaꞌa aꞌij tɨ jaꞌanáj seɨ́j aꞌuteájtaa tuꞌupi tɨ ajtɨ́tɨꞌɨ. Aꞌɨ́j pu jɨ́n, Moisés ayén raatamuáꞌa ɨ́ tavástaraꞌa tɨjɨ́n: “Ɨ́ tɨ Diojraꞌan púꞌeen aꞌɨ́jna ɨ́ Abraham, ajta ayén cheꞌatá naꞌa Diojraꞌan púꞌeen aꞌɨ́jna ɨ́ Isaac, ajta Diojraꞌan púꞌeen ɨ́ Jacobo.” ");
INSERT INTO crnNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","’Moisés pu hui tihuaꞌutáꞌixaa cumu mej maúcheꞌe ruuricaa. Aꞌɨ́j pu jɨ́n, aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ huáꞌa Dios aꞌɨ́ɨme ɨ́ mej ruuri. Capu huáꞌa Dios púꞌeen aꞌɨ́ɨme ɨ́ mej mɨꞌɨchíjta muaateájturaa tɨ́j naꞌa rusén jɨmeꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Majta seica ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa, ayée mú tiuꞌutaniú tɨjɨ́n: ―Maeestru, xɨ́ꞌepɨꞌɨn pej tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tɨ́j naꞌa aꞌajnáꞌɨmua, capu chéꞌe jaꞌatɨ ahuaújcaꞌane tɨ tiꞌitɨ́j raataꞌíhuaꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ajta Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨmeꞌe miyen tíꞌixaxaꞌa meꞌɨ́jna jɨmeꞌe ɨ́ Cɨríistuꞌu Dios tɨ raꞌantíhuaꞌu yee yaujraꞌan púꞌeen ɨ́ David teecan? ");
INSERT INTO crnNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ajta aꞌɨ́ɨn ɨ́ David, ayée pu tiuꞌutaxájtacaꞌa aꞌɨ́jna jɨ́meꞌen tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze tɨ ayén ántehuaa tɨjɨ́n Chuiicari. Ayen tɨjɨ́n: Dios pu ayén tiraataꞌixaa ɨ́ nevástaraꞌa ɨ́ tɨ raꞌantíhuaꞌu tɨ jɨ́meꞌen yee: “Acáayeijxɨꞌɨ ɨpuari japua, íiye nerɨꞌɨríintaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Paúcheꞌe pej hui mej cájcatii ajta necaí huaꞌutémuaꞌitɨn ɨ́ mej muájchaꞌɨɨreꞌe.” ");
INSERT INTO crnNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","’Ajta aꞌɨ́ɨn ɨ́ David, aꞌɨ́ɨ pu hui ayén raatamuáꞌa aꞌɨ́jna tɨ Dios raꞌantíhuaꞌu tɨjɨ́n nevástaraꞌa. Tɨ́ puaꞌa ayén tiꞌayajna, ¿aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn Cɨríistuꞌu ayén aꞌɨ́ɨn púꞌeeneꞌe aꞌɨ́jna tɨ David jetze airaújneijte? Capu aꞌij tíꞌirɨꞌɨri tzɨ́teꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Majta teɨte tíꞌinamuajracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Ayen tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen, aꞌɨ́mej jemi ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa. Jéꞌecan pu huaꞌaráanajche mej tɨ́tɨꞌɨjméꞌen tiꞌitechéjméꞌe mé méꞌujujhuaꞌaneꞌen aꞌájna mej tejéꞌetuꞌaraca, majta aꞌɨ́ɨme ɨ́ teɨte, aꞌɨ́ɨ mú majta tihuaꞌaseíiraꞌa muáꞌayeꞌi. ’Ayee mú meꞌɨ́jna jɨ́n titeꞌujtzáahuateꞌe muáꞌajuꞌun aꞌɨ́ɨme ɨ́ puaarijse meꞌɨ́jna jɨmeꞌe mej veꞌecán jɨ́n títeetatéꞌete ɨ́ Dios jemi. Majta, ayée mú tíꞌijxeꞌeveꞌe mej meꞌuun aꞌujráꞌasen ɨ́ ɨpuari japua tɨ jaítzeꞌe ruxeꞌeveꞌe aꞌujna teyujtaꞌa, ajta huaꞌaráanajche mej mi á vejliꞌi aꞌujráꞌase jemin tɨ tihuáꞌamin matɨ́ꞌɨj tíꞌiyeste. ");
INSERT INTO crnNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","’Aꞌɨ́ɨ mú hui majta huáꞌariꞌiraca ɨ́ huáꞌachiꞌi aꞌɨ́mej ɨ́ ꞌuuca mej huataújseɨ́starecaꞌa. Ayee mú jɨ́n huarɨ́n, aj mú mi aꞌuun aꞌuteáruti u teyujtaꞌa. Matɨ́ꞌɨjtá mi aꞌateeviꞌi mú muáꞌajuꞌun mej téniuusimeꞌe muáꞌajuꞌun mej mi seica teɨte huaꞌuseíj. Majta meꞌɨ́n ɨ́ mej miyen ꞌeen, jeíhua mú huápɨꞌɨ rajpuaíitzi muáꞌajuꞌun. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Aj pu i Jesús antanéerajraa. Aꞌɨ́mej pu huaseíj ɨ́ mej chíjteaani púꞌeen. Aꞌuu mú tumin úꞌuseɨreꞌecaꞌa, tɨ ij aꞌuun tiuꞌutévaɨreꞌesin u teyujtaꞌa aꞌɨ́jna ɨ́ tumin. ");
INSERT INTO crnNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Aꞌɨ́ɨ pu ajta ꞌɨ́itaꞌa huaseíj tɨ caí aꞌij tíꞌijviicuaꞌi. Ajta aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu huaꞌapuaca ucáahuaꞌaxɨ ɨ́ tumin tɨ caí aꞌij tíꞌijnajche. ");
INSERT INTO crnNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Aj pu i Jesús ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, ayée pu tíꞌeen ɨ́ Dios jemi. Amɨ́jna mɨ ꞌɨ́itaꞌa, jaítzeꞌe pu ruꞌucáahuaꞌaxɨ mecaí naímiꞌi ɨ́ seica. ");
INSERT INTO crnNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","’Aꞌɨ́ɨme ɨ́ seica, naímiꞌi muꞌu hui miyen ruꞌucáahuaꞌaxɨ meꞌɨ́jna jɨmeꞌe tɨ avéꞌeturaa ɨ́ mej jeíhua tíꞌijchaꞌɨɨ. Aru amɨ́jna, capu aꞌij tíꞌijviicuaꞌi. Mɨ́ ajta amɨ́n, nain uꞌucáahuaꞌaxɨ aꞌɨ́jna ɨ́ tɨ jɨ́n huateújvaɨreꞌesin. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Majta seica miyen tiújꞌixaateꞌecaꞌa meꞌɨ́jna jɨmeꞌe tɨ naa seijreꞌecaꞌa ɨ́ teyuu, ajta ɨ́ tetej tɨ curéꞌeteꞌete nainjapua, ajta aꞌɨ́ɨn ɨ́ muaɨꞌɨvéjri ɨ́ mej teuhuaréꞌeviɨ tɨ naa tíꞌeen. Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ");
INSERT INTO crnNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Naíjmiꞌi tɨ́j naꞌa sej yen tíꞌiseij, aj pu tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌan mej jetzen nain huatéꞌuuna temuaꞌa naa. Capu chéꞌe seíireꞌe aꞌame jaxuꞌu jetze ɨ́ tetej tɨ rujapua ticaíjme. ");
INSERT INTO crnNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Maeestru, ¿aꞌanajqui ayén téꞌeme? ¿Tiꞌitájni jɨ́n téjmuaꞌareeren tɨ ari tɨ́muaꞌa ayén tejaꞌuréꞌenejsin? ");
INSERT INTO crnNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Rɨ́ꞌɨ xuꞌu múꞌeen tɨ ij caí jaꞌatɨ amuáacuanamua. Muꞌiitɨ́ mú uvéꞌenejsin neniúucajtzeꞌe. Ayee mú tejámuaatáꞌixaateꞌesin yee: “Nee nu yeehui neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu.” Majta miyen tiꞌixáata muáꞌajuꞌun tɨjɨ́n: “Puꞌuri hui tɨ́n tejaꞌuréꞌenejsin.” Caxu hui áꞌujujhuaꞌaneꞌen huáꞌa jamuan aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","’Setɨ́ꞌɨj siyen tiúꞌunamua tɨjɨ́n: “Muaateújneꞌusiꞌiteꞌesin á jáꞌahuaꞌa seica jamuan ɨ́ teɨte, majta seica meri autéhuijsin mej tiújneꞌusiꞌiteꞌen”, caxu tíꞌitziɨɨneꞌe. Ayee pu hui tiúꞌujxeꞌeveꞌe tɨ amuacaí ayén téꞌaraꞌani. Mɨ́ ajta caí capu xɨ caꞌanacan teꞌentipuáꞌari nainjapua. ");
INSERT INTO crnNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Seica mú teɨtejraꞌa, majtáhuaꞌa seica teɨtejraꞌa, aꞌɨ́ɨ mú naímiꞌi huateújneꞌusiꞌiteꞌesin. Majta ɨ́ mej seica chuéjraꞌa japua aꞌuchéjme, majtáhuaꞌa ɨ́ mej majta seɨ́j chuéjraꞌa japua aꞌuchéjme, aꞌɨ́ɨ mú naímiꞌi huateújneꞌusiꞌiteꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","’Puaꞌamecɨé pu huateújcaꞌatzɨjxɨꞌɨsin jeíhua huápɨꞌɨ ɨ́ chaanaca japua, ajta huatúuriꞌihua aꞌame. Ajta jeíhua pu tiuꞌucuíꞌiniꞌiraꞌa aꞌame. Ayee pu tiꞌitɨ́j rɨni tɨ tiúꞌutziɨɨniꞌireꞌe aꞌame. Ajta júteꞌe, tiꞌitɨ́j pu huataseíjreꞌesin tɨ huápɨꞌɨ ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Aru tɨ caí xɨ ayén tiúꞌurɨni, aꞌɨ́ɨ mú hui amuacaícan áꞌamuaviviꞌiran, majta aꞌij puaꞌa áꞌamuaruuren. Aꞌuu mú tiuꞌutátuiireꞌesin múꞌejmi u teyujtaꞌa naꞌari aꞌu mej amuaꞌiteáanan. Aꞌuu mú amuáꞌaviꞌitɨn aꞌɨ́mej jemi ɨ́ tajtúhuaani, majta aꞌɨ́mej jemi ɨ́ mej rey jɨ́n antiújmuaꞌaree. Ayee mú ꞌeen jɨ́n áꞌamuaruuren meꞌɨ́jna jɨmeꞌe sej naꞌaráꞌastijre ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ayee pu hui ajta teꞌiráame sej si siyen tihuaꞌutáꞌixaateꞌen aꞌij tɨ Dios amuáaruu múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","’Seajta múꞌeen, setáꞌaj siyen huárɨni. Caxu amuacaícan seꞌɨ́jna jɨ́n tiúꞌumuaꞌati aꞌij sej titeeteújnan, aꞌiné nee nu amuaatáꞌasin aꞌij sej tiuꞌutaxáj, seajta sej raayɨ́ꞌɨtɨhuaꞌan, sej si huaꞌutémuaꞌitɨn aꞌɨ́mej. Camu aꞌij tirájteuvée muáꞌajuꞌun aꞌij mej tejámuaatíte, ni camu huaꞌitzi jɨ́n amuaatémuaꞌitɨn. ");
INSERT INTO crnNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","’Majta aꞌɨ́ɨme ɨ́ ruvaújsimuaꞌa, majta ɨ́ áꞌamuaꞌihuaamuaꞌa, majta aꞌɨ́ɨme áꞌamuaneusimuaꞌa, majta áꞌamigustemuaꞌa, aꞌɨ́ɨ mú avíitzi jɨ́n tiuꞌutátuiireꞌesin múꞌejmi. Majta jeꞌicáca múꞌejmi cuiꞌini. ");
INSERT INTO crnNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Naíimiꞌi ɨ́ teɨte, aꞌɨ́ɨ mú amuajchaꞌɨ́ɨreꞌe muáꞌajuꞌun múꞌejmi meꞌɨ́jna jɨmeꞌe sej naꞌaráꞌastijre ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","’Camu aꞌatzu aꞌij áꞌamuaruuren tɨ puaꞌa caí Dios huaꞌutáꞌacareꞌen, sino aꞌɨ́ɨ pu Dios áꞌamuachaꞌɨ́j aꞌame tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Setáꞌaj hui huateújcaꞌanen ɨ́ ru tzajtaꞌa sej si teꞌutáviicuaꞌi. Tɨ́ puaꞌa siyen huárɨni, múꞌeen xu raamuáꞌitɨn sej si ruuri huateáturan ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Ayee xu ꞌeen jɨ́n ráamuaꞌaree tɨ ari tɨ́muaꞌa aꞌájna tejaꞌuréꞌenejsin jaꞌanáj mej puaꞌa tiuꞌutéꞌuuna u Jerusalén. Aꞌɨ́mej xu seijran mej antevéejmee muáꞌajuꞌun ɨ́ xantaaruꞌu aꞌujna u Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","’Majta aꞌɨ́ɨme ɨ́ mej Judea aꞌutéꞌuu, michéꞌe aꞌɨ́ɨme jíyeꞌitzi jɨ́n áꞌucɨɨne aꞌutɨ́ áꞌujɨ́rime. Majta aꞌɨ́ɨme ɨ́ mej Jerusalén aꞌutéꞌuu, michéꞌe aꞌɨ́ɨme huirácɨɨne á puaꞌacɨé u chajtaꞌana jetze. Majta aꞌɨ́ɨme ɨ́ mej ɨtzitá aꞌutéꞌuu, michéꞌe caí meꞌuun aꞌuteáruꞌipicheꞌen u chajtaꞌana jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","’Chéꞌe ayén téꞌaraꞌani aꞌiné puꞌuri hui tejaꞌuréꞌene aꞌájna xɨcájraꞌan tɨ jetzen araúrastejsin nain aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. Jéihua mú rajpuaíitzi muáꞌajuꞌun meꞌɨ́jna jɨmeꞌe tɨ Dios ayén puaíjtzi huaꞌutáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","’Jéꞌecan pu aꞌij puaꞌa huáꞌaruuren aꞌájna xɨcájraꞌan jetze aꞌɨ́ɨme ɨ́ ꞌuuca ɨ́ mej autájucájmee, ajta aꞌɨ́ɨme i ɨ́ mej mauj huáꞌatziꞌite ɨ́ ruyaujmuaꞌa. Jéihua mú hui huápɨꞌɨ rajpuaíitzi muáꞌajuꞌun aꞌɨ́ɨme ɨ́ mej Israél aꞌuchéjme. Jéꞌecan pu puaíjtzi huaꞌutáꞌasin ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","’Xantaaruꞌu mú jeíhua teɨte cuiꞌini ɨ́ tiuꞌujchún jɨmeꞌe. Majta muꞌiicáca mú áꞌaviꞌitɨn nainjapua ɨ́ chuej tɨ yen seijreꞌe íiyen chaanaca japua. Majta aꞌɨ́ɨme ɨ́ mej caí Israél éꞌemeꞌecan, aꞌɨ́ɨ mú ratéꞌuuna ɨ́ Jerusalén ajta naꞌa caí araúrasten aꞌájna xɨcájraꞌan mej jetzen tiuꞌutaꞌaíjta aꞌɨ́ɨme ɨ́ mej caí Israél éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ajta jeíhua pu tiuꞌutaseíjreꞌesin u júteꞌe ɨ́ xɨcaj jetze, ajta ɨ́ máxcɨraꞌi jetze, ajta xuꞌuraꞌave tzajtaꞌa. Ajta íiyen chaanaca japua, jeíhua pu tiújtaꞌahuaꞌa aꞌame á jaataꞌa jetze tɨ veꞌée. Jéꞌecan pu tɨꞌɨráana aꞌame. Aꞌɨ́j pu jɨ́n utévatziɨjsin ɨ́ huáꞌa tzajtaꞌa ɨ́ teɨte aꞌɨ́jna jɨmeꞌe mej tíꞌitziɨɨneꞌe. Capu aꞌij tihuáꞌamitɨejteꞌe aꞌame ");
INSERT INTO crnNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Jéihua mú huateújtɨmuaꞌira ɨ́ teteca meꞌɨ́jna jɨmeꞌe mej aꞌij puaꞌa titéꞌujmuaꞌate aꞌij tɨ huáꞌa japua yen tíꞌaiixa íiyen chaanaca japua, aꞌiné tiꞌitɨ́j tɨ́j naꞌa tɨ júteꞌe tejéꞌeseijreꞌe, aꞌɨ́ɨ pu hui huateújcaꞌatzɨjxɨꞌɨsin. ");
INSERT INTO crnNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","’Aꞌájna xɨcájraꞌan jetze, aꞌɨ́ɨ mú neseijran inee, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, nej aꞌicáaméꞌe naꞌame jaitɨri tzajtaꞌa. Huápɨꞌɨ pu naa seíireꞌe aꞌame mej mi naa rɨ́ꞌɨ tiraꞌutaseíj ɨ́ teɨte. Nemuárɨꞌeriꞌiraꞌa jɨ́n nu yé veꞌecánejsin. ");
INSERT INTO crnNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","’Tɨ́ꞌɨj autéjcheni tɨ ayén tiúꞌurɨni, rɨ́ꞌɨ xuꞌu huaújruuren. Setáꞌaj ajnéjneꞌerixɨꞌɨn aꞌiné puꞌuri hui vejliꞌi aꞌájna xɨcájraꞌan Dios tɨ jetzen amuaꞌirájtuaani. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ajta seɨ́j niuucari huaꞌutáꞌixa tɨjɨ́n: ―Casiꞌi, xaaseíj seꞌɨ́jna ɨ́ huaréj, ajta naíjmiꞌi ɨ́ cɨyej tɨ tíꞌiseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tɨ́ꞌɨj antineájxɨꞌɨn ɨ́ xamuaꞌiraꞌan, múꞌeen xu rujɨ́ɨmuaꞌa senaꞌa raseijran, seajta siyen ramuaꞌaréeren tɨ ari vejliꞌi pɨ́ tíꞌirɨcɨ ɨ́ víitaꞌari tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ayee pu cheꞌatá naꞌa tíꞌeen. Setɨ́ꞌɨj seri raaseíjra aꞌij nej tejámuaatáꞌixaa, seajta siyen ramuaꞌaréeren tɨ ari tɨ́muaꞌa aꞌájna pɨ́tejáꞌarɨcɨ tɨ Dios tiuꞌutaꞌaíjta. ");
INSERT INTO crnNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, aꞌɨ́mej jɨ́meꞌen íjii mej huáteemua, maúcheꞌe mú miyen seíireꞌe muáꞌajuꞌun tɨ́ꞌɨj naíjmiꞌi teꞌaraúrasten aꞌij nej neri tejámuaatáꞌixaa. Camu meꞌɨ́n anáatéꞌee mú áꞌapuaꞌaren. ");
INSERT INTO crnNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Aꞌɨ́ɨ pu xaa áꞌapuaꞌaren ɨ́ ta japua tɨ éꞌeseijreꞌe. Ajta ɨ́ chaanaca, aꞌɨ́ɨ pu ajta áꞌapuaꞌaren. Mɨ́ ajta hui aꞌɨ́ɨn ɨ́ niuucari nej raataxájtacaꞌa, capu jaꞌanáj áꞌapuaꞌaren. ");
INSERT INTO crnNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Rɨ́ꞌɨ xuꞌu, temuaꞌa naa, múꞌeen. Caxu aꞌij puaꞌa ruruure ɨ́ ru tzajtaꞌa seꞌɨ́jna jɨmeꞌe sej jeíhua rutáꞌaruaijveꞌe, ajta ayén tejamuaataꞌasée áꞌayeꞌi mɨ aꞌamua tzajtaꞌa tiꞌitɨ́j tɨ aꞌij puaꞌa ꞌeen. Rɨ́ꞌɨ xuꞌu seajta múꞌeen tɨ ij caí aꞌij puaꞌa amuáaruuren mɨ aꞌamua tzajtaꞌa seꞌɨ́jna jɨmeꞌe sej jeíhua huápɨꞌɨ aꞌij puaꞌa titéꞌujmuajte aꞌij tɨ yeꞌí téꞌeme. Naꞌari caí, aꞌájna xɨcájraꞌan jetze pu hui caꞌanacan múꞌejmi japuan rávaɨjtzi setɨ́ꞌɨj puaꞌa caí chéꞌe hui rachúꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Aꞌiné aꞌɨ́ɨ pu huáꞌa japua rávaɨjtzi naíjmiꞌica japua ɨ́ mej yen japuan huachéjme ɨ́ chaanaca. ");
INSERT INTO crnNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","’Tɨ́ꞌɨj pɨ́ naꞌa xu atanéjneꞌeri. Setáꞌaj siyen rahuaviira ɨ́ Dios jemi tɨ ij amuaatévaɨreꞌen tɨ ij caí tiꞌitɨ́j aꞌij amuáaruuren aꞌij tɨ tiꞌitɨ́j rɨni. Setáꞌaj seajta rahuaviira sej si siyen ne jemi seíireꞌe xáꞌaraꞌani, neetzi jemi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Nain tújcaꞌari tzajtaꞌa, aꞌɨ́ɨ pu tihuáꞌamuaꞌatehuaꞌa u teyujtaꞌa. Ajta tɨ́ꞌɨj pɨ́ naꞌa tɨ huaréꞌecɨeenacareꞌe, aꞌúu pu áꞌuyeꞌicaa áꞌayeꞌi aꞌujna jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Aꞌuu pu eꞌetáxaꞌiirihuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Majta aꞌɨ́ɨme ɨ́ teɨte, aꞌɨ́ɨ mú íiyeꞌe menaꞌa aꞌuréꞌenineicaꞌa jemin aꞌujna teyujtaꞌa mej mi ráanamua. ");
INSERT INTO crnNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Puꞌuri aꞌájna vejliꞌi pɨ́tíꞌirɨjcaa matɨ́ꞌɨj puaꞌa meꞌɨ́jna jɨ́n tíꞌiyeste ɨ́ mej pan cuaꞌaca ɨ́ mej caí levadura ranájchiteꞌe. Ayee mú majta miyen ratamuáꞌamua tɨjɨ́n Tɨ́ꞌɨj Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌayaujmuaꞌa ɨ́ mej anáatéꞌee muanúnuꞌihuacaꞌa, aꞌujna jáꞌahuaꞌa u Egipto. ");
INSERT INTO crnNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Majta aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa, jeíhua mú tíꞌimuaꞌajca aꞌij mej yeꞌí tiraajéꞌica ɨ́ Jesús. Caxɨ́ɨ mú aꞌij tirájteuveꞌe aꞌiné huáꞌatziɨɨneꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tɨꞌɨj jí, aꞌɨ́ɨn tiyaaruꞌu, ɨ́ tɨ ayén ántehuaa Satanás, aꞌɨ́ɨ pu tzajtaꞌan uteájrupi aꞌɨ́jna jetze ɨ́ Judás, ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Iscariotes. Aꞌɨ́ɨ pu ajta huáꞌa jetze ajtémeꞌecan ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. ");
INSERT INTO crnNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tɨꞌɨj jí aꞌɨ́ɨn Judás aꞌɨ́mej jemi aꞌuréꞌene aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, ajta ɨ́ mej tihuáꞌaijteꞌe aꞌɨ́mej ɨ́ mej tíꞌichaꞌɨɨ aꞌujna teyujtaꞌa. Ayee mú tiújꞌixaateꞌecaꞌa meꞌɨ́jna jɨmeꞌe aꞌij tɨ yeꞌí huárɨni aꞌɨ́jna ɨ́ Judás tɨ́ꞌij avíitzi jɨ́n tiuꞌutátuiireꞌen aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Majta aꞌɨ́ɨme, jéꞌecan mú huataújtemuaꞌave. Majta teꞌataújratziiriꞌi mej tumin raatáꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aꞌɨ́ɨ pu raꞌancuréꞌa ɨ́ huaꞌaniuuca. Aj pu i aꞌutéjche tɨ tiuꞌuchúꞌeveꞌen jaꞌanáj tɨ rɨꞌɨrí tɨ huaꞌutátuiireꞌen ɨ́ Jesús mej caí raseíirecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tɨ́ꞌɨj i aꞌájna tejaꞌuréꞌene ɨ́ xɨcájraꞌa mé jetzen racuaꞌaca ɨ́ pan mej caí levadura ranájchiteꞌe. Aꞌájna xɨcájraꞌan jetze, aꞌɨ́ɨ mú majta ramuaɨꞌɨvajta aꞌɨ́jna ɨ́ cáneꞌa ɨ́ mej jɨ́n raꞌutámuaꞌaree aꞌájna xɨcájraꞌan tɨ Dios jetzen tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌayaujmuaꞌa ɨ́ mej anáatéꞌee muanúnuꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Aj pu i Jesús huaꞌutaꞌítecaꞌa aꞌɨ́jna ɨ́ Pedro, ajta aꞌɨ́jna ɨ́ Juan mej u áꞌujuꞌun. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj áꞌujuꞌun sej si rɨ́ꞌɨ tejáꞌuruuren tej ti ráacuaꞌani teꞌɨ́jna ɨ́ tej jɨ́n raꞌutámuaꞌaree tɨ Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌayaujmuaꞌa ɨ́ mej anáatéꞌee muanúnuꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ajta aꞌɨ́ɨme, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné jetze piyen tíꞌijxeꞌeveꞌe tej rɨ́ꞌɨ tejáꞌuruuren? ");
INSERT INTO crnNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setɨ́ꞌɨj seꞌuun aꞌuteárute u chajtaꞌana, teáataꞌa pu amuaꞌantinájchi tɨ xaꞌari huátɨsin, jaj tɨ urajmuaa. Setáꞌaj cujtaꞌan u áꞌujuꞌun. Seajta jamuan aꞌuteáruti u chiꞌita aꞌu tɨ aꞌɨ́ɨn aráꞌaiixa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","’Setáꞌaj siyen tiraataꞌixaateꞌen aꞌɨ́jna tɨ aꞌánna éꞌeche yee: “Ayee pu tiꞌixa ɨ́ maestro, yee: ¿Aꞌuné jetze éꞌerɨꞌɨri tɨ tzajtaꞌan tiúꞌucuaꞌani ɨ́ tɨ jɨ́n raꞌutámuaꞌaree tɨ Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌayaujmuaꞌa ɨ́ mej anáatéꞌee muanúnuꞌihuacaꞌa? Aꞌɨ́j pu yee tiúꞌucuaꞌani aꞌɨ́mej jamuan ɨ́ tɨ huaꞌantíhuau.” ");
INSERT INTO crnNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","’Aꞌɨ́ɨ pu hui amuaataseíjrateꞌesin ɨ́ cuaartu, tɨ veꞌée, tɨ án ɨmuá áꞌujvee. Puꞌuri raꞌavéꞌejaj. Setáꞌaj seꞌújna rɨ́ꞌɨ teꞌuhuáruuren. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aj mú mi aꞌucɨ́j. Matɨ́ꞌɨj meꞌuun aꞌaráꞌa, ayée pu teꞌirájraa aꞌij tɨ tihuaꞌutáꞌixaa ɨ́ Jesús. Aꞌɨ́j mú jɨ́n rɨ́ꞌɨ tiúꞌuruu ɨ́ mej jɨ́n raꞌutámuaꞌaree aꞌij tɨ Dios tihuaꞌutáꞌuuniꞌiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tɨ́ꞌɨj tejaꞌuréꞌene aꞌatzaj mej puaꞌa racuaꞌani, naímiꞌi mú jaꞌutéeji á vejliꞌi meesa jetze, aꞌɨ́jna ɨ́ Jesús, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tɨ́ꞌɨj i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Jeíhua nu huápɨꞌɨ raxɨ́ꞌeveꞌecaꞌa nej múꞌejmi jamuan amuacaícan tiúꞌucuaꞌani, nej caí xɨ rajpuaíjtzi, tej ti naímiꞌi raꞌutámuaꞌaree teꞌɨ́jna jɨmeꞌe ɨ́ tɨ Dios tihuaꞌutáꞌuuniꞌiriꞌi ɨ́ huáꞌayaujmuaꞌa ɨ́ mej anáatéꞌee muanúnuꞌihuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","’Ayee nu tejáꞌamuaꞌixaateꞌe, canu hui chéꞌe jaꞌanáj ráacuaꞌani ɨ́ pan ajta caí nain araúrasten aꞌájna xɨcájraꞌa Dios tɨ jetzen nain jɨ́n huateúraꞌateꞌesin íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","18","Aj pu i rájtɨ ɨ́ taasa. Tɨ́ꞌɨj i rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios jemi, aj pu i huaꞌutajájni. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Yeꞌecui, setáꞌaj huaráꞌujaanten, aꞌiné ayée nu tejáꞌamuaꞌixaateꞌe nej caí chéꞌe jaꞌanáj raꞌantíꞌisin ɨ́ jáꞌaraꞌa tɨ uuva jetze airámɨꞌɨyecaꞌa, ajta caí yen huataseíjreꞌen jaꞌanáj tɨ Dios tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tɨ́ꞌɨj i raatiɨ́ꞌɨ ɨ́ pan. Tɨ́ꞌɨj i ajtahuaꞌa pu rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Aj pu i raꞌantítaaraxɨ ɨ́ pan. Aj pu i huaꞌutáꞌɨ́ꞌɨpɨꞌi. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu huataújmuaꞌa ɨ́ pan. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ netéviraꞌa ɨ́ nej jɨ́n áꞌamuajapua huaniú. Ayee xu huárɨni sej si raꞌutámuaꞌaree aꞌij nej huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Matɨ́ꞌɨj meri tiuꞌucuáꞌa, ayée pu cheꞌatá naꞌa huarɨ́j. Aꞌɨ́ɨ pu raꞌajjáj ɨ́ taasa. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌijna i taasa tzajtaꞌa tuꞌurájmuaa, ayée pu huataújmuaꞌa ɨ́ niuucari tɨ jɨ́meꞌen Dios jéjcua jɨ́n teꞌataújratziiriꞌi tɨ amuaꞌirájtuaani. Neajta inee, nuꞌuri raataseíjratacaꞌa tɨ ayén tiꞌayajna aꞌɨ́jna jɨmeꞌe ɨ́ nexuureꞌe nej raꞌiráxɨreꞌesin múꞌejmi jetze meꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ tɨ avíitzi jɨ́n tiuꞌutátuiireꞌesin ineetzi, aꞌɨ́ɨ pu hui ajta yé seijreꞌe neetzi jamuan iiyencuí meesa japua. ");
INSERT INTO crnNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ayee pu tíꞌineruuren ineetzi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte, aꞌij tɨ tiúꞌuxɨꞌepɨꞌɨntariꞌihuacaꞌa. Aru chéꞌe huataújxɨeemɨsteꞌen aꞌɨ́jna tɨ neetzi jɨ́meꞌen tiuꞌutátuiireꞌesin avíitzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú teꞌutéjhuii mej huataúrihuaꞌu meꞌɨ́jna jɨmeꞌe jaꞌatɨ tɨ aꞌɨ́ɨn púꞌeen tɨ ayén rɨni. ");
INSERT INTO crnNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Matɨ́ꞌɨj mi majta miyen autéjhuii mej huataúrihuaꞌu maújjaaxɨéeviꞌira meꞌɨ́jna jɨmeꞌe jaꞌatɨ tɨ nuꞌu jaítzeꞌe ruxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́ɨme ɨ́ mej rey jɨ́n títetéꞌuꞌupuꞌu huáꞌa tzajtaꞌa ɨ́ mej caí Israél éꞌemeꞌecan, aꞌɨ́ɨ mú caꞌanéjri jɨ́n tihuáꞌaijteꞌe. Ajta aꞌɨ́ɨme ɨ́ mej miyen tihuáꞌaijteꞌe, ayée mú tiúꞌujxaa yee rɨ́ꞌɨ mú tiꞌitexáꞌapuai. ");
INSERT INTO crnNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","’Aru múꞌeen, caxu siyen éeneꞌe xáꞌajuꞌun matɨ́j aꞌɨ́ɨme, sino ayée xuꞌu éeneꞌe xáꞌaraꞌani. Aꞌɨ́n ɨ́ jaꞌatɨ tɨ jaítzeꞌe ruxeꞌeveꞌe múꞌejmi jemi, chéꞌe aꞌɨ́ɨn ayén éeneꞌe áꞌaraꞌani tɨ́j tɨ jaítzeꞌe paꞌarɨꞌɨ. Ajta aꞌɨ́ɨn hui tɨ tíꞌaijta, chéꞌe ayén éeneꞌe tɨ́j aꞌɨ́jna tɨ tíꞌivaɨreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","’Casiꞌi, ¿aꞌataani jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee? ¿Ni aꞌɨ́jna tɨ á vejliꞌi aꞌuréꞌehuiixɨ aꞌutɨ́ meesa aꞌutéjvee, naꞌari aꞌɨ́jna ɨ́ tɨ tíꞌijmin? ¿Ni necaí neꞌɨ́n púꞌeen inee i nej jaítzeꞌe veꞌecán jɨ́n, i nej yé vejliꞌi huaréꞌecaꞌa íiye ɨ́ meesa aꞌutéjvee? Mɨ́ neajta inee, yé nu seijreꞌe aꞌamua jamuan nej ni tejamuaamín múꞌejmi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Seajta múꞌeen, múꞌeen xu seꞌɨ́ɨn púꞌeen ɨ́ sej tɨ́ꞌɨj pɨ́ naꞌa yé huatéꞌuu neetzi jemi ɨ́ nej rajpuaíjtzi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Neajta nu tejáꞌamuaꞌíjcateꞌe múꞌejmi, sej si tiuꞌutaꞌaíjta aꞌiné aꞌɨ́jna ɨ́ niyáꞌupua puꞌuri ayén tinaaꞌíjca ineetzi nej ni tiuꞌutaꞌaíjta. ");
INSERT INTO crnNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","’Ayee nu hui tejáꞌamuaꞌíjcateꞌe sej si siyen tiúꞌucuaꞌani, seajta huayéꞌen ɨ́ meesa aꞌutéjvee neetzi jamuan aꞌájna xɨcájraꞌan ne jetzen yé veꞌecánejsin nej ni tiuꞌutaꞌaíjta íiyen chaanaca japua. Múꞌeen xu aꞌujráꞌase japuan ɨ́ ɨpuari sej si huáꞌaxɨjteꞌen aꞌɨ́mej ɨ́ teɨtejraꞌa ɨ́ mej majta Israél jetze huanéj, ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Aj pu i aꞌɨ́jna ɨ́ Jesús ayén tiraataꞌixaa ɨ́ Pedro tɨjɨ́n: ―Simón, Simón, aꞌɨ́jna ɨ́ tiyaaruꞌu tɨ iꞌi Satanás, aꞌɨ́ɨ pu raatáhuaꞌu tɨ Dios raatáꞌan tɨ i tiuꞌutéseꞌen tɨ muaatémuaꞌitɨn pej pi mé núurɨeeni. ");
INSERT INTO crnNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","’Aru inee, ayée nu hui raatáhuaꞌu múꞌeetzi jɨmeꞌe ɨ́ Dios jemi pej pi caí autéꞌɨtzen peꞌɨ́jna jɨmeꞌe pej náꞌastijreꞌe ineetzi. Neajta niyen tíꞌimuaꞌaijteꞌe. Patɨ́ꞌɨj rɨ́ꞌɨ huarɨ́n muaꞌa tzajtaꞌa, patáꞌaj pajtáhuaꞌa naꞌaráꞌastijreꞌen. Ayee pej huárɨni. Patáꞌaj caꞌaníjraꞌa huaꞌutáꞌan aꞌihuáamuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, nuꞌuri niyen ahuáncaꞌane nej múꞌeetzi jamuan aiteánamiꞌihua naꞌari nej huámɨꞌɨni múꞌeetzi jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ajta Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Pedro, ayée nu hui tíꞌimuaꞌixaateꞌe, tɨ́ꞌɨj caí xɨ huajíjhua ɨ́ tecuaaraꞌi, huaíca pej piyen tinaꞌavéꞌavaata tɨjɨ́n capej nemuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Aj pu i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni caí tiꞌitɨ́j tejamuáꞌaturaateꞌecaꞌa netɨ́ꞌɨj amuaataꞌítecaꞌa sej siyen aꞌucɨ́jxɨꞌɨn, sej caí caꞌaní anpiín, seajta caí tiꞌitɨ́j anúꞌaꞌɨn, sej tumin tzajtaꞌan ucáꞌan, sej seajta caí ajtácaꞌacaiméꞌe? Ayee mú tiuꞌutaniú tɨjɨ́n: ―Capu tiꞌitɨ́j auteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ari íjii, tɨ puaꞌa piyen rájchaꞌɨɨ aꞌɨ́jna ɨ́ caꞌaní, patáꞌaj raꞌanpíin, naꞌari pajta peꞌɨ́jna ɨ́ pej tzajtaꞌan tumin ucáꞌan. Tɨ́ puaꞌa pecaí seɨ́j tíchaꞌɨɨ ɨ́ chun, xantaaruꞌu mej rájchaꞌɨɨ, ayée pej huárɨni. Patáꞌaj ráatuaani ɨ́ áꞌacɨɨxu pej pi seɨ́j chun huánanan ɨ́ tumin jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","’Ayee pu téꞌeyuꞌusiꞌi tɨjɨ́n: “Ayee pu hui tihuáꞌamitɨejteꞌecaꞌa tɨjɨ́n aꞌii pu aꞌɨ́ɨn púꞌeen seɨ́j tɨ aꞌij puaꞌa tíꞌitevij.” Ayee nu tejáꞌamuaꞌixaateꞌe tɨ ruxeꞌeveꞌe tɨ ayén cheꞌatá naꞌa teꞌaraúrasten ineetzi jemi. Jee xaa neꞌu, aꞌíjna tɨ ayén téꞌeyuꞌusiꞌi ineetzi jɨmeꞌe, puꞌuri tɨ́muaꞌa araúrastejsin. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú tiraataꞌixaa tɨjɨ́n: ―Casiꞌi, tavástaraꞌa, huaꞌapua pu yee tíꞌiseijreꞌe ɨ́ chun. Ayee pu i ayén tiuꞌutaniú tɨjɨ́n: ―Amɨ́ puꞌu tíꞌicɨꞌɨpe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Aj pu i huirájraa ɨ́ Jesús. Tɨ́ꞌɨj i aꞌuun aꞌaráꞌa aꞌájna aꞌu tɨ éꞌeꞌaseca ɨ́ jɨrí jetze tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Aceituunajemi. Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú majta aꞌucɨ́j jamuan. ");
INSERT INTO crnNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tɨ́ꞌɨj aꞌuun aꞌaráꞌa, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj siyen huatéjniuuni sej si caí autéꞌɨtzen tiꞌitɨ́j jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tɨ́ꞌɨj i aꞌuun huajaꞌuteájtuaa, aꞌatzu pu ɨmuá á aꞌureꞌenée aꞌachú cumu aꞌatzu ɨmuá pu eꞌeráavaꞌɨtzɨ ɨ́ tetej tɨ puaꞌa jaꞌatɨ raatárɨeni. Aꞌuu pu títunutacaꞌa. Tɨ́ꞌɨj i raatáhuauu ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ayen tɨjɨ́n: ―Niyáꞌupua, ayée nu tíꞌimuahuavii, tɨ puaꞌa muaꞌaráanajche pej naatáꞌan nej ni caí niyen tirajpuaíitzi náꞌaraꞌani. Aru chéꞌe ayén tiúꞌurɨni aꞌij pej múꞌee tíꞌijxeꞌeveꞌe. Chéꞌe hui caí ayén tejaꞌuréꞌenineicaꞌa aꞌij nej nee tíꞌijxeꞌeveꞌe. ―Ayee pu tiraatáhuaviiriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aj pu i seɨ́j jemin huataseíjre tɨ ta japua tíꞌivaɨreꞌe. Aꞌɨ́ɨ pu caꞌaníjraꞌa raatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ajta aꞌɨ́ɨn ɨ́ Jesús, jeíhua pu tíꞌiteseꞌecaꞌa. Aꞌɨ́j pu jɨ́n, jaítzeꞌe huatéeniu. Jéꞌecan pu taíxɨꞌecaꞌa. Ayee pu seijreꞌecaꞌa xɨee tɨ́j xúureꞌe á eꞌerájtzune á chuaataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tɨ́ꞌɨj i ájchee aꞌu tɨ eꞌeténiuusimeꞌe, tɨ́ꞌɨj i aꞌuréꞌene aꞌu mej aꞌij éꞌeneꞌe aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Muꞌuri cuꞌutzucaꞌa aꞌiné jeíhua mú cuaꞌanacaꞌa meꞌɨ́jna jɨmeꞌe mej ruxɨeemɨ́jteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné sej si cuꞌutzu? Xáꞌajhuiixɨꞌɨ, seajta huatéjniuuni tɨ ij caí tiꞌitɨ́j aꞌamua japua rájveti, sej si caí auteáturan ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Aúcheꞌe pu tixájtacaꞌa ɨ́ Jesús, matɨ́ꞌɨj jeíhua teɨte eꞌiréꞌene. Ajta aꞌɨ́ɨn tɨ ayén ántehuaa tɨjɨ́n Judás, tɨ ajta huáꞌa jetze ajtémeꞌecantacaꞌa ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase, aꞌɨ́ɨ pu amuacaí huaméꞌecaa. Aj pu i ajteáxɨɨrecaꞌa tɨ ij ruꞌitépɨꞌɨtzen aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Judás, ni piyen tinuꞌitépɨꞌɨtzeꞌesin pej pi neetzi jɨmeꞌe tiuꞌutátuiireꞌen ineetzi, i nej neajta huáꞌa jetze airáane ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Majta aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, matɨ́ꞌɨj raaseíj aꞌij tɨ tiꞌitɨ́ rɨjcaa, matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Tavastaraꞌa, ¿ni tiyen huárɨni tej huaꞌutévajxɨꞌɨn teꞌɨ́jna jɨmeꞌe ɨ́ tíꞌitachun? ");
INSERT INTO crnNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ajta seɨ́j tɨ Jesús jamuan áꞌucheꞌecaneꞌe, aꞌɨ́ɨ pu raꞌajtéevajxɨ aꞌɨ́jna tɨ ravaɨreꞌe aꞌɨ́jna tɨ tíꞌaijta u teyujtaꞌa. Raꞌajtasíjchecaꞌa ɨ́ naxairaꞌan, rurɨꞌɨríintaꞌan tɨ raꞌajtánaxaiicaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Aj pu i Jesús ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Caxu chéꞌe siyen raruure. Aj pu i Jesús raꞌajtamuárɨej aꞌɨ́jna ɨ́ naxairaꞌan jetze. Ajta tiráahuaa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Aj pu i Jesús ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌaijta u teyujtaꞌa, ajta ɨ́ mej tihuáꞌaijteꞌe ɨ́ mej tíꞌichaꞌɨɨ u teyujtaꞌa, ajta aꞌɨ́mej ɨ́ huáꞌa vaujsi, naíjmiꞌi matɨ́j menaꞌa mej jemin eꞌiréꞌene. Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Ni qui nahuaꞌari neꞌɨ́n púꞌeen sej si siyen múꞌeen mú aꞌuvéꞌejuꞌun sej chun tiuꞌɨ́ꞌɨsimeꞌen, seajta cɨyej? ");
INSERT INTO crnNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Tɨ́ꞌɨj pɨ́ naꞌa nain xɨcaj tzajtaꞌa, aꞌúu nu hui aꞌutevée náꞌayeꞌi aꞌu tɨ eꞌeráyaujtaꞌa u teyujtaꞌa múꞌejmi jemi. Seajta múꞌeen, caxu jaꞌanáj naateeviꞌi. Ari íjii xu xaa siyen neruure aꞌiné ayée pu tejamuaacɨ́ꞌɨ tɨ aꞌamua jetze huáraa aꞌɨ́jna tɨ tíꞌaijta tɨ́caꞌamisteꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Matɨ́ꞌɨj mi raatéeviꞌi. Aj mú mi yaꞌuvíꞌitɨ. Aꞌuu mú yaꞌuréꞌeneijte aꞌu tɨ éꞌeche aꞌɨ́jna tɨ nain jɨ́n antiújmuaꞌaree u teyujtaꞌa. Ajta aꞌɨ́ɨn Pedro, aꞌatzu pu ɨmuá ráꞌasijmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Matɨ́ꞌɨj mi aúunai aꞌájna jáꞌitaꞌa tɨ eꞌeráyaujtaꞌa u teyujtaꞌa. Aj mú mi atéráaseajraa. Ajta aꞌɨ́jna ɨ́ Pedro, aꞌɨ́ɨ pu huáꞌa jamuan aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Tɨ́ꞌɨj aꞌɨ́ɨn ꞌɨ́itaꞌa tɨ tíꞌivaɨreꞌe, aꞌɨ́ɨ pu raaseíj tɨ aꞌuun áꞌajcatii aꞌu tɨ áꞌataa. Tɨ́ꞌɨj temuaꞌa raaseíj, aj pu i ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Amɨ́jna mɨ teáataꞌa, amɨ́ɨ pu ajta jamuan áꞌucheꞌecaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ajta aꞌɨ́ɨn Pedro, ayée pu tiuꞌutéhuaꞌitacaꞌa tɨjɨ́n: ―ꞌƗ́itaꞌa, canu ramuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aꞌatzu aꞌateeviꞌi, ajtahuaꞌa seɨ́j raaseíj. Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna tɨjɨ́n: ―Múꞌee pe pajta huáꞌa jetze ajtémeꞌecan. Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiuꞌutaniú tɨjɨ́n: ―Hoombi xaa, canu xaa neꞌu. ");
INSERT INTO crnNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tɨ́ꞌɨj seɨ́j hora teuuméꞌeca, ajtahuaꞌa seɨ́j ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna tɨ amɨ́n aꞌɨ́ɨn púꞌeen seɨ́j tɨ Jesús jamuan áꞌucheꞌecaneꞌe, aꞌiné Galilea pu éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ajta aꞌɨ́ɨn ɨ́ Pedro, ayée pu tiuꞌutaniú tɨjɨ́n: ―Hoombi xaa, capu aꞌij tináꞌamitɨejteꞌe aꞌij pej tiꞌixa. Tɨ́ꞌɨj auj ayén tíꞌixajtacaꞌa, tɨ́ꞌɨj i huajíjhuacaꞌa ɨ́ tecuaaraꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ajta aꞌɨ́ɨn ɨ́ tavástaraꞌa, aꞌɨ́ɨ pu pɨ́ aꞌuréꞌeve. Aj pu i raꞌaráaseij aꞌɨ́jna ɨ́ Pedro. Ajta aꞌɨ́ɨ pu raꞌutámuaꞌareeriꞌi aꞌij tɨ tavástaraꞌa tiraataꞌixaa yee tɨ́ꞌɨj caí xɨ huajíjhuan ɨ́ tecuaaraꞌi, huaíca pej piyen tinaꞌavéꞌavaata tɨjɨ́n capej nemuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Tɨ́ꞌɨj i Pedro huirájraa á puaꞌacɨé. Aj pu i tiujyeínejraa huápɨꞌɨ. Aꞌij pu puaꞌa téꞌujmuaꞌajcaa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Majta aꞌɨ́ɨme ɨ́ mej rachaꞌɨɨcaꞌa, aꞌɨ́ɨ mú autéjhuii mej raꞌutéxɨeehuariꞌi, majta raatéevajxɨ meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Matɨ́ꞌɨj mi raꞌutajɨ́ꞌɨcɨe á jɨꞌɨseáaraꞌan jetze. Aj mú mi caꞌanéeri jɨ́n raataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Huataxáj yee aꞌatani muaatéevajxɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Majta jeíhua mú raꞌutéxɨeehuariꞌiriꞌi meꞌɨ́jna jɨmeꞌe tɨ aꞌij puaꞌa ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tɨ́ꞌɨj huateapuáꞌarecaꞌa, naímiꞌi mú tiújseɨj, ɨ́ huáꞌavaujsimuaꞌa, majta ɨ́ mej tíꞌaijta u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌataca ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa. Majta á yaꞌuvíꞌitɨ huáꞌa jemi ɨ́ rujuéesi. ");
INSERT INTO crnNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ayee mú tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj taatáꞌixaateꞌen tɨ puaꞌa múꞌee pe peꞌɨ́n púꞌeen ɨ́ tɨ Dios án muajaꞌujyéijtza ɨ́ ɨpuari japua nusu pecaí. Tɨ́ꞌɨj i Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Tɨ́ puaꞌa niyen tejámuaatáꞌixaateꞌen yee: “Nee nu neꞌɨ́n púꞌeen”, caxu múꞌeen náꞌantzaahuateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ajta tɨ puaꞌa niyen tejámuaataꞌíhuaꞌu yee: “¿Aꞌataani nej pɨ́rɨcɨ inee?, caxu múꞌeen, aꞌatzu huatániuusin.” ");
INSERT INTO crnNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","’Silu íjii tɨ yú aucaꞌitɨ́ aꞌame, inee nej neajta huáꞌa jetze airáane ɨ́ teɨte, aꞌúu nu hui aꞌujcaí naꞌame aꞌujna rɨꞌɨríintaꞌan ɨ́ Dios tɨ nain jɨ́n antiújmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Naímiꞌi mú miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni peꞌɨ́n púꞌeen yaujraꞌan ɨ́ Dios? Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Ayee pu tiꞌayajna, nee nu neꞌɨ́n púꞌeen aꞌij sej tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Matɨ́ꞌɨj mi miyen tiuꞌutaúꞌixaa tɨjɨ́n: ―¿Tiꞌitáani máàj aꞌij tetíꞌixeꞌeveꞌe ɨ́ tej jɨ́n jetzen teꞌujpuáꞌajteꞌen tiꞌitɨ́j jɨmeꞌe? Tuꞌuri neꞌu hui ráanamuajriꞌi aꞌij tɨ amɨ́n tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Matɨ́ꞌɨj mi naímiꞌi ájhuiixɨ ɨ́ mej meꞌuun eꞌetiújseɨreꞌecaꞌa. Matɨ́ꞌɨj mi yaꞌuvíꞌitɨ meꞌɨ́jna ɨ́ Jesús aꞌɨ́jna jemi ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Matɨ́ꞌɨj mi autéjhuii mej tiꞌitɨ́j jɨ́n jetzen teꞌujpuáꞌajteꞌen. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayee tu hui ráamuaꞌareeriꞌi tɨ amɨ́n caꞌaníjraꞌa huaꞌatáꞌaca ɨ́ teɨte mej mi huaténeꞌuseꞌen ɨ́ gobierno jemi. Capu huaꞌutáꞌasin aꞌɨ́jna ɨ́ Jesús mej tiraanájchiteꞌen ɨ́ César ɨ́ tɨ huáꞌajijveꞌe. Aꞌɨ́ɨ pu hui ajta ayén tihuáꞌixaateꞌe tɨjɨ́n amɨ́ɨ pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ Dios án yeꞌujyeíjtza ɨ́ ɨpuari japua, tɨ ajta rey jɨmeꞌe tiꞌitéjvee. ―Ayee mú tiuꞌutaxájtacaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tɨ́ꞌɨj i Pilato ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni peꞌɨ́n púꞌeen ɨ́ pej Rey jɨmeꞌe tiꞌitéjvee aꞌɨ́mej jemi ɨ́ mej Israél jetze ajtémeꞌecan? Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Jee, nee nu neꞌɨ́n púꞌeen ɨ́ pej raxa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Tɨ́ꞌɨj i Pilato ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌaijta u teyujtaꞌa, ajta aꞌɨ́mej ɨ́ mej meꞌuun ajteáxɨɨrecaꞌa tɨjɨ́n: ―Capu aꞌij náꞌamitɨejteꞌe tiꞌitɨ́j tɨ jɨ́n auteájturaa ɨ́ nej jɨ́n raꞌuxɨ́jteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Majta aꞌɨ́ɨme, caꞌanín mú jɨ́n miyen tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Jeíhua pu hui caꞌaníjraꞌa huaꞌatáꞌaca ɨ́ teɨte mej mi jáꞌitaꞌa aꞌutácɨɨne. Aꞌuu pu hui aꞌutéjche tɨ ayén rɨjca ájtepua Galilea. Ajta áꞌiyen, aꞌu tɨ hui veꞌeráane ayujna. ");
INSERT INTO crnNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ajta aꞌɨ́ɨn Pilato, tɨ́ꞌɨj ayén tiráanamuajriꞌi, ayée pu tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni qui aꞌɨ́ɨn Jesús aꞌúnna éꞌemeꞌecan u Galilea? ");
INSERT INTO crnNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tɨ́ꞌɨj Pilato ayén ráamuaꞌareeriꞌi tɨjɨ́n aꞌɨ́ɨ pu Heródes aꞌuun tejéꞌaijta aꞌu tɨ Jesús éꞌemeꞌecan, aj pu i huaꞌutaꞌaíj mej ráꞌanviꞌitɨn jemin aꞌɨ́jna ɨ́ Heródes, ɨ́ tɨ rey jɨ́n tiꞌitéjvee. Aꞌɨ́ɨ pu ajta aꞌajnáꞌɨmua aꞌuun aꞌutéveecaꞌa u Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ajta aꞌɨ́ɨn Heródes, jeíhua pu huataújtemuaꞌave tɨ́ꞌɨj raaseíj aꞌɨ́jna ɨ́ Jesús, aꞌiné puꞌuri aꞌateeviꞌi tɨ raseijramɨꞌɨcaꞌa. Ayee pu tíꞌijxeꞌeveꞌecaꞌa tɨ aꞌɨ́ɨn Jesús tiꞌitɨ́j jɨ́n ayén huárɨni tɨ huápɨꞌɨ ruxeꞌeveꞌe aꞌiné puꞌuri jeíhua ramuaꞌareerecaꞌa aꞌij tɨ aꞌɨ́ɨn tiꞌitɨ́j huáruu aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jéihua pu tíꞌiraꞌihuaꞌuracaꞌa. Ajta aꞌɨ́ɨn Jesús, capu aꞌatzu huataniú. ");
INSERT INTO crnNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Majta aꞌɨ́ɨme ɨ́ mej tíꞌaijta teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌimuaꞌata ɨ́ yuꞌuxari jetze, Moisés tɨ raꞌuyúꞌuxacaꞌa, aꞌúu mú vejliꞌi jemin huatéꞌuucaꞌa. Caꞌanín mú jɨ́n tíꞌijxajtziꞌiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ajta aꞌɨ́ɨn ɨ́ Heródes, majta aꞌɨ́ɨme ɨ́ xantaaruꞌu ɨ́ tɨ tihuáꞌaijteꞌe, matɨ́ꞌɨj miyen tíhuáꞌunamuajriꞌi, matɨ́ꞌɨj mi autéjhuii mej miyen tiraatzeɨ́jrajmuaꞌan. Majta raꞌutéxɨeehuariꞌiriꞌi meꞌɨ́jna ɨ́ Jesús. Matɨ́ꞌɨj mi cɨ́ɨxuri ruꞌucáachejte, huáꞌa cɨɨxu ɨ́ mej jamuan tíꞌaijta ɨ́ Heródes. Matɨ́ꞌɨj mi huaꞌutaꞌaíj mej mi majtáhuaꞌa ráꞌanviꞌitɨn ɨ́ Pilato jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aꞌájna xɨcájraꞌa jetze, aꞌɨ́ɨ mú ruꞌamiigustemuaꞌa muáꞌaraa aꞌɨ́jna ɨ́ Pilato, ajta aꞌɨ́jna ɨ́ Heródes. Tɨ́ꞌɨj caí xɨ ayén tiujuꞌurɨ́j, maúcheꞌe mú tiújchaꞌɨɨreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ajta aꞌɨ́ɨn Pilato huaꞌutajé aꞌɨ́mej ɨ́ mej tíꞌaijta u teyujtaꞌa, ajta aꞌɨ́mej ɨ́ mej tihuáꞌaijteꞌe ɨ́ teɨte, ajta aꞌɨ́mej ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Aj pu i ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setɨ́ꞌɨj siyen yee ruꞌuvéꞌeneijte semɨ́jna ineetzi jemi, ayée xu seꞌɨ́jna jɨ́n jetzen tíꞌijpuaꞌajteꞌe yee aꞌɨ́ɨ pu caꞌaníjraꞌa huaꞌatáꞌaca ɨ́ teɨte mej mi jáꞌitaꞌa aꞌutácɨɨne. Nuꞌuri tiraataꞌíhuaꞌuriꞌi, múꞌeen xu neseíiracaꞌa. Mɨ ajta, capu aꞌij náꞌamitɨejteꞌe tiꞌitɨ́j tɨ jɨ́n auteájturaa ɨ́ sej jɨ́n jetzen tíꞌijpuaꞌajteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Capu ajta aꞌij tiráꞌamitɨejteꞌe aꞌɨ́jna ɨ́ Heródes aꞌiné aꞌɨ́ɨ pu ajtahuaꞌa mú yeꞌutaꞌítecaꞌa itejmi jemi. ’Aꞌɨ́j xu hui jɨ́n seri ramuaꞌaree tɨ caí ayén tiraavíjteꞌe tɨ amɨ́n huámɨꞌɨni, aꞌiné capu tiꞌitɨ́j jɨ́n auteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Aꞌɨ́j nu hui jɨ́n inee puaíjtzi raatáꞌasin nemɨ́jna. Neajta ráꞌaxɨjteꞌen. Netɨ́ꞌɨj ni raateátuaasin nicu. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Pilato. ");
INSERT INTO crnNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ayee mú tíꞌijrɨꞌɨrejcaꞌa mej seɨ́j huatátuaani ɨ́ mej aiteánamiꞌi aꞌájna matɨ́ꞌɨj tíꞌiyestehuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Majta aꞌɨ́ɨme ɨ́ teɨte, naímiꞌi mú miyen titeetejíihuajraa tɨjɨ́n: ―Micheꞌe hui ráꞌanviꞌitɨn amɨ́jna mɨ teáataꞌa, pej pi Barrabás huatátuaani itejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Aꞌɨ́jna ɨ́ Barrabás, ayée mú ꞌéen jɨ́n raꞌiteáana aꞌiné caꞌaníjraꞌa pu huaꞌutáꞌa ɨ́ teɨte Jerusalén mej éꞌechejcaꞌa mej mi huateújneꞌusiꞌiteꞌen. Aꞌɨ́ɨ pu ajta aꞌɨ́ɨn púꞌeen seɨ́j ɨ́ tɨ tíꞌitecuiꞌica.) ");
INSERT INTO crnNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ajta aꞌɨ́ɨn Pilato, aúcheꞌe pu raxɨ́ꞌeveꞌecaꞌa tɨ raatátuaani aꞌɨ́jna ɨ́ Jesús. Aꞌɨ́j pu jɨ́n, ajtahuaꞌa pu ayén tihuáꞌajee tɨ ij ráamuaꞌaree aꞌij mej tíꞌijxeꞌeveꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Majta aꞌɨ́ɨme ɨ́ teɨte, majtáhuaꞌa mú miyen titeetejíihuajraa tɨjɨ́n: ―Patáꞌaj hui ráꞌutatan, patáꞌaj ráꞌutatan. ");
INSERT INTO crnNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Huaíca pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨmeꞌe? ¿Tiꞌitájni aꞌij huáruu tɨ aꞌij puaꞌa ꞌeen? Capu hui aꞌij náꞌamitɨejteꞌe tiꞌitɨ́j tɨ jɨ́n auteájturaa tɨ ij ayén raavíjteꞌe tɨ huámɨꞌɨni amɨ́jna. Aꞌɨ́j nu hui jɨ́n niyen nenaꞌa rɨni. Puaíjtzi nuꞌu raatáꞌasin. Neajta raateátuaasin. ");
INSERT INTO crnNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Majta aꞌɨ́ɨme ɨ́ teɨte máàj mú jaítzeꞌe caꞌanín jɨ́n huajíjhuacaꞌa. Majtahuaꞌa miyen tiraataꞌaíj tɨ ráꞌutatan. Matɨ́ꞌɨj mi tiuꞌumuáꞌitɨ meꞌɨ́jna jɨmeꞌe ɨ́ mej jeíhua tejíjhuajmeꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Aj pu i Pilato raaxɨ́ꞌepɨꞌɨntare tɨ ayén huarɨ́j aꞌij mej tíꞌijxeꞌeveꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tɨ́ꞌɨj i raatátuaa aꞌɨ́jna ɨ́ mej raꞌiteáana aꞌɨ́jna jɨmeꞌe tɨ caꞌaníjraꞌa huaꞌutáꞌa mej mi huateújneꞌusiꞌiteꞌen, tɨ ajta tíꞌitecuiꞌica. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ mej rájhuaviiriꞌi ɨ́ teɨte. Ajta aꞌɨ́ɨn ɨ́ Pilato, aꞌɨ́ɨ pu tiuꞌutátui ɨ́ Jesús mej mi miyen ráaruuren aꞌij mej tíꞌijxeꞌeveꞌecaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Matɨ́ꞌɨj mi yaꞌujáj. Aa mú yaꞌujáasimeꞌeca, matɨ́ꞌɨj seɨ́j huatéeviꞌi tɨ ayén ántehuaa tɨjɨ́n Simón tɨ Cirene éꞌemeꞌecan. Aꞌuu pu ꞌɨtzitá eꞌeráaráꞌa tɨ i aꞌuun Jerusalén aꞌuteárute. Matɨ́ꞌɨj mi ruꞌuhuatéechuite ɨ́ cúruu tɨ ij ráꞌanchueni. Meraataꞌaíj tɨ ráachuisimeꞌen cujtaꞌan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jéihua mú teɨte huajúꞌucaa huáꞌa cujtaꞌa. Muꞌiitɨ́ ɨ́ ꞌuuca, jeíhua mú ruxɨeemɨjteꞌecaꞌa, muaꞌantiujyeíneꞌe mú muaajúꞌucaa aꞌɨ́jna jemi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","29","Aj pu i Jesús pɨ́ aꞌuréꞌeve. Ayee pu tihuáꞌixaa tɨjɨ́n: ―Múꞌeen ꞌuuca, mɨ sej huáꞌayaujmuaꞌa púꞌeen aꞌɨ́ɨme ɨ́ mej Jerusalén aꞌuchéjme, caxu neetzi jɨ́n ruyeine, sino rujɨ́ɨmuaꞌa sehuaújyeinixɨꞌɨ múꞌejmi jɨmeꞌe, seajta seꞌɨ́mej jɨmeꞌe ɨ́ ruyaujmuaꞌa aꞌiné aj pu hui tejaꞌuréꞌenejsin aꞌɨ́jna ɨ́ xɨcájraꞌa sej jetzen siyen tiuꞌutaxájta yee: “Dios pu rɨ́ꞌɨ tihuaꞌutáꞌa aꞌɨ́mej ɨ́ mej caí jaꞌanáj tiyaúumuaꞌa muáꞌaraa, majta aꞌɨ́mej ɨ́ mej caí jaꞌanáj tɨꞌɨríi huáꞌa jetze huataseíjre, majta aꞌɨ́mej ɨ́ mej caí jaꞌanáj huáꞌutzii ɨ́ huáꞌayaujmuaꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","’Aꞌájna xɨcájraꞌan jetze, ayée mú hui rɨni ɨ́ teɨte. Aꞌɨ́ɨ mú tiraatáꞌixaateꞌesin ɨ́ jɨrí tɨjɨ́n: “Patáꞌaj téjmi japua rájveti.” Majta miyen cheꞌatá menaꞌa tiraatáꞌixaateꞌesin aꞌɨ́jna ɨ́ jɨrí áa tɨ huacaíjme tɨjɨ́n: “Patáꞌaj taatéꞌavaa.” ");
INSERT INTO crnNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","’Tɨ́ puaꞌa niyen tirajpuaíjtzi neꞌɨ́jna jɨmeꞌe nej caí tiꞌitɨ́j jɨ́n auteájturaa, ¿aꞌiné tejamuáꞌamitɨejteꞌe mej miyen tirajpuaíitzi muáꞌajuꞌun aꞌɨ́ɨme ɨ́ mej xaa tiꞌitɨ́j jɨ́n auteájturaa? Huápɨꞌɨ mú hui rajpuaíitzi muáꞌajuꞌun xaa neꞌu. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Majta seica mú huajájpuajmeꞌe mej mi meꞌuun huáꞌutatan jamuan ɨ́ Jesús. Aꞌɨ́ɨme ɨ́ mej huaꞌapua, aꞌɨ́ɨ mú aꞌɨ́ɨn púꞌeen ɨ́ mej xaa aꞌij puaꞌa tíꞌirujca. ");
INSERT INTO crnNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa aꞌu tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Mɨꞌɨchímuꞌuta. Aꞌɨ́ɨ mú ráꞌutatai jamuan ɨ́ mej aꞌij puaꞌa tíꞌirujca. Seɨ́j mú aúutatai rɨꞌɨríintaꞌan pújmeꞌen ɨ́ Jesús. Majta ɨ́ seɨj, aꞌɨ́ɨ mú ráꞌutatai úutataꞌan pújmeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tɨ́ꞌɨj i Jesús ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Niyáꞌupua, patáꞌaj hui tihuaꞌutáꞌuuniꞌi aꞌiné camu ramuaꞌaree aꞌij mej rɨcɨ. Majta aꞌɨ́ɨme ɨ́ xantaaruꞌu, aꞌɨ́ɨ mú huáhuajcacaꞌa mej tetej aꞌucáahuaꞌaxɨn mej mi ráamuaꞌaree jaꞌatɨ tɨ racɨꞌɨti ɨ́ cɨ́ɨxureꞌaraꞌan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Majta aꞌɨ́ɨme ɨ́ teɨte, aꞌúu mú aꞌutéꞌuu mejseíiracaꞌa. Majta aꞌɨ́ɨme ɨ́ mej tihuáꞌaijteꞌe, aꞌɨ́ɨ mú majta raꞌutéxɨeehuariꞌiriꞌi. Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Amɨ́ pu seica japua huaniú. Chéꞌe hui amɨ́n rujapua huániuuni, tɨ puaꞌa hui ayén tiꞌayajna tɨ amɨ́n aꞌɨ́ɨn púꞌeen Dios tɨ raꞌantíhuaꞌu, aꞌɨ́jna Dios tɨ án yaꞌujyeíjtza ɨ́ ɨpuari japua. ");
INSERT INTO crnNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Majta aꞌɨ́ɨme ɨ́ xantaaruꞌu muaꞌajteáxɨɨrecaꞌa, majta raꞌutéxɨeehuariꞌiriꞌi. Aꞌɨ́ɨ mú majta raatanéste ɨ́ viinu tɨ antzináj tɨ raꞌantiyéꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ayee mú tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa Rey jɨmeꞌe pej tiꞌitéveecaꞌa aꞌɨ́mej jemi ɨ́ mej Israél jetze ajtémeꞌecan, patáꞌaj á japua huániuuni. ");
INSERT INTO crnNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Majta taabla tiꞌitɨ́j mú aúutatai aꞌu tɨ áꞌujmuꞌu ɨ́ Jesús. Ayee pu téꞌeyuꞌusiꞌihuacaꞌa aꞌɨ́jna jetze ɨ́ taabla tɨjɨ́n: “Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ huaꞌaRey aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan”. ");
INSERT INTO crnNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ajta seɨ́j ɨ́ mej huaꞌapua ɨ́ tɨ aꞌij puaꞌa tíꞌijrɨꞌɨrejcaꞌa, aj pu áꞌatataihuacaꞌa. Aꞌɨ́ɨ pu ayén aꞌij puaꞌa tiraataxájtacaꞌa. Ayen tɨjɨ́n: ―¿Ni pecaí peꞌɨ́n púꞌeen aꞌɨ́jna tɨ Dios án muaꞌujyeíjtza ɨ́ ɨpuari japua? Patáꞌaj á japua huániuuni, pajta téjmi japua. ");
INSERT INTO crnNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ajta ɨ́ seɨj tɨ aꞌij puaꞌa tíꞌijrɨꞌɨrejcaꞌa, tɨ ajta áꞌatataihuacaꞌa, aꞌɨ́ɨ pu raꞌajtéꞌaxɨ tɨjɨ́n: ―¿Ni hui pecaí ráꞌateseꞌe ɨ́ Dios? Casiꞌi, ayée pej cheꞌatá penaꞌa tirajpuaíitzi tɨ́j amɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ayee pu hui tiraavíjteꞌe tej tiyen tirajpuaíjtzi aꞌiné puꞌuri taacɨ́ꞌɨ aꞌij tɨ tiraavíjteꞌe aꞌɨ́jna jɨmeꞌe aꞌij tej tiꞌitɨ́j huáruu. Ajta amɨ́n, capu tiꞌitɨ́j jɨ́n auteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aj pu i ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Jesús, patáꞌaj naꞌutámuaꞌaree aꞌájna xɨcáaraꞌan pej jetzen autéchesin pej tiuꞌutaꞌaíjta. ");
INSERT INTO crnNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ajta aꞌɨ́ɨn ɨ́ Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―Ayee nu hui tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, íjii, múꞌee pe peꞌuun aꞌutevée puaꞌamé neetzi jamuan aꞌu tɨ Dios rɨ́ꞌɨ timuaatáꞌasin. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Tɨ́ꞌɨj ari teuuméꞌeca aꞌatzaj tacuarixpua, aj pu i nainjapua huateátɨcaꞌarecaꞌa ɨ́ chuej japua. Ayee pu áꞌatee aꞌachú cumu huaíca hora tɨ ayén ꞌeeneꞌe, aꞌiné aꞌɨ́jna xɨcaj aꞌumɨ́ꞌɨ. Capu i chéꞌe huáneeriꞌicɨcaa. Ajta aꞌɨ́ɨn ɨ́ cɨ́ɨxuri tɨ itzíjhua, tɨ ajta aꞌuun aꞌutaviviɨ́jmeꞌecaa u teyujtaꞌa, aꞌɨ́ɨ pu jáꞌitaꞌa acasiújtzaꞌanixɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Caꞌanín pu jɨ́n huajíjhuacaꞌa aꞌɨ́jna ɨ́ Jesús. Ayee pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Mɨ́ pej niyáꞌupua, múꞌeetzi nu huatátuiireꞌesin ɨ́ nexɨejniuꞌuca. Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj pu i raatapuáꞌajtacaꞌa tɨ tíyeeyeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ajta aꞌɨ́ɨn ɨ́ xantaaruꞌu, tɨ anxɨ́te tíꞌaijta, tɨ́ꞌɨj raaseíj aꞌij tɨ huarɨ́j, aj pu i rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Ajta ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Aꞌɨ́ɨ pu rɨ́ꞌɨ tíꞌitevistacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Majta aꞌɨ́ɨme ɨ́ teɨte ɨ́ mej ajteáxɨɨrecaꞌa meꞌújna mej mi tiúꞌumuaꞌariiveꞌen, matɨ́ꞌɨj raaseíj aꞌij tɨ tiꞌitɨ́ huarɨ́j, aꞌɨ́ɨ mú anteújtuꞌasixɨ án rútaviitzeꞌe meꞌɨ́jna jɨmeꞌe mej huataújxɨeemɨste. Majta aꞌucɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Majta aꞌɨ́ɨme ɨ́ mej ramuaꞌajcaa, majta aꞌɨ́ɨme ɨ́ ꞌuuca ɨ́ mej eꞌeráacɨ jamuan aꞌujna u Galilea, aꞌɨ́ɨ mú aꞌɨmuá aꞌutéꞌuu mej seijracaꞌa aꞌij tɨ tiꞌitɨ́ rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Meenti seɨ́j aꞌuun jéꞌeseijreꞌecaꞌa tɨ ayén ántehuaa tɨjɨ́n José. Aꞌii pu aꞌɨ́ɨn púꞌeen seɨ́j tɨ huáꞌa jetze ajtémeꞌecan ɨ́ huáꞌa jueesi ɨ́ mej huaícate japuan tamuáamuataꞌa mej aráꞌase. Rɨ́ꞌɨ pu tíꞌitevistacaꞌa aꞌɨ́jna. Capu tiꞌitɨ́j jɨ́n auteájturaa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ajta aꞌɨ́ɨn, capu raꞌaránajchecaꞌa aꞌij mej tiraaxɨ́ꞌepɨꞌɨntare, capu ajta rɨ́ꞌɨ raatáꞌa aꞌij mej huarɨ́j ɨ́ seica ɨ́ jueesi. Aꞌuu pu éꞌemeꞌecan aꞌɨ́jna ɨ́ José, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Arimatea, tɨ ajta aꞌuun huatacáꞌa u Judea. Ajta aꞌɨ́ɨn José, aꞌɨ́ɨ pu rachúꞌeveꞌecaꞌa jaꞌanáj xɨcáaraꞌan jetze Dios tɨ tiuꞌutaꞌaíjta íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tɨ́ꞌɨj i aꞌuun áꞌume ɨ́ Pilato jemi. Ayee pu tiraatáhuaviiriꞌi tɨ aꞌɨ́ɨn Pilato raatátuiireꞌen ɨ́ Jesús tɨ mɨꞌɨchi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tɨꞌɨj jí raꞌacájtɨ ɨ́ cúruu jetze ɨ́ téviraꞌa. Aj pu i saavana jɨ́n racáꞌijcatacaꞌa. Tɨꞌɨj jí aꞌuun aꞌuteájrupi aꞌu tɨ aúucun. Tɨꞌɨj jí yenuꞌuhuaréꞌetee aꞌu mej mauchén yauucú ɨ́ jaij. Caxɨ́ɨ mú jaꞌanáj jaꞌatɨ meꞌuun utétuaraꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Puꞌuri aꞌájna pɨ́tíꞌirɨjcaa aꞌájna xɨcájraꞌa mej jetzen rɨ́ꞌɨ ruruuren. Ajta puꞌuri tɨ́n tejaꞌuréꞌenejsimeꞌe aꞌájna xɨcájraꞌan mej jetzen ruseꞌupi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Majta aꞌɨ́ɨme ɨ́ ꞌuuca, ɨ́ mej meꞌuun eꞌeráacɨ u Galilea jamuan ɨ́ Jesús, aꞌɨ́ɨ mú cujtaꞌan huajúꞌucaa aꞌɨ́jna ɨ́ José. Matɨ́ꞌɨj mi raaseíj aꞌu tɨ aúucun, majta aꞌu tɨ yáꞌuruu ɨ́ mɨꞌɨchi. ");
INSERT INTO crnNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Matɨ́ꞌɨj mi aꞌucɨ́ ɨ́ ruche. Aj mú mi rɨ́ꞌɨ ráaruu ɨ́ tuꞌupi tɨ naa teáarɨ́ꞌe, majta ɨ́ mej jɨ́n racápɨtijra. Majta áꞌiyen huaújseꞌupe aꞌájna xɨcájraꞌan jetze aꞌij tɨ tiúꞌujxeꞌeveꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tɨ́ꞌɨjta aꞌájna tejaꞌuréꞌene ɨ́ tújcaꞌari taꞌamuájca i itɨeeri jetze. Iíyeꞌe muꞌu u áꞌujuꞌun meꞌɨ́jna ɨ́ ꞌuuca mej tejáꞌutɨɨ ɨ́ mej rɨ́ꞌɨ tiúꞌuruu ɨ́ tuꞌupi tɨ naa teáarɨ́ꞌe. Matɨ́ꞌɨj mi u áꞌujuꞌun aꞌu tɨ aúucun. ");
INSERT INTO crnNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Matɨ́ꞌɨj mi meꞌuun aꞌaráꞌa. Aj mú mi raaseíj aꞌujna tɨ aúucun tɨ puaꞌa ari teꞌentácuuniꞌi. Ajta aꞌɨ́ɨn ɨ́ tetej ɨ́ mej raꞌitéjmua, puꞌuri jaꞌatɨ u yéꞌenxɨɨracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Matɨ́ꞌɨj mi aꞌuun aꞌuteájrupi aꞌu tɨ aúucun. Aru camu ráateu ɨ́ téviraꞌan ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Majta mauj meꞌɨ́jna jɨ́n tíꞌimuaꞌajca aꞌij tɨ tiꞌitɨ́ huarɨ́j aꞌɨ́jna jɨmeꞌe ɨ́ mɨꞌɨchi, jíyeꞌitzi jɨ́n mú huaꞌapua huataseíjre ɨ́ teteca aꞌɨ́mej jemi ɨ́ ꞌuuca. Ayee mú cuaiínaviꞌin tiꞌitéchejcaꞌa. Ayee pu tiꞌitemastájyeꞌicaa cumu mej témaxcavaꞌaraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jéꞌecan mú tiuꞌutátziɨn ɨ́ ꞌuuca. Aꞌɨ́j mú jɨ́n títunutaxɨ, majta aicaújtuuxɨ. Majta aꞌɨ́ɨme ɨ́ teteca, ayée mú tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné sej si ꞌeen jɨ́n siyen rahuauhuau huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite seɨ́j tɨ ari ruuri? ");
INSERT INTO crnNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Capu hui yeꞌe jáꞌahuaꞌa, aꞌiné puꞌuri ajtahuaꞌa huatarúj. ¿Ni hui secaí ramuaꞌaree aꞌij tɨ tejámuaatáꞌixaa tɨ́ꞌɨj auj aꞌutéveecaꞌa múꞌejmi jemi aꞌujna u Galilea yee tɨ ayén tiúꞌujxeꞌeveꞌe mej tiuꞌutátuiireꞌen aꞌɨ́jna tɨ huáꞌa jetze airáane ɨ́ teɨte huáꞌa jemi ɨ́ mej aꞌij puaꞌa titetiújchaꞌɨɨ mej mi ráꞌutatan? Ajta yee huaíca xɨcaj tzajtaꞌa pu ajtahuaꞌa nuꞌu huatarújsin. ―Aꞌɨ́ɨ mú teteca miyen tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Majta aꞌɨ́ɨme ɨ́ ꞌuuca, aj mú mi raꞌutámuaꞌareeriꞌi aꞌij tɨ tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Matɨ́ꞌɨj mi huiráacɨ aꞌu tɨ aúucun. Matɨ́ꞌɨj mi aꞌucɨ́j ruche. Aj mú huaꞌutáꞌixa aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan seɨ́j aráꞌase, ajta ɨ́ seica. Nain mú huaꞌutáꞌixa aꞌij mej tiꞌitɨ́j tiuꞌuséij. ");
INSERT INTO crnNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Aꞌɨ́ɨme ɨ́ ꞌuuca, aꞌɨ́ɨ mú aꞌɨ́ɨn púꞌeen, ɨ́ María, Magdala tɨ éꞌemeꞌecan, ajta aꞌɨ́ɨn ɨ́ Juana, ajtahuaꞌa seɨ́j ɨ́ María tɨ náànajraꞌan púꞌeen aꞌɨ́jna ɨ́ Jacobo, majta seica ɨ́ ꞌuuca. Aꞌɨ́ɨ mú miyen tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej Jesús huaꞌantíhuau. ");
INSERT INTO crnNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mɨ́ ajta caí aꞌɨ́ɨme, camu huáꞌantzaahua ɨ́ ꞌuuca aꞌiné capu aꞌij tihuáꞌamitɨejteꞌecaꞌa aꞌij mej tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ajta aꞌɨ́ɨn Pedro, aꞌɨ́ɨ pu ájchee Tɨꞌɨj jí aꞌutɨéechejraa aꞌájna aꞌu tɨ aúucun. Tɨ́ꞌɨj i aꞌuteájrupi. Tɨꞌɨj jí aicaújtutzi, tɨ́ꞌij cɨ́ɨxuri tiuꞌuséij. Aa pu rujɨ́ɨmuaꞌa tíꞌijpiicaꞌa á chuaataꞌa. Tɨꞌɨj jí áꞌuraa. Jéihua pu tíꞌimuaꞌajca ɨ́ ru tzajtaꞌa aꞌij tɨ tiꞌitɨ́ huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Aꞌájna xɨcájraꞌa jetze, mé huaꞌapua ɨ́ mej huáꞌa jetze ajtémeꞌecan aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe, aꞌúu mú aujúꞌucaa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Emaús. Aꞌatzu pu aꞌɨmuá pɨ́tejáꞌarɨcɨ aꞌujna u Jerusalén, aꞌachú cumu tamuáamuataꞌa kilómetros. ");
INSERT INTO crnNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ayee mú tiuꞌuxájtajmeꞌe nain aꞌij tɨ tiꞌitɨ́j huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Maúcheꞌe mú tiuꞌuxáatajmeꞌeca, majta tiꞌihuaúrihuaurájmeꞌe rujɨ́ɨmuaꞌa, tɨ́ꞌɨj aꞌɨ́ɨn Jesús ajteáxɨɨrecaꞌa tɨ ꞌij huáꞌa jamuan huaméꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aru capu huaꞌutáꞌa mej ráamuaꞌati. ");
INSERT INTO crnNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tɨ́ꞌɨj i Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni aꞌij setiúꞌurixaateꞌe siyen huajúꞌun? Matɨ́ꞌɨj mi huatéhuiixɨ, muaꞌicaujtutájmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ajta seɨ́j tɨ ayén ántehuaa tɨjɨ́n Cleofas, aꞌɨ́ɨ pu ayén tiuꞌutaniú tɨjɨ́n: ―¿Ni pecaí ramuaꞌaree aꞌij tɨ tiꞌitɨ́ huarɨ́j íjii itejmi jemi? ¿Ni pecaí múꞌee peꞌɨ́n púꞌeen ɨ́ pej huayéꞌi penaꞌa pej caí tiꞌitɨ́j muaꞌaree aꞌij tɨ tiꞌitɨ́ taruure itejmi? ");
INSERT INTO crnNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitáani aꞌij huarɨ́j? Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Aꞌɨ́jna jɨmeꞌe ɨ́ Jesús, Nazarét tɨ éꞌemeꞌecan. Aꞌɨ́ɨ pu hui tíꞌixaxaꞌataꞌa ɨ́ rumuárɨꞌeriꞌireꞌaraꞌan jɨmeꞌe ɨ́ Dios jetze meꞌecan. Ajta jeíhua pu ayén tiúꞌuruu tɨ huápɨꞌɨ ruxeꞌeveꞌe, mejseíiracaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Majta aꞌɨ́ɨme ɨ́ mej tíꞌaijta u teyujtaꞌa, majta aꞌɨ́ɨme ɨ́ mej tíꞌitaꞌaijteꞌe, aꞌɨ́ɨ mú hui Jesús tiuꞌutátui mej mi tiuꞌutáꞌan mej raajéꞌica. Matɨ́ꞌɨj mi ráꞌutatai. ");
INSERT INTO crnNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","’Mɨ teajta iteen, ayée tu hui tíꞌijxeꞌeveꞌecaꞌa tɨ aꞌɨ́ɨn puꞌéeneꞌe áꞌameꞌencheꞌe tɨ tuꞌirájtuaani itejmi i tej Israél jetze ajtémeꞌecan. Puꞌuri huaíca xɨcaj tejauume ɨ́ mej ráꞌutatai. ");
INSERT INTO crnNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","’Majta seica juuca ɨ́ mej téjmi jetze ajtémeꞌecan, jeíhua mú aꞌij puaꞌa teꞌutaseíjra. Iíyeꞌe mú u aꞌatanéj aꞌu mej yeꞌaváꞌana meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Aru camu ráateu ɨ́ mɨꞌɨchi. Matɨ́ꞌɨj mi huaréꞌacɨ. Aj mú mi taataꞌixaa tɨjɨ́n seica mú huataseíjre aꞌɨ́mej jemi. Aꞌɨ́ɨ mú nuꞌu meꞌɨ́n púꞌeen ɨ́ mej ta japua tíꞌivaɨreꞌe. Ayee mú eeriꞌi tihuaꞌutáꞌixaa tɨ nuꞌu ari ajtahuaꞌa huatarúj aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Majta seica ɨ́ mej ta jamuan áꞌujujhuaꞌan, aꞌɨ́ɨ mú majta u aꞌatanéj aꞌu mej yeꞌaváꞌana. Ayee pu éeneꞌe aꞌij mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ ꞌuuca. Aru camu hui áꞌa yaꞌuseíj meꞌɨ́jna ɨ́ Jesús. ―Ayee mú tiraataꞌixaa aꞌɨ́ɨme ɨ́ mej huaꞌapua. ");
INSERT INTO crnNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ajta aꞌɨ́ɨn, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌij xu puaꞌa titéꞌujmuajte múꞌeen. Caxu aꞌij tirájteuve mɨ ru tzajtaꞌa sej si caꞌanacan tiráꞌantzaahuateꞌen nain tɨ́j naꞌa aꞌij mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","’¿Ni caí ayén tiúꞌujxeꞌeveꞌecaꞌa tɨ ij amuacaí ayén tirajpuaíitzi áꞌaraꞌani aꞌɨ́jna ɨ́ tɨ ajta Dios aꞌán yaꞌujyeíjtza ɨ́ ɨpuari japua, tɨ ij áꞌiyen teꞌenteárute aꞌɨ́jna jɨmeꞌe tɨ tiuꞌutaꞌaíjta íiyen chaanaca japua, ajta u ta japua, ajta nainjapua? ");
INSERT INTO crnNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aj pu i ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús temuaꞌa naa nain tɨ́j naꞌa tɨ téꞌeyuꞌusiꞌihuacaꞌa ɨ́ yuꞌuxari jetze aꞌɨ́jna jɨmeꞌe, tɨ́j naꞌa tɨ aꞌɨ́ɨn raꞌuyúꞌuxacaꞌa aꞌɨ́jna ɨ́ Moisés teecan, ajta matɨ́j menaꞌa ɨ́ mej tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Matɨ́ꞌɨj meri á vejliꞌi aujúꞌucaa aꞌájna chajtaꞌa aꞌu mej aráꞌaiixa, aúcheꞌe pu huaméꞌecaa aꞌɨ́jna ɨ́ Jesús, ayée pu cumu mú pu áꞌayee aꞌuméꞌe aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ajta aꞌɨ́ɨme, jeíhua mú caꞌaníjraꞌa raatáꞌa tɨ aꞌuun huateáturan. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj yé huateáturan téjmi jemi, aꞌiné puꞌuri téchuijxari, ajta ari tɨ́n tétɨcaꞌari. Tɨ́ꞌɨj i aꞌuun aꞌuteájrupi tɨ ij huáꞌa jamuan aꞌuun aꞌuteáturan. ");
INSERT INTO crnNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tɨ́ꞌɨj i Jesús ayén huarɨ́j tɨ́ꞌɨj aꞌɨ́ɨn aúucaꞌatii huáꞌa jamuan á vejliꞌi meesa jetze. Tɨ́ꞌɨj i raatiɨ́ꞌɨpɨi ɨ́ pan, ajta rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Aj pu i raꞌantítaaraxɨ ɨ́ pan. Tɨ́ꞌɨj i aꞌutéjche tɨ huaꞌutaꞌɨ́ꞌɨpɨꞌiteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jɨ́meꞌen puꞌu huaꞌutáꞌɨ́ꞌɨpɨꞌi, aj mú mi raamuáꞌa. Aj pu i eꞌehuaújpuaꞌarixɨ mejseíiracaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Matɨ́ꞌɨj mi miyen tiꞌitiúrihuaꞌuriꞌi tɨjɨ́n: ―¿Ni caí úꞌutzunajcaꞌa ɨ́ taxɨejniuꞌuca ɨ́ ta tzajtaꞌa, ajta caꞌaníjraꞌa yú huataseíjre u ta tzajtaꞌa tɨ́ꞌɨj aꞌɨ́ɨn tiuꞌuxájtajmeꞌe ta jamuan ɨ́ juye jetze, tɨ ayén tíꞌitaꞌixaateꞌecaa aꞌij tɨ huataújmuaꞌa ɨ́ tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze? ");
INSERT INTO crnNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Matɨ́ꞌɨj mi ájhuiixɨ. Caꞌanacan mú huaréꞌacɨ u Jerusalén. Aꞌuu mú huáꞌuteu aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan seɨ́j mej aráꞌase, majta ɨ́ seica ɨ́ mej huáꞌa jamuan áꞌujujhuaꞌaneꞌe. Naímiꞌi mú tiújseɨj meꞌújna. ");
INSERT INTO crnNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Majta meꞌɨ́jna ɨ́ mej meꞌuun aꞌutéꞌuucaꞌa u Jerusalén, ayée mú tihuaꞌutáꞌixaa ɨ́ mej huaꞌapua tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna. Tavástaraꞌa pu ajtahuaꞌa aꞌitáraa huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. Ajta huataseíjre jemin aꞌɨ́jna ɨ́ Simón. ");
INSERT INTO crnNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Majta aꞌɨ́ɨme ɨ́ mej huaꞌapua, aꞌɨ́ɨ mú tihuaꞌutáꞌixaa aꞌij tɨ tiꞌitɨ́ huarɨ́j matɨ́ꞌɨj meꞌuun aujúꞌucaa ɨ́ juye jetze, ajta aꞌij mej yeꞌí tiraamuáꞌa tɨ́ꞌɨj aꞌɨ́ɨn raꞌantítaaraxɨ ɨ́ pan. ");
INSERT INTO crnNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Maúcheꞌe mú tiꞌixáatacaꞌa meꞌɨ́jna jɨmeꞌe tɨ́ꞌɨj aꞌɨ́ɨn Jesús huataseíjre huáꞌa jemi. Aꞌuu pu jáꞌitaꞌa huatéechaxɨ. Aj pu i ayén tihuaꞌutateújte tɨjɨ́n: ―Chéꞌe huatéepuaꞌare ɨ́ aꞌamua tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jéꞌecan mú huajɨ́jxɨcaꞌa. Majta tiuꞌutátziɨn aꞌiné ayée pu huáꞌaseijrateꞌecaa. Cu xɨee mej cu mɨ́ꞌɨchi seijra. ");
INSERT INTO crnNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―¿Aꞌiné ꞌeen jɨ́n aꞌij puaꞌa amuaatáꞌa? ¿Aꞌiné sej si caí xɨ téꞌatzaahuateꞌe? ");
INSERT INTO crnNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Casiꞌi, i nemuajcaꞌa jetze, ajta i neꞌɨ́ɨca jetze. Nee nu neꞌɨ́n púꞌeen. Setáꞌaj naꞌajtamuárɨꞌen sej si siyen raaseíj. Seɨ́j tɨ mɨꞌɨchi, capu ayén nexɨ́ꞌej tiꞌitéhuaꞌiraꞌa, capu ajta ayén nexɨ́ꞌej tiꞌitéjcari. Xuꞌuri neseij nej xaa téhuaꞌiraꞌa, neajta téjcari. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tɨ́ꞌɨj ayén tihuaꞌutáꞌixaa, aj pu i ayén tihuaꞌutaseíjra ɨ́ rumuájcaꞌa jetze, ajta ruꞌɨ́ɨca jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Majta aꞌɨ́ɨme, camu xɨ ráꞌantzaahuate aꞌiné jeíhua mú aꞌij puaꞌa yáꞌuseijracaꞌa, majta rútemuaꞌaveꞌecaꞌa. Aj pu i ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni secaí tiꞌitɨ́j tíchaꞌɨɨ ɨ́ nej ráacuaꞌani? ");
INSERT INTO crnNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Matɨ́ꞌɨj mi seɨ́j raatáꞌa ɨ́ huaꞌí tɨ huáꞌijchiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tɨ́ꞌɨj i raꞌancuréꞌechui. Aj pu i ráacua mejseíiracaꞌa aꞌɨ́ɨme. ");
INSERT INTO crnNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejámuaatáꞌixaa netɨ́ꞌɨj aꞌamua jemi huácatii tɨ ayén ruxeꞌeveꞌecaꞌa tɨ nain jɨ́n teꞌaraúrasten aꞌij tɨ teꞌuyúꞌuxacaꞌa neetzi jɨmeꞌe aꞌɨ́jna ɨ́ Moisés, majta aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa, ajta jetzen ɨ́ tihuáꞌachuiica. ");
INSERT INTO crnNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aj pu i huaꞌutáꞌa mej mi yaúꞌitɨée muáꞌaraꞌani aꞌij tɨ téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze. ");
INSERT INTO crnNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ayee pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu téꞌeyuꞌusiꞌi ɨ́ yuꞌuxari jetze nej nuꞌu niyen tirajpuaíitzi náꞌaraꞌani inee, i nej neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu tɨ Dios án nejaꞌujyeíjtza ɨ́ ɨpuari japua. Ajta nuꞌu huaíca xɨcaj tzajtaꞌa nu neajtahuaꞌa aitáraꞌani huáꞌa tzajtaꞌa ɨ́ mɨꞌɨchite. ");
INSERT INTO crnNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","’Majta nuꞌu, nainjapua tihuaꞌutáꞌixaateꞌesin neniúucajtzeꞌe mej mi seɨcɨé tiúꞌumuaꞌati ɨ́ Dios jemi tɨ ij aꞌɨ́ɨn tihuaꞌutáꞌuuniꞌi. Maꞌutéjhuijsin nuꞌu mej miyen tihuaꞌutáꞌixaateꞌen íiye mej Jerusalén aꞌuchéjme, majta méyee ɨ́ mej aꞌɨmuá antachéejmee, majta méyee ɨ́ mej seɨj chuéjraꞌa japua huachéjme, tɨ́j naꞌa ɨ́ tɨ yen seijreꞌe íiyen chaanaca japua nainjapua. ");
INSERT INTO crnNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","’Múꞌeen xu tihuaꞌutáꞌixaateꞌesin aꞌij sej seri seꞌɨ́jna jɨ́n tiuꞌuséij. ");
INSERT INTO crnNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nee nu u yaꞌutaꞌíti múꞌejmi jemi aꞌɨ́jna tɨ niyáꞌupua jɨ́n teꞌataújratziiriꞌi. Seajta múꞌeen, setáꞌaj siyen yen huatéꞌen íiyen chajtaꞌa ajta naꞌa caí huateáturan múꞌejmi jemi aꞌɨ́jna tɨ júteꞌe eꞌicánejsin. Aꞌɨ́j xu jetzen araújcaꞌanejsin. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tɨ́ꞌɨj i aꞌɨ́jna ɨ́ Jesús huajaꞌuvíꞌitɨ u jáꞌahuaꞌa u Betania. Tɨ́ꞌɨj i ajméijcaꞌataxɨ. Aj pu i rɨ́ꞌɨ tihuaꞌutáꞌa ɨ́ huáꞌa tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Tɨ́ꞌɨj auj rɨ́ꞌɨ tíhuaꞌutáꞌasimeꞌeca, aꞌúu pu huajaꞌuhuáꞌaxɨ. Aj pu i júteꞌe tíraa. ");
INSERT INTO crnNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Majta aꞌɨ́ɨme, aꞌúu mú raateánajchecaꞌa. Jéihua mú huataújtemuaꞌave. Matɨ́ꞌɨj mi aꞌucɨ́j u Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Tɨ́ꞌɨj pɨ́ naꞌa, mú meꞌuun aꞌutéꞌuucaꞌa u teyujtaꞌa mej mi rɨ́ꞌɨ tiraatáꞌan ɨ́ Dios.");
INSERT INTO crnNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ajmíꞌɨmua pu seijreꞌecaꞌa aꞌɨ́jna ɨ́ tɨ ɨ́ niuucari. Ajta, aꞌɨ́jna ɨ́ niuucari, aꞌɨ́ɨ pu seijreꞌecaꞌa ɨ́ Dios jemi. Ajta aꞌɨ́ɨ pu Dios púꞌeeneꞌe aꞌɨ́jna ɨ́ niuucari. ");
INSERT INTO crnNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aꞌɨ́ɨ pu ꞌajmíꞌɨmua seijreꞌecaꞌa ɨ́ Dios jemi tɨ́ꞌɨj caí xɨ méꞌe jáꞌahuaꞌacaꞌa ɨ́ chaanaca. ");
INSERT INTO crnNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nain tɨ́j naꞌa tɨ tíꞌiseijreꞌe, aꞌɨ́jna niuucari jetze pu ayén tiuꞌutaseíjre. Aꞌɨ́ɨ pu ɨ́ Dios, ajta aꞌɨ́jna ɨ́ niuucari, aꞌɨ́ɨ mú naíjmiꞌi tiúꞌutaahuacaꞌa tɨ́j puaꞌamé yen tíꞌiseijreꞌe. Ajta, capu tiꞌitɨ́j ayén tiꞌiseíireꞌe áꞌameꞌencheꞌe tɨ puaꞌa caí aꞌɨ́ɨn niuucari ayén raatétaahuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tɨ́j naꞌa ꞌajmíꞌɨmua tɨ yú eꞌiréꞌene, aꞌɨ́j pu jetze airámeꞌecan aꞌɨ́jna tɨ iꞌirúuri rusén jɨmeꞌe. Ajta aꞌɨ́j pu jɨ́n ayén tiúꞌuneeriꞌicɨcaꞌa huáꞌa tzajtaꞌa ɨ́ teɨte aꞌɨ́jna jɨmeꞌe tɨ jɨ́n iꞌirúuri mej mi miyen tiráamuaꞌaree aꞌij tɨ ꞌeen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ajta aꞌɨ́jna tej tiyen teajta ratamuáꞌamua tɨjɨ́n tatzari, aꞌɨ́ɨ pu huanéeriꞌicɨ́ jáꞌaraa aꞌɨ́mej tzajtaꞌa ɨ́ teɨte ɨ́ mej áꞌujujhuaꞌaneꞌe tɨ́caꞌamisteꞌe. Majta aꞌɨ́ɨme ɨ́ mej miyen tɨ́caꞌamisteꞌe áꞌujujhuaꞌaneꞌe, camu raayɨ́ꞌɨtɨhuaꞌa mej raꞌujéꞌica ɨ́ tatzari tɨ huáꞌa tzajtaꞌa huáneeriꞌicɨcaa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Seɨ́j pu ayén u aꞌuvéꞌemej tɨ Dios ayén yaꞌutaꞌítecaꞌa. Ayee pu ántehuaacaꞌa tɨjɨ́n Juan. ");
INSERT INTO crnNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ayee pu ꞌeen jɨ́n u aꞌuvéꞌemej tɨ ij ayén aꞌɨ́jna jɨ́n teꞌanxájta aꞌij tɨ ari tíꞌijmuaꞌareerecaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ tɨ iꞌi tatzari, mej mi naímiꞌi miyen téꞌantzaahuateꞌen aꞌij tɨ aꞌɨ́ɨn ayén tihuáꞌixaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ajta aꞌɨ́jna ɨ́ Juan, capu aꞌɨ́ɨn púꞌeeneꞌe ɨ́ tatzari sino ayée puꞌu ꞌeen jɨ́n aꞌuvéꞌemej tɨ ij aꞌɨ́jna jɨ́n tihuaꞌutáꞌixaateꞌen aꞌɨ́jna jetze meꞌecan aꞌɨ́jna ɨ́ tatzari. ");
INSERT INTO crnNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ajta aꞌɨ́ɨn tɨ tzáahuatiꞌiraꞌa jɨ́n tatzari púꞌeen, tɨ ajta huanéeriꞌicɨ́ áꞌayeꞌi huáꞌa tzajtaꞌa ɨ́ teɨte, aꞌachú mej puaꞌamé yen seijreꞌe, aꞌɨ́ɨ pu mú aꞌuvéꞌemeꞌecaꞌa íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Aꞌɨ́ɨ pu ayén huateájturaa íiyen chaanaca japua. Ajta, aꞌɨ́ɨ pu nain tiúꞌutaahuacaꞌa tɨ́j naꞌa tɨ yen chaanaca japuan tíꞌiseijreꞌe. Mɨ́ majta meꞌɨ́n, ɨ́ mej yen huachéejmeꞌecaa íiyen chaanaca japua, camu raamuáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aꞌɨ́ɨ pu mú aꞌuvéꞌemeꞌecaꞌa, ajta aꞌɨ́ɨme jemi ɨ́ ruteɨ́testemuaꞌa huateájturaa. Majta aꞌɨ́ɨme, camu xaa raꞌancuréꞌeviꞌitɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mɨ́ majta, seica mú xaa raꞌancuréꞌeviꞌitɨ aꞌɨ́ɨme ɨ́ teɨtestemuaꞌameꞌen. Ajta aꞌɨ́ɨn, ayej tihuaꞌutáꞌa aꞌɨ́mej ɨ́ mej ráꞌastijre tɨ ꞌij ayén tihuáꞌucɨꞌɨti mej mi yaújmuaꞌameꞌen puꞌéeneꞌe muáꞌaraꞌani ɨ́ Dios, aꞌachú mej puaꞌaméca. ");
INSERT INTO crnNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Majta aꞌɨ́ɨme, camu miyen teteca jetze airámeꞌecan meꞌɨ́jna jɨmeꞌe tɨ teáataꞌa ayén tíꞌijxeꞌeveꞌecaꞌa. Camu aꞌatzu xaa neꞌu, sino ayée muꞌu meꞌɨ́jna jetze ajtémeꞌecan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ajta aꞌɨ́ɨn ɨ́ niuucari aꞌɨ́ɨ pu ayén huateújtevistacaꞌa. Aꞌɨ́ɨ pu ajta itejmi jemi huateájturaa. Teen tu teajta tiyen raaseíj teꞌɨ́jna ɨ́ tɨ jɨ́n rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Teen tu raaseíj ɨ́ tɨ jɨ́n Dios rɨ́ꞌɨ tiuꞌutáꞌa aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨ naꞌa caj tíꞌiyaujraꞌan ɨ́ Dios. Aꞌɨ́ɨ pu éꞌemeꞌecan ɨ́ ruyáꞌupua jemi. Nain pu jɨ́n rɨ́ꞌɨ titájchaꞌɨɨcaꞌa ruxɨ́ꞌeviꞌiraꞌa jɨmeꞌe. Ajta, nain pu ayén tzáahuatiꞌiraꞌa jɨ́n tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ajta aꞌɨ́ɨn ɨ́ Juan, ayée pu aꞌɨ́jna jɨ́n tiuꞌutaxájtacaꞌa, ayén tiꞌixáata tɨjɨ́n: ―Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ nej jɨ́n neri tejamuáꞌixaa yee aꞌɨ́jna tɨ yeꞌevéꞌeme nee cujtaꞌa, jaítzeꞌe pu veꞌecán jɨ́n tiꞌitéjvee necaí inee, aꞌiné aꞌɨ́ɨ pu amuacaí seijreꞌecaꞌa necaí inee. ―Ayee pu tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Naíjmiꞌi iteen, tuꞌuri tiyen teꞌɨ́jna jɨ́n raꞌancuréꞌa teꞌɨ́jna jɨmeꞌe ɨ́ tɨ nain jɨ́n rɨ́ꞌɨ naa titatáꞌaca. Ruxɨ́ꞌeviꞌiraꞌa pu jɨ́n rɨ́ꞌɨ titatáꞌaca tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aꞌiné ayée puꞌu, aꞌɨ́jna ɨ́ niuucari ɨ́ mej jɨ́n tíꞌaijta, Dios pu ayén raateájtuaa ɨ́ Moisés jemi. Dios pu ajta ayén tiraꞌíjca aꞌɨ́jna ɨ́ Jesús, tɨ ajta Cɨríistuꞌu púꞌeen, tɨ ij aꞌɨ́ɨn ruxɨ́ꞌeviꞌiraꞌa jɨ́n rɨ́ꞌɨ titaatáꞌan, tɨ ij ajta tzáahuatiꞌiraꞌa jɨ́n titaataseíjrateꞌen aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Capu jaꞌatɨ́ jaꞌanáj raaseíj ɨ́ Dios, sino aꞌɨ́ɨ puꞌu tɨ aꞌɨ́ɨ naꞌa caj tíꞌiyaujraꞌan. Ruxɨ́ꞌeviꞌiraꞌa pu jɨ́n rɨ́ꞌɨ titatáꞌaca tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame. Capu jaꞌatɨ́ jaꞌanáj raaseíj ɨ́ Dios, sino aꞌɨ́ɨ puꞌu tɨ seɨ́j naꞌa yaujraꞌan púꞌeen, tɨ ajta Dios jemi seijreꞌe, aꞌɨ́ɨ pu ayén taatamuáꞌate aꞌij tɨ ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Majta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, mej majta tejéꞌaijta meꞌújna Jerusalén, aꞌɨ́ɨ mú huajaꞌutaꞌítecaꞌa ɨ́ Juan jemi seica ɨ́ mej tíꞌivaɨreꞌecaꞌa u huaꞌatéyujtaꞌa, majta seica ɨ́ mej meꞌɨ́jna jetze airáane aꞌɨ́jna ɨ́ Leví teecan mej mi miyen tiraataꞌíhuaꞌu tɨ jɨ́meꞌen yee: “¿Aꞌataani pej pɨ́rɨcɨɨ?” ");
INSERT INTO crnNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ajta aꞌɨ́jna ɨ́ Juan, capu huaꞌutáꞌijmɨijriꞌi mej ráamuaꞌati sino ruxɨ́ꞌeviꞌiraꞌa pu jɨ́n ayén tihuaꞌutáꞌixaa mejseíiracaꞌa naíjmiꞌi ɨ́ teɨte. Ayen tɨjɨ́n: ―Canu nee neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu tɨ Dios raꞌantíhuaꞌu. ");
INSERT INTO crnNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌataani pej púꞌeen? ¿Ni peꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ Elías? Ajta ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu neꞌɨ́n púꞌeen. Majta miyen tɨjɨ́n: ―¿Ni peꞌɨ́n púꞌeen ɨ́ tej rachúꞌeveꞌe, aꞌɨ́jna tɨ Dios jetze meꞌecan titaatáꞌixaateꞌesin? Ayee pu tiuꞌutaniú tɨjɨ́n: ―Canu neꞌɨ́n púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―¿Aꞌataani neꞌu pej púꞌeen múꞌee? Patáꞌaj taatáꞌixaateꞌen áꞌa jɨmeꞌe tej ti teajta tiyen tihuaꞌutáꞌixaateꞌen aꞌɨ́ɨme ɨ́ mej tajaꞌutaꞌítecaꞌa. ¿Aꞌiné petíꞌixa áꞌa jɨmeꞌe? ");
INSERT INTO crnNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aj puꞌi ayén Juan tiuꞌutaniú tɨjɨ́n: ―Nee nu neꞌɨ́n púꞌeen aꞌɨ́jna tɨ ayén jɨ́meꞌen tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Isaías teecan tɨ nuꞌu ayén jaꞌatɨ́ pu á eꞌevéꞌejijhua aꞌujna jáꞌahuaꞌa ꞌɨtzitá. Ayen tɨjɨ́n: “Rɨ́ꞌɨ xu huaújruuren sej si siyen temuaꞌa naa raꞌancuréꞌeviꞌitɨn seꞌɨ́jna ɨ́ tavástaraꞌa.” ");
INSERT INTO crnNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Majta seica ɨ́ fariseos, ɨ́ mej tiuꞌutaꞌaíjtiꞌire, ayée mú tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Tɨ́ puaꞌa piyen múꞌee caí aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Cɨríistuꞌu, pajta caí múꞌee aꞌɨ́ɨn púꞌeen ɨ́ Elías, pajta caí múꞌee aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ tej rachúꞌeveꞌe tɨ Dios jetze meꞌecan titaatáꞌixaateꞌesin, ¿aꞌiné ꞌeen jɨ́n piyen huáꞌamuaɨꞌɨhua ɨ́ teɨte? ");
INSERT INTO crnNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Juan tɨjɨ́n: ―Nee nu áꞌamuamuaɨꞌɨhua jaj jɨmeꞌe. Mɨ́ ajta, seɨ́j pu ayén múꞌejmi jemi seijreꞌe ɨ́ sej caí ramuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ auj mé eꞌevéꞌeme. Aꞌiné inee cɨliéeneꞌe nu jɨ́n tiꞌitéjvee ɨ́ jemin, capu ayén tiraavíjteꞌe nej raꞌajtaꞌɨ́ꞌɨpɨꞌɨn ɨ́ caꞌacairaꞌan. ");
INSERT INTO crnNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ayee pu tiúꞌuruu aꞌujna jáꞌahuaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betábara, u jetze pújmeꞌen, ɨ́ játeꞌanaraꞌan jetze ɨ́ Jordán, aꞌu tɨ aꞌɨ́ɨn Juan huajéꞌemuaɨꞌɨhuacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Yee ruijmuaꞌa yee, aꞌɨ́ɨ pu raaseíj aꞌɨ́jna ɨ́ Jesús tɨ eꞌevéꞌemeꞌecaa aꞌájna jemin. Aj pu i ayén tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan tɨjɨ́n: ―Casiꞌi xaaseíj múꞌeen, mɨ cáneꞌa Dios tɨ raatámuaɨꞌɨvajta. Aꞌii pu aꞌɨ́ɨn púꞌeen tɨ ruxɨ́ꞌeviꞌiraꞌa jɨ́n raꞌuréꞌuuna nain jɨmeꞌe aꞌij mej titeꞌuteájturaa ɨ́ Dios jemi aꞌachú mej puaꞌamé yen seijreꞌe íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ nej jɨ́meꞌen niyen tiuꞌutaxájtacaꞌa netɨ́ꞌɨj niyen tejámuaatáꞌixaa yee: “Seɨ́j pu yé ꞌeꞌevéꞌemeꞌe aꞌame nehuáritaꞌa mejcaꞌihuáyee, tɨ ajta jaítzeꞌe veꞌecán jɨ́n tiꞌitéjvee necaí inee, aꞌiné aꞌɨ́ɨ pu amuacaí huataseíjre necaí inee.” ");
INSERT INTO crnNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Canu neajta inee neseɨ́j ramuaꞌatejcaꞌa. Aru ayée nu en jɨ́n mú aꞌuvéꞌemej nej ni niyen huáꞌumuaɨꞌɨhua ɨ́ jaj jɨmeꞌe tɨ ij aꞌɨ́ɨn ayén huataseíjreꞌen aꞌɨ́mej jemi ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Aj puꞌi Juan ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu raaseíj neꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios tɨ júteꞌe ꞌeꞌicámeꞌecaa. Yee pu seijreꞌecaꞌa tɨ́j cucuiꞌi. Aj pu i án muꞌúutzeꞌen aꞌujyeíjxɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Canu aꞌatzu ramuaꞌatíicheꞌe tɨ puaꞌa caí ayén tinaatáꞌixaateꞌencheꞌe aꞌɨ́jna tɨ nejaꞌutaꞌítecaꞌa ayén tɨjɨ́n: “Tɨ́ puaꞌa hui piyen raaseíj tɨ aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios ayén eꞌicáanen tɨ ij seɨ́j japuan huateáturan, aj pej ramuaꞌati tɨ aꞌɨ́ɨn púꞌeen tɨ ayén tiraataꞌaíjteꞌesin aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios tɨ múꞌejmi tzajtaꞌa huateáturan sej si seꞌɨ́jna jetze araújcaꞌanen.” ");
INSERT INTO crnNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","’Nee nu niyen raaseíj. Neajta nu niyen tejámuaatáꞌixaateꞌesin tɨ aꞌɨ́ɨn púꞌeen ɨ́ yaujraꞌan ɨ́ Dios. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Yee ruijmuaꞌa yee, ajtahuaꞌa pu aꞌuun aꞌutéveecaꞌa aꞌɨ́jna ɨ́ Juan. Ajta aꞌɨ́ɨme ɨ́ tɨ huáꞌuviꞌitɨjmeꞌe, huaꞌapua mú jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tɨ́ꞌɨj raaseíj tɨ aꞌuun aꞌataméꞌecaa aꞌɨ́jna ɨ́ Jesús, ayée pu tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Xaaseíj múꞌeen, ɨ́ cáneꞌa Dios tɨ raatámuaɨꞌɨvajta. ");
INSERT INTO crnNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Matɨ́ꞌɨj miyen tiráanamuajriꞌi aꞌɨ́ɨme ɨ́ mej huaꞌapua, matɨ́ꞌɨj mi Jesús huatavén. ");
INSERT INTO crnNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ajta aꞌɨ́ɨn Jesús, tɨ́ꞌɨj pɨ́ aꞌuréꞌeve, aj puꞌi huaꞌuseíj mej raavájrajmeꞌe. Aj puꞌi ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné setíꞌijxeꞌeveꞌe múꞌeen? Aj mú miyen tiuꞌutaniú tɨjɨ́n: ―Rabí, ¿aꞌuné peꞌeche múꞌee? Aꞌíjna i niuucari tɨjɨ́n Rabí, ayée pu huataújmuaꞌa tɨjɨ́n: Tevij tɨ Tihuáꞌamuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aj pu i Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj yú aꞌuvéꞌejuꞌun setáꞌaj yaꞌuseíj. Matɨ́ꞌɨj mi aꞌucɨ́j jamuan. Majta u yaꞌuseíj aꞌutɨ́ éꞌechejcaꞌa. Majta mú jamuan aꞌuun aꞌuteájturaa aꞌachú puaꞌan hora tíꞌituraacaꞌa aꞌɨ́jna xɨcájraꞌa jetze. Yee pu teuuméꞌeca teꞌecáaráꞌa tacuarixpua. ");
INSERT INTO crnNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ajta, seɨ́j tɨ huáꞌa jetze ajtémeꞌecantacaꞌa ɨ́ mej huaꞌapua ɨ́ mej Jesús jamuan aꞌucɨ́j, ayée pu ántehuaacaꞌa tɨjɨ́n Andrés. Aꞌɨ́ɨ pu juutzeájraꞌan pɨ́rɨcɨ aꞌɨ́jna ɨ́ Simón, tɨ ajta iꞌi Pedro. ");
INSERT INTO crnNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Aj puꞌi aꞌɨ́ɨn Andrés amuacaí raꞌantinájchecaꞌa aꞌɨ́jna ɨ́ rujaꞌa, ɨ́ Simón. Aj puꞌi ayén tiraataꞌixaa tɨjɨ́n: ―Tuꞌuri ráateu teꞌɨ́jna ɨ́ Mesías. (Mesías, ayée pu huataújmuaꞌa aꞌɨ́jna ɨ́ niuucari tɨjɨ́n: Cɨríistuꞌu tɨ Dios Raꞌantihuau.) ");
INSERT INTO crnNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Tɨꞌɨj jí yeꞌeráaviꞌitɨ aꞌɨ́jna ɨ́ Simón ɨ́ Jesús jemi. Ajta aꞌɨ́ɨn Jesús, temuaꞌa pu tiraꞌaráaseij. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Múꞌee pej aꞌɨ́ɨn púꞌeen ɨ́ yaujraꞌan ɨ́ Jonás. Ayee pej ántehuaa puaꞌamé tɨjɨ́n: Cefas. (Cefas, ayée pu huataújmuaꞌa tɨjɨ́n: Pedro, tɨ ajta tetej púꞌeen.) ");
INSERT INTO crnNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yee ruijmuaꞌa yee, Jesús pu aꞌuun áꞌuyeꞌimɨjcaꞌa. Ayee pu tiraaxɨ́ꞌepɨꞌɨntare tɨ aꞌuun áꞌumeꞌen aꞌujna ájtepua, Galilea jáꞌahuaꞌa. Tɨ́ꞌɨj i aꞌɨ́ɨn raꞌantinájchecaꞌa aꞌɨ́jna ɨ́ Felipe. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Patáꞌaj ne jamuan áꞌucheꞌecaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Aꞌɨ́jna ɨ́ Felipe, aꞌúu pu éꞌemeꞌecantacaꞌa, aꞌujna chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Betsaída. Aꞌuu mú majta éꞌemeꞌecan aꞌɨ́jna ɨ́ Andrés, ajta aꞌɨ́jna ɨ́ Pedro. ");
INSERT INTO crnNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aj puꞌi aꞌɨ́ɨn Felipe aꞌɨ́ɨn huáteu ɨ́ Natanael. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Tuꞌuri ráateu teꞌɨ́jna tɨ jɨ́meꞌen Moisés teecan ayén tiraꞌuyúꞌuxacaꞌa aꞌɨ́jna jetze ɨ́ yuꞌuxari, ɨ́ niuucari ɨ́ mej jɨ́n tíꞌaijta. Aꞌii pu hui ajta aꞌɨ́ɨn púꞌeen ɨ́ mej majta jɨ́meꞌen raꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej Dios jetze meꞌecan tíꞌixaxaꞌataꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen aꞌɨ́jna ɨ́ Jesús, Nazarét tɨ éꞌemeꞌecan. Aꞌɨ́ɨ pu yaujraꞌan púꞌeen ɨ́ José. ");
INSERT INTO crnNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ajta aꞌɨ́jna ɨ́ Natanael, ayée pu tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni qui Nazarét éꞌemeꞌecan? ¿Ni ayén tíꞌirɨꞌɨri tɨ aꞌuun Nazarét tiꞌitɨ́j airaanen tɨ tiꞌirɨ́ꞌeen? Aj puꞌi ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Felipe tɨjɨ́n: ―Cheꞌeré, patáꞌaj yaꞌuseíj. ");
INSERT INTO crnNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tɨ́ꞌɨj Jesús raaseíj tɨ eꞌevéꞌemeꞌecaa aꞌɨ́jna ɨ́ Natanael, ayée pu tiuꞌutaxájtacaꞌa jɨ́meꞌen aꞌɨ́jna tɨjɨ́n: ―Xaaseíj, puꞌuri eꞌevéꞌeme seɨ́j tɨ tzɨ́teꞌe Israél jetze ajtémeꞌecan. Capu tíꞌihuaꞌitzi aꞌɨ́jna jemi. Capu jaꞌanáj tíꞌihuaꞌitaca. ");
INSERT INTO crnNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Aj puꞌi aꞌɨ́ɨn Natanael ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné penejaꞌumuáꞌa? ¿Aꞌiné pej pi ꞌeen jɨ́n nemuaꞌate? Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Nee nu neꞌuun muajaꞌuseíj patɨ́ꞌɨj peꞌuun eꞌirácatii jeten aꞌɨ́jna ɨ́ huaréj, tɨ́ꞌɨj caí xɨ muaatajéeve aꞌɨ́jna ɨ́ Felipe. ");
INSERT INTO crnNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Aj puꞌi ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Natanael tɨjɨ́n: ―Rabí, múꞌee pej peꞌɨ́n púꞌeen pej iꞌi yaujraꞌan ɨ́ Dios. Múꞌee pej aꞌɨ́ɨn púꞌeen ɨ́ pej titaataꞌaíjteꞌesin itejmi, i tej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Aj puꞌi Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Múꞌee pej piyen téꞌatzaahuateꞌe peꞌɨ́jna jɨmeꞌe nej niyen timuaatáꞌixaa yee nej neꞌuun muajaꞌuseíj patɨ́ꞌɨj peꞌuun eꞌirácatii ɨ́ huaréj jete. Ayee nu tíꞌimuaꞌixaateꞌe pej pauj piyen tíꞌiseijran tiꞌitɨ́j jɨmeꞌe tɨ jaítzeꞌe ruxeꞌeveꞌe caí aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ajta ayén tiraataꞌixaa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe pej piyen raseijran tɨ ayén antacúuniꞌihua aꞌame u ta japua. Majta aꞌɨ́ɨme ɨ́ mej meꞌuun tíꞌivaɨreꞌe Dios tɨ éꞌeseijreꞌe, aꞌɨ́ɨ mú yéveꞌecánineícaꞌa muáꞌajuꞌu ineetzi jemi, i nej neajta teáataꞌa jetze airáane. Majta mú aꞌuun áꞌujnineicaꞌa muáꞌajuꞌu meꞌújna u ta japua. ");
INSERT INTO crnNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tɨ́ꞌɨj huaíca xɨca jetze teuuméꞌeca, seɨ́j pu huaténeꞌɨchecaꞌa aꞌájna jáꞌahuaꞌa Galilea, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Caná. Ajta aꞌɨ́ɨn náɨnajraꞌan ɨ́ Jesús, aꞌuun aꞌutéveecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Majta aꞌɨ́ɨme ɨ́ mej tíꞌiyeste, aꞌɨ́ɨ mú raatáꞌinee meꞌɨ́jna ɨ́ Jesús, majta huaꞌutáꞌinee aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, mej mi huáꞌa jamuan tiúꞌuyesten. ");
INSERT INTO crnNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tɨ́ꞌɨj huaxɨ́j aꞌɨ́jna ɨ́ viinu, aj puꞌi aꞌɨ́ɨn náɨnajraꞌan ɨ́ Jesús ayén tiraataꞌixaa aꞌɨ́jna tɨjɨ́n: ―Capu chéꞌe urajmuaa ɨ́ viinu. ");
INSERT INTO crnNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tɨꞌɨj jí Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Náànaj, ¿aꞌiné petíꞌijxeꞌeveꞌe ineetzi jemi? Capúu xɨ aꞌájna tejaꞌuréꞌene ɨ́ nej jetzen aꞌɨ́mej jemi huataseíjreꞌen meneseíiraca aꞌɨ́ɨme ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Aj puꞌi aꞌɨ́ɨn náɨnajraꞌan ayén tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe tɨjɨ́n: ―Setáꞌaj siyen huárɨni aꞌij tɨ aꞌɨ́ɨn tejámuaatáꞌixaateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ajta aꞌuun vejliꞌi tejaꞌuvéejmeꞌecaa ɨ́ xaꞌari. Ayee pu tíꞌipuaꞌamecaꞌa aꞌachú cumu arájsevi tɨ tetej jɨmeꞌe taavíjhuacaꞌa. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ mej meꞌɨ́jna jɨ́n tiuꞌujáꞌusi naꞌari meꞌɨ́jna jetze huaɨ́ꞌɨhua aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan mej mi miyen meꞌɨ́jna jɨ́n araúrasten ɨ́ ruyeꞌirá. Ayee pu téꞌuvejricaꞌa aꞌachú cumu seité liitro, naꞌari seité liitro japuan tamuáamuataꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aj puꞌi Jesús ayén tíhuaꞌutaꞌaíj aꞌɨ́mej ɨ́ mej tíꞌivaɨreꞌe. Ayen tɨjɨ́n: ―Setáꞌaj raꞌavéꞌejɨsteꞌaxɨꞌɨn ɨ́ jaj ɨ́ xaꞌari tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Aj puꞌi ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj ruꞌitajánɨꞌɨn cɨ́j caj ɨ́ jaj tuꞌurájmuaa mɨ xaꞌari tzajtaꞌa. Setáꞌaj seajta raatáꞌan seꞌɨ́jna tɨ aꞌɨ́jna jɨ́n antiújmuaꞌaree mej yé tíꞌiyeste. Aj mú mi miyen raatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ajta aꞌɨ́ɨn tɨ antiújmuaꞌaree, aꞌɨ́ɨ pu raꞌantiꞌí aꞌɨ́jna ɨ́ jaj tɨ huateújviinutacaꞌa. Aꞌɨ́ɨ pu caí ramuaꞌareerecaꞌa aꞌu tɨ éꞌemeꞌecan aꞌɨ́jna ɨ́ viinu. Mɨ́ majta aꞌɨ́ɨme ɨ́ mej tíꞌivaɨreꞌe, aꞌɨ́ɨ mú xaa ramuaꞌareerecaꞌa. Aꞌɨ́j pu jɨ́n, aꞌɨ́ɨ pu raatajé aꞌɨ́jna ɨ́ jaꞌatɨ tɨ huaténeꞌɨchecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ayee pu tiraataꞌixaa tɨjɨ́n: ―Jaꞌatɨ́ tɨ naꞌa, ayée tu tíꞌijrɨꞌɨre. Amuacaí pu hui huaꞌatáꞌaca aꞌɨ́jna ɨ́ viinu tɨ jaítzeꞌe rɨ́ꞌen. Tɨ́ puaꞌa meri táꞌaruaj, aj puꞌi aꞌɨ́ɨn huaꞌutáꞌasin ɨ́ tɨ caí rɨ́ꞌen. Mɨ́ pajta múꞌee, méꞌe pu aꞌayeúche ɨ́ tɨ jaítzeꞌe rɨ́ꞌen tɨ́j naꞌa tej autéjhuii tej tij íjii raꞌantiyéꞌen. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aꞌii pu aꞌɨ́ɨn púꞌeeneꞌe ɨ́ tɨ amuacaí ayén tiꞌitɨ́j jɨ́n huarɨ́j aꞌɨ́jna ɨ́ Jesús, ɨ́ mej jɨ́n rɨ́ꞌɨ tiraꞌutaseíj. Ayee pu huarɨ́j aꞌujna u Caná, chajtaꞌa tɨ aꞌuun aꞌutacáꞌa u Galilea. Ayee pu huáꞌa jemi huataseíjre ɨ́ tíꞌimuarɨꞌeriꞌireꞌaraꞌan ɨ́ tɨ jɨ́n rɨ́ꞌɨ tihuaꞌutáꞌa. Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌɨ́ɨ mú jaítzeꞌe ráꞌantzaahua. ");
INSERT INTO crnNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tɨ́ꞌɨjtaꞌi, aꞌuun aꞌucáane aꞌujna Capernaúm aꞌɨ́mej jamuan ɨ́ náɨnajraꞌan, ajta ihuáamuaꞌameꞌen. Aꞌuu mú éꞌetee aꞌachú puaꞌan xɨcaj. ");
INSERT INTO crnNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tɨ́ꞌɨj ari vejliꞌitacaꞌa aꞌájna mej jetzen miyen raꞌutámuaꞌaree aꞌájna xɨcájraꞌan tɨ jetzen Dios tihuaꞌutáꞌuuniꞌiriꞌi aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecantacaꞌa, tɨꞌɨquí Jesús án aꞌujnéj aꞌujna Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aꞌuu pu aꞌuteájrupi taꞌanténineꞌi ɨ́ teyuu tɨ aꞌutéjvee. Aj puꞌi aꞌuun huáꞌuteu aꞌɨ́mej ɨ́ mej tíꞌitetuꞌaraca tiꞌiteén huáacasi nusu cáneꞌaxɨ caꞌɨ́n cucuiꞌise. Ajta seica pu huáteu ɨ́ mej án eꞌijtéjcaa meesa jetze mej mi tumin huapuátaꞌata. ");
INSERT INTO crnNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Aj puꞌi cuaarta huatétaahuacaꞌa caujnari jɨmeꞌe. Tɨꞌɨj jí aꞌɨ́jna jɨ́n huaꞌirámuari naíjmiꞌica. Aꞌɨ́mej pu ajta huiiramuári ɨ́ cáneꞌaxɨ, ajta ɨ́ huáacasi. Ajta pu pɨ́ téꞌejhuaꞌaxɨxɨ ɨ́ tihuáꞌameesa aꞌɨ́mej ɨ́ mej japuan tumin tíꞌipuataꞌatiꞌiracaꞌa. Ajta nainjapua ráahuaꞌastɨ́raa ɨ́ tumin. ");
INSERT INTO crnNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ayee pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej cucuiꞌise tuꞌaraca tɨjɨ́n: ―Setáꞌaj teꞌiráꞌan nain ɨ́ tɨ ayun tíꞌiseijreꞌe. Caxu chéꞌe siyen raruure niyáꞌupua tɨ raatéechiꞌi. Chéꞌe caí ayén tiꞌitévaꞌɨrihuaꞌan tɨ́j chiꞌi ɨ́ mej tzajtaꞌan tumin muaꞌitɨcɨ. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aj mú mi miyen raꞌutámuaꞌareeriꞌi tɨ ayén téꞌeyuꞌusiꞌi tɨjɨ́n: “Naꞌancaꞌanéecan nu yeehui jɨ́n niyen yé áꞌaseca aꞌu pej aꞌutéechiꞌi nej ni muaateánajche.” ");
INSERT INTO crnNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Majta aꞌɨ́ɨme ɨ́ mej tihuáꞌaijteꞌe ɨ́ mej Israél jetze ajtémeꞌecan, ayée mú tirájhuaviiriꞌi tɨ ij aꞌɨ́ɨn caꞌanéeri jɨ́n tiꞌitɨ́j huaꞌutaseíjrateꞌen ɨ́ mej jɨ́n rɨ́ꞌɨ tiraaseíj. Miyen tɨjɨ́n: ―Patáꞌaj taataseíjrateꞌen tiꞌitɨ́j ɨ́ tej jɨ́n aꞌij tímuaꞌutaséij tej ti teꞌɨ́jna jɨ́n ráamuaꞌaree pej peꞌɨ́jna jɨ́n antíꞌamuaꞌaree pej piyen rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa siyen raatéꞌuuna seꞌíjna i teyuu, nee nu huaíca xɨcaj tzajtaꞌa neajtahuaꞌa raꞌajjájsin. ");
INSERT INTO crnNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ajta aꞌɨ́ɨme ɨ́ Israél mej jetze ajtémeꞌecan, ayée mú titeetaniú tɨjɨ́n: ―Ayee pu hui áꞌatee aꞌachú cumu huaꞌapuate nineꞌiraꞌa japuan arájsevi mej ráꞌajtaahuacaꞌa. ¿Ni qui múꞌee piyen huaíca xɨcaj tzajtaꞌa pajtáhuaꞌa ráꞌajtaahua? ―Ayee mú tiraataꞌíhuaꞌuriꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mɨ́ ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu aꞌɨ́jna jɨ́n tíꞌixajtacaꞌa ɨ́ teyuu tɨ jetzen seijreꞌe. Aꞌii pu aꞌɨ́ɨn púꞌeeneꞌe ɨ́ téviraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tɨ́ꞌɨj Dios raꞌajjáj ɨ́ Jesús huáꞌa tzajtaꞌa ɨ́ mej meri huácuii, aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aj mú mi raꞌutámuaꞌareeriꞌi aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna jɨmeꞌe. Ajta, ayén tihuáꞌamitɨejteꞌecaꞌa tɨ ayén tiꞌayájnacaꞌa aꞌij tɨ téꞌeyuꞌusiꞌihuacaꞌa ɨ́ huáꞌayuꞌuxa jetze. Majta ráꞌantzaahua aꞌij tɨ Jesús tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tɨ́ꞌɨj aꞌuun aꞌutéveecaꞌa u Jerusalén aꞌájna xɨcájraꞌan jetze matɨ́ꞌɨj tíꞌiyestejcaꞌa aꞌɨ́jna jɨmeꞌe tɨ Dios tihuaꞌutáꞌuuniꞌiriꞌi, jeíhua mú teɨte raaseíj aꞌij tɨ Jesús rɨjcaa aꞌɨ́jna jɨmeꞌe tɨ huápɨꞌɨ naa tihuáꞌaseijrateꞌe. Aꞌɨ́j mú jɨ́n muꞌiitɨ́ ráꞌantzaahua tɨ nuꞌu aꞌɨ́ɨn púꞌeeneꞌe ɨ́ mej rachúꞌeveꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mɨ́ ajta Jesús, capu huataúraꞌa tɨ huataújtuiireꞌen aꞌɨ́mej jemi, aꞌiné aꞌɨ́ɨ pu naíjmiꞌica muaꞌatejcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Capu ayén ruxeꞌeveꞌecaꞌa tɨ jaꞌatɨ́ ayén raatáꞌixaateꞌen aꞌij tɨ ꞌeen ɨ́ teáataꞌa, aꞌiné aꞌɨ́ɨ pu ruseɨ́j rúꞌumuaꞌareerecaꞌa aꞌij tɨ ꞌéeneꞌe muaꞌatzíireꞌaraꞌan ɨ́ tzajtaꞌan ɨ́ tevi. ");
INSERT INTO crnNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aꞌuun pu seɨ́j aꞌutéveecaꞌa tɨ aꞌɨ́mej jetze ajtémeꞌecantacaꞌa ɨ́ fariseos. Ayee pu ántehuaacaꞌa tɨjɨ́n Nicodemo. Aꞌɨ́ɨ pu seɨ́j aꞌɨ́ɨn púꞌeeneꞌe ɨ́ huaꞌavaujsi ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Aꞌɨ́ɨ pu tɨ́caꞌɨmua á eꞌiréꞌene ɨ́ Jesús jemi. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Vástaꞌa, teen tu ramuaꞌaree pej peꞌuun aꞌuvéꞌemej ɨ́ Dios jemi aꞌɨ́jna jɨmeꞌe aꞌij pej titaatáꞌixaateꞌen. Ayee tu tíꞌijmuaꞌaree tɨ caí aꞌij tíꞌirɨꞌɨri tɨ jaꞌatɨ́ ayén rɨjca patɨ́j múꞌee, aꞌɨ́jna jɨmeꞌe ɨ́ tej jɨ́n aꞌij tímuaꞌutaséij tɨ puaꞌa caí Dios ayén jemin seijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ajta Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Jee xaa neꞌu, ayée nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, tɨ puaꞌa jaꞌatɨ́ caí ajtahuaꞌa huanúꞌihua, capu rɨꞌɨrí tɨ aꞌɨ́ɨn aꞌuun aꞌuteárute aꞌujna Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Aj puꞌi Nicodemo ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ jaꞌatɨ́ ayén ajtahuaꞌa huanúꞌihua tɨ puaꞌa aꞌɨ́ɨn ari vástaꞌa púꞌeeneꞌen? Capu xaa neꞌu aꞌij tíꞌirɨꞌɨri tɨ ajtahuaꞌa atéhuiꞌixɨn ɨ́ jucáaraꞌan jetze ɨ́ runáàna tɨ ij ajtahuaꞌa huanúꞌihua. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Nicodemo. ");
INSERT INTO crnNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tɨꞌɨj jí Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, tɨ puaꞌa caí ayén huaujjéjcuareꞌen aꞌɨ́jna jɨmeꞌe tɨ ayén huaújmuaɨꞌɨhua jaj jɨmeꞌe, ajta tɨ puaꞌa caí ayén ajtahuaꞌa huanúꞌihua aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios ayén huateáturan ɨ́ jemin, capu aꞌij tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn jaꞌatɨ́ aꞌuun aꞌuteárute aꞌujna Dios tɨ éꞌeseijreꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Seɨcɨé pu ꞌeen aꞌɨ́jna tɨ aꞌɨ́jna jetze airáninei tɨ ayén ratéhuaꞌiraꞌa. Ayee pu cheꞌatá naꞌa seɨcɨé ꞌeen aꞌɨ́jna tɨ aꞌɨ́jna jetze airaújneijte ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","’Capej aꞌij téꞌamuajca nej niyen tíꞌimuaꞌixaateꞌe yee ruxeꞌeveꞌe pej pajtáhuaꞌa huanúꞌihua. ");
INSERT INTO crnNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Casiꞌi, ayée pu rɨcɨ ɨ́ eeca. Nain japua pu huáꞌeecaj. Pajta ranamua tɨ jújhuaꞌana. Mɨ́ ajta, capu aꞌij timuáꞌamitɨejteꞌe aꞌu tɨ pújmeꞌen aꞌuvéꞌeyeꞌi naꞌari aꞌu tɨ pújmeꞌen huarúꞌipi. Ayee pu cheꞌatá naꞌa tihuáꞌaruure matɨ́j menaꞌa puaꞌamé ɨ́ mej miyen airaújneijte meꞌɨ́jna jetze ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios. ―Ayee pu tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ajta aꞌɨ́ɨn Nicodemo ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ ayén tejaꞌuréꞌenen? ");
INSERT INTO crnNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tɨꞌɨj jí Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Mɨ́ pej tihuáꞌamuaꞌate aꞌɨ́mej ɨ́ mej Israél teecan jetze ajtémeꞌecan, ¿ni tzaa ayén tiꞌayajna pej caí yaúꞌitɨe aꞌij nej tíꞌimuaꞌixaateꞌe? ");
INSERT INTO crnNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ayee nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, ayée tu teꞌɨ́jna jɨ́n tíꞌixaxaꞌa ɨ́ tej tiyen ramuaꞌaree, teajta teꞌɨ́jna jɨ́n tiuꞌutaxájta ɨ́ tej tajɨ́ꞌɨ jɨ́n tiuꞌuséij. ’Mɨ́ seajta múꞌeen, caxuu xɨ raꞌancuréꞌa aꞌij tej tejáꞌamuaꞌixaateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ayee nu neꞌɨ́jna jɨ́n timuaatáꞌixaa aꞌij tɨ tíꞌirɨneca íiyen chaanaca japua. Mɨ́ pajta múꞌee, capej jɨ́meꞌen téꞌatzaahuateꞌe. ¿Aꞌiné tíꞌirɨꞌɨri pej piyen téꞌantzaahuateꞌen tɨ puaꞌa niyen neꞌɨ́jna jɨ́n timuaatáꞌixaateꞌen aꞌij tɨ tíꞌirɨneca u ta japua Dios tɨ éꞌeseijreꞌe? Capu xaa neꞌu aꞌij tíꞌirɨꞌɨri. ");
INSERT INTO crnNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Capu jaꞌatɨ́ jaꞌanáj u aꞌujnéj u ta japua sino aꞌɨ́ɨ puꞌu ɨ́ tɨ yé veꞌecáane íiyen chaanaca japua. Nee nu neꞌɨ́n púꞌeen i nej neajta teáataꞌa jetze airáane. ");
INSERT INTO crnNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Ajta, tɨ́j aꞌɨ́ɨn Moisés ajmíꞌi raꞌajpí aꞌɨ́jna ɨ́ cuꞌucuꞌu aꞌujna jáꞌahuaꞌa tɨ caí éꞌe tíꞌitɨɨtacaꞌa, ayée pu cheꞌatá naꞌa tiúꞌujxeꞌeveꞌe tɨ Dios ayén naꞌajján ineetzi i nej neajta teáataꞌa jetze airáane, tɨ ij ayén tihuáꞌacɨꞌɨti aꞌachú mej puaꞌamé náꞌantzaahuateꞌesin mej mi miyen ruuri huateáturan tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ayee pu Dios ayén huaꞌutaxɨ́ꞌeve aꞌɨ́mej ɨ́ mej yen huachéjme íiyen chaanaca japua tɨ i ayén nejaꞌutaꞌítecaꞌa ineetzi, nej nee nenaꞌa caj tíꞌiyaujraꞌan, nej ni niyen huámɨꞌɨni huáꞌa jetze meꞌecan mej mi caí antipuáꞌare sino tɨ ayén tihuáꞌacɨꞌɨti mej mi miyen ruuri huateáturan tɨ́j naꞌa rusén jɨmeꞌe, aꞌachú mej puaꞌamé miyen naꞌaráꞌastijreꞌesin ineetzi. ");
INSERT INTO crnNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ayee pu xaa neꞌu tiꞌayajna. Capu Dios ayén nejaꞌutaꞌítecaꞌa nej yé veꞌecáanen íiyen chaanaca japua nej ni niyen huaꞌuxɨ́jteꞌen neꞌɨ́mej ɨ́ mej yen huachéjme neꞌɨ́jna jɨmeꞌe nej ni puaíjtzi huaꞌutáꞌan sino ayée pu nejaꞌutaꞌítecaꞌa nej ni huáꞌa japua huániuuni neꞌɨ́jna jɨmeꞌe nej naíjmiꞌica tiuꞌutáꞌuuniꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Ayee pu tíꞌijcɨꞌɨti jaꞌatɨ́ tɨ naꞌa tɨ ayén náꞌastijreꞌe ineetzi, nej ni caí raꞌuxɨ́jteꞌen, neajta caí puaíjtzi raatáꞌan. Mɨ́ ajta aꞌɨ́ɨn, jaꞌatɨ́ tɨ naꞌa tɨ caí náꞌastijreꞌe ineetzi, Dios pu ari raꞌuxɨ́jte tɨ ij ayén puaíjtzi raatáꞌan aꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn caí náꞌastijreꞌe ineetzi nej nee nenaꞌa caj tíꞌiyaujraꞌan ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","’Ayee pu ari huáꞌa jɨ́meꞌen raꞌuxɨ́jte ɨ́ Dios nej neri huáꞌa jemi huataseíjre aꞌɨ́mej jemi ɨ́ mej yen huachéjme chaanaca japua nej ni niyen tíhuaꞌutétatzaviꞌi. Mɨ́ majta meꞌɨ́n ɨ́ teɨte, ayée mú jaítzeꞌe raataxɨ́ꞌeve mej meꞌuun aꞌuteáturan aꞌu tɨ aꞌutɨ́caꞌa mej caí raataxɨ́ꞌeve mej meꞌuun aꞌuteáturan aꞌu tɨ áꞌuneeriꞌi. Ayee mú ꞌeen jɨ́n raataxɨ́ꞌeve aꞌiné aꞌij mú puaꞌa titetiújchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","’Ayej xaa neꞌu tiꞌayajna, jaꞌatɨ́ tɨ naꞌa tɨ ayén aꞌij puaꞌa tiꞌitiújchaꞌɨɨ, capu aꞌatzu raꞌaráanajche tɨ ayén huárɨni tɨ aꞌij puaꞌa ꞌeen jɨmeꞌe aꞌu tɨ áꞌuneeriꞌi. Capu xaa neꞌu ayén áꞌujcaꞌane tɨ ayén aꞌij puaꞌa huárɨni aꞌu tɨ áꞌuneeriꞌi aꞌɨ́jna jɨmeꞌe tɨ rátziɨɨneꞌe tɨ ij ayén huatámitɨeereꞌen aꞌij tɨ ꞌeen aꞌɨ́jna tɨ jɨ́n ayén rɨcɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","’Mɨ́ ajta, jaꞌatɨ́ tɨ naꞌa tɨ hui tzáahuatiꞌiraꞌa jɨ́n rɨ́ꞌɨ tiꞌitiújchaꞌɨɨ, aꞌɨ́ɨ pu xaa ayén áꞌujcaꞌane tɨ ayén rɨjca aꞌu tɨ áꞌuneeriꞌi tɨ ij ayén huatámitɨeereꞌen temuaꞌa naa tɨ ayén rɨcɨ aꞌɨ́jna jɨmeꞌe tɨ ráꞌastijreꞌe ɨ́ Dios. ―Ayee pu tiuꞌutaxájtacaꞌa ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tɨ́ꞌɨj i Jesús aꞌuun áꞌume aꞌájna jáꞌahuaꞌa, aꞌuun tɨ aꞌutacáꞌa u Judea. Majta mú jamuan aꞌucɨ́j aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Aꞌuu pu huáꞌa jamuan aꞌutéveecaꞌa aꞌachú puaꞌan xɨcaj. Ajta huáꞌumuaɨꞌɨhuacaꞌa ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Aꞌajnáꞌɨmua, aꞌɨ́ɨ pu Juan ajta huáꞌamuaɨꞌɨhuacaꞌa aꞌájna jáꞌahuaꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Enón. Aꞌuu pu vejliꞌi aꞌutacáꞌa u chajtaꞌa tɨ ayén téjaꞌarájtehuaa Salim. Ayej tíꞌiruurejcaꞌa aꞌiné jeíhua pu jájmuaacaꞌa aꞌujna. Majta mú jeíhua teɨte eꞌiréꞌenineicaꞌa ɨ́ jemin tɨ ij huáꞌumuaɨꞌɨhua. ");
INSERT INTO crnNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ayee pu tíꞌiruurejcaꞌa aꞌiné camúu xɨ raꞌiténajcaꞌa meꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Matɨ́ꞌɨj mi autéjhuii aꞌɨ́ɨme ɨ́ mej Juan jamuan áꞌujujhuaꞌaneꞌe mej tiújteaꞌaxɨꞌɨn aꞌɨ́mej jamuan ɨ́ seica ɨ́ mej Israél jetze ajtémeꞌecan meꞌɨ́jna jɨmeꞌe ɨ́ huaꞌayeꞌira, ɨ́ tɨ nuꞌu ayén ruxeꞌeveꞌe mej nuꞌu ꞌéꞌetiɨꞌɨhuáxɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Matɨ́ꞌɨj mi eꞌiréꞌene ɨ́ Juan jemi. Aj mú mi miyen tiraataꞌixaa tɨjɨ́n: ―Rabí, casiꞌi aꞌij tɨ rɨcɨ aꞌɨ́jna tɨ aꞌuun aꞌutéveecaꞌa múꞌeetzi jemi patɨ́ꞌɨj peꞌuun u jetze pújmeꞌen u Jordán. Aꞌii pu hui aꞌɨ́ɨn púꞌeen ɨ́ pej jɨ́meꞌen tiuꞌutaxájtacaꞌa. Ajta íjii, aꞌɨ́ɨ pu huáꞌamuaɨꞌɨhua ɨ́ teɨte. Majta naímiꞌi mú eꞌiréꞌeninei ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ajta aꞌɨ́ɨn Juan, ayée pu tiuꞌutaniú tɨjɨ́n: ―Tɨ́j naꞌa tɨ jaꞌatɨ́ ayén raꞌancuréꞌasin, ayée pu tíꞌijcɨꞌɨti aꞌɨ́jna jɨmeꞌe tɨ Dios ayén tiraatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Múꞌeen xu hui seajta seri náanamuajriꞌi nej niyen tejámuaatáꞌixaa yee nej caí neꞌɨ́n púꞌeen ɨ́ Cɨríistuꞌu tɨ Dios raꞌantíhuaꞌu, sino Dios pu ayén nejaꞌutaꞌítecaꞌa nej ni amuacaí huataseíjreꞌen múꞌejmi jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","’Ayee pu tíꞌirɨneca tɨ́ꞌɨj jaꞌatɨ́ huaténeꞌɨche. Aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa, aꞌɨ́ɨ pu huateáturaasin aꞌɨ́jna jemi tɨ raꞌancuréꞌeviꞌitɨ. Ajta aꞌɨ́ɨn amiiguraꞌan ɨ́ jaꞌatɨ, aꞌɨ́ɨ pu á vejliꞌi aꞌutéveeca tɨ ij ayén ráꞌanviꞌitɨn aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa aꞌɨ́jna jemi ɨ́ teáataꞌa. Aꞌɨ́ɨ pu ajta ayén rutémuaꞌaveꞌe aꞌɨ́jna jɨmeꞌe tɨ ayén ranamua aꞌij tɨ aꞌɨ́ɨn jaꞌatɨ́ tiuꞌutaxájta aꞌɨ́jna jɨmeꞌe tɨ ari raꞌancuréꞌeviꞌitɨ aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa. Ayee nu hui cheꞌatá nenaꞌa netémuaꞌaveꞌe inee, aꞌiné puꞌuri antipuáꞌari ɨ́ nej jɨ́n antínmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","’Ayee pu tiúꞌujxeꞌeveꞌe tɨ aꞌɨ́ɨn jaítzeꞌe veꞌecán jɨ́n teꞌenteárute. Ajta ineetzi jemi, ayée pu ajta ruxeꞌeveꞌe nej jaítzeꞌe cɨliéeneꞌe jɨ́n tiuꞌutévaɨreꞌen. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan. ");
INSERT INTO crnNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Aꞌɨ́jna tɨ hui u eꞌicaanej u júteꞌe, aꞌɨ́ɨ pu nain jɨ́n antiújmuaꞌaree. Neajta inee, i nej íiyen chaanaca japua meꞌecan, íiye nu hui meꞌecan, neajta niyen tíꞌixaxaꞌa aꞌij tɨ tiꞌitɨ́j rɨ́ɨj áꞌayeꞌi íiyen chaanaca japua. Ajta aꞌɨ́ɨn tɨ júteꞌe eꞌicaanej, aꞌɨ́ɨ pu nain jɨ́n antiújmuaꞌaree. ");
INSERT INTO crnNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Aꞌɨ́ɨ pu ayén aꞌɨ́jna jɨ́n tíꞌixaxaꞌa aꞌij tɨ aꞌɨ́ɨn tiuꞌuséij, ajta aꞌij tɨ aꞌɨ́ɨn tiúꞌunamuajriꞌi ɨ́ Dios jemi. Mɨ́ ajta, capu jaꞌatɨ́ ráꞌatzaahuateꞌe aꞌij tɨ tiꞌixa. ");
INSERT INTO crnNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ajta aꞌɨ́ɨn tɨ ayén ráꞌantzaahuate, aꞌɨ́ɨ pu ayén raatáꞌitɨira tɨ ayén tiꞌayajna tɨ Dios ayén tzáahuatiꞌiraꞌa jɨ́n tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","’Aꞌɨ́jna tɨ Dios yaꞌutaꞌítecaꞌa, ayée pu hui cheꞌatá naꞌa aꞌɨ́jna jɨ́n tiꞌixa aꞌij tɨ tiuꞌutaxájtacaꞌa ɨ́ Dios. Ayee pu aꞌɨ́jna jɨ́n rɨcɨ aꞌiné Dios pu ayén raatáꞌa tɨ aꞌɨ́ɨn xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios nain jɨ́n huateáturan ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ajta, aꞌɨ́ɨn yaꞌupuáaraꞌan raxɨ́ꞌeveꞌe ɨ́ ruyauj, ajta ayén raatáꞌa tɨ aꞌɨ́ɨn yaujraꞌan nain jɨ́n antiújmuaꞌaréere áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","’Aꞌɨ́jna tɨ ráꞌastijreꞌe aꞌɨ́jna ɨ́ yaujraꞌan, aꞌɨ́ɨ pu ruuri huateáturaasin ɨ́ Dios jemi tɨ́j naꞌa rusén jɨmeꞌe. Ajta aꞌɨ́ɨn tɨ caí ayén tiraꞌaráꞌastijreꞌe, capu racɨꞌɨti tɨ ruuri huateáturan ɨ́ Dios jemi sino Dios pu puaíjtzi raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Majta meꞌɨ́n ɨ́ fariseos, ayée mú ráamuaꞌareeriꞌi tɨjɨ́n jaítzeꞌe pu nuꞌu huáꞌamuaꞌitɨjcɨ ɨ́ teɨte aꞌɨ́jna ɨ́ Jesús caí aꞌɨ́jna ɨ́ Juan. Ajta nuꞌu huáꞌamuaɨꞌɨhua. ");
INSERT INTO crnNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mɨ́ ajta aꞌɨ́ɨn Jesús, capu ayén tihuáꞌamuaɨꞌɨhuacaꞌa, sino aꞌɨ́ɨme muꞌu ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ajta aꞌɨ́ɨn Jesús, tɨ́ꞌɨj ayén tiúꞌunamuajriꞌi mej nuꞌu miyen tiráamuaꞌareeriꞌi aꞌɨ́ɨme ɨ́ fariseos, aj puꞌi aꞌuun eꞌerájraa u Judea. Tɨꞌɨj jí ajtahuaꞌa aꞌuun aꞌutamé ájtepua u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ayee pu tiúꞌujxeꞌeveꞌecaꞌa tɨ aꞌuun jáꞌitaꞌa aꞌuréꞌenen u Samaria. ");
INSERT INTO crnNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tɨꞌɨj jí aꞌuun aꞌaráꞌa chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Sicar, tɨ aꞌuun ajtémeꞌecan u Samaria. Aꞌuu pu vejliꞌi aꞌutacáꞌa aꞌɨ́jna chuéjraꞌa tɨ aꞌɨ́ɨn nuꞌu Jacobo teecan raatapuaíjve ɨ́ ruyauj ɨ́ José teecan. ");
INSERT INTO crnNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Aꞌuu pu yeꞌetéecu aꞌɨ́jna ɨ́ Jacobo. Ajta aꞌɨ́ɨn Jesús, aꞌúu pu aꞌujyeíjxɨ á vejliꞌi aꞌutɨ́ eꞌetécun aꞌiné temuaꞌa pu tíꞌicuaꞌanacaꞌa aꞌɨ́jna jɨmeꞌe tɨ áꞌatee tɨ huaméj ɨ́ juye jetze. Aꞌatzaj aꞌájna pɨ́tíꞌirɨjcaa á tacuarixpua. ");
INSERT INTO crnNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tɨꞌɨj jí seɨ́j á eꞌiréꞌene, ꞌɨ́itaꞌa tɨ Samaria éꞌemeꞌecan. Ayee pu aꞌɨ́jna jɨ́n eꞌiréꞌene tɨ ij jaj aiitajánɨꞌɨn. Aj puꞌi Jesús ayén tiraatajé tɨjɨ́n: ―Cɨ́j caj jaj tinaatáꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Majta aꞌɨ́ɨme, ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, aꞌúu mú áꞌujuꞌun u chajtaꞌa mej mi cuaꞌira tiúꞌunanan. ");
INSERT INTO crnNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa ayén tiraataꞌixaa tɨjɨ́n: ―Múꞌee pej hui Israél jetze ajtémeꞌecan. Neajta inee, inee iꞌi ꞌɨ́itaꞌa íiye nej Samaria meꞌecan. ¿Aꞌiné ꞌeen jɨmeꞌe piyen jaj nehuavii nej cɨ́j caj timuaatáꞌan? (Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa aꞌiné, aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, camu aꞌij áꞌujmuaꞌara aꞌɨ́mej jemi, ɨ́ mej Samaria éꞌeche.) ");
INSERT INTO crnNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Aj puꞌi Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Tɨ́ puaꞌa pej muaꞌareere tiꞌitɨ́j tɨ jɨ́n Dios ruxɨ́ꞌeviꞌiraꞌa jɨ́n muaatapuaíjveꞌesin, pajta ramuaꞌareere jaꞌatɨ́ nej púꞌeen inee, i nej niyen muahuavii, ayée pej naatahuavíirancheꞌe. Neajta nu niyen neꞌɨ́jna muaatáꞌanicheꞌen neꞌɨ́jna ɨ́ jaj ɨ́ pej jɨ́n rusén jɨ́n ruuri. ");
INSERT INTO crnNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ajta aꞌɨ́ɨn ɨ́ ꞌɨ́itaꞌa, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, capej tiꞌitɨ́j tíchaꞌɨɨ ɨ́ pej jɨ́n raꞌitajánɨꞌɨn ɨ́ jaj, ajta jeíhua pu hui ucátee ɨ́ tɨ atécun. ¿Aꞌuné jetze péyeꞌejánɨꞌɨsin peꞌɨ́jna ɨ́ jaj? ");
INSERT INTO crnNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ni piyen jaítzeꞌe tiꞌitɨ́j jɨ́n antíꞌamuaꞌaree múꞌee caí aꞌɨ́jna ɨ́ tayáꞌupuacɨꞌɨ, aꞌɨ́jna ɨ́ Jacobo teecan tɨ ayén taatáꞌa tej tiyen aꞌuyéꞌen iiyecuí? Aꞌɨ́ɨ pu ajta ayajna yéꞌecareꞌe, majta aꞌɨ́ɨme ɨ́ yaújmuaꞌameꞌen, majta ɨ́ tihuáꞌayeꞌemuaacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Ayee nu tíꞌimuaꞌixaateꞌe tɨ ayén tihuáꞌaruuren aꞌachú mej puaꞌamé miyen rayeꞌe meꞌɨ́jna ɨ́ jaj tɨ aiitáninei mɨ taꞌatécun jetze. Matɨ́ꞌɨj huayéꞌen, majtáhuaꞌa mú huataꞌíꞌicu méjcaꞌi huáyee. ");
INSERT INTO crnNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Mɨ́ ajta, jaꞌatɨ́ tɨ naꞌa tɨ aꞌɨ́jna huayéꞌen ɨ́ jaj nej hui niyen raatáꞌasin, capu chéꞌe jaꞌanáj huataꞌíꞌimɨ. Jee xaa neꞌu, ayée pu seíireꞌe aꞌame ɨ́ jemin tɨ aꞌɨ́jna ɨ́ jaj nej niyen tiraatáꞌasin tɨ ayén aiitáninéicaꞌa aꞌame tɨ ij aꞌɨ́ɨn jaꞌatɨ́ rusén jɨ́n ruuri áꞌaraꞌani. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Aj puꞌi aꞌɨ́ɨn ꞌɨ́itaꞌa ayén tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, patáꞌaj piyen cɨ́j caj tinaatáꞌan peꞌɨ́jna ɨ́ jaj nej ni caí chéꞌe huataꞌíꞌimɨn, tɨ ij ajta caí chéꞌe ayén tiúꞌujxeꞌeveꞌe nej niyen yeraajéin neyajna. ");
INSERT INTO crnNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Aj puꞌi ɨ́ Jesus ayén tiraataꞌixaa tɨjɨ́n: ―Aricu, u aꞌutájee ɨ́ tɨ muajáꞌuviꞌitɨn. Pajta mú aꞌuvéꞌemeꞌen. ");
INSERT INTO crnNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Aj puꞌi aꞌɨ́ɨn ꞌɨ́itaꞌa ayén tiraataꞌixaa tɨjɨ́n: ―Capu jaꞌatɨ́ nejáꞌuviꞌitɨn. Aj puꞌi ayén tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Xɨ́ꞌepɨꞌɨn pej tiuꞌutaxájtacaꞌa tɨ nuꞌu caí jaꞌatɨ́ muajáꞌuviꞌitɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ayee pu tiꞌayajna ɨ́ mej meri anxɨ́vi aráꞌase muáꞌaraa aꞌɨ́ɨme ɨ́ mej muatéviꞌitɨneꞌe. Ajta aꞌɨ́ɨn ɨ́ pej jamuan áꞌuca íjii, capu muajáꞌuviꞌitɨn aꞌɨ́jna. Ayee pej tzáahuatiꞌiraꞌa jɨ́n tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Aj puꞌi ayén tiraataꞌixaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n: ―Nevástaraꞌa, ayée pu hui tináꞌamitɨejteꞌe pej piyen Dios jetze meꞌecan tíꞌixaxaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tavaújsimuaꞌacɨꞌɨ mú ranáꞌamicheꞌe ɨ́ Dios aꞌíjna jetze ɨ́ jɨrí. Mɨ́ seajta múꞌeen, mɨ sej Israél jetze ajtémeꞌecan, ayée xu tíꞌixaxaꞌa tɨ ayén ruxeꞌeveꞌe tej teꞌuun yéꞌanaꞌamicheꞌen aꞌujna jáꞌahuaꞌa u Jerusalén. ―Ayee pu tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ajta aꞌɨ́ɨn Jesús, ayée pu tiuꞌutaniú tɨjɨ́n: ―ꞌƗitaꞌa, ayée nu tíꞌimuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, puꞌuri tɨ́n tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌan jetze sej caí chéꞌe ranáꞌamicheꞌe xáꞌajuꞌun ɨ́ tayáꞌupua íiyen jɨrí japua, camu majta chéꞌe ranáꞌamicheꞌe muáꞌajuꞌu u Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","’Múꞌeen, mɨ sej Samaria éꞌemeꞌecan, ayée xu hui caí ramuaꞌate seꞌɨ́jna ɨ́ sej ranaꞌamiche. Mɨ́ teajta iteen, teen tu ramuaꞌate teꞌɨ́jna ɨ́ tej ranaꞌamiche aꞌiné aꞌɨ́jna tɨ ayén ta japua niuuni, aꞌɨ́mej jetze pu huataseíjreꞌesin ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","’Mɨ́ ajta, puꞌuri tɨ́n tejaꞌuréꞌenejsin aꞌájna xɨcájraꞌan jetze mej miyen meꞌɨ́jna jetze araújcaꞌanen ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios mej mi miyen tzáahuatiꞌiraꞌa jɨ́n ranáꞌamicheꞌen ɨ́ tayáꞌupua. Jee xaa neꞌu, puꞌuri aꞌájna tejaꞌuréꞌene mej miyen rɨcɨ aꞌɨ́ɨme ɨ́ mej tzáahuatiꞌiraꞌa jɨ́n ranaꞌamiche aꞌiné tayáꞌupua pu ayén huáꞌahuauhuau aꞌɨ́mej ɨ́ mej miyen ranaꞌamiche. ");
INSERT INTO crnNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","’Dios pu xɨéjniuꞌucari púꞌeen, majta aꞌɨ́ɨme ɨ́ mej ranaꞌamiche, ayée pu ruxeꞌeveꞌe mej meꞌɨ́jna jetze araújcaꞌanen ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios mej mi tzáahuatiꞌiraꞌa jɨ́n ranáꞌamicheꞌen. ―Ayee pu tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nee nu hui ramuaꞌaree tɨ aꞌɨ́ɨn téjmi jemi huataseíjreꞌesin aꞌɨ́jna ɨ́ tɨ jee Mesías púꞌeen, ɨ́ mej miyen ratamuáꞌamua tɨjɨ́n Cɨríistuꞌu tɨ Dios raꞌantíhuaꞌu. Tɨ́ꞌɨj aꞌɨ́ɨn ayén huataseíjreꞌen, aꞌɨ́ɨ pu nain jɨ́n titaatáꞌixaateꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Aj puꞌi Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Inee, i nej á jamuan tiꞌixa, nee nu neꞌɨ́n púꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj mú mi uvéꞌene aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Jéꞌecan mú aꞌij raꞌutaseíj meꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn ꞌɨ́itaꞌa jamuan tíꞌixajtacaꞌa. Mɨ́ ajta, capu jaꞌatɨ́ ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: “¿Aꞌiné péjruuren pemɨ́jna mɨ ꞌɨ́itaꞌa?” Ni camu miyen yee: “¿Aꞌiné ꞌeen jɨmeꞌe piyen jamuan tiꞌixa?” ");
INSERT INTO crnNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Ajta aꞌɨ́ɨn ꞌɨ́itaꞌa, á pu yaꞌutára aꞌɨ́jna ɨ́ ruxaꞌari. Tɨꞌɨj jí u áꞌume u chajtaꞌa. Aj puꞌi ayén tihuaꞌutáꞌixaa ɨ́ teɨte. Ayen tɨjɨ́n: ―Mú seꞌutáuruyiꞌi sej si yaꞌuseíj jaꞌatɨ́ tɨ ayén tinaatáꞌixaa nain jɨmeꞌe aꞌij nej tiꞌitínchaꞌɨɨ. ¿Ni qui caí aꞌɨ́ɨn púꞌeen ɨ́ Cɨríistuꞌu? ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Matɨ́ꞌɨj miyen tiráanamuajriꞌi, aj mú mi meꞌɨ́n ɨ́ teɨte huiráacɨ u chajtaꞌa. Matɨ́ꞌɨj mi meꞌuun u áꞌujuꞌun ɨ́ Jesús jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Meenti mauj aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, ayée mú caꞌanéjri ratáꞌacareꞌe tɨ tiúꞌucuaꞌani. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Rabí, patáꞌaj tiúꞌucuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Aj puꞌi ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Nee nu neꞌɨ́jna jɨ́n huaténvaɨreꞌesin neꞌɨ́jna jɨmeꞌe ɨ́ cuaꞌira ɨ́ sej caí ramuaꞌate. ");
INSERT INTO crnNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Majta meꞌɨ́n, ayée mú tiújꞌixaateꞌecaꞌa tɨjɨ́n: ―Tij jaꞌatɨ́ ari tiraavéꞌetuiiriꞌi ɨ́ cuaꞌira. ");
INSERT INTO crnNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Aj puꞌi Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Aꞌɨ́j nu jɨ́n niyen huaténvaɨreꞌesin neꞌɨ́jna jɨmeꞌe nej ni niyen raꞌaráꞌasten ɨ́ tɨ jɨ́n Dios ayén nejaꞌutaꞌítecaꞌa, neajta nej nain jɨ́n raꞌantícɨꞌɨti neꞌɨ́jna ɨ́ tɨ jɨ́n tinaaꞌíjca. ");
INSERT INTO crnNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","’Caxu siyen tiuꞌutaxájta yee aúcheꞌe teꞌáꞌatura aꞌachú cumu muáacua máxcɨraꞌi, sej si tiuꞌuréꞌatzaana. Ayee nu tejáꞌamuaꞌixaateꞌe, xaaseíj, seajta nainjapua huanéereajraꞌani aꞌujna mej aꞌutéꞌuu ɨ́ mej tíꞌihuasteꞌe. Jéihua mú huacuaínaviꞌijmee. Puꞌuri huaxɨ́ꞌepɨꞌɨn sej huáꞌajseɨreꞌen sej si tiuꞌutátuiireꞌen ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ajta íjii, puꞌuri raꞌancuréꞌasin jaꞌatɨ́ aꞌɨ́jna tɨ racɨꞌɨti, aꞌɨ́ɨ pu huáꞌajseɨreꞌesin mej mi miyen ruuri huateáturan tɨ́j naꞌa rusén jɨmeꞌe mej mi naíjmiꞌi miyen huataújtemuaꞌaveꞌen, aꞌɨ́jna ɨ́ tɨ tiuꞌuhuáste aꞌij tɨ Dios tiraaꞌíjca, ajta aꞌɨ́jna tɨ ayén tiuꞌuréꞌatza aꞌij tɨ ajta Dios tiraaꞌíjca. ");
INSERT INTO crnNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","’Aꞌɨ́j pu jɨ́n ayén tiꞌayajna aꞌij tɨ téꞌeyuꞌusiꞌi tɨ ayén tɨjɨ́n: “Aꞌɨ́ɨ pu raayɨ́ꞌɨtɨ tɨ tiuꞌuhuásteꞌen. Ajta aꞌɨ́ɨn ɨ́ seɨ́j ayée pu raayɨ́ꞌɨtɨ tɨ tiuꞌuréꞌatzaana.” ");
INSERT INTO crnNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ayee nu hui neꞌɨ́jna jɨ́n amuaataꞌítecaꞌa sej si siyen seꞌɨ́jna huaréꞌatzaana aꞌu sej caí tejaꞌuhuáste. Seica mú jeíhua huápɨꞌɨ tiuꞌumuárɨej. Seajta múꞌeen, aꞌɨ́j xu siyen ancuréꞌa ɨ́ mej raamuáꞌitɨ meꞌɨ́jna jɨmeꞌe ɨ́ mej tiuꞌumuárɨej. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Majta aꞌɨ́ɨme ɨ́ mej Samaria éꞌemeꞌecan, muꞌiitɨ́ mú ráꞌantzaahua meꞌɨ́jna jɨmeꞌe tɨ ayén tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨ jɨ́n Jesús nain tiraataꞌixaa aꞌij tɨ tiꞌitiújchaꞌɨɨcaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Aꞌɨ́j pu jɨ́n, meꞌɨ́n u eꞌiréꞌene ɨ́ jemin, matɨ́ꞌɨj mi jeíhua rájhuaviiriꞌi tɨ i aꞌɨ́ɨn aꞌuun aꞌuteáturan huáꞌa jamuan. Aꞌɨ́j pu jɨ́n, aꞌuun ayén éꞌetee huáꞌa jamuan aꞌachú cumu huaꞌapua xɨcaj. ");
INSERT INTO crnNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Majta jeíhua mú jaítzeꞌe ráꞌantzaahua ɨ́ Jesús meꞌɨ́jna jɨmeꞌe aꞌij tɨ tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ayee mú tiraataꞌixaa meꞌɨ́jna ɨ́ ꞌɨ́itaꞌa tɨjɨ́n: ―Amuacaí tu hui teꞌɨ́jna jɨ́n téꞌantzaahua teꞌɨ́jna jɨmeꞌe aꞌij pej penaꞌa peri titaatáꞌixaa. Teajta íjii, catu chéꞌe tiyen teꞌɨ́jna jɨ́n tenaꞌa téꞌantzaahuateꞌe sino tuꞌuri tiyen ráanamuajriꞌi tajɨ́ɨmuaꞌa. Teajta hui tiyen ramuaꞌaree tzáahuatiꞌiraꞌa jɨmeꞌe tɨ aꞌɨ́ɨn púꞌeen aꞌɨ́jna tɨ ayén téjmi japua niuuni tetɨ́j tenaꞌa puaꞌamé yen seijreꞌe chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tɨ́ꞌɨj teuuméꞌeca aꞌachú cumu huaꞌapua xɨcaj, aj puꞌi aꞌɨ́ɨn Jesús huirájraa aꞌujna. Aj puꞌi aꞌuun áꞌume ájtepua u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesús pu ayén huataújxajtacaꞌa ruseɨ́j mej nuꞌu caí rɨ́ꞌɨ tirájchaꞌɨɨ aꞌɨ́ɨme ɨ́ mej aꞌuun éꞌeche aꞌu tɨ ajta éꞌeche seɨ́j tɨ Dios jetze meꞌecan tíꞌixaxaꞌa. Aꞌɨ́j pu jɨ́n, huirájraa aꞌujna u Judea. ");
INSERT INTO crnNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Mɨ́ ajta aꞌɨ́ɨme ɨ́ mej Galilea éꞌemeꞌecan, temuaꞌa mú naa tiraꞌancuréꞌeviꞌitɨ tɨ́ꞌɨj aꞌɨ́ɨn huáꞌa jemi aꞌaráꞌa. Ayee muꞌu meri nain tiuꞌuséijracaꞌa aꞌij tɨ huarɨ́j aꞌɨ́jna ɨ́ Jesús tɨ́ꞌɨj aꞌuun aꞌutéveecaꞌa aꞌujna Jerusalén matɨ́ꞌɨj tíꞌiyestejcaꞌa aꞌájna xɨcájraꞌan tɨ jetzen Dios tihuaꞌutáꞌuuniꞌiriꞌi. Majta aꞌɨ́ɨme ɨ́ mej Galilea éꞌemeꞌecan, aꞌɨ́ɨ mú majta aꞌutéꞌuucaꞌa meꞌújna. ");
INSERT INTO crnNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ajta aꞌɨ́ɨn Jesús, aꞌɨ́ɨ pu ajtahuaꞌa huáꞌumuaarecaꞌa aꞌɨ́mej jemi ɨ́ mej meꞌuun eꞌechéjmeꞌe meꞌújna Caná, aꞌu tɨ ɨ́ jaj aꞌuteújviinutacaꞌa. Aꞌɨ́ɨ pu seɨcɨé ayén ráaruu, neꞌu. Ajta pu seɨ́j aꞌuun aꞌutéveecaꞌa tɨ tiꞌitɨ́j jɨ́n tiꞌitéveecaꞌa aꞌɨ́jna jemi ɨ́ rey. Ajta aꞌɨ́ɨn, seɨ́j pu tiyáujcaꞌa tɨ aꞌuun áꞌucatii aꞌujna Capernaúm. Tíꞌicuiꞌicaꞌa aꞌɨ́jna ɨ́ yaujraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tɨ́ꞌɨj aꞌɨ́ɨn jaꞌatɨ́ ayén ráamuaꞌareeriꞌi tɨ Jesús aꞌuun aꞌarájraa aꞌujna Judea, ajta núꞌu ari aꞌuun aꞌaráꞌa u Galilea, tɨꞌɨquí aꞌɨ́jna ɨ́ jaꞌatɨ u áꞌume ɨ́ jemin. Jéihua pu tirájhuaviiriꞌi tɨ aꞌɨ́ɨn Jesús aꞌuun áꞌumeꞌen aꞌɨ́jna jemi tɨ tíꞌicuiꞌi tɨ ij raarújteꞌen aꞌiné puꞌuri nuꞌu tɨ́muaꞌa mɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ayee pu Jesús tiraataꞌixaa, tɨjɨ́n: ―Caxu jaꞌanáj téꞌantzaahuateꞌesin tɨ puaꞌa necaí niyen tiꞌitɨ́j tejamuaataseíjrateꞌen ɨ́ sej jɨ́n rɨ́ꞌɨ tínaꞌutaseíj naꞌari tiꞌitɨ́j ɨ́ sej jɨ́n ráamuaꞌaree tɨ Dios ayén naatáꞌa nej niyen huárɨni. ");
INSERT INTO crnNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ajta aꞌɨ́ɨn tɨ tiꞌitɨ́j jɨ́n tiꞌitéveecaꞌa ɨ́ rey jemi, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, patáꞌaj piyen u áꞌumeꞌen neetzi jamuan, naꞌari caí, aꞌɨ́ɨ pu hui mɨꞌɨni ɨ́ niyauj. ");
INSERT INTO crnNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ajta Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Aricu aꞌu pej éꞌeche. Puꞌuri run ɨ́ ayauj. Ajta aꞌɨ́ɨn jaꞌatɨ́, aꞌɨ́ɨ pu ráꞌantzaahua aꞌij tɨ tiraataꞌixaa aꞌɨ́jna ɨ́ Jesús. Tɨꞌɨj jí áꞌuraa. ");
INSERT INTO crnNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tɨ́ꞌɨj ari á vejliꞌi auméꞌecaa aꞌɨ́jna ɨ́ jaꞌatɨ, aꞌɨ́ɨ mú raꞌantinájchecaꞌa ɨ́ mej ravaɨreꞌe. Ayee mú tiraataꞌixaa tɨ nuꞌu ari huarúj aꞌɨ́jna ɨ́ yaujraꞌan. ");
INSERT INTO crnNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Aj puꞌi ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌatzaj tɨ puaꞌa ayén huatéepuaꞌaj aꞌɨ́jna tɨ jɨ́n pɨ́stacaꞌa aꞌɨ́jna ɨ́ yaujraꞌan. Ayee mú tiraataꞌixaa tɨjɨ́n: ―Aꞌatzaj pu hui huatéepuaꞌaj ɨ́ tajcaí aꞌatzaj teꞌecáaráꞌa ɨ́ tacuarixpua. ");
INSERT INTO crnNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jɨ́meꞌen muꞌu miyen tiraataꞌixaa, aj puꞌi ráamuaꞌareeriꞌi aꞌɨ́jna ɨ́ yaꞌupuáaraꞌan tɨ ayén puaꞌa pɨ́tíꞌirɨjcaa aꞌatzaj tɨ puaꞌa Jesús ayén tiraataꞌixaa tɨ nuꞌu aꞌɨ́ɨn yaujraꞌan ari run. Aꞌɨ́j pu jɨ́n, huataújtuiitze ɨ́ tavástaraꞌa jemi. Majta aꞌɨ́ɨme ɨ́ teɨtestemuaꞌameꞌen, aꞌɨ́ɨ mú majta miyen huarɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ huaꞌapua tɨ ayén huápɨꞌɨ ruxeꞌeveꞌe tɨ ayén tiúꞌuruu aꞌɨ́jna ɨ́ Jesús aꞌujna jáꞌahuaꞌa u Galilea tɨ́ꞌɨj aꞌuun huirájraa u Judea. ");
INSERT INTO crnNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Puꞌuri aꞌatzu áꞌateeviꞌica matɨ́ꞌɨj tiuꞌuyéꞌeste aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan. Ajta aꞌɨ́ɨn Jesús, aꞌuun pu aꞌujnéj aꞌánna Jerusalén. ");
INSERT INTO crnNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","3","Aꞌuun pu jéjmuaa aꞌájna vejliꞌi taꞌáa puéerta aꞌu mej jetzen aꞌuteáruꞌipi ɨ́ cáneꞌaxɨ. Ayee pu téjaꞌarájtehuaa tɨjɨ́n Betesda. Anxɨ́vi pu áꞌaportaalijmeꞌecaa aꞌu mej eꞌetiújseꞌɨrihuaꞌa jeíhua teɨte ɨ́ mej tíꞌicucuiꞌicaꞌa. Seica mú miyen aracúcuꞌunijmeꞌecaꞌa, majta seica, aꞌij puaꞌa mú huatzúnaꞌicheꞌe, majta seica cɨyáaxaviꞌicaa ɨ́ huáꞌɨɨca. ");
INSERT INTO crnNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aꞌɨ́ɨ mú miyen rachúꞌeveꞌecaꞌa tɨ ij jaꞌatɨ́ ayén raꞌutáruureajxɨꞌɨn ɨ́ jaj, aꞌiné jaꞌanáj tɨ naꞌa, ayée pu rɨjcaa seɨ́j tɨ júteꞌe tíꞌivaɨreꞌe Dios tɨ éꞌeseijreꞌe. Aꞌɨ́ɨ pu aveꞌecánineicaꞌa aꞌájna tɨ jéjmuaa, tɨ ij aꞌɨ́ɨn raꞌutáruureajxɨꞌɨn. Ajta aꞌɨ́ɨn jaꞌatɨ́ tɨ amuacaí ateájraꞌani ɨ́ jaj tzajtaꞌa, aꞌɨ́ɨ pu ayén run tɨ́j naꞌa tɨ jɨ́n tíꞌicuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Meenti seɨ́j aꞌuun aꞌutéveecaꞌa tɨ ayén ari áꞌatee aꞌachú cumu seité japuan tamuáamuataꞌa japuan aráhuaica nineꞌiraꞌa tɨ ayén tíꞌicuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tɨ́ꞌɨj i Jesús ayén raaseíj tɨ aꞌuun aúucaꞌatii, ayée pu ráamuaꞌareeriꞌi tɨ aꞌɨ́ɨn nuꞌu jaꞌatɨ́ ari áꞌatee tɨ ayén ꞌeen. Aj puꞌi ayén tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni piyen tíꞌijxeꞌeveꞌe pej huarún? ");
INSERT INTO crnNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ajta aꞌɨ́ɨn tɨ tíꞌicuiꞌi, ayée pu tiuꞌutaniú tɨjɨ́n: ―Nevástaraꞌa, tɨ́ꞌɨj ayén raꞌutáruureajxɨꞌɨn ɨ́ jaj, capu hui méꞌe jaꞌatɨ́ tɨ naatévaɨreꞌen nej ni ateájraꞌani ɨ́ jaj tzajtaꞌa. Ajta, netɨ́ꞌɨj nauj á áꞌumeꞌen, seɨ́j pu hui caꞌanacan aꞌuun ateeme nej caí inee. ―Ayee pu tiraataꞌixaa aꞌɨ́jna tɨ tíꞌicuiꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Aj puꞌi Jesús ayén tiraataꞌixaa tɨjɨ́n: ―Ájchesi. Anchuée mɨ áꞌutaatzi. Pajta hui áꞌuraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jɨ́meꞌen puꞌu ayén tiuꞌutaxájtacaꞌa, aj puꞌi aꞌɨ́ɨn jaꞌatɨ́ huarúj. Ajta yáꞌuchuii ɨ́ rúꞌutaatzi. Tɨꞌɨj jí áꞌuraa. Ajta aꞌájna pɨ́tíꞌirɨjcaa aꞌájna xɨcájraꞌa mej jetzen ruseꞌupi tɨ́ꞌɨj huarúj. ");
INSERT INTO crnNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ajta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, ayée mú tiraataꞌixaa meꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén huarúj tɨjɨ́n: ―Puꞌuri hui aꞌájna pɨ́tíꞌirɨcɨ ɨ́ xɨcájraꞌan tej jetzen taseꞌupi. Ajta ayée pu téꞌeyuꞌusiꞌi aꞌɨ́jna jetze ɨ́ yuꞌuxari tɨ ayén tíꞌitaꞌaijteꞌe tɨ nuꞌu caí aꞌij tíꞌirɨꞌɨri pej piyen ráachuisimeꞌen mɨ áꞌutaatzi íjii. ");
INSERT INTO crnNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ajta aꞌɨ́ɨn tɨ cɨyáaxaraꞌacaꞌa, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee pu tinaatáꞌixaa aꞌɨ́jna tɨ naarújte tɨjɨ́n yee nej nuꞌu ráꞌanchueeni ɨ́ neꞌutaatzi, neajta nuꞌu u áꞌuraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌataani púꞌeen aꞌɨ́jna ɨ́ jaꞌatɨ tɨ ayén timuaatáꞌixaa pej nuꞌu piyen ráꞌanchueeni, pajta nuꞌu áꞌuraꞌani? ");
INSERT INTO crnNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ́ tɨ ayén huarúj, capu aꞌatzu ramuaꞌatejcaꞌa jaꞌatɨ́ tɨ puꞌeeneꞌe, aꞌiné aꞌɨ́jna ɨ́ Jesús puꞌuri á aúurutecaꞌa huáꞌa tzajtaꞌa ɨ́ teɨte ɨ́ mej meꞌuun eꞌetiújseɨreꞌecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tɨꞌɨj jí Jesús aꞌuun yáꞌuteu aꞌujna teyujtaꞌa. Ayee pu tiraataꞌixaa tɨjɨ́n: ―Meꞌecui xaa, pepuꞌuri huarúj. Pecáj chéꞌe tiꞌitɨ́j jɨ́n aꞌaturáa ɨ́ Dios jemi. Naꞌari caí, ayée pu tejaꞌuréꞌenejsin tɨ jaítzeꞌe puaíjtzi muáacɨꞌɨti caí ajmíꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Aj puꞌi áꞌuraa aꞌɨ́jna ɨ́ jaꞌatɨ. Ajta ayée pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecan tɨ aꞌɨ́ɨn Jesús aꞌɨ́ɨn púꞌeeneꞌe tɨ ayén raarújte. ");
INSERT INTO crnNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Majta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, ayée mú ꞌeen jɨ́n aꞌij puaꞌa raruurejcaꞌa meꞌɨ́jna ɨ́ Jesús meꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn ayén rɨjcaa aꞌájna xɨcájraꞌa mej jetzen ruséꞌupihuaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame, aꞌɨ́ɨ pu auj tíꞌimuarɨꞌe ɨ́ niyáꞌupua. Ayee nu cheꞌatá nenaꞌa inee tíꞌimuarɨꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ayee mú ꞌeen jɨ́n jaítzeꞌe miyen tíꞌiteseꞌecaꞌa mej mi raajéꞌica meꞌɨ́jna jɨmeꞌe tɨ nuꞌu ayén Jesús raatéxɨeehuatacaꞌa tɨ ayén huárɨni aꞌij mej tíꞌijrɨꞌɨre aꞌájna xɨcájraꞌan jetze mej ruséꞌupihuaꞌa. Aꞌɨ́ɨ pu ajta nuꞌu ayén ratamuáꞌamuaꞌateꞌe ɨ́ Dios tɨ nuꞌu yaꞌupuáaraꞌan púꞌeen. Aꞌɨ́j pu nuꞌu jɨ́n ayén tiúꞌujseijratacaꞌa tɨ ayén cheꞌatá naꞌa ꞌeen tɨ́j ɨ́ Dios. ");
INSERT INTO crnNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ayee pu tiuꞌutaniú aꞌɨ́jna ɨ́ Jesús tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, capu rɨꞌɨrí nej niyen tiꞌitɨ́j huáruuren neseɨ́j, i nej neajta teáataꞌa jetze airáane. Ayee nu cheꞌatá nenaꞌa tíꞌiruure aꞌij nej tíꞌisiseꞌij tɨ ayén tíꞌiruure ɨ́ niyáꞌupua. ");
INSERT INTO crnNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ayee pu ɨ́ niyáꞌupua nexɨ́ꞌeveꞌe ineetzi i nej yaujraꞌan púꞌeen. Aꞌɨ́ɨ pu ajta tíꞌineseijrateꞌe nain aꞌij tɨ aꞌɨ́ɨn tíꞌiruure. ’Jee xaa neꞌu, ayée pu tinaataseíjrateꞌesin tiꞌitɨ́j tɨ jaítzeꞌe huápɨꞌɨ ruxeꞌeveꞌe caí aꞌij nej neri tiúꞌuruu sej si temuaꞌa naa tiraꞌutaseíj. ");
INSERT INTO crnNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ayee pu hui niyáꞌupua huaꞌajjájpuaxɨꞌɨsin ɨ́ teɨte huáꞌa tzajtaꞌa ɨ́ mej meri huácuii. Aꞌɨ́ɨ pu ajta huaꞌutáꞌasin mej mi majtáhuaꞌa ruuri muáꞌaraꞌani. Ayee nu cheꞌatá nenaꞌa huaꞌutáꞌasin aꞌachú puaꞌamé aꞌɨ́ɨme tɨ ayén naꞌaráanajche nej niyen huaꞌutáꞌan mej mi majtáhuaꞌa ruuri muáꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","’Ajta yeehui aꞌɨ́ɨn niyáꞌupua, capu jaꞌatɨ́ áꞌaxɨjteꞌe sino puꞌuri ayén nain jɨ́n tinaaꞌíjca ineetzi, i nej yaujraꞌan púꞌeen nej ni naíjmiꞌica aꞌuxɨ́jteꞌen. ");
INSERT INTO crnNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ayee pu ꞌeen jɨ́n huarɨ́j ɨ́ niyáꞌupua mej mi miyen cheꞌatá menaꞌa rɨ́ꞌɨ tinaatáꞌan ineetzi matɨ́j majta rɨ́ꞌɨ tiratáꞌaca meꞌɨ́jna ɨ́ niyáꞌupua. Ajta, aꞌɨ́ɨn tɨ caí rɨ́ꞌɨ tinaatáꞌaca ineetzi, i nej yaujraꞌan púꞌeen, aꞌɨ́ɨ pu ajta caí rɨ́ꞌɨ tiraatáꞌaca ɨ́ niyáꞌupua tɨ íiyen nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe, jaꞌatɨ́ tɨ naꞌa tɨ ayén ranamua aꞌij nej tiꞌixa, ajta tɨ ayén raꞌaráꞌastijreꞌen aꞌɨ́jna tɨ yen nejaꞌutaꞌítecaꞌa, aꞌɨ́jna ɨ́ jaꞌatɨ, ayée pu ruurican jɨ́n huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. Capu jaꞌanáj puaíjtzi racɨꞌɨti aꞌiné aꞌɨ́ɨ pu ari huirájraa aꞌu tɨ ayén tiyeꞌecɨꞌɨtíicheꞌe tɨ huámɨꞌɨni. Aꞌɨ́ɨ pu ajta ari aꞌuun aꞌuteájrupi aꞌu tɨ ayén yéꞌecɨꞌɨti tɨ ruuri áꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","’Ayee nu tzáahuatiꞌiraꞌa jɨ́n tejáꞌamuaꞌixaateꞌe. Ayee pu tejaꞌuréꞌenejsin, jee xaa neꞌu. Ayee pu ari tejaꞌuréꞌene aꞌájna xɨcájraꞌan tɨ jetzen ayén tihuáꞌacɨꞌɨti aꞌɨ́mej ɨ́ mej meri huácuii mej mi miyen ráanamua aꞌij nej tiꞌixa inee, i nej yaujraꞌan púꞌeen ɨ́ Dios. Majta aꞌɨ́ɨme ɨ́ mej miyen raꞌancuréꞌasin aꞌij mej tíꞌijnamuajran, aꞌɨ́ɨ mú rusén jɨmeꞌe ruuri muáꞌajuꞌu. ");
INSERT INTO crnNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","’Aꞌiné ru jetze pu ayén rusén jɨ́n ruuri ɨ́ Dios, aꞌɨ́ɨ pu ayén naatáꞌa ineetzi i nej yaujraꞌan púꞌeen nej ni niyen cheꞌatá nenaꞌa ne jetze rusén jɨ́n ruuri. ");
INSERT INTO crnNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aꞌɨ́ɨ pu hui ajta naatáꞌa nej ni neꞌɨ́jna jɨ́n antínmuaꞌaréere náꞌaraꞌani nej ni huaꞌuxɨ́jteꞌen ɨ́ teɨte aꞌiné nee nu neajta teáataꞌa jetze airánneijte. ");
INSERT INTO crnNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","’Caxu seꞌɨ́jna jɨ́n rɨ́ꞌɨ tiyéꞌuseijra, aꞌiné aj pu tejaꞌuréꞌenejsin matɨ́j menaꞌa puaꞌamé ɨ́ mej meri huácuii, ayée mú ranamuajran netɨ́ꞌɨj huaꞌutájeeve. ");
INSERT INTO crnNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Aꞌuu mú eꞌitajúꞌun aꞌu mej eꞌevéꞌenámiꞌihuajmee. Majta aꞌɨ́ɨme, ɨ́ mej rɨ́ꞌɨ titetiújchaꞌɨɨcaꞌa, aꞌɨ́ɨ mú eꞌitajúꞌun mej mi ruuri muáꞌaraꞌani. Mɨ́ majta aꞌɨ́ɨme ɨ́ mej aꞌij puaꞌa titetiújchaꞌɨɨcaꞌa, aꞌɨ́ɨ mú eꞌitajúꞌun nej ni niyen huaꞌuxɨ́jteꞌen tɨ ij ayén puaíjtzi tihuáꞌacɨꞌɨti. ");
INSERT INTO crnNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Capu rɨꞌɨrí nej niyen tiꞌitɨ́j huáruuren neseɨ́j nenaꞌa, sino ayée nu cheꞌatá nenaꞌa huáꞌaxɨjteꞌe aꞌij nej tíꞌijnamua ɨ́ niyáꞌupua jemi. Ajta, ayée pu tiraavíjteꞌe aꞌij nej tihuáꞌaxɨjteꞌe aꞌiné canu niyen rahuauca nej niyen rɨcɨ aꞌij tɨ tinaꞌaráanajche sino ayée nu rɨcɨ nej ni niyen rɨ́ꞌɨ tiraatáꞌan aꞌɨ́jna tɨ yen nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","’Tɨ́ puaꞌa neseɨ́j nenaꞌa niyen tiuꞌutánxaj, canu niyen tzáahuatiꞌiraꞌa jɨ́n niyen tiuꞌutánxajta. ");
INSERT INTO crnNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mɨ́ ajta, seɨ́j pu ayén tineetéxajta ineetzi, neajta inee, ayée nu ramuaꞌaree tɨ́j naꞌa aꞌij tɨ tíꞌinexa ineetzi, ayée pu tzáahuatiꞌiraꞌa jɨ́n tíꞌinexa aꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","’Múꞌeen xu seica huataꞌáitecaꞌa ɨ́ Juan jemi. Aꞌɨ́ɨ pu ajta tzáahuatiꞌiraꞌa jɨ́n tejámuaatáꞌixaa ineetzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Capu hui ayén ruxeꞌeveꞌe tɨ jaꞌatɨ́ ayén tíꞌinexajta ineetzi. ’Mɨ́ neajta, ayée nu tejáꞌamuaꞌixaateꞌe neꞌɨ́jna jɨmeꞌe ɨ́ Juan tɨ ij Dios ayén tejámuaatáꞌuuniꞌi. ");
INSERT INTO crnNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ayee pu aꞌatzu tiuꞌutévaɨ aꞌɨ́jna ɨ́ Juan tɨ́j tatzari tɨ áꞌataa, tɨ ajta nain japua huatátzaveꞌejyeꞌi. Seajta múꞌeen, ayée xu aꞌatzu huataúraꞌa sej siyen huataújtemuaꞌaveꞌen seꞌɨ́jna jɨmeꞌe sej raꞌancuréꞌa aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","’Tiꞌitɨ́ pu jaítzeꞌe ruxeꞌeveꞌe caí aꞌij tɨ tiuꞌutaxájtacaꞌa aꞌɨ́jna ɨ́ Juan. Aꞌɨ́jna tɨ Dios ayén jɨ́n tinaaꞌíjca nej ni niyen neꞌɨ́jna jɨ́n teꞌaráꞌasten ɨ́ nej neri niyen neꞌɨ́jna jɨ́n rɨcɨ, aꞌɨ́ɨ pu ajta tíꞌivaɨreꞌe sej si siyen ráamuaꞌaree tɨ ayén nejaꞌutaꞌítecaꞌa aꞌɨ́jna ɨ́ niyáꞌupua. ");
INSERT INTO crnNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ajta aꞌɨ́ɨn ɨ́ niyáꞌupua tɨ ayén nejaꞌutaꞌítecaꞌa, aꞌɨ́ɨ pu ajta naatéxajtacaꞌa ineetzi jɨmeꞌe. Múꞌeen xu caí jaꞌanáj ráanamuajriꞌi tɨ tiuꞌuxájtacaꞌa. Caxu seajta jaꞌanáj rujɨ́ꞌɨ jɨ́n raaseíj aꞌij tɨ ꞌeen. ");
INSERT INTO crnNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Caxu seajta raꞌancuréꞌasin aꞌij tɨ aꞌɨ́ɨn tiuꞌutaxájtacaꞌa aꞌiné caxu naꞌaráꞌastijreꞌesin ineetzi, Dios tɨ nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","’Múꞌeen xu aujcaꞌaneecan jɨ́n tiúꞌujmuaꞌate seꞌɨ́jna jetze ɨ́ yuꞌuxari aꞌiné ayée pu tejamuáꞌamitɨejteꞌe sej seꞌɨ́jna jetze yaúꞌitɨee xáꞌajuꞌun aꞌij sej yeꞌí huárɨni sej si rusén jɨ́n ruuri xáꞌaraꞌani. Aꞌii pu hui aꞌɨ́ɨn púꞌeen ɨ́ yuꞌuxari tɨ jetzen téꞌeyuꞌusiꞌi aꞌij mej tiuꞌutaxájtacaꞌa ineetzi jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","’Mɨ́ seajta múꞌeen, caxu áꞌujcaꞌane sej siyen naꞌaráꞌastijreꞌen ineetzi nej ni amuaatáꞌan sej si rusén jɨ́n ruuri xáꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Capu ne jetze ruxeꞌeveꞌe tɨ puaꞌa tevi ayén rɨ́ꞌɨ tinaatáꞌan. ");
INSERT INTO crnNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mɨ́ seajta múꞌeen seɨcɨé xu tíꞌimuaꞌatze. Nee nu niyen ramuaꞌaree sej caí hui raxɨ́ꞌeveꞌe ɨ́ Dios ɨ́ aꞌamua tzajtaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","’Ayee nu ꞌeen jɨ́n aveꞌecáane niyáꞌupua jetze meꞌecan. Mɨ́ seajta múꞌeen, caxu naꞌancuréꞌeviꞌitɨ. Aru tɨ puaꞌa jaꞌatɨ́ runiúucajtzeꞌen jɨ́n mú aꞌuvéꞌemeꞌen, múꞌeen xu xaa raꞌancuréꞌeviꞌitɨ seꞌɨ́jna. ");
INSERT INTO crnNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","’¿Aꞌiné tíꞌirɨꞌɨri sej tzáahuatiꞌiraꞌa jɨ́n téꞌantzaahuateꞌen tɨ́ puaꞌa siyen rɨ́ꞌɨ tiuꞌutaúraꞌan rujɨ́ɨmuaꞌa senaꞌa, seajta caí tíꞌiteseꞌe sej ráahuauni tɨ Dios rɨ́ꞌɨ tejamuaatáꞌan? Capu xaa neꞌu aꞌij tíꞌirɨꞌɨri. ");
INSERT INTO crnNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Caxu siyen múꞌeen tíꞌimuaꞌatze nej tejáꞌamuaxajtziꞌiran ɨ́ niyáꞌupua jemi. Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ tɨ tejáꞌamuaxajtziꞌiran aꞌɨ́jna ɨ́ Moisés teecan, ɨ́ sej siyen rachúꞌeveꞌe tɨ aꞌɨ́ɨn aꞌamua japua niuuni. ");
INSERT INTO crnNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","’Tɨ́ puaꞌa siyen téꞌatzaahuateꞌe seꞌɨ́jna jemi ɨ́ Moisés, ayée xu seajta náꞌantzaahuateꞌencheꞌe ineetzi seꞌɨ́jna jɨmeꞌe tɨ aꞌɨ́ɨn ayén neetzi jɨmeꞌe raꞌutéyuꞌuxacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","¿Aꞌiné sej si caí ráꞌatzaahuateꞌe aꞌij tɨ aꞌɨ́ɨn tiraꞌutéyuꞌuxacaꞌa? ¿Aꞌiné tíꞌirɨꞌɨri sej siyen ráꞌantzaahuateꞌen aꞌij nej inee tejámuaatáꞌixaateꞌesin? Capu xaa neꞌu aꞌij tíꞌirɨꞌɨri. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Aꞌatzu aꞌateeviꞌi, tɨꞌɨquí Jesús aꞌuun u jetze pújmeꞌen antáraa ɨ́ jaj japua tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Galilea. Ayee pu ajta téjaꞌarájtehuaa tɨjɨ́n Tiberias. ");
INSERT INTO crnNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jéihua mú teɨte aꞌucɨ́j jamuan aꞌiné muꞌuri raaseíj meꞌɨ́jna tɨ huápɨꞌɨ ruxeꞌeveꞌe tɨ ayén tihuáꞌuhuaa aꞌɨ́mej ɨ́ mej tíꞌicucuiꞌicaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aj puꞌi Jesús aꞌánna aꞌujnéj jɨrí japua. An pu aꞌutayéijxɨ, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Puꞌuri vejliꞌitacaꞌa aꞌájna xɨcájraꞌan mej jetzen tíꞌiyestehuaꞌa meꞌɨ́jna jɨmeꞌe tɨ Dios huaꞌirájtuaa aꞌɨ́mej ɨ́ mej Israél jetze ajtémeꞌecantacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tɨꞌɨj jí Jesús ayén huanéereajraa. Tɨ́ꞌɨj i huaꞌuseíj mej eꞌevéꞌejuꞌucaꞌa ɨ́ teɨte. Aj puꞌi Jesús aꞌɨ́ɨn Felipe ayén tiuꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Aꞌuné teyéꞌenanan ɨ́ pan ɨ́ mej racuaꞌani aꞌɨ́ɨme ɨ́ teɨte? ");
INSERT INTO crnNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Puꞌuri ramuaꞌareerecaꞌa ɨ́ Jesús aꞌij tɨ rɨni. Mɨ́ ajta, ayée pu ꞌeen jɨ́n raataꞌíhuaꞌuriꞌi ɨ́ Felipe tɨ ij ayén raaseíj aꞌij tɨ rɨni. ");
INSERT INTO crnNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe pu ayén tiuꞌutaniú tɨjɨ́n: ―Tɨ́ puaꞌa tiyen tíꞌituaaveꞌe aꞌachú mej ramuáꞌitɨjca aráhuaica máxcɨraꞌi jɨmeꞌe, capu aꞌɨ́ɨ naꞌa cɨꞌɨpe tej ti pan huánanan tej ti naíjmiꞌica tiuꞌumín. ");
INSERT INTO crnNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Aj puꞌi seɨ́j tɨ jamuan áꞌucheꞌecaneꞌe, aꞌɨ́jna ɨ́ Andrés tɨ juutzeájraꞌan púꞌeen ɨ́ Simón, aꞌɨ́ɨ pu ayén tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Yé pu paꞌarɨꞌɨ huatéjvee. Anxɨ́vica pu hui pan tíchaꞌɨɨ, ajta huaꞌapuaca ɨ́ huaꞌité. Mɨ́ ajta, capu aꞌatzu cɨꞌɨpe mej mi naímiꞌi tiúꞌucuaꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Setáꞌaj huaꞌutaꞌaíjteꞌen ɨ́ teɨte mej aꞌujráꞌasixɨꞌɨn. Ayee pu ꞌeen jɨ́n ayén raataxájtacaꞌa aꞌiné jeíhua pu huáꞌɨxaataꞌacaꞌa aꞌujna. Majta aꞌɨ́ɨme ɨ́ teteca, aꞌúu mú aꞌuráaseajraa. Ayee mú aráꞌasijmeꞌe aꞌachú cumu anxɨ́j viꞌiraꞌa méyee majta méyee. ");
INSERT INTO crnNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Aj puꞌi Jesús raꞌancuréꞌeꞌɨꞌɨpɨ ɨ́ pan. Ajta rɨ́ꞌɨ tiraatateújtziꞌire ɨ́ Dios jemi. Ajta huaꞌuréꞌeꞌɨꞌɨpɨꞌɨ aꞌɨ́mej ɨ́ mej aꞌucaíjmeꞌecaa aꞌachú tɨ seɨ́j raxɨ́ꞌeveꞌecaꞌa. Ayee pu cheꞌatá naꞌa huaꞌuréꞌeꞌɨꞌɨpɨꞌɨ ɨ́ huaꞌité. ");
INSERT INTO crnNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Matɨ́ꞌɨj ruxɨéehua tiúꞌucuaa, ayée pu tihuaꞌutáꞌixaa aꞌɨ́mej ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Setáꞌaj raaréꞌeꞌɨꞌɨpɨꞌɨn ɨ́ tɨ avéꞌeturaa. Chéꞌe caí tiꞌitɨ́j aꞌuváꞌɨtzɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Matɨ́ꞌɨj mi raaréꞌeꞌɨꞌɨpɨꞌɨ. Ayee mú teꞌevéꞌejɨsteꞌaxɨ ɨ́ sicɨ́ri jetze aꞌɨ́jna ɨ́ pan tɨ avéꞌeturaa mej tiúꞌucuaa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Majta aꞌɨ́ɨme ɨ́ teɨte, matɨ́ꞌɨj miyen raaseíj meꞌɨ́jna ɨ́ Jesús tɨ ayén huarɨ́j, ayée mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―Ayej xaa neꞌu tiꞌayajna, amɨ́ pu hui aꞌɨ́ɨn púꞌeen aꞌɨ́jna tɨ Dios jetze meꞌecan tíꞌixaxaꞌa, tɨ ayén yé nuꞌu uvéꞌenejsin íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ajta aꞌɨ́ɨn Jesús, ayée pu rúꞌumuaꞌareerecaꞌa ɨ́ ru tzajtaꞌa mej miyen raaxɨ́ꞌepɨꞌɨntare mej aꞌireꞌenejsin mej mi caꞌanéeri jɨ́n tiraaꞌíjcateꞌen tɨ aꞌɨ́ɨn teꞌenteárute ɨ́ rey jɨmeꞌe. Aꞌɨ́j pu jɨ́n, ayén ajtáraa. Aꞌuu pu jɨrí japua aꞌujnéj ruseɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tɨ́ꞌɨj huaréꞌecɨéenajmeꞌeca, aꞌúu mú aꞌucáane aꞌutɨ́ eꞌeveꞌeꞌástɨme ɨ́ jaj aꞌɨ́ɨme ɨ́ mej Jesús jamuan áꞌujujhuaꞌaneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Aꞌuu mú baarcu jetze atéecɨ. Matɨ́ꞌɨj mi antacɨ́j u jetze pújmeꞌen u Capernaúm. Puꞌuri huaréꞌetɨcaꞌarijmeꞌe. Ajta aꞌɨ́ɨn Jesús, capu méꞌe jáꞌahuaꞌacaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Caꞌanín pu jɨ́n huáꞌeecacaꞌa. Ajta puꞌuri áꞌujruurejcaꞌa ɨ́ jaj. ");
INSERT INTO crnNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Matɨ́ꞌɨj aujúꞌucaa aꞌachú anxɨ́j, o arájsevi kilómetros, matɨ́ꞌɨj mi raaseíj tɨ eꞌevéꞌemeꞌecaa aꞌɨ́jna ɨ́ Jesús. Jaj japua pu huaméꞌecaa. Jéꞌecan mú tiuꞌutátziɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Aj puꞌi ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Nee nu aꞌɨ́ɨn púꞌeen. Caxu tíꞌitziɨɨneꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Matɨ́ꞌɨj mi miyen huateújcaꞌane mej mi miyen raꞌateájtuaani ɨ́ baarcu jetze. Camu aꞌachú aꞌateeviꞌi meꞌuun aꞌutanéj aꞌájna aꞌu mej aꞌujuꞌucaa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Majta aꞌɨ́ɨme ɨ́ teɨte ɨ́ mej aꞌuun u jetze pújmeꞌen eꞌetiújseɨj ɨ́ Jesús jemi, aꞌɨ́ɨ mú aꞌuun aꞌuteájturaa. Yee ruijmuaꞌa yee, ayée pu tihuáꞌamitɨejteꞌecaꞌa tɨ seɨ́j naꞌa eꞌecáveꞌecaꞌa ɨ́ baarcu, ajta tɨ aꞌɨ́ɨn Jesús caí aꞌɨ́jna jetze ateájraa huáꞌa jamuan ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe, sino rujɨ́ɨmuaꞌa muꞌu antacɨ́j. ");
INSERT INTO crnNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Matɨ́ꞌɨj mi seica meꞌuun újhuiixɨ ɨ́ baarcu aꞌájna vejliꞌi aꞌu mej tejáꞌucuaa ɨ́ teɨte tɨ́ꞌɨj Jesús rɨ́ꞌɨ tiraatáꞌa ɨ́ Dios. Aꞌuu pu éꞌemeꞌecan ɨ́ baarcu, chajtaꞌa tɨ ayén téjaꞌarájtehuaa tɨjɨ́n Tiberias. ");
INSERT INTO crnNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Matɨ́ꞌɨj mi aꞌɨ́ɨme teɨte miyen ráamuaꞌareeriꞌi tɨ nuꞌu caí ajta aꞌuun áꞌucatii u Tiberias aꞌɨ́jna ɨ́ Jesús, majta aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe. Matɨ́ꞌɨj mi meꞌɨ́jna jetze atéecɨjxɨ aꞌɨ́jna jetze ɨ́ baarcu tɨ tiꞌimuꞌíi. Seica mú atéecɨjxɨ seɨ́j jetze, majtáhuaꞌa ɨ́ seica, seɨ́j jetze mú mijta atéecɨ, mej mi meꞌuun aꞌatanén u Capernaúm, mej mi meꞌuun ráahuauni meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Matɨ́ꞌɨj ráateu meꞌújna u jetze pújmeꞌen aꞌalaguun jetze, aj mú mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―Rabí, ¿aꞌanajni yé peráꞌa peyujna? ");
INSERT INTO crnNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe. Caxu seꞌɨ́jna jɨ́n nehuauhuau seꞌɨ́jna jɨ́n sej tiuꞌuséij aꞌij nej huarɨ́j ɨ́ sej jɨ́n aꞌij teꞌutaseíj sino ayée xu ꞌeen jɨ́n nehuauhuau seꞌɨ́jna jɨmeꞌe sej ráacua seꞌɨ́jna ɨ́ pan, seajta sej temuaꞌa naa titéejuꞌuxai. ");
INSERT INTO crnNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Caxu siyen senaꞌa tiuꞌumuárɨꞌen sej si seꞌɨ́jna huamuáꞌitɨn ɨ́ cuaꞌira tɨ aꞌuvaɨ́jtzi sino setáꞌaj siyen tiuꞌumuárɨꞌen sej si seꞌɨ́jna huamuáꞌitɨn ɨ́ sej jɨ́n huateújvaɨreꞌen tɨ́j naꞌa rusén jɨmeꞌe. Neajta inee, i nej neajta teáataꞌa jetze airánneijte, nee nu neꞌɨ́jna amuaatáꞌasin aꞌiné aꞌɨ́ɨn Dios tɨ niyáꞌupua púꞌeen, aꞌɨ́ɨ pu aꞌɨ́jna jɨ́n tinaaꞌíjca. ");
INSERT INTO crnNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni hui ruxeꞌeveꞌe tej tiyen teꞌɨ́jna jɨ́n huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios? ");
INSERT INTO crnNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús pu ayén tiuꞌutaniú tɨjɨ́n: ―Ayee pu tíꞌijxeꞌeveꞌe ɨ́ Dios sej siyen náꞌantzaahuateꞌen ineetzi tɨ Dios nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Matɨ́ꞌɨj mi miyen tiraataꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Tiꞌitájni jɨ́n piyen rɨcɨ tɨ huápɨꞌɨ ruxeꞌeveꞌe tej ti tiyen raaseíj, tej ti teꞌɨ́jna jɨ́n muáꞌantzaahuateꞌenɨ ɨAꞌiné pej pi piyen rɨcɨ? ");
INSERT INTO crnNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tavaújsimuaꞌacɨꞌɨ mú miyen ráacua meꞌɨ́jna tɨ nuꞌu maná púꞌeen meꞌújna aꞌu tɨ caí éꞌetiꞌitɨjcaꞌa. Ayee pu téꞌeyuꞌusiꞌi tɨjɨ́n: “Aꞌɨ́ɨ pu nuꞌu huaꞌutáꞌa mej meꞌɨ́jna huácuaꞌani ɨ́ cuaꞌira tɨ nuꞌu júteꞌe éꞌemeꞌecan.” ");
INSERT INTO crnNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe tɨ caí aꞌɨ́ɨn púꞌeen ɨ́ Moisés teecan tɨ ayén huaꞌutáꞌa aꞌɨ́ɨme áꞌamuayaꞌupuacɨꞌɨstemuaꞌa mej ráacuaꞌani ɨ́ cuaꞌira tɨ júteꞌe éꞌemeꞌecan. Capu xaa neꞌu, sino niyáꞌupua pu ayén amuaatáꞌasin sej si huateújvaɨreꞌen seꞌɨ́jna jɨmeꞌe ɨ́ cuaꞌira tɨ tzáahuatiꞌiraꞌa jɨ́n júteꞌe éꞌemeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","’Aꞌiné nee nu aꞌɨ́ɨn púꞌeen ɨ́ cuaꞌira tɨ Dios jemi éꞌemeꞌecan, neetzi pu jemi ajta éꞌemeꞌecan. Nee nu júteꞌe eꞌicaanej nej ni huaꞌutáꞌan mej ruuri muáꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe matɨ́j menaꞌa puaꞌamé yen huachéjme íiyen chaanaca japua. ");
INSERT INTO crnNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Matɨ́ꞌɨj mi miyen tiraataꞌixaa tɨjɨ́n: ―Tavastaraꞌa, patáꞌaj piyen taatáꞌan peꞌɨ́jna ɨ́ cuaꞌira tɨ́j naꞌa tɨ yú aucaꞌitɨ́ aꞌame. ");
INSERT INTO crnNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aj puꞌi Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Nee nu aꞌɨ́ɨn púꞌeen ɨ́ tɨ jetzen éꞌemeꞌecan ɨ́ cuaꞌira ɨ́ mej jɨ́n huateújvaɨreꞌen mej mi ruuri muáꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe. Jaꞌatɨ́ tɨ naꞌa tɨ neetzi jemi veꞌeréꞌenen, capu jaꞌanáj iꞌicuatá aꞌame. Ajta, jaꞌatɨ́ tɨ naꞌa tɨ ayén naꞌaráꞌastijreꞌen ineetzi, capu ajta jaꞌanáj huataꞌíꞌimɨ, sino Dios pu rusén jɨ́n raatáꞌasin. ");
INSERT INTO crnNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","’Neajta inee, ayée nu neri tejámuaatáꞌixaa sej seri neseij ineetzi. Mɨ́ seajta múꞌeen, caxu téꞌatzaahuateꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Matɨ́j menaꞌa puaꞌamé ɨ́ tɨ Dios naatátuiireꞌesin, aꞌɨ́ɨme mú veꞌeréꞌenejsin ineetzi jemi. Ajta tɨ puaꞌa jaꞌatɨ́ ayén neetzi jemi veꞌeréꞌenen, canu jaꞌanáj raaréꞌiti. ");
INSERT INTO crnNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","’Canu neꞌɨ́jna jɨ́n mú aꞌuvéꞌemej nej ni niyen huárɨni aꞌij nej neseɨ́j nenaꞌa tíꞌijxeꞌeveꞌe sino nej ni niyen huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe aꞌɨ́jna tɨ yen nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ajta, ayée pu tíꞌijxeꞌeveꞌe aꞌɨ́jna tɨ yen nejaꞌutaꞌítecaꞌa tɨ caí seɨ́j áꞌuveti aꞌɨ́ɨme ɨ́ mej veꞌeréꞌene ineetzi jemi sino nej ni naíjmiꞌica japua huániuuni aꞌájna xɨcájraꞌan tɨ jetzen nain jɨ́n teꞌentipuáꞌajte. ");
INSERT INTO crnNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","’Jee xaa neꞌu, ayée pu tíꞌijxeꞌeveꞌe ɨ́ niyáꞌupua tɨ ayén tiráacɨꞌɨti tɨ ruurican jɨ́n huateáturan tɨ́j naꞌa rusén jɨmeꞌe jaꞌatɨ́ tɨ naꞌa tɨ ayén tiráꞌamitɨejteꞌe jaꞌatɨ́ nej pɨ́rɨcɨ, ajta ayén tináꞌastijreꞌe ineetzi. Neajta inee, ayée nu raꞌajjájsin huáꞌa tzajtaꞌa ɨ́ mej meri huácuii aꞌájna xɨcájraꞌan tɨ jetzen nain jɨ́n teꞌentipuáꞌajte. ");
INSERT INTO crnNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Majta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, matɨ́ꞌɨj mi autéjhuii mej runiúusteꞌe rujɨ́ɨmuaꞌa meꞌɨ́jna jɨmeꞌe tɨ Jesús ayén tiuꞌutaxájtacaꞌa tɨ nuꞌu aꞌɨ́ɨn púꞌeen ɨ́ cuaꞌira tɨ júteꞌe eꞌicaanej. ");
INSERT INTO crnNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ayee mú tiuꞌutaxájtacaꞌa tɨjɨ́n: ―¿Ni caí aꞌɨ́ɨn púꞌeen ɨ́ Jesús tɨ ajta yaujraꞌan púꞌeen aꞌɨ́jna ɨ́ José? ¿Ni qui tecaí huáꞌamuajte ɨ́ táàtajraꞌan, ajta ɨ́ náànajraꞌan? Aꞌiné tijtá neꞌu. Aꞌɨ́j pu jɨ́n, ¿aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn ayén tíꞌixajta tɨ nuꞌu júteꞌe eꞌicaanej? ");
INSERT INTO crnNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Aj puꞌi Jesús ayén tiuꞌutaniú tɨjɨ́n: ―Caxu hui siyen chéꞌe runiúusteꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Capu rɨꞌɨrí tɨ jaꞌatɨ́ ayén veꞌeréꞌenen ineetzi jemi tɨ puaꞌa caí Dios amuacaí caꞌaníjraꞌa raatáꞌan tɨ ij ayén huárɨni. Neajta nu niyen raꞌajjájsin huáꞌa tzajtaꞌa ɨ́ mej meri huácuii aꞌájna xɨcájraꞌa tɨ jetzen nain jɨ́n teꞌentipuáꞌajte. ");
INSERT INTO crnNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","’Ayee mú tiraꞌuyúꞌuxacaꞌa aꞌɨ́ɨme ɨ́ mej tíꞌixaxaꞌataꞌa ɨ́ Dios jetze meꞌecan tɨjɨ́n: “Dios pu nuꞌu ayén tihuáꞌumuaꞌaten naíjmiꞌica.” Jaꞌatɨ́ tɨ naꞌa tɨ ayén ranamua ɨ́ ru tzajtaꞌa aꞌij tɨ tiꞌixa ɨ́ niyáꞌupua, ajta tɨ ayén ráaruuren aꞌij tɨ aꞌɨ́ɨn tíꞌijxeꞌeveꞌe, aꞌɨ́ɨ pu veꞌeréꞌenejsin ineetzi jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Capu ayén huataújmuaꞌa tɨ jaꞌatɨ́ ari raaseíj aꞌɨ́jna ɨ́ niyáꞌupua sino inee, i nej neꞌuun aꞌuvéꞌemej aꞌu tɨ aꞌɨ́ɨn éꞌeseijreꞌe, nee nu neri raaseíj ɨ́ niyáꞌupua. ");
INSERT INTO crnNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","’Ayee nu tejáꞌamuaꞌixaateꞌe tzáahuatiꞌiraꞌa jɨmeꞌe tɨ jaꞌatɨ́ tɨ naꞌa tɨ ayén téꞌantzaahuateꞌen aꞌij nej tiꞌixa, aꞌɨ́ɨ pu ruurican jɨ́n huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nee nu neꞌɨ́n púꞌeen ɨ́ cuaꞌira tɨ jetzen airáninei ɨ́ mej jɨ́n ruuri muáꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","’Aꞌamuahuáacɨxaꞌastemuaꞌacɨꞌɨ mú ráacua meꞌɨ́jna ɨ́ maná aꞌujna jáꞌahuaꞌa aꞌu tɨ caí éꞌetiꞌitɨjcaꞌa. Majta áꞌiyen mú huácuii. ");
INSERT INTO crnNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mɨ́ ajta, yé pu seijreꞌe aꞌɨ́jna ɨ́ cuaꞌira tɨ júteꞌe eꞌicaanej. Tɨ́ puaꞌa jaꞌatɨ́ ráacuaꞌani aꞌɨ́jna, capu jaꞌanáj mɨꞌɨni. ");
INSERT INTO crnNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","’Nee nu neꞌɨ́n púꞌeen aꞌɨ́jna ɨ́ cuaꞌira tɨ júteꞌe eꞌicaanej, tɨ jetzen airáninei ɨ́ mej jɨ́n ruuri muáꞌaraꞌani. Tɨ́ puaꞌa jaꞌatɨ́ ayén ráacuaꞌani aꞌɨ́jna ɨ́ cuaꞌira, aꞌɨ́ɨ pu ruurican jɨ́n huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. Ajta, aꞌɨ́jna ɨ́ cuaꞌira, aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ nej ratéhuaꞌiraꞌa, ɨ́ nej neajta ratámuaɨꞌɨvajta huáꞌa jetze meꞌecan matɨ́j menaꞌa mej yen huachéjme íiyen chaanaca japua mej mi ruuri muáꞌaraꞌani tɨ́j naꞌa rusén jɨmeꞌe. ―Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Majta aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecan, caꞌanín mú jɨ́n autéjhuii mej tiꞌihuaúrixaateꞌen. Miyen tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn jaꞌatɨ́ ayén nuꞌu ruhuáꞌiraꞌa taamín? ");
INSERT INTO crnNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Aj pu i Jesús, ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu tejámuaatáꞌixaateꞌesin. Tɨ́ puaꞌa secaí ráacuaꞌani i nehuáꞌiraꞌa, i nej neajta teáataꞌa jetze airánneijte, ajta tɨ puaꞌa secaí raayéꞌen i nexuureꞌe, caxu rusén jɨ́n ruuri xáꞌajuꞌun. ");
INSERT INTO crnNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Aꞌatɨ́ tɨ naꞌa tɨ ayén ráacuaꞌani i nehuáꞌiraꞌa, ajta ayén raayéꞌen i nexuureꞌe, aꞌɨ́ɨ pu ayén ruurican jɨ́n huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. Neajta nu niyen raꞌajjájsin aꞌájna xɨcájraꞌan tɨ jetzen nain jɨ́n teꞌentipuáꞌajte. ");
INSERT INTO crnNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","’Ayej tiꞌayajna xaa neꞌu. Aꞌɨ́ɨ pu nehuáꞌiraꞌa, aꞌɨ́ɨn púꞌeen ɨ́ tɨ cuaꞌira jetzen airáninei ɨ́ mej tzáahuatiꞌiraꞌa jɨ́n ruuri muáꞌaraꞌani ɨ́ Dios jemi. Ajta aꞌíjna, aꞌii pu xaa neꞌu aꞌɨ́ɨn púꞌeen ɨ́ jaj ɨ́ mej tzáahuatiꞌiraꞌa jɨ́n iraayéꞌen mej mi caí chéꞌe ruxɨéemɨsteꞌe ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aꞌatɨ́ tɨ naꞌa tɨ ayén ráacuaꞌani i nehuáꞌiraꞌa, ajta tɨ ayén raayéꞌen i nexuureꞌe, aꞌɨ́ɨ pu huateáturaasin ineetzi jemi. Neajta nu niyen cheꞌatá nenaꞌa huateáturaasin ɨ́ jemin. ");
INSERT INTO crnNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","’Aꞌɨ́ɨ pu ayanna nejaꞌutaꞌítecaꞌa ɨ́ niyáꞌupua tɨ iꞌirúuri. Neajta nu neꞌɨ́jna jetze aráncaꞌane nej ni ruuri náꞌaraꞌani ɨ́ niyáꞌupua jemi. Ajta aꞌɨ́ɨn ɨ́ jaꞌatɨ́ tɨ ayén tíꞌicuaꞌa ineetzi jemi, aꞌɨ́ɨ pu ayén cheꞌatá naꞌa neetzi jetze araújcaꞌane tɨ ij aꞌɨ́ɨn ruuri áꞌaraꞌani ɨ́ Dios jemi. ");
INSERT INTO crnNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Aꞌii pu aꞌɨ́ɨn púꞌeen ɨ́ cuaꞌira tɨ júteꞌe eꞌicaanej. Tahuáacɨxaꞌastemuaꞌacɨꞌɨ mú miyen ráacua meꞌɨ́jna ɨ́ maná. Majta huácuii. Mɨ́ ajta, aꞌɨ́ɨn tɨ ayén racuaꞌaca aꞌɨ́jna ɨ́ cuaꞌira tɨ neetzi jetze airáninei, aꞌɨ́ɨ pu ruurican jɨ́n huateáturaasin tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ayee pu tihuaꞌutáꞌixaa aꞌɨ́jna ɨ́ Jesús tɨ́ꞌɨj aꞌuun tihuáꞌamuaꞌatejcaꞌa aꞌu mej eꞌetiújseꞌɨrihuaꞌa aꞌujna u Capernaúm. ");
INSERT INTO crnNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Matɨ́ꞌɨj meꞌɨ́jna huánamuajriꞌi, ayée mú muꞌiitɨ́ tiuꞌutaxájtacaꞌa aꞌɨ́ɨme ɨ́ mej jamuan áꞌujujhuaꞌaneꞌe tɨjɨ́n: ―Aꞌij pu puaꞌa taatáꞌa tɨ ayén tiꞌixa. Jéꞌecan pu hui muárɨꞌeri tej tiyen yaúꞌitɨee táꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ajta aꞌɨ́ɨn Jesús, ayée pu rúꞌumuaꞌareerecaꞌa mej miyen runiúusteꞌecaa. Aj puꞌi ayén tihuaꞌutaꞌíhuaꞌuriꞌi tɨjɨ́n: ―¿Ni aꞌij puaꞌa amuaatáꞌa nej niyen tejámuaatáꞌixaa? ");
INSERT INTO crnNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ari tɨ puaꞌa siyen naaseíj ineetzi, i nej teáataꞌa jetze airánneijte, nej ni aꞌuun aꞌujnén júteꞌɨmua aꞌu nej amuacaí áꞌucatii. ");
INSERT INTO crnNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Aꞌɨ́jna jetze ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu jetzen airáninei ɨ́ sej jɨ́n ruuri xáꞌaraꞌani. Mɨ́ ajta, capu aꞌɨ́jna jɨ́n tíꞌivaɨreꞌe aꞌɨ́jna tɨ jetzen airáninei ɨ́ sej ratéhuaꞌiraꞌa. Capu aꞌatzu xaa neꞌu. Mɨ́ ajta, aꞌɨ́jna ɨ́ niuucari ɨ́ nej niyen tejáꞌamuaꞌixaateꞌe, aꞌɨ́jna ɨ́ xɨéjniuꞌucareꞌaraꞌan ɨ́ Dios, aꞌɨ́ɨ pu caꞌaníjraꞌa naatáꞌa nej niyen tiuꞌutaxáj. Ajta, aꞌɨ́j pu jetze airáninei ɨ́ sej jɨ́n ruuri xáꞌaraꞌani. ");
INSERT INTO crnNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mɨ́ seajta múꞌeen, muꞌiitɨ́ xu caí téꞌatzaahuateꞌe. Ayee pu tihuaꞌutáꞌixaa aꞌiné tɨ́j naꞌa ꞌajmíꞌɨmua tɨ yú eꞌiréꞌene, aꞌɨ́ɨ pu rúꞌumuaꞌareerecaꞌa jaꞌatɨ́ tɨ pɨ́rɨcɨ tɨ caí ráꞌatzaahuateꞌecaꞌa, ajta jaꞌatɨ́ tɨ púꞌeen tɨ Jesús jɨmeꞌe tiuꞌutátuiireꞌesin. ");
INSERT INTO crnNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ajta, ayée pu tihuaꞌutáꞌixaa tɨjɨ́n: ―Ayee nu ꞌeen jɨ́n tejámuaatáꞌixaa tɨ caí rɨꞌɨrí tɨ jaꞌatɨ́ ayén huataújtuiireꞌen ineetzi jemi tɨ puaꞌa caí Dios amuacaí caꞌaníjraꞌa raatáꞌan tɨ ayén huárɨni. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aꞌajnáꞌɨmua muꞌíi mú miyen titeecáujxɨeehuatacaꞌa mej mi caí chéꞌe jamuan áꞌujujhuaꞌaneꞌen. ");
INSERT INTO crnNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Aj puꞌi Jesús ayén tihuaꞌutaꞌíhuaꞌuriꞌi aꞌɨ́mej ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase tɨjɨ́n: ―Ari múꞌeen, ¿ni seajta seri ajtácɨɨnicu ineetzi jemi? ");
INSERT INTO crnNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ajta aꞌɨ́ɨn ɨ́ Simón, tɨ ajta iꞌi Pedro, ayée pu tiraataꞌixaa tɨjɨ́n: ―Nevástaraꞌa, ¿aꞌatajni máàj jemin téꞌujuꞌun? Múꞌeetzi puꞌu jemi seijreꞌe ɨ́ niuucari ɨ́ tej jɨ́n ruuri táꞌaraꞌani, tɨ́j naꞌa rusén jɨmeꞌe. ");
INSERT INTO crnNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ayee tu hui ráꞌatzaahuateꞌe, teajta tiyen ramuaꞌaree pej peꞌɨ́n púꞌeen i pej Dios jemi eꞌicaanej, tɨ Dios ajta muajaꞌutétuaasin ɨ́ rurɨꞌɨríintaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Aj puꞌi Jesús ayén tiuꞌutaniú tɨjɨ́n: ―¿Ni qui necaí niyen amuaꞌantíhuaꞌu múꞌejmi mɨ sej tamuáamuataꞌa japuan huaꞌapua aráꞌase? Aꞌiné nijta neꞌu. Mɨ́ ajta, seɨ́j tɨ múꞌejmi jetze ajtémeꞌecan, tiyaaruꞌu pu jetzen seijreꞌe. ―Ayee pu tihuaꞌutáꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aꞌɨ́jna tɨ nuꞌu tiyaaruꞌu jetzen seijreꞌe, aꞌɨ́ɨ pu ayén huatamuáꞌa ɨ́ Judás. Aꞌɨ́ɨ pu yaujraꞌan púꞌeeneꞌe aꞌɨ́jna ɨ́ Simón tɨ ayén teꞌentímuꞌutaca tɨjɨ́n Iscariotes. Ajta aꞌɨ́ɨn Judás, huáꞌa jetze pu ajtémeꞌecantacaꞌa ɨ́ mej tamuáamuataꞌa japuan huaꞌapua aráꞌase. Aꞌɨ́ɨ pu aꞌɨ́ɨn púꞌeen tɨ avíitzi jɨ́n tiuꞌutátuiireꞌesin aꞌɨ́jna jɨmeꞌe ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tɨ́j naꞌa aꞌájnáꞌɨmua, aꞌúu pu aꞌuteájturaa ɨ́ Jesús aꞌujna u Galilea. Capu chéꞌe aꞌuun áꞌucheꞌecaneꞌe u Judea aꞌiné aꞌɨ́ɨme ɨ́ mej Israél jetze ajtémeꞌecantacaꞌa ɨ́ mej aꞌuun éꞌechejcaꞌa, ayée mú raxɨ́ꞌeveꞌecaꞌa mej raajéꞌica. ");
INSERT INTO crnNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Puꞌuri ajta vejliꞌitacaꞌa aꞌájna matɨ́ꞌɨj miyen tíꞌiyestehuaꞌa meꞌɨ́jna jɨmeꞌe mej avéꞌujꞌɨnaamuaꞌasin, ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Matɨ́ꞌɨj mi miyen tiraataꞌixaa ɨ́ ihuáamuaꞌameꞌen ɨ́ Jesús tɨjɨ́n: ―Patáꞌaj hui piyen huiirájraꞌani peyujna pej peꞌuun áꞌuraꞌani aꞌujna u Judea, mej mi aꞌɨ́ɨme ɨ́ mej múꞌeetzi jamuan áꞌujujhuaꞌan miyen raaseíj aꞌij pej rɨcɨ peꞌɨ́jna jɨmeꞌe tɨ hui huápɨꞌɨ ruxeꞌeveꞌe, ɨ́ mej jɨ́n aꞌij teꞌutaseíj. ");
INSERT INTO crnNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tɨ́ puaꞌa hui jaꞌatɨ́ ayén raxɨ́ꞌeveꞌe mej mi mé jéjreꞌe miyen ráamuaꞌati, capu ayén avíitzi jɨ́n tíꞌimuarɨꞌe. Aꞌiné ayée pej hui rɨcɨ peꞌɨ́jna jɨmeꞌe tɨ huápɨꞌɨ ruxeꞌeveꞌe, naa pu xɨ́ꞌepɨꞌɨn pej piyen á jéjreꞌe huatáꞌaseijrata huáꞌa jemi, matɨ́j menaꞌa puaꞌamé mej yen huachéjme íiyen chaanaca japua. ―Ayee mú tiraataꞌixaa. ");
INSERT INTO crnNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Majta aꞌɨ́ɨme ɨ́ mej ihuáamuaꞌameꞌen púꞌeeneꞌe, camu majta ráꞌantzaahua meꞌɨ́jna ɨ́ Jesús. ");
INSERT INTO crnNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aj puꞌi ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Capúu xɨ aꞌájna tejaꞌuréꞌene tɨ huaxɨ́ꞌepɨꞌɨn ineetzi jemi nej ni neꞌuun aꞌutanén. Aru múꞌejmi jemi, jaꞌanáj tɨ naꞌa pu ayén íꞌixɨꞌepɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Capu hui aꞌatzu rɨꞌɨrí mej amuájchaꞌɨɨreꞌe ɨ́ mej yen huachéjme íiyen chaanaca japua. Mɨ́ majta xaa ineetzi menéjchaꞌɨɨreꞌe meꞌɨ́jna jɨmeꞌe nej caí niyen aꞌij puaꞌa tihuáꞌaxajta mej miyen aꞌij puaꞌa titetiújchaꞌɨɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Setáꞌaj seꞌuun aꞌujnén aꞌánna aꞌu mej tejéꞌeyeste. Caxɨ́ɨ nu aꞌuméꞌe naꞌame inee nej ni neꞌuun íjii tejaꞌuvéꞌemuaꞌariiveꞌen aꞌiné capu xɨ ayén tejaꞌuréꞌene tɨ ari huaxɨ́ꞌepɨꞌɨn. ");
INSERT INTO crnNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tɨ́ꞌɨj ayén tihuaꞌutáꞌixaa, aj puꞌi aꞌuun aꞌuteájturaa aꞌujna u Galilea. ");
INSERT INTO crnNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Mɨ́ ajta aꞌɨ́ɨn, ayée pu huarɨ́j. Matɨ́ꞌɨj aꞌucɨ́j ɨ́ ihuáamuaꞌameꞌen mej mi meꞌuun tejáꞌuyesten, aꞌɨ́ɨ pu ajta u áꞌume. Capu ruseíirata u áꞌume, sino avíitzi puꞌu jɨ́n u áꞌume. ");
INSERT INTO crnNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Majta meꞌɨ́n ɨ́ mej meꞌuun tejéꞌeyestehuaꞌa, aꞌɨ́ɨ mú ráꞌixɨꞌeeriꞌirecaꞌa meꞌɨ́jna ɨ́ ɨ́ Jesus. Miyen tiꞌixáata tɨjɨ́n: ―¿Aꞌuné aꞌij ꞌeen aꞌɨ́jna ɨ́ jaꞌatɨ? ");
INSERT INTO crnNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jéihua mú aꞌij puaꞌa tíꞌixajtacaꞌa aꞌɨ́jna jɨmeꞌe ɨ́ Jesús huáꞌa tzajtaꞌa ɨ́ teɨte ɨ́ mej meꞌuun eꞌetiújseɨreꞌecaꞌa. Seica mú miyen tíꞌixajtacaꞌa tɨjɨ́n: “Rɨ́ꞌɨ pu tíꞌitevij.” Majta seica miyen tíꞌixajtacaꞌa tɨjɨ́n: “Capu aꞌatzu. Aꞌɨ́ɨ pu hui huáꞌacuanamua ɨ́ teɨte.” ");
INSERT INTO crnNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Majta, capu jaꞌatɨ́ ayén áꞌujcaꞌanejcaꞌa tɨ ayén ruseíirata tiuꞌutaxájta aꞌɨ́jna jɨmeꞌe ɨ́ Jesús aꞌiné mehuáꞌatziɨɨneꞌecaꞌa aꞌɨ́mej ɨ́ mej tiꞌitɨ́j jɨ́n antiújmuaꞌareerecaꞌa aꞌɨ́ɨme jemi ɨ́ mej Israél jetze ajtémeꞌecan. ");
INSERT INTO crnNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Matɨ́ꞌɨj meri jáꞌitaꞌa ujúꞌuncaa ɨ́ mej tíꞌiyestehuaꞌa, aj puꞌi Jesús aꞌuun aꞌuteájrupi teyujtaꞌa. Tɨꞌɨj jí aꞌutéjche tɨ tihuáꞌumuaꞌaten ɨ́ teɨte. ");
INSERT INTO crnNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jéꞌecan mú rɨ́ꞌɨ tiraꞌutaseíj aꞌɨ́ɨme ɨ́ mej meꞌuun tíꞌaijta teyujtaꞌa. Ayee mú tiújꞌixaateꞌecaꞌa tɨjɨ́n: ―¿Aꞌiné tíꞌirɨꞌɨri tɨ aꞌɨ́ɨn caí jaꞌanáj tiꞌihuaújmuaꞌate, aꞌɨ́ɨ pu raayɨ́ꞌɨtɨ tɨ ayén tihuáꞌumuaꞌaten? ");
INSERT INTO crnNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús pu ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Canu aꞌij tirájteu neseɨ́j aꞌij nej tihuáꞌamuaꞌaten sino aꞌɨ́ɨ pu ayén tinaatáꞌa aꞌɨ́jna tɨ yé nejaꞌutaꞌítecaꞌa. ");
INSERT INTO crnNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tɨ́ puaꞌa hui jaꞌatɨ́ ayén áꞌujcaꞌane tɨ ayén huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, aꞌɨ́ɨ pu xaa ayén ramuaꞌaréeren tɨ puaꞌa Dios ayén naatáꞌa nej niyen tíꞌimuaꞌataca caꞌɨ́n neseɨ́j nenaꞌa aꞌij tirájteu. ");
INSERT INTO crnNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aꞌɨ́jna tɨ ayén tíꞌixaxaꞌa aꞌij tɨ aꞌɨ́ɨn naꞌa tirájteu ruseɨ́j, ayée pu ꞌeen jɨ́n ayén rɨcɨ tɨ ij rɨ́ꞌɨ tiuꞌutaúraꞌan ruseɨ́j. ’Mɨ́ neajta inee, ayée nu neꞌɨ́jna jɨ́n tíꞌimuarɨꞌe nej ni niyen rɨ́ꞌɨ tiraatáꞌan neꞌɨ́jna tɨ yen nejaꞌutaꞌítecaꞌa. Tɨ́ puaꞌa hui jaꞌatɨ́ ayén áꞌujcaꞌane tɨ ayén huárɨni aꞌij tɨ tíꞌijxeꞌeveꞌe ɨ́ Dios, aꞌɨ́ɨ pu xaa ayén ramuaꞌaréeren tɨ puaꞌa Dios ayén tinaatáꞌa nej niyen tíꞌimuaꞌata caꞌɨ́n neseɨ́j nenaꞌa aꞌij tirájteu. ");
INSERT INTO crnNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Ni caí aꞌɨ́ɨn Moisés teecan ayén amuaatátui aꞌɨ́jna ɨ́ niuucari ɨ́ mej jɨ́n tíꞌaijta? Aa niꞌijtá neꞌu. Mɨ́ seajta múꞌeen, capu jaꞌatɨ́ tɨ múꞌejmi jetze ajtémeꞌecan ayén araúrasten aꞌij tɨ aꞌɨ́ɨn niuucari tiꞌixa. ¿Aꞌiné ꞌeen jɨmeꞌe siyen tíꞌijxeꞌeveꞌe sej naajéꞌica? ");
INSERT INTO crnNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Majta aꞌɨ́ɨme ɨ́ mej meꞌuun ajteáxɨɨrecaꞌa, ayée mú titeetaniú tɨjɨ́n: ―Tiyaaruꞌu pu múꞌeetzi tzajtaꞌa seijreꞌe. ¿Aꞌataani hui ayén tíꞌijxeꞌeveꞌe tɨ́ꞌij muáajeꞌica? ");
INSERT INTO crnNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aj puꞌi Jesús ayén tihuaꞌutáꞌixaa tɨjɨ́n: ―Seɨj nuꞌu jɨ́n niyen huarɨ́j tɨ ayén huápɨꞌɨ ruxeꞌeveꞌecaꞌa. Ajta aꞌɨ́ɨn amuaatéjteu naíjmiꞌica. Jéꞌecan xu avéꞌejɨꞌɨstaxɨ. ");
INSERT INTO crnNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mɨ́ seajta múꞌeen, ayée xu tíꞌijrɨꞌɨre seꞌɨ́jna jɨmeꞌe tɨ Moisés teecan ayén amuaataꞌaíj sej nuꞌu raꞌantisíjchixɨꞌɨn ɨ́ naviiraꞌan. Jee xaa, capu Moisés teecan jetze huanéj, sino Dios pu ayén raateájtuaa aꞌɨ́mej jemi ɨ́ áꞌamuayaꞌupuacɨꞌɨstemuaꞌa. Aꞌɨ́j xu jɨ́n siyen raꞌa