﻿USE sofia;
DROP TABLE IF EXISTS sofia.crl_vpl;
CREATE TABLE crl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES crl_vpl WRITE;
INSERT INTO crl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ᒌᓴᔅ ᙭ ᓂᑭ ᐋᔨᒨᒫᐤ, ᐋ ᑭᓂᐙᐱᐦᑎᒥᓐ ᐊᓂᑎᐦ ᐋ ᒌ ᒥᓯᓈᐦᐄᑭᓂᐐᒡ ᐅᑖᓂᔅᑳᐅᓰᒻ ᐋ ᒌ ᒥᓯᓂᐦᐋᒥᒫᑭᓂᐐᒡ᙮ ᐊᓂᔮᐦ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᒌᐦ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐤ ᐊᓂᔮᐦ ᐋᑉᕋᐦᐋᒻᐦ ᐋᐦ ᑖᔨᒡ ᐊᑰᑖᐦ ᑳ ᐅᐦᒌᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒫᒃ ᐋᐃᓵᒃᐦ ᒌᐦ ᐅᑯᓯᓯᐤ, ᐋᒄ ᒫᒃ ᐋᐃᓵᒃ ᒉᑭᑉᐦ ᒌᐦ ᐅᑯᓯᓯᐤ, ᒉᑭᑉ ᒫᒃ ᒍᑖᐦ ᒌᐦ ᐅᑯᓯᓯᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓃᔨᐤᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ᒍᑖ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐯᕃᔅᐦ ᑭᔮᐦ ᓯᕌᐦ, ᑖᒫᕐᐦ ᒫᒃ ᒌᐦ ᐅᑳᐐᐅᒡ᙮ ᐯᕃᔅ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐦᐁᔅᕈᓐᐦ, ᐦᐁᔅᕈᓐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐋᕌᒻᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ᐋᕌᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᒥᓂᑖᑉᐦ, ᐋᒥᓂᑖᑉ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᓈᔣᓐᐦ, ᓈᔣᓐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᓵᓪᒧᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ᓵᓪᒧᓐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᑆᐋᔅᐦ, ᕃᐦᐋᑉ ᒌᐦ ᐅᑳᐐᔨᐤ᙮ ᑆᐋᔅ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐅᐱᑦᐦ, ᕉᕪ ᒌᐦ ᐅᑳᐐᔨᐤ᙮ ᐅᐱᑦ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒑᓰᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ᒑᓰ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦᐦ ᒌᐦ ᐅᑯᓯᓯᐤ᙮ ᑌᕕᑦ ᒫᒃ ᔂᓚᒥᓐᐦ ᒌᐦ ᐅᑯᓯᓯᐤ, ᔪᕆᔮᐦ ᒫᒃ ᐎᐐᔨᐤ ᒌᐦ ᐅᑳᐐᔨᐤ ᔂᓚᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ᔂᓚᒥᓐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᕌᐦᐙᐳᐋᒻᐦ, ᕌᐦᐙᐳᐋᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᐹᐃᒑᐦ᙮ ᐊᐹᐃᒑ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᓵᕝᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ᐊᓵᕝ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒉᐦᐙᔖᕚᑦᐦ, ᒉᐦᐙᔖᕚᑦ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒋᐦᐙᕌᒻᐦ᙮ ᒋᐦᐙᕌᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᔫᓵᔮᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ᔫᓵᔮ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒞᑖᒻᐦ, ᒞᑖᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐁᐦᐋᔅᐦ᙮ ᐁᐦᐋᔅ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐦᐁᓯᑳᔮᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ᐦᐁᓯᑳᔮ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒫᓈᓵᐦ᙮ ᒫᓈᓵ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᒸᓐᐦ, ᐊᒸᓐ ᒫᒃ ᒞᓵᔮᐦ ᒌᐦ ᐅᑯᓯᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ᒞᓵᔮ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒉᒀᓈᔮᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᔨᐤ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒫᒀᒡ ᐊᓂᒌ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐹᐱᓨᓐ ᑳ ᐄᑐᐦᑎᐦᐋᑭᓂᐎᒡ ᐋ ᐅᑎᓈᑭᓄᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ᔖᔥ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐹᐱᓨᓐ ᒌᐦ ᑖᐅᒡ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᑭᓂᐎᒡ, ᐋᒄ ᒉᒀᓈᔮ ᑳ ᐅᑯᓯᓯᑦ, ᔒᔮᓪᑎᔮᓪ ᒌᐦ ᐃᔑᓂᐦᑳᑖᐤ᙮ ᔒᔮᓪᑎᔮᓪ ᒫᒃ ᓯᕈᐹᐱᓪᐦ ᒌᐦ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ᓯᕈᐹᐱᓪ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᐱᔪᑦᐦ, ᐊᐱᔪᑦ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐁᓕᔮᑮᒻᐦ, ᐁᓕᔮᑮᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐋᔂᕐᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ᐋᔂᕐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᓵᑣᒃᐦ, ᓵᑣᒃ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐊᒋᒻᐦ, ᐊᒋᒻ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐄᓖᔪᑦᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ᐄᓖᔪᑦ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᐄᓖᔨᓵᕐᐦ, ᐄᓖᔨᓵᕐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒫᕦᓐᐦ, ᒫᕦᓐ ᒫᒃ ᒌᐦ ᐅᑯᓯᓯᐤ ᒉᑭᑉᐦ, ");
INSERT INTO crl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ᒉᑭᑉ ᒫᒃ ᒍᓯᕝᐦ ᒌᐦ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᑯᓯᔅᐦ, ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᒣᕇ ᑳ ᐅᓈᐹᒥᑦ᙮ ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᒣᕇᐦ ᑳ ᐅᑳᐐᑦ ᒌᓴᔅ ᐊᓐ ᙭ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ᓈᐅᔖᑉ ᒫᒃ ᒌ ᐃᐦᑎᔑᐎᒡ ᐅᒌ ᐅᐦᑖᐐᒫᐅᒡ ᑭᔮᐦ ᐅᑯᓯᓯᒫᐅᒡ ᐊᓂᑖᐦ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᐋ ᒌᐦ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᑖᐦ ᑌᕕᑦ ᐋᐦ ᑖᑦ ᐄᔑ᙮ ᓈᐅᔖᑉ ᑭᔮᐦ ᒌ ᐃᐦᑎᔑᐎᒡ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᐋ ᒌᐦ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐅᐦᑖᐐᒫᐅᒡ ᐊᓂᑖᐦ ᐄᔑ ᐄᔥᐱᐦ ᑳ ᐅᑎᓂᑭᓄᐐᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐹᐱᓨᓂᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑭᓂᐎᒡ᙮ ᐋᑯᑖᐦ ᒦᓐ ᓈᐅᔖᑉ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐅᐦᑖᐐᒫᐅᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᙭ ᑳ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ᒫᐤ ᒫᒃ ᑳ ᐄᔅᐱᔨᔨᒡ ᒑ ᐱᒫᑎᓰᑦ ᙭ ᒌᓴᔅ᙮ ᒣᕇ, ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᒑ ᐅᑳᐐᑦ, ᒋᐱᐦ ᐐᒋᒥᑐᐎᒡ ᐊᓂᔮᔨᐤ ᒍᓯᕝᐦ, ᒥᒄ ᒫᒃ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᐦᒋᐐᒋᑐᒡ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᐐᐦᐹᒥᑑᒡ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒣᕇ ᐋ ᐅᑎᐙᔑᔒᒥᐦᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᐙᔑᔥ ᒑ ᒋᒋᔥᑭᐙᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌᐦᑐᑖᑰ ᒑ ᒌ ᒋᒋᔥᑭᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᒍᓯᕝ ᒨᔥ ᑯᐃᔅᒄ ᑳ ᐐᐦ ᐄᐦᑎᒃ ᒌᐦ ᐄᑖᔨᐦᑖᑯᓯᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒑᔅᒑᔨᒫᑦ ᒣᕇ ᐋ ᐅᑎᐙᔑᔒᒥᔨᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᒫᐤ ᓂᑎᐐ ᒑ ᒌᐦ ᐄᑎᒋᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐋᒄ ᑳ ᑯᒀᑖᔨᐦᑎᐦᒃ ᒋᔮᒻ ᒑ ᒌ ᓂᑭᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ᒫᒀᒡ ᐅᔮᔨᐤ ᐋ ᒫᒥᑐᓈᔨᐦᑎᐦᒃ, ᐄᔥᐱᐦ ᒫᒃ ᓈᐹᑦ, ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᒌ ᓅᑯᓰᔥᑖᑰ ᐅᐳᐙᒧᐎᓂᐦᒡ ᐋᐦ ᐄᑎᑯᑦ, “ᒍᓯᕝᐦ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐊᑳᐐ ᑯᔥᑖᒡ ᒑ ᒌᐦ ᐐᒋᒥᑦ ᒣᕇ ᐙᔥ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌᐦ ᑐᑖᑰ ᒑ ᒌ ᒋᒋᔥᑭᐙᑦ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ᑭᑎ ᓈᐹᐅᔑᔨᐤ ᐊᓂᔮᔨᐤ ᐅᑎᐙᔑᔒᒻ, ᒌᓴᔅ ᒋᑭ ᐃᔑᓂᐦᑳᑖᐙᐤ, ᐙᔥ ᐋᐅᒄ ᐆ ᒑ ᐱᒫᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐅᒥᒑᑎᓰᐎᓃᔨᒡ ᐅᐦᒋ᙮” ᑳᐦ ᐄᑎᑯᑦ ᒍᓯᕝᐦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ᐋᐅᒄ ᓂᐦᐋᐤ ᑳ ᐄᔅᐱᔨᔨᒡ ᑳ ᑎᐱᐹᔨᒡ ᑖᓐ ᑳ ᐹᒋ ᐄᔨᔨᑯᐱᓈ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐅᒋᔅᒋᐙᐦᐄᒑᓰᒻ ᑳ ᐄᔨᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“ᐃᔅᒀᔥ ᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᒋᔅᒑᔨᒥᑯᑦ ᓈᐹᐤ ᒋᑭ ᒋᒋᔥᑭᐙᐤ ᐊᐙᔑᔥ, ᒋᑭ ᓈᐹᐅᔑᔨᐤ ᒫᒃ, ᐄᒫᓄᐁᓪ ᒋᑭ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ᙮” ᒋᔖᒥᓂᑑ ᐋ ᐹᒋᐦᑖᑦ ᐅᑎᐦ ᐋᐦᑖᐅᒄ ᐃᔑᒌᔂᒥᑭᓐ ᐆ ᐃᔑᓂᐦᑳᓱᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ᐄᔥᐱᐦ ᒫᒃ ᐎᓂᔥᑳᑦ ᒍᓯᕝ, ᒌᐦ ᑐᑎᒻ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᐊᓂᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ, ᒌ ᐐᒋᒫᐤ ᐊᓂᔮᔨᐤ ᒣᕇ᙮ ");
INSERT INTO crl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᐱᒫᔨᒫᐤ ᐹᑎᔥ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐅᑎᐙᔑᔒᒥᔨᐤᐦ᙮ ᒍᓯᕝ ᒫᒃ ᒌᓴᔅ ᒌᐦ ᐃᔑᓂᐦᑳᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ᐊᓂᑖᐦ ᒫᒃ ᐹᕪᓕᐦᐋᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᑳ ᐱᒫᑎᓰᑦ ᒌᓴᔅ, ᒫᒀᒡ ᐦᐁᕆᑦ ᒌ ᒋᐦᒋᐅᒋᒫᐤ᙮ ᒌ ᐹᒋ ᑎᑯᔑᓂᒡ ᒫᒃ ᓈᐹᐅᒡ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐙᐱᓅᑖᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ᐋᒄ ᑳ ᓈᓂᑐ ᑯᒀᒋᐦᒑᒧᒡ ᐋᐦ ᐃᔨᒡ, “ᑖᓂᑖᐦ ᐋᐦ ᑖᑦ ᐊᓐ ᐊᐙᔑᔥ ᑳ ᐱᒫᑎᓰᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᒑ ᐅᒋᔥᒍᒋᒫᒥᒡ? ᐙᔥ ᓂᒌᐙᐱᒫᓈᓐ ᐊᒋᐦᑯᐦᔥ ᐊᓂᑖᐦ ᐙᐱᓅᑖᐦᒡ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒋᐱᐦ ᓅᑯᓯᔨᐤ ᐄᔥᐱᐦ ᐱᒫᑎᓰᒑ᙮ ᐋᒄ ᑳ ᐹᒋ ᑎᑯᔑᓂᔮᐦᒡ ᒑ ᒌ ᐹᒋ ᒋᔥᑖᔨᒥᒋᐦᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ᐄᔥᐱᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ, ᓈᔥᒡ ᒌ ᒥᑯᔥᑳᑖᔨᐦᑎᒻ ᑭᔮᐦ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ᐋᒄ ᐦᐁᕆᑦ ᑳ ᓂᑑᒫᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒄ ᐃᐦᑖᐎᓂᔨᐤ ᒋᐱᐦ ᐱᒫᑎᓰᐤ ᐊᓐ ᙭?” ");
INSERT INTO crl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐋᑯᑖᐦ ᑭᔨᑆ ᑳ ᐄᓈᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐹᕪᓕᐦᐋᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐙᔥ ᒫᐅᔮᔨᐤ ᑳ ᐄᑎᓯᓂᐦᐊᒧᑯᐱᓈ ᐊᓐ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ, ");
INSERT INTO crl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ᐹᕪᓕᐦᐋᒻ ᐊᓂᑖᐦ ᒎᑏᔮᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐃᐦᑖᐎᓐ, ᓂᒥᔮᐤ ᒌᔨ ᒫᐅᒡ ᒑ ᑎᐱᑖᔨᐦᑖᑯᓯᔨᓐ ᐋ ᑎᐦᑎᐦᒡ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᒎᑏᔮ, ᐙᔥ ᐋᑯᑖᐦ ᒑ ᐅᐦᒌᑦ ᐊᓐ ᒑ ᓃᑳᓂᔥᑭᐙᑦ ᑭᔮᐦ ᒑ ᒋᔅᒋᓄᐦᑎᐦᐋᑦ ᐃᔅᕋᐄᓪ ᓂᑎᔨᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ᐄᔥᐱᐦ ᐦᐁᕆᑦ ᑳ ᐹᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒌᒧᒡ ᒌ ᓂᑑᒫᐤ ᐊᓂᔮᔨᐤᐦ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᒥᔨᒡ ᓈᐹᐤᐦ, ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᑖᔨᔥᐱᔥ ᓂᐦᐋᐤ ᑳ ᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᐊᒋᐦᑯᔥ ᐋ ᓅᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ᐋᒄ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᒥᔨᒡ ᓈᐹᐤᐦ ᐊᓂᑖᐦ ᐹᕪᓕᐦᐋᒥᐦᒡ ᐋᐦ ᐄᑖᑦ, “ᒫᒌᒄ ᒥᑐᓐ ᓂᑑᓈᓂᑐᐙᐱᒫᐦᒄ ᐊᓐ ᐊᐙᔑᔥ, ᐄᔥᐱᐦ ᒫᒃ ᒥᔅᑭᐙᒀ, ᒑ ᐹᒋ ᐐᐦᑎᒧᔮᒄ ᒑ ᒌ ᓂᑎᐙᐱᒥᒃ, ᑭᔮᐦ ᓃᔨ ᒑ ᒌ ᓂᑑᒫᒥᐦᒋᒥᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐐᐦᑎᒫᑯᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑖᓐ ᒑᐦ ᑎᒡ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ᙮ ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌ ᐙᐱᒫᐅᒡ ᒦᓐ ᐊᓂᔮᔨᐤᐦ ᐊᒋᐦᑯᔥᐦ, ᐊᓂᔮᔨᐤᐦ ᑳ ᐙᐱᒫᒡ ᐊᓂᑖᐦ ᐙᐱᓅᑖᐦᒡ᙮ ᐃᔥᐱᒥᐦᒡ ᒫᒃ ᐊᓂᑖᐦ ᓃᑳᓂᐦᒡ ᐋᐦ ᑖᒡ ᐋᑯᑖᐦ ᑳᐦ ᐋᑏᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐊᒋᐦᑯᔥ, ᒑᒃ ᒫᒃ ᑳ ᒋᐱᐦᒋᐱᔨᔨᒡ ᓂᐦᐋᐤ ᑎᐱᔅᑯᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ᓈᔥᒡ ᒫᒃ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐊᒋᐦᑯᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ᐋᒄ ᑳ ᐲᐦᒑᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᒣᕇᐦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑎᐙᔑᔒᒥᔨᐤᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ ᒌᐦ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᒡ ᐋ ᒫᒥᐦᒋᒫᒡ᙮ ᐋᒄ ᑳ ᑯᐃᑯᓂᐦᒡ ᐊᓂᔮᔨᐤᐦ ᒑᒀᔨᐤ ᑳ ᐐᐦ ᒥᔮᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ, ᔔᐎᔮᓈᐱᔅᒄ ᒌ ᒥᔮᐅᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒌᐦ ᐃᔥᒀᓯᑭᓂᐐᒡ ᑳ ᒥᔪᒫᑯᓰᔨᒡ ᑭᔮᐦ ᑳᐦ ᐋᔨᒥᒋᑖᑯᓃᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ ᑳ ᒥᔪᒫᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ᐄᔥᐱᐦ ᒫᒃ ᒑ ᒌᐙᒡ ᓂᒧᐃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐄᑖᐦᒑ ᐅᐦᒋ ᐄᔑ ᒌᐙᐅᒡ ᒑ ᒌ ᓂᑑᐐᐦᑎᒧᐙᒡ ᐦᐁᕆᑦ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᒌᐦ ᐃᔮᒀᒥᒥᑯᒡ ᐅᐳᐙᒧᓂᐙᐦᒡ ᒑᐦ ᐋᑳ ᑳᐤ ᓂᑎᐙᐱᒫᒡ ᐦᐁᕆᑦ᙮ ᐋᒄ ᒫᒃ ᐃᔨᐦᒡ ᑳ ᐄᔑ ᒌᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᐹᒋ ᒧᐎᒋᔑᐙᒡ, ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᑳ ᓅᑯᓰᔥᑖᑯᑦ ᒍᓯᕝᐦ ᐅᐳᐙᒧᐎᓂᐦᒡ ᐋᐦ ᐄᑎᑯᑦ, “ ᐦᐁᕆᑦ ᒋᑭ ᓈᓂᑐᐙᔨᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ ᐋ ᐐᐦ ᓂᐱᐦᐋᑦ᙮ ᐎᓂᔥᑳᐦ, ᓈᑖᐦ ᐄᒋᐱᑎᐦᒡ ᒑ ᐄᔑ ᐅᔑᒧᑣᔨᓐ ᐊᓐ ᐊᐙᔑᔥᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑳᐐᐦ, ᐋᑯᑖᐦ ᒑᐦ ᑖᔮᒄ ᐹᑎᔥ ᐄᑎᑎᑯᒑ ᒑ ᒌ ᒋᔅᑐᐦᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ᐋᒄ ᒍᓯᕝ ᑳ ᐎᓂᔥᑳᑦ, ᑳ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑳᐐᔨᐤᐦ ᐋ ᒫᒀᒋᔅᑎᐱᔅᑳᔨᒡ᙮ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᑖᒡ ᐹᑎᔥ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐦᐁᕆᑦ᙮ ᐆ ᒫᒃ ᑳ ᐄᔅᐱᔨᒡ ᐋᒄ ᑳ ᑎᐱᐱᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓰᒻ ᑳ ᐄᔨᔨᒡ ᐋ ᒌᐦ ᐃᔨᑦ, “ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐅᐦᒋ ᓂᒌ ᐅᐦᒋ ᓂᑑᒫᐤ ᓂᑯᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᐋ ᒌ ᐱᒫᑎᓰᑦ ᐦᐁᕆᑦ ᐄᔥᐱᐦ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐋ ᒌᐦ ᐎᓂᒧᐃᑯᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᒥᔨᒡ ᓈᐹᐤᐦ ᓈᔥᒡ ᒌ ᒋᔑᐙᔔ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒥᓯᐙ ᐊᐙᔑᔥᐦ ᐋ ᓈᐹᔒᐎᔨᒡ ᑳ ᓃᔓᐳᓍᓰᔨᒡ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᓃᐦᑖᐦᒡ ᐊᓂᑖᐦ ᐹᕪᓕᐦᐋᒥᐦᒡ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᐙᔅᑳ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᒌᐦ ᑐᑎᐙᑦ ᐙᔥ ᐋᔪᐎᒄ ᐎᔮᔥ ᑳ ᐃᔥᐱᔥ ᐐᐦᑎᒫᑯᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᒥᔨᒡ ᓈᐹᐤᐦ ᓃᔓ ᐱᐳᓐ ᐊᓂᑖᐦ ᐄᔑ ᐅᑖᐦᒡ, ᐊᓂᑖᐦ ᓃᔥᑎᒻ ᑳ ᐙᐱᒫᔨᑯᐱᓈᓂᐦᐄ ᐊᓂᔮᔨᐤ ᐊᒋᐦᑯᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ᐋᒄ ᒫᒃ ᑳ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᒧᑯᐱᓈ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒉᕆᒫᔮ, ᑳᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","ᐋ ᓂᓈᐦᑳᑣᐅᑖᑭᓅᐦᒡ ᒌ ᐹᐦᑖᑯᓐ ᐊᓂᑖᐦ ᕌᒫᐦᒡ, ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᐅᑳᐐᒫᐅᒡ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᕋᒋᓪ, ᑳ ᒧᔥᑭᐙᑖᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒧᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓈᓂᐦᐋᐅᒥᑯᒡ ᐙᔥ ᒥᓯᐙ ᒌ ᐳᓂᐱᒫᑎᓯᔨᐤᐦ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐦᐁᕆᑦ, ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑖᓐᒋᓂᒥᔨᐤ ᑳ ᓅᑯᓰᔥᑖᑯᑦ ᒍᓯᕝᐦ ᐅᐳᐙᒧᐎᓂᐦᒡ᙮ ᐋᔥᒄ ᒫᒀᒡ ᐊᓂᑖᐦ ᐄᒋᑉᑦ ᒌᐦ ᑖᐅᒡ᙮ ᒌᐦ ᐄᑎᑰ ᒫᒃ, ");
INSERT INTO crl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ᐎᓂᔥᑳᐦ, ᒋᔅᑐᐦᑎᐦᐄ ᐊᓐ ᐊᐙᔑᔥ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑳᐐᐦ, ᑳᐤ ᒑ ᒌᐙᔮᒄ ᐊᓂᑖᐦ ᐃᔅᕋᐄᓪ ᐙᔥ ᔖᔥ ᓂᒧᐃ ᐱᒫᑎᓰᐎᒡ ᐊᓂᒌ ᑳ ᐐᐦ ᓂᐱᐦᐋᒡ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ᐋᒄ ᒍᓯᕝ ᑳ ᐎᓂᔥᑳᑦ, ᑳ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔑᔥᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑳᐐᔨᐤᐦ, ᑳᐤ ᐊᓂᑖᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᒍᓯᕝ ᐱᔮᐦᑎᐦᒃ ᐊᕐᒉᓚᐅᔅ ᐋ ᒌ ᒦᔥᑯᑎᔥᑭᐙᔨᑯᐱᓈᓂᐦᐄ ᐊᓂᔮᔨᐤᐦ ᐅᐦᑖᐐᔨᐤᐦ ᐦᐁᕆᑦ ᐋ ᒋᐦᒋᐅᒋᒫᐎᓈᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ, ᐋᒄ ᑳ ᑯᔥᑖᒋᑦ ᒑ ᒌᐦ ᐐᒋᑦ ᐊᓂᑖᐦ᙮ ᐋᒄ ᒦᓐ ᑳ ᐐᐦᑎᒧᐙᑭᓅᑦ ᑖᓐ ᒑ ᑎᒃ ᐋ ᐳᐙᒧᑦ, ᐋᒄ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ᐋᒄ ᐊᓂᑖᐦ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐋᑯᑖᐦ ᑳ ᐐᒋᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᑎᐱᐱᔨᒡ ᐙᔅᑭᒡ ᑖᓐ ᑳᐦ ᐄᔨᔨᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑳᐦ ᐃᔨᒡ, “ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ ᒋᑭ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᒫᒀᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ ᑳ ᒌᐦ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ, ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᐄᑖᐦᒑ, ᐋᒄ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐋ ᑭᒑᔅᒀᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ᐋᐦ ᐃᔨᑦ, “ᒀᔅᑳᑎᓰᒄ, ᐙᔥ ᔖᔥ ᐹᔓᓈᑯᓐ ᐊᓐ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᒞᓐ ᑳᐦ ᐋᔨᒨᒫᑦ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐊᔨᒦᔥᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᐋᐃᓵᔮ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐋᔨᐅᒄ ᑳᐦ ᐃᔨᑯᐱᓈ, ᑭᑎ ᑖᐤ ᐊᐙᓐ ᐋ ᒥᑣᑖᑆᐅᑦ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐋᐦ ᐃᔨᑦ, ᐃᔮᔅᑭᐐᐦᑭᒸᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒫᔅᑭᓈᒻ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑖᑦ, ᑯᐃᔅᑯᒧᐦᑖᐙᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ᐆ ᒫᒃ ᒞᓐ, ᑳᒥᓪ ᐅᐲᐙᔨᐤ ᒌᐦ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᔨᐤ ᐅᒑᒀᓂᒻ, ᑭᔮᐦ ᐲᓵᑭᓈᐱᐦᒡ ᒌᐦ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳ ᐆ ᐱᐦᑯᐦᑖᐦᐅᓂᑦ ᑭᔮᐦ ᒀᔥᒀᔥᑯᐦᒋᔒᔥ ᑭᔮᐦ ᐋᒨᔔᑳᔨᐤ ᐋᔪᐎᒄ ᑳ ᐅᒦᒋᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ᒌ ᐹᒋ ᓂᑑᐦᑖᑰ ᒫᒃ ᒞᓐ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐅᐦᒌᔨᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒥᓯᐙ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᔨᒡ, ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓐ ᐹᔓᒡ ᒞᕐᑎᓐ ᓰᐲᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᑳ ᐅᐦᒌᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ᒧᔖ ᒌ ᐐᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒧᐙᑯᐱᓈᓐᐦᒋ ᐋᒄ ᒫᒃ ᑳ ᓰᑭᐦᐋᐦᑖᑯᒡ ᒞᓐ ᐊᓂᑖᐦ ᒞᕐᑎᓐ ᓰᐲᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ᐄᔥᐱᐦ ᒫᒃ ᒞᓐ ᐎᔮᐱᒫᑦ ᒥᐦᒑᑐ ᐹᕆᓰᐦ ᑭᔮᐦ ᓵᑎᔫᓰᐦ ᐋ ᐹᒋ ᑎᑯᔑᓃᔨᒡ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᔨᒡ, ᒌᐦ ᐄᑖᐤ, “ᒧᔮᒻ ᐋ ᒥᐦᒑᑎᒡ ᒫᒨ ᐋᐦ ᑖᒡ ᐊᒋᓈᐳᑯᒡ ᒋᑎᐄᑖᔨᐦᑖᑯᓯᓈᐙᐤ᙮ ᐊᐙᓐ ᑳ ᐄᑎᑖᒄ ᒑ ᒌᐦ ᐅᔑᒧᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᑖᐦᑯᐃᐙᓯᐎᓐ? ");
INSERT INTO crl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ᓅᑯᐦᑖᒄ ᑖᑆᐦ ᐋ ᒀᔅᑳᑎᓰᔮᒄ ᐅᐦᒋ ᐋᓐ ᐋ ᒥᔪᑐᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ᑭᔮᐦ ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᒑᐦ ᐋᑳ ᒫᑯᐦᐄᑖᒄ ᒋᔖᒥᓂᑑ ᐋ ᐎᓂᑐᑎᒫᒄ ᒥᒄ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᐋ ᐅᐦᒋᔮᒄ᙮ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᔖᒥᓂᑑ ᒋᑭ ᒌᐦ ᑐᑎᐙᐤ ᐅᔮᔨᐤᐦ ᐊᓯᓃᐦ ᑳ ᐄᑖᐱᔨᒡ ᒑ ᒌᐦ ᐅᐦᒋ ᐅᔑᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐋᑉᕋᐦᐋᒻ ᐋ ᐅᑎᐙᔑᔒᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ᐙᔥ ᒧᔮᒻ ᔖᔥ ᐋ ᐃᔮᔅᑰᔥᑖᒡ ᒋᑭᐦᐄᑭᓐ ᐋᐅᒄ ᒑ ᐃᓯᓈᑯᐦᒡ ᒑ ᓈᑣᑭᐦᐙᑭᓅᑦ ᐊᓐ ᒥᔥᑎᒄ ᐊᓂᑖᐦ ᐋ ᐅᑎᐲᐅᐎᑦ᙮ ᐙᔥ ᑎᐦᑐ ᒥᔥᑎᒄ ᐋᑳ ᑳ ᒥᔨᐤ ᒦᓂᔓᐎᑦ ᒋᑭ ᓈᑣᑭᐦᐙᑭᓂᐤ ᑭᔮᐦ ᒋᑭ ᒧᒋᔥᑖᐙᐱᓈᑭᓂᐤ ᐃᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ᓂᐲᐦᒡ ᒋᓰᑭᐦᐋᐦᑖᑎᓈᐙᐤ ᓃᔨ, ᐋ ᓅᑯᐦᒡ ᐋ ᐐᐦ ᒀᔅᑳᑎᓰᔮᒄ, ᒥᒄ ᒫᒃ ᑯᑎᒃ ᐊᐙᓐ ᒋᑭ ᑎᑯᔑᓐ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐ ᓃᔨ᙮ ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᑎᐦᑯᓂᒧᒡ ᐅᒥᔅᒋᓐ᙮ ᐐᔨ ᒫᒃ ᒋᑭ ᓰᑭᐦᐋᐦᑖᑯᐙᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᑭᔮᐦ ᐃᔥᑯᑖᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ᐆ ᒑ ᑎᑯᔑᐦᒃ ᒋᑭ ᐄᑖᔨᐦᑖᑯᓯᐤ ᒧᔮᒻ ᓈᐹᐤ ᑳ ᐱᔮᐦᒋᐦᑖᑦ ᐱᐦᒀᔑᑭᓂᒥᓈᐦᑎᒄ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᑎᓈᑦ ᐱᐦᒀᔑᑭᓐ ᑭᔮᐦ ᒫᒃ ᐱᐦᑳᓂᔥᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᒥᔻᔨᔨᒡ ᐊᓂᑖᐦ ᐊᔥᑖᓲᑭᒥᑯᐦᒡ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐎᔮᔥ ᒑ ᒌᐦ ᐄᑖᐱᑎᓃᔨᔨᒡ ᐃᔥᒀᓯᒻ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᓂᐦᑖ ᐋᔥᑐᐙᔨᒡ ᐃᔥᑯᑖᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ᐹᑎᒫ ᒫᒃ ᒌᓴᔅ ᒌ ᑎᑯᔑᓐ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᑐᐦᑖᑦ, ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᒞᓐᐦ ᐊᓂᑖᐦ ᒞᕐᑎᓐ ᓰᐲᐦᒡ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ᒥᒄ ᒫᒃ ᒞᓐ ᒋᐐᐦ ᒋᐱᒋᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᐃᓯᓈᑯᓐ ᑎᔨᑯᒡ ᒌᔨ ᒑ ᒌ ᐹᒋ ᓰᑭᐦᐋᐦᑎᐎᔨᓐ, ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐹᒋ ᑯᒀᒋᒥᔨᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑖᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓅᐦᒡ ᐆ ᑐᑎᐦ ᑖᓐ ᐋᑎᔓᒥᑖᓐ᙮ ᐙᔥ ᐆ ᑐᑎᒧᐦᒀ ᒋᑭᑐᑎᒸᓈᓂᐤ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ᙮” ᑭᔨᑆ ᑳ ᐱᔑᒋᐦᐋᑦ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓅᑦ, ᐋᐦ ᐋᑎ ᑭᐹᑦ ᒫᒃ ᒌᐦ ᐅᐦᒋ ᐹᑯᑎᔥᑯᐱᔨᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᒌ ᐙᐱᒫᐤ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᑯᔨᐤ ᐋ ᐹᒋ ᔮᔒᑐᑖᑯᑦ ᒧᔮᒻ ᐅᒦᒦᐤ ᐋ ᐃᓯᓈᑯᓰᔨᒡ ᑭᔮᐦ ᐋ ᑣᐦᐅᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ᐋᒄ ᑳ ᐹᐦᑎᐙᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᐅᐦᒋ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᐄᔨᔨᒡ, “ᐋᐅᒄ ᐆ ᓂᑯᔅ ᑳ ᓵᒋᐦᐄᒃ ᑭᔮᐦ ᓈᔥᒡ ᑳ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ᐋᒄ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᑳ ᐄᑐᐦᑎᐦᐄᑯᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒑ ᒌᐦ ᑯᒀᒋᐦᐄᑯᑦ ᒥᒋᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ᐄᔥᐱᐦ ᒫᒃ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑭᔮᐦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᑎᐱᔅᑳᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ ᐋᐦᐋᑳ ᒦᒋᓱᑦ ᒌᓴᔅ, ᒌ ᔒᐅᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ᐋᒄ ᒥᒋᒥᓂᑑ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᑆᐦ ᐃᔮᐎᓈ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐄᔑᒡ ᐅᒌ ᐊᓯᓃᔨᒡ ᒑ ᒌᐦ ᐋᐃᐦᑯᓈᐆᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ᒥᒄ ᒫᒃ ᒌᓴᔅ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ, ᓂᒧᐃ ᒥᒄ ᐋᐃᐦᑯᓈᐤ ᐋ ᒧᐙᑦ ᐊᐙᓐ ᒋᑭ ᒌᐦ ᐅᐦᒋ ᐱᒫᑎᓰᐤ, ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᐊᔨᒧᐎᓂᔨᐤ ᑳᐦ ᐃᔨᑦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᒥᒄ ᐊᓂᔮᔨᐤ ᒑ ᒌ ᐱᒫᒋᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ᐋᒄ ᒥᒋᒥᓂᑑ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᑳ ᐲᔮᐦᑭᓃᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒉᕉᓯᓕᒻ, ᐋᒄ ᑳ ᔖᑭᒋᐙᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐊᓂᑖᐦ ᒫᐅᒡ ᐋ ᐃᔥᐹᓈᔨᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐙᐅᑯᓰᑐᑖᔅᒀ, ᐋᒥᒀᔥᑯᐦᑎᐦ᙮ ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒋᔖᒥᓂᑑ ᒋᑭ ᐄᑎᔓᐙᑖᐤ ᐅᑖᓐᒋᓂᒻ ᒑ ᒌ ᒥᔪᓈᓈᑭᒋᐦᐄᔅᒌᔅᒡ, ᐋᓐᒋᓂᒡ ᒋᑭ ᑎᐦᑯᓂᑯᒡ ᒑᐦ ᐋᑳ ᐙᐙᒡ ᒌᐦ ᐋᐦᑯᐦᑎᑖᔨᓐ ᒋᓯᑎ ᐊᓯᓃᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒥᒄ ᒫᒃ ᐊᒀᒋᔥᑖᒡ ᑭᔮᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᑳᐐ ᒋᑭ ᑯᒀᒋᐦᐋᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᔨ ᒋᔖᒥᓂᑑᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ᐋᒄ ᒦᓐ ᑳ ᐐᐦ ᑯᒀᒋᐦᐋᑦ ᒥᒋᒥᓂᑑ ᐊᓂᔮᔨᐤᐦ ᒌᓴᔅᐦ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᓈᔥᒡ ᐋ ᐃᔥᐹᓈᔨᒡ ᐋᐱᔅᑯᑎᓈᔨᒡ, ᑳ ᐙᐱᐦᑏᔮᑦ ᒥᓯᐙ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᓃᔨᒡ ᒦᓯᒋᓰᐎᓂᔨᐤ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒥᓯᐙ ᒋᑭ ᒥᔨᑎᓐ ᐆ ᐹᒋ ᓃᐱᔅᑰᐱᔨᓈ ᐋᐦ ᑖᔮᓐ ᐋ ᐊᔨᒥᐦᐋᔥᑐᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ᒥᒄ ᒫᒃ ᒌᓴᔅ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒌᔨ ᒥᒋᒥᓂᑑ, ᒫᒌᐦ ᐄᒑᐦᑖᐦ ᓈᑖᐦ᙮ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒥᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᒋᔖᒥᓂᑑᒧᐙᐤ ᐊᔨᒥᐦᐋᔥᑐᐙᒄ ᑭᔮᐦ ᒥᒄ ᐐᔨ ᐋᐱᑎᓰᔥᑎᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ᐋᒄ ᒥᒋᒥᓂᑑ ᑳ ᓂᑭᑖᑦ ᐊᓂᔮᔨᐤᐦ ᒌᓴᔅᐦ, ᐋᒄ ᐋᓐᒋᓐ ᑳ ᐅᑎᐦᑎᑯᑦ ᒑ ᐐᒋᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᐹᐦᑎᐦᒃ ᒞᓐ ᐋ ᒌᐦ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ, ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᒌᐦ ᐄᑐᐦᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ᐋᒄ ᐊᓂᑖᐦ ᓈᓵᕆᑦ ᑳ ᐅᐦᒋ ᓂᑭᑎᐦᒃ᙮ ᐋᒄ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ, ᐊᓂᑖᐦ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᑳ ᓂᑑᐐᒋᑦ, ᐊᓂᑖᐦ ᓭᐳᓚᓐ ᑭᔮᐦ ᓈᕝᑖᓖ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐐᒋᑦ ᒌᓴᔅ ᐋᒄ ᑳ ᑎᐱᐱᔨᒡ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","ᓂᑎᐦᑎᒧᒄ ᒌᔨᐙᐤ ᐊᓂᑖᐦ ᓭᐳᓚᓐ ᑭᔮᐦ ᓈᕝᑖᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔮᒄ, ᑭᔮᐦ ᒌᔨᐙᐤ ᔮᐃᔅᑭᓂᐤ ᑳ ᐐᒋᔮᒄ ᓈᑖᐦ ᐄᔑ ᒋᐦᒋᑭᒦᐦᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᐊᑳᒥᐦᒡ ᐄᑖᐦᒑᑳᒻ ᒞᕐᑎᓐ ᓰᐲᐦᒡ ᑳ ᐐᒋᔮᒄ᙮ ᓂᑎᐦᑎᒧᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᑳᓕᓖᐦᒡ ᑳ ᐐᒋᔮᒄ, ᐊᓂᑖᐦ ᐙᒌᐦᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ᐋᐦ ᐋᑎ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᒋᑎᐄᔨᔨᒥᐙᐅᒡ ᒌ ᐙᐱᐦᑎᒧᒡ ᐋ ᒥᔥᑎᐦ ᐙᔥᑖᔨᒡ᙮ ᒫᒀᒡ ᑳᐦ ᑖᒡ ᐊᓂᑖᐦ ᐋ ᐊᐅᑳᔥᑖᔮᔨᒡ ᐊᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ ᓂᐱᐎᓂᔨᐤ, ᒌᐦ ᐅᑎᐦᑎᐦᐅᑯᒡ ᐙᔥᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ᐋᑯᑖᐦ ᒫᒃ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᒌᓴᔅ ᐋ ᑭᒑᔅᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᐄᑖᑦ, “ᒀᔅᑳᑎᓰᒄ, ᐙᔥ ᔖᔥ ᐹᔓᓈᑯᓐ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋ ᐱᒧᐦᑖᑦ ᐊᓂᑖᐦ ᔑᔓᒡ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᒌ ᐙᐱᒫᐤ ᓃᔓ ᓈᐹᐤ ᐋ ᐐᒋᐄᔨᔨᐦᑐᔨᒡ ᐋ ᓅᑎᒫᓵᓰᐐᔨᒡ, ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤᐦ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐐᒋᐄᔨᔨᐤᐦ ᐋᓐᑎᕉᐦ, ᐋ ᓅᑎᒫᓵᔨᒡ ᐊᓂᑖᐦ ᓵᑭᐦᐄᑭᓂᐦᒡ ᐃᐦᐄᐲ ᐋᐦ ᐋᐱᒋᐦᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᔥᑎᒧᒄ ᐹᒋ ᐐᒑᐅᒃ, ᒋᑭ ᑐᑖᑎᓈᐙᐤ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐱᑎᐦᐅᔮᔮᒄ ᒧᔮᒻ ᐋ ᐄᔑ ᐱᑎᐦᐅᔮᔮᒄ ᓂᒫᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᓂᑭᑖᐅᒡ ᐅᑎᐦᐄᐲᐙᐤ ᐋᒄ ᑳᐦ ᐋᑎ ᐐᒑᐙᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ᒦᓐ ᒫᒃ ᒌᐦ ᐋᑎ ᒋᔅᑐᐦᑖᐤ ᒌᓴᔅ, ᐋᒄ ᒦᓐ ᑳ ᐙᐱᒫᑦ ᓃᔓ ᓈᐹᐤ ᐋ ᐐᒋᐄᔨᔨᐦᑐᔨᒡ, ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ, ᓭᐱᑏᐦ ᐅᑯᓯᔨᐤᐦ᙮ ᐊᓂᑖᐦ ᐅᒌᒫᓂᓯᔨᔨᒡ ᒌᐦᑖᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᐦᑖᐐᔨᐤᐦ, ᐋ ᐅᐙᓯᐦᐋᔨᒡ ᐅᑎᐦᐄᐲᐙᔨᐤᐦ᙮ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ, ");
INSERT INTO crl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᓂᑭᑎᒧᒡ ᐊᓂᔮᔨᐤᐦ ᐅᒌᒫᓂᓯᐙᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᐦᑖᐐᐙᐤᐦ ᒌ ᓂᑭᑖᐅᒡ, ᐋᒄ ᑳᐦ ᐋᑎ ᐐᒑᐙᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ᒌᓴᔅ ᒫᒃ ᐊᓂᑖᐦ ᑳᓕᓕᒡ ᒌ ᐱᐹᐄᑐᐦᑖᐤ, ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒎᐄᔨᔨᐤ ᐅᑎᔨᒥᐦᐋᐎᑭᒥᑯᔨᒡ, ᑭᔮᐦ ᒌ ᑭᒑᔅᒀᐤ ᒥᔻᒋᒨᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ ᐆ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ, ᑭᔮᐦ ᒫᒃ ᐋ ᒦᓂᐙᒋᐦᐋᑦ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐊᔨᑖᔅᐱᓈᔨᒡ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ᒌ ᒋᑳᔮᒋᒫᑭᓂᐤ ᒫᒃ ᒥᓯᐙ ᐊᓂᑖᐦ ᓯᕆᔮᐦᒡ ᐊᔅᒌᐦᒡ, ᐋᒄ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᐹᔑᐙᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᑭᔮᐦ ᑳ ᒫᒀᔨᑎᒥᔨᒡ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ, ᓂᓈᐦᑭᐤ ᐄᑖᔅᐱᓈᐎᓂᔨᐤ ᑳ ᐃᔮᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐅᒋᐱᑎᑯᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᓂᔅᑐᓰᔨᒡ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᒌᓴᔅ ᐅᔮᔨᐤ ᐊᐙᔨᐤᐦ ᑳ ᐹᔑᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᐱᐹᐐᒑᑰ ᒌᓴᔅ, ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᐅᐦᒋ, ᑭᔮᐦ ᐊᓂᑖᐦ ᑳ ᒥᑖᐦᑎᐦᒡ ᐃᐦᑖᐎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑭᔮᐦ ᒎᑏᔮᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᒀᔅᑳᒻ ᒞᕐᑎᓐ ᓰᐲᐦᒡ ᑳᐦ ᑖᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ᐃᔥᐱᔥ ᒫᒃ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᐋ ᒥᐦᒑᑎᔨᒡ ᐊᐙᔨᐤᐦ, ᐋᒄ ᔑᔮᑭᒋᐙᑦ ᐊᓂᑎᐦ ᐋ ᐱᔅᑯᑖᐅᐦᑳᔨᒡ, ᐋᑯᑖᐦ ᑳ ᐅᐙᔨᐱᑦ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᐹᒋ ᓈᑎᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ᐋᒄ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐋ ᒋᔅᑯᑎᒧᐙᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐊᓂᑖᐦ ᐊᐦᒑᐦᑯᐎᓂᐦᒡ, ᐙᔥ ᐅᒋᒫᐎᓂᑯᐙᑭᓂᐎᒡ ᒋᐦᒋᒌᔒᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᓂᓈᐦᑳᒋᒧᒡ, ᐙᔥ ᑭᑎ ᓈᓂᐦᐋᐐᐦᑳᐙᑳᓅᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᔫᔅᐹᑎᓰᔨᒡ, ᐙᔥ ᐐᔨᐙᐤ ᑭᑎ ᐋᓲᒦᔮᑭᓂᐎᒡ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᐱᒀᑭᑖᑎᒡ ᑭᔮᐦ ᑳ ᓅᐦᑖᔮᐹᒀᑎᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ, ᐙᔥ ᑭᑎ ᒌᔥᐳᐦᐋᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᒑᔨᒫᒡ ᐊᐙᔨᐤᐦ ᐙᔥ ᐐᔨᐙᐤᐦ ᑭᔮᐦ ᑭᑎ ᒋᔅᑎᒫᒑᔨᒫᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᐱᔮᐦᒋᓰᒡ ᐅᑖᐦᐄᐙᐦᒡ, ᐙᔥ ᒋᑭ ᐙᐱᒫᐅᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᒋᔮᒫᐙᐄᐦᑖᑰᔨᐙᓯᐆᒡ, ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᑎᐙᔑᔒᒻ ᒋᑭ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐅᐦᒋ ᐙᔥ ᔖᔥ ᐅᒋᒫᐎᓂᑯᐙᑭᓂᐎᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᐋ ᒫᔮᔨᒥᑯᔮᒄ, ᑭᔮᐦ ᒫᒃ ᐋ ᓂᓈᐦᑳᒋᐦᐄᑯᐎᔮᒄ ᑭᔮᐦ ᐋ ᓂᓂᑐᔮᒋᒥᑯᔮᒄ ᐋ ᒥᒥᒑᒋᒥᑯᔮᒄ ᓃᔨ ᐅᐦᒋ ᐋ ᐹᒋ ᓅᔔᔥᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ᒨᒋᒑᔨᐦᑎᒧᒄ ᑭᔮᐦ ᓲᐦᒃ ᒥᔻᔨᐦᑎᒧᒄ ᐙᔥ ᒋᑭ ᒥᔖᐤ ᑰᐦᑎᓰᐎᓂᐙᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᐙᔥ ᐋᔪᐎᒄ ᐋᓐ ᒧᔮᒻ ᑳ ᐄᔑ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ ᐊᓂᒌ ᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ᒌᔨᐙᐤ ᒋᔒᐅᐦᑖᑭᓂᐎᓈᐙᐤ ᐊᔅᒌᐦᒡ, ᒥᒄ ᒥᔑᐤ ᐃᔮᔪᓂᒀᐤ ᐊᓐ ᐋ ᔑᐙᒡ, ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᒦᓐ ᔑᐙᒡ? ᒥᒄ ᒋᔮᒻ ᓂᒥ ᒌᐦ ᐎᔮᔅᑖᐱᑎᓐ ᐐᐱᒡ ᐊᓐ ᐋᐦᒡ, ᒥᒄ ᓰᑎᐤ ᒑ ᐙᐱᓂᑭᓂᐎᒡ, ᒑ ᑖᐦᑎᑯᔅᑳᑖᑭᓂᐎᒡ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“ᒌᔨᐙᐤ ᐋᐅᒄ ᐙᔥᑖᐎᓐ ᐅᑎᐦ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᐦᒡ ᐆ ᐊᔅᒌ᙮ ᒧᔮᒻ ᒫᒃ ᐃᐦᑖᐎᓐ ᐋ ᐎᔨᑳᐳᐦᑖᑭᓂᐐᒡ ᐊᓂᑖᐦ ᐋ ᐊᐱᔅᒀᐱᔅᑳᐦᒡ, ᓂᒧᐃ ᒋᑭ ᒌ ᑳᑖᑭᓂᐤ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐊᐙᓐ ᐊᑯᓂᐦᐊᒻ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋ ᒌᐦ ᓯᔅᑭᐦᐋᐦᒃ᙮ ᓈᐦᐹᒥᔥᑖᐤ ᐊᓂᔮᔨᐤ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᐎᔮᔥᑖᓂᒫᑯᑦ ᐊᓂᑎᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ᐋᒄ ᒸᐦᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᓈᐦᐄᔪ ᓅᑯᐦᑖᒄ ᒌ ᐙᔅᑐᐙᐎᓂᐙᐤ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ, ᒑ ᒌ ᐙᐱᑎᒡ ᒌ ᒥᔪᐦᑣᐤ ᐋ ᐃᔨᐦᑎᐎᓂᐙᐤ, ᒑ ᒋᔅᑖᒋᒫᒡ ᒫᒃ ᑯᐦᑖᐎᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᑖᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᐋ ᒌ ᐹᒋ ᑎᑯᔑᓂᔮᓐ ᒑ ᒌᐦ ᐄᒑᓂᒫᓐ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ᓂᒧᐃ ᓅᐦᒋ ᑎᑯᔑᓐ ᒑ ᒌᐦ ᐄᒑᓂᑭᓂᐎᒡ ᐊᓂᐦᐄ, ᒫᒃ ᓂᒌᑎᑯᔑᓐ ᑖᑆᐦ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒑ ᐃᔥᐱᔥ ᐄᐦᑎᑯᓃᒀ ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ, ᓂᒧᐃ ᐙᐙᒡ ᐊᓐ ᒫᐅᒡ ᐋ ᐊᐱᔖᔑᒡ ᐋ ᒥᓯᓈᑖᒡ ᐐᔓᐙᐎᓂᐦᒡ ᒋᑭ ᐅᐦᒋ ᐄᒑᓂᑭᓂᐤ, ᐹᑎᔥ ᒥᓯᐙ ᒌᐦ ᐄᔅᐱᔨᐦᒑ ᑖᓐ ᐋ ᑎᔅᑖᒡ ᒑ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ᐋᒄ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᓂᓂᐦᐄᐦᑎᐦᑳ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᐅᔮᔨᐤ ᒧᐙᐦᒡ ᐋᑳ ᑳ ᒋᔅᑎᒥᐙᓃᔨᒡ ᐄᑎᔓᐙᐎᓂᔨᐤ, ᑭᔮᐦ ᒫᒃ ᒋᔅᑯᑎᒧᐙᒑ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐐᔨᐙᐤ ᑭᔮᐦ ᒑ ᒌᐦ ᑏᔨᒡ, ᐋᐅᒄ ᐊᓐ ᒫᐅᒡ ᓂᒧᐃ ᐎᔮᔥ ᒋᑭ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐊᐙᓐ ᓂᓂᐦᐄᐦᑎᐦᑳ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᐄᔑ ᒋᔅᑯᑎᒧᐙᒑ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐅᔮᔨᐤᐦ ᒑ ᒌᐦ ᑏᔨᒡ, ᐋᐅᒄ ᒑ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒑ ᐄᑖᑭᓅᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ, ᐋᐅᒄ ᒥᒄ ᒑ ᒌ ᐲᐦᒑᔮᒄ ᐊᓐ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᐊᑎᑎᐤ ᒌᔨᐙᐤ ᑯᐃᔅᑯᑖᑎᓯᔮᒀ ᐃᔥᐱᔥ ᐐ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ᒋᒌ ᐹᐦᑖᓈᐙᐤ ᐋ ᒌᐦ ᐄᑖᑭᓂᐎᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ, ‘ᐊᑳᐐ ᓂᐱᐦᐋᐦᒄ ᐊᐙᓐ, ᐊᐙᓐ ᓂᐱᐦᐄᐙᒑ ᒋᑭ ᑎᐹᔅᑯᓈᑭᓂᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ, ᐊᐙᓐ ᐋ ᒋᔑᐙᓰᔅᑎᐙᑦ ᐐᒋᔖᓐᐦ ᒋᑭ ᑎᐹᔅᑯᓈᑭᓂᐤᐦ, ᑭᔮᐦ ᐊᐙᓐ ᐋ ᒫᔮᔨᒫᑦ ᐐᒋᔖᓐᐦ ᒋᑭ ᐹᔑᐙᑭᓂᐤᐦ ᐅᐦᑎᔅᑰ ᐊᓂᔮᔨᐤᐦ ᑳ ᐎᔨᔓᐙᑎᒥᔨᒡ ᑖᓐ ᒑ ᑐᑎᐙᑭᓂᐐᒡ ᐊᐙᔨᐤᐦ, ᑭᔮᐦ ᐊᐙᓐ ᑳᐦ ᐄᑖᑦ ᐐᒋᔖᓐᐦ ᑖᑆᐦ ᓂᒥ ᒥᑐᓐ ᒑᒀᓐ ᒋᑎᐄᑖᔨᐦᑖᑯᓯᔨᓐ ᑯᔥᐱᓈᑖᔨᐦᑖᑯᓂᔨᐤᐦ ᒑ ᒌᐦ ᐄᔑ ᐙᐱᓈᑭᓅᑦ ᒥᒋᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ᐋᒄ ᒫᒃ ᒧᔮᒻ ᐐᐦ ᒥᔨᑖ ᒋᔖᒥᓂᑑ ᒥᔨᐙᐎᓂᔨᐤ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ᙮ ᐅᐦᒋ ᒋᔥᒋᓯᔨᓈ ᒫᒃ ᒌᒋᔖᓐ ᐋ ᐎᔮᔅᑖᔨᒥᔅᒃ, ");
INSERT INTO crl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ᐊᑳᐐ ᐱᑎᒫ ᐱᒋᔅᑎᓐ ᐊᓐ ᒌ ᒥᔨᐙᐎᓐ ᐊᓂᑎᐦ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ, ᑏᐙᐦᒡ ᒑ ᓂᑎᐙᐱᒫᑦ ᐊᓐ ᒌᒋᔖᓐ ᒑ ᒥᔪᐱᔨᐦᑖᔮᒄ ᑖᓐ ᑳ ᐃᔅᐱᔮᒄ᙮ ᐋᒄ ᐃᔮᒄ ᒫᒃ ᒦᓐ ᑳᐤ ᒑ ᑎᑯᔑᓃᔨᓐ ᐃᔮᒄ ᒑ ᒥᔨᑦ ᒋᔖᒥᓂᑑᐦ ᐊᓂᔮᔨᐤᐦ ᒥᔨᐙᐎᓂᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“ᐊᐙᓐ ᒫᒃ ᒫᒥᔑᒥᔅᑳ ᒑᒀᔨᐤ ᐋᔨᑖᔨᒥᔅᒃ ᐋ ᒌᐦ ᐄᔑ ᐎᓂᑐᑎᐎᑦ ᐄᐦᑐᑖᔅᑳ ᒫᒃ ᒑ ᒌᐦ ᐄᑐᐦᑏᔅᒃ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ, ᒋᔨᐲᐦ ᐐᐦ ᑐᑐ ᐱᑎᒫ ᓃᔥᑎᒻ ᒑ ᒌ ᒥᔪ ᐊᔨᒥᐦᐄᑦ ᐋᑳ ᒑ ᒌᐦ ᐐᑐᐦᑎᐦᐄᔅᒃ ᐊᓂᑖᐦ ᒫᒀᒡ ᐊᓐ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᔮᒄ᙮ ᐙᔥ ᑎᑯᔑᓂᔮᒀ ᓈᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ, ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᓯᐤ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᒑ ᐄᔑ ᐱᒋᔅᑎᓂᔅᒃ, ᐋᒄ ᐊᓐ ᑎᐹᔅᑯᓂᒑᓯᐤ ᐊᓂᑖᐦ ᒋᐱᐦᐅᐙᔓᐤ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᒑ ᐄᔑ ᐱᒋᔅᑎᓂᔅᒃ, ᒑ ᒋᐳᐦᐆᔅᒡ ᐊᓂᒌ ᑳ ᒋᐱᐦᐅᐙᔓᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓐ ᒫᒃ ᑖᐹ ᒋᑭ ᒌᐦ ᐐᐎᔨᓐ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐹᑎᔥ ᒥᑐᓐ ᒌ ᒌᔥ ᑎᐱᐦᐋᒥᓈ ᐊᓐ ᐋ ᐄᔑ ᒥᓯᓂᐦᐄᒑᐱᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ᒋᒌ ᐹᐦᑖᓈᐙᐤ ᐋ ᐄᓈᓅᒡ, ‘ᐊᑳᐐ ᐐᒋᐱᓯᒀᑎᓰᒥᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ, ᐊᐙᓐ ᑭᓂᐙᐱᒫᒑ ᐃᔅᒀᐤ, ‘ᑭᒫ ᐐᒋᐱᒥᔑᒥᒃ ᐋᐦ ᐄᑖᐦᔨᐦᑎᒃ’, ᔖᔥ ᐱᓯᒀᑎᓰᐤ ᐅᑖᐦᐄᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ᐋᒄ ᒫᒃ ᐄᐦᑐᑖᑯᔨᓈ ᒋᔅᒌᔑᒄ ᒋᓂᐦᐄᐎᓂᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ ᑯᐃᑯᓐ, ᒑ ᐙᐱᓂᒥᓐ᙮ ᐊᐅᔅᑖ ᒥᔻᔑᐤ ᒑ ᒌᐦ ᐎᓂᐦᑖᔨᓐ ᐊᐱᔒᔥ ᒋᔨᐤ ᐃᔥᐱᔥ ᐐ ᒥᓯᐙ ᒋᔨᐤ ᒑ ᒌᐦ ᐄᔑ ᐙᐱᓂᑭᓂᐎᒡ ᒥᒋᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ᑭᔮᐦ ᒫᒃ ᐄᐦᑐᑖᑯᔨᓈ ᒋᑎᐦᒌ ᒋᓂᐦᐄᐎᓂᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᒥᓂᔕᐦ ᒑ ᐙᐱᓂᒥᓐ᙮ ᐊᐅᔅᑖ ᒥᔻᔑᐤ ᒑ ᒌᐦ ᐎᓂᐦᑖᔨᓐ ᐹᔨᒄ ᐊᓐ ᒋᑎᐦᒌ ᐃᔥᐱᔥ ᐐ ᒥᓯᐙ ᒋᔨᐤ ᒑ ᒌᐦ ᐄᔑ ᐙᐱᓂᑭᓂᐎᒡ ᒥᒋᔥᑯᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ᑭᔮᐦ ᒫᒃ ᒌᐦ ᐄᓈᓅᐦᑖᑯᐱᓐ, ‘ᐊᐙᓐ ᐋ ᐙᐱᓈᑦ ᐐᐤᐦ ᒋᐱᐦ ᒥᔮᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᐋ ᐙᐱᓈᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ, ᓈᐹᐤ ᐋ ᐙᐱᓈᑦ ᐐᐤᐦ ᐋᑦ ᐋᑳ ᓂᑎᐐ ᐃᔨᐦᑎᔨᒡ, ᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᐐᐤᐦ ᒑ ᒌᐦ ᐐᒋᐱᓯᒀᑎᓰᒫᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ᙮ ᑭᔮᐦ ᐊᓐ ᓈᐹᐤ ᑳ ᐐᒋᒫᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᐙᐱᓂᒫᑭᓂᐎᔨᒡ ᐃᔅᒀᐤᐦ ᐱᓯᒀᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“ᒦᓐ, ᒋᐹᐦᑖᓈᐙᐤ ᑳ ᐄᑖᑭᓂᐎᐙᒀ ᐙᔅᑭᒡ ᐄᔨᔨᐅᒡ, ᐊᑳᐐ ᒋᑭ ᓂᓂᑎᔨᓐ ᐋ ᒋᐦᒋ ᓂᔅᑯᒧᐙᒑᐙᑦ ᒋᔖᒥᓂᑑ ᐋᔑᓂᑳᓱᑦ, ᒥᒄ ᔮᔨᑖ ᒋᑭ ᑖᑭᔑ ᑐᑎᐙᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒥᓯᐙ ᑳ ᐄᔑ ᒋᐦᒋ ᓂᔅᑯᒧᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","“ᒥᒄ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ, ᐊᑳᐐ ᒥᑐᓐ ᑭᑎ ᐃᔨᐤ ᐊᐙᓐ ᐋ ᓈᔅᐱᒋᑖᑆᑦ᙮ ᐊᑳᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ ᓈᔅᐱᒋᑖᑆᒄ ᐙᔥ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐤ ᑖᐦᑎᐱᐎᓐ, ");
INSERT INTO crl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ᑭᔮᐦ ᐊᑳᐐ ᐊᔅᒌᐦᒡ ᐄᔑ ᓈᔅᐱᒡᑖᑆᒄ, ᐙᔥ ᐋᑯᑖᐦ ᑎᔮᐦᑎᔥᑖᑦ ᒋᔖᒥᓂᑑ ᐅᓯᑦ, ᐊᑳᐐ ᐙᐙᒡ ᐊᓐ ᐃᐦᑖᐎᓐ ᒉᕉᓯᓕᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐄᔑ ᓈᔅᐱᒋᑖᑆᒄ, ᐙᔥ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐅᑎ ᐃᐦᑖᐎᓐ ᒋᔖᒥᓂᑑ ᐊᓐ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒋᐦᒋᐅᒋᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ᐊᑳᐐ ᐙᐙᒡ ᒋᔅᑎᒀᓂᐙᐦᒡ ᐄᔑ ᓈᔅᐱᒋᑖᑆᒄ ᐙᔥ ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒀᐹᒡ ᒋᔅᑎᒀᓂᐲᐎᐙᐤ ᒋᑭ ᒋᑐᑖᓈᐙᐤ ᒑ ᒌᐦ ᐎᔨᐹᒡ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐙᐹᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","ᒥᒄ ᓃᐦᐄ ᑭᔮᐦ ᒫᒃ ᓂᒫᐦ ᒋᐱᐦ ᐃᔨᓐ ᐋᐦ ᐄᔥ ᑖᑆᔨᓐ᙮ ᑯᑎᒡ ᒫᒃ ᒑᒀᓐ ᐄᔨᔨᓈ ᐋ ᓂᑎᐙᔨᐦᑎᒥᓐ ᒑ ᒌ ᑖᑆᐦᑖᑭᐎᔨᓐ, ᒥᒋᒥᓂᑑ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ᑭᔮᐦ ᒫᒃ ᒋᒌ ᐹᐦᑖᓈᐙᐤ ᐊᓂᑖᐦ ᐙᔅᑭᒡ ᐋ ᒌᐦ ᐄᓈᓅᒡ, ‘ᐃᔮᔪᐦᑖᐎᑖ ᐊᐙᓐ ᐅᔥᒌᔑᒄ, ᑭᔮᐦ ᒌᔨ ᒋᔥᒌᔑᒄ ᒋᐱᐦ ᐃᔮᔪᐦᑖᑭᓂᐤ, ᑭᔮᐦ ᒫᒃ ᒥᓈᐱᑖᐦᐅᑖ ᐊᐙᓐ ᑭᔮᐦ ᒌᔨ ᒋᐱᐦ ᒥᓈᐱᑖᐦᐅᑰᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ᒥᒄ ᒫᒃ ᓃᔨ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᑳᐐ ᓂᔅᑯᔅᑑ ᐊᐙᓐ ᐋ ᒌ ᒥᒋᐦᑐᑖᔅᒃ᙮ ᐊᐙᓐ ᐅᑖᒥᐦᒀᐦᐆᔅᑳ ᒋᑖᒥᐦᑭᓂᐦᒡ, ᒥᔨ ᐋᑯᔥ ᐊᓂᑖᐦ ᒀᔥᑖ ᐄᑖᐦᒑ ᑭᔮᐦ ᒑ ᒌᐦ ᐅᑖᒥᐦᒀᐦᐆᔅᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐄᑐᐦᑎᐦᐄᔅᑳ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᐄᑎᔅᒃ ᒑ ᒌ ᑎᐱᐦᐅᓱᐙᑦ ᒋᐱᒋᐎᔮᓂᔨᐤ ᐋ ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᐋᑯᔥ ᒥᔨ ᒑ ᒌᐦ ᐃᔮᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᑎᑯᐦᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ᐊᐙᓐ ᒫᒃ ᔒᐦᒋᒥᔅᑳ ᒑ ᒌᐦ ᐐᐅᔔᑦ ᐐᐎᑦ ᐹᔨᒄ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ, ᐋᑯᔥ ᓃᔓ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ ᐃᔥᐱᔥ ᐄᑐᐦᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ᑭᔮᐦ ᐊᐙᓐ ᓂᑎᐙᔨᐦᑎᒫᔅᑳ ᒑᒀᔨᐤ, ᒥᔨ᙮ ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐐᐦ ᐊᐅᐦᐋᓲᒥᔅᑳ ᒑᒀᔨᐤ, ᒥᔨ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᐙᐦ ᐊᐅᐦᐋᓱᒥᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“ᒋᒌ ᐹᐦᑖᓈᐙᐤ ᐋ ᐄᓈᓅᒡ ᐊᓂᑖᐦ ᐙᔅᑭᒡ, ‘ᓵᒋᐦᐋᐦᑯᒡ ᒌᐦ ᐐᒑᐙᑭᓂᐙᐅᒡ, ᐅᐦᑳᑖᐦᑯᒡ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᑖᑯᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ, ᓵᒋᐦᐋᐦᑯᒡ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᑖᑯᒡ ᑭᔮᐦ ᐊᔨᒥᐦᐋᔥᑎᒫᐦᑯᒡ ᐊᓂᒌ ᑳ ᓂᓈᐦᑳᒋᐦᐄᑖᑯᒡ, ");
INSERT INTO crl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ᐋᒄ ᒫᒃ ᒑ ᐅᑯᓯᑐᑖᑖᒄ ᐊᓐ ᑰᐦᑖᐐᐙᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ᙮ ᐙᔥ ᑖᐱᔥᑯᓐ ᒥᔮᐤ ᐊᓂᔮᔨᐤ ᑳ ᒥᒋᐦᑑᑎᒥᔨᒡ ᑭᔮᐦ ᑳ ᒥᔪᑐᑎᒥᔨᒡ ᒑ ᒌ ᐙᔥᑖᓂᒫᑯᔨᒡ ᐲᓯᒻ, ᑭᔮᐦ ᑖᐱᔥᑯᓐ ᒥᔮᐤ ᐋ ᒋᒨᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᔪᑐᑎᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒥᒌᐦᑐᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ᒑᒀᔨᐤ ᒋᐱᐦ ᐅᐦᒋ ᒥᔨᒄ ᒋᔖᒥᓂᑑ ᒌᐦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒥᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓵᒋᐦᐄᔅᒡ ᓵᒋᐦᐄᑣᐙ᙮ ᐙᔥ ᐋᔪᐎᒄ ᐋᓐ ᒥᓯᐙ ᐋᐦᑎᒡ ᐊᓂᒌ ᑳ ᒥᒋᐦᑑᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ᑭᔮᐦ ᒫᒃ ᒥᒄ ᒌᐦ ᐐᒑᐙᑭᓂᒡ ᐊᔨᒥᐦᐄᑣᐙ, ᒑᒀᓐ ᐋᐦ ᑐᑎᒥᓐ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋᐦᐋᑳ ᑐᑎᐦᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ? ᐙᔥ ᒥᓯᐙ ᐋᔪᐎᒄ ᐋᐦᑎᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ᒧᔮᒻ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᑳ ᐃᔥᐱᔥ ᒥᑐᓐ ᑯᐃᔅᒄ ᑎᒃ, ᐋᐅᒄ ᒋᐱᐦ ᐄᔑ ᒥᑐᓐ ᑯᐃᔅᒄ ᐃᐦᑎᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ᐃᔮᒀᒦᒄ ᒑᐦ ᐋᑳ ᒥᒄ ᐄᐦᑐᑎᒫᒄ ᒌ ᒥᔪᐦᑣᐤ ᐋ ᐃᔨᐦᑎᐎᓂᐙᐤ ᒥᒄ ᐋ ᓂᑎᐙᔨᒫᑯᒡ ᐄᔨᔨᐅᒡ ᒑ ᐙᐱᒥᑖᑯᒡ, ᐙᔥ ᒥᔑᐤ ᐆ ᐅᐦᒌ ᑐᑎᒫᒀ, ᓂᒧᐎᔾ ᒋᑭ ᒥᔨᑯᐙᐤ ᑎᐱᐦᐋᒫᑯᓯᐎᓂᔨᐤ ᑯᐦᑖᐎᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ᐋᒄ ᒫᒃ ᐋ ᒥᔮᒄ ᐊᐙᓐ ᒑᒀᔨᐤ ᐋ ᐄᔑ ᓅᐦᑖᐱᔨᑦ, ᐊᑳᐐ ᑐᑎᒧᒄ ᐆ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ, ᐙᔥ ᐐᔨᐙᐤ ᐊᓂᒌ ᑳ ᐊᔨᒥᐦᐋᑳᓱᒡ ᓈᔥᒡ ᐐᐦ ᑭᒑᔅᒑᔨᐦᑖᑯᐦᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᒥᔪᐃᐦᑐᑎᐦᒡ ᐋ ᐙᐱᒫᑭᓂᐎᒡ ᐊᓂᑖᐦ ᒎᐤ ᐋᔮᒥᐦᐋᐆᑭᒥᑯᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ᙮ ᒥᒄ ᐋ ᐄᑖᔨᐦᑎᐦᒡ ᒑ ᒌ ᒫᒥᐦᒋᒥᑯᒡ ᐊᐙᔨᐤᐦ᙮ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᔖᔥ ᒌᓵᒡ ᒥᔮᑭᓂᐎᒡ ᐅᑎᐱᐦᐋᒫᑯᓰᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ᒫᒃ ᐋ ᐐᒋᐦᐋᒄ ᐊᐙᓐ ᐋ ᒋᔅᑎᒫᑎᓯᑦ, ᐊᑳᐐ ᓈᔅᑏᔨᔅ ᐱᐹᒫᒋᒥᐦᒄ ᑖᓐ ᑳ ᐄᔑ ᐐᒋᐦᐋᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ᒥᒄ ᒌᔨᐙᐤ ᒋᐱᐦ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᔪᑐᑎᒫᒄ᙮ ᐋᒄ ᒫᒃ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒑ ᑎᐱᐦᐊᒫᑖᒄ ᐙᔥ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐙᐱᐦᑎᒻ ᑖᓐ ᐋᐦᑑᐙᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“ᑭᔮᐦ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᔮᒄ, ᐊᑳᐐ ᑎᐦᒄ ᐋᐦ ᑎᒡ ᐊᓂᒌ ᐅᑎᔨᒥᐦᐋᑰᓱᐎᒡ᙮ ᓈᔥᒡ ᐋ ᒥᔻᔨᐦᑎᐦᒡ ᐋ ᓈᓃᐱᐎᒡ ᐋ ᐊᔨᒥᐦᐋᒡ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐋᐦ ᐄᒋᐦᑎᐎᒧᔨᔨᒡ ᐱᒧᐦᑖᔅᑭᓂᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐙᐱᒥᑯᒡ᙮ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᔖᔥ ᐃᔮᐅᒡ ᐅᑎᐱᐦᐋᒫᑯᓰᐎᓂᐙᐤ ᐅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ᒌ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᔨᓐ, ᒌ ᓂᐹᐅᑭᒥᑯᐦᒡ ᒋᐱᐦ ᒋᐱᐦᐆᓱᓐ, ᐄᔥᐱᐦ ᒫᒃ ᒌ ᒋᐱᐦᐆᓱᔨᓈ ᐋᒄ ᒑ ᐊᔨᒥᐦᐄᑦ ᑰᐦᑖᐐ ᐊᓐ ᐋᑳ ᑳ ᒌ ᐙᐱᒫᑭᓅᑦ᙮ ᒌ ᐙᐱᒧᒄ ᐐᔨ ᑖᓐ ᐋᐦ ᑐᑎᐦ ᐋᐦᐋᑳ ᑯᑎᒃ ᐊᐙᓐ ᐙᐱᒥᔅᒄ, ᐐᔨ ᒫᒃ ᒋᑭ ᑎᐱᐦᐊᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“ᑭᔮᐦ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᔮᒄ, ᐊᑳᐐ ᐋᐱᒋᐦᑖᐦᒄ ᐊᔨᒧᐎᓐ ᒥᑐᓐ ᐋᐦᐋᑳ ᒑᒀᓐ ᐄᑎᑖᑯᐦᒡ ᒧᔮᒻ ᐋᐦ ᑎᒡ ᐊᓂᒌ ᐊᔨᐦᒡ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ, ᐋ ᐄᑖᔨᐦᑎᐦᒡ ᒑ ᐹᐦᑖᑯᒡ ᒋᔖᒥᓂᑑ ᒥᒄ ᐊᓂᔮᔨᐤ ᓈᐆᔅ ᐋ ᐊᔨᒥᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ᐊᑳᐐ ᓂᔅᐱᑐᐙᐦᑯᒡ ᐅᒌ᙮ ᐙᔥ ᑰᐦᑖᐐᐙᐤ ᒋᔅᒑᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᒋᑭ ᐋᔮᑖᐙᐤ, ᐋᒸᔮ ᓂᑎᐙᔨᐦᑎᒧᐙᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ᐋᐅᒄ ᐆ ᒑ ᐄᔑ ᐊᔨᒥᐦᐋᔮᒄ, ᓄᐦᑖᐎᓈᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦᑖᔨᓐ, ᑭᑎ ᒋᔅᑖᔨᐦᑖᑭᓂᐤ ᐋ ᐱᔮᐦᒋᓰᒥᑭᐦᒡ ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ᒌ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᑭᑎ ᐅᑎᒋᐱᔨᐤ᙮ ᒌᔨ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᑭᑎ ᑐᑖᑭᓂᐤ, ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒧᔮᒻ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ᒥᔨᓈᓐ ᑎᐦᑐ ᑳᔑᑳᒡ ᐋᐃᐦᑯᓈᐤ ᒑ ᐅᐦᒋ ᐱᒫᑎᓰᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ᐙᐹᔨᐦᑎᒨᓈᓐ ᓂᒥᒋᐦᑣᐎᓈᓐ ᒧᔮᒻ ᑖᓐ ᑳ ᐄᔑ ᐙᐹᔨᐦᑎᒧᐎᒋᐦᒡ ᐊᓂᒌ ᑳ ᐎᓂᑐᑎᐎᔨᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ᐊᑳᐐ ᒫᒃ ᐄᑐᐦᑎᐦᐄᓈᓐ ᐊᓂᑖᐦ ᒑ ᒌᐦ ᑯᒀᒋᐦᐄᑭᐎᔮᐦᒡ᙮ ᒥᒄ ᒥᑖᒀᓂᒧᓈᓐ ᐊᓐ ᑳ ᒫᔮᑎᐦᒡ᙮” ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒌᓴᔅ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᒑ ᐄᔑ ᐊᔨᒥᐦᐋᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","ᐋᒄ ᒫᒃ ᒦᓐ ᑳᐦ ᐃᔨᑦ, “ᐙᔥ ᐙᐹᔨᐦᑎᒨᑣᐙ ᑯᑎᑭᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑖᔅᒡ, ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᑭ ᐙᐹᔨᐦᑎᒫᑯᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ᐋᒄ ᒫᒃ ᒥᔔ ᐋᑳ ᐙᐹᔨᐦᑎᒨᑣᐙᑰᒑ ᑯᑎᑭᒡ ᓂᒧᐃ ᑭᔮᐦ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᑭ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒫᑯᐙᐤ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒸᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“ᑏᔮᒀ ᒫᒃ ᐋᑳ ᒥᒋᓲᔮᒄ ᐋᐦ ᐊᔨᒥᐦᐋᔮᒄ ᐅᐦᒋ, ᐊᑳᐐ ᒥᓯᒫᔨᐦᑎᒧᓈᑯᐦᐄᓱᒄ ᒧᔮᒻ ᐋᐦ ᑎᒡ ᐊᓂᒌ ᑳ ᐐ ᒥᔪᐦᑣᐦᑳᓯᐎᒡ᙮ ᐱᐹᒧᐦᑖᐅᒡ ᓈᔥᒡ ᐋ ᓂᓈᐦᑳᔑᓈᑯᐦᐄᓱᒡ ᒑ ᒌ ᐙᐱᒥᑯᒡ ᑭᔮᐦ ᒑ ᒌ ᒋᔅᒑᔨᒥᑯᒡ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᒦᒋᓱᒡ᙮ ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐙᐤ, ᔖᔥ ᒥᑐᓐ ᐃᔮᐅᒡ ᐅᑎᐱᐦᐋᒫᑯᓯᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ᑎᔨᒀ ᒫᒃ ᐋᐦᐋᑳ ᒦᒋᓱᔮᒄ, ᑳᓰᐦᒀᐦᐅᒄ ᑭᔮᐦ ᔒᑭᐦᐆᒄ, ");
INSERT INTO crl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ᒑᐦ ᐋᑳ ᒋᔅᒑᔨᒥᑖᑯᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᒦᒋᓱᔮᒄ, ᒥᒄ ᒫᒃ ᑯᐦᑖᐎᐙᐤ ᐊᓐ ᐋᑳ ᑳ ᒌ ᐙᐱᒫᑭᓅᑦ ᐊᓐ ᓅᐦᑖᐐᐙᐤ ᐋ ᒋᔅᒑᔨᒥᑖᒄ ᒥᓯᐙ ᐹᔨᐦᑖᔮᐱᐦᑎᐦᒃ ᒑᒀᔨᐤ ᐐᔨ ᒋᑭ ᑎᐱᐦᐊᒫᑯᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“ᐊᑳᐐ ᓈᐦᐋᐆᔅᑣᓲᒄ ᒦᓯᒋᓰᐎᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᒑ ᒌᐦ ᐃᔮᔪᐦᑖᒡ ᒥᓐᑑᔑᒡ ᑭᔮᐦ ᒑ ᒌᐦ ᐊᒀᒀᐱᔅᒋᐱᔨᐦᒡ ᑭᔮᐦ ᒋᒧᑎᔅᑭᒡ ᐋᐲᐦᑖᐲᐦᐅᒡ ᒑ ᒌᐦ ᑭᒑᒧᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ᒥᒄ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᑯᑖᐦ ᐄᔑ ᓈᐦᐋᐆᔅᑣᓲᒄ ᒦᓯᒋᓰᐎᓐ ᐊᓂᑖᐦ ᐋᑳ ᒑ ᒌᐦ ᐃᔮᔪᐦᑖᒡ ᒥᓐᑑᔑᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌᐦ ᐊᒀᒀᐱᔅᒋᐱᔨᐦᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌᐦ ᑭᒑᒧᑎᒡ ᐋᐲᐦᑖᐲᐦᐅᒡ ᒋᒧᑎᔅᑭᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ᐙᔥ ᑖᓂᑖᐦ ᑭᓂᐙᔨᐦᑖᑯᐦᒡ ᒌ ᒦᓯᒋᓰᐎᓐ ᐋᑯᑖᐦ ᐋᐦᑎᑯᐦᒡ ᒋᑖᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ᒥᔅᒌᔑᒄ ᐋᐅᒄ ᐊᓐ ᒨᔮᒻ ᐙᔅᑖᓂᒫᑭᓐ ᐊᓂᑎᐦ ᒦᔮᐦᒡ᙮ ᐋ ᒥᔻᔨᒡ ᒫᒃ ᐊᐙᓐ ᐅᔥᒌᔑᒄ ᒥᓯᐙ ᐋᔅᐱᔖᔨᒡ ᐅᔨᐤ ᒋᑭ ᓵᑭᔅᒋᓂᔨᐤ ᐙᔅᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ᐋᒄ ᒫᒃ ᐋᑳ ᒥᔻᒑ ᒋᔅᒌᔑᒄ, ᒥᑐᓐ ᒫᒃ ᒋᒃ ᓵᑭᔅᒋᓂᒫᑭᓐ ᐋ ᐅᑳᔮᔅᑖᐎᓐ ᒌᔮᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐋᑳ ᑎᑯᐦᒑ ᐙᔥᑖᐎᓐ ᐊᓂᑖᐦ ᒌᔮᐦᒡ, ᑖᓐ ᐙᔥ ᐋᒄ ᐃᔥᐱᔥ ᐅᑳᔅᑖᔮᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᓈᓃᐦᑎᐙᐤ ᓃᔓ ᐅᒋᒫᐤ, ᐙᔥ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᒋᑭ ᐅᐦᑳᑖᐤ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒑ ᓵᒋᐦᐋᑦ᙮ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᓲᐦᒃ ᒋᑭ ᐋᐱᑎᓰᔥᑎᐙᐤ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᓂᒧᐃ ᒋᑭ ᓂᐦᐋᔨᑎᒻ ᒑ ᒌᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ᙮ ᒋᑭ ᐅᔮᔨᐦᑖᓈᐙᐤ ᐊᐙᓐ ᒑ ᐋᐱᑎᔒᔥᑑᐙᒄ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒫᒃ ᔔᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐄᑎᑯᒡ ᐋᑳ ᒑ ᒌ ᒥᑯᔥᑳᑖᔨᐦᑎᒫᒄ ᒦᒋᒻ ᑭᔮᐦ ᒑᒀᓐ ᒑ ᒥᓂᐦᒀᔮᒄ ᑖᓐ ᐊᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᒄ ᒑ ᒌᐦ ᐅᐦᒋ ᐱᒫᑎᓰᔮᒄ ᑭᔮᐦ ᒫᒃ ᒑᒀᓐ ᒑ ᒋᒋᔥᑭᒫᒄ᙮ ᐙᔥ ᐱᒫᑎᓰᐎᓐ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓐ ᐃᔥᐱᔥ ᐐ ᒦᒋᒻ, ᑭᔮᐦ ᒫᒃ ᒥᔨᐤ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓐ ᐃᔥᐱᔥ ᐐ ᐊᓂᐦᐄ ᒋᒑᒀᓂᒻ ᑳ ᒋᒋᔥᑭᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ᑭᓂᐙᐱᒥᑯᒡ ᐋ ᐱᐹᒥᐦᔮᐦᒡ ᐱᔮᔒᔑᒡ, ᓂᒧᐃ ᓂᐦᑖᐅᒋᐦᑖᐅᒡ ᒑᒀᔨᐤ ᑭᔮᐦ ᓂᒧᐃ ᒫᐅᒋᐦᑖᐅᒡ ᒦᒋᒥᔨᐤ, ᐊᔮᐱᒡ ᒫᒃ ᑰᐦᑖᐎᔾ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᑭᓂᐙᔨᒥᑯᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᒫᐅᒡ ᐊᐅᔅᑖ ᒌ ᒋᔅᑎᒫᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᐃᔥᐱᔥ ᐐ ᐱᔮᔒᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ᐙᔥ ᐋᑎ ᓈᔥᒡ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᑯᔮᒀ ᒑᒀᓐ ᓂᒧᐃ ᐊᑎᑎᐤ ᐊᔮᐱᒡ ᒋᑭ ᒌ ᓅᔅᒋᐦᑖᓈᐙᐤ ᒋᐱᒫᑎᓰᐎᓂᐙᐤ, ᐋᑦ ᒥᒄ ᐹᔨᒀᐤ ᐋ ᒌᓂᒀᓂᐦᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“ᒑᒀᓐ ᐙᐦᒋ ᐋᔨᒫᔨᐦᑎᒫᒄ ᒑᒀᓐ ᒑ ᒋᒋᔥᑭᒫᒄ᙮ ᒫᒥᑐᓈᔨᐦᑎᒧᒄ ᒫᐦ ᓃᐲᔅ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᔻᔑᒡ ᑭᔮᐦ ᐋ ᐄᔑ ᒥᔪ ᓂᐦᑖᐅᒋᐦᒡ᙮ ᓂᒧᐃ ᐋᐱᑎᓰᒥᑭᓐ ᒑ ᒌ ᐙᔅᐱᓲᒥᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ᐊᔮᐱᒡ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᑎ ᐊᓂᔮᔨᐤ ᐋ ᒌᐦ ᐃᔥᐱᔥ ᒥᓰᒋᓰᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᔂᓚᒥᓐ ᓂᒧᐃ ᐅᐦᒋ ᐃᔥᐱᔥ ᒥᔻᔑᔨᐤ ᐅᒑᒀᓂᒻ ᐋ ᐃᔥᐱᔥ ᒥᔻᔒᔨᒡ ᐙᐙᒡ ᐹᔨᒄ ᐅᔮᔨᐤ ᓃᐲᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ᐋᒄ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᒥᔪᓈᑯᑖᒀ ᒋᔖᒥᓂᑑ ᒥᔥᑯᔑᐤᐦ ᓂᑎᐐ ᐋ ᓈᑖᐎᒋᓃᔨᒡ, ᐊᓐ ᒫᒃ ᒥᔥᑯᔑᐤᐦ ᐋᓅᐦᒡ ᑳᔑᑳᒡ, ᐙᐱᐦᒑ ᔖᔥ ᑭᑎ ᒌᐦ ᐃᔥᒀᓯᑭᓅᐤ᙮ ᓂᒧᐃ ᐋ ᐊᐅᔅᑖ ᒌᔨᐙᐤ ᒋᐐᐦ ᒥᔨᑯᐙᐤ ᒑᒀᔨᐤ ᒑ ᐳᔥᑎᔥᑭᒸᒄ, ᒌᔨᐙᐤ ᑳ ᐊᐱᔖᔑᒡ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“ᐊᑳᐐ ᒫᒃ ᒨᔥ ᒫᒥᑐᓈᔨᐦᑎᐦ ᒑ ᒌᐦ ᐄᑖᔨᐦᑎᒥᓐ, ‘ᒑᒀᓐ ᒑ ᒦᒋᔮᓐ?’ ᑭᔮᐦ ᒫᒃ ᒑ ᒌᐦ ᐄᑖᔨᐦᑎᒥᓐ, ‘ᒑᒀᓐ ᒑ ᒥᓂᐦᒀᔮᓐ?’ ᑭᔮᐦ ᒫᒃ ᒑ ᒌᐦ ᐄᑖᔨᐦᑎᒥᓐ, ‘ᒑᒀᓐ ᒑ ᒋᒋᔥᑭᒫᓐ?’ ");
INSERT INTO crl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᒨᔥ ᓂᔮᓂᑐᐙᔨᐦᑎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐃᔨᐦᒡ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ᙮ ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᔅᒑᔨᐦᑎᒻ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ᐊᐅᔅᑖ ᓃᔥᑎᒻ ᐄᑖᔨᐦᑖᑯᓐ ᓲᐦᒃ ᒑ ᒌ ᓈᓂᑐᐙᔨᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᑭᔮᐦ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᓐ, ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑖᒄ ᐃᔅᒡ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᓅᐦᑖᐱᔨᐙᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ᔖᔥ ᑎᑯᓐ ᒑᒀᓐ ᐊᓅᐦᒡ ᒑ ᐅᔥᑎᐙᔨᐦᑎᒥᐦᐄᑯᔮᒄ᙮ ᐊᑳᐐ ᔖᔥ ᐋᔨᒫᔨᐦᑎᒧᒄ ᐆ ᐙᐱᐦᒑ ᒑ ᐄᔅᐱᔨᒡ᙮ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᑎᑯᓐ ᒑ ᒌᐦ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᒑᒀᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“ᐊᑳᐐ ᑎᐹᔅᑯᓂᒑᒄ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑎᐹᔅᑯᓂᑭᐎᓈᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ᐙᔥ ᑖᓐ ᒥᒄ ᒑ ᐄᔑ ᑭᓂᐙᐱᐦᑎᒧᐙᒀ ᑖᓐ ᐋ ᐄᔑ ᑎᐹᔅᑯᓈᒄ ᐊᐙᓐ ᐋᐅᒄ ᒧᔮᒻ ᒑ ᐄᔑ ᑭᓂᐙᐱᐦᑖᑭᓂᐎᒡ ᑭᔮᐦ ᒌᔨ ᑎᐹᔅᑯᓂᑭᐎᓈ᙮ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᔨᐙᑦ ᐊᐙᓐ ᒑᒀᔨᐤ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒧᔮᒻ ᒑ ᐃᔥᐱᔥ ᒥᔮᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᑭᓂᐙᐱᐦᑎᒧᑦ ᒌᒋᔖᓐ ᐋᐦ ᐊᐱᔖᔑᔨᒡ ᐅᐱᔑᓂᐎᓐ ᐋᐦᐋᑳ ᒫᒃ ᐃᔮᐱᑖᔨᐦᑎᒥᓐ ᐋ ᒥᐦᒑᔅᑯᐦᒡ ᒥᔥᑎᒄ ᐋ ᐱᔑᓃᔨᓐ ᒌᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐄᑎᑦ ᒌᒋᔖᓐ, ‘ᓂᑭ ᐱᑯᐦᑖᓐ ᒫᐦ ᒋᐱᔑᓂᐎᓐ,’ ᒌᔨ ᒫᒃ ᐋ ᒥᐦᒑᔅᑯᐦᒡ ᒥᔥᑎᒄ ᐋ ᐱᔑᓃᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ᒌᔨ ᑳ ᐊᔨᒥᐦᐋᑳᓱᔨᓐ, ᓃᔥᑎᒻ ᐱᑯᐦᑖᐦ ᐊᓐ ᒥᔥᑎᒄ ᑳ ᒥᐦᒑᔅᑯᐦᒡ ᒋᔅᒌᓯᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐋᒄ ᒫᒃ ᒑ ᒥᔪ ᐙᐱᐦᑎᒥᓐ ᒑ ᒌ ᐱᑯᐦᑖᐙᑦ ᐊᓂᔮᔨᐤ ᒌᒋᔖᓐ ᐅᐱᓯᓂᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ᐊᑳᐐ ᒥᔮᐦᑯᒡ ᐊᑎᒧᒡ ᒑᒀᔨᐤ ᐋ ᐱᔮᐦᑭᓃᔨᒡ᙮ ᑭᔮᐦ ᐊᑳᐐ ᐄᔑ ᐙᐱᓂᒧᐙᐦᑯᒡ ᑰᐦᑰᔑᒡ ᐋᐦ ᐋᔨᒥᒋᑖᑯᓃᔨᒡ ᐅᐙᔑᐦᐅᐎᓐ ᐙᔥ ᒥᒄ ᑭᑎ ᑖᐦᑎᐦᑯᔥᑳᑎᒧᒡ ᑭᔮᐦ ᒋᑭ ᐋᐱᒨᔥᑖᑯᐙᐅᒡ ᒑ ᒌᐦ ᐅᔑᑯᐦᐄᑖᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ᓂᑐᑎᒫᒄ, ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑯᔮᒄ᙮ ᓈᓂᑐᐙᔨᐦᑎᒧᒄ ᐋᒄ ᒫᒃ ᒑ ᒥᔅᑭᒫᒄ᙮ ᒥᒥᑣᐦᐄᒑᒄ ᐋᒄ ᒫᒃ ᒑ ᐋᐱᐦᐊᒫᑯᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ᐙᔥ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᓂᑐᑎᒫᑦ ᒋᑭ ᒥᔮᑭᓂᐤ᙮ ᑎᐦᑐ ᐊᐙᓐ ᓃᔮᓂᑐᐙᔨᐦᒑᑦ ᒋᑭ ᒥᔅᑭᒻ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᓃᔮᓂᑐᐙᔨᐦᑎᐦᒃ᙮ ᑭᔮᐦ ᑎᐦᑐ ᐊᐙᓐ ᒥᒥᑣᐦᐄᒑᑦ ᒋᑭ ᐋᐱᐦᐊᒧᐙᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ᒌᔨᐙᐤ ᐅᐦᑖᐐᒫᑐᒄ, ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᒋᑯᔅ ᐋᐃᐦᑯᓈᐤ, ᐊᓯᓃ ᐋ ᒋᐱᐦ ᒥᔮᐤ? ");
INSERT INTO crl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ᑭᔮᐦ ᒫᒃ ᓂᒫᔅ ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᐊᒋᓈᐱᒄ ᐋ ᒋᐱᐦ ᒥᔮᐤ? ");
INSERT INTO crl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ᐋᑎ ᐋ ᐃᔥᐱᔥ ᒥᒑᑎᓯᔮᒄ ᐊᔮᐱᒡ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒑ ᒌ ᒥᔪ ᒥᔮᑯᒡ ᒋᑎᐙᔑᔒᒧᐙᐅᒡ ᒑᒀᔨᐤ᙮ ᐊᑎᑎᐤ ᒫᒃ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᑭ ᒥᔪ ᒦᔮᐤ ᐊᓂᔮᔨᐤ ᓈᑑᑎᒫᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᑣᐤ ᐄᔨᔨᐅᒡ ᒑ ᒌᐦ ᑐᑎᒫᔅᒡ ᐋᔪᐎᒄ ᐄᐦᑐᑎᒧᒡ᙮ ᐋᐅᒄ ᐆ ᑖᐱᔥᑯᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᒥᑭᐦᒡ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᐙᐐᐦᑎᐦᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“ᓃᔑᓐ ᐃᔥᒀᐦᑖᒻ, ᐹᔨᒄ ᐋᔨᑭᔥᑳᐤ ᐋᒄ ᐊᓐ ᐹᔨᒄ ᔖᑯᐙᔔ᙮ ᐊᓐ ᒫᒃ ᑳᔖᑰᐙᒡ ᐃᔥᒀᐦᑖᒻ ᐋᑯᑖᐦ ᒋᐱᐦ ᐅᐦᒋ ᐲᐦᒑᓈᐙᐤ, ᐙᔥ ᐊᓐ ᐃᔥᒀᐦᑖᒻ ᑳᐦ ᐋᔨᑭᔥᑳᒡ ᐙᐦᑎᓐ ᒑ ᒌ ᐲᐦᒑᓅᐎᒡ ᐊᓐ ᒫᔅᑭᓂᐤ ᐊᓂᑖᐦ ᑳ ᐄᑎᒨᐦᒡ, ᒥᒄ ᒫᒃ ᓂᔑᐎᓈᑎᓯᐎᓂᒡ ᐄᑎᒨ᙮ ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᐲᐦᑐᒑᐅᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᑭᔅᑳᔨᒡ ᐃᔥᒀᐦᑖᒥᔨᐤ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᐋ ᐱᒧᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ᐙᔥ ᑯᐃᔓᐙᐤ ᐃᔅᒀᐦᑖᒻ, ᑭᔮᐦ ᑯᐃᔓᒨ ᒫᔅᑭᓂᐤ ᐱᒫᑎᓰᐎᓂᐦᒡ ᐋᑎᒧᒡ, ᒥᒄ ᑎᑭᐙᔑᐎᒡ ᒫᒃ ᐊᓂᒌ ᒫᔅᑭᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ᐃᔮᒀᒦᔥᑎᐙᐦᑯᒡ ᒥᒋᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐃᓯᓈᑯᓯᐎᒡ ᐅᑎᐦ ᐅᔅᒋᒡ, ᒥᒄ ᒫᒃ ᐲᐦᒡ ᒧᔮᒻ ᒥᐦᐄᐦᑭᓂᒡ ᐋ ᐎᓂᐲᐦᐄᐙᒡ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","“ᐅᑎᐦᑎᐎᓂᐙᒡ ᒋᑭ ᐅᐦᒋ ᒋᔅᒑᔨᒥᐙᐎᒡ᙮ ᒨᔮᒻ ᐋᐦ ᑎᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᒨᔔᒡ ᑳ ᐊᓯᒧᔒᒡ ᒦᓂᔥ ᑳᑳᐙᔅᑯᐦᒡ ᐅᐦᒋ, ᒥᒄ ᒫᒃ ᐊᓂᑎᐦ ᒥᔪᔔᒥᓈᐦᑎᑯᒡ ᐋᑯᑎᐦ ᐙᐦᒋ ᒨᔔᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ᐙᔥ ᒧᔮᒻ ᐋ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᒥᔥᑎᒄ ᐋ ᒥᔪᔑᒡ ᒥᔪᒥᓐ ᒋᑭ ᓂᐦᑖᐅᒋᐦᐅᒡ ᐊᓂᑎᐦ ᐊᓐ ᒥᔥᑎᒄ ᐋᒄ ᒫᒃ ᐋᐦᐋᑳ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᒥᔥᑎᒄ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᑖᐅᒋᐦᐅᒡ ᐋ ᒥᔪᔑᒡ ᒥᔪᒥᓐ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ᐋ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᒥᔥᑎᒄ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᑖᐅᒋᐦᑖᐤ ᒥᒋᒥᓐ ᑭᔮᐦ ᒫᒃ ᐋᐦᐋᑳ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᒥᔥᑎᒄ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᑖᐅᒋᑖᐤ ᒥᔪᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ᒥᓯᐙ ᒥᔅᑎᑯᒡ ᐋᑳ ᑳ ᒥᔪ ᒦᓂᔑᐎᒡ ᒋᑭ ᓈᑣᑭᐦᐙᑭᓅᐎᒡ ᐋᒄ ᒑ ᒧᒋᔥᑖᐙᐱᓈᑭᓂᐎᒡ ᐃᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐄᑎᑯᒡ ᐅᑎᔨᐦᑎᐎᓂᐙᒡ ᒋᑭ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐙᐎᒡ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᒥᔅᑎᑯᐦᒡ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“ᓂᒧᐃ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᐹᒋ ᐃᔑᓂᐦᑳᓯᑦ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᑎᐹᔨᐦᒋᒑᓯᐤ,’ ᒋᑭ ᐅᐦᒋ ᐲᐦᒑᐤ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ, ᒥᒄ ᐊᓂᒌ ᑳᐦ ᑐᑎᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᑯᒡ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᒑ ᐲᐦᒑᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","“ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᓂᑭ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓐ ᓂᒌᐦ ᐋᐱᒋᐦᑖᓈᓐ ᐋ ᒋᔅᒋᐙᐦᐄᒑᔮᐦᒡ, ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓐ ᑭᔮᐦ ᓂᒌᐦ ᐋᐱᒋᐦᑖᓈᓐ ᒥᐦᒑᑐ ᒥᒋᐊᐦᒑᐦᑯᒡ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᐲᐦᒋᔥᑯᐙᒡ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐆᒋᒡ, ᑭᔮᐦ ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ ᓂᒌᐦ ᑐᑖᓈᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ᐋᒄ ᒫᒃ ᒧᔖ ᒑ ᐄᑎᒀᐤ, ‘ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᒋᔅᒑᔨᒥᑎᓈᐙᐤ᙮ ᒫᒌᒄ, ᐄᒑᐦᑖᒄ ᓈᑖᐦ ᒌᔨᐙᐤ ᑳ ᒥᒑᑎᓯᔮᒄ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ᒥᓯᐙ ᐊᐙᓐ ᑳ ᓂᑐᐦᑎᐦᒃ ᓂᑎᔨᒥᐎᓂᔨᐤ ᑳᐦ ᐋᑎ ᐄᐦᑐᑎᐦᒃ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐃᔨᐅᒡ, ᒧᔮᒻ ᓈᐹᐤ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒃ ᐊᓂᑖᐦ ᐋ ᐹᐦᐹᒋᐱᔅᑳᔨᒡ ᑳ ᐐᔨᑳᐳᐦᑖᑦ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ ᐄᑖᔨᐦᑖᑯᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","“ᐃᔥᐱᔥ ᒫᒃ ᒥᔥᑏᐦ ᒋᒨᓃᔨᒡ, ᑭᔮᐦ ᐋᐦ ᐋᑎ ᐅᑎᐦᒋᐳᑖᔨᒡ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ ᑭᔮᐦ ᒫᒃ ᐄᔥᐱᐦ ᒥᔥᑏᐦ ᔫᑎᓃᔨᒡ ᓂᒧᐃ ᐙᐙᒡ ᒋᑭ ᐅᐦᒋ ᐋᐦᑖᔅᑎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ, ᐙᔥ ᓈᔥᑖᑆᐦ ᒌᐦ ᔮᐃᒋᑳᐳᐦᑖᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᐹᐦᐹᒋᐱᔅᑳᔨᒡ ᐋ ᒌᐦ ᐐᔨᑳᐳᐦᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ᐋᒄ ᐊᐙᓐ ᑳ ᓂᑐᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᐃᔨᐅᒡ ᐋᐦᐋᑳ ᒫᒃ ᑐᑎᐦᒃ ᒧᔮᒻ ᐊᐙᓐ ᐋᐦᐋᑳ ᐄᑆᐦᑳᑦ ᐊᓂᑖᐦ ᔮᑳᐦᒡ ᑳ ᐐᔨᑳᐳᐦᑖᑦ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","“ᐃᔥᐱᔥ ᒫᒃ ᒥᔥᑏᐦ ᒋᒨᓃᔨᒡ, ᐋᐦ ᐋᑎ ᐅᑎᐦᒋᐳᑖᔨᒡ ᒫᒃ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ, ᑭᔮᐦ ᒫᒃ ᒥᔥᑏᐦ ᔫᑎᓃᔨᒡ, ᒥᑐᓐ ᑭᐅᐱᔨᐤ ᑭᔮᐦ ᒥᑐᓐ ᐃᔮᔪᐎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ᐃᔥᐱᔥ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᑖᓐ ᑳ ᐐᐦ ᐃᔨᑦ, ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᒥᑰ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ᐙᔥ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒌ ᓂᔅᑐᐦᑖᑯᓲ ᐋ ᐃᔮᑦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ, ᓂᒧᐃ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐱᔮᒋ ᓃᐦᑖᐦᑎᒋᐙᑦ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ, ᒥᐦᒑᑐ ᐄᔨᔨᐤᐦ ᒌᐦ ᐋᑎ ᓅᔔᔥᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ᐋᒄ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳᐦ ᐋᐦᒀᑎᓃᔨᒡ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ ᐋ ᐃᔮᔨᒡ ᑳ ᐹᒋ ᓈᑎᑯᑦ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᔨᒡ ᐊᓂᑖᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐐᐦ ᐹᒋ ᐐᒋᐦᐄᔨᓈ ᒋᑭ ᒌᐦ ᑐᑖᓐ ᒑ ᒌ ᐱᔮᐦᒋᓯᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ᒌᓴᔅ ᒫᒃ ᒌ ᑖᐦᒋᓈᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᐐᐦ ᐐᒋᐦᐄᑎᓐ, ᐱᔮᐦᒋᓰᐦ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒦᓂᐙᑎᓰᐤ ᐊᓐ ᓈᐹᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᔮᔨᑖ ᐊᑳᐐ ᓈᔥᑎᔨᒡ ᐐᐦᑎᒨ ᐊᐙᓐ ᐹᑎᔥ ᒋᓂᑑᒋᔅᒑᔨᒥᔅᑳ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ᙮ ᑭᔮᐦ ᒌ ᐱᒋᔅᑎᓂᒫᓈ ᐊᓐ ᒥᔨᐙᐎᓐ ᐊᓂᔮᔨᐤ ᒧᓱᔅ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᒥᔨᐙᓂᐎᔨᒡ ᐄᔥᐱᐦ ᐋ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᐊᐙᓐ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐅᐦᒋ ᒑ ᒋᔅᒑᔨᒥᔅᒡ ᐄᔨᔨᐅᒡ ᒥᑐᓐ ᐋ ᒦᓂᐙᑎᓰᐅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ᐄᔥᐱᐦ ᒌᓴᔅ ᑖᑯᔑᐦᒃ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒌ ᓂᒋᔥᑳᑰ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡᐦ ᓂᑐᐱᔨᐤᐦ ᐋ ᐱᑯᓵᔨᒥᑯᑦ ᒑ ᒌᐦ ᐐᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ᐋᐦ ᐄᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᑖᐱᒋᐦᐋᑭᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᔮᐦᒡ ᑖᐤ ᐋᐦ ᐋᐦᑯᓯᑦ ᐋᐦᐋᑳ ᒌᐦ ᐋᐦᑎᓂᓱᑦ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᐙᐐᓯᑭᒥᒋᐦᐅᑦ ᒥᒄ ᐋ ᐱᒥᔑᒃ ᐅᓂᐹᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᑭ ᓂᑎᐙᐱᒫᐤ, ᒑ ᒦᓂᐙᒋᐦᐄᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ᐋᒄ ᐊᓐ ᓂᑐᐱᔨᐅᒋᒫᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᓂᒧᐃ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᐹᒋ ᐲᐦᒑᔨᓐ ᓂᐙᔅᑳᐦᐄᑭᓂᒥᐦᒡ᙮ ᒥᒄ ᒫᒃ ᐃᔨᐦ ᒑ ᒌ ᒦᓂᐙᑎᓰᑦ ᓂᑖᐱᒋᐦᐋᑭᓐ ᐋᒄ ᒫᒃ ᒑ ᒦᓂᐙᑎᓰᑦ ᐋᑦ ᐋᑳ ᑎᑯᔑᓃᔨᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ᓂᒋᔅᒑᔨᐦᑖᓐ ᒑ ᒌᐦ ᑐᑎᒥᓐ ᐆ, ᑭᔮᐦ ᓃᔨ ᑖᐅᒡ ᓅᒋᒫᒥᒡ ᐋ ᐱᔑᒋᐦᐄᒀᐤ᙮ ᑭᔮᐦ ᒫᒃ ᑖᐅᒡ ᓂᑐᐱᔫᒡ ᓃᔨ ᐋ ᐙᐐᔔᒥᒀᐤ᙮ ᐋᐦ ᐄᑎᒄ ᐹᔨᒄ ᓂᑐᐱᔨᐤ ᐊᓂᑖᐦ ᐄᑐᐦᑖ, ᑏᐙᐦᒡ ᐋᑯᑖᐦ ᐋ ᑐᐦᑖᑦ ᑭᔮᐦ ᒫᒃ ᐋᐦ ᐄᑎᒄ ᓂᑐᐱᔨᐤ, ᐋᔥᑎᒻ, ᑏᐙᐦᒡ ᑎᑯᔑᓐ᙮ ᐋᒄ ᑭᔮᐦ ᑯᑎᒃ ᐋᐦ ᐄᑎᒄ ᓂᑖᐱᒋᐦᐋᑭᓐ ᐆ ᒫᐦ ᑐᑎᐦ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐋᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐱᔮᐦᑎᐙᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᓈᔥᑖᑆᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᐙᐤ ᐅᑖᑆᐦᑎᒧᐎᓂᔨᐤ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᐐᒑᐅᑯᑦ, “ᐋᑦ ᒫᒃ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᑦ ᐆ ᓈᐹᐤ ᐋᔥᒄ ᓂᒧᐃ ᓅᐦᒋ ᐙᐱᐦᑖᓐ ᐋ ᐃᔥᐱᔥ ᒦᔅᑰᐙᒡ ᑖᑆᔮᔨᐦᑎᒨᐎᓐ ᐅᑎᐦ ᐃᔅᕋᐃᓕᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐙᐱᓅᑖᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᒋᔥᑑ ᒋᑭ ᐅᐦᑐᐦᑖᐅᒡ ᐄᔨᔨᐅᒡ ᒑ ᐐᑎᐱᒫᒡ ᐋᑉᕋᐦᐋᒻᐦ, ᐋᐃᓵᒃᐦ ᑭᔮᐦ ᒉᑭᑉᐦ ᒥᑯᔖᓂᐎᔨᒑ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᐊᐦᐋᑦ ᒥᓯᓈᓱᒡ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᐊᔮᐱᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐲᐦᑎᑭᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ᙮ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᒋᑭ ᐄᔑ ᐙᐱᓈᑭᓂᐎᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᒫᑑᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐅᒋᒫᐤ, “ᒌᐙ, ᑖᓐ ᑳ ᐄᔑ ᑖᑆᐦᑎᒥᓐ ᐋᐅᒄ ᐊᓐ ᒑ ᐄᔑ ᑐᑎᒫᑭᐎᔨᓐ᙮” ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᒀᒡ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐅᒋᒫᐤ, ᐋᑯᑖᐦ ᓂᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑎᐱᐦᐄᑭᓂᔨᐤ ᑳ ᒦᓂᐙᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐲᑎᕐᐦ ᐐᒋᔨᐦᒡ, ᐋᒄ ᑳ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐ ᐅᓯᑯᓯᔨᐤᐦ ᐋᐦ ᐋᐦᑯᓰᔨᒡ ᐋ ᒋᔑᑖᐅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ᐋᒄ ᒌᓴᔅ ᑳ ᑖᐦᒋᓂᒸᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐᐦ ᐅᓯᑯᓯᔨᐤ ᐅᑎᐦᒌᔨᐤ, ᑳ ᐄᔥᑖᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒋᔑᑖᐅᐱᔨᔨᒡ, ᐋᒄ ᑳᐦ ᐋᑎ ᐎᓂᔥᑳᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, ᑳᐦ ᐋᑎ ᒥᒥᔪᐦᑳᑯᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ, ᐋᒄ ᑳ ᐹᔑᐙᒡ ᐄᔨᔨᐅᒡ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐊᓂᑖᐦ ᒌᓴᔅ ᐋᐦ ᑖᔨᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑎᔓᒫᐤ ᓰᑎᐤ ᐊᔨᒨᐎᓂᔨᐤ ᐋᐦᐋᐱᒌᐦᑖᑦ ᒑ ᐐᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐊᓂᔮᔨᐤ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᐄᔨᔨᐤ, ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳᐦ ᑐᑎᐦᒃ ᒌᐦ ᐄᔅᐱᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᒧᑯᐱᓈ ᒑ ᐄᔅᐱᔨᒡ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳᐦ ᐃᔨᑦ, ᒋᒌ ᒦᓂᐙᒋᐦᐄᑯᓂᐤ ᑭᔮᐦ ᒌᐦ ᐄᒑᓂᒻ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᒋᑎᐄᑖᔅᐱᓈᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᐙᔅᑳ ᐋᐦ ᑖᑦ ᑳᐦ ᑖᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᓈᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ ᒑ ᒌᐦ ᐄᑎᐎᐦᔨᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ᐋᒸᔮ ᒫᒃ ᐅᐦᒋ ᒧᔖᐅᐦᐊᐦᒡ ᐹᔨᒄ ᐊᓐ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐐᔓᐙᐎᓂᔨᐤ ᒌᐦ ᐄᑖᐤ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᑭ ᐱᐹᐐᒑᐅᑎᓐ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᐅᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᐦᒑᔔᒡ ᑎᑯᓂᔨᐤ ᐅᐙᑎᑯᐙᐤ, ᐱᔮᔒᔑᒡ ᑭᔮᐦ ᑎᑯᓂᔨᐤ ᐅᒋᔥᑐᓂᐙᐤ, ᒥᒄ ᒫᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐙᐃᔑᒃ ᒑ ᒌᐦ ᐋᔨᐙᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ᐋᒄ ᒫᒃ ᑯᑎᒃ ᓈᐹᐤ ᐋ ᓅᔔᔥᑯᐙᑦ ᒌᓴᔅᐦ ᒌᐦ ᐄᑖᐤ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐱᒋᔅᑎᓐ ᐱᑎᒫ ᒑ ᒌ ᓂᐦᐄᐦᑯᒃ ᓅᐦᑖᐐ ᐴᓂᐱᒫᑎᓰᒑ ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᐐᒑᐅᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐐᒑᐅᐦ᙮ ᐋᑯᔥ ᐊᓂᒌ ᒧᔮᒻ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᑭᑎ ᓂᐦᐄᐦᑯᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔨᔨᒧᐙᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ᐋᒄ ᒌᓴᔅ ᑳ ᐴᓯᑦ ᒌᒫᓂᓯᔨᐤ, ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋ ᒌᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ᒑᒃ ᔑᔥᒋᑯᒡ ᑳ ᒥᔅᑎᒌᔥᑎᓃᔨᒡ ᐊᓂᑎᐦ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᒌᐦ ᑯᔥᐱᓈᑖᔨᑖᑯᓂᔨᐤ ᒫᒃ ᒑ ᒌᐦ ᑯᔖᐹᔮᐦᐊᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒌᒫᓂᐙᐤ᙮ ᒌ ᓂᐹᐤ ᒫᒃ ᐐᔨ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ᒑᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐹᑯᓈᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐹᒋ ᐱᒫᒋᐦᐄᓈᓐ, ᔖᔥ ᒋᑭ ᓂᔑᐎᓈᑎᓯᓈᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᑯᔥᑖᒋᔮᒄ, ᑖᑆᐦ ᓄᐎᒡ ᐊᐱᔖᔑᐤ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ᙮” ᐋᒄ ᑳ ᐎᓂᔥᑳᑦ ᑳᐦ ᐄᑎᔓᐙᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᔫᑎᓃᔨᒡ ᒑ ᒌᐦ ᐴᓂᐱᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑭᔥᑭᓐ ᑳᐦ ᐄᑖᑦ, “ᒋᔮᒫᐎᓰᒄ᙮” ᐋᒄ ᓈᔥᑎᔨᔥ ᑳ ᐃᔻᔥᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ᒥᓯᐙ ᐊᓂᒌ ᓈᐹᐅᒡ ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒧᒡ ᐋᐦ ᐃᔨᒡ, “ᐊᐙᓐ ᐆ ᐙᐙᒡ ᐋ ᔫᑎᓃᔨᒡ ᑭᔮᐦ ᒫᒃ ᑭᔥᑭᓐ ᐋ ᐱᔑᒋᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᒫᓯᑳᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑳᑖᕌ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᒌ ᓂᒋᔥᑳᑰ ᓃᔓ ᓈᐹᐤ ᐋ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐊᓂᑖᐦ ᒋᐹᔨᑭᒥᑯᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ᙮ ᓂᒧᐃ ᐙᐙᒡ ᐊᐙᔨᐤᐦ ᐅᐦᒌ ᐱᒧᐦᑖᔨᐤ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᑳ ᐃᔥᐱᔥ ᑯᔥᑖᑎᑯᓰᔨᒡ ᐅᒌ ᓈᐹᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒥᑯᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑏᐙᐦᒡ ᒌᐦ ᐅᐦᒋ ᐋᔑᐦᒀᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, “ᒌᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᑖᓐ ᐙᐦ ᐃᔒᐦᑭᐎᔮᐦᒡ, ᔖᔥ ᐋ ᒌ ᐐᐦ ᐹᒋ ᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᓈᓐ ᐋᔥᒄ ᒫᒃ ᐋᐦᐋᑳ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐊᓂᑎᐦ ᒑ ᐙᐐᓯᒑᔨᐦᑎᒧᐙᒋᐱᓈ?” ");
INSERT INTO crl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ᐊᓂᑎᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᒡ ᓂᒧᐃ ᐙᐦᔨᐤ ᐊᓂᑎᐦ ᒌᐦ ᑖᐅᒡ ᐋ ᒥᐦᒑᑎᒡ ᑰᐦᑰᔑᒡ ᐋ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ᐋᒄ ᐊᓂᒌ ᒥᒋᐊᐦᒑᐦᑯᒡ ᓈᔥᒡ ᓲᐦᒃ ᒌ ᓂᑐᑎᒧᐙᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᒑ ᐎᔨᐐᑎᔑᐦᐅᐙᔮᒑ, ᓈᑖᐦ ᐄᑎᔓᐦᐅᓈᓐ ᐊᓂᒌ ᑰᐦᑰᔑᒡ ᐋᐦ ᑖᒡ ᒑ ᒌ ᐲᐦᒋᔥᑯᐙᒋᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒫᒌᒄ᙮” ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᔨᐐᒡ ᐊᓂᒌ ᒥᒋᐊᐦᒑᐦᑯᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤᐦ ᓃᔓᐦ ᓈᐹᐤᐦ ᐋᐦ ᑖᔨᒡ ᐋᒄ ᑳᐦ ᐋᔓᐲᐦᒋᔥᑯᐙᒡ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ᙮ ᐋᒄ ᐊᓂᒌ ᑰᐦᑰᔑᒡ ᑳ ᐃᔮᒥᑖᐅᐦᒋᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐄᔑ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᑳ ᓂᔥᑖᐹᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᐋᒡ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ ᑳ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᒌᐦ ᐅᔑᒨᒡ, ᑳ ᓂᑑᐐᐦᑎᐦᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᓃᔓ ᓈᐹᐤ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ᓈᓈᒑᔒᔥ ᒫᒃ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᒌᓴᔅᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᒡ ᒌ ᔒᐦᒋᒫᐅᒡ ᒑ ᒌᐦ ᐄᒑᑖᔨᒡ ᐊᓂᑎᐦ ᐅᑎᔅᒌᐙᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ᐋᒄ ᒌᓴᔅ ᑳ ᐴᓯᑦ ᒌᒫᓂᓯᔨᐤ ᑳ ᑎᔅᑭᒥᐦᐊᒡ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᑳ ᐄᑖᔑᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐅᐦᒌᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ᒌ ᐹᔓᐙᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᓈᐹᐤᐦ ᐊᔥᐱᔑᒧᓂᓯᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᓂᓯᑐᓰᔨᒡ᙮ ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᐙᐱᐦᑎᒸᑦ ᐊᓂᔮᔨᐤᐦ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤᐦ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, “ᐊᑳᐐ ᐋᔨᒫᔨᐦᑦᐦ ᓂᐐᒑᐙᑭᓐ, ᒋᐙᐹᔨᐦᑎᒫᑰᓐ ᒋᒥᒋᐦᑣᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ᐋᒄ ᐊᓂᒌ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌᐦ ᐃᔨᐅᒡ ᐋᐦ ᐄᑐᒡ, ᒌᓴᔅ ᐋᐦ ᐊᔨᒧᒫᒡ, “ᒫᔮᔨᒫᐤ ᒋᔖᒥᓂᑑᐦ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑎᒦᒡ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᓂᑎᐐ ᒥᒄ ᒋᑎ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑖᓈᐙᐤ ᒋᑖᐦᐄᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ᑖᓐ ᐊᐅᔅᑖ ᐎᔮᐦᑎᐦᒡ ᒑ ᒌᐦ ᐄᓈᓅᒡ, ‘ᒋᒥᒋᐦᑣᐎᓐᐦ ᒋᐙᐹᔨᐦᑎᒫᑰᓐ’ ᑭᔮᐦ ᒫᒃ ᒑ ᒌᐦ ᐄᓈᓅᒡ, ‘ᐱᓯᑰᐦ, ᐱᒧᐦᑖᐦ ᒫᒃ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ᒋᑭ ᐙᐱᐦᑏᑎᓈᐙᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑖᑆᐦ ᐐᔨ ᐋ ᐃᔮᑦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᒑᑦ ᒥᒋᑣᐎᓐ᙮” ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᑳ ᑳ ᐅᐦᒋ ᓂᓯᑐᓰᔨᒡ, “ᐱᓯᑰᐦ, ᐅᑎᓐ ᒋᑎᔥᐱᔑᒧᓐᔅ, ᒑ ᒌᐙᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ᒌ ᐱᓯᑰ ᒫᒃ ᐊᓐ ᓈᐹᐤ, ᑳ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐋ ᒫᒨ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᐎᔮᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᒌ ᓵᒋᓯᐎᒡ ᐋᒄ ᑳ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑ ᐋ ᒥᔮᔨᒡ ᓈᐹᐤᐦ ᓈᔥᒡ ᒥᔅᑎᐦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ, ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᑦ, ᒌ ᐙᐱᒫᐤ ᓈᐹᐤ ᐋ ᐊᐱᔨᒡ ᒥᓯᓂᐦᐄᒑᐅᑭᒥᑯᐦᒡ ᒫᕠᔫ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᒫᒨᓯᐦᒋᓈᔨᒡ ᐋ ᒌᐦ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐱᐹᐐᒑᐤᐦ᙮” ᐋᒄ ᒫᕠᔫᐦ ᑳ ᐱᓯᑯᑦ, ᑳᐦ ᐋᑎ ᐐᒑᐙᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋ ᒦᒋᓱᑦ ᐊᓂᑖᐦ ᒫᕠᔫᐦ ᐐᒋᔨᐦᒡ ᒥᐦᒑᑐ ᑯᑎᑭᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐅᔔᔮᓂᒥᔨᐤ ᑳ ᒫᒨᔥᒋᓂᐦᒡ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡᐦ ᑳ ᒥᒑᑎᓯᒡᐦ ᐋ ᐐᒋᒦᒋᓲᒫᒡ ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ᐱᔅᒡ ᒫᒃ ᐹᕆᓰᒡ ᒌ ᐙᐱᒫᐅᒡ ᐅᔮᔨᐤ ᐋᒄ ᐋ ᑖᒡ ᐊᓂᔮᔨᐤᐦ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐐᒋᒦᒋᓲᒫᑦ ᒌ ᒋᔅᑯᑎᒫᒑᓰᒧᐙᐤ ᐊᓂᔮᔨᐤᐦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐᐦ ᑳ ᒫᒨᓯᒋᓈᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃ ᑳ ᒥᒑᑎᓰᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ᒌᓴᔅ ᒫᒃ ᒌ ᐹᐦᑎᐙᐤ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᑎᐙᔨᒫᐅᒡ ᓂᑐᐦᑯᔨᓐ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳᐦ ᐋᐦᑯᓰᔨᒡ, ᒥᒄ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᐋᐅᑯᓂᒡ ᓈᑐᐙᔨᒫᒡ ᓂᑐᐦᑯᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ ᒫᐦ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᒡ, ‘ᒋᔅᑎᒫᒑᐦᔨᒋᒑᐎᓐ ᒑ ᒌᐦ ᐃᔮᔮᒄ ᐋᐅᒄ ᓈᑐᐙᔨᐦᑎᒫᓐ, ᓂᒧᐃ ᐐᐦ ᐋ ᒥᒋᔥᑎᐦᐋᒫᓂᐐᒡ ᒑᒀᓐ᙮’ ᓂᒌᑎᑯᔑᓐ ᒑ ᒌ ᓂᑐᒥᒀᐤ ᐅᒥᒋᐦᑣᐅᒡ ᒑ ᒌᐦ ᒀᔅᑳᑎᓰᔨᒡ᙮ ᓂᒥᔮᐅᒡ ᐊᓂᒌ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ᐋᒄ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᐋᐅᒄ ᐋᐦ ᑎᔮᐦᒡ ᓃᔮᓐ ᒫᓐ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᐋᐦᐋᑳ ᒦᒋᓱᔮᐦᒡ᙮ ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᑭᔮᐦ ᐐᔨᐙᐤᐦ ᐄᐦᑐᑖᐦᒡ ᒋᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡᐦ ᐋᐦᐋᑳ ᒦᒋᓱᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒸᐦᒡ ᐊᓂᑖᐦ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐐᒡ, ᓂᒧᐃ ᒥᒑᔨᐦᑎᒧᒡ ᐊᓂᒌ ᑳ ᓂᑐᒫᑭᓂᐎᒡ ᒫᒀᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᔅᒋᓈᐹᐙᓐ᙮ ᐋᐅᒄ ᒫᒃ ᐋ ᐃᓯᓈᑯᐦᒡ ᐅᑎᐦ ᒫᒀᒡ ᐋᐦ ᑖᔮᓐ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐋᐦ ᑖᒡ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐹᒋ ᐅᑎᓂᑯᔮᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ ᐅᐦᒋ ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑᐦ ᑎᒡ ᐋᐦᐋᑳ ᒦᒋᓱᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ᒧᔮᒻ ᐊᐙᓐ ᐋ ᐐᐦ ᒦᔑᐦᐋᐦᒃ ᐙᔅᑭᒡ ᐊᑯᐦᐱᔨᐤ ᐋ ᐅᔥᑳᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᐋᐱᒋᐦᑖᒑ, ᐊᓂᔮᔨᐤ ᐋ ᐅᔥᑳᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᐋᐱᒋᐦᑖᒑ ᑭᑎ ᐅᑖᐹᐙᔨᐤ ᐋᒄ ᒫᒃ ᐊᑎᑎᐤ ᒑ ᐲᑯᐱᔨᐦᒡ ᐊᓐ ᐊᑯᐦᑉ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ᐋ ᐅᔥᑳᑭᒦᐦᒡ ᔔᒥᓈᐳᐃ ᐊᓂᑖᐦ ᐄᔑ ᐲᐦᑖᐹᐐᑖᑭᓂᐤ ᐋ ᐅᔥᑳᒡᐦ ᐲᔖᑭᓐ ᐐᐦᑯᔮᐤ ᐋᒄ ᒫᒃ ᒑ ᒌᐦ ᑭᓄᐙᔨᐦᑖᑭᓂᐐᒡ, ᑭᔮᐦ ᓂᒧᐃ ᐊᐙᓐ ᐲᐦᒋᑯᑖᐤ ᐋ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ ᐊᓂᑖᐦ ᐙᔅᑭᒡ ᐲᔖᑭᓐ ᐐᐦᒀᔮᐦᒡ᙮ ᐙᔥ ᐊᓂᑖᐦ ᐄᔑ ᐲᐦᒋᑰᑖᒑ ᐊᓂᔮᔨᐤ ᑳ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ, ᐄᔥᐱᐦ ᒫᒃ ᐅᔑᐦᐆᒥᑭᓃᔨᒑ ᒥᑐᓐ ᒋᑭ ᑖᑐᐲᔨᐤ ᐊᓂᔮᔨᐤ ᐲᔖᑭᓐ ᐐᐦᒀᔮᔨᐤ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐃᔮᐤ ᔔᒥᓈᐴᔨᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐲᔖᑭᓐ ᐐᐦᒀᔮᔨᐤ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐃᓯᓈᑯᓂᔨᐤ ᒦᓐ ᒑ ᒌᐦ ᐋᐱᒋᐦᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋᐦ ᐃᔨᑦ ᐅᔮᔨᐤ, ᐹᔨᒄ ᒎᐄᔨᔨᐤ ᐋ ᐅᒋᒫᐅᑦ ᒌ ᐹᒋ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐆ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋᐦ ᐄᑖᑦ, “ᒌᐦ ᐴᓂᐱᒫᑎᓰᐤ ᓂᑖᓂᔅ ᐊᓅᐦᒡ, ᐹᒋ ᑖᐦᒋᓐ ᐋᒄ ᒫᒃ ᒦᓐ ᒑ ᐱᒫᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ᐋᒄ ᒌᓴᔅ ᑳ ᐱᓯᑯᑦ, ᑳ ᐐᒑᐙᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐐᒑᐅᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ᔑᔥᒋᑯᒡ ᒫᒃ ᐃᔅᒀᐤ ᑳ ᐅᐦᒋ ᐹᒋ ᓈᑖᑦ ᒌᓴᔅᐦ, ᓃᔓᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᐋ ᒌᐦ ᐎᓂᐦᑖᑦ ᐅᒥᐦᒄ, ᐋᐅᒄ ᐊᓐ ᐅᔅᐱᔅᑯᓃᔨᒡ ᑳ ᐅᐦᒋ ᐹᒋ ᓈᑖᑦ ᒌᓴᔅᐦ ᑳ ᑖᐦᒋᓂᒸᑦ ᐊᓂᑖᐦ ᐋ ᐎᓂᔥᒀᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᑯᐦᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ᐋ ᒌ ᑖᑆᐦᑎᐦᒃ ᑭᔨᑆ ᒑ ᒦᓂᐙᑎᓰᑦ ᐋᑦ ᒥᒄ ᑖᐦᒋᓂᒸᒑ ᐋ ᐎᓂᔥᒀᑭᓃᔨᒡ ᒌᓴᔅᐦ ᐅᑎᑯᐦᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ᐋᒄ ᒌᓴᔅ ᑳ ᒀᔅᒋᑳᐳᐎᑦ, ᑳ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᐋᔨᒫᔨᐦᑦ ᓂᑖᓂᔅ, ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒋᒦᓂᐙᒋᐦᐄᑯᓐ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒦᓂᐙᑎᓰᐤ ᐊᓐ ᐃᔅᒀᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᐲᐦᒑᐙᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᐅᒋᒫᐎᔨᒡ ᐐᒋᔨᐤ, ᒌ ᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᒌᐦ ᐴᑖᑎᒥᔨᒡ ᒋᔅᑐᐦᒋᑭᓂᔅ ᐋ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᐊᐙᔨᐤᐦ ᐋ ᒌᐦ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓂᓈᐦᑳᑣᐅᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ᒌᐦ ᐄᑖᐤ, “ᓂᒧᐃ ᒋᓂᑎᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᐅᑎᐦ, ᐎᔨᐐᒄ ᓈᑖᐦ, ᑖᐹ ᐴᓂᐱᒫᑎᓰᐤ ᐊᓐ ᐃᔅᒀᔥ ᒥᒄ ᐙᔥ ᐊᓐ ᓂᐹᐤ᙮” ᐋᒄ ᑳ ᐅᔑᓄᐙᒡ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᐋ ᒫᔮᔨᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᐎᔨᐐᑎᔑᐦᐅᒫᑭᓂᐎᔨᒡ, ᐋᒄ ᒌᓴᔅ ᑳ ᐲᐦᒑᐙᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᔥᐦ ᐅᓂᐹᐅᑭᒥᑯᔨᐤ, ᑳ ᐅᑎᓂᒸᑦ ᐅᑎᐦᒌᔨᐤ ᐋᒄ ᑳ ᐎᓂᔥᑳᑦ ᐊᓐ ᐃᔅᒀᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ᐊᓐ ᒫᒃ ᑳ ᐄᔅᐱᔨᒡ ᒌ ᒥᔑᐦᑖᐱᔨᐤ ᐊᓐ ᑎᐹᒋᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᒑᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐐᒋᔨᐦᒡ ᓃᔓᐦ ᓈᐹᐤᐦ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ ᒌ ᓅᔔᔥᑳᑰ ᐋᐦ ᐋᔑᐦᒀᔨᒡ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᑎᑯᑦ, “ᒌᔨ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒥᓈᓐ ᒫᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ᒌᓴᔅ ᒫᒃ ᒌ ᐲᐦᒑᐤ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐋᒄ ᐊᓂᒌ ᓈᐹᐅᒡ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ ᑳ ᓂᑎᐙᐱᒫᒡ, ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᑖᑆᐦᑖᓈᐙᐤ ᐋ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᑎᑯᒡ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐋᐦᐋ, ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ᐋᒄ ᒌᓴᔅ ᑳ ᑖᐦᒋᓂᒸᑦ ᐊᓂᔮᔨᐤ ᐅᔅᒌᔑᑯᔨᐤ, ᑳᐦ ᐄᑖᑦ, “ᓂᐦᐋᐤ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᒫᒄ ᐋᐅᒄ ᐊᓐ ᒑ ᐄᔑ ᑐᑎᒫᑯᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ ᒫᒃ ᐋᒄ ᑳ ᐙᐱᐦᑎᐦᒡ᙮ ᐋᒄ ᒌᓴᔅ ᐋᔨᐦᑭᒻ ᑳᐦ ᐄᑎᔓᒫᑦ ᐋᑳ ᒑ ᒌ ᐐᐦᑎᒧᐙᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐱᔑᒋᐦᐋᐅᒡ, ᐊᔮᐱᒡ ᒌᐦ ᑭᑎᐹᒋᒫᐅᒡ ᒌᓴᔅᐦ ᒥᓯᐙ ᐊᓂᑖᐦ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᓈᐹᐅᒡ, ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒌ ᐹᔓᐙᐅᒡ ᓈᐹᐤᐦ ᐊᓂᑎᐦ ᒌᓴᔅ ᐋᐦ ᑖᔨᒡ ᐋᐦᐋᑳ ᓂᐦᑖᐙᔨᒡ ᐋ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐎᔨᐐᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤᐦ ᒥᒋᐊᐦᒑᐦᒄᐦ, ᐋᒄ ᑳ ᑭᔅᒋᐦᐅᑦ ᐊᓐ ᓈᐹᐤ ᐋ ᐊᔨᒥᑦ᙮ ᒥᓯᐙ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ᙮ ᒌᐦ ᐃᔨᐅᒡ ᒫᒃ, “ᓂᒧᐃ ᓂᐦᑖ ᓅᐦᒋ ᐙᐱᐦᑖᓈᓐ ᒫᒥᔥᑳᒡ ᒑᒀᓐ ᐅᐦᐄ ᐋᐦ ᐄᔅᐱᔨᒡ ᐅᑎᐦ ᐃᔅᕋᐃᓕᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌᐦ ᐄᑖᐅᒡ, “ᐊᓂᔮᔨᐤ ᐙᔥ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳ ᒥᔨᑯᑦ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐙᑦ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ᒌᓴᔅ ᒫᒃ ᒥᓯᐙ ᒌᐦ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᐋ ᐐᒋᓈᓂᐎᔨᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᔑᐦᒡ, ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᐋ ᑭᒑᔅᒀᑦ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐋᔨᒨᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ, ᑭᔮᐦ ᐋ ᒦᓂᐙᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᓂᓈᐦᑭᐤ ᐄᑖᔅᐱᓈᐎᓂᔨᐤ ᐋ ᐃᔮᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᒥᐦᒑᑐᐦ ᐊᐙᔨᐤᐦ, ᓈᔥᒡ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᑭᔨᑆ ᓈᔥᒡ ᐋ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᐃᔮᔨᒡ ᐊᔅᐹᔨᒧᐎᓂᔨᐤ, ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐋ ᐃᓯᓈᑯᓯᒡ ᐋᐦᐋᑳ ᐃᔮᐙᒡ ᒫᓂᔥᒑᓂᔑᐐᔨᔨᐤ ᒑ ᓈᓈᑭᒋᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐙᔫᑎᓐ ᐋ ᒌᔥ ᓂᐦᑖᐅᒋᐦᒡ ᓂᐦᑖᐅᒋᐦᑖᑭᓐ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᐦᒑᑑᒡ ᐊᓂᒌ ᒑ ᒫᒨᔥᒋᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ᐊᔨᒥᐦᐋᒄ, ᓂᑐᑎᒧᐙᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓐ ᑎᐱᔨᐙᐅᓯᑦ ᐅᔮᔨᐤ ᑳ ᒌᔥ ᓂᐦᑖᐅᒋᓃᔨᒡ ᓂᐦᑖᐅᒋᐦᑖᑭᓐ ᒑ ᒌᐦ ᐄᑎᔑᐦᐙᑦ ᒥᐦᒑᑐ ᐋᐱᑎᓯᓲᐤᐦ ᐊᓂᑖᐦ ᐋ ᒫᐅᒋᐦᑖᑭᓂᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ᒌᓴᔅ ᒌ ᓂᑑᒫᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳ ᒥᔮᑦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤᐦ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐙᔨᒡ ᒥᒋᐊᐦᒑᐦᒄᐦ, ᐋᔨᐤᐦ ᒫᒃ ᒑ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᓂᔮ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᓂᓈᐦᑭᐤ ᑳ ᐄᑖᔅᐱᓈᔨᒡ ᑭᔮᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ᒫᐤ ᒫᒃ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓃᔓᔖᑉ ᐋᑆᔅᑎᓪᐦ, ᓃᔥᑎᒻ ᐊᓐ ᓵᐃᒥᓐ, ᐋᐅᒄ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᑭᔮᐦ ᐲᑎᕐ ᐅᔒᒻ ᐋᓐᑎᕉᐦ, ᒉᒥᔅ ᑭᔮᐦ ᐊᓂᔮ ᐐᒋᔖᓐ ᒞᓐ, ᐋᔪᐎᑯᓐᐦ ᐅᔮᔨᐤ ᓭᐱᑏ ᐅᑯᓯᔅᐦ, ");
INSERT INTO crl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ᕕᓕᑉ ᑭᔮᐦ ᐹᕐᑣᓚᒥᔫ, ᑣᒥᔅ ᑭᔮᐦ ᒫᕠᔫ, ᐊᓐ ᑳ ᒌ ᒥᒧᔑᒋᓈᑦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ, ᑭᔮᐦ ᒉᒥᔅ, ᐊᓪᕕᔮᔅ ᐅᑯᓯᔅᐦ, ᑭᔮᐦ ᑖᑌᔨᔅ, ");
INSERT INTO crl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ᑭᔮᐦ ᓵᐃᒥᓐ ᓈᔥᒡ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᑭᔮᐦ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ, ᐋᐅᒄ ᐆ ᑳ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ᐋᒄ ᐅᒌ ᓃᔓᔖᑉ ᑳ ᒋᐦᒋᑎᔑᐦᐅᑯᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑎᑯᒡ, “ᐊᑳᐐ ᐄᑐᐦᑖᒄ ᐊᓂᑖᐦ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐋᐦ ᑖᒡ ᑭᔮᐦ ᐊᑳᐐ ᐄᑐᐦᑖᒄ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓐ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ᒥᒄ ᒫᒃ ᐊᓂᑖᐦ ᐄᑐᐦᑖᒄ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ ᐊᓂᑖᐦ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᐙᔥ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐋ ᐎᓂᔑᐦᒡ ᐃᓯᓈᑯᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ᒫᒌᒄᐦ ᓂᑑᑭᒑᔅᒀᒄ ᐋ ᐐᐦᑎᒫᒄ ᔖᔥ ᐋ ᐹᔓᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ᒦᓂᐙᒋᐦᐋᐦᑯᒡ ᑳᐦ ᐋᐦᑯᓯᒡ, ᑭᔮᐦ ᐎᓂᔥᑳᓈᐦᑯᒡ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᒦᓂᐙᒋᐦᐋᐦᑯᒡ ᒑ ᒌ ᐱᔮᐦᒋᓰᔨᒡ ᐊᓂᒌ ᑳ ᒫᔮᑎᓃᔨᒡ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ ᑳ ᐃᔮᒡ ᑭᔮᐦ ᐎᔨᐐᑎᔑᐦᐙᐦᑯᒡ ᒥᒋᐊᐦᒑᐦᑯᒡ᙮ ᓵᐦᒑᐄ ᒋᒌ ᒥᔨᑯᓈᐙᐤ ᐆ ᓲᐦᑳᑎᓰᐎᓐ, ᓂᒧᐃ ᒫᒃ ᒋᐱᐦ ᐅᐦᒋ ᑎᐱᐦᐋᒫᑯᓈᐙᐤ ᐆ ᐋᐦ ᑐᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ᐊᑳᐐ ᑭᔮᐦ ᐙᐙᒡ ᓃᒥᔔᔮᓈᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ᐊᑳᐐ ᑎᐦᑯᓂᒧᒄ ᑭᔮᐦ ᓃᒧᐎᑖᓐ, ᑭᔮᐦ ᐋᔨᐙᒡ ᒋᒑᒀᓂᒧᐙᐤ ᐋ ᒋᒋᔥᑭᒫᒄ, ᑭᔮᐦ ᒫᒃ ᒥᔅᒋᓐ ᑭᔮᐦ ᒫᒃ ᓯᔅᑭᐦᐅᓐ᙮ ᐙᔥ ᐋᐦ ᐋᐱᑎᓰᑦ ᐊᐙᓐ ᒋᐱᐦ ᒥᔮᑭᓂᐤ ᑖᓐ ᐋ ᐄᔑ ᓅᐦᑖᐱᔨᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᐦᑎᒫᒀ ᒋᔖᐃᐦᑖᐎᓐ ᑭᔮᐦ ᒫᒃ ᐃᐦᑖᐎᓐ, ᓈᓂᑐᐙᐱᒫᐦᒄ ᐊᐙᓐ ᐋ ᑖᐱᒑᔨᐦᑖᑯᓯᑦ ᒑ ᒌ ᐲᐦᑎᑭᐦᐄᑖᒄ᙮ ᐊᓐ ᒫᒃ ᒑ ᐃᔥᐱᔥ ᑖᔮᒄ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑖᒄ ᐹᑎᔥ ᒦᓐ ᒋᔅᑐᐦᑖᔮᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐲᐦᒑᔮᒄ ᐊᓐ ᐙᔅᑳᐦᐄᑭᓐ ᒑ ᐙᒋᔮᒫᑯᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᐦᒡ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᐊᓂᑎᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐊᑖᔨᐦᑖᑯᔑᐙᒀ, ᒑ ᓂᑐᑎᒧᐙᒄ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᒥᔮᑦ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐋᑳ ᑳᐦ ᐊᑖᔨᐦᑖᑯᔑᐙᒀ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᑐᑎᒧᐙᐤ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᒥᔮᑦ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ᐋᒄ ᒫᒃ ᐅᑎᐦᑎᒫᒀ ᐃᐦᑖᐎᓐ ᑭᔮᐦ ᒫᒃ ᐙᔅᑳᐦᐄᑭᓐ, ᐋᑳ ᒫᒃ ᐐᐦ ᐲᐦᑎᑭᐦᐄᑯᔮᒀ ᑭᔮᐦ ᐋᑳ ᐐ ᓂᑑᐦᑖᑯᔮᒀ, ᓂᑭᑎᒧᒄ ᐊᓐ ᐃᐦᑖᐎᓐ ᑭᔮᐦ ᒫᒃ ᐊᓐ ᐙᔅᑳᐦᐄᑭᓐ ᐋᒄ ᒑ ᐱᐦᐱᐅᓯᑖᔑᒧᔮᒄ, ᐋ ᓅᑯᐦᑖᔮᒄ ᐋ ᐃᔮᒀᒥᒫᑯᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᑎᓂᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐄᔥᐱᐦ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒑ ᒋᔖᒥᓂᑑ ᐊᐅᔅᑖ ᒋᑭ ᒋᔅᑎᒫᒑᔨᒫᐤ ᐊᓂᔮ ᑳ ᒥᒑᑎᓰᔨᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᔂᑐᒻ ᑭᔮᐦ ᒀᒧᕌ ᐃᔥᐱᔥ ᐐ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐋᑳ ᑳ ᓂᐦᐋᔨᒥᑏᔨᑖᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“ᓂᑎᐦᑎᒧᒄ, ᒋᐦᒋᑏᔑᐦᐅᑎᓈᐙᐤ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐋᐦ ᐄᑎᔑᐦᐙᑭᓂᐎᔨᒡ ᒥᐦᐄᐦᑭᓐ ᐋᐦ ᑖᔨᒡ᙮ ᔮᒀᐦ ᑎᒄ ᒧᔮᒻ ᐊᒋᓈᐱᒄ ᐋ ᐄᔑ ᔮᒀᐦ ᑎᒃᐦ, ᑭᔮᐦ ᒫᒃ ᔫᔅᐱᓰᒄ ᒧᔮᒻ ᐅᒦᒦᐤ ᐋ ᐃᔥᐱᔥ ᔫᔅᐱᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ᐃᔮᒀᒦᒄ ᒫᒃ, ᐙᔥ ᒋᑭ ᑖᐅᒡ ᐄᔨᔨᐅᒡ ᒑ ᐅᑎᓂᑖᑯᒡ ᐋᒄ ᐊᓂᑖᐦ ᑳ ᓃᑳᓂᔥᑳᒑᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᐄᑐᐦᑎᐦᐄᑖᑯᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᐙᒄ᙮ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᐙᐦᒡ ᐋᑎ ᒑ ᐱᐱᓯᔅᑖᐦᐅᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ᒋᑭ ᐄᑐᐦᑎᐦᐄᑯᓈᐙᐤ ᑎᐹᔨᐦᒋᒑᓯᐎᒡ ᑭᔮᐦ ᒋᐦᒋᐅᒋᒫᐅᒡ ᐋᐦ ᑖᒡ ᒑ ᒌᐦ ᐅᐦᑎᔅᑯᑳᐳᔥᑎᐙᑯᒡ ᐊᓐ ᐅᐦᒋ ᐋ ᓅᔔᔥᑭᐎᔮᒄ᙮ ᒋᑭ ᓂᑎᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᑯᐃᔅᒄ ᒑ ᒌᐦ ᐄᔑ ᐋᔨᒨᒥᔮᒄ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᒡ ᑭᔮᐦ ᐅᐦᑎᔅᑰ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᓂᑭᐐᔮᒀ, ᐊᑳᐐ ᐋᔨᒫᔨᐦᑎᒧᒄ ᑖᓐ ᓂᐦᐋᐤ ᒑ ᐃᔨᔮᒄ, ᐙᔥ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐊᓐ ᒑ ᑐᑖᑯᔮᒄ ᒋᑭ ᒥᔨᑯᓈᐙᐤ ᑖᓐ ᒑ ᐄᔑ ᐊᔨᒥᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ᐙᔥ ᐊᓐ ᒑ ᐄᔑ ᐊᔨᒥᔮᒄ, ᓂᒥᔮᐤ ᒌᔨᐙᐤ ᐊᓐ ᒋᑎᔨᒧᐎᓂᐙᐤ ᒥᒄ ᒫᒃ ᐊᓐ ᒑ ᐃᔨᔮᒄ ᐊᐦᒑᐦᒄᐦ ᑯᐦᑖᐎᐙᐤ ᐋᐦ ᑖᑦ ᑳ ᐅᐦᒌᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᒥᔨᑖᒄ ᑖᓐ ᓂᐦᐋᐤ ᒑ ᐃᔨᐙᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“ᓈᐹᐅᒡ ᒋᑭ ᐱᒋᔅᑎᓈᐅᒡ ᐐᒋᔖᓂᐙᐤ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᑭᔮᐦ ᐅᐦᑖᐐᒫᐅᒡ ᐋᔪᐎᒄ ᒑ ᑐᑎᐙᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ, ᑭᔮᐦ ᐊᐙᔑᔑᒡ ᒋᑭᑐᑎᐙᐅᒡ ᐅᓃᒋᐦᐄᑯᐙᐤ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒋᑭ ᐅᐦᑳᑎᑯᐙᐅᒡ ᐋ ᓅᔔᔥᑯᔮᒄ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᒑ ᓅᐦᑎ ᐴᓃᔨᒀ ᐋ ᐹᒋ ᓅᔔᔥᑯᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᐱᒫᒋᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ᓂᓈᐦᑳᒋᐦᐄᑯᔮᒀ ᐹᔨᒄ ᐃᐦᑖᐎᓐ, ᐅᔑᒧᒄ ᐋᒄ ᐊᓂᑖᐦ ᑯᑎᒡ ᐃᐦᑖᐎᓐ ᒑ ᐄᑐᐦᑖᔮᒄ᙮ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᐋᔥᒄ ᒥᓯᐙ ᒋᑭ ᐅᐦᒋ ᐄᔑ ᐙᐐᐦᑖᓈᐙᐤ ᒥᔻᒋᒧᐎᓐ ᐊᓂᑖᐦ ᐊᓂᐦᐄ ᐃᐦᑖᐎᓐ ᐃᔅᕋᐃᓕᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᔖᔥ ᒑ ᑎᑯᔑᐦᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ᓂᒧᐃ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᑳ ᒋᔅᑯᑎᒧᐙᑭᓅᑦ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᑯᑦ᙮ ᑭᔮᐦ ᐋᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᐐᔨ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐅᒋᒫᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ᒋᐱᐦ ᒥᔻᔨᐦᑎᒻ ᒫᒃ ᐊᓐ ᑳ ᒋᔅᑯᑎᒧᐙᑭᓅᑦ, ᐄᑖᔨᐦᑖᑯᓯᑦ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮ ᑳ ᒋᔅᑯᑎᒫᑯᑦ, ᑭᔮᐦ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐅᒋᒫᒻ᙮ ᓃᔨ ᒫᒃ ᐋᑎ ᐋ ᐅᒋᒫᐎᔮᓐ ᐆ ᐋ ᐹᔨᑰᑖᐅᔑᔨᐦᒄ ᒋᔅᒍᒄ ᒫᐦ ᑖᓐ ᑳ ᐄᔑ ᒫᔮᔨᒥᒡ ᐋ ᒌᐦ ᐄᔑᒡ ᐋᐦ ᐋᐅᐎᒡ ᓃᔨ ᐯᓪᓯᐳᓚ, ᐊᓂᔮᔨᐤᐦ ᒥᒋᐊᐦᒑᐦᒄᐦ ᐙᒋᒫᑭᑎᐙᔨᒡ᙮ ᐊᑎᑎᐤ ᒫᒃ ᒋᑭ ᒫᔮᔨᒥᑯᐙᐅᒡ ᑭᔮᐦ ᐅᔮᔨᐤ ᒥᓯᐙ ᐋᐹᔨᑯᑖᐅᔑᐆᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ᒥᒄ ᒫᒃ ᐊᑳᐐ ᑯᔥᑖᐦᑯᒡ ᐄᔨᔨᐅᒡ᙮ ᐙᔥ ᐊᓐ ᒑᒀᓐ ᑳ ᑳᑖᑭᓅᐦᒡ ᒋᑭ ᓅᑯᐦᑖᑭᓂᐤ᙮ ᒥᓯᐙ ᒑᒀᓐ ᒌᒧᒡ ᑳᐦ ᑐᑖᑭᓂᐎᔨᒡ ᒋᑭ ᒋᔅᒑᔨᐦᑖᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ᐊᓐ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᐋ ᑎᐱᔅᑳᒡ ᐐᐦᑎᒥᐦᒄ ᒫᒀᒡ ᐋ ᒌᔑᑳᒡ᙮ ᑭᔮᐦ ᐊᓐ ᑖᓐ ᑳ ᐄᔑ ᒌᒧᒡ ᐐᐦᑎᒫᑯᔮᒄ ᐐᐦᑎᒧᐙᐦᑯᒡ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ᐊᑳᐐ ᑯᔥᑖᐦᑯᒡ ᐄᔨᔨᐅᒡ ᑳ ᓂᐱᐦᐋᒡ ᐊᐙᔨᐤᐦ᙮ ᒋᑭ ᒌ ᓂᐱᐦᐋᐅᒡ ᐊᐙᔨᐤᐦ ᑭᔮᐦ ᒋᑭ ᒌ ᓂᔑᐎᓈᒋᐦᑖᐅᒡ ᒥᔮᔨᐤ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᔑᐎᓈᒋᐦᐋᐅᒡ ᐊᐦᒑᐦᒄᐦ᙮ ᑯᔥᐱᓃᔥᑐᐙᐦᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒋᑭ ᒌ ᓂᔑᐎᓈᒋᐦᑖᐤ ᐐ ᒥᔮᔨᐤ ᑭᔮᐦ ᐊᐦᒑᐦᒄᐦ ᒥᒋᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ᒥᒄ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᐄᑎᒋᐦᑖᑯᓯᐎᒡ ᓃᔓ ᐱᔮᔒᔑᒡ᙮ ᐊᔮᐱᒡ ᓂᒧᐃ ᒫᒃ ᐙᒋᐹᔮᒄ ᑭᑎ ᐅᐦᒋ ᐱᐦᒋᔑᓂᒡ ᒧᔥᑎᔅᑭᒦᐦᒡ ᐄᔑ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᑰᐦᑖᐐᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ᑭᔮᐦ ᒌᔨᐙᐤ ᒫᒃ ᐙᐙᒡ ᒋᔅᑎᒀᓂᐲᐙᐙᐤ ᒥᓯᐙ ᒌᐦ ᐊᒋᐦᑖᑭᓂᐤ ᐋ ᑎᐦᑣᐹᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ᐊᑳᐐ ᒫᒃ ᑯᔥᑖᒋᒄ ᐙᔥ ᒌᔨᐙᐤ ᐊᐅᔅᑖ ᒋᑎᐄᑖᔨᒥᑯᐙᐤ ᒋᔖᒥᓂᑑ ᐃᔥᐱᔥ ᐐ ᒥᐦᒑᑐ ᐱᔮᔒᔥ ᐋᑖᔨᒫᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“ᐊᐙᓐ ᐐᐦᑎᒧᐙᒑ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋ ᑖᑆᔮᔨᒥᑦ, ᑭᔮᐦ ᓃᔨ ᓂᑭ ᐐᐦᑎᒫᒫᔨᐤ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐋ ᒋᔅᒑᔨᒥᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ᐋᒄ ᒫᒃ ᐊᐙᓐ ᐋᐦ ᐄᑖᑦ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᑖᑆᔮᔨᒥᑦ ᓂᑭ ᐄᑎᒫᔨᐤ ᑭᔮᐦ ᓃᔨ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ, ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᐋ ᒌ ᑎᑯᔑᓂᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐹᑖᔮᓐ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ᙮ ᓂᒧᐃ ᓅᐦᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᐹᑖᔮᓐ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ, ᓂᒌᑎᑯᔑᓐ ᐋᑳ ᒑ ᒌ ᓂᐦᐄᔅᑳᑐᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ᓂᒌᑎᑯᔑᓐ ᐋᑳ ᒑ ᒌ ᓂᐦᐋᔨᒫᑦ ᓈᐹᐤ ᐅᐦᑖᐐᐦ, ᑭᔮᐦ ᐅᑳᐐᒫᐤ ᐋᑳ ᒑ ᒌ ᓂᐦᐋᔨᒥᑯᑦ ᐅᑖᓂᔅᐦ, ᑭᔮᐦ ᐃᔅᒀᐤ ᐋᑳ ᒑ ᒌ ᓂᐦᐋᔨᒥᑯᑦ ᐅᓂᐦᐋᑭᓂᔅᒀᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ᐊᓂᔮᔨᐤ ᑎᐱᔨᐙ ᐊᐙᔨᐤᐦ ᑳ ᐐᒋᒥᑯᑦ ᐊᐙᓐ ᐋᔨᐅᑯᓐ ᐊᓂᔮ ᒫᐅᒡ ᒑ ᐅᐦᑳᑎᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ᐊᐙᓐ ᐊᐅᔅᑖ ᐅᐦᑖᐐᐦ ᑭᔮᐦ ᒫᒃ ᐅᑳᐐᐦ ᓵᒋᐦᐋᒑ ᐃᔥᐱᔥ ᐐ ᓃᔨ, ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓲ ᒑ ᒌ ᐹᒋ ᓅᔔᔥᑯᑦ᙮ ᑭᔮᐦ ᐊᐙᓐ ᐊᐅᔅᑖ ᓵᒋᐦᐋᒑ ᐅᑯᓯᔅᐦ ᑭᔮᐦ ᒫᒃ ᐅᑖᓂᔅᐦ ᐃᔥᐱᔥ ᐐ ᓃᔨ, ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓲ ᒑ ᒌ ᐹᒋ ᓅᔔᔥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᐐᐦ ᐱᒧᐦᑎᐦᐋᑦ ᐅᑖᔑᑖᔮᐦᑎᑯᒻ ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓲ ᒑ ᒌᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ᐊᓐ ᐊᐙᓐ ᑳ ᐐᐦ ᑭᓄᐙᔨᐦᑎᐦᒃ ᐅᐱᒫᑎᓰᐎᓐ ᑭᑎ ᐎᓂᐦᑖᐤ ᐋᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᑳ ᐎᓂᐦᑖᑦ ᐅᐱᒫᑎᓰᐎᓐ ᓃᔨ ᐅᐦᒋ ᑭᑎ ᒥᔅᑭᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ᐊᐙᓐ ᐋ ᐲᐦᑎᑭᐦᐄᑖᒄ ᓂᐲᐦᑎᑭᐦᐄᒄ ᑭᔮᐦ ᓃᔨ, ᐋ ᐲᐦᑎᑭᐦᐄᑦ ᒫᒃ ᐅᑎᓈᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐲᐦᑎᑭᐦᐋᑦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ, ᐊᓂᔮᔨᐤ ᒑ ᐄᔑ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᔨᒡ ᐅᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᐤ ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨ ᒧᔮᒻ ᒑ ᐄᔑ ᑎᐱᐦᐋᒧᐙᑭᓅᑦ᙮ ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᑳ ᐲᐦᑎᑭᐦᐋᑦ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᓈᐹᐤ, ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ, ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᔨᒡ ᐋᔪᐎᒄ ᒧᔮᒻ ᑭᔮᐦ ᐐᔨ ᒑ ᐄᔑ ᑎᐱᐦᐋᒧᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᑎ ᒥᒄ ᒥᓂᐦᐋᒑ ᐊᐙᓐ ᐋ ᑎᐦᒋᑭᒥᔨᒡ ᓂᐲᔨᐤ ᐋᐙᔨᐤᐦ ᒧᔮᒻ ᐅᔮᔨᐤ ᐹᔨᒄ ᐊᐱᔥᑎᐙᔥ ᐊᓂᔮ ᐅᐦᒋ ᐋ ᐹᒋ ᓅᔔᔥᑭᐎᔨᒡ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒑᔥᑎᓈᔥ ᒋᑭ ᒥᔅᑭᒻ ᐅᑎᐱᐦᐊᒫᑯᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒋᔅᑯᑎᒨᐙᑦ ᒌᓴᔅ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ, ᑳ ᓂᑑᒋᔅᑯᑎᒫᒑᑦ ᑭᔮᐦ ᑳ ᑭᒑᔅᒀᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐃᐦᑖᐎᓐ ᐊᓂᑎᐦ ᐹᔓᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ᒞᓐ ᑳ ᓰᑭᐦᐋᐦᑖᒑᑦ ᒫᒃ ᒌᐦ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᑳ ᒋᐳᐦᐙᑭᓅᑦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐹᐦᑎᐦᒃ ᐋ ᑎᐹᒋᒫᑭᓂᐎᔨᒡ ᑖᓐ ᐋ ᐄᔨᐦᑎᔨᒡ ᙭, ᐋᒄ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᒫᐦ, ᐋᐤ ᐋ ᒌᔨ ᙭ ᐊᓐ ᒑ ᑎᑯᔑᓂᑯᐱᓈ ᑭᔮᐦ ᒫᒃ ᐋᔥᒄ ᒑ ᓈᓂᑐᐙᐱᒥᐙᒋᒑ ᑯᑎᒃ ᒑ ᑎᑯᔑᐦᒃ?” ");
INSERT INTO crl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒌᐙᒄ, ᒑ ᐐᐦᑎᒧᐙᒄ ᒞᓐ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᒥᔮᒄ ᐋ ᐄᔑ ᑐᑎᒫᓐ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ᐐᐦᑎᒧᐙᐦᒄ ᒫᒃ ᐋ ᐙᐱᐦᑎᒥᔨᒡ ᐊᓂᔮ ᐋᐦᐋᑳ ᐅᐦᒌ ᐙᐱᐦᑎᒥᔨᒡ, ᐋ ᐱᒧᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐅᐦᒌ ᐱᒧᐦᑖᔨᔨᒡ, ᑭᔮᐦ ᒫᒃ ᐋ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᓂᔮ ᑳ ᐃᔮᔨᒡ ᑳ ᒫᔮᑎᓃᔨᒡ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ, ᐋ ᒌ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ᙮ ᑭᔮᐦ ᐋ ᐹᐦᑎᒥᔨᒡ ᐊᓂᔮ ᐋᐦᐋᑳ ᐅᐦᒌ ᐹᐦᑎᒥᔨᒡ᙮ ᑭᔮᐦ ᐋ ᒌᐦ ᐎᓂᔥᑳᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᑭᔮᐦ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋ ᐙᐐᐦᑎᒫᒫᑭᓂᐎᔨᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ᔑᐙᔨᐦᑖᑯᓲ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᒑ ᐲᔨᐦᑎᐙᔨᒥᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᔨᒡ ᒞᓐ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤ, ᒌᓴᔅ ᒌᐦ ᐋᔨᒨᒫᐤ ᒞᓐ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐋᐦ ᐄᑖᑦ, “ᐄᔥᐱᐦ ᑳ ᓂᑎᐙᐱᒫᒄ ᒞᓐ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳ ᑭᒑᔅᒀᑦ, ᐊᐙᓐ ᑳ ᐄᑖᔨᒫᒄ ᒑ ᐙᐱᒫᒄ᙮ ᒧᔮᒻ ᐋ ᐊᐙᓐ ᒸᐦᒡ ᒥᔥᑯᔒᐦᒡ ᑖᓐ ᐋᐦ ᐄᑖᔥᑎᐦᒡ ᒥᒄ ᐊᓂᑖᐦ ᐋ ᐄᔑ ᔪᐙᒡ ᐋ ᐄᔑ ᓂᐙᔮᔥᑎᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᓂᑎᐙᐱᒫᒄ? ᐊᐙᓐ ᑳ ᐄᑖᔨᒫᒄ ᒑ ᐙᐱᒫᒄ? ᓈᐹᐤ ᐋ ᓈᔥᒡ ᐋ ᒥᔻᔥᐱᓱᑦ? ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒥᔻᔥᐱᓱᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᐋᑯᑖᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᓂᑎᐙᐱᒫᒄ? ᒋᒌ ᐄᑖᔨᐦᑎᓈᐙᐤ ᐋ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒑ ᐙᐱᒫᒄ? ᐋᐦᐋ, ᒋᔅᒌᐙᐦᐄᒑᓯᐤ ᒞᓐ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐅᔅᑖ ᐐᔨ ᒞᓐ ᒌᐦ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐ ᑯᑎᒃ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ᐋᐅᒄ ᐆ ᒞᓐ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᒡ, ᓂᑭ ᓃᑳᓂᑎᔑᐦᐙᐤ ᐊᐙᓐ ᒑ ᒌᐦ ᐃᔮᔅᑭᐐᐦᑭᐦᒃ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑖᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑎᐦᑐ ᐄᔨᔨᐅᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᓂᒧᐃ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ᙮ ᐊᔮᐱᒡ ᒫᒃ ᑖᓐ ᐊᓐ ᒫᐅᒡ ᓅᐦᑖᔮᔥ ᑳ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᐊᐅᔅᑖ ᐐᔨ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ᑳ ᐃᔥᐱᔥ ᒋᐦᒋᐱᔨᐦᑖᑦ ᒫᒃ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ ᐋ ᑭᒑᔅᒀᑦ, ᐅᑖᐦ ᒫᒃ ᐄᔑ ᐋᔅᑎᒦᐦᒑ, ᐄᔨᔨᐅᒡ ᒨᔥ ᐐᐦ ᓯᓲᐦᒑᔨᒧᑖᒨᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ, ᑭᔮᐦ ᑳᐦ ᐋᐦᒀᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᓲᐦᒃ ᐋ ᒫᓯᐦᒑᒡ ᐐᔨᐙᐤ ᐋ ᐐᐦ ᐅᑎᓂᒫᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ᐙᔥ ᒥᓯᐙ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒌ ᐐᐦᑎᒧᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᒑ ᐅᑎᐦᒋᐱᔨᒡ, ᐋᐅᒄ ᒫᒃ ᑭᔮᐦ ᑳ ᐄᔑ ᐹᒋ ᐐᐦᑖᑯᐦᒡ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ ᐹᑎᔥ ᑳ ᑎᑯᔑᐦᒃ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ᐅᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒌᐦ ᐃᔨᐅᒡ ᐋᔥᒄ ᒑ ᑎᑯᔑᓃᔨᒡ ᐄᓛᐃᒑ, ᒋᑎᔮᑆᐦᑎᐙᐙ ᒫᒃ, ᐆ ᒞᓐ ᐋᐅᒄ ᐊᓐ ᐄᓛᐃᒑ᙮ ᐋᐅᒄ ᐆ ᐅᒋᔅᒋᐙᐦᐄᒑᐤ ᒑ ᑎᑯᔑᓂᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ᓂᑭ ᐋᔨᒨᒫᐅᒡ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᒫᒀᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ᒧᔮᒻ ᐊᐙᔑᔑᒡ ᐋᑳ ᑳ ᒌ ᓂᓂᐦᐄᐙᐦᐄᑐᒡ ᑖᓐ ᐋ ᐄᔑ ᒫᑎᐙᒡ ᐋᔪᐎᒄ ᐋᐦ ᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ᐋ ᑖᑆᑐᒡ, ᐋᐦ ᐃᔨᒡ, ‘ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᒡ ᒋᔅᑑᐦᒋᑭᓐ ᓂᒌᐦ ᐄᔑ ᒫᑎᐙᓈᓐ, ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᓃᒥᓈᐙᐤ, ᑭᔮᐦ ᓂᒌ ᓂᑭᒧᓈᓐ ᐋ ᒋᔅᑎᒫᒋᑖᑯᐦᒡ ᓂᑭᒧᐎᓐ ᐋ ᓃᐦᐄᑯᐙᑭᓅᑦ ᐊᐙᓐ, ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᒫᑑᓈᐙᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ᐄᔥᐱᐦ ᒫᒃ ᒞᓐ ᑳ ᑎᑯᔑᐦᒃ ᓂᒧᐃ ᐋᔑᑯᒻ ᐅᐦᒋ ᐅᑎᓂᒻ ᒦᒋᒥᔨᐤ, ᓂᒧᐃ ᑭᔮᐦ ᐅᐦᒋ ᒥᓂᐦᒀᐤ ᔔᒥᓈᐴᔨᐤ, ᐋᒄ ᒫᒃ ᑳ ᐄᑖᑭᓅᑦ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᐦᒋᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ᐋᒄ ᒫᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒌ ᒦᒋᓲ ᑭᔮᐦ ᒌ ᒥᓂᐦᒀᐤ, ᒌᐦ ᐄᑎᑰ ᒫᒃ ᐊᐙᔨᐤᐦ, ‘ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ ᐆ ᓈᐹᐤ, ᑖᑆᐦ ᐋᔅᐳᓂᓯᐤ ᑭᔮᐦ ᑖᑆᐦ ᐐᐦᒋᐹᐤ, ᐋ ᐅᐐᒑᐙᑭᓂᑦ ᐅᒥᒑᑎᓯᔨᐤ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᑎᐐ ᒥᒄ ᑳ ᐄᔨᐦᑎᔨᒡ ᑳ ᒫᒨᔑᒋᓈᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ᙮’ ᒥᒄ ᒫᒃ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᑦ ᐊᐙᓐ ᐋᑯᑖᐦ ᓅᑯᓃᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ᐊᓂᑖᐦ ᒫᒃ ᐊᓂᐦᐄ ᐃᐦᑖᐎᓐ ᐋᑎ ᒫᐆᒡ ᒥᐦᒑᑐ ᑳᐦ ᑐᑎᐦᒃ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ ᒌᓴᔅ, ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓐ ᐊᔮᐱᒡ ᓂᒧᐃ ᐅᐦᒋ ᒀᔅᑳᑎᓯᐎᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᓈᒋᒫᐤ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“ᒌᔨᐙᐤ ᑳᐦ ᑖᔮᒄ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒀᕌᓯᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ, ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕪᓵᐃᑖ ᑳᐦ ᑖᔮᒄ ᐋᐅᒄ ᐊᓐ ᒧᔮᒻ ᒑ ᐄᔑ ᐅᔥᑖᐲᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ᐙᔥ ᐊᓂᐦᐄ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ ᑳ ᐄᔑ ᑐᑎᒫᑯᔮᒄ ᒌᐦᑐᑖᑭᓂᐙᑯᐱᓈ ᐊᓂᑖᐦ ᐙᔥᑭᒡ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᔖᔥ ᐙᔥᑭᒡ ᒋᐱᐦ ᒌᐦ ᒀᔅᑳᑎᓯᐎᒡ ᐐᔨᐙᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᐋᒄ ᒫᒃ ᐋ ᐐᐦ ᓅᑯᐦᑖᒡ ᐋ ᐃᔥᐱᔥ ᒥᐦᒋᔨᐙᓯᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ ᒋᐱᐦ ᐐᔅᒀᔮᑭᐴᒡ ᐋ ᑳᐙᑭᓃᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ, ᐊᓂᑖᐦ ᒫᒃ ᐱᐦᑯᑖᒡ ᒋᐱᐦ ᐊᐱᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ, ᒋᔖᒥᓂᑑ ᒋᑭ ᒫᑯᐦᐋᐤ ᐊᓂᔮ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᒌᐦᑖᔨᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᐊᑎᑎᐤ ᒋᑭ ᒫᑯᐦᐄᑯᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᐊᓂᑎᐦ ᑳᐱᕐᓈᔪᒻ ᑳᐦ ᑖᔮᒄ ᓈᔥᑖᑆᐦ ᒋᑎᔅᐹᔨᒧᓈᐙᐤ ᒑ ᒌ ᒫᒥᐦᒋᒥᑳᐎᔮᒄ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒑ ᒌᐦ ᐄᔑ ᐅᑎᓂᑯᔮᒄ᙮ ᓂᒧᐃ ᒫᒃ, ᒥᒋᔥᑯᑖᐦᒡ ᒋᑭ ᐄᔑ ᓃᔑᐙᐱᓂᑯᓈᐙᐤ᙮ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ ᒌᐦᑐᑖᑭᓂᐤ ᐊᓂᑖᐦ ᒋᑎᐦᑖᐎᓂᐙᐦᒡ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᑯᐦᒋ ᒀᔅᑳᑎᓰᓈᐙᐤ, ᐋᒄ ᒫᒃ ᐊᓂᐦᐄ ᑳ ᐄᔑ ᑐᑎᒫᑯᔮᒄ, ᒌᐦᑐᑖᑭᓅᑯᐱᓈ ᐊᓂᑖᐦ ᔂᑐᒻ ᐃᐦᑖᐎᓂᐦᒡ ᒋᐱᐦ ᒌᐦ ᒀᔅᑳᑎᓯᐎᒡ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᐋᔥᒄ ᒋᐱᐦ ᑎᑯᓐ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ, ᒌᔨᐙᐤ ᐊᐅᔅᑖ ᐋᒀᒡ ᒋᑭ ᐄᔑ ᑎᐹᔅᑯᓂᑯᓈᐙᐤ ᐃᔥᐱᔥ ᐐᔨ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᔂᑐᒻ ᑳᐦ ᑖᒡ ᐋᑎ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᒥᒑᑎᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ᐋᑯᑖᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐊᔨᒥᐦᐋᑦ ᐋᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᒌᔨ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᐦᒋᔑᑯᐦᒡ ᑭᔮᐦ ᐋᔥᒋᐦᒡ, ᒌ ᓂᓈᔅᑯᒥᑎᓐ ᐋ ᒌ ᐙᐱᐦᑏᑣᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᐙᐦᒋ ᒋᔅᑯᑎᒧᐙᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳ ᑳᑑᑣᐤ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ᐋᐦᐋ, ᓅᐦᑖ ᒌ ᓂᓈᔅᑯᒥᑎᓐ ᐙᔥ ᐋᐅᒄ ᐆ ᑳ ᐄᔑ ᓂᐦᐋᔨᐦᑎᒥᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","ᐋᒄ ᒌᓴᔅ ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᒌᐦ ᐄᑖᐤ, “ᓅᐦᑖᐐ ᒥᓯᐙ ᒑᒀᔨᐤ ᓂᒌ ᒥᔨᒄ ᒑ ᒌ ᓂᓈᑭᑐᐙᔨᐦᑎᒧᒡ᙮ ᐙᔥ ᓂᒧᐃ ᐊᐙᓐ ᒋᔅᒑᔨᒫᐤ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐅᑯᓯᓯᒫᐤ, ᒥᒄ ᐅᐦᑖᐐᒫᐤ ᒋᔅᒑᔨᒫᐤ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐊᐙᓐ ᒋᔅᒑᔨᒫᐤ ᐊᐙᔨᐤᐦ ᐅᐦᑖᐐᒫᐤ, ᒥᒄ ᐅᑯᓯᓯᒫᐤ ᒋᔅᒑᔨᒫᐤ, ᑭᔮᐦ ᒥᒄ ᐐᔨ ᐅᑯᓯᓯᒫᐤ ᒋᑭ ᐅᐙᔮᐱᒫᐤ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᒑ ᒌ ᒋᔅᒑᔨᒫᔨᒡ ᐅᐦᑖᐐᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“ᐹᒋ ᓈᔑᒄ ᒥᓯᐙ ᒌᔨᐙᐤ ᑳ ᒥᔑᒥᔮᒄ ᐊᑯᓯᑰᐦᒡ ᒑᒀᓐ ᐋᐱᒨᑖᔮᒄ, ᒋᑭ ᒥᔨᑎᓈᐙᐤ ᒑ ᒌᐦ ᐋᐃᐙᓯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ᐳᔥᑎᔥᑭᒧᑎᔨᓱᒄ ᓂᒀᐱᑳᐙᑭᓈᐦᑎᒄ, ᐹᒋ ᒋᔅᒋᓄᐙᐱᒧᒄ ᒫᒃ, ᐙᔥ ᓂᔫᔅᐹᑎᓰᓐ ᓃᔨ ᑭᔮᐦ ᓂᑎᐱᐦᑖᔨᒧᓐ ᓂᑖᐦᐄᐦᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒋᑭ ᒌᐦ ᐋᔨᐙᓱᒡ ᒋᑎᐦᒑᐦᑯᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ᐙᔥ ᐙᐦᑎᓐ ᓂᒀᐱᑳᐙᑭᓈᐦᑎᒄ ᐋᐦ ᐋᐱᑎᐦᒡ ᐋ ᐱᒧᐦᑖᑭᓅᐦᒡ ᒑᒀᓐ ᑭᔮᐦ ᒫᒃ ᔮᐦᑭᓐ ᒑᒀᓐ ᐋ ᐱᒧᐦᑖᑭᓅᐦᒡ ᐋᓐ ᒫᔨᐙᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ᒫᒀᒡ ᒫᒃ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᒌᓴᔅ ᒌᐦ ᐐᒑᐙᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᐊᓂᑖᐦ ᑳ ᒌ ᓂᐦᑖᐅᒋᓃᔨᒡ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᓂᑎᐦ ᐙᐦᒋ ᐅᔑᐦᐋᑭᓂᐎᒡ ᐱᐦᒀᔑᑭᓂᒡ᙮ ᒌ ᔒᐅᑖᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐋᒄ ᑳ ᓈᓈᑣᔮᔅᑯᐱᑎᒥᔨᒡ ᐊᓂᔮ ᐱᐦᒀᔑᑭᓂᒥᓐ ᐋ ᒦᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔨᐦᑎᔨᒡ ᒌᐦ ᐄᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒑᒀᓐ ᐙᐦᒋ ᒌᐦ ᑐᑎᐦᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐊᓐ ᒑᒀᓐ ᐋᑳ ᒑ ᑐᑖᑭᓅᑯᐱᓈ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᐦ ᐹᕆᓰᐦ, “ᒋᒌ ᐊᔨᒥᐦᑖᓈᐙᒑ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳ ᑎᐹᒋᒫᑭᓅᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ, ᒥᓯᐙ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᐐᒑᐅᑯᑦ ᐄᔥᐱᐦ ᑳ ᐐᐦ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ᒌ ᐲᐦᒑᐤ ᐊᓂᑎᐦ ᒋᔖᒥᓂᑑ ᐋ ᐊᔨᒥᐦᐊᔅᑎᒥᐦᒡ ᐋᒄ ᑳ ᒧᐎᐙᑦ ᐊᓂᔮ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑳ ᐊᔑᒫᑦ ᐅᐐᒑᐙᑭᓐᐦ᙮ ᒥᒄ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌᐦ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ ᒑ ᒌᐦ ᒧᐙᐙᑯᐱᓈ ᐅᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐙᔥ ᐋᔪᐎᒄ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐎᔮᔥ ᐅᐦᒋ ᑐᑎᐙᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ᑭᔮᐦ ᒋᒌ ᐊᔨᒥᐦᑖᓈᐙᒑ ᐊᓂᑖᐦ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓂᒌ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᐋᐦ ᐋᐱᑎᔒᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᐲᑯᓂᒧᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑖᓐ ᒑ ᐄᔑ ᓈᓈᑭᒋᐦᑖᑭᓄᐎᔨᑯᐱᓈ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᓂᒧᐃ ᒫᒃ ᒑᒀᔨᐤ ᒋᑭ ᒌᐦ ᐄᔑ ᐊᑖᒫᔨᐦᑖᑯᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑖᐤ ᐊᐙᓐ ᐅᑎᐦ ᐊᐅᔅᑖ ᐋ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐ ᑖᓐ ᐋᑐᐙᑖᑭᓂᐎᒡ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌᐦ ᐃᔨᑦ, ᒋᔅᑎᒫᒑᐄᐦᒋᒑᐎᓐ ᐋᐅᒄ ᓈᑐᐙᔨᐦᑎᒫᓐ, ᓂᒧᐃ ᐐᐦ ᐋ ᒥᒋᔥᑎᐦᐋᒫᓂᐎᒡ ᒑᒀᓐ᙮ ᓂᔅᑐᐦᑎᒫᒄ ᒫᒃ ᐆ ᑖᓐ ᓂᐦᐋᐤ ᐋᑣᒥᑭᐦᒡ, ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᑎᐹᔅᑯᓈᐙᐅᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᒥᒋᐦᑑᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ, ᐙᐙᒡ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᑎᐹᔨᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐋᒄ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᐲᐦᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᓈᐹᐤ ᐅᑎᐦᒌ ᐋ ᒫᔅᑭᓃᔨᒡ᙮ ᐱᔅᒡ ᒫᒃ ᑭᔮᐦ ᐊᓂᑎᐦ ᐄᔨᔨᐅᒡ ᐋ ᓈᓈᑭᒋᐦᐋᒡ ᐊᓂᔮ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᓈᓂᑐ ᒥᔅᑭᐦᒡ ᒑᒀᔨᐤ ᒑ ᒌᐦ ᐅᐦᒋ ᐊᑖᒫᔨᒫᒡ ᐋ ᒥᒋᐦᑑᑎᒥᔨᒡ, ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ, “ᐎᓂᑐᑖᑭᓄᐙ ᐊᐙᓐ ᐋ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐹᔨᒄ ᒫᐦ ᐊᐙᓐ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᐅᒫᓂᔥᒑᓂᔒᒻ ᐲᐦᒋᐱᔨᔨᒡ ᐊᓂᑖᐦ ᐋ ᐱᑯᓈᔮᔨᒡ, ᓂᒧᐃ ᐋ ᐊᔮᐱᒡ ᑭᑎ ᐐᐦ ᐱᐦᑯᐦᐋᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᐲᐦᒋᐱᔨᔨᒡ ᐋᑎ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ᐊᐅᔅᑖ ᒫᒃ ᓈᐹᐤ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐᔨ ᒫᓂᔥᒑᓂᔥ᙮ ᓂᒧᐃ ᒫᒃ ᐎᔮᔑᓐ ᐋ ᒥᔪ ᐐᒋᐦᐄᑦ ᐊᐙᓐ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᐦ ᓈᐹᐤᐦ ᐅᑎᐦᒌᔨᐤ ᑳ ᒫᔅᑭᓃᔨᒡ, “ᓰᑐᐱᔨᐦᑖᐦ ᒋᑎᐦᒌ᙮” ᒌ ᓰᑐᐱᔨᐦᑖᐤ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ, ᐋᒄ ᒫᒃ ᑳ ᒦᓂᐙᒋᐦᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ᙮ ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑯᑎᒋᔨᐤ ᐅᑎᐦᒌ ᑳ ᐄᔑ ᒥᔻᔨᒡ ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ ᑳ ᒫᔅᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᐹᕆᓰᒡ, ᑳᐦ ᐋᔨᒸᐦᐄᑯᒡ ᑖᓐ ᒋᐱᐦ ᒌᐦ ᑐᐎᒡ ᒑ ᒌ ᓂᐱᐦᐋᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐱᔮᐦᑎᐦᒃ ᑖᓐ ᐙᑑᑎᐙᑭᓅᑦ ᒌ ᒋᔅᑐᐦᑖᐤ, ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᓅᔔᔥᑳᑰ᙮ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᒫᑦ ᐋᑳ ᒑ ᐐᐦᑎᒧᐙᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐊᐙᓐ ᐐᔨ ᐃᔮᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳᐦ ᑎᒃ ᐋᒄ ᑳ ᑎᐱᐱᔨᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒋᔖᒥᓂᑑ, ᑖᓐ ᑳ ᐄᔑ ᒥᔮᑦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ ᐋᐃᓵᔮᐦ ᒑ ᒌᐦ ᐄᔑ ᐋᔨᒨᑎᒥᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","ᒫᐤ ᓂᑖᐱᒋᐦᐋᑭᓐ ᑳ ᐎᔮᔨᒫᒃ, ᐊᓐ ᑳ ᓵᒋᐦᐋᒃ, ᑭᔮᐦ ᑳ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᑦ᙮ ᓂᑭ ᒥᔮᐤ ᓂᑎᐦᒑᐦᒄ ᐋᒄ ᒫᒃ ᒑ ᐐᐦᑎᒧᐙᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑯᐃᔅᒄ ᒑ ᑎᐹᔅᑯᓂᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓈᓂᑐ ᒥᒋᐱᔨᐤ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐋᔑᐦᒀᐤ ᓂᑖᐱᒋᐦᐋᑭᓐ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐱᐹᐦᑖᑯᐦᐅᑦ ᐊᓂᑖᐦ ᐱᒧᐦᑖᔅᑭᓈᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ᒋᑭ ᒥᓈᒋᐦᐋᐤ ᑭᔮᐦ ᒋᑭ ᒋᔖᐙᑐᑎᐙᐤ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᓵᐱᓯᔨᒡᐦ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐱᐦᒋᔑᒫᐤ ᐊᓂᔮᔨᐤᐦ ᒑᑳᑦ ᑳ ᐱᐦᒋᔑᓃᔨᒡᐦ, ᒨᔮᒻ ᐅᑎᐦᑯᓐ ᐋ ᐐᐦ ᓈᑣᐲᒡ ᓂᒧᐃ ᑭᑎ ᓈᑣᓂᒻ᙮ ᑭᔮᐦ ᒋᑭ ᐐᒋᐦᐋᐤ ᐋ ᔒᐦᒋᒫᑦ ᐋᑳ ᒑ ᐴᓃᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓅᐦᑎ ᑳ ᐐᐦ ᐴᓃᔨᒡᐦ ᒧᔮᒻ ᐙᔅᑎᓂᒫᑭᓂᔨᐤ ᐋ ᐐᐦ ᐊᔅᑑᐙᔨᒡ, ᓂᒧᐃ ᑭᑎ ᐋᔅᑎᐙᓂᒻ᙮ ᓂᒧᐃ ᑭᑎ ᐴᓈᔮᔨᒥᑎᒻ ᐋᐦᐋᑳ ᑯᔨᔅᑰᑖᑎᓰᐎᓂᔨᐤ ᐅᔅᑎᔅᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ᒥᓯᐙ ᒫᒃ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ ᒋᑭ ᐄᔅᐹᔨᒧᑎᒥᔨᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒌ ᐹᔓᐙᐅᒡ ᓈᐹᐤ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᐅᐦᒌ ᐊᔨᒥᔨᒡ, ᐋ ᒌ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᒦᓂᐙᒋᐦᐋᑦ ᐊᓂᔮᐦ ᓈᐹᐤᐦ, ᒑ ᒌ ᓂᐦᑖᐙᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᒥᓯᐙ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᑐᑎᒥᔨᒡ᙮ ᒌᐦ ᐄᑖᐅᒡ ᒫᒃ, “ᒀᔣᓐ ᑖᑆᐦ ᒌᓴᔅ ᐋᐎᒑ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐊᓂᑖᐦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᑎᔅᑳᓈᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᐊᓂᒌ ᐹᕆᓰᒡ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᒌᐦ ᐄᑖᐅᒡ, “ᐯᓪᓵᐳᓪ, ᐊᓂᔮᔨᐤᐦ ᒥᒋᐊᐦᒑᐦᑯᒡ ᐅᒋᒫᒧᐙᐤᐦ, ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤᐦ ᑳ ᒥᔨᑯᑦ ᒥᑖᐅᐎᓂᔨᐤ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐙᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒥᔨᒡ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐹᔨᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᒫᓯᐦᐄᑐᑣᐙ ᒋᑭ ᓂᔑᐎᓈᒋᑖᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐙᐤ, ᑭᔮᐦ ᐹᔨᒄ ᐃᐦᑖᐎᓐ ᐄᔨᔨᐅᒡ ᐋ ᒥᒋᐱᔨᒡ, ᐋ ᐱᐦᑳᓂᐦᐄᑐᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒋᐦᑳᐙᒋᐱᔨᐎᒡ, ᒋᑭ ᓂᔑᐎᓈᒋᐦᑖᐅᒡ ᒫᒃ ᐅᑎᐦᑖᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ᐄᔅᑉ ᒥᒋᒥᓂᑑ ᐎᐐᑎᔑᐦᐙᑖ ᐊᓂᔮᔨᐤ ᓅᔔᔅᑳᑯᑦ, ᒫᓯᐦᐄᓲ ᒫᒃ, ᒋᑭ ᓂᔑᐎᓈᒋᐦᑖᑭᓂᐎᔨᐤ ᒥᒋᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ᐋᐅᒄ ᒫᒃ ᒋᐱᐦ ᐄᔅᐱᔨᐤ ᑖᑆᐦ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ ᐅᒋᒫᐤ ᐯᓪᓯᐳᓪ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐹᒋ ᒥᔨᑦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒑ ᒌᐦ ᐋᐱᒋᐦᑖᐅᒡ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐅᒀᐤ ᒥᒋᐊᐦᒑᐦᑯᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᑎᐱᔨᐙ ᒋᑎᐄᔨᔨᒥᐙᐅᒡ ᑭᔮᐦ ᐋ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᐊᐙᔨᐤᐦ ᒫᒃ ᐐᔨᐙᐤ ᑳ ᒥᔨᑯᒡ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒑ ᒌ ᑎᒡ᙮ ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᑎᐱᔨᐙ ᒋᑎᐄᔨᔨᒥᐙᐅᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐋ ᓂᑎᔮᒄ ᐊᓐ ᐋ ᐃᔨᔮᒄ ᒥᒋᒥᓂᑑ ᐋ ᒥᔨᐙᑦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒑ ᒌᐦ ᐎᔨᐐᑎᔑᐦᐅᒫᑭᓂᐎᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᐋᐅᒄ ᑳ ᐹᒋ ᒥᔨᑦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒑ ᒌᐦ ᑐᑎᒧᒡ ᐅᔮᔨᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐙᐦᒋ ᐙᐱᐦᑎᔨᑯᐎᔮᒄ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᔖᔥ ᒥᑐᓐ ᐋ ᐅᑎᐦᑎᐦᐅᑯᐙᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐲᐦᒑᐙᐤ ᐋ ᓲᐦᒋᓰᔨᒡ ᓈᐹᐤ ᐐᒋᔨᐤ ᒑ ᒌᐦ ᑭᒑᒧᑎᐙᑦ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐹᑎᔥ ᓃᔥᑎᒻ ᒌ ᒫᐦᑯᐱᑖᒑ ᐊᓂᔮ ᓈᐹᐤ ᑳ ᓲᐦᒋᓰᔨᒡ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᒌ ᒋᒧᑎᐙᑦ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ᒌᓴᔅ ᒫᒃ ᒦᓐ ᒌᐦ ᐄᑖᐤ, “ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᐹᒋ ᐐᒋᐦᐄᑦ ᓂᓂᔥᑰᔥᑖᒄ᙮ ᐊᐙᓐ ᐋᑳ ᑳ ᐐᒋᐦᐄᑦ ᐋ ᒫᒨᓯᒋᓂᒑᐅᒡ, ᓯᒑᑎᔑᐦᐄᒑᐤ ᐃᓯᓈᑯᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐐᐦᑎᒫᑎᑯᒡ, ᒋᑭ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ ᐊᐙᓐ ᒥᒄ ᑖᓐ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ ᐋᐦ ᑐᑎᐦᒃ ᑭᔮᐦ ᒫᒃ ᐋ ᐄᔑ ᒥᒋᐋᔨᔨᒨᒫᑦ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᑭᑎ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ ᐊᐙᓐ ᑳ ᒥᒋᐋᔨᒨᒫᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ᒥᓯᐙ ᐊᐙᓐ ᑳ ᒥᒋᐋᔨᒨᒫᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᑎ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ᙮ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ ᐊᐙᓐ ᐊᓅᐦᒡ ᑭᔮᐦ ᒫᒃ ᐅᑖᐦ ᐄᔑ ᓃᑭᓂᐦᒡ ᒫᔮᔨᒫᒑ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᓂᐦᑖᐅᒋᐦᑖᑦ ᒦᓂᔥ ᒥᔥᑎᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᓂᓯᑑᓄᐙᑭᓅᑦ ᒑᒄ ᒥᔥᑎᒄ ᐊᓐ᙮ ᒥᔥᑎᒄ ᐋ ᒥᔪᓃᐦᑖᐅᒋᑦ ᒥᔪ ᓂᐦᑖᐅᒋᓂᔨᐤ ᒦᓂᔥ᙮ ᐋᐦᐋᑳ ᒫᒃ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᒥᔥᑎᒄ ᓂᒧᐃ ᒥᔻᔑᐤ ᐊᓂᐦᐄ ᒦᓂᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐃᔮᔮᒄ ᒑᒀᓐ ᐋ ᒥᔪᐦᑖᑯᐦᒡ ᐋ ᒥᒑᑎᓯᔮᒄ ᒫᒃ ᒧᔮᒻ ᐊᒋᓈᐳᑯᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ᙮ ᑖᓐ ᐋ ᐄᔑ ᐊᔨᒥᑦ ᐊᐙᓐ ᐋᑯᑖᐦ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᓯᑦ ᑖᓐ ᐋ ᐄᔑ ᓵᑭᔅᒋᓈᔨᒡ ᐅᑖᐦᐄᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ᐊᓐ ᐊᐙᓐ ᑯᐃᔅᒄ ᐋᑎᒃ, ᐊᓂᔮᔨᐤ ᐱᔮᒡ ᐎᔨᐐᐲᐦᑖᑦ ᒥᔻᔑᔨᐤ ᐙᔥ ᐋᔪᐎᒃ ᐋᐦᑎᑯᓃᔨᒡ ᐅᑖᐦᐄᒡ᙮ ᐊᓐ ᐋ ᒥᒑᑎᓯᑦ ᐊᐙᓐ, ᐊᓂᔮᔨᐤ ᐋᐦᐋᒃ ᒥᔻᔒᒡ ᐋᔪᐎᒃ ᐱᔮᒡ ᐎᐐᐱᐦᑖᑦ ᐙᔥ ᐋᔪᐎᒃ ᐊᐦᑎᑯᓃᔨᒡ ᐅᑖᐦᐄᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒑᔥᑎᓈᔥ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᑦ ᐊᐙᓐ ᐋᐦᐋᑳ ᐋᐱᑎᓃᔨᒡ ᒋᑭ ᐐᐦᑎᒻ ᒑᒀᔨᐤ ᐙᐦᒋ ᒌᐦ ᐃᔨᑦ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ᐊᓐ ᑖᓐ ᐋ ᐄᔑ ᐊᔨᒥᔮᒄ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᓯᔮᒄ ᑯᐃᔅᒄ ᑳ ᑎᐙᒀ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᑯᐃᔅᒄ ᐙᐦᒋ ᑎᐙᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌᐦ ᐅᐦᒋ ᐋᔨᒨᒡ ᐋᐦ ᐄᔨᔨᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓂᐐᐙᐱᐦᑖᓈᓐ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᐋᐦ ᑐᑎᒥᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓅᐦᒡ ᐄᔨᔨᐅᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᓈᔥᑖᑆᐦ ᒥᒑᑎᓯᐎᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᑎᑖᑆᓰᔅᑑᐙᒡ ᒋᔖᒥᓂᑑ᙮ ᑳ ᑯᒀᒋᐦᒑᒧᔮᒄ ᒑ ᒌ ᐙᐱᐦᑎᔨᑯᐎᔮᒄ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐙᐱᐦᑎᔨᑯᓈᐙᐤ᙮ ᒥᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐄᔅᐱᔨᑦ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒍᓈ ᐋᐅᒄ ᒥᒄ ᐊᓐ ᒑ ᐙᐱᐦᑎᔨᑯᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ᒧᔮᒻ ᒍᓈ ᑳ ᐃᔥᐱᔥ ᑖᑦ ᐊᓂᑖᐦ ᒥᔥᑎᐦ ᓂᒫᔅ ᐙᑖᔨᐦᒡ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᑭᔮᐦ ᓂᔥᑐ ᑎᐱᔅᑳᐤ, ᐋᔪᐎᒄ ᑭᔮᐦ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᑭᔮᐦ ᓂᔥᑐ ᑎᐱᔅᑳᐤ, ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᐃᔥᐱᔥ ᓂᐦᐄᐦᑭᐙᑭᓅᑦ ᐊᓂᑖᐦ ᐄᔑ ᐄᑖᒥᐦᒡ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ᐄᔥᐱᐦ ᒫᒃ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒑ, ᐊᓂᔮᐦᑳ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᓂᓀᕓᐦᒡ ᑳ ᒌᐦ ᑖᒡ ᒋᑭ ᐅᐦᐱᑳᐳᐎᒡ ᒑ ᐃᔨᒡ ᐎᔮᔅ ᒑ ᒌᐦᑐᑖᑯᔮᒄ ᒌᔨᐙᐤ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔮᒄ᙮ ᐙᔥ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒀᔅᑳᑎᓰᔨᒡ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᒍᓈ ᐋ ᑭᒑᔅᒀᔨᒡ, ᑖᐤ ᒫᒃ ᐊᐙᓐ ᐅᑎᐦ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᒍᓈ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᑰᐦᒋ ᒀᔅᑳᑎᓰᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ᐄᔥᐱᐦ ᒫᒃ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ ᐅᑎᐦᒋᐱᔨᐦᒑ, ᐊᓂᔮ ᒋᒋᐅᒋᒫᔅᒀᐤ ᐲᓯᒸᑖᐦᒡ ᑳ ᑎᐹᔨᐦᒋᒑᑯᐱᓈ ᒋᑭ ᐅᐦᒋ ᐱᓯᑰ ᒑ ᓂᔑᐎᓈᒋᒫᑦ ᐊᓂᔮ ᐊᐙᔨᐤᐦ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ᙮ ᐙᔥ ᐐᔨ ᓈᔥᑖᑆᐦ ᐙᐦᔨᐤ ᒌᐦ ᐅᐦᑐᐦᑖᐤ ᒥᒄ ᒑ ᒌ ᓂᑑᓂᑑᐦᑎᐙᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᔂᓚᒥᓐ ᐅᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᑖᐤ ᒫᒃ ᐅᑎᐦ ᐊᐙᓐ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᔂᓚᒥᓐ, ᓂᒧᐃ ᒫᒃ ᐃᔮᐱᓯᐦᑎᐙᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᐄᔥᐱᐦ ᐋ ᒌᐦ ᐎᔨᐐᑦ ᒥᒋᐊᐦᒑᐦᒄ ᐲᐦᒡ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ, ᐊᓂᑖᐦ ᐋ ᐹᐦᒀᔨᒡ ᐱᐹᐄᐦᑖᐤ ᐋ ᓈᓂᑎᐙᔨᑎᐦᒃ ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐋᔨᐙᓯᑦ᙮ ᐋᐦᐋᑳ ᒫᒃ ᒫᔅᑭᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ᐋᒄ ᐋᐦ ᐄᑎᔓᑦ, ‘ᑳᐤ ᓂᑭ ᓈᓂᑎᐙᐱᒫᐤ ᐊᓐ ᓈᐹᐤ ᑳ ᓂᑭᑎᒃ᙮’ ᐊᓐ ᒫᒃ ᓈᐹᐤ ᒧᔮᒻ ᐙᔅᑳᐦᐄᑭᓐ ᐃᓯᓈᑯᓯᐤ᙮ ᑭᔨᑆ ᑳᐤ ᐋ ᐄᔑ ᒌᐙᑦ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᓈᓂᑐᐙᔨᐦᑎᐦᒃ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐎᔨᐐᑦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐲᐦᒑᑦ ᒫᔅᑭᐦᒃ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐋᐦᐋᑳ ᑖᓂᐎᔨᒡ ᑭᔮᐦ ᐋ ᒌ ᒋᔑᐦᐄᒑᓂᐎᔨᑯᐱᓈ ᑭᔮᐦ ᓈᔥᒡ ᐋ ᐱᔮᐦᒋᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ᐅᔮᔨᐤ ᒫᒃ ᐎᔮᐱᐦᑎᐦᒃ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐋᒄ ᒑᔅᑐᐦᑖᑦ, ᓂᔮᓂᑎᐙᔨᒫᑦ ᓃᔣᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐊᐅᔅᑖ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐐᔨ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ, ᒑ ᒌᐦ ᐐᒋᒥᑯᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐲᐦᒡ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐊᑎᑎᐤ ᒋᑭ ᐄᑖᔨᐦᑖᑯᐦᐄᑰ ᐊᓂᔮᔨᐤ ᓃᔣᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓯᑦ ᓃᔥᑎᒻ, ᒥᒄ ᐋ ᒌ ᐹᔨᑯᔑᔨᒡ᙮ ᐋᔨᐅᒄ ᒫᒃ ᒑ ᐄᔅᐱᔨᔨᒡ ᐊᓂᒌ ᐊᓅᐦᒡ ᐄᔨᔨᐅᒡ ᑳ ᒥᒑᑎᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᒌᓴᔅ ᒌ ᐊᔨᒥᐦᐋᐤ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᑳ ᐅᐦᒋ ᑎᑯᔑᓃᔨᒡ ᐅᑳᐐᐦ ᑭᔮᐦ ᐐᒋᔖᓐᐦ᙮ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑖᐦ ᒌᐦ ᓃᐴᔨᐤ ᐋ ᐐᐦ ᐊᔨᒥᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ᐋᒄ ᐹᔨᒄ ᐊᓂᑎᐦ ᐊᐙᔨᐤᐦ ᑳᐦ ᐄᑎᑯᑦ, “ᒋᑳᐐ ᑭᔮᐦ ᒌᒋᔖᓂᒡ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑖᐦ ᓃᐴᐎᒡ ᐋ ᐐᐦ ᐊᔨᒥᐦᐄᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᒫᒃ ᓂᑳᐐ ᑭᔮᐦ ᓃᒋᔖᓂᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ᐋᒄ ᑳ ᐊᑐᐦᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᒫᐅᒌ ᓃᒋᔖᓂᒡ ᑭᔮᐦ ᐋᐅᒄ ᓂᑳᐐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ᒧᔮᒻ ᓂᑳᐐ ᑭᔮᐦ ᓃᒋᔖᓂᒡ ᑭᔮᐦ ᓃᒋᔖᓂᔅᒀᒥᒡ ᓂᑎᐄᑖᔨᒫᐅᒡ ᐊᓂᒌ ᑳᐦ ᑐᑎᐦᒡ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐹᔨᑯᓃᔨᒡ ᐋ ᒌᔑᑳᔨᒡ ᒌᓴᔅ ᒌ ᓂᑭᑎᒻ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ, ᐋᒄ ᐊᓂᑖᐦ ᔑᔓᒡ ᑳ ᐄᑐᐦᑖᑦ ᐋᒄ ᑳ ᐅᐙᔨᐱᑦ ᐊᓂᑎᐦ ᔑᔓᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ᓈᔥᒡ ᒫᒃ ᒌᐦ ᐋᑎ ᒥᐦᒑᑎᔨᐤ ᐊᐙᔨᐤᐦ ᐋ ᐹᒋ ᓂᔥᑐᐎᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐋᒄ ᐄᔨᐙ ᑳ ᐴᓯᑦ ᒌᒫᓂᓯᔨᐤ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐊᐱᑦ, ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᔑᔓᒡ ᒌᐦ ᓃᐴᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᒫᒃ ᒌᐦ ᐋᐱᒋᐦᑖᐤ ᒌᓴᔅ ᐋ ᐙᐐᐦᑎᒧᐙᑦ ᒥᐦᒑᑐ ᒑᒀᔨᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐹᔨᒀᐤ ᓈᐹᐤ ᒌ ᓂᑑᓂᐦᑖᐅᒋᐦᒑᐤ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᓯᐦᒑᐙᐱᓂᐦᒃ ᔒᒥᓐ ᑳ ᓂᑖᐆᒌᐦᒑᒥᑭᐦᒡ ᐱᔅᒡ ᐊᓂᑖᐦ ᐹᑐᑖᔅᑭᓂᐤ ᒌ ᐱᐦᒋᔥᑎᓂᔨᐤ, ᐋᒄ ᐱᔮᔒᔥ ᒥᓯᐙ ᑳ ᒦᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ᑯᑎᒃ ᔒᒥᓐ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐎᔨᒡ ᒌ ᐱᐦᒋᔥᑎᓂᔨᐤ, ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᒥᔥᑏᐦ ᐊᔅᒌᐎᔨᒡ, ᐐᐱᒡ ᒫᒃ ᒌ ᓵᒋᓂᐦᑖᐅᒋᓂᔨᐤ ᐙᔥ ᑖᐹ ᐅᐦᒋ ᒋᔅᐱᑳᐤ ᐊᓂᑎᐦ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐋᑎ ᐄᔥᐹᐦᒃ ᐲᓯᒻ ᒌᐦ ᐃᔥᒀᑖᐤ ᐊᓂᐦᐄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᒑᒃ ᒌᐦ ᐋᑎ ᓂᐲᒥᑭᓐ ᐙᔥ ᑖᐹ ᐅᐦᒋ ᐅᑎᐲᒥᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ᐋᒄ ᐊᓂᐦᐄ ᒦᓐ ᑯᑎᒃ ᔒᒥᓐ ᑳ ᐹᐦᐱᐦᒋᑎᐦᒡ ᐊᓂᑖᐦ ᑳᑳᐙᔅᑯᐦᒡ ᓂᐱᓯᔮᐦᑎᒄ ᐋᐦᑎᑯᐦᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑᒃ ᑳᐦ ᐋᑎ ᐃᔅᒡ ᓂᐦᑖᐅᒋᐦᒡ᙮ ᒑᒃ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᓐ ᐊᓂᐦᐄ ᑳ ᓂᐦᑖᐅᒋᐦᑖᑭᓂᐎᒡ ᐋ ᒌ ᒋᐱᔥᑳᑑᒥᑭᐦᒡ ᐊᓂᐦᐄ ᑳ ᑳᐙᔅᑯᐦᒡ ᓂᐱᓯᔮᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ᐱᔅᒡ ᒫᒃ ᐊᓂᔮ ᔒᒥᓐ ᐋ ᒥᔪᔅᑭᒥᑳᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᐱᐦᒋᐦᑎᓃᔨᔨᒡ, ᒌ ᒥᔪ ᓂᐦᑖᐅᒋᓐ ᐅᐦᐄ, ᐋᒄ ᒫᒃ ᑳ ᒥᔪ ᒦᓂᔑᐎᒡ᙮ ᐱᔅᒡ ᒫᒃ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᓂᐦᑖᐅᒋᓐ ᐹᔨᒄ ᔒᒥᓐ ᐅᐦᒋ, ᐋᒄ ᑯᑎᒃ ᓂᑯᑣᓱᒥᑎᓂᐤ ᒌ ᓂᐦᑖᐅᒋᓐ, ᐋᒄ ᑯᑎᒃ ᓂᔥᑐᒥᑎᓂᐤ ᒌ ᓂᐦᑖᐅᒋᓐ ᐹᔨᒄ ᔒᒥᓐ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᐊᓐ ᐊᐙᓐ ᑳ ᐅᐦᑎᐎᑳᑦ ᐋ ᓂᐦᐄᐦᑎᐦᒃ ᒫᒃ, ᔮᒀᐦ ᑭᑎ ᐐ ᓂᑐᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᓈᑖᒡ ᒌᓴᔅᐦ ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ, “ᒑᒀᓐ ᐙᐦᒋ ᐐᐦᑎᒥᓐ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᐋ ᐊᔨᒥᐦᐄᑣᐤ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᒌ ᒥᔨᑯᓈᐙᐤ ᒌᔨᐙᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐊᓐ ᒑᒀᓐ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᒥᔮᑭᓂᐎᒡ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒡ, ᐋᐅᒄ ᐊᓐ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒫᒄ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐ ᐐᔨᐙᐤ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐱᒋᔅᑎᓈᑭᓂᐎᒡ ᐊᓂᔮ ᒑ ᒌᐦ ᐄᔑ ᒋᔅᒑᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ᐙᔥ ᐊᓐ ᐊᐙᓐ ᑳ ᐃᔮᑦ ᓂᔅᑐᐦᑎᒧᐎᓂᔨᐤ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᒋᑭ ᒥᔮᑭᓂᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒃ᙮ ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᓂᔅᑐᐦᑎᐦᒃ ᒋᑭ ᐅᑎᓂᑭᓂᐎᔨᐤ ᐙᐙᒡ ᐊᓂᔮᔨᐤ ᐊᐱᔒᔥ ᑳ ᐄᔑ ᓂᔅᑐᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ᐋᔪᐎᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐐᐦᑎᒨᒀᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᐋ ᐊᔨᒥᐦᐄᒀᐤ, ᐙᔥ ᐋᑎ ᐋ ᐹᒋ ᑭᓂᐙᐱᒥᒡ ᑖᓐ ᐋᔨᑑᐎᒡ ᓂᒧᐃ ᒌ ᓂᓯᑑᓂᒧᒡ ᑭᔮᐦ ᐋ ᐹᐦᑑᐎᒡ ᑖᓐ ᐋ ᐃᔨᐅᒡ ᓂᒧᐃ ᓂᑑᐦᑎᒨᒡ ᑭᔮᐦ ᓂᒧᐃ ᓂᔅᑐᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ᒧᔮᒻ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳᐦ ᐃᔨᑯᐱᓈ, ᐅᒌ ᐄᔨᔨᐅᒡ ᒋᑭ ᐹᐦᑎᒧᒡ ᓂᒧᐃ ᒥᒄ ᒋᑭ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ, ᒋᑭ ᐙᐱᐦᑎᒧᒡ ᓂᒧᐃ ᒥᒄ ᒋᑭ ᐅᐦᒋ ᓂᓯᑑᓂᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ᐙᔥ ᓂᒧᐃ ᐐᐦ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᑭᔮᐦ ᓂᒧᐃ ᐐ ᓂᑐᐦᑎᒧᒡ ᑭᔮᐦ ᓂᒧᐃ ᐐ ᓂᔅᑐᐦᑎᒧᒡ ᐅᑖᐦᐄᐙᐦᒡ ᑭᔮᐦ ᓂᒧᐃ ᐐᐦ ᐙᐱᐦᑎᒧᒡ᙮ ᐋᑳ ᒫᒃ ᐅᐦᒋ ᑎᒡ ᐅᔮᔨᐤ ᒋᐱᐦ ᐙᐱᐦᑎᒧᒡ, ᒋᐱᐦ ᐹᐦᑎᒧᒡ ᑭᔮᐦ ᒋᐱᐦ ᓂᔅᑐᐦᑎᒧᒡ, ᐋᒄ ᒫᒃ ᓂᐱᐦ ᐹᒋ ᓂᑎᐙᐱᒥᑯᒡ, ᐋᒄ ᒫᒃ ᓂᐱᐦ ᒦᓂᐙᒋᐦᐋᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ᒌᔨᐙᐤ ᒫᒃ ᒋᒌ ᒋᔖᐙᑐᑖᑯᐙᐤ ᒋᔖᒥᓂᑑ ᐙᔥ ᒋᓂᔅᑐᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐙᐱᐦᑎᒫᒄ ᑭᔮᐦ ᒋᓂᔅᑐᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐹᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᑖᐦ ᐹᒋ ᒌ ᒥᐦᒑᑑᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᒌ ᒥᐦᒑᑑᒡ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐋ ᒌ ᐱᑯᓵᔨᐦᑎᐦᒡ ᒑ ᒌ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᐙᐱᐦᑎᒫᒄ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐙᐱᐦᑎᒧᒡ ᑭᔮᐦ ᒌ ᐱᑯᓵᔨᐦᑎᒧᒡ ᒑ ᒌ ᐹᐦᑎᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᐹᐦᑎᒫᒄ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐹᐦᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ᓂᑎᐦᑎᒧᒄ ᒫᐦ, ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐊᓐ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᑳ ᑎᐹᒋᒧᔮᓐ ᓈᐹᐤ ᑳ ᓂᐦᑖᐅᒋᐦᐋᑦ ᔒᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐹᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐋᔨᒨᑖᑭᓂᐎᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐋᑳ ᒫᒃ ᓈᔅᑐᐦᑎᒧᒀ, ᒧᔮᒻ ᐊᓐ ᔒᒥᓐ ᐊᓂᑖᐦ ᔮᐃᔅᑭᓂᐤ ᑳ ᐱᐦᒋᔑᐦᒃ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᑦ, ᒥᒋᒥᓂᑑ ᒥᔅᑭᒥᑰ ᐅᑖᐦᐄᐦᒡ ᑳ ᐄᔑ ᐹᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ᐋᒄ ᐊᓐ ᔒᒥᓐ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐎᔨᒡ ᑳ ᐱᐦᒋᔑᐦᒃ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐄᔨᔨᐅᒡ ᐐᐱᒡ ᐋᐦ ᐋᑎ ᐹᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ ᑏᐙᐦᒡ ᑳᐦ ᐋᑎ ᐅᑎᓂᐦᒡ, ᓈᔥᒡ ᒫᒃ ᑳ ᒥᒨᒋᒑᔨᐦᑎᒥᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ᒧᔮᒻ ᒫᒃ ᐊᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᑳ ᑳ ᔮᐃᒡ ᓂᐦᑖᐅᒋᓃᔨᒡ ᐅᑎᐲ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ, ᓂᒧᐃ ᓈᐅᔥ ᑖᑆᐦᑎᒧᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᔨᒧᐦᐅᓈᓂᐎᔨᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᔨᒡ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐅᐦᒋ, ᑏᐙᐦᒡ ᐴᓃᐅᒡ ᐋ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ᐋᒄ ᒫᒃ ᐊᓐ ᑯᑎᒃ ᔒᒥᓐ ᑳ ᐱᐦᒋᔑᐦᒃ ᐊᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ ᑳᑳᐙᔅᑯᐦᓃᔨᔨᒡ ᓂᐱᓯᔮᐦᑎᒄ, ᐋᐦ ᐋᑎ ᓂᐦᑖᐅᒋᑦ ᒫᒃ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐄᔨᔨᐅᒡ ᑳ ᓂᑐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᐋ ᒧᑯᔥᑳᒋᔥᑖᒡ ᐊᔅᒌᐦᒡ ᒑᒀᔨᐤ ᑭᔮᐦ ᓈᔥᒡ ᒥᒄ ᐋ ᐐᐦ ᐅᔔᔮᓂᒥᒡ ᐋᐦ ᑎᒡ ᑭᔮᐦ ᐱᔑᔑᐦᒄ ᐋ ᒧᔥᑖᓂᐦᒡ ᒑᒀᔨᐤ ᒑ ᒌᐦ ᐃᔮᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᒑᒃ ᐃᔮᔪᓃᔨᒡ ᐅᑖᑆᐦᑎᒧᐎᓂᐙᐤ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒌ ᒦᓂᔑᐎᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ᐊᓐ ᒫᒃ ᔒᒥᓐ ᑳ ᐱᐦᒋᔑᐦᒃ ᐋ ᒥᔻᔒᔨᒡ ᐊᔅᒌᐦᒡ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓂᑐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᓂᔅᑐᐦᑎᐦᒧᒡ, ᓅᑯᓂᔨᐤ ᒫᒃ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᒥᔪ ᓂᐦᑖᐅᒋᐦᐄᑯᒡ᙮ ᒨᔮᒻ ᐊᒀᓯᓈᑯᒡ ᐋ ᒥᔪᓂᐦᑖᐆᒋᐦᑖᑦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ, ᐹᔨᒀᐤ ᒦᑖᐦᑐᒥᑎᓂᐤ, ᓂᑰᑣᓲᒥᑎᓂᐤ ᑭᔮᐦ ᒫᒃ ᓂᔥᑐᒥᑎᓂᐤ ᐃᔥᐱᔥ ᒦᓐ ᐄᐙᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᑯᑎᒋᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᐋᐅᒄ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᓈᐹᐤ ᐋ ᓂᐦᑖᐅᒋᐦᐋᑦ ᐋ ᒥᔪᔑᔨᒡ ᔒᒥᓐ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᑎᐱᔅᑳᔨᒡ ᒫᒀᒡ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᓂᐹᑦ, ᐊᐙᔨᐤᐦ ᐋ ᐅᐦᑳᑎᑯᑦ ᐊᓐ ᓂᐦᑖᐅᒋᐦᒑᓯᐤ ᒌ ᑎᑯᔑᓂᔨᐤ, ᐋᒄ ᑳ ᐙᓯᔂᐙᐱᓂᒥᔨᒡ ᒥᒋᔒᒥᓐ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓂᐦᒡ, ᐋᒄ ᑳ ᒋᐦᑐᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᒋ ᓵᒋᓂᐦᑖᐅᒋᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᑯᑎᐦ ᑭᔮᐦ ᑳ ᓅᑯᓃᔨᔨᒡ ᐊᓂᔮᔨᐤ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ᐋᒄ ᐊᓐ ᓂᐦᑖᐅᒋᐦᒑᓯᐤ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ ᐅᑖᐱᒋᐦᐋᑭᓐ, ᑳᐦ ᐄᑎᑯᑦ, ‘ᐅᒋᒫᐤ, ᓂᒧᐃ ᐋ ᑳ ᒥᔻᔑᒡ ᔒᒥᓐ ᑯᐦᒋ ᐙᓯᔂᐙᐱᔨᐦᑖᓐ ᑳ ᓂᐦᑖᐅᒋᐦᒑᔨᓐ? ᑖᓂᑖᐦ ᒫᒃ ᐙᐦᒋᑎᑯᐦᒡ ᐊᓂᐦᐄ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ?’ ");
INSERT INTO crl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓐ ᐅᒋᒫᐤ, ‘ᐊᐙᓐ ᐋᐦᐋᑳ ᓂᐦᐋᔨᒥᑦ ᐋᐅᒄ ᐊᓐ ᑳᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ᙮’ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐅᑖᐱᒋᐦᐋᑭᓐ, ‘ᒋᓂᑎᐙᔨᒥᓈᓐ ᐋ ᒑ ᒌ ᓂᑑᒫᐦᒥᓂᐱᑎᒫᐦᒡ ᐊᓂᐦᐄ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ?’ ");
INSERT INTO crl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓐ ᐅᒋᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ‘ᓂᒧᐃ, ᐙᔥ ᒥᓂᐱᑎᒫᒀ ᐊᓂᐦᐄ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᒋᑭ ᐊᔅᒌᐱᑖᓈᐙᐤ ᐊᓂᐦᐄ ᑳ ᐐ ᓂᐦᑖᐅᒋᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ᐋᑯᔥ ᑖᐱᔥᑯᓐ ᐊᓂᐦᐄ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑭᔮᐦ ᐊᓂᐦᐄ ᑳ ᐐ ᓂᐦᑖᐅᒋᐦᑖᔮᓐ ᑖᐱᔥᑯᓐ ᒋᑭ ᓂᐦᑖᐅᒋᓐ, ᐹᑎᔥ ᒫᒨᓯᒋᓂᑭᓅᒀᐙ᙮ ᐋᒄ ᒫᒃ ᒑ ᐄᑎᒀᐤ ᐊᓂᒌ ᒑ ᒫᒨᔥᒋᓂᐦᒡ, ᓃᔥᑎᒻ ᐊᓂᔮᔨᐤ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᒑ ᒫᒨᔥᒋᓂᐦᒡ, ᐋᒄ ᒫᒃ ᒑ ᐊᓵᐱᐦᑳᑎᐦᒡ ᒑ ᐃᔥᒀᓯᐦᒡ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᐊᓂᔮᔨᐤ ᐱᐦᒀᔑᑭᓂᒥᓈᐦᑎᒄ ᒑ ᒫᒨᔥᒋᓂᐦᒡ, ᐊᓂᑖᐦ ᒑ ᐊᔥᑖᒡ ᓂᑎᔥᑖᓱᑭᒥᑯᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᑯᑎᒋᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᒧᔮᒻ ᐊᓐ ᔒᒥᓐ ᑳ ᐊᐱᔒᔑᑦ ᒫᔅᑎᕐᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮ ᐙᑎᓈᑦ ᓈᐹᐤ ᐋᐦ ᐋᑎ ᓂᐦᑖᐅᒋᐦᑖᑦ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ᐋᑦ ᒫᒃ ᒫᐅᒡ ᐋ ᐊᐱᔒᔑᑦ ᐊᓐ ᔒᒥᓐ ᐋ ᑎᔑᔨᒡ ᑯᑎᒃ ᔒᒥᓐ, ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᓂᐦᑖᐅᒋᑦ ᐐᔨ ᒫᐅᒡ ᒥᔥᑎᐦ ᐲᒀᓂᐦᑖᐅᒎ᙮ ᐊᓂᑖᐦ ᒫᒃ ᐋ ᐅᑎᐦᑯᓂᐎᔨᒡ ᐊᓂᔮ ᒥᔥᑎᒄ ᐋᑯᑖᐦ ᐎᒋᔥᑐᓂᐦᑳᓱᒡ ᐱᔮᔒᔑᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ᒌᓴᔅ ᒫᒃ ᒌ ᐐᐦᑎᒧᐙᐤ ᒦᓐ ᑯᑎᒋᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᒫᐤ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ, ᒧᔮᒻ ᐲᔂᔮᔨᐦᑯᓂᐤ ᐅᐦᐱᓯᑭᓐ ᐄᑖᔨᐦᑖᑯᓐ, ᐊᓂᔮᔨᐤ ᑳ ᒌ ᒌᑯᐎᓂᐦᒃ ᐃᔅᒀᐤ ᒥᔥᑏᐦ ᐱᐦᒀᔑᑭᓂᐦᒡ, ᒥᓯᐙ ᒫᒃ ᐅᐦᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ᒨᔥ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᒌᐦ ᐋᐱᒋᐦᑖᐤ ᒌᓴᔅ ᐋᐦ ᐋᔨᒨᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ, ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐱᔑᔑᐦᒄ ᑳᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᑎᒃ ᒑ ᒌ ᑖᑆᒥᑭᓃᔨᒡ ᑖᓐ ᑳᐦ ᐃᔨᑯᐱᓈ ᐊᓐ ᐅᒋᔅᒋᐙᐦᐄᒑᐤ, ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᓂᑭ ᐋᐱᒋᐦᑖᐙᓐ ᐋ ᐐᐦᑎᒨᒀᐤ ᐄᔨᔨᐅᒡ ᑖᓂᔮᔨᐤ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᓃᔨᒡ ᑳ ᐃᔥᐱᔥ ᐅᔑᐦᑖᑭᓂᐎᒡ ᐆ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ, ᑳ ᐲᐦᒑᑦ ᒫᒃ ᐊᓂᑖᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ, ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᒫᐦ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐊᓐ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑳᐦ ᐋᔨᒨᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᓈᐹᐤ ᑳ ᓂᐦᑖᐅᒋᐦᐋᑦ ᑳ ᒥᔪᔑᔨᒡ ᔒᒥᓐ ᐋᐅᒄ ᐊᓐ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ᐋᒄ ᐊᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ, ᐋᐅᒄ ᐊᔅᒌ, ᐊᓐ ᒫᒃ ᑳ ᒥᔪᔑᑦ ᔒᒥᓐ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᑳ ᐅᐦᒌᒡ᙮ ᐋᒄ ᐊᓐ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒥᒋᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒌᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐅᐦᑳᑖᑦ ᐊᓂᔮᐦ ᑳ ᓂᐦᑖᐅᒋᐦᒑᔨᒡ, ᐊᓐ ᑳ ᐙᐙᐱᓂᐦᒃ ᒥᒋᔔᒥᓐ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ, ᐋᐅᒄ ᐊᓐ ᒥᒋᒥᓂᑑ᙮ ᐊᓐ ᒫᒃ ᒑ ᐅᑎᐦᒋᐱᔨᐦᒡ ᒑ ᒌ ᒫᒨᔅᒋᓂᑭᓂᐎᐦᒡ ᐊᓂᐦᐄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᐅᒄ ᐊᓐ ᒑ ᐃᔅᒀᐱᔨᒡ ᐊᔅᒌ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᒫᒨᔥᒋᓂᐦᒡ ᐊᓂᔮᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑳ ᐃᔨᔮᓐ, ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᐋᓐᒋᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ᒧᔮᒻ ᒫᒃ ᐊᓐ ᒑ ᐃᓯᓈᑯᐦᒡ ᒑ ᒫᒨᔅᒋᓂᑭᓂᐎᐦᒡ ᐊᓂᐦᐄ ᒥᒋᓂᐦᑖᐅᒋᐦᒋᑭᓐ, ᒑ ᐃᔥᒀᓯᑭᓂᐎᒡ ᒫᒃ, ᐋᐅᒄ ᒧᔮᒻ ᒑ ᐄᔅᐱᔨᒡ ᐃᔅᒀᐱᔨᒑ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ᐄᔨᔨᐅᑯᓯᓵᓐ ᒋᑭ ᐄᑎᔑᐦᐙᐤ ᐅᑖᓐᒋᓂᒻ ᒑ ᒌ ᓂᑑᒫᒨᓯᒋᓈᐦᔨᒡ ᐊᓂᑖᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳᐦ ᑐᑎᐙᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᔨᒡ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮ ᐊᐙᔨᐤᐦ ᑳ ᒥᒋᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᒥᒋᔥᑯᑖᐦᒡ ᒑ ᐄᔑ ᐙᐱᓈᒡ ᐊᓂᑖᐦ ᐱᔑᔑᐦᒄ ᒑ ᒫᑑᔨᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᓯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᑯᔨᔅᑰᑖᑎᓰᔨᒡ ᐅᑎᔨᔨᒻᐦ ᒑ ᒌᐦᑳᔮᔅᑐᐙᔨᔨᒡ ᐊᓂᑖᐦ ᐅᐦᑖᐐᒫᐤ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᒧᔮᒻ ᐲᓯᒻ ᐋ ᐄᔑ ᒌᐦᑳᔮᔥᑐᐙᑦ᙮ ᐊᓐ ᐊᐙᓐ ᑳ ᐹᐦᑎᐦᒃ ᓲᐦᒃ ᑭᑎ ᐐᐦ ᓂᔅᑐᐦᑎᒻ ᐅᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“ᒫᐤ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ, ᒧᔮᒻ ᐋ ᔔᔮᓂᐎᒡ ᒑᒀᓂᐦᐄ ᐋ ᒌᐦ ᐃᔮᐅᐦᑭᐦᐄᑭᓄᐙᑯᐱᓈ ᐋᒄ ᒫᒃ ᓈᐹᐤ ᐋ ᒥᔅᑭᐦᒃ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᐦᒡ᙮ ᒦᓐ ᐋᐦ ᐋᑎ ᐃᔮᐅᐦᑭᐦᐋᐦᒃ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᐦᒃ ᐋᒄ ᓂᑑ ᐊᑖᐙᑦ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ, ᐋᒄ ᐙᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐊᓂᑎᐦ ᑳ ᒥᔅᑭᐦᒃ ᐊᓂᔮᔨᐤ ᑳ ᔔᔮᓂᐎᔨᒡ ᒑᒀᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“ᒫᐤ ᑭᔮᐦ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐ, ᒧᔮᒻ ᓈᐹᐤ ᑳ ᓈᓂᑎᐙᔨᒫᑦ ᒦᒋᔥᐦ ᓈᔥᒡ ᑳ ᔔᔮᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","ᐄᔥᐱᐦ ᒫᔅᑭᐙᑦ ᐹᔨᒄ ᓈᔥᒡ ᐋ ᒥᔪᔑᔨᒡ ᐋ ᒥᔥᑏᐦ ᔔᔮᓂᐎᔨᒡ, ᓂᑑ ᐊᑖᐙᐤ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋ ᐄᔑ ᐃᔮᑦ ᐋᒄ ᓂᑑ ᐅᑎᓈᑦ ᐊᓂᔮᐦ ᒦᒋᔥᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“ᒫᐤ ᒦᓐ ᐊᔮᐱᒡ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒧᔮᒻ ᓈᐹᐅᒡ ᐋ ᒌ ᐱᒋᔅᑎᐦᐙᒡ ᓵᑭᐦᐄᑭᓂᐦᒡ ᓂᓈᐦᑭᐤ ᒫᒃ ᐋ ᐃᓯᓈᑯᓰᔨᒡ ᓂᒫᔅ ᐋ ᐱᑎᐦᐊᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ᐄᔥᐱᐦ ᒫᒃ ᓯᔮᑭᔅᒋᓈᔨᒡ ᐊᓂᔮ ᐅᑎᐦᐄᐲᐙᐤ, ᐋᒄ ᐋᒀᓯᐱᑖᒡ ᐊᓂᑖᐦ ᔑᔓᒡ ᒑ ᒌ ᐱᐦᑳᓂᐦᐋᒡ ᐊᓂᔮ ᓂᒫᔅ, ᐊᓂᔮ ᑳ ᒥᔪᔑᔨᒡ ᐊᓂᑖᐦ ᐊᔅᒋᐦᑯᐦᒡ ᒌ ᐲᐦᑎᐦᐙᐅᒡ, ᐋᒄ ᐊᓂᔮ ᐋᑳ ᑳ ᒥᔪᔑᔨᒡ ᒌ ᐙᐱᓈᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᒑ ᐃᓯᓈᑯᐦᒡ ᐄᔥᐱᐦ ᐃᔅᒀᐱᔨᒑ ᐊᔅᒌ, ᐋᓐᒋᓂᒡ ᒋᑭ ᓂᑑᐱᐦᑳᓂᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᒑᑎᓰᔨᒡ ᐊᓂᑖᐦ ᐅᐦᒋ ᑖᐙᔨᔥ ᐊᓂᔮ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ᐋᒄ ᐊᓂᑖᐦ ᒥᒋᔥᑯᑖᐦᒡ ᒑ ᐄᔑ ᐙᐱᓈᑭᓂᐎᒡ ᐊᓂᒌ ᑳ ᒥᒑᑎᓯᒡ, ᐊᓂᑖᐦ ᒑ ᒫᑑᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᓯᒡ ᒑ ᐃᔥᐱᔥ ᐐᓯᒑᔨᐦᑎᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᓂᔅᑐᐦᑖᓈᐙᐤ ᐋ ᐆ ᑳ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ?” “ᐋᐦᐋ,” ᒌᐦ ᐄᑖᐅᒡ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒥᓯᐙ ᐊᓂᒌ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᑳ ᒋᔅᑯᑎᒧᐙᑭᓂᐎᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒧᔮᒻ ᐊᐙᓐ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᔥᑖᓲᑭᒥᑯᔨᐤ ᐋ ᑭᓄᐙᔨᐦᑎᐦᒃ ᒑᒀᔨᐤ ᑖᐱᔥᑯᓐ ᓈᔥᒡ ᐋ ᒥᔻᔑᔨᔨᒡ ᑖᐱᔥᑯᓐ ᐋ ᐙᔅᑭᒋᓈᑯᓃᔨᒡ ᑭᔮᐦ ᐋ ᐅᔥᑳᔨᔨᒡ᙮ ᑖᐱᔥᑯᓐ ᒫᒃ ᐋ ᒥᔻᐱᒋᐦᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᒌᔥ ᐙᐐᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒨᓐ ᒌ ᒋᔅᑐᐦᑖᐤ ᐊᓂᑎᐦ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ᐋᒄ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐙᐦᒌᑦ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒥᓯᐙ ᒫᒃ ᐊᓂᔮ ᑳ ᐹᐦᑖᑯᑦ ᒌ ᒥᔅᑳᔑᑖᑰ ᐋᐦ ᐄᑎᑐᔨᒡ, “ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᐃᔮᑦ ᐅᔮᔨᐤ ᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ, ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᐃᔮᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ? ");
INSERT INTO crl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ᓂᒥᔮᔨᐤ ᐋ ᐅᔮᔨᐤ ᒥᔅᑎᑯᓈᐹᐤ ᐅᑯᓯᔅᐦ? ᓂᒧᐃ ᐋ ᐅᑳᐐᐦ ᒣᕇ ᐃᔑᓂᐦᑳᓱᔨᐤ ᑭᔮᐦ ᓂᒥᔮᔨᐤ ᐋ ᐅᔮᔨᐤ ᒉᒥᔅ, ᒍᓯᕝ, ᓵᐃᒥᓐ ᑭᔮᐦ ᒍᑖᔅ ᐐᒋᔖᓂᐙᐤ? ");
INSERT INTO crl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ᓂᒧᐃ ᐋ ᑭᔮᐦ ᒥᓯᐙ ᐐᒋᔖᓂᔅᒀᒻ ᐐᒋᔨᐤ ᐅᑎᐦ᙮ ᑖᓂᑖᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᐃᔮᑦ ᐅᔮᔨᐤ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ?” ");
INSERT INTO crl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ᓂᒧᐃ ᐅᐦᒋ ᓂᐦᐄᔅᑳᑯᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ᙮ ᒥᒄ ᒫᒃ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐊᓐ ᐊᐙᓐ ᑳ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ ᒋᔅᑖᔨᒫᑭᓂᐤ ᐃᔨᐦᒡ ᐊᓂᑖᐦ, ᐋᒄ ᐊᓂᑎᐦ ᑎᐱᔨᐙ ᐅᑎ ᐃᐦᑖᐎᓂᐦᒡ ᐋᐦ ᑖᑦ ᓂᒧᐃ ᐃᔮᐱᑖᔨᒫᑭᓂᐤ᙮ ᐙᐙᒡ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ ᑳᐦ ᑖᔨᒡ ᓂᒧᐃ ᒋᔅᑖᔨᒥᑰ᙮” ");
INSERT INTO crl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᔨᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤ, ᓂᒧᐃ ᒥᐦᒑᑐ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ ᐅᐦᒋᑐᑎᒻ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ᐊᓐ ᒫᒃ ᒫᒀᒡ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᒌ ᐹᐦᑎᒻ ᑖᓐ ᐋᐦ ᐄᑎᒋᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ, ");
INSERT INTO crl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, “ᐋᐅᒄ ᐊᓂᔮ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ, ᒌᐦ ᐎᓂᔥᑳᒑ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐃᔮᑦ ᒥᔥᑭᐎᓰᐎᓂᔨᐤ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ᐙᔥ ᐐᔨ ᐦᐁᕆᑦ ᒌᐦ ᐄᑎᔓᐙᑖᑯᐱᓐ ᒑ ᒌᐦ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮ ᒞᓐ, ᑭᔮᐦ ᒑ ᒌ ᒫᐦᑯᐱᑎᒫᑭᓂᐎᔨᒡ, ᑭᔮᐦ ᒑ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ᐋᔪᐎᒄ ᐙᐦᒌᐦ ᑐᑎᐙᑦ ᐅᔮᔨᐤ ᐊᓂᔮ ᐐᒋᔖᓐᐦ ᕕᓕᑉᐦ ᐎᐐᔨᐤᐦ ᐦᐁᕎᑎᔭᔅᐦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋ ᒌᐦ ᐄᑎᑯᑦ ᐋ ᒌ ᐐᐦ ᓂᐦᐄᐙᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ᐙᔥ ᐦᐁᕆᑦ ᒌ ᐐᒋᒫᐤ ᐦᐁᕎᑎᔭᔅᐦ ᐊᓂᔮᔨᐤᐦ ᐐᒋᔖᓐᐦ ᕕᓕᑉᐦ ᐎᐐᔨᐤᐦ, ᐋᒄ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ ᒨᔥ ᑳᐦ ᐄᑖᑦ ᐦᐁᕆᑦ, “ᒋᐲᑯᓈᓐ ᐐᔓᐙᐎᓐ ᐋ ᐐᐅᐙᑦ ᒌᒋᐄᔨᔨᐤᐦ ᐐᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ᐋᒄ ᐦᐁᕆᑦ ᑳ ᐐᐦ ᓂᐱᐦᐋᑦ ᐊᓂᔮ ᒞᓐ, ᒥᒄ ᒫᒃ ᒌᐦ ᑯᔥᑖᐤ ᐊᓂᔮ ᒎᐄᔨᔨᐤ, ᐙᔥ ᒌ ᑖᑆᐦᑎᒧᒡ ᐋ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ᐄᔥᐱᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᑖᐱᔅᑭᐦᒃ ᒌ ᒥᑯᔖᐤ ᐋᒄ ᐊᓂᔮ ᐦᐁᕎᑎᔭᔅᐦ ᐅᑖᓂᓯᔨᐤᐦ ᒌᐦ ᓃᒥᔨᐤ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ᙮ ᐦᐁᕆᑦ ᒫᒃ ᓈᔥᒡ ᒌ ᓂᐦᐄᐙᐦᐄᑰ ᐊᓂᔮ ᐃᔅᒀᔥ ᑳᐦ ᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ᐋᒄ ᑳᐦ ᐄᑖᑦ, ᒑᔥᑎᓈᔥ ᒑ ᒥᔮᑦ ᒑᒀᔨᐤ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒦᒀᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ᐋᒄ ᐊᓐ ᐃᔅᒀᔥ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐅᑳᐐᐦ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᒑ ᐃᔨᑦ, ᒑ ᒋᒥᒀᐦᐅᒫᑭᓂᐎᔨᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᐤ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᔥᑎᒀᓂᔨᐤ ᐎᔮᑭᓂᐦᒡ ᒑ ᒌᐦ ᐊᔥᑖᑭᓂᐎᔨᒡ ᒑ ᐹᑖᑭᓂᐎᔨᒡ ᒫᒃ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ᓈᔥᒡ ᒌ ᒥᒑᔨᐦᑎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐦᒃ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᐊᓂᔮ ᐃᔅᒀᔥ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒌ ᒥᔮᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ, ᐙᔥ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐅᒫᓂᑖᒻ ᒌ ᐹᐦᑖᑰ ᐋ ᒌᐦ ᐄᑖᑦ ᐊᓂᔮ ᐃᔅᒀᔥ ᒑᔥᑎᓈᔥ ᒑ ᒥᔮᑦ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒦᒀᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᒋᒥᒀᐦᐅᒫᑭᓂᐎᔨᒡ ᒞᓐ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ᐋᒄ ᑳ ᐹᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᔥᑎᒀᓂᔨᐤ ᐎᔮᑭᓂᐦᒡ ᐋ ᒌᐦ ᐊᔥᑖᑭᓂᐎᔨᒡ, ᑳ ᒥᔮᑭᓅᑦ ᐊᓐ ᐃᔅᒀᔥᐦ, ᑳ ᐄᑐᐦᑐᑎᐙᑦ ᐊᓂᔮ ᐅᑳᐐᐦ ᐊᓂᔮᔨᐤ ᒥᔅᑎᒀᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ᐋᒄ ᒞᓐ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᑎᑯᔑᓃᔨᒡ, ᑳ ᐅᑎᓂᒸᒡ ᐊᓂᔮᔨᐤ ᐐᔮᔨᐤ, ᑳ ᓂᐦᐄᐦᑭᒸᒡ, ᐋᒄ ᑳ ᓂᑑᐐᐦᑎᒧᐙᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐹᐦᑎᐦᒃ ᒞᓐ ᐋ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᐦ ᐴᓲ ᒌᒫᓂᓯᔨᐤ ᐋ ᐹᔨᑯᔑᑦ ᐋᒄ ᐊᓂᑖᐦ ᑳ ᐃᔅᒋᒫᑦ ᐋᐦᐋᑳ ᓈᔥᑎᔨᔥ ᑖᓂᐎᔨᒡ᙮ ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᒑᔅᒑᔨᐦᑎᐦᒡ ᑖᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᒌ ᒋᔅᑐᐦᑖᐅᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᐦ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᐙᔅᑳ ᑳᑎᑯᓃᔨᒡ, ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ᐄᔥᐱᐦ ᒫᒃ ᑳᐹᑦ ᒌᓴᔅ, ᐎᔮᐱᒫᑦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᑭᔮᐦ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᐊᓂᔮ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᑳ ᐹᔑᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᔖᔥ ᒋᐦᒋᐙ ᐅᑖᑯᔔ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᑎᑯᓐ ᐃᐦᑖᐎᓐ ᐅᑎᐦ ᓂᐦᐋᐤ ᐋᐦ ᑖᔨᐦᒄ᙮ ᐄᑎᔑᐦᐅᒡ ᒫᐦ ᐊᓂᑖᐦ ᐊᓂᔮᐦ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᐙᔅᑳ ᑳᑎᑯᓃᔨᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᓂᑑᐅᑎᓂᐦᒑᒡ ᒑᒀᔨᐤ ᒑ ᒦᒋᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᑯᔥ ᐋᑳ ᑭᑎ ᒫᒌᐆᒡ, ᐋᑯᑖᐦ ᐅᑎᐦ ᒑ ᑖᒡ, ᒌᔨᐙᐤ ᒥᔮᐦᑯᒡ ᒑᒀᔨᐤ ᒑ ᒦᒋᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒫᒃ ᒌᐦ ᐄᑎᑰ ᒌᓴᔅ, “ᒥᒄ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐆᒡ ᓃᔓ ᒫᒃ ᓂᒫᓯᒡ ᐋᐅᒄ ᒥᒄ ᐋ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᒑᒀᓐ ᐋ ᒦᒋᓈᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐹᑖᒄ ᐊᓐ ᒦᒋᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᐄᔨᔨᐤ ᒑ ᐅᐙᔨᐱᔨᒡ ᐊᓂᑖᐦ ᒥᔥᑯᔒᐦᒡ᙮ ᐋᒄ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐊᓂᔮ ᓃᔓ ᓂᒫᔅ, ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᔑ ᐄᑖᐱᑦ ᐋ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᒌ ᐱᐱᐦᒀᐱᑖᐤ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑳ ᒥᔮᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒑ ᒌ ᒫᑎᓂᒧᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᒌ ᒦᒋᓲ ᑭᔮᐦ ᒌ ᑖᐱᔥᑯᔨᐤ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᒫᒨᔅᒋᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔥᑯᔥᑐᐙᓂᔨᐤ᙮ ᓃᔓᔖᑉ ᒫᒃ ᐅᑎᐲᐎᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ᒥᒄ ᒫᒃ ᓈᐹᐅᒡ ᐋ ᐊᒋᒫᑭᓂᐎᒡ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᐃᐦᑎᔑᐎᒡ ᐋᐦᐋᑳ ᐊᔅᑎᒋᒫᑭᓂᐎᒡ ᐃᔅᒀᐅᒡ ᑭᔮᐦ ᐊᐙᔑᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ᑏᐙᐦᒡ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᒫᑦ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒑ ᐴᓰᔨᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ, ᔖᔥ ᒑ ᒌᐦ ᓃᑳᓐ ᐄᔑᒋᒫᔨᒡ ᐊᓂᑖᐦ ᐊᑳᒥᐦᒡ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᐋᒄ ᐐᔨ ᐱᑎᒫ ᑳ ᒌᐙᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᐙᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᐋᒄ ᑳ ᔖᑭᒋᐙᑦ ᐊᓂᑖᐦ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᒑ ᒌ ᐹᔨᑯᔑᑦ ᐋ ᐊᔨᒥᐦᐋᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᓈᔥᒡ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᐋᔥᒄ ᒌ ᐹᔨᑯᔑᐤ ᒌᓴᔅ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᑖᑦ ᐊᓂᑎᐦ ᔖᔥ ᑖᐅᑳᒻ ᒌᐦ ᑎᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ ᐊᓂᑎᐦ ᑳ ᐴᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᓈᔥᒡ ᐋ ᓵᓵᒥᑖᐦᐅᑯᔨᒡ ᐋ ᐊᔨᒥᐦᐄᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ᒑᑳᑦ ᒫᒃ ᒌ ᐹᑖᐱᓂᔨᐤ, ᐎᔮᔥ ᒋᔅᑑᒡ ᓂᔥᑐ ᑭᔮᐦ ᒫᒃ ᑯᑣᔥᒡ ᐋᐦ ᐄᔅᐱᔨᒡ, ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᒡ ᐋ ᐱᒧᐦᑖᔨᒡ ᓂᐲᐦᒡ ᓈᔥᒡ ᒌ ᓵᒋᓯᐎᒡ, ᐋ ᐃᔥᐱᔥ ᓵᒋᓰᔨᒡ ᒫᒃ ᒌᐦ ᐋᓯᒀᐎᒡ ᐋᐦ ᐃᔨᒡ, “ᒌᐲ ᐊᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ᒥᒄ ᒫᒃ ᒌᓴᔅ ᑏᐙᐦᒡ ᒌ ᐊᔨᒥᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᔮᒫᔨᐦᑎᒧᒄ, ᐋᐅᒄ ᐙᔥ ᐆ ᓃᔨ, ᐊᑳᐐ ᑯᔥᑖᒋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᑖᑆᐦ ᐃᔮᐎᓈ ᒌᔨ, ᐹᒋ ᐄᔑᐦ ᒑ ᒌ ᓂᑎᐙᐱᒥᑖᓐ ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᔥᑎᒻ᙮” ᐋᒄ ᐲᑎᕐ ᑳ ᑭᐹᑦ ᒑ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮ ᒌᓴᔅᐦ ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ᐄᔥᐱᐦ ᐲᑎᕐ ᐎᔮᐱᐦᑎᐦᒃ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᔅᑎᔫᑎᓃᔨᒡ ᒌᐦ ᑯᔥᑖᒎ, ᐋᒄ ᑳᐦ ᐋᑎ ᑯᔖᐹᑦ᙮ ᒌ ᑖᑆᐤ ᒫᒃ ᐋᐦ ᐃᔨᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐹᒋ ᐐᒋᐦᐄᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ᑏᐙᐦᒡ ᒫᒃ ᒌᓴᔅ ᒌᐦ ᔑᐎᓂᔅᒑᔨᐤ, ᑳ ᐅᑎᓈᑦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᐱᓵᓲ ᒋᑖᑆᔨᐦᑎᒧᐎᓐ, ᒑᒀᓐ ᐙᐦᒋ ᐋᓍᐦᑎᒥᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ᐄᔥᐱᐦ ᒫᒃ ᑖᐱᔥᑯᓐ ᑳ ᐴᓯᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ, ᐋᒄ ᓈᔥᑎᔨᒡ ᑳᐦ ᐋᑎ ᔻᔥᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐊᓂᑖᐦ ᒌᒫᓂᓯᒡ ᑳᐦ ᑖᒡ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᑖᑆᐦ ᐋᐅᒄ ᒌᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ᒌ ᑎᔅᑭᒧᐦᐋᒧᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᑫᓀᓯᕃᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᒥᓯᑳᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ᒌ ᓂᔅᑑᓈᑰ ᒫᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐃᔨᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐙᔅᑳ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᐹᔑᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ᐋᒄ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᑳ ᓂᑐᑎᒧᐙᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᐦᐋᔨᒥᑯᒡ ᒥᑯᒋᒃ ᒑ ᒌ ᑖᐦᒋᓂᒸᒡ ᐋ ᐎᓂᔥᒀᑭᓃᔨᒡ ᐅᑎᑯᐦᐱᔨᐤ᙮ ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᑳ ᑖᐦᒋᓂᒥᔨᒡ ᐅᑎᑯᐦᑉ ᒌ ᒦᓂᐙᑎᓰᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ᐋᒄ ᐱᔅᒡ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌᐦ ᐅᐦᑐᐦᑖᐅᒡ ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ, ᑳᐦ ᐄᑖᒡ, ");
INSERT INTO crl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ᑖᓐ ᐋᐦ ᑎᒡ ᐊᓂᒌ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐙᐦᒋ ᐋᑳ ᓂᓂᐦᐄᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐃᔨᐦᑎᐎᓂᔨᐤ ᒋᑖᓂᔅᑖᓂᔅᑰᓰᒥᓅᒡ ᑳᐦ ᐋᔔ ᒥᔨᑎᐦᑯᒡ? ᐙᔥ ᓂᒧᐃ ᑐᑎᒧᒡ ᐐᔨᐙᐤ ᒑ ᒌ ᒋᔥᑖᐹᐅᑖᒡ ᐅᑎᐦᒌᐙᐤ ᐋᔥᒄ ᐋᒸᔮ ᒦᒋᓱᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ᐋᒄ ᒌᓴᔅ ᐋ ᓂᔥᒀᐅᔑᐦᐋᑦ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᐋᐃᐦᑎᔮᒄ ᒫᒃ ᐐ ᒌᔨᐙᐤ ᐙᐦᒋ ᐋᑳ ᓂᓂᐦᐄᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᐎᓲᐙᐎᓐ ᑎᔨᑯᒡ ᐊᓂᐦᐄ ᐃᔨᐦᑎᐎᓐ ᑳ ᒋᔅᑯᑎᒫᑯᐎᔮᒄ ᐋ ᓂᓂᐦᐄᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ᐙᔥ ᒌᐦ ᐃᔨᐤ ᒋᔖᒥᓂᑑ, ‘ᒋᔅᑖᔨᒻ ᑰᐦᑖᐐ ᑭᔮᐦ ᒋᑳᐐ’ ᑭᔮᐦ ᒫᒃ ᒌᐦ ᐃᔨᐤ, ‘ᐊᐙᓐ ᒥᒋᐋᔨᒨᒫᒑ ᐅᐦᑖᐐᐦ ᑭᔮᐦ ᐅᑳᐐᐦ ᐋᑯᔥ ᒋᑭ ᐴᓂᐱᒫᑎᓰᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","ᒥᒄ ᒫᒃ ᒌᔨᐙᐤ ᐃᔨᐦᒡ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᒄ, ᐋ ᐃᔨᔮᒄ, ‘ᐊᐙᓐ ᐋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐅᓃᒋᐦᐄᒄᐦ ᐋ ᓅᐦᑖᐱᔨᐦᒡ ᒑᒀᔨᐤ ᐋᐦᐋᑳ ᒫᒃ ᒥᑐᓐ ᑯᒋᐦᑖᑦ ᒑ ᒌᐦ ᐐᒋᐦᐋᑦ ᑎᔨᑯᒡ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐋ ᐄᔑ ᐱᒋᔅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ,’ ᒋᑎᐄᑖᐙᐤ ᐋᐦᐋᑳ ᐎᓂᐱᔨᑦ ᐊᓂᔮᔨᐤ ᐋᐦᑎᒃ ");
INSERT INTO crl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦᑎᒃ ᓂᒧᐃ ᒋᔥᑖᔨᒫᐤ ᐅᐦᑖᐐᐦ᙮ ᐆ ᒫᒃ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᒄ ᒌᐦ ᑐᑎᐙᐙᐅᒡ ᒑ ᒌ ᓂᐦᐄᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐃᔨᐦᑎᐎᓐ ᑳ ᒋᔅᑯᑎᒧᐙᑯᒡ ᐃᔥᐱᔥ ᐐᔨ ᒋᔖᒥᓂᑑᐦ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᒸᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ ᐋᐅᒄ ᒌᔨᐙᐤ ᑖᑆᐦ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳᐦ ᐋᔨᒨᒥᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ᑳᐦ ᐃᔨᑦ, ᐅᒌ ᐄᔨᔨᐅᒡ ᐅᑑᓂᐙᐦᒡ ᓅᐦᒋ ᒋᔥᑖᒋᒥᑯᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᓂᑎᔮᐱᑖᔨᒥᑯᒡ ᐅᑖᐦᐄᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ᓂᒧᐃ ᐋᐱᑎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᐹᒋ ᐊᔨᒥᐦᐋᔥᑎᐎᒡ ᐙᔥ ᐊᐅᔅᑖ ᐐᔨᐙᐤ ᐅᐐᔓᐙᐎᓂᐙᐤ ᒋᔅᑯᑎᒫᒑᐅᒡ, ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐄᔑ ᐹᒋ ᐱᒋᔅᑎᓂᒥᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᑎᐦᑎᒧᒄ ᑖᓐ ᒑ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᑭᔮᐦ ᒫᒃ ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ᑖᐹ ᓂᒥᔮᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐲᐦᑎᐦᐋᐦᒃ ᐊᐙᓐ ᐅᑑᓂᐦᒡ ᐐᓂᐦᐄᑯᑦ, ᐙᔥ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐹᒋ ᐎᔨᐐᐱᔨᔨᒡ ᐋ ᐊᔨᒥᑦ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐐᓂᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᑳᐦ ᐄᑎᑯᑦ, “ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐋ ᒌ ᒋᔑᐙᐦᐄᑣᐤ ᐊᓂᒌ ᐹᕆᓰᒡ ᐊᓂᔮᔨᐤ ᑳ ᔨᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᓯᐙ ᐋ ᑎᓃᔨᒡ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᐋᐦᐋᑳ ᐐᔨ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᑖᑦ ᒋᑭ ᐱᐦᑯᒋᐱᑖᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ᐋᑯᔥ ᐋᑳ ᐋᔨᒫᔨᒫᐦᑯᒡ ᐊᓂᒌ ᐹᕆᓰᒡ᙮ ᐙᔥ ᒧᔮᒻ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ ᐊᔮᐱᒡ ᒫᒃ ᑳ ᐐᐦ ᒋᔅᒋᓄᐦᑎᐦᐋᒡ ᐊᐙᔨᐤᐦ ᐐᔨᐙᐤ ᑳᔮ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ ᐋᔪᐎᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ᑖᐱᔥᑯᓐ ᒫᒃ ᐋᐦᐋᑳ ᐙᐱᐦᑎᐦᒡ ᐙᐦᑎᓂᔨᐤ ᒑ ᒌᐦ ᐴᐦᒋᐱᔨᒡ ᐊᓂᑖᐦ ᐋ ᐱᑯᓂᔮᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ᐲᑎᕐ ᒫᒃ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᒫᐦ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐆ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᐋᔥᒄ ᓂᒫ ᒋᒌ ᓂᔅᑐᐦᑖᓈᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ? ");
INSERT INTO crl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ᓂᒧᐃ ᐋ ᒋᓂᔅᑐᐦᑖᓈᐙᐤ? ᒥᓯᐙ ᐊᐙᓐ ᑖᓐ ᐋ ᐄᔑ ᐲᐦᑎᐦᐋᐦᒃ ᐅᑑᓂᐦᒡ, ᐅᑖᐦᒡ ᐄᔅᐱᔨᔨᐤ, ᐋᒄ ᒫᒃ ᐋᑎ ᐐᔨᐐᐱᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐹᒋ ᐎᔨᐐᐱᔨᔨᒡ ᐊᐙᓐ ᐅᑑᓂᐦᒡ ᐋ ᐊᔨᒥᑦ, ᐅᑖᐦᐄᐦᒡ ᐅᐦᒋᐱᔨᐤ, ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦᑐᑖᑯᑦ ᐊᐙᓐ ᐋ ᐐᓂᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ᐙᔥ ᒥᑖᐦᐄᐦᒡ ᐅᐦᒋᐱᔨᐤ ᒥᒋᒫᒥᑐᓈᔨᐦᑎᒧᐎᓐ, ᓂᐱᐦᐄᐙᐎᓐ, ᐱᓯᒀᑎᓰᐎᓐ, ᐐᓂᓱᐙᑎᓰᐎᓐ, ᑭᒑᒧᑐᐎᓐ, ᓂᓂᑎᔨᐎᓐ ᑭᔮᐦ ᒫᒃ ᒥᒋᐋᔨᒧᒫᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᐋᐦ ᑐᑖᑯᑦ ᐊᐙᓐ ᐋ ᐐᓂᐦᐄᑯᑦ᙮ ᐋ ᒦᒋᓱᓈᓅᒡ ᐋᐦᐋᑳ ᒋᔥᑖᐹᐅᑖᑭᓂᐎᒡ ᒥᑎᐦᒌ ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᑐᑖᑰ ᐊᐙᓐ ᐋ ᐐᓂᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐊᓂᑖᐦ ᐄᑖᐦᒑ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐙᔅᑳ ᑳᐦ ᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓐ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ᐃᔅᒀᐤ ᒫᒃ ᐊᓂᑎᐦ ᑫᓈᓐ ᐋ ᒌᐦ ᐅᐦᒌᑦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ ᒌᓴᔅ, ᐋ ᑖᑆᔨᒡ ᐋᐦ ᐄᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ ᒫᐦ᙮ ᓂᑖᓂᔥ ᓈᔥᑖᑆᐦ ᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᑰ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᐦᒋᔥᑳᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᐅᐦᒋ ᒋᔅᑐᑖᐤ ᒌᓴᔅ ᐊᓂᔮ ᐃᔅᒀᐤ᙮ ᐋᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᑳᐦ ᐋᔨᐦᑭᒥᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᐄᒑᑎᔑᐦᐆ ᒫᐦ ᐊᓐ ᐃᔅᒀᐤ, ᐱᒋᔅᑳᓯᑖᑯᓯᐤ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᑎᑖᑯᓯᑦ ᐋ ᓅᔔᔥᑳᑎᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᐃᔅᒀᐤ, “ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑭᐎᓐ ᒑ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᒀᐤ ᒥᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᐋ ᐎᓂᔑᐦᒡ ᒫᓂᔥᒑᓂᔑᒡ ᑳ ᐃᓯᓈᑯᓯᒡ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᐃᔅᒀᐤ ᐱᔮᐦᑎᐙᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌᓴᔅᐦ, ᒌ ᐹᒋ ᓃᐱᔅᑰᐱᔨᐦᐆ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ ᐹᒋ ᐐᒋᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, “ᓂᒧᐃ ᑯᐃᔅᒄ ᐃᓯᓈᑯᓐ ᐊᑎᒧᒡ ᒑ ᒌ ᐙᐱᓂᒧᐙᑭᓂᐎᒡ ᐊᐙᔑᔥ ᐅᒦᒋᒥᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ᐋᒄ ᐊᓐ ᐃᔅᒀᐤ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ ᒌ ᑖᑆᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒦᒋᐙᐅᒡ ᐊᑎᒧᒡ ᐅᒋᒫᒧᐙᐤ ᐅᐱᓂᑐᐙᓂᔨᐤ ᐋ ᐱᐦᒋᔥᑎᓃᔨᒡ ᐊᓂᑖᐦ ᔒᐹ ᐅᒦᒋᓲᓈᐦᑎᑯᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐃᔅᒀᐤ, ᑖᑆᐦ ᓲᐦᒋᓰᒥᑭᓐ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ᒋᑭ ᐄᔑ ᑐᑎᒫᑯᓐ ᒫᒃ ᑖᓐ ᐋ ᐄᔑ ᐱᑯᓵᔨᐦᑎᒥᓐ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒦᓂᐙᑎᓰᔨᐤ ᐊᓂᔮᔨᐤ ᐅᑖᓂᔅᐦ ᐊᓐ ᐃᔅᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐋᒄ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ ᑳᐦ ᐋᑎ ᔮᔮᐙᑦ᙮ ᐋᒄ ᑳ ᔖᑭᒋᐙᑦ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳᐦ ᐋᑎ ᐅᐙᔨᐱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐤᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ, ᐋ ᐹᔓᐙᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐋᑳ ᑳ ᒌᐦ ᐋᐦᑎᓂᓱᔨᒡ, ᑭᔮᐦ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮ ᑳ ᒫᔅᒋᓰᔨᒡ, ᑭᔮᐦ ᐋᑳ ᑳ ᓂᐦᑖᐙᔨᒡ, ᑭᔮᐦ ᒥᐦᒑᑐ ᓂᓈᐦᑭᐤ ᑳ ᐄᑖᔅᐱᓈᔨᒡ᙮ ᒌᐦ ᐊᐦᐋᐎᒡ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᒌᓴᔅ ᐅᓯᑎᔨᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᒦᓂᐙᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋ ᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᓂᐦᑖᐙᔨᒡ ᐋ ᐊᔨᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒫᔅᒋᓰᔨᒡ ᐋ ᒥᔪᓈᑯᓰᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᓂᐦᑖᐅᐦᑖᔨᒡ ᐋ ᐱᒧᐦᑖᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᐋ ᐙᐱᐦᑎᒥᔨᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑ ᐃᔅᕋᐄᓪ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᒫᒥᐦᒋᒫᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᑳᐦ ᐄᑖᑦ, “ᓈᔥᒡ ᐋ ᒋᔅᑎᒫᒑᔨᒥᒀᐤ ᐅᒌ ᐄᔨᔨᐅᒡ, ᔖᔥ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᑖᐅᒡ ᐅᑎᐦ ᐋᐦᑖᐅᒡ, ᓂᒧᐃ ᒫᒃ ᔖᔥ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒑ ᒦᒋᒡ᙮ ᓂᒧᐃ ᑭᔮᐦ ᓂᐐ ᒋᐦᒋᑎᔑᐦᐙᐅᒡ ᐋ ᓰᐅᑖᒡ, ᑭᑎ ᐹᐅᓂᐎᒡ ᒦᓐ ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ᐋᒄ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᓂᑖᐦ ᒑ ᐅᐦᑎᓂᒥᐦᒄ ᒦᒋᒻ ᒑ ᒌᐦ ᐊᔑᒥᑰᒡ ᒥᓯᐙ ᐅᒌ ᐄᔨᔨᐅᒡ, ᐅᑖᐦ ᒫᒃ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐋᐦ ᑖᔨᐦᒄ?” ");
INSERT INTO crl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᑎᐦᑐ ᐋᐃᐦᑯᓈᐆᒡ ᐋᔮᐙᑯᒡ?” ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᓃᔣᔥᒡ ᐃᐦᑎᔑᐎᒡ, ᐋᐱᔒᔥ ᒫᒃ ᓂᒫᓯᒡ ᐋ ᐃᔮᐱᔒᔑᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᐙᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐅᐙᔨᐱᐦᐄᓱᔨᒡ ᐊᓂᑎᐦ ᒧᔥᑖᔅᑭᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᓃᔣᔥᒡ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᒫᔅ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ, ᑳ ᐱᐱᐦᒀᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᒫᔅ, ᐋᒄ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒑ ᒌ ᒫᑎᓂᐙᔨᒡ ᐊᓂᑎᐦ ᐋ ᒦᐦᒑᑎᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ᒥᓯᐙ ᑳ ᐃᑎᔑᒡ ᒌ ᒦᒋᓯᐎᒡ ᑭᔮᐦ ᒌ ᑖᐱᔥᑯᔨᐎᒡ᙮ ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᒫᒨᔥᒋᓂᐦᒡ ᐊᓂᔮᔨᐤ ᐃᔅᑯᔥᑖᐎᓂᔨᐤ᙮ ᓃᔣᔥᒡ ᒫᒃ ᐅᑎᐲᐎᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ᐊᓂᒌ ᒫᒃ ᑳ ᐊᔑᒫᑭᓂᐎᒡ ᐎᔮᔥ ᓈᐙᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᑎᔒᒑᓂᒌ ᓈᐹᐅᒡ, ᐋᐦᐋᑳ ᐊᔅᑎᒋᒫᑭᓂᐎᒡ ᐊᐙᔑᔑᒡ ᑭᔮᐦ ᐃᔅᒀᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᐦᒋᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᑳ ᐴᓯᑦ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᒫᑳᑖᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᒑᒃ ᑳ ᒥᓯᑳᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ᐱᔅᒡ ᒫᒃ ᐹᕆᓰᒡ ᑭᔮᐦ ᓵᑎᔫᓰᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐅᒡ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᑯᒀᒋᐦᐋᒡ᙮ ᒌᐦ ᐄᑖᐅᒡ ᒫᒃ ᒑ ᒌ ᐙᐱᐦᑎᔨᑯᒡ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒌᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐄᔥᐱᐦ ᐎᔮᐱᐦᑎᒫᒄ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᒡ ᒋᔑᓈᐙᐤ, ‘ᒋᑭ ᒥᔪ ᒌᔑᑳᐤ, ᐙᔥ ᒥᐦᒀᑖᑯᔔ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ᐋᒄ ᐐᐱᒡ ᐋ ᒑᒋᔖᐹᔮᒡ ᒋᔑᓈᐙᐤ, ‘ᒋᑭ ᒥᒋᒌᓯᑳᐤ, ᐙᔥ ᒥᐦᒀᐙᐱᓐ ᑭᔮᐦ ᐹᒋ ᐅᑳᔥᑖᔮᐤ᙮’ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐋ ᑭᓂᐙᐱᐦᑎᒫᒄ ᒌᔑᒄ ᑖᓐ ᒑ ᐄᔅᐱᔨᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᒌ ᓂᔅᑑᓈᓈᐙᐤ ᐊᓂᐦᐄ ᐙᐱᐦᑏᐙᐎᓐ ᑖᓐ ᐋᔨᔥᐱᔨᐦᒡ ᐊᓅᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ᐊᓅᐦᒡ ᐄᔨᔨᐅᒡ ᓈᔥᑖᑆᐦ ᒥᒑᑎᓯᐎᒡ ᑭᔮᐦ ᓈᔥᒡ ᐱᓯᒀᑎᓯᐎᒡ᙮ ᒥᒄ ᐋ ᐐᐦ ᐙᐱᐦᑎᐦᒡ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ, ᓂᒧᐃ ᒫᒃ ᒋᑭ ᐙᐱᐦᑏᔮᑭᓂᐎᒡ᙮ ᒥᒄ ᐊᓂᔮᔨᐤ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑎᐙᐎᓂᔨᐤ ᑳ ᐄᔥᐲᐦᐄᑯᑦ ᒍᓈ, ᐋᔪᐎᒄ ᒥᒄ ᐊᓂᔮᔨᐤ ᒑ ᐙᐱᐦᑏᔮᑭᓂᐎᒡ᙮” ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑭᑖᑦ ᑳᐦ ᐋᑎ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒫᓯᑳᒡ ᓈᑖᐦ ᐊᑳᒥᐦᒡ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ, ᒌᐦ ᐎᓂᒋᔅᒋᓯᐎᒡ ᒑ ᒌ ᑎᐦᑯᓈᒡ ᐋᐃᐦᑯᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᔮᒀᐦ, ᐃᔮᒀᒦᔅᑎᒸᐦᒄ ᐅᐦᐱᓯᑭᓂᐙᐤ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᓵᑎᔫᓰᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ᒌᐦ ᐋᔨᒸᐅᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ ᐋᐦ ᐃᔨᒡ, “ᐋᐦᐋᑳ ᐅᐦᒋ ᐹᔒᒥᐦᒄ ᐋᐃᐦᑯᓈᐤ ᐋᔪᐎᒄ ᐙᐦᒋ ᐃᔨᑦ ᐅᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᐊᐱᔖᔑᐤ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ᙮ ᒑᒀᓐ ᐙᐦᒋ ᐋᔨᒸᐅᐦᐄᑯᔮᒄ ᐊᓐ ᐋᐦᐋᑳ ᐃᔮᐙᒄ ᐋᐃᐦᑯᓈᐤ? ");
INSERT INTO crl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ᓂᒧᐃ ᐋ ᒋᓂᔅᑐᐦᑖᓈᐙᐤ ᐋᔥᒄ? ᓂᒧᐃ ᐋ ᒋᒋᔥᒋᓯᓈᐙᐤ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᓈᐹᐅᒡ ᑳ ᐊᔑᒥᒀᐤ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐤ ᐅᐦᒋ? ᑖᓐ ᑎᐦᑐ ᒫᒃ ᐅᑎᐲᐎᑦ ᑳ ᓵᑭᔅᒋᓂᑖᔮᒄ ᐊᓐ ᑳ ᐃᔥᐱᔥ ᐄᔅᑯᐱᔨᒡ ᐊᓐ ᒦᒋᒻ? ");
INSERT INTO crl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ᐋᒄ ᑭᔮᐦ ᐊᓐ ᓈᐙᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᓈᐹᐅᒡ ᑳ ᐊᔑᒥᒀᐤ ᓃᔣᔥᒡ ᐋᐃᐦᑯᓈᐤ ᐅᐦᒋ᙮ ᑖᓐ ᑎᐦᑐ ᒫᒃ ᐅᑎᐲᐎᑦ ᑳ ᓵᑭᔅᒋᓂᑖᔮᒄ ᐋᐦ ᐄᔅᑯᐱᔨᒡ ᒦᒋᒻ? ");
INSERT INTO crl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","ᒋᐱᐦ ᓂᔅᑐᐦᑖᓈᐙᐤ ᐋᐦᐋᑳ ᐋᐃᐦᑯᓈᐤ ᐅᐦᒋ ᐋᔨᒨᒥᒃ ᐄᔥᐱᐦ ᑳᐦ ᐄᑎᑯᒡ ᐃᔮᒀᒦᔅᑎᐙᐦᑯᒡ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᓵᑎᔫᓰᒡ ᐅᐦᐱᓯᑭᓂᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ᐋᒄ ᑳ ᐅᐦᒋ ᓂᔅᑐᐦᑎᐦᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐋᐦᐋᑳ ᐅᐦᐱᓯᑭᓂᔨᐤ ᐋᔨᒸᐅᐦᐄᑯᔨᒡ, ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐊᓂᔮ ᐹᕆᓰᐦ ᑭᔮᐦ ᓵᑎᔫᓰᐦ ᐋᐦ ᐋᐎᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᔮᒀᒫᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ᒌᓴᔅ ᒌᐦ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᓭᓯᕇᔮᐦ ᕕᓕᐹᐃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋᐦ ᐄᑖᑦ, “ᐊᐙᔨᐤᐦ ᐃᔮᐙᔨᒫᒡ ᐄᔨᔨᐅᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᐊᓂᔮ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᔑᐤ ᐄᑖᔨᒫᐅᒡ, ᐋᒄ ᑯᑎᑭᒡ ᐊᓂᔮ ᐄᓛᐃᒑ ᐄᑖᔨᒫᐅᒡ, ᐋᒄ ᑯᑎᑭᒡ ᐊᓂᔮ ᒉᕆᒫᔮ ᐋᔨᐅᑯᓐ ᐋᑖᔨᒫᒡ, ᑯᑎᑭᒡ ᒦᓐ ᐄᑖᔨᒫᐅᒡ ᑯᑎᒃ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐦ ᐋᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ᐋᒄ ᒌᓴᔅ ᑳ ᑯᒀᒋᒫᑦ, “ᒌᔨᐙᐤ ᒫᒃ ᐐᐦ, ᐊᐙᓐ ᓃᔨ ᐋ ᑖᔨᒥᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᑦ, “ᐋᐅᒄ ᒌᔨ ᙭, ᐊᓐ ᒋᔖᒥᓂᑑ ᐹᒫᑎᓰᑦ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᐲᑎᕐᐦ, “ᒋᔑᐙᔨᐦᑖᑯᓯᓐ ᓵᐃᒥᓐ, ᒞᓐ ᐅᑯᓯᔅᐦ, ᐙᔥ ᐆ ᑳ ᐄᔑ ᒋᔅᒑᔨᒦᓐ, ᓂᒧᐃ ᐄᔨᔨᐤ ᑰᐦᒋ ᐐᐦᑎᒫᒄ, ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒥᔨᑯᐎᔨᓐ ᐆ ᒑ ᒌᐦ ᐄᔑ ᒋᔅᒑᔨᒦᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ᒋᐐᐦᑎᒫᑎᓐ ᐲᑎᕐ, ᐋᐅᒄ ᒌᔨ ᐋ ᐹᐦᐹᒋᐱᔅᑳᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᐋ ᐹᐦᐹᒋᐱᔅᑳᒡ ᒑ ᐎᔨᑳᐳᐦᑖᔮᓐ ᓂᑎᔨᒥᐦᐋᐅᑭᒥᒄ, ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᓂᐱᐎᓐ ᓲᐦᑳᑎᓰᐎᓐ ᒋᑭ ᐅᐦᒋ ᔑᐦᑯᒋᐦᑖᒑᒥᑭᓐ ᐅᑎᐦ ᓂᑎᔨᒥᐦᐋᐅᑭᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ᒋᑭ ᒥᔨᑎᓐ ᒫᒃ ᒋᐦᒋᒌᔑᒄ ᐅᒋᒫᐎᓂᐦᒡ ᐋᐱᐦᐄᑭᓐ᙮ ᒑᒀᓐ ᒫᒃ ᒑ ᒫᐦᑯᐱᑎᒧᓈ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᒫᐦᑯᐱᑖᑭᓂᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᑭᔮᐦ ᒑᒀᓐ ᒑ ᐱᑯᐦᑖᐅᓈ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᐱᑯᐦᑖᑭᓂᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮” ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᐊᓂᔮ ᐲᑎᕐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ᐋᒄ ᑳᐦ ᐄᑎᔓᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋᑳ ᒑ ᐐᐦᑎᒧᐙᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋᐦᐋᐎᑦ ᐐᔨ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᒌᓴᔅ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳ ᒋᐦᒋ ᐐᐦᑎᒧᐙᑦ ᐋ ᐱᔮᑭᔅᒋᑖᑯᓯᑦ ᐋᐦ ᐄᑖᑦ, “ᓂᑭ ᐄᑐᐦᑖᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᒑ ᒥᔅᑎᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔑᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐎᒡᐦ, ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡᐦ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᓂᐱᐦᐄᑭᐎᔮᓐ, ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᒦᓐ ᒑ ᐎᓂᔥᑳᓄᑭᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ᐋᒄ ᐲᑎᕐ ᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, ᑳ ᒋᔅᑎᐦᐋᒧᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᐋᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐱᒋᔅᑎᓂᒻ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᐄᔅᐱᔨᒡ᙮ ᓂᒧᐃ ᓂᐦᑖ ᒋᐱᐦ ᒌᐦ ᑐᑖᑭᐎᔨᓐ ᐆ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ᐋᒄ ᒌᓴᔅ ᑳ ᒀᔅᒋᑳᐳᔥᑎᐙᑦ ᐊᓂᔮ ᐲᑎᕐᐦ, ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᒥᒋᒥᓂᑑ, ᒫᒌᐦ ᐄᒑᐦᑖᐦ ᓈᑖᐦ᙮ ᓈᔅᑖᐦ ᒋᑭᒑᐱᔅᑰᓐ, ᐊᓐ ᑖᓐ ᐋ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔨᓐ ᒑᒀᓐ ᑖᐹ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ, ᓈᐹᐤ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐊᐙᓐ ᐙᐦ ᓅᔔᔥᑯᐙᒀ ᐋᑯᔥ ᑭᑎ ᐱᒋᔅᑎᓂᒻ ᐐᔨ ᐊᓂᔮᔨᐤ ᐙᐦ ᐄᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᑦ, ᑭᑎ ᐅᑎᓈᐤ ᐅᑖᔑᑖᔮᐦᑎᑯᒻ ᐋᒄ ᒫᒃ ᒑ ᐹᒋ ᓅᔔᔥᑳᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ᐊᐙᓐ ᑳ ᐐᐦ ᑭᓄᐙᔨᐦᑎᒫᓱᑦ ᐅᐱᒫᑎᓰᐎᓐ ᑭᑎ ᐎᓂᐦᑖᐤ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐐᐦ ᐱᒋᔅᑎᓂᐦᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᐦᒃ ᒫᒋᒫ ᑭᔮᐦ ᐅᐱᒫᑎᓰᐎᓐ ᐋ ᐐᐦ ᐹᒋ ᓅᔔᔥᑯᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᒥᔅᑳᐦᒃ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ᒑᒀᓐ ᒑ ᐃᓯᓈᑯᓃᔨᒡ ᐊᐙᓐ ᐋᑎ ᒌᐦ ᐃᔮᒑ ᒥᓯᐙ ᒑᒀᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᐎᓂᐦᑖᒑ ᐅᐱᒫᑎᓰᐎᓐ᙮ ᓂᒧᐃ ᒥᑐᓐ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒄ ᑳᐤ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᐅᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒋᑭ ᑎᑯᔑᓐ ᐅᐦᑖᐐᒫᐤ ᐅᒥᔅᑎᒋᔅᑖᔨᐦᑖᑯᓱᐎᓃᔨᐦᒡ ᑭᔮᐦ ᐋᓐᒋᓐ ᐋ ᐹᒋ ᐐᒑᐅᑯᑦ, ᐋᒄ ᒫᒃ ᒑ ᑎᐱᐦᐊᒧᐙᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓃᐴᐎᒡ ᐅᑎᐦ ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᐋᔥᒄ ᒑ ᐋᐦᐋᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᑎᑯᔑᓃᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᐹᒋ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ᑯᑣᔥᒡ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐲᑎᕐ, ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ, ᒉᒥᔅ ᐐᒌᔨᔨᐤ ᐊᓂᑖᐦ ᐋ ᐃᔥᐱᑎᓈᔨᒡ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᒥᒄ ᐐᔨᐙᐤ ᒑ ᒌᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ᒫᒀᒡ ᒫᒃ ᐋ ᑭᓂᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐅᑖᔥᑎᒥᐦᑯᔨᐤ ᒌᐦ ᒀᔅᒋᓈᑯᓂᔨᐤ, ᒧᔮᒻ ᐲᓯᒧᐦᒡ ᒌᐦ ᐃᔥᐱᔥ ᒌᐦᑳᔮᔥᑖᔨᐤ ᑭᔮᐦ ᐅᒑᒀᓂᒻ ᓈᔥᑖᑆᐦ ᒌ ᐱᔮᑭᔅᒡ ᐙᐹᑭᓂᔨᐤ ᒥᑐᓐ ᐋ ᐙᔥᑖᔨᒡ ᒌᐦ ᐃᓯᓈᑯᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ᒌᐦ ᐅᐦᒋ ᐙᐱᒫᐅᒡ ᒫᒃ ᒧᓱᔅ ᑭᔮᐦ ᐄᓛᐃᒑ ᐋ ᐊᔨᒥᐦᐋᔨᒡ ᐊᓂᔮ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓄᐎᒡ ᒥᔻᔨᐦᑖᑯᓐ ᐅᑎᐦ ᒑ ᒌᐦ ᑖᐆᐦᑯᐱᓈ᙮ ᓂᐦᐋᔨᐦᑎᒫᓈ, ᓂᑭ ᐅᔑᐦᑖᓈᓐ ᓂᔥᑐ ᑎᐱᓅᔑᒧᓐᐦ, ᐹᐦᐹᔨᒄ ᒑ ᐃᔮᔮᒄ, ᒌᔨ, ᒧᓱᔅ ᑭᔮᐦ ᐄᓛᐃᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ᒫᒀᒡ ᒫᒃ ᐋᔥᒄ ᐋ ᐊᔨᒥᑦ, ᑭᔥᑭᐎᓂᔥᒄ ᓈᔥᒡ ᐋ ᐙᓯᓱᔨᒡ ᒌ ᐹᒋ ᐊᑯᒋᓂᔨᐤ ᐊᓂᑎᐦ ᑎᐱᔅᑯᒡ ᐃᔥᐱᒥᐦᒡ ᐋᐦ ᑖᒡ, ᐊᓂᑖᐦ ᒫᒃ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ ᒌᐦ ᐅᐦᒋ ᐹᐦᑎᐙᐅᒡ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᔨᔨᒡ, “ᐋᐅᒄ ᐆ ᓂᑯᔅ ᑳ ᓵᒋᐦᐄᒃ, ᑭᔮᐦ ᓈᔥᒡ ᑳ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᑦ᙮ ᓂᑐᐦᑎᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐱᔮᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐹᐦᑖᑯᓯᐎᓂᔨᐤ, ᒌ ᐱᐦᒋᓯᓂᐦᒡ ᐋ ᐅᑎᐦᑖᒨᓂᐱᔨᐦᒡ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᑳ ᐃᔥᐱᔥ ᓵᒋᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ᐋᒄ ᒌᓴᔅᐦ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᒡ, ᐋᒄ ᑳ ᑖᐦᒋᓂᑯᒡ ᐋᐦ ᐄᑎᑯᒡ, “ᐱᓯᑰᒄ, ᐊᑳᐐ ᑯᔥᑖᒋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᑖᐲᒡ ᒫᒃ ᓂᒧᐃ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᐙᐱᒫᐅᒡ ᒥᒄ ᒌᓴᔅᐦ ᒌ ᐹᔨᑯᑳᐳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ᒫᒀᒡ ᒫᒃ ᐋ ᓃᐦᑎᒋᐙᒡ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ, ᒌᓴᔅᐦ ᒌᐦ ᐄᑎᑯᒡ ᔮᔨᑖ ᒑᐦ ᐋᑳ ᐐᐦᑎᒧᐙᒡ ᐊᐙᔨᐤᐦ ᐅᔮᔨᐤ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᑳ ᐙᐱᐦᑎᐦᒡ ᐹᑎᔥ ᒌᐦ ᐎᓂᔥᑳᓈᑭᓂᐎᔨᒑ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᑯᒀᒋᒫᒡ ᐊᓂᔮ ᒌᓴᔅᐦ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐃᔨᒡ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ, ᓃᔥᑎᒻ ᐄᓛᐃᒑᐦ ᒑ ᑎᑯᔑᓃᔨᒡ ᐋᔥᒄ ᐋᒸᔮ ᑎᑯᔑᓃᔨᒡ ᙭ᐦ, ᐊᓐ ᑳ ᐅᐙᔮᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᐄᓛᐃᒑ ᓃᔥᑎᒻ ᒋᑭ ᑎᑯᔑᓐ, ᒥᓯᐙ ᒑᒀᔨᐤ ᐋᐦᐋᑳ ᑯᐃᔅᑯᓈᑯᓃᔨᒡ ᒑ ᑯᐃᔅᑯᓈᑯᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᔖᔥ ᐋ ᒌ ᑎᑯᔑᐦᒃ ᐄᓛᐃᒑ ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑑᓈᑰ ᐄᔨᔨᐤ᙮ ᒥᒄ ᒫᒃ ᐙᐦ ᑐᑎᐙᒡ ᒌᐦ ᑐᑎᐙᐅᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᒑ ᐃᔥᐱᔥ ᐐᓯᒑᔨᐦᑎᒥᐦᐋᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᐦᑎᐦᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐅᔮᔨᐤ, ᐋᒄ ᑳ ᓂᔅᑑᐦᑎᐦᒡ ᐋᐦ ᐋᐎᔨᒡ ᐊᓂᔮ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᐤ ᑳᐦ ᐋᔨᒨᒫᑭᓂᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ᐄᔥᐱᐦ ᒫᒃ ᑳᐤ ᐙᑎᐦᑖᒡ ᐊᓂᔮ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᓈᐹᐤ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐤ ᐊᓂᔮ ᒌᓴᔅᐦ, ᐋ ᓂᐱᔅᑯᐱᐦᐅᑦ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒋᔅᑎᒫᒑᔨᒻ ᓂᑯᔅ᙮ ᐅᒋᐱᑎᑰ ᒫᓐ, ᓈᔥᑖᑆᐦ ᓂᓈᐦᑳᑖᔨᒨ ᐙᔥ ᒥᐦᒑᑣᐤ ᒫᓐ ᒧᒋᔥᑖᐱᔨᐤ ᐃᔥᑯᑖᐦᒡ ᑭᔮᐦ ᒥᐦᒑᑣᐤ ᐱᑭᔥᑎᐙᐱᔨᐤ ᓂᐲᐦᒡ ᒫᒀᒡ ᐊᓂᔮᔨᐤ ᐋ ᐅᒋᐱᑎᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ᐋᑦ ᒫᒃ ᓂᒌᐦ ᐄᑐᐦᑎᐙᐅᒡ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ, ᓂᒧᐃ ᐅᐦᒌ ᒦᓂᐙᒋᐦᐋᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᒌᔨᐙᐤ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔮᒄ ᐋᑳ ᑳ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓂᔮᒄ ᑭᔮᐦ ᐋᑳ ᑳ ᒀᔅᑳᑎᓰᔮᒄ, ᑖᓐ ᒑ ᐃᔥᐱᔒ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐃᔮᒄ ᒑ ᒌ ᓂᔅᑐᐦᑎᒫᒄ? ᑖᓐ ᒑ ᐃᔥᐱᔥ ᐊᔑᓂᐙᐦᐄᑎᑯᒡ ᐃᔮᒄ ᒑ ᒌᐦ ᐃᔮᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ? ᐹᔓᐙᐦᒄ ᐊᓐ ᓈᐹᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑎᔓᒫᐤ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐋᐦ ᐄᑖᑦ ᒑ ᒌ ᓂᑭᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᔥ᙮ ᑏᐙᐦᒡ ᒫᒃ ᒌᐦ ᐎᔨᐐᐤ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ, ᐋᒄ ᑳᐦ ᐋᑎ ᒦᓂᐙᑎᓰᑦ ᐊᓐ ᓈᐹᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ᐋᒄ ᐊᓂᔮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ ᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑎᐦᐄᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᓂᑖᐦ ᐙᐦᒋ ᐋᑳ ᐅᐦᒌ ᐎᔨᐐᑎᔑᐦᐆᒋᐦᑦ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ?” ");
INSERT INTO crl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑭᔨᑆ ᐊᓐ ᐋᐦᐋᑳ ᐃᔥᐱᔖᒡ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ᙮ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐋᑦ ᒥᒄ ᐊᐱᔖᔑᒑ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒧᔮᒻ ᐋ ᐃᔥᐱᔥ ᐊᐱᔒᔑᑦ ᔒᒥᓐ ᑳ ᓂᑖᐆᒌᐦᒑᒥᑭᐦᒡ ᒫᔅᑎᕐᑦ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᒋᑭ ᒌᐦ ᐄᑎᔓᐙᑖᓐ ᐋᐱᔅᑯᑎᓈᐦᒡ, ‘ᓈᑖᐦ ᐄᔑ ᐋᐦᒋᑳᐳ᙮’ ᒋᑭ ᐱᔑᒋᐦᐄᑯᓐ ᒫᒃ᙮ ᒋᑭ ᒌᐦ ᑐᑖᓐ ᒑᒀᓐ ᐙᐦᑑᑎᒥᓐ ᐃᔮᔨᓈ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ᑭᔮᐦ ᒫᒃ, ᒥᒄ ᐊᔨᒥᐦᐋᒑ ᑭᔮᐦ ᐋᑳ ᒦᒋᓲᒑ ᐊᐙᓐ ᐋᑯᑖᐦ ᒥᒄ ᒑ ᒌᐦ ᐐᐎᔨᒡ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᓂᒧᐃ ᒦᓐ ᑎᑯᓂᔨᐤ ᑖᓐ ᒑ ᒌᐦ ᑎᒃ ᐊᐙᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐹᒋ ᓂᔥᑐᐐᒡ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ, ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᔖᔥ ᐐᐱᒡ ᒋᑭ ᒫᒥᔑᒫᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᒌ ᐱᒋᔅᑎᓈᑭᓄᐎᒡ ᐄᔨᔨᐅᒡ ᑖᓐ ᐙᐦ ᑐᑎᐙᒡ ᒑ ᒌᐦ ᑐᑎᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ᒋᑭ ᓂᐱᐦᐋᑭᓂᐤ, ᒥᒄ ᒫᒃ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᐋᒄ ᒑ ᐎᓂᔥᑳᓈᑭᓅᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮” ᓈᔥᒡ ᒫᒃ ᒌ ᒥᒑᔨᐦᑎᒧᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐄᔥᐱᐦ ᐱᔮᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ᐄᔥᐱᐦ ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ ᑭᐱᕐᓃᔨᒥᐦᒡ, ᐊᓂᒌ ᑳ ᓂᔅᑐᓈᒡ ᔓᐎᔮᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᐄᔑ ᐋᐱᑎᓰᔨᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐅᒡ ᐊᓂᔮ ᐲᑎᕐᐦ ᐋᐦ ᐄᑖᒡ, “ᒋᑭ ᑎᐱᐦᐄᒑᐙ ᒋᒋᔅᑯᑎᒫᒑᓰᒧᐙᐤ ᐊᓂᔮ ᔓᐎᔮᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᐄᔑ ᐋᐱᑎᓰᑯᐱᓈᓂᐦᐄ?” ");
INSERT INTO crl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ᙮” ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᐋᐦ ᐋᑎ ᐲᐦᒑᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᐋᔥᒄ ᐋᒸᔮ ᒌᐦ ᐄᑖᑦ ᒑᒀᔨᐤ, ᒌᓴᔅᐦ ᒌᐦ ᑯᒀᒋᒥᑰ ᐋᐦ ᐄᑎᑯᑦ, “ᓵᐃᒥᓐ, ᑖᓐ ᐋᑖᔨᐦᑎᒥᓐ ᒌᔨ? ᐊᐙᓐ ᒋᐱᐦ ᒥᔮᐤ ᔓᐎᔮᓐ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ? ᐅᑎᐙᔑᔒᒻ ᐋᐦ ᑖᔨᒡ ᒋᐱᐦ ᐅᐦᒋᐱᔨᔨᐤ ᔓᐎᔮᓐ ᑭᔮᐦ ᒫᒃ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐊᓂᔮᔨᐤ ᑭᔨᑆ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᒋᐱᐦ ᐅᐦᒋᐱᔨᔨᐤ᙮” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᒌᓴᔅᐦ, “ᑭᔨᑆ ᒦᔥᑯᒡ ᐅᑎᐙᔑᔒᒻ ᐊᑑᒡ ᐱᒋᔅᑎᓂᔨᐤ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐐᐦ ᒋᔑᐙᐦᐋᓅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᓈᓯᐹᐦ ᒫᒃ ᓈᑖᐦ ᒑ ᐱᑭᔥᑎᐙᐦᐊᒥᓐ ᐅᒋᒀᒋᑭᓐ᙮ ᐊᓐ ᒫᒃ ᓃᔥᑎᒻ ᓂᒫᔅ ᒑ ᐅᒋᒀᑎᑦ ᒑ ᐅᑎᓂᑦ, ᐊᓂᑖᐦ ᒫᒃ ᐅᑑᓂᐦᒡ ᒋᑭ ᒥᔅᑳᒫᔨᐤ ᔔᐎᔮᓈᐱᔅᒄ, ᒋᑭ ᐃᔥᑎᑎᐤ ᐊᓂᑎᐦ ᑖᐱᔥᑯᓐ ᐋ ᓃᔒᐦᒄ ᒑ ᐃᔥᐱᔥ ᐱᒋᔅᑎᓈᐅᐦᑯᐱᓈ ᔓᐎᔮᓐ᙮ ᒑ ᐄᑐᐦᑎᐦᐄᑦ ᓈᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᐱᒋᔅᑎᓂᑦ ᐊᓐ ᒑ ᐃᔥᐱᔥ ᐱᒋᔅᑎᓂᒑᐅᐦᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ᐋᑯᑦ ᒫᒃ ᐊᓂᑎᐦ ᓂᐦᐋᐤ ᒌᓴᔅ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᑳ ᑯᒀᒋᒥᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᐊᐙᓐ ᒫᐅᒡ ᓈᑳᓈᔨᐦᑖᑯᓯᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ ᐊᐙᔑᔥ, ᑳ ᐅᐦᑎᔅᑯᑳᐳᐦᐋᑦ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒥᔔ ᐋᑳ ᒀᔅᑳᑎᓯᔮᒀ ᑭᔮᐦ ᐋᑳ ᐄᑖᔨᐦᑖᑯᓯᔮᒀ ᒧᔮᒻ ᐊᐙᔑᔥ ᐋ ᑖᔨᐦᑖᑯᓯᑦ, ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᒋᐲᐦᒑᓈᐙᐤ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ᐊᓐ ᐊᐙᓐ ᒑ ᑎᐱᐦᑖᔨᒦᓱᒀ ᒧᔮᒻ ᐅᔮᔨᐤ ᐊᐙᔑᔥ ᐋ ᐄᑖᔨᐦᑖᑯᓰᒡ ᐋᐅᒄ ᐊᓐ ᒫᐅᒡ ᒑ ᓃᑳᓈᔨᐦᑖᑯᔑᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ᐊᐙᓐ ᐋ ᐅᑎᓈᑦ ᐹᔨᒄ ᐅᔮᔨᐤ ᐊᐙᔥᐦ ᐋ ᐄᑖᔨᐦᑖᑯᓰᒡ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ, ᑭᔮᐦ ᓃᔨ ᐋ ᐅᑎᓂᑦ ᐋᑯᑖᐦ ᐋ ᐃᓯᓈᑯᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“ᐊᓐ ᐊᐙᓐ ᒑ ᑐᑎᐙᒀ ᒑ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ ᐹᔨᒄ ᐅᔮᔨᐤ ᐊᐙᔑᔥ ᑳ ᑖᑆᔮᔨᒥᔨᒡ ᐊᐅᔅᑖ ᑭᑎ ᒥᔻᔑᔨᐤ ᒑ ᒌ ᒫᐦᑯᐱᑎᒫᑭᓂᐎᔨᒡ ᐋ ᒥᐦᒑᐱᔅᒋᔨᒡ ᐊᓯᓃ ᐅᑯᔮᐦᒡ ᐋᒄ ᒫᒃ ᒑ ᒌ ᓂᔅᑖᐹᐙᑦ ᐊᓂᑖᐦ ᐋ ᒌᔥᑳᔨᐙᔨᒡ ᒋᐦᒋᑭᒦᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᒥᒋᐦᑑᑎᐦᒡ ᐄᔨᔨᐅᒡ᙮ ᒨᔥ ᑭᑎ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒑ ᑯᒀᒋᐦᐄᑯᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒥᒋᐦᑑᑎᐦᒡ, ᒥᒄ ᒫᒃ ᑭᑎ ᐅᔅᑖᐱᔨᐆᒡ ᐊᓂᒌ ᐋᐦ ᑐᑎᐙᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“ᐄᐦᑐᑖᑯᔨᓈ ᐹᔨᒄ ᒋᑎᐦᒌ ᑭᔮᐦ ᒫᒃ ᒋᓯᑦ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᒥᓂᔕᐦ, ᒑ ᐙᐱᓂᒥᓐ᙮ ᐊᐅᔅᑖ ᒥᔻᔑᐤ ᒑ ᒌ ᐲᐦᒑᔨᓐ ᐱᒫᑎᓰᐎᓂᐦᒡ ᐋ ᒫᔅᒋᐱᔨᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᒫᔅᒋᓯᔨᓐ ᐃᔥᐱᔥ ᐐ ᒑ ᒌᐦ ᐃᔮᔨᓐ ᓃᔓ ᒥᑎᐦᒌ ᑭᔮᐦ ᓃᔓ ᒥᓯᑦ ᒑ ᐄᔑ ᐙᐱᓂᑭᐎᔨᓐ ᒫᒃ ᐊᓂᑖᐦ ᐊᓐ ᒥᒋᔥᑯᑖᐤ ᐋᑳ ᓂᐦᑖ ᒑ ᒌᐦ ᐋᔅᑐᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ᑭᔮᐦ ᒫᒃ ᐄᐦᑐᑖᑯᔨᓈ ᐹᔨᒄ ᒋᔅᒌᔑᒄ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᑯᐃᑯᐱᑦ, ᒑ ᐙᐱᓂᒥᓐ ᐊᓐ ᒋᔅᒌᔑᒄ᙮ ᐊᐅᔅᑖ ᒥᔻᔑᐤ ᒑ ᒌ ᐲᐦᒑᔨᓐ ᐱᒫᑎᓰᐎᓂᐦᒡ ᐋ ᓂᐱᑖᔮᐱᔨᓐ, ᐃᔥᐱᔥ ᐐ ᑖᐱᔥᑯᓐ ᒋᔅᒌᔑᒄ ᒑ ᒌᐦ ᐃᔮᔨᓐ ᒥᒋᔥᑯᑖᐦᒡ ᐋ ᐄᔑ ᐙᐱᓂᑭᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ᔮᒀᒦᒄ ᒫᒃ ᐋᑳ ᒑ ᒌᐦ ᐋᑎᐙᔨᒫᑯᒡ ᐅᒌ ᐊᐱᔅᑎᐙᔑᒡ, ᐙᔥ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐅᑖᓐᒋᓂᒧᐙᐤᐦ ᒨᔥ ᐋᔨᒥᔥᑎᒫᑯᒡ ᐋ ᐅᐦᑎᔅᑯᑳᐳᔥᑎᐙᔨᒡ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ᐹᒋ ᓈᓂᑎᐙᐱᒫᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐎᓂᔑᓃᔨᒡ ᒑ ᒌ ᐱᒫᒋᐦᐋᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ᒫᒥᑐᓈᔨᐦᑎᒧᒄ ᒫᐦ ᐆ, ᓈᐹᐤ ᐋᐦ ᑎᐲᐙᐆᓰᑦ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒫᓂᔥᒑᓂᔥ ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐎᓂᔑᓃᔨᒡ᙮ ᒋᑭ ᓂᑭᑖᐤ ᐊᓂᔮᔨᐤ ᐹᔨᑯᔥᑖᒥᑎᓂᐤ ᐹᔨᑯᔥᑖᐅᔖᑉ ᐊᓂᑎᐦ ᐋ ᐱᔅᑯᑖᐅᐦᑳᔨᒡ ᒑ ᓂᑑ ᓈᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᑳ ᐎᓂᔑᓃᔨᒡ ᒫᓂᔥᒑᓂᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ᐄᔥᐱᐦ ᒫᒃ ᒫᔅᑭᐙᑦ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐅᔅᑖ ᒥᔻᔨᐦᑎᒻ ᐅᔮᔨᐤ ᐹᔨᒄ ᐅᒫᓂᔥᒑᓂᔒᒻ ᑳ ᐎᓂᔑᓃᔨᒡ ᐋ ᒥᔅᑯᐙᑦ ᐃᔥᐱᔥ ᐐ ᐋ ᒌᐦ ᑎᐲᐙᐆᓰᑦ ᐊᓂᔮᔨᐤ ᐹᔨᑯᔥᑖᒥᑎᓂᐤ ᐹᔨᑯᔥᑖᐅᔖᑉ ᒫᓂᔥᒑᓂᔥ ᐋᑳ ᐙᐦᒋ ᐎᓂᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᑭᔮᐦ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᐋᐦᑎᒃ, ᓂᒧᐃ ᓂᑎᐙᔨᒫᐤ ᐙᒋᐹᔮᒄ ᐅᔮᔨᐤ ᐊᐱᔅᑎᐙᔥ ᒑ ᒌᐦ ᐎᓂᔑᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ᐎᓂᑐᑖᔅᑳ ᒌᒋᔖᓐ, ᓂᑎᐙᐱᒻ ᒑ ᐐᐦᑎᒨᑦ ᑖᓐ ᐋ ᐄᔑ ᐎᓂᑐᑖᔅᒃ, ᒥᒄ ᒌᔨᐙᐤ ᐋ ᓃᔑᔮᒄ ᒑ ᐐᐦᑎᒨᑦ ᐅᔮᔨᐤ᙮ ᓂᑐᐦᑖᔅᑳ ᒫᒃ, ᐋᒄ ᑭᔨᑆ ᒦᓐ ᒑ ᒥᔪᐱᔮᒄ ᐋ ᐐᒋᔖᓂᐦᑐᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ᐋᑳ ᒫᒃ ᓂᑐᐦᑖᔅᑳ ᐋᒄ ᒦᓐ ᑯᑎᒃ ᐊᐙᓐ ᑭᔮᐦ ᒫᒃ ᓃᔓ ᐄᔨᔨᐅᒡ ᒑ ᐐᔖᒥᑣᐤ ᒑ ᒌᐦ ᐐᒑᐅᔅᒡ ᒑ ᒌ ᐹᐦᑖᑖᑯᒡ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᔑ ᐊᔨᒥᐦᐄᑑᔮᒄ᙮ ᐙᔥ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳᐦ ᐃᔨᒡ ᐊᓂᒌ ᓃᔓ ᑭᔮᐦ ᒫᒃ ᓂᔥᑐ ᑳ ᓂᑐᒫᑭᓂᐎᒡ ᒑ ᒌ ᑖᑆᐎᐦᑖᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐹᐦᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ᐋᑳ ᒫᒃ ᐱᔑᒋᑖᔅᑳ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋᑳ ᐱᔑᒋᐦᐋᒑ, ᐋᒄ ᒑ ᐐᐦᑎᒫᒥᑦ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑐᑖᔅᒃ᙮ ᐋᑳ ᒫᒃ ᐱᔑᒋᐦᐋᒑ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᑭᓂᐤ, ᒧᔮᒻ ᐊᐙᓐ ᐋᑳ ᑳ ᒋᔅᒑᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᒑ ᐄᔑ ᑭᓂᐙᐱᒫᑭᓅᑦ᙮ ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᑳ ᐐ ᒀᔅᑳᑎᓰᑦ ᐋᔪᐎᒄ ᒑ ᐄᔑ ᑭᓂᐙᐱᒫᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ᐙᔥ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᒑᒀᓐ ᒑ ᒫᐦᑯᐱᑎᒧᓈ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᒫᐦᑯᐱᑖᑭᓂᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᑭᔮᐦ ᐊᓐ ᒑᒀᓐ ᒑ ᐱᑯᐦᑖᐅᓈ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᐱᑯᐦᑖᑭᓂᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“ᑭᔮᐦ ᒫᒃ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓃᔓ ᐄᔨᔨᐅᒡ ᑖᐱᔥᑯᓐ ᐋ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᒑᒀᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᓂᑑᑎᒫᒡ ᐋᔪᐎᒄ ᓂᐦᐋᐤ ᒑ ᐄᔑ ᑐᑎᒫᑯᒡ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ᐙᔥ ᐋᑦ ᒥᒄ ᓃᔓ ᑭᔮᐦ ᒫᒃ ᓂᔥᑐ ᐄᔨᔨᐅᒡ ᐋ ᒫᐅᒋᐦᐄᑐᒡ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ, ᐋᑯᑖᐦ ᑭᔮᐦ ᓃᔨ ᐋᐦᑖᐅᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ᐋᒄ ᐲᑎᕐ ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᑦ ᒌᓴᔅᐦ, ᑳᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓃᒋᔖᓐ ᒫᒃ ᐐᐦ ᐋᑳ ᐴᓃᒑ ᐋ ᐹᒋ ᐎᓂᑐᑎᐎᑦ, ᑖᓐ ᑎᐦᑣᐤ ᒑ ᐙᐹᔨᐦᑎᒨᒃ, ᓃᔣᔥᒡ ᐋ ᑎᐦᑣᐤ?” ");
INSERT INTO crl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᒫᐦ, ᓂᒧᐃ ᒥᒄ ᓃᔣᔥᒡ ᑎᐦᑣᐤ ᒋᐱᐦ ᐙᐹᔨᐦᑎᒧᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐎᓂᑐᑖᔅᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","ᐙᔥ ᒫᐤ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒧᔮᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋ ᒌ ᓂᑎᐙᔨᒫᑦ ᐅᑖᐱᒋᐦᐋᑭᓐ ᑳᐦ ᐋᐅᐦᐋᓱᒥᑯᑦ ᒑ ᒌ ᐲᑯᔑᓂᐦᐄᒑᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐐᐦ ᑐᑎᐦᒃ ᒥᓯᐙ ᒌ ᓂᑑᒫᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐅᐦᐋᓱᒥᑯᑦ ᐅᑖᐱᒋᐦᐋᑭᓐ᙮ ᐋᒄ ᑳ ᐹᔑᒫᑭᓂᐎᔨᒡ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐊᐅᔅᑖ ᒥᑖᐦᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᐃᔥᐱᔥ ᐊᐅᐦᐋᓱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᑖᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᐅᐦᒋ ᐃᔥᐱᔥ ᐃᔮᐙᔨᐤ ᔓᐎᔮᓐ ᒑ ᒌ ᒌᐙᑎᐱᐦᐊᒫᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᐊᐅᐦᐋᓱᒥᑯᑦ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᒑ ᒌᐦ ᐋᑖᐙᒑᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᑭᔮᐦ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᑭᔮᐦ ᐅᑎᐙᔑᔒᒥᔨᐤᐦ ᑭᔮᐦ ᐐᐎᔨᐤᐦ ᒑ ᒌ ᒋᐙᑎᐱᐦᐊᒫᐙᑭᓅᑦ ᒫᒃ ᐊᓂᑎᐦ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᔨᒡ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, ‘ᐊᑳᐐ ᐱᑎᒫ ᐹᒋ ᒋᔑᐙᓰᔅᑑ ᐊᔑᓂᐙᐦᐄ ᒫᐦ ᒦᓐ ᐙᐃᐱᔥᒌᔥ, ᐋᒄ ᒥᓯᐙ ᒑ ᒌᐦᐙᑎᐱᐦᐊᒫᑖᓐ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᐋᐅᐦᐋᓱᒥᑖᓐ ᒑᒀᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᑭᔮᐦ ᒌᐦ ᐄᑖᐤ ᐋᑯᔥ ᒑ ᐋᑳ ᒌᐙᑎᐱᐦᐊᒫᑯᑦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐊᐅᐦᐋᓲᒥᑯᑦ, ᐋᒄ ᒫᒃ ᑳ ᐱᒋᔅᑎᓈᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ᐋᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᒋᔅᑐᐦᑖᑦ, ᑳ ᓂᒋᐦᐋᑦ ᐐᒋᐋᐱᒋᐦᐋᑭᓐ ᐋ ᒌᐦ ᐊᐅᐦᐋᓱᒥᑯᑦ ᐊᐱᔒᔥ ᔓᐎᔮᓐ᙮ ᐋᒄ ᑳ ᐅᑎᓈᑦ ᐋ ᐐᐦ ᒋᐳᑖᒧᓈᑦ ᐋᐦ ᐄᑖᑦ, ‘ᒫᒌᐦ ᐹᒋ ᒌᐙᒥᔨ ᐊᓐ ᔓᐎᔮᓐ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐋᐅᐦᐋᓲᒥᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ᐋᒄ ᐊᓂᔮᔨᐤ ᐐᒋᐋᐱᒋᐦᐋᑭᓐ ᒌᐦ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᔨᐤ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᑦ, ᐋᐦ ᐄᑎᑯᑦ, ‘ᐊᑳᐐ ᐱᑎᒫ ᐹᒋ ᒋᔑᐙᓰᔅᑑ ᐊᔑᓂᐙᐦᐄ ᒫᐦ ᒦᓐ ᐙᐃᐱᔥᒌᔥ ᒑ ᒌ ᒌᐙᒥᔨᑖᓐ ᐊᓐ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐋᐅᐦᐋᓲᒥᑖᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᓂᑐᐦᑎᐙᐤ ᐊᓂᔮᔨᐤ ᐐᒋᐋᐱᒋᐦᐋᑭᓐ, ᐋᒄ ᑳ ᐄᑎᔓᐙᑖᑦ ᒑ ᒌ ᒋᐴᐦᐆᒫᑭᓂᐎᔨᒡ ᐹᑎᔥ ᒌ ᑎᐱᐦᐋᒫᑯᒑ ᑖᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᐊᐅᐦᐋᓱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑯᑎᑭᒡ ᐋᐱᒋᐦᐋᑭᓂᒡ ᐎᔮᐱᐦᑎᐦᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔅᐱᔨᒡ, ᓈᔥᒡ ᒌ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐋᒄ ᑳ ᓂᑑᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ, ᑳᐦ ᐄᑖᑦ, ‘ᒌᔨ ᐋᐱᒋᐦᐋᑭᓐ ᑖᑆᐦ ᒌ ᒥᒌᐦᑐᑖᓐ, ᓂᒧᐃ ᒥᑐᓐ ᑯᐦᒋ ᒌᐙ ᓂᑎᐙᔨᐦᑎᒫᑎᓐ, ᐙᔥ ᒌᔨ ᒋᒌ ᐱᑯᓵᔨᒥᓐ ᒑ ᒌ ᒋᔅᑎᒫᒑᔨᒥᑖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ᓂᒧᐃ ᐋ ᒫᒃ ᒋᐱᐦ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᒌᔨ ᐊᓐ ᒌᒡ ᐋᐱᒋᐦᐋᑭᓐ ᒧᔮᒻ ᓃᔨ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑎᒫᒑᔨᒥᑖᓐ᙮’ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ᓈᔥᒡ ᒫᒃ ᒌ ᒋᔑᐙᔔ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ ᐊᓂᑖᐦ ᒑ ᒌ ᓂᓈᐦᑳᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐹᑎᔥ ᒥᓯᐙ ᒌ ᒌᐙ ᑎᐱᐦᐋᒫᑯᒑ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐊᐅᐦᐋᓱᒥᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐃᔨᑦ, “ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᒑ ᑐᑖᑖᒄ ᓅᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ, ᐋᑳ ᐙᐹᔨᐦᑎᒧᐙᑰᒑ ᒌᒋᔖᓂᐙᐅᒡ ᒋᑖᐦᐄᐙᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᒌᔥ ᐐᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒌ ᒋᔅᑐᐦᑖᐤ ᐊᓂᑎᐦ ᑳᓕᓖᐦᒡ ᐅᐦᒋ, ᐋᒄ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳ ᐄᑐᐦᑖᑦ ᐊᑳᒥᐦᒡ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᒞᕐᑎᓐ ᓰᐲᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐄᔨᔨᐤ ᐋ ᓅᔔᔥᑳᑯᑦ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᒦᓂᐙᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ᐱᔅᒡ ᒫᒃ ᐹᕆᓰᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐋ ᐐᐦ ᑯᒀᒋᐦᐄᑯᑦ᙮ ᒌᐦ ᐄᑎᑰ ᒫᒃ, “ᐐᐦᑎᒨᓈᓐ ᒫᐦ, ᐋᐤ ᐋ ᐋᑎᔅᑖᒡ ᐐᔓᐙᐎᓂᐦᒡ ᒑ ᐱᒋᔅᑎᓈᑭᓅᑦ ᓈᐹᐤ ᒥᒄ ᒑ ᒌᐦ ᐄᔑ ᐙᐱᓈᑦ ᐐᐤᐦ?” ");
INSERT INTO crl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐋ ᑰᐦᒋ ᐊᔨᒥᐦᑖᓈᐙᐤ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᒡ, ᓃᔥᑎᒻ ᐄᔨᔨᐤ ᑳ ᐅᔑᐦᐋᑦ ᒋᔖᒥᓂᑑ, ᓈᐹᐤ ᑭᔮᐦ ᐃᔅᒀᐤ ᒌᐦ ᐅᔑᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ᒌᐦ ᐃᔨᑖᑯᐱᓐ ᒫᒃ ᒋᔖᒥᓂᑑ, ‘ᐆ ᐅᐦᒋ, ᓈᐹᐤ ᒋᑭ ᓂᑭᑖᐤ ᐅᓃᒋᐦᐄᒄᐦ ᒑ ᐐᒋᒫᑦ ᐐᐤᐦ, ᐋᒄ ᐊᓂᔮᔨᐤ ᐊᓃᔑᒡ ᒑ ᐹᔨᑯᒡ’᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ᓂᒧᐃ ᔖᔥ ᓃᓯᐎᒡ ᐄᔨᔨᐅᒡ, ᒫᒃ ᒥᒄ ᔖᔥ ᐋ ᐹᔨᑯᔑᑦ ᐊᐙᓐ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᐙᔨᐤᐦ ᒋᔖᒥᓂᑑ ᑳ ᐐᒋᑎᔮᑦ, ᓂᒧᐃ ᐊᐙᓐ ᒋᐱᐦ ᒌ ᐅᐦᒋ ᐱᐦᑳᓂᐦᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐹᕆᓰᐦ, “ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐎᔨᔥᑖᑦ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒧᓱᔅ ᐋᐦ ᐄᑎᔥᑖᔨᒡ, ᓈᐹᐤ ᐐᐦ ᐙᐱᓈᒑ ᐐᐤᐦ ᔮᔨᑖ ᓂᔮᑭᓐᐦ ᒋᑭ ᐐᐦᑎᒧᐙᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐋ ᒥᔮᑦ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᓂᑭᑖᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᒧᓱᔅ ᒋᒌ ᐱᒋᔅᑎᓂᑯᐙᐤ ᒑ ᒌ ᐙᐱᓂᒫᒄ ᒋᐅᐙᐤ ᐙᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᐋ ᒥᔅᑳᐎᑖᐦᐋᑦ᙮ ᓂᒧᐃ ᒫᒃ ᐐᔨ ᒋᔖᒥᓂᑑ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒻ ᒑ ᒌᐦ ᐃᓯᓈᑯᓃᔨᒡ ᐅᔅᑭᒡ ᐙᔑᐦᐋᑦ ᓈᐹᐤ ᑭᔮᐦ ᐃᔅᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ, ᓈᐹᐤ ᐙᐱᓈᒑ ᐐᐤᐦ, ᐋᐦᐋᑳ ᒫᒃ ᐅᐦᒋ ᐱᓯᒀᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐐᐤᐦ, ᐊᓐ ᒫᒃ ᓈᐹᐤ ᐐᒋᒫᒑ ᑯᑎᒃ ᐃᔅᒀᐤ ᐱᓯᒀᑎᓯᐤ ᐊᓐ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, “ᐅᔮᔨᐤ ᐋᔅᐱᔨᐙᒀᓂᒌ ᓈᐹᐤ ᐐᐤᐦ, ᐋᑯᔥ ᒥᔻᓯᔨᐤ ᒑ ᐋᑳ ᒋᐦᒋᐐᒌᐦᑑᒡ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᒥᓯᐙ ᐊᐙᓐ ᒋᑭ ᐅᑎᓂᒻ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐎᓂᔨᐤ, ᒥᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᔮᑦ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ᐱᔅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᒋᑭ ᒌ ᒋᐦᒋᐐᐎᒡ ᐙᔥ ᐋᔪᐎᒄ ᔖᔥ ᑳ ᐄᔑ ᐎᔨᔅᑖᔨᒡ ᐅᔅᑭᒡ ᑳ ᐱᒫᑎᓰᑦ, ᐋᒄ ᑯᑎᑭᒡ ᓂᒧᐃ ᐱᒋᔅᑎᓈᑭᓂᐎᒡ ᒑ ᒌ ᒋᐦᒋᐐᐎᒡ, ᐋᒄ ᑯᑎᑭᒡ ᐐᔨᐙᐤ ᐎᔮᔨᐦᑎᒧᒡ ᒑᐦ ᐋᑳ ᒋᐦᒋᐐᐎᒡ ᐙᔥ ᐄᑖᔨᐦᑎᒧᒡ ᐊᐅᔅᑖ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᒑ ᒌᐦ ᐋᐱᑎᔒᔥᑖᒡ ᒥᒄ ᐋ ᐹᔨᑯᒡ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᒌᐦ ᐅᑎᓂᐦᒃ ᐅᔮᔨᐤ ᐋᑯᔥ ᒋᑭ ᑐᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ᒌ ᐹᔓᐙᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋ ᒌ ᓂᑎᐙᔨᒫᒡ ᒑ ᒌ ᑖᐦᒋᓈᔨᒡ ᒑ ᒌᐦ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᔨᒡ ᒫᒃ, ᒥᒄ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐱᒋᔅᑎᓈᐦᑯᒡ ᐊᐙᔑᔑᒡ ᒑ ᒌ ᐹᒋ ᓈᓯᒡ, ᐊᑳᐐ ᐅᐦᒋ ᒋᔅᑎᐦᐋᒫᑯᒡ, ᐙᔥ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ, ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐐᔨᐙᐤ ᑎᐹᔨᐦᑎᒨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ᒌᓴᔅ ᑳ ᑖᐦᒋᓈᑦ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ᐹᔨᒀᐤ ᓈᐹᐤ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐤ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒑᒀᓐ ᒑ ᒌᐦ ᑐᑎᒫᓐ ᐋ ᒥᔻᔑᒡ ᒑ ᒌᐦ ᐅᐦᒋ ᐃᔮᔮᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᐙᐦᒋ ᑯᒀᒋᒥᔨᓐ ᒑ ᒌ ᐐᐦᑎᒫᑖᓐ ᒑᒀᓐ ᒫᔻᔑᒡ? ᒥᒄ ᐹᔨᒄ ᐊᐙᓐ ᒥᔪᐦᑣᐤ᙮ ᓂᓃᐦᑎ ᐄᑎᔓᐙᐎᓐᐦ ᐐᐦ ᐃᔮᔨᓈ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ, “ᒑᒄ ᐐᔓᐙᐎᓐ?” ᒌᓴᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᒋᑭ ᓂᐱᐦᐄᐙᓐ, ᐊᑳᐐ ᒋᑭ ᐱᓯᒀᑎᓯᓐ, ᐊᑳᐐ ᒋᑭ ᑭᒑᒧᑎᓐ, ᐊᑳᐐ ᒋᑭ ᓂᓂᑎᔮᒋᒫᐤ ᐊᐙᓐ, ");
INSERT INTO crl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ᒥᔪᑐᑎ ᐋ ᒋᔅᑖᔨᒥᑦ ᑰᐦᑖᐐ ᑭᔮᐦ ᒋᑳᐐ, ᑭᔮᐦ ᓵᒋᐦᐄᐦ ᒌᒋᐃᔨᔨᐤ ᒧᔮᒻ ᒌᐦ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ᐋᒄ ᐊᓐ ᐅᔅᒋᓃᒎ ᑳᐦ ᐃᔨᑦ, “ᔖᔥ ᓂᒌ ᓂᓂᐦᐄᐦᑖᓐ ᐅᐦᐄ ᐄᑎᔓᐙᐎᓐ ᑳ ᐹᒋ ᐊᐙᔑᐎᔮᓐ᙮ ᒑᒀᓐ ᒫᒃ ᐊᔮᐱᒡ ᐋᔥᒄ ᓂᐱᐦ ᑐᑖᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᑐᓐ ᒥᓯᐙ ᒑᒀᓐ ᐙᐦ ᑐᑎᒧᓈ ᒑ ᒌᐦ ᑯᐃᔅᑯᑖᑎᓯᔨᓐ, ᓂᑑᐊᑖᐙᒑ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᔨᓐ, ᐋᒄ ᐊᓐ ᔓᐎᔮᓐ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒑ ᒥᔨᑣᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᐃᔮᔨᓐ ᒦᓯᒋᓰᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ᙮ ᒌᐦ ᑐᑎᒥᓈ ᒫᒃ ᐆ ᐋᔥᑎᒻ ᐋᒄ ᒫᒃ ᒑ ᐹᒋ ᓅᔔᔥᑭᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐊᓐ ᐅᔅᒋᓃᒎ ᐅᔮᔨᐤ ᓈᔥᑖᑆᐦ ᒌ ᒥᒑᔨᐦᑎᒻ ᐙᔥ ᓈᔥᒡ ᒌ ᒦᓯᒋᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᐙᓐ ᑳ ᒥᓰᒋᓰᑦ ᑖᑆᐦ ᒋᑭ ᐋᔨᒥᓂᔨᐤ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ᒦᓐ ᐹᔨᒀᐤ ᓂᑭ ᐃᔨᓐ, ᐊᑎᑎᐤ ᐋᔨᒥᓂᔨᐤ ᐊᐙᓐ ᐋ ᒥᓰᒋᓰᑦ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᐃᔥᐱᔥ ᐐᔨ ᐊᓐ ᑳᒥᓪ ᒑ ᒌ ᔖᐳᔥᑭᐦᒃ ᔖᐳᓂᑭᓂᔨᐤ ᐊᓂᑖᐦ ᐋ ᐱᑯᓈᔮᐱᔅᑳᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐅᔮᔨᐤ, ᓈᔥᒡ ᒌᐦ ᑯᔥᒀᔨᐦᑎᒧᒡ, ᐋᒄ ᑳ ᐄᑐᒡ, “ᐊᐙᓐ ᒫᒃ ᐋᒄ ᒑ ᒌ ᐱᒫᒋᐦᐅᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ᐋᒄ ᒌᓴᔅ ᑯᐃᔅᒄ ᑳ ᑭᓂᐙᐱᒫᑦ ᐋᐦ ᐄᑖᑦ, “ᑖᓂᔮᔨᐤ ᐋᐦᐋᑳ ᒌᐦ ᑐᑎᐦᒃ ᐄᔨᔨᐤ ᒋᔖᒥᓂᑑ ᒫᒃ ᐐᔨ ᒥᓯᐙ ᒑᒀᔨᐤ ᒌᐦ ᑐᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᑭᓂᐙᐱᐦᑏ ᒫᐦ᙮ ᔖᔥ ᒥᓯᐙ ᒑᒀᓐ ᓂᒌ ᓂᑭᑖᓈᓐ ᒑ ᒌ ᓅᔔᔥᑳᑖᐦᒡ᙮ ᐆ ᒫᒃ ᑳ ᐄᔑ ᑐᑎᒫᐦᒡ, ᒑᒀᔨᐤ ᒫᒃ ᒑ ᒥᔨᑯᔮᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐄᔥᐱᐦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᐱᐦᒑ ᓈᔥᒡ ᑳᒋᔅᑖᔨᐦᑖᑯᓃᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᑖᐦᑎᐴᓂᐦᒡ ᒦᓐ ᐅᔅᑳᒑ ᐊᔅᒌ, ᐋᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᓂᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᒄ ᒑ ᐊᐱᔮᒄ ᓃᔓᔖᑉ ᐅᒋᒫᐤ ᑖᐦᑎᐱᐎᓐ, ᒑ ᑎᐹᔅᑯᓈᑯᒡ ᓃᔓᔖᑉ ᑳ ᑎᐦᑐᔅᑳᓈᓯᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ᒥᓯᐙ ᐊᐙᓐ ᑳ ᓂᑭᑎᐦᒃ ᐐᒡ ᑭᔮᐦ ᑳ ᓂᑭᑖᑦ ᐐᒋᔖᓐ, ᐅᓃᒋᐦᐄᒄᐦ ᑭᔮᐦ ᐅᑎᐙᔑᔒᒻ ᑭᔮᐦ ᒫᒃ ᑳ ᓂᑭᑎᐦᒃ ᐅᑎᐦ ᐊᔅᒌ ᓃᔨ ᐅᐦᒋ, ᐊᐅᔅᑖ ᒥᑖᐦᑐᒥᑎᓈᐙᐤ ᒋᑭ ᐃᔥᐱᔥ ᒌᐙᒥᔮᑭᓂᐤ ᑭᔮᐦ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᒋᑭ ᒥᔮᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ᒥᒄ ᒫᒃ ᒥᐦᒑᑐ ᐊᓂᒌ ᓈᔥᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᑳ ᐄᑖᔨᒫᑭᓂᐎᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᑭᔮᐦ ᒥᐦᒑᑐ ᐊᓂᒌ ᑳ ᐄᑖᔨᒫᑭᓂᐎᒡ ᐋᐦᐋᑳ ᓈᔥᑎᔨᔥ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ, ᓈᔥᒡ ᒫᒃ ᒋᑭ ᒋᔅᑖᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“ᒫᐤ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒌᐦ ᑖᐤ ᐹᔨᒀᐤ ᐅᒋᒫᐤ ᐋ ᑎᐱᔨᐙᐎᓰᑦ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ᙮ ᐹᔨᒀᐤ ᒫᒃ ᐐᐱᒡ ᐋ ᒑᒋᔖᐹᔮᔨᒡ ᒌᐦ ᐎᔨᐐᐤ ᐋ ᓂᑑᓈᓂᑐᐙᔨᒫᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌᐦ ᐅᑖᔅᑯᓈᑦ, ᒑ ᒌᐦ ᐋᐱᑎᓰᔨᒡ ᐊᓂᑖᐦ ᐅᔔᒥᓈᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ᒌᐦ ᐄᑖᐤ ᑭᔨᑆ ᐊᓐ ᐅᒋᒫᐤ ᒑ ᑎᐱᐦᐊᒧᐙᑦ ᐊᓂᔮ ᑳ ᐅᑖᔅᑯᓈᑦ, ᐹᔨᒄ ᒌᔑᑳᐤᐦ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᐋᐱᑎᓰᔨᒡ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᒑ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒧᐙᑦ᙮ ᒌ ᓂᔅᑯᒧᔨᐤ ᒫᒃ ᐋᒄ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᒑ ᒌᐦ ᐋᐱᑎᓰᔨᒡ ᐊᓂᑖᐦ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ᐋᒄ ᒦᓐ ᑳ ᒋᔅᑐᐦᑖᑦ ᐎᔮᔥ ᐹᔨᑯᔥᑖᐤ ᐋᐦ ᐄᔅᐱᔨᒡ ᐊᓂᔮᔨᐤ ᒌᔮᒋᔖᐹᔮᔨᒡ, ᑳ ᐙᐱᒫᑦ ᐊᓂᑖᐦ ᓈᐹᐤᐦ ᒥᒄ ᐋ ᓈᓃᐱᐎᔨᒡ ᐋᐦᐋᑳ ᐎᔮᔥ ᐄᑖᐱᑎᓰᔨᒡ ᐊᓂᑖᐦ ᑳ ᒌᐦ ᐋᑖᐙᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᓂᒧᐃ ᐋ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᐐᐦ ᐋᐱᑎᓰᓈᐙᐤ ᐊᓂᑖᐦ ᓂᔔᒥᓈᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ? ᒥᓯᐙ ᐙᔥ ᒋᑭ ᒥᔪ ᑎᐱᐦᐊᒫᑎᓈᐙᐤ ᐋᐱᑎᓰᔮᒀ᙮’ ᐋᒄ ᒫᒃ ᑳ ᐄᑐᐦᑖᔨᒡ ᒑ ᒌ ᓂᑑᐋᐱᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","“ᐃᔮᐱᐦᑖᒌᔒᑳᔨᒡ ᒫᒃ, ᑭᔮᐦ ᒦᓐ ᓂᔥᑐ ᐋᐦ ᐄᔅᐱᔨᒡ ᐋ ᐃᔥᒀᐱᐦᑖᒌᔒᑳᔨᒡ, ᒦᓐ ᒌᐦ ᐄᑐᐦᑖᐤ ᐊᓐ ᐅᒋᒫᐤ ᐊᓂᑖᐦ ᑳ ᒌᐦ ᐋᑖᐙᓂᐎᔨᒡ ᒦᓐ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌᐦ ᐅᑖᔅᑯᓈᑦ᙮ ᐊᔮᐱᒡ ᑭᔨᑆ ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ᒑᑳᑦ ᒫᒃ ᓂᔮᔪ ᒌᐦ ᐄᔅᐱᔨᔨᒑ ᐋᒄ ᒦᓐ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑳ ᒌᐦ ᐋᑖᐙᓂᐎᔨᒡ ᒦᓐ ᒫᒃ ᒌ ᐙᐱᒫᐤ ᓈᐹᐤ ᐊᓂᑖᐦ ᐋ ᓈᓃᐱᐎᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᒑᒀᓐ ᐙᐦᒋ ᒥᒄ ᓈᓃᐴᔮᒄ ᐅᑎᐦ ᐃᔅᑭᓐ ᒌᔑᑳᐤᐦ ᐋᐦᐋᑳ ᒑᒀᓐ ᐄᐦᑐᑎᒫᒄ?’ ” ");
INSERT INTO crl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, ‘ᓂᒧᐃ ᐊᐙᓐ ᓅᐦᒋ ᐅᑖᔅᑯᓂᑯᓈᓐ᙮’ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᑭᔮᐦ ᒌᔨᐙᐤ ᓂᑑᐋᐱᑎᓰᒄ ᐊᓂᑖᐦ ᓂᔔᒥᓈᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ᐄᔥᐱᐦ ᒫᒃ ᐙᑖᑯᓰᔨᒡ, ᐊᓐ ᐅᒋᒫᐤ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮ ᑳ ᓈᓈᑭᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐱᑎᓰᔨᒡ, ‘ᓂᑑᒥᒡ ᐊᓂᒌ ᑳᐦ ᐋᐱᒋᐦᐄᒀᐤ, ᒥᓯᐙ ᒑ ᑎᐱᐦᐊᒧᑣᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐱᑎᔒᒡ᙮ ᓃᔥᑎᒻ ᐊᓂᒌ ᒫᐦᒑᔨ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ ᑎᐱᐦᐋᒨᒡ, ᐋᒄ ᒦᓐ ᐊᓂᒌ ᑯᑎᑭᒡ ᑖᓐ ᒥᒄ ᑳᐦ ᐋᑎ ᐄᑎᔅᑳᑐᒡ ᐋ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ, ᒑ ᐋᑎ ᐅᑎᐦᑎᐦᐆᑣᐤ ᐊᓂᒌ ᓃᔥᑎᒻ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“ᐊᓂᒌ ᒫᒃ ᓈᐹᐅᒡ ᓂᔮᔪ ᑳ ᐄᔅᐱᔨᔨᒡ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ ᐋᐅᑯᓂᒡ ᓃᔥᑎᒻ ᑳ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᒡ᙮ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᒌ ᒥᔮᑭᓂᐎᒡ, ᒧᔮᒻ ᐊᔮᐱᒡ ᐃᔅᑭᓐ ᒌᓯᑳᐤ ᐋ ᒌᐦ ᐃᔥᐱᔥ ᐋᐱᑎᔒᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᒡ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᑳᔑᑳᔨᒡ, ᑭᔮᐦ ᐊᓂᒌ ᓃᔥᑎᒻ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᓃᔥᑎᒻ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ ᑳ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᒡ, ᒌᐦ ᐄᑖᔨᐦᑎᒧᒡ ᐐᔨᐙᐤ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᒑ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᒡ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᒌᐦ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒧᐙᑭᓂᐎᒡ ᑭᔮᐦ ᐐᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ᒌᐦ ᐅᑎᓈᐅᒡ ᑭᔨᑆ ᐊᓂᔮᔨᐤ ᔔᐎᔮᓈᐱᔅᒄ ᑳ ᒥᔮᑭᓂᐎᒡ, ᓂᒧᐃ ᒥᒄ ᓈᔥᒡ ᐅᐦᒋ ᐐᐦ ᒥᒥᔪᐄᑖᔨᒫᐎᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᔨᒧᒫᒡ ᐊᓂᔮᔨᐤ ᑳ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ᒌᐦ ᐄᑖᐅᒡ, ‘ᐊᓂᒌ ᒫᐦᒑᔨ ᑳ ᐅᑖᔅᑯᓈᑭᓂᐎᒡ ᒑ ᒌᐦ ᐋᐱᑎᔒᒡ ᒥᒄ ᐹᔨᒀᐤ ᐋᐦᒋᓂᒀᓂᐦᑖᔨᒡ ᐲᓯᒧᐦᑭᓐ ᒌᐦ ᐃᔥᐱᔥ ᐋᐱᑎᓰᐎᒡ, ᓃᔮᓐ ᒫᒃ ᐐᔨ ᐃᔅᑭᓐ ᒌᔑᑳᐤᐦ ᓂᒌᐦ ᐋᐱᑎᓰᓈᓐ ᐋᑎ ᒫᒀᒡ ᐊᓂᑎᐦ ᑳ ᒋᔒᑖᒡ ᐊᔮᐱᒡ ᒫᒃ ᐹᔨᑯᓂᐦᒡ ᒥᓯᐙ ᐋ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒧᔮᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“ᐊᓐ ᒫᒃ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮ ᐹᔨᒄ, ‘ᓂᐐᒑᐙᑭᓐ, ᓂᒧᐃ ᒌ ᒋᒧᑎᒥᑎᓐ, ᐙᔥ ᒋᒌ ᐄᑎᑎᓐ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᒑ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒫᑖᓐ ᐹᔨᒄ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᐋᐱᒋᐦᐄᑖᓈ᙮ ᒋᒌ ᓂᔅᑯᒧᓐ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ᔖᔥ ᒋᒌ ᑎᐱᐦᐊᒫᑎᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ, ᒫᒌ ᓈᑖᐦ᙮ ᐙᔥ ᐆ ᑳ ᐅᑖᔅᑯᓂᑐᑯᒡ ᒥᓯᐙ ᑖᐱᔥᑯᓐ ᒋᒌ ᐐᐦ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒫᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ᓂᒧᐃ ᐋ ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᒥᒄ ᐙᐦ ᑐᑎᐎᒃ ᓂᔔᔮᓂᒻ ᒑ ᒌᐦ ᑐᑎᐎᒃ? ᒋᐅᐎᐦᑖᔨᒥᓈ ᐙᔪᒡ ᐋ ᒥᔪᑐᑎᒫᒑᔮᓐ?’ ” ");
INSERT INTO crl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᐋᒄ ᐅᑖᐦᒡ ᑳᐦ ᑖᒡ ᓃᑳᓂᐦᒡ ᒑ ᑖᒡ ᐋᒄ ᐊᓂᒌ ᓃᑳᓂᐦᒡ ᑳᐦ ᑖᒡ ᐅᑖᐦᒡ ᒑ ᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᒋᕉᓯᓕᒥᐦᒡ ᐋᐦ ᐄᑐᐦᑖᑦ ᒌ ᐱᔅᒑᐦᑎᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᐱᐦᑳᓐ ᒑ ᒌ ᑖᐙᑯᐱᓈ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ, ");
INSERT INTO crl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ᓂᑎᐦᑎᒧᒄ ᒫᐦ, ᒋᕉᓯᓕᒥᐦᒡ ᒋᑎᐄᑐᐦᑖᓈᓂᐤ, ᐋᑯᑖᐦ ᐅᑖᐦ ᒑ ᐅᑎᓈᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᑖᐦ ᒑ ᒌᐦ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓅᑦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡᐦ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᑦ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᓂᐱᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ᐋᒄ ᒫᒃ ᒦᓐ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᐄᑐᐦᑎᐦᐋᒡ ᒑ ᒌ ᒫᔮᔨᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐱᔑᔥᑖᐦᐅᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ᒥᒄ ᒫᒃ ᒌ ᓂᔥᑐ ᒌᔑᑳᔨᒑ ᒦᓐ ᒋᑭ ᐎᓂᔥᑳᐤ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ᓭᐱᑏ ᒫᒃ ᐐᐤᐦ ᒌ ᐹᒋ ᐐᒑᐙᐤ ᐅᑯᓯᔅᐦ, ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ, ᐋᒄ ᐊᓐ ᐃᔅᒀᐤ ᑳᐦ ᐋᑎ ᐅᒋᐦᒌᐦᑯᓂᐱᔥᑎᐙᑦ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᓂᑎᐙᔨᐦᑎᒧᐙᑦ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᓈᑐᐙᔨᐦᑎᒥᓐ?” ᑳ ᐄᑎᑯᑦ ᒫᒃ, “ᐅᒌ ᑖᐱᔥᑯᓐ ᓂᑯᓯᒡ ᒑ ᒌᐦ ᐐᑎᐱᒥᔅᒡ ᐄᔥᐱᐦ ᒋᐦᒋᐅᒋᒫᐎᔨᓈ, ᐹᔨᒄ ᐊᓂᑖᐦ ᒌ ᓂᐦᐄᐎᓂᐦᒡ ᒑ ᒌᐦ ᐊᐱᑦ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᐊᓂᑖᐦ ᒌ ᓂᒥᐦᒌᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᑯᓯᔨᐤᐦ, “ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐊᓐ ᒑᒀᓐ ᑳ ᐄᔑ ᓂᑐᑎᒫᔮᒄ᙮ ᒋᑭ ᒌᐦ ᑎᓈᐤ ᐋ ᒑ ᒌ ᒥᓂᐦᒀᔮᒄ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᐦᒡ ᓂᒥᓂᐦᒀᑭᓂᒡ ᒫᓂᐦᒀᔮᓐ ᐊᓅᐦᒡ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐋᐦᐋ, ᓂᑭ ᒌᐦ ᑎᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ, ᑖᑆᐦ, ᒋᑭ ᐅᐦᒋ ᒥᓂᐦᒀᓈᐙᐤ ᓂᒥᓂᐦᒀᑭᓂᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓃᔨ ᓂᑭ ᒌᐦ ᐎᔮᔨᒫᐤ ᐊᐙᓐ ᒑ ᐐᑎᐱᒥᑦ ᐊᓂᑖᐦ ᓂᐦᐄᐎᓂᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᓂᒥᐦᒌᐎᓂᐦᒡ᙮ ᐙᔥ ᐐᔨ ᓅᐦᑖᐐ ᒌᐦ ᐋᔮᔅᑰᐎᐦᑑᑎᒧᐙᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᒑ ᐊᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑯᑎᑭᒡ ᒥᑖᐦᑐ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᒌ ᒋᔑᐙᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᓃᔓ ᑳ ᐐᒋᔖᓂᐦᑐᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ ᒥᓯᐙ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌ ᒋᔅᒑᔨᒫᐙᐅᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᑭᑎᐹᔨᒫᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ᑭᔮᐦ ᐐᔨᐙᐤ ᒫᒃ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓈᑳᓂᔥᑳᑯᒡ ᐋ ᐎᔨᓲᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ᒥᒄ ᒫᒃ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᐃᓯᓈᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ᙮ ᐊᓐ ᐊᐙᓐ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᓈᑎᐙᔨᐦᑎᒧᒀ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐋᑯᔥ ᒋᐱᐦ ᐱᒋᔅᑎᓃᓱᐤ ᒑ ᒌᐦ ᐋᐱᑎᔒᔥᑖᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ᐋᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᐐᐦ ᓃᑳᓂᐦᐄᓱᑦ ᐋᐅᒄ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᒋᐱᐦ ᐅᑖᐱᒋᐦᐋᑭᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ᒧᔮᒻ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᒧᐃ ᐅᐦᒋ ᐹᒋ ᑎᑯᔑᓐ ᒑ ᒌᐦ ᐋᐱᑎᔒᔥᑑᐙᑭᓅᑦ, ᒌ ᑎᑯᔑᓐ ᒑ ᒌᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ ᐄᔨᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᒌ ᑎᑯᔑᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒃ ᐅᐱᒫᑏᓯᐎᓐ ᒦᔥᑯᒡ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐱᑯᐦᐄᒫᑭᓂᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᓂᑭᑎᐦᒡ ᒉᕆᒀᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᒌ ᓅᔔᔥᑳᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ᓃᔓ ᒫᒃ ᓈᐹᐅᒡ ᐋᐦᐋᑳ ᐙᐱᐦᑎᐦᒡ ᐊᓂᑖᐦ ᔮᐃᔅᑭᓂᐤ ᐋ ᐊᐱᐎᒡ ᒌ ᐹᐦᑎᒧᒡ ᐋᐦ ᐄᓈᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐋ ᐱᒧᐦᑖᔨᒡ, ᐋᒄ ᑳ ᑎᑖᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒥᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐙᔅᑳ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐅᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, ᐋᐦ ᐄᑖᒡ, “ᐋᑳ ᒋᔅᑐᒄ ᒫᐦ᙮” ᐋᒄ ᒥᒄ ᐋᒡ ᐊᑎᑎᐤ ᓲᐦᒃ ᑳ ᑖᑆᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒥᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᐱᐦᒋᑳᐳ, ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᓈᑎᐙᔨᐦᑎᒫᒄ ᒑ ᒌᐦ ᑐᑎᒫᑎᑯᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ᒌᐦ ᐄᑖᐅᒡ ᒫᒃ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᑐᑎᐎᓈᓐ ᒫᐦ ᒑ ᒌ ᐙᐱᐦᑎᒫᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ, ᑳ ᑖᐦᒋᓂᒸᑦ ᐅᔅᒌᔑᑯᔨᐤ, ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐙᐱᐦᑎᒥᔨᐤ, ᐋᒄ ᑳᐦ ᐋᑎ ᓅᔔᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ᐄᔥᐱᐦ ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᐋᑎ ᐹᔣᐱᐦᑎᐦᒡ, ᒌᐦ ᐅᑎᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐯᕪᐯᐃᒡ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐊᓂᑖᐦ ᐋᐱᔅᑯᑎᓈᐦᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐋᑯᑖᐦ ᑳᐦ ᑎᑯᐦᒡ ᐆ ᐃᐦᑖᐎᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᒌᓴᔅ ᑳ ᓃᑳᓂᑎᔑᐦᐙᑦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ᐄᑐᐦᑖᒄ ᓈ ᓈᑖᐦ ᐃᐦᑖᐎᓐ, ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᐦᑎᒫᒀ ᒋᑭ ᐙᐱᒫᐙᐤ ᐋᐦᐋᓯᔑᔥ ᑭᔮᐦ ᐊᓂᔮ ᐅᑯᓯᔨᐤᐦ ᐋ ᐐᒋᑳᐳᔥᑖᑯᑦ᙮ ᐱᑯᐦᐋᐦᑯᒡ ᐋᒄ ᒫᒃ ᒑ ᐹᑑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ᐋᒄ ᑯᒀᒋᒥᑖᒀ ᐊᐙᓐ, ᒑᒀᔨᐤ ᐙᐦᒋ ᐱᑯᐦᐋᐦᑯᒡ ᐊᓂᒌ, ᒑ ᐄᑖᒄ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᑎᐙᔨᒫᐤ᙮’ ᑏᐙᐦᒡ ᒫᒃ ᒋᑭ ᓂᐦᐋᔨᒥᑯᐙᐤ ᒑ ᒌᐦ ᐅᑎᓂᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ᐙᔥ ᐊᓐ ᐹᔨᒄ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳᐦ ᐃᔨᑯᐱᓈ ᐅᔮᔨᐤ ᒑ ᐄᔅᐱᔨᒡ, ᒌ ᑎᐱᐱᔨᐤ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","ᐐᐦᑎᒧᐙᐦᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᓵᐃᔨᓂᐦᒡ ᑳ ᐅᐦᒌᒡ, ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ ᒋᒋᔥᒋᐅᒋᒫᒧᐙᐤ᙮ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑯᐙᐤ ᐋ ᑎᐱᐦᑖᔨᒦᓱᑦ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ ᐋ ᑖᐦᑎᐱᐙᑦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑯᐱᓈ ᐊᓂᔮ ᐹᔨᒄ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᓃᔓ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᑳᐦ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔑᒥᑯᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ᒌ ᐹᔓᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᑭᔮᐦ ᐊᓂᔮ ᐅᑯᓯᔨᐤᐦ, ᑳ ᐊᑯᓂᐦᐙᒡ ᐅᑎᑯᐦᐱᐙᐤ ᐊᓂᑖᐦ ᐅᔅᐱᔅᑯᓃᔨᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᑖᐦᑎᐱᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ᐋ ᒫᒨ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᒌᐦ ᓯᑣᑭᔥᑖᐅᒡ ᐅᑎᑯᐦᐱᐙᐤ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑎᐦᐄᑯᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐅᐦᑳᓐ ᑭᔮᐦ ᑯᑎᑭᒡ ᓂᐱᓯᔮᐦᑎᒄ ᒌ ᓈᑣᓂᒧᒡ ᑳ ᐱᒫᔅᑯᔅᑖᒡ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᐱᒧᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐅᐦᑳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᓃᑳᓂᐦᒡ ᑳ ᐱᒧᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᑭᔮᐦ ᐊᓂᒌ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᑳ ᐱᒧᐦᑖᐙᒡ ᒌ ᒋᐦᒋ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ ᐋ ᒋᔣᐙᒡ ᐋᐦ ᐃᔨᒡ, “ ᐦᐆᓵᓈᐦ! ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐦᒄ ᐊᓐ ᑳ ᐅᑯᓯᑐᑖᑯᑦ ᑌᕕᑦ, ᔑᐙᔨᐦᑖᑯᓲ ᐆ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᒫᒥᐦᒋᒫᑖᐤ ᒋᔖᒥᓂᑑ ᐐᔨ ᒫᐅᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᒥᐦᒡ ᒋᐦᒋᔑᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑖᑯᔑᐦᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᒡ ᒌᐦ ᑯᔥᒀᔨᐦᑎᒧᒡ ᐋᐦ ᐃᔨᒡ, “ᐊᐙᓐ ᐊᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᐐᒑᐙᔨᒡ ᒌᓴᔅᐦ, “ᒌᓴᔅ ᐊᓐ᙮ ᐋᐅᒄ ᐊᓐ ᐆ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐊᓂᑖᐦ ᓈᓵᕆᑦ, ᑳᓕᓖ ᐊᔅᒌᐦᒡ, ᑳ ᐅᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ᐋᒄ ᒌᓴᔅ ᑳ ᐲᐦᒑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ᙮ ᒌ ᐙᐱᒫᐤ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᑳ ᐊᑖᐙᔨᒡᐦ ᑭᔮᐦ ᐊᓂᔮ ᑳ ᐅᑎᓂᒑᔨᒡᐦ ᐊᓂᑖᐦ ᐲᐦᑎᑭᒥᐦᒡ, ᐋᒄ ᑳ ᐎᔨᐐᑎᔑᐦᐙᑦ᙮ ᒌᐦ ᒀᑎᐳᐙᐱᓂᒸᐤ ᒫᒃ ᐅᒦᒋᓲᓈᐦᑎᑯᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒦᔅᑯᑑᓈᔨᒡ ᔔᐎᔮᓈᐱᔅᒄ ᑭᔮᐦ ᐅᑖᐦᑎᐴᓂᔨᐤ ᒌᐦ ᒀᑎᐳᐙᐱᓂᒸᐤ ᐊᓂᔮᐦ ᑳᐦ ᐋᑖᐙᔨᒡᐦ ᐱᔮᔒᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᑭᑎ ᐃᔑᓂᐦᑳᑖᐤ ᓂᐙᔅᑳᐦᐄᑭᓂᒻ᙮ ᒥᒄ ᒫᒃ ᒌᔨᐙᐤ ᒋᒧᑎᔅᑭᒡ ᐅᐙᔅᑳᐦᐄᑭᓂᒧᐙᐤ ᐋᐅᒄ ᐋ ᑖᐱᒋᐦᑖᔮᒄ ᐆ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ᙮” ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᑳ ᐊᑖᐙᔨᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᒫᒃ ᐊᓂᔮᐦ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮ ᑳ ᒫᔅᒋᓂᐦᑖᐅᒋᔨᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒫᒀᒡ ᐋᐦ ᑖᑦ, ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᒋᔑᐙᐦᐄᑯᒡ ᐊᓂᔮ ᒌᓴᔅᐦ ᐋ ᐙᐱᒫᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ ᐋᐦ ᑐᑎᒥᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒌᐦ ᐅᐦᑳᒥᑯᒡ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ ᐋ ᐄᔑ ᑖᑆᔨᒡ ᐊᓂᑎᐦ ᐲᐦᑎᑭᒥᐦᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, “ᒫᒥᐦᒋᒫᑖᐤ ᒌᓴᔅ ᑌᕕᑦ ᐅᑯᓯᔅᐦ,” ᐋᐦ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ᐋᒄ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮ ᒌᓴᔅᐦ, “ᒌ ᐹᐦᑎᐙᐅᒡ ᐋ ᑖᓐ ᐋᐦ ᐃᔨᒡ?” ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᐹᐦᑐᐙᐅᒡ᙮ ᓂᒧᐃ ᐋ ᓂᐦᑖ ᑯᐦᒋ ᐊᔨᒥᐦᑖᓈᐙᐤ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᒡ, ᒋᔖᒥᓂᑑ ᒌᐦ ᑐᑎᐙᐤ ᐊᐙᔑᔥ ᑭᔮᐦ ᐊᐱᔥᑎᐙᔥ ᒑ ᒌ ᒥᔪ ᒫᒥᐦᒋᒥᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑭᑖᑦ, ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᐯᑎᓃᐦᒡ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑖᑦ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᑦ ᐹᔨᒄ ᑎᐱᔅᑳᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ᐐᐱᒡ ᒫᒃ ᒋᔮᒋᔖᐹᔮᔨᒡ ᒌᓴᔅ ᒦᓐ ᑳᐤ ᒌ ᒌᔨᐙᐤ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒌ ᔒᐅᑖᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ᐋᒄ ᑳ ᐙᐱᒫᑦ ᒥᓯᔔᒥᓈᐦᑎᒄ ᐊᓂᑖᐦ ᔮᐃᔅᑭᓂᐤ, ᑳ ᓂᑎᐙᐱᒫᑦ, ᓂᒧᐃ ᒫᒃ ᒑᒀᔨᐤ ᐅᐦᒋ ᒥᔅᑭᒻ ᒑ ᒌ ᒦᒋᑦ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ ᒥᒄ ᓃᐱᓯᔨ ᒌ ᓂᐦᑖᐅᒋᓂᔨᐤ ᐊᓂᑎᐦ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᒥᔥᑎᒄ, “ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᐅᒡ ᐙᐱᒥᓂᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᓐ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᓂᐱᐎᔨᐤ ᐊᓂᔮᔨᐤ ᒥᓯᔔᒥᓈᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᐙᐱᐦᑎᒧᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ, ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᒫᒃ ᐋᐦ ᐃᔨᒡ, “ᑖᓂᑖᐦ ᓈᔥᒡ ᐐᐱᒡ ᐙᐦᒋ ᓂᐱᑦ ᐊᓐ ᒥᓯᔔᒥᓈᐦᑎᒄ?” ");
INSERT INTO crl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᑳ ᒥᑐᓐ ᒑ ᐅᐦᒋ ᐋᓍᐦᑎᒧᐙᒀ ᒥᒄ ᒥᑐᓐ ᒑ ᑖᑆᐦᑎᒧᐙᒀ, ᒋᑭ ᒌᐦ ᐃᔨᐦᑑᑎᐙᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ ᑖᓐ ᑳᐦ ᑐᑎᐎᒃ ᐆ ᒥᓯᔔᒥᓈᐦᑎᒄ᙮ ᓂᒥᔮᐤ ᒥᒄ ᐊᓐ ᒑᒀᓐ ᒑ ᒌᐦ ᑐᑎᒫᒄ ᑭᔮᐦ ᒋᑭ ᒌᐦ ᐄᑎᔓᐙᑖᓐ ᐋᐱᔅᑯᑎᓈᐦᒡ, ‘ᐄᔑ ᐙᐱᓂᓱᐦ ᐊᓂᑖᐦ ᒋᐦᒋᑭᒦᐦᒡ᙮’ ᒋᑭ ᐱᔑᒋᐦᐄᑯᓐ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑐᑎᒫᐙᒀ ᐋ ᐊᔨᒥᐦᐋᔮᒄ, ᑖᑆᐦᑎᒫᒀ, ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑯᐎᔮᒄ ᐊᓐ ᑳ ᐄᔑ ᓂᑐᑎᒫᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐲᐦᒑᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᒫᒀᒡ ᒫᒃ ᐋ ᒋᔅᑯᑎᒫᒑᑦ, ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔑᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒌᐦ ᐄᑎᑰ, “ᐊᐙᓐ ᑳ ᒥᔨᔅᒃ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒑ ᒌᐦ ᑐᑎᒥᓐ ᐆ? ᐊᐙᓐ ᑳᐦ ᐄᑎᔓᒥᔅᒃ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᑐᑎᒧᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᑭ ᑯᒀᒋᒥᑎᓈᐙᐤ ᒑᒀᓐ, ᒑ ᐹᒋ ᓂᔥᒀᐅᔑᐦᐄᔮᒄ ᐋᒄ ᒫᒃ ᒑ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓂᑖᐦ ᐙᐦᒋᐱᔨᒡ ᐆ ᑎᐹᔨᐦᒋᒑᐎᓐ ᑳ ᐃᔮᔮᓐ ᒑ ᒌᐦ ᑐᑎᒫᓐ ᐅᐦᐄ ᒑᒀᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ᐹᒋ ᐐᐦᑎᒨᒄ, ᐊᐙᔨᐤᐦ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᒞᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ? ᒋᔖᒥᓂᑑ ᐋ ᑭᔮᐦ ᒫᒃ ᓈᐹᐤ?” ᒌᐦ ᐎᔥᑖᐱᔨᐎᒡ ᒫᒃ ᐊᓂᑎᐦ ᐐᔨᐙᐤ ᐋᐦ ᐃᔨᒡ, “ᐄᔨᔨᐦᒀ, ‘ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑎᑰ,’ ᒋᑭ ᐄᑎᑯᓐ, ‘ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᑖᑆᐦᑎᐙᒄ?’ ");
INSERT INTO crl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ᑭᔮᐦ ᒫᒃ ᐄᔨᔨᐦᒀ ‘ᓈᐹᐤ ᒌᐦ ᐄᑎᑰ,’ ᒋᑭ ᐐᐦ ᔮᒀᒦᔥᑐᐙᓅᒡ ᑖᓐ ᒑᐦ ᑎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᐙᔥ ᒥᓯᐙ ᑖᑆᐦᑎᒧᒡ ᒞᓐ ᐋ ᒌ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᒡ ᒌᓴᔅᐦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐊᐙᔨᐤᐦ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᒞᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ᙮” ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑭᔮᐦ ᓃᔨ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐙᓐ ᑳ ᐹᒋ ᐄᑎᔓᒥᑦ ᐆ ᒑ ᒌᐦ ᑐᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","ᐋᒄ ᒌᓴᔅᐦ ᑳᐦ ᐄᑖᑦ, “ᒋᑭ ᑎᐹᒋᒧᔥᑖᑎᓈᐙᐤ ᒑ ᒫᒥᑐᓈᔨᐦᑎᒫᒄ ᒫᒃ᙮ ᒌᐦ ᑖᐤ ᐹᔨᒀᐤ ᓈᐹᐤ ᐋ ᒌᐦ ᓃᔑᔨᒡ ᐅᑯᓯᔅᐦ᙮ ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑖᓯᒫᐎᔨᒡ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᓂᑯᔅ ᓂᑑᐋᐱᑎᓰᐦ ᒫᐦ ᐊᓂᑖᐦ ᓂᔔᒥᓈᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᐊᓅᐦᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐅᑯᓯᔅᐦ, ‘ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᓂᑑᐋᐱᑎᓰᓐ᙮’ ᐹᑎᒫ ᒫᒃ ᒌ ᓂᑐᐋᐱᑎᓰᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ᐋᒄ ᐊᓐ ᐅᐦᑖᐐᒫᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮ ᑯᑎᒃ ᐅᑯᓯᔅᐦ, ᒦᓐ ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ ᒑ ᒌ ᓂᑑᐋᐱᑎᓰᔨᒡ ᐊᓂᑖᐦ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐅᑯᓯᔅᐦ, ‘ᓂᐦᐄ, ᓂᑭ ᐄᑐᐦᑖᓐ᙮’ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐄᑐᐦᑖᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ᑖᓐ ᒫᒃ ᐊᓂᒌ ᐋ ᓃᔑᒡ ᓈᐹᔑᒡ ᑳ ᓂᓂᐦᐄᐦᑎᐙᑦ ᐅᐦᑖᐐᐦ᙮” ᐋᒄ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᑯᒀᒋᒫᑦ, “ᐊᓐ ᐅᔅᑖᓯᒫᐤ᙮” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᒌ ᓂᑎᐐ ᒥᒄ ᑳᐦ ᑎᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᐋᐱᒋᐦᐄᑯᒡ ᒑ ᒌ ᒫᒨᔑᒋᓂᒫᒡ ᐅᔔᔮᓂᒥᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᐱᓯᒀᑎᓰᔅᒀᐅᒡ ᐋᐅᑯᓂᒡ ᓃᔥᑎᒻ ᒑ ᐲᐦᒑᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᐋᔥᒄ ᐋᒸᔮ ᒌᔨᐙᐤ ᐲᐦᒑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","ᐙᔥ ᒞᓐ ᑳ ᓰᑭᐦᐄᑖᒑᑦ ᒋᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑯᐙᐤ ᐋ ᒌ ᐐᐦ ᐙᐱᐦᑏᑖᒄ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ, ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᑖᑆᐦᑎᐙᐙᐤ᙮ ᒥᒄ ᒫᒃ ᐊᓂᒌ ᒋᐦᒋᐅᒋᒫᐤ ᑳᐦ ᐋᐱᒋᐦᐄᑯᒡ ᐋ ᒫᒨᔑᒋᓂᒫᒡ ᐅᔔᔮᓂᒥᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᐱᓯᒀᑎᓰᔅᒀᐅᒡ ᒌ ᑖᑆᐦᑎᐙᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᑎᒫᑯᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ᙮ ᐋᑦ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑯᒡ ᐋ ᑖᑆᐦᑎᐦᒡ ᐅᒌ, ᓂᒧᐃ ᐊᔮᐱᒡ ᑰᐦᒋ ᒀᔅᑳᑎᓰᓈᐙᐤ, ᓂᒧᐃ ᐊᔮᐱᒡ ᑰᐦᒋ ᑖᑆᐦᑖᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᑎᐦᑎᒧᒄ ᒦᓐ ᐆ ᑯᑎᒡ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓐ᙮ ᒌᐦ ᑖᐤ ᐹᔨᒀᐤ ᐅᒋᒫᐤ ᐋ ᓂᐦᑖᐅᒋᐦᑖᑦ ᒦᓂᔥ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐅᔑᐦᑖᑦ ᔔᒥᓈᐴᔨᐤ᙮ ᒌ ᒋᐱᐦᐊᒻ ᒫᒃ ᒥᓯᐙ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ᙮ ᑭᔮᐦ ᒌ ᒨᓈᐅᐦᑭᐦᐊᒻ ᑖᓂᑖᐦ ᒑ ᐹᐱᒋᔅᒋᔥᑳᑭᓂᐐᔨᒡ ᐊᓂᔮ ᒦᓂᔥ᙮ ᒌᐦ ᐅᔑᐦᑖᐤ ᑭᔮᐦ ᓂᑎᐙᐱᐅᑭᒥᑯᔨᐤ ᐊᓂᑖᐦ ᒑ ᐅᐦᒋ ᓈᓈᑭᒋᐦᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᑐᑎᐦᒃ ᒌ ᓈᓂᑎᐙᐱᒫᐤ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ, ᐙᐦᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᔅᒌᔨᐤ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐱᔨᔨᒡ ᒑ ᒫᒨᔑᒋᓂᑭᓂᐐᔨᒡ ᐊᓂᔮᔨᐤ ᒦᓂᔥ ᐊᓂᑎᐦ ᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᒌᐦ ᐄᑎᔑᐦᐙᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᓂᑎᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᒑ ᒌ ᒥᔨᑯᑦ ᐐᔨ ᒑ ᐄᔑ ᐋᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ᐋᒄ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᒌᐦ ᑰᓰᐦᑯᐙᐅᒡ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᒫᑭᓂᐎᔨᒡ, ᐋᒄ ᒦᓐ ᑯᑎᒃ ᑳ ᓂᐱᐦᐋᒡ, ᐋᒄ ᒦᓐ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒌ ᓂᐱᐦᐋᐅᒡ ᐋ ᒌ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ᐋᒄ ᒫᒃ ᐊᓐ ᐅᒋᒫᐤ ᒦᓐ ᒌᐦ ᐄᑎᔑᐦᐙᐤ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ, ᐊᑎᑎᐤ ᐋ ᒥᐦᒑᑎᔨᒡ᙮ ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔮᐱᒡ ᐋᔪᐎᒄ ᑳᐦ ᑐᑎᐙᒡ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ᐋᒄ ᒑᒃ ᐊᓂᔮ ᐅᑯᓯᔅᐦ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐊᓐ ᐅᒋᒫᐤ ᐋᐦ ᐃᔨᑦ, ‘ᒋᑭ ᒋᔅᑖᔨᒫᐅᒡ ᐅᔮᔨᐤ ᓂᑯᔅ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᐊᓂᔮ ᐅᒋᒫᒧᐙᐤ ᐅᑯᓯᔨᐤᐦ ᒌᐦ ᐄᑎᑐᒡ, ‘ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᐊᓐ ᑰᒋᒫᒥᓂᐤ ᑎᐱᔨᐙ ᐅᑯᓯᔅᐦ᙮ ᐐᔨ ᒋᑭ ᐋᔔ ᒥᔮᑭᓂᐤ ᐅᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ᙮ ᓂᐱᐦᐋᑖᐤ᙮ ᐋᒄ ᒫᒃ ᐅᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᒌᔮᓂᐤ ᒑ ᑎᐱᔨᐙᐎᓯᐅᒄ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ᐋᒄ ᑳ ᐅᑎᓈᒡᐦ, ᑳ ᐎᔨᐐᑎᔑᓈᒡᐦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐋᒄ ᑳ ᓂᐱᐦᐋᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᒫᒃ ᐋᑖᔨᒫᒄ ᒑ ᑐᑎᐙᑦ ᐊᓐ ᐅᒋᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐄᔥᐱᐦ ᑎᑯᔑᐦᑳ?” ");
INSERT INTO crl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᑎᐹᒋᒧᔥᑐᐙᑦ ᐄᔨᔨᐤ, “ᑎᑯᔑᐦᑳ ᐊᓐ ᐅᒋᒫᐤ ᒋᑭ ᓂᐱᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒥᒋᐋᐱᒋᐦᐋᑭᓐ, ᐋᒄ ᒑ ᒥᔮᑦ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ, ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᒥᔨᑯᑦ ᐐᔨ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ ᐄᔥᐱᐦ ᒌᔥ ᓂᐦᑖᐅᒋᓃᒀᐙ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐋ ᑰᐦᒋ ᐊᔨᒥᐦᑖᓈᐙᐤ ᑳᐦ ᐄᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒌᐦ ᐋᑎᐙᔨᒫᐅᒡ ᑳ ᐙᔅᑳᐦᐄᑭᓂᐦᒑᒡ ᐊᓂᔮᔨᐤ ᑳ ᐎᔮᔨᒥᐦᒡ ᐊᓯᓃ ᐙᒋᐦᒡ ᑳᐦ ᐋᐱᑎᓰᔨᒡ ᐋ ᒌᐦᒑᔮᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑖᔨᐦᑐᐎᓐ, ᓄᐎᒡ ᒥᔅᑳᑖᔨᐦᑖᑯᓂᔨᐤ ᐋ ᑭᓂᐙᐱᐦᑖᒥᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᐆ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᑭᑎ ᐄᒑᓂᑭᓂᐤ ᐊᓂᑎᐦ ᒌᔨᐙᐤ ᐋᐦ ᑖᔮᒄ, ᐋᒄ ᒑ ᐋᔔᒥᔮᑭᓂᐎᒡ ᐊᓂᒌ ᑖᑆᐦ ᐋᐦ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᒫᔻᓰᔨᐦ ᓂᑎᐙᔨᐦᑖᑯᓯᒡ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᐅᐦᒋ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ‘ᐊᐙᓐ ᐋ ᐱᓱᓯᒥᑯᑦ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᒥᑐᓐ ᒋᑭ ᐲᑯᔑᓐ, ᐋᒄ ᒫᒃ ᐱᒋᔥᑐᐦᐅᑯᒑ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᒥᑐᓐ ᑭᑎ ᐱᒋᔅᒋᔥᑳᑰ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᒌᓴᔅᐦ ᐋ ᐐᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᔨᐤ, ᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᒫᒃ ᐐᔨᐙᐤ ᐋᐦ ᐋᔨᒨᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ᒋᐐᐦ ᐅᑎᓈᐅᒡ ᒫᒃ ᐊᓂᔮ ᒌᓴᔅᐦ, ᒥᒄ ᒌᐦ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑖᓐ ᒑ ᑎᔨᒡ, ᐙᔥ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒥᑐᓐ ᒌᐦ ᒑᔥᑎᓈᑖᔨᐦᑎᒧᒡ ᒌᓴᔅᐦ ᐋ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒧᔮᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋ ᐃᔮᔅᑰᔥᑖᑦ ᐋ ᒥᔖᔨᒡ ᒥᑯᔖᓂᔨᐤ, ᐅᑯᓯᔅᐦ ᐋ ᐐᐦ ᒥᑯᔖᐦᐋᑦ ᐋ ᐐᐦ ᒌ ᒋᐦᒋᐐᐗᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ᒌᐦ ᐄᑎᔑᐦᐙᐤ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᓂᑎᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓂᑐᒫᑭᓂᐎᔨᒡ᙮ ᐋᒄ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑎᑯᔑᓂᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᓂᑑᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ᐋᒄ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᒑ ᒌ ᓂᑎᐙᐱᒫᔨᒡ ᒦᓐ ᐊᓂᔮᔨᐤ ᑳ ᓂᑐᒫᑭᓂᐎᔨᒡ ᐊᐙᔨᐤᐦ᙮ ᒫᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑦ ᒑ ᒌᐦ ᐄᔨᔨᒡ, ‘ᔖᔥ ᓂᒌᔑᐋᔨᐦᑎᓐ ᒑ ᒥᑯᔖᔮᓐ᙮’ ᔖᔥ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ ᒥᔅᑐᓯᒡ ᑭᔮᐦ ᐎᔨᔫᒡ ᒥᔅᑐᓯᔑᒡ ᒑ ᒥᑯᔖᓂᐐᒡ ᑭᔮᐦ ᔖᔥ ᒌᔥ ᐎᔨᔥᑖᓱᓈᓂᐤ᙮ ᐹᒋ ᑎᑯᔑᓂᒄ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓂᑐᒫᑭᓂᐎᒡ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐱᓯᐦᑎᒧᒡ, ᐃᔨᐦᒡ ᐊᓂᑖᐦ ᒌᐦ ᐄᔑ ᑭᒋᐦᑐᐦᑖᐅᒡ᙮ ᐹᔨᒄ ᐊᓐ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᐦᑎᑯᓃᔨᒡ ᒌᐦ ᐄᑐᐦᑖᐤ᙮ ᐋᒄ ᒦᓐ ᑯᑎᒃ ᒌᐦ ᐃᔮᑖᑯᐱᓐ ᑖᓐ ᑳ ᐄᔑ ᐅᑎᓂᒑᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᑦ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᒫᑯᓂᒫᒡ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ, ᐋᒄ ᑳ ᑯᓰᐦᑯᐙᒡ, ᑳᐦ ᐋᑎ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐋ ᒌᐦ ᐋᐦᑎᓈᓂᐎᔨᒡ ᓈᔥᒡ ᒌ ᒋᔑᐙᔔ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐅᓂᑐᐱᔨᒻ ᒑ ᒌ ᓂᑑᓂᐱᐦᐋᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᓂᐱᐦᐋᔨᒡᐦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ᐋᒄ ᑭᔮᐦ ᑳᐦ ᐋᑎ ᐃᔥᒀᓯᒸᑦ ᐊᓂᔮᔨᐤ ᐅᑎ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ᐋᒄ ᒦᓐ ᑳ ᓂᑑᒫᑦ ᑯᑎᒃ ᐅᑖᐱᒋᐦᐋᑭᓐ, ᑳᐦ ᐄᑖᑦ, ‘ᔖᔥ ᐙᔥ ᐃᔮᔅᑰᔥᑖᐤ ᐊᓐ ᒋᐦᒋᐐᒋᑑ ᒥᑯᔖᓐ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᓂᑐᒥᒀᐤ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑎᑯᔑᓂᒡ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᑖᐱᒑᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ᒫᒌᒄ ᒫᒃ ᐄᑐᐦᑖᒄ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᐦᒡ ᐄᔨᔨᐅᒡ ᒥᒄ ᑎᐦᑐ ᐄᔨᔨᐅᒡ ᒑ ᐙᐱᒫᑯᒡ ᒑ ᓂᑑᒫᑯᒡ ᒑ ᒌ ᐹᒋ ᓈᒋᒥᑯᔖᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ᐋᒄ ᐊᓂᒌ ᐋᐱᒋᐦᐋᑭᓂᒡ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐙᐱᒫᒡ ᒥᓯᐙ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᐙᔨᐤᐦ, ᐅᒥᒋᐦᑣᐤ ᑭᔮᐦ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᐙᐐᓵᒫᒡ᙮ ᐋᒄ ᒫᒃ ᒥᑐᓐ ᑳᐦ ᐋᑎ ᓵᑭᔅᒋᓈᓂᐎᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᒥᑯᔖᓂᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐱᔮᒋ ᐲᐦᒑᑦ ᒑ ᒌ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑎᑯᔑᓃᔨᒡ, ᒌ ᐙᐱᒫᐤ ᐹᔨᒄ ᐊᓂᑎᐦ ᓈᐹᐤ ᐋᐦᐋᑳ ᒧᔮᒻ ᐄᑖᔅᐱᓱᔨᒡ ᐊᓂᔮᔨᐤ ᒑ ᐄᑖᔅᐱᓱᔨᑯᐱᓈᓂᐦᐄ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᓈᐹᐤ, ‘ᓂᐐᒑᐙᑭᓐ ᑖᓂᑖᐦ ᐙᐦ ᒌᐲᐦᒑᔨᓐ ᐅᑎᐦ ᐆ ᐋ ᒥᑯᔖᔮᓐ ᐋᐦᐋᑳ ᒫᒃ ᒧᔮᒻ ᐄᑖᔅᐱᓱᔨᓐ?’ ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᒋᔅᑑ ᐊᓐ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ‘ᒫᐦᑯᐱᑎᒸᒄ ᐅᓯᑦ ᑭᔮᐦ ᐅᑎᐦᒌ, ᒑ ᐄᔑ ᐙᐱᓈᒄ ᓈᑖᐦ ᐋ ᐊᐅᑳᔥᑖᔮᔨᒡ ᐊᓂᑎᐦ ᒑ ᓂᓈᐦᑳᑖᔨᒧᑦ ᐊᓂᑖᐦ ᒑ ᒫᑑᒡ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᓯᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᑖᑆᑖᑭᓂᐎᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᐦᒑᑦ ᐎᔮᐱᒫᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᐹᕆᓰᒡ, ᒑ ᓂᑑᔨᒥᐦᐄᑐᒡ ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᑳᐦᒋᔥᑎᓈᒡ ᒌᓴᔅᐦ ᐋ ᑯᒀᒋᒫᒡ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ᒌᐦ ᐄᑎᔑᐦᐙᐅᒡ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᐙᐤᐦ ᑭᔮᐦ ᐦᐁᕆᑦ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤᐦ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᑖᑆᐦ ᐋ ᑖᑆᒥᑭᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᓐ ᑭᔮᐦ ᒥᓯᐙ ᐹᔨᑯᓂᐦᒡ ᐋ ᐄᔑ ᒋᔅᑯᑎᒨᑣᐤ ᐄᔨᔨᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌᐦ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ᓂᒧᐃ ᒥᑐᓐ ᐎᔮᔥ ᒋᑎᐄᑖᔨᐦᑎᒥᐦᐄᑯᓐ ᑖᓐ ᒑ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐄᔨᔨᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᐅᑦ, ᑭᔮᐦ ᒥᓯᐙ ᐹᔨᑯᓂᐦᒡ ᒋᑎᐄᑖᔨᒫᐅᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ᐋᒄ ᒫᒃ ᓈᑐᐙᔨᒥᑖᐦᒡ ᒑ ᒌ ᐐᐦᑎᒧᔮᐦᒡ, ᐋᐤ ᐋ ᐋᑎᔅᑖᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᐦᒡ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᑳ ᑎᐱᐦᐄᒑᔨᒡ ᐊᐙᔨᐤᐦ?” ");
INSERT INTO crl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᐋ ᒌ ᐐᐦ ᑐᑖᑯᑦ ᓂᑎᐐ ᒑ ᒌᐦ ᐃᔨᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ, ᒑᒀᓐ ᐙᐦᒋ ᐐᐦ ᐹᒋ ᑯᒀᒋᐦᐄᔮᒄ? ");
INSERT INTO crl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ᐹᒋ ᐙᐱᐦᑎᔨᒄ ᒫᐦ ᐊᓐ ᔓᐎᔮᓐ ᐋ ᐱᐦᒀᓂᒧᐙᑭᓅᑦ ᒋᐦᒋᐅᒋᒫᐤ᙮” ᐋᒄ ᑳ ᒥᔨᑯᑦ ᔔᐎᔮᓈᐱᔅᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᒫᒃ ᐅᑖᔥᑎᒥᐦᒄ ᓅᑯᓃᔨᒡ ᐅᑎᐦ ᑭᔮᐦ ᐊᐙᓐ ᐅᔮᔨᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᑳ ᒥᓯᓈᑖᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐊᓂᔮᔨᐤᐦ ᐅᑖᔥᑎᒥᐦᒄ ᑭᔮᐦ ᐐᔨ ᐊᓂᑎᐦ ᒥᓯᓈᓲ᙮” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᔮᐦᒄ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᑖᓐ ᐊᓂᔮᔨᐤ ᐐᔨ ᑎᐱᔨᐙᐅᓯᑦ, ᑭᔮᐦ ᒫᒃ ᒥᔮᐦᒄ ᒋᔖᒥᓂᑑ ᑖᓐ ᐊᓂᔮᔨᐤ ᐐᔨ ᑎᐱᔨᐙᐅᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓂᐎᔨᒡ ᐱᔮᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᑎᑯᒡ, ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᑖᓐ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᑯᒡ, ᑳ ᓂᑭᑖᒡ, ᐋᒄ ᑳᐦ ᐋᑎ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐹᔨᑯᓃᔨᒡ ᐋ ᒌᔑᑳᔨᒡ ᓵᑎᔫᓰᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᒌᓴᔅ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᒥᔔ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᐙᔨᐤᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᑳ ᒦᓐ ᒑ ᐎᓂᔥᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ᒌᐦ ᐄᑎᑰ ᐊᓂᔮᔨᐤ ᓵᑎᔫᓰᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒧᓱᔅ ᒌ ᒥᓯᓂᐦᐋᒻ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐊᒀᑎᔥᑖᔨᒡ ᒫᒃ, ‘ᐴᓂᐱᒫᑎᓰᒑ ᓈᐹᐤ, ᐋᑳ ᒫᒃ ᐙᐦᒋ ᐃᔮᐙᒀ ᐊᐙᔑᔥ, ᐊᓂᔮ ᐐᒋᔖᓐ ᐊᓐ ᓈᐹᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ ᒋᐱᐦ ᐐᒋᒫᔨᐤ ᐊᓂᔮᔨᐤ ᐐᐤᐦ᙮ ᐋᒄ ᒫᒃ ᒋᐱᐦ ᐃᔮᐙᐅᒡ ᐊᐙᔑᔥ ᐊᓂᔮ ᐅᔅᑖᔅ ᒑ ᒌᐦ ᐅᐦᐱᓂᐦᑖᐅᒋᑎᒧᐙᑦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ᐋᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑎᐹᒋᒧᔥᑐᐙᒡ ᒌᓴᔅᐦ ᐊᓂᒌ ᓵᑎᔫᓰᒡ, “ᒌᐦ ᑖᐅᒡ ᐹᔨᒀᐤ ᓃᔣᔥᒡ ᓈᐹᐅᒡ ᐋ ᒌᐦ ᐐᒋᔖᓂᐦᑑᒡ᙮ ᐋᒄ ᐊᓐ ᑳ ᐅᔅᑖᓯᒫᐅᑦ ᑳ ᒋᐦᒋᐐᐙᑦ᙮ ᒌᐦ ᐴᓂᐱᒫᑎᓰᐤ ᒫᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐙᒡ ᐊᐙᔑᔥ᙮ ᐋᒄ ᐊᓂᔮ ᐐᒋᔖᓐᐦ ᑳ ᐅᐦᒋ ᑖᐦᒋᔥᑳᑯᑦ ᑳ ᒋᐦᒋᐐᔨᐐᒡ ᐊᓂᔮᔨᐤᐦ ᐐᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ᒑᒃ ᒫᒃ ᑭᔮᐦ ᐐᔨ ᐊᓐ ᐐᒋᔖᓂᒫᐤ ᑳ ᒋᐦᒋᐐᐆᑦ ᐊᓂᔮᔨᐤᐦ ᐐᒋᔖᓐᐦ ᐎᐐᔨᐤᐦ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ᓂᒧᐃ ᑭᔮᐦ ᐐᔨ ᐅᐦᒋ ᐃᔮᐙᐤ ᐊᐙᔑᔥ᙮ ᐋᒄ ᒦᓐ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᑖᐦᒋᔅᑳᑯᑦ ᐊᓐ ᐊᓅᐦᒡ ᑳ ᐴᓂᐱᒫᑎᓰᑦ ᑳ ᒋᐦᒋᐐᐐᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮ ᐋᔪᐎᒄ ᒧᔮᒻ ᑳᐦ ᐋᑎ ᐃᔅᐱᔨᒡ ᐊᓂᒌ ᓃᔣᔥᒡ ᐐᒋᔖᓂᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ᒑᒃ ᑭᔮᐦ ᐐᔨ ᐊᓐ ᐃᔅᒀᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᑎᐹᒋᒧᔥᑐᐙᒡ ᒌᓴᔅᐦ ᐊᓂᒌ ᓵᑎᔫᓰᒡ ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ, ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐎᓂᔥᑳᒡ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᐙᓐ ᒑ ᐐᐅᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, ᐙᔥ ᒥᓯᐙ ᐊᓂᒌ ᓃᔣᔥᒡ ᐐᒋᔖᓂᒫᐅᒡ ᒌᐦ ᐐᒋᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᐎᓂᐱᔨᓈᐙᐤ᙮ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ ᑭᔮᐦ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑎᒸᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ᐙᔥ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐎᓂᔥᑳᒡ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᑖᐹ ᑭᑎ ᐅᐦᒋ ᒋᐦᒋᐐᒋᑐᐎᒡ ᑭᔮᐦ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒋᐦᒋᐐᒋᑐᐦᐋᑭᓂᐎᒡ, ᐙᔥ ᐊᓂᔮᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐋᔪᐎᒄ ᒧᔮᒻ ᒑ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ᐋᒄ ᒫᒃ ᐊᓐ ᒑ ᐊᔨᒸᐦᐄᑯᔮᓐ ᒑ ᑎᑯᐦᒡ ᐊᐎᓂᔥᑳᐎᓅᒡ ᑳ ᐴᓂᐱᒫᑎᓰᓈᓅᒡ, ᓂᒧᐃ ᐋ ᑰᐦᒋ ᐊᔨᒥᐦᑖᓈᐙᐤ ᑳ ᐄᑎᑖᒄ ᒋᔖᒥᓂᑑ, ᒦᓐ ᒑ ᐎᓂᔥᑳᔨᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ᒋᔨᐤ, ‘ᐋᐅᒄ ᓃᔨ ᐅᒋᔖᒥᓂᑑᒧᐙᐤ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓵᒃ ᑭᔮᐦ ᒉᑭᑉ᙮’ ᐙᔥ ᑳᐦ ᐃᔨᑯᐱᓈ ᒋᔖᒥᓂᑑ ᐋᐦ ᐋᐅᑦ ᐙᒋᔖᒥᓂᑑᒥᑖᑯᑦ ᐊᓂᔮᔨᐤ ᔖᔥ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᓅᑯᓂᔨᐤ ᒫᒃ ᐋ ᐱᒫᑎᓰᔨᒡ᙮ ᒥᓯᐙ ᐊᐙᓐ ᐱᒫᑎᓰᐤ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ, ᓂᒧᐃ ᐴᓂᐱᒫᑎᓰᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐱᔮᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᐱᔮᐦᑎᐦᒡ ᐋ ᒌ ᒋᐱᑐᓈᐦᐙᔨᒡ ᒌᓴᔅᐦ ᐊᓂᔮ ᓵᑎᔫᓰᐦ, ᐋᒄ ᑳ ᓂᔥᑐᐐᒡ ᒫᒨ ᑳ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ᐹᔨᒄ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᐊᓂᒌ ᐹᕆᓰᒡ, ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐐᔓᐙᐎᓂᔨᐤ ᐋᐦ ᐄᑖᐱᑎᓰᑦ, ᒋᐐᐦ ᓈᓂᑐ ᑳᒋᔅᑎᓈᐤ ᒌᓴᔅᐦ, ᐋ ᑯᒀᒋᒫᑦ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐋ ᑎᐦᑎᐦᒡ ᐄᑎᔓᐙᐎᓐ ᒋᔖᒥᓂᑑ ᑳ ᐎᔨᔥᑖᑦ, ᑖᓐ ᐊᓐ ᒫᐅᒡ ᒑᔅᑖᔨᐦᑖᑯᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ ‘ᒋᑭ ᓵᒋᐦᐋᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᒋᔖᒥᓂᑑᒻ, ᒥᓯᐙ ᒋᑖᐦᐄᐦᒡ, ᑭᔮᐦ ᒥᓯᐙ ᒋᑎᐦᒑᐦᑯᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᒌ ᒥᑐᓈᔨᐦᒋᑭᓂᐦᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ᐋᐅᒄ ᐆ ᒫᐅᒡ ᓈᑳᓈᔨᐦᑖᑯᒡ ᑭᔮᐦ ᒫᐅᒡ ᒑᔅᑖᔨᐦᑖᑯᐦᒡ ᐄᑎᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ᐊᓐ ᒫᒃ ᐄᑎᔓᐙᐎᓐ ᒦᓐ ᒫᐅᒡ ᒑᔅᑖᔨᐦᑖᑯᐦᒡ ᐋᐅᒄ ᐆ ᑳ ᐄᑣᒥᑭᐦᒡ, ‘ᒋᑭ ᓵᒋᐦᐋᐤ ᒌᒋᐄᔨᔨᐤ ᒧᔮᒻ ᒌᔨ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ᐋᔪᐎᑯᓐᐦ ᒫᒃ ᐅᐦᐄ ᓃᔓ ᐄᑎᔓᐙᐎᓐᐦ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᓂᓈᑭᑎᐙᔨᐦᑎᒥᐦᐄᑯᐦᒄ ᐊᓂᔮᔨᐤᐦ ᒥᓯᐙᐦ ᒧᓱᔅᐦ ᐅᐐᔓᐙᐎᓂᔨᐤᐦ ᑳ ᒥᔮᑭᓅᑦ ᑭᔮᐦ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᐦᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ᒫᒀᒡ ᒫᒃ ᐋ ᐹᒋ ᒫᐅᓯᑯᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ, ᒌᓴᔅ ᒌ ᑯᒀᒋᒫᐤ, ");
INSERT INTO crl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ᑖᓐ ᐋ ᑖᔨᒫᒄ ᙭? ᐊᐙᓐ ᐊᓂᔮ ᐅᑯᓯᔅᐦ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᒌ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐤ ᐅᑯᓯᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᔨᐤ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐙᐦᒋ ᐃᔑᓂᐦᑳᑎᑯᑦ ᑌᕕᑦ? ᐙᔥ ᑌᕕᑦ, ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᒥᔨᑰ ᒑ ᒌᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᓂᑎᐹᔨᐦᒋᒑᒻ, ᐅᑖᐦ ᐹᒋ ᐊᐱᐦ ᓂᓂᐦᐄᐎᓂᐦᒡ ᐹᑎᔥ ᒌᐦ ᐃᔥᐱᔑᐦᐄᒀᐙ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᔅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ᐋᒄ ᒫᒃ ᑌᕕᑦ ‘ᓂᑎᐹᔨᐦᒋᒑᒻ’ ᐋ ᒌᐦ ᐃᔑᓂᐦᑳᑖᑦ ᐊᓂᔮᔨᐤᐦ ᙭ᐦ, ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ᓂᒧᐃ ᒫᒃ ᐊᐙᔨᐤᐦ ᐅᐦᒌ ᓂᔥᒀᐅᔑᐦᐄᑰ ᒌᓴᔅ᙮ ᐊᓂᑎᐦ ᒫᒃ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳᔑᑳᔨᒡ ᓂᒧᐃ ᒦᓐ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᑯᒋᐦᑖᔨᐤ ᒑ ᒌᐦ ᑯᒀᒋᒥᑯᑦ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ᐋᒄ ᒌᓴᔅ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒋᔅᑯᑎᒫᒑᐅᒡ ᒧᓱᔅᐦ ᐅᐐᔓᐙᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ᐋᐅᒄ ᒫᒃ ᐆ ᐅᐦᒋ, ᓂᓂᐦᐄᐦᑎᒸᐦᒄ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᑖᑯᒡ᙮ ᒥᒄ ᒫᒃ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᒋᔅᒋᓄᐙᐱᒫᐙᐅᒡ ᑖᓐ ᐋᐦ ᐄᑖᑎᓰᔨᒡ, ᐙᔥ ᑖᐹ ᑐᑎᒧᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑭᒑᔅᒀᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ᐱᑯᓵᔨᒫᐅᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑭᒑᔅᒀᒡ᙮ ᐋᔨᐦᑭᒥᐦᐋᐅᒡ ᐊᐙᔨᐤᐦ ᐋ ᑯᓯᑯᓃᔨᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᐱᒧᐦᑖᔨᒡ᙮ ᐋᔨᒥᐦᐄᑯᔨᐤ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᒌ ᐱᒧᐦᑖᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒥᑐᓐ ᐐᐦ ᐐᒋᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐋᔨᒥᐦᐄᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ᒥᓯᐙ ᒑᒀᔨᐤ ᑳᐦ ᑐᑎᐦᒡ ᐅᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐹᕆᓰᒡ ᐱᑯᓵᔨᐦᑎᒧᒡ ᒥᓯᐙᐦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐙᐱᒥᑯᒡ᙮ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᑖᔅᐱᓱᒡ ᓈᔥᒡ ᐋ ᑭᑳᓍᔨᒡ ᐋ ᔨᐙᐱᔨᒡ ᐅᑎᑯᐦᐱᐙᐤ ᑭᔮᐦ ᐋ ᑖᐱᔅᑭᐦᒡ ᒥᓯᓂᐦᐄᑭᓐ ᒥᐙᑦ ᐋ ᒥᒥᓵᔨᒡ, ᒌ ᐱᑯᓵᔨᐦᑎᒨᒡ ᒑ ᒌᐦ ᐄᑖᔨᒥᑯᒡ ᐊᐙᔨᐤᐦ ᓈᔥᒡ ᐋ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ᓂᑎᐙᔨᐦᑎᒧᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᐋ ᐹᐃᐦᑖᐱᒡ ᒑ ᒌᐦ ᐊᐱᐎᐦᐋᑭᓂᐎᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᒑ ᒌᐦ ᐊᐱᐎᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ᓂᑎᐙᔨᐦᑎᒧᒡ ᔮᔨᑖ ᒨᔥ ᒑ ᒌᐦ ᐅᐗᑎᓂᔅᒑᓈᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐋᐦ ᐋᑖᐙᓂᐎᔨᒡ ᑭᔮᐦ ᓂᑎᐙᔨᒫᐅᒡ ᐊᐙᔨᐤᐦ ‘ᒋᔅᑯᑎᒫᒑᓯᐤ’ ᒑ ᒌᐦ ᐃᔑᓂᐦᑳᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ᐊᑳᐐ ᒫᒃ ᐐ ᒌᔨᐙᐤ ᓂᑎᐙᔨᐦᑎᒧᒄ ‘ᒋᔅᑯᑎᒫᒑᓯᐤ’ ᒑ ᒌᐦ ᐃᔑᓂᐦᑳᑎᑯᐎᔮᒄ, ᐙᔥ ᒥᓯᐙ ᒋᐐᒋᔖᓂᓂᑐᓈᐙᐤ, ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐹᔨᑯᓯᐤ ᒌ ᒋᔅᑯᑎᒫᒑᓰᒧᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ᐊᑳᐐ ᑭᔮᐦ ᒋᑭ ᐅᐦᒋ ᐃᔑᓂᐦᑳᑖᐙᐤ ᐊᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ‘ᓅᐦᑖᐐᓈᓐ,’ ᐙᔥ ᒥᒄ ᐹᔨᑯᓯᐤ ᑰᐦᑖᐐᐙᐤ ᐋᐅᒄ ᐊᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ᐊᑳᐐ ᓂᑎᐙᔨᐦᑎᒧᒄ, ‘ᐅᒋᒫᐤ’ ᒑ ᒌᐦ ᐃᔑᓂᐦᑳᑎᑯᐎᔮᒄ, ᐙᔥ ᐹᔨᑯᓯᐤ ᒥᒄ ᑯᒋᒫᒧᐙᐤ, ᐋᐅᒄ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ᐊᐙᓐ ᐋ ᓃᑳᓈᔨᐦᑖᑯᔑᑦ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ, ᐋᑯᔥ ᒥᒄ ᐋᐱᒋᐦᐋᑭᓐ ᒋᑭ ᐄᔑ ᑭᓂᐙᐱᒥᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ᐙᔥ ᐊᓐ ᐊᐙᓐ ᑳ ᐐᐦ ᒋᑳᔮᔨᒥᑯᓰᑦ ᑭᑎ ᑎᑯᓂᔨᐤ ᑖᓐ ᒑ ᑐᑎᐙᑭᓅᑦ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᓃᐦᑖᔨᒥᑎᓲᑦ᙮ ᐊᓐ ᒫᒃ ᑳ ᑎᐱᐦᑖᔨᒦᓱᑦ ᐋᐅᒄ ᐊᓐ ᒥᔥᑏᐦ ᒑ ᐄᑖᔨᐦᑖᑯᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ, ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ, ᒌᔨᐙᐤ ᑳ ᑭᒑᐱᔅᑯᐙᑯᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐲᐦᒑᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ, ᐋᑳ ᒫᒃ ᐙᐙᒡ ᒑ ᒌ ᐲᐦᒑᔮᒄ ᒌᔨᐙᐤ᙮ ᓂᒧᐃ ᒌ ᐱᒋᔅᑎᓈᐙᐅᒡ ᐊᓂᒌ ᑳ ᐐᐦ ᐲᐦᒑᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᒑ ᒌ ᐲᐦᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ, ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᓈᔥᒡ ᒋᐐᐦ ᑯᐃᔅᑯᓈᑯᐦᐄᓱᓈᐙᐤ ᐊᓐ ᐅᐦᒋ ᓈᐅᔥ ᐋ ᐊᔨᒥᐦᐋᔮᒄ, ᒥᒄ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐅᑎᓂᒸᒄ ᒫᓐ ᑳ ᐹᐦᐹᔨᑯᒡ ᐃᔅᒀᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐋᑯᑖᐦ ᓅᑯᐦᒡ ᒋᐦᒋᐙ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ᙮ ᐆ ᒫᒃ ᑳ ᐄᔑ ᐄᐦᑐᑎᒫᒄ ᐊᑎᑎᐤ ᒌᔨᐙᐤ ᐋᒀᒡ ᒋᑭ ᑐᑖᑯᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ ᒥᒄ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᒥᓯᐙ ᐋᐦ ᐄᔥᐱᑎᔅᑭᒥᑳᒡ ᐆ ᐊᔅᒌ ᒋᑑᐦᑖᓈᐙᐤ ᐹᔨᒄ ᐊᐙᓐ ᒑ ᒌᐦ ᑐᑎᐙᒄ ᒑ ᒌ ᑖᑆᐦᑖᑖᒄ ᑭᔮᐦ ᒫᒃ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᐙᒄ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓯᑯᒋᒫᐦᒄ ᒌᐦ ᐃᔨᐦᑑᑎᐙᐙᐤ ᓃᔣ ᒦᓐ ᒑ ᒌᐦ ᐃᔥᐱᔥ ᒥᒋᐦᑐᑎᐦᒃ ᒌᔨᐙᐤ ᐋ ᐄᔑ ᒥᒋᐄᐦᑑᑎᒸᒄ, ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐄᑐᐦᑖᑦ ᒥᒋᔥᑯᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᒧᔮᒻ ᐋᑳ ᑳ ᐙᐱᐦᑎᒫᒄ ᑳ ᐃᓯᓈᑯᓱᔮᒄ ᐊᔮᐱᒡ ᒫᒃ ᑳ ᐐᐦ ᒋᔅᒋᓄᐦᑎᐦᐋᑯᒡ ᐄᔨᔨᐅᒡ᙮ ᒋᔑᓈᐙᐤ, ‘ᐊᐙᓐ ᐋ ᐐᐦ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒑ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᒑᒀᔨᐤ, ᐊᓂᑖᐦ ᒫᒃ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᐄᔑ ᑖᑆᑦ ᐊᓂᔮᔨᐤ, ᓂᒧᐃ ᓂᑎᐙᔨᐦᑖᑯᓲ ᔮᔨᑖ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒑ ᑐᑎᐦᒃ᙮ ᐊᐙᓐ ᒫᒃ ᐋ ᐐᐦ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒑ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᒑᒀᔨᐤ ᐊᓂᑖᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᔖᐅᔔᐎᔮᓈᐱᔅᒄ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐄᔑ ᑖᑆᒑ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᔮᔨᑖ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐃᔨᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ᒌᔨᐙᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒫᒄ ᑳ ᐃᓯᓈᑯᓱᔮᒄ, ᑖᑆᐦ ᓂᒧᐃ ᒋᒌ ᓂᔅᑐᐦᑖᓈᐙᐤ᙮ ᑖᓐ ᐊᐅᔅᑖ ᒑᔅᑖᔨᐦᑖᑯᐦᒡ, ᐊᓐ ᐅᔖᐅᔔᐎᔮᓈᐱᔅᒄ ᑭᔮᐦ ᒫᒃ ᐊᓐ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᐊᓂᑖᐦ ᐙᐦᒋ ᐱᔮᐦᒑᔨᐦᑖᑯᓯᑦ ᐊᓐ ᐅᔖᐅᔔᐎᔮᓈᐱᔅᒄ? ");
INSERT INTO crl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ᒋᔑᓈᐙᐤ ᑭᔮᐦ, ᐊᐙᓐ ᐋ ᐐᐦ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒑ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᔨᐤ᙮ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐅᐦᒋ, ᓂᒧᐃ ᓂᑎᐙᔨᐦᑖᑯᓲ ᔮᔨᑖ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒑ ᑐᑎᐦᒃ᙮ ᑭᔮᐦ ᒋᔑᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᐋ ᐐᐦ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒑ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑᐦ ᒑᒀᔨᐤᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ ᐊᓂᑎᐦ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ ᑳ ᐊᔥᑖᑭᓂᐎᔨᒡ ᐄᔑ ᑖᑆᒑ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᔮᔨᑖ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒑ ᑐᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ᒌᔨᐙᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒫᒄ ᑳ ᐃᓯᓈᑯᓱᔮᒄ, ᑖᓐ ᐊᐅᔅᑖ ᒑᔅᑖᔨᐦᑖᑯᐦᒡ, ᐊᓐ ᐋ ᒥᔨᐙᐎᓐ ᑭᔮᐦ ᒫᒃ ᐊᓐ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᒄ? ᐙᔥ ᐋ ᐊᔥᑖᑭᓂᐐᒡ ᒥᔨᐙᐎᓐ ᐊᓂᑎᐦ ᐊᓐ ᑳ ᒌ ᐱᒋᔅᑎᓂᒧᐙᑭᓅᑦ ᒋᔖᒥᓂᑑᐦ ᒑᒀᔨᐤ, ᐋᑯᑖᐦ ᒥᒄ ᐙᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᐦᒡ ᐊᓐ ᒥᔨᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ᐊᐙᓐ ᒫᒃ ᐋ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒑ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑᐦ ᒑᒀᔨᐤ ᐊᓂᑖᐦ ᐄᔑ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ, ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐊᔥᑖᔨᒡ ᐊᓂᑖᐦ ᐋᑯᑖᐦ ᑭᔮᐦ ᐋ ᐄᔑ ᓈᔅᐱᒋᔅᑖᑆᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ᐋᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐄᔑ, ᒋᔖᒥᓂᑑᐦ ᐋᐦ ᑖᔨᒡ ᐄᔑ ᓈᔅᐱᒋᔅᑖᑆᐤ, ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ᐊᓐ ᐊᐙᓐ ᑳ ᓈᔅᐱᒋᔅᑖᑆᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ, ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐤᐦ ᑖᐦᑎᐴᐎᓃᔨᒡᐦ ᐄᔑ ᓈᔅᐱᒋᔅᑖᑆᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᓂᑎᐦ ᑳ ᑖᐦᑎᐱᔨᒡ ᐋᑯᑖᐦ ᐋ ᐄᔑ ᓈᔅᐱᒋᔅᑖᑆᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ᙮ ᐋᐅᒄ ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᒫᔮᐦᒄ ᐱᒋᔅᑎᓂᒑᐎᓂᔨᐤ ᒋᔖᒥᓂᑑᐦ, ᓈᔥᒡ ᔮᒀᐦ ᒋᓈᓈᑭᒋᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐱᑯᓵᔨᐦᑖᑯᓯᔮᒄ ᒑ ᐄᔥᐱᔥ ᐱᐦᒀᓂᒧᐙᒄ ᓂᓈᐦᑭᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓂᔥ ᑳ ᓂᐦᑖᐅᒋᐦᑖᔮᒄ ᒧᔮᒻ ᐊᓂᐦᐄ ᒥᓂᑦ, ᑎᓪ ᑭᔮᐦ ᑰᒥᓐ ᑳ ᐃᔑᓂᐦᑳᑖᐦᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᒋᑎ ᐃᔮᐱᑖᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᐊᓂᐦᐄ ᑳ ᒋᔅᑎᒋᑖᑯᐦᒡ ᒋᔅᑯᑎᒫᒑᐎᓐ ᐊᓂᑖᐦ ᐐᔓᐙᐎᓂᐦᒡ ᑳᐦ ᐋᔨᒨᑖᐦᒡ, ᒸᐦᒡ ᑯᐃᔅᒄ ᑎᐹᔅᑯᓂᒑᐎᓐ, ᒋᔅᑎᒫᒑᔨᒧᐙᐎᓐ ᑭᔮᐦ ᑖᑆᐅᒑᔨᐦᑖᑰᓰᐎᓐ᙮ ᐋᐅᒄ ᐆ ᓃᔥᑎᒻ ᔮᔨᑖ ᒋᐱᐦ ᐐᐦ ᐄᔑ ᓂᓈᑭᑎᐙᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᒑ ᒌᐦ ᑐᑎᒫᒄ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐱᐦᒀᓂᒧᐙᒄ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ᒌᔨᐙᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ ᑳ ᐃᓯᓈᑯᓱᔮᒄ, ᐋᑳ ᑳ ᒥᑐᓐ ᓂᔅᑐᐦᑎᒫᒄ, ᐊᔮᐱᒡ ᐋ ᐐᐦ ᒋᔅᒋᓄᐦᑎᐦᐋᑯᒡ ᐄᔨᔨᐅᒡ᙮ ᒧᔮᒻ ᐊᐙᓐ ᓈᔥᒡ ᔮᒀᐦ ᑳᐦ ᑎᒃ ᒑ ᒌᐦ ᓯᑯᐙᔮᔅᑯᒋᑰᓈᑦ ᒥᓂᑐᔥ ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᐋ ᑰᐦᒋᐱᐦᐋᑦ ᑳᒥᓪ, ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᓈᔥᒡ ᔮᒀᐦ ᐋ ᐄᔑ ᐱᔮᐦᒋᐦᑖᔮᒄ ᐅᔅᒋ ᑰᔮᑭᓂᐙᐤ ᑭᔮᐦ ᒋᒥᓂᐦᒀᑭᓂᐙᐤ ᐋᐦᐋᑳ ᒫᒃ ᐱᔮᐦᒋᐦᑖᔮᒄ ᐊᓂᑖᐦ ᐲᐦᒡ᙮ ᐋᐅᒄ ᐋᔑᓈᑯᐦᐄᓱᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᓈᔥᒡ ᐋ ᒥᔪᓈᑯᐦᐄᓱᔮᒄ ᐊᓂᑖᐦ ᐅᔅᒋ, ᒥᒄ ᒫᒃ ᐊᓂᑖᐦ ᐲᐦᒡ ᒋᑎᐃᑖᑎᓰᐎᓂᐙᐦᒡ ᓂᒧᐃ ᒋᒥᔪᓈᑯᓯᓈᐙᐤ ᐋ ᐃᔥᐱᔥ ᐙᓵ ᐙᔫᒋᐱᔨᐦᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᓂᓈᑭᑐᐙᔨᒦᓱᔮᒄ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᒫᔮᒋᓂᑎᐙᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ᒌᔨᐙᐤ ᐹᕆᓰᒡ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ, ᓃᔥᑎᒻ ᐊᓂᑖᐦ ᐲᐦᒡ ᒋᐱᐦ ᐱᔮᐦᒋᐦᑖᓈᐙᐤ ᐊᓂᐦᐄ ᒋᒥᓂᐦᒀᑭᓂᐙᐤ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒥᑐᓐ ᒑ ᐱᔮᐦᑳᐱᔅᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ ᒥᒄ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᒧᔮᒻ ᒌᐲᑭᒥᑯᐦᑳᓐ ᐊᓂᑎᐦ ᐅᔅᒋᒡ ᓈᔥᒡ ᐋ ᒥᔪᓈᑯᐦᑖᑭᓂᐐᒡ ᐋᒄ ᒥᒄ ᐊᓂᑖᐦ ᐲᐦᒡ ᐱᔑᔑᐦᒄ ᓂᐱᐎᓐ ᑭᔮᐦ ᐋ ᐐᓈᒡ ᒑᒀᓐ ᐋ ᐃᓯᓈᑯᐦᒡ ᐋᐅᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ ᒌ ᐱᒫᑎᓰᐎᓂᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ᐋᐅᒄ ᑖᑆᐦ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᔮᒄ᙮ ᓈᔥᒡ ᒋᒥᔪᓈᑯᓯᓈᐙᐤ ᐅᔅᒋᒡ ᐊᓂᑎᐦ ᐋ ᑭᓄᐙᐱᒧᑯᔮᒄ ᒥᒄ ᐲᐦᒡ ᐊᓂᑖᐦ ᒌᔮᐙᐦᒡ ᐱᔑᔑᐦᒄ ᓂᓂᑎᔫᓐ ᑭᔮᐦ ᒥᒋᐦᑐᑎᒧᐎᓐ ᒋᑎᓯᓈᑯᓯᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ, ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ᙮ ᓈᔥᒡ ᒋᒌ ᒥᔪᐦᑖᓈᐙᐤ ᐊᓂᑎᐦ ᑳ ᓂᐦᐄᑭᐙᑭᓂᐎᒡ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ, ᑭᔮᐦ ᒋᒌ ᐙᐙᔑᐦᑖᐙᓈᐙᐤ ᐅᒌᐹᐃᑭᒥᑯᐙᐤ ᐊᓂᒌ ᑯᐃᔅᒄ ᑳ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ᐋᔨᐤᐦ ᒫᒃ ᒋᔑᓈᐙᐤ, ᒌ ᐱᒫᑎᓰᔮᐦᒡ ᒫᒀᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᐦᑳ ᐋᓂᔅᒑ ᓂᑖᓂᔅᑰᓯᒥᓈᓂᒡ, ᐊᑐᒡ ᐐ ᓂᐱᐦ ᐅᐦᒋ ᑎᐙᓈᓐ ᐊᓂᔮᔨᐤᐦ ᑳᐦ ᐋᔨᑐᐙᑯᐱᓈ, ᑳ ᓂᐱᐦᐋᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ᐋᑯᑖᐦ ᒫᒃ ᒥᑐᓐ ᑖᐹᒋᒥᓱᔮᒄ ᑖᑆᐦ ᐋ ᒌᐦ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔮᒄ ᐊᓂᑖᐦ ᐅᐦᒋ ᐊᓂᔮᐦᑳ ᑳ ᓂᐱᐦᐋᒡ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ᐋᐅᒄ ᑭᔨᑆ ᒑ ᐐᐦ ᑎᔮᒄ, ᒌᔑᐦᑖᐙᐦᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒫᔮᒡ ᒋᐦᒋᐱᔨᐦᑖᒡ ᐊᓂᔮᐦᑳ ᐋᓂᔅᒑ ᒋᐙᐦᑯᒫᑭᓄᐙᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ᒌᔨᐙᐤ ᐊᒋᓈᐳᑯᒡ ᑭᔮᐦ ᑳ ᐅᑯᓰᑐᑖᑖᑯᒡ ᐊᒋᓈᐳᑯᒡ ᓈᔥᒡ ᑳ ᑭᔅᒋᐦᐆᔮᒄ ᓂᑎᐐ ᒥᒄ ᐋ ᐄᔑ ᑭᒋᔑᒫᑯᒡ ᐄᔨᔨᐅᒡ,ᐦ ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐱᑯᐦᐅᔮᒄ ᐋᑳ ᒑ ᒌᐦ ᐄᑐᐦᑖᔮᒄ ᒥᒋᔥᑯᑖᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐄᑎᑯᒡ, ᓂᑭ ᐹᒋ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᑭᔮᐦ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐊᔮᐱᒡ ᒫᒃ ᐙᔥ ᐋᐅᒄ ᒑ ᐃᓯᓈᑯᓱᔮᒄ ᐋ ᓂᐱᐦᐋᑯᒡ ᐱᔅᒡ, ᑯᑎᑭᒡ ᐋ ᒌᔅᑖᔅᑯᐦᐙᑯᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᑭᔮᐦ ᑯᑎᑭᒡ ᐋ ᐱᐱᓯᔅᑖᐦᐙᑯᒡ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋᐦ ᐄᑖᒧᐦᒑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ᒌᔨᐙᐤ ᒫᒃ ᒋᑭ ᐋᓂᔅᒑ ᒫᐦᑯᔥᑳᑯᐙᓈᐙᐤ ᑖᓐ ᒑ ᐄᔑ ᐎᔮᔅ ᑐᑖᐦᒡ ᐊᓂᒌ ᑳ ᓂᐱᐦᐋᒡ ᒥᓯᐙ ᐊᓂᔮᐦ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡᐦ ᐊᐙᔨᐤᐦ, ᐁᐱᓪ ᐋᐦ ᑖᑦ ᐅᐦᒋ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᓵᑳᕌᔮ, ᐹᕋᑭᔮ ᐅᑯᓯᔅᐦ᙮ ᓵᑳᕌᔮ ᒫᒃ ᒋᔥᑎᐅᒡ ᐊᓂᔮᔨᐤ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᔨᐤ᙮ ᐊᓂᑎᐦ ᒫᒃ ᒫᐅᒡ ᐋ ᐱᔮᐦᒑᔨᐦᑖᑯᐦᒡ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᐋᑯᑖᐦ ᑳ ᓂᐱᐦᐄᑯᑦ ᐊᓂᔮ ᐋᓂᔅᒑ ᒋᐙᐦᑰᒫᑭᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ᐋᐦᐋ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑭᔮᐦ ᒌᔨᐙᐤ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔮᒄ ᒋᑭ ᐋᓂᔅᒑ ᒫᐦᑯᔥᑳᑯᐙᓈᐙᐤ ᑖᓐ ᒑ ᐄᔑ ᐎᔮᔅ ᑐᑎᐙᑭᓂᐎᒡ ᐅᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ᒌᔨᐙᐤ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔮᒄ, ᑳ ᓂᐱᐦᐋᑯᒡ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᑳ ᐹᐦᐱᒧᓯᓈᑎᐦᐆᒫᐦᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑᐦ ᑳ ᐹᒋ ᐄᑎᔑᐦᐊᒫᑖᒄ, ᑖᓐ ᑎᐦᑐ ᑳ ᐐᐦ ᒫᐅᓱᑯᐱᑎᑯᒡ ᐊᓂᑖᐦ ᐄᔑ ᐋᐦ ᑖᔮᓐ, ᒧᔮᒻ ᐹᐦᑭᐦᐋᐦᒀᓐ ᐋᐦ ᑐᑎᐙᑦ ᐅᐹᑭᐦᐋᐦᒀᓂᔒᒻ, ᔒᐹ ᐅᑎᐦᑭᑯᓂᐦᒡ ᐋ ᐄᔑ ᒫᐅᓱᑯᓈᑦ ᐋ ᐐᐦ ᓈᓈᑭᒋᐦᐋᑦ᙮ ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᑳ ᐐᐦ ᑐᑖᑎᑯᒡ᙮ ᒥᒄ ᓂᒧᐃ ᑰᐦᒋ ᐱᒋᔅᑎᓈᐙᐤ ᐆ ᒑ ᒌᐦ ᑐᑖᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ᓂᑎᐦᑎᒧᒄ ᒫᐦ, ᒋᑭ ᓂᑭᑎᒫᑯᓈᐙᐤ ᒋᐦᒋᐙ ᒥᑐᓐ ᐋ ᐱᓯᒀᒡ ᑭᔮᐦ ᐋ ᓂᔑᐎᓈᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ᐙᔥ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᒧᐃ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᐙᐱᒥᓈᐙᐤ ᐹᑎᔥ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐃᔨᔮᒄ, ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᑳ ᐹᒋ ᑎᑯᔑᐦᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐋᐦ ᐋᑎ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐅᐦᒋ, ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋ ᐐᐦ ᐙᐱᐦᑏᑯᑦ ᑖᓐ ᑳ ᐃᓯᓈᑯᐦᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓐ ᐙᔅᑳ ᐊᓂᑎᐦ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᒋᒥᔪᓈᓈᐙᐤ ᑖᓐ ᑳ ᐃᓯᓈᑯᑖᑭᓂᐎᔨᒡ ᐅᐦᐄ ᐙᔅᑳᐦᐄᑭᓐ, ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᒥᓯᐙ ᒑ ᓂᔑᐎᓈᒋᐦᑖᑭᓄᐐᒡ᙮ ᓂᒧᐃ ᐙᒋ ᐹᔨᒄ ᐊᓯᓃ ᒋᑭ ᐅᐦᒋ ᐋᐦᑯᐃᐦᑎᐎᐱᐤ ᑯᑎᒃ ᐊᓯᓃ ᑖᓂᔮᔨᐤ ᑳ ᐄᑎᐦᐋᑭᓅᑦ᙮ ᒥᓯᐙ ᐊᓯᓃᔨᒡ ᑳᐦ ᐋᐱᑎᔒᒡ ᑳ ᐅᔑᐦᑖᑭᓂᐎᒡ ᐅᐦᐄ ᐙᔅᑳᐦᐄᑭᓐ ᒋᑭ ᓃᐦᔑᐙᐱᓈᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋ ᐊᐱᑦ ᐊᓂᑎᐦ ᐋ ᐃᔅᐱᑖᐅᐦᑳᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐄᔥᐱᐦ ᐋᑳ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ, ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᒫᐦ ᑖᔨᔥᐱᔥ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ? ᑖᓂᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᐋᓐ ᐙᐱᐦᑏᐙᐎᓐ ᐅᑎᐦᒋᐱᔨᒑ ᒦᓐ ᒑ ᑎᑯᔑᓃᔨᓐ? ᑭᔮᐦ ᒫᒃ ᑖᓂᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᒑ ᐃᔅᒀᐱᔨᒡ ᐊᔅᒌ?” ");
INSERT INTO crl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᔮᒀᒦᒄ, ᐋᑳ ᐊᐙᓐ ᒑ ᒌ ᑳᒌᔑᐦᐄᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ᐙᔥ ᒋᑭ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐋ ᑎᑯᔑᐦᒡ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ ᐋᐦ ᐃᔨᒡ, ‘ᐋᐅᒄ ᓃᔨ ᙭’᙮ ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒋᑭ ᑳᒌᔑᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ᐊᑳᐐ ᑭᔮᐦ ᒋᑭ ᐅᐦᒋ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᐹᐦᑎᒫᒀ ᐋ ᒥᑣᓂᑐᐱᔨᓈᓂᐎᒡ ᐹᔓᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔮᒄ ᑭᔮᐦ ᐹᐦᑎᒫᒀ ᐋ ᑎᐹᑖᑭᓂᐎᒡ ᐋ ᓂᓂᑐᐱᔨᓈᓂᐎᒡ ᐊᓂᑖᐦ ᐙᐦᔨᐤ᙮ ᐋᐅᒄ ᐙᔥ ᐆ ᓃᔥᑎᒻ ᓈᑎᐙᔨᐦᑖᑯᐦᒡ ᒑ ᒌᐦ ᐄᔅᐱᔨᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐋᔥᒄ ᑭᑎ ᐅᐦᒋ ᐃᔅᒀᐱᔨᐤ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ᐹᔨᑯᓂᐦᒡ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᑭᑎ ᒫᓯᐦᐄᑑᒡ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐃᔨᐦᒡ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡᐦ᙮ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᐦᒋᐅᒋᒫᐅᒡ ᑭᑎ ᓂᑐᐱᔨᐦᑭᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃ ᑳ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ᙮ ᒋᑭ ᑎᑯᓐ ᐋ ᑯᐃᐦᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᑭᐎᐦᑭᑖᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ᐄᔥᐱᐦ ᒫᒃ ᒋᐦᒋᐱᔨᐦᒑ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᒥᓯᐙ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᐋᐅᒄ ᐱᒑᐃᒃ ᒑ ᒋᐦᒋᐱᔨᒡ ᓂᓈᐦᑳᑖᔨᒧᐎᓐ, ᒧᔮᒻ ᐃᔅᒀᐤ ᐋ ᒋᐦᒋ ᒨᔑᐦᐅᑦ ᒑ ᐋᐦᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ᐋᒄ ᒫᒃ ᒑ ᐅᑎᓂᑯᔮᒄ ᑭᔮᐦ ᒋᑭ ᓂᓈᐦᑳᒋᐦᐄᑯᓈᐙᐤ᙮ ᐙᐙᒡ ᒋᑭ ᓂᐱᐦᐄᑯᓈᐙᐤ᙮ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᒋᑭ ᐅᐦᑳᑎᑯᐙᐅᒡ ᐋ ᓅᔔᔥᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ᒥᐦᒑᑐ ᒫᒃ ᒋᑭ ᐴᓃᐅᒡ ᐋ ᑖᑆᔮᔨᒥᒡ ᑭᔮᐦ ᒋᑭ ᒫᒥᔑᒥᑯᐙᐎᒡ ᑭᔮᐦ ᒋᑭ ᐅᐦᑳᑐᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ᒥᐦᒑᑐ ᒥᒋᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒋᑭ ᑎᑯᔑᓂᒡ ᒑ ᑳᒌᔑᐦᐋᒡ ᐊᐙᔨᐤᐦ, ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒋᑭᑐᑎᐙᐅᒡ ᒑ ᒌᐦ ᐴᓃᔨᒡ ᐋ ᑖᑆᐦᑎᒥᔨᒡ ᑖᑆᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ᒑ ᐃᔥᐱᔥ ᒫᒃ ᓈᓈᓂᒌᒻ ᐙᔪᑎᐦᒡ ᒥᒑᑎᓰᐎᓐ, ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐅᓵᒋᐦᐄᐙᐎᓂᐙᐤ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑖᑎᔅᐱᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᒑ ᔮᐃᒋᑳᐳᒀ ᒑ ᐃᔥᐱᔥ ᐱᒫᑎᓰᑦ ᐋᐅᒄ ᒑ ᐱᒫᒋᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ᐆ ᒫᒃ ᒥᔻᒋᒧᐎᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᑳ ᑎᐹᑐᑖᔨᒡ ᒋᑭ ᑭᒑᔅᒀᓂᐤ ᐅᑎᐦ ᒥᓯᐙ ᐊᔅᐱᒋᔅᑭᒥᑳᒡ ᐊᔅᒌ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒌ ᐹᐦᑎᐦᒃ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᐃᔅᒀᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ᐄᔥᐱᐦ ᒫᒃ ᐙᐱᒫᒀ ᐊᓐ ᐊᐙᓐ ᒫᐅᒡ ᑳ ᐅᐦᑳᑖᔮᔨᐦᑖᑯᓯᑦ ᐋ ᓃᐴᐎᑦ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᐱᔮᐦᑭᓃᔨᒡ ᐋ ᒫᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑖᓂᔮᓪ ᑳᐦ ᐋᔨᒨᒫᑯᐱᓈ᙮ ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᑖᔮᒄ ᐆ ᓲᐦᒃ ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ ᑖᓐ ᐋᑣᒥᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ᐙᐱᐦᑎᒫᒀ ᒫᒃ ᐆ ᐋᐦ ᐄᔅᐱᔨᒡ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ, ᐋᑯᔥ ᐊᓂᑖᐦ ᐋᐦ ᐋᐱᔅᑯᑎᓈᔨᒡ ᑭᑎ ᐄᑎᔓᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ᑭᔮᐦ ᐊᓐ ᐊᐙᓐ ᑎᐦᑯᐦᒡ ᐐᒋᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐐ ᑭᑎ ᓃᐦᑎᒋᐙᐤ ᒑ ᒌ ᐲᐦᒑᑦ ᐅᐙᔅᑳᐦᐄᑭᓂᒦᐦᒡ ᒑ ᒌ ᓂᑎᐙᐱᐦᑎᐦᒃ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ᑭᔮᐦ ᐊᓐ ᐊᐙᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐐ ᑭᑎ ᒌᐙᐤ ᐅᑎᑯᐦᑉ ᐋ ᐐ ᓂᑎᐙᐱᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ᑖᑆᐦ ᑭᑎ ᐋᔨᒥᐦᐅᒡ ᐊᓂᒌ ᒫᒀᒡ ᑳ ᒌᒋᔥᑯᐙᒡ ᐊᐙᔑᔥ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓅᔖᓂᐦᐋᐅᓱᒡ ᐊᓂᔮᔨᐤ ᒑ ᒌᔑᑳᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ᐊᔨᒥᐦᐋᒄ ᐋᑳ ᒫᒀᒡ ᐋ ᒫᒀᐱᐳᐦᒡ ᒑ ᒌᐦ ᐄᔅᐱᔨᒡ ᐆ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᓂᐦᐋᐤ ᐊᓂᑎᐦ ᐋ ᐊᔨᒥᐦᐋᐆᒌᔑᑳᒡ ᒑ ᒌᐦ ᐄᔅᐱᔨᒡ ᐆ ᒫᒀᒡ ᐐᐦ ᐅᔑᒧᔮᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ᐙᔥ ᐋᑯᑖᐦ ᐅᑎᐦ ᒫᐅᒡ ᒑ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᒡ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐃᔥᐱᔥ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓐ ᑖᓐ ᓂᐦᐋᐤ ᒑ ᐄᑖᔨᐦᑖᑯᐦᒡ ᐆ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌᐦ ᐎᔮᔨᐦᑎᒻ ᒑ ᐊᒋᐎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᔨᒡ ᐊᓂᑎᐦ ᒑ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᔨᑯᐱᓈ᙮ ᐋᑳ ᐅᐦᒋ ᑐᑎᒧᑯᐱᓈ ᐅᔮᔨᐤ ᓂᒧᐃ ᐊᐙᓐ ᒋᐱᐦ ᐅᐦᒌ ᔖᐳᔥᑭᒻ᙮ ᒥᒄ ᒫᒃ ᐋ ᒋᔅᒋᓰᑐᑎᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᐅᑎᔨᔨᒻᐦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒑ ᐅᐦᒋ ᐊᒋᐎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ᐋᑯᑖᐦ ᒫᒃ ᐊᓐ ᒫᒀᒡ, ᒥᔔ ᐊᐙᓐ ᐄᑎᑖᒀ, ‘ᐄᑖᐱᒄ ᒫᐦ, ᐋᐅᒄ ᐙᔥ ᐆ ᙭,’ ᑭᔮᐦ ᒫᒃ ᐄᑎᑖᒀ, ‘ᒸᓐ ᙭’, ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᑖᑆᐦᑎᐙᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ᑭᑎ ᑖᐅᒡ ᐄᔨᔨᐅᒡ ᐋ ᑳᒌᔑᐦᐄᐙᒡ ᐋᐦ ᐃᔨᒡ, ‘ᐋᐅᒄ ᓃᔨ ᙭’᙮ ᑭᑎ ᑖᐅᒡ ᑭᔮᐦ ᒥᒋᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᓂᓈᐦᑭᐤ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᒑ ᐙᐱᐦᑎᔨᐙᒡ ᑭᔮᐦ ᑭᑎ ᑐᑎᒧᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᔨᒡ ᒑᒀᔨᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᐅᐦᒋ ᑳᒌᔑᐦᐋᒡ ᐊᐙᔨᐤᐦ ᓂᑎᐐ ᒥᒄ ᒑ ᒌᐦ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ᙮ ᐙᐙᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒫᔨᒡ ᐊᐙᔨᐤᐦ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒑ ᐐᐦ ᑳᒌᔑᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ᓂᑐᐦᑎᐎᒄ ᒫᒃ, ᐙᔥ ᔖᔥ ᓂᔮᑭᓐᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“ᐄᑎᑖᑯᒑ ᒫᒃ ᐄᔨᔨᐅᒡ, ‘ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ ᙭, ᓈᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐋᑯᑖᐦ ᐋᐦ ᑖᑦ,’ ᐊᑳᐐ ᐄᑐᐦᑖᐙᐦᒄ ᐊᓂᑖᐦ᙮ ᑭᔮᐦ ᒫᒃ ᐄᑎᑖᑯᒑ, ‘ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ, ᒫᐅᑖ ᐲᐦᑎᑭᒥᐦᒡ ᐋᐦ ᑖᑦ,’ ᐊᑳᐐ ᑖᑆᐦᑎᐙᐦᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ᐙᔥ ᐄᔥᐱᐦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑎᑯᔑᐦᑳ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᑭᑎ ᐙᐱᒥᑰ᙮ ᒧᔮᒻ ᐋ ᐃᔥᐱᔥ ᒌᐦᑳᓈᑯᐦᒡ ᐋ ᐙᔥᑖᐱᔨᐦᒡ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ, ᐊᓂᑖᐦ ᐙᐱᓅᑖᐦᒡ ᐋ ᐅᐦᒋ ᓅᑯᐦᒡ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᐊᒋᔥᑑ, ᐋᐅᒄ ᒑ ᐃᓯᓈᑯᓃᔨᒡ ᑎᑯᔑᐦᑳ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ᐄᔥᐱᐦ ᒫᒃ ᐙᐱᐦᑎᒫᒀ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ ᐋᒄ ᒑ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐋ ᐹᔓᓈᑯᐦᒡ ᒑ ᐃᔅᒀᐱᔨᒡ ᐊᔅᒌ, ᒧᔮᒻ ᐊᓂᑖᐦ ᐋ ᓅᑯᓯᒡ ᑳᐦᑳᒎᒡ ᐋ ᒥᐦᒑᑎᒡ ᒋᔅᒑᔨᐦᑖᑯᓂᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᒑᒀᔨᐤ ᐋ ᓂᐲᒥᑭᓃᔨᒡ ᐊᓂᑎᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ᐄᔥᐱᐦ ᒫᒃ ᒥᔮᐅᐱᔨᐦᒑ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᐋᔨᒥᐦᒡ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᑎ ᒌᔑᑳᒡ, ᐋᐅᒄ ᑏᐙᐦᒡ ᒑ ᐋᑎ ᐃᔅᐱᔨᒡ, ᐲᓯᒻ ᒋᑭ ᑎᐱᔅᒋᐱᔨᐤ, ᑭᔮᐦ ᑎᐱᔅᒋᐲᓯᒻ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒋᐦᑳᔮᔥᑎᐙᐤ, ᑭᔮᐦ ᐊᒋᐦᑯᔑᒡ ᑭᑎ ᐹᐦᐱᐦᒋᔑᓂᒡ ᒌᔑᑯᐦᒡ ᐅᐦᒋ ᑭᔮᐦ ᒥᓯᐙ ᒑᒀᓐ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᑭᑎ ᐋᐦᒋᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ᐋᒄ ᒫᒃ ᒑ ᓅᑯᓃᔨᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ ᔖᔥ ᐋ ᐹᒋ ᑎᑯᔑᐦᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ ᑭᑎ ᒫᑑᒡ᙮ ᑭᑎ ᐙᐱᒫᐅᒡ ᒫᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐹᒋ ᔮᓰᔨᒡ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ, ᒥᓯᐦᑖ ᐋ ᓅᑯᓃᔨᒡ ᐅᓲᐦᑳᑎᓰᐎᓐ ᑭᔮᐦ ᐆ ᒥᔥᑎᐦ ᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ᐄᔥᐱᐦ ᒫᒃ ᐹᐦᑖᑯᐦᒑ ᑳ ᒋᔣᐙᒥᑭᐦᒡ ᐴᑖᒋᑭᓐ ᐋᒄ ᒑ ᐄᑎᔑᐦᐙᑦ ᒋᔖᒥᓂᑑ ᐅᑖᓐᒋᓂᒻᐦ ᒑ ᒌ ᓂᑑᓂᔥᑑᓈᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐅᐙᔮᐱᒫᑦ ᓈᐙᔨᒡ ᐋ ᐅᐦᒌ ᔪᐙᔨᒡ ᑳ ᐅᐦᒌᔨᒡ᙮ ᒥᑐᓐ ᐋᐦ ᐄᔥᒀᔮᔨᒡ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᒥᑐᓐ ᐋᐦ ᐄᔥᒀᔮᔨᒡ ᒋᐦᒋᒌᔑᑯᔨᐤ ᑭᑎ ᐅᐦᑎᓈᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ᑎᑯᓐ ᒑᒀᓐ ᒑ ᒌ ᒋᔅᑯᑎᒫᓱᔮᒄ ᒥᓯᔔᒥᓈᐦᑎᒄ ᐋ ᑭᓂᐙᐱᒫᒄ᙮ ᐄᔥᐱᐦ ᐋᐦ ᐋᑎ ᐅᔅᒋᓂᐦᑖᐅᒋᓃᔨᒡ ᐅᑎᐦᑯᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᓃᐲᓯᐎᑦ, ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᔖᔥ ᐐᐱᒡ ᒑ ᓃᐱᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ᐅᐦᐄ ᒫᒃ ᒑᒀᓂᐦᐄ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ ᒑ ᐄᔅᐱᔨᔨᒡ ᐄᔥᐱᐦ ᐄᔅᐱᔨᐦᒀᐙ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᒄ ᔖᔥ ᐋ ᐹᔓᓈᑯᓃᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᑎᑯᔑᐦᒃ, ᒧᔮᒻ ᔖᔥ ᐃᔥᒀᐦᑖᒥᐦᒡ ᐋ ᐹᒋ ᓃᐴᐎᑦ ᐋ ᐃᓯᓈᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᒌ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓅᐦᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒫᐦᒋᓂᐱᐎᒡ ᐋᔥᒄ ᐋᐦᐋᑳ ᑎᐱᐱᔨᐦᒑ ᒥᓯᐙ ᑖᓐ ᒑ ᐄᔅᐱᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ ᑭᑎ ᐃᔅᒀᐱᔨᐤ, ᒥᒄ ᒫᒃ ᓂᑎᔨᒧᐎᓐ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐃᔅᒀᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ᐙᔥ ᓂᒧᐃ ᐊᐙᓐ ᒋᔅᒑᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑎᐱᐦᐄᑭᓂᔨᐤ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ᙮ ᓂᒧᐃ ᐙᐙᒡ ᒋᒋᒌᔑᑯᐦᒡ ᐋᓐᒋᓂᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ, ᐙᐙᒡ ᐅᑯᓯᓯᒫᐤ, ᒥᒄ ᐅᐦᑖᐐᒫᐤ ᒋᔅᒑᔨᐦᑎᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ᒧᔮᒻ ᒫᒃ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐊᓂᑎᐦ ᒫᒀᒡ ᑳ ᐱᒫᑎᓰᑦ ᐊᓂᔮ ᓄᐙᐦ, ᐋᐅᒄ ᒑ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒦᓐ ᑎᑯᔑᐦᑳ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ᐋᔥᒄ ᐋᒸᔮ ᐅᐦᒋ ᐊᔅᒋᐳᑖᒡ ᐊᔅᒌ ᒥᒄ ᐙᐦ ᑎᒡ ᒌᐦ ᑑᐎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᒌ ᒦᒋᓯᐎᒡ, ᒌ ᒥᓂᐦᒀᐅᒡ, ᑭᔮᐦ ᒌ ᒋᐦᒋᐐᒋᑑᒡ ᐲᐦᐃᒻ ᑳ ᐅᑎᐦᒋᐱᔨᐦᒡ ᒑ ᐲᐦᒑᑦ ᓄᐙ ᐅᒌᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᒑ ᐄᔅᐱᔨᔨᒡ ᐹᑎᔥ ᑳ ᐊᔅᒋᐳᑖᔨᒡ ᐊᔅᒌᔨᐤ, ᒥᓯᐙ ᒫᒃ ᒌ ᓂᔑᐎᓈᒋᐦᐅᒡ᙮ ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᒑ ᐄᔅᐱᔨᒡ ᐄᔥᐱᐦ ᐹᒋ ᓅᑯᓯᒑ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ᐊᓐ ᒫᒃ ᒫᒀᒡ, ᓃᔓ ᓈᐹᐅᒡ ᒋᑭ ᑖᐅᒡ ᐊᓂᑖᐦ ᓅᐦᒋᒦᐦᒡ᙮ ᐹᔨᒄ ᐊᓐ ᒋᑭ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᓂᑭᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ᒋᑭ ᓃᔔᒡ ᐃᔅᒀᐅᒡ ᐋ ᐱᒥᓄᐙᒡ, ᐹᔨᒄ ᐊᓐ ᒋᑭ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᓂᑭᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","ᔮᒀᒦᒄ ᒫᒃ ᐙᔥ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᔨᔥᐱᔥ ᒑ ᑎᑯᔑᐦᒃ ᒋᑎᐹᔨᐦᒋᒑᓯᒧᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ ᒫᒃ ᐆ᙮ ᒧᔮᒻ ᐊᐙᓐ ᐐᒋᐦᒡ ᐋᐦ ᑖᑦ ᒋᔅᒑᔨᒫᑦ ᒫᒃ ᒋᒧᑎᔅᒃ ᒑ ᐹᒋ ᑎᑯᔑᓃᔨᒡ, ᒋᐱᐦ ᐃᔮᔅᑭᐎᔥᑎᐙᐤ᙮ ᐋᑐᒡ ᐐᔨ ᒋᐱᐦ ᐅᐦᒋ ᓂᐦᐋᔨᒨ ᒥᒄ ᒑ ᒌᐦ ᐄᔑ ᑭᒑᒧᑎᔨᒡ ᐊᓂᑎᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒦᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ᐋᐅᒄ ᒫᒃ ᐆ ᐅᐦᒋ ᑭᔮᐦ ᒌᔨᐙᐤ ᒨᔥ ᒋᐱᐦ ᐃᔮᔅᑭᐐᓈᐙᐤ᙮ ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᑎ ᑎᑯᔑᓐ ᑖᓂᑖᐦ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᐅᐦᒋ ᐹᔣᔨᒫᒄ ᒑ ᑎᑯᔑᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ᐋᐱᒋᐦᐋᑭᓐ ᑯᐃᔅᒄ ᑳᐦ ᑐᑎᐦᒃ ᐅᑖᐱᑎᓰᐎᓐ ᑭᔮᐦ ᑳ ᐄᑆᐦᑳᑦ ᐋᐅᒄ ᒑ ᐅᐙᔮᐱᒥᑯᑦ ᐅᒋᒫᒻ ᐐᔨ ᒑ ᒌᐦ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃᐦ ᐋᐱᒋᐦᐋᑭᓐᐦ ᑭᔮᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᐙᑦ ᓂᐦᐋᐤ ᒑ ᒌᐦ ᐄᔑ ᐊᔑᒫᑭᓂᐎᔨᒡ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐊᔑᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ᑭᑎ ᒋᔖᐙᑐᐙᑭᓂᐤ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᒥᔅᑯᐙᑭᓅᒑ ᑯᐃᔅᒄ ᐋᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑖᐱᑎᓰᐎᓐ ᐄᔥᐱᐦ ᑎᑯᔑᓃᔨᒑ ᐅᒋᒫᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᑭ ᒥᔨᑰ ᐊᓂᔮ ᐅᒋᒫᒻ ᒥᓯᐙ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᐙᑦ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ᒥᒄ ᒫᒃ ᒥᒋᐋᐱᒋᐦᐋᑭᓐ ᐄᑖᔨᐦᑎᐦᑳ, ᐋᔥᒄ ᔮᐅᓈᑯᓂᔨᐤ ᒑ ᐃᔥᐱᔥ ᑎᑯᔑᐦᒃ ᒦᓐ ᓅᒋᒫᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ᐋᒄ ᒫᒃ ᓈᔥᒡ ᓈᓈᐦᑳᒋᐦᐋᒑ ᐊᓂᔮᔨᐤᐦ ᐐᒋᐋᐱᒋᐦᐋᑭᓐᐦ ᑳ ᓃᑳᓂᔥᑭᐙᑦ, ᐋ ᐅᑎᑖᒥᐦᐙᑦ ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐐᒋᒦᒋᓱᒫᒑ ᑭᔮᐦ ᒫᒃ ᐐᒋᒌᔥᒀᐹᒫᒑ ᑯᑎᒃ, ");
INSERT INTO crl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ᐅᒋᒫᒻ ᒫᒃ ᑎᑯᔑᓃᔨᒑ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᐹᔣᔨᒫᑦ ᑭᔮᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᒋᔅᒑᔨᐦᑎᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ᐋᒄ ᐎᔮᔅ ᒑ ᑐᑎᐙᑭᓅᑦ ᒥᑐᓐ ᒑ ᒌ ᐙᐐᓯᒑᔨᐦᑎᐦᒃ᙮ ᐋᒄ ᒫᒃ ᒑ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓅᑦ ᐊᓂᑖᐦ ᑳ ᒥᔪᐦᑣᐦᑳᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᓂᓈᐦᑳᑖᔨᒧᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᒫᑑᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᔑᐦᒡ ᒑ ᐃᔥᐱᔥ ᓂᓈᐦᑳᑖᔨᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᒑ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒧᔮᒻ ᒥᑖᐦᑐ ᐃᔅᒀᓯᒡ ᐋ ᑎᐦᑯᓂᐦᒡ ᐅᐙᔥᑖᓂᒫᑭᓂᐙᐤ, ᐋ ᓂᑑᓂᒋᔥᑭᐙᒡ ᐅᔅᒋᓈᐹᐙᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ᓂᔮᔪ ᒫᒃ ᐅᒌ ᓂᒧᐃ ᓈᔥᒡ ᐅᐦᒋ ᐄᑆᐦᑳᐅᒡ, ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᓂᔮᔪ ᒌᐦ ᐄᑆᐦᑳᐅᒡ ᐐᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ᐊᓂᒌ ᒫᒃ ᐋᑳ ᑳ ᓈᔥᒡ ᐄᑆᑳᒡ ᒌ ᒋᔅᑐᐦᑎᑖᐅᒡ ᐅᐙᔥᑖᓂᒫᑭᓂᐙᐤ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐋᔨᐙᒡ ᐅᐦᒋ ᑎᐦᑯᓂᒧᒡ ᐱᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ᐋᒄ ᐊᓂᒌ ᑳ ᐄᑆᑳᒡ ᐋᔨᐙᒡ ᒌ ᒋᔅᑐᐦᑎᑖᐅᒡ ᐐᔨᐙᐤ ᐱᒥᔨᐤ ᒑ ᐲᐦᒋᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐅᐙᔥᑖᓂᒫᑭᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ᓂᒧᐃ ᒫᒃ ᑏᐙᐦᒡ ᐅᐦᒋ ᑎᑯᔑᓐ ᐊᓐ ᐅᔅᒋᓈᐹᐙᓐ᙮ ᒑᒃ ᑳ ᒋᓯᐦᑯᓯᒡ ᐊᓂᒌ ᐃᔅᒀᓯᒡ, ᐋᒄ ᒑᒃ ᑳ ᑭᐎᐦᑯᔑᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ᔖᔥ ᒫᒃ ᒌᐦ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᐤ, ᑳ ᒥᑣᑖᑆᑦ ᐊᐙᓐ ᐋᐦ ᐃᔨᑦ, ‘ᔖᔥ ᑎᑯᔑᓐ ᐅᔅᒋᓈᐹᐙᓐ, ᐹᒋ ᓂᒋᔥᑭᐙᐦᒄ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ᑭᔨᑆ ᑳ ᐎᓂᔥᑳᒡ ᐊᓂᒌ ᒥᑖᐦᑐ ᐃᔅᒀᓯᒡ, ᑳ ᐙᐙᔑᐦᑖᒡ ᐅᐙᔥᑖᓂᒫᑭᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᓈᔥᒡ ᐄᑆᑳᒡ ᐃᔅᒀᓯᒡ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐄᑆᐦᑳᔨᒡ ᐃᔅᒀᔥᐦ, ‘ᐹᒋ ᒥᔨᓈᓐ ᒫᐦ ᐊᐱᔒᔥ ᒋᐱᒦᒧᐙᐤ᙮ ᔖᔥ ᒑᑳᑦ ᐋᔥᑎᐙᐤ ᓂᐙᔅᑖᓂᒫᑭᓈᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ᐋᒄ ᐊᓂᒌ ᑳ ᐄᑆᑳᒡ ᐃᔅᒀᓯᒡ ᑳᐦ ᐄᑖᒡ, ‘ᓂᒧᐃ, ᑖᐹ ᒋᑭ ᐄᔅᐱᔨᓈᓂᐤ ᑖᐱᔥᑯᓐ ᒑ ᒌᐦ ᐋᐱᒋᐦᑖᔨᐦᒄ ᐆ ᐱᒦ᙮ ᐊᑖᐙᐅᑭᒥᑯᐦᒡ ᓂᑑᐅᑎᓂᒫᓱᒄ ᐱᒦ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᓈᔥᒡ ᐄᑆᑳᒡ ᐃᔅᒀᓯᒡ ᑳ ᓂᑑᐅᑎᓂᒑᐦᒡ ᐱᒥᔨᐤ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᐃᔅᐱᐦᑎᓂᐦᐅᒡ, ᒌ ᑎᑯᔑᓂᔨᐤ ᐊᓂᔮᔨᐤᐦ ᐅᔅᒋᓈᐹᐙᓐᐦ᙮ ᐊᓂᒌ ᒫᒃ ᐃᔅᒀᓯᒡ ᑳ ᐃᔮᔅᑭᐐᒡ ᒌᐦ ᐋᑎ ᐐᒑᐙᐅᒡ ᐋᐦ ᐋᑎ ᐲᐦᒑᔨᒡ ᐊᓂᑖᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ, ᐋᒄ ᑳ ᒋᐳᐦᐙᑭᓅᑦ ᐊᓐ ᒋᔥᑐᐦᑭᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ᐹᑎᒫ ᒫᒃ ᑳ ᐹᒋ ᑎᑯᔑᐦᒡ ᐊᓂᒌ ᑯᑎᑭᒡ ᐃᔅᒀᓯᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐹᒋ ᐲᐦᑎᑭᐦᐄᓈᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤᐦ ᐅᔅᒋᓈᐹᐙᓐᐦ, ‘ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᒋᒋᔅᒑᔨᒥᑎᓈᐙᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᐋᐅᒄ ᒫᒃ ᐆ ᐅᐦᒋ ᑭᔮᐦ ᒌᔨᐙᐤ ᒨᔥ ᒋᐱᐦ ᐃᔮᔅᑭᐐᓈᐙᐤ ᐙᔥ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᔨᔥᐱᔥ ᓂᐦᐋᐤ ᒑ ᑎᑯᔑᐦᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“ᒫᐤ ᒦᓐ ᒑ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᒧᔮᒻ ᓈᐹᐤ ᐙᐦᔨᐤ ᐊᔅᒌᐦᒡ ᐋᐦ ᐄᑐᐦᑖᑦ, ᐋ ᓂᑑᒫᑦ ᒫᒃ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ ᐋᐦ ᐄᑖᑦ ᒑ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ᒌ ᒥᔮᐤ ᒫᒃ ᔓᐎᔮᓐ ᐋ ᐱᑯᓵᔨᒫᑦ ᐋᔨᐙᒡ ᒑ ᒌᐦ ᐅᔑᐦᑎᒫᑯᑦ ᒑ ᐃᔅᐱᐦᑎᓂᐦᐆᑦ᙮ ᒌ ᒫᑎᓂᒧᐙᐤ ᐊᓂᔮᔨᐤ ᐅᔔᔮᓂᒻ ᒥᒄ ᐊᓂᔮᔨᐤ ᐋ ᑖᔨᒫᑦ ᒑ ᐄᔑ ᑭᔅᒋᐦᐅᔨᒡ ᐋ ᑭᓂᐙᔨᒫᔨᒡ᙮ ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᐦ ᐋᐱᒋᐦᐋᑭᓐᐦ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᔔᐎᔮᓈᐱᔅᒄ ᒌ ᒥᔮᐤ, ᐋᒄ ᐊᓂᔮᐦ ᑯᑎᒃᐦ ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ, ᐋᒄ ᐊᓂᔮᐦ ᑯᑎᒃᐦ ᐹᔨᒀᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᒥᔮᐤ᙮ ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ᐊᓐ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐᐦ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ, ᒌ ᒋᐦᑖᐱᑎᓰᐙᒑᐙᐤ ᐊᓂᔮᔨᐤ ᐅᔔᔮᓂᒥᔨᐤ ᐊᑎᑎᐤ ᒑ ᒌᐦ ᐄᐦᒋᐦᐄᒫᑦ᙮ ᒦᓐ ᒫᒃ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᐱᐦᑯᐦᐋᐤ ᐊᓂᔮ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ᑭᔮᐦ ᒫᒃ ᐊᓐ ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ, ᒦᓐ ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᐱᐦᑯᐦᐋᐤ ᐊᓂᔮ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ᐊᓐ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐᐦ ᐹᔨᒀᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ, ᒌ ᒨᓈᐅᐦᑭᐦᐊᒻ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᐋᑯᑖᐦ ᑳ ᑳᔮᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ ᐅᔔᔮᓂᒥᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ᓈᐅᔥ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᑖᔨᐤ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒧᐙᐤ ᐊᓂᒌ ᐋᐱᒋᐦᐋᑭᓂᒡ᙮ ᒑᒃ ᑳ ᐹᒋ ᒌᐙᔨᒡ ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᒡ ᑖᓐ ᑳᐦ ᑐᑎᐙᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᑳ ᒥᔨᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ᐊᓐ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ ᔓᐎᔮᓐ ᒌ ᐹᒋ ᐲᐦᒑᐤ, ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ ᐊᓂᔮᔨᐤ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᔓᐎᔮᓐ ᐋᔨᐙᒡ ᑳ ᐱᐦᑯᐦᐋᑦ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, ‘ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒋᒌ ᒦᓐ ᔓᐎᔮᓐ, ᒦᓐ ᒫᒃ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋᔨᐙᒡ ᓂᒌ ᐱᐦᑯᐦᐋᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘ᑖᑆᐦ ᒌ ᒥᔪᑐᑖᓐ ᑭᔮᐦ ᑖᑆᐦ ᒌ ᒥᔻᐱᑎᓰᓐ,’ ᒌᐦ ᐄᑎᑰ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ᙮ ‘ᑯᐃᔅᒄ ᐋ ᒌᐦ ᐄᔑ ᐋᐱᑎᔒᔥᑎᒥᓐ ᐊᓐ ᐋ ᐊᐱᔖᔑᒡ ᑖᓐ ᑳ ᐄᔑ ᐱᑯᓵᔨᒥᑭᐎᔨᓐ ᐋᒄ ᐊᑎᑎᐤ ᐋ ᒥᔖᒡ ᒑᒀᓐ ᒑ ᐱᒋᔅᑎᓂᒫᑭᐎᔨᓐ ᒑ ᒌᐦ ᐅᒋᒫᐦᑭᐦᑎᒥᓐ᙮ ᐋᔥᑎᒻ ᐹᒋ ᐲᐦᒑᐦ, ᒑ ᐹᒋ ᐐᒋᐦᐄᔨᓐ ᑖᓐ ᐋ ᐄᔑ ᒥᔻᔨᐦᑎᒫᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ᐋᒄ ᐊᓐ ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ ᔓᐎᔮᓐ ᒌ ᐹᒋ ᐲᐦᒑᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ, ‘ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒋᒌ ᐹᒋ ᒦᓐ, ᒦᓐ ᒫᒃ ᓃᔣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋᔨᐙᒡ ᓂᒌ ᐱᐦᑯᐦᐋᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘ᑖᑆᐦ ᒌ ᒥᔪᑐᑖᓐ ᑭᔮᐦ ᓄᐎᒡ ᒌ ᒥᔻᐱᑎᓯᔨᓐ’, ᒌᐦ ᐄᑎᑰ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ᙮ ‘ᑯᐃᔅᒄ ᐋ ᒌᐦ ᐄᔑ ᐋᐱᑎᔒᔥᑎᒥᓐ ᐊᓐ ᐋ ᐊᐱᔖᔑᒡ ᑖᓐ ᑳ ᐄᔑ ᐱᑯᓵᔨᒥᑭᐎᔨᓐ, ᐊᑎᑎᐤ ᐋ ᒥᔖᒡ ᒑᒀᓐ ᒋᑭ ᐱᒋᔅᑎᓂᒫᑭᐎᓐ ᒑ ᒌᐦ ᐅᒋᒫᐦᑭᐦᑎᒥᓐ᙮ ᐋᔥᑎᒻ ᐹᒋ ᐲᐦᒑᐦ, ᒑ ᐹᒋ ᐐᒋᐦᐄᔨᓐ ᑖᓐ ᐋ ᐄᔑ ᒥᔻᔨᐦᑎᒫᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","ᐋᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐹᔨᒀᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᒥᔮᑭᓅᑦ ᑳ ᐹᒋ ᐲᐦᒑᑦ, ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᒋᔅᒑᔨᒥᑎᓐ ᓈᔥᒡ ᐋ ᐋᔨᒫᔨᐦᑖᑯᓯᔨᓐ᙮ ᑰᑎᓈᓐ ᑭᔮᐦ ᒋᒫᐆᒋᐦᑎᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᒌᐦ ᐅᐦᒋ ᓂᑖᐆᒋᐦᑖᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ᒋᒌ ᑯᔥᑎᑎᓐ, ᑳ ᓂᑑᑳᔨᒃ ᐊᓐ ᒋᔔᔮᓂᒻ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ᙮ ᒫᐤ ᒫᒃ ᒋᔔᔮᓂᒻ ᑳ ᐹᒋ ᒥᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ, ‘ᑖᑆᐦ ᒌ ᓅᐦᑖᓯᔨᓐ ᑭᔮᐦ ᑖᑆᐦ ᒌ ᒥᒋᐋᐱᒋᐦᐋᑳᓂᐐᓐ᙮ ᐋᔨᓯᔨᓐ ᐋ ᒋᔅᒑᔨᒥᔨᓐ ᐊᐅᑎᓂᒫᓐ ᑭᔮᐦ ᐋ ᒫᐆᒌᐦᑖᔮᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᓃᔨ ᐅᐦᒋ ᓂᑖᐆᒋᐦᑖᔮᓐ, ");
INSERT INTO crl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓂᑦ ᐊᓐ ᔓᐎᔮᓐ ᐊᓂᑖᐦ ᔔᔮᓂᑭᒥᑯᐦᒡ ᒑ ᒌᐦ ᐅᔑᐦᐅᑦ? ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᒦᓐ ᑎᑯᔑᓂᔮᓐ ᓂᐱᐦ ᐃᔮᐙᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐃᒋᐦᐆᑯᐱᓈ ᐊᓐ ᓂᔔᔮᓂᒻ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ᐋᒄ ᐊᓐ ᐅᒋᒫᐤ ᑳᐦ ᐃᔨᑦ, ‘ᐅᑎᓂᒫᐦᒄ ᐊᓂᔮᔨᐤ ᐅᔔᐎᔮᓈᐱᔅᑯᒻ, ᒑ ᒥᔮᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᒥᑖᐦᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᑎᔑᔨᒡ ᐅᔔᐎᔮᓈᐱᔅᑯᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ᒥᓯᐙ ᐊᐙᓐ ᑳ ᐃᔮᑦ ᒑᒀᔨᐤ ᐊᑎᑎᐤ ᒋᑭ ᑎᑯᓂᔨᐤ ᒑ ᐄᔑ ᒥᔮᑭᓅᑦ᙮ ᒋᑭ ᐙᔫᑎᓰᐤ ᒫᒃ᙮ ᐋᒄ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᓈᔥᒡ ᐃᔮᑦ ᒑᒀᔨᐤ ᒫᒋᒫ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐊᐱᔒᔥ ᐃᔮᑦ ᑭᑎ ᐅᑎᓂᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ᐆ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐ ᐋᑳ ᑳ ᒌᐦ ᐎᔮᔑᑖᐱᑎᓯᑦ ᐊᓂᑖᐦ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᐄᔑ ᐙᐱᓈᐦᒄ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᒫᑑᓈᓂᐎᒡ ᑭᔮᐦ ᒑ ᒥᒥᑣᔮᐱᑖᓯᓈᓂᐎᒡ ᒑ ᐃᔥᐱᔥ ᐐᓯᒑᔨᐦᑖᑭᓂᐎᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ᐊᓂᑖᐦ ᒫᒃ ᓃᔥᑖᒥᐦᒡ ᐄᔥᐱᐦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑎᑯᔑᒑ ᓈᔥᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᑭᔮᐦ ᐋ ᓲᐦᒑᔨᐦᑖᑯᓯᑦ ᒥᓯᐙ ᐋᓐᒋᓐ ᐋ ᐹᒋ ᐐᒑᐙᑦ, ᐋᒄ ᒑ ᐊᐱᑦ ᐊᓂᑖᐦ ᒋᐦᒋᐅᒋᒫᐤ ᑖᐦᑎᐴᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ᐋᒄ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᒑ ᒫᒨᐎᔨᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ᙮ ᐋᒄ ᒑ ᐱᐦᑳᓂᐦᐋᑦ, ᒧᔮᒻ ᒫᓂᔥᒑᓂᔓᐐᔨᔨᐤ ᑳ ᒌᐦ ᑐᑎᐙᑦ ᒫᓂᔥᒑᓂᔥ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐅᐦᑳᓐ ᑯᐎᑦ ᑳ ᐅᑖᔥᑭᓂᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ᐅᓂᐦᐄᐎᓂᐦᒡ ᒋᑭ ᐱᒋᔅᑎᓈᐤ ᐊᓂᔮᔨᐤᐦ ᒫᓂᔥᒑᓂᔥ ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃ ᐊᐅᐦᑳᓐᐦ ᑯᐎᑦ ᑳ ᐅᑖᔥᑭᓂᓯᑦ ᐊᓂᑖᐦ ᐅᓂᒥᐦᒌᐎᓂᐦᒡ ᒑ ᐱᒋᔅᑎᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ᐋᒄ ᒑ ᐄᑖᑦ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᐅᓂᐦᐄᐎᓂᐦᒡ ᑳᐦ ᑖᔨᒡ, ‘ᐋᔥᑎᒧᒄ ᒌᔨᐙᐤ ᑳ ᔓᐙᔨᒥᑖᒄ ᓅᐦᑖᐐᐦ᙮ ᐋᔥᑎᒧᒄ, ᐅᑎᓂᒧᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᐊᓐ ᑳ ᐊᔓᑎᒫᑯᐎᔮᒄ ᐄᔥᐱᐦ ᒫᐅᒡ ᓃᔥᑎᒻ ᑳ ᐅᔑᐦᑖᑭᓂᐎᒡ ᐆ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ᐙᔥ ᑳ ᔒᐅᑖᔮᓐ, ᒋᒌ ᐊᔑᒥᓈᐙᐤ, ᑳ ᐐᐦ ᒥᓂᐦᒀᔮᓐ, ᒋᒌ ᒥᓂᐦᐄᓈᐙᐤ, ᑳ ᒫᓂᑖᐎᔮᓐ ᒋᒌ ᐲᐦᑎᑭᐦᐄᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ᐋᑳ ᐙᐦᒋ ᐅᒑᒀᓂᒥᔮᓐ, ᒋᒌ ᓂᒋᓈᑯᓈᐙᐤ, ᑳᐦ ᐋᐦᑯᓯᔮᓐ, ᒋᒌ ᑭᓂᐙᔨᒥᓈᐙᐤ, ᑭᔮᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᑳᐦ ᑖᔮᓐ ᒋᒌ ᐹᒋ ᒧᑎᓰᓈᐙᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","ᐋᒄ ᒫᒃ ᒑ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᐙᐲᒥᑎᓈᓐ ᐋ ᔒᐅᑖᔨᓐ, ᒑ ᒌᐦ ᐊᔑᒥᑖᐦᒡ ᒫᒃ, ᑭᔮᐦ ᒫᒃ ᐋ ᐐᐦ ᒥᓂᐦᒀᔨᓐ, ᒑ ᒌ ᒥᓂᐦᐄᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ᑭᔮᐦ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᐙᐲᒥᑎᓈᓐ ᐋ ᒫᓂᑖᐎᔨᓐ, ᒑ ᒌ ᐲᐦᑎᑭᐦᐄᑖᐦᒡ, ᑭᔮᐦ ᒫᒃ ᐋᐦᐋᑳ ᐅᒑᒀᓂᒦᓐ, ᒑ ᒌ ᓂᒋᓈᑯᓂᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ᑭᔮᐦ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᐙᐲᒥᑎᓈᓐ ᐋᐦ ᐋᐦᑯᓯᔨᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᒋᐱᐦᐅᑯᐎᔨᓐ, ᒑ ᒌ ᓂᑑᒧᑎᑎᑖᐦᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ᐋᒄ ᒋᐦᒋᐅᒋᒫᐤ ᒑ ᐄᑖᑦ, ‘ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᐙᒄ ᐹᔨᒄ ᐊᓐ ᓃᒋᔖᓐ ᐋᑳ ᑳ ᒥᑐᓐ ᒌ ᑳᔮᔨᐦᑖᑯᓯᑦ ᑳ ᐄᑖᔨᒫᑭᓅᑦ, ᓃᔨ ᒋᒌ ᑐᑎᐎᓈᐙᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ᐋᒄ ᒑ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᓂᒥᐦᒌᐎᓂᐦᒡ ᑳᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᒥᒑᑎᓰᔨᒡᐦ, ‘ᐊᐅᔑᒄ ᓈᑖᐦ ᒌᔨᐙᐤ ᒋᔖᒥᓂᑑ ᒑ ᓂᓈᑳᑖᔨᒧᐦᐄᑖᒄ ᐊᓂᑖᐦ ᐄᔑ ᑳᒋᒡ ᒥᒋᔥᑯᑖᐦᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐄᔑ ᐃᔮᔅᑰᔥᑎᒧᐙᑭᓂᐎᔨᒡ ᒥᒋᒥᓂᑑ ᑭᔮᐦ ᐅᒥᒋᐋᓐᒋᓐᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ᐙᔥ ᓂᒌ ᔒᐅᑖᔨᓐ ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᐊᔑᒥᓈᐙᐤ, ᓂᒌ ᐐᐦ ᒥᓂᐦᒀᓐ ᓂᒧᐃ ᑰᐦᒋ ᒥᓂᐦᐄᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ᓂᒌ ᒫᓂᑖᐎᓐ, ᓂᒧᐃ ᑰᐦᒋ ᐲᐦᑎᑭᐦᐄᓈᐙᐤ ᒌᒋᐙᐦᒡ, ᓂᒥ ᓅᐦᒋ ᐅᒑᒀᓂᒥᓐ, ᓂᒧᐃ ᑰᐦᒋ ᓂᒋᓈᑯᓈᐙᐤ᙮ ᓂᒌᐦ ᐋᐦᑯᓯᓐ ᑭᔮᐦ ᓂᒌ ᒋᐱᐦᐅᑰᓐ ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᐹᒋ ᓂᓈᑭᒋᐦᐄᓈᐙᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“ᐋᒄ ᒫᒃ ᒑ ᐄᑖᒡ, ᐋ ᓂᔥᒀᐅᔑᐦᐋᒡ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᐙᐲᒥᑎᓈᓐ ᐋ ᔒᐅᑖᔨᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᐐᐦ ᒥᓂᐦᒀᔨᓐ ᑭᔮᐦ ᐋ ᒫᓂᑖᐎᔨᓐ ᑭᔮᐦ ᐋᐦᐋᑳ ᐅᒑᒀᓂᒦᓐ, ᑭᔮᐦ ᒫᒃ ᐋᐦ ᐋᐦᑯᓯᔨᓐ ᑭᔮᐦ ᐋ ᒋᐱᐦᐅᑯᔨᓐ, ᐋᐦᐋᑳ ᒫᒃ ᐅᐦᒋ ᐐᒋᐦᐄᑖᐦᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ᐋᒄ ᒫᒃ ᒑ ᐄᑎᑯᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ, ‘ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᐐᒋᐦᐋᒄ ᐹᔨᒄ ᓃᒋᔖᓐ ᐊᓐ ᐋᑳ ᑳ ᒥᑐᓐ ᒌ ᑳᔮᔨᐦᑖᑯᓯᑦ ᑳ ᐄᑖᔨᒫᑭᓅᑦ, ᓃᔨ ᑭᔮᐦ ᓂᒧᐃ ᑰᐦᒋ ᐐᒋᐦᐄᓈᐙᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᑳ ᒥᒑᑎᓯᒡ ᒑ ᐄᑎᔑᐦᐙᑭᓂᐎᒡ ᐊᓂᑖᐦ ᑳᒋᒡ ᒑ ᐄᔑ ᓂᓈᐦᑳᑖᔨᒧᒡ, ᐋᒄ ᐊᓂᒌ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐊᓂᑖᐦ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᐦᒡ ᒑ ᐄᑎᔑᐦᐙᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒋᔅᑯᑎᒫᒑᑦ ᒌᓴᔅ, ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ");
INSERT INTO crl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᓃᔓ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᐋᒄ ᒑ ᒋᐦᒋᐱᔨᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓐ ᒫᒀᒡ ᐄᔅᐱᔨᐦᒑ ᒑ ᐱᒋᔅᑎᓈᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ᐋᒄ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐄᔨᔨᐤ ᑳ ᓂᔥᑐᐐᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑳᔮᕙᔅᐦ ᐅᒋᔥᒍᒋᒫᐅᑭᒥᑯᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ᐋᒄ ᑳ ᐎᔮᔨᐦᑎᐦᒡ ᒌᒧᒡ ᒑ ᐐᐦ ᐅᑎᓈᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᒑ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ᒌᐦ ᐄᑖᐅᒡ ᒫᒃ, “ᓂᒧᐃ ᐐ ᒫᒀᒡ ᐆ ᒥᑯᔖᓂᐎᒑ ᒋᑭ ᒌᐦ ᐅᑎᓈᓂᐤ, ᐙᔥ ᓈᓂᑐ ᒋᑭ ᒥᔥᑎᐦ ᒋᔑᐙᔓᐎᒡ ᐄᔨᔨᐅᒡ, ᒋᑭ ᒌᐦ ᐃᓯᓈᑯᓐ ᒋᐦᒋᐙ ᒑ ᒌ ᒥᒋᐱᔨᓈᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ᐯᑎᓃᐦᒡ ᒌᐦ ᑖᐤ ᒌᓴᔅ, ᐊᓂᑖᐦ ᓵᐃᒥᓐᐦ ᐐᒋᔨᐦᒡ᙮ ᐆ ᓵᐃᒥᓐᐦ ᐋ ᒫᔮᑎᓃᔨᒡ ᐋᐦᑯᓯᐎᓂᔨᐤ ᐅᓯᑳᐦᒡ ᒌᐦ ᐃᔮᑖᑯᐱᓐ ᐙᔥᑭᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋ ᒦᒋᓱᑦ, ᒌᐦ ᐅᐦᒋ ᐲᐦᒑᔨᐤ ᐃᔅᒀᐤᐦ ᐋ ᐹᒋ ᑎᐦᑯᓂᒥᔨᒡ ᓈᔥᒡ ᐋ ᒥᔻᔒᔨᒡ ᐊᓯᓃ ᐱᔻᐱᔅᑯᔮᑭᓐ ᐋ ᐲᐦᒋᔥᑎᓃᔨᒡ ᐊᓂᑎᐦ ᒫᐅᒡ ᑳᐦ ᐋᔨᒥᒋᑖᑯᓃᔨᒡ ᑳ ᒥᔪᒫᑯᓰᔨᒡ ᑳ ᒥᔪᒫᑯᓃᔨᒡ᙮ ᒌᓴᔅ ᒫᒃ ᐅᔥᑎᒀᓃᔨᒡ ᒌᐦ ᑯᑎᐱᓂᒻ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐎᔮᐱᒫᒡ ᐅᔮᔨᐤ ᐋ ᐄᔨᐦᑎᔨᒡ, ᒌ ᒋᔑᐙᐦᐄᑯᒡ, ᐋᐦ ᐄᑖᒡ, “ᑖᑆᐦ ᐃᔮᔪᐦᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᒥᔪᒫᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ᒋᐱᐦ ᒌᐦ ᐊᑖᐙᒑᓂᐎᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒥᔪᒫᑯᓃᔨᒡ ᐋᒄ ᒫᒃ ᒋᐱᐦ ᒌ ᒥᔮᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᒥᔥᑎᐦ ᒑ ᐅᔑᐦᐄᒫᑭᓂᐐᑯᐱᓈᓂᐦᐄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋᐦ ᐄᑎᑐᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐋᔨᒦᐦᑰᐙᒄ? ᓈᔥᒡ ᒥᔻᔑᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᒌᐦ ᑐᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ᒨᔥ ᒋᑭ ᑖᐅᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ, ᓃᔨ ᒫᒃ ᓂᒧᐃ ᒨᔥ ᓂᑭᐅᐦᒋᐦᑖᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐹᒋ ᑐᑎᐙᑦ ᑳ ᐹᒋ ᑯᑎᐱᓂᐦᒃ ᑳ ᒥᔪᒫᑯᓃᔨᒡ ᐅᑎᐦ ᐋᐦᑖᐅᒡ, ᒧᔮᒻ ᐋ ᐃᔮᔅᑭᐐᐦᑭᐦᒃ ᓂᔮᔨᐤ ᒑ ᓂᐦᐄᑳᑭᓂᐎᔨᒡ ᐋᑯᑖᐦ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑖᓂᑖᐦ ᒥᒄ ᒑ ᑭᒑᔅᒀᓅᒀ ᐋ ᐙᐐᐦᑖᑭᓂᐎᒡ ᒥᔻᒋᒧᐎᓐ ᒥᓯᐙ ᐋᐦ ᐄᔥᐱᑎᔅᑭᒥᑳᒡ ᐆ ᐊᔅᒌ ᑭᑎ ᐐᐦᑖᑭᓂᐎᔨᐤ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐦᒃ ᐋ ᒋᔅᒋᓰᑐᑎᐙᑭᓅᑦ ᐆ ᐃᔅᒀᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ᐋᒄ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᓃᔓᔖᐴᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᒌ ᓂᑎᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔑᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᒑ ᒥᔮᒄ ᐐᒋᐦᐄᑎᑯᒑ ᒑ ᒌᐦ ᐅᑎᓈᒄ ᒌᓴᔅ᙮” ᓂᔥᑐᒥᑎᓂᐤ ᒫᒃ ᔔᐎᔮᓈᐱᔅᒄ ᒌ ᐙᐱᐦᑎᔨᑰ, ᐋᒄ ᑳ ᒥᔨᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐅᔅᑭᒡ ᒨᔥ ᑳ ᓈᓂᑐᐙᔨᐦᑎᒸᑦ ᒍᑖᔅ ᑖᓂᑖᐦ ᒑ ᒌ ᓂᐦᐄᐱᔨᒡ ᒑ ᒌ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᒑ ᒌᐦ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","ᐊᓐ ᒫᒃ ᓃᔥᑎᒻ ᐋ ᒌᔑᑳᒡ ᐋ ᒥᑯᓵᓅᒡ ᒫᒀᒡ ᐋ ᐱᒥᐱᔨᒡ ᐋᐦᐋᑳ ᐅᐦᐱᓱᑦ ᐋᐃᐦᑯᓈᐤ ᑳ ᒌᐦ ᒧᐙᑭᓅᑦ, ᒌᓴᔅ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᓂᑖᐦ ᓈᑎᐙᔨᒥᔮᐦᒡ ᒑ ᒌ ᓂᑑᐃᔮᔅᑰᔥᑎᒫᑖᐦᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᒑ ᒌ ᒦᒋᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐄᑐᐦᑖᒄ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᒑ ᓂᑎᐙᐱᒫᒄ ᐹᔨᒄ ᓈᐹᐤᐦ ᐋᒄ ᒑ ᐄᑖᒄ, ‘ᐊᑯᐄᔮᑦ ᒋᔅᑯᑎᒫᒑᓯᐤ, ᔖᔥ ᐐᐱᒡ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᒑ ᓂᑭᑎᒫᓐ ᐆ ᐊᔅᒌ᙮ ᐊᓂᑖᐦ ᒌᒋᐦᒡ ᓂᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓂᑭ ᐹᒋ ᒥᑯᔖᓈᓐ ᐊᓐ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒫᒃ ᒌᐦ ᑐᑎᒥᔨᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑦ, ᑭᔮᐦ ᒌᐦ ᐃᔮᔅᑰᔥᑖᔨᐤ ᐊᓂᔮᔨᐤ ᒥᑯᔖᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ᐊᓂᔮᔨᐤ ᒫᒃ ᐙᑖᑯᓰᔨᒡ, ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᓲᓵᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌᐦ ᐅᐙᔨᐴᒡ ᒑ ᒌ ᒥᑯᔖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ᒫᒀᒡ ᒫᒃ ᐋ ᒦᒋᓱᒡ, ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐹᔨᒄ ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᑭ ᒫᒥᔑᒥᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᒥᓯᒫᔨᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᐋᒄ ᐹᐦᐹᔨᒄ ᑳᐦ ᐄᑖᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᒥᔮᐤ ᐐ ᓃᔨ ᑳ ᐄᔑᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᐊᐙᓐ ᒑ ᐹᔨᑯᐦᑖᐙᐦᒑ ᐎᔮᑭᓐ ᐋ ᐊᑯᐦᒋᒥᒋᐦᑦ ᓂᑖᐃᐦᑯᓈᒥᓈᓐ ᐋᐅᒄ ᐊᓐ ᒑ ᒫᒥᔑᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ᑭᑎ ᓂᐱᐦᐋᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤ ᓂᐦᐋᐤ ᑳ ᐄᔑ ᐹᒋ ᒥᓯᓂᐦᐄᑭᓂᐎᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ᙮ ᒥᒄ ᒫᒃ ᑖᑆᐦ ᑭᑎ ᐋᐦᒀᒡ ᒥᒋᐱᔨᐤ ᐊᓐ ᐊᐙᓐ ᒑ ᒫᒥᔑᒫᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ᐊᐅᔅᑖ ᒋᐱᐦ ᒌ ᒥᔻᔑᑯᐱᓐ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᐄᔨᔨᐎᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ᐋᒄ ᒍᑖᔅ ᐊᓐ ᒦᔮᒥᔑᒫᑦ ᒌᓴᔅᐦ ᑳᐦ ᐃᔨᑦ, “ᓂᒧᐃ ᐋ ᐐᐦ ᓃᔨ ᑳ ᐄᔑᔨᓐ, ᒋᔅᑰᑎᒫᒑᓯᐤ” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ, ᐋᐅᒄ ᐊᓐ ᐙᔥ ᑭᔨᑆ ᐃᔮᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᒦᒋᓱᒡ, ᒌᓴᔅ ᒌᐦ ᐅᑎᓈᐤ ᐋᐃᐦᑯᓈᐤ ᐋᒄ ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᓈᔅᑯᒧᑦ ᐋᒄ ᑳ ᐱᐱᐦᒀᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐋᒄ ᑳ ᒥᔮᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, “ᐅᑎᓈᐦᒄ ᐆ, ᒧᐙᐦᒄ, ᐋᐅᒄ ᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ᐋᒄ ᐊᓂᔮᔨᐤ ᒥᓂᐦᒀᑭᓂᔨᐤ ᑳ ᐅᑎᓂᐦᒃ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑᐦ, ᐋᒄ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, “ᐅᑎᓂᒥᒄ ᐆ ᒑ ᒌ ᒥᓂᐦᒀᔮᒄ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ᐙᔥ ᐋᐅᒄ ᐆ ᓂᒥᐦᒄ ᒑ ᐅᐦᒋ ᐅᔅᒋᐦᑖᑭᓂᐎᒡ ᓂᔅᑯᒥᑐᐎᓐ, ᐋᐅᒄ ᓂᒥᐦᒄ ᒑ ᓰᒋᑭᐎᐦᑖᑭᓂᐎᒡ ᒑ ᒌᐦ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᒡ ᒥᐦᒑᑐᐦ ᐄᔨᔨᐅᒡᐦ ᐅᒥᒋᐦᑣᐎᓂᐙᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ ᓂᒧᐃ ᒦᓐ ᓂᑭ ᐅᐦᒋ ᒥᓂᐦᒀᓐ ᔔᒥᓈᐳᐃ ᐅᑎᐦ ᐐ ᐹᑎᔥ ᐊᓂᑖᐦ ᓅᐦᑖᐐ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᒦᓐ ᒫᒨ ᒥᓂᐦᒀᔨᐦᒀ ᐋ ᐅᔅᑳᑭᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᑭᒧᒡ ᐊᔨᒥᐦᐋᐤ ᓂᑭᒧᐎᓂᔨᐤ ᐋᒄ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐆ ᐊᓅᐦᒡ ᒑ ᑎᐱᔅᑳᒡ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᒋᑭ ᓂᑭᓯᓈᐙᐤ, ᐊᓐ ᐅᐦᒋ ᑖᓐ ᒑ ᑐᑖᑯᔮᓐ, ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᑭ ᓃᐦᑎᐦᐙᐤ ᐊᓐ ᒫᓂᔥᒑᓂᔑᐐᔨᔨᐤ, ᐋᒄ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ ᒑ ᐙᓯᔀᔮᒧᐦᒑᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᐄᔥᐱᐦ ᒫᒃ ᒌᐦ ᐎᓂᔥᑳᓂᑯᔮᓈ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᓂᑭ ᐄᑐᐦᑖᓐ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᐊᔑᓂᐙᐦᐄᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ᐲᑎᕐ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐋᑎ ᒥᓯᐙ ᐊᐙᓐ ᓂᑭᑎᔅᑳ ᐊᓐ ᒑ ᑐᑖᑭᐎᔨᓐ ᓂᒧᐃ ᐐ ᓃᔨ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᓂᑭᑎᑎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐᐦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓐ᙮ ᐊᓅᐦᒡ ᐆ ᒑ ᑎᐱᔅᑳᒡ, ᐐᐱᒡ ᒑ ᒋᔖᐹᔮᒑ ᐋᒸᔮ ᒋᔅᑑᑦ ᓈᐹ ᐹᐦᑭᐦᐋᐦᒀᓐ ᓂᔥᑣᐤ ᒋᑭ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ᐲᑎᕐ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐋᑦ ᑭᔮᐦ ᓃᔨ ᐐ ᓂᐱᐦᐄᑭᐎᔮᓈ ᐄᔥᐱᐦ ᓂᐱᐦᐄᑭᐎᓈ, ᓂᒧᐃ ᐊᔮᐱᒡ ᓂᑭ ᐅᐦᒋ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᑖᓐ᙮” ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨᐙᐤ ᑳᐦ ᐃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᐲᑎᕐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᒑᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᑭᑎᓰᒫᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐋᑯᑖᐦ ᐅᑎᐦ ᐊᐱᒄ, ᓈᑖᐦ ᓂᑭ ᐄᑐᐦᑖᓐ, ᓂᑭ ᓂᑑᐊᔨᒥᐦᐋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐ ᑭᔮᐦ ᓃᔓ ᐊᓂᔮᔨᐤᐦ ᓭᐱᑏ ᐅᑯᓯᔨᐤᐦ ᐊᐅᔅᑖᓰᔅ ᓈᑖᐦ ᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑎᐦᐋᑦ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒥᓯᒫᔨᐦᑎᒻ ᒌᓴᔅ ᑭᔮᐦ ᓈᔥᒡ ᒌᐦ ᑯᔑᑯᑖᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓈᔥᑖᑆᐦ ᒥᓯᒫᔨᐦᑎᒻ ᓂᑎᐦᒑᐦᒄ, ᒨᔮᒻ ᐊᓂᑎᐦ ᒑ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᔮᓐ᙮ ᐋᑯᑖᐦ ᐅᑎᐦ ᑖᒄ ᒥᒄ ᒫᒃ ᐊᑳᐐ ᐐᐦ ᑭᐎᐦᑯᔑᒄ ᐋ ᐋᔓᐙᐱᒥᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ᐋᒄ ᐊᓂᑖᐦ ᐄᒑᓯᔅ ᑳ ᐄᑐᐦᑖᑦ ᐐᔨ, ᒌᐦ ᐅᒋᐦᒌᐦᑯᓂᐱᐤ ᒫᒃ, ᑳ ᓂᑐᑎᒫᑦ ᐋᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᒑ ᒌᐦ ᐃᓯᓈᑯᓂᒀ, ᐹᒋ ᐄᒑᓂᒨᐦ ᐊᓐ ᒥᓂᐦᒀᑭᓐ ᐆ ᑖᓐ ᒑ ᐄᔑ ᐙᐐᓯᒑᔨᐦᑎᒫᓐ, ᒥᒄ ᒫᒃ ᒌᔨ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᒋᑭ ᑐᑖᑭᓂᐤ, ᓂᒧᐃ ᓃᔨ ᓂᑎᐄᑖᔨᐦᑎᒧᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ᒌ ᐱᓯᑰ ᒫᒃ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ, ᑳᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᐊᓯᓂᐙᐦᐄᑯᑦ, ᐙᑎᐦᑖᑦ ᒫᒃ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤᐦ ᑳ ᓂᐹᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐ, “ᓂᒥ ᐙᐙᒑ ᐹᔨᒀᐤ ᐋ ᒌᓂᒀᓂᐦᑖᑦ ᑰᐦᒌ ᐊᓯᓂᐙᐦᐄᓈᐙᐤ ᐋᐦᐋᑳ ᓂᐹᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ᔮᒀᒦᒄ ᑭᔮᐦ ᐊᔨᒥᐦᐋᒄ ᐋᑳ ᒑ ᒌᐦ ᔑᐦᑯᒋᐦᐄᑯᔮᒄ ᑯᒀᒋᐦᐄᐙᐎᓐ᙮ ᐙᔥ ᒋᑎᐦᒑᐦᑯᐙᐦᒡ ᓈᔥᑖᑆᐦ ᑯᐃᔅᒄ ᒋᐐᐦᑎᓈᐙᐤ ᒥᒄ ᒫᒃ ᒋᔮᓯᐙᐦᒡ ᓂᒧᐃ ᒥᑐᓐ ᒋᓵᐱᓰᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ᐋᒄ ᒦᓐ ᑳ ᓂᑐᐊᔨᒥᐦᐋᑦ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᐋᑳ ᒑ ᒌᐦ ᐄᒑᓂᑭᓅᒀ ᐆ ᒑ ᐄᔑ ᐐᓯᒑᔨᐦᑎᒫᓐ ᐋᐅᒄ ᑭᔨᑆ ᒑ ᐄᔑ ᑐᑎᒫᓐ, ᒌᔨ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᒑ ᒌᐦ ᑐᑖᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ᒦᓐ ᑳ ᓂᑎᐙᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᒦᓐ ᒫᒀᒡ ᒌ ᓂᐹᔨᐤᐦ, ᐙᔥ ᔖᔥ ᓂᒧᐃ ᐅᐦᒌ ᒌᐦ ᑎᔨᐤ ᐋᑳ ᒑ ᒌ ᓂᐹᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ᒌᓴᔅ ᑳ ᓂᑭᑖᑦ, ᒦᓐ ᑳ ᓂᑐᐊᔨᒥᐦᐋᑦ᙮ ᐋᔪᐎᒄ ᐋᒄ ᓂᔥᑣᐤ ᑳ ᐹᔨᑯᐦᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ᐋᒄ ᒦᓐ ᑳᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᑳᐦ ᐄᑖᑦ, “ᐋᔥᒄ ᐋ ᒋᓂᐹᓈᐙᐤ? ᐋᔥᒄ ᐋ ᒋᑎᔨᐙᓯᓈᐙᐤ? ᐄᑖᐱᒄ ᒫᐦ, ᔖᔥ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓐ ᐋᐦᒋᓂᒀᓂᐦᑖᑦ ᐲᓯᒧᐦᑳᓐ ᒑ ᒫᒥᔑᒫᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᑖᐦ ᐅᒥᒋᐦᑣᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ᐎᓂᔥᑳᒄ, ᒫᒌᑖᐤ ᐋᒄ, ᐙᔥ ᔖᔥ ᑎᑯᔑᓐ ᐊᓐ ᓈᐹᐤ ᒑ ᒫᒥᔑᒥᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᐋ ᐊᔨᒥᑦ ᒌᓴᔅ ᒌᐦ ᐅᐦᒋ ᑎᑯᔑᓂᔨᐤ ᐹᔨᒄ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒍᑖᔅᐦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᒌ ᐹᒋ ᐐᒑᑯᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᔨᒡ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ᙮ ᒌ ᐹᒋ ᑎᐦᑯᓂᒧᒡ ᒫᒃ ᓂᑐᐱᔫᐦᑯᒫᓐ ᑭᔮᐦ ᐅᑖᒥᐦᐄᑭᓈᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ᐊᓐ ᒑ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᓃᑳᓐ ᒌ ᐐᐦᑎᒧᐙᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᑳ ᐐᒑᐅᑯᑦ ᑖᓐ ᒑ ᑎᒃ᙮ ᒌᐦ ᐄᑖᒑ, “ᐊᓐ ᓈᐹᐤ ᒑ ᐅᒑᒥᒃ ᐋᐅᒄ ᐊᓐ ᓈᐹᐤ ᓈᑎᐙᔨᒫᒄ᙮ ᐋᐅᒄ ᐊᓐ ᒑ ᐅᑎᓈᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ᒍᑖᔅ ᒫᒃ ᑯᐃᔅᒄ ᒌ ᓈᑖᐤ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐙᒋᔮ, ᒋᔅᑯᑎᒫᒑᓯᐤ᙮” ᐋᒄ ᑳ ᐅᒑᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᐐᒑᐙᑭᓐ, ᑐᑎᐦ ᑭᔨᑆ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᒥᓐ᙮” ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᑳᐦᒋᔥᑎᓈᒡ ᑭᔮᐦ ᑳ ᐅᑎᓈᒡᐦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ᐹᔨᒄ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌᐦ ᐅᐦᒋ ᔮᔨᔥᑳᐱᔅᒋᐱᑎᒥᔨᐤ ᐅᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ ᑳ ᒥᓂᐦᑑᑭᔨᔂᑦ ᐊᓂᔮᔨᐤᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐲᐦᑖᐦ ᐊᓐ ᒋᒨᐦᑯᒫᓐ, ᐙᔥ ᒥᓯᐙ ᐊᐙᓐ ᑳᐦ ᐋᐱᒋᐦᑖᑦ ᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ ᒑ ᒌ ᓂᐱᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐋᐱᑎᓃᔨᒡ ᓂᐱᐦᐋᑭᓅᒑ ᑭᔮᐦ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ᓂᒧᐃ ᐋ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒑ ᒌ ᓂᑐᑎᒧᐙᐅᒋᐱᓐ ᓅᐦᑖᐐ ᒑ ᒌ ᓈᑎᒨᑦ? ᑏᐙᐦᒡ ᒫᒃ ᒋᐱᐦ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᐊᐅᔅᑖ ᒥᐦᒑᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋᓐᒋᓐ ᒑ ᒌ ᐹᒋ ᓈᑎᒧᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ᒥᒄ ᒫᒃ ᐊᓐ ᑎᔮᓈ, ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᑎᐱᐹᔨᒡ ᐊᓐ ᑳᐦ ᐄᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓐ ᒑ ᐄᔅᐱᔨᑯᐱᓈ?” ");
INSERT INTO crl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, “ᒧᔮᒻ ᑖᑆᐦ ᑳᐦ ᐋᐦᒀᑎᓰᑦ ᒋᒧᑎᔅᒃ ᐋᐦ ᑐᑎᐎᔮᒄ ᐋ ᐹᒋ ᓂᑎᐙᐱᒥᔮᒄ ᐋ ᑎᐦᑯᓂᒫᒄ ᓂᑐᐱᔫᐦᑯᒫᓐ ᑭᔮᐦ ᐅᑖᒥᐦᐄᑭᓈᐦᑎᒄ᙮ ᐙᔥ ᔖᔥ ᒋᐱᐦ ᒋᒫᑯᓂᓈᐙᐤ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᒌᐦᑖᔨᐦᒄ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᐋ ᒋᔅᑯᑎᒫᒑᔮᓐ, ᓂᒧᐃ ᒫᒃ ᓂᐦᑖ ᑰᐦᒋ ᑯᒋᑖᓈᐙᐤ ᒑ ᒌ ᒫᑯᓂᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ᒥᒄ ᒫᒃ ᐋᔨᐱᒡ ᒥᓯᐙ ᑎᐱᐱᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᐦᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐋᒄ ᒥᓯᐙ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᐅᔑᒧᔨᒡ ᐋ ᓂᑭᑎᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ᐊᓂᒌ ᒫᒃ ᑳ ᐅᑎᓈᒡ ᒌᓴᔅᐦ ᒌᐦ ᐄᑐᐦᑎᐦᐋᐅᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑳᔮᕙᔅ ᐋᐦ ᑖᔨᒡ᙮ ᔖᔥ ᒫᒃ ᒌ ᓂᔥᑐᐎᔨᐤ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒎᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ᐲᑎᕐ ᒫᒃ ᐙᐦᔨᐤ ᐊᓂᑖᐦ ᒌᐦ ᐅᐦᒋ ᓅᔔᔥᑯᐙᐤ ᐊᓂᔮᔨᐤ ᑳ ᐅᑎᓈᔨᒡ ᒌᓴᔅᐦ, ᐲᐦᐃᒻ ᑳ ᐅᑎᐦᑎᐦᒡ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᐤ᙮ ᐊᓂᑎᐦ ᒫᒃ ᐎᔨᐐᑎᒥᐦᒡ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᐐᔨ ᐲᑎᕐ, ᑳ ᓂᑑᐐᑎᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᑎᐦ ᐋ ᐐᐦ ᐙᐱᐦᑎᐦᒃ ᑖᓐ ᒑ ᐋᔨᐦᑎᓈᓂᐎᔨᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒎᐄᔨᔨᐤ ᒋᐐᐦ ᓈᓂᑐ ᐅᐦᑎᓂᒧᒡ ᑖᓐ ᒑ ᒌᐦ ᐄᔑ ᓂᓂᑎᔮᒋᒫᒡ ᒌᓴᔅᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒌ ᒥᔅᑭᒸᐅᒡ ᒑᒀᔨᐤ ᐋ ᒌᐦ ᑏᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᐱᒋᔅᑎᓱᐙᑎᑯᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒑ ᒌ ᓂᐱᐦᐋᒡ ᒌᓴᔅᐦ, ᐋᑎ ᒥᐦᒑᑐ ᐋ ᒌ ᑎᑯᔑᒡ ᐋ ᓂᓂᑎᔮᒋᒫᒡ᙮ ᒑᒃ ᒫᒃ ᓃᔓ ᓈᐹᐅᒡ ᑳ ᑎᑯᔑᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᐆ ᓈᐹᐤ ᒌᓴᔅ ᓂᒌ ᐹᐦᑎᐙᓈᓐ ᐋᐦ ᐃᔨᑦ, ‘ᓂᑭ ᒌ ᓂᔑᐎᓈᒋᑖᐙᓐ ᒋᔖᒥᓂᑑᐦ ᐅᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᒄ, ᒥᒄ ᒫᒃ ᓂᔥᑐ ᒌᔑᑳᐤ ᐃᔥᐱᔥ ᔖᔥ ᒦᓐ ᓂᑭ ᒌᐦ ᐎᔨᑳᐳᐦᑖᐙᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳ ᐱᓯᑯᑦ, ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᑖᓐ ᒫᒃ ᒑ ᒌᐦ ᐃᔨᓐ ᑳ ᐄᑖᒋᒥᑭᐎᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ᒌᓴᔅ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑ᙮ ᐋᒄ ᒦᓐ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ, “ᑯᐃᔅᒄ ᒫᐦ ᐹᒋ ᐐᐦᑎᒧᓈᓐ ᐋ ᐹᐦᑖᔅᒃ ᐊᓐ ᐹᒫᑎᓰᑦ ᒋᔖᒥᓂᑑ, ᐋᐤ ᐋ ᒌᔨ ᑖᑆᐦ ᙭, ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ?” ");
INSERT INTO crl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᐃᔮᔨᓐ᙮ ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒋᑭ ᐙᐱᒫᐙᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ ᐋ ᐊᐱᑦ ᒋᔖᒥᓂᑑ ᑳ ᓲᐦᑳᑎᓰᔨᒡ ᑭᔮᐦ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ ᒋᐦᒋᒋᔑᑯᐦᒡ ᐋ ᐹᒋᔮᓰᑦ᙮ ᑭᔮᐦ ᒋᑭ ᐙᐱᒫᐙᐤ ᐹᒋ ᑎᑯᔑᒑ ᒋᐦᒋᒌᔑᒄ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ ᐋ ᐅᐦᒋ ᓅᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳ ᐲᑯᐱᑎᐦᒃ ᐅᒑᒀᓂᒻ ᐋᐦ ᐃᔨᑦ, “ᐋᔪᐎᒄ ᐋᓐ ᐋᒄ ᒑ ᐃᔥᐱᔥ ᒫᔮᔨᒫᑦ ᒋᔖᒥᓂᑑᐦ᙮ ᓂᒧᐃ ᒌ ᓂᑎᐙᔨᐦᑎᒸᓈᓂᐤ ᐊᑎᑎᐤ ᒑ ᒌ ᑎᐹᒋᒫᑭᓅᑦ᙮ ᐙᔥ ᒌᔮᓂᐤ ᔖᔥ ᒥᑐᓐ ᒋᒌ ᐹᐦᑎᐙᓂᐤ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒫᔮᔨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ᑖᓐ ᐋᑖᔨᐦᑎᒥᐦᐄᑯᐙᒄ ᑳ ᐄᔑ ᐹᐦᑖᐙᒄ?” ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᑎᑯᓂᔨᐤ ᑭᔨᑆ ᑖᓐ ᐋ ᐄᔑ ᐎᓂᑐᑎᐦᒃ᙮ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᒫᒃ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ᒌᐦ ᓯᐦᒀᑖᐅᒡ ᐅᑖᔥᑎᒥᐦᑯᔨᒡ ᐋᔨᐤᐦ ᒌᐦ ᐅᑖᒧᐦᐙᐅᒡ ᑭᔮᐦ ᒌᐦ ᐅᑎᑖᒥᐦᒀᐦᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ᒌ ᒫᔮᔨᒫᐅᒡ ᐋᐦ ᐄᑖᒡ, “᙭, ᒋᔅᒋᐙᐦᐄᒑ ᒫᐦ, ᐐᐦᑎᒨᓈᓐ ᒫᐦ ᐱᑯᓅ ᐊᐙᓐ ᑳ ᐅᑖᒥᐦᐆᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ᒫᒀᒡ ᒫᒃ ᐋ ᒫᔮᔨᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ, ᐲᑎᕐ ᒌᐦ ᐊᐱᐤ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐎᔨᐐᑎᒥᐦᒡ, ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔅᒀᒥᔨᐤ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᑳᐦ ᐄᑎᑯᑦ, “ᑭᔮᐦ ᒌ ᒋᒌ ᐱᐹᐐᒑᐙᐤ ᒌᓴᔅ ᐊᓐ ᓈᐹᐤ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ᐲᑎᕐ ᒫᒃ ᒌ ᓂᑎᔨᐤ ᐋᐦ ᐃᔨᑦ, ᐋ ᐹᐦᑖᑯᑦ ᒥᓯᐙ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᒑᒀᓐ ᐃᔮᔨᒸᐅᐦᐄᑯᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ᐋᒄ ᑳᐦ ᐋᑎ ᐎᔨᐐᑦ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᑖᓂᐎᔨᒡ᙮ ᐋᒄ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓂᔅᒀᐤ ᑳ ᐙᐱᒥᑯᑦ, ᐋᒄ ᐊᓐ ᐃᔅᒀᔥ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᐆ ᓈᐹᐤ ᑭᔮᐦ ᐐᔨ ᒌ ᐱᐹᐐᒑᐙᐤ ᒌᓴᔅᐦ, ᓈᓵᕆᑦ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᐅᐦᒌᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ᒦᓐ ᒫᒃ ᒌ ᓂᑎᔨᐤ ᐲᑎᕐ ᐋᐦ ᐃᔨᑦ, “ᓂᑖᑆᓐ ᐋᐦ ᐃᔨᔮᓐ ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᐤ ᐊᓐ ᓈᐹᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ᓈᓈᒑᔒᔥ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳ ᓈᓃᐱᐎᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐᐦ ᑳᐦ ᐄᑖᒡ, “ᒥᑐᓐ ᐋ ᒑᔥᑎᓈᐦᐅᔮᐦᒡ ᑭᔮᐦ ᒌᔨ ᐋᑯᑖᐦ ᑳ ᐐᒋᐦᐄᐙᔨᓐ, ᐙᔥ ᐋᐅᒄ ᒧᔮᒻ ᐋᐦ ᐄᑎᐦᑖᑯᓯᔨᓐ ᑭᔮᐦ ᒌᔨ ᐋᐦ ᐊᔨᒥᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ᐲᑎᕐ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᑆᐦ ᐙᔥ ᐊᓐ, ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᐤ ᐊᓐ ᓈᐹᐤᐦ᙮ ᐋᑯᔥ ᓂᑭ ᐎᔮᔅᑐᑖᒄ ᒋᔖᒥᓂᑑ ᓂᑎᐐ ᐃᔮᐙᓈ᙮” ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑏᐙᐦᒡ ᑳ ᐅᐦᒋ ᒋᔅᑐᑦ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ᐋᒄ ᐲᑎᕐ ᑳ ᐅᐦᒋ ᒋᔥᒋᓯᑦ ᑖᓐ ᑳᐦ ᐄᑎᑯᑦ ᒌᓴᔅᐦ, “ᐋᔥᒄ ᐋᒸᔮ ᒋᔅᑑᑦ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ ᓂᔥᑣᐤ ᒋᑭ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᔨᓐ᙮” ᐋᒄ ᒫᒃ ᑳ ᐎᔨᐐᑦ ᑳ ᓂᑐᒫᑑᑦ, ᓲᐦᒃ ᐋ ᒫᑑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ᐐᐱᒡ ᒫᒃ ᒋᔮᒋᔖᐹᔮᔨᒡ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒌ ᓂᔥᑐᐎᒡ ᒑ ᒌᐦ ᐎᔮᔨᐦᑎᐦᒡ ᑖᓂᑖᐦ ᒑ ᒌᐦ ᐅᐦᒋ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒥᒫᒋᒫᐱᐦᑳᑎᒸᐦᒡ ᐅᑎᐦᒌᔨᐤ, ᐋᒄ ᑳ ᒋᔅᑐᐦᑎᐦᐋᒡ᙮ ᐊᓂᑖᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐹᔨᓕᑦᐦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ᒍᑖᔅ ᒫᒃ ᐊᓐ ᑳ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᐄᔥᐱᐦ ᒑᔅᒑᔨᑎᒃ ᑖᑆᐦ ᒑ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᓴᔅᐦ ᓈᔥᒡ ᒌ ᒥᐦᒋᔨᐙᓲ ᐋᒄ ᑳᐤ ᑳ ᐄᑐᐦᑐᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᓂᔥᑐᒥᑎᓂᐤ ᔓᐎᔮᓈᐱᔅᑯᔥ ᑳ ᒥᔮᑭᓅᑦ, ");
INSERT INTO crl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᓄᐎᒡ ᓂᐎᓂᑐᑖᓐ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔑᒥᒃ ᓈᐹᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᒥᒌᐦᑐᑎᐦᒃ᙮” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ, “ᑖᐹ ᐎᔮᔥ ᓂᑭ ᒌᐦ ᑎᓈᓐ ᓃᔮᓐ᙮ ᒌᔨ ᒋᑭ ᐐ ᒥᔪᐱᔨᐦᑣᓱᓐ ᐊᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ᐋᒄ ᒍᑖᔅ ᐊᓂᑖᐦ ᒧᔅᑎᑎᐦᒡ ᑳ ᐄᔑ ᐙᐱᓈᑦ ᐊᓂᔮᔨᐤ ᔔᐎᔮᓈᐱᔅᒄ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑳᐦ ᐋᑎ ᒫᒌᑦ᙮ ᑳ ᒌᔅᐦᑑᐦᑖᑦ ᑭᔮᐦ ᑳ ᓂᑑᐊᑯᑏᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ᐋᒄ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳ ᐅᑎᓈᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᐋᒄ ᑳᐦ ᐃᔨᒡ, “ᐄᑎᔥᑖᐤ ᐐᔔᐙᐎᓐ ᐋᑳ ᒑ ᒌᐦ ᑭᓂᐙᔨᒫᑭᓅᑦ ᐆ ᔓᐎᔮᓐ ᐅᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋᔥ ᒌᐦ ᐋᐱᑎᓰᐤ ᐋ ᑎᐱᐦᐋᒧᐙᑭᓅᑦ ᐊᐙᓐ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ᐱᑎᒫ ᒫᒃ ᒌᐦ ᐋᔨᒸᐦᐄᑯᒡ ᐅᔮᔨᐤ᙮ ᐋᒄ ᒑᒃ ᑳ ᓂᔅᑯᒧᒡ ᒑ ᒌᐦ ᐅᑎᓂᒑᐦᒡ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᑳ ᒌᐦ ᐅᐦᑎᓈᑭᓅᑦ ᓯᔅᒋᐤ ᐎᔮᑭᓐ ᐋ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳᐦ ᐋᑎ ᐄᑖᐱᒋᐦᑖᒡ ᐋ ᓂᐦᐄᑯᐙᒡ ᒫᓂᑖᐤᐦ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐋᑎ ᐃᔑᓂᐦᑳᑖᒡ ᐊᓐ ᐊᔅᒌ, “ᒥᐦᒄ ᐊᔅᒌ᙮” ᐋᐅᒄ ᒫᒃ ᐋᔥᒄ ᐊᓅᐦᒡ ᐋᔑᓂᐦᑳᑖᒡ ᐊᓐ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ᐋᒄ ᒫᒃ ᑳ ᑎᐱᐱᔨᒡ ᐊᓂᔮ ᒉᕆᒫᔮ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳᐦ ᐃᔨᑯᐱᓈ, ᒌᐦ ᐅᑎᓈᐅᒡ ᐊᓂᔮᔨᐤ ᓂᔥᑐᒥᑎᓂᐤ ᔔᐎᔮᓈᐱᔅᒄ ᑖᓐ ᑳ ᐄᔑ ᓂᔅᑯᒧᒡ ᐱᔅᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᒑ ᐃᔥᐱᔥ ᑎᐱᐦᐙᒡ ᐅᔮᔨᐤ ᑳ ᐄᑖᒋᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ᐋᒄ ᒫᒃ ᑳ ᐱᒋᔅᑎᓂᐦᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᒑ ᒌᐦ ᐅᑎᓂᒑᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᑳ ᒌᐦ ᐅᐦᑎᓈᑭᓅᑦ ᓯᔅᒋᐤ ᐎᔮᑭᓐ ᐋ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᒡ᙮ ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒥᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᑑᐎᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒌᐦ ᐃᔨᒑ ᒉᕆᒫᔮ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐐᐦᑎᔅᑭᐎᑳᐴᔥᑎᐙᐤ ᐹᔨᓕᑦᐦ ᐊᓂᔮᔨᐤ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐅᒋᔕᐅᒋᒫᒻ᙮ ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᑦ, “ᒌᔨ ᐋ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ?” ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᐊᓐ ᐋᓯᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ᐋᒄ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᓂᓈᐦᑭᐤ ᒌᐦ ᐄᔑ ᒥᒥᒑᒋᒥᑰ, ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐹᔨᓕᑦ, “ᓂᒧᐃ ᐋ ᒌ ᐹᐦᑎᐙᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᓈᐦᑭᐤ ᐄᑖᒋᒥᔅᒡ?” ");
INSERT INTO crl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ᓂᒧᐃ ᒫᒃ ᐊᔮᐱᒡ ᐅᐦᒋ ᒋᔅᑑ ᒌᓴᔅ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐅᒋᔕᐅᒋᒫᒻ ᓈᔥᒡ ᑳ ᒥᔅᑳᑖᔨᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ᐋᔑᑯᒻ ᐱᐳᓐ ᒫᒃ ᐄᔥᐱᐦ ᐙᑎᐦᒋᐱᔨᐦᒡ ᐊᓐ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᐹᔨᓕᑦ ᒌ ᐱᒋᔅᑎᓈᐤ ᒫᓐ ᐹᔨᒄ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ ᐋ ᒌᐦ ᐎᓂᐦᐱᓱᔨᒡ ᐅᐦᒋ᙮ ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᓈᑐᐙᔨᒫᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑭᓂᐎᔨᒡ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᐱᒋᔅᑎᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ᒫᒀᒡ ᒫᒃ ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᓈᔥᒡ ᐋ ᒋᔅᒑᔨᒫᑭᓅᑦ ᑖᓐ ᑳ ᐄᔑ ᓂᓈᐦᑭᐤ ᐎᓂᐦᐱᓱᑦ, ᐹᕌᐹᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ᐄᔥᐱᐦ ᒫᒃ ᓈᔅᑐᐎᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ, ᐹᔨᓕᑦ ᒌᐦ ᑯᒀᒋᒫᐤ, “ᐊᐙᓐ ᓈᑐᐙᔨᒥᔮᒄ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑎᑯᒡ, ᐹᕌᐹᔅ ᐋ ᑭᔮᐦ ᒫᒃ ᒌᓴᔅᐦ ᐊᓐ ᙭ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ?” ");
INSERT INTO crl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ᒌ ᒋᔅᒑᔨᒫᐤ ᐹᔨᓕᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐋ ᐅᐐᐦᑖᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐋᐦ ᐋᐎᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐱᒋᔅᑎᔓᐙᑎᒫᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ᒫᒀᒡ ᒫᒃ ᐹᔨᓕᑦ ᐋ ᐊᐱᑦ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᐐᐤᐦ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᔨᐤ ᐊᐙᔨᐤᐦ ᒑ ᒌᐦ ᐄᑎᑯᑦ, “ᐊᑳᐐ ᐎᔮᔥ ᑐᑐᐤ ᐊᓐ ᑳ ᑯᐃᔅᑯᑖᑎᓰᑦ ᓈᐹᐤᐦ᙮ ᐙᔥ ᓈᔥᑖᑆᐦ ᓂᓈᔨᐦᑳᑖᔨᒥᐦᐄᑯᐙᓐ ᑖᓐ ᑳ ᐄᔑ ᐳᐙᑎᒃ ᑖᐱᔅᑳᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡᐦ ᒌ ᔒᐦᑰᒋᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒑ ᒌᐦ ᑯᒀᒋᒫᔨᒡ ᐹᔨᓕᑦᐦ ᐹᕌᐹᔅᐦ ᒑ ᒌ ᐱᒋᔅᑎᓈᔨᒡ, ᐋᒄ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ᐋᒄ ᐹᔨᓕᑦ ᒦᓐ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ, “ᑖᓐ ᒫᒃ ᐊᓐ ᓈᑐᐙᔨᒥᔮᒄ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑎᑯᒡ ᐅᒌ ᐋ ᓃᔑᒡ?” ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᐄᑖᒡ, “ᐹᕌᐹᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᒫᒃ ᒑ ᑐᑎᐎᒃ ᐆ ᒌᓴᔅᐦ, ᐊᓐ ᙭ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ᙮” ᐋᒄ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᐃᔨᒡ, “ᒌᔅᑖᔅᑯᐦᐋᐦᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᔨᐤ ᐋᒄ? ᑖᓐ ᑳ ᐄᔑ ᒥᒌᐦᑐᑎᐦᒃ?” ᐋᒄ ᐋᐦᒡ ᐊᑎᑎᐤ ᑳᐦ ᐋᔑᐦᒀᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, “ᒌᔅᑖᔅᑯᐦᐋᐦᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᐦᑎᐦᒃ ᐹᔨᓕᑦ ᐋᑳ ᒑ ᒌᐦ ᔑᐦᑯᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑭᔮᐦ ᒑᔥᑳ ᐋᐦ ᐋᑎ ᒋᐦᒋ ᒥᒋᐱᔨᓈᓂᐎᔨᒡ ᑳ ᐅᑎᓂᐦᒃ ᓂᐲᔨᐤ ᑳ ᒋᔅᑖᐹᐅᑎᐦᒑᑦ ᐅᐦᑎᔅᑰ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐐ ᓃᔨ ᓂᑭ ᐅᐦᒋ ᐊᑖᒫᔨᐦᑖᑯᓯᓐ ᒑ ᓂᐱᐦᐋᑭᓅᑦ ᐆ ᓈᐹᐤ᙮ ᒌᔨᐙᐤ ᐆ ᑳ ᐊᔨᐦᑎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᐄᑖᒡ, “ᐋᑯᔥ ᓃᔮᓐ ᑭᔮᐦ ᓂᑎᐙᔒᒥᓈᓂᒡ ᓂᑭ ᐱᑎᑯᔥᑳᑯᐙᓈᓐ ᑖᓐ ᒑ ᐄᔑ ᓂᐱᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᐱᒋᔅᑎᓈᒫᑭᓂᐎᔨᒡ ᐹᕌᐹᔅᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᐱᔑᔥᑖᐦᐅᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᐱᒋᔅᑎᔓᐙᑖᑦ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ᐋᒄ ᐹᔨᓕᑦ ᐅᓂᑐᐱᔨᒻᐦ ᑳ ᐄᑐᐦᑎᐦᐋᔨᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐐᒋᔨᐦᒡ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᐙᔅᑳᑳᐳᔥᑎᐙᐅᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ᒌ ᒥᓂᒸᐅᒡ ᒫᒃ ᐅᒑᒀᓂᒥᔨᐤ᙮ ᐋᒄ ᐋ ᒥᐦᒀᑭᓃᔨᒡ ᐊᑯᐦᐱᔨᐤ ᑳ ᐳᔥᑭᒧᔮᐦᒡ ᒧᔮᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᐄᑖᔅᐱᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ᐋᒄ ᑳ ᐅᔑᐦᑎᒧᐙᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐊᔥᑐᑎᓂᔨᐤ, ᑳᑳᐙᔅᑯᓃᔨᒡ ᓂᐱᓯᔮᐦᑎᒄ ᐋ ᒌᐦ ᐋᐱᒋᐦᑖᐙᒡ᙮ ᑭᔮᐦ ᒌ ᒥᔮᐅᒡ ᒥᔅᑎᑯᔨᐤ ᒑ ᒌ ᑎᐦᑯᓂᒥᔨᒡ᙮ ᐋᒄ ᑳ ᓃᐱᔅᑰᐳᐙᒡ ᐅᐦᑎᔅᑰ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ᙮ ᒌ ᒫᔮᔨᒫᐅᒡ ᒧᔮᒻ ᐋ ᒫᒥᐦᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᐋᐅᒄ ᒌᔨ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ᒌᐦ ᓯᐦᒀᑖᐅᒡ ᒫᒃ᙮ ᐋᒄ ᑳ ᐅᑎᑖᒥᔅᑎᒀᓈᐦᐙᒡ ᐊᓂᔮᔨᐤ ᒥᔅᑎᑯᔨᐤ ᑳ ᑎᐦᑯᓂᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒫᔮᔨᒫᒡ ᐋᒄ ᑳ ᒥᓂᒸᒡ ᐊᓂᔮᔨᐤ ᐊᑯᐦᐱᔨᐤ ᑳ ᒋᒋᔥᑭᒥᔨᒡ ᐋᒄ ᐐᔨ ᐅᒑᒀᓂᒥᔨᐤ ᑳ ᐳᔥᑭᒧᔮᐦᒡ᙮ ᐋᒄ ᑳ ᐎᔨᐐᐦᑎᐦᐋᒡ ᒑ ᓂᑑᒌᔅᑖᔅᑯᐦᐙᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᑎ ᐎᔨᐐᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᒌ ᓂᒋᐦᐋᐅᒡ ᓈᐹᐤ ᓵᐃᒥᓐ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᓵᐃᕇᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐋ ᐅᐦᒌᔨᒡ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᔒᐦᒋᒫᒡ ᒑ ᒌᐦ ᐎᓂᑳᑎᐦᐙᔨᒡ ᒌᓴᔅᐦ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ᒀᓪᒀᕧ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᒌᓴᔅᐦ᙮ ᐆ ᒀᓪᒀᕧ ᑳ ᐄᓈᓅᒡ, ᐊᓂᑎᐦ ᐋᐦᑎᑯᐦᒡ ᒥᔥᑎᒀᓂᑭᓐ ᐄᔑ ᐄᑣᔥᑎᒧᐙᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ᐋᑯᑖᐦ ᑳ ᐐ ᒥᓂᐦᐋᑭᓅᑦ ᒌᓴᔅ ᔔᒥᓈᐴᔨᐤ ᒋᔨᑰ ᐐᓯᑳᐳᔨᐤ ᐋ ᒌ ᐱᒋᔅᑎᓂᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᑯᒋᔥᑎᐦᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᐐ ᒥᓂᐦᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒡ ᒌᓴᔅᐦ, ᒋᐐᐦ ᑖᐅᓂᒫᑑᐎᒡ ᐅᒑᒀᓂᒥᔨᐤ᙮ ᒌᐦ ᐐᑖᐅᐦᐄᒑᐎᒡ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐎᔮᔨᐦᑎᐦᒡ ᐊᐙᔨᐤᐦ ᒑ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒑᒀᓂᒥᔨᐤ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᑎᒡ ᐋᑯᑖᐦ ᑳ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ, ᒌ ᒫᑎᓂᒫᑑᐎᒡ ᓂᒑᒀᓂᒻ ᑭᔮᐦ ᒌ ᑖᐅᐦᐄᑭᓂᐤ ᓂᑎᑯᐦᑉ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ᐋᒄ ᒫᒃ ᑳ ᐅᐙᔮᐱᒡ ᐋ ᓈᓈᑭᒋᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ᐃᔥᐱᒥᔒᔥ ᒫᒃ ᐊᓂᑎᐦ ᐅᔥᑎᒀᓂᐦᒡ ᒌᐦ ᐊᑯᐦᑎᑭᐦᐄᑭᓂᐎᔨᐤ ᐋ ᒥᓯᓈᑖᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᑖᒫᔨᒫᑭᓅᑦ᙮ ᐅᔮᔨᐤ ᒌᐦ ᐄᑎᔅᑖᔨᐤ, “ᐋᐅᒄ ᐆ ᒌᓴᔅ, ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ᓃᔓ ᒋᒧᑎᔅᒃᐦ ᒌ ᒌᔅᑖᔅᑯᐦᐙᐅᒡ ᑭᔮᐦ, ᐹᔨᒄ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ ᒌᐦ ᐊᑯᒋᓐ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᐊᓂᑖᐦ ᐅᓂᒥᐦᒌᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ᐋ ᐱᒧᐦᑖᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᒌ ᐙᐙᐱᔅᒀᔫᒡ ᑭᔮᐦ ᒌ ᒫᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ᒌᐦ ᐄᑖᐅᒡ, “ᒌᔨ ᑳ ᐃᔨᓐ ᒑ ᒌ ᓂᔑᐎᓈᒋᑖᔨᓐ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᐋᒄ ᒫᒃ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᒦᓐ ᑳᐤ ᒑ ᒌᐦ ᐎᔨᑳᐳᐦᑖᔨᓐ, ᑖᑆᐦ ᐃᔮᐎᓈ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐱᒫᒋᐦᐄᓲ ᐹᒋ ᓃᔖᐦᑎᐐᐦ ᐊᓐ ᒋᑖᔑᑖᔮᐦᑎᑯᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ᐋᔪᐎᒄ ᑭᔮᐦ ᑳ ᐄᔑ ᒫᔮᔨᒫᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒎᐄᔨᔨᐤ᙮ ᒌᐦ ᐃᔨᐅᒡ, ");
INSERT INTO crl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ᒌ ᐱᒫᒋᐦᐋᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ᙮ ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᒌ ᐱᒫᒋᐦᐄᓲ ᐐᔨ᙮ ᓂᒥᔮᐤ ᐋ ᒫᒃ ᐆ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ? ᒑ ᒌ ᐱᑯᐦᐄᓱᒀ ᒫᒃ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᐅᐦᒋ ᐋᒄ ᒑ ᑖᑆᔮᔨᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ, ᑖᑆᐦ ᒫᐦ ᑭᑎ ᐐᒋᐦᐄᑰ ᒋᔖᒥᓂᑑ ᐊᓅᐦᒡ, ᐐᐦ ᐐᒋᐦᐄᑯᒑ᙮ ᐙᔥ ᒌᐦ ᐃᔨᐤ, ‘ᓃᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅ᙮’ ” ᑖᑆᐦ ᒫᐦ ᑭᑎ ᐐᒋᐦᐄᑰ ᒋᔖᒥᓂᑑ ᐊᓅᐦᒡ, ᐐᐦ ᐐᒋᐦᐄᑯᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᒧᑎᔅᒃ ᑳ ᐃᔅᒡ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ ᐋᔪᐎᒄ ᑭᔮᐦ ᑳ ᐄᔑ ᒫᔮᔨᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ᑳᐦ ᐋᐱᐦᑖᒌᔑᑳᒡ ᒫᒃ ᐋᑯᑖᐦ ᒥᑐᓐ ᐋ ᑭᔅᑎᐱᔅᑳᒡ ᑳ ᐃᓯᓈᑯᐦᒡ ᒥᓯᐙ ᐋ ᐃᔥᐱᔖᒡ ᐊᓂᑎᐦ ᐊᓐ ᐊᔅᒌ᙮ ᓂᔥᑣᐤ ᐋᐦᒋᓂᒀᓂᐦᑖᒡ ᐋᐅᒄ ᑳ ᐃᓯᓈᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ᐎᔮᔥ ᒫᒃ ᓂᔥᑐ ᐋ ᐃᔅᐱᔨᒡ, ᒌᓴᔅ ᐋ ᒋᔣᐙᑦ ᑳᐦ ᐃᔨᑦ, “ᐄᓨᐃ, ᐄᓨᐃ, ᓛᒫ ᓵᐹᑭᑖᓃ᙮” ᒫᐤ ᐋ ᐄᔑ ᐄᑣᔥᑎᒧᐙᑖᑭᓂᐎᒡ ᐆ, “ᓂᒋᔖᒥᓂᑑᒻ, ᓂᒋᔖᒥᓂᑑᒻ, ᒑᒀᓐ ᐙᐦᒋ ᐹᒋ ᓂᑭᓯᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳ ᓈᓃᐱᐎᒡ ᒌ ᐹᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᐄᓛᐃᒑ ᐙᔥ ᐊᓐ ᑖᑆᑖᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ᑏᐙᐦᒡ ᒫᒃ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᒌᐦ ᐅᐦᒋ ᐅᑎᓂᒻ ᒑᒀᔨᐤ ᐅᐦᐱᓂᐦᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᑳ ᒋᐦᑖᓂᐦᒃ ᐊᓂᑖᐦ ᐋ ᐎᓯᑳᑭᒦᒡ ᔔᒥᓈᐴᔨᐤ᙮ ᐋᒄ ᐋ ᐎᓂᔥᒀᔅᑯᓃᔨᒡ ᒥᔅᑎᑯᐦᒡ ᑳ ᒋᑭᒧᐦᑖᑦ᙮ ᐋᒄ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐅᑑᓃᔨᒡ ᑳ ᐄᑎᓂᐦᒃ ᐋ ᐐ ᒥᓂᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒌᐦ ᐃᔨᐅᒡ, “ᐊᑳᐐ ᐱᑎᒫᐦ᙮ ᐊᔑᓂᐙᐦᑖᐤ ᒫᐦ ᒑ ᐹᒋ ᐐᒋᐦᐄᑯᒀ ᑖᑆᐦ ᐄᓛᐃᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ᒌᓴᔅ ᒫᒃ ᒦᓐ ᒌ ᑖᑆᐤ ᐋ ᒋᔣᐙᑦ᙮ ᐋᒄ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ᐄᔥᐱᐦ ᒫᒃ ᓈᐱᑦ, ᐊᓐ ᐋᑯᔮᑯᐦᐄᑭᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᒥᑐᓐ ᒌ ᑖᔅᒋᐱᔨᐤ ᐊᓂᑖᐦ ᐋᐦ ᐄᔥᒀᔮᑭᒡ ᐄᔑ᙮ ᐊᔅᒌ ᑭᔮᐦ ᒫᒃ ᒌᐦ ᐋᔮᐦᒋᐱᔨᔨᐤ᙮ ᑭᔮᐦ ᐊᓯᓃᔨᒡ ᒌ ᑖᔅᒋᐱᔫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ᒌᐲᑭᒥᒄ ᒌᐦ ᐋᐱᐦᐄᐱᔨᐤ᙮ ᒥᐦᒑᑐ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᑎᔨᔨᒻᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒌᐦ ᐎᓂᔥᑳᓂᒫᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ᒌ ᒋᔅᑐᐦᑖᐅᒡ ᒫᒃ ᐊᓂᑎᐦ ᒌᐲᑭᒥᑰᐦᑳᓂᐦᒡ ᐅᐦᒋ ᐊᓂᒌ ᑳ ᐎᓂᔥᑳᓈᑭᓂᐎᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᓂᔥᑳᔨᒡ ᒌᓴᔅᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᐋᒄ ᐊᓂᑖᐦ ᑳ ᐱᔮᐦᑭᓃᒡ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᑳ ᐙᐱᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ᐊᓐ ᒫᒃ ᓂᑐᐱᔨᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᓂᑐᐱᔨᒻᐦ ᑳ ᓈᓈᑭᒋᐦᐋᔨᒡ ᒌᓴᔅᐦ ᐄᔥᐱᐦ ᐎᔮᐱᐦᑎᐦᒡ ᐋ ᑯᐎᐦᑯᓃᔨᒡ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ ᓈᔥᒡ ᒌ ᓵᒋᓯᐎᒡ᙮ ᐋᒄ ᑳᐦ ᐃᔨᒡ, “ᑖᑆᐦ ᒀ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ᒌ ᒥᐦᒑᑑᒡ ᒫᒃ ᐃᔅᒀᐅᒡ ᐊᓂᑎᐦ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒋ ᐐᒑᐙᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᑳ ᒌ ᐙᐐᒋᐦᐋᒡ᙮ ᐙᐦᔨᐤ ᐊᓂᑖᐦ ᒌᐦ ᐅᐦᒋᑳᐳᐎᒡ ᐋ ᓈᓈᑭᒋᐦᐄᐙᒡ ᑖᓐ ᐋᐦᑎᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ᐋᑯᑖᐦ ᑳᐦ ᑖᒡ ᒣᕇ ᒫᒃᑖᓖᓐ ᑭᔮᐦ ᒣᕇ, ᒉᒥᔅ ᑭᔮᐦ ᒍᓯᕝ ᐅᑳᐐᐙᐤ, ᑭᔮᐦ ᓭᐱᑏ ᐅᑯᓯᔅᐦ ᐅᑳᐐᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎᐅᑖᑯᔑᒡ ᒌ ᑎᑯᔑᓐ ᓈᐹᐤ ᒍᓯᕝ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᓈᔥᒡ ᒌ ᒥᓯᒋᓰᐤ ᐆ ᓈᐹᐤ᙮ ᐊᓂᑖᐦ ᒫᒃ ᐃᐦᑖᐎᓂᔨᐤ ᐋᕆᒫᕠᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒌᑦ᙮ ᒌ ᓅᔔᔥᑯᐙᐤ ᑭᔮᐦ ᐐᔨ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ᒌ ᓂᑎᐙᐱᒫᐤ ᒫᒃ ᐹᔨᓕᑦ᙮ ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑯᑦ ᒌᓴᔅᐦ ᐐᔮᔨᐤ᙮ ᐹᔨᓕᑦ ᒫᒃ ᒌᐦ ᐄᑎᔑᐦᐙᐤ ᒑ ᒌ ᒥᔨᒫᑭᓂᐎᔨᒡ ᒍᓯᕝᐦ ᐊᓂᔮᔨᐤ ᒥᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ᐋᒄ ᒍᓯᕝ ᑳ ᓃᐦᑎᓂᒸᑦ ᒌᓴᔅᐦ ᐐᔮᔨᐤ ᐊᓂᑎᐦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᐅᐦᒋ᙮ ᒌᐦ ᐋᑎ ᐐᔅᒀᔮᒋᓂᒻ ᒫᒃ ᓈᔥᒡ ᐋ ᐱᔮᐦᒑᑭᓃᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ᐊᓂᑖᐦ ᒫᒃ ᐋ ᒌ ᐙᑎᒀᐱᔅᑭᐦᐊᒧᑯᐱᓈ, ᐋᓅᐦᒌᐦᒑ ᐋ ᒌᐦ ᐅᔑᐦᑖᑯᐱᓈ, ᐋᑯᑖᐦ ᑳ ᐲᐦᑎᐦᐋᐦᒃ᙮ ᐐᔨ ᒫᒃ ᒋᐱᐦ ᒌ ᓂᐦᐄᑭᐙᑭᓂᐤ ᐊᓂᑎᐦ ᐄᔥᐱᐦ ᐴᓂᐱᒫᑎᓰᒑ᙮ ᐋᒄ ᐋ ᒥᐦᒑᐱᔅᒋᔨᒡ ᐊᓯᓃ ᑳ ᑎᐦᑎᐱᓈᑦ ᐊᓂᑖᐦ ᐋ ᐃᔥᒀᐦᑎᒥᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᑳ ᒋᐱᔑᒫᑦ᙮ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᑖᒡ ᒣᕇ ᒫᒃᑖᓖᓐ ᑭᔮᐦ ᐊᓐ ᑯᑎᒃ ᒣᕇ ᐋ ᐅᑖᔥᑎᒥᐱᔥᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ᐊᓐ ᒫᒃ ᒦᓐ ᐎᔮᐱᐦᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᑎᔨᐙᓲ ᒌᔑᑳᒧᐙᐤ᙮ ᐊᓂᒌ ᒫᒃ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᓂᒋᔥᑭᐙᐅᒡ ᐹᔨᓕᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᐅᒋᒫᐤ, ᓂᒋᔥᒋᓯᓈᓐ ᐋᔥᒄ ᐋ ᒌ ᐱᒫᑎᓰᑦ ᐊᓐ ᑳ ᓂᓂᑎᔨᑦ ᐋ ᒌᐦ ᐃᔨᑦ, ‘ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᐋᒄ ᒑ ᐎᓂᔥᑳᓂᑭᐎᔮᓐ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮’ ");
INSERT INTO crl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ᐄᑎᔓᐙ ᒫᐦ ᔮᒀᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᑭᓂᐎᒡ ᐊᓐ ᒌᐲᑭᒥᑯᐦᑳᓐ ᐹᑎᔥ ᒌ ᓂᔥᑐᒌᔑᑳᒑ᙮ ᐙᔥ ᑭᑎ ᒌ ᐹᒋ ᒋᒧᑎᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᔮᔨᐤ ᐅᔨᐤ ᒑ ᒌ ᓂᓂᑎᔨᒫᔨᒡ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᔨᔨᒡ ᐋ ᒌᐦ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᒄ ᐊᓐ ᒫᐦᒋᒡ ᓂᓂᑎᔨᐎᓐ ᐊᐅᔅᑖ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒋᐦᑳᐙᓯᑖᑯᓐ ᐃᔥᐱᔥ ᐐ ᐊᓐ ᓃᔥᑎᒻ ᓂᓂᑎᔨᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ, “ᐅᑎᓈᐦᑯᒡ ᓂᑐᐱᔫᒡ᙮ ᒑ ᓂᑑᔮᐃᒋᐦᑖᔮᒄ ᐊᓐ ᒌᐲᑭᒥᑯᐦᑳᓐ ᒥᒄ ᒑ ᒌᐦ ᐃᔥᐱᔥ ᔮᐃᒋᐦᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᒡ᙮ ᒌ ᓂᑑᒋᔅᒋᓂᐦᐋᒋᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᑳ ᒋᐦᐱᔑᒫᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᒌᐲᑭᒥᑰᐦᑳᓂᐦᒡ ᒑᐦ ᐋᑳ ᐊᐙᔨᐤᐦ ᒌ ᐱᒫᔨᒫᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᒡ ᓂᑐᐱᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒥᔮᐅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᐊᓐ ᒫᒃ ᐋᐦ ᐋᑎ ᐹᑖᐱᐦᒡ ᒣᕇ ᒫᒃᑖᓖᓐ ᑭᔮᐦ ᒣᕇ ᒌ ᓂᑎᐙᐱᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ᔑᔥᒋᑯᒡ ᒫᒃ ᒌ ᒥᔥᑎᐦ ᑯᐃᐦᑯᓐ, ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑖᓐᒋᓂᒻ ᑳ ᐹᒋ ᔮᓰᔨᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ, ᑳ ᐄᒑ ᑎᐦᑎᐱᓈᔨᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᐊᓂᑎᐦ ᐃᔥᒀᐦᑖᒥᐦᒡ ᐅᐦᒋ, ᐋᒄ ᑳ ᑖᐦᑎᐱᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ᒧᔮᒻ ᒫᒃ ᐋ ᐙᔥᑖᐱᔨᐦᒡ ᐋ ᐃᔥᐱᔥ ᒌᐦᑳᔮᔥᑖᒡ ᐋᐅᒄ ᐋᓐ ᑳ ᐃᓯᓈᑯᓯᑦ ᐊᓐ ᐋᓐᒋᓐ ᐄᔥᐱᐦ ᐙᐦᒋ ᓅᑯᓯᑦ, ᑭᔮᐦ ᐅᒑᒀᓂᒻ ᒧᔮᒻ ᑰᓐ ᐋ ᐃᔥᐱᔥ ᐙᐱᔑᑦ ᐋᔪᐎᒄ ᐋᓐ ᑳ ᐃᓯᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ᐊᓂᒌ ᒫᒃ ᓂᑐᐱᔫᒡᐦ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᐋ ᐃᔥᐱᔥ ᑯᔥᑖᒋᒡ, ᒌ ᓂᓂᒥᐱᔫᒡ, ᒌ ᐱᐦᒋᔑᓂᒡ ᒫᒃ ᐋᒄ ᒧᔮᒻ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑳ ᐃᓯᓈᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","ᐋᒄ ᐊᓐ ᐋᓐᒋᓐ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤᐦ, “ᐊᑳᐐ ᑯᔥᑖᒋᒄ, ᒋᒋᔅᒑᔨᒥᑎᓈᐙᐤ ᐋ ᓈᓂᑐᐙᔨᒫᒄ ᒌᓴᔅ ᐊᓐ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ᓂᒧᐃ ᑖᐤ ᐅᑎᐦ, ᐙᔥ ᒌᐦ ᐎᓂᔥᑳᐤ ᒧᔮᒻ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒑ ᑎᒃ᙮ ᐋᔥᑎᒧᒄ ᐹᒋ ᑭᓂᐙᐱᐦᑎᒸᒄ ᐊᓂᑎᐦ ᑳ ᐱᒥᔑᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ᒫᒌᒄ ᐐᐦ ᒌᐲᔨᒄ, ᒫᒃ ᓂᑑᐐᐦᑎᒫᒥᐦᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐋ ᒌᐦ ᐎᓂᔥᑳᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᐊᓅᐦᒡ ᒫᒃ ᓃᑳᓐ ᐄᑐᐦᑖᐤ ᑳᓕᓖᐦᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᐙᐱᒫᒄ᙮ ᐋᐅᒄ ᐆ ᑳ ᐐᐦ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᐙᐦᒋ ᒌ ᑎᑯᔑᓂᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ᐊᓂᒌ ᒫᒃ ᐃᔅᒀᐅᒡ ᒌᐦ ᐎᔨᐐᐱᐦᐄᑑᒡ ᐊᓂᑎᐦ ᒌᐲᑭᒥᑰᐦᑳᓂᐦᒡ ᐅᐦᒋ ᐋ ᓵᒋᓯᒡ ᑭᔮᐦ ᐋ ᒨᒋᒑᔨᐦᑎᐦᒡ, ᑳ ᓂᑑᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ᔑᔥᒋᑯᒡ ᒫᒃ ᒌᓴᔅᐦ ᒌ ᓂᒋᔥᑳᑯᒡ ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᐐᐦ ᒋᔮᒫᔨᐦᑎᒧᒄ᙮” ᐋᒄ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᒡ ᐋᐦ ᑖᔨᒡ ᑳ ᒫᑯᓂᒸᒡ ᐅᓯᑎᔨᐤ ᐋᒄ ᑳ ᒫᒥᐦᒋᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᑯᔥᑖᒋᒄ, ᓂᑑᐐᐦᑎᒫᐦᑯᒡ ᓃᒋᔖᓂᒡ ᑳᓕᓖᐦᒡ ᒑ ᐄᑐᐦᑖᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᐙᐱᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ᒫᒀᒡ ᒫᒃ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᐋ ᐃᔥᐱᓰᔨᒡ ᐋ ᐐᐦ ᓂᑑᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐱᔅᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᒌᐦ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᑳ ᓂᑑᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡᐦ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᑎᐦᒡ ᐋᐦ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ᐋᒄ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐄᔨᔨᐤᐦ ᑳ ᓂᔥᑐᐐᒡ ᐋᒄ ᑳ ᐎᔮᔨᐦᑎᐦᒡ ᑖᓐ ᒑᐦ ᑎᒡ᙮ ᒌ ᒥᔮᐅᒡ ᒫᒃ ᒥᔥᑏᐦ ᔓᐎᔮᓐ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ᐋᒄ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤᐦ, “ᒑ ᐄᑖᑯᒡ ᐄᔨᔨᐅᒡ, ᑖᐱᔅᑳᒡ ᒫᒀᒡ ᑳ ᓂᐹᔮᐦᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒌᒧᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᐦᑎᒥᔨᐤ ᐊᓂᔮᔨᐤ ᐅᔨᐤᐦ, ᐋᒄ ᑳ ᒋᔅᑑᐦᑖᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ᐹᐦᑎᐦᒃ ᒫᒃ ᐅᔮᔨᐤ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ, ᓂᑭ ᔑᐦᑯᒋᒫᓈᓐ ᒑᐦ ᐋᑳ ᒌᔨᐙᐤ ᒌᐦ ᐊᑖᒫᔨᒥᑯᐎᔮᒄ, ᒋᑭ ᒥᔪᐱᔨᐦᐄᑎᓈᓐ ᒑ ᐋᑳ ᐎᔮᔥ ᒌᐦᑐᑖᑯᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᐅᑎᓈᒡᐦ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ, ᐋᔪᐎᒄ ᒫᒃ ᑳᐦ ᑎᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑭᓂᐎᒡ᙮ ᐆ ᒫᒃ ᑎᐹᒋᒧᐎᓐ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᑎᐹᒋᒧᔥᑐᐙᑭᓂᐎᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᐆ ᒫᒀᒡ ᑭᔮᐦ ᐊᓅᐦᒡ ᑳᔑᑳᔨᒡ ᐋᔥᒄ ᐋᐅᒄ ᐋᐦᑖᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ᐋᒄ ᐊᓂᒌ ᐹᔨᑯᔖᑉ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᑳᓕᓖᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ ᒑ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᒡ, ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᐋᑦ ᐱᔅᒡ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᐋ ᒌᐦ ᐋᓍᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ᐋᒄ ᑳ ᓈᑎᑯᒡ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᒡ, “ᓂᒌ ᒥᔨᑰᓐ ᓃᔨ ᒥᑐᓐ ᒑ ᒌᐦ ᐅᒋᒫᐦᑭᐦᑎᒫᓐ ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ᐆ ᒫᒃ ᐅᐦᒋ ᒫᒌᒄ ᓂᑎᐙᐱᒫᐦᑯᒡ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᒑ ᐐᐦᑐᑎᐙᑯᒡ ᒑ ᒌᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔮᓐ, ᒑ ᓰᑭᐦᐋᐦᑐᐙᑯᒡ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᐅᑯᓰᓯᒫᐤ ᑭᔮᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ᑭᔮᐦ ᒑ ᒋᔅᑯᑎᒧᐙᑯᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐦᒡ ᒥᓯᐙ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑎᑯᒡ᙮ ᒨᔥ ᒫᒃ ᒋᑭ ᐐᒑᐅᑎᓈᐙᐤ ᐲᐦᐃᒻ ᐋᑎ ᐃᔅᒀᐱᔨᒑ ᐊᔅᒌ᙮”");
INSERT INTO crl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ᐋᑯᑦ ᐅᑎᐦ ᐧᐋᐦᒋ ᒋᐦᒋᐱᔨᒡ ᒥᐧᔮᒋᒧᐧᐃᓐ ᐋᐦ ᐋᔨᒨᒫᑭᓅᑦ ᒌᓴᔅ ᙭, ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ᒌ ᒥᓯᓂᐦᐋᒧᑖᑯᐱᓐ ᐊᓂᔮᐦ ᐋᐃᓵᔮᐦ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐅᒋᔅᒋᐧᐋᐦᐄᒑᓯᐤ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔨᑯᐱᓈᓂᐦᐄ ᒋᔖᒥᓂᑑᐦ, ᓃᔨ ᓂᑭ ᓃᑳᓐ ᐄᑎᔑᐦᐧᐋᐤ ᓂᑎᔨᒦᔥᑎᒫᒑᓰᒻ, ᒑ ᒌᐦ ᑐᑎᐧᐋᑦ ᐊᔅᒌᐦᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐃᔮᔅᑭᐧᐃᔅᑖᔅᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ᐊᓐ ᐊᐧᐋᓐ ᒑ ᐹᒋ ᓃᑳᓐ ᐄᑎᔑᐦᐅᒃ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑭᑎ ᐱᐹᐦᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, “ᐃᔮᔅᑭᐧᐄᐦᑭᐧᒫᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒫᔅᑭᓈᒻ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑖᑦ, ᑯᐃᔅᑯᒧᐦᑖᐧᐋᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ᐋᐅᒄ ᒫᒃ ᐆ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ᙮ ᐊᓂᑖᐦ ᒫᒃ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒌ ᐱᐹᐄᐦᑖᐤ ᐋ ᓰᑭᐦᐋᐦᑎᐧᐋᑦ ᐊᐧᐋᔨᐤᐦ ᑭᔮᐦ ᐋ ᑭᒑᔅᒋᒫᑦ᙮ ᒌ ᑭᒑᔅᒋᒫᐤ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᐧᑳᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᒫᑭᓂᐧᐃᔨᒡ, ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒑ ᐧᐋᐹᔨᐦᑎᒫᑯᔨᒡ ᐅᒥᒋᐦᐧᑖᐧᐃᓂᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᑳᐦ ᑖᔨᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑭᔮᐦ ᒉᕉᓯᓕᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐧᐃᓂᔨᐤ ᒌ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑰ᙮ ᒧᔖ ᒌ ᐧᐄᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒧᐧᐋᑯᐱᓈ, ᐋᒄ ᒫᒃ ᑳ ᓰᑭᐦᐋᐦᑖᑯᒡ ᒞᓐ ᐊᓂᑖᐦ ᐧᒑᕐᑎᓐ ᓰᐲᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ᑳᒥᓪ ᐅᐲᐧᐋᔨᐤ ᒌ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐧᐃᔨᐤ ᒞᓐ ᐅᒑᐧᑳᓂᒻ, ᑭᔮᐦ ᐲᔖᑭᓈᔮᐲᐦᒡ ᒌ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒑᐧᑳᔨᐤ ᑳ ᐆ ᐱᐦᑯᐦᑖᐦᐅᓂᑦ, ᑭᔮᐦ ᐧᑳᔥᐧᑳᔥᑯᐦᒋᔒᔥ ᑭᔮᐦ ᐋᒧᔔᑳᔨᐤ ᐋᔪᐧᐃᒄ ᑳ ᐅᒦᒋᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ᐋᔪᐧᐃᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑭᒑᔅᒋᒫᑦ ᐊᐧᐋᔨᐤᐦ, “ᑭᑎ ᑎᑯᔑᓐ ᐊᐧᐋᓐ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥᐧᐄ ᓃᔨ, ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᓃᔨ ᒑ ᒌ ᓂᐧᐋᐱᔨᐦᐅᔮᓐ ᒑ ᒌ ᐋᐱᐦᑯᓂᒧᒡ ᐅᒥᔅᒋᓂᔮᐲ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ᓂᐲ ᓂᑖᐱᒋᐦᑖᓐ ᐋ ᓰᑭᐦᐋᐦᑖᑎᑯᒡ, ᐧᐄᔨ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒋᑭ ᓰᑭᐦᐋᐦᑖᑯᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ᒌᓴᔅ ᒫᒃ ᒌ ᑎᑯᔑᓐ ᐧᒑᕐᑎᓐ ᓰᐲᐦᒡ ᐊᓂᑖᐦ ᐋ ᐅᐦᑐᐦᑖᑦ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ᒌ ᓰᑭᐦᐋᐦᑖᑰ ᒫᒃ ᒞᓐ ᐊᓂᑖᐦ ᐧᒑᕐᑎᓐ ᓰᐲᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ᐄᔥᐱᐦ ᒫᒃ ᑳᐹᑦ ᒌᓴᔅ ᑏᐧᐋᐦᒡ ᒌ ᐧᐋᐱᐦᑎᒻ ᒋᐦᒋᒌᔑᑯᔨᐤ ᐋ ᐅᐦᒋ ᐋᐱᐦᐄᐱᔨᐦᒡ ᑭᔮᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐋ ᐹᒋ ᔮᔒᔥᑖᑯᑦ ᒧᔮᒻ ᐱᔮᔑᔥ ᐅᒦᒦᒡ ᐋ ᐃᓯᓈᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ᒋᐦᒋᒌᔑᑯᐦᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᐹᐦᑖᑯᓯᐤ ᐊᐧᐋᓐ ᐋᐦ ᐃᔨᑦ, “ᐋᐅᒄ ᒌᔨ ᓂᑯᔅ ᓈᔥᒡ ᑳ ᓵᒋᐦᐄᑖᓐ᙮ ᓈᔥᑖᑆᐦ ᒋᓂᐦᐋᔨᐦᑎᒥᐦᐄᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ᑏᐧᐋᐦᒡ ᒫᒃ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒌ ᐄᑎᔓᐦᐅᑰ ᒌᓴᔅ ᑳ ᐱᔮᐦᒋᓰᔨᐦᒡ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᐋ ᑯᐧᑳᒋᐦᐄᑯᑦ ᒥᒋᒥᓂᑑᐦ᙮ ᒌᐦ ᑖᔨᐤ ᐋ ᑯᔥᑖᑎᑯᓰᔨᒡ ᐊᐅᐦᑳᓐᐦ ᐊᓂᑖᐦ᙮ ᒥᒄ ᒫᒃ, ᐋᓐᒋᓐ ᒌ ᐹᒋ ᓂᓈᑭᒋᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ᐹᑎᒫ ᒫᒃ ᒫᐧᑳᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᑳᐦ ᑖᑦ ᒌᓴᔅ ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᑭᒑᔅᐧᑳᑦ ᐋ ᐧᐋᐧᐄᐦᑎᐦᒃ ᒋᔖᒥᓂᑑᐦ ᐅᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ᒌ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᐤ, “ᔖᔥ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᐋ ᐹᔓᓈᑯᓃᔨᒡ ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ᙮ ᐧᑳᔅᑳᑎᓰᒄ, ᑭᔮᐦ ᑖᑆᐦᑎᒧᒄ ᒥᐧᔮᒋᒧᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᑦ ᒫᒃ ᒌᓴᔅ ᐊᓂᑖᐦ ᔑᔓᒡ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᐦᒡ ᒌ ᐧᐋᐱᒫᐤ ᓅᑎᒫᓵᓯᐤᐦ ᓵᐃᒥᓐᐦ ᑭᔮᐦ ᐧᐄᒋᐄᔨᔨᐤᐦ ᐋᓐᑎᕉᐦ᙮ ᒫᐧᑳᒡ ᒌ ᓅᑎᒫᓵᔨᐤ ᐃᐦᐄᐲ ᐋᐦ ᐋᐱᒋᐦᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᔮᐦ ᓈᐹᐤᐦ, “ᐋᔥᑎᒧᒄ, ᐹᒋ ᓅᔔᔥᑯᒄ᙮ ᒋᑭ ᑐᑖᑎᓈᐧᐋᐤ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐱᑎᐦᐆᔮᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ᑏᐧᐋᐦᒡ ᒫᒃ ᒌ ᓂᑭᑖᐅᒡ ᐅᑎᐦᐄᐲᐧᐋᐤᐦ, ᐋᒄ ᑳᐦ ᐋᑎ ᐧᐄᒑᐧᐋᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌᓴᔅ ᒌ ᐧᐋᐱᒫᐤ ᒉᒥᔅ ᑭᔮᐦ ᐧᐄᒋᐄᔨᔨᐤᐦ ᒞᓐᐦ, ᐊᓂᔮᔨᐤ ᓭᐱᑏᐦ ᐅᑯᓯᓯᔨᐤᐦ, ᒫᐧᑳᒡ ᐅᒌᒫᓂᔒᔨᒡ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐧᐋᑖᔅᐱᑖᔨᒡ ᐅᑎᐦᐄᐲᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ᑏᐧᐋᐦᒡ ᒌ ᓂᑑᒫᐤ ᐧᐃᔮᐱᒫᑦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᐅᒌᒫᓂᔑᐧᐋᒡ ᑳ ᐅᐦᒋᔅᑭᑖᒡ ᐅᐦᑖᐧᐄᐧᐋᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓂᐧᐋᐤᐦ, ᐋᒄ ᑳ ᐱᐹᐧᐄᒑᐧᐋᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ ᒌᓴᔅ ᒌ ᐲᐦᒑᐤ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋᒄ ᑳ ᒋᔅᑯᑎᒫᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ᐊᓂᒌ ᒫᒃ ᐊᓂᑎᐦ ᑳᐦ ᑎᒡ ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᐧᐋᐅᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ, ᐧᐋᔥ ᒧᔮᒻ ᐊᐧᐋᓐ ᓈᔥᒡ ᐋ ᐅᒋᒫᐧᐋᔨᐦᑖᑯᓯᑦ ᒌ ᐄᑎᐦᑖᑯᓲ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐄᑎᐦᑖᑯᓯᔨᐤ ᐧᐄᔨ ᐊᓂᔮᔨᐤᐦ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ᔑᔥᒋᑯᒡ ᒫᒃ ᐊᓂᑎᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᓈᐹᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᒋᔥᑳᑯᑦ ᒌ ᐅᐦᒋ ᑖᑆᐤ, ");
INSERT INTO crl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ᐋᐦ ᐃᔨᑦ, “ᐊᑳᐧᐄ ᐧᐃᔮᔥ ᐹᒋ ᑐᑎᐧᐃᓈᓐ, ᒌᔨ ᒌᓴᔅ ᓈᓵᕆᑦ ᑳ ᐅᐦᒋᔨᓐ᙮ ᒋᒌ ᐹᒋ ᑎᑯᔑᓐ ᐋ ᒑ ᒌ ᐃᔮᔪᐦᐄᔮᐦᒡ? ᒌ ᒋᔅᒑᔨᒥᑎᓐ ᐊᐧᐋᓐ ᒌᔨ, ᐋᐅᒄ ᒌᔨ ᑳ ᐱᔮᐦᒋᓰᓐ, ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐧᐋᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑐᑖᐤ ᐋᐦ ᐄᑖᑦ, “ᐋᑳ ᒋᔅᑐᐦ᙮ ᒫᒌᐦ ᐹᒋ ᐧᐃᔨᐧᐄᐦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓐ ᓈᐹᐤ ᐋᐦ ᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ᐊᓐ ᒫᒃ ᒥᒋᐊᐦᒑᐦᒄ ᒌ ᑐᑎᐧᐋᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᒑ ᒌ ᒥᔥᑎᐦ ᐅᒋᐱᑎᑯᔨᒡ ᒥᓯᐧᐋ ᐋᔅᑎᑎᔨᒡ ᐅᔮᔨᐦᒡ ᑭᔮᐦ ᑳ ᓂᑭᑖᑦ ᓲᐦᒃ ᐋᐦᒋ ᐋᔑᐦᐧᑳᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ᒥᓯᐧᐋ ᒫᒃ ᐊᐧᐋᓐ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑰ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑎᑐᒡ, “ᒑᐧᑳᓐ ᒫᒃ ᒦᓐ ᐆ? ᐅᔅᒋ ᒋᔅᑯᑎᒫᒑᐧᐃᓐ ᐋ? ᐋ ᐃᔮᑦ ᐆ ᓈᐹᐤ ᑎᐹᔨᐦᒋᒑᐧᐃᓂᔨᐤ ᐧᐋᐧᐋᒡ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐱᔑᒋᐦᐄᑯᑦ ᐋ ᐧᐃᔨᔓᒫᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᒥᔑᐦᑖᐱᔨᔨᒡ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓅᑦ ᒌᓴᔅ ᒥᓯᐧᐋ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᐄᑖᐦᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ᑏᐧᐋᐦᒡ ᒫᒃ ᒌᓴᔅ ᒌ ᐧᐃᔨᐧᐄᐤ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᓵᐃᒥᓐ ᑭᔮᐦ ᐋᓐᑎᕉᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᒌ ᐧᐄᒑᐅᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᐧᑳᒡ ᓵᐃᒥᓐ ᐅᓯᑯᔅᐦ ᒌ ᐋᐦᑯᓯᔨᐤᐦ ᐋ ᒌ ᒋᔑᑖᐅᐱᔨᔨᒡ᙮ ᑏᐧᐋᐦᒡ ᒫᒃ ᒌ ᐧᐄᐦᑎᒧᐧᐋᑭᓂᐤ ᐅᔮᔨᐤ ᒌᓴᔅ ᐄᔥᐱᐦ ᑖᑯᔑᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ᑳ ᓂᑎᐧᐋᐱᒫᑦ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤᐦ, ᑳ ᐅᑎᓂᐧᒫᑦ ᐅᑎᐦᒌᔨᐤ, ᐋᒄ ᑳ ᐧᐄᒋᐦᐋᑦ ᐋ ᐧᐃᓂᔥᑳᔨᒡ᙮ ᒌ ᓂᑭᑎᑰ ᒫᒃ ᐊᓐ ᐃᔅᐧᑳᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔑᑖᐅᐱᔨᑦ᙮ ᑳᐦ ᐱᓯᑯᑦ, ᐋᒄ ᑳᐦ ᐋᑎ ᐃᔮᐱᑎᓰᑦ ᐋ ᒥᒥᔪᑑᑎᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ᐊᓐ ᐧᐋᑖᑯᔑᒡ ᐄᔥᐱᐦ ᐹᐦᒋᔑᒧᑦ ᐲᓯᒻ, ᒌ ᐹᑐᐧᐋᑭᓂᐤ ᒌᓴᔅ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᐧᐋᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ᒥᓯᐧᐋ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐧᐃᓂᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᐹᒋ ᒫᐅᓯᑯᐧᐃᒡ ᐊᓂᑎᐦ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ᒥᐦᒑᑐ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᒌ ᒦᓂᐧᐋᒋᐦᐋᐤ ᒌᓴᔅ, ᒥᓯᐧᐋ ᓂᓈᐦᑭᐤ ᑳ ᐄᑖᔅᐱᓈᔨᒡᐦ ᑭᔮᐦ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᐤ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᐅᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐊᔨᒥᔨᒡ, ᐧᐋᔥ ᒌ ᒋᔅᒑᔨᒥᑰ ᐊᐧᐋᓐ ᐧᐄᔨ ᐄᔮᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ᐧᐄᐱᒡ ᒫᒃ ᒋᔮᒋᔖᐹᔮᔨᒡ ᐋᔥᒄ ᐋᐦᒋ ᑎᐱᔅᑳᔨᒡ ᒌ ᐧᐃᓂᔥᑳᐤ, ᐋᒄ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᑖᓂᐧᐃᔨᒡ ᑳ ᐄᑐᐦᑖᑦ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ᓵᐃᒥᓐ ᑭᔮᐦ ᐅᐧᐄᒑᐧᐋᑭᓐᐦ ᒌ ᓈᓂᑐᐧᐋᐱᒫᐅᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒥᔅᑭᐧᐋᒡ ᒌ ᐄᑖᐅᒡ, “ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᒌ ᓈᓂᑐᐧᐋᔨᒧᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ᒌ ᐄᑎᑯᒡ ᒫᒃ, “ᑯᑎᒃ ᑭᔮᐦ ᐃᐦᑖᐧᐃᓐ ᐲᐦᒑᑖᐤ ᒑ ᒌ ᑭᒑᔅᐧᑳᔮᓐ ᑭᔮᐦ ᐊᓂᑖᐦ, ᐧᐋᔥ ᐋᐅᒄ ᐧᐋᐦᒋ ᐹᒋ ᑎᑯᔑᓂᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ᐋᒄ ᒫᒃ ᒥᓯᐧᐋ ᑳ ᐱᐹᐄᑐᐦᑖᑦ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᐊᔅᒌᔨᐤ ᐋ ᑭᒑᔅᐧᑳᑦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᐤ ᒥᒋᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ᒌ ᐹᒋ ᓈᑎᑰ ᒌᓴᔅ ᓈᐹᐤᐦ ᐋ ᒫᔮᑎᓃᔨᒡ ᐅᒥᒌᐧᐋᔅᐱᓈᐧᐃᓂᔨᐤ ᐋ ᐃᔮᔨᒡ᙮ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ, ᐋᒄ ᑳ ᓂᑐᑎᒫᑯᑦ ᒑ ᒌ ᒦᓂᐧᐋᒋᐦᐋᑦ᙮ ᒌ ᐄᑎᑰ ᒫᒃ, “ᐧᐄᐦ ᑐᑎᒥᓈ, ᒋᑭ ᒌ ᐱᔮᐦᒋᐦᐄᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ᒌᓴᔅ ᒫᒃ ᓈᔥᒡ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᐋᒄ ᑳ ᔑᑐᐱᔨᐦᑖᑦ ᐅᔅᐱᑐᓐ ᑳ ᑖᐦᒋᓈᑦ ᐋᐦ ᐄᑖᑦ, “ᒋᐧᐄᐦ ᐧᐄᒋᐦᐄᑎᓐ, ᐱᔮᐦᒋᓰᐦ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ᑏᐧᐋᐦᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᒥᔪᓈᑯᓲ ᐊᓐ ᓈᐹᐤ ᐋ ᒌ ᒦᓂᐧᐋᒋᐦᐋᑭᓅᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᓲᐦᒃ ᐋ ᐋᐃᐦᑭᒥᒫᑦ, ");
INSERT INTO crl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“ᓂᑑᑎ ᒫᐦ ᒑ ᐄᑎᑖᓐ, ᐊᑳᐧᐄ ᐊᐧᐋᓐ ᒋᑭ ᐅᐦᒋ ᐧᐄᐦᑎᒧᐧᐋᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᓐ᙮ ᑏᐧᐋᐦᒡ ᓂᑎᐧᐋᐱᒻ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒥᑐᓐ ᒑ ᓂᑑᒋᔅᒑᔨᒥᔅᒃ᙮ ᐋᒄ ᒑ ᐱᒋᔅᑎᓂᒥᓐ ᐊᓐ ᒑ ᐱᒋᔅᑎᓂᒧᐱᓈ ᐊᓂᔮᔨᐤ ᒧᓱᔅ ᑳᐦ ᐄᑎᔓᐧᐋᑦ ᒑ ᐱᒋᔅᑎᓂᒑᓂᐧᐃᔨᒡ᙮ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᐧᐋᐱᐦᑎᔨᐧᐋᔨᓐ ᑖᑆᐦ ᐋᒄ ᐋ ᐱᔮᐦᒋᓯᔨᓐ᙮” ᐋᒄ ᑳ ᒋᐦᒋᑎᔑᐦᐧᐋᑦ ᐅᔮᔨᐤᐦ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ᑳ ᒋᔅᑐᐦᑖᑦ ᐆ ᓈᐹᐤᐦ᙮ ᒥᒄ ᒫᒃ, ᐊᔮᐱᒡ ᒌ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᐤ ᒥᓯᐧᐋ ᐊᐧᐋᔨᐤᐦ᙮ ᐅᔮᔨᐤ ᒫᒃ ᐋ ᒌᐦ ᑎᒃ ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᐅᐦᒌ ᐲᐦᒑᔨᐤ ᒌᓴᔅ ᐃᐦᑖᐧᐃᓂᐦᒡ ᐋᐦᐋᑳ ᒨᔑᐦᐄᒫᑭᓂᐧᐃᔨᒡ᙮ ᐋᒄ ᐊᓂᑖᐦ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐋᑯᑖᐦ ᒥᒄ ᑳᐦ ᑖᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᑖᓂᐧᐃᔨᒡ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒌ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑰ ᐊᐧᐋᔨᐤᐦ ᓂᓈᐦᑭᐤ ᐋ ᐅᐦᑐᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ᓂᒧᐃ ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᐅᐦᒋ ᒥᔮᐅᐱᔨᐤ ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳ ᑎᑯᔑᐦᒃ ᐊᓂᑎ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒨᔑᐦᐋᑭᓅᑦ ᒦᓐ ᐋ ᒌ ᐹᒋ ᒌᐧᐋᑦ ᐋᒄ ᑳ ᒥᔑᐦᑖᔮᒋᒧᓈᓂᐧᐃᔨᒡ ᒦᓐ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ᓄᐧᐃᒡ ᒫᒃ ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᒌ ᐹᒋ ᑎᑯᔑᓂᔨᐤ, ᒑᒃ ᓂᒧᐃ ᐅᐦᒋ ᑖᐱᔅᑳᑐᔫᐦ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ, ᐧᐋᐧᐋᒡ ᐊᓂᑖᐦ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐃᔥᐧᑳᐦᑖᒥᐦᒡ ᒑ ᒌ ᑎᐧᐋᔨᒡ᙮ ᒌ ᑭᒑᔅᒋᒫᐤ ᒫᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᑳ ᑎᑯᔑᓃᔨᒡ, ᒋᔖᒥᓂᑑᐦ ᐅᑎᔨᒧᐧᐃᓂᔨᐤᐦ ᐋᐦ ᐋᔨᒨᑎᒧᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ᐅᔮᔨᐤ ᒫᒃ ᒫᐧᑳᒡ, ᓈᐤ ᓈᐹᐅᒡ ᒌ ᐹᔓᐧᐋᐅᒡ ᐧᐄᑖᐹᐧᐋᐤ ᐋᐦᐋᑳ ᓈᔥᑎᔨᔥ ᒌ ᐋᐦᑎᓃᓲᔨᒡ ᐅᑎᔥᐱᔑᒧᐧᐃᓃᔨᒡ ᐋ ᐱᒥᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᒡ ᓂᒧᐃ ᐹᔓᒡ ᐅᐦᒌ ᓈᑖᐅᒡ ᒌᓴᔅᐦ᙮ ᐋᒄ ᑳ ᐱᑯᓈᐱᑎᐦᒡ ᐊᓂᑖᐦ ᑎᐦᑯᐦᒡ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᓂᐦᐋᐤ ᑎᐱᔅᑯᒡ ᐊᓂᑎᐦ ᐋ ᒌ ᓃᐴᐧᐃᔨᒡ ᒌᓴᔅᐦ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᔮᔖᐱᐦᒑᓈᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐊᔥᐱᔑᒧᓂᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ᒌᓴᔅ ᒫᒃ ᒌ ᐧᐋᐱᐦᑎᐧᒫᐤ ᐅᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋ ᐃᔥᐱᔥ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᑳ ᓈᔥᑎᔨᔥ ᒌ ᐋᐦᑎᓃᓲᔨᒡ, “ᓂᑯᔅ, ᒋᐧᐋᐹᔨᐦᑎᒫᑭᐧᐃᓐ ᒋᒥᒋᐦᐧᑖᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ, ᐅᔮᔨᐤ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐅᔮᔨᐤ ᐄᔑ ᐊᔨᒥᑦ ᐆ ᓈᐹᐤ? ᒫᔮᔨᐦᒑᐤ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ᒫᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ᙮ ᓂᒧᐃ ᐧᐄᔨ ᓈᐹᐤ ᑭᑎ ᒌ ᐧᐋᐹᔨᐦᑎᒫᒑᐤ ᒥᒋᐦᐧᑖᐧᐃᓐ, ᒥᒄ ᒋᔖᒥᓂᑑ ᑭᑎ ᒌ ᐧᐋᐹᔨᐦᑎᒫᒑᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ᒌᓴᔅ ᒫᒃ ᑏᐧᐋᐦᒡ ᒌ ᒨᔑᐦᐆ ᐅᑎᐦᒑᐦᑯᐦᒡ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒥᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐊᓐ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒫᒄ? ");
INSERT INTO crl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ᑖᓐ ᐊᑎᑎᐤ ᐧᐃᔮᐦᑎᐦᒡ ᒑ ᒌ ᐄᑖᑭᓅᑦ ᐆ ᓈᐹᐤ ᐋᑳ ᓈᔥᑎᔨᔥ ᒌ ᐋᐦᑎᓂᓲᑦ, ‘ᒋᐧᐋᐹᔨᐦᑎᒫᑭᐧᐃᓐ ᒋᒥᒋᐦᐧᑖᐧᐃᓐ,’ ᑭᔮᐦ ᒫᒃ ᐄᑖᑭᓅᑦ ‘ᐧᐃᓂᔥᑳᐦ, ᐅᑎᓐᐦ ᒋᑎᔥᐱᔑᒧᓐᐦ ᑭᔮᐦ ᐱᒧᐦᑖᐦ?’ ");
INSERT INTO crl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ᒋᑭ ᐧᐋᐱᐦᑏᑎᓈᐧᐋᐤ ᒑᐧᑳᓐ ᒑ ᒋᒋᔅᒑᔨᐦᑎᒫᒄ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑖᑆᐦ ᐧᐄᔨ ᐋ ᐃᔮᑦ ᑎᐹᔨᐦᒋᒑᐧᐃᓂᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐧᐋᐹᔨᐦᑎᒫᒑᑦ ᒥᒋᐦᐧᑖᐧᐃᓐ᙮” ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᑳ ᑳ ᓈᔥᑎᔨᔥ ᒌ ᐋᐦᑎᓃᓲᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ᒋᐧᐄᐦᑎᒫᑎᓐ, ᐱᓯᑰᐦ, ᐅᑎᓐᐦ ᒋᑎᔥᐱᔑᒧᓐᐦ, ᒑ ᒌᐧᐋᔨᓐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ᑏᐧᐋᐦᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᐱᔑᑰ ᐊᓐ ᓈᐹᐤᐦ ᑖᐧᐋᔨᔥ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᒡ, ᑳᐦ ᐋᑎ ᐅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑎᔥᐱᔑᒧᓐ, ᐋᒄ ᑳ ᒫᒌᑦ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ ᑭᔮᐦ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑᐦ ᐋᐦ ᐃᔨᒡ, “ᓂᒧᐃ ᓂᐦᑖ ᓅᐦᒋ ᐧᐋᐱᐦᑖᓈᓐ ᐆ ᐋᐦ ᐄᔅᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ᒌᓴᔅ ᒫᒃ ᑳᐤ ᒌ ᓈᔑᐹᐤ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ᙮ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑳ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑯᑦ, ᐋᒄ ᑳ ᒋᔅᑯᑎᒧᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᑦ ᒌ ᐅᑎᐦᑖᐤ ᓈᐹᐤᐦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐧᐃᔮᓐ ᑳ ᒫᒨᔑᒋᓈᔨᒡ ᐋᐦ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᓖᕙᐃᐦ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ᙮ ᐊᓪᕕᔨᔅᐦ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᐦᑖᐧᐄᔨᐤᐦ᙮ ᒫᐧᑳᒡ ᐊᓂᑖᐦ ᐅᒥᓯᓂᐦᐄᒑᐅᑭᒥᑯᐦᒡ ᒌ ᐊᐱᐤ ᐆ ᓖᕙᐃᐦ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ, “ᐹᒋ ᓅᔔᔥᑯᐦ᙮” ᒌ ᐱᔑᑰ ᒫᒃ ᓖᕙᐃ ᑳᐦ ᐋᑎ ᐧᐄᒑᐧᐋᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ᐹᑎᒫ ᒫᒃ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐋ ᒌ ᐹᒋ ᐧᐄᒑᐅᑯᑦ ᒌ ᒦᒋᓯᐧᐃᒡ ᐊᓂᑖᐦ ᓖᕙᔨᐦ ᐧᐄᒋᔨᐦᒡ᙮ ᐋᑯᑖᐦ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤᐦ ᒋᐦᒋᐅᒋᒫᐤᐦ ᔓᐧᐃᔮᓐ ᐋ ᒫᒨᔑᒋᓈᔨᒡ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᒥᒑᑎᓰᔨᒡ, ᐧᐋᔥ ᒥᐦᒑᑐ ᒌ ᓅᔔᔥᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᔨᔅ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒌ ᐧᐋᐱᒫᐅᒡ ᒌᓴᔅ ᐋ ᐧᐄᒋᒦᒋᓲᒫᔨᒡ ᐊᓂᔮᔨᐤᐦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐧᐃᔮᓐ ᐋ ᒫᒨᔑᒋᓈᔨᒡ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᑭᔮᐦ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᒥᒑᑎᓰᔨᒡ᙮ ᒌ ᑯᐧᑳᒋᒥᒫᐅᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᔨᐤᐦ, ᐋᐦ ᐄᑖᒡ, “ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐧᐄᒋᒦᒋᓲᒫᑦ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ᒌᓴᔅ ᒫᒃ ᒌ ᐹᐦᑎᐧᐋᐤ ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᑎᐧᐋᔨᒫᐅᒡ ᓂᑐᐦᑯᔨᓐ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳᐦ ᐋᐦᑯᓯᒡ, ᒥᒄ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᐋᐅᑯᓂᒡ ᓈᑐᐧᐋᔨᒫᒡ ᓂᑐᐦᑯᔨᓐ᙮ ᓂᒥᔮᐅᒡ ᐊᓂᒌ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐧᐋᐦᒋ ᑎᑯᔑᓂᔮᓐ᙮ ᓂᒌᑎᑯᔑᓐ ᒑ ᒌ ᓂᑐᒥᐧᑳᐤ ᐅᒥᒋᐧᑖᐧᐃᒡ ᒑ ᒌ ᐧᑳᔅᑳᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ᐹᔨᐧᑳᐤ ᒫᐧᑳᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᐧᐋᐤᐦ ᐋᐦᐋᑳ ᒦᒋᓱᒡ, ᒌᐦ ᑖᔨᐤ ᐊᐧᐋᔨᐤᐦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑯᐧᑳᒋᒥᑯᑦ ᒌᓴᔅ, “ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐋᑳ ᒦᒋᓱᔨᒡ ᒞᓐ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᑭᔮᐦ ᐊᓂᒌ ᐊᔨᒥᐦᐋᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᐧᐋᐤᐦ, ᒌᔨ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᓂᒧᐃ ᑑᐧᐃᒡ ᐧᐄᔨᐧᐋᐤ ᐋᐦᐋᑳ ᒦᒋᓱᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ᒌᓴᔅ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒧᔮᒻ ᐊᓂᑖᐦ ᒫᐧᑳᒡ ᐋ ᒋᐦᒋᐧᐄᒋᑐᓈᓂᐧᐃᒡ ᒋᑭ ᒌᐦ ᑐᐧᐃᒡ ᒑᐦ ᐋᑳ ᒌ ᒦᒋᓱᒡ ᐊᓂᒌ ᑳ ᓂᑐᒫᑭᓂᐧᐃᒡ ᐋ ᒥᑯᔖᓂᐧᐃᔨᒡ? ᓂᒧᐃ ᓈᓂᑐ᙮ ᐋᔥᒄ ᒫᐧᑳᒡ ᐋᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦᑖᐦᒡ ᐊᓂᔮᔨᐤᐦ ᐅᔅᒋᓈᐹᐧᐋᓐ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒧᒡ ᒑ ᐋᑳ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ᐹᑎᒫ ᑭᑎ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᒑ ᐹᒋ ᐅᑎᓈᑭᓅᑦ ᐊᓐ ᐅᔅᒋᓈᐹᐧᐋᓐ, ᐋᑯᑖᐦ ᒫᒃ ᐃᔮᒄ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᒡ ᓂᒥ ᑭᑎ ᒦᒋᓱᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ᓂᒧᐃ ᐊᐧᐋᓐ ᐋᐱᒋᐦᑖᐤ ᐱᒋᐧᐃᔮᓈᒋᓂᔨᐤ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᒋᐱᔨᔨᒡ ᐋ ᐧᐄᐦ ᒦᔑᐦᐋᐦᒃ ᐊᑯᐦᐱᔅᒌᔑᔨᐤ᙮ ᐧᐋᔥ ᐅᔮᔨᐤ ᒦᔑᐦᐄᑳᒑᒑ ᐅᒋᐱᔨᔨᒑ ᒫᒃ ᐊᑎᑎᐤ ᑭᑎ ᐋᐧᑳᒋᐱᔨᐤ ᐊᓐ ᐊᑯᐦᑉ ᐊᓂᑎᐦ ᐋ ᒌ ᐲᑯᐱᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐊᐧᐋᓐ ᐲᐦᑖᐹᐅᑖᐤ ᐋ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ ᐊᓂᑖᐦ ᐧᐋᔥᑭᒡ ᔖᔥ ᐋ ᒌ ᐋᐱᑎᓃᔨᒡ ᔔᒥᓈᐴᔨᐤ ᐲᓵᑭᓐ ᐧᐄᐦᐧᑳᔮᔨᐤ᙮ ᐧᐋᔥ ᐅᔮᔨᐤ ᑐᑎᐦᒑ ᒥᑐᓐ ᑭᑎ ᐹᐦᑳᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐧᐄᐦᐧᑳᔮᔨᐤ, ᐋᒄ ᒫᒃ ᒥᓯᐧᐋ ᒑ ᐃᔮᔪᓃᔨᒡ ᐊᓂᔮᔨᐤ ᔔᒥᓈᐴᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐧᐄᐦᑯᔮᐤ᙮ ᓂᒧᐃ ᒫᒃ ᒦᓐ ᑭᑎ ᒌ ᐋᐱᑎᓐ᙮ ᓂᒧᐃ ᐊᐧᐋᓐ ᐅᔮᔨᐤ ᑐᑎᒻ, ᐧᐋᔥ ᐋ ᐅᔥᑳᑭᒦᐦᒡ ᔔᒥᓈᐳᐃ ᐊᓂᑖᐦ ᐋ ᐅᔥᑳᒡ ᐲᓵᑭᓐ ᐧᐄᐦᐧᑳᔮᐦᒡ ᐲᐦᒋᑭᐅᑖᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ᐹᔨᐧᑳᐤ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ ᒌᓴᔅ ᒌ ᐱᒧᐦᑖᐤ ᐊᓂᑖᐦ ᐱᐦᐧᑳᔑᑭᓂᒥᓈᐦᑎᒄ ᐋ ᓂᐦᑖᐅᒋᐦᑖᑭᓂᐧᐃᔨᒡ᙮ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᐧᐄᒑᐅᑰ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᔨᒡ ᒌ ᓂᓈᐧᑖᓂᒥᔨᐤ ᐊᓂᑎᐦ ᐋ ᐧᐃᓂᔥᐧᑳᔅᑯᓃᔨᒡ ᐅᔮᔨᐤ ᐱᐦᐧᑳᔑᑭᓂᒥᓐ ᐋ ᒦᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ᐋᒄ ᐹᕆᓰᒡ ᐋᑖᒡ ᒌᓴᔅᐦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᑐᑎᐦᒡ ᐊᓐ ᒑᐧᑳᔨᐤ ᐋᑳ ᒑ ᑐᑎᒧᐧᐋᐧᐋᑯᐱᓈ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ᒌᓴᔅ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᒌ ᐊᔨᒥᐦᑖᓈᐧᐋᒑ ᒌᐦᒋ ᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑎᐦ ᑖᐹᒋᒫᑭᓅᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ, ᑭᔮᐦ ᒫᒃ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤᐦ ᑳ ᐧᐄᒑᐅᑯᑦ ᑖᓐ ᑳᐦ ᑎᒡ ᐄᔥᐱᐦ ᑳ ᐧᐄᐦ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ᒌ ᐲᐦᒑᐤ ᒋᔖᒥᓂᑑ ᐅᐧᐋᔅᑳᐦᐄᑭᓂᒥᔨᒡ, ᐋᒄ ᑌᕕᑦ ᑳᐦ ᒧᐧᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐋᔨᐦᑯᓈᐤ, ᐋᒄ ᑳ ᐊᔑᒫᑦ ᐊᓂᔮᔨᐤ ᐅᐧᐄᒑᐧᐋᑭᓐᐦ᙮ ᒫᐧᑳᒡ ᐋᐱᔮᕦᕐ ᒌ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐧᐄᒑ ᐅᔮᔨᐤ᙮ ᒥᒄ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᐄᑖᔨᐦᑖᑯᓯᐧᐃᒡ ᒑ ᒌ ᒧᐧᐋᒡ ᐅᔮᔨᐤ ᐋᔨᐦᑯᓈᐤ, ᐧᐋᔥ ᐋᔪᐧᐃᒄ ᐋᑎᔥᑖᒡ ᐊᔨᒥᐦᐋᐤ ᐧᐄᔓᐧᐋᐅᓯᓂᐦᐄᑭᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ᐋᒄ ᑳᐦ ᐋᑎ ᐄᑖᑦ ᒌᓴᔅ, “ᒋᔖᒥᓂᑑ ᒌ ᐅᔑᐦᑖᐤ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ ᒑ ᐧᐄᒋᐦᐄᑯᔨᒡ ᓈᐹᐤᐦ, ᓂᒧᐃ ᐅᐦᒋ ᐅᔑᐦᐋᐤ ᓈᐹᐤ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᒑ ᒌ ᓂᓈᑭᑐᐧᐋᔨᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ᐄᔨᔨᐅᑯᓯᓵᓐ ᒫᒃ, ᐧᐋᐧᐋᒡ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ ᑎᐹᔨᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ᐹᔨᐧᑳᐤ ᒦᓐ ᒌᓴᔅ ᐋ ᐲᐦᒑᑦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ ᓈᐹᐤ ᐋ ᒫᔅᑭᓃᔨᒡ ᐅᑎᐦᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ᒌᐦ ᑖᔨᐤ ᑭᔮᐦ ᐊᓂᑎᐦ ᐊᐧᐋᔨᐤᐦ ᐋ ᐧᐄᐦ ᓈᓂᑐ ᒫᒥᔑᒥᑯᑦ ᒌᓴᔅ, ᐋᒄ ᓈᔥᒡ ᑳ ᓈᓈᑭᒋᐦᐄᑯᑦ ᑖᑆᐦ ᒑ ᒦᓂᐧᐋᒋᐦᐄᐧᐋᐧᑳ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒫᔅᑭᓃᔨᒡ ᐅᑎᐦᒌᔨᐤ, “ᐋᔥᑎᒻ ᐅᑖᐦ ᓃᑳᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ᐋᒄ ᒌᓴᔅ ᑳ ᑯᐧᑳᒋᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᑖᓐ ᐋᑎᔥᑖᒡ ᐧᐄᔨᔓᐧᐋᐧᐃᓂᐦᒡ ᒑ ᒌᐦ ᑐᑎᒧᑯᐱᓈ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ? ᐋ ᒥᔪᑐᑖᑭᓂᐧᐃᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᒋᐦᑑᑎᑭᓂᐧᐃᒡ, ᐋ ᐱᒫᒋᐦᑖᔨᓐ ᐱᒫᑎᓰᐧᐃᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᐃᔮᔪᐦᑖᔨᓐ?” ᐊᓂᒌ ᒫᒃ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᓂᒧᐃ ᐅᐦᒋ ᒋᔥᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ᒌᓴᔅ ᒌ ᒋᔓᑭᓂᐧᐋᐱᒫᐤ, ᐋᔨᐤᐦ ᒫᒃ ᒌ ᒥᓯᒥᑖᐦᐋᔅᑳᑰ ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᒥᔅᑰᑖᐦᐋᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᒫᔅᑭᓃᔨᒡ ᐅᑎᐦᒌᔨᐤ, “ᓰᑐᐱᔨᐦᑖᐦ ᒋᑎᐦᒌᐦ᙮” ᒌ ᓰᑐᐱᔨᐦᑖᐤ ᒫᒃ ᐊᓐ ᓈᐹᐤᐦ, ᐋᒄ ᒫᒃ ᑳ ᒦᓂᐧᐋᒋᐦᑖᑭᓂᐧᐃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ, ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑯᑎᒋᔨᐤ ᐅᑎᐦᒌ ᑳ ᐄᔑ ᒥᐧᔮᔨᒡ ᐋᔪᐧᐃᒄ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ ᑳ ᒫᔅᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᐋᑎ ᐧᐃᔨᐧᐄᐧᐃᒡ ᐊᓂᑎᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᐋᒄ ᑏᐧᐋᐦᒡ ᑳ ᓂᑎᐧᐋᐱᒫᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᐦᐁᕆᑦ ᑳ ᐧᐄᒋᐦᐋᔨᒡ, ᐋᒄ ᑳ ᓂᔥᑐᐧᐄᒡ᙮ ᒌ ᐋᔨᐧᒫᐦᐄᑯᒡ ᑖᓂᑖᐦ ᒋᐱᐦ ᒌ ᐅᐦᒋ ᓂᐱᐦᐋᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ᒌᓴᔅ ᒌ ᒋᔅᑐᐦᑖᐤ ᐋ ᐧᐄᒑᐅᑯᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᐋᒄ ᐊᓂᑖᐦ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᐦᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ᒥᐦᒑᑐ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᒌ ᓅᔔᔥᑳᑯᒡ᙮ ᓂᓈᐦᑭᐤ ᒌ ᐅᐦᑐᐦᑖᔨᐤ, ᑳᓕᓖᐦᒡ ᐊᔅᒌᐦᒡ ᒌ ᐅᐦᑐᐦᑖᔨᐤ ᑭᔮᐦ ᒎᑏᔮᐦᒡ ᐊᔅᒌᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ᑭᔮᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐃᐦᑖᐧᐃᓐ, ᐄᑑᒥᔮᐦᒡ ᐊᔅᒌᐦᒡ, ᑭᔮᐦ ᒫᒃ ᐊᑳᒥᐦᒡ ᐊᓂᔮᔨᐤ ᐧᒑᕐᑎᓐ ᓰᐲᔨᐤ ᒌ ᐅᐦᑐᐦᑖᔨᐤ᙮ ᐋᔨᐤᐦ ᒫᒃ ᑖᐊᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐧᐃᓐᐦ ᑭᔮᐦ ᐊᓂᑎᐦ ᐧᐋᔅᑳᐦ ᒌ ᐅᐦᑐᐦᑖᔨᐤ᙮ ᒌ ᐹᐦᑎᒧᑖᐧᐋᑯᐱᓐ ᐅᒌ ᐄᔨᔨᐅᒡ ᒥᓯᐧᐋ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᐧᐄᐦ ᐹᒋ ᓂᑑᐦᑎᐧᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒑ ᒌ ᐃᔮᔅᑭᐧᐃᔥᑖᔨᒡ ᒌᒫᓂᓯᔨᐤ ᒑᒃ ᓂᑎᐧᐋᔨᐦᑖᑯᓃᔨᒑ ᒑ ᒌ ᐴᓯᑦ ᐧᐋᔥ ᓰᐦᑎᔅᑳᑯᒑ ᐊᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ᐧᐋᔥ ᐊᓂᔮᔨᐤ ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᐋ ᒌ ᒦᓂᐧᐋᒋᐦᐋᑦ ᐋᒄ ᒥᐦᒑᑐ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑖᔅᐱᓈᔨᒡ ᑳ ᐹᒋ ᓰᐦᑎᔅᑳᑯᑦ ᐋ ᐧᐄᐦ ᑖᐦᒋᓂᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ᒥᒋᐊᐦᒑᐦᑯᒡ ᒫᒃ ᐄᔥᐱᔥ ᐧᐃᔮᐱᒫᒡ ᒌᓴᔅᐦ ᒌ ᑐᑎᐧᐋᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐲᐦᒋᔥᑯᐧᐋᒡ ᒑ ᒌ ᐱᐦᒋᔑᓃᔨᒡ ᐅᐦᑎᔅᑰ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ, ᐋᒄ ᑳ ᐅᐦᒋ ᑖᑆᒡ ᐊᓂᒌ ᒥᒋᐊᐦᒑᐦᑯᒡ ᐋᐦ ᐃᔨᒡ, “ᐋᐅᒄ ᒌᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ᒌᓴᔅ ᒫᒃ ᓲᐦᒃ ᒌ ᐊᔨᒥᐦᐋᐤ ᐋᐦ ᐄᑖᑦ ᐋᑳ ᒑ ᐧᐄᐦᑎᒧᐧᐋᔨᒡ ᐊᐧᐋᔨᐤᐦ ᐊᐧᐋᓐ ᐧᐄᔨ ᐃᔮᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ᐋᒄ ᒌᓴᔅ ᑳ ᔖᑭᒋᐧᐋᑦ ᐋ ᐱᔅᐧᑳᐱᔅᑳᔨᒡ᙮ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᐅᐧᐋᔮᐱᒫᑦ᙮ ᒌ ᓈᑎᑰ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ᐋᒄ ᓃᔓᔖᑉ ᐋᑆᔅᑎᓪᐦ ᑳ ᐅᐧᐋᔮᐱᒫᑦ ᒑ ᒌ ᐱᐹᐧᐄᒑᑯᑦ ᑭᔮᐦ ᒑ ᒌ ᒋᐦᒋᑎᔑᐦᐅᒫᑭᓂᐧᐃᔨᒡ ᒑ ᒌ ᑭᒑᔅᐧᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ᑭᔮᐦ ᒌ ᒥᔮᐤ ᑎᐹᔨᐦᒋᒑᐧᐃᓂᔨᐤ ᒑ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ᒫᐅᔨᐤᐦ ᑳ ᐅᐧᐋᔮᐱᒫᑦ, ᓵᐃᒥᓐ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᑖᑦ ᒌᓴᔅ, ");
INSERT INTO crl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ᐋᒄ ᒦᓐ ᒉᒥᔅ, ᓭᐱᑏ ᐅᑯᓯᔨᐤᐦ, ᑭᔮᐦ ᒞᓐ, ᒉᒥᔅ ᐧᐄᒋᔖᓂᔨᐤ᙮ ᐅᔮᔨᐤ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᑆᓈᕐᑭᔅ ᒌ ᐄᔑ ᓂᔅᐱᐧᐄᐦᐋᐤ ᒌᓴᔅ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐄᔑ ᓂᔅᐱᐧᐄᐦᐋᑦ ᓂᒥᔅᒋᐅᒡ ᐅᑯᓯᐧᐋᐤ ᐄᔑ ᐄᐧᑖᔥᑎᒫᑖᑭᓂᐧᐃᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ᐋᒄ ᒦᓐ ᐅᔮᔨᐤ ᑳ ᐅᐧᐋᔮᐱᒫᑦ, ᐋᓐᑎᕉᐦ, ᕕᓕᑉᐦ, ᐹᕐᐧᑖᓚᒥᔪᐦ, ᒫᕠᔫᐦ, ᐧᑖᒥᔅᐦ, ᐋᒄ ᒫᒃ ᒉᒥᔅᐦ᙮ ᐆ ᒫᒃ ᒉᒥᔅᐦ, ᐊᓪᕕᔨᔅ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᐦᑖᐧᐄᐦ᙮ ᑖᑌᔨᔅ ᒌ ᐃᔑᓂᐦᑳᓲ ᒦᓐ ᑯᑎᒃ ᑳ ᐅᐧᐋᔮᐱᒫᑭᓅᑦ, ᐋᒄ ᒦᓐ ᑯᑎᒃ ᓵᐃᒥᓐᐦ ᓈᔥᒡ ᑖᐱ ᑳ ᐊᔨᒥᐦᐋᐧᐋᑎᓰᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ");
INSERT INTO crl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ᐋᒄ ᒫᒃ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ ᐊᓐ ᒑ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒦᓐ ᑳ ᐅᐧᐋᔮᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ᑳ ᒌᐧᐋᑦ ᒌᓴᔅ᙮ ᐋᒄ ᒦᓐ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑳᐦ ᐹᒋ ᒫᐅᓯᑯᔨᒡ᙮ ᒑᒃ ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᐅᐦᒋ ᐄᔥᐱᔑᐧᐃᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒑ ᒌ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐹᔓᑖᐦᑯᒫᑦ ᐱᔮᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᒌ ᓂᑎᐧᐋᐱᒥᑰ ᒑ ᒌ ᒋᔅᑐᐦᑎᐦᐄᑯᑦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐧᐋᔥ ᒌ ᐄᑖᔨᒥᑰ ᐊᐧᐋᔨᐤᐦ ᐋᐦᐋᑳ ᑯᐃᔅᑯᑯᑖᔨᒡ ᐅᒥᑐᓈᔨᐦᒋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ᑭᔮᐦ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒫᐧᑳᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ᙮ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ᙮ ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᒥᒋᐊᐦᒑᐦᑯᒡ ᐅᒋᒫᒨᐧᐋᔨᐤ ᐹᔨᓪᓯᐳᓪ, ᐋᔨᐅᑯᓐ ᐹᐦᒋᔥᑳᑯᑦ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒫᔨᑯᑦ ᒥᑖᐅᐧᐃᓂᔨᐤ ᒑ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᑦ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ, ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᑎᐹᒋᒧᐧᐃᓐ ᒋᔅᑯᑎᒫᒑᐧᐃᓐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᑦ ᒥᒋᒥᓂᑑ ᒥᒋᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ᐧᐋᔥ ᒥᔔ ᐄᔨᔨᐅᒡ ᐹᔨᒄ ᐊᔅᒌᔨᐤ ᑳ ᐅᐦᒌᒡ ᒥᒋᐃᔑᑳᑐᐧᑖᐧᐋ, ᓂᒧᐃ ᒥᑐᓐ ᑭᑎ ᐅᐦᒋ ᒥᔪᐱᔫᒡ ᐊᓂᑎᐦ ᐅᑎᔅᒌᐧᐋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ᑭᔮᐦ ᒫᒃ ᐹᔨᑯᑖᓂᐤ ᐄᔨᔨᐅᒡ ᒥᒋᐃᔑᑳᑐᐧᑖᐧᐋ, ᓂᒧᐃ ᒥᑐᓐ ᑭᑎ ᐅᐦᒋ ᒥᔪᐱᔫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ᒥᒋᒥᓂᑑ ᒫᒃ ᒧᔮᒻ ᐋ ᒫᓯᐦᐄᓲᑦ ᐋ ᐃᓯᓈᑯᓯᑦ, ᒥᑐᓐ ᐋ ᐱᐱᐦᑳᓂᐦᐄᓱᑦ, ᓂᒧᐃ ᑭᑎ ᒌ ᐄᔑᑳᐳ᙮ ᑭᑎ ᐲᑯᐱᔨᔨᐤ ᐅᒋᒫᐅᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","ᓂᒧᐃ ᒥᒄ ᑭᑎ ᒌ ᐄᔑ ᐲᐦᒑᐧᐋᐤ ᐊᐧᐋᓐ ᐋ ᓲᐦᒋᓰᔨᒡ ᓈᐹᐤ ᐧᐄᒋᔨᐦᒡ ᒑ ᒌ ᓂᑑᑭᒑᒧᑎᒫᑦ, ᐹᑎᔥ ᒫᐦᑯᐱᑖᒑ, ᐋᒄ ᐃᔮᒄ ᒑ ᒌ ᐅᑎᓂᐧᒫᑦ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐧᐋᐅᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᑭᑎ ᐧᐋᐹᔨᐦᑎᒧᐧᐋᑭᓂᐧᐃᒡ ᐄᔨᔨᐅᒡ ᒥᓯᐧᐋ ᐅᒥᒋᐦᐧᑖᐧᐃᓂᐧᐋᐤ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐋᔨᒨᒫᒡ ᐊᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐧᐋᓐ ᒑ ᒫᔮᔨᒫᐧᑳ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐧᐋᐹᔨᐦᑎᒧᐧᐋᑭᓂᐤ᙮ ᑳᒋᒡ ᑭᑎ ᓂᔑᐧᐃᓈᒋᒫᑭᓂᐤ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᒥᒌᐦᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐧᐄᐦᑎᒧᐧᐋᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐊᔨᒥᐦᐋᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐧᐋᔥ ᒌ ᐄᑎᑰ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ᒌ ᐅᐦᒋ ᑎᑯᔑᓂᔨᐤ ᒌᓴᔅ ᐅᑳᐧᐄᐦ ᑭᔮᐦ ᐧᐄᒋᐄᔨᔨᐤ᙮ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐊᓂᑖᐦ ᒌ ᓃᐴᔨᐤ, ᐋᒄ ᑳ ᐲᐦᑖᑎᔑᐦᐧᐋᔨᒡ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᓂᑑᒫᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ᒌ ᒥᐦᒑᑎᔨᐤ ᐄᔨᔨᐤᐦ ᐋ ᐧᐋᔅᑳᐱᔥᑖᑯᑦ ᒌᓴᔅ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐧᐋᔥ ᐊᓂᒌ ᑖᐅᒡ ᒋᑳᐧᐄ ᑭᔮᐦ ᒌᒋᔖᓂᒡ, ᒌ ᓂᑑᒥᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᐧᐋᓐ ᒫᒃ ᓂᑳᐧᐄ ᑭᔮᐦ ᐄᔨᔨᐅᒡ ᓃᒋᔖᓂᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ᒥᓯᐧᐋ ᒌ ᐊᔨᑖᐱᐤ ᐋ ᑭᓂᐧᐋᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐧᐋᔅᑳᐱᔥᑖᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒫᐅᒌ ᓃᒋᔖᓂᒡ ᑭᔮᐦ ᐋᐅᒄ ᐆ ᓂᑳᐧᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ᐊᓐ ᐊᐧᐋᓐ ᒑ ᑐᑎᒧᐧᑳ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐧᐃᓂᔨᐤ ᐋᐅᒄ ᐊᓐ ᐧᐋᒋᔖᓂᔮᓐ ᑭᔮᐦ ᐋᐅᒄ ᐊᓐ ᐧᐋᒋᔖᓂᔅᐧᑳᒥᔮᓐ ᑭᔮᐦ ᐋᐅᒄ ᐊᓐ ᐧᐋᑳᐧᐃᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ᐹᔨᐧᑳᐤ ᒦᓐ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᔑᔓᒡ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᒑᒃ ᒌ ᐋᑎ ᒫᒨ ᒥᐦᒑᑎᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐋ ᐹᒋ ᓂᑑᐦᑖᑯᑦ᙮ ᐋᒄ ᑳ ᐴᓯᑦ ᒌᒫᓂᓯᔨᐤ, ᑳ ᐊᑯᒧᑦ ᐊᓂᑎᐦ ᓵᑭᐦᐄᑭᓂᐦᒡ ᐋᑯᑎᐦ ᑳ ᐅᐦᒋ ᒋᔅᑯᑎᒧᐧᐋᑦ᙮ ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᒥᐦᒑᑐᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐹᒋ ᑎᑯᔑᓃᔨᒡ ᐋ ᐧᐄ ᓂᑑᐦᑖᑯᑦ ᐊᓂᑖᐦ ᔑᔓᒡ ᒌᐦ ᑖᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ᒥᔥᑏᐦ ᒫᒃ ᒌ ᒋᔅᑯᑎᒧᐧᐋᐤ ᑎᐹᒋᒧᐧᐃᓐ ᒋᔅᑯᑎᒫᒑᐧᐃᓐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, ");
INSERT INTO crl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ᓂᑎᐦᑎᒧᒄ ᒫᐦ, ᐹᔨᐧᑳᐤ ᓈᐹᐤ ᒌ ᓂᑑᓂᐦᑖᐅᒋᐦᒑᐤ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐧᐋᓯᐧᓵᐱᓂᐦᒃ ᔒᒥᓐ ᑳᓂᑖᐆᒌᐦᒑᒥᑭᐦᒡ ᐱᔅᒡ ᐊᓂᑖᐦ ᐹᑐᑖᔅᑭᓂᐤ ᒌ ᐱᐦᒋᔥᑎᓂᔨᐤ, ᐋᒄ ᐱᔮᔒᔥ ᒥᓯᐧᐋ ᑳ ᒦᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ᑯᑎᒃ ᔒᒥᓐ ᐋ ᐊᓯᓃᐧᐃᔨᒡ ᒌ ᐱᐦᒋᔥᑎᓂᔨᐤ, ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᒦᐦᐧᑳᒡ ᐊᔅᒌᐧᐃᔨᒡ, ᐧᐄᐱᒡ ᒫᒃ ᒌ ᓵᒋᓂᐦᑖᐅᒋᓂᔨᐤ ᐧᐋᔥ ᑖᐹ ᐅᐦᒋ ᒋᔅᐱᑳᐤ ᐊᓂᑎᐦ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐋᑎ ᐄᔥᐱᐦᐋᐦᒃ ᐲᓯᒻ ᒌ ᐃᔥᐧᑳᑖᔨᐤ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᒑᒃ ᒌ ᐋᑎ ᓂᐲᒥᑭᓐ ᐧᐋᔥ ᑖᐹ ᐅᐦᒋ ᐅᑎᐲᒥᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ᐋᒄ ᐊᓂᐦᐄ ᔒᒥᓐ ᑳ ᐹᐦᐱᐦᒋᔥᑎᐦᒡ ᐊᓂᑖᐦ ᑳ ᑳᐧᐋᔅᑯᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ ᐋᐦᑎᑯᐦᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑᒃ ᑳᐦ ᐋᑎ ᐃᔅᒡ ᓂᐦᑖᐅᒋᐦᒡ᙮ ᒑᒃ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᓐᐦ ᐊᓂᐦᐄ ᑳ ᓂᐦᑖᐅᒋᐦᑖᑭᓂᐧᐃᐦᒡ ᐋ ᒌ ᒋᐱᔥᑳᑑᒥᑭᐦᒡ ᐊᓂᐦᐄ ᑳ ᑳᐧᐋᔅᑯᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᓂᐦᑖᐆᒌᐦᒑᒥᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ᐱᔅᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᔒᒥᓐᐦ ᐋ ᒥᔪᔅᑭᒥᑳᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᐲᐦᒋᔥᑎᓃᔨᒡ, ᒌ ᒥᔪ ᓂᐦᑖᐅᒋᓐ ᐅᐦᐄ, ᐋᒄ ᒫᒃ ᑳ ᒥᔪ ᓂᐦᑖᐆᒌᐦᒑᒥᑭᐦᒡ᙮ ᐱᔅᒡ ᐅᐦᐄ ᔒᒥᓐ ᓂᔥᑐᒥᑎᓂᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐᐦ ᒌ ᐅᐦᒋ ᓂᐦᑖᐅᒋᓐᐦ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐋᒄ ᐱᔅᒡ ᓂᑯᐧᑖᓱᒥᑎᓂᐤ ᒌ ᐅᐦᒋ ᓂᐦᑖᐅᒋᓐᐦ, ᐋᒄ ᑯᑎᒃ ᒥᑖᐦᑐᒥᑎᓂᐤ᙮” ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑎᐹᒋᒧᐧᐃᓂᔨᐤ ᑳ ᐧᐄᐦᑎᐦᒃ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐅᐦᑖᐅᑳᑦ ᐋ ᓂᐦᐄᐦᑎᐦᒃ ᒫᒃ, ᔮᐧᑳᐦ ᑭᑎ ᐧᐄ ᓂᑐᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᒥᒄ ᐧᐄᔨᐧᐋᐤ ᐋᐦᑖᐦᒡ ᒌᓴᔅ, ᐱᔅᒡ ᐊᐧᐋᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, ᒌ ᑯᐧᑳᒋᒥᑰ ᑖᓐ ᐋ ᐄᔑ ᐧᐄᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᑎᐹᒋᒧᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᒌ ᒥᔨᑯᓈᐧᐋᐤ ᒌᔨᐧᐋᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐧᒫᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ, ᒥᒄ ᒫᒃ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᐄᔥ ᒥᔮᑭᓄᐧᐃᐦᒡ ᐅᔮᔨᐤ ᒑ ᒌ ᐄᔥ ᒋᔅᒑᐦᐄᑎᐦᒡ, ᐋᔨᒨᑎᒧᐧᐋᑭᓂᐧᐃᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐧᐃᓐ ᐋᐦ ᐋᐱᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ᒑ ᒌ ᑎᐱᐱᔨᒡ ᐆ ᑳᐦ ᐄᑎᔥᑖᒡ, ᐋᑦ ᐋ ᐧᐋᐱᐦᑎᐦᒡ ᓂᒧᐃ ᒌ ᓂᔥᑑᓂᒧᒡ ᑭᔮᐦ ᓲᐦᒃ ᐋ ᓂᑐᐦᑎᐦᒡ ᓂᒧᐃ ᒌ ᓂᔅᑐᐦᑎᒧᒡ᙮ ᐧᐋᔥ ᒌ ᓂᔥᑑᓂᒧᐧᐋᐧᐋᑯᐱᓈ ᑭᔮᐦ ᒌ ᓂᔅᑐᐦᑎᒧᐧᐋᐧᐋᑯᐱᓈ ᓂᐱᐦ ᐹᒋ ᒌᐧᐋ ᓈᑎᑯᒡ ᒑ ᒌ ᐧᐋᐹᔨᐦᑎᒨᐧᑳᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᓂᒧᐃ ᐋ ᒋᓂᔅᑐᐦᑖᓈᐧᐋᐤ ᒌᔨᐧᐋᐤ ᐋ ᐄᔑ ᐧᐄᐦᑎᒫᒑᒥᑭᐦᒡ ᐆ ᑎᐹᒋᒧᐧᐃᓐ? ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒫᒄ ᐊᓂᐦᐄ ᑯᑎᒃ ᑎᐹᒋᒧᐧᐃᓐ? ");
INSERT INTO crl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐧᐋᐧᐄᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᒧᔮᒻ ᓂᐦᑖᐅᒋᐦᒑᓯᐤ ᔒᒥᓐ ᑳ ᐧᐋᓯᐦᐧᓵᐱᓂᐦᒃ ᐃᓯᓈᑯᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ᐊᓂᐦᐄ ᒫᒃ ᔒᒥᓐ ᐱᑐᑖᔅᑭᓂᐤ ᑳ ᐱᒋᔅᑎᐦᒡ ᐋᐅᑯᓂᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒡ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ, ᑏᐧᐋᐦᒡ ᒥᒋᒥᓂᑑ ᑎᑯᔑᓂᔨᐤ ᐋᐦ ᐋᑎ ᐅᑎᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᒑ ᐄᔑ ᓂᐦᑖᐅᒋᓃᔨᑯᐱᓈ ᐅᑖᐦᐄᐧᐋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ᐋᒄ ᐊᓂᐦᐄ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐧᐃᒡ ᑳ ᐱᒋᔅᑎᐦᒡ ᐋᐅᑯᓂᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᑏᐧᐋᐦᒡ ᒥᒄ ᑳ ᐄᔑ ᐅᑎᓂᐦᒡ ᐅᔅᑭᒡ ᐱᔮᐦᑎᐦᒡ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᓈᔥᒡ ᐋ ᒨᒋᒑᔨᐦᑎᒥᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᐅᑎᐲ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐋᔨᒡ ᓂᐦᑖᐅᒋᒡ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᓈᐅᔥ ᒌ ᐄᔑ ᑳᐳᐧᐃᒡ᙮ ᐄᔥᐱᐦ ᓈᒋᔅᑭᐦᐧᑳᐤ ᐋᐦ ᐋᔨᒥᓂᔨᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᒫᔮᔨᒫᑭᓂᐧᐃᒡ ᐊᓂᔮᔨᐤ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᑳ ᑖᑆᐦᑎᒡ ᐅᐦᒋ ᐋᑯᑖᐦ ᑏᐧᐋᐦᒡ ᒌᐧᐋᑳᐳᐧᐃᒡ ᑭᔮᐦ ᐴᓈᔮᔨᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ᐋᒄ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᐊᓂᐦᐄᐦ ᔒᒥᓐ ᑳ ᐱᒋᔅᑎᐦᒡ ᐊᓂᑖᐦ ᑳ ᑳᐧᐋᔅᑯᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ ᐋᐦᑎᑯᐦᒡ ᐋᔪᐧᐃᒄ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᑳ ᐹᐦᑎᐦᒡ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᐋ ᒥᑯᔥᑳᑖᐦᔨᑎᒦᐦᐄᑯᐦᒡ ᒑᐧᑳᔨᐤ ᐆ ᐱᒫᑎᓰᐧᐃᓂᐧᐋᐦᒡ ᑭᔮᐦ ᓈᔥᒡ ᒥᒄ ᐋ ᐧᐄᐦ ᐅᔔᔮᓂᒥᒡ ᐋᐦ ᑎᒡ ᑭᔮᐦ ᐱᔑᔑᐦᒄ ᐋ ᒧᔥᑖᓂᐦᒡ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᐃᔮᒡ ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᐧᐋᐦᒋ ᒑᒃ ᐋᑎ ᐧᐋᓈᑎᓃᔨᒡ ᐅᑖᑆᐦᑎᒧᐧᐃᓂᐧᐋᐤ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪᓂᐦᑖᐅᒋᒡ ᐅᐱᒫᑎᓰᐧᐃᓂᐧᐋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ᐋᒄ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᐊᓂᐦᐄᐦ ᔒᒥᓐ ᑳ ᐱᒋᔅᑎᐦᒡ ᐊᓂᑖᐦ ᐋ ᒥᔪᔅᑭᒥᑳᒡ ᐋᔪᐧᐃᒄ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒡ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᑏᐧᐋᐦᒡ ᐅᑎᓂᒧᒡ ᑭᔮᐦ ᓅᑯᓂᔨᐤ ᐅᐱᒫᑎᓰᐧᐃᓂᐧᐋᐦᒡ ᒧᔮᒻ ᐋᐦ ᐋᑎ ᒥᔪᓂᐦᑖᐅᒋᒡ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ᒧᔮᒻ ᓂᐦᑖᐅᒋᐦᒋᑭᓐᐦ ᓈᔥᒡ ᐋ ᒥᔪᓂᐦᑖᐅᒋᒡ ᐋᔪᐧᐃᒄ ᒑᒃ ᐋᑎ ᐃᓯᓈᑯᓯᒡ ᐅᒌ᙮ ᑯᑎᑭᒡ ᓂᔥᑐᒥᑎᓂᐤ ᐊᑎᑎᐤ ᒌ ᓂᐦᑖᐅᒋᓂᔨᐤᐦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋᐦᑖᐦᒡ, ᐋᒄ ᑯᑎᑭᒡ ᓂᑯᐧᑖᓱᒥᑎᓂᐤ, ᐋᒄ ᑯᑎᑭᒡ ᒥᑖᐦᑐᒥᑎᓂᐤ᙮” ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ ᒌᓴᔅ, “ᐄᔨᐦᑐ ᐋ ᐊᐧᐋᓐ ᐋ ᒌ ᓯᔅᑭᐦᐋᐦᒃ ᐧᐋᔥᑖᓂᒫᑭᓂᔨᐤ ᔒᐹ ᓂᐹᐧᐃᓂᐦᒡ ᒑ ᒌ ᐊᔥᑖᑦ, ᑭᔮᐦ ᒫᒃ ᔒᐹ ᐧᐋᐅᔮᐦᑖᑭᓂᐦᒡ? ᓂᒧᐃ ᐋ ᐧᐋᔥᑖᓂᒫᑭᓈᐦᑎᑯᒡ ᒋᒥᑖᐤ? ");
INSERT INTO crl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ᒥᓯᐧᐋ ᒑᐧᑳᓐ ᐋᑳ ᑳ ᓅᑯᐦᑖᑭᓂᐧᐃᒡ ᑭᑎ ᓅᑯᐦᑖᑭᓂᐤ, ᐋᒄ ᐊᓐ ᑳ ᐊᑯᓂᐦᐄᑭᓅᐦᒡ ᑭᑎ ᒧᔖᔥᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ᓂᑎᐦᑎᒧᒄ ᒫᒃ, ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐅᐦᑖᐅᑳᑦ ᐋ ᓂᐦᐄᐦᑎᐦᒃ, ᐋᑯᔥ ᔮᐧᑳᐦ ᑭᑎ ᐧᐄ ᓂᑐᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ᒌᓴᔅ ᑭᔮᐦ ᒌᐦ ᐄᑖᐤ, “ᓂᓈᑭᑎᐧᐋᔨᐦᑎᒧᒄ ᔮᐧᑳᐦ ᒑ ᒌ ᓂᑐᐦᑎᒫᒄ᙮ ᐧᐋᔥ ᐃᔥᐱᔥ ᐊᑎᑎᐤ ᓂᑑᐦᑎᒥᓈ ᑭᔮᐦ ᐋᐅᒄ ᐊᓐ ᒑ ᐃᔥᐱᔥ ᓂᔅᑐᐦᑎᒥᓐ ᑭᔮᐦ ᒫᒃ ᐊᔮᐱᒡ ᐊᑎᑎᐤ ᒦᓐ ᒑ ᐃᔮᔨᓐ ᓂᔅᑐᐦᑎᒨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ᐊᓐ ᒫᒃ ᐊᐧᐋᓐ ᓈᑑᐦᑎᐦᒃ ᓂᒋᔅᑯᑎᒫᒑᐅᓂᔨᐤ ᐊᑎᑎᐤ ᓂᔅᑑᐦᑎᒧᓂᔨᐤ ᒋᑭ ᒥᔮᑭᓂᐤ᙮ ᐋᒄ ᐊᓐ ᐊᐦᐋᑳ ᓈᑑᐦᑎᐦᒃ ᐋᐅᒄ ᐊᓐ ᐋᐦᐋᑦ ᐊᓂᔮ ᐊᐱᔑᔥ ᑳ ᐃᔥᐱᔥ ᓂᔅᑑᐦᑎᐦᒃ ᑭᑎ ᐅᑎᓂᑭᓄᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ᒌᓴᔅ ᑭᔮᐦ ᒦᓐ ᑳᐦ ᐄᑖᑦ, “ᒧᔮᒻ ᓈᐹᐤ ᑳ ᐧᐋᓯᐧᓵᐱᓈᐦᒃ ᔒᒥᓐ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᐋᔪᐧᐃᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ᐊᓐ ᓈᐹᐤ ᓂᐹᐤ ᐋ ᑎᐱᔅᑳᔨᒡ ᐋᒄ ᐄᔥᐱᐦ ᐱᔮᑖᐱᓃᔨᒡ ᐧᐃᓂᔥᑳᑦ᙮ ᓂᐦᑖᐅᒋᓂᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᔒᒥᓐ ᑳ ᓂᐦᑖᐅᒋᐦᑖᑦ ᒥᒄ ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓂᑖᐦ ᐧᐋᐦᒋ ᓂᐦᑖᐅᒋᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ᐧᐋᔥ ᐊᔅᒌ ᓂᐦᑖᐅᒋᒑᒥᑭᓐ ᐊᓂᐦᐄᐦ ᐱᐦᐧᑳᔑᑭᓂᒥᓐ᙮ ᓃᔥᑎᒻ ᓵᒋᓂᐦᑖᐅᒋᓐᐦ ᐊᓂᑎᐦ ᐊᔅᒌᐦᒡ, ᒦᓐ ᐋᑎ ᓃᐦᑖᐆᒌᐦᒡ ᐊᑐᐧᐃᔅ, ᑳ ᒌᔥ ᓂᐦᑖᐅᒋᐦᒡ ᑭᔮᐦ ᐋᐦ ᐋᑎ ᒦᓂᔑᐧᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ᐃᔥᑯᑎᒃ ᑳ ᒌᔑ ᓂᐦᑖᐆᒋᐦᐧᑳᐧᐋ ᐊᓂᐦᐄ ᐱᐦᐧᑳᔑᑭᓂᒥᓐ, ᐋᒄ ᒑ ᐋᐱᑎᓰᑦ ᐊᓐ ᓈᐹᐤ ᐋ ᒫᐦᒥᓂᔕᐦᒃ ᒋᒥᔅᑯᔖᐧᐋᓯᑭᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᑦ ᑭᔮᐦ ᒑ ᐋᑎ ᓂᓂᔅᑑᓂᐦᒃ ᐊᓂᔮᔨᐤᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐᐦ᙮ ᐧᐋᔥ ᔖᔥ ᐅᑎᐦᒋᐱᔨᐤ ᒑ ᓂᔅᑑᓂᑭᓂᐧᐃᒡ ᐊᓂᐦᐄ ᑳ ᐄᔥ ᓂᐦᑖᐅᒌᐦᑖᑭᓂᐧᐃᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ᐋᒄ ᐅᔮᔨᐤ ᑳᐦ ᐋᑎ ᐄᑖᑦ ᒌᓴᔅ, “ᒑᐧᑳᓐ ᒫᒃ ᒑ ᒌ ᐧᐄᐦᑎᒥᐦᒄ ᒑ ᒌ ᐄᔨᔨᒄᐦ ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐧᐃᓐ? ᒑᒄ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐧᐃᓐ ᒑ ᒌ ᐧᐄᐦᑎᒥᐦᒄ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ᒧᔮᒻ ᐊᓐ ᔒᒥᓐ ᒫᐅᒡ ᑳ ᐊᐱᔒᔑᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒫᔅᑎᕐᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐊᐧᑳᔑᓈᑯᐦᒡ ᒋᔖᒥᓂᑑ ᒋᐦᒋᐅᒋᒫᐧᐃᓐᐦ᙮ ᓈᐹᐤ ᐅᑎᓈᐤ ᐅᔮᔨᐤ ᔒᒥᓐ ᐋᒄ ᐊᔅᒌᐦᒡ ᐋᔮᐅᑭᐧᐋᑦ ᒑ ᒌ ᓂᐦᑖᐅᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ᒑᒃ ᒫᒃ ᐋᐦ ᐋᑎ ᓂᐦᑖᐅᒋᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᓂᐦᑖᐅᒋᔨᒡ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒫᐅᒡ ᒑᐧᓈᔅᑯᓰᔨᒡ ᐋᑎᓃᔨᔨᒡ ᑯᑎᒃ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᐋ ᐃᔥᐱᔥ ᐲᐧᑳᓯᑦ ᐆ ᒥᔅᑎᑯᔥ ᐱᔮᔒᔑᒡ ᐅᒋᔥᑐᓂᐦᑳᓯᐧᐃᒡ ᐊᓂᑖᐦ ᐊᐅᐦᑎᐦᑯᓃᐧᐃᔨᒡ ᐊᓂᑎᐦ ᐋ ᐊᐅᑳᔥᑖᔮᔅᐧᑳᔮᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ᒥᐦᒑᐧᑖᐤ ᒌ ᑎᐹᒋᒨ ᒌᓴᔅ ᐅᔮᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᑎᐹᒋᒧᐧᐃᓐ ᐋ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᑦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᑦ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ᙮ ᒥᒄ ᑖᓐ ᒑ ᒌ ᐃᔥᐱᔥ ᓂᔅᑐᐦᑎᒥᔨᒡ ᐋᔪᐧᐃᒄ ᑳ ᐄᔑ ᐧᐄᐦᑎᒧᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᐱᔑᔑᐦᒄ ᑳᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᐧᐋᔨᐤᐦ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᐧᐄᔨᐧᐋᐤ ᐋᐦᑖᐦᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐋᑯᑖᐦ ᑳ ᒌ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᑦ ᑖᓐ ᐋᔥᒌᔓᐧᐋᒥᑭᓃᔨᔨᒡ ᐅᔮᔨᐤᐦ ᐆ ᑎᐹᒋᒧᐧᐃᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ᐊᓂᔮᔨᐤ ᐧᐋᑖᑯᓰᔨᒡ, ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, “ᓈᑖᐦ ᐊᑳᒥᐦᒡ ᓵᑭᐦᐄᑭᓂᐦᒡ ᐃᔅᒋᒫᑖᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑳ ᓂᑭᑖᒡ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᐋᒄ ᑳ ᐴᓯᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒌᓴᔅᐦ᙮ ᐋᒄ ᑳ ᒋᐦᒋᒋᒫᒡ ᒌᓴᔅᐦ ᐋ ᐴᓯᐦᐋᒡ᙮ ᒌᐦ ᑎᐧᑳᓐᐦ ᑭᔮᐦ ᑯᑎᒃ ᒌᒫᓐ ᐋᐦ ᐋᑎᒧᔖᐅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ᒑᒃ ᒌ ᐅᐦᒋ ᒥᔥᑎᐦ ᒌᔥᑎᓂᐱᔨᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐴᓯᐹᐦᔨᔨᒡ ᑭᔥᑭᓐ ᐅᒌᒫᓂᓯᐧᐋᒡ, ᒑᑳᑦ ᒌ ᓵᑭᔅᒋᓈᐹᔮᔨᐤ ᐅᒌᒫᓂᓯᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ᐊᓂᑖᐦ ᒫᒃ ᑎᐦᑯᐦᐄᑭᓂᐦᒡ ᒌᐦ ᑖᐤ ᒌᓴᔅ ᐋ ᓂᐹᑦ ᐋ ᐊᔥᐧᑳᔑᒧᑦ ᐊᔥᐧᑳᔑᒧᓂᔨᐤ᙮ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒫᒃ ᒌ ᑯᔥᑯᓈᐧᐃᒡ ᐋᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓂᒧᐃ ᐋ ᒋᑭ ᐅᐦᒋ ᐃᔮᐱᑖᔨᐦᑖᓐ ᓂᔅᑖᐹᐧᐋᔮᐦᐧᑳ?” ");
INSERT INTO crl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ᑳ ᐧᐃᓂᔥᑳᑦ ᒌᓴᔅ, ᐋᒄ ᑳᐦ ᐄᑎᔓᐧᐋᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑳ ᒌᔥᑎᓃᔨᒡ ᒑ ᒌ ᐴᓂᐱᔨᔨᒡ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑭᔥᑭᓐᐦ ᑳᐦ ᐄᑖᑦ, “ᒋᔮᒫᐧᐃᓰᒄ, ᐋᔪᐧᐃᒄ ᐋᓐ ᐋᒄ᙮” ᒌ ᒋᒥᔅᑎᓂᔨᐤ, ᐋᒄ ᒫᒃ ᑳ ᐅᐦᒋ ᐧᔮᔥᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᑯᔥᑖᒋᔮᒄ? ᑖᓐ ᒋᑖᑆᔮᔨᐦᑎᒧᐧᐃᓂᐧᐋᐤ?” ");
INSERT INTO crl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ᒥᔥᑎᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑖᓐ ᑳ ᐄᔑ ᐧᐋᐱᐦᑎᐦᒡ ᐋᐦ ᐄᔅᐱᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑎᑐᒡ, “ᐊᐧᐋᓐ ᐆ ᐧᐋᐧᐋᒡ ᐋ ᒌᔥᑎᓃᔨᒡ ᑭᔮᐦ ᑭᔥᑭᓐᐦ ᐋ ᐱᔑᒋᐦᐄᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓅᐦᐋᒧᐧᐋᑭᓐᐦ ᒑᒃ ᒌ ᒥᓯᑳᐅᒡ ᓈᑖᐦ ᐊᑳᒥᐦᒡ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᑳᕋᓰᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ᒌᓴᔅ ᒫᒃ ᑳ ᑭᐹᑦ ᑏᐧᐋᐦᒡ ᒌ ᐹᒋ ᓂᒋᔥᑳᑰ ᓈᐹᐤᐦ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒌᐲᑭᒥᑯᐦᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒌᐲᑭᒥᑯᐦᒡ ᑳ ᐧᐄᒌᑦ ᐆ ᓈᐹᐤ᙮ ᓂᒧᐃ ᔖᔥ ᐅᐦᒌ ᐄᑖᐱᐦᑳᓲ ᐴᓂᔑᓈᔓᓈᔮᐱᔨ ᐋᐦ ᐋᐱᑎᓃᔨᒡ ᐋ ᒫᐦᑯᐱᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ᒥᐦᒑᐧᑖᐤ ᒌ ᒫᐦᑯᐱᑖᑭᓂᐧᐃᔨᒑᓂᐦᐄ ᐅᑎᐦᒌ ᐴᓂᔑᓈᔮᐱᔨᐤ ᐋᐦ ᐋᐱᑎᓃᔨᒡ ᑭᔮᐦ ᐅᓯᑦ ᒌ ᒥᒫᒋᒫᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᐤᐦ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒌ ᐱᔅᒋᐱᑎᒻ ᐊᓂᔮᔨᐤ ᐴᓂᔑᓈᔮᐱᔨᐤ ᑭᔮᐦ ᒌ ᐲᑯᐱᑎᒻ ᐊᓂᔮᔨᐤ ᐱᐧᔮᐱᔅᒄ ᐅᓯᑎᐦᒡ ᑳ ᒋᑭᒧᔨᔨᒡ᙮ ᒥᑐᓐ ᒌ ᐃᔥᐱᔑᐦᐋᐤ ᐊᐧᐋᔨᐤᐦ ᐋ ᐧᐄᐦ ᒥᒫᒋᑯᓂᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ᐋᔑᑯᒻ ᑎᐱᔅᑳᐤ ᑭᔮᐦ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒌ ᐱᐹᔨᐦᑖᐤ ᐊᓂᑖᐦ ᒌᐲᑭᒥᑯᐦᒡ ᑭᔮᐦ ᐋᐱᔅᑯᑎᓈᔨᐦᒡ ᐱᔑᔑᐦᒄ ᐋ ᐃᔮᔑᐧᑳᑦ ᑭᔮᐦ ᐋ ᒥᒫᑎᓱᓱᑦ ᐊᓯᓃᐦ ᐋᐦ ᐋᐱᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ᐧᐋᐦᐄᐧᐃᔥ ᒫᒃ ᒌᐦ ᑖᐤ ᑳ ᐅᐦᒋ ᐧᐋᐱᒫᑦ ᒌᓴᔅᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐧᐃᔮᐱᒫᑦ ᐋᒄ ᐋᑎ ᒋᐦᒋᐱᐦᑖᑦ, ᑳᐦ ᐋᑎ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᐧᐋᑦ ᒌᓴᔅᐦ ᐅᓯᑎᔨᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ᐋᒄ ᑳ ᑖᑆᑦ ᐋ ᒋᐧᔖᐧᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᒌᓴᔅ, ᒌᔨ ᑳ ᐅᑯᓰᑐᑖᔅᒃ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ, ᑖᓐ ᐧᐋᐦ ᑐᑎᐧᐄᔨᓐ? ᒋᐧᐄᐦᑎᒫᑎᓐ ᐋ ᐹᐦᑑᐧᐃᑦ ᒋᔖᒥᓂᑑ, ᐊᑳᐧᐄ ᓂᓈᐦᑳᑖᔨᒧᐦᐄᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐧᐋᔥ ᒌ ᐄᑎᑰ ᒌᓴᔅ, “ᒌᔨ ᒥᒋᐊᐦᒑᐦᒄ, ᒫᒌᐦ ᐧᐃᔨᐧᐄᐦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓐ ᓈᐹᐤ ᑳ ᐲᐦᒋᔥᑯᐧᐋᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᐋ ᐃᔑᓂᐦᑳᓱᔨᓐ?” ᒌ ᐄᑎᑰ ᒫᒃ, “ᑳ ᒥᐦᒑᑎᒡ ᓂᑎᔑᓂᐦᑳᓱᓐ, ᐧᐋᔥ ᓈᔥᑖᑆ ᓂᒥᐦᒑᑎᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ᐋᒄ ᓈᔥᒡ ᑳ ᐧᐄᐦ ᐋᔨᐦᑭᒫᑦ ᒌᓴᔅᐦ ᐋᑳ ᒑ ᒌ ᐄᑎᔑᐦᐧᐋᔨᒡ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐊᓂᑖᐦ ᐧᐋᐦᔨᐤ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ᒌᐦ ᑖᐅᒡ ᒫᒃ ᒥᐦᒑᑐ ᑰᐦᑰᔑᒡ ᐊᓂᑎᐦ ᐹᔓᒡ, ᐋ ᒦᒋᓱᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐊᐱᔅᐧᑳᐱᔅᑳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ᐊᓂᒌ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᒡ ᒌ ᒌᔒᐦᒋᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᐊᓂᑖᐦ ᐹᒋ ᐄᑎᔓᐦᐅᓈᓐ ᐊᓂᒌ ᑰᐦᑰᔑᒡ ᐋᐦᑖᐦᒡ ᒑ ᒌ ᐲᐦᒋᔥᑰᒋᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ᐋᔪᐧᐃᒄ ᒫᒃ ᑳᐦ ᑐᑎᐧᐋᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ᐊᓂᒌ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᒡ, ᐄᔥᐱᐦ ᑳ ᐧᐃᔨᐧᐄᔅᑯᐧᐋᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ ᑳᐦ ᐋᔓᐲᐦᒋᔥᑯᐧᐋᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑰᐦᑰᔑᒡ ᑳ ᐃᔮᒥᑖᐅᐦᒋᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐄᔑ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᑳ ᓂᔥᑖᐹᐧᐋᒡ᙮ ᐧᐃᔮᔥ ᒫᒃ ᓃᐧᔖᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᑎᔒᒑᓐᒌ ᐅᒌ ᑰᐦᑰᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ᐊᓂᒌ ᒫᒃ ᓈᐹᐅᒡ ᑳ ᑭᓂᐧᐋᔨᒫᒡ ᐅᔮᔨᐤ ᑰᐦᑰᔥ ᒌ ᐅᔑᒨᒡ ᑳ ᓂᑎᐧᐋᐧᐄᐦᑎᐦᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐧᐃᓂᐦᒡ ᑭᔮᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ᙮ ᒌ ᐃᔥᐱᐦᐄᑑᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐋ ᐧᐄᐦ ᐧᐋᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ᐄᔥᐱᐦ ᐧᐋᐦᑎᐦᑖᒡ ᒌᓴᔅᐦ ᒌ ᐧᐋᐱᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᒥᐦᒑᑐ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᒌ ᐲᐦᒋᔥᑳᑯᔨᒡ ᐋ ᐊᐱᔨᒡ ᐊᓂᑎᐦ ᐋ ᒌ ᓂᒋᓈᐧᑳᔨᑯᐱᓈᓂᐦᐄ ᑭᔮᐦ ᐋ ᒋᔮᒫᔨᐦᑖᑯᓰᔨᒡ᙮ ᒌ ᑯᔥᑖᒋᐧᐃᒡ ᒫᒃ ᐄᔥᐱᐦ ᐧᐃᔮᐱᒫᒡ ᐅᔮᔨᐤᐦ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ᒌ ᑎᐹᒋᒨᒡ ᐊᓂᒌ ᑳ ᐧᐋᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᒌ ᐲᐦᒋᔥᑳᑯᔨᒡ, ᑭᔮᐦ ᒌ ᐧᐄᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ᐋᒄ ᑳᐦ ᐋᔨᐦᑭᒫᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᑭᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔅᒌᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ᒌᓴᔅ ᒫᒃ ᐋᐦ ᐋᑎ ᐴᓯᑦ ᒌᒫᓂᓯᔨᐤ, ᐊᓐ ᓈᐹᐤ ᑳ ᒌ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ ᓈᔥᒡ ᒋᐧᐄᐦ ᐧᐄᒑᐧᐋᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐱᒋᔅᑎᓂᑰ ᒌᓴᔅᐦ ᒑ ᒌ ᐧᐄᒑᐧᐋᑦ᙮ ᒌ ᐄᑎᑰ ᒫᒃ, “ᒫᒌᐦ ᒌᐧᐋ,ᐦ ᓂᑎᐧᐋᐱᒥᒡ ᒋᐧᐄᒑᐧᐋᑭᓂᒡ ᑭᔮᐦ ᒋᐧᐋᐦᑯᒫᑭᓂᒡ, ᒑ ᐧᐄᐦᑎᒧᐧᑖᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᔪᑐᑎᒫᔅᒃ ᒋᔖᒥᓂᑑ, ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑎᒫᒑᔨᒥᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳ ᒋᔅᑐᐦᑖᑦ ᒥᓯᐧᐋ ᑳ ᐱᐹᐄᑐᐦᑖᑦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᒥᑖᐦᑐ ᐃᐦᑖᐧᐃᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋ ᐧᐋᐧᐄᐦᑎᐦᒃ ᑖᓐ ᑳᐦ ᑐᑎᒫᑯᑦ ᒌᓴᔅᐦ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᐹᐦᑖᑯᑦ ᑖᓐ ᑳ ᐄᔑ ᐧᐄᐦᑎᐦᒃ ᒌ ᒥᔅᑳᔥᑎᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ᐋᒄ ᒦᓐ ᑳ ᑎᔅᑭᒫᐦᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒫᓯᑳᑦ ᓈᑖᐦ ᐊᑳᒥᐦᒡ ᓈᔥᒡ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑳᐦ ᐹᒋ ᓈᓯᐹᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ᐹᔨᒄ ᓈᐹᐤ ᒑᐃᕋᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᒌ ᐹᒋ ᐅᑎᐦᑎᐱᔨᐦᐆ ᒌᓴᔅ ᐅᓯᑎᔨᐦᒡ᙮ ᐋᐅᒄ ᐆ ᐹᔨᒄ ᓈᐹᐤ ᑳ ᓃᑳᓂᔥᑭᐦᒃ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ᓈᔥᒡ ᓲᐦᒃ ᒌ ᓂᑐᑎᒧᐧᐋᐤ ᒌᓴᔅ ᐋᐦ ᐄᑖᑦ, “ᔖᔥ ᒑᑳᑦ ᐴᓂᐱᒫᑎᓰᐤ ᓂᑖᓂᔥ᙮ ᒌ ᐧᐃᔖᒥᑎᓐ ᒑ ᒌ ᐹᒋ ᑖᐦᒋᓂᑦ ᒑ ᒌ ᒦᓂᐧᐋᑎᓰᑦ, ᐋᒄ ᒫᒃ ᓂᒥ ᑭᑎ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ᒌᓴᔅ ᒫᒃ ᒌ ᐧᐄᒑᐧᐋᐤ ᐅᔮᔨᐤ ᓈᐹᐤᐦ᙮ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᒌ ᐧᐄᒑᐅᑰ ᐋ ᓰᐦᑎᔅᑳᑯᑦ ᐋ ᐃᔥᐱᔥ ᒥᐦᒑᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᐹᔨᒄ ᐃᔅᐧᑳᐤ ᔖᔥ ᓃᔓᔖᑉ ᐱᐳᓐᐦ ᐋ ᒌ ᐄᑖᔅᐱᓈᑯᐱᓈ ᐋ ᐧᐃᓂᐦᑖᑦ ᒫᓐ ᒥᐦᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ᐋᑎ ᒌᓂᑐᐧᐋᐱᒫᑦ ᓂᓈᐦᑭᐤ ᓂᑐᐦᑯᐄᓐᐦ ᒑ ᒌ ᐧᐄᒋᐦᐄᑯᑦ ᐊᔮᐱᒡ ᒌ ᓂᓈᐦᑳᑖᔨᒧᐦᐄᑰ ᐅᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ᙮ ᒑᒃ ᒫᒃ ᒌ ᒫᔅᑎᓈᐤ ᒥᓯᐧᐋ ᐅᔔᔮᓂᒻ ᐋ ᑎᐱᐦᐊᒧᐧᐋᑦ ᐅᔮᔨᐤ ᓂᑐᐦᑯᐄᓐ᙮ ᐊᔮᐱᒡ ᒫᒃ ᐋᔪᐧᐃᒄ ᑳᐦ ᑎᒃ ᐋ ᐧᐃᓂᐦᑖᑦ ᒫᓐ ᒥᐦᑯᔨᐤ᙮ ᐊᑎᑎᐤ ᑭᔮᐦ ᒌ ᐋᑎ ᐋᐦᑯᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ᒌ ᐹᐦᑎᒧᑖᑯᐱᓐ ᑖᓐ ᑳ ᐄᑖᒋᒫᑭᓂᐧᐃᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᐊᓂᔮᔨᐤ ᐋ ᐹᒋ ᐧᐄᒋᐦᐄᐧᐋᑦ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᒡ ᒋᐧᐄᐦ ᐹᐧᔖᐱᒫᐤ ᒌᓴᔅᐦ ᐋ ᐄᑖᔨᐦᑎᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“ᐋᑦ ᒥᒄ ᑖᐦᒋᓂᒧᒑ ᐅᒑᐧᑳᓂᒻ ᓂᑭ ᒌ ᒦᓂᐧᐋᑎᓰᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ᒌ ᑖᐦᒋᓂᐧᒫᐤ ᐅᑎᑯᐦᐱᔨᐤ ᐋᒄ ᑏᐧᐋᐦᒡ ᑳ ᒋᐱᐦᑎᔑᑭᐧᐃᔨᒡ ᐅᒥᐦᒄ᙮ ᑭᔮᐦ ᒌ ᒨᔑᐦᑖᐤ ᐲᐦᒋᔨᐤ ᑖᑆᐦ ᐋ ᒦᓂᐧᐋᒋᐦᐋᑭᓅᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ᒌᓴᔅ ᒫᒃ ᑏᐧᐋᐦᒡ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒦᓂᐧᐋᒋᐦᐄᐧᐋᐤ ᓲᐦᑳᑎᓰᐧᐃᓂᔨᐤ ᐋ ᒌ ᐧᐃᔨᐧᐄᐱᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐅᐦᒋ᙮ ᑳ ᑭᓂᐧᐋᐱᒫᑦ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᐧᐋᓐ ᑳ ᐹᒋ ᑖᐦᒋᓂᐦᒃ ᓂᑎᑯᐦᐱᔨᐤ?” ");
INSERT INTO crl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒫᒃ ᒌ ᐄᑎᑰ, “ᒌ ᐧᐋᐱᒫᐅᒡ ᐋ ᐃᔥᐱᔥ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐧᐋᔅᑳ ᐋᐦ ᑖᔨᓐ, ᐊᔮᐱᒡ ᒫᒃ ᐋᐦ ᐃᔨᓐ, ᐊᐧᐋᓐ ᑳ ᐹᒋ ᑖᐦᒋᓂᑦ?” ");
INSERT INTO crl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ᐋᒄ ᑳ ᐄᑖᐱᑦ ᒌᓴᔅ ᐋ ᓈᓂᑎᐧᐋᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᑖᐦᒋᓂᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ᐋᒄ ᒫᒃ ᐊᓐ ᐃᔅᐧᑳᐤ ᐋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᑖᓐ ᑳᐦ ᑐᑎᒧᐧᐋᑭᓅᑦ, ᒌ ᐹᒋ ᐅᑎᐦᑎᐱᔨᐦᐆ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋ ᐧᐋᐧᐃᐱᔨᑦ ᐋ ᐃᔥᐱᔥ ᓵᒋᓯᑦ᙮ ᐋᒄ ᑳ ᐧᐄᐦᑎᒧᐧᐋᑦ ᐧᐄᔨ ᐋ ᒌ ᑖᐦᒋᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤ, “ᓂᑖᓂᔥ, ᒋᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ ᒋᒦᓂᐧᐋᒋᐦᐄᑯᓐ᙮ ᒫᒌᐦ ᒫᒃ ᒋᔮᒫᔨᐦᑎᒧᐧᐃᓐ ᐃᔮᐦ᙮ ᐧᐋᔥ ᔖᔥ ᑖᑆᐦ ᒌ ᒦᓂᐧᐋᑎᓰᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ᒫᐧᑳᒡ ᒫᒃ ᐋᔥᒄ ᐋ ᐊᔨᒥᑦ ᒌᓴᔅ ᒌ ᐹᒋ ᑎᑯᔑᓂᔨᐤ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑖᐦ ᒑᐃᕈᔅ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ ᒑ ᒌ ᐹᒋ ᐧᐄᐦᑎᒧᐧᐋᒡ ᒑᐃᕋᔅ ᔖᔥ ᐋᐦᐋᑳ ᐱᒫᑎᓰᔨᒡ ᐅᑖᓂᓯᔨᐤᐦ᙮ ᒌ ᐄᑖᐅᒡ ᒫᒃ ᐋᐦᐋᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐊᑎᑎᐤ ᒑ ᒌ ᐅᑖᒥᐦᐋᔨᒡ ᒋᔅᑯᑎᒫᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ᒌᓴᔅ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐱᓯᐦᑎᐧᐋᐤ ᐅᔮᔨᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒑᐃᕈᔅ, “ᐊᑳᐧᐄ ᑯᔥᑖᒡ, ᒥᒄ ᑖᑆᐦᑎ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ᐋᒄ ᒌᓴᔅ ᓂᒧᐃ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᓅᔔᔥᑳᑯᑦ ᒥᒄ ᐲᑎᕐᐦ, ᒉᒥᔅᐦ ᑭᔮᐦ ᒞᓐᐦ, ᒉᒥᔅ ᐧᐄᒋᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ᐄᔥᐱᐦ ᐧᐋᑎᐦᑎᐧᒫᒡ ᒑᐃᕈᔅ ᐧᐄᒋᔨᐤ ᒌ ᐧᐋᐱᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᓈᔥᒡ ᐋᐦ ᐄᑎᐦᑖᑯᓯᔨᒡᐦ, ᐋ ᐅᐦᒋᑭᐧᐋᐱᔨᒡ ᑭᔮᐦ ᐋᐦ ᐋᔑᐧᑳᔨᒡ ᐋ ᒫᑑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᐲᐦᒑᑦ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᒌᐦ ᐄᑖᐤ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᓈᔥᒡ ᐄᑎᐦᑖᑯᓯᔮᒄ? ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐅᐦᒋᑯᐧᐋᐱᔮᒄ? ᑖᐹ ᐴᓂᐱᒫᑎᓰᐤ ᐆ ᐃᔅᐧᑳᔥ ᒥᒄ ᐧᐋᔥ ᐊᓐ ᓂᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ᒑᔥᑳ ᒥᒄ ᒌ ᐅᔑᓈᑰ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ᙮ ᐋᒄ ᒥᓯᐧᐋ ᑳ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᑦ᙮ ᐋᒄ ᐊᓐ ᐊᐧᐋᔑᔥ ᐅᑳᐧᐄᐦ, ᑭᔮᐦ ᐅᐦᑖᐧᐄᐦ ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᑳ ᐹᒋ ᐧᐄᒑᐅᑯᑦ ᐋᔪᐧᐃᑯᓐᐦ ᒥᒄ ᐅᔮᔨᐤ ᑳ ᐱᒋᔅᑎᓈᑦ ᒑ ᒌ ᐲᐦᒑᔨᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐧᐋᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ᑳ ᐅᑎᓂᐧᒫᑦ ᐅᑎᐦᒌᔨᐤ ᐊᓂᔮᔨᐤ ᐊᐧᐋᔑᔥ, ᑳᐦ ᐄᑖᑦ, “ᑖᓕᕦ, ᑰᒻ᙮” “ᐃᔅᐧᑳᔥ, ᐧᐃᓂᔥᑳ ᒋᐧᐄᐦᑎᒫᑎᓐ,” ᐄᔑ ᐄᐧᑖᔥᑎᒧᐧᐋᑖᑭᓂᐤ ᐆ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ᑏᐧᐋᐦᒡ ᒫᒃ ᒌ ᐧᐃᓂᔥᑳᐤ ᐊᓐ ᐃᔅᐧᑳᔥ ᑳᐦ ᐋᑎ ᐱᐹᒧᐦᑖᑦ᙮ ᐧᐃᔮᔥ ᒌ ᓃᔓᔖᐳᐧᓈᔒᒑ ᐆ ᐃᔅᐧᑳᔥ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᑳ ᐧᐋᐱᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ᒌᓴᔅ ᒫᒃ ᒌ ᐄᑎᔓᒫᐤ ᐋᑳ ᒑ ᒌ ᐧᐄᐦᑎᒧᐧᐋᔨᒡ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᒑ ᒌ ᒥᔨᒫᑭᓂᐧᐃᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᐧᑳᔥᐦ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᒦᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ᒌ ᓂᑭᑎᒻ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ, ᐋᒄ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᑳ ᓂᐦᑖᐅᒋᓈᑭᓅᑦ, ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒌ ᐧᐄᒑᐅᑰ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔒᑳᔨᒡ ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᒌ ᒥᐦᒑᑎᔨᐤ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᐋ ᓂᑑᐦᑖᑯᑦ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᒥᔅᑳᔥᑐᐧᐋᐅᒡ ᑖᓐ ᑳ ᐄᔨᔨᒡ᙮ “ᑖᓂᑖᐦ ᐧᐋᐦᑎᓂᐦᒃ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ?” ᒌ ᐄᑎᑐᒡ᙮ ᑭᔮᐦ ᒌ ᐃᔨᐅᒡ, “ᑖᑆᐦ ᑭᒑᐦᑖᐧᐋᔨᐦᑎᒧᐦᑖᑯᓲ᙮” ᒌ ᐃᔨᐅᒡ ᑭᔮᐦ, “ᑖᓂᑖᐦ ᐧᐋᐦᒋ ᑐᑎᐦᒃ ᐅᔮᔨᐤ ᒫᒥᔥᑳᒡ ᒑᐧᑳᔨᐤ? ");
INSERT INTO crl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ᓂᒧᐃ ᐋᐦ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᒥᔅᑎᑯᓈᐹᐧᐃᔨᒡ ᒣᕇ ᐅᑯᓯᔅᐦ᙮ ᓂᒧᐃ ᐋᐦ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᐧᐄᒋᐄᔨᔨᐧᐋᐤ ᒉᒥᔅ, ᐧᒑᓯᔅ, ᒍᑖᔅ ᑭᔮᐦ ᓵᐃᒥᓐ? ᓂᒧᐃ ᐋ ᐅᑎᐦ ᐧᐄᒋᔨᐤ ᑭᔮᐦ ᐅᐧᐄᒋᔖᓂᔅᐧᑳᒻ?” ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑯᐧᑳᒋᒥᑐᒡ ᐧᐋᔥ ᑖᐹ ᐅᐦᒋ ᓂᐦᐄᔅᑳᑯᒡ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐅᒋᔅᒋᐧᐋᐦᐄᒑᓲᑦ ᒋᔅᑖᔨᒫᑭᓂᐤ ᐊᔨᐦᒡ ᐃᐦᑖᐧᐃᓂᐦᒡ, ᐋᒄ ᐊᓂᑎᐦ ᑎᐱᔨᐧᐋ ᐅᑎᔅᒌᐦᒡ ᐋᐦ ᑖᑦ ᓂᒧᐃ ᐃᔮᐱᑖᔨᒫᑭᓂᐤ᙮ ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᒋᔅᑖᔨᒥᑰ ᐅᐧᐋᐦᑯᒫᑭᓐᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ ᑳ ᐅᐦᒌᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᑖᑆᐦᑎᒥᔨᒡ ᓂᒧᐃ ᐅᐦᒋ ᒌᐦ ᑑᑎᒻ ᒫᒥᔥᑳᒡ ᒑᐧᑳᔨᐤ ᐊᓂᑎᐦ, ᒥᒄ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓯᔨᒡᐦ ᒌ ᑖᐦᒋᓈᐤ, ᒌ ᒦᓂᐧᐋᒋᐦᐋᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ᒌᓴᔅ ᒌ ᑰᔅᐧᑳᔨᒫᐤ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᐋ ᐃᔥᐱᔥ ᐋᑳ ᑖᑆᔮᔨᒥᑯᑦ᙮ ᒌ ᐊᒋᓈᔅᑯᒻ ᒫᒃ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔥ ᐋ ᐱᐹᒋᔅᑯᑎᒫᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ᒌ ᓂᑑᒫᐤ ᐊᓂᔮᔨᐤ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐋᒄ ᑳ ᒋᐦᒋᑎᔑᐦᐧᐋᑦ ᐋ ᓈᓃᔓᐦᑖᔨᒡ᙮ ᒌ ᒥᔮᐤ ᑎᐹᔨᐦᒋᒑᐧᐃᓂᔨᐤ ᒑ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ᒌ ᐄᑎᔓᒫᐤ ᒫᒃ ᐋᑳ ᒥᑐᓐ ᒑᐧᑳᔨᐤ ᒑ ᑎᐧᑳᓂᒥᔨᒡ, ᒥᒄ ᓯᔅᑭᐦᐆᓂᔨᐤ ᒑ ᑎᐧᑳᓂᒥᔨᒡ᙮ ᒌ ᐄᑎᔓᒫᐤ ᐋᑳ ᐧᐋᐧᐋᒡ ᒦᒋᒥᔨᐤ ᒑ ᑎᐧᑳᓂᒥᔨᒡ, ᑭᔮᐦ ᒫᒃ ᓃᒨᑖᓂᔨᐤ ᒑ ᒌ ᐃᔮᔨᒡ ᑭᔮᐦ ᐋᑳ ᐧᐋᐧᐋᒡ ᒑ ᒌ ᓃᒥᔓᔮᓈᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ᒌᐦ ᐄᑖᐤ ᒥᒄ ᐊᓂᔮᔨᐤ ᒥᔅᒋᓐ ᑳ ᒋᒋᔥᑭᒥᔨᒡ ᒑ ᐃᔮᔨᒡ᙮ ᑭᔮᐦ ᐋᑳ ᑯᑎᒋᔨᐤ ᐱᒋᐧᐃᔮᓂᔨᐤ ᒑ ᒌ ᐃᔮᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ᒌᐦ ᐄᑖᐤ ᑭᔮᐦ, “ᐊᓂᑎᐦ ᒑ ᐲᐦᑎᑭᐦᐄᑯᐧᐋᐧᑳ ᐧᐋᔅᑳᐦᐄᑭᓐ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑖᒄ ᐹᑎᔥ ᓂᑭᑎᒫᐧᑳ ᐊᓐ ᐃᐦᑖᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ᐋᑳ ᒫᒃ ᐧᐄᐦ ᐲᐦᑎᑭᐦᐄᑯᔮᐧᑳ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᐧᐄᐦ ᓂᑑᐦᑖᑯᔮᐧᑳ, ᓂᑭᑎᒫᐧᑳ ᐊᓐ ᐃᐦᑖᐧᐃᓐ ᒑ ᐱᐦᐴᓯᑖᔑᒧᔮᒄ᙮ ᐋᐅᒄ ᒑᐦ ᑎᔮᒄ ᐋ ᓅᑯᐦᑖᔮᒄ ᐋ ᐃᔮᐧᑳᒥᒫᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑳ ᓂᑑᑭᒑᔅᒋᒫᒡ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᐧᑳᔅᑳᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐅᐧᐋᐅᒡ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐲᐦᒋᔥᑯᐧᐋᔨᒡ ᐊᐧᐋᔨᐤᐦ ᑭᔮᐦ ᒌ ᑑᒥᓈᐅᒡ ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ, ᒌ ᒦᓂᐧᐋᑎᓰᔨᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᒫᒃ ᒌ ᐹᐦᑎᒻ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ, ᐧᐋᔥ ᒌ ᒥᔑᐦᑖᐱᔨᔨᐤ ᑖᓐ ᑳ ᐄᑖᒋᒫᑭᓅᑦ ᒌᓴᔅ᙮ ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒌ ᐃᔨᐅᒡ, “ᐋᐧᐄᒑ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ, ᒌ ᐧᐃᓂᔥᑳᓈᑭᓂᐧᐄᒑ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᐧᐋᐦᒋ ᐄᐦᑎᒃ ᐅᔮᔨᐤ ᒫᒥᔥᑳᒡ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ᐋᒄ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᑳᐦ ᐃᔨᒡ, “ᐄᓛᐃᒑ ᐆ᙮” ᐋᒄ ᒦᓐ ᑯᑎᑭᒡ ᑳᐦ ᐃᔨᒡ, “ᐋᐅᒄ ᐆ ᐹᔨᒄ ᐅᒋᔅᒋᐧᐋᐦᐄᒑᓯᐤ ᐊᓂᑖᐦ ᐧᐋᔥᑭᒡ ᑳ ᒌ ᒋᔅᒋᐧᐋᐦᐄᒑᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ᐃᔥᑯᑎᒃ ᐱᔮᐦᑎᐦᒃ ᐦᐁᕆᑦ ᒫᒃ ᐅᔮᔨᐤ ᐋᐦ ᐄᓈᓂᐧᐃᔨᒡ ᒌᓴᔅᐦ ᐋ ᑎᐹᒋᒫᑭᓂᐧᐃᒡ ᒌᐦ ᐄᑖᐤ, “ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐆ᙮ ᐋᐅᒄ ᐆ ᑳ ᒋᒥᔅᑎᐧᑳᓈᐦᐆᒃ, ᒦᓐ ᑳᐤ ᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ᐧᐄᔨ ᐦᐁᕆᑦ ᒌ ᐄᑎᔓᐧᐋᒑ ᒑ ᒌ ᐅᑎᓂᒫᑭᓂᐧᐃᔨᒡ ᒞᓐ ᑭᔮᐦ ᒑ ᒌ ᒫᐦᑯᐱᑎᒫᑭᓂᐧᐃᔨᒡ, ᐋᒄ ᒫᒃ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᒑ ᒋᐱᐦᐅᒫᑭᓂᐧᐃᔨᒡ᙮ ᐧᐄᐤᐦ ᐦᐁᐧᕌᑎᔭᔅ ᒌᐦ ᑐᑎᒧᐧᐋᐤ ᐅᔮᔨᐤ ᐧᐋᐦᒌᐦ ᑐᑎᐧᐋᑦ ᒞᓐ᙮ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤᐦ ᐦᐁᐧᕌᑎᔮᔅᐦ ᑳ ᐧᐄᒋᒫᑦ ᐦᐁᕆᑦ ᐧᐄᒋᐄᔨᔨᐤ ᕕᓕᑉᐦ ᐊᓂᔮᔨᐤ ᒌ ᐧᐄᐧᐃᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ᒞᓐ ᒌ ᐄᑖᒑ ᐊᓂᔮᔨᐤ ᐦᐁᕆᑦ, “ᒌ ᐲᑯᓈᓐ ᐧᐄᔓᐧᐋᐧᐃᓐ ᐋ ᐧᐄᐆᑦᐦ ᒌᒋᐄᔨᔨᐤ ᐧᐄᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ᐋᒄ ᐊᓐ ᐦᐁᐧᕌᑎᔭᔅ ᓂᒧᐃ ᐅᐦᒋ ᓂᐦᐄᔅᑳᑰᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᒞᓐᐦ, ᐋᒄ ᑳ ᓂᑎᐧᐋᔨᒫᑦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒌ ᑐᑎᒻ ᐅᔮᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ᐧᐋᔥ ᐦᐁᕆᑦ ᒌ ᑯᔥᑖᐤ ᐊᓂᔮᔨᐤᐦ ᒞᓐᐦ, ᒋᐧᐄᐦ ᒥᓈᒋᐦᐋᐤ ᐋ ᒌ ᒋᔅᒑᔨᒫᑦ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᑭᔮᐦ ᐋ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐅᔮᔨᐤ ᓈᐹᐤ᙮ ᐋᔪᐧᐃᒄ ᒫᒃ ᐅᔮᔨᐤ ᐧᐋᐦᒋ ᐋᑳ ᐅᐦᒋ ᐧᐄᐦ ᐱᒫᔨᒫᑦ᙮ ᒌ ᒥᐧᔮᔨᐦᑎᒻ ᐋ ᓂᑑᐦᑎᐧᐋᑦ ᐋᐦᐋᑦ ᒨᔥ ᒌ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᐧᐋᑦ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᑎᐦᑐ ᐋ ᓂᑑᐦᑎᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ᒑᒃ ᒫᒃ ᒌ ᓂᐦᐄᐱᔨᐤ ᐦᐁᐧᕌᑎᔭᔅ ᒑ ᒌᐦ ᑎᒃ ᑖᓐ ᑳ ᐧᐄᐦ ᑎᒃ᙮ ᐦᐁᕆᑦ ᒌ ᑎᐱᔅᑭᒻ᙮ ᒌ ᓂᑑᒫᐤ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᒫᐅᒡ ᓃᑳᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐋ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐱᑎᓰᔨᒡ᙮ ᒌ ᓂᑑᒫᐤ ᑭᔮᐦ ᓂᑐᐱᔨᐅᒋᒫᐤ, ᑭᔮᐦ ᓈᐹᐤ ᑳ ᐅᒋᒫᐧᐋᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᑎᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ᐊᓂᔮᔨᐤ ᒫᒃ ᐦᐁᐧᕌᑎᔭᔅ ᐅᑖᓂᔅᐦ ᒌ ᐹᒋ ᓃᒥᔨᐤ ᐋᒄ ᓈᔥᒡ ᑳ ᒥᐧᔮᔨᐦᑎᒥᔨᒡ ᐦᐁᕆᑦ ᑭᔮᐦ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᓂᑐᒫᑭᓂᐧᐃᔨᒡ᙮ ᐋᒄ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐃᔅᐧᑳᔥ, “ᐹᒋ ᐧᐄᐦᑎᒨ ᒑᐧᑳᓐ ᒋᐱᐦ ᒥᐧᔮᔨᐦᑖᓐ ᐃᔮᔨᓐ᙮ ᒥᒄ ᒑ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᒨᓈ ᐋᐅᒄ ᐊᓐ ᒑ ᒥᔨᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ᒌᐦ ᐄᑖᐤ ᑭᔮᐦ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒧᐧᐋᑦ ᒑ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᒥᔨᐧᑳᓂᐦᐄ᙮ ᒌᐦ ᐄᑖᐤ, “ᒥᒄ ᒑᐧᑳᓐ ᒑ ᓂᑎᐧᐋᔨᐦᑎᒧᐧᐃᓈ ᒋᑭ ᒥᔨᑎᓐ, ᐋᑎ ᐋᐱᐦᑑ ᐊᓐ ᐊᔅᒌ ᐊᓂᑖᐦ ᐧᐋᒋᒫᐧᐃᔮᓐ ᓂᑎᐧᐋᔨᐦᑎᒫᓈ ᐊᔮᐱᒡ ᒋᑭ ᒥᔨᑎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ᐋᒄ ᑳ ᐧᐃᔨᐧᐄᑦ ᐊᓐ ᐃᔅᐧᑳᔥ ᑳ ᓂᑑᑯᐧᑳᒋᒫᑦ ᐅᑳᐧᐄᐦ ᐋᐦ ᐄᑖᑦ, “ᒑᐧᑳᓐ ᒑ ᓂᑎᐧᐋᔨᐦᑎᒫᓐ᙮” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐅᔥᑎᐧᑳᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ᐋᒄ ᐊᓐ ᐃᔅᐧᑳᔥ ᑏᐧᐋᐦᒡ ᑳ ᐄᔥᐱᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐋᐦ ᑖᔨᒡ ᑳ ᓂᑑᐄᑖᑦ, “ᐊᓅᐦᒡ ᓂᓂᑎᐧᐋᔨᐦᑎᐧᒫᓐ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐅᔥᑎᐧᑳᓐ ᒑ ᒌ ᐹᑖᑭᓂᐧᐃᔨᒡ ᐧᐄᔮᑭᓂᐦᒡ ᐋ ᐊᔅᑖᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ᓄᐧᐃᒡ ᒌ ᒥᒑᔨᐦᑎᒻ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑯᐧᑳᒋᐦᒑᔨᒧᔨᒡ, ᐧᐋᐧᐋᒡ ᐧᐄᔨ ᔖᔥ ᐋ ᒌ ᐄᑖᑦ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒧᐧᐋᑦ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᒥᔨᐧᑳᓂᐦᐄ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᒡ ᐊᓂᑎᐦ ᒫᐧᑳᒡ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ, ᑭᔨᑆ ᓂᒧᐃ ᒋᐧᐄᐦᒋᐧᐋᓂᒻ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐄᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ᑏᐧᐋᐦᒡ ᑳ ᒋᐦᒋᑎᔑᐦᐧᐋᑦ ᐹᔨᒄ ᓂᑐᐱᔨᐤᐦ ᐋ ᒌ ᐄᑎᔓᒫᑦ ᒑ ᒌ ᐹᑖᔨᒡ ᒞᓐᐦ ᐅᔥᑎᐧᑳᓂᔨᐤ᙮ ᐋᒄ ᐊᓐ ᓂᑐᐱᔨᐤᐦ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐊᓂᑖᐦ ᒞᓐᐦ ᑳᐦ ᑖᔨᒡ ᑳ ᓂᑑᒋᒥᔅᑎᐧᑳᓈᐧᔖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ᐧᐄᔮᑭᓂᐦᒡ ᑳ ᐊᔥᑖᐧᐋᑦ ᐊᓂᔮᔨᐤ ᐅᔥᑎᐧᑳᓂᔨᐤ ᐋᒄ ᑳ ᓂᑑᒥᔮᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᐧᑳᔥ, ᐋᒄ ᐊᓐ ᐃᔅᐧᑳᔥ ᐅᑳᐧᐄᐦ ᑳ ᒥᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ᒞᓐ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐄᔥᐱᐦ ᐱᔮᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᒌ ᓂᑎᐧᐋᐱᐦᑎᐧᒫᐧᐃᒡ ᐧᐄᔮᔨᐤ ᐋᒄ ᑳ ᓂᑑᓂᐦᐄᑭᐧᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ᒌᓴᔅ ᐅᑖᑆᔅᑎᓕᒻᐦ ᑳᐦ ᑎᑯᓯᓃᔨᒡ ᐧᐃᔮᐱᒥᑯᑦ ᒌ ᐧᐄᐦᑎᒫᑰ ᒥᓯᐧᐋ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ᓈᔥᒡ ᒫᒃ ᒌ ᒥᐦᒑᑎᔨᐤ ᐊᐧᐋᔨᐤᐦ ᐋ ᑎᑯᔑᓃᔨᒡ ᐋ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑯᒡ ᐋᒄ ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᐅᐦᒋ ᐃᔥᐱᔒᐅᒡ ᒑ ᒌ ᒦᒋᓱᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, “ᐋᔥᑎᒧᒄ ᒥᒄ ᒌᔨᐧᐋᐤ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᑖᓅᐦᒡ, ᒑ ᐋᔨᐧᐋᓯᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ᐋᒄ ᑳᐦ ᐋᔔᐦᐊᐦᒡ, ᐊᓂᑖᐦ ᑳᐦ ᐋᑎ ᐊᓯᒋᒫᒡ ᐋᐦᐋᑳ ᑖᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ᒥᐦᒑᑐ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᒌ ᐧᐋᐱᒥᑯᒡ ᑭᔮᐦ ᑏᐧᐋᐦᒡ ᒌ ᓂᔅᑑᓈᑯᒡ ᑳ ᐧᐋᐱᒥᑯᒡ᙮ ᓂᓈᐦᑭᐤ ᒫᒃ ᐃᐦᑖᐧᐃᓂᐦᒡ ᒌ ᐅᐦᒋᐱᐦᐄᑑᒡ ᐋ ᐧᐄᐦ ᐅᑎᐦᑎᐦᒡ ᐊᓂᑖᐦ ᑳ ᐧᐄᐦ ᐃᔅᒋᒫᔨᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᔨᐤᐦ᙮ ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᒋᐧᐄᐦ ᐋᑎᔥᑭᐧᐋᐅᒡ ᓈᑖᐦ ᒑ ᓈᑎᑳᒫᐦᐋᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳᐹᑦ ᐊᓂᔮᔨᐤ ᒌᒫᓂᓯᔨᐤ ᒌ ᐧᐋᐱᒫᐤ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒨᔑᐦᑖᐤ ᐋ ᒋᔅᑎᒫᒑᔨᒫᑦ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐋᐦᐋᑳ ᐃᔮᐧᐋᒡ ᒫᓂᔥᒑᓂᔓᐧᐄᔨᔨᐤ ᒑ ᓈᓈᑭᒋᐦᐄᑯᒡ ᐋ ᐃᓯᓈᑯᓰᔨᒡ᙮ ᐋᒄ ᑳ ᒋᔅᑯᑎᒧᐧᐋᑦ ᒥᐦᒑᑐ ᒑᐧᑳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒌ ᓈᑖᐅᒡ ᒌᓴᔅ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᔖᔥ ᒋᐦᒋᐧᐋ ᐅᑖᑯᔑᐤ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᑎᑯᓐ ᐃᐦᑖᐧᐃᓐ ᐅᑎᐦ ᐆ ᐋᐦ ᑖᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ᒋᐦᒋᑎᔑᐦᐅᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᓂᑑᐅᑎᓂᐦᒡ ᒑᐧᑳᔨᐤ ᒑ ᒦᒋᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓐ ᐹᔓᒡ ᐅᑎᐦ ᐧᐋᔅᑳ ᑳᐦ ᑎᑯᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒌᔨᐧᐋᐤ ᒥᔮᐦᑯᒡ ᒑᐧᑳᔨᐤ ᒑ ᒦᒋᒡ᙮” ᑳ ᑯᐧᑳᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᓃᔮᓐ ᐋ ᒌ ᓂᑎᐧᐋᔨᒥᓈᓐ ᓃᐧᔖᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᔔᐧᐃᔮᓈᐱᔅᑯᔑᒡ ᒑ ᒌ ᐃᔥᐱᔥ ᐋᐱᒋᐦᐄᒋᐦᒡ ᐋ ᐅᑎᓂᒋᐦᑦ ᐋᐃᐦᑯᓈᐤ ᒑ ᒌ ᒦᒋᓱᒡ ᐅᒌ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᐃᔮᐧᐋᒄ ᐋᐃᐦᑯᓈᐤ᙮ ᒫᒌᒄ ᓂᑑᒋᔅᒑᔨᐦᑎᒧᒄ᙮” ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᑑᒋᔅᒑᔨᐦᑎᐦᒡ ᐋᒄ ᑳ ᓂᑑᐧᐄᐦᑎᒧᐧᐋᒡ ᒌᓴᔅᐦ, “ᓂᔮᔫᒡ ᐋᐃᐦᑯᓈᐆᒡ ᑭᔮᐦ ᓃᔓ ᓂᒫᓯᒡ ᑖᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ᐋᒄ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒑ ᒌᐦ ᐄᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᒥᒫᓂᐱᔨᒡ ᐊᓂᑎᐦ ᒥᔥᑯᔒᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ᑳᐦ ᐋᑎ ᐅᐧᐋᔨᐱᐦᐄᓱᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᐋ ᒫᒥᑖᐦᑐᒥᑎᓈᐧᐋᐱᒡ ᑭᔮᐦ ᐋ ᓈᓂᔮᔫᒥᑎᓈᐧᐋᐱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓃᔓ ᓂᒫᔅ, ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᔑ ᐄᑖᐱᑦ ᐋ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᒌ ᐱᐦᐱᐦᐧᑳᓂᐤ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑳ ᒥᔮᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒑ ᒌ ᒫᑎᓂᐧᐋᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓃᔓ ᓂᒫᔅ ᒌ ᒫᑎᓂᒧᐧᐋᐤ ᒑ ᒌ ᒫᑎᓂᒧᐧᐋᔨᒡ ᒥᓯᐧᐋ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᒦᒋᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ᒥᓯᐧᐋ ᒫᒃ ᐊᐧᐋᓐ ᒌ ᒦᒋᓲ ᑭᔮᐦ ᒌ ᑖᐱᔥᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑳ ᒫᒨᔑᒋᓂᐦᒡ ᐃᔥᑯᔥᑐᐧᐋᓂᔨᐤ᙮ ᓃᔓᔖᑉ ᒫᒃ ᐅᑎᐲᐧᐃᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᐊᔅᑯᐳᒫᑭᓂᐧᐃᔨᒡ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᓂᒫᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ᓂᔮᐧᔮᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒫᒃ ᒌ ᐄᑎᓯᑖᐧᐋᑯᐱᓐ ᓈᐹᐅᒡ ᑳ ᐊᔑᒫᑭᓂᐧᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ᒌᓴᔅ ᒫᒃ ᑏᐧᐋᐦᒡ ᒌ ᐄᑎᔓᒫᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒑ ᒌ ᐴᓰᔨᒡ, ᓃᑳᓐ ᒑ ᒌ ᐃᔅᒋᒫᔨᒡ ᓈᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐊᑳᒥᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ, ᐱᕪᓭᐃᑖ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᐧᐄᔨ, ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒑ ᒌᐧᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐧᐋᒋᔮᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᒄ ᐋ ᐱᔅᐧᑳᐱᔅᑳᔨᒡ ᑳ ᔖᑭᒋᐧᐋᑦ ᒌᓴᔅ, ᑳ ᓂᑐᐊᔨᒥᐦᐋᑦ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᒫᒃ ᑖᑖᐅᑎᑳᒻ ᒌᐦ ᑖᐅᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ᙮ ᒫᐧᑳᒡ ᒌᓴᔅ ᐋ ᐹᔨᑯᓯᑦ ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ᒌ ᐧᐋᐱᒫᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᓈᔥᒡ ᓲᐦᒃ ᐋ ᐱᒥᔅᑳᔨᒡ, ᐧᐋᔥ ᒌ ᓂᑳᔮᓯᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐋᔥᒄ ᐋ ᑎᐱᔅᑳᔑᔨᒡ ᐧᐃᔮᔥ ᒋᔅᑑᒡ ᓂᔥᑐ ᑭᔮᐦ ᑯᐧᑖᔥᒡ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᒌᓴᔅ ᒌ ᓈᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᑦ᙮ ᒋᐱᐦ ᒌ ᐋᑎ ᒥᔮᔅᑯᐧᐋᐤ ᑭᔨᑆ, ");
INSERT INTO crl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ᒥᒄ ᒫᒃ ᒌ ᐧᐋᐱᒥᑰ ᐊᓂᑎᐦ ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᑦ᙮ “ᒌᐲ” ᒌ ᐄᑖᔨᒥᑰ ᐋᒄ ᑳᐦ ᐋᔑᐦᐧᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ᒥᓯᐧᐋ ᒌ ᓵᒋᓯᐧᐃᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᐄᔥᐱᐦ ᐧᐃᔮᐱᒫᒡ ᒌᓴᔅᐦ᙮ ᒌᓴᔅ ᒫᒃ ᑏᐧᐋᐦᒡ ᒌ ᐊᔨᒥᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᔮᒫᔨᐦᑎᒧᒄ, ᐋᐅᒄ ᐧᐋᔥ ᐆ ᓃᔨ᙮ ᐊᑳᐧᐄ ᑯᔥᑖᒋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ᑳ ᐴᓯᑎᐧᐋᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐴᓯᑎᐧᐋᑦ ᐋᔪᐧᐃᒄ ᑏᐧᐋᐦᒡ ᑳᐦ ᐋᑎ ᔮᐦᔮᒋᔥᑎᓃᔨᒡ᙮ ᓄᐧᐃᒡ ᒫᒃ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ᐧᐋᔥ ᑖᐹ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ ᑖᓐ ᐋ ᐄᔑ ᐧᐄᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑳ ᐊᔑᒫᑭᓂᐧᐃᔨᒡ ᓂᔮᐧᔮᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐄᔨᔨᐤ᙮ ᓂᒧᐃ ᐅᐦᒌ ᓂᔅᑐᐦᑎᒧᒡ ᐧᐋᔥ ᐋ ᒌ ᒥᔅᑰᑖᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ᒌ ᑎᔅᑭᒧᐦᐋᒧᒡ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ ᒑᒃ ᑳ ᒥᓯᑳᒡ ᓈᑖᐦ ᑫᓀᓯᕃᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᑳ ᒫᐦᑯᐱᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐅᒌᒫᓂᓯᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ᐋᐦ ᐋᑎ ᓂᑭᑎᐦᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᒌᒫᓂᓯᐧᐋᐤ ᑏᐧᐋᐦᒡ ᒌ ᓂᔅᑑᓈᑰ ᒌᓴᔅ ᐊᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒥᓯᐧᐋ ᐊᓂᑖᐦ ᑳ ᐊᐄᔥᐱᐦᐄᑐᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐋ ᐃᔥᐱᔖᔨᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐧᐃᔨᐧᐄᑎᒫ ᐋ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᒡ ᐊᐧᐋᔨᐤᐦ ᑖᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ᙮ ᒥᒄ ᑖᓂᑖᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᐄᐦᑖᔨᒡ ᒌᓴᔅᐦ ᐋᑯᑖᐦ ᑳ ᐹᔓᐧᐋᒡ ᑳᐦ ᐊᑯᓰᔨᒡ ᑖᐦᑎᐦᓂᑭᓂᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ᒥᓯᐧᐋ ᒫᒃ ᑖᓂᑖᐦ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᑦ ᒌᓴᔅ ᐃᐦᑖᐧᐃᓂᐦᒡ ᑭᔮᐦ ᒋᔖᐃᐦᑖᐧᐃᓂᐦᒡ, ᑭᔮᐦ ᒫᒃ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᓂᑖᐦ ᒨᔥ ᑳ ᒌ ᓂᔥᑐᐧᐄᓈᓂᐧᐃᔨᒡ ᐋ ᐊᑖᒥᑐᓈᓂᐧᐃᔨᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᑳ ᓂᑐᑎᒧᐧᐋᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᐱᒋᔅᑎᓂᑯᒡ ᒥᑯᒋᒃ ᒑ ᒌ ᑖᐦᒋᓂᐧᒫᒡ ᐋ ᐧᐃᓂᔥᐧᑳᑭᓃᔨᒡ ᐅᑎᑯᐦᐱᔨᐤ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᑖᐦᒋᓂᒥᔨᒡ ᐅᑎᑯᐦᑉ ᒌ ᒦᓂᐧᐋᑎᓰᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ᐱᔅᒡ ᐹᕆᓰᒡ ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐅᐦᑐᐦᑖᒡ ᒌ ᐹᒋ ᒫᐅᔓᑯᑳᐳᐧᐃᒡ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ᓈᔥᒡ ᒌ ᒌᐦᑳᔮᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᑳᓰᑎᐦᒑᔨᒡ ᐋᐧᒫᔮ ᒦᒋᓱᔨᒡ ᐋᓂᔮᔨᐤ ᐧᐄᔨ ᐧᐋᔥ ᓂᑎᐧᐋᐦᐄᑖᑰᐦᒡ ᐊᓂᑎᐦ ᒎᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ᐧᐋᔥ ᐹᕆᓰᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᒎᐤ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᔮᐧᑳᐦ ᒌ ᓂᓈᑭᑎᐧᐋᔨᐦᑎᒧᒡ ᒑ ᒌ ᑐᑎᐦᒡ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ ᑖᓐ ᑳ ᒌ ᐹᒋ ᑐᑎᒥᔨᒡ ᐊᓂᔮᐦᑳ ᐅᐦᑖᐧᐄᐧᐋᐤ᙮ ᓂᒧᐃ ᐅᐦᒋ ᒦᒋᓯᐧᐃᒡ ᐹᑎᔥ ᑳᐦ ᑐᑎᐧᑳᐤ ᐊᓂᔮᔨᐤ ᒑ ᑐᑎᒧᐧᐋᑯᐱᓈ ᐋ ᒋᔥᑖᐹᐅᑖᒡ ᐅᑎᐦᒌᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ᓂᒧᐃ ᑭᔮᐦ ᐅᐦᒋ ᒦᒋᐧᐃᒡ ᒑᐧᑳᔨᐤ ᐊᓂᑖᐦ ᐋ ᐊᑖᒥᑐᓈᓂᐧᐃᔨᒡ ᐋ ᒌ ᐅᐦᑎᓂᑭᓂᐧᐃᔨᒡ ᐹᑎᔥ ᑳ ᒋᔥᑖᐹᐅᑖᐧᑖᐤ᙮ ᓂᓈᐦᑭᐤ ᑭᔮᐦ ᑎᑯᓂᔨᐤ ᑯᑎᒃ ᐄᑎᔓᐧᐋᐧᐃᓐ ᐋ ᓈᓈᑭᒋᐦᑖᒡ ᒑ ᒌ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᔮᑭᓂᐧᐃᔨᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐦᒡ, ᐧᒫᐦᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᓂᐦᐋᐤ ᒑ ᑎᐧᐋᑯᐱᓈ ᐋ ᒋᔥᑖᐹᐅᑖᒡ ᐅᒥᓂᐦᐧᑳᑭᓂᐧᐋᐤ ᑭᔮᐦ ᐧᐃᔮᑭᓂᐧᐋᐤ᙮ ᑭᔮᐦ ᒫᒃ ᑖᓐ ᒋᐱᐦ ᑑᐧᐃᒡ ᐋ ᒋᔥᑖᐹᐧᐊᑖᒡ ᐅᑎᔅᒋᐦᑯᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᑳ ᑯᐧᑳᒋᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᐅᒌ ᒫᐦ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ, ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐋᑳ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐹᒋ ᐋᔔ ᓈᓈᑭᒋᐦᑖᒡ ᑰᐦᑖᐧᐄᓅᒡ ᒑ ᒌ ᐄᔑ ᓈᓈᑭᒋᐦᑖᑭᓂᐧᐃᔨᒡ᙮ ᒥᒄ ᐄᔑ ᒦᒋᓯᐧᐃᒡ ᐋᐦᐋᑳ ᐧᐋᐧᐋᒡ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᒑ ᑐᑎᒧᐧᐋᑯᐱᓈ ᐱᑎᒫ ᐋ ᒋᔥᑖᐹᐅᑖᒡ ᐅᑎᐦᒌᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒌ ᑖᑆᑖᑯᐱᓐ ᐊᓂᔮ ᒋᔅᒌᐧᐋᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᒌᔨᐧᐋᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ ᑳ ᐄᑎᓯᓂᐦᐋᒧᑯᐱᓈ ᒋᔖᒥᓂᑑ ᑳᐦ ᐄᑎᑯᑦ, ᐅᒌ ᐄᔨᔨᐅᒡ ᐅᑑᓂᐧᐋᐦᒡ ᓅᐦᒋ ᒋᔅᑖᒋᒥᑯᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᓂᑎᔮᐱᑖᔨᒥᑯᒡ ᐅᑖᐦᐄᐧᐋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ᓂᒧᐃ ᐋᐱᑎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᐹᒋ ᐊᔨᒥᐦᐋᔥᑎᐧᐃᒡ ᐧᐋᔥ ᐧᐄᔨᐧᐋᐤ ᐅᐧᐄᔓᐧᐋᐧᐃᓂᐧᐋᐤ ᒋᔅᑯᑎᒫᒑᐅᒡ᙮ ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳ ᐄᑎᓯᓈᐦᒃ ᐊᓂᔮ ᐋᐃᓵᔮ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᒫᒃ ᐋᐦ ᑎᔮᒄ ᒌᔨᐧᐋᐤ᙮ ᓂᒧᐃ ᒋᑎ ᐃᔮᐱᑖᔨᐦᑎᐧᒫᓈᐧᐋᐤ ᑖᓐ ᐋᑎᔓᐧᐋᑦ ᒋᔖᒥᓂᑑ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᓈᐹᐤ ᐋᐅᒄ ᐊᓐ ᑎᔨᑯᒡ ᓂᓂᐦᐄᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ᒌ ᐋᑎ ᐄᑖᐤ ᒦᓐ ᒌᓴᔅ, “ᑖᑆᐦ ᒋᑭᔅᒋᐦᐅᓈᐧᐋᐤ ᐊᓐ ᐋᐃᐦᑎᔮᒄ ᐋᐦᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᐧᒫᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐄᑎᔓᐧᐋᑦ ᒋᔖᒥᓂᑑ, ᒌᔨᐧᐋᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᒄ ᐋᐅᒄ ᑎᔨᑯᒡ ᒑ ᒌ ᒋᔅᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ᐧᐋᔥ ᒌ ᐃᔨᐤ ᐊᓂᔮ ᒧᓱᔅ, ᒋᔅᑖᔨᒻ ᑰᐦᑖᐧᐄ ᑭᔮᐦ ᒋᑳᐧᐄ ᑭᔮᐦ ᒌ ᐄᑎᔑᐦᐧᐋᐤ, ᐊᓐ ᐊᐧᐋᓐ ᒑ ᒫᔮᔨᒫᐧᑳ ᐅᐦᑖᐧᐄᐦ ᒫᒃ ᐅᑳᐧᐄᐦ ᒋᑭ ᓂᐱᐦᐋᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ᐋᒄ ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ ᒌᓴᔅ, “ᒌᔨᐧᐋᐤ ᒫᒃ ᒋᑎ ᐄᔑ ᒋᔅᑯᑎᒫᒑᓈᐧᐋᐤ ᐋᐦᐋᑳ ᐧᐃᓂᑐᑎᒃ ᐊᐧᐋᓐ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᓈᑎᒧᐧᐋᑦ ᐅᓃᒋᐦᐄᒄᐦ ᐧᐋᔥ ᒫᒃ ᐄᑖᒑ, ‘ᓂᒥᐦᒋᔨᐧᐋᓯᓐ, ᑖᐹ ᒋᒌ ᐧᐄᒋᐦᐄᑎᓈᐧᐋᐤ ᐧᐋᔥ ᔖᔥ ᒋᔖᒥᓂᑑ ᓂᒌᒥᔮᐤ ᑖᓐ ᒋᐱᐦ ᒌ ᐄᔑ ᒥᔨᑎᓈᐧᐋᐤ ᒌᔨᐧᐋᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ᓂᒧᐃ ᐧᐃᓂᑐᑎᒻ ᒋᑎᐄᑖᐧᐋᐤ ᐅᔮᔨᐤ ᐋᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ᐆ ᒫᒃ ᐋ ᐄᔑ ᐋᔔ ᒋᔅᑯᑎᒫᒑᔮᒄ ᓂᒥ ᒋᑎᐦᑎᐧᒫᓈᐧᐋᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐧᐃᓐᐦ᙮ ᑎᑯᓐ ᒫᒃ ᒥᐦᒑᑐ ᑯᑎᒡ ᒑᐧᑳᓐ ᐋᐃᐦᑎᔮᒄ ᐋᐦᐋᑳ ᑯᐃᔅᒄ ᐃᓯᓈᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᒑ ᐹᒋ ᐄᑐᐦᑖᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᑐᐦᑎᐧᐃᒄ ᒫᐦ, ᒥᓯᐧᐋ ᐋ ᑎᔑᔮᒄ, ᑭᔮᐦ ᐧᐄᐦ ᓂᔅᑐᐦᑑᒄ ᑖᓐ ᒑ ᐃᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ᓂᒧᐃ ᐧᐄᔨ ᒑᐧᑳᔨᐤ ᐋ ᒦᒋᑦ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᓂᐦᐧᑳᑦ ᐊᐧᐋᓐ ᑭᑎ ᒌ ᑐᑖᑰ ᒑ ᒌ ᒥᒌᐦᑐᑎᒃ᙮ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐋᔨᒥᑦ ᑭᔮᐦ ᒫᒃ ᐋ ᐄᔑ ᒥᒋᒫᒥᑐᓈᔨᐦᑎᐦᒃ ᐋᔪᐧᐃᒄ ᐊᓂᔮᔨᐤ ᒑ ᑐᑖᑯᑦ ᒑ ᒌ ᒥᒌᐦᑐᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ᐄᔅᑉ ᒫᒃ ᐊᐧᐋᓐ ᐱᔮᐦᑎᒧᐧᑳ ᐋᑯᔥ ᑭᑎ ᓂᑐᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ᐄᔥᐱᐦ ᒫᒃ ᓈᑭᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᒫᐅᓯᑯᑳᐳᔥᑖᑯᑦ ᒌ ᐲᐦᒑᐤ ᐊᓂᑎᐦ ᐧᐋᔅᑳᐦᐄᑭᓂᐦᒡ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᑳ ᑯᐧᑳᒋᒥᑯᑦ ᒑ ᒌ ᐧᐄᐦᑎᒧᐧᐋᑦ ᑖᓐ ᐋ ᐄᔑ ᐧᐄᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᓂᒧᐃ ᐋ ᒋᓂᔅᑐᐦᑖᓈᐧᐋᐤ ᑭᔮᐦ ᒌᔨᐧᐋᐤ? ᓂᒧᐃ ᐋ ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᑖᐹ ᓂᒥᔮᔨᐤ ᒦᒋᒥᔨᐤ ᑳᐦ ᑐᑖᑯᑦ ᐊᐧᐋᓐ ᐧᐋᐦᒋ ᒥᒌᐦᑐᑎᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ᐧᐋᔥ ᑖᐹ ᐅᑖᐦᐄᐦᒡ ᐲᐦᒋᐱᔨᐤ ᐊᓂᔮᔨᐤ ᒦᒋᒥᔨᐤ, ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᐋᑯᑖᐦ ᐋ ᐃᔅᐱᔨᒡ, ᐋᒄ ᒫᒃ ᐧᐋᔨᐧᐄᐱᔨᐦᑖᑦ᙮” ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᒌ ᐧᐄᐦᑎᒻ ᒥᓯᐧᐋ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒦᒋᒥᔨᐤ ᐋ ᐱᔮᐦᑭᓃᔨᒡ ᒑ ᒌ ᒦᒋᓈᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ᒌᓴᔅ ᑭᔮᐦ ᒌᐦ ᐄᑖᐤ, “ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐊᔮᑦ ᐊᐧᐋᓐ ᐅᑖᐦᐄᐦᒡ ᐋᔪᐧᐃᒄ ᐊᓂᔮᔨᐤ ᒑ ᑐᑖᑯᑦ ᒑ ᒌ ᒥᒌᐦᑐᑎᐦᒃ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒥᒋᐋᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ᐧᐋᔥ ᐊᓂᑖᐦ ᐅᑖᐦᐄᐦᒡ ᐊᐧᐋᓐ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᓈᔥᒡ ᓂᑎᐧᐄ ᒑ ᒌ ᐄᑖᔨᐦᑎᐦᒃ ᑭᔮᐦ ᓂᑎᐧᐄ ᒑ ᒌᐦ ᑎᒃ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᑭᒑᒧᑎᑦ, ᒑ ᒌ ᓂᐱᐦᐄᐧᐋᑦ, ");
INSERT INTO crl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ᑭᔮᐦ ᒫᒃ ᒑ ᐱᓯᐧᑳᑎᓰᑦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒧᔥᑖᓈᔨᐦᑎᒧᐧᐋᑦ ᐊᐧᐋᔨᐤ ᒑᐧᑳᔨᐤ ᐋ ᐄᔑ ᐃᔮᔨᒡ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒥᒋᐦᐧᑖᑦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᑳᒌᔑᐦᐄᐧᐋᑦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐧᐄᓂᔑᐧᐋᑎᓰᑦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᑖᔨᐦᑎᐦᒃ, ᑭᔮᐦ ᒑ ᔅᐯᓪ ᒥᒋᐋᔨᒨᒫᑦ ᐊᐧᐋᔨᐤᐦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒋᔅᑖᔨᒧᑦ, ᑭᔮᐦ ᒑ ᒌ ᒌᔥᐧᑳᐤ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ᒥᓯᐧᐋ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᒥᒌᐦᑐᑎᐦᒃ ᐊᐧᐋᓐ ᐲᐦᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ ᐋᔪᐧᐃᒄ ᒫᒃ ᐅᔮᔨᐤ ᒫᒋᓈᑯᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑐᐦᑖᐤ᙮ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐹᔓᒡ ᓵᐃᑎᓐ ᑭᔮᐦ ᑖᐊᕋ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᑦ᙮ ᑖᑯᔑᐦᒃ ᒫᒃ ᒌ ᐲᐦᒑᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᐋᒄ ᑳᐦ ᐄᑎᔓᐧᐋᑦ ᐋᑳ ᒑ ᒌ ᐧᐄᐦᑎᒧᐧᐋᑭᓂᐧᐃᔨᒡ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓈᐅᔥ ᐅᐦᒌ ᐃᓯᓈᑯᓂᔨᐤ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ᒌᐦ ᑖᔨᐤ ᐃᔅᐧᑳᐤ ᐋ ᒌ ᐹᐦᑎᒥᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐋᒄ ᑏᐧᐋᐦᒡ ᑳ ᓂᑎᐧᐋᐱᒥᑯᑦ ᐋ ᐹᒋ ᐱᐦᒋᔑᒧᐱᔨᐦᐅᔨᒡ ᐊᓂᑖᐦ ᐅᓯᑎᐦᒡ ᐄᔑ᙮ ᐧᐋᔥ ᐆ ᐃᔅᐧᑳᐤ ᒌᐦ ᑖᔨᐤ ᐅᑖᓂᔅᐦ ᐋ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ᐆ ᒫᒃ ᐃᔅᐧᑳᐤ ᒃᕇᒃ ᒌ ᐄᑎᔅᑳᓈᓲ, ᐊᓂᑖᐦ ᐧᕚᓃᓰᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐊᓂᑖᐦ ᐄᑖᐦᒑ ᓯᕆᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᒌ ᐱᒫᑎᓰᒑ᙮ ᓈᔥᒡ ᒌ ᐋᔨᐦᑭᒥᒫᐤ ᐋ ᓂᑐᑎᒧᐧᐋᑦ ᒌᓴᔅᐦ ᒑ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᔨᒡ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᐅᑖᓂᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᓃᔥᑎᒻ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᓂᐱᐦ ᐧᐄᒋᐦᐋᐅᒡ᙮ ᓂᒧᐃ ᑯᐃᔅᒄ ᐃᓯᓈᑯᓐ ᐊᑎᒧᒡ ᒑ ᒌ ᐧᐋᐱᓂᒫᒡ ᐊᐧᐋᔑᔥ ᐅᒦᒋᒥᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓐ ᐃᔅᐧᑳᐤ, “ᐋᐦᐋ, ᒌ ᑖᑆᓐ, ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᐊᓂᒌ ᐊᑎᒧᒡ ᔒᐹ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ ᑳᐦ ᑖᒡ ᒫᒨᔑᑭᐦᑎᐧᒫᐧᐃᒡ ᑖᓐ ᐋ ᐄᔑ ᐱᓂᐦᑎᐧᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐧᐋᔑᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᐋ ᒌ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᐄᐧᐋᔨᓐ, ᒫᒌᐦ, ᓂᒧᐃ ᔖᔥ ᐲᐦᒋᔥᑳᑰ ᒋᑖᓂᔅ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ᒌ ᒌᐧᐋᐤ ᒫᒃ ᐊᓐ ᐃᔅᐧᑳᐤ ᑳ ᐧᐋᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐅᑖᓂᔅᐦ ᐅᓂᐹᐧᐃᓃᔨᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ, ᑖᑆᐦ ᐋ ᒌ ᓂᑭᑎᑯᔨᑯᐱᓈᓂᐦᐄ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑐᐦᑖᐤ ᐊᓂᑎᐦ ᑖᐊᕋᐦᒡ ᐅᐦᒋ᙮ ᐄᔥᐱᐦ ᐧᐋᑎᐦᑎᐦᒃ ᓵᐃᑎᓐ ᐃᐦᑖᐧᐃᓂᔨᐤ ᒥᒄ ᒌ ᐄᔑ ᔖᐳᐦᑎᐧᐋᔥᑭᒻ᙮ ᐋᒄ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᒥᑖᐦᑐ ᐃᐦᑖᐧᐃᓐ ᑳᐦ ᑎᑯᓃᔨᒡ ᑳ ᐄᔑ ᐱᒧᐦᑖᑦ, ᒑᒃ ᑳ ᐅᑎᐦᑎᐦᒃ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᐊᐧᐋᔨᐤᐦ ᐋ ᐹᐧᑖᑯᑦ ᓈᐹᐤ ᐋᐦᐋᑳ ᐹᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᑖᑎᔅᑉ ᓂᐦᑖᐧᐋᔨᒡ᙮ ᓲᐦᒃ ᒫᒃ ᒌ ᔒᐦᒋᒫᐅᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᑖᐦᒋᓈᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᒥᒄ ᐧᐄᔨᐧᐋᐤ ᒑ ᒌ ᓃᔑᒡ, ᐋᒄ ᑳ ᐴᐦᒋᔥᑑᑭᔮᐦᓈᑦ, ᑭᔮᐦ ᒌ ᔑᐦᑰ ᐋᒄ ᑳ ᑖᐦᒋᓂᐧᒫᑦ ᐅᑖᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ᐃᔥᐱᒥᐦᒡ ᒫᒃ ᒌ ᐄᔑ ᐄᑖᐱᑦ ᒌᓴᔅ ᐋ ᔨᐦᑭᑖᒧᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᐋᕝᕙᕦ᙮” ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᑦ, “ᐋᐱᐦᐄᐲᐦ, ᐄᔑ ᐄᐧᑖᔥᑎᒧᐧᐋᑖᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","ᑏᐧᐋᐦᒡ ᒌ ᐋᐱᐦᐄᐱᔨᐤ ᐅᐦᑎᐧᐃᑮ ᐊᓐ ᓈᐹᐤ᙮ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑖᔨᔨ ᑳᐦ ᐋᐱᐦᑯᐱᔨᒡ ᐋᒄ ᓈᔥᒡ ᑳ ᐅᐦᒋ ᒥᔪ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑎᔓᒫᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, ᒑᐦ ᐋᑳ ᐧᐄᐦᑎᒧᐧᐋᔨᒡ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔅᐱᔨᒡ᙮ ᒥᒄ ᒫᒃ ᐋᐦᐋᑦ ᓲᐦᒃ ᒌ ᒋᔅᑎᐦᐋᒧᐧᐋᑦ ᒌᓴᔅ ᐋᐦᒡ ᐊᑎᑎᐤ ᒌ ᐱᐹᒫᒋᒧᔨᐤ ᐋ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᔨᒡ ᐊᐧᐋᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ᒥᓯᐧᐋ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᐹᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᔨᐤ᙮ ᒌ ᐄᔨᔨᐤ ᒫᒃ, “ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᒌ ᒥᔪᑐᑎᒻ᙮ ᐧᐋᐧᐋᒡ ᒌ ᑐᑎᐧᐋᐤ ᐋᑳ ᑳ ᐹᐦᑎᒥᔨᒡ ᒑ ᒌ ᐹᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᓂᐦᑖᐧᐋᔨᒡ ᒑ ᒌ ᓂᐦᑖᐧᐋᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ᓂᒧᐃ ᓈᐅᔥ ᐊᓂᑖᐦ ᐄᔑ ᐋᒄ ᒦᓐ ᐋ ᒫᒨ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᑳ ᐹᒋ ᓂᔥᑐᐧᐄᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐋᑳ ᐊᑎᑯᓃᔨᒡ ᒑᐧᑳᔨᐤ ᒑ ᒦᒋᒡ ᒌᓴᔅ ᒌ ᓂᑑᒫᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ᓂᒋᔅᑎᒫᒑᔨᒫᐅᒡ ᐅᒌ ᐄᔨᔨᐅᒡ᙮ ᔖᔥ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔒ ᑖᒡ ᐅᑎᐦ ᐋᐦᑖᐅᒡ, ᓂᒧᐃ ᒫᒃ ᔖᔥ ᑎᑯᓂᔨᐤ ᒑᐧᑳᔨᐤ ᒑ ᒦᒋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ᒌᐧᐋᑎᔑᐦᐆᐧᑳᐧᐋ ᐋᐦᐋᑳ ᐧᐋᐧᐋᒡ ᐊᔑᒥᒡ ᑭᑎ ᐃᓯᓈᑯᓂᔨᐤ ᒑ ᒌ ᐹᐅᓂᐦᒡ ᒫᐧᑳᒡ ᐋ ᐱᒧᐦᑖᒡ ᐧᐋᔥ ᐱᔅᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᐧᐋᐦᔨᐤ ᒌ ᐅᐦᑐᐦᑖᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ᐋᒄ ᑳ ᑯᐧᑳᒋᒥᑯᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, “ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᑎᓂᐦᒃ ᐊᐧᐋᓐ ᒦᒋᒥᔨᐤ ᐅᑎᐦ ᐱᐧᑳᑎᔅᑭᒥᑳᒡ ᒥᓯᐧᐋ ᐅᒌ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐊᔑᒫᑭᓂᐧᐃᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᓐ ᑎᐦᑐ ᐋᐃᐦᑯᓈᐆᒡ ᐋᔮᐧᐋᑯᒡ?” “ᓃᐧᔖᔥᒡ ᐄᑎᔓᒡ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᐧᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐅᐧᐋᔨᐱᐦᐄᓱᔨᒡ ᐊᓂᑎᐦ ᒧᔥᑎᔅᑭᒥᒡ᙮ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᓃᐧᔖᔥᒡ ᐋᐃᐦᑯᓈᐤ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ, ᐋᒄ ᑳ ᐱᐦᐧᑳᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᑳ ᒫᒥᔮᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒑ ᒌ ᒫᑎᓂᐧᐋᔨᒡ᙮ ᐋᔪᐧᐃᒄ ᒫᒃ ᑳᐦ ᑎᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ᒌ ᐃᔮᐧᐋᐅᒡ ᐋᔨᐤᐦ ᓂᒫᔅ ᐋ ᐃᔮᐱᔒᔑᔨᒡ, ᓂᒧᐃ ᐅᐦᒋ ᒥᐦᒑᑎᔨᐤ᙮ ᒌᓴᔅ ᒌ ᓂᓈᔅᑯᒨ ᐋ ᐃᔮᐧᐋᒡ ᐅᔮᔨᐤ ᓂᒫᔅ ᐋᒄ ᑳᐦ ᐄᑎᔓᐧᐋᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒑ ᒌ ᒫᑎᓂᐧᐋᔨᒡ ᑭᔮᐦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ᒥᓯᐧᐋ ᑳᐦ ᑎᔑᒡ ᒌ ᒦᒋᓯᐧᐃᒡ ᑭᔮᐦ ᒌ ᑖᐱᔥᑯᔨᐧᐃᒡ᙮ ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑳ ᒫᒨᔑᒋᓂᐦᒡ ᐊᓂᔮᔨᐤ ᐊᔅᑯᔥᑎᐧᐋᓂᔨᐤ᙮ ᓃᐧᔖᔥᒡ ᒫᒃ ᐅᑎᐲᐧᐃᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐊᔅᑯᔥᑎᐧᐋᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ᐧᐃᔮᔥ ᒫᒃ ᓈᐧᐋᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᑎᔑᓈᓂᐧᐃᔨᐤ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒥᓯᐧᐋ ᒑ ᒌᐧᐋᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐋᑎ ᒌᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᓈᑖᐦ ᑎᓪᒫᓄᐦᑖᐦᒡ ᐋᔅᒋᐦᒡ ᑳ ᐊᔅᒋᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ᒌᐦ ᑖᐅᒡ ᐱᔅᒡ ᐹᕆᓰᒡ ᐋ ᐹᒋ ᓂᑎᐧᐋᐱᒫᒡ ᒌᓴᔅᐦ ᐋ ᐧᐄᐦ ᑯᐧᑳᒋᐦᐋᒡ᙮ ᒌ ᓂᑎᐧᐋᔨᒫᐆᒡ ᒑ ᒌ ᐧᐋᐱᐦᑎᔨᑯᒡ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓂᔨᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒌᒥᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ᒌᓴᔅ ᒫᒃ ᒌ ᐄᐦᑭᑖᒨ ᐅᑎᐦᒑᐦᑯᐦᒡ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᓂᑎᐧᐋᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᑳᔑᑳᔨᒡ ᒑ ᒌ ᐧᐋᐱᐦᑎᔮᑭᓂᐧᐃᔨᒡ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓂᔨᐤ? ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐧᐋᐱᐦᑎᔨᑯᓈᐧᐋᐤ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓐ ᒌᔨᐧᐋᐤ ᐄᔨᔨᑑᒄ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ᒌ ᓂᑭᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᒡ ᐋᒄ ᑳ ᐴᓯᑦ ᒦᓐ ᒌᒫᓂᓯᔨᐤ, ᐋᒄ ᓈᑖᐦ ᐊᑳᒥᐦᒡ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ ᑳ ᐃᔅᒋᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒥᒄ ᐹᔨᒄ ᐋᐃᐦᑯᓈᐤ ᒌ ᐹᒋ ᓃᒫᐦᑖᐧᐋᑯᐱᓐ ᐋ ᒌ ᐧᐃᓂᒋᔥᒋᓯᐧᐋᑯᐱᓈ ᐋᔨᐧᐋᒡ ᒑ ᒌ ᑎᐦᑯᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ᒌᓴᔅᐦ ᒌ ᐄᔑ ᐃᔮᐧᑳᒥᑯᒡ, “ᔮᐧᑳᒄ, ᐃᔮᐧᑳᒦᔥᑎᐧᒫᐦᒄ ᐅᐦᐱᓯᑭᓂᒧᐧᐋᐤ ᐹᕆᓰᒡ ᑭᔮᐦ ᒫᒃ ᐦᐁᕆᑦ ᐅᐦᐱᓯᑭᓂᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ᒌ ᐋᔨᐧᒫᐅᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, ᐋᐦ ᐃᔨᒡ, “ᐋᐦᐋᑳ ᐅᐦᒋ ᐹᔒᒫᐦᒄ ᐋᐃᐦᑯᓈᐤ ᐋᔪᐧᐃᒄ ᐧᐋᐦᒋ ᐃᔨᑦ ᐅᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ ᐋᒄ ᑳ ᑯᐧᑳᒋᒫᑦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐋᔨᐧᒫᐅᐦᐄᑯᔮᒄ ᐊᓐ ᐋᐦᐋᑳ ᐃᔮᐧᐋᒄ ᐋᐃᐦᑯᓈᐤ? ᓂᒧᐃ ᐋᔥᒄ ᒋᐧᐋᐱᐦᑖᓈᐧᐋᐤ? ᓂᒧᐃ ᐋᐦ ᐋᔥᒄ ᒋᓂᔅᑐᐦᑖᓈᐧᐋᐤ? ᒌ ᒥᔅᑰᑖᐦᐋᓈᐧᐋᐤ ᐋ ᑭᔮᐦ ᒌᔨᐧᐋᐤ? ");
INSERT INTO crl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ᒋᑎ ᐃᔮᓈᐧᐋᐤ ᒥᔅᒌᔑᒄ, ᓂᒧᐃ ᐋ ᒫᒃ ᒋᐧᐋᐱᐦᑖᓈᐧᐋᐤ? ᑭᔮᐦ ᒥᐦᑑᑮ ᒋᑎ ᐃᔮᓈᐧᐋᐤ, ᓂᒧᐃ ᐋ ᒫᒃ ᒋᐹᐦᑖᓈᐧᐋᐤ? ᓂᒧᐃ ᐋ ᒋᒋᔥᒋᓯᓈᐧᐋᐤ? ");
INSERT INTO crl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ᒋᒋᔥᒋᓯᓈᐧᐋ ᑳ ᐱᐦᐧᑳᓂᒃ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐆᒡ ᒑ ᒌ ᒦᒋᓱᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᓂᔮᐧᔮᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑳ ᐃᑎᔑᒡ᙮ ᑖᓐ ᒫᒃ ᑳ ᑎᐦᑎᐦᒡ ᐅᑎᐲᐧᐃᑦ ᑳ ᓵᑭᔅᒋᓂᑖᔮᒄ ᐃᔅᑯᔥᑎᐧᐋᓐ ᑳ ᒫᒨᔑᒋᓂᒫᒄ?” “ᓃᔓᔖᑉ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐱᐱᐦᐧᑳᓂᐧᑳᐤ ᐊᓂᒌ ᓃᐧᔖᔥᒡ ᐋᐃᐦᑯᓈᐆᒡ ᒑ ᒌ ᒦᒋᓱᒡ ᐊᓂᒌ ᓈᐧᐋᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐄᔨᔨᐅᒡ ᑖᓐ ᑳ ᐄᔥᐱᔖᒡ ᒫᒃ ᐃᔅᑯᔥᑎᐧᐋᓐ ᐊᓂᑎᐦ?” “ᓃᐧᔖᔥᒡ ᐅᑎᐲᐧᐃᑦ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᓂᑖᐦ ᒫᒃ ᐧᐋᐦᒋ ᐋᑳ ᒌ ᓂᔅᑐᐦᑎᒫᒄ?” ");
INSERT INTO crl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ᐄᔥᐱᐦ ᐧᐋᑎᐦᑎᐦᒡ ᐱᕪᓭᐃᑖ ᒌᐦ ᑖᐅᒡ ᐄᔨᔨᐅᒡ ᐋ ᐹᔓᐧᐋᒡ ᓈᐹᐤᐦ ᐋᐦᐋᑳ ᐧᐋᐱᐦᑎᒥᔨᒡ᙮ ᓈᔥᒡ ᒌ ᓂᑎᐧᐋᔨᒫᐅᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᑖᐦᒋᓈᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᓂᐧᒫᑦ ᐅᑎᐦᒌᔨᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᒄ ᑳ ᐧᐃᔨᐧᐄᐦᑎᐦᐋᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᑭᒧᐦᑖᐧᐋᑦ ᐅᓯᐦᑰᐧᐃᓐ ᐅᔅᒌᔑᑯᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌ ᐧᐋᐱᐦᑖᓐ ᐋ ᒑᐧᑳᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ᒌ ᐄᑖᐱᐤ ᐊᓐ ᓈᐹᐤᐦ ᐋᐦ ᐄᑖᑦ, “ᐋᐦᐋ, ᓂᐧᐋᐱᒫᐅᒡ ᐄᔨᔨᐅᒡ, ᒥᒄ ᒫᒃ ᒧᔮᒻ ᒥᔅᑎᑯᒡ ᐋ ᐱᐹᒧᐦᑖᒡ ᐊᐧᑳᔑᓅᐧᑳᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ᒌᓴᔅ ᒦᓐ ᑳ ᑖᐦᒋᓂᐧᒫᑦ ᐅᔅᒌᔑᑯᔨᐤ᙮ ᐋᔪᐧᐃᒄ ᐋᒄ ᑳᐦ ᐋᐱᐦᐄᐱᔨᔨᒡ ᒥᑐᓐ ᐋ ᒦᓂᐧᐋᒋᐦᑖᑭᓂᐧᐄᔨᒡ, ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᒌ ᐱᔮᐦᑭᔅᒋᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ᐋᒄ ᒌᓴᔅ ᑳ ᒌᐧᐋᑎᔑᐦᐧᐋᑦ, ᐅᔮᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᐊᑳᐧᐄ ᐄᑐᐦᑖ ᐊᓂᑖᐦ ᐃᐦᑖᐧᐃᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ᐋᒄ ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓐ ᐹᔓᒡ ᓭᓯᕇᔮᐦ ᕕᓕᐹᐃ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌᓴᔅᐦ ᒌ ᑯᐧᑳᒋᒫᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᐊᐧᐋᔨᐤᐦ ᐃᔮᐧᐋᔨᒥᒡ ᒫᒃ ᓃᔨ, ᐄᔨᔨᐅᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᐃᔨᐅᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐋᐦ ᐋᐧᐄᔮᓐ, ᐋᒄ ᑯᑎᑭᒡ ᐃᔨᐅᒡ ᐄᓛᐄᒑ ᐋᐦ ᐋᐧᐄᔮᓐ, ᐋᒄ ᒦᓐ ᑯᑎᑭᒡ ᐹᔨᒄ ᐊᓂᔮ ᐅᒋᔅᒋᐧᐋᐦᐄᒑᓯᐤ ᒋᑎᐄᑖᔨᒥᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐧᐋᐤ ᒫᒃ ᐧᐄᐦ, ᐊᐧᐋᓐ ᓃᔨ ᐋᑖᔨᒥᔮᒄ?” ᐲᑎᕐ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᒌᔨ ᙭᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᒫᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐋᑳ ᒑ ᐧᐄᐦᑎᒧᐧᐋᔨᒡ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᐦᒋ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, “ᓂᑎᐧᐋᔨᐦᑖᑯᓂᔨᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᔮᔨᑖᐃ ᒑ ᒌ ᒥᔥᑎᐦ ᐧᐄᓯᒑᔨᐦᑎᒥᐦᐋᑭᓅᑦ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒥᑰ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐧᐋᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔑᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡᐦ᙮ ᑭᑎ ᓂᐱᐦᐋᑭᓂᐤ, ᐄᔥᐱᐦ ᒌ ᓂᔥᑐ ᒌᔑᑳᔨᒑ ᑭᑎ ᐧᐃᓂᔥᑳᐤ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᓈᔥᒡ ᒌ ᐱᔮᑭᔅᒋᐦᑖᑯᐦᑖᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᒥᔨᒡ᙮ ᐋᒄ ᐲᑎᕐ ᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅ, ᑳ ᒋᔅᑎᐦᐋᒧᐧᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᐋᐦ ᐄᑖᑦ, “ᐊᑳᐧᐄ ᐊᓐ ᑳᐦ ᐃᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ᒌᓴᔅ ᒫᒃ ᒌ ᐧᑳᔅᒋᑳᐳ ᑳ ᐅᑖᔥᑎᒥᑳᐳᔥᑎᐧᐋᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐋᒄ ᑳᐦ ᐋᐧᓈᔨᒫᑦ ᐲᑎᕐ ᐋᐦ ᐄᑖᑦ, “ᒥᒋᒥᓂᑑ, ᒫᒌᐦ ᐄᒑᑖᐦ ᐅᑖᐦᒡ ᐄᑐᐦᑖ᙮ ᐊᓐ ᑖᓐ ᐋ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔨᓐ ᒑᐧᑳᓐ ᑖᐹ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ, ᓈᐹᐤ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ᐋᒄ ᒌᓴᔅ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳ ᒫᐅᓯᑯᔨᒡ ᐊᐧᐋᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᐧᐋᓐ ᐧᐋᐦ ᓅᔔᔥᑯᐧᐋᐧᑳ ᐋᑯᔥ ᑭᑎ ᐱᒋᔅᑎᓂᒻ ᐊᓂᔮᔨᐤ ᐧᐄᔨ ᑖᓐ ᐧᐋᐦ ᐄᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᑦ, ᑭᑎ ᐅᑎᓈᐤ ᐅᑖᔑᑖᔮᐦᑎᑯᒻ, ᐋᒄ ᒫᒃ ᒑ ᐹᒋ ᓅᔔᔥᑳᐧᐃᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ᐧᐋᔥ ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐧᐄᐦ ᑭᓄᐧᐋᔨᐦᑎᒫᓱᑦ ᐅᐱᒫᑎᓰᐧᐃᓐ ᑭᑎ ᐧᐃᓂᐦᑖᐤ᙮ ᐊᓐ ᒫᒃ ᐊᐧᐋᓐ ᒑ ᐱᒋᔅᑎᓂᒧᐧᑳ ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᑖᓐ ᑳ ᐧᐄᐦ ᑐᑎᐦᒃ ᐧᐋᐧᐋᒡ ᑭᔮᐦ ᐅᐱᒫᑎᓰᐧᐃᓐ ᐋ ᐧᐄᐦ ᐹᒋ ᓅᔔᔥᑯᑦ ᑭᔮᐦ ᒫᒃ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᐅᐦᒋ, ᐋᐅᒄ ᐆ ᒑ ᒥᔮᑭᓅᑦ ᐱᒫᑎᓰᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ᑖᓐ ᒫᒃ ᒑ ᒌ ᐄᔑ ᐧᐄᒋᐦᐄᑯᑦ ᐊᐧᐋᓐ ᐋᑎ ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᒌ ᐱᑯᐦᑎᒫᓱᒑ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᐦᒃ, ᒑ ᐧᐃᓂᐦᑖᐧᑳ ᒫᒃ ᐅᐱᒫᑎᓰᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ᓂᒧᐃ ᒥᑐᓐ ᑎᑯᓂᔨᐤ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒃ ᑳᐤ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᐅᐱᒫᑎᓰᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ᐊᓐ ᐊᐧᐋᓐ ᒑ ᐱᒫᒥᔒᔥᑑᐧᐃᑦ ᑭᔮᐦ ᒑ ᐱᒫᒥᔒᔥᑎᒧᐧᑳ ᐊᓂᔮᔨᐤ ᓂᒋᔅᑯᑎᒫᒑᐧᐃᓐ ᐊᓅᐦᒡ ᐅᔮᔨᐤ ᒫᐧᑳᒡ ᐋ ᐃᔥᐱᔥ ᐋᑳ ᑯᐃᔅᒄ ᐃᔨᐦᑎᒡ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐋ ᐃᔥᐱᔥ ᐱᓯᐧᑳᑎᓰᐤ ᐱᒫᑎᓰᔨᒡ, ᑭᔮᐦ ᐧᐄᔨ ᑭᑎ ᐱᒫᒥᔒᔥᑖᑰ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐄᔥᐱᐦ ᑎᑯᔑᓃᔨᒑ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓰᐧᐃᓃᔨᐦᒡ, ᐱᔮᐦᒋ ᐋᓐᒋᓐ ᐋ ᐹᒋ ᐧᐄᒑᐅᑯᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ᐋᒄ ᒌᓴᔅ ᐅᔮᔨᐤ ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᑖᐅᒡ ᐱᔅᒡ ᐅᑎᐦ ᑖᐧᐋᔨᔥ ᐄᔨᔨᐅᒡ ᐋᑳ ᒑ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦᐧᒫᔮ ᒌ ᐧᐋᐱᐦᑎᐧᒫᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ ᐋ ᐹᒋ ᓅᑯᓃᔨᒡ ᓲᐦᑳᑎᓰᐧᐃᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ᑯᐧᑖᔥᒡ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐹᑎᒫ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐲᑎᕐ, ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᐊᓂᑖᐦ ᐋ ᐃᔥᐱᑎᓈᔨᒡ ᐋ ᐱᔅᐧᑳᐱᔅᑳᔨᒡ ᒥᒄ ᐧᐄᔨᐧᐋᐤ ᒑ ᒌ ᑖᒡ᙮ ᐋᑯᑖᐦ ᐅᑎᐦ ᑳ ᐧᑳᔅᒋᓈᑯᓯᑦ ᒌᓴᔅ ᐅᐦᑎᔅᑰ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ, ᐊᑭᓂᐧᐋᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ᐅᒑᐧᑳᓂᒻ ᒫᒃ ᒥᑐᓐ ᒌ ᐧᐋᓵᑖᔨᐤ, ᓈᔥᒡ ᐋ ᐱᔮᐦᑭᔥᒡ ᐧᐋᐹᔨᒡ᙮ ᓂᒧᐃ ᑖᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐊᐧᐋᓐ ᒑ ᒌ ᐃᔥᐱᔥ ᐧᐋᐹᔨᒡ ᒑᐧᑳᔨᐤ ᐋ ᒋᔥᑖᐹᐅᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ᐋᒄ ᒫᒃ ᑳᐦ ᐅᐦᒋ ᓅᑰᓯᔨᐦᒡ ᐅᐦᑎᔅᑭᐤ ᐋᐦ ᑖᒡ, ᐄᓛᐃᒑᐦ ᑭᔮᐦ ᒧᓯᔅᐦ ᐋ ᐊᔨᒥᐦᐋᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓄᐧᐃᒡ ᒥᐧᔮᔨᐦᑖᑯᓐ ᐅᑎᐦ ᒑ ᒌ ᑖᐅᑯᐱᓈ᙮ ᐱᒋᔅᑎᓈᓐ ᒑ ᒌ ᐅᔑᐦᑖᔮᐦᒡ ᓂᔥᑐ ᑎᐱᓅᔑᒧᓐᐦ, ᐹᐦᐹᔨᒄ ᒑ ᐃᔮᔮᒄ, ᒌᔨ, ᒧᓱᔅ ᑭᔮᐦ ᐄᓛᐃᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐲᑎᕐ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᑖᓐ ᒑ ᒌ ᐄᑖᑦ ᐧᐋᔥ ᓈᔥᑖᑆᐦ ᒌ ᓵᒋᓲ᙮ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᓈᔥᑖᑆᐦ ᒌ ᓵᒋᓯᐧᐃᒡ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ᒑᒃ ᑭᔥᑭᐧᐃᓂᔥᒄ ᑳ ᐅᐦᒋ ᐅᑳᔥᑖᔅᑳᑯᒡ᙮ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐹᐦᑎᐧᐋᒡ ᐊᐧᐋᔨᐤᐦ ᐋᐦ ᐄᔨᔨᒡ, “ᐋᐅᒄ ᐆ ᓃᔨ ᑎᐱᔨᐧᐋ ᓂᑯᔅ ᑳ ᓵᒋᐦᐄᒃ᙮ ᓂᑐᐦᑎᐧᐋᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ᒌ ᐊᔨᐦᑖᐱᐧᐃᒡ ᑏᐧᐋᐦᒡ ᐊᓂᑎᐦ ᐧᐋᔅᑳ ᐋᐦᑖᐦᒡ ᐋ ᓈᓂᑎᐧᐋᐱᒫᒡ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᐋᐦᑖᔨᐧᑳᓂᐦᐄ ᐊᓂᑎᐦ ᐋᐦᑖᐦᒡ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᑖᔨᐤ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ, ᒥᒄ ᒌᓴᔅᐦ ᒌᐦ ᑖᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᓃᑎᐦᒋᐧᐋᒡ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᐧᑳᐱᔅᑳᔨᒡ ᒌᓴᔅᐦ ᒌ ᐄᑎᔓᒥᑯᒡ, “ᐊᑳᐧᐄ ᐊᐧᐋᓐ ᐅᐦᒋ ᐧᐄᐦᑎᒧᐧᐋᐦᒄ ᐆ ᑳ ᐄᔅᐱᔨᒡ ᐹᑎᔥ ᒌ ᐧᐃᓂᔥᑳᒑ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ᒌ ᐱᔑᒋᐦᐋᐅᒡ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑎᐦᐋᒫᑯᒡ, ᒥᒄ ᒫᒃ ᐊᓂᑎᐦ ᐧᐄᔨᐧᐋᐤ ᒌ ᐊᔨᐧᒫᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᐋᐦ ᐃᔨᒡ, “ᒑᐧᑳᓐ ᐆ ᑳ ᐄᓈᓂᐧᐃᔨᒡ ᐋ ᐧᐃᓂᔥᑳᑦ ᐊᐧᐋᓐ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ?” ");
INSERT INTO crl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ᐋᒄ ᐋᑖᒡ ᒌᓴᔅᐦ, “ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐃᔨᒡ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᔮᔨᑖ ᓃᔥᑎᒻ ᐄᓛᐃᒑᐦ ᒑ ᑎᑯᔑᓃᔨᒡ ᐋᐧᒫᔮ ᑎᑯᓯᓃᔨᒡ ᙭?” ");
INSERT INTO crl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ᐋᒄ ᑳ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᐄᑯᒡ, “ᑖᑆᐦ ᑭᔨᑆ ᐄᓛᐃᒑ ᓃᔥᑎᒻ ᑭᑎ ᑎᑯᔑᓐ ᒑ ᒌ ᐃᔮᔅᑰᔥᑖᑦ ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ᙮ ᒑᐧᑳᓐ ᒫᒃ ᐧᐋᐦᒋ ᐄᑎᔥᑖᒡ ᒋᔖᒥᓂᑑ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒥᔥᑏᐦ ᒑ ᓂᓈᐦᑳᑖᔨᒧᑦ ᑭᔮᐦ ᐋᑳ ᒑ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᑭᓅᑦ? ");
INSERT INTO crl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ᒥᒄ ᒫᒃ, ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᔖᔥ ᒌ ᑎᑯᔑᓐ ᐄᓛᐃᒑ᙮ ᒥᒄ ᒫᒃ ᑖᓐ ᐧᐋᐦ ᑐᑖᑯᑦ ᐊᐧᐋᔨᐤᐦ ᐋᔪᐧᐃᒄ ᑳᐦᑐᑖᑯᑦ ᐋ ᒌ ᒫᔮᔨᒥᑯᑦ᙮ ᐧᐋᔥ ᐋᔪᐧᐃᒄ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒥᓯᓂᐦᐄᑭᓃᔨᒡ ᒑ ᑐᑎᐧᐋᑭᓄᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᓈᑎᐧᐋᐱᒫᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᒌ ᐧᐋᐱᒫᐅᒡ ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᐋ ᐧᐋᔅᑳᑳᐳᔥᑖᑯᔨᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᑳ ᒥᔥᑎᐦ ᐋᔮᔅᑖᒥᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᐧᐃᔮᐱᒫᒡ ᒌᓴᔅᐦ, ᓈᔥᑖᑆᐦ ᒌ ᑯᔥᐧᑳᔨᐦᑎᒧᒡ, ᑳ ᒋᒋᓈᒡ ᒑ ᒌ ᐧᐋᒋᔮᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᒑᐧᑳᓐ ᐊᓐ ᓈᔥᒡ ᑳ ᒥᔥᑎᐦ ᐋᔨᐧᒫᐅᐦᐄᑯᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ᒌ ᐅᐦᒋ ᐊᔨᒨ ᐹᔨᒄ ᓈᐹᐤ ᐊᓂᑎᐦ ᑖᐧᐋᔨᔥ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐋᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᒌ ᐹᐧᑖᑎᓐ ᓂᑯᔅ᙮ ᓂᒧᐃ ᒌ ᐊᔨᒨ ᐧᐋᔥ ᒥᒋᐊᐦᒑᐦᒄ ᐲᐦᒋᔥᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ᐄᔥᐱᐦ ᒥᔮᓯᐦᐄᑯᒡ ᐅᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ, ᒥᑐᓐ ᐧᐋᔥ ᑭᑎ ᑯᐧᐋᐱᐦᐅᑰ, ᑭᔮᐦ ᑭᑎ ᐲᔥᑖᐅᑖᐦᑎᒻ, ᐋᔨᐤᐦ ᒫᒃ ᐧᐋᔥ ᑭᑎ ᔑᔖᔮᐱᑖᔨᐤ, ᑭᔮᐦ ᒥᑐᓐ ᑭᑎ ᒌᑎᐧᐋᔅᑯᐱᔨᐤ᙮ ᐊᓂᒌ ᒫᒃ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᓂᒌ ᑯᐧᑳᒋᒫᐅᒡ ᒑ ᒌ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᒡ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᐧᐄᐧᐃᑎᔑᐦᐧᐋᐧᐃᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳ ᑖᔨᐦᒡ, “ᒌᔨᐧᐋᐤ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᐋ ᐱᒫᑎᓰᔮᒄ ᐋᑳ ᑳ ᐃᔮᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ, ᑖᓐ ᒑ ᐃᔥᐱᔒ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐃᔮᒄ ᒑ ᒌ ᓂᔅᑐᐦᑎᒫᒄ? ᑖᓐ ᒑ ᐃᔥᐱᔥ ᐊᔑᓂᐧᐋᐦᐄᑎᑯᒡ ᐃᔮᒄ ᒑ ᒌ ᐃᔮᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ? ᐹᔓᐧᐋᐦᒄ ᐊᓐ ᓈᐹᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ᐋᒄ ᑳ ᐹᔓᐧᐋᒡ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐄᔥᐱᐦ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ ᐧᐃᔮᐱᒫᑦ ᒌᓴᔅᐦ ᑏᐧᐋᐦᒡ ᒌ ᑐᑎᐧᐋᐤ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᒑ ᒌ ᐅᒋᐱᑎᑯᔨᒡ, ᒥᑐᓐ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᐋ ᒌ ᐄᔑ ᐱᐦᒋᔑᓃᔨᒡ᙮ ᐋᒄ ᑳ ᐧᑳᐦᐧᑳᑎᐱᔨᐦᐅᑦ ᐊᓂᑎᐦ ᐊᓐ ᓈᐹᔥ ᐋ ᐲᔥᑖᐅᑖᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ᒌᓴᔅ ᑳ ᑯᐧᑳᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐅᐦᑖᐧᐄᒫᐤ, “ᔖᔥ ᐋ ᐧᐋᔥᑭᒡ ᐅᔮᔨᐤ ᑳ ᐃᓯᓈᑯᓯᑦ?” “ᐧᐄᐱᒡ ᑳ ᐊᐧᐋᔑᔒᐧᐃᑦ ᔖᔥ ᐋᔪᐧᐃᒄ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᑦ,” ᒌᐦ ᐄᑖᐤ ᐊᓐ ᐅᐦᑖᐧᐄᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","ᑭᔮᐦ ᒌᐦ ᐄᑖᐤ, “ᔖᔥ ᒥᐦᒑᐧᑖᐤ ᒋᐧᐄᐦ ᓂᐱᐦᐄᑰ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐃᔥᑯᑖᐦᒡ ᑭᔮᐦ ᒫᒃ ᓂᐲᐦᒡ ᐋ ᐄᔑ ᐧᐋᐱᓂᑯᑦ᙮ ᒋᔅᑎᒫᒑᔨᒥᓈᓐ ᒫᐦ, ᐧᐄᒋᐦᐄᓈᓐ, ᒑ ᒌ ᐧᐄᐦ ᐧᐄᒋᐦᐄᐧᐋᐦᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐃᔨᓐ ᒑ ᒌ ᐧᐄᐦ ᐧᐄᒋᐦᐄᐧᐋᐦᒑ? ᐧᐋᔥ ᒋᔖᒥᓂᑑ ᒋᑭ ᒌᐦ ᑐᑎᒧᐧᐋᐤ ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᐊᓂᔮᔨᐤ ᑳᑖᑆᔮᔨᒥᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ᑏᐧᐋᐦᒡ ᑳ ᐅᐦᒋ ᐋᔑᐦᐧᑳᑦ ᐊᓐ ᐅᐦᑖᐧᐄᒫᐤ, “ᓂᑖᑆᐦᑖᓐ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓈᔥᒡ ᓂᑎᔮᓐ ᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ᙮ ᐧᐄᒋᐦᐄᐦ ᐊᑎᑎᐤ ᒑ ᒌ ᐃᔮᔮᓐ ᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ᒌᓴᔅ ᒫᒃ ᒌ ᐧᐋᐱᒫᐤ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑳ ᐹᒋ ᒫᐅᓯᑯᑳᐳᐧᐃᔨᐦᒡ ᐋᐦ ᐋᑎᓰᐦᑎᔅᑳᑐᔨᒡ ᐋᒄ ᑳ ᒋᔅᑎᐦᐋᒧᐧᐋᑦ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐋᐦ ᐄᑖᑦ, “ᒌᔨ ᐊᐦᒑᐦᒄᐦ ᐋᑳ ᑳ ᐹᐦᑎᒥᓐ ᑭᔮᐦ ᐋᑳ ᑳ ᓂᐦᑖᐧᐋᔨᓐ, ᒫᒌᐦ ᐧᐃᔨᐧᐄᐦ ᐊᓂᑎᐦ ᐆ ᓈᐹᔥ ᐋᐦ ᑖᑦ ᐅᐦᒋ᙮ ᐊᑳᐧᐄ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᐲᐦᒋᔥᑭᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ᐋᒄ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐅᐦᒋ ᐋᔑᐦᐧᑳᑦ, ᑳᐦ ᑐᑎᐧᐋᑦ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᒑ ᒌ ᐅᒋᐱᑎᑯᔨᒡ, ᐋᒄ ᑳ ᓂᑭᑖᑦ᙮ ᐊᓐ ᒫᒃ ᓈᐹᔥ ᒧᔮᒻ ᐋ ᐴᓂᐱᒫᑎᓰᑦ ᐋᒄ ᑳ ᐃᓯᓈᑯᓯᑦ ᐊᓂᑎᐦ ᐋ ᐱᒥᔑᐦᒃ᙮ ᐋᒄ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ᒌᓴᔅ ᒌ ᐅᑎᓂᐧᒫᐤ ᐅᑎᐦᒌᔨᐤ ᐊᓂᔮᔨᐤ ᓈᐹᔥ, ᐋᒄ ᑳ ᐧᐄᒋᐦᐋᑦ ᐋ ᐧᐃᓂᔥᑳᔨᒡ᙮ ᑳ ᐱᔑᑯᑦ ᐊᓐ ᓈᐹᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ᑳ ᐊᑎ ᒋᔅᑐᐦᑖᑦ ᒌᓴᔅ, ᐋᒄ ᑳ ᐲᐦᒑᑦ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒫᒃ ᒌ ᑯᐧᑳᒋᒥᑰ ᒥᒄ ᐧᐄᔨᐧᐋᐤ ᐋᐦᑖᐦᒡ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐋᑳ ᐅᐦᒌ ᑐᑎᐧᐋᒋᐦᑦ ᓃᔮᓐ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐧᐃᔨᐧᐄᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐲᐦᒋᔥᑯᐧᐋᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ᒌ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᐄᑯᒡ ᒫᒃ ᒌᓴᔅᐦ, “ᒥᒄ ᐊᔨᒥᐦᐋᒑ ᐊᐧᐋᓐ ᐋᑯᑖᐦ ᒥᒄ ᒑ ᒌ ᐧᐃᔨᐧᐄᔨᒡ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᓂᒧᐃ ᒦᓐ ᑎᑯᓂᔨᐤ ᐊᓂᑖᐦ ᒑ ᒌᐦ ᑎᒃ ᐊᐧᐋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᒋᔅᑐᐦᑖᐅᒡ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐋᒄ ᒥᒄ ᑳ ᔖᐳᐦᑎᐧᐋᔥᑭᐦᒡ ᑳᓕᓖ ᐊᔅᒌᔨᐤ ᐄᔥᐱᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᒡ᙮ ᒌᓴᔅ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐧᐋᔨᒫᐤ ᒑ ᒌ ᒋᔅᒑᔨᒥᑯᑦ ᐊᐧᐋᔨᐤᐦ ᑖᓂᑖᐦ ᐋᐦ ᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ᐧᐋᔥ ᒫᐧᑳᒡ ᒌ ᒋᔅᑯᑎᒧᐧᐋᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ᒌᐦ ᐄᑖᐤ, “ᓈᐹᐤ ᐋᐦ ᑖᔨᒡ ᑭᑎ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᒌ ᓂᐱᐦᐄᑯᑦ᙮ ᒥᒄ ᒫᒃ ᒌ ᓂᔥᑐ ᒌᔑᑳᔨᒑ ᐋᒄ ᒦᓐ ᒑ ᐧᐃᓂᔥᑳᑦ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ ᑖᓐ ᐋ ᐄᔑ ᐧᐄᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ, ᒌ ᓵᒋᓯᐧᐃᒡ ᑭᔮᐦ ᒑ ᒌ ᑯᐧᑳᒋᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ᒌ ᐅᑎᐦᑎᒧᒡ ᑭᐱᕐᓃᔨᒥᔨᐤ ᐃᐦᑖᐧᐃᓐ, ᐄᔥᐱᐦ ᒫᒃ ᐲᐦᑎᑭᒥᐦᒡ ᐋᐦᑖᐦᒡ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᒑ ᑖᒡ ᐋᒄ ᒌᓴᔅ ᑳ ᑯᐧᑳᒋᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᒌ ᐋᔮᔅᑖᒥᑐᔮᒄ ᐊᓂᑖᐦ ᑳ ᐹᒋ ᐱᒧᐦᑖᔨᐦᒄ?” ");
INSERT INTO crl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑᒡ, ᐧᐋᔥ ᐊᓂᔮᔨᐤ ᒫᐧᑳᒡ ᑳ ᐱᒧᐦᑖᒡ ᒌ ᐋᔮᔅᑖᒥᑑᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐊᐧᐋᔨᐤᐦ ᒫᐅᒡ ᒑᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᑎᐦ ᐋᑎᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ᒌ ᐅᐧᐋᔨᐱᐤ ᒌᓴᔅ, ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᐊᐧᐋᓐ ᓈᑎᐧᐋᔨᐦᑎᒧᐧᑳ ᐧᐄᔨ ᒫᐅᒡ ᓃᑳᓐ ᒑ ᒌ ᐄᑖᔨᐦᑖᑯᓯᑦ, ᒫᐅᒡ ᐅᑖᐦᒡ ᒋᐱᐦ ᐄᔑ ᐱᒋᔅᑎᓃᓲ ᑭᔮᐦ ᒥᓯᐧᐋ ᐊᐧᐋᔨᐤᐦ ᒋᐱᐦ ᒥᔪ ᐋᐱᑎᓰᔅᑎᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ᐋᒄ ᑳ ᐅᑎᓈᑦ ᐊᐧᐋᔑᔥ ᑳ ᐅᐦᑎᔅᑯᑳᐳᐦᐋᑦ ᐊᓂᑎᐦ ᑖᐧᐋᔨᔥ ᐋᐦᑖᐦᒡ᙮ ᑳ ᐧᐋᐅᒋᓈᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ");
INSERT INTO crl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ᐊᐧᐋᓐ ᐋ ᐅᑎᓈᑦ ᐹᔨᒄ ᐊᐧᐋᔑᔥ ᓂᑎᔑᓂᐦᑳᓱᐧᐃᓂᐦᒡ ᐅᐦᒋ, ᒧᔮᒻ ᑭᔮᐦ ᓃᔨ ᐋ ᐅᑎᓂᑦ ᐊᐧᑳᔑᓈᑯᓃᔨᒡ᙮ ᐊᓐ ᒫᒃ ᐊᐧᐋᓐ ᑳ ᐅᑎᓂᑦ ᓂᒥᔮᔨᐤ ᓃᔨ ᑳ ᐅᑎᓂᑦ, ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᐧᐋᑎᓈᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ᒞᓐ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓂᒌᐧᐋᐱᒫᓈᓐ ᓈᐹᐤ ᐋ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᑦ ᒥᒋᐊᐦᒑᐦᒄ ᒋᑎᐃᔑᓂᐦᑳᓱᐧᐃᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᑦ, ᐋᒄ ᑳ ᒋᔅᑎᐦᐋᒧᐧᐃᒋᐦᑦ, ᐧᐋᔥ ᐊᓐ ᑖᐹ ᐅᑖᐦ ᒌᔮᓂᐤ ᐋᑖᐅᐦᒄ ᐄᔑ ᐧᐄᒋᐦᐄᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, “ᐊᑳᐧᐄ ᒋᔅᑎᐦᐋᒫᐦᒄ, ᐧᐋᔥ ᑖᐹ ᓂᑭ ᐅᐦᒋ ᒥᒋᐋᔨᒨᒥᐦᒄ ᐊᐧᐋᓐ ᒥᔔ ᑐᑎᐦᑳ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐧᐃᓂᔨᐤ ᓂᑎᔑᓂᐦᑳᓱᐧᐃᓂᔨᐤ ᐋ ᒌ ᐋᐱᒋᐦᑖᑦ ᑭᔮᐦ ᒫᒃ ᒦᓐ ᑏᐧᐋᐦᒡ ᒑ ᒌ ᒥᒑᐊᔨᒧᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ᐧᐋᔥ ᐊᓐ ᐊᐧᐋᓐ ᐋᑳ ᑳ ᓂᔥᑰᔥᑖᑎᐦᒄ, ᒌ ᐧᐄᒋᐦᐄᑯᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ᒋᐦᒋᐧᐋ ᒫᒃ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᐊᓐ ᐊᐧᐋᓐ ᒑ ᒥᓂᐦᐄᑎᐧᐋᐧᑳ ᓂᐲᔨᐤ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᙭ ᐋ ᐧᐄᒑᒫᒄ, ᒑᔥᑎᓈᔥ ᑭᑎ ᒥᔮᑭᓂᐤ ᐅᑎᐱᐦᐊᒫᑯᓰᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ᒌᓴᔅ ᒌ ᐋᑎ ᐄᑖᐤ, “ᐊᓐ ᐊᐧᐋᓐ ᒑ ᑐᑎᐧᐋᐧᑳ ᒑ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ ᐹᔨᒄ ᐅᔮᔨᐤ ᐊᐧᐋᔑᔥ ᑳ ᑖᑆᔮᔨᒥᔨᒡ ᐊᐅᔅᑖ ᑭᑎ ᒥᐧᔮᔑᔨᐤ ᒑ ᒌ ᒫᐦᑯᐱᑎᒫᑭᓂᐧᐃᔨᒡ ᐋ ᒥᐦᒑᐱᔅᒋᔨᒡ ᐊᓯᓃ ᐅᑯᔮᐦᒡ, ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᒋᐦᒋᑭᒦᐦᒡ ᒑ ᒌ ᐱᑭᔥᑎᐧᐋᐱᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","ᒥᔔ ᒫᒃ ᒋᑎᐦᒌ ᐄᐦᑐᑖᑯᔨᓈ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᐋᑯᔥ ᒋᒥᔥ ᐊᓐ ᒋᑎᐦᒌ᙮ ᐊᐅᔅᑖ ᑭᑎ ᒥᐧᔮᓯᐤ ᒑ ᒌ ᐲᐦᒑᔨᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᐦᒡ ᒥᒄ ᐋ ᐹᔨᑯᐦᒡ ᐊᔅᑎᐦᒌ ᐃᔥᐱᔥ ᐧᐄ ᐋ ᐃᔮᔨᓐ ᑖᐱᔥᑯᓐ ᐊᔅᑎᐦᒌ ᒥᒋᔥᑯᑖᐦᒡ ᒫᒃ ᒑ ᐄᔑ ᐧᐋᐱᓂᑯᐧᐃᔨᓐ, ᐊᓂᑎᐦ ᐋᑳ ᓂᐦᑖ ᒑ ᐋᔥᑎᐧᐋᒡ ᐃᔥᑯᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","ᑭᔮᐦ ᒫᒃ ᒋᓯᑦ ᐄᐦᑐᑖᑯᔨᓈ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᒋᒥᔥ ᐊᓐ ᒋᓯᑦ᙮ ᐊᐅᔅᑖ ᑭᑎ ᒥᐧᔮᔓ ᒑ ᒌ ᐲᐦᒑᔨᓐ ᐱᒫᑎᓰᐧᐃᓂᐦᒡ ᐋ ᒫᔅᒋᐱᔨᓐ ᐃᔥᐱᔥ ᐧᐄ ᐋ ᐃᔮᔨᓐ ᑖᐱᔥᑯᓐ ᒋᓯᑦᐦ ᒥᒋᔥᑯᑖᐦᒡ ᒫᒃ ᒑ ᐄᔑ ᐧᐋᐱᓂᑯᐧᐃᔨᓐ, ᐊᓂᑎᐦ ᐋᑳ ᓂᐦᑖ ᒑ ᐋᔥᑎᐧᐋᒡ ᐃᔥᑯᑖᐤ, ");
INSERT INTO crl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ᑭᔮᐦ ᒫᒃ ᒋᔅᒌᔑᒄ ᐄᐦᑐᑖᑯᔨᓈ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᓐ, ᐋᑯᔥ ᐧᑳᔨᑯᐱᑦ ᐊᓐ ᒋᔅᒌᔑᒄ᙮ ᐊᐅᔅᑖ ᑭᑎ ᒥᐧᔮᓯᐤ ᒑ ᒌ ᐲᐦᒑᔨᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᐦᒡ ᒥᒄ ᐋ ᓂᐱᑖᔮᐱᔨᓐ ᐃᔥᐱᔥ ᐧᐄ ᑖᐱᔥᑯᓐ ᒑ ᒌ ᑭᓄᐧᐋᔨᐦᑎᒥᓐ ᒋᔅᒌᔑᒄ ᒥᒋᔥᑯᑖᐦᒡ ᒫᒃ ᒑ ᒌ ᐄᔑ ᐧᐋᐱᓂᑯᐧᐃᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ᐧᐋᔥ ᐋᑯᑖᐦ ᐅᑖᐦ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᓂᐲᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ ᒥᓂᑑᔥ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐋᔥᑐᐧᐋᔨᐤ ᐋᓂᔮᔨᐤ ᐃᔥᑯᑖᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᐃᔥᑯᑖᔨᐤ ᑭᑎ ᐋᐱᑎᓂᔨᐤ ᐋ ᐧᐄᐦ ᒥᔪᓈᑯᐦᑖᑭᓂᐧᐃᔨᒡ ᐅᐱᒫᑎᓰᐧᐃᓐ ᒧᔮᒻ ᑖᓐ ᐋᑖᐱᑎᐦᒡ ᔒᐅᐦᑖᑭᓐ, ᒦᒋᒥᐦᒡ ᐋ ᐊᔥᑖᑭᓂᐧᐃᒡ ᐋᑳ ᒑ ᒌ ᐧᐄᓂᐱᔨᒡ ᐊᓐ ᒦᒋᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ᒥᐧᔮᐱᑎᓐ ᔒᐅᐦᑖᑭᓐ, ᒥᒄ ᒫᒃ ᐃᔥᐱᔥ ᐋᑳ ᔑᐧᐃᔅᐱᑯᐦᒑ ᑖᓐ ᒑ ᒌ ᑐᑎᒥᓐ ᒦᓐ ᒑ ᒌ ᓯᐧᐋᒡ᙮ ᐋᒄ ᒫᒃ ᒌᔨᐧᐋᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᒄ ᒧᔮᒻ ᐋ ᒌ ᓰᐅᐦᐄᑯᔮᒄ ᒋᐱᐦ ᐄᑖᔨᐦᑖᑯᓯᓈᐧᐋᐤ ᑭᔮᐦ ᒋᐱᐦ ᒋᔮᒫᐧᐋᔨᐦᑖᑯᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᑭᑎᒻ ᐊᓂᑎᐦ ᐋ ᒌ ᑖᑦ, ᐋᒄ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐧᑳᔅᑖᐦ ᐄᑖᐦᒑᑳᒻ ᐧᒑᕐᑎᓐ ᓰᐲᐦᒡ᙮ ᐋᔪᐧᐃᒄ ᐊᔮᐱᒡ ᑳᐦᑐᑖᑯᑦ ᑭᔮᐦ ᐊᓂᑖᐦ ᐊᐧᐋᔨᐤᐦ, ᒌ ᒥᐦᒑᑎᔨᐤ ᐋ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑯᑦ᙮ ᐋᒄ ᑳᐦ ᑐᑎᐧᐋᑦ ᑖᓐ ᑳ ᒌ ᑐᑎᐧᐋᑦ ᒫᓐ ᐊᐧᐋᔨᐤᐦ ᐋ ᓂᑎᐧᐋᐱᒥᑯᑦ, ᒌ ᒋᔅᑯᑎᒧᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ᒌ ᑎᑯᔑᓂᔨᐤ ᐹᕆᓰᐦ ᐋ ᒌ ᐧᐄᐦ ᓈᓂᑐ ᑯᐧᑳᒋᐦᐄᑯᑦ ᐋᑳ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐧᐄᐦᑎᐦᒃ ᒑᐧᑳᔨᐤ᙮ ᐅᔮᔨᐤ ᒫᒃ ᒌ ᐄᔑ ᑯᐧᑳᒋᒥᑰ, “ᐧᐄᐦᑎᒨᓈᓐ ᒫᐦ, ᐄᑎᔥᑖᐤ ᐋ ᐧᐄᔓᐧᐋᐧᐃᓂᐦᒡ ᒑ ᓂᐦᐋᔨᒫᑭᓅᑦ ᓈᐹᐤ ᒑ ᒌ ᐧᐋᐱᓈᑦ ᐧᐄᐤᐦ?” ");
INSERT INTO crl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ᒌᓴᔅ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ, ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑯᐧᑳᒋᒫᑦ, “ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑖᒄ ᒫᒃ ᒧᓱᔅ?” ");
INSERT INTO crl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ᐋᒄ ᑳ ᔨᔨᒡ, “ᒧᓱᔅ ᒌ ᓂᐦᐋᔨᒫᐤ ᓈᐹᐤ ᒑ ᒌ ᐅᔑᐦᑖᔨᒡ ᐧᐋᐱᓂᑑ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᒌ ᐧᐋᐱᓈᔨᒡ ᐧᐄᐅᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓈᔥᑖᑆᐦ ᒋᓰᐱᐦᑖᓈᐧᐋᐤ ᒋᑖᐦᐄᐧᐋᒡ ᐋᔪᐧᐃᒄ ᐧᐋᐦᒋ ᒥᓯᓂᐦᐋᐦᒃ ᒧᓱᔅ ᐅᔮᔨᐤ ᐄᑎᔓᐧᐋᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ᒥᒄ ᒫᒃ ᐅᔅᑭᒡ ᑳ ᐅᔑᐦᑖᑭᓂᐧᐃᒡ ᐆ ᐊᔅᒌ, ᒋᔖᒥᓂᑑ ᑖᐱᔥᑯᓐ ᓈᐹᐤ ᑭᔮᐦ ᐃᔅᐧᑳᐤ ᒌ ᐅᔑᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ᐋᔪᐧᐃᒄ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᐅᐦᒋ ᓂᑭᑖᑦ ᓈᐹᐤ ᐅᓃᒋᐦᐄᒄᐦ, ᐧᐄᐤᐦ ᒑ ᒌ ᐧᐄᒋᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ᐋᒄ ᒫᒃ ᐋ ᓃᔑᒡ ᐊᓂᔮᔨᐤ ᐧᐄᐤᐦ ᐹᔨᒄ ᒥᔨᐤ ᒑ ᐃᓯᓈᑯᓯᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐋᒄ ᐋ ᓃᔑᒡ ᐃᓯᓈᑯᓯᐧᐃᒡ, ᒥᒄ ᒧᔮᒻ ᐹᔨᒄ ᒥᔨᐤ ᐋᓯᓈᑯᓯᐧᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᒋᔖᒥᓂᑑ ᑳ ᐹᔨᑯᐦᐋᑦ ᐊᑳᐧᐄ ᐊᐧᐋᓐ ᑭᑎ ᑐᑎᐧᐋᐤ ᒑ ᒌ ᐱᑳᓂᐦᐄᑐᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ᐄᔥᐱᐦ ᒫᒃ ᐹᐦᒑᒡ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᑯᐧᑳᒋᒥᑰ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᐧᒫᐅᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐊᓐ ᐊᐧᐋᓐ ᒑ ᐧᐋᐱᓈᐧᑳ ᐧᐄᐤᐦ, ᒦᓐ ᒫᒃ ᒋᒋᐧᐄᐅᒑ, ᑯᑎᒃ ᐃᔅᐧᑳᐤ ᐧᐄᒋᒫᒑ, ᓂᒧᐃ ᑯᐃᔅᒄ ᑐᑎᐧᐋᐤ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᐃᔅᐧᑳᐤ ᑳ ᐧᐄᒋᒫᑦ, ᐱᓯᐧᑳᑎᓯᐤ ᐅᔮᔨᐤ ᐋᐦ ᑐᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ᑭᔮᐦ ᒫᒃ ᐃᔅᐧᑳᐤ ᐧᐋᐱᓈᒑ ᐅᓈᐹᒻ, ᒦᓐ ᒫᒃ ᒋᐦᒋᐅᓈᐹᒥᒑ, ᑯᑎᒃ ᓈᐹᐤ ᐧᐄᒋᒫᒑ, ᓂᒧᐃ ᑯᐃᔅᒄ ᑐᑎᐧᐋᐤ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᐅᓈᐹᒻ, ᐱᓯᐧᑳᑎᓯᐤ ᐅᔮᔨᐤ ᐋᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ᒌ ᐹᔓᐧᐋᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᐧᐋᔑᔥ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ, ᐋ ᓂᑎᐧᐋᔨᒫᒡ ᒑ ᒌ ᑖᐦᒋᓈᔨᒡ ᒑ ᒌ ᓯᐧᐋᔨᒫᔨᒡ᙮ ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒌ ᒋᔅᑎᐦᐋᒧᐧᐋᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ᐄᔥᐱᐦ ᒌᓴᔅ ᐧᐃᔮᐱᒫᑦ ᐅᔮᔨᐤ ᐋᐦᑎᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᐅᐦᑳᐦᐄᑰ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐱᒋᔅᑎᓈᐦᑯᒡ ᐊᐧᐋᔑᔑᒡ ᒑ ᒌ ᐹᒋ ᓈᓯᒡ, ᐊᑳᐧᐄ ᐅᐦᒋ ᒋᔅᑎᐦᐋᒫᑯᒡ, ᐧᐋᔥ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓃᔨᒡ ᐄᔑ ᑎᐹᔨᐦᑖᑯᓯᐧᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᒥᒄ ᐊᓐ ᐊᐧᐋᓐ ᒑᐦ ᐋᑳ ᐄᔥ ᐅᑎᓂᒧᐧᑳ ᒋᔖᒥᓂᑑ ᐆ ᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ ᒧᔮᒻ ᐊᐱᔅᑎᐧᐋᔑᔑᒡ, ᓂᒧᐃ ᓃᐦᑖ ᑭᑎ ᒌᐲᐦᒑᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ᒌ ᐅᐦᐱᓈᐤ ᐹᐦᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐊᐧᐋᔑᔥ ᐋᒄ ᑳᐦ ᐋᑎᑖᐦᑖᑳᑎᐹᓈᑦ ᑭᔮᐦ ᑳ ᒥᔪᑐᑖᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ᒫᐧᑳᒡ ᒫᒃ ᐋ ᐱᒧᐦᑖᑦ ᒌᓴᔅ ᒫᔅᑭᓈᐦᒡ, ᓈᐹᐤ ᒌ ᐅᐦᒋ ᐹᐱᐦᑖᔨᐤ ᑳᐦ ᐋᑎᐅᒋᐦᒌᐦᑯᓂᐱᐦᐧᐃᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᑳ ᒥᐧᔮᔨᐦᑖᑯᓯᔨᓐ, ᑖᓐ ᒑᑎᔮᓐ ᒑ ᒌ ᐃᔮᔮᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐧᐃᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐃᔑᓂᐦᑳᓱᔨᓐ ᑳ ᒥᐧᔮᔨᐦᑖᑯᓯᔨᓐ? ᓂᒧᐃ ᐊᐧᐋᓐ ᑖᐤ ᒥᑐᓐ ᒑ ᒌ ᒥᐧᔮᔨᐦᑖᑯᓯᔨᑦ, ᒥᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ᒋᒋᔅᒑᔨᐦᑖᓐ ᐅᐦᐄ ᐄᑎᔓᐧᐋᐧᐃᓐ, ᐊᑳᐧᐄ ᓂᐱᐦᐄᐧᐋᐦ, ᐊᑳᐧᐄ ᐱᓯᐧᑳᑎᓰᐦ, ᐊᑳᐧᐄ ᒋᒧᑦᐦ, ᐊᑳᐧᐄ ᓂᑎᐧᐄ ᒥᒄ ᐄᔑ ᐊᑖᒫᔨᒻ ᐊᐧᐋᓐ, ᐊᑳᐧᐄ ᑳᒌᔑᐦᐄᐧᐋᐦ, ᒋᔅᑖᔨᒻᐦ ᑰᐦᑖᐧᐄ ᑭᔮᐦ ᒋᑳᐧᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᑳ ᐹᒋ ᐊᐧᐋᔑᐧᐃᔮᓐ ᔖᔥ ᓂᒌ ᓂᓂᐦᐄᐦᑖᓐ ᐅᐦᐄ ᐄᑎᔓᐧᐋᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ᒌᓴᔅ ᒌ ᑭᓂᐧᐋᐱᒫᐤ ᐋ ᓵᒋᐦᐋᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐹᔨᒄ ᒑᐧᑳᓐ ᒋᓅᐦᑖᓈᓐ᙮ ᒫᒌᐦ ᓂᑑᐊᑖᐧᐋᒑ ᒥᓯᐧᐋ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᔨᓐ, ᐋᒄ ᐊᓐ ᔓᐧᐃᔮᓐ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒑ ᒥᔨᐧᑖᐤ, ᐋᒄ ᒫᒃ ᒑ ᐃᔮᔨᓐ ᒦᓯᒋᓯᐧᐃᓐ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᒌ ᑐᑎᒥᓈ ᒫᒃ ᐆ, ᐋᒄ ᒑ ᐹᒋ ᓅᔔᔥᑭᐧᐃᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᓈᔥᒡ ᒌ ᐅᐦᒋ ᒥᒑᔨᐦᑎᒨᓈᑯᓲ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ ᐋ ᒥᒑᔨᐦᑎᐦᒃ ᐧᐋᔥ ᓈᔥᑖᑆᐦ ᒌ ᒥᓯᒋᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ᐋᒄ ᒌᓴᔅ ᒥᓯᐧᐋ ᑳᐦ ᐋᑎ ᑭᓂᐧᐋᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᓄᐧᐃᒡ ᑭᑎ ᐋᔨᒥᓂᔨᐤ ᐊᓂᒌ ᑳ ᒦᓯᒋᓰᔨᒡ ᒑ ᒌ ᐲᐦᒑᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ᒌ ᑯᔥᑯᐧᐋᔨᐦᑎᒥᐦᐄᑯᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᐧᒫᐦᐄᑯᔨᒡ ᒌᓴᔅᐦ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒌ ᐋᑎ ᐊᔨᒨ ᒌᓴᔅ ᐋᐦ ᐄᑖᑦ, “ᓂᑎᐧᐋᔒᒥᑐᒄ, ᑖᑆᐦ ᓄᐧᐃᒡ ᐋᔨᒥᓂᔨᐤ ᐊᐧᐋᓐ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ᐊᑎᑎᐤ ᐋᔨᒥᓂᔨᐤ ᐊᐧᐋᓐ ᑳ ᒦᓯᒋᓰᑦ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓃᔨᒡ ᐃᔥᐱᔥ ᐊᓐ ᑳᐱᔅᐧᑳᑭᐦᒃ ᒑ ᒌ ᔖᐳᔥᑭᐦᒃ ᐋ ᐱᑯᓈᔮᐱᔅᑳᔨᒡ ᔖᐳᓂᑭᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᓄᐧᐃᒡ ᒌ ᑯᔥᑯᐧᐋᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᐋᒄ ᑳᐦ ᐃᔨᒡ, “ᐊᐧᐋᓐ ᒫᒃ ᐋᒄ ᒑ ᒌ ᐱᒫᒋᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ᒌᓴᔅ ᒫᒃ ᑯᐃᔅᒄ ᒌ ᑭᓂᐧᐋᐱᒫᐤ ᐋᐦ ᐄᑖᑦ, “ᓈᐹᐤ ᓂᒧᐃ ᒋᑭᒌᐦᑐᑎᒻ, ᒋᔖᒥᓂᑑ ᒫᒃ ᐧᐄᔨ ᒌᒃ ᒌ ᑐᑎᒻ᙮ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᐧᑳᔨᐤ ᒋᔖᒥᓂᑑ ᐋᑳ ᒑ ᒌ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ᐲᑎᕐ ᒌ ᐅᐦᒋ ᐊᔨᒨ ᐋᐦ ᐄᑖᑦ, “ᑭᓂᐧᐋᐱᐦᑦ ᒫᐦ, ᒥᓯᐧᐋ ᒑᐧᑳᓐ ᓂᒌ ᓂᑭᑖᓈᓐ ᒑ ᒌ ᓅᔔᔥᑳᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“ᐋᐦᐋ, ᑖᑆᐦ,” ᒌ ᐄᑎᑰ ᒌᓴᔅᐦ, “ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ ᒫᒃ, ᐊᓐ ᐊᐧᐋᓐ ᒑ ᓂᑭᑎᒧᐧᑳ ᐧᐄᒡ, ᑭᔮᐦ ᒫᒃ ᒑ ᓂᑭᑖᐧᑳ ᐧᐄᒋᔖᓐ, ᐧᐄᒋᔖᓂᔅᐧᑳᒻ, ᑭᔮᐦ ᒫᒃ ᐅᑳᐧᐄᐦ, ᐅᐦᑖᐧᐄᐦ, ᑭᔮᐦ ᒫᒃ ᐅᑎᐧᐋᔑᔒᒻ ᑭᔮᐦ ᒫᒃ ᒑ ᓂᑭᑎᒧᐧᑳ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ ᓃᔨ ᐅᐦᒋ ᑭᔮᐦ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ ᐅᐦᒋ, ");
INSERT INTO crl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ᒑᔅᑎᓈᔅ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᑭᑎ ᐄᔑ ᐃᔮᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒫᐧᑳᒡ ᐋᐦ ᑖᑦ᙮ ᐅᔮᔨᐤ ᑎᐦᒑ ᒥᑖᐦᑐᒥᑎᓅᐤ ᐋᔨᐧᐋᒡ ᑭᑎ ᐃᔥᐱᔥ ᒥᔮᑭᓂᐤ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᓂᑭᑎᐦᒃ, ᑭᔮᐦ ᑭᑎ ᒥᔮᑭᓂᐤ ᐧᐋᔅᑳᐦᐄᑭᓐ, ᐊᑎᑎᐤ ᐊᐧᐋᔨᐤᐦ ᒑ ᐧᐄᒋᔖᓂᑦ ᑭᔮᐦ ᒑ ᐧᐄᒋᔖᓂᔅᐧᑳᒥᑦ ᑭᔮᐦ ᒑ ᐅᑳᐧᐄᑦ, ᑭᔮᐦ ᒑ ᐅᑎᐧᐋᔑᔒᒥᑦ ᑭᔮᐦ ᐋᔨᐧᐋᒡ ᐊᔅᒌᔨᐤ᙮ ᒥᒄ ᒫᒃ, ᑭᑎ ᓂᒋᔥᑭᒻ ᐋ ᓂᓈᐦᑳᒋᐦᐋᑭᓅᑦ᙮ ᐋᔨᐤᐦ ᒫᒃ ᑳᒋᒡ ᐱᒫᑎᓰᐧᐃᓂᔨᐤ ᑭᑎ ᐃᔮᐤ ᐊᓂᑖᐦ ᐄᔥ ᓃᔥᑖᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᓃᑳᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐊᓅᐦᒡ ᐅᑖᐦᒡ ᑭᑎ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓂᐧᐃᒡ, ᐋᒄ ᐊᓂᒌ ᐅᑖᐦᒡ ᑳᐦ ᑖᒡ ᐊᓅᐦᒡ ᐧᐄᔨᐧᐋᐤ ᓃᔥᑖᒥᐦᒡ ᑭᑎ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓂᐧᐃᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐄᑐᐦᑖᐅᒡ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌᓴᔅ ᒌ ᐋᑎ ᓃᑳᓂᐦᑖᐤ᙮ ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒌ ᒥᔅᑳᑖᔨᒫᐅᒡ ᒌᓴᔅᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐧᐄᐦ ᐄᑐᐦᑖᔨᒡ ᑭᔮᐦ ᐊᓂᒌ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᑳ ᐹᒋ ᐱᒧᐦᑖᒡ ᒌ ᓵᒋᓯᐧᐃᒡ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᑐᐦᑖᒡ᙮ ᐋᒄ ᒌᓴᔅ ᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐋᒄ ᑳ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᑦ ᑖᓐ ᒑ ᐄᔅᐱᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“ᓂᑎᐦᑎᒧᒄ ᒫᐦ,” ᒌᐦ ᐄᑖᐤ, “ᒋᕉᓯᓕᒥᐦᒡ ᒋᑎᐄᑐᐦᑖᓈᓂᐤ, ᐋᑯᑖᐦ ᐅᑖᐦ ᒑ ᐅᑎᓈᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓅᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᑭᔮᐦ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᑦ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᒑ ᐄᑎᔓᐧᐋᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᒑ ᐄᔑ ᐱᒋᔅᑎᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ᐋᐅᑯᓂᒡ ᐅᒌ ᒑ ᒫᔮᔨᒫᒡ ᑭᔮᐦ ᒑ ᓯᐦᐧᑳᑖᒡ, ᑭᔮᐦ ᒑ ᐱᐱᓯᔅᑖᐦᐧᐋᒡ, ᐋᒄ ᒫᒃ ᒑ ᓂᐱᐦᐋᒡ᙮ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᐅᑎᐦᒋᐱᔨᔨᒑ ᒦᓐ ᑳᐤ ᒑ ᐧᐃᓂᔥᑳᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ᐄᔥᐱᐦ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ, ᒌ ᐹᒋ ᓈᑎᑰ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ, ᐊᓂᔮᔨᐤ ᓭᐱᑏ ᐅᑯᓯᓯᔨᐤᐦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᓂᑎᐧᐋᔨᒥᑎᓈᓐ ᒑ ᒌᐦ ᑐᑎᒧᔮᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᐱᑯᓵᔨᒥᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ᒌ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, “ᒑᐧᑳᓐ ᒫᒃ ᐊᓐ ᓈᑎᐧᐋᔨᐦᑎᒫᒄ ᒑ ᒌ ᑐᑎᒫᑎᑯᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ᑳᐦ ᐄᑖᒡ, “ᐱᒋᔅᑎᓈᓐ ᒫᐦ ᐊᓂᑖᐦ ᑳ ᒋᔅᑖᔨᐦᑖᑯᐦᒡ ᒋᒋᐦᒋᐅᒋᒫᐧᐃᓂᐦᒡ ᑖᔮᐦᒑ ᐄᑑ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᓐ ᒑ ᒌ ᐊᐱᔮᐦᒡ, ᐹᔨᒄ ᒌ ᓂᐦᐄᐧᐃᓂᐦᒡ ᑭᔮᐦ ᐹᔨᒄ ᐊᓂᑖᐦ ᒌ ᓂᒥᐦᒌᐧᐃᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ᒥᒄ ᒫᒃ ᒌᓴᔅᐦ ᒌ ᐄᑎᑰᒡ, “ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᐆ ᒑᐧᑳᓐ ᑳ ᓂᑎᐧᐋᔨᐦᑎᒫᒄ᙮ ᒋᑭ ᒌᐦ ᑎᓈᐧᐋᐤ ᐋ ᒑ ᒌ ᒥᓂᐦᐧᑳᔮᒄ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᐦᒡ ᓂᒥᓂᐦᐧᑳᑭᓂᒡ ᒫᓂᐦᐧᑳᔮᓐ? ᒋᑭ ᒌᐦ ᑎᓈᐧᐋᐤ ᐋ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑯᐧᐃᔮᒄ ᒧᔮᒻ ᓃᔨ ᑖᓐ ᒑ ᐄᔑ ᓰᑭᐦᐋᐦᑖᑭᐧᐃᔮᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᓂᑭ ᒌᐦ ᑐᑖᓈᓐ᙮” ᐋᒄ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᒡ, “ᐊᓐ ᒑ ᐄᔑ ᒥᓂᐦᐧᑳᔮᓐ ᐋᐅᒄ ᑭᔮᐦ ᒌᔨᐧᐋᐤ ᒑ ᐄᔑ ᒥᓂᐦᐧᑳᔮᒄ, ᒋᑭ ᐹᔨᑯᐦᑖᓈᓂᐤ ᐊᓐ ᒥᓂᐦᐧᑳᑭᓐ᙮ ᑭᔮᐦ ᐊᓐ ᓰᑭᐦᐋᐦᑖᒑᐧᐃᓐ ᒑ ᓰᑭᐦᐋᐦᑖᑭᐧᐃᔮᓐ ᐋᐅᒄ ᐊᓐ ᑭᔮᐦ ᒌᔨᐧᐋᐤ ᒑ ᓰᑭᐦᐋᐦᑖᑯᐧᐃᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓃᔨ ᓂᑭ ᒌᐦ ᐧᐃᔮᔨᒫᐤ ᐊᐧᐋᓐ ᒑ ᐊᐱᑦ ᐊᓂᑖᐦ ᓂᓂᐦᐄᐧᐃᓂᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᓂᓂᒥᐦᒌᐧᐃᓂᐦᒡ, ᐧᐋᔥ ᔖᔥ ᒌ ᐧᐃᔮᔨᒫᑭᓂᐧᐃᒡ ᐄᔨᔨᐅᒡ ᒑ ᐊᐱᐧᐃᒡ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑯᑎᑭᒡ ᒥᑖᐦᑐ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᐱᔮᐦᑎᐧᐋᒡ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑯᐧᑳᒋᐦᒑᒧᔨᒡ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ, ᒌ ᒋᔑᐧᐋᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ᐋᒄ ᒌᓴᔅ ᒥᓯᐧᐋ ᑳ ᓂᑑᒫᑦ ᑳᐦ ᐄᑖᑦ, “ᐊᓂᒌ ᑳ ᐅᒋᒫᐅᒡ ᑳ ᐄᑖᔨᒫᑭᓂᐧᐃᒡ ᓈᔥᒡ ᐧᐄᐦ ᑭᑎᐹᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐧᐋᒡ᙮ ᐅᒌ ᒫᒃ ᑳ ᐅᒋᒫᐅᒡ ᒥᑐᓐ ᐧᐃᔨᔓᐧᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ᒥᒄ ᒫᒃ ᐊᑳᐧᐄ ᒋᑭ ᐅᐦᒋ ᐃᓯᓈᑯᓯᓈᐧᐋᐤ ᒌᔨᐧᐋᐤ᙮ ᐊᓐ ᐊᐧᐋᓐ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᓈᑎᐧᐋᔨᐦᑎᒧᐧᑳ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐋᑯᔥ ᒋᑭ ᐱᒋᔅᑎᓃᓱᐤ ᒑ ᒌ ᐋᐱᑎᔒᔥᑖᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ᐋᒄ ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐧᐄᐦ ᓃᑳᓂᐦᐄᓱᑦ ᐋᐅᒄ ᒥᓯᐧᐋ ᐋ ᑎᔑᔮᒄ ᒑ ᐅᑎᐱᒋᐦᐋᑭᓂᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ᒧᔮᒻ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᒧᐃ ᐅᐦᒋ ᐹᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᐋᐱᑎᔒᔥᑑᐧᐋᑭᓅᑦ, ᒌ ᑎᑯᔑᓐ ᒑ ᒌ ᐋᐱᑎᔒᔥᑎᐧᐋᑦ ᐄᔨᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᒌ ᑎᑯᔑᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒃ ᐅᐱᒫᑎᓰᐧᐃᓐ ᒦᔥᑯᒡ ᒥᐦᒑᑐ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᐱᑯᐦᐄᒫᑭᓂᐧᐃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ᒌ ᐅᑎᐦᑎᒧᒡ ᐃᐦᑖᐧᐃᓂᔨᐤ ᒉᕆᐧᑳᐤ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐧᐃᔨᐧᐄᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᑭᔮᐦ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ, ᒌ ᐅᑎᐦᑖᐅᒡ ᓈᐹᐤ ᐊᓂᑖᐦ ᐱᑐᑖᔅᑭᓂᐤ ᐋ ᐊᐱᔨᒡ᙮ ᐆ ᒫᒃ ᓈᐹᐤ ᓂᒧᐃ ᐅᐦᒌ ᐧᐋᐱᐦᑎᒻ ᑭᔮᐦ ᒫᒃ ᒌ ᓂᑑᑎᒫᐤ ᔓᐧᐃᔮᓐ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᐊᐱᑦ᙮ ᐹᕐᑎᒫᔭᔅ ᒌ ᐃᔑᓂᐦᑳᓲ᙮ ᑎᒫᔮᔅ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᐦᑖᐧᐄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒃ ᒌᓴᔅᐦ ᐋ ᑎᑯᔑᓃᔨᒡ, ᐊᓂᔮᔨᐤ ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᔨᒡ, ᒌ ᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, “ᒌᓴᔅ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ᒥᐦᒑᑐ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᒌ ᒋᔅᑎᐦᐋᒫᐦᒄ ᐋᐦ ᐄᑎᑯᑦ ᒑᐦ ᐋᑳ ᒋᔅᑐᑦ᙮ ᐋᐦᒡ ᒫᒃ ᐊᑎᑎᐤ ᓲᐦᒃ ᒌ ᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, “ᒌᓴᔅ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᐱᐦᒋᑳᐳ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᑑᒫᐦᒄ᙮” ᐋᒄ ᑳ ᑖᑆᑖᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᑳ ᑳ ᐧᐋᐱᐦᑎᒥᔨᒡ ᐋᐦ ᐄᑖᒡ, “ᒥᐧᔮᔨᐦᑦ, ᐱᔑᑰᐦ, ᒋᑖᑆᑎᒄ ᐧᐋᔥ ᐊᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ᒌ ᒥᓂᐧᐋᐱᓂᒻ ᐊᓂᔮᔨᐤ ᐅᑎᑯᐦᑉ ᐋᒄ ᑳ ᐱᔑᑯᔑᐱᐦᑖᑦ ᑳ ᓂᑎᐧᐋᐱᒫᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐅᔮᔨᐤ ᓈᐹᐤ, “ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᒥᓐ ᒑ ᒌ ᑐᑎᒫᑖᓐ?” ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒥᔨᐦ ᒑ ᒌ ᐧᐋᐱᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒫᒌᐦ, ᒋᑖᑆᔮᔨᐦᑎᒧᐧᐃᓐ ᒋᒦᓂᐧᐋᒋᐦᐄᑯᓐ᙮” ᐊᓐ ᒫᒃ ᓈᐹᐤᐦ ᑏᐧᐋᐦᒡ ᒌ ᐅᐦᒋ ᐧᐋᐱᐦᑎᒻ, ᐋᒄ ᑳ ᓅᔔᔥᑯᐧᐋᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒋᐧᐄᐦ ᐄᑐᐦᑖᐅᒡ᙮ ᐄᔥᐱᐦ ᐋᑎ ᐹᐧᔖᐱᐦᑎᐦᒡ ᒌ ᐅᑎᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔥ ᐯᑖᓃ ᑭᔮᐦ ᐯᕪᐯᐃᒡ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐊᓂᑖᐦ ᐊᓕᕝ ᐋᐱᔅᑯᑎᓈᐦᒡ ᐋᑯᑖᐦ ᑳ ᑎᐦᑯᐦᒡ ᐅᐦᐄ ᐃᐦᑖᐧᐃᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᒌᓴᔅ ᑳ ᓃᑳᓂᑎᔑᐦᐧᐋᑦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ᓈᑖᐦ ᐄᑐᐦᑖᒄ ᐊᓐ ᐃᐦᑖᐧᐃᓐ᙮ ᑎᑯᔑᓂᔮᐧᑳ ᓈᑖᐦ ᒋᑭ ᐧᐋᐱᒫᐧᐋᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔅᐦ ᐋ ᒋᓯᑳᐱᐦᑳᓱᑦ ᐋᐦᐋᑳ ᓂᐦᑖ ᐋᔥᒄ ᐅᐦᒋ ᑖᐦᑎᐱᔨᒡ ᐊᐧᐋᔨᐤᐦ ᐅᔅᐱᔅᑯᓂᐦᒡ᙮ ᒑ ᐋᐱᐦᑯᓈᒄ ᐋᒄ ᒑ ᐹᔓᐧᐋᒄ ᐅᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ᑯᐧᑳᒋᒥᑖᐧᑳ ᐊᐧᐋᓐ ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐋᐱᐦᑯᓂᒫᒄ ᐋᒄ ᒑ ᐄᑖᒄ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᑎᐧᐋᔨᒫᐤ ᒦᓐ ᑭᑎ ᐹᒋ ᒌᐧᐋᑎᔑᐦᐧᐋᐤ᙮’ ᑏᐧᐋᐦᒡ ᒫᒃ ᒋᑭ ᓂᐦᐋᔨᒥᑯᐧᐋᐤ ᒑ ᒌ ᐅᑎᓂᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ ᑳ ᒥᔅᑭᐧᐋᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ᙮ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐧᐋᔅᑳᐦᐄᑭᓂᒡ ᐋ ᒋᓯᑳᐱᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᐧᑳᒡ ᐋᐦ ᐋᐱᐦᑯᓈᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ ᒌ ᐹᒋ ᓈᓃᐴᔨᐤ ᐊᐧᐋᔨᐤᐦ ᐋ ᑭᓂᐧᐋᐱᒥᑯᒡ, ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᑖᓐ ᐋᐃᐦᑎᔮᒄ ᐧᐋᐦᒋ ᐋᐱᐦᑯᓈᒄ ᐊᓐ ᐋᐦᐋᓯᔅ?” ");
INSERT INTO crl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ᐋᒄ ᐋᑖᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ ᒑ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᑖᒡ ᐋᒄ ᑳ ᓂᐦᐋᔨᒥᑯᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᒋᔅᑐᐦᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ᐋᒄ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐅᔮᔨᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ, ᑳ ᓯᐧᑖᑭᔥᑖᒡ ᐅᑎᑯᐦᐱᐧᐋᐤ ᐊᓂᑎᐦ ᐅᔅᐱᔅᑯᓃᔨᐦᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ, ᐋᒄ ᒌᓴᔅ ᑳ ᑖᐦᑎᐳᐧᐋᑦ ᐅᔅᐱᔅᑯᓃᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ ᒌ ᐄᔑ ᓯᐧᑖᑭᔥᑖᐅᒡ ᐅᑎᑯᐦᐱᐧᐋᐤ ᐊᓂᑎᐦ ᒑ ᐋᑎ ᐱᒧᐦᑎᐦᐄᑯᔨᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ, ᐋᒄ ᑯᑎᑭᒡ ᓃᐱᓰᔮᐦᑎᒄ ᒌ ᓈᓈᐧᑖᓂᒧᒡ ᐋᒄ ᐊᓂᑎᐦ ᒫᔅᑭᓈᐦᒡ ᑳ ᐊᔥᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᓃᑳᓂᐦᒡ ᑭᔮᐦ ᐊᓂᒌ ᐅᑖᐦᒡ ᑳ ᐹᒋ ᐱᒧᐦᑖᒡ ᒌ ᑖᑆᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᒫᒥᐦᒋᒫᑖᐤ ᑳᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ᙮ ᔑᐧᐋᔨᐦᑖᑯᓯᐤ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᐅᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ᔑᐧᐋᔨᐦᑖᑯᓯᐤ ᐊᓐ ᑖᐹᔨᐦᒋᒑᑦ, ᐊᓐ ᐊᓂᔮ ᒋᑖᓂᔅᒑ ᒋᒧᔓᒥᓂᐤ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᑦ᙮ ᒫᒥᐦᒋᒫᑖᐤ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑖᑯᔑᐦᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐲᐦᒑᐤ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᒥᓯᐧᐋ ᐊᓂᑖᐦ ᐧᐋᔅᑳ ᑳ ᐄᑖᐱᑦ ᐋ ᑭᑭᓄᐧᐋᐱᐦᑎᐦᒃ ᒑᐧᑳᔨᐤ᙮ ᔖᔥ ᒫᒃ ᒌ ᐋᑎ ᐅᑖᑯᔑᔨᐤ ᐋᒄ ᐊᓂᑖᐦ ᐯᑎᓃᐦᒡ ᑳ ᐄᑐᐦᑖᑦ ᐋ ᐧᐄᒑᐅᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ᒦᓐ ᐧᐃᔮᐱᓃᔨᒡ ᒫᐧᑳᒡ ᐋ ᐱᒧᐦᑖᒡ ᐯᑎᓃᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ, ᑳᐦ ᓰᐆᑖᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ᒌ ᐧᐋᐱᒫᐤ ᓈᑖᐦ ᐧᐋᐦᐄᐧᐃᔥ ᐋ ᒋᒥᓱᔨᒡ ᒥᓯᔔᒥᓈᐦᑎᒄ ᐋ ᓃᐱᓰᐧᐃᔨᒡ᙮ ᑳ ᓈᑖᑦ ᐋ ᐧᐄᐦ ᓂᑐᒋᔅᒑᔨᒫᑦ ᒥᓂᔑᐧᐃᔨᐧᑳᓂᐦᐄ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᑎᐦᑖᑦ ᒥᒄ ᓃᐱᓰ ᒌ ᐧᐋᐱᐦᑎᒻ ᐧᐋᔥ ᑖᐹ ᐋᔥᒄ ᐅᐦᒋ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᑳ ᒌ ᒦᓂᔑᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ᒌ ᐊᔨᒥᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒥᔥᑎᒄ ᑳᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᒑ ᐃᓯᓈᑯᓯᔨᓐ, ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᓂᐦᑖᐅᒋᓐ ᒦᓂᔥ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᓐ ᒑ ᒌ ᒦᒋᒡ ᐄᔨᔨᐅᒡ᙮” ᒌ ᐹᐦᑖᑰ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒥᔥᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ᐄᔥᐱᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑖᑯᔑᐦᒡ ᐋᒄ ᑳ ᐲᐦᒑᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᑳᐦ ᐋᑎᐧᐋᐦᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᑦ ᐊᓂᔮᔨᐤ ᐊᑖᐧᐋᓯᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐅᑎᓂᒑᔨᒡ ᐊᓂᑎᐦ ᐲᐦᑎᑭᒥᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ᒌ ᑯᑎᐳᐧᐋᐱᓂᐧᒫᐤ ᐅᒦᒋᓲᓈᐦᑎᑯᔨᐤ ᐊᓂᔮᔨᐤ ᔓᐧᐃᔮᓐ ᑳ ᒦᔅᑯᑑᓈᔨᒡ ᑭᔮᐦ ᐋᔪᐧᐃᒄ ᑳᐦ ᑐᑎᒧᑦ ᐅᑖᐦᑎᐱᐧᐃᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐱᔮᓯᐤ ᐅᒦᒦᐤ ᑳ ᐊᑖᐧᐋᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ᒌ ᒋᐱᒋᐦᐋᐤ ᑭᔮᐦ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᔖᐳᐦᑎᐧᐋᐦᑖᔨᒡ ᒑᐧᑳᔨᐤ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᒫᒃ, ᐋᐦ ᐄᑖᑦ, “ᐄᑎᓯᓈᑖᐤ ᒋᔖᒥᓂᑑ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡᐦ, ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᑭᑎ ᐃᔑᓂᐦᑳᑖᐤ ᓂᐧᐋᔅᑳᐦᐄᑭᓂᒻ, ᐊᓂᑖᐦ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ ᒑ ᒌ ᐊᔨᒥᐦᐋᑦ? ᒌᔨᐧᐋᐤ ᒫᒃ ᒧᔮᒻ ᒋᒧᑎᔅᑭᒡ ᐆ ᒫᒨᐧᐃᔨᔫᑭᒥᑯᐧᐋᐤ ᐋᔪᐧᐃᒄ ᐋ ᐃᓯᓈᑯᐦᑖᐧᐋᒄ ᒋᔖᒥᓂᑑ ᐅᐧᐋᔅᑳᐦᐄᑭᓂᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒌ ᐹᐦᑎᒧᒡ ᐅᔮᔨᐤ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ᙮ ᐋᒄ ᑳ ᓈᓂᑐ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᒑ ᒌ ᑎᒡ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᓂᐱᐦᐄᒫᑭᓂᐧᐃᔨᐦᒡ ᒌᓴᔅᐦ ᒥᒄ ᒫᒃ ᒌ ᑯᔅᑖᐅᒡ᙮ ᐧᐋᔥ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᒌ ᒥᔅᑳᔥᑎᒥᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᑖᑯᓰᔨᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᓂᑭᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ᐧᐄᐱᒡ ᒦᓐ ᐧᐃᔮᐱᓃᔨᒡ ᒫᐧᑳᒡ ᐋ ᐱᒧᐦᑖᒡ ᒫᔅᑭᓈᐦᒡ ᒌ ᐧᐋᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒥᓯᔔᒥᓈᐦᑎᒄ ᒥᑐᓐ ᓈᔥᑎᔨᒡ ᐋ ᓂᐱᔨᒡ, ᐧᐋᐧᐋᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐲᔨᐤᐦ ᐋ ᓂᐲᒥᑭᓃᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ᐲᑎᕐ ᒫᒃ ᒌ ᒋᔅᒋᓯᐤ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᐅᐦᒋ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐄᑖᐱᐦ ᒫᐦ᙮ ᐆ ᒥᓯᔔᒥᓈᐦᑎᒄ ᑳᐦ ᐋᐧᓈᔨᒥᑦ ᒥᑐᓐ ᐹᔔ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ, “ᑖᑆᔮᔨᒫᐦᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᐊᐧᐋᓐ ᒑ ᒌ ᐄᑎᔓᐧᐋᑎᒧᐧᑳ ᐅᔮᔨᐤ ᐋ ᐱᔅᐧᑳᐱᔅᑳᔨᒡ, ᐱᓯᑰ, ᐋᒄ ᐊᓂᑖᐦ ᒋᐦᒋᑭᒦᐦᒡ ᒑ ᐄᔑ ᐧᐋᐱᓂᓱᔨᓐ, ᐋᑳ ᒫᒃ ᒥᑐᓐ ᐋᐧᓈᑎᐦᑳ ᐅᑖᐦᐄᒡ ᑖᑆᐦ ᒑ ᒌ ᐄᔅᐱᔨᒡ ᐅᔮᔨᐤ, ᒥᑐᓐ ᑖᑆᐦᑎᐦᑳ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒑ ᐄᔅᐱᔨᒡ, ᐋᔪᐧᐃᒄ ᒑ ᑐᑎᒧᐧᐋᑭᓅᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ᐋᐅᒄ ᒫᒃ ᐋ ᑎᑎᑯᒡ, ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑐᑎᒫᐧᐋᐧᑳ ᐋ ᐊᔨᒥᐦᐋᔮᒄ, ᑖᑆᐦᑎᒧᒄ ᔖᔥ ᐋ ᐃᔮᔮᒄ ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑯᐧᐃᔮᒄ ᐊᓐ ᑳ ᐄᔑ ᓂᑐᑎᒫᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ᑭᔮᐦ ᒫᒃ ᑖᐧᑖᐤ ᓃᐴᐧᐃᔨᓈ ᐋ ᐊᔨᒥᐦᐋᔨᓐ, ᐧᐋᐹᔨᐦᑎᒨ ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐧᐃᓂᑐᑖᔅᒃ, ᐋᒄ ᒫᒃ ᑰᐦᑖᐧᐄ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᑭᔮᐦ ᐧᐄᔨ ᒑ ᐧᐋᐹᔨᐦᑎᒫᔅᒃ ᒋᒥᒋᐦᐧᑖᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","ᐋᑳ ᐧᐋᐹᔨᐦᑎᒫᒑᔨᓈ ᓂᒧᐃ ᑭᔮᐦ ᐧᐄᔨ ᑰᐦᑖᐧᐄ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᑭ ᐅᐦᒋ ᐧᐋᐹᔨᐦᑎᒫᒄ ᒋᒥᒋᐦᐧᑖᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ᒦᓐ ᑳᐤ ᒌ ᑎᑯᔑᓂᒡ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐋ ᐱᒧᐦᑖᑦ ᒫᒃ ᒌᓴᔅ ᐊᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒌ ᓂᑎᐧᐋᐱᒥᑰ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐧᐋᔨᒡ ᒎᐄᔨᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᓐ ᐋᐦᑎᔨᓐ ᐆ? ᐊᐧᐋᓐ ᑳᐦ ᐄᑎᔓᒥᔅᒃ ᒑ ᒌ ᑐᑎᒥᓐ ᐅᐦᐄ ᒑᐧᑳᓂᐦᐄ?” ");
INSERT INTO crl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᒋᑭ ᑯᐧᑳᒋᒥᑎᓈᐧᐋᐤ ᒑᐧᑳᓐ, ᒑ ᐹᒋ ᓂᔥᐧᑳᐅᔑᐦᐄᔮᒄ, ᐋᒄ ᒫᒃ ᒑ ᐧᐄᐦᑎᒫᑎᑯᒡ ᑖᓂᑖᐦ ᐧᐋᐦᒋᐱᔨᒡ ᐆ ᑎᐹᔨᐦᒋᒑᐧᐃᓐ ᑳ ᐃᔮᔮᓐ ᒑ ᒌ ᑐᑎᒫᓐ ᐅᐦᐄ ᒑᐧᑳᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ᒞᓐ ᒫᐦ ᑳ ᓰᑭᐦᐋᐦᑎᐧᐋᑦ ᐊᐧᐋᔨᐤᐦ, ᐊᐧᐋᔨᐤᐦ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᒑᑦ, ᒋᔖᒥᓂᑑ ᐋ ᑭᔮᐦ ᒫᒃ ᓈᐹᐤ? ᐧᐄᐦᑎᒨᒄ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ᒌ ᐅᔥᑖᐱᔫᒡ ᒫᒃ ᐊᓂᑎᐦ ᐧᐄᔨᐧᐋᐤ, ᐋᐦ ᐃᔨᒡ, “ᐄᔨᔨᐧᑳ, ‘ᒋᔖᒥᓂᑑ ᒌ ᐄᑎᑰ,’ ᒋᑭ ᐄᑎᑯᓂᐤ, ‘ᒑᐧᑳᔨᐤ ᒫᒃ ᐧᐋᒋ ᐋᑳ ᐅᐦᒋ ᑖᑆᐦᑎᐧᐋᒄ?’ ");
INSERT INTO crl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ᒋᑭ ᐄᑖᓂᐤ ᐋ ᒫᒃ, ‘ᓈᐹᐤ ᑳᐦ ᐄᑎᑯᑦ᙮’ ” ᒌ ᐧᐋᐧᐋᓈᔨᐦᑎᒧᒡ ᑖᓐ ᒑ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᐋᒡ ᐋ ᒌ ᑯᔥᑖᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ᐧᐋᔥ ᒥᓯᐧᐋ ᒌ ᑖᑆᐦᑎᒥᔨᐤ ᑖᑆᐦ ᐋ ᒌ ᒋᔅᒋᐧᐋᐦᐄᒑᓯᐧᐃᔨᒡ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒌᓴᔅᐦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐊᐧᐋᔨᐤᐦ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᒞᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐧᐋᑦ ᐊᐧᐋᔨᐤᐦ᙮” ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᑭᔮᐦ ᓃᔨ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ ᐊᐧᐋᓐ ᑳ ᐹᒋ ᐄᑎᔓᒥᑦ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᑐᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ᒌᓴᔅ ᒌ ᐋᑎ ᐧᐄᐦᑎᒧᐧᐋᐤ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐧᐃᓂᔨᐤ᙮ ᒌᐦ ᐄᑖᐤ, “ᒌᐦ ᑖᐤ ᓈᐹᐤ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᐋ ᒌ ᓂᐦᑖᐅᒋᐦᐋᑦ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ᒌ ᒋᐱᐦᐊᒻ ᒫᒃ ᒥᓯᐧᐋ ᐧᐋᔅᑳ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ᙮ ᑭᔮᐦ ᒌ ᒨᓈᐅᐦᑭᐦᐊᒻ ᐊᓂᑎᐦ ᒑ ᐹᐱᒋᔅᒋᔥᑳᑭᓂᐧᐄᔨᒡ ᐊᓂᔮᔨᐤ ᒦᓂᔥ᙮ ᒌ ᐅᔑᐦᑖᐤ ᑭᔮᐦ ᓂᑎᐧᐋᐲᐅᑭᒥᑯᔨᐤ ᐊᓂᑎᐦ ᒑ ᐅᐦᒋ ᓈᓈᑭᒋᐦᑖᑭᓂᐧᐃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᑐᐦᑎᒃ ᒌ ᓈᓂᑐᐧᐋᐱᒫᐤ ᐊᐧᐋᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ, ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᑦ, ᐧᐋᐦᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᔅᒌᔨᐤ ᑳᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᑎᐦᒋᐱᔨᒡ ᒑ ᒫᒨᔑᒋᓂᑭᓂᐧᐄᔨᒡ ᐊᓂᔮᔨᐤ ᒦᓂᔥ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ ᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᒌ ᐄᑎᔑᐦᐧᐋᐤ ᐹᔨᒄ ᐋᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᓂᑎᐧᐋᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᒑ ᒌ ᒥᔨᑯᑦ ᐊᓂᔮᔨᐤ ᐧᐄᔨ ᒑ ᐄᔑ ᐃᔮᑯᐱᓈ ᐋᓐ ᐅᒋᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ᐊᓂᒌ ᒫᒃ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᒌ ᐅᑎᓈᐅᒡ ᐅᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ ᐋᒄ ᑳ ᑯᓰᐦᑯᐧᐋᒡ, ᑳᐦ ᐋᑎ ᒋᐦᒋᑎᔑᐦᐧᐋᒡ ᐋᐦᐋᑳ ᒑᐧᑳᔨᐤ ᒥᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ᐋᒄ ᐊᓐ ᐅᒋᒫᐤ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑳᐦ ᐄᑎᔑᐦᐧᐋᑦ ᐊᓂᑖᐦ᙮ ᐋᒄ ᑳ ᒥᐧᔖᑭᓂᐦᑳᑖᒫᑭᓂᐧᐃᔨᒡ ᐅᔮᔨᐤ ᓈᐹᐤ ᐅᔥᑎᐧᑳᓃᔨᒡ ᐋ ᒌ ᐧᐃᔮᔥᑐᑖᒫᑭᓂᐧᐃᔨᒡ, ᑭᔮᐦ ᒫᒃ ᒌ ᒫᔮᔨᒫᑭᓂᐧᐃᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑳᐦ ᐄᑎᔑᐦᐧᐋᑦ ᐊᓐ ᐅᒋᒫᐤ, ᐋᔨᐅᑯᓐ ᐋᒄ ᐅᔮᔨᐤ ᑳ ᓂᐱᐦᐋᔨᒡ᙮ ᐋᔪᐧᐃᒄ ᑳᐦ ᑐᑎᐧᐋᒡ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᑳ ᐄᑎᔓᐦᐅᒫᑭᓂᐧᐃᔨᒡ ᐊᓂᑖᐦ ᐋᐦᑖᐦᒡ, ᐱᔅᒡ ᒌ ᑯᓰᐦᑭᐧᐋᐅᒡ, ᐋᒄ ᐱᔅᒡ ᑳ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ᒑᒃ ᒥᒄ ᐹᔨᒄ ᓈᐹᐤ ᑳᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐊᓐ ᐅᒋᒫᐤ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑎᐱᔨᐧᐋ ᐅᑯᓯᔅᐦ ᓈᔥᒡ ᑳ ᓵᒋᐦᐋᑦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔑᐦᐧᐋᑦ ᒑᒃ, ᐋ ᐄᑖᔨᐦᑎᐦᒃ, ‘ᒋᑭ ᒋᔅᑖᔨᒫᐅᒡ ᐅᔮᔨᐤ ᓂᑯᔅ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᒌ ᐄᑎᑐᒡ, ‘ᐋᐅᒄ ᐆ ᒑ ᐋᔔ ᒥᔮᑭᓅᑦ ᐋᔥᒄ ᐊᓂᑖᐦ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ, ᐋᔥᑎᒧᒄ, ᓂᐱᐦᐋᑖᐤ, ᒌᔮᓂᐤ ᒦᔥᑯᒡ ᒑ ᐋᔔ ᒥᔨᑯᐧᐃᔨᐦᒄ ᐆ ᐊᔅᒌ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ᒌ ᐅᑎᓈᐅᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐋᒄ ᑳ ᓂᐱᐦᐋᒡ, ᑳ ᐧᐃᔨᐧᐄᐧᐋᐱᓈᒡ ᐊᓂᑎᐦ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“ᑖᓐ ᒫᒃ ᒑᑎᒃ ᐊᓐ ᑳ ᑎᐱᔨᐧᐋᐧᐃᓰᑦ ᐅᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ? ᑭᑎ ᓂᑎᐧᐋᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᔮᔨᐤ ᐅᑎᔅᒌ, ᐋᒄ ᒑ ᓂᐱᐦᐋᑦ᙮ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᒑ ᒥᔮᑦ ᐅᔮᔨᐤ ᐅᑎᔅᒌ ᒑ ᓈᓈᑭᒋᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ᓂᒧᐃ ᐋ ᑰᐦᒋ ᐊᔨᒥᐦᑖᓈᐧᐋᐤ ᐊᓂᑎᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᒡ? ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᑳᐦ ᐋᐱᑎᓰᔨᒡ ᐧᐋᒋᐦᒡ ᐊᓂᑎᐦ ᐋ ᒌᐦᒑᔮᔨᒡ ᐊᓂᒌ ᑳ ᐧᐋᔅᑳᐦᐄᑭᓂᐦᒑᒡ ᒌ ᐋᑎᐧᐋᔨᒫᐧᐋᐦᑎᐧᐋᑯᐱᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᐃᐦᑐᐧᐃᓐ, ᓄᐧᐃᒡ ᒥᔅᑳᑖᔨᐦᑖᑯᓂᔨᐤ ᐋ ᑭᓂᐧᐋᐱᐦᑖᑭᓂᐧᐃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᑳᓃᑳᓂᓰᔨᒡ ᒋᓂᔅᑐᐦᑎᐧᐋᐅᒡ ᐧᐄᔨᐧᐋᐤ ᐋ ᒌ ᐋᔨᒧᒥᑯᒡ ᒌᓴᔅᐦ, ᒋᐧᐄᐦ ᐅᑎᓈᐧᐃᒡ᙮ ᒥᒄ ᒫᒃ ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ᙮ ᐋᒄ ᐄᔨᐧᐋ ᑳ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ᒌ ᐄᑎᔑᐦᐧᐋᑭᓂᐧᐃᔨᒡ ᐱᔅᒡ ᐹᕆᓰᒡ ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᒌ ᐦᐁᕆᑦ ᑳ ᓅᔔᔥᑯᐧᐋᒡ ᐊᓂᑖᐦ ᒌᓴᔅ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᓈᓂᑐ ᑳᐦᒋᔥᑎᓈᒡ ᐋᑳ ᒧᔮᒻ ᒑ ᒌ ᐄᔨᔨᒡ ᒑᐧᑳᔨᐤ᙮ ᓂᓈᐦᑭᐤ ᒑᐧᑳᔨᐤ ᒌ ᐄᔑ ᑯᐧᑳᒋᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ᒌ ᐹᒋ ᓂᑎᐧᐋᐱᒫᐅᒡ ᒫᒃ, ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᒨᔥ ᐋ ᑖᑆᔨᓐ ᑖᓐ ᐊᓐ ᐃᔮᔨᓐ᙮ ᓂᒧᐃ ᐧᐃᔮᔅ ᐊᐧᐋᓐ ᐊᓐ ᑳ ᐊᔨᒥᐦᐄᑦ ᐧᐋᔥ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᐹᔨᑯᓂᐦᒡ ᒋᑎᐄᑖᔨᒫᐤ᙮ ᓂᒧᐃ ᒌ ᑭᓂᐧᐋᐱᐦᑎᐧᒫᓐ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐊᐧᐋᓐ᙮ ᑯᐃᔅᒄ ᑭᔮᐦ ᒌ ᒋᔅᑯᑎᒧᐧᐋᐅᒡ ᐄᔨᔨᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐧᐋᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ᐄᑎᔥᑖᐤ ᐋ ᒎᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᐦᒡ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᐊᓂᔮᔨᐤ ᔓᐧᐃᔮᓐ ᑳ ᑎᐱᐦᐄᒑᔨᒡ ᐊᐧᐋᔨᐤᐦ?” ");
INSERT INTO crl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ᓂᐱᐦ ᑎᐱᐦᐄᒑᓈᓐ ᐋ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᒑ ᑎᐱᐦᐄᒑᐧᐋᒑ? ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᐋ ᐧᐄᐦ ᑳᒋᔅᑎᓂᑯᑦ ᐅᔮᔨᐤ ᐧᐋᒋ ᐄᔑ ᑯᐧᑳᒋᒥᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐧᐄᐦ ᐹᒋ ᑯᐧᑳᒋᐦᐄᔮᒄ? ᐹᔓᐧᐋᐦᒄ ᒫᐦ ᔓᐧᐃᔮᓈᐱᔅᑯᔥ, ᓂᑭ ᐧᐋᐱᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ᑳ ᒥᔮᒡ ᐹᔨᒄ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᐧᐋᓐ ᒫᒃ ᐅᑖᔥᑎᒥᐦᒄ ᓅᑯᓃᔨᒡ ᐅᑎᐦ ᑭᔮᐦ ᐊᐧᐋᓐ ᐅᔮᔨᐤ ᐅᑎᔑᓂᐦᑳᓱᐧᐃᓐ ᒫᓯᓈᑖᔨᒡ᙮” ᒌ ᐄᑖᐅᒡ, “ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐊᓂᔮᔨᐤ ᐅᑖᔥᑎᒥᐦᒄ ᑭᔮᐦ ᐧᐄᔨ ᐊᓂᑎᐦ ᒥᓯᓈᓲ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᒥᔮᐦᒄ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᑖᓂᔮᔨᐤ ᐧᐄᔨ ᑎᐱᔨᐧᐋᐅᓯᑦ, ᑭᔮᐦ ᒫᒃ ᒥᔮᐦᒄ ᒋᔖᒥᓂᑑ ᑖᓂᔮᔨᐤ ᐧᐄᔨ ᑎᐱᔨᐧᐋᐅᓯᑦ᙮” ᓄᐧᐃᒡ ᒫᒃ ᒌ ᒫᒥᔥᑳᓯᑐᐧᐋᐅᒡ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ᐱᔅᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᓵᑎᔫᓰ ᑳᐦᐄᔑᓂᐦᑳᑖᑭᓂᐧᐃᒡ ᒌ ᐹᒋ ᓂᑎᐧᐋᐱᒫᐅᒡ ᒌᓴᔅ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᐋᑳ ᐧᐋᐦᒋ ᑖᑆᐦᑎᐦᒡ ᐊᐧᐋᔨᐤᐦ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒦᓐ ᑳᐤ ᒑ ᒌ ᐧᐃᓂᔥᑳᓂᒫᑭᓂᐧᐄᒡ᙮ ᒌ ᑯᐧᑳᒋᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, ");
INSERT INTO crl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒧᓱᔅ ᒌ ᒥᓯᓂᐦᐋᒻ ᑖᓐ ᒑ ᐄᔑ ᓈᓈᑭᒋᐦᑖᔨᐦᒄ᙮ ᒌ ᐄᑎᔥᑖᐤ ᐊᓂᑎᐦ, ‘ᐳᓂᐱᒫᑎᓰᒑ ᓈᐹᐤ ᐋ ᒌ ᐧᐄᐅᑦ ᐋᑳ ᒫᒃ ᐧᐋᐦᒋ ᐅᑎᐧᐋᔑᔒᒧᐧᐋᐧᑳ, ᐊᓂᔮᔨᐤ ᑳ ᐅᐦᒋ ᑖᐦᒋᔅᑳᑯᑦ ᐧᐄᒋᐄᔨᔨᐤ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒋᐱᐦ ᐧᐄᒋᒫᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐧᐄᐤᐦ᙮ ᐋᒄ ᒫᒃ ᒋᐱᐦ ᐃᔮᐧᐋᐅᒡ ᐊᐧᐋᔑᔥ ᐊᓂᔮ ᐅᔅᑖᔅ ᐊᓐ ᓈᐹᐤ ᐋᔪᐧᐃᑯᓐᐦ ᒋᐱᐦ ᐅᐦᐱᓂᐦᑖᐅᒋᑎᒧᐧᐋᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ᓃᐧᔖᔥᒡ ᒫᒃ ᒌ ᐄᑎᔓᒡ ᓈᐹᐅᒡ ᐋ ᒌ ᐧᐄᒋᔖᓂᐦᑐᒡ᙮ ᐊᓐ ᐅᔅᑖᓯᒫᐤ ᒌ ᒋᐦᒋᐧᐄᐤ᙮ ᐹᑎᒫ ᒫᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐧᐋᐅᒡ ᐊᐧᐋᔑᔥ ᐊᓂᔮᔨᐤ ᐧᐄᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ᐋᒄ ᐊᓂᔮᔨᐤ ᐧᐄᒋᔖᓐ ᑳ ᐅᐦᒋ ᑖᐦᒋᔅᑳᑯᑦ ᑳ ᐧᐄᒋᒫᔨᒡ ᐊᓂᔮᔨᐤ ᐧᐄᐤᐦ᙮ ᑭᔮᐦ ᐧᐄᔨ ᒫᒃ ᐆ ᓈᐹᐤ ᒑᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐧᐋᐅᒡ ᐊᐧᐋᔑᔥ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ᙮ ᐋᔪᐧᐃᒄ ᒧᔮᒻ ᑳ ᐊᔅᐱᔨᑦ ᑭᔮᐦ ᐊᓐ ᑯᑎᒃ ᐧᐄᒋᔖᓂᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ᒑᒃ ᒥᓯᐧᐋ ᐊᓂᒌ ᓃᐧᔖᔥᒡ ᐧᐄᒋᔖᓂᒫᐅᒡ ᑳ ᐧᐄᒋᒫᒡ ᐊᓂᔮᔨᐤ ᐃᔅᐧᑳᐤ᙮ ᒥᓯᐧᐋ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐧᐋᒡ ᐊᐧᐋᔑᔥ᙮ ᒑᒃ ᒫᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᑭᔮᐦ ᐧᐄᔨ ᐊᓐ ᐃᔅᐧᑳᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ᑖᓂᔮᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᒑ ᐅᓈᐹᒥᑦ ᐆ ᐃᔅᐧᑳᐤ ᐄᔥᐱᐦ ᐧᐃᓂᔥᑳᓂᒫᑭᓂᐧᐃᔨᒑ ᐊᐧᐋᔨᐤᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ? ᐧᐋᔥ ᒥᓯᐧᐋ ᐊᓂᒌ ᓃᐧᔖᔥᒡ ᓈᐹᐅᒡ ᒌ ᐧᐄᒋᒫᐅᒡ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᐹ ᒧᔮᒻ ᒋᑎᐄᑖᔨᐦᑎᓈᐧᐋᐤ, ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ ᑭᔮᐦ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑎᐧᒫᓈᐧᐋᐤ ᒋᔖᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ᐧᐋᔥ ᐧᐃᓂᔥᑳᓈᑭᓄᐧᑖᐧᐋ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᑖᐹ ᑭᑎ ᐅᐦᒋ ᒋᐦᒋᐧᐄᒋᑐᐧᐃᒡ ᑭᔮᐦ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒋᐦᒋᐧᐄᒋᑐᐦᐋᑭᓂᐧᐃᒡ, ᐧᐋᔥ ᐊᓂᔮᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐋᓐᒋᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᑖᔨᐦᒡ ᐋᔪᐧᐃᒄ ᒧᔮᒻ ᒑ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ᐊᓐ ᒫᒃ ᓂᑑᒋᔅᒑᔨᐦᑎᐧᒫᐧᑳ ᒑ ᐧᐃᓂᔥᑳᓈᑭᓄᐧᐋᐧᑳ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᓂᒧᐃ ᐋ ᑰᐦᒋ ᐊᔨᒥᐦᑖᐧᐋᓈᐧᐋᐤ ᒧᓱᔅ ᑖᓐ ᑳ ᐄᑎᓯᓈᐦᒃ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓂᑎᐦ ᑳ ᑎᐹᑎᐦᒃ ᐋ ᓃᐱᓯᐦᑰᐹᔨᒡ ᑳ ᐅᐦᒋ ᐊᔨᒥᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ, ᐋ ᒌ ᐄᑎᑯᑯᐱᓈ, ‘ᐋᐅᒄ ᓃᔨ ᐅᒋᔖᒥᓂᑑᒧᐧᐋᐤ, ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓵᒃ ᑭᔮᐦ ᒉᑭᑉ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ᐧᐋᔥ ᑳᐦ ᐃᔨᑯᐱᓈ ᒋᔖᒥᓂᑑ ᐋᐦ ᐋᐅᑦ ᐧᐋᒋᔖᒥᓂᑑᒥᑖᑯᑦ ᐊᓂᔮᔨᐤ ᔖᔥ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᐱᒫᑎᓰᔨᐤ ᒫᒃ᙮ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᐱᒫᑎᓰᐤ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ᙮ ᑖᑆᐦ ᑯᓂᐲᓈᐧᐋᐤ ᐊᔨᑖᐦᐄᑎᒫᒄ ᐋᐦᐋᑳ ᑎᑯᐦᒡ ᐊᐧᐃᓂᔥᑳᐧᐃᓅᒡ ᑳ ᐴᓂᐱᒫᑎᓰᓈᓅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ᐹᔨᒄ ᒫᒃ ᓈᐹᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᒌ ᐹᒋ ᓈᒋᑳᐳ, ᐋ ᒌ ᐹᐦᑎᐧᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᐊᔨᒥᐦᐄᑐᔨᒡ᙮ ᒌ ᐹᐦᑎᐧᐋᐤ ᒫᒃ ᒌᓴᔅᐦ ᑖᓐ ᑳ ᐄᔑ ᑯᐃᔅᒄ ᓂᔥᐧᑳᐅᔑᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᓵᑎᔫᓰᐦ᙮ ᐋᒄ ᑳ ᑯᐧᑳᒋᒫᑦ, “ᒑᒄ ᐄᑎᔓᐧᐋᐧᐃᓐ ᒫᐅᒡ ᓃᑳᓐ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐧᐄᐦᑖᑯᓐ ᒋᔖᒥᓂᑑ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓐ ᒫᐅᒡ ᓃᑳᓐ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᐄᑎᔓᐧᐋᐧᐃᓐ᙮ ᐊᐧᑳᒋᔥᑖᒡ, ᓂᑎᐦᑎᒧᒄ, ᒌᔨᐧᐋᐤ ᐃᔅᕋᐄᓪ ᐅᑎᔨᔨᒻᐦ, ᐅᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᒋᔖᒥᓂᑑᒧᐧᐋᐤ, ᐋᐅᒄ ᒥᒄ ᐱᔮᔨᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ᓵᒋᐦᐄᐦ ᐅᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᒋᔖᒥᓂᑑᒻ, ᒥᓯᐧᐋ ᒋᑖᐦᐄᐦᒡ, ᑭᔮᐦ ᒥᓯᐧᐋ ᒋᑎᐦᒑᐦᑯᐦᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᒌ ᒥᑐᓈᔨᐦᒋᑭᓂᐦᒡ ᑭᔮᐦ ᒫᒃ ᒥᓯᐧᐋ ᒌ ᒥᔅᑭᐧᐃᓰᐧᐃᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ᒌ ᐋᑎ ᐄᑖᐤ ᒦᓐ ᒌᓴᔅ, “ᐊᓐ ᒦᓐ ᑯᑎᒡ ᐄᑎᔓᐧᐋᐧᐃᓐ ᒑᔅᑖᔨᑖᑯᒡ ᐋᐅᒄ ᐊᓐ ᑳᐦ ᐄᑎᔥᑖᒡ, ᓵᒋᐦᐄᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᒌ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᔨᓐ᙮ ᐋ ᑎᐦᑎᐦᒡ ᐄᑎᔓᐧᐋᐧᐃᓐ ᐋᔪᐧᐃᑯᓐᐦ ᐅᐦᐄ ᓃᔓ ᐄᑎᔓᐧᐋᐧᐃᓐ ᒫᐅᒡ ᓃᑳᓐ ᐋᑖᔨᑖᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ᒌ ᐄᑎᑰ ᐊᓂᔮᔨᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᑖᑆᓐ᙮ ᒌ ᑖᑆᓐ ᐋᐦ ᐃᔨᓐ ᒥᒄ ᐋ ᐹᔨᑯᑦ ᒋᔖᒥᓂᑑ, ᓂᒧᐃ ᒦᓐ ᑖᐤ ᑯᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ᑭᔮᐦ ᒌ ᑖᑆᓐ ᐋᐦ ᐃᔨᓐ, ᒑ ᒌ ᓵᒋᐦᐋᑭᓅᑦ ᒋᔖᒥᓂᑑ ᒥᓯᐧᐋ ᒥᑖᐦᐄᐦᒡ, ᑭᔮᐦ ᒥᓯᐧᐋ ᒥᑐᓈᔨᐦᒋᑭᓂᐦᒡ, ᑭᔮᐦ ᒥᓯᐧᐋ ᐊᐦᒑᐦᑯᐧᐃᓂᐦᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᒥᔅᑭᐧᐃᓰᐧᐃᓂᐦᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᓵᒋᐦᐋᑦ ᐊᐧᐋᓐ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᒧᔮᒻ ᐧᐄᔨ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᑦ᙮ ᐅᔮᔨᐤ ᒑ ᒌ ᐃᔥᐱᔥ ᓵᒋᐦᐄᐧᐋᑦ ᐊᐧᐋᓐ ᐊᑎᑎᐤ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᐃᔥᐱᔥ ᐧᐄ ᐋ ᒧᒋᔥᑖᐦᐋᒧᐧᐋᑭᓅᑦ ᒋᔖᒥᓂᑑ ᒥᔨᐧᐋᐧᐃᓐ ᑭᔮᐦ ᒫᒃ ᐊᐅᐦᑳᓐ ᐋ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ ᒑ ᒌ ᒧᒋᔥᑖᐦᐊᒧᐧᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ᒌᓴᔅ ᒫᒃ ᐱᔮᐦᑎᐧᐋᑦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑭᒑᐦᑖᐧᐋᔨᐦᑎᒨᐦᑖᑯᓰᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᓂᒧᐃ ᒌ ᔮᐧᐋᐱᐦᑎᐧᒫᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᔨᐤ᙮” ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᑖᐤ ᐊᐧᐋᓐ ᐋ ᑖᐹᔨᒧᑦ ᐊᑎᑎᐤ ᒑ ᒌ ᑯᐧᑳᒋᒫᑦ ᒑᐧᑳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ᒫᐧᑳᒡ ᒌᓴᔅ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌ ᑯᐧᑳᒋᒫᐤ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, ᐋᐦ ᐄᑖᑦ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔨᒡ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᙭ ᐋᐧᐃᔨᒡ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᓯᔨᐤ? ");
INSERT INTO crl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᑐᑖᑰ ᐊᓂᔮ ᑌᕕᑦ ᒑ ᒌ ᐄᑖᑦ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᓂᑎᐹᔨᐦᒋᒑᓰᒻ, ᐅᑖᐦ ᐹᒋ ᐊᐱᐦ ᓂᓂᐦᐄᐧᐃᓂᐦᒡ ᐹᑎᔥ ᒌ ᐃᔥᐱᔑᐦᐄᐧᑳᐧᐋ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᔅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","ᐧᐋᐧᐋᒡ ᑌᕕᑦ ᓂᑎᐹᔨᐦᒋᒑᓰᒻ ᐋ ᒌ ᐃᔑᓂᐦᑳᑖᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐅᑯᓰᑐᑖᑯᑦ?” ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᑳ ᓂᑑᐦᑖᑯᑦ ᒌᓴᔅ ᓄᐧᐃᒡ ᒌ ᒥᔪᐦᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ᒫᐧᑳᒡ ᒫᒃ ᒦᓐ ᐋ ᒋᔅᑯᑎᒧᐧᐋᑦ ᒌᐦ ᐄᑖᐤ, “ᔮᐧᑳᒦᔥᑐᐧᐋᐦᑯᒡ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ, ᐧᐋᔥ ᓂᑎᐧᐋᔨᐦᑎᒧᒡ ᒑ ᒌ ᒋᔅᑖᔨᒫᑭᓂᐧᐃᒡ᙮ ᒥᐧᔮᔨᐦᑎᒧᒡ ᐋ ᐳᔥᒋᔥᑭᐦᒡ ᑳ ᒋᐧᓈᑭᓃᔨᒡ ᐊᑯᐦᑉ, ᑭᔮᐦ ᒥᐧᔮᔨᐦᑎᒧᒡ ᐋ ᐅᑎᓂᔅᒑᓈᑭᓂᐧᐃᒡ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ᑭᔮᐦ ᓂᑎᐧᐋᔨᐦᑎᒧᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᐋ ᐱᔨᐦᑖᐱᒡ ᒑ ᒌ ᐊᐱᐦᐋᑭᓂᐧᐃᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᐋ ᒥᑯᔖᓂᐧᐃᔨᒡ ᒑ ᒌ ᐊᐱᐧᐃᐦᐋᑭᓂᐧᐃᒡ ᐊᓂᑖᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ᐅᑎᓂᐧᒫᐅᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐧᐋᐅᓰᔨᒡ ᑳ ᐹᔨᑯᔨᒡ ᐃᔅᐧᑳᐤ ᑭᔮᐦ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᒡ ᓈᐅᔥ ᐊᔨᒥᐦᐋᐅᒡ, ᐊᔨᒥᐦᐋᑳᓱᒡ ᒫᒃ ᒥᒄ ᐅᔮᔨᐤ ᐋᐦ ᑎᒡ᙮ ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᐊᐅᔅᑖ ᒑ ᐋᐦᐧᑳᑖᔨᐦᑖᑯᓃᔨᒡ ᑖᓐ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᑯᒡ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ᒌᓴᔅ ᒫᒃ ᑎᐱᔅᑯᒡ ᑳ ᒌ ᐱᒋᔅᑎᓂᒑᓂᐧᐃᔨᒡ ᐋᑯᑖᐦ ᑳ ᐊᐱᑦ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᒌ ᒥᐦᒑᑎᓈᓂᐧᐃᔨᐤ ᐊᓂᑎᐦ ᐋ ᐱᒋᔅᑎᓂᒑᓂᐧᐃᔨᒡ᙮ ᒌ ᑭᓂᐧᐋᐱᒫᐤ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᐋ ᐹᒋ ᐱᒋᔅᑎᓂᒑᔨᒡ᙮ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤ ᑳ ᒥᓯᒋᓰᔨᒡ ᐊᐧᐋᔨᐤᐦ ᒥᔥᑏᐦ ᒌ ᐱᒋᔅᑎᓂᒑᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ᒑᒃ ᒌ ᐅᐦᒋ ᑎᑯᔑᓐ ᐋ ᐹᔨᑯᑦ ᐃᔅᐧᑳᐤ, ᐋ ᒋᔅᑎᒫᑎᓯᑦ, ᓃᔓ ᐋ ᐧᐃᔨᐹᐱᔅᒋᔨᒡ ᔓᐧᐃᔮᓈᐱᔅᑯᔥ ᒌ ᐱᒋᔅᑎᓂᒑᐤ᙮ ᐅᔮᔨᐤ ᑖᐱᔥᑯᓐ ᔓᐧᐃᔮᓈᐱᔅᑯᔥ ᑳ ᐱᒋᔅᑎᓂᒑᑦ ᒥᒄ ᐹᔨᒄ ᓵᓐᔅ ᒌ ᐄᑎᒋᑖᑯᓯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ᐋᒄ ᒌᓴᔅ ᑳ ᐊᔨᒥᐦᐋᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᑳ ᐃᔥᐱᔥ ᐱᒋᔅᑎᓂᒑᑦ ᐊᓐ ᑳ ᐹᔨᑯᑦ ᐃᔅᐧᑳᐤ ᑳ ᒋᔅᑎᒫᑎᓯᑦ ᐊᑎᑎᐤ ᐧᐄᔨ ᒥᔖᔨᐤ ᐅᐱᒋᔅᑎᓂᒑᐧᐃᓐ ᐃᔥᐱᔥ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᐱᒋᔅᑎᓂᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ᐧᐋᔥ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᐱᒋᔅᑎᓂᒑᒡ ᐊᔨᐧᐋᒋᐲᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᔓᐧᐃᔮᓐ ᑳ ᐱᒋᔅᑎᓈᒡ᙮ ᐆ ᒫᒃ ᑳ ᐹᔨᑯᑦ ᐃᔅᐧᑳᐤ, ᐋᑎ ᐋ ᐅᐧᐋᓂᓯᑦ ᒌ ᐱᒋᔅᑎᓈᐤ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᐅᔔᔮᓂᒻ ᐊᓂᔮᔨᐤ ᒑ ᐅᐦᒋ ᐱᒫᒋᐦᐄᓱᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ᒌᓴᔅ ᒫᒃ ᐋᐦ ᐋᑎ ᐧᐃᔨᐧᐄᑦ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐹᔨᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒌ ᐄᑎᑰ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐄᑖᐱᐦ ᒫᐦ᙮ ᓄᐧᐃᒡ ᒥᔪᔑᐧᐃᒡ ᐅᒌ ᐊᓯᓃᔨᒡ ᐅᑎᐦ ᐧᐋᔅᑳᐦᐄᑭᓂᐦᒡ ᑳ ᒋᑭᒧᒡ ᑭᔮᐦ ᒫᒃ ᐅᐦᐄ ᐧᐋᔅᑳᐦᐄᑭᓐ ᓄᐧᐃᒡ ᒥᐧᔮᔑᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᒋᐧᐋᐱᐦᑖᓈᐧᐋᐤ ᐋ ᐅᐦᐄ ᐧᐋᔅᑳᐦᐄᑭᓐ ᑳ ᒫᒥᔖᒡ? ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᐹᔨᒄ ᐊᓯᓃ ᒋᑭ ᐅᐦᒋ ᐋᐦᑯᐃᐦᑎᐧᐃᐱᐤ ᑯᑎᒃ ᐊᓯᓃ ᐊᓂᔮᔨᐤ ᑳ ᐄᑎᐦᐋᑭᓅᑦ᙮ ᒥᓯᐧᐋ ᐊᓯᓃᔨᒡ ᑳᐦ ᐋᐱᒋᐦᐋᑭᓂᐧᐃᒡ ᑳ ᐅᔑᐦᑖᑭᓂᐧᐃᐦᒡ ᐅᐦᐄ ᐧᐋᔅᑳᐦᐄᑭᓐ ᒋᑭ ᓃᐦᔑᐧᐋᐱᓈᑭᓂᐧᐃᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ᒫᐧᑳᒡ ᒫᒃ ᐋ ᐊᐱᑦ ᐊᓂᑖᐦ ᐊᓕᕕᔅ ᐋᐱᔅᑯᑎᓈᐦᒡ ᑎᐱᔅᑯᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑳᐦ ᑎᑯᓃᔨᒡ, ᒌ ᓈᑎᑰ ᐲᑎᕐ, ᒉᒥᔅ, ᒞᓐ ᑭᔮᐦ ᐋᓐᑎᕉ ᒑ ᒌ ᑯᐧᑳᒋᒥᑯᑦ ᒑᐧᑳᔨᐤ ᒫᐧᑳᒡ ᒥᒄ ᐧᐄᔨᐧᐋᐤ ᐋᐦᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ᒌ ᐄᑎᑰ, “ᐧᐄᐦᑎᒨᓈᓐ ᒫᐦ ᑖᔨᔥᐱ ᒑ ᐄᔅᐱᔨᒡ ᐆ? ᒑᒄ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓐ ᒑ ᐄᔅᐱᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᐦᒡ ᔖᔥ ᐋ ᐅᑎᐦᒋᐱᔨᐦᒡ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᐧᑳᓂᐦᐄ?” ");
INSERT INTO crl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᔮᐧᑳᒦᒄ ᐋᑳ ᐊᐧᐋᓐ ᒑ ᒌ ᑳᒌᔑᒥᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ᐧᐋᔥ ᒋᑭ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐋ ᑎᑯᔑᐦᒡ ᓂᑎᔑᓂᐦᑳᓱᐧᐃᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ ᐋᐦ ᐃᔨᒡ, ‘ᐋᐅᒄ ᓃᔨ ᙭’᙮ ᒥᐦᒑᑐ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᒋᑭ ᑳᒌᔑᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ᐊᑳᐧᐄ ᑭᔮᐦ ᒋᑭ ᐅᐦᒋ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᓈᐧᐋᐤ ᐹᐦᑎᒫᐧᑳ ᐋ ᒥᐧᑖᓂᑐᐱᔨᓈᓂᐧᐃᒡ ᐹᔓᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔮᒄ ᑭᔮᐦ ᐹᐦᑎᒫᐧᑳ ᐋ ᑎᐹᑐᑖᑭᓅᐦᒡ ᐋ ᓂᑑᐱᔨᓈᓂᐧᐃᒡ ᐊᓂᑖᐦ ᐧᐋᐦᔨᐤ᙮ ᐋᐅᒄ ᐧᐋᔥ ᓃᔥᑎᒻ ᓈᑎᐧᐋᔨᐦᑖᑯᐦᒡ ᒑ ᒌ ᐄᔅᐱᔨᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐋᔥᒄ ᑭᑎ ᐅᐦᒋ ᐄᔅᐧᑳᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ᐹᔨᑯᓂᐦᒡ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᑭᑎ ᒫᓯᐦᐄᑐᐧᐃᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ ᐃᔨᐦᒡ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᐅᒋᒫᐅᒡ ᑭᑎ ᓂᑐᐱᔨᐦᑭᐦᑎᐧᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᑳ ᐅᒋᒫᐧᐃᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᓂᓈᐦᑭᐤ ᐊᓂᑖᐦ ᐧᐃᔮᔥ ᑭᑎ ᑯᐃᐦᑯᓐ᙮ ᑭᔮᐦ ᑭᑎ ᑎᑯᓐ ᐋ ᑭᐧᐃᐦᑭᑖᓂᐧᐃᒡ᙮ ᐆ ᒫᒃ ᓂᓈᐦᑭᐤ ᒑ ᐄᔅᐱᔨᒡ, ᐋᐅᒄ ᐱᒑᐃᒃ ᒑ ᒋᐦᒋᐱᔨᒡ ᓂᓈᐦᑳᑖᔨᒧᐧᐃᓐ, ᒧᔮᒻ ᐃᔅᐧᑳᐤ ᐋ ᒋᐦᒋ ᒨᔑᐦᐅᑦ ᒑ ᐋᐦᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“ᔮᐧᑳᒦᒄ ᐧᐋᔥ ᒋᑭ ᑖᐅᒡ ᐊᓂᒌ ᒑ ᐅᑎᓂᑖᑯᒡ, ᐋᒄ ᐊᓂᑖᐦ ᑳ ᓃᑳᓂᔥᑳᒑᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᐄᑐᐦᑎᐦᐄᑖᑯᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᐧᐃᔮᒄ᙮ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᑯᑖᐦ ᒑ ᐹᐱᐦᓯᔅᑖᐦᐅᑯᐧᐃᔮᒄ᙮ ᒋᑭ ᐄᑐᐦᑎᐦᐄᑯᓈᐧᐋᐤ ᐹᔓᒡ ᑭᔮᐦ ᒋᐦᒋᐅᒋᒫᐅᒡ ᐋᐦᑖᐦᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑖᑯᒡ ᐊᓐ ᐅᐦᒋ ᐋ ᓅᔔᔥᑯᔮᒄ ᑭᔮᐦ ᑯᐃᔅᒄ ᒋᑭ ᑎᐹᒋᒥᓈᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ᐋᐧᒫᔮ ᒫᒃ ᐆ ᐃᔅᐱᔮᒄ, ᓃᔥᑎᒻ ᒋᐱᐦ ᑭᒑᔅᒋᒫᑭᓂᐧᐃᒡ ᒥᓯᐧᐋ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᐋ ᐧᐋᐧᐄᐦᑎᒧᐧᐋᑭᓂᐧᐃᒡ ᒥᐧᔮᒋᒧᐧᐃᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᓂᑯᔮᐧᑳ ᑭᔮᐦ ᐄᑐᐦᑎᐦᐄᑯᔮᐧᑳ ᐊᓂᑖᐦ ᒑ ᑎᐹᔅᑯᓂᑯᔮᒄ ᐊᑳᐧᐄ ᓂᔮᑭᓐᐦ ᒋᑭ ᐅᐦᒋ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᑯᓈᐧᐋᐤ ᑖᓐ ᒑ ᐃᔮᒄ, ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᒥᔨᑯᐧᐋᐧᑳ ᒑ ᐃᔮᒄ ᒫᐧᑳᒡ ᐊᓂᑎᐦ ᑖᔮᐧᑳ ᐋᐅᒄ ᐊᓐ ᒑ ᐃᔮᒄ᙮ ᐧᐋᔥ ᑖᐹ ᒌᔨᐧᐋᐤ ᒋᑭ ᐅᐦᒋ ᐋᔨᒥᓈᐧᐋᐤ ᐊᓂᑎᐦ ᒫᐧᑳᒡ ᐋᔨᒥᔮᐧᑳ, ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋᐅᒄ ᒑ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ᒫᐤ ᑭᔮᐦ ᒑ ᐄᔅᐱᔨᒡ᙮ ᐧᐄᒋᔖᓂᒫᐤ ᑭᑎ ᒫᒥᓯᒫᐤ ᑎᐱᔨᐧᐋ ᐧᐄᒋᔖᓐ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ᙮ ᐅᐦᑖᐧᐄᒫᐤ ᑭᔮᐦ ᐋᔪᐧᐃᒄ ᒑ ᑐᑎᐧᐋᑦ ᐅᑎᐧᐋᔑᔒᒻ᙮ ᐊᐧᐋᔑᔑᒡ ᑭᔮᐦ ᑭᑎ ᒋᔑᐧᐋᐦᐄᑯᒡ ᐅᓃᒋᐦᐄᑯᐧᐋᐤ ᐋᒄ ᒑ ᑐᑎᐧᐋᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᒋᑭ ᐅᐦᑳᑎᑯᐧᐋᐤ ᐋ ᓅᔔᔥᑭᐧᐃᔮᒄ᙮ ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐧᐋᓐ ᒑ ᔮᐃᔨᒋᑳᐳᐧᑳ ᒥᒄ ᒑ ᐃᔥᐱᔥ ᐱᒫᑎᓰᐧᑳ ᐋᐅᒄ ᐊᓐ ᒑ ᐱᒫᒋᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᐱᒫᐧᑳ ᐊᓐ ᐊᐧᐋᓐ ᒫᐅᒡ ᑳ ᐅᐦᑳᑖᔮᔨᐦᑖᑯᓯᑦ ᐋ ᓃᐴᐧᐃᑦ ᐊᓂᑎᐦ ᐋᑳ ᒑ ᓃᐴᐧᐃᑰᐱᓐ” (ᐊᓐ ᐊᐧᐋᓐ ᑳ ᐊᔨᒥᐦᑖᑦ ᐅᔮᔨᐤ ᑭᑎ ᐧᐄᐦ ᓂᔅᑐᐦᑎᒻ), “ᐋᑯᔥ ᐱᒋᔅᑎᓈᐦᑯᒡ ᐊᓂᒌ ᒎᑏᔮᐦᒡ ᑳᐦ ᑖᒡ ᐊᓂᑖᐦ ᐋᐱᔅᑯᑎᓈᔨᒡ ᒑ ᒌ ᐄᑎᔓᒧᒡ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᐊᓂᔮ ᐅᒋᔅᒋᐧᐋᐦᐄᒑᓯᐤ ᑖᓃᔨᓪ ᑳᐦ ᐋᔨᒨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ᑭᔮᐦ ᐊᓐ ᐊᐧᐋᓐ ᑎᐦᑯᐦᒡ ᐧᐄᒋᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐧᐄ ᓂᐦᐋᔨᒫᐦᒄ ᒑ ᒌ ᐲᐦᒑᑦ ᐅᐧᐋᔅᑳᐦᐄᑭᓂᒦᐦᒡ ᒑ ᒌ ᓂᑎᐧᐋᐱᐦᑎᐦᒃ ᒑᐧᑳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ᑭᔮᐦ ᐊᓐ ᐊᐧᐋᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐧᐄ ᐱᒋᔅᑎᓈᐦᒄ ᒑ ᒌ ᒌᐧᐋᑦ ᐅᑎᑯᐦᑉ ᐋ ᐧᐄᐦ ᓂᑎᐧᐋᐱᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ᑖᑆᐦ ᑭᑎ ᐋᔨᒥᓂᔨᐤ ᐊᓂᒌ ᒫᐧᑳᒡ ᑳ ᒋᒋᔥᑯᐧᐋᒡ ᐊᐧᐋᔑᔥ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓅᔖᓂᐦᐋᐅᓱᒡ ᒫᐧᑳᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ᐊᔨᒥᐦᐋᒄ ᒑᐦ ᐋᑳ ᒌ ᐄᔅᐱᔨᒡ ᐆ ᒑᐧᑳᓐ ᒫᐧᑳᒡ ᐋ ᒫᐧᑳᐳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ᐧᐋᔥ ᐅᐦᐄ ᐋ ᒌᔑᑳᒡᐦ ᐅᑎᐦᒋᐱᔨᐦᐧᑳᐧᐋ ᓄᐧᐃᒡ ᑭᑎ ᑎᑯᓐ ᐋ ᓂᓈᐦᑳᑖᔨᒧᒡ ᐄᔨᔨᐅᒡ᙮ ᑳ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᐆ ᐊᔅᒌ, ᒋᔖᒥᓂᑑ ᑳ ᐅᔑᐦᑖᑦ, ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓐ ᑖᓐ ᒑ ᐄᑖᔨᐦᑖᑯᐦᒡ ᐆ ᓂᓈᐦᑳᑖᔨᒧᐧᐃᓐ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᑎᑯᓐ ᐆ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᓂᓈᐦᑳᑖᔨᒧᐧᐃᓐ ᐄᔥᐱᐦ ᒌ ᒥᔮᐅᐱᔨᐦᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ᐋᑳ ᐅᐦᒋ ᓂᑳᐦᐊᒧᑯᐱᓈ ᒋᔖᒥᓂᑑ ᐊᑎᑎᐤ ᓈᐅᔥ ᒑ ᒌ ᑎᑯᓃᔨᒡ ᓂᓈᐦᑳᑖᔨᒧᐧᐃᓂᔨᐤ ᐊᑑᒡ ᑖᐤ ᐊᐧᐋᓐ ᐋ ᐱᒫᑎᓰᑦ, ᐋ ᒌᒋᔅᒌᑐᐧᐋᑯᐱᓈ ᑳ ᐅᐧᐋᔮᐱᒫᑦ ᐅᑎᔨᔨᒻᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“ᐋᒄ ᒫᒃ ᐄᑖᐧᑳ ᐊᐧᐋᓐ, ‘ᐄᑖᐱᒄ ᒫᐦ, ᐋᐅᒄ ᐧᐋᔥ ᐆ ᙭’, ᑭᔮᐦ ᒫᒃ ᐄᑎᑯᔮᐧᑳ, ‘ᒫᓐ ᙭’, ᐊᑳᐧᐄ ᒋᑭ ᐅᐦᒋ ᑖᑆᐦᑖᓈᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ᑭᑎ ᑖᐅᒡ ᐄᔨᔨᐅᒡ ᐋ ᑳᒌᔑᒧᐧᐋᒡ ᐋᐦ ᐃᔨᒡ, ‘ᐋᐅᒄ ᓃᔨ ᙭’᙮ ᑭᑎ ᑖᐅᒡ ᑭᔮᐦ ᒥᒋᐅᒋᔅᒋᐧᐋᐦᐄᒑᓱᒡ᙮ ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᓂᓈᐦᑭᐤ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓐ ᒑ ᐧᐋᐱᐦᑎᔨᐧᐋᒡ ᑭᔮᐦ ᑭᑎ ᑐᑎᒧᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᒡ ᒑᐧᑳᔨᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᐅᐦᒋ ᑳᒌᔑᐦᐋᒡ ᐊᐧᐋᔨᐤᐦ ᓂᑎᐧᐄ ᒥᒄ ᒑ ᒌ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᐅᐧᐋᔮᐱᒫᔨᒡ ᐊᐧᐋᔨᐤᐦ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒑ ᐧᐄᐦ ᑳᒌᔑᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ᔮᐧᑳᒦᒄ ᒫᒃ᙮ ᔖᔥ ᓂᔮᑭᓐᐦ ᒋᒌ ᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᐧᑳᓂᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ᐄᔥᐱᐦ ᒥᔮᐅᐱᔨᐦᒑ ᐋ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐧᐃᒡ, ᓈᓈᓂᒌᒻ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐃᔥᐱᔥ ᒋᐦᑳᔮᔥᑎᐧᐋᐤ ᒌᔑᑳᐅᐲᓯᒻ ᑭᔮᐦ ᑎᐱᔅᒋᐲᓯᒻ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐧᐋᔥᑎᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ᐊᒋᐦᑯᔑᒡ ᒌᔑᑯᐦᒡ ᑭᑎ ᐅᐦᒋ ᐹᐦᐱᐦᒋᔑᓂᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᐦᒡ ᐃᔥᐱᒥᐦᒡ ᑭᑎ ᓂᓂᒥᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ᐋᒄ ᒫᒃ ᒑ ᐧᐋᐱᒫᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐹᒋ ᔮᓯᑦ ᑭᔥᑭᐧᐃᓂᔅᑰᐦᒡ, ᒥᑐᓐ ᐋ ᓅᑯᓃᔨᒡ ᐆ ᒥᔥᑎᐦ ᓲᐦᑳᑎᓰᐧᐃᓐ ᑭᔮᐦ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ᐋᒄ ᒑ ᐄᑎᔑᐧᐋᑖᑦ ᐋᓐᒋᓐ ᒑ ᒌ ᓂᑑᒫᒨᓈᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐅᐧᐋᔮᔨᒫᑦ ᐊᓂᑖᐦ ᓈᐧᐃᔨᒡ ᐋ ᐅᐦᑎᓃᔨᒡ ᐋ ᐅᐦᒌᔨᒡ᙮ ᒥᑐᓐ ᐋᐦ ᐄᔥᐧᑳᔮᔨᒡ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᒥᑐᓐ ᐋᐦ ᐄᔥᐧᑳᔮᔨᒡ ᒋᐦᒋᒌᔑᑯᔫ ᑭᑎ ᐅᐦᑎᓈᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ᑎᑯᓐ ᒑᐧᑳᓐ ᒑ ᒌ ᒋᔅᑯᑎᒫᓱᔮᒄ ᒥᓯᔔᒥᓈᐦᑎᒄ ᐋ ᑭᓂᐧᐋᐱᒫᒄ᙮ ᐄᔥᐱᐦ ᐋᐦ ᐋᑎ ᐅᔅᒋᓂᐦᑖᐅᒋᓃᔨᒡ ᐅᑎᐦᑯᓐ ᑭᔮᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᓃᐱᓯᐧᐃᒡ, ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᔖᔥ ᐧᐄᐱᒡ ᒑ ᓃᐱᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ᐅᐦᐄ ᒫᒃ ᒑᐧᑳᓂᐦᐄ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ ᒑ ᐄᔅᐱᔨᔨᒡ ᐄᔥᐱᐦ ᐄᔅᐱᔨᐦᐧᑳᐧᐋ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᒄ ᔖᔥ ᐋ ᐹᔓᓈᑯᓃᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᑎᑯᔑᐦᒃ, ᒧᔮᒻ ᔖᔥ ᐃᔥᐧᑳᐦᑖᒥᐦᒡ ᐋ ᐹᒋ ᓃᐴᐧᐃᑦ ᐋ ᐃᓯᓈᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᐊᓂᒌ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓅᐦᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒫᐦᒋ ᐴᓂᐱᒫᑎᓰᐧᐃᒡ ᐋᔥᒄ ᐋᐦᐋᑳ ᑎᐱᐱᔨᒡ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᒑ ᐄᔅᐱᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ ᑭᑎ ᐃᔅᐧᑳᐱᔨᐤ ᒥᒄ ᒫᒃ ᓂᑎᔨᒧᐧᐃᓐ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐃᔅᐧᑳᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐊᐧᐋᓐ ᒋᔅᒑᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑎᐱᐦᐄᑭᓂᔨᐤ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᔮᔨᐤᐦ ᒑᐧᑳᔨᐤᐦ᙮ ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᐋᓐᒋᓂᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ, ᐋᑦ ᑭᔮᐦ ᐅᑯᓯᓯᒫᐤ, ᒥᒄ ᐅᐦᑖᐧᐄᒫᐤ ᒋᔅᒑᔨᐦᑎᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ᔮᐧᑳᒦᒄ, ᒨᔥ ᐹᒋ ᐃᔮᔅᑭᐧᐃᔥᑑᒄ᙮ ᐧᐋᔥ ᑖᐹ ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᑖᔨᔥᐱᔥ ᒑ ᐄᔅᐱᔨᒡ ᐆ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ᐋᐅᒄ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᓈᐹᐤ ᐧᐋᐦᐄᔨᐤ ᐋ ᐧᐄᐦ ᐄᑐᐦᑖᑦ᙮ ᐄᔥᐱᐦ ᒑ ᓂᑭᑎᐦᒃ ᐧᐄᒡ ᐅᑖᐱᒋᐦᐋᑭᓐ ᒥᔮᐤ ᒑ ᐅᒋᒫᐧᐃᔨᒡ ᒫᐧᑳᒡ ᐋᐦᐋᑳ ᑖᑦ᙮ ᒥᓯᐧᐋ ᐹᐦᐹᔨᒄ ᐧᐄᐦᑎᒧᐧᐋᐤ ᒑ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᑭᓅᔥᑯᑎᐧᐋᔨᒡ ᐄᑎᔓᒫᐤ ᔮᐧᑳᐦ ᒑ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐃᔥᐧᑳᐦᑖᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ᔮᐧᑳᒦᒄ ᐧᐋᔥ ᑖᐹ ᒋᒋᔅᒑᔨᐦᑖᓈᐧᐋᐤ ᑖᔨᔥᐱᔥ ᒑ ᑎᑯᔑᐦᒃ ᑯᒋᒫᒧᐧᐋᐤ ᑳ ᓈᓈᑭᒋᐦᑖᐧᐋᒄ ᐧᐄᒡ, ᐋ ᐅᑖᑯᔑᔨᒡ ᒑ ᑎᑯᔑᓂᐧᑳ, ᑭᔮᐦ ᒫᒃ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᒑ ᑭᔮᐦ ᒫᒃ ᐹᑖᐱᓃᔨᒑ, ᑭᔮᐦ ᒫᒃ ᐹᑎᔥ ᐋᑎ ᐧᐋᐱᓃᔨᒡ ᒑ ᑎᑯᔑᓂᐧᑳ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ᔮᐧᑳᒦᒄ ᒫᒃ, ᔮᐧᑳᐦ ᒑᔅᑳᑯᔮᐧᑳ ᐋ ᓂᐹᔮᒄ ᔑᔥᒋᑯᒡ ᑎᑯᔑᐦᑳ᙮ ");
INSERT INTO crl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ᐆ ᒑ ᐄᑎᑯᒡ, ᓂᑎᑖᐅᒡ ᑭᔮᐦ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ, ᐃᔮᔅᑭᐧᐃᔥᑑᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ᓃᔓ ᒌᔑᑳᐤᐦ ᒌ ᐃᔥᐱᔑᓈᑯᓐ ᒑ ᒦᒋᓈᓂᐧᐃᒡ ᐊᓐ ᒥᑯᔖᓐ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓂᐧᐃᒡ ᑭᔮᐦ ᒑ ᒋᐦᒋᐱᔨᒡ ᐋᐃᐦᑯᓈᐤ ᐋᐦᐋᑳ ᐅᐦᐱᓱᑦ ᑳ ᒌ ᒧᐧᐋᑭᓅᑦ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒋᐧᐄᐦ ᓈᓂᑐ ᒥᔅᑭᒧᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒌᒧᒡ ᐅᑎᓈᒡᐦ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ᒌ ᐄᑎᑐᒡ, “ᓂᒧᐃ ᐧᐄᔨ ᒫᐧᑳᒡ ᒥᑯᔖᓂᐧᐃᒑ ᒋᑭ ᒌ ᐅᑎᓈᓂᐤ, ᒋᑭ ᑯᓰᐦᑳᑯᓅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒋᔑᐧᐋᐦᐄᐧᑳᐧᐋ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ᐯᑎᓃᐦᒡ ᒫᐧᑳᒡ ᑳᐦ ᑖᑦ ᒌᓴᔅ, ᐊᓂᑖᐦ ᓵᐃᒥᓐ ᐧᐄᒋᔨᐦᒡ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ᙮ ᐅᔮᔨᐤ ᓈᐹᐤ ᓵᐃᒥᓐ ᑳ ᐅᒥᒌᐧᐋᔅᐱᓈᑦ ᒌ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐧᐃᔨᐤ᙮ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ ᒌ ᐊᐱᐧᐃᒡ ᐋ ᒦᒋᓱᒡ ᑳ ᐅᐦᒋ ᐲᐦᒑᔨᒡ ᐃᔅᐧᑳᐤ ᐋ ᐹᒋ ᑎᐦᑯᓂᒥᔨᒡ ᓈᔥᒡ ᐋ ᒥᐧᔮᔒᔨᒡ ᐱᐧᔮᐱᔅᑯᔮᑭᓂᔨᐤ ᐋ ᐊᓯᓃᐧᐃᔨᒡ᙮ ᐋᐦ ᐋᔨᒥᒋᑖᑯᓃᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ ᐋ ᒥᔪᒫᑯᓰᔨᒡ ᒌ ᐲᐦᒋᐦᑎᓂᔨᐤ ᐊᓂᑎᐦ᙮ ᒌ ᒧᔥᑖᑭᒥᔨᐤ ᒫᒃ ᐅᔮᔨᐤ ᑑᒥᓂᑭᓂᔨᐤ, ᓈᕐᑦ ᒌ ᐃᔑᓂᐦᑳᑖᔨᐤ᙮ ᒌ ᐲᑯᓂᒻ ᐊᓂᑎᐦ ᐋ ᐅᔥᑎᐧᑳᓂᐧᐃᔨᒡ ᐊᓂᔮᔨᐤ ᐴᑖᔨᐤ ᐋᒄ ᑳ ᑯᑎᐱᓂᐦᒃ ᐊᓂᔮᔨᐤ ᑑᒥᓂᑭᓂᔨᐤ ᒌᓴᔅ ᐅᔥᑎᐧᑳᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ᐱᔅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᒋᓯᐧᐋᐦᐄᑯᒡ ᐅᔮᔨᐤ ᐋᐦᑎᔨᒡ ᐋᒄ ᑳᐦ ᐄᑎᑐᒡ, “ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐃᔮᔪᐦᑖᑦ ᐅᔮᔨᐤ ᑳ ᒥᔪᒫᑯᓰᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ᒌ ᐊᑖᐧᐋᒑᑦ ᐊᐧᐋᓐ ᐅᔮᔨᐤ ᑑᒥᓂᑭᓂᔨᐤ ᐹᔅᒡ ᓂᔥᐧᑖᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᔔᐧᐃᔮᓈᐱᔅᒄ ᒋᐱᐦ ᒥᔮᑭᓂᐤ᙮ ᐊᓐ ᒫᒃ ᔓᐧᐃᔮᓐ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐄᔨᔨᐅᒡ ᒋᐱᐦ ᒌ ᒥᔮᑭᓂᐧᐃᒡ᙮” ᐋᒄ ᑳᐦ ᐋᐧᓈᔨᒫᒡ ᐊᓂᔮᔨᐤ ᐃᔅᐧᑳᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐊᑳᐧᐄ ᐃᔮᐱᑖᔨᒫᐦᒄ᙮ ᒑᐧᑳᔨᐤ ᐧᐋᐦᒋ ᐋᔨᒫᔨᐦᑎᒥᐦᐋᒄ? ᓈᔥᒡ ᒥᐧᔮᔑᔨᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᑐᑎᐧᐃᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ᒨᔥ ᑖᐅᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ, ᒋᑭ ᒌ ᒥᔪᑐᑎᐧᐋᐧᐋᐅᒡ ᑖᓂᑖᐦ ᒥᒄ ᒑ ᓂᐦᐄᐱᔨᐦᐧᑳ ᒑ ᒌ ᒥᔪᑐᑎᒧᐧᐋᑯᒡ, ᓃᔨ ᒫᒃ ᓂᒧᐃ ᒨᔥ ᓂᑭᐅᐦᒋᐦᑖᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ᐆ ᐃᔅᐧᑳᐤ ᒌ ᑐᑎᒻ ᐧᐄᔨ ᑖᓐ ᑳ ᐧᐄᐦ ᑐᑎᐦᒃ᙮ ᓂᔮᑭᓐᐦ ᒌ ᑑᒥᓂᒻ ᓂᔮᔨᐤ ᐋ ᐃᔮᔅᑭᐧᐄᐦᑭᐦᒃ ᒑ ᓂᐦᐄᑳᑭᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᑖᓂᑖᐦ ᒥᒄ ᒑ ᑭᒑᔅᐧᑳᓅᐧᑳ ᐋ ᐧᐋᐧᐄᐦᑖᑭᓂᐧᐃᒡ ᒥᐧᔮᒋᒧᐧᐃᓐ ᒥᓯᐧᐋ ᐋᔅᐱᑎᔅᑭᒥᑳᒡ ᐆ ᐊᔅᒌ ᑭᑎ ᐧᐄᐦᑖᑭᓂᐧᐃᔨᐤ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐦᒃ ᐋ ᒋᔅᒋᓰᑐᑎᐧᐋᑭᓅᑦ ᐆ ᐃᔅᐧᑳᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ᐹᔨᒄ ᐊᓐ ᑳ ᓃᔓᔖᐴᒡ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᒌ ᓂᑎᐧᐋᐱᒫᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒑ ᒌ ᐧᐄᐦᑎᒧᐧᐋᑦ ᐧᐄᔨ ᒑ ᒌ ᑐᑎᐦᒃ ᒑ ᒌ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐅᑎᓂᒫᑭᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ᐅᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᓯᒋᔮᐦᐄᑯᒡ ᐱᔮᐦᑎᐧᐋᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᐋᒄ ᐋᑖᒡ ᔓᐧᐃᔮᓐ ᒑ ᒥᔮᒡ ᒑ ᒌ ᑐᑎᒥᔨᐧᑳᓂᐦᐄ ᐅᔮᔨᐤ᙮ ᐋᒄ ᒍᑖᔅ ᑳ ᓈᓂᑎᐧᐋᔨᐦᑎᐦᒃ ᑖᐃᔅᐱᔅ ᒑ ᓂᐦᐄᐱᔨᔨᐧᑳ ᒑ ᒌ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ᐊᓐ ᒫᒃ ᓃᔥᑎᒻ ᐋ ᒌᔑᑳᒡ ᒫᐧᑳᒡ ᐋ ᐱᒥᐱᔨᒡ ᑳ ᒌ ᒧᐧᐋᑭᓅᑦ ᐋᐦᐋᑳ ᐅᐦᐱᓱᑦ ᐋᐃᐦᑯᓈᐤ, ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᐱᐦᐋᑭᓅᑦ ᒫᓂᔥᒑᓂᔥ ᐋ ᒌᔥᒌᑑᐧᐋᑭᓂᐧᐃᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᐊᓐ ᐋ ᒥᔮᔥᑳᒑᐤ ᒌᔑᑳᒡ ᒌᓴᔅ ᒌ ᐄᑎᑰ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᑖᓂᑖᐦ ᓈᑎᐧᐋᔨᒥᔮᐦᒡ ᒑ ᒌ ᓂᑑᐃᔮᔅᑰᔥᑎᒫᑖᐦᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᒑ ᒌ ᒦᒋᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ᐋᒄ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᑳ ᒋᐦᒋᑎᔑᐦᐧᐋᑦ ᒌᓴᔅ ᐋᐦ ᐄᑖᑦ, “ᐄᑐᐦᑖᒄ ᓈᑖᐦ ᐊᓐ ᒋᔖᐃᐦᑖᐧᐃᓐ᙮ ᐋᑯᑖᐦ ᒑ ᓂᒋᔥᑭᐧᐋᒄ ᓈᐹᐤ ᓂᐲᔨᐤ ᐋ ᐱᒧᐦᑖᑦ᙮ ᐋᐅᒄ ᒑ ᓅᔔᔥᑯᐧᐋᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᒑ ᐲᐦᒑᑦ ᒑ ᑯᐧᑳᒋᒫᒄ ᐊᓐ ᑎᐱᔨᐧᐋᐅᓯᑦ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ, ‘ᐊᑯ ᐄᔮᑦ ᓂᒋᔅᑯᑎᒫᒑᓰᒥᓈᓐ, ᑖᓂᑖᐦ ᐋᐦᑎᑯᐦᒡ ᐊᓐ ᐋ ᐱᔅᒑᒡ ᐊᓂᑎᐦ ᒑ ᐧᐄᒋᒥᒋᓱᒫᐅᒋᐱᓈᓂᒌ ᓂᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᔨᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ᐋᒄ ᒑ ᐧᐋᐱᐦᑏᑖᒄ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᐊᐲᐦᑎᐧᐋᔨᒡ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᐋ ᒥᔖᔨᒡ ᐋ ᐱᔅᒑᔨᒡ ᓈᔥᑎᔨᒡ ᐋ ᒌ ᐃᔮᔅᑭᐧᐃᔥᑖᔨᒡ, ᔖᔥ ᒥᓯᐧᐋ ᒑᐧᑳᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᒑ ᐄᔑ ᓂᑎᐧᐋᔨᐦᑖᑯᓃᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐅᑖᐦ ᒑ ᐃᔮᔅᑭᐧᐃᔥᑖᔮᒄ ᐆ ᒥᑯᔖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒋᔖᐃᐦᑖᐧᐃᓂᔨᐤ ᑳ ᐄᑐᐦᑖᒡ᙮ ᓂᐦᐋᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐧᐄᐦᑎᒫᑯᒡ ᐋᔪᐧᐃᒄ ᑳ ᐄᔅᐱᔨᒡ᙮ ᐋᒄ ᑳ ᐃᔮᔅᑰᔥᑖᒡ ᐊᓂᔮᔨᐤ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᑖᑯᓰᔨᒡ ᒌᓴᔅ ᒌ ᑎᑯᔑᓐ ᐊᓂᑖᐦ ᐋ ᐧᐄᒑᐅᑯᑦ ᐊᓂᔮᔨᐤ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ᒫᐧᑳᒡ ᒫᒃ ᐋ ᒦᒋᓱᒡ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᐹᔨᒄ ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᑭ ᒫᒥᔑᒥᒄ, ᐋᑯᑖᐦ ᐅᑎᐦ ᓂᐦᐋᐤ ᐧᐋᒋᒦᒋᓲᒥᑦ ᐊᓐ ᐊᐧᐋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ᐋᒄ ᒥᓯᐧᐋ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒌ ᒥᓯᒫᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᐋᒄ ᐹᐦᐹᔨᒄ ᑳ ᑯᐧᑳᒋᒫᒡ, “ᓃᔨ ᐋ ᐊᓐ ᐊᐧᐋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᑯᑖᐦ ᐋᐦ ᑖᑦ ᐊᓐ ᐊᐧᐋᓐ ᐅᑎᐦ ᐆ ᐋ ᓃᔓᔖᐳᔮᒄ᙮ ᐋᐅᒄ ᐊᓐ ᑳ ᐊᑯᐦᒋᒫᑦ ᐅᑖᔨᐦᑯᓈᒻ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐧᐃᔮᑭᓂᔨᐤ ᑳ ᐊᑯᐦᒋᒥᒡ ᓂᑖᔨᐦᑯᓈᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ᑭᑎ ᓂᐱᐦᐋᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐹᒋ ᒥᓯᓂᐦᐄᑭᓂᐧᐃᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ᙮ ᒥᒄ ᒫᒃ ᑖᑆᐦ ᑭᑎ ᐋᐦᐧᑳᒡ ᒥᒋᐱᔨᐤ ᐊᓐ ᐊᐧᐋᓐ ᒑ ᒫᒥᔑᒫᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ᐊᐅᔅᑖ ᒋᐱᐦ ᒌ ᒥᐧᔮᔑᔨᑯᐱᓐ ᐊᓐ ᐊᐧᐋᓐ ᐋᑯᔥ ᐋᑳ ᐧᐋᐧᐋᒡ ᐅᐦᒋ ᐄᔨᔨᐧᐃᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᒦᒋᓱᒡ, ᒌᓴᔅ ᒌ ᐅᑎᓈᐤ ᐋᐃᐦᑯᓈᐤ ᐋᒄ ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᐄᔥᐱᐦ ᑳ ᓂᓈᔅᑯᒧᑦ ᐋᒄ ᑳ ᐱᐱᐦᐧᑳᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑳ ᒫᒥᔮᑦ ᒥᓯᐧᐋ ᐹᐦᐹᔨᒄ ᐋ ᑎᔑᔨᒡ, ᐋᐦ ᐄᑖᑦ, “ᐅᑎᓈᐦᒄ ᐆ, ᒧᐧᐋᐦᒄ, ᐋᐅᒄ ᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ᐋᒄ ᐊᓂᔮᔨᐤ ᒥᓂᐦᐧᑳᑭᓂᔨᐤ ᑳ ᐅᑎᓂᐦᒃ, ᒌ ᓂᓈᔅᑯᒫᐤ ᒋᔖᒥᓂᑑ, ᐋᒄ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ᒥᓯᐧᐋ ᒫᒃ ᐋ ᑎᔑᔨᒡ ᒌ ᒥᓂᐦᐧᑳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ᑳᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᓂᒥᐦᒄ, ᐊᓐ ᒑ ᐅᐦᒋᑭᐧᐃᑖᑭᓂᐧᐃᒡ ᒥᐦᒑᑐ ᐊᐧᐋᓐ ᐅᐦᒋ᙮ ᐆ ᓂᒥᐦᒄ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᐧᐃᔨᔥᑖᒡ ᐅᔅᒋ ᓂᔅᑯᒥᑐᐧᐃᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓈᐧᐋᐤ, ᓂᒧᐃ ᒦᓐ ᓂᑭ ᐅᐦᒋ ᒥᓂᐦᐧᑳᓐ ᔔᒥᓈᐳᐃ ᐹᑎᔥ ᐋ ᐅᔥᑳᑭᒦᐦᒡ ᔔᒥᓈᐳᐃ ᒥᓂᐦᐧᑳᔮᓈ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐧᐃᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᑭᒧᒡ ᐊᔨᒥᐦᐋᐤ ᓂᑭᒧᐧᐃᓂᔨᐤ ᐋᒄ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᐱᔅᐧᑳᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᐆ ᐊᓅᐦᒡ ᒑ ᑎᐱᔅᑳᒡ ᒥᓯᐧᐋ ᐋ ᑎᔑᔮᒄ ᒋᑭ ᓂᑭᓯᓈᐧᐋᐤ, ᐊᓐ ᐅᐦᒋ ᑖᓐ ᒑ ᑐᑖᑯᐧᐃᔮᓐ, ᐧᐋᔥ ᐊᐧᑳᑎᔥᑖᔨᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᑭ ᓃᐦᑎᐦᐧᐋᐤ ᐊᓐ ᒫᓂᔥᒑᓂᔑᐧᐄᔨᔨᐤ, ᐋᒄ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ ᒑ ᓯᒑᔮᒧᐦᒑᓂᐧᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ᐄᔥᐱᐦ ᒫᒃ ᒌ ᐧᐃᓂᔥᑳᓂᑯᔮᓈ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᓂᑭ ᐄᑐᐦᑖᓐ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᐊᔑᓂᐧᐋᐦᐄᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ᐲᑎᕐ ᒫᒃ ᒌ ᓂᔥᐧᑳᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᓂᑭᑎᑎᓐ ᓃᔨ ᐋᑎ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᓂᑭᑎᔅᑳ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐧᐄᐦᑎᒫᑎᓐ, ᐋᐧᒫᔮ ᐧᐋᐧᐋᒡ ᓃᐧᔖᐤ ᒋᔅᑐᑦ ᓈᐹ ᐹᐦᑭᐦᐋᐦᐧᑳᓐ ᒑ ᐅᑖᑯᔑᔨᒡ ᔖᔥ ᓂᔅᐧᑖᐤ ᒋᑭ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ᐲᑎᕐ ᓈᔥᒡ ᒋᐧᐄᐦ ᑖᑆᐤ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᐦᑖ ᓂᑭ ᐅᐦᒋ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᑖᓐ, ᐋᑎ ᐄᔑᓈᑯᐦᒑ ᒑ ᓂᐱᔮᓐ ᓂᐱᐦᐄᑭᐧᐃᔨᓈ᙮” ᐋᔪᐧᐃᒄ ᑳᐦ ᐃᔨᒡ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ᑭᑎᓰᒫᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, “ᐋᑯᑖᐦ ᐅᑎᐦ ᐊᐱᒄ᙮ ᓂᑭ ᓂᑑᐊᔨᒥᐦᐋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ᐋᒄ ᑳ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐲᑎᕐ, ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒥᓯᒥᔅᑳᑰ ᒥᓯᒫᔨᐦᑎᒧᐧᐃᓂᔨᐤ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᑯᔑᑯᒥᐦᒋᐦᐆ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓈᔥᑖᑆᐦ ᒥᓯᒫᔨᐦᑎᒻ ᓂᑎᐦᒑᐦᒄ, ᐧᑳᑎᒥᐦᒋᐧᐃᔮᓐ ᐋ ᐹᓲᓈᑰᐦᒡ ᒑ ᓂᐱᔮᓐ᙮ ᐋᑯᑖᐦ ᐅᑎᐦ ᑖᒄ, ᒥᒄ ᒫᒃ ᐊᑳᐧᐄ ᐧᐄᐦ ᑭᐧᐃᐦᑯᔑᒄ ᐋ ᐊᔑᓂᐧᐋᓯᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ᓈᑖᐦ ᒫᒃ ᐊᐅᔅᑖᓰᔥ ᒌ ᐄᑐᐦᑖᐤ ᒌᓴᔅ, ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᑳ ᐄᔑ ᐱᐦᒋᔑᒥᐱᔨᐦᐅᑦ᙮ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᐋ ᓂᑐᑎᒫᑦ ᐃᓯᓈᑯᓃᔨᒑ ᐊᑯᔅ ᐋᑳ ᒑ ᒌ ᐧᐃᓯᒑᐦᐄᑎᐦᒃ ᓈᑦ ᒑ ᐧᐃᓯᒑᐦᐄᑎᒨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ᒌ ᐃᔨᐤ ᒫᒃ, “ᐋᐹ, ᓅᐦᑖ, ᓂᒧᐃ ᑎᑯᓐ ᒑᐧᑳᓐ ᐋᑳ ᒑ ᒌ ᑐᑎᒥᓐ ᒌᔨ᙮ ᐄᒑᓂᒨ ᒫᐦ ᐆ ᑖᓐ ᒑ ᐄᔑ ᐧᐄᓯᒑᔨᐦᑖᒧᐧᐋᐹᓈ᙮ ᒥᒄ ᒫᒃ, ᒌᔨ ᒋᑎᐄᑖᔨᐦᑎᒧᐧᐃᓐ ᒋᑭ ᑐᑖᑭᓂᐤ, ᓂᒧᐃ ᓃᔨ ᓂᑎᑖᔨᐦᑎᒧᐧᐃᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᑳᐤ ᒌ ᓈᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᓂᔥᑎᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᒥᓯᐧᐋ ᒫᒃ ᒌ ᓂᐹᔨᐤ᙮ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐲᑎᕐ, “ᓵᐃᒥᓐ, ᒌ ᓂᐹᓐ ᐋ? ᓂᒧᐃ ᐋ ᐧᐋᐧᐋᒡ ᑰᐦᒌᐦ ᑎᓐ ᐹᔨᐧᑳᐤ ᐋᐦᒋᓂᐧᑳᓂᐦᑖᔨᒡ ᐋᑳ ᒑ ᒌ ᓂᐹᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋ ᓂᔥᑎᔨᒡ, “ᔮᐧᑳᒦᒄ ᑭᔮᐦ ᐊᔨᒥᐦᐋᒄ ᐋᑳ ᒑ ᒌ ᔑᐦᑯᒋᐦᐄᑯᔮᒄ ᑯᐧᑳᒋᐦᐄᐧᐋᐧᐃᓐ᙮ ᐧᐋᔥ ᒋᑎᐦᒑᐦᑯᐧᐋᐦᒡ ᓈᔥᑖᑆᐦ ᑯᐃᔅᒄ ᒋᐧᐄᐦ ᑎᓈᐧᐋᐤ ᒥᒄ ᒫᒃ ᒋᔮᐧᐋᐦᒡ ᓂᒧᐃ ᒥᑐᓐ ᒋᓵᐱᓰᓈᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ᐋᒄ ᒦᓐ ᑳ ᓂᑭᑖᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ᙮ ᑳ ᐊᔨᒥᐦᐋᑦ ᒦᓐ ᒋᔖᒥᓂᑑ, ᐋᔪᐧᐃᒄ ᐊᔮᐱᒡ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ᒦᓐ ᒫᒃ ᓂᔮᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒦᓐ ᑳ ᑭᐧᐃᐦᑯᔒᑯᐱᓈᓂᐦᐄ᙮ ᐧᐋᔥ ᔖᔥ ᓂᒧᐃ ᒦᐦᐧᑳᒡ ᐅᐦᒌ ᑑᐦᑳᐱᔨᐤ ᑳ ᐃᔥᐱᔥ ᐧᐄ ᓂᐹᔨᒡ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᒑ ᐄᑖᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ᐋᒄ ᒑᒃ ᓂᔥᐧᑖᐤ ᑳ ᓈᑖᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐋᔥᒄ ᐋ ᒋᓂᐹᓈᐧᐋᐤ? ᐋᔥᒄ ᐋ ᒋᑎᔨᐧᐋᓯᓈᐧᐋᐤ? ᐋᑯᓐ ᐋᒄ, ᔖᔥ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓐ ᒑ ᐄᔅᐱᔨᑯᐱᓈ᙮ ᐄᑖᐱᒄ ᒫᐦ, ᔖᔥ ᒫᒥᓯᐦᐋᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᔮᐦ ᒑ ᐄᔥ ᐅᑎᓂᑭᓅᑦ ᑭᔮᐦ ᒑ ᒌ ᑎᐹᔨᒥᑯᑦ ᐅᒥᒋᐧᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ᐧᐃᓂᔥᑳᒄ᙮ ᒫᒌᑖᐤ᙮ ᑭᓂᐧᐋᐱᒫᐦᒄ ᒫᐦ ᐊᓐ ᒑ ᒫᒥᔑᒥᐦᑦ ᔖᔥ ᐹᔓᓈᑯᓲ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ᐋᔥᒄ ᒫᒃ ᒫᐧᑳᒡ ᐋ ᐊᔨᒥᑦ ᒌᓴᔅ ᒌ ᐅᐦᒋ ᑎᑯᔑᓂᔨᐤ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᒌ ᐹᒋ ᐧᐄᒑᑯᔨᐤ ᐋ ᒫᒨ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᔨᒡ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑯᐧᐋᔨᒡᐦ᙮ ᒌ ᐹᒋ ᑎᐦᑯᓂᒧᒡ ᒫᒃ ᓂᑐᐱᔫᐦᑯᒫᓐ ᑭᔮᐦ ᐅᑖᒥᐦᐄᑭᓈᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ᐊᓐ ᒑ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᒌ ᓃᑳᓐ ᐧᐄᐦᑎᒧᐧᐋᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᑳ ᐧᐄᒑᐅᑯᑦ ᑖᓐ ᒑᑎᒃ᙮ ᒌ ᐄᑖᒑ, “ᐊᓐ ᒑ ᐅᒑᒥᒃ ᓈᐹᐤ ᐋᐅᒄ ᐊᓐ ᓈᐹᐤ ᓈᑎᐧᐋᔨᒫᒄ᙮ ᐋᐅᒄ ᐊᓐ ᒑ ᐅᑎᓈᒄ ᒑ ᒋᔅᑐᐦᑎᐦᐋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒃ ᒍᑖᔅ ᑎᐧᐋᐦᒡ ᒌ ᓈᑖᐤ ᒌᓴᔅᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ᙮” ᐋᒄ ᑳ ᐅᒑᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ᐋᒄ ᑳ ᐅᑎᓈᒡᐦ ᒌᓴᔅᐦ ᓲᐦᒃ ᐋ ᒫᒫᐦᒋᑯᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ᐹᔨᒄ ᒫᒃ ᐊᐧᐋᓐ ᐊᓂᑎᐦ ᐋ ᓃᐴᐧᐃᑦ ᐋ ᓈᓈᑭᒋᐦᐄᐧᐋᑦ ᒌ ᐅᐦᒋ ᑯᔨᑯᐱᑎᒻ ᐅᓂᑐᐱᔫᐦᑯᒫᓐ ᐋᒄ ᑳ ᒥᓂᓯᐧᒫᑦ ᐅᐦᑎᐅᑳᔨᐤ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ᒌᓴᔅ ᑳ ᐅᐦᒋ ᐊᔨᒥᑦ ᐋᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᓂᑎᐧᐋᐱᒥᑯᑦ, “ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐹᒋ ᓂᑎᐧᐋᐱᒥᔮᒄ ᒨᐦᑯᒫᓐᐦ ᑭᔮᐦ ᐅᑖᒥᐦᐄᑭᓈᐦᑎᒄᐦ ᐋ ᐹᒋ ᑎᐦᑯᓂᒫᒄ? ᐋᔪᐧᐃᒄ ᐋᑑᑎᐧᐋᑭᓅᑦ ᒋᒧᑎᔅᒃ ᐋ ᐧᐄᐦ ᑳᐦᒋᔅᑎᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᓂᒌ ᑖᓐ ᐊᓂᑖᐦ ᑖᐧᐋᔨᔥ ᐋᐦ ᑖᔮᒄ ᐋ ᒋᔅᑯᑎᒫᒑᔮᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᐱᒫᔨᒥᓈᐧᐋᐤ᙮ ᒥᒄ ᒫᒃ ᓂᑎᐧᐋᔨᐦᑖᑯᓐ ᑖᓐ ᐋᑎᔥᑖᒡ ᐊᓂᑎᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᔮᔨᑖ ᒑ ᑎᐱᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ᐋᒄ ᒥᓯᐧᐋ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᑳ ᓂᑭᑎᑯᑦ ᐋ ᐅᔑᒧᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ᒌᐦ ᑖᐤ ᓈᐹᔥ ᐋ ᐅᔅᒋᓃᒋᐧᐃᑦ ᐋ ᓅᔔᔥᑯᐧᐋᑦ ᒌᓴᔅᐦ᙮ ᒌ ᑎᐦᑎᐦᐱᔮᐦᒋᔥᑭᒻ ᐋ ᐱᒋᐧᐃᔮᓈᒋᓂᔨᐤ ᐋ ᒥᔑᑎᐧᐋᔮᒋᔅᑭᐦᒃ᙮ ᐋᒄ ᐱᔅᒡ ᓈᐹᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᑳ ᐅᑎᓂᑯᑦ, ");
INSERT INTO crl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ᒥᒄ ᒫᒃ ᒌ ᑎᒋᔅᒋᐱᔨᐦᐆ ᐋᒄ ᑳ ᐅᔑᒧᑦ ᐊᓐ ᓈᐹᔥ ᐋᐦ ᐋᑎᒧᔖᔥᑭᑖᐱᐦᑖᑦ ᐋ ᒌ ᒥᓂᐱᑖᑭᓂᐧᐃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᑎᐦᑎᐱᔮᐦᒋᔥᑭᐦᒃ ᐱᒋᐧᐃᔮᓈᒋᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ᐋᒄ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᒌᓴᔅᐦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᓂᔥᑐᐧᐄᐧᐋᑯᐱᓈ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐧᐋᒡ ᐄᔨᔨᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ᐲᑎᕐ ᒫᒃ ᐧᐋᐦᐄᐧᐃᔥ ᐊᓂᑖᐦ ᒌ ᐹᒋ ᓅᔔᔥᑳᒑᐤ᙮ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐅᐧᐋᔅᑳᐦᐄᑭᓂᒥᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᑳᐦ ᑖᑦ᙮ ᒌ ᐧᐋᐱᒫᐤ ᐋᐱᒋᐦᐋᑭᓐ ᐃᔥᑯᑖᔨᐤ ᐋ ᐧᐋᔅᑳᐱᔥᑎᒦᒡ ᐋ ᐊᐆᔓᔨᒡ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳ ᓈᑖᑦ ᑳᐦ ᐋᑎᐧᐄᑎᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᐊᓂᒌ ᑳ ᒫᒨᐱᔥᑎᐦᒡ ᐋ ᐧᐃᔮᔨᐦᑖᑭᓂᐧᐃᔨᒡ ᒑᐧᑳᔨᐤ ᒋᐧᐄᐦ ᓈᓂᑐ ᒥᔅᑭᒧᒡ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᐄᔑ ᐊᑖᒫᔨᒫᒡ ᒌᓴᔅᐦ, ᐋᒄ ᒫᒃ ᒑ ᒌ ᐄᑎᔓᐧᐋᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔅᑭᐧᒫᐅᒡ ᒑᐧᑳᔨᐤ ᒑ ᒌ ᐄᔑ ᐊᑖᒫᔨᐦᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᐃᔨᐅᒡ ᒑᐧᑳᔨᐤ ᐋ ᐧᐄᐦ ᒫᒥᔑᒫᒡ ᒌᓴᔅᐦ, ᓂᒧᐃ ᑖᐱᔥᑯᓐ ᐅᐦᒋ ᐄᑎᐦᑖᑯᓂᔨᐤ ᐊᓂᔮ ᑳ ᐄᔑ ᐧᐋᐧᐄᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ᐋᒄ ᐱᔅᒡ ᓈᐹᐅᒡ ᑳ ᐅᐦᒋ ᐱᓯᑯᒡ ᐋᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐧᐄᐦᑎᐦᒡ ᐋ ᓂᓂᑐᔨᒡ, ᐋᐦ ᐃᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ᓂᒌ ᐹᐦᑎᐧᐋᓈᓐ ᐋᐦ ᐃᔨᑦ, ‘ᓂᑭ ᓂᔑᐅᓈᒋᑖᓐ ᐆ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᓈᐹᐤ ᑳ ᐅᔑᐦᑖᑦ, ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᒦᓐ ᑯᑎᒡ ᓂᑭ ᐧᐃᔨᑳᐳᐦᑖᓐ ᐋᐦᐋᑳ ᓈᐹᐤ ᐅᐦᒋ ᐅᔑᐦᑖᑦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ ᐅᒌ ᓈᐹᐅᒡ ᐅᐦᒋ ᑖᑆᐦᑖᑭᓂᐧᐃᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐧᐄᐦᑎᐦᒡ, ᓂᒧᐃ ᑖᐱᔥᑯᓐ ᐅᐦᒋ ᐄᑎᐦᑖᑯᓂᔨᐤ ᐊᓂᔮ ᑳ ᐄᔑ ᐧᐋᐧᐄᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳ ᐅᐦᒋ ᐱᓯᑯᑦ ᒥᓯᐧᐋ ᑳ ᐅᐦᑎᔅᑯᑳᐳᔥᑎᐧᐋᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, ᐋᒄ ᑳ ᑯᐧᑳᒋᒫᑦ ᒌᓴᔅᐦ, “ᓂᒧᐃ ᐋ ᑎᑯᓐ ᒑᐧᑳᓐ ᐋ ᐧᐄᐦ ᐃᔨᓐ ᐊᓂᔮᔨᐤ ᐋᔨᑖᒋᒥᔅᒡ ᐅᒌ?” ");
INSERT INTO crl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑ ᒌᓴᔅ, ᓂᒧᐃ ᒑᐧᑳᔨᐤ ᐅᐦᒋ ᐃᔨᐤ᙮ ᒦᓐ ᑳ ᑯᐧᑳᒋᒥᑯᑦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ, “ᐋᐤ ᐋ ᒌᔨ ᙭, ᑳ ᔑᐧᐋᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ?” ");
INSERT INTO crl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐋᐦᐋ, ᐋᐅᒄ ᓃᔨ᙮ ᒋᑭ ᐧᐋᐱᒫᐧᐋᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐊᐱᑦ ᐊᓂᑖᐦ ᑳ ᓲᐦᑳᑎᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᐅᓂᐦᐄᐧᐃᓂᐦᒡ ᐄᑖᐦᒑ᙮ ᑭᔮᐦ ᒋᑭ ᐧᐋᐱᒫᐧᐋᐤ ᐹᒋ ᑎᑯᔑᓂᒑ ᒋᐦᒋᒌᔑᒄ ᑭᔥᑭᐧᐃᓂᔅᑰᐦᒡ ᐋ ᐅᐦᒋ ᓅᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ᐄᔥᐱᐦ ᐱᔮᐦᑎᐧᐋᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌ ᐲᑯᐱᑎᒻ ᐅᒑᐧᑳᓂᒻ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᒌ ᓂᑎᐧᐋᔨᒫᓅᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐹᒋ ᐧᐄᐦᑎᐦᒡ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᑭᔮᐦ ᒫᒃ ᑖᓐ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ᒌ ᐹᐦᑎᐧᐋᐧᐋᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᑖᓐ ᒫᒃ ᐧᐋᐦ ᑐᑎᐧᐋᒄ?” ᒥᓯᐧᐋ ᒫᒃ ᐋᑎᓯᒡ ᒌ ᐃᔨᐅᒡ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐧᐄᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ᐱᔅᒡ ᒫᒃ ᒌ ᔑᐦᐧᑳᑖᐅᒡ ᑭᔮᐦ ᒌ ᐊᑯᐧᐋᐱᐧᑳᐧᐋᐅᒡ ᐋᒄ ᑳ ᐅᑎᑖᒥᐦᐧᐋᒡ ᐋᐦ ᐄᑖᒡ, “ᐊᐧᐋᓐ ᑳ ᐅᑖᒥᐦᐆᔅᒃ ᒋᑎᐄᑖᔨᐦᑖᓐ?” ᐧᐋᐧᐋᒡ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᐧᐋᔓᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᒌ ᐅᑎᑖᒧᐦᐅᑰ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᒋᔅᑐᐦᑎᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ᐋᔥᒄ ᐊᓂᑖᐦ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᒌᐦ ᑖᐤ ᐲᑎᕐ ᑳ ᐅᐦᒋ ᐱᒧᐦᑖᔨᒡ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔅᐧᑳᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ᐆ ᐋᐱᒋᐦᐋᑭᓐ ᐃᔅᐧᑳᐤ ᐄᔥᐱᐦ ᐧᐃᔮᐱᒫᑦ ᐲᑎᕐ ᐋ ᐊᐆᔓᔨᒡ, ᑯᐃᔅᒄ ᒌ ᑭᓂᐧᐋᐱᒫᐤ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌᔨ ᑭᔮᐦ ᒋᒌ ᐱᐹᐧᐄᒑᐧᐋᐤ ᒌᓴᔅ, ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ᐲᑎᕐ ᒫᒃ ᒌ ᓂᑎᔨᐤ, ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᑭᔮᐦ ᓂᒧᐃ ᓂᓂᔅᑐᐦᑖᓐ ᒑᐧᑳᓐ ᐆ ᑳᐦ ᐋᔨᒨᑎᒥᓐ᙮” ᐋᒄ ᑳ ᐱᓯᑯᑦ ᐋᒄ ᐊᓂᑖᐦ ᐋ ᐃᔥᐧᑳᐦᑖᒨᐧᐃᔨᒡ ᐊᓂᔮᔨᐤ ᐧᐋᔅᑳᐦᐄᑭᓂᔨᐤ ᑳ ᐄᑐᐦᑖᑦ᙮ ᑳ ᐅᐦᒋ ᒋᔅᑑᔨᒡ ᓈᐹᐹᐦᑭᐦᐋᐦᐧᑳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ᑳ ᐧᐋᐱᒫᑦ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐃᔅᐧᑳᐤ ᐊᓂᑖᐦ ᐋ ᓃᐴᐧᐃᔨᒡ ᐲᑎᕐ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᐊᓂᑖᐦ ᑳ ᓈᓃᐴᔨᒡ, “ᐋᐅᒄ ᐊᓐ ᐹᔨᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ᒥᒄ ᒫᒃ ᐲᑎᕐ ᒦᓐ ᒌ ᐋᐧᓈᐦᑎᒻ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ᐹᑎᒫ ᒦᓐ ᒌ ᐄᑎᑰ ᐊᓂᑎᐦ ᑳ ᓈᓃᐴᔨᒡ, “ᓂᒧᐃ ᒋᑭ ᒌ ᐃᔨᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᐱᐹᐧᐄᒑᐅᑦ ᐧᐋᔥ ᒌ ᓂᔅᑐᐦᑖᑯᓯᓐ ᑳᓕᓖᐦᒡ ᐋ ᐅᐦᒋᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐲᑎᕐ, “ᒥᑐᓐ ᐋᐦᑖᑆᔮᓐ ᒋᔖᒥᓂᑑ ᐋᐦᐹᑑᑦ, ᑭᔮᐦ ᓈᔥᒡ ᒋᐧᐄᐦ ᑖᑆᐤ ᐋᐦ ᐄᑖᑦ, ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᐤ ᐆ ᓈᐹᐤ ᑳᐦ ᐋᔨᒨᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ᔑᔥᒋᑯᒡ ᒫᒃ ᒦᓐ ᒌ ᐅᐦᒋ ᒋᔅᑑ ᓈᐹᐦᐹᐦᑭᐦᐋᐦᐧᑳᓐ ᐋᒄ ᐲᑎᕐ ᑳ ᐅᐦᒋ ᒋᔥᒋᓯᑦ ᑳᐦ ᐄᑎᑯᑦ ᒌᓴᔅᐦ, “ᐋᔥᒄ ᐋᐧᒫᔮ ᓃᐧᔖᐤ ᒋᔅᑐᑖ ᓈᐹᐤ ᐹᐦᑭᐦᐋᐦᐧᑳᓐ ᓂᔥᐧᑖᐤ ᒋᑭ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᔨᓐ᙮” ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒥᔥᑎᐦ ᒫᑑᑦ ᐲᑎᕐ ᐋ ᒋᔥᒋᓯᑦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ᐧᐄᐱᒡ ᐧᐃᔮᐱᓃᔨᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᓂᔥᑐᐧᐃᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐧᐋᔨᒡ ᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᑭᔮᐦ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᐋ ᐧᐃᔮᔨᐦᑖᑭᓂᐧᐃᔨᒡ ᒑᐧᑳᔨᐤ, ᐋᒄ ᑳ ᐧᐃᔮᔨᐦᑎᐦᒡ ᑖᓐ ᒑᐦ ᑎᒡ᙮ ᒌ ᒫᐦᑯᐱᑖᐅᒡ ᒌᓴᔅᐦ ᐋᒄ ᐊᓂᑖᐦ ᐹᔨᓕᑦ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᑐᐦᑎᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ᐋᒄ ᐹᔨᓕᑦ ᑳ ᑯᐧᑳᒋᒫᑦ ᒌᓴᔅᐦ, “ᐋᐤ ᐋ ᒌᔨ ᒎᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ?” ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᐋᓐ ᐃᔮᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ᒥᔥᑏᐦ ᒑᐧᑳᔨᐤ ᒌᐦ ᑎᑯᓂᔨᐤ ᐋ ᒌ ᐄᔑ ᐊᑖᒫᔨᒫᒡ ᒌᓴᔅᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ᐋᒄ ᐹᔨᓕᑦ ᒦᓐ ᑳ ᑯᐧᑳᒋᒫᑦ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐋ ᒋᑭ ᐅᐦᒋ ᓂᔥᐧᑳᐅᔑᐦᐋᐅᒡ? ᓂᑑᐦᑑᒡ ᒫᐦ ᐋ ᐄᔑ ᓂᓈᐦᑭᐤ ᒑᐧᑳᔨᐤ ᐊᑖᒫᔨᒥᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ᐊᔮᐱᒡ ᓂᒧᐃ ᐅᐦᒋ ᐧᐄᐦ ᒋᔅᑑ ᒌᓴᔅ᙮ ᐹᔨᓕᑦ ᒫᒃ ᓄᐧᐃᒡ ᒌ ᒥᔅᑳᑖᔨᒫᐤ ᐋᐦᐋᑳ ᒋᔅᑑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ᐋᒄ ᑳ ᒌ ᑎᓈᓂᐧᐃᒡ ᒫᓐ ᑎᐦᐧᑖᐤ ᐧᐋᑎᐦᒋᐱᔨᐦᒡ ᐊᓂᑎᐦ ᑳ ᒌ ᒦᒋᓈᓂᐧᐃᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ, ᐹᔨᓕᑦ ᒌ ᐱᒋᔅᑎᓈᐤ ᐹᔨᒄ ᐊᐧᐋᔨᐤᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐋᐦ ᑖᔨᒡ ᒥᒄ ᑖᓂᔮ ᐊᓂᔮᔨᐤ ᓈᑎᐧᐋᔨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑭᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᒫᐧᑳᒡ, ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐹᕌᐹᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᐋᑯᑖᐦ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐧᐄᒋᐦᐄᑯᑦ ᐋ ᓂᔅᑯᔅᑎᐧᐋᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᒌ ᓂᐱᐦᐋᒑ ᓈᐹᐤ ᒫᐧᑳᒡ ᐅᔮᔨᐤ ᑳ ᐄᔨᐦᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ᐋᒄ ᐊᓂᒌ ᐋ ᒫᒨ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᒌ ᐹᒋ ᓈᑖᐅᒡ ᐹᔨᓕᑦ, ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒑ ᒌ ᑐᑎᒫᑯᒡ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᑐᑎᒫᑯᒡ ᐋᔑᑯᒻ ᐱᐳᓐ ᐄᔥᐱᐦ ᒫᑯᔖᓂᐧᐃᔨᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᐹᔨᓕᑦ, “ᒋᓂᑎᐧᐋᔨᒥᓈᐧᐋᐤ ᐋ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑎᑯᒡ ᒎᐧᐃᔨᔫᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ?” ");
INSERT INTO crl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ᐧᐋᔥ ᒌ ᒋᔅᒑᔨᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋ ᐅᐦᑖᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐧᐋᐦᒋ ᐹᒋ ᐄᑎᔑᐦᐧᐋᔨᒡ ᐊᓂᑖᐦ ᐧᐄᔨ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ᐋᒄ ᐅᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᔒᐦᒋᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌᐦ ᐄᑖᔨᒡ ᐹᔨᓕᑦ, ᐹᕌᐹᔅ ᑎᔨᑯᒡ ᒑ ᒌ ᐱᒋᔅᑎᓂᒧᐧᐋᑭᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ᐋᒄ ᐹᔨᓕᑦ ᒦᓐ ᑳ ᑯᐧᑳᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᑖᓐ ᒫᒃ ᐋ ᐄᔑ ᓈᑎᐧᐋᔨᒥᔮᒄ ᒑ ᒌ ᑐᑎᐧᐃᐦᒄ ᐊᓐ ᒎᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ ᑳ ᐃᔑᓂᐦᑳᑖᒄ?” ");
INSERT INTO crl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“ᒌᔅᑖᔅᑯᐦᐋᐦᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ,” ᒌ ᐄᔑ ᓂᔥᐧᑳᐅᔑᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ, “ᒑᐧᑳᔨᐤ ᐋᒄ? ᑖᓐ ᒫᒃ ᑳ ᐄᔑ ᒥᒌᐦᑐᑎᐦᒃ?” ᐋᒄ ᐋᐦᒡ ᑳᐦ ᐋᔑᐦᐧᑳᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, “ᒌᔅᑖᔅᑯᐦᐋᐦᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ,” ᐋ ᐄᔑ ᑖᑆᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ᐹᔨᓕᑦ ᒫᒃ ᒋᐧᐄᐦ ᓈᓂᐦᐄᐧᐋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᒄ ᑳ ᐱᒋᔅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᐹᕌᐹᔅ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐱᔑᔥᑖᐦᐅᒫᑭᓂᐧᐃᔨᒡ ᒌᓴᔅᐦ ᐋᒄ ᑳ ᐱᒋᔅᑎᓈᑦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᒑ ᒌ ᓂᑑᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐧᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ᐊᓂᒌ ᒫᒃ ᓂᑐᐱᔨᐧᐃᒡ ᐊᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐅᒋᒫᐅᑭᒥᑯᔨᐤ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᒌᓴᔅᐦ᙮ ᑳ ᓂᑐᒫᒡ ᒥᓯᐧᐋ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᓂᑐᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ᐋᒄ ᑳ ᐳᔥᑭᒧᔮᐦᒡ ᐊᑯᐦᐱᔨᐤ ᐋ ᒥᐦᐧᑳᑭᓃᔨᒡ ᑭᔮᐦ ᒌ ᐅᔑᐦᑖᐅᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐊᔥᑐᑎᓂᔨᐤ, ᑳᑳᐧᐋᔅᑯᓃᔨᒡ ᓃᐱᓰᔮᐦᑎᒄ ᐋᐦ ᐋᐱᒋᐦᑖᒡ᙮ ᐋᔪᐧᐃᒄ ᐅᔮᔨᐤ ᑳ ᐳᒋᔥᑐᑎᓂᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ᒌ ᒫᔮᔨᒫᐅᒡ ᒧᔮᒻ ᐋ ᒫᒥᐦᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᐋᐅᒄ ᒌᔨ ᒎᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ᐋᒄ ᑳ ᐅᑖᒥᔅᑎᐧᑳᓈᐦᐧᐋᒡ ᒥᔥᑎᒄ ᐋᐦ ᐋᐱᒋᐦᑖᒡ᙮ ᒌ ᔑᐦᐧᑳᑖᐅᒡ ᑭᔮᐦ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᒡ ᐅᐦᑎᔅᑰ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᒧᔮᒻ ᐋ ᒋᔅᑖᔨᒫᒡ ᐋᐦ ᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒫᔮᔨᒫᒡ ᐋᒄ ᑳ ᒥᓂᐱᑎᐧᒫᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᐦᐧᑳᑭᓃᔨᒡ ᐊᑯᐦᐱᔨᐤ ᑳ ᒋᒋᔥᑭᒥᔨᒡ, ᐋᒄ ᐧᐄᔨ ᐅᒑᐧᑳᓂᒥᔨᐤ ᑳ ᐳᔥᑭᒧᔮᐦᒡ᙮ ᐋᒄ ᑳ ᐧᐃᔨᐧᐄᐦᑎᐦᐋᒡ ᑳᐦ ᐋᑎ ᒌᑐᐦᑎᐦᐊᒡ ᒑ ᓂᑑᒌᔅᑖᔅᑯᐦᐧᐋᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ᓵᐃᒥᓐ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᓈᐹᐤ ᓵᐊᕇᓂᐦᒡ ᐋ ᐅᐦᒌᑦ ᓂᐦᐋᐤ ᐊᓂᑎᐦ ᒌ ᐹᒋ ᐱᒧᐦᑖᐤ, ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐋ ᐅᐦᑐᐦᑖᑦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᐅᐦᑖᐧᐄᒡ ᐋᓕᒃᓵᓐᑎᕐ ᑭᔮᐦ ᕈᕙᔅ᙮ ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᓈᐹᐤ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᓯᒋᒫᒡ ᒑ ᒌ ᐱᒧᐦᑎᐦᐋᔨᒡ ᒌᓴᔅᐦ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ᐧᑳᓪᐧᑳᕧ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᒌᓴᔅᐦ᙮ ᐆ ᐧᑳᓪᐧᑳᕧ ᑳ ᐄᓈᓅᒡ, ᐊᓂᑎᐦ ᐋᐦᑎᑯᐦᒡ ᒥᔥᑎᐧᑳᓂᑭᓐ ᐄᔑ ᐄᐧᑖᔥᑎᒧᐧᐋᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ᒋᐧᐄᐦ ᒥᓂᐦᐋᐅᒡ ᒫᒃ ᔔᒥᓈᐴᔨᐤ ᑭᔮᐦ ᒧᔮᒻ ᓂᑑᐦᑯᔨᓂᔨᐤ ᒥᕐ ᐋ ᒌ ᒌᑯᓂᑭᓂᐧᐃᔨᒡ ᐊᓂᑎᐦ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐧᐄᐦ ᒥᓂᐦᐧᑳᐤ ᒌᓴᔅ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ᐋᒄ ᑳ ᒌᔅᑖᔅᑯᐦᐧᐋᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᒑᐧᑳᓂᒥᔨᐤ ᒋᐧᐄᐦ ᑖᐅᓂᒫᑑᐧᐃᒡ᙮ ᒌ ᐧᐄᑖᐅᐦᐄᒑᐧᐃᒡ, ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐧᐃᔮᔨᐦᑎᐦᒡ ᐊᐧᐋᔨᐤᐦ ᒑ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒑᐧᑳᓂᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ᐹᔨᑯᔥᑖᐤ ᒌ ᐄᔅᐱᔨᐤ ᐋ ᒑᒋᔖᐹᔮᔨᒡ ᑳ ᒌᔅᑖᔅᑯᐦᐧᐋᒡ ᒌᓴᔅᐦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ᒌ ᒥᓯᓈᑖᔨᐤ ᒫᒃ ᐊᓂᑎᐦ ᐊᔥᐱᒦᔑᔥ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᑖᒫᔨᒫᒡ᙮ ᒌ ᐄᑎᔅᑖᔨᐤ, “ᒎᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ᑭᔮᐦ ᒫᒃ ᓃᔓ ᒋᒧᑎᔅᒃ ᒌ ᒌᔅᑖᔅᑯᐦᐧᐋᐅᒡ, ᐹᔨᒄ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐅᓂᐦᐄᐧᐃᓂᐦᒡ ᐄᑖᐦᒑ ᒌ ᐊᑯᒋᓂᔨᐤ, ᐋᒄ ᐊᓐ ᑯᑎᒃ ᐊᓂᑖᐦ ᐅᓂᒥᐦᒌᐧᐃᓂᐦᒡ ᐄᑖᐦᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ᒌ ᑎᐱᐱᔨᐤ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᒥᓯᓂᐦᐄᑭᓂᐧᐃᒡ ᐊᓂᑖᐦ ᐧᐋᔥᑭᒡ ᒌᓴᔅ ᐋ ᒌ ᐋᔨᒨᒫᑭᓅᑦ᙮ ᑳᐄᑎᔅᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒌ ᐊᓯᑎᓈᑭᓂᐤ ᐊᓂᑖᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᐲᑯᓂᒥᔨᒡ ᐧᐄᔓᐧᐋᐧᐃᓐ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᐧᐋᔨᐤᐦ ᑳ ᐹᒋ ᐱᒧᐦᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒌ ᒫᔮᔨᒥᑰ᙮ ᒌ ᐧᐋᐧᐋᐱᔅᐧᑳᔫᒡ, ᐋᐦ ᐄᔨᔨᒡ, “ᑖᑆᐦ ᑭᔨᑆ᙮ ᒌᔨ ᑳᐦ ᐃᔨᓐ ᒑ ᒌ ᓂᔑᐅᓈᒋᑖᔨᓐ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᐋᒄ ᒫᒃ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ ᑳᐤ ᒑ ᒌ ᐧᐃᔨᑳᐳᐦᑖᔨᓐ, ");
INSERT INTO crl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ᐧᐄᒋᐦᐄᓲ ᒫᒃ, ᐹᒋ ᓃᔖᐦᑎᐧᐃᐦ ᐊᓐ ᒋᑎ ᐋᔑᑖᔮᐦᑎᑯᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ᐋᒄ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐧᐄᔓᐧᐋᐧᐃᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᒌ ᒫᔮᔨᒫᐅᒡ ᐊᓂᑎᐦ ᐋ ᐊᔨᒥᐦᐄᑐᒡ ᐋᐦ ᐃᔨᒡ, “ᒌ ᐱᒫᒋᐦᐋᐤ ᑯᑎᒃ ᐊᐧᐋᔨᐤᐦ, ᓂᒧᐃ ᐧᐋᐧᐋᒡ ᒌ ᐱᒫᒋᐦᐄᓲ ᐧᐄᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ᐆ ᙭, ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐧᐋᐤ, ᒋᐱᐦ ᒌ ᓃᔖᐦᑎᐧᐃᐤ ᐊᓂᔮᔨᐤ ᐋᔑᑖᔮᐦᑎᒄ ᐋ ᑭᓂᐧᐋᐱᒥᐦᒄ, ᐋᒄ ᒫᒃ ᒋᐱᐦ ᑖᑆᐦᑖᓈᓂᐤ᙮” ᐊᓂᒌ ᒫᒃ ᑯᑎᑭᒡ ᑳ ᒌᔅᑖᔅᑯᐦᐧᐋᑭᓂᐧᐃᒡ ᒌ ᒫᔮᔨᒫᐅᒡ ᑭᔮᐦ ᐧᐄᔨᐧᐋᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ᑳᐦ ᐋᐱᐦᑖᒌᔑᑳᒡ ᒫᒃ ᐋᑯᑖᐦ ᒥᑐᓐ ᐋ ᑭᔅᑎᐱᔅᑳᒡ ᑳ ᐃᓯᓈᑯᐦᒡ ᒥᓯᐧᐋ ᐋ ᐃᔥᐱᔖᒡ ᐊᓂᑎᐦ ᐊᓐ ᐊᔅᒌ᙮ ᓂᔥᑐ ᐋᐦᒋᓂᐧᑳᓂᐦᑖᒡ ᐋᐅᒄ ᐊᓐ ᑳ ᐃᓯᓈᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ᓂᔥᑐ ᒫᒃ ᐋᐦ ᐄᔅᐱᔨᒡ ᒌᓴᔅ ᐋ ᒋᐧᔖᐧᐋᑦ ᑳᐦ ᐃᔨᑦ, “ᐄᐧᓛᐄ, ᐄᐧᓛᐄ, ᓛᒫ ᓵᐹᑭᑖᓃ?” ᒫᐤ ᐋ ᐄᔑ ᐊᐧᑖᔥᑎᒧᐧᐋᑖᑭᓅᐦᒡ ᐆ, “ᓂᒋᔖᒥᓂᑑᒻ, ᓂᒋᔖᒥᓂᑑᒻ, ᒑᐧᑳᓐ ᐧᐋᐦᒋ ᐹᒋ ᓂᑭᓯᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓃᐱᐧᐃᒡ ᐊᓂᑎᐦ ᐄᔥᐱᐦ ᐱᔮᐦᑎᐧᐋᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌ ᐃᔨᐅᒡ, “ᓂᑐᐦᑎᐧᐋᐦᒄ ᒫᐦ, ᐄᓛᐃᒑ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ᐋᒄ ᐹᔨᒄ ᐊᓐ ᒌ ᐄᔥᐱᐦᑖᐤ ᒑ ᒌ ᓂᑑᐊᑯᐦᑖᑦ ᐅᐦᐱᓂᒡ ᑳ ᐄᑖᔨᑖᑯᓃᔨᒡ ᐧᐄᓯᑳᐳᐦᒡ, ᒥᔅᑎᑯᐦᒡ ᑳ ᐊᐧᑳᐱᐦᑳᑎᐦᒃ ᐋᒄ ᐅᑐᓃᔨᒡ ᑳ ᐃᑎᓂᐧᒫᑦ ᒑ ᒌ ᔔᐱᐦᑎᒥᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐊᔑᐧᐋᐱᑖᐤ, ᓈᓈᑭᒋᐦᐋᑖᐤ ᑖᑆᐦ ᒑ ᐹᒋ ᓃᐦᑎᓂᑰᐧᑳ ᐄᓛᐃᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ᒌᓴᔅ ᒫᒃ ᒌ ᐅᐦᒋ ᐹᐦᑖᑯᓯᐤ ᐋ ᒋᐧᔖᐧᐋᑦ, ᐋᒄ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ᐃᔥᐱᔥ ᒫᒃ ᓂᐦᐋᐤ ᑳᐦ ᓂᐱᑦ, ᐋᒄ ᐊᓐ ᐋᑰᐧᐋᑭᐦᐄᑭᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᒥᑐᓐ ᒌ ᐳᔅᐧᑳᒋᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ᐊᓐ ᒫᒃ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᐅᐦᑎᔅᑯᑳᐳᔥᑎᐧᐋᑦ ᒌᓴᔅᐦ ᐄᔥᐱᐦ ᐧᐃᔮᐱᒫᑦ ᑖᓐ ᑳ ᐄᔑᓂᐱᔨᒡ, ᒌ ᐃᔨᐤ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑖᑆᐦ ᑳᐦ ᐋᐧᐃᔨᑯᐱᓈᓂᐦᐄ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ᒌᐦ ᑖᐅᒡ ᑭᔮᐦ ᐃᔅᐧᑳᐅᒡ ᓈᑖᐦ ᐧᐋᐦᐄᐧᐃᔥ ᐋ ᐅᐦᒋ ᓈᓈᑭᒋᐦᐄᐧᐋᒡ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᑭᔮᐦ ᑳᐦ ᑖᒡ ᒣᕇ ᒫᒃᑖᓖᓐ, ᑭᔮᐦ ᓵᐧᓛᒥ, ᑭᔮᐦ ᒣᕇ, ᒉᒥᔅ ᑳ ᐊᐧᐋᔑᔒᐧᐃᑦ ᑭᔮᐦ ᐧᒑᓯᔅ ᐅᑳᐧᐄᐧᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ᐋᐅᑯᓂᒡ ᐅᒌ ᐃᔅᐧᑳᐅᒡ ᑳ ᓅᔔᔥᑯᐧᐋᒡ ᒌᓴᔅᐦ ᒫᐧᑳᒡ ᐋᔥᒄ ᑳᓕᓖᐦᒡ ᐋ ᒌᐦ ᑖᔨᒡ ᑭᔮᐦ ᑳ ᐧᐋᐧᐄᒋᐦᐋᒡ᙮ ᒥᐦᒑᑐ ᑭᔮᐦ ᑯᑎᑭᒡ ᐃᔅᐧᑳᐅᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐊᓂᒌ ᑳ ᐧᐄᒑᐧᐋᒡ ᒌᓴᔅᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐹᒋ ᐄᑐᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ᐋᐅᒄ ᐧᐋᔥ ᐊᓐ ᐹᐦᐧᑳᓯᑭᓂᒌᓯᑳᒡ ᑳ ᐃᔮᔅᑭᐧᐄᐦᑳᑭᓂᐧᐃᒡ ᐅᑎᔨᒥᐦᐋᐅᒌᔑᑳᒧᐧᐋᐤ ᒎᐄᔨᔨᐅᒡ᙮ ᐊᓐ ᒫᒃ ᐋᑎᓈᒡ ᐅᑖᑯᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ᓈᐹᐤ ᒍᓯᕝ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᑳ ᑎᑯᔑᐦᒃ, ᐋᕆᒫᕠᔮ ᒌ ᐃᔑᓂᐦᑳᑖᔨᐤ ᐃᐦᑖᐧᐃᓂᔨᐤ ᐊᓂᑖᐦ ᑳ ᐅᐦᒌᔨᑦ, ᓈᔥᒡ ᒌ ᒋᔅᑖᔨᒥᑰ ᐧᐄᒋᐅᒋᒫᐤ ᑳ ᒫᒨᐱᔨᒡ᙮ ᐧᐄᔨ ᒫᒃ ᑭᔮᐦ ᒌ ᓈᓂᑐᐧᐋᐱᐦᑎᐧᒫᐤ ᒋᔖᒥᓂᑑ ᐅᒋᒫᐧᐃᓂᔨᐤ᙮ ᐋᒄ ᒍᓯᕝ ᑳᐦ ᐋᑎ ᓂᑎᐧᐋᐱᒫᑦ ᐹᔨᓚᑦᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᑯᔥᑖᒋᑦ, ᑳ ᑯᐧᑳᒋᒫᑦ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᒌᓴᔅᐦ ᐧᐄᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ᐹᔨᓕᑦ ᒫᒃ ᒌ ᑯᔥᐧᑳᔨᐦᑎᒻ ᐋ ᐹᐦᑎᐦᒃ ᔖᔥ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒌᓴᔅᐦ᙮ ᒌ ᓂᑑᒫᐤ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔫᒋᒫᐤ ᐋᒄ ᑳ ᑯᐧᑳᒋᒫᑦ ᑖᑆᐦ ᔖᔥ ᑳ ᓂᐱᔨᐧᑳᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ᐄᔥᐱᐦ ᒫᒃ ᐧᐋᐦᑎᒫᑯᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔫᒋᒫᐤ ᔖᔥ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᐹᔨᓕᑦ ᑳ ᓂᔅᑯᒫᑦ ᒍᓯᕝᐦ ᒑ ᒌ ᐅᑎᓂᒥᔨᒡ ᒌᓴᔅᐦ ᐧᐄᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ᐋᒄ ᒍᓯᕝ ᑳ ᓂᑑᐅᑎᓂᐦᒃ ᐋ ᒥᐧᔮᑭᔑᔨᒡ ᐱᒋᐧᐃᔮᓈᒋᓂᔨᐤ ᐋ ᐧᐋᐹᑭᓃᔨᒡ, ᐋᒄ ᑳ ᓂᑑᓃᐦᑎᓂᐧᒫᑦ ᒌᓴᔅᐦ ᐧᐄᔮᔨᐤ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐱᒋᐧᐃᔮᓂᒋᓂᒡ ᑳ ᑎᐦᑎᐹᔮᒋᓂᐧᒫᑦ ᐊᓂᔮᔨᐤ ᐧᐄᔮᔨᐤ ᐋᒄ ᐧᐋᑎᐧᑳᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᒡ ᐊᓂᑎᐦ ᒌᐲᑭᒥᑯᐦᒡ ᑳ ᓂᑑᓂᐦᐋᐧᐃᔥᑖᑦ᙮ ᐋᒄ ᑳ ᑎᐦᑎᐱᓈᑦ ᐋᐦᒦᐦᒑᐱᔅᒌᐦᒡ ᐊᓯᓃ ᐊᓂᑖᐦ ᐋ ᐱᑯᓈᔮᔨᒡ ᐊᓂᔮᔨᐤ ᐧᐋᑎᐧᑳᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᐤ, ᐋᑯᑖᐦ ᑳ ᒋᐱᔑᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ᒣᕇ ᒫᒃᑖᓖᓐ ᑭᔮᐦ ᒣᕇ, ᐧᒑᓯᔅ ᐅᑳᐧᐄ, ᐋᑯᑖᐦ ᑳᐦ ᑖᒡ, ᒌ ᐧᐋᐱᐦᑎᐧᒫᐅᒡ ᑖᓂᑖᐦ ᑳ ᐱᒥᔑᒫᑭᓂᐧᐃᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ᐄᔥᐱᐦ ᒫᔮᐅᐱᔨᒡ ᒎᐄᔨᔨᐅᒡ ᐅᑎᔨᒥᐦᐋᐅᒌᔑᑳᒧᐧᐋᐤ ᐊᓂᒌ ᐃᔅᐧᑳᐅᒡ ᒣᕇ ᒫᒃᑖᓖᓐ, ᑭᔮᐦ ᓵᐧᓛᒦ, ᑭᔮᐦ ᒣᕇ ᒉᒥᔅ ᐅᑳᐧᐄᔨ ᒌ ᓂᑑᐅᑎᓂᒑᐅᒡ ᓂᓈᐦᑭᐤ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐋ ᒥᔪᒫᑯᓰᔨᒡ ᑑᒥᓂᑭᓐ ᒑ ᒌ ᑑᒥᓂᐧᒫᒡ ᒌᓴᔅᐦ ᐧᐄᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ᐧᐄᐱᒡ ᒫᒃ ᒋᔮᒋᔖᐹᔮᔨᒡ ᓃᔥᑎᒻ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᔮᔨᐤ ᒦᓐ ᒑ ᐋᑎ ᑎᐧᐃᔥᑖᔨᒡ, ᐄᔥᐱᐦ ᐱᔮᒋ ᓅᑯᓰᔨᒡ ᐲᓯᒻ, ᐊᓂᑖᐦ ᑳ ᐧᐋᑎᐧᑳᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᒡ ᒌ ᐄᑐᐦᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌ ᐄᑎᑐᒡ, “ᐊᐧᐋᓐ ᒫᒃ ᒑ ᐄᒑ ᑎᐦᑎᐱᓂᒫᑎᐦᒄ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᑳ ᒋᐱᔑᒫᑭᓂᐧᐃᔨᒡ ᐊᓂᑎᐦ ᐋ ᐱᑯᓈᔮᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ᐧᐋᔥ ᓈᔥᒡ ᒌ ᒥᒑᐱᔅᒋᔨᐤ ᐊᓂᔮᔨᐤ ᐊᓯᓃ᙮ ᐋᐦ ᐄᑖᐱᒡ ᒫᒃ ᐊᓂᑖᐦ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᔖᔥ ᑳ ᐄᒑᑎᐦᑎᐱᓂᒫᑭᓂᐧᐄᑯᐱᓈᓂᐦᐄ ᐊᓂᔮᔨᐤ ᐊᓯᓃᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ᐋᒄ ᑳ ᐲᐦᒑᒡ ᐊᓂᔮᔨᐤ ᑳ ᐧᐋᑎᐧᑳᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᒡ ᐊᓂᑎᐦ ᒌᐲᑭᒥᑯᐦᒡ᙮ ᐊᓂᑖᐦ ᒫᒃ ᓂᐦᐄᐧᐃᓂᐦᒡ ᐄᑖᐦᒑ ᒌ ᐧᐋᐱᒫᐅᒡ ᐅᔅᒋᓃᒋᐤ ᐋ ᐊᐱᔨᒡ ᐋ ᐧᐋᐹᔅᐱᓱᔨᒡ᙮ ᓄᐧᐃᒡ ᒫᒃ ᒌ ᓵᒑᐦᐄᑎᒨᒡ ᐧᐃᔮᐱᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ᒌ ᐄᑎᑯᒡ ᒫᒃ, “ᐊᑳᐧᐄ ᓵᒋᓯᒄ᙮ ᒌᓴᔅ ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ ᒌ ᐹᒋ ᓈᓂᑐᐧᐋᔨᒫᐧᐋᐤ, ᐊᓐ ᑳ ᒌᔅᑖᔅᑯᐦᐧᐋᑭᓅᑦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᒌ ᐧᐃᓂᔥᑳᐤ, ᓂᒧᐃ ᑖᐤ ᐅᑎᐦ᙮ ᑭᓂᐧᐋᐱᐦᑎᐧᒫᒄ ᒫᐦ ᐊᓂᑎᐦ ᑳ ᐱᒥᔑᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ᒫᒌᒄ ᒫᒃ ᓂᑑᐧᐄᐦᑎᒫᒫᐦᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᑭᔮᐦ ᐲᑎᕐ ᐧᐄᐦᑎᒧᐧᐋᐦᒄ, ᐋ ᓃᑳᓂᐦᑖᔨᒡ ᒌᓴᔅᐦ ᑳᓕᓖᐦᒡ ᐋᐦ ᐄᑐᐦᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᐧᐋᐱᒫᒄ, ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑳ ᐄᑎᑖᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ᐋᒄ ᑳ ᐧᐃᔨᐧᐄᐱᐦᐄᑐᒡ ᐊᓂᒌ ᐃᔅᐧᑳᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐧᐋᑎᐧᑳᐱᔅᑭᐦᐄᑭᓂᐧᐃᔨᒡ ᐋ ᓂᓂᒥᐱᔨᒡ ᑭᔮᐦ ᐋ ᓵᒋᓯᒡ᙮ ᓂᒧᐃ ᐊᐧᐋᔨᐤᐦ ᐅᐦᒋ ᐊᔨᒥᐦᐋᐅᒡ ᑳ ᐃᔥᐱᔥ ᑯᔥᑖᒋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᐧᐃᓂᔥᑳᑦ ᓂᐱᐧᐃᓂᐦᒡ ᐅᐦᒋ ᐧᐄᐱᒡ ᐋ ᒑᒋᔖᐹᔮᔨᒡ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᐋ ᒌᔑᑳᔨᒡ ᒦᓐ ᒑ ᑖᐅᔥᑖᔨᒡ ᒣᕇ ᒫᒃᑖᓖᓐ ᓃᔥᑎᒻ ᒌ ᓅᑯᓰᔥᑎᐧᐋᐤ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤ ᑳ ᐧᐃᔨᐧᐄᑎᔑᐦᐆᒫᑦ ᓃᐧᔖᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᒌ ᐲᐦᒋᔥᑳᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ᒣᕇ ᒫᒃᑖᓖᓐ ᒫᒃ ᒌ ᓂᑑᐧᐄᐦᑎᒧᐧᐋᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐧᐋᔨᐤᐦ ᑳ ᒌ ᐧᐋᐧᐄᒑᐧᐋᔨᒡ ᒌᓴᔅᐦ᙮ ᒌ ᓂᓈᑳᒋᒧᔨᐤ ᑭᔮᐦ ᒌ ᑯᔑᑯᑖᐦᐋᔨᐤ ᑳ ᐅᑎᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐧᐋᒡ ᐅᔮᔨᐤ ᐃᔅᐧᑳᐤ ᐋᐦ ᐄᔨᔨᒡ ᐋ ᐱᒫᑎᓰᔨᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᐋ ᒌ ᐧᐋᐱᒫᔨᒡ ᓂᒧᐃ ᐅᐦᒋ ᐧᐄᐦ ᑖᑆᐦᑎᐧᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ᐹᑎᒫ ᒫᒃ ᒌᓴᔅ ᒌ ᓅᑯᓰᔥᑎᐧᐋᐤ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒫᐧᑳᒡ ᐋ ᐱᒧᐦᑖᔨᒡ ᐧᐃᔨᐧᐄᑎᒥᐦᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᒡ᙮ ᐃᔨᐦᒡ ᒌ ᐃᓯᓈᑯᓯᐤ ᐊᓂᔮᔨᐤ ᑳ ᓅᑯᓰᔥᑎᐧᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ᐄᔥᐱᐦ ᑳ ᒌᐧᐋᒡ ᐋᒄ ᑳ ᐧᐄᐦᑎᒧᐧᐋᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᑭᔮᐦ ᐅᐦᒋ ᐧᐄᐦ ᑖᑆᐦᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ᐹᑎᒫ ᒫᒃ, ᒌᓴᔅ ᒌ ᓅᑯᓰᔥᑎᐧᐋᐤ ᐊᓂᔮᔨᐤᐦ ᐹᔨᑯᔖᑉᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐᐦ ᒫᐧᑳᒡ ᐋ ᒫᒨᒦᒋᓱᔨᒡ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ᙮ ᒌ ᐋᐧᓈᔨᒫᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᐧᓈᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐋ ᒥᔅᑯᔅᑎᐧᑳᓈᔨᒡ, ᐋᐦᐋᑳ ᐅᐦᒋ ᐧᐄᐦ ᑖᑆᐦᑎᐧᐋᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐧᐋᐱᒥᑯᑦ ᐹᑎᒫ ᑳ ᐧᐃᓂᔥᑳᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒫᒌᒄ ᒥᓯᐧᐋ ᐋᔅᐱᑎᔅᑭᒥᑳᒡ ᐆ ᐊᔅᒌ ᒑ ᑭᒑᔅᐧᑳᔮᒄ ᐋ ᐧᐋᐧᐄᐦᑎᒫᒄ ᐆ ᒥᐧᔮᒋᒧᐧᐃᓐ ᒥᓯᐧᐋ ᐊᐧᐋᓐ ᒑ ᒌ ᐹᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ᐊᓐ ᐊᐧᐋᓐ ᒑ ᑖᑆᐦᑎᒧᐧᑳ ᑭᔮᐦ ᓰᑭᐦᐋᐦᑐᐧᐋᑭᓂᐧᐃᒑ ᑭᑎ ᐱᒫᒋᐦᐋᑭᓂᐤ, ᐋᒄ ᐊᓐ ᐊᐧᐋᓐ ᐋᑳ ᒑ ᑖᑆᐦᑎᒧᐧᑳ ᑭᑎ ᓂᔑᐧᐃᓈᒋᒫᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ᑳ ᑖᑆᐦᑎᐦᒡ ᑭᑎ ᒥᔮᑭᓂᐧᐃᒡ ᓲᐦᑳᑎᓰᐧᐃᓂᔨᐤ ᒑ ᒌ ᑐᑎᐦᒡ ᓂᓈᐦᑭᐤ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑎᔨᐧᐋᐧᐃᓐᐦ᙮ ᒥᒋᐊᐦᒑᐦᒄ ᑭᑎ ᐧᐃᔨᐧᐄᑎᔑᐦᐧᐋᐅᒡ ᓂᑎᔑᓂᐦᑳᓱᐧᐃᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ ᑭᔮᐦ ᐋᐅᔅᑳᔨᒡ ᐊᔨᒧᐧᐃᓐ ᑭᑎ ᐄᔑ ᐋᔨᒨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ᐅᑎᓈᐧᑖᐧᐋ ᐊᒋᓈᐱᒄ, ᑭᔮᐦ ᒫᒃ ᒥᓂᐦᐧᑳᐧᑖᐧᐋ ᒑᐧᑳᔨᐤ ᐋ ᐱᐦᒋᐳᔨᐧᐋᔨᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐧᐃᔮᔥ ᑐᑖᑯᒡ᙮ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᐧᐋᔨᐤᐦ ᑭᑎ ᑖᒋᓈᐧᐃᒡ ᐋᒄ ᒫᒃ ᒑ ᒦᓂᐧᐋᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ᐹᑎᒫ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒌ ᐄᔑ ᐅᐦᐱᔅᑳᐤ᙮ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᓂᐦᐄᐧᐃᓃᔨᐦᒡ ᐄᑖᐦᒑ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᐅᐧᐋᔨᐱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ᐋᒄ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐧᐋᑭᓂᒡ ᒥᓯᐧᐋ ᐊᓂᑖᐦ ᒌ ᐱᐹᐄᑐᐦᑖᐅᒡ ᐋ ᑭᒑᔅᐧᑳᒡ᙮ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐧᐄᒋᐦᐄᑯᒡ, ᒑ ᒌ ᐧᐋᐱᐦᑎᔨᐧᐋᔨᒡ ᐋ ᑖᑆᒥᑭᓃᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᒑᔅᐧᑳᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᓂᓈᐦᑭᐤ ᒫᒥᔥᑳᒡ ᐧᐋᐱᐦᑏᐧᐋᐧᐃᓐ ᐋ ᒌᐦ ᑑᑎᐦᒡ᙮ ᐋᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ᒌᔨ ᑎᔻᕕᓚᔅ ᒑᔅᑖᔨᐦᑖᑯᓯᔨᓐ, ᒋᒥᓯᓈᐦᐋᒫᑎᓐ ᐊᓐ ᒥᔻᒋᒧᐎᓐ ᑖᓐ ᑳ ᐄᔑ ᐱᒫᑎᓰᑦ ᒌᓴᔅ ᒫᒀᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑖᐙᔨᔥ ᐋᐦᑖᐎᒋᐦᑦ ᑳᐦ ᑖᑦ᙮ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᒥᓯᓂᐦᐋᒧᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐄᔑ ᑎᐱᐱᔨᒡ ᑳ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒧᔨᒥᐦᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᓃᔥᑎᒻ ᑳ ᐙᐱᒫᒡ ᑭᔮᐦ ᑳ ᐹᐦᑎᐙᒡ ᒌᓴᔅᐦ᙮ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᑳ ᐐᐦᑎᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ᐋᒄ ᒫᒃ ᓈᔥᒡ ᔮᒀᐦ ᑳ ᓂᑑᑭᒑᔅᒑᔨᐦᑎᒫᓐ ᐆ ᒥᓯᐙ ᒑᒀᓐ ᑖᓐ ᓂᐦᐋᐤ ᑳᐦ ᐋᑎ ᐃᔅᐱᔨᒡ ᐅᔥᑭᒡ ᑳᐦ ᒋᐦᒋᐱᔨᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔮᓐ ᒑ ᒥᔻᔑᑯᐱᓈ ᑭᔮᐦ ᓃᔨ ᒑ ᒌ ᒥᓯᓂᐦᐋᒧᐙᐹᓈ ᐋ ᐐᐦᑎᒫᑖᓐ ᒥᓯᐙ ᑖᓐ ᓂᐦᐋᐤ ᑳᐦ ᐋᑎ ᐃᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ᐆ ᒫᒃ ᓂᑎᐦᑐᑖᓐ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒥᓐ ᐋ ᑖᑆᒥᑭᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᑭᐎᔨᓐ ᐊᓂᑖᐦ ᐅᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ᒫᒀᒡ ᐦᐁᕆᑦ ᑳ ᒋᐦᒋᐅᒋᒫᐅᑦ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ, ᒌᐦ ᑖᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᓵᑳᕌᔮ ᐋ ᒌ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᐊᓂᔮ ᐊᐹᐃᒑ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒌᔨᑦ ᓵᑳᕌᔮ᙮ ᐐᐤᐦ ᒫᒃ ᐃᓕᓯᐱᑦ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ᙮ ᐆ ᒫᒃ ᐃᓕᓯᐱᑦ ᐊᓂᑖᐦ ᐁᕋᓐ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᑖᑯᐱᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ᓵᑳᕌᔮ ᑭᔮᐦ ᐃᓕᓯᐱᑦ ᒌ ᑯᐃᔅᑯᑖᑎᓯᐎᒡ᙮ ᒥᑐᓐ ᒌ ᓂᓂᐦᐄᐦᑎᒸᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᑎᔑᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᓂᐦᐋᔨᐦᑎᒥᐦᐋᐅᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐃᔮᐙᐅᒡ ᐊᐙᔑᔥ ᐙᔥ ᐃᓕᓯᐱᑦ ᓂᒧᐃ ᐅᐦᒌ ᓂᑖᐅᔖᐤ, ᑭᔮᐦ ᒫᒃ ᔖᔥ ᑖᐱᔥᑯᓐ ᒌ ᒋᔖᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ᐊᓂᒌ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒫᒦᔅᑯᒡ ᒌ ᐋᐱᑎᓰᐎᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᐹᔨᒀᐤ ᒫᒃ ᒫᒀᒡ ᐊᓂᑎᐦ ᐋ ᒌ ᐅᑎᐦᒋᐱᔨᒡ ᐐᔨ ᓵᑳᕌᔮ ᒀᔅᒌᐱᓐ ᒑ ᐋᐱᑎᓰᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ");
INSERT INTO crl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ᒌ ᐙᔮᐱᒫᑭᓂᐤ ᒑ ᒌ ᓯᔅᑭᐦᐋᐦᒃ ᑳ ᒥᔪᒫᔅᑖᔨᒡ ᒑᒀᔨᐤ ᐊᓂᑎᐦ ᑳ ᒌ ᒥᒋᔥᑎᐦᐋᒫᓂᐎᔨᒡ, ᐙᔥ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᐄᔑ ᓈᓈᑭᒋᐦᑖᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᐲᐦᒑᑦ ᐊᓂᑖᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᒡ ᒑ ᒌ ᓯᔅᑭᐦᐋᐦᒃ ᑳ ᒥᔪᒫᔅᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ᒫᒀᒡ ᒫᒃ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᐦ ᑖᑦ ᓵᑳᕌᔮ, ᑳ ᐅᑎᐦᒋᐱᔨᒡ ᒑ ᐃᔅᒀᓯᑭᓂᐎᔨᒡ ᑳ ᒥᔪᒫᔅᑖᔨᒡ, ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑖᐦ ᒌᐦ ᑖᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋ ᒫᒨᐊᔨᒥᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ᓵᑳᕌᔮ ᒫᒃ ᒌ ᓅᑯᓰᔥᑖᑰ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ, ᐊᓂᑖᐦ ᓂᐦᐄᐎᓂᐦᒡ ᐄᑖᒑ ᐊᓂᑎᐦ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ᙮ ᐊᓂᑖᐦ ᑳ ᒌ ᐃᔥᒀᓯᑭᓂᐐᒡ ᑳ ᒥᔪᒫᔅᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᓃᐴᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ᐄᔥᐱᐦ ᒫᒃ ᓵᑳᕌᔮ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᒌ ᑯᔥᑯᓲ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᓵᒋᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᐊᑳᐐ ᓵᒋᓯᐦ, ᓵᑳᕌᔮ, ᐙᔥ ᒋᒌ ᐹᐦᑖᒄ ᒋᔖᒥᓂᑑ ᑖᓐ ᑳ ᐄᔑ ᓂᑐᑎᒧᐙᑦ᙮ ᒌᐅᐤ ᐃᓕᓯᐱᑦ ᒋᑭ ᒋᒋᔥᑭᐙᐤ ᐊᐙᔑᔥ, ᒋᑭ ᓈᐹᔒᐎᔨᐤ᙮ ᒞᓐ ᒫᒃ ᒋᑭ ᐃᔑᓂᐦᑳᑖᐤ ᐊᓐ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ᓈᔥᒡ ᒫᒃ ᒋᑭ ᒥᔻᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᓈᔥᒡ ᒋᑭ ᓯᒋᔮᓯᓈᐙᐤ᙮ ᒥᐦᒑᑐ ᑭᔮᐦ ᐄᔨᔨᐅᒡ ᒋᑭ ᒥᔻᑎᒧᒡ ᐄᔥᐱᐦ ᐱᒫᑎᓰᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐅᐙᔮᐱᒥᑰ ᐊᓐ ᐊᐙᔑᔥ ᐙᔥ ᒋᔅᑖᔨᐦᑖᑯᓂᔨᐤ ᑖᓐ ᐙᐦ ᐄᑖᐱᒋᐦᐄᑯᑦ᙮ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᒥᓂᐦᒀᐤ ᔔᒥᓈᐴᔨᐤ ᑭᔮᐦ ᐃᔥᑯᑖᐙᐴᔨᐤ᙮ ᐙᔥ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒥᑐᓐ ᒋᑭ ᓵᑭᔅᒋᓈᔥᑳᑰ ᐋᐦ ᐋᑎ ᐋᔥᒄ ᒫᒀᒡ ᐅᑳᐐᐦ ᐋ ᑭᓂᐙᔨᒥᑯᑦ ᐅᔅᐱᔮᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ᒥᐦᒑᑐ ᒫᒃ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒋᑭᑐᑎᐙᐤ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ, ᑳᐤ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐙᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐅᒋᔖᒥᓂᑑᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ᒞᓐ ᒫᒃ ᒋᑭ ᓃᑳᓐ ᐄᑎᔑᐦᐙᑭᓂᐤ ᒑ ᒌ ᐐᒋᐦᐋᑦ ᒋᔖᒥᓂᑑ ᐅᑏᔨᔨᒥᔨᐤ ᒑ ᒌ ᐃᔮᔅᑭᐎᔨᒡ ᑎᑯᔑᓃᔨᒑ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᒋᑭ ᐃᔮᐙᐤ ᐊᓂᔮᔨᐤ ᐊᐦᒑᐦᒄᐦ ᑳ ᓵᑭᔅᒋᓈᔅᑳᑯᔨᒡ ᐊᓂᔮ ᐄᓛᐃᒑ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᒋᔖᒥᓂᑑ ᑳ ᒌ ᐋᔨᒦᔥᑎᒧᐙᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐃᔮᔨᒡ ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨ ᒑ ᐄᔑ ᐃᔮᑦ᙮ ᒋᑭᑐᑎᐙᐤ ᐅᐦᑖᐐᒫᐤ ᐅᑖᐦᐄᔨᐦᒡ ᒑ ᒌ ᓵᒋᐦᐋᔨᒡ ᐅᑎᐙᔑᔒᒥᔨᐤ᙮ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᒋᑭᑐᑎᐙᐤ ᒑ ᒌ ᐄᔑ ᑭᒑᐦᑖᐙᔨᐦᑎᒥᔨᒡ ᒸᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᑎᒃ ᒞᓐ ᒑ ᒌ ᐃᔮᔅᑭᐎᐦᐋᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓂᒋᐦᐋᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒫᑯᑦ ᓵᑳᕌᔮ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ᓵᑳᕌᔮ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᒑᔥᑎᓈᐦᐅᔮᓐ ᐋ ᑖᑆᒥᑭᐦᒡ ᐆ ᑳ ᐄᔑ ᐐᐦᑎᒧᔨᓐ, ᔖᔥ ᒫᒃ ᐋ ᒋᔖᐄᔨᔨᐎᔮᓐ ᑭᔮᐦ ᒫᒃ ᓃᐤ ᔖᔥ ᐋ ᒋᔖᐃᔥᒀᐙᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","ᐋᒄ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᑳ ᓂᔥᒀᐅᔑᐦᐄᑯᑦ, ᐋᐦ ᐄᑎᑯᑦ, “ᐋᐅᒄ ᓃᔨ ᑳᑉᕆᔨᓪ, ᓂᐦᐋᐤ ᐅᑖᔅᑎᒻ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᓂᓃᐱᐎᓐ ᐋᐦ ᐋᐱᑎᔒᔥᑐᐎᒄ᙮ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ ᒑ ᒌ ᐐᐦᑎᒫᑖᓐ ᐆ ᒥᔻᒋᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ᐋᒄ ᒫᒃ ᓂᑑᐦᑎ, ᓂᒧᐃ ᒋᑭ ᒌ ᐋᔨᒥᓐ ᐹᑎᔥ ᒌ ᐄᔅᐱᔨᐦᒑ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᑖᓐ᙮ ᐋᐅᒄ ᐆ ᒑ ᐅᐦᒌ ᑎᔨᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᑖᑆᐦᑎᐎᔨᓐ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᑖᓐ᙮ ᔮᔨᑖᐃ ᒋᑭ ᐄᔅᐱᔨᐤ ᐆ ᐅᑖᐦᒌᐱᔨᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᐊᔑᓂᐙᐦᐋᐅᒡ ᓵᑳᕌᔮ ᒑ ᐃᔥᐱᔥ ᐹᒋ ᐎᔨᐐᔨᒡ᙮ ᐋᒄ ᑳ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᒑᒀᔨᐤ ᐙᐦᒋ ᓈᔥᒡ ᓈᐅᔥ ᑖᔨᒡ ᐊᓂᑖᐦ ᐲᐦᑎᑭᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᒋ ᐎᔨᐐᑦ ᓵᑳᕌᔮ ᓂᒧᐃ ᐅᐦᒌ ᐊᔨᒨ᙮ ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᐄᑖᔨᐦᑎᒧᐦᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᐋ ᒌ ᐙᐱᐦᑎᔨᒫᑭᓂᐎᔨᒡ ᐲᐦᑎᑭᒥᐦᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᒥᒄ ᒌ ᐄᔑᓂᔥᒑᐱᔨᐦᐆ ᓵᑳᕌᔮ ᒑᒀᔨᐤ ᐋ ᐐᐦ ᐐᐦᑎᐦᒃ ᐋᐦᐋᑳ ᐅᐦᒌ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᒫᐦᒋᒡ ᑳᓯᑳᔨᒡ ᑳ ᒌᔥ ᐋᐱᑎᓰᑦ ᓵᑳᕌᔮ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᒄ ᑳ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ᐐᐱᒡ ᒫᒃ ᑖᑆᐦ ᒌ ᒋᒋᔥᑭᐙᔨᐤ ᐊᐙᔑᔥ ᐊᓂᔮᔨᐤ ᐐᐤᐦ ᐃᓕᓯᐱᑦᐦ᙮ ᓂᔮᔪ ᐲᓯᒻ ᒫᒃ ᒌ ᑳᔔᔥᑎᐙᔨᐤ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ᐋᒄ ᐃᓕᓯᐱᑦ ᑳᐦ ᐃᔨᑦ, “ᓂᒌ ᐱᒫᒫᔨᒧᓐ ᐋᐦᐋᑳ ᐅᐦᒌ ᐃᔮᐅᒃ ᐊᐙᔑᔥ, ᒥᒄ ᒫᒃ ᓂᒌᐦᑐᑎᒫᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᒌ ᐃᔮᒥᒡ ᐊᐙᔑᔥ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᐱᒫᒫᔨᒧᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ᐄᔥᐱᐦ ᒫᒃ ᑯᑣᔥᒡ ᑎᐦᑐ ᐲᓯᒻ ᑳ ᐃᔥᐱᔥ ᒋᒋᔅᑭᐙᑦ ᐊᐙᔑᔥ ᐃᓕᓯᐱᑦ, ᒋᔖᒥᓂᑑ ᒌ ᐄᑎᔑᐦᐙᐤ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᑳᑉᕆᔨᓪ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ, ᐊᓂᑖᐦ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ᐊᓐ ᐋᓐᒋᓐ ᒌ ᐄᑎᔑᐦᐙᑭᓂᐤ ᒑ ᒌ ᓂᑎᐙᐱᒫᑦ ᐅᔥᒋᓃᒋᔅᒀᐤ ᒣᕇ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᒣᕇ ᒫᒃ ᒋᐱᐦ ᒌ ᐅᓈᐹᒨ ᐊᓂᔮᔨᐤ ᒍᓯᕝᐦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᓈᐹᐤ ᒑ ᒌ ᐐᒋᒫᑦ᙮ ᐆ ᒫᒃ ᒍᓯᕝ, ᒌ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐤ ᐊᓂᔮᐦ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","ᒌ ᓂᑎᐙᐱᒥᑰ ᒫᒃ ᒣᕇ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒋᔮᒫᔨᐦᑎ, ᐙᔥ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐐᒑᒄ᙮ ᒋᔖᒥᓂᑑ ᒥᔥᑏᐦ ᒋᐐᐦ ᒋᔖᐙᑐᑖᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ᒣᕇ ᒫᒃ ᒌ ᓵᒋᓲ ᑭᔮᐦ ᒌ ᒥᑯᔅᑳᑖᔨᐦᑎᒥᐦᐄᑰ ᐅᔮᔨᐤ ᑖᓐ ᑳ ᐄᑖᑭᓅᑦ ᑭᔮᐦ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑰ ᐊᓂᔮᔨᐤ ᑳ ᐐᔑ ᐐᐦᑎᒫᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","ᒌ ᐄᑎᑰ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᐊᑳᐐ ᓵᒋᓯᐦ ᒣᕇ, ᐙᔥ ᒋᔖᒥᓂᑑ ᓄᐎᒡ ᒋᔑᐙᔨᒥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ᒋᑭ ᒋᒋᔥᑭᐙᐤ ᐊᐙᔑᔥ, ᓈᐹᔥ ᒋᑭ ᐃᔮᐙᐤ᙮ ᒌᓴᔅ ᒋᑭ ᐃᔑᓂᐦᑳᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ᓈᔥᑖᑆᐦ ᑭᑎ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ᙮ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ, ᐐᐦ ᐅᑯᓯᔅᐦ ᑭᑎ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ᙮ ᐙᔥ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ ᒋᑭ ᒋᒋᐅᒋᒫᐅᐦᐄᑰ ᐊᓂᑖᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ ᒧᔮᒻ ᑳ ᐄᔑ ᒋᐦᒋᐅᒋᒫᐅᐦᐄᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑖᓂᔥᑰᔒᒻ ᑌᕕᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ᑳᒋᒡ ᒋᑭ ᐃᔮᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒑ ᒌ ᐅᒋᒋᐅᒋᒫᒥᑖᑯᑦ᙮ ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᑎᐹᔨᐦᒋᒑᑦ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐃᔅᒀᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ᐋᒄ ᒣᕇ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐄᔅᐱᔨᒡ ᐆ, ᐋᐦᐋᑳ ᒫᒃ ᓂᐦᑖ ᐅᐦᒋ ᐱᒫᔨᒥᑦ ᓈᐹᐤ?” ");
INSERT INTO crl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒋᑭ ᐅᑎᐦᑎᒄ, ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ, ᐅᓲᐦᑳᑏᓰᐎᓂᐦᒡ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᒋᔥᑭᐎᑦ ᐊᐙᔑᔥ᙮ ᐋᔪᐎᒄ ᒫᒃ ᒑ ᐅᐦᒋ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐊᓐ ᐊᐙᔑᔥ ᒑ ᐱᒫᑎᓰᑦ ᑳ ᐱᔮᐦᒋᓰᑦ ᑭᔮᐦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ᐙᐙᒡ ᒋᐙᐦᑯᒫᑭᓐ ᐃᓕᓯᐱᑦ, ᑳ ᐄᑖᑭᓅᑦ ᒑᐦ ᐋᑳ ᒌ ᒋᒋᔥᑭᐙᑦ ᐊᐙᔑᔥ, ᔖᔥ ᑯᑣᔥᒡ ᑎᐦᑐ ᐲᓯᒻ ᒋᒋᔥᑭᐙᐤ ᐊᐙᔥᐦ, ᐋᑦ ᒫᒃ ᔖᔥ ᐋ ᒋᔖᐃᔅᒀᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒋᔖᒥᓂᑑ ᐋᑳ ᒑ ᒌᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ᐋᒄ ᒣᕇ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᔖᔥ ᓂᑭ ᐃᔮᔅᑭᐎᔨᓐ ᑖᓐ ᒑ ᐄᑖᐱᒋᐦᐄᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᑭᑎ ᐄᔅᐱᔨᐤ ᐊᓐ ᑳᐦ ᐃᔨᓐ᙮” ᐋᒄ ᒫᒃ ᑳ ᓂᑭᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ᐹᑎᒫ ᒫᒃ, ᒣᕇ ᒌ ᐄᑐᐦᑖᐤ ᐋ ᐐᐦ ᒫᒌᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᐋ ᐱᐹᔅᑯᑖᐅᐦᑳᔨᒡ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ᓵᑳᕌᔮ ᐐᒋᔨᐦᒡ ᒌ ᐲᐦᒑᐤ ᐋᒄ ᑳ ᐙᒋᔮᒫᑦ ᐊᓂᔮᔨᐤ ᐃᓕᓯᐱᑦᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ᐄᔥᐱᐦ ᒫᒃ ᐃᓕᓯᐱᑦᐦ ᑳ ᐙᒋᔮᒥᑯᑦ ᒣᕇ ᒌ ᒨᔑᐦᐋᐤ ᐋ ᐅᐦᒋ ᔮᔮᐦᒋᔨᒡ ᐅᑎᐙᔑᔒᒻ᙮ ᐋᒄ ᐃᓕᓯᐱᑦ ᑳ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒣᕇ ᐋ ᒋᔣᐙᑦ, “ᒌ ᒫᐅᒡ ᒋᔑᐙᔨᒫᒄ ᒋᔖᒥᓂᑑ ᐋᑎᓯᒡ ᐃᔅᒀᐅᒡ, ᑭᔮᐦ ᓈᔥᑖᑆᐦ ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᐊᐙᔑᔥ ᒑ ᒋᔥᑯᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ᓂᒥᔅᑳᑖᔨᐦᑖᓐ ᒫᒃ ᒑᒀᓐ ᓃᔨ ᐙᐦᒋ ᐹᒋ ᒧᐎᑎᓰᔨᒡ ᓂᑎᐹᔨᐦᒋᒑᒻ ᐅᑳᐐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ᐄᔥᐱᐦ ᑳ ᐹᒋ ᐙᒋᔮᒥᔨᓐ ᐊᓐ ᓂᑎᐙᔒᒻ ᒌ ᐅᐦᒋ ᐋᔮᐦᒌᐤ ᐋ ᒥᔻᔨᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ᑖᓐ ᒋᑎ ᐃᔥᐱᔥ ᔑᐙᔨᐦᑖᑯᓯᓈᒑ ᐙᔥ ᒥᑐᓐ ᒋᒌ ᑖᑆᐦᑎᒸᓐ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᔅᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑖᓐᒋᓂᒻᐦ ᒑ ᐄᔅᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ᐋᒄ ᒣᕇ ᑳᐦ ᐃᔨᑦ, “ᓂᒥᑐᓈᔨᒋᑭᓂᒡ ᓂᒋᐦᑳᔮᒋᒫᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ, ");
INSERT INTO crl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ᑭᔮᐦ ᓂᑎᐦᒑᐦᒄ ᒌ ᒧᒋᒑᔨᑎᒻ ᒋᔖᒥᓂᑑ ᓂᐱᒫᒋᐦᐄᐙᓰᒻ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ᐙᔥ ᓂᒥ ᐅᐦᒋ ᐋᑐᐙᓯᓂᐙᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔅᒀᒻ ᑳ ᑎᐱᑖᔨᑖᑯᓰᔨᒡ᙮ ᐙᔥ ᐙᐱᑎᒧᒄ, ᐊᓅᐦᒡ ᐅᐦᒋ ᐃᔥᑯᑎᒃ ᒥᓯᐙ ᒑ ᐋᑎ ᐊᔮᓂᔅᒑ ᐱᒫᑎᓰᓈᓂᐐᒡ, ᑖᑆᐦ ᒥᔻᔨᒨ, ᓂᑭ ᐄᑎᑯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ᐙᔥ ᐊᓐ ᑳ ᓲᐦᑳᑎᓰᑦ ᓂᒌᐦᑐᑎᒫᒄ ᒋᐦᒋ ᒑᒀᔨᐤ᙮ ᐱᔮᐦᑭᓂᔨᐤ ᒫᒃ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ᑭᑎ ᒥᓈᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒀᔅᐱᓂᔅᑖᑯᑦ, ᒨᔥ ᒑ ᐃᔥᐱᔥ ᐊᔮᓂᔅᒑ ᐱᒫᑎᓰᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ᐅᔅᐱᑐᓂᒡ ᒌ ᐅᐦᒋ ᓵᓱᒋᔨᐦᑎᐤ᙮ ᒌ ᐙᓯᔂᔮᒧᒑᐤ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑖᔨᒧᔨᒡ, ᐐᔨᐙᐤ ᑎᐱᔨᐙ ᐋ ᐄᑖᔨᐦᑎᒥᔨᒡ ᐅᑖᐦᐄᔨᐦᒡ, ᐋᐦ ᐋᐱᒋᑖᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ᐅᑖᐦᑎᐱᐎᓃᔨᒡ ᒌ ᐅᐦᒋ ᓃᔑᐱᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑎᓰᔨᒡ, ᑭᔮᐦ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳ ᑎᐱᑖᔨᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ᑳ ᐐ ᒥᒋᓱᔨᒡ ᒥᔪ ᒑᒀᔨᐤ ᒌ ᑎᐹᔨᐦᑎᒧᐦᐋᐤ, ᑳ ᐙᔪᑎᓰᔨᒡ ᒫᒃ ᐱᔑᔑᒄ ᒌ ᒋᐦᒋᑎᔑᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ᒌ ᐐᒋᐦᐋᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐃᔅᕋᐃᓚ ᐋ ᒋᔥᒋᓯᑦ ᒑ ᒌ ᒋᔅᑎᒫᒑᔨᒫᑦ, ");
INSERT INTO crl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ᒑ ᒋᔖᐙᑐᑎᐙᑦ ᐋᑉᕋᐦᐋᒻ, ᑭᔮᐦ ᐅᑎᐙᔑᔑᒥᔨᐤ ᒨᔥ ᑳᒋᒡ, ᒧᔮᒻ ᑳ ᐄᑖᑯᐱᓈ ᐋᑉᕋᐦᐋᒻ ᑭᔮᐦ ᒋᑖᓂᔅᑰᓯᒥᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒥᓯᐙ ᑳᐦ ᐃᔨᑦ ᒣᕇ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᑖᑦ ᐊᓂᑎᐦ ᐃᓕᓯᐱᑦᐦ ᐐᒋᔨᐦᒡ᙮ ᓂᔥᑐ ᐲᓯᒻ ᒌ ᐐᒋᒫᐤ, ᐋᒄ ᑳ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ᒑᒃ ᒌ ᐅᑎᐦᒋᐱᔨᐤ ᐃᓕᓯᐱᑦ ᒑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐙᔑᔒᒻ, ᒌ ᓈᐹᐅᔑᔨᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᒥᔨᒡ ᐅᐙᐦᑯᒫᑭᓐ ᑭᔮᐦ ᒥᓯᐙ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᐹᔓᒡ ᑳᐦ ᑖᔨᒡ, ᓈᔥᑖᑆᐦ ᒌ ᒥᔻᔨᐦᑎᒥᔨᐤ ᐋ ᒌ ᐹᐦᑎᒥᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᔪᑐᑎᒫᑯᑦ ᐃᓕᓯᐱᑦᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ᐄᔥᐱᐦ ᒫᒃ ᓂᔮᓈᓈᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐱᒫᑎᓰᑦ ᐊᓐ ᐊᐙᔑᔥ ᒥᓯᐙ ᐅᐙᐦᑯᒫᑭᓂᐙᐤ ᑭᔮᐦ ᐅᐐᒑᐙᑭᓂᐙᐤ ᒌ ᐹᒋ ᑎᑯᔑᓂᔨᐤ ᒑ ᒌᐦ ᑐᑎᐙᒡ ᑖᓐ ᑳ ᒌ ᑑᑎᐙᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ ᐋ ᓈᐹᐅᔑᔨᒡ, ᒌ ᒋᔅᒋᓄᐙᒋᔣᐅᒡ᙮ ᐅᐙᐦᑯᒫᑭᓂᐙᐤ ᒫᒃ ᓵᑳᕌᔮ ᒋᐐᐦ ᐃᔑᓂᐦᑳᑖᔨᐤ ᐅᔮᔨᐤ ᐊᐙᔑᔥ, ᒸᐦᒡ ᐅᐦᑖᐐᔨᐤ ᐋᔑᓂᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ᐅᑳᐐᐦ ᒫᒃ ᒌ ᓂᔅᒀᔒᐦᑖᔨᐤ, “ᓂᒧᐃ, ᒞᓐ ᒋᑭ ᐃᔑᓂᐦᑳᓲ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᑖᐅᒡ ᒋᐙᐦᑯᒫᑭᓄᐙᐅᒡ ᒞᓐ ᐋ ᐃᔑᓂᐦᑳᓱᒡ, ᐙᔥ ᐋᔑᓂᑳᓱᔨᒡ ᐅᐙᐦᑯᒫᑭᓐ ᒋᐱᐦ ᐄᔑ ᐎᒋᔓᒫᑭᓂᐤ, ᐋᐅᒄ ᑳ ᒌᐦ ᑎᓈᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ᐋᒄ ᒫᒃ ᑳ ᐄᔨᓯᓂᔥᒑᐦᐱᔨᐦᐆᑐᐙᒡ ᐊᓂᔮᔨᐤ ᐅᐦᑖᐐᐙᐤ ᐋ ᑯᒀᒋᒫᒡ ᑖᓐ ᒑ ᐃᔑᓂᐦᑳᓱᔨᑯᐱᓈᓂᐦᐄ ᐅᔮᔨᐤ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ᓵᑳᕌᔮ ᒌ ᐄᔑᓂᔥᒑᐦᐱᔨᐦᐆ ᐋ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑᒀᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᒥᓯᓂᐦᐄᒑᑦ᙮ “ᒞᓐ ᑭᑎ ᐃᔑᓂᐦᑳᓲ,” ᒌ ᐄᑎᓯᓂᐦᐄᒑᐤ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔥᑖᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ᐅᔮᔨᐤ ᒫᒃ ᒫᒀᒡ ᑏᐙᐦᒡ ᒌ ᐅᐦᒋ ᒥᔪᐱᔨᐤ ᒦᓐ ᒑ ᒌ ᐊᔨᒥᑦ ᓵᑳᕌᔮ ᐋᒄ ᑳ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ᐋᒄ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᓈᔥᑖᑆᐦ ᒌ ᓵᒋᓯᐎᒡ ᑭᔮᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐙᔅᑳ ᐊᓂᑎᐦ ᒎᑏᔮ ᑳᐦ ᑖᒡ ᑳ ᐹᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ᒥᓯᐙ ᒫᒃ ᑎᐦᑐ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐦᒡ ᓈᔥᒡ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒧᒡ ᐋ ᐄᑖᔨᐦᑎᐦᒡ, ᐋ ᐄᔑ ᒫᐦ ᑭᑎ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐆ ᐊᐙᔑᔥ᙮ ᐙᔥ ᒥᑐᓐ ᒌ ᒋᔅᒑᔨᐦᑖᑯᓐ ᔖᔥ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᐎᔨᔓᐙᑎᑯᑦ ᐆ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ᓵᑳᕌᔮ ᒫᒃ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑰ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᒥᔨᑯᑦ ᒑ ᒌ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ᑭᑎ ᒥᔻᒋᒫᑭᓂᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐃᔅᕋᐄᓪ ᐅᒋᔖᒥᓂᑑᒻ, ᐙᔥ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐤ ᑭᔮᐦ ᒌᐦ ᑐᑎᒻ ᒑ ᒌ ᐱᐦᑯᐦᐅᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ᑭᔮᐦ ᒋᒋ ᐅᐦᑎᓂᒫᑯᓂᐤ ᐋ ᓲᐦᒑᔨᑖᑯᓰᔨᒡ ᐱᒫᒋᐦᐄᐙᓯᐤ ᐊᓂᑖᐦ ᐅᑖᐱᒋᐦᐋᑭᓐ ᑌᕕᑦ ᐅᑏᔨᔨᒥᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ᒧᔮᒻ ᑳᐦ ᐃᔨᑯᐱᓈ ᐋᐦ ᐋᔨᒥᐙᒑᐙᑦ ᐅᑐᓂᔨᐤ ᐆ ᐱᔮᐦᒋ ᒋᔅᒋᐙᐦᐄᒑᓰᒻ ᐋᓐᑖᐦ ᐹᒋ ᐙᔅᑭᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ᒑ ᒌ ᐱᑯᐦᐅᐙᒄ ᐊᓂᔮᔨᐤ ᓂᔥᑯᔥᑖᑎᔨᑎᐦᒄ ᐅᐦᒋ, ᑭᔮᐦ ᒫᒃ ᐆ ᓲᐦᒌᓯᐅᓂᐙᐦᒡ ᐅᐦᒋ ᒥᓯᐙ ᐙᐦᑳᑎᑏᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ᐋ ᒋᔖᐙᑐᑎᐙᑦ ᐋᓂᔅᒑ ᒋᑖᓂᔅᑰᓯᒥᓂᐤ, ᑭᔮᐦ ᐋ ᒋᔥᒋᓯᑦ ᐆ ᐱᔮᐦᒋ ᓂᔅᑯᒧᐎᓐ, ");
INSERT INTO crl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᐦᒋ ᓂᔅᑯᒫᑦ ᑯᐦᑖᐐᓄᐤ ᐋᑉᕋᐦᐋᒻ ");
INSERT INTO crl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ᒑ ᒥᔨᑎᐦᒃ ᐋ ᑎᐱᑑᑖᑭᓂᐎᔨᒡ, ᐋ ᐱᐦᑯᐦᐅᐦᒄ ᐊᓂᔮᔨᐤ ᑳ ᓂᔥᑯᔥᑖᑎᔨᑎᐦᒄ ᐆ ᓲᐦᒋᓯᐎᓃᔨᒡ ᐅᐦᒋ, ᒑ ᒌ ᐋᐱᑎᔒᔥᑑᐦᒄ ᔖᔥ ᐋᐦᐋᑳ ᑯᔅᑖᒋᔨᐦᒄ, ");
INSERT INTO crl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ᐱᔮᒋᐃᓯᐎᓂᒡ ᑭᔮᐦ ᑯᐃᔅᑯᑖᑎᓯᐎᓂᒡ ᒥᓯᐙ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒑ ᐃᔥᐱᔥ ᐱᒫᑎᓰᔨᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ᐋᒄ ᓵᑳᕌᔮ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ, “ᐋᐦᐋ ᒌᔨ ᒫᒃ ᐊᐙᔑᔥ, ᒫᐅᒡ ᑳ ᐄᔥᐹᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐆ ᒋᔅᒋᐙᐦᐄᒑᓰᒻ ᒋᑭ ᐄᑎᑯᐎᓐ, ᐙᔥ ᒋᑭ ᓃᑳᓂᑎᐙᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᐙᐎᔑᑎᐙᑦ ᐋᑎ ᒑ ᐄᑐᐦᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ᒑ ᒋᔅᒋᔨᑎᒥᐦᐄᒥᑦ ᐅᑎᔨᔨᒻᐦ ᐊᓂᔮᔨᐤ ᐋ ᐙᐹᔨᑎᒥᐙᑭᓂᐎᔨᒡ ᐆ ᒥᒋᑣᐎᓂᔨᐤ ᐋᐦ ᐋᐅᓃᔨᒡ ᐱᒫᒋᐦᐄᐙᐎᓂᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ᒌ ᒋᔖᒥᓂᑑᒥᓂᐤ ᐆ ᒋᔅᑎᒫᒑᔨᐦᒋᒑᐅᓵᒌᐦᐄᐙᐎᓐ ᐅᐦᒋᐱᔨᒡ, ᒧᔮᒻ ᐊᓐ ᐋᐹᑖᐱᒡ ᐃᔥᐱᒥᐦᒡ ᐋ ᐅᐦᒋᐱᔨᒡ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐋᐦᐹᒡ ᐙᔥᑖᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ᒑ ᒌ ᐙᔅᑖᔨᒡ ᐋᐦ ᑖᒡ ᐊᓂᒌ ᐊᐅᑳᔅᑖᐱᒡ ᑭᔮᐦ ᑖᑳᔅᑖᔅᑳᑯᒡ ᓂᐱᐎᓂᔨᐤ, ᑭᔮᐦ ᒑ ᒌ ᒋᔅᒋᓄᐦᑎᐦᐄᑯᔨᐦᒄ ᒋᔮᒫᔨᑎᒧᐎᓂᒡ ᐄᔑ᙮” ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒥᓯᐙ ᓵᑳᕌᔮ ᑳᐦ ᐃᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ᐆ ᒫᒃ ᐊᐙᔑᔥ ᒞᓐ ᒌ ᐋᑎ ᓲᐦᒋᓂᐦᑖᐅᒋᐤ ᐐᔮᐦᒡ ᑭᔮᐦ ᐅᑎᐦᒑᐦᑯᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᒌᔥ ᓂᐦᑖᐅᒋᑦ, ᐊᓂᑖᐦ ᒌ ᒌᐱᐹ ᐊᔨᑖᐤ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐊᓂᑖᐦ ᐋᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᒑᒀᔨᐤ, ᐹᑎᔥ ᐙᑎᐦᒋᐱᔨᒡ ᒑ ᑭᒑᔅᒋᒫᑦ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ᒫᒀᒡ ᒫᒃ ᓰᓯᕐ ᐊᑭᔅᑎᔅ ᑳ ᒋᐦᒋᐅᒋᒫᐅᑦ, ᒌ ᐄᑎᔑᐦᐙᐤ ᒥᓯᐙ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᕎᒻ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐱᒋᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒥᓯᓂᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒫᐅᒡ ᓃᔥᑎᒻ ᑳ ᑎᐱᒋᒫᑭᓂᐎᒡ ᐅᒌ ᐄᔨᔨᐅᒡ᙮ ᒫᒀᒡ ᒫᒃ ᑯᕆᓃᔨᔅ ᒌ ᐅᒋᒫᐤ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᓯᕆᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ᒥᓯᐙ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐅᑎ ᐃᐦᑖᐎᓂᐙᐦᒡ ᑖᓂᑖᐦ ᒥᒄ ᑳ ᐱᒫᑎᓰᔨᒀᓂᐦᐄ ᐅᓃᒋᐦᐄᑯᐙᐤ ᑭᔮᐦ ᒫᒃ ᐅᐙᐦᑯᒫᑭᓂᐙᐤ ᒑ ᒌ ᒥᓯᓂᐦᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ᒍᓯᕝ ᒫᒃ ᐊᓂᑖᐦ ᒌ ᐅᐦᒋ ᒋᔅᑐᐦᑖᐤ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ, ᐹᕪᓕᐦᐋᒥᐦᒡ ᑳ ᐄᑐᐦᑖᑦ, ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ᙮ ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑎᐦ ᑳ ᐱᒫᑎᓰᑯᐱᓈᓂᐦᐄ ᐊᓂᔮ ᐅᑖᓂᔥᑰᔒᒻ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ᒍᓯᕝ ᒫᒃ ᒌ ᐐᒑᐅᑰ ᒣᕇ ᐊᓂᔮᔨᐤ ᒑ ᐐᐅᑦ, ᒑ ᒌ ᒥᓯᓂᐦᐙᑭᓂᐎᒡ᙮ ᒫᒀᒡ ᒫᒃ ᒌ ᒋᒋᔥᑭᐙᐤ ᐊᐙᔑᔥ ᒣᕇ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐹᕪᓕᐦᐋᒥᐦᒡ ᐋᐦ ᑖᒡ ᒌ ᐅᑖᐦᒋᐱᔨᐤ ᒑ ᐙᐱᒫᐅᓱᑦ ᒣᕇ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ᓂᐹᐅᑭᒥᒄ ᒫᒃ ᒥᑐᓐ ᒌ ᓵᑭᔅᒋᓈᔨᐤ ᐋᒄ ᐊᓂᑖᐦ ᐊᐅᐦᑳᓂᑭᒥᑯᐦᒡ ᑳᐦ ᑖᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓃᔥᑎᒨᔖᓐ ᒣᕇ, ᐋ ᒌ ᓈᐹᔒᐎᔨᒡ᙮ ᑳ ᐐᔅᒀᔮᒋᓈᑦ ᐱᒋᐎᔮᓈᒋᓂᒡ, ᐋᒄ ᑳ ᐱᒥᔑᒫᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐊᐅᐦᑳᓂᒡ ᑳ ᒌ ᐅᐦᒋ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ᐊᓐ ᒫᒃ ᑳ ᑎᐱᔅᑳᒡ, ᐹᔓᒡ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ, ᒌᐦ ᑖᐅᒡ ᑭᓄᒫᓂᔥᒑᓂᔓᐙᔑᐎᒡ ᐋ ᓈᓈᑭᒋᐦᐋᒡ ᒫᓂᔥᒑᓂᔥ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᒫᒃ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᒌ ᓅᑯᓰᔥᑖᑯᒡ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒋᐦᑳᔮᔥᑖᔨᐤ ᐊᓂᑎᐦ ᐙᔅᑳ ᐋᐦ ᑖᒡ, ᐆ ᒋᔅᑖᔨᐦᑖᑯᓰᐎᓃᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᒋ ᐙᔥᑖᔨᒡ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᓵᒋᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᐊᑳᐐ ᓵᒋᓯᒄ᙮ ᐙᔥ ᒋᐐᐦ ᐐᐦᑎᒫᑎᓈᐙᐤ ᒥᔻᒋᒧᐎᓐ, ᒥᓯᐙ ᐊᐙᓐ ᐹᐦᑎᐦᑳ ᒑ ᒥᔻᔨᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐅᐦᒌᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ, ᒌᔨᐙᐤ ᐅᐦᒋ ᒌ ᐱᒫᑎᓰᐤ ᐊᐙᔑᔥ, ᐋᐅᒄ ᐊᓐ ᒋᐱᒫᒋᐦᐄᐙᓯᒥᓅᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ᒋᑭ ᐙᐱᐦᑖᓈᐙᐤ ᒥᑐᓐ ᐋ ᑖᑆᔮᓐ, ᒋᑭ ᒥᔅᑭᐙᐙᐤ ᐊᐱᔥᑎᐙᔥ ᐋ ᐐᔅᒀᔮᒋᓈᑭᓅᑦ ᐱᒋᐎᔮᓈᒋᓂᒡ ᐋ ᐱᒥᔑᐦᒃ ᐊᐅᐦᑳᓐ ᐋᐆᐦᒋᒥᒋᓲᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ᔑᔥᒋᑯᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᒥᐦᒑᑑᒡ ᑯᑎᑭᒡ ᐋᓐᒋᓂᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒋ ᓅᑯᓯᒡ ᐋ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑ ᐋᐦ ᐃᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“ᒋᔅᑖᔨᒫᐦᒄ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᐃᔥᐱᒥᐦᒡ ᑳᐦ ᑖᑦ᙮ ᒋᑭ ᒥᔮᑭᓂᐎᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᐊᓂᒌ ᑳ ᓂᐦᐋᔨᐦᑎᒥᐦᐋᒡ ᒋᔖᒥᓂᑑ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐋᓐᒋᓂᒡ ᑳ ᐅᐦᐱᔅᑳᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ, ᐊᓂᒌ ᑭᓄᒫᓂᔥᒑᓂᔓᐙᔑᐎᒡ ᒌ ᐄᑎᑐᒡ, “ᐄᑐᐦᑖᑖᐤ ᐹᕪᓕᐦᐋᒥᐦᒡ, ᒑ ᐙᐱᐦᑎᒥᐦᒄ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᑳ ᐄᔑ ᐹᒋ ᐐᐦᑎᒫᑎᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ᒋᐐᐦ ᒋᐱᔨᐆᒡ ᐹᕪᓕᐦᐋᒥᐦᒡ ᐋᐦ ᐄᑐᐦᑖᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᒥᔅᑭᐙᒡ ᒣᕇ ᑭᔮᐦ ᒍᓯᕝ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᐱᔥᑎᐙᔥ᙮ ᐊᓐ ᒫᒃ ᐊᐱᔥᑎᐙᔥ ᒌ ᐱᒥᔑᓐ ᐊᓂᑖᐦ ᐊᐅᐦᑳᓐ ᑳ ᒌ ᐅᐦᒋ ᒦᒋᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑭᓄᒫᓂᔥᒑᓂᔓᐙᔑᐎᒡ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ ᒌ ᓂᑑᐱᐹᒫᒋᒨᒡ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᐙᒡ ᐋᓐᒋᓐ ᐋ ᐄᔑ ᐋᔨᒨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ᒥᓯᐙ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᐊᓂᔮᔨᐤ ᑭᓄᒫᓂᔥᒑᓂᓯᐙᓯᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᒋᒧᔨᒡ ᓈᔥᑖᑆᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ᒣᕇ ᒫᒃ ᒌ ᑭᓂᐙᔨᐦᑎᒻ ᐅᑖᐦᐄᐦᒡ ᒥᓯᐙ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ, ᑖᓐ ᑳ ᐄᑖᒋᒫᑭᓂᐎᔨᒡ, ᐋᔨᐤᐦ ᓈᔥᒡ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑭᓄᒫᓂᔥᒑᓂᔓᐙᔑᐎᒡ ᒌ ᒌᐙᐅᒡ ᐋ ᒋᔅᑖᒋᒫᒡ ᑭᔮᐦ ᐋ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑ᙮ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐹᐦᑎᐦᒡ ᑭᔮᐦ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒡ ᐅᐦᒋ, ᐙᔥ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒫᑯᒡ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᐋᔪᐎᒄ ᓂᐦᐋᐤ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ᐄᔥᐱᐦ ᐊᓐ ᐊᐙᔑᔥ ᓂᔮᓈᓈᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐱᒫᑎᓰᑦ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᒌ ᐄᔑ ᒋᔅᒋᓄᐙᒋᔣᑭᓂᐤ ᑭᔮᐦ ᒌᓴᔅ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ᙮ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᑳ ᐃᔑᓂᐦᑳᑎᑯᑦ ᐋᓐᒋᓐ ᐋᒸᔮ ᐅᐦᒋ ᒋᒋᔅᑳᑯᑦ ᐅᑳᐐᐦ ᐊᓂᑖᐦ ᐅᔅᐱᔮᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐱᔨᒡ ᒑ ᒌ ᐱᔮᐦᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᒌᓴᔅ ᐅᓃᒋᐦᐄᒄᐦ, ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᔥᑖᔨᒡ ᒧᓱᔅ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ ᒑ ᑎᓈᓂᐎᔨᑯᐱᓈ᙮ ᑭᔮᐦ ᒌ ᐹᔓᐙᐅᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐄᔑ ᐱᒋᔅᑏᓲᐙᑖᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ᐙᔥ ᐊᒀᑎᔥᑖᔨᒡ ᐊᓂᑖᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᐐᔓᐙᐎᓂᐦᒡ, ᐃᔅᒀᐤ ᐅᓃᔥᑎᒨᔖᓐ ᓈᐹᐎᔒᔨᒑ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᒋᑭ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓂᐤ ᒑ ᒌ ᐋᐱᒋᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ᑭᔮᐦ ᓃᔓ ᐱᔮᓯᔅ ᐅᒦᒦᔨᐦ ᒑ ᒌ ᒥᔮᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒑ ᒌ ᒥᒋᔥᑎᐦᐋᒫᑯᒡ, ᐙᔥ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᐐᐦᑖᑯᓃᔨᒡ ᐊᓂᑖᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᐐᔓᐙᐎᓃᐦᒡ ᒑ ᑎᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌᐦ ᑖᐤ ᓈᐹᐤ, ᓯᒥᔨᓐ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᒌ ᑯᐃᔅᑯᐱᒫᑎᓰᐤ ᑭᔮᐦ ᒌ ᐊᔨᒥᐦᐋᐙᑎᓯᐤ᙮ ᑭᔮᐦ ᒌ ᐹᔣᔨᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐹᑖᒋᒫᑭᓂᐎᔨᒡ ᐅᐱᒫᒋᐦᐄᐙᐤ ᒑ ᒌ ᐱᒫᒋᐦᐋᔨᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᐲᒋᔥᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ᒌ ᐄᑎᑯᐦᑖᑯᐱᓐ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐋᔥᒄ ᒑ ᐱᒫᑎᓰᑦ ᒑ ᐙᐱᒫᐦᑦ ᑭᔮᐦ ᐐᐦ ᑎᑯᓯᓃᔨᒑ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᔨᒡ, ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒑ ᙭ᑎᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒫᒃ ᒌ ᐋᑎ ᒋᔅᒋᓄᐦᑎᐦᐄᑰ ᓯᒥᔨᓐ ᒑ ᒌ ᐲᐦᒑᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᒌᓴᔅ ᒫᒃ ᐅᓃᒋᐦᐄᒄᐦ ᒌ ᐹᔒᑰ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ᙮ ᐙᔥ ᒋᐐᐦ ᑐᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐐᔥᑖᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᔮᔨᐤ ᒑ ᑐᑖᑭᓂᐎᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ᓯᒥᔨᓐ ᒫᒃ ᒌ ᐅᑎᓈᐤ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ ᑳ ᑎᐦᑯᓈᑦ ᐋᒄ ᑳ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ, ᐋᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ᐆ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐋᒄ ᒑ ᓂᐦᐋᔨᒥᔨᓐ ᓃᔨ ᒋᑎᐋᐱᒋᐦᐋᑭᓐ ᒋᔮᒫᔨᑎᒧᐎᓂᒡ ᒑ ᐄᒑᐎᔮᓐ, ᒧᔮᒻ ᑳᐦ ᐃᔨᐎᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ᐙᔥ ᓂᔅᒋᔑᑯᒡ ᓈᐦᐄᔪ ᔖᔥ ᓂᒋ ᐙᐱᑖᓐ ᐊᓐ ᒑ ᐅᐦᒋ ᐱᒫᒋᐦᐄᐙᔨᓐ, ");
INSERT INTO crl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ᑳᐦ ᐋᔮᔅᑯᐎᔅᑖᔨᓐ ᒑ ᐙᐱᑎᒡ ᒥᓯᐙ ᐄᔥ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ᐙᔥᑖᐎᓐ ᒑ ᐙᔅᑖᓂᒫᑯᒡ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌ ᒋᔅᒑᔨᒥᒡ ᒋᔖᒥᓂᑑᐦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒑ ᐅᐦᒋ ᒋᔅᑖᔨᑖᑯᓯᒡ ᒋᑎᐄᔨᔨᒥᒡ ᐃᔅᕋᐄᓪ᙮” ᑳᐦ ᐃᔨᑦ ᓯᒥᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ᒌ ᒥᔅᑳᔥᑎᒥᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᓃᒋᐦᐄᒄᐦ ᒌᓴᔅᐦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒥᔨᒡ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ᐋᒄ ᐊᓐ ᒋᔖᐄᔨᔨᐤ ᓯᒥᔨᓐ ᒥᓯᐙ ᑳ ᔑᐙᔨᒫᑦ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒣᕇᐦ, ᒌᓴᔅᐦ ᐅᑳᐐᔫᐦ, “ᐆ ᐊᐙᔑᔥ ᒌ ᐅᐙᔮᐱᒥᑰ ᒋᔖᒥᓂᑑ, ᒋᑭᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᒥᐦᒑᑐ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒑ ᒌ ᐱᐦᒋᔑᓃᔨᒡ ᐋᒄ ᐊᓂᔮᔨᐤ ᒥᐦᒑᑐ ᑳ ᑖᑆᔮᔨᒥᑯᑦ ᑭᑎ ᐅᐦᐱᑳᐳᐦᐋᐤ᙮ ᐆ ᐊᐙᔑᔥ ᒋᑭ ᐙᐱᐦᑏᔨᐙᐤ ᒋᔖᒥᓂᑑ ᐅᐱᒫᒋᐦᐄᑯᓰᐎᓂᔨᐤ ᒥᒄ ᒫᒃ ᒥᐦᒑᑐ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒋᑭ ᓂᔥᑰᔑᐦᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ᐋᑯᑖᐦ ᒫᒃ ᒑ ᓅᑯᓃᔨᒡ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐃᓯᓈᑯᓃᔨᔨᒡ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᐙᐤ ᐅᑖᐦᐄᐙᐦᒡ ᐄᔨᔨᐅᒡ᙮ ᐋᒄ ᒫᒃ ᒌᔨ ᒣᕇ, ᒥᔥᑏᐦ ᒋᑭ ᒥᓯᒫᔨᐦᑎᒥᐦᐄᑭᐎᓐ ᒑ ᑐᑎᐙᑭᓅᑦ, ᒧᔮᒻ ᒨᐦᑯᒫᓐ ᐋ ᑎᐦᑭᒥᑭᐎᔨᓐ ᒋᑎᐦᒑᐦᑯᐦᒡ ᒋᑭ ᐄᑎᒥᐦᒋᐦᐅᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒋᔖᐃᔥᒀᔥ ᐋᓈ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐋ ᒌ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ᙮ ᕙᓄᐁᓪ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᐦᑖᐐᐦ, ᐊᔑᕐ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ ᐋᑯᑖᐦ ᑳ ᐅᐦᒌᔨᒡ᙮ ᔖᔥ ᒫᒃ ᓈᔥᒡ ᒌ ᒋᔖᐃᔥᒀᔔ ᐋᓈ᙮ ᓃᔮᓈᓈᒥᑎᓂᐤ ᓈᐅᔖᑉ ᒌ ᑎᐦᑐᐳᓍᔔ᙮ ᒥᒄ ᓃᔣᔥᒡ ᑎᐦᑐ ᐱᐳᓐ ᒌ ᐐᒋᒥᑐᒑᓂᒋ ᐅᐐᒋᒫᑭᓐ ᐋᒄ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒦᓐ ᐅᐦᒋ ᐅᓈᐹᒨ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ᒨᔥ ᒫᒃ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᒌᔑᑳᔨᒡ ᑭᔮᐦ ᐋ ᑎᐱᔅᑳᔨᒡ, ᐋ ᐊᔨᒥᐦᐋᑦ, ᐋᐦᐋᑳ ᐋᔑᑯᒻ ᒦᒋᓱᑦ ᐐᐦ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐄᔥ ᐎᔮᔨᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ ᐅᓃᒋᐦᐄᑯᔨᐤ ᒌ ᐅᐦᒋ ᐲᐦᒑᐤ ᐆ ᒋᔖᐃᔥᒀᔥ᙮ ᒌ ᓂᓈᔅᑯᒫᐤ ᒋᔖᒥᓂᑑ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ᙮ ᐋᒄ ᑳᐦ ᐋᔨᒨᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᐊᐙᔑᔥ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐊᔑᓂᐙᐦᐋᔨᒡ ᐅᐱᒫᒋᐦᐄᐙᐤ ᒑ ᒌ ᐱᒫᒋᐦᐋᔨᒡ ᒉᕉᓯᓕᒻ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐅᓃᒋᐦᐄᒄᐦ ᒥᓯᐙ ᑳ ᐄᔑ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐎᔨᔥᑖᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᔨᐤ, ᑳᐤ ᒌ ᒌᐙᐅᒡ ᐊᓂᑖᐦ ᑳ ᐅᐦᒌᒡ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ᒌᓴᔅ ᒫᒃ ᒌ ᐋᑎ ᒥᔪᓲᐦᒋᓃᐦᑖᐅᒋᐤ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᑭᒑᐦᑖᐙᔨᐦᑎᒻ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒋᔖᐙᑐᑖᑰ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ᐋᔑᑯᒻ ᐱᐳᓐ ᒌᓴᔅ ᐅᓃᒋᐦᐄᒄᐦ ᒌ ᐄᑐᐦᑖᔨᐤ ᒋᕉᓯᓕᒥᐦᒡ ᐄᔥᐱᐦ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ᒌᓴᔅ ᒫᒃ ᑳ ᓃᔓᔖᐳᓍᔑᑦ ᒌ ᐐᒋᐦᐄᐙᐤ ᐊᓂᑖᐦ ᐋᐦ ᐄᑐᐦᑖᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒥᑯᔖᓂᐎᔨᒡ ᑳᐤ ᑳᐦ ᐋᑎ ᒋᐦᒋ ᒌᐙᐅᒡ, ᒥᒄ ᒫᒃ ᒌᓴᔅ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᑯᑦ ᐅᓃᒋᐦᐄᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ᒌ ᐄᑖᔨᒥᑰ ᒫᒃ ᐋ ᐹᒋ ᐐᒋᐦᐄᐙᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᒫᐅᓯᑯᐦᑖᓂᐎᔨᒡ᙮ ᐹᔨᒄ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᐃᔥᐱᔥ ᐱᒧᐦᑖᐅᒡ ᐋᒄ ᑳ ᒋᐦᒋ ᓈᓂᑐᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᑖᐙᔨᔥ ᐅᐙᐦᑯᒫᑭᓂᐙᐤᐦ ᑭᔮᐦ ᐅᐐᒑᐙᑭᓂᐙᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔅᑭᐙᐅᒡ, ᐋᒄ ᒫᒃ ᑳᐤ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᓂᑑᓈᓂᑎᐙᔨᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᓈᓂᑎᐙᔨᒫᒡ ᐋᒄ ᑳ ᒥᔅᑭᐙᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᒌ ᐐᑎᐱᒫᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐋ ᓂᑐᐦᑎᐙᔨᒡ ᐋᔨᐤᐦ ᒫᒃ ᐋ ᑯᒀᒋᒫᔨᒡ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᑳ ᐹᐦᑖᑯᑦ ᓈᔥᒡ ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᔨᐤ ᐅᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓐ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᐋ ᑭᔅᒋᐦᐅᑦ ᐋ ᐄᔑ ᓂᔥᒀᐅᔑᑖᑦ ᒑᒀᔨᐤ ᐋ ᑯᒀᒋᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᓃᒋᐦᐄᒄᐦ ᑳ ᐙᐱᒥᑯᑦ ᒌ ᑯᔥᒀᔨᐦᑎᒥᔨᐤ ᐊᓂᑖᐦ ᑳ ᒥᔅᑳᑯᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᑳᐐ ᒌ ᐄᑎᑰ, “ᓂᑯᔅ, ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᔮᐦᒡ, ᒌᔨ ᒋᒌ ᓈᓂᑎᐙᔨᒥᑎᓈᓐ ᑰᐦᑖᐐ ᐋ ᓃᔑᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᐙᐦᒋ ᓈᓂᑎᐙᔨᒥᔮᒄ? ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐙᔥ ᐋᑯᑖᐦ ᓂᐱᐦ ᑖᓐ ᐅᑎᐦ ᓅᐦᑖᐐ ᐐᒋᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒥᔨᐤ ᐊᓂᔮᔨᐤ ᐅᓃᒋᐦᐄᒄᐦ ᒑᒀᔨᐤ ᐙᐦᒋ ᐃᔨᑦ ᐊᓂᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ᐋᒄ ᑳ ᐐᒑᐙᑦ ᐋ ᒌᐙᔨᒡ ᐊᓂᑖᐦ ᓈᓵᕆᑎᒡ, ᒌ ᐱᔑᒋᐦᐋᐤ ᒫᒃ ᒑᒀᔨᐤ ᐋᐦ ᐄᑎᔓᒥᑯᑦ᙮ ᐅᑳᐐᐦ ᒫᒃ ᒌ ᑭᓄᐙᔨᐦᑎᒥᔨᐤ ᐅᑖᐦᐄᔨᐦᒡ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ᒌᓴᔅ ᒫᒃ ᒌ ᐋᑎ ᓂᐦᑖᐅᒋᐤ ᐋᔨᐤᐦ ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᑭᒑᐦᑖᐙᔨᐦᑎᒻ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᓂᐦᐋᔨᐦᑎᒥᔨᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᐄᔨᔨᐤ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ᐊᓂᔮᔨᐤ ᑆᐳᓃᔨᒡ ᓂᔮᔫᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᑳ ᐃᔥᐱᔥ ᒋᐦᒋᐅᒋᒫᐅᑦ ᑖᐃᐲᕆᔨᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᑆᓐᑎᔨᔅ ᐹᔨᓕᑦ ᒫᒀᒡ ᒌ ᓃᑳᓂᔥᑳᒑᐤ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᐋᒄ ᐦᐁᕆᑦ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᓃᑳᓂᔥᑳᒑᑦ, ᐋᒄ ᐐᒋᔖᓐ ᐦᐁᕆᑦ, ᕕᓕᑉ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐊᓂᑖᐦ ᒌ ᓃᑳᓂᔥᑳᒑᔨᐤ ᐄᑐᕆᔮ ᑭᔮᐦ ᑦᕌᑯᓈᐃᑎᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ᙮ ᐋᒄ ᓚᐃᓯᓃᔨᔅ ᑳ ᓃᑳᓂᔥᑳᒑᑦ ᐊᓂᑖᐦ ᐊᐱᓖᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ᒫᒀᒡ ᒫᒃ ᑭᔮᐦ ᐋᓈᔅ ᑭᔮᐦ ᑳᔮᕙᔅ ᒌ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒫᒀᒡ ᒞᓐ, ᓵᑳᕌᔮ ᐅᑯᓯᔅᐦ, ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒌᐦ ᑖᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐐᐦᑎᒫᑯᑦ ᒋᔖᒥᓂᑑ ᒑ ᐄᔑ ᑭᒑᔅᒀᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ᒞᓐ ᒫᒃ ᒥᓯᐙ ᒌ ᐊᐄᑐᐦᑖᐤ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐹᔓᒡ ᒞᕐᑎᓐ ᓰᐲᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋ ᑭᒑᔅᒋᒫᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᒫᑭᓂᐎᔨᒡ, ᒋᔖᒥᓂᑑ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒫᑯᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ᐙᔥ ᐋᐃᓵᔮ, ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒌ ᐄᑎᓯᓂᐦᐊᒧᑖᑯᐱᓈ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᑖᐤ ᐊᐙᓐ ᐋ ᑖᑆᑦ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐋᐦ ᐃᔨᑦ, ᐃᔮᔅᑭᐐᐦᑭᒸᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒫᔅᑭᓈᔨᐤ ᐋᑎ ᒑ ᐱᒧᐦᑖᑦ ᑭᔮᐦ ᑯᐃᔅᑯᒧᐦᑖᐙᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ᐊᓐ ᒫᒃ ᒫᔅᑭᓂᐤ ᐊᓂᑖᐦ ᒑ ᐋᑎ ᐅᐙᔮᒡ ᒋᐱᐦ ᑖᐱᔥᑯᑎᐦᐄᑭᓂᐤ, ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐋ ᐊᐱᔅᒀᐱᔅᑳᐦᒡ ᐋᐦ ᐄᑎᒨᐦᒡ ᐊᓐ ᒫᔅᑭᓂᐤ ᒋᐱᐦ ᑎᐦᑎᑯᐦᐄᑭᓂᐤ ᐊᓐ ᐋᐱᔅᑯᑎᓈᐦᒡ ᒑ ᒌ ᐅᐦᒋ ᒥᔪᒧᐦᒡ ᐊᓐ ᒫᔅᑭᓂᐤ᙮ ᐋᒄ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐅᐙᔨᒧᐦᒡ ᐊᓐ ᒫᔅᑭᓂᐤ, ᒋᐱᐦ ᑯᐃᔅᑯᒧᐦᑖᑭᓂᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᒥᒋᐦᒡ, ᒋᐱᐦ ᒥᔪᐦᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒑ ᐙᐱᒫᒡ ᐅᐱᒫᒋᐦᐄᐙᐤ, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᑎᓯᓂᐦᐊᒧᑯᐱᓈ ᐊᓂᔮ ᐋᐃᓵᔮ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᒞᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑯᒡ ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᒧᔮᒻ ᑖᑆᐦ ᐊᒋᓈᐳᑯᒡ ᐋᑖᔨᐦᑖᑯᓯᒡ ᒋᑎᐄᑖᔨᐦᑖᑯᓯᓈᐙᐤ᙮ ᒋᑎᐄᑖᔨᐦᑎᓈᐙᐤ ᐋ ᒑ ᒌ ᐅᔑᒧᑎᒸᒄ ᒋᔖᒥᓂᑑ ᓃᔥᑖᒥᐦᒡ ᐅᑖᐦᑭᐎᐙᓯᐎᓐ, ᐋ ᓰᑭᐦᐋᐦᑖᑯᐎᔮᒄ ᐋᐦᐋᑳ ᒫᒃ ᐐ ᒀᔅᑳᑎᓰᔮᒄ? ");
INSERT INTO crl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ᒋᐱᐦ ᒀᔅᑳᑎᓰᓈᐙᐤ ᐋᒄ ᒫᒃ ᒑ ᓅᑯᐦᒡ ᑖᑆᐦ ᒥᑐᓐ ᐋ ᓂᑭᑎᒫᒄ ᒌ ᒥᒑᑎᓰᐎᓂᐙᐤ᙮ ᑭᔮᐦ ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᒑ ᒌ ᐅᔑᒧᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᑖᐦᑭᐎᐙᓯᐎᓐ ᒥᒄ ᐊᓐ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᐋ ᐅᐦᒋᔮᒄ᙮ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᔖᒥᓂᑑ ᒋᑭ ᒌᐦ ᑐᑎᐙᐤ ᐅᔮᔨᐤ ᐊᓯᓃ ᑳ ᐄᑖᐱᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᐅᔑᐦᐋᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐅᑎᐙᔑᔒᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ᐙᔥ ᒧᔮᒻ ᔖᔥ ᐋ ᐃᔮᔅᑰᔥᑖᒡ ᒋᑭᐦᐄᑭᓐ ᐋᐅᒄ ᒑ ᐃᓯᓈᑯᐦᒡ ᒑ ᓈᑣᑭᐦᐙᑭᓅᑦ ᐊᓐ ᒥᔥᑎᒄ ᐊᓂᑖᐦ ᐋ ᐅᑎᐲᐎᑦ᙮ ᐙᔥ ᑎᐦᑐ ᒥᔥᑎᒄ ᐋᑳ ᑳ ᒥᔪ ᒦᓂᔓᐎᑦ ᒋᑭ ᓈᑣᑭᐦᐙᑭᓂᐤ ᑭᔮᐦ ᒋᑭ ᒥᒋᔥᑎᐙᐱᓈᑭᓂᐤ ᐃᔥᑯᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒞᓐ ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᒫᒃ ᒑ ᒌᐦ ᑎᔮᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ᑳᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᐋ ᓃᔑᓃᔨᔨᒡ ᐅᑎᑯᐦᑉᐦ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᒋᐱᐦ ᒥᔮᐤ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᐃᔮᔨᒡ, ᑭᔮᐦ ᒫᒃ ᒦᒋᒥᔨᐤ ᐋᔮᒀ ᒋᐱᐦ ᐊᔑᒫᐤ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᐅᒦᒋᒥᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᒫᒨᔑᒋᓈᐦᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡ, ᒌ ᐹᒋ ᐄᑐᐦᑖᐅᒡ ᒑ ᒌ ᓰᑭᐦᐋᑎᐙᑭᓂᐎᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒞᓐ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᑖᓐ ᓂᐱᐦ ᑎᓈᓐ ᓃᔮᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐊᑐᒡ ᐐᐦ ᐊᐅᔅᑖ ᒋᐱᐦ ᐅᐦᒋ ᐅᑎᓈᐙᐤ ᔓᐎᔮᓐ ᒥᒄ ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᓂᑎᐙᔨᐦᑖᑯᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ᐋᒄ ᒫᒃ ᓂᑐᐱᔫᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᑯᒀᒋᐦᒑᔨᒧᒡ, “ᓃᔮᓐ ᒫᒃ ᐐ ᑖᓐ ᓂᐱᐦ ᑎᓈᓐ?” ᒞᓐ ᒌᐦ ᐄᑖᐤ, “ᐊᑳᐐ ᐋᔨᐦᑭᒥᐦᐄ ᐊᐙᓐ ᒑ ᒌ ᒥᔨᔅᒃ ᔓᐎᔮᓐ ᑭᔮᐦ ᐊᑳᐐ ᓂᑎᐐ ᐄᔑ ᒫᒥᔑᒻ ᐊᐙᓐ᙮ ᒋᐱᐦ ᓂᐦᐋᔨᐦᑖᓈᐙᐤ ᐊᓐ ᐋ ᐃᔥᐱᔥ ᑎᐱᐦᐊᒫᑯᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ᐋ ᐹᐦᑎᐙᒡ ᒫᒃ ᒞᓐ ᐋ ᑭᒑᔅᒀᔨᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᔖᔥ ᓈᔥᒡ ᒌ ᐱᑯᓵᔨᒫᐅᒡ ᙭ ᒑ ᑎᑯᔑᓃᔨᒡ ᐋᒄ ᑳ ᒫᒥᑐᓈᔨᒫᒡ ᐅᑖᐦᐄᐙᐦᒡ ᒞᓐ ᐃᔮᐎᔨᒀᓂᐦᐄ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ᐋᒄ ᒞᓐ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᓂᐲᐦᒡ ᒋᓰᑭᐦᐋᐦᑖᑎᓈᐙᐤ ᓃᔨ, ᒥᒄ ᒫᒃ ᑯᑎᒃ ᐊᐙᓐ ᒋᑭ ᑎᑯᔑᓐ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᓃᔨ᙮ ᐐᔨ ᒫᒃ ᒋᑭ ᓰᑭᐦᐋᐦᑖᑯᐙᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᑭᔮᐦ ᐃᔥᑯᑖᔨᐤ᙮ ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᓂᑎᑖᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᐋᐱᐦᑯᓂᒧᒡ ᐅᒥᔅᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ᐆ ᒑ ᑎᑯᔑᐦᒃ ᒧᔮᒻ ᓈᐹᐤ ᑳ ᒥᔪᐦᑖᑦ ᐱᐦᒀᔑᑭᓂᒥᓈᐦᑎᒄ ᒋᑭ ᐄᑖᔨᐦᑖᑯᓯᐤ᙮ ᐊᓂᔮᔨᐤ ᐱᐦᒀᔑᑭᓂᒥᓈᐦᑎᒄ ᐊᓂᑖᐦ ᐊᔥᑖᓲᑭᒥᑯᐦᒡ ᑭᑎ ᐄᔑ ᒫᐅᒋᐦᐋᐤ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᑳ ᐱᐲᐅᔅᑖᔨᒡ ᐋᐦᐋᑳ ᐎᔮᔥ ᒑ ᒌ ᐄᑖᐱᑎᓃᔨᒡ ᒋᑭ ᐃᔥᒀᓯᒻ, ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᓂᐦᑖ ᒑ ᐋᔥᑐᐙᔨᒡ ᐃᔥᑯᑖᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ᒞᓐ ᒫᒃ ᓂᓈᐦᑭᐤ ᒦᓐ ᒌ ᐄᔑ ᐃᔮᒀᒥᒫᐤ ᐄᔨᔨᐤ ᐋᔨᐤᐦ ᐋ ᑭᒑᔅᒋᒫᑦ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ᒥᒄ ᒫᒃ ᒞᓐ ᐄᔥᐱᐦ ᑳᐦ ᐋᓍᔨᒫᑦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐊᓂᔮᔨᐤ ᐋ ᐐᒋᒫᔨᒡ ᐐᒋᐄᔨᔨᐤ ᐎᔨᐐᔨᐤ, ᐦᐁᕎᑎᔭᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐋᔨᐤᐦ ᒫᒃ ᑳᐦ ᐋᔨᒨᑎᒧᐙᑦ ᑯᑎᒃ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒥᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ᐦᐁᕆᑦ ᒌ ᐄᑎᔑᐦᐙᐤ ᒑ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ ᒞᓐ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᑐᑎᐦᒃ ᐊᑎᑎᐤ ᒌ ᓄᔅᒋᑣᓲ ᐊᓂᔮᔨᐤ ᑖᓐ ᔖᔥ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒧᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ, ᐋᒄ ᑭᔮᐦ ᐐᔨ ᒌᓴᔅ ᑳ ᓰᑭᐦᐋᑎᐙᑭᓅᑦ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᑦ ᒌ ᐅᐦᒋ ᐋᐱᐦᐄᐱᔨᐤ ᒋᐦᒋᒌᔑᒄ, ");
INSERT INTO crl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᑳ ᐅᐦᒋ ᔮᔒᔥᑖᑯᑦ ᒌᓴᔅ ᒧᔮᒻ ᐱᔮᓯᓴᒡ, ᐅᒦᒦᒡ ᐋ ᐃᓯᓈᑯᓰᔨᒡ᙮ ᐋᒄ ᑳ ᐅᐦᒋ ᐹᐦᑖᑯᓯᑦ ᐊᐙᓐ ᐊᓂᑖᐦ ᐅᐦᒋ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᐃᔨᑦ, “ᐋᐅᒄ ᒌ ᓂᑯᔅ ᑳ ᓵᒋᐦᐄᑖᓐ ᑭᔮᐦ ᓈᔥᒡ ᑳ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ᒌᓴᔅ ᒫᒃ ᐎᔮᔥ ᒌ ᓂᔥᑐᒥᑎᓂᐅᐙᐳᓍᓲ ᐄᔥᐱᐦ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᑖᓐ ᑳ ᐐᐦ ᐄᑖᐱᒋᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ᙮ ᒌ ᐄᑖᔨᒥᑰ ᒫᒃ ᐊᐙᔨᐤᐦ ᑎᐱᔨᐙ ᐋ ᐅᐦᑖᐐᑦ ᒍᓯᕝᐦ᙮ ᐆ ᒫᒃ ᒍᓯᕝ, ᐦᐄᓖᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ᐦᐄᓖ ᒫᒃ ᒫᑖᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᑖᑦ, ᓖᕚᐃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᓖᕚᐃ ᒫᒃ ᒣᓪᑮᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒣᓪᑮ, ᒑᓈᐃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᒑᓈᐃ ᒫᒃ ᒍᓯᕝᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ᒍᓯᕝ ᒫᒃ ᒫᑖᕦᔮᔅᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᑖᕦᔮᔅ, ᐁᒸᔅᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐁᒸᔅ ᒫᒃ ᓀᐦᐅᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᓀᐦᐅᒻ ᐁᔅᓖᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐁᔅᓖ ᒫᒃ ᓂᑳᐄᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ᓂᑳᐃ ᒫᒃ ᒫᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒫᑦ, ᒫᑖᕦᔮᔅᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒫᑖᕦᔮᔅ ᒫᒃ ᓭᒦᔨᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᓭᒦᔨᓐ ᒫᒃ ᒞᓯᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒞᓯᒃ, ᒞᑖᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ᒞᑖ ᒫᒃ ᒞᐋᓈᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒞᐋᓈᓐ, ᕃᓵᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᕃᓵ ᒫᒃ ᓭᕈᐹᐱᓪᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᓭᕈᐹᐱᓪ, ᔒᐋᓪᑎᔦᓪᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᔒᐋᓪᑎᔦᓪ ᒫᒃ ᓀᕇᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ᓀᕇ ᒫᒃ ᒣᓪᑮᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒣᓪᑮ, ᐋᑎᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᑎ ᒫᒃ, ᒀᔑᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒀᔑᒻ ᐁᓪᒫᑖᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐁᓪᒫᑖᒻ ᒫᒃ, ᐁᕐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ");
INSERT INTO crl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ᐋᒄ ᒫᒃ ᐁᕐ, ᒞᔓᐋᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒞᔓᐋ ᒫᒃ ᐁᓕᔨᓵᕐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᐁᓕᔨᓵᕐ, ᒞᕆᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒞᕆᒻ ᒫᒃ ᒫᑖᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ ᐋᒄ ᒫᑖᑦ, ᓖᕚᐃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ᓖᕚᐃ ᒫᒃ ᓯᒥᔨᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᓯᒥᔨᓐ, ᒍᑖᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒍᑖ, ᒍᓯᕝᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒍᓯᕝ ᒫᒃ ᒞᓂᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒞᓂᒻ, ᐁᓕᔮᑮᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ᐁᓕᔮᑮᒻ ᒫᒃ ᒣᓕᔮᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒣᓕᔮ, ᒣᓈᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒣᓈ ᒫᒃ ᒫᑖᕦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ ᐋᒄ ᒫᒃ ᒫᑖᑦ ᓀᕠᓐᐦ, ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᓀᕠᓐ ᒫᒃ ᑌᕕᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ᑌᕕᑦ ᒫᒃ ᒉᓰᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒉᓰ ᒫᒃ ᐅᐱᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐅᐯᑦ, ᑆᐋᔅᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᑆᐋᔅ ᒫᒃ ᓵᓪᒧᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐋᒄ ᒫᒃ ᓵᓪᒧᓐ, ᓈᔣᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ᓈᔣᓐ ᒫᒃ ᐊᒥᓂᑖᑉᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᐋᒥᓂᑖᑉ, ᐋᑦᒥᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐋᑦᒥᓐ ᒫᒃ ᐋᕐᓃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐋᕐᓃ, ᐦᐁᔅᕈᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐦᐁᔅᕈᓐ ᒫᒃ ᐯᕃᔅᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐯᕃᔅ, ᒍᑖᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ᒍᑖ ᒫᒃ ᒉᑭᑉᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᒉᑭᑉ, ᐋᐃᓯᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐋᐃᓵᒃ ᒫᒃ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᑌᕌᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᑌᕌ ᒫᒃ ᓀᐦᐅᕐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ᓀᐦᐅᕐ ᒫᒃ ᓭᕈᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐋᒄ ᒫᒃ ᓭᕈᒃ, ᕃᐤᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᕃᐤ ᒫᒃ ᐯᓓᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐯᓓᒃ, ᐁᐯᕐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᐁᐯᕐ, ᔐᓛᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ᔐᓛ ᒫᒃ ᑫᓈᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᑫᓈᓐ, ᐊᕐᕙᑭᓵᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐊᕐᕙᑭᓵᑦ ᒫᒃ ᔐᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᐋᒄ ᒫᒃ ᔐᒻ, ᓄᐙ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᓄᐙᐦ ᒫᒃ ᓚᒣᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ᓚᒣᒃ ᒫᒃ ᒣᕤᓯᓛᐦ ᒌ ᐅᑯᓯᑐᑖᑰ ᐋᒄ ᒫᒃ ᒣᕤᓯᓛ, ᐄᓍᒃᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐄᓍᒃ ᒫᒃ ᒑᕃᑦᐦ ᒌ ᐅᑯᓯᑐᑖᑰ, ᒑᕃᑦ ᒫᒃ ᒫᐦᐋᓛᓕᓪᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᒫᐦᐋᓚᓕᓪ ᒫᒃ ᑫᓈᓐᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ᑫᓈᓐ ᒫᒃ ᐄᓍᔥᐦ ᒌ ᐅᑯᓯᑐᑖᑰ ᐋᒄ ᒫᒃ ᐄᓍᔥ, ᓭᕪᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᓭᑦ ᒫᒃ ᐋᑎᒻᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ᐋᒄ ᒫᒃ ᐋᑕᒻ, ᒋᔖᒥᓂᑑᐦ ᒌ ᐅᑯᓯᑐᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ᐊᓂᑖᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐅᐦᑐᐦᑖᑦ ᒞᕐᑎᓐ ᓰᐲᐦᒡ, ᒌ ᓵᑭᔅᒋᓈᔥᑳᑰ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐄᑯᑦ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᑯᒀᒋᐦᐄᑯᑦ ᒥᒋᒥᓂᑑ ᒑ ᒌ ᒥᒋᐦᑐᑎᐦᒃ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᒀᒡ ᑳ ᐃᔥᐱᔥ ᑖᑦ ᐊᓂᑖᐦ ᓂᒧᐃ ᒑᒀᔨᐤ ᐅᐦᒋ ᒦᒋᐤ ᒌᓴᔅ᙮ ᒌ ᔒᐅᑖᐤ ᒫᒃ ᐄᔥᐱᐦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᑖᑦ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ᒥᒋᒥᓂᑑ ᒌ ᐄᑎᑰ, “ᑖᑆᐦ ᐃᔮᐎᓈ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐄᑎᔓᐙᔥ ᐆ ᐊᓯᓃ ᒑ ᒌ ᐋᔨᐦᑯᓈᐎᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᒧᐃ ᒥᒄ ᐋᐃᐦᑯᓈᐤ ᒋᑭ ᒌ ᐅᐦᒋ ᐱᒫᑎᓰᐤ ᐊᐙᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ᐋᒄ ᒥᒋᒥᓂᑑ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐋ ᐃᔥᐱᑎᓈᔨᒡ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ, ᒋᔨᔥᑭᒻ ᑳ ᐙᐱᐦᑏᔮᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋ ᐄᔑ ᑎᑯᓃᔨᒡ ᒥᓯᐙ ᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒥᓯᐙ ᒋᑭ ᐱᒋᔅᑎᓂᒫᑎᓐ ᒑ ᒌ ᑎᐹᔨᐦᒋᒑᔨᓐ ᐅᑎᐦ ᐅᐦᐄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ ᑭᔮᐦ ᒥᓯᐙ ᐊᓐ ᒦᓯᒋᓰᐎᓐ ᒑ ᒌ ᑎᐹᔨᐦᑎᒥᓐ᙮ ᓃᔨ ᒥᓯᐙ ᓂᒌ ᐱᒋᔅᑎᓂᒫᑭᐎᓐ, ᐋᒄ ᒫᒃ ᒥᒄ ᐊᓐ ᐊᐙᓐ ᐙᐦ ᒥᔨᒃ ᓂᑭ ᒌ ᒥᔮᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ᐋᐅᒄ ᒫᒃ ᐆ ᒥᓯᐙ ᒑ ᐄᔑ ᑎᐱᔨᐙᐅᓯᔨᓐ ᐹᒋ ᐊᔨᒥᐦᐋᔥᑎᐎᓈ ᒧᔮᒻ ᐋ ᐄᔑ ᐊᔨᒥᐦᐋᔥᑎᐎᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒥᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᒋᔖᒥᓂᑑᒧᐙᐤ ᐊᔨᒥᐦᐋᔥᑎᐙᐦᒄ ᑭᔮᐦ ᐐᔨ ᒥᒄ ᐋᐱᑎᓰᔥᑎᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ᐋᒄ ᒫᒃ ᒥᒋᒥᓂᑑ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᒌᓴᔅᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᒄ ᑳ ᔖᑭᒋᐙᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᐊᓂᑖᐦ ᒫᐅᒡ ᐋ ᐃᔥᐹᓈᔨᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑦ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᐃᔮᐎᓈ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐋᒥᒀᔥᑯᐦᑎᐦ, ");
INSERT INTO crl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒋᔖᒥᓂᑑ ᒋᑭ ᐄᑎᔓᐙᑖᐤ ᐅᑖᓐᒋᓂᒻᐦ ᒑ ᒌ ᒥᔪᓈᓈᑭᒋᐦᐄᔅᒌᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ᐋᓐᒋᓂᒡ ᒋᑭ ᑎᐦᑯᓂᑯᒡ ᒑᐦ ᐋᑳ ᐙᐙᒡ ᒌ ᐋᐦᑯᐦᑎᑖᔨᓐ ᒋᓯᑦᐦ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᒥᒋᒥᓂᑑ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ᒌᓴᔅ ᒫᒃ ᒌ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᐤ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᑳᐐ ᒋᑭ ᑯᒀᒋᐦᐋᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᒋᔖᒥᓂᑑᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ᐄᔥᐱᐦ ᒫᒃ ᒥᒋᒥᓂᑑ ᒥᓯᐙ ᑳ ᐄᔑ ᑯᒀᒋᐦᐋᑦ ᒌᓴᔅᐦ ᐙᐃᐱᔥᒌᔥ ᒌ ᓂᑭᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ᐋᒄ ᒌᓴᔅ ᑳᐤ ᑳ ᐄᔑ ᒌᐙᑦ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᐹᔮᒋᓰᔨᒡ ᐊᐦᒑᐦᒄᐦ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ᙮ ᒋᑭ ᑎᐹᒋᒫᑭᓂᐤ ᒫᒃ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᐊᓂᑖᐦ ᐄᑖᐦᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᒎᐄᔨᔨᐤ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᔨᔨᒡ, ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᒋᔅᑖᒋᒥᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᓈᓵᕆᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᓂᑎᐦ ᑳ ᓂᐦᑖᐅᒋᓈᑭᓅᑦ᙮ ᑳ ᒌ ᐄᑐᐦᑖᑦ ᒫᓐ ᐋ ᒎᐤ ᐋᔮᒦᐦᐋᐆᒋᓯᑳᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐋᑯᑖᐦ ᑳ ᐲᐦᒑᑦ᙮ ᒌ ᐱᓯᑰ ᒑ ᒌ ᐊᔨᒥᐦᑖᑦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ᐋᒄ ᑳ ᒥᔮᑭᓅᑦ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᐤ ᐋᐃᓵᔮ ᑳ ᐅᔑᑖᔨᑯᐱᓈᓂᐦᐄ᙮ ᒌ ᐋᐱᐦᐊᒻ ᐋᒄ ᑳ ᐊᔨᒥᐦᑖᑦ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᐦᒑᐦᒄ ᓂᐲᐦᒋᔥᑳᑯᔨᐤ, ᐙᔥ ᐐᔨ ᓂᒌ ᐅᐙᔮᐱᒧᒄ ᒑ ᒌ ᐐᐦᑎᒫᒥᐦᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ ᒑ ᒌ ᐐᐦᑎᒨᒀᐤ ᑳ ᒫᐦᒋᒀᐱᐦᑳᓱᒡ ᒑ ᒌ ᐱᑯᐦᐋᑭᓂᐎᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ ᒑ ᐙᐱᐦᑎᐦᒡ᙮ ᑭᔮᐦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒀᐤ ᐊᓂᒌ ᑳ ᓂᓈᐦᑳᑖᔨᒧᐦᐋᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ᑭᔮᐦ ᒫᒃ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑭᐎᓐ ᒑ ᒌ ᐐᐦᑎᒫᓐ ᐊᓂᔮᔨᐤ ᐋ ᐱᐳᓃᔨᒡ ᐋᐦ ᐅᑎᐦᒋᐱᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᐱᒫᒋᐦᐋᑦ ᐅᑎᔨᔨᒻᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᒋᐱᐦᐋᐦᒃ ᐊᓂᔮᔨᐤ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᔨᐤ, ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤᐦ ᐹᔨᒄᐦ ᓈᐹᐤᐦ ᐊᓂᑎᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᒌ ᐐᒋᐦᐄᐙᔨᒡ᙮ ᑳᐦ ᐋᑎ ᓂᑑᐙᔨᐱᑦ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᑖᒡ ᓈᔥᒡ ᒌ ᑭᓂᐙᐱᒫᐅᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐆ ᑳ ᐄᔑ ᐹᐦᑎᒫᒄ ᐋ ᐊᔨᒥᐦᑖᔮᓐ ᐋᐦ ᐄᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓅᐦᒡ ᑳᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒌ ᒥᔪᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᔨᒡ ᒌᓴᔅᐦ᙮ ᒌ ᑯᔥᑯᐃᑰᐎᒡ ᐋ ᐃᔥᐱᔥ ᑭᔅᒋᐦᐆᑖᑯᓰᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ, ᑖᓂᑖᐦ ᐙᐦᑎᓂᐦᒃ ᐅᔮᔨᐤ ᑳ ᐄᑎᐦᑖᑯᓯᑦ, “ᓂᒥᔮᔨᐤ ᐋ ᐅᔮᔨᐤ ᒍᓯᕝ ᐅᑯᓯᔅᐦ?” ");
INSERT INTO crl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒑᔥᑎᓈᔥ ᒋᑭ ᐹᒋ ᐄᔑᓈᐙᐤ ᐊᓐ ᑳ ᒌ ᐄᓈᓅᒡ, ‘ᓂᑐᐦᑯᔨᓐ, ᒌ ᒦᓂᐙᒋᐦᐄᓲ,’ ᑭᔮᐦ ᒫᒃ ᒋᑭ ᐹᒋ ᐄᔑᓈᐙᐤ, ‘ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᐦᒡ ᐋ ᒫᒥᔥᑳᒡ ᐋᔨᐦᑎᔨᓐ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᑐᑎᐦ ᑭᔮᐦ ᐅᑎᐦ ᐆ ᐃᐦᑖᐎᓐ ᑳ ᐅᐦᒋᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ᒥᒄ ᒫᒃ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᑳ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ ᓂᒧᐃ ᐃᔮᐱᑖᔨᒫᑭᓂᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᓂᐦᑖᐅᒋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ᓂᑐᐦᑎᒧᒄ ᒫᐦ᙮ ᑖᑆᒥᑭᓐ ᐆ ᒑ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ᙮ ᒫᒀᒡ ᐊᓂᔮ ᐄᓛᐃᒑ ᑳ ᐱᒫᑎᓰᑦ ᒌ ᐱᒥᐱᔨᐤ ᐋ ᑭᐎᐦᑭᑖᓂᐎᒡ ᐊᓂᑎᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᒨᐦᒡ ᓂᔥᑐ ᐱᐳᓐ ᒦᓐ ᐋᐱᐦᑑ ᐃᔥᐱᔥ᙮ ᒌᐦ ᑖᐅᒡ ᒫᒃ ᐊᓂᑎᐦ ᒥᐦᒑᑐ ᐃᔅᒀᐅᒡ ᐋ ᐹᔨᑯᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐄᑎᔑᐦᐙᑭᓂᐤ ᐄᓛᐃᒑ ᐙᒋ ᐹᔨᒄ ᒑ ᒌ ᓂᑎᐙᐱᒫᑦ ᐅᔮᔨᐤ ᐃᔅᒀᐤ ᒑ ᒌ ᓂᑑᐐᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ᐊᓂᑖᐦ ᒫᒃ ᓵᕃᕙᑦ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᓵᐃᑎᓐ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᐃᔅᒀᐤ ᐋ ᐹᔨᑯᑦ᙮ ᐋᑯᑖᐦ ᑳᐦ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐄᓛᐃᒑ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᐋᔨᐦᑖᔨᒡ, ᐊᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ᑭᔮᐦ ᒫᒃ ᒫᒀᒡ ᐋᔥᒄ ᐋ ᒌ ᐱᒫᑎᓰᑦ ᐊᓂᔮ ᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐄᓛᐃᔖ ᒌᐦ ᑖᐅᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ, ᑳ ᒫᔮᑎᓃᔨᒡ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ ᐋ ᒌ ᐃᔮᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐙᒋ ᐹᔨᒄ ᐅᐦᒋ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ ᐅᒌ ᒑ ᒌ ᐱᔮᐦᒋᓰᔨᒡ, ᒥᒄ ᐊᓐ ᓈᐹᐤ ᓀᒥᓐ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐤ, ᐊᓂᑖᐦ ᒫᒃ ᓯᕆᔮ ᐊᔅᒌᐦᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒌᑦ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓂᑑᐦᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑳᐦ ᑖᒡ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᒌᓴᔅᐦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᓈᔥᒡ ᒌ ᒋᔑᐙᔓᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ᐋᒄ ᑳ ᐱᓯᑯᒡ ᑳ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐅᑎ ᐃᐦᑖᐎᓂᐙᐦᒡ ᐅᐦᒋ᙮ ᐊᓂᑎᐦ ᒫᒃ ᐹᔓᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᑖᐎᓂᐙᐤ ᒌᐦ ᑎᑯᓂᔨᐤ ᐋ ᒌᔥᒋᔖᑳᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐋ ᒌ ᐐᐦ ᐋᒥᐙᐱᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ᒥᒄ ᒫᒃ ᒌᓴᔅ ᒌ ᒋᔅᑐᐦᑖᐤ ᐋᐦ ᐋᑎ ᔖᐳᐦᑎᐙᔥᑯᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ, ᑳ ᒋᔅᑯᑎᒧᐙᑦ ᐊᐙᔨᐤᐦ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ᒥᓯᐙ ᒌ ᒥᔅᑳᔑᑎᒧᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ ᑳ ᐃᔥᐱᔥ ᓲᐦᒑᔨᐦᑖᑯᓃᔨᒡ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᓈᐹᐤ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᒌ ᑖᑆᐤ ᒫᒃ ᐋᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ᑖᓐ ᐙᐦᑐᑎᐎᔮᐦᒡ ᒌᔨ ᒌᓴᔅ ᓈᓵᕆᑦ ᑳ ᐅᐦᒋᔨᓐ? ᒋᐐᐦ ᓂᔑᐎᓈᒋᐦᐄᓈᓐ ᐋ ᐙᐦᒋ ᑎᑯᔑᓃᔨᓐ? ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᐊᐙᓐ ᒌᔨ᙮ ᒌᔨ ᑳ ᐱᐦᑳᓂᐦᐄᔅᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐋᐱᒋᐦᐄᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ᒌᓴᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐊᐦᒑᐦᒄᐦ ᐋᐦ ᐄᑖᑦ, “ᐋᑳ ᒋᔅᑐᐦ᙮ ᐎᔨᐐᔅᑰ ᐊᓐ ᓈᐹᐤ᙮” ᐋᒄ ᐊᓐ ᐊᐦᒑᐦᒄ ᑳᐦ ᑐᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᔑ ᐱᐦᒋᔑᓃᔨᒡ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑳ ᐎᔨᐐᔅᑭᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᐦᐋᑳ ᐎᔮᔥ ᐅᐦᒌ ᑐᑎᐙᑦ ᒑ ᒌ ᐋᐦᑯᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ᑖᑆᐦ ᒫᒃ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᐄᐙᒡ ᐋᐦ ᐄᑎᑐᒡ, “ᒑᒄ ᐊᔨᒧᐎᓂᔨᐤ ᐅᔮᔨᐤ ᑳᐦ ᐋᐱᒋᐦᑖᑦ? ᑖᑆᐦ ᓲᐦᒋᐱᔨᐤ ᐅᑎᔨᒧᐎᓐᐦ ᑭᔮᐦ ᑖᑆᐦ ᓄᐎᒡ ᐅᒋᒫᐙᔨᐦᑖᑯᓲ ᒥᒄ ᐋ ᐄᔑ ᐎᔨᐐᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐎᔨᐐᑎᔑᐦᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ᐋᒄ ᒫᒃ ᑳ ᒥᔑᐦᑖᔮᒋᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ᒌᓴᔅ ᑳ ᐎᔨᐐᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᓵᐃᒥᓐ ᐲᑎᕐ ᐐᒋᔨᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᓵᐃᒥᓐ ᐲᑎᕐ ᒫᒃ ᐅᓯᑯᔅᐦ ᒌ ᐋᐦᑯᓯᔨᐤ ᐋ ᒋᔑᑖᐅᐱᔨᔨᒡ᙮ ᒌ ᓂᑐᑎᒧᐙᐅᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᐙᑳᐳ ᐊᓂᑖᐦ ᐄᔑ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᒋᔑᑖᐅᐱᓈᓂᐎᔨᒡ ᒑ ᒌ ᓂᑭᑎᑯᔨᒡ᙮ ᑏᐙᐦᒡ ᒫᒃ ᒌ ᓂᑭᑎᑯᔨᐤ, ᑳ ᐎᓂᔥᑳᑦ ᐊᓐ ᐃᔅᒀᐤ ᑳᐦ ᐋᑎ ᐊᔮᐱᑎᓰᔥᑑᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐱᐦᒋᔑᒧᔨᒡ ᐲᓯᒻ, ᒌ ᐹᑐᐙᐅᒡ ᐄᔨᔨᐅᒡ ᒌᓴᔅ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ, ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑖᔅᐱᓈᔨᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᑖᐦᒋᓈᐤ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᑳ ᒦᓂᐙᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᐎᔨᐐᔅᑳᑰᐎᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᔨᒡ, “ᐋᐅᒄ ᒌᔨ ᑖᑆᐦ, ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐤ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐊᔨᒥᔨᒡ, ᐙᔥ ᒌ ᒋᔅᒑᔨᒥᑰ ᐐᔨ ᐋᐦᐋᐎᑦ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᑖᐱᓃᔨᒡ ᒌᓴᔅ ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᑖᓂᐎᔨᒡ᙮ ᒌᐦ ᑖᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐋ ᓈᓂᑐᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒥᔅᑭᐙᒡ ᒋᐐᐦ ᔒᐦᒋᒫᐅᒡ ᐋᑳ ᒑ ᒌ ᓂᑭᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᐙᔥ ᓂᐱᐦ ᑭᒑᔅᒀᓐ ᑭᔮᐦ ᐊᓂᑖᐦ ᑯᑎᒃ ᐃᐦᑖᐎᓐ ᐆ ᒥᔻᒋᒧᐎᓐ ᐋ ᐙᐐᐦᑎᒫᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ᒌ ᐋᑎ ᑭᒑᔅᒀᐤ ᒫᒃ ᓂᓈᐦᑭᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒥᓯᐙ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ᐹᔨᒀᐤ ᒌᓴᔅ ᒫᒀᒡ ᐋ ᓃᐴᐎᑦ ᔑᔓᒡ ᓵᑭᐦᐄᑭᓂᐦᒡ ᑫᓀᓯᕃᑦ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐤ ᐋ ᓰᐦᑎᔅᑳᑯᑦ ᐋ ᓂᑑᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ᒌ ᐙᐱᐦᑎᒻ ᓃᔓ ᒌᒫᓂᔅ ᐊᓂᑎᐦ ᔑᔓᒡ, ᐋ ᒌ ᓂᑭᑎᒦᑯᐱᓈᓂᐦᐄ ᑳ ᓅᑎᒫᓵᔨᒡ ᒑ ᒌ ᓂᑑᒋᔥᑖᐹᐎᔮᔨᒡ ᐅᑎᐦᐄᐲᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ᒌ ᐴᓲ ᒫᒃ ᒌᓴᔅ ᐹᔨᒄ ᒌᒫᓂᓯᔨᐤ, ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮ ᑳ ᑯᒀᒋᒫᑦ ᓵᐃᒥᓐ ᐲᑎᕐ ᒑ ᒌ ᒧᔖᐅᐦᐊᒥᔨᒡ ᐊᐱᔒᔥ᙮ ᐋᒄ ᒫᒃ ᑳ ᐅᐙᔨᐱᑦ ᒌᓴᔅ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑎᐦ ᒌᒫᓂᓯᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐊᔨᒥᑦ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ, “ᒧᔖᐅᐦᐊᒧᒄ ᐊᓂᑖᐦ ᐋ ᒌᔥᑳᔨᐙᒡ ᒑ ᐱᑭᔥᑎᐙᐦᐋᑯᒡ ᒋᑎᐦᐄᐲᐙᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ᓵᐃᒥᓐ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐃᔅᑭᓐ ᑎᐱᔅᑳᐤ ᓂᒌ ᓂᑑᓂᒫᓵᓈᓐ, ᓂᒧᐃ ᒫᒃ ᓅᐦᒋ ᐱᑎᐦᐅᔮᓈᓐ᙮ ᓂᐹᔥ ᒫᒃ ᓂᑭ ᐱᑭᔥᑎᐙᐦᐙᓈᓂᒡ ᓂᑑᐦᐄᐲᓈᓂᒡ ᐙᔥ ᐋᐅᒄ ᐋᔑᔮᐦᒡ ᒑ ᑎᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐱᑭᔥᑎᐙᐦᐙᒡ ᐅᑎᐦᐄᐲᐙᐤ ᒌ ᐋᑎ ᐲᑯᐱᔨᐤ ᐅᑎᐦᐄᐲᐙᐤ ᑳ ᐃᔥᐱᔥ ᒥᔥᑎᐦ ᐱᑎᐦᐅᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ᐋᒄ ᑳ ᐙᔥᑎᓂᒧᐙᒡ ᐐᒋᓅᑎᒫᓵᓯᐙᐤ ᑯᑎᒋᔨᐤ ᒌᒫᓂᓯᔨᐤ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᐹᒋ ᐐᒋᐦᐄᑯᒡ᙮ ᐋᒄ ᑳ ᐹᒋ ᓂᑑᐦᐅᑯᒡ᙮ ᑖᐱᔥᑯᓐ ᒫᒃ ᐊᓂᐦᐄ ᒌᒫᓂᔅ ᒋᐐᐦ ᑯᔖᐹᐤ ᑳ ᐃᔥᐱᔥ ᓵᑭᔅᒋᓈᒡ ᓂᒫᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ᐄᔥᐱᐦ ᒫᒃ ᓵᐃᒥᓐ ᐲᑎᕐ ᐎᔮᐱᐦᑎᐦᒃ ᐋ ᐃᔅᐱᔨᒡ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐆ ᐅᐦᑎᔅᑰ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ, ᐋᐦ ᐃᔨᑦ, “ᓂᑭᓯᐦ, ᐅᑎᐹᔨᐦᒋᒑᐤ, ᐙᔥ ᓂᒥᒑᑎᓰᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ᒌ ᑯᔥᒀᔨᐦᑎᒥᐦᐄᑯᒡ ᓵᐃᒥᓐ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐐᒋᓅᑎᒫᓵᓯᐙᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᒥᔅᑎᐱᑎᐦᐅᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᓅᑎᒫᓵᓯᐤᐦ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ, ᓭᐱᑏ ᐅᑯᓯᔅᐦ, ᐐᔨᐙᐤ ᑭᔮᐦ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐᐦ, “ᐊᑳᐐ ᓵᒋᓯᐦ᙮ ᐙᔥ ᒧᔮᒻ ᐄᔨᔨᐅᒡ ᐋ ᐱᑎᐦᐅᔮᔮᒄ ᐋᐅᒄ ᔖᔥ ᒑ ᑎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ᒌ ᓵᔅᒋᐱᑎᒧᒡ ᒫᒃ ᐅᒌᒫᓂᐙᐤ ᑳ ᓂᑭᑎᐦᒡ ᒥᓯᐙ ᒑᒀᔨᐤ ᐊᓂᑎᐦ, ᐋᒄ ᑳ ᐐᒑᐙᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋᐦ ᑖᑦ ᐊᓂᑖᐦ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐊᓂᑎᐦ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ ᐋ ᒫᔮᑎᓃᔨᒡ ᐋ ᐃᔮᑦ᙮ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᒌᓴᔅᐦ ᒌ ᐅᑎᐦᑎᐱᔨᐦᐆ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ, ᐋᒄ ᓈᔥᒡ ᑳ ᐱᑯᓵᔨᒫᑦ ᒑ ᒌ ᐐᒋᐦᐄᑯᑦ, ᐋᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐐᐦ ᐹᒋ ᐐᒋᐦᐄᓈ ᒋᑭ ᒌᐦ ᑐᑎᐎᓐ ᒑ ᒌ ᐱᔮᐦᒋᓯᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ᒌᓴᔅ ᒌ ᔑᐎᓂᔅᒑᔨᐤ ᑳ ᑖᐦᒋᓈᑦ ᐋᐦ ᐄᑖᑦ, “ᒋᐐᐦ ᐐᒋᐦᐄᑎᓐ᙮ ᐱᔮᐦᒋᓰᐦ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒦᓂᐙᑎᓰᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔅᐱᓈᑦ ᐊᓐ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ᒌᓴᔅ ᒫᒃ ᒌ ᐄᑎᔓᒫᐤ ᐋᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᐐᐦᑎᒨ ᐊᐙᓐ ᑖᓐ ᑳ ᐄᔅᐱᔨᓐ᙮ ᒫᒌᐦ, ᓂᑑᓅᑯᐦᐄᓲ ᑎᐙᐦᒡ ᐊᓅᐦᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᑦ ᒑ ᐙᐱᒥᔅᒃ ᐋ ᒌ ᒦᓂᐙᒋᐦᐄᑭᐙᑦ᙮ ᑭᔮᐦ ᒑ ᐱᒋᔅᑎᓂᒑᔨᓐ ᐊᓐ ᒑᒀᓐ ᐊᓂᔮᔨᐤ ᒧᓱᔅᐦ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᐱᒋᔅᑎᓂᒑᓅᐎᔨᒡ ᐋ ᒌ ᐱᔮᐦᒋᐦᐋᑭᓅᑦ ᐊᐙᓐ᙮ ᐆ ᒫᒃ ᑎᔨᓈ ᒥᓯᐙ ᐊᐙᓐ ᒋᑭ ᒋᔅᒑᔨᐦᑎᒻ ᑖᑆᐦ ᒥᑐᓐ ᐋ ᒌ ᐱᔮᐦᒋᐦᐄᑭᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ᒌ ᒥᔑᐦᑖᐱᔨᐤ ᒫᒃ ᒌᓴᔅ ᐋᐦ ᐄᑖᒋᒫᑭᓅᑦ᙮ ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐋ ᐐᐦ ᓂᑐᐦᑖᑯᑦ ᑭᔮᐦ ᐋ ᐐᐦ ᒦᓂᐙᒋᐦᐄᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ᒌ ᐄᑐᐦᑖᐤ ᒫᒃ ᒫᓐ ᒌᓴᔅ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ, ᐋᒄ ᑳ ᒌ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ᐹᔨᒀᐤ ᒌᓴᔅ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ ᐹᕆᓰ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐅᒌ ᒫᒃ ᓈᐹᐅᒡ ᒥᓯᐙ ᐃᐦᑖᐎᓂᐦᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ, ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᑭᔮᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᐃᔮᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ᒫᒀᒡ ᒫᒃ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᒌᓴᔅ ᒌ ᐅᐦᒋ ᐹᔓᐙᐅᒡ ᓈᐹᐅᒡ ᐐᑖᐹᐙᐤ ᐋᐦᐋᑳ ᐅᐦᒌ ᐋᐦᑎᓂᓲᔨᒡ ᐊᔥᐱᔑᒧᓂᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ᙮ ᒋᐐᐦ ᐲᐦᑎᑭᐦᐋᐅᒡ ᐊᓂᑎᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐋ ᒌ ᐐᐦ ᐱᒥᔑᒫᒡ ᐅᐦᑎᔅᑰ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᐲᐦᑎᑭᐦᐋᐅᒡ ᐙᔥ ᐋ ᒌ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐲᐦᑎᑭᒥᐦᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᓵᑭᒋᐙᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᑳ ᐱᑯᓈᐱᑎᐦᒡ ᐊᐱᐦᒀᓂᔨᐤ ᐊᓂᑖᐦ ᑎᐦᑯᐦᒡ ᐊᓂᑖᐦ ᑳ ᐅᐦᒋ ᐱᒋᔥᑖᐱᐦᒑᓈᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐊᓂᑎᐦ ᑖᐙᔨᔥ ᐋ ᑖᓂᐎᔨᒡ, ᐅᐦᑎᔅᑰ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐱᒋᔅᑎᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐎᔮᐱᐦᑎᒸᑦ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤ ᑳ ᐱᒥᔑᓃᔨᒡ, “ᓂᐐᒑᐙᑭᓐ, ᒋᐙᐹᔨᐦᑎᒫᑭᐎᓐ ᒋᒥᒋᐦᑣᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᑳᐦ ᐋᑎ ᐋᔨᒸᐅᐦᐄᑯᐙᒡ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ, ᐋᐦ ᐄᑎᑐᒡ, ᒫᔮᔨᐦᒑᐤ ᐆ ᓈᐹᐤ ᐋᐦ ᐃᔨᑦ, “ᒌ ᐙᐹᔨᐦᑎᒫᑭᐎᓐ ᒋᒥᒋᐦᑣᐎᓐ᙮ ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐙᐹᔨᐦᑎᒧᐙᐤ ᐊᐙᔨᐤᐦ ᐅᒥᒋᐦᑣᐎᓂᔨᐤ, ᒥᒄ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ᐄᔥᐱᐦ ᒌᓴᔅ ᒑᔅᒑᔨᒫᑦ ᐋ ᐄᔑ ᐊᔨᒥᐦᐄᑐᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᒑᒀᓐ ᐙᐦᒋ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᐊᓐ ᑳ ᐃᔮᓐ? ");
INSERT INTO crl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ᑖᓂᔮᔨᐤ ᒫᒃ ᐊᐅᔅᑖ ᐎᔮᐦᑎᓃᔨᒡ ᒑ ᒌ ᐄᑖᑭᓅᑦ? ‘ᒌ ᐙᐹᔨᐦᑎᒫᑭᐎᓐ ᒋᒥᒋᐦᑣᐎᓐ,’ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐄᑖᑭᓅᑦ? ‘ᐎᓂᔥᑳᐦ, ᐋᒄ ᒫᒃ ᐱᒧᐦᑖᐦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ᒋᑭ ᐙᐱᐦᑏᑎᓈᐙᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑖᑆᐦ ᐐᔨ ᐋ ᐃᔮᑦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᒑᑦ ᒥᒋᐦᑣᐎᓐ᙮” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᐋᑳ ᐙᐦᒋ ᐋᐦᑎᓂᓱᔨᒡ, “ᐱᓯᑰᐦ, ᐅᑎᓐᐦ ᒋᑎᔥᐱᔑᒧᓐ, ᒑ ᒌᐙᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐱᔑᑰ ᐊᓐ ᓈᐹᐤ ᑖᐙᔨᔥ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ, ᑳᐦ ᐋᑎ ᐅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑎᔥᐱᔑᒧᓐ ᐋᒄ ᑳᐦ ᐋᑎ ᒌᐙᑦ ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᑭᔮᐦ ᒌ ᓵᒋᓯᐎᒡ᙮ ᒌ ᒋᔅᑖᒋᒫᐅᒡ ᒋᔖᒥᓂᑑᐦ ᐋᐦ ᐃᔨᒡ, “ᑖᑆᐦ ᒫᒥᔥᑳᒡ ᒋᑎ ᐄᔑ ᐙᐱᐦᑖᓈᓂᐤ ᒑᒀᓐ ᐊᓅᐦᒡ ᐋᐦ ᐄᔅᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔑᐱᔨᐦᒡ ᐆ ᒌ ᐎᔨᐐᐤ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ᒌ ᐙᐱᒫᐤ ᒫᒃ ᓈᐹᐤᐦ ᐋ ᐊᐱᔨᒡ ᐅᒥᓯᓂᐦᐄᒑᐅᑭᒥᑯᔨᒡ, ᓖᕚᐃᐦ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᑳ ᒫᒨᔑᒋᓃᔨᒡ ᒋᐦᒋᐅᒋᒫᐤᐦ ᔓᐎᔮᓐ ᐋᐦ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐱᐹᐐᒑᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ᑳ ᐱᓯᑯᑦ ᓖᕚᐃᐦ ᑳ ᓂᑭᑎᐦᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᐃᔮᑦ ᐋᒄ ᑳ ᐱᐹᐐᒑᐙᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ᐹᑎᒫ ᒫᒃ ᒌ ᒥᔥᑏᐦ ᒥᑯᔖᐦᐋᐤ ᒌᓴᔅ ᐊᓂᑖᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒦᐦᒡ᙮ ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᑯᑎᒃ ᑳ ᒫᒨᔑᒋᓈᔨᒡ ᒋᐦᒋᐅᒋᒫᐤᐦ ᔓᐎᔮᓐ ᐋᐦ ᐄᑖᐱᑎᓰᔨᒡ ᑭᔮᐦ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒌᐦ ᑖᔨᐤ ᐋ ᒌ ᐐᒋᒦᒋᓲᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ᐋᒄ ᒫᒃ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᑳ ᐊᔨᒥᐦᐋᒡ ᒌᓴᔅᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤᐦ ᐋᐦ ᐄᑖᒡ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐐᒋᒦᒋᓲᒫᑯᒡ ᐊᓂᒌ ᑳ ᒫᒨᔑᒋᓈᐦᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᐅᒥᒋᐦᑣᐎᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᑎᐙᔨᒫᐅᒡ ᓂᑐᐦᑯᔨᓐ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳᐦ ᐋᐦᑯᓯᒡ, ᒥᒄ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᐋᐅᑯᓂᒡ ᓈᑐᐙᔨᒫᒡ ᓂᑐᐦᑯᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ᓂᒥᔮᐅᒡ ᐊᓂᒌ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᒥᒄ ᓂᑐᒥᒀᐤ ᐙᐦᒋ ᑎᑯᔑᓂᔮᓐ᙮ ᓂᒌᑎᑯᔑᓐ ᒑ ᒌ ᓂᑐᒥᒀᐤ ᐅᒥᒋᐦᑣᐎᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ᐹᕆᓰᒡ ᒫᒃ ᒌ ᐄᑖᐅᒡ ᒌᓴᔅᐦ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᒥᐦᒑᑣᐤ ᑐᑎᒥᔨᒡ ᒞᓐ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦᐋᑳ ᐋᔑᑯᒻ ᒦᒋᓱᔨᒡ, ᒥᒄ ᒑ ᒌ ᐊᔨᒥᐦᐋᔨᒡ? ᑭᔮᐦ ᓃᔮᓐ ᓂᒋᔅᒋᓂᐦᐊᒧᐙᑭᓈᓂᒡ ᐋᔪᐎᒄ ᐋᐦ ᑎᒡ᙮ ᒌᔨ ᒫᒃ ᒋᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓂᒧᐃ ᑑᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒸᐦᒡ ᐊᓂᑖᐦ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᒡ ᒋᑭ ᒌᐦ ᑑᐎᒡ ᐋ ᒑᐦ ᐋᑳ ᒌ ᒦᒋᓱᒡ ᐊᓂᒌ ᑳ ᓂᑐᒫᑭᓂᐎᒡ ᐋ ᒥᑯᔖᓂᐎᔨᒡ? ᒥᔔ ᐋᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ ᐊᓂᔮᔨᐤ ᐅᔅᒋᓈᐹᐙᓐ ᓂᒧᐃ ᓈᔥᑎᔨᒡ ᑭᑎ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒧᒡ ᒑᐦ ᐋᑳ ᒌ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᐦᒋᐱᔨᒑ ᒑ ᐹᒋ ᒥᔅᑭᒫᑭᓂᐎᒡ ᐅᔅᒋᓈᐹᐙᓐ ᐋᒄ ᒫᒃ ᐃᔮᒄ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒦᒋᓲᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐊᐙᓐ ᒋᐱᐦ ᒌ ᐅᐦᒋ ᐱᐦᒀᐱᑎᒻ ᐋ ᐅᔥᑳᔨᒡ ᐅᑎᑯᐦᑉ ᒑ ᒌ ᒦᔑᐦᐋᐦᒃ ᐙᔥᑭᒡ ᐊᑯᐦᐱᔅᒌᓯᔨᐤ᙮ ᐙᔥ ᐅᔮᔨᐤ ᑐᑎᐦᑳ, ᑭᑎ ᐃᔮᔪᐦᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᐅᔥᑳᔨᒡ ᐅᑎᑯᐦᑉ᙮ ᐊᓐ ᒫᒃ ᑳ ᐅᔥᑭᒡ ᒦᔑᐦᐄᑭᓐ, ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐄᓈᑯᓐ ᐊᓂᑎᐦ ᐙᔥᑭᒡ ᐊᑯᐦᐱᔅᒌᔑᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ᓂᒧᐃ ᑭᔮᐦ ᐊᐙᓐ ᐲᐦᑖᐹᐅᑖᐤ ᐋ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ ᐊᓂᑖᐦ ᐄᔑ ᐙᔅᑭᒡ ᐲᔖᑭᓐ ᐐᐦᒀᔮᐦᒡ᙮ ᐙᔥ ᐊᓂᑖᐦ ᐄᔑ ᐲᐦᑖᐹᐎᑖᒑ, ᐄᔥᐱᐦ ᒫᒃ ᐅᔑᐦᐆᒥᑭᓃᔨᒑ, ᒥᑐᓐ ᒋᑭ ᑖᑐᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐲᔖᑭᓐ ᐐᐦᒀᔮᔨᐤ᙮ ᐋᒄ ᒫᒃ ᓂᒥ ᑭᑎ ᐃᔮᐤ ᔔᒥᓈᐴᔨᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐲᔖᑭᓐ ᐐᐦᒀᔮᔨᐤ ᓂᒧᐃ ᔖᔥ ᑭᑎ ᐅᐦᒋ ᐃᓯᓈᑯᓂᔨᐤ ᒦᓐ ᒑ ᒌ ᐋᐱᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ᐋ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ ᐊᓂᑖᐦ ᐋ ᐅᔥᑳᔨᒡ ᐲᔖᑭᓐ ᐐᐦᒀᔮᔨᐤ ᒋᐱᐦ ᐄᔑ ᐲᐦᑖᐹᐅᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ᐊᐙᓐ ᔖᔥ ᐋ ᒌ ᑯᒋᔥᑎᐦᒃ ᐙᔥᑭᒡ ᔔᒥᓈᐴᔨᐤ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐐ ᒥᓂᐦᒀᐤ ᐋ ᐅᔥᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ᙮ ᐙᔥ ᐊᓂᔮᔨᐤ ᐙᔥᑭᒡ ᔔᒥᓈᐴᔨᐤ ᐊᐅᔅᑖ ᑭᑎ ᐐᐦᒋᔅᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ, ᒌᓴᔅ ᒌ ᐐᒑᐙᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐋ ᐱᒧᐦᑖᒡ ᐊᓂᑖᐦ ᑳ ᒌ ᓂᐦᑖᐅᒋᓃᔨᒡ ᐱᐦᒀᔑᑭᓂᒥᓈᐦᑎᒄ᙮ ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳᑭᒑᒥᐦᐱᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐱᐦᒀᔑᑭᓂᒥᓐ, ᐋ ᐱᒋᔅᒋᓂᐦᒡ ᐅᑎᐦᒌᐙᐅᐦᒡ ᐋ ᒦᒋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ᒌ ᐹᒋ ᓈᑎᑰᐎᒡ ᒫᒃ ᐱᔅᒡ ᐹᕆᓰᐦ ᐋᐦ ᐄᑎᑯᒡ, “ᒋᑖᔮᔅᑭᐐᐦᑳᓈᐙᐤ ᐋ ᒋᒦᒋᒧᐙᐤ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ? ᒑᒀᓐ ᐙᐦᒋ ᐄᐦᑐᑎᒫᒄ ᐊᓐ ᒑᒀᓐ ᐋᑳ ᒑ ᑐᑎᒧᐙᑯᐱᓈ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᒌ ᐊᔨᒥᐦᑖᓈᐙᒑ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳ ᑎᐹᒋᒫᑭᓅᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ, ᒥᓯᐙ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᒑᐅᑯᑦ ᐄᔥᐱᐦ ᑳ ᐐᐦ ᒦᒋᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ᑌᕕᑦ ᒌ ᐲᐦᒑᐤ ᒋᔖᒥᓂᑑ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᐋᒄ ᑳ ᐅᑎᓈᑦ ᑳ ᒧᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑳ ᐊᔑᒫᑦ ᐅᐐᒑᐙᑭᓐᐦ᙮ ᒥᒄ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ ᒑ ᒌ ᒧᐙᐙᑯᐱᓈ ᐅᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐙᔥ ᐋᐅᒄ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ᒌᐦ ᐄᑖᐤ ᑭᔮᐦ ᒌᓴᔅ, “ᐄᔨᔨᐅᑯᓯᓵᓐ ᒫᒃ ᐙᐙᒡ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᑎᐹᔨᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ᒦᓐ ᒫᒃ ᐹᔨᒀᐤ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᒌᓴᔅ ᒌ ᐲᐦᒑᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᒌ ᒋᔅᑯᑎᒫᒑᑦ᙮ ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᓈᐹᐤ ᐅᓂᐦᐄᐎᓂᐦᒡ ᐅᑎᐦᒌ ᐋ ᒫᔅᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ᐊᓂᒌ ᒫᒃ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᑭᔮᐦ ᐹᕆᓰᒡ ᔮᒀᐦ ᒌ ᓈᓈᑭᒋᐦᐋᐎᒡ ᒌᓴᔅᐦ ᒑ ᒦᓂᐙᒋᐦᐄᐙᔨᒀᓂᐦᐄ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮ ᒋᐐᐦ ᓈᓂᑐᒥᔅᑭᒧᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒫᒥᔑᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒥᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᐅᑎᐦᒌᔨᐤ ᑳ ᒫᔅᑭᓃᔨᒡ, “ᐱᓯᑰᐦ, ᐅᑖᐦ ᑖᑖᐅᒡ ᐹᒋ ᓃᐴᐦ᙮” ᒌ ᐱᓯᑰ ᐊᓐ ᓈᐹᐤ, ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᐐᐦ ᒫᒥᔑᒥᑯᑦ, “ᒋᑭ ᑯᒀᒋᒥᑎᓈᐙᐤ, ᑖᓐ ᐋ ᐄᔑ ᐱᑯᓵᔨᒥᑯᔨᐦᒄ ᐐᔓᐙᐎᓐ ᒑ ᒌᐦ ᑐᑎᒧᑯᐱᓈ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮ ᑖᓐ ᑯᐃᔥᒄ ᒑ ᒌᐦ ᑐᑎᒥᓐ ᒑᒀᓐ᙮ ᐋ ᒥᔪᑐᑎᒥᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᒋᐦᑐᑎᒥᓐ, ᐋ ᐱᒫᒋᐦᑖᔨᓐ ᒫᒃ ᐋᐦᐋᑳ ᐐᐦ ᐱᒫᒋᐦᑖᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ᐋᒄ ᒫᒃ ᒌᓴᔅ ᑳ ᑭᓂᐙᐱᒫᑦ ᒥᓯᐙ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒫᔅᑭᓃᔨᒡ ᐅᑎᐦᒌᔨᐤ, “ᓰᑐᐱᔨᐦᑖᐦ ᒋᑎᐦᒌ᙮” ᒌ ᓰᑐᐱᔨᐦᑖᐤ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ ᐋᒄ ᒫᒃ ᑳ ᒦᓂᐙᒋᐦᑖᑭᓂᐎᔨᒡ, ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑯᑎᒋᔨᐤ ᐅᑎᐦᒌ ᑳ ᐄᔑ ᒥᔻᔨᒡ ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᒌ ᑳ ᒫᔅᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ᐋᒄ ᒫᒃ ᓈᔥᒡ ᑳ ᒋᔑᐙᓯᒡ ᐊᓂᒌ ᑳ ᐐᐦ ᒫᒥᔑᒫᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳᐦ ᐋᔨᒸᐦᐄᑯᒡ ᑖᓐ ᒑ ᒌᐦ ᑐᑎᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ᐹᔨᒀᐤ ᐋ ᒌᔑᑳᔨᒡ ᒌᓴᔅ ᒌ ᐄᑐᐦᑖᐤ ᐋᐱᔅᑯᑎᓈᔨᒡ, ᒑ ᓂᑐᐊᔨᒥᐦᐋᑦ᙮ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᐃᔅᑭᓐ ᑎᐱᔅᑳᐤ ᐋ ᐊᔨᒥᐦᐋᔥᑎᐙᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᓃᔨᒡ ᒌ ᓂᔥᑑᓈᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓅᔔᔥᑳᑯᑦ, ᐋᒄ ᑳ ᐅᐙᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᑆᔅᑎᓕᒡ ᒑ ᒌ ᐄᑖᐱᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ, ᓵᐃᒥᓐ, ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᑖᑦ ᑭᔮᐦ ᐅᔒᒦᔨᐤ ᐋᓐᑎᕉ᙮ ᑭᔮᐦ ᒫᒃ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᑭᔮᐦ ᕕᓕᑉ ᑭᔮᐦ ᐹᕐᐧᕧᓚᒥᔪ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ᒫᕠᔫ ᒫᒃ, ᐋᒄ ᒦᓐ ᑣᒥᔅ, ᒉᒥᔅ ᐊᓂᔮ ᐊᓪᕕᔨᔅ ᐅᑯᓯᔅᐦ᙮ ᐋᒄ ᒫᒃ ᓵᐃᒥᓐ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ᒍᑖᔅ ᒫᒃ ᑭᔮᐦ ᒌ ᐙᔮᐱᒫᑭᓂᐤ, ᒉᒥᔅ ᐅᑯᓯᔅᐦ᙮ ᐋᒄ ᒫᒃ ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ, ᐋᐅᒄ ᐊᓐ ᐆ ᒑ ᒫᒥᔑᒫᑯᐱᓈ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᓃᐦᑎᒋᐙᒡ ᐎᒋᔨᐤ ᐊᓂᑖᐦ ᒌ ᐄᑐᐦᑖᐅᒡ ᐋ ᑖᐱᔅᑰᑎᔅᑭᒥᑳᔨᒡ᙮ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤ ᑳ ᓅᔓᔅᑳᑯᑦ ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ ᑭᔮᐦ ᒌ ᒥᐦᒑᑎᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ, ᓂᓈᐦᑭᐤ ᐋ ᒌ ᐅᐦᑐᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᒎᑏᔮ ᐊᔅᒌᔨᐤ ᐋ ᐃᔥᐱᔖᔨᒡ᙮ ᒋᕉᓯᓕᒥᐦᒡ ᑭᔮᐦ ᑯᑎᑭᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ, ᑯᑎᑭᒡ ᑭᔮᐦ ᔑᔓᒡ ᒋᐦᒋᑭᒦᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐃᐦᑖᐎᓐ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ᒌ ᑎᑯᔑᓂᒡ ᒑ ᒌ ᐹᒋ ᓂᑑᐦᑎᐙᒡ ᒌᓴᔅᐦ, ᑭᔮᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᑯᒡ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐅᑎᑖᔅᐱᓈᐎᓂᐙᐤ᙮ ᒌ ᑎᑯᔑᓂᒡ ᑭᔮᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒧᑯᔥᑳᒋᐦᐄᑯᒡ ᒥᒋᐊᐦᒑᐦᒄ, ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᒋᐐᐦ ᑖᐦᒋᓈᐤ ᒌᓴᔅᐦ, ᐙᔥ ᒦᓂᐙᒋᐦᐄᐙᐤ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒌ ᐅᐦᒋᐱᔨᐤ ᐋᐦ ᑖᔨᒡ᙮ ᑎᐦᑐ ᒫᒃ ᐊᐙᓐ ᑳ ᑖᐦᒋᓈᑦ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ᒌᓴᔅ ᒌ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓅᔓᔅᑳᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᒋᔅᑎᒫᑎᓯᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᒋᒥᓯᓈᓱᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᓅᐦᑖᐦᑭᑖᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᒋᑭ ᒌᔥᐳᐦᐄᑯᓈᐙᐤ᙮ ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᒫᑐᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᒋᑭ ᐹᐦᐱᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᐅᐦᑳᑖᔨᒥᑯᐎᔮᒄ, ᐋᐦᐋᑳ ᐱᔅᑳᑎᑯᐎᔮᒄ, ᐋ ᒫᔮᔨᒥᑯᐎᔮᒄ ᑭᔮᐦ ᐋ ᒥᒋᐋᔨᒨᒥᑯᐎᔮᒄ ᓃᔨ ᐅᐦᒋ, ᐄᔨᔨᐅᑯᓯᓵᓐ, ᐋ ᓅᔔᔥᑯᔮᒄ, ");
INSERT INTO crl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ᒥᔻᔨᐦᑎᒧᒄ ᒫᒃ ᐆ ᑐᑖᑯᔮᒀ, ᑭᔮᐦ ᒀᔥᑯᐦᑎᒄ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᒫᒄ᙮ ᐙᔥ ᑭᓂᐙᔨᐦᑖᑯᓐ ᐋ ᒥᔖᒡ ᒋᑎᐱᐦᐋᒫᑯᓰᐎᓂᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᐙᔥ ᐊᓂᒌ ᐅᔮᔨᐤ ᑳᐦ ᑐᑖᑖᑯᒡ ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᑖᐦᒡ ᐅᐙᐦᑯᒫᑭᓂᐙᐤᐦ, ᐋᔪᐎᒄ ᒧᔮᒻ ᑳᐦ ᑐᑎᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑖᐦᒡ ᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ᔮᒀᒄ ᒌᔨᐙᐤ ᑳ ᒥᓯᒋᓰᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᒥᑐᓐ ᔖᔥ ᒋᒌ ᐃᔮᓈᐙᐤ ᐋ ᐙᐦᑖᔨᐦᑖᑯᐦᒡ ᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ᔮᒀᒄ ᒌᔨᐙᐤ ᑳ ᑖᐱᔥᑯᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᒋᑭ ᓅᐦᑖᐦᑭᑖᓈᐙᐤ᙮ ᔮᒀᒄ ᒌᔨᐙᐤ ᑳ ᐹᐦᐱᔮᒄ ᐊᓅᐦᒡ, ᐙᔥ ᒋᑭ ᒫᑑᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ᔮᒀᒄ ᒌᔨᐙᐤ ᑳ ᒥᔻᒋᒥᑯᐎᔮᒄ, ᐙᔥ ᐊᓂᒌ ᑳ ᒥᔻᒋᒥᑖᑯᒡ, ᐊᓂᔮᔨᐤ ᐅᑖᐦᒡ ᐅᐙᐦᑯᒫᑭᓂᐙᐤᐦ, ᐋᔪᐎᒄ ᒧᔮᒻ ᑳ ᐄᔑ ᒥᔻᒋᒫᔨᒡ ᐋᑳ ᑳ ᑖᑆᓰᔨᒡ ᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ᐆ ᒫᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᓂᑐᐦᑎᒫᒄ᙮ ᓵᒋᐦᐋᐦᑯᒡ ᐊᓂᒌ ᑳ ᒥᒑᔨᒥᑖᑯᒡ, ᒥᔪᑐᑎᐙᐦᑯᒡ ᐊᓂᒌ ᑳ ᐅᐦᑳᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ᐊᔨᒥᐦᒋᑳᔥᑎᒧᐙᐦᑯᒡ ᒑ ᒌ ᒋᔖᐙᑐᑖᑯᒡ ᒋᔖᒥᓂᑑ ᑖᓐᒌ ᐊᓂᒌ ᑳ ᒥᒋᐄᔥᒌᔂᑖᑯᒡ ᑭᔮᐦ ᐊᔨᒥᐦᒋᑳᔥᑎᒧᐙᐦᑯᒡ ᐊᓂᒌ ᑳ ᒫᔮᔨᒥᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐅᑖᒥᐦᐆᔅᑳ ᓂᐱᑖ ᒋᑖᒥᐦᑭᓂᐦᒡ, ᐋᑯᔥ ᒥᔨ ᒑ ᒌ ᐅᑖᒥᐦᐆᔅᒃ ᒀᔥᑖ ᒋᑖᒥᐦᑭᓂᒡ, ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐅᑎᓂᐦᑳ ᒋᑎᑯᐦᐱᔨᐤ ᐋᑯᔥ ᒥᔨ ᒑ ᒌ ᐃᔮᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᐱᒍᔮᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ᒥᔨ ᑎᐦᑐ ᐊᐙᓐ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᒑᒀᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐊᐙᓐ ᐅᑎᓂᐦᑳ ᒑᒀᔨᐤ ᐋ ᑎᐱᔮᐙᐎᓯᐎᑦ, ᐊᑳᐐ ᒦᓐ ᑳᐤ ᓂᑎᐙᔨᐦᑎᒨ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ᑐᑎᐎᒡ ᐄᔨᔨᐅᒡ ᒸᐦᒡ ᐋ ᐄᔑ ᐱᑯᓵᔨᒥᑣᐤ ᒑ ᒌ ᑐᑖᔅᒡ ᑭᔮᐦ ᒌᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“ᒑᒀᓐ ᐋ ᓈᔥᒡ ᒋᐱᐦ ᐃᓯᓈᑯᓐ ᒥᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓵᒋᐦᐄᔅᒡ ᓵᒋᐦᐄᑣᐤ? ᐙᔥ ᐋᔪᐎᒄ ᐋᐦ ᑎᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐅᒥᒋᐦᑣᐎᒡ ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓵᒋᐦᐄᑯᒡ ᓵᒋᐦᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ᒑᒀᓐ ᐋ ᓈᔥᒡ ᒋᐱᐦ ᐃᓯᓈᑯᓐ ᒥᒄ ᒥᔪᑑᑑᑣᐤ ᐊᓂᒌ ᑳ ᒥᔪᑐᑖᔅᒡ? ᐙᔥ ᐊᔮᐱᒡ ᐋᔪᐎᒄ ᐋᐦ ᑎᒡ ᐅᒥᒋᐦᑣᐎᒡ, ᒥᔪᑐᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᔪᑐᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ᒑᒀᓐ ᐋ ᓈᔥᒡ ᒋᐱᐦ ᐃᓯᓈᑯᓐ ᒥᒄ ᐊᓂᒌ ᐊᐅᐦᐄᑣᐤ ᒑᒀᔨᐤ, ᐊᓂᒌ ᐋ ᐱᑯᓵᔨᒥᑣᐤ ᒦᓐ ᒑ ᒌ ᒌᐙᒥᔨᔅᒡ? ᐙᔥ ᐋᔪᐎᒄ ᐋᐦ ᑎᒡ ᐅᒥᒋᐦᑣᐎᒡ ᐊᐅᐦᐄᑑᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᒑᒀᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᐄᑖᔨᐦᑎᒧᒡ ᒦᓐ ᑳᐤ ᒑ ᒌ ᒌᐙᐊᔮᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᐅᐦᐋᓱᒫᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ᒫᐅᑖ ᒋᐱᐦ ᑎᓐ, ᒋᐱᐦ ᓵᒋᐦᐋᐅᒡ ᐊᓂᒌ ᑳ ᒥᒑᔨᒥᔅᒡ, ᑭᔮᐦ ᒋᐱᐦ ᒥᔪᑐᑎᐙᐅᒡ, ᒋᐱᐦ ᒥᔮᐅᒡ ᑭᔮᐦ ᒑᒀᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᔅᒡ᙮ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐱᑯᓵᔨᐦᑖᓐ ᒦᓐ ᒑ ᒌ ᒌᐙᒦᑭᐎᔨᓐ ᒑᒀᓐ, ᒑ ᒥᔖᒡ ᒫᒃ ᒌ ᑎᐱᐦᐊᒫᑯᓰᐎᓐ᙮ ᑭᔮᐦ ᒫᒃ ᐆ ᑐᑎᒥᓈ ᒋᑭ ᓅᑯᓐ ᐋ ᐅᑎᐙᔑᔒᒥᑐᑖᔅᒃ ᒋᔖᒥᓂᑑ, ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ᙮ ᐙᔥ ᒥᔪᑐᑎᐙᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐋᑎ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᓂᓈᔅᑯᒧᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒥᒋᐦᑣᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ᒋᔅᑎᒫᒑᔨᒧᐙ ᑭᔮᐦ ᒌᔨ ᒧᔮᒻ ᑰᐦᑖᐐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᐋ ᐃᔥᐱᔥ ᒋᔅᑎᒫᒑᔨᒧᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“ᐊᑳᐐ ᑎᐹᔅᑯᓂᒑᒄ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᑎᐹᔅᑯᓂᑯᐙᐤ ᒋᔖᒥᓂᑑ᙮ ᐊᑳᐐ ᓂᔑᐎᓈᒋᒧᐙᒄ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᔑᐎᓈᒋᒥᑯᐙᐤ ᒋᔖᒥᓂᑑ᙮ ᐙᐹᔨᐦᑎᒫᒑᒄ ᐋᒄ ᒫᒃ ᑭᔮᐦ ᒌᔨᐙᐤ ᒑ ᐙᐹᔨᐦᑎᒫᑖᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ᒥᔨᐙᒄ, ᐋᒄ ᒫᒃ ᒑ ᒌᐙᒥᔨᑯᐎᔮᒄ᙮ ᒥᔥᑏᐦ ᒋᑭ ᒥᔨᑯᓈᐙᐤ᙮ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᔨᐙᑦ ᐊᐙᓐ ᒑᒀᔨᐤ ᐋᔪᐎᒄ ᒧᔮᒻ ᒑ ᐃᔥᐱᔥ ᒥᔮᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ᒌᓴᔅ ᒫᒃ ᒌ ᐐᐦᑎᒧᐙᐤ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᐋᐦᐋᑳ ᐙᐱᐦᑎᐦᒃ ᐊᐙᓐ ᒋᑭ ᒌ ᐋ ᒋᔅᒋᓄᐦᑎᐦᐋᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ? ᓂᒧᐃ ᑭᔨᑆ᙮ ᐙᔥ ᑖᐱᔥᑯᓐ ᒋᑭ ᐴᐦᒋᐱᔫᒡ ᐋ ᐙᔮᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ᐊᓐ ᑳ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓅᑦ ᐊᐙᓐ ᓂᒧᐃ ᐐᔨ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᒋᓄᐦᐊᒫᑯᑦ᙮ ᐙᔥ ᐄᔥᐱᐦ ᒌᔥ ᒋᔅᑯᑎᒧᐙᑭᓅᒑ ᐋᔪᐎᒄ ᒑ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᒋᓄᐦᐊᒫᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᓈᓈᑭᑐᐙᔨᐦᑎᒧᑦ ᒌᒋᔖᓐ ᐋ ᐊᐱᔖᔑᔨᒡ ᐅᐱᓯᓂᐎᓐ ᐋᐦᐋᑳ ᒫᒃ ᓈᓈᑭᑐᐙᔨᐦᑎᒥᐦᐄᑯᔨᓐ ᒌ ᐋᐱᔑᓃᔨᓐ ᐋ ᒥᐦᒑᔅᑯᐦᒡ ᒥᔥᑎᒄ? ");
INSERT INTO crl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐄᑎᑦ ᒌᒋᔖᓐ? ‘ᓂᑭ ᐱᐦᑯᐦᑖᓐ ᒋᐱᔑᓂᐎᓐ’, ᐋᐦᐋᑳ ᒫᒃ ᐙᐙᒡ ᒋᐙᐱᐦᑎᒥᓐ ᐊᓐ ᑳ ᒥᐦᒑᔅᑯᐦᒡ ᒥᔥᑎᒄ ᐊᓂᑖᐦ ᒌᔨ ᒋᔅᒌᓯᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ᙮ ᒋᑎᐄᑖᔨᒫᐅᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐄᑖᔨᒥᔅᒡ ᐋ ᑯᐃᔅᑯᑖᑎᓯᔨᓐ ᐋᐦᐋᑳ ᒫᒃ ᑯᐃᔅᑯᑖᑎᓯᔨᓐ᙮ ᒌᔨ ᑳ ᐊᔨᒥᐦᐋᑳᓱᔨᓐ, ᓃᔥᑎᒻ ᐱᐦᑯᐦᑖᐦ ᐊᓐ ᑳ ᒥᐦᒑᔅᑯᐦᒡ ᒥᔥᑎᒄ ᒋᔅᒌᓯᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᐋᒄ ᒫᒃ ᒑ ᓂᐦᐋᐱᔨᓐ᙮ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐱᐦᑯᐦᑖᐅᑦ ᒌᒋᔖᓐ ᐅᐱᓯᓂᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“ᐙᔥ ᒥᔪᒥᓈᐦᑎᑯᐦᒡ ᓂᒧᐃ ᓂᐦᑖᐅᒋᓐ ᐊᓂᑎᐦ ᒥᒋᒥᓐ, ᑭᔮᐦ ᒫᒃ ᒥᔥᑎᒄ ᐋᐦᐋᑳ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᑖᐅᒋᓂᔨᐤ ᐋ ᒥᔻᔒᔨᒡ ᒦᓂᔥ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᓂᐦᑖᐅᒋᐦᑖᑦ ᒥᔥᑎᒄ ᒦᓂᔥ ᐋᑯᑖᐦ ᐙᐦᒋ ᓂᓯᑑᓄᐙᑭᓅᑦ ᑖᓐ ᐋ ᐃᑖᐦᑎᑯᐎᑦ᙮ ᒧᔮᒻ ᐄᔨᒥᓐᐦ ᓂᒧᐃ ᓂᐦᑖᐅᒋᓐ ᐋ ᑳᔓᑖᐙᔥᑰᐦᒡ ᒥᔥᑯᔒᐤ ᑭᔮᐦ ᒫᒃ ᑳ ᐊᔨᓰᒧᓯᒡ ᓂᒧᐃ ᓂᐦᑖᐅᒋᓐ ᐙᒋᓈᑭᓈᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ᐙᔥ ᐊᐙᓐ ᑳ ᑯᐃᔅᑯᑖᑎᓰᑦ, ᑖᓐ ᐋ ᐄᔑ ᒥᔪ ᐃᔮᑦ ᐅᑖᐦᐄᐦᒡ ᑭᑎ ᒋᔅᒑᔨᐦᑖᑯᓂᔨᐤ ᐅᐱᒫᑎᓰᐎᓂᐦᒡ, ᐋᒄ ᒫᒃ ᐊᐙᓐ ᐋ ᒥᒑᑎᓰᑦ, ᑖᓐ ᐋ ᐄᔑ ᒫᔮᒡ ᐃᔮᑦ ᐅᑖᐦᐄᐦᒡ ᑭᑎ ᒋᔅᒑᔨᐦᑖᑯᓂᔨᐤ ᐅᐱᒫᑎᓰᐎᓂᐦᒡ᙮ ᐙᔥ ᐋ ᐄᔑ ᐊᔨᒥᑦ ᐊᐙᓐ ᐋᑯᑖᐦ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᓯᑦ ᑖᓐ ᐋ ᐄᔑ ᑖᐦᐋᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐃᔑᓂᐦᑳᓱᔮᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐋᐦᐋᑳ ᒫᒃ ᐄᐦᑐᑎᒫᒄ ᐊᓐ ᑳᐦ ᐄᑎᑯᒡ ᒑᐦ ᑐᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ᐋᒄ ᒫᒃ ᒑ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓐ ᐋ ᐃᓯᓈᑯᓯᑦ ᐊᐙᓐ ᑳ ᐹᒋ ᓈᔑᑦ ᑭᔮᐦ ᑳ ᓂᑐᐦᑎᐦᒃ ᑖᓐ ᐋᐦ ᐃᔨᐅᒡ, ᐋᐦ ᑐᑎᐦᒃ ᒫᒃ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᐋᐦ ᐄᑎᒄ᙮ ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐙᔨᐤᐦ ᓈᔅᐱᑐᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ᒧᔮᒻ ᐊᐙᓐ ᐋ ᐐᐦ ᐐᔨᑳᐳᐦᑖᑦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᓃᔥᑎᒻ ᐄᑖᒥᐦᒡ ᐄᔑ ᒨᓂᐦᐄᒑᐤ, ᐹᑎᒫ ᐙᑎᐦᑎᐦᐊᒃ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐎᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐹᐦᐹᐦᒋᐱᔅᑳᔨᒡ ᐙᔨᑳᐳᐦᑖᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᐙᑎᐦᒋᐳᑖᔨᒡ ᐊᓂᑎᐦ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ, ᓂᒧᐃ ᓈᔥᑎᔨᒡ ᒋᑭ ᐅᐦᒋ ᐋᐦᒋᑳᐳᔨᐤ, ᐙᔥ ᓈᔥᑖᑆᐦ ᒌ ᒥᔪ ᔮᐃᒋᑳᐳᐦᑖᐤ᙮ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᑦ ᐊᐙᓐ ᑳ ᐱᔑᒋᐦᑎᒸᑦ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ᐊᐙᓐ ᒫᒃ ᑳ ᓂᑐᐦᑎᐦᒃ ᐋᐦ ᐃᔨᐅᒡ ᐋᐦᐋᑳ ᒫᒃ ᑐᑎᐦᒃ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᑦ ᒧᔮᒻ ᐊᐙᓐ ᒧᔅᑎᔅᑭᒥᒡ ᑳ ᐐᔨᑳᐳᐦᑖᑦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐋᐦᐋᑳ ᐱᑎᒫ ᐅᔑᐦᑖᑦ ᐋᐦ ᐋᐃᑎᓃᔨᒡ ᐊᓂᑎᐦ ᒑ ᒋᒥᑖᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐳᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ, ᑏᐙᐦᒡ ᑭᐅᐱᔨᐤ ᐋᒄ ᒫᒃ ᒥᑐᓐ ᓈᔅᑏᔨᒡ ᔮᔮᔪᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ᙮ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᑦ ᐊᐙᓐ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑎᒸᑦ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᒌᔥ ᐋᔨᒧᑎᐦᒃ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᐋ ᐹᐦᑖᑯᑦ ᐄᔨᔨᐤᐦ ᐋᒄ ᑳ ᑎᑯᔑᐦᒃ ᐊᓂᑎᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᐹᔨᒄ ᓂᑐᐱᔫᒋᒫᐤ ᓈᔥᒡ ᐋ ᒌ ᓵᒋᐦᐋᑦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ᙮ ᒫᒀᒡ ᒫᒃ ᓈᔥᒡ ᒌ ᐋᐦᑯᓯᔨᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ ᒑᑳᑦ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ᐋᒄ ᒫᒃ ᐆ ᓂᑐᐱᔫᒋᒫᐤ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐦᒃ ᑖᓐ ᐋᐦ ᐄᑖᒋᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᒌ ᐄᑎᔑᐦᐙᐤ ᒎᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᓂᑐᑎᒧᐙᔨᒡ ᒑ ᒌ ᐹᒋ ᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ᐄᔥᐱᐦ ᒫᒃ ᐅᒌ ᓈᐹᐅᒡ ᐙᑎᐦᑖᒡ ᒌᓴᔅᐦ ᓈᔥᑖᑆᐦ ᓲᐦᒃ ᒌ ᒌᔒᐦᒋᒫᐅᒡ ᒑ ᒌᐦ ᑐᑎᒥᔨᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᑖᒡ, “ᓈᔥᑖᑆᐦ ᓲᐦᒃ ᐱᑯᓵᔨᐦᑎᒻ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ ᐆ ᓂᑐᐱᔫᒋᒫᐤᐦ᙮ ᐄᑖᔨᐦᑖᑯᓲ ᒫᒃ ᒑ ᒌᐦ ᑐᑎᒧᐙᑭᓅᑦ ᐅᔮᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ᐙᔥ ᓵᒋᐦᐋᐤ ᓂᑎᐄᔨᔨᒥᓈᓐ ᑭᔮᐦ ᓂᒌ ᐅᔑᐦᑣᑯᓈᓐ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᒑᐙᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᔣᐱᐦᑎᒸᒡ ᐊᓂᔮᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᐤ ᐋᒄ ᐊᓐ ᓂᑐᐱᔫᒋᒫᐤ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐅᐐᒑᐙᑭᓐᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐃᑖᔨᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐊᑳᐐ ᐅᑎᒥᐦᐄᓲ, ᐙᔥ ᓂᒧᐃ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᐹᒋ ᐲᐦᒑᔨᓐ ᓂᐙᔅᑳᐦᐄᑭᓂᒥᒡ, ");
INSERT INTO crl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᓂᑑᓂᒋᔥᑳᑖᓐ᙮ ᐃᔨᐦ ᒫᒃ ᒑ ᒦᓂᐙᑎᓰᑦ ᓂᑖᐱᒋᐦᐋᑭᓐ ᒑᔅᑎᓈᔅ ᒑ ᒦᓂᐙᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ᐙᔥ ᑭᔮᐦ ᓃᔨ ᑖᐅᒡ ᓅᒋᒫᒥᒡ ᐋ ᐱᔑᒋᐦᐄᒀᐤ ᑭᔮᐦ ᒫᒃ ᑖᐅᒡ ᓂᑐᐱᔫᒡ ᐋ ᐎᔨᔓᒥᒀᐤ᙮ ᐋᐦ ᐄᑎᒄ ᐹᔨᒄ ᓂᑐᐱᔨᐤ ‘ᐊᓂᑖᐦ ᐄᑐᐦᑖᐦ,’ ᑏᐙᐦᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᐋᑐᐦᑖᑦ᙮ ᐋᒄ ᑯᑎᒃ ᐋᐦ ᐄᑎᒄ, ‘ᐋᔥᑎᒻ,’ ᑏᐙᐦᒡ ᑎᑯᔑᓐ᙮ ᐋᒄ ᑭᔮᐦ ᑯᑎᒃ ᐋᐦ ᐄᑎᒄ ᓂᑖᐱᒋᐦᐋᑭᓐ, ‘ᐆ ᒫᐦ ᑐᑎᐦ,’ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐋᑑᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ᐄᔥᐱᐦ ᒌᓴᔅ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᓈᔥᑖᑆᐦ ᒌ ᒫᒥᐦᒋᐦᐄᑯᐙᐤ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤᐦ᙮ ᐋᒄ ᑳ ᒀᔅᒋᑳᐳᔥᑎᐙᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓅᔔᔥᑳᑯᑦ ᑳᐦ ᐄᑖᑦ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᐙᐙᒡ ᐋᔥᒄ ᓅᐦᒋ ᐙᐱᒫᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐋ ᐃᔥᐱᔥ ᓲᐦᒋᑖᑆᔮᔨᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᑳᐤ ᑳ ᒌᐙᒡ ᐊᓂᒌ ᑳ ᐄᑎᔑᐦᐙᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ, ᒌ ᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐋᐱᒋᐦᐋᑭᓐᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐋ ᒥᔪᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ᐹᑎᒫ ᒫᒃ ᒌᓴᔅ ᒌ ᐄᑐᐦᑖᐤ ᐃᐦᑖᐎᓂᐦᒡ ᓀᐃᓐ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐐᒑᐅᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ᐄᔥᐱᐦ ᑳ ᐅᑎᐦᑎᐦᒡ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᓂᒋᔥᑭᐙᐅᒡ ᐄᔨᔨᐤᐦ ᐋ ᐅᐦᒋ ᐱᒧᐦᑎᐦᐋᔨᒡ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᓈᐹᐤᐦ, ᒑ ᓂᑑᓂᐦᐄᑭᐙᔨᒡ᙮ ᐅᑳᐐᐦ ᒫᒃ ᐊᓐ ᓈᐹᐤᐦ ᒌ ᐹᔨᑯᔨᐤ᙮ ᒥᒄ ᐋ ᒌ ᐹᔨᑯᔒᑯᐱᓈᓂᐦᐄ ᐅᑯᓯᔅᐦ ᐊᓐ ᑳ ᒋᔅᑎᒫᑎᓯᑦ ᐃᔅᒀᐤ᙮ ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᐐᒑᐅᑯᑦ ᐋ ᓂᑑᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ᐄᔥᐱᐦ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, ᓈᔥᒡ ᒌ ᒋᔅᑎᒫᒑᔨᒫᐤ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᒫᑑᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ᒌ ᓈᑎᒻ ᐊᓂᔮᔨᐤ ᑖᐦᑎᓂᑭᓂᔨᐤ ᑳ ᑖᐦᒋᓂᐦᒃ, ᐋᒄ ᐊᓂᒌ ᑳ ᑎᐦᑯᓂᐦᒡ ᐊᓂᔮᔨᐤ ᑖᐦᑎᓂᑭᓂᔨᐤ ᒌ ᒋᐱᐦᒋᑳᐳᐎᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᐎᓂᔥᑳᐦ ᐅᔅᒋᓃᒋᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ᐋᒄ ᐊᓐ ᑳ ᐳᓂᐱᒫᑎᓰᑦ ᓈᐹᐤ ᑳ ᐅᐦᒋ ᓯᒥᑎᐱᑦ, ᑳ ᐅᐦᒋ ᐋᔮᔨᒸᑦ, ᐋᒄ ᒌᓴᔅ ᑳᐤ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᐊᓂᔮᔨᐤᐦ ᐅᑯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ᒥᓯᐙ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐃᑎᔑᒡ ᐄᔨᔨᐅᒡ ᒌ ᓵᒋᓯᐎᒡ ᐋᒄ ᑳ ᒋᔅᑖᒋᒫᒡ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑᐦ ᐋᐦ ᐃᔨᒡ, “ᒋᒌ ᐅᑎᐦᑎᑯᓂᐤ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ᑭᔮᐦ ᒫᒃ ᒌ ᐃᔨᐅᒡ, ᒋᔖᒥᓂᑑ ᐹᒋ ᐐᒋᐦᐋᐤ ᐅᑎᔨᔨᒻᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ᒥᓯᐙ ᒫᒃ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᒎᑏᔮ ᐊᔅᒌᔨᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐙᔅᑳ ᒌ ᐹᐦᑖᑯᓂᔨᐤ ᒌᓴᔅ ᑖᓐ ᑳᐦ ᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐐᐦᑎᒫᑰ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᔨᒡ ᒌᓴᔅᐦ᙮ ᐋᒄ ᒞᓐ ᑳ ᓂᑑᒫᑦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐊᓂᑖᐦ ᐅᔮᔨᐤ ᒑ ᒌ ᐄᔑ ᑯᒀᒋᒫᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᐋᐤ ᐋ ᒌᔨ ᙭ ᐊᓐ ᒑ ᑎᑯᔑᓂᑯᐱᓈ ᑭᔮᐦ ᒫᒃ ᐋᔥᒄ ᒑ ᐊᔑᓂᐙᐦᐋᐅᒋᒑ ᑯᑎᒃ ᐊᐙᓐ ᒑ ᑎᑯᔑᐦᒃ?” ");
INSERT INTO crl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᐙᑎᐦᑖᒡ ᒌᓴᔅᐦ ᒌ ᐄᑖᐅᒡ, “ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᓂ ᐹᒋ ᐄᑎᔑᐦᐅᑯᓈᓐ ᒑ ᒌ ᑯᒀᒋᒥᑖᐦᒡ, ᐋᐤ ᐋ ᒌᔨ ᙭ ᐊᓐ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓄᑯᐱᓈ ᑭᔮᐦ ᒫᒃ ᐋᔥᒄ ᒑ ᐊᔑᓂᐙᐦᐋᐅᒋᒑ ᒑ ᑎᑯᔑᐦᒃ?” ");
INSERT INTO crl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ, ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑖᔅᐱᓈᔨᒡ, ᑭᔮᐦ ᒥᒋᐊᐦᒑᐦᒄᐦ ᐋ ᒌ ᐎᔨᐐᑎᔑᐦᐙᑦ ᑭᔮᐦ ᐋ ᒌᐦ ᑐᑎᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ᐋᒄ ᒌᓴᔅ ᐋ ᓂᔥᒀᐅᔑᐦᐋᑦ ᒌᐦ ᐄᑖᐤ, “ᒌᐙᒄ, ᒑ ᐐᐦᑎᒧᐙᒄ ᒞᓐ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᒫᒄ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᒄ᙮ ᐐᐦᑎᒧᐙᐦᒄ ᐋ ᐙᐱᐦᑎᒥᔨᒡᐦ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᐅᐦᒌ ᐙᐱᐦᑎᒥᔨᒡ, ᐋ ᐱᒧᐦᑖᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᐅᐦᒌ ᐱᒧᐦᑖᔨᒡ, ᑭᔮᐦ ᒫᒃ ᐋ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᐃᔮᔨᒡ ᐋ ᒫᔮᑎᓃᔨᒡ ᐋ ᐅᒥᒌᓈᓂᐎᔨᒡ᙮ ᑭᔮᐦ ᐋ ᐹᐦᑎᒥᔨᒡᐦ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᐅᐦᒌ ᐹᐦᑎᒥᔨᒡ᙮ ᑭᔮᐦ ᒦᓐ ᑳᐤ ᐋ ᐎᓂᔥᑳᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᑭᔮᐦ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋ ᐙᐐᐦᑎᒫᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᒑ ᐋᑎᐙᔨᒥᒀ ᐋᐦᐋᑳ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᒞᓐ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᔨᒨᒫᑦ ᒞᓐᐦ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐋᐦ ᐃᔨᑦ, “ᐊᐙᓐ ᑳ ᐄᑖᔨᒫᒄ ᒑ ᐙᐱᒫᒄ ᐄᔥᐱᐦ ᑳ ᓂᑎᐙᐱᒫᒄ ᒞᓐ ᓈᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ? ᒧᔮᒻ ᒥᔥᑯᔒ ᒥᒄ ᐊᓂᑖᐦ ᐋ ᐄᔑ ᔪᐙᒡ ᐋ ᐄᔑ ᓂᐙᔮᔥᑎᐦᒡ ᐋᔪᐎᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᐙᓐ ᓈᔥᒡ ᐋ ᓂᐦᐄᔖᑰᒋᒫᑭᓅᑦ᙮ ᓂᒥᔮᐙ ᑳ ᐄᑖᔨᒫᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ᐊᐙᓐ ᒫᒃ ᑳ ᐄᑖᔨᒫᒄ ᒑ ᐙᐱᒫᒄ? ᓂᒧᐃ ᓈᓂᑐ ᐐᔨ ᐊᐙᓐ ᐋ ᒥᔻᔥᐱᓱᑦ᙮ ᐙᔥ ᐊᓂᒌ ᑳ ᒥᔻᔥᐱᓱᒡ ᓈᔥᑖᑆᐦ ᐙᔫᑎᓰᐎᒡ, ᐊᓂᑖᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᐋᑯᑖᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ᐊᐙᓐ ᒫᒃ ᐆ ᐊᓂᑖᐦ ᑳ ᓂᑎᐙᐱᒫᒄ? ᐊᐙᓐ ᐋ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ? ᐋᐦᐋ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐋᐅᒄ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒞᓐ, ᐐᔨ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐ ᑯᑎᒃ ᐊᐙᓐ ᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ᐋᐅᒄ ᐆ ᒞᓐ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ᓂᑭ ᓃᑳᓂᑎᔑᐦᐙᐤ ᐊᐙᓐ ᒑ ᒌ ᐃᔮᔅᑭᐐᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑖᐅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑎᐦᑐ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᓂᒧᐃ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ᙮ ᐊᔮᐱᒡ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᒫᐅᒡ ᓅᐦᑖᔮᔥ ᑳ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑᐦ ᐆᒋᐦᒋᐅᒋᒫᐎᓃᔨᐦᒡ ᐊᐅᔅᑖ ᐐᔨ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐᔨ ᒞᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᓂᑑᐦᑖᑰ ᒌᓴᔅ ᐙᐙᒡ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᒥᒑᑎᓯᐎᒡ ᑳ ᐄᑖᔨᒫᑭᓂᐎᒡ, ᐊᓂᔮᔨᐤ ᑭᔨᑆ ᐋ ᒫᒨᔑᒋᓈᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᑳ ᓂᓂᐦᐄᐦᑎᒧᐙᑯᐱᓈ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ, ᒌ ᓰᑭᐦᐋᐦᑖᑯᑖᐙᑯᐱᓐ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᐋᑎᐙᔨᐦᑎᒸᐅᒡ ᐊᓂᔮᔨᐤᐦ ᑳᐦ ᐄᑎᔓᐙᔨᒡ ᒋᔖᒥᓂᑑᐦ᙮ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒧᒡ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑯᒡ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ᐋᒄ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ᒫᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ᒧᔮᒻ ᐊᐙᔑᔑᒡ ᐊᓂᑖᐦ ᐋ ᒫᑎᐙᒡ ᐎᔨᐐᑎᒥᐦᒡ ᐋᐦᐋᑳ ᒫᒃ ᒌ ᓂᓂᐦᐄᐙᐦᐄᑐᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᒫᑎᐙᒡ᙮ ᐋ ᑖᑆᑐᒡ, ᐋᐦ ᐃᔨᒡ, ‘ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᒡ ᓂᒌ ᐐᐦ ᐄᔑ ᒫᑎᐙᓈᓐ ᐋ ᒋᔅᑐᐦᒑᔮᐦᒡ ᐋᐦ ᑎᔮᐦᒡ, ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᓃᒥᓈᐙᐤ, ᑭᔮᐦ ᓂᒌ ᓂᑭᒧᓈᓐ ᐋ ᒋᔅᑎᒫᓯᑖᑯᐦᒡ ᓂᑭᒧᐎᓐ ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᒫᑑᓈᐙᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ᐄᔥᐱᐦ ᒫᒃ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᑳ ᑎᑯᔑᐦᒃ ᓂᒧᐃ ᐋᔑᑯᒻ ᐅᐦᒋ ᒦᒋᓲ, ᓂᒧᐃ ᑭᔮᐦ ᐅᐦᒋ ᒥᓂᐦᒀᐤ ᔔᒥᓈᐴᔨᐤ, ᒋᒌ ᐄᑖᐙᐤ ᒫᒃ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᐦᒋᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ᒌ ᐹᒋ ᑎᑯᔑᓐ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᒦᒋᓱᑦ ᑭᔮᐦ ᐋ ᒥᓂᐦᒀᑦ᙮ ᒋᒌ ᐃᔨᓈᐙᐤ ᒫᒃ, ‘ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ ᐆ ᓈᐹᐤ, ᓄᐎᒡ ᐋᔥᐳᓂᓯᐤ ᑭᔮᐦ ᓄᐎᒡ ᐐᐦᒋᐹᐤ, ᐋ ᐅᐐᒑᐙᑭᓂᑦ ᐅᒥᒑᑎᓯᔨᐤᐦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐋ ᒫᒨᔑᒋᓈᔨᒡ ᒋᐦᒋᐅᒋᒫᐤᐦ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡᐦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᒸᒡ ᒋᔖᒥᓂᑑ ᐅᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ ᑭᑎ ᓅᑯᐦᑖᐅᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ ᑖᑆᐦ ᐋ ᒑᔥᑎᓈᑖᔮᔨᐦᑖᑯᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ᒌᓴᔅ ᐹᔨᒀᐤ ᒌ ᓂᑑᒥᑰ ᐹᕆᓰᐦ ᓵᐃᒥᓐᐦ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᒑ ᒌ ᐐᒋᒦᒋᓲᒫᑦ, ᐋᒄ ᒫᒃ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᐋᒄ ᑳ ᐅᐙᔨᐱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ᐊᓂᑎᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒌᐦ ᑖᐤ ᐃᔅᒀᐤ ᓈᔥᒡ ᐋ ᒥᒑᑎᓰᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᐃᔅᒀᐤ ᐱᔮᐦᑎᐦᒃ ᒌᓴᔅᐦ ᐋ ᒌ ᓂᑐᒫᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ ᐐᒋᔨᐦᒡ ᒑ ᒌ ᒦᒋᓱᔨᒡ, ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ, ᐋ ᒌ ᐄᑐᐦᑖᑦ ᓈᔥᒡ ᐋ ᒥᔻᔒᔨᒡ ᐱᔻᐱᔅᑯᔮᑭᓂᔨᐤ ᐋ ᐊᓯᓃᐎᔨᒡ, ᐋ ᒥᔪᒫᑯᓃᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ ᐋ ᐲᐦᒋᔥᑎᓃᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋ ᐅᐦᐱᒫᔑᐦᒃ ᐊᓂᑎᐦ ᐋ ᒦᒋᓱᒡ, ᐊᓐ ᐃᔅᒀᐤ ᒌ ᓃᐴ ᐊᓂᑖᐦ ᐄᑖᐦᒑ ᒌᓴᔅᐦ ᐅᓯᑎᔨᒡ, ᐋ ᒫᑑᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐅᐦᒋᑯᐙᐱᑦ ᒌ ᓂᐱᐅᑖᐙᐤ ᒌᓴᔅᐦ ᐅᓯᑎᔨᐤᐦ᙮ ᐋᒄ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᑦ ᐅᔥᑎᒀᓂᐲᐐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᐹᐦᑯᓯᑖᓈᑦ᙮ ᑭᔮᐦ ᐋ ᐅᒑᐦᑎᒸᑦ ᑭᔮᐦ ᐋ ᑑᒥᓂᒸᑦ ᐊᓂᔮᔨᐤ ᐋ ᒥᔪᒫᑯᓃᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ᐊᓐ ᒫᒃ ᐹᕆᓰ ᑳ ᓂᑑᒫᑦ ᒌᓴᔅᐦ, ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᐊᓂᔮᔨᐤ ᐋ ᐄᔨᐦᑎᔨᒡ ᒌ ᐄᑖᔨᒫᐤ, “ᒋᐱᐦ ᒋᔅᒑᔨᒫᐤ ᐅᔮᔨᐤ ᐃᔅᒀᐤ ᐋ ᐃᔥᐱᔥ ᒥᒑᑎᓰᔨᒡ ᑳ ᑖᐦᒋᓂᑯᑦ ᑖᑆᐦ ᒑᔅᒋᐙᐦᐄᒑᓯᐅᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ᒌᓴᔅᐦ ᑳ ᐊᔨᒥᐦᐄᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᓵᐃᒥᓐ, ᒋᐐᐦ ᐄᑎᑎᓐ ᒑᒀᓐ᙮” ᓵᐃᒥᓐ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐹᒋ ᐐᐦᑎᒨ ᐊᓐ ᒑᒀᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ᐋᒄ ᒌᓴᔅ ᑳ ᑎᐹᒋᒧᔥᑐᐙᑦ ᐋᐦ ᐄᑖᑦ, “ᒌ ᓃᔔᒡ ᓈᐹᐅᒡ ᐋ ᒌ ᐊᐅᐦᐋᔓᒫᒡ ᓈᐹᐤᐦ ᔓᐎᔮᓐ᙮ ᐹᔨᒄ ᐊᓐ ᓂᔮᔻᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᐊᐅᐦᐋᔓᒫᐤ, ᐋᒄ ᐊᓐ ᑯᑎᒃ ᓂᔮᔫᒥᑎᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᒋᐙᑎᐱᐦᐋᒫᐦᒄ ᑖᐱᔥᑯᓐ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, ᐋᒄ ᑳ ᑳᓰᓯᓂᐦᐊᒸᑦ ᐊᓂᔮᔨᐤ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᒋᐙᑎᐱᐦᐋᒫᑯᑯᐱᓈ᙮ ᑖᓂᔮᔨᐤ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᓃᔑᔨᒡ ᓈᐹᐤ ᐊᑎᑎᐤ ᒑ ᓵᒋᐦᐄᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ᓵᐃᒥᓐ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑭᔨᑆ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᒥᔥᑏᐦ ᑳ ᐊᐅᐦᐋᔓᒥᑯᑦ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᒑ ᓵᒋᐦᐄᑯᑦ᙮” ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ, ᑖᑆᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᑳ ᑭᓂᐙᐱᒫᑦ ᒌᓴᔅ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ, “ᒌ ᐙᐱᒫᐤ ᐋ ᐆ ᐃᔅᒀᐤ ᑖᓐ ᐋ ᑎᒃ? ᑳ ᐹᒋ ᐲᐦᒑᔮᓐ ᐅᑎᐦ ᒌᒋᐦᒡ ᓂᒧᐃ ᐙᐙᒡ ᑰᐦᒋ ᐹᒋ ᒥᔨᓐ ᓂᐲ ᒑ ᒌ ᒋᔥᑖᐹᐅᑖᔮᓐ ᓂᓯᑦ᙮ ᐐᔨ ᒫᒃ ᒌ ᒋᔥᑖᐹᐅᑖᐤ ᓂᓯᑦ ᐋ ᐅᐦᒋᑭᐙᐱᑦ ᐅᐦᒋ, ᑭᔮᐦ ᒌ ᐹᐦᑯᐦᐊᒻ ᓂᓯᑦ ᐅᔥᑎᒀᓂᐲᐐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ᑳ ᐹᒋ ᐲᐦᒑᔮᓐ ᐅᑎᐦ ᓂᒧᐃ ᑰᐦᒋ ᐹᒋ ᐙᒋᔮᒥᓐ ᐋ ᐹᒋ ᐅᒑᒥᓐ, ᐐᔨ ᒫᒃ ᓂᒧᐃ ᐋᔥᒄ ᐅᐦᒋ ᐴᓃᐤ ᐋ ᐅᒑᐦᑎᐦᒃ ᓂᓯᑦ ᑳ ᐃᔥᐱᔥ ᐹᒋ ᐲᐦᒑᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ᓂᒧᐃ ᑭᔮᐦ ᑰᐦᒋ ᑑᒥᔅᑯᓈᓐ ᓂᔅᑎᒀᓐ, ᐐᔨ ᒫᒃ ᒌ ᐹᒋ ᑑᒥᓂᒻ ᓂᓯᑦ ᐋ ᒥᔪᒫᑯᓃᔨᒡ ᑑᒥᓂᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ᒋᐐᐦᑎᒫᑎᓐ, ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᐋ ᓵᒋᐦᐄᐙᑦ ᐋᑯᑖᐦ ᐙᐦᒋ ᓅᑯᓃᔨᒡ ᒥᐦᒑᑐ ᒥᒋᐦᑣᐎᓐ ᐋ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓅᑦ᙮ ᐊᐙᓐ ᐊᐱᔒᔥ ᑳ ᐙᐹᔨᐦᑎᒧᐙᑭᓅᑦ ᐊᐱᔒᔥ ᓵᒋᐦᐄᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, “ᒌ ᐙᐹᔨᐦᑎᒫᑭᐎᓐ ᒋᒥᒋᐦᑣᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ᐊᓂᒌ ᒫᒃ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳ ᐊᐱᐎᒡ, ᒌ ᒫᒥᑐᓈᔨᐦᑎᒧᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᑎᑐᒡ, “ᒑᒄ ᓈᐹᐤ ᐆ ᐙᐙᒡ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᒑᑦ ᒥᒋᐦᑣᐎᓐᐦ?” ");
INSERT INTO crl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, “ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒋᐱᒫᒋᐦᐄᑯᓐ᙮ ᒫᒌᐦ ᒫᒃ, ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒑ ᐃᔮᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔑᐱᔨᔨᒡ ᐅᔮᔨᐤ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐙᐐᐦᑎᐦᒃ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋ ᑎᐹᑐᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᒑ ᐅᑎᐦᒋᐱᔨᔨᒡ᙮ ᒌ ᐐᒑᐅᑰ ᐊᓂᔮᔨᐤᐦ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ᐃᔅᒀᐅᒡ ᑭᔮᐦ ᒌ ᐱᐹᐐᒑᐙᐅᒡ, ᐊᓂᒌ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐎᔨᐐᑎᔑᐦᐅᒫᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ ᐅᐦᒋ᙮ ᑭᔮᐦ ᐊᓂᒌ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ ᓂᓈᐦᑭᐤ ᐄᑖᔅᐱᓈᐎᓐ ᐅᐦᒋ᙮ ᐋᐅᒄ ᐹᔨᒄ ᒣᕇ ᒫᒃᑖᓖᓐ, ᐊᓐ ᐃᔅᒀᐤ ᓃᔣᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᐎᔨᐐᑎᔑᐦᐅᒫᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ᑭᔮᐦ ᒍᐙᓈ ᒌ ᐐᒋᐦᐄᐙᐤ᙮ ᐆ ᐃᔅᒀᐤ ᒍᓵᐦ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᓈᐹᒻᐦ, ᒌ ᐅᒋᒫᐤᐦ ᐋᐱᑎᓰᔨᐤ, ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᒌ ᐋᐱᑎᔒᔥᑑᐙᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᓱᓵᓈ ᒌ ᐐᒋᐦᐄᐙᐤ᙮ ᒥᐦᒑᑐ ᒫᒃ ᒦᓐ ᑯᑎᑭᒡ ᐃᔅᒀᐅᒡ ᒌ ᐐᒑᐙᐅᒡ ᒌᓴᔅᐦ᙮ ᑎᐱᔨᐙ ᒫᒃ ᐅᔓᐎᔮᓂᒧᐙᐤ ᒌ ᐋᐱᒋᐦᐋᐅᒡ ᐅᒌ ᐃᔅᒀᐅᒡ ᐋ ᐐᒋᐦᐋᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᒌ ᐅᐦᑐᐦᑖᔨᒡ ᒌ ᐹᒋ ᓂᔥᑐᐎᔨᐤ ᒑ ᒌ ᓂᑑᐦᑖᑯᑦ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“ᐹᔨᒀᐤ ᒌᐦ ᑖᐤ ᓂᐦᑖᐅᒋᐦᒑᓯᐤ ᐋ ᓂᑎᐙᓯᔂᐱᓂᐦᒃ ᔒᒥᓐ ᑳ ᓂᐦᑖᐆᒌᐦᒑᒥᑭᓂᔨᒡ᙮ ᐱᔅᒡ ᒫᒃ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ ᒌ ᐹᐦᐱᐦᒋᑎᓂᔨᐤ ᐋᐦ ᐋᑎ ᑖᐦᑎᐦᑯᔥᑳᑖᑭᓂᐎᔨᒡ ᑭᔮᐦ ᐱᔮᔒᔥ ᐋᐦ ᐋᑎ ᒦᒋᔨᒡ ᐊᓂᔮᔨᐤ ᔒᒥᓐ ᑳ ᐙᓯᔂᐱᓂᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ᐋᒄ ᐱᔅᒡ ᑳ ᐱᐦᒋᐦᑎᐦᒡ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᔫᐦᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᓈᓈᒑ ᑳ ᓂᐦᑖᐅᒋᐦᒡ ᒑᒃ ᒌ ᐋᑎ ᐹᔅᑖᐤ ᐙᔥ ᓂᒧᐃ ᒦᐦᒀᒡ ᐅᐦᒋ ᓂᐲᐅᔅᑭᒥᑳᐤ ᐊᓂᑎᐦ ᑳ ᐱᐦᒋᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ᐋᒄ ᐊᓂᐦᐄ ᔒᒥᓐ ᑳ ᐹᐦᐹᐦᒋᑎᐦᒡ ᐊᓂᑖᐦ ᑳ ᑳᐙᔅᑯᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ ᐋᐦᑎᑯᐦᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑᒃ ᑳᐦ ᐋᑎ ᐊᔅᒡ ᓂᐦᑖᐅᒋᐦᒡ᙮ ᒑᒃ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᓐ ᐊᓂᐦᐄ ᑳ ᓂᐦᑖᐅᒋᐦᑖᑭᓂᐎᒡ ᐋ ᒌ ᒋᐱᔥᑳᑑᒥᑭᐦᒡ ᐊᓂᐦᐄ ᑳ ᑳᐙᔅᑯᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ᐱᔅᒡ ᔒᒥᓐ ᐊᓂᑖᐦ ᐋ ᒥᔪᔅᑭᒥᑳᔨᒡ ᐋᑯᑖᐦ ᑳ ᐲᐦᒋᔥᑎᓃᔨᒡ, ᓈᔥᒡ ᒫᒃ ᒌ ᒥᔪ ᓂᐦᑖᐅᒋᓂᔨᐤ ᐅᔮᔨᐤ᙮ ᐋᒄ ᒫᒃ ᒥᔥᑏᐦ ᒦᒋᒥᔨᐤ ᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᐊᓂᑎᐦ ᔒᒥᓂᐦᒡ ᐅᐦᒋ᙮” ᐊᑯᐦ ᒦᓐ ᑳᐦ ᐃᔨᑦ ᐋ ᒋᔣᐙᑦ, “ᐊᓐ ᐊᐙᓐ ᑳ ᐅᐦᑖᐎᑳᑦ ᐋ ᓂᐦᐄᐦᑎᐦᒃ ᒫᒃ, ᔮᒀᐦ ᑭᑎ ᐐ ᓂᑐᐦᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ᐋᒄ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᑯᒀᒋᒫᒡ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᐅᔮᔨᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᒌ ᒥᔨᑯᓈᐙᐤ ᒌᔨᐙᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐊᓐ ᒑᒀᓐ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᒥᔮᑭᓂᐎᒡ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒡ, ᐋᐅᒄ ᐆ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ᐅᒌ ᐄᔨᔨᐅᒡ, ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐱᑎᓂᔨᐤ ᐋᐦ ᐋᔨᒨᑎᒧᐙᑭᓂᐎᒡ ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤᐦ᙮ ᐋᑎ ᐋ ᐙᐱᐦᑎᐦᒡ ᓂᒧᐃ ᒌ ᓂᓯᑑᓂᒧᒡ, ᑭᔮᐦ ᐋ ᐹᐦᑎᐦᒡ ᓂᒧᐃ ᒌ ᓂᔅᑐᐦᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐆ ᑎᐹᒋᒧᐎᓐ᙮ ᒧᔮᒻ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓐᐦ ᐋᔪᐎᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᓐ ᔒᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ᐊᓐ ᔒᒥᓐ ᐊᓂᑖᐦ ᐋ ᒥᔅᑰᐙᔨᒡ ᒫᔅᑭᓈᐦᒡ ᑳ ᐱᐦᒋᔑᐦᒃ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᑳ ᐹᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᒥᒋᒥᓂᑑ ᑖᑯᔑᓃᔨᒡ ᒫᔅᑭᒥᑯᒡ ᐅᑖᐦᐄᐙᐦᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ ᑖᓂᔮᔨᐤ ᑳ ᐄᔑ ᐹᐦᑎᐦᒡ ᐋᑖᔨᒥᑯᒡ ᒑᐦ ᐋᑳ ᒌ ᑖᑆᐦᑎᐦᒡ ᑭᔮᐦ ᒑᐦ ᐋᑳ ᒌ ᐱᒫᒋᐦᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ᐋᒄ ᐊᓐ ᔒᒥᓐ ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐎᔨᒡ ᑳ ᐱᐦᒋᔑᐦᒃ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ ᐋ ᑖᑆᐦᑎᐦᒡ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᐋ ᒥᔻᔨᐦᑎᒥᐦᐄᑯᒡ᙮ ᒧᔮᒻ ᒫᒃ ᐊᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᑳ ᑳ ᔮᐃᒡ ᓂᐦᑖᐅᒋᓃᔨᒡ ᐅᑎᐲᐦ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᐋᑎᐙᔨᐱᔥᒌᔥ ᑳ ᑖᑆᐦᑎᐦᒡ᙮ ᐄᔥᐱᐦ ᑯᒀᒋᐦᐄᐙᐎᓂᔨᐤ ᓈᒋᔅᑭᐦᒀᐤ ᐋᑯᑖᐦ ᔖᔥ ᐹᐦᒋᔑᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ᐋᒄ ᒫᒃ ᐊᓐ ᑯᑎᒃ ᔒᒥᓐ ᑳ ᐱᐦᒋᔑᐦᒃ ᐊᓂᑖᐦ ᑳ ᑳᐙᔅᑯᓃᔨᒡ ᒥᔥᑯᔒ ᐋᐦᑎᑯᓃᔨᒡ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐄᔨᔨᐅᒡ ᑳ ᓂᑑᐦᑎᒸᒡ ᑭᔮᐦ ᐙᑎᓂᒸᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᑖᑆᐦᑎᒧᐎᓂᐙᐤ ᒑᒃ ᓂᔑᐎᓈᒋᐦᑖᑭᓂᐎᔨᐤ ᐙᔥ ᐋᐦ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᑯᒡ ᐋᔨᔅᐱᔨᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ ᑭᔮᐦ ᒦᓯᒋᓰᐎᓂᔨᐤ ᐋ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᒡ, ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐊᔅᒌᐦᒡ ᒑᒀᔨᐤ ᐋ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᒑ ᒌ ᐅᐦᒋ ᒥᔻᔨᐦᑎᐦᒡ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒌ ᐄᔑ ᓂᐦᑖᐅᒋᐦᐅᒡ ᑖᓂᔮᔨᐤ ᒋᐱᐦ ᐄᔑ ᓂᐦᑖᐅᒋᐦᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ᐊᓐ ᒫᒃ ᔒᒥᓐ ᑳ ᒥᔪ ᓂᐦᑖᐅᒋᑦ ᐋ ᒥᔪᔅᑭᒥᑳᔨᒡ ᐊᔅᒌᐦᒡ ᒧᔮᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓂᑐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᓂᓂᐦᐄᐦᑎᒧᒡ, ᑭᔮᐦ ᑭᓂᐙᔨᐦᑎᒧᒡ ᐅᑖᐦᐄᐙᐦᒡ᙮ ᓈᓈᓂᒌᒻ ᑖᑆᐦᑎᒧᒡ ᐋᐦ ᐋᔨᒋᑳᐳᐎᒡ ᐋᒄ ᒫᒃ ᒑᒃ ᐋᑎ ᒥᔪ ᒦᓂᔑᐎᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“ᓂᒧᐃ ᐊᐙᓐ ᐊᑯᓂᐦᐊᒻ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋ ᒌ ᓯᔅᑭᐦᐋᐦᒃ ᑭᔮᐦ ᒫᒃ ᔒᐹ ᓂᐹᐎᓂᐦᒡ ᒑ ᒌ ᐊᔥᑖᑦ᙮ ᓈᐦᐹᒥᔥᑖᐤ ᐊᓂᔮᔨᐤ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᐹᒋ ᐲᐦᒑᑦ ᐙᐱᐦᑎᐦᒻ ᐊᓂᔮᔨᐤ ᐋ ᐙᔥᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","ᒥᓯᐙ ᒑᒀᓐ ᐋᑳ ᑳ ᓅᑯᐦᑖᑭᓂᐎᒡ ᑭᑎ ᓅᑯᐦᑖᑭᓂᐤ, ᐋᒄ ᐊᓐ ᑳ ᐊᑯᓂᐦᐄᑭᓂᐎᒡ ᑭᑎ ᒧᔖᔥᑖᑭᓂᐤ᙮ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᐋᔥᒄ ᐋᑳ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑖᑭᓂᐎᒡ ᐋᔥᒄ ᑭᑎ ᒋᔅᒑᔨᐦᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ᔮᒀᒦᐦ ᒫᒃ ᑖᓐ ᐋ ᐄᔑ ᓂᑐᐦᑎᒥᓐ, ᐙᔥ ᐊᓐ ᐊᐙᓐ ᔮᒀᐦ ᑳ ᓂᑐᐦᑎᐦᒃ ᐊᑎᑎᐤ ᒋᑭ ᓂᔅᑐᐦᑎᒻ᙮ ᐋᒄ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᔮᒀᐦ ᓂᑐᐦᑎᐦᒃ ᒋᑭ ᐎᓂᒋᔅᒋᓲ ᐊᔮᐱᒡ ᑖᓂᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑎᐦᒃ ᐋ ᓂᔅᑐᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ᐹᔨᒀᐤ ᒌᓴᔅ ᐅᑳᐐᐦ ᑭᔮᐦ ᒫᒃ ᐐᒋᐄᔨᔨᐤᐦ ᒋᐐᐦ ᐙᐱᒥᑰ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᓈᑎᑰ, ᐙᔥ ᐋ ᒌ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ᒑᒃ ᒫᒃ ᑳᐦ ᐄᑎᑯᑦ ᐊᐙᔨᐤᐦ ᒌᓴᔅ, “ᒋᑳᐐ ᑭᔮᐦ ᒌᒋᐄᔨᔨᐎᒡ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑖᐦ ᓃᐴᐎᒡ ᐋ ᐐᐦ ᐙᐱᒥᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒧᔮᒻ ᓂᑳᐐ ᑭᔮᐦ ᓃᒋᐄᔨᔨᐎᒡ ᓂᑎᐄᑖᔨᒫᐅᒡ ᐊᓂᒌ ᑳ ᓂᑐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᑳᐦ ᑐᑎᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ᐹᔨᒀᐤ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᓈᑖᐦ ᒫᐦ ᐄᔑ ᐋᔔᐦᐊᐦᑖᐤ ᐊᑳᒥᐦᒡ ᓵᑭᐦᐄᑭᓂᐦᒡ᙮” ᐋᒄ ᑳ ᒧᔖᐅᐦᐊᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ᓈᓈᒑ ᒫᒃ ᑳ ᒨᔖᐙᔮᓯᒡ ᐋᒄ ᑳ ᓂᐹᑦ ᒌᓴᔅ᙮ ᒑᒃ ᔑᔥᒋᑯᒡ ᑳ ᒌᔥᑎᓃᔨᒡ ᐊᓂᑎᐦ ᓵᑭᐦᐄᑭᓂᐦᒡ᙮ ᐋ ᒫᒥᓯᒋᔅᑎᔨᒡ ᑭᔥᑭᓐ ᒌ ᐴᓯᐱᐦᐄᑐᔨᐤ ᐅᒌᒫᓂᓯᐙᐦᒡ᙮ ᒑᒃ ᑳ ᑯᔥᑖᑎᑯᓃᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ᒑᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐹᑯᓈᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᑭ ᓂᔥᑖᐹᐙᓈᓂᐤ᙮” ᒌᓴᔅ ᒫᒃ ᒌ ᐎᓂᔥᑳᐤ, ᑳᐦ ᐄᑎᒄ ᐊᓂᔮᔨᐤ ᐋ ᔫᑎᓃᔨᒡ ᒑ ᐴᓂᐱᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑭᔥᑭᓐ ᑳᐦ ᐄᑖᑦ, “ᒋᔮᒫᐎᓰᒄ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᔻᔥᑎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᑖᓐ ᒋᑖᑆᐦᑎᒧᐎᓂᐙᐤ?” ᒌ ᑯᔥᑖᒎᒡ ᑭᔮᐦ ᐋᔨᐤᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᐋᐦ ᐃᔨᒡ, “ᐊᐙᓐ ᐆ ᐙᐙᒡ ᔪᑎᓂᓯᐤ ᑭᔮᐦ ᑭᔥᑭᓐ ᐋ ᐱᔑᒋᐦᐄᑯᑦ ᐋ ᒋᔅᑎᐦᐋᒧᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᑎᔅᑭᒧᐦᐋᒧᒡ ᐊᓂᑖᐦ ᐄᔑ ᑳᕋᓰᓐ ᐄᔨᔨᐤ ᐅᑎᔅᒋᔨᒡ᙮ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑎᑯᓐ ᐆ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑭᐹᑦ ᒌᓴᔅ ᒌ ᓂᒋᔥᑭᐙᐤ ᓈᐹᐤᐦ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐅᐦᒌᔨᒡ, ᐋ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᔖᔥ ᒫᒃ ᐙᔥᑭᒡ ᐊᓂᑖᐦ ᓂᒧᐃ ᐅᐦᒋ ᒋᒋᔥᑭᒻ ᐅᒑᒀᓂᒻ ᐆ ᓈᐹᐤ᙮ ᓂᒧᐃ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐅᐦᒋ ᑖᐤ ᒥᒄ ᐊᓂᑖᐦ ᒌᐲᑭᒥᑯᒡ ᒨᔥ ᒌᐦ ᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ᐆ ᒫᒃ ᓈᐹᐤ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, ᒌ ᐃᔮᔑᐦᒀᐤ ᑳᐦ ᐋᑎ ᐱᐦᒋᔑᐦᒃ ᐅᐦᑎᔅᑰ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᑳ ᑖᑆᑦ ᐋᐦ ᐃᔨᑦ, “ᒌᓴᔅ, ᒌ ᑳ ᐅᑯᓰᑐᑖᔅᒃ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ, ᑖᓐ ᐙᐦ ᐃᔒᐦᑭᐎᔨᓐ? ᐊᑳᐐ ᐹᒋ ᓂᓈᐦᑳᑖᔨᒧᐦᐄᐦ ᒋᐐᐦ ᓂᑐᑎᒫᑎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑖᑆᑦ ᐆ ᓈᐹᐤ ᐙᔥ ᒌᓴᔅ ᒌ ᐃᔨᑖᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐎᔨᐐᔨᒡ ᐊᓂᑖᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐆ ᒫᒃ ᓈᐹᐤ ᒥᐦᒑᑣᐤ ᒌ ᑎᐹᔨᒥᑯᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᒨᔥ ᒫᒃ ᒌ ᓈᓈᑭᒋᐦᐋᑭᓂᐤ ᐊᓐ ᓈᐹᐤ᙮ ᐋᑦ ᒫᒃ ᑭᔮᐦ ᐋ ᒫᐦᑯᐱᑖᔨᒡ ᐅᓯᑦ ᑭᔮᐦ ᐅᑎᐦᒌ ᐊᔮᐱᒡ ᒌ ᐱᔅᒋᐱᑎᒻ ᒫᓐ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᒥᒫᒋᒫᐱᔅᑭᐦᐄᑭᓂᐐᔨᒡ ᐲᔻᐲᔅᒀᔮᐲᔨᐤ᙮ ᒌ ᑐᑖᑰ ᒫᒃ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ᒌᓴᔅ ᒫᒃ ᒌ ᑯᒀᒋᒫᐤ, ᐋᐦ ᐄᑖᑦ, “ᑖᓐ ᐋᔑᓂᐦᑳᓱᔨᓐ?” ᑳᐦ ᐄᑎᑯᑦ, “ᑳ ᒥᐦᒑᑎᒡ᙮” ᐙᔥ ᒌ ᒥᐦᒑᑎᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᐊᓐ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ᐋᒄ ᒫᒃ ᑳ ᑯᒀᒋᒫᒡ ᒌᓴᔅᐦ ᐋᑳ ᒑ ᒌ ᐄᑎᔓᐦᐅᑯᒡ ᐊᓂᑖᐦ ᒥᒋᔥᑯᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ᒌᐦ ᑖᐅᒡ ᒫᒃ ᑰᐦᑰᔑᒡ ᐋ ᒦᒋᓱᒡ ᐊᓂᑖᐦ ᐋ ᐱᔅᑯᑖᐅᐦᑳᔨᒡ᙮ ᐊᓂᒌ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᐄᑎᔓᐦᐅᑯᒡ ᐊᓂᑖᐦ ᒑ ᒌ ᐲᐦᒋᔥᑯᐙᒡ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ᙮ ᐋᔪᐎᒄ ᒫᒃ ᑳᐦ ᑐᑎᐙᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ᐊᓂᒌ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᒡ, ᐄᔥᐱᐦ ᑳ ᐎᔨᐐᔅᑯᐙᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᒄ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ ᑳᐦ ᐋᔓᐲᐦᒋᔥᑯᐙᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑰᐦᑰᔑᒡ ᑳ ᐃᔮᒥᑖᐅᐦᒋᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐄᔑ ᓵᑭᐦᐄᑭᓂᐦᒡ, ᑳ ᓂᔥᑖᐹᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᐋᒡ ᑰᐦᑰᔥ ᑳ ᐙᐱᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ ᑳ ᒌᒋᐲᐦᔨᑑᒡ, ᑳ ᓂᑑᐐᐦᑎᐦᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐙᔅᑳ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ᒌ ᑎᑯᔑᓂᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᐋ ᒌ ᐹᒋ ᓂᑑᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ᐄᔥᐱᐦ ᐙᑎᐦᑖᒡ ᒌᓴᔅᐦ ᒌ ᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᔖᔥ ᐋᐦᐋᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐊᐱᔨᒡ ᐹᔓᒡ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐅᓯᑎᔨᒡ᙮ ᒌ ᓂᒋᓈᑯᐦᑖᑯᐱᓐ ᐋᔨᐤᐦ ᑭᔮᐦ ᒌ ᒋᔮᒫᐙᔨᐦᑖᑯᓲ᙮ ᓈᔥᒡ ᒌ ᑯᔥᑖᐅᒡ ᒫᒃ ᐎᔮᐱᒫᒡ ᐅᔮᔨᐤ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ᐊᓂᒌ ᒫᒃ ᑳ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᒌ ᑎᐹᒋᒧᔥᑐᐙᐅᒡ ᐄᔨᔨᐤ ᐋ ᑎᑯᔑᓃᔨᒡ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᒦᓂᐙᑎᓰᔨᒡ ᐅᔮᔨᐤ ᓈᐹᐤ ᒥᒋᐊᐦᒑᐦᒄ ᑳ ᒌ ᐲᐦᒋᔥᑳᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᑳᕋᓰᓂᐦᒡ ᑳ ᐅᐦᒌᒡ ᒌ ᓵᒋᓯᐎᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ ᐅᐦᒋ, ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᑭᑎᑯᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᐴᓯᑦ ᐅᒌᒫᓂᓯᐙᐤ, ᐋᒄ ᑳ ᒌᐙᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᑳ ᒌ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ ᓈᔥᒡ ᒋᐐᐦ ᐐᒑᐙᐤ ᒌᓴᔅᐦ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᒋᐦᒋᑎᔑᐦᐙᐤ ᐋ ᒌ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“ᒫᒌᐦ, ᒌᐙᐦ᙮ ᒑ ᐙᐐᐦᑎᒥᓐ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᔅᒃ ᒋᔖᒥᓂᑑ᙮” ᐋᔪᐎᒄ ᒫᒃ ᑳᐦ ᑎᒃ ᐊᓐ ᓈᐹᐤ᙮ ᒥᓯᐙ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒌ ᐱᐹᒫᒋᒨ ᑖᓐ ᑳᐦ ᑐᑎᒫᑯᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ᐄᔥᐱᐦ ᒦᓐ ᑳᐤ ᑳ ᒥᔑᑳᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᓵᑭᐦᐄᑭᓂᐦᒡ ᒌ ᒥᔻᔨᐦᑎᒥᔨᐤ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ, ᐙᔥ ᒥᓯᐙ ᒌ ᐊᔑᓂᐙᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ᐋᒄ ᑳ ᑎᑯᔑᐦᒃ ᓈᐹᐤ ᒑᐃᕋᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᐋ ᐅᒋᒫᐦᑭᐦᑎᐦᒃ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᑳ ᐹᒋ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᑦ ᐹᔓᒡ ᒌᓴᔅ ᐅᓯᑎᔨᒡ ᓈᔥᒡ ᐋ ᓂᑎᐙᔨᒫᑦ ᒑ ᒌ ᑎᑯᔑᓃᔨᒡ ᐊᓂᑖᐦ ᐐᒋᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ᐙᔥ ᐊᓂᔮᔨᐤ ᑳ ᐹᔨᑯᔑᔨᒡ ᐅᑖᓂᔅᐦ ᑳ ᓃᔓᔖᐳᓍᔑᔨᒡ, ᒑᑳᑦ ᒌ ᐴᓂᐱᒫᑎᓰᔨᐤᐦ᙮ ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒑᐃᕋᔅ ᐋ ᐐᒑᐙᑦ ᒌᓴᔅ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒌ ᓰᐦᑎᔅᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ᒌᐦ ᑖᐤ ᒫᒃ ᑭᔮᐦ ᐊᓂᑎᐦ ᐃᔅᒀᐤ ᓃᔓᔖᐳᓐ ᐋ ᒌ ᐎᓂᐦᑖᑦ ᐅᒥᐦᒄ᙮ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐃᔮᑦ ᒌ ᒥᔮᑖᑯᐱᓐ ᓂᑐᐦᑯᔨᓐ ᐋ ᑎᐱᐦᐊᒧᐙᑦ ᒑ ᒌ ᐐᒋᐦᐄᑯᑦ, ᓂᒧᐃ ᒫᒃ ᐙᒋ ᐹᔨᒄ ᐅᐦᒌ ᐐᒋᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ᐅᔅᐱᔅᑯᓃᔨᒡ ᑳ ᐅᐦᒋ ᐹᒋ ᓈᑖᑦ ᒌᓴᔅᐦ, ᑳ ᑖᐦᒋᓂᒸᑦ ᐊᓂᑎᐦ ᐋ ᐎᓂᔥᒀᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᑯᐦᐱᔨᐤ᙮ ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒋᐱᐦᑖᔑᑭᐎᔨᐤ ᐅᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, ᐊᐙᓐ ᑳ ᐹᒋ ᑖᐦᒋᓂᑦ? ᓂᒧᐃ ᒫᒃ ᐊᐙᓐ ᐅᐦᒋ ᒋᔅᑑ ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐋ ᓰᐦᑎᔅᑳᔥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ᒌᓴᔅ ᒫᒃ ᒌ ᐃᔨᐤ, “ᓂᒋᔅᒑᔨᐦᑖᓐ ᐊᐙᓐ ᐋ ᒌ ᐹᒋ ᑖᐦᒋᓂᑦ᙮ ᐙᔥ ᓂᒌᐦ ᒨᔑᐦᑖᓐ ᒦᓂᐙᒋᐦᐄᐙᐤ ᒥᔅᑭᐎᓰᐎᓐ ᐋ ᐎᔨᐐᐱᔨᐦᒡ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐊᓐ ᐃᔅᒀᐤ ᐋ ᒋᔅᒑᔨᒫᑭᓅᑦ ᑖᓐ ᑳᐦ ᑎᒃ ᐋᒄ ᑳ ᐹᒋ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᓃᑳᓂᐦᒡ᙮ ᑳᐦ ᐋᑎᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᑦ ᐅᐦᑎᔅᑰ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋ ᐙᐎᐱᔨᑦ ᐋ ᐃᔥᐱᔥ ᓵᒋᓯᑦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐐᐦᑎᐦᒃ ᒑᒀᔨᐤ ᐙᐦᒋ ᑖᐦᒋᓈᑦ ᐋᔨᐤᐦ ᒫᒃ ᑏᐙᐦᒡ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, “ᓂᑖᓂᔅ, ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒋᒦᓂᐙᒋᐦᐄᑭᐎᓐ᙮ ᒫᒌᐦ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᐦᒡ ᐄᔑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᑦ ᒌᓴᔅ, ᒌ ᑎᑯᔑᓐ ᓈᐹᐤ ᒑᐃᕋᔅ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᑐᐦᑖᑦ ᒑ ᒌ ᐹᒋ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒑᐃᕋᔅ, “ᔖᔥ ᓂᒧᐃ ᐱᒫᑎᓰᐤ ᒋᑖᓂᔅ᙮ ᐊᑳᐐ ᒫᒃ ᐋᑯᔥ ᐅᑎᒥᐦᐄ ᒋᔅᑯᑎᒫᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒑᐃᕋᔅ, “ᐊᑳᐐ ᐋᔨᒫᔨᐦᑦᐦ᙮ ᒥᒄ ᑖᑆᐦᑦᐦ, ᐙᔥ ᒋᑭ ᒥᔪ ᐱᒫᑎᓰᐤ ᒋᑖᓂᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ᐋᒄ ᑳ ᐄᑐᐦᑖᒡ ᒑᐃᕋᔅ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ᙮ ᐄᔥᐱᐦ ᑳ ᐅᑎᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᓂᒧᐃ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᒌᓴᔅ ᒑ ᒌ ᐐᒑᐅᑯᑦ ᐋ ᐲᐦᒑᑦ, ᒥᒄ ᐲᑎᕐ, ᒞᓐ, ᒉᒥᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᓃᒋᐦᐄᒄᐦ ᐊᓐ ᐃᔅᒀᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᒫᑑᒡ ᐋ ᒥᐦᑖᐦᑖᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᔥᐦ᙮ ᐋᒄ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᒡ, “ᐋᑳ ᒫᑑᒄ᙮ ᐙᔥ ᐊᓐ ᑖᐹ ᐴᓂᐱᒫᑎᓰᐤ, ᒥᒄ ᓂᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ᐋᒄ ᑳ ᐅᔑᓂᐙᒡ ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐅᒡ ᑖᑆᐦ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᔥᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ᑳ ᐲᐦᒑᒡ ᒌᓴᔅ ᐊᓂᑖᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ, ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᔥ, ᑳ ᐅᑎᓂᒸᑦ ᐅᑎᐦᒌᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᐃᔅᒀᔥ ᐎᓂᔥᑳ᙮” ");
INSERT INTO crl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ᐋᒄ ᒫᒃ ᒦᓐ ᑳ ᐲᐦᒋᔥᑳᑯᑦ ᐅᑎᐦᒑᐦᒄ ᐊᓐ ᐃᔅᒀᔥ, ᑳ ᐅᐦᒋ ᐎᓂᔥᑳᐱᐦᑖᑦ᙮ ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᐊᔑᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᓃᒋᐦᐄᑯᔨᐤ ᓈᔥᒡ ᒌ ᑯᔥᒀᔨᐦᑎᒥᔨᐤ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ ᒑᐦ ᐋᑳ ᐐᐦᑎᒧᐙᒡ ᐊᐙᔨᐤᐦ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ᒌᓴᔅ ᒫᒨ ᒌ ᓂᑑᒫᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ᑳ ᒥᔮᑦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᑭᔮᐦ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᔨᒡ ᒥᓯᐙ ᒥᒋᐊᐦᒑᐦᒄ ᑭᔮᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑖᔅᐱᓈᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ᐋᒄ ᑳ ᒋᐦᒋᑎᔑᐦᐙᑦ ᒑ ᒌ ᓂᑑᑭᒑᔅᒀᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐋᔨᐤᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᐙᔨᐤᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ᒌ ᐄᑎᔓᒫᐤ ᒫᒃ, “ᐆ ᒑ ᒋᔅᑐᐦᑖᔮᒄ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᑎᐦᑯᓈᓈᐙᐤ ᒑᒀᓐ᙮ ᐊᑳᐐ ᑎᐦᑯᓂᒧᒄ ᓯᔅᑭᐦᐅᓐ, ᓃᒨᑖᓐ, ᒦᒋᒻ, ᑭᔮᐦ ᐙᐙᒡ ᔓᐎᔮᓐ ᑭᔮᐦ ᐋᔨᐙᒡ ᒋᒋᒑᒀᓂᒧᐙᐤ ᐋ ᒋᒋᔥᑭᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ᑭᔮᐦ ᐊᓐ ᐙᔅᑳᐦᐄᑭᓐ ᑖᓂᑖᐦ ᒑ ᐲᐦᑎᑭᐦᐄᑯᐙᒀ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒑ ᑖᔮᒄ ᐹᑎᔥ ᓂᑭᑎᒫᒀ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ᐅᑎᐦᑎᒫᒀ ᒫᒃ ᐃᐦᑖᐎᓐ ᐋᐦᐋᑳ ᐐᐦ ᐲᐦᑎᑭᐦᐄᑭᐎᔮᒀ, ᓂᑭᑎᒧᒄ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ᒑ ᐱᐦᐴᓯᑖᔑᒧᔮᒄ, ᐋ ᓅᑯᐦᑖᔮᒄ ᐋ ᐃᔮᒀᒥᒫᑯᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᑎᓂᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑖᒡ ᐋ ᐙᐐᐦᑎᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᑭᔮᐦ ᐋ ᒦᓂᐙᒋᐦᐋᒡ ᑳᐦ ᐋᐦᑯᓰᔨᒡ, ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᑳ ᐊᑏᑑᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ᐄᔥᐱᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐱᔮᐦᑎᐦᒃ ᑖᓐ ᐋ ᐄᔨᐦᑎᔨᒡ ᒌᓴᔅᐦ, ᓈᔥᑖᑆᐦ ᒌ ᐙᐙᓈᔨᐦᑎᒥᐦᐄᑰ ᐙᔥ ᒌᐦ ᑖᐅᒡ ᐄᔨᔨᐅᒡ ᐋ ᐱᐹᒫᒋᒧᒡ ᐋᐦ ᐃᔨᒡ, ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐆ, ᒦᓐ ᑳᐤ ᐱᒫᑎᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ᒌᐦ ᑖᐅᒡ ᒦᓐ ᑯᑎᑭᒡ ᐋᐦ ᐃᔨᒡ, “ᐋᐅᒄ ᐆ ᐄᓛᐃᒑ, ᒦᓐ ᑳᐤ ᐱᒫᑎᓰᐤ᙮” ᐊᔮᐱᒡ ᒫᒃ ᒦᓐ ᒌᐦ ᑖᐅᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᐋᐅᒄ ᐆ ᐹᔨᒄ ᐙᔥᑭᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒦᓐ ᑳᐤ ᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ᐦᐁᕆᑦ ᒫᒃ ᒌ ᐃᔨᐤ, “ᐊᐙᓐ ᐆ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐄᑖᒋᒫᑭᓅᑦ? ᓂᒥᔮᒑ ᐐᔨ ᓈᓂᑐ ᒞᓐ, ᓂᒑᔥᑎᓈᐦᐅᓐ ᐙᔥ ᓂᒌᐦᐄᑎᓲᐙᓐ ᒑ ᒌ ᒋᒥᒀᐦᐙᑭᓅᑦ ᐐᔨ ᒞᓐ᙮” ᐋᒄ ᓈᔥᒡ ᑳ ᐐᐦ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ᐄᔥᐱᐦ ᑖᑯᔑᐦᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑳ ᒋᐦᒋᑎᔑᐦᐙᑭᓂᐎᒡ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᒡ ᒌᓴᔅᐦ ᑖᓐ ᑳᐦ ᐋᐃᐦᔨᑎᒡ ᑳ ᐃᔅᐱᐦᑎᓂᐦᐅᒡ᙮ ᐋᒄ ᑳ ᓂᑭᑖᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᐦᒑᑎᔨᒡ ᐄᔨᔨᐤ, ᑎᐹᓐ ᑳ ᐄᑐᐦᑖᒡ ᐋ ᐐᒑᐙᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐱᑦᓭᐃᑖᐦᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᐦ ᐄᑐᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ᐄᔥᐱᐦ ᒫᒃ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐦᒡ ᐋ ᒌ ᒋᔅᑐᐦᑖᔨᒡ ᐋᒄ ᑳ ᓅᓲᔅᑰᐙᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᒥᔻᔨᐦᑎᒻ ᐋ ᑎᑯᔑᓃᔨᒡ᙮ ᒌ ᐙᐐᐦᑎᒧᐙᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᑭᔮᐦ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ᔖᔥ ᒫᒃ ᒌ ᐋᑎ ᐅᑖᑯᔑᔨᐤ ᐋᒄ ᐊᓂᒌ ᓃᔓᔖᑉ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳᐦ ᐄᑖᒡ ᒌᓴᔅᐦ, “ᒋᐦᒋᑎᔑᐦᐅᒡ ᒫᐦ ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒑ ᓈᓂᑎᐙᔨᐦᑎᐦᒡ ᒑᒀᔨᐤ ᒑ ᒦᒋᒡ ᐅᑎᐦ ᐹᔓᒡ ᐃᐦᑖᐎᓐ ᐋᐦᑖᑯᓃᔨᒡ ᑭᔮᐦ ᐋᑎ ᒑ ᒌ ᒥᔻᔨᒧᒡ ᒑ ᑎᐱᔅᑳᔨᒡ᙮ ᑖᐹ ᑎᑯᓐ ᒑᒀᓐ ᐅᑎᐦ ᐐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᒥᔮᐦᑯᒡ ᒑᒀᔨᐤ ᒑ ᒦᒋᒡ᙮” ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒫᒃ ᒌ ᐄᑖᐅᒡ, “ᒥᒄ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐆᒡ ᓃᔓ ᒫᒃ ᓂᒫᓯᒡ ᐋᐅᒄ ᒥᒄ ᐋ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᒑᒀᓐ᙮ ᒥᒄ ᑭᔨᑆ ᓃᔮᓐ ᓂᑑᐅᑎᓂᒫᐦᒑ ᒦᒋᒻ ᒑ ᒌ ᑖᐱᐦᐅᒡ ᐅᒌ ᐋ ᐃᑎᔑᒡ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ᐎᔮᔥ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᑎᔒᒑᓂᒋ ᓈᐹᐅᒡ ᐊᓂᑎᐦ ᑳ ᑎᔑᓈᓂᐎᒡ᙮ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, “ᐄᑖᐦᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᓃᔮᔫᒥᑎᓂᐤ ᒑ ᐃᔮᑐᐱᒡ ᐹᔨᒀᐤ ᐊᓂᔮᔨᐤ ᐋ ᒫᐅᓯᑯᐱᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒫᒃ ᒌᐦ ᑐᑎᒧᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑭᓂᐎᒡ ᐋᒄ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᐅᐙᔨᐱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓃᔓ ᓂᒫᔅ, ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᑖᐱᑦ ᐋ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑᐦ᙮ ᑳ ᐱᐱᐦᒀᓈᒃ ᐊᓂᔮᔨᐤ ᒦᒋᒥᔨᐤ ᐋᒄ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒑ ᒌ ᒫᑎᓂᒧᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᒌ ᒦᒋᓲ ᑭᔮᐦ ᒌ ᑖᐱᔥᑯᔨᐤ, ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᒫᒨᔅᒋᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔅᑯᔥᑖᐎᓂᔨᐤ᙮ ᓃᔓᔖᑉ ᒫᒃ ᐅᑎᐲᐎᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ᐹᔨᒀᐤ ᒌᓴᔅ ᒌ ᐊᔨᒥᐦᐋᐤ ᐋ ᐹᔨᑯᔑᑦ, ᒥᒄ ᐱᔅᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐹᔓᒡ ᒌᐦ ᑖᔨᐤ ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᐋᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᓃᔨ ᐋᑖᔨᒥᒡ ᐄᔨᔨᐅᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ᑳᐦ ᐄᑎᑯᑦ, “ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᒋᑎᐄᑖᔨᒥᑯᒡ, ᐋᒄ ᑯᑎᑭᒡ ᐊᓂᔮ ᐹᔨᒄ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐄᓛᐃᒑ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᒋᑎᐄᑖᔨᒥᑯᒡ, ᐋᒄ ᒦᓐ ᑯᑎᑭᒡ ᐋᐦ ᑖᒡ ᐙᔥᑭᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒦᓐ ᑳᐤ ᐋ ᐱᒫᑎᓰᑦ ᐋ ᐄᑖᔨᒥᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳ ᑯᒀᒋᒫᑦ, “ᒌᔨᐙᐤ ᒫᒃ ᐐᐦ, ᐊᐙᓐ ᓃᔨ ᐋᑖᔨᒥᔮᒄ ᐋᐦ ᐋᐎᔮᓐ?” ᐲᑎᕐ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᒌᔨ ᙭, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐃᔨᑦ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑎᔓᒫᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᑳ ᒑ ᒌ ᐐᐦᑎᒧᐙᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐄᔨᔨᐅᑯᓯᓵᓐ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᒑ ᒌ ᒥᔅᑎᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᑯᑦ ᑭᔮᐦ ᒑ ᒌ ᐋᑎᐙᔨᒥᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔑᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤ, ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᑭᑎ ᓂᐱᐦᐋᑭᓂᐤ ᑭᔮᐦ, ᒥᒄ ᒫᒃ ᒌ ᓂᔥᑐ ᒌᔑᑳᔨᒑ ᒦᓐ ᑳᐤ ᑭᑎ ᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ᐋᒄ ᒌᓴᔅ ᒥᓯᐙ ᑳᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᐙᐦ ᓅᔔᔥᑰᒀ ᐋᑯᔥ ᒌ ᐴᓃᐤ ᐊᓂᔮᔨᐤ ᐐᔨ ᑖᓐ ᐙᐦ ᐄᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᑦ, ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒋᐱᐦ ᐅᑎᓈᐤ ᐅᑖᔑᑖᔮᐦᑎᑯᒻ ᐋᒄ ᒫᒃ ᓂᐱᐦ ᐹᒋ ᓅᔔᔥᑳᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ᐙᔥ ᐊᓐ ᐊᐙᓐ ᑳ ᐐᐦ ᑭᓄᐙᔨᐦᑎᒫᓱᑦ ᐅᐱᒫᑎᓰᐎᓐ ᑭᑎ ᐎᓂᐦᑖᐤ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐐᐦ ᐱᒋᔅᑎᓂᐦᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᐦᒃ ᒫᒋᒫ ᑭᔮᐦ ᐅᐱᒫᑎᓰᐎᓐ ᐋ ᐐᐦ ᐹᒋ ᓅᔔᔥᑯᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᒥᔮᑭᓅᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ᑖᓐ ᒫᒃ ᒑ ᒌ ᐄᔑ ᐐᒋᐦᐄᑯᑦ ᐊᐙᓐ ᐋᑎ ᒥᓯᐙ ᒑᒀᔨᐤ ᒌ ᐱᑯᐦᑎᒫᓱᒑ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᒑ ᐎᓂᐦᑖᒀ ᒫᒃ ᐅᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ᐊᐙᓐ ᒫᒃ ᐱᒫᒥᔒᔥᑑᐎᑦ ᓃᔨ ᐅᐦᒋ ᑭᔮᐦ ᓂᑎᔨᒧᐎᓂᔨᐤ ᐅᐦᒋ ᐋᐅᒄ ᒑ ᐱᒫᒥᔒᔅᑖᑯᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐄᔥᐱᐦ ᒦᓐ ᑎᑯᔑᓃᔨᒑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓃᔨᒡ᙮ ᐋᑯᑖᐦ ᒑ ᒋᔅᒑᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐋ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐙᔥ ᑭᑎ ᐙᐱᐦᑎᔨᐙᐅᒡ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐋᓐᒋᓂᒡ ᐋ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᑖᑆᐦ ᐋᐦ ᑖᒡ ᐅᑎᐦ ᐄᔨᔨᐅᒡ ᒑ ᐙᐱᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᒫᒀᒡ ᐋᔥᒄ ᐋ ᐱᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ᐎᔮᔥ ᓂᔮᓈᓈᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐋᔨᒸᐅᐦᐄᑯᑦ ᒌᓴᔅ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ, ᒌ ᒋᔅᑐᐦᑎᐦᐋᐤ ᐲᑎᕐ, ᒞᓐ ᑭᔮᐦ ᒉᒥᔅ, ᒌ ᓵᑭᒋᐙᐅᒡ ᒫᒃ ᐎᒌᔨᐤ ᐋᑎ ᒑ ᒌ ᓂᑑᐊᔨᒥᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐊᔨᒥᐦᐋᑦ ᐅᑖᔥᑎᒥᐦᒄ ᒌ ᒀᔅᒋᓈᑯᓂᔨᐤ ᑭᔮᐦ ᐅᒑᒀᓂᒻ ᓈᔥᑖᑆᐦ ᒌ ᐱᔮᑭᔅᒡ ᐙᐹᔨᐤ ᒥᑐᓐ ᐋ ᒌ ᐙᓯᑯᔥᑖᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ᔑᔥᒋᑯᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᓃᔑᔨᐤ ᓈᐹᐤ ᐋ ᐊᔨᒥᐦᐄᑯᑦ ᒌᓴᔅ᙮ ᐋᐅᑯᓂᒡ ᐊᓂᔮᐦᑳ ᒧᓱᔅ ᑭᔮᐦ ᐄᓛᐃᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ᐋᒄ ᑳᐦ ᐋᔨᒨᑎᒧᐙᒡ ᒌᓴᔅᐦ ᔖᔥ ᐋ ᐹᔓᓈᑯᓃᔨᒡ ᒑ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐄᔑ ᐎᔨᔥᑖᔨᒡ ᒑ ᐄᔅᐱᔨᒡ᙮ ᓈᔥᒡ ᒫᒃ ᐋ ᒥᔻᔥᑖᔨᒡ ᒋᐦᒋᒌᔑᒄ ᒋᔅᑖᔨᑖᑯᓯᐎᓂᔨᐤ ᒌ ᐙᔥᑖᔨᐤ ᐊᓂᑎᐦ ᐙᔅᑳ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ᐲᑎᕐ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒌᓴᔅᐦ ᑳ ᒌ ᐐᒑᐙᒡ ᒌ ᑰᐎᑯᔑᑖᐙᑯᐱᓐ᙮ ᒌ ᐹᑯᐱᔫᒡ ᒫᒃ ᑭᔮᐦ ᐄᔥᐱᐦ ᐎᔮᔅᑭᒫᔨᐦᑎᐦᒡ ᒌ ᐙᐱᐦᑎᒧᒡ ᐙᔥᑖᐎᓂᔨᐤ ᐙᔅᑳ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᑭᔮᐦ ᒌ ᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᓃᔓ ᓈᐹᐤ ᐋ ᐐᒋᑳᐳᔥᑖᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᓈᐹᐅᒡ ᐙᐦ ᓂᑭᑖᒡ ᒌᓴᔅᐦ, ᐲᑎᕐ ᒌᐦ ᐄᑖᐤ, “ᒋᔅᑯᑎᒫᒑᓯᐤ ᓄᐎᒡ ᒥᔻᔨᐦᑖᑯᓐ ᐅᑎᐦ ᒑ ᒌ ᑖᐅᐦᑯᐱᓈ᙮ ᐱᒋᔅᑎᓈᓐ ᒫᐦ ᒑ ᒌ ᐅᔑᐦᑖᔮᐦᒡ ᓂᔥᑐ ᑎᐱᓅᔑᒧᓐᐦ, ᐹᐦᐹᔨᒄ ᒑ ᐃᔮᔮᒄ, ᒌᔨ, ᒧᓱᔅ ᑭᔮᐦ ᐄᓛᐃᒑ᙮” ᐲᑎᕐ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒻ ᒑᒀᔨᐤ ᐙᐦᒋ ᐃᔨᑦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ᒫᒀᒡ ᒫᒃ ᐋᔥᒄ ᐋ ᐊᔨᒥᑦ, ᑭᔥᑭᐎᓂᔥᒄ ᒌ ᐅᐦᒋ ᓅᑯᓯᔨᐤ ᒥᑐᓐ ᐋ ᐊᐅᑳᔥᑖᔥᑳᑯᒡ᙮ ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓈᔥᑖᑆᐦ ᒌ ᓵᒋᓯᐎᒡ ᐄᔥᐱᐦ ᒥᑐᓐ ᐋᑯᓂᐦᐅᑯᒡ ᐊᓂᔮᔨᐤ ᑭᔥᑭᐎᓂᔥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ᐊᓂᑎᐦ ᒫᒃ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ ᒌ ᐅᐦᒋ ᐹᐦᑎᒧᒡ ᐹᐦᑖᑯᓯᐎᓂᔨᐤ, ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᔨᔨᒡ, “ᐋᐅᒄ ᐆ ᓂᑯᔅ ᑳ ᐅᐙᔮᐱᒥᒃᐦ, ᓂᑐᐦᑎᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐊᔨᒥᑦ ᐊᓐ ᐊᐙᓐ, ᒌ ᐙᐱᒫᐅᒡ ᒌᓴᔅᐦ ᐋ ᐹᔨᑯᑳᐳᐎᔨᒡ᙮ ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓂᒧᐃ ᐅᐦᒋ ᐱᐹᒫᒋᒨᒡ ᐋᔥᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒡ ᐋᐦ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ ᒌᓴᔅ ᑭᔮᐦ ᐊᓂᔮ ᓂᔥᑐ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒌ ᓃᐦᑎᒋᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ, ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐊᐙᔨᐤᐦ ᐋ ᐹᒋ ᓂᒋᐦᐄᑯᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ᐊᓂᑎᐦ ᒫᒃ ᑖᐙᔨᔥ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᒌ ᑖᑆᐤ ᐹᔨᒄ ᓈᐹᐤ ᐋᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᓂᑐᑎᒫᑎᓐ ᒑ ᒌ ᐐᒋᐦᐄᑦ ᓂᑯᔅ, ᐙᔥ ᐊᐅᒄ ᒥᒄ ᐋᐦ ᐹᔨᑯᔑᑦ ᓂᑎᐙᔒᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ᒫᔑᐦᐄᑰ ᓂᔮᓂᑯᑐᓐᐦ ᒥᒋᐊᐦᒑᐦᒄ ᐋᐦ ᑐᑖᑯᑦ ᔑᔥᒋᑯᒡ ᒑ ᒌ ᐋᔑᐦᒀᑦ᙮ ᐋᒄ ᒫᒃ ᑭᔮᐦ ᐋ ᐅᒋᐱᑎᑯᑦ ᒫᓐ ᒥᑐᓐ ᐋ ᐲᔥᑖᐅᑖᐦᒧᑦ᙮ ᓈᔥᒡ ᓂᓈᐦᑳᑖᔨᐦᑎᒥᐦᐄᑰ ᐅᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᐋᐦᐋᑳ ᒫᒃ ᐐ ᓂᑭᑎᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ᐋᑦ ᒫᒃ ᓂᒌ ᑯᒀᒋᒫᐅᒡ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᒡ ᐅᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᑐᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᒌᔨᐙᐤ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔮᒄ ᐋᑳ ᑳ ᐃᔮᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᑭᔮᐦ ᐋᑳ ᑳ ᒀᔅᑳᑎᓰᔮᒄ, ᓂᒧᐃ ᑭᔮᐦ ᑯᐃᔅᒄ ᒋᑎ ᐄᔑ ᐱᒫᑎᓰᓈᐙᐤ᙮ ᑖᓐ ᒑ ᐃᔥᐱᔒ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐃᔮᒄ ᒑ ᐃᔮᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ᐹᔓᐙᐦᒄ ᐊᓐ ᓈᐹᔥ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ᒫᒀᒡ ᒫᒃ ᐋ ᐹᒋ ᓈᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐊᓐ ᓈᐹᔥ, ᒥᒋᐊᐦᒑᐦᒄ ᒥᑐᓐ ᒌ ᑭᐎᐙᐱᓂᑰ ᐋᒄ ᑳᐦᑐᑖᑯᑦ ᒑ ᒌ ᐅᒋᐱᑎᑯᑦ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐤ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᑳᐦ ᐄᑖᑦ ᒑ ᒌ ᓂᑭᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᔥᐦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᒦᓂᐙᑎᓰᑦ ᐊᓐ ᓈᐹᔥ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᒌᐙᒥᔮᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᒋᔖᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᔨᒡ ᒌᓴᔅᐦ, ᒌ ᐊᔨᒥᐦᐋᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ᒋᔅᒍᒄ ᔮᔨᑖ ᑖᓐ ᒑ ᐄᑎᑯᒡ᙮ ᒋᑭ ᐱᒋᔅᑎᓈᑭᓂᐎᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌᐦ ᑐᑎᐙᒡ ᑖᓐ ᐙᐦ ᑐᑎᐙᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ᙮ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᑳ ᐐᐦ ᐄᔑ ᐐᐦᑎᒫᑯᒡ ᒌᓴᔅᐦ, ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᒥᔮᑭᓂᐎᒡ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒡ᙮ ᒌ ᓵᒋᓯᐎᒡ ᒫᒃ ᒑ ᒌ ᑯᒀᒋᐦᒑᒧᒡ ᒑᒀᔨᐤ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒫᒃ ᒌ ᐅᔥᑖᐱᔫᒡ ᐋ ᐃᔮᔥᑖᒥᑐᒡ ᐊᐙᓐ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᒫᐅᒡ ᒑ ᒑᔅᑖᔨᐦᑖᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒥᔨᒡ ᐋᒄ ᑳ ᐅᑎᓈᑦ ᐊᐙᔑᔥ ᐋ ᐊᐱᔒᔑᔨᒡ ᐋᒄ ᑳ ᓃᐴᐦᐋᑦ ᐊᓂᑎᐦ ᐅᐦᐱᒫ ᐋᐦ ᑖᑦ᙮ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ");
INSERT INTO crl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“ᐊᐙᓐ ᐋ ᐅᑎᓈᑦ ᐹᔨᒄ ᐅᔮᔨᐤ ᐊᐙᔑᔥ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ, ᒧᔮᒻ ᑭᔮᐦ ᓃᔨ ᐋ ᐅᑎᓂᑦ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓃᔨᒡ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐅᑎᓂᑦ, ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᐙᑎᓈᑦ᙮ ᐙᔥ ᐊᓐ ᐊᐙᓐ ᒫᐅᒡ ᓅᐦᑖᔮᔥ ᑳ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᐋᐅᒄ ᐊᓐ ᒫᐅᒡ ᒑᔅᑖᔨᐦᑖᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ᐋᒄ ᒞᓐ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓂᒌᐙᐱᒫᓈᓐ ᓈᐹᐤ ᐋ ᐎᔨᐐᑎᔑᐦᐙᑦ ᒥᒋᐊᐦᒑᐦᒄ ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᑦ, ᐋᒄ ᑳ ᒋᔅᑎᐦᐋᒧᐎᒋᐦᑦ, ᐙᔥ ᑖᐹ ᐅᑖᐦ ᒌᔮᓂᐤ ᐋ ᑖᐎᐦᒄ ᐄᔑ ᐐᒋᐦᐄᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᒋᔅᑎᐦᐋᒧᐙᐦᒄ᙮ ᐙᔥ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᓂᔥᑰᔥᑖᑎᐦᒄ ᒌ ᐐᒋᐦᐄᑯᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ᓈᓈᓂᒌᒻ ᒫᒃ ᒌ ᐋᑎ ᐹᔓᓈᑯᓂᔨᐤ ᒌᓴᔅ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒑ ᐄᔑ ᐅᑎᓈᑭᓅᑦ ᐋᒄ ᓈᔥᒡ ᑳ ᐄᑖᔨᐦᑎᒃ ᔮᔨᑖ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᑦ ᒌ ᓃᑳᓂᑎᔑᐦᐙᐤ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᓵᒫᕆᔮ ᐄᔨᔨᐤ ᑳᐦ ᑖᔨᒡ, ᒑ ᒌ ᓂᑑᐃᔮᔅᑰᔥᑖᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌᐦ ᑖᑯᐱᓈ ᐊᓂᔮᔨᐤ ᒑ ᑎᐱᔅᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐲᐦᑎᑭᐦᐄᑰ ᐙᔥ ᒌ ᒋᔅᒑᔨᒥᑰ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐐᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒉᒥᔅ ᑭᔮᐦ ᒞᓐ ᑳ ᐹᐦᑎᐦᒡ ᐅᔮᔨᐤ ᒌ ᐄᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒌ ᓂᑎᐙᔨᒥᓈᓈ ᒑ ᒌ ᓂᑎᐙᔨᐦᑎᒫᐦᒡ ᐃᔥᑯᑖᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒑ ᒌ ᐅᐦᒋᐱᔨᐦᒡ ᒑ ᒌ ᓂᔑᐎᓈᒋᐦᐄᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᐊᓂᔮ ᐄᓛᐃᒑ ᑳᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ᒌᓴᔅ ᒫᒃ ᒌ ᒀᔅᒋᑳᐳᔥᑎᐙᐤ ᑳ ᒋᔅᑎᐦᐋᒧᐙᑦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐊᔨᒥᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ, “ᐆ ᐋᑖᔨᐦᑎᒫᒄ ᓂᒧᐃ ᐐᔨ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ ᓂᒧᐃ ᐅᐦᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᓂᔑᐎᓈᒋᐦᑖᐙᑦ ᐊᐙᔨᐤᐦ ᐅᐱᒫᑎᓰᐎᓂᔨᐤ, ᒌ ᑎᑯᔑᓐ ᒑ ᒌ ᐱᒫᒋᐦᐄᐙᑦ᙮” ᐋᒄ ᐊᓂᑖᐦ ᑯᑎᒋᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐱᒧᐦᑖᒡ ᒌ ᓂᒋᔥᑳᑯᒡ ᓈᐹᐤᐦ᙮ ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒋᑭ ᐱᐹᐐᒑᐅᑎᓐ ᑖᓂᑖᐦ ᒥᒄ ᒑ ᐄᑐᐦᑖᐅᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᐦᒑᔔᒡ ᑎᑯᓂᔨᐤ ᐅᐙᑎᑯᐙᐤ, ᐱᔮᔒᔑᒡ ᑭᔮᐦ ᑎᑯᓂᔨᐤ ᐅᒋᔥᑐᓂᐙᐤ, ᒥᒄ ᒫᒃ ᐄᔨᔨᐅᑯᓯᓵᓐ, ᓂᒧᐃ ᐋᔮᔨᐤ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐙᔨᓯᐦᒃ ᒑ ᒌ ᐋᔨᐙᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᑯᑎᒃ ᓈᐹᐤ, “ᐹᒋ ᐐᒑᐅᐦ᙮” ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐱᒋᔅᑎᓐ ᐱᑎᒫ ᒑ ᒌ ᓂᐦᐄᐦᑯᒃ ᓅᐦᑖᐐ ᐴᓂᐱᒫᑎᓰᒑ ᐋᒄ ᒫᒃ ᐃᔮᒄ ᒑ ᐐᒑᐅᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ᐋᒄ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᑦ, “ᐊᓂᒌ ᒧᔮᒻ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᐋᑯᔥ ᑭᑎ ᓂᐦᐄᐦᑯᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔨᔨᒧᐙᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᒌᔨ ᒫᒃ, ᒫᒌᐦ ᒑ ᐙᐎᐦᑖᒨᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ᒦᓐ ᑯᑎᒃ ᓈᐹᐤ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒋᑭ ᐱᐹᐐᒑᐅᑎᓐ, ᒥᒄ ᒫᒃ ᓃᔥᑎᒻ ᓂᑭ ᒌᐙᓐ ᐋᒄ ᒑ ᓂᑎᐙᒋᔮᒥᒀᐤ ᓂᓃᒋᐦᐄᑯᒡ ᑭᔮᐦ ᓃᒋᔖᓂᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᔖᔥ ᐋ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐋᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ ᒋᔖᒥᓂᑑ, ᒨᔥ ᒫᒃ ᐋ ᒌᐙᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᑦ ᐙᔥᑭᒡ ᐅᑎᐃᑖᑎᓰᐎᓐ ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓯᐤ ᒑ ᒌ ᐋᐱᑎᔒᔥᑖᒸᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ᐄᔥᐱᐦ ᑳ ᒌᔑᐱᔨᐦᒡ ᐊᓐ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐅᐙᔮᐱᒫᐤ ᓃᔂᓱᒥᑎᓂᐤ ᓃᔓᔖᑉ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑦ ᐋᒄ ᑳ ᓃᑳᓂᑎᔑᐦᐙᑦ ᐋ ᓈᓃᔓᐦᑖᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ ᒥᓯᐙ ᐃᐦᑖᐎᓂᐦᒡ ᒑ ᐄᑐᐦᑖᔨᒡ ᒥᓯᐙ ᑖᓂᑖᐦ ᑭᔮᐦ ᐐᔨ ᒑ ᐄᑐᐦᑖᑯᐱᓈ, ᑭᔮᐦ ᒥᓯᐙ ᑖᓂᑖᐦ ᐋᐦ ᐋᑎᐃᐦᑖᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᒥᐦᒑᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᔖᔥ ᐋ ᐃᓯᓈᑯᐦᒡ ᒑ ᒌ ᒫᒨᔅᒋᓂᑭᓂᐎᐦᒡ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᐦᒑᑑᒡ ᐋᐱᑎᓰᐎᒡ ᒑ ᒌ ᒫᒨᔥᒋᓂᐦᒡ᙮ ᒋᐱᐦ ᐊᔨᒥᐦᐋᐙᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐊᓐ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋ ᓂᐦᑖᐅᒋᓃᔨᒡ, ᒑ ᒌ ᐄᑎᔑᐦᐙᑦ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒑ ᒫᒨᔅᒋᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ᒫᒌᒄ ᒫᒃ, ᒋᐦᒋᑎᔑᐦᐅᑎᓈᐙᐤ ᐊᓂᑖᐦ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᐋᐦ ᐄᑎᔑᐦᐙᑭᓂᐎᔨᒡ ᑖᐙᔨᔥ ᒥᐦᐄᐦᑭᓐ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ᐊᑳᐐ ᑎᐦᑯᓂᒧᒄ ᔔᔮᓂᐙᑦ, ᑭᔮᐦ ᒦᐎᑦ ᑭᔮᐦ ᒫᒃ ᒥᔅᒋᓐ ᑭᔮᐦ ᐊᑳᐐ ᒋᐱᐦᒋᑳᐳᒄ ᒑ ᒌ ᐊᔨᒥᐦᐋᒄ ᐊᐙᓐ ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“ᑖᓂᑖᐦ ᐊᓐ ᒑ ᐲᐦᑎᑭᐦᐄᑯᐙᒀ ᐙᔅᑳᐦᐄᑭᓐ ᓃᔥᑎᒻ ᒋᑭ ᐄᑖᐙᐅᒡ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒑ ᐐᐦ ᑎᑯᓃᔨᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒫᔻᔨᐦᑎᒧᐙᒀ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᑭᑎ ᐃᔮᐅᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐋᑳ ᒫᔻᔨᐦᑎᒧᐙᒀ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐃᔮᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ᐋᑯᑖᐦ ᒫᒃ ᒑ ᑖᔮᒄ ᐊᓂᑎᐦ ᐊᓐ ᐙᔅᑳᐦᐄᑭᓐ ᑳᐦ ᑖᒡ ᐊᓂᒌ ᐋ ᐐᐦ ᐃᔮᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᐋᑯᑖᐦ ᒑ ᒦᒋᓱᔮᒄ ᑭᔮᐦ ᒑ ᒥᓂᐦᒀᔮᒄ ᑖᓐ ᒑ ᐄᔑ ᒥᔨᑯᐎᔮᒄ, ᐙᔥ ᐊᐙᓐ ᑳᐦ ᐋᐱᑎᓰᑦ ᑖᑆᐦ ᐄᑖᔨᐦᑖᑯᓯᐤ ᒑ ᒌ ᑎᐱᐦᐋᒧᐙᑭᓅᑦ᙮ ᐊᑳᐐ ᐋᔓᐲᐦᒑᒄ ᐙᔅᑳᐦᐄᑭᓐ, ᐋᑯᑖᐦ ᒥᒄ ᐊᓂᑎᐦ ᑖᒄ ᑖᓂᑖᐦ ᑳ ᐲᐦᑎᑭᐦᐄᑯᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“ᑭᔮᐦ ᒫᒃ ᐅᑎᐦᑎᒫᒀ ᐃᐦᑖᐎᓐ ᐋ ᐲᐦᑎᑭᐦᐄᑯᐎᔮᒄ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑖᒄ᙮ ᒦᒋᒄ ᑖᓐ ᐋ ᐄᔑ ᐎᔨᔥᑣᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ᑭᔮᐦ ᒦᓂᐙᒋᐦᐋᐦᑯᒡ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᑭᔮᐦ ᒫᒃ ᒑ ᐄᑖᑯᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳᐦ ᐄᑖᒡ, ‘ᓈᔥᑖᑆᐦ ᒋᐹᔣᐱᒥᑯᐙᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ᐋᒄ ᒫᒃ ᐅᑎᐦᑎᒫᒀ ᐃᐦᑖᐎᓐ ᐋᐦᐋᑳ ᓂᑎᐙᔨᒥᑯᐎᔮᒄ ᒑ ᒌᐦ ᑖᔮᒄ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐄᔑ ᐃᔮᒀᒥᒫᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᐦ ᐄᑖᑯᒡ, ");
INSERT INTO crl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘ᒥᑐᓐ ᓂᐱᐲᐅᓯᑖᓯᒧᓈᓐ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐱᐹᒧᐦᑖᔮᐦᒡ ᐅᑎᐦ ᒋᑎᐦᑖᐎᓂᐙᐦᒡ᙮ ᐋᐅᒄ ᐆ ᐋ ᓅᑯᐦᑖᔮᐦᒡ ᐋ ᒌ ᐋᑎ ᐙᔨᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ᒥᒄ ᒫᒃ ᒋᐐᐦ ᐐᐦᑎᒫᑎᓈᓐ ᒑᔥᑎᓈᔥ ᒑ ᒌ ᓂᔅᑐᐦᑎᒫᒄ ᐋ ᒌ ᐹᔓᓈᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᐙᒄ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᓂᒌ ᑳ ᒥᒑᑎᓯᒡ ᐄᔨᔨᐅᒡ ᐙᔥᑭᒡ ᔂᑐᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳᐦ ᑖᒡ, ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᔨᒑ ᐊᑎᑎᐤ ᑭᑎ ᐙᐦᑎᓂᔨᐤ ᐐᔨᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᒌᔨᐙᐤ ᑳᐦ ᑖᔮᒄ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒀᕌᓯᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᓄᐎᒡ ᒋᑭ ᒥᒋᐱᔨᓈᐙᐤ, ᑭᔮᐦ ᐊᓂᑖᐦ ᐱᑦᓭᐃᑖᐦᒡ ᑳᐦ ᑖᒡ ᐋᐅᒄ ᐊᓐ ᒧᔮᒻ ᒑ ᐄᔅᐱᔨᒡ᙮ ᐙᔥ ᐊᓂᐦᐄ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ ᑳᐦ ᑐᑎᒫᑯᐎᔮᒄ ᒋᑎᐦᑖᐎᓂᐙᐦᒡ, ᒌ ᑐᑖᑭᓂᐙᑯᐱᓈ ᒫᒃ ᐊᓂᑖᐦ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᔖᔥ ᐙᔥᑭᒡ ᒋᐱᐦ ᒌ ᒀᔅᑳᑎᓰᐎᒡ ᐐᔨᐙᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᐋᒄ ᒫᒃ ᒋᐱᐦ ᓅᑯᐦᑖᐅᒡ ᐋ ᐃᔥᐱᔥ ᒥᐦᒋᔨᐙᓯᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ ᒋᐱᐦ ᐐᔅᒀᔮᑭᐴᒡ ᐋ ᑳᐙᑭᓃᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ, ᐊᓂᑖᐦ ᒫᒃ ᐱᐦᑯᑖᐦᒡ ᒋᐱᐦ ᐊᐱᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ, ᒋᔖᒥᓂᑑ ᐎᔮᔥ ᑭᑎ ᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᑖᐃᕋᐦᒡ ᑭᔮᐦ ᓵᐃᑎᓂᐦᒡ ᑳ ᒌᐦ ᑖᔨᒡ᙮ ᐊᑎᑎᐤ ᒫᒃ ᒌᔨᐙᐤ ᒋᑭ ᐋᒀᒡ ᑐᑖᑯᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᐊᓂᑎᐦ ᑳᐯᕐᓂᐅᒥᐦᒡ ᑳᐦ ᑖᔮᒄ, ᒌ ᐱᑯᓵᐄᐦᑖᓈᐙᒑ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒑ ᒌ ᐄᔑ ᐅᑎᓂᑯᐎᔮᒄ᙮ ᓂᒧᐃ ᒫᒃ, ᐙᔥ ᒥᒋᔥᑯᑖᐦᒡ ᐋᑯᑖᐦ ᒑ ᐄᔑ ᐙᐱᓂᑯᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐊᐙᓐ ᑳ ᓂᑑᐦᑖᑖᒄ ᒧᔮᒻ ᓃᔨ ᐋ ᐹᒋ ᓂᑑᐦᑎᐙᑦ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᑦ᙮ ᐊᐙᓐ ᒫᒃ ᑳᐦ ᐋᑎᐙᔨᒥᑖᒄ ᒧᔮᒻ ᓃᔨ ᐋᐦ ᐋᑎᐙᔨᒥᑦ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᑦ᙮ ᐋᒄ ᐊᐙᓐ ᑳᐦ ᐋᑎᐙᔨᒥᑦ ᒧᔮᒻ ᐋᐦ ᐋᑎᐙᔨᒫᑦ ᒋᔖᒥᓂᑑ, ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ, ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᑖᑯᔑᐦᒡ ᐊᓂᒌ ᓃᔂᓱᒥᑎᓂᐤ ᓃᓲᔖᐳ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᓈᔥᑖᑆᐦ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐋᐦ ᐃᔨᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐙᐙᒡ ᒥᒋᐊᐦᒑᐦᑯᒡ ᐋ ᓂᓂᐦᐄᐦᑎᐎᔨᒥᐦᒡ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᒋᐦᒡ, ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᓂᒌᐙᐱᒫᐤ ᒥᒋᒥᓂᑑ ᐋ ᐅᐦᒋ ᐱᐦᒋᔑᐦᒃ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᒧᔮᒻ ᑖᑆᐦ ᐋ ᐙᔥᑖᐱᔨᐦᒡ ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","ᓂᑐᐦᑎᒧᒄ ᒫᒃ, ᒋᒌ ᒥᔨᑎᓈᐙᐤ ᑎᐹᔨᐦᒋᒑᐎᓐ ᒑ ᒌ ᐃᔥᐱᔑᐦᑖᐙᒄ ᒥᒋᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓐ, ᑭᔮᐦ ᒑ ᒌ ᑖᐦᑎᐦᑯᔥᑳᑖᑯᒡ ᑳ ᐱᐦᒋᐳᔨᐙᒡ ᒥᔑᒋᓈᐳᑯᒡ, ᑭᔮᐦ ᒫᒃ ᑳ ᐱᐦᒋᐳᔨᑐᓂᐎᔨᒡ ᐋ ᒌᔅᑐᐦᐅᐙᒡ ᑳᒫᒥᒑᑐᑳᑖᒡ᙮ ᓂᒧᐃ ᑎᑯᓐ ᒑᒀᓐ ᒑ ᒌ ᐋᐦᑯᐦᐄᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ᐊᑳᐐ ᒥᔻᔨᐦᑎᒧᒄ ᒥᒄ ᐋ ᒌ ᔑᐦᑯᒋᐦᐋᑯᒡ ᒥᒋᐊᐦᒑᐦᑯᒡ, ᐊᐅᔅᑖ ᒥᔻᔨᐦᑎᒧᒄ ᒋᑎᔑᓂᐦᑳᓱᐎᓂᐙᐤ ᐋ ᒥᓯᓈᑖᐦᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ᐋᑯᑖᐦ ᒫᒃ ᒌᓴᔅ ᓈᔥᒡ ᑳ ᒨᒋᒑᔨᐦᑎᒥᔅᑳᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᒌ ᐃᔨᐤ ᒫᒃ, “ᓅᐦᑖ, ᒌᔨ ᑳ ᑎᐹᔨᐦᑎᒥᓐ ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ ᒋᓂᓈᔅᑯᒥᑎᓐ, ᐙᔥ ᒋᓂᑳᐦᐊᒧᐙᐅᒡ ᐊᓂᒌ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᒑ ᒌ ᓂᔅᑐᐦᑎᒧᐙᐙᑯᐱᓈ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ᙮ ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᓈᔥᒡ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᒋᒌ ᑐᑎᐙᐅᒡ ᐐᔨᐙᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒡ᙮ ᐋᐦᐋ, ᓅᐦᑖ, ᐋᐅᒄ ᐆ ᑳ ᐄᔑ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑯᔨᓐ ᒑ ᒌᐦ ᑐᑎᒥᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ᐋᒄ ᒌᓴᔅ ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᓅᐦᑖᐐ ᒥᓯᐙ ᒑᒀᔨᐤ ᓂᒌ ᒥᔨᒄ ᒑ ᒌ ᓈᓈᑭᑐᐙᔨᐦᑎᒫᓐ᙮ ᐙᔥ ᓂᒧᐃ ᐊᐙᓐ ᒋᔅᒑᔨᒫᐤ ᐅᑯᓯᓯᒫᐤ, ᒥᒄ ᐅᐦᑖᐐᒫᐤ ᒋᔅᒑᔨᒫᐤ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐊᐙᓐ ᒋᔅᒑᔨᒫᐤ ᐅᐦᑖᐐᒫᐤ, ᒥᒄ ᐅᑯᓯᓯᒫᐤ, ᑭᔮᐦ ᒥᒄ ᐐᔨ ᐅᑯᓯᓯᒫᐤ ᒋᑭ ᐅᐙᔮᐱᒫᐤ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ ᒑ ᒌ ᒋᔅᒑᔨᒫᔨᒡ ᐅᐦᑖᐐᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᔑᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒌᔨᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐙᐱᐦᑎᒫᒄ ᐊᓅᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ᐙᔥ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒌ ᒥᐦᒑᑑᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᒋᐦᒋᐅᒋᒫᐅᒡ ᐋ ᒌ ᐱᑯᓵᔨᐦᑎᐦᒡ ᒑ ᒌ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᒫᒄ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐙᐱᐦᑎᒧᒡ᙮ ᒋᐐᐦ ᐹᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᒄ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐹᐦᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ᐹᔨᒀᐤ ᒫᒃ ᓈᐹᐤ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ ᐋᐦ ᐄᑖᐱᑎᓰᑦ ᒌ ᓈᑖᐤ ᒌᓴᔅᐦ ᐋ ᐐ ᑯᒀᒋᐦᐋᑦ, ᐋᐦ ᐄᑖᑦ, “ᑖᓂᑖᐦ ᒑ ᑎᔮᓐ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔮᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ᒌᓴᔅᐦ ᒌ ᐄᑎᑰ, “ᑖᓐ ᒫᒃ ᐋ ᐄᔑ ᓂᔅᑐᐦᑎᒥᓐ ᐊᓐ ᐊᔨᒥᐦᐋᐤ ᐎᔨᔓᐙᐅᓯᓂᐦᐄᑭᓐ ᐋ ᐊᔨᒥᐦᑖᔨᓐ? ᑖᓐ ᐋᑎᔥᑖᒡ ᒫᒃ?” ");
INSERT INTO crl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᒌᐦ ᐄᑖᐤ, “ᓵᒋᐦᐄᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᒋᔖᒥᓂᑑᒻ, ᒥᓯᐙ ᒋᑖᐦᐄᐦᒡ, ᑭᔮᐦ ᒥᓯᐙ ᒋᑎᐦᒑᐦᑯᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᒋᒥᔅᑰᓰᐎᓂᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᒌ ᒥᑐᓈᔨᐦᒋᑭᓂᐦᒡ ᑭᔮᐦ ᒫᒃ ᓵᒋᐦᐄᒡ ᒌᒋᐄᔨᔨᐅᒡ ᒧᔮᒻ ᒌ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ᒌᓴᔅᐦ ᒫᒃ ᒌ ᐄᑎᑰ, “ᒌ ᑖᑆᓐ ᐊᓐ ᑳᐦ ᐃᔨᓐ᙮ ᒥᓯᐙ ᐊᓐ ᑐᑎᒥᓈ ᒋᑭ ᐃᔮᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ᓈᔥᒡ ᒫᒃ ᒧᔮᒻ ᐋ ᒥᔪᑐᑎᐦᒃ ᒋᐐᐦ ᐄᑎᐦᑖᑯᐦᐄᓲ ᐋ ᐄᔑ ᑯᒀᒋᒫᑦ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᑦ, “ᐊᐙᓐ ᐊᓐ ᓃᒋᐄᔨᔨᐤ ᓂᐱᐦ ᓵᒋᐦᐋᐤ ᒧᔮᒻ ᓃᔨ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓱᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᑎᐙᔨᒫᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᒥᔨᒡ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ “ᐹᔨᒀᐤ ᓈᐹᐤ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐅᐦᒌᑦ ᐊᓂᑖᐦ ᒑᕆᑯᐦᒡ ᒋᐐᐦ ᐄᑐᐦᑖᐤ᙮ ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐱᒧᐦᑖᑦ ᒌ ᓈᒋᒀᔥᑯᐦᑖᑰ ᒋᒧᑎᔅᒃ ᐋᒄ ᑳ ᒫᓯᐦᐄᑯᑦ, ᑳ ᐅᑎᓂᒥᔨᒡ ᒥᓯᐙ ᐅᒑᒀᓂᒻ᙮ ᒌ ᓂᑭᑎᑰ ᒫᒃ ᐊᓂᑎᐦ ᒫᔅᑭᓈᐦᒡ ᓈᔥᒡ ᐃᔮᐦᒻ ᐋ ᒥᔣᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ᐋᒄ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒌ ᐹᒋ ᐱᒧᐦᑖᐤ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ, ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐐᒋᐦᐋᐤ ᐋᒄ ᐊᓂᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᔅᑭᓂᐤ ᑳ ᐱᒧᐦᑖᑦ ᒥᒄ ᐋ ᒌ ᐄᔑ ᒥᔮᔅᑭᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ᒑᒃ ᒦᓐ ᑯᑎᒃ ᓈᐹᐤ ᒌ ᐹᒋ ᐱᒧᐦᑖᐤ, ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᑦ ᓖᕚᐃ ᐄᔨᔨᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ᙮ ᒌ ᐙᐱᒫᐤ ᑭᔮᐦ ᐐᔨ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᒥᔣᑭᓂᐦᑳᑖᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᐐᔨ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐐᒋᐦᐋᐤ ᐋᒄ ᒥᒄ ᑳ ᐄᔑ ᒥᔮᔅᑭᐙᑦ ᓈᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᔅᑭᓂᐤ ᐋ ᐱᒧᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ᒦᓐ ᑯᑎᒃ ᓈᐹᐤ, ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᒌᑦ ᒌ ᐅᑎᐦᑖᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐋᒄ ᓈᔥᒡ ᑳ ᒋᔅᑎᒫᒑᔨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ᑳ ᓈᑖᑦ ᐋᒄ ᑳ ᓂᑑᐦᑯᐦᐋᑦ ᐋ ᑯᑎᐱᓂᒸᑦ ᑑᒥᓂᑭᓂᔨᐤ ᐋ ᓂᑑᐦᑯᔨᓂᐎᔨᒡ ᑭᔮᐦ ᒫᒃ ᔔᒥᓈᐴᔨᐤ ᑖᓂᑖᐦ ᐊᓂᑎᐦ ᑳ ᒥᔣᑭᓂᐦᑳᑖᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒌ ᐐᔅᒀᔮᐱᐦᑳᑎᒸᐤ᙮ ᐋᒄ ᑳ ᑖᐦᑎᐦᐋᑦ ᐊᓂᑎᐦ ᐅᑑᐦᑳᓂᒻ ᐅᔅᐱᔅᑯᓃᔨᒡ, ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᓂᐹᐅᑭᒥᒄ ᐋᐦᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᓈᓈᑭᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ᒦᓐ ᒋᔮᒋᔖᐹᔮᔨᒡ, ᑳ ᒥᔮᑦ ᔓᐎᔮᓐ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐹᐅᑭᒥᑯᔨᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᓈᓈᑭᒋᐦᐄ ᐆ ᓈᐹᐤ᙮ ᒋᑭ ᑎᐱᐦᐊᒫᑎᓐ ᑖᓐ ᐊᓐ ᒑ ᐃᔥᐱᔥ ᐊᐅᐦᐋᔓᒥᑖᓐ ᐄᔥᐱᐦ ᒦᓐ ᐱᒧᐦᑖᔮᓈ ᐅᑎᐦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᑳ ᐐᐦᑎᒧᐙᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᑎᐹᔅᑯᓂᒑᓯᐤ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᐊᓐ ᐅᒌ ᐋ ᓃᔥᑎᒡ ᓈᐹᐅᒡ ᒧᔮᒻ ᐐᒋᔖᓐ ᑳᐦ ᑐᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒥᔣᑭᓂᐦᑳᑖᒫᑭᓂᐎᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ᐋᒄ ᐊᓐ ᑎᐹᔅᑯᓂᒑᓯᐤ ᑳᐦ ᐄᑖᑦ, “ᐊᓐ ᑭᔨᑆ ᓈᐹᐤ ᑳ ᐐᒋᐦᐋᑦ, ᑳ ᓅᑯᐦᑖᑦ ᐋ ᒋᔅᑎᒫᒑᔨᒫᑦ᙮” ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒫᒌᐦ ᒫᒃ, ᐋᐅᒄ ᒫᒃ ᐆ ᒧᔮᒻ ᒑ ᑐᑎᒥᓐ ᑭᔮᐦ ᒌᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᒡ ᒌ ᐅᑎᐦᑎᒧᒡ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᐃᔅᒀᐤ ᒫᕐᕧ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᐋᔨᐅᑯᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐲᐦᑎᑭᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ᒫᕐᕧ ᒫᒃ ᒌᐦ ᑖᔨᐤ ᐐᒋᔖᓂᔅᒀᒻ, ᒣᕇ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᒌ ᐙᐙᔨᐱᐤ ᒫᒃ ᐊᓂᑖᐦ ᒌᓴᔅ ᐅᓯᑎᔨᒡ ᐋ ᓂᑑᐦᑎᐙᑦ ᐋ ᐊᔨᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ᒫᕐᕧ ᒫᒃ ᓈᔥᑖᑆᐦ ᒌ ᐅᑎᒫᔨᐦᑎᒥᐦᐄᑰ ᐋ ᒥᔅᑎᐋᐱᑎᓰᑦ, ᐋᒄ ᑳ ᓈᒋᑳᐳᔥᑎᐙᑦ ᒌᓴᔅᐦ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᒧᐃ ᐋ ᐎᔮᔥ ᒋᑎᐄᑖᔨᒫᐤ ᐆ ᓃᒋᔖᓐ, ᓃᔨ ᒥᒄ ᐋᑖᔨᒥᑦ ᒑ ᒌ ᐋᐱᑎᓯᐎᒡ᙮ ᐄᔑ ᒫᐦ ᒑ ᒌ ᐹᒋ ᐐᒋᐦᐄᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐄᑎᑰ, “ᒫᕐᕧ, ᒫᕐᕧ ᑖᑆᐦ ᒥᐦᒑᑐ ᒑᒀᓐ ᓈᔥᒡ ᒌ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ᐹᔨᒄ ᐙᔥ ᒥᒄ ᒑᒀᓐ ᓈᔥᒡ ᓂᑎᐙᔨᐦᑖᑯᓐ, ᒣᕇ ᒫᒃ ᔖᔥ ᒌ ᐎᔮᐱᐦᑎᒫᓲ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᐊᐅᔅᑖ ᐋ ᒥᔻᔒᔨᒡ ᐋ ᓂᑎᐙᔨᐦᑖᑯᓃᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐊᐙᔨᐤᐦ ᒋᑭ ᒌ ᒥᔅᑭᒥᑰ ᐊᓂᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ᐹᔨᒀᐤ ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ, ᐹᔨᒄ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐄᑎᑰ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐹᒋ ᒋᔅᑯᑎᒨᓈᓐ ᒫᐦ ᑭᔮᐦ ᓃᔮᓐ ᑖᓐ ᒑ ᐄᔑ ᐊᔨᒥᐦᐋᔮᐦᒡ ᒧᔮᒻ ᒞᓐ ᑳᐦ ᑐᑎᐙᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᒫᐤ ᒑ ᐄᔑ ᐊᔨᒥᐦᐋᔮᒄ, ᓅᐦᑖᐐᓈᓐ, ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᑖᔨᓐ, ᑭᑎ ᒋᔅᑖᔨᐦᑖᑭᓂᐤ ᐋ ᐱᔮᐦᒋᓰᒥᑭᐦᒡ ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓐ᙮ ᒋᐦᒋᐅᒫᐎᓐ ᑭᑎ ᐅᑎᐦᒋᐱᔨᐤ᙮ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᑭᑎ ᑐᑖᑭᓂᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᒧᔮᒻ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","ᒥᔨᓈᓐ ᑎᐦᑐ ᑳᔑᑳᒡ ᐋᐃᐦᑯᓈᐤ ᒑ ᐅᐦᒋ ᐱᒫᑎᓰᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ᐙᐹᔨᐦᑎᒨᐎᓈᓐ ᒫᒃ ᓂᒥᒋᐦᑣᐎᓈᓐ, ᐙᔥ ᑭᔮᐦ ᓃᔮᓐ ᐋ ᐙᐹᔨᐦᑎᒧᒋᐦᒡ ᒥᓯᐙ ᑳ ᒥᒋᐦᑐᑎᐐᒥᔨᐦᒡ᙮ ᐊᑳᐐ ᒫᒃ ᐄᑐᐦᑎᐦᐄᓈᓐ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᔑ ᑯᒀᒋᐦᐄᑭᐎᔮᐦᒡ᙮ ᒥᒄ ᒥᑖᒀᓂᒨᓈᓐ ᐊᓐ ᑳ ᒫᔮᑎᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐱᑯᓃᒑ ᓂᑎᐙᐱᒫᑦ ᒫᐦ ᒋᐐᒑᐙᑭᓐ ᐋᐦ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᒡ ᐋ ᐐ ᓂᑑᐊᐅᐦᐋᓱᒫᑦ ᒑᒀᔨᐤ, ᐋᒄ ᒫᒃ ᐄᑎᑦ ᐊᓐ ᒋᐐᒑᐙᑭᓐ, ‘ᐹᒋ ᐊᐅᐦᐄᐦ ᒫᐦ ᓂᔥᑐ ᐲᔣᔮᐃᐦᑯᓈᐎᒡ ");
INSERT INTO crl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ᐙᔥ ᓂᐐᒑᐙᑭᓐ ᓂ ᐹᒋ ᒧᐎᑎᑎᐦᒄ ᐋᑯᑖᐦ ᐋᐦᑖᐅᒡ ᒑ ᓂᐹᑦ᙮ ᓂᒧᐃ ᓂᑎᔮᐙᓐ ᒑᒀᔨᐤ ᒑ ᐊᔑᒥᒃ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ᐋᒄ ᒫᒃ ᐄᑎᔅᒃ ᐊᓐ ᒋᐐᒑᐙᑭᓐ ᑳ ᓂᑑᐅᔅᐹᐙᐦᐄᑦ, ‘ᐊᑳᐐ ᐹᒋ ᒧᑯᔥᑳᒋᐦᐄᐦ ᐙᔥ ᔖᔥ ᓂᒌ ᒋᐱᐦᐙᐤ ᒋᔥᑐᐦᑭᓐ ᑭᔮᐦ ᓂᑎᐊᐙᔑᔒᒥᒡ ᓂᐐᐦᐹᒥᑯᒡ, ᓂᒧᐃ ᓂᑭ ᒌ ᐎᓂᔥᑳᓐ ᒑ ᒌ ᒥᔨᑖᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᑳ ᐐᐦ ᐎᓂᔥᑳᒑ ᒑ ᒌ ᒥᔨᔅᒃ ᐊᓂᔮᔨᐤ ᐱᔣᔮᐃᐦᑯᓈᐤ ᐋᑎ ᐋ ᒌ ᒥᔪ ᐐᒑᐙᑭᓂᑐᑖᔅᒃ ᐊᔮᐱᒡ ᒫᒃ ᒑᒃ ᒋᑭ ᐎᓂᔥᑳᐤ ᒑ ᒌ ᒥᔨᔅᒃ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒨᑦ, ᐋᑳ ᐴᓂᐦᐄᑖ ᐋ ᓂᑎᐙᔨᐦᑎᒨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ᐙᔥ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᑐᑎᒫᒄ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᒄ, ᒋᑭ ᒥᔨᑯᓈᐙᐤ ᒫᒃ, ᓈᓂᑐᐙᔨᒻ ᒋᔖᒥᓂᑑ ᐋᒄ ᒫᒃ ᒑ ᒥᔅᑭᐙᑦ᙮ ᒥᒥᑣᐦᐄᒑ ᒋᔥᑐᐦᑭᓐ ᐋᒄ ᒫᒃ ᒑ ᐋᐱᐦᐊᒫᑭᐎᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ᐙᔥ ᑎᐦᑐ ᐊᐙᓐ ᑳ ᓂᑐᑎᒫᑦ ᒋᑭ ᒥᔮᑭᓂᐤ᙮ ᑭᔮᐦ ᑎᐦᑐ ᐊᐙᓐ ᑳ ᓈᓂᑎᐙᔨᒫᑦ ᒋᔖᒥᓂᑑ ᒋᑭ ᒥᔅᑭᐙᐤ, ᑭᔮᐦ ᑎᐦᑐ ᐊᐙᓐ ᑳ ᒥᒥᑣᐦᐄᒑᑦ ᑭᑎ ᐋᐱᐦᐊᒧᐙᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“ᒌᔨᐙᐤ ᐅᐦᑖᐐᒫᑐᒄ, ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᒫᐦ ᒋᑯᓯᔅ ᓂᒫᔅ ᒋᐱᐦ ᒌᐦ ᑎᓈ ᐋ ᒑ ᒌ ᒥᔨᑦ ᐊᒋᓈᐱᒄ, ");
INSERT INTO crl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ᑭᔮᐦ ᒫᒃ ᓂᑎᐙᔨᐦᑎᒫᔅᒃ ᐙᐅᔨᐤ, ᒋᐱᐦ ᒌᐦ ᑎᓈ ᐋ ᒑ ᒌ ᒥᔨᑦ ᒥᓂᑐᔥ ᐋ ᒋᔅᑐᐦᐅᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ᐋᑦ ᐋ ᒥᒑᑎᓯᔮᒄ ᐊᔮᐱᒡ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒑ ᒌ ᒥᔪ ᒥᔮᑯᒡ ᒋᑎᐙᔑᔒᒧᐙᐅᒡ᙮ ᐊᑎᑎᐤ ᒫᒃ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᒋᔅᒑᔨᐦᑎᒻ ᒑ ᒌ ᒥᔪ ᒥᔨᐙᑦ᙮ ᒥᔻᔨᐦᑎᒻ ᐋ ᒥᔮᑦ ᐊᐙᔨᐤᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐊᓂᔮᔨᐤ ᑳ ᓂᑐᑎᒫᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ᒌᐦ ᑖᐤ ᓈᐹᐤ ᒥᑐᓐ ᐋ ᒌ ᑐᑖᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ ᐋᑳ ᒑ ᒌ ᑭᔅᒋᐦᐅᑦ ᐋ ᐊᔨᒥᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᐎᔨᐐᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ, ᐋᒄ ᑳ ᐅᐦᒋ ᓂᐦᑖᐙᑦ ᐊᓐ ᓈᐹᐤ᙮ ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᓈᔥᑖᑆᐦ ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ᐋᒄ ᐱᔅᒡ ᒌ ᐄᑖᐅᒡ, “ᐊᓂᔮᔨᐤ ᐯᓪᓯᐳᓚ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐅᒋᒫᐤ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳ ᒥᔨᑯᑦ ᒥᑖᐅᐎᓂᔨᐤ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᑦ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ᑯᑎᑭᒡ ᒫᒃ ᒋᐐᐦ ᑯᒀᒋᐦᐋᐅᒡ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᓈᓂᑐ ᒋᔅᒑᔨᐦᑎᒸᒡ ᑖᓂᑖᐦ ᐙᐦᒋᐱᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ᙮ ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒑ ᒌ ᐙᐱᐦᑎᔨᑯᒡ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᒋᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒥᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒫᓯᐦᐄᑐᑣᐙ ᐄᔨᔨᐅᒡ ᐊᐹᔨᑯᔅᑳᓈᔑᒡ ᒋᑭ ᓂᔑᐎᓈᒋᐦᐄᑑᒡ᙮ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᐹᔨᑯᑖᓂᐤ ᐄᔨᔨᐅᒡ ᐋ ᒥᒋᐱᔨᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒋᐦᑳᐙᒋᐱᔨᐎᒡ ᑭᔮᐦ ᒋᑭ ᒌ ᓂᔑᐎᓈᒋᐦᐄᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ᐊᓂᒌ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᒡ ᑳ ᓅᔔᔥᑯᐙᒡ ᒥᒋᒥᓂᑑ, ᒫᓯᐦᐄᑐᑣᐙ ᒫᒃ, ᒥᒋᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᒋᑭ ᓂᔑᐎᓈᒋᐦᑖᑭᓂᐎᔨᐤ᙮ ᐋᐅᒄ ᒫᒃ ᒋᐱᐦ ᐄᔅᐱᔨᐤ ᑖᑆᐦ ᐯᓪᓯᐳᓪ ᐹᒋ ᒥᔨᑦ ᒥᑖᐅᐎᓂᔨᐤ ᒑ ᒌ ᐋᐱᒋᐦᑖᐅᒡ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐆᒀᐤ ᒥᒋᐊᐦᒑᐦᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ᑖᑆᐦ ᐯᓪᓯᐳᓪ ᐅᒥᑖᐅᐎᓐ ᐃᔮᐱᒋᐦᑖᐙᐅᒑ ᐋ ᐎᔨᐐᑎᔑᐦᐅᒀᐤ ᒥᒋᐊᐦᒑᐦᑯᒡ, ᑭᔮᐦ ᒫᒃ ᒋᑎᐄᔨᔨᒥᐙᐅᒡ ᐋ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒥᒋᐊᐦᒑᐦᒄ, ᐊᐙᔨᐤᐦ ᒫᒃ ᑳ ᐐᒋᐦᐄᑯᒡ ᐐᔨᐙᐤ ᐅᔮᔨᐤ ᒑ ᒌ ᑎᒡ? ᒋᑭ ᒌ ᐐᐦᑎᒫᑯᐙᐅᒡ ᐋᐦᐋᑳ ᑖᑆᔮᒄ ᐊᓐ ᐋᐦ ᐃᔨᔮᒄ ᒥᒋᒥᓂᑑ ᐋ ᐐᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᑳ ᐹᒋ ᒥᔨᑦ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐆᒥᒀᐤ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐙᐦᒋ ᐙᐱᐦᑎᔨᑯᐎᔮᒄ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᔖᔥ ᒥᑐᓐ ᐋ ᐅᑎᐦᑎᐦᐅᑯᐙᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“ᐋᒄ ᐊᓯᓈᑯᓯᑦ ᒥᒋᒥᓂᑑ ᒧᔮᒻ ᐋ ᓲᐦᒋᓰᑦ ᓈᐹᐤ ᒥᓯᐙ ᐋ ᐄᔑ ᐃᔮᔅᑰᐎᔅᑖᑦ ᐅᓂᑐᐱᔫᐋᐱᒋᑖᐎᓐ ᐋ ᓈᓈᑭᒋᐦᑖᑦ ᐐᒋ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᐋ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ, ᓂᒧᐃ ᐊᐙᔨᐤᐦ ᑭᑎ ᒌ ᐱᒫᔨᐦᑎᒥᔨᐤ ᐊᓂᔮᔨᐤ ᐅᒑᒀᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ᐅᑎᐦᑎᑯᑦ ᒫᒃ ᐊᐙᔨᐤᐦ ᐊᐅᔅᑖ ᐋ ᓲᐦᒋᓰᔨᒡ ᐃᔥᐱᔥ ᐐᔨ ᑭᑎ ᒌ ᔑᐦᑯᒋᐦᐄᑰ᙮ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᒑ ᐅᑎᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᑐᐱᔫᐋᐱᒋᑖᐎᓐ ᐊᓂᔮᔨᐤ ᑳ ᐐ ᒫᒥᔒᑐᑎᐦᒃ ᒑ ᒌ ᐅᐦᒋ ᑭᓂᐙᔨᒦᓱᑦ᙮ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐃᔮᑦ, ᒥᓯᐙ ᑭᑎ ᐄᔑ ᒫᑎᓂᐙᐱᔨᐦᑖᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ᒌᓴᔅ ᒦᓐ ᒌᐦ ᐄᑖᐤ, “ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᐹᒋ ᐐᒋᐦᐄᑦ, ᓂᓂᔥᑰᔥᑖᒄ᙮ ᐊᐙᓐ ᐋᑳ ᑳ ᐐᒋᐦᐄᑦ ᐋ ᒥᒨᓯᒋᓂᒑᐅᒡ ᐙᐱᓂᒑᐤ ᐐᔨ ᐃᓯᓈᑯᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐄᑖᑦ, “ᐄᔥᐱᐦ ᐋ ᒌ ᐎᔨᐐᑦ ᒥᒋᐊᐦᒑᐦᒄ ᐲᐦᒡ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ ᐊᓂᑖᐦ ᐋ ᐹᐦᒀᔨᒡ ᐱᐹᐊᔨᑖᐤ ᐋ ᓈᓂᑎᐙᔨᑎᐦᒃ ᑖᓂᑖᐦ ᒑ ᒌ ᐋᔨᐙᓯᑦ᙮ ᐋᐦᐋᑳ ᒫᒃ ᒫᔅᑭᐦᒃ ᐋᒄ ᐋᑏᓱᑦ, ‘ᓂᑭ ᒌᐙ ᓈᓂᑎᐙᐱᒫᐤ ᐊᓐ ᓈᐹᐤ ᑳ ᓂᑭᑎᒃ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᓈᐹᐤ ᒧᔮᒻ ᐙᔅᑳᐦᐄᑭᓐ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓰᔨᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ᑭᔨᑆ ᑳᐤ ᐋ ᐄᔑ ᒌᐙᑦ ᐊᓐ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᓈᓂᑐᐙᔨᐦᑎᐦᒃ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐎᔨᐐᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐹᐦᒑᑦ ᐋᒄ ᒫᔅᑭᐦᒃ ᓈᔥᒡ ᐋ ᐱᔮᐦᒋᓈᑯᓃᔨᒡ ᑭᔮᐦ ᓈᔥᒡ ᐋ ᒥᔪᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ᐅᔮᔨᐤ ᒫᒃ ᐎᔮᐱᐦᑎᐦᒃ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐋᒄ ᒑᔅᑐᐦᑖᑦ, ᓂᔮᓂᑎᐙᔨᒫᑦ ᓃᔣᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᐊᐅᔅᑖ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐐᔨ ᒑ ᒌ ᐐᒋᒥᑯᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐲᐦᒡ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐊᑎᑎᐤ ᒋᑭ ᐄᑖᔨᐦᑖᑯᐦᐄᑰ ᐊᓂᔮᔨᐤ ᓃᔣᔥᒡ ᒥᒋᐊᐦᒑᐦᒄ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᐦᐄᑯᑦ ᓃᔥᑎᒻ, ᒥᒄ ᐋ ᒌ ᐹᔨᑯᔑᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ᒫᒀᒡ ᐅᔮᔨᐤ ᐋᐦ ᐊᔨᒥᑦ ᒌᓴᔅ, ᐃᔅᒀᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐊᓂᔮᔨᐤ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᒌ ᐅᐦᒋ ᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, “ᑖᑆᐦ ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᐃᔅᒀᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᑳ ᐅᐦᒋ ᓂᐦᑖᐅᒋᔨᓐ ᑭᔮᐦ ᑳ ᓅᔖᓂᐦᐄᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ, ᑖᑆᐦ, ᒥᒄ ᒫᒃ ᐊᐅᔅᑖ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᐹᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ ᑭᔮᐦ ᐋᐦ ᑐᑎᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ᐋᒄ ᒫᒃ ᐊᑎᑎᐤ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᓂᑑᐦᑖᑯᑦ ᒌᓴᔅ᙮ ᑳᐦ ᐄᑖᑦ, “ᐊᓅᐦᒡ ᐄᔨᔨᐅᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᓈᔥᑖᑆᐦ ᒥᒑᑎᓯᐎᒡ᙮ ᑯᒀᒋᐦᒑᔨᒨᐎᒡ ᒑ ᒌ ᐙᐱᐦᑏᔮᑭᓂᐎᒡ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ᙮ ᓂᒧᐃ ᒫᒃ ᒋᑭ ᐅᐦᒋ ᐙᐱᐦᑏᔮᑭᓂᐎᒡ᙮ ᒥᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒞᓈ ᐋᔪᐎᒄ ᒥᒄ ᐊᓂᔮᔨᐤ ᒑ ᐙᐱᐦᑏᔮᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ᒧᔮᒻ ᐙᐱᐦᑏᐙᐎᓐ ᒌ ᐃᓯᓈᑰᓲᐤ ᒞᓈ ᒌ ᐄᑎᔓᐦᐅᑰ ᒋᔖᒥᓂᑑ ᐊᓂᑖᐦ ᓂᓀᕓ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒑ ᒌ ᐃᔮᒀᒥᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᑭᔮᐦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᐄᔑᓈᑰᓯᑦ ᐙᐱᐦᑏᐙᐎᓐ ᐙᐦᒋ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐊᓂᑖᐦ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᐄᔨᔨᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ᐄᔥᐱᐦ ᒫᒃ ᐋ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒡ ᐅᑎᐦᒋᐱᔨᐦᒑ, ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᔥᒀᐤ ᐲᓯᒸᑖᐦᒡ ᑳ ᑎᐹᔨᐦᒋᒑᑯᐱᓈ ᒋᑭ ᐅᐦᒋ ᐱᓯᑰ ᒑ ᒌ ᐃᔨᑦ ᐋ ᓂᔑᐎᓈᒋᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ᙮ ᐙᔥ ᐐᔨ ᓈᔥᑖᑆᐦ ᐙᐦᔨᐤ ᒌ ᐅᐦᑐᐦᑖᐤ ᒥᒄ ᒑ ᒌ ᓂᑑ ᓂᑑᐦᑎᒸᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᔂᓚᒥᓐ ᐅᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᑖᐤ ᒫᒃ ᐅᑎᐦ ᐊᐙᓐ ᐊᐅᔅᑖ ᐋ ᒋᑳᔮᔨᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᔂᓚᒥᓐ, ᓂᒧᐃ ᒫᒃ ᐃᔮᐱᓯᐦᑎᐙᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ᐄᔥᐱᐦ ᒫᒃ ᑎᐹᔅᑯᓂᒑᐤ ᒌᔑᑳᒑ, ᐊᓂᔮᐦᑳ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᓂᓀᕓᐦᒡ ᑳ ᒌᐦ ᑖᒡ ᒋᑭ ᐅᐦᐱᑳᐳᐎᒡ ᒑ ᐃᔨᒡ ᒑ ᒌ ᓂᔑᐎᓈᒋᒥᑖᑯᒡ ᒌᔨᐙᐤ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᐙᒄ᙮ ᐙᔥ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒀᔅᑳᑎᓰᔨᒡ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᒞᓈ ᐋ ᑭᒑᔅᒀᔨᒡ᙮ ᑖᐤ ᒫᒃ ᐊᐙᓐ ᐅᑎᐦ ᐊᐅᔅᑖ ᐋ ᒋᑳᔮᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᒞᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“ᓂᒧᐃ ᐊᐙᓐ ᓯᔅᑭᐦᐊᒻ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋᒄ ᒫᒃ ᒑ ᒌ ᓂᑑᑳᑖᑦ, ᑭᔮᐦ ᒫᒃ ᐎᔮᔥᑖ ᐊᓂᑖᐦ ᒑ ᒌ ᐊᑯᓂᐦᐋᐦᒃ᙮ ᐊᔥᑖᐤ ᐊᓂᑎᐦ ᑖᓂᑖᐦ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᐹᒋ ᐲᐦᒑᑦ ᒑ ᒌ ᐙᐱᐦᑎᐦᒃ ᐋ ᐙᔥᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ᒋᔅᒌᔑᒄ ᐋᐅᒄ ᐅᔮᔨᐤ ᐅᐙᔥᑖᓂᒫᑭᓐ ᒌᔨᐤ᙮ ᐋ ᒥᔻᒡ ᒋᔅᒌᔑᒄ ᒥᑐᓐ ᐙᔥᑖᐤ ᒌᔮᐦᒡ ᒥᒄ ᒫᒃ ᐋᑳ ᒥᔻᒑ ᒋᔅᒌᔑᒄ ᓈᔥᑖᑆᐦ ᐋ ᐅᑳᔥᑖᔮᐤ ᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ᔮᒀᒦᐦ ᐋᑳ ᒑ ᒌ ᑎᑯᐦᒡ ᐎᓂᑎᐱᔅᒋᓰᐎᓐ ᒌ ᐱᒫᑎᓰᐎᓂᐦᒡ, ᐙᔥᑖᐎᓐ ᐊᓂᑖᐦ ᒋᐱᐦ ᑎᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ᐊᐙᓐ ᒫᒃ ᒥᑐᓐ ᐎᔮᔥᑖᐙᒀ ᐋᑳ ᒥᑐᓐ ᐃᔮᒀ ᐊᐅᑳᔅᑖᐎᓂᔨᐤ ᐅᐱᒫᑎᓰᐎᓂᐦᒡ, ᑖᑆᐦ ᒥᑐᓐ ᑭᑎ ᐙᔥᑎᐙᐤ, ᒧᔮᒻ ᑳ ᒌ ᐃᓯᓈᑯᓯᑦ ᐊᐙᓐ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ ᐋ ᒋᐦᑳᔓᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᑦ ᒌᓴᔅ, ᐹᔨᒄ ᐹᕆᓰ ᒌ ᓂᑑᒥᑰ ᒑ ᒌ ᐐᒋᒦᒋᓲᒫᑦ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ, ᑳ ᓂᑑᐐᒋᒦᒋᓲᒫᑦ ᐊᓂᔮᔨᐤ ᐹᕆᓰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ᒌ ᒥᔅᑳᑖᔨᐦᑎᒻ ᐊᓐ ᐹᕆᓰ ᐋᐦᐋᑳ ᐅᐦᒋ ᑳᓰᑎᐦᒑᔨᒡ ᒌᓴᔅᐦ ᐋᒸᔮ ᒦᒋᓱᔨᒡ᙮ ᐙᔥ ᐋᔪᐎᒄ ᑳ ᒌᐦ ᑎᓈᓂᐎᔨᒡ ᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᐹᕆᓰᑐᒄ, ᓈᔥᒡ ᔮᒀᐦ ᑳ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᑰᔮᑭᓂᐙᐤ ᑭᔮᐦ ᒋᒥᓂᐦᒀᑭᓂᐙᐤ ᒑ ᒌ ᐱᔮᐦᑭᐦᒡ ᐊᓂᑎᐦ ᐋ ᓅᑯᐦᒡ᙮ ᒥᒄ ᒫᒃ ᐋᐅᒄ ᒋᐦᒋᐙ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ ᓈᔥᒡ ᐋ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᒑᒀᓐ ᑭᔮᐦ ᓈᔥᒡ ᐋ ᒥᒋᐦᑑᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ᓂᒧᐃ ᐋ ᒋᓂᔅᑐᐦᑖᓈᐙᐤ, ᒋᔖᒥᓂᑑ ᑳ ᐅᔑᐦᑖᑦ ᒥᔮᔨᐤ ᒌ ᐅᔑᐦᑖᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐲᐦᒡ ᑖᓐ ᐋ ᐃᓯᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ᒥᔮᐦᑯᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒡ᙮ ᐋᒄ ᒫᒃ ᒑ ᐱᔮᐦᒋᓈᑯᐦᒡ ᒋᐱᒫᑎᓰᐎᓂᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐹᕆᓰᒡ, ᓈᔥᒡ ᔮᒀᐦ ᒋᓈᓈᑭᒋᐦᑖᓈᐙᐤ ᐋ ᐄᔑ ᐱᐦᒀᓂᒧᐙᒄ ᒋᔖᒥᓂᑑ ᑖᓐ ᐋ ᐄᔑ ᓂᐦᑖᐅᒋᐦᒑᔮᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓂᔥ᙮ ᒥᔻᔑᐤ ᑭᔨᑆ ᐊᓐ ᐋᐦ ᑐᑎᒫᒄ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᔻᔑᐤ ᐋᐦᐋᑳ ᑯᐃᔅᒄ ᑐᑎᐙᑯᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᓵᒋᐦᐋᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐹᕆᓰᑐᒄ᙮ ᐙᔥ ᓈᔥᒡ ᐊᓂᑖᐦ ᐋ ᒋᔅᑖᔨᐦᑖᑯᐦᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᑯᑖᐦ ᐙᐦ ᐊᐦᐄᔓᔮᒄ ᑭᔮᐦ ᓈᔥᒡ ᐋ ᓂᑎᐙᔨᐦᑎᒫᒄ ᒑ ᒌ ᒋᔅᑖᔨᒥᑯᐎᔮᒄ ᐋ ᐙᒋᔮᒥᑯᐎᔮᒄ ᐱᐹᒧᐦᑖᔮᒄ ᐊᓂᑖᐦ ᑳ ᒌ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐋ ᐊᑖᐙᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐹᕆᓰᒡ, ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ, ᒥᒄ ᒫᒃ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᔮᒄ ᒧᔮᒻ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒋᓂᐙᒋᑖᑳᓂᐎᒡ ᐋᑦ ᐋ ᒌ ᓂᐦᐄᑭᐙᑭᓅᑦ ᐊᐙᓐ᙮ ᐄᔨᔨᐅᒡ ᑖᑎᐦᑯᔅᑳᑎᒧᒡ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᐦᒡ ᒑᒀᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᐄᑖᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ᐹᔨᒄ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒌᐦ ᐄᑖᐤ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐆ ᑳᐦ ᐃᔨᓐ, ᒌ ᒫᔮᔨᒥᓈᓐ ᑭᔮᐦ ᓃᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᐐᔓᐙᐎᓐ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ, ᒌ ᐱᑯᓵᔨᒫᐙᐅᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓐ ᒌᔨᐙᐤ ᑳ ᐅᔑᐦᑖᔮᒄ, ᓈᔥᒡ ᑳ ᐋᔨᒥᐦᐄᑯᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐦᒡ᙮ ᒥᓯᒥᔅᑳᑰᐎᒡ ᐋᐦᐋᑳ ᒫᒃ ᐙᐙᒡ ᐊᐱᔑᔥ ᐐᐦ ᐄᒋᐦᐋᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ᙮ ᓈᔥᒡ ᒋᒌ ᒥᔪᐦᑖᐙᓈᐙᐤ ᐊᓂᑎᐦ ᑳ ᓂᐦᐄᑭᐙᑭᓂᐎᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ᐊᓂᔮᐦᑳ ᒫᒃ ᐋᓂᔅᒑ ᑰᐦᑖᐙᐅᒡ ᐋ ᒌ ᓂᐱᐦᐋᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ᒋᓅᑰᐦᑖᓈᐙᐤ ᒫᒃ ᐋ ᓂᐦᐋᔨᐦᑎᒸᒄ ᐅᔮᔨᐤ ᐋ ᒌᐦ ᑎᒡ ᐋᓂᔅᒑ ᑰᐦᑖᐙᐅᒡ᙮ ᐐᔨᐙᐤ ᒌ ᓂᐱᐦᐋᐅᒡ ᐅᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒌᔨᐙᐤ ᒫᒃ ᒋᒌ ᒥᔪᓈᑯᐦᑖᐙᓈᐙᐤ ᐊᓂᑎᐦ ᑳ ᓂᐦᐄᑭᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ᐋᔪᐎᒄ ᒫᒃ ᐙᐦᒋ ᐃᔨᑦ ᑳ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ, ‘ᓂᑭ ᐄᑎᔓᐦᐊᒧᐙᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ, ᑭᔮᐦ ᐋᑆᔅᑎᓪᐦ᙮ ᒥᒄ ᒫᒃ ᒋᑭ ᓂᐱᐦᐋᐅᒡ ᐱᔅᒡ, ᑭᔮᐦ ᑯᑎᒃ ᒋᑭ ᓂᓈᐦᑳᒋᐦᐋᐅᒡ᙮’ ᐋᔪᐎᒄ ᒫᒃ ᑳ ᐄᔅᐱᔨᒡ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ, ᐐᔨᐙᐤ ᑭᑎ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐹᒋ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐃᔥᐱᔥ ᑎᑯᓃᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ᐊᓂᑖᐦ ᑳ ᐅᐦᒋᐱᔨᒡ ᑳ ᓂᐱᐦᐋᑭᓅᑦ ᐁᐱᓪ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐊᓂᑖᐦ ᒫᒃ ᐄᔑ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᓵᑳᕌᔮ ᑖᓐ ᑳ ᐄᔑ ᓂᐱᐦᐋᑭᓅᑦ᙮ ᐲᐦᑎᑳᒥᐦᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌ ᓂᐱᐦᐋᑭᓂᐤ ᓵᑳᕌᔮ ᒋᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᑯᔨᐤ᙮ ᐊᓂᑎᐦ ᒫᒃ ᒫᐅᒡ ᐋ ᐱᔮᐦᒑᔨᐦᑖᑯᐦᒡ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ᙮ ᐋᐦᐋ, ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓅᐦᒡ ᐐᔨᐙᐤ ᒋᑭ ᐋᓂᔅᒑ ᐱᑎᑯᔥᑳᑯᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᐙᑭᓂᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ᓄᐎᒡ ᒋᑭ ᐅᔅᑖᐱᓈᐙᐤ ᒌᔨᐙᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔮᒄ ᐐᔓᐙᐎᓐ᙮ ᒌ ᓂᑳᐦᐙᐅᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒋᔅᒑᔨᒫᒡ ᑭᔮᐦ ᒑ ᒌ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ᙮ ᒌᔨᐙᐤ ᓂᒧᐃ ᒋᐐᐦ ᐲᐦᒑᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᐋᒄ ᒫᒃ ᒌ ᓂᑳᐦᐋᐙᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐐᐦ ᐲᐦᒑᒡ᙮ ᒧᔮᒻ ᐊᐙᓐ ᐋ ᐅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐋᐱᐦᐄᑭᓂᔨᐤ ᐋᑳ ᒑ ᒌ ᐲᐦᒑᔨᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐋ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᒋᔅᑐᐦᑖᑦ ᒌᓴᔅ ᐊᓂᑎᐦ ᐅᐦᒋ, ᐋᒄ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᒋᔑᐙᐦᐄᑯᒡ᙮ ᓈᔥᒡ ᒫᒃ ᓲᐦᒃ ᐊᔮᐱᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᑯᑎᒋᔨᐤ ᒑᒀᔨᐤ ");
INSERT INTO crl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ᐋ ᐐᐦ ᓈᓂᑐ ᑳᐦᒋᔥᑎᓈᒡ ᓂᑎᐐ ᒑ ᒌ ᐄᔨᔨᒡ ᒑᒀᔨᐤ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᒫᒥᔑᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ᒫᒀᒡ ᒫᒃ ᐊᓐ ᐋ ᐊᔨᐦᑎᓈᓂᐎᒡ, ᒥᐦᒑᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐄᔨᔨᐅᒡ ᒌ ᐙᔅᑳᑭᐴᐎᒡ ᐋ ᓂᑑᐦᑎᐙᒡ ᒌᓴᔅᐦ᙮ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔥᐱᔥ ᒥᐦᒑᑎᒡ ᒥᑐᓐ ᒌ ᑭᑎᐦᑯᔅᑳᑑᐎᒡ᙮ ᓃᔥᑎᒻ ᒫᒃ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᔮᒀᒦᔥᑐᐙᐦᑯᒡ ᐹᕆᓰᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐙᔥ ᐊᔨᒥᐦᐋᐦᑳᓲᐎᒡ᙮ ᒧᔮᒻ ᐱᔣᔮᔨᑯᓈᐤ ᐅᐦᐱᓯᑭᓐ ᑳ ᐄᑖᔨᐦᑖᑯᐦᒡ ᐋᔪᐎᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐦ ᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ᐙᔥ ᐊᓐ ᒑᒀᓐ ᐋᑳ ᑳ ᓅᑯᐦᒡ ᒋᑭ ᓅᑯᐦᑖᑭᓂᐤ ᐊᓂᑖᐦ ᐋ ᐙᔥᑖᒡ᙮ ᒥᓯᐙ ᒑᒀᓐ ᒌᒧᒡ ᑳᐦ ᑐᑖᑭᓂᐎᔨᒡ ᒋᑭ ᒋᔅᒑᔨᐦᑖᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒌᒧᒡ ᐊᔨᒥᐦᒡ ᐄᔨᔨᐅᒡ ᐋ ᑎᐱᔅᑳᒡ ᐋᔥᒄ ᒋᑭ ᐹᐦᑖᑯᓐ ᐋ ᒌᔑᑳᒡ᙮ ᑖᓐ ᐊᓐ ᑳ ᐄᔑ ᒌᒧᒡ ᐋᔨᒥᔨᓐ ᐋᔥᒄ ᒥᓯᐙ ᑭᑎ ᐐᐦᑖᑯᓐ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᐐᒑᐙᑭᓂᑐᒃ, ᐊᑳᐐ ᑯᔥᑖᐦᒄ ᐊᐙᓐ ᑳ ᓂᐱᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐙᔥ ᑖᐹ ᐎᔮᔥ ᒋᑭ ᒌᐦ ᑐᑎᐙᐤ ᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ᒌ ᐹᒋ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐙᓐ ᐊᓐ ᒋᐱᐦ ᑯᔥᑖᐙᐤ᙮ ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒑ ᒌ ᑯᔥᑖᒄ ᐙᔥ ᐐᔨ ᐃᔮᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒥᒋᔥᑯᑖᐦᒡ ᒑ ᒌ ᐄᔑ ᐙᐱᓂᑖᒄ ᐄᔥᐱᐦ ᓂᐱᔮᒀ᙮ ᐋᐦᐋ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐋᐅᒄ ᐆ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᒋᐱᐦ ᑯᔥᑖᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᓂᒧᐃ ᓈᔥᒡ ᐋᐱᑖᔨᐦᑖᑯᓯᐎᒡ ᐋ ᐃᔮᐱᔒᔑᒡ ᐱᔮᔒᔑᒡ, ᒥᒄ ᓃᔓ ᓵᓐᔅ ᐄᑎᒋᐦᑖᑯᓯᐎᒡ ᓂᔮᔪ ᐋ ᐅᑎᓈᑭᓂᐎᒡ, ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᐙᒋ ᐹᔨᒄ ᐎᓂᒋᔅᒋᓰᑐᑖᑯᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ᐙᐙᒡ ᒋᔅᑎᒀᓂᐲᐙᐙᐤ ᒌ ᐊᒋᐦᑖᑭᓂᐤ ᐋ ᑎᐦᑣᐹᑭᐦᒡ᙮ ᐊᑳᐐ ᒫᒃ ᑯᔥᑖᒋᒄ ᐙᔥ ᐊᔮᐱᒡ ᒌᔨᐙᐤ ᐊᐅᔅᑖ ᒋᒋᔅᑎᒫᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᐋ ᑭᓂᐙᐱᒥᑖᒄ ᒋᔖᒥᓂᑑ ᐃᔥᐱᔥ ᐐ ᐋ ᒥᐦᒑᑎᒡ ᐱᔮᔒᔑᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“ᐊᐙᓐ ᐐᐦᑎᒧᐙᒑ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋ ᑖᑆᔮᔨᒥᑦ, ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᔮᐦ ᑭᑎ ᐃᔨᐤ ᐋ ᐅᑏᔨᔨᒥᑖᑯᑦ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ᐋᒄ ᒫᒃ ᐃᔨᒑ ᐊᐙᓐ ᐋᐦ ᐄᑖᑦ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᑖᑆᔮᔨᒥᑦ, ᓂᑭ ᐄᑖᒫᔨᐤ ᑭᔮᐦ ᒋᔖᒥᓂᑑᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ, ‘ᓂᑖᑎᐙᔨᒫᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ᒥᓯᐙ ᐊᐙᓐ ᑳ ᒥᒋᐋᔨᒨᒫᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᑎ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᑳ ᒫᔮᔨᒫᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒥᔔ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᐄᑐᐦᑎᐦᐄᑭᐎᓈ ᑭᔮᐦ ᒫᒃ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᑦ ᒑ ᒌ ᑎᐹᔅᑯᓂᑭᐎᔨᓐ ᐊᑳᐐ ᒥᑯᔥᑳᑖᔨᐦᑎ ᑖᓐ ᒑ ᐃᔨᓐ ᑭᔮᐦ ᑖᓐ ᒑ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᐙᔨᓐ ᒑ ᒌ ᐅᐦᒋ ᐐᒋᐦᐄᓱᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ᐙᔥ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒋᑭ ᒋᔅᑯᑎᒫᒄ ᑖᓐ ᓂᐦᐋᐤ ᒑ ᐃᔨᓐ ᐊᓐ ᒫᒀᒡ ᐄᔑ ᓂᒋᔥᑭᒥᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ᐋᒄ ᐹᔨᒄ ᐊᓂᑎᐦ ᓈᐹᐤ ᑳ ᓂᑑᐦᑎᐙᑦ ᒌᓴᔅᐦ, ᒌᐦ ᐄᑖᐤ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐊᔨᒥᐦᐄ ᒫᐦ ᓃᒋᔖᓐ ᒑ ᒌ ᒫᑎᓂᒨᐎᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑭᑎᒧᔨᒥᐦᑦ ᐊᓂᔮ ᓅᐦᑖᐐᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᐹ ᓂᒥᔮᐤ ᓃᔨ ᑳ ᐎᔮᔨᐦᑎᐦᒃ ᑖᓂᑖᐦ ᒑ ᐄᔑ ᒫᑎᓂᐙᓂᐎᔨᒡ ᐊᐙᓐ ᐅᒑᒀᓂᒻ ᑭᔮᐦ ᒫᒃ ᑳ ᐹᐦᐱᒋᔅᑎᓂᒸᑦ ᐊᐙᔨᐤᐦ ᐅᒑᒀᓂᒥᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ᐋᒄ ᒌᓴᔅ ᒥᓯᐙ ᑳᐦ ᐄᑖᑦ ᐅᔮᔨᐤ, “ᔮᒀᒦᒄ, ᐋᑳ ᒑ ᒌ ᒧᔥᑖᓈᔨᐦᑎᒫᒑᔮᒄ ᐋ ᐃᔥᐱᔥ ᐐ ᐃᔮᔮᒄ ᒑᒀᓐ᙮ ᐙᔥ ᑖᐹ ᓂᒥᔮᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐙᔪᑎᓰᑦ ᐊᐙᓐ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᒫᓯᒋᐦᓰᒀ ᒑ ᑐᑖᑯᑦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᐹᔨᒀᐤ ᒌᐦ ᑖᐤ ᐋ ᒥᓰᒋᓰᑦ ᓈᐹᐤ, ᐋ ᒌ ᐃᔮᑦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᓈᔥᒡ ᐋ ᒥᔪ ᓂᐦᑖᐅᒋᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ᐋᒄ ᑳ ᐄᑖᔨᐦᑎᐦᒃ, ‘ᔖᔥ ᓂᒧᐃ ᓂᑖᐱᔥᒋᓂᑖᓐ ᒥᓯᐙ ᒑ ᒌ ᓂᐦᐋᐅᔥᑖᔮᓐ ᐅᐦᐄ ᑳ ᓂᐦᑖᐅᒋᐦᑖᔮᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᐋᒄ ᑳ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᑦ ᑖᓐ ᒑ ᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ᐆ ᒫᒃ ᓂᑭ ᑎᓐ ᒌ ᐃᔨᐤ, ᓂᑭ ᐲᑯᐦᐋᓐ ᐊᓂᐦᐄ ᒥᓯᐙ ᓂᑎᔥᑖᓱᓂᑭᒥᒄ ᐋᒄ ᒑ ᐅᔑᐦᑖᔮᓐ ᐊᑎᑎᐤ ᐋ ᒥᔖᒡ ᒑ ᒌ ᓂᐦᐋᐅᔥᑖᔮᓐ ᒥᓯᐙ ᑳ ᐄᔑ ᓂᐦᑖᐅᒋᐦᑖᔮᓐ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᓂᒑᒀᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ᐋᒄ ᒫᒃ ᒑ ᐄᑏᓱᔮᓐ, ᓄᐎᒡ ᓂᐙᔫᒋᐦᑖᓐ ᒑᒀᓐ ᐊᓂᑖᐦ ᓂᑎᔥᑖᓱᑭᒥᑯᐦᒡ ᒥᐦᒑᑐ ᐱᐳᓐ ᒑ ᒌ ᐄᔥᐱᔮᓐ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᐋᐱᑎᓰᓐ᙮ ᔖᔥ ᓂᑭ ᐙᔫᒋᐦᑖᓐ ᒦᒋᒻ ᑭᔮᐦ ᐋ ᒥᓂᐦᒀᔮᓐ ᒑᒀᓐ ᐋᒄ ᒫᒃ ᒑ ᒨᒋᑭᐦᑖᔮᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ᐋᒄ ᒋᔖᒥᓂᑑᐦ ᑳᐦ ᐄᑎᑯᑦ, ‘ᑖᑆᐦ ᓂᒥ ᒌᐃᑆᐦᑳᓐ, ᐊᓅᐦᒡ ᐆ ᒑ ᑎᐱᔅᑳᒡ ᒌ ᐱᒫᑎᓰᐎᓐ ᒋᑭ ᐅᑎᓂᑭᓂᐤ᙮ ᐊᐙᓐ ᒫᒃ ᒑ ᐃᔮᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᓂᐦᐋᐅᔥᑣᓱᔨᓐ ᒑᒀᓐ?’ ” ");
INSERT INTO crl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᐊᐙᓐ ᐐᔨ ᑳ ᒫᐅᒋᐦᑎᒫᓱᑦ ᒑᒀᔨᐤ᙮ ᓂᒧᐃ ᒥᓯᒋᓰᐤ ᐄᑖᔨᒥᑰ ᒋᔖᒥᓂᑑ ᐋ ᑭᓂᐙᐱᒥᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐄᑎᑯᒡ ᐋᑳ ᒑ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᒦᒋᒻ ᐊᓐ ᓈᑐᐙᔨᐦᑎᒫᒄ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᑎᓰᔮᒄ ᑭᔮᐦ ᒫᒃ ᒑᒀᓐ ᒑ ᒋᒋᔥᑭᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ᐙᔥ ᐱᒫᑎᓰᐎᓐ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓐ ᐃᔥᐱᔥ ᐐ ᒦᒋᒻ, ᑭᔮᐦ ᒥᔨᐤ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓐ ᐃᔥᐱᔥ ᐐ ᐋ ᒋᒋᔥᑭᒥᓐ ᒑᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ᒫᒥᑐᓈᔨᒫᑯᒡ ᒫᐦ ᑳᐦᑳᒎᒡ, ᓂᒧᐃ ᓂᐦᑖᐅᒋᐦᑖᐅᒡ ᒑᒀᔨᐤ ᑭᔮᐦ ᓂᒧᐃ ᒫᐅᒋᐦᑖᐅᒡ ᒦᒋᒥᔨᐤ, ᓂᒧᐃ ᐅᔑᐦᑖᐅᒡ ᐊᔥᑖᔓᑭᒥᒄ ᑭᔮᐦ ᒫᒃ ᑖᔑᐱᑖᑭᓐ ᐊᓂᑎᐦ ᒑ ᐊᔥᑖᒡ ᐅᒦᒋᒧᐙᐤ ᐊᔮᐱᒡ ᒫᒃ ᐊᔑᒥᑰᐎᒡ ᒋᔖᒥᓂᑑ᙮ ᒌᔨᐙᐤ ᒫᒃ ᐊᑎᑎᐤ ᒋᒋᔅᑎᒫᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᐃᔥᐱᔥ ᐐ ᐊᓂᒌ ᐱᔮᔒᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ᓂᒧᐃ ᐊᑎᑎᐤ ᒋᑭ ᒌ ᒋᓅᐦᑖᓈᐙᐤ ᐋᑦ ᒥᒄ ᐊᐱᔑᔥ ᒋᐱᒫᑎᓰᐎᓂᐙᐤ ᐋ ᐅᐦᒋ ᐋᔨᒫᔨᐦᑎᒦᐃᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ᐋᑳ ᒑ ᒌᐦ ᑐᑎᒧᐙᒀ ᐊᑎᑎᐤ ᒋᓍᔥ ᒑ ᒌ ᐱᒫᑎᓰᔮᒄ ᐋ ᒥᑯᔥᑳᑖᔨᐦᑎᒫᒄ ᐅᐦᒋ, ᒑᒀᓐ ᒫᒃ ᒑ ᐅᐦᒋ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᐅᐦᐄ ᒑᒀᓂᐦᐄ? ");
INSERT INTO crl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","ᒫᒥᑐᓈᔨᑎᒧᐦᒃ ᒫᐦ ᓃᐲᔅ ᑖᓂᑖᐦ ᐙᐦᒋ ᓂᐦᑖᐅᒋᐦᒡ, ᓂᒧᐃ ᐋᐱᑎᓰᐎᒡ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᑭᔅᒋᒀᓯᐎᒡ, ᐊᔮᐱᒡ ᒫᒃ ᓈᔥᒡ ᒥᔪᔑᐎᒡ ᐋ ᑭᓂᐙᐱᒫᑭᓂᐎᒡ᙮ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᑎ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐃᔥᐱᔥ ᒥᓰᒋᓰᑦ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᔂᓚᒥᓐ ᓂᒧᐃ ᐊᔮᐱᒡ ᐅᐦᒋ ᐃᔥᐱᔥ ᒥᔻᔑᔨᐤ ᐅᒑᒀᓂᒻ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᓂᑖᐦᐅᒋᑖᑭᓂᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ᐙᔥ ᒋᔖᒥᓂᑑ ᓂᐦᑖᐅᒋᐦᑖᐤ ᒥᔥᑯᔑᐤᐦ ᒑ ᒥᔪᓈᑯᐦᒡ ᐊᔅᒌ᙮ ᐊᓐ ᒥᔥᑯᔑᐤᐦ ᐋ ᒥᔪᓈᑯᐦᒡ ᐊᓅᐦᒡ ᑳᔑᑳᒡ, ᐙᐱᐦᒑ ᔖᔥ ᑭᑎ ᒌ ᐹᔥᑖᐤ ᑭᔮᐦ ᒑ ᒌ ᒥᒍᔅᑖᐙᐱᓂᑭᓂᐎᒡ᙮ ᐋᒄ ᒫᒃ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᓈᐦᑖᐅᒋᐦᑖᒀ ᒥᔥᑯᔑᐤᐦ ᒑ ᒌ ᐅᐦᒋ ᒥᔻᔑᒡ ᐊᔅᒌ ᒑᔥᑎᓈᔥ ᒋᑭ ᒌᐦ ᑐᑎᒫᑯᐙᐤ ᒑ ᒌ ᒥᔨᑖᒄ ᒑᒀᔨᐤ ᒑ ᒋᒋᔥᑭᒸᒄ᙮ ᑖᑆᐦ ᐊᐱᔖᔑᐤ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“ᐊᑳᐐ ᒫᒃ ᒨᔥ ᒋᑭ ᐅᐦᒋ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᒑᒀᓐ ᒑ ᒦᒋᔮᒄ ᑭᔮᐦ ᒑᒀᓐ ᒑ ᒥᓂᐦᒀᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ᒥᓯᐙ ᐊᐙᓐ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᑳ ᑳ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᒨᔥ ᒥᑯᔥᑳᑖᔨᐦᑎᒥᐦᐄᑰ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ᙮ ᑰᐦᑖᐐᐙᐤ ᒫᒃ ᒋᔅᒑᔨᐦᑎᒻ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒸᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓐ ᓃᔥᑎᒻ ᒑ ᒌ ᓈᓂᑐᐙᔨᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑖᒄ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑭᔮᐦ ᐋ ᐄᔑ ᓂᑏᐙᔨᐦᑎᒸᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ᐊᑳᐐ ᓵᒋᓯᒄ, ᐋ ᑎᑭᐙᔑᔑᔮᒄ, ᐙᔥ ᑰᐦᑖᐐᐙᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑖᑦ ᓈᔥᑖᑆᐦ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑰ ᒑ ᒌ ᒥᔨᑖᒄ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ᐊᑖᐙᒑᒄ ᐊᓐ ᒑᒀᓐ ᐋ ᐄᔑ ᑎᐱᔮᐅᓯᔮᒄ ᐋᒄ ᒑ ᒥᔮᑯᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᔓᐎᔮᓐᐦ᙮ ᐙᔥ ᐆ ᐄᔑ ᑐᑎᒫᒀ ᒋᔖᒥᓂᑑ ᒋᑭ ᑎᐱᐦᐊᒫᑯᐙᐤ ᓈᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᐙᔥ ᑖᓐ ᒑ ᐄᔑ ᑎᐱᐦᐊᒫᑖᒄ ᒋᔖᒥᓂᑑ ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᐃᔅᒀᐱᔨᐤ ᐙᔥ ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᒌ ᑭᒑᒧᑎᒫᑯᓈᐙᐤ ᑭᔮᐦ ᒥᓂᑑᔑᒡ ᓂᒧᐃ ᒋᑭ ᒌ ᐃᔮᔪᐦᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ᑖᓂᑖᐦ ᑳᓄᐙᔨᐦᑖᑯᐦᒡ ᒌ ᒥᓯᒋᓰᐎᓂᐙᐤ ᐋᑯᑖᐦ ᒨᔥ ᒑ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ᐃᔮᔅᑭᐐᒄ ᐋ ᐊᔓᐙᐱᒫᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒥᑐᓐ ᒋᐱᐦ ᐄᑖᔅᐱᓱᓈᐙᐤ ᑭᔮᐦ ᒌ ᐙᔥᑖᓂᒫᑭᓂᐙᐤ ᒋᐱᐦ ᓯᔅᑭᐦᐋᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ᒧᔮᒻ ᐋᐱᒋᐦᐋᑭᓂᒡ ᐋ ᐊᔓᐙᐱᒫᒡ ᐅᒋᒫᒧᐙᐤ ᒑ ᒌ ᐹᒋ ᒌᐙᔨᒡ ᐋ ᒌ ᓈᒋᒥᑯᔖᔨᒡ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᔨᒡ ᒋᐱᐦ ᐃᓯᓈᑯᓯᓈᐙᐤ᙮ ᑎᑯᔑᓃᔨᒑ ᑏᐙᐦᒡ ᒋᑭ ᐋᐱᐦᐊᒧᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ᑭᑎ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᒫᒃ ᐊᓂᒌ ᐋᐱᒋᐦᐋᑭᓂᒡ ᒥᔅᑳᑯᑣᐙ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒧᐙᐤ ᐋ ᒌ ᐃᔮᔅᑭᐐᔥᑎᐙᒡ᙮ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ, ᐊᓐ ᐅᒋᒫᐤ ᑭᑎ ᐃᔮᔅᑭᐎᐤ ᐐᔨ ᒀᔅᒌᐱᓐ ᒑ ᒌᐦ ᑐᑎᒧᐙᑦ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᑯᑦ ᐋᒄ ᒫᒃ ᒑ ᓂᑑᒫᑦ ᒑ ᒌ ᒦᒋᓱᔨᒡ, ᐙᐙᒡ ᐐᔨ ᒋᑭ ᐎᔨᔥᑎᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ᑭᑎ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᐋᐱᒋᐦᐋᑭᓂᒡ ᒑ ᐃᔮᔅᑭᐐᔥᑐᐙᒡ ᐄᔥᐱᐦ ᑎᑯᔑᓃᔨᒑ ᐅᒋᒫᒧᐙᐤ ᐋᑎ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᒑ ᑭᔮᐦ ᒫᒃ ᑆᔥᑎᐤ ᑎᑯᔑᓃᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ᐐᐦ ᓂᔅᑐᐦᑎᒧᒄ ᐆ᙮ ᒧᔮᒻ ᐊᐙᓐ ᐐᒋᐦᒡ ᐋᐦ ᑖᑦ ᒋᔅᒑᔨᒫᑦ ᒫᒃ ᒋᒧᑎᔅᒃ ᒑ ᐹᒋ ᑎᑯᔑᓃᔨᒡ, ᒋᐱᐦ ᐃᔮᔅᑭᐎᔥᑎᐙᐤ᙮ ᐋᑐᒡ ᐐᐦ ᒋᐱᐦ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᒥᒄ ᒑ ᒌ ᐄᔑ ᑭᒑᒧᑎᔨᒡ ᐊᓂᑎᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒦᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐃᓯᓈᑯᐦᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᒨᔥ ᒑ ᒌ ᐃᔮᔅᑭᐎᔮᒄ᙮ ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᑎ ᑎᑯᔑᓐ ᑖᓂᑖᐦ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᐹᔣᔨᒫᒀ ᒑ ᒌ ᑎᑯᔑᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ᐲᑎᕐ ᒌ ᐃᔨᐤ, “ᑎᐹᔨᐦᒋᒑᔨᓐ ᓃᔮᓐ ᐋ ᒥᒄ ᒋᑎᔨᒥᐦᐄᓈᓐ ᐆ ᑎᐹᒋᒧᐎᓐ ᑳ ᐐᐦᑎᒥᓐ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᐊᔨᒥᐦᐋᐅᑖ?” ");
INSERT INTO crl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᐦ ᐄᑖᐤ, “ᐋᐱᒋᐦᐋᑭᓐ ᑯᐃᔅᒄ ᑳᐦ ᑐᑎᐦᒃ ᐅᑖᐱᑎᓰᐎᓐ ᑭᔮᐦ ᑳ ᐄᑆᐦᑳᑦ ᐋᐅᒄ ᒑ ᐅᐙᔮᐱᒥᑯᑦ ᐅᒋᒫᒻ ᐐᔨ ᒑ ᒌ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑭᔮᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᐙᑦ ᓂᐦᐋᐤ ᒑ ᒌ ᐄᔑ ᐊᔑᒫᑭᓂᐎᔨᒡ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐊᔑᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ᑭᑎ ᔑᐙᔨᒫᑭᓂᐤ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᒥᔅᑭᐙᑭᓅᒑ ᑯᐃᔅᒄ ᐋᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑖᐱᑎᓰᐎᓐ ᐄᔥᐱᐦ ᑎᑯᔑᓃᔨᒑ ᐅᒋᒫᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᑭ ᒥᔨᑰ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ ᒥᓯᐙ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᐙᑦ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ᒥᒄ ᒫᒃ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᐦᑳ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ, ᐋᔥᒄ ᓈᐅᔖᔥ ᒑ ᐃᔥᐱᔥ ᑎᑯᔑᐦᒃ ᒦᓐ ᓅᒋᒫᒻ, ᐄᑖᔨᐦᑎᐦᑳ᙮ ᐋᒄ ᒫᒃ ᓈᔥᒡ ᓂᓈᐦᑳᒋᐦᐋᒑ ᐊᓂᔮᔨᐤ ᐐᒋᐋᐱᒋᐦᐋᑭᓐ ᑳ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ ᐋ ᐅᑎᑖᒥᐦᐙᑦ ᑭᔮᐦ ᒥᒄ ᒦᒋᓱᒑ ᑭᔮᐦ ᒌᔥᒀᐹᒑ, ");
INSERT INTO crl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ᐄᔥᐱᐦ ᐅᒋᒫᒻ ᑎᑯᔑᓃᔨᒑ ᐋᐦᐋᑳ ᐋᔥᒄ ᐅᐦᒋ ᐹᔣᔨᒫᑦ ᑖᓐ ᒥᒄ ᒑ ᐃᔥᐱᔥ ᒌᔑᑳᔨᒀ ᑭᔮᐦ ᒫᒃ ᒑ ᐃᔥᐲᔨᒀ, ᐋᒄ ᒑ ᒌ ᐄᔑ ᓂᓈᐦᑳᑖᔨᒧᑦ ᒫᒃ ᐊᓂᑖᐦ ᒑ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐋᑳ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ ᐋᐦ ᑖᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐐᐦᑎᒧᐙᑦ, ᐋᐦ ᐄᑖᑦ, “ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᐅᒋᒫᒻ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐋᐦᐋᑳ ᒫᒃ ᐃᔮᔅᑭᐐᑦ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑭᓅᑦ ᑭᑎ ᒥᔥᑎᐦ ᐱᐱᓯᔅᑖᐦᐙᑭᓂᐤ ᐋ ᒥᒫᑯᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ᐋᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐋᑳ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᒥᑯᑦ ᐅᒋᒫᒻ ᒑ ᒌ ᐄᔑ ᑐᑎᐦᒃ ᐋᒄ ᒫᒃ ᐋᐦ ᑐᑎᐦᒃ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᐋᑳ ᒑ ᑐᑎᒧᑯᐱᓈ ᑭᑎ ᒫᑯᐦᐋᑭᓂᐤ ᑭᔮᐦ ᐐᔨ, ᒥᒄ ᒫᒃ ᐊᐱᔒᔥ ᒥᒄ ᑭᑎ ᐱᔑᔥᑖᐦᐙᑭᓂᐤ᙮ ᐙᔥ ᒌ ᐎᓂᑐᑎᒻ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒃ᙮ ᐊᓐ ᒥᓯᐙ ᐊᐙᓐ ᒥᔥᑏᐦ ᑳ ᒥᔮᑭᓅᑦ, ᒥᔥᑏᐦ ᒋᑭ ᓂᑎᐙᔨᐦᑎᒫᑰ ᒋᔖᒥᓂᑑ, ᐋᒄ ᒫᒃ ᐊᓐ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᑳ ᒥᔮᑭᓅᑦ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᒋᑭ ᓂᑎᐙᔨᐦᑎᒫᑰ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ᒌᓴᔅ ᒌ ᐃᔨᐤ, “ᐋᐅᒄ ᐆ ᐙᐦᒋ ᑎᑯᔑᓂᔮᓐ ᒧᔮᒻ ᐋ ᐹᒋ ᐃᔥᒀᓯᒫᓐ ᐆ ᐊᔅᒌ ᒑ ᒌ ᐃᓯᓈᑯᓯᔮᓐ᙮ ᑭᒫ ᒫᒃ ᔖᔥ ᒌ ᐎᔨᐦᑖᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ᐙᔥ ᓈᔥᑖᑆᐦ ᑭᑎ ᐋᔨᒥᓐ ᒑᒀᓐ ᒑ ᐄᔑ ᓂᒋᔥᑭᒫᓐ, ᓄᐎᒡ ᒫᒃ ᓂᒥᑯᔥᑳᑖᔨᐦᑖᓐ ᑭᒫ ᔖᔥ ᒥᔮᔅᑮᒫᓐ ᐋ ᐄᑖᔨᐦᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ᒋᑎᐄᑖᔨᐦᑎᓈᐙᐤ ᐋ ᐙᐦᒋ ᑎᑯᔑᓂᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒑ ᒌ ᑎᑯᐦᒡ? ᓂᒧᐃ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᒌ ᐹᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᐱᐦᑳᓂᐱᔨᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ᒧᔮᒻ ᐹᔨᑯᐅᑖᓂᐤ ᐋ ᓂᔮᔨᒡ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐄᔥᑳᑑᐎᒡ᙮ ᓂᔥᑐ ᐊᓂᒌ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᓂᐦᐄᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᓃᔓ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᒌ ᓃᔓ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐋᔨᐦᑎᒸᐅᒡ ᐊᓂᔮᔨᐤ ᓂᔥᑐ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ᐅᐦᑖᐐᒫᐤ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐄᔥᑳᑑᐎᒡ ᐅᑯᓯᔅᐦ, ᑭᔮᐦ ᐅᑳᐐᒫᐤ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐄᔥᑳᑑᐎᒡ ᐅᑖᓂᔅᐦ᙮ ᑭᔮᐦ ᐅᓯᑯᓯᒫᐤ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᓂᐦᐋᑭᓂᔅᒀᒻ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐄᔥᑳᑑᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ᒌᓴᔅ ᐋᔨᐤᐦ ᑳᐦ ᐋᑎ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᐋ ᐙᐱᒫᒄ ᑭᔥᑭᐎᓂᔥᒄ ᐊᓂᑖᐦ ᐲᓯᒻ ᐋ ᐱᐦᒋᔑᒧᑦ ᐄᑖᐦᒑ ᑏᐙᐦᒡ ᒋᔑᓈᐙᐤ ᒑ ᒋᒨᐦᒡ, ᑖᑆᐦ ᒫᒃ ᒋᒨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ᑭᔮᐦ ᐋ ᒨᔑᐦᑖᔮᒄ ᐋ ᔖᐎᓂᐦᐊᐦᒡ ᒋᔑᓈᐙᐤ ᒑ ᒋᔒᑖᒡ, ᒋᔒᑖᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ᒌᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐋᐦᑳᓱᔮᒄ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᒑ ᐄᔅᐱᔨᒡ ᒥᒄ ᐋ ᑭᓂᐙᐱᐦᑎᒫᒄ ᐊᔅᒌ ᑭᔮᐦ ᒌᔑᒄ᙮ ᑖᓂᑖᐦ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᒌ ᓂᔅᑑᓂᒫᒄ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᔑ ᑐᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐊᓅᐦᒡ ᑳᔑᑳᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“ᒑᒀᓐ ᐙᐦᒋ ᐋᑳ ᒌ ᐎᔮᔨᐦᑎᒫᓱᔮᒄ ᑖᓐ ᐊᓐ ᑯᐃᔅᒄ ᒑᒀᓐ ᒑ ᒌ ᐄᔑ ᑐᑎᒧᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ᓈᐹᐤ ᒫᒃ ᒫᒥᔑᒥᔅᒃ ᒑᒀᔨᐤ ᐋ ᒌ ᐄᔑ ᐎᓂᑐᑎᒧᑦ, ᑐᑖᔅᑳ ᒫᒃ ᒑ ᒌ ᐄᑐᐦᑏᔅᒃ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ, ᒋᐱᐦ ᑯᒋᐦᐋᐤ ᐱᑎᒫ ᓃᔥᑎᒻ ᒑ ᒌ ᒥᔪ ᐊᔨᒥᐦᐄᑦ ᐋᑳ ᒑ ᒌ ᐄᑐᐦᑏᔅᒃ ᐊᓂᑖᐦ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᒋᐱᐦᒋᐦᐄᑦ ᐊᓂᑖᐦ ᐋ ᐐᐦ ᐄᑐᐦᑏᔅᒃ᙮ ᐋᑳ ᒫᒃ ᑐᑎᒥᓈ ᐆ ᐋᒄ ᐊᓐ ᑳ ᑎᐹᔅᑯᓂᒑᑦ ᒑ ᐱᒋᔅᑎᓂᔅᒃ ᐊᓂᑖᐦ ᐄᔑ ᒋᐱᐦᐅᐙᔓᐤ ᐋᐦ ᑖᔨᒡ᙮ ᒑ ᒋᐱᐦᐆᔅᒡ ᐊᓂᒌ ᒋᐱᐦᐅᐙᔓᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ᐆ ᒫᒃ ᐄᔅᐱᔨᐦᒑ ᒋᐐᐦᑎᒫᑎᓐ ᑖᐹ ᒋᑭ ᒌ ᐎᔨᐐᔨᓐ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐹᑎᔥ ᒥᑐᓐ ᒌ ᑎᐱᐦᐊᒥᓈ ᑖᓐ ᒑ ᐄᔑ ᑎᐱᐦᐅᓱᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ᐊᓐ ᒫᒃ ᒫᒀᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐄᔨᔨᐅᒡ ᐋ ᒌ ᐐᐦᑎᒧᐙᒡ ᒌᓴᔅᐦ ᑖᓐ ᑳᐦ ᑐᑎᐙᑭᓂᐐᒡ ᐱᔅᒡ ᐄᔨᔨᐤ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᔨᒡ᙮ ᒋᐦᒋᐅᒋᒫᐤ ᐹᔨᓕᑦ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐋ ᒌ ᓂᐱᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒫᒀᒡ ᐋ ᒌ ᐐ ᒥᒋᔥᑖᐦᐋᒧᐙᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᑎᐄᑖᔨᐦᑎᓈᐙᐤ ᐋ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ ᐋ ᓅᑯᓃᔨᒡ ᐊᐅᔅᑖ ᐐᔨᐙᐤ ᐋ ᒌ ᒥᒋᐦᑑᑎᒧᐙᑯᐱᓈ ᐃᔥᐱᔥ ᐐ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᑳᓕᓖᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ᙮ ᒥᔔ ᐋᑳ ᒀᔅᑳᑎᓰᔮᒀ ᐋᐅᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᒑ ᓂᔑᐎᓈᒋᐦᐄᑯᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ᒋᒋᔥᒋᓯᓈᐙᐤ ᐋ ᓂᔮᓈᓈᐅᔖᑉ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᓵᐃᓗᐊᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋ ᒌ ᐱᑎᑯᐦᐅᑯᒡ ᑳ ᐃᔥᐹᓈᔨᒡ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ? ᒋᑎᐄᑖᔨᐦᑎᓈᐙ ᐋ ᒌ ᓅᑯᓃᔨᒡ ᐐᔨᐙᐤ ᐊᐅᔅᑖ ᐋ ᒌ ᒥᒑᑎᓯᒡ ᐃᔥᐱᔥ ᐐ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ? ");
INSERT INTO crl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ᙮ ᓂᑐᐦᑎᒧᒄ ᒫᐦ, ᒥᔔ ᐋᑳ ᒀᔅᑳᑎᓰᔮᒀ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᑭ ᐃᔮᔪᐦᐅᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ᒌᐦ ᐄᑖᐤ, “ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐋ ᒌ ᐃᔮᐙᑦ ᒥᓯᔔᒥᓈᐦᑎᒄ ᐋ ᓂᐦᑖᐅᒋᔨᒡ ᐊᓂᑖᐦ ᐅᔔᒥᓈᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ᐋᒄ ᐹᔨᒀᐤ ᐋ ᒌᔑᑳᔨᒡ ᒌ ᓂᑎᐙᐦᐋᐤ ᒑ ᒥᓂᔑᐎᔨᒀᓂᐦᐄ ᐊᓂᔮᔨᐤ ᒥᔥᑎᒄ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒦᓂᔑᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ, ‘ᑭᓂᐙᐱᐦᑏ ᒫᐦ, ᐋᔑᑯᒻ ᐱᐳᓐ ᓂᒌᑎᑯᔑᓐ ᐅᑎᐦ, ᓂᔥᑐ ᐱᐳᓐ ᐃᔥᐱᔥ, ᒑ ᒌ ᓂᑑᒋᔅᒑᔨᒥᒃ ᐆ ᒥᓯᔔᒥᓈᐦᑎᒄ ᒫᓂᔑᐅᒀ᙮ ᓂᒧᐃ ᒫᒃ ᒑᒀᓐ ᓂᒥᔅᑳᓐ ᒑ ᒌ ᓂᐦᑖᐅᒋᐦᒡ ᐊᓂᑎᐦ, ᓈᑣᒄᐦ ᐋᑯᔥ, ᒑᔅᑳᐦ ᒋᒥᓲ ᐊᓂᑎᐦ ᐊᔅᒌᐦᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ᐋᒄ ᒫᒃ ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᒌᐦ ᐄᑖᐤ, ‘ᐊᑳᐐ ᐱᑎᒫ ᐱᒫᔨᒻ, ᒦᓐ ᐹᔨᒄ ᐱᐳᓐ ᑭᑎ ᐄᔑᑳᐳ᙮ ᓂᑭ ᒨᓂᐦᐙᐤ ᐊᓂᑖᐦ ᐙᔅᑳ, ᐋᒄ ᒑ ᐊᔥᑖᔮᓐ ᐊᓂᑖᐦ ᒑᒀᓐ ᒑ ᒌ ᐅᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ᒑᒃ ᒫᒃ ᒦᓂᔓᐎᒑ ᒦᓐ ᐱᐳᓃᔨᒑ ᒋᑭ ᒥᔻᔨᐦᑖᓈᓂᐤ᙮ ᐋᑳ ᒫᒃ ᒦᓂᔓᐎᒑ, ᐋᑯᔥ ᒋᑭ ᓈᑣᑭᐦᐙᑭᓂᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ᐹᔨᒀᐤ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᒌᓴᔅ ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ᐃᔅᒀᐤ ᒫᒃ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᒌ ᐲᐦᒋᔥᑳᑯᑦ ᐋ ᒌ ᑐᑖᑯᑦ ᓂᔮᓈᓈᐅᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᒑ ᒌ ᐃᔥᐱᔥ ᐋᐦᑯᓯᑦ ᐋ ᒌ ᒫᔅᑳᒋᐱᔅᑯᒃ ᐋᐦᐋᑳ ᐅᐦᒌ ᑯᐃᔅᑯᑳᐳᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ᐄᔥᐱᐦ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᒌ ᓂᑑᒫᐤ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐃᔅᒀᐤ, ᔖᔥ ᒥᑐᓐ ᒌ ᒦᓂᐙᒋᐦᐄᑭᐎᓐ ᑖᓐ ᑳ ᐄᑖᔅᐱᓈᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ᑳ ᑖᐦᒋᓈᑦ᙮ ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᑯᐃᔅᑯᑳᐳ ᐊᓐ ᐃᔅᒀᐤ ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ᐋᒄ ᒫᒃ ᐊᓐ ᑳ ᓃᑳᓂᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᓈᔥᑖᑆᐦ ᒌ ᒋᔑᐙᔔ, ᒌᓴᔅᐦ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᐙᔨᐤᐦ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᑯᑣᔥᒡ ᑎᐦᑎᓐ ᐋ ᒌᔑᑳᒡ ᒑ ᒌ ᐋᐱᑎᓰᓈᓂᐎᒡ, ᐋᑯᑖᐦ ᐅᑎᐦ ᒋᐱᐦ ᐹᒋ ᑎᑯᔑᓈᐙᐤ ᒫᒀᒡ ᐊᓂᐦᐄ ᐋ ᒌᔑᑳᒑᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᑯᐎᔮᒄ, ᓂᒧᐃ ᐐ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ᑎᐹᔨᐦᒋᒑᓯᐤ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᒌᔨ ᑳ ᐊᔨᒥᐦᐋᑳᓱᔨᓐ, ᐋᑎ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ ᓂᒧᐃ ᐋ ᐊᔮᐱᒡ ᒌ ᓂᑑᐋᐱᐦᑯᓈᐤ ᒋᑣᓂᑭᒻ ᑭᔮᐦ ᒫᒃ ᒋᒥᔅᑐᓱᒻ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᑦ ᐊᓂᑖᐦ ᒑ ᒥᓂᐦᒀᑦ? ");
INSERT INTO crl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ᐋᒄ ᒫᒃ ᐆ ᐃᔅᒀᐤ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒋ ᐋᓃᔅᒑᐦᒡ ᐱᒫᑎᓰᑦ, ᓂᔮᓈᓈᐅᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᒌ ᐃᔥᐱᔥ ᒫᐦᑯᐱᑎᑰ ᒥᒋᒥᓂᑑ, ᓂᒧᐃ ᐋ ᐃᓯᓈᑯᓂᔨᐤ ᒑ ᒌ ᐋᐱᐦᑯᓈᑭᓅᑦ ᐋᐦ ᐋᑎ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᓍᔨᒥᑯᑦ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᓈᔥᑖᑆᐦ ᒌ ᐱᐱᒫᒫᔨᒧᔨᐤ᙮ ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᑐᑎᒥᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ᐋᒄ ᒌᓴᔅ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, “ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ? ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ᒧᔮᒻ ᐊᓐ ᔒᒥᓐ ᑳ ᐊᐱᔒᔑᑦ ᒫᔅᑎᕐᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᐦᒡ ᒋᐦᒋᒌᔑᒄ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᔒᒥᓐ ᐙᑎᓈᑦ ᓈᐹᐤ ᐋ ᐱᒋᔅᑎᓈᑦ ᐊᓂᑖᐦ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ᒑᒃ ᓈᐦᑖᐅᒋᔨᒡ, ᒥᔥᑎᒄ ᓂᔮᓂᑯᑐᓐᐦ ᓄᐎᒡ ᐲᒀᓂᐦᑖᐅᒋᔨᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓐ ᔒᒥᓐ᙮ ᐱᔮᔒᔑᒡ ᒫᒃ ᐋᑯᑖᐦ ᐙᒋᔅᑐᓂᐦᑳᓱᒡ ᐊᓂᑎᐦ ᐋ ᐅᑎᐦᑯᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒥᔥᑎᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ᒦᓐ ᒫᒃ ᒌ ᐄᔑ ᑯᒀᒋᒫᐤ, “ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ? ");
INSERT INTO crl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ᒧᔮᒻ ᐱᔣᔮᐃᐦᑯᓈᐤ ᐅᐦᐱᓯᑭᓐ ᐋᐅᒄ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ, ᒌᑭᐎᓂᒻ ᐃᔅᒀᐤ ᐱᔣᔮᐃᐦᑯᓈᐤ ᐅᐦᐱᓯᑭᓂᔨᐤ ᒥᔥᑏᐦ ᐱᐦᒀᔑᑭᓂᐦᒡ, ᒥᓯᐙ ᒫᒃ ᐅᐦᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ᒌᓴᔅ ᒌ ᐋᑎ ᒋᔅᑯᑎᒫᒑᐤ ᑖᓂᑖᐦ ᑳᐦ ᐋᑎᐙᐅᑎᐦᑎᐦᒃ ᒋᔖᐃᐦᑖᐎᓐ ᑭᔮᐦ ᐋᐦ ᐋᑎ ᐃᔨᐦᑎᑯᓃᔨᔨᒡ ᐃᐦᑖᐎᓂᔥ ᐋᒸᔮ ᐅᐦᒋ ᐅᑎᐦᑎᐦᒃ ᒉᕉᓯᓕᒥᔨᐤ ᐊᓂᑖᐦ ᑳ ᐐᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ᒌ ᑯᒀᒋᒥᑰ ᒫᒃ ᒌᓴᔅ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒥᒄ ᐋ ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒋᑭ ᐱᒫᒋᐦᐋᑭᓂᐎᒡ?” ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, ");
INSERT INTO crl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒋᑭ ᑯᒋᐦᑖᐅᒡ ᒑ ᒌ ᐲᐦᒑᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ, ᓂᒧᐃ ᒫᒃ ᑭᑎ ᒌᐦ ᑑᐎᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᓲᐦᒃ ᑯᒋᐦᑖᒄ ᒑ ᒌ ᐲᐦᒑᔮᒄ ᐊᓂᑖᐦ ᐅᐦᒋ ᐊᓐ ᑳ ᔖᑯᐙᒡ ᐃᔥᒀᐦᑖᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ᐋᔥᒄ ᒫᒃ ᐋᑳ ᐙᐦᒋ ᐲᐦᒑᐙᒀ, ᐄᔥᐱᐦ ᒋᐳᐦᐙᒑ ᒋᔅᑐᑭᓐ ᐊᓐ ᑳ ᑎᐹᔨᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᐎᔨᐐᑎᒥᐦᒡ ᓃᐴᔮᒀ ᐋ ᒥᒥᑣᐦᐄᒑᔮᒄ ᒋᑭ ᐃᔨᓈᐙᐤ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐹᒋ ᐋᐱᐦᐊᒨᓈᓐ᙮’ ᐋᒄ ᒫᒃ ᒑ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᑖᒄ, ‘ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐋᐱᐦᐊᒫᑎᓈᐙᐤ ᐙᔥ ᓂᒧᐃ ᒋᒋᔅᒑᔨᒥᑎᓈᐙᐤ, ᓂᒧᐃ ᑭᔮᐦ ᓂᒋᔅᒑᔨᐦᑖᓐ ᑖᓂᑖᐦ ᐙᐦᒋᔮᒄ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ᐋᒄ ᒫᒃ ᒑ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᒄ, ‘ᒋᒌ ᐐᒋᒦᒋᓲᒥᑎᓈᓐ, ᒋᒌ ᐐᒋᒥᓂᐦᒀᒥᑎᓈᓐ ᑭᔮᐦ ᒋᒌᐦ ᑖᓐ ᓂᑎᐃᐦᑖᐎᓈᐦᒡ ᐋ ᒋᔅᑯᑎᒫᒑᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ᒦᓐ ᒫᒃ ᐊᔮᐱᒡ ᒋᑭ ᐄᑎᑯᐙᐤ, ‘ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᑖᓂᑖᐦ ᐙᐦᒋᔮᒄ, ᐄᒑᐦᑖᒄ ᓈᑖᐦ ᒥᓯᐙ, ᒌᔨᐙᐤ ᑳ ᒥᒋᐦᑑᑎᒫᒄ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“ᓈᔥᑖᑆᐦ ᓲᐦᒃ ᒋᑭ ᒫᑑᓈᐙᐤ ᑭᔮᐦ ᒋᑭ ᒥᒥᑣᔮᐱᑖᓯᓈᐙᐤ ᐄᔥᐱᐦ ᐙᐱᒫᒀᒑ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓵᒃ, ᒉᑭᑉ, ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐋᐦ ᑖᒡ ᐐᔨᐙᐤ ᐊᓂᑖᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ, ᒌᔨᐙᐤ ᒫᒃ ᐎᔨᐐᐙᐱᓂᑭᐎᔮᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ᑭᑎ ᑎᑯᔑᓂᒡ ᐄᔨᔨᐅᒡ ᐙᐱᓅᑖᐦᒡ, ᒌᐙᑎᓂᐦᒡ, ᐲᓯᒸᑖᐦᒡ ᑭᔮᐦ ᐹᔅᑖᒌᐙᑎᓂᐦᒡ ᐋ ᐅᐦᒌᒡ ᒑ ᐹᒋ ᒦᒋᓱᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ᐙᔥ ᐊᓂᒌ ᑳ ᐄᑖᔨᒫᑭᓂᐎᒡ ᐋᐦᐋᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᒋᑭ ᒋᔅᑖᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ, ᑭᔮᐦ ᒫᒃ, ᐊᓂᒌ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᑳ ᐄᑖᔨᒫᑭᓂᐎᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᒀᒡ ᒌᐦ ᑖᐅᒡ ᐹᕆᓰᒡ ᐋ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᒫᒌᐦ ᐄᒑᐦᑖᐦ ᐅᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᐃᔨᐦᒡ ᓈᑖᐦ ᐄᑐᐦᑖ, ᐙᔥ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᒋᐐᐦ ᓂᐱᐦᐄᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᓂᑑᐐᐦᑎᒫᒄ ᐊᓐ ᒥᐦᒑᓯᐤ ᐦᐁᕆᑦ, ᓂᐎᔨᐐᑎᔑᐦᐅᒫᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᑭᔮᐦ ᓂᒦᓂᐙᒋᐦᐄᒫᔨᐤ ᐄᔨᔨᐤ ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᑭᔮᐦ ᐙᐱᐦᒑ ᐋᐅᒄ ᐊᔮᐱᒡ ᒑ ᑎᔮᓐ᙮ ᐹᑎᔥ ᒦᓐ ᓈ ᒌᔑᑳᒑ ᐋᒄ ᒑ ᒌᐦᔑᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ᐊᔮᐱᒡ ᓂᐱᐦ ᐄᑐᐦᑖᓐ ᑖᓂᑖᐦ ᐙᐦ ᐄᑐᐦᑖᔮᓐ ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᑭᔮᐦ ᒦᓐ ᐙᐱᐦᒑ ᑭᔮᐦ ᒫᒃ ᐊᐅᓯᐙᐱᐦᒑ ᔖᔥ ᓂᐱᐦ ᑖᓐ ᐊᓂᑖᐦ ᐙᐦ ᐄᑐᐦᑖᔮᓐ᙮ ᐙᔥ ᒥᓯᐙ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑳ ᓂᐱᐦᐋᑭᓂᐎᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ᒌᔨᐙᐤ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔮᒄ, ᑳ ᓂᐱᐦᐋᑯᒡ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᑳ ᐹᐦᐱᒧᓯᓈᑎᐦᐅᒫᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐊᒫᑖᒄ, ᒥᐦᒑᐦᑣᐤ ᑳ ᐐᐦ ᒫᐅᓯᑯᐱᑎᑎᑯᒡ ᐊᓂᑖᐦ ᐄᔑ ᐋᐦ ᑖᔮᓐ, ᒧᔮᒻ ᐹᐦᑭᐦᐋᐦᒀᓐ ᐋᐦ ᑐᑎᐙᑦ ᐅᐹᑭᐦᐋᐦᒀᓂᔒᒻ, ᔒᐹ ᐅᑎᐦᑭᑯᓂᐦᒡ ᐋ ᐄᔑ ᒫᐅᓯᑯᓈᑦ ᐋ ᐐᐦ ᓈᓈᑭᒋᐦᐋᑦ᙮ ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᑳ ᐐᐦ ᑐᑖᑎᑯᒡ᙮ ᒥᒄ ᓂᒧᐃ ᑰᐦᒋ ᐱᒋᔅᑎᓈᐙᐤ ᐆ ᒑ ᒌ ᑐᑖᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ᒋᑭ ᓂᑭᑎᒫᑯᓈᐙᐤ ᒋᐦᒋᐙ ᒥᑐᓐ ᐋ ᓂᔔᓈᑎᐦᒡ᙮ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐙᐱᒥᓈᐙᐤ ᐹᑎᔥ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᒌ ᐃᔨᔮᒄ, ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓄᑦ ᒑ ᒌ ᐋᔨᒦᔥᑎᒧᐙᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᒌᓴᔅ ᒌ ᐄᑐᐦᑖᐤ ᒑ ᒌ ᓂᑑᒦᒋᓱᐙᑦ ᐊᓂᑖᐦ ᐐᒋᔨᐦᒡ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᑳ ᓃᑳᓈᔨᐦᑖᑯᓰᔨᒡ ᐹᕆᓰ᙮ ᐋᒄ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᐋ ᓈᓈᑭᒋᐦᐋᒡ ᒌᓴᔅᐦ ᒑ ᑎᔨᒀᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ ᓈᐹᐤ ᐋ ᐎᑎᔅᑭᐱᔥᑖᑯᑦ ᒌᓴᔅ᙮ ᐊᓐ ᒫᒃ ᓈᐹᐤ ᒌᐦ ᑎᑯᓂᔨᐤ ᐋᐦ ᐄᑖᔅᐱᓈᑦ᙮ ᐅᔅᐱᑐᓐᐦ ᑭᔮᐦ ᐅᔅᑳᑦᐦ ᒌ ᐹᒋᐱᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ᒌᓴᔅ ᒌ ᑯᒀᒋᒫᐤ ᐊᓂᔮᔨᐤ ᐹᕆᓰ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ, “ᐋᐤ ᐋ ᐋᑎᔅᑖᒡ ᐊᔨᒥᐦᐋᐤ ᐎᔨᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ ᐋ ᑯᐃᔅᑯᓈᑯᐦᒡ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᐙᓂᐎᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᑯᐃᔅᑯᓈᑯᓂᒀ?” ");
INSERT INTO crl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐐᐦ ᒋᔅᑐᐎᒡ᙮ ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᓂᒸᑦ ᐅᑎᐦᒌᔨᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᑳ ᒦᓂᐙᒋᐦᐋᑦ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᒑ ᒌ ᒫᒋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐹᕆᓰ, “ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ, ᐊᐙᓐ ᐅᑯᓯᔅᐦ ᑭᔮᐦ ᒫᒃ ᐅᒥᔅᑐᓰᒻ, ᐴᐦᒋᐱᔨᐦᒡ ᐊᓂᑖᐦ ᐋ ᐙᔮᔨᒡ, ᐱᔑᔑᐦᒄ ᓂᐲᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑎᐦ, ᓂᒧᐃ ᐋ ᒋᐱᐦ ᐱᐦᑯᐦᐋᐤ ᐋᐦᐋᑦ ᒫᒀᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ᒥᑐᓐ ᒫᒃ ᒌ ᒋᐳᑐᓈᐦᐙᐤ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ᒌᓴᔅ ᒫᒃ ᒌ ᐙᐱᒫᐤ ᐱᔅᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓂᑐᒫᑭᓂᐎᔨᒡ ᐋ ᐅᐙᔨᐱᔨᒡ ᑖᓂᑖᐦ ᐊᓂᑎᐦ ᒫᐅᒡ ᐋ ᐅᒋᒫᐙᔨᐦᑖᑯᓃᔨᒡ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“ᐊᐙᓐ ᓂᑑᒥᔅᑳ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᒸᐦᒡ ᐋ ᒌ ᒋᐦᒋᐐᒋᑐᓈᓂᐐᒡ ᐊᑳᐐ ᐅᐙᔨᐱᐦᐄᔓᐦ ᐊᓂᑎᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐐᒡ, ᐙᔥ ᒋᑭ ᒌ ᐃᓯᓈᑯᓐ ᒑ ᒌ ᑖᑦ ᐊᓂᑎᐦ ᐊᐙᓐ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᒌᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ᒋᑭ ᒌ ᐹᒋ ᓂᑎᐙᐱᒧᒄ ᐊᓐ ᐊᐙᓐ ᑖᐱᔥᑯᓐ ᑳ ᓂᑑᒥᑖᒄ, ᒑ ᒌ ᐄᑎᔅᒃ, ‘ᐄᒑᐱᐦ ᐊᓂᑎᐦ, ᐋᒄ ᐊᓐ ᐊᐅᔅᑖ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒑ ᐅᐙᔨᐱᐦᐋᑭᓅᑦ ᐊᓂᑎᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐎᔨᒡ ᐊᓂᑎᐦ ᑳ ᐊᐴᑦ᙮’ ᐋᒄ ᒫᒃ ᒑ ᐱᐱᒫᒫᔨᒧᔨᓐ ᐋᐦᑎᐱᔨᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ᐆ ᒫᒃ ᒋᐱᐦ ᐄᔑ ᑐᑖᓐ, ᐊᐙᓐ ᓂᑑᒥᔅᑳ ᐋ ᒥᑯᔖᑦ ᐊᓂᑖᐦ ᓂᑎᐐ ᒋᐱᐦ ᐅᐦᑎᐱᐦᐄᓱᓐ, ᐋᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᑯᔖᑦ ᒋᑭ ᒌ ᐄᑎᒄ, ‘ᓂᐐᒑᐙᑭᓐ, ᐋᔥᑎᒻ ᐅᑎᐦ ᐹᒋ ᐊᐱᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐐᒡ᙮’ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓂᑐᒫᑭᓂᐎᒡ ᒑ ᒋᔅᒑᔨᒥᔅᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ᐙᔥ ᐊᐙᓐ ᑳ ᐐᐦ ᒋᔅᑖᔨᒥᑯᓰᑦ ᒋᔖᒥᓂᑑ ᒋᑭ ᑎᐱᐦᑖᔨᒧᐦᐄᑰ᙮ ᐊᓐ ᒫᒃ ᑳ ᑎᐱᐦᑖᔨᒦᓱᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᓂᑑᒥᑯᑦ ᐋ ᒥᑯᔖᔨᒡ, “ᐋ ᒥᑯᔖᔨᓐ ᒫᐦ, ᐊᑳᐐ ᒥᒄ ᒋᐐᒑᐙᑭᓂᒡ ᓂᑑᒥᒡ ᑭᔮᐦ ᒫᒃ ᒌᒋᐄᔨᔨᐎᒡ ᑭᔮᐦ ᒫᒃ ᒋᐙᐦᑯᒫᑭᓂᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᓯᒋᓰᔨᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐹᔓᒡ ᐋ ᐐᒋᒥᑣᐤ, ᐙᔥ ᑭᑎ ᒌ ᐃᓯᓈᑯᓂᔨᐤ ᑭᔮᐦ ᒌᔨ ᒦᔥᑯᒡ ᒑ ᒌ ᓂᑑᒥᔅᒡ, ᒑ ᒌ ᑐᑖᔅᒡ ᒀᔅᒡ ᑭᔮᐦ ᒌᔨ ᑖᓂᔮᔨᐤ ᑳᐦ ᑐᑐᑣᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ᑎᔨᑯᒡ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᓂᑑᒥᒡ, ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒫᔅᒋᓂᐦᑖᐅᒋᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᓂᐦᑖᐅᐦᑖᒡ, ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ᐋᒄ ᒫᒃ ᒑ ᒋᔖᐙᑐᑖᑭᐎᔨᓐ ᐅᒌ ᐋ ᒌ ᓂᑑᒥᑣᐤ, ᐙᔥ ᑖᐹ ᒋᑭ ᒌ ᒌᐙ ᑐᑖᑯᒡ ᑖᓂᔮᔨᐤ ᑳᐦ ᑐᑐᑣᐤ᙮ ᒋᔖᒥᓂᑑ ᒋᑭ ᑎᐱᐦᐊᒫᒄ ᐄᔥᐱᐦ ᐎᓂᔥᑳᑣᐙ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᐊᓂᒌ ᑳ ᒀᔅᑳᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ᒌᐦ ᑖᔨᐤ ᓈᐹᐤ ᐋ ᐐᑎᐱᒥᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓂᑎᐦ ᒦᒋᓱᓈᐦᑎᑯᐦᒡ᙮ ᐄᔥᐱᐦ ᐱᔮᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ᒌ ᐄᑎᑰ ᒫᒃ ᐋᓂᔮᔨᐤ ᓈᐹᐤᐦ, “ᓄᐎᒡ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᒑ ᒦᒋᓱᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᒥᑯᔖᓂᐎᔨᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ, “ᐹᔨᒀᐤ ᓈᐹᐤ ᐋ ᒌ ᐃᔮᔅᑰᔥᑖᑦ ᐋ ᒥᔖᔨᒡ ᒥᑯᔖᓂᔨᐤ, ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒌ ᓂᑑᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒑ ᒦᒋᓱᓈᓂᐎᔨᒡ ᒌ ᐄᑎᔑᐦᐙᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᓂᑑᐄᑖᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓂᑐᒫᑭᓂᐎᔨᒡ, ‘ᐹᒋ ᑎᑯᔑᓂᒄ ᒋᑎᐄᑎᑯᓈᐙᐤ, ᔖᔥ ᒥᓯᐙ ᒑᒀᓐ ᐃᔮᔅᑰᔥᑖᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ᒥᓯᐙ ᒫᒃ ᐋ ᐃᑎᔑᒡ ᒌ ᐄᑖᐅᒡ ᐋᑳ ᒑ ᒌ ᑎᑯᔑᒡ᙮ ᐊᓐ ᓈᐹᐤ ᓃᔥᑎᒻ ᑳ ᓂᑎᐙᐱᒫᑭᓅᑦ ᐋᒄ ᑳᐦ ᐃᔨᑦ, ‘ᓂᒥᐦᒋᔨᐙᓯᓐ ᐋᐦᐋᑳ ᒌ ᐄᑐᐦᑖᔮᓐ ᐙᔥ ᓂᒌ ᐅᑎᓂᒑᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ, ᐱᑎᒫ ᒫᒃ ᓂᑭ ᓂᑑᑭᓂᐙᐱᐦᑖᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ᐊᓐ ᑯᑎᒃ ᓈᐹᐤ ᐋᒄ ᑳᐦ ᐃᔨᑦ, ‘ᓂᒥᐦᒋᔨᐙᓯᓐ ᐋᐦᐋᑳ ᒌ ᐄᑐᐦᑖᔮᓐ, ᐊᓅᐦᒡ ᐙᔥ ᒥᑖᐦᑐ ᒥᔅᑐᔓᒡ ᑳ ᒌ ᐅᑖᐹᒡ ᓂᒌ ᐅᑎᓂᒑᓐ᙮ ᐱᑎᒫ ᒫᒃ ᓂᑭ ᓂᑑᑯᒋᐦᐋᐅᒡ᙮ ᓂᒧᐃ ᒫᒃ ᓂᑎᐃᔥᐱᔒᓐ ᒑ ᒌ ᐄᑐᐦᑖᔮᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ᒦᓐ ᑯᑎᒃ ᓈᐹᐤ ᒌᐦ ᐄᑖᐤ, ‘ᐊᓅᐦᒡ ᐙᔥ ᐆ ᓂᒌ ᒋᐦᒋᐐᐎᓐ, ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐋᑳ ᒌ ᑎᑯᔑᓂᔮᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“ᐊᓐ ᒫᒃ ᐋᐱᒋᐦᐋᑭᓐ ᒌ ᓂᑑᐐᐦᑎᒧᐙᐤ ᐅᒋᒫᒻ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓂᑐᒫᑭᓂᐎᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᐅᒋᒫᐤ ᑳ ᐐ ᒥᑯᔖᑦ ᓈᔥᑖᑆᐦ ᒌ ᒋᔑᐙᔔ᙮ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ, ‘ᒌᐲ, ᒫᒌᐦ ᒥᓯᐙ ᐄᑐᐦᑖ ᐅᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᒑ ᐹᔔᑣᐤ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ, ᑳ ᒫᔅᒋᓂᐦᑖᐅᒋᒡ, ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳᐃᔅ ᓂᐦᑖᐅᐦᑖᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ᐐᐱᒡ ᒫᒃ ᒌ ᑎᑯᔑᓐ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ, ‘ᔖᔥ ᓂᒌᐦ ᑐᑖᓐ ᑖᓐ ᑳ ᐄᔑ ᓂᑎᐙᔨᒥᔨᓐ ᒑ ᒌᐦ ᑐᑎᒫᓐ ᐋᔥᒄ ᒫᒃ ᒥᔥᑏᐦ ᑎᐙᐤ ᐊᑎᑎᐤ ᑯᑎᑭᒡ ᒑ ᒌ ᑎᑯᔑᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ᑳᐦ ᐄᑎᑯᑦ ᐅᒋᒫᒻ, ‘ᐊᓂᑖᐦ ᐄᑐᐦᑖ ᒫᔅᑭᓈᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᓅᐦᒋᒦᐦᒡ ᒑ ᓂᑑᒥᑣᐤ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᑎᑯᔑᐦᒡ ᒑ ᒌ ᐅᐦᒋ ᓵᑭᔅᒋᓈᒡ ᐆ ᓂᐙᔅᑳᐦᐄᑭᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ᒋᐐᐦᑎᒫᑎᓐ, ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᓂᒌ ᓃᔥᑎᒻ ᑳ ᓂᑐᒥᒀᐤ ᑭᑎ ᐅᐦᒋ ᑯᒋᔥᑎᒧᒡ ᐅᔮᔨᐤ ᓂᒥᑯᔖᓂᔨᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐊᐙᔨᐤᐦ ᐋ ᐱᐹᐐᒑᐅᑯᑦ ᒌᓴᔅ, ᒌ ᑭᓂᐙᐱᒫᐤ ᒫᒃ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“ᐊᐙᓐ ᐙᐦ ᓅᔔᔥᑯᐙᒀ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔮᓐ, ᓃᔨ ᐊᑎᑎᐤ ᓂᑭ ᓵᒋᐦᐄᒄ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐋᑦ ᐅᐦᑖᐐᐦ ᒫᒃ ᐅᑳᐐᐦ, ᐐᐤᐦ, ᐅᑎᐙᔑᔒᒻᐦ ᑭᔮᐦ ᒫᒃ ᑎᐱᔨᐙ ᐐᒋᔖᓐᐦ᙮ ᓃᔨ ᐊᐅᔅᑖ ᓂᑭ ᓵᒋᐦᐄᒄ ᐃᔥᐱᔥ ᐐᔨ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᑖᑦ ᑎᐱᔨᐙ ᐅᐱᒫᑎᓰᐎᓐ᙮ ᐋᑳ ᒫᒃ ᒌ ᑏᒑ ᓂᒧᐃ ᓂᑭ ᒌ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑎᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ᐊᐙᓐ ᐋᑳ ᐱᒧᔮᒑ ᐅᑖᔑᑖᔮᐦᑎᑯᒻ ᐋ ᐹᒋ ᓅᔔᔥᑯᑦ ᓂᒧᐃ ᓂᑭ ᒌ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑎᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᑦ ᐊᐙᓐ ᐋ ᐐᐦ ᐐᔨᑳᐳᐦᑖᑦ ᓂᑎᐙᐲᐅᑭᒥᑯᔨᐤ, ᓃᔥᑎᒻ ᑭᑎ ᐎᔮᔨᐦᑎᒻ ᑖᓐ ᐎᔮᔥ ᒑ ᐃᔥᐱᔥ ᐄᔅᐱᔨᐦᐄᑯᑦ ᔓᐎᔮᓐ, ᑭᔮᐦ ᒫᒃ ᑖᑆᐦ ᑖᑉ ᐋ ᐃᔥᐱᔥ ᐃᔮᐙᒀ ᔓᐎᔮᓐ ᒑ ᒌ ᒌᔑᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ᐋᑳ ᒫᒃ ᓃᔥᑎᒻ ᓂᑑᒋᔅᒑᔨᐦᑎᐦᑳ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᐄᔅᐱᔨᔨᒡ ᒋᑭ ᒌ ᐃᓯᓈᑯᓯᐤ ᒑ ᒌ ᓅᐦᑖᐱᔨᑦ ᔓᐎᔮᓐ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᒌ ᒌᔑᐦᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᐅᔑᐦᑖᑦ᙮ ᐙᐱᐦᑎᒥᔨᒑ ᒫᒃ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐋᐦ ᐄᔅᐱᔨᑦ ᒋᑭ ᒫᔮᔨᒥᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ᒋᑭ ᐄᑎᑰ, ‘ᐆ ᓈᐹᐤ ᒌ ᒋᐦᒋᐦᑖᐤ ᐋ ᐐᔨᑳᐳᐦᑖᑦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᓂᒧᐃ ᒫᒃ ᒌ ᒌᔑᐦᑖᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ᐋᒄ ᒦᓐ ᐅᔮᔨᐤ ᑳᐦ ᐋᑎ ᐃᔨᑦ ᒌᓴᔅ, “ᑭᔮᐦ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᑦ ᒋᐦᒋᐅᒋᒫᐤ ᒥᑖᐦᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋ ᑎᔑᔨᒡ ᐅᓂᑐᐱᔨᒻ, ᐋ ᐐ ᓂᑑᐱᔨᐦᑭᐦᑎᐙᑦ ᒫᒃ ᑯᑎᒃ ᒋᐦᒋᐅᒋᒫᐤ ᓃᔥᑎᓂᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋ ᑎᔑᔨᒡ ᐅᓂᑐᐱᔨᒥᔨᐤ, ᐱᑎᒫ ᑭᑎ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑰ ᑖᑆᐦ ᒑ ᒌ ᐃᔥᐱᔑᐦᐋᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ᐋᑖᔨᐦᑎᒧᒀ ᒫᒃ ᒑ ᒫᑯᐦᐄᑯᑦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᐦᒋᐅᒋᒫᐤ, ᑭᑎ ᐄᑎᔑᐦᐙᐤ ᐱᔅᒡ ᓈᐹᐤ ᒑ ᒌ ᓂᑑᓂᒋᔥᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐋᔥᒄ ᐋ ᐃᔮᐅᓈᑯᓰᔨᒡ ᐋᒄ ᒑ ᑯᒀᒋᒫᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᑎᒡ ᒑᐦ ᐋᑳ ᒌ ᓂᑑᐱᔨᐦᑭᐦᑖᑐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, ᐋᐅᒄ ᐊᓐ ᒫᒃ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐊᐙᓐ ᑳ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑ ᒌ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑎᐎᒃ᙮ ᐹᑎᔥ ᑭᑎ ᐱᒋᔅᑎᓂᒻ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᑦ, ᐋᒄ ᐃᔮᒄ ᒑ ᒌ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑎᐎᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ᐋᒄ ᒫᒃ ᒦᓐ ᒌᓴᔅ ᐊᑎᑎᐤ ᑳᐦ ᐋᑎ ᒋᔅᑯᑎᒧᐙᑦ ᐅᔮᔨᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐅᐦᒋ, ᐋᐦ ᐃᔨᑦ, “ᒥᔻᔑᐤ ᔒᐅᐦᑖᑭᓐ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐲᒑ ᐋᑳ ᒑ ᐃᔥᐱᑯᓂᒀ ᐊᓐ ᔒᐅᐦᑖᑭᓐ ᒑ ᐄᔥᐱᑯᓂᑯᐱᓈ ᓂᒧᐃ ᑎᑯᓐ ᑖᓂᑖᐦ ᒑ ᒌ ᑐᑖᑭᓂᐎᔨᒡ ᓰᐅᐦᑖᑭᓂᒡ ᒑ ᒌ ᐃᔅᐱᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᒋᑭ ᒌ ᐎᔮᔥᑖᐱᑎᓐ ᐙᐙᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ᙮ ᐋᑯᔥ ᒫᒃ ᐃᔨᐙ ᑭᑎ ᐙᐱᓂᑭᓂᐤ᙮ ᔮᒀᐦ ᓂᑑᐦᑎ ᒑ ᒌ ᓂᔅᑐᐦᑎᒥᓐ ᑖᓐ ᓂᐦᐋᐤ ᐙᐦ ᐄᔑ ᐐᐦᑎᒫᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ᐹᔨᒀᐤ ᐊᓂᒌ ᑳ ᒫᒨᔥᒋᓈᐦᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᒌ ᐹᒋ ᓂᑐᐦᑎᐙᐅᒡ ᒌᓴᔅᐦ ᐋ ᐹᒋ ᒥᐦᒑᑎᒡ᙮ ᑭᔮᐦ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᐋ ᒋᔅᒑᔨᒫᑭᓂᐎᒡ ᐋ ᒥᒑᑎᓯᒡ ᒌ ᐹᒋ ᑎᑯᔑᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ᐹᕆᓰᒡ, ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᐋᔨᒨᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᐆ ᓈᐹᐤ ᐅᐐᒑᐙᑭᓂᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᑳ ᒥᒑᑎᓰᔨᒡ ᑭᔮᐦ ᐐᒋᒦᒋᓲᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“ᐃᓯᓈᑯᓯᑦ ᒫᐦ ᐊᐙᓐ ᒥᑖᐦᑐᒥᑎᓂᐤ ᐋ ᒌ ᐃᔮᐙᑦ ᒫᓂᔥᒑᓂᔥ, ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐎᓂᔑᓃᔨᒡ, ᑖᓐ ᒋᐱᐦ ᐄᔨᐦᑐ? ᒋᐱᐦ ᓂᑭᑖᐤ ᐊᓂᔮᔨᐤ ᐹᔨᑯᔥᑖᒥᑎᓂᐤ ᐹᔨᑯᔥᑖᐅᔖᑉ ᒫᓂᔥᒑᓂᔥ ᒑ ᒌ ᓂᑑᓈᓂᑐᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᐎᓂᔑᓃᔨᒡ, ᐹᑎᔥ ᒥᔅᑭᐙᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ᐄᔥᐱᐦ ᒫᒃ ᒥᔅᑭᐙᒑ ᓈᔥᑖᑆᐦ ᒋᑭ ᒥᔻᔨᐦᑎᒻ, ᐋᒄ ᐅᑎᐦᑎᒥᓂᐦᒡ ᒑ ᑖᐦᑎᐦᐋᑦ, ᒑ ᓂᑑᒌᐙᐦᑎᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ᐋᒄ ᒑ ᓂᑑᒫᑦ ᐅᐐᒑᐙᑭᓐᐦ ᑭᔮᐦ ᐐᒋᔖᓐᐦ ᒑ ᐄᑖᑦ, ‘ᐐᒋᒥᔻᔨᐦᑎᒨᒥᒄ ᐙᔥ ᓂᒥᔅᑭᐙᐤ ᐊᓐ ᓂᒫᓂᔥᒑᓂᔒᒻ ᑳ ᐎᓂᐦᐄᒃ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ᑳᐦ ᐃᔨᑦ ᒦᓐ ᒌᓴᔅ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᐅᔅᑖ ᐐᔨ ᒨᒋᒑᔨᐦᑎᒥᐦᐄᐙᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐹᔨᒄ ᐅᒥᒋᐦᑣᐤ ᐋ ᓈᑖᑦ ᒋᔖᒥᓂᑑ ᐋ ᐐᐦ ᒀᔅᑳᑎᓰᑦ, ᐃᔥᐱᔥ ᐐ ᐹᔨᑯᔥᑖᒥᑎᓂᐤ ᐹᔨᑯᔥᑖᐅᔖᑉ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐄᔨᔨᐅᒡ ᔖᔥ ᐋ ᒀᔅᑳᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᑯᑎᒋᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᑖᓐ ᐋ ᑎᒃ ᐃᔅᒀᐤ ᐋ ᐃᔮᐙᑦ ᒥᑖᐦᑐ ᔔᐎᔮᓈᐱᔅᒄ, ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐎᓂᐦᐋᑦ᙮ ᓯᔅᑭᐦᐊᒻ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ, ᒋᔑᐦᐄᒑᐤ ᑭᔮᐦ ᐊᓂᑎᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᒡ, ᒥᑐᓐ ᓈᓂᑎᐙᐱᒫᐤ ᐹᑎᔥ ᒫᔅᑭᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ᐄᔥᐱᐦ ᒫᒃ ᒫᔅᑭᐙᑦ, ᐋᒄ ᒫᒨ ᓂᑑᒫᑦ ᐅᐐᒑᐙᑭᓐ ᑭᔮᐦ ᐐᒋᔖᓐ ᐋᐦ ᐄᑖᑦ, ‘ᓈᔥᑖᑆᐦ ᓂᒥᔻᔨᐦᑖᓐ ᐋ ᒌ ᒥᔅᑭᐎᒃ ᐊᓐ ᔔᐎᔮᓈᐱᔅᒄ ᑳ ᐎᓂᐦᐄᒃ᙮ ᐐᒋᒥᔻᔨᐦᑎᒨᒥᒄ ᒫᐦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ᐋᒄ ᒦᓐ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᐦᒃ ᐊᓐ ᐃᔅᒀᐤ ᐋ ᒌ ᒥᔅᑭᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᐎᓂᐦᐋᑦ ᐅᔔᔮᓂᒻ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑖᓐᒋᓂᒻᐦ, ᒥᔻᔨᐦᑎᒥᔨᐤ ᐄᔥᐱᐦ ᐹᔨᒄ ᐅᒥᒋᐦᑣᐤ ᐋ ᒀᔅᑳᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ᒌᓴᔅ ᒫᒃ ᒦᓐ ᒌ ᐐᐦᑎᒻ ᑯᑎᒋᔨᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ, ᐋᐦ ᐃᔨᑦ, “ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐋ ᒌ ᓃᔑᔨᒡ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ᐊᓐ ᒫᒃ ᐅᔒᒫᐤ ᒌᐦ ᐄᑖᐤ ᐅᐦᑖᐐᐦ, ‘ᓅᐦᑖ, ᐹᒋ ᒥᔨᐦ ᐊᓅᐦᒡ ᐊᓐ ᒑᒀᓐ ᐋᓂᔅᒑ ᒑ ᑎᐱᔨᐙᐅᓯᔮᓐ᙮’ ᐋᒄ ᒫᒃ ᐅᐦᑖᐐᐙᐤ ᑳ ᒫᑎᓂᒫᑯᒡ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ᓂᒧᐃ ᓈᐅᔥ ᑳᐦ ᐋᑎ ᑎᒥᐦᒋᓂᐦᒃ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓐ ᐅᔒᒫᐤ, ᐋᒄ ᐊᓂᑖᐦ ᐙᐦᔨᐤ ᐊᔅᒌᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᒫᔥᑎᓈᑦ ᐅᔔᔮᓂᒻ ᐋ ᒌᔥᒀᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᑳ ᒫᔥᑎᓈᑦ ᐅᔔᔮᓂᒻ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳᐦ ᑖᑦ ᒌ ᐱᒥᐱᔨᔨᐤ ᐋ ᐅᐙᓂᐦᑭᑖᓂᐎᔨᒡ᙮ ᒑᒃ ᑳ ᐅᐙᓂᐦᑭᑖᑦ ᑭᔮᐦ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ᐋᒄ ᑳᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ ᐹᔨᒄ ᓈᐹᐤ ᐊᓂᑎᐦ ᐋ ᐅᐦᒌᔨᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ, ᑳᐦ ᐄᑎᔑᐦᐅᑯᑦ ᒑ ᒌ ᓈᓈᑭᒋᐦᐄᒫᑦ ᐅᑰᐦᑰᔑᒥᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ᐋ ᐃᔥᐱᔥ ᔒᐅᑖᑦ ᒫᒃ ᒑᒃ ᓈᔥᒡ ᒌ ᒧᔥᑖᓈᔮᔨᐦᑎᒻ ᒑ ᒌ ᒌᔥᐳᐦᐄᓱᑦ ᐊᓂᔮᔨᐤ ᑰᐦᑰᔥ ᐅᒦᒋᒥᔨᐤ, ᓂᒧᐃ ᒫᒃ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᐊᔑᒥᑰ ᒑᒀᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“ᒑᒃ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᑯᐃᔅᑯᑯᑖᔨᒡ ᐅᒫᒥᑐᓈᔨᐦᒋᑭᓐ, ᒌ ᐄᑖᔨᐦᑎᒻ, ‘ᐋᑎ ᐋ ᑎᔑᔨᒡ ᓅᐦᑖᐐ ᐅᑖᐱᒋᐦᐋᑭᓐ ᒥᓯᐙ ᐋ ᑖᐱᔥᑯᔨᔨᒡ ᐊᔮᐱᒡ ᐄᔅᑯᐱᔨᐅᒡ ᒦᒋᒥᔨᐤ, ᓃᔨ ᒫᒃ ᒑᑳᑦ ᓂᑭᐎᐦᑭᑖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ᓂᑭ ᒋᔅᑐᐦᑖᓐ ᒑ ᓂᑎᐙᐱᒥᒃ ᓅᐦᑖᐐ ᒑ ᐄᑎᒄ, ᓅᐦᑖ, ᓂᒌ ᒥᒋᐦᑐᑎᐙᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒌᔨ ᒋᒌ ᒥᒌᐦᑐᑖᑎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ᓂᒧᐃ ᓂᑎᑖᔨᐦᑖᑯᓯᓐ ᒋᑰᔅ ᒑ ᒌ ᐄᑎᑯᐎᔮᓐ, ᐹᒋ ᐋᐱᒋᐦᐄᐦ ᒫᒃ ᒧᔮᒻ ᐋ ᐄᔑ ᐋᐱᒋᐦᐄᑣᐤ ᒋᑖᐱᒋᐦᐋᑭᓂᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“ᐋᒄ ᒫᒃ ᑳ ᐱᓯᑯᑦ ᒦᓐ ᑳᐤ ᒑ ᓂᑎᐙᐱᒫᑦ ᐅᐦᑖᐐᐦ᙮ ᐋᒄ ᒫᒃ ᐋᔥᒄ ᐋ ᐃᔮᐅᓈᑯᓃᔨᒡ ᒑ ᐃᔥᐱᔥ ᑎᑯᔑᐦᒃ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ, ᒌ ᐙᐱᒥᑰ ᐅᐦᑖᐐᐦ ᐋᒄ ᓈᔥᒡ ᑳ ᒋᔅᑎᒫᒑᔨᒥᑯᑦ᙮ ᐋᒄ ᑳ ᓂᑑᐋᐳᔥᑳᑯᑦ, ᑳ ᐙᐅᒋᐱᑎᑯᑦ, ᑳ ᐅᒑᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ᑳᐦ ᐄᑖᑦ ᐊᓐ ᐅᑯᓯᓯᒫᐤ ᐊᓂᔮᔨᐤ ᐅᐦᑖᐐᐦ, ‘ᓅᐦᑖ, ᓂᒌ ᒥᒋᐦᑐᑎᐙᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒌᔨ ᒋᒌ ᒥᒌᐦᑐᑖᑎᓐ᙮ ᓂᒧᐃ ᓂᑎᑖᔨᐦᑖᑯᓯᓐ ᓂᑯᔅ ᒑ ᒌ ᐃᓯᓂᐦᑳᓯᔨᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“ᒥᒄ ᒫᒃ ᐊᓐ ᐅᐦᑖᐐᒫᐤ ᓯᑑ ᒌ ᓂᑑᒫᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᐐᐦ ᒌᐱᔨᒄ ᒑ ᐹᑖᔮᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᒥᔻᔑᒡ ᐊᑯᐦᑉ ᒑ ᐳᔥᑭᒧᔮᒄ᙮ ᑭᔮᐦ ᑖᐱᒋᔅᒑᐦᐱᓱᓐ ᒑ ᐳᔥᑭᒧᔮᒄ, ᐋᔨᐤᐦ ᒥᔅᒋᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ᑭᔮᐦ ᒑ ᓂᐱᐦᐋᒄ ᐊᓐ ᑳ ᑖᐦᒋᐳᐦᐋᑭᓅᑦ ᒥᔅᑐᔅ, ᒑ ᒥᔪᐦᑭᐙᒄ ᐋᒄ ᒫᒃ ᒑ ᒥᑯᔖᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ᐙᔥ ᐆ ᓂᑯᔅ ᒧᔮᒻ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ ᒌ ᐃᓯᓈᑯᓯᐤ ᐋᒄ ᒧᔮᒻ ᒦᓐ ᑳᐤ ᐋ ᐱᒫᑎᓰᑦ ᐃᓯᓈᑯᓯᐤ, ᒧᔮᒻ ᐋ ᒌ ᐎᓂᔑᐦᒃ ᐋᒄ ᒫᒃ ᒦᓐ ᐋ ᒥᔅᑭᐙᑭᓅᑦ᙮’ ᐋᒄ ᒫᒃ ᑳ ᒌᐦᒋ ᒨᒋᒑᔨᑎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ᐊᓐ ᒫᒃ ᐅᔅᑖᓯᒫᐤ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᒫᒀᒡ ᒌᐦ ᑖᐤ᙮ ᐄᔥᐱᐦ ᑳ ᐹᔣᐱᐦᑎᐦᒃ ᐐᒋᐙᐤ ᒌ ᐹᐦᑎᒻ ᐋ ᒥᑣᒋᔅᑐᐦᒑᓂᐎᔨᒡ ᑭᔮᐦ ᐋ ᒥᑣᓃᒥᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ᑳ ᓂᑑᒫᑦ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ, ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ, ᐋᐦ ᐄᑖᑦ, ‘ᑖᓐ ᐋᐦ ᑎᓈᓂᐎᒡ?’ ");
INSERT INTO crl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ, ‘ᒋᔒᒻ ᒦᓐ ᑳᐤ ᒌ ᑎᑯᔑᓐ ᐋ ᒥᔪ ᐱᒫᑎᓰᑦ, ᐋᒄ ᑰᐦᑖᐐ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐊᓂᔮᔨᐤ ᒥᔅᑐᔥᐦ ᑳ ᑖᐦᒋᐳᐦᐄᒫᑭᓂᐎᔨᒡ ᒑ ᒌ ᒥᑯᔑᐦᐋᑭᓅᑦ ᐊᓐ ᒋᔒᒻ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐊᓐ ᐅᔅᑖᓯᒫᐤ ᒌ ᒋᔑᐙᔔ, ᐋᒄ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐲᐦᒑᐤ᙮ ᐅᐦᑖᐐᐦ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᑳ ᓂᑑᒥᑯᑦ ᒑ ᒌ ᐲᐦᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐅᐦᑖᐐᐦ, ‘ᑭᓂᐙᐱᐦᑏ ᒫᐦ, ᒥᐦᒑᑐᐳᓐ ᐋᒄ ᑳ ᐃᔥᐱᔥ ᐋᐱᑎᔒᔥᑖᑖᓐ ᓂᒧᐃ ᒫᒃ ᓂᐦᑖ ᓅᐦᒋ ᑎᓐ ᐋᑳ ᒑ ᒌ ᓂᓃᐦᑎᒫᓐ ᑖᓐ ᑳᐦ ᐄᑎᔓᐙᔨᓐ᙮ ᒑᒀᓐ ᒫᒃ ᑳ ᐹᒋ ᒥᔨᓐ ᓃᔨ ᒑ ᒌ ᐅᐦᒋ ᐐᒋᒥᑯᔖᒥᒀᐤ ᓂᐐᒑᐙᑭᓂᒡ? ᓂᒧᐃ ᐙᐙᒡ ᐋᑦ ᒥᒄ ᐊᐱᔑᔥ ᐎᔮᔅ ᒋᒥᔨᓐ ᒑ ᒌ ᒥᑯᔖᐙᒑᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ᐆ ᒋᑯᓯᔅ ᑳ ᒌᔥᒀᐱᒫᑎᓰᐙᒑᑦ ᒋᔔᔮᓂᒻ, ᓂᑎᐐ ᐋᐦᔨᑖᐱᒌᐦᐋᑦ, ᐃᔅᒀᐤ ᐋ ᒌ ᒫᔮᔨᒫᑦ, ᐊᓅᐦᒡ ᒌ ᑎᑯᔑᓐ, ᒋᑎᐄᑎᔓᐙᑖᔨᐤ ᒫᒃ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᐦᒋᐳᐦᐄᒫᑭᓂᐎᔨᒡ ᒥᔅᑐᔅ ᒑ ᒌ ᒥᑯᔑᐦᐋᑭᓅᑦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“ᐅᐦᑖᐐᐦ ᒫᒃ ᒌ ᐄᑎᑰ, ‘ᓂᑯᔅ, ᒨᔥ ᐋᐦ ᑖᔮᓐ ᒋᑎᐦᑖᓐ, ᒥᓯᐙ ᐋ ᐄᔑ ᐃᔮᔮᓐ ᒌ ᑎᐱᔨᐙᐅᓯᔨᓐ ᑭᔮᐦ ᒌᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ᐃᓯᓈᑯᓐ ᑖᑆᐦ ᒑ ᒌ ᒨᒋᒑᔨᐦᑎᒥᐦᒄ ᐙᔥ ᒌᒋᔖᓐ ᒧᔮᒻ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ ᒌ ᐃᓯᓈᑯᓯᐤ, ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᒧᔮᒻ ᒦᓐ ᐋ ᐱᒫᑎᓰᑦ ᐃᓯᓈᑯᓯᐤ᙮ ᒧᔮᒻ ᐋ ᒌ ᐎᓂᔑᐦᒃ ᒌ ᐃᓯᓈᑯᓯᐤ, ᐋᒄ ᒫᒃ ᒦᓐ ᐋ ᒥᔅᑭᐙᑭᓅᑦ ᐃᓯᓈᑯᓯᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ᒌᓴᔅ ᒌ ᐐᐦᑎᒧᐙᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ, ᐋᐦ ᐄᑖᑦ, “ᒌᐦ ᑖᐤ ᐋ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᐋ ᒌ ᑎᐹᔨᒫᑦ ᐅᒋᒫᔥᐦ᙮ ᐊᓐ ᒫᒃ ᐅᒋᒫᔥ ᒌ ᓂᓈᑭᑐᐙᔨᐦᑎᒸᐤ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ᒌ ᐹᐦᑎᒥᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᐅᒋᒫᒻᐦ ᓂᑎᐐ ᒥᒄ ᐋ ᒌ ᐄᑖᐱᒋᐦᐄᒫᑦ ᐅᔔᔮᓂᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ᐋᒄ ᑳ ᓂᑑᒥᑯᑦ, ᑳᐦ ᐄᑎᑯᑦ, ‘ᓂᐹᐦᑖᓐ ᐋᔨᑖᒋᒥᑭᐎᔨᓐ ᓂᑎᐐ ᒥᒄ ᐋᐦ ᐄᑖᐱᒋᐦᐄᑦ ᓂᔔᔮᓂᒻ᙮ ᒧᔖ ᒑ ᐐᐦᑎᒥᓐ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐄᑖᐱᒋᐦᐄᑦ᙮ ᔖᔥ ᐊᓅᐦᒡ ᒸᐦᒡ ᓂᒧᐃ ᒋᑭ ᐃᔮᓐ ᐊᓐ ᒋᑖᐱᑎᓰᐎᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ᐊᓐ ᒫᒃ ᐅᒋᒫᔥ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒻ, ‘ᑖᓐ ᒫᒃ ᒑ ᑎᔮᓐ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐄᓱᔮᓐ, ᐋ ᐄᑖᔨᐦᑎᐦᒃ, ᔖᔥ ᓂᑎᓵᔮᔅᑯᓂᒄ ᓅᒋᒫᒻ᙮ ᓂᒧᐃ ᓂᒥᔅᑭᐎᓯᓐ ᐋ ᒨᓂᐦᐄᒑᔮᓐ ᒑ ᒌ ᐄᑖᐱᑎᓰᔮᓐ ᑭᔮᐦ ᓂᔖᒀᔨᒧᓐ ᒑ ᒌ ᓈᓂᑐᑎᒫᔮᓐ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ᓂᒋᔅᒑᔨᐦᑖᓐ ᑖᓐ ᒑ ᑎᔮᓐ ᒑ ᒌ ᐅᐦᒋ ᐅᐐᒑᐙᑭᓂᔮᓐ᙮ ᐋᒄ ᒫᒃ ᐋᑳ ᐃᔮᔮᓈ ᐋᐱᑎᓰᐎᓐ ᐐᔨᐙᐤ ᒑ ᐹᒋ ᓈᓈᑭᑎᐙᔨᒥᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ᐋᒄ ᑳ ᓂᑑᒫᑦ ᒥᓯᐙ ᑳ ᑎᔑᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐊᐅᐦᐋᔓᒫᔨᒡ ᐅᒋᒫᒻ ᒑ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᑳ ᑎᑯᔑᓃᔨᒡ ᑳ ᑯᒀᒋᒫᑦ, ᑖᓐ ᐋ ᐃᔥᐱᔥ ᐊᐅᐦᐋᔓᒥᑦ ᓅᒋᒫᒻ? ");
INSERT INTO crl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, ‘ᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᐦᑐᐎᑦ ᐱᒦ᙮’ ᐋᒄ ᐊᓐ ᐅᒋᒫᔥ ᑳᐦ ᐄᑖᑦ, ‘ᐅᑎᓐ ᐊᓂᐦᐄ ᒋᒥᓯᓂᐦᐄᑭᓐ, ᒌᐲ, ᒦᔅᑯᑎᔑᓂᐦᐋᐦ, ᒥᒄ ᓂᔮᔫᒥᑎᓂᐤ ᐄᑎᓯᓂᐦᐋᐦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᓈᐹᐤ ᑳᐦ ᐄᑖᑦ, ‘ᑖᓐ ᐋ ᐃᔥᐱᔥ ᐋᐅᐦᐋᔓᒥᑦ ᒌᔨ ᓅᒋᒫᒻ᙮’ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, ‘ᐹᔨᒀᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᐦᑐ ᐐᐦᑯᔮᐤ ᐱᐦᒀᔑᑭᓂᒡ᙮’ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᒫᐅᐦᐄ ᒌ ᒥᓯᓂᐦᐄᑭᓐ, ᒦᔅᑯᑎᔑᓂᐦᐋᐦ, ᒥᒄ ᓂᔮᓈᓈᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᐄᑎᓯᓂᐦᐋᐦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","ᐄᔥᐱᐦ ᐊᓐ ᐅᒋᒫᐤ ᐱᔮᐦᑎᐦᒃ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒋᒫᔒᒻᐦ ᒌ ᒫᒥᐦᒋᐦᐄᑰ, ᐄᑆᐦᑳᐤ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑎᒃ ᐋᐦ ᐄᑖᔨᒫᑦ᙮ ᐙᔥ ᐊᓂᒌ ᐋᑳ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᓈᔥᑖᑆᐦ ᑭᔅᒋᐦᐅᒡ ᐋ ᐱᑯᐦᑎᒫᓱᒡ ᒑᒀᔨᐤ ᐃᔥᐱᔥ ᐐ ᐊᓂᒌ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᐱᒋᐦᑖᒄ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᔮᒄ ᒦᓯᒋᓰᐎᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᒥᔪᑐᑎᒫᒄ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐅᐐᒑᐙᑭᓂᔮᒄ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐴᓂᐱᒫᑎᓰᔮᒀ ᐋᒄ ᒫᒃ ᒑ ᐲᐦᑎᑭᐦᐄᑯᐎᔮᒄ ᒥᔻᔨᐦᑖᒧᐎᓂᒡ ᐊᓂᑖᐦ ᑳᒋᒡ ᒑ ᐐᒋᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ᐊᐙᓐ ᑳ ᑖᑆᐅᒑᔨᐦᑖᑯᓯᑦ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᓈᓈᑭᒋᐦᑖᑦ ᐋ ᐊᐱᔖᔑᔨᒡ ᒑᒀᔨᐤ ᒋᑭ ᑖᑆᐅᒑᔨᐦᑖᑯᓯᐤ ᒑ ᒌ ᒥᔪᓈᓈᑭᒋᐦᑖᑦ ᐋ ᒥᔖᔨᒡ ᒑᒀᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᑳ ᑯᐃᔅᒄ ᑐᑎᐦᑳ ᐋ ᓈᓈᑭᒋᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᐋ ᐊᐱᔖᔑᔨᒡ ᒑᒀᔨᐤ, ᓂᒧᐃ ᑯᐃᔅᒄ ᒋᑭ ᒌᐦ ᑐᑎᒻ ᐋ ᓈᓈᑭᒋᐦᑖᑦ ᒑᒀᔨᐤ ᐋ ᒥᔖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ᐋᑳ ᒫᒃ ᑖᑆᐅᒑᔨᒥᑭᐎᓈ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᓈᓈᑭᒋᐦᑖᔨᓐ ᐆ ᐙᔪᑎᓰᐎᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑖᑆᐅᒑᔨᒥᑭᐎᓐ ᒋᐦᒋᐙ ᒦᓯᒋᓰᐎᓐ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ᑭᔮᐦ ᒫᒃ ᐋᑳ ᑖᑆᐅᒑᔨᒥᑭᐎᓈ ᑯᐃᔅᒄ ᒑ ᒌᐦ ᑐᑎᒧᑦ ᑯᑎᒃ ᐊᐙᓐ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ, ᐊᐙᓐ ᒫᒃ ᒑ ᑖᑆᐅᒋᔨᒥᔅᒃ ᒑ ᒌ ᒥᔨᔅᒃ ᒑᒀᔨᐤ ᒌᔨ ᒑ ᒌ ᑎᐱᔨᐙᐎᓯᐎᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ᓂᒧᐃ ᑭᑎ ᒌ ᐋᐱᑎᓰᔅᑎᐙᐤ ᐊᐙᓐ ᓃᔓ ᐅᒋᒫᐤ, ᐙᔥ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᑭᑎ ᐅᐦᑳᑖᐤ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᑭᑎ ᓵᒋᐦᐋᐤ᙮ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᓲᐦᒃ ᑭᑎ ᐋᐱᑎᓰᔅᑎᐙᐤ, ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᓂᐦᐋᔨᐦᑎᒻ ᒑ ᒌ ᐋᐱᑎᔒᔥᑎᐙᑦ᙮ ᓂᒧᐃ ᒋᑭ ᒌ ᐋᐱᑎᓰᔅᑎᐙᐤ ᒋᔖᒥᓂᑑ ᒨᔥ ᐋ ᒫᒥᑐᓈᔨᐦᑎᒫᒄ ᒑ ᒌ ᒥᓯᒋᓰᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","ᐄᔥᐱᐦ ᒫᒃ ᐹᕆᓰᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ ᒌ ᒫᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ, ᐙᔥ ᒌ ᓵᒋᐦᐋᐅᒡ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒋᑎᐃᔑᓈᑯᐦᐄᓯᓈᐙᐤ ᒧᔮᒻ ᐋ ᑯᐃᔅᑯᑖᑎᓯᔮᒄ ᐊᓂᑖᐦ ᐅᐦᑎᔅᑰ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ, ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓐ ᒋᐦᒋᐙ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ᙮ ᐙᔥ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳ ᒋᔅᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᐅᐦᑳᑎᒻ ᐊᓂᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“ᐋᒸᔮ ᐅᐦᒋ ᑎᑯᔑᐦᒃ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᒥᒄ ᐊᓂᔮᔨᐤ ᒧᓱᔅ ᑳ ᒥᓯᓂᐦᐋᐦᒃ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᑎᐦᑯᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐋᔪᐎᑯᓐᐦ ᐊᓂᐦᐄ ᒥᒄ ᑳᐦ ᐋᐱᑎᐦᒡ ᐋ ᒋᔅᑯᑎᒫᒑᓂᐎᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᑖᑦ ᒞᓐ ᐋᒄ ᒥᔻᒋᒧᐎᓐ ᑳ ᐙᐐᐦᑖᑭᓂᐎᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᐋᐦ ᐋᔨᒨᑖᑭᓂᐎᔨᒡ᙮ ᓲᐦᒃ ᒫᒃ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐋᔨᐦᑭᒻ ᐐᐦ ᐲᐦᒑᐆᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᐋᐦᐋᑳ ᔖᔥ ᓂᑎᐙᔨᐦᑖᑯᐦᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑖᑭᓂᐎᔨᒡ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ᙮ ᐋᑎ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᐋᑳ ᑳ ᒌ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᑳ ᐄᑖᔨᐦᑖᑭᓂᐎᔨᒡ ᐊᔮᐱᒡ ᐄᑖᔨᐦᑎᒥᐦᐄᑰ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᓂᓂᐦᐄᐦᑖᑭᓂᐎᔨᒡ ᒥᒄ ᒑ ᐃᔥᐱᔥ ᑎᑯᓃᒀ ᐆ ᐊᔅᒌ ᑭᔮᐦ ᒋᐦᒋᒌᔑᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ᓈᐹᐤ ᐙᐱᓈᑦ ᐐᐤᐦ ᑯᑎᒃ ᒫᒃ ᐃᔅᒀᐤ ᐐᒋᒫᑦ, ᐱᓯᒀᑎᓯᐤ ᐅᔮᔨᐤ ᐋᐦᑎᒃ᙮ ᐋᒄ ᐊᓐ ᓈᐹᐤ ᒑ ᐐᒋᒫᒀ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᐋ ᒌ ᐙᐱᓂᑯᔨᒡ ᐅᓈᐹᒥᔨᐤ, ᐱᓯᒀᑎᓯᐤ ᑭᔮᐦ ᐐᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ᒌᓴᔅ ᒌ ᐐᐦᑎᒻ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐃᔨᑦ, “ᐹᔨᒀᐤ ᒌᐦ ᑖᐤ ᐋ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᓈᔥᒡ ᐋ ᔔᔮᓈᑯᓃᔨᒡ ᐅᒑᒀᓂᒻ, ᓈᔥᒡ ᐋ ᒌ ᒥᓯᒋᓰᐅᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ᒌᐦ ᑖᐤ ᒦᓐ ᑯᑎᒃ ᓈᐹᐤ ᓛᓵᕋᔅ ᐋ ᒌ ᐃᔑᓂᐦᑳᓱᑦ ᓈᔥᒡ ᐋ ᒋᔅᑎᒫᑎᓯᑦ ᐱᔑᔑᐦᒄ ᐋ ᐹᐦᐱᑯᔑᐦᑖᑦ᙮ ᒥᓯᐙ ᐋᐦ ᐋᔅᑎᑎᒃ ᐋ ᒌ ᐅᒥᒌᑦ᙮ ᐎᔨᐐᑎᒥᐦᒡ ᒫᒃ ᐊᓂᑎᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᓯᒋᓰᔨᒡ ᓈᐹᐤ ᐋᑯᑖᐦ ᑳ ᐱᒥᔑᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ᐋ ᐱᑯᓵᔨᐦᑎᐦᒃ ᒑ ᒌ ᐅᐦᒋ ᒦᒋᓲᑦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐱᓂᐦᑎᐙᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᑳ ᒥᓯᒋᓰᔨᒡ ᓈᐹᐤ ᐅᒥᒋᒥᔨᐦᒡ᙮ ᑭᔮᐦ ᐙᐙᒡ ᐊᑎᒻ ᒌ ᑎᑯᔑᓂᔨᐤ ᐋ ᐹᒋ ᓅᐦᒀᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒥᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ᐊᓐ ᑳ ᒋᔅᑎᒫᑎᓯᑦ ᓈᐹᐤ ᒑᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ, ᒌ ᐹᒋ ᐅᑎᓂᑰ ᐋᓐᒋᓐ, ᐊᓂᑖᐦ ᒫᒃ ᐅᐦᐱᒫ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐱᒋᔅᑎᓂᑯᑦ᙮ ᒑᒃ ᑭᔮᐦ ᐊᓐ ᑳ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᒌ ᓂᐦᐄᐦᑯᐙᑭᓂᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ᒥᒋᔥᑯᑖᐦᒡ ᒫᒃ ᐋᐦ ᑖᑦ ᓈᔥᒡ ᐋ ᐙᐐᓯᒑᔨᑎᒃ, ᒌ ᐄᑖᐱᐤ ᐃᔥᐱᒥᐦᒡ, ᑳ ᐙᐱᒫᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋ ᔮᐅᓈᑯᓰᔨᒡ ᓛᓵᕋᔅᐦ ᐋ ᐐᒋᑳᐳᔥᑎᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ᒌ ᑖᑆᐤ ᒫᒃ, ᐋᐦ ᐃᔨᑦ, ‘ᐋᑉᕋᐦᐋᒻ, ᓅᐦᑖᐐᓈᓐ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ᙮ ᐹᒋ ᐄᑎᔓᐦᐆ ᒫᐦ ᓛᓵᕋᔅ ᒑ ᒌ ᑖᐦᑳᑭᒥᓂᐦᒃ ᒥᑯᒋᒃ ᓂᐲᔨᐤ ᒑ ᒌ ᐹᒋ ᑖᐦᒋᓂᐦᒃ ᓂᑖᔨᔨᐤ, ᒑ ᒌ ᐅᐦᒋ ᑎᐦᒋᐱᔨᐦᒡ᙮ ᐙᔥ ᓂᓂᓈᐦᑳᑖᔨᒧᓐ ᐅᑎᐦ ᐃᔥᑯᑖᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“ᐋᒄ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳᐦ ᐄᑖᑦ, ‘ᒌ ᒋᔥᒋᓯᓐ ᐋ ᓂᑯᔅ, ᒫᒀᒡ ᑳ ᐱᒫᑎᓰᔨᓐ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᒥᔪ ᒑᒀᓐ ᒋᒌ ᐃᔮᓐ, ᓛᓵᕋᔅ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪ ᐃᔮᐤ ᒑᒀᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᔖᔥ ᒥᔻᔨᒨ ᐐᔨ ᐅᑎᐦ, ᒌᔨ ᒫᒃ ᒌ ᓂᓈᐦᑳᑖᔨᒧᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ᑭᔮᐦ ᒫᒃ ᑎᑯᓐ ᐅᑎᐦ ᒋᔥᑖᐅᒡ ᐋᐦ ᑖᔨᐦᒄ ᐋᐦ ᐋᑎᑳᒫᓯᓈᓂᐎᒡ ᐋᐦᐋᑳ ᒥᑐᓐ ᐃᓯᓈᑯᐦᒡ ᒑ ᒌ ᐋᔔᐎᔥᑭᒃ ᐊᐙᓐ ᓈᑖᐦ ᐄᔑ ᐋᐦ ᑖᔨᓐ ᑭᔮᐦ ᓈᑖᐦ ᐅᐦᒋ ᒑ ᒌ ᐹᒋ ᐋᔔᐎᔥᑭᒃ ᐊᐙᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ᐋᒄ ᐊᓐ ᑳ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᑳᐦ ᐃᔨᑦ, ‘ᒋᓂᑐᑎᒫᑎᓐ ᒫᒃ, ᓅᐦᑖᐐ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᒑ ᒌ ᐄᑎᔓᐦᐅᑦ ᓛᓵᕋᔅ ᐊᓂᑖᐦ ᓅᐦᑖᐐ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ᓂᔮᔫᒡ ᓃᒋᐄᔨᔨᐎᒡ ᐊᓂᑖᐦ ᒋᐱᐦ ᓂᑑᐃᔮᒀᒥᒫᐤ ᐋᑳ ᒑ ᒌ ᐃᓯᓈᑯᓃᔨᒡ ᐋᔥᒄ ᐊᓂᑖᐦ ᒑ ᒌᐦ ᑖᔨᒡ ᐅᑎᐦ ᐅᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᔨᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ᐋᒄ ᐊᓐ ᑳ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ‘ᒌᒋᐄᔨᔨᐎᒡ ᒋᑭ ᒌ ᐊᔨᒥᐦᑖᐅᒡ ᒧᓱᔅ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒥᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐋ ᐄᔑ ᐃᔮᒀᒥᒫᒡ ᐊᐙᔨᐤᐦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒋᐱᐦ ᓂᓂᐦᐄᐦᑎᒧᒡ ᐊᓂᒌ ᒌᒋᔖᓂᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ᐊᓐ ᒫᒃ ᑳ ᒥᓰᒋᓰᑦ ᓈᐹᐤ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, ‘ᓅᐦᑖ ᐋᑉᕋᐦᐋᒻ, ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᑖᑆᐦᑎᒧᒡ ᐹᑎᔥ ᐊᐙᔨᐤᐦ ᑳᐤ ᒌ ᐎᓂᔥᑳᔨᒑ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᒑ ᒌ ᓂᑎᐙᐱᒥᑯᒡ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᒀᔅᑳᑎᓰᔨᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ᐋᒄ ᒫᒃ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳᐦ ᐄᑖᑦ, ‘ᐋᑳ ᒑ ᐅᐦᒋ ᑐᑎᒧᐙᒀᓂᒌ ᒧᓱᔅ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒥᔨᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᔑᐦᑯᒋᐦᐄᑯᒡ ᒑ ᒌ ᓂᑑᐦᑎᐙᒡ ᐊᐙᔨᐤᐦ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑣᐙ ᐋᑎ ᐋ ᒌ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒨᔥ ᑖᑆᐦ ᒋᑭ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒑ ᑐᑖᑯᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒥᒋᐦᑑᑎᐦᒡ᙮ ᒥᒄ ᒫᒃ ᑭᑎ ᐋᐦᒀᒋᐦᐄᓱᐎᒡ ᐊᓂᒌ ᑳᐦ ᑐᑎᐙᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ᐊᓐ ᐊᐙᓐ ᒑ ᑐᑎᐙᒀ ᒑ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ ᐹᔨᒄ ᐅᔮᔨᐤ ᐊᐙᔑᔥ ᑳ ᑖᑆᔮᔨᒥᔨᒡ ᐊᐅᔅᑖ ᑭᑎ ᒥᔻᔑᔨᐤ ᒑ ᒌ ᒫᐦᑯᐱᑎᒫᑭᓂᐎᔨᒡ ᐋ ᒥᐦᒑᐱᔅᒋᔨᒡ ᐊᓯᓃ ᐅᑯᔮᐦᒡ, ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᒋᐦᒋᑭᒦᐦᒡ ᒑ ᒌ ᐱᑭᔥᑎᐙᐱᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ᔮᒀᒦᒄ ᐋᑳ ᒑ ᒌᐦ ᑐᑎᐙᒄ ᐊᐙᓐ ᒑ ᒌ ᒥᒋᐦᑐᑎᐦᒃ᙮ ᒌᒋᔖᓐ ᒥᒌᐦᑐᑖᔅᑳ ᐐᐦᑎᒨ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐦᑐᑖᔅᒃ᙮ ᒥᐦᒋᔨᐙᓯᒑ ᒫᒃ, ᒑ ᐙᐹᔨᐦᑎᒨᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ᐋᑦ ᒫᒃ ᓃᔣᔥᒡ ᑎᐦᑣ ᒥᒌᐦᑐᑖᔅᑳ ᐹᔨᒄ ᒌᔑᑳᐤᐦ, ᑭᔮᐦ ᒥᒄ ᑎᐦᑣ ᐱᔮᒡ ᓂᑎᐙᐱᒥᔅᑳ ᐋᐦ ᐄᑎᔅᒃ, ‘ᓂᒥᐦᒋᔨᐙᓯᓐ ᑖᓐ ᑳ ᐄᔑ ᒥᒌᐦᑐᑖᑖᓐ,’ ᐊᔮᐱᒡ ᐙᔥ ᒋᐱᐦ ᐙᐹᔨᐦᑎᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐄᑎᑰ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓅᔅᒌᐦᑖᐦ ᐊᑎᑎᐤ ᓂᑖᑆᔮᔨᐦᑎᒧᐎᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑳᐦ ᐄᑖᑦ, “ᐋᑦ ᓈᔥᒡ ᐊᐱᔖᔑᒑ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ ᒧᔮᒻ ᒫᐅᒡ ᑳᐦ ᐋᐱᔒᔑᑦ ᔒᒥᓐ ᑳᐦ ᐋᔅᑎᑎᒃ ᐃᔥᐱᔖᒑ, ᒥᔥᑎᒄ ᒋᑭ ᒌᐦ ᐄᑖᐤ, ‘ᐱᑯᐦᐄᓲ ᐊᓂᑎᐦ ᑳ ᓂᐦᑖᐅᒋᔨᓐ ᐋᒄ ᐊᓂᑖᐦ ᒑ ᐄᔑ ᓂᐦᑖᐅᒋᐦᔨᓲᔨᓐ ᒋᐦᒋᑭᒦᐦᒡ,’ ᒋᑭᑐᑎᒻ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ᒌᓴᔅ ᒦᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᒧᔮᒻ ᐊᓂᑖᐦ ᐋᐱᒋᐦᐋᑭᓐ ᐋ ᓂᐦᑖᐅᒋᐦᒑᑦ ᑭᔮᐦ ᒫᒃ ᒫᓂᔥᒑᓂᔥ ᐋ ᓈᓈᑭᒋᐦᐋᑦ, ᐄᔥᐱᐦ ᒫᒃ ᒑ ᒌᐦᐙᒡ ᐋ ᒌᔥ ᐋᐱᑎᓰᑦ ᒋᑭ ᐄᑎᑰ ᐋ ᐅᒋᒫᒻ? ‘ᐋᔥᑎᒻ, ᐹᒋ ᐲᐦᒑᐦ, ᐹᒋ ᒦᒋᓲ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ᓂᒫ, ᐅᔮᔨᐤ ᒋᑭ ᐄᑎᑰ, ‘ᐹᒋ ᐎᔨᔥᑑᐦ ᐋᒄ ᒫᒃ ᒌᔥ ᒦᒋᓱᔮᓈ, ᐋᒄ ᒌᔨ ᒀᔅᒋᐦᐱᓐ ᒑ ᒦᒋᓱᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᓈᔅᑯᒫᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐋ ᒌᐦ ᑐᑎᒥᔨᒡ ᑖᓂᔮᔨᐤ ᑳ ᐐᐦ ᐄᑖᐱᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ᒌᔨᐙᐤ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᒌᔑᐦᑖᔮᒄ ᒥᓯᐙ ᒑᒀᓐ ᑳᐦ ᐄᑎᔓᒥᑯᐎᔮᒄ ᒑ ᒌ ᐄᐦᑐᑎᒫᒄ, ᒋᐱᐦᐄᓈᐙᐤ, ‘ᐙᔥ ᒥᒄ ᐋᐱᒋᐦᐋᑭᓂᒡ ᓃᔮᓐ᙮ ᓂᒌᐦ ᑐᑖᓈᓐ ᒥᒄ ᐊᓐ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑭᐎᔮᐦᒡ ᒑ ᑐᑎᒫᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ᒫᒀᒡ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒌ ᐱᒧᐦᑖᐤ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᑖᐦᒋᔅᑳᑑᔨᔨᒡ ᓵᒫᕆᔮ ᐊᔅᒌᔨᐤ ᑭᔮᐦ ᒫᒃ ᑳᓕᓖ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ᓂᐦᐋᐤ ᒫᒃ ᐋᑎ ᐅᑎᐦᑎᐦᒃ ᐃᐦᑖᐎᓂᔨᐤ ᒥᑖᐦᑐ ᓈᐹᐤ ᒌ ᓂᒋᐦᐄᑰ ᓈᔥᒡ ᐋ ᒫᔮᑎᓃᔨᒡ ᐅᒥᒌᐙᔅᐱᓈᐎᓂᔨᐤ ᐋ ᐃᔮᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ᐋᐦᐋᑳ ᒫᒃ ᐅᐦᒌ ᐹᔓᒋᑳᐳᔥᑖᑯᑦ᙮ ᐋᒄ ᑳ ᑖᑆᑖᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᒌᓴᔅᐦ, ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒥᓈᓐ ᐆ ᐋ ᐃᓯᓈᑯᓯᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ᒌᓴᔅ ᒫᒃ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᒌᐦ ᐄᑖᐤ, “ᒫᒌᒄ, ᓂᑎᐙᐱᒫᐦᒄ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ᒑ ᒌ ᐙᐱᒥᑖᒄ᙮” ᒫᒀᒡ ᒫᒃ ᐋ ᐃᔥᐱᔑᐱᔨᒡ ᐋ ᓂᑎᐙᐱᒫᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ᒌ ᒦᓂᐙᑎᓰᐆᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᐹᔨᒄ ᓈᐹᐤ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ, ᒌ ᒌᔨᐙᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᒌᓴᔅᐦ, ᐋ ᒋᔣᐙᑦ ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒃ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐆ ᐅᐦᑎᔅᑰ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐋ ᓂᓈᔅᑯᒫᑦ᙮ ᐆ ᒫᒃ ᓈᐹᐤ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᒌ ᐅᐦᒌᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒌ ᒥᑖᐦᑎᔔᒡ ᐊᓂᒌ ᑳ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ᙮ ᑖᓐ ᐋᔨᑎᐦᒡ ᐊᓂᔮᐦᑳ ᐹᔨᑯᔥᑖᐤ? ");
INSERT INTO crl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ᒥᒄ ᐆ ᐹᔨᒄ ᓈᐹᐤ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᑦ ᐋ ᐹᒋ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᐱᓯᑰᐦ, ᐋᒄ ᒫᒃ ᒑ ᒌᐙᔨᓐ, ᐙᔥ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒋᒦᓂᐙᒋᐦᐄᑯᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ᐹᔨᒀᐤ ᐹᕆᓰᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᑖᔨᔥᐱᔥ ᒑ ᐅᑖᐦᒋᐱᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᐅᑖᐦᒋᐱᔨᒑ ᓂᒧᐃ ᒧᔖ ᑭᑎ ᓅᑯᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐃᔨᐤ, ᐹᒋ ᑭᓂᐙᐱᐦᑏ ᒫᐦ᙮ ᒫᐅᑖ ᐋᐦᑎᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᔖᔥ ᑎᑯᓂᔨᐤ ᐅᑎᐦ ᑖᐙᔨᔥ ᐋᐦ ᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐋᔥᒄ ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ ᑭᑎ ᐅᑎᐦᒋᐱᔨᐤ ᓈᔥᒡ ᒑ ᐱᑯᓵᔨᐦᑎᒫᒄ ᒦᓐ ᑳᐤ ᒑ ᒌ ᐙᐱᒫᒄ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋᑎᑯᓯᐦᒃ, ᓂᒧᐃ ᒫᒃ ᒋᑭ ᒌ ᐙᐱᒫᐙᐤ ᐊᓂᑎᐦ ᐊᓐ ᒫᒀᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ᒋᑭ ᑖᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᒑ ᐄᑎᑖᑯᒡ, ‘ᒫᐅᑖ ᐋᐦ ᑖᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ,’ ᑭᔮᐦ ᒫᒃ, ‘ᒫᓈ ᓈᑖᐦ ᐋᐦ ᑖᑦ᙮’ ᒥᒄ ᒫᒃ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᓈᓂᑐᐙᐱᒥᓈᐙᐤ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ᐙᔥ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤ ᒌᔑᑳᔨᒑ ᑳᐤ ᒑ ᑎᑯᔑᓃᔨᒡ ᒧᔮᒻ ᐋ ᐙᔥᑖᐱᔨᐦᒡ ᑳ ᒌ ᐃᓯᓈᑯᐦᒡ ᒥᓯᐙ ᐊᔅᐱᓵᒡ ᒑ ᐙᔥᑎᐙᒡ ᒌᔑᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ᒥᒄ ᒫᒃ ᐋᔥᒄ ᐋᒸᔮ ᐅᑎᐦᒋᐱᔨᒡ ᐆ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒫᒀᒡ ᐊᓅᐦᒡ ᑳ ᐱᒫᑎᓰᔨᒡ ᓈᔥᒡ ᓂᑭ ᐐᓯᒑᔨᐦᑎᒥᐦᐄᑯᒡ ᑭᔮᐦ ᓂᑭ ᐋᑎᐙᔨᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ᒧᔮᒻ ᒫᒃ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐊᓂᑎᐦ ᒫᒀᒡ ᑳ ᐱᒫᑎᓰᑦ ᐊᓂᔮ ᓄᐙ, ᐋᐅᒄ ᐊᓐ ᒑ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒦᓐ ᑎᑯᔑᐦᑳ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ᒥᒄ ᐙᐦ ᑎᒡ ᒌᐦ ᑑᐎᒡ ᐊᓂᔮᐦᑳ ᐄᔨᔨᐅᒡ, ᒌ ᒦᒋᓯᐎᒡ, ᒌ ᒥᓂᐦᒀᐅᒡ, ᒌ ᒋᐦᒋᐐᒋᑐᐎᒡ ᐲᐦᐃᒻ ᑳ ᐅᑎᐦᒋᐱᔨᒡ ᒑ ᐲᐦᒑᑦ ᓄᐙ ᐅᒌᒫᓐ᙮ ᐋᒄ ᑳ ᐊᔅᒋᐳᑖᒡ ᐊᔅᒌ, ᒥᓯᐙ ᑳ ᓂᔔᐎᓈᑎᓰᔨᒡ ᐋ ᐃᑎᔑᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐋᔥᒄ ᐋ ᒌ ᐱᒫᑎᓰᑦ ᐊᓂᔮ ᓨᑦ᙮ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒥᒄ ᐙᐦ ᐋᐃᐦᔨᑎᒡ ᒌᐦ ᑑᐎᒡ᙮ ᐋ ᒦᒋᓱᒡ, ᐋ ᒥᓂᐦᒀᒡ, ᐋ ᐅᑎᓂᒑᒡ, ᐋ ᐊᑖᐙᒡ, ᐋ ᓂᐦᑖᐅᒋᐦᒑᒡ, ᐋᔨᐤᐦ ᐋ ᒫᓄᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ᐊᓂᔮᔨᐤ ᑳ ᒌᔑᑳᔨᒡ ᒑ ᓂᑭᑎᐦᒃ ᓨᑦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᔂᑐᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒌ ᒋᒨᓂᐱᐦᒋᐦᑎᓐ ᐃᔥᑯᑖᐤ ᑭᔮᐦ ᐋ ᐃᔥᑯᑖᐅᒡ ᐊᓯᓃᔨᒡ ᒌ ᐹᐦᐱᐦᒋᔑᓂᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ᙮ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳᐦ ᑖᒡ ᒌ ᓂᔑᐎᓈᒋᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᐋᔪᐎᒄ ᒧᔮᒻ ᒑ ᐄᑖᑎᓰᓈᓂᐎᔨᒡ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᐹᒋ ᓅᑯᓯᒑ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“ᐆ ᒫᒃ ᐋ ᒌᔑᑳᒡ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐊᓐ ᐊᐙᓐ ᐎᔨᐐᑎᒥᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐐ ᑭᑎ ᐅᐦᒋ ᐲᐦᒑᐤ ᐐᒋᐦᒡ, ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐊᓂᑖᐦ ᓅᐦᒋᒦᐦᒡ ᑳᐦ ᑖᑦ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᒌᔨᐙᐤ ᒑ ᒌ ᓂᑑᓂᓈᔅᑐᓂᐦᒃ ᐅᒑᒀᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ᒋᔅᒍᒄ ᒫᒃ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᓨᑦ ᐅᐐᒋᒫᑭᓐ, ᐋ ᒌ ᒌᐙᐋᐱᓵᐱᔨᒡ, ᐋᑯᑖᐦ ᑳᐦ ᐋᑎ ᓂᔑᐎᓈᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ᐊᐙᓐ ᐋ ᐐᐦ ᑭᓄᐙᔨᐦᑎᒫᓱᑦ ᐅᐱᒫᑎᓰᐎᓐ ᒋᑭ ᐎᓂᐦᑖᐤ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᐱᒋᔥᑖᔨᐦᑎᐦᒃ ᐅᐱᒫᑎᓰᐎᓐ ᐋᐅᒄ ᐊᓐ ᒑ ᑭᓂᐙᔨᐦᑖᑭᓂᐎᔨᒡ ᐅᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᒑ ᐄᔅᐱᔨᒡ ᒦᓐ ᑎᑯᔑᒑ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ᐊᓐ ᑎᐱᔅᑳᒑ ᑎᑯᔑᓂᔮᓈ ᑭᑎ ᓃᔓᓯᓂᒡ ᐄᔨᔨᐅᒡ ᓂᐹᐎᓂᐦᒡ᙮ ᐹᔨᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒋᑭ ᐅᑎᓂᑰ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᓂᑭᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ᑭᔮᐦ ᒋᑭ ᓃᔔᒡ ᐃᔅᒀᐅᒡ ᐋ ᐱᒥᓂᐙᒡ᙮ ᐹᔨᒄ ᐊᓐ ᒋᑭ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᓂᑭᑖᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ᑭᔮᐦ ᒫᒃ ᓃᔓ ᓈᐹᐅᒡ ᒋᑭ ᑖᐅᒡ ᓅᐦᒋᒦᐦᒡ᙮ ᐹᔨᒄ ᐊᓐ ᒋᑭ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᓂᑭᑖᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᑯᒀᒋᒥᑰ ᐋᐦ ᐄᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᑖᓂᑖᐦ ᐆ ᒑ ᐄᔅᐱᔨᒡ᙮” ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᒥᑐᓐ ᒋᑭ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐄᔅᐱᔨᐦᒑ ᐆ᙮ ᒧᔮᒻ ᐊᓂᑖᐦ ᐋ ᓅᑯᓯᒡ ᑳᐦᑳᒍᐎᒡ ᐋ ᒥᐦᒑᑎᒡ ᒋᔅᒑᔨᐦᑖᑯᓂᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᒑᒀᔨᐤ ᐋ ᓂᐲᒥᑭᓃᔨᒡ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ᒌᓴᔅ ᒌ ᐐᐦᑎᒧᐙᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᔨᒡ ᒨᔥ ᒑ ᒌ ᐊᔨᒥᐦᐋᔨᒡ, ᑭᔮᐦ ᐋᑳ ᒑ ᐴᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ᒌᐦ ᐄᑖᐤ, “ᒌᐦ ᑖᐤ ᑎᐹᔅᑯᓂᒑᓯᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᓈᓂᐦᒌᔥᑐᐙᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᑦ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᐃᐦᑖᐎᓐ ᒌᐦ ᑖᐤ ᐋ ᐹᔨᑯᑦ ᐃᔅᒀᐤ᙮ ᒨᔥ ᒫᒃ ᒌ ᓂᑎᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑎᐹᔅᑯᓂᒑᓯᐤ ᐋᐦ ᐄᑖᑦ, ‘ᒋᓂᑐᑎᒫᑎᓐ ᒑ ᒌ ᐐᒋᐦᐄᔨᓐ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᑎᐹᔅᑯᓈᑭᓅᑦ ᐊᓐ ᑳ ᐹᒋ ᐎᓂᑐᑎᐎᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ᓈᐅᔥ ᒫᒃ ᐊᓐ ᑎᐹᔅᑯᓂᒑᓯᐤ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᓈᑎᒧᐙᐤ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ᙮ ᐋᒄ ᒑᒃ ᑳ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᐦᒃ, ‘ᓂᒧᐃ ᓂᓈᓂᐦᒌᔥᑎᐙᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᓂᒧᐃ ᓂᑎᔮᐱᑖᔨᒫᐅᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ᐆ ᒫᒃ ᑳ ᐹᔨᑯᑦ ᐃᔅᒀᐤ ᔖᔥ ᓂᓯᔅᑭᒋᐦᐄᒄ ᑳ ᐃᔥᐱᔥ ᒨᔥ ᐹᒋ ᒧᑯᔥᑳᒋᐦᐄᑦ, ᐋ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑ ᒌ ᐐᒋᐦᐄᒃ᙮ ᐋᑯᔥ ᒫᒃ ᑭᔨᑆ ᐄᔨᐙ ᓂᑭ ᐐᒋᐦᐋᐤ, ᐋᑳ ᐊᑎᑎᐤ ᒑ ᒌ ᓯᔅᑭᒋᐦᐄᑦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᔮᔨᐤ ᒦᓐ ᑳᐦ ᐃᔨᑦ, “ᒫᒥᑑᓈᔨᐦᑖᒸᐦᒄ ᒫᐦ ᑳᐦᐄᑦ ᐊᓐ ᒥᒋᐎᔮᔅᑯᓂᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ᓂᒧᐃ ᐋ ᒫᒃ ᐊᑎᑎᐤ ᒋᔖᒥᓂᑑ ᓲᐦᒃ ᑭᑎ ᐐᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳᐙᔮᐱᒫᑦ ᐅᑎᔨᔨᒻᐦ ᑭᓂᐙᒡ ᑳ ᐊᔨᒥᐦᐋᔨᒡ ᐋ ᒌᔑᑳᔨᒡ ᑭᔮᐦ ᐋ ᑎᐱᔅᑳᔨᒡ ᐋ ᓂᑐᑎᒫᑯᑦ ᒑ ᒌ ᓈᑎᒧᐙᑦ? ᐐᐱᒡ ᑭᑎ ᓈᑎᒧᐙᐤ ᓈᑐᑎᒫᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒑᔥᑎᓈᑖᔮᔨᐦᑖᑯᓂᔨᐤ ᐐᐱᒡ ᒑ ᓈᑎᒧᐙᑦ᙮ ᐋᒄ ᒫᒃ, ᐄᔨᔨᐅᑯᓯᓵᓐ ᒦᓐ ᑎᑯᔑᒑ ᑭᑎ ᒥᔅᑭᐙᐤ ᑳᑭᔮᐦ ᐊᐙᔨᐤᐦ ᐋᔥᒄ ᐋ ᑖᑆᔮᔨᒥᑯᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ᒌᓴᔅ ᒦᓐ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᒑᔨᒦᓱᔨᒡ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᐋᐦ ᐄᑖᔨᒦᓱᔨᒡ ᒥᒄ ᒫᒃ ᑳ ᒥᒑᔨᒫᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“ᐹᔨᒀᐤ ᓃᔓ ᓈᐹᐅᒡ ᒌ ᐲᐦᒑᐅᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᒌ ᓂᑑᐊᔨᒥᐦᐋᒡ᙮ ᐹᕆᓰ ᐊᓐ ᐹᔨᒄ᙮ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᑳ ᒫᒨᔑᒋᓈᑦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᒌ ᐄᑖᐱᑎᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ᐋᒄ ᐊᓐ ᐹᕆᓰ ᒌ ᐹᔨᑯᑳᐳ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐊᔨᒥᐦᐋᑦ, ‘ᒋᔖᒥᓂᑑ, ᒌ ᓂᓈᔅᑯᒥᑎᓐ ᐋᐦᐋᑳ ᐃᓯᓈᑯᓯᔮᓐ ᑯᑎᑭᒡ ᐋ ᐃᓯᓈᑯᓯᒡ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᒥᔅᑎᒫᐅᒋᐦᑎᒫᓱᔮᓐ ᔓᐎᔮᓐ ᑭᔮᐦ ᐋᑳ ᓂᑎᐐ ᒥᒄ ᑑᑑᒀᐤ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᐱᓯᒀᑎᓯᔮᓐ᙮ ᒌ ᓂᓈᔅᑯᒥᑎᓐ ᐋᐦᐋᑳ ᐄᑖᔨᐦᑖᑯᓯᔮᓐ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᓐ ᐋ ᒫᒨᔑᒋᓈᑦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ᓃᔨ ᒫᒃ ᐋᔑᑯᒻ ᑑᐎᔥᑖᐤ, ᓃᔓ ᒌᔑᑳᐤᐦ ᓂᒧᐃ ᓂᒦᒋᓱᓐ ᑭᔮᐦ ᓂᐱᒋᔅᑎᓂᒑᓐ ᐹᔨᒀᐱᔥᒡ ᐋᔑᑯᒻ ᒥᑖᐦᑣᐱᔅᒡ ᐋ ᐃᔥᐱᔥ ᐋᔮᐎᒃ ᔓᐎᔮᓐ᙮’ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᐐᔨ ᐊᓐ ᐹᕆᓰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ᐋᒄ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐋ ᒫᒨᔑᒋᓈᑦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᑦ, ᐄᔥᐱᐦ ᐊᔨᒥᐦᐋᑦ ᐙᐦᔨᔫᐄᔥ ᐊᓂᑎᐦ ᒌ ᐅᐦᒋᑳᐳ ᑖᓂᑖᐦ ᑳ ᓃᐴᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐹᕆᓰ, ᓂᒧᐃ ᑭᔮᐦ ᐙᐙᒡ ᐅᐦᒋ ᐃᑖᐱᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐙᔥ ᒌ ᑯᔑᑯᑖᐦᐋᐤ᙮ ᒌ ᐃᔨᐤ ᒫᒃ, ‘ᒋᔖᒥᓂᑑ ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ ᐋ ᒥᒋᐦᑣᔮᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ᒌᓴᔅ ᒫᒃ ᒌ ᐐᐦᑎᒨᐙᐤ ᐋᔨᑖᑦ, “ᐆ ᓈᐹᐤ ᒌ ᒌᔨᐙᐤ ᑖᑆᐦ ᐋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐋ ᑭᓂᐙᐱᒥᑯᑦ᙮ ᓂᒧᐃ ᐐᔨ ᐊᓐ ᐹᕆᓰ᙮ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᐄᔅᐹᔨᑖᑯᐦᐅᑦ ᑭᑎ ᑎᐱᐦᑖᔨᐦᑖᑯᐦᐄᑰ ᒋᔖᒥᓂᑑ ᐋᒄ ᐊᓐ ᑳ ᑎᐱᐦᑖᔨᒦᓱᑦ ᐊᐙᓐ ᐋᐅᒄ ᒑ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ᒌ ᐹᑐᐙᐅᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌᓴᔅᐦ ᑳ ᐃᔮᐱᔒᔑᔨᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ, ᐋ ᒌ ᓂᑎᐙᔨᒫᒡ ᒑ ᒌ ᑖᐦᒋᓈᔨᒡ ᐋᔒᐙᔨᒫᔨᒡ᙮ ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᐅᔮᔨᐤ ᐋ ᐄᔨᐦᑎᔨᒡ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ᒌᓴᔅ ᒌ ᓂᑑᒫᐤ ᐊᐙᔑᔥ ᐋᐦ ᐃᔨᑦ, “ᐱᒋᔅᑎᓈᐦᑯᒡ ᐊᐙᔑᔑᒡ ᒑ ᒌ ᐹᒋ ᓈᓯᒡ, ᐊᑳᐐ ᐅᐦᒋ ᒋᔅᑎᐦᐋᒫᑯᒡ, ᐙᔥ ᐅᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᑎᐱᔨᐙᐆᓰᐆᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒧᔮᒻ ᐋ ᐄᔑ ᑖᑆᐦᑎᐦᒃ ᐊᐙᔑᔥ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒧᐙᑭᓅᑦ ᐋᐅᒄ ᐊᓐ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᐱᐦ ᐄᔑ ᑖᑆᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᑯᐎᔮᒄ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ, ᐋᐅᒄ ᒫᒃ ᒥᒄ ᒑ ᒌ ᐅᐦᒋ ᐲᐦᒑᔮᒄ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ᐋᒄ ᐹᔨᒀᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᒫᒧᐙᐤ ᒌ ᐄᔑ ᑯᒀᒋᒫᐤ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ ᑳ ᒥᔪᐦᑣᔨᓐ, ᑖᓐ ᒑ ᑎᔮᓐ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔮᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒑᒀᓐ ᐙᐦᒋ ᐃᔑᓂᐦᑳᓱᔨᓐ ᑳ ᒥᔪᐦᑣᑦ? ᓂᒧᐃ ᐊᐙᓐ ᑖᐤ ᒥᑐᓐ ᒑ ᒌ ᒥᔪᐦᑣᑦ, ᒥᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐅᐦᐄ ᐄᑎᔓᐙᐎᓐ, ᐊᑳᐐ ᒋᑭ ᓂᐱᐦᐄᐙᓐ, ᐊᑳᐐ ᒋᑭ ᐱᓯᒀᑎᓯᓐ, ᐊᑳᐐ ᒋᑭ ᑭᒋᒧᑎᑦ, ᐊᑳᐐ ᒋᑭ ᓂᑎᔮᒋᒫᐤ ᒌᒋᐄᔨᔨᐤ, ᒋᔅᑖᔨᒻ ᑰᐦᑖᐐ ᑭᔮᐦ ᒋᑳᐐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐃᔨᑦ, “ᑳ ᐹᒋ ᐊᐙᔑᐎᔮᓐ ᔖᔥ ᓂᒌ ᓂᓂᐦᐄᐦᑖᓐ ᐅᐦᐄ ᒥᓯᐙ ᒋᐄᑎᔑᐙᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐱᔮᐦᑎᐙᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᐋᔥᒄ ᒫᒃ ᐹᔨᒄ ᒑᒀᓐ ᒦᓐ ᓂᑎᐙᔨᐦᑖᑯᓐ ᒑ ᒌᐦ ᑐᑎᒥᓐ᙮ ᐊᑖᐙᒑ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᔨᓐ, ᐋᒄ ᐊᓐ ᔓᐎᔮᓐ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒑ ᒥᔨᑣᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᐃᔮᔨᓐ ᒦᓯᒋᓰᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ᙮ ᑐᑎᐦ ᒫᒃ ᐆ ᐋᒄ ᒑ ᐹᒋ ᓅᔔᔥᑭᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐊᓐ ᓈᐹᐤ ᐅᔮᔨᐤ, ᓈᔥᑖᑆᐦ ᒌ ᒥᒑᔨᐦᑎᒻ ᐙᔥ ᓈᔥᑖᑆᐦ ᒌ ᒥᓯᒋᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐎᔮᐱᐦᑎᒸᑦ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᒑᔨᐦᑎᒨᓈᑯᓰᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᓄᐎᒡ ᐋᔨᒥᓂᔨᐤ ᐊᐙᓐ ᐋ ᒥᓰᒋᓰᑦ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ᐊᑎᑎᐤ ᐋᔨᒥᓂᔨᐤ ᐊᐙᓐ ᑳ ᒥᓰᒋᓰᑦ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᐃᔥᐱᔥ ᐐᔨ ᐊᓐ ᑳᒥᓪ ᒑ ᒌ ᔖᐳᔥᑭᐦᒃ ᐋ ᐱᑯᓈᔮᐱᔅᑳᔨᒡ ᔖᐳᓂᑭᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᒌᓴᔅᐦ, ᒌ ᑯᒀᒋᒫᐅᒡ, “ᐊᐙᓐ ᒫᒃ ᐋᒄ ᒑ ᒌ ᐱᒫᒋᐦᐅᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᓂᔮᔨᐤ ᐋᑳ ᑳ ᒌᐦ ᑐᑎᐦᒃ ᐄᔨᔨᐤ, ᑭᑎ ᒌᐦ ᑐᑎᒻ ᐐᔨ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐃᔨᑦ, “ᑭᓂᐙᐱᐦᑏ ᒫᐦ᙮ ᔖᔥ ᓂᒌ ᓂᑭᑖᓈᓐ ᒥᓯᐙ ᓂᑎᐲᐙᐆᓰᐆᐎᓈᓐ ᒑ ᒌ ᓅᔔᔥᑳᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“ᐋᐦᐋ, ᑖᑆᐦ ᑭᔨᑆ,” ᒌᐦ ᐄᑖᐤ ᒌᓴᔅ, “ᒥᓯᐙ ᐊᐙᓐ ᑳ ᓂᑭᑎᐦᒃ ᐐᒡ ᑭᔮᐦ ᑳ ᓂᑭᑖᑦ ᐐᐤᐦ ᑭᔮᐦ ᐐᒋᔖᓐ ᑭᔮᐦ ᐅᓃᒋᐦᐄᒄᐦ ᑭᔮᐦ ᐅᑎᐙᔑᔒᒻ, ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐅᐦᒋ, ᒋᑭ ᒑᔥᑎᓈᑖᔮᔨᐦᑖᓈᐙᐤ, ");
INSERT INTO crl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᒑ ᒥᔮᑭᓅᑦ ᐃᔥᐱᔥ ᐐ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑭᑎᐦᒃ ᐊᓅᐦᒡ ᒫᒀᒡ ᐋ ᐱᒫᑎᓰᑦ, ᑭᔮᐦ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᑭᑎ ᐃᔮᐤ ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᐱᐦᑳᓐ ᒑ ᒌᐦ ᑖᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᕉᓯᓕᒥᐦᒡ ᒋᑭ ᐄᑐᐦᑖᓈᓂᐤ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒥᓯᐙ ᒑ ᑎᐱᐱᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐋᔨᒨᒫᑭᓅᑦ ᒑ ᐄᔅᐱᔨᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒧᐙᑯᐱᓈ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ᒋᑭ ᐱᒋᔅᑎᓂᒧᐙᑭᓂᐎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ, ᒑ ᒌ ᒫᔮᔨᒫᒡ ᑭᔮᐦ ᒑ ᒌ ᐎᔮᐦᐅᑐᐙᒡ ᓂᑎᐐ ᒥᒄ ᐋᐦ ᐄᔥᒌᔣᑖᒡ ᑭᔮᐦ ᒑ ᒌ ᔑᐦᒀᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ᑭᔮᐦ ᒑ ᒌ ᐱᔑᔥᑖᐦᐙᒡ, ᑭᔮᐦ ᒑ ᓂᐱᐦᐋᒡ᙮ ᒥᒄ ᒫᒃ ᒌ ᓂᔥᑐᒌᔑᑳᔨᒑ ᒦᓐ ᑳᐤ ᒋᑭ ᐎᓂᔥᑳᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒫᒃ ᓂᒧᐃ ᐙᒋ ᐹᔨᒄ ᐅᐦᒌ ᓂᔅᑐᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒸᐅᐦᐄᑯᔨᒡ᙮ ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐃᓯᓈᑯᓂᔨᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒡ᙮ ᓂᒧᐃ ᐅᐦᒋ ᒌᔅᒑᔨᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᐊᔨᒸᐦᐄᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐋᑎ ᐹᔣᐱᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒉᕆᒀᐤ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᓈᐹᐤ ᐋᐦᐋᑳ ᐙᐱᐦᑎᐦᒃ ᐊᓂᑖᐦ ᔮᐃᔅᑭᓂᐤ ᒌ ᐊᐱᐤ ᐋ ᓂᑐᑎᒫᑦ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐙᑦ ᐋ ᐱᒥᒦᔮᔥᑳᑯᑦ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒌ ᑯᒀᒋᒫᐤ ᑖᓐ ᐋᐦ ᑎᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“ᒌᓴᔅ, ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ ᒫᒀᒡ ᐱᒧᐦᑖᐤ,” ᒌ ᐄᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ᐋᒄ ᑳ ᑖᑆᑦ ᐋᐦ ᐃᔨᑦ, “ᒌᓴᔅ, ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᓃᑳᓂᐦᑖᒡ ᒌ ᒋᔅᑎᐦᐋᒧᐙᐅᒡ ᐋᐦ ᐄᑖᒡ, “ᐋᑳ ᒋᔅᑐᐦ᙮” ᐋᐦᒡ ᒫᒃ ᐊᑎᑎᐤ ᓲᐦᒃ ᒌ ᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, “ᒌᔨ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤᐦ ᑌᕕᑦ ᐋᓂᔅᒑ ᐅᑯᓯᔅᐦ, ᐹᒋ ᒋᔅᑎᒫᒑᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ᒌᓴᔅ ᒌ ᒋᐱᐦᒋᑳᐳ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᐹᑐᐙᑭᓅᑦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᓈᐹᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᐹᔣᐱᒫᑦ ᒌᓴᔅᐦ, ᒌ ᑯᒀᒋᒥᑰ, ");
INSERT INTO crl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᓐ ᒑ ᒌᐦ ᑐᑎᒫᑖᓐ?” ᐊᓐ ᓈᐹᐤ ᒌᐦ ᐄᑖᐤ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᑐᑎᐤ ᒑ ᒌ ᐙᐱᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐙᐱᐦᑎᐦ, ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᒋᒦᓂᐙᒋᐦᐄᑯᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ᑏᐙᐦᒡ ᒫᒃ ᒥᑐᓐ ᒌ ᐙᐱᐦᑎᒻ, ᑳᐦ ᐋᑎ ᓅᔔᔥᑯᐙᑦ ᒌᓴᔅᐦ ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᐎᔮᐱᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐋᐦ ᐄᔅᐱᔨᒡ, ᑭᔮᐦ ᐐᔨᐙᐤ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ᒌᓴᔅ ᒌ ᐅᑎᐦᑎᒻ ᐃᐦᑖᐎᓂᔨᐤ ᒉᕆᒀᐤ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒌ ᐋᑎ ᓵᐴᐦᑎᐙᔅᑭᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ᒌᐦ ᑖᐤ ᒫᒃ ᓈᐹᐤ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᓵᑮᔭᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᒌ ᓃᑳᓂᔥᑭᐙᐤ ᐋ ᒫᒨᔑᒋᓈᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑳ ᐄᑖᐱᑎᓰᔨᒡ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒥᓯᒋᓰᐤ ᐆ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ᒋᐐᐦ ᐙᐱᒫᐤ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒌᓴᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᒥᒄ ᒫᒃ ᒌ ᑎᐦᑳᐳ ᐋᒄ ᓂᒧᐃ ᐅᐦᒌ ᐙᐱᒫᐤ, ᐙᔥ ᒌ ᒥᐦᒑᑎᔨᐤ ᐊᐙᔨᐤᐦ ᐋᐦ ᐋᑰᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ᐋᒄ ᓈᑖᐦ ᓃᑳᓐ ᑳ ᐃᔥᐱᐦᑖᑦ ᑳ ᔖᑭᒋᐙᑦ ᒥᔥᑎᒄ, ᒑ ᒌ ᐙᐱᒫᑦ ᒌᓴᔅᐦ ᐄᔥᐱᐦ ᐱᒧᐦᑖᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐙᑎᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒥᔥᑎᒄ ᒌ ᐄᑖᐱᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓵᑮᔭᔅ, “ᒌᔨᐲᐦ ᐹᒋ ᓃᐦᑖᐦᑎᐐᐦ ᓵᑮᔭᔅ, ᐋᐦ ᑖᔨᓐ ᓂᑭ ᑖᓐ ᐊᓅᐦᒡ ᒑ ᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ᓵᑮᔭᔅ ᒫᒃ ᑏᐙᐦᒡ ᒌ ᐋᑎ ᓃᐦᑖᐦᑎᐐᐲᐦᐆ ᐋ ᒥᔻᔨᐦᑎᐦᒃ ᒑ ᐲᐦᑎᑭᐦᐋᑦ ᒌᓴᔅᐦ ᐎᒋᒡ᙮ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑎᒻ ᐋᐦ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᐐᒋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐋ ᐲᐦᑎᑭᐦᐄᑯᔨᒡ ᓵᑭᔮᔅ ᒌ ᒫᒫᐦᒋᐃᑖᐅᒡ ᐋᐦ ᐄᑖᒡ, “ᐆ ᓈᐹᐤ ᐋ ᓂᑑᐃᐦᑖᑦ ᐊᓂᑖᐦ ᐅᒥᒋᐦᑣᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ᓵᑮᔭᔅ ᒫᒃ ᒌ ᐱᓯᑰ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᑭᓂᐙᐱᐦᑦ ᒫᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᐋᐱᐦᑑ ᐋ ᐃᔥᐱᔥ ᐃᔮᔮᓐ ᓂᑭ ᒥᔮᐅᒡ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ᙮ ᑳ ᒋᒧᑎᒫᐅᒑ ᐊᐙᓐ, ᐊᐅᔅᑖ ᓈᐙᐤ ᓂᑭ ᒋᐙᒥᔮᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐊᓅᐦᒡ ᐆ ᑳᔑᑳᒡ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᑳ ᐐᒋᒡ ᐅᑎᐦ ᒌᒋᐦᒡ ᐱᒫᒋᐦᐋᑭᓂᐎᒡ᙮ ᐙᔥ ᒌᔨ ᓵᑮᔭᔅ ᑰᐦᒋᓐ ᐊᓂᑖᐦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ᐄᔨᔨᐅᑯᓯᓵᓐ ᒌ ᐹᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᓈᓂᑎᐙᐱᒫᑦ ᑭᔮᐦ ᒑ ᒌ ᐱᒫᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᐎᓂᔑᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᐹᔣᐱᐦᑎᒻ ᒌᓴᔅᐦ ᒉᕉᓯᓕᒥᔨᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤ ᐋ ᓂᑑᐦᑖᑯᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᐙᐐᐦᑎᒫᑯᒡ ᒌᓴᔅᐦ ᒌ ᐄᑖᔨᐦᑎᒧᒡ ᑖᑆᐦ ᔖᔥ ᑏᐙᐦᒡ ᒑ ᓅᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᒌᓴᔅ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᑳ ᐐᐦᑎᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ᒌ ᐃᔨᐤ ᒫᒃ, “ᓈᐹᐤ ᓈᔥᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ, ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᐙᐦᔨᐤ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᒋᐦᒋᐅᒋᒫᐅᐦᐋᑭᓅᑦ ᐋᒄ ᒫᒃ ᒦᓐ ᑳᐤ ᒑ ᐹᒋ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ᒥᒄ ᒫᒃ ᐋᒸᔮ ᐅᐦᒋ ᒋᔅᑐᐦᑖᑦ ᒌ ᓂᑑᒫᐤ ᒥᑖᐦᑐ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐹᐦᐹᔨᒄ ᑳ ᒥᔮᑦ ᔓᐎᔮᓐ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᐋᔨᐙᒡ ᐐᐦ ᐅᔑᐦᐋᒄ ᐆ ᔓᐎᔮᓐ ᒑ ᐃᔥᐱᔥ ᐃᑎᓂᐦᐅᔮᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ᐊᓂᔮᔨᐤ ᒫᒃ ᐄᔨᔨᐤ ᐊᓂᑖᐦ ᑳ ᐅᐦᒌᔨᒡ ᑳ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ ᒌ ᐅᐦᑳᑎᑰ᙮ ᐄᔥᐱᐦ ᑳ ᒋᔅᑐᐦᑖᑦ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐄᔨᔨᐤ ᒌ ᐄᑎᔑᐦᐙᔨᐤ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓂᑑᐳᑯᓅᒥᑯᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒑ ᐄᑐᐦᑖᑦ ᒑ ᒌ ᓂᑑᐐᐦᑎᒥᔨᒡ ᐋᐦᐋᑳ ᓂᑎᐙᔨᒫᒡ ᒑ ᒌ ᐅᐦᒋ ᒋᐦᒋᐅᒋᒫᒥᐦᑭᐙᑭᓄᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒌ ᒋᐦᒋᐅᒋᒫᐅᐦᐋᑭᓂᐤ, ᐋᒄ ᒦᓐ ᑳᐤ ᑳ ᐹᐦᒡ ᒌᐙᑦ᙮ ᐋᒄ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐ ᐋ ᓂᑐᒋᔅᒑᔨᒫᑦ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐅᐦᑎᓰᐙᒑᔨᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᑳ ᒥᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ᐊᓐ ᓃᔥᑎᒻ ᑳ ᑎᑯᔑᐦᒃ ᓈᐹᐤ ᒌᐦ ᐄᑖᐤ, ‘ᓅᒋᒫᒻ, ᐹᔨᒄ ᒋᒌ ᐹᒋ ᒥᔨᓐ ᔔᐎᔮᓈᐱᔅᒄ ᐋᒄ ᒫᒃ ᒥᑖᐦᑐ ᔔᐎᔮᓈᐱᔅᑯᒡ ᓂᒌ ᐅᐦᑎᓰᓐ ᐊᓂᑎᐦ ᐅᐦᒋ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘ᒌ ᒥᔪᑐᑖᓐ, ᒌ ᒥᔻᐱᑎᓰᓐ,’ ᒌ ᐄᑎᑰ ᐅᒋᒫᒻ᙮ ‘ᐋ ᒌ ᓅᑯᐦᑖᔨᓐ ᐋ ᑖᑆᐅᒑᔨᐦᑖᑯᓯᔨᓐ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐋᐱᑎᔒᔥᑎᒥᓐ ᒑᒀᓐ ᐋ ᐊᐱᔖᔑᒡ, ᒦᔥᑯᒡ ᒋᑭ ᒥᔨᑰᓐ ᒥᑖᐦᑐ ᐃᐦᑖᐎᓐ ᒑ ᒌ ᓃᑳᓂᔥᑭᒥᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ᒦᓐ ᑯᑎᒃ ᑳ ᑎᑯᔑᐦᒃ ᑳᐦ ᐃᔨᑦ, ‘ᓅᒋᒫᒻ, ᒋᒌ ᐹᒋ ᒥᔨᓐ ᐹᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ ᐋᒄ ᒫᒃ ᓂᔮᔪ ᔔᐎᔮᓈᐱᔅᑯᒡ ᐃᔮᐅᒀᐤ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ᒌ ᐄᑎᑰ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᒋᒫᐤ, ‘ᒋᑭ ᐅᒋᒫᐦᑭᐦᑖᓐ ᓂᔮᔪ ᐃᐦᑖᐎᓐ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“ᐋᒄ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᑎᑯᔑᐦᒃ ᐋᒄ ᑳᐦ ᐃᔨᑦ, ‘ᒫᐤ ᔔᐎᔮᓈᐱᔅᒄ, ᓂᒌ ᒫᐦᑯᐱᑖᐤ ᑖᐱᔅᑳᑭᓂᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ᒌ ᑯᔥᑎᑎᓐ ᐙᔥ, ᐙᔥ ᒌ ᒥᒋᐦᑣᓐ᙮ ᑰᑎᓈᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᑎᐱᔨᐙᐅᓯᔨᓐ ᑭᔮᐦ ᒌ ᒫᒨᓯᒋᓈᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐋᐦᐋᑳ ᒌᔨ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᑖᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ ᑳ ᐄᑎᑯᑦ, ‘ᒌᔨ ᑳ ᒥᒋᐋᐱᒋᐦᐋᑭᓂᐐᓐ, ᓂᑭ ᐋᐱᒋᐦᑖᓐ ᐊᓐ ᑳᐦ ᐃᔨᓐ ᐋ ᓂᔑᐎᓈᒋᒥᑖᓐ᙮ ᒋᑎᐄᑖᔨᒥᓐ ᐋ ᒥᒋᐦᑣᔮᓐ, ᐋ ᐅᑎᓂᒫᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᑎᐱᔨᐙᐅᓯᔮᓐ ᑭᔮᐦ ᐋ ᒫᒨᓯᒋᓂᒫᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᓃᔨ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ᐋᑖᔨᒨᓈ ᒫᒃ ᐆ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᓐ, ᒑᒀᔨᐤ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓂᑦ ᓂᔔᔮᓂᒻ ᐊᓂᑖᐦ ᔔᔮᓂᑭᒥᑯᐦᒡ ᒑ ᒌ ᐅᔑᐦᐅᑦ? ᐋᒄ ᒫᒃ ᐊᓐ ᑖᑯᔑᓂᔮᓐ ᓂᐱᐦ ᐃᔮᐙᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐅᔑᐦᐆᑯᐱᓈ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᓂᑎᐦ ᑳ ᓈᓃᐱᐎᔨᒡ, ‘ᒥᔮᐦᒄ ᐅᔮᔨᐤ ᔔᐎᔮᓈᐱᔅᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᒥᑖᐦᑎᔑᔨᒡ ᐆ ᔔᐎᔮᓈᐱᔅᑯᒻ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ᒌ ᐄᑖᐅᒡ ᒫᒃ ᐅᒋᒫᒧᐙᐤ, ‘ᔖᔥ ᒥᑖᐦᑎᔒᔨᐤ ᐐᔨ ᐋ ᐃᔮᐙᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ᐋᒄ ᐊᓐ ᐅᒋᒫᐤ ᑳᐦ ᐃᔨᑦ, ‘ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ ᓃᔨ, ᒥᓯᐙ ᐊᐙᓐ ᑳ ᓅᐦᔅᒌᐦᑖᑦ ᒑᒀᔨᐤ ᑳ ᒦᔮᑭᓅᑦ ᐊᑎᑎᐤ ᒋᑭ ᑎᑯᓂᔨᐤ ᒑ ᐄᔑ ᒥᔮᑭᓅᑦ᙮ ᐋᒄ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᓈᔥᒡ ᐃᔮᑦ ᒑᒀᔨᐤ ᐙᐙᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐊᐱᔒᔥ ᐃᔮᑦ ᑭᑎ ᐅᑎᓂᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ᐋᒄ ᒫᒃ ᐹᔓᐙᐦᑯᒡ ᐊᓂᒌ ᑳ ᐅᐦᑳᓯᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᓂᑎᐙᔨᒥᒡ ᒑ ᒌ ᒋᐦᒋᐅᒋᒫᐅᒡ, ᒑ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ ᐅᑎᐦ ᐋᐦᑖᐅᒡ᙮’ ” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᒌᓴᔅ ᑳ ᐐᐦᑎᐦᒃ ᒫᒀᒡ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒋᕉᓯᓕᒥᐦᒡ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᒋᔑ ᑎᐹᒋᒧᑦ, ᐋᒄ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᒡ, ᐋᐦ ᐋᑎ ᓃᑳᓂᐦᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᔣᐱᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓐ ᐯᕪᐯᐃᒡ ᑭᔮᐦ ᐯᕠᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᓂᑖᐦ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᒄ ᑳ ᓃᑳᓂᑎᔑᐦᐙᑦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ᓈᑖᐦ ᐄᑐᐦᑖᒄ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ᑎᑯᔑᓂᔮᒀ ᓈᑖᐦ ᒋᑭ ᐙᐱᒫᐙᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔅᐦ ᐋ ᒋᓯᑳᐱᐦᑳᓱᑦ ᐋᐦᐋᑳ ᓂᐦᑖ ᐋᔥᒄ ᐅᐦᒋ ᑖᐦᑎᐱᔨᒡ ᐊᐙᔨᐤᐦ ᐅᔅᐱᔅᑯᓂᐦᒡ᙮ ᒑ ᐋᐱᐦᑯᓈᒄ ᐋᒄ ᒑ ᐹᔓᐙᒄ ᐅᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ᑯᒀᒋᒥᑖᒀ ᒫᒃ ᐊᐙᓐ ᒑᒀᔨᐤ ᐙᐦᒋ ᐋᐱᐦᑯᓂᒫᒄ ᐋᒄ ᒑ ᐄᑖᒄ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᑎᐙᔨᒫᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ᐋᒄ ᒫᒃ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ ᐋᔪᐎᒄ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᐱᐦᑯᓈᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ, ᐊᓂᔮ ᑳ ᑎᐹᔨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᒌ ᐄᑎᑯᒡ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐋᐱᐦᑯᓈᒄ ᐊᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“ᑎᐹᔨᐦᒋᒑᔨᓐ ᓂᑎᐙᔨᒫᐤ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ᐋᒄ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᑐᐦᑎᐦᐋᒡ᙮ ᐋᒄ ᑳ ᐊᑯᓂᐦᐙᒡ ᐅᔅᐱᔅᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ ᐅᑎᑯᐦᐱᐙᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ ᐋᒄ ᑳ ᐐᒋᐦᐋᒡ ᒌᓴᔅᐦ ᐋ ᑖᐦᑎᐦᐄᓱᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ᐄᔥᐱᐦ ᒫᒃ ᐹᒧᐦᑎᐦᐄᑯᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐋᐦᐋᓯᔅ ᒌ ᓯᑣᑭᔥᑖᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐅᑎᑯᐦᐱᐙᐤ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑎᐦᐄᑯᔨᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᐊᐅᐦᑳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᔣᐱᐦᑎᐦᒃ ᒉᕉᓯᓕᒥᔨᐤ ᒌᓴᔅ, ᐋᐦ ᐋᑎ ᓃᑎᐦᒋᐙᒡ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒫᔅᑭᓈᐦᒡ, ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓅᔔᔥᑳᑯᑦ ᒌ ᐅᐦᒋ ᒫᒥᐦᒋᒫᔨᐤ ᒋᔖᒥᓂᑑ ᐋ ᒋᔣᐙᔨᒡ ᑭᔮᐦ ᐋ ᒨᒋᒑᔨᐦᑎᒥᐦᐄᑯᔨᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᒥᑯᑦ ᒌᓴᔅ ᐋ ᒫᒥᔥᑳᒡ ᐊᔨᐦᑎᔨᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᒡ ᐋ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑ, “ᔑᐙᔨᐦᑖᑯᓲ ᐆ ᒋᐦᒋᐅᒋᒫᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒑ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑭᓅᑦ᙮ ᑎᑯᓐ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ᙮ ᑭᔮᐦ ᒫᒃ ᑭᑎ ᒫᒥᐦᒋᒫᑭᓂᐤ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ᐱᔅᒡ ᒫᒃ ᐹᕆᓰᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᐐᔨᐙᐤ ᑳᐦ ᑖᒡ ᐋᒦᐦᒑᑎᓈᓅᐎᔨᒡ ᒌ ᐄᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒋᔅᑎᐦᐋᒧᒡ ᒫᐦ ᐅᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ᐄᔑᒡ ᒑ ᒌ ᒋᐱᑐᐙᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᐱᐦᑐᐙᑣᐙ ᐅᒌ ᐄᔨᔨᐅᒡ, ᐅᒌ ᐊᓯᓃᔨᒡ ᓂᑭ ᒌ ᒫᒥᐦᒋᒥᑯᒡ ᐋ ᒋᔂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ᓈᓈᓂᒌᒻ ᒫᒃ ᒌ ᐋᑎ ᐹᔣᐱᐦᑎᒻ ᒌᓴᔅ ᒉᕉᓯᓕᒥᔨᐤ, ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᐦᑎᐦᒃ ᒌ ᒧᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ᐋᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳ ᐅᐦᒌᔨᒡ ᒋᕉᓯᓕᒥᐦᒡ, “ᑭᒫ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐊᓅᐦᒡ ᒑ ᒌᔑᑳᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᐙᑯᐱᓈ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒌ ᒥᔨᑯᓈᐙᐤ ᒑ ᒌ ᓂᔅᑐᐦᑖᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᓂᑐᐱᔫᒡ ᑳ ᐅᐦᑳᑖᑯᐦᒡ, ᒑ ᒋᐱᔅᑳᑖᑯᒡ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᔮᒄ, ᒋᑭ ᒋᐱᔅᑳᑯᐙᐅᒡ ᐋᑳ ᒑ ᒌ ᐎᔨᐐᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ᒥᓯᐙ ᒌᔨᐙᐤ ᑭᔮᐦ ᐊᔥᑎᐙᓯᒨᐙᐅᒡ ᒋᑭ ᓂᔑᐎᓈᒋᐦᐄᑭᐎᓈᐙᐤ ᑭᔮᐦ ᒋᑎᐦᑖᐎᓂᐙᐤ ᒋᑭ ᓂᔑᐎᓈᒋᐦᑖᑭᓂᐤ᙮ ᓂᒧᐃ ᐙᒋ ᐹᔨᒄ ᐊᓯᓃ ᒧᔮᒻ ᒋᑭ ᐅᐦᒋ ᐄᑎᒨ ᐊᓂᑎᐦ ᒌ ᐙᔅᑳᐦᐄᑭᓂᒧᐙᐦᒡ᙮ ᐙᔥ ᓂᒧᐃ ᑰᐦᒋ ᒨᔑᐦᑖᓈᐙᐤ ᐊᓂᑎᐦ ᑳ ᐅᑎᐦᒋᐱᔨᑯᐱᓈ ᒋᔖᒥᓂᑑ ᑳ ᐐᐦ ᐱᒫᒋᐦᐄᑖᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ᒌᓴᔅ ᒫᒃ ᒌ ᐲᐦᒑᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑳᐦ ᐋᑎ ᐅᐙᔨᐐᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᐊᑖᐙᓯᐤ ᐊᓂᑎᐦ ᐲᐦᑎᑭᒥᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐋ ᒌ ᐃᔨᑯᐱᓈ ᒋᔖᒥᓂᑑ, ᓂᐙᔅᑳᐦᐄᑭᓂᒻ ᐋ ᐊᔨᒥᐦᐋᓂᐎᒡ ᒋᑭ ᐄᑖᐱᑎᓐ᙮ ᒥᒄ ᒫᒃ ᒧᔮᒻ ᒋᒧᑎᔅᑭᒡ ᐅᐙᑎᑯᐙᐤ ᐋᐅᒄ ᐋᔑᓈᑯᐦᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᒌᓴᔅ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᓃᑳᓂᔑᔨᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤ ᒋᐐᐦ ᓂᐱᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓂᑖᐦ ᒑ ᑎᒡ ᒑ ᒌ ᓂᐱᐦᐋᒡ ᐙᔥ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᓈᔥᒡ ᔮᒀᐦ ᒌ ᓂᑑᐦᑎᐙᔨᐤ ᒥᓯᐙ ᐋ ᒌ ᐐᐦ ᐹᐦᑎᒥᔨᒡ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ᐹᔨᒀᐤ ᒌᓴᔅ ᐋ ᒋᔅᒋᓂᐦᐊᒧᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᐋ ᐙᐐᐦᑎᐦᒃ ᒥᔻᒋᒧᐎᓂᔨᐤ, ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ, ");
INSERT INTO crl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᐐᐦᑎᒨᓈᓐ ᒫᐦ, ᒑᒀᓐ ᐙᐦᒋ ᑐᑎᒥᓐ ᐆ ᑳᐦ ᑐᑎᒥᓐ? ᐊᐙᓐ ᑳᐦ ᐄᑎᔓᒥᔅᒃ ᐆ ᒑ ᒌᐦ ᑐᑎᒥᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒋᑭ ᑯᒀᒋᒥᑎᓈᐙᐤ ᒑᒀᓐ᙮ ᓂᔥᒀᐅᔑᐦᐄᒄ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ᐊᐙᓐ ᑳᐦ ᐄᑎᔓᒫᑦ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᒑ ᒌ ᓰᑭᐦᐋᐦᑐᐙᔨᒡ ᐊᐙᔨᐤᐦ, ᒋᔖᒥᓂᑑ ᐋ ᑭᔮᐦ ᒫᒃ ᓈᐹᐤ?” ");
INSERT INTO crl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ᒌ ᐅᔥᑖᐱᔫᒡ ᒫᒃ ᐊᓂᑎᐦ ᐐᔨᐙᐤ ᐋᐦ ᐄᑎᑐᒡ, “ᐄᔨᔨᐦᒀ, ‘ᒋᔖᒥᓂᑑ ᒌ ᐄᑎᑰ,’ ᒋᑭ ᐄᑎᑯᓂᐤ, ‘ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᑖᑆᐦᑎᐙᒄ?’ ");
INSERT INTO crl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ᒫᒃ ᐄᔨᔨᐦᒀ, ‘ᓈᐹᐤ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋ ᐃᐦᑎᒃ,’ ᐋᒄ ᐅᒌ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᑳᐦ ᑖᒡ ᒋᑭ ᓂᐱᐦᐄᑯᓅᒡ ᐋ ᐹᐦᐱᒧᓯᓈᑎᐦᐆᑎᑯᐦᒡ᙮ ᐙᔥ ᒥᑐᓐ ᑖᑆᔮᔨᒫᐅᒡ ᒞᓐ ᐋ ᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ᑳ ᓂᔥᒀᐅᔑᐦᐋᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐊᐙᔨᐤᐦ ᑳᐦ ᐄᑎᔓᒥᑯᑦ ᒞᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑭᔮᐦ ᓃᔨ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᐙᓐ ᑳ ᐹᒋ ᐄᑎᔓᒥᑦ ᐆ ᒑ ᒌᐦ ᑐᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ᒌᓴᔅ ᑭᔮᐦ ᒌ ᐐᐦᑎᒧᐙᐤ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, “ᓈᐹᐤ ᒌ ᐅᔑᐦᑖᐤ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ, ᐋᒄ ᐱᑎᒫ ᑳ ᐱᒋᔅᑎᔓᐙᑎᐦᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑎᒫᑯᑦ᙮ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ, ᐊᓂᑖᐦ ᐙᐦᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᔅᒌᔨᐤ ᑳ ᐄᑐᐦᑖᑦ᙮ ᒌ ᐊᓂᐦᐆ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐱᔨᒡ ᒑ ᒫᒨᔑᒋᓂᑭᓂᐐᔨᒡ ᐊᓂᔮᔨᐤ ᒦᓂᔥ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ ᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᒌ ᐄᑎᔑᐦᐙᐤ ᐹᔨᒄ ᐅᑖᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᓂᑎᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᒑ ᒌ ᒥᔨᑯᑦ ᐊᓂᔮᔨᐤ ᐐᔨ ᒑ ᐄᔑ ᐃᔮᑯᐱᓈ᙮ ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᒌ ᑯᔒᐦᑭᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ ᑳᐤ ᑳ ᒌᐙᑎᔑᐦᐙᒡ ᐋ ᐱᔑᐦᑯᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ᐋᒄ ᐊᓐ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᒌ ᐄᑎᔑᐦᐙᐤ᙮ ᒥᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔮᐱᒡ ᒌ ᑯᔒᐦᑭᐙᐅᒡ ᐊᓂᔮᔨᐤ, ᑭᔮᐦ ᒌ ᒫᔮᔨᒫᐅᒡ, ᐋᒄ ᑳ ᒌᐙᑎᔑᐦᐙᒡ ᐋ ᐱᔑᐦᑯᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ᐋᒄ ᐊᓐ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᒦᓐ ᑯᑎᒃ ᐋᐱᒋᐦᐋᑭᓐ ᑳᐦ ᐄᑎᔑᐦᐙᑦ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐋᔨᐅᑯᓐ ᐋᒄ ᐅᔮᔨᐤ ᑳ ᒥᔣᑭᓂᐦᑳᑖᒡ, ᐋᒄ ᒫᒃ ᑳ ᐎᔨᐐᐙᐱᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ᐋᒄ ᐊᓐ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒻ ᑖᓐ ᒋᐱᐦ ᒌᐦᑑ᙮ ᒑᒃ ᑳ ᐄᑖᔨᐦᑎᐦᒃ, ‘ᓂᑭ ᐄᑎᔑᐦᐙᐤ ᓃᔨ ᑎᐱᔨᐙ ᓂᑯᔅ ᑳ ᓵᒋᐦᐋᒃ᙮ ᒋᑭ ᒋᔅᑖᔨᒫᐅᒡ ᐙᐱᒫᑣᐙ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ᐋᔪᐎᒄ ᒫᒃ ᑳᐦ ᑎᒃ᙮ ᐊᓂᒌ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᒌ ᐄᑎᑐᒡ, ‘ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᐊᓐ ᑰᒋᒫᒥᓂᐤ ᐅᑯᓯᔅᐦ᙮ ᐅᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐐᔨ ᒋᑭ ᐋᔔᒥᔮᑭᓂᐤ᙮ ᓂᐱᐦᐋᑖᐤ᙮ ᐋᒄ ᒫᒃ ᐅᔮᔨᐤ ᐅᑎᐦ ᐊᔅᒌ ᒌᔮᓂᐤ ᒑ ᑎᐱᔨᐙᐎᓯᐅᒄ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ᐋᒄ ᒫᒃ ᑳ ᐎᔨᐐᑎᔑᓈᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳ ᓂᑑᓂᐱᐦᐋᒡ᙮” ᐋᒄ ᒌᓴᔅ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᑎᐹᒋᒧᔥᑐᐙᑦ, “ᑖᓐ ᒫᒃ ᒑ ᑐᑎᐙᑦ ᐊᓐ ᐅᒋᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᓂᐦᑖᐅᒋᐦᒋᑭᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“ᑭᔨᑆ ᒑ ᒌᐙᑦ ᐊᓐ ᐅᒋᒫᐤ ᒑ ᓂᐱᐦᐋᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᒄ ᒑ ᒥᔮᑦ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮” ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᒌ ᐄᑖᐅᒡ, “ᑭᒫ ᐋᑳ ᓂᐦᑖ ᒌ ᐄᔅᐱᔨᒡ ᐆ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ᒌ ᑭᓂᐙᐱᒫᐤ ᒫᒃ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᑖᓐ ᐋᔥᒋᔂᒥᑭᐦᒡ ᒫᒃ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᒡ, ᒌ ᐋᑎᐙᔨᒫᐅᒡ ᑳ ᐙᔅᑳᐦᐄᑭᓂᐦᒑᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᐙᒋᐦᒡ ᑳᐦ ᐋᐱᑎᓰᔨᒡ ᐋ ᒌᐦᒑᔮᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ᑳᐦ ᐋᑎ ᐃᔨᑦ ᒦᓐ ᒌᓴᔅ, “ᐊᐙᓐ ᒫᒃ ᑎᐦᑯᐦᒋᐱᔨᒑ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᒋᑭ ᐲᑯᔑᓐ, ᐋᒄ ᒫᒃ ᐊᓐ ᐊᓯᓃ ᐱᐦᒋᔑᑳ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᒥᑐᓐ ᒋᑭ ᐲᔑᔥᑭᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ᐊᓂᒌ ᒫᒃ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑏᐙᐦᒡ ᒋᐐᐦ ᐅᑎᓈᐅᒡ ᒌᓴᔅᐦ᙮ ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐅᒡ ᐐᔨᐙᐤ ᐋ ᒌ ᐋᔨᒨᒥᑯᒡ ᑳ ᐐᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒌ ᐅᑎᓈᐅᒡ ᐋ ᒌ ᑯᔥᑖᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ᐋᒄ ᒥᒄ ᑳ ᑭᓂᐙᐱᐦᑎᒡ ᒑ ᐃᔥᐱᔥ ᒥᔪᐱᔨᒡ ᒑ ᒌ ᐅᑎᓈᒡᐦ᙮ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᒫᒃ ᐱᔅᒡ ᓈᐹᐤᐦ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᒫᒫᐦᒡ ᒑ ᒌ ᐄᔑ ᑯᒀᒋᒫᔨᒡ ᒑᒀᔨᐤ, ᐋ ᐐᐦ ᐎᓂᒧᔮᐦᒡ ᒑ ᒌ ᐄᔨᔨᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐅᑎᓈᒡᐦ᙮ ᐋᒄ ᒫᒃ ᒌ ᐅᑎᓂᒫᑭᓂᐎᒑ ᐋᒄ ᐊᓂᑖᐦ ᒋᐱᐦ ᐄᑐᐦᑎᐦᐋᐅᒡ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ, ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ᐋᒄ ᒫᒃ ᐅᒌ ᓈᐹᐅᒡ ᑳ ᑯᒀᒋᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᒑᒀᓐ ᐋᐦ ᐃᔨᓐ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᓐ ᐋ ᑖᑆᒥᑭᐦᒡ᙮ ᑭᔮᐦ ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᒥᓯᐙ ᐹᔨᑯᓂᐦᒡ ᐋ ᐄᑖᔨᒥᑣᐤ ᐄᔨᔨᐅᒡ, ᑭᔮᐦ ᒥᓯᐙ ᐹᔨᑯᓂᐦᒡ ᑖᑆᐦ ᐋ ᐄᔑ ᒋᔅᑯᑎᒨᑣᐤ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ ᑖᓂᔮᔨᐤ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ᐋᒄ ᒫᒃ ᓈᑐᐙᔨᒥᑖᐦᒡ ᒑ ᒌ ᐐᐦᑎᒧᔮᐦᒡ, ᐋᐤ ᐋ ᐋᑎᔅᑖᒡ ᐊᓂᑎᐦ ᐐᔓᐙᐎᓂᐦᒡ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᐊᓂᔮᔨᐤᐦ ᔓᐎᔮᓐᐦ ᐄᔨᔨᐤᐦ ᑳ ᑎᐱᐦᐄᒑᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᐋ ᐐᐦ ᐎᓂᒧᐄᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ᐹᒋ ᐙᐱᐦᑎᔨᒄ ᔔᐎᔮᓈᐱᔅᒄ᙮ ᐊᐙᓐ ᒫᒃ ᐅᑖᔥᑎᒥᐦᒄ ᓅᑯᓃᔨᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᐊᐙᓐ ᐊᓂᔮᔨᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᑳ ᒥᓯᓈᑖᔨᒡ?” ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᒡ, “ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐊᓂᔮᔨᐤ ᐅᑖᔥᑎᒥᐦᒄ ᑭᔮᐦ ᐐᔨ ᐊᓂᑎᐦ ᒥᓯᓈᓲ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ, “ᒥᔮᐦᒄ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᑖᓂᔮᔨᐤ ᐐᔨ ᑎᐱᔨᐙᐅᓯᑦ, ᑭᔮᐦ ᒫᒃ ᒥᔮᐦᒄ ᒋᔖᒥᓂᑑ ᑖᓂᔮᔨᐤ ᐐᔨ ᑎᐱᔨᐙᐅᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ᐊᓂᑎᐦ ᒫᒃ ᐋ ᐙᐱᒥᑯᒡ ᐄᔨᔨᐤ, ᓂᒧᐃ ᐅᐦᒌ ᑐᑎᐙᐅᒡ ᓂᑎᐐ ᒑ ᒌ ᐄᔨᔨᒡ ᒑᒀᔨᐤ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᐅᑎᓈᒡᐦ᙮ ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᐙᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᑯᒡ, ᐋᒄ ᓂᒧᐃ ᒦᓐ ᐅᐦᒋ ᒋᔅᑐᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ᒌ ᐹᒋ ᓈᑎᑰ ᒫᒃ ᒌᓴᔅ ᐱᔅᒡ ᓵᑎᔫᓰᐦ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᐋᑳ ᐙᐦᒋ ᑖᑆᐦᑎᐦᒡ ᒦᓐ ᒑ ᐎᓂᔥᑳᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᒌ ᑰᒀᒋᒫᐆᒡ ᑳᐦ ᐄᑖᒡ, ");
INSERT INTO crl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒧᓱᔅ ᒌ ᒥᓯᓂᐦᐋᒻ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ‘ᐴᓂᐱᒫᑎᓰᒑ ᓈᐹᐤ, ᐋᔥᒄ ᒫᒃ ᐱᒫᑎᓰᔨᒡ ᐐᐤᐦ, ᐋᑳ ᒫᒃ ᐙᐦᒋ ᐅᑎᐙᔑᔒᒨᐙᒀ, ᐊᓐ ᓈᐹᐤ ᐐᒋᐄᔨᔨᐤ ᒋᐱᐦ ᐐᒋᒫᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ ᐐᐤᐦ᙮ ᐋᒄ ᒫᒃ ᐃᔮᐅᐙᑣᐙ ᐊᐙᔑᔥ ᒧᔮᒻ ᐐᔨ ᐊᓂᔮ ᓈᐹᐤ ᐋ ᐅᑎᐙᔑᔒᒥᑦ ᒋᐱᐦ ᐃᓯᓈᑯᓂᔨᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ᐋᒄ ᒦᓐ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᒡ ᒌᓴᔅᐦ ᐊᓂᒌ ᓈᐹᐅᒡ, “ᐹᔨᒀᐤ ᐋ ᒌᐦ ᑖᒡ ᓃᔣᔥᒡ ᓈᐹᐅᒡ, ᐋ ᒌ ᐐᒋᔖᓂᐦᑐᒡ᙮ ᐋᒄ ᐊᓐ ᒫᐅᒡ ᒑᔖᐄᔨᔨᐎᑦ ᑳ ᒋᐦᒋᐐᐅᑦ, ᒑᒃ ᑳ ᐴᓂᐱᒫᑎᓰᑦ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐙᑦ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ᐋᒄ ᒫᒃ ᐊᓐ ᑳ ᐅᐦᒋ ᑖᐦᒋᔅᑭᐙᑦ ᐊᓂᔮᔨᐤ ᐅᔅᑖᔅ ᐋᐅᒄ ᐊᓐ ᒦᓐ ᑳ ᐐᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐅᔅᑖᔅ ᐐᐅᔨᐤᐦ᙮ ᑭᔮᐦ ᒫᒃ ᐐᔨ ᒑᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐙᑦ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ᐋᒄ ᒦᓐ ᐊᓐ ᑳ ᐅᐦᒋ ᑖᐦᒋᔅᑭᐙᑦ ᑳ ᐐᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓐ ᐐᐅᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᐐᔨ ᒑᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔮᐙᑦ ᐊᐙᔑᔥ᙮ ᐋᔪᐎᒄ ᐱᔑᔑᐦᒄ ᑳ ᐄᔅᐱᔨᔨᒡ ᐅᒌ ᐐᒋᔖᓂᒫᐅᒡ, ᐹᑎᔥ ᒥᓯᐙ ᓃᔣᔥᒡ ᐋ ᐃᑎᔑᒡ ᑳ ᐐᒋᒫᒡ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᐃᔅᒀᐤ, ᓂᒧᐃ ᒫᒃ ᐙᒋᐹᔮᒄ ᐅᐦᒋ ᐃᔮᐙᐅᒡ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ᐋᒄ ᒑᒃ ᐊᓐ ᐃᔅᒀᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᒌ ᐎᓂᔥᑳᒡ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᐊᐙᓐ ᒑ ᐐᐅᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ, ᐙᔥ ᒥᓯᐙ ᒌ ᐅᓈᐹᒨ ᐊᓂᔮᔨᐤ ᓃᔣᔥᒡ ᓈᐹᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒫᒀᒡ ᐊᓅᐦᒡ ᐋ ᐱᒫᑎᓰᓈᓂᐎᒡ, ᓈᐹᐤ ᑭᔮᐦ ᐃᔅᒀᐤ ᒋᐦᒋᐐᒋᑐᐎᒡ ᓈᔅᑦ ᒫᒃ ᒋᐦᒋᐐᒋᑐᐦᐋᑭᓂᐎᒡ, ");
INSERT INTO crl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ᒥᒄ ᒫᒃ ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᒑ ᐎᓂᔥᑳᓈᑭᓂᐎᒡ, ᐊᓂᒌ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ ᒦᓐ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑎᑯᓐ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐐᒡ ᓈᔅᑦ ᒫᒃ ᒋᐦᒋᐐᒋᑐᐦᐄᐙᓂᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ᐙᔥ ᒧᔮᒻ ᐋᓐᒋᓂᒡ ᒋᑭ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ ᐅᒌ, ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᒌ ᐴᓂᐱᒫᑎᓰᐎᒡ᙮ ᒋᔖᒥᓂᑑ ᑭᑎ ᐅᑎᐙᔑᔒᒥᑐᑖᑯᒡ ᐊᓂᒌ ᒑ ᐎᓂᔥᑳᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ᒧᓱᔅ ᒌ ᐙᐱᐦᑏᔨᐙᐤ ᐋ ᑖᑆᐦᑎᐦᒃ ᒦᓐ ᐋ ᐱᒫᑎᓰᔨᒡ ᑳ ᓂᐲᔨᒡ᙮ ᐐᐦᑖᑯᓐ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᒧᓱᔅ ᑳ ᐙᐱᐦᑎᐦᒃ ᒧᔮᒻ ᐋ ᐃᔥᒀᑖᔨᒡ ᓃᐱᓰᔮᐦᑎᒄ᙮ ᐋᑯᑖᐦ ᐙᐦᑖᑯᐦᒡ ᑭᔮᐦ ᒧᓱᔅ ᐋ ᒌ ᐃᔑᓂᐦᑳᑖᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐅᒋᔖᒥᓂᑑᒻ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐊᔮᐱᒡ ᐅᒋᔖᒥᓂᑑᒧᐙᐤ ᐋᐃᓵᒃ ᑭᔮᐦ ᒉᑭᑉ᙮ ᐅᒌ ᒫᒃ ᓈᐹᐅᒡ ᔖᔥ ᓂᒧᐃ ᐅᐦᒋ ᐱᒫᑎᓰᐎᒡ ᐅᔮᔨᐤ ᒫᒀᒡ ᑳᐦ ᐃᔨᑦ ᒧᓱᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ᓂᒧᐃ ᐅᒋᔖᒥᓂᑑᒥᑐᑖᑰ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᐙᔨᐤᐦ ᒥᒄ ᐊᓂᔮᔨᐤ ᑳ ᐱᒫᑎᓰᔨᒡ᙮ ᒥᓯᐙ ᐱᒫᑎᓰᐤ ᐄᑖᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ, ᐊᓂᔮᔨᐤ ᐋᔥᒄ ᑳ ᐱᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᔖᔥ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᐃᔨᐅᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒥᔻᔑᐤ ᐊᓐ ᑳᐦ ᐃᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ᓂᒧᐃ ᒫᒃ ᒦᓐ ᐊᐙᓐ ᐅᐦᒋ ᑯᒋᐦᑖᐤ ᒑ ᒌ ᑯᒀᒋᒫᑦ ᒌᓴᔅᐦ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ᒌ ᐃᔨᐤ ᒫᒃ ᒌᓴᔅ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᐃᔨᒡ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᙭ ᒑ ᐅᑯᓯᑐᑖᑰᑦ ᐊᓃᔭ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ᑌᕕᑦ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔑ ᒥᓯᓂᐦᐋᒧᑯᐱᓈ ᐊᓂᑖᐦ ᐅᓂᑭᒧᐎᓂᐦᒡ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᓂᑎᐹᔨᐦᒋᒑᒻ, ᐅᑖᐦ ᐹᒋ ᐊᐱᐦ ᓂᓂᐦᐄᐎᓂᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ᐹᑎᔥ ᒌ ᐃᔥᐱᔑᐦᐄᒀᐙ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᔅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ᐙᐙᒡ ᑌᕕᑦ ‘ᓂᑎᐹᔨᐦᒋᒑᒻ’ ᒌ ᐃᔑᓂᐦᑳᑖᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐅᑯᓰᑐᑖᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ᒫᒀᒡ ᒫᒃ ᐋ ᐹᐦᑖᑯᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ");
INSERT INTO crl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ᔮᒀᒦᔥᑐᐙᐦᑯᒡ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᐙᔥ ᓂᑎᐙᔨᐦᑎᒧᒡ ᒑ ᒌ ᒋᔥᑖᔨᒫᑭᓂᐎᒡ᙮ ᒥᔻᔨᐦᑎᒧᒡ ᐋ ᐳᔥᑎᔥᑭᐦᒡ ᑳ ᒋᓍᑭᓃᔨᔨᒡ ᐊᑯᐦᑉ, ᑭᔮᐦ ᒥᔻᔨᐦᑎᒧᒡ ᐋ ᐅᑎᓂᔅᒑᓈᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ᙮ ᑭᔮᐦ ᓂᑎᐙᔨᐦᑎᒧᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᐋ ᐱᐃᐦᑖᐱᒡ ᒑ ᒌ ᐅᐙᔨᐱᐦᐋᑭᓂᐎᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᒑ ᒌ ᐅᐙᔨᐱᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐋ ᐅᒋᒫᐅᐱᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ᐅᑎᓂᒸᐅᒡ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᑳ ᐹᐦᐹᔨᑯᔨᒡ ᐃᔅᒀᐤ ᑭᔮᐦ ᒫᒃ ᓈᐅᔥ ᐊᔨᒥᐦᐋᐅᒡ, ᒥᒄ ᒫᒃ ᐊᔨᒥᐦᐋᑳᓱᒡ ᐅᔮᔨᐤ ᐋᐦ ᑎᒡ᙮ ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᐊᐅᔅᑖ ᒑ ᐋᐦᒀᑖᔨᐦᑖᑯᓃᔨᒡ ᑖᓐ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᑯᒡ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᐋᐦ ᐄᑖᐱᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒌ ᐙᐱᒫᐤ ᐋ ᒥᓯᒋᓰᔨᒡ ᐊᐙᔨᐤᐦ ᐋ ᐱᒋᔅᑎᓈᔨᒡ ᔓᐎᔮᓐ ᐊᓂᑎᐦ ᑳ ᒌ ᐱᒋᔅᑎᓂᒑᓂᐎᔨᒡ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ᐋᒄ ᑭᔮᐦ ᑳ ᐙᐱᒫᑦ ᐋ ᐹᔨᑯᔨᒡ ᐃᔅᒀᐤ ᐋ ᐅᐙᓂᓯᔨᔨᒡ ᐋ ᐱᒋᔅᑎᓈᔨᒡ ᓃᔓ ᔓᐎᔮᓈᐱᔅᑯᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᐱᒋᔅᑎᓂᒑᑦ ᐊᓐ ᑳ ᐹᔨᑯᑦ ᐃᔅᒀᐤ ᑳ ᒋᔅᑎᒫᑎᓯᑦ ᐊᑎᑎᐤ ᒥᔖᔨᐤ ᐐᔨ ᐅᐱᒋᔅᑎᓂᒑᐎᓐ ᐃᔥᐱᔥ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᐱᒋᔅᑎᓂᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ᐙᔥ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᐱᒋᔅᑎᓂᒑᒡ ᐃᔨᐙᒋᐱᔨᐎᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᑳ ᐱᒋᔅᑎᓈᐦᒡ᙮ ᐆ ᒫᒃ ᑳ ᐹᔨᑯᑦ ᐃᔅᒀᐤ, ᐋᑦ ᐋ ᐅᐙᓃᓰᑦ ᒌ ᐱᒋᔅᑎᓈᐤ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐅᔔᔮᓂᒻ ᒑ ᐅᐦᒋ ᐱᒫᒋᐦᐄᓱᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ᐱᔅᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᐋᔨᒸᐅᐦᐄᑯᒡ ᐋ ᐃᔥᐱᔥ ᒥᔻᔒᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᐋ ᒥᔪᔑᔨᒡ ᐊᓯᓃ ᐋ ᒌ ᐋᐱᒋᐦᐄᒫᑭᓂᐎᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒥᔻᔒᔨᒡ ᒥᔨᐙᐎᓐ ᐄᔨᔨᐅᒡ ᑳ ᐱᒋᔅᑎᓂᒧᐙᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ᒌᓴᔅ ᒫᒃ ᒌ ᐃᔨᐤ, “ᐅᐦᐄ ᑳ ᐙᐱᐦᑎᒫᒄ ᒑᒀᓂᐦᐄ ᐋᔥᒄ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᒥᓯᐙ ᒑ ᓂᔑᐎᓈᑎᐦᒡ᙮ ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᓯᓃ ᒋᑭ ᐅᐦᒋ ᐋᐦᑯᐃᐦᑎᐎᐱᐤ ᑯᑎᒃ ᐊᓯᓃ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᑎᐦᐋᑭᓅᑦ᙮ ᒥᓯᐙ ᐊᓯᓃᔨᒡ ᑳ ᐄᔑ ᐋᐱᒋᐦᐋᑭᓂᐎᒡ ᑳ ᐅᔑᐦᑖᑭᓂᐎᒡ ᐆ ᐙᔅᑳᐦᐄᑭᓐ ᒋᑭ ᓃᐦᒋᐙᐱᓈᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ᐊᓂᒌ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᑖᔨᔥᐱᔥ ᒑ ᐄᔅᐱᔨᒡ ᐆ? ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᔖᔥ ᐋ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐋᐦ ᐄᔅᐱᔨᒡ ᐆ?” ");
INSERT INTO crl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᔮᒀᒦᒄ ᐋᑳ ᐊᐙᓐ ᒑ ᒌ ᑳᒌᔑᒥᑖᒄ᙮ ᐙᔥ ᒋᑭ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐋ ᑎᑯᔑᐦᒡ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ ᐋᐦ ᐃᔨᒡ, ᐋᐅᒄ ᓃᔨ ᙭᙮ ᑭᔮᐦ ᒫᒃ ᒋᑭ ᐃᔨᐅᒡ, ᔖᔥ ᐹᔓᓈᑯᓐ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ᙮ ᐊᑳᐐ ᒫᒃ ᒋᑭ ᐅᐦᒋ ᓅᔔᔥᑯᐙᐙᐅᒡ ᐅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ᐹᐦᑎᒫᒀ ᐋ ᓂᑑᐱᔨᓈᓂᐎᒡ, ᑭᔮᐦ ᒫᒃ ᐋ ᒫᓯᐦᐄᑐᓈᓂᐎᒡ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᓵᒋᓯᓈᐙᐤ᙮ ᐙᔥ ᐋᐅᒄ ᔮᔨᑖ ᓃᔥᑎᒻ ᒑ ᐄᔅᐱᔨᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐋᔥᒄ ᒋᑭ ᐅᐦᒋ ᐅᑎᐦᒋᐱᔨᐤ ᐋ ᐃᔥᒀᐱᔨᐦᒡ ᐊᔅᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ᒦᓐ ᑳᐦ ᐋᑎ ᐄᑖᑦ, “ᐹᔨᑯᓂᐦᒡ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᑭᑎ ᒫᓯᐦᐄᑑᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐃᔨᐦᒡ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᐅᒋᒫᐅᒡ ᑭᑎ ᓂᑐᐱᔨᐦᑭᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᑳ ᐅᒋᒫᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ᑭᔮᐦ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᐦᒡ ᐆ ᐊᔅᒌ, ᓂᓈᐦᑭᐤ ᐊᓂᑖᐦ ᒋᑭ ᑯᐃᐦᑯᓐ ᑭᔮᐦ ᒋᑭ ᑭᐎᐦᑭᑖᓂᐤ, ᑭᔮᐦ ᒥᔥᑏᐦ ᐋ ᒫᔮᑎᐦᒡ ᐋᐦᑯᓯᐎᓐ ᒋᑭ ᑎᑯᓐ᙮ ᑭᔮᐦ ᒋᑭ ᓅᑯᓐ ᒋᔅᒋᓄᐙᐱᐦᑎᔨᐙᐎᓐ ᐋ ᑯᔥᑖᑎᑯᐦᒡ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ᐋᔥᒄ ᐋᒸᔮ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ, ᒋᑭ ᐅᑎᓂᑯᓈᐙᐤ ᐋᒄ ᒑ ᓂᓈᐦᑳᒋᐦᐄᑯᐎᔮᒄ᙮ ᒋᑭ ᐄᑐᐦᑎᐦᐄᑯᐙᐅᒡ ᒎᐤ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᐙᐦᒡ ᒑ ᑎᐹᔅᑯᓂᑖᑯᒡ, ᐋᒄ ᒑ ᒋᐱᐦᐆᑖᑯᒡ᙮ ᑭᔮᐦ ᒋᑭ ᐄᑐᐦᑎᐦᐄᑯᐙᐅᒡ ᒋᔖᐅᒋᒫᐤ ᑭᔮᐦ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑏᑖᒄ ᓃᔨ ᐅᐦᒋ ᐋ ᐹᒋ ᓅᔔᔥᑭᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ᐆ ᒫᒃ ᑐᑖᑯᔮᒀ, ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒥᔪᐱᔮᒄ ᒑ ᒌ ᐐᐦᑎᒧᐙᑯᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᒌ ᐅᒋᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ᓂᔮᑭᓐᐦ ᒋᐱᐦ ᐎᔮᔨᐦᑖᓈᐙᐤ ᐋᑳ ᒑ ᐅᐦᒋ ᐋᔨᒫᔨᐦᑎᒫᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᐙᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ᐙᔥ ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᒑ ᐃᔨᔮᒄ ᑭᔮᐦ ᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓐ ᒋᑭ ᒥᔨᑎᓈᐙᐤ ᒑ ᒌ ᑭᒑᐦᑖᐙᔨᐦᑎᒨᐦᑖᑯᓯᔮᒄ ᐋᔨᒥᔮᒀ, ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᑖᑯᒡ ᓂᒧᐃ ᒋᑭ ᒌ ᐋᓍᐦᑎᒧᒡ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᔅᒀᔒᐦᐄᑯᐙᐅᒡ ᒑ ᐃᔨᐙᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ᐙᐙᒡ ᒋᓃᒋᐦᐄᑯᐙᐅᒡ, ᒌᒋᔖᓂᐙᐅᒡ ᒋᐙᐦᑯᒫᑭᓄᐙᐅᒡ, ᑭᔮᐦ ᒋᐐᒑᐙᑭᓄᐙᐅᒡ ᒋᑭ ᐄᑐᐦᑎᐦᐄᑯᐙᐅᒡ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ, ᒋᑭ ᑐᑖᑯᐙᐅᒡ ᐱᔅᒡ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᒑ ᒌ ᓂᐱᐦᐄᑯᐙᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ᒥᓯᐙ ᐊᐙᓐ ᒋᑭ ᐅᐦᑳᑎᑯᐙᐤ ᐋ ᓅᔔᔥᑭᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒋᑭ ᒥᔪᐱᔨᓈᐙᐤ, ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒀᐹᒡ ᒋᔅᑎᒀᓂᐲᐙᐙᐤ ᒋᑭ ᐅᐦᒋ ᐎᓂᐦᑖᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ᒋᑭ ᐃᔮᓈᐙᐤ ᒋᐦᒋᐙ ᐱᒫᑎᓰᐎᓐ ᐋᑳ ᓅᐦᑎ ᐴᓂᔮᒀ ᐋ ᓅᔔᔥᑭᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“ᐄᔥᐱᐦ ᒫᒃ ᐙᐱᒫᒀᒑ ᓂᑐᐱᔫᒡ ᐋ ᐙᔅᑳᑳᐳᔥᑎᐦᒡ ᒉᕉᓯᓕᒥᔨᐤ, ᐋᒄ ᒑ ᒋᔅᒑᔨᐦᑎᒫᒄ ᔖᔥ ᐋ ᐹᔓᓈᑯᐦᒡ ᒑ ᓂᔑᐎᓈᒋᐦᑖᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ, ᐊᓂᑖᐦ ᐋᐱᔅᑯᑎᓈᐦᒡ ᒋᑭ ᐄᑎᔓᒨᒡ᙮ ᐋᒄ ᐊᓂᒌ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ ᒑᔥᑎᓂᐤ ᒋᑭ ᐐᐦ ᓂᑭᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑎᐹᔅᒍ ᒑ ᑖᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᐊᑳᐐ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ᐋᐅᒄ ᒫᒃ ᐆ ᒑ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐄᔨᔨᐅᒡ ᐎᔮᔅ ᒑ ᑐᑎᐙᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᐦᒡ, ᐙᔥ ᐋᐅᒄ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑖᑯᐦᒡ ᐊᓐ ᑳ ᐄᔑ ᒥᓯᓈᐦᐄᑭᓂᐎᒡ ᒑ ᐄᔑ ᑎᐱᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ᑖᑆᐦ ᑭᑎ ᐋᔨᒥᓂᔨᐤ ᐊᓂᒌ ᒫᒀᒡ ᑳ ᒋᒋᔥᑯᐙᒡ ᐊᐙᔑᔥ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓅᔖᓂᐦᐋᐅᓱᒡ ᐊᓂᔮᔨᐤ ᒑ ᒌᐦᔑᑳᔨᔨᒡ᙮ ᓄᐎᒡ ᒋᑭ ᐋᔨᒥᓂᔨᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᑖᐦᑭᐎᐙᔓᐎᓂᔨᐤ ᒥᑐᓐ ᒋᑭ ᐱᐦᑎᑯᔥᑳᑰᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ ᒋᑭ ᐋᐱᑎᓂᔨᐤ ᐋ ᓂᐱᐦᐋᑭᓂᐎᒡ᙮ ᐋᒄ ᑯᑎᑭᒡ ᒑ ᐅᑎᓈᑭᓂᐎᒡ, ᓂᓈᐦᑭᐤ ᐊᔅᒌᐦᒡ ᒑ ᐄᑐᐦᑎᐦᐋᑭᓂᐎᒡ᙮ ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒥᑐᓐ ᑭᑎ ᐐᐦ ᓂᔑᐎᓈᒋᐦᑖᐅᒡ ᒉᕉᓯᓕᒥᔨᐤ, ᐹᑎᔥ ᒋᔖᒥᓂᑑ ᒋᔅᑎᐦᐋᒫᑯᑣᐙ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ᒋᑭ ᓅᑯᓐ ᒋᔅᒋᓄᐙᐱᐦᑎᔨᐙᐎᓐ ᐊᓂᑖᐦ ᐲᓯᒧᐦᒡ, ᑎᐱᔅᒋᐲᓯᒧᐦᒡ, ᑭᔮᐦ ᐊᓂᑖᐦ ᐊᒋᐦᑯᔑᐦᒡ, ᐋ ᐐᐦᑎᒫᑯᐎᔮᒄ ᒑᒀᓐ ᒑ ᐄᔅᐱᔨᒡ ᒑ ᒌ ᐃᔮᒀᒥᔮᒄ᙮ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ ᐊᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᓵᒋᓲ᙮ ᒋᑭ ᓵᒋᐦᐄᑯᒡ ᑖᓐ ᒑ ᐄᑎᐦᑖᑯᓃᔨᒡ ᒋᐦᒋᑭᒥᔨᐤ, ᐋᐦᒌᔂᐙᒥᑭᓃᔨᒡ ᑭᔮᐦ ᐊᒥᒥᐦᑳᐦᐋᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ᒋᑭ ᐋᑰᐙᔨᐦᑎᒧᐎᒡ ᐄᔨᔨᐅᒡ ᐋ ᐃᔥᐱᔥ ᑯᔥᑖᒋᒡ ᐋ ᒫᒥᑐᓈᔨᐦᑎᐦᒡ ᑖᓐ ᐋᔥᒄ ᒑ ᐄᔅᐱᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ᑭᔮᐦ ᒥᓯᐙ ᒑᒀᓐ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᑭᑎ ᔮᔮᐦᒋᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ᐋᒄ ᒫᒃ ᒑ ᐙᐱᒫᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐹᒋ ᔮᓰᑦ ᑭᔥᑭᐎᓂᔅᑰᐦᒡ, ᒥᑐᓐ ᐋ ᓅᑯᓃᔨᒡ ᐅᓲᐦᑳᑎᓰᐎᓐ ᑭᔮᐦ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ᐄᔥᐱᐦ ᒫᒃ ᒋᐦᒋᐱᔨᐦᒑ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ, ᓲᐦᒃ ᐃᔥᐱᒥᐦᒡ ᐄᑖᐱᒄ, ᐙᔥ ᔖᔥ ᐹᔓᓈᑯᓐ ᒑ ᐱᒫᒋᐦᐄᑯᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ᐋᒄ ᒌᓴᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐃᔨᑦ, “ᒫᒥᑐᓈᔨᒫᐦᒄ ᒫᐦ ᐆ ᒥᓯᔔᒥᓈᐦᑎᒄ, ᑭᔮᐦ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᒥᔅᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ᐄᔥᐱᐦ ᐎᔮᐱᐦᑎᒫᒄ ᓃᐱᓰᐦ ᐋ ᓂᐦᑖᐅᒋᐦᒡ, ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᔖᔥ ᐋ ᐹᔓᓈᑯᐦᒡ ᒑ ᓃᐱᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ᐋᐅᒄ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ᙮ ᐄᔥᐱᐦ ᐙᐱᐦᑎᒫᒀ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᐋᐦ ᐄᔅᐱᔨᒡ ᒋᑭ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᓈᔥᒡ ᐋ ᐹᔓᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᒌ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓅᐦᒡ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᒫᐦᒋ ᓂᐱᐎᒡ ᐋᒸᔮ ᑎᐱᐱᔨᒡ ᒥᓯᐙ ᑖᓐ ᒑ ᐄᔅᐱᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ ᑭᑎ ᐃᔅᒀᐱᔨᐤ ᒥᒄ ᒫᒃ ᓂᑎᔨᒧᐎᓐ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐃᔅᒀᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ᔮᒀᒦᒄ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔮᒄ᙮ ᐊᑳᐐ ᐅᑎᒥᐦᐄᓱᒄ ᐱᔑᔑᐦᒄ ᒑ ᒌ ᒥᓂᐦᒀᔮᒄ ᑭᔮᐦ ᒫᒃ ᐱᔑᔑᐦᒄ ᒑ ᒌ ᒦᒋᓱᔮᒄ ᑭᔮᐦ ᒫᒃ ᐱᔑᔑᐦᒄ ᒑ ᒌ ᐋᔨᒫᔨᐦᑎᒫᒄ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᓈᓂᐎᒡ᙮ ᐊᓐ ᑎᔮᒀ ᒋᑭ ᒌ ᐃᓯᓈᑯᓐ ᔑᔥᒋᑯᒡ ᒑ ᒌ ᑎᑯᔑᓂᔮᓐ ᒫᒀᒡ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᐄᑖᔨᐦᑎᒫᒄ᙮ ᐊᓐ ᒫᒃ ᔑᔥᒋᑯᒡ ᑎᑯᔑᓂᔮᓈ, ᒸᐦᒡ ᐊᐅᐦᑳᓐ ᐋᐦᐋᑳ ᐹᔣᔨᐦᑎᐦᒃ ᓂᒀᓂᔨᐤ ᒑ ᓂᒀᓱᑦ ᐋᐅᒄ ᐊᓐ ᒑ ᐄᑖᔨᐦᑖᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ᒥᓯᐙ ᐊᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᑦ ᐋᑳ ᐃᔮᔅᑭᐐᒑ ᒋᑭ ᑯᔅᑯᓯᐤ ᑎᑯᔑᓂᔮᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ᔮᒀᒦᒄ ᒨᔥ᙮ ᐊᑳᐐ ᐴᓃᒄ ᐋ ᐊᔨᒥᐦᐋᔮᒄ ᐋ ᓂᑐᑎᒫᔮᒄ ᒑ ᒌ ᔮᐃᒋᑳᐳᔮᒄ ᑭᔮᐦ ᒑ ᒌ ᔖᐳᔥᑭᒫᒄ ᒥᓯᐙ ᑖᓐ ᒑ ᐄᔅᐱᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᒑ ᒌ ᐋᑎᐙᔨᒥᑖᒄ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐄᔥᐱᐦ ᐎᑎᔅᑭᐎᑳᐳᔥᑎᐙᒀ᙮” ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᒌᓴᔅ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᒌ ᐄᑐᐦᑖᑦ, ᒑ ᒌ ᑖᑦ ᐊᓂᔮᔨᐤ ᒑ ᑎᐱᔅᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ᐐᐱᒡ ᒫᒃ ᒋᔮᒋᔖᐹᔮᔨᒡ, ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᒌ ᓂᑑᓂᑑᐦᑎᐙᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ᒌ ᐹᔓᓈᑯᓐ ᒫᒃ ᐊᓐ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᑳ ᒌ ᒨᐙᑭᓅᑦ ᐋᐦᐋᑳ ᐅᐦᐱᓱᑦ ᐋᐃᐦᑯᓈᐤ᙮ ᐋᐅᒄ ᐊᓐ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌᒧᒡ ᑳ ᐐᐦ ᓈᓂᑐ ᒥᔅᑭᐦᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᓴᔅᐦ, ᐙᔥ ᒌ ᑯᔥᑖᐅᒡ ᐄᔨᔨᐤᐦ ᐎᔮᔥ ᒑ ᒌ ᑐᑖᑯᒡ ᒥᒄ ᐄᔑ ᐅᑎᓈᑣᐙ ᐊᓂᔮᔨᐤᐦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌᓴᔅ, ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᒌ ᐲᐦᒋᔥᑳᑯᔨᐤ ᒥᒋᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ᒍᑖᔅ ᒫᒃ ᒌ ᓂᑭᑖᐤ ᒌᓴᔅᐦ ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑳ ᓂᑑᐋᔨᒨᑎᒧᐙᑦ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᑳᒋᔅᑎᓈᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ᓄᐎᒡ ᑭᔨᑆ ᒌ ᓯᒋᔮᐦᐄᑯᒡ ᐊᓂᒌ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒍᑕᔅᐦ ᑭᔮᐦ ᒫᒃ ᒌ ᓂᔅᑯᒨᐎᒡ ᒑ ᒌ ᒥᔮᒡ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ᐋᒄ ᒍᑖᔅ ᑳ ᓂᔅᑯᒧᑦ ᐊᓂᔮᔨᐤ ᑳ ᐐᐦ ᐄᑖᐱᒋᐦᐋᑭᓅᑦ᙮ ᐋᒄ ᒫᒃ ᒨᔥ ᑳ ᓈᓂᑐᐙᔨᐦᑎᐦᒃ ᒑᒀᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ᙮ ᐊᓂᑎᐦ ᒫᒃ ᐋᑳ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒥᔨᒡ ᐋ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᒑ ᒌ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","ᐋᒄ ᑳ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐊᓐ ᐋᒋᔑᑳᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᓂᐱᐦᐋᒡ ᒫᓂᔥᒑᓂᔥ ᒑ ᒥᑯᔖᐙᒑᒡ᙮ ᑭᔮᐦ ᒫᒃ ᐋᐃᐦᑯᓈᐤ ᐋᐦᐋᑳ ᐅᐦᐱᓱᔨᒡ ᒌ ᐊᔅᒋᒧᐙᐅᒡ᙮ ᐆ ᒫᒃ ᑳ ᐊᔨᐦᑎᓈᓂᐎᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ᒌᓴᔅ ᒌ ᒋᐦᒋᑎᔑᐦᐙᐤ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᐋᐦ ᐄᑖᑦ, “ᒫᒌᒄ ᓂᑑᐃᔮᔅᑰᔥᑖᒄ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᐊᓐ ᒑᒦᒋᔨᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ᒌ ᐄᑎᑰ ᒫᒃ, “ᑖᓂᑖᐦ ᓈᑐᐙᔨᐦᑎᒥᓐ ᒑ ᒌ ᐃᔮᔅᑰᔥᑖᔮᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐄᔥᐱᐦ ᐅᑎᐦᑎᒫᒀ ᐊᓐ ᐃᐦᑖᐎᓐ, ᓈᐹᐤ ᒋᑭ ᓂᒋᔥᑭᐙᐙᐤ ᐋ ᒌ ᒀᐱᒑᑦ᙮ ᐋᐅᒄ ᒑ ᓅᔔᔥᑯᐙᒄ ᑖᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᒑ ᐲᐦᒑᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ᐋᒄ ᒑ ᐄᑖᒄ ᐊᓐ ᓈᐹᐤ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ‘ᐋᒄ ᐃᔮᑦ ᓂᒋᔅᑯᑎᒫᒑᓰᒥᓈᓐ, ᑖᓂᑖᐦ ᐋᐦᑎᑯᐦᒡ ᐊᓐ ᐋ ᐱᔅᒑᒡ ᐊᓂᑖᐦ ᒑ ᐐᒋᒥᑯᔖᒫᐅᒋᐱᓈᓂᒋ ᓂᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᔨᐤ?’ ");
INSERT INTO crl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ᐋᒄ ᒑ ᐙᐱᐦᑏᑖᒄ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᐋ ᒥᔖᔨᒡ ᐋ ᐱᔅᒑᔨᒡ ᔖᔥ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑖᑯᓃᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᒑ ᐃᔮᔅᑭᐎᔥᑖᔮᒄ ᐊᓐ ᒥᑯᔖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ᒌ ᐄᑐᐦᑖᔨᐤ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᑭᔮᐦ ᒌ ᒥᔅᑭᒥᔨᐤ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᒌᓴᔅ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐃᔮᔅᑰᔥᑖᒡ ᐊᓂᔮᔨᐤ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᒋᐱᔨᔨᒡ ᒑ ᒦᒋᓱᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳ ᐅᐙᔮᐱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᓈᔥᑖᑆᐦ ᓂᒌ ᐱᑯᓵᔨᐦᑎᒥᐦᐄᑯᓐ ᒑ ᒌ ᐐᒋᒦᒋᓲᒥᑎᑯᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓐ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᑎᐦᒋᐱᔨᐦᒡ ᒑ ᐄᔑ ᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᑭᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᒦᓐ ᓂᑭ ᐅᐦᒋ ᒦᒋᓐ ᐆ ᒥᑯᔖᓐ ᐹᑎᔥ ᐅᑎᐦᒋᐱᔨᐦᒑ ᑖᓐ ᐋ ᐄᔑ ᓂᔅᑐᐦᑖᑭᓂᐎᒡ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐆ ᒥᑯᔖᐎᓐ ᑎᐱᐲᔨᒑ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ᒌ ᐅᑎᓂᒻ ᒥᓂᐦᒀᑭᓂᔨᐤ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐅᑎᓂᒧᒄ ᐆ, ᒥᓂᐦᒀᒄ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ᐙᔥ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᒧᐃ ᒦᓐ ᓂᑭ ᐅᐦᒋ ᒥᓂᐦᒀᓐ ᔔᒥᓈᐳᐃ ᐹᑎᔥ ᐅᑎᐦᒋᐱᔨᔨᒑ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ᒌ ᐅᑎᓈᐤ ᒫᒃ ᐋᐃᐦᑯᓈᐤ, ᒌ ᓂᓈᔅᑯᒨ ᒫᒃ ᑭᔮᐦ ᒌ ᐱᐦᒀᓈᐤ ᐋᒄ ᑳ ᒫᒥᔮᑦ, ᐋᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᐆ ᓂᔨᐤ ᐋ ᐄᔑ ᒥᔨᐙᓂᐎᒡ ᒌᔨᐙᐤ ᐅᐦᒋ, ᒧᐙᐦᒄ ᐆ ᐋᐃᐦᑯᓈᐤ, ᐆ ᒫᒃ ᑐᑎᒧᒄ ᐋ ᒌᔅᒋᑐᐎᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ᐋᔪᐎᒄ ᐊᔮᐱᒡ ᑳᐦ ᑐᑎᐦᒃ ᐋ ᐅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᒥᓂᐦᒀᑭᓂᔨᐤ, ᐄᔥᐱᐦ ᑳ ᒌᔥ ᒦᒋᓱᒡ᙮ ᒌᐦ ᐄᑖᐤ, “ᐆ ᔔᒥᓈᐳᐃ ᐋᐅᒄ ᓂᒥᐦᒄ, ᒌᔨᐙᐤ ᐅᐦᒋ ᒑ ᔑᒋᑭᐎᑖᑭᓂᐎᒡ ᒑ ᒌ ᐅᐦᒋ ᒥᔨᑯᐎᔮᒄ ᐋ ᐅᔅᑳᒡ ᓂᔅᑯᒧᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“ᐙᐱᑎᒧᒄ ᒫᐦ, ᐊᓐ ᐊᐙᓐ ᒑ ᒫᒥᔑᒥᑦ ᐋᑯᑖᐦ ᐅᑎᐦ ᐙᑎᐱᒥᑎᐦᒄ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ᑭᑎ ᓂᐱᐦᐋᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᔖᔥ ᐎᔮᔨᐦᑖᑭᓂᐎᒡ᙮ ᒥᒄ ᒫᒃ ᑖᑆᐦ ᑭᑎ ᐋᐦᒀᒡ ᒥᒋᐱᔨᐤ ᐊᓐ ᐊᐙᓐ ᒑ ᒫᒥᔑᒫᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ᐋᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᑯᒀᒋᒥᑐᔨᐤ, “ᐊᐙᓐ ᒫᒃ ᐅᑎᐦ ᐋᐦᑎᔒᐦᒄ ᒋᐱᐦ ᐐᐦ ᑐᑎᒻ ᐅᔮᔨᐤ?” ");
INSERT INTO crl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ᒌ ᐋᔮᔥᑖᒥᑑᐎᒡ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ, ᐊᐙᓐ ᐊᓐ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᒫᐅᒡ ᐋ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᓈᔥᒡ ᐐᐦ ᑭᑎᐹᔨᒫᐅᒡ ᐅᔮᔨᐤ ᐄᔨᔨᐤ᙮ ᐅᒌ ᒫᒃ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐅᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ, ᑳ ᒥᔪ ᑭᓂᐙᔨᒧᐙᒡ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ᒌᔨᐙᐤ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᐃᔨᐦᒡ ᐙᔥ ᒋᐱᐦ ᐄᑖᔨᐦᑖᑯᓯᓈᐙᐤ᙮ ᐊᐙᓐ ᐙᐦ ᐄᔅᐱᔨᐦᑖᑯᓯᒀ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ, ᐋᑯᔥ ᐊᓐ ᐊᐙᓐ ᒫᐅᒡ ᐋᐙᓰᐙᔨᐦᑖᑰᓱᑦ ᒋᐱᐦ ᐄᑎᐦᐄᓲ᙮ ᐋᒄ ᐊᓐ ᑖᓐ ᐙᐦ ᓃᑳᓂᔥᑳᒑᒀ ᐋᑯᔥ ᓰᑎᐤ ᑭᑎ ᐱᒋᔅᑎᓃᓱᐤ ᒑ ᐋᐱᑎᔒᔥᑎᐙᑦ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ᐙᔥ ᐊᓐ ᑳ ᐊᐱᑦ ᐊᓂᑎᐦ ᒦᒋᓲᓈᐦᑎᑯᐦᒡ ᐊᐅᔅᑖ ᐄᔅᐱᔨᐦᑖᑯᓲ ᐄᑖᔨᒫᑭᓂᐤ ᐃᔥᐱᔥ ᐐᔨ ᐊᓐ ᑳ ᒫᑎᓂᐙᑦ᙮ ᓃᔨ ᒫᒃ ᓂᒌ ᐱᐹᐃᔨᐦᑖᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐋᐦ ᐋᐱᒋᐦᐋᑭᓅᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ᒌᔨᐙᐤ ᒫᒃ ᒨᔥ ᒋᒌ ᐹᒋ ᐙᐐᒑᐅᓈᐙᐤ ᐋᑎ ᐊᓂᑎᐦ ᒫᒀᒡ ᐋ ᒌ ᐋᔨᒥᐦᐅᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ᓅᐦᑖᐐ ᓂᒌ ᐱᒋᔅᑎᓂᒫᒄ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᐊᓂᑖᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᐦᒡ, ᐋᒄ ᒫᒃ ᓃᔨ ᒑ ᐱᒋᔅᑎᓂᒫᑎᑯᒡ ");
INSERT INTO crl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ᒑ ᒌ ᐐᒋᒦᒋᓲᒥᔮᒄ ᑭᔮᐦ ᒑ ᒌ ᐐᒋᒥᓂᐦᒀᒥᔮᒄ ᓂᒦᒋᓲᓈᐦᑎᑯᐦᒡ ᐊᓂᑖᐦ ᓂᒋᔥᒍᒋᒫᐎᓂᐦᒡ᙮ ᒋᑭ ᐊᐱᓈᐙᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑖᐦᑎᐱᐎᓐ ᐋᑎ ᒑ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑯᒡ ᑳ ᓃᔓᔖᐳᔅᑳᓈᓯᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","ᐋᒄ ᒌᓴᔅ ᓵᐃᒥᓐᐦ ᐲᑎᕐᐦ, ᑳᐦ ᐄᑖᑦ, “ᓵᐃᒥᓐ ᐲᑎᕐ, ᓵᐃᒥᓐ ᐲᑎᕐ, ᒥᒋᒥᓂᑑ ᒌ ᑯᒀᒋᐦᒑᒨ ᒑ ᒌ ᑯᒀᒋᐦᐄᔅᒃ ᒧᔮᒻ ᐋ ᓰᑭᐙᐱᔨᐦᐄᔅᒃ ᒑ ᒌ ᑐᑖᔅᒃ᙮ ᒋᐐᐦ ᑐᑖᒄ ᒧᔮᒻ ᓂᐦᑖᐅᒋᐦᒑᓯᐤ ᑳ ᒌᐦ ᑐᑎᐙᑦ ᐱᐦᒀᔑᑭᓐ ᐋ ᓰᑭᐙᐱᔨᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ᒋᒌ ᐊᔨᒥᐦᒋᑳᔥᑎᒫᑎᓐ ᒫᒃ ᒌᔨ ᐋᑳ ᒑ ᒌ ᐴᓃᔨᓐ ᐋ ᑖᑆᔮᔨᐦᑎᒥᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒌᔥ ᑯᒀᒋᐦᐄᔅᑳ ᒥᒋᒥᓂᑑ ᒦᓐ ᒫᒃ ᑳᐤ ᒌ ᐹᒋ ᓈᔒᓐ ᒑ ᔮᐃᒋᑳᐳᐦᐄᑣᐤ ᒌᒋᔖᓂᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ ᐄᔑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ᐲᑎᕐ ᒌᐦ ᐄᑖᐤ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒥᑐᓐ ᓂᑖᔮᔅᑭᐎᔨᓐ ᒑ ᒌ ᐐᒑᐅᑖᓐ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᑭᔮᐦ ᓂᐱᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᒋᐐᐦᑎᒫᑎᓐ ᐲᑎᕐ, ᐋᔥᒄ ᐋᒸᔮ ᒋᔅᑐᑖ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ ᐊᓅᐦᒡ ᒑ ᒌᔑᑳᔨᒡ ᔖᔥ ᓂᔥᑣᐤ ᒋᑭ ᓂᓂᑎᔨᓐ ᐋᐦ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᒌᓴᔅ, “ᐄᔥᐱᐦ ᑳ ᒋᐦᒋᑎᔑᐦᐆᑎᑯᒡ ᓂᒧᐃ ᑰᐦᒋ ᐃᔮᓈᐙᐤ ᔓᐎᔮᓂᐎᑦ ᑭᔮᐦ ᒫᒃ ᒦᐎᑦ ᑭᔮᐦ ᒫᒃ ᒥᔅᒋᓐ᙮ ᒑᒀᓐ ᒫᒃ ᑳ ᓅᐦᑖᐱᔮᒄ?” ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᓂᒧᐃ ᒑᒀᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ᐋᒄ ᒦᓐ ᑳᐦ ᐄᑖᑦ, “ᐊᓅᐦᒡ ᒫᒃ ᐋᒄ ᓈᑐᐙᔨᐦᑖᑯᐦᒡ ᔮᔨᑖ ᒑ ᒌ ᐃᔮᔮᒄ ᔓᐎᔮᓅᑦ ᑭᔮᐦ ᒥᐎᑦ ᑭᔮᐦ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᐃᔮᒑ ᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ, ᒋᐱᐦ ᐊᑖᐙᒑᐤ ᐅᑎᑯᐦᑉ ᒑ ᒌ ᐅᐦᒋ ᐅᑎᓂᐦᒃ ᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ᐙᔥ ᐆ ᐙᐦᒋ ᐄᑎᑯᒡ ᑭᑎ ᑎᐱᐱᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐋᔨᒨᒥᑭᐎᔮᓐ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᒡ, ᒌ ᐊᔅᑎᒋᒫᑭᓂᐤ ᐊᓂᑖᐦ ᒋᒧᑎᔅᑳ ᐋᐦ ᑖᔨᒡ᙮ ᐆ ᑭᔮᐦ ᒫᒃ ᑳ ᐄᔑ ᑎᐹᒋᒥᑭᐎᔮᓐ ᑖᑆᐦ ᑭᑎ ᐄᔅᐱᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᒡ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᑎᔮᓈᓐ ᓃᔓ ᓂᑐᐱᔫᐦᑯᒫᓐ᙮” ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᐊᑰᓐ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ᒌ ᓂᑭᑎᒻ ᒫᒃ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋᒄ ᐊᓂᑖᐦ ᐊᓕᕕᔅ ᐋᐱᔅᑯᑎᓈᔨᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᒌ ᑎᑯᐱᓈ ᒫᓐ᙮ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒫᒃ ᒌ ᐐᒑᐅᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐊᔨᒥᐦᐋᒄ ᐋᑳ ᒑ ᒌ ᔑᐦᑯᒋᐦᐄᑯᔮᒄ ᑯᒀᒋᐦᐄᐙᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ᒌ ᓂᑭᑖᐤ ᒫᒃ ᐋᒄ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᑦ ᐎᔮᔥ ᐋ ᐙᐱᓈᑭᓅᑦ ᐊᓯᓃ ᐋᐦ ᐄᔅᐱᓯᓈᑯᓃᔨᒡ᙮ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᑦ ᐊᓂᑖᐦ ᐋ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ᑳᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᐹᒋ ᐄᒑᓂᒨ ᐆ ᒑ ᐄᔑ ᐙᐐᓯᒑᔨᐦᑎᒧᐙᐱᓈ ᒥᓂᐦᒀᑭᓐ, ᒥᒄ ᒫᒃ ᒌᔨ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᒋᑭ ᐐᐦ ᑐᑖᑭᓂᐤ, ᓂᒧᐃ ᓃᔨ ᓂᑎᐄᑖᔨᐦᑎᒧᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ᐋᒄ ᐋᓐᒋᓐ ᑳ ᓅᑯᓰᔥᑖᑯᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ ᐋ ᒥᔨᑯᑦ ᒥᔅᑭᐎᓰᐅᓂᔨᐤ ᒑ ᒌ ᔖᐳᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᒑ ᐄᔑ ᓂᒋᔥᑭᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ᓈᔥᑖᑆᐦ ᒌ ᑯᔑᑯᑖᐦᐋᔅᑳᑰ᙮ ᐋᒄ ᒫᒃ ᐊᑎᑎᐤ ᓲᐦᒃ ᑳ ᐊᔨᒥᐦᐋᑦ᙮ ᒑᒃ ᒧᔮᒻ ᒥᐦᑯᔨᐤ ᐋ ᐹᐱᐦᒋᑭᐎᔨᒡ ᐊᓂᑖᐦ ᐄᔑ ᐊᔅᒌᐦᒡ ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐊᑆᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ᒌ ᐱᓯᑰ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ᙮ ᒦᓐ ᑳᐤ ᑳ ᓈᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᓂᐹᔨᒡ ᒥᑐᓐ ᐋ ᒌ ᐋᒌᔥᒋᑯᔅᑎᒥᑯᔨᒡ ᐅᒥᓯᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᓐ ᐋᐃᐦᑎᔮᒄ ᐙᐦᒋ ᓂᐹᔮᒄ? ᐎᓂᔥᑳᒄ ᒑ ᐊᔨᒥᐦᐋᔮᒄ ᐋᑳ ᒑ ᒌ ᔑᐦᑯᒋᐦᐄᑯᔮᒄ ᑯᒀᒋᐦᐄᐙᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᑦ ᒌᓴᔅ ᒌ ᐅᐦᒋ ᑎᑯᔑᓂᔨᐤ ᐊᐙᔨᐤᐦ ᐋ ᒫᐅᓯᑯᐦᑖᔨᒡ᙮ ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᒍᑖᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᒌ ᐹᒋ ᓃᑳᓂᐦᑖᔨᐤ ᑳ ᓈᑎᑯᑦ ᐋᒄ ᑳ ᐅᒑᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒍᑕᔅᐦ, “ᐋᑯᑖᐦ ᐋ ᒑ ᐅᐦᒋ ᒫᒥᔑᒥᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐅᒑᒥᑦ?” ");
INSERT INTO crl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ᒥᔔ ᒫᒃ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᑖᓐ ᒑ ᐄᔅᐱᔨᒡ ᒌ ᐄᑖᐅᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐋᒄ ᐋ ᒑ ᐋᐱᒋᐦᑖᔮᐦᒡ ᓂᑑᐱᔫᐦᑯᒫᓈᓐ?” ");
INSERT INTO crl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᓈᑖᔨᐤ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤᐦ ᑳ ᒋᒥᓯᒸᑦ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᒑ ᐅᐦᑎᐎᑳᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᐋᑯᓐ ᒫᒃ᙮” ᐋᒄ ᒫᒃ ᑳ ᑖᐦᒋᓂᒸᑦ ᐅᐦᑎᐎᑳᔨᐤ ᐊᓂᔮᔨᐤᐦ ᐋᐱᒋᐦᐋᑭᓐᐦ, ᑳ ᒦᓂᐙᒋᐦᑖᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑳ ᓂᑎᐙᐱᒥᑯᑦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᒋᐱᐦᐅᐙᔓᐤᐦ ᑳᐦ ᐋᐱᑎᔒᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤᐦ, “ᒑᒀᓐ ᐙᐦᒋ ᐹᒋ ᓂᑎᐙᐱᒥᔮᒄ ᒧᔮᒻ ᒋᒧᑎᔅᒃ ᑳ ᒌᐦ ᑐᑎᐙᑭᓅᑦ ᐋ ᓂᑎᐙᐱᒫᑭᓅᑦ, ᐋ ᐹᒋ ᑎᑯᓂᒫᒄ ᓂᑐᐱᔫᐦᑯᒫᓐ ᑭᔮᐦ ᐅᑖᒥᐦᐄᑭᓈᐦᑎᒄ? ");
INSERT INTO crl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ᐋᑦ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᐋ ᒌᐦ ᑖᔨᐦᒄ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᑯᒋᐦᑖᓈᐙᐤ ᒑ ᒌ ᐅᑎᓂᔮᒄ᙮ ᐋᒄ ᒫᒃ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒑ ᒌ ᐄᐦᑐᑎᒫᒄ ᑖᓐ ᐙᐦ ᐄᐦᑐᑎᒫᒄ ᒫᒀᒡ ᐋ ᓲᐦᒑᔨᐦᑖᑯᐦᒡ ᐎᓂᑎᐱᔅᒋᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ᐋᒄ ᒫᒃ ᑳ ᐅᑎᓈᒡᐦ ᒌᓴᔅᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐐᒋᔨᐦᒡ᙮ ᐲᑎᕐ ᒫᒃ ᐙᐦᐄᐎᔥ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒌ ᐹᒋ ᓅᔔᔥᑳᒑᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ᒌ ᑯᑎᐙᓅᔨᐤ ᒫᒃ ᐊᓂᑎᐦ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ, ᐋᑯᑖᐦ ᑳ ᓂᐦᐊᐱᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᐲᑎᕐ ᒫᒃ ᒌ ᓈᑖᐤ ᐊᓂᔮᔨᐤ ᐋᒄ ᑳ ᐐᑎᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ᐋᐱᒋᐦᐋᑭᓐ ᐃᔅᒀᐤ ᒫᒃ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒌ ᐙᐱᒫᐤ ᐲᑎᕐ ᐋ ᐊᐱᔨᒡ ᐊᓂᑖᐦ ᐋ ᓵᑖᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔥᑯᑖᔨᐤ᙮ ᔮᒀᐦ ᒫᒃ ᒌ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᐲᑎᕐ, ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᐆ ᒫᐦ ᓈᐹᐤ ᒌ ᐐᒑᐙᐤ ᑭᔮᐦ ᐐᔨ ᒌᓴᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ᐲᑎᕐ ᒫᒃ ᒌᐦ ᐄᑖᐤ, ᐋ ᓂᓂᑎᔨᑦ, “ᓂᒧᐃ ᒌ ᑖᑆᓐ᙮ ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᐤ ᐊᓐ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ᐹᑎᒫ ᒫᒃ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒌ ᐙᐱᒥᑰ ᐲᑎᕐ ᐊᓂᑎᐦ ᐋ ᐊᐱᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ, “ᐋᑯᑖᐦ ᑭᔮᐦ ᒌᔨ ᑳ ᐐᒋᐦᐄᐙᔨᓐ ᐊᓂᒌ ᑳ ᐐᒑᐙᒡ ᒌᓴᔅᐦ᙮” “ᓂᒥᔮᐤ ᓃᔨ,” ᒌᐦ ᐄᑖᐤ ᐲᑎᕐ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᒑᒀᓐ ᐊᓐ ᑳᐦ ᐋᔨᒸᐦᐄᑯᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ᐋᒄ ᒫᒃ ᐎᔮᔥ ᐹᔨᒀᐤ ᐋᐦᒋᓂᒀᓂᐦᑖᔨᒡ ᐃᔥᐱᔥ ᒦᓐ ᑯᑎᒃ ᐊᐙᓐ ᒌ ᐃᔨᐤ, “ᒥᑐᓐ ᓂᒑᔥᑎᓈᐦᐅᓐ ᐆ ᓈᐹᐤ ᑭᔮᐦ ᐐᔨ ᐋ ᒌ ᐐᒑᐙᑦ ᒌᓴᔅᐦ ᐙᔥ ᑳᓕᓖᐦᒡ ᑭᔮᐦ ᐐᔨ ᐅᐦᒋᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ᐲᑎᕐ ᒫᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᒑᒀᓐ ᐊᓐ ᑳᐦ ᐋᔨᒸᐦᐄᑯᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ᐋᒄ ᒫᒃ ᒫᒀᒡ ᐋ ᐊᔨᒥᑦ ᒌ ᐅᐦᒋ ᒋᔅᑐᔨᐤ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ᙮ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒫᒃ ᒌ ᒀᔅᒋᑳᐳᔨᐤ ᑯᐃᔅᒄ ᑳ ᑭᓂᐙᐱᒥᑯᑦ ᐲᑎᕐ᙮ ᐋᒄ ᒫᒃ ᐲᑎᕐ ᑳ ᐅᐦᒋ ᒋᔥᒋᓯᑦ ᑖᓐ ᑳᐦ ᐄᑎᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᐋᔥᒄ ᐋᒸᔮ ᒋᔅᑐᑖ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᓂᔥᑣᐤ ᒋᑭ ᓂᓂᑎᔨᓐ ᐋᐦ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒦᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ᑳ ᐎᔨᐐᑦ ᐲᑎᕐ ᑳ ᓂᑐᒫᑑᑦ, ᒌ ᒥᔥᑎᐦ ᒫᑑ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᒋᐱᐦᐅᐙᔓᐎᒡ ᑳ ᓈᓈᑭᒋᐦᐋᒡ ᒌᓴᔅᐦ ᒌ ᒫᔮᔨᒫᐅᒡ ᑭᔮᐦ ᒌ ᐅᑖᒧᐦᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ᒌ ᐋᑭᐙᐱᑳᑖᐅᒡ ᑳᐦ ᐄᑖᒡ, “ᐐᐦᑎᒨᓈᓐ, ᐊᐙᓐ ᑳ ᐅᑖᒥᐦᐆᔅᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ᓂᓈᐦᑭᐤ ᒌ ᐄᔑ ᒥᒋᒫᔮᔨᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᑖᐱᓃᔨᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᓂᔥᑐᐎᒡ᙮ ᐋᑯᑖᐦ ᑭᔮᐦ ᑳ ᐄᑐᐦᑎᐦᐋᑭᓅᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ᒌ ᐄᑎᑰ ᒫᒃ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᒫᐦ, ᐋᐤ ᐋ ᒌᔨ ᙭?” ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ, “ᐋᑦ ᐐᐦᑎᒫᑎᑯᒡ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᑖᑆᐦᑑᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ᑭᔮᐦ ᒫᒃ ᒌᔨᐙᐤ ᑯᒀᒋᒥᑎᑯᒑ ᒑᒀᓐ, ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒌ ᓂᔥᒀᐎᔑᐦᐄᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ᒥᒄ ᒫᒃ ᐋᒄ ᐙᑎᐦᒋᐱᔨᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᐊᐱᑦ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᓲᐦᑳᑎᓰᔨᒡ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᑳ ᑯᒀᒋᒥᑯᑦ, “ᐋᐤ ᐋ ᒫᒃ ᒌᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ?” ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᒫᒃ ᐋᐦ ᐄᑖᑦ, “ᒋᔑᓈᐙᐤ ᐋ ᐋᐎᔮᓐ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ᒌ ᐄᑎᑐᒡ ᒫᒃ, “ᐋᑯᓐ ᐋᒄ, ᔖᔥ ᒥᑐᓐ ᒋᒌ ᐹᐦᑎᐙᓂᐤ ᑖᓐ ᐋᑖᒋᒦᓲᑦ᙮ ᓂᒧᐃ ᔖᔥ ᓂᑎᐙᔨᐦᑖᑯᓂᔨᐤ ᐊᑎᑎᐤ ᒑ ᒌ ᓈᓂᑐ ᒋᔅᒑᔨᒫᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ᒥᓯᐙ ᒫᒃ ᒫᒨ ᐋ ᐃᑎᔑᒡ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ, ᐹᔨᓕᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ᐋᒄ ᓂᑎᐐ ᒥᒄ ᑳ ᐄᔑ ᒫᒥᔑᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᐆ ᒫᐦ ᓈᐹᐤ ᓂᒥᔅᑭᐙᓈᓐ ᐋ ᒥᒋᑭᒑᔅᒋᒫᑦ ᓂᑎᐄᔨᔨᒥᓈᓐ, ᐋ ᒋᔅᑎᐦᐋᒧᐙᑦ ᒑ ᒌ ᑎᐱᐦᐙᔨᒡ ᒥᔥᑎᐦ ᒋᐦᒋᐅᒋᒫᐤ ᔓᐎᔮᓐ ᑭᔮᐦ ᐋ ᐐᐦᑎᒧᐙᑦ ᐐᔨ ᐋᐦᐋᐎᑦ ᙭, ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᐄᑎᐦᐄᓱᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ᐹᔨᓕᑦ ᒫᒃ ᒌ ᑯᒀᒋᒫᐤ ᐋᐦ ᐄᑖᑦ, “ᒌᔨ ᐋ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ?” ᒌᓴᔅ ᒫᒃ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᐊᓐ ᐃᔮᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳ ᒫᐅᓯᑯᔨᒡ, “ᓂᒧᐃ ᒥᑐᓐ ᓂᒥᔅᑭᒸᓐ ᒥᒋᐦᑣᐎᓂᔨᐤ ᒑ ᒌ ᐃᔮᑦ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ᐋᑯᑖᐦ ᐊᑎᑎᐤ ᓲᐦᒃ ᑳ ᐐᐦ ᑖᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᐆ ᓈᐹᐤ ᐅᔅᑖᐱᐦᐄᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᒥᓯᐙ ᐋ ᐃᔥᐱᔖᔨᒡ ᒎᑏᔮ ᐊᔅᒌᔨᐤ᙮ ᑳᓕᓖᐦᒡ ᒌ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐦᑖᐤ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᐅᑖᐦ ᒫᒃ ᒌ ᐄᔑ ᒋᔅᑯᑎᒫᒑᐤ ᒋᕉᓯᓕᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐹᔨᓕᑦ, ᒌ ᑯᒀᒋᒫᐤ, “ᑳᓕᓕᐦᒡ ᐋ ᐅᐦᒋᔨᐤ ᐆ ᓈᐹᐤ?” ");
INSERT INTO crl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ᐄᔥᐱᐦ ᒫᒃ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐹᔨᓕᑦ ᑳᓕᓖᐦᒡ ᐋ ᐅᐦᒋᔨᑯᐱᓈᓐ ᒌᓴᔅᐦ ᐋᒄ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐦᐁᕆᑦ ᐋᐦ ᑖᔨᒡ ᐙᔥ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᒌ ᒋᐦᒋᐅᒋᒫᐎᔨᐤ᙮ ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌᐦ ᑖᐤ ᐦᐁᕆᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ᐄᔥᐱᐦ ᒫᒃ ᐦᐁᕆᑦ ᐎᔮᐱᒫᑦ ᒌᓴᔅᐦ ᓈᔥᑖᑆᐦ ᒌ ᓯᒋᔮᓲ ᐙᔥ ᒌ ᐹᐦᑎᒻ ᓂᓈᐦᑭᐤ ᐋ ᒌ ᐄᔑ ᑎᐹᒋᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᔖᔥ ᓈᔥᑖᑆᐦ ᐙᔥᑭᒡ ᒋᐐᐦ ᐙᐱᒫᑖᑯᐱᓐ᙮ ᒌ ᐱᑯᓵᔨᐦᑎᒻ ᒑ ᒌ ᐙᐱᒫᑦ ᒌᓴᔅᐦ ᐋᐦ ᑐᑎᒥᔨᒡ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ᐄᔥᐱᐦ ᐱᔮᓯᐙᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ, ᐦᐁᕆᑦ ᓈᐅᔖᔥ ᒫᒫᐦᒡ ᒌ ᐄᔑ ᑯᒀᒋᒫᐤ᙮ ᓂᒧᐃ ᒫᒃ ᐎᔮᔥ ᐅᐦᒋ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᓃᐴᐎᒡ ᐊᓂᑖᐦ ᓲᐦᒃ ᐋ ᐊᔨᒥᒡ ᓂᓈᐦᑭᐤ ᒑᒀᔨᐤ ᐋ ᐄᔑ ᒥᒥᒑᒋᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ᐋᒄ ᒫᒃ ᐦᐁᕆᑦ ᑭᔮᐦ ᐅᓂᑐᐱᔨᒻ ᒌ ᐎᔮᐦᐅᒡ ᒌᓴᔅᐦ ᐋ ᒫᔮᔨᒫᒡ ᑭᔮᐦ ᐋ ᐳᔥᑭᒧᔮᐦᒡ ᐊᑯᐦᐱᔨᐤ ᐋ ᒥᔻᔒᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐦᐁᕆᑦ ᑳᐤ ᑳ ᒌᐙᑎᔑᐦᐙᑦ ᒌᓴᔅᐦ, ᐹᔨᓕᑦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐃᔥᑯᑎᒃ ᑳ ᐅᐦᒋ ᐅᐐᒑᐙᑭᓂᑖᑐᒡ ᐦᐁᕆᑦ ᑭᔮᐦ ᐹᔨᓕᑦ, ᐙᔥ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒌ ᐅᐦᑳᑎᑐᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ᐹᔨᓕᑦ ᒌ ᓂᔥᑑᓈᐤ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ, ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᐊᔨᒥᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᒌ ᐹᔓᐙᐙᐤ ᐆ ᓈᐹᐤ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᐋᐦ ᐄᑖᒄ ᐋ ᒌ ᒥᒋᑭᒑᔅᒋᒫᑦ ᐄᔨᔨᐤ ᐋᐦ ᐄᑖᑦ ᒑ ᒌ ᓂᔥᑰᔥᑐᐙᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ᙮ ᓂᒌ ᓂᑑᒋᔅᒑᔨᒫᐤ ᐅᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᔮᒄ ᓂᒧᐃ ᒫᒃ ᓂᒥᔅᑭᒸᓐ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒧᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ᐦᐁᕆᑦ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᒥᔅᑭᒸᐤ ᑳ ᒥᒋᐦᑐᑎᒦᒀᓂᐦᐄ, ᐙᔥ ᒦᓐ ᑳᐤ ᒌ ᐹᒋ ᒌᐙᑎᔑᐦᐋᐤ᙮ ᐆ ᓈᐹᐤ ᓂᒧᐃ ᒑᒀᔨᐤ ᐅᐦᒋ ᒥᒋᐦᑐᑎᒻ ᒑ ᒌ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ᐋᒄ ᒫᒃ ᓂᑭ ᐄᑎᔓᐙᑖᐤ ᒑ ᒌ ᐱᐱᓯᔅᑖᐦᐙᑭᓅᑦ ᐋᒄ ᒫᒃ ᒑ ᐱᒋᔅᑎᓂᐦᒃ,” ᐋᔪᐎᒄ ᑳᐦ ᐃᔨᑦ ᐹᔨᓕᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ᐋᔑᑯᒻ ᐱᐳᓐ ᒫᒃ ᐄᔥᐱᐦ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ, ᐹᔨᓕᑦ ᒋᐱᐦ ᒌ ᐱᒋᔅᑎᓈᑖᑯᐱᓐ ᐹᔨᒄ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐄᔑ ᒫᒨ ᑖᑆᒡ, “ᓂᐱᐦᐋᐦᒄ ᒌᓴᔅ᙮ ᐹᕌᐹᔅ ᐋᐅᒄ ᐱᒋᔅᑎᓈᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ᐆ ᒫᒃ ᓈᐹᐤ ᐹᕌᐹᔅ ᒌ ᒋᐳᐦᐙᑭᓅᑖᑯᐱᓐ ᐙᔥ ᒌ ᒋᐦᒋᐱᔨᐦᑖᑖᑯᐱᓐ ᐋ ᓂᔥᑯᔥᑖᒫᑭᓂᐎᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐋᔨᐤᐦ ᒫᒃ ᒌ ᓂᐱᐦᐋᑖᑯᐱᓐ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ᐹᔨᓕᑦ ᒫᒃ ᒋᐐᐦ ᐱᒋᔅᑎᓈᐤ ᐊᓂᔮᔨᐤᐦ ᒌᓴᔅᐦ ᐋᒄ ᒦᓐ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐱᒋᔅᑎᓈᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ᐋᒄ ᒫᒃ ᑳ ᑖᑆᒡ ᐋᐦ ᐋᔑᐦᒀᒡ, ᐋᐦ ᐃᔨᒡ, “ᒌᔅᑖᔅᑯᐙᐦᒄ, ᒌᔅᑖᔅᑯᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ᐋᔪᐎᒄ ᐋᒄ ᓂᔥᑣᐤ ᐹᔨᓕᑦ ᑳᐦ ᐄᑖᑦ, “ᒑᒄ ᒥᒋᐦᑐᑎᒧᐎᓂᔨᐤ ᒫᒃ ᑳᐦ ᑐᑎᐦᒃ ᐆ ᓈᐹᐤ, ᓂᒧᐃ ᓅᒡ ᒥᔅᑭᒸᓐ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᒑ ᐅᐦᒋ ᓂᐱᐦᐋᑭᓅᑯᐱᓈ᙮ ᓂᑭ ᐄᑎᔓᐙᑖᐤ ᒑ ᒌ ᐱᐱᓯᔅᑖᐦᐙᑭᓅᑦ ᐋᒄ ᒑ ᐱᒋᔅᑎᓂᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᔮᐱᒡ ᑳ ᐄᔑ ᑖᑆᒡ ᓈᔥᒡ ᓲᐦᒃ ᐋ ᓂᑎᐙᔨᒫᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ᒌ ᔑᐦᑯᒋᒧᐙᐅᒡ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ᐋᒄ ᐹᔨᓕᑦ ᐄᔨᐙ ᑳᐦ ᐃᔨᑦ ᒑ ᒌ ᑐᑖᑭᓂᐎᔨᒡ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ᑳ ᐱᒋᔅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᒋᐳᐦᐙᑭᓐ ᓈᐹᐤ ᐹᕌᐹᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᓐ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑯᐱᓈ ᐋ ᓂᔥᑯᔥᑖᒫᑭᓂᐎᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᑭᔮᐦ ᐋ ᒌ ᓂᐱᐦᐄᐙᔨᑯᐱᓈ᙮ ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐱᒋᔅᑎᓂᒧᐙᑭᓂᐎᒡ ᒑ ᒌᐦ ᑐᑎᐙᒡ ᒌᓴᔅᐦ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑎᐦᐋᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᒑ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ, ᒌ ᓂᒋᔥᑭᐙᐅᒡ ᓈᐹᐤᐦ ᓵᐃᒥᓐ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᓵᐃᕇᓐ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐅᐦᒌᔨᒡ, ᒫᒀᒡ ᒋᔖᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐐᐦ ᐹᒋ ᐄᑐᐦᑖᔨᒡ᙮ ᒌ ᐅᑎᓈᐅᒡ ᒫᒃ ᑳ ᒥᔮᒡ ᐊᓂᔮᔨᐤ ᐋᔑᑖᔮᐦᑎᒄ ᒑ ᒌ ᐎᓂᑳᑎᐦᐙᔨᒡ, ᐋᒄ ᑳᐦ ᐋᑎ ᓅᔔᔥᑯᐙᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᓅᔔᔥᑳᑰ ᒌᓴᔅ ᑭᔮᐦ ᐃᔅᒀᐤ ᒌ ᒫᑎᑖᑰ ᑭᔮᐦ ᒌ ᒨᔥᑯᐙᑎᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ᐋᒄ ᒌᓴᔅ ᑳ ᒀᔅᒋᑳᐳᔥᑎᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᐃᔥᒀᑐᒃ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐅᐦᒋᔮᒄ, ᐊᑳᐐ ᒨᔥᑯᐙᓯᒄ, ᒌᔨᐙᐤ ᒨᔥᑯᐙᑎᓯᒄ, ᑭᔮᐦ ᒋᑎᐙᔑᔒᒧᐙᐅᒡ ᒨᔥᑯᐙᑖᐦᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ᐙᔥ ᐋᔥᒄ ᐊᑎᑎᐤ ᒋᑭ ᐋᔨᒥᓐ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᐄᓈᓅᒡ, ‘ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐃᔮᐙᒡ ᐊᐙᔑᔥ, ᐊᓂᒌ ᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᓅᔖᓂᐦᐋᐅᓱᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ᒑ ᐃᔥᐱᔥ ᐋᔨᒥᐦᒡ ᒫᒃ ᐆ ᒑ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐎᒡ ᒋᑭ ᓂᑎᐙᔨᐦᑎᒧᒡ ᐄᔨᔨᐅᒡ ᐊᐙᔅᑖ ᒑ ᒌ ᐱᒋᔅᑎᐦᐅᑯᒡ ᐎᒌ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐊᑯᓂᐦᐅᑯᒡ ᐎᒌᔥ ᐃᔥᐱᔥ ᐐ ᒑ ᒌ ᐙᐐᓯᒑᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ᐙᔥ ᐆ ᐋ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᓂᓈᐦᑳᑖᔨᒧᐎᓐ ᒫᒀᒡ ᐋ ᒋᑭᔅᑳᐦᑎᑯᐎᑦ ᒥᔥᑎᒄ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᓂᓈᐦᑳᑖᔨᒧᐎᓐ ᐹᐦᑯᐦᑎᑰᒑ᙮” ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᑳ ᒨᔥᑭᐙᑎᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ᒌ ᓃᔔᒡ ᒫᒃ ᒋᒧᑎᔅᑭᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋᐦ ᐄᑐᐦᑎᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ ᒑ ᐊᓯᒋᓂᐱᐦᐋᑭᓂᐎᒡ ᒌᓴᔅᐦ ᓂᐱᐦᐄᒫᑭᓂᐎᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ᐄᔥᐱᐦ ᒫᒃ ᐙᑎᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐎᒌᔑᔨᐤ, ᒥᔥᑎᒀᓂᑭᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᑯᑖᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒡ ᒌᓴᔅᐦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᓃᔓ ᒋᒧᑎᔅᒃ ᐱᑐᑖᓰᔥ ᐊᓂᑎᐦ, ᔮᐄᑐ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒌ ᐊᑯᒋᓂᔨᐤ, ᐹᔨᒄ ᐅᓂᐦᐄᐎᓂᐦᒡ ᑭᔮᐦ ᐹᔨᒄ ᐅᓂᒥᐦᒌᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᐙᐹᔨᐦᑎᒨᒡ, ᐙᔥ ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᐋᐃᔨᐦᑎᒡ᙮” ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᒥᐦᐄᑭᓈᐦᑎᑯᒑᒡ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐎᔮᔨᐦᑎᐦᒡ ᐊᐙᔨᐤᐦ ᒑ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒑᒀᓂᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ᒌ ᓈᓃᐴᐎᒡ ᐊᓂᑖᐦ ᐄᔨᔨᐅᒡ ᐋ ᓈᓈᑭᒋᐦᐋᒡ, ᐋ ᒫᔮᔨᒥᑯᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐋᐦ ᐄᔨᔨᒡ, “ᒌ ᐐᒋᐦᐋᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ, ᑭᑎ ᐐᒋᐦᐄᓲ ᒫᒃ ᑖᑆᐦ ᐐᔨ ᐃᔮᐅᒀ ᙭, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒫᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ᓂᑐᐱᔫᒡ ᑭᔮᐦ ᒌ ᒫᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᓈᑖᒡ ᐹᔓᒡ ᑳ ᐐᐦ ᒥᓂᐦᐋᒡ ᐋ ᐐᔑᑳᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ᒌ ᐄᑖᐅᒡ ᑭᔮᐦ, “ᐐᒋᐦᐄᓲ ᒫᒃ ᑖᑆᐦ ᐃᔮᐎᓈ ᒎᐤ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ᒌ ᒋᑭᒧᐦᑖᑭᓂᐎᔨᑯᐱᓐ ᒫᒃ ᒥᓯᓂᐦᐄᑭᓂᔑᔨᐤ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᐦᒡ ᐊᓂᑎᐦ ᐃᔥᐱᒥᔒᔥ ᒌᓴᔅ ᐅᔥᑎᒀᓂᐦᒡ ᐋᐦ ᐄᑎᔥᑖᔨᒡ, “ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ᐹᔨᒄ ᐊᓐ ᒋᒧᑎᔅᒃ ᐊᓂᑎᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᑭᔮᐦ ᐐᔨ ᒌ ᒫᔮᔨᒫᐤ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᑦ, “ᓂᒥᔮᐤ ᐋ ᒫᒃ ᒌᔨ ᙭? ᐐᒋᐦᐄᓲ, ᑭᔮᐦ ᒫᒃ ᓃᔮᓐ, ᐐᒋᐦᐄᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ᐊᓐ ᒫᒃ ᑯᑎᒃ ᒋᒧᑎᔅᒃ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐐᒋᒋᒧᑎᔅᒃ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᐋ ᒌ ᑯᔥᑖᐤ ᒋᔖᒥᓂᑑ᙮ ᒋᒌ ᐄᔑ ᑎᐹᔅᑯᓂᑯᓈᓂᐤ ᒧᔮᒻ ᐐᔨ ᐋ ᐄᔑ ᑎᐹᔅᑯᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ᒌᔮᓂᐤ ᒫᒃ ᐃᓯᓈᑯᓐ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐅᑭᐎᔨᐦᒄ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑐᑎᒥᐦᒄ᙮ ᐆ ᒫᒃ ᓈᐹᐤ ᓂᒧᐃ ᐅᐦᒋ ᒥᒋᐦᑐᑎᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ᐊᓐ ᒫᒃ ᒋᒧᑎᔅᒃ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ, “ᒋᔅᒋᑐᐦ ᐄᔥᐱᐦ ᑎᑯᔑᓃᔨᓈ ᐋ ᒋᐦᒋᐅᒋᒫᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓐ, ᐊᓅᐦᒡ ᒌ ᑭᔮᐦ ᓃᔨ ᒌ ᑳ ᑖᓈᓅᐤ ᒥᔻᔨᐦᑎᒧᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ᐎᔮᔥ ᒫᒃ ᐋᐦ ᐋᐱᐦᑖᒌᔑᑳᒡ ᐋᒄ ᑳ ᑎᐱᔅᒋᐱᔨᐦᒡ ᑳᐦ ᐋᑎ ᐊᐅᑳᔥᑖᔮᒡ ᒥᓯᐙ ᐋ ᐃᔥᐱᔖᒡ ᐊᓐ ᐊᔅᒌ᙮ ᐹᑎᔥ ᓂᔥᑐ ᑳ ᐄᔅᐱᔨᒡ ᐋᒄ ᒦᓐ ᑳᐦ ᐋᑎ ᐙᔖᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ᒫᒀᒡ ᒫᒃ ᐋ ᑎᐱᔅᒋᐱᔨᐦᒡ, ᐋᓐ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᐊᑯᑖᒡ ᐋᑭᐙᑭᐦᐄᑭᓐ ᓈᔥᑎᔨᔥ ᑳ ᑖᔅᑳᒋᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ᒌᓴᔅ ᒫᒃ ᒌ ᑖᑆᐤ, ᐋᐦ ᐃᔨᑦ, “ᓅᐦᑖ, ᒌᔨ ᐋᐦ ᑖᔨᓐ ᓂᐱᒋᔥᑖᔨᒫᐤ ᓂᑎᐦᒑᐦᒄ ᒑ ᒌ ᑭᓂᐙᔨᒥᑦ᙮” ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᐋᒄ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ᐊᓐ ᒫᒃ ᓂᑐᐱᔨᐅᒋᒫᐤ ᐄᔥᐱᐦ ᑳ ᐙᐱᐦᑎᐦᒃ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ, ᒌ ᒋᔅᑖᒋᒫᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒌ ᐃᔨᐤ, “ᒑᔥᑎᓈᔥ ᑖᑆᐦ ᒌ ᑯᐃᔅᑯᑖᑎᓰᒑ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐹᒋ ᓈᓈᑭᒋᐦᐄᐙᒡ ᑳ ᐙᐱᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ, ᒌ ᒌᐙᐅᒡ ᐋ ᐅᑎᑖᒫᔅᒋᑭᓈᐦᐅᓱᒡ ᐋ ᐙᐱᐦᑎᔨᐙᒡ ᐋ ᐃᔥᐱᔥ ᒥᓯᒫᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒥᔪ ᒋᔅᒑᔨᒫᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᑳ ᐱᐹᐐᒑᐙᐙᑯᐱᓈ ᒌᓴᔅᐦ ᑳᓕᓖᐦᒡ ᐅᐦᒋ, ᐙᐦᐄᐐᔥ ᐊᓂᑖᐦ ᒌ ᓃᐴᐎᒡ ᐋ ᓈᓈᑭᒋᐦᐄᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᓈᐹᐤ ᒍᓯᕝ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᒎᑏᔮ ᐊᔅᒌᐦᒡ, ᐋᕆᒫᕠᔮ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒎᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᐋ ᒌ ᐅᐦᒌᑦ᙮ ᒌ ᑯᐃᔅᑯᐱᒫᑎᓰᑖᑯᐱᓐ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑖᑯᓯᑖᑯᐱᓐ ᐆ ᓈᐹᐤ, ");
INSERT INTO crl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ᑭᔮᐦ ᐐᔨ ᒌ ᐊᔑᓂᐙᑖᑖᑯᐱᓐ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᒑ ᒌ ᐅᑎᐦᒋᐱᔨᒡ ᑭᔮᐦ ᒌ ᐊᐱᐤ ᐊᓂᑎᐦ ᒎᐄᔨᔨᐤ ᐋ ᒫᒨᐲᒡ ᑳ ᓃᑳᓂᓰᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᓂᐦᐋᔨᐦᑎᒧᑖᑯᐱᓐ ᑖᓐ ᑳ ᐄᔑ ᐎᔮᔨᐦᑎᒥᔨᒡ ᒑ ᑐᑎᐙᔨᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑯᒨ ᒑ ᒌᐦ ᑐᑎᐙᑭᓂᐐᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᑐᑎᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ᒌ ᓂᑎᐙᐱᒫᐤ ᐹᔨᓕᑦ ᑳ ᓂᑐᑎᒧᐙᑦ ᒌᓴᔅᐦ ᐐᔮᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ᐋᒄ ᒫᒃ ᑳ ᓃᐦᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᒥᔮᔨᐤ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᐅᐦᒋ, ᑳ ᐎᔅᒀᔮᒋᓂᐦᒃ ᐱᒋᐎᔮᓈᒋᓂᒡ ᑭᔮᐦ ᑳ ᓂᑑᓂᐦᐋᐅᔅᑖᑦ ᐊᓂᑖᐦ ᐋ ᒌ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐋᔥᒄ ᓂᐦᑖ ᐅᐦᒋ ᐋᐱᑎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᑳ ᐊᔥᑖᐙᑦ ᒌᓴᔅᐦ ᐐᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ᐋᐅᒄ ᐆ ᐋ ᒌᔑᑳᒡ ᑳ ᒌ ᐃᔮᔅᑭᐐᓈᓅᒡ ᐙᔥ ᔖᔥ ᒌ ᐹᔓᓈᑯᓐ ᒑ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ᐊᓂᒌ ᒫᒃ ᐃᔅᒀᐅᒡ ᑳᓕᓖᐦᒡ ᑳ ᐅᐦᒋ ᐐᒑᐙᒡ ᒌᓴᔅᐦ ᒌ ᐐᒑᐙᐅᒡ ᐊᓂᔮᔨᐤ ᒍᓯᕝᐦ᙮ ᒌ ᐙᐱᐦᑎᒧᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᑭᔮᐦ ᑖᓐ ᑳᐦ ᐄᑎᔥᑖᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐐᔮᔨᐤ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ᐋᒄ ᒫᒃ ᑳ ᒌᐙᒡ ᑳ ᓂᑑᐃᔮᔅᑰᔥᑖᒡ ᐊᓂᔮᔨᐤ ᑳ ᒥᔪᒫᑯᓃᔨᒡ ᒥᔥᑯᔑᐤᐦ ᑭᔮᐦ ᑑᒥᓂᑭᓐ ᐊᓂᔮᔨᐤ ᒑ ᐋᐱᒋᐦᑖᒡ ᐋ ᒥᒥᔪᐦᑭᐦᒡ ᒥᔮᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᒎᐤ ᐅᑎᔨᒥᐦᐋᐅᒌᔑᑳᒥᔨᐤ ᒌ ᐋᔨᐙᓱᐎᒡ ᐙᔥ ᐋᔪᐎᒄ ᑳᐦ ᐄᑎᔓᐙᑖᑭᓂᐎᒡ ᒋᔖᒥᓂᑑ ᐅᑭᒑᔅᒀᐎᓃᔨᒡ ᒑ ᑎᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ᓃᔥᑎᒻ ᒫᒃ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᑎᐎᔥᑖᔨᒡ ᓈᔥᒡ ᒫᒃ ᐐᐱᒡ ᐋ ᒑᒋᔖᐹᔮᔨᒡ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᒌ ᐄᑐᐦᑎᑖᐅᒡ ᐊᓂᑖᐦ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐃᔮᔅᑰᔥᑖᒡ ᐋ ᒥᔪᒫᑯᓃᔨᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᑑᒥᓂᐦᒡ ᐊᓂᔮᔨᐤ ᒥᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ᑳ ᑎᑯᔑᐦᒡ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ ᔖᔥ ᒌ ᐄᒑᑎᐦᑎᐱᓂᒫᑭᓂᐎᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᐊᓂᑎᐦ ᑳ ᒋᐱᔑᒫᑭᓂᐎᔨᒡ ᐃᔥᒀᐦᑖᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ᑳ ᐲᐦᒑᒡ ᐊᓂᑖᐦ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔅᑭᒸᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᐐᔮᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ᒫᒀᒡ ᒫᒃ ᐋ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᔑᔥᒋᑯᒡ ᒌ ᐅᐦᒋ ᓃᔑᔨᐤ ᓈᐹᐤᐦ ᐋ ᓵᑖᑖᔨᒡ ᐅᒑᒀᓂᒥᔨᐤ ᐋ ᐐᒋᑳᐳᔅᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ᐋᒄ ᓈᔥᒡ ᑳ ᓵᒋᓯᒡ ᑳᐦ ᐋᑎ ᐅᑎᐦᑎᐱᔨᐦᐅᒡ ᐊᓂᑖᐦ ᐄᔑ ᐊᔅᒌᐦᒡ, ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, “ᒑᒀᔨᐤ ᐙᐦᒋ ᓈᓂᑐᐙᐱᒫᒄ ᐊᓐ ᑳ ᐱᒫᑎᓰᑦ ᐅᑎᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦ ᑖᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ᓂᒧᐃ ᑖᐤ ᐅᑎᐦ᙮ ᐙᔥ ᒌ ᐎᓂᔥᑳᐤ᙮ ᒋᒋᔥᒋᓯᓈᐙᐤ ᐋ ᑖᓐ ᑳ ᐄᑎᑖᒄ ᒫᒀᒡ ᑳᓕᓖᐦᒡ ᑳᐦ ᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ᐋ ᒌ ᐄᔑ ᓃᑳᓐ ᐄᑖᒋᒦᓱᑦ, ‘ᐄᔨᔨᐅᑯᓯᓵᓐ ᑭᑎ ᐱᒋᔅᑎᓈᑭᓂᐤ ᐅᒥᒋᐦᑣᐤ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ, ᐋᒄ ᒫᒃ ᒌ ᓂᔥᑐ ᒌᔑᑳᔨᒑ ᒦᓐ ᑭᑎ ᐎᓂᔥᑳᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᑳ ᐅᐦᒋ ᒋᔥᒋᓯᒡ ᒌᓴᔅᐦ ᑖᓐ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ᒌ ᓂᑭᑎᒧᒡ ᒫᒃ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ, ᑳ ᒌᐙᒡ, ᐋᒄ ᑳ ᐙᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᔨᑯᔖᐳᔨᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᑳ ᒌ ᐙᐐᒑᐙᔨᒡ ᒌᓴᔅᐦ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ᐋᐅᑯᓂᒡ ᐅᒌ ᐃᔅᒀᐅᒡ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐙᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ, ᒣᕇ ᒫᒃᑖᓖᓐ ᑭᔮᐦ ᒍᐙᓈ ᑭᔮᐦ ᒫᒃ ᒣᕇ, ᐊᓂᔮᔨᐤ ᒉᒥᔅ ᐅᑳᐐᐦ ᑭᔮᐦ ᑯᑎᒃ ᐃᔅᒀᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᒑᐅᑯᒡ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ᐋᒄ ᒥᒄ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤᐦ, ᓂᒥ ᑭᒑᔅᒑᔨᐦᑎᒨᒡ ᐃᔨᐦᒡ, ᐋ ᒌ ᐄᑖᔨᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ᐲᑎᕐ ᒫᒃ ᒌ ᐄᔥᐱᐦᑖᐤ ᐊᓂᑖᐦ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ ᐋᒄ ᑳ ᓄᐙᑳᐳᑦ ᒑ ᒌ ᐲᐦᑖᓯᐙᔮᐱᐦᑎᐦᒃ᙮ ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐱᒋᐅᔮᓈᒋᓐ ᑳ ᐎᔅᒀᔮᒋᓂᒫᑭᓂᐎᔨᒡ ᒌ ᐙᐱᐦᑎᒻ᙮ ᐋᐦ ᐋᑎ ᒌᐙᑦ ᒫᒃ ᒌ ᒥᔥᑎᐦ ᒫᒥᑐᓈᔨᐦᑎᒥᐦᐄᑰ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ᐋᒄ ᒫᒃ ᐋ ᐹᔨᑯᐦᒡ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᓃᔓ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᔨᐤ ᐁᒣᔪᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐎᔮᔥ ᒫᒃ ᓃᔣᔥᒡ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ ᒌ ᐃᔥᐱᔑᓈᑯᓂᔨᐤ ᒋᕉᓯᓕᒥᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ᒌ ᐋᔨᒸᐅᐦᐄᑯᒡ ᒫᒃ ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᒡ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐹᒋ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᐦᐄᑐᒡ ᒌ ᐅᑎᐦᑎᑯᒡ ᒌᓴᔅᐦ, ᑳᐦ ᐋᑎ ᐐᒑᐅᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔮᑭᓂᐎᒡ ᒑ ᒌ ᓂᓯᑑᓄᐙᒡ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐃᔮᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᒡ, “ᒑᒀᓐ ᐆ ᑳᐦ ᐋᔨᒸᐅᐦᐄᑯᔮᒄ ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᔮᒄ?” ᒌ ᒋᐱᐦᒋᑳᐳᐎᒡ ᒫᒃ ᓈᔥᒡ ᐋ ᒥᒑᔨᐦᑎᒨᓈᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ᐋᒄ ᐊᓐ ᐹᔨᒄ ᒃᓖᐅᐹᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᐋᐤ ᐋ ᒌᔨ ᒥᒄ ᐋᐹᔨᑯᔑᔨᓐ ᐋᒫᓂᑖᐎᔨᓐ ᒋᕉᓯᓕᒥᐦᒡ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᒥᓐ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᓂᒧᐃ ᒦᐦᒑᑑ ᒌᓯᑳᐤ ᐅᑖᐦ ᐄᔥ ᐅᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᒡ, “ᒑᒀᓂᐦᐄ ᒫᒃ ᐊᓂᐦᐄ ᑳ ᐄᔅᐱᔨᔨᒡ?” ᐋᒄ ᑳ ᑎᐹᒋᒧᔥᑐᐙᒡ ᒥᓯᐙ ᑖᓐ ᑳᐦ ᑐᑎᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ, ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᔨᒡ, ᐋᐦ ᐄᑖᒡ, “ᐆ ᒌᓴᔅ ᒌ ᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒌ ᒋᔅᑖᔨᐦᑎᒥᔨᐤ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳᐦ ᑐᑎᐦᒃ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᐦᒃ ᓈᔥᒡ ᐋ ᒌ ᓲᐦᒑᔨᐦᑖᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ᒌ ᓂᔅᑰᒥᑐᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ, ᐋᒄ ᑳ ᒌᔅᑖᔅᑯᐦᐙᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ᓂᒌ ᐱᑯᓵᔨᒫᓈᓐ ᒫᒃ ᐐᔨ ᒑ ᒌ ᐱᒫᒋᐦᐋᑯᐱᓈ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤᐦ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᐊᓅᐦᒡ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒥᓯᐙ ᑳ ᐃᔥᐱᔥ ᐄᔅᐱᔨᔨᒡ ᐆ ᒑᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ᐋᒄ ᒫᒃ ᐅᑎᐦ ᒦᓐ ᐱᔅᒡ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᐊᓂᑎᐦ ᐋᐦ ᑎᔑᔮᐦᒡ ᒌ ᒥᔅᑳᓯᑖᑯᓯᐎᒡ ᑖᓐ ᑳ ᐄᑖᒋᒧᒡ, ᐐᐱᒡ ᒑᒋᔖᑉ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᑳ ᐱᒥᔑᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔅᑭᒸᐅᒡ ᐐᔮᔨᐤᐦ᙮ ᑳ ᑎᑯᔑᒡ ᒌ ᐃᔨᐅᒡ ᐋ ᒌ ᓅᑯᓰᔥᑖᑯᒡ ᐋᓐᒋᓐ ᐋᐦ ᐄᑎᑯᒡ, ‘ᐱᒫᑎᓰᐤ ᐙᔥ ᐊᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ᐋᒄ ᐱᔅᒡ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᐦᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᓈᑖᐦ ᑳ ᐱᒥᔑᒫᑭᓂᐎᔨᒡ᙮ ᑖᑆᐦ ᒫᒃ ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᑖᓐ ᑳ ᐄᑖᒋᒧᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮ ᓂᒧᐃ ᐅᐦᒋ ᑖᔨᐤ ᒌᓴᔅᐦ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ, ᑖᑆᐦ ᐋᑳ ᑳ ᐄᑖᔨᐦᑎᒫᒄ, ᑖᓂᑖᐦ ᐙᐦᒋ ᐋᑳ ᐅᐦᒌ ᑖᑆᐦᑎᐙᑯᒡ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᐦᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ᑖᑆᐦ ᐋᐅᒄ ᐊᓐ ᑳ ᐄᔑ ᓂᑎᐙᔨᐦᑖᑯᐦᒡ ᒑ ᒌ ᐄᔅᐱᔨᑯᐱᓈ, ᐋᐅᒄ ᐆ ᙭ ᒑ ᒌ ᐐᓯᒑᔨᐦᑎᒧᑯᐱᓈ ᑭᔮᐦ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ᐋᒄ ᒌᓴᔅ ᑳ ᒋᐦᒋ ᐙᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᑎᓯᓂᐦᐄᑭᓂᐎᔨᒡ ᐋᐦ ᐋᔨᒨᒫᑭᓅᑦ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ᒧᓱᔅ ᑖᓐ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᐋᐦ ᐋᔨᒨᒥᑯᑦ ᒌ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐦᑖᐤ ᒑᒃ ᑳ ᐅᑎᐦᑎᐦᐋᐦᒃ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒥᔨᒡ ᐋᐦ ᐋᔨᒨᒥᑯᑦ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ᐄᔥᐱᐦ ᐋᐦ ᐋᑎ ᐹᔣᐱᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐁᒣᔪᔅ ᑳ ᐐᐦ ᐄᑐᐦᑖᒡ ᐋᒄ ᑳ ᐃᓯᓈᑯᓯᑦ ᒌᓴᔅ ᒧᔮᒻ ᒑ ᐋᑎ ᓵᐳᐦᑎᐙᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ᒌ ᐋᔨᐦᑭᒥᒫᐎᒡ ᒫᒃ ᒌᓴᔅᐦ ᐋᑳ ᐊᑎᑎᐤ ᒑ ᒌ ᒋᔅᑐᐦᑖᔨᒡ, ᐋᐦ ᐄᑖᒡ, “ᐋᑯᑖᐦ ᐅᑎᐦ ᑖᐦ, ᐙᔥ ᔖᔥ ᐅᑖᑯᔔ, ᔖᔥ ᐐᐱᒡ ᑭᑎ ᑎᐱᔅᑳᐤ᙮” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐋᑎ ᐐᒑᐙᑦ ᐋ ᒌᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ᐄᔥᐱᐦ ᒫᒃ ᐙᒋᒦᒋᓲᒫᑦ ᒌ ᐅᑎᓈᐤ ᐋᐃᐦᑯᓈᐤ, ᒌ ᓂᓈᔅᑯᒨ ᑭᔮᐦ ᒌ ᐱᐦᒀᓈᐤ ᐋᒄ ᑳ ᒫᑎᓂᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ᐋᒄ ᒫᒃ ᒧᔮᒻ ᐋᐦ ᐋᐱᐦᐄᐱᔨᔨᒡ ᐅᔅᒌᔑᑯᐙᐤ ᑳ ᐄᑖᔨᐦᑎᐦᒡ᙮ ᐋᒄ ᑳ ᓂᔥᑑᓄᐙᒡ ᒌᓴᔅᐦ᙮ ᔑᔥᒋᑯᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᐹᓯᑯᓂᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᑐᒡ, “ᑖᑆᐦ ᓈᔅᑖᑆᐦ ᒋᒌ ᒥᔻᔨᐦᑖᓈᓂᐤ ᒋᑖᐦᐄᓈᐦᒡ ᐋᐦ ᐋᑎ ᓂᔅᑐᐦᑎᒥᐦᒄ ᑖᓂᑖᐦ ᑳ ᐄᑣᒥᑭᓃᔨᑯᐱᓈ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ ᐊᓂᑖᐦ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᑎᐦᒄ ᒫᒀᒡ ᑳ ᐱᒧᐦᑖᔨᐦᒄ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ᒌ ᐱᓯᑯᒡ ᐋᒄ ᑏᐙᐦᒡ ᑳᐤ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᐐᐦᑎᒧᐙᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ᑳ ᒥᔅᑭᐙᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᔨᑯᔖᐳᔨᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑭᔮᐦ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᒫᐅᓯᑯᐎᔨᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᑖᑆᐦ ᐙᔥ ᐊᓐ ᒌ ᐎᓂᔥᑳᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐙᔥ ᒌ ᓅᑯᓰᔥᑖᑰ ᓵᐃᒥᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ᐋᒄ ᑳ ᐐᐦᑎᐦᒡ ᐐᔨᐙᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᒫᒀᒡ ᐊᓂᑖᐦ ᑳ ᐱᒧᐦᑖᒡ ᒫᔅᑭᓈᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐱᐦᒀᓈᔨᒡ ᐋᐃᐦᑯᓈᐤ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᒫᒡ ᐋᐦ ᐋᐎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᔨᒨᒫᒡ ᒌᓴᔅᐦ, ᒌ ᐅᐦᒋ ᓅᑯᓯᔨᐤ ᑖᐙᔨᔥ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᒋᔮᒫᔨᐦᑎᒧᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ᐋᒄ ᓈᔥᒡ ᑳ ᑯᔥᑯᓯᒡ ᑭᔮᐦ ᒌ ᓵᒋᓯᐎᒡ, ᒌᐱᔨ ᓂᐙᐱᒫᓈᓐ ᒌ ᐄᑖᔨᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, “ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᒥᑯᔥᑳᑖᔨᐦᑎᒫᒄ ᑭᔮᐦ ᐙᐦᒋ ᒥᔥᑎᐦ ᐋᓍᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ᐹᒋ ᑭᓂᐙᐱᐦᑎᒧᒄ ᒫᐦ ᓂᑎᐦᒌ ᑭᔮᐦ ᓂᓯᑦ ᒑ ᒌ ᐅᐦᒋ ᒑᔥᑎᓈᐦᐅᔮᒄ ᒥᑐᓐ ᑖᑆᐦ ᓃᔨ ᐋᐦ ᐋᐎᔮᓐ᙮ ᐹᒋ ᓂᑑᒫᒫᑎᓂᓂᒄ ᐙᔥ ᒌᐱᔨ ᑖᐹ ᐃᔮᐤ ᐎᔮᓯᐎᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᐅᔅᑭᓐ ᑖᓐ ᐋ ᐄᔑ ᐙᐱᒥᔮᒄ ᓃᔨ ᐋ ᐄᔑ ᐃᔮᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᒌᔥ ᐊᔨᒥᑦ ᒌ ᐙᐱᐦᑎᔮᐤ ᐅᑎᐦᒌ ᑭᔮᐦ ᐅᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᑖᑆᐦ ᐅᐦᒋ ᑖᑆᐦᑎᒧᒡ ᐋᐦ ᐋᐎᔨᒡ ᒌᓴᔅᐦ, ᑳ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᐦᒡ ᑭᔮᐦ ᑳ ᐃᔥᐱᔥ ᒥᒥᑯᔥᑳᑖᔨᐦᑎᐦᒡ᙮ ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᒡ, “ᑎᑯᓐ ᐋ ᒑᒀᓐ ᐋ ᒦᒋᓈᓂᐎᒡ?” ");
INSERT INTO crl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ᑳ ᒥᔮᒡ ᓂᒫᔅ ᐋ ᒌ ᑎᑭᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ᑳ ᓈᓈᑭᒋᐦᐋᒡ ᒫᒀᒡ ᐋ ᒦᒋᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᐋᐅᒄ ᒫᒃ ᐆ ᑳ ᐄᔑ ᐙᐐᐦᑎᒫᑎᑯᒡ ᐋᔥᒄ ᒫᒀᒡ ᐋ ᒌ ᐐᒑᐅᑎᑯᒡ ᑳ ᐃᔮᓐ, ᒑᔥᑎᓈᔥ ᑭᑎ ᑎᐱᐱᔨᐤ ᒥᓯᐙ ᐋ ᐄᔑ ᐋᔨᒨᒥᑭᐎᔮᓐ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐅᒥᓯᓂᐦᐄᑭᓂᐙᐦᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ, ᑭᔮᐦ ᑌᕕᑦ ᐅᓂᑭᒧᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ᐋᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒧᐙᑦ ᒑ ᒌ ᐱᔮᑭᔅᒡ ᓂᔅᑐᐦᑎᒥᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᓃᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ᐋᐦ ᐄᑖᑦ, “ᐊᒀᒋᔥᑖᒡ ᙭ ᔮᔨᑖ ᒑ ᐐᓯᒑᔨᐦᑎᒧᑯᐱᓈ, ᐋᒄ ᒫᒃ ᑳᐤ ᒑ ᐎᓂᔥᑳᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᒌ ᓂᔥᑐᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ᐋᒄ ᒫᒃ ᒋᐱᐦ ᐙᐐᐦᑎᒧᐙᑭᓂᐎᒡ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ ᙭ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ ᐄᔑ᙮ ᒋᕉᓯᓕᒥᐦᒡ ᒫᒃ ᓃᔥᑎᒻ ᒋᑭ ᐅᐦᒋ ᒥᔑᐦᑖᐱᔨᐤ ᐆ ᒑ ᐄᔑ ᐙᐐᐦᑖᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ᒌᔨᐙᐤ ᒫᒃ ᒋᒋᐦ ᐙᐱᐦᑖᓈᐙᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ, ᒑ ᒌ ᐐᐦᑎᒧᐙᑯᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ᐋᒄ ᒫᒃ ᒑ ᐹᒋ ᐄᑎᔑᐦᐋᒫᑎᑯᒡ ᐊᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐊᓂᔮᔨᐤ ᓅᐦᑖᐐ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮ ᐊᔑᓂᐙᓯᒄ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐹᑎᔥ ᒌ ᐅᑎᐦᑎᐦᐅᑯᔮᒀ ᓲᐦᑳᑎᓰᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋᐱᔨᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐄᔑ ᒋᔅᒋᓄᐦᑎᐦᐋᑦ ᐹᔓᒡ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᔨᐤ ᐯᕠᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᒄ ᑳ ᐅᐦᐱᓂᔅᒑᔨᑦ ᐋ ᒋᔖᐙᑐᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᐋ ᐋᒥᔪᑐᑎᐙᑦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᓂᑭᑖᑦ, ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐄᔑ ᐅᐦᐱᔅᑳᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐋᒄ ᑳᐤ ᑳ ᒌᐙᒡ ᒋᕉᓯᓕᒥᐦᒡ ᓈᔥᒡ ᐋ ᒥᔻᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ᒨᔥ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᒫᒥᐦᒋᒫᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ᒫᐅᒡ ᐅᔅᑭᒡ ᑳᐦ ᒋᔅᒋᐱᔨᓈᓂᐎᒡ, ᔖᔥ ᐐᔨ ᒌ ᑖᐦᑖᑯᐱᓐ ᐊᓐ ᐊᔨᒧᐎᓐ᙮ ᐊᓐ ᐊᔨᒧᐎᓐ ᒫᒃ ᒌᐦ ᑖᐤ ᐋᐦ ᑖᔨᒡ ᒋᔖᒥᓂᑑᐦ ᑭᔮᐦ ᐊᔨᒧᐎᓐ ᐐᔨ ᒌᐦ ᐋᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ᔖᔥ ᒌᐦ ᑖᐤ ᐊᔨᒧᐎᓐ ᒋᔖᒥᓂᑑ ᐊᐦᑖᔨᒡ ᐊᓂᑖᐦ ᒫᐅᒡ ᐅᔅᑭᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ᒥᓯᐙ ᒑᒀᔨᐤ ᐐᔨ ᒌ ᐅᔑᐦᑖᐤ, ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᐐᔨ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᔑᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ᐐᔨ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᐱᒫᑎᓰᐎᓃᐦᒡ ᒫᒃ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐙᔥᑖᓂᒫᑯᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ᐙᔥᑖᐎᓐ ᒫᒃ ᒌᐦᑳᔮᔥᑖᐤ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᑭᔮᐦ ᐊᐅᑳᔥᑖᔮᐎᓐ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒌ ᐋᔥᑐᐙᐦᐊᒻ ᐊᓂᔮᔨᐤ ᐙᔥᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ᒌᐦ ᑖᐤ ᓈᐹᐤ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᒞᓐ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ᒌ ᐹᒋ ᑎᑯᔑᓐ ᒑ ᒌ ᒋᔅᒑᔨᐦᑖᑯᓂᒑᓯᐎᑦ, ᒑ ᒌ ᒋᔅᒑᔨᐦᑖᑯᓂᒑᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑖᐎᓂᔨᐤ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐄᔨᔨᐤᐦ ᐹᐦᑖᑰᒑ ᒑ ᒌ ᑖᑆᐦᑎᒥᔨᒡ ᐐᔨ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ᓂᒥᔮᐤ ᒫᒃ ᐐᔨ ᐄᔮᐎᑦ ᐊᓐ ᐙᔥᑖᐎᓐ ᐊᓐ ᐃᔮᔨᒨᑖᒡ ᒥᒄ ᒫᒃ ᐐᔨ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓂᐤ ᑯᐃᔅᒄ ᒑ ᒌ ᐐᐦᑎᐦᒃ ᐙᔥᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ᐆ ᒋᐦᒋᐙ ᐙᔥᑖᐎᓐ ᒌ ᐹᒋ ᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒥᓯᐙ ᑎᐦᑑ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐙᔥᑖᓂᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒌᐦ ᑖᐤ᙮ ᐋᑦ ᐐᔨ ᐋ ᒌ ᐅᔑᐦᑖᑦ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐊᔮᐱᒡ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᒥᑰ ᐄᔨᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ᒌ ᐹᒋ ᓈᑎᒻ ᐊᓂᔮᔨᐤ ᑳ ᑖᐱᔨᐙᐅᔒᑦ, ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᑎᐱᔨᐙ ᐅᑎᔨᔨᒻᐦ ᓂᒧᐃ ᐅᐦᒋ ᐅᑎᓂᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ᐊᓂᔮᔨᐤᐦ ᒫᒃ ᐊᐙᔨᐤᐦ ᑳ ᐅᑎᓂᑯᑦ ᑭᔮᐦ ᑳ ᑖᑆᔮᔨᒥᑯᑦ ᒌ ᒥᔮᐤ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ ᒑ ᒌ ᐅᑎᐙᔑᔒᒥᑐᑖᑯᔨᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ᐊᓂᔮᔨᐤᐦ ᒫᒃ ᑳ ᐅᑎᐙᔑᔒᒥᑐᑖᑯᒡ ᓂᒧᐃ ᐐᔨ ᐃᔅᒀᐤ ᑭᔮᐦ ᒫᒃ ᓈᐹᐤ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ ᐱᒫᑎᓰᐎᒡ ᓂᒧᐃ ᑭᔮᐦ ᐄᔨᔨᐤ ᐅᑎᑖᔨᐦᑎᒧᐎᓃᐦᒡ ᐅᐦᒋ᙮ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᒋ ᐅᔅᒋ ᐱᒫᑎᓰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ᐊᓐ ᒫᒃ ᐊᔨᒧᐎᓐ ᒌ ᐄᔨᔫᐦᐋᑭᓂᐤ, ᒋᒌ ᐐᒋᒥᑯᓂᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᒋᒌ ᐙᐱᒫᓂᐤ ᒫᒃ ᐋ ᒫᐅᒡ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒧᔮᒻ ᐋ ᐃᔥᐱᔥ ᒫᐅᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤᐦ ᐅᐦᑖᐐᐦ ᐙᔥ ᐐᔨ ᒥᒄ ᐹᔨᑯᓯᐤ ᐋ ᐅᑯᓰᑐᑖᑯᑦ ᒋᔖᒥᓂᑑ, ᓵᑭᔅᒋᓈᔥᑳᑰ ᒫᒃ ᒥᔪᐦᑳᒑᐎᓂᔨᐤ ᑭᔮᐦ ᑖᑆᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ᒞᓐ ᑯᐃᔅᒄ ᒌ ᐐᐦᑎᒻ ᐊᐙᔨᐤᐦ ᐃᔮᐎᔨᒡ᙮ ᐋᔨᐤᐦ ᒫᒃ ᒌ ᐐᐦᑎᒻ ᐋ ᒋᔂᐙᑦ ᐋᐦ ᐃᔨᑦ, “ᒋᒌ ᒋᒋᓈᐙᒑ ᑳᐦ ᐋᔨᒨᒥᒃ ᐊᐙᓐ ᑳ ᐃᔮᓐ, ‘ᒋᑭ ᐹᒋ ᑎᑯᔑᓐ ᐋᔥᒄ ᐊᐙᓐ ᐊᑎᑎᐤ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᐐᔨ ᓃᔨ᙮ ᐋᐅᒄ ᐆ ᑳᐦ ᐋᔨᒨᒥᒃ ᐊᓐ ᑳᐦ ᑖᑦ ᐋᒸᔮ ᐅᐦᒋ ᐱᒫᑎᓰᔮᓐ ᓃᔨ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ᐊᓂᔮᔨᐤ ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ ᒥᔪᐦᑳᒑᐎᓂᔨᐤ ᒥᓯᐙ ᐋ ᑎᔑᔨᐦᒄ ᓈᔥᑖᑆᐦ ᒌ ᒋᔖᐙᑐᑖᑯᓂᐤ, ᓈᓂᑎᒫ ᒌ ᒥᔨᑯᓂᐤ ᒥᔪᐦᑳᒑᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ᒋᔖᒥᓂᑑ ᒌ ᐋᐱᒋᐦᐋᐤ ᐊᓂᔮᔨᐤᐦ ᒧᓱᔅ ᒑ ᒌ ᐐᐦᑎᒧᐙᔨᒡ ᐄᔨᔨᐤ ᐅᐐᔓᐙᐎᓐ, ᒌᓴᔅ ᙭ ᒫᒃ ᑳ ᐙᐱᐦᑎᐙᔨᒡ ᐅᑖᑆᐅᓯᐎᓐ ᑭᔮᐦ ᐅᒥᔪᐦᑳᒑᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ᓂᒧᐃ ᓂᐦᑖ ᐊᐙᓐ ᐅᐦᒋ ᐙᐱᒫᐤ ᒋᔖᒥᓂᑑ, ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᐅᐹᔨᑯᓵᓐ ᐅᑖᐦᐄᒡ ᑳᑎᔮᑦ ᒌ ᑐᑖᑰ ᒑ ᒌ ᒋᔅᒑᔨᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ᒎᐤ ᑎᐹᔨᐦᒋᒑᓯᐎᒡ, ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐅᐦᒌᔨᒡ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᓖᕚᐃ ᐄᔨᔨᐤ, ᒞᓐ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᓂᑑᑰᒀᒋᒫᔨᒡ ᐊᐙᓐ ᐐᔨ ᐃᔮᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ᒞᓐ ᒫᒃ ᑯᐃᔅᒄ ᒌ ᐐᐦᑎᒧᐙᐤ ᐋᐦ ᐄᑖᑦ, “ᓂᒥᔮᐤ ᓃᔨ ᙭᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ᐋᒄ ᑳ ᑯᒀᒋᒥᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᐊᐙᓐ ᒫᒃ ᒌᔨ? ᐄᓛᐃᒑ ᐋ?” ᑳᐦ ᐄᑖᑦ, “ᓂᒫ᙮ ᓂᒧᔮᐤ ᓃᔨ ᐄᓛᐃᒑ᙮” ᒦᓐ ᒫᒃ ᑳ ᑯᒀᒋᒥᑯᑦ, “ᐋᐤ ᐋ ᒌᔨ ᐊᓐ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒑ ᐹᒋ ᐄᑎᔓᐦᐊᒫᑯᐙᒋᐱᓈ?” ᑳᐦ ᐄᑖᑦ, “ᓂᒫ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ᐋᒄ ᒦᓐ ᑳᐦ ᐄᑖᒡ, “ᐹᒋ ᐐᐦᑎᒨᓈᓐ ᐊᐙᓐ ᒌᔨ, ᒑ ᒌ ᐐᐦᑎᒫᐅᒋᐦᒡ ᐊᓂᒌ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᔨᒥᐦᒡ ᐙᐦ ᒋᔅᒑᔨᒥᔅᒡ ᐊᐙᓐ ᒌᔨ ᐃᔮᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐋᐅᒄ ᐊᓐ ᓃᔨ ᑳ ᒌ ᑎᐹᒋᒥᑦ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ᙮ ᐅᔮᔨᐤ ᒌ ᐃᔨᐤ, ᒋᑭ ᑎᑯᔑᓐ ᐊᐙᓐ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᐋ ᐅᐦᑐᐦᑖᑦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᑦ, ᐃᔮᔅᑭᐐᐦᑭᒸᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒫᔅᑭᓈᒻ ᐊᓂᑎᐦ ᒑ ᐱᒧᐦᑖᑦ, ᑯᐃᔅᑯᒧᐦᑖᐙᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ᐊᓂᒌ ᒫᒃ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓂᐎᒡ ᐱᔅᒡ ᐙᔥ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒞᓐ, ");
INSERT INTO crl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᓰᑭᐦᐋᐦᑖᒑᔨᓐ ᐋᑳ ᐃᔮᐅᓈ ᙭ ᑭᔮᐦ ᒫᒃ ᐄᓛᐃᒑ ᑭᔮᐦ ᒫᒃ ᐊᓐ ᒋᔅᒋᐙᐦᐄᒑᓯᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ᐋᒄ ᒞᓐ ᑳᐦ ᐄᑖᑦ, “ᓂᓰᑭᐦᐋᐦᑖᒑᓐ ᓂᐲ ᐋᐦ ᐋᐱᒋᐦᑖᔮᓐ, ᑖᐤ ᒫᒃ ᐊᐙᓐ ᐊᐐᒋᑳᐳᔅᑖᑖᒄ ᒥᒄ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ᐋᐅᒄ ᒫᒃ ᐆ ᒑ ᑎᑯᔑᐦᒃ ᐐᔨ ᐊᐅᔅᑖ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᓃᔨ, ᓂᒧᐃ ᐙᐙᒡ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᒑ ᒌ ᐋᐱᐦᑯᓂᒧᒡ ᐅᒥᔅᒋᓯᓂᔮᐲᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ᐊᓂᑖᐦ ᒫᒃ ᐆ ᑳ ᐊᔨᐦᑎᓈᓅᒡ ᐙᐱᓅᑖᐦᒡ ᐄᑖᐦᒑᑳᒻ ᐊᓐ ᒞᕐᑎᓐ ᓰᐲᐦᒡ, ᒌ ᑎᑯᓐ ᐃᐦᑖᐎᓐ ᐯᕠᓃ ᑳ ᐃᔑᓂᐦᑳᑖᒡ, ᐋᑯᑖᐦ ᑳ ᓰᑭᐦᐋᐦᑖᒑᑦ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ᒦᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᐎᔮᐱᓃᔨᒡ ᒞᓐ ᒌ ᐙᐱᒫᐤ ᒌᓴᔅᐦ ᐋ ᐹᒋ ᓈᑎᑯᑦ, ᐋᒄ ᐃᔮᑦ, “ᑭᓄᐙᐱᒫᐦᒄ ᒫᐦ, ᐋᐅᒄ ᐅᔮᐦ ᒋᔖᒥᓂᑑ ᐅᒫᓂᔥᒑᓂᔑᒥᔥ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᔨᒡ ᐊᐙᔨᐤᐦ ᐅᒥᒋᐦᑣᐎᓂᐙᔨᐤᐦ ᐅᑎᐦ ᒥᓯᐦᑖᔅᑭᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ᐋᐅᒄ ᒫᒃ ᐆ ᑳᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ ᑳᐦ ᐄᑎᑯᒡ, ‘ᒋᑭ ᑎᑯᔑᓐ ᓈᐹᐤ, ᐐᔨ ᒫᒃ ᐊᑎᑎᐤ ᑭᑎ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᓃᔨ ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᓅᐦᒋ ᐱᒫᑎᓰᐙᓐ ᔖᔥ ᒌᐦ ᑖᐤ ᐐᔨ᙮’ ");
INSERT INTO crl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ᓂᒥ ᓅᐦᒋ ᒋᔅᒑᔨᒫᐤ ᐐᔨ ᐃᔮᐅᑦ, ᐋᐅᒄ ᐙᐦᒋ ᒌ ᑎᑯᔑᓂᔮᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᒑᔮᓐ ᓂᐲᐦᒡ ᒑ ᒌ ᐅᐦᒋ ᒋᐦᑳᔮᐱᒥᑯᑦ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ᒞᓐ ᒫᒃ ᒌ ᐐᐦᑎᒻ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒃ ᐋᐦ ᐃᔨᑦ, “ᓂᒌᐙᐱᒫᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋᒥᒥᐎᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒋ ᐹᒋ ᔮᔒᑖᑯᑦ, ᐋᒄ ᑳ ᑣᐦᐅᑖᑯᑦ, ᐋᑯᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ᓂᒧᐃ ᒫᒃ ᐊᔥᒄ ᓅᐦᒋ ᒌ ᒋᔅᒑᔨᒫᐤ ᒋᐦᒋᐙ, ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᒑᐅᒡ ᓂᐲᐦᒡ, ᓂᒌᐦ ᐄᑎᒄ, ‘ᒋᑭ ᐙᐱᒫᐤ ᓈᐹᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋ ᐹᒋ ᔮᔒᑎᑖᑯᑦ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒑ ᑖᔨᒡ, ᐋᐅᒄ ᐊᓐ ᒑ ᓰᑭᐦᐋᐦᑖᒑᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮’ ");
INSERT INTO crl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ᓂᒌᐙᐱᐦᑖᓐ ᐆ ᑳ ᐄᔅᐱᔨᒡ ᑭᔮᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐋᐦ ᐋᐎᔨᒡ ᐊᓂᔮᔨᐤᐦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ᒦᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳᔑᑳᔨᒡ ᒦᓐ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᒞᓐ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᑦ ᒌᓴᔅᐦ ᐋ ᐱᒧᐦᑖᔨᒡ ᐊᓂᑎᐦ, ᒌᐦ ᐄᑖᐤ, “ᐙᐱᒫᐦᒄ ᒫᐦ, ᒫᐤ ᐅᔮᔨᐤᐦ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒫᓂᔥᒑᓂᔒᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ᐊᓂᔮᔨᐤᐦ ᒫᒃ ᓃᔓ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐱᔮᐦᑖᑯᑦ ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᑦ, ᒌ ᐋᑎᐐᒑᐙᐅᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᐱᐦᒋᑳᐳ, ᑳᐦ ᐋᐱᓵᐱᑦ ᑳ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓅᔔᔥᑳᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᓂᔮᓂᑎᐙᐱᐦᑎᒫᒄ?” ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ ᑖᓂᑖᐦ ᐙᐦᒌᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐋᔥᑎᒧᒄ ᐹᒋ ᐙᐱᐦᑎᒧᒄ᙮” ᐋᒄ ᑳ ᐐᒑᐙᒡ, ᑳ ᐙᐱᐦᑎᒸᒡ ᐊᓂᑎᐦ ᐋ ᐐᒋᔨᒡ᙮ ᐎᔮᔥ ᓈᐤ ᒌ ᐄᔅᐱᔨᔨᒑ ᐋ ᐃᔥᒀᐱᐦᑖᒌᔒᑳᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᑖᐙᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᐃᔅᑭᓐ ᑖᑯᔔ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ᐊᓂᒌ ᒫᒃ ᓃᔓ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳᐦ ᐋᑎᐎᒑᐙᒡ ᒌᓴᔅᐦ, ᐹᔨᒄ ᒫᒃ ᐊᓐ ᐋᓐᑎᕉ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐊᓂᔮᔨᐤᐦ ᓵᐃᒥᓐ ᐲᑎᕐ ᐐᒋᔖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ᐋᓐᑎᕉ ᒫᒃ ᑏᐙᐦᒡ ᒌ ᐋᑎ ᓈᓂᑐᐙᔨᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐐᒋᔖᓐ ᓵᐃᒥᓐ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓂᒌ ᒥᔅᑭᐙᓈᓐ ᐙᔥ ᒫᓵᔮ᙮” ᐊᓐ ᒫᒃ ᒫᓵᔮ ᐋᐦ ᐄᓈᓅᒡ ᙭ ᐃᔑᒌᔣᓂᐤ ᒎᐤ ᐊᔨᒧᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᓵᐃᒥᓐ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ᒌᓴᔅ ᒫᒃ ᒌ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤᐦ ᓵᐃᒥᓐ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌᔨ ᓵᐃᒥᓐ, ᒞᓐ ᐅᑯᓯᔅᐦ, ᓰᕙᔅ ᒋᑭ ᐃᔑᓂᐦᑳᓱᓐ᙮” ᓰᕙᔅ ᐋ ᐃᔅᒌᔂᒥᑭᐦᒡ ᐲᑎᕐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ᒦᓐ ᐊᓂᔮᔨᐤ ᐋᑎ ᒌᔒᑳᔨᒡ ᒌᓴᔅ ᒌ ᐄᑖᔨᐦᑎᒻ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐄᑐᐦᑖᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᒥᔅᑭᐙᑦ ᕕᓕᑉ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐱᐹᐐᒑᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ᕕᓕᑉ ᒫᒃ ᐊᓂᑖᐦ ᐹᕪᓵᐃᑖᐦᒡ ᒌ ᐅᐦᒋᔨᐤ ᐊᓂᔮᔨᐤᐦ ᐊᓐᑎᕉ ᑭᔮᐦ ᐲᑎᕐ ᐅᑎᐦᑖᐎᓂᐙᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ᕕᓕᑉ ᒫᒃ ᒌ ᓈᓂᑎᐙᐱᒫᐤ ᓈᕧᓂᔨᓪ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐄᔥᐱᐦ ᑳ ᒥᔅᑭᐙᑦ, “ᓂᒌ ᒥᔅᑭᐙᓈᓐ ᐊᓂᔮᔨᐤᐦ ᒧᓱᔅ ᑳᐦ ᐋᔨᒨᒫᑦ ᐊᓂᑖᐦ ᐐᔓᐙᐎᓂᐦᒡ, ᑭᔮᐦ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑳᐦ ᐋᔨᒨᒫᒡ᙮ ᐋᐅᒄ ᐆ ᒌᓴᔅ, ᒍᓯᕝ ᐅᑯᓯᔅᐦ, ᐊᓂᑖᐦ ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ᐋᒄ ᓈᕦᓃᔨᓪ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᑳᑭᔮᐦ ᑭᑎ ᒌ ᐅᐦᒋᔨᐤ ᐊᐙᓐ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐊᓂᑖᐦ ᓈᓯᕆᑎᐦᒡ᙮” ᐋᒄ ᕕᓕᑉ ᑳᐦ ᐄᑖᑦ, “ᐋᔥᑎᒻ ᐹᒋ ᐙᐱᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᓈᕧᓂᔨᓪ ᐋ ᐹᑖᔥᑎᒧᐦᑖᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᐋᐅᒄ ᐆ ᒋᐦᒋᐙ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ, ᐋᑳ ᓈᔅᑏᔅ ᐲᐦᒋᔥᑳᑯᑦ ᑳᒌᔑᐦᐄᐙᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ᓈᕦᓃᔨᓪ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᑖᓂᑖᐦ ᐙᐦᒋ ᒋᔅᒑᔨᒥᔨᓐ?” ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒋᒌ ᐙᐱᒥᑎᓐ ᐋ ᐊᐱᔨᓐ ᔒᐹᔮᒋᐦᑎᒄ ᒥᓯᔔᒥᓈᐦᑎᑯᐦᒡ ᐋᒸᔮ ᐅᐦᒋ ᓂᑎᐙᐱᒥᔅᒃ ᕕᓕᑉ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ᓈᕦᓃᔨᓪ ᑳᐦ ᐄᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐋᐅᒄ ᒌᔨ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐋᐅᒄ ᒌᔨ ᒋᐦᒋᐅᒋᒫᐤ ᐅᑎᐦ ᐃᔅᕋᐃᓕᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᒌ ᑖᑆᐦᑖᓐ ᐋ ᐊᓐ ᒥᒄ ᐋ ᒌ ᐐᐦᑎᒫᑖᓐ ᐋ ᒌ ᐙᐲᒥᑖᓐ ᔒᐹᔮᒋᐦᑎᒄ ᒥᓯᔔᒥᓈᐦᑎᑯᐦᒡ? ᐋᔥᒄ ᒋᑭ ᐙᐱᐦᑖᓐ ᐊᑎᑎᐤ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ᐋᒄ ᒦᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᓈᔥᒡ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒋᑭ ᐙᐱᐦᑖᓈᐙᐤ ᒋᐦᒋᒌᔑᒄ ᐋᐦ ᐋᐱᐦᐄᐱᔨᐦᒡ, ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᑖᓐᒋᓂᒻᐦ ᐋ ᐅᐦᐱᐱᔨᔨᒡ ᑭᔮᐦ ᐋ ᐹᒋ ᔮᔒᔅᑎᐙᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᒌ ᒋᐦᒋᐐᒋᑐᓈᓂᐤ ᐊᓂᑖᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᑫᓈ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᒌᓴᔅ ᐅᑳᐐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᓂᑐᒫᑭᓂᐎᒡ ᐊᓂᔮᔨᐤᐦ ᐋ ᒋᐦᒋᐐᒋᑐᓈᓂᐎᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᑳ ᒋᑖᑭᓂᐎᒡ ᐊᓐ ᔔᒥᓈᐳᐃ, ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ ᐅᑳᐐᐦ, “ᔖᔥ ᓅᐦᑖᐱᔫᒡ ᔔᒥᓈᐴᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐃᔅᒀᐤ, ᒑᒀᓐ ᐙᐦᒋ ᐐᐦᑎᒧᔨᓐ ᐊᓐ? ᑖᐹ ᐋᔥᒄ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᒑ ᒋᔅᒑᔨᐦᑖᑯᓯᔮᓐ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ᐋᒄ ᐋᐦ ᑖᔨᒡ ᐅᑳᐐᐦ ᐋᐱᒋᐦᐋᑭᓐ, “ᒥᒄ ᑖᓐ ᒑ ᐄᑎᔓᒥᑖᒀ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᑐᑎᒸᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ᒌ ᑎᑯᓐ ᒫᒃ ᐊᓂᑎᐦ ᑯᑣᔥᒡ ᐊᓯᓂᔨᐤ ᐊᑑᑎᐹᓱᐙᑭᓐ᙮ ᐹᐦᐹᔨᒄ ᒫᒃ ᐅᐦᐄ ᐊᑑᑎᐹᓱᐙᑭᓐ ᐎᔮᔥ ᓃᔥᑎᓂᐤ ᑭᔮᐦ ᒫᒃ ᓂᔥᑐᒥᑎᓂᐤ ᐋ ᑎᐦᑐᒥᓂᐦᒀᑭᓈᔮᒡ ᒑ ᒌ ᐄᔅᐱᐦᑖᑭᒥᐦᒡ ᓂᐲ ᒌ ᐃᔮᔅᐱᔖᐤ᙮ ᒎᐤ ᐄᔨᔨᐅᒡ ᒫᒃ ᐋ ᒋᔥᑖᐱᔫᒡ ᐄᑖᐱᒋᐦᑖᐅᒡ ᐅᔮᔨᐤ ᓂᐲᔨᐤ ᐋᐦ ᑐᑎᐦᒡ ᑖᓐ ᐋᑎᔓᒥᑯᒡ ᐅᑎᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐋᐱᒋᐦᐋᑭᓐᐦ, “ᓵᑭᔅᒋᓈᐹᒋᐦᑖᒄ ᓂᐲ ᐅᑎᐦ ᐅᐦᐄ ᐊᑑᑎᐹᓱᐙᑭᓐ᙮” ᒥᑐᓐ ᒫᒃ ᒌ ᓵᑭᔅᒋᓈᐹᐦᒋᑖᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ᐋᒄ ᒦᓐ ᐋᑖᑦ, “ᒀᐱᐦᐊᒧᒄ ᐊᐱᔒᔥ ᒑ ᐄᑐᐦᑎᐙᒄ ᐊᓐ ᒥᑯᔖᐅᒋᒫᐤ᙮” ᐋᔪᐎᒄ ᑭᔨᑆ ᑳᐦ ᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ᒌ ᑯᒋᔥᑎᒻ ᐊᓐ ᒥᑯᔖᐅᒋᒫᐤ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ, ᔖᔥ ᒫᒃ ᔔᒥᓈᐴᐦᒡ ᒌ ᐄᑖᑭᒥᔪ᙮ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᔔᒥᓈᐴᔨᐤ᙮ ᐊᓂᒌ ᒫᒃ ᐐ ᐋᐱᒋᐦᐋᑭᓂᒡ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ ᑳ ᒀᐱᐦᐊᐦᒡ ᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐐᔨᐙᐤ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᔔᒥᓈᐴᔨᐤ᙮ ᐋᒄ ᐊᓐ ᒥᑯᔖᐅᒋᒫᐤ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐅᔅᒋᓈᐹᐙᓐᐦ, ");
INSERT INTO crl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ᐋᒄ ᐋᑖᑦ, “ᒥᓯᐙ ᐊᐙᓐ ᐋ ᒥᑯᔖᑦ, ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᐋ ᒥᔻᔒᔨᒡ ᔔᒥᓈᐴᔨᐤ ᓃᔥᑎᒻ ᒥᓂᐦᐄᐙᐤ, ᐋᒄ ᐄᔥᐱᐦ ᐋᑎ ᒥᔪᐦᑭᓱᔨᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᓂᑑᒫᑦ, ᐋᒄ ᐊᓂᔮᔨᐤ ᐋᑳ ᓵᐹᑭᒥᔨᒡ ᔔᒥᓈᐴᔨᐤ ᒫᓂᐦᐄᐙᑦ᙮ ᒫᐅᒡ ᑳ ᒥᔻᑭᒥᒡ ᔔᒥᓈᐳᐃ ᐋᐅᒄ ᒫᐦᒋᒡ ᒌ ᒫᓂᐦᐄᐙᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑫᓈᐦᒡ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ, ᐋᐅᒄ ᓃᔥᑎᒻ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ ᑳᐦ ᑐᑎᐦᒃ ᒌᓴᔅ, ᐋᑯᑖᐦ ᑳ ᓅᑯᓃᔨᒡ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᑖᑆᔮᔨᒥᑯᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ᐋᒄ ᒌᓴᔅ ᑭᔮᐦ ᐅᑳᐐᐦ ᑭᔮᐦ ᐐᒋᔖᓐ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᒡ᙮ ᓂᒧᐃ ᒥᒄ ᓈᔥᒡ ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᐅᐦᒋ ᑖᐅᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ᔖᔥ ᒫᒃ ᒌ ᐹᔓᓈᑯᓂᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᒥᑯᔖᒡ, ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᒄ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐄᑐᐦᑖᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ᐊᓂᑖᐦ ᒫᒃ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᐋᑎ ᐲᐦᒑᑦ, ᒌ ᐙᐱᒫᐤ ᐊᑖᐙᓲᐤᐦ ᐋ ᐊᑖᐙᔨᒡ ᒥᔅᑐᔅ ᑭᔮᐦ ᒫᓂᔥᒑᓂᔥ ᑭᔮᐦ ᐱᔮᔒᔥ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒦᔥᑯᑑᓈᔨᒡ ᔓᐎᔮᓐ ᐋ ᐊᐱᔨᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ᐋᒄ ᑳ ᐅᔑᐦᑖᑦ ᐱᔑᔥᑖᐦᐄᑭᓂᔨᐤ ᓵᔅᑏᒀᔮᐲ ᐋᐦ ᐋᐱᒋᐦᐋᑦ, ᐋᒄ ᑳ ᐙᐐᔮᒧᐦᒑᑦ ᐊᓂᔮᔨᐤᐦ ᐊᑖᐙᔔᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐅᐦᑳᓐ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑖᐱᔥᑯᓐ ᐊᓂᔮᔨᐤᐦ ᒫᓂᔥᒑᓂᔥ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᒥᔅᑐᔅ᙮ ᒌ ᒀᑎᐹᐙᐱᓂᒸᐤ ᑭᔮᐦ ᐅᒦᒋᓲᓈᐦᑎᑯᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒦᔥᑯᑎᓈᔨᒡ ᔓᐎᔮᓐ, ᑳ ᐊᔅᒋᐙᐱᓂᒫᑦ ᐊᓂᔮᔨᐤ ᐅᔔᔮᓂᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐱᔮᔒᔥ ᑳ ᐊᑖᐙᒑᔨᒡ, “ᒫᒌᒄ ᐎᔨᐐᐦᑎᐦᐋᐦᑯᒡ ᓈᑖᐦ ᐊᓂᒌ᙮ ᐋᑯᓐ ᐋᒄ ᐃᔥᐱᔥ ᐅᑖᐙᐅᑭᒥᑯᑐᒸᐦᒄ ᐅᔮᐦ ᓅᐦᑖᐐ ᐐᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒫᒃ ᒌ ᐅᐦᒋ ᒋᔥᒋᓯᔨᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ᒥᑐᓐ ᓂᑭ ᔑᐦᑯᒋᐦᐄᑯᓐ ᓈᔥᒡ ᐋ ᓵᒋᐦᑖᔮᓐ ᒌ ᐙᔅᑳᐦᐄᑭᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ᐋᒄ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒎᐄᔨᔨᐤ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᐋᒄ ᐋᑎᑯᑦ, “ᐊᐙᓐ ᑳᐦ ᐄᑎᔓᒥᔅᒃ ᐊᓐ ᑳᐦ ᑐᑎᒥᓐ, ᒑᒄ ᐅᒋᒫᐎᓐᐦ ᐃᔮᐱᒋᐦᑖᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓂᔑᐎᓈᒋᐦᑖᒄ ᐆ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ, ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᒦᓐ ᑳᐤ ᓂᑭ ᐎᔨᑳᐳᐦᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ᐋᒄ ᐃᔮᒡ, “ᑖᑆᐦᐋ, ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᐋ ᐃᔥᐱᔥ ᔖᔥ ᒦᓐ ᒋᑭ ᒌ ᐎᔨᑳᐳᐦᑖᓐ? ᓈᒥᑎᓂᐤ ᓂᑯᑣᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᒌ ᐱᒦᐦᑳᑭᓂᐤ ᐆ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᑳ ᐎᔨᑳᐳᐦᑖᑭᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒫᒃ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑳᐦᐄᑦ ᒌᓴᔅᐦ ᐅᔨᐤ ᐙᔥ ᐊᓂᔮᔨᐤ ᒌ ᐋᔨᒸᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᓂᔥᑳᓈᑭᓅᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᐋᒄ ᑳ ᒋᔥᒋᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ᙮ ᒌ ᑖᑆᐦᑎᒧᒡ ᒫᒃ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ᒫᒀᒡ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᑖᑦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐊᓂᔮᔨᐤ ᒫᒀᒡ ᑳ ᒥᑯᔖᓂᐎᔨᒡ ᒥᔮᔅᑳᒑᐎᓐ ᒥᑯᔖᓂᔨᐤ, ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒌ ᑖᑆᔮᔨᒥᑰ ᐄᔥᐱᐦ ᑳ ᐙᐱᒥᑯᑦ ᐋ ᒫᒥᔥᑳᒡ ᐋ ᐃᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ᒌᓴᔅ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᐅᒑᔨᒫᐤ ᐙᔥ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ᓂᒧᐃ ᑭᔮᐦ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒻ ᒑ ᒌ ᐐᐦᑎᒫᑯᑦ ᐊᐙᔨᐤᐦ ᑖᓐ ᐋᔨᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᐙᔨᐤᐦ ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐤ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ᒌᐦ ᑖᐤ ᓈᐹᐤ ᓂᑯᑏᒧᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᐹᕆᓰᔨᒡ ᒌ ᐅᐦᒌᐤ ᑭᔮᐦ ᐋᐅᒄ ᐊᓐ ᐹᔨᒄ ᑳ ᓃᑳᓂᔥᑭᐙᑦ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᑎᐱᔅᑳᔨᒡ ᒌ ᓂᑎᐙᐱᒫᐤ ᒌᓴᔅᐦ ᐋᒄ ᐋᑖᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᒋᔅᒑᔨᒥᑎᓈᓐ ᒌᔨ ᐋᐦ ᐋᐎᔨᓐ ᒋᔅᑯᑎᒫᒑᓯᐤ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐆᔅᒃ ᒋᔖᒥᓂᑑ᙮ ᐙᔥ ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌᐦ ᑐᑎᒻ ᐊᓂᔮᔨᐤ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ ᒌᔨ ᑳᐦ ᑐᑎᒥᓐ ᐋᑳ ᐐᒑᐅᑯᒑ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓈᔥᒡ ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓐ, ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐙᐱᐦᑎᒸᐤ ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤᐦ ᐹᑎᔥ ᒦᓐ ᒌ ᐄᔨᔨᐎᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ᐋᒄ ᓂᑯᑏᒧᔅ ᐋᑎᑯᑦ, “ᑖᓂᑖᐦ ᒦᓐ ᒑ ᒌ ᐅᐦᒋ ᐄᔨᔨᐎᑦ ᐊᐙᓐ ᔖᔥ ᐋ ᒌᔥ ᓂᐦᑖᐅᒋᑦ? ᓂᒧᐃ ᒦᓐ ᒋᑭ ᒌ ᐲᐦᒑᐙᐤ ᐅᑳᐐᐦ ᐅᔅᐱᔮᔨᐦᒡ ᒦᓐ ᒑ ᒌ ᐄᔨᔨᐎᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑯᐃᔅᒄ ᒋᐐᐦᑎᒫᑎᓐ, ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐲᐦᒑᐤ ᒋᔖᒥᓂᑑᐦ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ ᐹᑎᔥ ᓂᐲᐦᒡ ᑭᔮᐦ ᐊᐦᒑᐦᑯᐎᓂᐦᒡ ᐅᐦᒋ ᐄᔨᔨᐅᐦᐄᑯᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ᒥᓯᐙ ᒋᓃᒋᐦᐄᑯᓅᒡ ᐋᐦ ᑖᒡ ᒋᒌ ᐅᐦᒋ ᐃᔮᓈᓂᐤ ᐆ ᐄᔨᔨᐤ ᐱᒫᑎᓰᐎᓐ᙮ ᒥᒄ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋᐦ ᑖᑦ ᐅᐦᒋ ᐋᑯᑖᐦ ᐙᐦᒋ ᐃᔮᔨᐦᒄ ᐊᐦᒑᐦᒄ ᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ᐊᑳᐐ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᒄ ᐆ ᐋᐦ ᐄᑎᑖᓐ ᐋ ᓂᑎᐙᔨᐦᑖᑯᓯᔨᓐ ᒦᓐ ᒑ ᒌ ᐄᔨᔨᐅᐄᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ᐋ ᔫᑎᐦᒡ, ᒥᒄ ᐊᓂᑖᐦ ᐙᐦ ᐄᔑ ᔪᐙᒡ ᐋᑯᑖᐦ ᐋ ᐄᔑ ᔪᐙᒡ᙮ ᐹᐦᑖᑯᓐ ᐋ ᔫᑎᐦᒡ ᓂᒧᐃ ᒥᒄ ᒋᔅᒑᔨᐦᑖᑯᓐ ᑖᓂᑖᐦ ᓂᐦᐋᐤ ᐙᐦᒋᐱᔨᒡ ᑭᔮᐦ ᑖᓂᑖᐦ ᐋ ᐃᔅᐱᔨᒡ ᐊᓐ ᐋ ᔫᑎᐦᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᑦ ᒥᓯᐙ ᑎᐦᑐ ᐊᐙᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᑳ ᐅᐦᒋ ᐱᒫᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ᐋᒄ ᓂᑯᑏᒧᔅ ᐋᑎᑯᑦ, “ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐄᔅᐱᔨᒡ ᐆ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᒌᔨ ᐋᐅᒄ ᐹᔨᒄ ᒋᔅᑯᑎᒫᒑᓯᐤ ᐅᑎᐦ ᐃᔅᕋᐃᓕᐦᒡ, ᐊᔮᐱᒡ ᐋ ᒫᒃ ᓂᒧᐃ ᒌ ᓂᔅᑐᐦᑖᓐ ᐆ ᑳ ᐃᔮᓐ? ");
INSERT INTO crl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ᑯᐃᔅᒄ ᒋᐐᐦᑎᒫᑎᓐ᙮ ᓂᑎᐋᔨᒨᑖᓈᓐ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᒫᐦᒡ, ᓂᒧᐃ ᒫᒃ ᒌᔨᐙᐤ ᒋᐐᐦ ᑖᑆᐦᑑᓈᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ᓂᒧᐃ ᒋᑖᑆᐦᑑᓈᐙᐤ ᐋ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓐ ᐋᔨᔅᐱᔨᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᐦᑎᒫᒄ ᐐᐦᑎᒫᑎᑯᒑ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ᓂᒧᐃ ᒫᒃ ᐊᐙᓐ ᐅᐦᒋ ᐅᐦᐱᔅᑳᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ ᒥᒄ ᐊᓐ ᐄᔨᔨᐆᑯᓯᓵᓐ ᐋᐅᒄ ᐊᓐ ᐐᔨ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐹᒋ ᔮᔒᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᑳᐦ ᑎᒃ ᐊᓂᔮ ᒧᓱᔅ ᒫᒀᒡ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑖᒡ ᑳ ᒋᑭᒧᐦᐋᑦ ᑭᔮᐦ ᑳ ᓃᒫᔅᑯᐙᑦ ᐊᒋᓈᐳᑯᐦᑳᓐ ᒥᔅᑎᑯᐦᒡ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐙᐱᒫᔨᒡ, ᐋᔪᐎᒄ ᒧᔮᒻ ᑭᔮᐦ ᐐᔨ ᒋᐱᐦ ᓃᒫᔅᑯᐦᐙᑭᓂᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᑆᔮᔨᒫᑦ ᒑ ᒌ ᐃᔮᑦ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ᐙᔥ ᒋᔖᒥᓂᑑ ᑳ ᐃᔥᐱᔥ ᓵᒋᐦᐋᑦ ᐊᔅᒌᐦᒡ ᐋᐦ ᑖᔨᒡ ᒌ ᐱᒋᔅᑎᓈᐤ ᒥᒄ ᑳ ᐹᔨᑯᔑᔨᒡ ᐅᑯᓯᔅᐦ, ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒑ ᑖᑆᔮᔨᒥᑯᔨᒡ ᒑᐦ ᐋᑳ ᐄᔨᐎᐦᐅᔨᒡ, ᒫᒃ ᒑ ᒌ ᐃᔮᔨᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ᐙᔥ ᒋᔖᒥᓂᑑ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᐅᑯᓯᔅᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐱᒫᒋᐦᐋᔨᒡ ᐊᐙᔨᐤᐦ, ᓂᒧᐃ ᐐᔨ ᒑ ᒌ ᐹᒋ ᓂᔑᐎᓈᒋᐦᒫᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑎᔮᑆᔮᔨᒥᒫᑦ ᐅᑯᓯᓯᒫᐤ ᓂᒧᐃ ᓂᔑᐎᓈᒋᒫᑭᓂᐤ, ᐊᓐ ᐐᔨ ᐋᑳ ᑖᑆᔮᔨᒫᑦ ᔖᔥ ᓂᔑᐎᓈᒋᒫᑭᓂᐤ ᐙᔥ ᓂᒧᐃ ᑖᑆᔮᔨᒫᐤ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑᐦ ᑳ ᐹᔨᑯᔑᔨᒡ ᐅᑯᓯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ᐋᐅᒄ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ᙮ ᐙᔥᑖᐎᓐ ᒌ ᐹᒋ ᐱᒋᔅᑎᓈᑭᓂᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒥᒄ ᒫᒃ ᐊᐅᔅᑖ ᒌ ᓵᒋᐦᑖᐅᒡ ᐄᔨᔨᐅᒡ ᐊᐅᑳᔥᑖᔮᐎᓂᔨᐤ ᐃᔥᐱᔥ ᐐᔨ ᐙᔥᑖᐎᓂᔨᐤ, ᐙᔥ ᒌ ᒥᒑᑎᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ᐙᔥ ᒥᓯᐙᐦ ᑖᐦᑐ ᐊᐙᓐ ᑳ ᒥᒋᐦᑐᑎᐦᒃ ᐅᐦᑳᑎᒻ ᐊᓂᔮᔨᐤ ᐙᔥᑖᐎᓂᔨᐤ ᓂᒧᐃ ᐐᐦ ᓈᑎᒻ ᐙᔥ ᓂᒧᐃ ᓂᑎᐙᔨᐦᑎᒻ ᒑ ᒌ ᓅᑯᓃᔨᒡ ᐅᒥᒋᐄᐦᑐᐎᓐ ᐊᓂᑖᐦ ᐋ ᐙᔥᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᑖᑆᐎᓂᐦᒡ ᑳ ᐄᔑ ᐱᒫᑎᓰᑦ ᐊᓂᑖᐦ ᐋ ᐙᔥᑖᔨᒡ ᐄᑐᐦᑖᐤ, ᐋᒄ ᒫᒃ ᓅᑯᓃᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᓂᐦᐄᐦᑎᐙᑦ ᐅᑎᐦᑐᐎᓂᐦᒡ ᒋᔖᒥᓂᑑ ᐋ ᐐᒋᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ᐹᑎᒫ ᒫᒃ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᒌ ᐄᑐᐦᑖᐤ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋ ᐐᒑᐅᑯᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᑖᐙᑦ ᐋᐦ ᑖᔨᒡ ᑭᔮᐦ ᒌ ᓰᑭᐦᐋᐦᑖᒑᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ᑭᔮᐦ ᐐᔨ ᒞᓐ ᒌ ᓰᑭᐦᐋᐦᑖᒑᐤ ᐊᓂᑖᐦ ᐁᓍᓐ, ᓂᒧᐃ ᐙᐦᔨᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᓭᓕᒥᐦᒡ ᐙᔥ ᓈᔥᒡ ᒌ ᒥᔖᔨᐤ ᓂᐲᔨᐤ ᐊᓂᑖᐦ᙮ ᒨᔥ ᒌ ᓂᑎᐙᐱᒥᑰ ᐊᐙᔨᐤᐦ ᐋ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑦ, ᒌ ᓰᑭᐦᐋᐦᑎᐙᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᑎᒃ ᒞᓐ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᑎᓈᑭᓅᑦ ᒑ ᒋᐴᐦᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ᐱᔅᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᒞᓐ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑭᔮᐦ ᑯᑎᑭᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐎᔥᑖᐱᔨᐎᒡ ᐋᐦ ᐋᔨᒨᑎᐦᒡ ᐊᔨᒥᐦᐋᐤ ᐱᔮᐦᒋᐦᐄᐙᐎᓂᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᒞᓐ ᑭᔮᐦ ᒌ ᐄᑖᐅᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᐊᓐ ᓈᐹᐤ ᑖᐱᔥᑯᓐ ᑳᐦ ᑖᔮᒄ ᐊᓂᑖᐦ ᐙᐱᓅᑖᐦᒡ ᐊᓐ ᒞᕐᑎᓐ ᓰᐲ, ᐊᓐ ᑳᐦ ᐋᔨᒨᒥᑦ, ᐊᓅᐦᒡ ᑭᔮᐦ ᐐᔨ ᓰᑭᐦᐋᐦᑖᒑᐤ ᑭᔮᐦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᓂᑎᐙᐱᒥᑰ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ᐋᒄ ᒞᓐ ᐋᑖᑦ, “ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐃᔮᐤ ᒑᒀᔨᐤ ᐹᑎᔥ ᒋᔖᒥᓂᑑ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐦ ᑖᔨᒡ ᒥᔨᑰᒑ ᒑ ᒌ ᐃᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ᒌᔨᐙᐤ ᒫᒃ ᒋᒌ ᐹᐦᑑᓈᐙᐤ ᐆ ᑳ ᐃᔮᓐ, ‘ᓂᒥᔮᐤ ᓃᔨ ᐊᓐ ᙭, ᒥᒄ ᒫᒃ ᓂᒌ ᐹᒋ ᓃᑳᓂᑎᔑᐦᐅᑭᐎᓐ ᓃᔨ ᒑ ᒌ ᐋᔨᒨᒥᒃ᙮’ ");
INSERT INTO crl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ᐋᐅᒄ ᐙᓯᓐ ᓃᔨ ᒧᔮᒻ ᐊᓐ ᐅᔅᒋᓈᐹᐙᓐ ᐅᐐᒑᐙᑭᓐ, ᐐᔨ ᒋᑭ ᐐᒋᒫᐤ ᐊᓂᔮᔨᐤ ᐅᔅᒋᔅᒀᐙᓐ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐅᐐᒑᐙᑭᓐ ᐊᓐ ᐅᔅᒋᓈᐹᐙᓐ, ᐊᓂᔮᔨᐤ ᑳ ᐐᒋᐦᐄᐙᔨᒡ, ᐊᔑᓂᐙᐦᐄᑰ ᒑ ᐃᔥᐱᔥ ᑎᑯᔑᐦᒃ ᑭᔮᐦ ᒥᔻᔨᐦᑎᒥᔨᐤ ᐄᔥᐱᐦ ᐱᔮᐦᑖᑯᑦ᙮ ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᑭᔮᐦ ᓃᔨ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᒫᓐ ᔖᔥ ᐋᐦ ᑖᑦ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ᓂᑎᐙᔨᐦᑖᑯᓐ ᒫᒃ ᐐᔨ ᐊᑎᑎᐤ ᒑ ᒌ ᐋᑎ ᒋᔅᑖᔨᒫᑭᓅᑦ, ᐋᒄ ᓃᔨ ᓈᓈᓂᒌᒻ ᐋᑳ ᒑ ᒌ ᐃᔥᐱᔥ ᒋᔅᑖᔨᒥᑭᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ᐙᔥ ᐊᓐ ᐃᔥᐱᒥᐦᒡ ᑳ ᐅᐦᑐᐦᑖᑦ ᐋᐅᒄ ᐊᓐ ᒫᐅᒡ ᐋ ᐃᔥᐹᔨᐦᑖᑯᓯᑦ᙮ ᐊᓐ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᑦ, ᐊᔅᒌᐦᒡ ᐄᔑ ᐱᒫᑎᓰᐤ, ᑭᔮᐦ ᐊᔅᒌᔨᐤ ᐋᔨᒨᑎᒻ᙮ ᐊᓐ ᐊᐙᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒌᑦ ᐐᔨ ᒫᐅᒡ ᐄᔅᐱᔨᐦᑖᑯᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ᐐᐦᑎᒻ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒃ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᐦᒃ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐊᐙᔨᐤᐦ ᑖᑆᐦᑖᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ᐊᓐ ᐊᐙᓐ ᑳ ᐅᑎᓂᒸᑦ ᑖᓐ ᐋᐦ ᐄᔨᔨᒡ ᐋᑯᑖᐦ ᓅᑯᓃᔨᒡ ᐋ ᑖᑆᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐋ ᑖᑆᐅᒑᔨᐦᑖᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᒋᔖᒥᓂᑑ ᐃᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᔨᑯᑦ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐃᔨᑦ ᑭᔮᐦ ᒥᑐᓐ ᐲᐦᒋᔥᑳᑰ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ᐅᐦᑖᐐᒫᐤ ᓵᒋᐦᐋᐤ ᐅᑯᓯᓯᒫᐤ᙮ ᒌ ᒥᔮᐤ ᒥᓯᐙ ᒑᒀᔨᐤ ᒑ ᒌ ᑎᐹᔨᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᑖᑆᔮᔨᒫᑦ ᐅᑯᓯᓯᒫᐤ ᐃᔮᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᐋᒄ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᓂᓂᐦᐄᐦᑎᐙᑦ ᐅᑯᓯᓯᒫᐤ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐃᔮᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ᒋᔖᒥᓂᑑ ᐅᑖᐦᑭᐎᐙᔓᐎᓂᔨᐤ ᒋᑭ ᒋᒋᔥᑳᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ᒌᓴᔅᐦ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐹᕆᓰᐦ ᐋ ᒌ ᐹᐦᑎᒦᑯᐱᓈᓂᐦᐄ ᒌᓴᔅᐦ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᐋ ᑭᔅᒋᐦᐋᔨᒡ ᑭᔮᐦ ᐋ ᓰᑭᐦᐋᐦᑎᐙᔨᒡ ᐄᔨᔨᐤᐦ ᐃᔥᐱᔥ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ᒥᒄ ᒫᒃ ᑖᐹ ᓂᒥᔮᐤ ᐐᔨ ᒌᓴᔅ ᑳ ᓰᑭᐦᐋᐦᑖᒑᑦ, ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᔮᔨᐤ ᒌ ᓰᑭᐦᐋᐦᑖᒑᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒃ ᒌᓴᔅ ᐋᐦ ᐋᔨᒧᒫᑭᓅᑦ, ᒌ ᓂᑭᑎᒻ ᒎᑏᔮ ᐊᔅᒌᔨᐤ ᐋᒄ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᒦᓐ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ᒥᒄ ᒫᒃ ᒋᐱᐦ ᐋᑎ ᔖᐳᐦᑎᐙᔥᑭᒻ ᒫᒃ ᓵᒫᕆᔮ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᐋ ᐐᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᐋᐦ ᑖᑦ, ᒌ ᐅᑎᐦᑎᒻ ᐃᐦᑖᐎᓂᔨᐤ ᓵᐃᑭᕐ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐹᔓᒡ ᒫᒃ ᐅᑎᐦ ᐅᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋᑯᑖᐦ ᑳᐦ ᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐊᓂᔮ ᒉᑭᑉ ᑳ ᒥᔮᑦ ᐅᑯᓯᔅᐦ ᒍᓯᕝᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ᒌ ᑎᑯᓐ ᐊᓂᑎᐦ ᐅᐦᑎᐦᐄᐹᓐ, ᒉᑭᑉ ᐅᐦᑎᐦᐄᐹᓐ ᒌ ᐃᔑᓂᐦᑳᑖᐤ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᐃᔮᔅᑯᐦᑖᐤ ᒌᓴᔅ, ᑳᐦ ᐋᑎᐅᐙᔨᐱᑦ ᐹᔓᒡ ᐊᓂᑎᐦ ᐅᐦᑎᐦᐄᐹᓂᐦᒡ᙮ ᐎᔮᔥ ᒌ ᐋᐱᐦᑖᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ᓈᓈᒑᔒᔥ ᒫᒃ, ᐃᔅᒀᐤ, ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᒌᑦ ᒌ ᐹᒋ ᒀᐱᒑᐤ᙮ ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐹᒋ ᒥᔨᐦ ᒫᐦ ᐃᔨᐦᐲ ᒑ ᒌ ᒥᓂᐦᒀᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ᒫᒀᒡ ᐊᓂᔮᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᑖᔨᐤ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐙᔥ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒌ ᐄᑐᐦᑖᔨᐤ ᒦᒋᒥᔨᐤ ᐋ ᒌ ᓂᑑᐅᑎᓂᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ᐋᒄ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᐊᑎᑯᑦ, “ᒎᐄᔨᔨᐤ ᒌᔨ᙮ ᓃᔨ ᒫᒃ ᓵᒫᕆᔮ ᐃᔅᒀᐤ᙮ ᒑᒀᓐ ᐙᐦᒋ ᓂᑎᐙᔨᐦᑎᒥᓐ ᒑ ᒌ ᒥᓂᐦᐄᑖᓐ?” ᓂᒧᐃ ᒥᑐᓐ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᐅᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᒋᔅᒑᔨᐦᑎᒨᐦᐱᓈ ᒑᒀᔨᐤ ᐙᐦ ᒥᔨᐙᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒋᔅᒑᔨᒥᔨᓐ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ, ᒌᔨ ᒋᐱᐦ ᑯᒀᒋᒥᓐ ᒑ ᒌ ᒥᓂᐦᐄᑖᓐ᙮ ᐊᓐ ᒫᒃ ᑳ ᐱᒫᒋᐦᐄᐙᒥᑭᐦᒡ ᐃᔨᐦᐲ ᐋᐅᒄ ᐊᓐ ᒋᐱᐦ ᒥᓂᐦᐄᑎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ᐋᒄ ᐋᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, “ᓂᒧᐃ ᒋᑎᔮᓐ ᐊᔅᒋᐦᒄ ᒑ ᒌ ᒀᐱᐦᐄᑳᒑᔨᓐ ᑭᔮᐦ ᐊᓐ ᐃᔨᐦᐲ ᓈᔥᑖᑆᐦ ᔮᐅᓈᑯᓐ ᐊᓂᑖᐦ ᓃᐦᑖᐦᒡ, ᑖᓂᑖᐦ ᒫᒃ ᒑ ᐅᐦᑎᐦᐊᒥᓐ ᐊᓐ ᐃᔨᐦᐲ ᑳ ᐱᒫᒋᐦᐄᐙᒥᑭᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ᐙᔥᑭᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒋᑖᓂᔅᒑ ᐙᐦᑯᒫᑭᓂᐤ ᒉᑭᑉ ᒋᒌ ᒥᔨᑯᓂᐤ ᐅᔮᔨᐤ ᐅᐦᑎᐦᐄᐹᓂᔨᐤ᙮ ᒌ ᒥᓂᐦᒀᐤ ᐅᔮᔨᐤ ᐃᔨᐦᐲᔨᐤ ᑭᔮᐦ ᐅᑯᓯᔅᐦ, ᑭᔮᐦ ᐅᒫᓂᔥᒑᓂᔒᒻ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒥᓂᐦᒀᔨᒡ᙮ ᐊᐅᔅᑖ ᐋ ᒌᔨ ᒋᑎᐄᑖᔨᒦᓱᓐ ᐃᔥᐱᔥ ᐐ ᐊᓂᔮ ᒋᑖᓂᔅᒑ ᐙᐦᑯᒫᑭᓂᐤ ᒉᑭᑉ?” ");
INSERT INTO crl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐊᐙᓐ ᑳ ᒥᓂᐦᒀᑦ ᐅᔮᔨᐤ ᐃᔨᐦᐲᔨᐤ ᐅᑎᐦ, ᒦᓐ ᒋᑭ ᐹᐦᑯᑖᐦᑎᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ᐊᐙᓐ ᒫᒃ ᒑ ᒥᓂᐦᒀᒀ ᐊᓂᔮᔨᐤ ᐃᔨᐦᐲᔨᐤ ᒑ ᒥᔨᒃ ᒑ ᒌ ᒥᓂᐦᒀᑦ, ᓂᒧᐃ ᓂᐦᑖ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᐹᐦᑯᑖᐦᑎᒻ᙮ ᐙᔥ ᐊᓐ ᐃᔨᐦᐲ ᒑ ᒥᔨᐙᔮᓐ ᑭᑎ ᐲᐦᒋᔥᑳᑰ ᐊᐙᓐ ᒨᔮᒻ ᐋ ᐅᐦᒋ ᒨᔅᒑᐎᒍᐦᒡ ᑭᑎ ᐃᓯᓈᑯᓂᔨᐤ ᑭᔮᐦ ᐋᐅᒄ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᑦ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ᐋᒄ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤᐦ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐹᒋ ᒥᔨ ᐆ ᐃᔨᐦᐲ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᓂᑭ ᐅᐦᒋ ᐹᐦᑯᑖᐦᑖᓐ ᑭᔮᐦ ᓂᒧᐃ ᒦᓐ ᓂᐦᑖ ᓂᑭ ᐅᐦᒋ ᐹᒋ ᑎᑯᔑᓐ ᐅᑎᐦ ᒑ ᒌ ᐹᒋ ᒀᐱᒑᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, “ᒫᒌᐦ, ᓂᑎᐙᐱᒻ ᒋᓈᐹᒻ᙮ ᐹᔔ ᐅᑎᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᐋᑎᑯᑦ, “ᓂᒧᐃ ᓅᓈᐹᒥᓐ᙮” ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᒌ ᑖᑆᓐ ᐊᓐ ᑳᐦ ᐃᔨᓐ ᐋᐦᐋᑳ ᐅᓈᐹᒥᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ᓂᔮᔪ ᓈᐹᐅᒡ ᔖᔥ ᒋᒌ ᐐᒋᒫᐆᒡ ᑭᔮᐦ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐊᓅᐦᒡ ᑳ ᐐᒋᒥᑦ, ᐊᔮᐱᒡ ᓂᒥᔮᐤ ᐊᓐ ᒋᓈᐹᒻ᙮ ᑯᐃᔅᒄ ᒋᔑᓐ ᐊᓐ ᑳᐦ ᐃᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ ᐋᑎᑯᑦ, “ᐋᒀᑖᔨᒥᑖᓐ ᒧᔮᒻ ᐋᐦ ᐋᐎᔨᓐ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ᒋᑖᓂᔅᑰᓯᒥᓅᐎᒡ ᒌ ᑎᑯᔑᓂᒡ ᐋ ᐹᒋ ᓂᑑᐊᔨᒥᐦᐋᔅᑎᐙᒡ ᒋᔖᒥᓂᑑ ᐅᑎᐦ ᐋᐱᔅᑯᑎᓈᔨᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᒨᔥ ᐋᐅᒄ ᐃᔮᔮᒄ, ᒥᒄ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᑯᑖᐦ ᒑ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓅᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑖᑆᐦᑐ, ᐋᔥᒄ ᒋᑭ ᐄᔅᐱᔨᐤ ᒑᐦ ᐋᑳ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓅᑦ ᑰᐦᑖᐐᓂᐤ ᐅᑎᐦ ᐋᐱᔅᑯᑎᓈᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ᒌᔨᐙᐤ ᓵᒫᕆᔮ ᑳ ᐅᐦᒋᔮᒄ, ᒋᑎᔨᒥᐦᐋᔥᑎᐙᐙᐤ ᒋᔖᒥᓂᑑ ᐋᐦᐋᑳ ᒫᒃ ᒋᔅᒑᔨᒫᒄ᙮ ᓃᔮᓐ ᒎᐤ ᐄᔨᔨᐅᒡ, ᓂᒋᔅᒑᔨᒫᓈᓐ ᒋᔖᒥᓂᑑ ᐊᓐ ᑳ ᐊᔨᒥᐦᐋᔥᑎᐎᒋᐦᑦ᙮ ᐙᔥ ᐊᓂᑖᐦ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋᐱᔨᐦᒡ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒌ ᐱᒫᒋᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ᐙᔥ ᔖᔥ ᐹᔓᓈᑯᓐ, ᑭᔮᐦ ᐋᐅᒄ ᔖᔥ ᐋ ᐃᔅᐱᔨᒡ, ᐊᓂᒌ ᒋᐦᒋᐙ ᑳ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ ᐋᒫᒥᐦᒋᒫᒡ ᐅᐦᑖᐐᒫᐤ, ᐊᐦᒑᐦᑯᐎᓂᐦᒡ ᑭᔮᐦ ᑖᑆᐎᓂᐦᒡ ᐄᔑ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐋᐦ ᐄᑖᑎᓰᔨᒡ ᓈᑐᐙᔨᒫᑦ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᔅᑖᑯᑦ ᑰᐦᑖᐐᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ᒋᔖᒥᓂᑑ ᐐᔨ ᐊᐦᒑᐦᑰ, ᐋᒄ ᐊᓂᒌ ᑳ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ ᔮᔨᑖ ᑭᑎ ᐲᐦᒋᔅᑳᑯᐎᒡ ᐅᔮᔨᐤᐦ ᐊᐦᒑᐦᒄᐦ ᑭᔮᐦ ᑖᑆᐎᓂᐦᒡ ᒋᐱᐦ ᐄᔑ ᐊᔨᒥᐦᐋᔥᑎᐙᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ᐋᒄ ᐋᑎᑯᑦ ᐃᔅᒀᐤ, “ᓂᒋᔅᒑᔨᐦᑖᓐ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᒑ ᑎᑯᔑᓃᔨᒡ, ᙭ ᐃᔑᓂᐦᑳᓱᔨᐤ᙮ ᑎᑯᔑᐦᑳ ᒫᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᒋᑭ ᐐᐦᑎᒫᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐋᐅᒄ ᐊᓐ ᓃᔨ, ᓃᔨ ᑳ ᐊᔨᒥᐦᐄᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᑎᑯᔑᓃᔨᒡ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᓈᔥᒡ ᒫᒃ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ ᐋ ᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐋ ᐊᔨᒥᐦᐋᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᐙᒋᐹᔮᒄ ᐅᐦᒋ ᑯᒀᒋᒫᐅᒡ ᒑᒀᔨᐤ ᐙᐦᒋ ᐊᔨᒥᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᑯᒀᒋᒫᐅᒡ ᒑᒀᔨᐤ ᑳᐦ ᐋᔨᒸᐦᐄᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ᐋᒄ ᐊᓐ ᐃᔅᒀᐤ ᑳ ᓂᑭᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐅᒀᐱᑳᓐ, ᑳ ᒌᐙᑦ ᐊᓂᑖᐦ ᐅᑎ ᐃᐦᑖᐎᓂᐦᒡ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ᐋᔥᑎᒧᒄ᙮ ᒑ ᐙᐱᒫᒄ ᐊᓐ ᓈᐹᐤ ᑳ ᐹᒋ ᐐᐦᑎᒨᑦ ᒥᓯᐙ ᑖᓐ ᑳ ᑑᐎᒡ᙮ ᐋᐅᒄ ᑳᑭᔮᐦ ᐅᔮᔨᐤ ᙭ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑯᐱᓈ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐎᔨᐐᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ᒫᒀᒡ ᒫᒃ ᐅᔮᔨᐤ, ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒋᐐᐦ ᐋᔨᐦᑭᒥᐦᑰ, ᐋᐦ ᐄᑎᑯᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒦᒋᓲᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ᒥᒄ ᒌᓴᔅᐦ ᒌ ᐄᑎᑯᒡ, “ᓂᑎᔮᓐ ᐙᔥ ᒦᒋᒻ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ᐋᒄ ᐋᑎᑑᒡ, “ᒌ ᐹᑣᑰ ᑳᑭᔮᐦ ᐊᐙᔨᐤᐦ ᒑᒀᔨᐤ ᒑ ᒦᒋᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᒑ ᒌᐦ ᑐᑎᒧᒡ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᑭᔮᐦ ᒑ ᒌ ᒌᔑᐦᑖᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᒥᑦ ᒑ ᑐᑎᒧᒡ ᐋᐅᒄ ᐊᓐ ᒧᔮᒻ ᓂᒦᒋᒻ ᐋ ᐄᑖᔨᐦᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ᒋᔑᓈᐙᐤ, ‘ᓈᐤ ᐲᓯᒻ ᐋᒄ ᐃᔮᒄ ᒑ ᒌ ᒫᒨᔅᒋᓂᑭᓂᐎᐦᒡ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮’ ᒥᒄ ᒫᒃ ᓃᔨ, ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓈᑖᐦ ᒫᐦ ᔮᒀᐦ ᐄᑖᐱᒄ᙮ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᐊᓂᑖᐦ ᑳ ᓂᐦᑖᐅᒋᐦᒑᓂᐎᒡ ᔖᔥ ᐋ ᒌᔥ ᓂᐦᑖᐅᒋᐦᒡ ᐊᓂᐦᐄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ, ᐋᒄ ᒫᒃ ᒥᒄ ᒑ ᐄᔑ ᒫᒨᔅᒋᓂᑭᓂᐎᐦᒡ, ᐋᐅᒄ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᔖᔥ ᐋ ᒌᔥ ᐋᔮᔅᑰᐎᒡ ᒑ ᑖᑆᐦᑎᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐹᐦᑎᐦᒀᐙ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","ᐊᓐ ᑳ ᒫᒨᔑᒋᓂᐦᒃ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑎᐱᐦᐋᒧᐙᑭᓂᐤ᙮ ᒧᔮᒻ ᐊᓐ ᐊᐙᓐ ᑳ ᐐᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐃᔮᔨᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᐋᒀᔑᓈᑯᓯᑦ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᑳ ᓂᐦᑖᐅᒋᐦᒑᑦ ᑭᔮᐦ ᐊᓐ ᑳ ᒫᒨᔑᒋᓂᐦᒃ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑖᐱᔥᑯᓐ ᒑ ᒥᔻᔨᐦᑎᐦᒡ ᐙᔥ ᑖᐱᔥᑯᓐ ᒌ ᐋᐱᑎᓰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ᑖᑆᓂᐤ ᑳ ᐄᓈᓅᒡ, ‘ᐹᔨᒄ ᒋᑭ ᓂᐦᑖᐅᒋᐦᒑᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒑ ᒫᒨᔑᒋᓂᐦᒃ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ᔖᔥ ᑯᑎᑭᒡ ᒌ ᓂᐦᑖᐅᒋᐦᒑᐅᒡ ᑭᔮᐦ ᒌ ᒥᔥᑎᐦ ᐋᐱᑎᓰᐎᒡ ᐊᓂᑖᐦ ᑳ ᓂᐦᑖᐅᒋᐦᒋᒑᓂᐎᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐋᑎᔑᐦᐆᑖᑯᒡ ᒑ ᒌ ᒫᒨᔑᒋᓂᒸᒄ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ᙮ ᓂᒥᔮᐤ ᒌᔨ ᑳ ᓂᐦᑖᐅᒋᐦᒑᔨᓐ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒌ ᐐᒋᐦᐄᑯᐙᓐ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᐱᑎᓰᔨᒡ᙮” ᐋᐅᒄ ᑳᐦ ᐄᑖᑦ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ᒥᐦᒑᑐ ᓵᒫᕆᔮ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐅᐦᒌᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ᙮ ᐙᔥ ᒌ ᐃᔨᐤ ᐊᓐ ᐃᔅᒀᐤ, “ᒥᓯᐙ ᓂᒌ ᐐᐦᑎᒫᒄ ᑖᓐ ᑳ ᐹᒋ ᐊᔨᐦᑐᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ᐄᔥᐱᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᒡ ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐅᐦᑎᐦᐄᐹᓂᐦᒡ, ᒌᔒᐦᒋᒫᐅᒡ ᒑ ᒌᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᓃᔓ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌᐦ ᑖᐤ ᒌᓴᔅ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ, ᐄᔥᐱᐦ ᐱᔮᐦᑎᐙᒡ ᑖᓐ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ᐋᒄ ᐋᑖᒡ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ, “ᐋᒄ ᒫᒃ ᑎᔮᑆᐦᑐᐎᒋᐦᑦ, ᓃᔮᓐ ᐙᒌᐦᒡ ᐋ ᒌ ᐹᐦᑎᐎᒋᐦᑦ, ᓂᒧᐃ ᒥᒄ ᒌᔨ ᐋ ᒌ ᐃᔨᓐ᙮ ᐋᒄ ᒫᒃ ᒋᔮᔥᑎᓈᑖᔨᐦᑎᒫᐦᒡ ᐐᔨ ᐋᐦᐋᐎᑦ ᒑ ᒌ ᐱᒫᒋᐦᐋᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ᐄᔥᐱᐦ ᒫᒃ ᓃᔓ ᒌᔑᑳᐤᐦ ᑳᐦ ᑖᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ, ᐋᒄ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ᐙᔥ ᐐᔨ ᐙᒋᐦᒡ ᒌ ᐃᔨᒑ ᒌᓴᔅ, “ᑖᐱ ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑎᑯᔑᐦᒃ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᑳ ᐐᒋᒡ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐋ ᐙᐱᒫᒡ᙮ ᑭᔮᐦ ᐐᔨᐙᐤ ᒌ ᐄᑐᐦᑖᑖᐙᑯᐱᓐ ᒋᕉᓯᓕᒥᐦᒡ ᒫᒀᒡ ᑳ ᐅᑎᐦᒋᐱᔨᒡ ᐋᔑᑯᒻ ᐱᐳᓐ ᑳ ᒌ ᒥᔥᑎᐦ ᒥᑯᔖᓂᐎᔨᒡ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᐙᐱᐦᑎᒸᐅᒡ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ᐋᒄ ᒦᓐ ᑳᐤ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑳᓈ ᐃᐦᑖᐎᓐ ᑳᓕᓖᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᐊᓂᑖᐦ ᑳᐦ ᑐᑎᐦᒃ ᓂᐲᔨᐤ ᒑ ᒌ ᔔᒥᓈᐴᐎᔨᒡ᙮ ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᓈᐹᐤ ᐋ ᐅᒋᒫᐅᑦ᙮ ᐊᓐ ᐅᒋᒫᐤ ᒌᐦ ᑖᔨᐤ ᐅᑯᓯᔅᐦ, ᐋᐦ ᐋᐦᑯᓰᔨᒡ, ᐊᓂᑖᐦ ᒫᒃ ᑳᐱᕐᓈᔪᒻ ᐃᐦᑖᐎᓂᐦᒡ ᒌᐦ ᑖᔨᐤ ᒫᒀᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒃ ᐊᓐ ᐅᒋᒫᐤ ᐋ ᒌ ᑎᑯᔑᓃᔨᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ, ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ, ᒌ ᓂᑎᐙᐱᒫᐤ ᐋᒄ ᑳᐦ ᐋᔨᐦᑭᒥᒫᑦ ᒑ ᒌ ᐄᑐᐦᑖᔨᒡ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔨᒥᐦᒡ, ᒑ ᒌ ᓂᑑᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ, ᐙᔥ ᔖᔥ ᒑᑳᑦ ᓂᒧᐃ ᐅᐦᒋ ᐱᒫᑎᓰᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᐐᐦ ᑖᑆᐦᑐᓈᐙᐤ ᐹᑎᔥ ᐙᐱᒥᔮᒀ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᐋ ᐙᐱᐦᑎᔨᐙᔮᓐ ᑭᔮᐦ ᐋᐦ ᑐᑎᒫᓐ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᐦᒡ ᒑᒀᓂᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒋᒫᐤ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐋᔥᑎᒻ ᒫᐦ ᐹᒋ ᐄᑐᐦᑖ ᓂᐙᔅᑳᐦᐄᑭᓂᒥᐦᒡ ᐋᒸᔮ ᐴᓂᐱᒫᑎᓰᑦ ᓂᑯᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᒫᒌᐦ ᒌᐙ, ᒋᑭ ᐱᒫᑎᓰᐤ ᐙᔥ ᒋᑯᓯᔅ᙮” ᒌ ᑖᑆᐦᑎᒻ ᒫᒃ ᑖᓐ ᑳ ᐄᑖᑭᓅᑦ ᐊᓐ ᐅᒋᒫᐤ, ᐋᒄ ᑳ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ᒫᒀᒡ ᒫᒃ ᐋ ᐃᔥᐱᔑᔨᑦ ᐋ ᒌᐙᑦ, ᒌ ᓂᒋᐦᐄᑰ ᐊᓂᔮᔨᐤᐦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᔖᔥ ᒥᔪ ᐱᒫᑎᓰᐤ ᒋᑯᓯᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ᐋᒄ ᐊᓐ ᐅᒋᒫᐤ ᑳ ᑯᒀᒋᐦᒑᔨᒧᑦ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᒌᔑᑳᔨᒡ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒥᔪ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ᙮ ᐋᒄ ᐋᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᐱᒋᐦᐋᑭᓐ, “ᐅᑖᑯᔒᐦᒡ, ᑳ ᐃᔥᒀᐱᐦᑖᒌᔒᑳᔨᒡ ᐹᔨᒄ ᑳ ᐄᔅᐱᔨᒡ, ᐋᑯᑖᐦ ᑳ ᐊᐦᐊᔅᑎᐙᔥᑯᑖᐅᒋᐱᔨᑦ ᐋ ᒋᔑᑖᐅᐱᔨᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ᐋᒄ ᐊᓐ ᐅᐦᑖᐐᒫᐤ ᑳ ᒋᔥᒋᓯᑦ ᐋᑎ ᓂᐦᐋᐤ ᐋ ᒌ ᐃᔥᐱᔥ ᒌᔑᑳᔨᒡ ᑳᐦ ᐄᑎᑯᑦ ᒌᓴᔅᐦ, “ᒋᑭ ᐱᒫᑎᓰᐤ ᐙᔥ ᒋᑯᓯᔅ᙮” ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᑖᑆᐦᑎᐦᒃ ᑭᔮᐦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᑖᑆᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ᐋᐅᒄ ᒫᒃ ᐅᔮᔨᐤ ᓃᔣ ᑳ ᒫᒥᔥᑳᒡ ᐃᐦᑎᒃ ᒌᓴᔅ ᐋ ᑎᑯᔑᐦᒃ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ, ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ᒌ ᐅᑎᐦᒋᐱᔨᐤ ᒑᒃ ᐊᓂᑎᐦ ᑳ ᒌ ᒥᑯᔖᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐹᑎᒫ ᒫᒃ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ᐊᓂᑖᐦ ᒫᒃ ᒋᕉᓯᓕᒥᐦᒡ ᒌᐦ ᑎᑯᓐ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᒫᓂᔥᒑᓂᔥᐃᔥᒀᐦᑖᒻ ᐋ ᐃᔑᓂᐦᑳᑖᒡ ᐹᔓᒡ ᒫᒃ ᐊᓂᑎᐦ ᒌ ᑎᑯᓐ ᐋ ᐱᑳᔑᒧᓈᓂᐎᒡ, ᐹᕠᔅᑖ ᒌ ᐃᔑᓂᐦᑳᑖᐤ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᓈᓂᐎᒡ᙮ ᓂᔮᔪ ᒌ ᑎᐦᑎᓐ ᐲᐦᑐᔅᒀᐤ ᐋᐦᑎᑯᐦᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᑳᐦ ᐋᐦᑯᓯᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᐲᐦᑐᔅᒀᒡ ᑳ ᐱᒥᔑᐦᒡ, ᐊᓂᒌ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ, ᐊᓂᒌ ᐋᑳ ᑳ ᒌ ᐱᒧᐦᑖᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᓂᔅᑑᓯᒡ ᐐᔮᐙᐦᒡ, ᐋ ᐊᔑᓂᐙᑖᐦᒡ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ ᒑ ᐃᔥᐱᔥ ᐋᐦᑖᑭᒥᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ᐙᔥ ᒋᔖᒥᓂᑑ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᐅᑖᓐᒋᓂᒻᐦ ᒑ ᒌ ᐃᔮᑖᑭᒥᐦᐄᒥᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ᙮ ᐅᔮᔨᐤ ᒫᒃ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ, ᐊᓐ ᐊᐙᓐ ᑖᓐ ᒥᒄ ᐋᐦ ᐄᑖᔅᐱᓈᒀ ᓃᔥᑎᒻ ᐋ ᐱᑭᔥᑐᐙᐦᑖᑦ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ᒌᐦ ᑖᐤ ᒫᒃ ᓈᐹᐤ ᓂᔥᑐᒥᑎᓂᐤ ᓂᔮᓈᓈᐅᔖᑉ ᑎᐦᑐ ᐱᐳᓐ ᐋ ᒌ ᐃᔥᐱᔥ ᐋᐦᑯᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ᐄᔥᐱᐦ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐊᓂᑎᐦ ᐋ ᐱᒥᔑᓃᔨᒡ, ᒌ ᒋᔅᒑᔨᒫᐤ ᔖᔥ ᐙᔥᑭᒡ ᐋ ᒌ ᐋᐦᑯᓰᔨᒡ, ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᐋᐦ ᐄᑖᑦ, “ᒋᐐᐦ ᒦᓂᐙᒋᐦᐄᑯᓰᓐ ᐋ?” ");
INSERT INTO crl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ᐋᒄ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐋᑎᑯᑦ, “ᓂᒧᐃ ᑖᐤ ᐊᐙᓐ ᒑ ᒌ ᐹᒋ ᐄᑐᐦᑎᐦᐄᑦ ᐊᓂᑖᐦ ᒫᒀᒡ ᐋᐦ ᐋᐦᑖᑭᒥᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ᙮ ᒫᒀᒡ ᐋ ᐃᔥᐱᔒᐦᑳᓱᔮᓐ ᐊᓂᑖᐦ ᐋ ᐐᐦ ᐄᑐᐦᑖᔮᓐ ᔖᔥ ᑖᐤ ᒫᓐ ᐊᐙᓐ ᐋ ᐹᒋ ᐋᑎᔅᑭᐎᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᐱᓯᑰᐦ, ᐅᑎᓐ ᒋᑎᔥᐱᔑᒧᓐᔅ ᒑ ᐱᒧᐦᑖᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᒦᓂᐙᑎᓰᐤ ᐊᓐ ᓈᐹᐤ᙮ ᒌ ᐅᑎᓂᒻ ᐅᑎᔥᐱᔑᒧᓐᔅ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ᒌ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᐤ ᒫᒃ ᐆ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐋᑖᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ, “ᐊᔨᒥᐦᐋᐅᒌᔑᑳᐤ ᐊᓅᐦᒡ, ᐄᑎᔥᑖᐤ ᐐᔓᐙᐎᓂᐦᒡ ᒑ ᐋᐦᐋᑳ ᒌ ᑎᐦᑯᓂᒥᓐ ᒋᑎᔥᐱᔑᒧᓐᔅ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ᐋᒄ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐄᒫᑭᓅᐎᒡ ᐋᑎᑯᒡ, “ᐊᓐ ᐊᐙᓐ ᑳ ᐹᒋ ᒦᓂᐙᒋᐦᐄᑦ, ᐋᐅᒄ ᐊᓐ ᑳ ᐹᒋ ᐄᔑᑦ, ᐅᑎᓐᐦ ᒋᑎᔥᐱᔑᒧᓐᔅ ᑭᔮᐦ ᐱᒧᐦᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᐦ ᐄᑖᒡ, “ᒑᒄ ᓈᐹᐤ ᐆ ᑳ ᐄᑎᔅᒃ ᒑ ᒌ ᐅᑎᓂᒧᑦ ᒋᑎᔥᐱᔑᒧᐎᓂᓰᔨᐤ ᑭᔮᐦ ᒑ ᒌ ᐱᒧᐦᑖᐅᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐤ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᒦᓂᐙᒋᐦᐄᑯᑦ ᐙᔥ ᔖᔥ ᒌ ᒋᔅᑐᐦᑖᔨᐤ ᒌᓴᔅᐦ ᐙᔥ ᐋ ᒌ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ᐹᑎᒫ ᒫᒃ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌᓴᔅ ᒌ ᒥᔥᑯᐙᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐋᑦ ᐋᒄ ᐋᑖᑦ ᒫᒃ, “ᓂᑑᐦᑎᐦ, ᔖᔥ ᒌ ᒦᓂᐙᑎᓰᓐ᙮ ᐊᑳᐐ ᒦᓐ ᒥᒋᑑᑦ, ᐋᑳ ᓈᑎᐙᔨᐦᑎᒨᓈ ᐊᐅᔅᑖ ᐋ ᒫᔮᑎᐦᒡ ᒑᒀᓐ ᒑ ᒌ ᐃᔥᐱᔨᐦᐄᑯᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᒌ ᒋᔅᑐᐦᑖᐤ ᐋ ᓂᑑᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒌᓴᔅᐦ ᐋ ᒌ ᒦᓂᐙᒋᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᐦᒋᐱᔨᔨᒡ ᐋ ᐐᒥᒥᒋᐲᐦᐋᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ᒥᒄ ᒫᒃ ᑳᐦ ᐄᑎᑯᒡ ᒌᓴᔅᐦ, “ᓅᐦᑖᐐ ᒨᔥ ᐋᐱᑎᓰᐤ, ᑭᔮᐦ ᓃᔨ ᐋᐅᒄ ᒑ ᑎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐊᑎᑎᐤ ᒌ ᓂᑎᐙᔨᒫᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᓴᔅ, ᐃᔥᐱᔥ ᑳᐦ ᐹᐦᑑᐙᒡ ᐊᓂᔮᔨᐤ ᑳᐦᐄᒡ᙮ ᐙᔥ ᓂᒧᐃ ᒋᔅᑖᔨᐦᑎᒻ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᐋᒄ ᒦᓐ ᑳᐦ ᐃᔨᑦ ᒋᔖᒥᓂᑑ ᐋ ᐅᐦᑖᐐᑦ᙮ ᑭᔮᐦ ᒧᔮᒻ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐋᐦ ᐄᑖᒋᒦᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐅᑯᓯᓯᒫᐤ ᓂᒧᐃ ᒥᒄ ᐐᔨ ᑎᐱᔨᐙ ᒋᑭ ᒌᐦ ᑐᑎᒻ ᒑᒀᔨᐤ᙮ ᐅᐦᑖᐐᒫᐤ ᐋ ᐃᔑᓂᐙᑦ ᒑᒀᔨᐤ ᐋ ᐄᔨᐦᑎᔨᒡ ᑭᔮᐦ ᐐᔨ ᐋᔪᐎᒄ ᐋᑎ ᐃᐦᑎᒃ᙮ ᒥᒄ ᑖᓐ ᐋ ᐄᔨᐦᑎᔨᒡ ᐅᐦᑖᐐᒫᐤ ᐋᔪᐎᒄ ᐋᐦᑎᒃ ᑭᔮᐦ ᐐᔨ ᐅᑯᓯᓯᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ᐙᔥ ᐅᐦᑖᐐᒫᐤ ᓵᒋᐦᐋᐤ ᐅᑯᓯᓯᒫᐤ ᑭᔮᐦ ᐙᐱᐦᑎᔮᐤ ᒥᓯᐙ ᑖᓐ ᐋᐦᑎᒃ᙮ ᒋᑭ ᐐᒋᐦᐋᐤ ᐊᑎᑎᐤ ᒑ ᒌ ᒫᒥᔥᑳᒡ ᐋᐦ ᑎᔨᒡ᙮ ᐋᒄ ᒫᒃ ᒑ ᒫᒥᔥᑳᑖᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ᐅᐦᑖᐐᒫᐤ ᐎᓂᔥᑳᓈᐤ ᐊᐙᔨᐤᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᐋᒄ ᒫᒃ ᒫᔮᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᐋᐅᒄ ᑭᔮᐦ ᓂᐦᐋᐤ ᐋᐦᑎᒃ ᐅᑯᓯᓯᒫᐤ, ᒥᔮᐤ ᐊᐙᔨᐤᐦ ᐱᒫᑎᓰᐎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐙᐦ ᒥᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ᐅᐦᑖᐐᒫᐤ ᓂᒧᐃ ᑎᐹᔅᑯᓈᐤ ᐊᐙᔨᐤᐦ᙮ ᐐᔨ ᒥᑐᓐ ᒌ ᒥᔮᐤ ᐅᑯᓯᓯᒫᐤ ᒑ ᒌ ᑎᐹᔅᑯᓂᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒋᔥᑖᔨᒫᑦ ᐅᑯᓯᓯᒫᐤ ᒧᔮᒻ ᐋ ᐄᔑ ᒋᔥᑖᔨᒫᑦ ᐅᐦᑖᐐᒫᐤ᙮ ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᒋᔥᑖᔨᒫᑦ ᐅᑯᓯᓯᒫᐤ ᓂᒧᐃ ᒋᔥᑖᔨᒫᐤ ᑭᔮᐦ ᐅᐦᑖᐐᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᒑ ᐹᒋ ᓂᑑᐦᑎᒧᒀ ᑖᓐ ᐋᐦ ᐃᔨᐅᒡ ᑭᔮᐦ ᑖᑆᐦᑎᐙᒑ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ ᑳᒋᒡ ᑭᑎ ᐱᒫᑎᓰᐤ᙮ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑭᓂᐤ ᐙᔥ ᓂᐱᐎᓂᐦᒡ ᒌ ᐅᐦᒋ ᐅᑎᓈᑭᓂᐤ ᐋᒄ ᐱᒫᑎᓰᐎᓂᐦᒡ ᑳ ᐄᔑ ᐱᒋᔅᑎᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᔖᔥ ᐋ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐊᓐ ᐋᐦᒋᓂᒀᓂᐦᑖᑦ ᐆ ᒑ ᐄᔅᐱᔨᒡ, ᔖᔥ ᒫᒃ ᐄᔅᐱᔨᐤ, ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑭᑎ ᐹᐦᑎᒸᐅᒡ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔨᐤᐦ ᐅᐹᐦᑖᑯᓯᐎᓂᔨᐤ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᐹᐦᑎᐙᒡ ᑭᑎ ᐱᒫᑎᓰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ᐙᔥ ᐐᔨ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ ᐱᒫᑎᓰᐎᓐ, ᒥᔮᐤ ᒫᒃ ᐅᑯᓯᓯᒫᐤ ᑭᔮᐦ ᐐᔨ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐅᐦᒋᐱᔨᔨᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ᒌ ᒥᔮᐤ ᑭᔮᐦ ᐅᑯᓯᓯᒫᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒑ ᒌ ᑎᐹᔅᑯᓂᒑᔨᒡ ᐙᔥ ᐐᔨ ᐋᐅᒄ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ᐊᑳᐐ ᑯᔥᒀᔨᑎᒧᒄ, ᐙᔥ ᔖᔥ ᐹᔓᓈᑯᓐ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᓂᐦᐄᑭᐙᑭᓂᐎᒡ ᒑ ᒌ ᐹᐦᑎᒸᒡ ᐅᑯᓯᓯᒫᐤ ᐅᐹᐦᑖᑯᓯᐎᓂᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ᐋᒄ ᒫᒃ ᒑ ᐎᓂᔥᑳᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᒄ ᐊᓂᒌ ᑯᐃᔅᒄ ᑳ ᑐᑖᒑᒡ ᑳᒋᒡ ᑭᑎ ᐱᒫᑎᓰᐎᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑳ ᒥᒑᑎᓯᒡ ᒋᑭ ᐎᓂᔥᑳᓈᑭᓂᐎᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᒑ ᒌ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ ᓂᓲᓈᑎᓯᐎᓂᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ᓃᔨ ᒫᒃ, ᑖᐹ ᓂᒌᐦ ᑐᑖᓐ ᒑᒀᓐ ᒥᒄ ᓃᔨ ᐋ ᐹᔨᑯᐦᑭᒫᓐ᙮ ᓂᑎᐹᔅᑯᓂᒑᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᑰᔮᓐ, ᑯᐃᔅᑯᓈᑯᓐ, ᐙᔥ ᑖᐹ ᓃᔨ ᓂᐐ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᓲᓐ, ᒥᒄ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᐋᐅᒄ ᐊᓐ ᐙᓂᐦᐋᔨᐦᑎᒥᐦᐄᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“ᓃᔨ ᒫᒃ ᒥᒄ ᑎᐹᒋᒥᓱᔮᓐ ᐋ ᐃᔮᓐ ᐋᐦ ᐋᐎᔮᓐ ᙭ ᓂᒧᐃ ᓂᐱᐦ ᐅᐦᒋ ᑖᑆᐦᑖᑭᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ᑯᑎᒃ ᐊᐙᓐ ᑖᐤ ᐋ ᐹᒋ ᑎᐹᒋᒥᑦ ᐋᐦ ᐃᔨᑦ ᐋᐦ ᐋᐅᐎᒡ ᙭, ᓂᒋᔅᒑᔨᐦᑖᓐ ᒫᒃ ᐋ ᑖᑆᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᒋᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ᒋᒌ ᐄᑎᔑᐦᐙᐙᐅᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒞᓐ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᓂᑑᒋᔅᒑᔨᒥᒡ ᑖᑆᐦ ᐃᔮᐙᐅᒑ ᙭᙮ ᒌ ᑖᑆᐤ ᒫᒃ ᐊᓂᔮ ᑳ ᐄᔑ ᑎᐹᒋᒥᑦ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ᓂᒧᐃ ᓂᑎᐙᐄᐦᑖᑯᓐ ᒑ ᒌ ᐹᒋ ᐐᐦᑎᒨᑦ ᐊᐙᓐ ᓃᔨ ᐋᐦ ᐋᐎᔮᓐ ᙭, ᐙᔥ ᓂᒋᔅᒑᔨᒦᓱᓐ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ᙮ ᒥᒄ ᐋᐅᒄ ᐆ ᐙᐦᒋ ᐙᐐᐦᑎᒫᓐ ᒑ ᒌ ᐱᒫᒋᐦᐅᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ᒧᔮᒻ ᐙᔥᑖᓂᒫᑭᓐ ᐋ ᒌᐦᑳᔮᔥᑖᒡ ᐋᐅᒄ ᑳ ᐃᓯᓈᑯᓯᑦ ᒞᓐ ᑳ ᑎᐹᒋᒥᑦ᙮ ᒋᒌ ᓂᐦᐋᔨᐦᑖᓈᐙᐤ ᒥᒄ ᐙᐃᐱᔥᒌᔥ ᒑ ᒌ ᒨᒋᒑᔨᐦᑎᒫᒄ ᐊᓂᑖᐦ ᐅᐙᔥᑖᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ᒌ ᑖᑆᐤ ᒞᓐ ᐊᓂᔮ ᑳ ᐄᑖᒋᒥᑦ, ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐙᒋᐦᒡ ᐋᐱᑎᓰᐎᓂᔨᐤ ᑳ ᓂᑎᐙᔨᒥᑦ ᐅᐦᑖᐐᒫᐤ ᒑ ᒌᐦᔅᑐᑎᒨᒡ, ᐋᔪᐎᑯᓐ ᐹᒦᐦᑭᒨᒡ, ᐋᑯᑎᐦ ᐙᐦᒋ ᓅᑯᐦᒡ ᑖᑆᐦ ᑖᑆᐎᓐ ᐐᐦ ᓅᐦᑖᐐ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ᐅᐦᑖᐐᒫᐤ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᑭᔮᐦ ᐐᔨ ᓂ ᐹᒋ ᑎᐹᒋᒥᒄ᙮ ᓂᒧᐃ ᒫᒃ ᓂᐦᑖ ᑰᐦᒋ ᐹᐦᑎᒸᓈᐙᐤ ᐅᐹᐦᑖᑯᓯᐎᓐ ᑭᔮᐦ ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᐙᐱᒫᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ᐊᓂᔮᔨᐤ ᐅᑎᔨᒧᐎᓐ ᓂᒧᐃ ᒋᐐᐦ ᑭᓂᐙᔨᐦᑎᒸᓈᐙᐤ ᒋᑖᐦᐄᐙᐦᒡ ᐙᔥ ᓂᒧᐃ ᒋᑖᑆᐦᑖᓈᐙᐤ ᐐᔨ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ᔮᒀᐦ ᒌ ᓈᓂᑐᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐋᑎᔅᑖᔨᒡ ᒋᐦᒋᒥᓯᓈᐦᐄᑭᓂᐦᒡ ᐋ ᐄᑖᔨᐦᑎᒫᒄ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᒄ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔮᒄ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ, ᐋᑯᑖᐦ ᒥᓯᓈᑖᒡ ᐋ ᑖᐹᒋᒥᑭᐎᔮᓐ ᒋᐦᒋᒥᓯᓈᐦᐄᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ᐊᔮᐱᒡ ᒫᒃ ᓂᒥ ᒋᐐᐹᒋᓈᓯᓈᐙᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔮᒄ ᐱᒫᑎᓰᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ᓂᒧᐃ ᓂᑎᐦᑐᑖᓐ ᒑᒀᓐ ᓈᐹᐤ ᒑ ᒌ ᐅᐦᒋ ᐹᒋ ᒫᒥᐦᒋᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ᐙᔥ ᒋᒋᔅᒑᔨᒥᑎᓈᐙᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ᙮ ᓂᒧᐃ ᒋᓵᒋᐦᐋᐙᐤ ᒋᔖᒥᓂᑑ ᐊᓂᑖᐦ ᒋᑖᐦᐄᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ᓂᒌᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᓅᐦᑖᐐ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᒋᐐᐅᑎᓂᓈᐙᐤ᙮ ᑯᑎᒃ ᐊᐙᓐ ᒌ ᑎᑯᔑᐦᒃ ᐋᐦᐋᑳ ᒋᔖᒥᓂᑑ ᐅᐦᒋ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᒋᐱᐦ ᐅᑎᓈᐙᐤ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᐦᑎᒫᒄ ᒥᒄ ᓈᐹᐤ ᐋ ᒋᔅᑖᒋᒥᑖᒄ, ᐋᐦᐋᑳ ᐐ ᒫᒋᒽ ᐐᐦᐱᑰᐦᑖᔮᒄ ᒋᔅᑖᒋᒥᑯᓰᐅᓐ ᐋᓐ ᒥᒄ ᐋ ᐹᔨᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐋ ᐅᐦᒋᐱᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ᐊᑳᐐ ᐄᑖᔨᐦᑎᒧᒄ ᒑ ᒫᒥᔑᒥᑎᑯᒡ ᐊᓂᑖᐦ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ᙮ ᒧᓱᔅ ᐋᐅᒄ ᒑ ᒫᒥᔑᒥᑖᒄ ᐋ ᐄᑖᔨᐦᑎᒫᒄ ᑰᐃᔅᒄ ᐋᐃᐦᑎᔮᒄ ᐋ ᓂᓂᐦᐄᐦᑖᒸᒄ ᐊᓂᔮᔨᐤ ᐅᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ᑖᑆᐦ ᑎᔮᑆᐦᑎᐙᐙᒀ ᒧᓱᔅ, ᓃᔨ ᒋᐱᐦ ᐹᒋ ᑖᑆᐦᑑᓈᐙᐤ ᐙᔥ ᐊᓂᔮᔨᐤ ᓃᔨ ᓂᒌ ᐹᒋ ᑎᐹᒋᒥᒄ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳ ᒥᓯᓂᐦᐄᒑᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ᐋᒄ ᒫᒃ ᐋᑳ ᑎᔮᑆᐦᑎᒧᐙᒀ ᐊᓂᔮᔨᐤ ᒧᓱᔅ ᑳ ᐄᑎᓯᓂᐦᐄᒑᑦ, ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᐦᑎᒫᒄ ᓃᔨ ᓂᑎᔨᒧᐎᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ᐹᑎᒫ ᒌᓴᔅ ᒌ ᒋᔅᑳᒧᐦᐊᒨᒡ ᐊᓂᔮᔨᐤ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓂᔨᐤ᙮ ᑖᐃᐲᕆᔨᔅ ᓵᑭᐦᐄᑭᓐ ᑭᔮᐦ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ ᐆ ᑳᓕᓖ ᓵᑭᐦᐄᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐊᐙᔨᐤᐦ ᑳ ᓈᓅᔔᔥᑳᑯᑦ ᐙᔥ ᔖᔥ ᒌ ᐙᐱᒥᑰ ᐋ ᒫᒥᔥᑳᒡ ᐋ ᐃᐦᑎᒃ ᐋ ᒦᓂᐙᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐋᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ᒌᓴᔅ ᒫᒃ ᒌ ᔖᑭᒍᐙᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐅᐙᔨᐱᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋ ᐐᑎᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ᔖᔥ ᒌ ᐹᔓᓈᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᒥᑯᔖᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ᒌᓴᔅ ᒫᒃ ᒌ ᐊᔨᑖᐱᐤ ᑳ ᐙᐱᒫᑦ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᐋ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᑎᓂᐦᒃ ᐋᐃᐦᑯᓈᐤ ᒥᓯᐙ ᒑ ᒌ ᐊᔑᒥᑯᒡ ᐅᒌ ᐄᔨᔨᐅᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑯᒀᒋᒫᑦ ᕕᓕᑉ ᒥᒄ ᐋ ᒌ ᐐ ᓂᑐᒋᔅᒑᔨᒫᑦ ᑖᓐ ᒑ ᐃᔨᒀᓂᐦᐄ ᐋᑎ ᔖᔥ ᐋ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ ᒌᓴᔅ ᑖᓐ ᒑ ᑎᒃ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ᐋᒄ ᐋᑎᑯᑦ ᕕᓕᑉ, “ᐋᑦ ᒥᒄ ᐊᐱᔒᔥ ᐊᔑᒥᐦᒄ ᐹᐦᐹᔨᒄ ᐊᐙᓐ, ᐊᔮᐱᒡ ᒥᔥᑏᐦ ᔓᐎᔮᓐ ᒋᐱᐦ ᐄᔅᐱᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐅᑎᓂᒑᓅᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ᐋᒄ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᓐᑎᕉ, ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᐐᒋᐄᔨᔨᐤ ᒌ ᐄᑎᑰ, ");
INSERT INTO crl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ᑖᐤ ᐅᑎᐦ ᓈᐹᔥ ᓂᔮᔪ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᓃᔓ ᓂᒫᔅ ᐋ ᐃᔮᐙᑦ᙮ ᓂᒧᐃ ᒫᒃ ᑭᑎ ᐄᔅᐱᔨᐤ ᐆ ᒦᒋᒻ ᐋᐦ ᐄᔥᐱᐦ ᒥᐦᒑᑎᐦᒡ ᐅᒌ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ᐋᒄ ᒌᓴᔅ ᐃᔮᑦ, “ᐄᑖᐦᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐅᐙᔨᐱᒡ᙮” ᓈᔥᒡ ᒌ ᒥᔅᑭᐎᓰᔨᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᒡ᙮ ᐋᒄ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐅᐙᔨᐱᒡ, ᐎᔮᔥ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᐄᑎᔓᒡ ᓈᐹᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ᐋᒄ ᒌᓴᔅ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ ᑳᐦ ᐋᑎ ᒫᒫᑎᓂᒧᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳᐦ ᐋᑎ ᒫᑎᓄᐙᔨᒡ᙮ ᐋᐅᒄ ᑳᐦ ᑐᑎᐙᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᒫᔅ᙮ ᒥᓯᐙ ᒫᒃ ᒥᒄ ᐙᐦ ᐃᔥᐱᔥ ᒦᒋᓱᒡ ᒌ ᐃᔥᐱᔥ ᒦᒋᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᐱᔥᑯᔨᑦ, ᐋᒄ ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒫᒨᔑᒋᓂᒧᒄ ᒥᓯᐙ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᐄᔅᑯᐱᔨᒡ ᒦᒋᒻ, ᐊᑳᐐ ᒥᑐᓐ ᐃᔮᔪᐦᑖᑖᐤ ᒑᒀᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ᐋᒄ ᑭᔨᑆ ᑳ ᒫᒨᔑᒋᓈᔨᒡ, ᓃᔓᔖᑉ ᒫᒃ ᐅᑎᐲᐎᑦ ᒌ ᓵᑭᔅᒋᓂᑖᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᑯᐱᔨᒡ ᐃᔥᐱᔥ ᑳ ᒌᔥ ᒥᒋᓲᔨᒡ ᐄᔨᔨᐤ, ᐋ ᒌ ᐹᐦᐱᒀᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓃᔮᔪ ᐋᐃᐦᑯᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ, ᐊᓂᒌ ᑳ ᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᒫᒥᔅᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᐋᐦ ᑐᑎᒥᔨᒡ ᐋᒄ ᐃᔮᒡ, “ᒑᔥᑎᓈᔥ ᐋᐅᒄ ᐆ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐊᓐ ᑳ ᐊᔓᐙᐱᒥᐦᒄ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ ᐋᔨᐦᒄ ᒑ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ ᐋᔨᐦᑭᒻ ᒑ ᐐᐦ ᒋᐦᒋᐅᒋᒫᐅᐦᐄᑯᑦ, ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᑳ ᐄᑐᐦᑖᑦ, ᒥᒄ ᐐᔨ ᒑ ᒌ ᐹᔨᑯᔑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ᐄᔥᐱᐦ ᒫᒃ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᓈᓯᐹᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ᒌ ᐴᓯᐎᒡ ᒌᒫᓂᔨᐤ ᐋ ᒌ ᐐᐦ ᑎᔅᑳᒥᐦᐊᒡ, ᓈᑖᐦ ᑳᐱᕐᓈᔪᒻ ᐋ ᒌ ᐐᐦ ᐃᔅᒋᒫᐅᒡ᙮ ᔖᔥ ᒫᒃ ᒌ ᐋᑎ ᐊᐅᑳᔨᐤ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᓃᒋᐦᐄᑯᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ᒑᒃ ᓈᔥᒡ ᒌ ᔫᑎᓂᔨᐤ ᑭᔮᐦ ᒌ ᒫᒥᐦᑳᐦᐋᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ᓂᔥᑐ ᑭᔮᐦ ᒫᒃ ᓈᐤ ᑎᐦᑐ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ ᒌ ᐃᔥᐱᔥ ᐱᒥᔅᑳᒑᓂᒌ ᐋᒄ ᑳ ᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ᒌ ᐹᒋ ᓈᑎᑯᒡ ᐊᓂᑖᐦ ᒌᒫᓂᒡ ᐋᐦ ᑖᒡ ᓂᐲᐦᒡ ᐋ ᐱᒧᐦᑖᔨᒡ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᑯᔥᑖᒎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ᒥᒄ ᒫᒃ ᐋᑎᑯᒡ ᒌᓴᔅᐦ, “ᐊᑳᐐ ᑯᔥᑖᒋᒄ, ᐋᐅᒄ ᐙᔥ ᐆ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ᐋᒄ ᒫᒃ ᑳ ᓈᐦᐋᔨᒫᒡ ᒑ ᒌ ᐴᓯᑖᑯᒡ᙮ ᑏᐙᐦᒡ ᔖᔥ ᒌ ᒥᔑᑳᐅᒡ ᓈᑖᐦ ᑳ ᐃᔅᒋᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ᒦᓐ ᐎᔮᐱᓃᔨᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐋᔥᒄ ᒌᐦ ᑖᐅᒡ ᐊᓂᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ ᐊᓂᑖᐦ ᒌᓴᔅ ᑳ ᐊᔑᒫᑦ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ᙮ ᒌ ᒋᔅᒎᒡ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒥᒄ ᐋ ᒌ ᐹᔨᑯᔒᔨᒡ ᒌᒫᓂᔨᐤ ᐋ ᒌ ᐋᐱᒋᐦᑖᔨᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑭᔮᐦ ᐋᐦᐋᑳ ᐅᐦᒋ ᐴᓰᔨᒡ ᒌᓴᔅᐦ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ᑯᑎᒃᐦ ᒫᒃ ᒋᒫᓐᐦ ᒌ ᐹᒋ ᓈᑎᑳᒫᐱᔨᐤ ᐊᓂᑖᐦ ᑖᐃᐲᕆᔨᔅ ᐋ ᐅᐦᒋᐱᔨᔨᒡ, ᐹᔓᒡ ᐊᓂᑎᐦ ᑳ ᐊᔑᒫᑭᓂᐎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᐃᔥᑯᑎᒃ ᒌᓴᔅ ᑳ ᓂᓈᔅᑯᒨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐙᐱᒫᐅᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤ ᒑ ᒌᐦ ᑖᔨᒡ ᐊᓂᑎᐦ, ᐋᒄ ᑳ ᐴᓯᒡ ᒋᒫᓐᐦ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᑳ ᐃᔅᒋᒫᒡ ᒑ ᓈᓂᑐᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ᐄᔥᐱᐦ ᒫᔅᑯᐙᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᒀᔅᑖ ᐄᑖᐦᒑᑳᒻ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ ᐋᒄ ᐋᑖᒡ, “ᒋᔅᑯᑎᒫᒑᓯᐤ ᑖᔨᔥᐱᔥ ᑳ ᑎᑯᔑᓃᔨᓐ ᐅᑎᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᐊᓐ ᐋ ᒌ ᐙᐱᒥᔮᒄ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᐋᐦ ᑐᑎᒫᓐ ᐙᐦᒋ ᐹᒋ ᓈᓂᑐᐙᐱᒥᔮᒄ᙮ ᐙᔥ ᒥᒄ ᐊᓐ ᐋ ᒌ ᒧᐙᒄ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᐋ ᒌ ᒌᔥᐳᔮᒄ ᐋᐅᒄ ᐙᐦᒋ ᓈᓂᑐᐙᐱᒥᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ᐊᑳᐐ ᐋᐱᑎᓰᒄ ᒥᒄ ᐋ ᐐᐦ ᐱᑯᐦᑎᒫᓲᔮᒄ ᒦᒋᒻ ᐊᓐ ᒑ ᐃᔮᔪᐦᒡ, ᑎᔨᑯᒡ ᐐᐦ ᐱᑯᐦᑎᒫᓲᒄ ᐊᓐ ᑳᒋᒡ ᒑ ᑎᑯᐦᒡ᙮ ᐄᔨᔨᐅᑯᓯᓵᓐ ᒋᑭ ᒥᔨᑯᐙᐤ ᒦᒋᒥᔨᐤ ᐋᑳ ᓂᐦᑖ ᒑ ᐃᔮᔪᓃᔨᒡ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᐦᑖᐐᒫᐤ ᒌ ᓅᑯᐦᑖᐤ ᑖᑆᐦ ᐋᐦᐋᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓂᐦᐋᔨᐦᑎᒦᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ᐋᒄ ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᒫᒃ ᒑ ᑎᔮᐦᒡ ᒑ ᒌ ᐋᐱᑎᔒᔥᑑᒋᐦᑦ ᒋᔖᒥᓂᑑ?” ");
INSERT INTO crl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐄᔑ ᐋᐱᑎᔒᔥᑑᐙᑭᓅᑦ, ᒑ ᒌ ᑖᑆᔮᔨᒥᒥᐦᒄ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ᐋᒄ ᐋᑖᒡ ᒌᓴᔅᐦ, “ᑖᓐ ᒑ ᒌ ᐄᔑ ᒫᒥᔅᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᒑ ᐊᔨᐦᑎᔨᓐ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᔮᔨᒥᑖᐦᒡ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ᐊᓂᑖᐦ ᐙᔥᑭᒡ ᓂᑖᓂᔅᑰᓯᒥᓈᓂᒡ ᒌ ᒧᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑳ ᒥᔮᑭᓂᐎᒡ ᒫᒀᒡ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑖᒡ᙮ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒌ ᒥᔮᑭᓂᐎᒡ ᐋᐃᐦᑯᓈᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᒧᓱᔅ ᑳ ᒥᔨᑖᒄ ᓂᒧᐃ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ ᐅᐦᒋᐱᔨᐤ᙮ ᒋᔖᒥᓂᑑ, ᓅᐦᑖᐐ ᐋᐅᒄ ᐊᓐ ᒫᔨᑖᒄ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐙ ᐋᐃᐦᑯᓈᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋᐱᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ᐙᔥ ᐊᓐ ᐋᐃᐦᑯᓈᐤ ᒋᔖᒥᓂᑑ ᑳ ᒥᔨᐙᑦ ᐋᐅᒄ ᐊᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋᐱᔨᑦ, ᑭᔮᐦ ᐋᐅᒄ ᒫᔮᑦ ᒥᔅᑖᔅᑭᒦᐦᒡ ᑳᐦ ᑖᔨᒡ ᐊᐙᔨᐤᐦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ᐋᒄ ᐋᑖᒡ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒨᔥ ᒫᐦ ᐹᒋ ᒥᔨᓈᓐ ᐊᓐ ᐋᐃᐦᑯᓈᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᓃᔨ ᐋᐅᒄ ᐊᓐ ᐋᐃᐦᑯᓈᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᑎᓰᑦ ᐊᐙᓐ᙮ ᐊᐙᓐ ᒫᒃ ᒑ ᐹᒋ ᓈᓯᒀ ᑭᔮᐦ ᒑ ᐹᒋ ᑖᑆᔮᔨᒥᒀ, ᓂᒧᐃ ᓂᐦᑖ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᔒᐅᑖᐤ ᑭᔮᐦ ᓂᒧᐃ ᓂᐦᑖ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᓅᐦᑖᔮᐹᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ᔖᔥ ᒫᒃ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ, ᔖᔥ ᒋᒌ ᐙᐱᒥᓈᐙᐤ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᑰᐦᒋ ᐐᐦ ᑖᑆᔮᔨᒥᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐅᐦᑖᐐᒫᐤ ᑳ ᐹᒋ ᒥᔨᑦ ᓂᑭ ᐹᒋ ᓈᑎᑯᒡ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᐹᒋ ᓈᓯᑦ ᓂᒧᐃ ᓂᐦᑖ ᓂᑭ ᐅᐦᒋ ᐄᒑᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ᐙᔥ ᓂᒌᑎᑯᔑᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒋ ᐹᒋ ᔮᓯᔮᓐ ᒑ ᒌᐦ ᑐᑎᒧᒡ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ, ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ᓂᒧᐃ ᓅᐦᒋ ᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒥᒄ ᓃᔨ ᓂᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᒑ ᒌᐦ ᑐᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᐋᑳ ᒑ ᒌ ᐎᓂᐦᐄᒥᒡ ᐙᐙᒡ ᐹᔨᒄ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᒥᔨᑦ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐎᓂᔥᑳᓂᒥᒡ ᒫᐦᒋᒡ ᒌᔑᑳᔨᒑ ᑳᒋᒡ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ᐙᔥ ᐋᐅᒄ ᐅᔮᔨᐤ ᓅᐦᑖᐐ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ, ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᑳ ᐙᐱᒫᔨᒡ ᑭᔮᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᐅᑯᓯᓯᒫᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᒑ ᐃᔮᔨᒡ᙮ ᓃᔨ ᒫᒃ ᒑ ᐎᓂᔥᑳᓂᒃ ᒫᐦᒋᒡ ᒌᔑᑳᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ᐄᔥᐱᐦ ᑳ ᒌᔥ ᐊᔨᒥᑦ ᒌᓴᔅ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐎᔮᔅ ᒌ ᐄᑖᔨᒫᐅᒡ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔨᔨᒡ, “ᓃᔨ ᐋᐅᒄ ᐊᓐ ᐋᐃᐦᑯᓈᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓈᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ᐋᒄ ᐃᔮᒡ ᒫᒃ, “ᓂᒥᔮᐤ ᐋ ᐆ ᒌᓴᔅ, ᒍᓯᕝ ᐅᑯᓯᔅᐦ? ᓂᒋᔅᒑᔨᒫᓈᓐ ᐅᐦᑖᐐᐦ ᑭᔮᐦ ᐅᑳᐐᐦ᙮ ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐃᔨᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒌᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐋᑯᓐ ᐋᒄ ᐃᔥᐱᔥ ᐳᑯᓅᒧᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ᓂᒧᐃ ᓂᑭ ᒌ ᐹᒋ ᓈᑎᒄ ᐊᐙᓐ ᐹᑎᔥ ᐅᐦᑖᐎᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ ᑐᑖᑯᒑ ᒑ ᒌ ᐹᒋ ᓈᓯᑦ᙮ ᒫᐦᒋᒡ ᒌᔑᑳᒑ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᒌ ᐹᒋ ᓈᓯᑦ ᓂᑭ ᐎᓂᔥᑳᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ᒫᐅᔮᔨᐤ ᑳ ᐄᑎᓯᓂᐦᐄᒑᐙᑯᐱᓈ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ, ᒋᔖᒥᓂᑑ ᒋᑭ ᒋᔅᑯᑎᒧᐙᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ᙮” ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᓃᐦᑐᑎᐙᒡ ᑭᔮᐦ ᑳ ᐅᑎᓂᒸᒡ ᐅᒋᔅᑯᑎᒫᒑᐊᐎᓂᔨᐤ ᐅᐦᑖᐐᒫᐤᐦ ᓂᑭ ᐹᒋ ᓈᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ᓂᒧᐃ ᐊᐙᓐ ᐅᐦᒋ ᐙᐱᒫᐤ ᐅᐦᑖᐐᒫᐤ ᒥᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐋᐅᒄ ᐊᓐ ᒥᒄ ᑳ ᐙᐱᒫᑦ ᐅᐦᑖᐐᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᑳ ᐹᒋ ᑖᑆᔮᔨᒥᑦ ᐃᔮᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ᓃᔨ ᐋᐅᒄ ᐋᐃᐦᑯᓈᐤ ᑳ ᒥᔨᐙᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ᐊᓂᑖᐦ ᐙᔥᑭᒡ ᒌ ᒋᑖᓂᔅᑰᓰᒥᐙᐅᒡ ᒌ ᒧᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᒫᓈ ᐋ ᒌ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ, ᒫᒀᒡ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑖᒡ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒌ ᓂᐱᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ᒥᒄ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᒑ ᒧᐙᒀ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓈᒫᑭᓂᐎᔨᒡ, ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ᐋᐅᒄ ᒫᒃ ᓃᔨ ᐊᓐ ᐱᒫᒋᐦᐄᐙᐤ ᐋᐃᐦᑯᓈᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓈᑭᓅᑦ᙮ ᐊᐙᓐ ᒫᒃ ᒑ ᒧᐙᒀ ᐅᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᒋᑭ ᐃᔮᐤ᙮ ᐊᓐ ᒫᒃ ᐋᐃᐦᑯᓈᐤ ᒑ ᒥᔨᐙᔮᓐ ᐋᐅᒄ ᐆ ᓂᔮᔅ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᒡ ᐄᔨᔨᐅᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮” ᐋᐅᒄ ᐅᔮᔨᐤ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᐅᔥᑖᐱᔫᒡ ᐋ ᐊᔨᒥᐦᐄᑑᒡ, ᐋᒄ ᐃᔮᒡ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒥᔨᐙᑦ ᐆ ᓈᐹᐤ ᐎᔮᔅ ᒑ ᒌ ᐅᐦᒋ ᒦᒋᓈᓂᐎᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓂᒧᐃ ᒋᑭ ᒌ ᐃᔮᓈᐙᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ ᐋᑳ ᒥᒋᐙᒀ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐎᔮᔅ ᑭᔮᐦ ᐋᑳ ᒥᓂᐦᒀᐙᒀ ᐅᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᒦᒋᒀ ᓂᔮᓯᔨᐤ ᑭᔮᐦ ᒑ ᒥᓂᐦᒀᒀ ᓂᒥᐦᑯᔨᐤ ᐃᔮᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᑭᔮᐦ ᒫᒃ ᓃᔨ ᓂᑭ ᐎᓂᔥᑳᓈᐤ ᒫᐦᒋᒡ ᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ᐙᔥ ᓂᔮᔅ ᐋᐅᒄ ᒋᐦᒋᐙ ᒦᒋᒻ ᑭᔮᐦ ᓂᒥᐦᒄ ᒋᐦᒋᐙ ᒥᓂᐦᒀᐅᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᒦᒋᒀ ᓂᔮᓯᔨᐤ ᑭᔮᐦ ᒑ ᒥᓂᐦᒀᒀ ᓂᒥᐦᑯᔨᐤ, ᓂᐲᐦᒋᔥᑳᒄ ᑭᔮᐦ ᓃᔨ ᓂᐲᐦᒋᔥᑭᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ᓅᐦᑖᐐ ᐊᓐ ᑳ ᒥᔨᐙᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ ᑭᔮᐦ ᓂᒥᔨᒄ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᒧᔮᒻ ᑭᔮᐦ ᐐᔨ ᐊᓐ ᐊᐙᓐ ᑳ ᒦᒋᑦ ᓂᔮᓯᔨᐤ, ᓂᑭ ᒥᔮᐤ ᒑ ᒌ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ᐋᐅᒄ ᐆ ᐋᐃᐦᑯᓈᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐱᒋᔅᑎᓈᑭᓅᑦ᙮ ᐊᐙᓐ ᒫᒃ ᒑ ᒧᐙᒀ ᐅᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑳᒋᒡ ᑭᑎ ᐱᒫᑎᓰᐤ᙮ ᓂᒥᔮᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐋᓂᔅᒑ ᒌ ᐙᐦᑯᒫᑭᓄᐙᐅᒡ ᑳ ᒧᐙᒡ ᐊᓂᑖᐦ ᐙᔥᑭᒡ, ᐋᑎ ᐋ ᒌ ᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐊᔮᐱᒡ ᒌ ᐴᓂᐱᒫᑎᓰᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ᐋᔨᐅᑯᓐᐦ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᑳᐦ ᐋᔨᒨᑎᐦᒃ ᒌᓴᔅ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᓂᑖᐦ ᑳᐱᕐᓈᔪᒻ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᐦᑖᑯᑦ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤ ᑳ ᓅᔔᔥᑳᑯᑦ ᐊᓂᔮᔨᐤ ᐋᐦ ᐃᔨᑦ, ᐋᒄ ᐃᔮᔨᒡ, “ᑖᑆᐦ ᐋᔨᒥᓂᔨᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓂᔅᒀᔮᔨᐦᑎᒦᒡ ᐒᔮ ᐅᒋᔅᑯᑎᒫᒑᐎᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ᒌᓴᔅ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐤ, ᐋᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᐐᐦᑎᒧᐙᑭᓅᑦ, ᑖᓐ ᐋᐦ ᐄᑎᑐᔨᒡ, ᒌᐦ ᐄᑖᐤ, “ᑰᔥᑎᐙᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᐋ ᐆ ᑳ ᐃᔮᓐ? ");
INSERT INTO crl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ᑖᓐ ᒫᒃ ᒑ ᐄᑖᔨᐦᑎᒫᒄ ᐙᐱᒫᒀ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᐅᐦᐱᔅᑳᑦ ᐊᓂᑖᐦ ᐄᔑ ᑳ ᒌ ᑖᑦ ᐋᒸᔮ ᐅᐦᒋ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ᒥᒄ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒥᔨᐙᐤ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᓂᒧᐃ ᐐ ᓈᐹᐤ ᒋᑭ ᒌᐦ ᑐᑎᒻ ᐅᔮᔨᐤ᙮ ᐋᓐ ᒫᒃ ᐋᔨᒨᐎᓐ ᑳ ᐐᐦᑎᒫᑎᑯᒡ ᐋᑯᑎᐦ ᐙᐦᒋᐱᔨᒡ ᐊᓂᑎᐦ ᐊᐦᒑᐦᑰᐦᒡ ᑭᔮᐦ ᐱᒫᑎᓰᐎᓐ ᐋᓐ ᒑ ᒌ ᐋᔮᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ᐱᔅᒡ ᒫᒃ ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᒧᐃ ᒋᑖᑆᔨᐦᑖᓈᐙᐤ᙮” ᔖᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒌᓴᔅ ᒫᐅᒡ ᐅᔅᑭᒡ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᒑ ᐅᐦᒋ ᑖᑆᐦᑎᒥᔨᒡ ᑭᔮᐦ ᒌ ᒋᔅᒑᔨᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒑ ᒫᒥᔑᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ᐋᒄ ᐃᔮᑦ ᒫᒃ, “ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐄᑎᑯᒡ ᓂᒧᐃ ᐊᐙᓐ ᓂᑭ ᒌ ᐹᒋ ᓈᑎᒄ ᐹᑎᔥ ᐅᐦᑖᐐᒫᐤ ᒥᔨᑯᒑ ᒑ ᒌ ᓈᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤ ᑳ ᓅᔔᔥᑳᑯᑦ ᒌ ᓂᑭᑎᑰ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐐᒑᐅᑰ ᔖᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ᐋᒄ ᒌᓴᔅ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᓃᔓᔖᑉ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᐦ ᐄᑖᑦ, “ᑭᔮᐦ ᐋ ᒌᔨᐙᐤ ᒋᐐ ᓂᑭᓯᓈᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ᑳ ᓂᔥᒀᐅᔑᐦᐄᑯᑦ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐊᐙᓐ ᒫᒃ ᒑ ᓂᑎᐙᐱᒥᒋᐦᑦ? ᒋᑎᔨᒧᐎᓂᐦᒡ ᐋᑯᑖᐦ ᐙᐦᒋ ᑎᑯᐦᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ᓂᑖᑆᐦᑖᓈᓐ ᒫᒃ ᑭᔮᐦ ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᒌᔨ ᐋᐦ ᐋᐎᔨᓐ ᑳ ᐱᔮᐦᒋᓰᑦ, ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓂᒧᐃ ᐋ ᓃᔨ ᑰᐦᒋ ᐅᐙᔮᐱᒥᑎᓈᐙᐤ ᐋ ᓃᔓᔖᐳᔮᒄ, ᐹᔨᒄ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᒥᒋᒥᓂᑐᐎᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ᒍᑖᔅ, ᓵᐃᒥᓐ ᐃᔅᑳᕆᔨᑦ ᐅᑯᓯᔨᐤᐦ, ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔨᒨᒫᑦᐦ ᐙᔥ ᐋᐅᒄ ᐊᓐ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᓃᔓᔖᐴᒡ ᒑ ᒫᒥᔑᒫᑯᐱᓈ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ᒦᓐ ᐹᑎᒫ ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑳᓕᓖ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ, ᓂᒧᐃ ᐐᐦ ᐊᓂᑖᐦ ᒎᑏᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᐄᑖᐦᒑ ᐅᐦᒋ ᐐᐦ ᐄᑐᐦᑖᐤ ᐙᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᐋ ᒌ ᐐᐦ ᓂᐱᐦᐄᑯᑦ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ᔖᔥ ᒫᒃ ᒌ ᐹᔓᓈᑯᓂᔨᐤ ᑳ ᒌ ᒥᑯᔖᒡ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ᐙᐦᑎᒋᐱᔨᒡ ᒫᒃ ᒫᐦᑮᐦᒡ ᒫᓐ ᒌᐦ ᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ᐋᒄ ᐋᑎᑯᑦ ᒌᓴᔅ ᐐᒋᔖᓐᐦ, “ᒋᔅᑐᐦᑖ ᒫᐦ, ᓈᑖᐦ ᒎᑏᔮᐦᒡ ᒑ ᐄᑐᐦᑖᔨᓐ, ᒑ ᐙᐱᐦᑎᐦᒡ ᐊᓂᒌ ᑳ ᓅᔔᔥᑳᔅᒡ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᔥᑳᒡ ᐋ ᐃᐦᑐᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ᓂᒧᐃ ᐊᐙᓐ ᑳᑖᐤ ᑖᓐ ᒑ ᒌ ᐄᔑ ᑐᑎᐦᒃ ᓈᑐᐙᔨᐦᑎᒧᒀ ᒑ ᒌ ᒥᔪ ᒋᔅᒑᔨᒫᑭᓅᑦ᙮ ᐋᐦ ᑐᑎᒧᓐ ᒫᒃ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ, ᐱᒋᔅᑎᓃᓲ ᒑ ᒌ ᒋᔅᒑᔨᒥᑭᐎᔨᓐ ᑖᓐ ᒑ ᒌ ᐄᔑ ᑐᑎᒥᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ᐙᔥ ᐙᐙᒡ ᑎᐱᔨᐙ ᐐᒋᔖᓐ ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᔮᔨᒥᑰ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑖᐹ ᐋᔥᒄ ᐅᑎᐦᒋᐱᔨᐤ ᒑ ᒌ ᒋᔅᑐᐦᑖᔮᓐ, ᒌᔨᐙᐤ ᒫᒃ ᒥᒄ ᐙᐦ ᐃᔥᐱᔥ ᐄᑐᐦᑖᔮᒄ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ᑖᐹ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐅᐦᑳᑎᑖᑯᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ ᐋᑳ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ, ᒥᒄ ᒫᒃ ᓅᐦᑳᑎᑯᒡ ᓃᔨ ᐙᔥ ᓂᐐᐦᑖᓐ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᒑᑎᓰᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ᒫᒌᒄ ᒌᔨᐙᐤ ᐄᑐᐦᑖᒄ ᓈᑖᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ, ᑖᐹ ᐋᔥᒄ ᐅᑎᐦᒋᐱᔨᐤ ᓃᔨ ᒑ ᒌ ᐄᑐᐦᑖᔮᓐ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᐋᑯᑖᐦ ᐊᔮᐱᒡ ᐊᓂᑎᐦ ᑳᓕᓖᐦᒡ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓐ ᒌᓴᔅ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᐋᐦ ᐄᑐᐦᑖᔨᒡ, ᑭᔮᐦ ᐐᔨ ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᑯᑦ, ᐙᔥ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᒫᐤ ᒑ ᒌ ᒋᔅᒑᔨᒥᑯᑦ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ᐊᓂᔮᔨᐤ ᒫᒃ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒌ ᓈᓂᑐᐙᔨᒥᑰ ᐊᓂᑖᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ᙮ ᒌ ᓈᓂᑐ ᑯᒀᒋᒑᒧᔨᐤ ᑖᓂᑖᐦ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᐋᔨᒨᒥᑰ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ᐱᔅᒡ ᐋᐦ ᐄᔨᔨᒡ, “ᓈᔥᑖᑆᐦ ᒥᔻᔨᐦᑖᑯᓯᐤ ᐆ ᓈᐹᐤ᙮” ᐋᒄ ᑯᑎᒃ ᐋᐦ ᐄᔨᔨᒡ, “ᓂᒧᐃ ᒥᔻᔨᐦᑖᑯᓯᐤ, ᐎᓂᐱᔨᐦᐋᐤ ᐊᐙᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒋᔣᐙᐅᒡ ᐋᐦ ᐋᔨᒨᒫᒡ ᒌᓴᔅᐦ ᐙᔥ ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ᔖᔥ ᒫᒃ ᐎᔮᔥ ᐋᐱᐦᑑ ᒌ ᐃᔥᐱᔥ ᒌᔥ ᒥᑯᔖᓄᔨᐤ, ᐋᒄ ᒌᓴᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᒄ ᑳ ᒋᔅᑯᑎᒫᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ᐊᓂᒌ ᒫᒃ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᓈᔥᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᐙᐅᒡ ᐋ ᐃᔥᐱᔥ ᒥᔪᐦᑖᑯᓰᔨᒡ ᐋ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐋᒄ ᐃᔮᒡ, “ᑖᓂᑖᐦ ᐙᐦᒋ ᓈᔥᒡ ᒥᔥᑏᐦ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐋᐦᐋᑳ ᒫᒃ ᓂᐦᑖ ᐅᐦᒋ ᒋᔅᑯᑎᒧᐙᑭᓅᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᐊᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᓐ ᓂᒥᔮᐤ ᓃᔨ ᐊᓐ ᓂᒋᔅᑯᑎᒫᒑᐎᓐ, ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐅᒋᔅᑯᑎᒫᒑᐎᓐ, ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᓲᐦᒃ ᐐᐦ ᑐᑎᒧᒑ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ, ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᐅᒡ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔓᒦᒀᓂᐦᐄ ᐊᓂᔮᔨᐤ ᒑ ᒌ ᐄᔑ ᒋᔅᑯᑎᒫᒑᐅᒡ ᑭᔮᐦ ᒫᒃ ᒥᒄ ᓃᔨ ᓂᑎᑖᔨᐦᑎᒧᐎᓂᐦᒡ ᐙᐦᒋᐱᔨᔨᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ᐊᓐ ᐊᐙᓐ ᒥᒄ ᐐᔨ ᑖᓐ ᐋᔨᑖᔨᐦᑎᐦᒃ ᑳ ᐄᔑ ᐐᐦᑎᐦᒃ ᒑᒀᔨᐤ, ᓂᑎᐙᔨᐦᑎᒻ ᐐᔨ ᒑ ᒌ ᒋᔅᑖᔨᒫᑭᓅᑦ᙮ ᐋᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑ ᒌ ᒋᔅᑖᔨᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ, ᑯᐃᔅᒄ ᐊᔨᒨ ᑭᔮᐦ ᑖᑆᐅᒑᔨᐦᑖᑰᓲᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ᓂᒧᐃ ᐋ ᒧᓱᔅ ᑰᐦᒋ ᒥᔨᑯᐙᐤ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᐃᔮᐙᒄ? ᓂᒧᐃ ᒫᒃ ᐙᒋᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᒋᓂᓂᐦᐄᐦᑖᓈᐙᐤ ᐊᓐ ᐐᔓᐙᐎᓐ᙮ ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐐᐦ ᐹᒋ ᓂᐱᐦᐄᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᓂᔥᒀᐅᔑᐦᐋᒡ ᒌᓴᔅ ᐃᔮᒡ, “ᒥᒋᐊᐦᒑᐦᒄ ᒌ ᐲᐦᒋᔥᑳᒄ᙮ ᐊᐙᓐ ᒫᒃ ᐆ ᐙᐦ ᓂᐱᐦᐄᔅᒃ?” ");
INSERT INTO crl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᐹᔨᒄ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ ᓂᒌᐦ ᑐᑖᓐ, ᒋᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᒌᔨᐙᐤ ᒥᓯᐙ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ᒧᓱᔅ ᒌ ᐄᑎᔓᐙᒑ ᒑ ᒌ ᑐᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᐄᑎᔥᑖᔨᒡ ᒑ ᒌ ᒋᔅᒋᓄᐙᒋᔓᒫᑭᓂᐎᔨᒡ ᓈᐹᔥ᙮ ᓂᒥᔮᐤ ᒫᒃ ᒧᓱᔅ ᓃᔥᑎᒻ ᑳ ᐱᒋᔅᑎᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ, ᔖᔥ ᐊᓂᑖᐦ ᐙᔥᑭᒡ ᒌ ᐙᐦᑯᒫᑭᓂᐎᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᐃᔮᒡ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒌ ᒋᔅᒋᓄᐙᒋᔣᐙᐅᒡ ᓈᐹᔑᒡ ᐋ ᐅᑎᐦᒋᐱᔨᔨᒡ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᑐᑎᐙᑭᓂᐐᒡ ᐋᑎ ᒫᒀᒡ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᒌᔑᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ᐆ ᒫᒃ ᐋᐦ ᑐᑖᒫᒄ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ ᐋ ᐃᔥᐱᔥ ᐐ ᑭᓂᐙᔨᐦᑎᒸᒄ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓐ, ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᒋᔓᐙᓰᔅᑑᔮᒄ ᒥᑐᓐ ᐋ ᒌ ᒥᓂᐙᒋᐦᐄᒃ ᐊᓐ ᓈᐹᐤ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ᑯᐃᔅᒄ ᒫᐦ ᒫᒥᑐᓈᔨᐦᑎᒧᒄ ᐊᓐ ᑳᐦ ᑐᑎᒫᓐ᙮ ᐊᑳᐐ ᐊᑖᒫᔨᒥᒄ ᒑᒀᓐ ᐋᐦᐋᑳ ᓃᔥᑎᒻ ᒥᑐᓐ ᓂᑑᒋᔅᒑᔨᐦᑎᒫᒄ ᒑᒀᓐ ᐙᐦᒋ ᑐᑎᒫᓐ ᐊᓐ ᑳᐦ ᑐᑎᒫᓐ,” ᒌᐦ ᐄᑖᐤ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐅᐦᒌᒡ ᐃᔮᒡ, “ᐋᔨᐅᑯᓐ ᐋ ᐅᔮᔨᐤ ᓈᐹᐤ ᑳ ᐐᐦ ᓂᐱᐦᐋᒡ? ");
INSERT INTO crl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ᙮ ᓂᒧᐃ ᐎᔮᔥ ᐄᑖᑭᓂᐤ ᐊᓂᑖᐦ ᑖᐙᔨᔥ ᐋ ᒋᔅᑯᑎᒫᒑᑦ᙮ ᓂᒧᐃ ᑳᑭᔮᐦ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒎᐄᔨᔨᐤ ᑖᑆᐦ ᙭ ᐃᔮᐎᔨᒀᓂᐦᐄ, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ᐄᓈᓂᐤ ᒫᒃ ᐋᑳ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᒫᑭᓅᑦ ᑖᓂᑖᐦ ᒑ ᐅᐦᒌᑦ ᙭ ᑎᑯᔑᐦᑳ᙮ ᐆ ᒫᒃ ᐐᔨ ᓈᐹᐤ ᒌ ᒋᔅᒑᔨᒫᓂᐤ ᑖᓂᑖᐦ ᐙᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ᒫᒀᒡ ᒌᓴᔅ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒌ ᒋᔣᐙᐤ ᐋᒄ ᐃᔮᑦ, “ᑖᑆᐦ ᐋ ᒋᒋᔅᒑᔨᒥᓈᐙᐤ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ? ᑖᑆᐦ ᐋ ᒌ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓂᑖᐦ ᐙᐦᒋᔮᓐ? ᓂᒧᐃ ᓅᐦᒋ ᑎᑯᔑᓐ ᓃᔨ ᒥᒄ ᐋ ᒌ ᐄᑖᔨᐦᑎᒫᓐ ᒑ ᒌ ᑎᑯᔑᓂᔮᓐ᙮ ᐊᓐ ᒨᔥ ᑯᐃᔅᒄ ᑳᐦ ᑎᒃ ᐋᐅᒄ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᓂᒧᐃ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᐙᐤ ᒌᔨᐙᐤ ᐊᓐ ᐊᐙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ᒥᒄ ᒫᒃ ᓂᒋᔅᒑᔨᒫᐤ ᓃᔨ ᐙᔥ ᐐᔨ ᐋᐦ ᑖᑦ ᓅᐦᒌᐙᓐ ᑭᔮᐦ ᐐᔨ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ᐋᑯᑖᐦ ᑳ ᐐᐦ ᐅᑎᓈᒡᐦ ᒌᓴᔅᐦ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐱᒫᔨᒫᐅᒡ, ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᒑ ᐅᑎᓈᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒌ ᑖᑆᔮᔨᒥᑰ ᐋᐦ ᐄᔨᔨᒡ, “ᒥᔥᑏᐦ ᒌ ᐄᔑ ᒫᒥᔥᑳᒡ ᐄᔨᐦᑑ ᐆ ᓈᐹᐤ᙮ ᐹᒋ ᐄᑎᔑᐦᐙᒑ ᒫᒃ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᙭, ᐊᐅᔅᑖ ᐋ ᑭᑎ ᐄᔑ ᒫᒥᔥᑳᒡ ᑐᑎᒥᔨᐤ ᒑᒀᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑐᑎᒥᔨᒡ ᐅᔮᔨᐤ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑳ ᐹᐦᑎᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑖᓐ ᑳ ᐄᔑ ᒌᒧᒡ ᐋᔨᒨᒫᔨᒡ ᒌᓴᔅ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᐙᔓᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒑ ᒌ ᓂᑑᐅᑎᓈᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ᐋᒄ ᒌᓴᔅᐦ ᐃᔮᑦ, “ᐋᔥᒄ ᐙᐃᐱᔥᒌᔥ ᓂᑭ ᑖᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ᒥᒄ ᒫᒃ ᔖᔥ ᐐᐱᒡ ᓂᑭ ᐄᑐᐦᑖᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ᒋᑭ ᐹᒋ ᓈᓂᑐᐙᐱᒥᓈᐙᐤ ᒫᒃ, ᓂᒧᐃ ᒥᒄ ᒋᑭ ᐅᐦᒋ ᒥᔅᑯᓈᐙᐤ, ᐙᔥ ᐊᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ ᓂᒧᐃ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ ᒌᔨᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᑎᑐᒡ, “ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᑦ ᒑ ᐅᐦᒋ ᐋᑳ ᒥᔅᑰᐦᒃ? ᒀᔣᓐ ᑯᒀᑖᔨᐦᑎᒧᒑ ᐊᓂᑖᐦ ᑯᑎᒃ ᒌᒡ ᒎᐤ ᐄᔨᔨᐤ ᐋᐦ ᑖᔨᒡ ᑳ ᐐᒋᒫᔨᒡ ᒃᕇᒃ ᒑ ᐄᑐᐦᑖᑦ ᒑ ᒌ ᒋᔅᑯᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᒃᕇᒃ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ᑖᓐ ᐋᔅᒋᔣᒥᑭᓃᔨᒡ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ, ᒋᑭ ᓈᓂᑐᐙᐱᒥᓈᐙᐤ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒥᔅᑳᐅᓈᐙᐤ? ᑭᔮᐦ ᑳᐦ ᐃᔨᑦ, ᓂᒧᐃ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ ᐊᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ? ᐋᐅᒄ ᑳ ᐄᔑ ᐊᔨᒥᐦᐄᑐᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ᐊᓐ ᒫᐦᒑᔨ ᐋ ᒌᔑᑳᒡ ᐊᓐ ᑳ ᒥᑯᔖᓂᐎᔨᒡ ᐋᐅᒄ ᒫᐅᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᐦᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᒌᓴᔅ ᑳ ᐱᓯᑯᑦ ᐋ ᒋᔣᐙᑦ ᐋᐦ ᐃᔨᑦ, “ᐊᐙᓐ ᓅᐦᑖᔮᐹᒀᒀ ᓂᑭ ᐹᒋ ᓂᑎᐙᐱᒧᒄ ᐋᒄ ᒫᒃ ᒑ ᒥᓂᐦᐄᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ‘ᐊᓐ ᐊᐙᓐ ᒑ ᐹᒋ ᑖᑆᔮᔨᒥᒀ, ᐅᑖᐦᐄᐦᒡ ᒋᑭ ᐅᐦᒌᐎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᓂᐲᔨᐤ ᑳ ᐱᒫᒋᐦᐄᐙᒥᑭᓃᔨᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᐋᐦ ᐋᔨᒨᒫᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᑆᐦᑎᐦᒃ ᒑ ᐃᔮᐙᑦ᙮ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᒥᔮᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᐱᒫᐤ ᒌᓴᔅ ᐅᐦᑖᐐᒫᐤ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᐋᒄ ᐃᔮᒡ, “ᐋᐅᒄ ᐆ ᑖᑆᐦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐅᑎᐦ ᐋᔨᐦᑖᔨᐅᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ᑯᑎᑭᒡ ᐐᐦ ᐋᒄ ᐃᔮᒡ, “ᐋᐅᒄ ᐆ ᙭᙮” ᒥᒄ ᒫᒃ ᑯᑎᑭᒡ ᐋᒄ ᐃᔮᒡ, “ᓂᒥᔮᒑ ᐆ ᙭, ᐙᔥ ᓂᒧᐃ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᐅᐦᒋ ᐅᐦᒌᐤ ᐊᓐ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ‘ᐊᓂᑖᐦ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᒋᑭ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐤ ᐊᓐ ᙭, ᐊᓂᑖᐦ ᒫᒃ ᐹᕪᓕᐦᐋᒥᐦᒡ ᐊᓂᑖᐦ ᐊᓂᔮ ᑌᕕᑦ ᑳ ᐅᐦᒌᑦ ᐋᑯᑖᐦ ᒋᐱᐦ ᐱᒫᑎᓰᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ᐋᒄ ᑳ ᐱᐦᑳᓂᐱᔨᐦᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋᐦᐋᑳ ᐹᔨᑯᓂᐦᒡ ᐄᑖᔨᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ᐱᔅᒡ ᐄᔨᔨᐅᒡ ᒋᐐᐦ ᐅᑎᓈᐅᒡ ᒥᒄ ᓂᒧᐃ ᐊᐙᓐ ᐅᐦᒋ ᐱᒫᔨᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ᐊᓂᒌ ᒫᒃ ᑳ ᒋᐱᐦᐅᐙᔓᐎᒡ ᑳᐤ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ᙮ ᒌ ᐄᑎᑯᒡ ᒫᒃ, “ᒑᒀᓐ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᐹᔓᐙᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ᐋᒄ ᐃᔮᒡ ᐊᓂᒌ ᑳ ᒋᐱᐦᐅᐙᔓᐎᒡ, “ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᐃᔥᐱᔥ ᒥᔪ ᒋᔅᑯᑎᒫᒑᐤ ᐊᐙᓐ ᐋ ᐃᔥᐱᔥ ᒥᔪ ᒋᔅᑯᑎᒫᒑᑦ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ᐋᒄ ᐋᑎᑯᒡ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ, “ᑭᔮᐦ ᐋ ᒌᔨᐙᐤ ᒋᒌ ᐎᓂᐱᔨᐦᐄᑯᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ᓂᒧᐃ ᓂᐦᑖ ᐊᐙᓐ ᐋ ᓃᑳᓂᔥᑳᒑᑦ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᐅᐦᒋ ᑖᑆᐦᑎᒧᒡ ᒌᓴᔅᐦ ᐋᐦ ᐋᐎᔨᒡ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ᒥᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ ᐋᐅᑯᓂᒡ ᐅᒌ ᐙᐦ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᐋᐎᔨᒡ ᙭, ᓂᔑᐎᓈᒋᒥᑯᒡ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᐋᐦ ᑎᒡ,” ᒌ ᐄᑖᐅᒡ ᐊᓂᒌ ᐹᕆᓰᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ᐹᔨᒄ ᐊᓐ ᐹᕆᓰ ᐊᓐ ᐹᔨᒀᐤ ᑳ ᓂᑎᐙᐱᒫᑯᐱᓈ ᒌᓴᔅᐦ, ᓂᑯᑏᒧᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐐᒋᐹᕆᓯᔨᐦ, ");
INSERT INTO crl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","ᐊᒀᑎᔅᑖᐦᒡ ᒋᐐᔓᐙᐎᓂᓅ, “ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᑎᐹᔅᑯᓈᓂᐤ ᐊᐙᓐ ᐋᔥᒄ ᐋᐦᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᓂᑑᐦᑎᐎᐦᒄ ᐋ ᐊᔨᒥᑦ ᑭᔮᐦ ᐋᔥᒄ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒫᒄ ᑖᓐ ᑳᐦ ᑎᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ᐋᒄ ᓈᔅᒀᐅᔑᐦᐋᒡ ᐋᐦ ᐄᑖᒡ, “ᑭᔮᐦ ᐋ ᒌᔨ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑰᐦᒋᔨᓐ? ᐊᔨᒥᐦᑖᔨᓈ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ ᒋᑭ ᒋᔅᒑᔨᐦᑖᓐ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐅᐦᒌᑦ ᐊᐙᓐ ᐋ ᐅᒋᔅᒋᐙᐦᐄᒑᓲᑦ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ᐋᒄ ᒥᓯᐙ ᑳ ᒌᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ᐊᓂᑖᐦ ᒫᒃ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐋᐱᔅᑯᑎᓈᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᑦ ᐐᔨ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ᐐᐱᒡ ᒦᓐ ᐎᔮᐱᓃᔨᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒦᓐ ᒌ ᐄᑐᐦᑖᐤ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ᙮ ᑳ ᐅᐙᔨᐱᑦ ᐋᒄ ᑳ ᒋᔅᑯᑎᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ᐊᓂᒌ ᒫᒃ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᐹᔑᐙᐅᒡ ᐃᔅᒀᐤ ᐋ ᒌ ᐐᒋᐱᓯᒀᑎᓰᒫᔨᒡ ᓈᐹᐤ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᑳ ᐹᔑᐙᒡ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ᐋᒄ ᐋᑖᒡ ᒌᓴᔅᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᒌ ᒑᔅᑭᐙᑭᓂᐤ ᐆ ᐃᔅᒀᐤ ᒫᒀᒡ ᐋ ᐐᒋᐱᓯᒀᑎᓰᒫᑦ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᐦᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ ᐋ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᑭᓅᑦ ᐃᔅᒀᐤ ᐋ ᒑᔅᑭᐙᑭᓅᑦ ᑯᑎᒃ ᓈᐹᐤ ᓂᑎᐐ ᐋ ᐄᔑ ᐐᒑᐙᑦ᙮ ᑖᓐ ᒫᒃ ᒑ ᒌ ᐃᔨᓐ ᒌᔨ?” ");
INSERT INTO crl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ᐋᐅᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᒡ ᐋ ᒌ ᐐᐦ ᓈᓂᑐ ᑯᒀᒋᐦᐋᒡ ᒑ ᐲᑯᓂᒥᔨᒀᓂᐦᐄ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ, ᐋᒄ ᒫᒃ ᐲᑯᓂᒥᔨᒑ ᒑ ᑎᑯᓃᔨᑯᐱᓈ ᒑ ᐄᔑ ᒫᒥᓯᒫᒡ᙮ ᒥᒄ ᒫᒃ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᒌ ᐄᔑ ᓂᐙᑳᐳ ᒌᓴᔅ, ᑳ ᒥᓯᓂᐦᐄᒑᑦ ᐊᓂᑎᐦ ᔮᑳᐦᒡ ᐅᑎᐦᒌ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᓃᐴᐎᒡ ᐋᐦ ᐋᔨᐦᑭᒥᒫᒡ ᒑ ᒌ ᓂᔥᒀᐅᔑᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᑯᒀᒋᒫᒡ, ᒌ ᔑᐦᑐᑳᐳ ᒌᓴᔅ ᐋᒄ ᐋᑖᑦ, “ᑖᓐ ᐊᓐ ᐊᐙᓐ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᐋᑳ ᓂᐦᑖ ᐙᐦᒋ ᒥᒋᐦᑐᑎᐦᒃ ᐐᔨ ᓃᔥᑎᒻ ᒋᑭ ᐱᒧᔑᓈᑎᐦᐙᐤ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ᒦᓐ ᑳ ᓂᐙᑳᐳᑦ ᐋᒄ ᒦᓐ ᑳ ᒥᓯᓂᐦᐄᒑᑦ ᐊᓂᑖᐦ ᔮᑳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᐹᐦᐹᔨᒄ ᒌ ᐋᑎ ᒋᔅᑐᐦᑖᐅᒡ, ᓃᔥᑎᒻ ᐊᓂᒌ ᑳ ᒋᔖᐄᔨᔨᐅᒡ᙮ ᒑᒃ ᒥᒄ ᐐᔨ ᒌᓴᔅ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐃᔅᒀᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ᑳ ᔓᑐᑳᐳᑦ ᒌᓴᔅ ᐋᒄ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤᐦ, “ᐃᔅᒀᐤ, ᑖᓂᑖᐦ ᐋᐦ ᑖᒡ ᐊᓂᒌ ᑳ ᒫᒥᔑᒥᔅᒡ? ᓂᒧᐃᐋ ᑖᐤ ᐊᐙᓐ ᐋ ᒌ ᓂᔑᐎᓈᒋᒥᔅᒃ?” ");
INSERT INTO crl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ᐋᒄ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤᐦ ᐋᑎᑯᑦ ᒌᓴᔅᐦ, “ᓂᒧᐃ, ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓂᒧᐃ ᑭᔮᐦ ᓃᔨ ᒌ ᓂᔑᐎᓈᒋᒥᑎᓐ᙮ ᒫᒌᐦ, ᐊᑳᐐ ᒦᓐ ᒥᒋᐦᑑᑎ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ᐄᔥᐱᐦ ᒌᓴᔅ ᒦᓐ ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐋᒄ ᐋᑖᑦ, “ᓃᔨ ᐋᐅᒄ ᑳ ᒥᔨᒀᐤ ᐄᔨᔨᐅᒡ ᐙᔥᑖᐎᓂᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᐊᓐ ᐊᐙᓐ ᑳ ᓅᔔᔥᑯᑦ ᒋᑭ ᐃᔮᐤ ᐱᒫᑎᓰᐎᓂᔨᐤ ᐙᔥᑖᐎᓂᐦᒡ ᐅᐦᒋ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐱᒧᐦᑖᐤ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᐋᐦ ᐄᑖᒡ, “ᒥᒄ ᒌ ᒋᑎᔨᒦᔥᑎᒫᓱᓐ, ᓂᒧᐃ ᑖᑆᐦᑖᑯᓐ ᐊᓐ ᑳ ᐃᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᐋᑦ ᒥᒄ ᓃᔨ ᐋ ᑎᐹᒋᒥᓱᔮᓐ ᑖᑆᒥᑭᓐ ᑖᓐ ᐋ ᐃᔮᓐ᙮ ᐙᔥ ᓂᒋᔅᒑᔨᐦᑖᓐ ᑖᓂᑖᐦ ᐙᐦᒋᔮᓐ ᑭᔮᐦ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ᙮ ᒌᔨᐙᐤ ᒫᒃ ᓂᒧᐃ ᒋᒋᔅᒑᔨᒥᓈᐙᐤ ᑖᓂᑖᐦ ᐙᐦᒋᔮᓐ ᑭᔮᐦ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ᒥᒄ ᑖᓐ ᐋ ᐃᔑᓄᐙᒄ ᐊᐙᓐ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᑎᐹᔅᑯᓈᒄ, ᓃᔨ ᒫᒃ ᓂᒧᐃ ᓅᔮᔅᑯᓈᐤ ᐊᐙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ᑎᐹᔅᑯᓂᒑᔮᓈ ᒫᒃ ᒋᑭ ᑖᑆᒥᑭᓐ ᐊᓐ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᒑᔮᓐ᙮ ᐙᔥ ᓂᒧᐃ ᓂᐹᔨᑯᔑᓐ ᐋ ᑎᐹᔅᑯᓂᒑᔮᓐ, ᓅᐦᑖᐐ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᐋᐅᒄ ᐊᓐ ᐙᒋᐦᐄᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐐᔓᐙᐎᓂᐙᐦᒡ ᓃᔓ ᐄᔨᔨᐅᒡ ᐹᔨᑯᓂᐦᒡ ᐋᐦ ᐄᑎᐦᑖᑯᓯᒡ ᐋ ᐐᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒡ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᒑᒀᔨᐤ, ᑖᑆᒥᑭᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐃᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ᓂᑖᑆᓐ ᑖᓐ ᐋᐦ ᐄᑖᒋᒦᓱᔮᓐ ᑭᔮᐦ ᐅᐦᑖᐐᒫᐤ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᐐᐦᑎᒻ ᐋ ᑖᑆᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ᐋᒄ ᐋᑖᒡ, “ᑖᓂᑖᐦ ᐋᐦ ᑖᑦ ᑰᐦᑖᐐ?” ᒌᓴᔅ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᑦ, “ᓂᒧᐃ ᑖᑆᐦ ᒋᒋᔅᒑᔨᒥᓈᐙᐤ ᑭᔮᐦ ᓅᐦᑖᐐ ᓂᒧᐃ ᒌ ᒋᔅᒑᔨᒫᐙᐤ᙮ ᐙᔥ ᒋᔅᒑᔨᒥᔮᒄ ᓅᐦᑖᐐ ᑭᔮᐦ ᒋᐱᐦ ᒋᔅᒑᔨᒫᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᒋᔅᑯᑎᒫᒑᑦ ᐊᓂᑖᐦ ᑳ ᒌ ᑭᓄᐙᔨᐦᑖᑭᓂᐐᔨᒡ ᐱᒋᔅᑎᓂᒑᐎᓂᔨᐤ᙮ ᓂᒧᐃ ᒫᒃ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᒫᑯᓂᑰ ᐙᔥ ᓂᒧᐃ ᐋᔥᒄ ᐅᐦᒋ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᒑ ᐅᑎᓈᑭᓄᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ᒦᓐ ᒫᒄ ᐋᒄ ᐋᑖᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᓂᑭ ᒋᔅᑐᐦᑖᓐ, ᒋᑭ ᐹᒋ ᓈᓂᑐᐙᐱᒥᓈᐙᐤ ᒥᒄ ᒫᒃ ᐋᐅᒄ ᐋᓐ ᒑ ᐄᔑ ᓂᐱᔮᒄ ᐋ ᒋᒋᔥᑭᒫᒄ ᒌ ᒥᒑᑎᓰᐎᓂᐙᐤ᙮ ᓂᒧᐃ ᒫᒃ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ᐋᒄ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐃᔮᒡ, “ᐊᓂᔮᔨᐤ ᒫᐦ ᑳᐦ ᐃᔨᑦ, ᓂᒧᐃ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ᙮ ᒋᑭ ᓂᐱᐦᐄᓲ ᑳᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐃᔨᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᓃᐦᑖᐦᒡ ᑰᐦᒌᓈᐙᐤ ᒌᔨᐙᐤ ᓃᔨ ᒫᒃ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᓅᐦᒌᓐ᙮ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑰᐦᒌᓈᐙᐤ ᒌᔨᐙᐤ, ᓃᔨ ᒫᒃ ᐐ ᓂᒧᐃ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᓅᐦᒌᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ᐋᐅᒄ ᐊᓐ ᐋᐦᒡ ᒌ ᐐᐦᑎᒫᑎᑯᒡ ᒑ ᓂᐱᔮᒄ ᐋ ᒋᒋᔥᑭᒫᒄ ᒌ ᒥᒑᑎᓰᐎᓂᐙᐤ᙮ ᐋᐅᒄ ᐋᓐ ᒫᒃ ᑖᑆᐦ ᒑ ᐄᔑ ᓂᐱᔮᒄ ᐋ ᒋᒋᔥᑭᒫᒄ ᒌ ᒥᒑᑎᓰᐎᓂᐙᐤ, ᐋᑳ ᑖᑆᐦᑎᒫᒀ ᑖᑆᐦ ᓃᔨ ᐋᐦ ᐋᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᐄᑖᒡ, “ᐊᐙᓐ ᒫᒃ ᒌᔨ?” ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᐊᓂᑎᐦ ᐅᔅᑭᒡ ᑳ ᒋᐦᒋᐱᔨᐦᑖᔮᓐ ᐋ ᒋᔅᑯᑎᒫᒑᔮᓐ ᐋᑯᑖᐦ ᔖᔥ ᑳ ᐐᐦᑎᒫᑎᑯᒡ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ᒥᐦᒑᓐ ᒑᒀᓐ ᒑ ᒌ ᐐᐦᑎᒫᓐ ᒑ ᒌ ᐅᐦᒋ ᑎᐹᔅᑯᓂᑯᔮᒄ᙮ ᒥᒄ ᒫᒃ ᓂᑭ ᐐᐦᑎᒧᐙᐅᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑑᒃ ᐋᐦ ᐋᔨᒨᑎᐦᒃ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᐙᔥ ᒨᔥ ᑖᑆᐅᒑᔨᐦᑖᑯᓯᐤ ᐐᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᐙᐅᒡ ᒌᓴᔅᐦ ᐅᐦᑖᐐᒫᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔨᒨᒫᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᐄᔥᐱᐦ ᐅᐦᐹᔅᑯᐦᐋᒀ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋᒄ ᒑ ᒋᔅᒑᔨᐦᑖᒫᒄ ᓃᔨ ᑖᑆᐦ ᐋᐦ ᐋᐎᔮᓐ᙮ ᒋᑭ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᐋᐦᐋᑳ ᑐᑎᒫᓐ ᒑᒀᓐ ᐹᑎᔥ ᑳᐦ ᐄᑎᔓᒥᒡ ᓅᐦᑖᐐ ᒑ ᒌᐦ ᑐᑎᒫᓐ᙮ ᒥᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᑦ ᐅᐦᑖᐐᒫᐤ ᒑ ᒌ ᐐᐦᑎᒧᒡ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒑ ᐐᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ᐊᓐ ᒫᒃ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᓂᐐᒑᒄ, ᓂᒧᐃ ᓅᐦᒋ ᓂᑭᑎᒄ ᒥᒄ ᒑ ᒌ ᐹᔨᑯᔔᒡ ᐙᔥ ᒨᔥ ᓂᑎᐦᑐᑎᒸᓐ ᐐᔨ ᑖᓐ ᐋ ᐄᔑ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ᒥᐦᒑᑐ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᒌᓴᔅᐦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᑖᑆᔮᔨᒥᑯᑦ, “ᒨᔥ ᓂᓂᐦᐄᐦᑎᒫᒀ ᓂᒋᔅᑯᑎᒫᒑᐎᓐᐦ, ᒌᔨᐙᐤ ᐋᐅᒄ ᑖᑆᐦ ᓂᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ᒋᑭ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᑆᐎᓐ ᑭᔮᐦ ᒋᑭ ᐋᐱᐦᑯᓂᑯᓈᐙᐤ ᐊᓐ ᑖᑆᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ᐋᒄ ᐋᑎᑯᑦ, “ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᓂᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᓈᓐ, ᓂᒧᐃ ᓂᐦᑖ ᓅᐦᒋ ᑎᐹᔨᒥᑯᓈᓐ ᐊᐙᓐ᙮ ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐃᔨᓐ ᒋᑭ ᐋᐱᐦᑯᓂᑯᓈᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒥᓯᐙ ᐊᐙᓐ ᑳ ᒥᒋᐦᑐᑎᐦᒃ ᑎᐹᔨᒥᑰ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐦᑐᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ᐋ ᑎᐹᔨᒫᑭᓅᑦ ᐋᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᒨᔥ ᐐᒋᐤ ᐊᓂᑖᐦ ᐅᒋᒫᒻ ᐋᐦ ᑖᔨᒡ ᒥᒄ ᐊᓐ ᐅᑯᓯᓯᒫᐤ ᐋᐅᒄ ᐊᓐ ᒋᐦᒋᐙ ᐙᒋᑦ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ᐱᑯᐦᐄᑖᒀ ᒫᒃ ᐅᑯᓯᓯᒫᐤ ᒥᒋᐃᐦᑣᐎᓂᐦᒡ ᐅᐦᒋ ᑖᑆᐦ ᒋᑭ ᐱᑯᐦᐄᑯᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ᒋᒋᔅᒑᔨᒥᑎᓈᐙᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᐋ ᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔮᒄ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒋᐐᐦ ᓂᐱᐦᐄᓈᐙᐤ ᐋᐦᐋᑳ ᐐ ᓂᑐᐦᑎᒫᒄ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ᓂᑎᐋᔨᒨᑖᓐ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᔨᑦ ᓅᐦᑖᐐ᙮ ᒌᔨᐙᐤ ᒫᒃ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᑖᒄ ᑰᐦᑖᐐᐙᐤ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐋᐦ ᑐᑎᒸᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ᐋᒄ ᐊᓂᔮᔨᐤᐦ ᒎᐤ ᐄᔨᔨᐤᐦ ᑳ ᓂᔥᒀᐅᔑᐦᐄᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᐋᑉᕋᐦᐋᒻ ᐋᐅᒄ ᓅᐦᑖᐐᓈᓐ᙮” ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑖᑆᐦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐙᒀ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᑎᒃ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐅᒄ ᐊᓐ ᒋᐱᐦ ᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐊᓐ ᑖᑆᐎᓐ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᓐ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐅᐦᒋ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒋᐐᐦ ᐹᒋ ᓂᐱᐦᐄᓈᐙᐤ᙮ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᑐᑎᒻ ᐐᔨ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ᐋᐅᒄ ᐋᐃᐦᑎᔮᒄ ᑖᓐ ᐋᐦᑎᒃ ᑰᐦᑖᐐᐙᐤ᙮” ᐋᒄ ᒦᓐ ᑳ ᓂᔥᒀᐅᔑᐦᐄᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᒥᒄ ᐋ ᐹᔨᑯᑦ ᐙᐆᐦᑖᐎᔮᐦᒡ᙮ ᓂᒧᐃ ᓂᑎᐐ ᓅᐦᒌᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐙᐅᐦᑖᐐᐙᒀ, ᒋᐱᐦ ᓵᒋᐦᐄᓈᐙᐤ ᐙᔥ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᓅᐦᒌᓐ ᐋᒄ ᒫᒃ ᐅᑎᐦ ᐱᔮᒋ ᑖᔮᓐ᙮ ᓂᒧᐃ ᓃᔨ ᓅᐦᒋ ᐹᒋ ᐄᑎᔓᐦᐅᓱᓐ, ᐐᔨ ᒋᔖᒥᓂᑑ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐅᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ᒑᒀᓐ ᐙᐦᒋ ᐋᑳ ᒌ ᓂᔅᑐᐦᑎᒫᒄ ᑖᓐ ᐋ ᐃᔮᓐ? ᓂᒧᐃ ᒋᐐᐦ ᓂᓂᐦᐄᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᓐ ᐋᐅᒄ ᐙᐦᒋ ᐋᑳ ᓂᔅᑐᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ᒥᒋᒥᓂᑑ ᐋᐅᒄ ᐙᐆᐦᑖᐎᔮᒄ, ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᑖᒄ ᒑ ᐄᔑ ᒥᒋᐦᑑᑎᒸᒄ ᐋᐅᒄ ᒥᒄ ᐊᓐ ᐙᐦ ᐄᐦᑐᑎᒫᒄ᙮ ᒨᔥ ᒌ ᓂᐱᐦᐄᐙᐤ ᑳ ᐃᔥᐱᔥ ᑎᑯᓃᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒻ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐐᐦᑖᑯᓃᔨᒡ ᒑᒀᔨᐤ ᐙᔥ ᓂᒧᐃ ᒥᑐᓐ ᑎᑯᓂᔨᐤ ᑖᑆᐎᓂᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮ ᒨᔥ ᓂᑎᔨᐤ ᐙᔥ ᐋᐅᒄ ᒋᐦᒋᐙ ᐋᑖᑎᓰᑦ, ᐋᐅᒄ ᒫᒃ ᐊᓐ ᑖᑆᐦ ᐙᐅᐦᑖᐐᒥᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᓂᓂᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ᓃᔨ ᒫᒃ ᒨᔥ ᑯᐃᔅᒄ ᓂᔑᓐ ᐋᐅᒄ ᒫᒃ ᐊᓐ ᐙᐦᒋ ᐋᑳ ᑖᑆᐦᑑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᒋᑭ ᒌ ᐐᐦᑖᓈᐙᐤ ᑳ ᒥᒋᐦᑑᑎᒧᐙᓈ᙮ ᑯᐃᔅᒄ ᒫᒃ ᒨᔥ ᐋ ᐃᔮᓐ ᒑᒀᓐ᙮ ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᒌ ᑖᑆᐦᑑᔮᒄ? ");
INSERT INTO crl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ᐊᓐ ᐊᐙᓐ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒌᑦ ᓂᑐᐦᑎᒻ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤ᙮ ᒌᔨᐙᐤ ᒫᒃ ᓂᒧᐃ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᑰᐦᒌᓈᐙᐤ ᐋᐅᒄ ᐙᐦᒋ ᐋᑳ ᓂᑐᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓂᔥᒀᐅᔑᐦᐋᒡ ᐋᐦ ᐄᑖᒡ ᒌᓴᔅᐦ, “ᓂᒌ ᑖᑆᓈᓐ ᑳ ᐃᔮᐦᒡ ᓵᒫᕆᔮ ᐋ ᐅᐦᒋᔨᓐ ᑭᔮᐦ ᐋ ᐲᐦᒋᔥᑳᔅᒃ ᒥᒋᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᓂᒧᐃ ᓂᐲᐦᒋᔥᑳᒄ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᓂᒋᔥᑖᔨᒫᐤ ᓅᐦᑖᐐ ᒥᒄ ᒫᒃ ᒌᔨᐙᐤ ᓂᒧᐃ ᒋᒋᔅᑖᔨᒥᓈᐙᐤ ᓃᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ᓂᒧᐃ ᓂᓈᓂᑎᐙᔨᐦᑖᓐ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᑖᔨᒥᑭᐎᔮᓐ᙮ ᒥᒄ ᒫᒃ ᑖᐤ ᐊᐙᓐ ᐋ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑ ᒌ ᒋᔅᑖᔨᒥᑯᐎᒡ, ᐐᔨ ᒫᒃ ᐋᐅᒄ ᐙᔮᔅᑯᓈᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐋᑳ ᑳ ᒋᔅᑖᔨᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᒑ ᓂᓂᐦᐄᐦᑎᒧᒀ ᑖᓐ ᐋᐦ ᐃᔨᐅᒡ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ᐋᒄ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᐋᐦ ᐄᑖᒡ, “ᐋᒄ ᒫᒃ ᒋᔮᔥᑎᓈᐦᐅᔮᐦᒡ, ᑖᑆᐦ ᐋ ᐲᐦᒋᔥᑳᔅᒃ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒌ ᐴᓂᐱᒫᑎᓰᐎᒡ᙮ ᒌᔨ ᒫᒃ ᐋᐦ ᐃᔨᓐ ᐊᓐ ᐊᐙᓐ ᒑ ᓂᓂᐦᐄᐦᑎᒧᒀ ᑖᓐ ᐋᐦ ᐃᔨᐅᒡ ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ᒋᑎᐄᑖᔨᐦᑖᓐ ᐋ ᒌᔨ ᐊᐅᔅᑖ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᔨᓐ ᐃᔥᐱᔥ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ? ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᑭᔮᐦ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒌ ᐴᓂᐱᒫᑎᓰᐎᒡ, ᐊᐙᓐ ᒫᒃ ᒌᔨ ᐋᐦ ᐄᑖᔨᒦᓱᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᓃᔨ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᓱᔮᓈ ᓂᒧᐃ ᒥᑐᓐ ᒑᒀᓐ ᒋᑭ ᐅᐦᒋ ᐃᓯᓈᑯᓐ ᐊᓐ ᐋ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᓱᔮᓐ᙮ ᓅᐦᑖᐐ ᐋᐅᒄ ᒑᔅᑖᔨᐦᑖᑯᐦᐄᑦ, ᐊᓐ ᑳᐦ ᐃᔨᔮᒄ ᐋ ᐅᒋᔖᒥᓂᑑᒥᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ᓂᒧᐃ ᓂᐦᑖ ᑰᐦᒋ ᒋᔅᒑᔨᒫᐙᐤ ᒥᒄ ᒫᒃ ᓃᔨ ᓂᒋᔅᒑᔨᒫᐤ᙮ ᐃᔮᓈ ᒫᒃ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒥᒃ, ᓂᑭ ᓂᓂᑎᔨᓐ ᒧᔮᒻ ᒌᔨᐙᐤ ᐋ ᐄᔑ ᓂᓂᑎᔮᒄ᙮ ᒥᒄ ᒫᒃ ᓂᒋᔅᒑᔨᒫᐤ ᑭᔮᐦ ᓂ ᓂᓂᐦᐄᐦᑎᒸᓐ ᐅᑎᔨᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ᐊᓂᔮ ᑰᐦᑖᐐᐙᐤ ᐋᑉᕋᐦᐋᒻ ᒌ ᒨᒋᒑᔨᐦᑎᒻ ᐋ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ ᒑ ᐙᐱᐦᑎᐦᒃ ᓂᒌᔑᑳᒥᔨᐤ᙮ ᒌ ᐙᐱᐦᑎᒻ, ᒌ ᒥᔻᔨᐦᑎᒻ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᐙᐙᒡ ᒌ ᓂᔮᔫᒥᑎᓄᐙᐳᓍᔑᓐ, ᑖᑆᐦ ᐋ ᒫᒃ ᒋᒌ ᐙᐱᒫᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ?” ");
INSERT INTO crl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᔥᒄ ᐋᒸᔮ ᐅᐦᒋ ᑖᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᔖᔥ ᓂᑎᐦᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ᐋᒄ ᑳ ᒫᒨᔑᒋᓂᒡ ᐊᓯᓃ ᒑ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᒡ᙮ ᒥᒄ ᒫᒃ ᒌᓴᔅ ᒌ ᑳᓲᔅᑎᐙᐤ ᐋᒄ ᑳ ᐎᔨᐐᑦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ᐹᔨᒀᐤ ᐋ ᐱᒨᐦᑖᒡ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᒌ ᐙᐱᒫᒡ ᓈᐹᐤ ᒋᐦᒋᐙ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐙᐱᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ᑳ ᑯᒀᒋᒥᑯᑦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ ᒑᒀᔨᐤ ᑳᐦ ᑐᑖᑯᑦ ᐆ ᓈᐹᐤ ᐙᐦᒋ ᒋᐦᒋᐙ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐙᐱᐦᑎᐦᒃ᙮ ᐐᔨ ᐋ ᒌ ᒥᒋᐦᑐᑎᐦᒃ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐅᓃᒋᐦᐄᒄᐦ ᐋ ᒌ ᒥᒋᐦᑑᑎᒥᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ᒌᓴᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ, “ᓂᒥᔮᔨᐤ ᐐᔨ ᐅᒥᒋᐦᑣᐎᓐ ᑭᔮᐦ ᒫᒃ ᐅᓃᒋᐦᐄᒄᐦ ᐅᒥᒋᐦᑐᑎᒧᐎᓂᔨᐤ ᑳᐦᑐᑖᑯᑦ᙮ ᒥᒄ ᒫᒃ ᒑ ᒌ ᐙᐱᐦᑖᑭᓂᐎᔨᒡ ᒋᔖᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓐ ᐅᐦᒋ ᐆ ᓈᐹᐤ ᐆ ᐱᒫᑎᓰᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ᐙᔥ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᒋᐱᐦ ᑐᑎᒧᐙᓈᓂᐤ ᐅᑖᐱᑎᓰᐎᓐ ᐋᔅᑭᐤ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᒌᐦ ᑐᑎᒥᐦᒄ, ᐙᔥ ᐋᐱᑎᓰᓈᓂᐤ ᒫᒀᒡ ᐋ ᒌᔑᑳᒡ᙮ ᔖᔥ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᒑᐦ ᐋᑳ ᒌ ᐋᐱᑎᓰᓈᓂᐎᒡ ᒫᒀᒡ ᐋ ᑎᐱᔅᑳᒡ, ᐙᔥ ᐋᐆᑳᔅᑖᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ᒫᒀᒡ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᐊᔅᒌᐦᒡ ᐋᐅᒄ ᓃᔨ ᐐᔮᔅᑖᐎᓅᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ᐄᔥᐱᐦ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᒌ ᓯᐦᑰ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᐋᒄ ᑳᐆᓰᐦᐋᑦ ᓯᔅᒋᐤᐦ ᐊᓂᔮᔨᐤ ᐅᓯᐦᑰᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ᐋᒄ ᑳ ᔑᔓᔥᒋᓂᒸᑦ ᐅᔅᒌᔑᑯᔨᐤ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ᐋᒄ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᒫᒋᐦ ᓂᑑᒥᓈᐹᐆᑖᐦ ᓈᑖᐦ ᑳ ᒌ ᐱᑳᔑᒧᓈᓂᐎᒡ ᓵᐃᓗᐊᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮” ᐊᓐ ᓵᐃᓗᐊᒻ ᐋᐦ ᐄᓈᓅᒡ “ᑳᐦ ᐄᑎᔑᐦᐙᑭᓄᑦ” ᐄᔑ ᐄᑣᔥᑎᒧᐙᑖᑭᓂᐤ᙮ ᐋᒄ ᑳ ᓂᑑᒥᓈᐹᐆᑖᑦ ᐊᓐ ᓈᐹᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒃ, ᒌ ᐙᐱᐦᑎᒻ ᒫᒃ ᐄᔥᐱᐦ ᒦᓐ ᑖᑯᔑᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ᐋᒄ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᒋᔅᒑᔨᒥᑯᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᐙᐱᒥᑯᑦ ᐋ ᓂᑐᑎᒫᑦ ᔓᐎᔮᓐ, “ᐋᐅᒄ ᐋ ᐆ ᓈᐹᐤ ᑳ ᒌ ᐊᐱᑦ ᐋ ᓂᑐᑎᒫᑦ ᔓᐎᔮᓐᐦ?” ");
INSERT INTO crl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ᐱᔅᒡ ᐋᒄ ᐃᔮᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, “ᐋᐅᒄ ᐊᓐ ᓈᐹᐤ᙮” ᑯᑎᑭᒡ ᒫᒄ ᐐ ᐋᒄ ᐃᔮᒡ, “ᓂᒥᔮᐤ ᐊᓐ, ᒥᒄ ᐋᐅᒄ ᐋᓐ ᒑᑳᑦ ᐋ ᐃᓯᓈᑯᓯᑦ᙮” ᐊᓐ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᐋᒄ ᐃᔮᑦ, “ᐋᐅᒄ ᐙᔥ ᐊᓐ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᐄᔅᐱᔨᒡ ᒑ ᒌ ᐙᐱᐦᑎᒥᓐ ᐋᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐃᔨᑦ, “ᐊᓐ ᓈᐹᐤ ᒌᓴᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᓯᔅᒋᐤ ᒌ ᐹᒋ ᐊᔓᓈᐤ ᓂᔅᒌᔑᑯᐦᒡ, ᐋᒄ ᑳ ᐄᔑᑦ ᒑ ᒥᓈᐹᐆᑖᐅᒡ ᐊᓂᑖᐦ ᓵᐃᓗᐊᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᑳ ᒌ ᐱᑳᔑᒧᓈᓂᐎᒡ᙮ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᔮᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒥᓈᐹᐆᑖᐅᒡ ᑏᐙᐦᒡ ᓂᒌ ᐅᐦᒋ ᐙᐱᐦᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ᐋᒄ ᑳ ᑯᒀᒋᒫᒡ ᐊᓂᔮᔨᐤ ᑳ ᐙᒋ ᐙᐱᐦᑎᒦᒡ, “ᑖᓂᑖᐦ ᐋᐦ ᑖᑦ ᐆ ᓈᐹᐤ?” ᐋᒄ ᐋ ᓈᔅᒀᓯᐦᐋᑦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᐹᕆᓰᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ᒌ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᑳ ᐅᔑᐦᐋᑦ ᔑᔅᒎᐤ ᑭᔮᐦ ᑳ ᒦᓂᐙᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᒦᓐ ᑳ ᑯᒀᒋᒫᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᑖᓂᑖᐦ ᐙᐦᒋ ᐙᐱᐦᑎᒥᔨᒡ ᐋᒄ᙮ ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ, “ᔑᔥᒎᐤ ᒌ ᔑᔓᓈᐤ ᓂᔅᒌᓯᑯᐦᒡ ᐋᒄ ᑳ ᓂᑑᒥᓈᐹᐆᑖᐅᒡ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᐙᐱᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᐋᒄ ᐃᔮᒡ, “ᐆ ᓈᐹᐤ ᒌᓴᔅ ᓂᒧᐃ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋᔨᐤ, ᑖᐹ ᐃᔮᐱᑖᔨᐦᑎᒻ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ᙮” ᐋᒄ ᑯᑎᑭᒡ ᐃᔮᒡ, “ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒫᒥᔥᑳᒡ ᐃᐦᑎᒃ ᐊᐙᓐ ᒥᒋᐦᑑᑎᒧᒀ᙮” ᒌ ᐱᐦᑳᓂᐱᔫᒡ ᒫᒃ ᐅᔮᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᒦᓐ ᑳ ᑯᒀᒋᒫᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᐋᑖᔨᒥᑦ ᒫᒃ ᒌᔨ ᐊᓐ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐄᔅᒃ?” ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᓂᑎᐄᑖᔨᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑖᑆᐦᑎᒧᒡ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒋᐦᒋᐙ ᐋᐦᐋᑳ ᐅᐦᒋ ᐙᐱᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐊᓅᐦᒡ ᒫᒃ ᔖᔥ ᐋ ᐙᐱᐦᑎᒥᔨᒡ᙮ ᐋᒄ ᑳ ᓂᑐᒫᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐅᓃᒋᐦᐄᑯᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ᑳ ᑯᒀᒋᒥᒫᒡ ᐋᐦ ᐄᑎᒥᒫᒡ, “ᐋᐤ ᐋ ᐆ ᒋᑯᓯᐙᐤ ᑳᐦ ᐃᔨᔮᒄ ᐃᔥᑯᑎᒃ ᑳ ᐄᔨᔨᐅᑦ ᔖᔥ ᐋᐦᐋᑳ ᐅᐦᒌ ᐙᐱᐦᑎᐦᒃ? ᑖᓂᑖᐦ ᐙᐦᒋ ᐙᐱᐦᑎᐦᒃ ᐊᓅᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ᐅᓃᒋᐦᐄᒄᐦ ᐋᒄ ᐃᔮᔨᒡ, “ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᐋᐦᐋᐎᑦ ᑖᑆᐦ ᓂᑯᓯᓈᓐ, ᑭᔮᐦ ᑳ ᐄᔨᔨᐅᑦ ᑎᐙᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐙᐱᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ᓂᒧᐃ ᒫᒃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᑖᓂᑖᐦ ᐙᐦᒋ ᐙᐱᐦᑎᐦᒃ ᐊᓅᐦᒡ, ᑭᔮᐦ ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐊᐙᓐ ᑳᐦ ᑐᑎᐙᑦ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ? ᑯᒀᒋᒫᐦᒄ ᐐᐦ ᐊᐙᔨᐤᐦ ᑳ ᒦᓂᐙᒋᐦᐄᑯᑦ, ᐃᔅᐱᐦᑎᓰᐤ ᐙᔥ ᐐᐦ ᐙᒋᒋᐦᒡ ᒑ ᒌ ᐐᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐃᑖᒡ ᐅᒌ ᐅᓃᒋᐦᐄᑯᒫᐅᒡ᙮ ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐋ ᒌ ᐙᔮᔨᐦᑖᒥᔨᒡ ᒑ ᐎᔨᐐᑎᔑᐦᐙᔨᒡ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᐙᔨᐤᐦ ᒑ ᐄᑖᔨᒀᓂᐦᐄ ᐋ ᙭ᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᑭᔮᐦ ᐙᐦᒋ ᐃᑖᒡ, “ᑯᒀᒋᒫᐦᒄ, ᐃᔅᐱᐦᑎᓰᐤ ᐙᔥ ᒑ ᒌ ᐐᐦᑎᒫᑖᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ᐋᒄ ᐊᓂᒌ ᒎᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒦᓐ ᑳᐤ ᑳ ᓂᑐᒫᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᑳ ᐙᐦᒋ ᐙᐱᐦᑎᒥᔨᒡ ᐋᒄ ᐋᑖᒡ, “ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᒫᒥᐦᒋᒻ᙮ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐆ ᓈᐹᐤ ᒌᓴᔅ ᐋ ᒥᒑᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ᐋᒄ ᐃᔮᔨᒡ, “ᑖᐹ ᓂᒋᔅᒑᔨᒫᐤ ᒫᒑᑎᓰᒀ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᒥᒑᑎᓰᒀ ᐆ ᓈᐹᐤ, ᒥᒄ ᓂᒋᔅᒑᔨᐦᑖᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᐙᐱᐦᑎᒫᓐ ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᐋ ᐙᐱᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ᒀᒀᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᒫᒃ ᑳᐦ ᑐᑖᔅᒃ? ᑖᓐ ᑳᐦ ᑐᑎᐦᒃ ᒋᔅᒌᔑᒄ ᒑ ᒌ ᐋᐱᐦᐄᐱᔨᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ᓈᔅᒀᔒᐦᐄᑯᒡ ᐋᔨᑎᑯᒡ, “ᔖᔥ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᐐᐦ ᓂᑑᐦᑖᓈᐙᐤ᙮ ᒑᒀᓐ ᐙᐦᒋ ᓂᑎᐙᔨᒥᔮᒄ ᒦᓐ ᒑ ᒌ ᐃᔮᓐ? ᒋᐐᐦ ᓅᔔᔥᑯᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ᐋᒄ ᑳ ᐃᔮᔅᑖᒫᒻ ᐋᐦ ᐄᑖᒡ, “ᐋᐅᒄ ᒌᔨ ᐹᔨᒄ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓐ ᓈᐹᐤ, ᓃᔮᓐ ᐐᐦ ᒧᓱᔅ ᐋᐅᒄ ᐙᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑖᐎᔨᒥᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᒧᓱᔅ ᐋ ᒌ ᐊᔨᒥᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᐆ ᓈᐹᐤ ᑖᓂᑖᐦ ᐙᐅᐦᒌᑦ ᐐᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ᓈᔅᒀᔒᐦᐄᑯᒡ ᐋᔨᑎᑯᒡ, “ᑖᑆᐦ ᑭᔨᑆ ᒥᔅᑳᑖᔨᐦᑖᑯᓐ, ᐋᐦᐋᑳ ᐙᐙᒡ ᒋᔅᒑᔨᒫᒄ ᑖᓂᑖᐦ ᐙᐦᒌᑦ, ᒥᒄ ᒫᒃ ᑖᑆᐦ ᐙᔥ ᓂᒌᐦ ᑐᑖᒄ ᒑ ᒌ ᐙᐱᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᒋᔖᒥᓂᑑ ᐋᐦᐋᑳ ᓂᑑᐦᑎᐙᑦ ᑳ ᒥᒑᑎᓰᔨᒡ, ᓂᑐᐦᑎᐙᐤ ᒫᒃ ᐐᔨ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐊᔨᒥᐦᐋᔅᑖᑯᑦ ᑭᔮᐦ ᐋᐦ ᑐᑎᒥᔨᒡ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ᑳ ᐃᔥᐱᔥ ᑎᑯᐦᒡ ᐆ ᐊᔅᒌ, ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᐹᐦᑖᑯᓐ ᐊᐙᓐ ᒑ ᒌᐦ ᑐᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ᐊᓐ ᓈᐹᐤ ᑳᐦ ᑐᑎᐎᑦ ᒑ ᒌ ᐙᐱᐦᑎᒫᓐ ᓂᒧᐃ ᓂᐱᐦ ᒌ ᑐᑖᒄ ᒑ ᒌ ᐙᐱᐦᑎᒧᒡ ᐋᑳ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ ᐅᐦᒌᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ᐋᒄ ᓈᔥᒀᔑᐦᐋᒡ ᐋᑖᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᑖᐱ ᒥᒑᑎᓰᐎᓂᐦᒡ ᒋᒌ ᐅᐦᒋ ᐱᒫᑎᓰᓐ, ᐋ ᐄᑖᔨᐦᑎᒥᓐ ᒫᒃ ᐊᔮᐱᒡ ᒑ ᒌ ᒋᔅᑯᑎᒨᔮᐦᒡ᙮” ᐋᒄ ᑳ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒋᐦᒋᐙ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ᒌᓴᔅ ᒫᒃ ᒌ ᐹᐦᑎᒻ ᐋ ᒌ ᐎᔨᐐᑎᔑᐦᐅᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᒄ ᑳ ᓈᓂᑎᐙᐱᒫᑦ᙮ ᒌ ᒥᔅᑯᐙᐤ ᒫᒃ, ᐋᒄ ᐋᑖᑦ, “ᒌ ᑖᑆᔮᔨᒫᐤ ᐋᐦ ᐄᔨᔨᐅᑯᓯᓵᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ᐊᓐ ᓈᐹᐤ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᑦ ᒌᓴᔅᐦ, “ᐹᒋ ᐐᐦᑎᒨᐦ ᐊᐙᓐ ᐊᓐ, ᐋᒄ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᔮᔨᒥᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ᒌᓴᔅ ᐋᑖᑦ, “ᐆ ᑳ ᑭᓂᐙᐱᒥᑦ ᑳ ᐊᔨᒥᐦᐄᔅᒃ, ᐋᐅᒄ ᐙᔥ ᐊᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ᐋᒄ ᐋᑎᑯᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᒋᑖᑆᐦᑖᑎᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ᑳᐦ ᐋᑎᐅᒋᐦᒌᐦᑯᓂᐱᑦ ᐋ ᐊᔨᒥᐦᐋᔅᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ᐋᒄ ᒌᓴᔅ ᐃᔮᑦ, “ᓂᒌ ᐹᒋ ᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᒑᔮᓐ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐙᐱᐦᑎᐦᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ, ᐋᒄ ᐊᓂᒌ ᑳ ᐙᐱᐦᑎᐦᒡ ᐋᑳ ᒑ ᒌ ᐙᐱᐦᑎᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᒌ ᐹᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ, ᐋᒄ ᐋᑖᒡ, “ᒋᔑᓐ ᐋ ᑭᔮᐦ ᓃᔮᓐ ᐋᑳ ᐙᐱᐦᑎᒫᐦᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᐋᑳ ᐙᐱᐦᑎᒫᒄ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐄᑎᑯᓈᐙᐤ ᐋ ᒥᒋᐦᑑᑎᒫᒄ, ᒥᒄ ᒫᒃ ᐋᐦ ᐃᔨᔮᒄ ᓂᐙᐱᐦᑖᓈᓐ, ᐋᑯᑖᐦ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᓯᔮᒄ ᐋᔥᒄ ᐋ ᒥᒋᐦᑑᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ᒌᓴᔅ ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᐙᓐ ᐋ ᒋᒧᑎᔅᒋᐎᑦ ᓂᒧᐃ ᐊᓂᑖᐦ ᐋ ᐃᔥᒀᐦᑎᒥᐎᔨᒡ ᒫᓂᔥᒑᓂᔑᐅᑭᒥᑯᔨᐤ ᐅᐦᒋ ᐲᐦᒑᐤ᙮ ᐃᔨᐦᒡ ᐊᓂᑖᐦ ᐅᐦᒋ ᐹᔅᑖᐦᑎᐎᔨᐤ ᐋ ᐐᐦ ᐲᐦᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ᐋᒄ ᐊᓐ ᐊᓂᑖᐦ ᐋ ᐃᔥᒀᐦᑎᒥᐎᔨᒡ ᒫᓂᔥᒑᓂᔑᐅᑭᒥᑯᔨᐤ ᑳ ᐅᐦᒋ ᐲᐦᒑᑦ ᐋᔪᐎᑯᓐᐦ ᐅᔮᔨᐤ ᐅᑭᓄᒫᓂᔥᒑᓂᔑᐙᓯᒥᐙᐤ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ᐋᐱᐦᐊᒫᑰ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᑭᓅᔥᒀᐦᑎᐙᔨᒡ ᐊᓂᑎᐦ ᒫᓂᔥᒑᓂᔑᐅᑭᒥᑯᐦᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᓂᔥᒑᓂᔥ ᓂᔅᑐᐦᑎᒥᔨᐤ ᐅᐹᐦᑖᑯᓯᐎᓐ ᐄᔥᐱᐦ ᑎᔮᑆᑖᒡ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ, ᐙᔥ ᐐᔨ ᐊᓂᔮᔨᐤ ᐅᒫᓂᔥᒑᓂᔒᒻ᙮ ᐋᒄ ᒫᒃ ᐱᔮᒋ ᐎᔨᐐᔨᒡ ᐋᒄ ᐋᑎ ᓅᔔᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐎᔨᐐᐦᑎᐦᐋᑦ ᐐᔨ ᓃᑳᓂᐦᑖᐤ᙮ ᓅᔔᔥᑳᑰ ᒫᒃ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ ᐙᔥ ᓂᔅᑐᐦᑎᒥᔨᐤ ᐅᐹᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓅᔔᔥᑯᐙᐅᒡ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ᙮ ᒋᑭ ᐅᔑᒫᐅᒡ, ᐙᔥ ᑖᐹ ᓂᔅᑐᐦᑎᒸᐅᒡ ᒫᓂᑖᐤ ᐅᐹᐦᑖᑯᓯᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ᒌᓴᔅ ᒌ ᐐᐦᑎᒧᐙᐤ ᐅᔮᔨᐤ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᒋᒧᐎᓂᔨᐤ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑖᑰ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐋᔨᒨᑎᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᐋᑎᑯᒡ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᓃᔨ ᐋᐅᒄ ᐃᔥᒀᐦᑖᒻ ᐊᓂᑖᐦ ᐙᐦᒋ ᐲᐦᒑᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐙᐦᒋ ᐎᔨᐐᒡ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ᒥᓯᐙ ᑯᑎᑭᒡ ᑳ ᑎᑯᔑᐦᒡ ᐋ ᐐᐦ ᐎᔨᐐᐦᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᑎᑯᔑᓂᔮᓐ, ᒋᒧᑎᔅᑭᒡ ᐐᔨᐙᐤ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᓂᑑᐦᑖᑰᐎᒡ ᐐᔨᐙᐤ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ᓃᔨ ᐋᐅᒄ ᐃᔥᒀᐦᑖᒻ᙮ ᐊᓐ ᐊᐙᓐ ᓃᔨ ᐋᐦᑖᐅᒡ ᑳ ᐅᐦᒋ ᐲᐦᒑᑦ ᒋᑭ ᐱᒫᒋᐦᐆ᙮ ᒥᒄ ᒫᒃ ᐙᐦ ᐃᔥᐱᔥ ᐹᒋ ᐲᐦᒑᑦ ᑭᔮᐦ ᐙᐦ ᐃᔥᐱᔥ ᐎᔨᐐᑦ ᑭᔮᐦ ᒑ ᒥᔅᑭᐦᒃ ᐊᓂᑎᐦ ᒑ ᐅᐦᒋ ᒥᔪᒦᒋᓲᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ᒋᒧᑎᔅᒃ ᑎᑯᔑᓐ ᒥᒄ ᒑ ᒌ ᑭᒑᒧᑎᑦ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᓂᐱᐦᐄᐙᑦ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐄᔮᔨᐎᐦᐄᐙᑦ᙮ ᓃᔨ ᒫᒃ ᐐ ᓂᒌᑎᑯᔑᓐ ᒑ ᒌ ᒥᔨᐙᔮᓐ ᐊᓐ ᐱᒫᑎᓰᐎᓐ ᐙᔪᒡ ᐋᐦᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ᓃᔨ ᐋᐅᒄ ᑭᓄᒫᓂᔥᒑᓂᔑᐙᓯᐤ ᑳ ᒥᔪ ᑭᓂᐙᔨᒫᑦ ᐅᒫᓂᔥᒑᓂᔒᒻ᙮ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᔪ ᑭᓂᐙᔨᒫᑦ ᐅᒫᓂᔥᒑᓂᔒᒻ ᒋᑭ ᐱᒋᔅᑎᓂᒻ ᐅᐱᒫᑎᓰᐎᓐ ᐊᓂᔮᔨᐤ ᐅᒫᓂᔥᒑᓂᔒᒻ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ᐋᒄ ᐊᓐ ᒥᒄ ᑳ ᐅᑖᔅᑯᓈᑭᓅᑦ ᒑ ᒌ ᑭᓂᐙᔨᒫᑦ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ ᐋᐦᐋᑳ ᒫᒃ ᒋᐦᒋᐙ ᑭᓄᒫᓂᔥᒑᓂᔑᐙᓯᐎᑦ, ᐋᐦᐋᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ ᐅᔑᒨ ᐎᔮᐱᒫᒡ ᒥᐦᐄᐦᑭᓐ ᐋ ᑎᑯᔑᓃᔨᒡ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᒥᐦᐄᐦᑭᓐ ᑯᔻᔅᑯᐦᑐᑎᐙᔨᒡ ᐊᓂᔮᔨᐤ ᒫᓂᔥᒑᓂᔥ ᐋᒄ ᓵᒑᐱᐦᐄᑐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ᐅᔑᒨ, ᐙᔥ ᒥᒄ ᒌ ᐅᑖᔅᑯᓈᑭᓂᐤ᙮ ᓂᒧᐃ ᒋᐦᒋᐙ ᐃᔮᐱᑖᔨᒫᐤ ᐊᓂᔮᔨᐤᐦ ᒫᓂᔥᒑᓂᔥᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ᓃᔨ ᐋᐅᒄ ᑭᓄᒫᓂᔥᒑᓂᔑᐙᓯᐤ ᑳ ᒥᔪ ᑭᓂᐙᔨᒫᑦ ᐅᒫᓂᔥᒑᓂᔒᒻ᙮ ᓂᒋᔅᒑᔨᒫᐅᒡ ᓂᒫᓂᔥᒑᓂᔒᒥᒡ ᑭᔮᐦ ᒫᒃ ᐐᔨᐙᐤ ᓂᒋᔅᒑᔨᒥᑯᒡ, ");
INSERT INTO crl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ᒨᔮᒻ ᐅᐦᑖᐐᒫᐤ ᐋ ᐄᔑ ᒋᔅᒑᔨᒥᑦ ᑭᔮᐦ ᒫᒃ ᓃᔨ ᐋ ᐄᔑ ᒋᔅᒑᔨᒥᒃ᙮ ᒥᑐᓐ ᒫᒃ ᓂᑎᐄᑖᔨᐦᑎᒥᐦᐄᑯᐙᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᓯᐎᒡ ᒑ ᒌ ᓂᐱᐦᐄᑯᒡ ᐐᔨᐙᐤ ᐅᐦᒋ ᐊᓂᒌ ᓂᒫᓂᔥᒑᓂᔒᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ᑯᑎᑭᒡ ᒫᓂᔥᒑᓂᔑᒡ ᓂᑎᔮᐙᐅᒡ ᐋᐦᐋᑳ ᐅᑎᐦ ᐅᔮᔨᐤ ᒫᓂᔥᒑᓂᔑᐅᑭᒥᑯᔨᐤ ᐅᐦᒌᒡ᙮ ᑭᔮᐦ ᐐᔨᐙᐤ ᒫᒃ ᔮᔨᑖ ᓂᑭ ᐹᔓᐙᐅᒡ᙮ ᒋᑭ ᓂᑐᐦᑎᒧᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᓂᐹᐦᑖᑯᓱᐎᓂᔨᐤ ᐋᒄ ᒫᒃ ᐹᔨᑯᓂᐦᒡ ᒑ ᒫᒨᔒᒡ ᐊᓂᒌ ᒫᓂᔥᒑᓂᔑᒡ ᑭᔮᐦ ᒋᑭ ᐹᔨᑯᓯᐤ ᐊᓐ ᑭᓄᒫᓂᔥᒑᓂᔑᐙᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᓈᔥᒡ ᓵᒋᐦᐄᑦ ᐅᐦᑖᐐᒫᐤ ᒥᑐᓐ ᐋ ᐱᒋᔥᑖᔨᐦᑎᒫᓐ ᓂᐱᒫᑎᓰᐅᓐ ᒑ ᒌ ᐅᐦᒋ ᒦᓐ ᐱᒫᑎᓰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ᓂᒧᐃ ᐊᐙᓐ ᑭᑎ ᐅᑎᓂᒻ ᓂᐱᒫᑎᓰᐅᓂᔨᐤ᙮ ᓃᔨ ᓂᑳᐎᔮᔨᐦᑖᓐ ᒑ ᐱᒋᔥᑖᐦᔨᑎᒫᓐ ᓂᐱᒫᑎᓰᐅᓐ᙮ ᓂᒌ ᒥᔨᑰᓐ ᓲᐦᑳᑎᓰᐎᓐ ᒑ ᒌ ᐱᒋᔥᑖᔨᐦᑎᒫᓐ ᓂᐱᒫᑎᓰᐆᓐ ᑭᔮᐦ ᓂᒌ ᒥᔨᑰᓐ ᓲᐦᑳᑎᓰᐎᓐ ᒦᓐ ᒑ ᒌ ᐱᒫᑎᓰᔮᓐ᙮ ᓅᐦᑖᐐ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒥᑦ ᒑ ᒌᐦ ᑑᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ᐋᒄ ᒦᓐ ᑳ ᐱᐦᑳᓂᐱᔨᐦᐅᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐄᔥᐱᐦ ᐱᔮᐦᑖᑯᑦ ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ᒥᐦᒑᑐ ᒫᒃ ᐋᒄ ᐃᔮᒡ, “ᒥᒋᐊᐦᒑᐦᒄ ᐲᐦᒋᔥᑳᑰ᙮ ᒌᔅᒀᐤ᙮ ᒑᒀᔨᐤ ᐙᐦᒋ ᓂᑑᐦᑎᐙᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ᑯᑎᑭᒡ ᐐ ᐋᒄ ᐃᔮᒡ, “ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐃᔥᐱᔥ ᒥᔪᐦᑖᑯᓲ ᐊᐙᓐ ᐋ ᐊᔨᒥᑦ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ ᐋ ᐃᔥᐱᔥ ᒥᔪᐦᑖᑯᓯᑦ ᐆ ᓈᐹᐤ᙮ ᑖᓂᑖᐦ ᒋᐱᐦ ᒌ ᐅᐦᒋ ᐃᓯᓈᑯᓂᔨᐤ ᐊᐙᓐ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ ᒑ ᒌᐦ ᑐᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᐙᐱᐦᑎᒥᔨᒡ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ᒫᒀᒡ ᒌ ᐱᐳᓐ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒌ ᐋᑎ ᐅᑎᐦᒋᐱᔨᐤ ᒫᒃ ᐊᓂᑎᐦ ᐋᔑᑯᒻ ᐱᐳᓐ ᑳ ᒌ ᒥᑯᔖᒡ ᐋ ᒋᔥᒋᓯᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳ ᒋᔅᒋᓄᐙᒋᑖᑭᓂᐎᔨᒡ ᐅᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐙᐤ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ᒌᓴᔅ ᒫᒃ ᒫᒀᒡ ᒌ ᐱᐹᒧᐦᑖᐤ ᐊᓂᑖᐦ ᐱᐦᑐᔅᒀᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᔂᓚᒥᓐ ᐅᐱᐦᑐᔅᒀᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ᐋᒄ ᑳ ᐹᒋ ᐙᔅᑳᑳᐳᔥᑖᑯᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤᐦ᙮ ᐋᒄ ᐋᑎᑯᑦ, “ᑖᔨᔥᐱᔥ ᐋᒄ ᒑ ᒥᔮᐦᒡ ᒑ ᒌ ᒋᔅᒑᔨᒥᑖᐦᒡ ᐊᐙᓐ ᒌᔨ ᐃᔮᐎᔨᓐ? ᑯᐃᔅᒄ ᒫᐦ ᐹᒋ ᐐᐦᑎᒨᓈᓐ, ᐋᐤ ᐋ ᒌᔨ ᙭ ᐊᓐ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᔖᔥ ᑯᐃᔅᒄ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᓂᒧᐃ ᒫᒃ ᑰᐦᒋ ᐐᐦ ᑖᑆᐦᑑᓈᐙᐤ᙮ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐹᒋ ᒥᔨᑦ ᓅᐦᑖᐐ ᒑ ᒌ ᐄᔑ ᒫᒥᔥᑳᒡ ᐊᔨᐦᑐᐎᒡ ᑎᐱᔨᐙ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐋᑯᑖᐦ ᓅᑯᐦᒡ ᐊᐙᓐ ᓃᔨ ᐃᔮᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ᒌᔨᐙᐤ ᒫᒃ ᐐ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑖᑆᐦᑑᓈᐙᐤ ᐙᔥ ᑖᐹ ᐊᓂᑖᐦ ᓂᒫᓂᔥᒑᓂᔑᒥᒡ ᐋᐦ ᑖᒡ ᒋᑎ ᐄᔑ ᐐᒋᐦᐄᐙᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ᓂᑐᐦᑎᒧᒡ ᓂᐹᐦᑖᑯᓱᐎᓂᔨᐤ ᓂᒫᓂᔥᒑᓂᔑᒥᒡ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒋᔅᒑᔨᒫᐅᒡ, ᐋᒄ ᒫᒃ ᐱᔮᒋ ᓅᔔᔥᑯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ᓂᒥᔮᐅᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᓂᒧᐃ ᒫᒃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᓂᔑᐎᑎᓯᐎᒡ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐊᐙᓐ ᓂᑭ ᒌ ᒥᔅᑭᒧᒄ ᐋ ᑎᐦᑯᓂᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ᓅᐦᑖᐐ, ᐊᓐ ᑳ ᐹᒋ ᒥᔨᑦ ᐊᓂᔮᔨᐤ, ᐋᐅᒄ ᒫᐅᒡ ᐋᑎᑑ ᓲᐦᒑᔨᐦᑖᑯᓯᑦ ᐃᔥᐱᔥ ᑯᑎᒃ ᐊᐙᔨᐤᐦ᙮ ᓂᒧᐃ ᒫᒃ ᐊᐙᔨᐤᐦ ᑖᔨᐤᐦ ᒑ ᒌ ᒥᔅᑭᒥᑯᑦ ᐋ ᑎᐦᑯᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ᓃᔨ ᑭᔮᐦ ᓅᐦᑖᐐ ᓂᐹᔨᑯᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᐅᐦᒋ ᐅᑎᓈᒡᐦ ᐊᓯᓃ ᒦᓐ ᐋ ᐐᐦ ᐱᒧᔑᓈᑎᐦᐙᒡ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᒥᐦᒑᑣᐤ ᒋᒋᐙᐱᐦᑖᓈᐙᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᒌ ᒥᔪᑐᑎᒫᑎᑯᒡ᙮ ᓂᓈᐦᑭᐤ ᒋᒌ ᓅᑯᐦᑣᑎᓈᐙᐤ ᒥᔪᑐᑎᒫᒑᐎᓐ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐹᒋ ᒥᔨᑦ ᒑ ᒌ ᐙᐱᐦᑏᑎᑯᒡ᙮ ᑖᓐ ᐊᓐ ᑳᐦ ᑐᑎᒫᓐ ᐙᐦᒋ ᐐᐦ ᐱᒧᔑᓈᑎᐦᐅᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ᐋᒄ ᐋᑖᒡ ᐋ ᓂᔅᒀᔑᐦᐋᒡ, “ᓂᒥᔮᐤ ᐐ ᒥᔪᑐᑎᒫᒑᐎᓐ ᐙᐦᒋ ᐐᐦ ᐱᒧᔑᓈᑎᐦᐅᑖᐦᒡ, ᒌ ᒫᔮᔨᐦᒑᓐ ᐋᐅᒄ ᐙᐦᒋ ᐐ ᓂᐱᐦᐄᑖᐦᒡ᙮ ᒋᔑᓐ ᐋ ᒋᔖᒥᓂᑑᐎᔨᓐ ᒥᒄ ᒫᒃ ᐋ ᓈᐹᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᐊᒀᒋᔥᑖᒡ ᒋᐐᔓᐙᐎᓅᐙᐦᒡ, ᓂᒌᐦ ᐃᔨᓐ, ᒨᔮᒻ ᐋ ᒋᔖᒥᓂᑑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᑳᒋᒡ ᐋ ᑖᑆᒥᑭᐦᒡ ᑖᓐ ᐋᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ᙮ ᒥᓂᑑᒡ ᒌ ᐃᔑᓂᐦᑳᑖᐤ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳ ᒥᔮᑭᓂᐎᒡ ᐅᑎᔨᒧᐎᓐ᙮ ᐊᓐ ᒫᒃ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓐ ᓂᒧᐃ ᒋᒃ ᒌ ᐋᐦᑎᓂᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ᓃᔨ ᒫᒃ, ᐅᐦᑖᐐᒫᐤ ᓂᒌ ᐎᔮᔨᒥᒄ ᑭᔮᐦ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐅᒄ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔨᔮᒄ ᐋ ᒫᔮᔨᐦᒑᔮᓐ ᐋ ᐃᔮᓐ, ᐋᐅᒄ ᓃᔨ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ? ");
INSERT INTO crl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ᐋᑳ ᐋᑑᑎᒧᐙᐅᒑ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᓂᑎᐙᔨᒥᑦ ᓅᐦᑖᐐ ᒑ ᒌᐦ ᑐᑎᒧᒡ ᐋᒄ ᑭᔨᑆ ᓂᒧᐃ ᑎᑯᓐ ᒑ ᒌ ᑖᑆᔮᔨᒥᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ᐋᑦ ᐋᑳ ᐐᐦ ᑖᑆᔮᔨᒥᔮᒄ ᐋ ᐃᔮᓐ ᐋᐦ ᐋᐎᒡ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ ᒥᑐᓐ ᒋᐱᐦ ᒑᔥᑎᓈᑖᔨᐦᑎᒥᐦᐄᑯᓈᐙᐤ ᐋ ᐲᐦᒋᔥᑯᑦ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᓃᔨ ᒫᒃ ᐋ ᐲᐦᒋᔥᑰᒃ ᐊᓐ ᐅᐦᒋ ᐋ ᒫᒥᔥᑳᒡ ᐊᔨᐦᑎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ᐋᒄ ᒦᓐ ᑳ ᐐᐦ ᐅᑎᓂᑯᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, ᐐᐦ ᒫᒃ ᒥᒄ ᔖᔥ ᒌ ᐄᒑᐦᑖᐤ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ᐋᒄ ᒌᓴᔅ ᒦᓐ ᑳᐤ ᑳᐦ ᐋᔔᑳᒫᐦᐋᐦᒃ ᐊᓂᔮᔨᐤ ᒞᕐᑎᓐ ᓰᐲᔨᐤ᙮ ᐊᓂᑖᐦ ᑳ ᒌ ᓰᑭᐦᐋᐦᑖᒑᔨᒡ ᒞᓐ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ ᐋᐦ ᐄᔨᔨᒡ, “ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᒫᒥᔥᑳᒡ ᐊᔨᐦᑑ ᒞᓐ, ᒥᒄ ᒫᒃ ᒥᓯᐙ ᑖᑆᒥᑭᓂᔨᐤ ᑖᓐ ᑳ ᐄᑖᒋᒫᑦ ᐅᔮᔨᐤᐦ ᓈᐹᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒌ ᑖᑆᔮᔨᒥᑰ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ᒌᐦ ᑖᐤ ᓈᐹᐤ ᓛᓵᕋᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᓈᔥᒡ ᐋ ᒌ ᐋᐦᑯᓯᑦ᙮ ᐊᓂᑖᐦ ᐯᕠᓃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐐᒋᐤ᙮ ᐅᐐᒋᔖᓂᔅᒀᒻ ᒣᕇ ᑭᔮᐦ ᒫᕐᕧ ᒌ ᐐᒋᒥᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ᐋᐅᒄ ᐆ ᒣᕇ ᑳ ᑯᑎᐱᓂᒸᑦ ᑳ ᒥᔪᒫᑯᓃᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᓯᑎᔨᒡ ᑭᔮᐦ ᐅᔥᑎᒀᓂᐲᐐ ᑳᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᑳᓰᐦᐊᒸᑦ ᐅᓯᑎᔨᐤᐦ᙮ ᐋᐅᒄ ᐆ ᐃᔅᒀᐤ ᐐᒋᔖᓐ ᓛᓵᕋᔅᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ᐊᓂᒌ ᒫᒃ ᐐᒋᓵᓂᔅᒀᐅᒫᐅᒡ ᒌ ᐄᑎᔓᐙᐅᒡ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐐᐦᑎᒨᐙᔨᒡ ᒌᓴᔅᐦ, ᐊᓂᔮᔨᐤ ᐅᐎᒑᐙᑭᓂᔨᐤ ᓛᓵᕋᔅ ᒌᓴᔅᐦ ᑳ ᓵᒋᐦᐋᑦ ᐋᐦ ᐋᐦᑯᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐋᒄ ᐃᔮᑦ, “ᐋᑦ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᐋᐦ ᐋᐦᑯᓯᑦ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᐄᔅᐱᔨᐤ ᐆ ᒑ ᒌ ᓅᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ, ᑭᔮᐦ ᒫᒃ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓂᐎᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ᒌᓴᔅ ᒌ ᓵᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒫᕐᕧ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᔅᒀᒥᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᔨᐤ ᓛᓵᕋᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐐᐦᑎᒧᐙᑭᓅᑦ ᐋᐦ ᐋᐦᑯᓰᔨᒡ ᓛᓵᕋᔅᐦ ᐊᔮᐱᒡ ᒦᓐ ᓃᔓ ᒌᔑᑳᐤᐦ ᒌ ᐄᔅᑉ ᑖᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ᐋᒄ ᐋᑖᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐄᑐᐦᑖᑖᐤ ᒦᓐ ᓈᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ᐋᒄ ᐋᑎᑯᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒋᔅᑯᑎᒫᒑᓯᐤ, ᓂᒧᐃ ᐙᔥᑭᒡ ᑳ ᐐ ᓂᐱᐦᐄᔅᒡ ᐋ ᐹᐦᐱᒧᓯᓈᑎᐦᐆᔅᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᔮᐱᒡ ᒫᒃ ᒦᓐ ᑳᐤ ᒋᐐᐦ ᐄᑐᐦᑖᓐ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓃᔓᔖᑆᐤ ᑎᐦᑣ ᐋᒋᓂᒀᓂᐦᑖᑦ ᒌᔑᑳᐤ ᐹᔨᒀᐤ ᐋ ᒌᔑᑳᒡ᙮ ᐊᐙᓐ ᐱᒧᐦᑖᒑ ᐋ ᒌᔑᑳᔨᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐱᐦᒋᔑᓐ ᐙᔥ ᐙᐱᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐙᔥᑖᐎᓂᔨᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ᐱᒧᐦᑖᒑ ᐊᐙᓐ ᐋ ᑎᐱᔅᑳᔨᒡ ᒋᑭ ᐱᐦᒋᔑᓐ ᐙᔥ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᐙᔥᑖᐎᓂᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ᒌᓴᔅ ᐋᒄ ᐋᑖᑦ, “ᔖᔥ ᓂᐹᐤ ᒋᐐᒑᐙᑭᓂᐤ ᓛᓵᕋᔅ᙮ ᓂᑭ ᓂᑑᐹᑯᓈᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ᐋᒄ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐋᐦ ᐄᑖᒡ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓈᐹᒀ, ᒦᓐ ᐙᔥ ᒋᑭ ᒥᔪ ᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ᒌᓴᔅ ᒫᒃ ᔖᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᓛᓵᕋᔅᐦ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᒥᒄ ᒫᒃ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᔨᐤ ᐅᔮᔨᐤ, ᐋᒄ ᑳ ᐄᑖᔨᒫᒡ ᒌᓴᔅ ᓂᐹᐤ ᐋᐦ ᐄᑖᔨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᓛᓵᕋᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ᐋᒄ ᒌᓴᔅ ᒨᔖ ᐋᑖᑦ, “ᔖᔥ ᓂᒧᐃ ᐱᒫᑎᓰᐤ ᓛᓵᕋᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ᒌᔨᐙᐤ ᐅᐦᒋ ᓂᒥᔻᔨᐦᑖᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᑖᔮᓐ ᒫᒀᒡ ᐋᑳ ᐙᐦᒋ ᒥᔪᐱᔨᑦ ᓛᓵᕋᔅ ᐋᒄ ᒫᒃ ᒑ ᒌ ᑖᑆᔮᔨᒥᔮᒄ᙮ ᒫᒌᑖᐤ ᓂᑎᐙᐱᒫᑖᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ᐋᒄ ᑣᒥᔅ, ᐹᔨᒄ ᐊᓐ ᑳ ᓃᔑᒡ ᐐᒋᔖᓐ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐐᒋᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, “ᒥᓯᐙ ᐋᑯᔥ ᐋ ᑎᔑᔨᐦᒄ ᐐᒑᐙᑖᐤ ᒌᓴᔅ ᑭᔮᐦ ᒌᔮᓂᐤ ᒑ ᒌ ᓂᐱᐦᐄᑭᐎᔨᐦᒄ ᓂᐱᐦᐋᑭᓅᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑖᑯᔑᐦᒃ ᐊᓂᑖᐦ ᒌ ᐐᐦᑎᒧᐙᑭᓂᐤ ᔖᔥ ᓈᐤ ᒌᔑᑳᐤᐦ ᐋ ᒌ ᐃᔥᐱᔥ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᓛᓵᕋᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ᐊᓐ ᒫᒃ ᐃᐦᑖᐎᓐ ᐯᕠᓃ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐹᔓᒡ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᑎᑯᓐ, ᐎᔮᔥ ᓃᔓ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ ᒌ ᐃᔥᐱᔑᓈᑯᓐ ᐊᓂᑖᐦ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ᒥᐦᒑᑐ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐹᒋ ᓂᑎᐙᐱᒫᐅᒡ ᒫᕐᕧ ᑭᔮᐦ ᒣᕇ ᐋ ᐹᒋ ᓂᑑᓈᓂᐦᐋᐐᐦᑯᐙᒡ, ᐐᒋᔖᓂᔨᐤ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ᐄᔥᐱᐦ ᒫᒃ ᒫᕐᕧ ᐱᔮᔨᐦᑎᐦᒃ ᒌᓴᔅ ᐋ ᑎᑯᔑᓃᔨᒡ ᒌ ᐎᔨᐐᐤ ᒑ ᓂᑑᓂᒋᐦᐋᑦ, ᐋᒄ ᐐᔨ ᒣᕇ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ ᐎᒋᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ᐋᒄ ᒫᕐᕧ ᐋᑖᑦ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᔖᔥ ᐅᑎᐦ ᒌ ᑖᐅᐦᐱᓈ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ ᓃᒋᔖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ᒥᒄ ᒫᒃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᐊᔮᐱᒡ ᐋᔥᒄ ᐊᓅᐦᒡ ᒋᔖᒥᓂᑑ ᒑ ᑐᑎᒫᔅᒃ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑐᑎᒧᐙᐅᑖ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ, “ᒦᓐ ᒋᑭ ᐱᒫᑎᓰᐤ ᒌᒋᔖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ᐋᒄ ᒫᕐᕧ ᐋᑖᑦ, “ᓂᒋᔅᒑᔨᐦᑖᓐ ᑖᑆᐦ ᒦᓐ ᒑ ᐎᓂᔥᑳᑦ ᒫᐦᒋᒡ ᒌᔑᑳᔨᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ, “ᐋᐅᒄ ᓃᔨ ᐙᓂᔥᑳᓈᑦ ᐊᐙᔨᐤᐦ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᒫᔨᐙᑦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ᐊᐙᓐ ᒑ ᐹᒋ ᑖᑆᔮᔨᒥᒀ ᒋᑭ ᐱᒫᑎᓰᐤ ᐋᑎ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ᐊᓐ ᐊᐙᓐ ᑳ ᐱᒫᑎᓰᑦ ᐋ ᐹᒋ ᑖᑆᔮᔨᒥᑦ ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᒌ ᑖᑆᐦᑖᓐ ᐋ ᐆ ᑳ ᐄᑎᑖᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ᐋᒄ ᐋᑖᑦ ᒫᕐᕧ, “ᐋᐦᐋ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᓂᑖᑆᐦᑖᓐ ᒌᔨ ᐋᐦ ᐋᐎᔨᓐ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ, ᑭᔮᐦ ᒌᔨ ᐋᐦ ᐋᐎᔨᓐ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ, ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᑎᑯᔑᓃᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ᐄᔥᐱᐦ ᒫᕐᕧ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᒌ ᓂᑎᐙᐱᒫᐤ ᐐᒋᔖᓂᔅᒀᒻ ᒣᕇ ᐋᐦ ᐄᑖᑦ, ᐹᐦᑳᒡ ᐋ ᐊᔨᒥᑦ, “ᒋᔅᒋᓄᐦᐊᒫᓲ ᔖᔥ ᐅᑎᐦ ᑖᐤ᙮ ᒌ ᓂᑑᒥᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ᐄᔥᐱᐦ ᐱᔮᐦᑎᐦᒃ ᒣᕇ ᐅᔮᔨᐤ ᒌ ᐱᓯᑯᔑᐲᐦᑖᐤ ᐋᒄ ᑳ ᐎᔨᐐᑦ ᒑ ᓂᑑᓂᒋᐦᐋᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ᒥᒄ ᒫᒃ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᑎᑯᔑᓐ ᒌᓴᔅ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᐊᓂᑎᐦ ᑳ ᓂᒋᐦᐄᑯᑦ ᒫᕐᕧ ᐋᔥᒄ ᐋᑯᑖᐦ ᑳ ᐹᒋᐦᑖᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᐐᑎᐱᒫᒡ ᒣᕇ ᐋ ᐐᐦ ᓈᓂᐦᐋᐐᐦᑯᐙᒡ ᒌ ᓅᔑᐱᔨᔅᑐᐙᐅᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᓈᔥᒡ ᐋ ᐃᔮᓯᒋᐱᔨᐦᐅᔨᒡ ᐋᐦ ᐋᑎ ᐎᔨᐐᔨᒡ ᐙᔥ ᒌ ᐄᑖᔨᐦᑎᒧᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑳ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᐐᒋᔖᓂᔨᐤ ᐊᓂᑖᐦ ᐋᐦ ᐄᑐᐦᑖᔨᒡ ᒑ ᓂᑑᒫᑑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ᐄᔥᐱᐦ ᒫᒃ ᒣᕇ ᑖᑯᔑᐦᒃ ᐊᓂᑎᐦ ᒌᓴᔅ ᑳᐦ ᑖᔨᒡ ᐎᔮᐱᒫᑦ ᒫᒃ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐆ ᐊᓂᑖᐦ ᐅᓯᑎᔨᒡ, ᐋᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᔖᔥ ᒌ ᑖᐅᐦᐱᓈ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ ᓃᒋᔖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ᐄᔥᐱᐦ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᒣᕇ ᐋ ᒫᑑᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐐᒑᐅᑯᔨᒡ ᐋ ᒫᑑᔨᒡ ᓈᔥᒡ ᒌ ᑖᐦᑭᐦᐅᑰ ᐋᔨᐤᐦ ᒫᒃ ᓈᔥᒡ ᒌ ᒥᓯᒥᑖᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ᐋᒄ ᐃᔮᑦ, “ᑖᓂᑖᐦ ᑳ ᓂᐦᐄᑭᐙᑭᓅᑦ?” “ᐋᔥᑎᒻ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐹᒋ ᐙᐱᐦᑏ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ᒌ ᒫᑑ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐃᔮᒡ, “ᑖᑆᐦ ᒌ ᓵᒋᐦᐋᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᓛᓵᕋᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ᒌᐦ ᑖᐅᒡ ᒫᒃ ᐹᔅᒡ ᐋᐦ ᐄᑖᒡ, “ᒌᐦ ᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᓈᐹᐤ ᒑ ᒌ ᐙᐱᐦᑎᒥᔨᒡ᙮ ᑖᓂᑖᐦ ᐙᐦᒋ ᐋᑳ ᐅᐦᒌ ᑐᑎᐙᑦ ᓛᓵᕋᔅᐦ ᐋᑳ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ᒌᓴᔅ ᒫᒃ ᒦᓐ ᒌ ᒨᔑᐦᑖᐤ ᓈᔥᒡ ᐋ ᑭᓯᑯᑖᐦᐋᑦ᙮ ᐋᒄ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑳ ᐙᑎᒀᐱᔅᑭᐦᐄᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᑳ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᓛᓵᕋᔅᐦ, ᒌ ᒋᐱᑳᐳᐦᐄᒫᑭᓂᐎᔨᑖᑯᐱᓐ ᐋ ᒥᓯᒋᔅᑏᔨᒡ ᐊᓯᓃ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ᐋᒄ ᒌᓴᔅ ᐃᔮᑦ, “ᐄᒑᑎᐦᑎᐱᓈᐦᒄ ᐊᓐ ᐊᓯᓃ᙮” ᐋᒄ ᐋᑎᑯᑦ ᒫᕐᕧ, ᐊᓂᔮᔨᐤ ᓛᓵᕋᔅ ᐐᒋᔖᓂᔅᒀᒻ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᔖᔥ ᒋᑭ ᒥᔮᑯᓐ, ᐙᔥ ᔖᔥ ᓈᐤ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐴᓂᐱᒫᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᒫᕐᕧ, “ᓂᒧᐃ ᐋ ᔖᔥ ᑯᐦᒋ ᐐᐦᑎᒫᑎᓐ, ᑖᑆᐦᑎᒥᓈ ᒑ ᐙᐱᐦᑎᒧᑦ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ᐋᒄ ᑳ ᐄᒑᐦᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ᙮ ᒌᓴᔅ ᒫᒃ ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᑖᐱᑦ ᒌ ᐃᔨᐤ, “ᓅᐦᑖ ᒌ ᓂᓈᔅᑯᒥᑎᓐ ᐋ ᐹᒋ ᓂᑐᐦᑎᐎᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ᓂᒋᔅᒑᔨᐦᑖᓐ ᒨᔥ ᐋ ᐹᒋ ᓂᑐᐦᑎᐎᔨᓐ, ᒥᒄ ᒫᒃ ᓂᔑᓐ ᐆ ᒑ ᒌ ᑖᑆᐦᑎᐦᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᒌᔨ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᒌ ᒋᔣᐙᐤ ᐋᐦ ᐃᔨᑦ, “ᓛᓵᕈᔅ, ᐹᒋ ᐎᔨᐐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ᒌ ᐹᒋ ᐎᔨᐐᐤ ᐊᓐ ᓈᐹᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᐅᑎᐦᒌ ᑭᔮᐦ ᐅᓯᑦ ᐋ ᐐᔥᒀᔮᐱᐦᑳᑖᔨᒡ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᑭᔮᐦ ᐅᑖᔅᑎᒥᐦᒄ ᐋ ᒌ ᐱᔅᑯᔮᒋᓂᑭᓄᐐᒡ᙮ ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐋᐱᐦᑯᓈᐦᒄ, ᒑ ᐱᒋᔅᑎᓈᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ᒥᐦᒑᑐ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᐹᒋ ᒫᐆᑎᑖᒡ ᒣᕇ, ᒌ ᐙᐱᐦᑎᒧᒡ ᑖᓐ ᑳ ᐃᔨᐦᑎᔨᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᒌ ᑖᑆᔮᔨᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ᐊᔮᐱᒡ ᒫᒃ ᐱᔅᒡ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ ᐋ ᐐᐦᑎᒧᐙᒡ ᑖᓐ ᑳ ᐄᔨᐦᑎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᓂᔥᑑᓈᐅᒡ ᑳ ᐅᒋᒫᐐᔨᒡ ᑳ ᒫᒨᐱᔨᒡ, ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᒑ ᑎᔨᐦᒄ᙮ ᓈᔥᒡ ᒥᐦᒑᑐ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑐᐎᓂᔨᐤ ᐋᐦ ᑐᑎᐦᒃ ᐊᓐ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ᓂᐦᐋᔨᒫᐦᒀ ᒑ ᒌᐦ ᑎᒃ ᐅᔮᔨᐤ ᑖᓐ ᐋᐦᑎᒃ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒑᒃ ᒋᑭ ᑖᑆᔮᔨᒥᑰ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᕎᒻ ᑎᐹᔨᐦᒋᒑᓯᐎᒡ ᒑ ᑎᑯᓯᒡ ᒑ ᐃᔮᔪᐦᑖᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᐱᔮᐦᑭᓃᔨᒡ ᒋᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᓈᔨᐤ ᑭᔮᐦ ᒥᓯᐙ ᒌᔮᓂᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓲᐦᒄ ᒋᑭ ᓂᔑᐎᓈᒋᐦᐄᑯᓅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ᐹᔨᒄ ᒫᒃ ᐊᓐ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳᔮᕙᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᒫᒀᒡ ᑳ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐅᑦ ᐊᓂᔮᔨᐤ ᑳ ᐱᐳᓃᔨᒡ ᒌᐦ ᐄᑖᐤ, “ᑖᑆᐦ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒑᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ᓂᒧᐃ ᐋ ᒋᒌ ᓂᔅᑐᐦᑖᓈᐙᐤ ᐊᐅᔅᑖ ᒑ ᒥᔪᐱᔮᒄ ᐹᔨᒄ ᓈᐹᐤ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒃ ᐅᐱᒫᑎᓰᐎᓐ ᐄᔨᔨᐤ ᒑ ᒌ ᐱᒫᒋᐦᐅᔨᒡ ᐃᔥᐱᔥ ᐐ ᒥᓯᐙ ᒌᔮᓂᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓰᐦᒄ ᒑ ᒌ ᓂᔑᐎᓈᒋᐦᐄᑭᐎᔨᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ᓂᒧᐃ ᐐᔨ ᐙᒋᐦᒡ ᑳᔮᕙᔅ ᑳᐦ ᐃᔨᑦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑖᑦ, ᐙᔥ ᐐᔨ ᒫᒀᒡ ᐋ ᒌ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐅᑦ ᐊᓂᔮᔨᐤ ᑳ ᐱᐳᓃᔨᒡ ᐋᐅᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᒥᔨᑯᑦ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᒑ ᒌ ᐃᔨᑦ ᐋ ᒋᔅᒋᐙᐦᐄᒑᑦ, ᒌᐦ ᐄᑖᐤ ᒌᓴᔅᐦ ᒑ ᐱᒋᔅᑎᓂᒦᒡ ᐅᐱᒫᑎᓯᐎᓂᔨᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ᓂᒧᐃ ᒫᒃ ᒥᒄ ᒎᐄᔨᔨᐤ ᐅᐦᒋ ᒑ ᐱᒋᔅᑎᓂᒥᔨᒡ ᐅᐱᒫᑎᓯᐎᓂᔨᐤ, ᒥᓯᐙ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑᐦ ᐅᑏᔨᔨᒥᔨᐤᐦ ᐹᐦᐲᑐᔥ ᑳᐦ ᑖᔨᒡ ᒑ ᒫᒨᓈᔨᒡ, ᒑ ᒌ ᐹᔨᑯᑖᐆᓯᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᒌᔑᑳᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐦᑖᒡ ᐋ ᓈᓂᑐ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᒑ ᑎᒡ ᒑ ᒌ ᓂᐱᐦᐋᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐙᐦᒋ ᐋᑳ ᐅᐦᒋ ᑖᑦ ᒌᓴᔅ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ᙮ ᒌ ᒋᔅᑐᐦᑖᐤ ᐋᒄ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᔨᐤ ᐁᕝᕌᔨᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐹᔓᒡ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᑯᑖᐦ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ᒌ ᐹᔓᓈᑯᓐ ᒫᒃ ᐊᓐ ᒎᐤ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓐ᙮ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᐹᒋ ᐄᑐᐦᑖᐅᒡ ᒋᕉᓯᓕᒥᐦᒡ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ ᐋ ᐹᒋ ᑎᑯᔑᐦᒡ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐐᔥᑖᔨᒡ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᐦᒡ ᒑ ᑐᑎᒧᐙᑯᐱᓈ ᒑ ᒌ ᐱᔮᐦᒋᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ᒥᐦᒑᑐ ᒫᒃ ᐅᒌ ᐄᔨᔨᐅᒡ ᒌ ᒫᐅᓲᑯᒡ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᓈᓂᑐᐙᐱᒫᒡ ᒌᓴᔅᐦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑯᒀᒋᒥᑐᒡ, “ᑖᓐ ᐋ ᐄᑖᔨᐦᑎᒥᓐ ᒌᔨ, ᒋᑭ ᐹᒋ ᓈᒋ ᒥᑯᔖᐤ ᐋ ᒋᑎᐄᑖᔨᒫᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐹᕆᓰᒡ ᒌ ᐄᑎᔓᐙᐦᑖᐙᑯᐱᓐ ᔮᔨᑖ ᒑ ᐐᐦᑎᒥᔨᒡ ᐊᐙᔨᐤᐦ ᒋᔅᒑᔨᒫᔨᒑᓂᐦᐄ ᑖᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᑑᐅᑎᓂᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ᑯᑣᔥᒡ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒌ ᐃᔥᐱᔑᓈᑯᓂᔨᐤ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓂᔨᐤ, ᒌᓴᔅ ᑳ ᑎᑯᔑᐦᒃ ᐊᓂᑖᐦ ᐯᕠᓃᐦᒡ ᐊᓂᑖᐦ ᓛᓵᕋᔅᐦ ᐐᒋᔨᐦᒡ, ᐊᓂᔮᔨᐤ ᑳ ᐙᓂᔥᑳᓈᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ᒌ ᒥᑯᔖᐦᐋᑭᓂᐤ ᒫᒃ ᒌᓴᔅ ᐊᓂᑖᐦ, ᒫᕐᕧ ᒌ ᐐᒋᐦᐄᐙᐤ ᐋ ᒫᑎᓂᐙᓂᐎᔨᒡ, ᐋᒄ ᓛᓵᕋᔅ ᑳ ᐐᑎᐱᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᒦᒋᓱᓈᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ᒣᕇ ᒌ ᐅᐦᒋ ᐅᑎᓂᒻ ᐲᔻᐱᔅᑯᔮᑭᓂᔨᐤ, ᐋ ᐲᐦᒋᔥᑎᓃᔨᒡ ᐊᓂᑎᐦ ᑳ ᐐᒋᔅᑰᑭᓃᒡ ᑑᒥᓂᑭᓂᔨᐤᐦ ᓈᔥᒡ ᐋ ᒌ ᐋᔨᒥᒋᑖᑯᓃᔨᒡᐦ᙮ ᑳ ᑯᑎᐱᓂᒸᑦ ᐊᓂᑖᐦ ᒌᓴᔅᐦ ᐅᓯᑎᔨᒡ, ᐋᒄ ᑳ ᐹᐦᑯᓯᑖᓈᑦ ᐅᔥᑎᒀᓂᐱᐎᔾ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᑖᐦ ᐲᐦᑎᑭᒥᐦᒡ ᐊᓂᔮᔨᐤᐦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤᐦ ᒌ ᒥᔮᑯᓂᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᐐᒋᔅᑰᑭᓃᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᒍᑖᔅ ᐃᔅᑳᕆᔨᑦ, ᐊᓂᔮᔨᐤ ᒑ ᒫᒥᔑᒥᑯᑦ, ᐋᒄ ᐃᔮᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ᓂᔥᑣᐤ ᒥᑖᐦᑐᒥᑐᓂᐤ ᑳ ᐙᐹᐱᔅᒌᒡ ᐲᔻᐱᔅᑯᓯᒡ ᒋᐱᐦ ᒌ ᐄᑎᒋᐦᑖᑯᓐ ᒌ ᐊᑖᐙᒑᓅᒡ ᐊᓐ ᑳ ᐐᒋᔅᑰᑭᐦᒡ ᑑᒥᓂᑭᓐ᙮ ᐋᒄ ᐊᓐ ᔓᐎᔮᓐ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒋᐱᐦ ᒌ ᒥᔮᑭᓄᐦᑖᐙᑰᐱᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ᓂᒧᐃ ᐐᔨ ᐋ ᒋᔅᑎᒫᒑᔨᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐃᔨᑦ, ᐐᔨ ᒋᐐᐦ ᐅᑎᓂᒫᓲ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᐙᔥ ᐋᐅᒄ ᑳ ᒌᐦ ᑎᒃ ᒫᓐ ᐐᔨ ᑳ ᒌ ᓈᓈᑭᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐅᔓᐎᔮᓂᒧᐙᐤ ᒫᔮᑭᓅᑣᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ᒥᒄ ᒫᒃ ᒌᓴᔅ ᐋᑖᑦ ᒍᑕᔅᐦ, “ᐊᑳᐐ ᐱᒫᔨᒻ, ᐙᔥ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋᑑᑎᐎᑦ ᒧᔮᒻ ᐋᐦ ᐋᔮᔅᑳᐐᐦᑐᑖᐆᑦ ᐃᔥᐱᔥ ᐅᑎᐦᒋᐱᔨᒑ ᒑ ᓂᐦᐄᑳᑯᒡ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ᒨᔥ ᒋᑭ ᑖᐅᒡ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐋᐦᑖᐙᒄ, ᓃᔨ ᒫᒃ ᔖᔥ ᐹᓲᓈᑰᓐ ᒑᐦ ᐋᑳ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ᒥᐦᒑᑐ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐹᐦᑎᒧᒡ ᐊᓂᑖᐦ ᐯᕠᓃᐦᒡ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒑ ᒌ ᓂᑎᐙᐱᒫᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓛᓵᕋᔅᐦ ᒋᐐᐦ ᐙᐱᒫᐅᒡ, ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᑳ ᐎᓂᔥᑳᓈᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ᒌ ᐎᔮᔨᐦᑎᒧᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᓛᓵᕋᔅᐦ ᑭᔮᐦ ᒑ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ᐙᔥ ᐊᓂᔮᔨᐤ ᓛᓵᕋᔅᐦ ᐅᐦᒋ ᐋᔪᐎᒄ ᐙᐦᒋ ᓂᑭᑎᑯᒡ ᒥᐦᒑᑐ ᒎᐄᔨᔨᐤ ᑭᔮᐦ ᒫᒃ ᒌᓴᔅᐦ ᐋᔨᐅᑯᓐ ᑳ ᑖᑆᔮᔨᒫᐃᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ᒦᓐ ᐎᔮᐱᓃᔨᒡ ᒥᐦᒑᑐ ᒌᒫᐆᔑᑯᒡ ᐊᓂᒌ ᑳ ᑎᑯᔑᐦᒡ ᐊᓂᑖᐦ ᐋ ᒥᑯᔖᓂᐎᔨᒡ ᒌ ᐹᐦᑎᒧᒡ ᒌᓴᔅᐦ ᒑ ᑎᑯᔑᓃᔨᒡ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ᐋᒄ ᑳ ᓈᑣᓂᐦᒡ ᓃᐱᓰᔮᐦᑎᒄ ᑳᐦ ᐋᑎ ᐎᔨᐐᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᓂᑑᓂᒋᐦᐋᒡ, ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᒡ ᐋ ᒋᔣᐙᒡ, “ᒫᒥᐦᒋᒫᑖᐤ ᒋᔖᒥᓂᑑ, ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ, ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ᒌᓴᔅ ᒫᒃ ᒌ ᑖᐦᑎᐱᐤ ᐋᐦᐋᓯᔅ ᐋ ᒌ ᒥᔅᑭᐙᑯᐱᓈ᙮ ᐋᐅᒄ ᐅᔮᔨᐤ ᑳᐦ ᑎᒃ ᒧᔮᒻ ᑖᓐ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᒑ ᑎᑯᐱᓈ, ");
INSERT INTO crl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","ᐊᑳᐐ ᑯᔥᑖᒋᒄ ᒌᔨᐙᐤ ᓵᐃᔨᓂᐦᒡ ᑳ ᐅᐦᒋᔮᒄ ᐙᔥ ᒋᐦᒋᐅᒋᒫᒧᐙᐤ ᐹᒋ ᑎᑯᔑᓐ ᐋ ᑖᐦᑎᐱᑦ ᐋᐦᐋᓯᔅ ᐅᑯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ᐊᓂᑎᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᒫᒀᒡ ᓂᒧᐃ ᐱᑦ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒥᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᔖᔥ ᐊᓂᑖᐦ ᓃᑳᓐ ᐋ ᒌ ᐐᐦᑖᑭᓄᐐᑯᐱᓈ ᒑ ᑎᐱᐱᔨᒡ ᐅᔮᔨᐤ᙮ ᐹᑎᒫ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᐎᓂᔥᑳᓂᒫᑭᓂᐎᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᑭᔮᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐄᔑ ᐅᑎᓂᒫᑭᓂᐐᔨᒡ ᐋᒄ ᑳ ᒋᔥᒋᓯᒡ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐋᔨᒨᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑖᑆᐦ ᑭᔨᑆ ᐋ ᒌᐦ ᑐᑎᒫᑭᓄᐐᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒥᓯᓈᑖᔨᒡ ᒑ ᐄᑐᐦᑎᒫᑭᓅᐐᑯᐱᓈᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᑖᐙᑯᐱᓈ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᑳ ᑖᑆᑖᔨᒡ ᓛᓵᕋᔅᐦ ᒑ ᒌ ᐹᒋ ᐎᔨᐐᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᑳ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᒌ ᐙᐦ ᐐᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᐦᒡ ᑳ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ᐋᔪᐎᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᓂᑑᓂᒋᐦᐋᒡ ᒌᓴᔅᐦ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᑖᑯᔑᓃᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐹᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ᐊᓂᒌ ᐹᕆᓰᒡ ᐋᒄ ᐋᑎᑐᒡ, “ᓂᒧᐃ ᒋᒌ ᑐᑎᐙᓂᐤ ᐋᑳ ᒑ ᒌ ᓅᔔᔥᑳᑯᑦ ᐊᐙᔨᐤᐦ, ᑭᓂᐙᐱᒫᐦᒄ ᒫᐦ, ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐐᐦ ᓅᔔᔥᑳᑰ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ᒌ ᐐᒋᐦᐄᐙᐅᒡ ᒫᒃ ᒃᕇᒃ ᐄᔨᔨᐅᒡ ᐋᐦ ᐄᑐᐦᑖᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᓂᑑᐊᔨᒥᐦᐋᔅᑖᒫᑭᓂᐐᔨᒡ ᒋᔖᒥᓂᑑ ᒫᒀᒡ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᒥᑯᔖᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ᐋᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᑳ ᐹᒋ ᓂᑎᐙᐱᒫᒡ ᕕᓕᑉ, ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᐱᕪᓭᐃᑖ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐅᐦᒌᔨᒡ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ, ᐋᒄ ᐋᐦ ᐄᑖᒡ, “ᓂᐐ ᐙᐱᒫᓈᓐ ᒌᓴᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ᕕᓕᑉ ᒫᒃ ᒌ ᓂᑑᐐᐦᑎᒧᐙᐤ ᐋᓐᑎᕉ ᐋᒄ ᑖᐱᔥᑯᓐ ᑳ ᓂᑑᐐᐦᑎᒧᐙᒡ ᒌᓴᔅᐦ ᐋ ᐐᐦ ᐙᐱᒥᑯᔨᒡ ᐊᓂᔮᔨᐤ ᒃᕇᒃ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᒡ, “ᔖᔥ ᐅᑎᐦᒋᐱᔨᐤ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐙᐱᐦᑏᐙᑦ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᐄᔨᔨᐅᑯᓯᓵᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ᑖᑆ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᒥᔔ ᐋᑳ ᐄᑖᒥᐦᒡ ᐊᔅᒌᐦᒡ ᐊᔥᑖᑭᓅᐦᒑ ᐹᔨᒄ ᐱᐦᒀᓯᑭᓂᒥᓐ ᒥᒄ ᐋ ᓂᔮᔅᑑᐦᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᐦᑖᐅᒋᓐ, ᒥᒄ ᒫᒃ ᐊᔥᑖᑭᓅᐦᒑ ᐄᑖᒥᐦᒡ ᐊᔅᒌᐦᒡ ᐋᑎ ᓂᐲᒥᑭᐦᒑ ᒫᒃ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᒡ ᒥᐦᒑᑐ ᓂᑖᐅᒋᐦᒋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ᐊᓐ ᐊᐙᓐ ᑳ ᓵᒋᐦᑖᑦ ᐅᐱᒫᑎᓰᐎᓐ ᑭᑎ ᐎᓂᐦᑖᐤ᙮ ᐊᓐ ᐊᐙᓐ ᑳ ᐅᐦᑳᑎᐦᒃ ᐅᐱᒫᑎᓰᐎᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᑭᑎ ᐃᔮᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᓃᔨ ᒑ ᐋᐱᑎᔒᔥᑑᑦ ᔮᔨᑖᐃ ᓂᑭ ᐹᒋ ᓅᔔᔥᑳᒄ᙮ ᐋᒄ ᒫᒃ ᒑ ᑖᑦ ᓂᑖᐱᒋᐦᐋᑭᓐ ᑖᓂᑖᐦ ᒑ ᐋᑎ ᐃᔨᐦᑖᐅᒡ᙮ ᑭᑎ ᒋᔅᑖᔨᒥᑰ ᓅᐦᑖᐐ ᐊᓐ ᐊᐙᓐ ᒑ ᐋᐱᑎᔒᔥᑑᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ᓈᔥᒡ ᒥᓯᒫᔨᐦᑎᒻ ᓂᑎᐦᒑᐦᒄ, ᑖᓐ ᒫᒃ ᒑ ᒌ ᐄᑎᒄ ᓅᐦᑖᐐ᙮ ᓂᑭ ᐄᑖᐤ ᐋ, ᓅᐦᑖ, ᐊᑳᐐ ᐹᒋ ᐱᒋᔅᑎᓐ ᒑ ᒌ ᓂᓈᐦᑳᑖᔨᒧᔮᓐ᙮ ᓂᒧᐃ, ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᐄᑖᐤ ᐅᔮᔨᐤ ᐙᔥ ᐋᐅᒄ ᐙᐦᒋ ᑎᑯᔑᓂᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᓂᓈᐦᑳᑖᔨᒧᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ᓅᐦᑖ, ᒋᔅᑖᔨᐦᑖᑯᑖᐦ ᒋᑎᔑᓂᐦᑳᓱᐎᓐ᙮” ᐋᒄ ᐱᔮᒡ ᐹᐦᑖᑯᓃᔨᒡ ᒋᔖᒥᓂᑑᐦ ᐅᐹᐦᑖᑯᓯᐎᓐ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ ᐋᐦ ᐃᔨᑦ, “ᔖᔥ ᓂᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᑖᓐ ᓂᑎᔑᓂᐦᑳᓱᐎᓐ ᒦᓐ ᒫᒃ ᓂᑭ ᒋᔅᑖᔨᐦᑖᑯᐦᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᓃᐴᐎᒡ ᐱᔮᑖᐦᒡ ᐊᓂᔮᔨᐤ ᐹᐦᑖᑯᓯᐎᓂᔨᐤ ᐋᒄ ᐃᔮᒡ, “ᓂᒥᔅᒋᐅᒡ ᐹᐦᑖᑯᓯᐎᒡ᙮” ᐋᒄ ᑯᑎᑭᒡ ᑳᐦ ᐃᔨᒡ, “ᐋᓐᒋᓐ ᒌ ᐊᔨᒥᐦᐄᑰ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ᐋᒄ ᒌᓴᔅᐦ ᐃᔮᑦ, “ᐆ ᐹᐦᑖᑯᓯᐎᓐ ᑳᐦ ᐹᐦᑖᑯᐦᒡ ᓂᒧᐃ ᐹᐦᑖᑯᓐ ᓃᔨ ᐅᐦᒋ, ᒥᒄ ᒌᔨᐙᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ᐊᓅᐦᒡ ᐅᑎᐦᒋᐱᔨᐤ ᒑ ᒌ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ ᑭᔮᐦ ᐊᓅᐦᒡ ᐋᒄ ᐙᑎᐦᒋᐱᔨᔨᒡ ᒑ ᒌ ᐃᔥᐱᔑᐦᐋᑭᓅᑦ ᒥᒋᒥᓂᑑ, ᐊᓐ ᑳ ᑎᐹᔨᐦᒋᒑᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ᐄᔥᐱᐦ ᐅᐦᐱᓂᑯᔮᓈ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ, ᒥᓯᐙ ᐊᐙᓐ ᓂᑭ ᑐᑎᐙᐤ ᒑ ᒌ ᐹᒋ ᓈᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᒌ ᐐᐦᑎᒻ ᑖᓐ ᒑ ᐄᔑ ᓂᐱᐦᐋᑭᓅᑦ ᒑ ᐅᐦᐹᔅᑯᐦᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ᐋᒄ ᐊᓂᔮᔨᐤ ᑳᐦ ᒫᒨ ᒥᒑᐦᑎᔨᒡ ᐄᔨᔨᐤᐦ ᐋᑎᑯᑦ, “ᓂᐐᐦᑎᒫᑯᓈᓐ ᐊᓂᑖᐦ ᓂᐐᔓᐙᐎᓈᐦᒡ, ᙭ ᒨᔥ ᑳᒋᒡ ᐋᐦ ᑖᑦ᙮ ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᐃᔨᓐ, ᐄᔨᔨᐅᑯᓯᓵᓐ ᒑ ᐅᐦᐹᔅᑯᐦᐙᑭᓅᑦ ᐋ ᓂᐱᐦᐋᑭᓅᑦ? ᐊᐙᓐ ᐊᓐ ᐄᔨᔨᐅᑯᓯᓵᓐ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐙᐃᐱᔥᒌᔥ ᒦᓐ ᒋᑭ ᑎᑯᓐ ᐙᔥᑖᐎᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ᐱᒧᐦᑖᒄ ᐋᔥᒄ ᐋ ᐃᔮᔮᒄ ᐙᔥᑖᐎᓐ ᒑᐦ ᐋᑳ ᒫᒃ ᐊᑯᓅᐦᐆᑰᔮᒄ ᐋᐆᑳᔅᑖᔮᐎᓐ᙮ ᐊᐙᓐ ᐋ ᐱᒧᐦᑖᑦ ᐊᓂᑖᐦ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓂᑖᐦ ᐋᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ᑖᑆᔮᔨᒫᐦᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᔨᐙᑦ ᐙᔥᑖᐎᓂᔨᐤ ᐋᔥᒄ ᐋᐦ ᑖᑦ ᐅᑎᐦ ᐋᐦᑖᐙᒄ, ᐋᒄ ᒧᔮᒻ ᒫᒃ ᐋ ᐅᑎᐙᔑᔒᒥᑖᑰᔮᒄ ᐙᔅᑖᐎᓐ᙮” ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᒌᓴᔅ ᐋᒄ ᑳ ᓂᑭᑖᑦ, ᐊᓂᑖᐦ ᐋᑳ ᒑ ᒥᔅᑳᑯᑦ ᐋᑯᑖᐦ ᑳ ᓂᑑᐃᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ᐋᑦ ᒫᒃ ᒥᐦᒑᑣᐤ ᓈᔥᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᒡ ᒑᒀᔨᐤ ᐋ ᒌᐦ ᑐᑎᐦᒃ ᐊᓂᑎᐦ ᒎᐤ ᐋᐦ ᑖᔨᒡ ᐊᔮᐱᒡ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑖᑆᔮᔨᒥᑰ ᐐᔨ ᐋᐦᐋᐎᑦ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ᐋᐅᒄ ᑖᑆᐦ ᑳ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᒧᑯᐱᓈ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᐋ ᒌ ᐃᔨᑯᐱᓈ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐊᐙᓐ ᑎᔮᑆᐦᑐᔨᒥᐦᑦ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᐦᒡ? ᐊᐙᔨᐤᐦ ᑳ ᐙᐱᐦᑏᔮᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᓲᐦᑳᑎᓰᐎᓐ? ");
INSERT INTO crl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ᐋᔪᐎᒄ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᑖᑆᐦᑎᒥᔨᒡ᙮ ᐋᐃᓵᔮ ᐋᔨᐤ ᑭᔮᐦ ᐋ ᒌ ᐃᔨᑯᐱᓈ, ");
INSERT INTO crl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","ᒋᔖᒥᓂᑑ ᒌ ᑐᑖᑯᒡ ᐋᑳ ᒑ ᒌ ᐙᐱᐦᑎᐦᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒡ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᐙᐱᐦᑎᒧᒡ ᑭᔮᐦ ᓂᒧᐃ ᓂᔅᑐᐦᑎᒧᒡ᙮ ᓂᒧᐃ ᒫᒃ ᓂᐐ ᐹᒋ ᓂᑎᐙᐱᒥᑯᒡ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᒀᐤ, ᐃᔨᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ᐋᐃᓵᔮ ᒌ ᐃᔨᐤ ᐅᔮᔨᐤ ᐙᔥ ᒌ ᐙᐱᐦᑎᒸᐤ ᒌᓴᔅᐦ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓂᔨᐤ, ᐋᒄ ᒫᒃ ᑳᐦ ᐋᔨᒨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ᒥᐦᒑᑐ ᒫᒃ ᐊᔮᐱᒡ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᒌᓴᔅᐦ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐋᔨᒨᑎᒧᒡ ᐊᓂᑖᐦ ᐋ ᐹᐦᑎᐙᑭᓂᐎᒡ ᐙᔥ ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐹᕆᓰᐦ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑎᒧᒡ ᒋᐦᒋᐙ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᑭᓂᐎᒡ ᐊᓂᑎᐦ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ᐙᔥ ᐊᐅᔅᑖ ᒌ ᐄᑖᔨᒫᐅᒡ ᐄᔨᔨᐤ ᒑ ᒌ ᒫᒥᐦᒋᒥᑯᒡ ᐃᔥᐱᔥ ᐐᔨ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᒫᒥᐦᒋᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ᒌᓴᔅ ᒫᒃ ᒌ ᐃᔨᐤ ᐋ ᒋᔣᐙᑦ, “ᐊᐙᓐ ᑎᔮᑆᔮᔨᒥᒀ ᓂᒧᐃ ᒥᒄ ᓃᔨ ᓂ ᐹᒋ ᑖᑆᔮᔨᒥᒄ ᑭᔮᐦ ᑖᑆᔮᔨᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ᐊᓐ ᐊᐙᓐ ᐹᒋ ᐙᐱᒥᑦ, ᐙᐱᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ᓂᒌᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋ ᐙᔅᑖᐎᓅᔮᓐ ᒥᓯᐙ ᒫᒃ ᐊᓐ ᒑ ᑖᑆᔮᔨᒥᒀ ᓂᒧᐃ ᔖᔥ ᑭᑖ ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ᐊᓐ ᐊᐙᓐ ᐱᔮᐦᑎᒧᒀ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᓐ ᐋᑳ ᒫᒃ ᓂᓂᐦᐄᐦᑎᒧᒀ, ᓂᒧᐃ ᓃᔨ ᓂᑭ ᑎᐹᔅᑯᓈᐤ᙮ ᓂᒌᑎᑯᔑᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᓂᒧᐃ ᐐᐦ ᒑ ᒌ ᑎᐹᔅᑯᓂᒀᐤ ᐄᔨᔨᐅᒡ ᒥᒄ ᒫᒃ ᓂᒌᑎᑯᔑᓐ ᒑ ᒌ ᐱᒫᒋᐦᐄᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ᐊᓐ ᐊᐙᓐ ᐃᔮᑐᐙᔨᒥᒀ, ᑭᔮᐦ ᐋᑳ ᓂᓂᐦᐄᐦᑎᒧᒀ ᓂᑏᔨᒧᐎᓂᔨᐤ, ᒋᑭ ᑎᐹᔅᑯᓈᑭᓂᐤ᙮ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳᐦ ᐃᔨᐅᒡ ᓂᑏᔨᒧᐎᓂᔨᐤ ᐋᐅᒄ ᐊᓂᔮᔨᐤ ᒑ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑭᓅᑦ ᒫᐦᒋᒡ ᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ᓂᒧᐃ ᒥᒄ ᓃᔨ ᐋ ᐄᑖᔨᐦᑎᒫᓐ ᓅᐦᒋ ᐄᔑ ᐊᔨᒥᓐ᙮ ᐊᓐ ᐅᐦᑖᐐᒫᐤ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᐐᔨ ᓂᒌ ᐐᐦᑎᒫᒄ ᑖᓐ ᒑ ᐃᔨᐅᒡ ᐋᐅᒄ ᒫᒃ ᒥᒄ ᑳ ᐄᔑ ᐐᐦᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ᓂᒋᔅᒑᔨᐦᑎᒸᓐ ᒫᒃ ᐐᔨ ᐅᑎᑎᔑᐙᐎᓐ ᒋᑭ ᑐᑖᑯᐙᓈᐙᐤ ᒑ ᒌ ᐃᔮᔮᒄ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮ ᑖᓐ ᐋ ᐄᔑ ᒥᔨᑦ ᐅᐦᑖᐐᒫᐤ ᒑ ᒌ ᐄᑎᑯᒡ ᐋᐅᒄ ᐊᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ᐋᒸᔮ ᐅᐦᒋ ᐅᑎᐦᒋᐱᔨᔨᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓂᔨᐤ, ᔖᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒌᓴᔅ ᐋ ᐅᑎᐦᒋᐱᔨᔨᒡ ᒑ ᓂᑭᑎᐦᒃ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑭᔮᐦ ᒑ ᓂᑎᐙᐱᒫᑦ ᐅᐦᑖᐐᒫᐤ᙮ ᒨᔥ ᒌ ᓵᒋᐦᐋᐤ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑖᐲᐙᐅᓰᑦ ᑳ ᑖᑆᔮᔨᒥᑯᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ, ᐋᒄ ᒫᒃ ᒑ ᐅᑎᐦᒋᐱᔨᔨᒡ ᒑ ᒌ ᐙᐱᐦᑏᔮᑦ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓈᔥᒡ ᒥᔥᑏᐦ ᓵᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ᒫᒀᒡ ᒫᒃ ᒌ ᐅᑖᑯᔔ ᒦᒋᓯᐎᒡ ᒌᓴᔅ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐹᔨᒄ ᒫᒃ ᐊᓐ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒍᑖᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᓵᐃᒥᓐ ᐃᔅᑳᕆᔨᑦ ᐅᑯᓯᔅᐦ, ᔖᔥ ᐊᓂᑖᐦ ᒌ ᑐᑖᑯᐦᑖᑯᐱᓐ ᒥᒋᒥᓂᑑ ᒑ ᒌ ᐄᑖᔨᐦᑎᐦᒃ ᒑ ᒌ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ᒌᓴᔅ ᐋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐅᐦᑖᐐᒫᐤ ᐋ ᒌ ᐱᒋᔅᑏᓂᒫᑯᑦ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒥᓯᐙ ᒑᒀᔨᐤ ᒑ ᒌᐦ ᑐᑎᐦᒃ, ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᐐᔨ ᒫᒃ ᒋᔖᒥᓂᑑᐦᒡ ᐋ ᒌ ᐹᒋ ᐅᐦᒌᑦ ᑭᔮᐦ ᐋᐦ ᑖᔨᒡ ᒦᓐ ᑳᐤ ᒑ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ᒌ ᐱᓯᑰ ᒫᒃ ᐊᓂᑎᐦ ᒦᒋᓱᓈᐦᑎᑯᐦᒡ ᐅᐦᒋ, ᑳ ᒥᓂᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑎᑯᐦᑉ ᐅᔅᒋᒡ ᑳ ᐅᐦᑎᔥᑭᐦᒃ ᑳ ᐅᑎᓈᑦ ᑳᓰᐦᒀᐦᐅᓐ ᑳ ᒋᑳᔨᐙᐱᐦᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ᑳ ᑯᑎᐱᓂᐦᒃ ᓂᐲᔨᐤ ᒋᔅᑖᐹᐅᔮᑭᓂᒡ ᐋᒄ ᑳ ᒋᔥᑖᐹᐅᒋᓯᑖᓈᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑭᔮᐦ ᑳ ᐹᐦᑯᐦᐊᒸᑦ ᐅᓯᑎᔨᐤ ᐊᓂᔮᔨᐤ ᑳᓰᐦᒀᐦᐅᓐ ᑳ ᒋᑳᔨᐙᐱᐦᓱᑦ ᐋᐦ ᐋᐱᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ᒌ ᓈᑖᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᒄ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒋᑭ ᒋᔥᑖᐹᐅᒋᓯᑖᓐ ᐋ?” ");
INSERT INTO crl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓂᒧᐃ ᒌ ᓂᔅᑐᐦᑖᓐ ᐊᓅᐦᒡ ᑖᓐ ᐋᔨᐦᑎᔮᓐ, ᒥᒄ ᒫᒃ ᐋᔥᒄ ᒋᑭ ᓂᔅᑐᐦᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑎᑯᑦ, “ᓂᒧᐃ ᓂᐦᑖ ᒋᑭ ᐅᐦᒋ ᒋᔥᑖᐹᐅᑖᓐ ᓂᓯᑦ᙮” ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᐋᑳ ᒋᔥᑖᐹᐅᑖᔮᓈ ᒋᓯᑎ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑖᑎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐊᑳᐐ ᒥᒄ ᓂᓯᑦ ᒋᔥᑖᐹᐅᑖᐦ, ᒋᔥᑖᐹᐅᑖᐦ ᑭᔮᐦ ᓂᔅᑎᒀᓐ ᑭᔮᐦ ᓂᑎᐦᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐊᐙᓐ ᔖᔥ ᐋ ᒌ ᐱᑳᔑᒧᑦ ᓂᒧᐃ ᓂᑎᐙᔨᐦᑎᒻ ᒦᓐ ᒑ ᒌ ᐱᑳᔑᒧᑦ, ᒥᒄ ᐅᓯᑦ ᒋᐱᐦ ᒋᔥᑖᐹᐅᑖᑭᓅᔨᐤ᙮ ᒥᓯᐙ ᒫᒃ ᐋ ᑎᔑᔮᒄ ᔖᔥ ᒋᐱᔮᐦᒋᓰᓈᐙᐤ, ᒥᒄ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᒧᐃ ᐱᔮᐦᒋᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ᔖᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒌᓴᔅ ᑖᓂᔮᔨᐤ ᐊᓂᔮᔨᐤ ᒑ ᒫᒥᔑᒥᑯᑦ ᐋᔪᐎᒄ ᐙᐦᒋ ᐃᔨᑦ ᐅᔮᔨᐤ᙮ “ᔖᔥ ᒥᓯᐙ ᒋᐱᔮᐦᒋᓰᓈᐙᐤ ᒥᒄ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᒧᐃ ᐱᔮᐦᒋᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔥᑖᐹᐅᒋᓯᑖᓈᑦ, ᐋᒄ ᒦᓐ ᑳ ᐳᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᐅᑎᑯᐦᑉ ᑳ ᒥᓂᐦᒃ ᐋᒄ ᒦᓐ ᑳ ᐅᐙᔨᐱᑦ᙮ ᑳ ᑯᒀᒋᒫᑦ ᐋᐦ ᐄᑖᑦ, “ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐋ ᒑᒀᓐ ᐙᐦᒋ ᑐᑖᑎᑯᒡ ᐆ? ");
INSERT INTO crl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ᒋᔅᑯᑎᒫᒑᓯᐤ ᑭᔮᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᑎᐃᔑᓂᐦᑳᓯᓈᐙᐤ, ᐋᐅᒄ ᒫᒃ ᑖᑆᐦ ᓂᐱᐦ ᐃᔑᓂᐦᑳᑎᑯᐎᓐ ᐙᔥ ᑖᑆᐦ ᐋᐅᒄ ᓃᔨ ᐊᓐ ᐃᔮᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ᓃᔨ ᐋᐅᒄ ᒋᑎᐹᔨᐦᒋᒑᓯᒧᐙᐤ ᑭᔮᐦ ᒌ ᒋᔅᑯᑎᒫᒑᓰᒧᐙᐤ, ᐊᔮᐱᒡ ᒫᒃ ᓃᔨ ᒋᒌ ᒋᔥᑖᐹᐅᒋᓯᑖᓂᑎᓈᐙᐤ᙮ ᑭᔮᐦ ᒌᔨᐙᐤ ᒫᒃ ᒋᐱᐦ ᒋᔥᑖᐹᐅᒋᓯᑖᓂᑑᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ᒋᒌ ᐙᐱᐦᑏᑎᓈᐙᐤ ᑖᓐ ᒑ ᒌ ᐄᔑ ᒋᔅᒋᓄᐙᐱᒥᔮᒄ ᐊᓐ ᑖᓐ ᑳᐦᑐᑖᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐋᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᐐᐦ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐅᒋᒫᒻ ᑭᔮᐦ ᐊᐙᓐ ᑳ ᒋᐦᒋᑎᔑᐦᐙᑭᓅᑦ ᒑ ᒌ ᓂᑎᐙᐐᐦᑎᐦᒃ ᒑᒀᔨᐤ ᓂᒧᐃ ᐐᔨ ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓯᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒋᐦᒋᑎᔑᐦᐅᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ᓂᔅᑐᐦᑎᒫᒀ ᒫᒃ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᑭᔮᐦ ᒫᒃ ᑐᑎᒫᒀ ᒋᑭ ᒥᔪᑐᑖᑯᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ᓂᒧᐃ ᒫᒃ ᒥᓯᐙ ᒋᑖᔨᒨᒥᑎᓈᐙᐤ, ᓂᒥᔪ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᒌ ᓃᔨ ᑳ ᐅᐙᔮᐱᒥᒀᐤ᙮ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓐ ᓈᐹᐤ ᑳ ᐐᒋᒦᒋᓲᒥᑦ ᓂᑭ ᒫᒥᔑᒥᒄ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᔖᔥ ᐐᐱᒡ ᒋᐱᐦ ᐄᔅᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ᐋᐅᒄ ᒫᒃ ᐆ ᐋᐦ ᐄᑎᑯᒡ ᐋᒸᔮ ᐄᔅᐱᔨᒡ, ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᑖᑆᐦ ᐄᔅᐱᔨᐦᒑ, ᐋᒄ ᒑ ᑖᑆᐦᑎᒫᒄ ᓃᔨ ᑖᑆᐦ ᐋᐦ ᐋᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᒑ ᐅᑎᓈᒀ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒑ ᐄᑎᔓᐦᐅᒥᒡ ᓄᑎᓂᒄ ᑭᔮᐦ ᓃᔨ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᐅᑎᓂᑦ, ᐅᑎᓈᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ, ᓈᔥᒡ ᒌ ᒥᓯᒥᑖᐦᐋᐤ ᐋᒄ ᑯᐃᔅᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᐋᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐹᔨᒄ ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᑭ ᒫᒥᔑᒥᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᑭᓂᐙᐱᒥᑐᒡ ᓈᔥᒡ ᐙᐙᓈᔨᐦᑎᐦᒡ, ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᐦᒡ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔨᒨᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ᐊᓐ ᒫᒃ ᐹᔨᒄ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ, ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᑳ ᓵᒋᐦᐋᑦ, ᐅᐦᐱᒫ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒌ ᐊᐱᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᓈᒥᔅᑯᐙᔨᔅᑐᐙᑦ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳᐦ ᐄᑖᑦ ᒑ ᒌ ᑯᒀᒋᒫᔨᒡ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔨᒨᒫᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ᐋᒄ ᐊᓐ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᔅᐱᔨᐦᐅᑦ ᐋᒄ ᐋᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ ᐊᐙᓐ ᐊᓐ ᑳᐦ ᐋᔨᒨᒥᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᓂᑭ ᐊᑯᐦᒋᒫᐤ ᐆ ᐋᐃᐦᑯᓈᐤ ᐊᓂᑎᐦ ᒥᓂᐦᒀᑭᓂᒡ ᐋᒄ ᒑ ᒥᔨᒃ ᐊᓐ ᐊᐙᓐ᙮” ᑳ ᐊᑯᐦᒋᒫᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐋᒄ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᒍᑕᔅᐦ, ᓵᐃᒥᓐ ᐃᔅᑳᕆᔨᑦ ᐅᑯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ᒍᑖᔅ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ, ᐋᒄ ᑏᐙᐦᒡ ᑳ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᒥᓂᑑ᙮ ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᒍᑕᔅᐦ, “ᒌᔨᐲᐦ, ᑐᑎᐦ ᐊᓐ ᒑ ᑐᑎᒧᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ᓂᒧᐃ ᒫᒃ ᐙᒋᐹᔨᒄ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐄᑖᔨᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ᒌ ᐄᑖᔨᐦᑎᒧᒡ ᐋᐦ ᐄᑖᒫᑭᓂᐎᔨᒡ ᒑ ᒌ ᓂᑑᐅᑎᓂᒑᔨᒡ ᒥᑯᔖᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᓂᑑᐅᑎᓂᒧᐙᔨᒡ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ, ᐙᔥ ᐐᔨ ᒍᑖᔅ ᒌ ᑭᓂᐙᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᔔᔮᓅᑎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ᐄᔥᐱᐦ ᒫᒃ ᒍᑖᔅ ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᑏᐙᐦᒡ ᒌ ᐋᑎ ᐎᔨᐐᐤ, ᒌ ᑎᐱᔅᑳᔨᐤ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᔨᐐᑦ ᒍᑖᔅ, ᒌᓴᔅ ᐃᔮᑦ, “ᐋᒄ ᒫᒃ ᒑᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ, ᐋᒄ ᒫᒃ ᑭᔮᐦ ᒋᔖᒥᓂᑑ ᒑᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ ᓅᑯᐦᑖᑭᓂᐎᔨᒡ ᐅᑯᓯᓯᒫᐤ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ, ᐋᒄ ᐐᔨ ᒋᔖᒥᓂᑑ ᒑ ᐙᐱᐦᑏᔮᑦ ᐄᔨᔨᐤ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᐅᑯᓯᓯᒫᐤ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᑏᐙᐦᒡ ᒋᑭ ᐙᐱᐦᑏᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ᓂᑎᐙᔑᔒᒥᑐᒃ, ᔖᔥ ᓂᒧᐃ ᓈᐅᔥ ᓂᑭᐅᐦᒋᐦᑖᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ᒋᑭ ᐹᒋ ᓈᓂᑐᐙᐱᒥᓈᐙᐤ, ᒥᒄ ᒫᒃ ᒋᑭ ᐐᐦᑎᒫᑎᓈᐙᐤ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒨᒀᐤ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ, ᓂᒧᐃ ᒋᑭ ᒌ ᐄᑐᐦᑖᓈᐙᐤ ᐊᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ᐋ ᐅᔅᑳᒡ ᐄᑎᔓᐙᐎᓐ ᒋᒥᔨᑎᓈᐙᐤ ᐋᐅᒄ ᒑ ᒌ ᓵᒋᐦᐄᑐᔮᒄ᙮ ᒧᔮᒻ ᓃᔨ ᑳ ᐄᔑ ᓵᒋᐦᐄᑎᑯᒡ ᐋᐅᒄ ᐊᓐ ᒋᐱᐦ ᐄᔑ ᓵᒋᐦᐄᑐᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ᓵᒋᐦᐄᑐᔮᒀ ᒫᒃ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒋᔅᒑᔨᒥᑯᐎᔮᒄ ᐋ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑖᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔨᓐ?” ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓂᒧᐃ ᒋᑭ ᒌ ᐐᒑᐎᓐ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᓐ, ᐋᔥᒄ ᐊᓂᑖᐦ ᐹᑎᒫ ᐋᒄ ᒑ ᒌ ᐐᒑᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ᓵᐃᒥᓐ ᐲᑎᕐ ᒦᓐ ᑳ ᑯᒀᒋᒫᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒑᒀᓐ ᒑ ᐅᐦᒋ ᐋᑳ ᒌ ᐐᒑᑖᓐ ᐊᓅᐦᒡ? ᓂᐱᒫᑎᓰᐎᓐ ᐙᔥ ᓂᑭ ᐱᒋᔅᑎᓈᓐ ᒌᔨ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᑖᑆᐦ ᐋ ᔖᔥ ᒋᑖᔮᔅᑭᐐᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᒥᓐ ᒌ ᐱᒫᑎᓰᐎᓐ ᓃᔨ ᐅᐦᒋ? ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓐ, ᐐᐱᒡ ᒑᒋᔖᐹᔮᒑ ᐋᔥᒄ ᐋᐦᐋᑳ ᐙᐙᒡ ᒋᔅᑐᑖ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ, ᔖᔥ ᓂᔥᑣᐤ ᒋᑭ ᓂᓂᑎᔨᓐ ᐋᐦ ᐃᔨᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒦᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“ᐊᑳᐐ ᑭᑎ ᒥᑯᔥᑳᑖᔨᐦᑎᒧᒥᑭᓐ ᒋᑖᐦᐄᐙᐤ᙮ ᑖᑆᒑᔨᒫᐦᒄ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᓃᔨ ᑖᑆᒑᔨᒥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ᐊᓂᑖᐦ ᓅᐦᑖᐐ ᐐᒋᐦᒡ ᒥᐦᒑᓐ ᐋ ᐱᔅᒑᒡᐦ᙮ ᓂᑭ ᐄᑐᐦᑖᓐ ᓈᑖᐦ ᒑ ᒌ ᐃᔮᔅᑰᔥᑣᑎᑯᒡ ᐊᓂᑎᐦ ᒑ ᑖᔮᒄ᙮ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐄᑎᑎᓈᐙᐤ ᐆ ᐋᑳ ᐅᐦᒋ ᑖᑆᒥᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ᒌᔑᐦᑖᔮᓈ ᒫᒃ ᐊᓂᑎᐦ ᒑ ᑖᔮᒄ, ᐋᒄ ᒑ ᐹᒋ ᓂᑎᐙᐱᒥᑎᑯᒡ ᐋᒄ ᒑ ᒋᔅᑐᐦᑎᐦᐄᑎᑯᒡ ᐙᔥ ᒋᓂᑎᐙᔨᒥᑎᓈᐙᐤ ᒑ ᒌᐦ ᑖᔮᒄ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒫᒃ ᐊᓐ ᒫᔅᑭᓂᐤ ᐊᓂᑎᐦ ᐊᑎᒨᒡ ᐊᓂᑖᐦ ᓃᔨ ᐋᑐᐦᑖᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ᐋᒄ ᑣᒥᔅᐦ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᑖᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔨᓐ, ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᐊᓐ ᒫᔅᑭᓂᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᓃᔨ ᐋᐅᒄ ᒫᔅᑭᓂᐤ ᑭᔮᐦ ᑖᑆᐎᓐ ᑭᔮᐦ ᐱᒫᑎᓰᐎᓐ, ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᓈᑖᐤ ᐅᐦᑖᐐᒫᐤ ᒥᒄ ᓃᔨ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ᔖᔥ ᒫᒃ ᐋ ᒋᔅᒑᔨᒥᔮᒄ ᔖᔥ ᒋᐱᐦ ᒋᔅᒑᔨᒫᐙᐤ ᑭᔮᐦ ᓅᐦᑖᐐ᙮ ᐊᓅᐦᒡ ᐅᐦᒋ ᔖᔥ ᒌ ᒋᔅᒑᔨᒫᐙᐤ ᑭᔮᐦ ᔖᔥ ᒋᒌ ᐙᐱᒫᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ᕕᓕᑉ ᐋᑎᑯᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ ᐙᐱᐦᑎᔨᓈᓐ ᒫᐦ ᐅᐦᑖᐐᒫᐤ, ᐋᒄ ᒑ ᓂᐦᐋᔨᐦᑎᒫᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᕕᓕᑉ, ᔖᔥ ᓈᐎᔥ ᑳᐦ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐊᔮᐱᒡ ᒫᒃ ᓂᒧᐃ ᒋᒋᔅᒑᔨᒥᓐ? ᐊᓐ ᐊᐙᓐ ᑳ ᐙᐱᒥᑦ ᔖᔥ ᐙᐱᒫᐤ ᐅᐦᑖᐐᒫᐤ᙮ ᒑᒀᓐ ᒫᒃ ᐙᐦᒋ ᑯᒀᒋᒥᔨᓐ ᒑ ᒌ ᐙᐱᐦᑎᔨᑖᓐ ᐅᐦᑖᐐᒫᐤ? ");
INSERT INTO crl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ᕕᓕᑉ, ᓂᒧᐃ ᐋ ᒌ ᑖᑆᐦᑖᓐ ᐋ ᐲᐦᒋᔥᑰᒃ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᐋ ᐲᐦᒋᔥᑯᑦ? ᓂᐹᔨᑯᓈᓐ᙮ ᐆ ᑳ ᐄᔑ ᐊᔨᒥᐦᐄᑎᑯᒡ ᒋᔖᒥᓂᑑ ᓂᒌᐦ ᐄᑎᒄ ᒑ ᒌ ᐃᔨᐅᒡ, ᓂᒧᐃ ᓃᔨ ᐋᐹᔨᑯᓯᔮᓐ ᑳ ᐃᔮᓐ᙮ ᐅᐦᑖᐐᒫᐤ ᐊᓐ ᐹᐦᒋᔥᑯᑦ ᐐᔨ ᑐᑎᒻ ᐃᔨᐦᑎᐎᓐ ᓃᔨ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ᐹᒋ ᑖᑆᐦᑑᒄ ᐆ ᐋᐦ ᐄᑎᑯᒡ ᐋ ᐲᐦᒋᔥᑰᒃ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᐅᐦᑖᐐᒫᐤ ᐋ ᐲᐦᒋᔥᑯᑦ᙮ ᐋᑳ ᒫᒃ ᒑ ᑖᑆᐦᑎᒧᐙᒀ ᐆ ᐋᐦ ᐄᑎᑯᒡ ᑖᑆᐦᑑᒄ ᐊᓐ ᐅᐦᒋ ᑖᓐ ᑳ ᐄᔑ ᓂᓈᐦᑭᐤ ᑐᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ᑖᑆᐦ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᓐ ᐊᐙᓐ ᑎᔮᑆᔮᔨᒥᑦ ᒋᑭᑐᑎᒻ ᑖᓐ ᐋ ᐄᔑ ᑐᑎᒧᒡ ᑭᔮᐦ ᐊᑎᑎᐤ ᐊᔨᑖᔨᐦᑖᑯᓃᔨᒡ ᐃᔨᐦᑎᐎᓐ ᒋᑭᑐᑎᒻ ᐙᔥ ᐊᓂᑖᐦ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᓂᑭ ᐄᑐᐦᑖᓐ ᓃᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ᓂᑭ ᑐᑖᓐ ᑖᓐ ᐋ ᐄᔑ ᓂᑐᑎᒫᔮᒄ ᓂᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐱᒋᐦᑖᔮᒀ, ᐅᐦᑖᐐᒫᐤ ᒑ ᒌ ᒋᒋᔅᑖᔨᐦᑖᑰᐦᐋᑭᓅᑦ ᐅᑯᓯᓯᒫᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑐᑎᒫᐙᒀ ᓂᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᔮᒄ ᓂᑭ ᑐᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ᒥᔔ ᒫᒃ ᓯᔮᒋᐦᐄᐙᒀ ᒋᑭ ᓂᓂᐦᐄᐦᑎᐎᓈᐙᐤ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑎᑯᒡ ᒑ ᒌ ᑎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ᓂᑭ ᓂᑐᑎᒧᐙᐤ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᒑ ᒌ ᐄᑎᔑᐦᐊᒫᑖᒄ ᒦᓐ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐐᒋᐦᐄᑎᔨᑖᐦᒄ ᑭᔮᐦ ᒨᔥ ᑳᒋᒡ ᒑ ᒌᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐋᐦᑖᐙᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ᐋᐅᒄ ᒫᒃ ᐊᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ, ᐊᓐ ᑳ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᐙᑦ ᑖᑆᐎᓂᔨᐤ᙮ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᑳ ᑳ ᑖᑆᔮᔨᒫᒡ ᐅᐦᑖᐐᒫᐤ ᓂᒧᐃ ᒋᑭ ᒌ ᐲᐦᑎᑭᐦᐋᐅᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐙᔥ ᓂᒧᐃ ᐙᐱᒫᐅᒡ ᑭᔮᐦ ᓂᒧᐃ ᒋᔅᒑᔨᒫᐅᒡ᙮ ᒥᒄ ᒫᒃ ᒌᔨᐙᐤ ᒌ ᒋᔅᒑᔨᒫᐙᐤ ᐙᔥ ᒌ ᐐᒑᐅᑯᐙᐤ ᑭᔮᐦ ᒫᒃ ᒋᑭ ᐲᐦᒋᔥᑳᑯᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ᓂᒧᐃ ᒨᔮᒻ ᒌᐎᔑᔖᓂᔑᐦᒡ ᒋᑭ ᐄᔑ ᓂᑭᑎᑎᓈᐙᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᒦᓐ ᒋᑭ ᐹᒋ ᓂᑎᐙᐱᒥᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ᒥᒄ ᐋᔥᒄ ᐙᔨᐱᔅᒋᔥ ᐋᒄ ᓂᒥ ᓂᑭ ᐙᐱᒥᑯᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᒥᒄ ᒌᔨᐙᐤ ᒋᑭ ᐙᐱᒥᓈᐙᐤ᙮ ᒋᑭ ᐱᒫᑎᓰᓈᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ ᐙᔥ ᓃᔨ ᓂᐱᒫᑎᓰᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᐦᒋᐱᔨᐦᒑ, ᐋᑯᑖᐦ ᒑ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐋ ᐲᐦᒋᔥᑰᒃ ᓅᐦᑖᐐ ᑭᔮᐦ ᐋ ᐲᐦᒋᔥᑰᔮᒄ, ᑭᔮᐦ ᒫᒃ ᐋ ᐲᐦᒋᔥᑳᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ᐊᓐ ᐊᐙᓐ ᒑᔅᒑᔨᐦᑎᐦᒃ ᑭᔮᐦ ᓂᓂᐦᐄᐦᑎᒧᒀ ᑖᓐ ᐋᐦ ᐄᑎᔓᐙᔮᓐ ᐋᐅᒄ ᐊᓐ ᓯᔮᒋᐦᐄᑦ᙮ ᒋᑭ ᓵᒋᐦᐄᑰ ᓅᐦᑖᐐ ᐊᓐ ᒑ ᐹᒋ ᓵᒋᐦᐄᑦ, ᑭᔮᐦ ᓃᔨ ᒫᒃ ᓂᑭ ᓵᒋᐦᐋᐤ ᐊᓐ ᐊᐙᓐ ᑭᔮᐦ ᓃᔨ ᓂᑭ ᓄᑰᓯᔅᑎᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ᒍᑖᔅ, ᓂᒧᐃ ᐐᔨ ᐊᓐ ᐃᔅᑳᕆᔨᑦ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᒌᐦ ᐄᑖᐤ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒑᒀᓐ ᐙᐦᒋ ᒥᒄ ᓃᔮᓐ ᐐᐦ ᓄᑰᓯᔅᑑᔮᐦᒡ, ᐋᐦᐋᑳ ᒫᒃ ᐐᐦ ᓄᑯᓯᔅᑑᑣᐤ ᑯᑎᑭᒡ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ᒌᓴᔅ ᐋᑖᑦ, “ᐊᓐ ᐊᐙᓐ ᑳ ᓵᒋᐦᐄᑦ ᑭᑎ ᓂᓂᐦᐄᐦᑎᒻ ᓂᑎᔨᒧᐎᓂᔨᐤ᙮ ᓅᐦᑖᐐ ᒫᒃ ᒋᑭ ᓵᒋᐦᐄᑰ᙮ ᑖᐱᔥᑯᓐ ᓅᐦᑖᐐ ᑭᔮᐦ ᓃᔨ ᓂᑭ ᐹᒋ ᓂᑎᐙᐱᒫᓈᓐ ᐋᒄ ᒫᒃ ᒑ ᐐᒋᒥᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᐹᒋ ᓵᒋᐦᐄᑦ ᓂᒧᐃ ᓂᓂᐦᐄᐦᑎᒻ ᓂᑎᔨᒧᐎᓂᔨᐤ᙮ ᐆ ᐊᔨᒧᐎᓐ ᐱᔮᐦᑎᒫᒄ ᓂᒧᐃ ᓃᔨ ᐋᐦ ᑖᔮᓐ ᐅᐦᒋᐱᔨᐤ, ᓅᐦᑖᐐ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ, ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ᐋᐅᒄ ᐆ ᐋ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᐋᔥᒄ ᒫᒀᒡ ᐋᐦ ᑖᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ᐊᓂᔮᔨᐤ ᐐᒋᐦᐄᐙᓲᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᓅᐦᑖᐐ ᒑ ᐹᒋ ᐄᑎᔑᐦᐊᒫᑖᒄ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ ᐋᐅᒄ ᐐᔨ ᒥᓯᐙ ᒑᒀᔨᐤ ᒑ ᒋᔅᑯᑎᒫᑖᒄ ᑭᔮᐦ ᒋᑭ ᒋᔅᒋᓲᒥᑯᐙᐤ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒋᓂᑭᑎᒫᑎᓈᐙᐤ᙮ ᓃᔨ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒋᒥᔨᑎᓈᐙᐤ᙮ ᓂᒧᐃ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᒋᒥᔨᑎᓈᐙᐤ᙮ ᐊᑳᐐ ᒫᒃ ᒥᑯᔥᑳᑖᔨᐦᑎᒧᒄ ᒋᑖᐦᐐᐙᐦᒡ ᑭᔮᐦ ᐊᑳᐐ ᑯᔥᑖᒋᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ᒋᒌ ᐹᐦᑑᓈᐙᐤ ᑳᐦ ᐄᑎᑯᒡ, ‘ᓂᑭ ᒋᔅᑑᐦᑖᓐ ᒥᒄ ᒫᒃ ᒦᓐ ᑳᐤ ᒋᑭ ᐹᒋ ᓂᑎᐙᐱᒥᑎᓈᐙᐤ᙮’ ᒌ ᓵᒋᐦᐄᔮᒄ ᒫᒃ ᒋᐱᐦ ᒥᔻᔨᐦᑖᓈᐙᐤ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᐋᐦ ᐄᑐᐦᑖᔮᓐ, ᐙᔥ ᐐᔨ ᐊᐅᔅᑖ ᒋᔅᑖᔨᑖᑯᓯᐤ ᐃᔥᐱᔥ ᓃᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ᒥᓯᐙ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᐆ ᐊᒸᔮ ᐹᒋ ᐅᑎᐦᒋᐱᔨᒡ, ᐄᔥᐱᐦ ᒫᒃ ᐅᑎᐦᒋᐱᔨᒑ ᒑ ᑖᑆᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ᓂᒧᐃ ᔖᔥ ᓈᔥᒡ ᓈᐅᔥ ᒋᑭ ᒌ ᐊᔨᒥᐦᐄᑎᓈᐙᐤ, ᐙᔥ ᒥᒋᒥᓂᑑ, ᐊᓐ ᑳ ᐅᒋᒫᑳᑎᐦᒃ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᔖᔥ ᐹᒋ ᐄᑐᐦᑖᐤ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᓂᑭ ᒌ ᐅᒋᒫᐦᑭᐦᑖᒄ, ");
INSERT INTO crl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ᒥᒄ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᒨᔥ ᐊᓂᓂᐦᐄᐦᑑᒄ ᒥᓯᐙ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᑦ, ᐋᑯᑎᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋ ᓵᒋᐦᐄᒥᒡ ᐅᐦᑖᐐᒫᐤ᙮ ᐋᔅᑎᒧᒄ ᒫᒃ ᒋᔅᑐᐦᑖᑖᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᓃᔨ ᐋᐅᒄ ᒋᐦᒋᐙ ᑳᐃᓲᒧᓰᐦᒡ ᒦᓂᓵᐦᑎᒄ ᐋᒄ ᓅᐦᑖᐐ ᐋᐅᒄ ᑳ ᓂᐦᑖᐅᒋᐦᑖᑦ ᑳᐃᓲᒧᓰᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ᒥᓯᐙ ᐅᑎᐦᑯᓐ ᓃᔨ ᐋᐦ ᑖᔮᓐ ᐙᐦᒋ ᓯᑭᒧᒡ, ᐋᑳ ᑳ ᒦᓂᔓᐦᒡ ᓅᐦᑖᐐ ᒥᓂᔑᒻ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᑎᐦᑯᓐ ᑳ ᒦᓂᔓᐎᔨᐦᒡ ᒥᓯᐙ ᐎᔮᔥᑑᑎᒻ ᐊᑎᑎᐤ ᒑ ᒌ ᒦᓂᔓᐎᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ᒌᔨᐙᐤ ᒫᒃ ᔖᔥ ᒋᒌ ᐱᔮᐦᒋᐦᐄᑯᓈᐙᐤ ᐊᓐ ᐊᔨᒧᐎᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ᐹᒋ ᐲᐦᒋᔥᑰᒃ, ᓃᔨ ᑭᔮᐦ ᒑ ᐲᐦᒋᔥᑳᑎᑯᒡ᙮ ᒸᐦᒡ ᒨᔮᒻ ᐅᑎᐦᑯᓐ ᓂᒧᐃ ᒋᑭ ᒌ ᒦᓂᔓᐤ ᐋᐦᐋᑳ ᐊᓂᑖᐦ ᔔᒥᓈᐦᑎᑯᐦᒡ ᐄᔑ ᓯᑭᒧᒡ᙮ ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᓯᔮᒄ᙮ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᑖᐅᒋᐦᐄᓱᓈᐙᐤ ᒑ ᒌ ᒦᓂᔑᐎᔮᒄ ᒥᔔ ᐋᑳ ᐲᐦᒋᔥᑰᔮᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ᓃᔨ ᐋᐅᒄ ᑳᐃᓯᒧᓯᐦᒡ ᒦᓂᓵᐦᑎᒄ ᐋᒄ ᒌᔨᐙᐤ ᐅᑎᐦᑯᓐ᙮ ᐊᓐ ᐊᐙᓐ ᐹᐦᒋᔅᑯᑦ ᑭᔮᐦ ᓃᔨ ᓂᐲᐦᒋᔅᑯᐙᐤ ᐋᐅᒄ ᐊᓐ ᒑ ᒥᔪ ᒦᓂᔓᐎᑦ, ᐙᔥ ᑖᐹ ᒥᑐᓐ ᒑᒀᓐ ᒋᑭ ᒋᑐᑖᓈᐙᐤ ᓂᓲᐙᒄ ᑖᔮᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ᐊᐙᓐ ᐋᑳ ᓃᔨ ᐱᐦᒋᔅᑰᒑ, ᐙᐱᓈᑭᓂᐤ ᒨᔮᒻ ᑖᓐ ᐋᐦ ᑐᑖᑭᓂᐎᔨᒡ ᐅᑎᐦᑯᓐ, ᐹᔅᑖᐤ ᒫᒃ᙮ ᐊᓂᐦᐄ ᒫᒃ ᐅᑎᐦᑯᓐ ᑳ ᐙᐱᓂᑭᓂᐎᐦᒡ ᒫᒨᔑᒋᓂᑭᓂᐤ ᐋᒄ ᒫᒋᔥᑎᐙᐱᓂᑭᓂᐎᐦᒡ ᐋᒄ ᒫᒃ ᐋᑎ ᐃᔥᒀᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ᓃᔨ ᒫᒃ ᐲᐦᒋᔅᑯᔮᒀ ᑭᔮᐦ ᓂᑎᔨᒧᐎᓐ ᐲᐦᒋᔥᑳᑯᔮᒀ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑐᑎᒫᐙᒀ ᒑᒀᓐ ᐋᐅᒄ ᐊᓐ ᒑ ᑐᑎᒫᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ᐋ ᒥᔪ ᒦᓂᔓᐎᔮᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ ᓅᐦᑖᐐ, ᑭᔮᐦ ᒫᒃ ᐋᑯᑖᐦ ᒋᔮᔥᑎᓈᑖᔨᐦᑖᑯᐦᒡ ᐋ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᑐᑖᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ᒧᔮᒻ ᐋ ᐄᔑ ᓵᒋᐦᐄᑦ ᐅᐦᑖᐐᒫᐤ ᐋᐅᒄ ᐋᓐ ᐋ ᐄᔑ ᓵᒋᐦᐄᑎᑯᒡ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ᒨᔥ ᑖᒄ ᓂᓵᒋᐦᐄᐙᐎᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ᓂᓂᐦᐄᐦᑎᒫᒀ ᓂᑎ ᐄᑎᔓᐙᐎᓐ ᒋᑭ ᑖᓈᐙᐤ ᓂᓵᒋᐦᐄᐙᐎᓂᒡ ᒧᔮᒻ ᓃᔨ ᑳ ᐄᔑ ᓂᓂᐦᐄᐦᑑᒃ ᓅᐦᑖᐐ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑦ ᑭᔮᐦ ᐋᐦᑖᐅᒡ ᐆ ᓵᒋᐦᐄᐙᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᓂᒧᒋᒑᔨᐦᑎᒧᐎᓐ ᒑ ᒌ ᐲᐦᒋᔥᑳᑯᔮᒄ ᒥᑐᓐ ᒑ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑯᔮᒄ ᐋ ᒨᒋᒑᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ᐆ ᒫᒃ ᒋᑎᐄᑎᔓᒥᑎᓈᐙᐤ, ᒑ ᒌ ᓵᒋᐦᐄᑐᔮᒄ ᒧᔮᒻ ᓃᔨ ᑳ ᐃᔥᐱᔥ ᓵᒋᐦᐄᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ᐊᐙᓐ ᐋ ᐱᒋᔅᑎᓂᐦᒃ ᐅᐱᒫᑎᓰᐎᓐ ᐅᐐᒑᐙᑭᓐ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ, ᓂᒧᐃ ᑎᑯᓐ ᐊᑎᑎᐤ ᐋᐦ ᐄᔥᐹᒡ ᓵᒋᐦᐄᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ᒌᔨᐙᐤ ᒋᐐᒑᐙᑭᓂᑐᑖᑎᓈᐙᐤ ᑐᑎᒫᒀ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ᓂᒧᐃ ᐋᒄ ᐋᐱᒋᐦᐋᑭᓂᒡ ᒋᑭ ᐅᐦᒋ ᐄᑎᓈᐙᐤ ᐙᔥ ᐋᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓐ ᐋᔨᑎᔨᐦᒡ ᐅᒋᒫᒻ᙮ ᓃᔨ ᒫᒃ ᐐ ᓂᐐᒑᐙᑭᓂᒡ ᒋᒌ ᐄᑎᓈᐙᐤ ᐙᔥ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᒨᑦ ᓅᐦᑖᐐ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ᓂᒧᐃ ᒌᔨᐙᐤ ᑰᐦᒋ ᐅᐙᔮᐱᒥᓈᐙᐤ, ᓃᔨ ᐋᐅᒄ ᑳ ᐅᐙᔮᐱᒥᑎᑯᒡ᙮ ᐋᒄ ᒫᒃ ᒑ ᒋᔅᑎᓯᐦᐅᑎᑯᒡ ᒑ ᒌ ᒥᔪ ᒦᓂᔓᐎᔮᒄ ᐋ ᒥᔪ ᐄᐦᑐᑎᒫᒄ ᑭᔮᐦ ᒨᔥ ᒑ ᑎᑯᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᒑ ᒥᔨᑖᒄ ᑖᓐ ᒥᒄ ᒑ ᐄᔑ ᓂᑐᑎᒧᐙᒄ ᓂᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ᐋᐅᒄ ᒫᒃ ᐆ ᐋᑎᔓᒥᑎᑯᒡ, ᒑ ᒌ ᓵᒋᐦᐄᑐᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“ᐅᐦᑳᑎᑖᒀᐙ ᐊᓂᒌ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᒑ ᒋᔥᒋᓯᔮᒄ ᓃᔨ ᓃᔥᑎᒻ ᐋ ᒌ ᐅᐦᑳᓯᒡ ᐋᔥᒄ ᐋᒸᔮ ᒌᔨᐙᐤ ᐅᐦᒋ ᐅᐦᑳᑎᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ᐐᒌᑖᑏᓯᒫᑰᒑ ᐊᓂᒌ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᒋᐱᐦ ᓵᒋᐦᐄᑯᐙᐅᒡ ᒧᔮᒻ ᐋ ᐄᔑ ᓵᒋᐦᐄᑐᒡ ᐐᔨᐙᐤ᙮ ᒥᒄ ᒫᒃ ᐋ ᒌ ᐅᐙᔮᐱᒥᑎᑯᒡ ᒌᔨᐙᐤ ᐄᔨᔨᐅᒡ ᐊᔅᒌᐦᒡ ᐅᐦᒋ ᐋᔪᐎᒄ ᐙᐦᒋ ᐅᐦᑳᑎᑖᑯᒡ, ᐙᔥ ᑖᐹ ᐊᓂᑖᐦ ᐋᐦ ᑖᒡ ᒋᑎ ᐄᔑ ᐐᒋᐦᐄᐙᓈᐙᐤ ᔖᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ᒑ ᒋᔥᒋᓯᔮᒄ ᑖᓐ ᑳᐦ ᐄᑎᑯᒡ, ‘ᐋᐱᒋᐦᐋᑭᓐ ᓂᒧᐃ ᐊᐅᔅᑖ ᐅᒋᒫᐙᔨᐦᑖᑯᓯᐤ ᐃᔥᐱᔥ ᐐᔨ ᐅᒋᒫᒻ᙮’ ᒥᔔ ᑳ ᓈᓈᑳᒋᐦᐄᐙᐙᒀ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᑭ ᓂᓈᐦᑳᒋᐦᐄᑯᐙᐅᒡ᙮ ᑳ ᓂᓂᐦᐄᐦᑎᒧᐙᒀ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒧᑎᒨᒀᐤ ᒋᑭ ᓂᓂᐦᐄᐦᑎᒧᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᑖᓐ ᒑ ᐄᔑ ᐋᔨᒨᑎᒧᐙᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ᒥᒄ ᒥᓯᐙ ᐅᔮᔨᐤ ᒋᑭ ᑐᑖᑯᐙᐅᒡ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᐦᒋ, ᐙᔥ ᑖᐹ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ᐋᑳ ᐅᐦᒋ ᐹᒋ ᓂᑎᐙᐱᒥᒀᐤ ᑭᔮᐦ ᐊᔮᒥᐦᐄᒀᐤ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐊᑖᒫᔨᐦᑖᑯᓯᐎᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ᙮ ᐊᓅᐦᒡ ᒫᒃ ᑖᑆᐦ ᐋ ᒌ ᐹᒋ ᐊᔨᒥᐦᐄᒀᐤ ᓂᒧᐃ ᒋᑭ ᒌ ᐃᔫᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒌᔅᒑᔨᐦᑖᒡ ᐋ ᒥᒋᐦᑐᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ᐙᔥ ᐊᓐ ᑳ ᐅᐦᑳᓯᑦ ᓅᐦᑖᐐ ᑭᔮᐦ ᐅᐦᑳᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐊᑖᒫᔨᐦᑖᑯᓯᐎᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ ᐋᑳ ᐅᐦᒋ ᑐᑎᒧᒡ ᐃᔨᐦᑎᐎᓐ ᑎᐱᔨᐙ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᓂᒌᐦ ᑐᑖᓐ ᒑᒀᓂᐦᐄ ᐋᐦᐋᑳ ᓂᐦᑖ ᑯᑎᒃ ᐊᐙᓐ ᐅᐦᒋ ᑐᑎᐦᒃ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᐙᐱᐦᑎᒧᒡ᙮ ᐊᔮᐱᒡ ᒫᒃ ᓂᒌ ᐅᐦᑳᑎᑯᓈᓂᒡ ᑖᐱᔥᑯᓐ ᓃᔨ ᑭᔮᐦ ᓅᐦᑖᐐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐅᐦᒋ ᒌ ᑎᐱᐱᔨᐤ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᐅᐐᔓᐙᐎᓂᐙᐦᒡ᙮ ᓃᑳᓐ ᒌ ᐐᐦᑖᑯᓂᔨᐤ ᐊᓂᑖᐦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ᒑᔅᑳᐦ ᓂᑎᐐ ᓂᒌᐦ ᐄᔑ ᐅᐦᑳᑖᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ᒋᑭ ᐹᒋ ᑎᑯᔑᓐ ᐊᓐ ᐊᐙᓐ ᒑ ᐐᒋᐦᐄᑖᒄ, ᐋᐅᒄ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ᙮ ᓃᔨ ᓂᑭ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᐊᓂᑖᐦ ᐅᐦᒋ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᔨᒡ᙮ ᒋᑭ ᐐᐦᑎᒻ ᑖᑆᐎᓂᔨᐤ᙮ ᓃᔨ ᒫᒃ ᓂᑭ ᐋᔨᒨᒥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ᑭᔮᐦ ᒌᔨᐙᐤ ᒫᒃ ᒋᑭ ᐋᔨᒨᒥᓈᐙᐤ ᑖᑆᐃᓂᐦᒡ, ᐙᔥ ᐊᓂᑎᐦ ᐅᔅᑭᒡ ᑳ ᐅᐦᒋ ᒋᐦᒋ ᒋᔅᑯᑎᒫᒑᔮᓐ ᐋᑯᑖᐦ ᔖᔥ ᑳ ᐅᐦᒋ ᐙᐐᒑᐅᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᒥᓯᐙ ᐆ ᑳ ᐄᔑ ᐊᔨᒧᑎᒫᑎᑯᒡ ᐋᑳ ᒑ ᒌ ᐴᓂᔮᒄ ᐋ ᑖᑆᔮᔨᐦᑖᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ᐅᒌ ᐄᔨᔨᐅᒡ ᒋᑭ ᐎᔨᐐᑎᓯᓂᑯᐙᐅᒡ ᒎᐤ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᐙᐦᒡ᙮ ᐋᐦᐋ, ᒑᒃ ᑖᑆᐦ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᐊᐙᓐ ᒑ ᒌ ᓂᐱᐦᐄᑖᒄ ᐋ ᐄᑖᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐋᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᑐᑖᑖᑯᒡ ᐙᔥ ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐅᒡ ᐅᐦᑖᐐᒫᐤ ᑭᔮᐦ ᒫᒃ ᓃᔨ ᓂᒧᐃ ᓅᐦᒋ ᒋᔅᒑᔨᒥᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ᒥᒄ ᒫᒃ ᒋᐐᐦ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐆ ᒑ ᒌ ᒋᔥᒋᓯᔮᒄ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒨᒥᒀᐤ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᔨᒑ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᒑ ᒌ ᑐᑖᑖᑯᒡ᙮ ᓂᒧᐃ ᑰᐦᒋ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐅᔅᑭᒡ ᐊᓂᑖᐦ ᑳ ᐹᒋ ᒋᔅᑯᑎᒫᑎᑯᒡ ᐙᔥ ᐋᑯᑖᐦ ᑳᐦ ᑖᔮᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ᐊᓅᐦᒡ ᒫᒃ ᐐ ᐋᒄ ᒑ ᓂᑎᐙᐱᒥᒃ ᐊᓐ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ᙮ ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᐹᔨᒄ ᐋ ᑎᔑᔮᒄ ᒋᑯᒀᒋᒥᓈᐙᐤ ᑖᓂᑖᐦ ᐋᑐᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ᐊᓅᐦᒡ ᒫᒃ ᐋ ᒌ ᐐᐦᑎᒫᑎᑯᒡ ᐋᒄ ᓈᔥᒡ ᒫᓯᒫᔨᐦᑎᒫᒄ ᒋᑖᐦᐄᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ᒥᒄ ᒫᒃ ᑯᐃᔅᒄ ᐋ ᐐᐦᑎᒫᑎᑯᒡ ᐊᐅᔅᑖ ᐙᔥ ᒋᑭ ᐐᒋᐦᐄᑯᓈᐙᐤ ᐋ ᒋᔅᑐᐦᑖᔮᓐ, ᐙᔥ ᐋᑳ ᒋᔅᑐᐦᑖᔮᓈ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐹᒋ ᓂᑎᐙᐱᒥᑯᐙᐤ ᐊᓐ ᒑ ᐐᒋᐦᐄᑖᒄ, ᒋᔅᑐᐦᑖᔮᓈ ᒫᒃ ᐋᐅᒄ ᐊᓐ ᒑ ᐹᒋ ᐄᑎᔑᐦᐋᒫᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ᑎᑯᔑᐦᑳ ᒫᒃ ᑭᑎ ᑐᑎᐙᐤ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᒥᔨᒡ ᐋ ᐎᓂᐱᔨᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᓂᐙᐱᐦᑎᒥᔨᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ, ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᐎᔮᔅᑯᓂᒑᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ᐎᓂᐱᔫᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᓂᐙᐱᐦᑎᐦᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ ᐙᔥ ᐋᐦᐋᑳ ᑖᑆᔮᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ᐎᓂᐱᔫᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᓂᐙᐱᐦᑎᐦᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ, ᐙᔥ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᐋᑯᑖᐦ ᐋᑐᐦᑖᔮᓐ, ᓂᒧᐃ ᒫᒃ ᒦᓐ ᒋᑭ ᐅᐦᒋ ᐙᐱᒥᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ᐎᓂᐱᔫᒡ ᑖᓐ ᐋ ᐄᔑ ᑭᓂᐙᐱᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᐎᔮᔅᑯᓂᒑᐎᓂᔨᐤ ᐙᔥ ᒥᒋᒥᓂᑑ, ᐊᓐ ᑳ ᐅᒋᒫᑳᑎᐦᒃ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᔖᔥ ᐐᔨ ᒌ ᑎᐹᔅᑯᓂᑰ ᒋᔖᒥᓂᑑᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ᐋᔥᒄ ᐊᑎᑎᐤ ᒥᔥᑏᐦ ᑎᑯᓐ ᒑ ᒌ ᐄᑎᑯᒡ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐅᑎᓈᐙᐙᐤ ᐊᓅᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ᑎᑯᔑᐦᑳ ᒫᒃ ᐆ ᐊᐦᒑᐦᒄ ᑳ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᐙᑦ ᑖᑆᐎᓂᔨᐤ, ᐊᓐ ᒑ ᒋᔅᒋᓄᐦᑎᐦᐄᑖᒄ ᒥᓯᐙ ᑖᑆᐎᓂᐦᒡ᙮ ᓂᒧᐃ ᐐᔨ ᐙᒋᐦᒡ ᑭᑎ ᐃᔨᐤ ᒑᒀᔨᐤ, ᐊᓂᔮᔨᐤ ᒫᒃ ᑖᓐ ᒑ ᐄᔑ ᐹᐦᑎᐙᑦ ᒋᔖᒥᓂᑑ ᐋᐦ ᐄᔨᔨᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐄᔑ ᐙᐐᐦᑎᐦᒃ᙮ ᒋᑭ ᐙᐐᐦᑎᒫᑯᐙᐤ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᒑ ᐋᑎ ᐃᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ᓂᑭ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᒄ ᐙᔥ ᑖᓐ ᒑ ᐄᔑ ᐋᔨᒨᑎᒧᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐄᔑ ᐋᔔ ᐙᐐᐦᑎᒫᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᑦ ᐅᐦᑖᐐᒫᐤ ᓂᑎᐱᐙᐅᓰᓐ᙮ ᐋᐅᒄ ᐙᐦᒋ ᐄᑎᑯᒡ ᒑ ᐅᐦᑎᓂᐦᒃ ᐅᑎᐦ ᐋᐦᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐋᔔ ᒑ ᐙᐐᐦᑎᒫᑖᒄ ᐆ ᐊᐦᒑᐦᒄ ᑖᓂᔮᔨᐤ ᒑ ᐄᔑ ᐋᔨᒨᑎᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ᔖᔥ ᐐᐱᒡ ᓂᒥ ᒋᑭ ᐙᐱᒥᓈᐙᐤ, ᒥᒄ ᐙᐃᐱᔥᒌᔥ ᐋᒄ ᒦᓐ ᒑ ᐙᐱᒥᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ᐋᒄ ᐱᔅᒡ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᑎᑐᔨᒡ, “ᒑᒀᔨᐤ ᐅᔮᔨᐤ ᑳ ᐄᑎᒄ ᐋᔥᒄ ᒦᓐ ᐙᐃᐱᔥᒌᔥ ᒑ ᐐᒑᐅᐦᒄ ᐋᒄ ᒦᓐ ᐋᑳ ᒑ ᐅᐦᒋ ᐙᐱᒥᐦᒄ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒦᓐ ᐙᐃᐱᔥᒌᔥ ᐋᒄ ᒑ ᐙᐱᒥᐦᒄ, ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐃᔨᑦ, ‘ᐅᐦᑖᐐᒫᐤ ᐋ ᓂᑎᐙᐱᒫᑦ?’ ");
INSERT INTO crl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ᓂᒧᐃ ᒌ ᒋᔅᒑᔨᐦᑎᒸᓈᓂᐤ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐃᔨᑦ, ‘ᐙᐃᐱᔥᒌᔥ᙮’ ” ᓂᒧᐃ ᒋᒋᔅᒑᔨᒫᓂᐤ ᒑᒀᔨᐤ ᐋᔮᔨᒸᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ᒌᓴᔅ ᒌ ᒋᔅᒑᔨᒫᐤ ᐋ ᐐᐦ ᑯᒀᒋᒥᑯᑦ ᐅᔮᔨᐤ᙮ ᐋᒄ ᐋᑖᑦ, “ᐊᓐ ᑳ ᐃᔮᓐ, ᔖᔥ ᐐᐱᒡ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐐᒑᐅᑎᓈᐙᐤ᙮ ᒦᓐ ᒫᒃ ᐙᐃᐱᔥᒌᔥ ᐋᒄ ᒦᓐ ᒑ ᐙᐱᒥᔮᒄ᙮ ᐋᐙ ᐆ ᐙᐦ ᓂᑑᒋᔅᒑᔨᐦᑎᒫᒄ ᒑᒀᓐ ᐊᓐ ᑳᐦ ᐋᔨᒨᑎᒫᓐ? ");
INSERT INTO crl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ᑯᐃᔅᒄ ᐋ ᐐᐦᑎᒫᑎᑯᒡ ᒋᑭ ᒫᑑᓈᐙᐤ ᑭᔮᐦ ᒋᑭ ᒥᒫᑣᓈᐙᐤ᙮ ᐋᒄ ᐅᒌ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᒋᑭ ᓯᒋᔮᓯᐎᒡ᙮ ᒋᑭ ᒥᓯᒫᔨᐦᑖᓈᐙᐤ ᒌᔨᐙᐤ᙮ ᒥᒄ ᒫᒃ ᐊᓐ ᐋ ᒥᓯᒫᔨᐦᑎᒫᒄ ᒋᑭ ᒀᔅᒋᐱᔨᐤ ᑎᔨᑯᒡ ᒑ ᒌ ᒨᒋᒑᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ᒥᔮᒀᐦᐄᑎᐦᒃ ᐃᔅᒀᐤ ᒥᓯᒫᔨᐦᑎᒻ ᐙᔥ ᐅᑎᐦᒋᐱᔨᔨᐤ ᐋᒄ ᒑ ᐐᓯᒑᔨᐦᑎᐦᒃ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐙᔑᔒᒻ ᐎᓂᒋᔥᒋᓯᐤ ᑖᓐ ᑳ ᐄᔑ ᐐᓯᒑᔨᐦᑎᐦᒃ ᐙᔥ ᓈᔥᑖᑆᐦ ᒥᔻᔨᐦᑎᒻ ᐊᐙᔑᔥ ᐋ ᒌ ᐱᒫᑎᓰᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ᐋᐅᒄ ᐋᓐ ᒫᒃ ᒧᔮᒻ ᑭᔮᐦ ᒌᔨᐙᐤ, ᐊᓅᐦᒡ ᒋᒥᓯᒫᔨᐦᑖᓈᐙᐤ᙮ ᒥᒄ ᒫᒃ ᒦᓐ ᐙᐱᒥᑎᑯᒑ ᓈᔥᑖᑆᐦ ᒋᑭ ᒥᔻᔨᐦᑖᓈᐙᐤ ᒋᐦᑖᐦᐄᐙᐦᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐊᐙᓐ ᒋᑭ ᐅᐦᒌ ᑐᑖᑯᐙᐤ ᒑ ᒌ ᒥᔅᑭᒥᑖᒄ ᒋᒨᒋᒑᔨᐦᑎᒧᐎᓂᐙᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ᐅᑎᐦᒋᐱᔨᐦᒑ ᒫᒃ ᐆ ᑳ ᐄᔑ ᐋᔨᒨᑎᒫᑎᑯᒡ, ᓂᒧᐃ ᒑᒀᓐ ᒋᑭ ᐅᐦᒋ ᓂᑐᑎᒧᓈᐙᐤ᙮ ᑯᐃᔅᒄ ᐋ ᐐᐦᑎᒫᑎᑯᒡ ᒥᒄ ᑖᓐ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒧᐙᒄ ᐅᐦᑖᐐᒫᐤ ᓂᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᔮᒄ ᒋᑭ ᒥᔨᑯᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ᓂᒧᐃ ᐋᔥᒄ ᑰᐦᒋ ᓂᑐᑎᒫᓈᐙᐤ ᒑᒀᓐ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᓂᑐᑎᒫᒄ ᐋᒄ ᒫᒃ ᒑ ᒥᔨᑯᐎᔮᒄ, ᐋᒄ ᒥᑐᓐ ᒑ ᒥᔻᔨᐦᑎᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᑳ ᐐᐦᑎᒫᑎᑯᒡ ᐊᐦᐋᐱᒋᐦᑖᔮᓐ ᒋᔅᑯᑎᒫᒑᐤ ᐊᔨᒧᐎᓐ᙮ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᒫᒃ ᒑᒃ ᒑᐦ ᐋᑳ ᐋᐱᒋᐦᑖᔮᓐ ᐅᐦᐄ ᓰᑎᐤ ᑯᐃᔅᒄ ᒑ ᐋᔨᒧᑎᒫᑎᑯᒡ ᐅᐦᑖᐐᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ᐅᑎᐦᒋᐱᔨᐦᒑ ᒫᒃ ᐊᓐ, ᒌᔨᐙᐤ ᐋᒄ ᒑ ᓂᑐᑎᒧᐙᒄ ᒋᔖᒥᓂᑑ ᓂᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᒋᐐᐦᑎᒫᑎᓈᐙᐤ ᒫᒃ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᑎᐙᔨᐦᑖᑯᓐ ᒑ ᒌ ᐊᔨᒥᐦᐋᔮᓐ ᐋ ᓂᑐᑎᒧᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᒥᔨᑖᒄ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ᐙᔥ ᒌ ᓵᒋᐦᐄᑯᐙᐤ ᐐᔨ ᐅᐦᑖᐐᒫᐤ ᐋ ᒌ ᓵᒋᐦᐄᔮᒄ ᑭᔮᐦ ᐋ ᒌ ᑖᑆᐦᑎᒫᒄ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐋ ᒌ ᐅᐦᑐᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ᑖᑆᐦ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᓂᒌ ᐅᐦᑐᐦᑖᓐ ᑳ ᐹᒋ ᑎᑯᔑᓂᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᓂᑭ ᓂᑭᑖᓐ ᒫᒃ ᒦᓐ ᐆ ᐊᔅᒌ, ᑳᐤ ᒫᒃ ᐅᐦᑖᐐᒫᐤ ᓂᑭ ᓈᑖᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ᐋᒄ ᐃᔮᔨᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᐋᒄ ᒫᒃ ᐃᔮᒄ ᑯᐃᔅᒄ ᐊᔨᒥᐦᐄᔮᐦᒡ᙮ ᐋᐦᐋᑳ ᐋᐱᒋᐦᑖᔨᓐ ᒋᔅᑯᑎᒫᒑᐤ ᐊᔨᒧᐎᓐ ᐋᐐᐦᐐᐦᑎᒧᔮᐦᒡ ᒑᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ᐊᓅᐦᒡ ᒫᒃ ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᒥᓯᐙ ᒑᒀᓐ ᐋ ᒋᔅᒑᔨᐦᑎᒥᓐ, ᓂᒧᐃ ᓂᑎᐙᔨᐦᑖᑯᓲ ᐊᐙᓐ ᒑ ᒌ ᑯᒀᒋᒥᔅᒃ ᒑᒀᔨᐤ, ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᑖᑆᐦᑎᒫᐦᒡ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᐋ ᒌ ᐅᐦᑐᐦᑖᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐋᐙ ᐋᒄ ᑎᔮᑆᐦᑎᒫᒄ ᐊᓅᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ, ᔖᔥ ᒫᒃ ᑖᑆᐦ ᐅᑎᐦᒋᐱᔨᐤ ᐊᓂᑎᐦ ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᒑ ᑖᔮᒄ, ᑭᒑᐹᓐ ᒑ ᑖᔮᒄ ᑎᐱᔨᐙ ᒌᒋᐙᐦᒡ᙮ ᐋᒄ ᓃᔨ ᒑ ᐹᔨᑯᔑᔮᓐ ᐋ ᓂᑭᓯᔮᒄ᙮ ᓂᒧᐃ ᒥᒄ ᒋᐦᒋᐙ ᓂᑭ ᐅᐦᒋ ᐹᔨᑯᔑᓐ ᐙᔥ ᐅᐦᑖᐐᒫᐤ ᑖᐤ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᐆ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔮᒄ ᒋᔮᒫᔨᐦᑎᒧᐎᓐ ᐊᓂᑖᐦ ᓃᔨ ᐋᐦ ᑖᔮᓐ᙮ ᒋᑭ ᓂᓈᑳᑖᔨᒧᐦᐄᑯᓈᐙᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᓲᐦᒃ ᐐᐦ ᓲᐦᒋᑖᐦᐋᒄ, ᐙᔥ ᔖᔥ ᓃᔨ ᓂᒌ ᔑᐦᑯᒋᐦᑖᓐ ᐆ ᐊᔅᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅ ᑳ ᒌᔥ ᐊᔨᒥᑦ, ᒌ ᐄᑖᐱᐤ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ ᐋᒄ ᐃᔮᑦ, “ᓅᐦᑖ, ᐋᒄ ᐙᑎᐦᒋᐱᔨᐦᒡ ᐋᐦ ᒌᓂᒀᓂᐦᑖᑦ᙮ ᒋᔅᑖᔨᐦᑖᑯᐦᐄ ᒋᑯᓯᔅ ᒑ ᒋᔅᑖᔨᐦᑖᑰᐦᐄᔅᒃ ᐅᑯᓰᓰᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ᐙᔥ ᒋᒌ ᒥᔮᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒥᓯᐙ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᑎᐹᔨᒫᑦ, ᐋᒄ ᒫᒃ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᒑ ᒌ ᒥᔮᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᒥᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ᒫᐅᑖ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᑦ ᐊᐙᓐ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᒋᔅᒑᔨᒥᔅᑳ ᒌᔨ ᒥᒄ ᐋ ᐹᔨᑯᔑᔨᓐ ᐋ ᑖᑆᐦ ᒋᔖᒥᓂᑑᐎᔨᓐ, ᑭᔮᐦ ᒫᒃ ᒌᓴᔅ ᙭ ᒋᔅᒑᔨᒫᒑ, ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ᓂᒌᐙᐱᐦᑏᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓯᔨᓐ, ᐋ ᒌ ᒌᔑᐦᑖᔮᓐ ᑖᑭᔥ ᐊᓐ ᐋᐱᑎᓰᐎᓐ ᑳ ᐹᒋ ᒥᔨᔨᓐ ᒑ ᑐᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ᓅᐦᑖ, ᐊᓅᐦᒡ ᒫ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᐦ ᒧᔮᒻ ᐊᓐ ᑳ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓯᔮᓐ ᐋᔥᒄ ᐋ ᒌ ᑖᔮᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᓐ, ᐋᔥᒄ ᐋᑳ ᐅᐦᒋ ᑎᑯᐦᒡ ᐆ ᐊᔅᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“ᓂᒌᐦ ᑐᑎᐙᐅᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᑳ ᐹᒋ ᒥᔨᔨᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ ᒑ ᒌ ᒋᔅᒑᔨᒥᔅᒡ᙮ ᒌᔨ ᒋᒌ ᐅᑏᔨᔨᒥᓐ, ᓃᔨ ᒋᒌ ᐹᒋ ᒥᔨᓐ᙮ ᒌ ᓂᓂᐦᐄᐦᑎᒧᒡ ᒫᒃ ᒋᑎᔨᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ᐊᓅᐦᒡ ᒫᒃ ᒋᔅᒑᔨᐦᑎᒧᒡ ᒥᓯᐙ ᐊᓐ ᒑᒀᔨᐤ ᑳ ᒥᔨᔨᓐ ᑖᑆᐦ ᒌᔨ ᐋᐃᐦᑖᔨᓐ ᐋ ᐅᐦᒋᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ᓂᒌ ᐐᐦᑎᒧᐙᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᔨᔨᓐ ᒑ ᒌ ᐐᐦᑎᒨᒀᐤ᙮ ᒌ ᐅᑎᓂᒧᒡ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒨᒀᐤ᙮ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᑆᐦ ᒌᔨ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ, ᑖᑆᐦᑎᒧᒡ ᑭᔮᐦ ᐅᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ᐐᔨᐙᐤ ᓂᑐᑎᒫᔅᑎᒧᐙᐅᒡ, ᓂᒧᐃ ᐐᐦ ᐊᓂᒌ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᓂᑐᑎᒫᔅᑎᒧᐙᐅᒡ, ᒥᒄ ᐊᓂᒌ ᑳ ᐹᒋ ᒥᔨᔨᓐ ᓂᑐᑎᒫᔅᑎᒧᐙᐅᒡ ᐙᔥ ᒌ ᐊᓂᒌ ᒋᑎᐄᔨᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ᒥᓯᐙ ᐊᓐ ᑎᐱᔨᐙᐎᓰᔮᓐ ᒌᔨ ᒋᑎᐱᔨᐙᐎᓰᓐ, ᑭᔮᐦ ᒌᔨ ᐊᓐ ᑎᐱᔨᐙᐎᓰᓐ ᓃᔨ ᓂᑎᐱᔨᐙᐎᓰᓐ᙮ ᓂᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᑭᐎᓐ ᒫᒃ ᐐᔨᐙᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ᐋᒄ ᒫᒃ ᒑ ᓂᑎᐙᐱᒥᑖᓐ᙮ ᔖᔥ ᐐᐱᒡ ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᑖᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᐐᔨᐙᐤ ᒫᒃ ᐋᔥᒄ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒋᑭ ᑖᐅᒡ᙮ ᓅᐦᑖ, ᒌᔨ ᑳ ᐱᔮᐦᒋᓯᔨᓐ, ᒫᒨ ᑭᓄᐙᔨᒥᒡ ᒋᑎᐃᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᒌ, ᐊᓂᔮᔨᐤ ᐃᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᑳ ᐹᒋ ᒥᔨᔨᓐ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐹᔨᑯᒡ ᒧᔮᒻ ᒌᔮᓂᐤ ᐋ ᐄᔑ ᐹᔨᑯᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ᐋᔥᑯ ᒌᐦ ᑖᐅᒡ ᐋᐦ ᑖᒡ ᓂᒌ ᓈᑭᑎᐙᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐃᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᑳ ᐹᒋ ᒥᔨᐐᑦ ᐅᐦᒋ᙮ ᓂᒌ ᑭᓂᐙᔨᒫᐅᒡ, ᓂᒧᐃ ᒫᒃ ᐙᒋ ᐹᔨᒄ ᐅᐦᒋ ᐎᓂᔑᓂᒡ ᒥᒄ ᐊᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᑯᐱᓈ ᒑ ᐎᓂᔑᐦᒃ ᒌ ᐎᓂᔑᓐ᙮ ᒥᓯᐙ ᐆ ᑳ ᐄᔅᐱᔨᒡ ᒌ ᐄᔅᐱᔨᐤ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᑖᓐ ᐋ ᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓈᐦᐄᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ᐊᓅᐦᒡ ᒫᒃ ᒌ ᐹᒋ ᓈᑎᑎᓐ᙮ ᐅᐦᐄ ᒫᒃ ᒑᒀᓂᐦᐄ ᓂᐐᐦᑖᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᔥᒄ ᐋᐦ ᑖᔮᓐ, ᑖᑭᔥ ᒑ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑯᒡ ᓂᒨᒋᒑᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ᓂᒌ ᐐᐦᑎᒧᐙᐅᒡ ᒋᑎᔨᒧᐎᓂᔨᐤ᙮ ᒌ ᐅᐦᑳᑎᑯᒡ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᐤᐦ ᑳᐦ ᑖᔨᒡ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑳ ᐐᒡ ᐃᑖᑎᓯᒫᒡ, ᐙᔥ ᑖᐹ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐄᔑ ᑎᐹᔨᐦᑖᑯᓯᐎᒡ ᒧᔮᒻ ᓃᔨ ᐋ ᐄᔑ ᐋᑳ ᑎᐹᔨᐦᑖᑯᓯᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ᓂᒧᐃ ᐐᐦ ᒋᓂᑐᑎᒫᑎᓐ ᒑ ᒌ ᐅᑎᓂᑣᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ, ᒋᓂᑐᑎᒫᑎᓐ ᒑ ᒌ ᑭᓂᐙᔨᒥᑣᐤ ᐋᑳ ᒑ ᒌ ᐱᒫᔨᒥᑯᒡ ᒥᒋᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ᒧᔮᒻ ᐋ ᐄᔑ ᐋᑳ ᑎᐹᔨᐦᑖᑯᓯᐎᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᐅᒄ ᒧᔮᒻ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ᓂᒧᐃ ᑭᔮᐦ ᐐᔨᐙᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ ᑎᐹᔨᐦᑖᑯᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ᐱᔮᐦᒋᐦᐄᒡ ᒋᑖᑆᐎᓂᐦᒡ᙮ ᒋᑎᔨᒧᐎᓐ ᐋᐅᒄ ᑖᑆᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ᒧᔮᒻ ᒋᑳ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ ᐅᑖᐦ ᐊᔅᒌᐦᒡ ᒧᔮᒻ ᑭᔮᐦ ᓃᔨ ᑳ ᐱᐹ ᐄᑎᔓᐦᐅᒀᐤ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ᐐᔨᐙᐤ ᒫᒃ ᐅᐦᒋ, ᒥᑐᓐ ᓂᑎ ᐄᔑ ᐱᒋᔥᑖᔨᒦᓱᓐ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᐦ ᐱᒋᔥᑖᔨᒥᓲᔅᑖᔅᒡ ᒌᔨ ᐋᐦ ᑖᐅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ᓂᒧᐃ ᒥᒄ ᐅᒌ ᐅᑎᐦ ᓂᑐᑎᒫᔅᑎᒧᐙᐅᒡ᙮ ᓂᑐᑎᒫᔅᑎᒧᐙᐅᒡ ᑭᔮᐦ ᐃᔅᒡ ᑳ ᑖᑆᔮᔨᒥᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳ ᐄᔑ ᐹᒋ ᐋᔨᒨᒥᔨᒡ ᐅᔮᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ᒥᓯᐙ ᒑ ᒌ ᐹᔮᑯᒡ᙮ ᒧᔮᒻ ᒌᔨ ᓅᐦᑖ ᐋ ᐱᐦᒋᔅᑯᐎᔨᓐ, ᓃᔨ ᒫᒃ ᐋ ᐱᒋᔅᑳᑖᓐ, ᐐᔨᐙᐤ ᑭᔮᐦ ᒑ ᒌ ᐲᐦᒋᔥᑳᑎᐦᑰᐦᒡ, ᒑ ᒌ ᑖᑆᐦᑎᐦᒡ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᒌ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ᓂᒌᐦ ᑐᑎᐙᐅᒡ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᒧᔮᒻ ᒌᔨ ᑳᐦ ᑐᑎᐎᔨᓐ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᓯᔮᓐ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᐹᔨᑯᒡ ᒧᔮᒻ ᒌᔮᓂᐤ ᐋ ᐄᔑ ᐹᔨᑯᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ᓃᔨ ᐋ ᐲᐦᒋᔥᑰᒀᐤ ᑭᔮᐦ ᒌᔨ ᐋ ᐹᒋ ᐲᐦᒋᔥᑯᐎᔨᓐ ᐋᑯᑖᐦ ᐅᐦᒋ ᓈᔥᑎᔨᔥ ᒑ ᐹᔨᑯᐦᐋᑭᓂᐎᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᐦᑎᐦᒡ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ ᑳᐦ ᑖᒡ ᒌᔨ ᑖᑆᐦ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ ᑭᔮᐦ ᒫᒃ ᑖᑆᐦ ᐋ ᓵᒋᐦᐄᑣᐤ ᒧᔮᒻ ᓃᔨ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ᓅᐦᑖ, ᒌᔨ ᒋᒌ ᐹᒋ ᒥᔨᓐ ᐅᒌ, ᓂᑎᐙᔨᒫᐆᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋᔥᒄ ᒑ ᒌᐦ ᑖᒡ ᐊᓂᑖᐦ ᐋᐦᑖᐅᒡ, ᒑ ᒌ ᐙᐱᐦᑎᐦᒡ ᓂᒋᔅᑖᔨᐦᑖᑯᓯᐧᐃᓂᔨᐤ, ᐊᓂᔮᔨᐤ ᒋᒋᔅᑖᔨᐦᑖᑯᓯᐧᐃᓂᔨᐤ ᑳ ᐹᒋ ᒥᔨᔨᓐ, ᐙᔥ ᒋᒌ ᓵᒋᐦᐄᓐ ᐋᔥᒄ ᐋᒸᔮ ᐅᐦᒋ ᐅᔑᐦᑖᔨᓐ ᐆ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ᓅᐦᑖ, ᒌᔨ ᒨᔥ ᑳ ᑯᐃᔅᑯᑖᑎᓯᔨᓐ, ᓂᒧᐃ ᒋᒋᔅᒑᔨᒥᑯᒡ ᐊᓂᒌ ᐊᔅᒌᐦᒡ ᐄᔨᔨᐅᒡ, ᓃᔨ ᒫᒃ ᐐ ᒌ ᒋᔅᒑᔨᒥᑎᓐ᙮ ᐅᒌ ᒫᒃ ᑭᔮᐦ ᑳ ᐹᒋ ᒥᔨᔨᓐ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᑆᐦ ᒌᔨ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ᓂᒌᐦ ᑐᑎᐙᐅᒡ ᒑ ᒌ ᒋᔅᒑᔨᒥᔅᒡ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᐴᓃᐙᓐ ᐊᓂᑎᐦ ᐐ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᒥᑯᐎᐱᓈ᙮ ᐋᒄ ᒫᒃ ᐋᓐ ᓵᒋᐦᐄᐙᐎᓐ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᓐ ᒑ ᒌ ᐲᐦᒋᔥᑳᑯᒡ, ᐋᒄ ᒫᒃ ᑭᔮᐦ ᓃᔨ ᒑ ᐲᐦᒋᔥᑰᒀᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᐊᔨᒥᐦᐋᐎᓂᔨᐤ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋ ᐐᒑᐅᑯᑦ᙮ ᐋᒄ ᑳᐦ ᐋᔔᔅᑭᐦᒡ ᐊᓂᔮᔨᐤ ᓰᐲᓯᔨᐤ ᑭᑦᕎᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒌᐦ ᑎᑯᓂᔨᐤ ᒫᒃ ᐊᓂᑎᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ᒍᑖᔅ ᒫᒃ ᐊᓐ ᑳ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓂᑖᐦ ᑳᐦ ᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐙᔥ ᒥᐦᒑᑣᐤ ᒌ ᓂᔥᑐᐎᐅᒡ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ᐋᒄ ᒍᑖᔅ ᐋ ᐐᒑᐅᑯᑦ ᓂᑐᐱᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᒋᐱᐦᐅᐙᓯᐎᔨᒡᐦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᐋᐱᑎᓰᔨᒡᐦ᙮ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐹᕆᓰᐦ ᒌ ᐄᑎᔓᐦᐅᑯᒡ ᒑ ᒌ ᓂᑎᐙᐱᒫᒡ ᒌᓴᔅᐦ᙮ ᒌ ᑎᐦᑯᓂᒧᒡ ᒫᒃ ᐙᔥᑖᓂᒫᑭᓐᐦ ᑭᔮᐦ ᐃᔥᑯᑖᐤ ᐙᔥᑖᓂᒫᑭᓐᐦ ᑭᔮᐦ ᓂᑐᐱᔫᐦᑯᒫᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᒫᒃ ᒌᓴᔅ ᒥᓯᐙ ᑖᓐ ᒑ ᐄᔅᐱᔨᐦᐄᑯᑦ, ᐋᒄ ᑳ ᐹᒋ ᐊᐴᔅᑰᐙᑦ ᐋᒄ ᐋᑖᑦ, “ᐊᐙᓐ ᑳ ᓈᓂᑐᐙᐱᒫᒄ?” ");
INSERT INTO crl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ᐋᒄ ᐋᑖᒡ, “ᒌᓴᔅ ᓈᓵᕆᑦ ᑳ ᐅᐦᒌᑦ ᓂᓈᓂᑐᐙᐱᒫᓈᓐ᙮” ᐋᒄ ᐋᑎᑯᒡ ᒌᓴᔅ, “ᐋᐅᒄ ᓃᔨ᙮” ᒍᑖᔅ ᒫᒃ, ᐊᓐ ᑳᐦ ᒫᒥᔑᒫᑦ ᒌᓴᔅᐦ ᐋᑯᑖᐦ ᑳ ᓃᐴᐎᑦ ᐋ ᐐᒋᑳᐳᔥᑎᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐐᒑᐅᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ᐄᔥᐱᐦ ᒫᒃ ᒌᓴᔅᐦ ᑳᐦ ᐄᑎᑯᒡ, “ᐋᐅᒄ ᓃᔨ,” ᒌ ᐊᔖᑳᐳᐎᒡ ᑳᐦ ᐋᑎ ᐱᐦᒋᔑᐦᒡ ᐊᓂᑖᐦ ᒧᔅᑖᔅᑭᒦᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ᒌᓴᔅ ᒦᓐ ᑳ ᑯᒀᒋᒥᑯᒡ, “ᐊᐙᓐ ᑳ ᓈᓂᑐᐙᔨᒫᒄ?” ᐋᒄ ᐋᑖᒡ, “ᒌᓴᔅ, ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᔖᔥ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ ᓃᔨ ᐋᐦ ᐋᐎᔮᓐ ᐊᓐ᙮ ᓃᔨ ᓃᔮᓂᑐᐙᐱᒧᐙᒀ, ᐱᒋᔅᑎᓈᐦᑯᒡ ᐅᒌ ᑯᑎᑭᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ᐋᔪᐎᒄ ᐙᐦᒋ ᒌ ᐃᔨᑦ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᐊᓂᔮᔨᐤ ᔖᔥ ᐊᓂᑖᐦ ᑳᐦ ᐃᔨᑯᐱᓈ, “ᓅᐦᑖ, ᓂᒧᐃ ᓅᐦᒋ ᐎᓂᐦᐋᐅᒡ ᐙᒋ ᐹᔨᒄ ᐊᓂᒌ ᑳ ᐹᒋ ᒥᔨᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ᓵᐃᒥᓐ ᐲᑎᕐ ᒋᑭᓂᐙᔨᑎᒧᐦᑖᑯᐱᓐ ᐅᓂᑐᐱᔫᐦᑯᒫᓐ ᑭᔮᐦ ᑳ ᑯᐃᑯᓂᐦᒃ, ᑳ ᒥᓂᔑᒸᑦ ᐅᐦᑎᐅᑳᔨᐤ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᒑ ᐊᓂᔮᔨᐤ ᐹᔨᒄ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐅᑖᐱᒋᐦᐋᑭᓂᔨᐤ, ᒫᓪᑭᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ ᐲᑎᕐ, “ᐲᐦᑖ ᐊᓐ ᒌ ᓂᑐᐱᔫᐦᑯᒫᓐ᙮ ᒋᑎᑖᔨᐦᑖᓈ ᐋᑳ ᒑ ᒥᓂᐦᒀᔮᓐ ᐊᓐ ᒥᓂᐦᒀᑭᓐ ᐐᓯᒑᔨᐦᑖᒧᐎᓐ ᓅᐦᑖᐐ ᑳ ᐹᒋ ᒥᔨᑦ?” ");
INSERT INTO crl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ᐊᓂᒌ ᒫᒃ ᓂᑐᐱᔫᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒧᐙᐤᐦ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᑳ ᒋᐱᐦᐅᐙᔓᐎᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒌ ᐅᑎᓈᐅᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᑭᔮᐦ ᒌ ᒫᐦᑯᐱᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ᐊᓂᑖᐦ ᓃᔥᑎᒻ ᐋᓈᔅᐦ ᐋᐦ ᑖᔨᒡ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ᙮ ᐋᓈᔅᐦ ᒫᒃ ᒌᐎᓯᐤ ᑳᔮᕙᔅ᙮ ᐆ ᑳᔮᕙᔅ ᐐᔨ ᒫᐅᒡ ᑳᐦ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒌ ᐄᑖᐱᑎᓰᐤ ᐊᓂᔮᔨᐤ ᑳ ᐱᐳᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ᐋᐅᒄ ᐆ ᑳᔮᕙᔅ ᑳᐦ ᐃᔨᑖᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᐅᔅᑖ ᒑ ᒥᔪᐱᔨᐦᑯᐱᓈ ᐹᔨᒄ ᓈᐹᐤ ᒑ ᒌ ᓂᐳᔅᑎᒧᐙᔨᒡ ᒥᓯᐙ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ᓵᐃᒥᓐ ᐲᑎᕐ ᑭᔮᐦ ᒦᓐ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᓅᔔᔥᑯᐙᐅᒡ ᒌᓴᔅᐦ᙮ ᐊᓐ ᒫᒃ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᓈᔥᒡ ᒌ ᒥᔪ ᒋᔅᒑᔨᒥᑰ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ᙮ ᐋᒄ ᑳ ᐐᒑᐙᑦ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᐋ ᐲᐦᒑᔨᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᔮᔅᑯᓂᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ᐲᑎᕐ ᒫᒃ ᐎᔨᐐᑎᒥᔅᒀᐦᒡ ᐊᓂᑎᐦ ᒌᐦ ᑖᐤ ᐐᔨ᙮ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᒥᔪ ᒋᔅᒑᔨᒥᑯᑦ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳᐤ ᒌ ᐎᔨᐐᐤ, ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᔥ ᐊᓂᑎᐦ ᐃᔥᒀᐦᑖᒥᐦᒡ ᑳ ᑖᔨᐦᒡ ᑳ ᑯᒀᒋᒫᑦ ᒑ ᒌ ᐲᐦᒑᔨᒡ ᐲᑎᕐ᙮ ᐋᒄ ᑳ ᐲᐦᑎᑭᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ᐊᓐ ᒫᒃ ᐃᔅᒀᔥ ᐊᓂᑎᐦ ᐃᔥᒀᐦᑖᒥᐦᒡ ᑳᐦ ᑖᑦ ᐋᒄ ᐋᑖᑦ ᐲᑎᕐ, “ᐋᐙ ᒌᔨ ᐹᔨᒄ ᒌᓴᔅᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ?” ᐋᒄ ᐄᔮᑦ᙮ “ᓂᒫ᙮ ᓂᒥᔮᐤ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ᒌ ᑎᐦᑳᔮᔨᐤ ᒫᒃ᙮ ᐋᒄ ᐊᓂᒌ ᐋᐱᒋᐦᐋᑭᓂᒡ ᐋᔨᐤᐦ ᑭᔮᐦ ᒋᐱᐦᐅᐙᓱᔨᒡ ᑳ ᑯᑐᐙᒡ ᐋᒄ ᑳ ᐙᔅᑳᑳᐳᔥᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐃᔥᑯᑖᔨᐤ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐊᐅᔓᒡ᙮ ᐲᑎᕐ ᒫᒃ ᑭᔮᐦ ᐐᔨ ᒌ ᐹᒋ ᐐᒋᑳᐳᔥᑎᐙᐤ ᐋ ᐹᒋ ᐊᐆᔓᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᓂᓈᐦᑭᐤ ᑳ ᐄᔑ ᑯᒀᒋᒫᑦ ᒌᓴᔅᐦ ᐋ ᐐ ᓂᑐᒋᔅᒑᔨᒫᑦ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᔨᐤᐦ ᑭᔮᐦ ᐅᒋᔅᑯᑎᒫᒑᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ, “ᒥᓯᐙ ᑖᓐ ᑳ ᐃᔮᓐ ᒌ ᐹᐦᑎᒧᒡ ᐄᔨᔨᐅᒡ᙮ ᐊᓐ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔮᓐ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᓂᑖᐦ ᒥᓯᐙ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᐹᒋ ᓂᔥᑐᐐᒡ, ᓂᒧᐃ ᓂᐦᑖ ᒌᒧᒡ ᓄᐦᒋ ᐊᔨᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ᒑᒀᓐ ᐙᐦᒋ ᐹᒋ ᑯᒀᒋᒥᔨᓐ? ᑯᒀᒋᒥᒡ ᒫᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᐹᐦᑑᐎᒡ᙮ ᑯᒀᒋᒥᒡ ᑖᓐ ᑳ ᐄᑎᒀᐤ, ᐙᔥ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᑳᐦ ᐃᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ᐅᔮᔨᐤ ᑳᐦ ᔨᑦ ᒌᓴᔅ, ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᑳ ᒋᐱᐦᐅᐙᓯᐎᔨᒡ ᒌ ᐅᑖᒥᐦᒀᐦᐅᑰ ᐋᐦ ᐄᑎᑯᑦ, “ᓂᒧᐃ ᒋᑭ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ, “ᐋᑳ ᒧᔮᒻ ᐙᐦᒋ ᔨᐙᓈ ᒑᒀᓐ, ᐐᐦᑎᒧᐎᒡ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᑳᐦ ᑖᒡ᙮ ᒥᒄ ᒫᒃ ᑳ ᑖᑆᐙᓈ ᒥᓯᐙ ᑳ ᐃᔮᓐ, ᒑᒀᓐ ᐙᐦᒋ ᐹᒋ ᐅᑖᒧᐦᐅᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ᐋᒄ ᐋᓈᔅ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᑳᔮᕙᔅ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᐋᔥᒄ ᐋ ᒫᐦᑯᐱᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ᓵᐃᒥᓐ ᐲᑎᕐ ᒫᒃ ᐋᔥᒄ ᒫᒀᒡ ᒌ ᓃᐴ ᐊᓂᑎᐦ ᐋ ᐊᐆᔓᑦ᙮ ᐋᒄ ᐋᑖᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ, “ᓂᒥᔮᐤ ᐋ ᒌᔨ ᐹᔨᒄ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓐ ᓈᐹᐤ?” ᐲᑎᕐ ᒫᒃ ᒌ ᓂᑎᔨᐤ ᐋᐦ ᐃᔨᑦ, “ᓂᒫ᙮ ᓂᒥᔮᐤ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐱᒋᐦᐋᑭᓐ ᒌ ᐙᐦᑯᒫᔨᐦᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐲᑎᕐ ᑳ ᒥᓂᐦᑎᐅᑳᔮᔂᑦ᙮ ᐋᒄ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐ, “ᐋᐅᒄ ᒋᒋᐃᓯᓈᑎᓐ ᑳ ᐙᐱᒥᑖᓐ ᑭᔮᐦ ᒌᔨ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᐋ ᐱᐹᐐᒑᐅᑦ ᒌᓴᔅ, ᓂᒫ?” ");
INSERT INTO crl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ᒦᓐ ᒫᒃ ᐊᔮᐱᒡ ᐲᑎᕐ ᒌ ᓂᑎᔨᐤ ᐋᐦ ᐃᔨᑦ, “ᓂᒥᔮᐤ ᓃᔨ᙮” ᑏᐙᐦᒡ ᑳ ᐅᐦᒋ ᐹᐦᑖᑯᓰᔨᒡ ᓈᐹᐹᐦᑭᐦᐋᐦᒀᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ᐐᐱᒡ ᐊᓂᔮᔨᐤ ᑳ ᒑᒋᔖᐹᔮᔨᒡ ᐊᓂᑎᐦ ᑳᔮᕙᔅ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᒋ ᒋᔅᑐᐦᑎᐦᐋᑭᓂᐤ ᒌᓴᔅ, ᐊᓂᑖᐦ ᕉᒻ ᐅᒋᒫᐤᐦ ᐅᒋᓵᐙᔅᑳᐦᐄᑭᓂᒥᔨᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑭᓅᑦ᙮ ᐹᔨᓕᑦ ᒌ ᐃᔑᓂᐦᑳᓲ ᐊᓐ ᕉᒻ ᐅᒋᒫᐤ᙮ ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐲᐦᒑᐅᒡ ᐐᔨᐙᐤ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᒋᐐᐦ ᒥᒋᓈᑯᐦᐄᓯᐎᒡ ᐅᑎᔨᒥᐦᐋᐎᓂᐙᐦᒡ᙮ ᑭᔮᐦ ᐊᑑᒡ ᐅᐦᒋ ᒌ ᒦᒋᐆᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓂᔨᐤ ᒌ ᐲᐦᒑᐙᑯᐱᓈ ᐅᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐙᐦᒡ ᒌᐦ ᐎᔨᐐᑦ ᐹᔨᓕᑦ, ᑳ ᓂᑎᐙᐱᒫᑦ ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ, “ᑖᓐ ᐋ ᐄᔑ ᐊᑖᒫᔨᐦᑖᑯᓯᑦ ᐆ ᓈᐹᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ᐋᒄ ᐋᑖᒡ, “ᐋᑐᒡ ᓅᐦᒋ ᐹᔓᐙᓈᓐ ᑳ ᐅᐦᒋ ᒥᒋᐦᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ᐋᒄ ᐹᔨᓕᑦᐦ ᐋᑎᑯᒡ, “ᒌᔨᐙᐤ ᐅᑎᓈᐦᒄ ᐆ ᓈᐹᐤ ᒌᔨᐙᐤ ᒌ ᐐᔓᐙᐎᓂᐙᐤ ᒑ ᐋᐱᒋᐦᑖᔮᒄ ᐋ ᑎᐹᔅᑯᓈᒄ᙮” ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᑖᒡ, “ᓂᒧᐃ ᓂᐱᒋᔅᑎᓂᑯᓈᓐ ᓂᐐᔓᐙᐎᓈᓐᐦ ᒑ ᒌ ᐃᔨᔮᐦᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ ᐊᐙᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐄᔅᐱᔨᒡ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᐦᒃ ᒌᓴᔅ ᒑ ᐄᔑ ᐳᓂᐱᒫᑎᓰᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ᒦᓐ ᑳᐤ ᐹᐦᒑᑦ ᐹᔨᓕᑦ ᐊᓂᔮᔨᐤ ᒋᓵᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐋ ᓂᑑᒫᑦ ᒌᓴᔅᐦ ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ, “ᐋᐙ ᒌᔨ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ᐋᒄ ᒌᓴᔅ ᐋᑎᑯᑦ, “ᒌᔨ ᐆ ᐙᒋᐦᒡ ᒋᑎᐄᑖᔨᐦᑎᒧᐎᓐ ᑭᔮᐦ ᒫᒃ ᑯᑎᑭᒡ ᐋ ᒋᒌ ᐐᐦᑎᒫᑯᒡ ᐅᔮᔨᐤ ᑳ ᐃᔑᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ᐋᒄ ᐹᔨᓕᑦ ᐋᑖᑦ, “ᒎᐤ ᐋ ᓃᔨ ᒋᑎᐄᑖᔨᒥᓐ? ᒌ ᑎᐱᔨᐙ ᒋᑎᐄᔨᔨᒥᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒋᒌ ᐹᒋ ᐄᑎᔓᐦᐅᑯᒡ᙮ ᒑᒀᓐ ᒫᒃ ᑳᐦ ᑐᑎᒥᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᓂᒧᐃ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋᐱᔨᐤ ᓅᒋᒫᐎᓐ᙮ ᐅᑎᐦ ᒌ ᐅᐦᒌᒫᑭᓂᑯᐱᓈ ᓅᒋᒫᐎᓐ ᓲᐦᒃ ᒋᐱᐦ ᒫᔑᐦᒑᐅᒡ ᐊᓂᒌ ᓂᑖᐱᒋᐦᐋᑭᓂᒡ ᐋᑳ ᒑ ᒌ ᐱᒋᔅᑎᓂᑯᐎᒡ ᐊᓂᑖᐦ ᒎᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ᒥᒄ ᓂᒧᐃ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋᐱᔨᐤ ᓅᒋᒫᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ᐋᒄ ᐹᔨᓕᑦ ᐋᑖᑦ, “ᑖᑆᐦ ᑭᔨᑆ ᒑᐦ ᒋᐦᒋᐅᒋᒫᐎᔨᓐ᙮” ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᒋᔑᓐ ᐋ ᒋᐦᒋᐅᒋᒫᐎᔮᓐ᙮ ᐋᐅᒄ ᐙᐦᒋ ᐄᔨᔨᐎᔮᓐ ᑭᔮᐦ ᐋᐅᒄ ᐙᐦᒋ ᐹᒋ ᑎᑯᔑᓂᔮᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᒋᔅᒑᔨᐦᑖᑯᓂᐦᒑᔮᓐ ᐊᓐ ᑖᑆᐎᓐ᙮ ᑎᐦᑐ ᐊᐙᓐ ᑖᑆᐎᓂᐦᒡ ᑳᐦ ᑖᑦ ᐋᐅᒄ ᐊᓐ ᐱᔮᒋ ᓂᑑᐦᑎᐎᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ᐹᔨᓕᑦ ᑳ ᑯᒀᒋᒫᑦ ᐋᑖᑦ, “ᒑᒀᓐ ᐊᓐ ᑖᑆᐎᓐ?” ᐋᒄ ᒦᓐ ᑳᐤ ᑳ ᐎᔨᐐᑦ ᐋᒄ ᐋᑖᑦ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ, “ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑎᒸᓐ ᒑᒀᔨᐤ ᑳ ᐎᓂᑐᑎᒧᒀ ᐋᓂᑎ ᒑ ᒌ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ᑎᑯᓐ ᒫᒃ ᐃᔨᐦᑎᐎᓐ ᐹᔨᒄ ᒋᐴᐦᐙᑭᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑯᔮᒄ ᒫᒀᒡ ᐋ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᓂᐎᔨᒡ᙮ ᒋᓂᑎᐙᔨᒫᐙᐤ ᐋ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑯᔮᒄ ᐆ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ᐋᒄ ᒦᓐ ᑎᔮᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᓂᒧᐃ ᐐᔨ ᐊᓐ᙮ ᐹᕌᐹᔅ ᐋᐅᒄ ᓈᑐᐙᔨᒥᒋᐦᑦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑯᔮᐦᒡ᙮” ᐅᔮᔨᐤ ᒫᒃ ᐹᕌᐹᔅ ᒌ ᒋᒧᑎᔅᑰᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ᐋᒄ ᐹᔨᓕᑦ ᑳᐦ ᐄᑎᔓᐙᑖᑦ ᒌᓴᔅᐦ ᒑ ᒌ ᒋᔅᑐᐦᑎᐦᐋᑭᓂᐎᔨᒡ ᒑ ᒌ ᓂᑑᐱᔑᔥᑖᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ᐊᓂᒌ ᒫᒃ ᓂᑐᐱᔫᒡ ᒌ ᐅᔑᐦᑖᐅᒡ ᐅᒋᒫᐤ ᐊᔥᑐᑎᓂᔨᐤ ᑳ ᑳᔓᑖᐙᔅᑯᓃᔨᔨᒡ ᓃᐱᓰᔮᐦᑎᒄ ᐋᐦ ᐋᐱᒋᐦᑖᒡ᙮ ᑳ ᐳᔥᑭᒧᔮᐦᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᐊᔥᑐᑎᓂᔨᐤ᙮ ᑭᔮᐦ ᐋ ᒋᓍᑭᓃᔨᒡ ᐊᑯᐦᐱᔨᐤ ᐋ ᒥᐦᒀᑭᓃᔨᒡ ᒌ ᐳᔥᒋᔥᑭᒧᑎᔮᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ᒌ ᒫᔮᔨᒫᐅᒡ ᒧᔮᒻ ᐋ ᒫᒥᐦᒋᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᐙᒋᔮ ᒌᔨ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ᑭᔮᐦ ᒌ ᐅᑖᒥᐦᒀᐦᐙᐅᒡ ᐅᑎᐦᒌᐙᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ᒦᓐ ᑳ ᐎᔨᐐᑦ ᐹᔨᓕᑦ ᑭᔮᐦ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᒦᓐ ᒋᑭ ᐹᒋ ᐎᔨᐐᐦᑎᐦᐋᑭᓂᐤ ᐆ ᓈᐹᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒫᒄ ᐋᐦᐋᑳ ᒥᔅᑭᒧᒡ ᑖᓐ ᒑ ᒌ ᐄᔑ ᓂᔑᐎᓈᒋᒥᒃ ᓃᔨ ᐐᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ᐋᒄ ᒌᓴᔅ ᐹᔮᒡ ᐎᔨᐐᑦ ᐋ ᒋᒋᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐊᔥᑐᑎᓂᔨᐤ, ᑳᑳᐙᔅᑯᓃᔨᒡ ᓃᐱᓯᔮᐦᑎᑯᐦᒡ ᑳ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᒋᓍᑭᓃᔨᒡ ᐊᑯᐦᐱᔨᐤ ᑳ ᒥᐦᒀᑭᓃᔨᒡ ᐋ ᒋᒋᔥᑭᐦᒃ᙮ ᐋᒄ ᐹᔨᓕᑦ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, “ᒫᐤ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᐱᐦᐅᐙᓯᐎᔨᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐃᔥᑯᑎᒃ ᐎᔮᐱᒫᒡ ᒌᓴᔅᐦ, ᓲᐦᒃ ᑏᔮᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᒌᔅᑖᔅᑯᐦᐋᐦᒄ, ᒌᔅᑖᔅᑯᐦᐋᐦᒄ᙮” ᐹᔨᓕᑦ ᐋᑖᑦ, “ᒌᔨᐙᐤ ᓂᑑᒌᔅᑖᔅᑯᐦᐋᐦᒄ᙮ ᓂᒧᐃ ᓂᒥᔅᑭᒸᓐ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒧᒀ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓂᔥᒀᐅᔑᐦᐋᒡ ᐹᔨᓕᑦ ᐋᐦ ᐄᑖᒡ, “ᓂᑎᔮᓈᓐ ᐐᔓᐙᐎᓐ, ᐊᒀᒋᔥᑖᒡ ᐊᓂᑎᐦ ᓂᐐᔓᐙᐎᓈᐦᒡ ᒑ ᒌ ᐄᑎᔓᐙᓂᐎᔨᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒌ ᐃᔨᑦ ᐐᔨ ᐋᐦᐋᐎᑦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ᐹᔨᓕᑦ ᒫᒃ ᑳ ᐹᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐋᐦ ᐄᓈᓂᐎᔨᒡ, ᐊᑎᑎᐤ ᒌ ᓵᒋᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ᐋᒄ ᒦᓐ ᐹᐦᒑᒡ ᐊᓂᑖᐦ ᒋᓵᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐋᒄ ᐋᑖᑦ ᒌᓴᔅᐦ, “ᑖᓂᑖᐦ ᐙᐦᒋᔨᓐ?” ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑᑎᑰ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ᐋᒄ ᐹᔨᓕᑦ ᐋᑖᑦ, “ᓂᒧᐃ ᐋ ᒌ ᐐᐦ ᐊᔨᒥᐦᐄᔨᓐ? ᓂᒧᐃ ᐋ ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐋ ᐃᔮᔮᓐ ᑎᐹᔨᐦᒋᒑᐎᓐ ᒑ ᒌ ᐄᑎᔓᐙᔮᓐ ᒑ ᒌ ᐱᒋᔅᑎᓂᑭᐎᔨᓐ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐅᑭᐎᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ᐋᒄ ᒌᓴᔅ ᐋᔅ ᓂᔥᒀᐅᔑᐦᐄᑯᑦ, “ᒥᒄ ᒑᔓᐙᑦ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᒥᔨᔅᒃ ᐊᓂᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ ᒑ ᒌ ᑑᑐᐎᑦ ᐋᐅᒄ ᐙᐦᒋ ᒌᐦ ᑎᑯᐦᒡ ᐊᓐ ᒑ ᒌᐦ ᑎᔨᓐ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒌᔨ ᐋᐦ ᑖᔨᓐ ᑳ ᐄᔑ ᐱᒋᔅᑎᓱᐙᓯᑦ ᐋᐅᒄ ᐊᑎᑎᐤ ᒫᒋᑑᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐄᔨᔨᒡ ᒌᓴᔅᐦ, ᐹᔨᓕᑦ ᒋᐐᐦ ᐱᒋᔅᑎᓈᐤ᙮ ᐋᒄ ᒥᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᑖᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᐹᒋᔥᑎᓈᒀ ᒌᓴᔅ ᓂᒧᐃ ᒌ ᐅᐐᒑᐙᑭᓂᑐᑎᐙᐙᐤ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ᙮ ᐙᔥ ᐊᐙᓐ ᑳ ᒋᐦᒋᐅᒋᒫᐅᐦᐄᓱᑦ ᓂᔥᑯᔥᑎᐙᐤ ᓰᓯᕐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ᐄᔥᐱᐦ ᒫᒃ ᐹᔨᓕᑦ ᐱᔮᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᑖᑆᔨᒡ ᐎᔨᐐᑎᒥᐦᒡ ᒌ ᐄᑐᐦᑎᐦᐋᐤ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᐅᐙᔨᐱᑦ ᐊᓂᑎᐦ ᑎᐹᔅᑯᓂᒑᐤ ᑖᐦᑎᐱᐎᓂᐦᒡ, ᐊᓂᑖᐦ ᐋ ᐊᓯᓃᐦᑳᓂᐎᔨᒡ ᐋ ᒌ ᐊᔅᑖᔨᒡ᙮ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᓈᓂᐎᒡ ᑳᐹᑖ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᐊᓯᓃᐦᑳᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ᒫᒀᒡ ᒫᒃ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᒥᔮᔅᑳᒑᐎᓐ ᒥᑯᔖᐎᓐ ᐋ ᐃᔮᔅᑭᐎᔥᑖᑭᓂᐎᒡ ᒌ ᐄᔑ ᒌᔑᑳᐤ᙮ ᒑᑳᑦ ᒫᒃ ᒌ ᐋᐱᐦᑖᒌᔑᑳᔨᐤ, ᐋᒄ ᐋᑖᑦ ᐹᔨᓕᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, “ᑭᓂᐙᐱᒫᐦᒄ ᒫᐤ ᒋᒋᐦᒋᐅᒋᒫᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ᐅᔮᔨᐤ ᓲᐦᒃ ᒌ ᑖᑆᐅᒡ ᐋᐦ ᐃᔨᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ, “ᓂᐱᐦᐋᐦᒄ, ᓂᐱᐦᐋᐦᒄ, ᒌᔅᑖᔅᑯᐦᐋᐦᒄ,” ᐋᐦ ᐄᑖᒡ᙮ ᐋᒄ ᐹᔨᓕᑦ ᐋᑖᑦ, “ᒋᓂᑎᐙᔨᒥᓈᐙᐤ ᐋ ᒑ ᒌ ᐱᒋᔅᑎᓂᐦᒃ ᒋᒋᐦᒋᐅᒋᒫᒧᐙᐤ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ?” ᐋᒄ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᒌ ᓂᔥᒀᐅᔑᐦᐄᑰ ᐹᔨᓕᑦ ᐋᐦ ᐃᔨᒡ, “ᒥᒄ ᓰᓯᕐ ᓅᒋᐦᒋᐅᒋᒫᒥᓈᓐ ᓂᒧᐃ ᑯᑎᒃ ᐊᐙᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ᐋᒄ ᐹᔨᓕᑦ ᑳ ᐱᒋᔅᑎᓈᒨᐙᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐙᔨᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᐋᒄ ᑳ ᒋᔅᑐᐦᑎᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ᐋᒄ ᐙᔨᐎᒡ, ᒌᓴᔅᐦ ᐋ ᐅᓂᑳᑐᐦᐙᔨᒡ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᔨᐤ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ “ᒥᔥᑎᒀᓂᑭᓐ ᑳᐦ ᑎᑯᐦᒡ” ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐆ ᒫᒃ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᓈᓂᐎᒡ “ᒀᓪᒀᕧ” ᐄᓈᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒡ ᑭᔮᐦ ᒫᒃ ᓃᔓ ᓈᐹᐤ ᒌ ᒌᔅᑖᔅᑯᐦᐆᒫᑭᓂᐎᔨᐤ ᑳ ᒋᒥᔨᒫᑭᓂᐐᔨᒡ ᔮᐄᑑ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ᐹᔨᓕᑦ ᒫᒃ ᐋ ᒌ ᒥᓯᓂᐦᐄᒑᑦ ᒌ ᒋᑭᒧᐦᑖᑭᓂᔨᐤ ᐊᓂᑎᐦ ᐃᔥᐱᒥᐦᒡ ᒌᓴᔅᐦ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᔨᒡ ᐋᐦ ᐄᑎᔥᑖᔨᒡ, “ᒌᓴᔅ ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ᒥᐦᒑᑐ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐹᒋ ᐊᔨᒥᐦᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐙᔥ ᓂᒧᐃ ᐅᐦᒋ ᔮᐎᓈᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒉᕉᓯᓕᒻ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ᙮ ᓂᔥᑐᔨᒡ ᒫᒃ ᐊᔨᒧᐎᓐ ᒌ ᐋᐱᑎᓃᔨᑯᐱᓐ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ, ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᓈᓂᐎᒡ, ᓛᑎᓐ ᑭᔮᐦ ᒃᕇᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓃᑳᓂᔒᒡ ᐅᑎᔨᒥᐦᐋᐅᒋᒫᒧᐙᐤᐦ ᐋᑖᒡ ᐹᔨᓕᑦ, “ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐄᑎᔥᑖᓐ ᐊᓐ ᒎᐎᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤᐦ ᑳᐦ ᐄᑎᔥᑖᔨᓐ᙮” ᐋᐦᑎᓯᓂᐦᐋᐦ ᐊᓐ ᒦᔥᑯᒡ ᒑ ᒌ ᐄᑎᔥᑖᒡ, “ᒌ ᐃᔨᐤ, ᓃᔨ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒋᐦᒋᐅᒋᒫᒧᐙᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ᐹᔨᓕᑦ ᐋᒃ ᐋᑎᑯᒡ, “ᑖᓐ ᑳᐦ ᐄᑎᔥᑖᔮᓐ ᐋᐅᒄ ᒑ ᐄᑎᔥᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ᐄᔥᐱᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐋᒄ ᐊᓂᔮᔨᐤ ᐅᒑᒀᓂᒥᔨᐤ ᑳ ᒫᑎᓂᒫᑐᐙᒡ ᐋ ᓈᐅᑖᐙᒡ ᐹᐦᐹᔨᒄ ᒑ ᒌ ᐃᔮᒡ ᐹᔨᒄ ᒑᒀᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᑯᐦᐱᔨᐤ ᐅᔅᒋᒡ ᑳ ᒌ ᒋᒋᔥᑭᒥᔨᒡ ᐋ ᒥᓴᐙᔮᑭᓃᔨᒡ ᒌ ᐃᓯᓈᑯᓂᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᑎᑯᓂᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐱᒥᒀᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ᐋᒄ ᐊᑎᑑᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ, “ᐋᑯᔥ ᐋᑳ ᐅᐦᒋ ᐲᑯᔑᒸᑖᐤ ᐅᔮᔨᐤ ᐅᑎᑯᐦᑉ᙮ ᑯᒋᐦᐄᑐᑖᐤ ᐊᐙᓐ ᒑ ᑖᐅᐦᐄᒑᒀ ᐊᓂᔮᔨᐤ ᐊᑯᐦᐱᔨᐤ᙮” ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᑎᒡ ᐋᑯᑖᐦ ᑳ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᑎᓯᓂᐦᐄᑭᓂᐎᔨᑯᐱᓈ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒌ ᒫᒫᑎᓂᒫᑑᒡ ᓂᒑᒀᓂᒻ ᐋ ᑖᐅᐦᐄᑳᒑᓅᒡ ᓂᑎᑯᐦᑉ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ᒌᓴᔅ ᒫᒃ ᐅᑳᐐᐦ ᐹᔓᒡ ᒌ ᓃᐴᔨᐤ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᐅᑖᔑᑖᔮᐦᑎᑯᒥᐦᒡ ᑭᔮᐦ ᐅᑳᐐᐦ ᐐᒋᔖᓂᔅᒀᒥᔨᐤ ᐋᑯᑖᐦ ᑳ ᓃᐴᐎᔨᒡ ᑭᔮᐦ ᒣᕇ, ᑭᓨᐹᔅ ᐐᐤᐦ ᑭᔮᐦ ᒣᕇ ᒫᒃᑖᓖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ᐄᔥᐱᐦ ᒌᓴᔅ ᐎᔮᐱᒫᑦ ᐅᑳᐐᐦ ᑭᔮᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᓵᒋᐦᐋᑦ ᐋ ᓃᐴᐎᔨᒡ ᐊᓂᑎᐦ, ᐋᒄ ᐋᑖᑦ ᐅᑳᐐᐦ, “ᒫᐤ ᒋᑯᓯᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ᐋᒄ ᐋᑖᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᒫᐤ ᒋᑳᐐ᙮” ᐊᓐ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋᑯᑖᐦ ᓂᒋᔅᒃ ᑳ ᐅᐦᒋ ᒋᐦᒋ ᑭᓂᐙᔨᒫᑦ ᒌᓴᔅᐦ ᐅᑳᐐᔨᐤ ᐊᓂᑖᐦ ᐐᒋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ᐹᑎᒫ ᒫᒃ ᒌᓴᔅ ᒌ ᒋᔅᒑᔨᐦᑎᒻ ᔖᔥ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋ ᒌ ᒌᔑᐱᔨᔨᒡ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᓂᐐᐦ ᒥᓂᐦᒀᓐ᙮” ᑳᐦ ᐃᔨᑦ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑖᑯᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᒑ ᐃᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ᒌ ᑎᑯᓐ ᒫᒃ ᐊᓂᑎᐦ ᐋᑐᑎᐹᐙᑭᓐ ᐋ ᓵᑭᔅᒋᓈᐹᔮᒡ ᐋ ᐐᓯᑳᑭᒦᐦᒡ ᔔᒥᓈᐳᐃ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐊᑯᐦᑖᒡ ᐅᐦᐱᓂᔑᒡ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᑳ ᐊᒀᐱᐦᑳᑎᐦᒡ ᒥᔅᑎᑯᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᐅᑑᓃᔨᐦᒡ ᑳ ᐄᑖᔅᑯᓂᒸᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ᐄᔥᐱᐦ ᒌᓴᔅ ᑳ ᒥᓂᐦᒀᑦ ᐋᒄ ᐃᔮᑦ, “ᔖᔥ ᒌᔅᑖᑭᓂᐤ᙮” ᐋᒄ ᑳ ᐊᒋᔅᑖᐎᓂᔅᒀᔨᑦ ᐊ ᐱᒋᔅᑎᓈᑦ ᐅᑎᐦᒑᐦᒄ ᑳᐦ ᐋᑎ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᒫᐅᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐅᒫᑭᓂᐎᔨᒡ ᐋᔥᒄ ᒑ ᒌ ᐄᑎᑯᒋᓃᔨᒡ ᐙᐱᓃᔨᒑ ᐙᔥ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒑ ᒋᔅᑎᒫᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ ᐹᔨᓕᑦᐦ ᒑ ᒌ ᐄᑎᔓᐙᔨᒡ ᒑ ᒌ ᓈᑣᑳᑖᐦᐆᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ, ᑭᔮᐦ ᒑ ᒌ ᓃᐦᑎᓂᑭᓂᐐᔨᒡ ᐐᐅᐙᔨᐤ ᒑ ᒌ ᓂᐦᐄᐦᑳᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᓈᑣᑳᑖᐦᐙᒡ ᐊᓂᔮᔨᐤᐦ ᓃᔓᐦ ᓈᐹᐤᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐆᒫᑭᓂᐐᔨᒡ ᒌᓴᔅᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐅᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ᒌᓴᔅ ᒫᒃ ᔖᔥ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᐐᔨ ᐄᔥᐱᐦ ᐙᑎᐦᑖᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᓈᑣᑳᑖᐦᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ᐹᔨᒄ ᒫᒃ ᐊᓐ ᓂᑐᐱᔨᐤ ᒌ ᑎᐦᑭᒫᐤ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐅᐦᐱᒫᔨᐤ᙮ ᑏᐙᐦᒡ ᑳ ᐅᐦᒋ ᑯᐃᒀᓯᑳᐐᒡ ᐅᒥᐦᑯᔨᐤᐦ ᑭᔮᐦ ᓂᐲᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ᐊᓐ ᐊᐙᓐ ᑎᐱᔨᐙ ᐅᔥᒌᔑᑯᐦᒡ ᐋ ᒌ ᐅᐦᒋ ᐙᐱᐦᑎᐦᒃ ᐅᔮᔨᐤ ᑖᑆᐦ ᐐᐦᑎᒻ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᒑ ᒌ ᑖᑆᐦᑎᒫᒄ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ᒋᔅᒑᔨᐦᑎᒻ ᐋ ᑖᑆᑦ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ᐙᔥ ᐆ ᒌ ᑐᑖᑭᓂᐤ ᒑ ᒌ ᑎᐱᐱᔨᒡ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᒧᐃ ᐙᒋᐹᔨᒄ ᐅᐦᒋ ᓈᑣᐦᐄᑭᓅᔨᐤ ᐐᔨ ᐅᔅᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ᑭᔮᐦ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒋᑭ ᑭᓂᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᑎᐦᑭᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ᐹᑎᒫ ᒫᒃ ᒍᓯᕝ, ᐋᕆᒫᕠᔮᐦᒡ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᐅᐦᒌᑦ ᓈᐹᐤ ᒌ ᓂᑎᐙᔨᐦᑎᒧᐙᐤ ᐹᔨᓕᑦᐦ ᒌᓴᔅᐦ ᐐᔮᔨᐤᐦ ᒑ ᒌ ᓂᐦᐄᑭᒸᑦ᙮ ᐆ ᒍᓯᕝ ᒥᒄ ᒌᒧᒡ ᒌ ᑖᑆᔮᔨᒫᐤ ᒌᓴᔅᐦ ᐙᔥ ᒌ ᑯᔥᑖᐤ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ᙮ ᒌ ᓂᔅᑯᒨ ᒫᒃ ᐹᔨᓕᑦ ᑖᓐ ᑳ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᒍᓯᕝᐦ᙮ ᐋᒄ ᒫᒃ ᒍᓯᕝ ᑳ ᐅᑎᓂᒸᑦ ᒌᓴᔅ ᐐᔮᔨᐤ ᑳ ᒋᔅᑐᐦᑎᑖᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ᓂᑯᑏᒧᔅ ᒫᒃ ᒌ ᐐᒑᐅᑰ᙮ ᐋᐅᒄ ᐆ ᓂᑯᑏᒧᔅ ᐋ ᑎᐱᔅᑳᔨᒡ ᓃᔥᑎᒻ ᑳ ᐹᒋ ᓈᑖᑦ ᒌᓴᔅᐦ᙮ ᒌ ᐃᔮᐤ ᒫᒃ ᑑᒥᓂᑭᓂᔨᐤ ᓃᐱᓰ ᒥᕐ ᑭᔮᐦ ᐊᓨ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋ ᒌ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᔨᒡ᙮ ᐎᔮᔥ ᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᐹᐹᔅᑯᒋᑭᓐ ᒌ ᐄᔅᐱᐦᑎᓂᑯᓂᔨᐤ ᐅᔮᔨᐤ ᑑᒥᓂᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ᐋᒄ ᐅᒌ ᓃᔓ ᓈᐹᐅᒡ ᓂᑯᑏᒧᔅ ᑭᔮᐦ ᒍᓯᕝ ᑳ ᐅᑎᓂᒸᒡ ᒌᓴᔅᐦ ᐐᔮᔨᐤ ᑳ ᑎᐦᑎᐹᔮᒋᓂᒸᒡ ᐱᒋᐎᔮᓈᒋᓂᒡ ᑭᔮᐦ ᒌ ᒥᔪᒫᑯᑖᐙᐅᒡ ᐙᔥ ᐋᐅᒄ ᑳ ᒌ ᑎᒡ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ᐊᓂᑎᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᒌᓴᔅ ᒌᐦ ᑎᑯᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ ᑭᔮᐦ ᒌᐦ ᑎᑯᓐ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐋᐱᑎᐦᒡ ᒌᐲᑭᒥᑯᐦᑳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐄᔑ ᒌᔑᑳᔨᒡ, ᐋ ᐃᔮᔅᑭᐐᐦᑳᑭᓂᐎᔨᒡ ᒥᔮᔥᑳᒑᐤ ᒥᑯᔖᐎᓂᔨᐤ, ᑭᔮᐦ ᒫᒃ ᐋ ᐹᔓᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᐊᓂᑖᐦ ᒌ ᐊᔥᑖᐙᒡ ᒌᓴᔅᐦ ᐐᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ᐊᓐ ᑳ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ ᐐᐱᒡ ᒫᒃ ᒦᓐ ᐋᐦ ᐋᑎ ᐙᐱᐦᒡ, ᐋᔥᒄ ᐋ ᐊᐅᑳᔨᒡ ᐊᓂᑖᐦ ᒌᐲᑭᒥᑰᐦᑳᓂᐦᒡ ᒌ ᐄᑐᐦᑖᐤ ᒣᕇ ᒫᒃᑖᓖᓐ ᑳ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐊᓯᓃᐦ ᐋ ᒌ ᐄᒑᐦᑎᐦᐄᒫᑭᓂᐎᔨᑯᐱᓈᓂᐦᐄ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ᐋᒄ ᒑᔅᒋᐱᐦᑖᑦ ᑳ ᓂᑎᐙᐱᒫᑦ ᓵᐃᒥᓐ ᐲᑎᕐ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌᓴᔅᐦ ᑳ ᓵᒋᐦᐋᔨᒡ ᐋᒄ ᐋᑖᑦ, “ᒌ ᐅᑎᓂᒸᐦᑖᐙᑯᐱᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐐᔮᔨᐤ ᓂᒧᐃ ᒫᒃ ᓂᒋᔅᒑᔨᐦᑎᒸᓐ ᑖᓂᑖᐦ ᑳ ᓂᐦᐋᐅᔅᑖᐙᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ᐋᒄ ᐲᑎᕐ ᑳ ᐎᔨᐐᑦ ᐄᔥᐱᐦ ᑳ ᐄᔨᔨᒡ ᐅᔮᔨᐤ ᐋ ᐐᒑᐅᑯᑦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ᙮ ᐊᓂᑖᐦ ᒌᐲᑭᒥᑰᐦᑳᓂᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ᑖᐱᔥᑯᓐ ᒌ ᒋᐦᒋᐱᐦᑖᐅᒡ ᒥᒄ ᒫᒃ ᒌ ᓂᑭᑎᑰ ᐲᑎᕐ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᐐᔨ ᓃᔥᑎᒻ ᑳ ᐹᐱᐦᑖᔨᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐱᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓐ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒌ ᓂᐙᑳᐳ ᐊᓂᑖᐦ ᐋ ᐲᐦᑎᓯᐙᔮᐱᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ᙮ ᒥᒄ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᒌ ᐙᐱᑎᒻ ᐋ ᐊᔥᑖᔨᒡ ᐊᓂᑖᐦ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐲᐦᒑᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ᒑᒃ ᑳ ᐹᐱᐦᑖᑦ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᒄ ᑳ ᐲᐦᒑᑦ ᐐᔨ ᐊᓂᑖᐦ᙮ ᒌ ᐙᐱᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᐊᓂᑎᐦ ᐋ ᐊᔥᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒋᔨᐤ ᐱᒋᐎᔮᓈᒋᓂᔨᐤ ᑳᐦ ᐋᐱᑎᓃᔨᒡ ᒌᓴᔅ ᑳ ᐎᔅᒀᔮᒋᓂᑭᓂᐎᔨᒡ ᐅᔥᑎᒀᓐ ᑎᐹᓐ ᐊᓂᑖᐦ ᒌ ᐊᔥᑖᔨᐤ ᐋ ᒌ ᓂᐦᐋᐙᒋᓂᑭᓄᐎᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ᐋᒄ ᐱᔮᒋᐲᐦᒑᑦ ᐊᓐ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐊᓐ ᓃᔥᑎᒻ ᑳ ᐹᐱᐦᑖᑦ, ᐐᔨ ᑭᔮᐦ ᒌ ᐙᐱᐦᑎᒻ ᐋᒄ ᑏᔮᑆᐦᑖᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ᐅᔮᔨᐤ ᒫᒃ ᒫᒀᒡ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᒦᓐ ᒑ ᐎᓂᔥᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ᐋᒄ ᑳᐤ ᑳ ᒌᐙᒡ ᐐᒋᐙᐦᒡ ᐅᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ᒥᒄ ᒣᕇ ᐐᔨ ᒌ ᓃᐴ ᐊᓂᑎᐦ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᐋ ᒫᑑᑦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᒫᑑᑦ ᒌ ᓂᐙᑳᐳ ᐋ ᐲᐦᑎᓯᐙᔮᐱᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ᐋᑯᑖᐦ ᑳ ᐙᐱᒫᑦ ᓃᔓ ᐋᓐᒋᓐ ᐋ ᐙᐹᔅᐱᓱᔨᒡ ᐋ ᐊᐱᔨᒡ ᐊᓂᑎᐦ ᒌᓴᔅᐦ ᑳ ᓂᐦᐄᑳᑭᓂᐎᔨᒡ ᐐᔮᔨᐤ᙮ ᐹᔨᒄ ᐊᓂᑖᐦ ᐋ ᒌ ᐄᔑ ᐅᔥᑎᒀᓃᔨᒡ ᒌ ᐊᐱᐤ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᐊᓂᑖᐦ ᐄᑖᐦᒑ ᐋ ᒌ ᐄᔑ ᐅᓯᑎᔨᒡ ᐋᑯᑖᐦ ᑳ ᐊᐱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ᐋᒄ ᐋᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᐃᔅᒀᐤ, ᒑᒀᓐ ᐙᐦᒋ ᒫᑑᔨᓐ?” ᐋᒄ ᒣᕇ ᐋᑖᑦ, “ᒌ ᐅᑎᓈᐅᒡ ᓂᑎᐹᔨᐦᒋᒑᓰᒻ ᓂᒧᐃ ᒫᒃ ᓂᒋᔅᒑᔨᒫᐅᒡ ᑖᓂᑖᐦ ᑳ ᐱᒋᔅᑎᓈᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᒌ ᒌᐙᑳᐳ ᐋᒄ ᐎᔮᐱᒫᑦ ᒌᓴᔅ ᐋ ᓃᐴᐎᔨᒡ, ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᓂᐙᐤ ᐋᐦᐋᐎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᐃᔅᒀᐤ, ᒑᒀᓐ ᐙᐦᒋ ᒫᑑᔨᓐ? ᐊᐙᓐ ᑳ ᓂᓂᑐᐙᐱᒥᑦ?” ᑳ ᑭᓂᐙᐱᒫᑦ ᒣᕇ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐋᐦ ᐋᐙᔨᒫᑦ, ᐋᒄ ᐋᑖᑦ, “ᐹᒋ ᐐᐦᑎᒨ ᒫᐦ ᐊᔨᐦᒡ ᑳ ᐄᑐᐦᑖᐙᐆᑖ ᐊᓂᔮᔨᐤ ᐅᔨᐤ, ᑖᓂᑖᐦ ᑳ ᐊᐦᐄᑦ ᐋᒄ ᒫᒃ ᒑ ᒌ ᓂᑎᐙᐱᐦᑎᒨᒡ ᒥᒄ ᒑ ᒌ ᐅᑎᓂᒧᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᒣᕇ᙮” ᒌ ᒀᔅᒋᑳᐳ ᒣᕇ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᑦ, ᐋᒄ ᐋᑖᑦ, “ᕋᑆᓈᐃ᙮” ᐆ ᒫᒃ ᕋᑆᓈᐃ ᑳ ᐄᓈᓅᒡ ᐋᐦ ᐄᑣᔥᑎᒧᐙᑖᑭᓂᐎᒡ ᒋᔅᑯᑎᒫᒑᓯᐤ ᐄᓈᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᐊᑳᐐ ᐹᒋ ᒥᒫᐦᒋᑯᓐ ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᑖᐐᒫᐤ ᐋᐦ ᑖᑦ ᓅᐦᒌ ᐄᑐᐦᑖᓐ᙮ ᒥᒄ ᒫᒃ ᓂᑎᐙᐱᒥᒡ ᓃᒋᔖᓂᒡ ᒑ ᐐᐦᑎᒨᐎᑣᐤ ᒑ ᓂᑎᐙᐱᒥᒡ ᓅᐦᑖᐐ ᑭᔮᐦ ᒌᔨᐙᐤ ᑰᐦᑖᐐᐙᐤ, ᓂᒋᔖᒥᓂᑑᒻ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᒋᔖᒥᓂᑑᒧᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ᐋᒄ ᒣᕇ ᒫᒃᑖᓖᓐ ᑳ ᒋᔅᑐᐦᑖᑦ ᐋ ᓈᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤᐦ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᐋᑖᑦ, “ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᒌᐙᐱᒫᐤ᙮” ᒌ ᐐᐦᑎᒧᐙᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᑦ ᒑ ᐄᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᐊᓐ ᓃᔥᑎᒻ ᐋ ᒌᔑᑳᔨᒡ ᐊᓐ ᑖᐅᔅᑖᒡ ᒌ ᓂᔥᑐᐎᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ᒌ ᐋᑖᐱᔥᒋᓃᓲᐎᒡ ᒫᒀᒡ ᐊᓂᔮᔨᐤ ᐋ ᓂᔅᑑᐐᒡ ᐙᔥ ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐅᒋᒫᐤᐦ᙮ ᔑᔥᒋᑯᒡ ᒫᒃ ᒌ ᐅᐦᒋ ᓃᐴᐎᔨᐤ ᒌᓴᔅᐦ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᐋᒄ ᐋᑎᑯᒡ, “ᒋᔮᒫᔨᐦᑎᒧᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐙᒋᔮᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐋᒄ ᑳ ᐙᐱᐦᑏᔮᑦ ᐅᑎᐦᒌ ᑭᔮᐦ ᐅᐦᐱᒫᔨᐤ᙮ ᓄᐎᒡ ᒫᒃ ᒌ ᓯᒋᔮᔨᐦᑎᒧᒡ ᐋ ᒌ ᐙᐱᒫᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ᐋᒄ ᒌᓴᔅᐦ ᒦᓐ ᐋᑖᑦ, “ᒋᔮᒫᔨᐦᑎᒧᒄ᙮ ᒧᔮᒻ ᐅᐦᑖᐐᒫᐤ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑦ ᑭᔮᐦ ᓃᔨ ᒋᑎᐄᑎᔑᐦᐅᑎᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ᐋᒄ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐄᔑ ᔮᔮᐦᐋᑦ ᑳᐦ ᐄᑖᑦ, “ᐅᑎᓈᐦᒄ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ᐙᐹᔨᐦᑎᒧᐙᒀ ᐊᐙᓐ ᐅᒥᒋᐦᑣᐎᓐ ᒋᑭ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ, ᐋᑳ ᐙᐹᔨᐦᑎᒧᐙᒀ ᐅᒫᒋᐦᑣᐎᓐ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᒧᐙᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ᐊᓐ ᒫᒃ ᐹᔨᒄ ᐊᓂᒌ ᑳ ᓃᓲᓵᐴᒡ, ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑣᒥᔅᐦ ᐋ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᐹᔨᒄ ᐊᓐ ᑳ ᓃᔑᒡ, ᓂᒧᐃ ᐅᐦᒋ ᑖᐤ ᐐᔨ ᒌᓴᔅ ᑳ ᓅᑯᔑᔅᑖᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐋᑖᒡ, “ᓂᒋᐙᐱᒫᓈᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ᐋᒄ ᐋᑎᑯᒡ, “ᐹᑎᔥ ᒌ ᑖᐦᒋᓂᒧᒑ ᐅᑎᐦᒌ ᐊᓂᑎᐦ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᑭᔮᐦ ᐹᑎᔥ ᒌ ᑖᐦᒋᓂᑳ ᐊᓂᑎᐦ ᐅᔅᐱᑳᐦᒡ, ᐃᔮᒄ ᒑ ᑖᑆᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ᐹᔨᒄ ᑎᐎᔥᑖᐤ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᒦᓐ ᑳ ᓂᔥᑐᐐᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ᑣᒥᔅ ᒫᒃ ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᒌ ᐋᑖᐱᔥᒋᓈᑭᓂᐎᒡ ᒋᔥᑐᐦᑭᓂᐦᒡ ᐊᔮᐱᒡ ᒫᒃ ᒌᓴᔅ ᒌ ᐹᒋ ᐲᐦᒑᐤ ᑳ ᐹᒋ ᐎᑎᔅᑭᐎᑳᐳᔥᑎᐙᑦ ᐋᒄ ᐋᑖᑦ, “ᒋᔮᒫᔨᐦᑎᒧᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ᐋᒄ ᐋᑖᑦ ᑣᒥᔅ, “ᑖᐦᒋᓐ ᓂᑎᐦᒌ ᑭᔮᐦ ᐅᑖᐦ ᐅᐦᐱᒫᔨᐤ ᐹᒋ ᑖᐦᒋᓐ, ᐋᑯᓐ ᐋᒄ ᐃᔥᐱᔥ ᐋᓍᐦᑎᐦ, ᑖᑆᐦᑎᐦ ᐋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ᐋᒄ ᑣᒥᔅ ᐋᑎᑯᑦ, “ᓂᑎᐹᔨᐦᒋᒑᒻ ᑭᔮᐦ ᓂᒋᔖᒥᓂᑑᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ᒌᓴᔅ ᐋᑖᑦ, “ᒌ ᑖᑆᐦᑖᓐ ᐋ ᒥᒄ ᐋ ᐹᒋ ᐙᐱᒦᓐ? ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᐋᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᐙᐱᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ᒌᓴᔅ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᒥᐦᒑᑐ ᒌ ᐙᐱᒥᑰ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ ᐋᐦ ᑐᑎᐦᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᒥᓯᓂᐦᐄᑭᓂᐎᔨᒡ ᐅᑎᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ᐋᔪᐎᑯᓐᐦ ᐅᐦᐄ ᒫᒃ ᑳ ᒥᓯᓂᐦᐄᑭᓂᐎᒡ ᒑ ᒌ ᑖᑆᐦᑎᒫᒄ ᒌᓴᔅ ᐋᐦᐋᐎᑦ ᙭ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ ᐋᒄ ᒫᒃ ᑖᑆᔮᔨᒫᒀ ᒑ ᐃᔮᔮᒄ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ᐹᑎᒫ ᒫᒃ ᐋᒄ ᒦᓐ ᒌᓴᔅ ᑳ ᓅᑯᓰᔥᑎᐙᑦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᓵᑭᐦᐄᑭᓂᔨᐤ ᑖᐃᐲᕆᔮᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒫᐅᑖ ᒫᒃ ᑳ ᐄᔑ ᓅᑯᓰᔥᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ᒫᒨ ᒌᐦ ᑖᐅᒡ ᐅᒌ ᒥᓯᐙ, ᓵᐃᒥᓐ ᐲᑎᕐ, ᑣᒥᔅ, ᐊᓐ ᑳ ᓃᔑᒡ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᓈᕦᓃᔨᓪ ᐊᓐ ᑫᓈ ᑳ ᐅᐦᒌᑦ ᐊᓂᑖᐦ ᑳᓕᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓃᔓ ᓭᐱᑏ ᐅᑯᓯᔅᐦ ᑭᔮᐦ ᓃᔓ ᑯᑎᑭᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑖᑦ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, “ᓂᑭ ᓂᑑᓅᑎᒫᓵᓐ᙮” ᐋᒄ ᐋᑖᒡ, “ᒋᑭ ᐐᒑᐅᑎᓈᓐ᙮” ᑳ ᐴᓯᒡ᙮ ᐃᔅᑭᓐ ᑎᐱᔅᑳᐤ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐱᑎᐦᐅᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ᐄᔥᐱᐦ ᒫᒃ ᐐᐱᒡ ᐋᑎ ᐹᑖᐱᓃᔨᒡ, ᒌᓴᔅ ᒌ ᓃᐴ ᐊᓂᑖᐦ ᔑᔓᒡ, ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐃᔮᐎᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ᐋᒄ ᐋᑎᑯᒡ, “ᐋᐙᔑᔒᑐᒄ, ᐋᔥᒄ ᐋ ᓂᒧᐃ ᒋᐱᑎᐦᐅᔮᓈᐙᐤ?” ᐋᒄ ᐋᑖᒡ, “ᓂᒫ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ᐋᒄ ᐋᑎᑯᒡ, “ᒋᑭ ᐱᑎᐦᐅᔮᓈᐙᐤ ᐊᓂᑖᐦ ᒌ ᓂᐦᐄᐎᓂᐙᐦᒡ ᐄᑖᐦᒑ ᐄᔑ ᐱᑭᔥᑎᐙᐦᐙᒀ ᐊᓐ ᒋᑎᐦᐄᐲᐙᐤ᙮” ᑭᔨᑆ ᑳ ᐱᑭᔥᑎᐙᐦᐙᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᐄᐲᐙᐤ᙮ ᓂᒧᐃ ᐅᐦᒋ ᔑᐎᐱᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᐄᐲᐙᐤᐦ ᐄᔥᐱᐦ ᐙᐦᒋᐱᑖᒡ ᐋ ᐃᔥᐱᔥ ᒥᐦᒑᑎᔨᒡ ᐅᓂᒫᓯᒧᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ᐊᓐ ᒫᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᒌᓴᔅ ᑳ ᓵᒋᐦᐋᑦ ᐋᑖᑦ ᓵᐃᒥᓐ ᐲᑎᕐ, “ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓐ᙮” ᐄᔥᐱᐦ ᒫᒃ ᓵᐃᒥᓐ ᐲᑎᕐ ᐱᔮᐦᑎᐦᒃ ᐋᐦ ᐋᐎᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐳᔥᒋᔥᑭᒻ ᐅᑎᑯᐦᑉ ᐊᓂᔮᔨᐤ ᑳ ᒥᓂᐦᒃ ᒑ ᐋᐱᑎᓰᑦ, ᐋᒄ ᑳ ᐱᑭᔥᑎᐙᒀᔥᑯᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᑳ ᐹᒋ ᓈᑎᑳᒫᐦᐊᐦᒡ, ᐋ ᐅᑖᐹᒡ ᐅᑎᐦᐄᐲᐙᐤ ᐋ ᓵᑭᔅᒋᓈᔨᒡ ᓂᒫᔅ᙮ ᓂᒧᐃ ᒫᒃ ᓈᔥᒡ ᐙᐦᔨᐤ ᐅᐦᒋ ᑖᐅᒡ, ᐎᔮᔥ ᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᐦᑐᑎᐹᔅᑯᓂᑭᓐ ᒌ ᐃᔥᐱᔑᓈᑯᓰᒑᓂᒌ ᐊᓂᑎᐦ ᐅᐦᒋ ᔑᔓᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑭᐹᒡ ᒌ ᐙᐱᐦᑎᒧᒡ ᐃᔥᑯᑖᔨᐤ ᓂᒫᔅ ᐋ ᑎᑭᔣᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᐋᐃᐦᑯᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ᐋᒄ ᒌᓴᔅᐦ ᐋᑎᑯᒡ, “ᐹᔓᐙᐦᑯᒡ ᐊᓂᒌ ᐱᔅᒡ ᓂᒫᓯᒡ ᑳ ᐱᑎᐦᐅᔮᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᒦᓐ ᑳ ᐴᓯᑦ ᑳ ᐊᒀᓯᐱᑖᑦ ᐊᓂᔮᔨᐤ ᐃᐦᐄᐲᐦ᙮ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒦᓐ ᓂᔮᔫᒥᑎᓂᐤ ᓂᔥᑐᔖᑉ ᒌ ᑎᔑᔨᐤ ᐋ ᒥᒥᓰᑎᔅᑏᔨᒡ ᓂᒫᔅ᙮ ᐋᑦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐃᔥᐱᔥ ᓵᑭᔅᒋᓈᔨᒡ ᓂᒫᔅ ᓂᒧᐃ ᐊᔮᐱᒡ ᐅᐦᒋ ᐲᑰᐲᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐅᑎᐦᐄᐲᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐋᔥᑎᒧᒄ, ᐹᒋ ᒦᒋᓱᒄ᙮” ᓂᒧᐃ ᒫᒃ ᐙᒋᐹᔮᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐅᐦᒋ ᐐᐦ ᐄᑖᐅᒡ, “ᐊᐙᓐ ᒌᔨ?” ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐅᒡ ᐋᐦ ᐋᐎᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ᒌᓴᔅ ᒫᒃ ᒌ ᓈᑖᐤ, ᑳ ᐅᑎᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐋᒄ ᑳ ᒫᑎᓂᒧᐙᑦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᒫᔅ ᐋᔪᐎᒄ ᑳᐦ ᑐᑎᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᓂᔥᑣᐤ ᑳ ᓅᑯᓰᔥᑎᐙᑦ ᒌᓴᔅ ᐊᓂᔮᔨᐤᐦ ᐅᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ ᑳ ᐃᔥᐱᔥ ᐎᓂᔥᑳᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒦᒋᓱᒡ, ᒌᓴᔅ ᐋᑖᑦ ᓵᐃᒥᓐ ᐲᑎᕐ, “ᓵᐃᒥᓐ ᐲᑎᕐ, ᒌᔨ ᑳ ᐅᑯᓰᑐᑖᔅᒃ ᒞᓐ, ᐊᐅᔅᑖ ᐋ ᓃᔨ ᒋᓵᒋᐦᐄᓐ ᐃᔥᐱᔥ ᐐᔨᐦ ᐅᒌ?” ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᐋᑎᑯᑦ, “ᐋᐦᐋ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᒋᔅᒑᔨᐦᑖᓐ ᐋ ᓵᒋᐦᐄᑖᓐ᙮” ᒌᓴᔅ ᐋᒄ ᐋᑖᑦ, “ᐊᔑᒥᒡ ᓂᒫᓂᔥᒑᓂᔑᔑᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ᐋᒄ ᒦᓐ ᐋᑖᑦ ᐋᔪᐎᒄ ᐋᒄ ᓃᔣᐤ ᐋᑖᑦ, “ᓵᐃᒥᓐ ᐲᑎᕐ, ᒞᓐ ᑳ ᐅᑯᓰᑐᑖᔅᒃ, ᒋᓵᒋᐦᐄᓐ ᐋ?” ᐋᒄ ᐋᑎᑯᑦ, “ᐋᐦᐋ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᒋᔅᒑᔨᐦᑖᓐ ᐋ ᓵᒋᐦᐄᑖᓐ᙮” ᐋᒄ ᒌᓴᔅᐦ ᐋᑖᑦ, “ᓈᓈᑭᒋᐦᐄᒡ ᓂᒫᓂᔥᒑᓂᔑᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ᐋᒄ ᐋᑖᑦ ᐋᔪᐎᒄ ᐋᒄ ᓂᔥᑣᐤ ᐋᑖᑦ, “ᓵᐃᒥᓐ ᐲᑎᕐ, ᒞᓐ ᑳ ᐅᑯᓰᑐᑖᔅᒃ, ᒌ ᓵᒋᐦᐄᓐ ᐋ?” ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᓈᔥᒡ ᑳ ᒥᒑᔨᐦᑎᐦᒃ ᐙᔥ ᐋᔪᐎᒄ ᓂᔥᑣᐤ ᑳ ᑯᒀᒋᒥᑯᑦ ᒌᓴᔅᐦ ᐋᐦ ᐄᑎᑯᑦ, “ᒋᓵᒋᐦᐄᓐ ᐋ?” ᐋᒄ ᐋᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒥᓯᐙ ᒑᒀᓐ ᒋᒋᔅᒑᔨᐦᑖᓐ, ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐋ ᓵᒋᐦᐄᑖᓐ᙮” ᒌᓴᔅᐦ ᐋᑖᑦ, “ᐊᔑᒥᒡ ᓂᒫᓂᔥᒑᓂᔑᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ᑯᐃᔅᒄ ᒋᐐᐦᑎᒫᑎᓐ, ᐋᔥᒄ ᐋ ᒌ ᐅᔅᒋᓃᒋᔨᓐ ᒥᒄ ᑖᓐ ᐙᐦ ᐊᔨᐦᑏᓐ ᒋᒌᐦ ᑎᓐ ᑭᔮᐦ ᒥᒄ ᑖᓂᑖᐦ ᐙᐦ ᐄᑐᐦᑖᔨᓐ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᔨᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒋᔖᐄᔨᔨᓈ, ᔑᐎᓂᔅᒑᔨᓈ ᒫᒃ ᒋᑭ ᒫᐦᑯᐱᑖᑭᓂᐤ ᒋᑎᐦᒌ ᐋᒄ ᒑ ᐄᑐᐦᑎᐦᐄᑭᐎᔨᓐ ᐊᓂᑖᐦ ᐋᐦᐋᑳ ᐐᐦ ᐄᑐᐦᑖᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ᐅᔮᔨᐤ ᒫᒃ ᒌᓴᔅ ᐙᐦᒌ ᐃᔨᑦ ᒌ ᓂᑎᐙᔨᒫᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒥᔨᒡ ᑖᓂᑖᐦ ᒑ ᐄᔑ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᑖᔨᑖᑯᐦᐋᔨᒡ ᒋᔖᒥᓂᑑ᙮ ᐋᒄ ᒌᓴᔅ ᐋᑖᑦ, “ᐹᒋ ᓅᔔᔥᑯᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ᓵᐃᒥᓐ ᐲᑎᕐ ᒌ ᒀᔅᒋᑳᐴ ᑳ ᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐᐦ, ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᑳ ᓵᒋᐦᐋᔨᒡ᙮ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔅᐱᒋᓯᒧᔨᒡ ᒌᓴᔅ ᐋᐦ ᑖᑦ ᒫᒀᒡ ᑳᐅᑖᑯᓰᐤ ᒦᒋᓱᒡ ᑭᔮᐦ ᑳ ᐄᔑ ᑯᒀᒋᒫᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐊᐙᓐ ᒑ ᒫᒥᔑᒥᔅᒃ?” ");
INSERT INTO crl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᓵᐃᒥᓐ ᐲᑎᕐ ᐅᔮᔨᐤ ᓈᐹᐤ ᐋᒄ ᐋᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐆ ᒫᒃ ᐐᐦ ᓈᐹᐤ?” ");
INSERT INTO crl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ᒌᓴᔅᐦ ᐋᑎᑯᑦ, “ᓂᑎᐙᔨᒥᑳ ᒑ ᒌ ᐱᒫᑎᓰᑦ ᐹᑎᔥ ᒦᓐ ᑎᑯᔑᓅᒑ, ᑖᓐ ᒫᒃ ᒑ ᒌᐦ ᑎᔨᓐ ᒌᔨ? ᐹᒋ ᓅᔔᔥᑯᐦ ᒌᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ᐋᒄ ᑳ ᒥᔑᐦᑖᐱᔨᐦᒡ ᑎᐹᒋᒧᐎᓐ ᐊᓂᑎᐦ ᑖᐙᔨᔥ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᐐᒋᔖᓂᒫᐅᒡ ᐋᐦ ᑖᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᒑ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᑦ ᐆ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐃᔨᑖᑯᐱᓐ ᒌᓴᔅ ᐋᑳ ᒑ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ, “ᓈᑐᐙᔨᒫᐅᒑ ᐋᔥᒄ ᒑ ᒌ ᐱᒫᑎᓰᑦ ᑎᑯᔑᓅᒑ, ᑖᓐ ᒫᒃ ᒑ ᒌᐦ ᑎᔨᓐ ᒌᔨ?” ");
INSERT INTO crl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ᐋᐅᒄ ᐆ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᑳ ᑎᐹᑐᑎᐦᒃ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ, ᑭᔮᐦ ᑳ ᒥᓯᓂᐦᐋᐦᒃ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ᙮ ᒌ ᒋᔅᒑᔨᒫᓂᐤ ᒫᒃ ᐋ ᑖᑆᒥᑭᓃᔨᒡ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ᒥᐦᒑᓂᔨᐤ ᒫᒃ ᑯᑎᒃ ᒑᒀᔨᐤ ᒌᓴᔅ ᐋ ᒌᐦ ᑐᑎᐦᒃ᙮ ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᐙᐐᐦᑖᑭᓂᐎᔨᒡ ᒑᒀᔨᐤ ᑳᐦ ᑐᑎᐦᒃ, ᒀᔂᓐ ᐋᑐᒡ ᑖᐱᔥᑖᔨᐤᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐅᔑᐦᑖᑭᓂᐎᒡ ᒥᓯᓂᐦᐄᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ᒌᔨ ᑎᔻᕕᓚᔅ ᒋᒥᓯᓂᐦᐋᒫᑎᓐ᙮ ᓃᔥᑎᒻ ᒥᓯᓂᐦᐄᑭᓐ ᑳ ᒥᓯᓂᐦᐋᒫᒑᔮᓐ ᐋᑯᑖᐦ ᑳ ᐐᐦᑎᒫᓐ ᒥᓯᐙ ᑖᓐ ᑳᐦ ᑎᒃ ᒌᓴᔅ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᒫᐅᒡ ᐅᔅᑭᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ᐋᒸᔮ ᐅᐦᒋ ᐹᒋ ᐅᑎᓈᑭᓅᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ, ᐋᑯᑎᐦ ᑳ ᒋᔅᑯᑎᒧᐙᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᐋᑆᔅᑎᓪᐦ ᐋ ᐐᐦᑎᒧᐙᑦ ᑖᓐ ᒑ ᐃᔨᐦᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ᐄᔥᐱᐦ ᑳ ᒌᔥ ᓂᓈᐦᑳᑖᔨᒧᑦ ᒌᓴᔅ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᒥᐦᒑᑣᐤ ᒌ ᓅᑯᓰᔥᑎᐙᐤ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᐃᔥᐱᔥ᙮ ᒌ ᐙᐱᐦᑎᔮᐤ ᒥᐦᒑᑐᔨᒡ ᐋ ᐐᐦ ᒑᔥᑎᓈᑖᔨᐦᑎᒥᐦᐋᑦ ᑖᑆᐦ ᒦᓐ ᑳᐤ ᐋ ᐱᒫᑎᓰᑦ, ᑭᔮᐦ ᒌ ᐋᔨᒨᑎᒧᐙᐤ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᓂᔥᑐᐐᒡ, ᒌᓴᔅ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ, “ᐊᑳᐐ ᓂᑭᑎᒧᒄ ᒉᕉᓯᓕᒻ᙮ ᐊᔑᓂᐙᑖᒄ ᐊᓂᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ ᓅᐦᑖᐐ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᒥᔨᑖᒄ, ᐋᐅᒄ ᐆ ᔖᔥ ᑳ ᐹᒋ ᐋᔨᒨᑎᒫᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ᐙᔥ ᒞᓐ ᑳ ᓰᑭᐦᐋᐦᑖᒑᑦ ᓂᐲᔨᐤ ᒌ ᐋᐱᒋᐦᑖᐤ᙮ ᔖᔥ ᒫᒃ ᐐᐱᒡ ᒋᑭ ᓰᑭᐦᐋᐦᑖᑯᓈᐙᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ᐋᒄ ᒫᒃ ᒦᓐ ᐹᔨᒀᐤ ᐋ ᓂᔥᑐᐐᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᒌᓴᔅᐦ, “ᑎᐹᔨᐦᒋᒑᓯᐤ, ᔖᔥ ᐋ ᐅᑎᐦᒋᐱᔨᐤ ᒑ ᒥᔨᑣᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ ᐐᔨᐙᐤ ᒦᓐ ᒑ ᒌ ᐱᒥᐱᔨᐦᑣᓱᒡ ᒥᓯᐙ ᒑᒀᔨᐤ?” ");
INSERT INTO crl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ᒌᓴᔅ ᒫᒃ ᒌᐦ ᐄᑖᐤ, “ᓂᒧᐃ ᒌᔨᐙᐤ ᒋᐱᐦ ᐅᐦᒋ ᓈᓂᑐ ᑭᒑᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᒑ ᐄᔅᐱᔨᔨᒡ ᐊᓂᑖᐦ ᐄᔑ ᓃᔥᑖᒥᐦᒡ᙮ ᐊᓂᔮᔨᐤ ᐋ ᑎᐹᔨᐦᒋᒑᑦ ᓅᐦᑖᐐ ᔖᔥ ᒌ ᐎᔮᔨᐦᑎᒻ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᐅᑎᐦᒋᐱᔨᔨᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ᒥᒄ ᒫᒄ ᒋᑭ ᓵᑭᔅᒋᓈᔥᑳᑯᓈᐙᐤ ᓲᐦᑳᑎᓰᐎᓐ, ᐄᔥᐱᐦ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒌ ᐅᑎᐦᑎᑖᒀ᙮ ᐋᒄ ᒫᒃ ᒑ ᐱᐹᒫᒋᒥᔮᒄ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒥᓯᐙ ᒎᑏᔮ ᐊᔅᒌᐦᒡ, ᓵᒫᕆᔮᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᒡ ᐊᔅᒌ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ᐄᔥᐱᐦ ᒌᓴᔅ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪ, ᒫᒀᒡ ᐋ ᑭᓂᐙᐱᒥᑯᑦ ᐃᔥᐱᒥᐦᒡ ᒌ ᐄᔑ ᐅᐦᐱᐱᔨᐤ᙮ ᑭᔥᑭᐎᓂᔥᒄ ᑳᐦ ᐋᑯᐦᐅᑯᑦ ᐋᒄ ᓂᒧᐃ ᐅᐦᒌ ᐙᐱᒥᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ᒫᒀᒡ ᒫᒃ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᐋᐦ ᐄᑖᐱᒡ, ᔑᔥᒋᑯᒡ ᒌ ᐅᐦᒋ ᐐᒋᑳᐳᔥᑖᑯᒡ ᓃᔓ ᓈᐹᐤ ᐋ ᐙᐹᔅᐱᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ᐋᒄ ᑳᐦ ᐄᑎᑯᒡ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ ᑳᓕᓖᐦᒡ ᑳ ᐅᐦᒋᔮᒄ, ᒑᒀᓐ ᐙᐦᒋ ᓃᐴᐎᔮᒄ ᐅᑎᐦ, ᐃᔥᐱᒥᐦᒡ ᐋᐦ ᐄᑖᐱᔮᒄ? ᐆ ᒌᓴᔅ ᑖᓐ ᑳ ᐄᔑ ᐹᒋ ᐅᑎᓈᑭᓅᑦ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ, ᑳ ᐄᔑ ᐙᐱᒫᒄ ᐋᐦ ᐄᑐᐦᑖᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᐋᔪᐎᒄ ᒧᔮᒻ ᒑ ᐃᓯᓈᑯᓯᑦ ᒦᓐ ᑎᑯᔑᐦᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ᐋᒄ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑳ ᒋᔅᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᐊᓕᕕᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᑳᐤ ᑳ ᒌᐙᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐎᔮᔥ ᐋᐱᐦᑑ ᐊᔅᒌᔨᐤ ᑎᐱᐦᐄᑭᓐ ᒌ ᐄᔅᐱᓯᓈᑯᓃᔨᒑ ᐅᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᐲᐦᒑᐅᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᒑ ᑖᒡ᙮ ᒌᐦ ᑎᑯᓂᔨᐤ ᐋ ᐱᔅᒋᓵᔨᒡ ᐃᔥᐱᒥᐦᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐋᑯᑖᐦ ᑳ ᐄᔑ ᑯᔥᐹᐦᑎᐐᒡ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᑳᐦ ᑖᒡ, ᓵᐃᒥᓐ ᐲᑎᕐ, ᒞᓐ, ᒉᒥᔅ, ᐋᓐᑎᕉ, ᕕᓕᑉ, ᑣᒥᔅ, ᐹᕐᐧᕧᓚᒥᔪ, ᒫᕠᔫ, ᒉᒥᔅ ᐊᓪᕕᔮᔅ ᐅᑯᓯᔅᐦ, ᓵᐃᒥᓐ ᓈᔥᒡ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᑭᔮᐦ ᒍᑖᔅ, ᒉᒥᔅ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ᒥᓯᐙ ᒫᒃ ᒌ ᓂᐦᐋᔨᐦᑎᒧᒡ ᒨᔥ ᒑ ᒌ ᐹᔨᑯᒥᓈᐦᐄᑎᒡ ᐋ ᒫᒨᐊᔨᒥᐦᐋᒡ᙮ ᐋᑯᑖᐦ ᑳ ᒌᐦ ᑖᒡ ᑭᔮᐦ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᑭᔮᐦ ᒣᕇ ᒌᓴᔅ ᐅᑳᐐᐦ ᑭᔮᐦ ᒫᒃ ᒌᓴᔅ ᐐᒋᔖᓐᐦ ᑳ ᓈᐹᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᓂᔥᑐᐐᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ, ᓵᐃᒥᓐ ᐲᑎᕐ ᒌ ᐱᓯᑰ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᓂᔥᑐᐎᔨᒡ᙮ ᐎᔮᔥ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒦᓐ ᓃᔥᑎᓂᐤ ᒌ ᑎᔒᒑᓂᒋ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ᓃᒋᔖᓂᑎᒄ, ᐊᓐ ᑳ ᐄᔑ ᓃᑳᓐ ᐐᐦᑖᑯᐦᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᔮᔨᑖ ᒌ ᓂᑎᐙᔨᐦᑖᑯᓐ ᒥᓯᐙ ᒑ ᒌ ᐄᔅᐱᔨᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᑳ ᐄᔑ ᒥᔮᑦ ᐊᓂᔮ ᑌᕕᑦ ᒑ ᒌ ᓃᑳᓐ ᐐᐦᑎᒥᔨᒡ ᑖᓐ ᒑ ᑎᔨᑯᐱᓈᓂᐦᐄ ᒍᑕᔅᐦ᙮ ᐋᐅᒄ ᐆ ᒍᑖᔅ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᓂᑐᐱᔨᐤᐦ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐅᑎᓈᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ᐋᐅᒄ ᐙᔥ ᑭᔮᐦ ᒍᑖᔅ ᐹᔨᒄ ᒌᔮᓂᐤ ᐋᐦᑎᓰᔨᐦᒄ ᑭᔮᐦ ᐐᔨ ᒌ ᒥᔮᑭᓅᐤ ᐋᑆᔅᑎᓪ ᒑ ᒌ ᐄᑖᐱᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","“ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᐄᔑ ᒥᒋᐦᑐᑎᐦᒃ ᒍᑖᔅ ᒌ ᑎᐱᐦᐋᒧᐙᑭᓂᐤ ᔓᐎᔮᓐ᙮ ᐋᒄ ᑳ ᐅᑎᓂᒑᑦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ᙮ ᐋᑯᑖᐦ ᐅᑎᐦ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᒥᑐᓐ ᒌ ᑯᐃᐦᑯᑎᑎᓵᔑᓐ ᐋ ᐱᐦᒋᔑᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ᒥᓯᐙ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒌ ᒋᔅᒑᔨᐦᑖᑭᓂᐎᔨᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᑦ ᒍᑖᔅ, ᐋᒄ ᒥᐦᒄ ᐊᔅᒌ ᑳᐦ ᐋᑎ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᑳ ᒥᔅᑭᐙᑭᓅᑦ᙮ ᐐᔨᐙᐤ ᒫᒃ ᐋ ᐄᔑ ᐊᔨᒥᒡ ᐋᑫᓪᑖᒫ ᒌ ᐃᔑᓂᐦᑳᑎᒧᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","“ᐙᔥ ᐊᒀᑎᔅᑖᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮ ᑌᕕᑦ ᐅᓂᑭᒧᐎᓂᐦᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᑖᓂᐎᔨᐤ ᐊᓂᑎᐦ ᑳ ᒌᐦ ᑖᑦ, ᐊᑳᐐ ᐊᐙᓐ ᒋᑭ ᐅᐦᒋ ᐐᒋᐤ ᐊᓂᑎᐦ᙮ ᐋᔨᐤᐦ ᒫᒃ ᐊᒀᒋᔥᑖᒡ, ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒋᑭ ᒦᔅᑯᑎᔥᑳᑰ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᐄᑖᐱᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","ᑳᐦ ᐋᑎ ᐃᔨᑦ ᒦᓐ ᓵᐃᒥᓐ ᐲᑎᕐ, “ᐋᒄ ᒫᒃ ᒋᐱᐦ ᐎᔮᔨᒫᓂᐤ ᐹᔨᒄ ᐊᐙᓐ ᐅᑎᐦ ᐋ ᐅᐦᒋᑦ ᐋᐦᑖᔨᐦᒄ ᒑ ᐐᒋᐦᐄᑎᐦᒄ ᐋ ᐙᐦ ᐐᐦᑎᒨᑯᐦᒡ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᒥᑭᓃᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᐋ ᒌ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᐎᔮᔨᒫᐦᒄ ᔖᔥ ᐊᓂᑖᐦ ᐋ ᒌ ᐅᐦᒋ ᐹᒋ ᐐᒑᐅᑎᐦᒄ ᐅᔅᑭᒡ ᑳ ᒋᐦᒋ ᐱᐹᐐᒑᐅᑎᐦᒄ ᒌᓴᔅᐦ, ");
INSERT INTO crl_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ᐄᔥᐱᐦ ᑳ ᓰᑭᐦᐋᐦᑖᑯᑦ ᒌᓴᔅ ᐊᓂᔮ ᒞᓐ, ᐲᐦᐃᒻ ᒫᒃ ᒌᓴᔅ ᑳ ᐅᑎᓈᑭᓅᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ᐋᒄ ᒫᒃ ᓃᔓ ᓈᐹᐤ ᑳ ᐐᐦᐋᒡ᙮ ᐊᓐ ᐹᔨᒄ ᓈᐹᐤ ᒍᓯᕝ ᒌ ᐃᔑᓂᐦᑳᓲ᙮ ᓂᔮᓂᑯᑐᓐᐦ ᒑᔅᑎᔅ ᑭᔮᐦ ᒫᒃ ᐹᕐᓯᐹᔅ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᒑ᙮ ᐋᒄ ᐊᓐ ᑯᑎᒃ ᓈᐹᐤ ᒫᕧᔮᔅ ᒌ ᐃᔑᓂᐦᑳᓲ᙮ ");
INSERT INTO crl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᒡ ᐋᐦ ᐃᔨᒡ, “ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒌ ᒋᔅᒑᔨᒫᐤ ᒥᓯᐙ ᐊᐙᓐ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ᙮ ᐹᒋ ᐙᐱᐦᑎᔨᓈᓐ ᑖᓐ ᐊᓐ ᐙᐙᔮᐱᒥᑦ ᐅᒌ ᓈᐹᐅᒡ ᐋ ᓃᔑᒡ ");
INSERT INTO crl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ᒑ ᒌ ᐅᑎᓂᐦᒃ ᐅᔮᔨᐤ ᐋᐱᑎᓰᐎᓂᔨᐤ ᐋᑆᔅᑎᓪ ᐋᐦ ᐄᑖᐱᑎᓰᑦ, ᐊᓂᔮᔨᐤ ᒍᑖᔅ ᑳ ᓂᑭᑎᐦᒃ ᐄᔥᐱᐦ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᐄᑐᐦᑖᑯᐱᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ᐋᒄ ᑳ ᐎᔮᔨᒫᒡ ᐊᓂᔮᔨᐤ ᐋ ᓃᔑᔨᒡ ᓈᐹᐤ ᑖᓂᔮᔨᐤ ᐊᓂᔮᔨᐤ ᒑ ᐅᑎᓈᒡᐦ, ᐋ ᐅᒋᐱᑎᒸᒡ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᑳ ᑖᐅᓂᑭᓂᐎᔨᒡ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐅᒄ ᐊᓐ ᒫᕧᔮᔅ᙮ ᐋᐅᒄ ᒫᒃ ᐊᓐ ᑳ ᐅᑎᓈᑭᓅᑦ ᐋᑆᔅᑎᓪ ᒑ ᒌ ᐄᑖᐱᑎᓰᑦ᙮ ᐋᒄ ᒫᒃ ᒦᓐ ᑳ ᓃᔔᔖᐴᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᐋ ᒌᔑᑳᒡ ᐹᓐᑏᒀᔅᑦ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒥᓯᐙ ᐹᔨᑯᓂᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ᔑᔥᒋᑯᒡ ᒌ ᐅᐦᒋ ᐹᐦᑎᒧᒡ ᒧᔮᒻ ᐋ ᒥᔅᑎᔫᑎᓃᔨᒡ ᐋᐦ ᐄᑎᐦᑖᑯᓃᔨᒡ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ ᐅᐦᒋ᙮ ᒥᓯᐙ ᐋ ᐃᔥᐱᔖᔨᒡ ᐲᐦᑎᑭᒥᐦᒡ ᒌ ᐹᐦᑖᑯᓂᔨᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᑳᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ᐋᒄ ᑳ ᐅᐦᒋ ᓅᑯᓃᔨᔨᒡ ᐃᔥᑯᑖᔥ ᒧᔮᒻ ᐋ ᒋᒥᑖᔨᔨᒡ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐋᐦ ᐋᑎ ᒫᑎᓄᐙᐱᔨᔨᒡ, ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᐊᐙᓐ ᐋᐦ ᑖᑦ ᒌᐦ ᑎᑯᓂᔨᐤ ᐹᔨᒄ ᐊᓂᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ᒥᓯᐙ ᒫᒃ ᐋ ᐃᑎᔑᒡ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑯᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᒌ ᐅᐦᒋ ᒀᔅᒡ ᐋᔨᒨᒡ ᑭᔮᐦ ᒫᒃ ᑯᑎᒃ ᐊᔨᒧᐎᓐ ᐋ ᐄᔑ ᒥᔨᑯᒡ ᐊᐦᒑᐦᒄ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ᒌᐦ ᑖᐅᒡ ᒫᒃ ᒎᐤ ᓈᐹᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᐎᒌᒡ ᓈᔥᒡ ᐋ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐊᔅᒌᐦᒡ ᐋ ᒌ ᐅᐦᒌᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᑎᐦᑖᑯᓃᔨᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᐄᔥᐱᐦᐄᑑᒡ ᐊᓂᑖᐦ᙮ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ ᒫᒃ ᐙᔥ ᒌ ᐹᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐐᔨᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐊᔨᒥᒡ ᐋ ᐄᔑ ᐊᔨᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ᓈᔥᒡ ᒫᒃ ᒌ ᒥᔅᑳᓯᑎᐙᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᐋᒄ ᐋᑖᒡ, “ᓂᒧᐃ ᐋ ᑳᓕᓖᐦᒡ ᐅᐦᒌᐅᒡ ᐅᒌ ᑳ ᐊᔨᒥᒡ? ");
INSERT INTO crl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ᑖᓂᑖᐦ ᒫᒃ ᐙᐦᒋ ᐄᔑ ᐹᐦᑑᐦᑰᐦᒡ ᒌᔮᓂᐤ ᐋ ᐄᔑ ᐋᔨᒨᐦᒄ ᑎᐱᔨᐙ ᐋ ᐄᔑ ᐊᔨᒥᒡ? ");
INSERT INTO crl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ᐊᓂᑖᐦ ᒫᒃ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐊᔅᒌ ᐋ ᐅᐦᒌᐦᒄ ᐊᓂᑖᐦ ᐹᕐᑎᔮ ᑭᔮᐦ ᒦᑎᔮ, ᐄᓚᒻ, ᒣᓵᑆᑖᐃᒥᔮ, ᒎᑏᔮ ᑭᔮᐦ ᑳᐹᑣᓯᔮ, ᑆᓐᑎᔅ, ᐋᐃᔖ, ");
INSERT INTO crl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ᕝᕆᑭᔮᐦ, ᐹᒻᕕᓕᔮ, ᐄᒋᑉᑦ, ᑭᔮᐦ ᓕᐱᔮ ᐹᔓᒡ ᐊᓂᑖᐦ ᓵᐃᕇᓐ ᑳᐦ ᑎᑯᐦᒡ ᐃᐦᑖᐎᓐᐦ᙮ ᑭᔮᐦ ᒫᒃ ᐱᔅᒡ ᐅᑎᐦ ᐋᐦᑎᔒᐦᒄ ᕎᒻ ᑰᐦᒌᓈᓂᐤ ᐋ ᐹᒋᒨᑎᓯᐙᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ᒋᑎᐦᑖᓈᓂᐤ ᑭᔮᐦ ᐅᑎᐦ ᑖᐱᔥᑯᓐ ᒎᐤ ᑭᔮᐦ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᐦᒃ ᐋ ᒌ ᐎᔮᔨᐦᑎᒥᐦᒄ ᒌᔮᓂᐤ ᒑ ᒌ ᑖᑆᐦᑎᒧᒄ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᐦᒡ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ᐱᔅᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒃᕇᑦ ᑭᔮᐦ ᐊᕇᐱᔮ ᑰᐦᒌᓈᓂᐤ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒥᓯᐙ ᐋᐦᑎᔒᐦᒄ ᒌ ᐹᐦᑎᐙᓅᒡ ᒌᔮᓂᐤ ᐋ ᐄᔑ ᐊᔨᒧᒄ ᐋ ᐄᔑ ᐊᔨᒥᒡ᙮ ᐙᐐᐦᑎᒧᒡ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᔥᑳᒡ ᐋᐦ ᑎᔨᒡ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ᒥᓯᐙ ᒫᒃ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᔨᒡ ᑭᔮᐦ ᒌ ᐅᐙᓈᔨᐦᑎᒥᐦᐄᑯᒡ᙮ ᒌ ᑯᒀᒋᒥᑑᒡ ᒫᒃ ᐋᐦ ᐄᑎᑐᒡ, “ᒑᒀᓐ ᐆ ᑳ ᐄᔅᐱᔨᔨᒡ, ᑖᓐ ᐋᐦ ᑎᓈᓂᐎᒡ ᐆ?” ");
INSERT INTO crl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ᑯᑎᑭᒡ ᒫᒃ ᒌ ᒫᔮᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ ᐋᐦ ᐄᑖᒡ, “ᒌᔥᒀᐹᐅᒡ ᐅᒌ ᓈᐹᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ᓵᐃᒥᓐ ᐲᑎᕐ ᒫᒃ ᒌ ᐐᒋᑳᐳᔥᑎᐙᐤ ᐊᓂᔮᔨᐤ ᐐᒡ ᑳ ᐹᔨᑯᔖᐳᔨᒡ ᐋᑆᔅᑎᓪᐦ ᐋ ᐎᑎᔅᑭᐎᑳᐳᔥᑎᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ᐋᒄ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋ ᒋᔣᐙᑦ ᐋᐦ ᐄᑖᑦ, “ᒌᔮᓂᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᐦᒃ ᑭᔮᐦ ᒥᓯᐙ ᒌᔨᐙᐤ ᐋ ᑎᔑᔮᒄ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐐᒋᔮᒄ ᔮᒀᐦ ᐹᒋ ᓂᑐᐦᑎᐎᒄ ᑖᓐ ᒑ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᒑᒀᓐ ᑳ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ᓂᒧᐃ ᒌᔥᒀᐹᐅᒡ ᐅᒌ ᓈᐹᐅᒡ ᒌᔥᒀᐹᐅᒡ ᐋᑖᔨᒫᑯᒡ᙮ ᐙᔥ ᐱᒑᐃᒃ ᐹᔨᑯᔥᑖᐤ ᐄᔅᐱᔨᐤ ᐋ ᒑᒋᔖᐹᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ᐆ ᑳ ᐄᔅᐱᔨᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒞᐃᓪ ᑳ ᐐᐦᑎᒧᑯᐱᓈ ᒑ ᐄᔅᐱᔨᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ᐄᔥᐱᐦ ᒫᐦᒋᒡ ᐋᑎ ᒌᔑᑳᒑ ᒫᐤ ᒑ ᑐᑎᒫᓐ ᒌ ᐃᔨᐤ ᒋᔖᒥᓂᑑ, ᒥᓯᐙ ᐊᐙᓐ ᓂᑭ ᓰᒋᓂᒧᐙᐤ ᓂᑎᒑᐦᒄ, ᒋᑯᓱᐙᐅᒡ ᑭᔮᐦ ᒋᑖᓂᓱᐙᐅᒡ ᒋᑭ ᒋᔅᒋᐙᐦᐄᒑᐅᒡ᙮ ᐅᔅᒋᓃᒎᒡ ᒋᑭ ᐙᐱᐦᑎᒧᒡ ᐙᐱᐦᑏᐙᐎᓐ, ᐋᒄ ᒋᔖᐄᔨᔨᐅᒡ ᓂᓈᐦᑭᐤ ᒋᑭ ᐄᔑ ᐳᐙᒨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ᑭᔮᐦ ᒫᒃ ᑖᐱᔥᑯᓐ ᓂᑖᐱᒋᐦᐋᑭᓂᒡ ᓈᐹᐆᒡ ᑭᔮᐦ ᐃᔅᒀᐆᒡ ᓂᑭ ᒥᔮᐅᒡ ᓂᑎᐦᒑᐦᒄ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᔨᒡ, ᐋᒄ ᒑ ᒋᔅᒋᐙᐦᐄᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ᓂᑭ ᐙᐱᐦᑏᐙᓐ ᒫᒥᔥᑳᒡ ᒑᒀᓂᐦᐄ ᐊᓂᑖᐦ ᒌᔑᑯᐦᒡ ᑭᔮᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᒋᑭ ᑎᑯᓐ ᒥᐦᒄ ᑭᔮᐦ ᐃᔥᑯᑖᐤ ᑭᔮᐦ ᐋ ᐊᒀᐱᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ᐲᓯᒻ ᒋᑭ ᑎᐱᔅᒋᐱᔨᐤ ᑭᔮᐦ ᑎᐱᔅᒋᐲᓯᒻ ᒋᑭ ᒥᐦᑯᓲ ᒧᔮᒻ ᒥᐦᒄ ᐋ ᐄᔑ ᒥᐦᒀᒡ ᐋᔪᐎᒄ ᒑ ᐃᓯᓈᑯᓯᑦ ᐋᒸᔮ ᑎᑯᔑᐦᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᓈᔥᑖᑆᐦ ᑭᑎ ᒋᔅᑖᔨᐦᑖᑯᓐ ᐊᓐ ᒑ ᒌᔑᑳᒡ ᑭᔮᐦ ᓄᐎᒡ ᑭᑎ ᒥᔅᑳᑖᔮᔨᐦᑎᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ᐋᒄ ᒫᒃ ᑎᐦᑐ ᐊᐙᓐ ᒑ ᓂᑑᑖᒨᐙᒀ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ, ᒋᑭ ᐱᒫᒋᐦᐋᑭᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ᑳᐦ ᐋᑎ ᐃᔨᑦ ᒦᓐ ᓵᐃᒥᓐ ᐲᑎᕐ, “ᒌᔨᐙᐤ ᐃᔅᕋᐃᓕᐦᒡ ᑳ ᐅᐦᒋᔮᒄ ᓂᑐᐦᑎᐎᒄ ᑖᓐ ᒑ ᐄᔑ ᐋᔨᒨᒥᒃ ᒌᓴᔅ ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ᙮ ᒥᑐᓐ ᒌ ᓅᑯᓂᔨᐤ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᒫᒥᔥᑳᒡ ᐃᐦᑎᒃ ᑭᔮᐦ ᐋ ᒌ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᑦ ᓂᓈᐦᑭᐤ ᒑᒀᔨᐤ ᑭᔮᐦ ᒫᒃ ᐋ ᒌ ᐙᐱᐦᑏᐙᑦ ᒋᔅᒋᓄᐙᒡ ᐙᐱᐦᑏᐙᐎᓐ᙮ ᒌᔨᐙᐤ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐆ ᐙᔥ ᐋᑯᑖᐦ ᐅᑎᐦ ᑖᐙᔨᔥ ᐋᐦᑖᐙᒄ ᑳᐦ ᑐᑎᐦᒃ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᒥᔨᑯᑦ ᑭᔅᒋᐦᐅᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ᔖᔥ ᐊᓂᑖᐦ ᒌ ᐎᔮᔨᐦᑎᒻ ᒋᔖᒥᓂᑑ ᒌᔨᐙᐤ ᐋᐦᑖᐙᒄ ᒑ ᐄᔑ ᐱᒋᔅᑎᓈᑦ ᒌᓴᔅᐦ, ᒌᔨᐙᐤ ᒫᒃ ᒋᒌ ᓂᐱᐦᐋᐙᐤ ᐋ ᒌ ᐱᒋᔅᑎᓈᑯᒡ ᓈᐹᐅᒡ ᐋ ᒥᒑᑎᓯᒡ ᒑ ᒌ ᒌᔅᑖᔅᑯᐦᐙᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᐎᓂᔥᑳᓈᐤ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᒌ ᐱᐦᑯᐦᐋᐤ ᓂᐱᐎᓐ ᐐᓯᒑᔨᐦᑎᒧᐎᓂᐦᒡ ᐅᐦᒋ ᐙᔥ ᓂᒧᐃ ᐅᐦᒌ ᒥᒋᒥᓂᑰ ᓂᐱᐎᓂᔨᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ᐊᓂᔮ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᓃᑳᓐ ᒌ ᐋᔨᒨᒫᑖᑯᐱᓐ ᒌᓴᔅᐦ ᑳᐦ ᐄᑖᑦ, ᒨᔥ ᓂᐙᐱᒫᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᐦᑎᔅᑰ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ᙮ ᐹᔓᒡ ᐋᐦ ᑖᔮᓐ ᑖᐤ ᓂᒧᐃ ᒫᒃ ᓂᑭ ᐅᐦᒋ ᒥᑯᔥᑳᑖᔨᐦᑖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᓈᔥᒡ ᒥᔻᔨᐦᑎᒫᓐ ᓂᑖᐦᐄᐦᒡ ᑭᔮᐦ ᓂᒨᒋᒑᔨᐦᑖᓐ ᐋ ᐊᔨᒥᔮᓐ᙮ ᐋᑦ ᒫᒃ ᒑ ᓂᐱᔮᓐ, ᓂᒧᐃ ᓂᑎ ᐋᔨᒫᔨᐦᑖᓐ ᐙᔥ ᓂᑎᔅᐹᔨᒧᓐ, ");
INSERT INTO crl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ᐋᑳ ᒑ ᓂᑭᑎᑦ ᓂᑎᐦᒑᐦᒄ ᐊᓂᑖᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦ ᑖᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᒋᑖᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᐐᓂᓯᒃ ᐊᓂᑖᐦ ᑳ ᓂᐦᐄᐦᑭᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ᒋᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᓐ ᐊᓐ ᒫᔅᑭᓂᐤ ᐊᑎᒨᒡ ᐊᓂᑖᐦ ᐱᒫᑎᓰᐎᓂᐦᒡ, ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᓐ ᑖᔮᓈ ᒋᑭᑐᑎᐎᓐ ᓈᔥᒡ ᒑ ᒌ ᒨᒋᒑᔨᐦᑎᒫᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ᓃᒌᐄᔨᔨᑑᒄ ᐃᔅᕋᐃᓕᒡᐦ, ᓂᒑᔥᑎᓈᐦᐅᓐ ᐊᓂᔮ ᐋᓂᔅᒑ ᒋᒧᔓᒥᓂᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ ᐐᔨ ᑭᔮᐦ ᒌ ᓂᐦᐄᐦᑯᐙᑭᓂᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᓂᐦᐄᑭᐙᑭᓅᑦ ᐋᔥᒄ ᒌ ᒋᔅᒑᔨᐦᑎᒸᓈᓂᐤ ᑖᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ᐊᓂᔮ ᒫᒃ ᒋᑎ ᐋᓂᔅᒑ ᒋᒧᔓᒥᓂᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᒌ ᒋᔅᒋᐙᐦᐄᒑᓯᐤ᙮ ᒌ ᐃᑖᑖᑯᐱᓐ ᒫᒃ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᐹᔨᒄ ᐊᓂᑎᐦ ᐋᓂᔅᒑ ᐅᑎᐙᔑᔒᒥᔨᐤᐦ ᒑ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ ᒧᔮᒻ ᐐᔨ ᑳ ᐄᔑ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ᑌᕕᑦ ᒫᒃ ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᑖᓐ ᒑ ᑎᔨᒡ ᒋᔖᒥᓂᑑ ᐊᓂᑖᐦ ᐄᔑ ᓃᑳᓂᐦᒡ, ᐋᒄ ᒫᒃ ᑳ ᓃᑳᓐ ᐋᔨᒨᑎᐦᒃ ᑳᐤ ᒑ ᐎᓂᔥᑳᔨᒡ ᙭ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᑳᐦᐄᑯᐱᓈ ᑌᕕᑦ, “ᓂᒧᐃ ᓈᐅᔥ ᐅᐦᒋ ᐱᒋᔅᑎᓈᑭᓂᐤ ᐊᓂᑖᐦ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑖᑦ, ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᐐᓂᐱᔨᔨᐤ ᐐᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ᒋᔖᒥᓂᑑ ᒌ ᐎᓂᔥᑳᓈᐤ ᐅᔮᔨᐤ ᒌᓴᔅᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᓂᒋᔅᒑᔨᐦᑖᓈᓐ ᐆ ᐙᔥ ᒥᓯᐙ ᓂᒌᐙᐱᒫᓈᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ᒌ ᐅᐙᔨᐱᐦᐋᑭᓂᐤ ᒌᓴᔅ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ ᓈᔥᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ᙮ ᐊᓂᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ ᑳ ᒥᔨᑯᑦ ᐅᐦᑖᐐᐦ ᒋᔖᒥᓂᑑ ᑳ ᐄᔨᔨᒡ ᒑᔥᑎᓈᔥ ᒑ ᒥᔨᐙᔨᒡ, ᐋᔨᐅᑯᓐ ᐋᒄ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᒌᓴᔅ ᓂᓰᒋᓂᒫᑯᓈᓐ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐅᐦᒋ ᐆ ᒑ ᒌᐦ ᑎᔮᐦᒡ, ᐊᓅᐦᒡ ᑳ ᐄᔑ ᐙᐱᒥᔮᐦᒡ ᐋᐦ ᑎᔮᐦᒡ ᑭᔮᐦ ᑳ ᐄᔑ ᐹᐦᑑᔮᐦᒡ ᐋ ᐄᔑ ᐊᔨᒥᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ᐙᔥ ᐊᓂᔮ ᑌᕕᑦ ᓂᒧᐃ ᐅᐦᒋ ᐅᐦᐱᔅᑳᐤ ᐐᔨ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ, ᐊᔮᐱᒡ ᒫᒃ ᒌᐦ ᐄᑖᐤ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᓂᑎᐹᔨᐦᒋᒑᓰᒻ, ᐅᑖᐦ ᓂᓂᐦᐄᐎᓂᐦᒡ ᐹᒋ ᐊᐱᐦ, ");
INSERT INTO crl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ᐹᑎᔥ ᒌ ᐃᔥᐱᔑᐦᐄᒀᐙ ᐊᓂᒌ ᑳ ᐅᐦᑳᑎᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","ᐋᒄ ᒦᓐ ᑳ ᐊᑎᔨᑦ ᐲᑎᕐ, “ᐋᐅᒄ ᒫᒃ ᐙᐦ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑎᑯᒡ ᒌᔨᐙᐤ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐃᔅᕋᐃᓕᐦᒡ ᒋᑭ ᒑᔥᑎᓈᐦᐅᓈᐙᐤ ᐆ ᒌᓴᔅ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒫᑦ ᒑ ᒌ ᑎᐹᔨᐦᒋᒑᓯᐎᔨᒡ ᑭᔮᐦ ᒑ ᙭ᐎᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ ᓈᔥᒡ ᒌ ᒥᓯᒫᔨᐦᑎᒧᒡ ᐋᒄ ᐋᑖᒡ ᐲᑎᕐ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐋᑆᔅᑎᓪᐦ, “ᓃᒋᔖᓂᑎᒄ, ᑖᓐ ᒫᒃ ᒑ ᒌ ᑎᔨᐦᒄ?” ");
INSERT INTO crl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᒀᔅᑳᑎᓰᒄ ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᐋ ᑎᔑᔮᒄ᙮ ᓂᑭᑎᒧᒄ ᒋᒥᒋᐦᑣᐎᓂᐙᐤ ᑭᔮᐦ ᒑ ᓰᑭᐦᐋᐦᑖᑯᐎᔮᒄ ᒌᓴᔅ ᙭ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒫᑯᔮᒄ ᒌ ᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ᒋᑭ ᒥᔨᑯᐙᐤ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒥᔨᐙᐎᓐ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ᐙᔥ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᒥᔨᐙᑦ ᒌᔨᐙᐤ ᒋᒌ ᐄᑖᔨᒥᑯᐙᐤ ᒑ ᒌ ᐃᔮᒫᒄ ᑭᔮᐦ ᒋᑎᐙᔑᔒᒥᐙᐤ ᒑ ᒌ ᐃᔮᐙᔨᒡ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐙᐦᔨᐤ ᑳᐦ ᑖᔨᒡ᙮ ᒥᓯᐙ ᐊᓂᒌ ᒑ ᑖᑆᑎᑯᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᔖᒥᓂᑑ, ᒋᑭ ᒥᔮᑭᓂᐎᒡ ᐅᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ᒌ ᐊᔨᒥᐦᐋᐤ ᐲᑎᕐ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ᓂᓈᐦᑭᐤ ᒥᐦᒑᑐᔨᒡ ᒌ ᐄᔑ ᐃᔮᒀᒥᒫᐤ, ᐋᐦ ᐄᑖᑦ, “ᐱᑯᐦᐄᓱᒄ ᐋᑳ ᒑ ᒌ ᒫᑯᐦᐄᑯᔮᒄ ᒌᔨᐙᐤ ᑖᓐ ᒑ ᐄᔑ ᒫᑯᐦᐋᑭᓂᐎᒡ ᐅᒌ ᐊᓅᐦᒡ ᑳ ᒥᒑᑎᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ᒥᐦᒑᑐ ᒫᒃ ᒌ ᐱᔑᒋᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᒡ᙮ ᐋᒄ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ᙮ ᐊᓐ ᒫᒃ ᑳᔑᑳᒡ ᐎᔮᔥ ᓂᔥᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋᔨᐙᒡ ᒌ ᐃᐦᑎᔑᐎᒡ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᐹᔨᑯᒥᓈᐃᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ᒥᓯᐙ ᒫᒃ ᐋᑯᑖᐦ ᒨᔥ ᑳᐦ ᑖᒡ ᐋ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᑭᔮᐦ ᒌ ᐱᐦᒀᓈᐅᒡ ᐋᐃᐦᑯᓈᐤ ᑭᔮᐦ ᒌ ᒫᒨ ᒥᔪ ᐐᒑᐅᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ᒥᐦᒑᑐ ᒫᒃ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ ᑭᔮᐦ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᒌᐦ ᑐᑎᒧᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ᙮ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐎᔮᐱᐦᑎᐦᒡ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᐋ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᒨᔥ ᒌ ᒫᒨᐎᔫᒡ ᑭᔮᐦ ᐅᒑᒀᓂᒧᐙᐤ ᒨᔥ ᒌ ᐊᐅᐦᐄᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ᒌ ᐊᑖᐙᐅᒡ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐋᒄ ᑳ ᒫᑎᓂᒫᑐᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᒥᓯᐙ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ᙮ ᒥᒄ ᑖᓐ ᐋ ᐄᔑ ᓅᐦᑖᐱᔨᑦ ᐊᐙᓐ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᒥᔮᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᒫᒨᐎᔫᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒌ ᒫᒨ ᒦᒋᓱᐎᒡ ᐐᒋᐙᐦᒡ, ᐋ ᒥᔻᔨᐦᑎᐦᒡ ᐅᑖᐦᐄᐙᒡ ᐋ ᒥᔨᑐᒡ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ᒨᔥ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ᙮ ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᒥᔻᔨᒥᑯᒡ᙮ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᐋᑎ ᒥᐦᒑᑎᔨᐤ ᐊᐙᔨᐤᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᐱᒫᒋᐦᐋᑦ ᑭᔮᐦ ᐋ ᐐᒑᐅᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ᐹᔨᒀᐤ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᓂᔥᑐ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᐋ ᒌ ᐃᔥᒀᐱᐦᑖᒌᔒᑳᔨᒡ, ᐊᓂᑎᐦ ᐋ ᐅᑎᐦᒋᐱᔨᔨᒡ ᑳ ᒌ ᐊᔨᒥᐦᐋᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ᓈᔥᒡ ᒌ ᒥᓯᒋᔥᑑ ᐊᓐ ᒋᔥᑐᐦᑭᓐ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐊᓐ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᑳ ᒥᔻᔑᒡ ᐃᔥᒀᐦᑖᒻ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ, ᐋᑯᑖᐦ ᑳ ᐊᐱᑦ ᓈᐹᐤ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᓂᐦᑖᐅᐦᑖᑦ᙮ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᐋ ᒌ ᐄᑐᐦᑎᐦᐋᑭᓅᑦ ᐊᓂᑖᐦ, ᒑ ᒌ ᓂᑐᑎᒧᐙᑦ ᐊᐙᔨᐤᐦ ᔓᐎᔮᓐ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᐦ ᐄᑐᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᓈᐹᐤ ᐎᔮᐱᒫᑦ ᐊᓂᔮ ᐲᑎᕐᐦ ᑭᔮᐦ ᒞᓐ ᒑ ᐋᑎ ᐲᐦᒑᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒌ ᓂᑎᐙᔨᐦᑎᒧᐙᐤ ᔓᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ᑯᐃᔅᒄ ᒫᒃ ᒌ ᑭᓂᐙᐱᒫᐆᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᑭᓂᐙᐱᒥᓈᓐ ᒫᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ᐋᒄ ᑳ ᑭᓂᐙᐱᒥᑯᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, ᐋ ᐱᑯᓵᔨᒥᑯᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᒥᔮᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓈᔥᑎᔨᒡ ᓂᑎᔮᐙᐤ ᔓᐎᔮᓐ ᒑ ᒌ ᒥᔨᑖᓐ, ᒥᒄ ᒫᒃ ᒋᑭ ᒌ ᒥᔨᑖᓐ ᑯᑎᒡ ᒑᒀᓐ᙮ ᒌᓴᔅ ᙭ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ, ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ, ᐱᓯᑰᐦ ᒑ ᐱᒧᐦᑖᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ᐋᒄ ᐲᑎᕐ ᑳ ᐅᑎᓂᒸᑦ ᐊᓂᔮᔨᐤ ᐅᓂᐦᐄᐎᓂᑎᐦᒋᔨᐤ ᑳ ᐐᒋᐦᐋᑦ ᐋ ᐱᓯᑯᔨᒡ᙮ ᑏᐙᐦᒡ ᒫᒃ ᐊᓐ ᓈᐹᐤ, ᐅᓯᑦ ᑭᔮᐦ ᐅᐦᑯᓐ ᒌ ᐅᐦᒋ ᓵᐲᒥᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ᒌ ᐱᓯᑯᔑᐲᐦᑖᐤ ᒫᒃ, ᑳ ᓃᐴᐎᑦ, ᑳᐦ ᐋᑎ ᐱᐹᒧᐦᑖᑦ᙮ ᑳ ᐐᒑᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐᐦ ᑭᔮᐦ ᒞᓐᐦ ᐋ ᐲᐦᒑᔨᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋ ᐱᒧᐦᑖᑦ, ᐋ ᒀᔥᒀᔥᑯᐦᑎᒃ, ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ᒥᓯᐙ ᒫᒃ ᐊᐙᔨᐤᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᒌ ᐙᐱᒥᑰ ᐋ ᐱᒧᐦᑖᑦ ᑭᔮᐦ ᐋ ᒫᒥᐦᒋᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ᒌ ᓂᓯᑑᓄᐙᐅᒡ ᒫᒃ ᐋᐎᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᑳ ᒌ ᐊᐱᔨᒡ ᐋ ᐱᑯᔑᐦᑖᔨᒡ ᐊᓂᑖᐦ ᑳ ᒥᔻᔒᔨᒡ ᐃᔥᒀᐦᑖᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᑯᔥᑯᒀᔨᑎᒧᒡ ᑭᔮᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᐋᑳ ᐙᐦᒋ ᓂᐦᑖᐅᐦᑖᑦ ᒌ ᒥᒫᐦᒋᑯᓈᐤ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐᐦ ᑭᔮᐦ ᒞᓐᐦ, ᐋᒄ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᑳ ᐄᔥᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐋ ᓃᐴᐎᔨᒡ ᐊᓂᑖᐦ ᔂᓚᒥᓐ ᐅᐲᐦᑎᐎᔥᒀᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒥᓯᐙ ᓈᔥᒡ ᒌ ᑯᔥᒀᐳᒨᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᒌᐦ ᐄᑖᐤ, “ᒌᔨᐙᐤ ᐃᔅᕋᐃᓕᐦᒡ ᑳ ᐅᐦᒋᔮᒄ, ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᑯᔥᒀᐳᒧᔮᒄ ᐆ, ᑭᔮᐦ ᒑᒀᓐ ᐙᐦᒋ ᓈᔥᒡ ᒥᔅᑳᔑᓂᐎᔮᐦᒡ? ᒋᑎᐄᑖᔨᐦᑎᓈᐙᐤ ᐋ ᓃᔮᓐ ᑎᐱᔨᐙ ᓂᒥᔅᑭᐎᓰᐎᓈᐦᒡ ᑭᔮᐦ ᒫᒃ ᓂᑎᔨᒥᐦᐋᐙᑎᓰᐎᓂᓈᐦᒡ ᐙᐦᒋ ᐱᒧᐦᑖᑦ ᐆ ᓈᐹᐤ? ");
INSERT INTO crl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐋᐱᑎᔒᔥᑑᐙᒡ ᐊᓂᔮᐦᑳ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓵᒃ ᑭᔮᐦ ᒉᑭᑉ ᑭᔮᐦ ᐅᑖᐦᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ, ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐤ ᐊᓂᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒌᓴᔅᐦ᙮ ᒌᔨᐙᐤ ᒫᒃ ᒋᒌ ᑐᑎᐙᐙᐤ ᒑ ᒌ ᐱᒋᔅᑎᓈᑭᓅᑦ ᐊᓂᑖᐦ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ᙮ ᐋ ᒌ ᐋᑎᐙᔨᒫᒄ ᐅᐦᑎᔅᑰ ᐹᔨᓕᑦ ᐋᐦ ᑖᔨᒡ, ᐋᑎᐄᔅᐱ ᐹᔨᓕᑦ ᑳ ᐐᐦ ᐱᒋᔅᑎᓈᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ᐊᔮᐱᒡ ᒌᔨᐙᐤ ᒋᒌ ᐋᑎᐙᔨᒫᐙᐤ ᐊᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᑭᔮᐦ ᑳ ᑯᐃᔅᑯᑖᑎᓰᑦ ᑭᔮᐦ ᐋ ᒌ ᐃᔮᒄ ᑳ ᓂᐱᐦᐄᐙᑦ ᓈᐹᐤ ᐊᐅᔅᑖ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ᑭᔮᐦ ᒋᒌ ᑐᑎᐙᐙᐤ ᒌᓴᔅ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᑦ ᐊᓐ ᑳ ᒥᔮᑦ ᐊᐙᔨᐤᐦ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᐎᓂᔥᑳᓈᐤ ᒌᓴᔅᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᒋᐐᐦᑎᒫᑎᓈᓐ ᐋ ᑖᑆᒥᑭᐦᒡ, ᐙᔥ ᓂᒌᐙᐱᒥᓈᓐ ᒦᓐ ᑳᐤ ᐋ ᐱᒫᑎᓰᑦ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ᐊᓂᔮᔨᐤ ᒌᓴᔅ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᒦᓂᐙᑎᓰᑦ ᒑ ᒌ ᐱᒨᐦᑖᑦ ᐆ ᓈᐹᐤ᙮ ᒋᒌ ᒋᔅᒑᔨᒫᐙᐤ ᑭᔮᐦ ᒋᒌ ᐙᐱᒫᐙᐤ ᑖᓐ ᑳ ᐃᓯᓈᑯᓯᑦ᙮ ᒋᒌ ᐙᐱᒫᐙᐤ ᒫᒃ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦᑖᐙᒄ ᑳ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᐊᓂᔮᔨᐤ ᐋ ᑖᑆᔮᔨᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ᐋᒄ ᒫᒃ ᓃᒋᔖᓂᑎᒄ, ᓂᒋᔅᒑᔨᐦᑖᓐ ᒌᔨᐙᐤ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑳᑖᑯᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᒄ ᑖᓐ ᓂᐦᐋᐤ ᐋᐃᐦᑎᔮᒄ ᐊᓂᔮᔨᐤ ᑳᐦ ᑐᑎᐙᒄ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ᒋᔖᒥᓂᑑ ᒌ ᒥᔮᐤ ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒑ ᒌ ᓃᑳᓐ ᐐᐦᑎᒥᔨᒡ ᒑ ᐙᐐᓯᒑᔨᐦᑎᒥᔨᒡ ᙭ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᑎᐱᐱᔨᐦᑖᐤ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ᒀᔅᑳᑎᓰᒄ, ᒥᐦᒋᔨᐙᔮᔨᐦᑎᒧᒄ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒫᒄ᙮ ᓈᑖᐦᒄ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᑖᒄ ᒋᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ᐋᒄ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᑐᑖᑖᒄ ᒦᓐ ᒑ ᒌ ᒋᔓᒥᐦᒋᐦᐅᔮᒄ ᒋᑎᐦᒑᐦᑯᐙᐦᒡ᙮ ᑭᔮᐦ ᑭᑎ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᒌᓴᔅ ᙭, ᐊᓂᔮᔨᐤ ᔖᔥ ᑳ ᐅᐙᔮᐱᒫᑦ ᒑ ᐄᑎᔑᐦᐊᒫᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᒋᐱᐦ ᑖᐤ ᐹᑎᔥ ᐅᑎᐦᒋᐱᔨᒑ ᒥᓯᐙ ᒑᒀᔨᐤ ᐅᔅᒋᐦᑖᑭᓂᐎᔨᒑ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᑐᑎᐙᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓲᐤ ᒑ ᒌ ᓃᑳᓐ ᐐᐦᑎᐦᒥᒡ ᒑ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ᐙᔥ ᐊᓂᔮ ᒧᓱᔅ ᒌ ᐃᔨᐤ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒋᒋᔖᒥᓂᑑᒥᓂᐤ ᒌ ᐅᐙᔮᐱᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᓃᑳᓂᐦᒡ ᒑ ᒋᔅᒋᐙᐦᐄᒑᔨᒡ, ᒧᔮᒻ ᓃᔨ ᐋ ᐄᔑ ᐋᐱᒋᐦᐄᑦ, ᐋ ᒋᔅᒋᐙᐦᐄᒑᔮᓐ᙮ ᐊᓂᑎᐦ ᒌᔨᐙᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔮᒄ, ᐋᑯᑖᐦ ᒑ ᐅᐦᒌᔨᒡ᙮ ᓂᑑᐦᑎᐙᐙᒄ ᑭᔮᐦ ᓂᓂᐦᐄᐦᑐᐙᐙᒄ ᑖᓐ ᒑ ᐄᑎᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ᐊᓐ ᒫᒃ ᐊᐙᓐ ᐋᑳ ᒑ ᓂᑑᐦᑎᐙᒀ ᐅᔮᔨᐤ ᒑ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ, ᒋᑭ ᐄᒑᓈᑭᓂᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᒋᔖᒥᓂᑑ ᐅᑏᔨᔨᒥᔨᐤ ᐋᐦ ᑖᔨᒡ, ᐋᒄ ᒫᒃ ᒑ ᓂᔑᐎᓈᒋᐦᐋᑭᓅᑦ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐐᐦᑎᐦᒃ ᐲᑎᕐ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ ᐊᓂᔮ ᒧᓱᔅ᙮ ᐋᒄ ᑳᐦ ᐋᑎ ᐃᔨᑦ ᒦᓐ ᐲᑎᕐ, ");
INSERT INTO crl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“ᓵᒥᔪᓪ ᑭᔮᐦ ᐊᓂᒌ ᒥᓯᐙ ᑯᑎᑭᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐹᑎᒫ ᒦᓐ ᑳᐦ ᑖᒡ ᓃᑳᓐ ᒌ ᐐᐦᑎᒧᒡ ᐅᔮᔨᐤ ᐊᓅᐦᒡ ᑳᔑᑳᔨᒡᐦ ᐋᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ᐊᓂᔮᔨᐤ ᒋᔅᒌᐙᐦᐄᒑᐎᓂᔨᐤ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᔅᑯᒧᐎᓂᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᔨᑯᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᐦᑳ ᒋᑖᓂᔅᑰᓰᒥᐙᐅᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᑎᔅᑎᓯᓈᓱᓈᐙᐤ ᐊᓂᑎᐦ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ ᒋᑎᐙᔑᔒᒥᒡ ᓂᑭ ᐅᐦᒋ ᐅᐦᑎᓈᐤ ᐹᔨᒄ ᐊᐙᓐ ᐊᓂᑎᐦ ᐅᐦᒋ ᒑ ᒌ ᐅᐦᒋ ᒥᔪᑐᑖᐦᒡ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ᒌ ᐅᐙᔮᐱᒫᐤ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ ᒌᔨᐙᐤ ᒫᐅᒡ ᓃᔥᑎᒻ ᐋ ᒌ ᐄᑎᔑᐦᐊᒫᑖᒄ᙮ ᒋᑭ ᒥᔪᑐᑖᑯᐙᐤ ᐋᐦ ᑐᑖᑖᒄ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᒑ ᒌ ᓂᑭᑎᒫᒄ ᒋᒥᒑᑎᓰᐎᓂᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᐋ ᐊᔨᒥᐦᐋᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᒌ ᐹᒋ ᓈᑎᑯᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒧᐙᐤᐦ ᐊᓂᒌ ᓂᑐᐱᔨᐎᒡ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓵᑎᔫᓰᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ᒌ ᒌᓯᐙᓯᔨᐤ ᐙᔥ ᐋ ᒋᔅᑯᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᐄᑖᒡ ᑳᐤ ᐋ ᒌ ᐎᓂᔥᑳᔨᒡ ᒌᓴᔅᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᑭᔮᐦ ᐋᐦ ᐄᑖᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᒑ ᐎᓂᔥᑳᔨᒡ ᐊᐙᔨᐤᐦ ᐋᑎ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒧᔮᒻ ᒌᓴᔅᐦ ᑳᑎᔨᒡ ᒦᓐ ᐋ ᒌ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ᔖᔥ ᒫᒃ ᒌ ᐅᑖᑯᔑᔨᐤ ᑳ ᐅᑎᓈᑭᓂᐎᒡ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ᙮ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐱᑎᒫ ᑳ ᑭᓄᐙᔨᒫᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᑖᐱᔅᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ᐊᔮᐱᒡ ᒫᒃ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᑖᑆᐦᑎᒸᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ᐎᔮᔥ ᓂᔮᔻᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᓈᐹᐅᒡ ᒌ ᑎᔑᒑᓂᒋ ᐋ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ᐎᔮᐱᓃᔨᒡ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓃᑳᓂᔒᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔖᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᓂᔥᑐᐎᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ᑳ ᓂᒋᔥᑭᐙᒡ ᐊᓂᔮᔨᐤ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᓈᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᑭᔮᐦ ᑳᔮᕙᔅ, ᒞᓐ, ᐋᓕᒃᓵᓐᑎᕐ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐅᐙᐦᑯᒫᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ᒌ ᐹᔓᒫᑭᓂᐎᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᒑ ᒌ ᐅᐦᑎᔅᑯᑳᐳᔥᑖᑯᒡ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᑖᓂᑖᐦ ᐙᐦᒋ ᐃᔨᐦᑐᑎᒫᒄ ᐆ? ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᐃᔮᔮᒄ ᓲᐦᑳᑎᓰᐎᓐ ᒑ ᒌ ᑎᔮᒄ ᐆ ᑭᔮᐦ ᐊᐙᓐ ᑳᐦ ᐄᑎᔓᒥᑖᒄ ᐆ ᒑ ᒌ ᑎᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ᐲᑎᕐ ᒫᒃ ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᒌ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐋᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᑳ ᓃᑳᓂᔥᑭᐙᑯᒡ ᐄᔨᔨᐅᒡ, ᑭᔮᐦ ᑳ ᒋᔖᐄᔨᔨᐎᔮᒄ, ");
INSERT INTO crl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ᒌ ᐹᒋ ᑯᒀᒋᒥᓈᓐ ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᒑ ᒌ ᐐᐦᑎᒫᐦᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᔪᑐᑎᒧᐙᑭᓅᑦ ᐆ ᓈᐹᐤ ᑭᔮᐦ ᒑ ᒌ ᐐᐦᑎᒫᐦᒡ ᑖᓂᑖᐦ ᐙᐦᒋ ᒦᓂᐙᑎᓰᑦ ᐆ ᓈᐹᐤ ᐋ ᒌ ᒫᔅᒋᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ᒥᓯᐙ ᒋᐱᐦ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᒥᓯᐙ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᒋᐱᐦ ᒋᔅᒑᔨᐦᑎᒧᒡ ᒌᓴᔅ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐋ ᒌ ᒦᓂᐙᒋᐦᐄᑯᑦ ᐆ ᓈᐹᐤ᙮ ᐋᐅᒄ ᐆ ᒌᓴᔅ ᙭ ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ, ᐊᓐ ᑳ ᒌᔅᑖᔅᑯᐦᐙᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᒦᓐ ᑳᐤ ᑳ ᐙᓂᔥᑳᓈᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ᐋᐅᒄ ᐆ ᒌᓴᔅ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ᐊᓂᒌ ᑳ ᐙᔅᑳᐦᐄᑭᓂᐦᒑᒡ ᒌ ᐋᑎᐙᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᒫᐅᒡ ᒋᐦᒋᐙ ᒑᔅᑖᐱᑎᓰᔨᒡ ᐊᓅᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ᒥᒄ ᒌᓴᔅ ᐋᐦ ᑖᑦ ᐅᐦᒋᐱᔨᐤ ᐱᒫᒋᐦᐄᐙᐎᓐ᙮ ᓂᒧᐃ ᐅᐦᒋ ᒥᔮᐤ ᒋᔖᒥᓂᑑ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐱᒫᒋᐦᐄᐙᔨᒡ, ᒥᒄ ᒌᓴᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ᐊᓂᒌ ᒫᒃ ᑳ ᓂᔥᑐᐐᒡ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒸᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᓲᐦᒋᑖᐦᐋᔨᒡ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᐋ ᒋᔅᒑᔨᒫᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᑯᑎᒧᐙᑭᓂᐎᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᒌᓴᔅᐦ ᐋ ᒌ ᐅᐐᒑᐙᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐎᔮᔥ ᐅᐦᒌ ᐄᑖᐅᒡ ᒑ ᒌ ᓂᔥᒀᐅᔑᐦᐋᒡ, ᐙᔥ ᒌ ᐙᐱᒫᐅᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐋ ᐐᒋᑳᐳᔥᑐᐙᔨᒡ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᒑ ᒌ ᐎᔨᐐᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᒫᒨᐱᒡ, ᐋᒄ ᒥᒄ ᐐᔨᐙᐤ ᑳ ᐊᔨᒥᐦᐄᑐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᑖᓐ ᒑ ᑑᑑᑯᒡ ᐋᒄ ᐅᒌ ᓈᐹᐅᒡ? ᒥᓯᐙ ᐊᐙᓐ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒋᔅᒑᔨᐦᑎᒻ ᐋ ᒌ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ ᐊᓐ ᓈᐹᐤ ᐐᔨᐙᐤ ᐅᐦᒋ᙮ ᓂᒧᐃ ᒋᑭ ᒌ ᐄᓈᓂᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ᒋᐱᐦᒋᐦᑖᑖᐤ ᒫᒃ ᐋᑳ ᐊᑎᑎᐤ ᒑ ᒌ ᒥᔑᐦᑖᐱᔨᐦᒡ ᐊᓂᑖᐦ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓅᑦ ᒌᓴᔅ᙮ ᒋᔅᑎᐦᐋᒧᐙᑖᐎᓂᒌ ᐅᒌ ᓈᐹᐅᒡ ᐋᑳ ᒦᓐ ᓂᐦᑖ ᒑ ᒌ ᐋᔨᒨᒫᒡ ᒌᓴᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ᒦᓐ ᑳᐤ ᑳ ᓂᑐᒫᒡ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᐊᓂᑖᐦ ᐋ ᓂᔥᑐᐐᒡ, ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑖᒡ ᐋᑳ ᒥᑐᓐ ᒑ ᒌ ᐋᔨᒨᒫᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᑳ ᓂᔥᒀᐅᔑᐦᐋᒡ ᐋᐦ ᐄᑖᒡ, “ᐎᔮᔨᐦᑎᒧᒄ ᒫᐦ, ᑖᓂᔮᔨᐤ ᐊᓂᔮᔨᐤ ᐋ ᑯᐃᔅᑯᓈᑯᓃᔨᒡ ᐋᔑᓂᐦᒃ ᐐᔨ ᒋᔖᒥᓂᑑ᙮ ᒌᔨᐙᐤ ᒑ ᒌ ᐱᓯᒋᐦᐄᑖᐦᒡ ᑭᔮᐦ ᒫᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐱᓯᒋᐦᐄᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ᐙᔥ ᑖᐹ ᓂᑭ ᒌ ᐴᓃᓈᓐ ᐋ ᐙᐐᐦᑎᒫᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᒫᐦᒡ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᒫᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳ ᓂᔥᑐᐐᒡ, ᑳᐦ ᐄᑖᒡ ᒑ ᐎᔮᔅᑐᑎᐙᒡ ᐋᑳ ᐴᓃᔨᒑ ᐋᐦ ᐋᔨᒨᒫᔨᒡ ᒌᓴᔅᐦ᙮ ᐋᒄ ᒫᒃ ᑳ ᐱᒋᔅᑎᓈᒡ᙮ ᓂᒧᐃ ᐅᐦᒌ ᒥᔅᑭᒧᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐎᔮᔅ ᑐᑎᐙᒡ, ᐙᔥ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᑳ ᒥᔅᑳᒡ ᒦᓂᐙᒋᐦᐋᑭᓅᑦ, ᐊᐅᔅᑖ ᓈᒥᑎᓂᐤ ᒌ ᑎᐦᑐᐳᓍᔔ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐱᒋᔅᑎᓈᑭᓂᐎᒡ, ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᑳᐤ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᐅᐐᒑᐙᑭᓂᐙᐤᐦ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᒡ ᑖᓐ ᑳᐦ ᐄᑎᑯᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ᐄᔥᐱᐦ ᑳ ᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐅᐐᒑᐙᑭᓂᐙᐤᐦ ᐋᒄ ᒫᒨ ᑳ ᐊᔨᒥᐦᐋᒡ ᒋᔖᒥᓂᑑ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᒡ, “ᒫᐅᒡ ᑳ ᐄᔅᐱᔨᐦᑖᑯᓯᔨᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒌᔨ ᑳ ᐅᔑᐦᑖᔨᓐ ᒋᐦᒋᒌᔑᒄ ᑭᔮᐦ ᐊᔅᒌ ᑭᔮᐦ ᒋᐦᒋᑭᒦ, ᑭᔮᐦ ᒥᓯᐙ ᒑᒀᓐ ᐋ ᐄᔑ ᑎᑯᐦᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒌ ᐐᐦᑎᒧᐙᐤ ᐊᓂᔮ ᓂᐙᐦᑰᒫᑭᓈᓐ ᑌᕕᑦ, ᒋᑎ ᐋᐱᒋᐦᐋᑭᓐ, ᐊᓂᔮᔨᐤ ᒌᔨ ᑖᓐ ᑳ ᐐᐦ ᐃᔨᐎᑦ, ᒌ ᐃᔨᐤ ᒫᒃ, ᒑᒀᔨᐤ ᐙᐦᒋ ᒋᔑᐙᓯᒡ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ? ᒑᒀᔨᐤ ᐙᐦᒋ ᐋ ᒫᒥᑑᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᐄᔨᔨᐅᒡ ᐋᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐎᔮᔅᑖᐱᑎᓃᔨᔨᒡ? ");
INSERT INTO crl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ᐅᒋᒫᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒌ ᐃᔮᔅᑭᐎᔪᒡ ᒑ ᓂᔥᑰᔥᑐᐙᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ᐋᐅᒄ ᐊᓐ ᒫᒃ ᑖᑆᐦ ᐋᔅᐱᔨᐦᒡ ᐊᓅᐦᒡ ᐙᔥ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ, ᑭᔮᐦ ᐊᓐ ᐅᒋᒫᐤ ᑆᓐᑎᔭᔅ ᐹᔨᓕᑦ, ᑭᔮᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ, ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒌ ᓂᔥᑐᐎᐅᒡ ᐋ ᓂᔥᑰᔥᑐᐙᒡ ᒌᓴᔅᐦ, ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᒋᑎ ᐋᐱᒋᐦᐋᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ᒥᒄ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑐᑎᐦᒡ, ᒌᔨ ᔖᔥ ᐙᔥᑭᒡ ᒋᒌ ᐎᔮᔨᐦᑖᓐ ᒑ ᐄᔅᐱᔨᒡ, ᒌᔨ ᒫᒃ ᒋᒌ ᑐᑖᓐ ᒑ ᒌ ᑎᐱᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ᑎᐹᔨᐦᒋᒑᓯᐤ, ᑭᓂᐙᐱᒥᒡ ᒫᐦ, ᑖᓐ ᐋ ᐄᔑ ᓈᓂᑐ ᑯᔥᑖᒋᐦᐄᔨᒥᐦᒡ᙮ ᐐᒋᐦᐄᓈᓐ ᓃᔮᓐ ᒋᑎ ᐋᐱᒋᐦᐋᑭᓂᒡ ᒑ ᒌ ᓲᐦᒋᑳᐳᔮᐦᒡ ᐋ ᐙᐐᐦᑎᒫᐦᒡ ᒌ ᒥᔻᒋᒧᐎᓐ, ᒑ ᒌ ᓲᐦᒋᑖᐦᐋᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ᐐᒋᐦᐄᓈᓐ ᒫᒃ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᒋᐦᒡ ᑳᐦ ᐋᐦᑯᓯᒡ, ᑭᔮᐦ ᑯᑎᒃ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑎᐎᓐ ᒑ ᒌᐦ ᑐᑎᒫᐦᒡ, ᒌᓴᔅ, ᐊᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᒋᑎ ᐋᐱᒋᐦᐋᑭᓐ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᐎᒋᐦᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᒡ, ᒌ ᐋᔮᐦᒋᐱᔨᔨᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳ ᓂᔥᑐᐐᒡ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑯᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐋᒄ ᒫᒃ ᑳ ᓲᐦᒑᔨᒧᒡ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᑯᔥᑖᒋᐎᒡ ᐋ ᐙᐐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ, ᒌ ᐅᐹᔨᑯᒥᑐᓈᔨᒋᑭᓂᐎᒡ ᑭᔮᐦ ᐹᔨᑯᓂᐦᒡ ᒌ ᐄᔑ ᐎᔮᔨᐦᑎᒧᒡ ᒑᒀᔨᐤ᙮ ᑖᓐ ᑳ ᐄᔑ ᑎᐱᔨᐙᐎᓰᑦ ᐊᐙᓐ ᒑᒀᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒻ ᒥᒄ ᐐᔨ ᐋ ᑎᐱᔨᐙᐎᓰᑦ, ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒫᒨ ᒌ ᐋᐱᒋᐦᑖᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐃᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ᒌ ᒥᔥᑏᐦ ᓲᐦᒋᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᐋ ᐙᐐᐦᑎᐦᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᑳᐤ ᐋᐦᒋ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒥᔥᑏᐦ ᒌ ᒥᒥᔪᑳᑯᒡ ᒥᓯᐙ ᐋ ᐃᑎᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ᓂᒧᐃ ᒫᒃ ᐙᒋ ᐹᔨᒄ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐅᐦᒋ ᐅᐙᓂᓯᐅᒡ᙮ ᐋᔅᑭᐤ ᒫᓐ ᐊᐙᓐ ᒌ ᐊᑖᐙᒑᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ ᑭᔮᐦ ᒫᒃ ᐅᑎᐊᔅᒌ᙮ ᒌ ᐹᓯᐙᐅᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᑳ ᐃᔥᐱᔥ ᐅᐦᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ᐋᒄ ᑳ ᒥᔮᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ᙮ ᐋᒄ ᑳ ᒫᑎᓂᒧᐙᒡ ᐊᓂᔮᔨᐤ ᑎᐦᑐ ᐊᐙᔨᐤᐦ ᑳ ᐅᐙᓂᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ᐋᔪᐎᒄ ᑳᐦ ᑎᒃ ᒍᓯᕝ, ᐊᓐ ᓖᕙᔨᑦ ᐄᔨᔨᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓯᑦ, ᓵᐃᑉᕋᔅ ᒥᓂᔅᑎᑯᐦᒡ ᒌ ᐱᒫᑎᓰᒑ ᐆ ᓈᐹᐤ᙮ ᐊᓂᒌ ᒫᒃ ᐋᑆᔅᑎᓕᒡ ᐹᕐᓂᐱᔅ ᒌ ᐃᔑᓂᐦᑳᑖᐅᒡ ᐅᔮᔨᐤ ᒍᓯᕝᐦ᙮ ᐊᓐ ᒫᒃ ᐃᔑᓂᐦᑳᓱᐎᓐ ᑳ ᔒᐦᒋᒫᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒥᔥᑭᐎᑳᐳᐎᒡ ᐄᔑ ᐄᑣᔥᑎᒫᑖᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ᒍᓯᕝ ᒫᒃ ᒌ ᐊᑖᐙᒑᐤ ᐊᔅᒌᔨᐤ ᐋ ᒌ ᑎᐱᔨᐙᐎᓰᑦ, ᑳ ᐹᓯᐙᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ, ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ᒌᐦ ᑖᐤ ᒫᒃ ᓈᐹᐤ ᐋᓂᓈᔮᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᐐᐤᐦ ᒫᒃ ᓯᕙᐃᕋ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ᙮ ᒌ ᐊᑖᐙᒑᐤ ᒫᒃ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳ ᑎᐱᔨᐙᐅᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ᑖᐱᔥᑯᓐ ᒌ ᓂᔅᑯᒧᐎᒡ ᒌᒧᒡ ᒑ ᑭᓄᐙᔨᐦᑎᒫᓱᒡ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᐋᒄ ᑳ ᐄᑐᐦᑐᐙᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐃᔅᑯᓈᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐋᓂᓈᔮᔅ, ᒑᒀᓐ ᐙᐦᒋ ᐱᒋᔅᑎᓂᑦ ᒥᒋᒥᓂᑑ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᑖᐦᐄᐦᒡ, ᒑ ᒌ ᑐᑖᔅᒃ ᒑ ᒌ ᓂᑎᔨᒥᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᒌᒧᒡ ᐋ ᑭᓄᐙᔨᐦᑎᒫᓱᔨᓐ ᐱᔅᒡ ᐊᓐ ᔓᐎᔮᓐ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᐅᐦᑎᓰᓐ ᑳ ᐊᑖᐙᒑᔨᓐ ᐊᓐ ᑳ ᐄᔑ ᑎᐱᔨᐙᐎᓰᓐ? ");
INSERT INTO crl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᐊᑖᐙᒑᔨᓐ ᒋᑎᐊᔅᒌ ᒌᔨ ᒋᒌ ᑎᐱᔨᐙᐎᓰᓐ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐊᑖᐙᒑᔨᓐ ᒋᒌ ᒥᔨᑰᓐ ᒑ ᒌ ᐎᔮᔨᐦᑎᒥᓐ ᑖᓐ ᒑ ᑐᑎᐙᑦ ᐊᓐ ᔓᐎᔮᓐ᙮ ᒑᒀᓐ ᑳ ᒫᒥᑐᓈᔨᐦᑎᒥᓐ ᐙᐦᒋ ᐎᔮᔨᐦᑎᒥᓐ ᐆ ᒑ ᒌᐦ ᑐᑎᒥᓐ? ᓂᒧᐃ ᓈᐹᐤ ᒌ ᓂᑎᔨᒫᐤ, ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᓈᑎᔨᒫᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐋᓂᓈᔮᔅ ᐅᔮᔨᐤ ᐋᐦ ᐄᑖᑭᓅᑦ ᒌ ᐋᑎ ᐱᐦᒋᔑᓐ, ᑳᐦ ᐋᑎ ᐴᓂᐱᒫᑎᓰᑦ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᐹᐦᑎᐦᒡ ᒌ ᓵᒋᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ᐅᔅᒋᓃᒎᒡ ᒫᒃ ᒌ ᐹᒋ ᐲᐦᒑᐅᒡ, ᑳ ᐐᔅᒀᔮᒋᓂᒸᒡ ᐊᓂᔮᔨᐤ ᐐᔮᔨᐤ, ᑳ ᐎᔨᐐᐦᑎᐦᐋᒡ, ᑳ ᓂᑑᓂᐦᐄᐦᑯᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ᓂᔥᑣᐤ ᐋ ᒌᓂᒀᓂᐦᑖᔨᒡ ᐲᓯᒧᐦᑳᓐ ᒫᒃ ᐃᔥᐱᔥ ᐐᐤᐦ ᑳ ᐹᒋ ᐲᐦᒑᔨᒡ, ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᔨᐤ ᑖᓐ ᑳ ᐄᔅᐱᔨᑯᐱᓈ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐹᒋ ᐐᐦᑎᒨᐦ, ᐋᐤ ᐋ ᐆ ᒥᓯᐙ ᑳ ᒥᔨᑯᔮᒄ ᔓᐎᔮᓐ ᒌ ᓈᐹᒻ ᑳ ᐊᑖᐙᒑᔮᒄ ᒋᑎᔅᒌᐙᐤ?” ᑳᐦ ᐃᔨᑦ ᐊᓐ ᐃᔅᒀᐤ, “ᐋᐦᐋ, ᐋᐅᒄ ᐊᓐ ᒥᓯᐙ᙮” ");
INSERT INTO crl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᐙᐦᒋ ᑖᐱᔥᑯᓐ ᒌ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔮᒄ ᒌ ᓈᐹᒻ ᒑ ᒌ ᑯᒀᒋᐦᐄᒫᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᐦᒑᐦᒄ? ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᓂᑑᓂᐦᐄᐦᑯᐙᒡ ᒌ ᓈᐹᒻ ᔖᔥ ᒌ ᑎᑯᔑᓂᒡ, ᓈᑖᐦ ᐃᔥᒀᐦᑖᒥᐦᒡ ᓃᐴᐎᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒌᔨ ᒋᑭ ᐎᔨᐐᐦᑎᐦᐄᑯᒡ ᒧᔮᒻ ᒌ ᓈᐹᒻ ᑳ ᐄᔑ ᐎᔨᐐᐦᑎᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ᐋᒄ ᐊᓐ ᐃᔅᒀᐤ ᑳ ᐱᐦᒋᔑᐦᒃ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᔨᒡ, ᐋ ᐴᓂᐱᒫᑎᓰᑦ᙮ ᐊᓂᒌ ᒫᒃ ᐅᔅᒋᓃᒎᒡ ᒌ ᐹᒋ ᐲᐦᒑᐅᒡ, ᑳ ᐙᐱᒫᒡ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᐋᒄ ᑳ ᐎᔨᐐᐦᑎᐦᐋᒡ, ᑳ ᓂᑑᓂᐦᐄᐦᑯᐙᒡ ᐊᓂᑖᐦ ᐅᐦᐱᒫ ᐅᓈᐹᒥᔨᐤ ᑳ ᓂᐦᐄᐦᑳᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᑭᔮᐦ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐦᒡ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔅᐱᔨᔨᒡ ᓈᔥᑖᑆᐦ ᒌ ᓵᒋᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ᒥᐦᒑᑐ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᒌ ᐙᐱᐦᑏᐙᐅᒡ ᑭᔮᐦ ᒌᐦ ᑐᑎᒧᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᔨᒡ ᒑᒀᔨᐤ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᑖᔨᒡ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᒨᔥ ᑳ ᒫᒨᐊᔨᒥᐦᐋᒡ ᒌ ᓂᔥᑐᐎᔫᒡ ᒫᓐ ᐊᓂᑖᐦ ᔂᓚᒥᓐ ᐅᐲᐦᑎᐎᔥᒀᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ᑯᑎᑭᒡ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᑯᔅᑖᒍᐎᒡ ᒑ ᒌ ᐐᒑᐙᒡ, ᐋᑦ ᒫᒃ ᓈᔥᒡ ᒌ ᒋᔅᑖᔨᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ᐊᔮᐱᒡ ᒫᒃ ᐊᑎᑎᐤ ᒌ ᐋᑎ ᒥᐦᒑᑑᒡ ᐊᓂᔮᔨᐤ ᑳ ᐃᑎᔑᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᐹᔨᑯᒥᓈᐦᐄᑎᒡ, ᑖᐱᔥᑯᓐ ᓈᐹᐅᒡ ᑭᔮᐦ ᐃᔅᒀᐅᒡ ᒌ ᐋᑎ ᑖᑆᔮᔨᒫᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋ ᐄᔑ ᒫᒥᔥᑳᒡ ᐋᐦ ᑎᔨᒡ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ ᐊᔥᐱᔑᒧᓂᐦᒡ ᑭᔮᐦ ᒫᒃ ᑖᐦᑎᔮᒋᓂᑭᓂᐦᒡ ᐋ ᐱᒥᔑᓃᔨᒡ, ᐋ ᐄᑖᔨᐦᑎᐦᒡ ᐋᑦ ᒥᒄ ᑖᐦᑯᐦᐅᑯᑣᐙ ᐲᑎᕐ ᐋ ᑎᑳᔥᑖᓯᓃᔨᒡ ᐊᔮᐱᒡ ᒑ ᒌ ᒦᓂᐙᑎᓰᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ᓈᔥᒡ ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᑎᑯᔑᓂᒡ, ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ ᐊᓂᑎᐦ ᐙᔅᑳ ᒋᕉᓯᓕᒥᐦᒡ, ᐋ ᐹᔑᐙᒡ ᐊᐙᔨᐤᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ᙮ ᒥᓯᐙ ᒫᒃ ᒌ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᐐᒑᐅᑯᑦ ᐊᓂᔮᔨᐤ ᓵᑎᔫᓰᐦ ᑳ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ ᒌ ᐅᐎᐦᑖᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋᒄ ᑳ ᓈᓂᑐ ᒥᔅᑭᐦᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᐱᐦᒋᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ᒌ ᐅᑎᓈᐅᒡ ᐋᒄ ᑳ ᐲᐦᑎᑭᐦᐋᒡ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎ ᑎᐱᔅᑳᔨᒡ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑖᓐᒋᓂᒻᐦ ᒌ ᐋᐳᐦᐙᔨᐤ ᒋᔥᑐᐦᑭᓐ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᐋᒄ ᑳ ᐎᔨᐐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ, ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ᒫᒌᒄ ᓈᑖᐦ ᓂᑑᐄᑐᐦᑖᒄ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒑ ᐙᐐᐦᑎᒧᐙᑯᒡ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐅᔮᔨᐤ ᑳ ᐅᔥᑳᔨᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ᐊᓂᒌ ᒫᒃ ᐋᑆᔅᑎᓕᒡ ᒌ ᑖᑆᐦᑎᐙᐅᒡ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᑯᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐹᑖᐱᓃᔨᒡ ᒌ ᐲᐦᒑᐅᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋᒄ ᑳ ᒋᐦᒋ ᒋᔅᑯᑎᒫᒑᒡ᙮ ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᒋᐦᐄᑯᑦ ᒌ ᓂᑑᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᑳ ᒫᒨᐲᔨᒡ ᒥᓯᐙ ᒫᒨ ᒑ ᒌ ᓂᔥᑐᐎᒡ᙮ ᐋᒄ ᑳ ᐄᑎᔑᐦᐙᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᒑ ᒌ ᐹᔑᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᑖᑯᔑᐦᒡ ᐊᓂᒌ ᓂᑐᐱᔨᐎᒡ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᓂᒧᐃ ᐅᐦᒋ ᒥᔅᑭᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐊᓂᑖᐦ᙮ ᐋᒄ ᑳᐤ ᑳ ᒌᐙᒡ ᐊᓂᑖᐦ ᑳ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ, ᑳ ᓂᑑᐐᐦᑎᐦᒡ ᐋᐦ ᐃᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ᐄᔥᐱᐦ ᑳ ᑎᑯᔑᓂᔮᐦᒡ ᓈᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᒥᓯᐙ ᒥᑐᓐ ᒌ ᐋᑖᐱᔥᒋᓂᑭᓂᐤ, ᑭᔮᐦ ᐊᓂᒌ ᓂᑐᐱᔨᐎᒡ ᑳ ᓈᓈᑭᒋᐦᑖᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐎᔨᐐᑎᒥᐦᒡ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᑳᐦ ᐋᐱᐦᐆᒋᒡ ᐊᓂᒌ ᒋᔥᑐᐦᑭᓂᐦᒡ, ᓂᒧᐃ ᓅᐦᒋ ᒥᔅᑭᐙᓈᓐ ᐊᐙᓐ ᒑ ᒌ ᑖᑦ ᐊᓂᑖᐦ ᐲᐦᑎᑭᒥᐦᒡ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᑳ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ ᐊᓂᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ, ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᒌ ᐅᐙᓈᔨᐦᑎᒥᐦᐄᑯᒡ ᑖᓐ ᑳ ᐄᔅᐱᔨᔨᒡ ᐅᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ᐋᒄ ᐹᔨᒄ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑯᒡ ᐋᐦ ᐄᑎᑯᒡ, “ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᐅᑎᓈᑯᒡ, ᒫᒀᒡ ᒋᔅᑯᑎᒫᒑᐅᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ”᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ᐋᒄ ᒫᒃ ᐊᓐ ᓂᑐᐱᔨᐤᐦ ᑳ ᐅᒋᒫᐦᑭᐦᑎᐙᑦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᓂᑐᐱᔨᒻ, ᑳ ᓂᑎᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ, ᑳ ᐹᔑᐙᒡ ᒦᓐ ᐊᓂᑖᐦ ᑳ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ᙮ ᒋᔮᒻ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐙᔥ ᒌ ᑯᔥᑖᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᓂᐱᐦᐄᑯᒡ ᐋ ᐹᐱᒧᔑᓈᑎᐦᐅᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ᒌ ᐹᔓᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᑳ ᐎᑎᔅᑭᑳᐳᐦᐋᒡ ᐊᓂᑎᐦ ᑳ ᐊᐱᔥᑎᒥᔨᒡ ᑳ ᒫᒨᐲᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ᒋᒌ ᐄᑎᑎᓈᓐ ᔮᔨᑖ ᐋᑳ ᒦᓐ ᒑ ᒌ ᒋᔅᑯᑎᒫᒑᔮᒄ ᒌᓴᔅ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ᙮ ᑖᓐ ᑳᐦ ᑎᔮᒄ ᒫᒃ? ᒥᓯᐙ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒋᒌ ᒋᔅᑯᑎᒫᒑᓈᐙᐤ, ᑭᔮᐦ ᒋᐐᐦ ᑐᑎᐎᓈᓐ ᓃᔮᓐ ᒑ ᒌ ᐊᑖᒫᔨᒥᑯᔮᐦᒡ ᒌᓴᔅ ᑳ ᓂᐱᐦᐋᑭᓅᑦ,” ᒌᐦ ᐄᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ᐲᑎᕐ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᐋᑆᔅᑎᓕᒡ ᒌ ᓂᔥᒀᐅᔑᐦᐋᐅᒡ ᐋᐦ ᐄᑖᒡ, “ᐊᐅᔅᑖ ᐄᑖᔨᐦᑖᑯᓐ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᐎᒋᐦᑦ ᐃᔥᐱᔥ ᐐᔨ ᑯᑎᒃ ᐊᐙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐋᐱᑎᔒᔥᑑᐙᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ, ᐋᐅᒄ ᐆ ᑳ ᐙᓂᔥᑳᓈᑦ ᒌᓴᔅᐦ ᐊᓐ ᑳ ᓂᐱᐦᐋᒄ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐤ ᒌᓴᔅᐦ ᐅᓂᐦᐄᐎᓂᐦᒡ ᐄᑖᐦᒑ ᐋ ᒌ ᐊᐱᐦᐋᑦ, ᒑ ᒌ ᐅᒋᒫᐎᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐱᒫᒋᐦᐄᐙᔨᒡ, ᑭᔮᐦ ᒑ ᒌᐦ ᑐᑎᐙᑦ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᔨᒡ ᐅᒥᒋᐦᑣᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ᓃᔮᓐ ᒫᒃ ᓂᑎᐹᑐᑖᓈᓐ ᐙᔥ ᓂᒌᐙᐱᐦᑖᓈᓐ ᐆ ᑳ ᐄᔅᐱᔨᐦᒡ, ᐋᒄ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᒥᔮᑦ ᐊᐙᔨᐤᐦ ᑳ ᓂᓂᐦᐄᐦᑖᑯᑦ ᑭᔮᐦ ᐐᔨ ᐐᐦᑎᒫᒑᐤ ᐋ ᑖᑆᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔅᐱᔨᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ ᐊᓂᒌ ᑳ ᒫᒨᐲᔨᒡ, ᓈᔥᒡ ᒌ ᒋᔑᐙᔓᐎᒡ, ᒌ ᓂᑎᐙᔨᐦᑎᒨᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐅᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ᒌᐦ ᑖᐤ ᐹᔨᒄ ᐹᕆᓰ, ᐋ ᐊᔅᑎᐱᑦ ᐊᓂᑎᐦ ᑳ ᒫᒨᐲᔨᒡ, ᑳᒫᓕᔮᓪ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᐆ ᓈᐹᐤ ᐋ ᒋᔅᑯᑎᒫᒑᑦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒌ ᐄᑖᐱᑎᓰᐤ, ᓈᔥᒡ ᒫᒃ ᒌ ᒋᔅᑖᔨᒫᑭᓂᐤ᙮ ᒌ ᐅᐦᐱᑳᐳ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ, ᑳᐦ ᐄᑎᔓᐙᑖᑦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᒑ ᒌ ᐎᔨᐐᐦᑎᐦᐄᒥᒡ ᐱᑎᒫ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ᐋᒄ ᑳᒫᓕᔮᓪ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᓂᔥᑐᐎᔨᒡ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ ᐅᑎᐦ ᐃᔅᕋᐄᓪ ᑳᐦ ᑖᔮᒄ, ᔮᒀᒦᒄ ᑖᓐ ᐙᐦ ᑐᑎᐙᑯᒡ ᐅᒌ ᓈᐹᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ᒌ ᒋᔅᒋᓰᑐᑎᐙᐙᐤ ᐙᔥᑭᒡ ᓈᐹᐤ ᕠᔪᑎᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᑳ ᑎᑯᔑᐦᒃ ᐋᐦ ᐃᔨᑦ ᓈᔥᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ, ᐎᔮᔥ ᒫᒃ ᓈᐙᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᓈᐹᐤ ᒌ ᓅᔔᔥᑳᑰ᙮ ᒥᒄ ᒫᒃ ᒌ ᓂᐱᐦᐋᑭᓂᐤ, ᒥᓯᐙ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᓅᔔᔥᑳᑯᑦ ᐹᐦᐲᑐᔥ ᒌᐦ ᑖᔨᐤ, ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳᐦ ᑎᒃ ᓂᒧᐃ ᔖᔥ ᐋᐱᑖᔨᐦᑖᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ᐹᑎᒫ ᒫᒃ ᒍᑖᔅ, ᐊᓐ ᑳᓕᓖᒡ ᑳ ᐅᐦᒌᑦ, ᒌ ᑎᑯᔑᓐ ᒫᒀᒡ ᑳ ᐊᒋᒫᑭᓂᐎᔨᒡ ᐄᔨᔨᐤ᙮ ᑭᔮᐦ ᐐᔨ ᒫᒃ ᒌ ᒥᐦᒑᑎᔨᐤ ᐊᐙᔨᐤᐦ ᑳ ᓅᔔᔥᑳᑯᑦ, ᒥᒄ ᒫᒃ ᑭᔮᐦ ᐐᔨ ᒌ ᓂᐱᐦᐋᑭᓂᐤ ᑭᔮᐦ ᒌ ᓯᒑᔮᒧᐦᒑᓂᐎᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᓅᔔᔥᑳᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ᐆ ᒫᒃ ᒋᐐᐦ ᐐᐦᑎᒫᑎᓈᐙᐤ, ᐊᑳᐐ ᐎᔮᔥ ᑐᑎᐙᐦᑯᒡ ᐅᒌ ᓈᐹᐅᒡ, ᐙᔥ ᐅᒋᔅᑯᑎᒫᒑᐎᓂᐙᐤ ᑭᔮᐦ ᐅᑎᔨᐦᑎᐎᓂᐙᐤ ᐐᔨᐙᐤ ᐋᐦ ᑖᒡ ᐙᐦᒌᒥᑭᓃᔨᒀ ᓂᒧᐃ ᓈᐅᔥ ᒋᑭ ᐅᐦᒋ ᐋᐱᑖᔨᐦᑖᑭᓂᐎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐙᐦᒋᐱᔨᔨᒀ ᓂᒧᐃ ᒋᑭ ᒌ ᐃᔥᐱᔑᐦᐋᐙᐅᒡ ᐙᔥ ᒧᔮᒻ ᐐᔨ ᒋᔖᒥᓂᑑ ᐋ ᓂᔥᑰᔥᑐᐙᒄ ᐋᐅᒄ ᐋᓐ ᒑ ᐃᓯᓈᑯᓱᔮᒄ᙮” ᐋᔪᐎᒄ ᑳᐦ ᐃᔨᑦ ᑳᒫᓕᔮᓪ᙮ ᐊᓂᒌ ᒫᒃ ᓈᐹᐅᒡ ᑳ ᓂᔥᑐᐐᒡ ᒌ ᐱᔑᒋᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᑳᒫᓕᔮᓪ ᐅᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ᐋᒄ ᑳ ᓂᑐᒫᒡ ᐊᓂᔮ ᐋᑆᔅᑎᓪᐦ, ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒑ ᒌ ᐱᐱᓯᔅᑖᐦᐅᒫᑭᓂᐎᔨᒡ, ᑭᔮᐦ ᒌ ᐄᑎᔓᒫᐅᒡ ᐋᑳ ᒦᓐ ᓂᐦᑖ ᒑ ᒌ ᐙᐐᐦᑎᒥᔨᒡ ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ, ᐋᒄ ᑳ ᐱᒋᔅᑎᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ᐊᓂᒌ ᒫᒃ ᐋᑆᔅᑎᓕᒡ ᒌ ᒋᔅᑐᐦᑖᐅᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᑳ ᓂᔥᑐᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒫᒨᐲᔨᒡ, ᐋ ᓯᒋᔮᓯᒡ ᐋ ᒌ ᑖᐱᒑᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᓂᓈᐦᑳᑖᔨᒧᒡ ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ᐋᒄ ᒫᒃ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐊᐙᔨᐤᐦ ᐐᒋᔨᐦᒡ, ᐊᔮᐱᒡ ᒌ ᒋᔅᑯᑎᒫᒑᐅᒡ ᑭᔮᐦ ᒌ ᑭᒑᔅᒀᐅᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᒌᓴᔅ ᙭ ᐋᐦ ᐋᔨᒨᒫᒡ, ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ᐄᔥᐱᐦ ᒫᒃ ᐊᑎᑎᐤ ᐋᑎ ᒥᐦᒑᑎᒡ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ, ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒃᕇᒃ ᑳ ᐄᔑ ᐊᔨᒥᒡ ᒌ ᐎᔮᔅᑖᔨᒫᐎᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐦᐄᑉᕉ ᑳ ᐄᔑ ᐊᔨᒥᔨᒡ ᐋ ᒌ ᐃᑖᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᐦᐹᔨᑯᔨᒡ ᐃᔅᒀᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐃᔥᐱᔥ ᐊᔑᒫᑭᓂᐎᔨᒡ ᒦᒋᒥᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒌ ᒫᑎᓂᒧᐙᑭᓂᐎᔨᒡ ᐃᔅᒀᐤ ᑳ ᐹᔨᑯᔨᒡ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᓃᔓᔖᑉ ᐋᑆᔅᑎᓕᒡ ᒌ ᓂᑑᒫᐅᒡ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᑯᐃᔅᒄ ᐃᓯᓈᑯᓐ ᐋᐦᐋᑳ ᐃᔮᔥᐱᔑᔮᐦᒡ ᒑ ᒌ ᑭᒑᔅᒀᔮᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓐᐦ ᐅᐦᒋ ᐊᓐ ᐋᔨᐤᐦ ᐋ ᓈᓈᑭᒋᐦᑖᔮᐦᒡ ᒑ ᒌ ᒥᔪ ᐊᔑᒫᑭᓂᐎᒡ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᑳ ᐹᔨᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ᒌᔨᐙᐤ ᓃᒋᔖᓈᓂᒡ, ᐅᐙᔮᐱᒫᐦᑯᒡ ᓃᔣᔥᒡ ᓈᐹᐅᒡ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᐊᓂᒌ ᐋ ᒥᔻᒋᒫᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᑭᔮᐦ ᓈᔥᒡ ᐋ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᒑ ᒥᔨᒡ ᐅᔮᔨᐤ ᐋᐱᑎᓰᐎᓂᔨᐤ ᐋ ᓈᓈᑭᑐᐙᔨᒫᒡ ᑳ ᐹᐦᐹᔨᑯᔨᒡ ᐃᔅᒀᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ᐋᒄ ᒫᒃ ᓃᔮᓐ ᒑ ᐃᔥᐱᔑᔮᐦᒡ ᒑ ᒌ ᐊᔨᒥᐦᐋᔮᐦᒡ ᑭᔮᐦ ᐋ ᑭᒑᔅᒀᔮᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓐᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ᒥᓯᐙ ᒫᒃ ᒋᓂᐦᐋᔨᐦᑎᒧᒡ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ ᐊᓂᔮᔨᐤᐦ ᑳ ᐄᔨᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐋᑆᔅᑎᓪᐦ᙮ ᐋᒄ ᑳ ᐅᐙᔮᐱᒫᒡ ᔅᑏᕙᓐ᙮ ᔅᑏᕙᓐ ᒫᒃ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᓈᔥᒡ ᒌ ᓲᐦᒑᔨᐦᑖᑯᓂᔨᐤ, ᑭᔮᐦ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑰ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᑭᔮᐦ ᕕᓕᑉ ᒌ ᐅᐙᔮᐱᒫᐅᒡ ᑭᔮᐦ ᑉᕈᒀᕋᔅ, ᑭᔮᐦ ᓂᑭᓄᕐ, ᑭᔮᐦ ᑎᒸᓐ, ᑭᔮᐦ ᐹᕐᒣᓈᔅ, ᐋᒄ ᒫᒃ ᓂᑯᓚᔅ᙮ ᐆ ᓂᑯᓚᔅ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᒌ ᐅᐦᒋᔨᐤ ᐐᔨ, ᐋᑦ ᒫᒃ ᐋᐦᐋᑳ ᒎᐤ ᐅᐦᒋ ᐄᑎᔅᑳᓈᓯᑦ ᔖᔥ ᑭᔮᐦ ᐐᔨ ᒌ ᑖᑆᐦᑎᒻ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᒡ ᓈᐹᐤ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑳ ᑖᐦᒋᓈᒡ ᑭᔮᐦ ᑳ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ᒋᔖᒥᓂᑑ ᒫᒃ ᐅᑎᔨᒧᐎᓐᐦ ᒌ ᒥᔑᐦᑖᐱᔨᔨᐤ᙮ ᓈᓈᓂᒌᒻ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᑖᑆᐦᑎᒧᒡ, ᑭᔮᐦ ᒥᐦᒑᑐ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᒌ ᑖᑆᐦᑎᒧᒡ ᑭᔮᐦ ᒌ ᓂᓂᐦᐄᐦᑎᒧᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ᔅᑏᕙᓐ ᒫᒃ ᐊᓐ ᐊᐙᓐ ᑳ ᓵᒋᔅᒋᓈᔥᑳᑯᑦ ᒋᔖᒥᓂᑑ ᐅᒥᔪᑳᒑᐎᓂᔨᐤ ᑭᔮᐦ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒌ ᐄᑖᔨᐦᑖᑯᓯᐤ, ᒌᐦ ᑐᑎᒻ ᒫᒃ ᓂᓈᐦᑭᐤ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ ᑭᔮᐦ ᒫᒥᔅᑳᒡ ᐙᐱᐦᑏᐙᐎᓐᐦ ᐊᓂᑎᐦ ᐄᔨᔨᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ᒌᐦ ᑖᐅᒡ ᓈᐹᐅᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᓂᐦᐋᔨᒫᒡ ᔅᑏᕙᓐ, ᐊᓂᒌ ᐊᓂᑖᐦ ᑳ ᒌ ᐄᔑ ᓈᒋᐊᔨᒥᐦᐋᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᑳ ᐱᑯᐦᐋᑭᓂᐎᒡ ᓈᐹᐅᒡ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᒌ ᐅᐦᒌᐅᒡ ᓵᐃᕇᓐ ᑭᔮᐦ ᐋᓕᒃᓵᓐᑦᕆᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᑯᑎᑭᒡ ᒫᒃ ᐊᓂᑖᐦ ᓯᓕᓯᔮ ᑭᔮᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᒌ ᐅᐦᒌᐅᒡ᙮ ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᓈᐹᐤ ᑳ ᐎᔮᔅᑖᒥᑯᑦ ᔅᑏᕙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ᓂᒧᐃ ᒫᒃ ᐅᐦᒌ ᓂᔥᒀᐅᔑᐦᐄᑰ ᐅᔮᔨᐤ ᐄᔨᔨᐤ ᔅᑏᕙᓐ ᐙᔥ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᒥᔨᑰ ᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ ᒑ ᒌ ᑭᔅᒋᐦᐅᑦ ᐋ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ᐋᒄ ᒫᒃ ᒌᒧᒡ ᑳᐦ ᐋᐱᒋᐦᐋᒡ ᓈᐹᐤᐦ ᒑ ᒌ ᓂᓂᑎᔮᒋᒫᔨᒡ ᔅᑏᕙᓐ ᐋᐦ ᐄᔨᔨᒡ, “ᓂᒌ ᐹᐦᑎᐙᓈᓐ ᔅᑏᕙᓐ ᐋ ᐱᐹᔥᑖᒫᑦ ᒧᓱᔅ ᑭᔮᐦ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ᐅᔮᔨᐤ ᒫᒃ ᐋ ᒌ ᐃᔨᐦᑎᒡ ᒌᐦ ᑐᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔑᔨᒡ ᑭᔮᐦ ᑳ ᒋᔅᑯᑎᒫᒑᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᐄᔨᔨᐤ ᒑ ᒌ ᒋᔑᐙᐦᐄᑯᔨᒡ ᐊᓂᔮᔨᐤ ᔅᑏᕙᓐ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᓃᑳᓂᔒᒡ ᒌ ᐄᑎᔓᐙᐅᒡ ᒑ ᒌ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ ᔅᑏᕙᓐ ᑭᔮᐦ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐋ ᓂᔥᑐᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒫᒨᐲᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ᑭᔮᐦ ᒌ ᐐᔖᒫᐅᒡ ᐊᓂᔮ ᐱᔅᒡ ᓈᐹᐤ ᓂᑎᐐ ᒑ ᒌ ᐄᑖᒋᒫᔨᒡ ᔅᑏᕙᓐ ᐊᓂᑎᐦ ᐋ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ᙮ ᒌᐦ ᐄᔨᐤ ᒫᒃ, “ᐆ ᓈᐹᐤ, ᓂᒧᐃ ᒋᐱᐦᑐᐙᐤ ᐋ ᒥᒫᔮᔨᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒫᐅᒡ ᑳ ᐱᔮᐦᑭᓃᔨᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᒥᔮᔨᒡ ᐊᓂᔮᐦ ᒧᓱᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ᐙᔥ ᓂᒌ ᐹᐦᑎᐙᓈᓐ ᐋᐦ ᐃᔨᑦ, ᐅᔮᔨᐤ ᒌᓴᔅᐦ, ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᔨᒡ, ᒑ ᓂᔑᐅᓈᒋᑖᔨᒡ ᐅᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᑭᔮᐦ ᒫᒃ ᒑ ᒀᔅᒋᓂᒥᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐃᔨᐦᑎᐎᓐ ᐊᓂᔮᔨᐤ ᒧᓱᔅ ᑳᐦ ᐄᑎᔓᐙᔨᑯᐱᓈᓂᐦᐄ ᒑ ᑐᑖᑭᓂᐎᔨᒡ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᑖᒋᒧᒡ ᐊᓂᒌ ᓈᐹᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᐊᓂᑎᐦ ᑳ ᒫᒨᐱᒡ ᓈᔥᒡ ᒌ ᑭᓂᐙᐱᒫᐅᒡ ᔅᑏᕙᓐ ᐋ ᐙᐱᐦᑎᒸᒡ ᐅᑖᔥᑎᒥᐦᑯᔨᐤ ᒧᔮᒻ ᐋᓐᒋᓐ ᐅᑖᔥᑎᒥᐦᑯᔨᐤ ᐋ ᐃᓯᓈᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ᐋᒄ ᒫᒃ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑳ ᑯᒀᒋᒫᑦ ᔅᑏᕙᓐ ᐋᐦ ᐄᑖᑦ, “ᑖᑆᐅᒡ ᐋ ᑖᓐ ᐋᐦ ᐄᑖᒋᒥᔅᒡ?” ");
INSERT INTO crl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ᐋᒄ ᔅᑏᕙᓐ ᑳᐦ ᐄᑖᑦ, “ᓃᒋᔖᓂᑎᒄ ᑭᔮᐦ ᐅᐦᑖᐐᒫᑐᒄ᙮ ᐹᒋ ᓂᑐᐦᑎᐎᒄ᙮ ᒋᔖᒥᓂᑑ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᒌ ᓅᑯᓰᔥᑎᐙᐤ ᐙᔥᑭᒡ ᐊᓂᔮ ᑰᐦᑖᐐᓂᐤ ᐋᑉᕋᐦᐋᒻ ᒫᒀᒡ ᑳ ᐐᒋᔨᒡ ᐊᓂᑖᐦ ᒫᓯᑆᑖᐃᒥᔮ ᐊᔅᒌᐦᒡ, ᐋᒸᔮ ᐅᐦᒋ ᐄᔑ ᐋᐦ ᑐᒑᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐦᐁᕋᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ᒋᒌ ᐄᑎᑰ ᒫᒃ ᒋᔖᒥᓂᑑ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᓂᑭᓯᒡ ᒋᐙᐦᑯᒫᑭᓂᒡ ᑭᔮᐦ ᓂᑭᑎᐦ ᐊᓐ ᐊᔅᒌ ᐊᓂᑎᐦ ᐙᐦᒋᔨᓐ᙮ ᒑ ᐄᑐᐦᑖᔨᓐ ᐊᓂᑖᐦ ᐊᓐ ᐊᔅᒌ ᒑ ᐙᐱᐦᑎᔨᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“ᐋᒄ ᒫᒃ ᑳ ᓂᑭᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑳᓪᑎᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᐋᒄ ᑳ ᓂᑑᐐᒌᑦ ᐊᓂᑖᐦ ᐦᐁᕋᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐅᐦᑖᐐᐦ, ᒋᔖᒥᓂᑑ ᒌ ᑐᑖᑰ ᐅᑖᐦ ᒑ ᒌ ᐄᔑ ᐋᐦᑎᔅᑭᑎᐦᒃ ᐅᑖᐦ ᐆ ᐊᓅᐦᒡ ᐙᐦᒋᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔨᑰ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᒑ ᒌ ᑎᐱᔨᐙᐎᓰᑦ, ᓂᒧᐃ ᐙᐙᒡ ᐊᐱᔒᔥ ᐅᐦᒋ ᒥᔨᑰ, ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᐄᑎᑰ ᒑᔅᑎᓈᔅ ᒑ ᐋᔔ ᒥᔨᑯᑦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐋᔥᒄ ᒑ ᒌ ᑎᐱᔨᐙᐎᓰᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᓂᔅᒑ ᐅᑎᐙᔑᔒᒻ ᒑ ᑎᐱᔨᐙᐅᓰᔨᒡ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐄᑖᑭᓅᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐙᐤ ᐊᐙᔑᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ᒫᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒋᔖᒥᓂᑑ, ᒋᑎᐙᔑᔒᒥᒡ ᑭᔮᐦ ᒫᒃ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ ᒋᑭ ᐐᒋᐎᒡ ᐊᓂᑖᐦ ᒫᓂᑖᐤ ᐊᔅᒌᐦᒡ, ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᒑ ᓂᓈᐦᑳᑖᔨᒧᒡ᙮ ᒋᑭ ᑖᐱᑎᐹᔨᒫᑭᓂᐎᒡ ᐋᐦ ᐋᐱᒋᐦᐋᑭᓂᐎᒡ ᑭᔮᐦ ᒋᑭ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ ᓈᐙᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐ ᐃᔥᐱᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑳᐦ ᐋᐱᒋᐦᐄᑯᒡ ᓂᑭ ᑎᐹᔅᑯᓂᒫᔨᐤ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᐋᑉᕋᐦᐋᒻ ᐅᑖᓂᔥᑰᔒᒻ ᒑ ᓂᑭᑎᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐊᓂᑎᐦ ᑳ ᓂᓈᐦᑳᑖᔨᒧᒡ ᐋ ᑖᐱᑎᐹᔨᒫᑭᓂᐎᒡ ᐋᐦ ᐋᐱᒋᐦᐋᑭᓂᐎᒡ ᐋᒄ ᒫᒃ ᒑ ᐹᒋ ᐊᔨᒥᐦᐋᔥᑎᐎᒡ ᐅᑎᐦ ᐆ ᐊᔅᒌ ᒫᒀᒡ ᐊᓅᐦᒡ ᑳ ᓃᐴᐎᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ᐋᒄ ᔅᑏᕙᓐ ᒦᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᐅᔑᐦᑐᐙᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᓂᔅᑯᒧᐎᓂᔨᐤ, ᐆ ᒫᒃ ᓂᔅᑯᒧᐎᓐ ᒑ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓂᐎᒡ ᓈᐹᔑᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳ ᒋᔅᒋᓄᐙᒋᔣᑦ ᐅᑯᓯᔅᐦ ᐋᐃᓵᒃ ᐄᔥᐱᐦ ᓂᔮᓈᓈᐤ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐱᒫᑎᓰᔨᒡ᙮ ᐋᐃᓵᒃ ᒫᒃ ᐋᔨᐅᑯᓐ ᒉᑭᑉᐦ ᑳ ᐅᐦᑖᐐᑦ᙮ ᒉᑭᑉ ᒫᒃ ᒌ ᓃᔓᔖᐳᔨᐤ ᐅᑯᓯᔅᐦ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᓃᔓᔖᑉ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᒋᑖᓂᔅᒑ ᑰᐦᑖᐐᓅᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ᐹᔨᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒉᑭᑉ ᐅᑯᓯᔅᐦ ᒍᓯᕝ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᑯᑎᒃ ᐅᑯᓯᔅᐦ ᒉᑭᑉ, ᒌ ᐅᐎᐦᑖᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᐙᐤ ᒍᓯᕝᐦ᙮ ᒌ ᐊᑖᐙᒑᐅᒡ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᐙᐤ ᐋ ᑎᐹᔨᒫᑭᓅᑦ ᐋᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᐄᑖᐱᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐄᒋᑉᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ᙮ ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑᐦ ᒌ ᐐᒑᐅᑰ ᒍᓯᕝ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ᒌ ᐱᑯᐦᐄᑰ ᒫᒃ ᐊᓂᑎᐦ ᒫᒀᒡ ᓈᔥᒡ ᐋᐦ ᐋᔨᒥᓂᔨᒡ ᑳᐦ ᑖᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒍᓯᕝ ᑳ ᐅᐦᑎᔅᑯᑳᐳᔥᑎᐙᑦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕓᕎ ᑳ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐄᒋᑉᑦ ᑳᐦ ᑖᔨᒡ, ᒋᔖᒥᓂᑑ ᒌ ᒥᔨᑰ ᒍᓯᕝ ᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ ᑭᔮᐦ ᒌ ᑐᑖᑰ ᒑ ᒌ ᒥᔻᔨᐦᑖᑯᓯᑦ᙮ ᒌ ᒥᔻᔨᒥᑰ ᒫᒃ ᕓᕎ, ᐋᒄ ᑳ ᐅᒋᒫᐅᐦᐄᑯᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋᔅᒋᔨᐤ ᑳ ᐅᒋᒫᑭᑎᒥᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᑎᐱᔨᐙᐅᓰᔨᒡ ᒌ ᒥᔨᑰ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“ᒑᒃ ᒫᒃ ᒌ ᓅᐦᑖᐱᔨᐤ ᒦᒋᒻ ᒥᓯᐙ ᐊᓂᑎᐦ ᐄᒋᑉᑦ ᑭᔮᐦ ᑫᓈᓐ ᐊᔅᒌᐦᒡ᙮ ᐊᓂᑖᐦ ᒫᒃ ᑫᓈᓐ ᐊᔅᒌᐦᒡ ᐋᑯᑖᐦ ᑳᐦ ᑖᔨᒡ ᒍᓯᕝ ᐅᐦᑖᐐᐦ ᑭᔮᐦ ᐐᒋᔖᓐᐦ᙮ ᓈᔥᒡ ᐋ ᒌ ᓂᓈᐦᑳᑖᔨᒧᒡ ᐄᔨᔨᐅᒡ᙮ ᒉᑭᑉ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ, ᐊᓂᒌ ᒋᑖᓂᔅᑰᓯᒥᓅᐎᒡ, ᓂᒧᐃ ᒥᑐᓐ ᐅᐦᒋ ᒥᔅᑭᒧᒡ ᒦᒋᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᒉᑭᑉ ᐋᐦᑎᑯᓃᔨᒡ ᒦᒋᒥᔨᐤ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐋ ᒌ ᒫᐅᒋᑖᑭᓂᐎᔨᑯᐱᓈ, ᒌ ᐄᑎᔑᐦᐙᐤ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ, ᒋᑖᓂᔅᑰᓯᒥᓂᐤ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᓃᔥᑎᒻ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ᒦᓐ ᒫᒃ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐋᒄ ᑳ ᒋᔅᒑᔨᐦᑖᑯᐦᐅᑦ ᒍᓯᕝ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓐᐦ ᐋᐦ ᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᕓᕎ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᒍᓯᕝᐦ ᐐᒋᔖᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ᐋᒄ ᒍᓯᕝ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᐅᐦᑖᐐᐦ ᒉᑭᑉ ᑭᔮᐦ ᒥᓯᐙ ᐅᐙᐦᑯᒫᑭᓂᔨᐤ ᒑ ᒌ ᐹᒋᐦᑖᔨᒡ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ᙮ ᓃᔂᓱᒥᑎᓂᐤ ᓂᔮᔫᔖᑉ ᒌ ᑎᔑᔨᐤ ᒫᒃ ᐅᔮᔨᐤ ᐅᐙᐦᑯᒫᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ᐋᒄ ᒉᑭᑉ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ, ᐋᑯᑖᐦ ᒫᒃ ᒑᒃ ᑳ ᐴᓂᐱᒫᑎᓰᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐋᑯᑖᐦ ᑭᔮᐦ ᐐᔨᐙᐤ ᒑᒃ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐎᔮᐙᐤ ᐊᓂᑖᐦ ᔐᑭᒻ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐋᑯᑖᐦ ᑳᐤ ᑳ ᐄᑐᐦᑖᑭᓂᐐᔨᒡ᙮ ᐋᒄ ᐊᓂᑖᐦ ᑳ ᓂᐦᐄᐦᑳᑭᓂᐐᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᓂᔮᑭᓐᐦ ᑳ ᑎᐱᐦᐋᒧᑯᐱᓈ ᐊᓂᑖᐦ ᐹᒋ ᐙᔥᑭᒡ, ᐦᐁᒸᕐ ᐅᑏᔨᔨᒥᔨᐤ ᐋ ᒌ ᐊᑖᒥᑯᑦ ᐅᔮᔨᐤ ᒌᐲᑭᒥᑯᐦᑳᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ᒑᒃ ᒫᒃ ᒌ ᐅᑎᐦᒋᐱᔨᔨᐤ ᒑ ᒌᐦ ᑐᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᐋᑉᕋᐦᐋᒻ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒧᐙᑦ᙮ ᔖᔥ ᒫᒃ ᓈᔥᒡ ᒌ ᒥᐦᒑᑑᒡ ᒋᑎᐄᔨᔨᒥᓅᒡ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᐋ ᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ᑯᑎᒃ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᒑᒃ ᒌ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓂᑎᐦ ᐄᒋᐱᑎᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᒫᑯᐱᓈ ᐊᓂᔮᔨᐤ ᒍᓯᕝᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ᐆ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᓂᒥ ᐅᐦᒋ ᑖᑆᐅᒑᔨᐦᑖᑰᓲ ᑭᔮᐦ ᓈᔥᒡ ᒌ ᒫᔮᔨᒫᐤ ᐊᓂᔮᐦ ᒋᐙᐦᑯᒫᑭᓄᐤ, ᒌᐦ ᑐᑎᐙᐤ ᒥᔥᑏᐦ ᒑ ᒌ ᓂᓈᐦᑳᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒌ ᐄᑎᔓᐙᑖᐤ ᐎᔨᐐᑎᒥᐦᒡ ᒑ ᒌ ᓂᑭᑎᒫᑭᓂᐎᔨᒡ ᐅᑎᐙᔑᔒᒥᔨᐤ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᑖᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“ᐋᑯᑖᐦ ᒫᒃ ᒫᒀᒡ ᐆ ᑳ ᐄᔅᐱᔨᒡ ᓈᐹᔥ ᒌ ᐱᒫᑎᓰᐤ ᒧᓱᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᓈᔥᒡ ᐋ ᒌ ᒥᔪᓈᑯᓯᑦ᙮ ᓂᔥᑐ ᐲᓯᒻ ᒫᒃ ᒌ ᐃᔥᐱᔥ ᑭᓂᐙᔨᒫᑭᓂᐤ ᐊᓂᑖᐦ ᐅᐦᑖᐐᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑳᔮᑭᓅᑦ ᒧᓱᔅ ᐊᓂᑖᐦ ᐎᔨᐐᑎᒥᐦᒡ ᕓᕎ ᐅᑖᓂᓯᔨᐤᐦ ᒌ ᒥᔅᑳᑰ, ᒌ ᐅᑎᓂᑰ, ᐋᒄ ᑳ ᑭᓂᐙᔨᒥᑯᑦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᔥ ᑭᔮᐦ ᑳ ᓂᐦᑖᐅᒋᓂᑯᑦ ᒧᔮᒻ ᐐᔨ ᑎᐱᔨᐙ ᐅᑯᓯᔅᐦ ᐋ ᒌ ᑐᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ᒥᓯᐙ ᒫᒃ ᒌ ᐄᔑ ᒋᔅᑯᑎᒧᐙᑭᓂᐤ ᒧᓱᔅ ᐄᒋᑉᑦ ᐄᔨᔨᐤ ᐅᑭᒑᐦᑖᐙᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᓈᓈᓂᒌᒻ ᓈᔥᒡ ᒌ ᑭᔅᒋᐦᐆ ᐋ ᐊᔨᒥᑦ ᑭᔮᐦ ᒑᒀᔨᐤ ᐋᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ᐄᔥᐱᐦ ᒫᒃ ᓈᒥᑎᓂᐤ ᑳ ᑎᑐᐳᓍᔑᑦ ᒧᓱᔅ ᐋᒄ ᑳ ᐄᑖᔨᐦᑎᐦᒃ ᒑ ᓂᑎᐙᐦᐋᑦ ᑖᓐ ᐋᔨᑑᑎᐙᑭᓂᐎᔨᒡ ᐐᒋᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ᒌ ᐙᐱᒫᐤ ᒫᒃ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐋ ᓂᓈᐦᑳᒋᐦᐄᑯᔨᒡ ᐄᒋᑉᑦ ᐄᔨᔨᐤ᙮ ᐋᒄ ᑳ ᓂᑑᓈᑎᒧᐙᑦ, ᑳ ᓂᐱᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᒋᑉᑦ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ᐅᔮᔨᐤ ᐋ ᒌᐦ ᑐᑎᐦᒃ ᒌ ᐄᑖᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᑎᐲᐙ ᐅᑎᔨᔨᒻᐦ ᒑ ᓂᔅᑐᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᒑ ᐋᐱᒋᐦᐄᑯᑦ ᒑ ᒌ ᐱᑯᐦᐋᑦ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ, ᒧᓱᔅ ᒌ ᓈᑖᐤ ᓃᔓ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐋ ᒫᓯᐦᐄᑐᔨᒡ, ᐋᒄ ᑳ ᐐᐦ ᒋᐱᐦᒋᐦᐋᑦ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᓂᑐᐦᑎᐎᒄ ᒫᐦ, ᑖᐱᔥᑯᓐ ᒋᐐᒋᔖᓂᓂᑐᓈᐙᐤ ᒨᔮᒻ, ᒑᒀᓐ ᐙᐦᒋ ᒫᓯᐦᐄᑐᔮᒄ?’ ” ");
INSERT INTO crl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“ᐊᓐ ᒫᒃ ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐋ ᒫᓯᐦᐄᑐᒡ ᐊᓂᔮᔨᐤ ᐐᒋᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒌ ᑯᐦᑯᓈᐤ ᐊᓂᔮᔨᐤ ᒧᓱᔅ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, ‘ᐊᐙᓐ ᑳ ᐎᔮᔨᒥᔅᒃ ᒑ ᒌ ᐅᒋᒫᐦᑭᐦᑑᔮᐦᒡ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᑎᐹᔅᑯᓂᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ᐋᐤ ᐋ ᐙᑑᑎᐎᔨᓐ ᑖᓐ ᑳᐦ ᑐᑎᐙᑦ ᐅᑖᑯᔑᔨᒡ ᐊᓐ ᐄᒋᐱᑎᐄᔨᔨᐤ ᑳ ᓂᐱᐦᐄᑦ?’ ");
INSERT INTO crl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᒧᓱᔅ, ᒌ ᐅᔑᒨ ᐊᓂᑎᐦ ᐄᒋᑉᑦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ, ᐋᒄ ᐊᓂᑖᐦ ᒥᑎᔮᓐ ᐊᔅᒌᐦᒡ ᑳ ᓂᑑᐃᐦᑖᑦ ᐋ ᒫᓂᑖᐅᑦ᙮ ᐋᑯᑖᐦ ᑳ ᐐᒋᑦ ᑭᔮᐦ ᐋᑯᑖᐦ ᑳ ᐱᒫᑎᓰᔨᒡ ᓃᔓ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“ᐄᔥᐱᐦ ᒫᒃ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐ ᑳᐦ ᑖᑦ ᒧᓱᔅ ᐊᓂᑖᐦ ᒥᑎᔮᓐ ᐊᔅᒌᐦᒡ, ᐹᔨᒀᐤ ᐋ ᒌᔑᑳᔨᒡ ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ, ᐹᔓᒡ ᐊᓂᑖᐦ ᐋ ᐱᔅᒀᐱᔅᑳᔨᒡ ᓵᐃᓈᐃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᒌ ᐙᐱᐦᑎᒻ ᐋ ᐎᔨᑖᐱᔨᔨᒡ ᐊᓂᑎᐦ ᐋ ᐱᔅᑯᑳᐳᐐᔨᒡ ᓃᐱᓰ, ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐅᐦᒋ ᓅᑯᓰᔥᑖᑯᑦ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ᐄᔥᐱᐦ ᒫᒃ ᒧᓱᔅ ᑳ ᐙᐱᐦᑎᐦᒃ ᐅᔮᔨᐤ ᓈᔥᒡ ᒌ ᑯᔥᑯᒀᔨᑎᒻ᙮ ᐋᒄ ᑳ ᓈᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᐱᔅᑯᑳᐳᐐᔨᒡ ᓃᐱᓰ ᐹᔓᒡ ᒑ ᒌ ᑭᓂᐙᐱᐦᑎᐦᒃ᙮ ᒌ ᐹᐦᑎᐙᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᐅᐦᒋ ᐊᔨᒥᔨᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋᐦ ᐄᔨᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ᐋᐅᒄ ᓃᔨ ᐅᒋᔖᒥᓂᑑᒧᐙᐤ, ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓵᒃ ᑭᔮᐦ ᒉᑭᑉ᙮’ ᐄᔥᐱᐦ ᒧᓱᔅ ᐱᔮᐦᑎᐙᑦ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌ ᐙᐐᐱᔨᐤ ᐋ ᐃᔥᐱᔥ ᓵᒋᓯᑦ, ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑭᓂᐙᐱᐦᑎᒻ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᒀᑖᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᒦᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ, ‘ᒥᓂᐦ ᒋᒥᔅᒋᓯᓐ, ᐙᔥ ᐊᓂᑎᐦ ᐊᓐ ᐋ ᓃᐴᐎᔨᓐ ᐱᔮᐦᑭᓐ ᐊᓐ ᐊᔅᒌ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ᒥᑐᓐ ᓂᒌᐙᐱᒫᐅᒡ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓂᓈᐦᑳᑖᔨᒧᒡ ᓂᑎᐄᔨᔨᒥᒡ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ᙮ ᓂᐹᐦᑎᐙᐅᒡ ᐋ ᒥᒫᑣᒡ, ᐋᒄ ᒫᒃ ᑖᑯᔑᓂᔮᓐ ᒑ ᒌ ᐱᑯᐦᐄᒀᐤ᙮ ᐋᔥᑎᒻ ᒫᒃ, ᒦᓐ ᒋᑭ ᐄᑎᔓᐦᐆᑎᓐ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ᒦᓐ ᒫᒃ ᔅᑏᕙᓐ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᒌ ᐋᑎᐙᔨᒫᐅᒡ ᒫᒃ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐅᔮᔨᐤ ᒧᓱᔅ ᐋ ᒌ ᐃᑖᒡ, ‘ᐊᐙᓐ ᑳ ᐎᔮᔨᒥᔅᒃ ᒑ ᒌ ᐅᒋᒫᐦᑭᐦᑑᔮᐦᒡ ᑭᔮᐦ ᒑ ᒌ ᑎᐹᔅᑯᓂᔮᐦᒡ?’ ᐋᔪᐎᒄ ᐋᓐ ᒫᒃ ᐅᔮᔨᐤ ᐊᔮᐱᒡ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐅᒋᒫᒥᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐱᑯᐦᐄᑯᔨᒡ᙮ ᒋᔖᒥᓂᑑ ᒌ ᐊᔨᒥᐦᐋᐤ ᒧᓱᔅ ᐊᓂᔮᔨᐤᐦ ᐋᓐᒋᓐᐦ ᐋ ᒌ ᐋᐱᒋᐦᐋᑦ ᐊᓂᑖᐦ ᐅᐦᒋ ᑳ ᐱᔅᑯᑳᐳᐐᔨᒡ ᓃᐱᓰ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ᐋᐅᒄ ᒫᒃ ᐆ ᒧᓱᔅ ᑳ ᐹᒋ ᐎᔨᐐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐅᐦᒋ᙮ ᒌ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑐ ᒫᒃ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒥᐦᒀᑭᒦᐦᒡ ᑭᔮᐦ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐ ᒌ ᒫᒥᔥᑳᒡ ᐃᔨᐦᑐ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ᐋᐅᒄ ᐆ ᒧᓱᔅ ᑳᐦ ᐃᔨᑖᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐊᓂᑖᐦ ᑳ ᐅᐦᒌᔨᒡ, ᒋᔖᒥᓂᑑ ᒋᑭ ᐄᑎᔓᐦᐊᒫᑯᐙᐤ ᐊᐙᔨᐤᐦ ᒑ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᔨᒡ ᒧᔮᒻ ᓃᔨ ᑳ ᐄᔑ ᐹᒋ ᐄᑎᔓᐦᐅᑦ, ᐅᑎᐦ ᒫᒃ ᐋ ᐅᐦᒋᔮᒄ ᒋᑭ ᐅᐦᒋᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ᐋᐅᒄ ᐆ ᒧᓱᔅ ᒌᐦ ᑖᐤ ᑭᔮᐦ ᐐᔨ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒫᒀᒡ ᑳᐦ ᑖᒡ ᐊᓂᑖᐦ ᐊᓂᒌ ᐙᔥᑭᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᓵᐃᓈᐃ ᐋᐱᔅᑯᑎᓈᐦᒡ ᐊᓂᑎᐦ ᑳ ᐊᔨᒥᐦᐄᑯᑦ ᐋᓐᒋᓐ᙮ ᐐᔨ ᒧᓱᔅ ᒌ ᒥᔮᑭᓂᐤ ᒑ ᒌ ᐋᔔᐐᐦᑎᒫᑎᐦᒄ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᑳ ᐱᒫᑎᓰᐎᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ᒥᒄ ᒫᒃ ᐊᓂᒌ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐊᔮᐱᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᑐᐦᑎᐙᐅᒡ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᐅᒡ, ᐊᐅᔅᑖ ᒌ ᐄᑖᔨᐦᑎᒧᒡ ᒦᓐ ᑳᐤ ᒑ ᒌ ᒌᐙᒡ ᐊᓂᑖᐦ ᐄᒋᑉᑦ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ᒌ ᐄᑖᐅᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐁᕋᓐ, ‘ᐅᔑᐦᑎᒨᓈᓐ ᒥᓂᑑᐦᑳᓂᒡ ᒑ ᒌ ᓃᑳᓂᐦᑎᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ ᒑ ᐄᑐᐦᑖᔮᐦᒡ, ᐙᔥ ᓂᒧᐃ ᓂᒋᔅᒑᔨᒫᓈᓐ ᑖᓐ ᐋ ᑎᒃ ᒧᓱᔅ, ᐊᓐ ᑳ ᐱᑯᐦᐄᔨᒥᐦᑦ ᐊᓂᑖᐦ ᐄᒋᐱᑎᐦᒡ ᐅᐦᒋ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᐅᔑᐦᐋᒡ ᒥᓂᑑᐦᑳᓐ ᒧᔮᒻ ᒥᔅᑐᔥ ᐋ ᐃᓯᓈᑯᓰᔨᒡ᙮ ᐋᒄ ᑳ ᒧᒋᔥᑖᐦᐙᒧᐙᒡ ᐊᓂᔮᔨᐤ ᒥᓂᑑᐦᑳᓐ ᑭᔮᐦ ᑳ ᒥᑯᔖᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒌ ᐅᔑᑎᒫᓱᒡ ᐊᓂᔮᔨᐤ ᒥᓂᑑᐦᑳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᓂᑭᑎᑯᒡ, ᑳ ᐱᒋᔅᑎᓂᑯᒡ ᒑ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔥᑐᐙᒡ ᐊᒋᐦᑯᔥ᙮ ᒌ ᒥᓯᓂᐦᐋᒧᒡ ᒋᔖᒥᓂᑑ ᐅᒥᓯᓂᐦᐄᑭᓃᔨᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ ᒋᔖᒥᓂᑑ, ᒌᔨᐙᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ, ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐ ᒋᒌ ᓂᐱᐦᐋᐙᐅᒡ ᐊᐅᐦᑳᓂᒡ ᐋ ᒧᒋᔥᑖᐦᐊᒫᔮᒄ, ᒫᒀᒡ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑖᔮᒄ, ᓂᒥᔮᐤ ᒫᒃ ᓃᔨ ᑳᐦ ᑐᑎᒧᔮᒄ ᐆ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ᒋᒌ ᐱᐹᒧᐦᑖᐙᓈᐙᐤ ᒌ ᒥᓂᑑᐦᑳᓂᐙᐤ ᒸᓓᒃ ᐅᒫᐦᑮᒻ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑎᒋᐦᑯᔒᒻ ᑳ ᐅᔑᐦᑎᒧᐙᒄ ᐊᓐ ᒌ ᒥᓂᑑᐦᑳᓂᐙᐤ ᕃᕚᓐ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ ᒥᓂᑑᐦᑳᓂᒡ ᑳ ᐅᔑᐦᐋᑯᒡ ᒑ ᒌ ᐅᒋᐦᒌᐦᑯᓂᐱᔥᑐᐙᑯᒡ᙮ ᐋᒄ ᒫᒃ ᒑ ᑐᑖᑎᑯᒡ ᐋᐙᔅᑖᐦ ᐹᐱᓨᓂᐦᒡ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᑭᐎᔮᒄ ᐊᓂᑖᐦ ᒑ ᒥᒫᐦᒋᑯᓂᑯᔮᒄ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᑎᓯᓂᐦᐄᒑᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐋ ᒌ ᐄᔨᔨᒡ ᒋᔖᒥᓂᑑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ᐋᒄ ᐆ ᒦᓐ ᒑ ᐐᐦᑎᒫᑎᑯᒡ, ᐊᓂᒌ ᐹᒋ ᐋᓂᔅᒑ ᒌ ᐙᐦᑯᒫᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳ ᒌᐦ ᑖᒡ, ᒌ ᐃᔮᐅᒡ ᐊᔨᒥᐦᐋᐅᒫᐦᑭᔨᐤ᙮ ᐊᓐ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒫᐦᑮ ᑳᐦ ᐄᑖᑦ ᒋᔖᒥᓂᑑ ᒧᓱᔅ ᒑ ᐃᓯᓈᑯᐦᑖᔨᒡ ᐋᔪᐎᒄ ᓂᐦᐋᐤ ᑳ ᐃᓯᓈᑯᐦᑖᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ᒥᐦᒑᑐ ᐱᐳᓐ ᒫᒃ ᐊᓂᒌ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᒌ ᐃᔮᐅᒡ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐅᒫᐦᑭᔨᐤ ᐋ ᒌ ᐋᔔᒥᔮᑭᓂᐎᒡ᙮ ᒌ ᐹᑖᐅᒡ ᑭᔮᐦ ᐄᔥᐱᐦ ᑳ ᐐᒑᐙᒡ ᐊᓂᔮ ᒞᔓᐋ ᑳ ᐲᐦᒑᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐊᓂᑎᐦ ᒋᔖᒥᓂᑑ ᑳ ᐅᐦᒋ ᒋᐦᒋᑎᔑᐦᐙᑦ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ᐋᔥᒄ ᒌ ᐋᐱᑎᓐ ᐆ ᐊᔨᒥᐦᐋᐅᒫᐦᑮ ᐅᔅᑭᒡ ᑳ ᒋᐦᒋᐅᒋᒫᐅᑦ ᐊᓂᔮ ᑌᕕᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᓂᐦᐋᔨᐦᑎᒻ ᑖᓐ ᑳ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ᙮ ᐆ ᒫᒃ ᑌᕕᑦ ᒌ ᑯᒀᒋᒫᐤ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐄᑖᑦ, ‘ᒋᑭ ᐱᒋᔅᑎᓐ ᐋ ᒑ ᒌ ᐐᔨᑳᐳᐦᑣᑖᓐ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ, ᒌᔨ ᐊᓂᔮ ᒉᑭᑉ ᑳ ᐅᒋᔖᒥᓂᑑᒥᔅᒃ?’ ");
INSERT INTO crl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ᒥᒄ ᒫᒃ ᓂᒥᔮᐤ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᑳ ᒥᔮᑭᓅᑦ ᒑ ᒌ ᐐᔨᑳᐳᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᒋᔖᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᔂᓚᒥᓐ ᐋᐅᒄ ᐊᓐ ᑳ ᐐᔨᑳᐳᐦᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᓂᒧᐃ ᐐᒋᐤ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐄᔨᔨᐤ ᐋ ᒌ ᐅᔑᐦᑖᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔥᑖᑦ ᐊᓐ ᐹᔨᒄ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ ᒋᔖᒥᓂᑑ, ");
INSERT INTO crl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘ᐋᒄ ᐃᔮᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋᐅᒄ ᐙᐦ ᒌᐦᒌᐅᒋᒫᐆᑖᐦᑎᐴᐎᓂᔮᓐ, ᐆ ᒫᒃ ᐊᔅᒌ ᒧᔮᒻ ᐋ ᐊᐱᔖᔑᒡ ᑖᐦᑎᐱᐎᓐ ᓂᑎ ᐄᑖᔨᐦᑖᓐ ᐊᓂᑎᐦ ᒑ ᒌ ᑖᐦᑎᔥᑖᔮᓐ ᓂᓯᑦ᙮ ᑖᓐ ᒫᒃ ᒋᐱᐦ ᒋᐃᓯᓈᑯᐦᑖᓈᐙᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᐊᓂᑎᐦ ᒑ ᒌ ᐋᔨᐙᓯᔮᓐ? ");
INSERT INTO crl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ᓂᒧᐃ ᐋ ᓃᔨ ᓅᐦᒋ ᐅᔑᐦᑖᓐ ᒥᓯᐙ ᒑᒀᓐ? ᒌ ᐃᔨᐤ ᒋᔖᒥᓂᑑ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ᔅᑏᕙᓐ ᐊᑎᑎᐤ ᑳᐦ ᐋᑎ ᐃᔨᑦ, “ᒋᔥᒋᓯᑖᐤ ᒫᐦ, ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᓲᐦᒋᔥᑎᒀᓈᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐋᐅᒄ ᒧᔮᒻ ᑭᔮᐦ ᒌᔨᐙᐤ ᐋ ᐃᔥᐱᔥ ᓲᐦᒋᔥᑎᒀᓈᔮᒄ᙮ ᐋᐦᐋᑳ ᑖᑆᐦᑎᒫᒄ ᐊᓂᑖᐦ ᒋᑖᐦᐄᐙᐦᒡ, ᑭᔮᐦ ᐋᐦᐋᑳ ᐐᐦ ᓂᑑᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓐᐦ, ᒧᔮᒻ ᒋᑖᓂᔅᑰᓰᒥᐙᐅᒡ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐐᐦ ᓂᓂᐦᐄᐦᑐᐙᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ᒥᓯᐙ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᒌ ᓂᓈᐦᑳᒋᐦᐋᐅᒡ ᒋᑖᓂᔅᑰᓰᒥᐙᐅᒡ᙮ ᑭᔮᐦ ᒌ ᓂᐱᐦᐋᐅᒡ ᐊᓂᔮᐦᑳ ᑳ ᐹᒋ ᓃᑳᓐ ᐐᐦᑎᒥᔨᒡ ᒑ ᑎᑯᔑᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᑳ ᒫᒥᓯᒫᒄ ᑭᔮᐦ ᑳ ᓂᐱᐦᐋᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ᐋᓐᒋᓂᒡ ᒋᒌ ᐹᑣᑯᐙᐅᒡ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓂᔨᐤ, ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐊᔮᐱᒡ ᑰᐦᒋ ᓂᓂᐦᐄᐦᑎᒸᓈᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᑳ ᓂᔥᑐᐐᒡ ᑳ ᐹᐦᑎᐙᒡ ᐊᓂᔮᔨᐤ ᔅᑏᕙᓐ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ, ᓈᔥᒡ ᒌ ᒋᔑᐙᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ᒥᒄ ᒫᒃ ᔅᑏᕙᓐ ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᐄᑖᐱᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐄᔑ, ᐋᒄ ᑳ ᐙᐱᐦᑎᒸᑦ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓱᐎᓂᔨᐤ ᑭᔮᐦ ᑳ ᐙᐱᒫᑦ ᒌᓴᔅᐦ ᐋ ᓃᐴᐎᔨᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ᒌᐦ ᐄᑖᐤ ᒫᒃ ᔅᑏᕙᓐ, “ᑭᓂᐙᐱᐦᑎᒧᒄ ᒫᐦ, ᓂᐙᐱᐦᑖᓐ ᒋᐦᒋᒌᔑᒄ ᐋᐦ ᐋᐱᐦᐄᐱᔨᐦᒡ ᑭᔮᐦ ᓂᐙᐱᒫᐤ ᐄᔨᔨᐅᑯᓯᓵᓐ ᐋ ᓃᐴᐎᑦ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐄᑖᐦᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ᒌ ᒋᐳᓂᒧᒡ ᐅᐦᑎᐎᑳᐙᐤ ᐋᐦ ᐋᔑᒀᒡ ᐊᓂᒌ ᑳ ᐹᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ᙮ ᐋᒄ ᒥᓯᐙ ᒫᐅᓯᒄ ᑳ ᐄᔥᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ᐋᒄ ᑳ ᐎᔨᐐᑎᔑᐦᓈᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋᒄ ᑳ ᒋᐦᒋᒌᒡ ᐋ ᓂᐱᐦᐋᒡ ᐋ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᒡ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᒫᒦᔑᐦᐋᒡ ᔅᑏᕙᓐ ᒌ ᓂᑭᑎᒧᒡ ᐅᑎᑯᐦᐱᐙᐤ ᒑ ᒌ ᓈᓈᑭᒋᐦᑖᔨᒡ ᐅᔅᒋᓃᒎ ᔂᓪ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ᒌ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᐅᒡ ᒫᒃ ᐊᔮᐱᒡ ᐊᓂᔮᔨᐤ ᔅᑏᕙᓐ ᐋᐦ ᐋᑎ ᒫᒀᒡ ᐋ ᑖᑆᑖᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐋᐦ ᐄᔨᔨᒡ, “ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ, ᐅᑎᓐ ᓂᑎᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ᔅᑏᕙᓐ ᒌ ᓃᐱᔅᑯᐱᐤ, ᐋᐦ ᐋᔑᒀᑦ ᐋᐦ ᐃᔨᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᐙᐹᔨᐦᑎᒨᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐎᒡ ᐊᑳᐐ ᑭᑎ ᐐᐦ ᐱᑎᑯᔥᑳᑯᒡ᙮” ᐋᒄ ᒫᒃ ᑳ ᐴᓂᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ᔂᓪ ᒫᒃ ᒌ ᓂᐦᐋᔨᐦᑎᒻ ᐋ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᔅᑏᕙᓐ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐹᔨᑯᓃᔨᒡ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᒌ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᐦᒋ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᓂᑭᑎᐦᒡ ᒉᕉᓯᓕᒥᔨᐤ᙮ ᐋᒄ ᐊᓂᑖᐦ ᒎᑏᔮᐦᒡ ᑭᔮᐦ ᓵᒫᕆᔮᐦᒡ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᑳᐦ ᐋᑎᐐᒋᒡ᙮ ᒥᒄ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᐋᑯᑖᐦ ᐊᔮᐱᒡ ᑳᐦ ᑖᒡ ᐐᔨᐙᐤ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ᐱᔅᒡ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᓈᐹᐅᒡ ᒌ ᓂᑑᓂᐦᐄᐦᑯᐙᐅᒡ ᔅᑏᕙᓐ, ᐋ ᒋᔂᐙᒡ ᐋ ᒫᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ᔂᓪ ᒫᒃ ᒋᐐᐦ ᐃᔮᔪᐦᐋᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ᙮ ᒥᓯᐙ ᐙᔅᑳᐦᐄᑭᓐ ᒌ ᐲᐦᒑᐤ, ᐋ ᐎᔨᐐᑖᐹᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ, ᑖᐱᔥᑯᓐ ᐃᔅᒀᐤ ᑭᔮᐦ ᓈᐹᐤ, ᒑ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ᐊᓂᒌ ᒫᒃ ᑳ ᑖᑆᐦᑎᐦᒡ ᑳ ᐅᔑᒧᒡ ᒋᕉᓯᓕᒥᐦᒡ, ᒥᓯᐙ ᒌ ᐱᐹᐄᑐᐦᑖᐅᒡ ᐋ ᐙᐐᐦᑎᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ᕕᓕᑉ ᒫᒃ, ᒌ ᐄᑐᐦᑖᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᐋᐦᑎᑯᓃᔨᒡ᙮ ᐋᒄ ᑳ ᐙᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᒌᓴᔅᐦ ᐋ ᙭ᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᑳ ᐹᐦᑎᐙᒡ ᐋ ᐊᔨᒥᔨᒡ ᑭᔮᐦ ᐋ ᐙᐱᐦᑎᒸᒡ ᒫᒥᔥᑳᒡ ᒑᒀᔨᐤ ᐋᐦ ᑐᑎᒥᔨᒡ ᓈᔥᒡ ᓲᐦᒃ ᒋᐐᐦ ᓂᑐᐦᑎᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ᒥᒋᐊᐦᒑᐦᑯᒡ ᓲᐦᒃ ᐋ ᑖᑆᒡ ᒌ ᐹᒋ ᐎᔨᐐᔫᒡ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐲᐦᒋᔥᑯᐙᒡ᙮ ᐊᓂᒌ ᒫᒃ ᐋᑳ ᑳ ᒌᐋᐦᑎᓂᓯᐎᒡ, ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒫᔅᒋᓯᒡ, ᒌ ᒦᓂᐙᒋᐦᐋᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ᒌ ᒥᔅᑎᒨᒋᒑᔨᐦᑖᑭᓂᐤ ᒫᒃ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᐃᐦᑖᐎᓐ ᒌᐦ ᑖᐤ ᓈᐹᐤ ᓵᐃᒥᓐ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐋ ᒌ ᒫᒫᐦᑖᐙᑎᓰᑦ᙮ ᔖᔥ ᒫᒃ ᐙᔥᑭᒌᔥ ᐊᓂᒌ ᓵᒫᕆᔮ ᐄᔨᔨᐅᒡ ᒌ ᒥᔅᑳᑖᔨᒫᐅᒡ ᑖᓐ ᑳᐦ ᑎᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ᑭᔮᐦ ᐊᐙᓐ ᐋ ᒋᑳᔮᔨᑖᑯᓯᑦ ᒌ ᐄᑖᒋᒦᓲ ᐊᓐ ᓵᐃᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᑳ ᒋᑳᔮᔨᑖᑯᓯᑦ ᑭᔮᐦ ᓅᐦᑖᔮᔥ ᑳ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᓈᔥᒡ ᒌ ᓂᑐᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ, ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᐄᑖᐅᒡ ᐋᐦ ᐋᔨᒨᒫᒡ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ, “ᐆ ᓈᐹᐤ, ᐃᔮᐤ ᒫᐦᑖᐙᑎᓰᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᑎᓂᐦᒃ᙮ ᐋᔨᐤᐦ ᒌ ᐄᑖᔨᒫᐅᒡ ᐋ ᒌ ᐄᔑᓂᐦᑳᑎᒫᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᐋ ᒋᔅᑖᔨᐦᑖᑰᓰᔨᒡ ᐋ ᒥᒫᐦᑖᐙᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ᓈᔥᒡ ᒌ ᓂᑑᐦᑖᑰ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐙᔥ ᔖᔥ ᐙᔥᑭᒡ ᒌ ᒫᒥᔅᑳᑖᔨᐦᑎᒥᐦᐋᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋ ᒥᒫᐦᑖᐙᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ᐄᔥᐱᐦ ᒫᒃ ᕕᓕᑉ ᑳ ᑎᑯᔑᓃᔨᒡ ᐋ ᐙᐐᐦᑎᒫᑯᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ, ᐋ ᑎᐹᒋᒫᔨᒡ ᒌᓴᔅ ᙭ ᑭᔮᐦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ ᐋᐦ ᐋᔨᒨᑎᒥᔨᒡ, ᒌ ᑖᑆᐦᑎᐙᐅᒡ, ᑖᐱᔥᑯᓐ ᒫᒃ ᓈᐹᐅᒡ ᑭᔮᐦ ᐃᔅᒀᐅᒡ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ᐊᓐ ᒫᒃ ᓵᐃᒥᓐ ᑳ ᒥᒥᐦᑖᐙᑎᓰᑦ ᒌ ᑖᑆᐦᑎᒻ᙮ ᐃᔅᑯᑎᒄ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓅᑦ, ᐋᒄ ᒫᒃ ᒨᔥ ᑳ ᒌ ᐱᐹᐐᒑᐙᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ, ᒌ ᒥᔅᑳᑖᔨᐦᑎᒻ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ, ᐱᔮᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᑳᐦ ᑖᔨᒡ ᐋ ᑖᑆᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ, ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ, ᒌ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᒑ ᒌ ᐲᐦᒋᔅᑳᑯᔨᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ᐙᔥ ᐋᔥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐲᐦᒋᔅᑳᑯᐎᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐊᐦᒑᐦᒄᐦ᙮ ᒥᒄ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ᐋᒄ ᒫᒃ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᑳ ᑖᐦᒋᓈᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᐋᒄ ᒫᒃ ᑳ ᐲᐦᒋᔅᑳᑯᔨᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ᐄᔥᐱᐦ ᓵᐃᒥᓐ ᑳ ᒥᒫᐦᑖᐙᑎᓯᑦ, ᐎᔮᐱᒫᑦ ᐋ ᐲᐦᒋᔅᑳᑯᔨᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐊᐦᒑᐦᒄᐦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᑳ ᑖᐦᒋᓈᔨᒡ, ᒋᐐᐦ ᒥᔮᐤ ᔓᐎᔮᓐ ᐊᓂᔮᔨᐤ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ, ");
INSERT INTO crl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ᐋᐦ ᐄᑖᑦ, “ᐹᒋ ᒥᔨᒄ ᐆ ᓲᐦᑳᑎᓰᐎᓐ, ᐋᒄ ᒫᒃ ᒥᒄ ᐊᐙᓐ ᒑ ᑖᒋᓂᒃ ᒑ ᐃᔮᐙᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᒋᔔᔮᓂᒻ ᑭᔮᐦ ᒌ ᒋᑭ ᓂᔑᐎᓈᑎᓯᓈᐙᐤ ᐋᑖᔨᐦᑎᒧᓈ ᔓᐎᔮᓐ ᒑ ᒌ ᐋᐱᒋᐦᐄᑦ ᒑ ᒌ ᐅᑎᓂᒧᑦ ᒋᔖᒥᓂᑑ ᐅᒥᔨᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ᓂᒧᐃ ᒋᑭ ᒌ ᐐᒋᐋᐱᑎᓰᒥᓈᓐ, ᐙᔥ ᓂᒧᐃ ᑯᐃᔅᑯᓈᑯᓐ ᒌ ᐱᒫᑎᓰᐎᓐ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ᐴᓃᐦ ᐆ ᐋ ᐄᔑ ᒥᒋᒫᒥᑐᓈᔨᐦᑎᒥᓐ ᒋᐦᑖᐄᐦᒡ, ᒀᔂᓐ ᒋᑭ ᐙᐹᔨᐦᑎᒫᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᓂᑐᑎᒧᑖ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ᐙᔥ ᓂᐙᐱᐦᑖᓐ ᓈᔥᒡ ᐋ ᐃᔮᔨᓐ ᐅᐦᑖᔨᐦᑎᒧᐎᓐ, ᑭᔮᐦ ᒋᒥᒋᐦᑣᐎᓐ ᐋ ᒫᒫᐦᒋᑯᓂᑯᔨᓐ,” ᒌᐦ ᐄᑖᐤ ᐲᑎᕐ ᐊᓂᔮᔨᐤ ᓵᐃᒥᓐ ᑳ ᒥᒫᐦᑖᐙᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ᐋᒄ ᐊᓐ ᓵᐃᒥᓐ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ, “ᓂᑐᑎᒫᔅᑎᒨᐙᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᑳ ᒑ ᒌ ᐅᑎᐦᑎᐦᐅᑯᔮᓐ ᐆ ᑳᐦ ᐃᔨᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᑭᔮᐦ ᒞᓐ ᑳ ᑭᒑᔅᒋᒫᒡ ᑭᔮᐦ ᒌᔥ ᐙᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᒑᔨᒫᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ, ᑭᔮᐦ ᐋ ᐙᐐᐦᑎᒧᐙᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋᒄ ᑳ ᒌᐙᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᒌ ᐙᐐᐦᑎᒧᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᒥᐦᒑᑐ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᓵᒫᕆᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ᐋᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐄᑎᔓᒫᐤ ᐋᓐᒋᓐ ᒑ ᒌ ᐊᔨᒥᐦᐋᔨᒡ ᕕᓕᑉ, ᒑ ᒌ ᐃᑖᔨᒡ, “ᐱᓯᑰᐦ ᒫᐦ ᐊᓂᑖᐦ ᐱᔑᒸᑖᒡ ᒑ ᐄᔑ ᒋᔅᑐᐦᑖᔨᓐ ᐹᑎᔥ ᐅᑎᐦᑎᒥᓈ ᐊᓐ ᒫᔅᑭᓂᐤ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐆᐦᑎᒨᒡ ᐊᓂᑖᐦ ᐄᔑ ᑳᓴᐦᒡ ᑳ ᐄᑎᒨᐦᒡ᙮ ᐊᓐ ᒫᒃ ᒫᔅᑭᓂᐤ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᒌ ᐄᑎᒨ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒋᔅᑐᐦᑖᐤ ᕕᓕᑉ, ᑳ ᓂᒋᔥᑭᐙᑦ ᓈᐹᐤ ᐄᕠᔪᐱᔮᐦᒡ ᐋ ᐄᔑ ᒌᐙᔨᒡ, ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐅᐦᑐᐦᑖᔨᒡ ᐋ ᒌ ᓈᒋᐊᔨᒥᐦᐋᐄᑯᐱᓈᓂᐦᐄ ᐊᓂᑖᐦ, ᓈᔥᒡ ᒫᒃ ᒌ ᒋᔅᑖᔨᐦᑖᑯᓰᑖᑯᐱᓐ ᐅᔮᔨᐤ ᓈᐹᐤ᙮ ᐆ ᒫᒃ ᓈᐹᐤ ᒌ ᓈᓈᑭᒋᐦᐄᒫᐤ ᐄᕠᔪᐱᔮ ᒋᐦᒋᐅᒋᒫᔥᒀᐤ ᐅᔔᔮᓂᒥᔨᐤ ᑭᔮᐦ ᐅᒑᒀᓂᒥᔨᐤ᙮ ᐊᓂᑖᐦ ᒫᒃ ᐄᕠᔪᐱᔮᐦᒡ ᑳᓐᑎᔅ ᒌ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ ᐊᐙᓐ ᐋ ᒋᐦᒋᐅᒋᒫᔥᒀᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ᐆ ᓈᐹᐤ ᐋ ᐄᔑ ᒌᐙᐱᔨᑦ ᑎᐦᑎᐱᑖᐹᓈᔅᑯᐦᒡ ᐋ ᐊᐱᑦ, ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐱᒥᐱᔨᑦ ᒌ ᐊᔨᒥᐦᑖᐤ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᑳ ᒥᓯᓂᐦᐋᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ᐋᒄ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ, “ᐹᔓᒡ ᓈᔥ ᐊᓐ ᑎᐦᑎᐱᑖᐹᓈᔅᑯᐦᒡ ᑳ ᐱᒥᐱᔨᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ᕕᓕᑉ ᑳ ᐄᔥᐱᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᐦ ᑖᔨᒡ᙮ ᑳ ᐹᐦᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋ ᐊᔨᒥᐦᑣᓱᔨᒡ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳ ᒥᓯᓂᐦᐋᒥᔨᒡ᙮ ᐋᒄ ᕕᓕᑉ ᑳᐦ ᐄᑖᑦ, “ᒌ ᓂᔅᑐᐦᑖᓐ ᐋ ᐊᓐ ᒥᓯᓂᐦᐄᑭᓐ ᑳ ᐊᔨᒥᐦᑖᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᑖᓂᑖ ᒑ ᒌ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒫᓐ ᐹᑎᔥ ᐊᐙᓐ ᐹᒋ ᒋᔅᑯᑎᒨᒑ?” ᐋᒄ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ ᒑ ᒌ ᐹᒋ ᐐᑎᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ᒌ ᐊᔨᒥᐦᑖᐤ ᒋᔖᒥᓂᑑᐦ ᐆᒋᐦᒋᒥᓯᓈᐦᐄᑭᓂᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ, ᒧᔮᒻ ᒫᓂᔥᒑᓂᔥ ᐋᐦᐋᑳ ᒋᔅᑐᑦ ᐋ ᓂᑑᓂᐱᐦᐋᑭᓅᑦ ᒌ ᐃᓯᓈᑯᓯᐤ, ᒧᔮᒻ ᐋ ᐊᐱᔒᔑᑦ ᒫᓂᔥᒑᓂᔥ ᐋᑳ ᑳ ᒋᔅᑐᑦ ᐋ ᒥᓂᑐᐙᔣᑭᓅᑦ, ᐋᔪᐎᒄ ᑳ ᐃᓯᓈᑯᓯᑦ, ᓂᒧᐃ ᐎᔮᔥ ᐅᐦᒋ ᐃᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ᒌ ᒫᔮᔨᒫᑭᓂᐤ, ᑭᔮᐦ ᓂᒧᐃ ᑯᐃᔅᒄ ᐅᐦᒋ ᐄᔑ ᑎᐹᔅᑯᓈᑭᓂᐤ᙮ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐃᔮᐙᐤ ᐊᐙᔑᔥ ᐙᔥ ᒋᑭ ᐴᓂᐱᔨᐤ ᐋ ᐱᒫᑎᓰᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᑳ ᐊᔨᒥᐦᑖᑦ ᐊᓐ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ ᐋᐦ ᐄᑖᑦ, “ᐹᒋ ᐐᐦᑎᒨ ᒫᐦ, ᐊᐙᔨᐤᐦ ᑳᐦ ᐋᔨᒨᒫᑦ ᐆ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ, ᐐᔨ ᐋ ᒌ ᐋᔨᒨᒥᓲ ᑭᔮᐦ ᒫᒃ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᑳᐦ ᐋᔨᒨᒫᒀ?” ");
INSERT INTO crl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ᐋᒄ ᕕᓕᑉ ᑳ ᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᒌᓴᔅᐦ ᐋᐦ ᐋᔨᒨᒥᑭᓂᐎᔨᒡ, ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᐦᑖᔨᒡ ᒋᔖᒥᓂᑑᐦ ᐆᒋᐦᒋᒥᓯᓈᐦᐄᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ᒫᒀᒡ ᒫᒃ ᐋᐦ ᐋᑎᐱᒥᐱᔨᐦᐋᑭᓂᐎᒡ ᑎᐦᑎᐱᑖᐹᓈᔅᑯᐦᒡ ᐊᓂᑎᐦ ᒫᔅᑭᓈᐦᒡ, ᒌ ᐅᑎᑎᐦᐋᒧᒡ ᐊᓂᑎᐦ ᐋᐦᑎᑯᓃᔨᒡ ᓂᐲᔨᐤ, ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐃᔨᑦ, “ᒫᓐ ᓂᐲ, ᒑᒀᓐ ᒑ ᒋᐱᐦᒋᐦᐄᑯᔮᓐ ᐋ ᓂᑎᐙᔨᐦᑎᒫᓐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑖᑭᐎᔮᓐ?” ");
INSERT INTO crl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ᕕᓕᑉ ᒌᐦ ᐄᑖᐤ, “ᑖᑆᐦ ᑎᔮᑆᔮᔨᒫᐅᑖ ᒌᓴᔅ, ᒋᑭ ᒌ ᓰᑭᐦᐋᐦᑖᑰᓐ᙮” ᐋᒄ ᐊᓐ ᓈᐹᐤ ᑳᐦ ᐃᔨᑦ, “ᓂᑖᑆᐦᑖᓐ ᒌᓴᔅ ᙭ ᐋᐦᐋᐎᑦ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ᐊᓐ ᒫᒃ ᓈᐹᐤ ᒌ ᐄᑎᔓᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐱᒥᐱᔨᐦᐄᑯᑦ ᒑ ᒌ ᒋᐱᐦᒋᐱᔨᔨᒡ᙮ ᐋᒄ ᑳ ᐐᒑᐙᑦ ᐊᓂᔮᔨᐤ ᕕᓕᑉ ᑳᐦ ᐋᑎᓃᐦᑎᒋᐙᒡ ᑳᐦ ᐋᑎᐱᑭᔥᑎᐙᐦᑖᔨᒡ᙮ ᐋᒄ ᕕᓕᑉ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ᐄᔥᐱᐦ ᒫᒃ ᑳᐹᒡ, ᕕᓕᑉ ᒌ ᐅᑎᓂᑰ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᐦᒑᐦᑯᔨᐤ᙮ ᓂᒧᐃ ᒫᒃ ᒦᓐ ᐅᐦᒋ ᐙᐱᒫᐤ ᐊᓐ ᓈᐹᐤ ᐊᓂᔮᔨᐤ ᕕᓕᑉ, ᑳᐦ ᐋᑎ ᒌᐙᑦ, ᐋ ᒨᒋᒑᔨᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ᕕᓕᑉ ᒫᒃ ᐊᓂᑖᐦ ᐊᔂᑐᓯᐦᒡ ᐃᐦᑖᐎᓂᒡ ᒌ ᐅᐦᒋ ᑖᐤ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᔂᑐᓯᐦᒡ ᑳ ᒋᐦᒋ ᐙᐐᐦᑎᐦᒃ ᒥᔻᒋᒧᐎᓂᔨᐤ ᑭᔮᐦ ᐊᓂᑖᐦ ᒥᓯᐙ ᑖᓂᑖᐦ ᑳᐦ ᐋᑎ ᐊᐄᑖᑦ ᐃᐦᑖᐎᓂᒡ ᐲᐦᐃᒻ ᑳ ᑎᑯᔑᐦᒃ ᓭᓵᕆᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ᔂᓪ ᒫᒃ ᐐᔨ ᐋᔥᒄ ᐋᔪᐎᒄ ᑳᐦ ᑎᒃ ᐋ ᐱᐹᑯᔅᑖᒋᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᐋᐦ ᐄᑖᑦ ᒑ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ᙮ ᒌ ᓂᑎᐙᐱᒫᐤ ᒫᒃ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔒᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ, ");
INSERT INTO crl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ᑳ ᓂᑐᑎᒧᐙᑦ ᒑ ᒌ ᒥᔨᑯᑦ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᒑ ᒌ ᐙᐱᐦᑏᔮᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔅᑳᒥᔨᒡ ᒎᐤ ᐋᔮᒥᐦᐋᐆᑭᒥᒄ ᐊᓂᑎᐦ ᑖᒫᔅᑭᔅ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᔨᒡ ᐋ ᐐᐦᑖᑯᓃᔨᒡ ᐊᓂᑎᐦ ᐋ ᒥᔮᑭᓅᑦ ᒑ ᒌ ᐅᑎᓈᑦ ᐃᔅᒀᐤ ᑭᔮᐦ ᓈᐹᐤ ᑳ ᑖᑆᐦᑎᒦᒡ ᒌᓴᔅᐦ ᐋᐦ ᐋᐐᔨᒡ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᑳᐤ ᒑ ᒌᐦᐙᐦᑎᐦᐋᑦ ᒋᐴᐦᐙᑭᓂᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ᒌ ᐄᑐᐦᑖᐤ ᒫᒃ ᐊᓂᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ, ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐹᔣᐱᐦᑎᐦᒃ, ᔑᔥᒋᑯᒡ ᓈᔥᒡ ᒌ ᐅᐦᒋ ᒋᑳᔮᔅᑖᔨᐤ ᐊᓂᑎᐦ ᐙᔅᑳ ᐋᐦ ᑖᑦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒋ ᐙᔥᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ᒌ ᐱᐦᒋᔑᓐ ᐊᔅᒌᐦᒡ, ᐋᒄ ᑳ ᐹᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᑎᑯᑦ, “ᔂᓪ, ᔂᓪ, ᒑᒀᓐ ᐙᐦᒋ ᓂᓈᐦᑳᒋᐦᐄᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ᐋᒄ ᔂᓪ ᑳᐦ ᐃᔨᑦ, “ᐊᐙᓐ ᒌᔨ ᑳ ᐹᒋ ᐊᔨᒥᐦᐄᔨᓐ, ᑎᐹᔨᐦᒋᒑᓯᐤ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ, “ᐋᐅᒄ ᓃᔨ ᒌᓴᔅ, ᐊᓐ ᑳ ᓂᓈᐦᑳᒋᐦᐄᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ᐱᓯᑰᐦ, ᒑ ᐄᑐᐦᑖᔨᓐ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᐋᑯᑖᐦ ᒑ ᐐᐦᑎᒫᑭᐎᔨᓐ ᑖᓐ ᒑ ᑎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ᐊᓂᒌ ᒫᒃ ᓈᐹᐅᒡ ᑳ ᐐᒑᐙᒡ ᔂ ᒌ ᒋᐱᐦᒋᑳᐳᐎᒡ ᒥᑐᓐ ᐋᐦᐋᑳ ᒋᔅᑑᒡ᙮ ᒌ ᐹᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ, ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐙᐱᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ᐋᒄ ᔂᓪ ᑳ ᐱᓯᑯᑦ, ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑑᐦᑳᐱᑦ, ᓂᒧᐃ ᐅᐦᒌ ᐙᐱᐦᑎᒻ᙮ ᐋᒄ ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᓯᒋᓂᔅᒑᐦᑎᐦᐋᒡ ᐋᐦ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᓂᒧᐃ ᐅᐦᒌ ᐙᐱᐦᑎᒻ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐃᔥᐱᔥ ᓂᒧᐃ ᐅᐦᒋ ᒦᒋᓲ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᒥᓂᐦᒀᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ᐊᓂᑖᐦ ᒫᒃ ᑖᒫᔅᑯᓯᐦᒡ ᒌᐦ ᑖᐤ ᓈᐹᐤ ᐋ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ, ᐋᓂᓈᔮᔅ ᒌ ᐃᔑᓂᐦᑳᓲ᙮ ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐊᔨᒥᐦᐄᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᐦ ᐄᑎᑯᑦ, “ᐋᓂᓈᔮᔅ᙮” ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐋᑯᑦ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᐱᓯᑰᐦ, ᒑ ᐄᑐᐦᑖᔨᓐ ᓈᑖᐦ ᒫᔅᑭᓂᐤ ᑳ ᑯᐃᔅᑯᒧᐦᒡ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒍᑖᔅ ᐅᐙᔅᑳᐦᐄᑭᓂᒦᐦᒡ ᒑ ᑯᒀᒋᐦᒑᔨᒧᔨᓐ ᐋ ᑖᒀ ᓈᐹᐤ ᔂᓪ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐊᓂᑖᐦ ᑖᕐᓯᔅ ᐋ ᐅᐦᒌᑦ᙮ ᐋᐅᒄ ᐅ ᔂᓪ ᒫᒀᒡ ᐊᔨᒥᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ᒌ ᐄᔑᓂᒻ ᑭᔮᐦ ᐋ ᐹᒋ ᐲᐦᒑᔨᒡ ᓈᐹᐤ ᐋᓂᓈᔮᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐋ ᑖᒋᓂᑯᑦ ᒦᓐ ᑳᐤ ᒑ ᒌ ᐙᐱᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ᐋᒄ ᒫᒃ ᐋᓂᓈᔮᔅ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᐦ ᐄᑖᑦ, “ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᓂᒌ ᐐᐦᑎᒫᑯᒡ ᐆ ᓈᐹᐤ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓂᓈᐦᑳᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ᑭᔮᐦ ᒫᒃ ᒌ ᐹᒋ ᐄᑐᐦᑖᐤ ᔂᓪ ᐅᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ, ᐋ ᒌ ᒥᔨᑯᑦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᒑ ᒌ ᐅᑎᓈᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒥᔅᒋᔨᔅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ᐋᒄ ᐋᓂᓈᔮᔅ ᑳᐦ ᐄᑎᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᐄᑐᐦᑖ ᐊᔮᐱᒡ, ᐙᔥ ᓂᒌ ᐎᔮᔨᒫᐤ ᔂᓪ ᒑ ᒌ ᐹᒋ ᐋᐱᑎᔒᔥᑑᑦ, ᑭᔮᐦ ᒑ ᒌ ᐹᒋ ᒋᔅᒑᔨᐦᑖᑯᐦᐄᑦ ᐊᓂᑖᐦ ᒎᐄᔨᔨᐤ ᐋᐦ ᑖᔨᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ, ᑭᔮᐦ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ᐙᔥ ᓃᔨ ᓂᑭ ᐙᐱᐦᑎᔮᐤ ᑖᓐ ᒑ ᐃᔥᐱᔥ ᓂᓈᐦᑳᑖᔨᒧᑦ ᓃᔨ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ᐋᒄ ᐋᓂᓈᔮᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ, ᑳ ᐲᐦᒑᑦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᐊᓂᑖᐦ ᑳᐦ ᐄᑎᔑᐦᐙᑭᓄᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᔂᓚ, ᐋᒄ ᑳ ᑖᒋᓈᑦ ᐋᐦ ᐄᑖᑦ, “ᓃᒋᔖᓐ ᔂᓪ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ, ᐊᓐ ᑳ ᓂᒋᔥᑳᔅᒃ ᓈᑖᐦ ᒫᔅᑭᓈᐦᒡ ᒫᒀᒡ ᑳ ᐹᒋ ᐄᑐᐦᑖᔨᓐ ᐅᑖᐦ᙮ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐆᒄ ᒦᓐ ᑳᐤ ᒑ ᒌ ᐙᐱᐦᑎᒥᓐ, ᑭᔮᐦ ᒑ ᒌ ᓵᑭᔅᒋᓈᔥᑳᔅᒃ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ᑏᐙᐦᒡ ᒫᒃ ᒧᔮᒻ ᓂᒫᔅ ᐅᐦᐋᑮᐦ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒑᒀᔨᐤ ᒌ ᐅᐦᒋ ᐹᐦᐱᐦᒋᔥᑎᓂᔨᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᔂᓪ ᐅᔥᒌᔑᑯᐦᒡ, ᐋᑯᑖᐦ ᒫᒃ ᒦᓐ ᑳᐤ ᑳ ᐅᐦᒋ ᐙᐱᐦᑎᐦᒃ᙮ ᒌ ᐱᓯᑰ ᐋᒄ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒦᒋᓱᑦ, ᐋᒄ ᒦᓐ ᑳᐦ ᐋᑎ ᒥᔅᑰᐱᒫᑎᓰᑦ᙮ ᐙᐃᐱᔥᒌᔥ ᒌ ᐐᒋᒫᐤ ᔂᓪ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐊᓂᑎᐦ ᑖᒫᔅᑯᓯᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋ ᑭᒑᔅᒀᑦ ᐋᐦ ᐃᔨᑦ, “ᒌᓴᔅ, ᐋᐅᒄ ᒋᔖᒥᓂᑑ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ᐊᓂᒌ ᑳ ᐹᐦᑎᐙᒡ, ᒌ ᒫᒥᔥᑳᑖᔨᐦᑎᒥᐦᐄᑯᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᐋᒄ ᑳᐦ ᐄᑎᑐᒡ, “ᓂᒧᐃ ᐋ ᐋᐅᒄ ᐆ ᓈᐹᐤ ᑳ ᓂᔑᐎᓈᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔨᒡ? ᓂᒥᔮᔨᐤ ᐋ ᐙᐦᒋ ᐹᒋ ᑎᑯᔑᐦᒃ ᐋ ᐐᐦ ᐹᒋ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᒑ ᒌ ᐅᑎᓈᑦ ᑭᔮᐦ ᒑ ᒌ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᐋᐦ ᑖᔨᒡ?” ");
INSERT INTO crl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ᔂᓪ ᒫᒃ ᐊᑎᑎᐤ ᒌ ᒑᔥᑎᓈᔑᑖᑯᓯᐤ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᑭᒑᔅᒀᑦ ᐋᐦ ᐋᔨᒨᒫᑦ ᒌᓴᔅᐦ ᑖᑆᐦ ᐋᐦ ᐋᐎᔨᒡ ᙭ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᔨᒡ ᒋᔖᒥᓂᑑ᙮ ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑖᒫᔅᑯᓯᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᐙᐙᓈᔨᐦᑎᒥᐦᐄᑯᒡ, ᓂᒧᐃ ᒥᑐᓐ ᒑᒀᔨᐤ ᐅᐦᒌ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ᐄᔥᐱᐦ ᒫᒃ ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᒫᔮᐅᐱᔨᔨᒡ ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓂᔥᑐᐐᒡ, ᑳ ᐎᔮᔨᐦᑎᐦᒡ ᒑ ᓂᐱᐦᐋᒡ ᔂᓚ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ᒥᒄ ᒫᒃ ᔂᓪ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐋᑭᓂᐤ ᑖᓐ ᐙᐦ ᑐᑎᐙᑭᓅᑦ᙮ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᑭᔮᐦ ᐋᔑᑯᒻ ᑎᐱᔅᑳᐤ ᒌ ᓈᓈᑭᒋᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᒑ ᒌ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ᐹᔨᒀᐤ ᒫᒃ ᐋ ᑎᐱᔅᑳᔨᒡ ᔂᓪ ᐅᐐᒑᐙᑭᓐᐦ ᒌ ᐐᒋᐦᐄᑰ ᒑ ᒌ ᐅᔑᒧᑦ ᐊᓂᑎᐦ ᐅᐦᒋ ᑖᒫᔅᑯᓯᐦᒡ᙮ ᐋ ᐱᑯᓈᔮᔨᒡ ᐋ ᔮᐃᐦᑎᑳᔨᒡ ᒌ ᐅᐦᒋ ᔮᓵᐱᐦᒑᓈᑭᓂᐤ ᐅᑎᐲᐅᐎᑎᐦᒡ ᐋ ᐲᒋᔑᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ᔂᓪ ᒫᒃ ᑳᐤ ᒌ ᒌᔨᐙᐤ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐋᒄ ᑳ ᐐᐦ ᐱᐹᐐᒑᐙᑦ ᐊᓂᔮᔨᐤ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓐ ᐋ ᓂᑎᐙᔨᒫᑦ ᒑ ᒌ ᑖᑆᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐐᔨ ᐋ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᐦᑎᒥᔨᐤ ᐋ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ, ᒥᓯᐙ ᒌ ᑯᔥᑎᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ᐹᕐᓂᐱᔅ ᒫᒃ ᒌ ᐐᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᔂᓚ, ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋᐦ ᑖᔨᒡ᙮ ᑳ ᐐᐦᑎᒧᐙᑦ ᑖᓐ ᑳ ᐄᔑ ᓅᑯᓰᔥᑖᑯᔨᒡ ᔂᓚ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ, ᑭᔮᐦ ᐋ ᒌ ᐊᔨᒥᐦᐄᑯᔨᒡ᙮ ᑭᔮᐦ ᒌ ᐐᐦᑎᒧᐙᐤ ᑖᓐ ᑳ ᐄᔑ ᑭᒑᔅᒀᔨᒡ ᔂᓚ ᐊᓂᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ, ᐋᐦᐋᑳ ᒥᑐᓐ ᐅᐦᒋ ᑯᔥᑖᒋᔨᒡ, ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ᐋᑯᑖᐦ ᒫᒃ ᑳᐦ ᑖᑦ ᔂᓪ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋᐦ ᑖᔨᒡ᙮ ᒥᓯᐙ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᑭᒑᔅᒀᑦ ᐋᐦ ᐋᔨᒨᒫᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐋᐦᐋᑳ ᑯᔥᑖᒋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ᒌ ᐊᔨᒥᐦᐋᐤ ᑭᔮᐦ ᒌ ᓂᓈᔅᒀᐅᔑᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᒃᕇᒃ ᑳ ᐄᔑ ᐊᔨᒦᒡ ᒑ ᒌ ᑖᑆᔮᔨᒫᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ, ᒥᒄ ᒫᒃ ᒋᐐᐦ ᓂᐱᐦᐄᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐐᒋᔖᓂᒫᐅᒡ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᐊᓂᑖᐦ ᓭᓯᕇᔮᐦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐄᑐᐦᑎᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᔂᓚ, ᐋᒄ ᐊᓂᑖᐦ ᑖᕐᓯᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐄᑎᔑᐦᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ᐊᓂᒌ ᒫᒃ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᒥᓯᐙ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌ, ᒎᑏᔮ ᑭᔮᐦ ᑳᓕᓖ ᑭᔮᐦ ᓵᒫᕆᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᑳᐦ ᑖᒡ, ᐙᐃᐱᔥᒌᔥ ᑳ ᐃᔮᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᓂᒧᐃ ᐅᐦᒋ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ᙮ ᒌ ᒋᔅᑖᔨᒫᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒌ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᔮᐃᒋᑳᐳᐎᒡ ᑭᔮᐦ ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᒥᐦᒑᑑᒡ ᐙᔥ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᐐᒋᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ᐲᑎᕐ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᒌ ᐄᑐᐦᑖᐤ᙮ ᐋᒄ ᒫᒃ ᐹᔨᒀᐤ ᐋ ᓂᑑᒧᐎᑎᐦᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᓕᑖᐦᒡ ᑳᐦ ᑖᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ᐋᑯᑖᐦ ᑳ ᐙᐱᒫᑦ ᓈᐹᐤ ᐁᓀᔮᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐋᐦᐋᑳ ᐅᐦᒋ ᒌ ᐋᐦᑎᓂᓲᔨᒡ, ᓂᔮᓈᓈᐤ ᑎᐦᑐ ᐱᐳᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᐋᒥᔨᒡ ᐅᓂᐹᐎᓃᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐁᓀᔮᔅ, ᒌᓴᔅ ᙭ ᒌ ᒦᓂᐙᒋᐦᐄᒄ, ᐎᓂᔥᑳ, ᒑ ᐅᑎᓂᒥᓐ ᒋᑎᔥᐱᔑᒧᓐ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐎᓂᔥᑳᐤ ᐁᓀᔮᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ᒥᓯᐙ ᒫᒃ ᐄᔨᔨᐤ ᑳ ᑎᔑᔨᒡ ᐊᓂᑎᐦ ᓕᑖᐦᒡ ᑭᔮᐦ ᔖᕎᓂᐦᒡ ᒌ ᐙᐱᒥᑰ ᐋ ᐱᐹᒧᐦᑖᑦ, ᐋᒄ ᒫᒃ ᑳᐦ ᐋᑎ ᑖᑆᔮᔨᒫᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒞᐹ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒌᐦ ᑖᐤ ᐃᔅᒀᐤ ᐋ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ, ᑖᐱᑖ ᐋ ᒌ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᐆ ᒫᒃ ᐃᔑᓂᐦᑳᓱᐎᓐ ᑖᕐᑭᔅ, ᒃᕇᒃ ᐋ ᐄᔑ ᐊᔨᒥᓈᓅᒡ ᐆ᙮ ᒨᔥ ᒌ ᒥᔪᑐᑎᐙᐤ ᐊᐙᔨᐤᐦ ᐊᓐ ᐃᔅᒀᐤ ᑭᔮᐦ ᒌ ᐐᒋᐦᐋᐤ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ᒫᒀᒡ ᒫᒃ ᐲᑎᕐ ᐋᐦ ᑖᑦ ᐊᓂᑎᐦ ᓕᑖᐦᒡ, ᓈᔥᑖᑆᐦ ᒌ ᐋᑯᓯᐤ ᐊᓐ ᐃᔅᒀᐤ, ᒑᒃ ᒫᒃ ᒌ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᐐᔨᐤ ᒫᒃ ᒌ ᒋᔥᑖᐹᐅᑖᑭᓂᐎᔨᐤ, ᐋᒄ ᐃᔥᐱᒥᐦᒡ ᐋᐱᑎᐙᔨᒡ ᑳ ᐊᔥᑖᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ᒌ ᐹᔓᓈᑯᓐ ᒫᒃ ᒞᐹ ᐊᓂᑖᐦ ᓕᑖᐦᒡ ᐅᐦᒋ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ ᐲᑎᕐ ᐊᓂᑖᐦ ᓕᑖᐦᒡ, ᓃᔓ ᓈᐹᐤ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᑖᐦ ᒑ ᒌ ᓂᑑᒫᔨᒡ ᐲᑎᕐ ᑏᐙᐦᒡ ᒑ ᒌ ᐹᒋ ᑎᑯᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ᐲᑎᕐ ᑳ ᐱᓯᑯᑦ, ᑳ ᐐᒑᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᓈᑖᐦ, ᒌ ᐄᑐᐦᑎᐦᐋᑭᓂᐤ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᐊᓂᑖᐦ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒥᔮᔨᐤ᙮ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐃᔅᒀᐅᒡ ᐋ ᐹᔨᑯᒡ, ᒌ ᒫᐅᓯᑯᑳᐳᔥᑎᐙᐅᒡ ᐲᑎᕐ ᐋ ᒫᑑᒡ ᑭᔮᐦ ᐋ ᐙᐱᐦᑎᔮᒡ ᐱᒋᐎᔮᓐ ᑭᔮᐦ ᐊᑯᐦᑉ ᐋ ᒌ ᐅᔑᑎᒫᑯᐙᑯᐱᓈ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᑖᐲᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ᐲᑎᕐ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒌ ᐎᔨᐐᑎᔑᐦᐋᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᓂᐹᐅᑭᒥᑯᔨᐤ ᑳᐦ ᑖᔨᒡ, ᐋᒄ ᑳ ᓃᐱᔅᑰᐱᑦ ᐋ ᐊᔨᒥᐦᐋᑦ, ᐋᒄ ᑳ ᑭᓂᐙᐱᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᒥᔮᔨᐤ ᐋᐦ ᐃᔨᑦ, “ᑖᐲᑖ, ᐎᓂᔥᑳ᙮” ᒌ ᐋᐱᐦᐊᒻ ᒫᒃ ᐅᔥᒌᔑᒄ ᐊᓐ ᐃᔅᒀᐤ, ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐲᑎᕐ, ᒌ ᐅᐦᒋ ᓯᒥᑎᐱᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ᐲᑎᕐ ᒫᒃ ᒌ ᔑᐎᓂᔅᒑᔨᔥᑎᐙᐤ ᑳ ᐐᒋᐦᐋᑦ ᐋ ᐎᓂᔥᑳᓂᓱᔨᒡ᙮ ᐋᒄ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᐹᔨᑯᔨᒡ ᐃᔅᒀᐤ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᐙᔨᐤᐦ, ᑳ ᐙᐱᐦᑏᔮᑦ ᒦᓐ ᐋ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑖᐲᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ᒥᓯᐙ ᒫᒃ ᐊᓂᑎᐦ ᒞᐹᐦᒡ ᒌ ᒥᔑᐦᑖᐱᔨᐤ ᑎᐹᒋᒧᐎᓐ ᐆ ᑳ ᐄᔅᐱᔨᒡ᙮ ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ᓈᐅᓵᔥ ᒫᒃ ᒌᐦ ᑖᐤ ᐲᑎᕐ ᐊᓂᑎᐦ ᒞᐹᐦᒡ, ᐊᓂᔮᔨᐤ ᒌ ᐐᒋᒫᐤ ᑳ ᒌᔑᓂᒑᑦᐦ ᓵᐃᒥᓐᐦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ᒌᐦ ᑖᐤ ᓈᐹᐤ ᒀᕐᓃᓖᔪᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᓭᓯᕇᔮᐦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᐋᐦ ᐄᑖᐱᑎᓰᑦ ᐋ ᓃᑳᓂᔥᑭᐙᑦ ᓂᑐᐱᔨᐤ ᐊᓂᑖᐦ ᐃᑎᓖ ᐊᔅᒌᐦᒡ ᐋ ᐅᐦᒌᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ᒌ ᐊᔨᒥᐦᐋᐙᑎᓯᐤ ᑭᔮᐦ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒫᒃ ᐊᓂᑎᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐋ ᐹᔨᑯᑖᐅᓰᑦ᙮ ᒥᔥᑏᐦ ᒫᒃ ᒌ ᐐᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᒎᐄᔨᔨᐤ᙮ ᑭᔮᐦ ᒨᔥ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ᐹᔨᒀᐤ ᐋ ᐃᔥᒀᐱᐦᑖᒌᔒᑳᔨᒡ ᐎᔮᔥ ᓂᔥᑐ ᐋᐦ ᐄᔅᐱᔨᔨᒡ, ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ, ᒥᑐᓐ ᐋ ᒌ ᐙᐱᒫᑦ ᒋᔖᒥᓂᑑᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᐋ ᐹᒋ ᐲᐦᒑᔨᒡ, ᐋᐦ ᐄᑎᑯᑦ ᒫᒃ, “ᒀᕐᓃᓖᔪᔅ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ᒌ ᒥᔅᑳᓯᓂᐙᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᐋ ᓵᒋᓯᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ, ᑎᐹᔨᐦᒋᒑᓯᐤ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᒋᔖᒥᓂᑑ ᒌ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑰ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᔨᓐ, ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒥᔪ ᐐᒋᐦᐄᑣᐤ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ, ᓂᒧᐃ ᒫᒃ ᒋᑭ ᐅᐦᒋ ᐎᓂᒌᔅᒌᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ᐄᑎᔑᐦᐅᒡ ᒫᒃ ᓈᐹᐅᒡ ᐊᓂᑖᐦ ᒞᐹᐦᒡ ᒑ ᒌ ᓂᑐᒫᒡ ᓵᐃᒥᓐ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ᐊᓂᑖᐦ ᑖᐤ ᐊᓂᔮᔨᐤ ᑳ ᒌᔑᓂᒑᑦ ᓵᐃᒥᓐ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐹᔓᒡ ᔑᔓᒡ ᒋᐦᒋᑭᒦᐦᒡ ᑳ ᐐᒋᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ᐄᔥᐱᐦ ᒫᒃ ᐋᑳ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᑳ ᐊᔨᒥᐦᐄᑯᑦ ᐋᒄ ᒀᕐᓃᓖᔪᔅ ᑳ ᓂᑑᒫᑦ ᓃᔓ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ, ᑭᔮᐦ ᐹᔨᒄ ᓂᑐᐱᔨᐤ ᐋ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᒨᔥ ᑳ ᒌ ᓂᓈᑭᑎᐙᔨᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ᒀᕐᓃᓖᔪᔅ ᑳ ᐐᐦᑎᒧᐙᑦ ᒥᓯᐙ ᑖᓐ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᔑᐦᐙᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒞᐹ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ ᐎᔮᔥ ᐋᐦ ᐋᐱᐦᑖᒌᔑᑳᔨᒡ ᐋᒄ ᒌ ᐹᔣᐱᐦᑎᒧᒑᓂᒋ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒞᐹ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐎᔮᔥ ᑳ ᓂᑐᐊᔨᒥᐦᐋᑦ ᐲᑎᕐ ᑎᐦᑯᐦᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ᒑᒃ ᒫᒃ ᒌ ᔒᐅᑖᐤ ᐋᒄ ᑳ ᐐᐦ ᒦᒋᑦ ᒑᒀᔨᐤ, ᒫᒀᒡ ᒫᒃ ᐋ ᐃᔥᐱᔒᓈᓂᐎᔨᒡ ᐋ ᐱᒥᓅᑖᑭᓅᑦ ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ᒌ ᐙᐱᐦᑎᒻ ᒌᔑᑯᔨᐤ ᐋᐦ ᐋᐱᐦᐄᐱᔨᔨᒡ, ᐋᒄ ᑳ ᐙᐱᐦᑎᐦᒃ ᒑᒀᔨᐤ ᒧᔮᒻ ᐋᒥᓵᑭᓃᔨᒡ ᐊᔥᐱᒦᒋᓱᓈᒋᓂᐦᒡ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᑖᐦ ᐋ ᓈᐆᓃᔨᒡ ᐋ ᑭᒌᐦᒑᔮᑭᓃᔨᒡ ᐋ ᐅᐦᒋ ᐹᒋ ᔮᔑᓂᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᐄᔑ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ᐊᓂᑎᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐹᒋ ᔮᔑᓂᑭᓂᐎᔨᒡ ᓂᓈᐦᑭᐤ ᐊᐅᐦᑳᓐ ᐋ ᐃᓯᓈᑯᓰᔨᒡ ᑭᔮᐦ ᐊᒋᓈᐱᒄ ᑭᔮᐦ ᐱᔮᔒᔥ ᒌᐦ ᑖᔨᐤ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ᐋᒄ ᑳ ᐅᐦᒋ ᐹᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᑎᑯᑦ, “ᐲᑎᕐ, ᐱᓯᑰᐦ, ᒑ ᓂᐱᐦᑖᒑᔨᓐ, ᒑ ᒦᒋᓱᔨᓐ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᑐᑖᓐ ᐆ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᓂᒧᐃ ᓂᐦᑖ ᓅᐦᒋ ᒦᒋᓐ ᒑᒀᓐ ᐋᐦᐋᑳ ᒦᒋᓈᓂᐎᒡ ᑭᔮᐦ ᐋ ᐐᓈᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ᐋᒄ ᒦᓐ ᑳ ᐅᐦᒋ ᐹᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋᐦ ᐄᑎᑯᑦ, “ᐊᑳᐐ ᐃᔨᐦ ᐋ ᐐᓈᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐃᔨᑦ ᐋ ᐱᔮᐦᑭᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ᓂᔥᑣᐤ ᒫᒃ ᒌ ᐄᑎᐦᑎᒻ ᐋ ᐹᐦᑎᐙᑦ ᐊᐙᔨᐤᐦ ᐋ ᐊᔨᒥᐦᐄᑯᑦ, ᐋᒄ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᔥᐱᒦᒋᓱᓈᒋᓂᒡ ᑳ ᐃᓯᓈᑯᓃᔨᒡ ᒦᓐ ᑳᐤ ᒌ ᐅᐦᐱᐱᔨᔨᐤ ᐊᓂᑖᐦ ᐄᔑ ᐃᔥᐱᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ᒫᒀᒡ ᒫᒃ ᐲᑎᕐ ᐋ ᒫᒥᑐᓈᔨᐦᑎᐦᒃ ᑖᓐ ᐊᔥᒋᔣᒥᑭᓃᔨᒡ ᐅᔮᔨᐤ ᑳ ᐙᐱᐦᑎᔮᑭᓅᑦ, ᐊᓂᒌ ᓈᐹᐅᒡ ᒀᕐᓃᓖᔪᔅ ᑳ ᐹᒋ ᐄᑎᔓᐦᐅᑯᒡ ᒌ ᒥᔅᑭᒸᐅᒡ ᓵᐃᒥᓐ ᑳ ᒌᔑᓂᒑᔨᒡ ᐊᓂᑎᐦ ᐙᒋᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᑳ ᐹᒋ ᓃᐴᐎᒡ, ");
INSERT INTO crl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ᑳ ᑖᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᐋᑯᑖᐦ ᐋ ᐅᑎᐦ ᐋᐦ ᑖᑦ ᓵᐃᒥᓐ ᐲᑎᕐ?” ");
INSERT INTO crl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ᐲᑎᕐ ᒫᒃ ᐋᔥᒄ ᒫᒀᒡ ᒌ ᒫᒥᑐᓈᔨᐦᑎᒻ ᑖᓂᑖᐦ ᐋᔥᒋᔣᒥᑭᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐙᐱᐦᑎᔮᑭᓅᑦ᙮ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, “ᓂᑑᐦᑎ ᒫᐦ, ᓂᔥᑑᒡ ᐅᑎᐦ ᓈᐹᐅᒡ ᐋ ᐹᒋ ᓈᓂᑎᐙᔨᒥᔅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ᒫᒌᐦ ᓃᐦᑖᐦᑎᐐᐦ ᒑ ᓂᑑᐃᔮᔅᑭᐎᔨᓐ, ᑭᔮᐦ ᐊᑳᐐ ᐅᐦᒋ ᓅᒋᔨ ᒑ ᒌ ᐐᒑᐅᑣᐤ᙮ ᐙᔥ ᓃᔨ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐙᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ᐋᒄ ᐲᑎᕐ ᑳ ᓃᐦᑖᐦᑎᐐᑦ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᐋᐅᒄ ᓃᔨ ᐃᔮᐎᔮᓐ ᑳ ᓈᓂᑐᐙᐱᒥᔮᒄ᙮ ᒑᒀᓐ ᒫᒃ ᐆ ᐙᐦᒋ ᑎᑯᔑᓂᔮᒄ?” ");
INSERT INTO crl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ᒌ ᐄᑖᐅᒡ ᒫᒃ, “ᓅᒋᒫᒥᓈᓐ ᒀᕐᓃᓖᔪᔅ ᑳ ᓃᑳᓂᔥᑭᐙᑦ ᕎᒻ ᓂᑐᐱᔨᐤ ᓂᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᓈᓐ᙮ ᑰᐃᔅᑯᑖᑎᓯᐤ ᐆ ᓈᐹᐤ, ᑭᔮᐦ ᒋᔥᑖᔨᒫᐤ ᒋᔖᒥᓂᑑ, ᒥᓯᐙ ᑭᔮᐦ ᒎᐄᔨᔨᐤ ᐄᑖᔨᒥᑰ ᐋ ᒥᔻᔨᐦᑖᑯᓯᑦ᙮ ᐹᔨᒄ ᒋᔖᒥᓂᑑᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᒌ ᐄᑎᑰ ᒑ ᒌ ᓂᑑᒥᔅᒃ ᐊᓂᑖᐦ ᐐᒋᐦᒡ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐹᐦᑎᐦᒃ ᑖᓐ ᐙᐦ ᐄᔑ ᐐᐦᑎᒧᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ᐋᒄ ᒫᒃ ᐲᑎᕐ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᒑ ᒌᐦ ᑖᔨᒡ ᐱᑦ ᐊᓂᑎᐦ ᐲᐦᑎᑭᒥᐦᒡ᙮ ᒦᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳᔑᑳᔨᒡ ᐋᒄ ᑳ ᐃᔮᔅᑭᐐᑦ ᒑ ᐐᒑᐙᑦ, ᑭᔮᐦ ᒫᒃ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐤ ᐐᒋᔖᓂᒫᐤ ᐊᓂᑎᐦ ᒞᐹᐦᒡ ᑳ ᐅᐦᒌᔨᒡ ᒌ ᐐᒑᐅᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ᒦᓐ ᐎᔮᐱᓃᔨᒡ ᐋᒄ ᑳ ᑎᑯᔑᐦᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᓭᓯᕇᔮᐦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐊᓯᓂᐙᐦᐄᑯᐙᐙᑯᐱᓈᓂᒌ ᒀᕐᓃᓕᔭᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓂᑑᒫᔨᒡ ᐅᐙᐦᑯᒫᑭᓂᔨᐤ ᑭᔮᐦ ᐅᐐᒑᐙᑭᓂᔨᐤ ᒑ ᒌ ᓂᑐᐦᑎᐙᔨᒡ ᐲᑎᕐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᐋᐦ ᐋᑎ ᐲᐦᒑᐙᑦ ᒀᕐᓃᓕᔭᔅ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᐤ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑰ, ᐋ ᓃᐱᔅᑰᐱᔨᐦᐅᔨᒡ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᑦ ᐋ ᐊᔨᒥᐦᐋᔅᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ᒥᒄ ᒫᒃ ᐲᑎᕐ ᒌ ᐱᓯᑰᓈᐤ ᐋᐦ ᐄᑖᑦ, “ᐱᓯᑰᐦ, ᒥᒄ ᐙᔥ ᓈᐹᐤ ᑭᔮᐦ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ᒌ ᐊᔨᒥᐦᐋᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᒀᕐᓃᓕᔭᔅ ᐋᐦ ᐋᑎ ᐲᐦᒑᒡ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᑳ ᐙᐱᒫᑦ ᒥᐦᒑᑐ ᐄᔨᔨᐤ ᐋ ᒌ ᒫᐅᓯᑯᔨᐙᐙᑭᐱᓈ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᒋᑭ ᐋᔨᒨᑎᒫᑎᓈᐙᐤ ᒑᒀᓐ᙮ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐅᓯᓂᐦᐄᑭᓂᐦᒡ ᐋᐦ ᐄᑎᔥᑖᒡ, ᐊᐙᓐ ᐋ ᒎᐐᔨᔨᐎᑦ ᐋᑳ ᒑ ᒌ ᒧᐎᑎᐦᑖᑦ ᐊᐙᔨᐤᐦ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᐅᐐᒑᐙᑭᓂᑐᑎᐙᑦ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᓂᒌᐙᐱᐦᑎᔨᒄ ᐋᑳ ᒑ ᒌ ᐋᑎᐙᔨᒥᒃ ᐊᐙᓐ, ᒑ ᒌ ᐄᑖᔨᒥᒃ ᐋᐦᐋᑳ ᐱᔮᐦᒋᓰᑦ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᒋᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ᑳ ᐹᒋ ᓂᑑᒥᔮᒄ ᒫᒃ, ᓂᒧᐃ ᓅᐦᒋ ᑏᓐ ᒑᐦ ᐋᑳ ᐐᐦ ᐹᒋ ᐄᑐᐦᑖᓐ ᐙᔥ ᑏᐙᐦᒡ ᓂᒌ ᓂᔅᑐᐦᑖᓐ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᑎᔨᑭᐎᔮᓐ, ᐋᒄ ᒫᒃ ᑳ ᐹᒋ ᑎᑯᔑᓂᔮᓐ᙮ ᐋᒄ ᒫᒃ ᐙᐦ ᒋᔅᒑᔨᐦᑎᒫᓐ, ᒑᒀᓐ ᐙᐦᒋ ᐹᒋ ᓂᑑᒥᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","ᐋᒄ ᒀᕐᓃᓖᔪᔅ ᑳᐦ ᐄᑖᑦ, “ᓈᐤ ᒌᔑᑳᐤᐦ ᐅᑖᐦᒡ ᐅᑎᐦ ᐋᐅᒄ ᐋᓐ ᐙᐎᔓᐙ ᒌ ᐃᔥᐱᔥ ᒌᔑᑳᒑ ᐋ ᒌ ᐊᔨᒥᐦᐋᔮᓐ ᐊᓂᑖᐦ ᓃᒋᐦᒡ ᓂᔥᑐ ᐋᐦ ᐄᔅᐱᔨᒡ ᐋᐦ ᐄᔥᒀᐱᐦᑖᒌᔑᑳᒡ᙮ ᒑᒃ ᔑᔥᒋᑯᒡ ᓈᐹᐤ ᐋ ᐙᔥᑖᔨᒡ ᐅᒑᒀᓂᒻ ᒌ ᐅᐦᒋ ᓃᐴ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ᐋᒄ ᑳ ᐄᔑᑦ, ‘ᒀᕐᓃᓕᔪᔅ, ᒋᔖᒥᓂᑑ ᒌ ᐹᐦᑎᒻ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᔨᓐ ᑭᔮᐦ ᒌ ᐙᐱᐦᑎᒻ ᑖᓐ ᑳ ᐄᔑ ᐐᒋᐦᐄᑣᐤ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ᐋᒄ ᒦᓐ ᑳ ᐄᔑᑦ, ‘ᐄᑎᔑᐦᐅᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒞᐹ ᒑ ᒌ ᓂᑐᒫᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᐊᓂᑖᐦ ᑖᐤ ᓵᐃᒥᓐ ᐋᐦ ᑖᔨᒡ ᐊᓐ ᑳ ᒌᔑᓂᒑᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᐊᓂᑖᐦ ᔑᔓᒡ ᒋᐦᒋᑭᒦᐦᒡ ᑳ ᐐᒋᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ᑏᐙᐦᒡ ᒫᒃ ᓂᒌᐦ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᒑ ᒌ ᓂᑑᒥᔅᒡ, ᒥᔪᔑᔔ ᒫᒃ ᑳ ᑎᑯᔑᓃᔨᓐ᙮ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐋᐦ ᑖᔨᐦᒄ ᐅᑎᐦ, ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᐋᑯᑖᐦ ᐋᐦ ᑖᑦ, ᐋᒄ ᒫᒃ ᒑ ᐹᐦᑎᒫᐦᒡ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᔅᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᔨᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ᐋᒄ ᒫᒃ ᐲᑎᕐ ᑳᐦ ᐄᑖᑦ, “ᐋᒄ ᒫᒃ ᓈᔅᑐᐦᑎᒫᓐ ᒋᔖᒥᓂᑑ ᐹᔨᑯᓂᐦᒡ ᒥᓯᐙ ᐋᐦ ᐄᑖᔨᒫᑦ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ᓂᒧᐃ ᐎᔮᔑᓂᔨᐤ ᑖᓐ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ᙮ ᐙᔥ ᐊᓐ ᐊᐙᓐ ᑳ ᒋᔅᑖᔨᐦᑖᑰᐦᐋᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᑳᐦ ᑐᑎᐦᒃ ᑖᓐ ᐋ ᐄᔑ ᑯᐃᔅᑯᓈᑯᓃᔨᒡ, ᐋᐅᒄ ᐊᓐ ᒑ ᓂᐦᐋᔨᑎᒥᐦᐋᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᑎᑯᓃᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ, ᐋ ᒌ ᐐᐦᑎᒧᐙᑦ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᔨᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᒌᓴᔅᐦ ᙭ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ᙮ ᐙᔥ ᐐᔨ ᒌᓴᔅ ᒥᓯᐙ ᐃᔮᐤ ᑎᐹᔨᐦᒋᒑᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔅᐱᔨᒡ ᒥᓯᐙ ᐊᓂᑖᐦ ᐃᔅᕋᐄᓪ ᐊᔅᒌᐦᒡ᙮ ᐊᓂᑖᐦ ᑳᓕᓖᐦᒡ ᒌ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐤ ᐆ ᐄᔥᐱᐦ ᒞᓐ ᑳ ᓰᑭᐦᐋᐦᑖᒑᑦ ᑳ ᑭᒑᔅᒀᑦ ᐋᐦ ᐄᑖᑦ ᐄᔨᔨᐤ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ᒋᒌ ᐹᐦᑖᓈᐙᐤ ᒌᓴᔅ ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ ᑳ ᐅᐙᔮᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᐋ ᒌ ᒥᔨᑯᑦ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ᒥᒄ ᑖᓂᑖᐦ ᑳᐦ ᐋᑎ ᐃᔨᐦᑖᑦ ᒌ ᒥᔪᑐᑎᒫᒑᐤ ᑭᔮᐦ ᒌ ᒦᓂᐙᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒥᒋᒥᓂᑑ ᑳ ᓂᓈᐦᑳᒋᐦᐄᑯᔨᒡ ᐙᔥ ᒨᔥ ᒌ ᐐᒑᐅᑰ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ᓂᑎᐹᑐᑖᓈᓐ ᒥᓯᐙ, ᐙᔥ ᓃᔮᓐ ᑎᐱᔨᐙ ᓂᔅᒌᔑᑯᓈᐦᒡ ᓂᒌᐙᐱᐦᑖᓈᓐ ᑖᓐ ᑳᐦ ᑎᒃ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒉᕉᓯᓕᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᑯᑎᒃ ᐃᐦᑖᐎᓐ ᑳᐦ ᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᔅᒌᔨᐤ᙮ ᒌ ᓂᐱᐦᐋᑭᓂᐤ ᒫᒃ ᐋ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᐎᓂᔥᑳᓂᑰ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᑳ ᓂᔥᑐᒌᔒᑳᔨᒡ, ᐋᒄ ᑳᐦ ᑐᑎᐙᑦ ᒑ ᒌ ᓅᑯᐦᐄᓱᔨᒡ ᒦᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ᓂᒧᐃ ᑭᔨᑆ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᓅᑯᓰᔥᑎᐙᐤ ᒌᓴᔅ, ᒥᒄ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒥᑯᔨᒡ ᒑ ᒌ ᑎᐹᒋᒥᑯᑦ᙮ ᑭᔮᐦ ᓂᒌ ᐐᒋᒦᒋᓲᒫᓈᓐ ᐹᑎᒫ ᑳ ᐎᓂᔥᑳᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᔓᒥᔨᒥᐦᑦ ᒌᓴᔅ ᒑ ᒌ ᐙᐐᐦᑎᒫᒥᒋᐦᒡ ᐄᔨᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᑭᔮᐦ ᒑ ᒌ ᐐᐦᑎᒨᒋᐦᒡ ᐄᔨᔨᐅᒡ ᐐᔨ ᒌᓴᔅ ᐋ ᒌ ᐅᐙᔮᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᑎᐹᔅᑯᓈᑦ ᐊᐙᔨᐤᐦ ᑳ ᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ᒌ ᑎᐹᒋᒥᑰ ᒥᓯᐙ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐄᔨᔨᒡ, ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᑆᐦᑎᐦᒃ ᒋᑭ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ ᐅᒥᒋᐦᑣᐎᓐ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ᒫᒀᒡ ᒫᒃ ᐲᑎᕐ ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᐹᒋ ᔮᔑᔨᐤ ᐊᓂᑎᐦ ᐊᓂᒌ ᒥᓯᐙ ᑳ ᓂᑐᐦᑎᐦᒡ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᑖᑆᐦᑎᐦᒡ, ᐊᓂᒌ ᑳ ᐹᒋ ᐐᒑᐙᒡ ᐲᑎᕐ, ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ ᒋᔖᒥᓂᑑ ᐋ ᒥᔮᔨᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐋ ᒌ ᒥᔮᑭᓂᐎᔨᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᐙᔥ ᒌ ᐹᐦᑎᐙᐅᒡ ᐋ ᒀᔅᒡ ᐊᔨᒥᔨᒡ ᑭᔮᐦ ᐋ ᒫᒥᐦᒋᒫᔨᒡ ᒋᔖᒥᓂᑑ᙮ ᐋᒄ ᐲᑎᕐ ᑳᐦ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ᐅᒌ ᐄᔨᔨᐅᒡ ᒌ ᒥᔮᑭᓂᐎᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒸᐦᒡ ᑭᔮᐦ ᒌᔮᓂᐤ ᑳ ᐄᔑ ᒥᔨᑯᐎᔨᐦᒄ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᐊᐙᓐ ᒋᐱᐦ ᐅᐦᒋ ᒋᐱᐦᒋᐦᐋᐤ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᔨᒡ ᓂᐲᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ᒌ ᐄᑎᔑᐦᐙᐤ ᒫᒃ ᐲᑎᕐ ᒑ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᔨᒡ ᐅᔮᔨᐤ ᒌᓴᔅ ᙭ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ᙮ ᐅᒌ ᒫᒃ ᑳ ᑖᑆᐦᑎᐦᒡ ᒌ ᑯᒀᒋᒫᐅᒡ ᐲᑎᕐ ᐙᐃᐱᔥᒌᔥ ᒦᓐ ᒑ ᒌᐦ ᑖᔨᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᐦᑖᐦᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᔅᒌᔨᐤ ᑳᐦ ᑖᒡ ᒌ ᐹᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋ ᑖᑆᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᑳ ᑎᑯᔑᐦᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒌ ᐊᔨᒥᐦᐄᑰ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦᐋᑳ ᓂᐦᐋᔨᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᑳᐦ ᐋ ᐃᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤᐦ ᐲᑎᕐᐦ, “ᒋᒌ ᐄᑐᐦᑖᓐ ᐊᓂᑖᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ, ᐙᐙᒡ ᑭᔮᐦ ᒋᒌ ᐐᒋᒦᒋᓲᒫᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ᐋᒄ ᐲᑎᕐ ᑳ ᐐᐦᑎᒧᐙᑦ ᒥᓯᐙ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐹᒋ ᐄᔅᐱᔨᔨᒡ, ᐋᐦ ᐄᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ᒫᒀᒡ ᑳ ᐊᔨᒥᐦᐋᔮᓐ ᐊᓂᑖᐦ ᒞᐹᐦᒡ, ᓂᒌᐙᐱᐦᑎᔨᑭᐎᓐ ᐙᐱᐦᑏᐙᐎᓐ᙮ ᓂᒌᐙᐱᐦᑖᓐ ᒑᒀᓐ ᐋ ᐹᒋ ᔮᔒᒥᑭᐦᒡ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ, ᒧᔮᒻ ᐋᒥᓵᑭᐦᒡ ᐊᔥᐱᒦᒋᓱᓈᒋᓐ ᐋ ᐃᓯᓈᑯᐦᒡ, ᐊᓂᑖᐦ ᓈᐐᒡ ᐋᐦᑭᒌᐦᒑᔮᑳᐦᒡ ᐋ ᐅᐦᒋ ᑎᐦᑯᓂᑭᓂᐎᒡ ᐋ ᒌ ᐄᔑᓂᒫᓐ᙮ ᐋᒄ ᑳ ᐹᒋ ᓂᑳᐱᔨᐦᒡ ᓂᐦᐋᐤ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐹᔓᒡ ᑳ ᐲᐦᑖᔮᐱᐦᑎᒫᓐ ᓂᒌᐙᐱᒫᐅᒡ ᓂᓈᐦᑭᐤ ᐋ ᐃᓯᓈᑯᓯᒡ ᐊᐅᐦᑳᓂᒡ ᑭᔮᐦ ᐊᒋᓈᐱᒄ ᑭᔮᐦ ᐱᔮᔒᔑᒡ ᐋᐦ ᑖᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ᐋᒄ ᑳ ᐹᐦᑐᐎᒃ ᐊᐙᓐ ᐋ ᐹᒋ ᐊᔨᒥᐦᐄᑦ ᐋ ᐄᔑᑦ, ‘ᐲᑎᕐ ᐱᓯᑰᐦ, ᓂᐱᐦᑖᒑ ᐋᒄ ᒫᒃ ᒑ ᒦᒋᔨᓐ ᐊᓐ ᑳ ᓂᐱᐦᑖᔨᓐ’᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ᓂᒌᐦ ᐃᔨᓐ ᒫᒃ, ‘ᓂᒧᐃ ᓂᑭ ᐅᐦᒋ ᑐᑖᓐ ᐆ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᓂᒧᐃ ᓂᐦᑖ ᓅᐦᒋ ᒦᒋᓐ ᒑᒀᓐ ᐋ ᐐᓈᒡ ᐋ ᐄᑖᔨᐦᑖᑯᐦᒡ ᒎᐤ ᐐᔓᐙᐎᓂᐦᒡ ᑳ ᐐᐦᑖᑯᐦᒡ ᐋᑳ ᓂᐦᑖ ᒑ ᐅᐦᒋ ᒥᒋᓈᓄᑯᐱᓈ’᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ᐋᒄ ᒦᓐ ᑳ ᐅᐦᒋ ᐹᐦᑖᑯᐦᒡ ᐹᐦᑖᑯᓯᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ ᐋᐦ ᐃᔨᑦ ᐊᐙᓐ, ‘ᐊᑳᐐ ᐃᔨᐦ ᐋ ᐐᓈᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐃᔨᑦ ᐋ ᐱᔮᐦᑭᓃᔨᒡ ᒑ ᒌ ᒥᒋᓈᓅᐎᔨᒡ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ᓂᔥᑣᐤ ᒫᒃ ᓂᒌᐦ ᐊᔨᒥᐦᐄᑭᐎᓐ, ᐋᒄ ᒦᓐ ᑳᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑳ ᐄᔑ ᐅᒋᐱᔨᐦᑖᑭᓂᐎᒡ ᐊᓐ ᐋᒥᓵᑭᐦᒡ ᐊᔥᐱᒦᒋᓱᓈᒋᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“ᒸᐦᒡ ᒫᒀᒡ ᒫᒃ ᐆ ᓂᔥᑐ ᓈᐹᐅᒡ ᒌ ᑎᑯᔑᓂᒡ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐊᓐ ᐙᔅᑳᐦᐄᑭᓐ ᑳᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᓂᒌᐦ ᐄᑎᒄ ᒑ ᒌ ᐐᒑᒥᒡ ᐅᔮᔨᐤ ᓈᐹᐤ ᑭᔮᐦ ᐋᑳ ᒑ ᐐᐦ ᓈᓂᒋᔮᓐ ᒑ ᒌ ᐐᒑᐅᒀᐤ ᒥᒄ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᐐᒑᐅᒀᐤ᙮ ᑭᔮᐦ ᒫᒃ ᐅᒌ ᑯᑣᔥᒡ ᑯᑎᑭᒡ ᒌᒋᔖᓅᒡ ᑳ ᑖᑆᐦᑎᐦᒡ ᒞᐹᐦᒡ ᑳ ᐅᐦᒌᒡ ᓂᒌ ᐐᒑᐅᑯᒡ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ ᐋᐦ ᐄᑐᐦᑖᐅᒡ᙮ ᐋᑰᑖᐦ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᔮᒡ ᐊᓐ ᓈᐹᐤ ᒀᕐᓃᓖᔪᔅ ᐐᒋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ᐋᒄ ᒫᒃ ᒀᕐᓃᓖᔪᔅ ᑳ ᐐᐦᑎᒧᔨᒥᐦᑦ ᐋ ᒌ ᐙᐱᒫᑯᐱᓈ ᐋᓐᒋᓐ ᐋ ᓃᐴᐎᔨᒡ ᐊᓂᑖᐦ ᐲᐦᑎᑭᒥᐦᒡ ᐐᒋᐦᒡ ᐋᐦ ᐄᑎᑯᑦ, ‘ᐄᑎᔓᐦᐆ ᐊᐙᓐ ᓈᑖᐦ ᒞᐹᐦᒡ ᒑ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ᐆ ᒫᒃ ᓈᐹᐤ ᓵᐃᒥᓐ ᐲᑎᕐ ᒋᑭ ᐙᐐᐦᑎᒫᒄ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᔨᓐ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᒌ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓯᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᐦᑎᒫᓐ ᑖᓐ ᑳ ᐄᑎᑯᑖᑯᐱᓐ ᒀᕐᓃᓖᔪᔅ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, ᐋᒄ ᑳ ᒋᐦᒋ ᐊᔨᒥᔮᓐ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᔮᓐ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᐹᒋ ᔮᔒᑐᑖᑯᒡ ᒧᔮᒻ ᒌᔮᓂᐤ ᐅᔅᑭᒡ ᑳ ᒥᔨᑯᐎᔨᐦᒄ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ᐋᒄ ᑳ ᐅᐦᒋ ᒋᔥᒋᓯᔮᓐ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ‘ᒞᓐ ᒋᒌ ᓰᑭᐦᐋᐦᑖᑯᐙᐤ ᓂᐲᔨᐤ, ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒋᑭ ᓰᑭᐦᐋᐦᑖᑯᐙᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ᒑᔥᑎᓈᔥ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᒥᔮᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒧᔮᒻ ᒌᔮᓂᐤ ᑳ ᐄᔑ ᒥᔨᑯᐎᔨᐦᒄ ᐄᔥᐱᐦ ᑳ ᑖᑆᔮᔨᒥᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᙭᙮ ᐊᐙᓐ ᒫᒃ ᓃᔨ ᒑ ᒌ ᒋᐱᐦᒋᐦᐄᒃ ᒋᔖᒥᓂᑑ ᑖᓐ ᐙᐦ ᐃᐦᑎᒃ,” ᒌᐦ ᐄᑖᐤ ᐲᑎᕐ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ᐅᔮᔨᐤ ᒫᒃ ᐋ ᐹᐦᑎᐙᒡ ᐋ ᐄᔑ ᐐᐦᑎᒥᔨᒡ ᓂᒧᐃ ᐅᐦᒌ ᓂᔥᑰᔥᑐᐙᐅᒡ ᔖᔥ᙮ ᒌ ᒋᔅᑖᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ ᐋᐦ ᐄᑖᒡ, “ᒋᔖᒥᓂᑑ ᒌ ᓂᐦᐄᐱᔨᐦᑖᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐱᒫᒋᐦᐅᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᐱᐦᐋᑭᓅᑦ ᔅᑏᕙᓐ, ᒌ ᓂᓈᐦᑳᒋᐦᐋᑭᓂᐎᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ, ᒥᓯᐙ ᒫᒃ ᓂᓈᓂᔅ ᒌ ᐄᑎᔓᒧᒡ᙮ ᐱᔅᒡ ᒫᒃ ᐙᐦᔨᐤ ᒌ ᐄᑐᐦᑖᐅᒡ ᒸᐦᒡ ᐊᓂᑖᐦ ᐊᔅᒌ ᕛᓃᓰᔮ ᑭᔮᐦ ᓵᐃᑉᕋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒥᓂᔅᑎᑯᔨᐤ ᑭᔮᐦ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ ᐋᓐᑎᔻᒃ, ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᒌ ᐙᐐᐦᑎᒧᐙᐅᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ᐱᔅᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᐊᓂᑖᐦ ᓵᐃᑉᕋᓯᐦᒡ, ᑭᔮᐦ ᒫᒃ ᓵᐃᕇᓂᐦᒡ ᐃᐦᑖᐎᓂᒡ ᑳ ᐅᐦᒌᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᒃᕇᒃ ᐄᔨᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐋᔨᒨᒫᑭᓂᐎᔨᒡ ᒌᓴᔅᐦ ᐋ ᑎᐹᔨᐦᒋᒑᓯᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ᒌ ᒥᔮᑭᓂᐎᒡ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ, ᒥᐦᒑᑐ ᒫᒃ ᐄᔨᔨᐅᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᑭᔮᐦ ᒌ ᓅᔔᔥᑯᐙᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ᐄᔥᐱᐦ ᐊᓂᒌ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ ᑳ ᐹᐦᑎᐦᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐹᕐᓂᐱᔅ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒃ ᐹᕐᓂᐱᔅ ᐊᓂᑖᐦ, ᐎᔮᐱᐦᑎᒸᑦ ᒫᒃ ᒋᔖᒥᓂᑑ ᑖᓐ ᐋ ᐄᔑ ᒥᒥᔪᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᒌ ᒥᔻᔨᐦᑎᒻ᙮ ᒌ ᔒᐦᒋᒫᐤ ᒫᒃ ᒑ ᒌ ᔮᐃᒋᑳᐳᐎᔨᒡ ᐅᑖᑆᔮᔨᐦᑖᒧᓂᐙᔨᒡ ᑭᔮᐦ ᓲᐦᒃ ᒨᔥ ᒑ ᐐᐦ ᓂᓂᐦᐄᐙᐦᐋᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ᐙᔥ ᐆ ᓈᐹᐤ ᐹᕐᓂᐱᔅ ᓈᔥᒡ ᒌ ᑯᐃᔅᑯᑖᑎᓯᐤ, ᑭᔮᐦ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑰ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᑭᔮᐦ ᒌ ᓲᐦᒑᔨᐦᑖᑯᓂᔨᐤ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ᐋᒄ ᒫᒃ ᐊᑎᑎᐤ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᑳ ᑖᑆᔮᔨᒫᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ᐋᒄ ᐹᕐᓂᐱᔅ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᑖᕐᓯᔅ ᒑ ᒌ ᓂᑑᓈᓂᑎᐙᔨᒫᑦ ᔂᓚ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ᐄᔥᐱᐦ ᒫᒃ ᒫᔅᑭᐙᑦ, ᒌ ᐹᔓᐙᐤ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ᙮ ᑖᐱᔥᑯᓐ ᒫᒃ ᐋ ᓃᔑᒡ ᒥᑐᓐ ᐹᔨᒄ ᐱᐳᓐ ᒨᔥ ᒌ ᓂᔥᑑᓈᐅᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᒑ ᒌ ᒫᒨᐊᔨᒥᐦᐋᒡ ᑭᔮᐦ ᒥᐦᒑᑐ ᐊᓂᔮᔨᐤ ᒌ ᒋᔅᑯᑎᒧᐙᐅᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐋᓐᑎᔻᑭᐦᒡ ᒫᐅᒡ ᓃᔥᑎᒻ ᒃᕆᔅᑎᔮᓂᒡ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᒡ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ᒫᒀᒡ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐃᔨᐦᑎᔨᒡ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓪ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᐱᔅᒡ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐅᐦᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ᐹᔨᒄ ᒫᒃ ᐊᓐ ᐊᑭᐹᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᒌ ᐱᓯᑰ ᐋ ᒥᔨᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒑ ᒌ ᐄᔑ ᓃᑳᓐ ᐐᐦᑎᐦᒃ ᒑ ᐱᒥᐱᔨᔨᒡ ᐋ ᑭᐎᐦᑭᑖᓂᐎᔨᒡ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᐊᔅᒌᔨᐤ᙮ ᐋᐅᒄ ᐋᓐ ᒫᒃ ᑖᑆᐦ ᑳ ᐄᔅᐱᔨᔨᒡ ᒫᒀᒡ ᒃᓨᑎᔨᔅ ᑳ ᒋᐦᒋᐅᒋᒫᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ᐋᒄ ᐊᓂᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᒡ ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᐋ ᐃᑎᔑᒡ ᑳ ᐎᔮᔨᐦᑎᐦᒡ ᓲᐦᒃ ᒑ ᐐᒋᐦᐋᒡ ᒥᒄ ᐊᓂᔮᔨᐤ ᒑ ᒌ ᐃᔥᐱᔥ ᐎᒋᐦᐋᒡ, ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐤ ᐐᒋᔖᓂᐙᐤ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ᐋᔪᐎᒄ ᒫᒃ ᑳᐦ ᑎᒡ᙮ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓚ ᒑ ᒌ ᐄᑐᐦᑎᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᔓᐎᔮᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᒥᔮᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐎᔮᔥ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᑳ ᐅᐦᒋ ᒋᐦᒋ ᓂᓈᐦᑳᒋᐦᐋᑦ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ᒞᓐ ᐐᒋᔖᓂᔨᐤ ᒉᒥᔅ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤ ᓃᔥᑎᒻ ᑳᐦ ᐄᑎᔓᐙᑖᑦ ᒑ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ, ᓂᑐᐱᔫᐦᑯᒫᓂᔨᐤ ᐋᐦ ᐋᐱᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ᐄᔥᐱᐦ ᐎᔮᐱᐦᑎᐦᒃ ᐋ ᒥᔻᔨᐦᑎᒥᔨᒡ ᒎᐄᔨᔨᐤ ᐅᔮᔨᐤ ᑳᐦ ᑎᒃ, ᐋᒄ ᑳᐦ ᐃᔨᑦ ᐲᑎᕐ ᑭᔮᐦ ᒑ ᒌ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒫᒀᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒥᑯᔖᒡ, ᐊᓐ ᒥᑯᔖᓐ ᑳ ᒌ ᒧᐙᑭᓅᑦ ᐋᐃᐦᑯᓈᐤ ᐋᐦᐋᑳ ᐅᐦᐱᓯᑭᓂᐦᑭᐦᑐᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ᐋᒄ ᐲᑎᕐ ᑳ ᐅᑎᓈᑭᓅᑦ ᑳ ᒋᐳᐦᐙᑭᓅᑦ᙮ ᒫᒨ ᓂᑯᑣᔖᑉ ᒌ ᑎᔑᔨᐤ ᓂᑐᐱᔨᐤ ᐋ ᓈᓈᑭᒋᐦᐄᑯᑦ, ᐋ ᒫᒦᔅᑯᑎᔥᑳᑐᔨᒡ᙮ ᓈᐤ ᒌ ᑎᔑᔨᐤ ᐹᔨᒀᐤ ᐋ ᓈᓈᑭᒋᐦᐄᑯᑦ᙮ ᐦᐁᕆᑦ ᒫᒃ ᒌ ᐄᑖᔨᐦᑎᒻ ᒑ ᒌ ᑎᐹᔅᑯᓈᑦ ᐲᑎᕐ ᒫᒀᒡ ᐋ ᒦᐦᒑᑎᓈᓅᐎᔨᒡ ᒌ ᒌᔥ ᒫᑯᔖᓂᐎᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ᒫᒀᒡ ᒫᒃ ᐲᑎᕐ ᑳᐦ ᑖᑦ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᓲᐦᒃ ᒌ ᐊᔨᒥᐦᐋᔥᑎᒫᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ᐊᓂᔮᔨᐤ ᒫᒃ ᒫᐦᒑᔨ ᑖᐱᔅᑳᔨᒡ ᒑ ᑖᑦ ᐲᑎᕐ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᒋᔅᑑᒡ ᓃᔓ ᓂᑐᐱᔨᐤ ᐋᐦ ᑖᔨᒡ ᒌ ᓂᐹᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐙᐱᓃᔨᒑ ᐋᑯᑖᐦ ᒋᐱᐦ ᑎᐹᔅᑯᓈᑭᓂᐤ᙮ ᓃᔣᐹᒡ ᒫᒃ ᐴᓂᔑᓈᔮᐲ ᒌ ᒫᐦᑯᐱᑖᑭᓂᐤ᙮ ᑭᔮᐦ ᒌᐦ ᑖᔨᐤ ᓂᑐᐱᔨᐤ ᐋ ᑭᓅᔥᒀᐦᑎᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ᒑᒃ ᔑᔥᒋᑯᒡ ᑳ ᐅᐦᒋ ᐙᔥᑖᔨᒡ ᐊᓂᑎᐦ ᐲᑎᕐ ᑳ ᒋᐳᐦᐙᑭᓅᑦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᐙᐦᒋ ᓃᐴᐎᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ᙮ ᑳ ᐃᔮᔮᐦᒋᐱᑎᑯᑦ ᐋ ᐐᐦ ᑯᔥᑯᓂᑯᑦ, ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒌᔨᐲᐦ ᐎᓂᔥᑳ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐃᔮᐱᐦᑯᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐴᓂᔑᓈᔓᓈᔮᐲ ᑳ ᒫᐦᑯᐱᑖᑭᓅᑦ ᐲᑎᕐ ᐅᐦᑯᓂᑎᐦᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ, “ᓂᒋᓈᑰ, ᑭᔮᐦ ᒫᐦᑯᐱᑦ ᒋᒥᔅᒋᓐ᙮” ᐋᔪᐎᒄ ᑳᐦ ᑎᒃ ᐲᑎᕐ ᐋᒄ ᒦᓐ ᑳᐦ ᐄᑎᑯᑦ, “ᐳᔥᒃ ᒋᑎᑯᐦᑉᐦ, ᒑ ᐹᒋ ᐐᒑᐎᔨᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","ᐲᑎᕐ ᒫᒃ ᒌ ᓅᔔᔥᑭᐙᐤ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ ᐋᐦ ᐋᑎᐐᐎᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒻ ᑖᑆᐦ ᐋᐦ ᐄᔅᐱᔨᒀ ᐅᔮᔨᐤ ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐋᔑᓂᒧᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ᓃᔥᑎᒻ ᒫᒃ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᒌ ᐋᑎ ᒥᔮᔅᑭᐙᐅᒡ, ᒦᓐ ᐊᓂᔮᔨᐤ ᑯᑎᒃ, ᐋᒄ ᒑᒃ ᑳ ᐅᑎᐦᑖᒡ ᐊᓂᔮᔨᐤ ᐱᔻᐱᔅᒄ ᒋᔥᑐᐦᑭᓐ ᐊᓂᑖᐦ ᐋ ᐅᐦᒋ ᐲᐦᒑᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᓵᐦᒑᐄ ᒫᒃ ᒌ ᐋᐱᐦᐄᐱᔨᐤ ᐊᓐ ᐱᔻᐱᔅᒄ ᒋᔥᑐᐦᑭᓐ, ᐋᒄ ᑳᐦ ᐋᑎ ᐎᔨᐐᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᒡ ᐊᓂᑖᐦ ᒫᔅᑭᓈᐦᒡ, ᔑᔥᒋᑯᒡ ᒌ ᓂᑭᑎᑰ ᐊᓂᔮᔨᐤ ᐋᓐᒋᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ᐄᔥᐱᐦ ᒫᒃ ᐲᑎᕐ ᒥᔮᒥᑐᓈᔨᐦᑎᐦᒃ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᑦ, ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᓂᒑᔥᑎᓈᐦᐅᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐅᑖᓐᒋᓂᒻᐦ ᒑ ᐹᒋ ᐱᐦᑯᐦᐄᔨᒡ, ᐋᑳ ᒑ ᒌ ᐹᒋ ᐎᔮᔥ ᑐᑎᐎᑦ ᐦᐁᕆᑦ ᑭᔮᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᑳ ᒑ ᒌᐦ ᑐᑎᐎᒡ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ᐄᔥᐱᐦ ᒫᒃ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐲᑎᕐ ᑖᓐ ᑳ ᐄᔅᐱᔨᑦ, ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᒣᕇ ᐋᐦ ᑖᔨᒡ, ᒞᓐ ᒫᕐᒃ ᐅᑳᐐᔨᐤ᙮ ᒫᒀᒡ ᒫᒃ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᒌ ᓂᔥᑐᐎᔨᐤ ᐊᓂᑎᐦ ᐋ ᐊᔨᒥᐦᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ᐋᒄ ᐲᑎᕐ ᑳ ᒥᒥᑣᐦᐙᐦᑦ ᐊᓂᔮᔨᐤᐦ ᒋᔥᑐᐦᑭᓐᐦ, ᐋᒄ ᐊᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐃᔅᒀᐤ ᕎᑖ ᑳ ᓂᑐᒋᔅᒑᔨᒫᑦ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᐦ ᐹᒋ ᐲᐦᒑᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ᐄᔥᐱᐦ ᓈᔅᑐᐦᑎᐙᑦ ᐲᑎᕐ ᐋ ᐊᔨᒥᔨᒡ, ᑳᐤ ᒌ ᒌᐙᐱᐦᑖᐤ ᐋᐦᐋᑳ ᐙᐙᒡ ᐋᐱᐦᐙᑦ ᐊᓂᔮᔨᐤ ᒋᔥᑐᐦᑭᓐ ᒑ ᒌ ᐲᐦᒑᔨᒡ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑎᐦᒃ᙮ ᐋᒄ ᑳ ᓂᑑᐐᐦᑎᐦᒃ ᐲᑎᕐ ᐋ ᑎᑯᔑᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ᒌ ᐄᑖᑭᓂᐤ ᒫᒃ, “ᒋᒌᔅᒀᓈᒑ, ᓂᒧᐃ ᓈᓂᑐ ᐲᑎᕐ᙮” ᒥᒄ ᒫᒃ ᓈᔥᒡ ᒋᐐᐦ ᑖᑆᐤ ᐋᐦ ᐃᔨᑦ, ᑖᑆᐦ ᐙᔥ ᐊᓐ ᐲᑎᕐ ᐊᓐ ᑳ ᐹᒋ ᓃᐴᐎᑦ᙮ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᒑᔥᑎᓈᔥ ᐅᑖᓐᒋᓂᒻᐦ ᐊᓂᔮᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ᐊᔮᐱᒡ ᒫᒃ ᒌ ᒥᒥᑣᐦᐄᒑᐤ ᐲᑎᕐ ᐃᔥᒀᐦᑖᒥᐦᒡ᙮ ᒑᒃ ᒫᒃ ᑳᐦ ᐋᐱᐦᐊᒧᐙᑭᓅᑦ, ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒫᒡ, ᓈᔥᑖᑆᐦ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ᒌ ᐙᔥᑎᐦᒧᐙᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑᐦ ᐋᑳ ᒋᔅᑑᔨᒡ᙮ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᐱᑯᐦᐄᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐅᐦᒋ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐐᐦᑎᒧᐙᐦᑯᒡ ᒉᒥᔅ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᒌᒋᔖᓅᒡ ᑖᓐ ᑳ ᐄᔥᐱᔮᓐ᙮” ᐋᒄ ᑳ ᐎᔨᐐᑦ, ᐃᔨᐦᒡ ᐊᓂᑖᐦ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ, ᓈᔥᑖᑆᐦ ᒌ ᑯᔥᒀᔨᐦᑎᒧᒡ ᑭᔮᐦ ᒌ ᓵᒋᓯᐎᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐋᐦᐋᑳ ᒥᔅᑭᐙᒡ ᐊᓂᔮᔨᐤ ᐲᑎᕐ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ᐦᐁᕆᑦ ᒫᒃ ᒌ ᐄᑎᔑᐦᐙᐤ ᒑ ᒌ ᓈᓂᑐᐙᔨᒫᑭᓂᐎᔨᒡ ᐲᑎᕐ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔅᑭᐙᑭᓄᔨᐤᐦ᙮ ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᑳ ᓈᓈᑭᒋᐦᐋᒡ ᐲᑎᕐ ᒌ ᑯᒀᒋᒫᑭᓂᐎᒡ ᒑ ᒌ ᐐᐦᑎᐦᒡ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐄᔅᐱᔨᔨᒡ, ᐋᒄ ᐦᐁᕆᑦ ᑳᐦ ᐄᑎᔓᐙᑖᑦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓂᑐᐱᔨᐤᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐙᑭᓂᐐᒡ, ᐦᐁᕆᑦ ᒌ ᓂᑭᑎᒻ ᒎᑏᔮ ᐊᔅᒌᔨᐤ, ᐋᒄ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ᐦᐁᕆᑦ ᒫᒃ ᓈᔥᒡ ᒌ ᒋᔑᐙᐦᐄᑰ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᑖᐃᕋᐦᒡ ᑭᔮᐦ ᓵᐃᑎᓂᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ᒫᒀᒡ ᒫᒃ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ ᑳᐦ ᑖᑦ ᒌ ᑎᑯᔑᓂᔨᐤ ᐄᔨᔨᐤ ᐊᓂᑖᐦ ᑖᐃᕋ ᑭᔮᐦ ᓵᐃᑎᓐ ᐋ ᐅᐦᒌᔨᒡ ᐋ ᒌ ᐹᒋ ᐄᑎᔓᐦᐅᒫᑭᓂᐎᔨᑯᐱᓈᓂᐦᐄ ᒑ ᒌ ᒥᔪᐱᔨᐦᑖᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐱᔨᒡ ᐦᐁᕆᑦ ᑭᔮᐦ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᐙᔥ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᒌ ᐅᐦᑎᓂᐦᒡ ᐅᒦᒋᒧᐙᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐦᐁᕆᑦ ᑳ ᒋᐦᒋᐅᒋᒫᑭᑎᒥᔨᒡ᙮ ᐐᔨ ᒫᒃ ᐦᐁᕆᑦ ᒌ ᐱᒋᔅᑎᔓᐙᑎᒻ ᐊᓂᔮᔨᐤ ᒦᒋᒥᔨᐤ᙮ ᒌᐦ ᑖᔨᐤ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ ᐱᓛᔅᑎᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐋ ᓈᓈᑭᑐᐙᔨᐦᑎᒸᑦ ᐦᐁᕆᑦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᐤ ᐋ ᐄᑖᐱᑎᓰᑦ᙮ ᐋᔨᐅᑯᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᔑᐦᑯᒋᒫᒡ ᒑ ᒌ ᐐᒋᐦᐄᑯᒡ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᑳ ᓂᑎᐙᐱᒫᒡ ᐦᐁᕆᑦ ᐙᔥ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᒫᐅᒡ ᒑ ᒌ ᒋᔑᐙᓰᔅᑖᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ᐋᒄ ᐦᐁᕆᑦ ᑳ ᐎᔮᔨᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᒑ ᓂᑑᐦᑎᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᑳ ᒌᔑᑳᔨᒡ ᒌ ᒋᐦᒋᐅᒋᒫᐙᔅᐱᓲ, ᐋᒄ ᑳ ᐊᐱᑦ ᐊᓂᑎᐦ ᒋᐦᒋᐅᒋᒫᐤ ᑖᐦᑎᐱᐎᓂᐦᒡ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᐹᐦᑎᐙᒡ ᒌ ᑖᑆᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᓂᒥᔮᐤ ᓈᐹᐤ ᐆ ᑳ ᐊᔨᒥᑦ, ᒧᔮᒻ ᐋ ᒋᔖᒥᓂᑑᑦ ᐊᐙᓐ ᐊᒀᑎᐦᑖᑯᓯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ᑏᐙᐦᒡ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᐅᑖᓐᒋᓂᒥᔨᐤᐦ ᒌ ᑐᑖᑰ ᐦᐁᕆᑦ ᓈᔥᒡ ᒑ ᒌ ᐋᐦᑯᓯᑦ, ᐋᒄ ᒥᓐᑐᔒᔥ ᑳᐦ ᐋᑎᒨᑯᑦ ᒥᑐᓐ ᐋ ᒌ ᐋᑎ ᓂᐱᐦᐄᑯᑦ, ᐙᔥ ᐐᔨ ᒌ ᒋᔥᑖᔨᐦᑖᑯᐦᐄᓲᐤ ᐊᐦᐋᑳ ᒋᐐᐦ ᒋᔅᑖᔨᐦᑖᑰᐦᐋᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ᓈᓈᓂᒌᒻ ᒫᒃ ᒥᔑᐦᑖ ᒌ ᐙᐐᐦᑖᑭᓂᐎᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓐᐦ ᑭᔮᐦ ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᒥᐦᒑᑑᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓪ ᒌ ᒌᔑᐦᑖᐅᒡ ᑖᓐ ᑳ ᐐᐦ ᐃᔨᐦᑎᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐋᒄ ᒫᒃ ᑳ ᒌᐙᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ᙮ ᒞᓐ ᒫᕐᒃ ᒫᒃ ᒌ ᒋᔅᑐᐦᑎᐦᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ᐊᓂᑎᐦ ᒫᒃ ᐋᓐᑎᔻᑭᐦᒡ ᑳᐦ ᑖᒡ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᑳ ᒋᔅᑯᑎᒫᒑᒡ᙮ ᐋᐅᑯᓂᒡ ᐅᒌ, ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᓯᒥᔨᓐ ᑳ ᐐᔨᐱᓯᑦ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᑭᔮᐦ ᓗᓰᔨᔅ, ᓵᐃᕇᓂᐦᒡ ᑳ ᐅᐦᒌᑦ, ᑭᔮᐦ ᒥᓃᔨᓐ ᐊᓐ ᑳ ᐃᔅᒡ ᓂᐦᑖᐅᒋᓈᑭᓅᑦ ᒋᐦᒋᐅᒋᒫᐤ ᐦᐁᕆᑦ ᑳ ᓂᐦᑖᐅᒋᓈᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᔂᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐋᐦᐋᑳ ᒦᒋᓱᒡ ᒥᒄ ᐋ ᒫᒨ ᐊᔨᒥᐦᐋᔥᑎᐙᒡ ᑎᐸᔨᐦᒋᒑᓯᐤᐦ, ᐋᑯᑖᐦ ᑳ ᐊᔨᒥᐦᐄᑯᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐋᐦ ᐄᑎᑯᒡ, “ᐹᒋ ᑎᐹᓂᐦᐋᐦᑯᒡ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓪ ᐙᔥ ᓂᒌ ᐎᔮᔨᒫᐅᒡ ᒑ ᒌᐦ ᑐᑎᒧᐎᒡ ᐋᐱᑎᓰᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔑᐦᑖᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᑎᒡ ᐋᐦᐋᑳ ᒦᒋᓱᒡ ᑭᔮᐦ ᒥᒄ ᐋ ᐊᔨᒥᐦᐋᒡ, ᐋᒄ ᑳ ᑖᐦᒋᓈᒡ ᐋ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓚ, ᐋᒄ ᑳ ᒋᐦᒋᑎᔑᐦᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ᑳ ᐱᔮᐦᒋᓰᔨᒡ ᐊᐦᒑᐦᒄ ᒫᒃ ᐋ ᒌ ᒋᐦᒋᑎᔑᐦᐅᑯᒡ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓪ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᔨᐤ ᓭᓗᓯᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐅᐦᒋ ᐴᓯᒡ ᐊᓂᑖᐦ ᒥᓂᔅᑎᑯᐦᒡ ᓵᐃᑉᕋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑖᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ᐄᔥᐱᐦ ᒫᒃ ᒫᓯᑳᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᓵᓛᒥᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ, ᒌ ᐙᐐᐦᑎᒧᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᐊᓂᑖᐦ ᒎᐄᔨᔨᐤ ᐅᑎᔨᒥᐦᐋᐅᑭᒥᑯᔨᐦᒡ᙮ ᒌ ᐐᒑᐅᑯᒡ ᒫᒃ ᒞᓐ ᒫᕐᒃ ᒑ ᒌ ᐐᒋᐦᐄᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ᐄᔥᐱᐦ ᑳ ᒌᔥ ᑭᒑᔅᒀᒡ ᐊᓂᑎᐦ ᒥᓂᔅᑎᑯᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐹᕛᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᓂᒋᐦᐋᒡ ᐋ ᒥᒫᐦᑖᐙᑎᓰᔨᒡ ᒎᐤ ᓈᐹᐤᐦ ᐹᕐᒌᓴᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᒌ ᒥᒋᐅᒋᔅᒋᐙᐦᐄᒑᓲᔨᐤ ᒫᒃ ᐅᔮᔨᐤᐦ ᓈᐹᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ᑭᔮᐦ ᒫᒃ ᐆ ᐹᕐᒌᓴᔅ ᒌ ᐅᐐᒑᐙᑭᓂᐤᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤᐦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒥᓂᔅᑎᑯᔨᐤ ᑳᐦ ᑖᔨᐦᒡ, ᓭᕐᑭᔪᔅ ᑆᓗᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᓈᔥᒡ ᐋ ᒌ ᐄᑆᐦᑳᔨᒡ᙮ ᐊᓐ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᒌ ᓂᑑᒫᐤ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓚ ᐋ ᐐᐦ ᐹᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ᒥᒄ ᒫᒃ ᐆ ᑳ ᒥᒫᐦᑖᐙᑎᓰᑦ ᐹᕐᒌᓴᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᐁᓖᒫᔅ ᒌ ᐃᔑᓂᐦᑳᑎᑰ ᐊᓂᔮᔨᐤ ᒃᕇᒃ ᑳ ᐄᔑ ᐊᔨᒥᔨᒡ, ᒋᐐᐦ ᒋᐱᐦᒋᐦᐋᐤ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᔂᓚ ᒑ ᒌ ᐐᐦᑎᒧᐙᔨᒡ ᐊᓂᔮᔨᐤᐦ ᒋᐦᒋᐅᒋᒫᐤᐦ ᒥᔻᒋᒧᐎᓂᔨᐤ, ᐙᔥ ᓂᒧᐃ ᐅᐦᒋ ᓂᑎᐙᔨᒫᐤ ᒑ ᒌ ᑖᑆᔮᔨᒫᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ᐋᒄ ᒫᒃ ᔂᓪ, ᐊᓐ ᑆᓪ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᐋ ᓵᑭᔅᒋᓈᔥᑳᑯᑦ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᑯᐃᔅᒄ ᒌ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤᐦ ᑳ ᒥᒫᐦᑖᐙᑎᓰᔨᒡ ᓈᐹᐤᐦ, ");
INSERT INTO crl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒧᔮᒻ ᒥᒋᒥᓂᑑ ᐅᑎᐙᔑᔒᒻ ᐋᐅᒄ ᐋᑖᔨᐦᑖᑯᓯᔨᓐ, ᐋ ᐅᐦᑳᑎᒥᓐ ᒥᓯᐙ ᑯᐃᔅᑯᑖᑎᓰᐎᓐ᙮ ᐊᑯᓐ ᐋᒄ ᐃᔥᐱᔥ ᐎᓂᐱᔨᐦᐄᐙᑦ ᓂᓂᑏᔫᐎᓐ ᐅᐦᒋ ᑭᔮᐦ ᐴᓃᐦ ᐋᒄ ᐋ ᐐᐦ ᓂᔑᐎᓈᒋᐦᑖᐙᑦ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐄᑖᑎᓰᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ᒋᐐᐦᑎᒫᑎᓐ ᐊᓅᐦᒡ ᓄᐎᒡ ᒋᑭ ᒫᑯᐦᐄᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐙᐃᐱᔥᒌᔥ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐙᐱᒫᐤ ᐲᓯᒻ᙮” ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒨᔑᐦᑖᐤ ᐋ ᐲᒋᔖᐱᔨᔨᒡ ᑭᔮᐦ ᐋ ᐅᐦᒋ ᑎᐱᔅᒋᐱᔨᔨᒡ ᐋ ᐄᑖᔨᐦᑎᐦᒃ ᐊᓐ ᓈᐹᐤ, ᐋᒄ ᓂᒧᐃ ᐅᐦᒋ ᐙᐱᐦᑎᒻ, ᐋᒄ ᑳ ᓈᓂᑐᒥᔅᑯᓈᑦ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐱᐹᑎᐦᑯᓂᔅᒑᐦᑎᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᐦᑎᐦᒃ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐅᔮᔨᐤ ᐋ ᐄᔅᐱᔨᔨᒡ ᒌ ᑖᑆᔮᔨᒫᐤ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ ᑭᔮᐦ ᓈᔥᑖᑆᐦ ᒌ ᒥᔅᑳᑖᔨᐦᑎᒥᐦᐄᑰ ᑳ ᐄᔑ ᐹᐦᑎᐦᒃ ᐋ ᒋᔅᑯᑎᒫᒑᓂᐎᔨᒡ ᐋᐦ ᐋᔨᒨᒫᑭᓂᐎᔨᔅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ᐋᒄ ᑆᓪ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᐐᒑᐙᑭᓐᐦ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐹᕛᔅ ᑳ ᐅᐦᒋ ᐴᓯᒡ, ᐋᒄ ᐊᓂᑖᐦ ᐯᕐᑳ ᑳ ᐃᔅᒋᒫᒡ ᐊᓂᑖᐦ ᐹᒻᕕᓕᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐃᐦᑖᐎᓐ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐯᕐᑳᐦᒡ ᑳ ᐅᐦᒋᒋᔅᑭᑎᑯᒡ ᒞᓐ ᒫᕐᒃ ᐋᒄ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐤ ᑳ ᐄᔑ ᒌᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ᐋᒄ ᒦᓐ ᐋᓐᑎᔻᑭᐦᒡ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐱᓯᑎᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐃᐦᑖᐎᓐ᙮ ᑳ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᒫᒃ ᒌ ᐲᐦᒑᐅᒡ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋᒄ ᑳ ᐊᐱᐎᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᐊᐙᓐ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᐊᔨᒥᐦᑐᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓐ, ᑭᔮᐦ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒥᔨᑯᐱᓈᓂᐦᐄ᙮ ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐦᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒌ ᐄᑎᔓᐙᐅᒡ ᐄᔨᔨᐤᐦ ᒑ ᑯᒀᒋᒫᔨᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᒑ ᒌ ᐊᔨᒥᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᒥᔥᑭᐎᑳᐳᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ᐋᒄ ᒫᒃ ᑆᓪ ᑳ ᐅᐦᐱᑳᐳᑦ, ᑳ ᐅᐦᐱᓂᔅᒑᔨᑦ ᐋ ᓂᑎᐙᔨᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᑳ ᒑ ᒌ ᒋᔅᑑᔨᒡ, ᑳᐦ ᐃᔨᑦ, “ᓃᒋᔖᓂᑎᒄ, ᑖᐱᔥᑯᓐ ᒌᔨᐙᐤ ᒎᐤ ᑭᔮᐦ ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᑳ ᐊᔨᒥᐦᐋᔥᑎᐙᐦᒄ ᒋᔖᒥᓂᑑ, ᓂᑐᐦᑎᐎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ᐊᓐ ᒋᔖᒥᓂᑑ, ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌ ᐎᔮᔨᒫᐤ ᒋᑖᓂᔅᑰᓯᒥᓂᐤ ᒑ ᒌ ᐅᑏᔨᔨᒥᑦ᙮ ᒌᐦ ᑐᑎᐙᐤ ᒑ ᒌ ᐋᑎ ᒥᐦᒑᑎᔨᒡ ᒫᒀᒡ ᐊᓂᑎᐦ ᐄᒋᑉᑦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᓲᐦᒑᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᒌ ᐎᔨᐐᐦᑎᐦᐄᑯᒡ ᐊᓂᑎᐦ ᐊᔅᒌᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐ ᒫᒃ ᒌ ᐃᔥᐱᔥ ᓰᐱᔨᐙᓰᔅᑎᐙᐤ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᒫᒀᒡ ᐊᓂᑖᐦ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳᐦ ᑖᔨᒡ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᓂᓂᐦᐄᐦᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᒥᔮᐤ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑫᓈᓐ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒑ ᒌ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐄᔥᐱᐦ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᓂᔑᐎᓈᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓃᔣᔥᒡ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ᐎᔮᔥᑖᐦ ᓈᐙᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒦᓐ ᓂᔮᔪᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐᐦ ᒫᒃ ᒌ ᐃᔥᐱᔥ ᐱᒥᐱᔨᐤ ᐆ᙮ ᐋᒄ ᒋᔖᒥᓂᑑ ᑳ ᐎᔮᔨᒫᔨᒡ ᐊᐙᔨᐤᐦ ᒑ ᓃᑳᓂᔥᑳᑯᒡ ᑭᔮᐦ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᒡ᙮ ᐋᔥᒄ ᐋᒸᔮᐦ ᐅᐦᒋ ᑖᔨᒡ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᓵᒥᔪᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ᐋᒄ ᒑᒃ ᐅᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᐄᑖᒡ ᓵᒥᔪᓪ ᐋ ᓂᑎᐙᔨᒫᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐅᒋᔥᒍᒋᒫᒥᒡ᙮ ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᐎᔮᔨᒫᑦ ᔂᓪᐦ ᒑ ᒌ ᐅᒋᐦᒋᐅᒋᒫᒥᒡ᙮ ᔂᓪ ᒫᒃ ᐅᐦᑖᐐᐦ ᑭᔥ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ, ᐊᓂᑖᐦ ᐱᓐᒋᒥᓐ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᑎᔅᑳᓈᓯᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᓈᒥᑎᓂᐤ ᑎᐦᑐ ᐱᐳᓐᐦ ᑳ ᐃᔥᐱᔥ ᒋᐦᒋᐅᒋᒫᐅᑦ, ");
INSERT INTO crl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ᐋᒄ ᒋᔖᒥᓂᑑ ᑳ ᐄᒑᓈᑦ ᔂᓪ ᐋ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ, ᑌᕕᑦ ᑳ ᒋᐦᒋᐅᒋᒫᐅᐦᐋᑦ, ᑳ ᒦᔅᑯᑎᔥᑭᐙᑦ ᔂᓪᐦ, ᑳᐦ ᐄᑦ ᒋᔖᒥᓂᑑ, ᑌᕕᑦ, ᒉᓰ ᐅᑯᓯᔅᐦ, ᐋᐅᒄ ᒫᔻᔨᒥᒃ ᓈᐹᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐋᐦ ᑐᑎᐦᒃ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᒃ ᒑ ᒌᐦ ᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“ᒋᔖᒥᓂᑑ ᒫᒃ ᑭᔮᐦ ᒌ ᐃᔨᐤ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐊᐙᔨᐤᐦ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᐋ ᐅᐦᒌᔨᒡ ᒑ ᒌ ᐱᒫᒋᐦᐋᔨᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤᐦ, ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᒌᓴᔅᐦ, ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ᐋᒸᔮ ᐅᐦᒋ ᒋᐦᒋᐱᔨᐦᑖᑦ ᒌᓴᔅ ᐋ ᑭᒑᔅᒀᑦ, ᒞᓐ ᒌ ᑭᒑᔅᒋᒫᐤ ᒥᐦᒑᑐ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐋᐦ ᐄᑖᑦ, ᒀᔅᑳᑎᓰᒄ, ᒑ ᓂᑭᑎᒫᒄ ᒋᒥᒑᑎᓰᐎᓂᐙᐤ, ᑭᔮᐦ ᒫᒃ ᒑ ᓰᑭᐦᐋᐦᑖᑯᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ᐄᔥᐱᐦ ᒫᒃ ᒑᑳᑦ ᑳ ᒌᔑᐦᑖᑦ ᒞᓐ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᓂᑎᐙᔨᒥᑯᑦ ᒋᔖᒥᓂᑑᐦ ᒑ ᑎᒃ, ᒌ ᐃᔨᑖᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ‘ᐊᐙᓐ ᐋᑖᔨᒥᔮᒄ ᓃᔨ? ᓂᒥᔮᐤ ᓃᔨ ᙭ ᐊᓐ ᑳ ᐊᔓᐙᐱᒫᒄ᙮ ᔖᔥ ᐐᐱᒡ ᒋᑭ ᑎᑯᔑᓐ, ᓂᒧᐃ ᐙᐙᒡ ᓂᑖᐱᒑᔨᐦᑖᑯᓯᓐ ᓃᔨ ᒑ ᒌ ᐋᐱᐦᑯᓂᒧᒡ ᐅᒥᔅᒋᓐ᙮’ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑯᐱᓈ ᐊᓂᔮ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ᓃᒋᔖᓂᑎᒄ, ᒌᔨᐙᐤ ᒫᒃ ᑳ ᐅᐦᑎᔅᑳᓈᓯᔮᒄ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᑭᔮᐦ ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᑳ ᐊᔨᒥᐦᐋᔥᑎᐙᐦᒄ ᒋᔖᒥᓂᑑᐦ, ᒋᒌ ᒥᔨᑯᓈᓂᐤ ᒥᔻᒋᒧᐎᓐ ᒑ ᒌ ᑭᒑᔅᒀᔨᐦᒄ ᐊᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ᐙᔥ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑳᑯᒡ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᒫᐅᒡ ᒌᓴᔅᐦ ᐋᐦ ᐋᐎᔨᒡ ᐱᒫᒋᐦᐄᐙᐤᐦ, ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᑖᐙᑯᐱᓐ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒥᔨᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᑳ ᐄᔑ ᐋᔨᒨᒫᔨᒡ ᙭᙮ ᐋᑦ ᒫᒃ ᐋᔑᑯᒻ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᐋ ᒌ ᐊᔨᒥᐦᑐᐙᑭᓂᐎᒡ᙮ ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᓂᑎᐙᔨᒫᒡ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ, ᐋᒄ ᑳ ᑎᐱᐱᔨᒡ ᑖᓐ ᑳ ᐄᑎᓯᓂᐦᐄᑭᓂᐎᔨᒡ ᒑ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤᐦ ᐹᔨᓕᑦᐦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᒌᓴᔅᐦ, ᐋᐦᐋᑦ ᒌ ᒋᔅᒑᔨᒫᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ᐙᔥᑭᒡ ᒌ ᒥᓯᓂᐦᐄᑭᓂᐤ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑖᓐ ᒑ ᑐᑖᑯᑦ ᐄᔨᔨᐤ ᙭, ᒥᓯᐙ ᒫᒃ ᒌ ᑎᐱᐱᔨᐤ ᐆ, ᒌᓴᔅ ᒌ ᓂᐱᐦᐋᑭᓂᐤ ᐋᒄ ᑳ ᓃᐦᑎᓈᑭᓅᑦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ, ᐋᒄ ᑳ ᓂᐦᐄᑭᐙᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᐎᓂᔥᑳᓈᐤ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌ ᐙᐱᒥᑰ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳᓕᓖᐦᒡ ᑳ ᒌ ᐅᐦᒋ ᐹᒋ ᐐᒑᐅᑯᑦ ᒋᕉᓯᓕᒥᐦᒡ ᐄᔅᒄ᙮ ᒌ ᐐᐦᑎᒧᐙᔨᐤ ᒫᒃ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒦᓐ ᐋ ᐱᒫᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“ᓃᔮᓐ ᒫᒃ ᒌ ᐹᒋ ᐐᐦᑎᒫᑎᓈᓐ ᒥᔻᒋᒧᐎᓐ ᐋᐅᒄ ᐆ ᔖᔥ ᐋ ᑎᐱᐱᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑖᓐ ᑳᐦ ᐄᑖᑦ ᒋᑖᓂᔅᑰᓯᒥᓂᐤ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᐦᒃ, ");
INSERT INTO crl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ᐋ ᐙᓂᔥᑳᓈᑦ ᒌᓴᔅ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᑌᕕᑦ ᐅᓂᑭᒧᐎᓂᐦᒡ ᓃᔓ ᐱᔅᒋᑎᓯᓂᐦᐄᑭᓂᒡ, ᒌᔨ ᓂᑯᔅ, ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᔖᔥ ᓃᔨ ᑰᐦᑖᐐᑐᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᒑ ᐙᓂᔥᑳᓈᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᐋᑳ ᓂᐦᑖ ᒦᓐ ᒑ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᑭᔮᐦ ᐊᒀᒋᔥᑖᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᐦᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐃᔨᑦ, ᑖᑆᐦ ᒋᑭ ᒥᔨᑎᓐ ᐊᓂᐦᐄ ᐱᔮᐦᒋ ᒥᔪᑐᑖᒑᐎᓐ ᑳ ᑖᑆᐅᒑᔨᐦᑖᑯᐦᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᒄ ᐊᓂᔮ ᑌᕕᑦ ᒑ ᒥᔨᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ᐋᒄ ᒫᒃ ᐊᒀᒋᔥᑖᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᑌᕕᑦ ᐅᓂᑭᒧᐎᓂᐦᒡ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐱᒋᔅᑎᓈᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᒋᑎ ᐋᐱᒋᐦᐋᑭᓐ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᑦ, ᑭᔮᐦ ᐅᔨᐤ ᒑ ᒌ ᐃᔮᔪᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“ᐙᔥ ᑌᕕᑦ ᒌ ᐋᐱᑎᓰᔅᑎᐙᐤ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒌᐦ ᑐᑎᒻ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ ᑳ ᐃᔥᐱᔥ ᐱᒫᑎᓰᑦ᙮ ᐋᒄ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᑳ ᓂᐦᐄᑭᐙᑭᓅᑦ ᐊᓂᑖᐦ ᑳ ᓂᐦᐄᑭᒫᑭᓂᐎᔨᒡ ᐊᓂᔮ ᐅᐙᐦᑯᒫᑭᓐ, ᐅᔨᐤ ᒫᒃ ᒌ ᐎᓂᐱᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ᒌᓴᔅ ᒫᒃ ᐐᔨ, ᐋᑦ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ ᒌ ᐎᓂᔥᑳᓂᑰ ᒋᔖᒥᓂᑑᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᓂᒧᐃ ᒫᒃ ᒦᓐ ᐅᐦᒋ ᐴᓂᐱᒫᑎᓰᐤ, ᓂᒧᐃ ᓂᐦᑖ ᐅᐦᒋ ᐎᓂᐱᔨᐤ ᐅᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ᒥᓯᐙ ᒌᔨᐙᐤ ᓃᒋᔖᓂᑎᒄ ᐹᒋ ᓂᑐᐦᑎᐎᒄ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ, ᒋᐱᐦ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᒌᓴᔅ ᐅᐦᒋ ᐋᑯᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒫᑯᔮᒄ ᒋᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ ᑖᑆᐦ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐤ ᒥᓯᐙ ᐅᒥᒋᐦᑣᐎᓐ, ᓂᒧᐃ ᐐᔨ ᒧᓱᔅ ᐅᑎᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒋᑭ ᒌ ᐙᐹᐃᑎᒫᐙᑭᓂᐤ ᐊᐙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ᔮᒀᒦᒄ ᒫᒃ ᐋᑳ ᒑ ᒌ ᐄᔅᐱᔨᔮᒄ ᑖᓐ ᑳ ᐄᔑ ᒥᓯᓂᐦᐋᒧᐙᑯᐱᓈ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑖᓐ ᒑ ᐄᔅᐱᔨᔨᒡ ᐊᐙᔨᐤᐦ, ");
INSERT INTO crl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ᑭᓂᐙᐱᐦᑎᒧᒄ ᒫᐦ, ᒌᔨᐙᐤ ᑳ ᒥᒫᔮᔨᐦᒑᔮᒄ, ᒫᒥᔥᑳᑖᔨᐦᑎᒧᒄ ᑭᔮᐦ ᓂᔑᐎᓈᑎᓰᒄ᙮ ᐙᔥ ᒑᒀᓐ ᓂᑭ ᑐᑖᓐ ᐅᑎᐦ ᒫᒀᒡ ᐋᔥᒄ ᐋ ᐱᒫᑎᓰᔮᒄ ᐊᓐ ᐋᑳ ᒑ ᐅᐦᒋ ᑖᑆᐦᑎᒥᐦᐄᑯᔮᒄ ᐋᑦ ᐊᐙᓐ ᐐᐦ ᐐᐦᑎᒫᑖᒀ᙮” ᑳ ᐄᔑ ᐊᔨᒥᐦᐋᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ᐄᔥᐱᐦ ᒫᒃ ᒑ ᐎᔨᐐᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌ ᐋᔨᐦᑭᒥᐦᐄᑯᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᑎᑯᔑᐦᒡ ᐄᔥᐱᐦ ᒦᓐ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒑ ᐊᑎᑎᐤ ᒑ ᒌ ᒋᔅᑯᑎᒫᑯᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᒡ ᒫᒃ, ᒥᐦᒑᑐ ᒎᐤ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᒌ ᐐᒑᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ᙮ ᐋᒄ ᒫᒃ ᐊᓂᒌ ᑳ ᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᐄᑖᒡ, ᒋᔖᒥᓂᑑ ᓈᔥᑖᑆᐦ ᒌ ᒥᔪᑐᑖᑯᐙᐤ, ᓲᐦᒃ ᑯᐃᔅᒄ ᐐᐦ ᐄᔑ ᐱᒫᑎᓰᒄ ᐆ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ᒦᓐ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ, ᒑᑳᑦ ᒥᓯᐙ ᐋ ᐃᑎᔑᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᓂᔥᑐᐎᒡ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᐹᒋ ᓂᑐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᒥᐦᒑᑐ ᐄᔨᔨᐤ ᐋ ᐐᐦ ᓂᑑᐦᑎᒥᔨᒡ, ᓈᔥᒡ ᒌ ᐅᐦᑖᔨᐦᑎᒧᒡ᙮ ᒌ ᓂᔅᒀᔑᐦᐋᐅᒡ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᑆᓪ ᑭᔮᐦ ᒌ ᒫᔮᔨᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ᒥᒄ ᒫᒃ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐋᐦᒡ ᒌ ᓲᐦᒑᔨᒨᒡ ᐋᐦ ᐄᑖᒡ, “ᒋᔖᒥᓂᑑ ᓂᒌ ᓂᑎᐙᔨᒥᑯᓈᓐ ᒌᔨᐙᐤ ᒎᐤ ᐄᔨᔨᐅᒡ ᓃᔥᑎᒻ ᒑ ᒌ ᐐᐦᑎᒫᑖᐦᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔨᒧᐎᓐᐦ᙮ ᒥᒄ ᒫᒃ ᐋᐦ ᐋᓍᔨᐦᑎᒫᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᓅᑯᐦᒡ ᐋᐦᐋᑳ ᑖᐱᒑᔨᐦᑖᑯᓯᔮᒄ ᒑ ᒌ ᐃᔮᔮᒄ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮ ᐋᒄ ᒫᒃ ᒑ ᓂᑭᑎᑖᐦᒡ ᓂᑭᑎᑐᐎᒡ, ᒑ ᓂᑑᐐᐦᑎᒧᐎᒋᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑳᐦ ᐄᑎᔓᒥᔨᒥᐦᑦ ᒑ ᒌᐦ ᑎᔮᐦᒡ ᑳᐦ ᐃᔨᑦ, ᒋᒌ ᐅᐙᔮᐱᒥᑎᓐ ᒑ ᒌ ᐙᔥᑐᐎᓂᔨᐎᓐ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ, ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓂᑖᐦ ᐙᐦᒋ ᐱᒫᒋᐦᐄᐙᑦ ᒋᔖᒥᓂᑑ᙮ ᒥᓯᐙ ᒫᒃ ᐋᔅᐱᑎᔅᑭᒥᑳᐦᒡ ᐅᑎᐦ ᐊᔅᒌ ᒋᑭ ᐹᐦᑖᑯᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ᐄᔥᐱᐦ ᐱᔮᐦᑎᐙᒡ ᑆᓪ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᓄᐎᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᑭᔮᐦ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑᐦ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐱᒋᔅᑎᓂᒥᔨᒡ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐅᐙᔮᐱᒥᑯᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐃᔮᒡ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ ᒌ ᒋᐦᒋ ᑖᑆᔮᔨᒫᐅᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ᐋᒄ ᒫᒃ ᓈᓈᓂᒌᒻ ᒥᔑᐦᑖ ᑳᐦ ᐋᑎ ᐹᐦᑖᑯᓃᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔨᒧᐎᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ᒥᒄ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌᐦ ᑐᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ ᑭᔮᐦ ᐃᔅᒀᐤᐦ ᓈᔥᒡ ᑳ ᒋᔅᑖᔨᒫᑭᓂᐎᔨᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᒑ ᒌ ᒋᔑᐙᓰᔅᑐᐙᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐋᑆᔅᑎᓪᐦ ᑭᔮᐦ ᒑ ᒌ ᓂᓈᐦᑳᒋᐦᐋᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒌ ᐎᔨᐐᑎᔑᐦᐅᐙᐅᒡ ᐊᓂᔮ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ᒌ ᐱᐦᐱᐅᓯᑖᔑᒨᒡ ᒫᒃ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐋ ᐙᐱᐦᑎᔨᐙᒡ ᐋᑳ ᒦᓐ ᒑ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐋᑳ ᑳ ᐅᐦᒋ ᐐᐦ ᑖᑆᐦᑎᒥᔨᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᐋᒄ ᐊᓂᑖᐦ ᐋᐃᒀᓃᔨᒥᐦᒡ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ᐊᓂᒌ ᒫᒃ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳᐦ ᑖᒡ ᓈᔥᑖᑆᐦ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᑭᔮᐦ ᒌ ᓵᑭᔅᒋᓈᔥᑳᑯᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ᐋᐅᒄ ᐊᔮᐱᒡ ᑳ ᐄᔅᐱᔨᒡ ᑳ ᑎᑯᔑᐦᒡ ᐊᓂᑖᐦ ᐋᐃᒀᓃᔨᒥᐦᒡ, ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᒌ ᐲᐦᒑᐅᒡ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᓲᐦᒋᐦᑖᑯᓯᒡ ᐋ ᑭᒑᔅᒀᒡ ᒥᐦᒑᑐ ᒎᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᑖᑆᐦᑎᐦᒡ, ᒌᐦ ᑐᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒑ ᒌ ᐎᔮᔅᑖᔨᒫᔨᒡ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐤ ᐐᒋᔖᓂᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ᓈᐅᔥ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ᙮ ᒌ ᐋᔨᒨᒫᐅᒡ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋᐦᐋᑳ ᒥᑐᓐ ᑯᔥᑖᒋᒡ᙮ ᐋᒄ ᒫᒃ ᑳ ᒥᔨᑯᒡ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑏᐙᐎᓐ ᒑ ᒌ ᐙᐱᐦᑎᔨᐙᒡ ᑭᔮᐦ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᔨᒡ ᒑᒀᔨᐤ, ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᓅᑯᐦᑖᑭᓂᐎᔨᒡ ᐋ ᑖᑆᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᐙᐐᐦᑎᐦᒡ ᐋ ᐄᔑ ᒋᔖᐙᑐᑖᑎᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ᐋᒄ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᐱᐦᑳᓂᐦᐄᑑᒡ, ᐱᔅᒡ ᒌ ᑖᑆᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓕᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ, ᐋᒄ ᑯᑎᑭᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᑖᑆᐦᑎᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑭᔮᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑳᑯᒡ ᒌ ᑯᒀᑖᔨᑎᒧᒡ ᒑ ᒌ ᓂᓈᐦᑳᒋᐦᐋᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᒑ ᒌ ᓂᐱᐦᐋᒡ ᐋ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐋᑆᔅᑎᓕᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᐊᓂᑖᐦ ᓕᔅᑦᕌ ᑭᔮᐦ ᑎᕐᐲ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓐ ᒌ ᐄᑎᔓᒧᒡ᙮ ᐊᓂᑖᐦ ᓚᐃᒀᓂᔮ ᐊᔅᒌᐦᒡ ᒌᐦ ᑎᑯᓂᔨᐤ ᐅᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᐊᓂᑖᐦ ᑭᔮᐦ ᐙᔅᑳ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐋᑯᑖᐦ ᑳ ᐱᐹᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑳ ᐙᐐᐦᑎᐦᒡ ᐅᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ᐊᓂᑖᐦ ᒫᒃ ᓕᔅᑦᕌ ᒌᐦ ᑖᐤ ᐹᔨᒄ ᓈᐹᐤ ᐋ ᒌ ᒫᔅᑭᓃᔨᔨᒡ ᐅᓯᑦ ᐋᐦᐋᑳ ᐅᐦᒋ ᓂᐦᑖᐅᑖᑦ, ᔖᔥ ᑳ ᐃᓯᓈᑯᓯᑯᐱᓈ ᑳ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐋ ᐊᐱᑦ ᐊᓐ ᓈᐹᐤ ᒌ ᓂᑐᐦᑎᐙᐤ ᐊᓂᔮᔨᐤ ᑆᓪ ᐋ ᐊᔨᒥᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑆᓪ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐋ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤᐦ ᓈᐹᐤᐦ ᒑ ᒌ ᒦᓂᐙᒋᐦᐄᒫᑭᓂᐎᔨᒡ, ᑯᐃᔅᒄ ᒌ ᑭᓂᐙᐱᒫᐤ ");
INSERT INTO crl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐋ ᒋᔣᐙᑦ, “ᐱᓯᑰᐦ, ᔓᑐᑳᐳᐦ ᒫᒃ᙮” ᒌ ᐅᐦᒋ ᐱᓯᑯᔑᐲᐦᑖᐤ ᐊᓐ ᓈᐹᐤ, ᑳᐦ ᐋᑎ ᐱᐹᒧᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ᐄᔥᐱᐦ ᑳ ᐙᐱᐦᑎᐦᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑖᓐ ᑳᐦ ᑐᑎᒥᔨᒡ ᑆᓪ, ᒌ ᑖᑆᐅᒡ ᓚᐃᒀᓂᔮ ᐊᔨᒧᐎᓂᔨᐤ ᐋ ᐄᔑ ᐊᔨᒥᒡ, “ᒥᓂᑑᒡ ᑰᑎᐦᑎᑯᓂᐎᒡ ᒧᔮᒻ ᓈᐹᐅᒡ ᐋ ᐃᓯᓈᑯᓯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ᐊᓂᔮᔨᐤ ᐹᕐᓂᐱᔅ ᐋᐅᒄ ᐆ ᓲᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᑆᓪ ᐦᐁᕐᒣᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ᐙᔥ ᐊᓂᔮᔨᐤ ᑆᓪ ᒨᔥ ᐐᔨ ᐋ ᒌ ᐊᔨᒥᔨᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐄᑖᔨᒫᒡ ᐋᐦ ᐋᐎᔨᒡ ᐦᐁᕐᒣᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᐦ ᐋᐱᑎᔒᔥᑎᐙᑦ ᐊᓂᔮᔨᐤ ᓲᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᐊᓐ ᒫᒃ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᐊᓂᑖᐦ ᑳ ᒌ ᒫᒥᐦᒋᒫᑭᓅᑦ ᐆ ᓲᔅ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᒌ ᑎᑯᓐ᙮ ᐊᓐ ᒫᒃ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒌ ᐲᐦᑎᑭᐦᐋᐤ ᒥᔅᑐᔅ ᑭᔮᐦ ᓃᐲᔅ ᐊᓂᑖᐦ ᐋ ᐃᔥᒀᐦᑎᒥᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒑ ᒌ ᒥᒋᔥᑎᐦᐊᒫᓂᐎᔨᒡ᙮ ᒌᐦ ᑐᑎᒻ ᐅᔮᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒋᐐᐦ ᑐᑎᒥᔨᐤ ᐋ ᒌ ᐐᐦ ᒥᒋᔥᑎᐦᐋᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ᐄᔥᐱᐦ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᑳ ᒋᔅᒑᔨᒫᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒥᓂᑑᒡ ᐋ ᐐᐦ ᐄᑖᐱᒋᐦᐄᑯᒡ ᒌ ᐲᑯᐱᑎᒧᒡ ᐅᒑᒀᓂᒧᐙᐤ ᐋ ᓅᑯᐦᑖᒡ ᐋᐦᐋᑳ ᓂᐦᐋᔨᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐙᐦ ᐃᔨᐦᑎᔨᒡ, ᐋᒄ ᑳ ᐄᔥᐱᐦᐄᑐᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦ ᑖᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ ᐋ ᒋᔣᐙᒡ, ");
INSERT INTO crl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ᓈᐹᑐᒄ ᐊᑳᐐ ᑐᑎᒧᒄ ᐆ, ᓈᐹᐅᒡ ᐙᔥ ᑭᔮᐦ ᓃᔮᓐ ᒧᔮᒻ ᒌᔨᐙᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᔮᒄ ᐋᐅᒄ ᐋᑖᔨᐦᑖᑯᓯᔮᐦᒡ᙮ ᒋᐐᐦ ᐐᐦᑎᒫᑎᓈᓐ ᒥᔻᒋᒧᐎᓐ ᒑ ᒌ ᐅᐦᒋ ᐴᓂᐦᐋᑯᒡ ᐋ ᐊᔨᒥᐦᐋᔥᑎᐙᑯᒡ ᐊᓂᒌ ᓂᑎᐐ ᒥᒄ ᒥᓂᑑᐦᑳᓂᒡ, ᐋᐦᐋᑳ ᒑᒀᓐ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ᒦᔥᑯᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᑳ ᐱᒫᑎᓰᑦ ᐋᐦ ᑖᑦ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᔮᒄ, ᐊᓐ ᑳ ᐅᔑᐦᑖᑦ ᒋᐦᒋᒌᔑᑯᔨᐤ, ᐊᔅᒌᔨᐤ, ᒋᐦᒋᑭᒥᔨᐤ ᑭᔮᐦ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᐱᒫᑎᓰᒥᑭᓃᔨᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒌ ᐱᒋᔅᑎᓈᐤ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᐊᔨᒥᐦᐋᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ᐊᔮᐱᒡ ᒫᒃ ᒋᔖᒥᓂᑑ ᒨᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐋᐤ ᐄᔨᔨᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳ ᐄᔑ ᒥᔪᑐᑎᐦᒃ, ᒧᔮᒻ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᒌ ᑐᑎᒫᑯᐙᐤ ᒑ ᒌ ᒋᒨᓃᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᓂᐦᑖᐅᒋᓃᔨᒡ ᒦᒋᒥᔨᐤ᙮ ᒋᒌ ᒥᔨᑯᐙᐤ ᒦᒋᒥᔨᐤ ᑭᔮᐦ ᒋᑎᐦᑐᑖᑯᐙᐤ ᒑ ᒌ ᒥᔻᔨᐦᑎᒸᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ᐋᑦ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔑ ᐐᐦᑎᒧᐙᑭᓂᐎᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᐊᔮᐱᒡ ᒋᐐᐦ ᓂᐱᐦᐋᐅᒡ ᒥᔅᑐᔥᐦ ᒑ ᒌ ᒥᒋᔥᑖᐦᐋᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ᙮ ᒑᒃ ᒫᒃ ᑳ ᔑᐦᑯᒋᒥᑯᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᐋᑳ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ᐱᔅᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᐊᓐ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᐱᓯᑎᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᑖᐦ ᐋᐃᒀᓃᔨᒻ ᒌ ᐅᐦᑐᐦᑖᐅᒡ, ᐋᒄ ᑳ ᔑᐦᑯᒋᒫᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐐᒋᐦᐄᑯᒡ ᐋ ᐐᐦ ᓂᐱᐦᐋᒡ ᑆᓪ᙮ ᐋᒄ ᑳ ᐹᐦᐱᒧᓯᓈᑎᐦᐙᒡ ᑭᔮᐦ ᑳ ᐎᔨᐐᑖᐹᑖᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋ ᒌ ᐄᑖᔨᒫᒡ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᑳ ᐙᔅᑳᑳᐳᔥᑎᐙᒡ ᐊᓂᔮᔨᐤ ᑆᓪ, ᒌ ᐎᓂᔥᑳᐤ ᑆᓪ, ᐋᒄ ᒦᓐ ᑳᐤ ᑳ ᐲᐦᒑᑦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᒦᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᐎᔮᐱᓃᔨᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐊᓂᑖᐦ ᑎᕐᐲᐦᒡ ᒌ ᐄᑐᐦᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᒌ ᐙᐐᐦᑎᒧᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᑎᕐᐲ, ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᑖᑆᔮᔨᒫᔨᐤ ᒌᓴᔅᐦ᙮ ᐋᒄ ᒦᓐ ᑳᐤ ᐊᓂᑖᐦ ᓕᔅᑦᕌ ᑳ ᐄᑐᐦᑖᒡ, ᒦᓐ ᐊᓂᑖᐦ ᐋᐃᒀᓃᔨᒥᐦᒡ, ᐋᒄ ᒦᓐ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐊᔨᒥᐦᐋᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐋ ᔒᐦᒋᒫᒡ ᒑ ᒌ ᒥᒫᒋᑯᓂᒥᔨᒡ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᒌ ᐄᑖᐅᒡ ᑭᔮᐦ ᐋ ᓂᑎᐙᔨᐦᑖᑯᓃᔨᒡ ᐊᐙᓐ ᒑ ᒌ ᓂᒋᔥᑭᐦᒃ ᓂᓈᐦᑭᐤ ᒑᒀᔨᐤ ᐋᐦ ᐋᔨᒥᓂᔨᒡ ᐋᒄ ᒑ ᒌ ᐲᐦᒑᑦ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ᐋᒄ ᒫᒃ ᒥᓯᐙ ᒥᒄ ᐊᓂᑎᐦ ᑳᐦ ᐋᑎ ᑖᔨᔨᒡ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ, ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᒌ ᐎᔮᔨᒫᐅᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒋᔑᐦᑖᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᒦᒋᓱᒡ ᒥᒄ ᐋ ᐊᔨᒥᐦᐋᒡ, ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᒡ ᒑ ᒌ ᐋᐱᒋᐦᐄᑯᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐊᓂᔮᔨᐤ ᔖᔥ ᑏᔮᑆᔮᔨᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᔖᐳᑐᐙᔥᑭᐦᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐱᓯᑎᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᒄ ᐊᓂᑖᐦ ᐹᒻᕕᓕᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᑳ ᐲᐦᒑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ᑳ ᐙᐐᐦᑎᐦᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᐊᓂᑖᐦ ᐯᕐᑳᐦᒡ᙮ ᐋᒄ ᒦᓐ ᐊᓂᑖᐦ ᐋᑖᓕᔮᐦᒡ ᑳ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᐅᐦᒋ ᑳᐤ ᑳ ᐃᔅᒋᒫᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒋᐦᒋᑎᔑᐦᐙᑭᓂᐎᒡ᙮ ᐋᔥᒄ ᒫᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᑐᐦᑖᒡ, ᒌ ᐊᔨᒥᐦᐋᔥᑎᒫᑯᒡ ᐄᔨᔨᐤ ᒑ ᒌ ᒋᔖᐙᑐᑖᒥᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐋᐱᑎᓰᐎᓂᔨᐤ ᐊᓅᐦᒡ ᑳ ᒌᔅᑐᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ᐄᔥᐱᐦ ᒫᒃ ᑳᐤ ᒫᓯᑳᒡ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᒌ ᓂᔥᑑᓈᐅᒡ ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᐅᒫᒨᐊᔨᒥᐦᐋᐤᐦ ᐋ ᐙᐐᐦᑎᒧᐙᒡ ᑖᓐ ᑳᐦ ᑐᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐐᔨᐙᐤ ᐋ ᒌ ᐋᐱᒋᐦᐄᑯᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᐐᐦᑎᒫᑯᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᒋᔖᒥᓂᑑ ᒌ ᑐᑖᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᒑ ᒌ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᑳᐦ ᑖᒡ ᓈᐅᔥ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ᐱᔅᒡ ᒫᒃ ᓈᐹᐅᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᒌ ᐅᐦᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳ ᐲᐦᒑᒡ ᑳᐦ ᐋᑎ ᒋᔅᒋᓂᐦᐊᒧᐙᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ, ᐋᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᒋᑭ ᒌ ᐱᒫᒋᐦᐅᓈᐙᐤ ᐹᑎᔥ ᒋᔅᒋᓄᐙᒋᔓᑯᔮᒀ ᐙᔥ ᐋᔪᐎᒄ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᒌ ᓂᔥᑰᔥᑐᐙᐅᒡ ᑭᔮᐦ ᓲᐦᒃ ᒋᐐᐦ ᐙᐱᐦᑎᔮᐅᒡ ᑖᑆᐦ ᐋ ᐎᓂᐱᔨᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐋᐦ ᐄᔨᔨᒡ᙮ ᐋᒄ ᑳ ᐎᔮᔨᐦᑖᑭᓂᐎᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᑎᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳ ᐅᐦᒌᒡ ᒑ ᒌ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᓂᑑᑯᒀᒋᒫᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᑖᓐ ᐋᑖᔨᐦᑎᒥᐦᐄᑯᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ᐄᔅᑉ ᑳ ᒋᐦᒋᔅᑎᓲᐦᐆᑯᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ, ᕛᓃᓰᔮ ᑭᔮᐦ ᓵᒫᕆᔮ ᒌ ᔖᐳᑐᐙᔥᑭᒧᒡ ᐋ ᐙᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᐋ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ, ᑳ ᒀᔅᑳᑎᓰᒡ᙮ ᓈᔥᑖᑆᐦ ᒌ ᒥᔻᔨᐦᑎᒥᔨᐤ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᐤ ᐐᒋᔖᓂᒫᐤ ᐄᔥᐱᐦ ᐱᔮᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᓈᔥᒡ ᒌ ᓯᒋᔮᔅᑯᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋᑆᔅᑎᓪᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ, ᐋᒄ ᑳ ᐙᐐᐦᑎᒧᐙᒡ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᐦᒋ ᐐᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ᒥᒄ ᒫᒃ, ᐱᔅᒡ ᐊᓂᒌ ᐹᕆᓰᒡ ᑳ ᑖᑆᐦᑎᐦᒡ, ᐄᔥᐱᐦ ᐱᔮᐦᑎᐙᒡ ᑆᓪ ᐋ ᐐᐦᑎᒥᔨᒡ ᐋ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ, ᒌ ᐅᐦᒋ ᐱᓯᑯᒡ ᐋᐦ ᐄᑖᒡ, “ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᑭᔨᑆ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓂᐎᒡ ᐐᔨᐙᐤ ᑭᔮᐦ ᒋᐱᐦ ᐄᑖᑭᓂᐎᒡ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᒸᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ᐋᒄ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐦᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒌ ᓂᔥᑐᐎᒡ ᐋᐦ ᐋᔨᒸᐦᐄᑯᒡ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑯᒀᒋᒑᔨᒧᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ᓈᐅᔥ ᒫᒃ ᒌ ᐋᔨᒸᐦᐄᑯᒡ ᐅᔮᔨᐤ ᐋᒄ ᐲᑎᕐ ᑳ ᐅᐦᒋ ᐱᓯᑯᑦ ᐋᐦ ᐃᔨᑦ, “ᓃᒋᔖᓂᑎᒄ, ᒋᒋᔥᒋᓯᓈᐙᐤ ᔖᔥ ᐙᔅᑭᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐅᐙᔮᐱᒥᑦ ᒑ ᒌ ᐙᐐᐦᑎᒨᒀᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ, ᒑ ᒌ ᐅᐦᒋ ᐹᐦᑎᐦᒡ ᐋᒄ ᒫᒃ ᒑ ᒌ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ᒋᔖᒥᓂᑑ ᒫᒃ ᒋᔅᒑᔨᒫᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ᙮ ᒌ ᓅᑯᐦᑖᐤ ᐋ ᓂᑎᐙᔨᒫᑦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒑ ᒌ ᑖᑆᔮᔨᒥᑯᑦ ᒧᔮᒻ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ, ᐙᔥ ᒌ ᒥᔮᐤ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒧᔮᒻ ᒌᔮᓂᐤ ᑳ ᐄᔑ ᒥᔨᑎᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐙᐱᐦᑏᐙᑦ ᐋᐦᐋᑳ ᐃᔨᐦᒡ ᐄᑖᔨᒫᑦ ᐊᐙᔨᐤᐦ᙮ ᒌ ᐱᔮᐦᒋᐦᐋᐤ ᐋ ᐙᐹᔨᐦᑎᒧᐙᑦ ᐅᒥᒋᐦᑣᐎᓂᔨᐤ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ᒧᔮᒻ ᐋ ᐐᐦ ᑯᒀᒋᐦᐋᒄ ᒋᔖᒥᓂᑑ ᐋᐅᒄ ᐋᐦ ᑎᔮᒄ᙮ ᒋᑎᔨᒥᐦᐋᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐋ ᔒᐦᒋᒫᑯᒡ ᐅᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ ᐙᐙᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐋᐦᐋᑳ ᐅᐦᒌ ᑐᑎᐦᒡ ᑭᔮᐦ ᒫᒃ ᒌᔮᓂᐤ ᐋᐦᐋᑳ ᐙᐙᒡ ᒌᐦ ᑐᑎᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ᒌ ᑖᑆᐦᑖᓈᓂᐤ ᒫᒃ ᐋ ᐱᒫᒋᐦᐄᑎᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᐅᒥᔪᐦᑳᒑᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐋᔪᐎᒄ ᒫᒃ ᑭᔮᐦ ᐐᔨᐙᐤ ᐅᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᐄᔑ ᐱᒫᒋᐦᐄᑯᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑑ ᒥᒄ ᒌ ᓂᑐᐦᑎᐙᐅᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐋ ᐐᐦᑎᒥᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔥᑳᒡ ᐙᐱᐦᑎᔨᐙᔨᒡ ᒋᔖᒥᓂᑑ ᐙᐱᐦᑏᐙᐎᓐ, ᑭᔮᐦ ᒫᒃ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᔨᒡ ᐋ ᒫᒥᔥᑳᑖᔨᐦᑖᑯᓃᔨᔨᒡ ᒑᒀᔨᐤ ᐐᔨᐙᐤ ᐅᐦᒋ ᐊᓂᑖᐦ ᐄᔨᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᑎᐹᒋᒧᔨᒡ, ᐋᒄ ᒉᒥᔅ ᑳ ᐱᓯᑯᑦ ᐋᐦ ᐃᔨᑦ, “ᓂᑐᐦᑎᒧᒄ ᒫᐦ, ᓃᒋᔖᓂᑎᒄ, ");
INSERT INTO crl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ᓵᐃᒥᓐ ᐲᑎᕐ ᒋᒌ ᐐᐦᑎᒫᑭᓂᐤ ᑖᓐ ᑳᐦ ᑎᒃ ᒋᔖᒥᓂᑑ ᓃᔥᑎᒻ ᑳ ᐙᐱᐦᑏᐙᑦ ᐋᐦᐋᑳ ᒥᒄ ᒎᐄᔨᔨᐤ ᐅᐦᒋ ᐅᐙᔮᐱᒫᑦ, ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᑭᔮᐦ ᒌ ᐅᐙᔮᐱᒫᐤ ᒑ ᒌ ᐅᑏᔨᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ᐋᐅᒄ ᒧᔮᒻ ᑳᐦ ᐄᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ, ");
INSERT INTO crl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ᐹᑎᒫ ᒦᓐ ᓂᑭ ᑎᑯᔑᓐ ᐋᒄ ᒑ ᐅᐦᐱᑳᐳᐦᐄᒀᐤ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᐋᐦ ᑖᔨᒡ ᑳ ᐎᐦᑎᔅᑳᓈᓯᒡ ᐊᓂᒌ ᐋ ᒌ ᐱᐦᒋᔑᒡ᙮ ᒦᓐ ᓂᑭ ᐅᐦᐱᑳᑑᐦᑖᐙᓐ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐃᔮᔪᐦᑖᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᑌᕕᑦ ᐆ ᒋᐦᒋᐅᒋᒫᐎᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᐅᐦᒋ ᓈᓂᑎᐙᔨᒫᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᒌ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ, ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑳ ᐅᐙᔮᐱᒥᒀᐤ ᒑ ᐅᑏᔨᔨᒥᔮᓐ, ᑳᐦ ᐃᔨᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ");
INSERT INTO crl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ᐊᓐ ᐙᔥᑭᒡ ᑳ ᒋᔅᒑᔨᐦᑖᑯᐦᑖᑦ ᐅᔮᔨᐤ ᐋ ᒌ ᐄᔑ ᐎᔮᔨᐦᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ᐋᒄ ᒉᒥᔅ ᑳᐦ ᐄᑖᑦ ᒦᓐ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᓂᑎᑖᔨᐦᑖᓐ ᓃᔨ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ, ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐋᔨᐦᑭᒥᐦᐋᑭᓂᐎᒡ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ᒋᐱᐦ ᒥᓯᓂᐦᐋᒧᐙᓂᐎᒡ ᐅᒌ ᐋ ᐐᐦᑎᒨᑯᐦᒡ ᐅᔮᔨᐤ ᒑ ᒌ ᐄᔑ ᓈᓈᑭᑐᐙᔨᐦᑎᐦᒡ᙮ ᐋᑳ ᒑ ᒌ ᒧᐙᒡ ᐊᐅᐦᑳᓐ ᐋ ᒌ ᒥᒋᔥᑖᐦᐋᒧᐙᑭᓂᐎᔨᒡ ᒥᓂᑑᐦᑳᓐ, ᑭᔮᐦ ᐊᐅᐦᑳᓐ ᐋ ᒌ ᒋᐳᑖᒫᐱᐦᑳᑎᒫᑭᓂᐎᔨᒡ ᒫᒃ ᑭᔮᐦ ᒥᐦᑯᔨᐤ ᒑ ᒌ ᒦᒋᒡ ᑭᔮᐦ ᒫᒃ ᐋᑳ ᐐᓂᓱᐎᓂᒡ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ᐙᔥ ᐋᐅᒄ ᐆ ᔖᔥ ᐙᔥᑭᒡ ᑳ ᐄᔑ ᐹᒋ ᑭᒑᔅᒀᓂᐎᒡ ᑭᔮᐦ ᐃᔮᔨᒨᑎᑭᓂᐎᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓐ ᐊᓂᑖᐦ ᒥᓯᐙ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᓂᑎᐦ ᒥᓯᐙ ᐃᐦᑖᐎᓐ ᐊᐦᑎᐦᒡ ᐋᔑᑯᒻ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ᐋᒄ ᐊᓂᒌ ᐋᑆᔅᑎᓕᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᒌ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᒌ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑯᒡ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᒉᒥᔅ ᐋᒄ ᑳ ᐎᔮᔨᒫᒡ ᓃᔓ ᓈᐹᐤ ᒑ ᒌ ᐐᒑᐙᔨᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐋ ᓂᑎᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ᐋᔨᐅᑯᓂᒡ ᒫᒃ ᐅᒌ ᐊᓂᑖᐦ ᑳ ᐄᑎᔑᐦᐙᑭᓂᐎᒡ, ᒍᑖᔅ, ᐊᓐ ᐹᕐᓵᐹᔅ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᑭᔮᐦ ᓵᐃᓚᔅ᙮ ᒌ ᐐᒋᐦᐄᐙᐅᒡ ᐋ ᓃᑳᓂᔥᑳᒫᑭᓂᐎᔨᒡ ᐐᒋᔖᓂᒫᐤ ᐅᒌ ᓈᐹᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᒌ ᒥᔮᑭᓂᐎᒡ ᒑ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᐊᓂᑖᐦ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᐋᐦ ᑖᔨᒡ᙮ ᒌ ᐄᑎᔅᑖᔨᐤ ᒫᒃ ᐊᓂᑎᐦ, “ᐙᒋᔮᐦ, ᓃᔮᓐ ᐋᑆᔅᑎᓕᒡ, ᑭᔮᐦ ᓃᔮᓐ ᑳ ᓃᑳᓂᔥᑭᒫᐦᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ, ᒋᒥᓯᓂᐦᐋᒫᑎᓈᓐ ᒌᔨᐙᐤ ᓃᒋᔖᓈᓂᒡ ᑳ ᑖᑆᐦᑎᒫᒄ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ, ᒌᔨᐙᐤ ᑳ ᐐᒋᔮᒄ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ, ᓯᕆᔮᐦᒡ ᐊᔅᒌᐦᒡ, ᑭᔮᐦ ᓯᓕᓯᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ᓂᒌ ᐹᐦᑖᓈᓐ ᐱᔅᒡ ᓈᐹᐅᒡ ᐅᑎᐦ ᐋ ᐅᐦᒋᔮᐦᒡ ᐋ ᐅᐦᒌᒡ ᐋ ᒌ ᓂᑎᐙᐱᒥᑖᑯᒡ ᑭᔮᐦ ᐋ ᒌ ᒋᔅᑯᑎᒫᑖᑯᒡ ᒑᒀᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐋᔨᒫᔨᐦᑎᒸᒄ ᑭᔮᐦ ᐎᔅᑐᐙᔨᐦᑎᒸᒄ᙮ ᓂᒧᐃ ᒫᒃ ᓃᔮᓐ ᓅᐦᒋ ᐄᑎᔓᒫᓈᓂᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᐦᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᓂᔥᑐᐎᔮᐦᒡ ᐅᑎᐦ, ᒥᓯᐙ ᓂᒌ ᐎᔮᔨᐦᑖᓈᓐ ᒫᒃ ᒑ ᒌ ᐄᑎᔓᐦᐅᒋᐦᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐋᐦᑖᐙᒄ᙮ ᑭᑎ ᐹᒋ ᐐᒑᐙᐅᒡ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ, ᐊᓂᔮᔨᐤ ᓂᐐᒑᐙᑭᓈᓐ ᑳ ᓵᒋᐦᐄᒥᒋᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ᐅᒌ ᒫᒃ ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ, ᐋᐦ ᐋᑎ ᒌᑯᔅᑖᑖᔮᔨᐦᑖᑯᓃᔨᒡ ᒫᓐ, ᒑᑳᑦ ᐋ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ, ᓂᒧᐃ ᐊᔮᐱᒡ ᐅᐦᒋ ᐴᓃᐅᒡ ᐋᐦ ᐋᐱᑎᔒᔥᑑᐙᒡ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ᐋᒄ ᒫᒃ ᒍᑖᔅ ᑭᔮᐦ ᓵᐃᓚᔅ ᓂᒌᐦ ᐄᑎᔑᐦᐙᓈᓂᒡ ᐐᔨᐙᐤ ᑎᐲᐙ ᒑ ᒌ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓐ ᐋ ᐄᔑ ᒥᓯᓂᐦᐋᒫᑖᐦᒡ ᐅᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ᑖᐱᔥᑯᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᑭᔮᐦ ᓃᔮᓐ ᓂᒌ ᓂᐦᐋᔨᐦᑖᓈᓐ ᐋᑳ ᒑ ᒌ ᐋᔨᒫᔨᐦᑎᒥᐦᐄᑖᐦᒡ ᒥᒄ ᒫᒃ ᐋᐅᒄ ᐆ ᓈᑎᐙᔨᒥᑖᐦᒡ ᒑ ᒌ ᑭᓂᐙᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ᐋᑳ ᒑ ᒌ ᒧᐙᒄ ᐊᐅᐦᑳᓐ ᐋ ᒌ ᒥᒋᔥᑎᐦᐋᒧᐙᑭᓅᑦ ᒥᓂᑑᐦᑳᓐ, ᐋᑳ ᒑ ᒌ ᒦᒋᔮᒄ ᒥᐦᒄ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᒧᐙᑯᒡ ᐊᓂᒌ ᐊᐅᐦᑳᓂᒡ ᐋ ᒌ ᒋᐳᑖᒸᐱᐦᑳᑖᑭᓂᐎᒡ ᑭᔮᐦ ᐋᑳ ᐐᓂᓱᐎᓂᒡ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᔮᒄ᙮ ᒋᑭ ᒥᔪᐱᔨᓈᐙᐤ ᑐᑎᒫᒀ ᐆ ᑳᐦ ᐄᑎᔓᒥᑖᐦᒡ᙮ ᒋᐙᒋᔮᒥᑎᓈᓐ ᒫᒃ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ᐄᔥᐱᐦ ᑳ ᒋᐦᒋᑎᔑᐦᐙᑭᓂᐎᒡ ᐊᓂᒌ ᑆᓪ, ᐹᕐᓂᐱᔅ, ᒍᑖᔅ ᑭᔮᐦ ᓵᐃᓚᔅ, ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᒌ ᐹᒋ ᐄᑐᐦᑖᐅᒡ᙮ ᐋᒄ ᑳ ᓂᔥᑑᓈᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐋᒄ ᑳ ᒥᔮᒡ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ ᑳ ᒥᓯᓂᐦᐋᒫᑭᓂᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᑳ ᐊᔨᒥᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ, ᒥᓯᐙ ᒌ ᒥᔻᔨᐦᑎᒨᒡ ᑭᔮᐦ ᒌ ᐅᐦᐱᓂᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ᒍᑖᔅ ᑭᔮᐦ ᓵᐃᓚᔅ ᐋ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᐐᔨᐙᐤ, ᓈᐅᔥ ᒌ ᐊᔨᒥᐦᐋᐅᒡ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᒫᐤ, ᐋᒄ ᒫᒃ ᑳᐦ ᐋᑎ ᐆᐦᐱᓈᒡ ᐊᑎᑎᐤ ᑳᐦ ᐋᑎ ᒥᔥᑭᐎᑳᐳᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐋᒄ ᑳ ᒌᐙᒡ ᐊᓂᑖᐦ ᐄᔑ ᑳ ᐅᐦᒋ ᐄᑎᔑᐦᐙᑭᓂᐎᒡ᙮ ᒌ ᐊᔨᒥᐦᐋᔥᑎᒫᑯᒡ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᒫᐤ ᒑ ᒌ ᒥᔪ ᑭᓂᐙᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ᓵᐃᓚᔅ ᒫᒃ ᒌ ᐎᔮᔨᐦᑎᒻ ᐋᑎ ᒑ ᑖᑦ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ᑆᓪ ᑭᔮᐦ ᐹᕐᓂᐱᔅ ᐋᑯᑖᐦ ᑭᔮᐦ ᐐᔨᐙᐤ ᑳᐦ ᑖᒡ ᐊᓂᑎᐦ ᐋᓐᑎᔻᑭᐦᒡ᙮ ᒌ ᒋᔅᑯᑎᒫᒑᐅᒡ ᑭᔮᐦ ᒌ ᑭᒑᔅᒀᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᐋᐦ ᐋᔨᒨᑎᐦᒡ᙮ ᒥᐦᒑᑐ ᑭᔮᐦ ᑯᑎᒃ ᐊᓂᑎᐦ ᑳᐦ ᑖᔨᒡ ᐋᔪᐎᒄ ᑳᐦ ᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ᐹᑎᒫ ᒫᒃ ᑆᓪ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᐹᕐᓂᐱᔅ, “ᑳᐤ ᒫᐦ ᐄᑐᐦᑖᑖᐤ ᐊᓂᑖᐦ ᐊᓂᐦᐄ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᑳ ᐙᐐᐦᑎᒥᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᒥᔻᒋᒧᐎᓐ, ᒑ ᓂᑎᐙᐦᐄᑯᒡ ᒫᔫᐱᔨᐙᒀ ᐊᓂᒌ ᒌᒋᔖᓅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ᐋᒄ ᐹᕐᓂᐱᔅ ᑳ ᐐᐦ ᒋᔅᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒞᓐ ᒫᕐᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ᒥᒄ ᒫᒃ ᑆᓪ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᒋᔅᑐᐦᑎᐦᐋᐤ ᐐᔨ, ᐙᔥ ᒌ ᓂᑭᑎᑯᒡ ᒞᓐ ᒫᕐᒃ ᐊᓂᑖᐦ ᐹᒻᕕᓕᔮᐦᒡ ᑳᐦ ᑖᒡ ᓅᐦᑎ ᐋ ᒌ ᐴᓃᔨᒡ ᐋᔥᒄ ᐋᑳ ᐅᐦᒋ ᒋᔑᐦᑖᒡ ᐅᑖᐱᑎᓰᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ᐋᒄ ᑳ ᐎᔥᑖᐱᔨᔨᒡ ᐹᕐᓂᐱᔅ ᑭᔮᐦ ᑆᓪ ᐅᔮᔨᐤ ᐅᐦᒋ, ᐋᒄ ᐹᐱᐦᑳᓐ ᑳ ᐄᑐᐦᑖᒡ᙮ ᐹᕐᓂᐱᔅ ᒌ ᒋᔅᑐᐦᑎᐦᐋᐤ ᐊᓂᔮᔨᐤ ᒞᓐ ᒫᕐᒃ, ᐊᓂᑖᐦ ᓵᐃᑉᕋᔅ ᐋᑯᑖᐦ ᑳ ᐄᑖᔑᒡ ᒌᒫᓂᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ᐋᒄ ᐐᔨ ᑆᓪ, ᐊᓂᔮᔨᐤ ᓵᐃᓚᔅ ᒌ ᒋᔅᑐᐦᑎᐦᐋᐤ᙮ ᐋᒄ ᐊᓂᒌ ᐐᒋᔖᓂᒫᐅᒡ ᐊᓂᑎᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳᐦ ᑖᒡ ᑳ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᒡ ᒑ ᒌ ᑭᓄᐙᔨᒥᑯᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ᐋᒄ ᐊᓂᑖᐦ ᓯᕆᔮᐦᒡ ᐊᔅᒌᐦᒡ ᑭᔮᐦ ᓯᓕᓯᔮᐦᒡ ᑳ ᐄᑐᐦᑖᑦ ᑆᓪ, ᒥᓯᐙ ᒫᒃ ᑖᓂᑖᐦ ᑳᐦ ᐋᑎ ᐊᔨᒥᐦᐋᑦ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᒥᓯᐙ ᒌ ᐐᒋᐦᐋᐤ ᒑ ᒌ ᒥᔥᑭᐎᑳᐳᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ᐋᒄ ᑆᓪ ᐊᓂᑖᐦ ᑎᕐᐲᐦᒡ ᑭᔮᐦ ᓕᔅᑦᕋᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ᒌᐦ ᑖᐤ ᐊᓂᑖᐦ ᓈᐹᐤ ᐋ ᑖᑆᔮᔨᒫᑦ ᒌᓴᔅᐦ, ᑎᒧᕢ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᐅᑳᐐᐦ ᑭᔮᐦ ᒌ ᑖᑆᔮᔨᒫᔨᐤ ᒌᓴᔅᐦ᙮ ᒎᐤ ᒌ ᐄᑎᔅᑳᓈᓯᔨᐤ ᐅᔮᔨᐤ ᐅᑳᐐᐦ ᐋᒄ ᐅᐦᑖᐐᐦ ᒃᕇᒃ ᒌ ᐄᑎᔅᑳᓈᓯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ᑎᒧᕢ ᒫᒃ ᒥᓯᐙ ᒌ ᒥᔻᒋᒥᑰ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᓕᔅᑦᕋᐦᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐋᐃᒀᓃᔨᒥᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ᑆᓪ ᒌ ᓂᑎᐙᔨᒫᐤ ᐊᓂᔮᔨᐤ ᑎᒧᕢ ᒑ ᒌ ᐐᒑᐅᑯᑦ, ᐱᑎᒫ ᒫᒃ ᒌ ᒋᔅᒋᓄᐙᒋᔣᐤ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᑐᑎᐙᑦ ᐋ ᓅᑰᐦᑖᑦ ᐋ ᒋᔥᑖᔨᒫᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᓂᑖᐦ ᑳ ᐐᒋᔨᒡ ᐙᔥ ᒌ ᒋᔅᒑᔨᒫᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᑎᒧᕢ ᐅᐦᑖᐐᔨᐤ ᒃᕇᒃ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐊᒋᓈᔅᑭᐦᒡ ᐃᐦᑖᐎᓐ ᒌ ᐙᐐᐦᑎᒧᐙᐅᒡ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᑖᓐ ᑳ ᐄᔑ ᐎᔮᔨᐦᑎᒥᔨᒡ ᐋᑆᔅᑎᓪᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑖᓐ ᒑ ᐄᔑ ᓂᓃᐦᑎᒥᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ᐋᒄ ᐊᓂᒌ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ ᓈᓈᓂᒌᒻ ᒌ ᐋᑎ ᔮᐃᒋᑳᐳᐎᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ ᐄᔑ ᑭᔮᐦ ᑎᐦᑣ ᐋ ᒌᔑᑳᔨᒡ ᒌ ᐋᑎ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ᐋᒄ ᐊᓂᑖᐦ ᕝᕆᑭᔮᐦ ᑭᔮᐦ ᑳᓓᓰᔮ ᐊᔅᒌᐦᒡ ᑳ ᐄᑐᐦᑖᒡ, ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐋ ᒌ ᒋᔅᑎᐦᐋᒫᑯᒡ ᒑ ᒌ ᐙᐐᐦᑎᐦᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ᐄᔥᐱᐦ ᐹᔓᒡ ᐋᐦᑖᐦᒡ ᒫᐃᓯᔮ ᐊᔅᒌᔨᐤ, ᒋᐐᐦ ᐲᐦᒑᐅᒡ ᐱᑎᓂᔮ ᐊᔅᒌᐦᒡ ᒥᒄ ᒫᒃ ᒌᓴᔅᐦ ᐅᑎᐦᒑᐦᑯᔨᐤ ᒌ ᒋᔅᑎᐦᐋᒫᑯᒡ ᒑ ᒌ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ᐋᒄ ᑳ ᓵᐳᐦᑎᐙᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒫᐃᓯᔮ ᐊᔅᒌᔨᐤ ᐋᒄ ᐊᓂᑖᐦ ᑦᕎᐋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ᐊᓂᔮᔨᐤ ᒫᒃ ᑖᐱᔅᑳᔨᒡ ᑆᓪ ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᐙᐱᐦᑏᐙᐎᓂᔨᐤ᙮ ᒌ ᐄᔑᓂᒻ ᐋ ᐙᐱᒫᑦ ᓈᐹᐤ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᐊᔅᒌᐦᒡ ᐋ ᓃᐴᐎᔨᒡ ᐋ ᓂᑐᑎᒫᑯᑦ, “ᐹᒋ ᐄᑐᐦᑖᒄ ᐅᑖᐦ ᒫᓯᑐᓂᔮᐦᒡ, ᒑ ᐹᒋ ᐐᒋᐦᐄᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐐᐦᑎᒧᔨᒥᐦᑦ ᑆᓪ ᐅᔮᔨᐤ ᑳ ᐃᔑᓂᐦᒃ, ᓂᒌᐦ ᒑᔥᑎᓈᐦᐅᓈᓐ ᒋᔖᒥᓂᑑ ᐋ ᓂᑎᐙᔨᒥᔨᒥᐦᑦ ᒑ ᒌ ᐐᐦᑎᒧᐎᒋᐦᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᐋᒄ ᑏᐙᐦᒡ ᑳ ᐃᔮᔅᑭᐎᔮᐦᒡ ᒑ ᐄᑐᐦᑖᔮᐦᒡ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ᐊᓂᑖᐦ ᑦᕎᐋᓯᐦᒡ ᓂᒌ ᐅᐦᑖᓯᓈᓐ ᐋᒄ ᐊᓂᑖᐦ ᑯᐃᔅᒄ ᒥᓂᔅᑎᑯᐦᒡ ᓵᒧᑦᕃᔑᐦᒡ ᑳ ᐄᑖᔑᔮᐦᒡ᙮ ᐋᒄ ᒦᓐ ᐎᔮᐱᐦᒡ ᐊᓂᑖᐦ ᓂᔮᐳᓕᔅ ᐃᐦᑖᐎᓐ ᐋᑯᑎᐦ ᑳ ᑭᐹᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐱᒧᐦᑖᔮᐦᒡ ᐊᓂᑖᐦ ᐋᐦ ᐄᑐᐦᑖᔮᐦᒡ ᕕᓕᐹᐃᐦᒡ ᐊᓐ ᑳ ᒥᔖᒡ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ, ᕎᒻ ᐄᔨᔨᐅᒡ ᒌ ᑎᐹᔨᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ᐙᐃᐱᔥᒌᔥ ᓂᒌᐦᑖᓈᓐ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ᐊᓐ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᒡ, ᓂᒌ ᓈᓯᐹᓈᓐ ᐊᓂᑖᐦ ᔑᔓᒡ ᓰᐲᐦᒡ ᐎᔨᐐᑎᒥᐦᒡ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᐋ ᐄᑖᔨᐦᑎᒫᐦᒡ ᒑ ᒥᔅᑭᐎᒋᐦᒡ ᐊᓂᑎᐦ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᐊᔨᒥᐦᐋᒡ᙮ ᓂᒌᐦ ᐊᐱᓈᓐ, ᐋᒄ ᑳ ᐊᔨᒥᐦᐄᒋᐦᒡ ᐊᓂᒌ ᐃᔅᒀᐅᒡ ᐊᓂᑎᐦ ᑳ ᓂᔥᑐᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ᐋᒄ ᐹᔨᒄ ᐃᔅᒀᐤ ᐊᓂᑎᐦ ᑳᐦ ᑖᑦ ᐋ ᓂᑑᐦᑖᐎᔨᒥᐦᑦ ᓕᑎᔮ ᒌ ᐃᔑᓂᐦᑳᓲ, ᑖᔮᑖᐃᕋ ᐋ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐅᐦᒋᔨᐤ᙮ ᐋᔪᐎᒄ ᑳ ᐄᑖᐱᑎᓰᑦ ᐋ ᒌ ᐊᑖᐙᑦ ᒫᓐ ᐋ ᒋᔅᑎᒋᑖᑯᓃᔨᒡ ᐊᑯᐹᒋᓂᔨᐤ᙮ ᐋᑦ ᒫᒃ ᐋᐦᐋᑳ ᒎᐤ ᐅᐦᒋ ᐄᑎᔅᑳᓈᓯᑦ ᐊᔮᐱᒡ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᐤ ᒋᔖᒥᓂᑑ ᒧᔮᒻ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᑏᔨᒡ᙮ ᓈᔥᒡ ᒌ ᓂᑐᐦᑎᒻ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᑆᓪ, ᐋᒄ ᑳ ᒥᔨᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒃ ᑭᔮᐦ ᒑ ᒌ ᑖᑆᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐤ ᒫᒃ ᓕᑎᔮ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᑎᐦ ᐐᒋᐦᒡ ᑳ ᐐᒋᒥᑯᑦ᙮ ᐋᒄ ᑳ ᓂᑑᒥᔨᒥᐦᑦ ᐊᓂᑖᐦ ᐐᒋᐦᒡ ᒑ ᒌ ᐐᒋᒥᒋᐦᑦ ᐋ ᐃᔑᔨᒥᐦᑦ, ᒋᔮᔥᑎᓈᐦᐅᐙᒀ ᐋ ᑖᑆᔮᔨᒫᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᐹᒋ ᐲᐦᒑᒄ ᓃᒋᐦᒡ ᐊᓂᑎᐦ ᒑ ᑖᔮᒄ᙮” ᓂᒌ ᔑᐦᑰᒋᒥᑯᓈᓐ ᒫᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ᐹᔨᒀᐤ ᐋᐦ ᐄᑐᐦᑖᔮᐦᒡ ᐊᓂᑖᐦ ᑳ ᒌ ᓂᔥᑐᐐᓈᓂᐎᒡ ᐋ ᐊᔨᒥᐦᐋᓂᐎᒡ, ᓂᒌ ᓂᒋᔥᑭᐙᓈᓐ ᐋᐱᒋᐦᐋᑭᓐ ᐃᔅᒀᔥ ᐋ ᐲᐦᒋᔥᑳᑯᑦ ᒥᒋᐊᐦᒑᐦᒄ, ᐋᐦ ᑐᑖᑯᑦ ᓃᑳᓐ ᒑ ᒌ ᐐᐦᑎᐦᒃ ᑖᓐ ᒑ ᐄᔅᐱᔨᔨᒡ ᒑᒀᔨᐤ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᐅᔔᔮᓂᒥᑭᐦᐙᐤ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᑎᐹᔨᒥᑯᑦ ᐊᓂᔮᔨᐤ ᐋ ᐃᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ᓂᒌ ᐱᐹᓅᔔᔥᑳᑯᓈᓐ ᐊᓐ ᐃᔅᒀᔥ ᐋ ᑖᑆᑦ ᐋᐦ ᐃᔨᑦ, “ᒋᔖᒥᓂᑑ ᒫᐅᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᐋᐱᑎᔒᔥᑑᐙᐅᒡ ᐅᒌ ᓈᐹᐅᒡ᙮ ᒋᑭ ᐐᐦᑎᒫᑯᐙᐅᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ᐋᔪᐎᒄ ᑳᐦ ᑎᒃ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ, ᒑᒃ ᑆᓪ ᑳ ᓯᔅᑭᒋᒥᑯᑦ, ᐋᒄ ᑳ ᒀᔅᒋᑳᐳᔥᑎᐙᑦ, ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ, “ᒌᓴᔅ ᙭ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᐦᒡ ᐅᐦᒋ ᐊᔅᑎᑎᓲᒥᑎᓐ, ᒫᒌᐦ ᐎᔨᐐᐦ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ ᐅᐦᒋ,” ᒌᐦ ᐄᑖᐤ᙮ ᐋᒄ ᐊᓐ ᐊᐦᒑᐦᒄ ᑏᐙᐦᒡ ᑳ ᐎᔨᐐᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᔥ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ᐄᔥᐱᐦ ᒫᒃ ᐊᓐ ᐃᔅᒀᔥ ᐊᓂᔮᔨᐤ ᐅᒋᒫᒻ ᑳ ᐙᐱᐦᑎᒥᔨᒡ ᐋᑳ ᒑ ᒌ ᐅᔔᔮᓂᒥᐦᑳᑯᒡ, ᒌ ᐅᑎᓈᐅᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ, ᐋᒄ ᑳ ᐄᔑ ᑖᐹᐱᐦᑣᒡ ᐊᓂᑖᐦ ᑳ ᒌ ᓂᔅᑎᐎᔨᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᔑᐙᒡ ᐊᓂᑖᐦ ᕎᒻ ᐎᔨᔓᐙᐅᒋᒫᐤ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓈᔨᒡ, ᒌ ᐄᑖᐅᒡ, “ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᒌ ᓈᐹᐅᒡ, ᐅᔅᑖᐱᐦᐄᐙᐙᒡ ᐅᑎᐦ ᒋᑎᐃᐦᑖᐎᓈᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ᒋᔅᑯᑎᒧᐙᐅᒡ ᐊᐙᔨᐤᐦ ᒑᒀᔨᐤ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᐊᓂᑖᐦ ᕎᒻ ᐐᔓᐙᐎᓂᐦᒡ ᐋᑳ ᒑ ᑐᑖᑭᓂᐎᔨᑯᐱᓈ᙮ ᕎᒻ ᐄᔨᔨᐅᒡ ᒌᔮᓂᐤ, ᐊᑑᒡ ᑯᑎᓂᒸᓈᓂᐤ ᑭᔮᐦ ᐊᑑᒡ ᒋᑑᑎᒸᓈᓂᐤ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋᐦ ᐃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᒌ ᐐᒋᐦᐄᐙᐅᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋ ᐎᔮᔅᑐᑖᒥᐦᒡ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ᙮ ᐋᒄ ᐊᓂᒌ ᕎᒻ ᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒌ ᐄᑎᔓᐙᐅᒡ ᒑ ᒌ ᒥᓂᐱᑖᑭᓂᐎᒡ ᐅᒑᒀᓂᒥᔨᐤ, ᐋᒄ ᒑ ᒌ ᐱᐱᓯᔅᑖᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᒥᔥᑎᐦ ᐱᐱᓯᔅᑖᐦᐙᑭᓂᐎᒡ ᐋᒄ ᑳ ᐲᐦᑎᑭᐦᐋᑭᓂᐎᒡ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᐋᒄ ᑳᐦ ᐄᑎᔓᒫᑭᓅᑦ ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ ᐃᔮᒀ ᒑ ᒌ ᓈᓈᑭᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ᐅᔮᔨᐤ ᒫᒃ ᐋ ᒌ ᐄᑎᔓᒫᑭᓅᑦ ᐊᓂᑖᐦ ᐙᔅᒀᐦᑖᒥᐦᒡ, ᐊᓂᑖᐦ ᒫᐅᒡ ᐋᐦ ᐋᔨᒥᐦᒡ ᐋ ᐱᑯᐦᐅᓈᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ, ᐋᑯᑖᐦ ᑳ ᒫᒫᐦᒋᑯᓯᑖᔮᐱᔅᑭᐦᐙᑦ ᐋ ᐳᑯᓈᐦᑎᒋᓰᔨᒡ ᓂᐱᑳᐦᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ᒑᑳᑦ ᒌ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᒑ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᒡ ᑆᓪ ᑭᔮᐦ ᓵᐃᓚᔅ ᑭᔮᐦ ᐋ ᓂᑭᒨᔥᑐᐙᒡ ᒋᔖᒥᓂᑑᐦ, ᐊᓂᒌ ᒫᒃ ᑯᑎᑭᒡ ᑳ ᒋᐳᐙᑭᓂᐎᒡ ᒌ ᓂᑐᐦᑎᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ᒑᒃ ᔑᔥᒋᑯᒡ ᓈᔥᒡ ᒌ ᒥᔅᑎᑯᐄᑯᓐ, ᐋᒄ ᐊᓐ ᒋᐱᐦᐅᑑᑭᒥᒄ ᓈᔥᒡ ᒌ ᐋᔮᐦᒋᐱᔨᔨᐤ᙮ ᑏᐙᐦᒡ ᒥᓯᐙ ᒋᔥᑐᐦᑭᓂᒡ ᒌ ᐋᐱᐦᐄᐱᔨᐎᒡ, ᐋᒄ ᐊᓂᒌ ᑳ ᒥᒫᒋᒫᐱᔅᑭᐦᐙᑭᓂᐎᒡ ᒌ ᒥᓂᐱᔨᐤ ᐊᓂᔮᔨᐤ ᐱᔻᐱᔅᑯᔮᐲ ᑳ ᒋᒋᔥᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","ᒌ ᐹᑰᐱᔨᐤ ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ᙮ ᐄᔥᐱᐦ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ ᒋᔥᑐᐦᑭᓐ ᐋ ᔫᐦᑖᑯᒋᓃᔨᒡ, ᒌ ᐄᑖᔨᐦᑎᒻ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ ᐋ ᒌ ᐅᔑᒧᔨᒡ᙮ ᐋᒄ ᑳ ᐐᐦ ᓂᐱᐦᐄᓱᑦ ᑎᐱᔨᐙ ᐅᓂᑐᐱᔫᐦᑯᒫᓐ ᐋ ᐐᐦ ᐋᐱᒋᐦᑖᑦ ᐋ ᐃᔥᐱᔥ ᓈᔥᒡ ᓵᒋᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ᑆᓪ ᒫᒃ ᒌ ᑖᑆᑖᐤ ᐋᐦ ᐄᑖᑦ, “ᐊᑳᐐ ᐎᔮᔥ ᑐᑖᔓᐦ ᒥᓯᐙ ᐙᔥ ᐋᔥᒄ ᐋᑯᑖᐦ ᐅᑎᐦ ᐋᐦ ᑖᔮᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","ᐋᒄ ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ ᒌ ᓂᑎᐙᔨᐦᑎᒻ ᐙᔥᑖᓂᒫᑭᓂᔨᐤ, ᐋᒄ ᑳ ᐲᐦᑖᐱᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᑳᐦ ᑖᔨᒡ, ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᑦ ᐊᓂᑎᐦ ᐅᐦᑎᔅᑰ ᐋᐦ ᑖᔨᒡ ᐋ ᐙᐎᐲᔨᑦ ᐋ ᐃᔥᐱᔥ ᓵᒋᓯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ᐋᒄ ᑳ ᐎᔨᐐᐦᑎᐦᐋᑦ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐅᐦᒋ, ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ, ᐹᒋ ᐐᐦᑎᒨᒄ ᑖᓂᑖᐦ ᒑ ᑎᔮᓐ ᐋ ᐐᐦ ᐱᒫᒋᐦᐅᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ᐋᒄ ᐋᑖᒡ ᐅᔮᔨᐤ ᓈᐹᐤ, “ᑖᑆᔮᔨᒻ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ, ᐋᒄ ᒫᒃ ᒑ ᐱᒫᒋᐦᐅᔨᓐ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᒌ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓯᔨᓐ ᑳᐦ ᑖᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ᒌ ᐋᔨᒨᑎᒧᐙᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᑭᔮᐦ ᒥᓯᐙ ᐋ ᑎᔒᔨᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑎᐦ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ᑏᐙᐦᒡ ᒫᒃ, ᐋᑎ ᐋ ᒫᒀᒋᔅᑎᐱᔅᑳᔨᒡ, ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ ᒌ ᐄᑐᐦᑎᐦᐋᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᐊᓂᑖᐦ ᒑ ᒋᔥᑖᐹᐅᑖᐙᑦ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐹᐦᐹᑳᐆᒫᑭᓂᐎᔨᒡ᙮ ᐋᒄ ᑏᐙᐦᒡ ᐐᔨ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ᐋᒄ ᐊᓂᑖᐦ ᐐᒋᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ, ᑳ ᒥᔮᑦ ᒦᒋᒥᔨᐤ ᒑ ᒌ ᒦᒋᓱᔨᒡ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒥᔻᔨᐦᑎᒻ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ ᒌ ᒨᒋᒑᔨᐦᑎᒥᔨᐤ ᐋ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ᐎᔮᐱᓃᔨᒡ ᒫᒃ, ᐊᓂᒌ ᕎᒻ ᐅᒋᒫᐅᒡ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᐙᔓᐤ ᒑ ᐄᑐᐦᑖᔨᒡ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᒑ ᒌ ᓂᑑᐄᑖᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓈᓈᑭᒋᐦᑖᔨᒡ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ, ᒑ ᒌ ᐱᒋᔅᑎᓈᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ᐋᒄ ᐊᓐ ᑳ ᓈᓈᑭᒋᐦᑖᑦ ᒋᐱᐦᐅᑑᑭᒥᑯᔨᐤ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᐊᓂᒌ ᐅᒋᒫᐅᒡ ᐃᔨᐅᒡ ᒑ ᒌ ᐱᒋᔅᑎᓂᑖᐦᒡ, ᒫᒌᒄ ᒫᒃ ᒋᔮᒻ ᒋᔅᑐᐦᑖᒄ, ᓂᒧᐃ ᐊᐙᓐ ᐎᔮᔥ ᒋᑭ ᑐᑖᑯᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ᒥᒄ ᒫᒃ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᕎᒻ ᐋ ᐄᔑ ᒥᓯᓈᓱᑦ ᐊᐙᓐ ᐱᑎᒫ ᒋᐱᐦ ᑎᐹᔅᑯᓈᑭᓂᐤ ᐋᒄ ᐃᔮᒄ ᐎᔮᔅ ᒋᐱᐦ ᐄᑎᔓᒫᑭᓂᐤ᙮ ᕎᒻ ᓂᑎ ᐄᑎᓯᓈᓱᓈᓐ ᐊᔮᐱᒡ ᒫᒃ ᓂᒌᐦᑯᔒᐦᑳᑰᓈᓐ ᒥᐦᒑᑐ ᐊᐙᓐ ᐋᐙᐱᔨᒥᐦᑦ ᑭᔮᐦ ᓂᒌ ᐲᐦᑖᐙᐱᓂᑰᓈᓐ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᐋᐦᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᑎᐹᔅᑯᓂᑭᐎᔮᐦᒡ᙮ ᐋᒄ ᒫᒃ ᒌᒧᒡ ᐙᐦ ᐱᒋᔅᑎᓂᑭᐎᔮᐦᒡ᙮ ᓂᒧᐃ ᒫᒃ ᓂᑭ ᐅᐦᒋ ᐄᒑᐦᑖᓈᓐ ᐅᑎᐦ᙮ ᓂᓂᑎᐙᔨᒫᓈᓂᒡ ᐊᓂᒌ ᕎᒻ ᐅᒋᒫᐅᒡ ᐐᔨᐙᐤ ᒑ ᒌ ᐹᒋ ᑎᑯᔑᒡ ᒑ ᒌ ᐱᒋᔅᑎᓃᔨᒥᐦᒡ᙮” ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᒋᐱᐦᐅᐙᔓᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ᐋᒄ ᐊᓂᒌ ᒋᐱᐦᐅᐙᔓᐎᒡ ᑳ ᒌᐙᒡ ᓈᑖᐦ ᑳ ᐐᐦᑎᒧᐙᒡ ᐊᓂᔮᔨᐤ ᐅᒋᒫᐤ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᑆᓪ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐊᓂᒌ ᐅᒋᒫᐅᒡ ᕎᒥᐦᒡ ᐋ ᐄᔑ ᒥᓯᓈᓱᔨᒡ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ, ᒌ ᓵᒋᓯᐎᒡ, ᐙᔥ ᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐋ ᒌ ᐎᓂᑐᑎᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᒡ, ᑳᐦ ᐄᑖᒡ, ᓂᒥᐦᒋᔨᐙᓯᓈᓐ ᐊᓐ ᑳ ᐊᔨᐦᑎᔮᐦᒡ᙮ ᐋᒄ ᑳ ᐎᔨᐐᐦᑎᐦᐋᒡ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ, ᑳᐦ ᐄᑖᒡ ᒑ ᓂᑭᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ᐋᒄ ᒫᒃ ᑆᓪ ᑭᔮᐦ ᓵᐃᓚᔅ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᔅᒀᐤ ᓕᑎᔮ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᒡ᙮ ᐋᑯᑖᐦ ᐅᑎᐦ ᐱᔅᒡ ᑳᐦ ᑖᔨᒡ ᒋᒋᔖᓅᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ, ᐋᒄ ᑳᐦ ᐋᔨᐦᑭᒫᒡ ᒑ ᒌ ᔮᐃᒋᑳᐳᐎᔨᒡ ᐋ ᑖᑆᐦᑎᒥᔨᒡ᙮ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ᐋᒄ ᑆᓪ ᑭᔮᐦ ᓵᐃᓚᔅ ᐊᓂᑖᐦ ᐊᒻᕕᑆᓕᔅ ᑭᔮᐦ ᐋᑆᓗᓂᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓐ ᑳᐦ ᐋᑎ ᐄᑐᐦᑖᒡ᙮ ᐋᒄ ᐊᓂᑖᐦ ᕞᓵᓨᓈᐃᑳ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᑳ ᐄᑐᐦᑖᒡ᙮ ᐊᓂᑎᐦ ᒫᒃ ᕞᓵᓨᓈᐃᑳᐦᒡ ᐃᐦᑖᐎᓐ ᒌ ᑎᑯᓐ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ᒌ ᐄᑐᐦᑖᐤ ᑆᓪ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐙᔥ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᒌᐦ ᑎᒃ ᒫᓐ᙮ ᓂᔥᑣᐤ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ ᒌ ᐙᐐᐦᑎᒧᐙᐤ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑖᓐ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓂᐎᒡ ᙭, ᒋᔖᒥᓂᑑᐦ ᐆᒋᐦᒋᒥᓯᓈᐦᐄᑭᓃᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᔮᔨᑖ ᐋ ᒌ ᓂᑎᐙᔨᐦᑖᑯᓰᔨᒡ ᒑ ᒌ ᓂᓈᐦᑭᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᙭, ᑭᔮᐦ ᒦᓐ ᒑ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, “ᐆ ᒌᓴᔅ ᑳᐦ ᐋᔨᒨᒥᒃ, ᐋᐅᒄ ᐆ ᙭, ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐅᑯᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᓂᑑᐦᑎᐙᒡ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᒌ ᔑᐦᑯᒋᒥᑯᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐄᔑ ᐐᒋᐦᐄᐙᒡ ᐋᐦ ᑖᔨᒡ᙮ ᑭᔮᐦ ᒥᐦᒑᑐ ᒃᕇᒃ ᐄᔨᔨᐅᒡ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ, ᑭᔮᐦ ᒥᐦᒑᑐ ᐃᔅᒀᐅᒡ ᑳ ᒋᔥᑖᔨᒫᑭᓂᐎᒡ ᒌ ᔑᐦᑯᒋᒫᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ᒌ ᐅᐎᐦᑖᔨᒥᑯᒡ ᒫᒃ ᒎᐄᔨᔨᐤ ᐄᔥᐱᐦ ᐎᔮᐱᒥᑯᒡ ᒥᐦᒑᑐ ᐊᐙᔨᐤᐦ ᐋ ᐐᒋᐦᐄᑯᒡ᙮ ᒌ ᓂᔥᑑᓈᔨᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐋᑳ ᐱᐹᔅᐱᓈ ᑳᐦ ᑎᔨᒡ ᒫᓐ, ᐋᒄ ᑳ ᒫᐅᓯᑯᐦᑖᔨᒡ ᑳ ᓂᑑᒥᒋᐱᔨᐦᐄᐙᔨᒡ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ᙮ ᒥᒄ ᐊᓂᑖᐦ ᑯᐃᔅᒄ ᒌ ᐄᑐᐦᑖᔨᒡ ᒉᓯᓐ ᐅᐙᔅᑳᐦᐄᑭᓂᒥᔨᒡ, ᐋ ᒌ ᐄᑖᔨᐦᑎᐦᒡ ᒑ ᒥᔅᑭᐙᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᐊᓂᑖᐦ᙮ ᒋᐐᐦ ᐅᑎᓈᐅᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᐋ ᒌ ᐐᐦ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᑖᐦ ᑳᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᒋᔑᐙᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ᐄᔥᐱᐦ ᒫᒃ ᐋᑳ ᒫᔅᑯᐙᒡ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᐊᓂᑖᐦ ᒉᓯᓐ ᐋᐦ ᑖᔨᒡ ᐋᒄ ᐊᓂᔮᔨᐤ ᒉᓯᓐ ᑭᔮᐦ ᑯᑎᒃ ᐐᒋᔖᓂᒫᐤ ᐊᓂᑖᐦ ᑳ ᐃᔑᑖᐹᑖᑣᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋᐦ ᑖᔨᒡ᙮ ᒌ ᑖᑆᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᑆᓪ ᑭᔮᐦ ᓵᐃᓚᔅ ᒨᔥ ᐅᔅᑖᐱᔨᐦᑖᐅᒡ ᒑᒀᔨᐤ ᑖᓂᑖᐦ ᐋᑎ ᐃᔨᐦᑖᒡ, ᐋᒄ ᒫᒃ ᑖᑯᔑᐦᒡ ᐅᑎᐦ ᒋᑎ ᐃᐦᑖᐎᓈᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ᒉᓯᓐ ᒫᒃ ᐊᓂᑖᐦ ᐐᒋᐦᒡ ᒌ ᑭᓄᐙᔨᒫᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ᙮ ᒥᓯᐙ ᐋᓍᐦᑎᒧᒡ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐅᐐᔓᐙᐎᓂᔨᐤ, ᐋᐦ ᐃᔨᒡ ᐋᐦ ᑖᔨᒡ ᑯᑎᒃ ᒋᐦᒋᐅᒋᒫᐤ ᒌᓴᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᒡ ᒌᐦ ᑐᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᓈᔥᒡ ᒑ ᒌ ᒋᔑᐙᓰᔅᑐᐙᔨᒡ ᒉᓯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ᐋᒄ ᑳᐦ ᐄᑖᒡ ᒉᓯᓐ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᑳ ᑖᑆᐦᑎᐦᒡ ᒑ ᑎᐱᐦᐅᓲᔨᒡ, ᐋᒄ ᒫᒃ ᐃᔮᒄ ᑳ ᐱᒋᔅᑎᓈᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ᐐᐱᒡ ᒫᒃ ᐋᐦ ᐋᑎ ᑎᐱᔅᑳᔨᒡ, ᐊᓂᒌ ᑖᑆᔮᔨᐦᑖᒡ ᒌ ᐄᑎᔑᐦᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐯᕆᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑖᐦ ᑏᐙᐦᒡ ᒌ ᐄᑐᐦᑖᐅᒡ ᒎᐄᔨᔨᐤ ᐅᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ᐊᓂᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐯᕆᔮᐦᒡ ᑳᐦ ᑖᒡ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐐᔨᐙᐤ ᐋ ᓂᑑᐦᑎᐙᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ, ᓂᒧᐃ ᒸᐦᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑖᐦ ᕞᓵᓨᓈᐃᑳ ᑳᐦ ᑖᔨᒡ ᑳᐦ ᑎᔨᒡ᙮ ᓈᔥᒡ ᒌ ᓂᑐᐦᑎᐙᐅᒡ ᑭᔮᐦ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒌ ᓂᑑᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᔖᒥᓂᑑᐦ ᐆᒋᐦᒋᒥᓯᓂᐦᐄᑭᓃᔨᒡ, ᐋ ᒌ ᐐᐦ ᓂᑑᒋᔅᒑᔨᒫᒡ ᑆᓪ ᑎᔮᑆᔨᒀᓂᐦᐄ ᐊᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ᐋᒄ ᒥᐦᒑᑐ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᐋᑎ ᑖᑆᔮᔨᒫᐅᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ, ᑭᔮᐦ ᒥᐦᒑᑐ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᒡ ᒃᕇᒃ ᐃᔅᒀᐅᒡ ᑭᔮᐦ ᓈᐹᐅᒡ ᒌ ᑖᑆᔮᔨᒫᐅᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᕞᓵᓨᓈᐃᑳᐦᒡ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᒡ ᑆᓪ ᐋ ᐙᐐᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ ᐊᓂᑖᐦ ᐯᕆᔮ ᐃᐦᑖᐎᓂᐦᒡ, ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ, ᑳᐦ ᑐᑎᐙᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᒑ ᒌ ᒋᔑᐙᐦᐄᑯᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᓵᐃᓕᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ᐋᒄ ᐊᓂᒌ ᐐᒋᔖᓂᒫᐅᒡ ᑏᐙᐦᒡ ᑳ ᐄᑎᔑᐦᐙᒡ ᑆᓪ ᐊᓂᑖᐦ ᔑᔓᒡ ᒋᐦᒋᑭᒦᐦᒡ᙮ ᓵᐃᓚᔅ ᑭᔮᐦ ᑎᒧᕢ ᐋᑯᑖᐦ ᑳᐦ ᑖᒡ ᐐᔨᐙᐤ ᐊᓂᑎᐦ ᐯᕆᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ᐋᒄ ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᐄᑎᐦᐅᔮᐦᒡ ᑆᓪ ᐊᓂᑖᐦ ᐋᕞᓐᓯᐦᒡ ᐋᒄ ᐊᓂᒌ ᓈᐹᐅᒡ ᒦᓐ ᑳᐤ ᐯᕆᔮᐦᒡ ᑳ ᐄᔑ ᒌᐙᐦᐅᒡ, ᐋ ᒌ ᐄᑎᑯᒡ ᑆᓪ ᒑ ᐃᑖᔨᒡ ᓵᐃᓕᔅᐦ ᑭᔮᐦ ᑎᒧᕢ ᐐᐱᒡ ᒑ ᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ᒫᒀᒡ ᒫᒃ ᑆᓪ ᐋᐦ ᐋᔑᓂᐙᐦᐋᑦ ᓵᐃᓕᔅᐦ ᑭᔮᐦ ᑎᒧᑏᐦ ᐊᓂᑖᐦ ᐋᕞᓐᓯᐦᒡ ᐃᐦᑖᐎᓐ, ᒥᓯᐙ ᒥᒄ ᐊᓂᑖᐦ ᐋᐦ ᐄᑖᐱᑦ ᒌ ᐙᐱᒫᐤ ᐋ ᒥᐦᒑᑎᔨᒡ ᒥᓂᑑᐦᑳᓐ, ᐋᒄ ᓈᔥᒡ ᑳ ᒥᒑᔨᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ᐋᔪᐎᒄ ᐙᐦᒋ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒑ ᒌ ᐐᐦᑎᒧᐙᑦ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᒃᕇᒃ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑳ ᐊᔨᒥᐦᐋᐙᑎᓰᔨᒡ ᐄᔨᔨᐤᐦ ᑭᔮᐦ ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᒌ ᐄᑐᐦᑖᐤ ᐊᓂᑖᐦ ᑳ ᒌ ᐊᑖᐙᓂᐎᔨᒡ ᒑ ᒌ ᐊᔨᒥᐦᐋᑦ ᐊᓂᑎᐦ ᐄᔨᔨᐤ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ᐹᔨᒀᐤ ᒌ ᓂᒋᐦᐋᐅᒡ ᒋᔅᑯᑎᒫᒑᓯᐤ ᓈᔥᒡ ᐋ ᒌ ᐄᑆᐦᑳᔨᒡ ᐁᐱᑯᕆᔨᓐ ᑭᔮᐦ ᒋᑣᐃᒃ ᑳ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ᙮ ᐅᒌ ᒫᒃ ᒋᔅᑯᑎᒫᒑᓯᐎᒡ ᒌ ᐊᔨᒥᐦᐋᐅᒡ ᐊᓂᔮᔨᐤᐦ ᑆᓪ ᐋᒄ ᑳ ᒫᔮᔨᒫᒡ ᐋᐦ ᐄᑖᒡ, “ᑖᓐ ᐋᐦ ᐃᔨᑦ ᐆ ᒌᔥᒀᐦᑳᓐ?” ᐋᒄ ᑯᑎᑭᒡ ᑳᐦ ᐄᑖᒡ, “ᒋᑭ ᐋᔨᒨᒫᐙᐦ ᐊᓂᔮᔨᐤᐦ ᐐᔨ ᐋ ᐊᔨᒥᐦᐋᔅᑎᐙᑦ ᐊᐙᔨᐤᐦ, ᓂᒧᐃ ᒫᒃ ᒌ ᒋᔅᒑᔨᒫᓂᐤ ᒌᔮᓂᐤ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤᐦ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᒡ ᐙᔥ ᑆᓪ ᒌ ᐋᔨᒨᒫᔨᐤ ᒌᓴᔅᐦ, ᑳ ᐎᓂᔥᑳᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᑆᓪ ᐊᓂᑖᐦ ᐋ ᓂᔥᑐᐲᔨᒡ ᑳ ᓃᑳᓂᔑᔨᒡ ᐁᕎᐱᑭᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᓂᐐ ᒋᔅᒑᔨᐦᑖᓈᓐ ᐆ ᑳ ᐅᔅᑳᒡ ᒋᔅᑯᑎᒫᒑᐎᓐ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ᐱᔅᒡ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᑳᐦ ᐋᔨᒸᐦᐄᑯᔨᓐ ᓂᒥᔅᑳᓯᑖᓈᓐ ᐋᒄ ᒫᒃ ᐙᐦ ᒋᔅᒑᔨᐦᑎᒫᐦᒡ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐊᓐ ᑳᐦ ᐃᔨᓐ,” ᒌ ᐄᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ᐊᓂᒌ ᒥᓯᐙ ᐊᓂᑖᐦ ᐋᕞᓐᓯᐦᒡ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᒡ ᑭᔮᐦ ᐊᓂᒌ ᒫᓂᑖᐅᒡ ᐊᓂᑖᐦ ᑳ ᐐᒋᒡ ᓈᔥᑖᑆᐦ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᒨᔥ ᐋᐦ ᑐᓂᒫᓱᐎᒡ ᒑ ᒌ ᓂᑐᐦᑎᐦᒡ ᐋᐦ ᐋᔨᒸᐅᐦᐄᑯᒡ ᑖᓐ ᐋ ᐄᔑ ᐃᔮᒄ ᐱᐹᐦᑖᑯᓃᔨᒡ, ᐋᔪᐎᒄ ᑳ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ᐋᒄ ᑆᓪ ᐊᓂᑎᐦ ᑖᑖᐅᒡ ᑳ ᓃᐴᐎᑦ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ ᐅᑎᐦ ᐋᕞᓐᓯᐦᒡ ᐃᐦᑖᐎᓐ ᑳ ᐅᐦᒋᔮᒄ, ᓂᐙᐱᐦᑖᓐ ᒥᓯᐙ ᑖᓐ ᐊᓐ ᐋᐃᐦᑎᔮᒄ, ᓈᔥᒡ ᐋ ᐊᔨᒥᐦᐋᐙᑎᓯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ᐋ ᐱᒧᐦᑖᔮᓐ ᐊᓂᑖᐦ ᒋᑎᐦᑖᐎᓂᐙᐦᒡ, ᓂᒌᐙᐱᐦᑖᓐ ᐊᓂᑖᐦ ᐋ ᐊᔨᒥᐦᐋᔮᒄ᙮ ᓂᒌ ᑭᓂᐙᐱᐦᑖᓐ ᔮᒀᐦ ᓂᓈᐦᑭᐤ ᐋ ᐃᓯᓈᑯᐦᒡ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᐋᔨᒦᐦᐋᔅᑎᒫᒄ᙮ ᐋᒄ ᑳ ᐙᐱᐦᑎᒫᓐ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᒄ ᐋ ᒥᓯᓈᑖᒡ ᐋᐦ ᐄᑎᔥᑖᒡ, ‘ᐋᑯᑖᐦ ᐅᑎᐦ ᒑ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓅᑦ ᒋᔖᒥᓂᑑ ᐊᓐ ᐋᔥᒄ ᐋᑳ ᑳ ᒋᔅᒑᔨᐦᑖᑯᓯᑦ᙮’ ᐋᒄ ᒫᒃ ᐙᐦ ᐋᔨᒨᑎᒫᑎᑯᒡ ᒋᔖᒥᓂᑑ ᐊᓐ ᐙᐦ ᐊᔨᒥᐦᐋᔥᑎᐙᐦᒄ ᐋᑦ ᒫᒃ ᐋᐦᐋᑳ ᒋᔅᒑᔨᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“ᐋᐅᒄ ᐆ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᑳ ᐅᔑᐦᑖᑦ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᓃᔨᒡ ᐅᑎᐦ, ᐐᔨ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑭᔮᐦ ᒋᐦᒋᒌᔑᑯᐦᒡ ᓂᒧᐃ ᒫᒃ ᐐᒋᐤ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᓈᐹᐤ ᐋ ᒌ ᐅᔑᐦᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ᓂᒧᐃ ᐱᑯᓵᔨᒫᐤ ᓈᐹᐤ ᒑ ᒌ ᐙᐐᒋᐦᐄᑯᑦ, ᐙᔥ ᒥᔮᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐱᒫᑎᓰᐎᓂᔨᐤ, ᔮᐦᔮᐎᓂᔨᐤ ᑭᔮᐦ ᒥᓯᐙ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ᐹᔨᒄ ᓈᐹᐤ ᐅᐦᒋ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᒋ ᐅᔑᐦᐋᐤ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᓂᓈᐦᑭᐤ ᒑ ᒌ ᐄᔑ ᐃᐦᑖᔨᒡ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ᓂᔮᑭᓐᐦ ᒫᒃ ᒌ ᐎᔮᔨᐦᑎᒸᐤ ᑖᔨᔥᐱᔥ ᒑ ᑖᔨᒡ ᐊᓂᑖᐦ ᑭᔮᐦ ᑖᓐ ᒑ ᐃᔥᑯᓯᓈᑖᔨᒡ ᐊᔅᒌᔨᐤ ᐊᓂᑖᐦ ᒑ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐅᔑᐦᐋᑦ ᐊᐙᔨᐤᐦ, ᒌ ᐱᑯᓵᔨᐦᑎᒻ ᒑ ᒌ ᓈᓂᑐᐙᐱᒥᑯᑦ ᐋᒄ ᒫᒃ ᒨᔑᐦᐄᑯᒑ ᒑ ᒌ ᒥᔅᑳᑯᑦ᙮ ᑖᑆᐦ ᒫᒃ, ᒥᓯᐙ ᐹᐦᐹᔨᒄ ᐋᐦᑎᔒᐦᒄ ᓈᔥᑖᑆᐦ ᒌ ᐹᔣᐱᒥᑯᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ᒧᔮᒻ ᐊᐙᓐ ᑳ ᔨᒀ, ‘ᒋᔖᒥᓂᑑ ᐅᐦᒋ ᐙᐦᒋ ᐱᒫᑎᓰᔨᐦᒄ, ᑭᔮᐦ ᐙᐦᒋ ᐋᐦᒋᔨᐦᒄ ᑭᔮᐦ ᐙᐦᒋ ᐃᔮᔨᐦᒄ ᔮᐦᔮᐎᓐ᙮’ ᒧᔮᒻ ᐱᔅᒡ ᑎᐱᔨᐙ ᒋᑎᐄᔨᔨᒥᐙᐅᒡ ᑳ ᒌ ᒥᓯᓂᐦᐄᒑᒡ ᑳ ᔨᐙᒀ, ‘ᑖᑆᐦ ᒥᓯᐙ ᑯᑎᐙᔑᔒᒥᑐᑖᑭᓂᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ᐋ ᐅᑎᐙᔑᔒᒥᑐᑖᑎᐦᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐄᑖᔨᒫᓂᐤ ᒋᔖᒥᓂᑑ ᒸᐦᒡ ᒥᓂᑑᐦᑳᓐ ᒑ ᒌ ᐄᑖᔨᐦᑖᑯᓯᑦ, ᐙᔥ ᓈᐹᐤ ᐅᔑᐦᐋᐤ ᒥᓂᑑᐦᑳᓐ ᔔᐎᔮᓈᐱᔅᑯᐦᒡ ᑭᔮᐦ ᐙᐱᔔᐎᔮᓈᐱᔅᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓯᓃᐦᒡ ᐅᐦᒋ ᐐᔨ ᐅᑭᔅᒋᐦᐅᐎᓐ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ᐙᔥᑭᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᒌ ᐅᔑᐦᐋᐅᒡ ᒥᓂᑑᐦᑳᓐ, ᓂᒧᐃ ᒫᒃ ᐱᑎᒫ ᐅᐦᒋ ᒫᑯᐦᐄᑯᒡ ᒋᔖᒥᓂᑑ᙮ ᐊᓅᐦᒡ ᒫᒃ ᒋᔖᒥᓂᑑ ᐄᑎᔓᒫᐤ ᐄᔨᔨᐤ ᒥᓯᐙ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ᐙᔥ ᒋᔖᒥᓂᑑ ᒌ ᐎᔮᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑯᐃᔅᒄ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᒫᑭᓂᐎᔨᒡ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᒌ ᐎᔮᔨᒫᐤ ᐹᔨᒄ ᓈᐹᐤ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᒑᔨᒡ, ᒌ ᐙᐱᐦᑎᔮᐤ ᒫᒃ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐋᐦ ᐋᐎᔨᒡ ᐅᔮᔨᐤ ᓈᐹᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᒑ ᒌ ᑎᐹᔅᑯᓂᒑᔨᒡ, ᐋ ᒌ ᐙᓂᔥᑳᓈᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮” ");
INSERT INTO crl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐙᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᐋᐦ ᐋᔨᒨᑎᒥᔨᒡ ᐊᓂᔮᔨᐤ ᑳᐤ ᐋ ᐎᓂᔥᑳᓂᐎᔨᒡ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᐱᔅᒡ ᒌ ᒫᔮᔨᒫᐅᒡ ᐋ ᐅᔑᓂᐙᒡ, ᒥᒄ ᒫᒃ ᑯᑎᑭᒡ ᒌ ᐄᑖᐅᒡ, “ᒦᓐ ᒋᐐᐦ ᐹᐦᑖᑎᓈᓐ ᐋᐦ ᐋᔨᒨᑎᒥᓐ ᐆ᙮” ");
INSERT INTO crl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ᐋᒄ ᒫᒃ ᑆᓪ ᑳ ᒋᔅᑐᐦᑖᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ᐱᔅᒡ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᐐᒑᐅᑰ ᑭᔮᐦ ᒌ ᐋᑎ ᑖᑆᐦᑎᒥᔨᐤ᙮ ᐹᔨᒄ ᐊᓐ ᑎᔻᓃᓰᔨᔅ ᒌ ᐃᔑᓂᐦᑳᓲ, ᒌ ᐅᒋᒫᐦᑳᓂᔑᐤ ᐋᐆᒋᒫᐆᓈᓂᐐᒡ ᐊᓂᑖᐦ ᐁᕎᐱᑭᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᑭᔮᐦ ᐃᔅᒀᐤ ᑖᒫᕆᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᑭᔮᐦ ᒫᒃ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ᐹᑎᒫ ᒫᒃ ᒌ ᒋᔅᑐᐦᑖᐤ ᑆᓪ ᐊᓂᑎᐦ ᐅᐦᒋ ᐋᕞᓐᓯᐦᒡ ᐃᐦᑖᐎᓂᐦᒡ, ᐋᒄ ᐊᓂᑖᐦ ᒀᕆᓐᑦ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ᐋᑯᑖᐦ ᒫᒃ ᐅᑎᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᒫᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐋᑶᓛ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋᑯᑖᐦ ᐊᓂᑖᐦ ᑆᓐᑎᔅ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒋᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᑳ ᐅᐦᑐᐦᑖᑯᐱᓈ, ᐐᐤᐦ ᑉᕆᓯᓛ ᐋ ᒌ ᐐᒑᐙᑦ ᐊᓂᑖᐦ ᐅᐦᒋ ᐃᑎᓖ ᐊᔅᒌᐦᒡ, ᐙᔥ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᒃᓨᑎᔨᔅ ᒌ ᐄᑎᔓᐙᑖᑯᐱᓐ ᒥᓯᐙ ᒎᐄᔨᔨᐤ ᒑ ᓂᑭᑎᒥᔨᒡ ᕎᒻ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᐃᑎᓖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ᙮ ᒌ ᓂᑎᐙᐱᒫᐤ ᒫᒃ ᑆᓪ ᐅᔮᔨᐤ ᐋᑶᓛ ᑭᔮᐦ ᐐᐅᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ᑳ ᐐᒋᒫᑦ ᑭᔮᐦ ᑳ ᐐᒋᐋᐱᑎᓰᒫᑦ ᐋ ᐅᔑᐦᑖᔨᒡ ᒫᐦᑮ ᐙᔥ ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨ ᑳ ᐄᑖᐱᑎᓰᑦ ᒧᔮᒻ ᑭᔮᐦ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒥᓃᓱᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ᒨᔥ ᒫᒃ ᑎᐦᑐ ᐋ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒌᔑᑳᔨᒡ, ᑆᓪ ᒌ ᐄᑐᐦᑖᐤ ᒫᓐ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᒡ, ᐋᒄ ᑳ ᒌ ᐊᔨᒥᐦᐄᑐᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᑭᔮᐦ ᒃᕇᒃ ᐄᔨᔨᐤ ᐋ ᐐᐦ ᔒᐦᒋᒫᑦ ᒑ ᒌ ᑖᑆᐦᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᓃᔨᒡ ᓵᐃᓕᔅᐦ ᑭᔮᐦ ᑎᒧᕢ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᐋ ᐅᐦᑐᐦᑖᔨᒡ᙮ ᐋᒄ ᑆᓪ ᐋᔪᐎᒄ ᔖᔥ ᑳᐦ ᑎᒃ ᐱᔑᔑᐦᒄ ᐋ ᐙᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐋᐦ ᐄᑖᑦ, ᒌᓴᔅ ᐋᐅᒄ ᙭ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ᒌ ᐋᓍᐦᑖᑰ ᒫᒃ ᑭᔮᐦ ᒌ ᒫᔮᔨᒥᑰ ᐋᒄ ᑆᓪ ᑳ ᐱᐦᐱᐅᐦᐋᐦᒃ ᐅᒑᒀᓂᒻ ᐋ ᓅᑯᐦᑖᑦ ᐋᐦᐋᑳ ᓂᐦᐄᔥᑳᑯᑦ ᐊᓂᔮᔨᐤ ᐋ ᐃᔨᐦᑎᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᒋᑭ ᑐᑖᓱᓈᐙᐤ ᓂᔑᐎᓈᑎᓯᔮᒀ, ᓂᒥᔮᐤ ᓃᔨ ᒑ ᑐᑖᑎᑯᒡ᙮ ᐙᔥ ᐋᒄ ᒑ ᒋᐦᒋᐱᔨᐦᑖᔮᓐ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐋ ᐙᐐᐦᑎᒨᒀᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ᐋᒄ ᑳ ᓂᑭᑖᑦ, ᑳ ᓂᑑᐐᒋᒫᑦ ᓈᐹᐤ ᑖᐃᑎᔮᔅ ᒑᔅᑎᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐆ ᓈᐹᐤ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᑦ ᐊᔮᐱᒡ ᒫᒃ ᐋ ᒫᒥᒋᒫᒡ ᒋᔖᒥᓂᑑ᙮ ᐹᔓᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒌ ᒋᒥᑖᔨᐤ ᐅᐙᔅᑳᐦᐄᑭᓂᒻ ᐆ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ᒃᕆᔅᐳᔅ ᒫᒃ, ᐊᓐ ᑳ ᓃᑳᓂᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᒌ ᑖᑆᔮᔨᒫᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ, ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᐋ ᐹᔨᑯᑖᐅᓰᑦ᙮ ᑭᔮᐦ ᒫᒃ ᒥᐦᒑᑐ ᐊᓂᑎᐦ ᒀᕆᓐᑦ ᑳᐦ ᑖᒡ ᐄᔨᔨᐅᒡ ᒌ ᐹᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᒌ ᑖᑆᐦᑎᒧᒡ ᑭᔮᐦ ᒫᒃ ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ᐹᔨᒀᐤ ᐋ ᑎᐱᔅᑳᔨᒡ ᑆᓪ ᒌ ᐙᐱᐦᑎᔮᑭᓂᐤ ᒑᒀᔨᐤ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᐊᔨᒥᐦᐄᑯᑦ ᐋᐦ ᐄᑎᑯᑦ, “ᐊᑳᐐ ᑯᔥᑖᒡ, ᐊᔮᐱᒡ ᑭᒑᔅᒀ, ᐊᑳᐐ ᓅᐦᑦ ᐴᓃᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ᐙᔥ ᒌ ᐐᒑᐅᑎᓐ᙮ ᓂᒧᐃ ᐊᐙᓐ ᐎᔮᔥ ᒋᑭ ᒌ ᑐᑖᒄ ᐙᔥ ᒥᐦᒑᑐᐎᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᓃᔨ ᐊᓂᒌ ᓂᑎᐄᔨᔨᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ᐋᒄ ᑆᓪ ᑳᐦ ᑖᑦ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᐹᔨᒄ ᐱᐳᓐ ᒦᓐ ᐋᐱᐦᑑ ᐃᔥᐱᔥ, ᐋ ᒋᔅᒋᓂᐦᐊᒧᐙᑦ ᐄᔨᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ᐄᔥᐱᐦ ᒫᒃ ᑳᓕᐤ ᕎᒻ ᑳ ᐅᒋᒫᐦᑳᓅᑦ ᐊᓂᑖᐦ ᐊᑫᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ, ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒫᒨ ᒌ ᓂᔥᑐᐎᒡ ᐋᒄ ᑳ ᐅᑎᓈᒡᐦ ᑆᓪ ᑳ ᐄᑐᐦᑎᐦᐋᒡ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ᐋᒄ ᑳᐦ ᐃᔨᒡ, “ᐆ ᓈᐹᐤ ᔒᐦᒋᒫᐤ ᐄᔨᔨᐤ ᐃᔨᐦᒡ ᒑ ᒌ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓂᐎᔨᒡ ᒋᔖᒥᓂᑑ ᓂᒧᐃ ᐄᑎᔥᑖᐤ ᐊᓂᑖᐦ ᐐᔓᐙᐎᓂᐦᒡ ᐆ ᒑ ᒌᐦ ᑎᓈᓂᐎᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ᒧᔮᒻ ᒫᒃ ᑆᓪ ᒋᐐᐦ ᐊᔨᒨ, ᑳᓕᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, “ᑖᑆᐦ ᑳ ᐎᓂᑐᑎᒧᒀ ᐆ ᓈᐹᐤ ᑆᓪ, ᒋᐱᐦ ᓂᑑᐦᑖᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ᒥᒄ ᒫᒃ ᒌᔨᐙᐤ ᐊᓂᑎᐦ ᒋᒥᒋᐱᔨᐦᓈᐙᐤ ᐊᔨᒥᐎᓐ ᐅᐦᒋ ᑭᔮᐦ ᐃᔑᓂᐦᑳᓱᐎᓐ ᐅᐦᒋ ᑭᔮᐦ ᒫᒃ ᒋᑎᔨᒥᐦᐋᐤ ᐐᔓᐙᐎᓂᐙᐤ ᐅᐦᒋ᙮ ᒌᔨᐙᐤ ᒥᔪᐱᔨᐦᑖᒄ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐱᔮᒄ, ᓂᒧᐃ ᐐ ᓃᔨ ᒋᑭ ᐅᐦᒋ ᐐᒋᐦᐄᑎᓈᐙᐤ ᒑ ᒌ ᑎᐹᔅᑯᓂᒫᒄ ᐅᐦᐄ ᒑᒀᓂᐦᐄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ᐋᒄ ᑳᓕᐤ ᑳ ᐎᔨᐐᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᐹᔓᐙᔨᒡ ᑆᓪ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒦᔥᑯᒡ ᐊᓂᔮᔨᐤ ᔂᔅᑎᓈᔅᐦ ᑳ ᐅᑎᓈᒡᐦ, ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᒥᔨᒡ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐋᒄ ᑳ ᑯᓰᐦᑯᐙᒡ ᐊᓂᑖᐦ ᐎᔨᐐᑎᒥᐦᒡ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ᙮ ᓂᒧᐃ ᒥᒄ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᐤ ᐊᓐ ᐅᒋᒫᐤ ᑳᓕᐤ ᐊᓂᔮᔨᐤ ᑳᐦ ᐃᔨᐦᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᒌᐦ ᑖᐤ ᑆᓪ ᐊᓂᑎᐦ ᒀᕆᓐᑦ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐤ ᐐᒋᔖᓂᒫᐤ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒑᒃ ᑳ ᒋᔥᑖᓯᒡ, ᐊᓂᑖᐦ ᓯᕆᔮ ᐊᑯᑖᐦ ᑳ ᐄᑖᔑᒡ, ᑉᕆᓯᓛ ᑭᔮᐦ ᐋᑶᓛ ᒌ ᐐᒑᐅᑰ᙮ ᐋᔥᒄ ᒫᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᐄᑖᔑᒡ ᐊᓂᑖᐦ ᐅᐦᒋ ᓭᓐᒃᕆᔮᐦᒡ, ᑆᓪ ᒌ ᑳᔅᒋᐹᑎᒻ ᐅᔥᑎᒀᓐ ᒧᔮᒻ ᒎᐄᔨᔨᐤ ᑳ ᒌ ᑎᔨᒡ ᒑᒀᔨᐤ ᐋ ᒌ ᐃᑖᔨᒡ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒥᔨᒡ, ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨ ᑳ ᐄᔑ ᓂᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ᐋᒄ ᑳ ᒥᓯᑳᒡ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑆᓪ ᑳ ᓂᑭᑖᑦ ᐊᓂᔮᔨᐤ ᑉᕆᓯᓛ ᑭᔮᐦ ᐋᑶᓛ᙮ ᐋᒄ ᑆᓪ ᓃᔥᑎᒻ ᑳ ᐲᐦᒑᑦ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᒄ ᑳ ᐊᔨᒥᐦᐄᑐᒡ ᐊᓂᔮᔨᐤ ᒎᐤ ᐋ ᔒᐦᒋᒫᑦ ᒑ ᒌ ᑖᑆᐦᑖᑯᑦ ᑖᓐ ᐋᐦ ᐃᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ᒌ ᑯᒀᒋᒥᑰ ᒫᒃ ᐊᓂᔮᔨᐤ ᐱᔅᒡ ᒎᐄᔨᔨᐤ ᓈᐅᔖᔥ ᒑ ᒌ ᑖᑦ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ, ᓂᒧᐃ ᒥᒄ ᐅᐦᒋ ᓂᔅᑯᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ᒥᒄ ᒌᐦ ᐄᑖᐤ ᑆᓪ, ᐄᔥᐱᐦ ᒑᔅᑐᐦᑖᑦ, “ᓂᑭ ᑎᑯᔑᓐ ᒦᓐ, ᒋᔖᒥᓂᑑ ᐄᑖᔨᐦᑎᐦᑳ ᒦᓐ ᒑ ᒌ ᑎᑯᔑᓂᔮᓐ᙮” ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒋᔥᑖᓯᑦ ᐊᐱᔖᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","ᐄᔥᐱᐦ ᒫᒃ ᒫᓯᑳᑦ ᐊᓂᑎᐦ ᓭᓯᕇᔮᐦ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᒋᔅᑐᐦᑖᑦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᐦ ᐄᑐᐦᑖᑦ, ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᐋᒄ ᒦᓐ ᐊᓂᑖᐦ ᐋᓐᑎᔻᑭᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ᐋᑯᑖᐦ ᑳᐦ ᑖᑦ ᐙᐃᐱᔥᒌᔥ ᐋᒄ ᒦᓐ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ᐋᒄ ᐊᓂᑖᐦ ᐊᔅᒌ ᑳᓓᓰᔮ ᑭᔮᐦ ᕝᕆᑭᔮᐦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑖᑦ, ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒑ ᒌ ᔮᐃᒋᑳᐳᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ᒎᐄᔨᔨᐤ ᐊᑆᓗᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐊᓂᑖᐦ ᐋᓕᒃᓵᓐᑦᕆᔮ ᐋ ᐅᐦᒌᑦ ᒌ ᑎᑯᔑᓐ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ᙮ ᓈᔥᒡ ᒌ ᑭᔅᒋᐦᐆ ᐆ ᓈᐹᐤ ᐋ ᐊᔨᒥᑦ, ᑭᔮᐦ ᒌ ᒥᔪ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ᓈᔥᒡ ᒫᒃ ᑯᐃᔅᒄ ᒌ ᐄᔑ ᒋᔅᑯᑎᒧᐙᑭᓅᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑳ ᐄᔨᔨᒡ ᒑ ᐄᔑ ᐱᒧᐦᑖᓂᐎᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᒌ ᓯᒋᔮᓲ ᐋᐦ ᐋᔨᒨᒫᑦ ᒌᓴᔅᐦ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐄᔑ ᐹᐦᑎᐙᑦ ᒞᓐ ᓰᑭᐦᐋᐦᑖᒑᓯᐤ ᐋ ᐄᔑ ᐋᔨᒨᒫᔨᒡ ᑭᔮᐦ ᒫᒃ ᒌ ᑖᑆᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ᙮ ᒥᒄ ᒫᒃ ᒞᓐ ᐆ ᓰᑭᐦᐋᐦᑖᒑᐎᓂᔨᐤ ᒌ ᒋᔅᒑᔨᐦᑎᒸᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ᒌ ᐊᔨᒥᐦᐋᐤ ᒫᒃ ᐄᔨᔨᐤ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᐦᐋᑳ ᒥᑐᓐ ᑯᔥᑖᒋᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᐦᑖᑯᑦ ᑉᕆᓯᓛ ᑭᔮᐦ ᐋᑶᓛ, ᒌ ᒌᐙᑎᐦᐄᑰ᙮ ᐊᑎᑎᐤ ᒥᒋᓐ ᑳ ᐙᐐᐦᑎᒫᑯᑦ ᒋᔖᒥᓂᑑ ᐅᒫᔅᑭᓈᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ᒑᒃ ᐊᑆᓗᔅ ᑳ ᐄᑖᔨᐦᑎᐦᒃ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐊᑫᔮ, ᐋᒄ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᒫᐤ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᔨᒡ ᒌ ᓂᐦᐋᔨᐦᑎᒥᔨᐤ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᐋᒄ ᑳ ᒥᓯᓂᐦᐋᒧᐙᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐊᑫᔮ ᑳᐦ ᑖᔨᒡ, ᐋᐦ ᐄᑖᒡ ᒑ ᒥᒥᔪᐦᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐊᑆᓗᔅ ᑎᑯᔑᓃᔨᒑ ᐊᓂᑖᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐊᑆᓗᔅ ᑖᑯᔑᐦᒃ ᐊᓂᑖᐦ ᐊᑫᔮ, ᓈᔥᑖᑆᐦ ᒥᔥᑏᐦ ᒌ ᐐᒋᐦᐋᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐊᓂᔮᔨᐤ ᑳ ᒋᔖᐙᑐᑖᑯᔨᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᑖᑆᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ᒥᑐᓐ ᒫᒃ ᒌ ᔑᐦᑰᒋᒫᐤ ᐊᓂᔮᔨᐤᐦ ᒎᐄᔨᔨᐤᐦ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ, ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐋ ᐅᐦᒋ ᐐᐦᑎᒧᐙᑦ ᒌᓴᔅᐦ ᐋᐦ ᐋᐎᔨᒡ ᙭, ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐹᒋ ᐄᑎᔑᐦᐅᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ᒫᒀᒡ ᒫᒃ ᐊᑆᓗᔅ ᐊᓂᑖᐦ ᒀᕆᓐᑦ ᑳᐦ ᑖᑦ, ᑆᓪ ᒌ ᓵᐴᐦᑎᐙᔅᑯᒻ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐋᒄ ᒑᒃ ᑳ ᐅᑎᐦᑎᐦᒃ ᐁᕕᓱᔅ᙮ ᐋᑯᑖᐦ ᑳ ᓂᒋᔥᑭᐙᑦ ᐱᔅᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ᑳ ᑯᒀᒋᒫᑦ, “ᒋᒌ ᒥᔨᑯᓈᐙᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐄᔥᐱᐦ ᑳᐦ ᐋᑎ ᑖᑆᐦᑎᒫᒄ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᓂᒧᐃ ᓅᐦᒋ ᐹᐦᑖᓈᓐ ᐋᐦ ᑖᑦ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᒑᒄ ᓰᑭᐦᐋᐦᑖᒑᐎᓐ ᒫᒃ ᑳ ᐄᔑ ᓰᑭᐦᐋᐦᑖᑯᐎᔮᒄ᙮” ᑳᐦ ᐄᑎᑯᑦ, “ᒞᓐ ᑳ ᐄᔑ ᓰᑭᐦᐋᐦᑖᒑᑦ ᓂᒌᐦ ᐄᔑ ᓰᑭᐦᐋᐦᑖᑯᓈᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᒞᓐ ᒌ ᓰᑭᐦᐋᐦᑎᐙᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐐ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒫᒃ ᒌ ᐃᔨᑖᑖᑯᐱᓐ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓰᑭᐦᐋᐦᑎᐙᑦ, ᒑ ᑎᑯᔑᓃᔨᒡ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐊᐅᔫᑯᓐ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᒋᐱᐦ ᑖᑆᔨᒫᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐊᔨᒥᐦᐄᑯᒡ ᑆᓪ ᐱᔮᐦᑎᐦᒡ ᐅᔮᔨᐤ, ᒌ ᓰᑭᐦᐋᐦᑎᐙᑭᓂᐎᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐦᒡ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ᐋᒄ ᑆᓪ ᑳ ᑖᐦᑳᑎᐦᐹᓈᑦ, ᑳ ᐲᐦᒋᔥᑳᑯᒡ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ, ᑭᔮᐦ ᒌ ᒀᔅᒡ ᐋᔨᒨᒡ, ᑭᔮᐦ ᒫᒃ ᒌ ᐋᔨᒦᔥᑎᒧᐙᐅᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ᐎᔮᔥ ᒫᒃ ᓃᔓᔖᑉ ᒌ ᐃᐦᑎᔑᐎᒡ ᒫᒨ ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᑖᐦᑳᑎᐦᐹᓈᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ᓂᔥᑐ ᐲᓯᒻ ᒫᒃ ᒌᐦ ᑖᐤ ᑆᓪ ᐊᓂᑎᐦ ᐁᕕᓱᓯᐦᒡ ᑭᔮᐦ ᒨᔥ ᒌ ᐲᐦᒑᐤ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᐋ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᑯᔥᑖᒋᑦ, ᓈᔥᒡ ᐋ ᔒᐦᒋᒫᑦ ᒑ ᒌ ᑖᑆᐦᑖᑯᑦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ᒥᒄ ᒫᒃ ᐱᔅᒡ ᐊᓂᒌ ᑳ ᓂᑐᐦᑎᐦᒡ ᓈᔥᒡ ᒌ ᓰᐱᐦᑎᒧᒡ, ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᑖᑆᐦᑎᒧᒡ, ᑭᔮᐦ ᓈᔥᒡ ᒌ ᒥᒋᐋᔨᒧᑎᒸᒡ ᐊᓂᑖᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑳ ᐄᔑ ᑎᐹᒋᒨᔨᒡ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᒑ ᐱᒧᐦᑖᓂᐎᔨᒡ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑆᓪ ᑳ ᐎᔨᐐᑦ ᐊᓂᑎᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᑳ ᐐᒑᐅᑯᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐋᒄ ᑳ ᐄᑐᐦᑖᒡ ᐊᓂᑖᐦ ᑖᐃᕋᓂᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᒥᒋᐙᐦᐱᔨᐤ ᑳ ᒌ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ ᐋ ᒋᔅᑯᑎᒫᓲᓈᓂᐎᔨᒡ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒌᓴᔅᐦ ᐋᐦ ᐋᔨᒨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ᓃᔓ ᐱᐳᓐ ᒫᒃ ᐃᔥᐱᔥ ᐋᐅᒄ ᑳᐦ ᑎᓈᓂᐎᒡ ᐆ, ᐋᒄ ᒫᒃ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᑖᐱᔥᑯᓐ ᒎᐤ ᑭᔮᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒌ ᐹᐦᑎᒧᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ᒋᔖᒥᓂᑑ ᒫᒃ ᒌᐦ ᑐᑎᐙᐤ ᑆᓪ ᒑ ᒌ ᓲᐦᒋᒫᒥᔥᑳᒡ ᐋ ᐃᐦᑎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ᐙᐙᒡ ᑖᐱᔥᑳᑭᓐ ᑭᔮᐦ ᒫᒃ ᑯᑎᒋᔨᐤ ᐲᒎᔮᓂᔨᐤ ᐋ ᒌ ᑖᐦᒋᐦᓂᐦᒃ ᒌ ᐄᑐᐦᑖᑭᓂᐎᔨᐤ ᐊᓂᑖᐦ ᑳᐦ ᐋᐦᑯᓰᔨᒡ ᐊᐙᔨᐤᐦ ᐋᐦ ᑖᔨᒡ, ᑏᐙᐦᒡ ᒫᒃ ᒌ ᒦᓂᐙᑎᓰᔨᐤᐦ ᐄᔥᐱᐦ ᑎᔮᐦᐄᒋᓂᒥᔨᒡ᙮ ᑭᔮᐦ ᐊᓂᒌ ᒥᒋᐊᐦᒑᐦᑯᒡ ᒌ ᐎᔨᐐᔫᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳ ᐲᐦᒋᔥᑯᐙᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ᐱᔅᒡ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒌ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒥᒋᐊᐦᒑᐦᒄ ᒌ ᐱᐹᒧᐦᑖᐅᒡ ᐋ ᑯᒋᐦᑖᒡ ᒑ ᒌ ᐎᔨᐐᑎᔑᐦᐙᒡ ᒥᒋᐊᐦᒑᐦᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᐅᐦᒋ᙮ ᒌ ᐄᑖᐅᒡ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ, “ᒌᓴᔅ, ᐊᓂᔮᔨᐤ ᑆᓪ ᑳᐦ ᐋᔨᒨᒫᑦ ᐋ ᑭᒑᔅᒀᑦ, ᐋᐅᒄ ᐊᓐ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐅᐦᒋ ᒋᑎᐄᑎᔓᒥᑎᓈᐙᐤ ᒑ ᒌ ᐹᒋ ᐎᔨᐐᔮᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ᐋᒄ ᒫᒃ ᒌᐦ ᑖᐤ ᐹᔨᒄ ᑳ ᓃᑳᓂᓰᑦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒋᑮᕙ ᐋ ᐃᔑᓂᐦᑳᓱᑦ, ᓃᔣᔥᒡ ᐋ ᒌ ᑎᔑᔨᒡ ᐅᑯᓯᔅᐦ, ᐋᐅᒄ ᒫᒃ ᑳᐦ ᑎᔨᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ᐋᒄ ᒥᒄ ᐊᓂᔮᔨᐤ ᒥᒋᐊᐦᒑᐦᒄ ᒌ ᓂᔥᒀᐅᔑᐦᐄᑯᒡ ᐋᐦ ᐄᑎᑯᒡ, “ᓂᒋᔅᒑᔨᒫᐤ ᐊᐙᓐ ᐊᓐ ᒌᓴᔅ ᑭᔮᐦ ᑆᓪ᙮ ᒌᔨᐙᐤ ᒫᒃ ᐐᐦ, ᐄᔨᔨᐅᒡ ᒌᔨᐙᐤ?” ");
INSERT INTO crl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ᐋᒄ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᐲᐦᒋᔥᑳᑯᔨᒡ ᒥᒋᐊᐦᒑᐦᒄ ᒌ ᒥᔅᑎᑯᓰᐦᑳᑯᒡ᙮ ᒌ ᐎᔨᐐᑎᔑᒨᒡ ᐊᓂᑎᐦ ᐙᔅᑳᐦᐄᑭᓂᐦᒡ ᐋ ᒌ ᒥᔂᑭᓂᐦᑳᑎᑯᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤᐦ, ᐋ ᒧᔖᔥᑭᑖᐱᐦᐄᑐᒡ ᐋ ᒌ ᐲᑯᐱᑎᒥᔨᒡ ᐅᒑᒀᓂᒧᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐊᓂᑎᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᒡ ᑳ ᐹᐦᑎᐦᒡ ᐅᔮᔨᐤ ᒥᓯᐙ ᒌ ᓵᒋᓯᐎᒡ᙮ ᐋᒄ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐊᑎᑎᐤ ᑳᐦ ᐋᑎ ᒋᔅᑖᔨᐦᑖᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ᒥᐦᒑᑐ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᒌ ᐹᒋ ᐐᐦᑎᒧᒡ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ᒥᐦᒑᑐ ᒫᒃ ᐊᓂᒌ ᒌ ᐹᑖᐅᒡ ᐅᒥᑖᐅᓯᓂᐦᐄᑭᓂᐙᐤ ᐋᒄ ᑳ ᐃᔥᒀᓯᐦᒡ ᐊᓂᑎᐦ ᐋ ᒥᐦᒑᑎᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑳ ᑎᐱᒋᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᑎᒋᐦᑖᑯᓃᐙᑯᐱᓈ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓐ, ᓂᔮᔪᒥᑎᓂᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᑎᑐᐦᑎ ᒌ ᐄᑎᒋᑖᑯᓂᐙᑯᐱᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ᐆ ᒫᒃ ᐋ ᒌ ᐄᔅᐱᔨᒡ ᒌ ᐋᑎ ᒥᔑᐦᑖᐱᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐆ ᒥᔻᒋᒧᐎᓐ᙮ ᐊᓐ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᓲᐦᒋᐱᔨᐦᒡ ᐆ ᒥᔻᒋᒧᐎᓐ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᐋᑎᑖᑆᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔑᐱᔨᐦᒡ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᑆᓪ ᒌ ᐄᑖᔨᐦᑎᒻ ᑳᐤ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᑭᔮᐦ ᐊᑫᔮ ᐊᔅᒌᐦᒡ, ᐋᒄ ᒫᒃ ᒦᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐄᑖᐦᒑ ᒑ ᒌ ᐄᑐᐦᑖᑦ᙮ ᑆᓪ ᑳᐦ ᐃᔨᑦ “ᐄᔥᐱᐦ ᒌ ᐄᑐᐦᑖᔮᓈ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐋᒄ ᕎᒥᐦᒡ ᑭᔮᐦ ᔮᔨᑖᐃ ᒑ ᐄᑐᐦᑖᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ᐋᒄ ᑳ ᓃᑳᓂᑎᔑᐦᐙᑦ ᓃᔓ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐱᑎᔒᔥᑖᑯᑦ, ᑎᒧᕢ ᑭᔮᐦ ᐊᔨᕋᔅᑎᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ, ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐄᑐᐦᑖᔨᒡ, ᐋᒄ ᐊᓂᑎᐦ ᐋᐃᔖ ᐙᐃᐱᔥᒌᔥ ᑳᐦ ᑖᑦ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ᒫᒀᒡ ᒫᒃ ᐊᓂᑎᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᑦ, ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᒋᔑᐙᔓᐎᒡ ᐊᓂᔮᔨᐤ ᐋ ᐅᔥᑳᔨᒡ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᔨᒡ ᑆᓪ ᐋᐦ ᐃᔨᒡ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᐋᐅᒄ ᒫᔅᑭᓂᐤ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ᐙᔥ ᒌᐦ ᑖᐤ ᐹᔨᒄ ᓈᐹᐤ ᐊᓂᑎᐦ ᐁᕕᓱᓯᐦᒡ, ᑎᒦᑦᕆᔮᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᐋ ᐅᔑᐦᑖᑦ ᐋ ᐃᔮᐱᔖᔑᔨᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔥ ᐋ ᒋᔅᒋᓄᐙᐱᐦᑎᐦᒃ ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᐋ ᐊᔨᒥᐦᐋᔅᑖᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒥᓂᑑᐦᑳᓂᔅᒀᐤ ᐊᕐᑎᒥᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᔔᐎᔮᓈᐱᔅᒄ ᒌ ᐋᐱᒋᐦᐋᐤ ᐅᔮᔨᐤ ᐋ ᐅᔑᐦᑖᑦ᙮ ᒌ ᐊᑖᐙᒑᐤ ᒫᒃ ᐊᓂᔮᔨᐤ᙮ ᒌ ᐐᒋᐦᐄᑯᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐐᒋᐋᐱᑎᓰᒥᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᒥᔥᑎᐦ ᐅᔑᐦᐋᒡ ᔓᐎᔮᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ᐋᒄ ᑳ ᓂᑑᒫᑦ ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᐅᔮᔨᐤ ᑳ ᐄᑖᐱᑎᓰᔨᒡ ᐙᔥ ᓈᔥᒡ ᒌ ᒋᔑᐙᔔ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐋ ᐅᔑᐦᐄᒄ ᔓᐎᔮᓐ ᐆ ᐋᐦ ᐄᑖᐱᑎᓰᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ᑆᓪ, ᒥᐦᒑᑐ ᒌᐦ ᑐᑎᐙᐤ ᐄᔨᔨᐤ ᒑ ᒌ ᑖᑆᐦᑎᒥᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ ᒑᐦ ᐋᑳ ᒌ ᐊᔨᒥᐦᐋᔥᑎᒥᔨᒡ ᒑᒀᔨᐤ ᔔᐎᔮᓈᐱᔅᑯᐦᒡ ᐋ ᒌ ᐅᐦᒋ ᐅᔑᐦᑖᑭᓂᐎᔨᒡ᙮ ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᔨᐤᐦ ᒌ ᑖᑆᐦᑖᑰ ᐅᑎᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᒥᓯᐙ ᐊᓂᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ᐅᔮᔨᐤ ᒫᒃ ᐋ ᐄᔑ ᒋᔅᑯᑎᒫᒑᑦ, ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒧᒡ ᐄᔨᔨᐅᒡ ᐋ ᒥᔻᔒᔨᒡ ᒋᑎ ᐋᐱᑎᓰᐎᓈᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᒋᔅᑖᔨᐦᑖᑭᓅᔨᐤ ᐅᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᑭᔮᐦ ᓂᒧᐃ ᑭᑎ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓂᐤ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᐃᔥᐱᔥ ᒋᔅᑖᔨᐦᑖᑯᓲᐤ ᐊᓐ ᒥᓂᑑᐦᑳᓂᔅᒀᐤ ᐊᕐᑎᒥᔅ, ᐊᓐ ᑳ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓅᑦ ᐅᑎᐦ ᐋᐃᔖ ᑭᔮᐦ ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ᐄᔥᐱᐦ ᒫᒃ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐱᔮᐦᑎᐙᒡ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᒌ ᒋᔑᐙᔓᐎᒡ, ᐋᒄ ᑳ ᑖᑆᒡ, ᐋᐦ ᐃᔨᒡ, “ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐊᕐᑎᒥᔅ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ᐐᐱᒡ ᒫᒃ ᒌ ᐋᑎ ᒥᐦᒑᑑᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᒥᓯᐙ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᒡ᙮ ᒌ ᓃᔔᒡ ᒫᒃ ᓈᐹᐅᒡ, ᑫᔮᔅ ᑭᔮᐦ ᐊᕆᔅᑖᕐᑭᔅ ᐋ ᐃᔑᓂᐦᑳᓱᒡ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮᐦᒡ ᐋ ᒌ ᐅᐦᒌᒡ, ᐋ ᒌ ᐐᒑᐙᒡ ᑆᓪ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᓈᐹᐤ ᑳ ᐅᑎᓈᒡᐦ ᐋᒄ ᑳ ᐄᔑ ᑖᐹᐱᐦᑣᑖᒡ ᐊᓂᑖᐦ ᐄᔨᔨᐤ ᑳ ᒌ ᓂᔥᑐᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ᐋᒄ ᑆᓪ ᑳ ᐐᐦ ᐊᔨᒥᐦᐋᑦ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᑳ ᒋᔑᐙᓰᔨᒡ, ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᓂᒧᐃ ᐅᐦᒋ ᐱᒋᔅᑎᓂᑰ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ᐱᔅᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᐱᑎᔒᔥᑑᐙᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ, ᐊᓂᔮᔨᐤ ᑳ ᐅᐐᒑᐙᑭᓂᑦ ᑆᓪ, ᒌ ᐄᑎᔓᐦᐅᒫᑭᓄᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᐐᐦᑎᒫᑯᑦ ᐋᐦ ᐄᑎᑯᑦ ᒑᐦ ᐋᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᒋᔑᐙᓰᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᒥᓯᐙ ᒌ ᒋᔑᐙᔓᐎᒡ, ᐱᔅᒡ ᒌ ᐋᔑᐦᒀᐅᒡ ᐋᐦ ᐋᔮᔥᑖᒥᑐᒡ, ᒥᐦᒑᑐ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒧᒡ ᒑᒀᔨᐤ ᐙᐦᒋ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ᐋᒄ ᐱᔅᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒌ ᑯᐦᑯᓈᐅᒡ ᓈᐹᐤ ᐋᓕᒃᓵᓐᑎᕐ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᓂᑖᐦ ᓃᑳᓂᐦᒡ ᐄᔑ, ᐋᐦ ᐄᑖᔨᒫᑭᓅᑦ ᐐᔨ ᐋᐦ ᑐᑎᐦᒃ ᐙᐦᒋ ᒋᔑᐙᓯᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑳ ᐅᐦᐱᓂᔅᒑᔨᑦ ᒑ ᒌ ᒋᐱᐦᒋᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐄᔨᔨᐤᐦ ᐋ ᑖᑆᔨᒡ, ᐋ ᐐᐦ ᐐᐦᑎᒧᐙᑦ ᐋᐦᐋᑳ ᐎᔮᔥ ᐅᐦᒋ ᑎᒃ ᐐᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒑᔅᒑᔨᒫᒡ ᐋᓕᒃᓵᓐᑎᕐᐦ ᒎᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ, ᒥᓯᐙ ᒫᒨ ᒌ ᑖᑆᐅᒡ, “ᒋᔅᑖᔨᐦᑖᑯᓯᐤ ᐊᕐᑎᒥᔅ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᑦ᙮” ᓃᔣᐤ ᐋ ᒌᓂᒀᓂᐦᑖᔨᔨᒡ ᒫᒃ ᒌ ᐃᔥᐱᔥ ᑖᑆᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ᒑᒃ ᒫᒃ ᐊᓐ ᐹᔨᒄ ᑳ ᓃᑳᓂᔥᑳᒑᑦ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ ᑳ ᒋᐱᐦᒋᐦᐋᑦ ᐋ ᑖᑆᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌᔨᐙᐤ ᐁᕕᓱᓯᐦᒡ ᑳ ᐅᐦᒋᔮᒄ, ᒥᓯᐙ ᐊᐙᓐ ᒋᔅᒑᔨᐦᑎᒻ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᐁᕕᓱᓯᐦᒡ ᐋᐦᑎᑯᐦᒡ ᐊᓐ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᐊᓂᑖᐦ ᑳ ᒌ ᑭᓂᐙᔨᒫᑭᓅᑦ ᐊᓐ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᑦ ᐊᕐᑎᒥᔅ ᑭᔮᐦ ᐊᓐ ᑳ ᒋᔅᑖᔨᒫᑭᓅᑦ ᐊᓯᓃ ᒌᔑᑯᐦᒡ ᑳ ᐅᐦᒋ ᐱᒋᔑᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐋᓍᐦᑎᒻ ᐅᔮᔨᐤ᙮ ᐴᓃᒄ ᒫᒃ ᐆ ᐋ ᐊᔨᐦᑎᔮᒄ ᑭᔮᐦ ᔮᒀᒦᒄ ᑖᓐ ᒑ ᐊᔨᐦᑎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ᒋᒌ ᐹᔑᐙᐙᐅᒡ ᐅᒌ ᓈᐹᐅᒡ ᐋᐦ ᐋᑦᐦ ᐋᑳ ᒫᒃ ᐅᐦᒋ ᑭᒑᒧᑎᒡ ᐊᓂᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᒫᔮᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒌ ᒥᓂᑑᐦᑳᓂᔅᒀᒥᓅᐤ ᐊᕐᑎᒥᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ᐋᒄ ᑎᒦᑦᕆᔮᔅ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᒋᐋᐱᑎᓰᒫᑦ ᐎᔮᔥ ᐋᑖᔨᐦᑎᒧᐙᒀ, ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᒋᐱᐦ ᐄᑐᐦᑖᐅᒡ᙮ ᐙᔥ ᐋᐱᐦᐄᑭᓂᐤ ᐊᓐ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᒄ ᑭᔮᐦ ᑖᐅᒡ ᐊᓂᒌ ᑎᐹᔅᑯᓂᒑᓯᐎᒡ, ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑖᐦ ᒋᐱᐦ ᓂᑑᐋᔨᒧᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ᐋᒄ ᒫᒃ ᐋᐦᑎᑯᓃᒀ ᒦᓐ ᒑᒀᓐ ᐋ ᐐᐦ ᐃᔨᔮᒄ, ᓂᑑᐐᐦᑎᒧᒄ ᐄᔥᐱᐦ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᓂᔥᑐᐐᓈᓂᐎᐦᒑ᙮ ᐐᔨᐙᐤ ᒋᑭ ᐎᔮᔨᐦᑎᒧᒡ ᑖᓐ ᒑ ᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ᑯᔥᐱᓈᑖᔨᐦᑖᑯᓐ ᒌᔮᓂᐤ ᒑ ᒌ ᐊᑖᒫᔨᐦᑖᑯᓯᔨᐦᒄ ᐋ ᒥᒋᐱᔨᑖᔨᐦᒄ ᒑᒀᓐ ᐆ ᐊᓅᐦᒡ ᑳ ᐊᔨᐦᑎᓈᓂᐎᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒑᒀᓐ ᑎᑯᓐ ᐙᐦᒋ ᒥᒋᐱᔨᓈᓂᐎᒡ ᑭᔮᐦ ᓂᒧᐃ ᒋᑭ ᒌ ᐐᐦᑖᓈᓂᐤ ᒑᒀᓐ ᐙᐦᒋ ᐄᔅᐱᔨᔨᒡ ᐆ᙮” ");
INSERT INTO crl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᐊᓐ ᑳ ᓃᑳᓂᔥᑭᐦᒃ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ, ᐋᒄ ᑳ ᐄᒑᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᓂᔥᑐᐐᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐋᑎ ᒋᐱᐦᑣᐙᑖᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᑎᑖᑯᓯᓈᓂᐎᔨᒡ ᑭᔮᐦ ᑳ ᒌᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑆᓪ ᒌ ᓂᑑᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ᙮ ᐋᒄ ᑳᐦ ᐋᔨᐦᑭᒫᑦ ᓲᐦᒃ ᒑ ᐐᐦ ᔮᐃᒋᑳᐳᐎᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐙᒋᔮᒫᑦ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᑦ ᒫᓯᑐᓂᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᐋᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋᐦ ᐋᑎ ᐱᒧᐦᑖᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒫᓯᑐᓂᔮᐦᒡ ᒌ ᐙᐱᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᓂᓈᐦᑭᐤ ᐃᐦᑖᐎᓂᐦᒡ ᑳᐦ ᐋᑎ ᐃᔨᐦᑖᔨᒡ ᐊᓂᑖᐦ ᐄᑖᐦᒑ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᒦᓐ ᑳᐦ ᐋᔨᐦᑭᒫᑦ ᒑ ᒌ ᔮᐃᒋᑳᐳᐎᔨᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ ᑭᔮᐦ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ᙮ ᒑᒃ ᐊᓂᑖᐦ ᑭᕇᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᑳᐦ ᐋᑎ ᐃᔨᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ᓂᔥᑐ ᐲᓯᒻ ᒫᒃ ᒌᐦ ᑖᐤ ᐊᓂᑎᐦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐃᔮᔅᑭᐐᑦ ᒑ ᐄᑖᔑᑦ ᐊᓂᑖᐦ ᓯᕆᔮᐦᒡ ᐊᔅᒌᐦᒡ, ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒋᐐᐦ ᓂᐱᐦᐄᑰ, ᐋᒄ ᑳ ᐎᔮᔨᐦᑎᐦᒃ ᑳᐤ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮᐦᒡ ᒑ ᐄᔑ ᒌᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ᒌ ᒥᐦᒑᑎᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐐᒑᐅᑯᑦ᙮ ᔂᐹᑎᕐ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐊᓂᔮᔨᐤ ᐹᔨᒄ, ᐹᐃᕋᔅ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐅᐦᑖᐐᐦ᙮ ᐯᕆᔾ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐋᑯᑖᐦ ᑳ ᐅᐦᒌᒡ᙮ ᐋᒄ ᒦᓐ ᓃᔓ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᕞᓵᓨᓈᐃᑳᐦᒡ ᐃᐦᑖᐎᓐ ᐋ ᐅᐦᒌᔨᒡ ᒌ ᐐᒑᐅᑰ ᑆᓪ, ᐋᔪᐎᒄ ᐊᓐ ᐊᕆᔅᑖᕐᑭᔅ ᑭᔮᐦ ᓯᑭᓂᑐᔅ᙮ ᐋᒄ ᒦᓐ ᐊᓂᑖᐦ ᑎᕐᐲ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐹᔨᑯᔑᔨᐤ ᐊᓂᑎᐦ ᐋ ᐅᐦᒌᔨᒡ ᐋ ᐐᒑᐅᑯᑦ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑫᔮᔅ᙮ ᑎᒧᑏᐦ ᑭᔮᐦ ᒌ ᐐᒑᐅᑰ᙮ ᐋᒄ ᓃᔓ ᒦᓐ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᐋᐃᔖ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐊᔅᒌᔨᐤ ᐋ ᐅᐦᒌᔨᒡ ᒌ ᐐᒑᐅᑰ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᑖᐃᑭᑭᔅ ᑭᔮᐦ ᑦᕎᕕᒥᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ᒌ ᓃᑳᓂᐦᑖᐅᒡ ᐅᒌ ᓈᐹᐅᒡ ᐋᒄ ᐊᓂᑖᐦ ᑦᕎᐋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᑯᑖᐦ ᑳᐦ ᐋᔑᓂᐙᐦᐄᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ᐊᓂᑖᐦ ᒫᒃ ᕕᓕᐹᐃᐦᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐴᓯᔮᐦᒡ ᓃᔮᓐ ᐄᔥᐱᐦ ᐊᓐ ᑳᔑᑳᒡ ᑳ ᒌ ᒧᐙᑭᓅᑦ ᐋᐃᐦᑯᓈᐤ ᐋᐦᐋᑳ ᐅᐦᐱᓱᑦ᙮ ᓂᔮᔪ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᑳ ᐅᑎᐦᑎᐦᐆᒋᐦᒡ ᐊᓂᑖᐦ ᑦᕎᐊᔅᐦ᙮ ᐋᑯᑖᐦ ᑳᐦᑖᔮᐦᒡ ᐹᔨᒄ ᑎᐎᔥᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ᐊᓐ ᒫᒃ ᒥᔮᑎᓂᐙᒌᔑᑳᒡ ᐋᐦ ᐋᑎ ᐅᑖᑯᔑᔨᒡ ᓂᒌ ᓂᔥᑐᐐᓈᓐ ᒑ ᒌ ᒫᒨ ᒦᒋᓱᔮᐦᒡ᙮ ᑆᓪ ᒫᒃ ᒌ ᐊᔨᒥᐦᐋᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐹᒋ ᓂᔥᑐᐎᔨᒡ᙮ ᐐᐱᒡ ᒋᐐᐦ ᒋᔅᑐᐦᑖᐤ ᐊᓂᔮᔨᐤ ᒦᓐ ᑳᔑᑳᔨᒡ, ᐋᒄ ᒫᒃ ᓈᐅᔥ ᑳᐦ ᐋᑎᐃᔨᒥᑦ᙮ ᐲᐦᐃᒻ ᒌ ᐋᐱᐦᑖᑎᐱᔅᑳᔨᐤ ᐋᔥᒄ ᐋ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ᐊᓂᑖᐦ ᒫᒃ ᐊᓐ ᑳ ᓂᔥᑐᐎᔮᐦᒡ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᒌ ᒥᐦᒑᓐ ᐙᔥᑖᓂᒫᑭᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ᒌᐦ ᑖᐤ ᒫᒃ ᐊᓂᑎᐦ ᐅᔅᒋᓃᒎ ᔫᑎᑭᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᐊᓂᑖᐦ ᐙᓵᓂᐦᑖᑭᓂᔨᐤ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑎᐦ ᒫᒃ ᐋ ᑳᐦᑎᐹᓰᔨᒡ ᐋᑯᑖᐦ ᑳ ᐊᐱᑦ᙮ ᒌ ᐋᐱᐦᐄᑯᑖᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐙᓵᓂᐦᑖᑭᓂᔨᐤ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᓈᐅᔥ ᐊᔨᒥᔨᒡ ᑆᓪ ᒑᒃ ᒌ ᑭᐎᑯᔓ ᐊᓐ ᓈᐹᔥ ᐋᒄ ᑳ ᐎᔨᐐᐱᔨᑦ ᐊᓂᔮᔨᐤ ᐙᓵᓂᐦᑖᑭᓂᔨᐤ᙮ ᒋᐦᒋᐙ ᒫᒃ ᒌ ᐃᔥᐹᓈᔨᐤ ᐊᓂᑖᐦ ᑳ ᐅᐦᒋ ᐋᒥᐱᔨᑦ᙮ ᐄᔥᐱᐦ ᓈᑎᐙᐦᐋᑭᓅᑦ, ᔖᔥ ᓂᒧᐃ ᐅᐦᒋ ᐱᒫᑎᓰᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ᐄᔥᐱᐦ ᒫᒃ ᒨᔑᐦᑖᑦ ᑆᓪ ᑖᓐ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᒌ ᓃᐦᑖᐦᑎᐐᐤ, ᐋᒄ ᑳ ᐅᒋᐦᒌᐦᑯᓂᐱᔨᐦᐅᑦ ᐅᐦᐱᒫ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᑭᔮᐦ ᑳᐦ ᐋᑎᐙᐅᒋᓈᑦ᙮ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᐊᑳᐐ ᐋᔨᒫᔨᐦᑎᒧᒄ, ᓂᒧᐃ ᐴᓂᐱᒫᑎᓰᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ᐋᒄ ᒦᓐ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᑳ ᐄᑐᐦᑖᑦ ᑆᓪ, ᑳ ᐱᐦᒀᓈᑦ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᒑ ᒧᒥᒋᐦᒡ ᒑ ᐐᒋᒦᒋᓱᒥᒋᐦᑦ᙮ ᒦᓐ ᒫᒃ ᒌ ᐋᑎ ᐊᔨᒧᐤ᙮ ᒑᒃ ᐱᔮᑖᐱᓃᔨᒡ ᐋᔥᒄ ᐋ ᐊᔨᒥᑦ, ᐋᒄ ᒫᒃ ᑳ ᒋᔅᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ᐋᒄ ᐊᓐ ᓈᐹᔥ ᑳ ᐎᔨᐐᐱᔨᑦ ᒌ ᒌᐙᐦᑎᐦᐋᑭᓂᐤ᙮ ᓄᐎᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ᐊᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᓂᒌᐦ ᐄᑖᔑᓈᓐ ᐊᓂᑖᐦ ᐊᓐ ᐊᔂᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᓂᐱᐦ ᐅᐦᒋ ᐴᓯᐦᐋᓈᓐ ᑆᓪ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑎᔓᐙᑦ ᐙᔥ ᒌ ᐱᒧᐦᑖᐤ ᐐᔨ ᐊᓂᑖᐦ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᓂᒋᔥᑭᐎᔨᒥᐦᑦ ᐊᓂᑖᐦ ᐊᔂᔅ, ᓂᒌ ᐴᓯᐦᐋᓈᓐ ᐋᒄ ᐊᓂᑖᐦ ᒥᑎᓖᓃ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᑳ ᐄᑖᔑᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ᒦᓐ ᐎᔮᐱᐦᒡ, ᐋᑯᑖᐦ ᒦᓐ ᑳ ᐅᐦᒋ ᒋᔥᑖᔑᔮᐦᒡ ᐋᒄ ᐊᓐ ᒥᓂᔥᑎᒄ ᑮᔻᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᑳᐦ ᐋᑎᔮᐃᐦᐊᒫᐦᒡ᙮ ᒦᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᐋᒄ ᒦᓐ ᑯᑎᒡ ᒥᓂᔥᑎᒄ ᓵᒸᔅ ᐋ ᐃᔑᓂᐦᑳᑖᒡ ᑳ ᐅᑎᐦᑎᐦᐊᒫᒡ᙮ ᒦᓐ ᐎᔮᐱᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᒥᓖᑖᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐋᑯᑖᐦ ᑳ ᒥᓯᑳᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ᑆᓪ ᒫᒃ ᒌ ᐎᔮᔨᐦᑎᒻ ᐋᑳ ᒑ ᑭᐹᐅᒋᐦᑦ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ, ᐋᒄ ᑳ ᒥᔮᐅᐦᐊᒫᐦᒡ ᐊᓐ ᐃᐦᑖᐎᓐ᙮ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᐅᑎᒦᐤ ᐊᓂᑎᐦ ᐋᐃᔖᒡ ᐊᔅᒌᐦᒡ, ᐙᔥ ᒋᐐᐦ ᐅᑎᐦᑎᒻ ᒉᕉᓯᓕᒥᔨᐤ ᐋᒸᔮ ᐹᓐᑏᒀᔅᑦ ᒌᔑᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ᑆᓪ ᒫᒃ ᐊᓂᑖᐦ ᒥᓖᑖᔅ ᒌ ᐅᐦᒋ ᐄᑎᔓᐙᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒨᐦᐄᒫᑭᓄᐐᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐅᒫᒨᐊᔨᒥᐦᐋᐤ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐋ ᓂᑑᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᑎᑯᔑᓃᔨᒡ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ᙮ ᒌᐦ ᐄᑖᐤ, “ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᑳ ᐄᔑ ᐱᒫᑎᓰᔮᓐ ᑳ ᐃᔥᐱᔒ ᑖᔮᓐ ᐅᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᐲᐦᐃᒻ ᑳ ᒋᔅᑐᐦᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ᐋ ᒌ ᐋᐱᑎᔒᔥᑑᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑎᐱᐦᑖᔨᒧᐎᓂᐦᒡ ᐄᔑ ᑭᔮᐦ ᐋᔅᑭᐤ ᐋ ᒌ ᒫᑑᔮᓐ᙮ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒥᐦᐅᔮᓐ ᒫᓐ ᐊᓂᔮᔨᐤ ᑳ ᐃᔥᐱᔥ ᒨᔥ ᒋᐐᐦ ᐎᔮᔥ ᑐᑎᐎᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ᑭᔮᐦ ᒫᒃ ᐋᐦᐋᑳ ᐅᐦᒋ ᑳᑣᑎᑯᒡ ᒑᒀᓐ ᑖᓐ ᒑ ᒌ ᐄᔑ ᐐᒋᐦᐄᑯᔮᒄ᙮ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᑖᓐ ᑳ ᐄᔑ ᒋᔅᒋᓄᐦᐊᒫᑎᑯᒡ ᐊᓂᑖᐦ ᐋ ᓂᔥᑐᐐᓈᓂᐎᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᒌᒋᐙᐦᒡ, ");
INSERT INTO crl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ᐋ ᐐᐦᑎᒨᒀᐤ ᑖᐱᔥᑯᓐ ᒎᐤ ᑭᔮᐦ ᒃᕇᒃ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐋ ᓂᑎᐙᔨᐦᑖᑯᓯᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐋ ᓈᑖᒡ ᑭᔮᐦ ᒑ ᒌ ᑖᑆᔮᔨᒫᒡ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ᓂᑐᐦᑎᒧᒄ ᒫᒃ, ᐊᓅᐦᒡ ᓈᔥᒡ ᓲᐦᒋᐱᔨᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒑ ᒌ ᓂᓂᐦᐄᐦᑑᒃ ᐋᐦ ᐄᑎᔓᒥᑦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᐄᑐᐦᑖᐅᒡ, ᓂᐱᐦ ᐄᑐᐦᑖᓐ ᒫᒃ ᐊᓂᑖᐦ ᐊᓅᐦᒡ᙮ ᓂᒧᐃ ᓂᒋᔅᒑᔨᐦᑖᓐ ᒑᒀᓐ ᒑ ᐅᑎᐦᑎᐦᐅᑯᔮᓐ ᐊᓂᑖᐦ ᑖᔮᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ᒫᐤ ᒥᒄ ᒑᔅᒑᔨᐦᑎᒫᓐ, ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᓂᓃᑳᓐ ᐊᓂᒌ ᐐᐦᑎᒫᒄ ᒑ ᒋᐱᐦᐅᑯᐎᒡ ᑭᔮᐦ ᓂᓈᐦᑭᐤ ᒑ ᐄᔑ ᐋᔨᒥᐦᐅᒡ ᒥᓯᐙ ᐃᐦᑖᐎᓂᐦᒡ ᒑ ᐋᑎ ᐄᑐᐦᑖᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ᓂᒧᐃ ᒫᒃ ᒥᑐᓐ ᐎᔮᔥ ᓂᑎ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᓐ ᓂᐱᒫᑎᓰᐎᓐ ᐙᔥ ᒫᒃ ᐄᔥᐱᐦ ᒌᔑᐱᔨᐦᒑ ᓂᐱᒫᑎᓰᐎᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᒌ ᒌᔑᑖᔮᓈ ᑖᓐ ᑳᐦ ᐄᑎᔓᒥᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᒑ ᐄᑖᐱᑎᓰᐎᒡ, ᐋᔪᐎᒄ ᐋᒄ ᐅᔮᔨᐤ ᒑ ᒌ ᐙᐐᐦᑎᒧᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᐅᑎᐦ ᒫᒃ ᒥᔻᒋᒧᐎᓂᐦᒡ ᐋᑯᑖᐦ ᐃᔮᔨᒨᑖᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ᓂᑐᐦᑎᒧᒄ ᒫᐦ, ᓂᒋᔅᒑᔨᐦᑖᓐ ᐋᐦ ᐋᐅᒡ ᐆ ᐊᓅᐦᒡ ᒫᐦᒑᔨ ᒑ ᐙᐱᒥᔮᒄ ᒌᔨᐙᐤ ᐆ ᑳ ᒌ ᐙᐐᐦᑎᒫᑎᑯᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒌᐅᒋᒫᐎᓐ ᐅᑖᐦ ᐄᑖᐦᒑ ᑳᐦ ᑖᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᑯᐃᔅᒄ ᐐᐦᑎᒫᑎᑯᒡ ᐆ ᐊᓅᐦᒡ ᑳᔑᑳᒡ ᓂᒧᐃ ᓃᔨ ᓂᑭ ᐅᐦᒋ ᐊᑖᒫᔨᐦᑖᑯᓯᓐ ᐋᑳ ᒌ ᐱᒫᒋᐦᐆᒑ ᐊᐙᓐ ᐅᑎᐦ ᐋ ᑎᔑᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ᐙᔥ ᓂᒧᐃ ᒥᑐᓐ ᓅᐦᒋ ᓅᒋᓐ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐐᐦᑎᒫᑎᑯᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᑖᒄ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᑎᔮᒄ, ᓂᒧᐃ ᒥᑐᓐ ᒑᒀᓐ ᑰᐦᒋ ᑳᑣᑎᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ᓲᐦᒃ ᒫᒃ ᓈᓈᑭᑐᐙᔨᒦᓱᒄ ᑭᔮᐦ ᓲᐦᒃ ᐐᐦ ᒥᔪ ᑭᓂᐙᔨᒫᐦᑯᒡ ᑳ ᑖᑆᔮᔨᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᑳ ᒥᔨᑖᒄ ᒑ ᒌ ᓈᓈᑭᒋᐦᐄᒫᒄ᙮ ᔮᒀᐦ ᐄᔑ ᑭᓂᐙᔨᒫᐦᑯᒡ ᐅᒫᒨᐊᔨᒥᐦᐋᐅᒡ, ᐙᔥ ᒋᔖᒥᓂᑑ ᐐᔨ ᒌ ᑎᐱᐦᐙᐤ ᐅᔮᔨᐤ ᒑ ᒌ ᐅᑎᔨᔨᒦᑦ ᐅᐦᒋ ᐐᔨ ᑎᐲᐙ ᐅᑯᓯᔅᐦ ᐅᒥᐦᑯᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ᓂᒋᔅᒑᔨᐦᑖᓐ ᐙᔥ ᐄᔥᐱᐦ ᒌ ᒋᔅᑐᐦᑖᔮᓈ, ᒑ ᐅᑎᐦᑎᑖᑯᒡ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᑯᐃᔅᒄ ᐄᔑ ᒋᔅᑯᑎᒫᒑᒡ ᓈᔥᒡ ᐋᐦᐋᑳ ᓂᓂᐦᐋᑳᑎᓰᔨᒡ ᒧᔮᒻ ᒥᐦᐄᐦᑭᓂᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ, ᒋᑭ ᐐᐦ ᐙᓈᒋᐦᑎᒫᑯᐙᐅᒡ ᑖᑆᔮᔨᐦᑎᒨᐎᓂᔨᐤ ᐋ ᒫᒨ ᐊᔨᒥᐦᐋᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ᐋᐦᐋ, ᐙᐙᒡ ᑭᔮᐦ ᐊᓂᑎᐦ ᑖᐙᔨᔥ ᐋᐦ ᑖᔮᒄ ᒋᑭ ᐅᐦᒋ ᐎᔨᑳᐳᐎᒡ ᐄᔨᔨᐅᒡ ᐋ ᐐᐦ ᒀᔅᒋᐱᔨᐦᑖᒡ ᑖᑆᐎᓂᔨᐤ ᑭᔮᐦ ᐋ ᐐᐦ ᐄᒑᐱᑖᒡ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ, ᐐᔨᐙᐤ ᒦᔥᑯᒡ ᒑ ᒌ ᓅᔔᔥᑳᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ᔮᒀᒦᒄ ᒫᒃ, ᒨᔥ ᒋᔅᒍᒄ ᓂᔥᑐ ᐱᐳᓐ ᐃᔥᐱᔥ ᐅᑖᐦ ᐄᔑ ᐅᑖᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐴᓂᔮᓐ ᒨᔥ ᐋ ᒌ ᔮᒀᒥᒥᑎᑯᒡ, ᑭᔮᐦ ᐋ ᒌ ᒫᑑᔮᓐ ᑳ ᐃᔥᐱᔥ ᓲᐦᒃ ᐐᐦ ᐐᒋᐦᐄᑎᑯᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᒋᑎ ᐄᔑ ᐱᒋᔅᑎᔓᐙᑎᑎᓈᐙᐤ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᑦ ᒑ ᒥᔪ ᑭᓂᐙᔨᒥᑖᒄ ᑭᔮᐦ ᐅᑎᔨᒧᐎᓐᐦ ᒑ ᒋᔖᐙᑐᑖᑯᐙᒄ᙮ ᐅᒥᔪᐦᑳᒑᐎᓂᐦᒡ ᑭᔮᐦ ᐅᑎᔨᒧᐎᓂᐦᒡ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᔮᒄ ᑭᔮᐦ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᐃᔮᔮᒄ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐐᐦ ᐄᔑ ᒥᔮᑦ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᐅᐙᔮᔨᒫᑦ ᒑ ᐅᑏᔨᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᒧᔥᑖᓂᒨᒃ ᐊᐙᓐ ᐅᔔᔮᓂᒻ ᑭᔮᐦ ᒫᒃ ᐅᒑᒀᓂᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑭᔮᐦ ᓃᔨ ᑎᐱᔨᐙ ᐋ ᒌ ᐃᔮᐱᑎᓯᔮᓐ ᒑ ᒌ ᐅᐦᒋ ᐅᐦᑎᓂᒫᓱᔮᓐ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒫᓐ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᑎᓰᔮᓐ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒡ ᐊᓂᒌ ᑳ ᐐᒑᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ᐊᓐ ᒫᒃ ᒥᓯᐙ ᑳᐦ ᐋᑎ ᐃᔨᐦᑎᔮᓐ ᑭᔮᐦ ᑳ ᐃᔥᐱᔥ ᒥᔥᑏᐦ ᐋᐱᑎᓰᔮᓐ ᒨᔥ ᒋᒌ ᐐᐦ ᐙᐱᐦᑏᑎᓈᐙᐤ ᑖᓐ ᐊᓐ ᒋᐱᐦ ᐐᐦ ᐄᔑ ᐐᒋᐦᐋᓂᐎᒡ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒋᔅᒋᓰᔨᐦᒄ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ, ᐊᑎᑎᐤ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᔨᐙᑦ ᒑᒀᔨᐤ ᔑᐙᔨᐦᑖᑯᓲ ᐃᔥᐱᔥ ᐐᔨ ᐊᓐ ᐊᐙᓐ ᑳ ᒥᔮᑭᓅᑦ ᒑᒀᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᒌᔥ ᐊᔨᒥᐦᐋᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᑳᐦ ᑖᔨᒡ ᐋᒄ ᒥᓯᐙ ᑳ ᓃᐱᔅᑰᐱᒡ ᐋ ᐊᔨᒥᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ᒥᓯᐙ ᒫᒃ ᒌ ᒫᑑᔨᐤᐦ ᑭᔮᐦ ᒌ ᐙᐅᒋᓂᑰ ᐋᐆᒑᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ᓈᔥᒡ ᐋ ᒥᒑᔨᐦᑎᒥᔨᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᒌ ᐄᑖᑦ ᐋᑳ ᒦᓐ ᒑ ᐅᐦᒋ ᐙᐱᒥᑯᑦ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒫᐅᒡ ᑳ ᒫᑯᐦᐄᑯᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐋᑎᐐᒑᐅᑯᑦ ᐊᓂᑖᐦ ᒌᒫᓂᐦᒡ ᐋᐦ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐙᒋᔮᒥᒋᐦᒡ, ᐋᒄ ᒦᓐ ᑳ ᒋᔥᑖᔑᔮᐦᒡ, ᐋᒄ ᐊᓂᑖᐦ ᒀᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᑯᐃᔅᒄ ᑳ ᐄᑖᔑᔮᐦᒡ᙮ ᒦᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᕎᑎᓯᐦᒡ ᑳᐦ ᐋᑎᐱᒫᔑᔮᐦᒡ, ᐋᒄ ᐊᓂᑖᐦ ᐅᐦᒋ ᐹᑖᕋ ᑳ ᐄᑖᔥᑎᒥᓱᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᐹᑖᕋ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᑯᑖᐦ ᑳᐦ ᑎᑯᐦᒡ ᒌᒫᓐ ᐊᓂᑖᐦ ᕛᓃᓰᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᔅᒌ ᐋ ᒌ ᐐᐦ ᐄᑖᔥᑎᑖᑭᓂᐎᒡ᙮ ᑳ ᐴᓯᔮᐦᒡ ᐊᓐ ᒌᒫᓐ᙮ ᐋᒄ ᒦᓐ ᑳ ᒋᔥᑖᔑᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᐦᑎᒫᐦᒡ ᐊᓐ ᒥᓂᔥᑎᒄ ᓵᐃᑉᕋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐲᓯᒸᑖᐦᒡ ᐄᑖᐦᒑ ᓂᒌᐦ ᐄᔑ ᒥᔮᐅᐦᐋᓈᓐ, ᐋᒄ ᑯᐃᔅᒄ ᐊᓂᑖᐦ ᓯᕆᔮ ᐊᔅᒌᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᑖᔥᑎᒥᓱᔮᐦᒡ᙮ ᐊᓐ ᒫᒃ ᐃᐦᑖᐎᓐ ᑖᐃᕋ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᓂᑖᐦ ᓯᕆᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐋᑯᑖᐦ ᑳ ᓈᑎᑳᒫᐦᐋᒫᐦᒡ ᐋᑯᑖᐦ ᑭᔮᐦ ᑳ ᐊᒀᓈᓱᓈᓃᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ᐋᒄ ᑳ ᓂᑎᐙᐱᒥᒋᐦᒡ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ᙮ ᐹᔨᒄ ᑐᔥᑖᐤ ᒫᒃ ᓂᒌ ᑖᐙᓈᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᐊᓂᒌ ᒫᒃ ᑳ ᑖᑆᐦᑎᐦᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒌ ᑐᑖᑯᒡ ᒑ ᒌ ᐃᔮᒀᒥᒫᒡ ᑆᓪ ᐋᑳ ᒑ ᒌ ᐄᑐᐦᑖᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ᒥᒄ ᒫᒃ ᐄᔥᐱᐦ ᐙᑎᐦᒋᐱᔨᐦᒡ ᒑ ᒋᔅᑐᐦᑖᔮᐦᒡ, ᒥᒄ ᓂᒌᐦ ᐄᔑ ᒋᔅᑐᐦᑖᓈᓐ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᑭᔮᐦ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ ᓂᒌ ᐐᒑᐅᑯᓈᓂᒡ ᐋ ᓈᓯᐹᐎᒋᐦᑦ᙮ ᐋᒄ ᒥᓯᐙ ᑳ ᓃᐱᔅᑰᐱᔮᐦᒡ ᐊᓂᑎᐦ ᔑᔓᒡ ᐋ ᐊᔨᒥᐦᐋᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐙᒋᔮᒥᑐᔮᐦᒡ, ᐋᒄ ᑳ ᐴᓯᔮᐦᒡ ᓃᔮᓐ ᐊᓐ ᒌᒫᓐ, ᐋᒄ ᑳ ᒌᐙᒡ ᐐᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᑖᐃᕋ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐅᐦᒋ ᐋᒄ ᐱᑣᓚᒫᐃᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᑳ ᑭᐹᔮᐦᒡ, ᑳᐦ ᐋᑎ ᓂᑎᐙᐱᒥᒋᐦᒡ ᐊᓂᒌ ᐐᒋᔖᓂᒫᐅᒡ᙮ ᐹᔨᒄ ᒌᔑᑳᐤᐦ ᓂᒌ ᑖᐙᓈᓐ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ᐋᒄ ᒫᒃ ᐎᔮᐱᐦᒡ ᐋᒄ ᑳ ᒋᔅᑐᐦᑖᔮᐦᒡ ᐊᓂᑖᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᓭᓯᕇᔮᐦ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᑳ ᐄᑐᐦᑖᔮᐦᒡ᙮ ᕕᓕᑉ ᒫᒃ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᓈᐹᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᐋᐅᒄ ᐆ ᐐᒋᐦᒡ ᑳ ᐃᐦᑖᐎᒋᐦᑦ᙮ ᐋ ᑭᒑᔅᒀᑦ ᒌ ᐄᑖᐱᑎᓰᐤ ᐆ ᕕᓕᑉ ᑭᔮᐦ ᐋᐅᒄ ᐆ ᐹᔨᒄ ᐊᓂᒌ ᓃᔣᔥᒡ ᑳ ᐃᑎᔑᒡ ᑳ ᐅᐙᔮᐱᒫᑭᓂᐎᒡ ᒑ ᒌ ᓈᑎᒫᒑᒡ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ᒌ ᓈᐎᔨᐤ ᐅᑖᓂᔅᐦ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᐅᓈᐹᒥᔨᒡ ᑭᔮᐦ ᒫᒃ ᒌ ᒋᔅᒋᐙᐦᐄᒑᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ᐙᐃᐱᔥᒌᔥ ᒫᒃ ᑳ ᑖᔮᐦᒡ ᐊᓂᑎᐦ, ᐋᒄ ᑳ ᑎᑯᔑᐦᒃ ᓈᐹᐤ ᑳ ᒋᔅᒋᐙᐦᐄᒑᓯᐎᑦ᙮ ᐊᑳᐹᔅ ᒌ ᐃᔑᓂᐦᑳᓲ᙮ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᒌ ᐅᐦᑐᐦᑖᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ᐋᒄ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᔨᒥᐦᑦ ᐆ ᓈᐹᐤ, ᑳ ᐅᑎᓂᒫᑦ ᑆᓪ ᐆ ᐱᐦᑯᐦᑖᐦᐅᓂᔨᐤ, ᑳ ᒫᐦᑯᐱᑎᐦᒃ ᐅᓯᑦ ᑭᔮᐦ ᐅᑎᐦᒌ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᒫᐤ ᐃᔮᑦ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ, ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐄᑖᐱᐦᑳᑎᑯᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔨᒡ ᐊᓐ ᐊᐙᓐ ᑎᐱᔨᐙᐅᓯᑦ ᐅᔮᔨᐤ ᐱᐦᑯᐦᑖᐦᐅᓐ᙮ ᒋᑭ ᐄᔑ ᐱᒋᔅᑎᓂᑰ ᑭᔮᐦ ᐅᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᓂᑖᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᐦᒃ ᐊᓐ ᐊᑳᐹᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᒫᐦᒡ ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᑦ, ᓃᔮᓐ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᑯᑎᑭᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ, ᓂᒌ ᐐᐦ ᒋᔅᑎᐦᐋᒧᐙᓈᓐ ᑆᓪ ᒑ ᒌ ᐄᑐᐦᑖᑦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ᒥᒄ ᒫᒃ ᓂᒌᐦ ᐄᑎᑯᓈᓐ, “ᒑᒀᓐ ᐙᐦᒋ ᒫᑐᔮᒄ, ᓂᑯᔑᑯᑖᐦᐋᓐ ᐋ ᒫᑐᔮᒄ᙮ ᐊᔮᐱᒡ ᐙᔥ ᓂᑭ ᐄᑐᐦᑖᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᔖᔥ ᐙᔥ ᓂᑎᔮᔅᑭᐐᓐ, ᓂᒧᐃ ᒥᒄ ᒑ ᒌ ᒋᐱᐦᐅᑭᐎᔮᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅ ᐅᑎᔑᓂᐦᑳᓱᐎᓐ ᐅᐦᒋ, ᓂᑎᔮᔅᑭᐐᓐ ᑭᔮᐦ ᒑ ᐐᐦ ᓂᐱᐦᐄᑯᐙᓈ ᐐᔨ ᐅᐦᒋ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐃᔑᔨᒥᐦᑦ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ᓂᒧᐃ ᒫᒃ ᓅᐦᒌ ᒋᐦᐱᒋᐦᐋᓈᓐ, ᐋᒄ ᒥᒄ ᑳ ᐄᑎᒋᐦᑦ, “ᐋᑯᑖᐦ ᑭᔨᑆ ᐋᑯᔥ ᒑ ᐃᓯᓈᑯᐦᒡ᙮ ᐙᔥ ᒫᒃ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ ᐄᔅᐱᔨᔨᒑ᙮” ");
INSERT INTO crl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ᐙᐃᐱᔥᒌᔥ ᒫᒃ ᓂᒌᐦᑖᓈᓐ ᐊᓂᑎᐦ, ᐋᒄ ᑳ ᐃᔮᔅᑭᐎᔮᐦᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᐄᑐᐦᑖᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᓭᓯᕇᔮᐦ ᑳ ᐅᐦᒌᒡ ᓂᒌ ᐐᒑᐅᑯᓈᓂᒡ, ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐃᔨᒥᐦᒡ ᐊᓂᑖᐦ ᓈᐹᐤ ᒥᓈᓱᓐ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ᐋᑯᑖᐦ ᐊᓐ ᐐᒋᐦᒡ ᓂᐱᐦ ᑖᐙᓈᓐ᙮ ᐊᓂᑖᐦ ᓵᐃᑉᕋᔅ ᒌ ᐅᐦᒋᔨᐤ ᐆ ᒥᓈᓱᓐ᙮ ᔖᔥ ᐙᔥᑭᒡ ᒌ ᑖᑆᔮᔨᒫᑖᑯᐱᓐ ᐐᔨ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ᐄᔥᐱᐦ ᑖᑯᔑᓂᔮᐦᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑎᒧᒡ ᐊᓂᒌ ᐐᒋᔖᓂᒫᐅᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒥᔨᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ᒦᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᓂᒌ ᓂᑎᐙᐱᒫᓈᓐ ᒉᒥᔅ ᒥᓯᐙ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᐦᒡ᙮ ᑆᓪ ᑭᔮᐦ ᓂᒌ ᐐᒑᐅᑯᓈᓐ᙮ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔨᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᒉᒥᔅ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ᑆᓪ ᒫᒃ ᒌ ᐋᑎ ᐙᒋᔮᒫᐤ ᒥᓯᐙ, ᐋᒄ ᑳᐦ ᐋᑎ ᐙᐐᐦᑎᒧᐙᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᑯᔨᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒫᒀᒡ ᑳ ᐙᐐᐦᑎᐦᒃ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐙᒡ ᐅᒌ ᑖᓐ ᐋᐦ ᐄᑖᒋᒧᔨᒡ ᑆᓪ ᒥᓯᐙ ᒌ ᒫᒥᐦᒋᒫᐅᒡ ᒋᔖᒥᓂᑑ᙮ ᒑᒃ ᒫᒃ ᒌ ᐄᑖᐅᒡ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᓃᒋᔖᓈᓐ, ᒌ ᐙᐱᐦᑖᓐ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᐦᒑᑎᐦᒡ ᐋᒄ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᔮᔨᒫᒡ ᒌᓴᔅᐦ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᒥᐦᒑᑣᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᐋ ᐃᑎᔑᒡ᙮ ᒥᓯᐙ ᒫᒃ ᐋᔥᒄ ᓈᔥᒡ ᓈᓈᑭᑐᐙᔨᐦᑎᒸᐅᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ᒌ ᐄᑖᒋᒧᔥᑐᐙᑭᓂᐎᒡ ᒫᒃ ᐋ ᒋᔅᑯᑎᒫᒥᑦ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᐐᒋᔨᒡ ᐊᓂᑖᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ ᒑᐦ ᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᒥᐦᐄᑯᔨᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ, ᐋᐦ ᐄᑎᑎᑣᐤ ᒑᐦ ᐋᑳ ᒋᔅᒋᓄᐙᒋᔣᒡ ᐅᑎᐙᔑᔒᒥᐙᐤᐦ ᑭᔮᐦ ᒑᐦ ᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᐦᒡ ᒎᐤ ᐃᔨᐦᑎᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ᐅᒌ ᒫᒃ ᒎᐤ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᑳ ᓂᓈᑭᑎᐙᔨᐦᑎᒸᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ ᒑᔥᑎᓈᔥ ᑭᑎ ᐹᐦᑎᒧᒡ ᐋ ᒌ ᑎᑯᔑᓅᑦ᙮ ᑖᓐ ᒑ ᑎᔨᐦᒄ ᒫᒃ? ");
INSERT INTO crl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ᑐᑎᐦ ᒫᒃ ᐆ ᒑ ᐄᑎᑖᐦᒡ᙮ ᓈᐆᒡ ᓈᐹᐅᒡ ᐅᑎᐦ ᐋᐦ ᑖᒡ ᐋᐦᑎᑯᓃᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᒑᔥᑎᓈᔥ ᑎᐱᑑᑎᐦᒡ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐎᓐ ᐃᔨᐦᑎᐎᓂᔨᐤ, ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑖᑯᓃᔨᒡ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓃᐦᒡ ᒑ ᑐᑖᑭᓂᐎᔨᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ᐐᒑᐅᒡ ᒫᒃ ᐅᒌ ᓈᐹᐅᒡ ᐊᓂᑖᐦ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋ ᓂᑑᐱᔮᐦᒋᐦᐄᓱᔮᒄ, ᒑ ᒌ ᑎᐱᐦᐆᑣᐤ ᐊᓂᔮᔨᐤ ᒑ ᐃᔥᐱᔥ ᑎᐱᐦᐅᓱᐙᑯᐱᓐ, ᐋᒄ ᒫᒃ ᒑ ᒌ ᑳᔅᒋᐹᑖᑭᓅᐎᒡ ᐅᔥᑎᒀᓂᐙᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᐙᐱᐦᑎᔨᐙᔨᓐ ᐋᔥᒄ ᐋ ᒋᔅᑖᔨᐦᑎᒧᑦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓐ ᑭᔮᐦ ᒑ ᒋᔅᒑᔨᐦᑖᑯᐦᒡ ᐋ ᒌ ᓂᓂᑎᔮᒋᒧᓈᓂᐎᒡ ᐊᓐ ᑳ ᐄᑖᒋᒥᑭᐎᔨᓐ ᐋᐦᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᒧᑦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑳ ᑖᑆᐦᑎᐦᒡ, ᓂᒌ ᒥᓯᓂᐦᐋᒧᐙᓈᓂᒡ ᒫᒃ ᐋ ᐐᐦᑎᒧᐎᒋᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᔮᔨᐦᑎᒧᒋᐦᑦ ᒑ ᒌ ᐄᔑ ᓈᓈᑭᒋᐦᑖᒡ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐋᑳ ᒑ ᒌ ᒦᒋᒡ ᒑᒀᔨᐤ ᐋᐦ ᐄᔅᑯᐱᔨᔨᒡ ᐋ ᒌ ᒥᒋᔥᑎᐦᐋᒧᐙᑭᓂᐎᔨᒡ ᒥᓂᑑᐦᑳᓐ, ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᒦᒋᒡ ᒥᐦᑯᔨᐤ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᒧᐙᒡ ᐊᐅᐦᑳᓐ ᐋ ᒌ ᒋᐳᑖᒫᐱᐦᑳᑎᒫᑭᓂᐎᔨᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᐱᓯᒀᑎᓰᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ᒦᓐ ᐎᔮᐱᓃᔨᒡ ᒌ ᐐᒑᐙᐤ ᐊᓂᔮᔨᐤ ᓈᐤ ᓈᐹᐤ ᒑ ᒌ ᐱᔮᐦᒋᐦᐄᒫᑭᓂᐎᔨᒡ᙮ ᒌ ᐄᑐᐦᑖᐤ ᑭᔮᐦ ᐐᔨ ᑆᓪ ᐊᓂᑖᐦ ᒎᐤ ᐅᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᒡ᙮ ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑖᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳᐦ ᐋᐱᑎᓰᔨᒡ ᑖᓐ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᐃᔮᒄ ᒋᐦᒋᐙ ᒋᐱᐦ ᒌᔑᐱᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᐐᐦ ᐄᔑ ᓈᓈᑭᑎᐙᔨᐦᑎᒥᐦᐄᑯᒡ ᒑ ᒌ ᑎᒡ᙮ ᑭᔮᐦ ᒫᒃ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒋᐱᐦ ᑎᑯᓂᔨᐤ ᑖᔨᔅᐱ ᓂᐦᐋᐤ ᒑᒥᒋᔅᑎᐦᐋᒫᐙᐙᑯᐱᓈ ᒑᒀᔨᐤ ᒥᓯᐙ ᐊᓂᑎᐦ ᐋ ᐃᑎᔑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ᔖᔥ ᒑᑳᑦ ᒌ ᒋᓯᐦᑖᐅᒡ ᐋ ᐲᔮᐦᒋᐦᐄᓯᐎᒡ, ᓃᔣᔥᒡ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐹᑎᒫ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐊᓂᑖᐦ ᐋᐃᔖ ᐋ ᐅᐦᒌᒡ ᒌ ᐙᐱᒫᐅᒡ ᑆᓪ ᐊᓂᑖᐦ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᐋᒄ ᑳᐦ ᑑᑎᐎᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᒋᔑᐙᓰᔅᑐᐙᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ, ᐋᒄ ᑳ ᐅᑎᓈᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ᒌ ᑖᑆᐅᒡ ᒫᒃ, ᐅᔮᔨᐤ ᐋᐦ ᐃᔨᒡ, “ᒌᔨᐙᐤ ᓈᐹᑐᒄ ᐃᔅᕋᐃᓚᐦᒡ ᑳ ᐅᐦᒋᔮᒄ, ᐹᒋ ᐐᒋᐦᐄᓈᓐ, ᐋᐅᒄ ᐆ ᓈᐹᐤ ᒥᓯᐙ ᑳ ᐊᐄᑐᐦᑖᑦ ᐋ ᒋᔅᑯᑎᒧᐙᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒑᐦ ᐋᑳ ᐃᔮᐱᑖᔨᒫᔨᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ, ᑭᔮᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᐅᔮᔨᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ ᓂᒧᐃ ᐃᔮᐱᑖᔨᐦᑎᒻ᙮ ᐙᐙᒡ ᑭᔮᐦ ᒌ ᐹᒋ ᐲᐦᑎᑭᐦᐋᐤ ᒫᓂᑖᐤ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐅᑎᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᒑ ᐲᐦᒑᔨᑯᐱᓈᓂᐦᐄ ᐅᑎᐦ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᑎᒃ ᓈᔥᒡ ᒫᔮᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᒫᐅᒡ ᑳ ᐱᔮᐦᑭᓃᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ᐋᔪᐎᒄ ᐙᐦᒋ ᐃᔨᒡ ᐅᔮᔨᐤ ᐙᔥ ᒌ ᐙᐱᒫᐅᒡ ᒫᓂᑖᐤ ᐋᐦᐋᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑦᕎᕕᒥᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐊᓂᑖᐦ ᐁᕕᓱᓯᐦᒡ ᐋ ᐅᐦᒌᔨᒡ ᐋ ᐐᒑᐙᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓂᐦᒡ, ᓂᑎᐐ ᐋ ᒌ ᐄᑖᔨᒫᒡ ᑆᓪ ᐋ ᒌ ᐲᐦᑎᑭᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᒫᓂᑖᐤ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ᒧᔮᒻ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᐙᐙᓈᔨᐦᑎᐦᒃ ᒌ ᐄᑖᔨᐦᑖᑯᓐ᙮ ᓂᓈᐦᑭᐤ ᒌ ᐅᐦᒋᐱᐦᐄᑑᒡ ᐄᔨᔨᐅᒡ᙮ ᐋᒄ ᑳ ᐅᑎᓈᑭᓅᑦ ᑆᓪ, ᑳ ᐎᔨᐐᑖᐹᑖᑭᓅᑦ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐋᑎ ᒋᐳᐦᐙᑭᓂᐎᒡ ᐊᓂᒌ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᒡ ᒋᔥᑐᐦᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᑳ ᐅᑎᓈᒡᐦ ᑆᓪ ᐋᑯᑖᐦ ᑳ ᐐᐦ ᐋᑎ ᓂᐱᐦᐋᒡ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᐃᔥᐱᔒᐦᑯᐙᒡ ᐊᓂᔮᔨᐤ ᐋ ᐐ ᓂᐱᐦᐋᒡ, ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᒌ ᐹᐦᑎᒻ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᐱᔨᓈᓂᐎᔨᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ᑏᐙᐦᒡ ᒫᒃ ᒌ ᐄᔥᐱᐦᐄᑑᒡ ᐋ ᐐᒋᐱᐦᑖᒫᑦ ᐊᓂᔮᔨᐤ ᐋᓂᑐᐱᔪᒋᒫᐤ ᑭᔮᐦ ᓂᑐᐱᔨᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋᐦᑖᓂᐎᔨᒡ ᐋᒥᐦᒑᑎᓈᓃᐎᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᒥᑯᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒌ ᐴᓂᔨᐤ ᐋ ᑯᓰᐦᑯᐙᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ᐋᒄ ᐊᓐ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑆᓪ ᐋᒄ ᑳ ᐅᑎᓈᑦ᙮ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᒥᒫᐦᒋᒀᐱᐦᑳᑖᑭᓂᐎᔨᒡ, ᓃᔓ ᐴᓂᓯᓈᓱᓈᔮᐲ ᐋᐦ ᐋᐱᑎᓃᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᒑᒄ ᓈᐹᐤ ᐆ, ᑖᓐ ᑳᐦ ᑎᒃ?” ");
INSERT INTO crl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ ᒌ ᓂᔥᑰᔑᐦᐋᐅᒡ ᐋ ᑖᑆᒡ᙮ ᐋᒄ ᒥᒄ ᓂᒧᐃ ᐹᔨᑯᓂᐦᒡ ᐅᐦᒋ ᐃᔨᐅᒡ, ᑯᑎᑭᒡ ᐃᔨᐦᒡ ᐋᐦ ᐃᔨᒡ ᑖᓐ ᐃᔮᔨᒡ ᐊᓂᔮᔨᐤ ᑯᑎᒃ᙮ ᐋᒄ ᑭᔨᑆ ᓂᒥ ᓂᐦᐋᐤ ᐅᐦᒌ ᓂᔅᑐᐦᑎᒻ ᐊᓐ ᓂᑐᐱᔫᒋᒫᐤ ᑖᓐ ᓂᐦᐋᐤ ᑳ ᐊᔨᑎᓈᓂᐎᔨᒡ, ᐋᒄ ᒥᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᒌ ᐲᐦᑎᑭᐦᐄᒫᑭᓂᐎᔨᒡ ᑆᓪ ᐊᓂᑖᐦ ᓂᑐᐱᔪᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ᐊᓂᒌ ᒫᒃ ᓂᑐᐱᔫᒡ ᐄᔥᐱᐦ ᒑ ᐋᑎᐃᔅᒀᐦᑎᐐᒡ ᒑ ᒌ ᐲᐦᑎᑭᐦᐋᒡ ᑆᓪ ᐊᓂᑖᐦ, ᐄᔨᐙ ᒑᒃ ᒌ ᐅᐦᐱᓈᐅᒡ ᑳ ᐃᔥᐱᔥ ᓈᓈᓂᒌᒻ ᒌ ᐊᐦᒀᑖᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒌ ᐹᒋ ᐱᒨᐦᑖᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋ ᑖᑆᒡ ᐋᐦ ᐃᔨᒡ, “ᓂᐱᐦᐋᐦᒄ ᐊᓐ ᓈᐹᐤ᙮ ᓂᐱᐦᐋᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ᒫᒀᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐐᐦ ᐲᐦᑎᑭᐦᐋᑭᓅᑦ ᑆᓪ ᐊᓂᑖᐦ ᓂᑐᐱᔪᑭᒥᑯᐦᒡ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔫᒋᒫᐤ, “ᒋᑭ ᒌ ᐄᑎᓈ ᒑᒀᓐ?” ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᒃᕇᒃ ᐋ ᒋᑎ ᐄᔑ ᐋᔨᒥᓐ? ");
INSERT INTO crl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ᓂᒥᔮᐤ ᐋ ᒌᔨ ᐊᓐ ᓈᐹᐤ ᐄᒋᑉᑦ ᑳᐦ ᐄᑎᔅᑳᓈᓯᑦ ᐅᑖᐦ ᐄᔑ ᐅᑖᐦᒡ, ᑳ ᒋᐦᒋᐱᔨᐦᑖᑦ ᐋ ᓂᔅᑯᑖᒫᑭᓂᐎᔨᒡ ᒋᐦᒋᐅᒋᒫᐤ ᑭᔮᐦ ᑳ ᓃᑳᓂᔥᑭᐙᑦ ᓈᐙᐤ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᒥᒋᓂᑐᐱᔨᐤ, ᐊᓂᑖᐦ ᒫᒃ ᐱᑯᑎᔅᑭᒥᑳᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐋᑦ?” ");
INSERT INTO crl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᓂᒥᔮᐤ ᓃᔨ᙮ ᒎᐤ ᓂᑎ ᐄᑎᔅᑳᓈᓯᓐ ᓃᔨ ᐐᐦ, ᓯᓕᓯᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᔅᒌ ᓅᐦᒌᓐ ᐊᓂᑖᐦ ᑖᕐᓯᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᑯᑖᐦ ᒫᓯᓈᓱᔮᓐ ᐙᒋᐦᒡ ᐋ ᐅᐦᒋᔮᓐ᙮ ᒋᐦᒋᐙ ᐋ ᒋᔅᑖᔨᐦᑖᑯᒡ ᐃᐦᑖᐎᓐ ᐄᔑ ᑭᓂᐙᐱᐦᑖᑭᓂᐤ ᑖᕐᓯᔅ᙮ ᐹᒋ ᒥᔨ ᒫᐦ ᒑ ᒌ ᐊᔨᒥᐦᐄᒀᐤ ᐅᒌ ᐄᔨᔨᐅᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ᐋᒄ ᑳ ᐱᒋᔅᑎᓂᑯᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔫᒋᒫᐤ ᒑ ᒌ ᐊᔨᒥᑦ᙮ ᐋᒄ ᑆᓪ ᑳ ᑎᐦᑯᐦᒋᑳᐳᐎᑦ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᓵᑭᒋᐙᓂᐎᔨᒡ᙮ ᑳ ᐅᐦᐱᓂᔅᒑᔨᑦ ᐋ ᓂᑎᐙᔨᒫᑦ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᒑᐦ ᐋᑳ ᒋᔅᑑᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐋᑳ ᒑᔅᑐᔨᒡ, ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᑦ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","ᑆᓪ ᒌᐦ ᐄᑖᐤ, “ᓃᒋ ᒎᐄᔨᔨᑐᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᒋᔖᐄᔨᔨᑐᒄ, ᐹᒋ ᓂᑐᐦᑎᐎᒄ ᑯᐃᔅᒄ ᐋ ᐐᐦ ᐐᐦᑎᒫᓐ ᐋᐦᐋᑳ ᐎᔮᔥ ᐄᔑ ᐋᑖᒫᔨᐦᑖᑯᓯᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐙᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᔨᒡ ᑆᓪ, ᐊᓂᔮᔨᐤ ᑭᔨᑆ ᐋ ᐄᔑ ᐊᔨᒥᒡ, ᐋᒄ ᐊᑎᑎᐤ ᓂᒥ ᐅᐦᒋ ᒋᔅᑐᐎᒡ᙮ ᐋᒄ ᑆᓪ ᑳᐦ ᐋᑎ ᐃᔨᑦ, ");
INSERT INTO crl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ᒎᐤ ᓂᑎᐄᑎᔅᑳᓈᓯᓐ᙮ ᑖᕐᓯᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᓯᓕᓯᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐋᑯᑖᐦ ᑳ ᐱᒫᑎᓰᔮᓐ᙮ ᐋᒄ ᒥᒄ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᓂᐦᑖᐅᒋᓂᑭᐎᔮᓐ᙮ ᐊᓂᔮ ᒫᒃ ᒋᔅᑯᑎᒫᒑᓯᐤ ᑳᒫᓕᔮᓪ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᐋᐅᒄ ᑳ ᒋᔅᑯᑎᒨᑦ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮ ᐋᐅᒄ ᐊᓐ ᑭᔮᐦ ᓃᔨ ᐃᔮᒀ ᑳ ᐄᔑ ᒋᔅᑯᑎᒫᑭᐎᔮᓐ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᐅᐐᔓᐙᐎᓂᐙᐤ᙮ ᑭᔮᐦ ᓃᔨ ᓈᔥᒡ ᓂᒌ ᐐᐦ ᓂᓂᐦᐄᐦᑎᐙᐤ ᒋᔖᒥᓂᑑ ᒧᔮᒻ ᐋᐃᐦᑎᔮᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᐅᑎᐦ ᐊᓅᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ᓈᔥᒡ ᓂᒌ ᐐᐦ ᓂᓈᐦᑳᒋᐦᐋᐅᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᒌᓴᔅᐦ ᐋᐦᐋᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᓂᒌᐦ ᐄᑎᔓᐙᓐ ᒑ ᒌ ᓂᐱᐦᐋᑭᓅᐎᒡ᙮ ᓂᒌ ᐅᑎᓈᐅᒡ ᑖᐱᔥᑯᓐ ᓈᐹᐅᒡ ᑭᔮᐦ ᐃᔅᒀᐅᒡ ᒑ ᒌ ᒋᐳᐦᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ᐆ ᒫᒃ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᒫᒨᐱᔥᑎᐦᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ ᒋᑭ ᒌ ᐐᐦᑎᒫᑯᐙᐅᒡ ᐋ ᑖᑆᐅᒡ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᐅᒡ᙮ ᓂᒌ ᒥᔨᑯᒡ ᒥᓯᓂᐦᐄᑭᓐ ᒑ ᒌ ᐄᑐᐦᑣᒥᒡ ᒎᐤ ᐐᒋᔖᓂᒫᐤ ᐊᓂᑖᐦ ᑖᒫᔅᑭᔅ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᔨᒡ᙮ ᒌ ᒥᓯᓈᑖᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᐄᑎᔓᒥᒡ ᒑ ᒌ ᒫᑯᓂᒥᒡ ᑭᔮᐦ ᒑ ᒌ ᒥᒫᐦᒋᒀᐱᐦᑳᑎᒥᒡ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ ᐊᓂᑖᐦ ᑖᒫᔅᑭᔅ ᐃᐦᑖᐎᓐ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐹᔒᒥᒡ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᐎᔮᔅ ᑐᑎᐙᑭᓂᐐᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ᒫᒀᒡ ᐋ ᐱᒧᐦᑖᔮᓐ ᐋᐦ ᐋᑎ ᐹᔣᐱᐦᑎᒫᓐ ᑖᒫᔅᑭᔅ ᐃᐦᑖᐎᓐ, ᐎᔮᔥ ᐋᐦ ᐋᐱᐦᑖᒌᔑᑳᒡ, ᔑᔥᒋᑯᒡ ᒌ ᐅᐦᒋ ᒥᔥᑎᐦ ᐙᔥᑖᐤ ᐊᓂᑎᐦ ᐙᔅᑳ ᐋᐦ ᑖᔮᓐ ᐊᓂᑖᐦ ᐅᐦᒋ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐋ ᐅᐦᒋ ᐙᔥᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ᒥᑐᓐ ᒫᒃ ᓂᒌᐦ ᐋᑎ ᐱᐦᒋᔑᓐ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᐋᒄ ᑳ ᐹᐦᑎᐎᒃ ᐊᐙᓐ ᐋ ᐄᔑᑦ, ‘ᔂᓪ, ᔂᓪ ᒑᒀᓐ ᐙᐦᒋ ᓂᓈᐦᑳᒋᐦᐄᔨᓐ?’ ");
INSERT INTO crl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ᐋᒄ ᑳᐦ ᐄᑎᒄ, ‘ᐊᐙᓐ ᒫᒃ ᒌᔨ, ᐅᑎᐹᔨᐦᒋᒑᐤ?’ ᐋᒄ ᑳ ᐄᔑᑦ, ‘ᐋᐅᒄ ᓃᔨ ᒌᓴᔅ, ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒋᔮᓐ, ᑳ ᓂᓈᐦᑳᒋᐦᐄᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ᐊᓂᒌ ᒫᒃ ᓈᐹᐅᒡ ᑳ ᐐᒑᐅᒡ ᒌ ᐙᐱᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᑳ ᒋᐦᑳᔮᔥᑖᔨᒡ, ᓂᒧᐃ ᒥᒄ ᐅᐦᒋ ᐹᐦᑎᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑳ ᐹᒋ ᐊᔨᒥᐦᐄᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","ᐋᒄ ᑳᐦ ᐄᑎᒄ, ‘ᐅᑎᐹᔨᐦᒋᒑᐤ, ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᔨᓐ ᒫᒃ ᒑ ᑎᔮᓐ?’ ᐋᒄ ᑳ ᐄᔑᑦ, ‘ᐱᓯᑰᐦ, ᒑ ᐄᑐᐦᑖᔨᓐ ᐊᓂᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒑ ᐐᐦᑎᒫᑭᐎᔨᓐ ᒥᓯᐙ ᑖᓐ ᐋᐦ ᐄᑎᔓᒥᔅᒃ ᒋᔖᒥᓂᑑ ᒑ ᐄᑖᐱᑎᓰᐎᑦ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","ᓂᒧᐃ ᒫᒃ ᓅᐦᒌ ᐙᐱᐦᑖᓐ ᑳ ᐃᔥᐱᔥ ᓈᔥᒡ ᒌᐦᑳᔮᔥᑖᒡ ᐊᓐ ᑳ ᐙᔥᑖᒡ᙮ ᐋᒄ ᐊᓂᒌ ᓂᐐᒑᐙᑭᓂᒡ ᑳ ᐹᒋ ᑎᐦᑯᓂᔅᒑᐦᑎᐦᐄᒡ ᐊᓂᑖᐦ ᑖᒫᔅᑯᓯᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐄᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“ᒌᐦ ᑖᐤ ᒫᒃ ᓈᐹᐤ ᐊᓂᑎᐦ ᑖᒫᔅᑯᓯᐦᒡ ᐋ ᒌ ᐐᒋᑦ ᐋᓂᓈᔮᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ᙮ ᒌ ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐆ ᓈᐹᐤ ᑭᔮᐦ ᓈᔥᒡ ᐃᔮᒀ ᒌ ᐄᔑ ᓈᓈᑭᑐᐙᔨᐦᑎᒥᐦᐄᑰ ᒎᐤ ᐊᔨᒥᐦᐋᐐᔓᐙᐎᓂᔨᐤ᙮ ᓈᔥᒡ ᒫᒃ ᒌ ᒋᔅᑖᔨᒥᑰ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐊᓂᑎᐦ ᑖᒫᔅᑯᓯᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","ᐋᐅᒄ ᐆ ᓈᐹᐤ ᑳ ᐹᒋ ᓂᑎᐙᐱᒥᑦ, ᑳ ᐹᒋ ᐎᑎᔅᑭᐎᑳᐳᔥᑑᑦ, ᐋᒄ ᑳ ᐄᔑᑦ, ‘ᓃᒋᔖᓐ ᔂᓪ, ᑳᐤ ᒦᓐ ᐙᐱᐦᑎᐦ᙮’ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐄᔑᑦ ᐅᔮᔨᐤ ᑏᐙᐦᒡ ᒦᓐ ᓂᒌᐙᐱᐦᑎᒸᓐ᙮ ᑳ ᑭᓂᐙᐱᒥᒃ, ");
INSERT INTO crl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","ᐋᒄ ᑳ ᐄᔑᑦ, ‘ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ, ᒋᒌ ᐅᐙᔮᐱᒧᒄ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒧᑦ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᐦᒃ ᒑ ᑎᓈᓂᐎᐅᔨᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ, ᑭᔮᐦ ᒑ ᒌ ᐙᐱᒥᑦ ᐊᓂᔮᔨᐤ ᙭ ᑳ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᐹᐦᑖᒸᑦ ᐋ ᐊᔨᒥᐦᐄᔅᒌᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","ᒥᓯᐙ ᒫᒃ ᐄᔨᔨᐅᒡ ᒋᑭ ᐐᐦᑎᒧᐙᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᒥᓐ ᑭᔮᐦ ᑳ ᐄᔑ ᐹᐦᑎᒥᓐ ᐋᐦ ᐄᑖᒋᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ᒫᒌᐦ ᒫᒃ, ᐊᑳᐐ ᓈᓄᒋᐦ᙮ ᐱᓯᑰᐦ, ᒑ ᓰᑭᐦᐋᐦᑖᑭᐎᔨᓐ, ᐋᒄ ᒫᒃ ᒑ ᐙᐹᔨᐦᑎᒫᑭᐎᔨᓐ ᒋᒥᒋᐦᑣᐎᓐ ᐋ ᓂᑐᑎᒧᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᔅᒃ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“ᐋᒄ ᒦᓐ ᑳᐤ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐄᑐᐦᑖᔮᓐ᙮ ᒫᒀᒡ ᒫᒃ ᐋ ᐊᔨᒥᐦᐋᔮᓐ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᒌ ᑎᑯᓐ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᔨᑭᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ᓂᒌᐙᐱᒫᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐋ ᐹᒋ ᐄᔑᑦ, ‘ᒌᐲ, ᓂᑭᑦ ᐆ ᒉᕉᓯᓕᒻ ᐊᓅᐦᒡ, ᐙᔥ ᑖᐹ ᒋᑭ ᐅᐦᒋ ᑖᑆᐦᑖᑯᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᑖᓐ ᒑ ᐹᒋ ᐄᑖᒋᒥᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","ᐋᒄ ᑳᐦ ᐄᑎᒄ, ‘ᑎᐹᔨᐦᒋᒑᓯᐤ, ᒋᔅᒑᔨᐦᑎᒧᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᒥᒄ ᐋ ᒌ ᐃᔮᔔ ᓈᑎᒫᓐ ᐅᐦᐄ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᒄ ᒑ ᒌ ᐅᑎᓂᒀᐤ ᐅᒌ ᑳ ᑖᑆᔮᔨᒥᔅᒡ ᑭᔮᐦ ᐋ ᒌ ᑑᑑᒀᐤ ᒑ ᒌ ᐹᐱᐦᓯᔅᑖᐦᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ᑭᔮᐦ ᒫᒃ ᐄᔥᐱᐦ ᑳ ᓂᐱᐦᐋᑭᓅᑦ ᔅᑏᕙᓐ ᐊᓂᔮᔨᐤ ᐋ ᑎᐹᒋᒥᔅᒃ ᐅᐦᒋ, ᑭᔮᐦ ᓃᔨ ᓂᒌ ᑖᓐ ᐊᓂᑎᐦ᙮ ᓂᒌ ᓂᐦᐋᔨᐦᑖᓐ ᐊᓂᔮᔨᐤ ᐋ ᒌᐦ ᑐᑎᐙᑭᓅᑦ ᑭᔮᐦ ᓂᒌ ᑭᓂᐙᔨᐦᑎᒸᓐ ᐅᑎᑯᐦᐱᐙᐤᐦ ᐊᓂᒌ ᑳ ᓂᐱᐦᐋᒡ ᔅᑏᕙᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","ᐋᒄ ᑳ ᐄᔑᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ‘ᒫᒌᐦ ᐊᔮᐱᒡ ᐙᔥ ᐙᐦᔨᐤ ᒋᑭ ᐄᑎᔓᐦᐆᑎᓐ ᐊᓂᑖᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐋᐦ ᑖᒡ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐊᔨᒥᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ, ᐊᓂᔮᔨᐤ ᑭᔨᑆ ᐋᐦ ᐄᑖᒋᒧᔨᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐄᑎᔑᐦᐅᑯᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐋᐦ ᑖᔨᒡ, ᐋᔪᐎᒄ ᑳ ᐃᔥᐱᔥ ᓂᑑᐦᑎᐙᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ᙮ ᒌ ᒋᐦᒋ ᐋᔑᐦᒀᐅᒡ ᐋᐦ ᐃᔨᒡ, “ᓂᐱᐦᐋᐦᒄ ᐆ ᓈᐹᐤ, ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓯᐤ ᒑ ᒌ ᐱᒫᑎᓰᑦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ᒌ ᐋᔑᐦᒀᐅᒡ ᒫᒃ ᐋ ᐙᐙᐱᔨᐦᑖᒡ ᐅᒑᒀᓂᒧᐙᐤ, ᑭᔮᐦ ᔮᑳᔨᐤ ᐋ ᐃᔥᐹᐦᒑᐙᐱᓂᐦᒡ ᑳ ᐃᔥᐱᔥ ᓈᔥᒡ ᒋᔑᐙᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᓂᑐᐱᔨᒻ ᒑ ᐲᐦᑎᑭᐦᐋᔨᒡ ᑆᓪ ᐊᓂᑖᐦ ᓂᑐᐱᔪᑭᒥᑯᐦᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᒑ ᐱᐱᓯᔅᑖᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ᒌ ᐱᑯᓵᔨᐦᑎᒻ ᑭᔨᑆ ᒑᒃ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᐹᐱᐦᓯᔅᑖᐦᐅᒫᑭᓂᐎᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᐐᐦᑎᒥᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒥᔨᒡ ᐙᐦᒋ ᐃᔥᐱᔥ ᓈᔥᒡ ᒋᔑᐙᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᔮᐱᐦᑳᑖᒡ ᒑ ᐹᐱᐦᓯᔅᑖᐦᐙᒡ, ᐊᓐ ᓂᑐᐱᔨᐅᒋᒫᐤ ᐅᔮᔨᐤ ᒌ ᐄᔑ ᑯᒀᒋᒥᑰ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᑯᐃᔅᑯᓈᑯᓐ ᐋ ᒑ ᒌ ᐹᐱᐦᓯᔅᑖᐦᐙᒄ ᐊᐙᓐ ᕎᒻ ᐋ ᐄᔑ ᒥᓯᓈᓱᑦ ᑭᔮᐦ ᐋᐦᐋᑳ ᐋᔥᒄ ᐅᐦᒋ ᑎᐹᔅᑯᓈᑭᓅᑦ?” ");
INSERT INTO crl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","ᐄᔥᐱᐦ ᒫᒃ ᐱᔮᐦᑎᐦᒃ ᐅᔮᔨᐤ ᐊᓐ ᑳ ᓃᑳᓂᔥᑭᐙᑦ ᓂᑐᐱᔨᐤ, ᒌ ᓂᑎᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᕎᒻ ᓂᑐᐱᔨᐅᒋᒫᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐋ ᑖᓐ ᐋᔨᐦᑎᔨᓐ ᐆ? ᕎᒻ ᐄᔨᔨᐤ ᐙᔥ ᐄᑎᓯᓈᓲ ᐆ ᓈᐹᐤ ᑳ ᐊᔨᑑᑎᐎᐦᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᓂᑎᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, ᑳᐦ ᐄᑖᑦ, “ᑖᑆᐦ ᐋ ᕎᒻ ᒋᑎᐃᑎᓯᓈᓱᓐ?” ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᐋᐦᐋ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ᐋᒄ ᐊᓂᔮᔨᐤ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳᐦ ᐄᑎᑯᑦ, “ᓄᐎᒡ ᒥᔥᑏᐦ ᔓᐎᔮᓐ ᓂᒌᐦ ᐄᑎᓂᑰᓐ ᕎᒥᐦᒡ ᒑ ᒌ ᐄᔑ ᒥᓯᓈᓱᔮᓐ᙮” ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᑳ ᐱᒫᑎᓰᔮᓐ ᓃᔨ ᔖᔥ ᕎᒻ ᓂᒌᐦ ᐄᑎᓯᓈᓱᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","ᐱᔮᐦᑎᐦᒡ ᒫᒃ ᐅᔮᔨᐤ ᐋᐦ ᐄᔨᔨᒡ ᑆᓪ ᐊᓂᒌ ᑳ ᐐᐦ ᓂᑑᒋᔅᒑᔨᒫᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒥᔨᒡ ᒌ ᐋᑎ ᐊᔖᑳᐳᐎᒡ᙮ ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᓵᒑᔨᑎᐦᒃ ᐄᔥᐱᐦ ᒑᔅᒑᔨᒫᑦ ᑆᓪ ᑖᑆᐦ ᕎᒻ ᐋᐦ ᐄᑎᓯᓈᓱᔨᒡ, ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᒫᐦᑯᐱᑖᑦ ᐴᓂᓯᓈᓱᓈᔮᐱᔨᐤ ᐋᐦ ᐋᐱᒋᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ᐎᔮᐱᓃᔨᒡ ᒫᒃ, ᐋ ᐐᐦ ᓂᑑᒋᔅᒑᔨᐦᑎᐦᒃ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒫᒥᔑᒥᐦᒡ ᑆᓪ ᐅᐦᒋ, ᒌ ᐄᑎᔑᐦᐙᐤ ᐱᑦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑭᓂᐎᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ ᒑ ᒌ ᓂᔥᑐᐎᔨᒡ᙮ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᑆᓪ ᐊᓂᑖᐦ, ᐋᒄ ᑳᐦ ᐅᐦᑎᔅᑯᑳᐳᐦᐋᑦ ᐊᓂᑎᐦ ᐋ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","ᐋᒄ ᑆᓪ ᑯᐃᔅᒄ ᑳ ᑭᓂᐙᐱᒫᑦ ᐊᓂᔮᔨᐤ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᓃᒋᔖᓂᑎᒄ, ᑳ ᐃᔥᐱᔥ ᐹᒋ ᐋᐱᑎᔒᔥᑑᒄ ᒋᔖᒥᓂᑑ ᓂᒑᔥᑎᓈᐦᐅᓐ ᒨᔥ ᑯᐃᔅᒄ ᐋ ᒌᐦ ᑎᔮᓐ ᒋᔖᒥᓂᑑ ᐋ ᐱᒫᑎᓰᔅᑑᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᓂᓈᔮᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᑳᐦ ᐄᑎᔓᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐹᔓᒡ ᑆᓪ ᐋᐦ ᑖᔨᒡ ᑳᐦ ᓃᐴᐎᔨᒡ ᒑ ᒌ ᐅᑖᒥᑐᓈᐦᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᒋᔖᒥᓂᑑ ᒋᑭ ᐅᑖᒥᐦᒀᐦᐆᒄ, ᒌᔨ ᐅᔅᒡ ᑳ ᐐᐦ ᒥᒥᔪᓈᑯᐦᐄᓱᔨᓐ᙮ ᒋᑎᐱᓐ ᐅᑎᐦ ᒑ ᒌ ᑎᐹᔅᑯᓃᔨᓐ ᐐᔓᐙᐎᓂᐦᒡ ᐄᔑ, ᒌᔨ ᒫᒃ ᑎᐲᐙ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑎᒥᓐ ᐊᓐ ᐐᔓᐙᐎᓐ ᐋ ᒌ ᐄᑎᔓᐙᔨᓐ ᒑ ᒌ ᐅᑖᒥᐦᒀᐦᐅᑭᐎᔮᓐ ᐋᔥᒄ ᒫᒃ ᐋᐦᐋᑳ ᑯᐃᔅᒄ ᐅᐦᒋ ᐄᔑ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","ᐋᒄ ᐊᓂᒌ ᐹᔓᒡ ᑆᓪ ᐋᐦ ᑖᔨᒡ ᑳ ᓃᐴᐎᒡ ᑳᐦ ᐄᑖᒡ ᐊᓂᔮᔨᐤᐦ ᑆᓪᐦ, “ᐋ ᐄᔨᐙ ᑖᐹ ᒋᐱᐦ ᐄᔑ ᐊᔨᒥᐦᐋᐤ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒥᑯᑦ?” ");
INSERT INTO crl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","ᑆᓪ ᑳᐦ ᐃᔨᑦ, “ᓃᒋᔖᓂᑎᒄ, ᐊᑐᒡ ᓂᐱᐦ ᐅᐦᒌ ᐄᑖᐤ ᐅᔮᔨᐤ ᒌ ᒋᔅᒑᔨᒫᐅᒋᐱᓈ ᐋ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐅᑦ ᐙᔥ ᑭᔨᑆ ᑖᑆᐦ ᐋᐅᒄ ᐋᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᒥᒋᐋᔨᒨᒫᐤ ᐊᐙᓐ ᐋ ᓃᑳᓂᔥᑭᐙᑦ ᒋᑎᐃᔨᔨᒻ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","ᐄᔥᐱᐦ ᒫᒃ ᓈᓯᑐᓄᐙᑦ ᑆᓪ ᑖᐱᔥᑯᓐ ᓵᑎᔫᓰᐦ ᑭᔮᐦ ᐹᕆᓰᐦ ᐋᐦ ᑖᔨᒡ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᓂᔥᑐᐎᔨᒡ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ, ᒌᐦ ᐄᑖᐤ ᐋ ᒋᔣᐙᑦ, “ᓃᒋᔖᓂᑎᒄ, ᐹᕆᓰ ᓃᔨ, ᑭᔮᐦ ᐊᓂᔮᐦᑳ ᓂᑎᐋᓂᔅᒑ ᐙᐦᑯᒫᑭᓂᒡ ᒌ ᐹᕆᓰᐎᒡ᙮ ᐋᐅᒄ ᐆ ᐙᐦᒋ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ ᐊᓅᐦᒡ, ᐋ ᑖᑆᐦᑎᒫᓐ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑳᐤ ᒑ ᐎᓂᔥᑳᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᑆᓪ, ᐊᓂᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᐊᓂᒌ ᓵᑎᔫᓰᒡ ᒌ ᒋᐦᒋ ᒥᒋᐱᔫᒡ, ᐙᔥ ᑖᐹ ᐹᔨᑯᓂᐦᒡ ᐅᐦᒋ ᐄᔑ ᑖᑆᐦᑎᒧᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","ᐊᓂᒌ ᓵᑎᔫᓰᒡ ᓂᒧᐃ ᑖᑆᐦᑎᒧᒡ ᒑ ᐎᓂᔥᑳᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᓂᒧᐃ ᑭᔮᐦ ᑖᑆᐦᑎᒧᒡ ᐋᓐᒋᓐ ᑭᔮᐦ ᐊᐦᒑᐦᒄ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐐᔨ ᐊᓂᒌ ᐹᕆᓰᒡ ᒥᓯᐙ ᐄᔑ ᑖᑆᐦᑎᒧᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","ᐋᒄ ᓈᓈᓂᒌᒻ ᑳᐦ ᐋᑎ ᒥᔥᑎᐦ ᒋᔣᐙᒡ ᐋᐦ ᐋᔮᔅᑖᒥᑑᒡ ᐅᒌ ᐹᕆᓰᒡ ᑭᔮᐦ ᓵᑎᔫᓰᒡ ᐋ ᒥᒋᐱᔨᒡ᙮ ᐋᒄ ᐊᓂᒌ ᐹᕆᓰᒡ ᑳ ᒋᔅᑯᑎᒫᒑᒡ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᐱᓯᑯᒡ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᓂᒧᐃ ᐐ ᓃᔮᓐ ᓂᒥᔅᑭᒸᓈᓐ ᒑᒀᔨᐤ ᒑ ᐅᐦᒋ ᐎᔮᔥ ᑐᐙᑭᓅᑦ ᐆ ᓈᐹᐤ᙮ ᑖᑆᐦ ᑳ ᐊᔨᒥᐦᐄᑯᒀ ᐊᐦᒑᐦᒄ ᑭᔮᐦ ᒫᒃ ᐋᓐᒋᓐ, ᐊᒄᔅ ᐋᑳ ᐎᔮᔅ ᑐᑎᐙᑖᐤ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","ᒑᒃ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᒥᔥᑎᐦ ᒥᒋᐱᔨᓈᓂᐎᔨᒡ, ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᒌ ᑯᔥᐱᓈᔨᐦᑎᒻ ᒑᒃ ᐎᔮᔥ ᒑ ᒌᐦ ᑐᑎᐙᑭᓂᐐᒡ ᑆᓪ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᐅᓂᑐᐱᔨᒻ ᒦᓐ ᒑ ᒌ ᐲᐦᑎᑭᐦᐋᔨᒡ ᑆᓪ ᐊᓂᑖᐦ ᓂᑑᐱᔪᑭᒥᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ᐊᓂᔮᔨᐤ ᒫᒃ ᑖᐱᔅᑳᔨᒡ, ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌ ᐹᒋ ᓃᐴᐎᔨᐤ ᐊᓂᑎᐦ ᑆᓪ ᐋᐦ ᐄᑖᑦ ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᓲᐦᒃ ᐐᐦ ᓲᐦᒋᑖᐦᐋᐦ, ᒋᒌ ᐋᔨᒨᒥᓐ ᐅᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐋᐅᒄ ᒫᒃ ᒑ ᑎᔨᓐ ᑭᔮᐦ ᐊᓂᑖᐦ ᕎᒥᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","ᐊᓐ ᒫᒃ ᒦᓐ ᐎᔮᐱᐦᒡ ᒌᐦ ᑖᐅᒡ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᒫᒨ ᓂᔅᑯᒧᒡ ᑭᔮᐦ ᐋ ᒫᒨ ᑖᑆᐦ ᐋᐦ ᐃᔨᒡ ᒑᔥᑎᓈᔥ ᐋᑳ ᒑ ᐅᐦᒋ ᒦᒋᓱᒡ ᑭᔮᐦ ᐋᑳ ᐙᐙᒡ ᒑ ᒥᓂᐦᒀᒡ ᒑᒀᔨᐤ ᐹᑎᔥ ᒌ ᓂᐱᐦᐋᑣᐙ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","ᐊᐅᔅᑖ ᒫᒃ ᓈᒥᑎᓂᐤ ᒌ ᐃᐦᑎᔑᐎᒡ ᐅᒌ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᐅᑎᐦ ᐆ ᐋ ᑎᔑᔮᐦᒡ ᓂᒌ ᒫᒨ ᓂᔅᑯᒧᓈᓐ ᐋᑳ ᒥᑐᓐ ᒑ ᐅᐦᒋ ᒦᒋᓱᔮᐦᒡ ᐹᑎᔥ ᒌ ᓂᐱᐦᐄᒋᒑ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","ᒌᔨᐙᐤ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒫᒨᐱᔥᑎᐦᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ, ᓂᑑᑖᒨᐙᐦᒄ ᒫᐦ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᒑ ᒌ ᐹᑣᑖᒄ ᐊᓂᔮᔨᐤ ᑆᓪ, ᒧᔮᒻ ᒦᓐ ᐋ ᐐᐦ ᑯᒀᒋᒫᒄ ᒑᒀᔨᐤ ᒋᐱᐦ ᑐᑎᐙᐙᐤ᙮ ᓃᔮᓐ ᐐ ᓂᑭ ᒌ ᓂᐱᐦᐋᓈᓐ ᑆᓪ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᑎᐦ ᐹᔓᐙᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ᐅᔮᔨᐤ ᒫᒃ ᑳᐦ ᐃᔨᒡ ᐅᒌ ᑳ ᐐᐦ ᓂᐱᐦᐋᒡ ᑆᓪ ᓂᐦᐋᐤ ᒌ ᐄᑖᔨᐦᑖᑯᐱᓐ ᓈᐹᔥ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᒡ᙮ ᑆᓪ ᒫᒃ ᐐᒋᔖᓂᔅᒀᒻ ᐅᔮᔨᐤ ᐅᑯᓯᓯᔨᐤᐦ᙮ ᑭᔨᑆ ᐱᔮᐦᑎᐦᒃ ᐊᓐ ᓈᐹᔥ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓂᐎᒡ ᐊᓂᔮᔨᐤ ᐅᐦᑯᒥᔅᐦ ᑆᓪ᙮ ᑳ ᐲᐦᒑᑦ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᓂᑑᐱᔪᑭᒥᑯᔨᐤ ᐊᓂᑖᐦ ᑳ ᑭᓂᐙᔨᒫᑭᓂᐎᔨᒡ ᑆᓪ, ᐋᒄ ᑳ ᐐᐦᑎᒧᐙᑦ ᑖᓐ ᑳ ᐄᔑ ᐹᐦᑎᐦᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ᑆᓪ ᑳ ᓂᑑᒫᑦ ᐹᔨᒄ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᓂᑐᐱᔨᐤ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐄᑐᐦᑎᐦᐄ ᒫᐦ ᐆ ᓈᐹᔥ ᓈᑖᐦ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᐋᐦ ᑖᔨᒡ᙮ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᐙᐦ ᐐᐦᑎᒧᐙᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","ᐋᒄ ᑭᔨᑆ ᐊᓐ ᑳ ᓃᑳᓂᔥᑭᐙᑦ ᓂᑐᐱᔨᐤ ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᐊᓂᑖᐦ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᐋᐦ ᑖᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ, “ᐊᓐ ᑳ ᐅᑎᓈᑭᓅᑦ ᑆᓪ ᓂᒌᐦ ᐄᑎᒄ ᒑ ᐹᔒᒥᒡ ᐅᔮᔨᐤ ᓈᐹᔥ ᐅᑎᐦ ᐋᐦᑖᐅᑦ, ᒑᒀᔨᐤ ᒋᐐᐦ ᐄᑎᑯᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᐅᑎᓂᒸᑦ ᐊᓂᔮᔨᐤ ᓈᐹᔥ ᐅᑎᐦᒌᔨᐤ, ᑳ ᐄᑐᐦᑎᐦᐋᑦ ᐊᓂᑖᐦ ᒥᒄ ᐐᔨᐙᐤ ᒑ ᒌ ᓃᔑᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᒑᒀᓐ ᑳ ᐐᐦ ᐹᒋ ᐐᐦᑎᒧᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ᐋᒄ ᐊᓐ ᓈᐹᔥ ᑳᐦ ᐃᔨᑦ, “ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒎᐄᔨᔨᐤ ᒋᑭ ᐄᑎᑯᒡ ᐙᐱᓃᔨᒑ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᒫᒄ ᑆᓪ ᓈᑖᐦ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ ᐋᐦ ᑖᔨᒡ, ᒧᔮᒻ ᒦᓐ ᒑᒀᔨᐤ ᐋ ᐐᐦ ᐄᔑ ᓂᑑᒋᔅᒑᔨᒫᒡ ᒋᑭ ᑐᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","ᐊᑳᐐ ᒥᒄ ᑖᑆᐦᑑᒡ᙮ ᐊᐅᔅᑖ ᓈᒥᑎᓂᐤ ᐄᑎᔓᒡ ᓈᐹᐆᒡ ᐊᓂᒌ ᐋᐦᑎᑯᓃᔨᒡ ᐊᓂᑖᐦ ᐋ ᑳᔓᒡ ᐋ ᐊᔓᐙᐱᒫᒡ ᒑ ᐃᔥᐱᔥ ᐄᑐᐦᑎᐦᐄᒫᑭᓂᐎᔨᒡ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ᙮ ᐙᔥ ᒋᐦᒋᐙ ᒌ ᐃᔨᐅᒡ ᐋᑳ ᒑ ᐅᐦᒋ ᒦᒋᓱᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᐅᐦᒋ ᒥᓂᐦᒀᒡ ᒑᒀᔨᐤ ᐹᑎᔥ ᒌ ᓂᐱᐦᐋᑣᐙ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ᔖᔥ ᒫᒃ ᐃᔮᔅᑭᐎᔪᒡ ᐅᔮᔨᐤ ᒑ ᑎᒡ, ᒥᒄ ᐊᔓᐙᐱᒫᐅᒡ ᒑ ᐃᔥᐱᔥ ᐄᑐᐦᑎᐦᐄᒫᑭᓂᐎᔨᒡ ᓈᑖᐦ ᓂᔅᑯᒧᔨᓈ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᔥ, “ᐊᑳᐐ ᐊᐙᓐ ᐐᐦᑎᒨ ᑖᓐ ᑳ ᐄᔑ ᐐᐦᑎᒧᔨᓐ ᐊᓅᐦᒡ᙮” ᐋᒄ ᑳ ᒌᐙᑎᔑᐦᐙᑦ ᐊᓂᔮᔨᐤ ᓈᐹᔥ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᓂᑑᒫᑦ ᓃᔓ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐅᓂᑐᐱᔨᒻ, ᐋᒄ ᑳᐦ ᐄᑖᑦ, “ᐃᔮᔅᑰᐦᐄᒡ ᓃᔣ ᒥᑖᐦᑐᒥᑎᓂᐤ ᓂᑐᐱᔫᒡ ᑳ ᒧᔅᑐᐦᑖᒡ ᑭᔮᐦ ᓃᔂᓱᒥᑎᓂᐤ ᐊᓂᒌ ᐋᐦᐋᔅ ᑳ ᒌ ᐋᐱᒋᐦᐋᒡ ᐋ ᒫᓯᐦᒑᒡ ᑭᔮᐦ ᒫᒃ ᓃᔣ ᒥᑖᐦᑐᒥᑎᓂᐤ ᓂᑐᐱᔫᒡ ᐊᔑᒫᑭᓐ ᑳ ᒫᓯᐦᒑᐙᒑᒡ ᒑ ᒌ ᐄᑐᐦᑖᒡ ᓭᓵᕆᔮᐦᒡ᙮ ᐊᓅᐦᒡ ᒫᒃ ᐅᔮᔨᐤ ᒑ ᐅᑖᑯᔑᔨᒡ ᐹᔨᑯᔥᑖᐤ ᐄᔅᐱᔨᔨᒑ ᒑ ᒋᔅᑐᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","ᔮᔨᑖ ᐅᐦᑎᓂᒧᐙᒄ ᑆᓪ ᐋᐦᐋᔅ ᒑ ᒌ ᐱᒧᐦᑎᐦᐄᑯᑦ᙮ ᐋᒄ ᓈᑖᐦ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ ᐋᐦ ᑖᔨᒡ ᒑ ᐄᑐᐦᑎᐦᐋᒄ᙮ ᔮᒀᐦ ᓈᓈᑭᒋᐦᐋᐦᒄ ᐋᑳ ᒑ ᒌ ᐎᔮᔥ ᑐᑖᑯᑦ ᐊᐙᔨᐤᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ᐋᒄ ᐊᓐ ᕎᒻ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᒥᓯᓂᐦᐄᒑᑦ ᐋᐦ ᐄᑎᔥᑖᑦ, ");
INSERT INTO crl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“ᒃᓨᑎᔨᔅ ᓚᐃᓰᔨᔅ ᓃᔨ, ᐙᒋᔮ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ ᒋᒥᓯᓂᐦᐋᒫᑎᓐ, ");
INSERT INTO crl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","ᐆ ᓈᐹᐤ ᑳᐦ ᐄᑎᔑᐦᐅᒃ ᐋᐦᑖᐅᑦ ᒎᐄᔨᔨᐤ ᒌ ᐅᑎᓂᑰ, ᑭᔮᐦ ᒋᐐᐦ ᓂᐱᐦᐄᑰ᙮ ᐄᔥᐱᐦ ᑳ ᐐᐦᑎᒫᑭᐎᔮᓐ ᕎᒻ ᐋ ᐄᔑ ᒥᓯᓈᓱᑦ, ᐋᒄ ᑳ ᓂᑑᐐᒋᐦᐄᒃ ᓂᓂᑑᐱᔨᒻᐦ ᐋ ᒌ ᐐᒑᐅᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ᓂᒌ ᐐᐦ ᓂᑑᒋᔅᒑᔨᐦᑎᒸᓐ ᒑᒀᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒫᒥᔑᒫᒡ, ᐋᒄ ᑳ ᐄᑐᐦᑎᐦᐄᒥᒡ ᐊᓂᑖᐦ ᒎᐤ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ᐄᔥᐱᐦ ᒫᒃ ᐙᐦᑎᒫᑭᐎᔮᓐ ᑖᓐ ᑳ ᐄᔑ ᒫᒥᔑᒫᑭᓅᑦ ᐆ ᓈᐹᐤ ᓂᒧᐃ ᒑᒀᔨᐤ ᐅᐦᒋ ᑎᑯᓃᔨᑯᐱᓐ ᒑ ᒌ ᐅᐦᒋ ᐎᔮᔥ ᑐᑎᐙᑭᓅᑦ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᓂᐱᐦᐋᑭᓅᑦ᙮ ᐋᐦᐋᑳ ᒫᒨᔮᒻ ᑐᑎᐦᒃ ᒎᐤ ᐐᔓᐙᐎᓐ ᐋᔪᐎᒄ ᑳ ᐄᔑ ᒫᒥᔑᒫᑭᓅᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","ᒑᒃ ᑳ ᐐᐦᑎᒫᑭᐎᔮᓐ ᐋ ᐃᔮᔅᑭᐎᔨᒡ ᒎᐄᔨᔨᐤ ᐋ ᐐᐦ ᓂᐱᐦᐄᑯᑦ, ᐋᒄ ᑳ ᐄᑖᔨᐦᑎᒫᓐ ᒑ ᒌ ᐄᑎᔑᐦᐅᒃ ᑎᐙᐦᒡ ᓈᑖᐦ ᐋᐦ ᑖᔨᓐ᙮ ᐋᒄ ᒫᒃ ᐙᐦ ᐄᑎᒀᐤ ᐊᓂᒌ ᑳᐦ ᑖᒡ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑎᒥᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ, ᐐᔨᐙᐤ ᒑ ᒌ ᓂᑑᐐᐦᑎᒫᔅᒡ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᔑᒫᒡ᙮ ᒑ ᐎᔮᔨᐦᑎᒥᓐ ᒫᒃ ᑖᓐ ᒑ ᑐᑎᐙᑭᓅᑦ᙮ ᒋᐙᒋᔮᒥᑎᓐ ᒫᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ᐋᔪᐎᒄ ᑭᔨᑆ ᑳᐦ ᑎᒡ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᐄᑎᔓᒫᑭᓂᐎᒡ᙮ ᒌ ᓂᑎᐙᐱᒫᐅᒡ ᑆᓪ ᐊᓂᔮᔨᐤ ᑖᐱᔅᑳᔨᒡ, ᐋᒄ ᑳ ᒋᔅᑐᐦᑎᐦᐋᒡ᙮ ᐊᓂᑎᐹᑦᕆᔅ ᒫᒃ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐃᔥᐱᔥ ᐄᑐᐦᑎᐦᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ᐊᓂᔮᔨᐤ ᒫᒃ ᐎᔮᐱᓃᔨᒡ, ᒌ ᒌᐙᐅᒡ ᐊᓂᒌ ᑳ ᒧᔅᑐᐦᑖᒡ ᓂᑐᐱᔫᒡ᙮ ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐋᐦᐋᔅ ᑳᐦ ᐋᐱᒋᐦᐋᒡ ᑳ ᐐᒑᐙᒡ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ᐊᓂᑖᐦ ᒫᒃ ᓭᓵᕆᔮᐦᒡ ᐋᑯᑖᐦ ᑳ ᐄᑐᐦᑎᐦᐋᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐊᓂᑎᐦ ᐋᒄ ᑳ ᒥᔮᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ᙮ ᑆᓪ ᑭᔮᐦ ᑳ ᐱᒋᔅᑎᓈᒡ ᐊᓂᑖᐦ ᕖᓕᒃᔅ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᑳ ᐊᔨᒥᐦᑖᑦ ᐊᓂᔮᔨᐤ ᒥᓯᓂᐦᐄᑭᓂᔨᐤ᙮ ᑳ ᒌᔥ ᐊᔨᒥᐦᑖᑦ ᒫᒃ ᐋᒄ ᑳ ᑯᒀᒋᒫᑦ ᐊᓂᔮᔨᐤ ᑆᓪ ᑖᓂᑖᐦ ᐙᐦᒋᔨᒡ᙮ ᐄᔥᐱᐦ ᒑᔅᒑᔨᐦᑎᐦᒃ ᐊᓂᑖᐦ ᓯᓕᓯᔮ ᐋ ᐅᐦᒌᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᐄᔥᐱᐦ ᑎᑯᔑᐦᒀᐙ ᐊᓂᒌ ᑳ ᒫᒥᔑᒥᔅᒡ ᐋᑯᑖᐦ ᐃᔮᒀ ᒑ ᓂᑑᐦᑎᒫᓐ ᑖᓐ ᐙᐦ ᐄᔑ ᑎᐹᔅᑯᓂᑭᐎᔨᓐ᙮” ᐋᒄ ᑳᐦ ᐄᑎᔓᒫᑦ ᐅᓂᑐᐱᔨᒻ ᒑ ᒌ ᓈᓈᑭᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᐊᓂᑖᐦ ᐊᓂᔮᐦ ᐦᐁᕆᑦ ᐅᒋᔥᒍᒋᒫᐅᑭᒥᑯᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ᓂᔮᔪ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᐊᓐ ᒫᐅᒡ ᑳ ᓃᑳᓈᔮᔨᐦᑖᑯᔑᑦ ᒋᔖᐊᔨᒥᐦᐋᐅᒋᒫᐤ ᐋᓂᓈᔮᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᒌ ᑎᑯᔑᓐ ᐊᓂᑎᐦ ᓭᓵᕆᔮᐦᒡ᙮ ᒌ ᐐᒑᐅᑰ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒎᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᔨᒥᔅᑏᒫᒑᓯᐤ ᑌᕐᑖᓚᔅ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮ ᐋᒄ ᑳ ᓂᑎᐙᐱᒫᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ ᐋ ᐙᐐᐦᑎᒧᐙᒡ ᑖᓐ ᑳ ᐄᑖᔨᒫᒡ ᑆᓪ ᐋ ᐄᔑ ᐎᓂᑐᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","ᐋᒄ ᑆᓪ ᑳ ᓂᑑᒫᑭᓅᑦ ᒑ ᒌ ᐲᐦᒑᑦ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐲᐦᒑᑦ ᐋᒄ ᑌᕐᑎᓚᔅ ᑳ ᒋᐦᒋ ᐙᐐᐦᑎᐦᒃ ᑖᓐ ᑳ ᐄᔑ ᐊᑖᒫᔨᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ, “ᒌᔨ, ᒋᐦᒋᐅᒋᒫᐤ, ᓈᔥᒡ ᑳ ᑭᔅᒋᐦᐅᔨᓐ ᐋ ᓃᑳᓂᔥᑳᒑᔨᓐ, ᓈᐅᔥ ᓂᒧᐃ ᐅᐦᒋ ᑎᑯᓐ ᒑ ᒌ ᒥᒥᒋᐱᔨᓈᓂᐎᒡ ᐅᑖᐦ ᒌᔮᓂᐤ ᐄᑖᐦᒑ ᐋᐦ ᑖᔨᐦᒄ, ᒨᔥ ᒌ ᒋᔮᒫᐙᔨᐦᑖᑯᓐ᙮ ᑭᔮᐦ ᓂᓈᐦᑭᐤ ᒑᒀᓂᐦᐄ ᒋᒌ ᐋᐦᒋᐦᑖᓐ ᒑ ᒌ ᐅᐦᒋ ᒥᔪᐱᔨᓈᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ᒥᓯᐙ ᒫᒃ ᑖᓂᑖᐦ ᐋᐦ ᑖᔮᐦᒡ ᑖᑆᐦ ᒌ ᓂᔅᑯᒥᑎᓈᓐ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒥᓐ ᑳ ᐃᔥᐱᔥ ᐅᒋᒫᐅᐎᓐ ᐅᑖᐦ ᐋᐦ ᑖᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","ᐋᒄ ᒫᒃ ᐋᑳ ᓈᔥᒡ ᒑ ᒌ ᐅᑎᒥᐦᐄᑖᐦᒡ, ᒋᒌ ᐐᐦ ᐄᔑ ᑯᒀᒋᒥᑎᓐ ᐊᓐ ᑭᔨᑆ ᐋ ᐄᔑ ᒥᔪᐦᑣᔨᓐ ᒑ ᒌ ᓂᑐᐦᑎᐎᔨᓐ ᑖᓐ ᒑ ᐃᔮᓐ᙮ ᓂᒧᐃ ᓈᐅᔥ ᒋᑭ ᐅᐦᒋ ᐊᔨᒥᐦᐄᑎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ᓂᒥᔅᑰᐙᐦᓈᓐ ᐆ ᓈᐹᐤ, ᑆᓪ ᐋ ᐅᔅᑖᐱᐦᐄᐙᑦ᙮ ᑎᑯᓂᔨᐤ ᑖᓐ ᐋᐦᑎᒃ ᐊᓂᑎᐦ ᐙᐦᒋ ᑐᑎᐙᑦ ᐅᔮᔨᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐄᔨᔨᐤ ᒥᓯᐙ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ ᒑ ᒌ ᓈᔥᒡ ᒥᒋᐱᔨᔨᒡ᙮ ᐐᒋᐦᐄᐙᐤ ᑭᔮᐦ ᐋ ᓃᑳᓂᔥᑳᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓈᓵᕇᓐ ᑳ ᐃᔑᓂᐦᑳᑎᒫᑭᓂᐎᔨᒡ ᓈᔥᒡ ᓂᑎᐐ ᒥᒄ ᑳ ᐄᔑ ᑭᑖᑆᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ᐙᐙᒡ ᒋᐐᐦ ᒫᔮᔨᐦᑎᒻ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᔨᐤ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐅᑎᓂᒋᐦᑦ᙮ ᐊᓂᑖᐦ ᒫᒃ ᓃᔮᓐ ᓄᐎᔮᔅᑯᓂᒑᐎᓈᐦᒡ ᐋᑯᑖᐦ ᑳ ᐐᐦ ᐄᔑ ᑎᐹᔅᑯᓂᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","ᒥᒄ ᒫᒃ ᐊᓐ ᓂᑐᐱᔫᒋᒫᐤ ᓚᐃᓰᔨᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ ᑳ ᑎᑯᔑᐦᒃ, ᑳ ᒥᔅᑭᒥᔨᒥᐦᑦ ᐅᔮᔨᐤ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ᒌ ᐄᑎᔓᒫᐤ ᐊᓂᔮᔨᐤ ᑆᓪ ᑳ ᒫᒥᓯᒥᑯᔨᒡ ᒑ ᐅᑎᔅᑯᑳᐳᔅᑖᔅᒌᒡ ᒌᔨ ᐙᒋᐦᒡ ᒑ ᑎᐹᔅᑯᓂᑦ᙮ ᐋᒄ ᒫᒃ ᒌᔨ ᐙᒌᐦᒡ ᒑ ᒌ ᓂᑑᒋᔅᒑᔨᒥᑦ ᑖᓐ ᑳᐦ ᑎᒃ᙮ ᑯᒀᒋᒥᑖ ᒫᒃ ᑆᓪ, ᒋᑭ ᒌ ᓂᑑᒋᔅᒑᔨᐦᑎᒸᓐ ᐅᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᔑᒥᐦᒄ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐄᑖᑦ ᑌᕐᑖᓚᔅ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᑌᕐᑖᓚᔅ ᑳ ᐐᒑᐙᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋᔪᐎᒄ ᑳᐦ ᐃᔨᒡ ᑖᑆᐦ ᐋ ᒌ ᐎᓂᑐᑎᒥᔨᒡ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᑳ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᑆᓪ ᒑ ᒌ ᐊᔨᒥᔨᒡ, ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᒌ ᒋᔅᒑᔨᒥᑎᓐ ᔖᔥ ᒥᐦᒑᑐ ᐱᐳᓐ ᐋ ᒌ ᑎᐹᔅᑯᓂᒑᓰᐎᔨᓐ ᐅᑖᐦ ᐄᑖᐦᒑ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ᙮ ᓂᒥᔻᔨᐦᑖᓐ ᒫᒃ ᐋ ᓂᐦᐄᐱᔨᐦᒡ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐋᔨᒨᑎᒫᑖᓐ ᑭᔮᐦ ᓃᔨ ᐆ ᑖᓐ ᐙᐦ ᐄᔑ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ᒥᒄ ᓃᔓᔖᑉ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᐅᑖᐦ ᐄᔑ ᐅᑖᐦᒡ ᑳ ᐃᔥᐱᔥ ᑎᑯᔑᓂᔮᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋ ᒌ ᓂᑑᐊᔨᒥᐦᐋᔮᓐ᙮ ᒌᔨ ᐙᒋᐦᒡ ᒋᑭ ᒌ ᓂᑑᒋᔅᒑᔨᐦᑖᓐ ᐋ ᑖᑆᔮᓐ ᐆ ᑳ ᐄᑎᑖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","ᐅᒌ ᒫᒃ ᑳᐦ ᑎᑯᓃᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᐹᒋ ᒥᒥᒑᒋᒥᐦᒡ ᓂᒧᐃ ᓅᐦᒋ ᐙᐱᒥᑯᒡ ᒑ ᒌ ᐅᔅᑑ ᐋᔮᒥᐦᐄᒥᒡ ᐊᐙᔨᐤᐦ ᐊᓂᑖᐦ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ᙮ ᓂᒧᐃ ᑭᔮᐦ ᓅᐦᒋ ᐙᐱᒥᑯᒡ ᒑ ᒌᐦ ᑐᑎᒥᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᒥᒋᐱᔨᔨᒡ ᐊᓂᑖᐦ ᓂᓈᐦᑭᐤ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᐃᔨᐦᒡ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᓂᐦᐋᐤ ᒋᑭ ᒌ ᐙᐱᐦᑎᔨᑯᒡ ᑖᑆᐦ ᐋ ᑖᑆᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐹᒋ ᐊᑖᒫᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ᒫᐤ ᒥᒄ ᒑᔥᑎᓈᔥ ᑯᐃᔅᒄ ᒑ ᒌ ᐄᔑ ᐐᐦᑎᒫᑖᓐ᙮ ᐋᑯᑖᐦ ᐋ ᐄᔑ ᐐᒋᐦᐄᐙᔮᓐ ᑭᔮᐦ ᓃᔨ ᐊᓂᒌ ᑳ ᐱᒧᐦᑖᒡ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐄᔨᔨᒡ ᒑ ᐄᔑ ᐱᒧᐦᑖᓂᐎᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᓂᑎᐐ ᒥᒄ ᐋ ᐄᔑ ᑭᑖᑆᐦᑖᑭᓂᐎᒡ ᑳ ᐃᔑᓂᐦᑳᑎᐦᒡ ᐐᔨᐙᐤ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ᐊᓐ ᒋᔖᒥᓂᑑ ᒋᑖᓂᔅᑰᓰᒥᓅᒡ ᑳ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ ᐋᐅᒄ ᐊᓐ ᐊᔨᒥᐦᐋᔥᑐᐎᒃ ᑭᔮᐦ ᓃᔨ᙮ ᓃᔨ ᒫᒃ ᐐᔨ ᓂᑖᑆᐦᑖᓐ ᒥᓯᐙ ᒑᒀᓐ ᑖᓐ ᐋ ᐄᔑ ᐐᐦᑖᑯᐦᒡ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᐦᒡ ᑭᔮᐦ ᒥᓯᐙ ᑖᓐ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᐊᓂᒌ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐅᒥᓯᓂᐦᐄᑭᓂᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","ᓂᑖᑆᐦᑖᓐ ᑭᔮᐦ ᓃᔨ ᑳᐤ ᒑ ᐎᓂᔥᑳᒡ ᒥᓯᐙ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ, ᐊᓂᒌ ᑳ ᒥᒋᐦᑑᑎᐦᒡ ᑭᔮᐦ ᐊᓂᒌ ᑳ ᒥᔪᐃᐦᑐᑎᐦᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᔮᔨᒫᒄ ᒋᔖᒥᓂᑑ ᒑ ᑐᑎᐦᒃ ᒧᔮᒻ ᑭᔮᐦ ᐐᔨᐙᐤ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᐄᔑ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ᓲᐦᒃ ᓂᑭ ᐙᓰᐹᔨᒥᓲᓐ ᐋᑳ ᒑ ᒌ ᒫᔮᔨᒥᒃ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒫᒃ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐅᐦᒋ ᒑᔥᑎᓈᐦᐅᔮᓐ ᑯᐃᔅᒄ ᐋᐦ ᑎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ᒥᐦᒑᑐ ᐱᐳᓐ ᓂᒧᐃ ᓅᐦᒋ ᑖᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳᐤ ᑳ ᑎᑯᔑᓂᔮᓐ ᐊᓂᑎᐦ, ᓂᒌ ᐹᑐᐙᐅᒡ ᓂᑎᐄᔨᔨᒥᒡ ᐱᒋᔅᑎᓂᒑᐎᓂᔨᐤ ᐋ ᒌ ᒥᔮᑭᓂᐎᔨᒡ ᐊᓂᒌ ᑳ ᒋᔅᑎᒫᑎᓰᔨᒡ, ᐋᒄ ᒫᒃ ᐋᔨᐤᐦ ᓂᒌ ᓈᒋᐊᔨᒥᐦᐋᓐ ᒑ ᒌ ᒥᒋᔥᑎᐦᐊᒨᒃ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᒫᒀᒡ ᑳ ᑖᐅᒡ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑳ ᐙᐱᒥᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᑳ ᐅᐦᒌᒡ᙮ ᔖᔥ ᓂᒌᐦ ᑐᑎᒸᓐ ᑖᓐ ᑳ ᒌᐦ ᑎᓈᓂᐎᔨᒡ ᒑ ᒌ ᐱᔮᐦᒋᐦᐄᓱᓈᓂᐎᔨᒡ᙮ ᐊᓐ ᒫᒃ ᒫᒀᒡ ᓂᒧᐃ ᐅᐦᒋ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑭᔮᐦ ᓂᒧᐃ ᒑᒀᓐ ᐅᐦᒋ ᒥᒋᐱᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","ᒥᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᐋ ᐅᒌᒡ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ᙮ ᐋᐅᑯᓂᒡ ᒫᒃ ᐊᓂᒌ ᒋᐱᐦ ᑖᐅᒡ ᐅᑎᐦ ᐋᐦᑖᐅᑦ ᒑ ᒌ ᐐᐦᑎᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒧᐙᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ᐅᒌ ᒫᒃ ᐅᑎᐦ ᑳᐦ ᑖᒡ ᑯᒀᒋᒫᐦᑯᒡ ᑳ ᒥᔅᑭᒧᐙᒀ ᐋ ᒌ ᐎᓂᑐᑎᒧᒡ ᒫᒀᒡ ᑳ ᑎᐹᔅᑯᓂᒡ ᐊᓂᑖᐦ ᒎᐤ ᑳ ᒫᒨᐱᔥᑎᒥᔨᒡ ᑎᐹᔅᑯᓂᒑᐎᓂᔨᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","ᐹᔨᒄ ᑭᔨᑆ ᒑᒀᔨᐤ ᓂᒌᐦ ᔨᐙᓐ ᐊᓂᑎᐦ ᑳ ᐎᑎᔅᑭᐎᑳᐳᔥᑑᒀᐤ, ᑭᔮᐦ ᒫᒃ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦ ᐅᐦᒋ ᑎᐹᔅᑯᓂᐙᒀ᙮ ᓂᒌ ᒋᔣᐙᐙᓐ ᐋᐦ ᐃᔨᐅᒡ, ᐋ ᑖᑆᐦᑎᒫᓐ ᐊᓂᒌ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒦᓐ ᑳᐤ ᒑ ᐎᓂᔥᑳᒡ᙮ ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᒄ ᐊᓅᐦᒡ ᐆ ᑳᔑᑳᒡ᙮” ᐋᔪᐎᒄ ᑳᐦ ᐄᑖᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ ᒫᒃ ᑭᔮᐦ ᐐᔨ ᒌ ᒥᔪ ᒋᔅᒑᔨᐦᑎᒻ ᐊᓂᔮᔨᐤ ᒫᔅᑭᓈᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᐄᔨᔨᒡ ᒑ ᒌ ᐄᔑ ᐱᒧᐦᑖᓂᐎᔨᒡ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐅᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑳ ᒋᐱᐦᐋᐦᒃ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᑎᐹᔅᑯᓂᒫᑳᓂᐎᔨᒡ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᐄᔥᐱᐦ ᒌ ᑎᑯᔑᐦᑳ ᐊᓐ ᓂᑐᐱᔫᒋᒫᐤ ᓛᐃᓰᔨᔅ ᑳ ᐃᔑᓂᐦᑳᓱᑦ, ᐋᒄ ᒋᐦᒋᐙ ᒑ ᐎᔮᔨᐦᑎᒫᓐ ᑖᓐ ᒑ ᐄᑎᔓᒥᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔫᒋᒫᐤ ᑳ ᓈᓈᑭᒋᐦᐋᔨᒡ ᑆᓪ ᔮᒀᐦ ᐊᔮᐱᒡ ᒑ ᒌ ᓈᓈᑭᒋᐦᐄᒫᑭᓂᐎᔨᒡ ᑆᓪ, ᒥᒄ ᐋᑳ ᒥᑐᓐ ᒑ ᒌ ᒥᒫᒋᑯᓂᒫᑭᓂᐎᔨᒡ᙮ ᒌ ᐄᑎᔑᐦᐙᐤ ᑭᔮᐦ ᒑ ᒌ ᐱᒋᔅᑎᓂᒫᑭᓂᐎᔨᒡ ᐅᐐᒑᐙᑭᓂᔨᐤ ᒑ ᒌ ᐐᒋᐦᐄᑯᔨᒡ ᑖᓐ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒀᓂᐦᐄ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ᓂᒧᐃ ᒫᒃ ᓈᐅᔥ, ᐋᒄ ᒦᓐ ᑳ ᑎᑯᔑᐦᒃ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ, ᐐᐤᐦ ᑦᕈᓯᓚ ᐋ ᐹᒋ ᐐᒑᐙᑦ᙮ ᒎᐤ ᒌ ᐄᑎᔅᑳᓈᓯᔨᐤ ᐊᓂᔮᔨᐤ ᐐᐤᐦ᙮ ᐋᒄ ᑳ ᓂᑑᒫᑦ ᕖᓕᒃᔅ ᐊᓂᔮᔨᐤ ᑆᓪ, ᑳ ᓂᑑᐦᑎᐙᑦ ᐋᐦ ᐋᔨᒨᑎᒥᔨᒡ ᐋ ᑖᑆᔮᔨᒫᑭᓂᐎᔨᒡ ᙭ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","ᐄᔥᐱᐦ ᒫᒃ ᐋᐦ ᐋᑎ ᐋᔨᒨᑎᒥᔨᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᒑ ᐐᐦ ᒥᔪᓈᑭᑎᐙᔨᒦᓲᔨᒡ ᐊᐙᔨᐤᐦ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᔥᒄ ᒑ ᐅᑎᐦᒋᐱᔨᔨᒡ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᑎᐦ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒑ ᑎᐹᔥᑯᓈᔨᒡ, ᒌ ᑯᔥᑖᒎ ᕖᓕᒃᔅ, ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮ ᑆᓪ, “ᐋᑯᑖᐦ ᐱᑎᒫ᙮ ᔖᔥ ᒋᑭ ᒌ ᒫᒌᓐ᙮ ᐄᔥᐱᐦ ᒦᓐ ᓂᐦᐄᐱᔮᓈ ᐋᒄ ᒦᓐ ᒑ ᓂᑑᒥᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","ᒥᒄ ᒫᒃ ᒌ ᑎᑯᓃᔨᑯᐱᓐ ᑖᓐ ᑳ ᐄᔑ ᐱᑯᓵᔨᒧᑦ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ᙮ ᒌ ᐱᑯᓵᔨᒫᑖᑯᐱᓐ ᑆᓪ ᒑ ᒌ ᒥᔨᑯᑦ ᔓᐎᔮᓐ ᐋᒄ ᒫᒃ ᒨᔥ ᑳ ᓂᑑᒫᑦ ᒑ ᒌ ᐊᔨᒥᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ᓃᔓ ᐱᐳᓐ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᑳ ᒦᔅᑯᑎᔥᑳᑯᑦ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᕖᓕᒃᔅ᙮ ᐳᕐᑭᔮᐦᔅ ᕓᔅᑐᔅ ᒌ ᐃᔑᓂᐦᑳᓱᔨᐤ ᐊᓂᔮᔨᐤ ᑳ ᒦᔅᑯᑎᔥᑳᑯᑦ᙮ ᐋᒄ ᒫᒃ ᕖᓕᒃᔅ, ᒥᒄ ᐋ ᐐᐦ ᓂᓂᐦᐄᐙᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᑳ ᓂᑭᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᑳ ᐃᔥᐱᔥ ᑎᑯᔑᐦᒃ ᐳᕐᑭᔮᐦᔅ ᕓᔅᑐᔅ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ, ᒌ ᓂᑭᑎᒻ ᓭᓯᕇᔮᐦ ᐋᒄ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐄᑐᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐹᒋ ᐎᑎᔅᑭᐎᑳᐳᔥᑖᑯᑦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐤᐦ ᑭᔮᐦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᒎᐄᔨᔨᐤ ᐋ ᐹᒋ ᒫᒥᔑᒫᔨᒡ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","ᒌ ᔒᐦᒋᒫᐅᒡ ᕓᔅᑐᔅ ᒑ ᒌ ᓂᔅᑯᒧᔨᒡ ᒑ ᒌ ᐹᒋ ᐄᑐᐦᑎᐦᐄᒫᑭᓂᐎᔨᒡ ᑆᓪ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐙᔥ ᒌᒧᒡ ᒌ ᐎᔮᔨᐦᑎᒧᑖᐙᑯᐱᓐ ᒑ ᒌ ᐊᔮᔅᑭᐎᔨᒡ ᑆᓪ ᐋ ᐐᐦ ᓂᐱᐦᐋᒡ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐹᒋ ᐄᑐᐦᑎᐦᐄᒫᑭᓂᐎᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ᐋᒄ ᕓᔅᑐᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᔥᒄ ᒫᒀᒡ ᒋᐳᐦᐙᑭᓂᐤ ᑆᓪ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ᙮ ᔖᔥ ᒫᒃ ᐐᐱᒡ ᓂᑭ ᐄᑐᐦᑖᓐ ᓈᑖᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ᐋᐦᑖᐙᒀ ᒫᒃ ᐊᓂᒌ ᑳ ᓃᑳᓂᔥᑳᑖᑯᒡ ᐋᐦᑎᑯᓃᔨᒡ ᑖᓐ ᐙᐦ ᐄᔑ ᑎᐹᔅᑯᓈᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᓂᐱᐦ ᐹᒋ ᐐᒑᐅᑯᒡ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ ᐋᐦ ᐄᑐᐦᑖᐅᒡ᙮ ᐋᒄ ᒫᒃ ᑖᑆᐦ ᑳ ᐎᓂᑐᑎᒥᔨᒀᓂᐦᐄ, ᐋᑯᑖᐦ ᓈᑖᐦ ᑖᔨᐦᒑ ᓂᐱᐦ ᐐᐦᑎᒫᑯᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒥᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ᐎᔮᔥ ᒫᒃ ᓂᔮᓈᓈᐤ ᑭᔮᐦ ᒫᒃ ᒥᑖᐦᑐ ᒌᔑᑳᐤᐦ ᒌ ᐃᔥᐱᔥ ᑖᐤ ᒦᓐ ᕓᔅᑐᔅ ᐊᓂᑎᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐋᒄ ᑳ ᐄᑐᐦᑖᑦ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ᙮ ᐎᔮᐱᓃᔨᒡ ᒫᒃ, ᒌ ᐋᑎᐅᐙᔨᐱᐤ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᐄᔥᐱᐦ ᒥᓯᐙ ᑳ ᓂᔥᑐᐎᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐐᐦ ᑎᐹᔅᑯᓈᔨᒡ ᑆᓪ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᑆᓪᐦ ᒑ ᒌ ᐹᒋ ᐲᐦᑎᑭᐦᐄᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐲᐦᑎᑭᐦᐄᒫᑭᓂᐎᔨᒡ ᑆᓪᐦ, ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒋᕉᓯᓕᒥᐦᒡ ᑳ ᐅᐦᑐᐦᑖᒡ ᒌ ᐋᑎ ᐙᔅᑳᑳᐳᔥᑎᐙᐅᒡ᙮ ᐋᒄ ᓂᓈᐦᑭᐤ ᐋᒀᒡ ᒑᒀᔨᐤ ᑳ ᐄᔑ ᒫᒥᔑᒫᒡ᙮ ᓂᒧᐃ ᒥᒄ ᐅᐦᒌ ᑑᐎᒡ ᑖᑆᐦ ᒑ ᒌ ᒑᔥᑎᓈᑖᔨᐦᑖᑯᑖᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒫᒥᔑᒫᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ᒑᒃ ᒫᒃ ᑆᓪ ᑳ ᐊᔨᒦᔥᑎᒫᓱᑦ᙮ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᓂᒧᐃ ᓅᐦᒋ ᐎᓂᑐᑖᓐ ᒎᐤ ᐐᔓᐙᐎᓐ᙮ ᓂᒧᐃ ᑭᔮᐦ ᓅᐦᒋ ᑎᓐ ᒑ ᒌ ᒫᔮᔨᐦᑎᒫᓐ ᒎᐤ ᒋᔖᐊᔨᒥᐦᐊᐅᑭᒥᒄ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐎᓂᑐᑎᐎᒃ ᕎᒻ ᒋᐦᒋᐅᒋᒫᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","ᐋᒄ ᕓᔅᑐᔅ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᒋᐱᐦ ᒥᔻᔨᐦᑖᓈ ᓈᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᑭᐎᔨᓐ ᑭᔮᐦ ᒑ ᒌ ᑎᐹᔅᑯᓂᑖᓐ ᐅᐦᒋ ᐊᓂᐦᐄ ᑳ ᐄᔑ ᒫᒥᔑᒥᑭᐎᔨᓐ?” ᒥᒄ ᐋ ᐐᐦ ᓂᓂᐦᐄᐙᐦᐋᑦ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐋᔪᐎᒄ ᐙᐦᒋ ᐃᔨᑦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","ᐋᒄ ᑆᓪ ᑳᐦ ᐃᔨᑦ, “ᐅᑎᐦ ᐆ ᑳ ᓃᐴᔮᓐ ᓰᓯᕐ ᐅᐎᔮᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ ᐋᑯᑖᐦ ᐅᑎᐦ ᓂᐱᐦ ᑎᐹᔅᑯᓂᑭᐎᓐ ᐙᐦ ᑎᐹᔅᑯᓂᑯᐙᓈ᙮ ᑖᐹ ᑎᑯᓂᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᐅᒀᐤ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ᒌᔨ ᐙᒋᐦᒡ ᒌ ᒋᔅᒑᔨᐦᑖᓈᒑ ᐆ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","ᑖᑆᐦ ᒫᒃ ᐋᐦᑎᑯᓃᒀ ᐋ ᒌ ᐎᓂᑐᑎᒫᓐ, ᐋᑖᔨᐦᑖᑯᓂᒀ ᒫᒃ ᒑ ᒌ ᓂᐱᐦᐄᑭᐎᔮᓐ ᐊᓐ ᐅᐦᒋ, ᑭᔨᑆ ᐹᒋᔥᑎᓂᓱᔮᓐ ᒑ ᒌ ᓂᐱᐦᐄᑭᐎᔮᓐ᙮ ᒥᒄ ᒫᒃ ᒥᔔ ᐋᑳ ᑎᔮᑆᐙᒀ ᐅᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᔑᒥᒡ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᐄᑖᔨᐦᑖᑯᓐ ᐐᔨᐙᐤ ᐋᐦ ᑖᒡ ᒑ ᒌ ᐄᔑ ᐱᒋᔅᑎᓂᑯᐎᒡ ᐊᓂᑎᐦ ᐐᔨ ᐐᔓᐙᐎᓂᒡ᙮ ᓰᓯᕐ ᐋᐦ ᑖᑦ ᐋᑯᑖᐦ ᓈᑎᐙᔨᐦᑎᒫᓐ ᒑ ᒌ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","ᕓᔅᑐᔅ ᒫᒃ, ᐱᑎᒫ ᒌ ᐊᔨᒥᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳ ᐐᑎᐱᒥᑯᑦ ᐋ ᒫᒨᐱᒡ᙮ ᐋᒄ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᒋᒌ ᓂᑎᐙᔨᐦᑖᓐ ᓈᑖᐦ ᒥᔅᑖ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐋᐦ ᑖᑦ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᐎᔨᓐ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᐄᑎᔓᐦᐅᑖᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ᐹᑎᒫ ᒫᒃ ᒦᓐ ᑯᑎᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᑭᔮᐦ ᐐᒋᔖᓂᔅᒀᒻ ᐯᕐᓃᔅ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᒌ ᐹᒋ ᑎᑯᔑᓂᒡ ᐊᓂᑖᐦ ᓭᓵᕆᔮᐦᒡ᙮ ᒋᐐᐦ ᐹᒋ ᓂᑎᐙᒋᔮᒫᐅᒡ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᕓᔅᑐᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ᓈᐅᔖᔥ ᒫᒃ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ᙮ ᐋᒄ ᕓᔅᑐᔅ ᑳᐦ ᐋᔨᒨᑎᒧᐙᑦ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᑖᓐ ᑳ ᐐᐦ ᑐᑎᐙᑭᓂᐐᒡ ᑆᓪ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, “ᐋᔥᒄ ᐙᔥ ᐋᑯᑖᐦ ᐋᐦ ᑖᑦ ᐹᔨᒄ ᓈᐹᐤ ᐋ ᒌ ᒋᐳᐦᐙᑭᓅᑦ ᒫᒀᒡ ᕖᓕᒃᔅ ᑳ ᒋᐦᒋᐅᒋᒫᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐄᑐᐦᑖᔮᓐ ᒋᕉᓯᓕᒥᐦᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᑭᔮᐦ ᐊᓂᒌ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᒡ ᒌᐦ ᑎᑯᓂᔨᐤ ᓂᓈᐦᑭᐤ ᐋ ᐄᔑ ᐹᒋ ᒫᒥᔑᒫᒡ ᐊᓂᔮᔨᐤ ᑆᓪ᙮ ᓲᐦᒃ ᒫᒃ ᒋᐐᐦ ᐅᐦᑎᓂᒧᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐄᑎᔓᐙᑎᒥᐦᒡ ᐎᔮᔥ ᒑ ᒌᐦ ᑐᑎᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","ᐋᒄ ᑳ ᐄᑎᒀᐤ, ᕎᒻ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᑐᐎᒡ ᒥᒄ ᒑ ᒌ ᐄᔑ ᐱᒋᔅᑎᓈᒡ ᐊᐙᔨᐤᐦ ᒑ ᑎᐹᔅᑯᓂᒫᑭᓂᐎᔨᒡ ᐋᔥᒄ ᐋᐦᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᒌ ᐙᐱᒫᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᒫᒥᔑᒥᑯᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒥᔮᑭᓅᑦ ᒑ ᒌ ᓈᑎᒫᓲᑦ ᐊᓐ ᐊᐙᓐ ᒫᒥᔑᒫᑭᓅᑦ ᐊᓂᑖᐦ ᑎᐹᔅᑯᓂᒑᓯᐤ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ᐄᔥᐱᐦ ᒫᒃ ᑖᑯᔑᐦᒡ ᐅᑎᐦ, ᑏᐙᐦᒡ ᓂᒌ ᐐᐦ ᓂᓂᐦᐄᐱᔨᐦᑎᐙᓐ ᒑ ᒌ ᑎᐹᔅᑯᓂᒫᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑆᓪ᙮ ᐊᓐ ᐎᔮᐱᐦᒡ ᓂᒌᐦ ᐄᑐᐦᑖᓐ ᑎᐹᔅᑯᓂᒑᐅᑭᒥᑯᐦᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐅᐙᔨᐱᔮᓐ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᔮᓐ ᒑ ᒌ ᐹᒋ ᐲᐦᑎᑭᐦᐋᑭᓅᑦ ᐊᓐ ᑳ ᐐᐦ ᑎᐹᔅᑯᓈᑭᓅᑦ, ᐋᐅᒄ ᐆ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","ᑳ ᐃᑖᔨᐦᑎᒫᓐ ᒑ ᒌ ᐊᑖᒫᔩᒫᔨᒫᒡ ᒋᐦᒋᐙᐦ ᐋᐦ ᒋ ᐎᓂᑑᑎᒥᔨᒡ ᑆᓪᐦ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐅᐦᒋ ᐄᔑ ᐊᑖᒫᔨᒫᐅᒡ ᐊᓂᔮᔨᐤ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᒥᔨᒡ ᑆᓪ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᑳᐦ ᐋᔨᒨᑎᐦᒡ ᐋᐦᐋᑳ ᓂᐦᐋᐤ ᐐᔨᐙᐤ ᐄᔑ ᑖᑆᐦᑎᐦᒡ ᐋ ᐄᔑ ᐙᐐᐦᑎᒥᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᓈᐹᐤ ᒌᓴᔅᐦ ᐋ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒥᒄ ᒫᒃ ᑆᓪ ᐋ ᒌ ᐄᔨᔨᒡ ᐋ ᐱᒫᑎᓰᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","ᐋᒄ ᒫᒃ ᓃᔨ ᐋᐦᐋᑳ ᑭᔨᑆ ᓈᔥᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᑳᐦ ᐋᔨᒸᐅᐦᐄᑯᒡ, ᓂᒌ ᑯᒀᒋᒫᐤ ᑆᓪ ᐙᐦ ᐄᑐᐦᑖᒀ ᒋᕉᓯᓕᒥᐦᒡ ᒑ ᒌ ᑎᐹᔅᑯᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","ᒌ ᓂᑎᐙᔨᐦᑎᒻ ᒫᒃ ᐊᔮᐱᒡ ᐊᓂᑎᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᒑ ᒌ ᑭᓂᐙᔨᒫᑭᓅᑦ ᐱᑎᒫ᙮ ᓰᓯᕐ ᒌ ᓂᑎᐙᔨᒫᐤ ᒑ ᒌ ᐎᔮᔨᐦᑎᒥᔨᒡ ᑖᓐ ᒑ ᑐᑎᐙᑭᓅᑦ᙮ ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᔓᐙᐅᒡ ᐊᓂᑖᐦ ᒋᐱᐦᐅᑑᑭᒥᑯᐦᒡ ᐱᑎᒫ ᒑ ᒌ ᑭᓂᐙᔨᒫᑭᓅᑦ ᐹᑎᔥ ᒌ ᐄᑎᔓᐦᐅᑳ ᓈᑖᐦ ᓰᓯᕐ ᐋᐦ ᑖᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᕓᔅᑐᔅ, “ᓂᐐ ᓂᑐᐦᑎᐙᐤ ᑭᔮᐦ ᓃᔨ ᐆ ᓈᐹᐤ᙮” ᐋᒄ ᕓᔅᑐᔅ ᑳᐦ ᐄᑖᑦ, “ᐋᑯᑖᐦ᙮ ᐙᐱᐦᒑ ᒋᑭ ᒌ ᓂᑐᐦᑎᐙᐤ ᑖᓐ ᒑ ᐃᔨᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ᒦᓐ ᒫᒃ ᐊᓂᔮᔨᐤ ᐎᔮᐱᓃᔨᒡ ᐋᒃᕆᐹ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᔖᓂᔅᒀᒻ ᐯᕐᓃᔅ ᒌ ᑎᑯᔑᓂᒡ ᐊᓂᑖᐦ ᒑ ᐋᔨᒥᓈᓂᐎᔨᒡ᙮ ᒌ ᐹᒋ ᐐᒑᐅᑯᒡ ᓂᑐᐱᔫᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐄᔨᔨᐤ ᐊᓂᑎᐦ ᐃᐦᑖᐎᓂᐦᒡ᙮ ᓈᔥᒡ ᒌ ᒥᔻᔥᐱᓯᐎᒡ ᐄᔥᐱᐦ ᐱᔮᒋ ᐲᐦᒑᒡ ᑭᔮᐦ ᓈᔥᒡ ᔮᒀᐦ ᒌᐦ ᑎᓈᓂᐤ ᐊᓐ ᐋ ᐹᒋ ᐲᐦᒑᓅᐦᒡ ᐋ ᐃᔥᐱᔥ ᒋᔥᑖᔨᒫᑭᓂᐎᒡ ᐊᓂᒌ ᐋᒃᕆᐹ ᑭᔮᐦ ᐯᕐᓃᔅ᙮ ᐋᒄ ᒋᐦᒋᐅᒋᒫᐤ ᕓᔅᑐᔅ ᑳᐦ ᐄᑎᔓᐙᑦ ᑆᓪ ᒑ ᒌ ᐹᒋ ᐲᐦᑎᑭᐦᐄᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐹᒋ ᐲᐦᑎᑭᐦᐄᒫᑭᓂᐎᔨᒡ ᐋᒄ ᑳ ᐊᔨᒥᑦ ᕓᔅᑐᔅ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᑳ ᓂᔥᑐᐐᓈᓂᐎᔨᒡ᙮ ᐋᒄ ᑳᐦ ᐃᔨᑦ, “ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᑭᔮᐦ ᒥᓯᐙ ᒌᔨᐙᐤ ᐅᑎᐦ ᑳᐦ ᑖᔮᒄ, ᒌ ᐙᐱᒫᐙᐤ ᐆ ᓈᐹᐤ ᑳ ᐹᒋ ᐲᐦᑎᑭᐦᐋᑭᓅᑦ᙮ ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤ ᓈᐹᐤ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᑳᐦ ᑖᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᐊᑖᒫᔨᒫᒡ᙮ ᐙᐙᒡ ᒌ ᐋᓯᐦᒀᐅᒡ ᐋᐦ ᐃᔨᒡ ᐋᐦᐋᑳ ᐙᐙᒡ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","ᓂᒧᐃ ᒫᒃ ᓃᔨ ᐐᐦ ᓅᐦᒋ ᒥᔅᑭᒸᓐ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒥᔨᒀᓂᐦᐄ ᒑ ᒌ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐐᔨ ᐆ ᓈᐹᐤ ᒌ ᓂᑎᐙᔨᐦᑎᒻ ᓈᑖᐦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓈᑭᓅᑦ᙮ ᐋᒄ ᒫᒃ ᑳ ᐎᔮᔨᐦᑎᒧᒡ ᓈᑖᐦ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᐄᑎᔑᐦᐅᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","ᐋᒄ ᒥᒄ ᓂᒧᐃ ᓂᐦᐋᐤ ᓂᒋᔅᒑᔨᐦᑎᒸᓐ ᑖᓐ ᒑ ᐄᑎᔥᑖᐅᒡ ᐋ ᒥᓯᓂᐦᐋᒫᒥᒡ ᓰᓯᕐ ᐋ ᑎᐹᒋᒥᒃ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐹᔔᒃ ᐅᑎᐦ ᐋᐦ ᑖᔨᓐ ᒌ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᑭᔮᐦ ᒫᒃ ᒌᔨᐙᐤ ᒥᓯᐙ ᐅᑎᐦ ᑳᐦ ᑖᔮᒄ᙮ ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᒌ ᒥᔅᑭᒧᒀ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑐᑎᐦᒃ, ᐋᒄ ᒑ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᒑ ᐄᑎᔥᑖᐅᒡ ᒥᓯᓂᐦᐋᒫᒥᒑ ᓰᓯᕐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","ᐙᔖ ᑖᓐ ᒑ ᐃᓯᓈᑯᐦᒡ ᐄᑎᔓᐦᐅᑳ ᓈᑖᐦ ᐊᐙᓐ ᐋ ᒌ ᐅᑎᓈᑭᓅᑦ ᐋᑳ ᒫᒃ ᐙᐙᒡ ᑎᑯᓃᔨᒑ ᑖᓐ ᒑ ᒌ ᐄᔑ ᒥᓯᓂᐦᐋᒧᒡ ᐋ ᒌ ᐄᔑ ᒥᒋᐦᑐᑎᐦᒃ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","ᐋᒄ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᐋᒄ ᐹᒋᔥᑎᓂᑭᐎᔨᓐ ᒑ ᒌ ᐋᔨᒥᔥᑎᒫᓱᔨᓐ᙮” ᐋᒄ ᑆᓪ ᑳ ᔑᐎᓂᔅᒑᔨᑦ ᐄᔥᐱᐦ ᒑ ᐊᔨᒦᔥᑎᒫᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, “ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, ᓂᔑᐙᔨᐦᑖᑯᓯᓐ ᓂᑎᐄᑖᔨᐦᑖᓐ ᐋ ᓂᐦᐄᐱᔨᐦᒡ ᐅᑎᐦ ᐋᐦ ᑖᔨᓐ ᒑ ᒌ ᐋᔨᒦᔥᑎᒫᓱᔮᓐ ᐅᐦᒋ ᒥᓯᐙ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᒡ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᒌᐦ ᑑᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ᐊᓐ ᓈᔥᒡ ᐋ ᒥᔪ ᒋᔅᒑᔨᐦᑎᒥᓐ ᒎᐤ ᐊᔨᑎᐎᓐ ᑭᔮᐦ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᐙᐦᒋ ᐎᔥᑖᐱᔨᔨᒡ ᒫᓐ ᒎᐤ ᐄᔨᔨᐅᒡ, ᐋᐅᒄ ᐙᐦᒋ ᓈᔥᒡ ᒥᔻᔨᐦᑎᒫᓐ ᐅᑎᐦ ᐋᐦ ᑖᔨᓐ ᒑ ᒌ ᐋᔨᒦᔥᑎᒫᓱᔮᓐ᙮ ᒋᓂᑐᑎᒫᑎᓐ ᒫᒃ ᒑ ᒌ ᓂᑐᐦᑎᐎᔨᓐ ᒑ ᐐᐦ ᓰᐱᔨᐙᓰᔅᑎᐎᔨᓐ ᑖᓐ ᒑ ᐄᔑ ᐊᔨᒥᔮᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ᒥᓯᐙ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᓐ ᑳ ᐄᔑ ᐹᒋ ᐱᒫᑎᓰᐎᒡ ᐊᓂᑖᐦ ᐙᒋᐦᒡ ᑳ ᐅᐦᒋᔮᓐ ᐃᔥᑯᑎᒃ ᑳ ᐹᒋ ᐊᐙᔑᐎᔮᓐ ᑭᔮᐦ ᒫᒃ ᒋᔅᒑᔨᐦᑖᑯᓐ ᑖᓐ ᑳ ᐄᑖᑎᓰᔮᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᑳᐦ ᑖᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ᒨᔥ ᒌ ᐹᒋ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ, ᐋ ᐹᕆᓰᐎᔮᓐ ᑭᔮᐦ ᓈᔥᒡ ᔮᒀᐦ ᐋ ᒌ ᐄᑖᔨᐦᑎᒧᒡ ᐹᕆᓰ ᐋᐦᑖᐅᒡ᙮ ᒋᐱᐦ ᒌ ᐐᐦᑎᒧᒡ ᑭᔮᐦ ᐐᐦ ᐐᐦᑎᐦᒡ ᐅᔮᔨᐤ᙮ ᐊᓂᒌ ᒫᒃ ᐹᕆᓰᒡ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᒫᐅᒡ ᔮᒀᐦ ᐋ ᐄᔑ ᓈᓈᑭᒋᐦᑖᒡ ᐅᔮᔨᐤ ᒎᐤ ᐐᔓᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","ᐊᓅᐦᒡ ᒫᒃ ᐆ ᑳ ᓃᐴᔮᓐ ᐅᑎᐦ, ᓂᑎᐹᔅᑯᓂᑭᐎᓐ ᒥᒄ ᐊᓐ ᐋ ᑖᑆᐦᑎᒫᓐ ᑖᑆᐦ ᒑ ᐄᔅᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᔨᑖᑯᐱᓈ ᒋᔖᒥᓂᑑ ᒋᑖᓂᔅᑰᓯᒥᓂᐤ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ᒥᓯᐙ ᒫᒃ ᑭᔮᐦ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ, ᐊᓂᔮᔨᐤ ᑳ ᓃᔓᔖᐳᔨᒡ ᒉᑭᑉ ᐅᑯᓯᔨᐤᐦ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒌᒡ, ᐋᔪᐎᒄ ᑭᔮᐦ ᐐᔨᐙᐤ ᐅᔮᔨᐤ ᐋ ᐊᔑᐙᐱᐦᑎᐦᒡ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐱᑯᓵᔨᒧᒡ ᐋ ᐊᔨᒥᐦᐋᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌᔑᑳᔨᒡ ᑭᔮᐦ ᐋ ᑎᐱᔅᑳᔨᒡ᙮ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᑖᑆᐦᑎᒧᒡ ᐙᐦᒋ ᐐᐦ ᐄᔑ ᒫᒥᔑᒥᒡ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","ᐋᒄ ᑳᐦ ᐄᑖᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ, ᒌᔨᐙᐤ ᒎᐄᔨᔨᐅᒡ, ᒑᒀᓐ ᐙᐦᒋ ᐋᑳ ᒌ ᑖᑆᐦᑎᒫᒄ ᒋᔖᒥᓂᑑ ᐋ ᐙᓂᔥᑳᓈᑦ ᐊᐙᔨᐤᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ?” ");
INSERT INTO crl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᓃᔨ ᑎᐱᔨᐙ ᒥᓯᐙ ᒑᒀᓐ ᓂᒌᐦᑐᑖᓐ ᒑ ᒌ ᓂᔅᑯᔅᑎᒫᓐ ᐊᓐ ᒥᔻᒋᒧᐎᓐ ᒌᓴᔅ ᓈᓵᕆᕠᐦᒡ ᑳ ᐅᐦᒌᑦ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ᐋᐅᒄ ᑳᐦ ᑎᔮᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ᙮ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ ᓂᒌ ᒥᔨᑯᒡ ᒑ ᒌ ᐅᑎᓂᒥᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᐦᑎᒥᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒋᐱᐦᐅᒫᑭᓂᐎᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᐄᑎᔓᐙᑖᑭᓅᑣᐙ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ, ᐋᐅᒄ ᑳ ᐄᔑ ᓂᔅᑯᒧᔮᓐ ᑭᔮᐦ ᓃᔨ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ᒥᐦᒑᑣᐤ ᑭᔮᐦ ᓃᔨ ᓂᒌᐦ ᑐᑎᐙᐅᒡ ᒑ ᒌ ᐎᔮᔅᑐᑎᐙᑭᓂᐎᒡ ᐊᓂᑖᐦ ᒎᐤ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ, ᑭᔮᐦ ᓂᒌ ᐐᐦ ᑐᑎᐙᐅᒡ ᒑ ᒌ ᒫᔮᔨᒫᒡ ᒌᓴᔅᐦ᙮ ᓈᔥᑖᑆᐦ ᒨᔥ ᓂᒌ ᒋᔑᐙᐦᐄᑯᒡ, ᐙᐙᒡ ᐊᓂᑖᐦ ᒫᓂᑖᐤ ᐃᐦᑖᐎᓂᐦᒡ ᓂᒌᐦ ᐄᑐᐦᑖᐙᓐ ᐋ ᓂᑑᓂᓈᐦᑳᒋᐦᐄᒀᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ᐹᔨᒀᐤ ᒫᒃ ᒫᒀᒡ ᒦᓐ ᐆ ᐋᐦ ᐄᑖᐱᑎᓰᔮᓐ, ᐊᓂᑖᐦ ᑖᒫᔅᑭᓯᒡ ᓂᒌᐦ ᐄᑎᔓᐦᐅᑯᒡ ᐊᓂᒌ ᑳ ᓃᑳᓂᔒᒡ ᐊᔨᒥᐦᐋᐅᒋᒫᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᔨᓐ ᒋᐦᒋᐅᒋᒫᐤ, ᒫᒀᒡ ᒫᔅᑭᓈᐦᒡ ᐋᐦ ᑖᔮᐦᒡ, ᐎᔮᔥ ᐋᐦ ᐋᐱᐦᑖᒌᔑᑳᒡ, ᓂᒌᐙᐱᐦᑖᓐ ᐙᔥᑖᐎᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ ᐙᔅᑳ ᐊᓂᑎᐦ ᐋᐦ ᑖᔮᓐ ᑭᔮᐦ ᐙᔅᑳ ᐊᓂᒌ ᓈᐹᐅᒡ ᑳ ᐐᒑᐅᒡ ᐋᐦ ᑖᒡ᙮ ᐊᐅᔅᑖ ᒌ ᒌᐦᑳᔮᔥᑖᐤ ᐋᑎ ᐋ ᐃᔥᐱᔥ ᒌᐦᑳᔮᔥᑐᐙᑦ ᐲᓯᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","ᒥᓯᐙ ᒫᒃ ᓂᒌ ᐱᐦᒋᔑᓈᓐ, ᐋᒄ ᑳ ᐹᐦᑎᐎᒃ ᐊᐙᓐ ᐦᐄᑉᕉ ᐋ ᐄᔑ ᐊᔨᒥᑦ ᐋ ᐹᒋ ᐄᔑᑦ, ‘ᔂᓪ, ᔂᓪ ᒑᒀᓐ ᐙᐦᒋ ᓂᓈᐦᑳᒋᐦᐄᔨᓐ? ᑖᑆᐦ ᓈᔅᑏᔨᔅ ᒑᒀᓐ ᑭᑎ ᐃᓯᓈᑯᓐ, ᐋ ᓂᔅᑯᔅᑎᒥᓐ ᓂᑎᐄᑖᔨᐦᑎᒧᐎᓐ᙮ ᒌᔨ ᑎᐱᔨᐙ ᒋᑎ ᐋᐦᑯᐦᐄᓱᓐ ᐋᑦ ᓃᔨ ᐋ ᐐᐦ ᐹᒋ ᐋᐦᑯᐦᐄᔨᓐ᙮’ ");
INSERT INTO crl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","ᐋᒄ ᑳ ᐃᔮᓐ, ‘ᐊᐙᓐ ᒌᔨ, ᐅᑎᐹᔨᐦᒋᒑᐤ?’ ᐋᒄ ᑳ ᐹᒋ ᐄᔑᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, ‘ᐋᐅᒄ ᓃᔨ ᒌᓴᔅ ᐊᓐ ᐊᐙᓐ ᑳ ᓂᓈᐦᑳᒋᐦᐄᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","ᐱᓯᑰᐦ ᒫᒃ᙮ ᐆ ᐙᒋ ᓅᑯᓰᔥᑖᑖᓐ ᒌ ᓂᑎᐙᔨᒥᑎᓐ ᒑ ᒌ ᐋᐱᑎᓰᔥᑎᒧᐎᔨᓐ᙮ ᒌ ᓂᑎᐙᔨᒥᑎᓐ ᒑ ᒌ ᐐᐦᑎᒧᑣᐤ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐙᐱᐦᑎᔨᑖᓐ ᐊᓅᐦᒡ ᑭᔮᐦ ᑖᓐ ᒑ ᐄᔑ ᐙᐱᐦᑎᔨᑖᓐ ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ᓃᔨ ᒋᑭ ᑭᓂᐙᔨᒥᑎᓐ ᑖᔨᓈ ᐊᓂᑖᐦ ᒑ ᐄᑎᔓᐦᐅᑖᓐ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ ᑭᔮᐦ ᐊᓂᑖᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ᒋᑎ ᐃᑎᔑᐦᐅᑎᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᒡ ᒑ ᒌ ᓂᔅᑐᐦᑎᒥᐦᐄᑣᐤ ᑖᓐ ᐋ ᐃᓯᓈᑯᓃᔨᔨᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐤ᙮ ᒋᔅᒑᔨᐦᑎᐦᒀᐙ ᒫᒃ ᐋᒄ ᒑ ᓂᑭᑎᐦᒡ ᐊᐅᑳᔥᑖᔮᐎᓂᔨᐤ ᐋᒄ ᐙᔥᑖᐎᓂᔨᐤ ᒑ ᓈᑎᐦᒡ᙮ ᑭᔮᐦ ᒫᒃ ᒑ ᓂᑭᑎᒸᒡ ᒥᒋᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᐊᐅᔅᑖ ᒋᔖᒥᓂᑑ ᐅᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᒑ ᒌ ᓈᑎᒸᒡ᙮ ᐋᒄ ᒫᒃ ᑖᑆᔮᔨᒥᑣᐙ ᒑ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᒥᓯᓈᓱᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐊᓂᑖᐦ ᒫᓯᓈᓱᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑏᔨᔨᒥᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“ᐋᒄ ᒫᒃ ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, ᓂᒌ ᓂᓂᐦᐄᐦᑖᓐ ᐆ ᑳᐦ ᐄᑎᔓᒥᑭᐎᔮᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","ᐊᓂᑖᐦ ᒫᒃ ᑖᒫᔅᑭᓯᒡ ᓃᔥᑎᒻ, ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ, ᐋᒄ ᒦᓐ ᒥᓯᐙ ᐊᓂᑖᐦ ᐃᐦᑖᐎᓐ ᒎᑏᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᑭᔮᐦ ᒫᒃ ᐊᓂᑖᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐋᐦ ᑖᒡ ᓂᒌ ᐱᐹᑭᒑᔅᒀᓐ ᐋᐦ ᐄᑎᒀᐤ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᒀᔅᑳᑎᓰᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ, ᑭᔮᐦ ᒫᒃ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᒑᒀᔨᐤ ᐊᓂᑎᐦ ᒑ ᒌ ᐅᐦᒋ ᓅᑯᓃᔨᒡ ᑖᑆᐦ ᐋ ᒀᔅᑳᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐅᐦᒋ ᑳ ᑑᐎᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᐹᒋ ᐅᑎᓂᒡ ᒫᒀᒡ ᐊᓂᑖᐦ ᒋᔖᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᐋᐦᑖᐅᒡ, ᐋᒄ ᑳ ᐐᐦ ᐹᒋ ᓂᐱᐦᐄᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒨᔥ ᓂᒌ ᐹᒋ ᐐᒋᐦᐄᒄ, ᐋᐅᒄ ᐙᐦᒋ ᓃᐴᔮᓐ ᐅᑎᐦ ᐊᓅᐦᒡ ᐋ ᐙᐐᐦᑎᒨᒀᐤ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐋ ᒌᔅᑎᒫᑎᔒᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᒦᔒᒋᔒᒡ, ᐋ ᑖᑆᔮᓐ ᒥᓯᐙ ᑖᓐ ᐋ ᐄᔑ ᐙᐐᐦᑎᒫᓐ ᐋᐦᐋᑦ ᐋᐱᓵᔑᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᒥᓵᒡ᙮ ᐊᓐ ᒫᒃ ᐋ ᐄᔑ ᐙᐐᐦᑎᒫᓐ ᐋᔪᐎᒄ ᒧᔮᒻ ᑳ ᐄᔑ ᐙᐐᐦᑎᒧᐙᐙᑯᐱᓈ ᑭᔮᐦ ᐐᔨᐙᐤ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᑭᔮᐦ ᐊᓂᔮ ᒧᓱᔅ ᒑ ᐄᔅᐱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","ᐆ ᑳ ᐄᔑ ᐋᔨᒸᐅᐦᐄᐙᑯᐱᓈ ᐋᐅᒄ ᐆ ᙭ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ ᒑᔥᑎᓈᔥ ᒑ ᓂᓈᐦᑳᒋᐦᐋᑭᓅᑦ, ᑭᔮᐦ ᐐᔨ ᓃᔥᑎᒻ ᒑ ᐎᓂᔥᑳᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᒑ ᒌ ᐋᔨᒨᑎᒧᐙᑦ ᒎᐄᔨᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐙᔥᑖᐎᓂᐦᒡ ᐊᓂᑎᐦ ᐋᐦᑎᑯᐦᒡ ᐱᒫᒋᐦᐄᑯᓯᐎᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ᒫᒀᒡ ᒫᒃ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᐊᔨᒥᑦ ᑆᓪ, ᕓᔅᑐᔅ ᒌ ᐋᓯᐦᒀᑎᑰ ᐋᐦ ᐄᑎᑯᑦ, “ᑆᓪ, ᒌ ᒋᒌᔥᒀᓐ᙮ ᐊᓐ ᑳ ᐃᔥᐱᔥ ᒥᔥᑎᐦ ᒋᔅᑯᑎᒫᑭᐎᔨᓐ ᒌ ᒋᒌᔥᒀᐦᐄᑯᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","ᐋᒄ ᑆᓪ ᑳ ᓂᔥᒀᐅᔑᐦᐋᑦ ᐋᐦ ᐄᑖᑦ, “ᓂᒧᐃ ᓂᒌᔥᒀᓐ, ᕓᔅᑐᔅ ᒫᐅᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓯᔨᓐ᙮ ᓂᑖᑆᓐ ᑯᐃᔅᒄ ᐊᓐ ᑳ ᐄᔑ ᐐᐦᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, ᒋᑭ ᒌ ᐋᔨᒨᑎᒫᑎᓐ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᐋᐦᐋᑳ ᑯᔥᑖᒋᔮᓐ ᐙᔥ ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐊᓐ ᐃᔮᔨᒧᑎᒫᓐ᙮ ᓂᒧᐃ ᒌᒧᒡ ᐅᐦᒋ ᐄᔅᐱᔨᐤ ᐅᐦᐄ ᒑᒀᓂᐦᐄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ᒋᐦᒋᐅᒋᒫᐤ ᐋᒃᕆᐹ, ᒌ ᑖᑆᐦᑎᒸᓈ ᐋ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒨᑎᐦᒡ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ? ᒌ ᒋᔅᒑᔨᒥᑎᓐ ᐋ ᑖᑆᐦᑎᒧᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","ᐋᒄ ᐋᒃᕆᐹ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᑆᓪ, “ᐆ ᐃᔥᐱᔥ ᐙᐃᐱᔥᒌᔥ, ᒋᑎᐄᑖᔨᐦᑖᓐ ᐋ ᔖᔥ ᒑ ᒌ ᔑᐦᑰᒋᒦᓐ ᒑ ᒌ ᑖᑆᔮᔨᒫᒄ ᙭?” ");
INSERT INTO crl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ, “ᐙᐃᐱᔥᒌᔥ ᑭᔮᐦ ᒫᒃ ᓈᐅᔥ ᒑ ᐃᔥᐱᔒᐦᑳᓲᒥᑭᓂᒀ, ᓂᐱᑯᓵᔨᒫᐤ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐃᓯᓈᑯᐦᐄᑖᒄ ᑭᔮᐦ ᒌᔨᐙᐤ ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᑳ ᓂᑐᐦᑎᐦᒡ ᒧᔮᒻ ᓃᔨ ᑳ ᐃᓯᓈᑯᓯᔮᓐ᙮ ᓂᒧᐃ ᑭᔨᑆ ᐊᔨᔮᓐ ᒑ ᒌ ᒥᒫᒋᒀᐱᔅᑭᐦᐅᑯᔮᒄ ᐱᔻᐱᔅᒀᔮᐲ ᒧᔮᒻ ᓃᔨ ᐋᔑᓈᑯᓯᔮᓐ ᐊᓅᐦᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","ᐋᒄ ᐊᓐ ᒋᐦᒋᐅᒋᒫᐤ, ᑭᔮᐦ ᐊᓐ ᒋᔖᒋᐦᒋᐅᒋᒫᐤ, ᑭᔮᐦ ᐯᕐᓃᔅ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᐐᑎᐱᒥᑯᒡ ᒌ ᐱᓯᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ᐄᔥᐱᐦ ᑳ ᐎᔨᐐᒡ ᐋᒄ ᑳᐦ ᐄᑎᑐᒡ, “ᓂᒧᐃ ᒑᒀᔨᐤ ᐅᐦᒋ ᑐᑎᒻ ᐆ ᓈᐹᐤ ᒑ ᒌ ᐅᐦᒋ ᐅᑎᓈᑭᓅᑦ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᓂᐱᐦᐋᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","ᐋᒄ ᐋᒃᕆᐹ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨ ᕓᔅᑐᔅ, “ᒥᑐᓐ ᒋᐱᐦ ᒌ ᐱᒋᔅᑎᓈᑭᓂᐤ ᐆ ᓈᐹᐤ ᑆᓪ, ᒥᒄ ᒫᒃ ᐐᐦ ᐋ ᒌ ᐃᔨᑦ ᒑ ᒌ ᐄᑎᔑᐦᐙᑭᓄᑦ ᐊᓂᑖᐦ ᓰᓯᕐ ᐋᐦ ᑖᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓈᑭᓅᑦ, ᐋᔪᐎᒄ ᒑ ᑐᑎᐙᑭᓅᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐎᔮᔨᐦᑖᑭᓂᐎᒡ ᐃᑎᓖ ᒑ ᐃᔅᒋᒫᔮᐦᒡ, ᐹᔨᒄ ᓂᑐᐱᔨᐅᒋᒫᐤ ᒍᓕᔪᔅ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᒌ ᐄᑎᔓᒫᑭᓂᐤ ᒑ ᒌ ᓈᓈᑭᒋᐦᐋᑦ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᑳ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ᙮ ᐆ ᒫᒃ ᒍᓕᔪᔅ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒌ ᑎᔑᔨᐤ ᓂᑐᐱᔨᐤ ᐋ ᓃᑳᓂᔥᑭᐙᑦ ᕎᒻ ᐋ ᐄᔑ ᒥᓯᓈᓱᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ᐋᒄ ᑳ ᐴᓯᔮᐦᒡ ᒌᒫᓐ ᐊᓂᑖᐦ ᐋᑦᕌᒥᑎᔪᒻ ᐋ ᐅᐦᒋᐱᔨᐦᒡ᙮ ᔖᔥ ᒌ ᐃᔮᔅᑭᐎᑐᑖᑭᓂᐤ ᐊᓂᑖᐦ ᐋᐃᔖ ᐊᔅᒌᐦᒡ ᒑ ᒌ ᐄᔅᐱᔨᔨᒡ, ᐋᑯᑖᐦ ᒫᒃ ᑳ ᐄᔑ ᒋᔥᑖᔑᔮᐦᒡ᙮ ᐊᕆᔅᑖᕐᑭᔅ ᒫᒃ ᐋ ᐃᔑᓂᐦᑳᓱᑦ ᓈᐹᐤ ᐊᓂᑖᐦ ᒫᓯᑐᓂᔮ ᐊᔅᒌᐦᒡ ᐊᓂᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᕞᓵᓨᓈᐃᑳ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐋ ᒌ ᐅᐦᒌᑦ ᐋᐅᒄ ᐆ ᑭᔮᐦ ᑳᐦ ᒌᒥᔨᒥᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ᐊᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᓵᐃᑎᓂᐦᒡ ᓂᒌ ᒥᔑᑳᓈᓐ᙮ ᒌ ᒥᔪᑐᑎᐙᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᑆᓪ ᐊᓐ ᓂᑐᐱᔨᐅᒋᒫᐤ ᒍᓕᔪᔅ᙮ ᒌ ᐱᒋᔅᑎᓈᐤ ᐱᑦ ᒑ ᒌ ᑭᐹᔨᒡ ᒑ ᒌ ᓂᑎᐙᐱᒫᔨᒡ ᐅᐐᒑᐙᑭᓂᔨᐤ, ᑭᔮᐦ ᒑ ᒌ ᒥᔮᑭᓂᐎᔨᒡ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","ᐊᓂᑎᐦ ᒫᒃ ᓵᐃᑎᓂᐦᒡ ᐋᑯᑖᐦ ᒦᓐ ᑳ ᐅᐦᒋ ᐴᓯᔮᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᐋ ᒌ ᓂᑳᔮᓯᔮᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᐋ ᑎᐱᓂᐙᒡ ᐊᓐ ᒥᓂᔥᑎᒄ ᓵᐃᑉᕋᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐋᑯᑖᐦ ᑳ ᐄᑖᔥᑎᒥᓱᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","ᐋᒄ ᐊᓂᑖᐦ ᑳ ᐄᔑ ᐋᔔᐦᐊᒫᐦᒡ ᐊᓐ ᒋᐦᒋᑭᒦ ᑳᐦ ᐋᑎ ᐃᔮᔨᐱᔮᐦᒡ ᐊᓂᔮᔨᐤ ᐊᔅᒌ ᓯᓕᓯᔮ ᑭᔮᐦ ᐹᒻᕕᓕᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ, ᐋᒄ ᐊᓐ ᒫᐃᕋ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐊᓂᑖᐦ ᓚᐃᓯᔮ ᐊᔅᒌᐦᒡ ᑳᐦ ᑎᑯᐦᒡ ᐋᑯᑖᐦ ᑳ ᒥᔑᑳᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ᐅᑎᐦ ᒫᒃ ᐅᔮᔨᐤ ᐃᐦᑖᐎᓂᔨᐤ ᐋᑯᑖᐦ ᑳ ᒥᔅᑭᐦᒃ ᐊᓐ ᓂᑐᐱᔨᐅᒋᒫᐤ ᒌᒫᓂᔨᐤ ᐊᓂᑖᐦ ᐋᓕᒃᓵᓐᑦᕆᔮ ᐋ ᐅᐦᒌᒥᑭᓃᔨᒡ, ᐊᓂᑖᐦ ᐃᑎᓖ ᐋᐦ ᐄᔅᐱᔨᔨᒡ, ᐋᑯᑖᐦ ᒫᒃ ᐊᓂᑎᐦ ᑳ ᐴᓯᐦᐄᑭᐎᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐹᐦᑳᒡ ᒥᒄ ᓂᒌ ᐱᒫᔥᑎᒦᓱᓈᓐ, ᓂᒌᐦ ᐋᔨᒥᐦᐅᓈᓐ ᐋ ᐐᐦ ᒥᔑᑳᔮᐦᒡ ᐊᓂᑖᐦ ᐊᓐ ᓯᓈᐃᑎᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ, ᐋᑯᑖᐦ ᓂᐦᐋᐤ ᑳ ᐅᐦᑎᐦᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓐ ᐊᓂᑖᐦ ᐋ ᐅᐦᑎᐦᒡ, ᐃᔨᐦᒡ ᑳ ᐄᑖᔥᑎᒥᓱᔮᐦᒡ᙮ ᐊᓂᑖᐦ ᐋ ᑎᐱᓂᐙᒡ ᐊᓐ ᒥᓂᔥᑎᒄ ᒃᕇᑦ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐋᑯᑖᐦ ᑳ ᐄᑖᔑᔮᐦᒡ, ᑳᐦ ᐋᑎ ᔮᐃᐦᐄᒫᐦᒡ ᐊᓐ ᑳ ᒥᒋᔥᑖᐙᔮᐱᔅᑳᒡ ᓵᓪᒧᓂ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ᐃᔮᐱᒡ ᓂᒌ ᐋᔨᒥᐦᐅᓈᓐ ᐋᑦ ᒥᒄ ᐋ ᔮᔮᐅᐦᐊᒫᐦᒡ᙮ ᒥᒄ ᓈᐅᔅ ᐊᔮᐱᒡ ᓂᒌ ᒥᔑᑳᓈᓐ ᐊᓂᑖᐦ ᐊᓐ ᐋ ᒥᔻᒡ ᐋ ᐊᑯᐦᑖᑭᓂᐎᒡ ᒌᒫᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ, ᓂᒧᐃ ᐙᐦᔨᐤ ᐊᓂᑎᐦ ᐊᓐ ᐃᐦᑖᐎᓐ ᓚᓯᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᓂᒌᐦᑖᓈᓐ ᐊᓂᑎᐦ ᑳ ᐃᔥᐱᔥ ᒥᒋᒌᔑᑳᒡ᙮ ᒑᒃ ᑳ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐊᓂᑎᐦ ᐋ ᑯᔥᑖᑎᑯᐦᒡ ᒑ ᒌ ᐴᓯᓈᓂᐎᒡ, ᔖᔥ ᐋ ᑎᒀᒋᐦᒡ ᔖᔥ ᐋ ᒌ ᒥᔮᐎᐱᔨᒡ ᐊᓐ ᐋᒋᔑᑳᒡ ᐋᐦᐋᑳ ᒥᒋᓲᓈᓅᐦᒡ᙮ ᐋᒄ ᑆᓪ ᑳ ᐃᔮᒀᒥᒫᑦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᑳᐦ ᑖᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ, ");
INSERT INTO crl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ᓂᐙᐱᐦᑖᓐ ᑖᓐ ᒑ ᐄᔑ ᑯᔥᑖᑎᑯᐦᒡ ᒦᓐ ᐴᓯᐦᔨᒀᐤ᙮ ᒋᑭ ᒌ ᐎᓂᐦᑖᓈᓂᐤ ᒑᒀᓂᐦᐄ ᑭᔮᐦ ᒫᒃ ᐆ ᒌᒫᓐ᙮ ᐙᐙᒡ ᑭᔮᐦ ᒋᑭ ᒌ ᐃᔮᔪᐦᐆᓈᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","ᐋᒄ ᒥᒄ ᐊᓐ ᓂᑐᐱᔨᐅᒋᒫᐤ ᐊᐅᔅᑖ ᐊᓂᔮᔨᐤ ᒌᒫᓂᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᑳ ᑎᐱᔨᐙᐅᓰᔨᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ ᒌ ᓂᑐᐦᑎᐙᐤ ᑖᓐ ᑳ ᐄᔨᔨᒡ, ᐋᒄ ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐱᓯᐦᑎᐙᐤ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᑆᓪ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","ᑭᔮᐦ ᒫᒃ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐋ ᐊᑯᐦᑎᓃᔨᒡ ᒌᒫᓂᔨᐤ ᑳᐦ ᑖᒡ, ᓂᒧᐃ ᓈᔥᒡ ᐅᐦᒋ ᒥᔻᔨᐤ ᐋ ᐱᐳᓃᔨᒡ ᐐᔨ ᒑ ᒌ ᐊᑯᐦᑎᓃᔨᒡ ᒌᒫᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐋᔨᐤᐦ ᒑᑳᑦ ᒥᓯᐙ ᐊᓂᒌ ᓈᐹᐅᒡ ᒋᐐᐦ ᐴᓯᐎᒡ, ᐊᓂᑖᐦ ᐋ ᐱᑰᓵᔨᐦᑖᐦᒡ ᒑ ᒌ ᐅᑎᐦᑎᐦᐊᒡ ᐊᓂᔮᔨᐤ ᕖᓂᑭᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᐋᐦᐋᑳ ᐙᐦᔨᐤ ᐅᐦᒋ ᑎᑯᓃᔨᒡ ᐊᓂᑎᐦ ᐋᔮᔮᐙᔮᔨᒡ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᒡ ᐊᓂᑎᐦ ᒥᓂᔥᑎᒄ ᒃᕇᑦ, ᒑ ᒌ ᐱᐳᓂᐦᑖᒡ ᐊᓂᑖᐦ᙮ ᒌ ᒥᔻᔑᐤ ᐊᓂᑎᐦ ᐋ ᓂᐦᐋᐅᔅᑖᑭᓂᐎᒡ ᒌᒫᓐ ᐋ ᐱᐳᐦᒡ᙮ ᐆ ᒫᒃ ᐃᐦᑖᐎᓐ ᐄᑑ ᐊᓂᑖᐦ ᐄᔑ ᐲᓯᒸᑖᐦᒡ ᑭᔮᐦ ᒌᐙᑎᓂᐦᒡ ᒌ ᐄᔑ ᓅᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","ᐄᔥᐱᐦ ᒫᒃ ᒑᐦᒋᔅᑎᓃᒡ, ᐊᓂᑖᐦ ᐲᓯᒸᑖᐦᒡ ᐋ ᐅᐦᒋ ᔪᐙᒡ, ᐋᒄ ᑳ ᐄᑖᔨᐦᑎᐦᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᒦᓐ ᒑ ᒌ ᒋᔥᑖᔑᒡ, ᒑ ᒌ ᐅᑎᐦᑖᐦᐊᒡ᙮ ᐋᒄ ᑳ ᐅᒋᐱᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐴᓂᓯᓈᒋᑭᓂᔨᐤ ᐋᒄ ᑳᐦ ᐋᑎ ᔮᐃᐦᐊᐦᒡ ᐊᓂᔮᔨᐤ ᒥᓂᔅᑎᑯᔨᐤ ᒃᕇᑦ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","ᒑᒃ ᒫᒃ ᓈᔥᒡ ᒌ ᐹᓯᒀᑎᓐ ᐊᓂᑎᐦ ᐄᑖᐦᒑ ᒃᕇᑦ ᐋ ᐅᐦᑎᒡ, ᐋᐹᔅᑖᒋᐙᑎᐦᒡ ᐋᐦ ᐄᓈᓅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","ᓂᐦᐋᐤ ᒫᒃ ᓂᒌ ᑖᐅᐦᐅᑯᓈᓐ ᐆ ᐋ ᒥᔅᑎᔫᑎᐦᒡ ᐋᒄ ᓂᒧᐃ ᐅᐦᒋ ᒥᔪᐱᔨᐤ ᒑ ᒌ ᐋᐦᐄᒫᓯᓈᓅᒡ᙮ ᐋᒄ ᐃᔨᐙ ᑳ ᐴᓂᐦᑖᔮᐦᒡ ᐋ ᐐᐦ ᐋᐃᒥᐦᐋᒫᐦᒡ, ᒥᒄ ᑳ ᓈᒨᓈᓯᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","ᐄᔥᐱᐦ ᒫᒃ ᐲᓯᒸᑖᐦᒡ ᐊᓐ ᒥᓂᔥᑎᒄ ᑳᐅᑖ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᑳᐦ ᐋᑎᑖᔮᐦᒡ ᐋᑯᑖᐦ ᑳ ᑎᐱᓂᐙᒡ, ᐋᒄ ᒥᒄ ᑳ ᐋᔨᒥᐦᐄᑯᔮᐦᒡ ᐋ ᐳᓯᑖᔮᐦᒡ ᑭᔮᐦ ᐋ ᒥᒫᒋᒀᐱᐦᑳᑎᒫᐦᒡ ᐊᓐ ᑳ ᐊᐱᓵᓰᔨᒡ ᐆᑦ ᐊᓂᑎᐦ ᐊᓐ ᑳ ᒥᔖᒡ ᒌᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","ᐄᔥᐱᐦ ᒫᒃ ᑳ ᐳᓯᑖᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔨᐤ ᐊᓂᑖᐦ ᒌᒫᓂᐦᒡ ᐋᒄ ᐊᓂᒌ ᓈᐹᐅᒡ ᒥᓯᐙ ᐊᓂᑖᐦ ᑳ ᒥᒫᐦᒋᒀᐱᐦᑳᑎᐦᒡ ᔒᐹ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ ᐋᑳ ᒑ ᒌ ᐲᒀᐦᐋᓃᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᐋᐦ ᐋᑎ ᐎᔨᑯᒧᔮᐦᒡ ᒌ ᑯᔥᐱᓈᔨᐦᑎᒧᒡ ᒑ ᒌ ᑖᐦᒋᐦᑎᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᒌᒫᓂᐙᐤ ᔑᔓᒡ ᑳ ᐹᒋ ᐙᓯᐹᐦᒀᔨᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᔅᒌᔨᐤ ᓕᐱᔮ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ᙮ ᐋᒄ ᑳ ᔮᓵᒋᐱᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐅᐱᒫᔑᐙᑭᓂᐙᐤ, ᒥᒄ ᓯᑑ ᒑ ᒌ ᐋᑎᓈᒨᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ ᐋᒄ ᑳᐦ ᐋᒧᑖᐙᐱᓂᐦᒡ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᑳ ᐳᓯᑖᒡ ᑳ ᐃᔥᐱᔥ ᓈᔥᒡ ᒌ ᒥᔅᑎᔫᑎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ᒦᓐ ᒫᒃ ᐎᔮᐱᓃᔨᒡ ᐋᒄ ᐃᔨᐙ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋᐦ ᐄᑖᐱᑎᓃᔨᒡ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᑳ ᐹᐦᐱᑭᔥᑐᐙᐙᐱᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ᒑᒃ ᒥᐦᒑᑐ ᒌᔑᑳᐤᐦ ᓂᒧᐃ ᓅᐦᒋ ᐙᐱᒫᓈᓐ ᐲᓯᒻ ᑭᔮᐦ ᐊᒋᐦᑯᔑᒡ, ᐱᔑᔑᐦᒄ ᐋ ᒥᒋᒌᔑᑳᒡ ᑭᔮᐦ ᐋ ᒥᔅᑎᔫᑎᐦᒡ᙮ ᒑᒃ ᒥᓯᐙ ᐋ ᑎᔑᔮᐦᒡ ᒥᑐᓐ ᔖᔥ ᓂᒌᐦ ᐄᑖᔨᐦᑎᓈᓐ ᒑ ᐃᔮᔨᐦᐅᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ᒑᒃ ᓈᐅᔥ ᓂᒥ ᐅᐦᒋ ᒦᒋᓱᐎᒡ ᐊᓂᒌ ᓈᐹᐅᒡ᙮ ᐋᒄ ᑆᓪ ᑳ ᐊᔨᒥᐦᐋᑦ᙮ ᒌᐦ ᐄᑖᐤ ᒫᒃ, ᓈᐹᑐᒄᐦ, “ᐋᑯᔥ ᒫᒃ ᒌ ᓂᑑᐦᑎᐎᔮᒄ ᑳ ᐃᔮᒀᒥᑎᑯᒡ, ᐋᑯᔥ ᐊᓂᑖᐦ ᒃᕇᑦ ᒌ ᑖᐅᐦᑯᐱᓈ, ᐋᒄ ᒫᒃ ᐊᑑᒡ ᐐ ᐅᐦᒋ ᐃᔥᐱᔥ ᐃᔮᔪᐎᓐ ᒑᒀᓂᐦᐄ ᑭᔮᐦ ᐊᑑᒡ ᐅᐦᒋ ᐲᒀᐦᐊᓐ ᐆ ᒋᒌᒫᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ᐊᓅᐦᒡ ᒫᒃ ᐊᔮᐱᒡ ᒋᐐᐦ ᔒᐦᒋᒥᑎᓈᐙᐤ ᒑ ᒌ ᓲᐦᒋᑖᐦᐋᔮᒄ, ᐙᔥ ᒥᑐᓐ ᓂᒋᔅᒑᔨᐦᑖᓐ ᐋᑳ ᐙᒋᐹᔨᒄ ᒑ ᐃᔮᔪᓰᔨᐦᒄ᙮ ᒥᒄ ᐆ ᒌᒫᓐ ᒋᑭ ᐃᔮᔪᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","ᐙᔥ ᐊᓐ ᒋᔖᒥᓂᑑ ᑳ ᑎᐹᔨᒥᑦ ᐊᓐ ᑳ ᐊᔨᒥᐦᐋᔅᑑᒃ, ᐅᑖᓐᒋᓂᒻᐦ ᓂᒌ ᐹᒋ ᓂᑎᐙᐱᒥᑯᔨᐤ ᑖᐱᔅᑳᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ᐋᒄ ᑳ ᐄᔑᑦ ᐊᓐ ᐋᓐᒋᓐ, ‘ᑆᓪ, ᐊᑳᐐ ᑯᔥᑖᒡ, ᐙᔥ ᒋᑭ ᐎᑎᔅᑭᐎᑳᐳᔥᑎᐙᐤ ᓰᓯᕐ ᐊᓂᑖᐦ ᕎᒥᐦᒡ ᑳᐦ ᑖᑦ ᒑ ᒌ ᑎᐹᔅᑯᓂᔅᒃ᙮ ᑎᑯᓂᔨᐤ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᒥᔪᑐᑎᒫᔅᒃ ᒋᔖᒥᓂᑑ, ᒥᓯᐙ ᒋᑭ ᐱᒫᑎᓰᐎᒡ ᐊᓂᒌ ᑳ ᐐᒑᐅᑣᐤ᙮’ ” ");
INSERT INTO crl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","ᐋᒄ ᒫᒃ ᑆᓪ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓈᐹᐤ, “ᓲᐦᒋᑖᐦᐋᒄ ᒫᒃ, ᐙᔥ ᒥᑐᓐ ᓂᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ ᑖᑆᐦ ᒥᓯᐙ ᒑ ᐄᔅᐱᔨᔨᒡ ᑖᓐ ᑳᐦ ᐄᑦᐦ ᒑ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","ᒥᒄ ᒫᒃ ᔑᔓᒡ ᐊᓂᑖᐦ ᒥᓂᔅᑎᑯᐦᒡ ᒋᑭ ᐄᔑ ᐊᒀᔮᐦᐅᑯᓈᓂᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","ᐄᔥᐱᐦ ᒫᒃ ᓃᔓ ᑎᐎᔥᑖᐤ ᑳ ᐃᔥᐱᔥ ᔫᑎᐦᒡ, ᐊᓐ ᒫᒃ ᑖᐱᔅᑳᒡ, ᐋᔥᒄ ᒥᒄ ᓂᐱᐹᒫᔅᑎᒥᑯᓈᓐ ᐊᓐ ᐋ ᒥᔅᑎᔫᑎᐦᒡ ᐊᓂᑖᐦ ᐊᓐ ᒋᐦᒋᑭᒦ ᐋᑦᕆᔮ ᑳ ᐃᔑᓂᐦᑳᑖᒡ᙮ ᐎᔮᔥ ᒫᒃ ᐃᔮᐱᐦᑖᑎᐱᔅᑳᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᑳᐦ ᐋᐱᑎᔒᒡ ᒌ ᒨᔑᐦᑖᐅᒡ ᐋ ᐹᔣᐱᐦᑎᒧᐎᒋᐦᑦ ᐊᔅᒌᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ᐋᒄ ᑳ ᓂᑑᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᐋᔅᐱᐦᑖᑎᒥᔨᒡ ᐊᓂᑎᐦ᙮ ᐊᐱᓯᔨᐤ ᒌ ᐋᐱᒋᐦᑖᐅᒡ, ᐋ ᑯᓯᑯᓃᔨᒡ ᒑᒀᔨᐤ ᒌ ᒫᐦᑯᐱᑎᒧᒡ ᐊᓂᑖᐦ ᐋ ᐎᓂᔅᒀᐹᑭᓃᔨᒡ, ᐋᒄ ᑳ ᐱᑭᔥᑎᐙᐦᐊᐦᒡ᙮ ᒑᒀᔨᐤ ᐅᔮᔨᐤ ᔖᔥ ᒥᒄ ᐹᔨᒀᐤ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒦᓐ ᓃᔥᑎᓂᐤ ᒥᓯᑦ ᑳ ᐃᔅᐱᐦᑖᑎᒦᔨᒡ᙮ ᐹᑎᒫᔑᔥ ᒫᒃ, ᔖᔥ ᒥᒄ ᐹᔨᑯᔥᑖᒥᑎᓂᐤ ᒥᓯᑦ ᒌ ᐃᔥᐱᐦᑖᑎᒥᔨᐤ ᒦᓐ ᑳ ᓂᑑᒋᔅᒑᔨᐦᑖᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᑯᔥᐱᓈᔨᐦᑎᐦᒡ ᒑ ᒌ ᐱᔅᑖᐱᔅᒋᐦᑎᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ, ᓈᐤ ᐊᓂᔮᔨᐤ ᐴᓂᓯᓈᓱᐎᓐ ᒌ ᐱᑭᔥᑎᐙᐦᐊᒧᒡ, ᒑ ᐋᐦᐋᑳ ᒌ ᒌᐦᒋᑖᐦᐋᓃᔨᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ᙮ ᐋᒄ ᑳ ᐊᔨᒥᐦᐋᒡ ᐐᐱᒡ ᒑ ᒌ ᐙᐱᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","ᐱᔅᒡ ᒫᒃ ᐊᓂᒌ ᓈᐹᐅᒡ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᑳᐦ ᐋᐱᑎᔒᒡ ᒌᒧᒡ ᒋᐐᐦ ᑭᐹᐅᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ᙮ ᐋᒄ ᐊᓂᔮᔨᐤ ᑳ ᐊᐱᔖᔑᔨᒡ ᐅᑎᔨᐤ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᑳᐦ ᑎᑯᓃᔨᒡ ᑳ ᐐᐦ ᐱᑭᔅᑎᐙᐦᐋᒡ᙮ ᒧᔮᒻ ᒫᒃ ᒥᒄ ᐋ ᐐᐦ ᐱᑭᔥᑎᐙᐦᐊᐦᒡ ᐴᓂᓯᓈᒋᑭᓂᔨᐤ ᐊᓂᑖᐦ ᓃᔥᑖᒧᐦᑎᑯᐦᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","ᐋᒄ ᑆᓪ ᑳᐦ ᐄᑖᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐅᒋᒫᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ, “ᓂᒧᐃ ᐙᒋ ᐹᔨᒄ ᒋᑭ ᐅᐦᒋ ᐱᒫᑎᓰᐎᒡ ᓂᑭᑎᐦᒀᐙ ᐅᔮᔨᐤ ᒌᒫᓂᔨᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ᐋᒄ ᒫᒃ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᐃᔨᐙ ᑳ ᐱᔅᒋᓯᐦᒡ ᐊᓂᔮᔨᐤ ᐊᐱᔅ ᑳ ᐅᐦᒋ ᒫᑯᐱᑖᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᔨᐤ, ᐋᒄ ᑳ ᐱᒋᔅᑎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","ᔖᔥ ᒫᒃ ᒑᑳᑦ ᒌ ᐙᐱᓂᔨᐤ᙮ ᐋᒄ ᑆᓪ ᑳ ᔒᐦᒋᒫᑦ ᒥᓯᐙ ᐋ ᑎᔑᔨᒡ ᒑ ᒦᒋᓱᔨᒡ, ᐋᐦ ᐄᑖᑦ, “ᔖᔥ ᓈᐅᔖᑉ ᑎᐦᑐ ᒌᔑᑳᐤᐦ ᑳ ᐃᔥᐱᔥ ᐊᔑᓂᐙᑖᔨᒄ ᑖᓐ ᒑ ᐄᓂᒀ ᑭᔮᐦ ᑳ ᐃᔥᐱᔥ ᐋᑳ ᐅᐦᒋ ᒦᒋᓱᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ᒋᓂᑎᐙᔨᒥᑎᓈᐙᐤ ᒫᒃ ᐋᒄ ᒑ ᒌ ᒦᒋᓱᔮᒄ᙮ ᒋᓂᑎᐙᔨᐦᑖᑯᓯᓈᐙᐤ ᒑ ᒌ ᒦᒋᓱᔮᒄ ᒑ ᒌ ᐱᒫᑎᓰᔮᒄ᙮ ᑖᐹ ᐙᒋᐹᔮᒄ ᐋ ᑎᔑᔮᒄ ᒑᒀᓐ ᒋᑭ ᐅᐦᒋ ᐄᔅᐱᔨᓈᐙᐤ, ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐅᔥᑎᒀᓂᐱᐎᐦ ᒋᑭ ᐅᐦᒋ ᐎᓂᐦᑖᐤ ᐊᐙᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","ᐄᔥᐱᐦ ᒫᒃ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ ᑆᓪ, ᐋᒄ ᑳ ᐅᑎᓈᑦ ᐱᔂᔮᔨᑯᓈᐤ, ᑳ ᓂᓈᔅᑯᒫᑦ ᒋᔖᒥᓂᑑ ᐅᐦᑎᔅᑰ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᐋᐦ ᑖᔨᒡ, ᑳ ᐱᐦᒀᓈᑦ ᐊᓂᔮᔨᐤ ᐱᔂᔮᔨᑯᓈᐤ, ᐋᒄ ᑳ ᒧᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","ᐋᒄ ᒥᓯᐙ ᑳᐦ ᐋᑎ ᓲᐦᒋᔅᑖᐦᐋᒡ ᐊᓂᒌ ᓈᐹᐅᒡ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᑭᔮᐦ ᐐᔨᐙᐤ ᒌ ᐋᑎᒦᒋᓱᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","ᒫᒨ ᒫᒃ ᓃᔣ ᒥᑖᐦᑐᒥᑎᓂᐤ ᒦᓐ ᓃᔂᓱᒥᑎᓂᐤ ᓂᑯᑣᔖᑉ ᓂᒌ ᑎᔑᓈᓐ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ᐄᔥᐱᐦ ᒫᒃ ᒥᓯᐙ ᐊᐙᓐ ᑳ ᑖᐱᔥᑯᔨᑦ, ᐋᒄ ᑳ ᐱᑭᔥᑎᐙᐙᐱᓈᑭᓂᐎᒡ ᐱᐦᒀᔑᑭᓂᒡ, ᐊᑎᑎᐤ ᒑ ᒌ ᔮᐦᑭᐦᒡ ᐊᓐ ᒌᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","ᐄᔥᐱᐦ ᒫᒃ ᐎᔮᐱᐦᒡ, ᐊᓂᒌ ᑳᐦ ᐋᐱᑎᔒᒡ ᐊᓂᑎᐦ ᒌᒫᓂᐦᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᔥᑑᓂᒧᒡ ᑖᓂᑖᐦ ᐋᐦᑖᐎᒋᐦᑦ᙮ ᐋᒄ ᑳ ᐙᐱᐦᑎᐦᒡ ᐊᓂᑎᐦ ᐋ ᐹᒋ ᐙᓯᐦᐋᔨᒡ ᐋ ᔮᑳᐅᔑᔨᒡ, ᐋᒄ ᑳ ᐄᑖᔨᐦᑎᐦᒡ ᐊᓂᑖᐦ ᒑ ᐄᔑ ᓈᑎᑳᒫᐲᐦᑖᐅᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","ᐋᒄ ᑭᔨᑆ ᑳ ᐱᔅᒋᓯᐦᒡ ᐊᓂᔮᔨᐤ ᐴᓂᓯᓈᒋᑭᓂᔨᐤ ᑭᔮᐦ ᑳᐦ ᐋᐱᐦᑯᓂᐦᒡ ᐊᓂᔮᔨᐤ ᑳ ᒫᐦᑯᐱᑎᐦᒡ ᐊᓂᑎᐦ ᐋ ᐅᐦᒋ ᑎᑯᐦᐄᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒌᒫᓂᔨᐤ᙮ ᐋᒄ ᑳ ᐅᐦᐹᔅᑯᐦᐊᐦᒡ ᐱᒫᔥᑐᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᓃᔥᑎᒧᐦᑎᑯᐦᒡ ᔑᔓᒡ ᒑ ᒌ ᐄᑖᐦᐅᑯᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","ᒥᒄ ᒫᒃ ᐊᓐ ᒌᒫᓐ ᐊᓂᑖᐦ ᓃᔥᑎᒧᐦᑎᑯᐦᒡ ᑳ ᓯᔅᒋᑯᐦᑎᐦᒡ ᒦᑖᒀ ᐋ ᐹᒀᒡ ᐋᒄ ᑳ ᓂᒋᒧᐦᑎᐦᒡ ᐊᓂᑎᐦ, ᐋᒄ ᑳᐦ ᐋᑎ ᐲᒀᐦᒡ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᐙᔥ ᐋ ᒌ ᒫᒥᓯᒋᔥᑎᒡ ᑭᔅᑭᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","ᐋᒄ ᐊᓂᒌ ᓂᑐᐱᔫᒡ ᒥᓯᐙ ᑳ ᐐᐦ ᓂᐱᐦᐋᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ ᑳ ᑭᓂᐙᔨᒫᒡ ᑳ ᐅᑎᓂᒫᑭᓂᐎᔨᒡ, ᐋᐦᐋᑳ ᑭᔨᑆ ᓂᑎᐙᔨᒫᒡ ᒑ ᒌ ᐅᔑᒧᔨᒡ, ᐙᔥ ᒋᐱᐦ ᒌ ᐱᑭᔥᑎᐙᒀᔥᑯᐦᑎᔨᐤ ᐊᓂᑖᐦ ᓂᐲᐦᒡ, ᐋᒄ ᒫᒃ ᐊᓂᑖᐦ ᒑ ᒌ ᐄᔑ ᓈᑎᑳᒫᐦᐋᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","ᐊᓐ ᒫᒃ ᓂᑐᐱᔨᐅᒋᒫᐤ ᒋᐐᐦ ᐱᒫᒋᐦᐋᐤ ᑆᓪ ᐋᒄ ᑳ ᒋᔅᑎᐦᐋᒧᐙᑦ ᐊᓂᔮᔨᐤ ᓂᑐᐱᔨᐤ ᑳ ᐐᐦ ᓂᐱᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᓈᐹᐤ᙮ ᐋᒄ ᑳᐦ ᐄᑎᔓᐙᑦ ᐊᓂᔮᔨᐤ ᑳ ᓂᐦᑖᐅᒋᒫᔨᒡ ᓃᔥᑎᒻ ᒑ ᒌ ᐱᑭᔥᑎᐙᒀᔥᑯᐦᑎᔨᒡ ᒑ ᒌ ᓈᑎᑳᒫᐦᐋᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ᑭᔮᐦ ᐊᓂᒌ ᑯᑎᑭᒡ ᐋᔪᐎᒄ ᒋᐱᐦ ᑑᐎᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᐋ ᒥᒫᒋᑯᒡ ᓂᐱᑳᐦᑎᒄ ᑭᔮᐦ ᒫᒃ ᑯᑎᒋᔨᐤ ᒑᒀᔨᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᒌᒫᓂᐦᒡ ᐋ ᒌ ᐲᒀᐦᐋᓃᔨᒡ᙮ ᐋᒄ ᒫᒃ ᒥᓯᐙ ᑳ ᑎᔑᔮᐦᒡ ᑳ ᒥᔪᐲᔮᐦᒡ ᒑ ᒌ ᑭᐹᔮᐦᒡ ᐊᔅᒌ ᒑ ᒌ ᑖᐦᒋᔥᑭᒫᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ᐄᔥᐱᐦ ᒥᓯᐙ ᑳ ᑭᐹᔮᐦᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐎᔮᔅᑎᔮᐦᒡ, ᐋᒄ ᑳ ᐐᐦᑎᒫᑯᔮᐦᒡ ᒫᓪᑖ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᒥᓂᔥᑎᒄ ᐋᐦ ᑖᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ᐊᓂᒌ ᒫᒃ ᐄᔨᔨᐅᒡ ᐊᓂᑎᐦ ᑳᐦ ᑖᒡ, ᓈᔥᒡ ᓂᒌ ᒥᔪᑐᑖᑯᓈᓂᒡ᙮ ᓂᐦᐋᐤ ᒌ ᒋᐦᑎᐅᐦᑖᓂᔨᐤ, ᐋᒄ ᑳ ᑎᐦᑳᔮᐦᒡ, ᑳ ᑯᑑᓯᔨᒥᐦᒡ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ᑆᓪ ᒫᒃ ᒌ ᒫᒨᔑᒋᓂᒻ ᒥᔥᑎᒄ ᑳ ᒧᒋᔥᑎᐦᐋᐦᒃ᙮ ᑳ ᐅᐦᒋ ᒨᔅᒋᔨᒡ ᐊᒋᓈᐱᒄ ᐊᓂᑎᐦ ᐊᓂᔮ ᒥᔥᑎᒄ ᐋᐦ ᐄᑎᔥᑖᔨᒡ, ᐊᓂᔮᔨᐤ ᑭᔨᑆ ᐋ ᒨᔑᐦᑖᔨᒡ ᐋ ᒋᔑᑖᔨᒡ, ᐋᒄ ᑳ ᒋᑭᒧᔨᒡ ᑆᓪ ᐅᑎᐦᒌᐦᒡ, ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᐱᒋᔅᑎᒥᑰ ᐊᓂᔮᔨᐤ ᐊᒋᓈᐱᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐄᔥᐱᐦ ᐎᔮᐱᒫᒡ ᐊᓂᔮᔨᐤ ᐊᒋᓈᐱᒄ ᐋ ᒋᑭᒧᔨᒡ ᐊᓂᑎᐦ ᑆᓪ ᐅᑎᐦᒋᔨᒡ ᑳᐦ ᐄᑎᑐᒡ, “ᒌ ᓂᐱᐦᐄᐙᒑ ᐙᔥ ᐆ ᓈᐹᐤ᙮ ᐋᐦ ᐋᑦ ᒫᒃ ᒌ ᐅᔑᒧᑦ ᐊᓂᑖᐦ ᒋᐦᒋᑭᒦᐦᒡ ᐅᐦᒋ, ᐊᔮᐱᒡ ᐅᑎᐦᑎᐦᐅᑰ ᒑ ᒌ ᐎᔮᔥᑎᒃ᙮ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᐙᐦᒋ ᒫᑯᒥᑯᑦ ᐊᓂᔮᔨᐤ ᐊᒋᓈᐱᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","ᐋᒄ ᒫᒃ ᑆᓪ ᓰᑎᐤ ᑳ ᒧᒋᔥᑎᐙᐱᓈᑦ ᐊᓂᔮᔨᐤ ᐊᒋᓈᐱᒄ ᐊᓂᑎᐦ ᐃᔥᑯᑖᐦᒡ ᐋᐦᐋᑳ ᒥᑐᓐ ᐎᔮᔥ ᐅᐦᒋ ᑐᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ᐋᒄ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒌ ᓈᓈᑭᒋᐦᐋᐅᒡ ᒑ ᒌ ᐹᒋᐱᔨᔨᒡ ᐊᓂᔮᔨᐤ ᑆᓪ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒥᑐᓐ ᐅᐦᒋ ᐎᔮᔥ ᑎᔨᐤ᙮ ᐄᔥᐱᐦ ᒫᒃ ᓈᐆᔅ ᐎᔮᐱᒫᒡ ᐋᐦᐋᑳ ᒥᑐᓐ ᐎᔮᔥ ᑎᔨᒡ ᐋᒄ ᑳᐦ ᐄᑖᒡ, “ᒑᔥᑎᓈᔥ ᒋᔖᒥᓂᑑᐐᒑ ᐆ ᓈᐹᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ᓂᒧᐃ ᐙᐦᔨᐤ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᑳᐦ ᑖᒡ ᒌ ᑎᑯᓐ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌ᙮ ᐴᑉᓕᔭᔅ ᒌ ᐃᔑᓂᐦᑳᓲ ᐊᓐ ᑳ ᐅᒋᒫᐅᑦ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᒥᓂᔥᑎᑯᔨᐤ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᑳ ᑎᐱᔨᐙᐎᓰᑦ ᐊᓂᔮᔨᐤ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᔨᐤ᙮ ᓈᔥᒡ ᓂᒌ ᒥᔪᑐᑖᑯᓈᓐ ᐆ ᓈᐹᐤ᙮ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᓂᒌᐦ ᐃᔥᐱᔥ ᑖᐙᓈᓐ ᐊᓂᑖᐦ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","ᐆ ᒫᒃ ᐴᑉᓕᔭᔅ ᐅᐦᑖᐐᐦ ᒌ ᐋᐦᑯᓯᔨᐤ, ᐋ ᒋᔑᑖᐅᐱᔨᔨᒡ ᑭᔮᐦ ᐋ ᒫᒦᓰᔨᒡ᙮ ᐋᒄ ᑆᓪ ᑳ ᐲᐦᒑᐙᑦ ᐊᓂᑖᐦ ᐅᓂᐹᐅᑭᒥᑯᔨᒡ, ᑳ ᑖᐦᒋᓈᑦ ᐋ ᐊᔨᒥᐦᐋᔥᑎᒧᐙᑦ, ᐋᒄ ᑳ ᒦᓂᐙᒋᐦᐋᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ᐄᔥᐱᐦ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐄᔅᐱᔨᔨᒡ, ᐋᒄ ᒥᓯᐙ ᐊᓂᒌ ᑳᐦ ᐋᐦᑯᓯᒡ ᐊᓂᑎᐦ ᒥᓂᔅᑎᑯᐦᒡ ᑳᐦ ᑖᒡ ᒌ ᑎᑯᔑᓂᒡ ᑭᔮᐦ ᐐᔨᐙᐤ, ᑭᔮᐦ ᒫᒃ ᐐᔨᐙᐤ ᒌ ᒦᓂᐙᑎᓰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ᒥᐦᒑᑐ ᒑᒀᔨᐤ ᓂᒌ ᒥᔨᑯᓈᓂᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒦᓐ ᐙᐦ ᐴᓯᐎᒋᐦᑦ, ᒌ ᐴᓯᐦᑖᐅᒡ ᓂᓈᐦᑭᐤ ᒑᒀᔨᐤ ᒑ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒧᒋᐦᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","ᓂᔥᑐ ᐲᓯᒻ ᒫᒃ ᐃᔥᐱᔥ, ᐋᒄ ᒦᓐ ᑯᑎᒡ ᒌᒫᓐ ᑳ ᒋᔥᑖᔑᔮᐦᒡ ᐋᓕᒃᓵᓐᑦᕆᔮᐦᒡ ᐋ ᐅᐦᒌᒥᑭᐦᒡ᙮ ᒌ ᑎᑯᓐ ᑖᓐ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐊᓐ ᒌᒫᓐ, “ᑳ ᓃᔑᒡ ᒥᓂᑑᐦᑳᓂᒡ” ᒌ ᐃᔑᓂᐦᑳᑖᐤ᙮ ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᒥᓂᔅᑎᑯᐦᒡ ᑳ ᑎᑯᓂᑯᐱᓈ ᐃᔅᑭᓐ ᐱᐳᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","ᐊᓂᑖᐦ ᒫᒃ ᓯᕋᑭᔪᔅ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᑯᑖᐦ ᑳ ᒥᔑᑳᔮᐦᒡ᙮ ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᓂᒌᐦᑖᓈᓐ ᐊᓂᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","ᐋᒄ ᒦᓐ ᐊᓂᑎᐦ ᑳ ᐅᐦᒋ ᐴᓯᔮᐦᒡ, ᕃᑭᔮᒻ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᑯᑖᐦ ᑳ ᒥᓯᑳᔮᐦᒡ᙮ ᒦᓐ ᒫᒃ ᐎᔮᐱᐦᒡ ᒌ ᓵᐅᓂᐦᐃᓐ᙮ ᐋᒄ ᒦᓐ ᓈ ᐋᑎ ᒌᔑᑳᒡ ᐴᑎᔻᓕ ᑳ ᐃᔑᓂᐦᑳᑖᒡ ᐃᐦᑖᐎᓐ ᐋᐅᒄ ᐊᓐ ᑳ ᐅᑎᐦᑎᐦᐊᒫᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","ᐋᑯᑖᐦ ᐅᑎᐦ ᑳ ᐙᐱᒥᒋᐦᒡ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ᙮ ᐋᒄ ᑳ ᐐᔖᒥᔨᒥᐦᒡ ᐹᔨᒄ ᑎᐎᔥᑖᐤ ᒑ ᒌ ᐃᐦᑖᐎᒋᐦᑦ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ᙮ ᐋᒄ ᕎᒻ ᑳ ᐅᑎᐦᑎᐦᐊᒫᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","ᐋᒄ ᐊᓂᒌ ᑳ ᑖᑆᐦᑎᐦᒡ ᐊᓂᑖᐦ ᕎᒥᐦᒡ ᑳᐦ ᑖᒡ ᑳ ᐹᐦᑎᐦᒡ ᐋ ᒌ ᒥᓯᑳᐎᒋᐦᑦ᙮ ᐱᔅᒡ ᐙᐦᐄᐎᔨᔥ ᒌ ᐄᑐᐦᑖᐅᒡ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐊᐱᔮᔅ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᑳ ᒌ ᒫᐅᒋᐦᐄᑐᓈᓂᐎᔨᒡ ᑭᔮᐦ ᐱᔅᒡ ᐊᓂᑖᐦ ᑳ ᓂᔥᑎᐦᒡ ᒥᓂᐦᒀᐅᑭᒥᒄ ᑳ ᐃᔑᓂᐦᑳᑖᔨᒡ ᐃᐦᑖᐎᓂᔨᐤ ᒌ ᐄᑐᐦᑖᐅᒡ ᐋ ᐐᐦ ᐹᒋ ᓂᒋᔥᑰᐎᔨᒥᐦᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑆᓪ ᐎᔮᐱᒫᑦ ᐊᓂᔮᔨᐤ, ᒌ ᓂᓈᔅᑯᒫᐤ ᒋᔖᒥᓂᑑ, ᐙᔥ ᓈᔥᒡ ᒌ ᐅᐦᐱᓂᑰ ᐊᓂᔮᔨᐤ ᐋ ᐙᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","ᑳ ᐅᑎᐦᑎᒫᐦᒡ ᐊᓂᑖᐦ ᕎᒥᐦᒡ, ᑆᓪ ᒌ ᐱᒋᔅᑎᓈᑭᓂᐤ ᑎᐹᓐ ᐊᓂᑖᐦ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ ᒑ ᒌ ᐐᒋᑦ᙮ ᐋᒄ ᒥᒄ ᐊᔮᐱᒡ ᓂᑐᐱᔨᐤ ᒌᐦ ᑖᔨᐤ ᐋ ᓈᓈᑭᒋᐦᐄᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ᓂᔥᑐ ᒌᔑᑳᐤᐦ ᒫᒃ ᐃᔥᐱᔥ ᐋᒄ ᑳ ᓂᑑᒫᑦ ᑆᓪ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑳ ᓃᑳᓂᔥᑭᐙᔨᒡ ᐊᓂᑎᐦ ᑳ ᐅᐦᒌᔨᒡ᙮ ᐄᔥᐱᐦ ᒫᒃ ᓈᔥᑐᐎᔨᒡ ᒌ ᐃᔨᐤ, “ᓃᒋᔖᓂᑎᒄ, ᓂᒌ ᐅᑎᓂᑭᐎᓐ ᐊᓂᑖᐦ ᒋᕉᓯᓕᒥᐦᒡ ᐋᒄ ᐊᓂᑖᐦ ᕎᒻ ᐄᔨᔨᐅᒡ ᐋᐦ ᑖᒡ ᑳ ᐄᔑ ᐱᒋᔅᑎᓂᑭᐎᔮᓐ ᒑ ᒌ ᐄᔑ ᒫᒫᐦᒋᑯᓂᑭᐎᔮᓐ᙮ ᐋᐅᒄ ᐆ ᑳᐦᑐᑖᑯᔮᓐ ᐋᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᒥᒋᑑᑑᒀᐤ ᒋᑎᐄᔨᔨᒥᓂᐎᒡ ᑭᔮᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᐎᓂᑐᑎᒫᓐ ᐊᓂᐦᐄ ᐃᔨᐦᑎᐎᓐ ᐋᓂᔅᒑ ᒌ ᐙᐦᑯᒫᑭᓂᐎᒡ ᑳ ᒥᔨᑎᐦᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ᒋᐐᐦ ᓂᑑᒋᔅᒑᔨᐦᑎᒧᒡ ᒫᒃ ᐊᓂᒌ ᕎᒻ ᐄᔨᔨᐅᒡ ᑖᓐ ᑳ ᐄᔑ ᐎᓂᑐᑎᒧᐦᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒑᒀᔨᐤ ᐅᐦᒋ ᒥᔅᑭᒧᒡ ᒑ ᒌ ᐄᔑ ᐎᓂᑐᑎᒧᐦᒡ᙮ ᔖᔥ ᒫᒃ ᓂᒌ ᐐᐦ ᐱᒋᔅᑎᓂᑯᒡ ᐙᔥ ᓂᒧᐃ ᐅᐦᒋ ᒥᔅᑭᒧᒡ ᑖᓐ ᒑ ᒌ ᐅᐦᒋ ᓂᐱᐦᐄᑯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","ᐋᒄ ᒥᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᐅᐦᒋ ᓂᐦᐋᔨᐦᑎᒧᒡ, ᐋᒄ ᐃᔨᐙ ᑳ ᐃᔮᓐ ᒑ ᒌ ᐙᐱᒥᒄ ᒫᐅᒡ ᓃᑳᓐ ᒋᐦᒋᐅᒋᒫᐤ ᓰᓯᕐ ᑳ ᐃᔑᓂᐦᑳᑖᑭᓅᑦ, ᐐᔨ ᒑ ᒌ ᐎᑎᔅᑭᐎᑳᐳᔥᑎᐎᒃ᙮ ᓂᒥᔮᐤ ᑭᔨᑆ ᐐ ᐋ ᒌ ᐄᑖᔨᐦᑎᒫᓐ ᐎᔮᔥ ᒑ ᒌ ᐄᔑ ᒫᒥᔑᒥᒀᐤ ᓂᑎ ᐄᔨᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ᐋᐅᒄ ᐆ ᐙᐦᒋ ᓂᑑᒥᑎᑯᒡ᙮ ᒋᒌ ᐐᐦ ᐐᐦᑎᒫᑎᓈᐙᐤ ᒑᒀᓐ ᐙᐦᒋ ᒥᒫᐦᒌᒀᐱᔅᑰᐦᐆᑭᐎᔮᓐ, ᐋᐅᒄ ᐆ ᐋᐦ ᐋᐱᑎᔒᔥᑑᒄ ᙭ ᐊᓂᔮᔨᐤ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᑳ ᐊᔅᐹᔨᒧᑐᐙᒡ ᒑ ᐱᒫᒋᐦᐄᑖᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ᐋᒄ ᑳᐦ ᐄᑎᑯᑦ, “ᓂᒧᐃ ᑭᔨᑆ ᐐ ᓃᔮᓐ ᓅᐦᒋ ᐅᑎᑐᐦᐆᑰᓈᓐ ᒑ ᒌ ᒥᓯᓂᐦᐋᒫᑯᔮᐦᒡ ᐊᓂᑖᐦ ᒎᑏᔮ ᐅᐦᒋ, ᒑ ᒌ ᐋᔨᒨᒥᑭᐎᔨᓐ ᐊᓂᑎᐦ᙮ ᑭᔮᐦ ᐊᓂᒌ ᒌᒋᔖᓅᒡ ᐊᓂᑖᐦ ᑳ ᐅᐦᑐᐦᑖᒡ ᓂᒧᐃ ᐎᔮᔥ ᑰᐦᒋ ᐄᑖᒋᒥᑯᒡ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒫᔮᑖᒋᒥᔅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","ᒥᒄ ᒫᒃ ᒋᐐᐦ ᒋᔅᒑᔨᒥᑎᓈᓐ ᑖᓐ ᐋ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᔨᓐ ᒌᔨ, ᐙᔥ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒥᔑᐦᑖ ᐅᐦᑏ ᐆ ᐊᔅᒌ ᓂᒧᐃ ᒥᔻᔨᐦᑎᒧᒡ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᑖᑆᐦᑎᒸᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᑳ ᐎᔮᔨᐦᑎᐦᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᒑ ᒌ ᓂᔥᑐᐐᒡ ᒑ ᒌ ᓂᑑᐦᑎᐙᒡ ᑖᓐ ᒑ ᐄᔨᔨᒡ ᑆᓪᐦ᙮ ᐙᑎᐦᒋᐱᔨᔨᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᐊᓂᑎᐦ ᑳ ᓂᔅᑯᒧᒡ ᒑ ᒌ ᓂᔥᑐᐐᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒌ ᑎᑯᔑᓂᒡ ᐊᓂᑎᐦ ᑆᓪ ᐋᐦ ᑖᔨᒡ᙮ ᐋ ᒑᒋᔖᐹᔮᔨᒡ ᐲᐦᐃᒻ ᐋᐦ ᐋᑎ ᑎᐱᔅᑳᔨᒡ, ᑆᓪ ᒌ ᐙᐐᐦᑎᒧᐙᐤ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᑖᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ᙮ ᑭᔮᐦ ᒌ ᑭᒑᔅᒋᒫᐤ ᐋ ᐐᐦ ᔒᐦᒋᒫᑦ ᒑ ᒌ ᑖᑆᐦᑎᒥᔨᒡ ᒌᓴᔅᐦ ᐊᓐ ᑳᐦ ᐋᔨᒨᒫᑭᓅᑦ ᐊᓂᑖᐦ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓃᔨᒡ ᑭᔮᐦ ᐊᓂᔮᐦᑳ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐅᒥᓯᓂᐦᐄᑭᓃᔨᒡᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ᐱᔅᒡ ᒫᒃ ᒌ ᑖᑆᐦᑖᑰ, ᑯᑎᒃ ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᐦᑎᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ᒌ ᐅᔅᑎᐙᔨᒥᑐᔨᐤ ᒑᒃ ᐅᔮᔨᐤ ᐋᑳ ᑳ ᑖᑆᐦᑎᒥᔨᒡ, ᐋᒄ ᑳᐦ ᐋᑎ ᒋᔅᑐᐦᑖᔨᒡ ᐄᔥᐱᐦ ᐅᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᑆᓪ, “ᑖᑆᐦ ᒧᔮᒻ ᒌ ᐄᔑ ᐐᐦᑎᒧᑖᑯᐱᓐ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᑖᓐ ᑳᐦ ᐄᑖᑦ ᒋᑎᐋᓂᔅᑭᐎᓰᒧᐙᐤ ᐊᓂᔮᔨᐤ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᐋ ᒌ ᐋᐱᒋᐦᐋᑦ ᒑ ᒌ ᐄᔑ ᐐᐦᑎᒧᐙᔨᒡ, ");
INSERT INTO crl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘ᐄᔑᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ, ᒨᔥ ᒋᑭ ᐹᐦᑖᓈᐙᐤ ᒥᒄ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᔅᑐᐦᑖᓈᐙᐤ ᑭᔮᐦ ᐋᑦ ᐄᑖᐱᔮᒀ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᓂᔅᑑᓈᓈᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ᐙᔥ ᐅᒌ ᐄᔨᔨᐅᒡ ᓈᔥᑖᑆᐦ ᓰᐱᐦᑎᒧᒡ, ᓂᒧᐃ ᐐᐦ ᑖᑆᐦᑎᒧᒡ, ᒧᔮᒻ ᐋ ᒋᐳᓂᐦᒡ ᐅᐦᑎᐎᑳᐙᐤ ᑭᔮᐦ ᐅᔅᒌᔑᑯᐙᐤ ᐋᔪᐎᒄ ᐋᓐ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ᐋᑳ ᒫᒃ ᐅᔮᔨᐤ ᑎᒡ ᒋᐱᐦ ᐙᐱᐦᑎᒧᒡ ᑭᔮᐦ ᒋᐱᐦ ᐹᐦᑎᒧᒡ ᑭᔮᐦ ᒋᐱᐦ ᓂᔅᑐᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᒀᐤ᙮ ᓂᐱᐦ ᐹᒋ ᓂᑎᐙᐱᒥᑯᒡ ᒫᒃ, ᐋᒄ ᒫᒃ ᓂᐱᐦ ᒦᓂᐙᒋᐦᐋᐅᒡ᙮’ ” ᐋᔪᐎᒄ ᑳᐦᐄᑖᑯᐱᓈ ᒋᔖᒥᓂᑑᐦ ᐋᐃᓵᔮ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","ᐋᒄ ᑆᓪ ᑳᐦ ᐃᔨᑦ, “ᒑ ᒋᔅᒑᔨᐦᑎᒫᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐋᐦ ᐄᑎᔓᐦᐅᐃᒥᐦᑦ ᒑ ᒌ ᐙᐐᐦᑎᒫᐦᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐱᒫᒋᐦᐋᑭᓂᐎᒡ᙮ ᒋᑭ ᓂᑐᐦᑎᒧᒡ ᒫᒃ ᐅᒌ ᐐᔨᐙᐤ᙮” ");
INSERT INTO crl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ᐄᔥᐱᐦ ᒫᒃ ᑆᓪ ᑳᐦ ᐃᔨᑦ ᐅᔮᔨᐤ, ᒌ ᐎᔨᐎᐅᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᒥᒋᐱᔨᔨᒡ ᐋᐦ ᐋᔮᔅᑖᒥᑑᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","ᓃᔓ ᐱᐳᓐ ᒫᒃ ᒌᐦ ᑖᐤ ᑆᓪ ᐊᓂᑎᐦ ᐊᓂᔮᔨᐤ ᐙᔅᑳᐦᐄᑭᓂᔨᐤ᙮ ᐐᔨ ᒌ ᐱᒥᐱᔨᐦᐄᓲ ᔓᐎᔮᓐ ᐅᐦᒋ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᔮᔨᐤ ᐄᔨᔨᐤᐦ ᑳ ᒧᑎᐦᑖᑯᑦ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑎᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ᒌ ᐋᔨᒨᑎᒸᐤ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒋᐦᒋᐅᒋᒫᐎᓂᔨᐤ, ᑭᔮᐦ ᒌ ᒋᔅᑯᑎᒫᒑᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒌᓴᔅᐦ ᙭ ᐋᐦ ᐋᔨᒨᒫᑦ᙮ ᒌ ᓲᐦᒋᑖᐦᐋᐤ ᒫᒃ ᒥᑐᓐ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᒋᔅᑎᐦᐋᒧᐙᑭᓂᐤ ᐅᔮᔨᐤ ᐋ ᐃᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","ᓃᔨ ᑆᓪ, ᒌᓴᔅ ᙭ ᐅᑖᐱᒋᐦᐋᑭᓐᐦ᙮ ᒋᔖᒥᓂᑑ ᓂᒌ ᐅᐙᔮᐱᒧᒄ ᐋᑆᔅᑎᓪ ᒑ ᒌᐦ ᑖᐅᒡ ᑭᔮᐦ ᒫᒃ ᐐᔨ ᓂᒌ ᑖᑆᑎᒄ ᒑ ᒌ ᐙᐐᐦᑎᒧᒡ ᐅᒥᔻᒋᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ᔖᔥ ᐙᔥᑭᒡ ᐊᓂᑖᐦ ᒌ ᐹᒋ ᐐᐦᑎᒥᐦᑖᑯᐱᓐ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᐋᔥᒄ ᒑ ᑎᑯᓃᔨᒡ ᐅᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᐊᓂᔮᐦᑳᐦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤᐦ ᒌ ᐋᐱᒋᐦᐋᐤ ᒑ ᒌ ᒥᓯᓈᐦᐋᒥᔨᒡ ᐅᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᐅᐱᔮᐦᒋ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᔨᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ᐅᑯᓯᔅᐦ, ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤᐦ ᒌᓴᔅ ᙭, ᐋᔪᐎᒄ ᐋᓐ ᐊᓂᔮᔨᐤᐦ ᐃᔮᔨᒧᒫᑭᓂᐎᔨᒡ ᐅᑎᐦ ᒥᔻᒋᒧᐎᓂᐦᒡ᙮ ᑳ ᐱᒫᑎᓰᑦ, ᐊᓂᔮᔨᐤ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐋᐦ ᑖᔨᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","ᐋᔨᐤᐦ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᐅᑯᓰᑐᑖᑰ᙮ ᒋᔖᒥᓂᑑᐦ ᒫᒃ ᐋ ᒌ ᐎᓂᔥᑳᓂᑯᑦ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ ᙭ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐙᐱᐦᑏᐙᑦ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒌᓴᔅᐦ ᑖᑆᐦ ᐋᐦ ᐋᐎᔨᒡ ᒋᔖᒥᓂᑑ ᑳ ᓲᐦᒑᔨᐦᑖᑯᓰᔨᒡ ᐅᑯᓯᓯᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","᙭ ᐅᐦᒋ ᒋᔖᒥᓂᑑ ᓂᒌ ᒥᔪᑐᑖᒄ ᐋ ᒌ ᐅᐙᔮᐱᒥᑦ ᑭᔮᐦ ᐋᑆᔅᑎᓪ ᒑ ᒌ ᐄᔑ ᐋᐱᑎᓰᔥᑎᐙᐦᒄ, ᒑ ᒌ ᐐᒋᐦᐄᒥᒡ ᒥᓯᐙ ᓂᓈᐦᑭᐤ ᐋ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐋᑎ ᑖᑆᔮᔨᒥᑯᑦ ᑭᔮᐦ ᒑ ᒌ ᐅᐦᒋ ᐋᑎ ᓂᓂᐦᐄᐦᑖᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","ᑭᔮᐦ ᒫᒃ ᒌᔨᐙᐤ ᒋᑎᔅᑎᓂᑯᓈᐙᐤ ᐆ ᐋ ᐄᔑ ᐙᐐᐦᑎᒫᓐ, ᒌᔨᐙᐤ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒥᑖᒄ ᒌᓴᔅ ᙭ ᒑ ᒌ ᑎᐹᔨᒥᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᒥᓯᓂᐦᐋᒫᑎᑯᒡ ᒥᓯᐙ ᒌᔨᐙᐤ ᕎᒥᐦᒡ ᑳᐦ ᑖᔮᒄ, ᒌᔨᐙᐤ ᒋᔖᒥᓂᑑ ᑳ ᓵᒋᐦᐄᑖᒄ ᑭᔮᐦ ᑳ ᐅᐙᔮᐱᒥᑖᒄ ᒑ ᒌ ᑎᐹᔨᒥᑖᒄ᙮ ᒋᔖᒥᓂᑑ ᑰᐦᑖᐐᓂᐤ ᑭᔮᐦ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ ᙭ ᒋᑭ ᒥᔪᑐᑖᑯᐙᐅᒡ ᑭᔮᐦ ᒋᑭ ᒥᔨᑯᐙᐅᒡ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ᓃᔥᑎᒻ ᒑᒀᓐ ᐙᐦ ᐃᔮᓐ᙮ ᓂᓂᓈᔅᑯᒫᐤ ᓂᒋᔖᒥᓂᑑᒻ ᒌᓴᔅ ᙭ ᐅᐦᒋ ᐄᔥᐱᐦ ᒑᔅᒑᔨᐦᑖᑯᐦᒡ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ, ᐙᔥ ᒥᓯᐙ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐋᔨᒨᑖᑭᓂᐤ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ᒋᔖᒥᓂᑑ ᐊᓐ ᐙᒋᐦᒡ ᑳᐦ ᐋᐱᑎᔒᔥᑑᒄ ᒥᓯᐙ ᓂᑖᐦᐄᒡ ᐅᐦᒋ ᐋ ᐙᐐᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐅᑯᓯᔅᐦ ᐊᓂᑎᐦ ᐋᐦ ᐋᔨᒨᒫᑭᓂᐎᒡ ᓂᒋᔅᒑᔨᒥᒄ ᐋ ᑖᑆᐅᒡ᙮ ᓂᒋᔅᒑᔨᒥᒄ ᒨᔥ ᐋ ᒌᔥᒌᑖᑎᑯᒡ ᑎᐦᑐ ᐊᔨᒥᐦᐋᔅᑑᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ᓂᓂᑐᑎᒧᐙᐤ ᑖᑆᐦ ᒑ ᒌ ᓂᐦᐄᐱᔨᐦᑖᑦ ᒑ ᒌ ᐙᐱᒥᑎᑯᒡ, ᐐᔨ ᑭᔨᑆ ᐋᑖᔨᒥᒀ ᒑ ᒌ ᓂᑎᐙᐱᒥᑎᑯᒡ ᐋᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","ᓈᔥᑖᑆᐦ ᒋᐐᐦ ᐙᐱᒥᑎᓈᐙᐤ ᒑ ᒌ ᐊᓲᒥᔨᑖᑯᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᐊᓂᔮᔨᐤ ᐊᐦᒑᐦᑰ ᒥᔨᐙᐎᓐ ᒋᔖᒥᓂᑑ ᑳ ᐹᒋ ᒥᔨᑦ ᒑ ᒌ ᔮᐃᒋᑳᐳᔮᒄ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","ᓂᔑᓐ ᑖᐱᔥᑯᓐ ᒑ ᒌ ᐐᒋᐦᐄᑐᔨᐦᒄ, ᒑ ᒌ ᐐᒋᐦᐄᑯᔮᒄ ᓃᔨ ᓂᑖᑆᔮᔨᐦᑎᒧᐎᓐ ᑭᔮᐦ ᒫᒃ ᒌᔨᐙᐤ ᒋᑖᑆᔮᔨᐦᑎᒧᐎᓂᐙᐤ ᒑ ᒌ ᐐᒋᐦᐄᑯᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ᒑ ᐐᐦ ᒋᔥᒋᓯᔮᒄ ᐆ ᓃᒋᔖᓂᑎᒄ᙮ ᔖᔥ ᒥᐦᒑᑣᐤ ᓂᒌ ᐎᔮᔨᐦᑖᓐ ᒑ ᒌ ᓂᑎᐙᐱᒥᑎᑯᒡ, ᒥᒄ ᒫᒃ ᒨᔥ ᒌᐦ ᑎᑯᓐ ᒑᒀᓐ ᐋ ᓂᑳᐦᐅᑯᔮᓐ᙮ ᐙᔥ ᓂᐱᑯᓵᔨᐦᑖᓐ ᑭᔮᐦ ᒌᔨᐙᐤ ᒑ ᒌ ᐐᒋᐦᐄᑎᑯᒡ ᒑ ᒌ ᑖᑆᐦᑎᒫᒄ ᒥᔻᒋᒧᐎᓐ ᒧᔮᒻ ᑳ ᐄᔑ ᐐᒋᐦᐄᒀᐤ ᑯᑎᑭᒡ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌ ᑖᑆᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","ᐋᐅᒄ ᐆ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑖᑯᓯᔮᓐ ᒑ ᒌᐦ ᑎᔮᓐ᙮ ᓂᓂᑎᐙᔨᐦᑖᑯᓯᓐ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐙᐐᐦᑎᒨᒀᐤ ᐅᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ, ᐊᓂᒌ ᒃᕇᒃ ᑭᔮᐦ ᒫᒃ ᐊᓂᒌ ᐋᐦᐋᑳ ᒃᕇᒃ ᐄᑎᔅᑳᓈᓰᔨᒡ, ᐊᓂᒌ ᐋ ᒌ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᐎᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒋᓂᐦᐊᒧᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᓈᔥᒡ ᐎᔓᐙᔨᒧᔮᓐ ᒑ ᒌ ᐙᐐᐦᑎᒫᑎᑯᒡ ᑭᔮᐦ ᒌᔨᐙᐤ ᕎᒥᐦᒡ ᑳᐦ ᑖᔮᒄ ᐆ ᒥᔻᒋᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","ᐙᔥ ᑖᐹ ᓂᐱᒫᒥᓯᔅᑖᓐ ᒥᔻᒋᒧᐎᓐ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐅᓲᐦᑳᑎᓯᐎᓐ ᐃᔮᐱᒋᐦᑖᑦ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐃᔮᔨᒡ ᐱᒫᒋᐦᐄᑯᓰᐎᓂᔨᐤ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ᙮ ᓃᔥᑎᒻ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒌ ᐙᐐᐦᑎᒧᐙᑭᓂᐎᔨᐤ ᒑᒃ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳᐦ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑳ ᐙᐐᐦᑎᒫᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","ᐋᑯᑖᐦ ᑭᔮᐦ ᒥᔻᒋᒧᐎᓂᐦᒡ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑭᐎᔨᐦᒄ ᑖᓂᑖᐦ ᐙᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐋᑦ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ ᐐᔨ ᐄᔑ ᐋᐦ ᑖᑦ᙮ ᐋ ᑖᑆᔮᔨᒫᑦ ᐊᐙᓐ ᒌᓴᔅᐦ ᐋᑯᑖᐦ ᒥᒄ ᐙᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐋᑭᓅᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᐊᓐ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤ ᐱᒫᒋᐦᐄᑰ ᐊᐙᓐ, ᑭᔮᐦ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᒌᐙᐦᑎᐦᐄᑯᑦ᙮ ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓐ ᑳ ᑯᐃᔅᑯᑖᑎᓰᑦ, ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ ᐅᐦᒋ ᐋᐅᒄ ᒑ ᐱᒫᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ᐙᔥ ᐋᑯᑖᐦ ᓅᑯᐦᑖᑦ ᒋᔖᒥᓂᑑ ᒋᐦᒋᒌᔑᑯᐦᒡ ᐅᐦᒋ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓈᔥᒡ ᒋᔑᐙᐦᐄᑯᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒥᒑᑎᓰᔨᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᒥᑐᓐ ᐃᔮᐱᑖᔨᒥᑯᑦ᙮ ᐙᔥ ᐊᓂᔮᔨᐤ ᐋ ᒥᒑᑎᓯᒡ ᐄᔨᔨᐅᒡ ᓂᑳᐦᐊᒧᒡ ᐊᑎᑎᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑖᑯᓃᔨᒡ ᑖᑆᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","ᐙᔥ ᔖᔥ ᒥᑐᓐ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐋᐤ ᐊᐙᔨᐤᐦ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ᙮ ᐐᔨ ᒋᔖᒥᓂᑑ ᒌ ᐱᔮᑭᔅᒡ ᐙᐱᐦᑎᔮᐤ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ᐋᐦ ᐋᑳ ᓈᐦᐄᔨᐤ ᒌ ᐙᐱᒫᑭᓅᑦ ᑖᓐ ᓂᐦᐋᐤ ᐊᑖᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ, ᐃᔥᑯᑎᒃ ᒫᒃ ᐊᓂᑖᐦ ᒫᐅᒡ ᐅᔅᑭᒡ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐅᔑᐦᑖᑦ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᐋᑯᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐱᔮᑭᔅᒡ ᒋᔅᒑᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᑳᒋᒡ ᐆ ᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᐋᑯᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᒫᒡ ᑖᑆᐦ ᐋ ᒋᔖᒥᓂᑑᐎᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᑭᑎ ᒌ ᐃᔨᐤ ᐊᐙᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐋᐦ ᑖᔨᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ᐙᔥ ᒫᐤ ᑳ ᐃᓯᓈᑯᐦᒡ᙮ ᒌ ᒋᔅᒑᔨᐦᑎᒧᒡ ᑖᑆᐦ ᐋᐦ ᑖᔨᒡ ᒋᔖᒥᓂᑑ, ᒥᒄ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᒋᔅᑖᔨᒫᐅᒡ ᑖᓐ ᒑ ᐄᔑ ᒋᔅᑖᔨᒫᐙᑯᐱᓈ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒋ ᐐᐦ ᓂᓈᔅᑯᒫᐅᒡ᙮ ᐅᔮᔨᐤ ᐋᐦ ᑎᒡ ᓂᒧᐃ ᐱᐹᔅᐱᓈ ᐅᐦᒋ ᐃᓯᓈᑯᓂᔨᐤ ᑖᓐ ᑳ ᐄᑖᔨᐦᑎᐦᒡ ᐋ ᐄᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑᐦ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᑯᐃᔅᒄ ᐅᐦᒋ ᐄᔑ ᑭᓂᐙᐱᐦᑎᒧᒡ ᒑᒀᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ᒧᔮᒻ ᓈᔥᒡ ᐋ ᑭᒑᐦᑖᐙᔨᐦᑎᐦᒡ ᒌ ᐄᑖᔨᐦᑖᑯᐦᐄᓱᐎᒡ, ᒥᒄ ᒫᒃ ᒥᑐᓐ ᒌᔥᒀᐦᑳᓂᐦᒡ ᐄᑖᔨᐦᑖᑯᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ᐃᔥᐱᔥ ᐐ ᒑ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ ᑳ ᒋᔅᑖᔨᐦᑖᑯᓰᔨᒡ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳᒋᒡ ᒑ ᑖᔨᒡ, ᐊᐙᔅᑖ ᐊᓂᔮᔨᐤᐦ ᒥᓂᑑᐦᑳᓐᐦ ᐊᔨᒥᐦᐋᔥᑎᐙᐅᒡ, ᐊᓂᔮᔨᐤᐦ ᐐᔨᐙᐤ ᑎᐱᔨᐙ ᐋ ᒌ ᐅᔑᐦᐋᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᒥᓂᑑᐦᑳᓐᐦ ᑳ ᐄᔑᓈᑰᐦᐋᒡ ᒧᔮᒻ ᓈᐹᐤᐦ ᐊᓂᔮᔨᐤᐦ ᒑ ᐳᓂᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᒫᒃ ᐱᔮᔒᔥ ᑭᔮᐦ ᒫᒃ ᐊᐅᐦᑳᓐ ᑭᔮᐦ ᒫᒃ ᓂᓈᐦᑭᐤ ᐋ ᐃᓯᓈᑯᓰᔨᒡ ᒥᓂᑐᔥᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ᓂᒧᐃ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᐎᒡ ᒋᔖᒥᓂᑑᐦ᙮ ᐋᔪᐎᒄ ᐙᐦᒋ ᒥᑐᓐ ᒌ ᐱᒋᔥᑖᔨᒥᑯᒡ ᐐᓂᓱᐎᓂᐦᒡ ᐄᔑ, ᒑ ᒌ ᐋᑎ ᐃᔨᐦᑑᑎᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᓂᑐᐙᔨᐦᑎᒨᒥᑭᓃᔨᔨᒡ ᐅᑖᐦᐄᐙᐤᐦ᙮ ᐐᓂᐦᐄᑑᐎᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᓂᑎᐐ ᐋ ᐊᔨᐦᑐᑖᑐᒡ ᐐᓂᓱᐎᓂᐦᒡ ᐄᔑ, ");
INSERT INTO crl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ᒀᔅᒋᓂᒧᐙᐅᒡ ᐊᓂᔮᔨᐤ ᑖᑆᐎᓂᔨᐤ ᒋᔖᒥᓂᑑᐦ ᑳ ᐱᒋᔅᑎᓂᒥᔨᒡ ᒑ ᒌ ᒋᔅᒑᔨᐦᑖᑭᓂᐎᔨᒡ᙮ ᒦᔥᑯᒡ ᒫᒃ ᓂᓂᑎᐎᓂᔨᐤ ᒌ ᑖᑆᐦᑎᒧᒡ᙮ ᐃᔥᐱᔥ ᐐ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐅᔑᐦᑖᔨᒡ ᒑ ᒌ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ, ᐊᓂᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᑳ ᐅᔑᐦᑖᔨᒡ ᐋᔪᐎᒄ ᐋᓐ ᐊᓂᔮᔨᐤ ᐊᔨᒥᐦᐋᔅᑎᐦᒡ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᐋᐅᒄ ᑖᑆᐦ ᑎᔮᐱᒑᔨᐦᑖᑯᓯᑦ ᑳᒋᒡ ᒑ ᒌ ᒫᒥᐦᒋᒫᑭᓅᑦ᙮ ᐋᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ᐅᔮᔨᐤ ᒫᒃ ᐋᐦ ᑎᒡ ᐄᔨᔨᐅᒡ, ᐋᐦᐋᑳ ᐐᐦ ᒋᔅᑖᔨᒫᒡ ᑭᔮᐦ ᐋᐦᐋᑳ ᐐᐦ ᓂᓈᔅᑯᒫᒡ ᒋᔖᒥᓂᑑ, ᐋᒄ ᐊᓂᑖᐦ ᑳ ᐄᔑ ᐱᒋᔥᑖᔨᒥᑯᒡ ᐅᐐᓂᓯᐤ ᒥᒋᓂᑐᐙᔨᐦᑎᒧᐎᓂᐙᐦᒡ ᐄᔑ᙮ ᐙᐙᒡ ᐃᔅᒀᐅᒡ ᒌ ᒀᔅᒋᐱᔨᐦᑖᐙᐅᒡ ᐊᓂᔮᔨᐤᐦ ᒋᔖᒥᓂᑑᐦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᐋ ᒥᔪᓈᑯᓃᔨᒡ ᒑ ᐄᔑ ᒋᔅᒑᔨᒥᑐᔨᒡ ᓈᐹᐤᐦ ᑭᔮᐦ ᐃᔅᒀᐤᐦ ᐊᓂᑖᐦ ᐐᒋᐦᑐᐎᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","ᐋᔪᐎᒄ ᑳᐦ ᑎᒡ ᑭᔮᐦ ᓈᐹᐅᒡ᙮ ᒌ ᓂᑭᑎᒧᒡ ᐊᓂᔮᔨᐤᐦ ᒋᔖᒥᓂᑑ ᑳ ᐄᔑ ᒥᔨᑯᒡ ᒑ ᒌ ᐄᔑ ᒋᔅᒑᔨᒫᒡ ᐃᔅᒀᐤᐦ᙮ ᐋᒄ ᒫᒃ ᓈᔥᒡ ᓲᐦᒋᐱᔨᔨᒡ ᐐᔨᐙᐤ ᐋ ᐄᔑ ᒥᒋᓂᑐᐙᔨᒥᑐᒡ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐊᔨᐦᑐᑖᑐᒡ ᓈᐹᐅᒡ ᒥᑐᓐ ᐱᐱᒫᔮᔨᐦᑖᑯᓂᔨᐤ ᑭᔮᐦ ᐐᔨᐙᐤ ᒫᑯᐦᐄᓯᐎᒡ ᐊᓂᔮᔨᐤᐦ ᐋ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᒌ ᐄᔑ ᒫᑯᐦᐋᑭᓄᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ᐋᐦᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᑯᐃᔅᒄ ᒑ ᐄᔑ ᒋᔅᒑᔨᒫᐙᑯᐱᓈ ᒋᔖᒥᓂᑑᐦ, ᑭᔮᐦ ᐋᐦᐋᑳ ᐐᐦ ᐃᔮᐱᑖᔨᒫᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ ᐋᒄ ᒋᔖᒥᓂᑑ ᑳ ᐱᒋᔅᑎᓂᑯᒡ ᒑ ᑐᑖᑯᒡ ᓈᔥᒡ ᐋᑳ ᒑ ᒌ ᑯᐃᔅᑯᓈᑯᓃᔨᒡ ᑖᓐ ᐋᔨᑖᔨᐦᑎᐦᒡ ᒑ ᒌᐦ ᑎᒡ᙮ ᐋᒄ ᒫᒃ ᐋᐦ ᑐᑎᐦᒡ ᐊᓂᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᐋᑳ ᒑ ᑐᑎᒧᐙᑯᐱᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ᐲᐦᒋᔥᑳᑭᐎᔨᒡ ᓂᓈᐦᑭᐤ ᒥᒑᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᒫᔮᑎᓰᐎᓂᔨᐤ, ᑭᔮᐦ ᐲᐦᒋᔥᑳᑭᐎᔨᒡ ᒧᔥᑖᓂᒫᒑᐎᓂᔨᐤ ᑭᔮᐦ ᐅᐦᑳᑖᔮᔨᒧᐎᓂᔨᐤ᙮ ᒥᑐᓐ ᐲᐦᒋᔥᑳᑭᐎᔨᒡ ᐅᐎᐦᑖᔨᐦᑎᒧᐎᓂᔨᐤ, ᑭᔮᐦ ᒨᔥ ᐐᐦ ᓂᐱᐦᐄᐙᐅᒡ, ᑭᔮᐦ ᒨᔥ ᒥᒋᐋᔨᓰᐦᑳᐙᐅᒡ ᐊᐙᔨᐤᐦ, ᐱᔑᔑᐦᒄ ᑭᔮᐦ ᐎᓂᐲᐦᐄᐙᐅᒡ, ᑭᔮᐦ ᒥᑐᓐ ᐲᐦᒋᔥᑳᑯᒡ ᐅᐦᑳᓯᐙᐎᓂᔨᐤ᙮ ᐳᑯᓅᒧᐙᐅᒡ ᑭᔮᐦ, ");
INSERT INTO crl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ᒫᒃ ᒧᔖ ᒥᒋᐋᔨᒨᒫᐅᒡ ᐊᐙᔨᐤᐦ, ᐅᐦᑳᑖᐅᒡ ᑭᔮᐦ ᒋᔖᒥᓂᑑᐦ, ᓈᔥᑖᑆᐦ ᓲᐦᒋᒫᔮᔨᐦᒑᐅᒡ, ᓈᔥᑖᑆᐦ ᒋᔅᑖᔨᒦᓱᐎᒡ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᐋ ᐐᐦ ᓂᓈᐹᐅᒧᒡ ᐋᔪᐎᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓯᒡ᙮ ᒨᔥ ᒥᔅᑭᐙᑖᐎᒡ ᑖᓂᔮᔨᐤ ᐊᑎᑎᐤ ᒑ ᒌ ᐅᐦᒋ ᒥᒋᐱᒫᑎᓰᔨᒡ᙮ ᓂᔥᑰᔥᑐᐙᐅᒡ ᐅᓃᒋᐦᐄᑯᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ᓂᒧᐃ ᒥᑐᓐ ᓂᔅᑐᔥᑳᑰᐎᒡ ᒥᒑᑎᓰᐎᓂᔨᐤ ᐅᑖᐦᐄᐙᐦᒡ ᑭᔮᐦ ᐅᒥᑐᓈᔨᐦᒋᑭᓂᐙᐦᒡ᙮ ᓂᒧᐃ ᒥᑐᓐ ᓂᓈᑭᑐᐙᔨᐦᑎᒧᒡ ᐊᓂᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ ᑳ ᓂᔅᑯᒧᒡ ᒑ ᓂᓈᑭᑐᐙᔨᐦᑎᐦᒡ᙮ ᓂᒧᐃ ᒥᑐᓐ ᓅᑯᓂᔨᐤ ᓵᒋᐦᐄᐙᐎᓂᔨᐤ ᒑ ᒌ ᐃᔮᒡ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᒥᑐᓐ ᒋᔅᑎᒫᒑᔨᒫᐅᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ᐋᑦ ᐋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᒋᔖᒥᓂᑑᐦ ᐋ ᒌ ᐎᔮᔨᐦᑎᒥᔨᒡ ᑖᑆᐦ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᒥᒋᐱᒫᑎᓰᔨᒡ ᐊᔮᐱᒡ ᐊᑎᑎᐤ ᑑᐎᒡ ᐐᔨᐙᐤ ᑖᓐ ᐙᐦ ᐃᔨᐦᑎᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒥᒄ ᐅᔮᔨᐤ ᑑᐎᒡ, ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᑯᒡ ᐋᔨᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐅᔮᔨᐤ ᐋ ᐄᔑ ᒥᒋᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","ᐋᐅᒄ ᒫᒃ ᐆ ᐙᐦᒋ ᐋᑳ ᒥᑐᓐ ᐃᓯᓈᑯᐦᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑦ ᐊᐙᓐ᙮ ᐙᔥ ᒥᔔ ᐋ ᑎᐹᔅᑯᓂᑣᐤ ᐄᔨᔨᐅᒡ, ᒌᔨ ᒫᒃ ᑳᐦ ᑐᑎᒧᓈ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᑎᐹᔅᑯᓂᑣᐤ, ᒌᔨ ᑎᐱᔨᐙ ᒌ ᓂᔑᐎᓈᒋᒦᓱᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ᐙᔥ ᒥᓯᐙ ᒋᒑᔥᑎᓈᐦᐅᓈᓂᐤ ᑖᑆᐦ ᑯᐃᔅᒄ ᐋᐦᑎᒃ ᒋᔖᒥᓂᑑ ᑖᐹᔅᑯᓈᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳᐦ ᑐᑎᒥᔨᒡ ᐅᔮᔨᐤᐦ ᒑᒀᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ᒌᔨ ᒫᒃ ᐐ, ᒌᔨ ᒋᑐᑖᓐ ᐅᐦᐄᐦ ᒑᒀᓂᐦᐄᐦ ᑖᓂᔮᔨᐤᐦ ᐋ ᐄᔑ ᑎᐹᔅᑯᓂᑣᐤ ᑯᑎᑭᒡ ᐋᐦ ᑐᑎᐦᒡ᙮ ᒋᑎᐄᑖᔨᐦᑖᓐ ᐋ ᒑ ᒥᔮᔅᑭᒧᑦ ᒋᔖᒥᓂᑑ ᐅᐎᔮᔅᑯᓂᒑᐎᓐᐦ ᐆ ᐋᐦᑎᔨᓐ? ");
INSERT INTO crl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","ᓈᔥᑖᑆᐦ ᒋᔖᐙᑎᓯᐤ ᒋᔖᒥᓂᑑ᙮ ᓂᒧᐃ ᐄᑖᔨᐦᑎᒻ ᒑ ᒌ ᑎᐹᔅᑯᓂᔅᒃ ᑭᔮᐦ ᓈᔥᑖᑆᐦ ᒌ ᓰᐱᔨᐙᓰᔅᑖᒄ᙮ ᒑᒀᔨᐤ ᐙᐦᒋ ᒫᔮᔨᒥᑦ, ᐊᓂᔮᔨᐤ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑖᑯᓯᑦ? ᓂᒧᐃ ᐋ ᒋᒋᔅᒑᔨᐦᑖᓐ ᒑᒀᔨᐤ ᐙᐦᒋ ᒋᔖᐙᑐᑖᔅᒃ? ᒌ ᓂᑎᐙᔨᒥᒄ ᒑ ᒌ ᒥᐦᒋᔨᐙᔨᐦᑎᒧᑦ ᑖᓐ ᐋ ᐄᔑ ᒥᒑᑎᓰᐎᑦ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᒀᔅᑳᑎᓰᐎᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ᐊᓐ ᒫᒃ ᐋ ᐃᔥᐱᔥ ᓰᐱᐦᑎᒥᓐ ᒑᔅᑳᐦ ᒌᐦ ᑐᑖᓱᓐ ᐊᑎᑎᐤ ᐋᐦᒀᒡ ᒑ ᒌ ᐄᔑ ᑎᐹᔅᑯᓂᔅᒃ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐋ ᒌᔑᑳᔨᒡ ᒑ ᓅᑯᐦᑖᑦ ᒑᔥᑎᓈᔥ ᑯᐃᔅᒄ ᒑ ᐄᔑ ᑎᐹᔅᑯᓈᑦ ᐊᓂᔮᔨᐤᐦ ᑳ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","ᐙᔥ ᒋᔖᒥᓂᑑ ᑭᑎ ᑎᑯᓂᔨᐤ ᒑ ᐄᔑ ᒥᔮᑦ ᐹᐦᐹᔨᒄ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᑐᑎᒥᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒨᔥ ᑳ ᒥᔪᑐᑎᒥᔨᒡ ᐋ ᐱᑯᓵᔨᒧᔨᒡ ᒑ ᒌ ᒥᔪ ᑭᓂᐙᐱᒥᑯᔨᒡ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒑ ᒌ ᒥᔻᒋᒥᑯᔨᒡ ᑭᔮᐦ ᒑ ᒌ ᒥᔨᑯᔨᒡ ᑳᒋᒡ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ, ᑭᑎ ᒥᔮᐤ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","ᐋᒄ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᒥᒄ ᐐᔨᐙᐤ ᑳ ᒫᒥᑐᓈᔨᒦᓱᔨᒡ ᒥᑐᓐ ᑳᐦ ᐋᑎ ᐙᔨᐦᑎᒥᔨᒡ ᑖᑆᐎᓂᔨᐤ, ᐱᔑᒄ ᒫᒃ ᑳ ᒥᒋᐦᑑᑎᒥᔨᒡ, ᐋᔨᐅᑯᓐ ᐅᔮᔨᐤᐦ ᒫᐅᒡ ᐋᐦᒀᒡ ᒑ ᐄᔑ ᑎᐹᔅᑯᓈᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","ᒥᓯᐙ ᐊᓂᒌ ᑳ ᒥᒑᑎᓰᔨᒡ ᒥᔥᑏᐦ ᒋᑭ ᐅᑎᐦᑎᐦᐅᑯᒡ ᓂᓈᐦᑳᑖᔨᒧᐎᓂᔨᐤ ᑭᔮᐦ ᑭᑎ ᐱᑎᑯᔥᑳᑰᐎᒡ ᐋᔨᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᓃᔥᑎᒻ ᑭᑎ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ ᐋᒄ ᒦᓐ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ᐊᓂᔮᔨᐤ ᒫᒃ ᒨᔥ ᑳ ᒥᔪᑐᑎᒥᔨᒡ ᐋᔨᐅᑯᓐ ᐊᓂᔮᔨᐤᐦ ᒑ ᒥᔪ ᑭᓂᐙᐱᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᒋᑭ ᒋᔅᑖᒋᒫᐤ ᑭᔮᐦ ᒋᑭ ᒥᔮᐤ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ᐊᓂᔮᔨᐤᐦ ᓃᔥᑎᒻ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒋᑭ ᑐᑎᐙᐤ ᐅᔮᔨᐤ ᐋᒄ ᒦᓐ ᐊᓂᔮᔨᐤᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","ᐙᔥ ᒥᓯᐙ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᐹᔨᑯᓂᐦᒡ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒋᔖᒥᓂᑑᐦ ᑳ ᒥᔮᔨᒡ ᐊᓂᔮᔨᐤᐦ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᑭᑎ ᐎᓂᔑᓂᒡ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒥᒋᐦᑑᑎᐦᒡ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑭᑎ ᐅᐦᒋ ᐋᐱᑎᓂᔨᐤ ᑎᐹᔅᑯᓈᑭᓄᑣᐙ᙮ ᐊᓂᒌ ᒫᒃ ᐐᔨ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᒋᔅᒑᔨᐦᑎᒧᒡ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᒥᒋᐦᑑᑎᒧᒡ ᒫᒃ ᑭᔮᐦ ᐐᔨᐙᐤ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒑ ᐋᐱᑎᓃᔨᒡ ᑎᐹᔅᑯᓂᑯᑣᐙ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","ᐙᔥ ᑖᐹ ᐊᓂᑎᐦ ᐋ ᐹᐦᑎᐦᒃ ᐊᐙᓐ ᐐᔓᐙᐎᓂᔨᐤ ᑭᑎ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᓲ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᑐᑎᐦᑳ ᑖᓐ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᐊᓂᑎᐦ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","ᐊᓂᒌ ᒫᒃ ᐐ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᓂᒧᐃ ᐃᔮᐅᒡ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤᐦ᙮ ᒥᒄ ᒫᒃ ᑎᐱᔨᐙ ᐊᓂᑎᐦ ᐋᐦ ᑖᒡ ᐋ ᐅᐦᒋᐱᔨᔨᒡ ᒑ ᒌᐦ ᑐᑎᐦᒡ ᑖᓐ ᐋᐦ ᐄᑎᔓᒧᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᐋᑯᑖᐦ ᐙᐦᒋ ᓅᑯᓃᔨᒡ ᐋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᒑ ᑎᐙᑯᐱᓈ ᑭᔮᐦ ᑖᓂᔮᔨᐤ ᐋᑳ ᒑ ᑎᐙᑯᐱᓈ ᐋᐦ ᐋᑦ ᐋᑳ ᐃᔮᒡ ᒎᐤ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ᐋᑯᑖᐦ ᒫᒃ ᐙᐦᒋ ᓅᑯᓃᔨᒡ ᐋᐦᑎᑯᓃᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ ᐅᑖᐦᐄᐙᐦᒡ ᐊᓂᔮᔨᐤ ᐋ ᐎᔨᔓᒥᑯᒡ ᑖᓐ ᒋᐱᐦ ᐄᔑ ᐱᒫᑎᓰᐎᒡ ᑭᔮᐦ ᒫᒃ ᑎᑯᓂᔨᐤ ᐊᓂᑎᐦ ᐙᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓐ ᒋᐱᐦ ᐄᔑ ᐱᒫᑎᓰᐎᒡ᙮ ᒋᔅᒑᔨᐦᑎᒧᒡ ᒫᔫᑑᑎᒧᐙᒀ ᑭᔮᐦ ᒫᒃ ᒫᒋᑑᑎᒧᐙᒀ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","ᐋᒄ ᒫᒃ ᐄᔥᐱᐦ ᒋᔖᒥᓂᑑ ᑎᐹᔅᑯᓈᒑ ᒥᓯᐙ ᐊᐙᔨᐤᐦ, ᒌᓴᔅ ᙭ ᐅᐦᒋ, ᑖᓐ ᑳ ᐄᔑ ᒌᒧᒡ ᐄᑖᔨᐦᑎᒥᔨᒡ ᐋᑯᑖᐦ ᒑ ᓅᑯᓃᔨᒡ ᐊᓐ ᐊᐙᓐ ᑖᑆᐦ ᑳᐦ ᑐᑎᒧᒀ ᑖᓐ ᐋᐦ ᐄᑎᔓᒧᐙᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐋᐅᒄ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᐆ ᒥᔻᒋᒧᐎᓐ ᐐᔨ ᐙᐐᐦᑎᒫᑎᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ᒌᔨ ᒫᒃ ᐐ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓯᔨᓐ ᒀᔣᓐ ᒋᑎᐄᑖᔨᐦᑎᓈᒑ ᐋ ᒥᔪ ᑭᓂᐙᐱᒥᔅᒃ ᒋᔖᒥᓂᑑ ᒥᒄ ᐊᓂᔮᔨᐤ ᐋ ᒋᔅᒑᔨᐦᑎᒧᑦ ᒎᐤ ᐅᐐᔓᐙᐎᓐᐦ᙮ ᑭᔮᐦ ᒌ ᒫᒥᐦᒋᒧᓐ ᒋᔖᒥᓂᑑ ᐋ ᐅᑏᔨᔨᒥᑖᔅᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","ᒋᒋᔅᒑᔨᒫᐤ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᒥᔅᒃ ᒑ ᒌ ᐄᔑ ᐱᒫᑎᓰᐎᑦ ᒋᔖᒥᓂᑑ᙮ ᐅᐐᔓᐙᐎᓂᐦᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᓐ ᑖᓐ ᒋᐱᐦ ᐄᔑ ᐱᒫᑎᓰᓐ ᑭᔮᐦ ᑖᓐ ᐊᓐ ᐋᑳ ᒋᐱᐦ ᐅᐦᒋ ᐄᔑ ᐱᒫᑎᓰᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ᒋᒑᔥᑎᓈᐦᐅᓐ ᑭᔮᐦ ᒑ ᒌ ᒥᔪ ᒋᔅᒋᓄᐦᑎᐦᐄᑣᐤ ᐊᓂᒌ ᐋᑳ ᑳ ᐙᐱᐦᑎᐦᒡ᙮ ᒋᒑᔥᑎᓈᐦᐅᓐ ᑭᔮᐦ ᐙᔥᑖᐎᓂᐦᒡ ᒑ ᒌ ᐃᓯᓈᑯᓯᔅᑐᑣᐤ ᐊᓂᒌ ᐊᐅᑳᔥᑖᔮᐎᓂᐦᒡ ᑳᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ᒋᒑᔥᑎᓈᐦᐅᓐ ᐋ ᐃᓯᓈᑯᐦᒡ ᒑ ᒌ ᑯᐃᔅᑯᓂᑣᐤ ᐊᓂᒌ ᓈᔥᒡ ᐋᑳ ᑳ ᐊᔨᑖᔨᐦᑎᐦᒡ, ᑭᔮᐦ ᒌ ᒑᔥᑎᓈᐦᐅᓐ ᐋ ᐃᓯᓈᑯᐦᒡ ᒑ ᒌ ᒋᔅᒋᓂᐦᐊᒧᑣᐤ ᐊᐙᔑᔑᒡ᙮ ᐋ ᐃᔮᔨᓐ ᐆ ᐐᔓᐙᐎᓐ ᒋᑎᐄᑖᔨᐦᑖᓐ ᒥᓯᐙ ᒑᒀᓐ ᐋ ᒋᔅᒑᔨᐦᑎᒥᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᒋᔅᒑᔨᐦᑎᒥᓐ ᑖᑆᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ᒋᒋᔅᑯᑎᒧᐙᐅᒡ ᐄᔨᔨᐅᒡ᙮ ᓂᒧᐃ ᐋ ᒌᔨ ᑭᔮᐦ ᒋᒋᔅᑯᑎᒫᓱᓐ? ᒋᑭᒑᔅᒋᒧᐙᓐ ᐋᑳ ᒑ ᒌ ᑭᒑᒧᑎᒃ ᐊᐙᓐ᙮ ᒌᔨ ᒫᒃ ᐐ ᒑᔥᑎᓈᔥ ᐋ ᓂᒧᐃ ᒋᑭᒑᒧᑎᓐ? ");
INSERT INTO crl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","ᒋᔑᓐ ᑭᔮᐦ ᐋᑳ ᒑ ᐱᓯᒀᑎᓰᑦ ᐊᐙᓐ᙮ ᒌᔨ ᒫᒃ ᐐᐦ ᒑᔥᑎᓈᔥ ᐋ ᓂᒧᐃ ᒋᐱᓯᒀᑎᓰᓐ? ᑰᐦᑳᑖᐅᒡ ᒥᓂᑑᐦᑳᓂᒡ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᐋ ᒋᑭᒑᒧᑎᓐ ᐊᓂᑎᐦ ᐊᔨᒥᐦᐋᐅᑭᒥᑯᐦᒡ ᑖᓂᑖᐦ ᐊᔨᒥᐦᐋᔅᑎᐙᑭᓂᐎᒡ ᒥᓂᑑᐦᑳᓂᒡ? ");
INSERT INTO crl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","ᒦᓐ ᑯᑎᒡ ᒑᒀᓐ᙮ ᓈᔥᒡ ᒋᐐᐦ ᓂᓈᐹᐅᒧᓐ ᐋ ᐃᔮᐙᑦ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ᙮ ᒥᒄ ᒫᒃ ᓄᐎᒡ ᒋᒫᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑎᒧᑦ ᐅᐐᔓᐙᐎᓐᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᒀᒋᔥᑖᒡ, ᒌᔨᐙᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔮᒄ, ᒌᔨᐙᐤ ᒌᐦ ᑐᑎᐙᐙᐅᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌ ᒥᒋᐋᔨᒨᒫᒡ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","ᒎᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᔨᓐ ᒋᒌ ᒋᔅᒋᓄᐙᒋᔓᑭᐎᓐ ᒑ ᒌ ᒋᔅᒑᔨᒥᑭᐎᔨᓐ ᒋᔖᒥᓂᑑ ᐋ ᐅᑏᔨᔨᒥᑖᔅᒃ᙮ ᓂᓂᐦᐄᐦᑎᒧᑖ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ ᒋᑭ ᐐᒋᐦᐄᑯᓐ ᑖᑆᐦ ᒋᔅᒋᓄᐙᒋᔓᐙᐎᓐ᙮ ᐋᑳ ᒫᒃ ᓂᓂᐦᐄᐦᑎᒧᑖ ᐅᐐᔓᐙᐎᓐ ᓂᒧᐃ ᐋᐱᑎᓐ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔓᑭᐎᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","ᐊᓐ ᐊᐙᓐ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᑦ ᑭᔮᐦ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᓂᓂᐦᐄᐦᑎᐦᑳ ᐐᔓᐙᐎᓂᔨᐤ ᒋᑭ ᒥᔪ ᑭᓂᐙᐱᒥᑰ ᒋᔖᒥᓂᑑ, ᒧᔮᒻ ᑖᑆᐦ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐋᔪᐎᒄ ᒑ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔮᒄ ᒑ ᓂᔑᐎᓈᒋᒥᑖᑯᒡ ᐅᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐙᔥ ᑖᐹ ᒋᓂᓂᐦᐄᐦᑎᒸᓈᐙᐤ ᒌᔨᐙᐤ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ ᐋᑎ ᒌᔨᐙᐤ ᐋ ᐃᔮᐙᒄ ᐋ ᒌ ᒥᓯᓂᐦᐄᑭᓂᐎᔨᒡ ᑭᔮᐦ ᒫᒃ ᐋᑎ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔓᑯᐎᔮᒄ᙮ ᐐᔨᐙᐤ ᒫᒃ ᐅᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᓂᓂᐦᐄᐦᑎᒧᒡ ᐐᔓᐙᐎᓂᔨᐤ ᐋᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔓᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","ᐊᐙᓐ ᑖᑆᐦ ᒎᐤ ᐋᐦ ᑖᑦ, ᓂᒧᐃ ᐐᔨ ᐊᓐ ᒥᒄ ᒎᐤ ᐋ ᐃᓯᓈᑯᓯᑦ᙮ ᓂᒧᐃ ᐐᔨ ᒥᒄ ᐊᓂᔮᔨᐤ ᐋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐊᐙᓐ ᐐᔮᐦᒡ ᐙᐦᒋ ᐅᑏᔨᔨᒥᑖᑯᑦ ᒋᔖᒥᓂᑑᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","ᐊᓐ ᐊᐙᓐ ᑖᑆᐦ ᒎᐤ ᐋᐦ ᑖᑦ ᓅᑯᓂᔨᐤ ᐊᓂᑖᐦ ᐲᐦᒡ ᐅᐱᒫᑎᓰᐎᓂᐦᒡ᙮ ᑖᑆᐦ ᐋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐊᐙᓐ ᒥᓂᓯᑭᓄᔨᐤ ᐆ ᒥᒋᐦᑣᐎᓐ ᐅᑖᐦᐄᒡ ᐅᐦᒋ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᐅᐦᒋ, ᓂᒧᐃ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᑳ ᒥᓯᓂᐦᐄᑭᓂᐎᒡ ᐋ ᒌ ᓂᓃᔨᐦᑎᐦᒡ᙮ ᐅᔮᔨᐤ ᒫᒃ ᐊᐙᓐ ᐋ ᐄᑖᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐋᔨᐅᑯᓐ ᓈᑎᐙᔨᒫᑦ ᒑ ᒌ ᒥᒥᔻᒋᒥᑯᑦ, ᓂᒧᐃ ᓵᐹᐄᔨᐦᑎᒻ ᐋ ᒥᒥᔻᒋᒥᑯᑦ ᓈᐹᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","ᑖᓐ ᒫᒃ ᐄᔑ ᔮᐦᐱᒡ ᒎᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ ᐊᐙᓐ? ᑖᓐ ᐄᔑ ᔮᐦᐱᒡ ᐋᑎ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐊᐙᓐ? ");
INSERT INTO crl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ᒥᔥᑏᐦ ᑭᔨᑆ ᒑᒀᓐ ᐄᑖᔨᐦᑖᑯᓐ ᒎᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᑦ ᐊᐙᓐ᙮ ᓃᔥᑎᒻ ᒫᒃ ᒑᒀᓐ, ᐋᐅᑯᓂᒡ ᐅᒌ ᐄᔨᔨᐅᒡ ᑖᐱᒑᔨᐦᑖᑯᓯᐎᒡ ᑳ ᒥᔮᑭᓂᐎᒡ ᒑ ᒌ ᒥᔪᑭᓄᐙᔨᐦᑎᒡ ᒋᔖᒥᓂᑑ ᐅᑎᔨᒧᐎᓂᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","ᐹᔅᒡ ᐋᑳ ᑏᔮᑆᐅᒑᔨᐦᑖᑯᓲᐙᒀ, ᐋᐤ ᐋ ᒫᒃ ᓂᒥ ᑖᑆᐅᒑᔨᐦᑖᑯᓯᐤ ᑭᔮᐦ ᐐᔨ ᒋᔖᒥᓂᑑ? ");
INSERT INTO crl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ᓂᒧᐃ ᑭᔨᑆ, ᓂᒧᐃ ᒥᑐᓐ ᐃᓯᓈᑯᓂᔨᐤ ᐋᑳ ᒫᒨᔮᒻ ᒑ ᒌ ᑎᒃ ᒋᔖᒥᓂᑑ᙮ ᑖᑆᐤ ᐐᔨ ᒋᔖᒥᓂᑑ ᐋᑎ ᒥᓯᐙ ᑯᑎᒃ ᐊᐙᓐ ᐋ ᓂᓂᑎᔨᑦ᙮ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐐᔨ ᒋᔖᒥᓂᑑ ᐋᐦ ᐋᔨᒨᒫᑭᓅᑦ, ᐊᔨᒦᓈ ᒫᒃ ᒋᑭ ᓅᑯᓐ ᐋ ᑖᑆᔨᓐ᙮ ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᒋᑭ ᒋᔅᒑᔨᐦᑎᒻ ᐋ ᑖᑆᔨᓐ ᑎᐹᔅᑯᓂᑭᐎᓈ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","ᒫᒃ ᒌ ᐹᒋ ᐃᔨᐤ ᐊᐙᓐ, “ᐋ ᒥᒋᐦᑐᑎᒥᐦᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᐊᑎᑎᐤ ᐱᔮᑭᔅᒡ ᐙᐱᐦᑎᒸᒡ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑᐦ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᓂᔨᐤᐦ᙮ ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᒫᑯᐦᐄᑖᒄ ᒋᔖᒥᓂᑑ ᐋ ᒥᒋᐦᑐᑎᒥᐦᒄ? ᓂᒧᐃ ᑭᔨᑆ ᑯᐃᔅᒄ ᐃᔨᐦᑐ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᐋᐦ ᑐᑖᑎᐦᒄ᙮” ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐃᔮᒡ ᐱᔅᒡ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","ᓂᒧᐃ ᒫᒃ ᐙᐙᒡ ᐆ ᒋᐱᐦ ᐅᐦᒋ ᐄᔑ ᐊᔨᒥᓈᓂᐤ᙮ ᐋᑳ ᐎᔮᔅ ᑐᑎᐙᒑ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ ᐋ ᒥᒋᐦᑑᑎᒥᔨᒡ, ᑭᑎ ᒌ ᑎᐹᔅᑯᓂᒻ ᐋ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ? ");
INSERT INTO crl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ᒌ ᐹᒋ ᐃᔨᐤ ᐊᐙᓐ, “ᒑᒀᓐ ᒫᒃ ᒑ ᐅᐦᒋ ᑎᐹᔅᑯᓂᑭᐎᔮᓐ ᐊᓐ ᐅᐦᒋ ᐋ ᒥᒋᑣᐄᔨᔨᐅᔮᓐ, ᐊᓂᑎᐦ ᐙᒋ ᐊᑎᑎᐤ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓅᑦ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐅᐦᒋ?” ");
INSERT INTO crl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ᒑᒀᓐ ᒑ ᐅᐦᒋ ᐋᑳ ᒌ ᐃᔨᐦᒄ, “ᒥᒋᐦᑑᑎᐦᑖᐤ ᒑ ᒌ ᐅᐦᒋᐲᔨᒡ ᐋ ᒥᔻᓰᔨᒡ?” ᓂᒌ ᒫᔮᔨᒥᑯᓈᓂᒡ ᑯᑎᑭᒡ ᐄᔨᔨᐅᒡ ᓂᑎᐐ ᒥᒄ ᐋ ᒌ ᐄᔑ ᒫᒥᔒᒥᔨᒥᐦᒡ, ᐋ ᒌ ᐃᔒᒥᐦᒡ ᐅᔮᔨᐤ ᐋ ᒌ ᐃᔨᔪᐎᒋᐦᒡ᙮ ᑖᑆᐦ ᒫᒃ ᒋᑭ ᑎᐹᔅᑯᓈᑭᓂᐎᒡ ᐅᒌ ᐙᔥ ᐊᔨᐆᒄ ᐊᓯᓈᑯᓃᒡ ᒑ ᒌᐦ ᑐᑎᐙᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","ᐄᔑ ᑯᒀᒋᐦᒑᔨᒧᑦ ᒫᐦ ᐊᐙᓐ, ᐊᐅᔅᑖ ᐋ ᒌᔮᓂᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᐦᒄ ᒋᑎᑖᔨᒥᑯᓂᐤ ᒋᔖᒥᓂᑑ ᐋᑖᔨᒫᑦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ? ᓂᒧᐃ ᑭᔨᑆ᙮ ᔖᔥ ᒋᒌ ᐐᐦᑎᒫᑎᓈᐙᐤ, ᒥᓯᐙ ᐊᐙᓐ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓯᑦ ᑭᔮᐦ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᑦ ᑎᐹᔨᒥᑰ ᒥᒋᐦᑣᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᒧᐃ ᐊᐙᓐ ᑯᐃᔅᑯᑖᑎᓰᐤ᙮ ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᐙᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᐙᓐ ᓂᔅᑐᐦᑎᒻ ᑖᑆᐎᓂᔨᐤ᙮ ᓂᒧᐃ ᐙᐙᒡ ᐹᔨᒄ ᐊᐙᓐ ᐐᐦ ᒋᔅᒑᔨᒫᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","ᒥᓯᐙ ᐊᐙᓐ ᒌ ᐱᒋᔅᑎᓵᐱᒫᐤ ᒋᔖᒥᓂᑑ᙮ ᒥᓯᐙ ᐊᐙᓐ ᓂᒥ ᒑᒀᓐ ᐄᑖᔨᐦᑖᑯᓯᐤ᙮ ᓂᒧᐃ ᑖᐤ ᐊᐙᓐ ᑯᐃᔅᒄ ᐋᐦᑎᒃ, ᐙᐙᒡ ᐋᑦ ᒥᒄ ᐹᔨᒄ ᐊᐙᓐ ᒑ ᒌ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ᓂᐱᐦᐄᐙᒥᑭᓂᔨᐤ ᐅᑎᔨᒧᐎᓂᐙᐤ᙮ ᐱᔑᒄ ᐎᓂᐱᐦᐄᐙᐅᒡ ᑖᓐ ᐋᐦ ᐃᔨᒡ᙮ ᒧᔮᒻ ᐊᒋᓈᐱᒄ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐅᐱᐦᒋᐴᔨᐙᐎᓐ ᐋᐅᒄ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐅᑎᔨᒧᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ᐱᔑᒄ ᐎᔮᔅᑖᔨᑎᒧᑖᑯᓯᐎᒡ᙮ ᑭᔮᐦ ᐱᔑᒄ ᐙᐐᐦᒀᑖᐅᒡ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ᓈᔥᑖᑆᐦ ᒋᔨᐱᐎᒡ ᒑ ᒌ ᓂᓈᐦᑳᒋᐦᐋᒡ ᐊᐙᔨᐤᐦ ᑭᔮᐦ ᒑ ᒌ ᐋᑎ ᓂᐱᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ᑖᓂᑖᐦ ᒥᒄ ᐋᑦ ᐄᐦᑖᒡ ᒨᔥ ᐋᐦᑯᐦᐋᐅᒡ ᐊᐙᔨᐤᐦ᙮ ᑭᔮᐦ ᒨᔥ ᑎᑯᓂᔨᐤ ᐋ ᐄᔑ ᐎᓈᒋᐦᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ᓂᒧᐃ ᒋᔅᒑᔨᐦᑎᒨᒡ ᑖᓐ ᒑ ᑎᒡ ᒑ ᒌ ᒥᔪ ᐐᒑᐙᒡ ᐊᐙᔨᐤᐦ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᒡ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ᓂᒧᐃ ᒥᑐᓐ ᓂᓂᐦᒌᔥᑐᐙᐅᒡ ᒋᔖᒥᓂᑑ᙮ ᐋᐅᒄ ᐊᓐ ᐋᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᐊᓂᒌ ᑳ ᒥᔮᑭᓂᐎᒡ ᐅᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ ᒋᐱᐦ ᓂᓂᐦᐄᐦᑎᒧᒡ ᒥᓯᐙ ᑖᓐ ᐋᐦ ᐄᑎᔓᐙᒥᑭᓃᔨᒡ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᒑ ᐅᐦᒋ ᐋᑳ ᒥᑐᓐ ᒌ ᐃᔨᑦ ᐊᐙᓐ ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐋ ᒌ ᒥᒋᐦᑐᑎᐦᒃ ᑭᔮᐦ ᒫᒃ ᐋᔪᐎᒄ ᐙᐦᒋ ᒥᓯᐙ ᐊᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᒌ ᑎᐹᔅᑯᓂᑯᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","ᐙᔥ ᑖᐹ ᐊᐙᓐ ᒌ ᑯᐃᔅᑯᓈᑯᐦᐄᓲ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ ᒥᒄ ᐊᓂᔮᔨᐤ ᐋ ᓂᓃᐦᑎᐦᒃ ᐐᔓᐙᐎᓐ᙮ ᒌ ᒋᔅᒑᔨᐦᑖᓐ ᐋ ᑖᓐ ᐋᑖᐱᑎᐦᒡ ᐅᐦᐄ ᐐᔓᐙᐎᓐ? ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᐦᒃ ᐊᐙᓐ ᐋ ᒥᒋᐦᑐᑎᐦᒃ ᐋᐅᒄ ᐋᑖᐱᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ᐊᓅᐦᒡ ᒫᒃ ᐋᒄ ᓅᑯᐦᑖᑦ ᒋᔖᒥᓂᑑ ᑖᓂᑖᐦ ᐙᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐐᔨ ᐄᔑ ᐋᐦ ᑖᑦ᙮ ᓂᒥᔮᔨᐤ ᒫᒃ ᐐᔨ ᐋ ᓂᓃᐦᑎᐦᒃ ᐊᐙᓐ ᑭᔮᐦ ᐋᐦ ᑐᑎᐦᒃ ᒎᐤ ᐐᔓᐙᐎᓂᔨᐤ ᐙᐦᒋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᐐᔓᐙᐎᓂᐦᒡ ᐊᓂᑖᐦ ᐹᒋ ᐙᔥᑭᒡ ᐋᑯᑖᐦ ᐙᐦᑖᑯᐦᒡ ᐊᐙᓐ ᒑ ᒌ ᑯᐃᔅᑯᓈᑯᓯᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᐊᓂᔮᐦᑳ ᒫᒃ ᐅᒋᔅᒋᐙᐦᐄᒑᓱᒡ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐐᐦᑎᐦᒡ ᐐᔨᐙᐤ ᑭᔮᐦ ᐋᔪᐎᒄ ᑳ ᐄᑎᓯᑖᔨᒡ ᒎᐤ ᐎᓲᐙᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅ ᙭᙮ ᐙᔥ ᒥᓯᐙ ᐹᔨᑯᓂᐦᒡ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᐊᐙᔨᐤᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ᒥᓯᐙ ᐊᐙᓐ ᒌ ᒥᒋᐦᑐᑎᒻ᙮ ᐋᑯᑖᐦ ᒫᒃ ᐙᐦᒋ ᒥᓯᐙ ᐊᐙᓐ ᓅᐦᑖᔥᑭᒸᑦ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓱᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ᐊᓂᔮᔨᐤ ᓵᐦᒑᐄ ᐋ ᐄᔑ ᒥᔮᑦ ᐋ ᒋᔖᐙᑐᑎᐙᑦ ᐊᐙᔨᐤᐦ ᒋᔖᒥᓂᑑ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᙭ ᒌᓴᔅ᙮ ᙭ ᒌᓴᔅ ᒌ ᐄᒑᓂᒧᐙᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒥᑯᑦ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᐄᔑ ᑎᐹᔅᑯᓂᑯᔨᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","ᐙᔥ ᒋᔖᒥᓂᑑ ᒌ ᐱᒋᔅᑎᓈᐤ ᒌᓴᔅᐦ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ ᒑ ᒌ ᐅᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᔨᒡ ᐊᐙᔨᐤᐦ ᐅᒥᒋᑣᐎᓂᔨᐤ᙮ ᐋ ᑖᑆᔮᔨᒫᑦ ᒫᒃ ᐊᐙᓐ ᒌᓴᔅᐦ ᐅᒥᐦᑰᔨᐦᒡ ᐅᐦᒋ, ᐋᑯᑖᐦ ᐙᐦᒋ ᐙᐹᔨᐦᑎᒧᐙᑭᓅᑦ ᐅᒥᒋᐦᑣᐎᓐ᙮ ᒋᔖᒥᓂᑑ ᒌᐦ ᑐᑎᒻ ᐅᔮᔨᐤ ᒑ ᒌ ᐙᐱᐦᑏᐙᑦ ᒨᔥ ᑯᐃᔅᒄ ᐋᐦᑎᒃ᙮ ᐅᑖᐦ ᐄᔑ ᐅᑖᐦᒡ ᓈᔥᑖᑆᐦ ᒌ ᓰᐱᔨᐙᓰᔅᑖᒑᐤ ᒋᔖᒥᓂᑑ ᑖᓐ ᑳ ᐄᔑ ᒥᒌᐦᑐᑖᑭᓂᐎᔨᒡ᙮ ᓂᒧᐃ ᒨᔥ ᓂᐦᐋᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᐄᔑ ᑎᐹᔅᑯᓂᒫᑭᓂᐎᔨᒡ ᐊᐙᔨᐤᐦ ᐅᐦᒋ ᐄᔑ ᑎᐹᔅᑯᓈᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ᐙᐱᐦᑏᔨᐙᐤ ᐊᓅᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᑯᐃᔅᒄ ᑎᒃ ᑭᔮᐦ ᒫᒃ ᑖᑆᐦ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᐋ ᐄᔑ ᑭᓂᐙᐱᒫᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","ᑖᓐ ᒫᒃ ᒑ ᒌ ᐄᔑ ᓂᓈᐹᐅᒧᑦ ᐋᒄ ᐊᐙᓐ? ᓂᒧᐃ ᒥᑐᓐ ᑎᑯᓂᔨᐤ ᑖᓐ ᒑ ᒌ ᐄᔑ ᓂᓈᐹᐅᒧᑦ᙮ ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᐃᔨᐤ ᐋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᒥᒄ ᐋ ᓂᓃᐦᑎᐦᒃ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᐙᔥ ᐋ ᑖᑆᔮᔨᒫᑦ ᐊᐙᓐ ᒌᓴᔅᐦ ᐋᑯᑖᐦ ᒥᒄ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","ᐋᐅᒄ ᒫᒃ ᐆ ᐋ ᐄᔑ ᐐᐦᑎᒥᐦᒄ᙮ ᐋ ᑖᑆᔮᔨᐦᑎᐦᒃ ᐊᐙᓐ ᐋᑯᑖᐦ ᒥᒄ ᐙᐦᒋ ᐃᓯᓈᑯᓃᔨᒡ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ, ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᐋ ᓂᓂᐦᐄᐦᑎᒸᑦ ᐅᐐᔓᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","ᐋᒄ ᒫᒃ ᒥᒄ ᐋ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐙᒋᔖᒥᓂᑑᒥᒡ ᒋᔖᒥᓂᑑ? ᓂᒧᐃ ᐋ ᑭᔮᐦ ᐐᔨᐙᐤ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐅᒋᔖᒥᓂᑑᒨᒡ ᒋᔖᒥᓂᑑ? ᑭᔨᑆ ᑭᔮᐦ ᐐᔨᐙᐤ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᐙᒋᔖᒥᓂᑑᒥᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","ᐙᔥ ᐹᔨᑯᓯᐤ ᒥᒄ ᒋᔖᒥᓂᑑ, ᑖᐱᔥᑯᓐ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᒋᑭ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᑎᔮᑆᔮᔨᒫᔨᒀᓂᐦᐄ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","ᐋᐤ ᐋ ᒫᒃ ᐎᔮᐱᓂᒥᐦᒄ ᐐᔓᐙᐎᓐ ᐋᐦ ᐄᔨᔨᐦᒄ ᒥᒄ ᐋ ᑖᑆᔮᔨᒫᑦ ᐊᐙᓐ ᒌᓴᔅᐦ ᐋ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐋᑭᓅᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ? ᓂᒧᐃ ᑭᔨᑆ᙮ ᑎᔨᑯᒡ ᒌᐦᑳᔮᔨᐦᑖᑯᐦᑖᓈᓂᐤ ᑖᓐ ᐙᒋᐦᒡ ᐋᑖᐱᑎᐦᒡ ᐊᓐ ᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ᐋᒄ ᒫᒃ ᒋᐱᐦ ᐊᔨᒨᒫᓂᐤ ᐊᓂᔮ ᐋᓂᔅᒑ ᒋᐙᐦᑯᒫᑭᓂᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐋᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","ᐙᔥ ᒥᔔ ᑳ ᑯᐃᔅᑯᓈᑯᐦᐋᑭᓅᒀ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ ᐋ ᒥᔪᑐᑎᐦᒃ, ᒋᐱᐦ ᑎᑯᓂᔨᐤ ᑖᓐ ᒑ ᒌ ᐄᔑ ᒫᒥᐦᒋᒨᑯᐱᓈ᙮ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᒫᒥᐦᒋᒧᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","ᑖᓐ ᐋᑎᔥᑖᒡ ᒫᒃ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ? ᐊᒀᒋᔥᑖᒡ, ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒌ ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","ᑭᓂᐙᐱᐦᑎᒧᒄ ᑖᓐ ᐋ ᐃᓯᓈᑯᐦᒡ ᐊᐙᓐ ᐋᐦ ᐋᐱᑎᓰᑦ᙮ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᐱᑎᓰᑦ ᑭᔮᐦ ᐋ ᑎᐱᐦᐋᒧᐙᑭᓅᑦ ᓂᒧᐃ ᓵᐦᒑᐄ ᒥᔮᑭᓂᐤ ᐊᓂᔮᔨᐤ ᐅᑎᐱᐦᐊᒫᑯᓰᐎᓐ᙮ ᐋᔨᐱᓂᒡ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐋᐱᑎᓰᑦ ᐙᐦᒋ ᒥᔮᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","ᒫᒥᑐᓈᔨᒫᑖᐤ ᒫᐦ ᐊᐙᓐ ᑳ ᒥᒑᑎᓰᑦ᙮ ᐊᓂᔮᔨᐤ ᐋ ᒥᔪᑐᑎᐦᒃ ᐋᐅᑦᐦ ᐋ ᐙᐦᒋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᐋ ᐄᔑ ᑳᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ? ᓂᒫ, ᐋ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐋᑯᑖᐦ ᒥᒄ ᒑ ᒌ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᓯᑦ ᐊᐙᓐ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ, ᐊᓐ ᐎᔮᐹᔨᐦᑎᒨᐙᑦ ᐊᐙᓐ ᐅᒥᒋᐦᑣᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᐋᔨᒨᑎᐦᒃ ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ᙮ ᒌ ᐋᔨᒨᒫᐤ ᐋ ᐃᔥᐱᔥ ᔑᐙᔨᐦᑖᑯᓰᔨᒡ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᑳ ᐄᔑ ᑭᓂᐙᐱᒥᑯᔨᒡ ᒋᔖᒥᓂᑑ᙮ ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᔪ ᐋᐱᑎᔒᒡ ᐙᐦᒋ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐄᔑ ᑭᓂᐙᐱᒥᑯᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ᑳᐦ ᐃᔨᑦ ᐆ ᒋᐦᒋᐅᒋᒫᐤ, ᑖᑆᐦ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐙᐹᔨᐦᑎᒫᑯᒡ ᒋᔖᒥᓂᑑ ᐅᐎᓂᑐᑎᒧᐎᓂᐙᐤ, ᐊᓂᒌ ᑳ ᐄᒑᓂᒧᐙᑭᓂᐎᒡ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ᑖᑆᐦ ᔑᐙᔨᐦᑖᑯᓲ ᐊᓐ ᐊᐙᓐ ᑖᑭᔥ ᒋᐦᒋᐙ ᒑ ᑳᔒᔑᓂᐦᐋᑭᓂᐎᒡ ᐅᒥᒋᐦᑣᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ᒥᒄ ᐋ ᒫᒃ ᐊᓂᒌ ᑳ ᒋᔅᒋᓄᐙᒋᔣᑭᓂᐎᒡ ᒋᑭ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ? ᓂᒫ᙮ ᐊᓂᒌ ᐋᑳ ᑳ ᒋᔅᒋᓄᐙᒋᔣᑭᓂᐎᒡ ᒋᑭ ᔑᐙᔨᐦᑖᑯᓯᐎᒡ᙮ ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᒥᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ ᐋ ᑯᐃᔅᑯᑖᑎᓰᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","ᑖᔨᔥᐱᔥ ᒫᒃ ᑳ ᐄᑖᒋᒫᑭᓅᑦ ᐅᔮᔨᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ, ᐋᒸᔮ ᐋ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᑭᔮᐦ ᒫᒃ ᔖᔥ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ? ᐋᒸᔮ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐋᑯᑖᐦ ᑳ ᐄᑖᒋᒫᑭᓅᑦ ᐅᔮᔨᐤ, ᓂᒧᐃ ᐐᔨ ᐹᑎᔥ ᑳ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","ᐹᑎᒫ ᒫᒃ ᐋ ᒌ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑖᑯᐦᑖᑭᓂᐎᔨᒡ ᐋ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ᙮ ᔖᔥ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑰᑖᑯᐱᓐ ᐋᒸᔮ ᐙᐙᒡ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔣᑭᓅᑦ᙮ ᐋᒄ ᒫᒃ ᐋᒀᔑᓈᑯᓯᑦ ᐋ ᐅᐦᑖᐐᒥᑯᑦ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᒫᔨᒡ ᒋᔖᒥᓂᑑ, ᐊᓂᔮᔨᐤ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᑳ ᐄᔑ ᑭᓂᐙᐱᒥᑯᔨᒡ ᒋᔖᒥᓂᑑ, ᐋᐦ ᐋᑦ ᐋᑳ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔓᒫᑭᓂᐎᔨᒡ ");
INSERT INTO crl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳ ᒋᔅᒋᓄᐙᒋᔓᒫᑭᓂᐎᔨᒡ ᐅᐦᑖᐐᒥᑰ, ᓂᒥᔮᔨᐤ ᒥᒄ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒋᔅᒋᓄᐙᒋᔓᒫᑭᓂᐎᔨᒡ, ᒥᒄ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳ ᐃᔮᔨᒡ ᐋᐦ ᐋᑦ ᐋᑳ ᐋᒸᔮ ᐅᐦᒋ ᒋᔅᒋᓄᐙᒋᔣᒫᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐊᓂᑎᐦ ᐋᐦ ᑖᑦ ᒑ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ, ᒑᔥᑎᓈᔥ ᑖᑆᐦ ᒑ ᐊᔓ ᒥᔮᑦ ᒥᓯᐙ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳ ᐄᔨᔨᒡ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒫᑯᑦ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᐋ ᓂᓃᐦᑎᐦᒃ ᐐᔓᐙᐎᓂᔨᐤ ᐙᐦᒋ ᐄᑎᑯᑦ ᐅᔮᔨᐤ ᒑ ᑐᑎᒫᑯᑦ᙮ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒫᒃ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᐋ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᑐᑎᒫᑯᑦ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","ᐙᔥ ᐋᔑᓈᑯᓂᒀ ᒥᒄ ᐊᓂᒌ ᑳ ᓂᓂᐦᐄᐦᑎᐦᒡ ᐐᔓᐙᐎᓂᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᐊᔓ ᒥᔨᑯᐎᔨᐦᒄ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦᐄᑦ ᒑᔅᑎᓈᒡ ᒑ ᒥᔨᐙᑦ, ᐋᒄ ᑭᔨᑆ ᒑ ᒌ ᐃᔨᐦᒄ, ᓂᒧᐃ ᐎᔮᔥ ᐃᓯᓈᑯᓐ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ, ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐃᔨᑦ ᒑᔅᑎᓈᔅ ᒑ ᑐᑎᐦᒃ ᓂᒧᐃ ᐋᐱᑎᓂᔨᐤ ᒑ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᑳ ᑖᑆᔮᔨᐦᑎᒦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","ᐙᔥ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑖᑭᓂᐎᒡ ᐐᔓᐙᐎᓐ ᐋᑯᑖᐦ ᐙᐦᒋᐱᔨᔨᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐋᐦᑯᔨᐙᓯᑦ᙮ ᐋᒄ ᒫᒃ ᑖᓂᑖᐦ ᐋᐦᐋᑳ ᑎᑯᐦᒡ ᐐᔓᐙᐎᓐ ᓂᒧᐃ ᑭᔨᑆ ᑎᑯᓐ ᒑ ᒌ ᐲᑯᓂᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐃᓯᓈᑯᐦᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ ᒥᒄ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᑭᓂᐎᔨᒡ ᐊᓂᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒫᒑᑦ᙮ ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓂᒡ ᐋᑯᑖᐦ ᐙᐦᒋ ᒑᔥᑎᓈᑖᔮᔨᐦᑖᑯᓃᔨᒡ ᒥᓯᐙ ᐊᓂᒌ ᑳ ᐄᔑ ᐋᓂᔅᒑ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ ᒧᔮᒻ ᑳ ᐄᔑ ᑖᑆᔮᔨᒫᔨᒡ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑭᔮᐦ ᐐᔨᐙᐤ ᒑ ᒌ ᐃᔮᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔨᔨᒡ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒫᒑᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᒥᒄ ᐊᓂᒌ ᑳ ᒥᔮᑭᓂᐎᒡ ᒧᓱᔅ ᐅᐐᔓᐙᐎᓂᔨᐤ ᒋᑭ ᒌ ᐃᔮᐅᒡ ᐅᔮᔨᐤ᙮ ᐊᓂᒌ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ ᒧᔮᒻ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳ ᐄᔑ ᑖᑆᔮᔨᒫᔨᒡ ᐋᐅᑯᓂᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᒑ ᐃᔮᒡ ᐅᔮᔨᐤ᙮ ᐙᔥ ᒥᓯᐙ ᐋᐦᑎᔒᐦᒄ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑰᐦᑖᐐᑎᐙᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋ ᒌ ᐄᑎᑯᑯᐱᓐ ᒋᔖᒥᓂᑑ, ᒋᒌ ᑐᑖᑎᓐ ᒑ ᒌ ᐅᐦᑖᐐᒥᑖᔅᒡ ᒥᐦᒑᑐ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ᙮ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒫᒃ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᐋ ᐅᐦᑖᐐᒥᑐᐦᒄ᙮ ᐋᔪᐎᒄ ᐋᓐ ᒫᒃ ᐅᔮᔨᐤ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑳ ᑖᑆᔮᔨᒫᑦ, ᐊᓂᔮᔨᐤ ᑳᐦ ᑐᑎᐙᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᐱᒫᑎᓰᔨᒡ ᒦᓐ ᑳᐤ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐋᐦ ᐄᔨᔨᒡ ᒑ ᒌ ᑎᑯᓃᔨᒡ ᒑᒀᔨᐤ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᑎᑯᓃᔨᒡ ᑏᐙᐦᒡ ᑎᑯᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ᐋᐦ ᐋᑦ ᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᑎᑯᓃᔨᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐄᔑ ᐊᔅᐹᔨᒧᑯᐱᓈ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᑖᑆᐦ ᒑ ᒌ ᐅᑎᐙᔑᔒᒥᒡ ᐐᐤᐦ, ᐊᔮᐱᒡ ᒌ ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐙᔥ ᐋᔪᐎᒄ ᑳᐦ ᐄᑎᑯᑦ ᒑ ᑐᑎᒫᑯᑦ᙮ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐃᓯᓈᑯᓃᔨᒡ ᒥᐦᒑᑐ ᐋᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᐊᐙᔨᐤᐦ ᒑ ᒌ ᐅᐦᑖᐐᒥᑯᑦ᙮ ᐙᔥ ᑭᔨᑆ ᐋᔪᐎᒄ ᐋᐦ ᐄᑎᔥᑖᔨᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒋᑭ ᒥᐦᒑᑑᒡ ᐄᔨᔨᐅᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᓐ ᒑ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ᔖᔥ ᒫᒃ ᒑᑳᑦ ᒌ ᒥᑖᐦᑐᒥᑎᓄᐙᐳᓍᓲ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐅᔮᔨᐤ ᑳ ᐄᑖᑭᓅᑦ ᒑ ᑐᑎᒧᐙᑭᓅᑦ᙮ ᐊᔮᐱᒡ ᒫᒃ ᐹᔨᑯᓂᒡ ᒌ ᐃᔥᐱᔥ ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ᙮ ᑳ ᐃᔥᐱᔥ ᓲᐦᒋᐱᔨᔨᒡ ᐋ ᑖᑆᔮᔨᒫᑦ ᓂᒧᐃ ᒥᑐᓐ ᐅᐦᒋ ᐋᓍᐦᑎᒻ ᒑ ᐅᑎᐙᔑᔒᒥᒡ ᐋᐦ ᐋᑦ ᒌ ᒋᔅᒑᔨᒦᓱᑦ ᐋᑳ ᔖᔥ ᒑ ᒌ ᐅᐦᑖᐐᒫᐅᑦ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐐᒋᒋᔖᐃᔥᒀᔥ ᐋ ᒌ ᒋᔅᒑᔨᒫᑦ ᒑᔥᑎᓈᔥ ᔖᔥ ᐋᑳ ᒑ ᒌ ᐅᑎᐙᔑᔒᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","ᐊᔮᐱᒡ ᒌ ᑖᑆᐦᑎᒻ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᒑ ᑐᑎᒫᑯᑦ ᒋᔖᒥᓂᑑ ᑖᓂᔮᔨᐤ ᑳᐦ ᐄᑎᑯᑦ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒫᑯᑦ᙮ ᐊᑎᑎᐤ ᒌ ᐋᑎ ᓲᐦᒑᔨᐦᑖᑯᓂᔨᐤ ᐅᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ᑭᔮᐦ ᒌ ᒋᔅᑖᒋᒫᐤ ᒋᔖᒥᓂᑑ, ");
INSERT INTO crl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","ᒥᑐᓐ ᒌ ᒑᔥᑎᓈᑖᔨᒫᐤ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒥᔨᒡ ᑖᓂᔮᔨᐤ ᑳ ᐄᔨᔨᒡ ᒑ ᑐᑎᒫᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","ᐋᔪᐎᒄ ᒫᒃ ᐙᐦᒋ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","ᐊᓐ ᑳᐦ ᐄᑎᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑰ ᒋᔖᒥᓂᑑ, ᓂᒧᐃ ᒥᒄ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐅᐦᒋ ᐋᔨᒨᒫᑭᓂᐤ ᐅᑎᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ᒋᑎᔅᑎᓂᑯᓈᓂᐤ ᑭᔮᐦ ᒌᔮᓂᐤ ᐆ ᑳᐦ ᐄᑎᔥᑖᒡ, ᒌᔮᓂᐤ ᑳ ᑖᑆᔮᔨᒥᐦᒄ ᒋᔖᒥᓂᑑ ᐊᓐ ᑳ ᐙᓂᔥᑳᓈᑦ ᒌᓴᔅᐦ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᑭᔮᐦ ᒌᔮᓂᐤ ᑯᐃᔅᑯᑖᑎᓯᐎᓂᐦᒡ ᒋᑭ ᐄᔑ ᑭᓂᐙᐱᒥᑯᓂᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ᒌᓴᔅ ᒌ ᐱᒋᔅᑎᓈᑭᓂᐤ ᒑ ᒌ ᓂᐳᔅᑎᒫᑎᐦᒄ ᒑ ᒌ ᐙᐹᔨᐦᑎᒫᑭᐎᔨᐦᒄ ᒋᒥᒋᐦᑣᐎᓂᓂᐤ, ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᐎᓂᔥᑳᓈᑭᓅᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐃᓯᓈᑯᐦᒡ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑎᐦᒃ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","ᐋᒄ ᒫᒃ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᐋᒄ ᐋ ᐄᔑ ᑭᓂᐙᐱᒥᑎᐦᒄ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐋ ᑖᑆᔮᔨᒥᐦᒄ᙮ ᐋᒄ ᑭᔮᐦ ᒫᔫᐐᒑᐅᐦᒄ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳᐦ ᑐᑎᒫᑎᐦᒄ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ ᙭, ");
INSERT INTO crl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","ᐐᔨ ᑳᐦ ᑐᑖᑎᐦᒄ ᒑ ᒋᔅᒑᔨᐦᑎᒧᒄ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓂᔨᐤ ᒌ ᐱᒫᑎᓰᐎᓈᐦᒡ, ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᒋᑖᑆᔨᐦᑎᒧᐎᓅᐦ᙮ ᐋᒄ ᒫᒃ ᒫᔻᔨᐦᑎᒥᐦᒄ ᐋ ᒑᔅᑎᓈᑖᔨᐦᑎᒥᐦᒄ ᐋᔥᒄ ᒥᑐᓐ ᒑ ᐎᒌᐦᐄᑯᔨᐦᒄ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐃᓯᓈᑯᓰᔨᐦᒄ ᐊᔮᐱᒡ ᐋ ᒨᒋᒑᔨᐦᑎᒧᒄ ᐋᑦ ᐊᓂᑎᐦ ᒫᒀᒡ ᐋ ᐊᔨᒥᐦᐅᔨᐦᒄ, ᐙᔥ ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᐊᓂᑎᐦ ᐊᓐ ᐋ ᐊᔨᒥᐦᐅᔨᐦᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᐊᑎᑎᐤ ᓰᐱᔨᐙᓰᐦᔨᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ᐋᒄ ᒫᒃ ᐊᓐ ᓈᓈᓂᒌᒻ ᐋ ᓰᐱᔨᐙᓰᔨᐦᒄ ᒋᐱᒫᑎᓰᐎᓈᐦᒡ ᒋᔖᒥᓂᑑ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑰ᙮ ᐅᔮᔨᐤ ᒫᒃ ᐋ ᐄᔑ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᒑᔥᑎᓈᑖᔨᐦᑎᒥᐦᒄ ᐋᔥᒄ ᒥᑐᓐ ᒑ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑎᐦᒄ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ᐋ ᒋᔅᒑᔨᐦᑎᒧᒄ ᒫᒃ ᐋᔥᒄ ᒥᑐᓐ ᒑ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑎᐦᒄ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ, ᒋᑭ ᒋᒑᔥᑎᓈᑖᔨᐦᑖᓈᓂᐤ ᑖᑆᐦ ᐋᔥᒄ ᒑ ᐄᔅᐱᔨᔨᒡ, ᐙᔥ ᒋᔖᒥᓂᑑ ᑖᑆᐦ ᒋᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑯᓂᐤ ᒋᑖᐦᐄᓈᐦᒡ ᐅᐱᔮᐦᒋ ᐊᐦᒑᐦᒄ ᐅᐦᒋ, ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᑎᐦᒄ᙮ ᐐᔨ ᒫᒃ ᒋᔖᒥᓂᑑ ᒋᒌ ᒥᔨᑯᓂᐤ ᐅᐱᔮᐦᒋ ᐊᐦᒑᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","ᐙᔥ ᐊᓂᑎᐦ ᒫᒀᒡ ᑳ ᐃᓯᓈᑯᓰᔨᐦᒄ ᐋᑳ ᒥᑐᓐ ᒑ ᒌ ᐱᒫᒋᐦᐄᓱᔨᐦᒄ, ᙭ ᒌ ᓂᐳᔅᑎᒧᐙᐤ ᐅᒥᒋᐦᑣᐤ᙮ ᐊᓂᑎᐦ ᒫᒃ ᒋᔖᒥᓂᑑ ᑳ ᐎᔮᔨᐦᑎᒥᔨᒡ ᐅᔮᔨᐤ ᒑ ᒌᐦ ᑐᑎᒫᑎᐦᒄ ᐋᑯᑖᐦ ᑳ ᓂᐳᔥᑎᒫᑎᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","ᓂᒧᐃ ᒥᐦᒑᑣᐤ ᐊᐙᓐ ᒋᐱᐦ ᐅᐦᒋ ᐐᐦ ᓂᐳᔅᑎᒧᐙᐤ ᐊᐙᔨᐤᐦ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᒥᒄ ᒫᒃ ᒀᔣᓐ ᒋᐱᐦ ᒌ ᐃᓯᓈᑯᓂᔨᐤ ᒑ ᒌ ᑖᑦ ᐊᐙᓐ ᐋ ᑯᒀᑖᔨᐦᑎᐦᒃ ᒑ ᒌ ᓂᐳᔅᑎᒧᐙᑦ ᐊᐙᔨᐤᐦ ᐋ ᒥᔪ ᐄᔨᔨᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","ᒋᔖᒥᓂᑑ ᒫᒃ ᐐᔨ ᒥᑐᓐ ᒋᒌ ᐙᐱᐦᑎᔨᑯᓂᐤ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᑎᐦᒄ, ᒌ ᐱᒋᔅᑎᓈᐤ ᙭ ᒑ ᒌ ᓂᐳᔅᑎᒫᑎᔨᑎᐦᒄ ᐋᔥᒄ ᒫᒀᒡ ᒥᒋᐦᑣᐎᓂᐦᒡ ᐋ ᒌ ᑖᐅᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ᐋᔪᐎᒄ ᒫᒃ ᐋ ᑯᐃᔅᑯᑖᑎᓰᐅᒄ ᐙᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑎᐦᒄ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᙭ ᐅᒥᐦᑯᔨᐦᒡ ᐅᐦᒋ, ᐋ ᒌ ᓂᐴᔥᑎᒫᑎᔨᑎᐦᒃ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᐋᐐᔅᑖ ᒌ ᒑᔥᑎᓈᑖᔨᐦᑖᓈᓂᐤ ᙭ ᑖᑆᐦ ᒑ ᐱᑯᐦᐄᑎᐦᒄ ᒋᔖᒥᓂᑑ ᐅᑖᐦᑭᐎᐙᔔ ᑎᐹᔅᑯᓂᒑᐎᓃᔨᒡ ᐅᐦᒋ ᒫᐦᒋᒡ ᒌᔑᑳᔨᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","ᐋᔥᒄ ᒫᒃ ᒫᒀᒡ ᐋᐦᐋᑳ ᒥᑐᓐ ᐅᐦᒋ ᐃᔮᐱᑖᔨᒫᐦᒄ ᒋᔖᒥᓂᑑ ᐊᔮᐱᒡ ᒌ ᐅᐦᑎᓂᒻ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐃᓯᓈᑯᓃᔨᒡ ᒑ ᒌ ᐋᑎᒦᔫᐐᒑᐅᐦᒄ᙮ ᑳ ᓂᐳᔅᑎᒫᑎᔨᑎᐦᒄ ᐅᑯᓯᔅᐦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᓂᐦᐄᐱᔨᐦᑖᑦ ᐅᔮᔨᐤ ᒑ ᒌ ᐃᓯᓈᑯᓃᔨᒡ᙮ ᐋᒄ ᒫᒃ ᐊᓅᐦᒡ ᐋ ᒥᔪᐎᒑᐅᐦᒄ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᑖᔨᐦᑖᑯᓐ ᒑ ᐱᒫᒋᐦᐄᑎᐦᒄ ᒌᓴᔅ ᐅᐱᒫᑎᓰᐎᓃᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ᐋᔨᐤᐦ ᒫᒃ ᓈᔥᒡ ᒌ ᒥᔻᔨᐦᑖᓈᓂᐤ ᒋᔖᒥᓂᑑ ᔖᔥ ᐋ ᒌ ᓂᐦᐄᐱᔨᐦᑖᑦ ᒑ ᒌ ᒥᔪᐐᒑᐅᐦᒄ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒌᓴᔅ ᙭ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ᐋᐅᒄ ᒫᒃ ᐆ ᑳ ᐄᔅᐱᔨᒡ, ᐹᔨᒄ ᓈᐹᐤ ᐋᐦ ᑖᑦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᑎᑯᐦᒡ ᒥᒋᐦᑣᐎᓐ ᑭᔮᐦ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᑎᑯᐦᒡ ᓂᐱᐎᓐ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᒥᒋᐦᑐᑎᐦᒃ᙮ ᑭᔮᐦ ᒫᒃ ᐋᑯᑖᐦ ᐙᐦᒋ ᐃᓯᓈᑯᐦᒡ ᒥᓯᐙ ᐊᐙᓐ ᐋ ᐅᑎᐦᑎᐦᐅᑯᑦ ᓂᐱᐎᓂᔨᐤ, ᐙᔥ ᒥᓯᐙ ᐊᐙᓐ ᒥᒋᐦᑐᑎᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","ᐋᑦ ᐋ ᒌ ᒥᒋᐄᐦᑑᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᒡ ᐋᔥᒄ ᐋᒸᔮ ᐅᐦᒋ ᑎᑯᓃᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ, ᓂᒧᐃ ᐅᐦᒋ ᐊᒋᐦᑎᒥᔨᐤ ᒋᔖᒥᓂᑑ ᐅᒥᒌᐦᑐᑎᒧᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ᐋᑕᒻ ᐋᐦ ᑖᑦ ᐅᐦᒋ ᑭᔮᐦ ᐊᓂᒌ ᐊᓂᑖᐦ ᐲᐦᐃᒻ ᑳᐦ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᒨᓱᔅ ᐋᐦ ᑖᔨᒡ ᐅᐦᒋ ᒥᓯᐙ ᒌ ᑎᐹᔨᒥᑰᐎᒡ ᓂᐱᐎᓂᔨᐤ ᐋᑦ ᐊᓂᒌ ᐋᐦᐋᑳ ᓂᐦᐋᐤ ᐅᐦᒋ ᐄᔑ ᒥᒋᐦᑑᑎᐦᒡ ᐋᑕᒻ ᑳ ᐄᔑ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮ ᐆ ᒫᒃ ᐋᑕᒻ ᐊᔮᐱᒡ ᒌᐦ ᑎᑯᓂᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᓂᔅᐱᑎᐙᑦ ᐊᓂᔮᔨᐤ ᐋᔥᒄ ᒑ ᑎᑯᔑᓃᔨᒡ, ᐋᔪᐎᒄ ᐋᓐ ᒌᓴᔅᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","ᒥᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ ᓵᐦᒑᐄ ᑳ ᒥᔨᑎᐦᒄ ᒋᔖᒥᓂᑑ ᓈᔥᑖᑆᐦ ᐃᔨᐦᒡ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐋᑕᒻ ᐅᒥᒋᐦᑑᑎᒧᐎᓐ᙮ ᒥᐦᒑᑐ ᐊᐙᓐ ᒌ ᐴᓂᐱᒫᑎᓰᐤ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐹᔨᒄ ᓈᐹᐤ ᐋ ᒌ ᒥᒋᐦᑐᑎᐦᒃ, ᐋᐅᒄ ᐆ ᐋᑕᒻ᙮ ᒥᒄ ᒫᒃ ᐊᑎᑎᐤ ᒥᐦᒑᑎᔨᐤ ᐊᐙᔨᐤᐦ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᒋᔖᐙᑐᑎᐙᑦ, ᐅᐦᒋ ᐹᔨᒄ ᓈᐹᐤ ᐋᔪᐎᑯᓐ ᐊᓂᔮᔨᐤ ᒌᓴᔅᐦ ᙭᙮ ᐊᑎᑎᐤ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᐊᓂᔮᔨᐤ ᒥᔨᐙᐎᓂᔨᐤ ᓵᐦᒑᐄ ᑳ ᒥᔨᑎᐦᒄ ᙭ ᐅᒥᔪᐦᑳᒑᐎᓃᔨᒡ ᐅᐦᒋ ᒥᐦᒑᑐ ᒫᒃ ᐊᐙᓐ ᒑ ᒌ ᐱᒫᒋᐦᐅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ᐃᔨᐦᒡ ᑖᑆᐦ ᐄᑖᔨᐦᑖᑯᓂᔨᐤ ᒋᔖᒥᓂᑑ ᐅᒥᔨᐙᐎᓐ ᑖᓐ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐹᔨᒄ ᓈᐹᐤ ᐅᒥᒋᐦᑑᑎᒧᐎᓐ᙮ ᐙᔥ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᒥᒋᐦᑐᑎᐦᒃ ᐋᑕᒻ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋᐱᔨᔨᒡ ᒥᓯᐙ ᐊᐙᓐ ᑖᑆᐦ ᒑ ᒌ ᐊᑖᒫᔨᐦᑖᑯᓯᑦ ᒥᒋᐦᑣᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ, ᐋᑯᑎᐦ ᐙᐦᒋᐱᔨᒡ ᒑ ᒌ ᓂᔓᓈᒋᒫᑭᓂᐎᒡ᙮ ᒋᔖᒥᓂᑑ ᒫᒃ ᐙᔪᒡ ᐊᔅᒋᒥᔨᑯᓂᐤ ᑳ ᐱᒋᔅᑎᓈᑦ ᒌᓴᔅ ᒑ ᒌ ᓂᐱᐦᐄᒫᑭᓂᐐᔨᒡ ᐋᑯᑖᐦ ᐙᐦᒋᐱᔨᔨᒡ ᒥᐦᒑᑐ ᐄᔨᔨᐅᒡ ᒑ ᒌ ᐙᐹᔨᐦᑎᒧᐙᑭᓂᐎᒡ ᐋᐦᐋᑦ ᒥᐦᒑᓃᔨᒡ ᐅᒥᒌᐦᑐᑎᒧᐎᓂᐙᐤ, ᐋᒄ ᒫᒃ ᐋ ᑯᐃᔅᑯᑖᑎᓰᔨᒡ ᒑ ᐄᔑ ᑭᓂᐙᐱᒥᑯᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","ᐙᔥ ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᐊᓂᔮᔨᐤ ᐅᒥᒋᐦᑣᐎᓐ ᐊᓐ ᐹᔨᒄ ᓈᐹᐤ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᐃᓯᓈᑯᐦᒡ ᒥᓯᐙ ᐊᐙᓐ ᒑ ᒌ ᑎᐹᔨᒥᑯᑦ ᓂᐱᐎᓂᔨᐤ᙮ ᑖᓐ ᒫᒃ ᐊᐅᔅᑖ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑖᑯᓃᔨᒡ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᑎᐦᒄ ᐊᓐ ᐹᔨᒄ ᑯᑎᒃ ᓈᐹᐤ, ᐋᐅᒄ ᒌᓴᔅ ᙭᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᒌ ᑳ ᐙᔪᒡ ᒋᔅᒑᔨᐦᑎᒥᐦᐋᑭᓂᐎᒡ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓂᔨᐤ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐋ ᐄᔑ ᑭᓂᐙᐱᒧᑯᒡ ᒋᔖᒥᓂᑑᐤ ᒨᔥ ᑭᑎ ᑖᐅᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᔨᒡ ᒌᓴᔅᐦ ᑭᔮᐦ ᑭᑎ ᐐᒋᐦᐄᑯᒡ ᒑ ᒌ ᒥᔥᑭᐎᑳᐳᐎᒡ ᐅᐱᒫᑎᓰᐎᓂᐙᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐃᓯᓈᑯᐦᒡ ᒧᔮᒻ ᐹᔨᒄ ᐊᐙᓐ ᐅᒥᒋᐦᑣᐎᓐ ᐅᐦᒋ ᒥᓯᐙ ᐊᐙᓐ ᐊᑐᐦᑎᐦᐄᑯᑦ ᓂᔑᐎᓈᒋᐦᐄᐙᐎᓂᒡ᙮ ᐋᓐ ᒫᒃ ᑯᑎᒃ ᐹᔨᒄ ᓈᐹᐤ ᐊᓐ ᒌᓴᔅᐦ, ᐅᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᐋᑯᑖᐦ ᐙᐦᒋᐱᔨᔨᒡ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᒡ ᑭᔮᐦ ᒥᓯᐙ ᒑ ᒌ ᐃᔮᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","ᐹᔨᒄ ᐊᐙᓐ, ᐋᐅᒄ ᐋᑕᒻ, ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᓂᓂᐦᐄᐦᑎᐙᑦ ᒋᔖᒥᓂᑑ ᐋᑯᑖᐦ ᐙᐦᒋᐱᔨᔨᒡ ᒥᓯᐙ ᐊᐙᓐ ᐊᑖᒫᔨᐦᑖᑯᓯᑦ ᐋ ᒥᒑᑎᓰᑦ᙮ ᐊᓐ ᒫᒃ ᑯᑎᒃ, ᐋᐅᒄ ᒌᓴᔅ, ᒥᑐᓐ ᐋ ᒌ ᓂᓂᐦᐄᐦᑎᐙᑦ ᒋᔖᒥᓂᑑ ᐋᑯᑖᐦ ᐙᐦᒋᐱᔨᔨᒡ ᒥᐦᒑᑦ ᐊᐙᓐ ᐋ ᑯᐃᔅᑯᑖᑎᓰᑦ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","ᐄᔥᐱᐦ ᑳ ᐱᒋᔅᑎᓂᐦᒃ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐋ ᐃᔥᐱᔥ ᐙᔪᒡ ᒥᒋᐦᑑᑎᐦᒡ᙮ ᒥᒄ ᒫᒃ ᑖᓂᑖᐦ ᑳ ᐙᔪᒡ ᒥᒌᐦᑐᑖᑭᓂᐎᒡ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓐ ᐊᑎᑎᐤ ᒌ ᐋᐱᑎᓰᒥᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","ᑖᑆᐦ ᑭᔨᑆ ᓲᐦᒋᐱᔨᐤ ᒥᒋᐦᑣᐎᓐ᙮ ᐙᔥ ᒥᑐᓐ ᑎᐹᔨᒥᑰᐎᒡ ᐄᔨᔨᐅᒡ ᐋᔪᐎᒄ ᒫᒃ ᐙᐦᒋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ᙮ ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᒋᔖᐙᑎᓰᐎᓐ ᓲᐦᒑᔨᐦᑖᑯᓂᔨᐤ᙮ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᒋᑎ ᐄᔑ ᑭᓂᐙᐱᒥᑯᓂᐤ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᑎᐦᒄ ᒌᓴᔅ ᙭ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒥᓯᐙ ᒑ ᒌ ᐅᐦᒋ ᐃᔮᐅᐦᒄ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","ᐃᔨᑦ ᒫᐦ ᐊᐙᓐ ᐋᑯᔥ ᐊᔮᐱᒡ ᒥᒋᐦᑑᑎᐦᑖᐤ ᐊᑎᑎᐤ ᒑ ᒌ ᓅᑯᐦᑣᑎᐦᒄ ᐋ ᐃᔥᐱᔥ ᒨᔥ ᐙᔪᒡ ᒥᔪᑐᑎᐙᑦ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ᙮ ᒫᐤ ᓂᐱᐦ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐊᓐ ᐊᐙᓐ ᐅᔮᔨᐤ ᐃᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ᑖᐹ ᑭᑎ ᒋᑭ ᐃᓯᓈᑯᓐ ᐆ᙮ ᐊᑑᒡ ᐙᐙᒡ ᒋᐱᐦ ᐅᐦᒋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒻ ᐊᐙᓐ ᐅᔮᔨᐤ᙮ ᒋᐱᐦ ᐄᔑ ᑭᓂᐙᐱᒥᓱᓈᓂᐤ ᒧᔮᒻ ᐋ ᒌ ᐳᓂᐱᒫᑎᓰᔨᐦᒄ ᐋᓐ ᑖᓐ ᑳ ᐄᔑ ᑎᐹᔨᒥᑯᔨᐦᒄ ᒥᒋᐦᑣᐎᓐ ᐅᐦᒋ᙮ ᓂᒧᐃ ᐋᒄ ᒥᒋᐃᐦᑣᐎᓂᐦᒡ ᒋᐱᐦ ᐅᐦᒋ ᐄᔑ ᐱᒫᑎᓰᓈᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","ᓂᒧᐃ ᐋ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐄᔥᐱᐦ ᑳ ᓰᐦᑭᐦᐋᐦᑖᑭᐎᔨᐦᒄ ᒑ ᒌ ᐐᒑᐅᒄ ᙭ ᒌᓴᔅ, ᐋᑯᑖᐦ ᑳ ᓅᑯᐦᑖᔨᐦᒄ ᐋ ᒌ ᐃᔅᒡ ᓂᐲᒥᑭᐦᒡ ᐙᔥᑭᒡ ᒋᑎᐃᑖᑎᓯᐎᓂᓂᐤ ᙭ ᑳ ᓂᐱᐦᐋᑭᓅᑦ? ");
INSERT INTO crl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","ᐋᔪᐎᒄ ᒫᒃ ᑳ ᓰᐦᑭᐦᐋᐦᑖᑭᐎᔨᐦᒄ ᒧᔮᒻ ᑭᔮᐦ ᒌᔮᓂᐤ ᐋ ᒌ ᓂᐦᐄᐦᑳᑯᐎᔨᐦᒄ ᑳ ᓂᐦᐄᐦᑭᐙᑭᓅᑦ, ᑭᔮᐦ ᑳ ᓂᐱᐦᐋᑭᓅᑦ ᒌᔮᓂᐤ ᑭᔮᐦ ᒋᒌ ᓂᐱᐦᐄᑯᓈᓂᐤ᙮ ᐆ ᒫᒃ ᐙᐦᒋ ᐃᓯᓈᑯᐦᒡ ᐋᐅᒄ ᒥᑐᓐ ᒑ ᒌ ᐅᔅᒑᔨᐦᑖᑯᐦᒡ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᐦᒄ ᒧᔮᒻ ᑳ ᐃᔥᐱᔥ ᒥᑐᓐ ᐅᔅᒑᔨᐦᑖᑯᓃᔨᒡ ᙭ ᐅᐱᒫᑎᓰᐎᓐ ᑳ ᐎᓂᔥᑳᓂᑯᑦ ᐅᐦᑖᐐᒫᐤ ᐅᒋᔅᑖᔨᐦᑖᑯᓲ ᓲᐦᑳᑎᓰᐎᓃᔨᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ᐋᒄ ᒫᒃ ᐋ ᐐᒑᐅᐦᒄ ᒌᓴᔅ ᐅᓂᐱᐎᓂᐦᒡ ᒋᑎᐄᔑᓈᑯᓯᓈᓂᐤ᙮ ᐋᑯᑖᐦ ᐙᐦᒋ ᒑᔥᑎᓈᑖᔮᔨᐦᑖᑯᐦᒡ ᒑ ᐎᓂᔥᑳᓂᑯᐎᔨᐦᒃ ᒧᔮᒻ ᐐᔨ ᐋ ᒌ ᐎᓂᔥᑳᓈᑭᓅᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","ᐙᔥ ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᐊᓐ ᐙᔥᑭᒡ ᒋᑎᐃᑖᑎᓯᐎᓂᓂᐤ ᐋ ᒌ ᒌᔅᑖᔅᑯᐦᑖᑭᓂᐎᒡ ᒌᓴᔅ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᐋᔑᑖᔮᐦᑎᑯᐦᒡ᙮ ᐊᓂᔮᔨᐤ ᑳ ᒌᔅᑖᔅᑯᐦᐙᑭᓅᑦ ᐋᑯᑖᐦ ᑳ ᓂᔑᐎᓈᑎᓰᒥᑭᐦᒡ ᑖᓐ ᑳ ᐄᔑ ᑎᐹᔨᒥᑯᔨᐦᒄ ᐙᔥᑭᒡ ᒋᑎᐃᑖᑎᓰᐎᓂᓂᐤ, ᐋᒄ ᒫᒃ ᓂᒧᐃ ᔖᔥ ᒥᑐᓐ ᒋᑭ ᒌ ᑎᐹᔨᒥᑯᓈᓂᐤ ᒥᒑᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","ᐊᐙᓐ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᑦ ᓂᒧᐃ ᒋᑭ ᒌ ᑎᐹᔨᒥᑰ ᒥᒑᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ᐙᔥ ᐋ ᐄᔑ ᑖᑆᐦᑖᒥᐦᒄ ᐊᓂᐦᐄ ᐙᔥᑭᒡ ᒋᑎᐃᑖᑎᓯᐎᓂᐤ ᐋ ᒌ ᓂᐱᐦᑖᑭᓂᐎᒡ, ᙭ ᑳ ᓂᐱᐦᐋᑭᓅᑦ, ᒋᑖᑆᐦᑖᓈᓂᐤ ᑭᔮᐦ ᒑᔥᑎᓈᔥ ᐐᔨ ᙭ ᒑ ᐐᒋᐱᒫᑎᓰᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᙭ ᐋ ᒌ ᐎᓂᔥᑳᓈᑭᓅᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᓂᒧᐃ ᒫᒃ ᒦᓐ ᒋᑭ ᒌ ᐴᓂᐱᒫᑎᓰᐤ᙮ ᓂᒧᐃ ᓂᐦᑖ ᒦᓐ ᒋᑭ ᒌ ᑎᐹᔨᒥᑰ ᓂᐱᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","ᐙᔥ ᐊᓂᔮᔨᐤ ᑳ ᐴᓂᐱᒫᑎᓰᑦ, ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒥᒄ ᐹᔨᒀᐤ ᑳ ᓂᐳᔅᑎᒧᐙᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᑳ ᑎᐹᔨᒥᑯᔨᒡ ᒥᒋᐦᑣᐎᓂᔨᐤ᙮ ᐋᒄ ᒫᒃ ᐊᓂᔮᔨᐤ ᐊᓅᐦᒡ ᒦᓐ ᑳᐤ ᐋ ᐱᒫᑎᓰᑦ, ᐱᒫᑎᓰᐤ ᒑ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ᒧᔮᒻ ᐄᔨᔨᐅᒡ ᐋ ᐴᓂᐱᒫᑎᓰᔨᒡ ᐋᐦᐋᑳ ᑎᐹᔨᒥᑯᒡ ᒥᒑᑎᓰᐎᓂᔨᐤ ᐋᐅᒄ ᒋᐱᐦ ᐄᔑ ᑭᓂᐙᐱᒦᓱᓈᐙᐤ᙮ ᒋᐱᒫᑎᓰᓈᐙᐤ ᐋᒄ ᒑ ᒌ ᑎᐹᔨᒥᑖᒄ ᒋᔖᒥᓂᑑ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᐋ ᐐᒑᐅᒫᒄ ᙭ ᒌᓴᔅ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","ᐊᑳᐐ ᒫᒃ ᐅᐦᒋ ᐱᒋᔅᑎᓂᒧᒄ ᒥᒋᐦᑣᐎᓐ ᒑ ᒌ ᑎᐹᔨᒥᑯᔮᒄ ᒋᔮᐙᐦᒡ ᒑ ᒌ ᓂᐲᒥᑭᐦᒡ, ᐋᐦ ᑐᑎᒫᒄ ᐊᓐ ᐋᔥ ᒥᒋᒨᔅᑖᓈᔮᔨᐦᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ᐊᑳᐐ ᑭᔮᐦ ᐱᒋᔅᑎᓂᒧᒄ ᒌᔨᐙᐤ ᒥᒋᐃᐦᑣᐎᓂᐦᒡ ᒑ ᒌ ᐄᔑ ᐋᐱᑎᐦᒡ᙮ ᒋᔖᒥᓂᑑ ᑎᔨᑯᒡ ᐱᒋᔥᑖᔨᒧᔅᑎᐙᐦᒄ᙮ ᐋᒄ ᒫᒃ ᒑ ᐃᓯᓈᑯᓱᔮᒄ ᒧᔮᒻ ᐄᔨᔨᐅᒡ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒦᓐ ᒫᒃ ᑳᐤ ᐋ ᐱᒫᑎᓰᔨᒡ᙮ ᒥᑐᓐ ᐱᒋᔅᑎᓈᒫᐦᒄ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᑎᐹᔨᐦᑎᐦᒃ ᒋᐱᒫᑎᓰᐎᓂᐙᐤ᙮ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐋᐱᒋᐦᐄᑖᒄ ᒑ ᒌ ᒥᔪᑐᑎᒸᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","ᐊᑳᐐ ᐋᒄ ᒋᑭ ᐅᐦᒋ ᑎᐹᔨᒥᑯᓈᐙᐤ ᒥᒑᑎᓰᐎᓐ, ᐙᔥ ᑖᐹ ᐋᒄ ᒥᒄ ᐐᔓᐙᐎᓐ ᐋ ᓂᓂᐦᐄᐦᑎᒫᒄ ᒋᑭ ᐅᐦᒋ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐋᐙᐤ ᒋᔖᒥᓂᑑ᙮ ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᐙᔪᒡ ᒥᔪᐦᑳᒑᐎᓂᒡ ᐋᑯᑖᐦ ᐙᐦᒋ ᐱᒫᒋᐦᐄᑖᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","ᑖᓐ ᒫᒃ ᒑ ᒌ ᑎᔨᐦᒄ᙮ ᐊᔮᐱᒡ ᐋ ᒋᑭ ᒥᒌᐦᑐᑖᓈᓂᐤ ᐐᐦ ᒥᒋᐦᑑᑎᒧᐦᒀ ᐋ ᒋᔅᒑᔨᐦᑎᒥᐦᒄ ᐋᐦᐋᑳ ᐐᔓᐙᐎᓐ ᑎᐹᔨᒥᑯᔨᐦᒄ, ᑎᔨᑯᒡ ᒋᔖᒥᓂᑑ ᐅᒋᔖᐙᑎᓯᐎᓂᐦᒡ ᐋ ᐄᔑ ᑭᓂᐙᔨᐦᑖᑯᓰᔨᐦᒄ? ᓂᒧᐃ ᐆ ᒋᑭ ᒌᐦ ᑎᓈᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","ᒋᓂᑎᐙᔨᒥᑎᓈᐙᐤ ᐆ ᒑ ᒌ ᒋᔥᒋᓯᔮᒄ᙮ ᐱᒋᔥᑖᔨᒧᔅᑎᐙᒀ ᐊᐙᓐ ᒑ ᒌ ᐅᐦᒋ ᒥᑐᓐ ᓂᓂᐦᐄᐦᑎᐙᒄ ᒧᔮᒻ ᐋᐱᒋᐦᐋᑭᓐ ᑳ ᑖᐱᑎᐹᔨᒫᑭᓅᑦ ᐋ ᐃᓯᓈᑯᓯᑦ ᐋ ᓂᓂᐦᐄᐦᑎᐙᑦ ᐅᒋᒫᒻ, ᑭᔨᑆ ᒑ ᐅᑖᐱᒋᐦᐋᑭᓂᑖᑖᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᐎᔮᔨᐦᑎᒫᒄ ᒑ ᓂᓂᐦᐄᐦᑎᐙᒄ᙮ ᒥᔔ ᒫᒃ ᑳ ᐱᒋᔥᑖᔨᒧᔅᑎᒧᐙᒀ ᐊᓐ ᑖᓐ ᐋ ᐄᔑ ᑎᑯᐦᒡ ᐋ ᐐᐦ ᒥᒋᐦᑑᑎᒫᒄ ᑭᔨᑆ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋᐱᔨᐦᒡ ᓂᐱᐎᓐ᙮ ᒥᔔ ᒫᒃ ᐐᔨ ᒋᔖᒥᓂᑑ ᓂᓃᐦᑑᐙᒀ ᐋᑯᑖᐦ ᒑ ᐅᐦᒋᐱᔨᐦᒡ ᒑ ᒌ ᑯᐃᔅᑯᑖᑎᓯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","ᓂᓂᓈᔅᑯᒫᐤ ᒋᔖᒥᓂᑑ ᒌᔨᐙᐤ ᐋᑎ ᐹᔨᒀᐤ ᑳ ᐃᓯᓈᑯᓱᔮᒄ ᐋ ᐅᑖᐱᒋᐦᐋᑭᓂᑖᑯᔮᒄ ᒥᒋᐦᑣᐎᓐ, ᐋ ᒌ ᐅᑎᐦᒋᐱᔨᐦᒡ ᐊᓂᑎᐦ ᒥᑐᓐ ᑳ ᐄᑖᔨᐦᑎᒥᐦᐄᑯᐎᔮᒄ ᒑ ᒌ ᓂᓂᐦᐄᐦᑎᒫᒄ ᒥᔪ ᒋᔅᑯᑎᒫᒑᐎᓐ ᐄᔥᐱᐦ ᑳᐦ ᐋᑎᐙᐐᐦᑎᒫᑯᐎᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","ᒋᒌ ᐱᑯᐦᐄᑯᓈᐙᐤ ᒥᒋᐃᐦᑣᐎᓂᐦᒡ ᐅᐦᒋ ᐋᒄ ᒫᒃ ᑯᐃᔅᑯᑖᑎᓰᐎᓐ ᑳᐦ ᐋᑎᑎᐹᔨᒥᑯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ᐋᐅᒄ ᐆ ᐋ ᐄᔑ ᐊᔨᒥᐦᐄᑎᑯᒡ ᐙᔥ ᐋᑯᑖᐦ ᒥᒄ ᒑ ᒌ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒫᒄ᙮ ᐹᔨᒀᐤ ᒋᒌ ᐃᓯᓈᑯᓯᓈᐙᐤ ᒥᑐᓐ ᐋ ᒌ ᐱᒋᔅᑎᓂᓱᔮᒄ ᐐᓂᔓᐙᑎᓰᐎᓐ ᒑ ᒌ ᑎᐹᔨᒥᑯᔮᒄ ᑭᔮᐦ ᒫᒃ ᒋᒌ ᐱᒋᔅᑎᓃᓱᓈᐙᐤ ᓈᓈᓂᒌᒻ ᒑ ᒌ ᐋᑎ ᒥᒑᑎᓯᔮᒄ᙮ ᐊᓅᐦᒡ ᒫᒃ ᒥᑐᓐ ᐱᒋᔅᑎᓂᓱᒄ ᑯᐃᔅᑯᑖᑎᓰᐎᓐ ᒑ ᒌ ᑎᐹᔨᒥᑯᔮᒄ ᒑ ᒌ ᐅᐦᒋ ᐱᔮᐦᒋᓯᔮᒄ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","ᒫᒀᒡ ᒥᑐᓐ ᑳ ᑎᐹᔨᒥᑯᔮᒄ ᒥᒋᐦᑣᐎᓐ ᓂᒧᐃ ᒥᑐᓐ ᑰᐦᒋ ᐃᔮᐱᑖᔨᐦᑖᓈᐙᐤ ᑯᐃᔅᑯᑖᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ᑖᓐ ᒫᒃ ᑳ ᐄᔑ ᐐᒋᐦᐄᑯᔮᒄ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᑳ ᒌ ᑑᑎᒫᒄ, ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᐙᐙᓂᐦᑎᒋᐦᐄᑯᔮᒄ ᐊᓅᐦᒡ᙮ ᓂᐱᐎᓂᐦᒡ ᐄᑐᐦᑎᐦᐄᐙᒥᑭᓐ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᑳ ᒌ ᑑᑎᒫᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ᐊᓅᐦᒡ ᒫᒃ ᐐᐦ, ᒋᒌ ᐱᑯᐦᐄᑭᐎᓈᐙᐤ ᒥᒋᐃᐦᑣᐎᓂᐦᒡ ᐅᐦᒋ, ᔖᔥ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐅᑖᐱᒋᐦᐋᑭᓂᑖᑖᐦᒄ᙮ ᐋᒄ ᒫᒃ ᒥᑐᓐ ᒋᔖᒥᓂᑑ ᐋᐦ ᑖᑦ ᔖᔥ ᐋ ᐄᔑ ᐱᐦᑳᓂᔥᑖᒡ ᒌ ᐱᒫᑎᓰᐎᓐ, ᒋᑭ ᐋᑎ ᐅᑎᐦᑖᓈᐙᐤ ᒫᒃ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","ᐙᔥ ᓂᐱᐎᓂᐦᒡ ᐄᑐᐦᑎᐦᐄᑰ ᐊᐙᓐ ᒥᒋᐦᑣᐎᓂᔨᐤ᙮ ᐋᒄ ᐊᓐ ᐊᐙᓐ ᑳ ᐐᒑᐙᑦ ᙭ ᒌᓴᔅ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᒋᔖᒥᓂᑑ ᓵᐦᒑᐄ ᒥᔨᑰ ᑳᒋᒡ ᐱᒫᑎᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ᒌᔨᐙᐤ ᓃᒋᔖᓂᑎᒄ, ᓂᒑᔥᑎᓈᐦᐅᓐ ᒑ ᓂᔅᑐᐦᑎᒫᒄ ᑖᓐ ᒑ ᐄᔑ ᐙᐐᐦᑎᒫᑎᑯᒡ ᐙᔥ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐐᔓᐙᐎᓐ᙮ ᒌ ᒋᔅᒑᔨᐦᑖᓈᐙᒑ ᒥᒄ ᒑ ᐃᔥᐱᔥ ᐱᒫᑎᓰᒀ ᐊᐙᓐ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᐐᔓᐙᐎᓐ ᑭᑎ ᑎᐹᔨᒥᑰ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ᒧᔮᒻ ᐃᔅᒀᐤ ᑖᓐ ᐋ ᐃᓯᓈᑯᓯᑦ, ᐄᑎᔅᑖᔨᐤ ᐐᔓᐙᐎᓂᐦᒡ ᐋᑳ ᒑ ᒌ ᓂᑭᑖᑦ ᐅᓈᐹᒻ ᐋᔥᒄ ᐋ ᐱᒫᑎᓰᔨᒡ᙮ ᒥᔔ ᒫᒃ ᐴᓂᐱᒫᑎᓰᔨᒑ ᐊᓂᔮᔨᐤ ᐅᓈᐹᒻ ᐋᒄ ᑭᔨᑆ ᓂᒧᐃ ᔖᔥ ᒋᑭ ᒫᒫᐦᒋᒀᐱᐦᑳᑎᑰ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","ᐆ ᒫᒃ ᑖᓐ ᐋᑣᒥᑭᐦᒡ ᐆ ᐐᔓᐙᐎᓐ ᐱᓯᒀᑎᓰᔅᒀᐤ ᒋᑭ ᐃᔑᓂᐦᑳᑖᑭᓂᐤ ᐃᔅᒀᐤ ᑯᑎᒃ ᓈᐹᐤ ᐐᒋᒫᒑ ᐋᔥᒄ ᐋ ᐱᒫᑎᓰᔨᒡ ᐅᓈᐹᒻ᙮ ᐴᓂᐱᒫᑎᓰᒑ ᒫᒃ ᐅᓈᐹᒻ ᐃᔅᒀᐤ ᓂᒧᐃ ᐋᒄ ᑭᑎ ᐅᐦᒋ ᐋᐱᑎᓂᔨᐤ ᐊᓂᔮᔨᐤ ᐎᒋᐦᑐ ᐐᔓᐙᐎᓂᔨᐤ ᑭᔮᐦ ᒫᒃ ᓂᒧᐃ ᑭᑎ ᐅᐦᒋ ᐱᓯᒀᑎᓯᐤ ᐋᑎᑯᑎᒃ ᓈᐹᐤ ᓃᓲᑳᐳᑣᐙ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","ᐋᐅᒄ ᒫᒃ ᒧᔮᒻ ᐋ ᐃᓯᓈᑯᐦᒡ ᑖᓐ ᑳᐦ ᑐᑎᒫᑭᐎᔨᐦᒄ, ᓃᒋᔖᓂᑎᒄ᙮ ᐊᔅᒋᐱᑯᐦᐄᑯᓈᓂᐤ ᐊᓂᑎᐦ ᐅᐦᒋ ᐐᔓᐙᐎᓂᐦᒡ ᑳ ᑎᐹᔨᒥᑯᔨᐦᒄ ᐃᔥᐱᔥ ᙭ ᑳ ᓂᐴᔥᑎᒫᑎᐦᒄ, ᐋᐅᒄ ᒫᒃ ᐐᔨ ᒑ ᒌ ᑎᐹᔨᒥᑎᐦᒄ ᒦᔥᑯᒡ, ᐋᐅᒄ ᐋᒄ ᙭ ᐋᓐ ᑳ ᐎᓂᔅᑳᓈᑭᓅᑦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐐᔨ ᒫᒃ ᑎᐱᔨᒥᑎᐦᒀ, ᐋᒄ ᒑ ᒥᔻᐱᑎᔒᔥᑑᐦᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","ᐙᔥ ᐋᔥᒄ ᐙᔥᑭᒡ ᒋᑎᐃᑖᑎᓰᐎᓂᓂᐤ ᐋ ᒌ ᑎᐹᔨᒥᑯᔨᐦᒄ, ᐊᓐ ᒫᒃ ᐋᐦᑎᑯᐦᒡ ᐐᔓᐙᐎᓐ ᑭᔮᐦ ᒫᒃ ᐋ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᒄ ᐊᓐ ᐐᔓᐙᐎᓐ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋᐱᔨᐦᒡ ᐋᐦᒡ ᐋ ᒨᔥᒋᐱᔨᐦᒡ ᒑ ᒌ ᒥᒋᐦᑐᑎᒥᐦᒄ᙮ ᐆ ᒫᒃ ᐋ ᒌ ᐄᔑ ᐱᒫᑎᓰᔨᐦᒄ ᓂᐱᐎᓂᐦᒡ ᒋᒌ ᐄᑐᐦᑎᐦᐄᑯᓈᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ᐊᓅᐦᒡ ᒫᒃ ᔖᔥ ᒋᒌ ᐱᑯᐦᐄᑯᓈᓂᐤ ᑖᓐ ᑳ ᐄᔑ ᒫᐦᒋᒀᐱᐦᑳᑎᑯᔨᐦᒄ ᐐᔓᐙᐎᓐ, ᐙᔥ ᒋᐦᒋᐙ ᒋᒌ ᓂᑭᑖᓈᓂᐤ ᐊᓐ ᐄᑖᑎᓰᐎᓐ ᓈᔥᒡ ᑳ ᒌ ᑎᐹᔨᒥᑯᔨᐦᒄ᙮ ᒦᔥᑯᒡ ᐙᔅᑳᐦᒡ ᐊᓐ ᐱᒫᑎᓰᐎᓐ ᐋᐦᐋᐱᑎᔒᔥᑑᐦᒄ ᒋᔖᒥᓂᑑ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋ ᐐᒋᐦᐄᑎᐦᒄ, ᐋᐦᐋᑳ ᐃᔮᐱᑖᔨᐦᑎᒫᐦᒄ ᐊᓐ ᐙᔅᑭᒡ ᐐᔓᐙᐎᓐ ᑳ ᒥᓯᓂᐦᐄᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","ᐃᔨᑦ ᒫᐦ ᐊᐙᓐ, ᒫᔮᑎᓅᒑ ᐊᓐ ᐐᔓᐙᐎᓐ ᐙᔥ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋᐱᔨᐦᒡ ᐋᐦᒡ ᒑ ᒌ ᒥᒋᐦᑐᑎᒫᓐ᙮ ᒫᐤ ᓂᐱᐦ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐋᐤ ᐆ ᐊᐙᓐ, ᑖᐹ ᓂᒥᔮᐤ ᐊᓐ ᐐᔓᐙᐎᓐ ᑳᐦᑐᑖᑯᔮᓐ ᒑ ᒌ ᒥᒋᐦᑐᑎᒫᓐ᙮ ᒥᒄ ᒫᒃ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᓐ ᑖᑆᐦ ᐋ ᒥᒋᐦᑐᑎᒫᓐ ᐊᓂᑎᐦ ᐅᐦᒋ ᑖᓐ ᐋᑎᔓᐙᒥᑭᐦᒡ ᐊᓐ ᐐᔓᐙᐎᓐ᙮ ᒧᔮᒻ ᐊᓂᑎᐦ ᐊᓐ ᑳᐦ ᐄᑎᔥᑖᒡ, “ᐊᑳᐐ ᒥᒋᒧᔥᑖᓂᒫᒑ,” ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᓐ ᐋ ᒥᒋᐦᑐᑎᒫᓐ ᐋ ᒥᒋᒧᔥᑖᓂᒫᒑᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ᐊᓂᑎᐦ ᒫᒃ ᐊᓐ ᑳᐦ ᐄᑎᔥᑖᒡ ᐐᔓᐙᐎᓂᐦᒡ ᐋᑳ ᒑ ᒌ ᒥᒋᒧᔥᑖᓈᒫᒑᑦ ᐊᐙᓐ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋᐱᔨᐦᒡ ᐋᐦᒡ ᓂᓈᐦᑭᐤ ᒑ ᒌ ᐄᔑ ᒥᒋᒧᔥᑖᓈᒫᐦᒑᔮᓐ᙮ ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒻ ᐊᐙᓐ ᐋ ᒥᒋᐦᑐᑎᐦᒃ ᐋᑳ ᐅᐦᒋ ᑎᑯᓃᔨᐙᑯᐱᓈ ᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ᐅᑖᐦᒡ ᓂᒌᐦ ᐄᔑ ᐱᒫᑎᓰᓐ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᒫᓐ ᑖᓐ ᐋᑎᔓᐙᒥᑭᐦᒡ ᐐᔓᐙᐎᓐ᙮ ᑎᐙᐦᒡ ᒫᒃ ᑳ ᒋᔅᒑᔨᐦᑎᒫᓐ ᐄᑎᔓᐙᐎᓐ ᑖᓐ ᐋᑣᒥᑭᐦᒡ, ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒫᓐ ᐋ ᒥᒑᑎᓯᔮᓐ ᑭᔮᐦ ᓂᐱᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐄᑯᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ᐋᒄ ᐊᓐ ᐐᑎᔑᐙᐎᓐ ᑳ ᒥᔨᐙᓂᐎᒡ ᐋᑎ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᐆᔨᐦᒄ, ᒥᒄ ᒫᒃ ᓂᐱᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐄᑯᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","ᒋᔖᒥᓂᑑ ᐅᑏᑎᔑᐙᐎᓂᐦᒡ ᒌ ᐅᐦᒋ ᓂᐦᐄᐱᔨᐦᐄᓲᒥᑭᓐ ᒥᒋᐦᑣᐎᓐ ᒑ ᒌ ᐎᔮᓯᒥᑯᔮᓐ᙮ ᐋᐅᒄ ᒫᒃ ᐆ ᒥᒋᐦᑣᐎᓐ ᑳ ᓂᐱᐦᐄᑯᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","ᐋᑯᑖᐦ ᒫᒃ ᐙᐦᒋ ᐙᐱᐦᑎᒫᓐ ᐋ ᐱᔮᐦᑭᐦᒡ ᐐᔓᐙᐎᓐ᙮ ᑭᔮᐦ ᒫᒃ ᒥᓯᐙ ᑖᓐ ᐄᑎᔓᐙᒥᑭᐦᒡ ᐊᓂᐦᐄ ᐄᑎᔓᐙᐎᓐ ᐊᓂᑎᐦ ᐐᔓᐙᐎᓂᐦᒡ ᐱᔮᐦᒋᓰᒥᑭᓐ, ᑖᑆᒥᑭᓐ, ᑭᔮᐦ ᒥᔻᔑᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","ᐋᐤ ᐋ ᒫᒃ ᐋ ᐃᓯᓈᑯᐦᒡ ᐊᓐ ᑳ ᒥᔻᔑᒡ ᐐᔓᐙᐎᓐ ᓂᐱᐎᓂᐦᒡ ᒑ ᒌ ᐄᑐᐦᑎᐦᐄᑯᔮᓐ? ᓂᒫ᙮ ᒥᒋᐦᑣᐎᓐ ᐋᐅᒄ ᓂᐱᐎᓂᐦᒡ ᑳ ᐄᑐᐦᑎᐦᐄᑯᔮᓐ᙮ ᐊᓐ ᒥᔪᐐᔓᐙᐎᓐ ᐋᑯᑖᐦ ᑳ ᐙᐦᒋ ᓅᑯᐦᒡ ᑖᓐ ᐃᔥᐱᔥ ᒫᔮᑎᐦᒡ ᒋᒥᒋᐦᑣᐎᓂᐤ᙮ ᐙᔥ ᐊᓐ ᒋᒥᒋᐦᑣᐎᓂᐤ, ᒋᔖᒥᓂᑑ ᐆ ᒥᔪᐐᔓᐙᐎᓐ ᐋᐱᑎᓂᔨᐤ ᒑ ᒌ ᓂᓲᓈᒋᒥᑯᐦᐅᒄ᙮ ᐋᑯᑎᐦ ᒫᒃ ᐊᓐ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᐆ ᐐᔓᐙᐎᓐ, ᓅᑯᐦᒡ ᑖᑭᔥ ᐊᓐ ᐃᔥᐱᔥ ᓈᔥᒡ ᒫᔮᑎᐦᒡ ᒋᒥᒋᐦᑣᐎᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᐋᐦ ᑖᔨᒡ ᐋ ᒌ ᐅᐦᒋᐱᔨᐦᒡ ᐆ ᐐᔓᐙᐎᓐ᙮ ᓃᔨ ᐐᐦ, ᓂᔮᓯᒡ ᓂᐱᒫᑎᓰᓐ ᓃᔨ᙮ ᒧᔮᒻ ᒥᒋᐦᑣᐎᓐ ᐋ ᐅᒋᒫᐦᑳᑎᑯᔮᓐ ᐊᔨᑎᓲᒥᑯᔮᓐ ᒑ ᒌ ᐋᐱᑎᔒᔥᑎᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","ᓂᒧᐃ ᓂᓂᔅᑐᐦᑖᓐ ᒑᒀᓐ ᐙᐦᒋ ᑐᑎᒫᓐ ᐊᓐ ᒑᒀᓐ ᐋᐦ ᑐᑎᒫᓐ᙮ ᔖᔥ ᓂᒧᐃ ᓂᑎᐦᑐᑖᓐ ᐊᓐ ᑳ ᐐᐦ ᑐᑎᒫᓐ, ᑎᔨᑯᒡ ᐊᓐ ᐙᐦᑭᑎᒫᓐ ᐋᐅᒄ ᐊᓐ ᐋᐦ ᑐᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ᒥᔔ ᐋᐦ ᑐᑎᒧᐙᓈ ᐊᓐ ᐋᑳ ᐙᐦ ᑐᑎᒫᓐ ᐋᑯᑖᐦ ᐙᐦᒋ ᓅᑯᐦᒡ ᐋ ᑖᑆᐦᑎᒫᓐ ᐋ ᒥᔻᔑᒡ ᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","ᓂᒥᔮᐤ ᒫᒃ ᑖᑆᐦ ᓃᔨ ᑳᐦ ᑐᑎᒫᓐ ᐊᓐ ᐋᑳ ᑳ ᒥᔻᔨᐦᑎᒫᓐ ᐋᐦ ᑐᑎᒫᓐ᙮ ᐋᐅᒄ ᐊᓐ ᒥᒋᐦᑣᐎᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᑳᐦ ᑎᑯᐦᒡ ᑳᐦᑐᑖᑯᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","ᓂᒋᔅᒑᔨᐦᑖᓐ ᐋᐦᐋᑳ ᒥᑐᓐ ᒌ ᒥᔪᑐᑎᒫᓐ ᓃᔨ ᑎᐱᔨᐙ ᐋ ᐐᐦ ᒥᔪᑐᑎᒫᓐ, ᐅᑎᐦ ᑭᔨᑆ ᓈᐦᐄᐤ ᓂᐱᒫᑎᓰᐎᓂᐦᒡ᙮ ᐋᑎ ᐋᐦᑎᑯᐦᒡ ᐋ ᐐᐦ ᒥᔪᑐᑎᒫᓐ ᓂᒧᐃ ᐊᔮᐱᒡ ᓂᒌ ᒥᔪᑐᑖᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","ᐙᔥ ᑖᐹ ᓂᑎᐦᑐᑖᓐ ᐊᓐ ᐙᐦ ᐄᔑ ᒥᔪᑐᑎᒫᓐ᙮ ᐊᓐ ᑳ ᒫᔮᐦᑎᐦᒡ ᐋᑳ ᑳ ᐐᐦ ᑐᑎᒫᓐ ᐋᐅᒄ ᐊᓐ ᐋᐦ ᐋᑎ ᑑᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","ᒥᔔ ᒫᒃ ᐋᐦ ᑐᑎᒫᓐ ᐊᓐ ᐋᑳ ᑳ ᐐᐦ ᑐᑎᒫᓐ, ᓂᒥᔮᐤ ᓃᔨ ᑳᐦ ᑐᑎᒫᓐ ᐊᓐ᙮ ᐊᓐ ᒥᒋᐦᑣᐎᓐ ᐅᑎᐦ ᐋᐦ ᑖᔮᓐ ᑳᐦ ᑎᑯᐦᒡ ᐋᐅᒄ ᐊᓐ ᑳᐦᑐᑖᑯᔮᓐ ᐆ ᒑ ᒌᐦ ᑎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","ᒫᐤ ᒫᒃ ᐋ ᐄᔑ ᐙᐱᐦᑎᒫᓐ ᒨᔥ ᐋᐦ ᐄᔥᐱᔮᓐ᙮ ᐋᐦ ᐋᑎᐐ ᒥᔪᑐᑎᒫᓐᐦ ᔮᔨᑖ ᒨᔥ ᐊᔅᒋᐱᔨᐤ ᐋ ᐐᐦ ᒥᒋᐦᑐᑎᒫᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ᐅᑎᐦ ᐲᐦᒡ ᐋᐦ ᑖᔮᓐ ᓈᔥᒡ ᓂᒥᔻᔨᐦᑎᒥᐦᐄᑯᐙᓐ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","ᒥᒄ ᒫᒃ ᒫᐤ ᐋ ᐄᔑ ᐙᐱᐦᑎᒫᓐ ᒨᔥ ᐋ ᐐᐦ ᐄᔥᐱᔮᓐ᙮ ᑎᑯᓐ ᐋ ᐄᔑ ᒫᓯᐦᐄᑐᐱᔨᐦᒡ ᐅᑎᐦ ᓂᒥᑐᓈᐃᐦᒋᑭᓂᒡ, ᐊᓐ ᐋ ᐐᐦ ᒥᔪᑐᑎᒫᓐ ᑭᔮᐦ ᐊᓐ ᐋ ᐐᐦ ᒥᒋᐦᑐᑎᒫᓐ᙮ ᐊᓐ ᒫᒃ ᐋ ᒥᒋᐦᑐᑎᒫᓐ ᐋᐅᒄ ᑖᐹᔨᒥᑯᔮᓐ, ᐋᐦᐋᑦ ᒫᒃ ᐊᓐ ᒑ ᒌ ᓂᓃᔨᐦᑎᒫᓐ ᒋᔖᒥᓂᑑ ᐅᐐᔔᐙᐎᓐ ᐋᐅᒄ ᐙᐦᑎᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","ᑖᑆᐦ ᑭᔨᑆ ᓅᔥᑖᐱᔨᓐ᙮ ᐊᐙᓐ ᒫᒃ ᒑ ᐹᒋ ᐱᑯᐦᐄᑦ ᐅᑎᐦ ᐅᔮᔨᐤ ᒥᔮᔨᐤ ᒑ ᓂᐲᒥᑭᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","ᓂᓈᔅᑯᒫᑖᐤ ᒋᔖᒥᓂᑑ ᐊᓐ ᐙᒋᐦᐄᑎᐦᒃ ᒌᓴᔅ ᙭ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᐅᐦᒋ᙮ ᒫᐤ ᐋᐦ ᐄᔥᐱᔮᓐ᙮ ᓃᔨ ᐅᑎᐦ ᑎᐱᔨᐙ ᐋᐦ ᑖᔮᓐ ᓂᒥᔻᔨᐦᑎᒥᐦᐄᑯᐙᓐ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓐ ᑭᔮᐦ ᓂᐐ ᓂᓂᐦᐄᐦᑎᒸᓐ᙮ ᒥᒄ ᒫᒃ ᐊᓂᑎᐦ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔮᓐ ᑎᑯᓐ ᐋ ᐄᔑ ᐅᑖᐱᒌᐦᐄᑭᓂᑖᑯᔮᓐ ᒥᒋᐦᑣᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","ᓂᒧᐃ ᔖᔥ ᑎᑯᓐ ᐊᓂᑎᐦ ᒑ ᐅᐦᒋ ᓂᔑᐎᓈᒋᒥᑯᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᙭ ᒌᓴᔅ ᑳ ᐐᒑᐙᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","ᐙᔥ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᒌ ᑐᑖᑯᔨᓂᐤ ᒑ ᒌ ᐱᒫᑎᓰᐅᒄ ᙭ ᒌᓴᔅᐦ ᐅᐦᒋ᙮ ᐋᐅᒄ ᑳ ᐱᑯᐦᐄᑦ ᑖᓐ ᑳ ᐄᔑ ᑎᐹᔨᒥᑯᒡ ᒥᒑᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᓂᐱᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ᐆ ᐐᔓᐙᐎᓐ ᓂᒧᐃ ᑰᐦᒋ ᐱᒫᒋᐦᐄᑯᓈᓂᐤ ᐅᐦᒋ ᐙᔥ ᒋᔮᓂᐤ ᐄᔨᔨᐅᒡ ᓈᔥᒡ ᐊᐦᐋᑳ ᓵᐲᒡ ᑭᔮᐦ ᓂᒧᐃ ᑖᑭᔥ ᑰ ᒌ ᓂᓃᐦᑖᓈᓂᐤ ᐐᔓᐙᐎᓐ᙮ ᒥᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌᐦ ᑐᑎᒻ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᒌᐦ ᐄᑖᐱᑎᓰᒥᑭᓃᒡ ᐊᓂᔮᔨᐤ ᐐᔓᐙᐎᓐ᙮ ᑳ ᐹᒋ ᐄᑎᔑᐦᐙᑦ ᐅᑯᓯᔅᐦ, ᒨᔮᒻ ᒌᔮᓂᐤ ᐋᒥᒋᐦᑣᐦᔨᐦᒄ ᐋ ᐃᓯᓈᑯᓲᐦᒄ ᒑ ᒌ ᐄᔑᓈᑯᓯᒡ᙮ ᒌ ᐹᒋ ᐄᑎᔑᐦᐙᐤ ᒑ ᒌ ᓂᐴᔅᑏᒫᑏᑖᐦᒄ ᒑ ᒌ ᐱᒋᔅᑏᓂᒑᓲᐐᒡ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᒋᒥᒋᐦᑣᐎᓂᐤ᙮ ᐋᑯᑎᐦ ᒫᒃ ᑳ ᐅᐦᒋ ᐄᔮᔨᐆᐦᑖᑦ ᐊᓂᔮᔨᐤ ᑳ ᐅᐦᒋ ᑎᐹᔨᒥᑰᐦᒃ ᒫᒋᐦᑣᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ᒌᐦ ᑐᑎᒻ ᐅᔮᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᒥᑐᓐ ᑎᐱᑑᑎᒥᐦᒄ ᑖᓐ ᐋ ᐄᔑ ᑯᐃᔅᒄ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᐊᑎᔓᐙᒥᑭᓃᔨᒡ ᐅᐐᔓᐙᐎᓐ᙮ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋ ᑎᐹᔨᒥᑎᐦᒄ ᐋᒄ ᐃᔮᒄ ᒑ ᒌ ᑎᐱ ᑐᑎᒥᐦᒄ ᐆ, ᓂᒧᐃ ᐐᔨ ᒌ ᒥᒑᑎᓰᐎᓂᓂᐤ ᐋ ᑎᐹᔨᒥᑯᔨᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","ᐊᓂᒌ ᒫᒃ ᒥᒄ ᑖᐹᔨᒥᑯᒡ ᒑ ᒌ ᒥᒑᑎᓯᒡ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ, ᒥᒄ ᐐᔨᐙᐤ ᓂᑎᐐ ᒥᒄ ᒑ ᒌ ᐄᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓯᐎᒡ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒧᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᑳ ᐱᒋᔅᑎᓈᒡ ᒑ ᒌ ᑎᐹᔨᒥᑯᒡ ᑖᓐ ᒑ ᐄᔑ ᐱᒫᑎᓰᔨᒡ, ᐱᔑᔑᐦᒄ ᒑ ᒌ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐋᒡ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","ᓂᑎᐐ ᒥᒄ ᐐᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᒑ ᐊᐙᓐ, ᑭᑎ ᓂᐱᐦᐄᑰ ᐅᔮᔨᐤ ᐋᐦᑎᒃ᙮ ᐱᔑᔑᐦᒄ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᒑ ᒌ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐋᑦ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᐦᒃ ᐊᐙᓐ ᐱᒫᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᒋᔮᒫᔨᐦᑎᒧᐎᓂᔨᐤ ᐃᔮᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ᐙᔥ ᐊᓂᒌ ᓂᑎᐐ ᒥᒄ ᒑ ᒌ ᐄᔑ ᓂᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᒡ ᑳ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᐦᒡ ᓂᔥᑰᔥᑎᐙᐅᒡ ᒋᔖᒥᓂᑑ᙮ ᓂᒧᐃ ᑐᑎᒧᒡ ᑖᓐ ᐋᑎᔓᐙᔨᒡ᙮ ᓂᒧᐃ ᒋᑭ ᒌᐦ ᑐᑎᒧᐙᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ᐊᓂᒌ ᓂᑎᐐ ᒥᒄ ᑳ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᓂᒧᐃ ᒋᑭ ᒌ ᓂᐦᐋᔨᐦᑎᒥᐦᐋᐅᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","ᒌᔨᐙᐤ ᒫᒃ ᐐ, ᓂᒧᐃ ᒋᑎᐹᔨᒥᑯᓈᐙᐤ ᓂᑎᐐ ᒥᒄ ᐋ ᐐᐦ ᐄᔑ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᓱᔮᒄ᙮ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋᐅᒄ ᑖᐹᔨᒥᑖᒄ ᒥᔔ ᑖᑆᐦ ᐹᐦᒋᔥᑳᑎᐙᒀ᙮ ᐊᐙᓐ ᒫᒃ ᐋᑳ ᐹᐦᒋᔥᑳᑰᒀ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᓂᒧᐃ ᑎᐹᔨᒥᑰ ᙭᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","᙭ ᒫᒃ ᐋ ᐲᐦᒋᔥᑳᑖᒄ ᐋᑯᑖᐦ ᐙᐦᒋ ᐄᔅᐱᔨᔨᒡ ᑖᑆᐦ ᒑ ᒌ ᐱᒫᑎᓰᔨᒡ ᒋᑎᐦᒑᐦᑯᐙᐅᒡ, ᐙᔥ ᐋ ᑯᐃᔅᑯᑖᑎᓰᐙᒄ ᒋᑎ ᐄᔑ ᑭᓂᐙᐱᒥᑯᐙᐤ ᒋᔖᒥᓂᑑ, ᐋᑦ ᐋᓅᐦᒡ ᐋᐦ ᐋᑎ ᓂᐲᒥᑭᐦᒡ ᒌᔨᐙᐤ ᐊᓐ ᐅᐦᒋ ᐋ ᒥᒑᑎᓯᔮᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","ᒥᔔ ᐹᐦᒋᔥᑳᑎᑎᐙᒀ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ, ᒋᔖᒥᓂᑑ ᐊᓐ ᑳ ᐙᓂᔥᑳᓈᑦ ᒌᓴᔅᐦ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᒑᔥᑎᓈᔥ ᒋᔖᒥᓂᑑ ᒋᑭ ᐎᓂᔥᑳᓂᑯᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ᐋᑯᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᐱᒫᒋᐦᑖᑭᓂᐎᒡ ᐊᓂᐦᐄ ᐋ ᓂᐲᒥᑭᐦᒡ ᒋᔮᐙᐤᐦ, ᐋ ᐐᒑᑏᑖᒄ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","ᓃᒋᔖᓂᑎᒄ, ᔮᔨᑖᐃ ᒋᓂᑎᐙᔨᐦᑖᑯᓯᓈᓂᐤ ᐋᑳ ᒑ ᒌ ᒥᒋᓂᑐᐙᔨᐦᑎᒧᒥᑭᐦᒡ ᐄᔑ ᐱᒫᑎᓰᔨᐦᒄ, ᓂᒧᐃ ᒋᐱᐦ ᐅᐦᒋ ᐄᔑ ᐱᒫᑎᓰᓈᓂᐤ ᑖᓐ ᐋ ᐄᔑ ᒥᒋᓂᑐᐙᔨᐦᑎᒧᒥᑭᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","ᐙᔥ ᐊᓐ ᐄᔑ ᐱᒫᑎᓰᔨᓈ ᑖᓐ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒨᒥᑭᐦᒡ ᒋᔮᔅ ᒋᑭ ᓂᐱᓐ᙮ ᐱᒋᔅᑎᓂᑖ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒑ ᒌ ᐐᒋᐦᐄᔅᒃ ᒑ ᒌ ᐴᓂᐦᑖᐙᑦ ᑖᓐ ᐙᐦ ᐄᔑ ᐙᐦᒋᐱᔨᔨᒡ ᒑ ᒌ ᒥᒋᐦᑑᑎᒧᑦ ᐋᒄ ᑭᔨᑆ ᑖᑆᐦ ᒑ ᐱᒫᑎᓰᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","ᒥᓯᐙ ᐊᓂᒌ ᑳ ᐱᔮᐦᒋᓰᔨᒡᐦ ᐊᐦᒑᐦᒄᐦ ᑳ ᒋᔅᒋᓄᐦᑎᐦᐄᑯᒡ ᒋᔖᒥᓂᑑ ᐅᑎᐙᔑᔒᒥᑐᑖᑰᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","ᐙᔥ ᑖᐹ ᒋᑎᐦᑐᑖᑯᐙᐤ ᐊᓐ ᐊᐦᒑᐦᒄ ᒋᔖᒥᓂᑑ ᑳ ᒥᔨᑖᒄ ᒦᓐ ᑳᐤ ᒑ ᒌ ᑎᐹᔨᒥᑯᐙᒄ ᓵᒋᓯᐎᓂᔨᐤ᙮ ᐆ ᐊᐦᒑᐦᒄ ᐅᐦᒋ ᐋᑯᑖᐦ ᐙᐦᒋ ᐄᔑᐦᐄᑎᐦᒄ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐅᑎᐙᔑᔒᒥᑖᑎᐦᒄ᙮ ᑭᔮᐦ ᒫᒃ ᒑ ᒌ ᐄᑎᒄ, “ᐋᐹ, ᓅᐦᑖ᙮” ");
INSERT INTO crl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑯᓂᐤ ᒋᑖᐦᐄᓈᐦᒡ ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐋ ᐅᑎᐙᔑᔒᒥᑖᑎᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","ᐋᒄ ᒫᒃ ᐋ ᐅᑎᐙᔑᔒᒥᑖᑎᐦᒄ ᒋᔖᒥᓂᑑ ᒑᔥᑎᓈᔥ ᒋᑭ ᒥᔨᑯᓂᐤ ᐊᓂᔮᔨᐤ ᒥᔪᑐᑎᒫᒑᐎᓐ ᑳ ᐃᔮᔅᑰᔥᑎᒧᐙᑦ ᐅᑎᐙᔑᔒᒻ᙮ ᒌᔮᓂᐤ ᑭᔮᐦ ᒑ ᐃᔮᔨᐦᒄ ᑖᓐ ᑳ ᐄᔑ ᐋᓂᔅᒑ ᒥᔮᑭᓅᑦ ᐐᔨ ᙭᙮ ᐙᔥ ᒥᔔ ᐐᒋᓂᓈᐦᑳᑖᔨᒨᒥᐦᒀ ᙭ ᑭᔮᐦ ᒌᔮᓂᐤ ᒋᑭ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᑯᓈᓂᐤ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᑭᓄᒑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","ᓃᔨ ᐋ ᐄᑖᔨᐦᑎᒫᓐ ᑖᓐ ᐋ ᐄᔑ ᓂᓈᐦᑳᑖᔨᒧᔨᐦᒄ ᐊᓅᐦᒡ ᓂᒧᐃ ᒥᑐᓐ ᒑᒀᓐ ᒋᑭ ᐅᐦᒋ ᐄᑖᔨᐦᑖᑯᓐ ᒑ ᐃᔥᐱᔥ ᓈᔥᒡ ᒨᒌᒑᔨᐦᑖᑯᐦᒡ ᐄᔥᐱᐦ ᐅᑎᐦᒋᐱᔨᐦᒑ ᐊᓂᑎᐦ ᒑ ᓅᑯᐦᑖᑭᓂᐎᒡ ᐋ ᒋᔅᑖᔨᐦᑖᑯᐦᐄᑎᐦᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","ᒥᓯᐙ ᒑᒀᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐅᔑᐦᑖᑦ ᒋᔖᒥᓂᑑ ᓈᔥᒡ ᐱᒀᔨᐦᑎᒨᒥᑭᓂᔨᐤ ᐋ ᐊᔓᐙᐱᐦᑎᒧᒥᑭᓃᔨᒡ ᒑ ᐃᔥᐱᔥ ᒧᔖ ᓅᑯᐦᐋᑦ ᐅᑎᐙᔑᔒᒻ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","ᐙᔥ ᐊᓐ ᒥᓯᐙ ᒑᒀᓐ ᑳ ᐅᔑᐦᑖᑭᓂᐎᒡ ᔖᔥ ᓂᒥ ᒥᔻᓯᐤ ᐊᓐ ᑳ ᐃᓯᓈᑯᐦᒡ ᐊᓂᑖᐦ ᐅᔅᑭᒡ᙮ ᓂᒥᔮᔨᐤ ᐐᔨᐙᐤ ᑳᑑᑎᐦᒡ᙮ ᒋᔖᒥᓂᑑ ᒌ ᐱᒋᔅᑎᓂᒻ ᒥᓯᐙ ᒑᒀᔨᐤ ᒑᒃ ᒑ ᐋᑎ ᐃᔮᔫᐎᓃᒡ, ᒥᒄ ᒫᒃ ᐊᔮᐱᒡ ᒋᔖᒥᓂᑑ ᒌ ᒥᔨᐙᐤ ᐊᔅᐹᔨᒧᐎᓂᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","ᐊᓂᔮᔨᐤ ᒥᓯᐙ ᑳ ᐅᔑᐦᑖᑦ ᐋᔥᒄ ᐹᔨᒀᐤ ᐋ ᒌᔑᑳᔨᒡ, ᒋᑭ ᐱᑯᐦᐅᒥᑭᓄᔨᐤ ᐊᓂᑎᐦ ᑳ ᐄᔑ ᑎᐹᔨᐦᑖᑯᓃᔨᒡ ᐃᔮᔪᔒᐎᓂᒡ, ᑭᔮᐦ ᒫᒨ ᒑ ᐄᔑ ᐱᑯᐦᐅᔨᒡ ᒋᔖᒥᓂᑑ ᐅᑎᐙᔑᔒᒻ ᑖᐱ ᒦᔻᔨᐦᑎᒧᐎᓂᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᐊᓂᑎᐦ ᒥᓯᐙ ᑖᓐ ᑳ ᐄᔑ ᐅᔑᐦᑖᑦ ᒋᔖᒥᓂᑑ ᐋᔥᒄ ᑭᔮᐦ ᐊᓅᐦᒡ ᐋ ᒥᒫᑣᐦᐄᐙᔨᒡ ᓂᓈᐦᑳᑖᔨᒨᐐᓂᔨᐤ, ᒧᔮᒻ ᐃᔅᒀᐤ ᐋ ᐄᔑ ᒥᒫᑣᐄᑯᑦ ᐄᔥᐱᐦ ᐋᐦ ᐋᑎ ᒋᐦᒋᐱᔨᔨᒡ ᒑ ᐙᐱᒫᐅᓱᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","ᓂᒧᐃ ᒫᒃ ᒥᒄ ᐅᐦᐄ ᒑᒀᓂᐦᐄ ᓂᓈᐦᑳᑖᔨᒨᒥᑭᓐ᙮ ᒌᔮᓂᐤ ᑭᔮᐦ ᒌ ᓂᓈᐦᑳᑖᔨᒧᓈᓂᐤ ᐋ ᒥᒫᑣᐦᐄᑯᔨᐦᒄ ᒋᑖᐦᐄᓈᐦᒡ ᒫᒀᒡ ᓈᔥᒡ ᐋ ᐱᒀᔨᐦᑎᒥᐦᒄ ᐋ ᐊᔑᓂᐙᓰᔨᐦᒄ ᒋᔖᒥᓂᑑ ᐅᑎᐙᔑᔒᒻ, ᒑ ᒌ ᐄᔑ ᓅᑯᐦᐄᑭᐎᔨᐦᒄ ᐋ ᐄᔑ ᐅᑎᓂᑭᐎᔨᐦᒄ ᐋᑳ ᓂᐦᑖ ᒦᓐ ᒑ ᒌ ᓂᓈᐦᑳᑖᔨᒧᔨᐦᒄ ᒋᔮᓈᐦᒡ᙮ ᔖᔥ ᒫᒃ ᒋᒌ ᒥᔨᑯᓂᐤ ᒋᔖᒥᓂᑑ ᐅᑎᐦᒑᐦᒄ ᒑ ᒌ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᒥᐦᒄ ᒥᓯᐙ ᑖᑆᐦ ᒑ ᐄᔅᐱᔨᔨᒡ ᐅᔮᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","ᐙᔥ ᐋᐅᒄ ᑳ ᐄᔑ ᐊᔅᐹᔨᒧᔨᐦᒄ ᐃᔥᐱᔥ ᑳ ᐱᒫᒋᐦᐄᑭᐎᔨᐦᒄ᙮ ᐄᔥᐱᐦ ᒫᒃ ᒌ ᐅᑎᐦᒋᐱᔨᐦᒑ ᑭᔨᑆ ᓂᒧᐃ ᐋᒄ ᒋᑭ ᐅᐦᒋ ᐊᔅᐹᔨᒧᓈᓂᐤ᙮ ᐙᔥ ᑖᐹ ᐊᔅᐹᔨᒨ ᐊᐙᓐ ᒑᒀᔨᐤ ᒑ ᒌ ᐄᔅᐱᔨᔨᒡ ᔖᔥ ᐋ ᒌ ᐄᔅᐱᔨᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","ᒌ ᐱᑯᓵᔮᐱᑖᓈᓂᐤ ᒫᒃ ᒑᒀᓐ ᐋᐦᐋᑳ ᓂᐦᑖ ᐅᐦᒋ ᐙᐱᐦᑎᒧᒄ᙮ ᓂᒧᐃ ᒌ ᐱᒋᔥᑖᔨᒧᓈᓂᐤ ᒫᒃ ᐋᐦ ᐋᔓᐙᐱᐦᑎᒥᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","ᐋᑳ ᓵᐱᓯᔨᐦᒄ, ᐊᔨᒥᐦᐋᔨᐦᒄ ᓂᒧᐃ ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᒑ ᐄᔑ ᐋ ᐊᔨᒥᐦᐋᔨᐦᒄ, ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋᐅᒄ ᐙᒋᐦᐄᑎᐦᒄ᙮ ᐋᑯᑖᐦ ᒫᒃ ᓈᑐᑎᒫᔅᑎᒫᑎᐦᒄ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᐋ ᒫᒫᑣᐦᐄᑯᑦ ᐋᐦᐋᑳ ᒌ ᐐᐦᑖᑭᓅᐎᒡ ᐊᔨᒧᐎᓂᔨᐤ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","ᒋᔖᒥᓂᑑ ᒫᒃ ᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ ᒥᓯᐙ ᒋᑖᐦᐄᓂᐤᐦ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓐ ᓂᐦᐋᐤ ᐋ ᐄᔑ ᓂᑐᑎᒫᔅᑎᒫᒑᔨᒡ ᐊᐦᒑᐦᒄ, ᐙᔥ ᓂᑐᑎᒫᔅᑎᒫᒑᔨᐤ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ ᐄᔑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","ᒋᒋᔅᒑᔨᐦᑖᓈᓂᐤ ᒫᒃ ᒥᓯᐙ ᒑᒀᔨᐤ ᐋᐦ ᐄᔅᐱᔨᔨᒡ ᐅᐱᒫᑎᓯᐎᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᓵᒋᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ ᑐᑎᒧᐙᐤ ᒥᓯᐙ ᒑ ᒌ ᒥᔪᑐᑖᑯᔨᒡ᙮ ᐋᔪᐎᒄ ᐋᐦ ᑐᑎᒧᐙᑦ ᐊᓂᔮᔨᐤ ᐐᔨ ᑳ ᐄᑖᔨᐦᑎᐦᒃ ᒑ ᐅᐙᔮᐱᒫᑦ ᒑ ᒌ ᐅᑏᔨᔨᒥᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","ᐙᔥ ᓂᔮᑭᓐᐦ ᒌ ᒋᔅᒑᔨᒫᐤ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ ᒑ ᐅᑏᔨᔨᒥᑦ, ᐋᔨᐅᑯᓐ ᒫᒃ ᐅᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ ᒑ ᓂᔅᐱᑎᐙᔨᒡ ᐅᑯᓯᔅᐦ᙮ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳᐦ ᑎᒃ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᓃᔥᑎᒨᔖᓂᐎᔨᒡ ᐅᑯᓯᔅᐦ ᐊᓂᑎᐦ ᑖᐙᔨᔥ ᐋ ᒥᐦᒑᑎᔨᒡ ᐐᒋᔖᓂᒫᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ᐊᓂᔮᔨᐤ ᒫᒃ ᓂᔮᑭᓐᐦ ᑳ ᐎᔮᔨᒫᑦ ᐊᐙᔨᐤᐦ ᒌ ᓂᑑᒫᐤ ᒑ ᒌ ᓈᑎᑯᑦ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳ ᓂᑑᒫᑦ ᒌ ᑯᐃᔅᑯᓈᑯᐦᐋᐤ ᐐᔨ ᐄᔑ ᐋᐦ ᑖᑦ᙮ ᐅᔮᔨᐤ ᒫᒃ ᑳ ᑯᐃᔅᑯᓈᑯᐦᐋᑦ ᒌ ᒋᔅᑖᔨᐦᑖᑯᐦᐋᐤ ᑭᔮᐦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ᒥᓯᐙ ᒫᒃ ᐆ ᐋ ᒋᔅᒑᔨᐦᑎᒥᐦᒄ ᒫᐤ ᒑ ᒌ ᐃᔨᐦᒄ, ᑖᑆᐦ ᒋᔖᒥᓂᑑ ᐙᒋᐦᐄᑐᐦᒀ ᓂᒧᐃ ᐊᐙᓐ ᒋᑭ ᒌ ᓵᑯᐦᐄᑯᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","ᓂᒧᐃ ᐙᐙᒡ ᐅᑯᓯᔅᐦ ᑰᐦᒋ ᒋᔖᑎᓂᒫᑯᓂᐤ᙮ ᒌ ᐱᒋᔅᑎᓈᐤ ᒥᒄ ᒑ ᒌ ᓂᐳᔅᑎᒫᑏᑎᐦᒄ ᒌᔮᓂᐤ ᐅᐦᒋ, ᐋᑯᑖᐦ ᒑ ᐅᐦᒋ ᒑᔥᑎᓈᐦᐅᔨᐦᒄ ᒥᒄ ᒑ ᐄᔑ ᒥᔨᑎᐦᒄ ᒥᓯᐙ ᑯᑎᒋᔨᐤ ᒑᒀᔨᐤ ᐃᔥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","ᐊᐙᓐ ᒑ ᒌ ᒫᒥᔑᒫᑦ ᒋᔖᒥᓂᑑ ᐅᐙᔮᐱᒫᑭᓂᔨᐤ᙮ ᐐᔨ ᒋᔖᒥᓂᑑ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐄᔑ ᑭᓂᐙᐱᒫᐤ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ᓂᒧᐃ ᒫᒃ ᐊᐙᓐ ᒋᑭ ᒌ ᓂᔑᐎᓈᒋᒫᐤ ᒋᔖᒥᓂᑑ ᐅᐙᔮᐱᒫᑭᓂᔨᐤ ᒑ ᒌ ᐄᑖᑦ ᐋ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᒫᑯᐦᐄᒫᑭᓂᐎᔨᒡ ᐅᒥᒋᐦᑣᐎᓂᔨᐤ ᐅᐦᒋ᙮ ᐙᔥ ᓂᒧᐃ ᒥᒄ ᑰᐦᒋ ᓂᐳᔅᑎᒫᑯᓂᐤ ᙭ ᐋᔨᐤᐦ ᒌ ᐎᓂᔥᑳᓈᑭᓂᐤ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᒫᒀᒡ ᒫᒃ ᒋᔖᒥᓂᑑ ᐅᓂᐦᐄᐎᓃᔨᐦᒡ ᐊᐱᐤ ᐋ ᐊᔨᒥᐦᐋᔅᑎᒫᑎᐦᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","ᐊᐙᓐ ᒫᒃ ᒑ ᒌ ᐄᒑᓂᑎᐦᒄ ᙭ ᐅᓵᒋᐦᐄᐙᐎᓃᐦᒡ ᐅᐦᒋ? ᐋᑦ ᓈᔥᒡ ᓂᓈᐦᑳᑖᔨᒧᔨᒀ ᑭᔮᐦ ᒫᒃ ᓈᔥᒡ ᐋᔨᒧᐦᐅᔨᐦᒀ, ᑭᔮᐦ ᐋᑎᐙᐐᓯᒑᔨᐦᑎᒥᐦᐄᑭᐎᔨᒀ, ᐋᑦ ᐄᔑᓈᑯᐦᒑ ᒑ ᒌ ᑭᐎᐦᑭᑖᔨᐦᒄ, ᑭᔮᐦ ᐋᑎ ᓈᔥᒡ ᒋᔅᑎᒫᑎᓯᔨᒀ, ᐋᑎ ᓈᔥᒡ ᑯᔥᑖᑎᑯᐦᒑ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᐦᒄ ᑭᔮᐦ ᒫᒃ ᐋᑎ ᓂᐱᐦᐄᑭᐎᔨᐦᒀ ᓂᒧᐃ ᐊᔮᐱᒡ ᒋᑭ ᒌ ᐄᒑᐦᑎᐦᐄᑯᓈᓂᐤ ᒌᓴᔅ ᐅᓵᒋᐦᐄᐙᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐋᔑᑯᒻ ᒌᔑᑳᐤᐦ ᑯᔥᐱᓈᔨᐦᑖᑯᓐ ᒑ ᒌ ᓂᐱᐦᐄᑭᐎᔮᐦᒡ ᐋ ᓅᔔᔥᑳᑖᐦᒡ᙮ ᒧᔮᒻ ᒫᓂᔥᒑᓂᔑᒡ ᑳ ᐹᔑᐙᑭᓂᐎᒡ ᒑ ᒌ ᓂᐱᐦᐋᑭᓂᐎᒡ ᐋᐅᒄ ᐋ ᐃᓯᓈᑯᓯᔮᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ᐋᐦᐋᑦ ᒫᒃ ᒥᓯᐙ ᐆ ᐄᔑ ᓂᓈᐦᑭᐤ ᐄᔅᐱᔨᒡ ᐊᓂᑎᐦ ᐋᐦ ᑖᔨᐦᒄ ᒋᑎᔮᓈᓂᐤ ᐱᔅᒋᔮᒑᐎᓐ ᙭ ᐅᐦᒋ, ᐊᓐ ᑳ ᓵᒋᐦᐄᑎᐦᒄ ᐙᔥ ᐐᔨ ᒌ ᐐᒋᐦᐄᑯᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","ᓂᒑᔥᑎᓈᐦᐅᓐ ᐋᐦᐋᑳ ᒑᒀᓐ ᑎᑯᐦᒡ ᒑ ᒌ ᐄᒑᐦᑎᐦᐄᑯᔨᐦᒄ ᙭ ᐅᓵᒋᐦᐄᐙᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐴᓂᐱᒫᑎᓰᔮᒀ ᑭᔮᐦ ᒫᒃ ᒫᒀᒡ ᐋ ᐱᒫᑎᓰᔨᐦᒄ ᐊᔮᐱᒡ ᒋᓵᒋᐦᐄᑯᓂᐤ᙮ ᓂᒧᐃ ᐙᐙᒡ ᐋᓐᒋᓂᒡ ᑭᔮᐦ ᒫᒃ ᒥᒋᐊᐦᒑᐦᑯᐦᒡ ᒋᑭ ᒌ ᐄᒑᐦᑎᐦᐄᑯᓂᐎᒡ ᙭ ᐅᓵᒋᐦᐄᐙᐎᓃᔨᒡ ᐅᐦᒋ᙮ ᓂᒧᐃ ᒑᒀᓐ ᒋᑭ ᒌ ᐄᔅᐱᔨᐤ ᐊᓅᐦᒡ ᒫᒃ ᐊᓂᑖᐦ ᓃᔥᑖᒥᐦᒡ ᒑ ᒌ ᐄᒑᐦᑎᐦᐄᑯᔨᐦᒄ ᐅᓵᒋᐦᐄᐙᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ᓂᒧᐃ ᑎᑯᓐ ᓲᐦᒑᔨᐦᑖᑯᓯᐎᓐ ᐊᓂᑖᐦ ᐃᔥᐱᒥᐦᒡ ᑭᔮᐦ ᒫᒃ ᐅᑖᐦ ᓃᐦᑖᐦᒡ ᒑ ᒌ ᐄᒑᐦᑎᐦᐄᑯᐦᒄ ᐅᓵᒋᐦᐄᐙᐎᓂᐦᒡ᙮ ᑭᔮᐦ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᐋ ᒌ ᐅᔑᐦᑖᑦ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐄᒑᐦᑎᐦᐄᑯᐦᒄ ᙭ ᐆ ᓵᒋᐦᐄᐙᐎᓂᐦᒡ ᐅᐦᒋ᙮ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᑐᑎᒫᑎᐦᒄ ᒌᓴᔅ ᙭ ᒋᑎᐹᔨᐦᒋᒑᓰᒥᓂᐤ ᐋᑯᑖᐦ ᑳ ᐙᐱᐦᑎᔨᑎᐦᒄ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᓵᒋᐦᐄᑎᐦᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","ᓂᑖᑆᓐ ᐆ ᒑ ᐃᔮᓐ᙮ ᓂᒧᐃ ᓂ ᓂᓂᑎᔨᓐ ᐙᔥ ᙭ ᓂᑎᐹᔨᒥᒄ᙮ ᓂᒑᔥᑎᓈᐦᐅᓐ ᐋ ᑖᑆᔮᓐ ᑭᔮᐦ ᒫᒃ ᑳ ᐱᔮᐦᒋᓰᑦ ᐊᐦᒑᐦᒄ ᓂᒋᔅᒑᔨᐦᑎᒥᐦᐄᒄ ᐋ ᑖᑆᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","ᓈᔥᑖᑆᐦ ᓂᒥᓯᒫᔨᑖᓐ ᑭᔮᐦ ᒨᔥ ᐱᒥᐱᔨᐤ ᓈᔥᒡ ᐋ ᒥᑯᔅᑳᑖᔨᑎᒫᓐ ᐋ ᒫᒥᑐᓈᔨᒥᒀᐤ ᓃᒋ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","ᒥᔔ ᒌ ᓂᐦᐄᐱᔨᑯᐱᓈ ᒑ ᒌ ᑐᑖᑭᓂᐎᒡ ᓂᐱᐦ ᐱᒋᔥᑖᔨᒦᓱᓐ ᑎᐲᐙ ᓂᑏᔨᔨᒥᒡ ᐅᐦᒋ ᓃᔨ ᐋᑯᔥ ᒑ ᒌ ᒫᑯᐦᐄᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒫᒃ ᓃᔨ ᐋᑯᔥ ᒑ ᒌ ᐄᒑᐦᑎᐦᐄᑭᐎᔮᓐ ᙭ ᐅᐦᒋ ᐋᐦ ᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ᐙᔥ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᐱᒥᑯᒡ ᒑ ᒌ ᐅᑎᐙᔑᔒᒥᑖᑯᒡ ᑭᔮᐦ ᐐᔨᐙᐤ ᑳᐙᐱᐦᑎᔨᑯᒡ ᐆ ᒋᔅᑖᔨᐦᑖᑯᓱᐎᓂᔨᐤ᙮ ᒌ ᐅᔑᐦᑎᒫᑯᒡ ᓂᔅᑯᒧᐎᓂᔨᐤ᙮ ᒌ ᒥᔨᑯᒡ ᐐᔓᐙᐎᓂᔨᐤ᙮ ᒌ ᒋᔅᒑᔨᐦᑎᒥᐦᐄᑯᒡ ᑖᓐ ᑳᐦ ᐄᔑ ᐊᔨᒥᐦᐋᔅᑎᐙᒡ᙮ ᓂᓈᐦᑭᐤ ᒑᒀᔨᐤ ᒌ ᐄᑎᑯᒡ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒫᑯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","ᐊᓂᔮᐦᑳ ᐋᓂᔅᒑ ᒋᐙᐦᑯᒫᑭᓄᐤ ᐋᑉᕋᐦᐋᒻ, ᐋᐃᓯᒃ ᑭᔮᐦ ᒉᑭᑉ ᐋᐦ ᑖᔨᐦᒡ ᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐎᒡ᙮ ᐋᑯᑖᐦ ᑭᔮᐦ ᐐᔨ ᒌᓴᔅ ᙭ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᑦ ᐄᔥᐱᐦ ᓈᐹᒡ ᑳ ᐃᔑᐦᐋᑭᓅᑦ᙮ ᒋᔖᒥᓂᑑ ᐊᓐ ᒥᓯᐙ ᒑᒀᔨᐤ ᑳ ᐱᒥᐱᔨᐦᑖᑦ, ᑳᒋᒡ ᑭᑎ ᐐᔨ ᒫᒥᐦᒋᒫᑭᓂᐤ᙮ ᐋᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","ᓂᒧᐃ ᑭᔨᑆ ᑭᑎ ᒌ ᐄᓈᓂᐤ ᐋᐦᐋᑳ ᐅᐦᒋ ᑐᑎᐦᒃ ᒋᔖᒥᓂᑑ ᑖᓂᔮᔨᐤ ᑳᐦ ᐃᔨᑦ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᐦᒃ, ᐙᔥ ᑖᐹ ᒥᓯᐙ ᐊᓂᒌ ᒉᑭᑉ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ, ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᑳ ᐃᔑᓂᐦᑳᑎᓱᒡ, ᑖᑆᐦ ᐅᑏᔨᔨᒥᑖᑰᐎᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","ᑭᔮᐦ ᒫᒃ ᒥᒄ ᐱᔅᒡ ᐊᓂᒌ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐅᑏᔨᔨᒥᑖᑰᐎᒡ ᒋᔖᒥᓂᑑ᙮ ᐙᔥᑭᒡ ᐊᓂᑖᐦ, ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᐋᑉᕋᐦᐋᒻ, “ᐋᐃᓵᒃ ᐋᐦ ᑖᑦ ᒋᑭ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᐎᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᑳ ᐄᑎᑖᓐ ᒑᔥᑎᓈᔥ ᒑ ᒥᔨᑖᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒥᓯᐙ ᐊᐙᓐ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᔨᒡ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᑦ ᐅᑎᐙᔑᔒᒥᑖᑰ ᒋᔖᒥᓂᑑ᙮ ᒥᒄ ᐊᓂᒌ ᑳ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᔨᒡ ᐋᐅᑯᓂᒡ ᐙᔥ ᐊᓂᒌ ᒋᔖᒥᓂᑑ ᑳᐦᐄᑦ ᔖᔥ ᐊᓂᑖᐦ ᐹᒋ ᒑᔥᑎᓈᔥ ᒑ ᐅᑎᐙᔑᔒᒥᑑᐙᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ᐙᔥ ᒌᐦ ᐄᑖᐤ ᒋᔖᒥᓂᑑ ᐋᑉᕋᐦᐋᒻ ᐅᔮᔨᐤ ᒑᔥᑎᓈᔥ ᒑ ᑐᑎᒧᐙᑦ, “ᐹᔨᒄ ᐱᐳᓐ ᐃᔥᐱᔥ ᒑ ᐹᒋ ᓂᑎᐙᐱᒥᑖᓐ ᑭᔮᐦ ᔖᔥ ᑭᑎ ᐃᔮᐙᐤ ᓭᕌ ᐅᑯᓯᔅᐦ᙮” ");
INSERT INTO crl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","ᑭᔮᐦ ᐐᔨ ᒫᒃ ᕃᐹᑳ ᓂᔮᑭᓐᐦ ᒌ ᐐᐦᑎᒫᑰ ᒋᔖᒥᓂᑑ ᑖᓐ ᒑ ᐄᔅᐱᔨᔨᒡ᙮ ᐊᓂᔮᔨᐤ ᐅᑯᓯᔅᐦ ᑳ ᓃᔑᔨᒡ ᑖᐱᔥᑯᓐ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᒋᑖᓂᔅᒑ ᐙᐦᑯᒫᑭᓄᐤ ᐋᐃᓯᒃ ᐋᐦ ᑖᔨᒡ ᒌ ᐅᐦᒌᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","ᐋᒸᔮ ᒫᒃ ᐅᐦᒋ ᐱᒫᑎᓰᔨᒡ ᐅᔮᔨᐤ ᐋᓃᓰᔨᒡ ᐅᑯᓯᔅᐦ ᕃᐹᑳ, ᐋᔥᒄ ᐋᐦᐋᑳ ᐙᐙᒡ ᐅᐦᒋ ᒥᒋᐦᑑᑎᒥᔨᒡ ᑭᔮᐦ ᐋᐦ ᐋᑎ ᐋᔥᒄ ᐋᐦᐋᑳ ᐅᐦᒋ ᒥᔪᑐᑎᒥᔨᒡ, ᒌ ᐄᑎᑰ ᒋᔖᒥᓂᑑ, ");
INSERT INTO crl_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ᐊᓐ ᓃᔥᑎᒨᓵᓐ ᒋᑭ ᓃᑳᓂᔥᑳᑰ ᐊᓂᔮᔨᐤ ᐅᔑᒻᐦ᙮ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᒌᐦ ᐄᑖᐤ ᒑ ᒌ ᐙᐱᐦᑏᐙᑦ ᐐᔨ ᐋ ᐅᐙᔮᐱᒫᑦ ᑖᓂᔮᔨᐤ ᐙᐦ ᐅᐙᔮᐱᒫᑦ ᐊᐙᔨᐤᐦ ᒑ ᐅᑏᔨᔨᒥᑦ, ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔨᐦᑎᔨᒡ ᑭᔮᐦ ᒫᒃ ᐋᐦᐋᑳ ᐋ ᐄᔨᐦᑎᔨᒡ ᐊᐙᔨᐤᐦ ᐙᐦᒋ ᐅᐙᔮᐱᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᒌ ᓵᒋᐦᐋᐤ ᒉᑭᑉ ᐋᒄ ᐄᔂ ᑳ ᐅᐦᑳᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","ᑖᓐ ᒫᒃ ᒑ ᐄᔨᐦᒄ? ᒋᑭ ᒌ ᐄᓈᓂᐤ ᐋᐦᐋᑳ ᒫᒨᔮᒻ ᑎᒃ ᒋᔖᒥᓂᑑ? ᓂᒧᐃ ᑭᔨᑆ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","ᐙᔥ ᐙᔥᑭᒡ ᐊᓂᑖᐦ ᒋᔖᒥᓂᑑ ᒌᐦ ᐄᑖᐤ ᐊᓂᔮᔨᐤ ᒧᓱᔅ, “ᓂᑭ ᒋᔖᐙᑐᑎᐙᐤ ᐊᓐ ᐊᐙᓐ ᐙᐦ ᒋᔖᐙᑐᑎᐎᒃ ᑭᔮᐦ ᒫᒃ ᓂᑭ ᒋᔅᑎᒫᒑᔨᒫᐤ ᐊᓐ ᐊᐙᓐ ᐙᐦ ᒋᔅᑎᒫᒑᔨᒫᒄ᙮” ");
INSERT INTO crl_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","ᒋᔖᒥᓂᑑ ᒋᔅᑎᒫᒑᔨᒫᐤ ᑖᓂᔮᔨᐤ ᐊᐙᔨᐤᐦ ᐙᐦ ᒋᔅᑎᒫᒑᔨᒫᑦ᙮ ᓂᒥᔮᔨᐤ ᐐᔨ ᑖᓂᔮᔨᐤ ᐋ ᐄᔑ ᓂᑎᐙᔨᐦᑎᒥᔨᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᐄᔑ ᒥᔪᑐᑎᒥᔨᒡ ᐙᐦᒋ ᒋᔅᑎᒫᒑᔨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","ᐙᔥ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐐᐦᑖᑯᓐ ᕓᕎ ᐋ ᒌ ᐄᑖᑭᓅᑦ, “ᒋᒌ ᐎᔨᑳᐳᐦᐄᑎᓐ ᒑ ᒌ ᒋᐦᒋᐅᒋᒫᐎᔨᓐ ᐋᐦ ᐋᐱᒋᐦᐄᑖᓐ ᒑ ᒌ ᓅᑯᐦᑑᒀᐤ ᒥᓯᐙ ᐄᔨᔨᐅᒡ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᓂᓲᐦᑳᑎᓰᐎᓂᔨᐤ ᑭᔮᐦ ᒑ ᒋᔅᒑᔨᒥᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","ᐋᒄ ᒫᒃ ᒋᔖᒥᓂᑑ ᒑᔅᑎᒫᒑᔨᒫᑦ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐙᐦ ᒋᔅᑎᒫᒑᔨᒫᑦ, ᑭᔮᐦ ᒫᒃ ᑖᓂᔮᔨᐤ ᐙᐦ ᑐᑎᐙᑦ ᒑ ᒌ ᒥᔅᑭᐎᑖᐦᐋᔨᒡ ᐋᔪᐎᒄ ᐋᓐ ᐊᓂᔮᔨᐤ ᒫᔅᑭᐅᑖᐙᑦ ᐅᑖᐦᐄᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","ᒀᔣᓐ ᐹᔨᒄ ᐊᐙᓐ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᓂᐱᐦ ᒌ ᐄᑎᒄ, “ᑖᑆᐦ ᐆ ᐋᔑᓈᑯᓂᒀ, ᑖᓂᑖᐦ ᐊᔮᐱᒡ ᐙᐦᒋ ᐊᑖᒫᔨᒫᑦ ᒋᔖᒥᓂᑑ ᐊᐙᔨᐤᐦ ᒑᒀᔨᐤ? ᑖᐤ ᐋ ᐊᐙᓐ ᒑ ᒌ ᓂᔥᑯᔅᑎᒸᑦ ᐅᑎᑖᔨᐦᑎᒧᐎᓂᔨᐤ?” ");
INSERT INTO crl_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","ᐊᐙᓐ ᒫᒃ ᐋᑖᔨᒦᓱᔨᓐ ᒌᔨ ᐋ ᓈᐹᐎᓐ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᓂᔥᒀᐅᔑᐦᐄᑦ ᒋᔖᒥᓂᑑ? ᒋᑭ ᒌ ᐄᑎᑯᓈ ᐊᓐ ᓯᔅᒋᐤ ᐴᑖᔨ ᑳ ᐎᔨᔅᒎᒋᓂᑭᓂᐎᒡ, “ᒑᒀᓐ ᐆ ᐙᐦᒋ ᐄᔑᐦᐄᔨᓐ?” ");
INSERT INTO crl_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ᐊᓐ ᑳ ᐎᔨᔅᒎᒋᓂᒑᑦ ᓂᒧᐃ ᐋ ᒥᒄ ᒑᒀᔨᐤ ᐙᐦ ᐅᔑᑖᑦ ᒋᑭ ᒌ ᐅᔑᐦᑖᐤ? ᓂᒧᐃ ᐋ ᒋᑭ ᒌ ᐅᔑᐦᑖᐤ ᓃᔓ ᐎᔮᑭᓐ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᐹᔨᒀᐤ ᐋ ᐱᔅᑯᐱᔨᒡ ᓯᔅᒋᐤ᙮ ᐹᔨᒄ ᐎᔮᑭᓂᔨᐤ ᓈᔥᒡ ᐋ ᒥᔻᔒᔨᒡ ᒑ ᒌ ᐃᓯᓈᑯᐦᑖᑦ ᒥᒄ ᓂᔮᓂᑯᑐᓐ ᒑ ᒌ ᐋᐱᑎᓃᔨᒡ, ᑯᑎᒋᔨᐤ ᒫᒃ ᒨᔥ ᒑ ᒌ ᐋᐱᑎᓃᔨᒡ ᒑ ᒌ ᐃᓯᓈᑯᐦᑖᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᐋᐦᑎᒃ ᒋᔖᒥᓂᑑ᙮ ᒌ ᐎᔮᔨᐦᑎᒻ ᒑ ᒌ ᐙᐱᐦᑏᐙᑦ ᐅᑖᐦᑭᐎᐙᓯᐎᓐ ᑭᔮᐦ ᒫᒃ ᒋᐐᐦ ᒋᔅᒑᔨᐦᑖᑯᐦᑖᐤ ᐅᓱᐦᒑᔨᐦᑖᑯᓯᐎᓐ᙮ ᔮᐱᒡ ᐅᑖᐦᒡ ᒨᔥ ᒌ ᐹᒋ ᓰᐱᔨᐙᓰᔅᑎᐙᐤ ᐊᓂᔮᔨᐤ ᑳ ᒋᔑᐙᐦᐄᑯᑦ, ᐊᓂᔮᔨᐤ ᑳ ᐄᑖᔨᐦᑖᑯᓃᔨᒡ ᒑ ᒌ ᓂᔑᐎᓈᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᐎᔮᔨᐦᑎᐦᒃ ᐋ ᒌ ᐐᐦ ᐙᐱᐦᑏᐙᑦ ᐋ ᐃᔥᐱᔥ ᐙᔫᑎᓃᔨᒡ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ ᐊᓂᔮᔨᐤ ᑳ ᐄᔑ ᒥᔮᑦ ᐊᓂᔮᔨᐤ ᑳ ᐎᔮᔨᒫᑦ ᒑ ᒌ ᒋᔖᐙᑐᑎᐙᑦ, ᐋᔪᐎᒄ ᒌᔮᓂᐤ᙮ ᓂᔮᑭᓐᐦ ᒋᒌ ᐎᔮᔨᒥᑯᓂᐤ ᒑ ᒌ ᒋᔅᒑᔨᐦᑎᒧᒄ ᐅᒋᔅᑖᔨᐦᑖᑯᓯᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ᒌᔮᓂᐤ ᒋᒌ ᑖᑆᑎᑯᓂᐤ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐅᑏᔨᔨᒥᑖᑎᐦᒄ᙮ ᓂᒧᐃ ᒫᒃ ᒥᒄ ᓃᔮᓐ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓯᔮᐦᒡ ᓅᐦᒋ ᑖᑆᑎᑯᓂᐤ ᑭᔮᐦ ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᒋᒌ ᑖᑆᑎᑯᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐃᔮᔨᒨᑎᐦᒃ ᒋᔖᒥᓂᑑ ᐊᓂᑖᐦ ᐊᓂᔮᔨᐤ ᐦᐅᓵᔮ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ ᐅᑎᔨᒧᐎᓃᔨᒡ᙮ ᐊᒀᑖᔥᑖᔨᒡ ᐊᓂᑎᐦ, ᐊᓂᒌ ᐋᑳ ᑳ ᐅᑏᔨᔨᒥᑐᑎᐎᒀ, ᓂᑎᐄᔨᔨᒥᒡ ᓂᑭ ᐃᔑᓂᐦᑳᑖᐅᒡ᙮ ᐋᒄ ᐊᓂᒌ ᐋᑳ ᑳ ᓵᒋᐦᐋᑭᓂᐎᒡ ᓈᔥᒡ ᓂᑭ ᓵᒋᐦᐋᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","ᐊᓂᑎᐦ ᓂᐦᐋᐤ ᒫᒀᒡ ᑳᐦ ᑖᒡ ᑳᐦ ᐄᑎᑯᐙᑯᐱᓈ ᒋᔖᒥᓂᑑ, ᓂᒥᔮᐤ ᒌᔨᐙᐤ ᓂᑎᐄᔨᔨᒥᒡ, ᐋᑯᑖᐦ ᐊᓂᑎᐦ ᓂᐦᐋᐤ ᒑ ᐃᔑᓂᐦᑳᑖᑭᓂᐎᒡ, ᐅᑎᐙᔑᔒᒻ ᐊᓐ ᑳ ᐱᒫᑎᓰᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","ᐋᒄ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᒌᐦ ᑎᑯᓂᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐋᔨᒨᒫᑦ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ᙮ ᒌ ᐃᔨᑖᑯᐱᓐ, ᐋᑎ ᐋ ᐃᔥᐱᔥ ᐙᔪᑎᓰᔨᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᒧᔮᒻ ᐋ ᐃᔥᐱᔥ ᐙᔫᑖᐅᑳᒡ ᔮᑳᐤ ᔑᔓᒡ ᒋᐦᒋᑭᒦᐦᒡ ᐊᔮᐱᒡ ᓂᒧᐃ ᒥᐦᒑᑐ ᑭᑎ ᐅᐦᒋ ᐱᒫᒋᐦᐅᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","ᐙᔥ ᒋᑭ ᒋᔨᐲᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑎᐹᔅᑯᓈᒑ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᐅᑎᐦ ᐊᔅᒌᐦᒡ ᑳᐦ ᑖᔨᒡ ᑭᔮᐦ ᒑᔥᑎᓈᔥ ᐋᔪᐎᒄ ᒑ ᐃᓯᓈᑯᓃᔨᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳᐦ ᐃᔨᑦ ᒑ ᐄᔑ ᑎᐹᔅᑯᓂᒑᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","ᓂᐦᐋᐤ ᑳᐦᐄᑦ ᐙᔅᑭᒡ ᐊᓂᔮᐦ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ, ᒥᔔ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒫᐅᒡ ᑳ ᓲᐦᑳᑎᓰᑦ ᐋᑳ ᐅᐦᒋ ᐎᔮᔨᐦᑎᒥᑯᐱᓈ ᐱᔅᒡ ᐊᓂᔮᔨᐤ ᐋᓂᔅᒑ ᒋᑎᐙᔑᔒᒥᓄᐤ ᒑ ᒌ ᐱᒫᒋᐦᐋᑦ ᒥᓯᐙ ᒋᐱᐦ ᓂᔑᐎᓈᑎᓰᓈᓂᐤ ᒧᔮᒻ ᑳ ᐄᔑ ᓂᔑᐎᓈᒋᐦᐋᑭᓂᐎᒡ ᐊᓂᔮᐦᑳ ᐄᔨᔨᐅᒡ ᔂᑐᒻ ᑭᔮᐦ ᒀᒧᕌ ᑳᐦ ᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ᒫᐤ ᐋ ᐄᔑ ᐐᐦᑎᒫᒑᒥᑭᐦᒡ ᒥᓯᐙ ᐆ ᑳ ᐄᔑ ᐋᔨᒨᑖᒡ, ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᓂᒧᐃ ᐙᐙᒡ ᐅᐦᒋ ᑯᒋᐦᑖᐅᒡ ᒑ ᒌ ᑯᐃᔅᑯᓈᑯᐦᐄᓱᒡ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᐋᔪᐎᒄ ᐋᓐ ᒫᒃ ᐅᔮᔨᐤ ᒋᔖᒥᓂᑑ ᑳ ᑯᐃᔅᑯᓈᑯᐦᐋᑦ ᐄᔥᐱᐦ ᑳ ᑖᑆᔮᔨᐦᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ᐋᒄ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒋᔖᒥᓂᑑ ᑳ ᐅᑏᔨᔨᒥᑖᑯᒡ, ᐋ ᓂᓂᐦᐄᐦᑎᐦᒡ ᐐᔓᐙᐎᓐ ᒋᐐᐦ ᐅᐦᒋ ᑯᐃᔅᑯᓈᑯᐦᐄᓲᐎᒡ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᓂᒧᐃ ᒫᒃ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐅᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑰᐎᒡ ᒋᔖᒥᓂᑑ ᐅᔮᔨᐤ ᐋ ᒌ ᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","ᒑᒀᔨᐤ ᒫᒃ ᐙᐦᒋ ᐋᑳ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐅᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒧᑯᒡ ᒋᔖᒥᓂᑑ? ᓂᒧᐃ ᐅᐦᒋ ᑖᑆᔮᔨᒫᐅᒡ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᑯᐃᔅᑯᓈᑯᐦᐄᑯᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐙᐦᒋ ᐋᑳ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᐅᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑯᒡ ᒋᔖᒥᓂᑑ᙮ ᐅᑖᐦ ᒌ ᐄᑖᔨᐦᑎᒧᒡ, ᐋ ᒥᔪᑐᑎᒫᐦᒡ ᒋᑭ ᐅᐦᒋᐱᔨᐤ ᐅᑯᐃᔅᑯᑖᑎᓰᐎᒡ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒥᔨᒥᐦᑦ ᒋᔖᒥᓂᑑ᙮ ᐋᒄ ᒫᒃ ᑳ ᐱᓱᐦᐋᐦᒡ ᐊᓂᔮᔨᐤ ᐊᓯᓃ ᑳ ᐱᒋᔅᑎᓂᒫᑭᓂᐎᔨᒡ ᒑ ᐱᓱᓯᒧᐙᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ᐋᐅᒄ ᐆ ᐃᔮᔨᒧᑖᒡ ᒋᐦᒋ ᐅᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᒡ, ᐄᑖᐱᒄ ᒫᐦ, ᓂᐱᒋᔅᑎᓈᐤ ᓵᐃᔨᓂᐦᒡ ᐊᓯᓃ ᒑ ᐱᓱᓯᒧᐙᑦ᙮ ᐆ ᐊᓯᓃ, ᑭᑎ ᐱᐦᒋᔑᓂᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᒑ ᐱᓱᔅᑳᑯᑦ᙮ ᐊᓐ ᒫᒃ ᐊᐙᓐ ᒑ ᑖᑆᔮᔨᒫᒀ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᒥᐦᒋᔨᐙᓯᐤ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","ᓃᒋᔖᓂᑎᒄ, ᒫᐅᒡ ᐋ ᐄᔑ ᐱᑯᓵᔨᒧᔮᓐ ᓂᑖᐦᐄᒡ ᑭᔮᐦ ᒫᐅᒡ ᐋ ᐄᔑ ᓂᑐᑎᒧᒃ ᒑᒀᔨᐤ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᒑ ᒌ ᐱᒫᒋᐦᐅᒡ ᓃᒋ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","ᐙᔥ ᑖᑆᐦ ᓂᑭ ᒌ ᐄᑖᒋᒫᐅᒡ ᑖᑆᐦ ᐋ ᐐᐦ ᓂᐦᐋᔨᐦᑎᒥᐦᐋᒡ ᒋᔖᒥᓂᑑ ᒥᒄ ᒫᒃ ᓂᒧᐃ ᓂᔅᑐᐦᑎᒧᒡ ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᓂᐦᐋᔨᐦᑎᒥᐦᐋᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","ᐋᐦᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᐦᑎᐦᒡ ᑖᓂᑖᐦ ᑯᐃᔅᑯᑖᑎᓰᐎᓂᐦᒡ ᐙᐦᒋ ᐄᔑ ᑭᓂᐙᐱᒥᑯᔨᒡ ᐊᐙᔨᐤᐦ ᒋᔖᒥᓂᑑ, ᐋᒄ ᐐᔨᐙᐤ ᑎᐹᓐ ᑳ ᑯᒋᐦᑖᒡ ᒑ ᒌ ᑯᐃᔅᑯᓈᑯᐦᐄᓱᒡ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᐱᒋᔥᑖᔨᒨᔅᑎᒧᒡ ᐊᓂᔮᔨᐤ ᑖᓐ ᑳ ᐄᔑ ᐱᒋᔅᑎᓂᒥᔨᒡ ᒋᔖᒥᓂᑑ, ᐊᐙᔨᐤᐦ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᒌ ᐄᔑ ᑭᓂᐙᐱᒫᑭᓂᐎᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","᙭ ᐅᐦᒋ ᐊᓐ ᐐᔓᐙᐎᓐ ᔖᔥ ᐳᓂᐲᔨᐤ, ᐋᒄ ᒫᒃ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᒑ ᑖᑆᔮᔨᒥᑰᒀ ᐋᔪᐎᒄ ᐋᓐ ᐊᓂᔮᔨᐤ ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᐄᔑ ᑭᓂᐙᐱᒥᑯᔨᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","ᒧᓱᔅ ᒌ ᐋᔨᒨᒫᐤ ᐊᓂᔮᔨᐤᐦ ᐊᐙᔨᐤᐦ ᐋ ᓂᓂᐦᐄᐦᑎᒥᔨᒡ ᒋᔖᒥᓂᑑ ᐅᐐᔓᐙᐎᓂᔨᐤ ᒑ ᒌ ᐅᐦᒋ ᑯᐃᔅᑯᑖᑎᓰᐦᐄᓱᔨᒡ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ᙮ ᒌᐦ ᐄᑖᐤ, “ᐊᓐ ᐊᐙᓐ ᒑ ᑎᐱᑑᑎᒧᒀ ᑖᓐ ᐋᑎᔓᐙᒥᑭᓃᔨᒡ ᐐᔓᐙᐎᓂᔨᐤ ᐋᔪᐎᒄ ᐊᓂᔮᔨᐤ ᒑ ᐄᔑ ᐱᒫᑎᓰᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","ᒫᐤ ᒫᒃ ᐋ ᐄᔑ ᐋᔨᒨᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᐦᒡ ᐋ ᐅᐦᒋ ᑯᐃᔅᑯᑖᑎᓰᐦᐋᑭᓅᑦ ᐊᐙᓐ, ᐊᑳᐐ ᑭᑎ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒻ ᐊᐙᓐ ᒋᐦᒋᒌᔑᑯᐦᒡ ᑭᑎ ᐄᑐᐦᑖᐤ ᐊᐙᓐ ᒑ ᒌ ᐹᒋ ᓃᐦᑎᐦᒋᐙᐦᑎᐦᐋᑦ ᙭ ᒑ ᒌ ᐋᔨᒨᑎᒫᑰᐎᐦᒄ ᐱᒫᒋᐦᐄᑯᓰᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","ᐊᑳᐐ ᑭᔮᐦ ᑭᑎ ᐅᐦᒋ ᐄᑖᔨᐦᑎᒻ ᐊᐙᓐ ᐄᑖᒥᐦᒡ ᐊᓂᑖᐦ ᐊᔅᒌᐦᒡ ᑖᓂᑖᐦ ᐋᐦ ᑖᒡ ᑳ ᐴᓂᐱᒫᑎᓰᔨᒡ ᑭᑎ ᐄᑐᐦᑖᐤ ᐊᐙᓐ ᐊᓂᑖᐦ ᒑ ᒌ ᐅᐦᑐᐦᑎᐦᐋᑦ ᙭ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","ᑖᓐ ᒫᒃ ᐋ ᐃᒋᔅᑖᔨᒡ ᐊᓂᑎᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ? ᐋᐅᒄ ᐆ ᐊᑎᔅᑖᒡ, “ᒋᔖᒥᓂᑑ ᐅᐱᒫᒋᐦᐄᐙᐤ ᒥᔻᒋᒧᐎᓐ ᒌ ᐹᔣᐱᒥᑯᐙᓐ᙮ ᒋᑭ ᒌ ᐃᔨᓐ ᐋ ᑖᑆᒥᑭᐦᒡ ᑭᔮᐦ ᒋᑭ ᒌ ᐅᑎᓈᓐ ᒋᑖᐦᐄᐦᒡ᙮” ᐋᐅᒄ ᒫᒃ ᐆ ᐋ ᐄᔑ ᐙᐐᐦᑎᒫᐦᒡ ᑖᑆᔮᔨᐦᑎᒧᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","ᐄᔨᓈ ᒌᓴᔅ ᐋᐅᒄ ᑎᐹᔨᐦᒋᒑᓯᐤ ᑭᔮᐦ ᒫᒃ ᒋᑖᐦᐄᐦᒡ ᑖᑆᐦᑎᒥᓈ ᑖᑆᐦ ᐋ ᒌ ᐎᓂᔥᑳᓂᑯᑦ ᒋᔖᒥᓂᑑ ᓂᐱᐎᓂᐦᒡ ᐅᐦᒋ, ᒋᑭ ᐱᒫᒋᐦᐅᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ᐙᔥ ᐅᑖᐦᐄᒡ ᑖᑆᐦᑎᒻ ᐊᐙᓐ ᐅᐦᒋ, ᐅᑯᐃᔅᑯᑖᑎᓰᐤ ᒑ ᐄᔑ ᑭᓂᐙᐱᒥᑯᑦ ᒋᔖᒥᓂᑑ᙮ ᒧᔖ ᐋ ᐐᐦᑎᐦᒃ ᐊᐙᓐ ᙭ ᐋ ᑎᐹᔨᐦᒋᒑᓯᐎᔨᒡ ᐋᑯᑖᐦ ᐙᐦᒋ ᐱᒫᒋᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, “ᐊᓐ ᐊᐙᓐ ᒑ ᑖᑆᔮᔨᒫᒀ ᓂᒧᐃ ᓂᐦᑖ ᑭᑎ ᐅᐦᒋ ᒥᐦᒋᔨᐙᓯᐤ ᐋ ᒌ ᑖᑆᔮᔨᒫᑦ᙮” ");
INSERT INTO crl_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ᒥᓯᐙ ᒫᒃ ᐊᐙᓐ ᐋᔨᒨᒫᑭᓂᐤ ᐅᑎᐦ ᐙᔥ ᐹᔨᑯᓂᐦᒡ ᐄᔑ ᑭᓂᐙᐱᒫᑭᓂᐎᒡ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᑭᔮᐦ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐋᐦ ᐄᑎᔅᑳᓈᓯᒡ᙮ ᐹᔨᑰ ᐊᓐ ᑎᐹᔨᐦᒋᒑᓯᐤ ᒥᓯᐙ ᐄᔨᔨᐤᐦ ᑎᐹᔨᒫᐤ᙮ ᒥᓯᐙ ᒫᒃ ᐊᓂᔮᔨᐤ ᑳ ᓂᑐᑎᒫᑯᑦ ᒑ ᒌ ᐐᒋᐦᐋᑦ ᒋᑭ ᐙᔪᒡ ᒋᔖᐙᑐᑎᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒥᓯᐙ ᐊᐙᓐ ᒑ ᑖᑆᑖᒀ ᑎᐹᔨᐦᒋᒑᓯᐤ ᐅᑎᔑᓂᐦᑳᓱᐎᓂᔨᐤ ᒑ ᒌ ᐐᒋᐦᐄᑯᑦ ᑭᑎ ᐱᒫᒋᐦᐋᑭᓂᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","ᑖᓂᑖᐦ ᒫᒃ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᑖᒡ ᒑ ᒌ ᐐᒋᐦᐄᑯᒡ, ᐋᑳ ᐙᐦᒋ ᑖᑆᔮᔨᒫᐙᒀ? ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᑖᑆᔮᔨᒫᒡ ᐋᐦᐋᑳ ᐅᐦᒋ ᐹᐦᑎᐦᒡ ᒑ ᒌ ᐋᔨᒨᒫᑭᓂᐎᒡ ᐊᓂᑖᐦ ᐋᐦ ᑖᒡ? ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᐹᐦᑎᐦᒡ, ᐋᐦᐋᑳ ᑖᔨᒡ ᐄᔨᔨᐤᐦ ᒑ ᒌ ᑭᒑᔅᒋᒥᑯᒡ ᐅᔮᔨᐤ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ᑖᓂᑖᐦ ᒑ ᒌ ᐅᐦᒋ ᑭᒑᔅᒀᒡ ᐄᔨᔨᐅᒡ ᐋᑳ ᒋᐦᒋᑎᔑᐦᐙᑭᓄᑣᐙ᙮ ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓄᐎᒡ ᒥᔻᔨᐦᑖᑯᓂᔨᐤ ᑖᑯᔑᐦᒀᐤ ᐅᒌ ᒥᔻᒋᒧᐎᓂᔨᐤ ᑳ ᐹᑖᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","ᐋᑦ ᒫᒃ ᐋ ᒌᐦ ᑖᔨᒡ ᐊᓂᔮᔨᐤ ᑳ ᐄᑎᔓᐦᐊᒧᐙᑭᓂᐎᒡ ᒑ ᒌ ᐙᐐᐦᑎᒫᑯᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᓂᒧᐃ ᒥᓯᐙ ᐅᐦᒋ ᑖᑆᐦᑎᒧᒡ᙮ ᐋᔪᐎᒄ ᒫᒃ ᐅᔮᔨᐤ ᐊᓂᔮ ᐅᒋᔅᒋᐙᐦᐄᒑᓯᐤ ᐋᐃᓵᔮ ᑳᐦ ᐋᔨᒨᑎᐦᒃ ᑳᐦ ᐃᔨᑦ, ᑎᐹᔨᐦᒋᒑᓯᐤ, ᐋᑎᐐ ᐋ ᐊᐙᓐ ᑖᑆᐦᑎᒻ ᑖᓐ ᐋ ᐄᔑ ᑭᒑᔅᒀᔮᐦᒡ? ");
INSERT INTO crl_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","ᐋ ᐹᐦᑎᐦᒡ ᐄᔨᔨᐅᒡ ᐋᑯᑖᐦ ᐙᐦᒋ ᑖᑆᐦᑎᐦᒡ ᑭᔮᐦ ᐋ ᐹᐦᑎᐦᒡ ᙭ ᐆ ᒥᔻᔨᒋᒧᐎᓂᔨᐤ ᐋ ᑭᒑᔅᒀᓄᐐᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ᒥᒄ ᒫᒃ ᓂᐐ ᑯᒀᒋᐦᒑᒧᓐ, ᓂᒧᐃ ᐋ ᒫᒃ ᙭ ᐅᐦᒋ ᐋᔨᒨᑎᒧᐙᑭᓂᐎᒡ ᒎᐤ ᐄᔨᔨᐅᒡ? ᐋᐦᐋ, ᑭᔨᑆ ᑳᐦ ᐋᔨᒨᑎᒧᐙᑭᓂᐎᒡ᙮ ᐙᔥ ᐊᒀᒋᔥᑖᒡ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒥᓯᐙ ᐋᔅᐱᑎᔅᑭᒥᑳᔨᒡ ᐊᔅᒌᐦᒡ ᒌ ᐙᐐᐦᑎᒧᒡ ᐊᓂᔮᔨᐤ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᒥᑐᓐ ᓈᑖᐦ ᐋᐦ ᐄᔥᒀᔮᔨᒡ ᐅᔮᔨᐤ ᐊᔅᒌᔨᐤ ᒌ ᐹᐦᑖᑯᓂᔨᐤ ᐅᑎᔨᒧᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","ᒦᓐ ᑯᑎᒡ ᒑᒀᓐ ᓂᐐ ᑯᒀᒋᐦᒑᒧᓐ, ᓂᒧᐃ ᐋ ᒫᒃ ᐅᐦᒋ ᓂᔅᑐᐦᑎᒧᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ? ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒧᓱᔅ ᑳ ᓃᑳᓐ ᐋᔨᒨᑎᐦᒃ ᐊᓂᑎᐦ ᑳᐦ ᐄᑎᔥᑖᔨᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐄᔨᐦᒡ, ᒋᑭ ᑐᑖᑎᓈᐙᐤ ᒑ ᒌ ᐅᐎᐦᑖᔨᒫᑯᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᐅᑏᔨᔨᒥᑎᐙᑭᓂᐎᒡ, ᑭᔮᐦ ᒋᑭ ᒋᔑᐙᐦᐄᑎᓈᐙᐤ ᐋᐦᐋᐱᒋᐦᐄᒀᐤ ᐋ ᐹᔨᑯᔥᑳᓈᓯᒡ ᐄᔨᔨᐅᒡ ᐋᑳ ᑳ ᓂᔅᑑᐦᑎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","ᐊᓂᔮ ᐋᐃᓵᔮ ᑯᐃᔅᒄ ᒌ ᐐᐦᑎᒻ ᐅᔮᔨᐤ ᐋ ᒌ ᐃᔨᑯᐱᓈᓂᐦᐄ ᒋᔖᒥᓂᑑ, ᓂᒌ ᒥᔅᑳᑯᒡ ᐊᓂᒌ ᐋᑳ ᐙᐙᒡ ᐙᐦᒋ ᓈᓂᑎᐙᔨᒥᒡ᙮ ᓂᒌ ᓅᑯᓰᔥᑎᐙᐅᒡ ᐊᓂᒌ ᐋᑳ ᐅᐦᒋ ᒋᔅᒑᔨᒥᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ᒫᐅᔮᔨᐤ ᒫᒃ ᐋ ᐄᔑ ᐋᔨᒨᒫᑦ ᒋᔖᒥᓂᑑ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ, ᐃᔅᑭᓐ ᒌᔑᑳᐤᐦ ᓂᒌ ᔑᐎᓂᔅᒑᔨᔥᑐᐙᐅᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᓂᓂᐦᐄᐦᑑᐎᒡ ᑭᔮᐦ ᑳᐦ ᐋᓍᐦᑎᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","ᒦᓐ ᑯᑎᒡ ᒑᒀᓐ ᓂᐐ ᑯᒀᒋᐦᒑᔨᒧᓐ᙮ ᒌ ᐙᐱᓈᐤ ᐋ ᒋᔖᒥᓂᑑ ᐅᑎᔨᔨᒻᐦ? ᓂᒧᐃ ᑭᔨᑆ ᐅᐦᒋ ᐙᐱᓈᐤ᙮ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᑭᔮᐦ ᓃᔨ᙮ ᐊᓂᔮ ᐋᑉᕋᐦᐋᒻ ᐋᐦ ᑖᑦ ᓂᒌ ᐅᐦᒋ ᐋᓂᔅᒑ ᐱᒫᑎᓰᓐ᙮ ᐱᓐᒋᒥᓐ ᑳ ᐃᔑᓂᐦᑳᓱᒡ ᐅᐹᔨᑯᑖᐅᓯᐎᒡ ᐋᑯᑖᐦ ᐙᐦᒋᔮᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","ᓂᒧᐃ ᐅᐦᒋ ᐙᐱᓈᐤ ᒋᔖᒥᓂᑑ ᐅᑎᔨᔨᒻᐦ, ᐊᓂᔮᔨᐤ ᔖᔥ ᐊᓂᑖᐦ ᐙᔥᑭᒡ ᑳ ᐅᐙᔮᐱᒫᑦ ᐐᔨ ᒑ ᒌ ᑎᐱᔨᐙᐎᓰᑦ᙮ ᒋᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᑖᓐ ᐋ ᐄᔑ ᐋᔨᒨᒫᑭᓅᑦ ᐄᓛᐃᒑ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ᙮ ᒌ ᐋᔨᒨᑎᒧᐙᐤ ᒋᔖᒥᓂᑑ ᑖᓐ ᑳ ᐄᔑ ᐋᑳ ᒫᒨᔮᒻ ᐅᐦᒋ ᐋᐦ ᑎᔨᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ, ᒌ ᐃᔨᐤ, ");
INSERT INTO crl_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“ᑎᐹᔨᐦᒋᒑᔨᓐ, ᒌ ᓂᐱᐦᐋᐅᒡ ᒋᒋᔅᒋᐙᐦᐄᒑᓰᒻ ᐅᒌ ᐄᔨᔨᐅᒡ᙮ ᒌ ᓂᔑᐎᓈᒋᐦᑖᐅᒡ ᒌ ᐱᒋᔅᑎᓂᒑᐤ ᒦᒋᓲᓈᐦᑎᒄ᙮ ᓃᔨ ᒫᐦᒑᔨ ᓂᐹᔨᑯᔑᓐ ᐋ ᓅᔔᔥᑳᑖᓐ᙮ ᓂᐐ ᓂᐱᐦᐄᑯᒡ ᒫᒃ ᑭᔮᐦ ᓃᔨ᙮” ");
INSERT INTO crl_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","ᐋᒄ ᒫᒃ ᑳᐦ ᐄᑎᑯᑦ ᑎᐹᔨᐦᒋᒑᓯᐤ, “ᓃᔣᔥᒡ ᑎᐦᑐ ᒋᔖᒥᑖᐦᑐᒥᑎᓂᐤ ᓂᒌ ᐱᐦᑳᓂᐦᐋᐅᒡ ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᐋᑳ ᓂᐦᑖ ᐙᐦᒋ ᓃᐱᔅᑰᐱᔅᑎᐎᒡ ᐊᓂᔮᔨᐤ ᒥᓂᑑᐦᑳᓐ ᐯᐊᓪ ᑳ ᐃᔑᓂᐦᑳᓱᔨᒡ᙮” ");
INSERT INTO crl_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᐋᔅᐱᔨᔨᒡ ᐊᓅᐦᒡ᙮ ᑖᐅᒡ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐋᐦᐋᑳ ᒥᐦᒑᑎᒡ ᒋᔖᒥᓂᑑ ᐋ ᒌ ᐅᐙᔮᐱᒥᑯᒡ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒋᔖᐙᑎᓰᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","ᐋ ᒋᔖᐙᑎᓰᑦ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᐙᐦᒋ ᐎᔮᔨᒥᑯᒡ᙮ ᓂᒧᐃ ᐐᔨ ᐊᓂᔮᔨᐤ ᐋ ᒥᔪᐃᐦᑐᑎᐦᒡ᙮ ᐙᔥ ᐎᔮᔨᒫᑦ ᐊᐙᔨᐤᐦ ᐊᓂᔮᔨᐤ ᐅᐦᒋ ᐋ ᒥᔪᑐᑎᒥᔨᒡ, ᓂᒥᔮᔨᐤ ᐊᓂᔮᔨᐤ ᐐᔨ ᒥᒄ ᐅᒋᔖᐙᑎᓰᐎᓐ ᐅᐦᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","ᒑᒀᓐ ᒫᒃ ᒑ ᒌ ᐄᓈᓅᒡ ᔖᔥ? ᓂᒧᐃ ᒫᒃ ᐅᐦᒋ ᒥᔅᑭᒧᒡ ᐊᓂᒌ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐅᒡ ᐊᓂᔮᔨᐤ ᓈᔥᒡ ᑳ ᓈᓂᑎᐙᔨᐦᑎᐦᒡ᙮ ᒥᒄ ᐊᓂᒌ ᒋᔖᒥᓂᑑ ᑳ ᐅᐙᔮᐱᒥᑯᒡ ᐋᐅᑯᓂᒡ ᐊᓂᒌ ᑳ ᒥᔅᑭᐦᒡ᙮ ᐋᒄ ᐊᓂᒌ ᑯᑎᑭᒡ ᓈᓈᓂᒌᒻ ᓂᒧᐃ ᐅᐦᒌ ᐹᐦᑎᐙᐅᒡ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᓂᒧᐃ ᐅᐦᒌ ᓂᔅᑐᐦᑎᒧᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ᐋᐅᒄ ᐙᔥ ᑖᑆᐦ ᑳᐦ ᐄᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᒌ ᑐᑖᑰᐎᒡ ᒋᔖᒥᓂᑑ ᒥᑐᓐ ᐋᑳ ᒑᒀᔨᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᐦᒡ ᐊᐦᒑᐦᑯᐎᓂᐦᒡ ᐄᔑ᙮ ᒌ ᑐᑖᑰᐎᒡ ᐋᑳ ᒑ ᒌ ᐙᐱᐦᑎᒸᒡ ᑖᓐ ᐋ ᐄᔨᐦᑎᔨᒡ ᑭᔮᐦ ᐋᑳ ᒑ ᒌ ᐹᐦᑎᐦᐙᒡ ᑖᓐ ᐋᐦ ᐄᔨᒡ᙮ ᐋᔥᒄ ᐊᓅᐦᒡ ᑳ ᒌᔑᑳᔨᒡ ᐋᔪᐎᒄ ᐋ ᐃᓯᓈᑯᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ᐊᓂᔮ ᒋᐦᒋᐅᒋᒫᐤ ᑌᕕᑦ ᑭᔮᐦ ᐐᔨ ᒌ ᐄᑎᓯᓂᐦᐄᒑᐤ, ᐋᑯᔥ ᐋ ᑎᔓᔨᑯᒡ ᑭᔮᐦ ᒫᒃ ᐋ ᓂᒀᑎᑯᒡ ᒋᑭ ᐃᓯᓈᑯᓂᔨᐤ ᐅᒥᑯᔖᐎᓂᐙᐤ᙮ ᐋᑯᔥ ᒋᑭ ᐱᐦᒋᔑᒥᑰᐎᒡ ᐊᓂᔮᔨᐤ ᐅᒥᑯᔖᐎᓂᐙᐤ᙮ ᐋᑯᔥ ᑭᑎ ᒫᑯᐦᐋᑭᓂᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ᐋᑯᔥ ᒑ ᒌ ᐋᑭᐙᐱᓈᑭᓂᐎᒡ ᒑᐦ ᐋᑳ ᐙᐱᐦᑎᐦᒡ ᑭᔮᐦ ᑳᒋᒡ ᒑ ᒌ ᐙᒋᓯᒡ ᐋ ᐃᔥᐱᔥ ᑯᔑᑯᔥᑳᑯᒡ ᐅᑖᔨᒫᔨᐦᑎᒧᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","ᒦᓐ ᑯᑎᒡ ᒑᒀᓐ ᓂᐐ ᑯᒀᒋᐦᒑᒧᓐ᙮ ᐄᔥᐱᐦ ᑳᐦ ᐋᑎᐙᔨᒫᒡ ᒋᔖᒥᓂᑑ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ, ᒌ ᓈᔅᐱᒡ ᐱᐦᒋᔑᓂᒡ ᐋ ᐊᓂᔮᔨᐤ ᑳ ᐱᐦᒋᔑᐦᒡ? ᓂᒧᐃ ᐅᐦᒋ ᓈᔅᐱᒡ ᐱᐦᒋᔑᓂᒡ᙮ ᐊᓂᔮᔨᐤ ᐋᐦ ᐋᑎᐙᔨᒫᒡ ᒋᔖᒥᓂᑑ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋ ᓂᐦᐄᐱᔨᐦᑖᔨᒡ ᒑ ᒌ ᐱᒫᒋᐦᐋᔨᒡ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᒌ ᐱᒫᒋᐦᐋᔨᐤ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ ᒑ ᒌ ᐅᐦᑖᔨᐦᑎᐦᒡ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","ᐊᓂᑎᐦ ᑳ ᒥᒋᐦᑑᑎᐦᒡ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐋᑯᑖᐦ ᓈᔥᒡ ᑳ ᒋᔖᐙᑐᑎᐙᑦ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᐊᓂᔮᔨᐤ ᑯᑎᒃ ᐊᐙᔨᐤᐦ ᐃᔨᐦᒡ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᑭᔮᐦ ᒫᒃ ᐊᓂᔮᔨᐤ ᐋ ᒌ ᐱᐦᒋᔑᐦᒡ ᐋᑯᑖᐦ ᑭᔮᐦ ᒋᔖᒥᓂᑑ ᑳ ᐅᐦᒋ ᒥᔥᑎᐦ ᒥᔪᑐᑎᐙᑦ ᐊᓂᔮᔨᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔨᒡ᙮ ᒑᔥᑎᓈᑖᔨᐦᑖᑯᓐ ᒫᒃ ᐊᑎᑎᐤ ᒑ ᒥᔖᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒥᔪᐦᑳᒑᐎᓐ ᑳᐤ ᓂᑎᐙᐱᒥᑯᒑ ᒥᓯᐙ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","ᐋᒄ ᒫᒃ ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᒑ ᐊᔨᒥᐦᐄᑎᑯᒡ᙮ ᐋᐅᒄ ᓃᔨ ᒋᑎᐹᔅᑎᓕᒧᐙᐤ᙮ ᒨᔥ ᒫᒃ ᓂᑭ ᒋᔅᑖᔨᐦᑎᒥᐦᐄᑯᓐ ᐆ ᐋᐱᑎᓰᐎᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ᐙᐱᒥᑣᐙ ᓃᒋ ᒎᐤ ᐄᔨᔨᐅᒡ ᐋ ᐙᐐᐦᑎᒫᑎᑯᒡ ᒥᔻᒋᒧᐎᓐ ᒋᑭ ᒌ ᐃᓯᓈᑯᓂᔨᐤ ᒑ ᒌ ᑐᑖᑯᒡ ᐱᔅᒡ ᑳᐤ ᒑ ᒌ ᓂᑎᐙᐱᒫᒡ ᒋᔖᒥᓂᑑ ᐋᒄ ᒫᒃ ᒑ ᐱᒫᒋᐦᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ᒫᒀᒡ ᑳᐦ ᐋᑑᐙᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐋᑯᑖᐦ ᑳ ᐅᐦᒋᐱᔨᔨᒡ ᒥᓯᐙ ᐊᓂᒌ ᑯᑎᑭᒡ ᐃᔨᐦᒡ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᒑ ᒌ ᐅᐐᒑᐙᑭᓂᐦᑭᐙᑭᓂᐎᒡ ᒋᔖᒥᓂᑑ᙮ ᐄᔥᐱᐦ ᒫᒃ ᑳᐤ ᒦᓐ ᒌᐙ ᐅᑎᓂᑯᑣᐙ ᒋᔖᒥᓂᑑ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᒧᔮᒻ ᐄᔨᔨᐅᒡ ᐋ ᒌ ᐴᓂᐱᒫᑎᓰᔨᒡ ᒦᓐ ᒫᒃ ᑳᐤ ᐋ ᐱᒫᑎᓰᔨᒡ ᒋᑭ ᐃᓯᓈᑯᓯᐎᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","ᐋ ᐱᐦᒀᓈᑦ ᐊᐙᓐ ᐋ ᐅᔅᒋᓰᔨᒡ ᐋᐃᐦᑯᓈᐤ ᐋ ᒥᒋᔥᑎᐦᐋᒫᑦ ᒋᔖᒥᓂᑑ ᐄᔑ ᐋᐦ ᑖᔨᒡ ᒥᓯᐙ ᐋᔅᑎᑎᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐃᐦᑯᓈᐤ ᐐᔨ ᒋᔖᒥᓂᑑ ᐋ ᐃᔮᐙᑦ ᒥᓯᐙ ᐱᔮᐦᒋᓯᔨᐤ ᐃᓯᓈᑯᓂᔨᐤ᙮ ᑭᔮᐦ ᒫᒃ ᐐᔨ ᒋᔖᒥᓂᑑ ᑳ ᐱᒋᔅᑎᓂᒧᐙᑭᓅᒀ ᐊᓂᔮᔨᐤ ᐅᑎᐱᔨᐤ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᐅᑎᐦᑯᓐ ᐱᔮᐦᑭᓐ ᐃᓯᓈᑯᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","ᐊᓂᒌ ᐄᔨᔨᐅᒡ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐋᐅᑯᓂᒡ ᐅᒌ ᐊᓕᕝ ᒥᔥᑎᒄ ᐊᓂᑖᐦ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳ ᓂᐦᑖᐅᒋᐦᐋᑭᓅᑦ᙮ ᒌ ᑎᑯᓐ ᐅᑎᐦᑯᓐ ᐋ ᒌ ᓈᑣᑭᐦᐄᑭᓂᐎᒡ ᐊᓂᑎᐦ ᐅᐦᒋ ᐊᓕᕝ ᒥᔅᑎᑯᐦᒡ᙮ ᑭᔮᐦ ᒌᐦ ᑖᐅᒡ ᐊᓂᑎᐦ ᐎᔨᐐᑎᒫ ᑯᑎᒃ ᐊᓕᕝ ᒥᔅᑎᑯᒡ ᓂᑎᐐ ᒥᒄ ᐋ ᒌ ᓂᐦᑖᐅᒋᐦᒡ, ᐋᔪᐎᒄ ᒫᒃ ᐅᐎᑎᐦᑯᓐ ᒌ ᒋᑭᒧᐦᑖᑭᓂᐎᔨᐤ ᐄᔑ ᐊᓂᑎᐦ ᐊᓕᕝ ᒥᔥᑎᒄ ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳᓂᐦᑖᐅᒋᒡ᙮ ᒌᔨᐙᐤ ᒫᒃ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᒋᐐᒋᐦᐄᑯᓈᐙᐤ ᑭᔮᐦ ᒌᔨᐙᐤ ᐅᐦᒋ ᐊᓂᔮᔨᐤ ᑳᐦ ᑐᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᒎᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","ᐊᑳᐐ ᒫᒃ ᒋᑭ ᐅᐦᒋ ᒫᔮᔨᒫᐙᐅᒡ ᐊᓂᒌ ᒧᔮᒻ ᐙᐦᑎᐦᑯᓐ ᐋ ᒌ ᓈᑣᑭᐦᐄᑭᓂᐎᒡ ᑳ ᐃᓯᓈᑯᓯᒡ᙮ ᒑᒀᓐ ᒑ ᐅᐦᒋ ᐐᐦ ᓂᓈᐹᐅᒧᔮᒄ? ᒧᔮᒻ ᑖᑆᐦ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ ᐋ ᐅᐦᒋᔮᒄ ᒋᑎᓯᓈᑯᓯᓈᐙᐤ᙮ ᐋᑯᑖᐦ ᐙᐦᒋ ᒥᔪ ᓂᐦᑖᐅᒋᔮᒄ᙮ ᓂᒥᔮᐤ ᒌᔨᐙᐤ ᓈᐦᑖᐅᒋᐦᐋᒄ ᐆ ᒥᔥᑎᒄ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","ᒀᔣᓐ ᐱᔅᒡ ᐊᓂᑎᐦ ᐋ ᑎᔑᔮᒄ ᒋᑭ ᒌ ᐄᓈᐙᐤ, “ᐱᔅᒡ ᐅᑎᐦᑯᓐ ᒌ ᓈᑣᓂᒻ ᒋᔖᒥᓂᑑ ᓃᔨ ᒦᔥᑯᒡ ᒑ ᒌ ᓂᐦᑖᐅᒋᔮᓐ ᑖᓂᑖᐦ ᑳ ᓂᐦᑖᐅᒋᓃᔨᒡ ᐊᓂᔮᔨᐤ ᐅᑎᐦᑯᓐ᙮” ");
INSERT INTO crl_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","ᑖᑆᐦ ᑭᔨᑆ᙮ ᒥᒄ ᒫᒃ, ᒋᔖᒥᓂᑑ ᒌ ᐄᒑᓈᐤ ᐊᓂᔮᔨᐤ ᒎᐄᔨᔨᐤ ᐙᔥ ᐋ ᒌ ᐋᓍᐦᑖᑯᑦ᙮ ᒌᔨ ᒫᒃ ᐐ, ᒌ ᒥᔪᓂᐦᑖᐅᒋᓐ ᐊᓂᑎᐦ ᐊᓐ ᒥᔥᑎᒄ ᐙᔥ ᒋᒌ ᑖᑆᔮᔨᒫᐤ ᒋᔖᒥᓂᑑ᙮ ᐊᑳᐐ ᒋᑭ ᐅᐦᒋ ᓂᓈᐹᐅᒧᓐ᙮ ᑎᑯᓐ ᐊᐅᔅᑖ ᒑ ᒌ ᐄᔑ ᐃᔮᒀᒥᔨᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","ᓂᒧᐃ ᐅᐦᒋ ᒥᓈᒋᐦᐋᐤ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ, ᐊᓂᔮᔨᐤ ᒋᐦᒋᐙ ᐅᑎᐦᑯᓐ ᐊᓂᑎᐦ ᒥᔅᑎᑯᐦᒡ ᑳ ᐄᔑ ᑭᓂᐙᐱᒫᑭᓂᐎᔨᒡ᙮ ᒋᑎᐄᑖᔨᐦᑖᓐ ᐋ ᒫᒃ ᒑ ᒥᓈᒋᐦᐄᔅᒃ ᒌᔨ? ");
INSERT INTO crl_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","ᒋᐙᐱᐦᑎᒸᓈᓂᐤ ᒫᒃ ᑖᓐ ᐋ ᐃᔥᐱᔥ ᒥᔻᔨᐦᑖᑯᓯᑦ ᒋᔖᒥᓂᑑ ᑭᔮᐦ ᒋᐙᐱᐦᑎᒸᓈᓂᐤ ᑖᓐ ᒑ ᒌ ᐃᔥᐱᔥ ᐋᑳ ᒥᓈᑎᓰᑦ᙮ ᓂᒧᐃ ᒥᓈᒋᐦᐋᐤ ᐊᓂᔮᔨᐤ ᑳ ᐱᐦᒋᔑᓃᔨᒡ ᒥᒄ ᒫᒃ ᒑ ᒥᔪᑐᑎᒫᑯᐙᐤ ᑖᑆᐅᒑᔨᒫᒀ ᒨᔥ ᒑ ᒌ ᒥᔪᑐᑎᒫᑖᒄ᙮ ᐋᑳ ᒫᒃ ᐆ ᑎᔨᓈ ᑭᔮᐦ ᒌᔨ ᒋᑭ ᒥᓂᔔᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","ᒥᔔ ᒫᒃ ᒥᐦᒋᔨᐙᔮᔨᐦᑎᐦᒀᐙ ᐋ ᒌ ᐋᓍᐦᑎᐦᒡ ᐊᓂᒌ ᒎᐤ ᐄᔨᔨᐅᒡ ᒦᓐ ᑳᐤ ᒋᑭ ᒋᑭᒧᐦᐋᑭᓂᐎᒡ ᑖᓂᑖᐦ ᑳ ᐅᐦᒋ ᓂᐦᑖᐅᒋᒡ᙮ ᐋᔪᐎᒄ ᑖᑆᐦ ᒑ ᒌ ᑐᑖᑯᒡ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᐋᐅᒄ ᒌᔨᐙᐤ ᐅᐎᑎᐦᑯᓐ ᓂᑎᐐ ᒥᒄ ᑳ ᓂᐦᑖᐅᒋᒡ ᐊᓕᕝ ᒥᔅᑎᑯᒡ ᒋᑎᓯᓈᑯᓯᓈᐙᐤ᙮ ᐆ ᒫᒃ ᐅᑎᐦᑯᓐ, ᓂᐦᑖᐅᒋᐦᒋᑭᓐ ᐊᔅᒌᐦᒡ ᑳ ᓂᐦᑖᐅᒋᑦ ᐊᓕᕝ ᒥᔥᑎᒄ ᐋᑯᑖᐦ ᑳ ᒋᑭᒧᐦᑖᑭᓂᐎᒡ ᐋᐦ ᐋᑦ ᐋᑳ ᐊᓂᑎᐦ ᐅᐦᒋ ᓂᐦᑖᐅᒋᐦᒡ᙮ ᐆ ᒫᒃ ᐊᓕᕝ ᒥᔥᑎᒄ ᑳ ᓂᐦᑖᐅᒋᐦᐋᑭᓅᑦ ᐋᐅᑯᓂᒡ ᐅᒌ ᒎᐤ ᐄᔨᔨᐅᒡ᙮ ᒑᔥᑎᓈᔥ ᒫᒃ ᒋᑭ ᒌᐦ ᑐᑎᐙᐤ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᒎᐤ ᑳᐦ ᐄᑎᔅᑳᓈᓰᔨᒡ ᑳᐤ ᒑ ᒌ ᒋᐦᒋ ᓂᐦᑖᐅᒋᔨᒡ ᑖᓂᑖᐦ ᔖᔥ ᑳ ᓂᐦᑖᐅᒋᔨᒡ ᐊᓂᑖᐦ ᐹᒋ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","ᓃᒋᔖᓂᑎᒄ, ᒋᓂᑎᐙᔨᒥᑎᓈᐙᐤ ᒑ ᒌ ᓂᔅᑐᐦᑎᒸᒄ ᐅᔮᔨᐤ ᑳ ᐄᔑ ᒋᔅᒑᔨᐦᑖᑯᐦᑖᑦ ᒋᔖᒥᓂᑑ ᐋᒄ ᒫᒃ ᓂᒧᐃ ᒋᑭ ᐅᐦᒋ ᐄᑖᔨᐦᑎᓈᐙᐤ ᓈᔥᒡ ᐋ ᔨᑆᐦᑳᔮᒄ᙮ ᐊᓅᐦᒡ ᒫᒀᒡ ᒥᐦᒑᑐ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐐᐦ ᓰᐱᑎᒧᒡ᙮ ᒥᒄ ᒫᒃ ᒋᑭ ᐅᑎᐦᒋᐱᔨᔨᐤ ᑖᓂᑖᐦ ᒑ ᑖᑆᐦᑎᐦᒡ᙮ ᐋᔥᒄ ᒫᒃ ᐋᒸᔮ ᐅᑎᐦᒋᐱᔨᒡ ᐆ ᒥᓯᐙ ᐊᓂᒌ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓯᒡ ᑎᐦᑐ ᒥᒄ ᒑ ᐅᐙᔮᐱᒥᑯᐙᒀ ᒋᔖᒥᓂᑑ ᒑ ᒌ ᐱᒫᒋᐦᐅᒡ, ᒋᑭ ᐱᒫᒋᐦᐅᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ᐋᑯᑖᐦ ᒫᒃ ᒥᓯᐙ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᒑ ᐱᒫᒋᐦᐋᑦ ᒋᔖᒥᓂᑑ᙮ ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᐊᓐ ᒑ ᐱᒫᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ, ᓵᐃᔨᓂᐦᒡ ᒋᑭ ᐅᐦᑐᐦᑖᐤ᙮ ᒋᑭᑐᑎᐙᐤ ᐊᓂᔮᔨᐤ ᒉᑭᑉ ᐅᑖᓂᔥᑰᔒᒻ ᒑ ᒌ ᐴᓃᔨᒡ ᐋ ᒥᒋᐦᑑᑎᒥᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","ᐋᔪᐎᒄ ᐅᔮᔨᐤ ᒑ ᐄᔑ ᓂᔅᑯᒨᒀᐤ ᒑ ᒌᐦ ᑐᑎᒧᒀ ᐙᐹᔨᐦᑎᒨᒀᐙ ᐅᒥᒋᐦᑣᐎᓂᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","ᐊᓂᒌ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᒌ ᐋᑎᐙᔨᐦᑎᒧᒡ ᒥᔻᒋᒧᐎᓂᔨᐤ᙮ ᐋᑯᑖᐦ ᐙᐦᒋ ᓅᑯᓃᔨᒡ ᐋ ᐅᐦᑳᑖᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ, ᒑ ᒌ ᐱᒫᒋᐦᐅᔮᒄ ᒫᒃ ᒌᔨᐙᐤ ᐋᑳ ᐃᔅᕋᐄᓪ ᐄᔨᔨᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ ᐋᔪᐎᒄ ᐙᐦᒋ ᐄᔅᐱᔨᔨᒡ ᐆ᙮ ᐊᔮᐱᒡ ᒫᒃ ᒋᔖᒥᓂᑑ ᒌ ᐙᔮᐱᒫᐤ ᐃᔅᕋᐄᓪ ᒑ ᐅᑏᔨᔨᒥᑦ ᐋ ᓵᒋᐦᐋᑦ ᐙᔥ ᒌ ᓵᐦᒋᐦᐋᐤ ᐅᑖᓂᔥᒑ ᐅᐙᐦᑯᒫᑭᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","ᑖᐹ ᓂᐦᑖ ᐄᒑᓈᐤ ᒋᔖᒥᓂᑑ ᐊᓂᔮᔨᐤ ᑳ ᐅᐙᔮᐱᒫᑦ᙮ ᑭᔮᐦ ᓂᒧᐃ ᓂᐦᑖ ᒦᓐ ᑳᐤ ᒌᐙ ᐅᑎᓂᒸᐤ ᑖᓂᔮᔨᐤ ᔖᔥ ᑳ ᐄᔑ ᒥᔮᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","ᓂᒧᐃ ᑰᐦᒋ ᓂᓂᐦᐄᐦᑎᐙᐙᐤ ᒋᔖᒥᓂᑑ ᐊᓂᑖᐦ ᐅᑖᐦᒡ ᒌᔨᐙᐤ ᐋᑳ ᑳ ᒎᐤ ᐄᑎᔅᑳᓈᓰᔮᒄ᙮ ᐊᓂᔮᔨᐤ ᒫᒃ ᐊᓅᐦᒡ ᐋᐦᐋᑳ ᓂᓂᐦᐄᐦᑐᐙᒡ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᐋᔪᐎᒄ ᐙᐦᒋ ᒋᔅᑎᒫᒑᔨᒥᑖᒄ ᒌᔨᐙᐤ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","ᐋᔪᐎᒄ ᒫᒃ ᒧᔮᒻ ᒑ ᑐᑎᒧᐙᑭᓂᐎᒡ ᐊᓂᒌ ᒎᐤ ᑳ ᐄᑎᔅᑳᓈᓯᒡ ᑖᓐ ᑳᐦ ᑐᑎᒫᑯᐎᔮᒄ᙮ ᐊᓅᐦᒡ ᓂᒧᐃ ᓂᓃᐦᑐᐙᐅᒡ ᒋᔖᒥᓂᑑ᙮ ᒥᒄ ᐋᔥᒄ ᒋᑭ ᐅᑎᐦᒋᐱᔨᐤ ᐋ ᒋᔅᑎᒫᒑᔨᒥᑯᒡ ᒋᔖᒥᓂᑑ ᒧᔮᒻ ᑳ ᐄᔑ ᒋᔅᑎᒫᒑᔨᒥᑖᒄ ᑭᔮᐦ ᒌᔨᐙᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","ᐙᔥ ᒋᔖᒥᓂᑑ ᑳ ᐱᒋᔅᑎᓈᑦ ᒥᓯᐙ ᐊᐙᔨᐤᐦ ᒧᔮᒻ ᐋ ᒥᒫᐦᒋᒀᐱᐦᑳᑎᑯᔨᒡ ᐊᓂᔮᔨᐤ ᐋᐦᐋᑳ ᓂᓃᐦᑎᒥᔨᒡ ᐋᑦ ᒑ ᒌ ᐅᐦᒋ ᐙᐱᐦᑏᔮᑦ ᐋ ᒋᔅᑎᒫᒑᔨᒫᑦ ᒥᓯᐙ ᐄᔨᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","ᓈᔥᑖᑆᐦ ᐙᔪᒡ ᐃᔮᐤ ᑭᒑᐦᑎᐙᔨᐦᑎᒧᐎᓂᔨᐤ ᑭᔮᐦ ᒋᔅᒑᔨᐦᑎᒧᐎᓂᔨᐤ ᒋᔖᒥᓂᑑ᙮ ᓂᒧᐃ ᑎᑯᓂᔨᐤ ᒑᒀᔨᐤ ᐋᐦᐋᑳ ᒋᔅᒑᔨᐦᑎᐦᒃ᙮ ᐄᔥᐱᐦ ᐙᔮᔨᐦᑎᐦᒃ ᒑᒀᔨᐤ ᓂᒧᐃ ᐊᐙᔨᐤᐦ ᒌ ᐐᐦᑎᒥᔨᐤ ᒑᒀᔨᐤ ᐊᓂᑖᐦ ᐙᐦᒋ ᐄᔑ ᐎᔮᔨᐦᑎᐦᒃ᙮ ᓂᒧᐃ ᐊᐙᔨᐤᐦ ᒌ ᒥᔪ ᒋᔅᒑᔨᐦᑎᒥᔨᐤ ᑖᓐ ᐋᐦᑎᒃ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","ᒧᔮᒻ ᐋᑎᔥᑖᒡ ᐊᓂᑖᐦ ᒋᐦᒋᒥᓯᓂᐦᐄᑭᓂᐦᒡ, ᓂᒧᐃ ᒥᑐᓐ ᐊᐙᓐ ᒋᔅᒑᔨᐦᑎᒻ ᑖᓐ ᐋᔨᑖᔨᐦᑎᒥᔨᒡ ᑎᐹᔨᐦᒋᒑᓯᐤ᙮ ᓂᒧᐃ ᒥᑐᓐ ᐊᐙᓐ ᒋᑭ ᒌ ᐐᐦᑎᒧᐙᐤ ᑖᓐ ᒋᐱᐦ ᑎᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","ᑖᐤ ᐋ ᐊᐙᓐ ᐋ ᒌ ᐊᐅᐦᐋᑦ ᒋᔖᒥᓂᑑ ᒑᒀᔨᐤ ᐋᒄ ᒫᒃ ᒑ ᒌ ᐃᓯᓈᑯᓃᔨᒡ ᐋ ᐊᐅᐦᐋᓱᒥᑯᑦ? ");
INSERT INTO crl_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","ᐐᔨ ᒋᔖᒥᓂᑑ ᒥᓯᐙ ᒑᒀᔨᐤ ᒌ ᐅᔑᐦᑖᐤ᙮ ᐐᔨ ᒥᓯᐙ ᒑᒀᔨᐤ ᓈᓈᑭᒋᐦᑖᐤ᙮ ᐐᔨ ᒥᓯᐙ ᒑᒀᔨᐤ ᑎᐱᔨᐙᐅᓯᐤ᙮ ᐐᔨ ᒫᒃ ᑳᒋᒡ ᑭᑎ ᐐᐦ ᒋᔅᑖᔨᒫᑭᓂᐤ᙮ ᐋᒥᓐ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","ᐊᓂᔮᔨᐤ ᐋ ᐃᔥᐱᔥ ᒥᔖᔨᒡ ᒋᔖᒥᓂᑑ ᐅᒋᔅᑎᒫᒑᔨᐦᒌᒑᐎᓐ, ᐋᐅᒄ ᐙᐦ ᒌ ᓂᑎᐙᔨᒥᑎᑯᐦᒡ, ᓃᒋᔖᓂᑎᒄ, ᒑ ᒌ ᐱᒋᔥᑖᔨᐦᑎᒧᐙᒄ ᒋᔖᒥᓂᑑ ᒋᐱᒫᑎᓰᐎᓂᐙᐤ ᒧᔮᒻ ᐋ ᐱᒫᑎᐦᒡ ᒥᔨᐙᐎᓐ ᐋ ᐃᓯᓈᑯᐦᒡ, ᐋ ᐱᔮᐦᑭᐦᒡ ᑭᔮᐦ ᐋ ᓂᐦᐋᔨᐦᑎᒥᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ᙮ ᐋᐅᒄ ᒋᐱᐦ ᑎᓈᐙᐤ ᒋᐦᒋᐙ ᒑ ᒌ ᐄᔑ ᐊᔨᒥᐦᐋᔥᑎᐙᐦᒄ ᒋᔖᒥᓂᑑ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","ᐊᑳᐐ ᓂᔅᐱᑐᐙᐦᑯᒡ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᔨᒡ ᐊᓂᒌ ᐋᑳ ᑳ ᑖᑆᔮᔨᒫᒡ ᒋᔖᒥᓂᑑ᙮ ᑎᔨᑯᒡ ᐱᒋᔅᑎᓈᐦᒄ ᒋᔖᒥᓂᑑ ᐃᔨᐦᒡ ᒑ ᒌ ᐄᑖᔨᐦᑖᑯᐦᐄᑖᒄ ᐋ ᐅᔅᒋᐦᑖᑦ ᑖᓐ ᐋ ᐄᔑ ᒫᒥᑐᓈᔨᐦᑎᒸᒄ ᑭᔮᐦ ᑖᓐ ᐋ ᐄᔑ ᐱᒫᑎᓰᐙᒄ᙮ ᐋᒄ ᒫᒃ ᒑ ᒋᔅᒑᔨᐦᑎᒸᒄ ᒋᔖᒥᓂᑑ ᐅᑎᑖᔨᐦᑎᒧᐎᓐ, ᒋᑭ ᒋᔅᒑᔨᐦᑖᓈᐙᐤ ᐊᓐ ᒑᒀᓐ ᒫᔻᔑᒡ ᑭᔮᐦ ᐊᓂᔮᔨᐤ ᒑᒀᔨᐤ ᓈᐦᐋᔨᐦᑎᒥᐦᐄᑯᑦ ᒋᔖᒥᓂᑑ, ᑭᔮᐦ ᒫᒃ ᐊᓂᐦᐄ ᒑᒀᓂᐦᐄ ᒥᑐᓐ ᐋ ᑯᐃᔅᑯᓈᑯᐦᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","ᒋᔖᒥᓂᑑ ᓂᒌ ᒋᔖᐙᑐᑖᒄ ᐋ ᒌ ᒥᔨᑦ ᒑ ᒌ ᐋᐱᑎᔒᔥᑑᒄ᙮ ᐋᐅᒄ ᒫᒃ ᐙᐦᒋ ᐄᑎᑯᒡ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᐋᑳ ᐊᐅᔅᑖ ᒑ ᐄᑖᔨᒦᓱᔮᒄ ᑖᓐ ᒋᑭ ᐄᑖᔨᒦᓱᑖᐙᐤ᙮ ᒥᒄ ᒫᒃ ᑯᐃᔅᒄ ᐐᐦ ᐄᔑ ᒫᒥᑐᓈᔨᒦᓱᒄ᙮ ᒥᓯᐙ ᐋ ᑎᔑᔮᒄ ᒋᑭ ᐎᔮᔨᐦᑖᓈᐙᐤ ᑖᓐ ᑖᑆᐦ ᒑ ᒌ ᐃᔨᐦᑐᑎᒫᒄ᙮ ᒋᑭ ᐐᐦ ᓂᓈᑭᑎᐙᔨᐦᑖᓈᐙᐤ ᑖᓐ ᑳ ᐃᔥᐱᔥ ᒥᔨᑖᒄ ᒋᔖᒥᓂᑑ ᑖᑆᔮᔨᐦᑎᒧᐎᓂᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ᐹᔨᑯᓂᔨᐤ ᐊᐙᓐ ᐅᔨᐤ᙮ ᓂᓈᐦᑭᐤ ᒥᒄ ᐄᔑ ᐱᔅᒑᓰᐎᓃᔨᐎᔨᐤ ᐊᓂᔮᔨᐤ ᐅᔨᐤ᙮ ᑭᔮᐦ ᓂᓈᐦᑭᐤ ᐄᑖᐱᑎᓂᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᐱᐱᔅᒑᓯᐎᓃᔨᒡ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","ᐋᐅᒄ ᒫᒃ ᐊᓯᓈᑯᓯᔨᐦᒄ ᒌᔮᓂᐤ ᐋᑖᑆᔮᔨᐦᑎᒥᐦᒄ᙮ ᒥᓯᐙ ᒋᐹᔨᑯᓈᓂᐤ ᙭ ᐋᐦ ᑖᑦ᙮ ᐋᑦ ᒫᒃ ᐋ ᒥᐦᒑᑎᔨᐦᒄ ᐊᔮᐱᒡ ᐹᔨᒄ ᒥᔨᐤ ᒋᑎᐄᔑᓈᑯᓯᓈᓂᐤ᙮ ᒥᓯᐙ ᒫᒃ ᐋᐦᑎᔒᐦᒄ ᐋᑯᑖᐦ ᐋ ᐄᔑ ᐐᒋᐦᐄᐙᔨᐦᒄ ᐆ ᒥᔨᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","ᒥᓯᐙ ᐋᐦᑎᔒᐦᒄ ᓂᓈᐦᑭᐤ ᒥᔨᐙᐎᓐ ᒋᒌ ᒥᔨᑯᓂᐤ ᒋᔖᒥᓂᑑ᙮ ᒋᐱᐦ ᐋᐱᒋᐦᑖᓈᓂᐤ ᒫᒃ ᐅᐦᐄ ᒥᔨᐙᐎᓐ᙮ ᑳ ᒥᔮᑭᓅᒀ ᐊᐙᓐ ᒑ ᒌ ᐋᔨᒦᔥᑎᒧᐙᑦ ᒋᔖᒥᓂᑑ ᐋ ᐐᐦᑎᒧᐙᑦ ᐊᐙᔨᐤᐦ ᑖᓐ ᐋᐦ ᐄᑎᑯᐎᔨᒡ ᒋᔖᒥᓂᑑ ᐋᔪᐎᒄ ᒋᐱᐦ ᐃᔨᐤ ᐊᓂᔮᔨᐤ ᑖᓐ ᐋ ᐄᔑ ᑖᑆᐦᑎᐦᒃ ᒑ ᒌ ᐃᔨᑦ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","ᑳ ᒥᔮᑭᓅᒀ ᐊᐙᓐ ᓈᔥᒡ ᒑ ᒌ ᒥᔪ ᐐᒋᐦᐋᑦ ᐊᐙᔨᐤᐦ ᐋᔪᐎᒄ ᑭᔨᑆ ᐊᓂᔮᔨᐤ ᒋᐱᐦ ᐄᔨᐦᑐ᙮ ᑳ ᒥᔮᑭᓅᒀ ᐊᐙᓐ ᒑ ᒌ ᒋᔅᑯᑎᒫᒑᑦ ᒋᐱᐦ ᒋᔅᑯᑎᒫᒑᐤ᙮ ");
INSERT INTO crl_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ᐋ ᑖᒀ ᐊᐙᓐ ᐋ ᒌ ᒥᔮᑭᓅᑦ ᒑ ᒌ ᐅᐦᐱᓅᐙᑦ ᐋ ᐊᔨᒥᐦᐋᑦ ᐋᐙᔨᐤᐦ ᐅᐦᒋ, ᐋᔪᐎᒄ ᒋᐱᐦ ᐄᔑ ᐅᐦᐱᓅᐙᐤ᙮ ᑳ ᒥᔮᑭ