﻿USE sofia;
DROP TABLE IF EXISTS sofia.cpy_vpl;
CREATE TABLE cpy_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cpy_vpl WRITE;
INSERT INTO cpy_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Owakira etanta-nakari rowetsikan-teetzi, riitakira Tajorentsi wetsika-kirori inkite eejatzi kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tema tekatsi jeekatsini kepatsiki, iyoshiita inkaari eejatzi tsireni-kaakiri. Apatziro anashaata ishire Tajorentsi inkaari-mashiki. ");
INSERT INTO cpy_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ari iñaawae-tanaki Tajorentsi, ikantzi: “Okoñeetyii”, matanaka koñeetyaanaki. ");
INSERT INTO cpy_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Iñaatziiro Tajorentsi kameetha okantanaka okoñeetyaanaki. Rinashitakawo koñeetyaatsiri, eejatzi tsirenikaakiri. ");
INSERT INTO cpy_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Iitakiro “kitejeri”. Rooma kaari koñeeta-tsini iitakiro “tsireniri”. Ari otsireni-tanee opoñaashita okiteje-tanee, rootaki etana-kawori apaani kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Opoñaashita ikantanee Tajorentsi: “Otzimi aatzinkironi nijaa-paeni, rootaki inashi-tyaawoni.” ");
INSERT INTO cpy_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Imatakiro Tajorentsi, tzimanaki aatzinkironi nijaa. Eenitatsi nijaa jeekaneen-tsiri jenokinta, itsipa jaawiki. Ari okantanakari. ");
INSERT INTO cpy_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Iitakiro Tajorentsi aatzinkirori nijaa ‘inkite”. Ari otsireni-tanee opoñaashita okiteje-tanee, rootakira apitetatsiri kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Opoñaashita ikantzi Tajorentsi: “Apataatyaa nijaa-paeni okaatzi tzimatsiri jaawiki, okoñaatantyaari jempe opiryaa-pathate.” Matanaka ikantakiri. ");
INSERT INTO cpy_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Iitakiro Tajorentsi jempe opiryaa-patha-tanaki “kepatsi”. Rooma jempe apataatanaka nijaa-paeni iitakiro “inkaari”. Ikanta raminakiro Tajorentsi kameetha okantaka. ");
INSERT INTO cpy_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Opoñaashita ikantzi Tajorentsi: “Oshooki kepatsiki inaashi-yitachari inchato eejatzi pankirentsi, tzimatsini okithoki ithotee-teri eejatzi rowaetyaari.” Matanaka ikantakiri. ");
INSERT INTO cpy_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ari oshookanaki kepatsiki inashi-yitachari inchato eejatzi pankirentsi. Tzimayitanaki okithoki inchatopaeni. Ari okimitakari pankirentsi. Raminakiro Tajorentsi irokapaeni kameetha okantaka. ");
INSERT INTO cpy_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ari otsireni-tanee opoñaashita okiteeje-tanee, rootaki mawatatsiri kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Opoñaashita ikantzi Tajorentsi: “Itzimi jenokinta oorenta-chani, riitaki inashi-takae-yaawoni kitejeri eejatzi tsireniri. Rootaki riyoetan-tyaawori kitejeri-paeni, ojarentsi-paeni, eejatzi kitejeri roemoshirenkan-teetari. ");
INSERT INTO cpy_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Riitaki oorentaa-chani jenokinta ikoñeetya-kahaero jaawiki.” Matanaka ikantakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Aripaete rowetsikakiri Tajorentsi apite antari oorenta-chani. Apaani antari oorenta-chari kitejeriki, riima itsipa ewonkiri oorenta-chari tsireniriki. Ari rowetsika-kiriri eejatzi maawoeni ompokiro-paeni. ");
INSERT INTO cpy_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Rowanakiri Tajorentsi irika-paeni jenokinta, riitaki koñeetya-kahaerori maawoeni kepatsiki, ");
INSERT INTO cpy_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kitejeriki eejatzi tsireniriki. Rootaki riyoetan-tyaawori kitejeri eejatzi tsireniri. Ikanta raminakiri Tajorentsi irika-paeni kameetha ikantaka. ");
INSERT INTO cpy_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ari otsireni-tanee opoñaashita okiteje-tanee, rootaki 4-tatsiri kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Opoñaashita ikantzi Tajorentsi: “Ishekitee nijaaki inaashi-yitachani shimapaeni, eejatzi shiwankiri-paeni aayita-tsini.” ");
INSERT INTO cpy_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tema rowetsikakiri Tajorentsi antari-paeni jeekatsiri inkaariki, eejatzi maawoeni inashi-yi-tachari jeekatsiri nijaaki, osheniyi-tanaki. Rowetsikakiri ikaatzi inashi-yi-tachari shiwankiri-paeni aayita-tsiri. Ikanta raminakiri Tajorentsi irika-paeni kameetha ikantaka. ");
INSERT INTO cpy_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Itajonkawenta-nakiri Tajorentsi, ikantziri: “Itzimayitee iryaani-paeni, ishenitan-teeyaari nijaaki-paeni. Ari ikimitee-yaari eejatzi shiwankiri-paeni rosheki-yitee kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ari otsireni-tanee opoñaashita okiteje-tanee, rootaki 5-tatsi kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Opoñaashita ikantzi Tajorentsi: “Roshekitee kepatsiki ikaatzi inaashi-yitachari, ipireetari-paeni, antami-weri-paeni, anayita-tsiri, maawoeni tzimatsini kepatsiki.” Matanaka ikantakiri. ");
INSERT INTO cpy_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Ikanta rowetsika-yitakiri Tajorentsi maawoeni irika-paeni kameetha ikantaka. ");
INSERT INTO cpy_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Opoñaashita ikantzi Tajorentsi: “Jame owetsiki atziri kimiteeni aaka. Riitaki iyothanita-tsini rawijeri jeekatsiri inkaariki-paeni, shiwankiri-paeni, ipireetari-paeni, maawoeni tzimatsiri kepatsiki, eejatzi ikaatzi anayita-tsiri jaawiki.” ");
INSERT INTO cpy_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Imatakiri Tajorentsi rowetsikakiri atziri, roshiya-kaakari jempe ikanta rirori. Rowetsikaki shirampari eejatzi tsinani. ");
INSERT INTO cpy_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Iroka ikantakiri Tajorentsi itajonkawenta-nakiri: “Itzimayitee peentsite, poshekiyitee. Pinampi-teeyaawo maawoeni kepatsiki, pipinkathari-wentante. Piyothanitee pawijiri maawoeni tzimatsini jaka kepatsiki. Pawijiri ikaatzi jeekayitatsiri nijaa-ki, shiwankiri-paeni, ipireetari-paeni, antami-weri-paeni, eejatzi ikaatzi anayita-tsiri jaawiki.” ");
INSERT INTO cpy_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ikantaki eejatzi Tajorentsi: “Nopakimiro okaatzi shookatsiri kepatsiki tzimatsiri okithoki, eejatzi inchato-paeni okaatzi kithoki-tatsiri. Rootaki powayitee-yaari eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Riima antami-weri-paeni, ikaatzi anayita-tsiri jaawiki, shiwankiri-paeni, rowaeyaawo inchashi-paeni.” Matanaka ikantakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ari raminakiri Tajorentsi ikaatzi rowetsikakiri kameetha ikantaka. Ari otsireni-tanee opoñaashita okiteje-tanee, rootaki 6-tatsi kitejeri iroka. ");
INSERT INTO cpy_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ari rowetsikaetakiro okaatzi tzimayitatsiri inkiteki eejatzi kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tema rootaki 7-tatsiri kitejeri ithonkantakawori Tajorentsi maawoeni okaatzi rowetsikayitakiri. Roojatzi imakoryaantapaaka rirori. ");
INSERT INTO cpy_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Ari itajonkanakiro Tajorentsi iroka 7-tatsiri kitejeri. Ikantaki: “Notajonkaawenteero iroka kitejeri.” Tema iroka kitejeri rootaki imakoryaantakari Tajorentsi rowetsikantayitakawori maawoeni tzimayiteentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Iroka ikenkithatakoetziro owetsikantakari inkite eejatzi kepatsi. Tema paerani rowetsikantakawori Tajorentsi iroka inkite eejatzi kepatsi, ");
INSERT INTO cpy_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","tekira oshookayitziita pankirentsi eejatzi inchashipaeni. Tekira rowariiroota Tajorentsi inkani kepatsiki, tee itzimita antawaetatsini. ");
INSERT INTO cpy_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Roo kanteencha, shitowaatatsi kepatsiki nija irenkapathatzirori maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Opoñaashita raakiro kepatsi Tajorentsi rowetsikakiri atziri. Itajonkakiri ikiriki, añaanaki. Aripaete rañaanaki etanakawori atziri. ");
INSERT INTO cpy_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ikantakaakawo Tajorentsi otzimi pankirentsimashi janta ishitowapiintzira ooryaa iiteetziro Poshiñaarini. Aritaki roejeekakiri janta shirampari rowetsikakiri. ");
INSERT INTO cpy_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Ari ishookakaayitaki Tajorentsi inashiyitachari pankirentsipaeni, owaneenkayitachari, tzimayitatsiri kameethatatsiri okithoki owaetyaari. Ishookakaaki eejatzi niyankineki pankirentsimashiki apite pankirentsi: apaani rañaanteetari, itsipa riyoetantyaawori kameethatatsiri eejatzi kaari kameethatatsi. ");
INSERT INTO cpy_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Enitatsi Poshiñaariniki nija irenkirori pankirentsimashi, enitatsi ochewaa okaatzi 4. ");
INSERT INTO cpy_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Etanakawori ochewaa iiteetziro Shinchaari, rootaki tapotachari janta Tapotaariki, ari itzimiri ooro. ");
INSERT INTO cpy_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Riiperori ooro tzimatsiri janta, tzimatsi riiperori tziri, tzimatsi eejatzi mapipaeni poreryaatatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Iroka apite-taneentsiri ochewaa iiteetakiro Shipoposhaarini, rootaki tapotachari janta Cheenkariniki. ");
INSERT INTO cpy_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Iroka mawa-tapaentsiri ochewaa iiteetziro Tampishaarini, rootaki tapotachari Aatzikaweniki janta ishitowapiintzira ooryaa. Rooma otsipa 4-tatsiri ochewaa rootaki iiteetakiri Antawaani. ");
INSERT INTO cpy_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ikanta Tajorentsi ari roejeekakiri irika shirampari janta pankirentsimashiki ijeeki Poshiñaariniki, rantawaete, eejatzi raminakowentiro. ");
INSERT INTO cpy_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Iroka ikantanakiri: “Kameethatatsi pithotiro okithoki pankirentsipaeni jeekatsiri pankirentsimashiki. ");
INSERT INTO cpy_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Rooma okithoki pankirentsi riyoteetantyaawori kameethatatsiri eejatzi kaari kamethatatsi, eero pithotziro okithoki. Aririka pithotakiro, aritaki pikamaki.” ");
INSERT INTO cpy_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Opoñaashita ikantanaki Tajorentsi, “Tee okameethatzi ijeekawaete shirampari apaniroeni. Otzimatyee nowetsikiniri amitakoyiterini.” ");
INSERT INTO cpy_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Owakira rowetsikantakari Tajorentsi maawoeni antamiweripaeni, shiwankiripaeni aayitatsiri jenoki, kepatsi raaki rowetsikantakariri. Ari ramakiniri shirampari iiteetziri Adán, iitantayityaariri apaanipaeni rowetsikakirira Tajorentsi. Okaatzira iitayitakiri tsimeriyitatsiri, rootaki iwaeroyitaari nimaeka. ");
INSERT INTO cpy_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Imatakiro Adán iitayitakiri maawoeni antamiweripaeni, maawoni shiwankiripaeni, eejatzi ipireetaripaeni. Tema tekatsi apaani amitakoterini rirori. ");
INSERT INTO cpy_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Ikanta Tajorentsi rowochokyaakiri Adán, ikanta imaaperotanaki kameetha, rayitakiri imeriki, iwichaneeri kameetha iwathaki. ");
INSERT INTO cpy_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Rootaki imereki atziri rowetsikakiri Tajorentsi etanakawori tsinani. Ramakiro Tajorentsi tsinani iñiiro atziri. ");
INSERT INTO cpy_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Ikanta iñaawakiro, ikantanaki: ¡Naaka ashitawo nowatha iroka! Rootaki nomereki. Tsinani oetyaa, Tema nowatha rowetsikaetaki. ");
INSERT INTO cpy_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Rootaki ritsiparyaantyaariri ewankari ipaapate eejatzi riniro, aririka raaki iina, tema apaani ikantaneeya iwathaki okimitakawo rapaani-watha-tanaatyeemi. ");
INSERT INTO cpy_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kaankimerekiri ikanteeyani apitekiro, shirampari eejatzi iina, tema tee ikaaniwiteeyaani. ");
INSERT INTO cpy_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Tema kiyothaniri ikantaka maanki rawijiri antamiweri ikaatzi rowetsikakiri Tajorentsi Pawa. Ari rojampitakiro tsinani, ikantakiro: “¿Arima ikantzimi Tajorentsi tee okameethatzi pithotero okithoki okaatzi pankiteenchari jaka?” ");
INSERT INTO cpy_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Akanakiri tsinani, okantanakiri: “Shinetaantsitatsi nothotero okithoki pankiyiteenchari, ");
INSERT INTO cpy_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","rooma ojatekaenchari pankirentsimashiki eero nothotziro. Tema ikantatyaana Tajorentsi tee okameethatzi nothotero, tee inintakaanawo eejatzi noteeyiro, aririka noteeyakiro, ari nokamaki.” ");
INSERT INTO cpy_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Ari rakanakiro maanki iroka tsinani, ikantziro: “Theeyaantsi ini, eero pikami. ");
INSERT INTO cpy_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Tema riyotzitakawo Tajorentsi aririka pithotakiro okithoki pankirentsi ipinkakaemiri aritaki piyotanakiro kameethatatsiri eejatzi kaariperori, poshiyakotanakyaari ikantaha Tajorentsi rirori.” ");
INSERT INTO cpy_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Aminanakiro tsinani okithoki pankirentsi kameetha okantaka, oñaawenatanakawo othotero, oshekitzimotantyaawori iyomento. Aakiro chochoki, othotakiro. Roojatzi aantanakanariri oemi, opapaakiri, ithotawakiro eejatzi rirori. ");
INSERT INTO cpy_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Ari okoñaatzimotanakiro, ojeekamerekitashiteeyani apiteroeni. Ahaeyanakini oshi pankirentsi, oshirikakiro, rootaki opoñaantanakari. ");
INSERT INTO cpy_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Okanta otampetyaanaki tsireniiteeni ikematziiri ranashitapaaka Tajorentsi Pawa ikinawaeteeyinira rirori pankirentsimashiki. Ari ishiyeeyanakani roma-napithatyaari pankirentsimashiki. ");
INSERT INTO cpy_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Riitaki kantacha Tajorentsi Pawa ikaemapaakiri shirampari: “¿Jempe pijeekakika?” ");
INSERT INTO cpy_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ari rakanakiri shirampari: “Nokemawakimi pikinapaaki pankirentsimashiki, antawoete nothaawanaki, tema tekatsi nokithaatyaari, rootaki nomanantanakari.” ");
INSERT INTO cpy_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ikanta Tajorentsi, rojampitapaakiri: “¿Iitaka kantakimiri pijeekamerikitashitaha? ¿Pithotakiroma chochoki nokantzimiri eero pithotziro?” ");
INSERT INTO cpy_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Rakanaki shirampari, ikantzi: “Kaarima tsinani pipakinari notsipatyaari, rootakira pakinawori chochoki, nothotantakawori naaka.” ");
INSERT INTO cpy_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ikanta Tajorentsi Pawa rojampitanakiro tsinani, ikantziro: “¿Iitaka pantantawori iroka?” Roojatzi okantantanakari roori: “Maanki amatawitakinari naaka, rootaaki nothotantakawori chochoki.” ");
INSERT INTO cpy_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ikantanakiri maanki Tajorentsi Pawa: “Okantakaantziro pantakirowa iroka, nimaeka riyakateetemi pitsipawitarira maawoeni antamiweripaeni. Pishipaneeki panashiteeya nimaeka, kepatsi powaeya. ");
INSERT INTO cpy_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Naaka kantakahaeyaawoni okijaneentantemiri iroka tsinani. Ari ikanteemiri ojariteeyaari ikijaneenteeri pitomipaeni. Riitaki ompojiimini piitoki ojariteeyaari tsinani, apatziro patsikiri eeroka iitziki.” ");
INSERT INTO cpy_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Ikantanakiro tsinani: “Antawoete pikemaatsiwaeteeya aririka pitzimaanite. Pikoetyaapiinteeri piimi, riitaki antariwentzimiri rirori, osheki pipinkathateri eeroka.” ");
INSERT INTO cpy_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Eejatzi ikanteetanakiri shirampari: “Okantakakimi paawakotawakiro piina roojatzi pithotantakawori chochoki nopinkakawitziimiri, eerokaha kantakaanteroni riyakatanteetyaawori kepatsi. Antawoete pipomeentsiwaeteeyaawo pantawaetee piñaanteeyaawori otzimae powaeyaari eenirowa pañaayitzi. ");
INSERT INTO cpy_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kitocheemashi okantayiteeya kepatsi. Piwankiri powayiteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Otzimatye pimajawiwenteero okaate powayiteeyaari, roojatzi piikamakotee, tema kepatsipane pinatzi rowetsikaetakimiri, eejatzi pipeyaneeyawo kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ikanta shirampari iitakiro iina ‘Eva,’ tema roo rinirontayityaari ikaate tzimayitatsini. ");
INSERT INTO cpy_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Roojatzi raantanaka Tajorentsi Pawa mashitsi rowetsikakiniri iithaari, rootaki ikithaatakiriri shirampari eejatzi tsinani, ");
INSERT INTO cpy_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ikantaki: “Ari roshiyakae aakapaeni shirampari, riyotanakiro kameethatatsiri eejatzi kaariperori. Nimaeka tee nokowakaaneeri ithotaneero chochoki owañaantatsiri, tee nokoyi rañe ikanteetatyeeyani eero ikamaanite.” ");
INSERT INTO cpy_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Roojatzi romishitowantakari Tajorentsi irika shirampari pankirentsimashiki jeekatsiri Edén-ki. Rantawaetakaakiri jaka kepatsiki jempe rahaetakiri rowetsikanteetakariri shirampari. ");
INSERT INTO cpy_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ikanta romishitowaetakiri shirampari, rowaakiri ronampiri tajorentsi pankirentsimashiki jempe ishitowapiintzi ooryaa. Rowaakiro eejatzi owathaamentotsi oshiyawori opaamatzi paamari, oshewatzimaeta eejatzi, eero rareetanteetawo pankirentsi ow añaantatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ikanta Adán, itsipatakawo iina Eva. Ari omotzitaki, roojatzi itzimantakari otomi oetakiri Caín, tema okantaki roori: “Notzimakiri notyomi shirampari. Riitaki Tajorentsi pakinariri.” ");
INSERT INTO cpy_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Roojatzi itzimantakari itsipa otomi iita Abel, rirentzitanakari Caín. Pirawaerintzi rini Abel, riima Caín pankiwaerentsi rini. ");
INSERT INTO cpy_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Okanta paata ojamanitaki, irika Caín, raanakiniri Tajorentsi iwankiri ipiri. ");
INSERT INTO cpy_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Ari ikantzitakari Abel rirori, raanakiniri Tajorentsi kameethaperotatsiri ipira. Raakameethatanakiri Tajorentsi irika Abel ari ikimitzitakari rowishatepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Teemaeta raakameethatziri Caín eejatzi okaatzi ramawitakanariri. Rootaki otyaantanakariri Caín imashirenka. ");
INSERT INTO cpy_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ikantakiri Tajorentsi: “¿Iitaka otyaantzimiri pimashirenka? ");
INSERT INTO cpy_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Pantakityeeromi kameethatatsiri, eero pikantayitashitami. Rooma tee pimatziro, aritakira pikaariperoshiretaki. Roo kantzimaetacha aritakimi potsinampaakiromi eeroka.” ");
INSERT INTO cpy_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Ikanta Caín raanakiri rirentzi Abel ikinawaetakayiri. Ikanta ikinawaeteeyinira, ari rompojaakiri Abel. ");
INSERT INTO cpy_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ari rojampitakiri Tajorentsi irika Caín, ikantziri: “¿Jempe ikinakika pirentzi Abel?” ikantanaki Caín: “Tee niyotzi. ¿Naakama kempoyeeriri?” ");
INSERT INTO cpy_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Rapiitziri ikantziri: “¿Iitaka pantantakawori iroka? Kimitaka okaemakaematatyeenami riraa pirentzi pompojakirira. ");
INSERT INTO cpy_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kijaneentaarewo pikanteeya, eero pinampitaawo kepatsiki tema otsiryaantanamiki riraa pirentzi pompojakirira. ");
INSERT INTO cpy_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Pankiwaerintzi pinawita, eeromaeta piñaayiteero okithokitzimoteemi. Pithonkero pikinakinawaeyite jemperikapaeni, eero piñaahaero pijeekashiwaeteeya.” ");
INSERT INTO cpy_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Rakanakiri Caín irika Tajorentsi ikantziri: “Eero nomatziro nokijashityaawo okaatzi powajankitakina, antawoete ini. ");
INSERT INTO cpy_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Poemishitowakina kepatsikika, otzimatye niyaate nokinakinawaetee jemperika, inteena nokinapithateemi, eero noñiiro nojeekashiwaeteeya. Ikaatzi ñaayitenani ari rompojeena.” ");
INSERT INTO cpy_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Rakanaki Tajorentsi ikantziri: “Tzimatsirika ompojeemini eeroka, osheki rowajankiiteri rirori.” Ikimitakaantakari Tajorentsi ikentakotatyeerimi iwathaki Caín riyoetantyaariri, opoñaantyaari eero rompojanteetari. ");
INSERT INTO cpy_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Shitowanaki Caín ikenkithawaetakaakiri Tajorentsi, jataki inampiteeyaawo Nod-ki, jeekatsiri ishitowapiintzira ooryaa janta Edén-ki. ");
INSERT INTO cpy_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ikanta Caín aaki rirori iina, rowakakiro, tzimaki itomi iitakiri Enoc. Rowetsikaki Caín inampi, iitakiro Enoc, aakotakiri iwaero itomi. ");
INSERT INTO cpy_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Riitaki Enoc ashitanakariri Irad. Ikanta Irad riitaki ashitanakariri Mejujael. Ikanta Mejujael riitaki ashitanakariri Metusael. Ikanta Metusael riitaki ashitanakariri Lamec. ");
INSERT INTO cpy_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ikanta Lamec tzimaki rirori apite iina: etanakawori oeta Ada, otsipa oeta Zila. ");
INSERT INTO cpy_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Itzimanaki otomipaeni Ada iitakiri Jabal, riitaki isheninkapaeni ikaatzi pankoshetawaetachari, pirawaenitachari. ");
INSERT INTO cpy_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Eenitatsi Jabal itsipa rirentzi iitachari Jubal, rijatzi isheninkapaeni ikaatzi piyompiwaetatsiri, eejatzi showiwaetatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tzimaanitaki roori Zila, oetakiri Tubal-Caén, riitaki wetsikayitziriri poreryaayitatsiri eejatzi kijoyitatsiri. Irika Tubal-Caén eenitatsi rirori ritsiro oeta Naama. ");
INSERT INTO cpy_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Ikanta Lamec, ikantakiro iina Ada eejatzi Zila: “Pikemijantena okaate nokantemiri: Nompojakiri atziri tema retashitakityaana ikichankakina nowathaki. Nowamaaki ewankari tema retashitakinaha rompojakina. ");
INSERT INTO cpy_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Osheki ikijawenteeteri Caín, rooma naaka nomaperotante nokijakowentante.” ");
INSERT INTO cpy_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ikanta rapiiteero Adán itzimakahaero iina, tzimae itsipa otomi oetakiri Set. Ari okantzi: “Ipaana Tajorentsi itsipa notyomi riitaki poyaataariri Abel-ni, rompojakiri paerani Caín.” ");
INSERT INTO cpy_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Ikanta Set tzimaki itomi rirori iitakiri Enós. Riitaki etanakawo rapatziyaanakari Tajorentsi raakotapiinteero iwaero. ");
INSERT INTO cpy_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Iroka rojankinatakota ikaatzira icharinipaeni Adán. Tema owakira Tajorentsi rowetsikakiri atziri, ari roshiyari ikantaha itajorentsitzi rirori. ");
INSERT INTO cpy_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Rowetsikakiri shirampari eejatzi tsinani. Itajonkawentakiri. Tema owakira rowetsikakiri Tajorentsi, iitakiri ‘Atziri.’ ");
INSERT INTO cpy_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Okaataki Adán 130 rojarentsite, aripaete itzimae itsipa itomi iiteeri Set. Riitakira kimitanakariri jempe ikantawaeta rirori. ");
INSERT INTO cpy_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Okanta awijaki maawoeni irokapaeni, eeniroha rañaawita Adán okaataki 800 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tzimanaki Adán 930 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tzimanaki rirori Set okaatzi 105 rojarentsite, aripaete itzimaki itomi iitakiri Enós. ");
INSERT INTO cpy_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Set okaatzi 807 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tzimanaki Set 912 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Tzimanaki rirori Enós okaatzi 90 rojarentsite, aripaete itzimaki itomi iitakiri Caenán. ");
INSERT INTO cpy_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Enós okaatzi 815 ojarentsi. Tzimawaki itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tzimanaki Enós 905 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tzimanaki rirori Caenán okaatzi 70 rojarentsite, aripaete itzimaki itomi iitakiri Mahalaleel. ");
INSERT INTO cpy_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Caenán okaatzi 840 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tzimanaki Caenán 910 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tzimanaki rirori Mahalaleel okaatzi 65 rojarentsite, aripaete itzimaki itomi iitakiri Jared. ");
INSERT INTO cpy_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Mahalaleel okaatzi 830 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tzimanaki Mahalaleel 895 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tzimanaki rirori Jared okaatzi 162 rojarentsite, aripaete itzimaki itomi iitakiri Enoc. ");
INSERT INTO cpy_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Jared okaatzi 800 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tzimaki Jared 962 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tzimanaki rirori Enoc okaatzi 65 rojarentsite, aripaete itzimaki itomi iitakiri Matusalén. ");
INSERT INTO cpy_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ari ikantapiintatya Enoc rantziro ikoyiri Tajorentsi. Tzimakiita Matusalén, eeniro ijeekawita Enoc okaatzi 300 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tzimanaki Enoc 365 ojarentsi okaatzi ijeekaki. ");
INSERT INTO cpy_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ari ikantapiintatya Enoc rantziro ikoyiri Tajorentsi, roojatzi rantaariri Tajorentsi, tee iñahaeteeri. ");
INSERT INTO cpy_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tzimanaki rirori Matusalén okaatzi 187 rojarentsite, aripaete itzimaki itomi iitakiri Lamec. ");
INSERT INTO cpy_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Okanta awijayitaki maawoeni irokapaeni, eeniro rañaawita Matusalén okaatzi 782 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tzimanaki Matusalén 969 ojarentsi okaatzi rañaaki, roojatzi ikamantaa. ");
INSERT INTO cpy_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Tzimanaki rirori Lamec okaatzi 82 rojarentsite, aripaete itzimaki itomi, ");
INSERT INTO cpy_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ari iitakiri Noé. Tema ikenkithawaetaki Lamec, ikantzi: “Riyakatakiro Tajorentsi kepatsi, otzimatye antawaetee osheki apankiwaetee. Irika eentsi riitaki makoryaakahaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Tzimakiita Noé, eeniro rañaawita Lamec okaatzi 595 ojarentsi. Tzimawae itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tzimanaki Lamec 777 ojarentsi okaatzi rañaaki, roojatzi ikamantaari. ");
INSERT INTO cpy_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ikanta Noé tzimaki rirori okaatzi 500 rojarentsite, aripaete itzimaki itomipaeni: Sem, Cam, Jafet. ");
INSERT INTO cpy_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ikanta roshekitanaki atziripaeni kepatsiki, tzimayitanaki rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Owaneenka okantayitaka, iñaayitakiro itomyaayi Tajorentsi. Ari riyoyaaki tsinani, iinantakawo okaatzi kameethatzimotakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Ari ikantanaki Tajorentsi: “Tee nokoyi rañaayitee atziripaeni, tema wathatsi rinayitaki riroripaeni. Apatziro rañaawitya okaate 120 ojarentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ikanta iinantayitanakawo itomyaayii Tajorentsi, tzimanaki itomipaeni, rootaki etaneenchari. Riitakira irika antaripenthaki nampitakawori jaka kepatsiki, riroperori ikanteeyani. ");
INSERT INTO cpy_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Iñaakiri Tajorentsi maperotaka ikaariperotaki atziripaeni kepatsiki, itzimawenteeyironi ikenkithashiretawo ikaariperoyite. ");
INSERT INTO cpy_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Antawo okatsitzimoneentanakiri Tajorentsi rowetsikakirira atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ikantanaki: “Otzimatye nothonkaeri atziripaeni ikaatzi nowetsikakiri kepatsiki, ari noshiyakahaeri antamiweripaeni, anashiyitachari, shiwankiripaeni. Antawo okatsitzimoneentakina nowetsikawitakarira.” ");
INSERT INTO cpy_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Roo kantacha, iñaapiintakiri Noé kameethashireri ikantzimotakari rirori. ");
INSERT INTO cpy_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Iroka okanta ikenkithatakoetziri Noé. Tema Noé kameethashireri rini, ikemijantapiintziri Tajorentsi. Ikaatzira atziripaeni ijeekaeyinira paerani, apatziro Noé rantapiintakiro ikowayiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Iikaatzi mawa itomi, iroka iwaero: Sem, Cam, Jafet. ");
INSERT INTO cpy_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Osheki ikaariperotzimotakiri aatziripaeni Tajorentsi, ikoshekawakaawaeta. ");
INSERT INTO cpy_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Tema mawoeni ikaariperotaki atziripaeni. Ikanta iñaakiro Tajorentsi osheki okantaka kaariperotaantsi kepatsiki, ");
INSERT INTO cpy_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ikantakiri Noé: “Nokenkithashiretaka nothonkeri atziripaeni. Riitaki kantakaantakirori otzimantakari kepatsiki ompojawakahaantsi, nothonkeri irikapaeni eejatzi maawoeni kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Piwenatero inchato tzimatsiri okashi, rotaki pamaatakotantyaari. Pitsipanayitero inthomoeki pitantotantyaawo jantarikota. Roojatzi piwichantakyaawori tziriki iwitenkayitaha ojanarikira eejatzi inthomoeki, eero okyaantantawo nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Iroka okaate ojanthate pamaatakomento: 300 okaate ojanthate pimonkaatantyaawo pikonaki, 50 okaate ojanthate oshipaneeki pimonkaatantyaawo pikonaki, 30 okaate ojenokite pimonkaatantyaawo eejatzi pikonaki. ");
INSERT INTO cpy_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Mawamenko okaate oshitamenko owawitya, apaani okantya pimoontero shaawiini opankotapishiki ikine ramineete. Iroka omoo okaate ojenokite apaani pikonaki. Apaani okantya eejatzi ashitawo. ");
INSERT INTO cpy_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nowaryaatyeero antawo inkani thonkironi kepatsi, rootaki thonkaerini maawoeni añaayitatsiri jemperikapaeni jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Roo kantzimaetacha tzimatsi akashiyaakaawakaeyaari. Pomonkyaayiteri amaatakomentotsiki pitomipaeni, piina, paniropaeni eejatzi eeroka. ");
INSERT INTO cpy_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Pomonkyaayite eejatzi apitepaeni tsimeri pamaatakomentoki, apaani shirampari eejatzi apaani tsinani, opoñaantyaari itzimantayiteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Pomonkyaayite eejatzi pamaatakomentoki apitepaeni ikaatzi inashiyitachari antamiweripaeni: shiwankiripaeni, ipiraetari, anashiyitachari kepatsiki, opoñaantyaari itzimantayiteeyaari riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Paayite eejatzi okaatzi rowaetari, powaantyaawo, otzimantyaari poyaari eeroka eejatzi tsimeripaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Rantakiro Noé maawoeni okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ikanta Tajorentsi ikantakiri Noé: “Ikaatakira atziripaeni nimaeka, apatziro pikantakaawo eeroka pantapiintakiro nokoyiri naaka. Pikye amaatakomentotsiki pitsipatanakyaari pitomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Paanaki inashiyitachari tsimeri kitewathari, ikaate 7 shirampari eejatzi tsinani, riima tsimeri kaariperowathari apite ikaate paanakiri, apaani shirampari eejatzi tsinani. ");
INSERT INTO cpy_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Paanaki eejatzi inashiyitachari shiwankiri, ikaate 7 shirampari eejatzi tsinani, eero ipeyanta jempe ikantawaeta. ");
INSERT INTO cpy_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Okatapaaki 7 kitejeri nowaryaantyaawori inkani, okamaetyaawo opariyi okaate 40 kitejeri eejatzi 40 tsireniri. Nothonkatyeerira kepatsiki maawoeni añaayitatsiri, ikaatzi nowetsikawitakari.” ");
INSERT INTO cpy_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Rantakiro Noé maawoeni okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Oonkantakari paerani kepatsi, tzimaki Noé okaatzi 600 rojarentsite. ");
INSERT INTO cpy_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Roojatzi rotetapithateeyanakawoni Noé oonkawo amaatakomentotsiki itsipateeyanakarini itomipaeni, iina, raniropaeni. ");
INSERT INTO cpy_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Ikaatzi antamiweripaeni kitewathatatsiri, eejatzi kaariperowathatatsiri, aayitatsiri, anashiyitachari, ");
INSERT INTO cpy_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","oteyitanaka amaatakomentotsiki itsipatakari Noé, apitepaeni itsipatawakaapaa, apaani shirampari eejatzi tsinani. mataka okaatzi ikantakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Okanta monkaatapaaka 7 kitejeri, etanakawo oonkawo opamankanakiro kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Okaataki rojarentsite Noé 600, roori kitejeri 17 apitetaneentsiri kashiri. Aripaete otonkakotanaki antawoete inkaare inthomoekinta kepatsi, ashitaryaakotanaka eejatzi jenoki inkiteki. ");
INSERT INTO cpy_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Okamaetakawo oparyaaki kepatsiki okaatzi 40 kitejeri eejatzi 40 tsireniri. ");
INSERT INTO cpy_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Rootakira kitejeri ikyaantanakari Noé amaatakomentotsiki itsipayitanakari itomipaeni Sem, Cam, Jafet, iina eejatzi mawa raniro. ");
INSERT INTO cpy_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Aritaki itsipatakari maawoeni antamiweripaeni, ipireetari, anashiyitachari kepatsiki eejatzi shiwankiripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Maawoeni antamiweripaeni ikyaayitanaki amaatakomentotsiki itsipatakari Noé, apitepaeni itsipatawakanaka. ");
INSERT INTO cpy_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Rotetanaka apaani shirampari eejatzi apaani tsinani. Yomaatakaha okaatzi ikantakiriri Tajorentsi Noé. Roojatzi rashitantanakawori Tajorentsi ashitawo amaatakomentotsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Ari iyomaatapaaka okaatzi 40 kitejeri paryaapaaki inkani. Okanta oonkanaka, amaatanaki amaatakomentotsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Eekiro opokaahatzi nijaa, eekiro otzinaatya amaatakomentotsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Tema intsipaete opokaahapaaki nijaa, opamankanakiro antawopaeni tonkaari jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Opamankaperotanakiro antawopaeni tonkaari, awijaneentanakiro ojenokitzi okaatzira omonkaatari 15 konakintsi. ");
INSERT INTO cpy_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Roojatzi ithonkantaakari maawoeni atziripaeni jaka kepatsiki, aritaki ikanteeyakani shiwankiripaeni, antamiweripaeni, ipireetari, eejatzi anashitachari kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ari ithonkatakiri añaayitatsiri kepatsi, maawoeni ikaatzi jekawitachari. ");
INSERT INTO cpy_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Apatziro ikantakawo Noé eejatzi ikaatzi jeekaentsiri amaatakomentotsiki, ritaki añahaatsiri. Riima itsipapaeni ithonkaetakiri: atziripaeni, antamiweripaeni, shiwankiripaeni, ikaatzira anashiyiwitachari, maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tema 150 kitejeri okaatzi ojamanitaki opamankakiro oonkawo kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ikanta Tajorentsi, roshiretaari Noé eejatzi maawoeni antamiweripaeni itsipatakarira amaatakomentotsiki. Itampyaatakaakiro pyahaana oonkawo. ");
INSERT INTO cpy_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ashitayitanaa oshitowaawitaha nijaa poñaaneenchari inthomoeki kepatsiki, ari okantzitanaka jenoki inkiteki. Kaatanee opari inkani, ");
INSERT INTO cpy_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","amatsinka okantaka opiyaata nijaa. Okaataki 150 kitejeri, opiyahaantari nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ikanta rawijaki 5 kashiri, opiryaatakotee amaatakomentotsi janta ochempiki iitachari Ararat. ");
INSERT INTO cpy_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Eekiro iyaatatzi opiyaataawo nijaa. Ikanta rawijaneentakiro rawijaki apite kashiri, ari okoñaatee tonkaari jenokitatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Okanta awijaki 40 kitejeri, rashitaryahaero Noé imoontakirowa amaatakomentotsi, ");
INSERT INTO cpy_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","rowaahakiri tzijoniro. Ikanta reworewowaeta tzijoniro royaawentawo opiryaatee kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ikanta Noé, romishitowakiri shiro iñaantyaawori piryaateerika kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Eejatzi ipiyaawo shiro amaatakomentotsiki, tee iñi jempe rookya, eenirowa oonka kepatsiki. Rowaankawakotanaka Noé rookantapaari shiro romonkyaawaeri amaatakomentotsiki. ");
INSERT INTO cpy_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Eejatzi royaawentaawo Noé okaatzi 7 kitejeri, rapiiteeri rowahaeri shiro. ");
INSERT INTO cpy_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Okanta otsireniityaaki, piyaawo shiro, ramae ithowaki tsipanashi. Ari riyotee Noé piryaatzimatee. ");
INSERT INTO cpy_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Eejatzi royaawentawaa Noé okaatzi 7 kitejeri, rapiiteero rowaahaeri shiro. Tee ipiyaawo. ");
INSERT INTO cpy_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Okaataki Noé 601 rojarentsite, ari opiryaate kepatsi. Ikanta rawijaneentanakiro 10 kashiri, rookaero Noé opankoshi amaatakomentotsi. Iñaakiro piryaatee kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ikanta imonkaatzimataka apite kashiri, ari opiryaateeri kameetha kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Ikanteeri Tajorentsi irika Noé: ");
INSERT INTO cpy_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Pishitowae amaatakomentotsiki, pitsipateeyaawo piina, pitomipaeni eejatzi paniropaeni. ");
INSERT INTO cpy_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Pomishitowaeri maawoeni antamiweripaeni ikaatzira pitsipatakari: shiwankiripaeni, ipiraetari, anashiyitachari kepatsiki. Ishekiteeta maawoeniki kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ikanta Noé itsipatakawo iina, itomipaeni, raniropaeni, shitowoeyeeni amaatakomentotsiki. ");
INSERT INTO cpy_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ari ishitowaeyanakini maawoeni antamiweripaeni, ipiraetari, anashiyitachari, aayitatsiri maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Roojatzi rowetsikantaka Noé taapokimentotsi roemoshirenkantyaariri Tajorentsi. Raaki apaani ikaatzi tsimeriyitatsiri kitewathatatsiri, ari ikantzitakari ikaatzi shiwankiyitatsiri. Itaakiniri. ");
INSERT INTO cpy_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ikanta ikemaenkatawakiri Tajorentsi iwoshininka, ikantanaki: “Eero napiiteero nothonkaeri atziripaeni, nothonkawentashitakari iyaaperonkari. Okantawitaka reentsitakori ikenkithashiryahaapiintawo atziripaeni rantayitero kaariperori. Ari ikimitakiri maawoeni antamiweripaeni, eero napiiteeri nothonkaeri nokimitaakirira nimaeka. ");
INSERT INTO cpy_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ashi owaero ipankiwaete inampiki roojatzi rowiitanteeyaawori iwankiwaeropaeni. Ashi owaatyeero omajawirentsitee eejatzi okatsinkaetyee. Ashi owaatyeero okyaawontsitee eejatzi ojarentsitee. Okitejiyitayi eejatzi otsireniyitayi jaka kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ikanta Tajorentsi itajonkawentakiri Noé itsipataakiri itomipaeni, iroka ikantakiri: “Roshekitee pitomipaeni, ithonkya inampiteeyaawo kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ithaawanteemi antamiweripaeni. Eeroka yotashiteerini shiwankiripaeni, antamiweripaeni, nijaweripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Kameethatatsi poyaari antamiweripaeni eejatzi pankirentsipaeni. Naakaha pakimirori maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Riima añiinkari wathatsi, eero powakotawo riraa, rootaki añaakayiriri. ");
INSERT INTO cpy_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Roo kowaperotachari irahaantsi. Arika piratakakiri pisheninka pompojeri, arira nomatakimi naaka. Arira nokantzityaari pipira, pirentzi, maawoeni atziriyitatsiri, niratakayiri nompojeri. ");
INSERT INTO cpy_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Iitarika ompojerini atziri, Arira rompojeeteeri rirori. Tema Tajorentsi owetsikakiri atziri, roshiyakaakiri itajorentsishiretzi irirori. ");
INSERT INTO cpy_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Roshekitee pitomipaeni eeroka, Ithonkaeya inampitanteeyaawo kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Eekiro iñaanatatziiri Tajorentsi irika Noé itsipataakiri itomipaeni, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Pikem, tzimatsi nokashiyaakaakimiri, ari nokantzityaari eejatzi picharinipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Ari nokanteri maawoeni antamiweripaeni ikaatzi tsipayitakimiri pishitowaera amaatakomentotsiki: shiwankiripaeni, tsimeripaeni, ikaatera tzimayitaatsini kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Okaatzi nokashiyaakaakimiri eero nowashiñeero. Eero napiitantaawo oonkawo nowajankitanteeyaari atziriite eejatzi antamiweripaeni. Eero apiita oonkaeya kepatsi othonkaerikari tzimayitaatsiri.” ");
INSERT INTO cpy_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Eekiro ikenkithawaetakaatziiri Tajorentsi, ikantziri: “Irika iñahaeteeri riyotanteetyaari tzimatsi nokashiyaakaakimiri, roo piñaapiinteeri eeroka eejatzi antamiweripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Arika piñeeri oye menkoriki, piyotzi eenitatsi nokashiyaakaakimiri. ");
INSERT INTO cpy_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Arika ooreenkakite kepatsiki, ari iñahaeteeri ikatziye oye. ");
INSERT INTO cpy_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Ari nokenkithashireterori naaka nokashiyaakaakimiri eeroka eejatzi antamiweripaeni, eero rapiiteero iñahaero oonkawo othonkaero kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Arika noñeeri oye menkoriki, nokenkithashiretapiinteero nokashiyaakaakimiri rootaki naapatziyanteeyaariri atziripaeni, eejatzi antamiweripaeni jeekatsiri kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Roo iñeeri atziripaeni riyotantyaari, riyotee eejatzi antamiweripaeni eenitatsi nokashiyaakaantziri.” Roowa iñaani Tajorentsi ikamantakiriri Noé. ");
INSERT INTO cpy_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Irika itomipaeni Noé ikaatzi shitowaatsiri amaatakomentotsiki: Sem, Cam, Jafet. Riitaki Cam ipaapatetanakari Canaán. ");
INSERT INTO cpy_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ritaki mawa itomipaeni Noé oshekitaatsiri kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Owaancheempeki rini Noé, riira etanakawo ipankiyitziro chochoki imiriyiiteeri. ");
INSERT INTO cpy_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ikanta rirakirowa Noé owaa iwankiri, antawoete ishinkitanakawo tee iñaakoteeya, aatonkoryaawaetaka ipankoki. ");
INSERT INTO cpy_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ikanta Cam ipaapatetanakari Canaán, iñaakiri ipaapate raatonkoryaawaetaka, ikamantakiri rirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ipokapaaki Sem itsipatakari Jafet, ramaki ithaari ipashikaeri ipaapate. Itaapi ipokantaka eero iñaantari raatonkoryaakaa. ");
INSERT INTO cpy_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ikanta ikakitee Noé, riyotaki ritaki iyaapitsi itomi pashikaeriri. ");
INSERT INTO cpy_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ikantanaki: Iyakataarewo rinatye Canaán, Romperatapiintane rinatye rirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Eekiro ikantanakitzi Noé: Riitaki Tajorentsi tajonkawenteerini Sem, Riitaki omperateeyaarini Canaán. ");
INSERT INTO cpy_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Riitaki Tajorentsi kantakaeyaarini Jafet roshekitanteeyaari, Inampiteeyaawo iipatsiteki Sem, Rijatzi omperateeyaarini Canaán. ");
INSERT INTO cpy_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Okanta awijakira oonkapaetetantakari kepatsi, ojamani rañaawae Noé okaatzi 350 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Okaatzi ojamanitaki rañaaki Noé 950 ojarentsi roojatzi ikamantaari. ");
INSERT INTO cpy_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Okanta awijakira oonkawo, tzimanaki itomipaeni Sem, Cam, Jafet. Riitaki ichariniyitanakari Noé. ");
INSERT INTO cpy_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Riitaki Jafet tomintanakariri Homer, Mahoh, Madae, Javán, Tubal, Mesec, Tiras. ");
INSERT INTO cpy_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Riitaki Homer tomintanakariri Askenaz, Rifat, Togarma. ");
INSERT INTO cpy_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Riitaki Javán tomintanakariri Elisa, Tarsis, Quitim, Dodanim. ");
INSERT INTO cpy_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Riitaki icharinitakari Jafet, rijatzi nampitanakawori iñaacheraakipaeni. Tzimayitanaki irikapaeni inampi, eejatzi iñaanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Riitaki Cam tomintanakariri Cus, Mizraem, Fut, Canaán. ");
INSERT INTO cpy_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Riitaki Cus tomintanakariri Seba, Javila, Sabta, Raama, Sabteca. Riitaki Raama tomintanakariri Seba eejatzi Dedán. ");
INSERT INTO cpy_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Riitaki Cus tomintanakariri Nimrod, etanakawori atziri oshekitzimotziri ishintsinka. ");
INSERT INTO cpy_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Riitaki Tajorentsi kantakaakariri Nimrod ikominthatantari. Roo opoñaantari ikanteetzi: “Poshiyaari Nimrod, tema Tajorentsi kantakaakariri ikominthatantari.” ");
INSERT INTO cpy_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Iroka kyaariperori inampiite jeekatsiri Sinar-ki, ri ipinkathariwentantziri Nimrod: Babel, Erec, Acad, Calne. ");
INSERT INTO cpy_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ari ipoñaakawori Sinar-ki ashitawori inampipaeni: Nínive, Rejobot, Cala, ");
INSERT INTO cpy_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","rijatzi ashitawori kyaariperori nampitsi iitachari Resén. Iroka nampitsi Resén rootaki jatekachari ojeekira nampitsi Nínive eejatzi Cala. ");
INSERT INTO cpy_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Riitaki Mizraem tomintanakariri Ludim, Anamin, Lejabim, Naftujim, ");
INSERT INTO cpy_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Caslujim, Caftorim, ri isheninkapaeni Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Riitaki Canaán tomintanakariri Sidón rantarite itomi, eejatzi Het. ");
INSERT INTO cpy_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Rijatzi isheninkapaeni Canaán irika: Jebus-jatzi, Amor-jatzi, Herhes-jatzi, ");
INSERT INTO cpy_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Jev-jatzi, Arac-jatzi, Sin-jatzi, ");
INSERT INTO cpy_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad-jatzi, Zemar-jatzi, Hamat-jatzi. Riitaki icharinipaeni irika Canaán ikaatzi pookayitaatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Riitaki thonkakirori inampitawo Gerar-ki, ipoñaanakawo nampitsiki Sidón roojatzi Gaza-ki. Ithonka inampitakawo nampitsiki Sodoma, Gomorra, Adma, Zeboem, roojatzi Lasa-ki. ");
INSERT INTO cpy_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Riitaki irikapaeni icharinitakari Cam, rijatzi nampitanakawori jemperikapaeni. Tzimayitanaki irikapaeni inampiite, eejatzi iñaanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ikanta Sem rantarite Jafet, tzimaki icharini rirori iiteetakiri Heber. Riitaki Heber oshekitaneentsiri ikaatzi ichariniyitanakari Sem. ");
INSERT INTO cpy_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Riitaki Sem tomintanakariri Elam, Asur, Arfaxad, Lud eejatzi Aram. ");
INSERT INTO cpy_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Riitaki Aram tomintanakariri Uz, Jul, Heter, Mas. ");
INSERT INTO cpy_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Riitaki Arfaxad tomintanakariri Sala. Eejatzi Sala riitaki tomintanakariri Heber. ");
INSERT INTO cpy_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ikanta Heber tzimanaki apite itomipaeni: etakawori iita Peleh, aripaete ipookanaki atziri iipatsiteki. Riima itsipa itomi iita Joctán. ");
INSERT INTO cpy_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Riitaki Joctán tomintanakariri Almodad, Selef, Jazar-mavet, Jera, ");
INSERT INTO cpy_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO cpy_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO cpy_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Javila, Job-ab. Maawoeni irikaete riitaki itomiite Joctán. ");
INSERT INTO cpy_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ithonka inampitakawo janta Mesa-ki roojatzi Sefar-ki jeekatsiri ochempimashiki ishitowapiintzira ooryaatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Riitaki irikapaeni icharinitakari Sem, rijatzi nampitakawori jemperikapaeni. Tzimayitanaki irikapaeni inampiite, eejatzi iñaanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Riitaki irikapaeni icharinitanakari itomipaeni Noé. Tema awijanakira paerani oonkawo, ari ithonkari ipaashiniyitanaki irikapaeni, rinashiyitaanaka inampiteeyawowa jemperikapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Paerani apaani okanta ñaantsi iñaawaeteetziri kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikanta rowahanaka atziripaeni inampityaawo ishitowapiintzira ooryaa, areetaka janta iiteetziri Sinar, iñaapaakiro owintenipathatzi kepatsi, ari inampitapaakawo. ");
INSERT INTO cpy_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ari ikantawakahaeyakani atziripaenni: “Jame owetsikaeyeni kepatsipatha atayimaetyaawo.” Arira retanteetanakawo rotantoteetawo kepatsipatha, tee apatziro rotantoteetawo mapi. Retanteetanakawo eejatzi otsirekanteetawo tsirepathari, tee apatziro rahaetziro otsirekanteetari paerani. ");
INSERT INTO cpy_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ari ikantawakahaeyakani eejatzi: “Pipokaeyeni, jame owetsike anampi, owetsiki eejatzi antawo ateementotsi areetachani jenokinta. Jame anampiteeyaawo kameetha eero añaantawo akinakinawaetee jemperikapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Riitaki kantacha pokaki Tajorentsi raminero nampitsi eejatzi ateementotsi rowetsikakiri atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ikantashiretanaki Tajorentsi: “Apaani okanta inampiite, apaani okanta iñaani eejatzi, okaate ikenkithashireteeyaari rantero, ari imatakiro. ");
INSERT INTO cpy_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Nimaeka nowashiñaapithateri iñaanipaeni, eero ikemathatawakaanta iñaanatawakaeya.” ");
INSERT INTO cpy_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ari ipakaakaakiri Tajorentsi rowetsikawitakawowa antawo inampi, ipookayiteero ikinayiteero jemperikapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ikompitakaayitakari iñaanipaeni eejatzi, opoñaantyaari eero ikemathatawakaanta. Jatayitanaki inampiteeyaawo jemperikapaeni. Rootaki iitanteetakawori Babel iroka antawo nampitsi rowetsikakiri atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Irika icharinipaeni Sem. Tema awijaki apite ojarentsi oonkantakari paerani, tzimaki Sem okaatzi 100 rojarentsite, tzimaki itomi Arfaxad. ");
INSERT INTO cpy_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ojamani rañaaki Sem okaatzi 500 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ari tzimaki Arfaxad okaatzi 35 rojarentsite, ari itzimaki itomi iitakiri Sala. ");
INSERT INTO cpy_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Ojamani rañaaki Arfaxad okaatzi 403 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ari tzimaki Sala okaatzi 30 rojarentsite, roojatzi itzimantaka itomi iitakiri Heber. ");
INSERT INTO cpy_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ojamani rañaaki Sala okaatzi 403 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ari tzimaki Heber okaatzi 34 rojarentsite, roojatzi itzimantakari itomi iitakiri Peleh. ");
INSERT INTO cpy_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Ojamani rañaaki Heber okaatzi 430 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Ari tzimaki Peleh okaatzi 30 rojarentsite, roojatzi itzimantakari itomi iitakiri Reu. ");
INSERT INTO cpy_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Ojamani rañaaki Peleh okaatzi 209 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Ari tzimaki Reu okaatzi 32 rojarentsite, roojatzi itzimantakari itomi iitakiri Seruh. ");
INSERT INTO cpy_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Ojamani rañaaki Reu okaatzi 207 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ari tzimaki Seruh okaatzi 30 rojarentsite, roojatzi itzimantakari itomi iitakiri Nacor. ");
INSERT INTO cpy_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Ojamani rañaaki Seruh okaatzi 200 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ari tzimaki Nacor okaatzi 29 rojarentsite, roojatzi itzimantakari itomi iitakiri Taré. ");
INSERT INTO cpy_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Ojamani rañaaki Nacor okaatzi 119 ojarentsi. Osheki itomi eejatzi rishintopaeni tzimaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ari tzimaki Taré okaatzi 70 rojarentsite, roojatzi itzimantakari itomipaeni iitakiri Abram, Nacor, Harán. ");
INSERT INTO cpy_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Irika isheninkapaeni Taré. Irika Taré riitaki tomintanakariri Abram, Nacor, Harán. Irika Harán riitaki tomintanakariri Lot. ");
INSERT INTO cpy_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Irika Harán riitaki etakawo ikamae janta Ur-ki iipatsiteki Caldi-ite, tekiraha ikamiita Taré ashitariri. Ikamaki itzimakira paerani. ");
INSERT INTO cpy_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ikanta Abram iinantakawo Sarai. Riima Nacor iinantakawo rirori Mil-ca, rishinto Harán. Iroka Mil-ca roo irento Isca. ");
INSERT INTO cpy_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Teemaeta itzimi eentsite Sarai, amashithakiwaetatya roori. ");
INSERT INTO cpy_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ari riyaataki Taré janta Canaán-ki rookanakiro Ur iipatsiteki Caldi-ite. Ari raanakiri itomi Abram itsipataaneeri Sarai raniro, raanaeeri eejatzi Lot icharini. Ikanta rareetawo Harán-ki, ari inampitapaawori. ");
INSERT INTO cpy_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ojamani rañaaki Taré okaatzi 205 ojarentsi, ari ikamaeri rirori janta Harán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ikanta Tajorentsi iñaanatakiri Abram, ikantakiri: “Eenitatsi otsipa kepatsi noñahakimiri, piyaate janta, pookaneeri pisheninkapaeni eejatzi piipatsite. ");
INSERT INTO cpy_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ri noshekyahaeri picharinipaeni. Ari notajonkawentakimi eeroka, riroperori nokantakahaemi. Eeroka kantakaeyaawoni notajonkawentantyaariri itsipajatzipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ari notajonkawenteeri ikaatzi tajonkawentakimini eeroka. Ari niyakateeri naaka ikaatzi iyakatemini eeroka. Tema eeroka kantakaeyaawoni notajonkawentanteeyaariri maawoeni inashiyitachari sheninkatawakaeyitachari jaka kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tzimaki Abram okaatzi 75 rojarentsite. Jataki Canaán-ki rookotakinirira Tajorentsi, rookaneero Harán inampiwitawowa. ");
INSERT INTO cpy_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Itsipatanaawo iina Sarai, eejatzi Lot itominthori. Ithonkakiro raaneero tzimimoyitziriri, raaneeri maawoeni ratzirite ramanantakiri Harán-ki. Iroka okanta rareetantakari Abram Canaán-ki, ");
INSERT INTO cpy_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ithonkakiro ranashitakawo iroka kepatsi, roojatzi rareetantakari Siquem-ki ojeekira inchato iiteetziri More. Rootaki inampiite Canaán-jatzi janta. ");
INSERT INTO cpy_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Ari roñaahakariri Tajorentsi, ikantakiri: “Roo noperiri iroka kepatsi ikaate picharinityaari.” Rowetsike taapokimentotsi jempe roñaahakari Tajorentsi, ipinkathatantyaariri. ");
INSERT INTO cpy_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ikanta ikinanee ochempimashiki okaakitapaera Betel ikyaapiintzira ooryaa. Ari rowatzikapaero ipankothaante. Imontetapaakawo Betel ikyaapiintzira ooryaa, rooma nampitsi Jae ojeeki ishitowapiintzira ooryaa. Ari rowetsikapaeri otsipa taapokimentotsi, raakotapaero iwaero Tajorentsi iñaapinkathatapakiri. ");
INSERT INTO cpy_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Eekiro ranashitanakitya, riyaatziro kirinkanta Nehuev-ki. ");
INSERT INTO cpy_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Okanta paerani iñahaetakiro antawo tashetsi. Rootakira riyaatantakari Abram ijeekawaete Egipto-ki tema tekatsi rowaeyaari inampiki. ");
INSERT INTO cpy_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ikanta rareetzimataka Abram janta Egipto-ki, ikantakiro iina Sarai: “Noená, pikemina, maperori pikameethaanikitaki eeroka. ");
INSERT INTO cpy_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Arika iñaawakimi Egipto-jatzi, ikanteeyeni: ‘Iroka tsinani iina ini irika atziri.’ Rootaki opoñaantyaari rompojina, eero rompojimaetzimi eeroka tema ikowatye rayimi. ");
INSERT INTO cpy_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Pikanteri eeroka: ‘Aari rini’, rootaki opoñaantyaari eero rompojanteetana naaka.” ");
INSERT INTO cpy_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ikanta rareetaka Abram janta Egipto-ki, iñaawakiro Egipto-jatzi kameethaanikiri okantaka Sarai. ");
INSERT INTO cpy_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Iñaawakiro reewarite. Riyaatashiitakiri Faraón iwinkatharite Egipto-jatzi, ikamantakiri kameethaanikiri okantaka tsinani. Roojatzi rahaetantanakawo Sarai iwinkatharipankoteki Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Okantakaantziro okameethaanikitzira Sarai, raakameethatawakiri Faraón irika Abram. Ipashitakari osheki oveja, vaca-paeni, ratziriteepaeni, kawayopaeni eejatzi camello-paeni. ");
INSERT INTO cpy_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Okantakaanta Sarai, rowajankitantakari Tajorentsi mantsiyarentsi irika Faraón, itsipataakiri isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Roojatzi ikaemakaantantakariri Faraón irika Abram, ikantakiri: “¿Iitaka pomanakotantawori iroka? ¿Iitaka kaari pikamantantana piinaha iroka tsinani? ");
INSERT INTO cpy_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pikantakina: ‘Choeni ini.’ Naaka matajantachanimi ari noenantakyaawomi. Iroka nimaeka piina, paanaero.” ");
INSERT INTO cpy_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ikanta Faraón, ikantakiri ratzirite roemishitowaeri Abram raaneeroota iina, raaneero eejatzi okaatzi tzimimotziriri. ");
INSERT INTO cpy_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ikanta ipiyaanawo Abram janta Nehuev-ki itsipatanaawo iina ipoñanaawo Egipto-ki, ramaero maawoeni tzimimotziriri. Ari itsipataari itominthori Lot. ");
INSERT INTO cpy_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ashaahantaa Abram, ishekitzimotakiri ooro, koriki, osheki ipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ikanta rawijee ipoñaanaawowa Nehuev-ki, roojatzi rareetantaari Betel-ki. Ikanta rawijanee roojatzi niyankithakineki awotsi rareetantyaari nampitsiki Jae, rowetsikapaero ipankothaante jempe retakawo paerani ipankota, ");
INSERT INTO cpy_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","jempe rowetsikaki paerani taapokimentotsi, raakotantakawori iwaero Tajorentsi ipinkathatziri. ");
INSERT INTO cpy_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ari ikantakari eejatzi Lot, ishekitzimotakiri rovejate, ivacate, ratzirite, ikaatzi tsipatariri rirori. ");
INSERT INTO cpy_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Okanta janta jempe inampitaawo, opomeentsitzimotakari itsipatawakahaeya, tee riyomaatawo rowanawo ipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ikaatzi kempoyeeriri ipirapaeni Abram rantzitakiri rashi Lot. Ari ijeekitari eejatzi Canaán-jatzipaeni eejatzi Ferez-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Roo ikenkithawaetakaantakariri Abram itominthori Lot, ikantakiri: “Asheninkaha owawakaeyaani aaka, tee okameethate antaminthatawakaeya, tee omatzita eejatzi rantaminthatawakaeya kempoyeeriri apirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Iroka antawoete kepatsi, pamine jempe pinampityaawo. Arika pikinanaki kirinkanta, nokinanaki naaka katonkonta. Rooma pikinanakirika katonkonta, nokinanaki naaka kirinkanta.” ");
INSERT INTO cpy_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Raminakiro Lot othapya Jordán, jempe ojeeki nampichaniki iitachari Zoar, iñaatziiro kameethari okantaka, tzimatsi osheki nija. Ariwaetaki Egipto. (Roperori okantawita tekira ithonkaeroota Tajorentsí iroka Sodoma eejatzi Gomorra.) ");
INSERT INTO cpy_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Rookotakiro Lot inampityaawo ishitowapiintzira ooryaa Jordán-cheraki. Ari rotsiparyahaari Abram irika Lot. ");
INSERT INTO cpy_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Roojatzi ijeekanaki rirori Abram Canaán-ki, jataki Lot inampityaawo ojeekira nampitsipaeni, okaakitapaera nampitsi Sodoma. ");
INSERT INTO cpy_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ari ipiyotapaari atziri antayitzirori kaariperori kaari iñaamata Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ikanta riyaataki Lot, ikantakiri Tajorentsi irika Abram: “Pamine katonko, kirinka, ishitowapiintzira ooryaa eejatzi jempe ikyaapiintzi. ");
INSERT INTO cpy_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ari nopakimiro maawoeni kepatsi okaatzi piñaakiri, okanteetatyeeyaani pashiteeyaawo, roojatzi rashiteeyaari ikaate pichariniteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ari noshekyahaeri roshiyeeyaawo impaneki. Tee riyoetero jempe okaatzi oshekitzi impaneki, ari roshiyeeyaari pichariniyiteeyaari eero riyoeteeri jemperika ikaate roshekite. ");
INSERT INTO cpy_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Pikatziyanaki, pithonkiro panashityaawo maawoeni kepatsi okaate nashitakahaemiri, tema naaka pimironi.” ");
INSERT INTO cpy_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ari okantakari, roo riyaatantakari Abram inampiteeyaawo inchatomashiki. Riitaki ashitawo atziri iitachari Mamre. Ari ekaatapaeri nampitsi iiteetziri Jebrón. Rowetsikapae janta taapokimentotsi ipinkathatapaeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Okanta paerani janta Sinar-ki ipinkatharitzira Amrafel, riima Arioc ipinkatharitzi rirori Elasar-ki, Quedorlaomer ipinkatharitzi rirori Elam-ki, eejatzi Tidal ipinkatharitzi rirori Hoem-ki. ");
INSERT INTO cpy_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kameethari raapatziyawaka irikapaeni pinkathari rowayiriminthatari Bera pinkatharitatsiri Sodoma-ki, Birsa pinkatharitatsiri Gomorra-ki, Sinab pinkatharitatsiri Adma-ki, Sem-eber pinkatharitatsiri Zeboem-ki, eejatzi pinkatharitatsiri Bela-ki iitziteetari Zoar. ");
INSERT INTO cpy_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ikanta irikapaeni 5 pinkathari rowayirimintheetakiri, raapatziyawakaaka rirori ipiyotakiri rowayirite janta Sidin-ki ojeekira inkaari Katyaari. ");
INSERT INTO cpy_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tema tzimakotaki okaatzi 12 ojarentsi irikapaeni 5 pinkathari romperawaetakari pinkathari Quedorlaomer, roo 13-tapaentsiri ojarentsi ikenkithashireteeyakani ipiyatyaari rowayiriteri. ");
INSERT INTO cpy_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Okanta ojarentsi 14-tapaentsiri, irika pinkathari Quedorlaomer itsipatakari itsipa pinkathariite ikaatzi aapatziyakariri riyaateeyakini Astawot Karnaem, ari ithonkakiri rowayiritari Refa-ite. Ari ikantanakiri eejatzi Zuzi-ite janta Jam-ki, imatanakiri eejatzi Emiite janta Save-quiriataem-ki. ");
INSERT INTO cpy_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Imatzitanakari Jori-ite janta tonkaariki Seir-ki, ipatzimatanakiri roojatzi Parán-ki tsipanampitawori tonkaari. ");
INSERT INTO cpy_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ikanta ipiyaawo Quedorlaomer itsipataari pinkathariite aapatziyariri, rareeteeyaani En-mispat-ki iiteetziri eejatzi Cades. Ithonkatanakiri maawoeni iñaanakiri janta iipatsiteki Amalek-iite, ari ikantanakiriri eejatzi Amor-jatzi nampitawori janta Jazezon-tamar-ki. ");
INSERT INTO cpy_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Ikanta pinkatharitatsiri Sodoma-ki, Gomorra-ki, Adma-ki, Zeboem-ki, Bela-ki (iiteetziri eejatzi Zoar,) riyaateeyakini roma-natya Sidim-ki. ");
INSERT INTO cpy_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Irikapaeni 5 pinkathari, rowayiritakari itsipa 4 pinkathariite: Quedorlaomer pinkatharitatsiri Elam-ki, Tzidal pinkatharitatsiri Hoem-ki, Amrafel pinkatharitatsiri Sinar-ki, Arioc pinkatharitatsiri Elasar-ki. ");
INSERT INTO cpy_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Tema janta Sidim-ki tzimatsi pitsitharipatha. Ikanta pinkatharitatsiri Sodoma-ki eejatzi Gomorra-ki ikowaki ishiyapithatero awijaentsiri, ithonkari ipiinkantakari pitsitharipatha, ithonkaka ikamaki. Riima itsipa pinkathariite, ishiyeeyanakani tonkaariki. ");
INSERT INTO cpy_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Ikanta pinkathariite thonkaantetsiri, rayitanakiri maawoeni rowanawo, rayitzitanakiri eejatzi rashaahawo pinaperoyitachari okaatzi tzimatsiri janta Sodoma-ki eejatzi Gomorra-ki. Jateeyeeni. ");
INSERT INTO cpy_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Janta Sodoma-ki, ari inampitawori Lot itominthori Abram. Rahaetanakiri rirori itsipatahaetanakiri rashaahawo. ");
INSERT INTO cpy_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Eenitatsi apaani atziri shiyanaenchari, ikamantakiri Abram irika Heber-ite. Ari inampitawo Abram rinchatomashiteki Mamre. Irika Mamre riitaki Amor-jatzi, rirentzi Escol eejatzi Aner, riiyitaki aapatziyariri Abram. ");
INSERT INTO cpy_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ikanta ikemawaki Abram rahaetakiri itominthori, riyoyaaki itomi ronampiripaeni rawentaaperotari, ikaateeyini 318 ipiyotaka. Royaatzishitanakiri pinkathariite roojatzi janta nampitsiki Dan. ");
INSERT INTO cpy_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Roma-pokakiri tsireniriki Abram rowayiritari pinkathariite itsipatakari ratzirite, ipatzimatanakiri roojatzi Job-a-ki jeekatsiri katonkonta nampitsiki Damasco. ");
INSERT INTO cpy_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ari raapithatawaeri maawoeni owaahawontsi raayiwitanakari. Ari rokakaawentawaeri eejatzi itomithori Lot, raawaero eejatzi maawoeni rashitari. Rokakaawentawaero tsinanipaeni, eejatzi osheki itsipa atziripaeni raawiitakari. ");
INSERT INTO cpy_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ikanta Abram, piyaawo ithonkatawakirira Quedorlaomer itsipataari pinkathariite ikaatzi aapatziyakariri. Ari riyaataki pinkatharitatsiri Sodoma-ki itonkyotawaari janta Save-ki, tema ikanteetziri Save rootaki “Pinkatharyaarini”. ");
INSERT INTO cpy_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ari riyaatzitanaka Melquisedec pinkatharitatsiri Salem-ki, riitaki romperatajorentsite Jenokijatzi Tajorentsi, raanaki pan itsipataanakiro rireetziri. ");
INSERT INTO cpy_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ramanakowentawaari Abram, ikantanaki: “Itajonkawentemi Jenokijatzi Tajorentsi, Owetsikakirori inkite eejatzi kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kimoshirewentaarewo rini Jenokijatzi Tajorentsi, Riitaki kantakaakawori poetsinampaantakariri omanayitzimiri.” Ipakiri Abram irika Melquisedec eepichokiini raapithatantawaeri roma-nayitakaha. ");
INSERT INTO cpy_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ikanta pinkatharitatsiri Sodoma-ki ikantakiri Abram: “Pipenari atziripaeni, payero eeroka ashaahawontsi.” ");
INSERT INTO cpy_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Rakanaki Abram, ikantanakiri: “Tema naakotakiro iwaero Tajorentsi, Jenokijatzi owetsikakirori jenokinta eejatzi kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Eerowa nayi apaani pashitari eeroka, eero naajeetzi oeta noojotantyaariri no-zapato-te. Teera nokoyi pikantena paata, pikante: “Irika Abram nashaahantakaakari.” ");
INSERT INTO cpy_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tekatsi nokoyi naaka, apatziro nayiro okaatzi rowayitakari nomperatane. Riima tsipatakinari Aner, Escol, Mamre, raayitaki rirori.” ");
INSERT INTO cpy_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ari iñaanateeri Tajorentsi imishiriki Abram, ikanteeri: “Eero pithaawawaetzi Abram, naakataki kempoyaawentemini. Osheki nopinateemi.” ");
INSERT INTO cpy_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Rakanaki Abram, ikantanaki: “¡Tajorentsi! Piyotzi eeroka tekatsi notyomipaeni. ¿Iitaka pipinatantenari. Riitaki Eliezer nonampiri Damasco-jatzi ashiteeyaawoni maawoeni tzimimotanari.” ");
INSERT INTO cpy_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ikantzi eejatzi: “Tee pikowakaana itzime notyomintyaari, irika Eliezer nomperatani, riitaki ashiteeyaawoni tzimimotanari.” ");
INSERT INTO cpy_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Rakanakiri Tajorentsí, ikantziri: “Riitaki pitomipaeni eeroka ashiteeyaawoni maawoeni tzimimotanari, kaarira itsipajatzi ashiteeyaawoni.” ");
INSERT INTO cpy_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Ikanta Tajorentsi romishitowakiri Abram jakakiroki, ikantziri: “Paminero jenokinta, piyoteri jempe ikaatzi roshekitzi ompokiro. Ari ikanteeyaa pichariniteeyari roshekitee rirori, roshiyeeyaari roshekitzi ompokiropaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Rawentaakari Abram Tajorentsi. Roowa ipoñaantari Tajorentsi raakameethatziri Abram, iitakiri tampatzikashireri. ");
INSERT INTO cpy_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ikantakiri: “Naakataki Tajorentsi, naaka amaemiri jaka pinampitawowa paerani Ur-ki iipatsiteki Caldi-ite, nopashiteemiro iroka kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Rakanaki Abram, ikantanakiri: “¡Tajorentsi! ¿Jempe okantyaaka niyotantyaari naaka ashitaawori iroka kepatsi?” ");
INSERT INTO cpy_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ikantanaki Tajorentsi: “Pamakina ewankari pipira tzimaentsiri mawa rojarentsite: vaca, cabra, oveja. Pamakina konthawo, eejatzi iryaani shiro. ");
INSERT INTO cpy_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ari ikantakiro Abram, ramakiniri ipirapaeni, itankakiri, rowayitakiri imontekoyitakiri. Teera itankaeteri shiwankiripaeni rirori. ");
INSERT INTO cpy_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Pokapaaki amemporipaeni ikemaenkatakiri. Jeekaki rirori Abram romishiyiri kemaenkatakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Okanta otsireniityaanaki, ayitzimotakiri Abram antawoete iwochokini, maanaki. Ari omapokanaka otsirenikakitanaki. Antawo ithaawanaki. ");
INSERT INTO cpy_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ikantakiri Tajorentsi: “Abram, otzimatye piyotero iroka, rahaeteri picharinipaeni otsipaki kepatsi, okaate 400 ojarentsi ijeeke. Ari romperawaeteetyaari, ishintsiwenteeteri, rantawaetakahaeteri. ");
INSERT INTO cpy_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ari nowajankitzimaetakyaari naaka omperanawaetakariri. Arika okaatapaaki, aritaki ishitowae, oshekitzimotakiri osheki rashaahawo. ");
INSERT INTO cpy_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Tekatsitzimaeta awijimotemini eeroka, apatziro pikamae aririka pantarikitapaaki, pitsipateeyaari piwaejatziiteni. ");
INSERT INTO cpy_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Arika ojamanitaki paata, ari ipiyee itomi pichariniite jaka, tekira omonkaatapaakaata iyaariperonka Amor-jatziite.” ");
INSERT INTO cpy_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Okanta otsirenitanaki, tee okoñaatane ramine. Iñaaki Abram paamari antawoete okachaataki, oshiyawityawomi omorekantatyeeyaarimi kaminkari tsimeri itankaetakiri. ");
INSERT INTO cpy_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Aripaete ikenkithawaetakaakiri Tajorentsi Abram, ikantakiri: “Nashitakaeyaari picharinipaeni iroka kepatsi, etanakyaawo antawaaki nija Egipto-ki, roojatzi antawaaki nija Eufrates, rootaki aapatziyawakaanteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Aakotawakiroota iipatsite Cin-ite, Cenez-iite, Cadmon-jatziite, ");
INSERT INTO cpy_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Het-ite, Ferez-ite, Refa-ite, ");
INSERT INTO cpy_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor-ite, Canaán-ite, Gerges-iite, Jebus-iite eejatzi.” ");
INSERT INTO cpy_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tee okanta Sarai itzimakayiro oemi Abram, tzimimaetacha omperatane oeta Agar, Egipto-jato ini. ");
INSERT INTO cpy_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Okantakiri Abram: “¡Pikemaki! Tee ikowakayina Tajorentsi itzimi, nokoyimaetaka pitsipatyaawo onampiri Agar, pitzimakayiro, riitaki noshiyakayeri notyomipaeni naaka.” Inimotakiri Abram okantakiriri iina Sarai. ");
INSERT INTO cpy_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Aakiro Sarai onampiri Egipto-jato, opakiri Abram iinantyaawo. Tzimaki 10 ojarentsi inampitakawo Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ikanta itsitakawo Abram ronampiri Agar, rowakakiro. Okanta oñaaka Agar omotzitaki, okijaneentanakiro Sarai. ");
INSERT INTO cpy_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Okantakiri Sarai oemi Abram: “Eeroka kantakaantakirori okijaneetantanari Agar. Naakawitaka pakimirori piinantyaawo, oñaakaha omotzitaki, okowanaki awijena oñaaperotya. Tema Riitaki Tajorentsi yotziro iitarika kantakaantzirori naakarika, aama eerokarika.” ");
INSERT INTO cpy_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Rakanakiro Abram iina, ikantanakiro: “¡Pikemina! Ponampirira ini iroka tsinani, eerokataki yoteroni jemperika pikantero.” Roojatsi okijantanaakawo onampiri, roojatzi oshiyantakari Agar. ");
INSERT INTO cpy_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Iñiimaetakawo ronampiri Tajorentsi ochempimashiki, ojeekashitziro nijaateni jeekatsiri awotsiki riyaatantetari nampitsiki Shur. ");
INSERT INTO cpy_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Rojampitakiro, ikantziro: “¿Jempe pikinapaakika omperatane Sarai? ¿Jempe piyaateka?” Ari akanakiri roori, okantanakiri: “Noshiyapithatatyaawo Sarai omperatanari.” ");
INSERT INTO cpy_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ikantanakiro ronampiri Tajorentsi: “¡Agar! Pipiyee opankoki omperatzimiri, panteniro okaate omperatemiri.” ");
INSERT INTO cpy_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Eekiro ikantanakitziiro ronampiri Tajorentsi: “Noshekyaaperoteemiri pijariteeyaari, Tekatsi yoteerini jempe ikaate tzimatsini, ishekiperotaatyeera. ");
INSERT INTO cpy_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Tema motzitakimi nimaeka, itzimae apaani pitomi, Riitaki piiteri Ismael. Tema iñaakimi Tajorentsi pashironkawaetaka. ");
INSERT INTO cpy_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Roshiyari pitomi kawayoniro, mashireyantzi ikantya. Rantamintheteeri maawoeni atziri, ari ikantzityaari maawoeni atziripaeni rantamintheteeri rirori. Kijokiro rowaero inampi, okantawitya eero inimotziri isheninkapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Okanta okenkithawaetakaakiri Agar irika Tajorentsi, oeteeri: “Tajorentsi Ñaantatsiri,” tema okantakitzi roori: “Iñaana Tajorentsi, eeniro nañiira.” ");
INSERT INTO cpy_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Rootaki iitanteetakawori iroka nijateni: “Inijaate Añaaniri Ñaakinari.” Tema iroka nijateni ojeeki niyankithakineki awotsi kinachari janta nampitsiki Cades roojatzi Berea-ki. ");
INSERT INTO cpy_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Okanta Agar, tzimaki itomi Abram, oetakiri Ismael. ");
INSERT INTO cpy_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Tzimimaetaka Abram okaatzi 86 rojarentsite, ari itzimakiri Ismael. ");
INSERT INTO cpy_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tzimaki Abram okaatzi 99 rojarentsite, ari iñaahaeri Tajorentsi, ikantakiri: “Pijeekimotena kameetha eeniro pañiika eero otzimawaetzi kaariperori pantzimotanteri, tema naakataki Tajorentsi Shintsiperori. ");
INSERT INTO cpy_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Eenitatsi aapatziyawakahaeyaari. Ari nomaperotakiro noshekeemiri picharinipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ari rotziwerowanakari Abram, oeyotanaka kepatsiki ikenkithawaetzira Tajorentsi, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Iroka nantzimotemiri. Oshekiperori ikanteeyaa pichariniite, rinashiteeya ipiyoteeya ikaate sheninkatawakahaachani, oshiyakahaemimi eerokami ipaapateteeya. ");
INSERT INTO cpy_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Rootaki piitanteeyaari nimaeka Abraham, eero piitaawo Abram, tema oshekiperori ikanteeya pichariniite rinashiteeyaawo ipiyoteeya ikaatzira isheninkatawakahaeyaani, oshiyakahaemimi eerokami ipaapateteeya. ");
INSERT INTO cpy_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Osheki ikaatee pichariniteeyaari, eenitatsi pinkatharitaatsini, rinashiteeyaawo ipiyoteeya ikaatzira isheninkatawakahaeya. ");
INSERT INTO cpy_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Iroka nokashiyaakaemiri eeroka nimaeka, rootaki nokashiyaakahaeriri eejatzi paata pichariniite, naakatapiintaki Pitajorentsiteteeya, naakatzitaka Itajorentsiteteeya eejatzi pichariniite. ");
INSERT INTO cpy_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Nopaemiro maawoeni kepatsi jeekatsiri Canaán-ki pijeekakira nimaeka, ari pinampiteeyaawo. Eerokataki ashiteeyaawoni, roojatzi rashiteeyaari pichariniite. Rashi rowatyeero rashiteeyaawo, naakataki Itajorentsiteteeya.” ");
INSERT INTO cpy_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Eekiro ikenkithawaetatzi Tajorentsi ikantziri Abraham: “Pimonkaatenawo aapatziyawakaanteeyaari, eejatzi ikantziteeya pichariniite. ");
INSERT INTO cpy_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Iroka otsipa aapatziyawakaanteeyaari, otzimatye ithotyeenawo pichariniite imonkaateero. Maawoeni shirampariite itochonkyaaniteeya. ");
INSERT INTO cpy_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Pitoyiteero eerokaete opatzithowaki pishiramparitantari. Roo riyotanteetyaari eenitatsi aapatziyaawakaari aakaete. ");
INSERT INTO cpy_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Nimaeka etanakyaawo iitochonkyaaniteeya peenchaanikite tzimakoteentsiri 8 kitejeri. Ari ikanteeteri eejatzi otomipaeni pomperatane owakira tzimatsiri, ari pikanteri pomperatane owakira pamanantayitziri kaari pihekinkata. ");
INSERT INTO cpy_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Otzimatye itochonkyaaniteeya apiteroeni: eenchaaniite pomperatane, eenchaaniite eejatzi pamanantane. Roo iñahaetantyaawori piwathaki okaatzi aapatziyawakaeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Riima pisheninkapaeni kaari totachonkyaanikitaachani, otzimatye romishitowaeteri eero pitsipataari pinampiki, okantakaantziro tee rantziro aapatziyaawakaari.” ");
INSERT INTO cpy_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Ikanteeri Tajorentsi eejatzi Abraham: “Nimaeka oeteeya piina Sara, eero oetaa Sarai. ");
INSERT INTO cpy_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Antawoete notajonkawentero, ari notzimakayiro roori itzimae entsite. Maperori notajonkawenteero. Osheki ikaatee ojariteeyaari, eenitatsi pinkatharitaatsini. Tema oshekiperori ikanteeya ojaripaeni rinashiteeyaawo ipiyoteeya ikaatzira isheninkatawakaa, ikimitakaanteero roomi rinironteeya.” ");
INSERT INTO cpy_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Rotziwerowanaa Abraham, oeyootanaa kepatsiki, ishirontashireta ikantzi: “¿Arima rowakantee atziri antarikiteentsiri tzimaentsiri 100 rojarentsite? ¿Arima omateeya eejatzi otzimae Sara antawokitakira okaatakira 90 ojarentsite?” ");
INSERT INTO cpy_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Eekiro ikantatzi Abraham, ikantzi: “Okamintha inintahaeyaawo Ismael okaatzi pitajonkawentakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ikantanaki Tajorentsi: “Nokantatziimi naaka arira otzimae piina Sara itzime pitomi, riitaki piiteri Isaac. Riitaki maperoteeroni aapatziyawakaane, eero nopakaakahaeri ichariniite rirori. ");
INSERT INTO cpy_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Nokemaki jempe ikantakota Ismael, aritaki notajonkawentakimiri. Ari noshekyahaeniri icharini rirori. Riitaki ipaapateteeya 12 riroperori jewayiitatsini, naaka kantakahaeyaawoni iriroperotanteeyaari ichariniite, kameethari raapatziyawakaeya. ");
INSERT INTO cpy_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Rootaki itzimantyaari Isaac, yotapaaka apaani ojarentsi otzimanitantyaari Sara, riitaki noejokirotakahaeyaari aapatziyawakaane. ");
INSERT INTO cpy_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ikanta ithonkanakiro Tajorentsi ikenkithawaetakaakiri Abraham, ipeyapithatanaari. ");
INSERT INTO cpy_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Tee rowawijaanaki Abraham apaani kitejeri, itochonkyaanikitakiri itomi Ismael. Ari ikantzitakari maawoeni itomipaeni shirampariyitatsiri, ari ikantzitakari eejatzi ramanantane romperatanepaeni jeekatsiri ipankoki. Rantakiro okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Tzimanaki Abraham okaatzi 99 rojarentsite itoteetakiniri opatzithowaki ishiramparitantari ");
INSERT INTO cpy_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Riima itomi Ismael tzimaki rirori okaatzi 13 rojarentsite, itotziteetantakariri opatzithowaki ishiramparitantari. ");
INSERT INTO cpy_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tee awiji apaani kitejeri itotantakawori Abram opatzithowaki ishiramparitantari, arira itsipatakari itomi Ismael. ");
INSERT INTO cpy_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ari itsipatzitakari eejatzi ramanantane romperatanepaeni ikaatzi jeekatsiri ipankoki kaari isheninkayita. ");
INSERT INTO cpy_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Ikanta ijeekawaetzi Abraham opatzimooki ipanko tampatzikapaeteki ooryaa, roñaahakaari Tajorentsi janta rinchatomashiteki Mamre. ");
INSERT INTO cpy_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ikanta raminaki Abraham iñaatziiri mawa atziri. Intsipaete ikatziyanaka itonkyotawakari, rotziwerowashitawakari, oeyootanaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ikantawakiri: “¡Nowinkatharite! Paata pawijita, ");
INSERT INTO cpy_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","namawakimiita eepichokiini nija pikewyaari pitziki, pijeeke otsimankakira inchato pimakoryaawaete. ");
INSERT INTO cpy_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Naakataki pomperatane, pareetakari ipankoki. Paata niyaatawakiita namine owanawontsi poyaari okine pishintsite aririka pawijanaki.” Ikanteeyini rirori: “Ariwé, kameethataki.” ");
INSERT INTO cpy_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kyaanaki Abraham inthomoeki ipankoki, ikantapaakirro Sara: “Intsipaete pamine roperori trigo-pane okaate mawa piyeekitero powapiintzirowa powetsikane pan.” ");
INSERT INTO cpy_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ari ramaki Abraham riroperori ewonkiri vaca. Ipakiri ronampiri, riitaki aminerini okine rojanteri rowantyaariri. ");
INSERT INTO cpy_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tee apatziro ewonkiri vaca ramaki Abraham, ramakiniri eejatzi itene vaca. Kimoshireri ikanta raminayitawakiniri rowanawo, ijeekaeyakini areetariri otsimankakira inchato. ");
INSERT INTO cpy_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ikanta ithonkakiro rowaeyakani, irikapaeni areetzinkari rojampitakiri Abraham, ikantziri: “¿Jempe piina Sara?” Ikantanaki Abraham: “Ojeeki inthomoeki.” ");
INSERT INTO cpy_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ikantanaki areetzinkari: “Arika nopiyee otsipaki ojarentsi ari noñaapaero Sara itzimae entsite.” Okemaki Sara ikenkithawaeteeyinira Abraham, ojeekaki ojanari opatzimooki opanko, itaapiikira oemi. ");
INSERT INTO cpy_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Antarikiteeyakini apitekiroeni Abraham eejatzi Sara. Kaatapaaki oñaawenta otsinanitantari. ");
INSERT INTO cpy_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Roo kaari aamawetantanakawo oshirontanaka, okantashiretanaki: “¿Jempe okineeka notzimae naaka, antarikiteeyakinani apiteekite?” ");
INSERT INTO cpy_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Rojampitanakiri Tajorentsi irika Abraham, ikantziri: “¿Iitaka oshirontantari Sara? ¿Tema okemijantzi arira otzimae okantawitaka antawokitaki? ");
INSERT INTO cpy_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Eenitatsima pomeentsitzimotyaarini Tajorentsi? Arika nopiyaki otsipaki ojarentsi nareetemi, ari noñaapaero Sara itzimae entsite.” ");
INSERT INTO cpy_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Okanta okemawaki Sara, antawoete othaawanaki, okowawitanaka othaenkero ikanteetakiri, okantanaki: “Tema tee noshironta.” Ari ikantanakiro Rirori: “Niyotaki naaka shirontakimi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ari ikatziyanaa areetzinkari, jatanee ikinaneero nampitsiki Sodoma. Ari royaatanakiri Abraham riwethatawaeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ari ikenkithashiretanakari Tajorentsi, ikantzi: “¿Nokamanterima Abraham okaate nanteri? ");
INSERT INTO cpy_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Tema riitaki oshekitaatsini icharini, shintsiri rinatye ikaate sheninkatawakahaachani. Riitaki nokashiyaakaakiri ikantakaanteero notajonkawentanteeyaariri maawoeni inashiyitachari isheninkatawakaaha kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Naaka yoyaakiri imatakaanteeyaariri itomipaeni imayiteero niyotaantakiri, eejatzi ikaatzi ichariniteeyaari. Rantateero maawoeni kameethatatsiri, okaatzi tampatzikatatsiri, roo opoñaantyaari nomatantyaawori naaka okaatzi nokashiyaakaakiriri.” ");
INSERT INTO cpy_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Roojatzi ikantantanakari Tajorentsi: “Irikapaeni Sodoma-jatzi eejatzi Gomorra-jatzi omaperotaka ikaariperotaki. ");
INSERT INTO cpy_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ari niyaateri nimaeka janta, naminero maperotachari iyaariperonka okaatzi ikanteetziri. Rootaki niyotantyaari.” ");
INSERT INTO cpy_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Awijanaki apite areetzinkari nampitsiki Sodoma, roojatzi ijeekanaki Abraham itsipatanakari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ari rontsirokapaakari okaakiini, ikantziri: “¿Arima pithonkatakiri kameethashireri jeekimotziriri kameetha inampiki? ");
INSERT INTO cpy_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Aamaashitya tzimatsi 50 kameethashireri janta nampitsiki. Ikaaterika 50 kameethashireri, ¿arima pithonkakiro nampitsi? ¿Eeroma pimatziro pipeyakoteri, ikaaterika ikateerika 50? ");
INSERT INTO cpy_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Tekatsira inimote pithonkeri kameethashireri ikantakaantzirowa kaariperoripaeni, kimiwaetaka arikami ikaate ikaariperowaete. Eero pantziro iroka. Tema eerokataki ipaapateete aminakotantaneri maawoeniki kepatsi. ¿Eeroma pantziro kamethatzimotantatsiri?” ");
INSERT INTO cpy_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ari rakanaki Tajorentsi ikantanaki: “Arika noñaaki janta Sodoma-ki ikaate 50 kameethashireri, aritaki nopeyakoteeri maawoeni nampitawori janta, okantawitaka ikaariperowiteeyakani.” ");
INSERT INTO cpy_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tekira inimotziriita Abraham, rapiitanakiri rojampitziri, ikantziri: “Pipeyakotawakina napiitemiro nojampitemi, tema Tajorentsi pini eeroka, atziri nini naaka. ");
INSERT INTO cpy_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Arika riyotapaakya 5 kameethashireri imonkaatantyaari 50 kameethashireri, ¿arima pithonkataakiri maawoeni atziripaeni nampitawori janta?” Ari ikantanaki Tajorentsi: “Arika noñaaki ikaate 45 kameethashireri, eerowa nothonkiro nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eekiro ikantatziri Abraham: “Arika ikaate 40 kameethashireri, ¿arima pithonkakiri maawoeni atziripaeni nampitawori?” Ikantzi Tajorentsi: “Arika noñaaki ikaate 40 kameethashireri, eero nothonkiro nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eekiro ikantatziri Abraham ikantakowentantzi, ikantzi: “Eenitatsi nokowakotemiri eero pijamana napiitemiro nokantakimiri. ¿Iitaka awijatsini aririka ikaate 30 kameethashireri?” Ari rapiitanakiro Tajorentsi ikantzi: “Arika noñaaki ikaate 30 eero nothonkiro nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eekiro rapiitatziiri Abraham ikantziri: “¡Pinkatharí! Osheeki nowomeenchaakimi nojampitzimi. ¿Iitaka awijatsini ikaaterika 20 kameethashireri?” Ari ikantanee Tajorentsi: “Arika ikaate 20 kameethashireri eero nothonkiro nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Eekiro ikantatziri Abraham, ikantziri: “Pikeme nokantemi Nowinkatharite, eerowa pikijana, ari noweyaantawaemi nojampitemi, eero napiitziro. ¿Iitaka awijatsini ikaaterika 10 kameethashireri?” Ari ikantanee Tajorentsi: “Arika noñaaki ikaate 10, eero nothonkiro nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ikanta ithonkanakiro Tajorentsi ikenkithawaetakaeri Abraham, jataanee. Piyaaja rirori Abraham ipankoki. ");
INSERT INTO cpy_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ari otsireniityaanaki, areeteeyakani Sodoma-ki apite ronampiri tajorentsi. Ijeekamintheetzi Lot ikyaapiinteetzira nampitsiki, ari ipiyotapiinteeyani atziripaeni. Ikanta iñaawakiri, ikatziyanaka itonkyotawakyaari, rotziwerowashitawakari ipinkathatawakiri, oeyootanaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Ikantawakiri: “¡Pinkathari! Nokowatzi pimaanaki nopankoki. Iroka nija piikewya piitziki. Arika okitejitamanee, ari pawije.” Ikanteeyini rirori: “Aritaki, nomaye jakakiroki.” ");
INSERT INTO cpy_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Eekiro ikantatziri Lot, roojatzi ikowantanakari areetzinkari royaatanakiri ipankoki. Ikanta rareetakaapaakari, rowetsikakaantapaaki Lot owanawontsipaeni, rowetsikakaantaki eejatzi panponka kaari rowaeteetzi shineyakaeroni, rowakaeyaariri areetzinkari. ");
INSERT INTO cpy_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tekira imahaeyiniita, ipokaeyapaakini osheki Sodoma-jatzi, itapotapaakiro pankotsi ijeekaeyakinira, ari ikateeyakini ewankaripaeni itsipatakari antaripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ikaemapaakiri Lot, ikantziri: “¿Jempe ijeekika areetapaenchari pipankoki otsirenitanakira? Pomishitoweri, nokowatzi noñaathatakayaari.” ");
INSERT INTO cpy_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Ari ishitowanaki Lot ikenkithawaetakakiri atziripaeni, rashitakoperotakiri areetachari. ");
INSERT INTO cpy_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Ikantziri: “Pikempoyahaeya atziripaeni, pantzimotantzirokari kaariperori. ");
INSERT INTO cpy_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Eenitatsi apite nishinto tekira iyotziryiita shirampari. Pikoyirika aritaki nomishitowakimiro, roori piñaathawaetyaari pantero pikoyiri eeroka. Teemaeta nokoyi pikoshekyaari areetanari nopankoki, nowaemakaantane rini.” ");
INSERT INTO cpy_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ikanteeyini kaariperotatsiri: “Apatziromi romperawaetakaemi itsipajatzi atziri oshiyimiri eeroka. Piteenki, eeroka nomaperote nimaeka nokoshekyaa.” Retanakari ikoshekanakari Lot. Ipokaeyapaakini okaakiini ipankoki ikoyi rotatsinkirimi jaawi. ");
INSERT INTO cpy_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ari rakotanaki areetzinkari, rakathateeri Lot romonkyahaeri ipankoki. Rashitanakiro. ");
INSERT INTO cpy_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Thonkatanaka mawoeni imawityaakitanaki ewankaripaeni eejatzi antaripaeni. Aakiri imakone ithotyaakotziro ashitawo pankotsi. ");
INSERT INTO cpy_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Ikantanaaki areetzinkari, ikantziri Lot: “¿Tzimatsima Itsipa pisheninka jaka? Paanakiri pitomipaeni, pishintopaeni, pitzineripaeni. Payitanakyaari eejatzi pikaateeyinira, pishitoye nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nothonkatyeerowa iroka nampitsi. Okimiwitakawo okaemakaematatyeemi iyaariperonka atziripaaeni nampitawori jaka. Rootaki rotyaantantakinari Tajorentsi nothonkero.” ");
INSERT INTO cpy_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Ari riyaatanaki Lot iñeeri itzineripaeni, ikaatzi okashiyaari rishintopaeni oemintyaari, ikantapaakiri: “Pishitoye pinampiki, ithonkatatyaarowa Tajorentsi.” Teemaeta ikemijanteeyeni itzineripaeni Lot, roshiyakaatzi rowashiyawaetashita. ");
INSERT INTO cpy_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Okanta okitejitzimataki, ikantanaeri ronampiri tajorentsiite irika Lot: “Terika pikoyi pikame nothonkatyeerowa iroka nampitsi, pishiyakaero piina pitsipataanakiro apite pishinto. Intsipaetera.” ");
INSERT INTO cpy_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Etsikiroeni ikantawaeta Lot tee ithakyaawaetzi, akotanaki ronampiri tajorentsiite rakathawakotanakiri, tema etakopero royiri Tajorentsi irika Lot. Ari ikantanakirori iina eejatzi rishintopaeni. Rookakiro ojanari nampitsiki, awijakotee atsipetyaawomi ithonkaetakirowa nampitsi. ");
INSERT INTO cpy_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ari ishitowanaki nampitsiki Lot, ikenkithawaetanaki itsipa ronampiri tajorentsi, ikantziri: “Pishiye, eero pijeekawaetzi niyanki awotsiki, pawijakoteeta. Eero paminapanaatzi pitaapiiki, apatziro powanakiro piyaatero tonkaariki.” ");
INSERT INTO cpy_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Ari rakanakiri Lot, ikantanakiri: “Eerowa omata nowinkatharite. ");
INSERT INTO cpy_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Osheki kameethari pantakinari, maperori pineshironkatakina powawijaakotaana. Eeromaeta okanta noshiye tonkaariki, aritaki nokamaki aririka areetawakina pithonkatatantyaawori nampitsi. ");
INSERT INTO cpy_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Eenitatsi jaka okaakiini oryaanini nampitsi. Arira nokinanaki. Pishinetena niyaate eero nokamanta. Tema oryaanini ini nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ikantanaki itsipa ronampiri tajorentsi: “Nokemakimi, aritaki nomatakiro pikowakotakinari. Eero nothonkiro ewonkiri nampitsi pikantakinari. ");
INSERT INTO cpy_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Piyaatanakiita nimaeka. Eero nothonkitawo nampitsi tekiraata pareetyaata jempe poshiretakawo.” Roojatzi iitanteetakawori nampitsi Zoar. ");
INSERT INTO cpy_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Okanta okitejitamanee, areetaka Lot janta Zoar-ki. ");
INSERT INTO cpy_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Rowaryaaki Tajorentsi paamari janta Sodoma-ki eejatzi Gomorra-ki. ");
INSERT INTO cpy_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Ithonkakiri jeekantawori nampitsi, ari ikantakiro maawoeni shookayitatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pokawitacha iina Lot, oyaatakiri oemi, aminamintheetzi otaapiiki, omapokashitanaka opeyanakawo tziwithantha. ");
INSERT INTO cpy_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Okanta okitejitamanee, ananenkamanaki Abraham janta ikenkithawaetakaakirira chapinki Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Raminapaaki jantó ojeekira nampitsi Sodoma, ojeekitaha eejatzi Gomorra, iñaatziiro okachaareenkataki, okimitakawo okachaatzi pometaantsi. ");
INSERT INTO cpy_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Imatakiro Tajorentsi ithonkatakiro nampitsi inampiwitawowa Lot. Teemaeta ipeyakotziri Tajorentsi irika Abraham, rowawijaakoteeri itominthori Lot thonkatachanimi rirori. ");
INSERT INTO cpy_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Antawoete ithaawanaki Lot inampiteeyaawo Zoar-ki, itonkaanaki tonkaariki itsipatanaawo apite rishinto. Ari ijeekawaeteeri impeetamooki. ");
INSERT INTO cpy_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Okanta rantawote rishinto Lot okenkithawaetakaakiro irento, okantziro: “Antarikitaki apaapate, tekatsi shirampari aementeeyaari jaka, antantyaawori ametapiintari. ");
INSERT INTO cpy_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Jame ashinkiteri, roo añaantyaari itzimae eentsitepaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Okanta otsirenitanaki, okitaakitaatakiri opaapate. Otsipatakari rantawote rishinto. Teemaeta ikemawenta opaapate jempepaete otsipatakari, jempepaeterika opiriintanaa eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Okanta otsipa kitejeri, okantee rantawote rishinto, okantziro irento: “Notsipatakarira naaka apaapate tsireniriki, jame apiiteri oshinkiteri pitsipatantyaariri eeroka, rowakantemire.” ");
INSERT INTO cpy_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Okanta otsirenitanee, apiiteeri oshinkiteeri opaapate, omatakiro ewankawo otsipatakari opaapate. Teemaeta ikemawenta eejatzi Lot jempepaete otsipatakari rishinto jempepaeterika opiriintanaa eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Roojatzi omotzitantakari apitika rishinto Lot, riitaki owakakirori opaapate. ");
INSERT INTO cpy_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Etanakawo rantawote itzimaki otomi, oetakiri Moab, riitakira oshekitaneentsiri iiteetakiri Moab-ite. ");
INSERT INTO cpy_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ari okantaka eejatzi ewankawo, tzimae otomi, oetakiri Ben-amí, riitaki oshekitaneentsiri iiteetakiri Amon-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ikanta Abraham jatee kirinkanta Nehuev-ki, inampitapaawo Gerar-ki, jeekatsiri niyankithakineki awotsi nampitsiki Cades roojatzi Shur. ");
INSERT INTO cpy_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ikantantayitzi janta: “Kaari noena iroka Sara, choeni ini.” Ikanta ikemaki Abimelec, pinkatharitatsiri nampitsiki Gerar, rotyaantaki aakiteroni Sara, iinantyaawo. ");
INSERT INTO cpy_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Okanta otsirenitanaki imishiwaetaki Abimelec, ikantziri Tajorentsi: “Ari pikamaki, tema payitantakiro tsinani tzimatsiri oemi.” ");
INSERT INTO cpy_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tekiramacheeni iñeeroota Abimelec iroka tsinani, ikantanaki rirori: “¡Pinkatharí! ¿Kameethatatsima powamayeri kaari tzimatsini ikinakaashitane? ");
INSERT INTO cpy_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Riimacheetaka Abraham kantakinari: ‘Iroka tsinani choeni ini’. Omatzitakawo eejatzi roori okantzi: ‘Ariini rini irika Abraham.’ Teera nokowawita nowaariperotante. Tekatsi nantakayirori kaariperotatsiri.” ");
INSERT INTO cpy_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Rakanakiri Tajorentsi imishiriki, ikantziri: “Niyotaki naaka tee pikowawita powaariperotante. Rootaki kaari noshinetantzimi pantero, rootaki opoñaantari kaari pikaariperotzimotantana. ");
INSERT INTO cpy_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Pipaeri iina irika atziri. Tema kamantantaneri rini, ari ramanakotakimi eero pikamanta. Eerorika poepiyeeniri iina, ari pithonkatakya pikame maawoeni eejatzi pitomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ikanta ipiriintamanaa Abimelec, ikaemakiri romperatanepaeni, ikamantakiri okaatzi imishitakiri. Antawoete ithaawaeyanakini. ");
INSERT INTO cpy_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ikanta Abimelec ikaemakiri Abraham, ikantakiri: “Paminero jempe pikantakina. ¿Jempema nokantakimika naaka powaariperotantenari? Kaari ranteetziro iroka. ");
INSERT INTO cpy_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Iitaka pikenkithashiretari pantantawori iroka?” Ari ikantaki Abimelec iñaanatakiri Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Rakanaki Abraham, ikantanaki: “Noshiyakaatzi ari rompojawenteetakinawo noena, noshiyakamintheetzi jaka nampitsiki tekatsi pinkathaterini Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Omaperowita nitsirotawo Sara tema rishinto inatziiri ashitanari, kaaritzimaeta ashityaawoni nonaanate. Roowa naantakawori. ");
INSERT INTO cpy_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Paerani ikantakina Tajorentsi noshitoye iipatsiteki ashitanari, nokantakiro Sara okantantayite jemperika nareetya: ‘Aariini rini’.” ");
INSERT INTO cpy_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Ikanta Abimelec roepiyeeniri Abraham iina. Ipashitawaari tzimahaantatsiri romperatane, ipawaeri tsinani eejatzi shirampari, ari ipawaeri eejatzi tzimakaarantatsiri ivacate eejatzi rovejate. ");
INSERT INTO cpy_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ikantawaeri: “Iroka noepatsite, paminee jemperika pinintziro pinampityaawo.” ");
INSERT INTO cpy_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ari ikantawaero Sara roori: “Oshekira koriki nopakiriri piyaariri, ikaatzi 1000. Roo inimotanteemiri eero pikaaniwaetanta. Riyoteero maawoeni pikaateeyakinira rowetsikaero okaatzi awijeentsiri.” ");
INSERT INTO cpy_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Ikanta Abraham ramananakari Tajorentsi, omapokashitanaa retsiyatakotanee Abimelec, eejatzi itsipatari. Etsiyatakotanee eejatzi ronampiripaeni otzimaanitanteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Tema okantakaantakiro Sara, imaanirotakaakiro Tajorentsi tsinanipaeni romperatane Abimelec okaatzi jeekapankotziriri. ");
INSERT INTO cpy_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ikanta Tajorentsi, ikenkithashireteero Sara, monkaataka inintakaakirori. ");
INSERT INTO cpy_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Roojatzi omotzitantakariri eentsite, otzimakiniri apaani itomi Abraham, okantawitaka rantarikitaki Abraham, tema imonkatakiniri Tajorentsi okaatzi ikantakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Imatakiro Abraham, iitakiri Isaac otomi Sara. ");
INSERT INTO cpy_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ikanta imaakotapaaki 8 kitejeri raanakiri iitothowaanikiteri, tema rootaki ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Tzimaki Abraham okaatzi 100 rojarentsite itzimantakari Isaac. ");
INSERT INTO cpy_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ari okenkithashiretanaka Sara, okantzi: “Ikaatzi kemakoteenani tzimaki neentsite, aritaki ishirontawentakina, tema ari nokantaka naaka ishirontakaakina Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Iitama yotatsiri arira itzimae neentsite nothotahaeri? Matzimaetaaka tzimaana okantawitaka rantarikiwitaka Abraham.” ");
INSERT INTO cpy_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ikanta ikimotatanaki Isaac rookanakiro iteni, antawoete ikimoshireteeyaanaakini Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Roo kantacha Sara, oñaakiri otomi Agar Egipto-jato itzimakaakirori Abraham, osheki itheenkimawaetziri Isaac. ");
INSERT INTO cpy_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Iyaatashitakiri Abraham, okantapaakiri: “Potyaanteero ponampiri otsipataneeyaari otomi. Tee okameethatzimotana itsipatyaari notomipaeni naaka otomipaeni onampitaarewo. Tee nokoyi rantetyaari pashitakaeyaariri.” ");
INSERT INTO cpy_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Osheki okatsitzimotanakiri Abraham, tema rijatzi itomi. ");
INSERT INTO cpy_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Riitaki kantacha Tajorentsi ikanteeri Abraham: “Eero ipakootzimowaetzimi pitomipaeni eejatzi riniro. Pimatero okantakimiri Sara. Tema irika Isaac, riitaki shekitaatsini picharinityaari riroperotatsini. ");
INSERT INTO cpy_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ari nokanteeri eejatzi otomi pomperatane, ari noshekyahaeri eejatzi itomipaeni rirori, tema riitaki pitomi.” ");
INSERT INTO cpy_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Okanta okitejetamanee, ipakiro Abraham iroka Agar pan, ipakiro eejatzi mashitsinaki, ari ipiyaantakiniro nija. Ikyaakaakiro irokapaeni, itsipataakiro Ismael otomi, rotyaantakiro iyaate. Jatanaki ochempimashiki iiteetziro Beerseba, okinakinawaetzi, tee iyotzimaetya jempe areetya. ");
INSERT INTO cpy_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Okanta othaateero onijaate mashitsinakiki, ookanakiri otomi inchatapishiki. ");
INSERT INTO cpy_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Iyaatapithatanakiri inteneeni, tema tee okoyi oñeeri ikamimotero. Okanta jeekapaaki inteneeni, iraanaka otomi. ");
INSERT INTO cpy_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ikemakiri Tajorentsi riraawaeta eentsi, ikaantanaki ronampiri tajorentsite jenokinta, ikantziro Agar: “¿Iitaka awijimotzimiri Agar? Eero pithaawashiwaeta, ikemakiri Tajorentsi rirahaa peentsite pomaryaakirira. ");
INSERT INTO cpy_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Piyaate, pitzinahaeri, eero powashironkayiri. Tema ari noshekyahaeri ichariniite.” ");
INSERT INTO cpy_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Ikantakaakawo Tajorentsi, oñaaki Agar oshitowaatzi nija. Jatanaki, opiyaantaki mashitsinakiki, oetakiri otomi Ismael. ");
INSERT INTO cpy_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Riitaki Tajorentsi tajonkawentakiri eentsi, roojatzi rantaritantakari. Ari inampitakawori ochempimashiki. Kominthaantzi rini. ");
INSERT INTO cpy_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Inampitakawo ochempimashiki iiteetziro Parán. Okanta riniro, opakiri iinantyaawo Egipto-jato. ");
INSERT INTO cpy_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Aripaete riyaataki Abimelec ikenkithawaetakayiri Abraham. Itsipatanakari Ficol, reewari rowayirite. Ikantapaakiri: “Niyotzi osheki itajonkawentakimiro Tajorentsi okaatzi pantayitziri. ");
INSERT INTO cpy_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nokoyi paakotenawo iwaero Tajorentsi, niyotantyaari eero powaariperotantana naaka, notyomipaeni, eejatzi ikaate nochariniyityaari. Nokoyi pikantaperotena, niyotantyaari aririka paakameethatakina naakaete nokimitzimi eeroka naakameethatapiintakimi, ari poshiyakayiriri eejatzi atziripaeni ikaatzi nampitawori jaka pinampitakawowa eeroka.” ");
INSERT INTO cpy_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ikantanaki Abraham: “Aritaki nomatakimiro pikowakiri, omaperotatya.” ");
INSERT INTO cpy_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ikantanakiri eejatzi: “¿Piñaakiri ponampiripaeni rashitakawo nonijaate nokaapiintziri?” ");
INSERT INTO cpy_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ikantanaki Abimelec: “Tee niyote jempe itzimi aapithatakimirori, owakiraha nokemakimi nimaeka.” ");
INSERT INTO cpy_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Raaki Abraham rovejate, ivacatepaeni ipashitakari Abimelec. Arira raapatziyawakahaari. ");
INSERT INTO cpy_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Riitaki kantacha Abraham, rinashitaka itsipa 7 rovejate. ");
INSERT INTO cpy_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Rojampitakiri Abimelec, ikantziri: “¿Iitaka pinashitantariri povejatepaeni?” ");
INSERT INTO cpy_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ikantanaki Abraham: “Irika 7 oveja nopakimiri, roori riyotanteetyaari naakataki kiyakotzirori ikaapiinteetzira nija.” ");
INSERT INTO cpy_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Roo iitanteetakawori Beerseba, tema ari ikenkithawaetawakaaka janta apiteroeni eenitatsi raapatziyawakaeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ikanta ithonkakiro ikenkithawaeteeyini Beerseba-ki, piyanaa Abimelec itsipatanaari Ficol inampiiteki Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ikanta Abraham ipankitaki inchato janta Beerseba-ki, ikowakotakiri Tajorentsi raakotero iwaero, ikanteetziri “Añaaniri Tajorentsi”. ");
INSERT INTO cpy_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Osheki ojamanitaki ijeekawaetaki Abraham iipatsiteki Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Okanta ojamanitaki, ikowaki Tajorentsi iñeero rawentaashirenkari Abraham. Iñaanatakiri iwaero, ari rakanaki rirori, ikantanaki: “Jaka nojeeki Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ikantziri Tajorentsi: “Piyaate janta Moriaj-ki, paanakiri petakoperotane pitomi. Arika pareetakya, pitayenari tonkaariki jempe janta noñaahakimiro.” ");
INSERT INTO cpy_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Okanta okitejitamanee, ipiriintanaka Abraham, rowetsikakiri iyawayote, raanaki itsima itaantyaariri, jataki rookotakinirira Tajorentsi. Raanakiri itomi Isaac itsipataanakiri apite romperatane. ");
INSERT INTO cpy_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Mawatapaentsiri kitejeri ari raminanaki jantó roshiretakawonta. ");
INSERT INTO cpy_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ikantakiri romperatane: “Ari pijeekawaki jaka pikempoyeeri kawayo. Niyaatawakiita naaka notsipatanakyaari notyomi. Arika nomatakiri nopinkathateri Tajorentsi, roojatzi nopiyanteeya.” ");
INSERT INTO cpy_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Raakiro itsima Abraham, inatakaanakiri Isaac, raanaki eejatzi iyotsiryaanite, eejatzi paamari. Jateeyanakini apityaampikiteeni. ");
INSERT INTO cpy_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tekira ojamaniteeta rojampitakiri Isaac ipaapate, ikantziri: “Pawa.” Ari rakanakiri Abraham, ikantzi: “Iitaka pikoyiri notyomí.” Ikantzi Isaac: “¿Tzimatsi tsitsi, paamari, jempe ayeka oveja atayeri?” ");
INSERT INTO cpy_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ikantzi ashitariri: “¡Notomi! Riitaki Tajorentsi kantakaeyaawoni itzimantyaari oveja atayeniriri.” Eekiro riyaateeyatziini. ");
INSERT INTO cpy_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ikanta rareetapaaka jempe rookotakiniri Tajorentsi, ipewiryaapaaki mapi Abraham rowetsike itaamento, ipewiryaakiro itsima itaantyaariri. Raakiri itomi roojotakiri, roma-ryaakiri taamentotsiki ipiyotakirowa itsima. ");
INSERT INTO cpy_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Roo itzinaawitanakawo iyotsiryaanite rojataantyaariri itomi, ");
INSERT INTO cpy_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ikaemotanakiri ronampiri Tajorentsi, ikantziri: “¡Abraham! ¡Abraham!” Rakanaki rirori ikantzi: “Jaka nojeeki.” ");
INSERT INTO cpy_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ikantziri ronampiri tajorentsi: “Eero pojateeri eentsi, niyotakimi nimaeka tee pipiyathatari ikantzimiri Tajorentsi, tee pithañaapithatari papintzite pitomi.” ");
INSERT INTO cpy_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ari raminanaki itaapiiki Abraham, riñaatziri roojotaka icheeki oveja inchamaeshiki. Riyaatashitanakiri, riitaki poyaatakariri itomi itaakiri. ");
INSERT INTO cpy_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Rootaaki iitantakawori Abraham tonkaari, iitakiro: “Ipantziro Tajorentsi oetarika koetyiimoteeri.” Roo ikantantapiinteetari: “Ipaetanteero oetarika koetyiimoteeri janta itonkaariteki Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Eejatzi rapiitakiro ronampiri Tajorentsi iñaanateeri Abraham, ");
INSERT INTO cpy_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ikantziri: “Iroka iñaani Tajorentsi: ‘Okantakaantziro tee pithañaari papintzite pitomi, naakatakira pikemijante nopaanteki. ");
INSERT INTO cpy_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Ari piñaakiro notajonkawentaperotemi. Naakataki oshekeerini pitomipaeni roshiyeeyaari roshekitzi ompokiro, roshiyeeyaawo oshekitzi eejatzi impaneki nijathapyaaki. Riitaki otsinampahaerini ikijaneentane. ");
INSERT INTO cpy_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Riitaki kantakaanteeroni itajonkawenteetantyaawori maawoeni inashiyitachari isheninkatawakaaha kepatsiki, okamintha pikemijantakina.’” ");
INSERT INTO cpy_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Piyaaja Abraham jempe royaawentziri romperatanepaeni. Ikanta ranashitakawo maawoeni Beerseba, ari inampitaawori Abraham janta. ");
INSERT INTO cpy_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Okanta ojamanitaki, ikemakoteero Abraham iinathori Mil-ca itsimakahaero rirentzi Nacor. ");
INSERT INTO cpy_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Etakawori itzimi iita Uz, itzimanaki itsipa iitakiri Buz, itzimanaki itsipa iitakiri Kemuel, riitaki ashitanakariri Aram. ");
INSERT INTO cpy_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Ari itzimanaaki itsipa: Quesed, Jazo, Pildas, Jidlaf, Betuel. ");
INSERT INTO cpy_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Irika Betuel riitaki ashitanakawori Rebeca. Riitaki irikapaeni 8 otomipaeni Mil-ca itzimakakirori Nacor, rirentzi Abraham, ");
INSERT INTO cpy_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Itzimakakirori eejatzi Nacor omperatane iitachari Reúma. Irika ikaateeyini: Teba, Hajam, Tajas, Maaca. ");
INSERT INTO cpy_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Okaatzi 127 ojarentsi añaaki Sara. ");
INSERT INTO cpy_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ari okamaeri roori janta nampitsiki Quiriat-arba iiteetziri eejatzi Jebrón jeekatsiri Canaán-ki. Antawoete riraakotakawo Abraham okamakira Sara. ");
INSERT INTO cpy_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Okanta okamaki Sara, riyaatashitakiri Het-ite nampitawori janta, ikanteri: ");
INSERT INTO cpy_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Pashinijatzi nini naaka tee osheninkatawaka, nokoyi namanante piyaminkarimoote nokitatantyaawori noena.” ");
INSERT INTO cpy_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ikanteeyanakini Het-ite: ");
INSERT INTO cpy_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Pikemijantawakina nowinkatharite. Riyoyaane Tajorentsi pini eeroka, pamine kyaariperori kaminkarimoo pikitatero piina. Tekatsi thañaapithatemironi.” ");
INSERT INTO cpy_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Katziyanaka Abraham, riwethatanakari Het-ite. ");
INSERT INTO cpy_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ikantanakiri: “Kyaariperorika pikowaeyini nokitatzimotemiro noena, pikanteri Efrón itomi Zoar, ");
INSERT INTO cpy_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","nokoyi namanantero impeetamoo iiteetziri Macpela jeekatsiri iipatsiteki. Aritaki nopinatakiri jempe okaate ikowakotenari. Roo opoñaantyaari nashitantyaawori naaka.” ");
INSERT INTO cpy_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ari ijeekaki irika Efrón itsipatakari isheninkapaeni Het-ite, rakanakiri Abraham ikemantyaariri isheninkapaeni, ikemantyaari ikaatzi areeyitachari nampitsiki, ikantanaki: ");
INSERT INTO cpy_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Eero nowinkatharite, nopashitemiro noepatsite impeetamoo. Riitaki nosheninkapaeni ñeenani nopashitemiro. Otzimatye pikitatero piina.” ");
INSERT INTO cpy_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ari rapiitanakiro Abraham riwethatanakari nampitawori janta. ");
INSERT INTO cpy_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ikemakiri maawoeni itsipatakari, ikantanakiri Efrón: “Pikemi nokantemi, nokoyi payeri koriki nopinatemirori piipatsite, nokitatzimaetyaawo noena janta.” ");
INSERT INTO cpy_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ari ikantanaki Efrón: ");
INSERT INTO cpy_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Pikemi nowinkatharite, teera eepichokiini ipana noepatsite ikaatzi 400 ipewireeya koriki, teemaeta okameethatzi iñaawaetakoteri koriki. Pamakiro piina, pikitatero.” ");
INSERT INTO cpy_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Inimotanakiri Abraham ipinateri Efrón okaatzi ikantakiriri ipiyoteeyakanira isheninkapaeni Het-ite. Ipakiri iyorikite, raawakiri. ");
INSERT INTO cpy_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Rootaki awijaentsiri iipatsiteki Efrón jeekatsiri Macpela-ki, omontetakari Mamre ojeekira impeetamoo, inchatomashi ini eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Rashitanakawo Abraham iroka kepatsi. Maawoni iñaakowentakiro Het-ite ipinateetakiro, iñahaeyakironi eejatzi ikaatzi areeyitachari nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ari ikitatakiro Abraham iina Sara janta impeetamooki ramanantakotakiri Macpela-ki, omontetakari Mamre, iiteetzitawo eejatzi Jebrón janta Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Rootaki rashitantakawori Abraham okaatzi tzimatsiri kepatsi eejatzi impeetamooki. Rootaki ipimantakiri Het-ite, okine ikitatero Abraham iina. ");
INSERT INTO cpy_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Antarikiperotaki Abraham, osheki itajonkawentakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ikanta Abraham ikaemakiri antarikitaentsiri romperatane, kempoyeeniriri tzimimotziriri. Ikantakiri: “Poteeyachokitena. ");
INSERT INTO cpy_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Pikantena kyaariperoeni, paakoteri Tajorentsi Itajorentsitetari jenokintaki eejatzi kepatsiki, eero pishinetanari notyomi iinantyaawo tsinani Canaán-jato jeekatsiri jaka. ");
INSERT INTO cpy_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Otzimatye piyaate nonampiiteki, pamineniri nosheninkapaeni iinantyaari.” ");
INSERT INTO cpy_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Rakanakiri romperatane, ikantziri: “Eerorika okoyi opoke ewankawo, ¿jempe nokantyaaka? ¿Otzimatyeema naanakiri pitomi pinampiiteki jempe pipoñaaka paerani?” ");
INSERT INTO cpy_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ikantanaki Abraham: “Eero, eero omata payeri notyomi janta. ");
INSERT INTO cpy_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Tema Tajorentsi, Itajorentsitetari jenokintaki, amaanari paerani iipatsiteki ashitanari, iipatsiteki eejatzi nochariniite. Ishinetakiri iperi iroka kepatsi maawoeni nocharinityaari. Aritaki rotyaantaki ronampiri tajorentsite tsipatemini pamantyaari tsinani iinantyaari notyomi. ");
INSERT INTO cpy_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Eerorika okoyi oyaatemi tsinani, pimonkaatakiro pantzimotanari. Tee nokoyi payeri notyomi janta.” ");
INSERT INTO cpy_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Imatakiro romperatane, roteeyawathatakiri Abraham, ikantaki: “¡Omaperotatya! Ari nantakiro okaatzi pikantakinari.” ");
INSERT INTO cpy_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Riyoyaakiro tzimimotziriri omperatariri ipashitantyaari. Raanaki 10 tsimeri ikyaakaanakiri, jataki inampiki Nacor janta Mesopotamia-ki. ");
INSERT INTO cpy_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ikanta rareetzimataka nampitsiki, ari otsireniityaanaki, imakoryaakaapaakiri ipirapaeni ojeekira nija. Ari okaawoshitapiintari tsinanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Amanapaaka, ikantzi: “Tajorentsi, Itajorentsite omperatanari Abraham, eeroka kantakaeyaawoni omatantyaari nokoyiri, pineshironkateri omperatanari. ");
INSERT INTO cpy_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ari nojeekawaki jaka nijateniki, pokapaaki tsinanipaeni okayi nija. ");
INSERT INTO cpy_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Eeroka kantakaeyaawoni aririka nokantakiro apaani ewankawo: ‘Pipawakina pichomone nirantawakyaata nomiri.’ Okantanaki roori: ‘Pirantawakya. Ari nopitakyaari imiri eejatzi pipirapaeni.’ Rootaki tsinani pikowakaakiriri pomperatane Isaac. Ari niyoteri petakotari omperatanari.” ");
INSERT INTO cpy_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tekiraata ithonkiroota ramaña, pokapaaki apaani ewankawo onatakiro ochomone oshempaki. Rootaki Rebeca rishinto Betuel. Tema irika Betuel riitaki otomi Mil-ca itzimakakirori Nacor rirentzi Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Kameethanto ini Rebeca, tee iyootziri shirampari, tekatsi antaminthawaeteroni. Oerinkapaaka nijaaki, okaapaaki, roo opiyaneemi. ");
INSERT INTO cpy_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Ari ishiyashitanakawo omperataarewo, ikantakiro: “Pipawakina nirawaki eepichokiini pinijaate.” ");
INSERT INTO cpy_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Okantanaki roori: “Pirawaki nowinkatharite.” Owayiitakiro ochomone, opakotaakiri onijaate oteeyakotakiniri. ");
INSERT INTO cpy_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ikaatakiro riraki imiri omperataarewo, okantanakiri Rebeca: “Nokaapanaate otsipa noperiri pipirapaeni, rirawakiita rirori.” ");
INSERT INTO cpy_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Intsipaete oshiyapaenta okaapanaatzi nija irapinteetziri, osheki opiyapiyataka, iyeekitakiniri imiriteri piratsipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ari raminaminthatakiro operataari tekatsi ikantero, tema ikowatzi riyote riirika Tajorentsí kantakaawori omatantakari iroka. ");
INSERT INTO cpy_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ikanta ithonkaka rireeyakini piratsipaeni, romijokyaanakiri omarentsi rowetsikaetziri ooro, iryaani rini. Ikyaantakaakawo okiriki. Ipakiro eejatzi apite omarentsi omaatyaari akoki, antari rini. ");
INSERT INTO cpy_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ikantanakiro: “Pikantena, ¿Iitaka pipaapatetari? Antawo ipanko pipaapate nomaantyaari notsipatyaari nokaateeyakinira.” ");
INSERT INTO cpy_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Okantanaki roori: “Naakataki rishinto Betuel, otomipaeni Mil-ca rishinto Nacor. ");
INSERT INTO cpy_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Eenitatsi jempe pimahaeyeni, eenitatsi eejatzi osheki royaari pipirapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ari rotziwerowanaka omperataari ramananaakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ikantanaki: “Riroperori rini Tajorentsi, Itajorentsite omperatanari Abraham, tee ramatawiteri omperatanari ineshironkatakiri. Riitaki amakinari jaka noñaantakawori ipanko isheninkathori.” ");
INSERT INTO cpy_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tee ojeekanaki Rebeca, oshiyaperotanakitya opankoki oñeero iniro, okamantapaakiro. ");
INSERT INTO cpy_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Eenitatsi iyaariri iroka Rebeca iita Labán, riitaki shiyaneenchari kaayirontsiki raminiri atziri. ");
INSERT INTO cpy_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Tema iñaawakiri omarentsi rowetsikaetziri ooro omayitakari ritsiro akoki, ikemawakiro eejatzi okamantantapaakiri ikantakirori atziri. Ikanta rareetapaakari Labán romperatane Abraham ijeekaakayirira ipirapaeni nijaateniki. ");
INSERT INTO cpy_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ikantapaakiri: “Pipoke itajonkawentane Tajorentsi. ¿Iitaka pijeekantari inteeneni? Rowetsikaanteetakimira pankotsiki poyirira pipirapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ari riyaatanaki omperataari janta pankotsiki. Rowayiiyantapaakiri Labán irikapaeni eejatzi ipirapaeni, ipakiri royaari. Ari ramaetakiniri nija areetzinkari ikewapakyaari. ");
INSERT INTO cpy_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ikanta royiitawakiniri rowapaakyaari, ikantanaki romperatane Abraham: “Eerowa nowa eerorika nokamantzimiro nokoyiri.” Ikantanaki Labán: “ajaa pikamantena.” ");
INSERT INTO cpy_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ikantanaki omperataari: “Naakataki romperatane Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Antawoete itajonkawentakiri Tajorentsi irika omperatanari, osheki rashaahantakaakari: eenitatsi rovejate, ivacate, iyorikite, camello, iyawayotepaeni, tzimatsi osheki ratzirite romperatane tzimatsi eejatzi osheki tsinani. ");
INSERT INTO cpy_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ari okantakari Sara okantawitaka aatawitaka, tzimae otyomi. Riitaki rashitakahaari omperatanari okaatzi tzimimotziriri. ");
INSERT INTO cpy_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ikowaki eero namatawitziri, ikantakina: ‘Eero pishinetanari notyomi iinantyaawo tsinani Canaán-jato jeekatsiri jaka. ");
INSERT INTO cpy_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Roo kameethatatsi piyaatashiteri isheninkathori ashitanari, pamineniri notyomi apaani tsinani janta nosheninkapaeniki, kameethatatsiri iinantyaawo.’ ");
INSERT INTO cpy_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nokantanaki naaka: ‘Nowinkatharite, ¿eerorika okoyi oyaatena tsinani?’ ");
INSERT INTO cpy_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Ikantanakina rirori: ‘Kameethari nokantzimotakari Tajorentsi, aritaki rotyaantakimi ronampiri tajorentsite itsipatemi, ari pimatakiro okaatzi nokantakimiri. Aritaki pamaki tsinani iinantyaari notyomi, isheninkathori ini ashitanari. ");
INSERT INTO cpy_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Eerorika ikowashita nosheninkathori ipemiro rishinto, arira okaatzi ikantawakinari.’ ");
INSERT INTO cpy_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Nokanta nareetapaaka nijaateniki, namanakari Tajorentsi Itajorentsite omperatanari, nokantziri: ‘Kyaariperorika pineshironkatana omatya nokoyiri jaka. ");
INSERT INTO cpy_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Nokowakotzimi nojeeke jaka nijaateniki, opoñaantyaari omatya ironta ewankawo pokaentsiri okaayi nijaa, aririka nokantawakiro: “Pipena eepichokiini nijaa pichomoneki, nirawakiita.” ");
INSERT INTO cpy_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Arika akanakina, okantena: “Pirawaete. Ari nokaapanaate otsipa noperiri pi-pirapaeni rirawaki eejatzi rirori.” Rootaki tsinani ikowakaakiriri Tajorentsi itomi omperatanari.’ ");
INSERT INTO cpy_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tekira nothonkiroota namaña, noñaawakiro opokaki Rebeca amakiro ochomoni oshempaki. Oerinkapaaka nijaateniki, okitatapaaki nijaa. Ari nokantziro: ‘Pishinetena nirawaki pinijaate.’ ");
INSERT INTO cpy_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Intsipaete oyiitanakiro ochomoni, okantanakina: ‘Pirawaki, aritaki nokitaatapanaate otsipa imiriteri eejatzi pipirapaeni.’ Opakina nijaa nomiritaki, opitakari eejatzi nopirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ari nojampitanakiro: ‘¿Iitaka pipaapatetari?’ Ari okantanakina roori: ‘Naakataki rishinto Betuel itomipaeni Nacor eejatzi Mil-ca.’ Ari nokyaantakaakawo thatanentsi okiriki, nomaatantakawo akoki apite omarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ari notziwerowanakari nopinkathatanakiri Tajorentsi, nomampaawentanakari Itajorentsite omperatanari Abraham, riitaki amakinari nareetantakari ipankoki isheninkathori, namineniri iina itomi. ");
INSERT INTO cpy_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nokoyi pikantena kameetharika ikoyiri omperatanari, terika inimotemi pikantena, niyotantyaari oeta nanteri.” ");
INSERT INTO cpy_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Ikanta Labán itsipatakari ipaapate Betuel, ikantanaki: “Tema riitaki Tajorentsi kantakaawori, piyote eeroka kameethatatsirika. ");
INSERT INTO cpy_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Apatziro nokantzi naaka: Iroka Rebeca, paanakiro. Rootaki iinantyaari itomi omperatzimiri, rootakira ikowakiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ikanta ikemaki romperatane Abraham, otziwerowaperotanaka iñaapinkathatanakiri Tajorentsi, rowatziitotanaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Inoshikanakiro ramayitakiri rowetsikaetziri ooro, koriki, kithaarentsipaeni. Ipakiro maawoeni Rebeca. Ipashitakari eejatzi iyaariri eejatzi riniro. ");
INSERT INTO cpy_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Owaeyanakani, irawaeteeyakini itsipatari oyaatakiriri. Mahaeyakini. Okanta okitejitamanee, ipiriintamana, ikantanaki omperataari: “Pishinetena nopiyee ipankoki omperatanari.” ");
INSERT INTO cpy_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Teemaeta ikoyi iyaariri Rebeca eejatzi iniro, okantaki: “Paata iyaatzita ewankawo, nokowatzi ojeekanee okaate 10 kitejeri omanaki iroka, aripaete oyaatemi.” ");
INSERT INTO cpy_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ikantanaki omperataarewo: “Aritaki pojamanitakaakina, riitaki Tajorentsi kantakaakawo omatantakari awijeentsiri. Otzimatye pishinetena nopiyayiitee ipankoki omperatanari.” ");
INSERT INTO cpy_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ikanteeyanakini riroripaeni: “Thame akaemiro ewankawo, akemiro jempe okantzi roori.” ");
INSERT INTO cpy_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ikaemaetakiro Rebeca, rojampiitakiro: “¿Pikoyi poyaatanakiri atziri?” Ari okantanaki roori: “Jeen, nokoyi noyaatanakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ari ishineetakirori iyaate Rebeca otsipatanakyaawo apaani tsinani koeratzirori paerani eeniro eentsitapaakini. Oyaatanakiri romperatane Abraham itsipatanaari oyaayitakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Riwethatawaawo iyaariri, ikantawaero: “Piyaatera choeni, eerokataki rinironteeyari osheki atziri. Riitaki pitomipaeni aapithayiteerini inampi ikijaneentane.” ");
INSERT INTO cpy_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ari okyaakaanakari camello iroka Rebeca otsipatakawo koeratzirori paerani, oyaatanakiri romperatane Abraham. Imatakiro omperataari raanakiro Rebeca, piyanaa. ");
INSERT INTO cpy_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Areetzimataa rirori Isaac ipoñahaawo nijaaki iiteetziro “inijaate Añaari Ñaakinari,” jeekatsiri kirinkanta Nehuev-ki. ");
INSERT INTO cpy_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tsireniityiimataki riyaatzi ikinawaetzi. Raminanaki iñaatziri ipokaeyini camello-paeni. ");
INSERT INTO cpy_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ari okantzitaka Rebeca eejatzi, aminaki jantó oñaakiri Isaac, ayiitashitanakiri. ");
INSERT INTO cpy_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Ojampitanakiri romperatane: “¿Iitaka irinta pokashitakaeri?” Ikantanaki omperataari: “Riimacheetaka omperatanari.” Ari aanakiro owashikawo, opashikawootapithatanakari. ");
INSERT INTO cpy_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ikamantapakiri Isaac irika romperatane okaatzi rantakiri. ");
INSERT INTO cpy_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ikanta Isaac raanakiro Rebeca opankoki Sara rinironi, iinantakawo iroka tsinani. Osheki ikowanakiro Isaac iroka Rebeca. Rootaki oemoshirenkapakiriri okamaera rinironi. ");
INSERT INTO cpy_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Tzimae otsipa iina Abraham oeta Cetura ");
INSERT INTO cpy_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Irika itomipaeni itzimakakirori: Zimram, Jocsán, Medán, Madián, Isbac, Súa. ");
INSERT INTO cpy_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Riitaki Jocsán tomintanakariri Seba eejatzi Dedán. RiDedán sheninkatariri Asur-paeni, Letus-ite, Leum-paeni ");
INSERT INTO cpy_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Madián tomintanakariri Efa, Efer, Janoc, Abida, Elda. Maawoeni irikapaeni ri otomipaeni Cetura. ");
INSERT INTO cpy_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Riima Isaac riitaki aakirori okaatzi tzimimotziriri ashitariri Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Riima itsipa itomipaeni otzimakiri iinapaeni, apatziro ipakiri eepichokiini tzimimotziriri Abraham. Tekira ikamiita Abraham, rotyaantakiri itomipaeni rinashityaawo inampiteeyawo ishitowapiintzira ooryaa, tee itsipatari Isaac. ");
INSERT INTO cpy_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Okaatzi 175 ojarentsi rañaaki Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Kameetha ikamashitaka Abraham aakiri rantyaashiparinka. Ari itsipatapaari isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Riitaki kitateeri Isaac itsipatakari Ismael janta omoonaki Macpela-ki omontetari Mamre, iipatsiteki Efrón itomiranki Zoar Het-ite. ");
INSERT INTO cpy_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Rootaki iipatsite Abraham ramanakiriri paerani Het-ite. Ari ikitataari Abraham itsipatapaawo iinani Sara. ");
INSERT INTO cpy_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Okanta ikamaki Abraham-ni, itajonkawentakiri Tajorentsi irika Isaac, riitaki nampitaawori janta nijaateniki iiteetziro “Inijaate Añaari Ñaakinari.” ");
INSERT INTO cpy_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Irika itomipaeni Ismael, itomiranki Abraham itzimakantakawori Agar, Egipto-jato ini onampiri Sara. ");
INSERT INTO cpy_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Irika ikaatzi tzimaentsiri: Nebaeot, reewarite itomi. Eejatzi Cedar, Adbeel, Mibsam, ");
INSERT INTO cpy_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Dima, Massa, ");
INSERT INTO cpy_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Jadar, Tema, Jetur, Nafis, Cedema. ");
INSERT INTO cpy_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Riitaki 12 itomipaeni Ismael. Maawoeni tzimimotziriri iipatsite, rootaki iwaero aakoyitakiri inampi eejatzi iipatsite. Reewayitziri ikaatzira ijeeki inampiki. ");
INSERT INTO cpy_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Okaataki 137 rojarentsite Ismael roojatzi ikamantaari. Ari itsipatapaari isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Inampitaawo itomipaeni niyankithakineki kepatsi ojeekira nampitsi Havila, Sur, imontetakawo nampitsi Egipto, awotsiki jatachari Asiria-ki. Ari inampitakawori, okantawitaka tee ikowaeyini isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Irika ikenkithatakoetziri Isaac, itomi Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Tzimaki Isaac okaatzi 40 rojarentsite, raantakawori iina Rebeca rishinto Betuel, ritsiro Labán, Arampaini rini nampitawori Padan-aram-ki. ");
INSERT INTO cpy_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Teera itzimi Rebeca eentsite. Rootaki ramanakotantakawori Isaac ikowakotziri Tajorentsi. Ikemakiro ramana Tajorentsi, motzitaki Rebeca. ");
INSERT INTO cpy_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Okanta omotzitaki Rebeca, okematziiri raatzikatzikaatziro omotziki eentsite, ari okantashiretanaki: “Tzimatsirika awijimotenani, ¿oetaka nañaantyaari?” Jataki amanari Tajorentsi okoyi iyotero oeta anteri. ");
INSERT INTO cpy_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Rakanakiro Tajorentsi: Itzimatzi apite tsipatawakaachari inthomoeki pimotzikira, Apite okanta nampitsi, rootaki retantawori ikoshekawakaa tekira itzimiita. Shintsiri ikantya apaani, riima itsipa tee ishintsitzi, Riitaki omperatantachani impoerintzi, riitaki rompereetya etawori itzimi. ");
INSERT INTO cpy_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Okanta omonkaataka otzimaanitantyaari Rebeca, tzimaki tsipantzi. ");
INSERT INTO cpy_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Etapaakawori itzimi ikityonkatepokitatzi, ithonka iwitzitaki iwathaki, iiteetakiri Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Roteeyakiri iitziki itsipa rirentzi itzimapaakira, rootaki iitanteetakariri Jacob. Tzimaki Isaac okaatzi 60 rojarentsite otzimanitantakari Rebeca. ");
INSERT INTO cpy_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ari ikimotatanaki eentsipaeni. Osheki iñaawenatakawo Esaú owaantsi, kominthaantzi rini. Riima Jacob, tekatsi iñaamatya rirori, rashi royiro ijeekawaetzi pankotsiki. ");
INSERT INTO cpy_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Antawoete retakotakari Isaac itomi Esaú, tema osheki rowakotapiintakari ikentate. Rooma Rebeca etakotane oyiri roori Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ikanta ijeeki Jacob ronkotsiwaetzi, ari rareetaari Esaú imakonekiini ipoñahaawo owaantsiki. ");
INSERT INTO cpy_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ikantapaakiri: “Pipena eepichokiini poshiñeenkatentsiri ponkotsiri, aatyeena notashe.” (Rootaki iitanteetariri Edom eejatzi irika Esaú.) ");
INSERT INTO cpy_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ari ikantanaki Jacob: “Petawakyaawo eeroka poshiyakaeena naakami etyaawoni notzime.” ");
INSERT INTO cpy_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Eekiro ikantanakitzi Esaú: “Tema pikemana aatyena notashe, tekatsi oetya neewatakira notzimaki.” ");
INSERT INTO cpy_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Eekiro ishintsitanakitzi Jacob, ikantziri: “Ajatyaa pikantaperotena nimaeka.” Ari ishinetakiniriri Esaú rirentzi Jacob roshiyakaeri riitaki etyaawonimi itzimi, opoñaantyaari rahaero paata maawoeni tzimimotziriri ipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ipakiri Jacob rowanawo rirentzi Esaú. Ikanta ithonkakiro rowaka, riranaki imiri. Katziyanaka, jatanee. Tee ikenkithashiretakotero jemperika ikanteetero retawitakawowa itzimaki paerani. ");
INSERT INTO cpy_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Aripaete apiitaka iñahaetaki antawoete tashetsi janta, oshiyawo iñaakiri paerani Abraham-ni eeniro rañaawita. Rootaki riyaatantakari Isaac janta Gerar-ki, inampiwitawowa Abimelec, pinkathariwentziriri Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ari roñaahaari Tajorentsi, ikantakiri: “Eero piyaatzi Egipto-ki. Ari pijeeke jempe nonintakakimiro naaka. ");
INSERT INTO cpy_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Roojatzi pijeekawaki jaka nampitsiki. Aritaki notajonkawentakimi, tema nopakimiro maawoeni iroka kepatsi, roojatzi rashiteeyaarini eejatzi pitomipaeni. Rootaki nomonkaatantyaawori nokashiyaakaakiriri paerani ashitzimiri Abraham. ");
INSERT INTO cpy_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aritaki noshekyahaemiri pitomipaeni roshiyaari jempe ikanta roshekitzi ompokiro jenokinta. Aritaki nashitakahaeyaari maawoeni kepatsi. Riitaki kantakahaeyaawoni pitomipaeni itajonkawentanteetyaariri maawoeni inashiyitachari isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Tema ithotyaakiro paerani Abraham-ni ikemijantakiro nokantayitziriri, nonintakaantane, okaatzi niyotaayitziriri eejatzi.” ");
INSERT INTO cpy_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Rootaki ijeekantapaakari Isaac janta Gerar-ki. ");
INSERT INTO cpy_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ikanta rojampikowentziro Rebeca irikapaeni nampitawori janta, thaawanaki Isaac ikante rootaki iina, apatziro ikantzi choeni ini. Tema maperori okameethantotzi Rebeca, rootaki ikenkithashiretantakari Isaac ari rompojanteetakyaari iina. ");
INSERT INTO cpy_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ojamanitaki ijeekawaetaki Isaac janta. Okanta raminawaetzi Abimelec imoontzirowa ipanko, iñaakiri Isaac inintaawaetziro iina Rebeca. ");
INSERT INTO cpy_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Ari ikaemakaantakiri, rojampitakiri ikantziri: “Tema rootaki piina iroka, ¿tema ari? ¿Iitaka pikantantarikya choenira ini?” Ikantanaki Isaac: “Noshiyakaamintheetzi ari pompojantakinawo.” ");
INSERT INTO cpy_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ikantanakiri Abimelec: “Iitaka pikoshekawaetantari. Eepichokiinitaki, notsipatantyaaworimi piina, arira pikaariperotakaakinami.” ");
INSERT INTO cpy_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ikanta Abimelec ikantakiri maawoeni jeekatsiri nampitsiki: “Iitakarika koshekakyaarini irika atziri, koshekakyaawoni iina eejatzi, aritaki nompojakaantakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ari ipankiwaetakiri Isaac janta, rowiitakiro iwankiri, tema Tajorentsi tajonkawentakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Oshekitzimotakiri osheki rowaahawo, ashaahantzinkari rini. ");
INSERT INTO cpy_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Oshekini rovejate, ivacate. Osheki ikaatzi eejatzi romperatane. Rootaki ikijaneetantanakariri Filistia-jatziite. ");
INSERT INTO cpy_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tema paerani eeniro rañaawita Abraham ashitariri, ikiyakotakaakiri nijaateni romperatanepaeni. Roo kantacha ipokaeyakini Filistia-jatzi ityakitapakiro maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Tee ikijashitapaawo Abimelec, ikantakiri Isaac: “Pishitoyi nonampiki, tema pawijakina naakapaeni tzimaki pashaahawo.” ");
INSERT INTO cpy_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Shitowanaki Isaac ijeekapaki janta Gerar-ki. Ari inampitapaawo. ");
INSERT INTO cpy_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Rapiitapaero ikiyaatapaero nijaateni ikiyaatakiri paerani ipaapate, ityaakiwitaari Filistia-jatzi ikamakira Abraham. Rowaeniro owaero nijaateni iitzirowa paerani ipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Ikanta ikiyaateeyironi nijaateni romperatanipaeni Isaac, rareetakawo oshitowaatzira nijaateni. ");
INSERT INTO cpy_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ikanta koeratziriri rovejatepaeni Abimelec janta Gerar-ki, ikijapaakiri koeratziriri rovejate Isaac. Tema ikantawakaeyatyaani: “Iroka nijaateni nashi.” Rootaki iitantakawori Isaac iroka nijaateni “Esek”, tema ari rantawakaawentakawori nijaateni. ");
INSERT INTO cpy_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ari ikiyaatakotee romperatanepaeni Isaac otsipa nijaateni, roojatzi rapiitakiri ikijawakaawentawo, rootaki iitantaawori Isaac iroka nijaateni “Sitna.” ");
INSERT INTO cpy_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Rootaki ishirinkantaari Isaac ijeekae inteena, ikiyaatakotee otsipa nijaateni. Teera itzimapae kijawakaawentyaawoni, iitakiro nijaateni “Rejobot”, tema ikantakitzi ikenkithawaetzi: “Ishinetakaero Tajorentsi anintaawaeteeya jaka, ari añaakiro oshekitzimotee oetarika.” ");
INSERT INTO cpy_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","rojatzi riyaatantanaka Isaac janta Beerseba-ki. ");
INSERT INTO cpy_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Okanta tsirenipaeteki roñaahakari Tajorentsi, ikantakiri: “Naakataki Itajorentsite pipaapate Abraham. Eero pithaawashiwaeta, naakataki tsipatzimiri. Ikantakaantakiro nomperatane Abraham, aritaki notajonkawentakimi, Aritaki noshekyahaemiri pitomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Rootaki rowetsikantakari Isaac taapokimentotsi janta, ramanantyaariri Tajorentsi. Irira ijeekawaetakiri janta, ari ikiyaatakiri eejatzi romperatanepaeni nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ikanta ipokaki Abimelec ipoñaanakawo janta Gerar-ki ikenkithawaetakakiri Isaac. Itsipatakari raapatziyane iita Ajuzat, eejatzi Ficol, riitaki eewatziriri owayiriite. ");
INSERT INTO cpy_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ikantawakiri Isaac: “¿Iitaka pipokashitantanari nimaeka piñena? Tema pomishitowakina paerani pinampiki, tee pikowana janta.” ");
INSERT INTO cpy_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ari ikanteeyini riroripaeni: “Noñaakitziimi naakaete itsipatzimi eeroka Tajorentsi. Nokenkithashiretaka otzime antzimotawakaeyaari. Iroka okaate nokantemiri: ");
INSERT INTO cpy_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Tee nokoyi powaariperotena, tee nokoshekawaetzimi eeroka. Tema osheki naakameethatakimi, kameethaha notyaanteemi paerani eeroka, osheki itajonkawentakimi Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ikanta Isaac osheki roemoshirenkakahaeyanakarini irikapaeni, osheki rirawaeteeyanakini, rowaeyakani eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ikanta ipiriintamana okitejitamaneera, imatakiro rantzimotawakaeyaari, kameetha raapatziyawakaana apitepaeni. Ikanta Isaac, riwethatawaari riyaateeyeenira irikapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tekira awijita otsipa kitejeri, ipokaeyapaakini romperatane Isaac, ikamantapaakiri iñaaki otsipa nijaateni ikiyaatakiri. ");
INSERT INTO cpy_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Rootaki iitantakawori Isaac iroka nijaateni “Seba.” Iitanakiro nampitsi “Beerseba.” ");
INSERT INTO cpy_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ikanta Esaú, tzimaki okaatzi 40 rojarentsite, raantakawori Judit, rishinto Beeri, Het-ite rini. Raakiro eejatzi Basemat, rishinto itsipa Het-ite iiteetziri Elón. ");
INSERT INTO cpy_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Iroka apite tsinani, osheki okijashiryaakiri Isaac eejatzi Rebeca. ");
INSERT INTO cpy_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Antarikitapaaki Isaac, tee ikowichaatee. Ari ikaemakiri Esaú, reewari itomipaeni, ikantakiri: “¡Notomí!” Rakanakiri Esaú: “Iitaka paawa” ");
INSERT INTO cpy_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ikantziri Isaac: “Notyomí, naaka antyashiparitakina, tema rooteentsi nokami. ");
INSERT INTO cpy_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Nokoyi piyaate pikentakitena tsimeri. ");
INSERT INTO cpy_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ponkotsitenari, poshiniri ikantya nokoyiri naaka, pamakinari noyaari. Roojatzi nopasonkiwentantanakimiri tekira nokamanakiita.” ");
INSERT INTO cpy_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kemimaetaka roori Rebeca, okemakiri Isaac ikantziriri Esaú. Riyaamintheetzi Esaú ramini tsimeri royaari ipaapate, ");
INSERT INTO cpy_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","okantakiri itsipa otomi: “Nokemakiri pipaapate ikantakiri pirentzi Esaú, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pikentakitena tsimeri ponkotsitenari, kameetheeni okine noyaari, aritaki nopasonkiwentakimi tekira nokamanakiita.’ ");
INSERT INTO cpy_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Pikemijantero nokantemiri. ");
INSERT INTO cpy_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Piyaate poteeyi apite iryaani cabra, pamakinari, nonkotsitawakiniriita pipaapate okaatzira iñaamatapiintari rirori. ");
INSERT INTO cpy_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Eeroka aanakinirini rowawakya. Opoñaantyaari ipasonkiwentemi eeroka tekira ikamanakiita.” ");
INSERT INTO cpy_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ikantanakiro Jacob riniro: “Witzintzira rini yeeyi, rooma naaka tekatsi nowitzi. ");
INSERT INTO cpy_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ari riyotawakina ashitanari aririka ipampitawakina, ari ikenkithashiretakya notheenkashiretatziiri, aminaashiwaetya ipasonkiwentena tema osheki ikijimatanakina.” ");
INSERT INTO cpy_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Okantanakiri riniro: “Naakataki ikiji pipaapate. Pantero eeroka nokantakimiri naaka, pamakinari apite piratsi.” ");
INSERT INTO cpy_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Riyaatashitanakiri Jacob ipirapaeni, ramakiniro riniro. Onkotsitawakiri roori, owetsikakiniri jempe ikanta iñaamatapiintari Isaac. ");
INSERT INTO cpy_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Aakiro rooperori ithaari antarite otomi Esaú royiro ipankoki, okithaatakaakiri Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Okyaantakaakari imashi piratsi rakoki, eejatzi ikentsiki jempe tee otzimi iwitzi. ");
INSERT INTO cpy_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Opakiri pan eejatzi owanawontsi okaatzi onkotsitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Raakotanakiro Jacob ijeekakira ipaapate, ikantapaakiri: “¡Paawa!.” Rakanaki Isaac: “Iitaka notyomi.” ");
INSERT INTO cpy_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ikantzi Jacob: “Naakataki Esaú, pantarite pitomi. Nomatakiro okaatzi pikantakinari. Pipiriinte, poyaa noyentani, pipasonkitakotena.” ");
INSERT INTO cpy_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ikantzi Isaac: “¿Intsipaetema pikentakitzi tsimeri?” Ikantanaki Jacob: “Riitaki kantakaawori Tajorentsi pawa noñaantakari intsipaete.” ");
INSERT INTO cpy_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ikantanaki Isaac: “Pipoki okaakiini nopampitawakimi, niyotantemiri eerokarika notyomi Esaú.” ");
INSERT INTO cpy_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Pokapaaki okaakiini Jacob ipampitawakiri ipaapate. Ikantzi Isaac: “Aripaantewaetaki iñaawaetzi Jacob, rooma rakojampi riiwaewitaka Esaú.” ");
INSERT INTO cpy_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tee riyotawakiri, tema witzipako ikantaka ariwaewitaka rirentzi Esaú. Roojatzi ipasonkiwentantanakari. ");
INSERT INTO cpy_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Rapiitanakiri rojampitziri, ikantziri: “¿Eerokama notyomi Esaú?” Ikantzi Jacob: “Jeen, naakataki Esaú.” ");
INSERT INTO cpy_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ikantanakiri ipaapate: “¡Notyomí! Poyiitenari piyentane nowawakyaata, roojatzi nopasonkiwentemi.” Royiitakiniri owanawontsi ipaapate. Ramakiniri eejatzi imiri. Rowawakawo Isaac rirakiro imiri eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Roojatzi ikantantanakariri: “Pipoke okaakiini notyomi, pontsirokena.” ");
INSERT INTO cpy_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ikanta rontsirokapaakari Jacob ipaapate, ikemaenkatawakiro Isaac iithaari. Ipasonkitakotakari, ikantaki iñaanatziri: Riitaki jankahaentsiri notyomi. Oshiyaakawo ojankahani owaantsi itajonkawentziri Tajorentsí. ");
INSERT INTO cpy_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Riitaki Tajorentsi owaryaapiintemironi inkani. Riitaki kithokitakaaperoteemironi piwankiri. Osheki okanteeya piwankiripaeni, eejatzi piimiri. ");
INSERT INTO cpy_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Osheki omperawaeteemini, Ipinkathayiteemi poñaayitachari otsipaki nampitsi. Peewayiteeri pirentziperotari eeroka, Ipinkatheeteemi eejatzi. Ikaate kijimawaetemini, aritaki imaetakiri rirori. Riima ikaate kimoshirewentakimini eeroka, imaeteeri eejatzi rirori. ");
INSERT INTO cpy_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ikaatakiro Isaac ipasonkitakotakari itomi Jacob. Roo ishitowanakitziini Jacob ijeekira ipaapate, areetapaaka Esaú riyaatzira raamawenta. ");
INSERT INTO cpy_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ronkotsitaki eejatzi owanawontsi, ramakiniri ipaapate, ikantapaakiri: “Pipiriinte pawa, poyaa tsimeri ikentakiri pitomi, pipasonkitakotena.” ");
INSERT INTO cpy_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ari rojampitanakiri Isaac, ikantanakiri: “¿Jempe pitaka eeroka?” Ikantanaki rirori: “Naakataki Esaú, pantarite pitomi.” ");
INSERT INTO cpy_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Iyokitzi ikantanaka Isaac, riraashirenkanaka iñaawaetanaki, ikantanaki: “¿Iitakama pokaentsiri amakinariri itsimerite, nowawakari tekira pareetapaakaata eeroka? Nopasonkitakotakirira, tajonkawentaarewo rinanaki rirori.” ");
INSERT INTO cpy_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ikanta ikemawakiro Esaú ikantakiriri ipaapate, okatsitzimotanakiri, antawoete riraawaetanaka, ikantanaki: “Pipasonkitakotzitena eejatzi naaka, ashitanari.” ");
INSERT INTO cpy_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ikantanaki Isaac: ‘Pirentzira amatawitakinari, nopasonkitakotzimaetakari rirori, tema eerokawitaka nopasonkitakotemi.” ");
INSERT INTO cpy_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Rakanaki Esaú: “Tema iitaha Jacob, apite ramatawitakina. Retakawo raapithatakinawo neewatantari notzimaki, raapithatzitakinawo pipasonkiwentenami nimaeka. ¿Eeroma omataa pipasonkiwentawaena naaka?” ");
INSERT INTO cpy_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ikantanaki Isaac: “Nowakirira pirentzi Jacob reewateemi eeroka, riitaki omperateeyaarini pisheninkathoripaeni, noshekyahaeniri iwankiri, ari oshiyawo eejatzi imiri. ¿Jempema nokanteemika eeroka notyomi?” ");
INSERT INTO cpy_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Eekiro ikantanakitzi Esaú: “¿Tema okameethatzi pipasonkitakotzitena naaka, ashitanari? Pipasonkitakotzitena eejatzi naaka.” Rapiitaneero riraawaetanaa. ");
INSERT INTO cpy_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Ikantanaki Isaac: Pinampiteeyaawo inteena, Eero pinampitaawo okaakiini añaapathatzira kepatsi, oparyaayitzira eejatzi inkani. ");
INSERT INTO cpy_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Rootaki pojataamento pipiyawentanteeyaari. Romperawaeteemi pirentzi. Roo kantacha, aririka piroperotee eeroka, Arira pijeekashiwaeteeya. ");
INSERT INTO cpy_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Aripaete retanakawo Esaú ikijaneentziri rirentzi Jacob, ipasonkitakotakirira ashitariri. Ikantashiretanaki: “Arika ikamaki intsipaete ashitanari, aripaete nompojeri yeeyi Jacob.” ");
INSERT INTO cpy_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yotzimaetaka Rebeca oeta ikenkithashiretari Esaú, okaemakaantakiri Jacob, okantakiri: “Ikowatziira pirentzi rompojemi. ");
INSERT INTO cpy_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Pikemijantena notyomi nokantemiri. Piyaate inteena janta Harán-ki, ijeekira aarini Labán. ");
INSERT INTO cpy_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ojamani pikantya pijeekawaete janta awijawaeta imashirenka pirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ipeyakotawaeroota okaatzi pantakiri. Aritaki nokamanteemi pipiyanteeyaari. Tee nokoyi nopeyashityaari apite notyomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Okantakiri Rebeca oemi Isaac: “Osheki nojamashiryaakawo rishinto Het-ite iinatakari Esaú. Roojatzirika rayeri Jacob oshiyakawori iroka nampitawori Canaán-ki, okamethatzi nokamapithatero.” ");
INSERT INTO cpy_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Ikanta Isaac ikaemakiri Jacob, ipasonkitakoteeri, ikantziri: “Eerowa piinantawo tsinani nampitawori jaka Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Piyaate Padan-aram, inampiki picharini Betuel, paye rishinto pikonkiri Labán. ");
INSERT INTO cpy_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Riitaki tajonkawentemini Tajorentsi oshekitzimotziri ishintsinka, roshekyaakimiri pitomipaeni, riitaki inashiyitariri sheninkatawakahaachari maawoeni jemperikapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Rijatzi tajonkawenteemini eeroka, eejatzi pitomipaeni, tema riitaki kashiyaakaakimirori paerani picharinini Abraham, pashiteeyaawo maawoeni kepatsi ajeekakira nimaeka kaari ashita aakapaeni. Tema rootaki ikashiyaakaakiriri Tajorentsi paerani Abraham.” ");
INSERT INTO cpy_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Rotyaantakiri Isaac itomi Jacob janta Padan-aram-ki. Ikanta Jacob areetaka ipankoki rikonkiri Labán, itomi Betuel Aram-jatzi iyaariri Rebeca, riniro Jacob eejatzi Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iñaakowentakiri Esaú ipasonkiwenteetziri Jacob, rotyaanteetakiri Padan-aram-ki raye iina. Iñaakiri eejatzi Esaú ipaapate ikaminayiri Jacob eero iinantantawo tsinani Canaán-jato. ");
INSERT INTO cpy_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Jataki Jacob Padan-aram-ki, imatakiro okaatzi ikantakiriri ipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Antawoete ikenkithashirewaetanaka Esaú teera inimoteri ipaapate okaatzira iina apite Canaán-jato. ");
INSERT INTO cpy_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Rootaki riyaatantakari iñeeri Ismael, rijatzi itomi Abraham. Raapaakiro rishinto iitachari Majalat, irento Nebaeot, okantawitaka otzimi apite iina Canaán-jato. ");
INSERT INTO cpy_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jataki rirori Jacob janta Harán-ki ipoñaanakawo Beerseba-ki. ");
INSERT INTO cpy_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ikanta riweyaaka niyankineki awotsi ari imaapaaki, tema tsirenitanaki. roepinaakiro omaryaakaa mapi, rotziitotakawo, maanaki. ");
INSERT INTO cpy_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ari imishiwaetakiri, iñaaki pawitsi okinapaakiro jenokita inkiteki roojatzi kepatsiki. Ari rayiiteeyini ronampiri tajorentsite pawa, ari rateeteeyaneeni eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Iñiitakari eejatzi Tajorentsi ikatziyimotakari okaakiini, ikantziri iñaanatziri: “Naakataki Tajorentsi, Itajorentsite picharinini Abraham, eejatzi ashitzimiri Isaac. Aritaki nashitakahaemiro iroka kepatsi, ari nokanteeri eejatzi pitomipaeni rashiteeyaawo iroka kepatsi pomaryaakaha. ");
INSERT INTO cpy_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Osheki ikanteeya riroripaeni roshiyeeyaawo oshekitzi impaneki. Ithonkya inampiteeyaawo katonkonta, kirinkanta, ishitowapiintzira ooryaa eejatzi ikyaapiintzira. Tema eeroka kantakaeyaawoni notajonkawentanteeyaariri maawoeni inashiyitachari isheninkapaeni jaka kepatsiki. Ari ikanteeyaari eejatzi pitomipaeni riitaki kantakaeyaawoni notajonkawentanteeyaariri maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Naakataki tsipatapiintakimiri, aritaki nokempoyaawentakimi jemperika pikinayite. Aritaki nomatakiro noepiyeemi jaka pijeekakira. Otzimatye nomonkaatero okaatzi nokantakimiri, eero nookawentzimi.” ");
INSERT INTO cpy_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ari ikakitanaki Jacob imishiwaetzira, ikantashiretzi: “Omaperotatyaama ijeeki Tajorentsi jaka, teera niyowita.” ");
INSERT INTO cpy_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Antawoete ithaawanaki, ikantashiretzi: “Tajorentsipathaha ini jaka. Ipanko inatzi Tajorentsi. Otzimatye aki jaka aatantyaari inkiteki.” ");
INSERT INTO cpy_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ikanta ipiriintamanaa Jacob okitejitamaneera, raakiro mapi rotziitotakari, ipiriintathantheenatakiro. Ijeetantanakawo yeenkantsi itajonkawentanakiro. ");
INSERT INTO cpy_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Jeekawitachari janta nampitsi iiwiitawo Luz, rowashiñaanakiro owaero, iitanakiro rirori Bet-el. ");
INSERT INTO cpy_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Iñaawaetanaki Jacob, ikantanaki: “Itsipatana Tajorentsi, ikempoyaawentana jempe nokinayitzi, ipakina nowanawo, nokithaayitari eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Tekatsirika awijimotenani, aririka nopiyaki ipankoki ashitanari, notajorentsiteteeyari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Iroka mapi nopiriintathantheenatakiri, pipanko ini, Tajorentsi. Okaate pashitakahaenari naaka, ari noepiyakimi eepichokiini.” ");
INSERT INTO cpy_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Eekiro riyaatatzi Jacob ranashita, areetaka iipatsiteki nampitawori ishitowapiintzira ooryaa. ");
INSERT INTO cpy_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ikanta rareetaka owaantsiki ojeekira nijaateni, iñaapaaki osheki oveja rireeyini nijaa, mawa ikaatzi rinashiyitaka ipiyoteeyakani. Antawo ini mapi rashitakotanteetawori nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ikanta ipiyoteeyaanira koeratziriri oveja, raapithatawakaakawo ashitawo. Arika ithonkakiro imiritakaeri ipirapaeni, eejatzi rashitakotaneero nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Rojampitapaakiri Jacob koeratziriri oveja, ikantziri: “¿Jempe pipoñaaka eeroka asheninka?” Ikanteeyini rirori: “Harán-jatzi nineeyini.” ");
INSERT INTO cpy_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Rapiitanakiri rojampitziri: “¿Piñiiri eerokapaeni Labán itomi Nacor?” Ari rakaeyanakini: “Noñaatatziri.” ");
INSERT INTO cpy_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Eekiro ikantatzi Jacob: “¿Tee imantsiyawaetzi?” Ikanteeyini koeratziriri oveja: “Tekatsi ikanta Labán. Paminero jantó, rootakira rishinto pokaentsiri amakiriri ovejate, oeta Raquel.” ");
INSERT INTO cpy_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ikantanaki Jacob: “Eenitatsira okitejitzi tekiraha otsirenitziita pashitakotantyaariri povejate. ¿Iitaka kaari pipantari imiri, pitziyeri eejatzi?” ");
INSERT INTO cpy_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ikanteeyini riroripaeni: “Eero nomatziro, otzimatye noyeeri itsipa koeratziriri rovejate naawyaantyaawori noshirinkiro ashitawo nijaa. Nopantyaariri imiri ovejapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ikenkithawaemintheetzi Jacob, areetakaapaakari Raquel rovejate opaapate, rootakira koeratziniriri. ");
INSERT INTO cpy_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ikanta iñaawakiro Jacob iinathori Raquel areetakaapaakari rovejate rikonkiri Labán, jatanaki roshirinkiro ashitawo nijaateni, ipakiri imiri ovejapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Riwethatawakawo Raquel ithowootawakiro, rirayimotawakawo. ");
INSERT INTO cpy_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ikanta ikamantapaakiro Jacob riira otomi Rebeca, itzinerira rini Labán, iyaatashitanakiri Raquel opaapate, okamantapaakiri. ");
INSERT INTO cpy_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ikemakowentawakiri Labán itzineri Jacob, otomi ritsiro, ishiyashitanakari, rawithakitapakiri, iwethatawaakari eejatzi, raanakiri ipankoki. Ari ikenkithawaetakaapaakiri Jacob rikonkiri ikamantakiri okaatzi awijimotakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ikantanaki Labán: “Eerokataki nosheninka okaakiini, ari poshiyana naaka.” Apaani kashiri ijeekawaetapaaki Jacob ipankoki Labán. ");
INSERT INTO cpy_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Omapokashitaka, ikantakiri Labán: “Tee inimotena eerorika nopinatzimi pantawaeri, nosheninkathorira pini. Pikantena jempe ikaateka pikoyiri nopinatemiri.” ");
INSERT INTO cpy_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Eenitatsi apite rishinto Labán: rantawote rishinto oeta Lea, otsipa ewonkiri oeta Raquel. ");
INSERT INTO cpy_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Amashiwaetatyaaha okiki Lea, rooma Raquel kameethanto ini roori. ");
INSERT INTO cpy_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rootaki ikowashiryaakiri Jacob iroka Raquel, ikantanaki: “Kantacha nantawaete 7 ojarentsi, nantawaewentero pishinto, Raquel.” ");
INSERT INTO cpy_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ikantzi Labán: “Rootaki kameethatatsi nopimiro eeroka, tee nokoyi noperi itsipajatzi. Pijeekapae nopankoki.” ");
INSERT INTO cpy_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Imatakiro Jacob rantawaewentakiro Raquel okaatzi 7 ojarentsi, tee iñiimaetawo ojamanitzimoteri rantawaewentakirowa, tema inintaperotatziiro. ");
INSERT INTO cpy_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Okanta omonkaataka 7 ojarentsi, ikantakiri Jacob rikonkiri Labán: “Pipenawowa pishinto noenantyaawo, nomonkaatakiro nokantakiri paerani okaate nantawaewentero.” ");
INSERT INTO cpy_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ikaemakaantakiri Labán nampitawori janta, ipokaki maawoeni ikimoshireteeyini aawakaeyaaha rishinto Labán. ");
INSERT INTO cpy_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Okanta otsirenitanaki, raanakiro rishinto Lea, ipakiri Jacob, imaantakawo. ");
INSERT INTO cpy_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ipakiro Labán rishinto Lea apaani romperatane oeta Zilpa, rootakira omperaantyaari. ");
INSERT INTO cpy_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Okanta okitejitamanaki iñaatziiro Jacob imaantashitakawo Lea. Riyaatashitanakiri Labán, ikantakiri: “¿Iitaka pikoshekantanari? Kaarira Lea nantawaewente, Raquel-ra nantawaewentaki. ¿Iitaka pamatawitantanari?” ");
INSERT INTO cpy_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Rakanaki Labán, ikantziri: “Tee rameteetawo jaka iimintakahaetyaawo ewonkiri shintotsi tekirarika oemintyaata etawori otzimaki. ");
INSERT INTO cpy_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Payero Lea, arira nopakimiro eejatzi Raquel, otzimatye pantawentawaero eejatzi okaate 7 ojarentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ari ikantakiro Jacob, raakiro Lea. Rayitaawo eejatzi Raquel. ");
INSERT INTO cpy_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ipakiro eejatzi Raquel apaani romperatane oeta Bilja, rootaki omperaantyaari. ");
INSERT INTO cpy_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Imatakiro Jacob raakiro Raquel. Rootaki ikowaperotakiri awijanakiro ikoyiro Lea. Eejatzira rantawaeteeniri Labán okaatzi 7 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ikanta iñaakiri Tajorentsi imanintawaetziro Lea, itzimakakiro otomipaeni. Rooma Raquel tee okanta otzimi roori. ");
INSERT INTO cpy_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Okanta omotzitaki Lea, otzimakiri otomi iiteetakiri Rubén, tema okantashiretakitzi roori: “Iñaakina Tajorentsi nowashiretakowaetaka, rootaki ikowantakinari noemi.” ");
INSERT INTO cpy_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ari apiitanakiro Lea omotzitee, otzimani otomi, iiteetakiri Simón. Ari okantashiretanaki roori: “Iñaakina Tajorentsi imanintawaeteetanaha, rootakira rowaeyakaantanariri itsipa notomi.” ");
INSERT INTO cpy_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Eejatzi apiiteero omotzitee, otzimakiri itsipa otomi, iiteetakiri Leví. Tema okantashiretakitzi: “Itsipaperoteenaata noemi, tema notzimakiniri mawa itomi.” ");
INSERT INTO cpy_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Eejatzi itzimawae itsipa eentsite Lea, iiteetakiri Judá, tema okantashiretanakitzi: “Nomampaawentaari Tajorentsi.” Ari okaatapaaki tzimanitaki. ");
INSERT INTO cpy_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Okijaneentanakiro Raquel irento Lea oñaakirowa tee otzimaanitzi roori, okantakiri oemi Jacob: “Nokowaki pitzimakayina naaka, eerorika pitzimakaashitana, arira nokamaki.” ");
INSERT INTO cpy_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ari ikijanakiro Jacob Raquel, ikantanakiro: “¿Naakama Tajorentsi pikantantanari? Pikowakoteri rirori riitakira maanirotakayimiri.” ");
INSERT INTO cpy_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Okantanaki: “Pitsipatyaawo nomperatane Bilja. Arika itzimaki otomipaeni, noshiyakayeri naakami tzimakirini” ");
INSERT INTO cpy_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Opakiri Raquel oemi onampiri Bilja, itsipatyaawo. Imatakiro Jacob itsipatakawo Bilja. ");
INSERT INTO cpy_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tzimanaki apaani itomi Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ari oñaawaetakiri Raquel, okantaki: “Irika eenchaaniki iitya Dan, tema ikemakina Tajorentsi nokowakotakiri, owakowentaawo nini, ipakinaha apaani notyomi.” ");
INSERT INTO cpy_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ari apiitakiro Bilja otzimaki itsipa itomi Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Okantanaki eejatzi Raquel: “Irika eenchaaniki iitya Neftalí, tema osheki nokoshekakawo eentyo, notsinampaakiro.” ");
INSERT INTO cpy_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Okanta oñaaka Lea tee otzimaanitane roori, okantakiro onampiri Zilpa itsipatyaawo Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Otzimakiri Zilpa itomi Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Okantaki oñaawaetanaki Lea: “Okaminthaamatsitakina.” Rootaki iitantyaari eenchaaniki Gad. ");
INSERT INTO cpy_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Eejatzi apiitakiro Zilpa otzimakiri itsipa itomi Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ari okantanaki Lea: “Kimoshiretaantsi ini. Nimaeka okantayitaki tsinanipaeni kimoshireri nokantaawo naaka.” Rootaki iitantyaari eenchaaniki Aser. ");
INSERT INTO cpy_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ikanta riyaataki Rubén rowaneki rowiiwaetzi. Ari oñaaki iwenkiniro, ramakiniro riniro Lea. Okanta oñaawakiro Raquel iwenkiniro, okantakiro Lea: “Pipena eepichokiini ramakiri pitomi.” ");
INSERT INTO cpy_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Okantanaki Lea: “¿Tekirama inimotzimiita paapithatakinarira noemi? Eekiro pikowatzi paapithatenawo iwenkiniro ramakinari notyomi.” Okantanaki Raquel: “Arika pipakina ramakimiri pitomi, arira itsipatakimi Jacob tsireniriki.” ");
INSERT INTO cpy_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Okanta otsirenitanaki, areeta Jacob ipoñahaawo rowaneki, oshiyashitawakari Lea, okantawakiri: “Otzimatye pitsipatapaena opinatyaari iwenkiniro ramakinari notyomi.” Imatakiro Jacob itsipatapaawo Lea. ");
INSERT INTO cpy_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Ari otzimakiri 5-taneentsiri itomi Jacob, tema ikemakiniro Tajorentsi okowakotakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Oñaawaetanaki Lea okantzi: “Irika eenchaaniki iitya Isacar, tema riitaki Tajorentsi pakinariri, okantakaantziro nopiyoteetarira noemi notsipayitakawo nomperatanepaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Omotzitaki Lea itsipa itomi Jacob, riira 6-tanaentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Okantanaki: “Ineshironkatakina Tajorentsi, ipakina kameethantzi notyomi. Ikowaperotakina nimaeka noemi, tema notzimakiniri 6 itomipaeni.” Rootaki oetantariri irika eenchaaniki Zabulón. ");
INSERT INTO cpy_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ari oweyaantawaawo Lea otzimae ishinto, oetakiro Dina. ");
INSERT INTO cpy_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ikanta Tajorentsi ikenkithashiretanakiro Raquel, imatakiniro okowakotziriri, tzimanite. ");
INSERT INTO cpy_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Okanta otzimakiri etanakawori otomi, okantanaki: “Rookapithatakinawo Tajorentsi nokaaniwentawaetaha tee notzimi eentsite. ");
INSERT INTO cpy_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Inkamintha ikowakakina notzimae itsipa.” Rootaki iitantakariri José otomi. ");
INSERT INTO cpy_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ikanta otzimakiri Raquel otomi José, ikantakiri Jacob rikonkiri Labán: “Pishineteena niyaatee nonampiki. ");
INSERT INTO cpy_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pipawaenari notyomipaeni eejatzi noenapaeni, rootakira nantawentakiri. Pishineteena niyaatee. Tema piyotakiro jempe nokanta nantawaetapiintaki.” ");
INSERT INTO cpy_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Rakanaki Labán, ikantzi: “Niyotaki naaka, itajonkawentakina Tajorentsi pikantakaantakiro eeroka. Eero piyaatzi, thame anampityaawo jaka. ");
INSERT INTO cpy_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Pikantena pikoyirika nopinatemi pantawaetanaha, aritaki nopinatakimi.” ");
INSERT INTO cpy_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ikantanaki Jacob: “Piyotziro eeroka jempe nokantaka nantawaetapiintaki, nokoeratzimiri pipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Teera ishekitzi paerani tekira nopokanakiita naaka jaka. Rooma nareetakaha naaka ari roshekitanakiri pipirapaeni, itajonkawentakimi Tajorentsi. ¿Jempepaeteka otzime nowakaeyaariri nashi notyomipaeni?” ");
INSERT INTO cpy_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Eekiro ishintsitatzi Labán ikantziri: “¿Jempe ikaatzika pikoyiri nopinatemiri?” Ikantzi Jacob: “Tee nokoyi pipinatena. Aritaki napiiteero nokoerateemiri pipirapaeni, otzimatyee inimotemi eeroka nokantemiri. ");
INSERT INTO cpy_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Pishinetena niyaate pipiramashiki niyoshiiteri iryaani oveja ikaatzi cheenkayitatsiri. Niyoshiiteri eejatzi iryaani cabra karinayitatsiri, eejatzi inashiyitachari iyarinanka, riira inashityaari, pipinatenari nokoeratzimirira pipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ari aminiiro paata okaate pipinatenari, eero nayitzimiri. Ari piñaakiri nopirapaeni cabra riyoshitya karinari, inashiwaeyitachari iyarinanka. Piñeeri eejatzi novejate cheenkaripaeni rini. Piñaakiririka kitamaari, kaari karinatatsini, piyote pashira eeroka.” ");
INSERT INTO cpy_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ikantanaki Labán: “Ariwé, kameethataki pikantanari.” ");
INSERT INTO cpy_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Rinashitanakari Labán ipirapaeni cabra ikaatzi karinayitatsiri, eejatzi ikaatzi inashiyitachari iyarinanka. Rinashitzitakari eejatzi rovejate cheenkayitatsiri. Ipakiri itomipaeni ipiratyaari. ");
INSERT INTO cpy_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Raanakiri inteena ipirapaeni, okaatzi mawa kitejeri ranashitakaakari, rinashitaka ijeekakaakiri. Roojatzi ijeekanaki rirori Jacob ikoeratziniri Labán ipirapaeni kaari karinatatsiri, kaari cheenkatatsini. ");
INSERT INTO cpy_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Raaki Jacob eeritonki inchashithaki, ishaakakiro iñahaetantyaawori okitamaashithakite. ");
INSERT INTO cpy_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Rowayitakiniri piratsi inchashithaki rowamentoki, imirimentoki eejatzi, ro rowawiyaantantyaari ipokaeyinira rire imiri. ");
INSERT INTO cpy_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ikanta rowaeyanaka ipira, rinashiyitanaka iyarinanka. ");
INSERT INTO cpy_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Rinashitzimaetakari Jacob inashitachari iyarinanka, eejatzi ikaatzi cheenkayitatsiri oveja. Rinashitakari ipira Labán. Ari ikantapiintatziiro Jacob rinashitari rashitari rirori. ");
INSERT INTO cpy_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Eekiro riyaatakaatziiro Jacob royiniri inchashithaki wathayitatsiri piratsi, aririka ipokaeyeni imirimentoki. Ikine raminero inchashithaki aririka rowawiyaantawakaeya. ");
INSERT INTO cpy_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Rooma ipokayitzira mathari ipira, tee royiniri inchashithaki. Riitakira rashitari Labán ipirapaeni mathayitatsiri, riima wathayitatsiri rashi Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Rootaki roshekitzimotantakariri Jacob ipirapaeni, osheki eejatzi ronampiripaeni. Antariite ashaahantzinkari rinanaki. ");
INSERT INTO cpy_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ikemaki Jacob ikenkithawaetzi itomipaeni Labán, ikanteeyini: “Raapithatakaeri Jacob maawoeni ipirapaeni apaapate, rootakira rashaahantantakari.” ");
INSERT INTO cpy_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Iñaakiri Jacob ikijashiryaawaeta rikonkiri, tee raakameethateeri ikimiwitarira paerani. ");
INSERT INTO cpy_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ikanteeri Tajorentsi irika Jacob: “Pipiye iipatsiteki pipaapate ijeekayitzira pisheninkapaeni, eerowa nookawentzimi.” ");
INSERT INTO cpy_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ikaemakaantakiro Jacob apite iina, Raquel eejatzi Lea, opokashitakiri ijeekira irirori owaantsiki ikoeratziri rovejatepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ikantawakiro: “Noñaakiri pipaapate tee raakameethateena ikimitaanaha paerani. Roo kantacha itsipatapiintakina Itajorentsite ashitanari naaka. ");
INSERT INTO cpy_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Piyoteeyini eerokapaeni kameetha nantawaetapiintakiniri pipaapate, nomatakiro okaatzi naawyaakiri naaka. ");
INSERT INTO cpy_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Osheki ramatawitapiintakina, tee imonkaatziro ipinatena ikantakinari. Ikamintha Tajorentsi tee ishinetziri rowaariperotena. ");
INSERT INTO cpy_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tema aririka ikante: ‘Riira nopirapaeni karinayitatsiri nopinatemiri,’ maawoeni tsinani piratsipaeni otzimanakiri karinayitatsiri. Arika ikante: ‘Nopinatemiri nopirapaeni thapayitachari iyarinankari,’ otzimanakiri maawoeni thapayitachari. ");
INSERT INTO cpy_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Arira ikinakaakiro Tajorentsi raapithatziri ipirapaeni, roshekyaakinari nashi naaka. ");
INSERT INTO cpy_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Tema antawoteeyinira piratsi, ari romishimpyeetakina, noñaakiri rowawiyantawakaeyaani kaninayitatsiri piratsipaeni, eejatzi kantawaeyitachari othapayita iyaninanka. ");
INSERT INTO cpy_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Arira iñaanatakina eejatzi nomishiriki ronampiri tajorentsite Pawa, ikantakina: ‘Jacob.’ Ari nakanakiri naaka, nokantanakiri: ‘Iitaka.’ ");
INSERT INTO cpy_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ikantanakina ronampiri tajorentsi: ‘Pikempoyahaeri kameetheeni piratsipaeni. Arira piñaakiri ikaatzi owawiyanteenchari, ikaninayite. Tema noñaakiro maawoeni rantzimotakimiri Labán. ");
INSERT INTO cpy_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Naakatakira Tajorentsi oñaahakimiri paerani Bet-el-ki, pamanakotanakawowa paerani mapi pikenkithashiretantyaawori pikantakinari. Pikatziye, piyaatee pinampiki pitzimakira paerani.’” ");
INSERT INTO cpy_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ari akanakiri Raquel otsipatakawo irento Lea, okantanakiri: “Tekatsi rashitakayinari ipankoki nopaapate. ");
INSERT INTO cpy_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tema roshiyakaakina pashinijato ninayitzi. Ipinatakina, anintaakawo okaatzi pantawaetakiniriri pipinawentana naaka. ");
INSERT INTO cpy_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Omaperotatya ashitaawo maawoeni rashaahawo nopaapate okaatzi ipakimiri, roojatzi rashitaari eejatzi otomipaeni. Pimatero okaatzi ikantakimiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Ari ikatziyanakari Jacob, ikyaakahaeyanakarini ipira itomipaeni eejatzi iinapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Jatee inampiki ipaapate Isaac janta Canaán-ki. Rahaeyanakirini maawoeni ipirapaeni ikaatzira ramanantakiri ipineetziriri rantawaetakira Padan-aram-ki. ");
INSERT INTO cpy_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Riyaamintheetzi Labán rameetziri rovejatepaeni, ayitanakiri Raquel itajorentsitetashitari opaapate. ");
INSERT INTO cpy_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Rootaki opoñaantari imatantakawori Jacob ramatawitakiri Labán, irika Aram-jatzi. Tee ikantanakiri rooteentsi riyaatee. ");
INSERT INTO cpy_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ishiyakahaawo maawoeni tzimimotakiriri. Intsipaete imontyaanakawo nijaa Eufrates, roojatzi rareetantakari tonkaariki iiteetziro Halaad. ");
INSERT INTO cpy_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Okanta awijaki mawa kitejeri, ari riyotaki Labán shiyaaha Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ikamantakiri isheninkapaeni, jataki royaatawakiri. Roo awijaki 7 kitejeri royaatawakiri janta tonkaariki Halaad-ki. ");
INSERT INTO cpy_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Okanta otsirenitanaki roñaahakari Tajorentsi irika Labán iiteetziri Aram-jatzi imishiriki. Ikantakiri: “Eero pishintsithatziri piñaanateri Jacob.” ");
INSERT INTO cpy_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Rareetawaari Labán itzineri Jacob janta Halaad-ki, ipankoshetatapaakaha. Ari ipankoshetatapaakari eejatzi Labán itsipayitakari isheninka. ");
INSERT INTO cpy_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Iñaanaminthatakiri Jacob, ikantziri: “¿Iitaka pantakiri? ¿Iitaka pamatawitantanari? Pamapithatakinawo nishintopaeni, poshiyakotakari inoshikantzi owayiri-paeni. ");
INSERT INTO cpy_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Iitaka pamatawitantakinari, pomananekiini pishiyaka? Tee pikamantaajaetanakina. Arimi pikamantakinami, antawoete noemoshirenkawakimimi, niweshiryaawentawakimi, noshowiwentawakimi, oyameñeenkate thatanentsi. ");
INSERT INTO cpy_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Teemacheeni niwethatawaeyaawo nishintopaeni, nocharinipaeni, nokowawitaka nothowootawaerimi. Poshiyakotakarira rantziri majontzi. ");
INSERT INTO cpy_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nokowawitaka, nowaariperowaetemimi maawoeni eerokaete. Roori kantacha inkaahanki tsireniriki iñaanatakina Itajorentsite ashitzimiri, ikantakina: ‘Eerowa pishintsithatziri piñaanateri Jacob.’ ");
INSERT INTO cpy_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Pikowaperowitaha piyaatee inampiki ashitzimiri, eero payitanarimi notajorentsitetari” ");
INSERT INTO cpy_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ari rakanakiri Jacob rikonkiri Labán, ikantanakiri: “Osheki nothaawantakimi. Noshiyakaamintheetzi ari paapithatawakinawo pishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Eenitatsirika amakiriri pitajorentsite, ¡ikamera! Iñeeriita asheninkapaeni. Eenitatsirika namapithatakimiri pashitari eeroka, paanakiri.” Tee riyotzi Jacob rootaki Raquel amapithatakiriri itajorentsite opaapate. ");
INSERT INTO cpy_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Ikyaanaki Labán ipankoshetaki Jacob, eejatzi ashiki Lea, eejatzi ikantakiro ashi omperatanepaeni eejatzi, teemaeta iñiiri itajorentsite. Ari ikyaanaki ashikira Raquel, ");
INSERT INTO cpy_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","rootaki amakiriri itajorentsite opaapate, omanakiri ikyaakomentoki piratsi, ojeekakotzimaetakari. Ikanta ithotyaakowitakari opaapate, tee iñiiri. ");
INSERT INTO cpy_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ari okantanakiri Raquel opaapate: “Ashitanarí, tee nokoyi pikijya eerorika nokatziya nojeekira, noñaawentatyaaha.” Tema ithonkakiro ithotyaakowitakari Labán itajorentsite, teemaeta iñiiri. ");
INSERT INTO cpy_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Arira ikijanakari Jacob, ikantanakiri Labán: “¿Iitaka nantzimotakimiri? ¿Eenitatsima kaariperori nantakiri opoñaantari poyaatantanari? ");
INSERT INTO cpy_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pithonkakiro paminahaantakina. ¿Piñaakiroma okaatzi pashitari eeroka? Powero jaka iñaantyaawori pikaateeyakinira, iñaantyaawori nokaatakira naaka eejatzi. Rootaki riyotantyaari riroripaeni itzimirika kinakaashiwaeteenchari. ");
INSERT INTO cpy_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Piyote eeroka okaatzi 20 ojarentsi nantawaetaki pipankoki, tee piñiiri ipeyaaniwaetya pipira, tee nowaaneenta apaani. ");
INSERT INTO cpy_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Teera piñeena namemiri ikaatzi ratsikiri owaminthatariri, nopinatzimiri pikowakotanarira peyaenchari. Pikowakotanari eejatzi ikaatzi ikoshiteetziri tsireniriki eejatzi kitejeriki. ");
INSERT INTO cpy_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ayimawaetakina nomiri ooryaapaeteki, ayimatakina nowatsinkare tsireniriki, eejatzi nowochokini. ");
INSERT INTO cpy_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tema okaatzi 20 ojarentsi nojeekimotakimi pipankoki. Iroka okaatzi nantawaetaki: 14 ojarentsi nantawentakiro apiteka pishinto, eejatzi 6 ojarentsi nantawentakiri pipirapaeni. Tee pimonkaatero pipinatena pikantakinari. ");
INSERT INTO cpy_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Eeromi itsipatana Itajorentsite Abraham, Itajorentsitetari eejatzi ashitanari, tekatsimi namakimi nimaeka. Roo kantacha iñaakina Tajorentsi nowashiretakowaetaka, kameethari okantaka nantawaeri, rootaki ikijantakimiri tsirenipaeteki.” ");
INSERT INTO cpy_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ikanta Labán rakanakiri Jacob, ikantanakiri: “Okaatzi nishintotari naaka, nishinto ini. Ikaatzi nochariniyitari naaka, nocharini rinayitzi, ikaatzi nopirayitari naaka, nopira rinayitzi. Maawoeni piñaayitziri nimaeka, nashi rini. Roo kantacha, ¿kantachama nokoshekyaawo nishintyopaeni, eejatzi ikaatzi powakaakirori? ");
INSERT INTO cpy_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Pipokanakiita, thame akenkithawaete oeta anteri, rootaki iñeeri ikaatzi aminaminthatakaeri.” ");
INSERT INTO cpy_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ari itzinaanakiro Jacob apaani mapi, ipiriintathanthaatakiro. ");
INSERT INTO cpy_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ikantanakiri isheninkapaeni: “Pipewireero mapi.” Ramaeyapaakini mapi, ipewiryapaakiro. Ari rowaeyakani. ");
INSERT INTO cpy_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Rootaki iitakiri Labán iñaaniki rirori “Jegar Sajaduta,” riima Jacob iitakiro iñaaniki rirori “Galaad.” ");
INSERT INTO cpy_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ari ikantanaki Labán: “Iroka piyoteenchari mapipaeni, rootaki oshiyakawori aminaminthatatyeemi okaatzi antayitakiri.” Rootaki oetantakari janta Galaad. ");
INSERT INTO cpy_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Iitziteetakawo eejatzi “Mizpa,” tema ikantanakitzi Labán: “Riira Tajorentsi amineeni, okantawitakya eero iñaapootawakaeyita. ");
INSERT INTO cpy_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Arika powatsinaawaetero nishintyo, paminerika otsipa piina, okantawitakya tekatsi ñeemini janta, riitaki Tajorentsi ñemini.” ");
INSERT INTO cpy_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Eekiro ikenkithawaetanakitzi Labán, ikantziri Jacob: “Iroka apewiryaakiri mapi, iroka eejatzi piriinteenchari mapithantha, ");
INSERT INTO cpy_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","rootaki riyotanteetyaari, eero amatziro owaariperotawakaeya. Eero owaariperotawaka nonampiki, eejatzi pinampiki eeroka. ");
INSERT INTO cpy_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Riitaki yoteroni oetaarika antayiteri aakapaeni Itajorentsite picharinini Abraham, Itajorentsite eejatzi nocharinini naaka Nacor.” Ikanta Jacob raakotanakiri iwaero Itajorentsite ipaapate Isaac, ikantzi: “Eeroka yotatsi tee notheeya.” ");
INSERT INTO cpy_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ari itaanaki Jacob rowejate janta ochempiki, ikaemakiri isheninkapaeni rowaeyaani. Maawoeni rowaeyakani, ari imahaeyakini tonkaariki. ");
INSERT INTO cpy_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Okanta amaetyaaka, ipiriintanaka Labán ithowootaneeri icharinipaeni eejatzi rishintopaeni. Ikanta ramanakoyitanaawo, piyaanaawo inampiki. ");
INSERT INTO cpy_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Eekiro ranashitatya Jacob. Ari itonkyotakari ronampiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ikanta iñaawakiri Jacob, ikantanaki: “Rowayirite rini Tajorentsi irikapaeni.” Rootaki iitantakawori Majanaem janta itonkyotawakarira. ");
INSERT INTO cpy_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ari rotyaantaki Jacob jatatsini inampiki Seir, iipatsiteki Edom, riyaate ikamanteri Esaú rootaentsi rareeteeya. ");
INSERT INTO cpy_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Ikantawakiri rotyaantane: “Pikantenari yeeyi Esaú: ‘Owetsikaka pirentzi Jacob rantemiro okaate pomperatyaariri, rotyaantaki ñaantsi nokantemiri: “Ojamanitakira nojeekawaetaki Labán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Noshekyaakiri nopirapaeni: vaca, kawayo, oveja, nonampiripaeni: shirampari eejatzi tsinani. ¡Nowinkatharite! Notyaantatziimi iroka ñaantsi, tema nokowatzi paakameethatawaena.” ’” ");
INSERT INTO cpy_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ikanta ipiyeeyaani rotyaanteetakiri, ikantapaeri Jacob: “Nomatakiro niyaataki noñiiri pirentzi Esaú, kaakitaki itonkyotemi, ramaki 400 ratzirite.” ");
INSERT INTO cpy_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ikanta ikemaki Jacob, antawoete ithaawanaki, osheki okantzimoshiraanakari. Rootaki itsiparyantanakariri apawopaeni ratzirite, eejatzi ikantakiri ipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Tema ikantashiretanakitzi: “Arika ipokaki Esaú rowayiritawakiri apawopaeni natzirite, ishiyayitanaki itsipapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ari retanakawo ramananaka, ikantzi: “Tajorentsi, Itajorentsite nocharini Abraham-ni, Itajorentsite eejatzi ashitanari Isaac, tema eeroka kantakinari: ‘Pipiyee pinampiki, iipatsiteki pisheninkaete. Arika pimatakiro, ari nokempoyaawentakimi.’ ");
INSERT INTO cpy_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Tekatsi oetzimotena okaatzi paakameethawitakina, maperori pitsipatana. Tema apatziro naanashaatantakawo nokotzi, nomontyaantakawori Jordán. Tzimatsi nimaeka apite ikaatzi ipiyotaka natzirite, riitaki nameniri oeta noperiri. ");
INSERT INTO cpy_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Pineshironkatena eero ikoshekawaetantana yeeyi Esaú. Antawoete nothaawantakari ipoki rowayiritena, rompojayitero tsinanipaeni eejatzi eentsipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Koñaatziro nokemakimi pinkantakina paerani: ‘Naaka kantakaeyaawoni oshekitzimotantemiri. Roshekitee pitomipaeni, roshiyeeyaawo oshekitzi impaneki, tekatsi materoni riyoteri jemperika ikaatzi.’” ");
INSERT INTO cpy_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ari imaaki Jacob janta. Riyoyaanaki ikaate ipayitawakiriri rirentzi Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ipayitawakiri ipirapaeni cabra: ikaate 200 tsinani, 20 shirampari. Ipayitawakiri eejatzi oveja, ikaate 200 tsinani, 20 shirampari. ");
INSERT INTO cpy_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Ipayitawakiri eejatzi ikaate 30 camello itsipataakiri iryaani owakira tzimatsiri. Ipayiteri eejatzi vaca, ikaate 40 tsinani, 10 shirampari. Ipitakyaari eejatzi kawayo ikaate 20 tsinani, 10 shirampari. ");
INSERT INTO cpy_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ari ipayitakiri romperatane riyoshiitakiri ipirapaeni, ikantakiri: “Peewateeyeni, eerowa poyaatawakahaeyaani okaakiini, inteenaeni pikantayitya.” ");
INSERT INTO cpy_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ikantawakiri jewatanaentsiri: “Arika piñaapaakiri yeeyi Esaú, aritakira rojampitawakimi, ikantemi: ‘¿Iitaka omperatzimiri? ¿jempe piyaateka? ¿Iitaka ashitariri ipirapaeni pamakiri?’ ");
INSERT INTO cpy_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Pakanakiri pikanteri: ‘Pashi eeroka nowinkatharite Esaú, riitaki ipemiri Jacob, pomperatane. Awotsikitaki rirori rareetya.’” ");
INSERT INTO cpy_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ari ikantakiri eejatzi apitetanaentsiri, mawatanaentsiri, ari ikantakiri maawoeni rotyaantakiri aanakiriri ipirapaeni, ikantawakiri: “Arika piñaapaakiri Esaú, roojatzira pikanteriri. ");
INSERT INTO cpy_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Pikanteri eejatzi: ‘Awotsikitaki pomperatane Jacob rareetya.’” Iroka ikantaki ikenkithashirewaetaka Jacob: “Ari noetsimaryaakiri iñaawakirorika nopayiteriri. Arika iñaawakiro, ari rariperotawaena.” ");
INSERT INTO cpy_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Imatakiro Jacob reewatakiri rotyaantane raayitanakiro ipayiteriri rirentzi. Roojatzi ijeekanaki rirori maanee ipankoshetaki. ");
INSERT INTO cpy_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Katziyanaka Jacob tsireniriki, raanakiro apite iina, apite ronampiri, 11 itomipaeni. rashaatanakawo Jaboc ikinapiinteetzira. ");
INSERT INTO cpy_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ari rotyaantaki rahaetanakiro okaatzi tzimimotziriri. ");
INSERT INTO cpy_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ikanta ijeekanaki apaniroeni Jacob, ari roma-nkiyakari apaani atziri rooteentsimi ikitejitakotakayiri. ");
INSERT INTO cpy_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Ikanta iñaakiro atziri tee raawyaashitari Jacob, rompojakiri okaatzira owika ipori, ichorekapookitakiri Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ari ikantanakiri atziri: “Pipakayina, rooteentsi okitejite.” Ikantanaki Jacob: “Eerorika pitajonkawentana, eerowa nopakaemi.” ");
INSERT INTO cpy_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Rojampitanakiri atziri: “¿jempe piitaka piwaero?” Ari rakanakiri, ikantziri: “Noeta Jacob.” ");
INSERT INTO cpy_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ikantanaki atziri: “Eerowa piitaawo nimaeka Jacob. Israel piiteeya. Tema pomankiyakari Tajorentsi, ari pikanteriri eejatzi atziripaeni, ari paawyaakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ari rojampitanakiri rirori, ikantziri: “Pikantena, ¿jempe piitaka eeroka?” Ikantzi atziri: “¿Iitaka pikowantari piyotero nowaero?” Ari itajonkawenteetanakiri Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Iitanakiro Jacob janta “Peniel,” tema ikantanakitzi: “Noñaawootakiri Tajorentsi, teemaeta nokami.” ");
INSERT INTO cpy_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Shitowapaaki ooryaa roojatzi rawijantanaari Jacob Peniel-ki. Okantakaantziro ichorekapookitakirira, aashetataki ranashita. ");
INSERT INTO cpy_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Rootakira kaari rowantayitawo nimaeka Israel-paeni ichorimonkipaeni tsimeri, tema ari ichokiryahaetakiri paerani Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ikanta iñaawakiri Jacob ipokaki rirentzi Esaú ramaki 400 ratzirite, rinashitanakanawo otomipaeni Lea, ashi Raquel, ashipaeni romperatane. ");
INSERT INTO cpy_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Rootaki reewataki apite romperatane itsipataakiro otomipaeni, opoñaapaaka Lea otsipatakari otomipaeni, roo impoetapaentsiri Raquel otsipatakari otomipaeni José. ");
INSERT INTO cpy_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Anashitanaka Jacob, ri jewataneentsiri. Okaatzi 7 rapiitakiro rotziwerowanaka rokaakitapaakira Esaú rirentzi, tema antawoete ipinkathatakiri oeyootapaaka. ");
INSERT INTO cpy_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Riitaki kantacha Esaú, ishiyashitawaari rirori, rawithakitapaakiri, inintawaeri. Apitepaeni rirahaeyanakani. ");
INSERT INTO cpy_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ari raminanakiro Esaú tsinanipaeni, eejatzi eentsipaeni, rojampitziri: “¿Iitaka irikapaeni?” Ikantzi Jacob: “Riitaki itomipaeni ponampiri ipakiriri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ari opokapaaki romperatanepaeni otsipatapaakari otomipaeni, otziwerowashitapaakari, antawoete opinkathatapaakiri oeyootapaaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Okanta opokapaaki eejatzi Lea otsipatapaakari otomipaeni, roojatzi antapaakiri roori. Riitaki weyaantapaakawori ipokapaaki José itsipatapaakawo riniro Raquel, iñaapinkathatapaakiri eejatzi. ");
INSERT INTO cpy_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ari rojampitanakiri Esaú rirentzi Jacob, ikantziri: “¿jempe pikanterika pipirapaeni ikaatzi noñaawakiri?” Ikantanaki Jacob: “Riitaki pashi eeroka paakameethatantenari.” ");
INSERT INTO cpy_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ikantanaki Esaú: “¡Eero yeeyi! Eenitatsi osheki nashi. Poejokirotyaari ikaatzi pashitari eeroka.” ");
INSERT INTO cpy_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Eekiro ishintsitanakitzi Jacob, ikantziri rirentzi: “¡Eero yeeyi! Tema noñaakiro paakameethatawakina, otzimatye payeri nopashitzimiri. Tema noñaapakimira piwathaki eeroka, oshiyawitakawo riimi Tajorentsi noñaaki. Tema kameethari pikanta piwethatawakina. ");
INSERT INTO cpy_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Rootaki nokowantari payero okaatzi namakimiri nopashitemiri, tema Tajorentsi ashaakantakahaanari, tekatsi koetyiimotenani.” Ikanta ishintsinetakiri Jacob rirentzi, roetsinampaakiri Esaú rayero okaatzi ipashitariri. ");
INSERT INTO cpy_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ikantanaki Esaú: “Thame aate ajeeke jaka. Naaka jewatanakimini.” ");
INSERT INTO cpy_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ikantzi Jacob: “Piyotzi eeroka yeeyi teera ishenkaashiwaeta eenchaanikipaeni. Otzimatye nokenkithashiretakoteri eejatzi nopirapaeni tzimayitatsiri iryaani. Arika nanashitakaanakiri apaani kitejeri, aritaki ikamayitaki. ");
INSERT INTO cpy_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Rootaki kameethatatsi peewatakahaeri pomperatane, eentsikiroenira nonoshikakaeyaari nopirapaeni, neentsitepaeni, roojatzi notsipatantapakimiri janta Seir-ki.” ");
INSERT INTO cpy_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ikantzi Esaú: “Iriwé, nokoyi nopanakimi natzirite itsipatemi.” Ari ikantanaki Jacob: “Tee nokoyi, eero poñaashirenkana.” ");
INSERT INTO cpy_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tee imaapaentzi Esaú intsipaete ipiyitanaka inampiki Seir-ki. ");
INSERT INTO cpy_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Riima Jacob, jataki rirori janta Sucot-ki. Ari rowetsikapaakiri ipanko, ipankoshetatapaakiri eejatzi ipirapaeni. Rootaki iitantakawori janta Sucot. ");
INSERT INTO cpy_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Tema ipoñahaawo Jacob janta Padan-aram-ki, tekatsi awijimoterini, kameetha rareeta janta Canaán-ki. Imontetapaawo inampikira Siquem ari rowetsikapaki rirori inampi. ");
INSERT INTO cpy_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ramanantapakiro iipatsite itomipaeni Hamor, okaatzi opinatari 100 koriki. Irika Siquem riira itomi Hamor. Ari rowatzikitapaawo ipankosheta janta. ");
INSERT INTO cpy_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ari rowetsikaki taapokimentotsi, iitakiro El-Eloje-Israel. ");
INSERT INTO cpy_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Okanta Dina, ishinto Lea, iyaataki areetawo ewankawopaeni nampitawori janta. ");
INSERT INTO cpy_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ari iñaawakiro Siquem itomi Hamor Jev-jatzi rini jewatatsiri inampiki. Ishintsiwentakakaawo iñaathatyaawo. Rowaariperonta. ");
INSERT INTO cpy_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Rootaki opoñaantanakari inintaaperotanakiro Dina okowanakiri aapatziyaari. ");
INSERT INTO cpy_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ikenkithawaetakaakiri ipaapate Siquem, ikantakiri: “Piyaatashiteri ashitawori maenawo pikantakowentena, nokowatziira nayiro.” ");
INSERT INTO cpy_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Riyotaki Jacob rowaariperonta Siquem rishinto Dina. Tekatsi ikantanaki tema royaawentatziiri itomipaeni riyaateeyini ikoerateri rovejatepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Pokaki Hamor ipaapate Siquem, ikenkithawaetakaakiri Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ikanta rareeteeyapaani itomipaeni Jacob ikemapaakiro okaatzi awijeentsiri, antawo ikijanaka, tema antawoete rowaariperoteetakiri Riroripaeni iñaathatzitakarira rishinto Siquem. Tema tee oshinetaantsita okaatzi rantakiri Siquem. ");
INSERT INTO cpy_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Riitaki kantacha Hamor ikenkithawaetakaakiri itomipaeni Jacob, ikantakiri: “Ikowakirowa notomi pitsiro. Pishinetero ayiri. ");
INSERT INTO cpy_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Jame aheninkatawakaeya. Opoñaantyaari naantyaawori pishintopaeni, payityaawo nashi naaka. ");
INSERT INTO cpy_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Pinampiteeyaawo jaka atsipatawakaeya. Iroka nampitsi pashiite ini, pipimantawaeyitapaki, pamanantayite piipatsite.” ");
INSERT INTO cpy_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ikanta Siquem, ikantanakiri ashitawori eejatzi iyaariripaeni Dina: “Osheki nokowaki inimotemi. Aritaki nopakimiro okaate pikowakotenari. ");
INSERT INTO cpy_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Okantawitaka tee ameteeyaawoni apawakaeya, ari nopakimiro naaka. Otzimatyeera pishinetero ewankawo nayiro.” ");
INSERT INTO cpy_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tema rowaariperotakiro Siquem Dina, ramatawinkakiini rakanakiri itomipaeni Jacob, ikantakiri Siquem eejatzi Hamor: ");
INSERT INTO cpy_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Tee okameethatzi rayero choeni atziri kaari totathowaanikitachani, antawoete nokaaniwentakiro naakapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aritaki nakakimi aririka inimotakimi iroka: Poshiyakoyitakina naakapaeni, pitothowaanikiyitakiri maawoeni shirampari ikaatzira jeekimoyitzimiri. ");
INSERT INTO cpy_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Arira okameethataki paayitero eerokapaeni notomipaeni, nomatzityaawo naayitero pitomipaeni eerokaete. Arira atsipatawakahaeya ajeekaeyeni, apaani akantya asheninkatawakahaeya. ");
INSERT INTO cpy_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Terika inimotzimi nokantakimiri pitothowaanitya, arira niyaataki nahaatero choeni.” ");
INSERT INTO cpy_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Inimotanakiri Hamor eejatzi itomi Siquem okaatzi ikanteeyakirini riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tekatsi royaawentanakya ewankari, itothowaanikitanaka, ikowaperotanakitziiro rishinto Jacob. Tema pinkathataarewo Siquem isheninkamashiki, ");
INSERT INTO cpy_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","raanakiri Siquem ipaapate, Hamor, roojatzi janta ikyaapiinteetzira nampitsiki, jempe ipiyotapiinteeta, ikanteeyakirini atziripaeni: ");
INSERT INTO cpy_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Irikapaeni naapatziyane rineeyini, riitaki nampiyityaawoni jaka riyompariyitya, eenitatsi kepatsi jempe ijeekapaaki. Kameetha inantyaawo itomipaeni, imatzityaawo atomipaeni aaka. ");
INSERT INTO cpy_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Imatatyaeyaarika ijeekimoyitee, otzimatyeera inimoyitee ikanteeri: atothowanikiyiteeri maawoeni shiramparipaeni, rootakira rameteeyaarini riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ikaatzi rashiyitari, ipirapaeni, maawoeni ashiyiteeyaari aakapaeni. Apatziro akeri okaatzi ikoyiri, aritaki ijeekimoyitakae aakapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ikanta ewankaripaeni nampitawori janta, inimotanakiri ikantakiriri Hamor eejatzi Siquem, itothowaanikiyitanaka. ");
INSERT INTO cpy_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Okanta awijawitaka mawa kitejeri, tekira retsiyatakoperoteeta shiramparipaeni itothowaaniyitakaha, riyaateeyakini itomipaeni Jacob, Simeón itsipatanakari rirentzi Leví iyaariri Dina, raanaki rojataamento, rompojapaakiri maawoeni tekatsi piyatawakyaarini. ");
INSERT INTO cpy_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Rowamahaetzitakari Hamor itsipataanakiri itomi Siquem. Raanayiro Dina ojeekawitakaha ipankoki Siquem, jateeyeeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Jateeyanakini eejatzi itsipa itomipaeni Jacob, iñaapaakiri roma-ryaayitakaha kaminkaripaeni, ithonka raanakiro okaatzi tzimatsiri nampitsiki ipiyawentziro ritsiro rowaariperotakirowa. ");
INSERT INTO cpy_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Raanaki oveja, vaca, kawayo, maawoeni tzimatsiri nampitsiki eejatzi okaatzi tzimatsiri rowaneki. ");
INSERT INTO cpy_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ithonkanakiro tzimatsiri pankotsiki, raanakiri maawoeni eenchaaniki eejatzi tsinanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Rootaki ikantantanakariri Jacob itomi Simeón eejatzi Leví: “Pikantakaantakinaha eerokapaeni. Osheki ikijaneentena nimaeka nampitawori jaka, Canaán-jatzi, Ferez-jatzi. Arika rapatotanakya riroripaeni ikoyi ipiyawentya, ipokashitena rowayiritena. Tekatsira osheki natzirite naaka, aritaki rompojakina eejatzi notyomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ikanteeyanakini riroripaeni: “¿Kameethatatsima ikanteetero choeni mayempiro ini?” ");
INSERT INTO cpy_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ikanta Tajorentsi ikantakiri Jacob: “Piyaate pinampiteeyaawo janta Bet-el-ki. Ari powetsikapakina taapokimentotsi, tema naaka Pitajorentsite, oñaahakimiri paerani pishiyapithatantakariri pirentzi Esaú.” ");
INSERT INTO cpy_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ari ikantanakiri Jacob itomipaenipaeni eejatzi ikaatzi tsipatakariri: “Pookeri pitajorentsitetashiyitari eerokapaeni, piyaate pikaawoshite, pikithaateeyaawo otsipa piithaari. ");
INSERT INTO cpy_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Jame aate Bet-el-ki, ari nowetsikapakiri taapokimentotsi nopinkathatapakiri Tajorentsi neshironkatakinari nokemaatsiwaetakaha paerani, tema itsipatapiintakina jempe nokinayitaki.” ");
INSERT INTO cpy_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Iitakiri Jacob maawoeni itajorentsitetashiitari, ikaatzi ithayiitziri eejatzi kempitantsiki. Raanakiri Jacob maawoeni ikitatakiri inchatomashiki jeekatsiri okaakiini inampiki Siquem. ");
INSERT INTO cpy_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ikanta riyaateeyeeni Jacob, ikantakaakawo Tajorentsi ithaawaeyanakini ikaatzi nampiyitawori janta. Rootaki kaari ikoshekanteetawaari itomipaeni Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Maawoeni itsipatakari Jacob, areeteeyakani iiteetziro Luz, roojatzi iiteetzitari Bet-el jeekatsiri Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ari rowetsikapakiri taapokimentotsi, iitakiro El-Bet-el. Tema ari roñaahakari paerani Tajorentsi ishiyapithatantakariri rirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ari okamaeri paerani Débora omperatapiintane Rebeca, ikiteetakiri antamimashiki okaakitapakira Bet-el. Iitakiro Jacob janta “Alón-bacut.” ");
INSERT INTO cpy_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ikanta ipiyaa Jacob ipoñahaawo Padan-aram-ki, rapiiteero Tajorentsi roñaahaari, itajonkawentawakiri. ");
INSERT INTO cpy_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ikantakiri: “Piwaero ini Jacob, Roo kantacha eeromaeta piitaawo nimaeka jempe piiwita ketziroeni. Israel piiteeya.” Ari rowaeniri Tajorentsi otsipa iwaero Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ikantanakiri: “Naakataki Tajorentsi shintsiperori. Ari noshekyahaeri pitomipaeni eejatzi picharinipaeni Noshekyahaemiri pitomipaeni riyoshiiteeya sheninkatawakahaachani, rijatzi inashiyitaachani isheninkapaeni jemperikapaeni. Nopinkatharitakaayitakiri pitomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Aritaki nashitakahaemiro kepatsi nashitakaakariri paerani Abraham eejatzi Isaac. Roojatzi iroka kepatsi nashitakaeyaariri pitomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ikanta ipiyanaa Tajorentsi ikenkithawaetakaakirira Jacob, ");
INSERT INTO cpy_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","raanaki mapi, ipiriintathanthatakiro ikenkithawaetakaakiri Tajorentsi. Ijeetantanakawo yeenkantsi, eejatzi imiriitari opoñaantyaari otajorentsitantyaari. ");
INSERT INTO cpy_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Iitanakiro Bet-el janta. ");
INSERT INTO cpy_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Roojatzi rawijantanakawo Jacob Bet-el. Okaakitzimatapaaki rareetya Efrata-ki, ari okatsitakotapaakiri Raquel, otzimaanite. Oshekimaeta okemaatsitaka otzimaanitantyaari. ");
INSERT INTO cpy_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Okanta oñaakiro aminirori osheki okemaatsiwaetaka, okantanakiro: “Eero pithaayi, tzimaki itsipa peentsite.” ");
INSERT INTO cpy_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tema kamimataki roori, oetanakiri eentsite “Benoni,” riima ashitariri iitakiri rirori “Benjamín.” ");
INSERT INTO cpy_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Roojatzi okamantaari Raquel, ikiteetakiro awotsiki jatachari Efrata-ki, iiteetziri nimaeka Belén. ");
INSERT INTO cpy_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Rowiriintaki Jacob mapi janta ikitateetakirowa. Rootaki iroka mapi riyoetantari ari okitataari Raquel. ");
INSERT INTO cpy_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Eekiro riyaatatzi Jacob, rawijaneentanakiro Mihdal-edar-ki. ");
INSERT INTO cpy_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ikanta ijeekaperotapaki Israel janta, jataki Rubén itsipatakawo Bilja, roojatzi itsipatzitari ipaapate. Ikanta riyotakira Israel, antawoete ikijanaka. Ikaatzi 12 itomipaeniite Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Irika otomipaeni Lea: Rubén (Jewari itomi Jacob), Simeón, Leví, Judá, Isacar eejatzi Zabulón. ");
INSERT INTO cpy_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Irika otomipaeni Raquel: José, Benjamín. ");
INSERT INTO cpy_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Irika otomipaeni Bilja, omperatane Raquel: Dan, Neftalí. ");
INSERT INTO cpy_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Irika otomipaeni Zilpa, omperatane Lea: Had, Aser. Riiyitakira itomipaeni Jacob ikaatzi tzimaentsiri janta Padan-aram-ki. ");
INSERT INTO cpy_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ari riyaataki Jacob iñeeri ashitaririni Isaac ijeeki rirori nampitsiki Mamre-ki, roojatzi iiteetzitari Arba, iiteetziro eejatzi Jebrón. Rootaki inampipaeni Abraham eejatzi Isaac. ");
INSERT INTO cpy_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Tzimaki Isaac okaatzi 180 rojarentsite roojatzi ikamantaari. ");
INSERT INTO cpy_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Raanakiri itomipaeni Jacob, Esaú, ikitateeri. Ari itsipataari isheninkapaeni aakiri rantyashiparinka. ");
INSERT INTO cpy_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Irika itomipaeni Esaú iiteetziri Edom. ");
INSERT INTO cpy_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Rootaki iinantakari Esaú tsinanipaeni Canaán-jato. Oeta Ada, rishinto Elón isheninkapaeni Het. Otsipa oeta Ajolibama, rishinto Iná, ijawo Zibeón isheninkapaeni Jev-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ikanta raakiro Basemat, rishinto Ismael, ritsiro Nebaeot. ");
INSERT INTO cpy_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Irika otomipaeni Ada itzimakaakirori Esaú, iita Elifaz. Itzimakaakirori Basemat iita Reuel. ");
INSERT INTO cpy_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Itzimakaakirori Ajolibama iita: Jeús, Jaalam, Coré. Riitakira itomipaeni Esaú irikapaeni tzimayiteentsiri ijeekawitaha rirori Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ikanta raanakiro Esaú iinapaeni, itomipaeni, ikaatzi jeekanampitziriri, maawoeni. Jataki inteena otsipaki nampitsi, ari rontsiparyaanakari rirentzi Jacob. Rayitanaari ipirapaeni, maawoeni tzimimotakiriri janta Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Omaperotatya roshekitzimotakiri ipira apiteroeni, tee omateeya itsipatawakaeya iipatsiteki. Tee iyomaatapaeya rowakaeyaariri ipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Rootaki riyaatantakari Esaú iiteetziri Edom inampityaawo tonkaariteki iiteetziro Seir. ");
INSERT INTO cpy_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Irika itomipaeni Esaú, icharinipaeni Edom nampitakawori tonkaariteki iiteetziro Seir. ");
INSERT INTO cpy_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iroka iwaeropaeni itomipaeni Esaú: Elifaz, otomipaeni Ada iina Esaú. Eejatzi Reuel, otomipaeni Basemat iina Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Irika itomipaeni Elifaz: Temán, Omar, Zefo, Hatam, Cenaz. ");
INSERT INTO cpy_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eenitatsi otsipa Elifaz romperatane iinantakari oeta Tzimna. Itzimaaki roori otomi iitakiri Amalec. Riira otomipaeni Ada, iina Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Irika itomipaeni Reuel: Najat, Zera, Jama, Miza. Riira otomipaeni Basemat, otsipa iina Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Rooma Ajolibama iina otsipa Esaú, otzimakiri roori Jeús, Jaalam, Coré. Tema rishinto Iná inatziiri roori, ijawo Zibeón. ");
INSERT INTO cpy_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Irika icharinipaeni Esaú. Ikaatzi itzmakantakiri Elifaz, rantarite itomi Esaú: Temán, Omar, Zefo, Cenaz, ");
INSERT INTO cpy_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Hatam, Amalec. Riiyitaki itomipaeni Elifaz ikaatzi jewariyiteentsiri nampitsiki Edom. Maawoeni irikapaeni otomipaenira Ada. ");
INSERT INTO cpy_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Irika itomipaeni Reuel, itomi Esaú, ikaatzi jewariyitatsiri: Najat, Zera, Jama, Miza. Riiyitaki icharinipaeni Reuel ikaatzi jewariyiteentsiri nampitsiki Edom. Riira otomipaeni Basemat iina Esaú. ");
INSERT INTO cpy_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Irika otomipaeni Ajolibama, rishinto Iná iina Esaú, ikaatzi jewariyiteentsiri Jeús, Jaalam, Coré. ");
INSERT INTO cpy_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Maawoeni irika riitaki itomipaeni Esaú, iiteetziri eejatzi Edom. Riitakira jewariyiteentsiri. ");
INSERT INTO cpy_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Irika itomipaenika Seir, Jor-jatzi rini, nampiyitawori janta, iiyita: Lot-án, Sobal, Zibeón, Iná, ");
INSERT INTO cpy_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer, Disán. Riitakira jewariyitakiriri Jor-jatzi, itomipaeni Seir, nampitawori Edom-ki. ");
INSERT INTO cpy_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Irika itomipaeni Lot-án: Jori, Jemam. Iroka Tzimna ritsiro ini Lot-án. ");
INSERT INTO cpy_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Irika itomipaeni Sobal: Alván, Manajat, Ebal, Sefo, Onam. ");
INSERT INTO cpy_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Irika itomipaeni Zibeón: Aja, Iná. Irika Iná, riitaki ñaakirori paerani nijaateni jaawaari janta tonkaariteki, ikoeratzinirira iyawayote ipaapate Zibeón. ");
INSERT INTO cpy_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Apaani ikanta itomi Iná riitaki iitachari Disón. Okanta apaani rishinto iitachari Ajolibama. ");
INSERT INTO cpy_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Itomipaeni Disón iiyita: Jemdán, Esbán, Itrán, Querán. ");
INSERT INTO cpy_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Itomipaeni Ezer iiyita: Bilján, Zaaván, Acán. ");
INSERT INTO cpy_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Itomipaeni Disán iiyita: Uz, Arán. ");
INSERT INTO cpy_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ikaatzi reewariyitakari Jor-jatzi: Lot-án, Sobal, Zibeón, Iná, ");
INSERT INTO cpy_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer, Disán. Riiyitakira jewatakiriri isheninkapaeni janta Seir-ki. ");
INSERT INTO cpy_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Riitakira pinkathariyiteentsiri nampitsiki Edom tekira itzimanakiita iwinkatharite Israel-ite. ");
INSERT INTO cpy_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Irika Bela, itomi Beor, riira pinkatharitaentsiri Edom-ki, iiteetziro nampitsi Dinaba. ");
INSERT INTO cpy_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ikanta ikamae paerani Bela, ipoyaatanaari Job-ab itomi Zera, ipinkatharitee rirori nampitsiki Bosra. ");
INSERT INTO cpy_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ikanta ikamae Job-ab, ipoyaataari Jusam ipinkatharitee rirori nampitsiki Temán. ");
INSERT INTO cpy_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ikanta ikamae Jusam, ipoyaataari Jadad itomi Bedad pinkatharitee. Riitaki ashiryaakariri rowayiritari Madián janta Moab-ki. Oeta inampi Avit. ");
INSERT INTO cpy_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ikanta ikamae Jadad, ipoyaataari Samla ipinkatharitee rirori inampiki iiteetziro Masreca. ");
INSERT INTO cpy_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ikanta ikamae Samla, ipoyaataari Saúl poñaachari janta Rejobot-ki, nampitsi jeekacheratzirori nijaa. ");
INSERT INTO cpy_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ikanta ikamae Saúl, ipoyaataari ipinkatharitee Baal-janán, itomi rini Acbor. ");
INSERT INTO cpy_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ikanta ikamae Baal-janán, ipoyaataari ipinkatharitaki Jadar. Riitakira poñaachari nampitsiki iiteetziro Pau. Iina Jadar oeta Mejetabel, rootaki rishinto Matred, ijawo Mezaab. ");
INSERT INTO cpy_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iroka iwaeropaeni ichariniyitari Esaú. Rootaki iwaero aakotakiri inampipaeni rirori: Tzimna, Alva, Jetet, ");
INSERT INTO cpy_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ajolibama, Ela, Pinón, ");
INSERT INTO cpy_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO cpy_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mahdiel eejatzi Iram. Tema Edom iiteetzitari eejatzi Esaú. Riiyitaki reewariyitakari Edom-jatzi, inampiyitawowa paerani reewarite aakoyiteeri iwaero inampipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Roojatzi ijeekaki rirori Jacob inampitawo Canaán-ki, ijeekira paerani ipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Iroka ikenkithatakoetziri itomipaenipaeni Jacob. Tema ewankaritaki José tzimaki 17 rojarentsite, riitaki aminapiintziriri ovejapaeni itsipayitari rirentzi, otomipaeni Bilja eejatzi ashi Zilpa, romperatanepaeni ipaapate. Riitaki José kamantapiintakiriri ipaapate rantayitzirowa kaariperori rirentzipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Riitaki José inintaperotziri ipaapate tee ari ikantayitziri itsipapaeni, okantakaantziro itzimakira rantyashiparinkaki. Rontyahaetakiniri owaneenkakitachari kithaarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ikanta riyoteeyakini rirentzipaeni riitaki José inintaperotziri ipaapate teera ari ikantziri riroripaeni, ikijaneentanakiri, tee riwethatanaari. ");
INSERT INTO cpy_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Ikanta imishiwaetaki José, ikamantakiri rirentzipaeni. Rootakira ikijaneentaperotantanakariri. ");
INSERT INTO cpy_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Tema ikamantakitziiri, ikantziri: “Pikeme nokamantemiro okaatzi nomishitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Noñaakiro ajeekaeyini owaantsiki, oojotsinaayitziro awankiri. Omapokashitanaka opiriintanaka noojotsinaatakiri naaka, tampatzikari okanta okatziyanaka. Rooma pashipaeni eeroka otapotapaakiro nashi, opinkathatzimaetawo.” ");
INSERT INTO cpy_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ari rakanakiri rirentzipaeni, ikantziri: “¿Pipinkathariwentatyenama eeroka? ¿Eerokama omperawaetenani?” Eekirowa ikijaneentaperotanakitziiri, ikemirira ikenkithatakotziro imishitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ikanta rapiitakiro José imishiwaetaki, ikamantakiri rirentzipaeni. Ikantziri: “¿Piyotakima, eenitatsi otsipa nomishitakiri? Noñaakiri ooryaatsiri, kashiri eejatzi 11 ikaatzi ompokiro ipinkathatakina.” ");
INSERT INTO cpy_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Ikanta ikenkithatakiniri José imishiri ipaapate eejatzi rirentzipaeni, ikijathatanakiri ipaapate, ikantanakiri: “¿Iitaka oshiyakaawentachari pimishitakiri? ¿Opinkathataatyeemima piniro, pirentzipaeni eejatzi naaka?” ");
INSERT INTO cpy_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ikijaneentakiri rirentzipaeni, riima ashitariri kenkithashireri royiro imishiri itomi. ");
INSERT INTO cpy_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ikanta riyaateeyakini rirentzipaeni José janta Siquem-ki, ithotyaakotzi rowakaeyaariri rovejate ipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ikanta Israel ikantakiri José: “Nokoyi piyaate Siquem-ki, pimpoetaateri pirentzipaeni ikoeratziri ovejapaeni.” Ikantanaki José: “Aritaki nomatakiro niyaate.” ");
INSERT INTO cpy_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ikantzi Israel: “Piyaate, piñahaateri pirentzipaeni jempe ikanta ijeeki, eejatzi ovejapaeni. Pipiyera intsipaete, pikamantapakina.” Rotyaantakiri Israel itomi José ipoñaanakawo Jebrón-ki. Ikanta rareetaka José Siquem-ki, ");
INSERT INTO cpy_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","tzipinatakira janta. Ari itonkyotakari apaani atziri, rojampitakiri: “¿Iitaka pithotyaakotziri?” ");
INSERT INTO cpy_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ikantanaki José: “Nothotyaakotatziiri yeeyipaeni. Pikamantena jempe ijeekiro ikoeratziri ovejapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ikantanakiri atziri: “Aamakya jateeyeenirika, nokemakiri ikanteeyini ikinanaki Dotán-ki.” Jatanaki José ithotyaakoteeri. Iñahaerira janta Dotán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ikanta riroripaeni iñaawakiri inteena ipokakira, tekira rareetariita ijeekaeyakinira, ikamantawakahaeyakani rompojeri. ");
INSERT INTO cpy_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ikantawakaanaka: “Kaakitaki mishiwaetapiintatsiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Pipokaeyeni, jame ompojeri, oteteri omookira, akantapaki: ‘rowakari katsimari owantaneri.’ Añaawakiroota jempe okantya imishitapiintakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ikanta ikemakira Rubén, ikowawitanaka rotsiparyaakowenterimi José eero ikoshekantari rirentzipaeni. Ikantanaki: “Eero ompojiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Poteteri omookira jeekatsiri tonkaariki, tee okameethatzi pakotashiteri. Eero pewanatakaari riraa.” Rootaki ikantantawitari Rubén tema tee ikoyi rompojeeteri José, riyaateeta ipaapateki. ");
INSERT INTO cpy_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ikanta rareetapaaka José ijeekaeyakinira rirentzi, raatonkoryaawakiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Roojotanakiri, rotetakiri omookira opiryaanatakira. ");
INSERT INTO cpy_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ari ijeekaeyanakini rowaeyani. Roojatzi iñaantawakariri ipokaeyakini Ismael-ite ipoñaakawo janta Halaad-ki, ramayitaki ipirapaeni, kajankaripaeni, aawintawontsipaeni, owa inchatopaeni, rayero Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Ikanta Judá ikantanakiri rirentzipaeni: “¿Iitaka owamaantyaariri arentzi, akoyimaeta omanakoteri ompojakirira? ");
INSERT INTO cpy_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Rootaki kameethatatsi apimanteniri Ismael, eero ompojawaetashitari, tema riitaki arentzi aakapaeni.” Inimotanakiri rirentzipaeni okaatzi ikantakiri Judá. ");
INSERT INTO cpy_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ikanta rareetapaakaha iyompariwaetzinkari Madián-jatzi, roeyowaetanakiri José omookira, ipimantawakiniri Ismael-ite ikaatzi 20 ipewiryaaka koriki. Roojatzi rahaetantanakariri José janta Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ikanta ipiyaawitapaawo Rubén omookira, teera iñaapaeri José inthomoeki, ijaanakiro ithaari okatsitzimoneentanakirira. ");
INSERT INTO cpy_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ipiyashitanakari ijeekira rirentzipaeni, ikantapaakiri: “¿Teera añahaeri ewankari? ¿jempe nokantyaaka nimaeka?” ");
INSERT INTO cpy_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Rahaeyakironi iithari José, itziritantakawo riraa ipira rowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ari rotyaanteeniri ipaapate, ikantziri: “Piñeero iroka kithaarentsi noñaakiri, paminero roorika ikithaari pitomi.” ");
INSERT INTO cpy_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ikanta riyotawakirowa Jacob, ikantanaki: “Roomacheetaka iithaari notyomi. Aamakya itonkyotakityaari owantaneri, rowakari.” ");
INSERT INTO cpy_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ari itzijaahanakiro iithaari Jacob, antawoete iriraanaka, ikithaatanakawo meremankiri, ojamani rowashiretakotanakari ikamakira itomi. ");
INSERT INTO cpy_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Osheki ikowawiteeyakani itomipaeni roemoshirenkaerimi, ari okantziwitakari rishintopaeni, teemaeta ikoyi rirori roemoshirenkaeteri. Eekiro riraakowaetatyaari itomi, ikantzi: “Oshekira nowashiretakotyaari notyomi, roojatzi paata notsipatanteeyaariri.” ");
INSERT INTO cpy_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ikanta rareeteeyakani Madián-jatzi janta Egipto-ki, ipimantapakiri eejatzi José, ipapaakiri atziri iiteetziri Potifar, eewatziriri owayiripaeni. Riitaki itsipatari Faraón pinkatharitatsiri Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Aripaete rotsiparyaanakari Judá rirentzipaeni, jataki ijeekawaetzi ipankoki atziri iita Jira, poñaachari Adulam-ki. ");
INSERT INTO cpy_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ari iñaakiro rishinto Canaán-jatzi iitachari Súa, raakiro. ");
INSERT INTO cpy_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ikanta raawakaaka, imotzitakaakiro, otzimakiri otomi iitakiri Er. ");
INSERT INTO cpy_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Eejatzi apiitakiro omotzitaki, otzimakiri itsipa otomi, iitakiri Onán. ");
INSERT INTO cpy_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Eejatzi otzimawae itsipa otomi, oetakiri Sela, riitaki tzimaentsiri ijeekantawitakari Judá Quezib-ki. ");
INSERT INTO cpy_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ikanta Judá ikowakaakiri Er rantarite itomi, raakiro tsinani iitachari Tamar. ");
INSERT INTO cpy_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Riitaki kantacha Tajorentsi tee inimotziri okaatzi rantayitziri Er, rootaki rowamaantakariri. ");
INSERT INTO cpy_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ikanta Judá ikantakiri Onán: “Pahaero iina pirentzini tema piinathori ini. opoñaantyaari pitzimakahaero roshiyawaetyaari riimi ashityaarini pirentzini.” ");
INSERT INTO cpy_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Riyotaki Onán jempe ikaate itzimakayirori iinathori eeromaeta rashitari rirori. Rootaki kaari ithonkaperotantawo iñaathawitawowa omotzitzikari iina rirentzini, itzimikari itomipaeni, rashitaarikari rirentzini. ");
INSERT INTO cpy_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Antawoete owatsimaakiri Tajorentsi okaatzi rantziri Onán, rowamaakiri eejatzi rirori. ");
INSERT INTO cpy_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ikanta Judá ikantakiro raniro Tamar: “Piyaatee pijeekapae ipankoki pipaapate tema kinankawo pini, rantaritawakiita itsipa notyomi Sela.” Tema ikenkithashiretaka Judá, ikantzi: “Aamaaka ari ikamaki rirori Sela roshiyaari rirentzipaeni.” Rootaki iyaatantaari Tamar ojeekapae ipankoki opaapate. ");
INSERT INTO cpy_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Okanta ojamanitaki, kamae eejatzi iina Judá, rishinto Súa. Ikanta okaatzimoteeri Judá rowashiretakowaeta, jataki nampitsiki Tzimnat, ijeekayitzira ameetziriri rovejate. Riitaki itsipatanakari Jira Adulam-jatzi ikempiyane. ");
INSERT INTO cpy_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Okanta okemaki Tamar riyaatatzi rikonkiri janta Tzimnat rameeyiteri rovejate, ");
INSERT INTO cpy_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","aatonkoryaanakawo oethaari owashiretakowaetaha, opashikawootanaka eero riyotanteetawo. Ari ojeekanaki awotsinampiki nampitsi Enaem ikinapiinteetzira janta Tzimnat. Rootaki antantawori iroka tema yotaki roori antariwitaa Sela, roo kantzimaetacha tee raakahaetziro. ");
INSERT INTO cpy_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ikanta iñaapaakiro Judá roshiyakaamintheetziro mayempiro ini, tee riyotapaakiro opashikawootakaha. ");
INSERT INTO cpy_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ari itempaashitanakiro raminero okaakiini. Teera riyotzi roori raniro, ikantapaa: “¿Tee pikoyi notsipatemi?” Ari okantanakiri roori: “¿Iitaka pipenari aririka pitsipatakina?” ");
INSERT INTO cpy_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ikantanaki Judá: “Ari nopakaantakimi iryaani nopira.” Okantanaki roori: “Kameethataki. Roo kantacha otzimatye pookanaki pashitari eeroka roojatzi potyaantantakinariri pipira.” ");
INSERT INTO cpy_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Eekiro ikantanakitzi Judá: “¿Iitaka pikoyiri nookanakimiri?” Okantanaki roori: “Pookanakinawo pikotzi, eejatzi pipothomento pithaantakiri.” Ipakiro Judá okaatzi okowakotakiriri, itsipatakawo. Imotzitakaakiro. ");
INSERT INTO cpy_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ari iyaatee Tamar, opashikaryaawootana, okithaatanaawo oethaari owashiretakowaewitaha. ");
INSERT INTO cpy_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Ikanta Judá rotyaantakaantakiniro iryaani ipira raanakiniro ikempiyane Adulam-jatzi, oepiyanteeyaanariri ipanakirori ketziroeni, teemaeta iñaapaero. ");
INSERT INTO cpy_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Rojampitapaakiri jeekatsiri janta: “¿Jempe okinakika mayempiro Enaem-jato jeekatsiri paerani awotsinampiki?” Ari rakaeyanakirini: “¿Tekatsira mayempiro jeekatsini jaka?” ");
INSERT INTO cpy_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ari ipiyanakari ijeekira Judá, ikantapakiri: “Teera noñaahaero tsinani. Nojampiwitakari jeekatsiri janta, ikantanakina: ‘Tekatsi mayempiro jeekatsini jaka.’” ");
INSERT INTO cpy_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ikantanaki Judá: “Aamashitya ari ithaenkaetakina eekirorika aatatye athotyaakotero, ayeroota nopakirori. Tema nopakaantawitakawo iryaani nopira, teemaeta piñaapaero.” ");
INSERT INTO cpy_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Okanta ojamanitaki awijaki mawa kashiri, eenitatsi pokaentsiri, ikantapaakiri Judá: “Eenitatsira atziri maantakawori paniro Tamar, motzitakira nimaeka.” Icheraanaki Judá ikantanaki: “¡Payero, pitayero!” ");
INSERT INTO cpy_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ikanta rahaetanakiro, otyaantakaantakiniri ñaantsi rikonkiri, okantaki: “Iitakarika ashitawori iroka, riitakira tzimakakinari. Paminero iitaka ashitawori ipothomento ithaantakoetziri eejatzi ikotzi.” ");
INSERT INTO cpy_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ikanta riyotawaero Judá riitaki ashitawori, ikantanaki: “Omatakiro iroka antakiro kameethatatsiri, naaka antakirori kaariperori, tema tee naakayiro notyomi Sela.” Ari aashiryaanakiri tee rapiiteero itsipateeyaawo. ");
INSERT INTO cpy_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Okanta otzimaanitaki Tamar, apite ikantaka eenchaanite. ");
INSERT INTO cpy_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ikanta itzimapaakira eenchaanite, romishitowawakotapaaka apaani. Oojowakotantawakari kityonkathari mampetha aminirorira, okantanaki: “Riira etapaakawori ishitowapaaki”. ");
INSERT INTO cpy_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ikanta romonkyaaneero rako, riitaki etapaakawo itzimaki itsipa. Rootaki iitantakariri aminirori tziminkawo “Fares,” okantanaki: “¿Pimatakiro piñaashintsitaka?” ");
INSERT INTO cpy_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Roojatzi itzimantapaakari itsipa, roojotanteetakari ketziroeni kityonkathari mampetha, iiteetakiri Zara. ");
INSERT INTO cpy_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ikanta raanakirira Ismael-ite José janta Egipto-ki, ramanantawakiri Egipto-jatzi iita Potifar. Irika Potifar reewari owayiripaeni, inampina rini pinkathari Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Riitaki kantacha Tajorentsi itsipatapiintakari José, itajonkawentakiri janta ipankoki omperanatariri Egipto-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Riyotaki omperanatariri José itsipatatyaarira Tajorentsi, itajonkawentziri maawoeni rantayitziri. ");
INSERT INTO cpy_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Rootaki raakameethaperotantanakariri omperatariri, riitaki rowakiri ramitakoteri, ramineniri tzimatsiri ipankoki, ishinetakiniri ikempoyeeniri maawoeni tzimimotziriri. ");
INSERT INTO cpy_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ari retanakawo Potifar ipanakiri José ikempoyeero tzimatsiri ipankoki, maawoeni, aripaete itajonkawentanakiri Tajorentsi irika Potifar ipankoki eejatzi rowaneki. ");
INSERT INTO cpy_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Riitakira José koeratziniriri maawoeni tzimimotziriri, teera okantzimowaetanaari Potifar ikoetyeero oetarika royaari. Kameethantzi rini José, inintaashireetakiri. ");
INSERT INTO cpy_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Okanta ojamanitaki, aminaminatakiri iina omperatariri, okantakiri: “Pitsipatena.” ");
INSERT INTO cpy_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tee raapatziyaawo José, ikantanakiro: “Pikeme nokantemi, irika omperatanari inintakaakinawo nokoerateeniri maawoeni tzimimotziriri, nojeekira naaka ipankoki eero otzimawaetzi oeta kantzimoshiretyaarini. ");
INSERT INTO cpy_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Naakaha rawentaa jaka pankotsiki, tekatsi apaani oeta ithañaapithatenari. Apatziro pikantakawo eeroka ithañiimi, tema iina royimi. ¿Iitaka nantantyaawori kaariperori, pikowatziima nokaariperotzimoteri Tajorentsi?” ");
INSERT INTO cpy_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ashironkawentapiintawitakari José itsipatyaawomi. Tee raapatziyimaetawo. ");
INSERT INTO cpy_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Okanta ojamanitaki ikyaapae José pankotsiki rantawaete. Tekatsi jeekatsini. ");
INSERT INTO cpy_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Oteeyakotakiri roori iithaariki, okantziri: “Pipokiita pitsipatena.” Riitaki matacha José ishiyapithatanakawo, roojatzi rookanakiro iithaari oteeyakiro roori. ");
INSERT INTO cpy_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ikanta ishiyapithatanakawo, roojatzi rookanakiro iithaari oteeyakirowa akoki roori, ");
INSERT INTO cpy_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","okaemakiri omperatanepaeni, okantakiri: “Pikemina, ramaki noemi jaka apaani Hebreo-jatzi riitaki theenkimawaeteeri nimaeka. Ipokashitakina nojeekira ikowawita itsipatena, ari nokaemanaki shintsiini. ");
INSERT INTO cpy_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ikanta ikemawakina nokaemanakira shintsiini, shitowanaki, iroka rookanakiro iithaari.” ");
INSERT INTO cpy_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Roojatzi owakiro roori iithaari José roojatzi rareetantapaari omperatariri ipankoki. ");
INSERT INTO cpy_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Okamantawakiriri, okantziri: “Irika Heber omperatane pamakiriranki, ikyaashitakina amaapiintzira, ikowawitaka roetsinampaena. ");
INSERT INTO cpy_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ari nokaemanaki shintsiini, shiyanaka ishitowanaki, iroka rookanakiro iithaari. ");
INSERT INTO cpy_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Arira ikantakina pomperatane.” Antawoete ikijanaka omperatariri José ikemakirowa okamantakiri iina. ");
INSERT INTO cpy_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Roteeyakiri José, romonkyaakaantakiri, ijeekayitzira eejatzi romonkyaakaantane pinkathari. ");
INSERT INTO cpy_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Okantawitaka romonkyaakaantawiitakari, eekiro itajonkawentanakitziiri Tajorentsi irika José, osheki ineshironkatakiri. Ikantakaakawo Tajorentsi ikempiyaminthatakari kempoyeeriri omonkyahaarewo. ");
INSERT INTO cpy_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ikowakaakiri ikoeteniri rirori omonkyahaarewo. Riitaki José jewatziriri, okaatzi romperatariri rirori, rantayiitziniri. ");
INSERT INTO cpy_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Teera ipakowaetanaa koeratziriri omonkyahaarewo, riitaki José koeratanakiriri maawoeni. Tema Tajorentsi tsipatakariri, itajonkawentapiintakiri. ");
INSERT INTO cpy_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ikanta omperataarewo pakopiintziriri pinkathari imiri, owetsikapiintziniriri pan, ikijakaakari omperatariri, pinkatharitatsiri Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Ikanta Faraón, pinkatharitatsiri, ikijakiri reewarite pakopiintatziriri imiri, eejatzi reewari owetsikapiintziniriri pan. ");
INSERT INTO cpy_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Rotyaantakiniri kempoyeeriri omonkyahaarewo, rashitakoteri. Arira ijeekitari eejatzi José romonkyahaetziri rirori. ");
INSERT INTO cpy_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ikanta eewatziriri omonkyahaarewo, rowawijaakiniri José ikoerateri irikapaeni, osheki ojarentsi romonkyahaetakiri janta. ");
INSERT INTO cpy_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ari imishiwaetaki pakotantaniri, eejatzi owetsikapiintzirori pan. Inashiyitakaha imishiri irikapaeni, inashiyitaka eejatzi oshiyakaawentziri. ");
INSERT INTO cpy_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Okanta okitejitamanee, raminamaneeri José omonkyahaarewo, iñaapaatziiri antawoete okantzimoshiryaakari. ");
INSERT INTO cpy_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Rojampitapaakiri, ikantziri: “¿Iitaka pipaashinikyaatantari?” ");
INSERT INTO cpy_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ari ikanteeyanakini riroripaeni: “Tzimatsi nomishitakiri, tekatsitzimaeta kantenawoni oetarika kantakotachari.” Ikantanaki José: “Pipokeeta, pikamantenawo pimishitakiri. Tema Tajorentsi matzirori riyotakotziro mishiwaerentsi.” ");
INSERT INTO cpy_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ari retanakawo reewari pakotantaneri ikamantziri José okaatzi imishitakiri, ikantziri: “Noñaaki nomishiriki apaani pankirentsi, ");
INSERT INTO cpy_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","tzimatsiri mawa otewa. Shookanaki pankirentsi, oteyakitanaki. Rootaki oteyaki peyanaenchari okithoki, irakayitanaki. ");
INSERT INTO cpy_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Naaka oteeyakirori riramento Faraón, naakiro okithoki pankirentsi, nochowakiniri riramentoki. Ari naakotanakiniri eejatzi Faraón nopakotziri.” ");
INSERT INTO cpy_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ikantanakiri José: “Iroka oshiyakaawentachari pimishiri: mawatatsiri otewa pankirentsi, rootakira mawar kitejeri. ");
INSERT INTO cpy_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Arika awijaki mawa kitejeri raminakotakimiro Faraón okaatzi awijimotakimiri, ari roepiyeemi pantawaeteeniri. Aritaki papiiteero pipakoteeri Faraón, pikemitayirowa paerani. ");
INSERT INTO cpy_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Arika omatakya nokantakimiri, eerowa pipeyakotana naaka. Pikamanteri Faraón romishitowanteenari naaka jaka. Pineshironkataajeeteena naaka. ");
INSERT INTO cpy_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Tema pimantaarewo nini naaka, nopoñaawo iipatsiteki Heber-ite, tee okameethatzi romonkyaawaeteetena, tema tee nantziro kaariperori.” ");
INSERT INTO cpy_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ikanta iñaakiro reewari owetsikapiintzirori pan kameethari riyotakotakiro José mishirentsi, ikantanaki rirori: “Noñaakira naaka nomishiriki nopewiryaakotziro noetoki mawa kantziri yeekitaki kitamaari pan. ");
INSERT INTO cpy_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kantziri nopewiryaakiri jenoki ari iyeekitakiri kantawaetachari pan nopiriri Faraón. Roo kantacha ipokaeyapaakini shiwankiri rowapaakawo pan nowakotakiri noetoki.” ");
INSERT INTO cpy_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Rakanakiri José, ikantanakiri: “Iroka oshiyakaawentachari pimishiri eeroka: mawatatsiri kantziri, mawa kitejeri ini. ");
INSERT INTO cpy_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tema omonkaatapaakyaarika mawari kitejeri raminakoteemiro Faraón pantakiri eeroka, ithatakaantemi inchatoki, ipokaeyini tzijopaeni royaawo piwatha.” ");
INSERT INTO cpy_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Yomaatapaakaha mawa kitejeri, ari omonkaatakari roemoshirenkya Faraón itzimantakari paerani, antawoete roemoshirenkaeyakani itsipayitakari inampinapaeni. Ikanta ipiyoteeyanira roemoshirenka, ikaemakaantakiri kitapiintziriri imiri itsipataakiri owetsikapiintziniriri pan. ");
INSERT INTO cpy_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ikantakiri kitapiintziriri imiri: “Papiiteero pantawaetayi nopankoki.”. Rapiiteerowa irika ikitairi imiri Faraón ikimiteerowa paerani. ");
INSERT INTO cpy_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Riima owetsikapiintziniriri pan ithatakaantakiri, monkaatakaha okaatzi ikantakiriri José oshiyakaawentachari imishiriki. ");
INSERT INTO cpy_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ikanta kitapiintziriri imiri Faraón, imaejantanakiri José tee ikenkithashiretaneeri. ");
INSERT INTO cpy_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Awijaki apite ojarentsi. Ari imishiwaetaki Faraón ijeeki othapyaaki nijaa Nilo. ");
INSERT INTO cpy_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Iñaatziiri ishitowaeyini nijaaki 7 wathantzipaeni vaca kameethari ikanteeyakani, ari ijeekaeyini rowaeyaani janta. ");
INSERT INTO cpy_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Iñaatziri royaatapaakiri itsipa 7 matharipaeni vaca, kaariperori rini. itsipatapaakari wathantzipaeni rowaeyani. ");
INSERT INTO cpy_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Ikanta mathari vaca-paeni, rowanakari wathantzipaeni. Ari ikakiwitanakari Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Eejatzi ipiyanaa imaanee, imishitaki otsipa. Iñaki 7 oshooki pankirentsi kameethari okantayitaka, oshookaki owaatoki. ");
INSERT INTO cpy_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Iñaatziiro otsipa 7 oshooki pankirentsi, tee opantawo, jampipayitaki owakiro tampyaa poñahaenchari ishitowapiintzira ooryaa. ");
INSERT INTO cpy_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Okanta iroka jampipateentsiri oshooki, owanakawo otsipa kaatatsiri 7 tzimatsiri okithoki. Ari ikakitanakiri Faraón, iñaakirowa imishiri. ");
INSERT INTO cpy_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Okanta okitejitamanee okantzimoshiretamanaari, ikaemakaantakiri maawoeni yotzinkaripaeni eejatzi sheripiyaripaeni janta Egipto-ki. Ikamantakiri Faraón maawoeni imishitakiri, tekatsitzimaeta kanterini oetarika oshiyakaawentziri imishitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ikanta reewari kitapiintziriri imiri pinkathari, ikantanakiri Faraón: “Nokenkithashiryaaneero nokaariperotzimotakimira paerani. ");
INSERT INTO cpy_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pikijakiri paerani reewari owetsikapiintzimiri pan eejatzi naaka, potyaantakina romonkeena jewatakaantatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ikanta imishitaki reewari owetsikapiintzimirori pan, nomishitaki eejatzi naaka otsipa. Tzimatsi otsipa oshiyakaawentachari okaatzi nomishiyitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ari itsipatakina janta apaani ewankari Heber, ikempiyane rini koeratziriri omonkyahaarewo. Nokamantakiri okaatzira nomishitakiri, riyotaakinawo okaatzi kantakotachari. ");
INSERT INTO cpy_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Monkaatzimaetaka maawoeni ikantakinari rirori. Napiiteerowa naaka nantawaeteemi, riima itsipa ishirikaetakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ikanta Faraón ikaemakaantanakiri José. Intsipaete romishitowapaentziri rashitakoetakirira. Jatanaki José rameetakaantapaenta, ikithaatapaenta otsipa ikithaari, jatanaki ijeekira Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ikantawakiri Faraón: “Tzimatsi nomishitakiri, tekatsitzimaeta materoni ikantenawo oetarika oshiyakaawentachari. Roo kantacha nokemaki naaka pimatziro eeroka pikamantantziro aririka pikemakiro okaatzi imishiteetziri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ari rakanaki José, ikantanaki: “¡Pinkathari! Teera naaka materoni apaniroeni, riitaki Tajorentsi ooñaawontemironi pimishiri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kenkithawaetanaki Faraón, ikantanakiri José: “Nomishitakiro nojeeki othapyaaki Nilo. ");
INSERT INTO cpy_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Noñaaki ishitowaatapaaki 7 vaca wathantzi, ari rowawaeteeyapaakani. ");
INSERT INTO cpy_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Noñaatziiri rishitowaatapaaki itsipa ikaatzi 7 matharipaeni. Tee noñaapiinteri kaariperori vaca jaka Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Ikanta matharipaeni vaca, rowanakari itsipa wathantzipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Okantawitaka rowawitakari wathantzipaeni, eekiro riyaatatzi imathatzi ikantaha paerani. Ari nokakitanaki. ");
INSERT INTO cpy_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ari nomishitaki otsipa, noñaaki 7 oshooki pankirentsi, jaankanari okantaka owaatoki. ");
INSERT INTO cpy_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Noñaatziiro otsipa 7 oshooki pankirentsi, jampiyathataki okantakiro tampyaa poñahaenchari ishitowapiintzira ooryaa. ");
INSERT INTO cpy_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Okanta pankirentsi jampipateentsiri, owanakawo otsipa kaatatsiri 7 jaankanatatsiri. Nokamantawitakari maawoeni sheripiyaripaeni, tekatsitzimaeta yoteroni oetarika kantakotachari nomishitakiri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ari rakanakiri José Faraón, ikantanakiri: “¡Pinkathari! Okaawita apite pimishitakiri, apaani okanta ikamantzimiri Tajorentsi ranteri. ");
INSERT INTO cpy_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Tema ikaatakira 7 wathantzi vaca, 7 ojarentsi ini. Okaatakira 7 jaankanatatsiri oshiwithate pankirentsi, 7 ojarentsi ini. Tema apaani okanta mishirentsi ");
INSERT INTO cpy_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ari ikantakari 7 matharipaeni vaca oyaatapaakiriri wathantzipaeni, 7 ojarentsi ini. Kaateentsiri 7 shiwitha jampiyathateentsiri, okantakiro tampyaa poñahaenchari ishitowapiintzira ooryaa, 7 ojarentsi iñahaetero tashetsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Okaatzira nokamantakimiri pinkathari, rootakira ikamantzimiri Tajorentsi okaate ranteri. ");
INSERT INTO cpy_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tema iñahaetatyeero jaka Egipto-ki okaate 7 ojarentsi otzimanteeyaari pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Iñiiteetyaawo eejatzi okaate 7 ojarentsi eero oshookae pankirentsi. Tekatsi kenkithateeroni oshekitantapaentari pankirentsi Egipto-ki. Arira owamayimatakiri itashe ikaatzi nampitawori jaka. ");
INSERT INTO cpy_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Antawoete okantya tashetsi, eero iñahaeteero owanawontsi tzimawitachari paerani. ");
INSERT INTO cpy_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","¡Pinkathari! Apaanira okanta oshiyakaawentziri apite pimishitakiri. Intsipaetera rantero Tajorentsi iroka, tema rootaki ikowakiri rantero. Rootaki rapiitantakawori romishimpiimi. ");
INSERT INTO cpy_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","¡Pinkathari! Otzimatye pamine atziri yotzinkari eewateroni nampitsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Pantero iroka pinkathari: Powayite eewariite jatatsini maawoeniki nampitsi Egipto. Riitaki piyotatsini pankirentsi, roojatzi omonkaatantakyaari 7 ojarentsi oshekitzimaetaka pankirentsi. Jemperika otzimaperote pankirentsi, raye eepichokiini rowaantyaawoí. ");
INSERT INTO cpy_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ithonka raakiyite okithokiyiterika ojarentsiki, ipayiteri pinkathayitatsiri nampitsiki rowaantyaawo, rootakira rowayityaari paata atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ari pikantero powaantyaawo maawoeni pankirentsi jaka nampitsiki, eero aantari atziripaeni itashe areetakyaarika 7 ojarentsi ritasheyeete maawoeni Egipto-ki.” ");
INSERT INTO cpy_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Okameethatzimotakiri Faraón eejatzi ithapinapaeni okaatzi ikantakiri José. ");
INSERT INTO cpy_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ari ikantanaki Faraón: “¿Arima añaaki itsipa atziri oshiyaarini irika, ijeekantashiretari itajorenka Tajorentsi?” ");
INSERT INTO cpy_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ipithokashitanakari José, ikantanakiri: “Tekatsira itsipa yotzinkari kenkithashiryahaachani kameethari awijemini eeroka, tema Tajorentsi yotakayimirori maawoeni iroka. ");
INSERT INTO cpy_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Eerokaha aminakaanteeroni nimaeka nowinkatharipankote, ikemijanteeyemini maawoeni atziripaeni okaate pikanteriri. Rooma naaka, nawijaneentemi ipinkathayiitena tema pinkathariperori nini. ");
INSERT INTO cpy_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Naakataki owakimiri peewateri maawoeni jeekatsiri jaka Egipto-ki.” ");
INSERT INTO cpy_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Inowikyaanakiro Faraón ipothomento, rowakiniri rakoki José. Ari ikithaateetakiri kyaariperori, ithaantakahaetakiri thatanentsi rowetsikaetziri ooro. ");
INSERT INTO cpy_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Roteteetakiri otsipaki ishiyakomento pinkathari, ikanteetakiri atziripaeni ikaemaeyeni, ikante: “Piteenkaryaayite.” Ari retanakawo José reewatziri maawoeni Egipto-jatzi. ");
INSERT INTO cpy_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ikantanaki eejatzi Faraón: “Okantawitaka naaka pinkatharitatsiri, roo kantacha eerokaha ipinkathate maawoeni Egipto-jatzi, eero rantashiwaetawo ikoyiri rirori, okaate pikanteriri eeroka rootaki ranteri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ikanta Faraón rowakiniri José otsipa iwaero iñaaniki Egipto-jatzi, iitakiri Zafnat-panea. Ipakiri iinantyaawo Asenat rishinto Potifera omperatajorentsitaneri nampitsiki iiteetziri On. Roojatzira riyaatantanakari José ranashityaawo maawoeni Egipto. ");
INSERT INTO cpy_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Tzimaki José okaatzi 30 rojarentsite raanteetakariri iñeeri Faraón pinkatharitatsiri Egipto-ki. Ari riwethatanakari José pinkathari Faraón, jataki ithotyeero maawoeni Egipto. ");
INSERT INTO cpy_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Oshekitzimaetanaka pankirentsi okaatakira 7 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Ithonka ipiyotakaantakiro José maawoeni pankirentsi okaatzi kithokiteentsiri ojamanitakira 7 ojarentsi. Rowaantakawo owanawontsi nampitsikipaeni okaatzi kithokiyiteentsiri owaantsikipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Ipiyotakaantaki José osheki pankirentsi, oshiyawaetakawo impaneki. Tema omaperotatya roshekitaki, tee ikantapaeya riyoteero jemperika okaatzi. ");
INSERT INTO cpy_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tekira omonkaatyaata iñahaetantyaawori tashetsi, itzimakaakiro iina José iroka Asenat, tzimanaki apite itomi. ");
INSERT INTO cpy_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Etanakawori itzimaki iitakiri Manasés, tema ikantakitzi José: “Imaejantakahaanawo Tajorentsi maawoeni nokemaatsiwaetane, eejatzi nosheninkapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Riima apitetanaentsiri iitakiri Efraín, tema ikantakira eejatzi José: “Itzimakakina Tajorentsi nampitsiki jempe nokemaatsiwaetaka.” ");
INSERT INTO cpy_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ari okaatapaaki 7 ojarentsi okithokitantakari pankirentsi Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Monkaatapaakaha ojarentsi ikantakiri paerani José. Iñahaetantyaawori tashetsi maawoeniki nampitsi, rooma Egipto-ki tee iñahaetziro, tema eenitatsi owanawontsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ikanta iñahaeyawakironi Egipto-jatzi tashetsi, riyaatashitanakiri Faraón ikowakoteri owanawontsi. Ikantawakiri Faraón maawoeni Egipto-jatzi: “Piyaatashiteri José, panterowa okaate ikantemiri.” ");
INSERT INTO cpy_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Antetanakaha tashetsi maawoeniki nampitsi, rashiryaakaantakiro José rowaantakawowa owanawontsi ipimanteniriri Egipto-jatzi, tema eekiro omaperotatya tashetsi. ");
INSERT INTO cpy_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Osheki atziri poñaayitachari otsipaki nampitsi pokaentsiri Egipto-ki, ramanante owanawontsi rowaantakari José, tema tekatsi owanawontsi otsipaki nampitsi. ");
INSERT INTO cpy_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ikanta ikemaki Jacob ari otzimi owanawontsi janta Egipto-ki, ikantanakiri itomipaeni: “¿Iitaka paminaminthatawakaantari? ");
INSERT INTO cpy_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ikamanteetakinaha tzimatsi owanawontsi janta Egipto-ki. Piyaateeyeni janta pamanantakite oyaari, eero aantee atashe.” ");
INSERT INTO cpy_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ikanta irikapaeni 10 rirentzipaeni José, pokaeyakini Egipto-ki ramanante owanawontsi. ");
INSERT INTO cpy_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Riitaki kantacha Jacob teera ishinetziri Benjamín riyaate rirori, rirentzi okaakiini José, tema ikenkithashirewaetaka ari awijimotakiri kaariperori. ");
INSERT INTO cpy_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Riyaateeyakini itomipaeni Israel itsipayitanakari itsipapaeni atziri jatatsiri ramanante owanawontsi, tema maawoeni Canaán-ki iñahaetakiro tashetsi. ");
INSERT INTO cpy_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Riitaki José eewatakaantzirori nampitsiki, riitaki pimantziniriri owanawontsi atziripaeni poñaayitachari otsipaki kepatsi. Ikanta rareeteeyakani rirentzipaeni ijeekakira rirori, rotziwerowashitapaakari roeyooperotanaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Riyotawakiri José rirentzipaeni iñaawakirira. Roshiyakaawakiri tee riyotziri, shintsitha ikantawakiri rojampitziri: “¿jempe pipoñaaka eerokapaeni?” Ikanteeyanakini riroripaeni: “Nopoñahaeyaani Canaán-ki, nopokatzi namanante owanawontsi.” ");
INSERT INTO cpy_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Okantawitaka riyowitawaari José rirentzipaeni, teemaeta riyotapaeri riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ari ikenkithashiretanakiro José imishitakiri paerani, ikantanakiri rirentzipaeni: “Eeteempyawaerintzi pineeyini. Pipokaeyatziini paminaantyaawó nampitsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Rakaeyanakini riroripaeni: “Tee, pinkathari, apatziro nopokaeyini namanante owanawontsi. ");
INSERT INTO cpy_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Maawoeni naakapaeni nokaatakira apaani ikanta ashitanari. Kameethashireri nineeyini. Tee neeteempyawaeta.” ");
INSERT INTO cpy_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Eekiro ishintsitanakitzi José ikantziri: “Pitheeya, pipokaeyatziini paminaantatya nampitsiki.” ");
INSERT INTO cpy_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ari rakaeyanakini rirori, ikanteeyini: “Nonampiteeyaawoni naaka Canaán-ki, nokaatzi 12 yeeyipaeni, apaani ikanta ashitanari. Roojatzi ijeekanaki itsipa iyaapitsi yeeyi itsipatanakari ashitanari. Tzimatsi itsipa apaani peyeenchari, tee noñaahaeri.” ");
INSERT INTO cpy_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Rapiitanakiro José ikantanakiri: “Nokantakimi. Eeteempyawaerintzi pineeyini. ");
INSERT INTO cpy_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Iroka niyotantemiri: Riyotana Faraón tee notheeya, eerowa pipiyaawo pinampiki, eerorika pamanari iyaapitsi pirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ipiye apaani pirentzi rahaateri. Roojatzi ijeekawaki itsipapaeni romonkyahaeteri. Arira noñeero kyaariperorika pikantakinari. Arika pitheeyakya, eerokataki eeteempiyawaerintzi.” ");
INSERT INTO cpy_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Romonkyaakaantakiri José maawoeni irikapaeni okaatzi mawa kitejeri. ");
INSERT INTO cpy_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Okanta omonkaataka mawa kitejeri, ikanteeri: “Nopinkathatziri Tajorentsi naaka. Arika pikemijantakina, eero pikami. ");
INSERT INTO cpy_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kyaariperorika pikameethashireteeyini, pamakina apaani pirentzi romonkyahaeteri, riyaateeta itsipapaeni raanaki owanawontsi royaari pitomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Arika pamakiri iyaapitsi pirentzi, ari noñeero kyaariperorika pikantakinari. Terika ari okantya, aritaki pikamaki.” Imateeyakironi ikanteetakiriri. ");
INSERT INTO cpy_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ari ikantawakaeyitanaka: “Tema kyaariperori teera aneshironkateri arentzi, tee akemijantziri ikantawitakae paerani eero owashironkaawaetziri, ikemaatsiwaetya. Rootaki añaantawori nimaeka ashironkaawaeta aakapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ari rakanaki Rubén, ikantanaki: “Tema nokantawitakimi paerani eero powashironkaawaetziri ewankari. Roo kantacha tee pikemijanteeyenani. Otzimatye atsipetyaawo rowajankiwentanteteero ikamakira.” ");
INSERT INTO cpy_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tee riyoteeyini riroripaeni ikemathatakirira José okaatzi ikenkithawaetakiri. Tema ikenkithawaetakaapiintakirira José eenitatsi owaahakotziniriri iñaani ikemathatantyaariri. ");
INSERT INTO cpy_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Iteenkapithatapaentziri José irikapaeni, ari riraawaetakari. Ikanta ipiyapaaka raapaakiri Simeón, roojotakaantakiri, maawoeni iñahaeyakirini. ");
INSERT INTO cpy_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Ikantakiri ronampiri riyeekiteniri owanawontsi, roepyakiniri iyorikite, roteyiteeniri owanawontsiki. Ipawakiri eejatzi rowaneeyaari awotsiki aririka riyaatee. Imatakiro okaatzi ikantakiri. ");
INSERT INTO cpy_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ari ikyaakaayitanakiri ikawayote owanawontsi, piyeeyaani. ");
INSERT INTO cpy_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ikanta rareeteeyaani jempe imahaeyapakini, raminakiro rowanawo ikoyi iperi royaari ikawayote. Iñaatziiri rotetaka iyorikite, rowaetakiniri jeñokiini. ");
INSERT INTO cpy_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ikantanakiri rirentzipaeni: “Pamineri noorikite roepiyeetaanari.” Antawoete ithaawaeyanakini riroripaeni, okawaeteeyanakani, ikantawakaeyita: “¿jempe ikanteeka Tajorentsi?” ");
INSERT INTO cpy_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ikanta rareeteeyaani Canaán-ki, ikamantapakiri ipaapate Jacob okaatzi awijimotakiriri, ikantapakiri: ");
INSERT INTO cpy_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Ishintsithawaetakina iñaanatana pinkatharitatsiri nampitsiki, roshiyakaakina naakami eeteempiyawaerintzi naminaantziro inampiki. ");
INSERT INTO cpy_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Ari nakanakiri naaka, nokantziri: ‘Kameethashireri atziri nineeyini, teera naaka eeteempiyawaerintzi. ");
INSERT INTO cpy_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nokaateeyini 12 yeeyipaeni, apaani ikanta ashitanari, eenitatsi itsipa apaani peyeenchari kaari noñaahae notsipateeyaari, eenitatsi itsipa eejatzi apaani iyaapitsi jeekanaentsiri itsipatanakari nopaapate Canaán-ki.’ ");
INSERT INTO cpy_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ari ikantanakina rirori: ‘Irokaha noñaantyaawori kyaariperorika pikantana kameethashireri pineeyini eerokapaeni. Pookanakina apaani pirentzi jaka, pipiyanaki eerokapaeni paanaki eepichokiini owanawontsi royaari pitomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Otzimatyeera pamakinari iyaapitsi pirentzi. Ari noñeero omaperotatyaarika pikantanari kameethashireri pineeyini, tee poshiyaari eeteempyawaerintzi eeroka. Ari nopakahaeri pirentzi, kantacha piyomparitya eeroka jaka nampitsiki tekatsi oowomeenchahemini.’” ");
INSERT INTO cpy_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ikanta rojokapakirowa rowanawopaeni, iñaatzi rirentzipaeni José rotetakoyiiteeniri iyorikite. Ikanta iñaakirira iyorikite, antawoete ithaawaeyanakini, imatzitanakawo ashitariri. ");
INSERT INTO cpy_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ari ikantanaki Jacob: “Rooteentsi pithonkitenari notomipaeni. Tee añahaeri José atsipatyaari, ari ikantakari Simeón. Eekiro pikowatzi payitenari eejatzi Benjamín. Oshekira okatsitzimotakina.” ");
INSERT INTO cpy_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ikanta Rubén ikantanakiri ipaapate: “Pishinetenari Benjamín, naakataki koerateerini. Aritaki namaemiri. Eerorika noepiyeeri, powamayeri apiteeni notyomipaeni naaka.” ");
INSERT INTO cpy_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Riitaki kantacha Jacob rakanaki, ikantanakiri: “Eero noshinetziri royaatemi notyomipaeni. Tema kamaki José rirentziwitari, riitaki yotapaenchari ijeekanaki rirori. Eenitatsirika awijimotakirinimi, eerokapaenira kantakaanteroni nokamantyaari, teera roo ayinani nantyashiparinka nowashirenkaha ayinani. ");
INSERT INTO cpy_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Eekiro iyaatatzi itasheyeetzi nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ikanta ithonkaeyakironi Jacob eejatzi itomipaeni rowakawo tzimahaantapaentsiri rowanawo raakitziri Egipto-ki, ikanteeri Jacob itomipaeni: “Papiitero piyaate, pamanantakite eepichokiini owanawontsi oyaari aakapaenika.” ");
INSERT INTO cpy_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ari rakanaki Judá, ikantanaki: “Ikantawakinaha paerani atziri: ‘Eerorika pamashitanari iyaapitsi pirentzi, teera nokoyi pipiyashiteena.’ ");
INSERT INTO cpy_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Arika pishinetakiri naanakiri yeeyi iyaapitsi, aritaki niyaataki namanante owanawontsi. ");
INSERT INTO cpy_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Rooma eerorika pishinetziri, eerowa niyaateeyini. Tema ari ikantawakina atziri: ‘Eerorika pamanari pirentzi, tee nokoyi pipiyashiteena.’” ");
INSERT INTO cpy_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ari ikantanaki Israel: “¿Iitaka powashironkaantanari? ¿Iitaka pikamantantariri eenitatsi itsipa pirentzi?” ");
INSERT INTO cpy_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ari ikanteeyanakini riroripaeni: “Tema osheki rojampiteeyakinani jemperika nokaateeyini, ikantana: ‘¿Eenitatsima ashitzimiri? ¿Eenitatsi itsipa pirentzi?’ Tekatsi nokinakaanakiro naakapaeni, otzimatye nakeniri rojampitanari. ¿Jempema niyotantakyaari ikowatziira nameniri iyaapitsi yeeyi?’” ");
INSERT INTO cpy_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ikantanakiri Judá ipaapate Israel: “Akoyirorika añaayite, pishinetenari iyaapitsi royaatanakina, naakaha koerateerini. Ari niyaatanaki nimaeka, ahaekarira atashe aakapaenika. ");
INSERT INTO cpy_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Naakataki pinatemini oetarika awijimotakirini iyaapitsi. Eerorika noepiyashitari jaka, naakaha kantakaantakirori roojatzi nokamanteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Eeromi atzimawentawaetziromi iroka ojamanitakaakaeri, apitera nopiyakimi namanante oyaari.” ");
INSERT INTO cpy_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ari rakanakiri ipaapate, ikantanakiri: “Tekatsi akinakayiro nimaeka, pimatero. Payitanakya eejatzi pipashityaariri atziri. Paanakiniri kyaariperori tzimatsiri anampiki: paanakiniri eepichokiini itziriitari, pitsi, kajankari, kepishaari, eejatzi pajotzikipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Poepiyeeniri koriki pakimiriri, pipinatapakiri eejatzi otsipa owanawontsi ipawakimiri, aamaeya tee riyotzi rotetakaakimirira koriki. ");
INSERT INTO cpy_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Piyaate piñahaateri atziri, paanakiri pirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Riira Tajorentsi Shintsiperori kantakaeyaawoni ineshironkaetantemiri, opoñaantyaari ishineteeri itsipa pirentzi eejatzi Benjamín. Ikoyirika ithonkya notyomipaeni naaka, imatyaata.” ");
INSERT INTO cpy_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ari raanaki itomipaenira Jacob ipashitantayityaari, raanakiri iyorikite roepiyeeteeniriri, rawijakaneentakiri itsipa ipinatapakirori owanawontsi ramaeri. Raanakiri Benjamín, jateeyanakini Egipto-ki. Rareetaawo ijeekira José. ");
INSERT INTO cpy_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iñaawakirira José rareetapaakaha Benjamín, ikantanakiri romperatane: “Paanakiri irikapaenika atziri nopankoki, powamaakaante nopira, ponkotsitakaante, nowakaatyeeyaarira irikapaenika tampatzikapaeteki.” ");
INSERT INTO cpy_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ari ikantakiro romperatane José okaatzi ikantakiriri. Raanakiri ipankoki. ");
INSERT INTO cpy_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Roo kantacha antawoete ithaawaeyanakini riroripaeni iñaakirowa rahaetanakiri ipankoki José. Ikantawakahaeyanakani: “Ikoshekawaetatyaaha irika. Aamashitya ikantawentatyeeri iyorikite roepyakaeri chapinki. Aamashitya rantawaetakaatyee roshiyakahae romperatane, ari ikantakiri eejatzi apirapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ikanta rareeteeyapaakanira ipankoki, ikenkithawaetakaapaakiri romperatane. ");
INSERT INTO cpy_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ikantapaakiri: ‘Arira nopokaki chapinki namanantzi owanawontsi. ");
INSERT INTO cpy_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Roo kantacha nareeteeyakani nomaapaakira, ari naminapaakiro owanawontsiki noñaakiri koriki rotetaka. Tee ithomakahaantawaeta. Namaeri nimaeka noepiyeeri. ");
INSERT INTO cpy_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Namaki itsipa koriki nopinaterori owanawontsi naaneeri. Roo kantacha tee niyomaeta iitakarika oteteeriri koriki namakiri chapinki.” ");
INSERT INTO cpy_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ari rakanakiri omperataarewo: “Eero pithaawashiwaeta. Aamaya riitaki owakiriri koriki Pitajorentsite eerokapaenira, Itajorentsite eejatzi ashitzimiri. Tema naawakiri naaka koriki ikaatzi pipinatakirori owanawontsi.” Romishitowakaantakiri omperataarewo irika Simeón, ramaeri ijeekaeyakinira rirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Roojatzi ikyaakaantanakariri maawoeni ipankoki José, ipapaakiri nijaa ikiwakoyityaari, ipakiri rowanawo eejatzi iyawayotepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tema yoteeyakini ari rowaeyakyaani, owetsika ikanteeyakani riroripaenira ipashitawakyaari José aririka rareeteeya tampatzikapaeteki. ");
INSERT INTO cpy_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ikanta rareetapaakaha José ipankoki, ipayitakiri okaatzi ramayitakiri inampiki. Ari ipinkathatanakiri, roeyootashitakari roojatzi raretakawo kepatsi. ");
INSERT INTO cpy_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ari rojampitanakiri José, ikantanakiri: “¿Tema pimantsiyawaeteeyini? ¿Jeekatsi pipaapate antyashipari pikantakinari, tee imantsiyawaetzi rirori? ¿Roojatzima rañi rirori?” ");
INSERT INTO cpy_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ari rapiitanakiro iñaapinkathatziri eejatzi, ikantanakiri: “Tee imantsiyawaete ashitanari, roojatzi rañi.” ");
INSERT INTO cpy_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ari raminanaki José ikatziyeeyakanira, iñaatziiri ikatziya rirentzi Benjamín, riitaki otomipaeni riniro rirori. Ikantanaki: “¿Riitaki iyaapitsi pirentzi pikantanari chapinki? Riitaki Tajorentsi tajonkawentemini!” Ari ikenkithawaetanakiro José iroka ñaantsi, ");
INSERT INTO cpy_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","antawoete omiraashiretanakiri iñaawakirira rirentzi, ikowawitanaka riraanakya. Ikyaanaki imaapiintzira, ari riraawaetapaakari. ");
INSERT INTO cpy_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ikanta ikaatakiro riraawaeta, ikiwawootanaa, shitowapae, ikantapaakiri: “Poyiitero owanawontsi.” ");
INSERT INTO cpy_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Inashita rowakoetakiniri rowanawo José, ari ikantakiriri itomipaeni Jacob, eejatzi Egipto-jatzipaeni ikaatzi tsipatapiintariri José. Tema tee ishinetantziro Egipto-jatzi rakyooteri Heber-ite. ");
INSERT INTO cpy_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Imatakiro rirentzipaeni José ijeekaeyakini jempe rookotakiniri. Retapaakawo roejeekawakiri antari rirentzi roojatzi iyaapitsi. Osheki okompitzimoteeyakarini irikapaenika. Ari raminawakahaeyanakani. ");
INSERT INTO cpy_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ari rowakaakari José irikapaenika okaatzi tzimimotziriri rowamentoki. Riitaki Benjamín ipaperotaki owanawontsi, awijanakiro okaatzi ipakiriri itsipapaeni. Kimoshirera ikantaka José itsipayitakarira rirentzipaeni rirawaeteeyakini. ");
INSERT INTO cpy_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Okanta amayitaka iroka, ikantakiri José romperatane: “Poteteniri owanawontsi irikapaenika atziri, potetayiteeniri iyorikitepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Potetakaeri niramento iyaapitsi, pitsipataakiniri iyorikite ipinawitakawori eentsikiroeni rimpoete owanawontsi.” Imatakiro romperatane okaatzi ikantakiriri José. ");
INSERT INTO cpy_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Owakira ishitowapaki ooryaa, rotyanteeri José rirentzipaeni ikyaakaaneeyaari ikawayote riyaayitee. ");
INSERT INTO cpy_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Tekiraha riyaatziita inteena, ikanteeri José romperatane: “Piyaate poyaatawaeri ananinkaneentsiri inkaahanki, pikanteri: ‘¿Iitaka pantantawori kaariperori? ¿Iitaka pikoshitantawori iramentotsi? ");
INSERT INTO cpy_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Rootakira riramento eewatanari, roo iñaawyaawaetantapiintari eejatzi. Pantakirowa kaariperori.’” ");
INSERT INTO cpy_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ikanta romperatane rareetawaari, ikantapaakiri ñaantsi ikantawakiriri omperatariri. ");
INSERT INTO cpy_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ari ikanteeyanakini rirori: “¿Iitaka pikantantanawori iroka ñaantsi? Teera nametawo nantayitero pikantakinari. ");
INSERT INTO cpy_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Tema piñaana nopiyaaha Canaán-ki, noepiyeemiri koriki ikaatzi noñaakiri rotetaka owanawontsiki. ¿Iitaka nokoshitantyaariri omperatzimiri? ");
INSERT INTO cpy_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Paminiro riramento omperatzimiri, aririka piñaakiro, iitakarika amakirori, ikamiita. Omperataarewo ninatye eejatzi naakapaenira ipankoki.” ");
INSERT INTO cpy_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ari ikantanaki omperataarewo: “Aritaki nomatakiro pikantakiri eerokapaenira. Arika noñaakiri iitakarika amakirori iramentotsi, apatziro nomperatashityaari. Riima itsipapaeni tekatsi nokanteri, riyaateeta.” ");
INSERT INTO cpy_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Intsipaete rowayiiteeyanakironi rowanawo, raminayitakiro. ");
INSERT INTO cpy_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ithonka raminahaantakiri omperataarewo, retanakari rantarite rirentzi eejatzi iyaapitsi. Iñaatziiro otetaka iramentotsi Benjamín-ki. ");
INSERT INTO cpy_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Itzijaanakiro iithaari, tema osheki okatsitzimoshiretanakiri. Inatakoyitaneero rowanawo, piyanaawo nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ikanta rareetapaaka Judá ipankoki José itsipayitakari rirentzipaeni, roojatzi ijeekaki José ipankoki. Rotziwerowashitapaakari, roeyootapaaka kepatsiki ipinkathatapaakiri. ");
INSERT INTO cpy_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Rojampitawakiri José, ikantawakiri: “¿Iitaka panteeyakirini? ¿Tema piyote atziri oshiyanari naaka riyotziro iñaawyaatanta?” ");
INSERT INTO cpy_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ikantzi Judá: “¿Iitaka nokantemiri eeroka? ¿jempe nokantyaaka piyotantyaawori? Riyotzi Tajorentsi eenitatsi kaariperori nantakiri. Irikateeyakinani naaka jaka: naakataki pomperatane notsipatakari iñaakoetakiri piramento.” ");
INSERT INTO cpy_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Riitaki kantacha José, ikantanaki: “Eero omata, apatziro nomperatyaari iñaakoetakiri niramento. Rooma eerokapaenira tekatsi nokantemi, piyaatee pipaapateki. Tekatsira oñaashirenkimini.” ");
INSERT INTO cpy_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Ikanta Judá ipokashitapaakiri José, ikantakiri: “Pikeme nokantemi pinkathari, pishinetena nokamantemi. Nokowakotemi eero pikijana, oshiyawityaawo eerokami Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tema pojampitakina eenitatsirika ashitanari, eenitatsirika eejatzi iyaapitsi yeeyi. ");
INSERT INTO cpy_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nokamantakimira naaka eenitatsi nopaapate, tema antyashiparitaki, eenitatsi eejatzi iyaapitsi yeeyi weyaantapaakawori itzimi rantyashipariwitakaha nopaapate. Pikemaki nokantakimi, osheki retakoperotakari nopaapate, tema riitaki weyaantawori itzimawae otsipaki iina nopaapate. Eeniwitacha paerani iina, kamaki rirori. ");
INSERT INTO cpy_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Pikowakotakinari eeroka nameri, tema pikowatzi piñeeri. ");
INSERT INTO cpy_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Pikemakina nokantanakimi tee ishinetziri nopaapate ipoke, aririka rookanentanakiri nopaapate, aritaki ikamanaki. ");
INSERT INTO cpy_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Roo kantacha pikanteeyakinani eeroka eerorika namashitari yeeyi, eero pishinetana napiiteero noñahaemi. ");
INSERT INTO cpy_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nokanta niyaatee paerani, nokamantapakiri nopaapate okaatziri pikantakinari. ");
INSERT INTO cpy_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Roojatzi ikantantaanari nopaapate: ‘Papiitero pipiye pamanante eepichokiini oyaari.’ ");
INSERT INTO cpy_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nokantanakiri naaka: ‘Eero omata nopiye eerorika naanakiri iyaapitsi yeeyi. Tema eerorika royaatana rirori, eerowa ishinetana jeewari noñeeri.’ ");
INSERT INTO cpy_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ari ikantanakina nopaapate: ‘Piyoteeyini eeroka apitemacheeni otzimaki pinirothori. ");
INSERT INTO cpy_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Peyakaha apaani, roojatzi nimaeka tee noñahaeri. Tema niyotaki rowakarira owantaneri.” ");
INSERT INTO cpy_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Arika paaneeri itsipa pirentzi ayinani, oetaarika awijimotakirini, eerokaha kantakaanteroni nokamantyaari, teera roo nantyashiparinkari nowashirenkaha ayinani.’ ");
INSERT INTO cpy_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Piñaakiro, antawoete retari nopaapate irika ewankari. Eerorika naaneeri, ");
INSERT INTO cpy_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","aritaki ikamaki nopaapate eerorika iñaawaeri. Naakatakira kantakaanteroni ikamantyaari ashitanari rowashirewaetanakyaarika. ");
INSERT INTO cpy_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nokantakiri eejatzi naakataki rashitakaeya nopaapate oetaarika awijimotakirini ewankari. Nokantakiri naaka: ‘Eerorika noepiyeemiri yeeyi, naakatakira kantakaanteroni roojatzira nokamantakyaari naaka.’ ");
INSERT INTO cpy_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Rootakira nokowakotantzimirori payiina pomperatane. Naakatakira poyaatyaarini irika ewankari. Pishineteri riyaate royaataneeri rirentzipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Jempema nokinakayiroka nopiye nopaapateki eerorika naaneeri yeeyi? Teera nokoyi noñeeri rowashirewaetya nopaapate.” ");
INSERT INTO cpy_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tee ramawetanakiro José ipiyoteeyakanira ratziripaenira, ikaemanaki: “¡Pishitowaeyawakini maawoeni!” Tekatsira romperatane José jeekaneentsini. Ari ikamanteeyanakirini, ikantziri: “Naakaha pirentzi.”. ");
INSERT INTO cpy_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Shintsiini rirahaeyakani, ikemaeyakirini maawoeni Egipto-jatzi. Jateeyanakini roojatzi iwinkatharipankoteki Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ikantanakiri rirentzipaeni: “Naakaha José. ¿Roojatzima rañi apaapate?” Antawoete ithaawaeyanakini irikapaenika itsipatakarira okaakiini. Tee rakanakiri. ");
INSERT INTO cpy_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ikantanakiri José: “Pipokaeyeni okaakiini.” Ikanta ipokaeyapaakini, ikantziri: “Naakatakira pirentzi José, naaka pipimantakiri paerani Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Eero okantzimowaetashitzimi eerokapaenira nimaeka, okantawitaka pipimantakina. Tema Tajorentsi otyaantakina jaka nowawijaakoteeri osheki atziri. ");
INSERT INTO cpy_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Awijakira apite ojarentsi iñahaetziro tashetsi jaka nampitsiki. Eenitatsira 5 ojarentsi eero iñahaeteero okithokitee pankirentsi, okantawitya ipankiwiityaawo. ");
INSERT INTO cpy_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Riitaki kantacha Tajorentsi rotyaantakina naaka jaka nowawijaakoyiteemi eerokapaenira, eero ithonkanta pitomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ari okantari, riitaki Tajorentsi otyaantakinari jaka teera eeroka. Rijatzi Tajorentsi owakinari nojeekanampiteri Faraón, neewateri romperatanepaeni, nopinkathariwentakiro eejatzi maawoeni Egipto. ");
INSERT INTO cpy_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Piyaate intsipaete apaapateki, pinkantapakiri: ‘Iroka ikantzi pitomi José: “Ipinkatharitakaakina Tajorentsi jaka Egipto-ki. Pipokanakiita intsipaete, piñeena. ");
INSERT INTO cpy_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Pinampitapaeyaawo iiteetziro Hosén, pitsipatapaeyaari pitomipaenika eejatzi picharinipaeni, ari powapaeri pipirapaeni, maawoeni tzimimotzimiri. Pitsipatapaena naaka. ");
INSERT INTO cpy_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Aritaki nopawakimi powanawo eeroka eejatzi pitomipaeni. Nopawakiri eejatzi pikaatzira pijeekaeyini, eero ikoetyaawaetanta riroripaenira. Tema eeniro iñahaetero itasheneentawaeteete okaate 5 ojarentsi.” ’ ");
INSERT INTO cpy_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Piñaakinaha eeroka pitsipatakari arentzi Benjamín naakaha kenkithawaetakirori iroka ñaantsi. ");
INSERT INTO cpy_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Pikamantapakiri apaapate piñaakitana nopinkathariwentantzi Egipto-ki. Pikamantapakiri eejatzi jempe okanta piñaakiro jaka. ¡Piyaatanakiita intsipaete pahaateri apaapate!” ");
INSERT INTO cpy_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ari rawithakitanakiri José rirentzi Benjamín, osheki riraanaka. Ari ikantakari eejatzi Benjamín osheki riraanaka rawithakitakirira José. ");
INSERT INTO cpy_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ari inintaawootanakiri José maawoeni rirentzipaeni, ari rirahaeyani rawithakitawakaaha. Roojatzi iñaanatantanaariri rirentzipaeni rirori. ");
INSERT INTO cpy_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Okanta iwinkatharipankoteki Faraón ikemaetaki arira rareeteeyani rirentzipaeni José. Antawoete ikimoshiretanaki Faraón, ari ikantzitakari eejatzi ikaatzira itsipanampiyitari. ");
INSERT INTO cpy_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ikanta Faraón ikantakiri José: “Pikanteri pirentzipaeni ikyaakaayitaneeyaari ikawayote ipiyeeta Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Roojatzi ramanteeyaariri ipaapate eejatzi isheninkapaeni. Aritaki nopakiri naaka kyaariperori kepatsi jeekatsiri Egipto-ki. Aritaki ininteeyaawo rowawaetapaeya okaatzi shookatsiri jaka nonampiki. ");
INSERT INTO cpy_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Pikanteri eejatzi raanaki shiyakomentotsipaeni ramanteeyaawori tsinanipaeni, eentsipaeni eejatzi pipaapate. ");
INSERT INTO cpy_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ipokaeyeniita, eero okantzimowaetashitari okaatzi tzimimotziriri nimaeka, tema okaatzi rooperoyitatsiri tzimayitatsiri jaka Egipto-ki riitaki ashiteeyaawoni.” ");
INSERT INTO cpy_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ari ikantakiro itomipaenira Israel. Ipayitawakiri shiyakomentotsi ikantakiriri Faraón. Ipawakiri eejatzi owanawontsi rowanaeyaari awotsiki. ");
INSERT INTO cpy_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ipawakiri eejatzi owakiraripaeni kithaarentsi ikithaataneeyaari. Riima Benjamín ipawakiri koriki ikaatzi 300 ikithoki, eejatzi 5 kithaarentsi. ");
INSERT INTO cpy_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ipakaantawakiri ipaapate ikaatzi 10 ikawayote ikyaakaayitakiri kyaariperori okaatzi tzimayitatsiri janta Egipto-ki. Eejatzi 10 ikawayote tsinani ikyaakaayitakiro owanawontsi, pan eejatzi otsipa owanawontsi royaari ipaapate ipokanakirika awotsiki. ");
INSERT INTO cpy_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ikanta riwethatawaari José rirentzipaeni, ikantawakiri: “Teera nokoyi pitzimawentawakaeya awotsiki piyaateeyeenira nimaeka.” Imatakiro jateeyeeni. ");
INSERT INTO cpy_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ipoñahaeyanaani Egipto-ki roojatzi rareetantaari Canaán-ki inampitawowa ipaapate Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ikamantapakiri itomi ikantziri: “Paawa, roojatzira rañi José, riitakira pinkatharitatsiri Egipto-ki.” Tekatsi ikantanaki Jacob, tema tee ikemijantziri okaatzi ikantawitariri. ");
INSERT INTO cpy_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Roo kantacha ikamantapaakirira maawoeni ñaantsi okaatzi ikantakiri José, oñaayitawakiro shiyakomentotsi rotyaantakaantakiri José ishiyakotantanakyaari Jacob, antawoetera ikimoshiretanaki. ");
INSERT INTO cpy_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ikantanaki: “¡Nokemaki eeniro rañi notyomi José! Otzimatye niyaate noñaapaeri tekira nokamanakiita.” ");
INSERT INTO cpy_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jataki Israel, raanakiro maawoeni tzimimotziriri. Ikanta rareetaka Beerseba-ki, ari itaapakiniri Itajorentsite Isaac ipaapate Jacob. ");
INSERT INTO cpy_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Okanta otsirenitanaki iñaanatakiri Tajorentsi imishiriki Israel, ikantziri: “¡Jacob!” Ari rakanaki rirori, ikantanakiri: “Iitaka.” ");
INSERT INTO cpy_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ikantanaki: “Naakataki Tajorentsi, rijatzi Itajorentsitetari ashitzimiri. Eero pithaawashiwaeta piyaate Egipto-ki, aritaki noshekyahaemiri pisheninkapaeni janta. ");
INSERT INTO cpy_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Aritaki notsipatakimi janta Egipto-ki, naakataki oepiyeerini pitomipaeni ijeekawitakyaarika janta. Ari okantya aririka pikamaki, itsipatapaemi José.” ");
INSERT INTO cpy_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ikanta Jacob rawijapithatanakiro Beerseba. Ikanta itomipaenira Israel, rotetanakiri shiyakomentotsiki rotyaantakiniriri Faraón: ipaapate, isheninkapaeni, eejatzi iinapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jataki Jacob itsipatanakari ikaateeyinira janta Egipto-ki, raanakiri ipirapaeni, maawoeni tzimimotakiriri janta Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Raanakiri itomipaeni, rishintopaeni, icharinipaeni, maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Iroka iwaeropaeni Israel-ite ikaatzi jataentsiri Egipto-ki. Ikaatzi itomiyitari Jacob: Rubén, reewarite itomi. ");
INSERT INTO cpy_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Irika itomipaeni rirori Rubén: Janoc, Falú, Jezrón, Carmi. ");
INSERT INTO cpy_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Itomipaeni rirori Simeón: Jemuel, Jamín, Ojad, Jaquín, Zojar, Saúl, riitaki otomi tsinani Canaán-jato. ");
INSERT INTO cpy_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Itomipaeni rirori Leví: Hersón, Coat, Merari. ");
INSERT INTO cpy_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Itomipaeni rirori Judá: Er, Onán, Sela, Fares, Zara. (Er eejatzi Onán kamaeyakini rirori janta Canaán-ki) Itomipaeni rirori Fares apite ikantamatsita: Jezrón, Jamul. ");
INSERT INTO cpy_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Itomipaeni rirori Isacar: Tola, Fúa, Job, Simrón. ");
INSERT INTO cpy_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Itomipaeni rirori Zabulón: Sered, Elón, Jajleel. ");
INSERT INTO cpy_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Riiyitakira itomipaeni Jacob ikaatzi itzimakakirori Lea ijeekantawitakari Padan-aram-ki, ari okaatzitakari eejatzi Dina rishinto. Tema 33 atziri ikaatzi rapatotanaka maawoeni otomipaeni roori, eenitatsi shiramparipaeni eejatzi tsinanipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Irika itomipaeni rirori Had: Zifión, Jahui, Ezbón, Suni, Eri, Awodi, Areli. ");
INSERT INTO cpy_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Itomipaeni rirori Aser: Imna, Isúa, Isúi, Bería, ritsiro iiteetziri Sera. Itomipaeni rirori Bería: Heber, Malquiel. ");
INSERT INTO cpy_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Riiyitaki otomipaeni Zilpa itzimakakirori Jacob. Tema iroka Zilpa rootaki ronampiriranki Labán ipakirori rishinto Lea. Tema 17 atziripaeni ikaatzi rapatotanaka maawoeni otomipaeni roori. ");
INSERT INTO cpy_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Irika otomipaeni Raquel, iinaha eejatzi Jacob: José itsipatakari Benjamín. ");
INSERT INTO cpy_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Irika itomipaeni José itzimakakirori Asenat: Manasés, Efraín. Riiyitakira tzimaentsiri Egipto-ki. Tema Asenat rishinto ini Potifera, omperatajorentsitaneri nampitsiki On. ");
INSERT INTO cpy_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Irika itomipaeni rirori Benjamín: Bela, Bequer, Asbel, Hera, Naamán, Eji, Ros, Mupim, Jupim ipoñaapaaka Ard. ");
INSERT INTO cpy_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Riiyitaki otomipaeni Raquel itzimakakirori Jacob, tema 14 ikaatzi rapatotanaka maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Irika itomi rirori Dan: Husim. ");
INSERT INTO cpy_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Irika itomipaeni rirori Neftalí: Jajzeel, Huni, Jezer, Silem. ");
INSERT INTO cpy_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Riiyitakira otomipaeni Bilja itzimakakirori Jacob. Tema iroka Bilja rootaki ronampiriranki Labán ipakirori rishinto Raquel. Tema 7 ikaatzi rapatotanaka maawoeni otomipaenipaeni roori. ");
INSERT INTO cpy_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Maawoeni atziripaeni itsipatakari Jacob rareeteeyakani Egipto-ki, isheninkapaeni rirori, ikaateeyini 66 atziri. Ikaatakira 66 atziri teera itsipateero raniropaeni. ");
INSERT INTO cpy_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tema itzimakira eejatzi apite itomi José Egipto-ki, rapatotanaka maawoeni kaatanaki 70 atziri. Riiyitakira isheninkapaeni Jacob ikaatzi areeteenchari Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Tema areetapaakaata Jacob Egipto-ki, rotyaantakiri Judá iñeeri José ipokeeta itonkyotawakyaari janta Hosén-ki. ");
INSERT INTO cpy_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Ikanta rareeteeyapaakani Hosén-ki, ikantakiri José romperatanipaeni ramineniri ishiyakomento itonkyotantawakyaariri ipaapate. Ikanta iñaawootawaeri ipaapate, rawithakitawakiri, ojamani ikantaka riraaka. ");
INSERT INTO cpy_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ikanta Israel ikantanakiri José: “Aritakiira noñaawootapaemi eenirowa pañi. ¡nimaekaha nokami!” ");
INSERT INTO cpy_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ari ikantanakiri José rirentzipaeni eejatzi maawoeni isheninkapaeni ipaapate: “Paata noñaakiteriita Faraón, nokamanteri, nokanteri: ‘Areeteeyakani yeeyipaeni, isheninkapaeni ipaapate ikaatzi nampitawori Canaán-ki, ipokaeyakini itsipatapaena nojeekira naaka. ");
INSERT INTO cpy_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ramayitakiri rovejate, ivacatepaeni, okaatzi tzimimoyitziriri riroripaeni, maawoeni. Tema rootaki rantawaero riroripaeni ikoeraayitziri ipirapaeni.’ ");
INSERT INTO cpy_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Arika ikaemakimi Faraón rojampitemi: ‘¿Iitaka pantawaetziri?’, ");
INSERT INTO cpy_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","pikanteeyerini eerokapaenira: ‘Apatziro nameteeyarini nokoeratziri nopira, ari noshiyakotari ikantaha paerani nocharinini.’ Rootaki pimatantyaawori pinampityaawo Hosén-ki. Tema tee inimoteri Egipto-jatzi itsipatyaari koeraayitziriri oveja.” ");
INSERT INTO cpy_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Jataki José ikamanteri Faraón. Ikantapaakiri: ‘Areetakaha nopaapate itsipayitakari yeeyipaeni ipoñaakawo Canaán-ki. Ari ijeekaeyapaakini Hosén-ki, ijeekakaapaakiri rovejatepaeni, ivacatepaeni, ikaatzi tzimimoyitziriri, maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ramaki ikaatzi 5 rirentzipaeni, iñeeri Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ikanta Faraón rojampitakiri rirentzipaeni José, ikantziri: “¿Iitaka pantawaetziri eerokapaeni?” Ikanteeyanakini riroripaeni: “¡Nowinkatharite! Nameteeyawoni naaka nokoeratziri oveja, ari noshiyari nocharinini. ");
INSERT INTO cpy_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nopokaeyatziinira nonampityaawo jaka, tema antawo iñahaetakiro tashetsi janta Canaán-ki, tekatsi rowaeya eejatzi novejatepaeni. Nokowakotzimiro, nowinkatharite, nonampityaawo jaka Hosén-ki.” ");
INSERT INTO cpy_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ikanta Faraón ikantanakiri José: “Pokakira pipaapate eejatzi pirentzipaeni itsipateemi eeroka. ");
INSERT INTO cpy_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Okaatzira kepatsi jeekatsiri Egipto-ki, eerokataki aminakaantzirori. Piperi janta Hosén-ki, ari inampityaawo, tema kyaariperori ini ironta kepatsi, tekatsi oshiyaawoni. Eenitatsirika pisheninkaete yotaperotziriri ikoeratziri ovejapaeni, pikanteri ikoeratenari nashi naaka.” ");
INSERT INTO cpy_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ari raanakiri eejatzi José ipaapate Jacob janta Faraón-ki iñeeri. Riwethatapaakari Jacob pinkathari Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Rojampitawakiri Faraón, ikantziri: “¿jempe okaatzika pojarentsite?” ");
INSERT INTO cpy_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ikantanaki Jacob: “Tzimaki 130 nojarentsite nokinakinawaeyitzi jemperikapaeni. Tekira ojamaniteeta ojarentsi noñaakiro okaariperowaetaki, teemaeta nomonkaatyaawo nañe okaatzi ikinakinawaetaki etanakawori nocharinipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ari riwethatanaari Jacob pinkathari Faraón, piyanaawo. ");
INSERT INTO cpy_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ipakiri nimaeka José kyaariperori kepatsi, ari inampiteeyakawoni janta, imonkaatakiro ikantakiriri Faraón. Roojatzi otzimantaari iipatsite ipaapate eejatzi rirentzipaeni iiteetziro Ramesés. ");
INSERT INTO cpy_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Eekirowa ipapiintatziiri José rowanawo maawoeni isheninkapaeni, oetarika koetyiimoyitariri. ");
INSERT INTO cpy_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Tekatsira nampitsi jempe otzime owanawontsi, eekiro iyaatatzi itasheneenteetzi. Kamayitatsi atziripaeni aayitziri itashe Egipto-ki eejatzi Canaán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ithonka ipiyotakiri José maawoeni koriki ikaatzi ipinayitziriri Egipto-jatzi, Canaán-jatzi, ramanantayitzira owanawontsi, rowakiri koriki iwinkatharipankoteki Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ari thonkapaaka koriki Egipto-ki eejatzi Canaán-ki, riyaateeyakini Egipto-jatzi iñeeri José, ikantapaakiri: “Pipena eeroka nowanawo. Tee okameethatzi pishinetena nokamayite tekatsitapaaki noorikite.” ");
INSERT INTO cpy_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ari rakanakiri José, ikantanakiri: “Thonkapaakarika piyorikite pamayite pipira, rootaki opinatyaari nopemira powanawo.” ");
INSERT INTO cpy_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ramayitaki Egipto-jatzi rovejate iperi José, ivacate, ikawayote. Riitaki ipinatziriri José ikaatzi ramayitakiri, ipayitapiintakiri rowanawo. ");
INSERT INTO cpy_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Okanta awijanaki ojarentsi, kyaapaaki otsipa ojarentsi, jateeyeeni eejatzi ikantapakiri José: “Teera namatawitatyeemi eeroka, arira ikaatapaaki noorikite. Maawoeni nopirapaeni tema pashitakari eeroka. Tee otzimapae otsipa oeta nopemiri, apatziro noepatsite eejatzi naakapaenira. ");
INSERT INTO cpy_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nokoyi pamananteeyenani naakaete pitsipatahaenawo noepatsite, pipimaetena nowanawo. Romperatane rowayitakina Faraón, ari nantawaetzimaetyaanari noepatsiteki, pipimaetenawo nopankiteri nañaantayityaari, eero apaatashiwaetanta noepatsite. ¿Iitaka pishinetantenari eeroka nookawentyaawo noepatsite?” ");
INSERT INTO cpy_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ikanta José ramanantakiro maawoeni kepatsipaeni tzimimoyitziriri Egipto-jatzi rashityaawo Faraón. Imatakiro Egipto-jatzi ipimantayitakiro iipatsite okantakaantziro tashetsi. Rootaki rashitantakawori Faraón maawoeni kepatsipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Maawoeni Egipto-jatzi, romperatane rinayitaki Faraón. ");
INSERT INTO cpy_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Eenitatsi otsipa kepatsi kaari ramanante José, roo rashipaeni omperatajorentsitaarewo, tema ipapiintakiri Faraón rowanawo. Rootaki opoñaantari kaari ipimantantawo iipatsite. ");
INSERT INTO cpy_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ikanta José ikantakiri atziripaeni: “Maawoeni eerokapaenira eejatzi piipatsite rashiyitakimi Faraón, tema riitaki namanantakiniri. Irokaha nimaeka okithoki pipankiteeyerini kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Otzimatye pinashityaawo pipiyotero piwankiri okaate 5, paaki apaani pipapiinteeriri Faraón. Rooma otsipa 4 tzimahaantaneentsini powaantyaawo pipankiteeri otsipaki ojarentsi, roojatzi powakaeyaariri pitomipaenira, powakaeyaari pikaateeyinira pijeekaeyini.” ");
INSERT INTO cpy_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ari ikanteeyanakini riroripaeni: “Neshironkatantaneri pini eeroka pineshironkateeyakinani, tema powawijaakotakina nokamayitemi. ¡Romperatane ninayitayi Faraón!” ");
INSERT INTO cpy_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ari inintakaantanakiro José rowiitapiinteeniri Faraón eepichokiini aririka rowiiyitero pankirentsi Egipto-ki. Roojatzira okanta nimaeka ikowakaanteetziri. Riima omperatajorentsitaarewo, tee rashitawo paerani Faraón iipatsite riroripaeni, rootaki kaari ipinawaetanta. ");
INSERT INTO cpy_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Arira inampiteeyakawoni Israel-paeni janta Egipto-ki. Inampiperotakawowa janta Hosén-ki. Rashitapaakawo kepatsi, riitaki kyaaryooteentsi roshekitapaaki riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Awijaki 17 ojarentsi ijeekapaaki Jacob Egipto-ki. Okaatzi apatotanaka 147 rojarentsite. ");
INSERT INTO cpy_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Rooteentsi iyomaatya ikamantyaari Israel. Ikaemakaantakiri itomi José, ikantakiri: “Kyaariperorika pimatenawo nokantemiri, poteeyachokitena, pikantena aririka pimatakinawo nokowakotemiri. Teera nokoyi pikitatena Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Arika nomakoryaaki notsipatapaeyaari nocharinipaeni, paanakina, pinkitateena jempe ikitayita riroripaeni.” Ari ikantanaki José: “Aritaki nomatakiro.” ");
INSERT INTO cpy_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Eekiro ishintsitanakitzi ipaapate: “Pikantena teera nokoyi pamatawitena.” Ari rapiitanakiro ikantziri: “Aritaki nomatakiro.” Oeyootanaka Israel imaamentoki. ");
INSERT INTO cpy_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Tekira ojamaniteeta ikamanteetakiri José, ikanteetziri: “Mantsiyatakira pipaapate.” Jatanaki José ramineri ipaapate, ari raanakiri apite itomi Manasés eejatzi Efraín. ");
INSERT INTO cpy_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ikamanteetakiri Jacob, ikanteetziri: “Areetapaaka pitomi José raminemi.” Ratsiwakanakawo, piriintanaka. ");
INSERT INTO cpy_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ikenkithatakaawakiri Jacob itomi José, ikantziri: Roñaahakina Tajorentsi Shintsiperori, nampitsiki Luz, jeekatsiri janta Canaán-ki. Itajonkawentakina, ");
INSERT INTO cpy_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ikantapaakina: ‘Aritaki noshekyahaemiri pitomipaeni. Ikaate pichariniyiteeyaari, osheki rinashiyiteeya isheninkaetepaeni. Aritaki nashitakaeyaari iroka kepatsi. Rootaki rashiteeyaari riroripaeni ari ikanteetatyeeyaani.’ ");
INSERT INTO cpy_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Irika apite pitomi Manasés eejatzi Efraín, ikaatzi tzimaentsiri jaka Egipto-ki tekira nopokanakiita notsipateemi pijeekira eeroka jaka nampitsiki, noshiyakahaeri naakami ashityaarini. Nokimiteerira Rubén eejatzi Simeón naakataki ashitari. ");
INSERT INTO cpy_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Riima itsipa pitomipaeni pipoyaateeri pitzimaeri, riitaki pashityaari eeroka, eero noshiyakahaeri riimi notyomipaeni naaka. Okantakaantziro rirentzitari Manasés eejatzi Efraín, aritaki oshekitzimoteeri eejatzi okaate nashitakaayityaariri paata rirentzi. ");
INSERT INTO cpy_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Okanta noshitoyeero paerani Padan-aram-ki, okamimotakina piniro Raquel janta Canaán-ki, roowiteencha nareeteyaami Efrata-ki. Ari nokitatanakiro janta ikinapiinteetzirowa Efrata-ki, iiteetziri eejatzi Belén.” ");
INSERT INTO cpy_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ari ikempoyaanakiri itomipaeni José, ikantziri: “¿Iitaka irikapaeni?” ");
INSERT INTO cpy_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ikantanaki José: “Riiyitaki notyomipaeni ipakinari Tajorentsi jaka Egipto-ki.” Ikantanaki ipaapate: “Pamakiri okaakiini, niwethataneeyaariita.” ");
INSERT INTO cpy_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Antyashiparitapaaki kameetha Jacob, tee ikowichaate kameetheeni. Ramakiniri José okaakiini itomipaeni, ari inintaawootakiri eejatzi rawithakitakiri. ");
INSERT INTO cpy_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ari ikantanákiri José: “Teera nokenkithashirewita noñahaemi, riitaki kantacha Tajorentsi ikantakaakawo noñaanakiri pitomipaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Rakathatakiri José itomipaeni roejeekakiri iporiki ipaapate, otziwerowanaka rirori roeyootanaka roojatzi kepatsiki ipinkathatanakiri. ");
INSERT INTO cpy_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Raakiri apitepaeni itomi, roteeyantanakari Efraín rakoperori, riima Manasés roteeyantanakari rampate. Rontsirokapaakiri ipaapate. Jeekanaki Efraín rampateki Israel, riima Manasés rakoperoki. ");
INSERT INTO cpy_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ikanta rowaankawakotanakaha Israel, ikonompiwakotanaka, roteeyapatziitotantakari Efraín rakoperori, riiwitaka iyaapitsi. Riima Manasés roteeyapatziitotantakari rampate, riiwitakaha jewari. ");
INSERT INTO cpy_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ari riwethatanaari José, ikantanakiri: “Namañaari Tajorentsi ikemijantakiri Abraham, eejatzi ashitanari Isaac. Rijatzi Tajorentsi kempoyaawentakinari notzimakira paerani roojatzi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Namañaari Ronampiri tajorentsi ontsiparyaawentapiintanawori maawoeni kaariperori, nokantziri: ‘Pitajonkawentenari irikapaeni eentsi. Riitaki kantakaanteroni ikenkithashiretantapiinteetenari naaka, ikenkithashiretantapiinteetyaariri ashitanari, Isaac eejatzi Abraham. Itzimayitee osheki itomipaeni. Riitaki oshekiperotaatsini kepatsiki.’” ");
INSERT INTO cpy_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Riitaki kantacha José tee okameethatzimotziri rantakiri ipaapate, roteeyapatziitotantashitakari rakoperori Efraín, rooma rampate roteeyapatziitotantakari Manasés. ");
INSERT INTO cpy_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ikantziri: “Tee ari okantya. Irika jewatatsiri itzimi. Poteeyapatziitotantyaari pakoperori.” ");
INSERT INTO cpy_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Riitaki kantacha tee ikoyi ipaapate, ikantanakiri: “Niyotaki notyomi. Aritaki imatakiro eejatzi iriroperotee ikaatera isheninkatawakaeya. Riima rirentzi iyaapitsi riitaki awijeerini iriroperote, imaperoteeya roshekitee isheninkapaeni.” ");
INSERT INTO cpy_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Irira ipasonkitakotanakari, ikantanakiri: “Rootaki piwaero iñaawaetapiinteeri Israel-ite aririka riwethatantya, ikantayitee: ‘Imatakimiro Tajorentsi eeroka okaatzi imatakiniriri Efraín eejatzi Manasés.’” Riitaki Efraín retakari ipasonkitakotakari eejatzi Manasés. ");
INSERT INTO cpy_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ari ikantanakiri José: “Rooteentsira nokame. Riitaki Tajorentsi tsipatapiintemini eerokapaeni. Aritaki roepiyeemi iipatsiteki picharinini. ");
INSERT INTO cpy_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Eerokaha nopaperotaki pawijanakiri pirentzipaeni. Nopemiro ochempi naapithatakiriri paerani Amor-jatzi nowayiritantakariri rirori.” ");
INSERT INTO cpy_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ikaemakiri Jacob maawoeni itomipaeni, ikantakiri: “Pontsirokena okaakiini, nokamantatyeemirowa okaate awijimotemini paata. ");
INSERT INTO cpy_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","¡Itomipaeni Jacob! Pipokaeyeni okaakiini pikemantyaari. Powayempitatyaariri pipaapate Israel. ");
INSERT INTO cpy_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Eeroka Rubén, neewarite notyomi, Noshintsinka noyimi, eerokataki etakaantanakawori noshintsinka, Eeroka etawori ipinkatheetzimi, oshekitzimotzimi pishintsinka. ");
INSERT INTO cpy_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ari okaatzimaetapaaka piriroperotane, Poshiyawitapiintakawo oshinchaari nijaa, Tema pitheenkaneentzitakinawo nomaamento. ");
INSERT INTO cpy_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Rooma eeroka Simeón eejatzi Leví, pirentzi powawakaeyaani, Powamaamento powayitakiro pichekopitepaeni. ");
INSERT INTO cpy_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Eerowa napiiteero notsipateeyeemini jempe pipiyoteeyapiintani. Tema otyahakimi paerani pimashirenka osheki atziri powamaaki. Okantakaantziro pikijawaetaka piitzinkakiiwaetanakiri piratsipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Koweenkari okantaka piyatsimankari, Omaperota pikijanaka. Naaka mataperoteemini notzimpookayiteemi notsipatahaemiri Israel-ite. ");
INSERT INTO cpy_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Rooma eeroka Judá, rajahaawenteemi pirentzipaeni. Poteeyakentsiyiteeri kijaneentemini. Ipinkathayiteemi pirentziteeyaari. ");
INSERT INTO cpy_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Eeroka Judá, notyomitari naaka. Poshiyaari iryaani manitzi aririka ipakaeri rowari ratsikane. Roeyoota, romaryaawaeta kepatsiki, ikantaha antari manitzi. ¿Iitaka materoni oñaashirenkaerini? ");
INSERT INTO cpy_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tekatsira materoni raapithateeri ishintsinka Judá, Tekatsi aapithateerini iwinkatharimento roteeyakiri, Roojatzi ipokantakyaari ashitawori iwinkatharimento, Ikemijantawakiri inashiyitachari roshekitawakayitaha. ");
INSERT INTO cpy_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Riitaki oojotakoterini iyawayote oponkitziki pankirentsi rireetziri, Ikiwantawo rireetziri maawoeni iithaari, tema oshekiperotatzi chochoki rireetziri. ");
INSERT INTO cpy_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kameethantzi ikanteeya, tema cheenkaakiri okantayitya rooki awijanakiro ocheenkatzi rireetziri. Kitamaari okantayitya raeki awijanakiro okitamaatzi tenitsi. ");
INSERT INTO cpy_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Inampiteeyaawo Zabulón inkaarecheraki, jempe aatapiintayita amaatakomentotsi. Ari iweyaathapiyiteeyaani roojatzi janta Sidón-ki. ");
INSERT INTO cpy_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Roshiyeeyaari Isacar piratsi ikyaakahaetari, Ari makoryaapiintatsini piratsipankoki. ");
INSERT INTO cpy_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ikanta iñaawakirowa kameethari owetsikaka imakoryaanteetyaawo, Oeyootanaka inatakahaeteri. Maeriri ikantaka roshiyakahaetziri omperataarewo. ");
INSERT INTO cpy_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ipinkathariwenteeri Dan isheninka ikimitaa itsipa ipinkathariwenteeri Israel-ite. ");
INSERT INTO cpy_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Roshiyeeyaari Dan maanki ijeeki awotsinampiki, Riitaki atsikakiiterini kawayo, Rowariimaetyaari kyaakotariri. ");
INSERT INTO cpy_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡Tajorentsi! Nawentahaemi powawijaakoteena. ");
INSERT INTO cpy_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ikoshekawaetaari Had owayiri-paeni, Riitaki kantacha aritaki nopiyatakyaari paata. ");
INSERT INTO cpy_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Riima Aser oshekitzimoteeri iwankiri rowaeyaari, Kyaariperori owanawontsi ini, oshiyaawo rowanawo pinkathariperori. ");
INSERT INTO cpy_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Roshiyaari Neftalí maniro tekatsi ashitakoterini, Owaneenkatacha ikantayita itomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Riima José roshiyaawo pankirentsi shookatziiri ocheraki nijaa, Osheki okithokinite, Ithonkiro itaayitziro otanto. ");
INSERT INTO cpy_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Osheki ikijaneenteeri omanatzinkari, Roma-natantapiinteeyaari chekopi, Ikanteetatyeeyaani roñaashirenkapiinteeri. ");
INSERT INTO cpy_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Riitaki kantacha José shintsishempa ikanta rirori, kijokiro royiro iwiani. Ikaminthakiri Itajorentsite Jacob Shintsiri, Okamintha iwaero kempoyaawentantaneri, kijakowentariri Israel. ");
INSERT INTO cpy_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ikamintha Itajorentsite ashitzimiri, ri neshironkateemini. Riitaki Tajorentsi Shintsiperori, riitaki tajonkawenteemini. Opoñaawo itajorenka jenoki ikiteki. Opoñaawo itajorenka inthomoeyaaki inkaareki. Opoñaawo itajorenka tenitsiki eejatzi owamaarentsiki. ");
INSERT INTO cpy_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Okaatzira ipasonkitakotanakimi ashitzimiri, Awijanakiro okaatzi ipasonkitakotanari ashitanari naaka. Eero opeyaawo, roojatzi paata eero iñahaetantaawo eejatzi ochempi. Oshiyakawo ijeepatziitotanteetyaarimi José irokapaeni tajorenkantsi, Tema riitaki riyoyahaetakiri itsipatakari rirentzipaeni, riitaki riroperoyitaatsini. ");
INSERT INTO cpy_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Roshiyeeyaari Benjamín owantaneri, rananinki rowamanaari ratsikane, Arika otsireniityaane ipawakaeyaani tzimahaantapaentsiri.” ");
INSERT INTO cpy_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Riiyitakira isheninkapaeni Israel, rootaki ñaantsipaeni ikantanakiriri ipaapate ipasonkitakotanakari itomipaeni. ");
INSERT INTO cpy_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ikantanakiri itomipaeni: “Okaatapaakiini nokamantyaari. Pitsipatahaenari nocharinipaeni pinkitateena, omookira iipatsiteki Efrón Het-jatzi, ");
INSERT INTO cpy_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","jeekatsiri janta Canaán-ki. Rootaki omoowa jeekatsiri Macpela-ki, amontetari Mamre, ramanantakiri paerani Abraham itsipataakiro iipatsite Efrón, okitataaha iina. ");
INSERT INTO cpy_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Jaha ikiteetakiri Abraham itsipatahaetakiri iina Sara, eejatzi Isaac itsipatahaetakiri iina Rebeca. Ari nokitateero eejatzi Lea. ");
INSERT INTO cpy_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ironta kepatsi eejatzi omookira jeekatsiri janta riira Het-jatzi pimantakirori paerani.” ");
INSERT INTO cpy_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ikanta ithonkari Jacob riyotaayitanayiri itomipaeni, ari roma-ryaanakari, kamanaki. Itsipatapaari isheninkapaeni. ");
INSERT INTO cpy_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ikanta rawithakitanakiri José ikamakira ipaapate, rirayimankakiini ithowootanakiri. ");
INSERT INTO cpy_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ikantanakiri aawintantzinkari itsipatakarira, itziritantyaari yeenkantsi ipaapate Israel. Ari itziritantakari yeenkantsi iwathaki. ");
INSERT INTO cpy_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Okaatzi 40 kitejeri rojamanitaki itziritantakariri okine eero ishitzitanta. Tema omaperotatya okowaperota iroka. Osheki Egipto-jatzipaeni owashiretakotakotakariri Israel, okaatzi 70 kitejeri ojamanitaki rowashiretakotari. ");
INSERT INTO cpy_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Okanta awijaki rowashiretakoetari, ikenkithawaetakaakiri José ikaatzi jeekatsiri ipankoki Faraón, ikantakiri: “Kyaariperorika nokameethatzimotzimi eerokaete, nokoyi pinkantenari Faraón, pikanteri: ");
INSERT INTO cpy_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Tema ikamimatakira paerani nopaapate, ikantakina eero namatawitziri, otzimatye nokitateeri jempe rowetsikaantaka rirori, jantaha Canaán-ki ojeekiri. Rootaki nokowantari pishinetena niyaate nokitateeri nopaapate, aririka nokitatakiri, ari nopiyeero.” ");
INSERT INTO cpy_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ari rakanaki Faraón, ikantanakiri: “Piyaate pikitateeri pipaapate, pimatero okaatzi ikantakimiri paerani.” ");
INSERT INTO cpy_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Jataki José inkitateeri ipaapate, ari royaateeyanakirini jeekanampiyitziriri iwinkatharipankoteki Faraón, ikaatzi pinkathariyitatsiri eejatzi Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ari iyaatzitanakari isheninkapaeni Jacob, rashi José, eejatzi rashi rirentzipaeni. Apatziro rookaeyanakirini eencheeriki eejatzi ipirapaeni janta Hosén-ki. ");
INSERT INTO cpy_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Eenitatsi atziripaeni kinakoyitaneentsi ishiyakomentoki, itsipa kinakoyitaneentsiri iyawayoteki royaateeyanakirini José. Osheki ikaateeyini atziri. ");
INSERT INTO cpy_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ikanta rareeteeyapaakani Atad-ki, intatsikeronta Jordán, ari ranteeyapaakironi rameteeyarini riroripaeni ikenkithashiretakotari kamayitatsiri. Ari rowashiretakowaetanakari José ipaapate okaatzi 7 kitejeri. ");
INSERT INTO cpy_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ikanta iñahaeyakirini Canaán-jatzi nampiyitawori janta, ikanteeyanakini: “Ikitatatziiri Egipto-jatzi iriroperorite kaminkari.” Rootaki iitantakawori riroripaeni Abel-mizraem intatsikero Jordán-ki. ");
INSERT INTO cpy_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Imatakiro itomipaeni Jacob okaatzi ikoyiri ranteniriri. ");
INSERT INTO cpy_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Raaneeri Canaán-ki, ikitateeri omooiki jeekatsiri Macpela-ki, ramanantakiri paerani Abraham rashiwitari Efrón Het-jatzi jempe ikitayiteeya isheninkapaeni. Iroka kepatsi eejatzi omooha omontetari Mamre. ");
INSERT INTO cpy_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ikanta ithonkakiri ikitatakiri ipaapate, piyaanawo José Egipto-ki itsipataari rirentzipaeni eejatzi ikaatzi oyaatanakiriri, maawoeni. ");
INSERT INTO cpy_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kamakira Jacob, ikenkithashireteeyaakani rirentzipaeni José, ikantashireteeyini: “Aamashitya ari ikijaneentakae nimaeka José, ipiyawenteeya owaariperowaetakirira paerani.” ");
INSERT INTO cpy_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Rotyaantaki kanterini José: “Tekira ikamanakiita pipaapate, ikantakina nokamantemi: ");
INSERT INTO cpy_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nokoyi pariperoteeri pirentzipaeni, rowaariperowaetakimira, ikemaatsitakaawaetakimi.’ Rootaki nokowantari pipeyakoteero rowaariperowaetakimira, tema naaka romperatane Itajorentsite pipaapate.” Ikenkithawaetakayirira José rotyaantane rirentzipaeni, iraawaetacha rirori José. ");
INSERT INTO cpy_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ari rareeteeyapaani rirentzi, rotziwerowashitapaakari, roeyootapaaka kepatsiki, ikanteeyini: “Irikateeyakinani, naakataki pomperatane.” ");
INSERT INTO cpy_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Riitaki kantacha José rakanakiri, ikantziri: “Eero pithaawashiteeyani. ¿Naakama Tajorentsi.? ");
INSERT INTO cpy_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Pikenkithashirewiteeyakani eerokapaeni powaariperotenami, riitaki kantacha Tajorentsi riyotakiro okaatzi kaariperori pantawitakari, ikantakaakawo Tajorentsi kameethari okantzimotanteeya, rootaki nomatantakawori okaatzi añaayitziri nimaeka, rowawijaakotanteeyaariri osheki atziri. ");
INSERT INTO cpy_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Eero pithaawashiwaeta. Aritaki nopayitakimi poyaari eeroka eejatzi pitomipaenira.” Ari ikantakiri José ikenkithawaetakaakiri kameetha rirentzipaeni rinimotakahaeri. ");
INSERT INTO cpy_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ikanta José eejatzi isheninkapaeni ipaapate, eeniro inampiteeyaawoni Egipto-ki. Okaatzi 110 rojarentsite rañaaki José. ");
INSERT INTO cpy_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Iñaayitanakiri itomi Efraín. Iñaanakiro eejatzi ishekinkatari itomipaeni icharini Maquir, itomira Manasés. ");
INSERT INTO cpy_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Okanta paata, ikantakiri José rirentzipaeni: “Iyotapaaka eepichokiini nokamantyaari, roo kantacha ari ipokaki Tajorentsi ineshironkateemi, raayiteemi pijeekayiwitakaha jaka nampitsiki, rookaemi otsipaki kepatsi ipakiriri paerani Abraham, Isaac eejatzi Jacob.” ");
INSERT INTO cpy_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ikanta José ikantayitakiri itomipaeni Israel: “Aritaki ipokaki Tajorentsi ineshironkateemi. Nokowatzi pikantaperotena, eero pamatawitana, paayitaneerowa eerokapaeni notonkipooki.” ");
INSERT INTO cpy_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ari ikamaeri José janta Egipto-ki okaataki 110 rojarentsite. Itziritanteetakari yeenkantsi iwathaki, rowaetakiniri. ");
INSERT INTO cpy_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Okanta paata, kamae rirori José, matzitaka rirentzi-paeni, eejatzi ikaatzi itsipatakari ipokaeyakini paerani. ");
INSERT INTO cpy_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Roo kanteencha eekiro riyaatatzii isheniteeyini rirori Israel-paeni, tekatsi otsinampaerini. Tema ithonka inampitan-takawo maawoeni Apitantoni. ");
INSERT INTO cpy_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Okanta paata tzimae Apitantoniki owakirari pinkathari, teemaeta ikemako-tziri José okaatzi rantakiri inampiki. Riitaki kantapaa-kiriri isheninka-paeni Apitantoniki, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“¡Nosheninká! Shenitaki Israel-paeni anampiki, riroperori ikantee-yakani, tema rawijanakae aakapaeni. ");
INSERT INTO cpy_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Otzimatyee amini jempe akinakaero eero ishenitanta, aamaeyaa otzima-minthatakirika owayiritaantsi, ari raapatziya-wakyaari ikaatzi kijaneenteeri, ari ipithoka-shitanakae aakapaeni, aritaki riyaayitee ijeekae-yawitani anampiki.” ");
INSERT INTO cpy_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ari retanakawo Apitantoni-jatzi imapero-tziri rompera-waetari Israel-paeni, rowetsika-kaakiri apite nampitsi, iiteetziro “Manchakironi” itsipa iiteetziro “Itomyaani Ooryaa”. Rootaki rowaahaanta-pankoti pinkathari Faraón. Osheki ratsipetakaa-waetakaakari Israel-paeni rompera-yitakari, rowayitaki aminayi-terini jempe rantawae-takaeri. ");
INSERT INTO cpy_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Tema imapero-witeeta-tyaari Israel-paeni ratsipetakahae-tari, eekiro ishenitatzii rirori. Tema ithaawantani itzima-kirini Apitantoni-jatzi irika Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Eekiro imapero-witatyaari Apitantoni-jatzi rompera-waetari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Antawo rowatsimae-takiri Israel-paeni rompera-waeteetarira, roetziñaarikotakawo itaakahae-tziri kepatsi rowetsikan-teetyaawori ipanko-paeni, rantawae-takae-tziri owaantsiki. Tema osheki ratsipetakahae-takari. ");
INSERT INTO cpy_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Ikanta pinkathari-tatsiri Apitantoniki ikenkitha-waetakaakiro Sifra eejatzi Fúa, tema rootaki aminirori tsinani-paeni Heber-paeni aririka otzimaanite, ikantakiro: ");
INSERT INTO cpy_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Paminiro tsinani-paeni Heber-paeni aririka otzimaaniyite. Riirika shirampari tzimatsini, powamayiri. Roorika tsinani eero powamayiro.” ");
INSERT INTO cpy_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Teemaeta omatziro tsinani-paeni ikantawi-takawori pinkathari-tatsiri Apitantoniki. Tema pinkathari oyiri roori Tajorentsi, tee owamaayi-ritzi shirampari eenchaa-niki. ");
INSERT INTO cpy_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Rootaki ikaemakaan-tanta-kawori pinkathari-tatsiri Apitantoniki, ikantakiro: “¿Iita kaari powamaantari shirampari eenchaa-niki?” ");
INSERT INTO cpy_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Okanteeyini roori: “¡Pinkatharí! Tema ñaaperori okanteeyani tsinani Heber-paeni, tee oshiyaawo Apitantoni-jato, tekira nareetyaa naminiro tzimaanitatsiri, aritaki tzimaanitanaki.” ");
INSERT INTO cpy_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Rootaki ineshironka-tanta-kawori Tajorentsi tsinani-paeni aminirori Heber-paeni otzimaa-niyitzi. Ari okanta isheki-pero-tantakari Heber-paeni tema eekiro riyaatatzii otzimimo-tziri ishintsinka riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Tema okemijanta-yitziri Tajorentsi roori tsinani-paeni aminirori otzimaaniyitzi Israel-paeni, rootaki ishekitan-takanawori otomi-paeni roori. ");
INSERT INTO cpy_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ikanta Faraón, ikanteeri isheninka-paeni Apitantoniki, ikantziri: “¡Pikemi Nosheninka-paeni! Pookiri nijaaki maawoeni shirampari otomi-paeni Heber-paeni, roorika tsinani eero pookayi-tziro roori, añaayiteeta.” ");
INSERT INTO cpy_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ikanta apaani isheninka Leví-paeni raaki iina. Tema iroka iina roojatzi isheninka Leví-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ari itzimaki otomi. Tema kameethaanikiri rirori eenchaa-niki. Rootaki omananta-kariri riniro. Tema mawa kashiri omanawi-takari. ");
INSERT INTO cpy_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Tee omataneeya omaniri eenchaaniki, aaki tsiwoo “owichaanatakiro” otziri-moko-takiro. Otetakiri eenchaaniki, owamaata-kotakiri oshimpena-thapyaataki nijaa. ");
INSERT INTO cpy_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ari otyaantakiro ritsiro eenchaa-niki, okatziyaka inteeneeni aminako-wentziri oetarika awijimo-terini eenchaa-niki. ");
INSERT INTO cpy_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ari iyaataki nijaaki rishinto Faraón okaawoshitya. Anashiwae-tapaaka onampiri-paeni nijaathapyaaki. Oñaatziiro rishinto Faraón janta tsiwoo oshimpena-thapyaatakira nijaa, okaemakiro onampiri, okantziro: “Pipoki, paakitero tsiwoo.” ");
INSERT INTO cpy_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Okanta ashitaryaa-wakiro tsiwoo, oñaatziiri rotetaka eenchaa-niki, ayimatakiri ishenka. Osheki etako-shire-tanakari roori, okantanaki: “Reentsite Heber-paeni irika.” ");
INSERT INTO cpy_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ari okantanaki ritsiro eenchaa-niki, okantziro rishinto Faraón: “¿Tee pikoyi nokaemimi nosheninka thoteemirini eenchaa-niki?” ");
INSERT INTO cpy_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Okantzi rishinto Faraón: “Jeen, nokoyi. Piyaate pikaemakitero.” Jatanaki ewankawo, okaemapaen-tziro riniro eenchaa-niki. ");
INSERT INTO cpy_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Okantawakiro: “¡Tsinani! Paanakiri irika eenchaa-niki poemotan-tenari, aritaki nopinatakimi.” Aaneeri riniro eenchaa-niki, oemotan-teeri. ");
INSERT INTO cpy_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ikanta ikimotataki eenchaa-niki, opaero rishinto Faraón. Oshiyakaantakiri riirikami otomi roori, rootaki oetantakariri “Ahaa-nyaari” tema okantakitzii roori: “Nijaaki naakiri”. Tema iroka waerontsi Ahaa-nyaari, rootaki ikantziri iñaaniki riroripaeni “Moisés”. ");
INSERT INTO cpy_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ikanta rantari-pero-tanaki Moisés, jataki rareetari isheninka-paeni, iñaapaa-tziiri osheki rantawae-takae-tziri. Iñaakowentapaakiri isheninka Moisés ipajawae-tziri Apitantoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ithonka raminanaki tekatsi-rika ñeerini, rowamaakiri Apitantoni-jatzi, ikitata-nakiri impanekiiteki. ");
INSERT INTO cpy_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Okanta okiteeje-tamanee rapiitakiro riyaatee, iñaapaa-tziiri ranta-wakahaeyani isheninka rirori. Ikantziri antanta-tsiri: “¡Nosheninká! ¿Iita pikoshekantariri akaateeyinira?” ");
INSERT INTO cpy_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ari rakanaki, ikantzi: “¿Iitaka owakimiri eeroka pompera-tantenari? ¿Pikowatziima powamayina, pikimitaakiri chapinki Apitantoni-jatzi?” Ikanta ikemawaki Moisés, antawo ithaawanaki, roshiya-kaantzi riyotakoe-takiri rowamaakiri chapinki Apitantoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Ari ikemaki rirori Faraón, ikowaki rowamayiri Moisés. Rootaki ishiyan-takari Moisés ikinanakiro Kosheka-weniki. Ari ikoyi inampityaawo janta. Kotyaatapaaka ikaapiin-teetzi nijaa. ");
INSERT INTO cpy_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tema janta Kosheka-weniki ari inampitawori sheripiyari iita Reuel, tzimatsi 7 rishinto rirori. Ari iyaatee-yakini roori ayi nijaa imiriteri ipira opaapate. ");
INSERT INTO cpy_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ari ipokaeya-paakini ikaatzi aminako-wentziriri ipira-paeni janta, ithañaa-pitha-takawo ayimi nijaa. Rootaki riyaatan-tanakari Moisés ikijako-wentawo, raapaaki rirori nijaa ipakiri imiri opira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Okanta opiyeeyaani ewankawo-paeni opankoki, rojampi-tawaero opaapate, ikantziro: “¿Intsipaetima pipiyapaaka?” ");
INSERT INTO cpy_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Okanteeyini roori: “¡Pawa! Noñaaki Apitantoni-jatzi janta, riitaki kijako-wentakinari ithañaa-pitha-tanawo nijaa aminako-wentziriri ipira-paeni janta. Riitaki kitaataki-nawori nijaa, ipakiri apira-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ari ikantanaki Reuel: “¿Jempe nimaeka rirori? ¿Pikaemiri ipoki royaa. Iitaka pookanta-nakariri?” ");
INSERT INTO cpy_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ari okanta ijeekan-tapaakari Moisés ipankoki Reuel. Okanta paata irika Reuel, ipakiri Moisés rishinto, oeta Séfora, iinantakawo. ");
INSERT INTO cpy_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ari otzimakiri itomi, ikantanaki Moisés: “Itsipa-jatzi naaka jaka, kaari nonampi.” Rootaki iitantakariri itomi “Itsipa-jatzi”, tema iroka waerontsi Itsipa-jatzi, rootaki ikantee-tziri iñaaniki rirori-paeni “Gersón”. ");
INSERT INTO cpy_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Okanta paata kamae pinkathari-witachari Apitantoniki. Eekiro ratekae-yatziini Israel-paeni tema osheki ishintsi-teetziri rantawae-takae-tziri. Rootaki ikemanta-kariri Tajorentsi jenoki rowashire-tawae-teeyakani. ");
INSERT INTO cpy_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Tema ikemirira ratekaeyini, roojatzi roshiretakotakawo Tajorentsi ikashiya-kaakiriri paerani Abraham, Isaac, eejatzi Jacob. ");
INSERT INTO cpy_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tema iñiiri Tajorentsi maawoeni Israel-paeni riyotakotziri okaatzi awijimo-yitziriri. ");
INSERT INTO cpy_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Riitaki Moisés aminakowentziriri ipira-paeni rikonkiri, iiteetziri Jetro. Sheripiyari rirori janta Kosheka-weniki. Ikanta raanakiri Moisés ipira-paeni ochempi-mashiki raminakaeri royaari. Rareetaka iiteetziro Mamerii-toni, rootaki rochempi-mashite Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Ari roñaahakari janta Ronampiri Tajorentsi ipaamatzi-motakiri. Ikanta ramina-pero-tanaki Moisés, iñaatziiro kitochee-maeshi paamatatsiri, teemaeta opaaka omoreki. ");
INSERT INTO cpy_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ari ikanta-shire-tanaki Moisés: “Nimaeka naminakitero okaakiini kaari othonkatanta otaaha, tee noñaa-piintziro kimityaawoni iroka.” ");
INSERT INTO cpy_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ikanta iñaakiri Tajorentsi ipokaki Moisés raminiro okaakiini, ñaawaetanaki omorekakira kitochee-maeshi, ikantziri: “¡Moisés!” Ikantzi Moisés: “¿Iitaaka?” ");
INSERT INTO cpy_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ikantzi Tajorentsi: “Eero pontsirokawo okaakiini morekaen-tsiri. Panashi-konta-tashityaa, tema pikatziyan-tatyaawo tajorentsi-pathari.” ");
INSERT INTO cpy_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Eekiro ikantana-kitzii Tajorentsi: “Naakataki Itajorentsite piwaejatziite, Itajorentsite Abraham, Isaac, eejatzi Jacob.” Ari rotzimika-wootanaka Moisés, tema ithaawan-tanaki-tyaari Tajorentsi raminawooteri. ");
INSERT INTO cpy_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Eekiro iñaanata-nakitziiri Tajorentsi, ikantziri: “¡Moisés! Noñaakiri rashironka-waeta ikaatzi nashitari naaka jeekatsiri Apitantoniki. Nokemakiri ratekakaakiri aminayi-tziriri rantawae-teeyinira. Noñaakiri rashironkaa-waeta. ");
INSERT INTO cpy_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tema rootaki nopokan-takari kepatsiki, nookakaa-wenteeri rashiwi-takari Apitantoni-jatzi. Nomishitowaeri, naaneri otsipaki kepatsi poshini-patha-tatsiri, kimii-patha-tatsiri, jempe oshookapae osheki pankirentsi, eejatzi jempe itzimapae osheki ipireetari. Tema rootaki inampi-witari nimaeka Owinteni-jatzi, Thaawan-taarewoni-jatzi, Ochempi-weni-jatzi, Nampitsi-weni-jatzi, Thaantewenijatzi eejatzi Kaya-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","¡Moisés! Nokemakiniri ratekani Israel-paeni, noñaakiri eejatzi Apitantoni-jatzi osheki rowashironkaa-waetakiri. ");
INSERT INTO cpy_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Otzimatyee piyaate Apitantoniki jempe ipinkatharitzi Faraón, pomishitowaeri rompera-waeteetari Israel-paeni, nashitari naaka.” ");
INSERT INTO cpy_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Ikantanaki Moisés: “Tee noripero-waetzi naaka niyaata-shitan-tyaariri Faraón, nomishito-wanteeyaariri nosheninka-paeni ijeeki Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ikantzi Tajorentsi: “Aritaki akaate, iroka piyotan-tyaari naakataki otyaantzimiri: Aririka pomishitowa-yiteeri ikaatzi nashitari naaka ijeekira Apitantoniki, aritaki pipinkatha-teenari maawoeni jaka tonkaariki.” ");
INSERT INTO cpy_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ikantanaki Moisés: “¡Tajorentsi! Eenitatsi pomeentsi-tzimotanari aririka niyaawi-takyaa, nokanta-paakiri Israel-paeni: ‘Naaka rotyaantani Itajorentsite awaejatziiteni.’ Aririka rojampi-tanakina, ikantena: ‘¿Jempema iitaka rirori?’ ¿Iitakama nokanteriri naaka?” ");
INSERT INTO cpy_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ari rakanaki Tajorentsi, ikantzi: “NAAKATAKI NAAKATA-PIINTA-TSIRI.” Eekiro ikantana-kitzii Tajorentsi: “Iroka pikanteriri Israel-paeni: ‘Irika iitachari NAAKATAKI, riitaki otyaanta-kinari nopokantari noñeemi eerokapaeni.’” ");
INSERT INTO cpy_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Eekiro iñaawae-tanakitzii Tajorentsi ikantziri Moisés: “Pikanteri pisheninka Israel-paeni: ‘Iroka ikantzi Awinkatharite, Itajorentsite awaejatziite Abraham, Isaac, Jacob, riitaki otyaantanari noñeemi eerokapaeni.’ Tema ashi owaatyeero nowaero. Ari iiteenari pisheninkapaeni eejatzi ikaate ichariniyiteeyaari paata rirori. ");
INSERT INTO cpy_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Piyaate, pipiyoteri antaripero-paeni Israel-paeni, pikanteri: ‘¡Nosheninka! Roñaahaana Awinkatharite, Itajorentsite awaejatziite, Itajorentsite Abraham, Isaac, Jacob, ikamanta-kinawo jempe pikanta iñaakimi rowashironkaa-waetee-tzimi Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Iroka otsipa ikantakinari: “Aritaki nookakaa-wenteemi owashironkae-tzimi Apitantoniki, noejeekaemi inampiiteki iwaejatziite Owinteni-jatzi, Thaawantaarinijatzi, Ochempi-weni-jatzi, Nampitsi-weni-jatzi, Thaantewenijatzi, eejatzi Kayaawenijatzi, jempe oshookapae osheki pankirentsi, eejatzi jempe itzimapae osheki ipireetari.” ’ ");
INSERT INTO cpy_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Aririka poemintha-takaa-kyaari antaripero-paeni, riitaki pitsipa-tanakyaari piyaata-shiteri pinkathari Apitantoniki, pikanta-paakiri: ‘¡Pinkathari! Roñaahaakina Tajorentsi, Itajorentsite nosheninka Heber-paeni. Otzimatyee nanashi-teeyeni okaate mawa kiteejeri, niyaate ochempi-mashiki notayiniri nopira Nowinkatharite Tajorentsi.’ ");
INSERT INTO cpy_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Niyotzimaetaka naaka, eero ishinetzimi piyaate pinkathari-tatsiri Apitantoniki. Otzimatyee noshintsiteri naaka. ");
INSERT INTO cpy_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Roo kanteencha, aritaki noñaaha-kimiro noshintsinka, nowamayi osheki Apitantoni-jatzi. Aririka iñaakiro okaate nanteri inampiiteki, aripaete ishineteemi pinkathari Faraón piyaatee. ");
INSERT INTO cpy_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Naaka kantakae-yaarini Apitantoni-jatzi ipashitan-tawae-yaariri oetarika-paeni pisheninka-paeni aririka riyaatee-yeeni, tema eero riyaa-wako-wae-tashi-tanaa. ");
INSERT INTO cpy_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tema othonka okowako-taneero tsinani ojeeka-nampi-tziri, okowako-taneero otsipata-piintari, opayita-waero ooro, koriki, eejatzi kithaarentsi-paeni. Rootaki pikithaa-teriri pitomi-paeni, tema paapitha-tanee-ri maawoeni rashaahawo Apitantoni-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ari ikantanaki Moisés: “¡Tajorentsi! Eero imatziro nokantiriri, osheki ipiyatha-tina. Apatziro ikantee-yinani: ‘¡Moisés! Tee roñaayimi Tajorentsi.’” ");
INSERT INTO cpy_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Rapiita-nakiri Tajorentsi, ikantziri: “¡Moisés! ¿Iitaka poteeyakiri pakoki?” Ikantzi Moisés: “Nokotzi nateyi.” ");
INSERT INTO cpy_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ikantzi Tajorentsi: “Ajantyaa pookiro jaawiki.” Rookakiro Moisés ikotzi. Ari opeyanakari maanki. Ishiya-pitha-tanakawo ikotzi iñaakiro opeyanakari maanki. ");
INSERT INTO cpy_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Ikantzi Tajorentsi: “Poteeyiri ipatzishithaki.” Imatakiri Moisés roteeyakiri, kotzitsi-tanee. ");
INSERT INTO cpy_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ikantzi Tajorentsi: “Piñaakiro. Rootaki riyotan-teetyaari maperori noñaahakimi, tema naaka Itajorentsite piwaejatzite Abraham, Isaac, eejatzi Jacob.” ");
INSERT INTO cpy_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ari ikantanakiri eejatzi Tajorentsi: “¡Moisés! Pojate-wakotyaa pishipaneeki.” Imatakiro Moisés, iñaatziiro rako othonka opathaanaki, kitamaa-wakotanaki, kimiwae-tanaka okitamaatzi jiriniki. ");
INSERT INTO cpy_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ikantzi Tajorentsi: “Papiiteero poja-tewa-koteeyaa.” Rapiitakiro Moisés rojate-wakotaa. Etsiyatanee ipathaawo, kimitanaa ikantaha maawoeni iwathaki. ");
INSERT INTO cpy_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ikantzi Tajorentsi: “Eerorika ikemijan-teetzimi iñaawitee-takyaawo petakyaari poñaahantiri, aritaki ikemijan-teetakimi aririka iñahaetakiro otsipa poñaahantiri. ");
INSERT INTO cpy_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Eerorika ikemijan-teetzimi poñaahan-tawitakyaawo iroka apite kaari iñaapiin-teetzi, paaki eepichokiini nijaa, pijakotiro jaawiki. Aritaki oshiyana-kyaawo iraantsi.” ");
INSERT INTO cpy_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ikantzi Moisés: “¡Apaa Nowinkatharite! Osheki opomeentsi-tzimotana noñaawaeti, tema ari nokantzita paerani, eejatzi nimaeka piñaana-tanta-kinari pompera-tina. Tema osheki nokowa-piintawita nokenkitha-waetimi, osheki nokijopaantetaki noñaawaeti-rika.” ");
INSERT INTO cpy_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ari ikantzi Tajorentsi: “¡Moisés! ¿Iitaka pakiriri atziri-paeni iñaani? ¿Kaarima naaka kijopaante-takaeriri, matayempi-tatakaeriri, eejatzi mawityaaki-takaeriri? ¿Kaarima naaka aminakaa-yitziriri eejatzi? ");
INSERT INTO cpy_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Otzimatyee piyaati, aritaki niyotaakimi jempe pikanteri, naaka tsipatimini.” ");
INSERT INTO cpy_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Eekiro ikantana-kitzii Moisés: “¡Apaa, Nowinkatharite! Potyaanti itsipa atziri.” ");
INSERT INTO cpy_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Ari ikijatha-tanakiri Tajorentsi irika Moisés, ikantanakiri: “Aritaki ijeekiri janta pirentzi Aarón, isheninka Leví-paeni. Riyotziro iñaawaetzi kameetha rirori. Pokaki itonkiyo-timi, antawo ikimo-shiretanaki aririka iñaawaemi. ");
INSERT INTO cpy_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tema eeroka kamanterini okaatzi ikenkitha-takaanteri, ari nojeekityaari eejatzi naaka notsipatemi, niyoteemiro okaate panteri. ");
INSERT INTO cpy_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Rootaki ikamantiriri Aarón maawoeni atziripaeni okaatzi pikanta-kiriri eeroka. Tema okaatzi pikaman-tiriri Aarón okimiwae-tyaawo naakami Tajorentsi ñaanatirini atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Iroka pikotzi poteeyeri, rootaki pimatan-tyaawori kaari iñaapiin-teetzi.” ");
INSERT INTO cpy_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ari ipiyaa Moisés ipankoki rikonkiri Jetro, ikantapaeri: “¡Konki! Rooteentsi niyaatee Apitantoniki, jempe ijeeki nosheninka-paeni. Nokoyi naminaatiri eeniro-rika rañaayitzi.” Ikantzi Jetro: “Pimateero ñotzi, okantashitzimaityaa tekatsi awijimo-temini.” ");
INSERT INTO cpy_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Tema ikantzi-takari Tajorentsi irika Moisés ijeekantari Kosheka-weniki, ikantakiri: “¡Moisés! Pipiyi Apitantoniki, tema kamae kowawita-chari rowamayimi.” ");
INSERT INTO cpy_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tema raaneero iina Moisés itsipataa-neero itomi-paeni, ikyaako-takaa-naari ipira-paeni, piyaa Apitantoniki. Tema tee rotsiparyaawo ikotzi Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ikanta Moisés itsipatari Aarón jataki ikenkitha-waetakaeri Faraón, ikantapaakiri: “¡Pinkathari! Pikemiro iñaani Tajorentsi, Itajorentsite Israel, ikantzimi: ‘Pishineteri atziri nashitari naaka riyaatee ochempi-mashiki roemoshirenkaena.’” ");
INSERT INTO cpy_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Ari rakanaki Faraón, ikantanaki: “¿Itzimika Tajorentsi nokemijantiri, rootakima noshine-tantyaariri pisheninka-paeni riyaatee? Tee niyotziri jempe itzimi Tajorentsi-tatsiri, eero noshine-tziri riyaatee pisheninka-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ari ikanteeyini rirori: “¡Pinkathari! Roñaahaana Itajorentsite nosheninka Heber-paeni. Otzimatyee niyaateeyeni, okaate mawa kiteejeri nareetan-tyaari ochempi-mashiki. Ari notayi-niri natsipe-takaani Notajorentsite, eero aantana mantsiyarentsi, eero rompojanteetana.” ");
INSERT INTO cpy_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ari rakanaki iwinkatharite Apitantoni-jatzi, ikantziri: “¡Moisés! ¡Aarón! ¿Iitaka pookakaan-tyaariri rantawaero pisheninka-paeni? Ikantawa-kaata, otzimatyee rantawaeti.” ");
INSERT INTO cpy_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Eekiro ikantana-kitzii Faraón: “Osheki pisheninka Israel-paeni jaka nampitsiki. ¿Kameetha-tatsima pookakaeri rantawaero?” ");
INSERT INTO cpy_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tema tee ishenkaanaka Faraón, riyotaakiri ikaatzi aminiriri Israel-paeni, jewayitzirori antawaerentsi, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Aritapaaki pipakiri katawoshi wetsika-yitzirori kijonakiri kepatsi, riyaati rirori rayi katawoshi. ");
INSERT INTO cpy_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pishintsiwentzi-maetyaari pikantiri: ‘Tee nokoyi powetsiki eepichokiini, tema nokowatzii powetsiki jempe okaatzi powetsika-piintziri.’ Tema iperatee-yatyaani, rootaki ikaeman-teeyarini, ikantzi: ‘¡Aatiwé. Atayiniri atsipeta-kaani Atajorentsite!’ ");
INSERT INTO cpy_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Pipa-pero-tiri osheki rantawaero, eero pishine-tziri ijeekashiwaityaa irikapaeni. Eero ikemijanta-waetziro theeyaantsi-paeni ñaantsi.” ");
INSERT INTO cpy_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Jataki aminiriri Israel-paeni, jewatakaan-tzirori antawaerontsi, ikantapaakiri: “Pikemi ikantakinari Faraón: ‘Tema eero nopayiteemi katawoshi. ");
INSERT INTO cpy_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Eeroka jatatsini payi. Roo kanteencha otzimatyee kijonakiri kepatsi powetsiki okaatzi powetsika-piintziri.’” ");
INSERT INTO cpy_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ithonka ikinayi-tanaki Israel-paeni jempe-rika-paeni janta Apitantoniki, ithotyaakoyitzi katawoshi. ");
INSERT INTO cpy_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Ari ikantapiin-tanakityaa rowayitakiri Faraón ishintsiwen-tantzi rowetsikaeti kijonakiri kepatsi okaatzi rowetsika-piintziri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Tema osheki ipajawae-teetakiri Israel-paeni rowakiri Faraón reewatiri isheninka-paeni, ikantziri: “¿Iita kaari pimonkaa-tantawo okaatzi powetsika-piintziri? Tee pimatziro chapinki, eejatzi nimaeka.” ");
INSERT INTO cpy_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Jateeyakini jewatziriri Israel-paeni, ikantapaakiri Faraón: “¡Pinkathari! ¿Iita powashironkaan-tariri patzirite? ");
INSERT INTO cpy_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tema tee ipaeteena katawoshi, eekiro ishintsiwen-teetatyaana, ikanteetana: ‘Powetsiki osheki kijonakiri kepatsi.’ Ipajatzima-teetana. Riitaki kantakaan-tzirori pinampina-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ikantanaki Faraón: “Tema piperatee-yatyaani eeroka. Rootaki pikantantari: ‘¡Aatiwé. Atayiniri atsipeta-kaani Atajorentsite!’ ");
INSERT INTO cpy_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Pipiyanaki, pantawae-teeyini. Okantawityaa eero ipaetzimi katawoshi, otzimatyee powetsiki kijonakiri kepatsi okaatzi powetsika-piintziri.” ");
INSERT INTO cpy_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Osheki opomeentsi-tzimota-nakari Israel-paeni jewatziriri isheninka-paeni rantawaeti, ishintsiwen-teetziri rirori rowetsiki kijonakiri kepatsi okaatzi rowetsika-piintziri kiteejeriki. ");
INSERT INTO cpy_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Roo ishitowa-nakitzii ikenkitha-waetakaeri Faraón, iñaapaakiri Moisés eejatzi Aarón royaawen-takari. ");
INSERT INTO cpy_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ikantapaakiri: “Riitaki Atajorentsite owajankitaa-wenti-mironi okaatzi pantakiri. Eeroka kantakaan-takiro ikijashiri-tanteeri Faraón eejatzi inampina. Okemiwae-takawo eeroka pakirinimi iyotsiro-shitha-kiti rowamaanteeri.” ");
INSERT INTO cpy_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ari ramananaka Moisés, ikantzi: “¡Ashitanari! ¿Iita powajankitaan-tariri pashitari eeroka? ¿Iitaka potyaan-tanta-kinari nopokan-takari noñiiri? ");
INSERT INTO cpy_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tema rowajankitaa-waetanakiri Faraón nosheninka-paeni nokenkitha-takota-paakiniri piwaero, tekatsi-maeta panti pookakaa-wentantee-yaariri pashitari eeroka.” ");
INSERT INTO cpy_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Rakanakiri Tajorentsi, ikantziri: “¡Moisés! Piñaakowenteri noshintsiteri naaka Faraón ishinetanteemiri pishitoyi inampiki, riitaki shintsi-teemini eejatzi eerokapaeni piyaatee.” ");
INSERT INTO cpy_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Eekiro ikantana-kitziiri Tajorentsi: “Tema naaka Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Naaka oñaahakariri paerani Abraham, Isaac, Jacob, nokaman-takiri nowaero, nokantakiri: ‘Naaka Tajorentsi Shintsi-perori’, teemaeta nokaman-tziri nowaero-pero, noeta ‘Naakataki.’ ");
INSERT INTO cpy_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Tema eenitatsi nokashiya-kaakiriri rirori-paeni, nokowaki inampitee-yaawo Owinteniki jempe ikimita-kaantee-takiri itsipa-jatzipaeni irika. ");
INSERT INTO cpy_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Niyotzitaka eejatzi osheki rowashironka-waetaka Israel-paeni, ishintsi-waetakiri Apitantoni-jatzi rantawae-takaeri. Tema noshiretakawo nokashiya-kaakiriri. ");
INSERT INTO cpy_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Rootaki pikantan-tyaariri Israel-paeni, pinkanteri: ‘Pikemi ikantzimi Tajorentsi: “Naaka Tajorentsi, aritaki nookakaawen-teemi ishintsi-tzimira rantawae-takaemi Apitantoni-jatzi. Ari piñaakiro noshintsinka, kameetha nowawijaa-koyiteemi nokijawen-teemi. ");
INSERT INTO cpy_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Naaka ashitee-mini, naaka Pitajorentsite-teeyaa. Ari okantyaa piyotan-teeyaari naakataki Pitajorentsite, naaka ookakaawen-teemiri rompera-waetzimi Apitantoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Naneemi nampitsiki nokashiya-kaakiriri paerani piwaejatzite Abraham, Isaac, Jacob. Rootaki nopaemiri, pashitee-yaawo. Naakataki Tajorentsi.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Rootaki rapiitakiri Moisés ikamantziri isheninka-paeni, teemaeta ikemijan-teeyini, tema antawo okantzi-motakari ishintsi-teetzirira rantawaete. ");
INSERT INTO cpy_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ari rapiiteero Tajorentsi ikanteeri Moisés: ");
INSERT INTO cpy_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Piyaate pikanteri Faraón pinkathari-tatsiri Apitantoniki, ishineteri riyaatee pisheninka-paeni ijeekawaetakira iipatsiteki.” ");
INSERT INTO cpy_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ari ikantanaki Moisés: “¡Tajorentsi! Tee ikoyi ikemijantena nosheninka-paeni. Rii owanaapero Faraón eero ikemijantana, tema tee niyotzi noñaawaetzi kameetha.” ");
INSERT INTO cpy_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ari iñaanateeri Tajorentsi irika Moisés, ikanteeri: “¡Moisés! Naaka kantakae-yaawoni ikimita-kaantantimiri Faraón eerokami tajorentsi. Riima pirentzi Aarón, riitaki pikimi-takaantiri kamantan-tironi piñaani. ");
INSERT INTO cpy_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tema eeroka kamantirini Aarón okaatzi nokantimiri, rowawijayi-maetyaanari rirori Faraón ishinetan-teeyaariri pisheninka-paeni ishitowae inampiki. ");
INSERT INTO cpy_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Roo kanteencha osheki nokijo-shire-takaeri Faraón. Roojatzi noñaakan-tantyaawori kaari iñaapiin-teetzi Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Eero ikemi-maetzimi Faraón. Roo kanteencha aritaki noñaakaeri noshintsinka maawoeni Apitantoni-jatzi. Tema kameetha nokijawen-teeyaari pisheninka Israel-paeni, nashitari naaka, nokimi-takaari nowayiriti. Aritaki naayiteeri maawoeni ijeekawae-witaka Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Aririka noñaahan-takiro noshintsinka Apitantoniki, aririka nahaeri pisheninka Israel-paeni janta, aripaete riyoti Apitantoni-jatzi naaka Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Imatakiro Moisés eejatzi Aarón okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Tema okaataki Moisés 80 rojarentsite ikenkitha-waetakaan-takariri Faraón. Riima Aarón okaataki rirori 83 rojarentsite. ");
INSERT INTO cpy_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Ari rapiiteero Tajorentsi iñaanateeri Moisés eejatzi Aarón, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Aririka ikantakimi Faraón: ‘Ajaantyaa poñaayina kaari iñaapiin-teetzi,’ pikanta-nakiri eeroka Aarón: ‘Pookiro pikotzi ikatziyakaha Faraón opeyaari maanki.’” ");
INSERT INTO cpy_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Jataki Moisés eejatzi Aarón iñiiri Faraón, imatakiro ikantakiriri Tajorentsi. Rookakiro ikotzi Aarón ikatziyakaha Faraón itsipayi-takari inampina, opeyanakari maanki ikotzi. ");
INSERT INTO cpy_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Ari ikaemakaan-takiri rirori Faraón yotaniri-paeni eejatzi sheripiyari-paeni Apitantoni-jatzi. Imawita-paakawo rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Rookapaakiro ikotzi apaani-paeni rirori, opeyanakari maanki. Roo kanteencha ikotzi Aarón oniyakiri rashi irika-paeni yotaniri. ");
INSERT INTO cpy_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Teemaeta ikemijantzi Faraón, eekiro ikijo-shire-tanakitzii. Tema mataka ikantzi-takari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Osheki ikijo-shiretaki Faraón, tee ishinetziri riyaatee pisheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pananin-kashiteri Faraón riyaata-manee rirori nijaaki. Pitonkiyo-tyaari nijaathapyaaki poteeyiro pikotzi peyakariri maanki. ");
INSERT INTO cpy_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Pikantiri: ‘¡Pinkathari! Tema rotyaanta-witakina Tajorentsi, Itajorentsite Heber-paeni, nokaman-timiro iñaani ikantzimi: “Pishineteri nashitari naaka riyaatee ochempi-mashiki ipinkatha-tina.” Roo kanteencha teemaeta pikemi eeroka, owanaa pipiyathataka. ");
INSERT INTO cpy_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Rootaki ikantan-takari eejatzi Tajorentsi: “Iroka piyotan-tyaanari naaka Tajorentsi.” Piñaakina noteeyakiro nokotzi, rootaki nopajaatan-tyaawori nijaa, aritaki opeyana-kyaawo iraantsi. ");
INSERT INTO cpy_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ari ithonkakyaa ikami maawoeni ikaatzi jeekatsiri nijaaki, oshityaati nijaa. Tema osheki ipinkamatiro Apitantoni-jatzi aririka imiritiro.’” ");
INSERT INTO cpy_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ikantanakiri Tajorentsi irika Moisés: “Pikanteri pirentzi Aarón rowaankiro ikotzi jempe ojeekayitzi nijaa, inkaari, jempe owaanka-naayita, jempe rowaan-teetawo Apitantoniki, tema othonkyaa opeyaawo iraantsi okaatzi tzimayi-tatsiri inchato-naaki eejatzi mapinakiki, maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tema imatakiro Moisés eejatzi Aarón okaatzi ikantakiriri Tajorentsi. Roñaahakiri Faraón itsipatakari inampina-paeni, ipajaatan-takawo ikotzi nijaa, thonkaka opeyanakawo iraantsi okaatzi tzimatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Thonkaka ikamayitaki maawoeni ikaatzi jeekatsiri nijaa-ki, thonkanaka oshityaatanaki nijaa, tee okameethatzi imiriteero Apitantoni-jatzi. Thonkaka iraanchaataki maawoeni nijaa janta Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Roo kanteencha imatakiro eejatzi isheripiyarite-paeni Apitantoni-jatzi okaatzi rantakiri Moisés. Rootaki ikijo-shire-tantari Faraón, tee ikemijantzi, tema mataka ikantzi-takari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Piyaa rirori Faraón ipankoki, apatziro inimowae-tziri, tee okantzimotyaari okaatzi iñaawitakari. ");
INSERT INTO cpy_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tema ikiyako-teeyakini othapyaaki nijaa maawoeni Apitantoni-jatzi ikoyi rayi kiteshaari nijaa, rootaki rireri, tema tee okameethatzi rireero antawaani. ");
INSERT INTO cpy_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ari maakotaki okaatzi 7 kiteejeri ipeyanta-kawori Tajorentsi iroka nijaa iraantsi. ");
INSERT INTO cpy_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Piyaate ijeekira Faraón, pikanteri: ‘Ikantzi Tajorentsi: “Pishineteri ikaatzi nashitari naaka riyaate ipinkatha-teena. ");
INSERT INTO cpy_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Eerorika pishine-tashitari, aritaki nowajankitaan-takimiri mashero-paeni maawoeni piipatsiteki. ");
INSERT INTO cpy_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ari itzimaki osheki mashero nijaaki, ikyaayite pipankoki, eejatzi jempe pimaapiintzi. Tema ari ithonkyaa ikyaapaaki ipankopaeniki pinampina-paeni, eejatzi ipankopaeniki maawoeni pisheninka. Ari ikyaayitaki pitashi-mentoki, pichomoniki-paeni, maawoeniki. ");
INSERT INTO cpy_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ithonkyaa rateeta-paakimi mashero-paeni, eejatzi ikanta-paakiri maawoeni pisheninka-paeni. Imatakiri pinampina-paeni eejatzi.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Opoñaashita ikantanakiri Tajorentsi Moisés: “Pikanteri Aarón rowaankiro ikotzi jempe otzimayitzi nijaa, jempe rowaan-teetawo eejatzi. Ari ipoñeeyaari mashero-paeni iñahaeteri Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Ari rowaanka-nakiro Aarón ikotzi jempe otzimayitzi nijaa janta Apitantoniki. Tema tonkaapaaki osheki mashero, ipamankapaakiro nampitsipaeni Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Roo kanteencha imatzitakawo sheripiyari-paeni, roetonkaaki isheripiyarin-kakiini rirori osheki mashero janta Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Rootaki ikaemakaan-tanta-kariri Faraón ipoki Moisés eejatzi Aarón, ikantawakiri: “Pikowako-teeri Tajorentsi ipeyeeri mashero-paeni ikaatzi oñaashirenka-kinari naaka eejatzi nosheninka-paeni. Aritaki noshine-takiri pisheninka-paeni riyaate itayiniri ratsipe-takaani Pitajorentsite.” ");
INSERT INTO cpy_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ari rakanakiri Moisés pinkathari Faraón, ikantziri: “Pikantena jemperika okaatzi namanakotantemiri eeroka, pinampina-paeni eejatzi pisheninka-paeni, eero roñaashirenkan-teemi mashero-paeni pipankokipaeni, apatziro ijeeki nijaaki.” ");
INSERT INTO cpy_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ikantzi Faraón: “Okiteeje-tamanee.” Ikantzi Moisés: “Aritaki omatakyaa okaatzi pikowakiri, rootaki piyotan-tyaari tekatsi itsipa monkaatyaarini Notajorentsite. ");
INSERT INTO cpy_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Tema eero itzimanee mashero-paeni pipankoki, eejatzi ipankoki pinampina-paeni, ari ikantzitakyaa ipankokipaeni pisheninka-paeni, apatziro ijeekayite nijaaki.” ");
INSERT INTO cpy_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ikanta ipiyaa Moisés eejatzi Aarón ipoñahaawo ipankoki Faraón. Ari ramananaka Moisés ikowako-tziri Tajorentsi ipeyeeri mashero-paeni ikaatzi oñaashirenka-kiriri Faraón. ");
INSERT INTO cpy_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Imatakiro Tajorentsi okaatzi ikowakiri Moisés. Ithonka ikamanaki mashero-paeni kyahaen-tsiri pankotsiki, piyoteen-chari okaankiityeera, eejatzi owaantsiki-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Tema ithonka ipiyota-kaanteetakiri mashero ikaatzi kamaentsiri, shityeenka-mashitaki. ");
INSERT INTO cpy_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Tema tekatsi kantashiryaaneerini Faraón, kameetha ijeekanee. Ari rapiita-neero ikijo-shire-tanee, tee rantziro ikantawi-teetariri, mataka okaatzi ikantzi-takari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Pikanteri pirentzi Aarón: ‘Powaankiro pikotzi, pipaja-panetero kepatsi, tema rootaki peyaneen-chani netsi, ithonkyaa iñahaeteri maawoeni Apitantoniki.’” ");
INSERT INTO cpy_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tema imatakiro Aarón okaatzi ikantee-takiriri. Rowaankakiro ikotzi, ipaja-panetakiro kepatsi, peyanaka netsi. Riitaki shenita-neentsiri maawoeniki Apitantoniki. Tema roñaashirenka-paakiri atziri-paeni eejatzi piratsi-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Ari imawitakawo eejatzi sheripiyari-paeni ipeyiri netsi isheripiyarin-kakiini, teemaeta imatziro. Tema osheki ikantanaka ini atziri-paeni eejatzi ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ikantawi-takari sheripiyari-paeni pinkathari Faraón, ikantziri: “Okaatzi piñaakiri, Tajorentsi kantakaawo.” Teemaeta ikemi Faraón ikantawi-teetariri, tema mataka okaatzi ikantzi-takari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Pananin-kashiteri okiteeje-tamanee Faraón riyaata-manee nijaaki, pikanteri: ‘Iroka ikantzi Tajorentsi: “Pishineteri riyaatee nashitari naaka ipinkatha-teena. ");
INSERT INTO cpy_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Tema eerorika pishine-tziri riyaate, aritaki notyaantaki osheki inashi-tachani shimpoki-paeni, riitaki oñaashirenka-paakimini pipankoki, ipankoki pinampina-paeni eejatzi ipankokipaeni maawoni pisheninka-paeni. Ithonkaero maawoeni iipatsite jempe inampiyitawo. ");
INSERT INTO cpy_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Eeromaeta itzimi shimpoki-paeni Okaakishaariki jempe ijeeki Israel-paeni, ikaatzi nashitari naaka. Tema rootaki piyotan-tyaari naaka Tajorentsi ashitawori kepatsi. ");
INSERT INTO cpy_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Tema naaka ookakaa-wenteerini maawoeni nashitari naaka, ikaatzi pashi-witakari eeroka. Inkaamani omatyaa iroka.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tema imatakiro Tajorentsi okaatzi ikantakiri, pokapaaki osheki shimpoki ipankoki Faraón, ipankoki inampina-paeni, eejatzi ipankoki isheninka-paeni, ithonka ipamankapaakiro maawoeni Apitantoni. Tema ithonka rowaaripero-tanta-paaki irika-paeni shimpoki. ");
INSERT INTO cpy_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Rootaki ikaeman-takariri Faraón irika Moisés eejatzi Aarón, ikantakiri: “Kantacha piyaate pitayiniri patsipe-takaani Pitajorentsite, roo kanteencha eero pawijiro jempe oweyaa nampitsi.” ");
INSERT INTO cpy_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ari ikantzi Moisés: “Tee inimotana pikantanari, tema piwinkani roori aririka notayiniri Notajorentsite. Aririka nomatakiro iwinkani Apitantoni-jatzi, aritaki rowamaa-wentakinawo. ");
INSERT INTO cpy_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Otzimatyee niyaateeyeni, tema okaatzi mawa kiteejeri nanashitya ochempi-mashiki, notayiniri natsipe-takaani Notajorentsite, nanteero okaatzi ikantanari rirori.” ");
INSERT INTO cpy_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ikantzi Faraón: “Aritaki noshine-takimi piyaate pitayiniri patsipe-takaani Pitajorentsite janta ochempi-mashiki, eeromaeta piyaa-perotzi inteena. Pamanakotena eejatzi naaka.” ");
INSERT INTO cpy_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ikantzi Moisés: “¡Pinkatharí! Aririka noshitowanee nokenkitha-waetakaemi, aritaki nokowako-takiri Tajorentsi ipeyeeri inkaamani irika-paeni inashi-yitachari shimpoki ikaatzi oñaashirenka-kimiri eeroka, pinampina-paeni eejatzi pisheninka-paeni. Okantashitzimaetya eero papiitziro pamatawitana, pithañee-yaari nosheninka-paeni riyaate itayiniri ratsipe-takaani Notajorentsite.” ");
INSERT INTO cpy_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ari ishitowanee Moisés ikenkitha-waetakaeri ipankoki Faraón, ramanaari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Imatakiro Tajorentsi okaatzi ikowakiri Moisés. Peyanaa shimpoki-paeni ikaatzi oñaashirenka-kiriri Faraón, inampina-paeni eejatzi maawoeni isheninka-paeni, tekatsi apaani tzimahaan-tanaa-tsini. ");
INSERT INTO cpy_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Roo kanteencha Faraón, rapiita-neero ikijo-shire-tawaetzi, tee ikemijantziro ikantee-tziriri, tee ishinetziri riyaatee Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ikanta Tajorentsi rapiiteeri Moisés ikanteeri: “Piyaate piñeeri pinkathari Faraón, pikanteri: ‘Ikantzi Tajorentsi, Itajorentsite Heber-paeni: “Pishineteri ikaatzi nashitari naaka, riyaate ipinkatha-teena. ");
INSERT INTO cpy_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Tema eerorika pishine-tziri riyaatee, roojatzi-rika pithañee-yaari, ");
INSERT INTO cpy_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","aritaki nowajankitaan-takimiro kowaenkatatsiri mantsiyarentsi, rootaki thonkaerini ikaatzi pipiratari powaneki, ikyaakoetari-paeni, maawoeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Riima ipira-paeni Israel-paeni, eero ikamahaantzi apaani. Tema nina-shityaari ikaatzi rashitari Israel-paeni, eejatzi rashi Apitantoni-jatzi.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ari rowaki Tajorentsi apaani kiteejeri, ikantzi: “Inkaamani nomatero okaatzi nokantakiri.” ");
INSERT INTO cpy_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Okanta okiteeje-tamanee, imatakiro Tajorentsi okaatzi ikantakiri. Ithonkanaka ikamaki ipira-paeni Apitantoni-jatzi, riima rashi Israel-paeni tee ikamahaantzi apaani. ");
INSERT INTO cpy_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Rojampi-kowen-takiri Faraón ipira-paeni Israel-paeni, ikematzii ikanteetzi: “Tee ikamahaantzi apaani.” Roo kanteencha Faraón, eekiro ikijo-shire-tanakitzii, tee ishinetziri riyaatee Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ari rapiiteero Tajorentsi ikanteeri Moisés eejatzi Aarón, ikantziri: “Powiiteeyini jamampo, riitaki Moisés oñaayirini Faraón rooka-panetero. ");
INSERT INTO cpy_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Rootaki shekita-neentsini jamampo maawoeni Apitantoniki. Rootaki pathaakaa-yiterini maawoeni Apitantoni-jatzi eejatzi piratsi-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Imatakiro Aarón eejatzi Moisés, raanaki ojamampote paamari, jataki ijeekira Faraón. Rooka-pane-takiro Moisés jamampo jenoki. Rootaki opoñaan-tanakari ipathaa-waeyi-tanaki maawoeni atziri-paeni eejatzi ikimita-nakari ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tee imatziro sheripiyari-paeni okaatzi rantakiri Moisés, tema ithonka ipathaa-waeyi-tanaki rirori, roshiya-nakari jempe ikantayi-tanaka maawoeni Apitantoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Roo kanteencha, ikantakaawo Tajorentsi eekiro ikijo-shire-tatzii Faraón, tee ikoyi ikemiro ikantee-tziriri, monkaataka ikantzi-takariri Tajorentsi paerani Moisés. ");
INSERT INTO cpy_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Eejatzi rapiiteeri Tajorentsi ikanteeri Moisés: “Pananinkanaki inkaamani piñeeri Faraón, pikanteri: ‘Ikantzi Tajorentsi, Itajorentsite Heber-paeni: “Pishineteri riyaatee ikaatzi nashitari naaka, ipinkatha-teena. ");
INSERT INTO cpy_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Tema notyaan-tatzii nimaeka osheki mantsiyarentsi patsipe-tyaari eeroka, pinampina-paeni, eejatzi maawoeni pisheninka-paeni. Rootaki piyotan-tyaari tekatsi itsipa kimitenani naaka jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Tema nimaeka nowajankitaan-temiro eeroka mantsiyarentsi, eejatzi nokimiteri maawoeni pisheninka-paeni, tema ari pikamaetyaanaki jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Omapero-tatyaa, tema naaka kantakaawo pañaayite, rootaki riyotan-teetenari otzimimotana naaka noshintsinka, ari okantyaa ikenkitha-takoe-tantee-nari naaka maawoeni kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Tema piñaawi-takawo okaatzi awijeentsiri, eekiro pithañaa-tyaari ikaatzi nashitari naaka, tee pishine-ritzi riyaayitee. ");
INSERT INTO cpy_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tema inkaamani, ari okimityaawo nimaeka iweyaakaha ooryaa, ari piñaakiro opariyi jiriniki, tee iñahaetziro paerani jaka Apitantoniki kimityaawoni iroka, omapokakimi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Otzimatyee potyaante ahaaterini pipira-paeni, eejatzi maawoeni tzimatsiri powaneki. Tema aririka opariyaa-paaki jiriniki, othonka owamaapaakiri atziri-paeni, eejatzi ipira-paeni kaari jeekatsini pankotsiki.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Tema eenitatsi apaani-paeni inampina Faraón pinkatha-tanakiriri Tajorentsi ikemakiro ikantakiri, ramayiteeri romperatani eejatzi ipira-paeni ipankoki. ");
INSERT INTO cpy_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Riima ikaatzi piyatha-tawori iñaani Tajorentsi, tee ramaeri ipankoki romperatani eejatzi ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ari rapiiteeri Tajorentsi ikanteeri Moisés: “Powaanka-wakotyaa jenokinta, opariyiita Apitantoniki jiriniki, thonkirini atziri, ipira-paeni eejatzi maawoeni iwankiri Apitantoni-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ari itzinaa-wako-tanaka Moisés jenokinta roteeyiro ikotzi, ikantakaakawo Tajorentsi ookathatyaa. Othonka ojiriniki-tanaki maawoeni Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tema matanaka ojiriniki-tanaki, otsipatakawo jiriniki ookatha-rentsi. Osheki okowaenkataki, tee iñaapiin-teetziro paerani Apitantoniki kimityaawoni iroka. ");
INSERT INTO cpy_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Tema othonka owaaripero-tapaakiro jiriniki iipatsiteki Apitantoni-jatzi. Omatakiri maawoeni atziri-paeni, eejatzi ipira-paeni. Omatakiro owaaripero-takiro pankirentsi-paeni shookatsiri owaantsiki, otewaryaa-yitanakiro inchato-paeni tzimatsiri nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Rooma janta Okaakishaariki jempe inampitee-yawoni Israel-paeni, tee iñahaetziro opariyi jiriniki. ");
INSERT INTO cpy_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ari ikaemakaan-teeri Faraón irika Moisés eejatzi Aarón, ikanteeri: “Nokaariperotaki naaka. Tema kameethari ikanta rirori Tajorentsi. Rooma naaka eejatzi maawoeni nonampina-paeni, kaari-perori nokanteeyani. ");
INSERT INTO cpy_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pamaniri Tajorentsi okaatantyaari ookatha-rentsi, eejatzi jiriniki. Aritaki noshine-takimi piyaayitee, eero nothañaa-neemi.” ");
INSERT INTO cpy_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ari rakanaki Moisés ikantanakiri: “Aririka noñaakiro niyaa-tapitha-teero pinampi, ari nowaanka-wako-tashi-teeyaari Tajorentsi namaneeri. Ari okaatapaaki ookathataka eejatzi jiriniki, rootaki piyotan-tyaari rashi Tajorentsi iroka kepatsi. ");
INSERT INTO cpy_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Roo kanteencha niyotzi naaka, tekira pipinkathatzimaetari eeroka Tajorentsi, ari ikimitzitakari eejatzi pinampina-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Tema thonkaka okamaki pankirentsi okaatzi powaenka-ryaawi-teenchari, okaatzi eejatzi teyakiwi-teenchari. ");
INSERT INTO cpy_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Roo kanteencha, teemaeta okamayitzi okaatzi ojamani-yitatsiri oshooka-yitzi. ");
INSERT INTO cpy_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ikanta ishitowanee Moisés ikenkitha-waetakaeri ipankoki Faraón, itzinaa-wako-tanaa ramananeeri Tajorentsi. Awijeen-katanaki jiriniki, tee opariyaani inkani, tee ookatha-taneeyaa. ");
INSERT INTO cpy_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ikanta iñaakiro Faraón tee opariyane inkani, awijanaki jiriniki, tee ookatha-taneeyaa, ari ikaaripero-tanee eejatzi. Tema rapiita-neero ikijo-shire-tanee, ari ikimitzi-tanaari inampina-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Maperotanaa ikijo-shire-tawae-tanee Faraón, tee ishinetziri riyaate Israel-paeni. Tema monkaataka ikantakiriri Tajorentsi paerani Moisés. ");
INSERT INTO cpy_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Eejatzi rapiiteeri Tajorentsi ikanteeri Moisés: “Piyaati piñiiri Faraón, tema naaka kantakaari ikijo-shire-tawae-tantari rirori eejatzi inampina-paeni, rootaki iñaantee-tyaawori kaari iñaapiinteetzi. ");
INSERT INTO cpy_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Rootaki pikaman-teeriri pitomi-paeni eejatzi picharini-paeni okaate nantayi-teeri Apitantoniki, tema noñaaha-yitee-ri kaari iñaapiin-teetzi. Ari piyoyiteeri eerokapaeni naakataki Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ari riyaatanaki Moisés eejatzi Aarón iñiiri Faraón, ikantapaakiri: “Iroka ikantzi Tajorentsi, Itajorentsite Heber-paeni: ‘¿Jempema okaateka pipakaero pikijo-shire-yitzi? Pishineteri riyaatee ikaatzi nashitari naaka, ipinkatha-teena. ");
INSERT INTO cpy_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Eekiro-rika pithañaa-tyeeyaari, ari namaki inkaamani osheki tsitsiri pinampiki. ");
INSERT INTO cpy_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ipamanka-paakiro kepatsi, eero okaankitee eepichokiini. Ithonka-paakiro royaawo tzimahaan-taneen-tsiri owamayiromi jiriniki, ithonka-paakiro royaawo okaatzi shookatsiri inchato-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ipiyota-paakyaa pipankokipaeni, ari ikantzitakyaa ipankoki pinampina-paeni, eejatzi maawoeni ipankopaeniki Apitantoni-jatzi. Iñahaeteero kaari iñaayitzi paerani ashitzimiri eejatzi piwaejatzite-paeni.’” Ithonkakiro ikenkitha-waetakaeri Faraón, piyanaa irirori. ");
INSERT INTO cpy_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Ikantanakiri inampina-paeni Faraón: “¡Pinkathari! ¿Jempema okaateka ipakaero rajarii-matee irika atziri? Pishineteri riyaatee isheninka-paeni, ipinkatha-teeri Itajorentsite. ¿Tema piñiiro rowaariperotaitakero anampi Apitantoni?” ");
INSERT INTO cpy_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Ari rapiitakiro Faraón ikaemakaan-tziri Moisés eejatzi Aarón, ikantakiri: “Piyaati pipinkathateri Pitajorentsite. Roo kanteencha nokoyi pikantina jempe-rika itzimi jatatsini.” ");
INSERT INTO cpy_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ikantzi Moisés: “Tema maawoeni niyaateeyini: eentsi-paeni eejatzi antariki-paeni, notyomi-paeni eejatzi nishintyo-paeni. Ari naaneeri maawoeni nopira-paeni. Tema antawo okantyaa noemoshirenkaeri Notajorentsite.” ");
INSERT INTO cpy_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Ikantanaki Faraón: “Tema tee omana pikoyi pantiro kaari-perori. ¿Poshiya-kaantzi ari noshine-takimi piyaatee, ari paayita-neeri eejatzi peentsite-paeni? Omawitakyaa itsipatimi Tajorentsi eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Eero omata pikoyiri. Piyaateeyeni eeroka antari-paeni, pipinkathateri Tajorentsi, tema rootaki pikowae-yakirini.” Roepiyawakiri Faraón tee ikoyi iñiiri. ");
INSERT INTO cpy_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Powaanka-wako-teeyaa jempe ojeeki Apitantoni, tema namatyee osheki tsitsiri, ithonkiro pankirentsi tzimahaan-taneen-tsiri kaari owamaanaki jiriniki.” ");
INSERT INTO cpy_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ari rowaanka-wako-tanaka Moisés jempe ojeeki Apitantoni roteeyiro ikotzi, ikantakaakawo Tajorentsi otampyaataki kiteejeriki eejatzi tsireniriki. Okanta okiteeje-tamanee, iñeetatzii osheki tsitsiri amakiri tampyaa kinapaen-tsiri ishitowa-piintzi ooryaa. ");
INSERT INTO cpy_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Tema piyotapaaka tsitsiri-paeni Apitantoniki. Tee otzimae jempe okaankiitye eepichokiini. Maperori ishenita-paaki, tee iñeetziro paerani, eero iñeeteero paata eejatzi. ");
INSERT INTO cpy_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Ithonka ipamanka-paakiro maawoeni nampitsi, tsirenitankyaa-tapaaki kepatsiki. Ithonka rowapaakawo pankirentsi, maawoeni okithoki-paeni inchato okaatzi tzimahaan-taneen-tsiri kaari owamayi jiriniki. Mapero ithonkakiro, tee iñeetee Apitantoniki jempe eerishitee inchatoshi, omataka owaantsiki eejatzi antami-mashiki. ");
INSERT INTO cpy_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Ari ishintsi-tanaki Faraón ikaemakaan-takiri Moisés eejatzi Aarón, ikantakiri: “Nokaaripero-tzimotakiri Pitajorentsite, ari nokantzi-takimiri eejatzi eeroka. ");
INSERT INTO cpy_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Roo kanteencha, nokoyi pipeyako-teenawo nantzimota-kimiri, eero napiiteero. Pikowakoteri Tajorentsi, ipeyeeri nopankoki naaka irika-paeni owamaan-taniri.” ");
INSERT INTO cpy_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Ikanta ishitowanee Moisés ipankoki Faraón ikenkitha-waetakaeri, ramananeeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Ari ikantakaakawo Tajorentsi oshintsiti otampyaati okinapaakiro ikyaapiintzira ooryaa, othonkaneeri aanakiri tsitsiri-paeni ookakiri Inkaariki Kityonkaariki. Tee iñeetaneeri tsitsiri maawoeni nampitsiki Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Roo kanteencha Tajorentsi, eekiro ikijo-shire-takaa-tziiri Faraón, tee ishinetziri riyaatee Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Ari rapiiteero Tajorentsi ikanteeri Moisés: “Pitzinaa-wakoti jenokinta, otsirenikaakitantyaari maawoeni Apitantoniki, tema otsirenikaakiperotatyee kantacha roteeyeetiro.” ");
INSERT INTO cpy_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ari itzinaa-wako-tanaka Moisés jenokinta, tema mawa kiteejeri otsirenikaakitaki maawoeni Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tema tekatsi ñahaerini isheninka, okaatzi mawa kiteejeri tee okantya riyaayite jempe-rika-paeni. Riima Israel-paeni koñeetyaakotatsi ipankoki rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ari rapiita-neero Faraón ikaemakaan-takiri Moisés, ikantakiri: “Piyaati nimaeka pipinkatha-teeri Tajorentsi, paanakiri pitomi-paeni. Apatziro pookanakiri pipira-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Ikantzi Moisés: “Eeroka pawakinani piratsi notayiri, riijatzi kachaa-teyamaitatsini notayiniri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tema otzimatyee naanakiri ikaatzi nopiratari naaka. Eero nookanaki apaani, riitaki noemoshirenkan-tapiin-tariri Notajorentsite. Tema eerorika nayiri, tee niyotzi oetarika noemoshirenkan-tyaariri Tajorentsi aririka nareetakyaa jempe noshiritawo.” ");
INSERT INTO cpy_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Tema riitaki Tajorentsi kantakaakawo ikijo-shire-tantari Faraón, tee ishinetziri riyaayitee. ");
INSERT INTO cpy_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ikantanakiri Faraón irika Moisés: “¡Piyaati! Tee nokoyi pipiyi piñiina. Aririka napiitakiro noñiimi, aritaki pikamaki.” ");
INSERT INTO cpy_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ikantzi Moisés: “¡Kameetha pikantakiri! Eero napiiteero noñiimi.” ");
INSERT INTO cpy_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Eejatzi rapiiteeri Tajorentsi ikanteeri Moisés: “Naaka kantakaeyaawoni iñaantyaawori pinkathari otsipa kowaenkari, roojatzi iñiiri maawoeni Apitantoni-jatzi. Aririka iñaakiro ikowaenka-takotanaki Faraón, aritaki ishineteemi piyaatee. Riitaki Faraón shintsiwen-teemini piyaatanteeyaari. ");
INSERT INTO cpy_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Pikanteri pisheninka-paeni ikowakoteri pinatachari ijeeka-nampi-tziri, ari okimitzi-tyaari tsinani-paeni okowakotiro ojeeka-nampi-tziri opayita-waero rowetsikae-tziri koriki, ooro.” ");
INSERT INTO cpy_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Ikantakaakari Tajorentsi Apitantoni-jatzi ipashita-waeyaari Israel-paeni. Ari ikantzi-teetakari eejatzi Moisés, ikimita-kaetakari riroperori. Osheki ipinkatha-takiri inampina-paeni Faraón eejatzi maawoeni atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ari ikenkitha-waetakaakiri Moisés pinkathari Faraón, ikantakiri: “Pikemi ikantzi Tajorentsi: ‘Aririka oniyankiityaa-paaki tsireniri, ari nanashitiro maawoeni nampitsi Apitantoni. ");
INSERT INTO cpy_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ari ithonkyaa ikami rantarite-paeni itomi Apitantoni-jatzi, eejatzi rantariti itomi-paeni Faraón, okantawitaka riroperori ijeekawitaka iwinkathari-mentoki. Imatzityaa rantariti itomi-paeni omperataa-rewo ashironkaa-chari toonka-waetatsiri. Ari ikamitakyaa etanakawori itzimi ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Tema ari rakisheenkatakyaa iraachaani Apitantoniki, tee iñahaetziro paerani kemityaawoni, eero apiitaa eejatzi paata. ");
INSERT INTO cpy_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Roo kanteencha, tekatsi koshekyaarine Israel-paeni, eero itzimi otsitzi thaatirini. Rootaki piyotan-tyaari riyotziri Tajorentsi Apitantoni-jatzi, riyotzitari Israel-paeni ikaatzi rashitari rirori. ");
INSERT INTO cpy_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ari ipokanaki pinampina-paeni iñiina, rotziwerowa-paaki, ikanti: ‘Piyaatee eeroka, paaneeri pisheninka-paeni ikaatzi pitsipa-takari.’ Aririka okaataki awijatsini, aripaete niyaatee.” Tema antawo ikijaka Moisés ishitowanee ikenkitha-waetakaerira Faraón. ");
INSERT INTO cpy_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ari rapiitakiro Tajorentsi ikantziri Moisés: “Owanaa itheenkimi Faraón, rootaki kantakaan-tironi iñaantyaawori okaatzi kaari iñaapiin-teetzi paerani Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Imatakiro Moisés eejatzi Aarón, tema roñaaha-yitakiri Faraón kaari iñaapiintzi. Riitaki Tajorentsi kantakaawo ikijo-shire-tanta-naari Faraón. Tee ishinetziri riyaatee Israel-paeni ijeekiita Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Ikanta Tajorentsi iñaanateeri Moisés eejatzi Aarón janta Apitantoniki, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Riroperori irika kashiritatsirika, riitaki etakaantaneeyaawoni ojarentsiki. ");
INSERT INTO cpy_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Pikenkitha-waetakaeri maawoeni Israel-paeni, pikanteri: ‘Aririka areetyaa kiteejeri 10 irika kashiri, ari piyoshiiteri apaani pipira ipankopaeniki apaani-paeniki pisheninkapaeni eeroka. ");
INSERT INTO cpy_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Teerika pishekitzi pipankoki pithonkan-tyaariri poyaari pipira, kantacha pikaemiri jeeka-nampi-tzimiri, pantetyaari pipira, riitaki oyaarini ikaatzira ijeekaeyini rirori ipankoki. ");
INSERT INTO cpy_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tema kameetha ikantyaa irika pipira, shirampari, tzimaentsiri apaani rojarentsite. ");
INSERT INTO cpy_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ari ijeekawaki irika pipira roojatzi kiteejeri 14 irika kashiriki. Riitaki powamaa-yiteri aririka otsireniityaanaki apaani-paeni pipankoki eeroka. ");
INSERT INTO cpy_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Payiro riraa, pipotho-tantyaawo apitekiro otzinkami-panke eejatzi okonompiro pashitakowo jempe powayityaari pipira. ");
INSERT INTO cpy_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Tema tsireniriki poyaari pitashi-takiri, patantyaari kaari shineya-kaerori, eejatzi inchashi kepishi-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Eero powari añiinkari, eejatzi onkotsirentsi, apatziro poyaari tashirentsi. Tema kantacha poyaawo eejatzi okaatzi tzimantayitariri inthomaenta imotziki. ");
INSERT INTO cpy_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Pithonkateri poyaari, eero powaantari powaneeyaari inkaamani. Aririka itzimahaan-tapaaki eepichokiini, pitayiri. ");
INSERT INTO cpy_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Iroka pikantyaa poyaari. Powatha-kityaa, eero panashi-konta-tashita, poteeyiro pikotzi, intsipaete poyaa. Tema iroka kiteejeri aetero “Anonkoryaantsi,” rashi Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Tema nimaeka tsireniriki nonkinanaki maawoeni nampitsi Apitantoniki, ari nowamaakiri maawoeni rantarite itomi-paeni Apitantoni-jatzi, eejatzi rantarite itomi-paeni ipira-paeni. Tema Tajorentsi naaka. Aritaki notzimpookita-nakiri itajorentsi-nirote Apitantoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Tema rootaki iraantsi niyotan-tapaa-kyaawori pipanko jempe pijeeka-yitzi eeroka. Aririka noñaapaakiro opothotakyaa iraantsi pipankoki, nanonkoryaa-nakiro. Eero piñiiro mantsiyarentsi owamaan-tatsiri ratsipe-teetyaari Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Tema rootaki pikenkishire-tapiin-teeri iroka kiteejeri, antawo poemoshirenkaero poshire-teeyaari Tajorentsi. Rootaki imateeri ikaate picharini-teeyaari. Ashi rowaero roemoshirenkaero. ");
INSERT INTO cpy_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Tema okaatzi 7 kiteejeri powapiin-tyaawo ratanteetari. Pookayitero pipankoki okaatzi shineya-kaerori etana-kawori kiteejeri. Eenitatsi-rika atziri owakyaawoni shineya-tsiri ratanteetari etana-kawori kiteejeri roojatzi omonkaa-tantakyaa 7 kiteejeri, eero ishinetee-tziri itsipatee-yaari isheninka, ari rookaetakiri. ");
INSERT INTO cpy_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tema pipiyowenteeyaana pimpinkathataena etana-kyaawoni kiteejeri. Ari pikanterori eejatzi aririka omonkaa-tapaakyaa 7 kiteejeri. Tekatsi antawae-tatsini, apatziro ronkotsite royaari. ");
INSERT INTO cpy_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Poemoshirenkaero iroka kiteejeri rowantee-takawori atanteetari kaari rowaetee-tzi shineya-kaerori, tema rootaki kiteejeri naanteemiri pijeeka-witaka Apitantoniki. Otzimatyee piyotahaeri ikaate picharini-teeyaari, ashi rowaero roemoshirenkaero rirori nokantakiri. ");
INSERT INTO cpy_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Powapiin-teeyaawo atanteetari kaari rowaetee-tziri shineya-kaerori kiteejeri 14 roojatzi kiteejeri 21 aririka retana-kyaawo owakirariki ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tema eero otzimi eepichokiini shineya-kaerori atanteetari pipankoki, roojatzi omonkaa-tanta-kyaari 7 kiteejeri. Eenitatsi-rika owakota-kyaawoni shineya-kaerori, eero ikowaeteeri pinampiki, rookaetakiri. Okantawityaa riitakirika Israel-paeni, itsipa-jatzi-rika jeekimo-tzimiri, otzimatyee rookaeteri. ");
INSERT INTO cpy_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Jempe-rika pinampi-yitee-yaawo eeroka, eero powako-waetawo shineya-kaerori atanteetari.’” ");
INSERT INTO cpy_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ari ipiyotakiri Moisés maawoeni antaripero-paeni Israel-paeni, ikantakiri: “Piyaate piyoshiiyite pipira powamayiri pipankokipaeni eeroka, riitaki oemoshirenkyaari kiteejerika ‘Anonkoryaantsi.’ ");
INSERT INTO cpy_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Payi inchashi, pashetan-tyaawo riraa pipira powakotakiri, pipotho-tantyaawo apitekiro otzinkami-panke eejatzi okonompiro-panke pashitakowo. Aritaki pijeekawaki pipankoki, eero pishitowa-waetzi roojatzi inkaamani. ");
INSERT INTO cpy_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Tema awijatyee Tajorentsi rowamaa-nakiri rantarite itomi-paeni Apitantoni-jatzi. Aririka iñaapaakiro iraantsi pipotho-takiro apitekiro otzinkami-panke eejatzi okonompi-pankero pashitakowo, ari rawijanakiro pipanko-paeni. Eero ishinetziri Tajorentsi ikyaa-wankotemi thonkan-taniri. ");
INSERT INTO cpy_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Poemoshirenka-piinteero eeroka nokantakimiri, ashi rowaero eejatzi ikaate picharini-teeyaari roemoshirenka-yiteero rirori. ");
INSERT INTO cpy_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Aririka pareeteeyaa kepatsi-kinta ikashiya-kaakimiri Tajorentsi, roojatzi poemoshirenki-teeyaari eejatzi janta. ");
INSERT INTO cpy_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Aririka rojampi-teemi ikaate picharini-teeyaari, ikantemi: ‘¿Iitaka oshiyakaa-wentachari iroka oemoshirenkaantsi?’ ");
INSERT INTO cpy_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Iroka pikante eerokapaeni: ‘Ari ratsipe-takaetari ipireetari roemoshirenkaetari Tajorentsi kiteejeri Anonkoryaantsi. Tema ranonkoryaakiro paerani Tajorentsi ipanko-paeni asheninka Israel-paeni ijeekan-tawitakari Apitantoniki, tema rowamaa-nakiri rantarite itomi-paeni-paeni Apitantoni-jatzi, riima asheninka-paeni aaka tee rowamaa-nakiri.’” Ari rotziwerowanaka Israel-paeni ipinkatha-tanakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ikanta riyaatee-yeeni Israel-paeni, imatakiro okaatzi ikantakiriri Tajorentsi irika Moisés eejatzi Aarón. ");
INSERT INTO cpy_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Okanta niyankiite tsireniri, ithonka rowamaakiri Tajorentsi rantarite itomi-paeni Apitantoni-jatzi. Retanakari rantarite itomi-paeni pinkathari Faraón, imatzitakari rantarite itomi-paeni omonkyahaarewo. Ari ikantzitakari etachari iryaani itzimi ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ikanta ikakitanaki tsireniriki Faraón, maawoeni inampina-paeni, eejatzi Apitantoni-jatzi, antawo okantanaka irahaantsi. Tema maawoeni ipankoki ikamayitaki rantarite itomi-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ari ikaemakaan-takiri Faraón tsireni-paeteki Moisés eejatzi Aarón, ikantakiri: “Piyaatee, tee nokoyi pijeeki-motaneena, paaneeri maawoeni pisheninka Israel-paeni, pipinkathateri Tajorentsi, tema rootaki pikanta-piintakinari. ");
INSERT INTO cpy_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Paaneeri maawoeni pipira-paeni. Pimatero pikowapiin-takiri panteri. Piyaata-nakiita. Pamana-kowen-tena eejatzi naaka.” ");
INSERT INTO cpy_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tema ishintsi-thatanakiri Apitantoni-jatzi ithaanki-takaantyaariri riyaatee Israel-paeni, ikantziri: “¡Piyaatanaki intsipaete! Tee nokoyi nothonkyaa nokami.” ");
INSERT INTO cpy_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Ari raanakiro Israel-paeni opatha atantee-tari kaari rowaeteetzi shineya-kaerori, iponatan-tanakawo imaatha, inatanakiro. ");
INSERT INTO cpy_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Imatakiro Israel-paeni okaatzi ikantakiriri Moisés, ikowako-tanakiri Apitantoni-jatzi ikaatzi rowetsikae-tziri koriki, ooro, eejatzi kithaarentsi. ");
INSERT INTO cpy_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Riitaki Tajorentsi kantakaakari Apitantoni-jatzi ipashitan-tawaariri Israel-paeni, ipayita-waeri okaatzi ikoyiri. Ari ikantakirori Israel-paeni raapitha-tanta-naariri Apitantoni-jatzi rashaahawo. ");
INSERT INTO cpy_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Jatee-yeeni Israel-paeni ipoñaanakawo Itomyaani Ooryaa riyaatee-yironi Pankoshaaki. Tema riyoshiita antari-paeni, ikaateeyini 600,000 atziri. Tee riyoetziro jempe okaatzi tsinani-paeni eejatzi eentsi-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tee apatziro riyoshiityaa Israel-paeni riyaatee-yeeni, itsipata-nakari inashi-yitachari atziri kaari isheninkayita. Tema raayitanee osheki ipira-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Tema intsipaete romishitowakiri inampiki Apitantoni-jatzi, tee rowaeta-nakiro shineya-kaerori opatha atanteetari, tee ronkotsi-tanaki rowanawo, apatziro itashitanaki atanteetari. ");
INSERT INTO cpy_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Tema okaatzi 430 ojarentsi ijeekaki Israel-paeni janta Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Aripaete ishitowae-yeeni maawoeni rowayiri-takaani Tajorentsi ijeekawitaka janta Apitantoniki omonkaa-tapaaka 430 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Tema raminakowentakiri Tajorentsi tsireniriki Israel-paeni, tema romishitowaeri ijeekawitaha Apitantoniki. Rootaki raminakowen-tantee-yaariri Tajorentsi iroka tsireniriki Israel-paeni, roojatzi imateeri ikaate icharini-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Ikanta rapiiteero Tajorentsi iñaanateeri Moisés, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Pashita-kaeyaanari rantarite-paeni itzimakaan-teetani. Tema maawoeni omapokaaniro otzimiri otomi-paeni pisheninka Israel-paeni, eejatzi ashi ipireetari-paeni, tema riitaki nashi irika-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ari rapiiteero Moisés ikanteeri isheninka-paeni Israel-paeni, ikantziri: “¡Nosheninkapaeni! Pikenkishire-teero kiteejeri pishitowan-taari Apitantoniki, jempe rompera-wiitakimi. Tema ishintsinka Tajorentsi romishitowan-teemiri. Rootaki eero powantaawo rowaetee-tziro shineya-kaerori atanteetari. ");
INSERT INTO cpy_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Tema irika kashiri iiteetziri “Eerikiri”, riitaki pishitowan-tayitaari. ");
INSERT INTO cpy_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Riitaki irika kashiri poemoshirenkan-teeyaari paata aririka pahaero inampi Owinteni-jatzi, Thaawantaarinijatzi, Ochempi-weni-jatzi, Thaantewenijatzi, eejatzi Kayaawenijatzi. Tema rootaki ikashiya-kaakiriri Tajorentsi paerani awaejatzite pashitee-yaawo. Ari oshookapae janta osheki pankirentsi, eejatzi jempe itzimapae osheki ipireetari. ");
INSERT INTO cpy_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tema okaatzi 7 kiteejeri powaeyaawo atanteetari kaari rowaeteetzi shineya-kaeroni. Roo kanteencha aririka omonkaa-tapaeya 7-tatsiri kiteejeri, poemoshirenkaeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tema okaatzi 7 kiteejeri rowaetyaawo atanteetari kaari rowaeteetzi shineya-kaeroni. Eero otzimi eepichokiini pinampiki opatha rowaetee-tzirori shineya-kaerori. ");
INSERT INTO cpy_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Otzimatyee pikaman-teeri paata pitomi, pikanteeri: ‘Opoñaantari oemoshirenkiro iroka kiteejeri, tema eenitatsi rantzimota-kinari paerani Tajorentsi noshitowan-taari nojeeka-witaka Apitantoniki.’ ");
INSERT INTO cpy_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Poshiya-kaanteero iroka ñaantsi pikenta-kotyaawomi pakoki eejatzi pipankaki. Pikenkithata-koteero riyotakahaemiri Tajorentsi, tema ishintsinka Tajorentsi raanteemiri paerani pijeeka-witaka Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Otzimatyee pametee-yaawo poemoshirenkaero ojarentsiki-paeni aririka omonkaa-tapaeyaa. ");
INSERT INTO cpy_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Ari rareeta-kahae-mi Tajorentsi iipatsiteki Owinteni-jatzi, jempe otzimi ikashiya-kaakimiri eeroka eejatzi piwaejatziteni. Aririka rashita-kahae-miro eeroka, ");
INSERT INTO cpy_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","pashita-kahae-yaari eerokapaeni Tajorentsi maawoeni romapokaetani itzimaetziri. Ari pikantiriri shirampari omapokani otzimiri pipira-paeni, tema riitaki Tajorentsi ashitariri. ");
INSERT INTO cpy_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Riima omapokani otzimiri iryaani pipira ikyaakoetari, pipoyaa-tantyaari oryaanitsiti pipira kaari ipinkaetzi. Eerorika itzimi pipoyaa-tantyaariri, pikatzikiri. Ari pikantiriri eejatzi itomi-paeni ikaati picharini-teeyaari, pipoyaa-tantyaari iryaani pipira rowaetari. ");
INSERT INTO cpy_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Aririka rojampitimi pitomi-paeni, ikantimi: ‘Iita kantakota-chari iroka?’, pikantiri eeroka: ‘Rootaki kantakotacha ishintsinka Tajorentsi romishitowan-teeri ajeekawita Apitantoniki, rompera-waetee. ");
INSERT INTO cpy_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Okantakaakawo ikijo-shire-tawaetaki pinkathari Faraón, tee ishinetana niyaatee, rootaki rowamaan-takariri Tajorentsi rantariti itomi-paeni Apitantoni-jatzi, ari ikanta-kiriri eejatzi omapokachari otzimiri iryaani ipira-paeni. Rootaki notan-taanariri Tajorentsi shirampari omapokani otzimiri iryaani nopira. Ari nokanteeriri etawori itomi-paeni notyomi-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Pikemita-kaantiro eeroka pikenta-kotyaawomi ñaantsi pakoki eejatzi pipankaki, tema shintsiri Tajorentsi ramanteeri paerani ajeekawitaka Apitantoniki.’” ");
INSERT INTO cpy_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ikanta ishineteeri paerani Faraón riyaatee Israel-paeni, tee ikinakaa-neeri Tajorentsi iipatsiteki Kinakinawaetaniripaeni, ari eenta-thakiwita. Tema ikantakitzii Tajorentsi: “Aririka iñaakiro Israel-paeni omanarentsi-paeni, ari ikowanaki ipiyaneero Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Rootaki itapota-kaantakariri Tajorentsi ochempi-mashiki roojatzi Inkaariki Kityonkaariki. Tema wetsikaeyakani Israel-paeni rowarityaa ishitowan-taari Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Tema ramaero Moisés itonki-pooki José, rootaki ikowakiri paerani José, Ikantaki: “Aririka ineshironka-teemi paata Tajorentsi, nokoyi pikantina kameetha, paaneenawo paata notonki-pooki.” ");
INSERT INTO cpy_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ikanta rawijanaki Israel-paeni ijeekawi-tapaaka Pankoshaaki, areetee-yakani Shewamentaaki jempe etanakawo otonkaawo ochempi-mashi. Ari imahaeya-paakini. ");
INSERT INTO cpy_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Riitaki Tajorentsi jewatapiin-takiriri. Tema iñiiro okantajamata kitejipaeteki menkori, riyotzi ari ikineeyini. Rooma tsireni-paeteki opaamatzi menkori, rootaki okoñaatantari jempe ikini ranashi-teeyini. Ari okanta ranashi-tantakari kiteejeriki eejatzi tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tema tee ookiri Israel-paeni kitejipaeteki okantajamataha menkori, ari okimitzitakari tsireni-paeteki okoñeetyaa-kotziri opaamajamataki. ");
INSERT INTO cpy_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ikanta Tajorentsi iñaanateeri Moisés, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Pikanteri Israel-paeni ipiyeeta maawoeni, ipanko-thaante-tapaeya Opatzimoo-weniki, imonteta-paeyawo nampitsi Rashaahawo Inkañaaweri, jempe ojatekakiri inkaari eejatzi Pankothanthaari. ");
INSERT INTO cpy_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Rootaki ikantan-tyaari Faraón: ‘Tekatsi ikini ishiyi Israel-paeni, otzikawakiri ochempi-paeni.’ ");
INSERT INTO cpy_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ari nokanta-kaakyaawo naaka rapiitiro ikijo-shire-tanee Faraón, rootaki ikowantyaari royaa-kyaatawaemi. Ari noñaahan-tirori noshintsinka, notsipa-teeri rowayirite-paeni. Ari riyoti Apitantoni-jatzi naaka Tajorentsi.” Imatakiro Israel-paeni okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ari ikamantee-takiri iwinkatharite Apitantoni-jatzi, ikantee-tziri: “Shiyaka Israel-paeni.” Antawo owatsimaa-nakiri Faraón ikemawakira, imatzita-nakawo inampina-paeni rirori, ikantee-yanakini: “¿Iita ashinetan-taariri riyaatee Israel-paeni, tekatsi omperatee-yaari?” ");
INSERT INTO cpy_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Intsipaeti rowetsika-nakiro ishiyako-mento, ikaemakiri rowayiriti. ");
INSERT INTO cpy_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Riyoshiitaki rooperori-paeni shiyako-mentotsi okaatzi 600. Raanaki eejatzi otsipa ishiyako-mento-paeni Apitantoni-jatzi, ari rotetanakari jewayitziriri rowayiriti. ");
INSERT INTO cpy_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Riitaki Tajorentsi kantakaawori ikijo-shire-tanta-naari Faraón, pinkathari-tatsiri Apitantoniki, royaa-kyaatanakiri Israel-paeni. Roo kanteencha Faraón tee ikenkishire-taawo antawo ishintsini Tajorentsi ishitowan-taari Israel-paeni janta. ");
INSERT INTO cpy_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Jateeyakini Apitantoni-jatzi royaakyaatziri Israel-paeni. Eejatzi rowayirite-paeni ikyaako-yitakari ipira-paeni, eejatzi ishiyako-mento-paeni Faraón. Royaata-waeri ipanko-thaante-yitapaaka inkaari-thapyaaki Opatzimoo-weniki, omontetakari nampitsi Rashaahawo Inkañaaweri. ");
INSERT INTO cpy_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ikanta rokaaki-tapaaki Faraón, raminee-yakini Israel-paeni, iñaatziiri ipokaeyakini Apitantoni-jatzi royaa-kyaatziri. Antawo ithaawae-yanakini Israel-paeni, ikowako-tanakiri Tajorentsi ramitakoteri. ");
INSERT INTO cpy_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ikantanakiri Moisés: “¿Tekatsima Apitantoniki jempe nokitatyaa pamantanari ochempi-mashiki nokamayiti? ¿Jempema pikantinaka? ¿Iitaka pamantaanari nojeekawita Apitantoniki? ");
INSERT INTO cpy_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Aritaki nokantzi-takimi Apitantoniki: ‘Piñaashi-tina ishintsiwaetana Apitantoni-jatzi nantawae-teniri, rootaki kameetha-witacha rompera-tina Apitantoni-jatzi, eero noñiiromi nimaeka nokami ochempi-mashiki.’” ");
INSERT INTO cpy_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ari rakanakiri Moisés isheninka-paeni Israel-paeni, ikantziri: “Eero pithaawan-teeyarini. Pitonta-shireti. Aritaki rowawijaa-kotakimi Tajorentsi. Tema ikaatzi Apitantoni-jatzi piñiiri nimaeka, eero piñahaeri paata. ");
INSERT INTO cpy_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Eero pikanta-shiryaa-waeta, riitaki Tajorentsi piyawen-timini eerokapaeni.” ");
INSERT INTO cpy_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ari ikantanaki Tajorentsi: “¡Moisés! ¿Iitaka pikaema-kaema-tantanari? Pikanteri pisheninka-paeni Israel-paeni: ‘Piyaateeyini.’ ");
INSERT INTO cpy_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Rooma eeroka powaankiro pikotzi inkaariki, aritaki otenkaryaanaki. Tema ari opiryaakotatanaki, ari ikineeya-nakini Israel-paeni ranashi-tanaki. ");
INSERT INTO cpy_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Naaka kompita-shiryaa-kaerini Apitantoni-jatzi, ikowantyaari royaakyaa-timi. Ari iñiirori noshintsinka Faraón, eejatzi maawoeni rowayiriti. Nothonkiro ishiyako-mento eejatzi ipira-paeni ikyaako-yitari-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Tema aripaeti riyoti Apitantoni-jatzi naakataki Tajorentsi, aririka iñaakiro noshintsinka jempe nokantakiri pinkathari Faraón, nothonkiteri ishiyako-mento, rowayiriti eejatzi ipira-paeni ikyaakoyitari-paeni” ");
INSERT INTO cpy_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ikanta Ronampiri Tajorentsi, eejatzi menkori jewatziriri Israel-paeni, inkitapaaki itaapiiki ikineeya-paakironi ketziroeni. ");
INSERT INTO cpy_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ojatekapaaka niyankineki ranashiteeyanira Apitantoni-jatzi royaakyaa-tziri Israel-paeni. Tsireni-kaakitako-tanaki Apitantoni-jatzi, riima Israel-paeni koñeetyaaki iñiiro rirori tsireni-paetiki. Rootaki kaari imatantawo Apitantoni-jatzi royaateri Israel-paeni, tema tsireni-kaaki-takotaki rirori. ");
INSERT INTO cpy_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ikanta rowaanka-nakiro Moisés rako inkaariki, ikantakaakawo Tajorentsi opoki antawo tampyaa tsireni-paetiki okinapaakiro ishitowa-piintzira ooryaa, ari otenka-ryaanaki inkaari, piryaakotatanaki awotsitanakira. ");
INSERT INTO cpy_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ranashi-tanta-nakawo Israel-paeni opiryaa-kotatanaki inkaari, tema oshiya-nakawo impeeta okatziya-tantaa-tanaka rampateki eejatzi rakoperoki. ");
INSERT INTO cpy_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Royaakyaatee-yakirini Apitantoni-jatzi, itsipayi-takari rowayiriti Faraón ikyaako-yitakari ipira-paeni, ishiyako-yitaka ishiyako-mentoki-paeni, weyahae-yakani niyankineki inkaari. ");
INSERT INTO cpy_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ikanta okiteejetzi-mataki, ari raminaki Tajorentsi ijeekaki okoñeetyaakira menkori oorenta-jamateenchari, iñaakiri rowayiriti Apitantoni-jatzi, ikantakaakawo ithaawaeyini iriroripaeni. ");
INSERT INTO cpy_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ikantakaawo eejatzi othopaa-yitanaki oshiyantari ishiyako-mento. Ari omaperotanakyaa ithaawae-yanakini. Ikanteeyini Apitantoni-jatzi: “Jame apiya-pithateri Israel-paeni, tema ikijawen-tatyaari Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Roo kanteencha ikantakiri Tajorentsi irika Moisés: “Powaankaero pako inkaariki, opiyaateeta nijaa opamankiri maawoeni Apitantoni-jatzi, ishiyako-mento-paeni eejatzi ikaatzi kyaakotariri ipira-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Tema kiteeje-tzimataki, rowaanka-nakiro rako Moisés inkaariki, intsipaeti opiyaata-paaka inkaari. Ishiya-mintheeta Apitantoni-jatzi, itonkiyo-takawo inkaari. Ari ikantakiro Tajorentsi ithonkan-takariri Apitantoni-jatzi niyankyaaki inkaari. ");
INSERT INTO cpy_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Tema intsipaeti opiyaata-paaka inkaari, opamanka-nakiro ishiyako-mento-paeni, ikaatzi kyaakotariri ipira-paeni, eejatzi maawoeni rowayiriti Faraón itsipatakari royaakyaa-tziri Israel-paeni. Ithonkaka maawoeni, tekatsi añahaatsini. ");
INSERT INTO cpy_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Riima Israel-paeni kameetha ranashi-tanta-nakawo inkaari opiryaa-kotanakira, oshiyanakawo impeeta okatziya-tantaa-tanaka rampateki eejatzi rako-peroki. ");
INSERT INTO cpy_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ari ikantakirori Tajorentsi rowawijaa-kotanta-kariri Israel-paeni rompera-waetari Apitantoni-jatzi. Iñaakiri Israel-paeni ikamaeyakini Apitantoni-jatzi rotampitziitaka inkaare-thapyaaki. ");
INSERT INTO cpy_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ikanta iñaakiro Israel-paeni kyaari-perori okantaka rantakiri Tajorentsi rotsinampaakiri Apitantoni-jatzi, ipinkatha-tanakiri, rawentaa-nakari Tajorentsi eejatzi ikemita-nakiriri Moisés, romperatani Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ari romampaa-wentanakari Moisés Tajorentsi eejatzi isheninka Israel-paeni. Iroka ikantzi romampahaeyani: Nomampaa-koteeri Tajorentsi, tema riroperori ikantaka rirori rotsinampaantaki. Rowiinkakiri ikyaakoetari eejatzi ikaatzi kyaakotariri. ");
INSERT INTO cpy_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Nomampaa-wenteeri Tajorentsi, Tema riitaki shintsi-takaanari, riitaki owawijaa-kotaanari. Riitaki Notajorentsite, otzimatyee nomampaa-kotee-yaari, Riitaki Itajorentsite ashitanarini, otzimatyee najahaa-wentee-yaari. ");
INSERT INTO cpy_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ikanta raaneeri Moisés isheninka Israel-paeni rookaneero Inkaari Kityonkaari. Ikinanaki ochempi-mashiki iiteetziro Tantotsi-weniki, tema mawa kiteejeri ranashi-teeyakani, tee iñahae nijaa ochempi-mashiki rireri. ");
INSERT INTO cpy_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ikanta rareetee-yakani iiteetziro Kepishaari, tee okantyaa ririro nijaa, tema kepishi okantaka. Rootaki owaeta-kaantzirori janta Kepishaari. ");
INSERT INTO cpy_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ari ikijima-tanakiri isheninka-paeni Moisés, ikantee-yirini: “¿Iitaka ireri?” ");
INSERT INTO cpy_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Rootaki ramanan-tanakari Moisés ikowako-takiri Tajorentsi. Ari roñaaha-kiriri apaani inchashimpoki. Raakiro Moisés, rowiinkakiro nijaaki, kameetha-tanaki imiritiro. Ari ikowaki Tajorentsi iñaantyaari Israel-paeni. Ipakiri ikantakaantani eejatzi rametee-yaari. ");
INSERT INTO cpy_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ikantakiri: “Aririka pikemijanteri Pitajorentsite, tampatzika-shire-teemi, pimonkaa-teero ikantakaantani, noñaakimi pipakahaero okaatzi ipinkakaantani, eero patsipetawo eeroka mantsiyarentsi ratsipe-takari Apitantoni-jatzi, tema naaka Tajorentsi, etsiyata-kotakaan-taniri.” ");
INSERT INTO cpy_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ikanta rareetee-yakani Kompiro-shaariki, jempe otzimiri janta okaatzi 12 nijaateni, ari oshookiri eejatzi okaatzi 70 kompiroshi. Ari ipanko-thaante-teeya-paakani janta. ");
INSERT INTO cpy_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Tema rootaki iroka kiteejeri 15 ikaatan-tyaarimi apite kashiri ishitowan-taari Israel-paeni Apitantoniki. Ari rawijee-yanakini ipoñaanaawo Kompiroshaariki roojatzi niyanki-thakineki ochempi-mashi Cheentoniki. ");
INSERT INTO cpy_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Okanta janta ochempi-mashiki, maawoeni Israel-paeni iñaanawae-tapaakiri Moisés eejatzi Aarón. ");
INSERT INTO cpy_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ikanteeyini: “Ari okameethawita rowamaa-yitinami Tajorentsi Apitantoniki, jempe nopiyota-kotapiin-tziri wathatsi nochomoniki, jempe nokemapiin-teeyani nowawae-teeyani. Rooma pamawitee-yakinani eeroka jaka ochempi-mashiki rooteentsi paakaenawo notashe maawoeni nokaatee-yinira.” ");
INSERT INTO cpy_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Ari rapiiteeri Tajorentsi, ikanteeri Moisés: “Ari nowaryaa-kiniri owanawontsi. Rootaki rowiiteri Israel-paeni okaate royaari apaani kiteejeri. Ari niyoteriri ikemijan-tziro-rika nokantziriri. ");
INSERT INTO cpy_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Roo kanteencha iroka 6-tatsiri kiteejeri, otzimatyee rawijakaero okaatzi rowiita-piintziri otsipaki kiteejeri, rootaki rowaan-tyaari.” ");
INSERT INTO cpy_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Rootaki iroka ñaantsi rowawijaa-kiniriri maawoeni isheninka-paeni Moisés eejatzi Aarón, ikantakiri: “Nimaeka tsirenii-teeni ari piyoteri riitaki Tajorentsi omishitowaemiri Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Rooma inkaa-manee ari piñiirori rowaneenkawo Tajorentsi, tema ikemakimi okaatzi pikijima-waetakiri. ¿Poshiya-kaantzima naaka pikijima-waetzi?” ");
INSERT INTO cpy_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Eekiro ikantana-kitzii Moisés: “Nimaeka tsirenii-teeni ipimi Tajorentsi wathatsi poyaari. Rooma inkaa-manee ipimi osheki atanteetari, rootaki pikemaneen-tyaari. Tema ikemakimi Tajorentsi pikijima-waetakiri. ¿Poshiya-kaantzi naaka pikijima-waetzi? Tema tee naaka pikijimati, Tajorentsi pikijimataki.” ");
INSERT INTO cpy_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ari ikantanakiri Moisés rirentzi Aarón, ikantziri: “Pikaemiri maawoeni asheninka-paeni Israel-paeni, pikanteri: ‘Pipoki maawoeni apiyowen-tyaari Tajorentsi, tema ikemakimi pikijima-waetakiri.” ");
INSERT INTO cpy_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Iñaana-minthee-tziri Aarón maawoeni Israel-paeni, ari raminanaki ochempi-mashiki, iñaatziiro rowaneenkawo Tajorentsi janta menkoriki. ");
INSERT INTO cpy_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ari iñaanata-nakiri Tajorentsi irika Moisés, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“¡Moisés! Nokemakiri pisheninka-paeni Israel-paeni ikijima-waetana. Nokoyi pikanteri: ‘Pikemiri ikantzi Tajorentsi: “Aritaki powakyaa wathatsi tsirenii-teeni, rooma inkaa-manee ari powakyaa osheki atanteetari, rootaki pikemaneen-tyaari. Tema rootaki piyotan-teeyaari naakataki Pitajorentsite.” ’” ");
INSERT INTO cpy_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Okanta otsireniityaanaki, ari itonkae-yapaakini tsimeri, anashi-tee-yapaakani opiyotaka ipanko-thaante Israel-paeni. Rooma okiteeje-tamanee iñaatziiro ashemashi-tapaaki itsini ompokiro kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ikanta okaatapaakira itsini ompokiro, iñeetatzii piyopane-tapaen-chari okaankiityiira ochempi-mashiki, oryaaneerikiini. ");
INSERT INTO cpy_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Tee riyotziro Israel-paeni jempe oeta, ikanta-wakahaeyani: “¿Oetaka iroka?” Ikantzi Moisés: “Rootaki owanawontsi ipimiri Tajorentsi poyaari. ");
INSERT INTO cpy_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Iroka ikantzi Tajorentsi: ‘Powiiyiti okaate pantetyaari poyaari jempe pikaateeyini pipankoki. Pijayi apaaniki pachaka ikemyaari apaani atziri.” ");
INSERT INTO cpy_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Imatakiro Israel-paeni ikantee-takiriri. Eenitatsi ahaentsiri osheki, itsipa eepichokiini rowiitaki. ");
INSERT INTO cpy_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Rootaki imonkaa-tanta pachaka raayitzi, tee rapaawae-tziro ahaentsiri osheki, tee okoetyi-motyaari ahaentsiri eepichokiini. Raayitaki okaatzi ikoyiri royaari. ");
INSERT INTO cpy_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ari ikantaki Moisés: “Eero powaan-tawo ashi inkaamanii.” ");
INSERT INTO cpy_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Roo kanteencha, ipiyatha-takawo Israel-paeni ikantawi-takariri Moisés, eenitatsi owaan-teenchari royaarimi inkaamanii. Tema othonka ochowi-tanaki, eejatzi shitzitanaki. Rootaki ikijanta-kariri Moisés ikaatzi piyatha-takariri. ");
INSERT INTO cpy_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ari ikantatyaa ikoyii okiteeje-tamanee, rayi okaatzi ikoyiri royaari. Aririka ijaawata-paaki ooryaa, othonka iwyaahanakya. ");
INSERT INTO cpy_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Rooma 6-tatsiri kiteejeri, ari rawijakaero okaatzi rowiita-piintziri otsipa kiteejeri, apite pachaka raakotzi royaari apaani atziri. Roojatzi riyaatashitantanakari jewaripaeni ikamantziri Moisés okaatzi raayitakiri. ");
INSERT INTO cpy_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ari ikantzi Moisés: “¡Jewaripaení! Rootaki ikantakiri Tajorentsi, ikantzi: ‘Okiteeje-tamanee, rootaki kiteejeri imako-ryaan-teetari iitajonkawentakiri Tajorentsi. Pikoyi-rika ponkotsitiro, pimatiro. Pikoyi-rika pitashitiro, pimatiro. Aririka otzimahaanti, kantacha powaan-tyaawo poyaari inkaamanii.’” ");
INSERT INTO cpy_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Imatakiro okaatzi ikantakiriri Moisés, rowaan-takawo, rootaki royaari inkaamanii, teemaeta ochowitzi, tee oshitzitzi eejatzi. ");
INSERT INTO cpy_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ari ikantzi Moisés: “Poyaawo nimaeka, tema rootaki kiteejeri jempe romaerintawenteetari Tajorentsi. Eero piñiiro opiyo-wanetyaa okimipiintaha. ");
INSERT INTO cpy_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Tema apatziro okaate 6 kiteejeri powiita-piinti, rooma kiteejeri 7-tatsiri imako-ryaan-teetari, eero piñiiro opiyo-wanetyaa.” ");
INSERT INTO cpy_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Roo kanteencha, eenitatsi Israel-paeni jatamanaa-tsiri kiteejeri imako-ryaan-teetari rowiiti, teemaeta iñaapae. ");
INSERT INTO cpy_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Rootaki ikantan-tanakariri Tajorentsi irika Moisés, ikantziri: “¿Jempema okaateka pipakairo pipiyatha-waetawo nokanta-kaantani, eejatzi noñaani? ");
INSERT INTO cpy_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Pikenkishiretyaa, naaka Tajorentsi wetsika-kimirori kiteejeri imako-ryaan-teetari. Rootaki otzimantari 6-tatsiri kiteejeri paantyaari osheki poyaari apiteki kiteejeri. Rooma kiteejeri imako-ryaan-teetari, pijeeki pipankopaeniki eero pishitowa-waetzi jempe-rika-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ari ikantakiro Israel-paeni romoerin-teeyakani kiteejeri imako-ryaan-teetari. ");
INSERT INTO cpy_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Ikanta irika Israel-paeni iitakiro iroka owanawontsi “iitaka”. Tema kitamaapaneri, roowaetaki oryaaneeriki okithoki pankirentsi, pocharini rowaetaki ocheerinkaantsi rowaetee-tziro pitsi. ");
INSERT INTO cpy_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Ikanta rawijee-yanakini maawoeni Israel-paeni ijeekawi-tapaaka ochempi-mashiki Cheentoni, eentsikiroeni ikanta riyaateeyini, ikemijantakiro ikantziriri Tajorentsi. Roojatzi rareetee-yantakarini Maamentoweniki, ari ijeekae-yapaakini janta jempe tee otzimapae nijaa rireri. ");
INSERT INTO cpy_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ari rapiita-neero Israel-paeni iñaana-mintha-teeri Moisés, ikantziri: “¡Moisés! Pipina nijaa nomiriteri.” Ari ikantzi rirori Moisés: “¿Iitaka piñaana-mintha-tantanari naaka? ¿Iita pikoshekan-tariri Tajorentsi?” ");
INSERT INTO cpy_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tema antawo imiritee-yakini Israel-paeni, eekiro iñaana-mintha-tatziiri Moisés, ikantziri: “¿Iitaka pamantanari nojeekawita Apitantoniki? ¿Rooma pamantanari aayitina nomiri naaka, imiri notomi-paeni eejatzi nopira-paeni?” ");
INSERT INTO cpy_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Rootaki ramanan-tankari Moisés ikowako-takiri Tajorentsi, ikantziri: “¡Tajorentsi! ¿Jempema nokanti-rika irika-paeni nosheninka? ¡Aririka awijimo-takiri eepichokiini oetarika, ari rowamaan-takyaanawo mapi!” ");
INSERT INTO cpy_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ikantzi Tajorentsi: “¡Moisés! Piyaati jempe ipiyotee-yakani pisheninka-paeni Israel-paeni, pitsipa-tanakyaari antaripero-paeni. Paanakiro pikotzi pipajaatan-taakawori paerani nijaa. ");
INSERT INTO cpy_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ari nojeekiri eejatzi naaka janta ochempiki Mameriitoni. Pompojiro shiranta, aritaki oshitowanaki nijaa rireri pisheninka-paeni.” Tema imatakiro Moisés okaatzi ikantakiriri Tajorentsi, iñaakiri antaripero-paeni Israel-paeni rantakiri. ");
INSERT INTO cpy_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Rootaki owaeta-kaantzirori janta Koshekaa-rini, rootaki iiteetzitari eejatzi Kijima-shaari, tema osheki ikijawaetaka Israel-paeni, ikijima-waetakiri Tajorentsi, ikantaki: “¿Maperorima itsipatee Tajorentsi, tee ramatawitee?” ");
INSERT INTO cpy_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Tema awijanaki ikaatzi mawa kashiri romishitowae-teeri Israel-paeni ijeekawitaka Apitantoniki, areetee-yakani ochempi-mashiki Cheentoni. ");
INSERT INTO cpy_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Tema ipoñaanaawo Maamentoweniki irikapaeni Israel-paeni, roojatzi ochempi-mashiki Cheentoni jempe ijeekae-yapaakini. Ari ipanko-thaante-teeya-paakani imonteta-paakawo ochempi. ");
INSERT INTO cpy_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Ari itonkaanaki Moisés itonkiyo-tyaari Tajorentsi ikenkitha-waetakaeri. Ari iñaawae-tanaki Tajorentsi ijeekaki ochempiki, ikantziri: “¡Moisés! Pikamanteri icharini-paeni Jacob pikanteri: ‘¡Israel-paeni! Iroka iñaani Tajorentsi, ikantzi: ");
INSERT INTO cpy_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Piñaayi-takiro jempe nokantakiri Apitantoni-jatzi, jempe nokantakiro namanteemiri nojeekira naaka, tema oshiyawi-takawo riimi amaemini pakitha ishiwankiki. ");
INSERT INTO cpy_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Aririka pimonkaa-teero okaatzi akashiyakaa-wakaari, eerorika pipiyathatana, tema eerokapaeni netako-pero-teeyaa, ari awijanakiro okaatzi netakotari paashini-jatzi, tema naaka ashitawori maawoeni kepatsi. ");
INSERT INTO cpy_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ompera-tajorentsi-taarewo piinayitee eeroka pikaatzi ipinkathari-wenteetakimi. Pikiteshireyitee.” Rootaki iroka ñaantsi pikanteriri pisheninka Israel-paeni.’” ");
INSERT INTO cpy_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Ari ipiyapaaki Moisés, ikaemakiri antaripero-paeni, ikamantakiri okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ikantee-yanakini maawoeni Israel-paeni: “Ari amatakiro okaatzi ikantakiri Tajorentsi.” Eejatzi ipiyanaawo Moisés, ikamanta-paeri Tajorentsi, ikantziri: “Ikowaeyakini nosheninka-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ari ikantziri Tajorentsi: “¡Moisés! Ari nokanta-kaakyaawo otsirenirikaakiti menkori, ari nopokiri noñiimi, tema ari ikemakina pisheninka-paeni noñaanatimi. Ashi rowaero ikemijantimi.” Tema rapiita-nakiro Moisés okaatzi ikowakiri Israel-paeni, ikamantakiri Tajorentsi, ikantziri: “Kyaaripero ikowaeyakini nosheninka.” ");
INSERT INTO cpy_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ikantzi Tajorentsi: “¡Moisés! Piyaati, powetsika-shire-takahae-yaari pisheninka-paeni nimaeka iroka kiteejeri eejatzi inkaamanee. Ikiwayi-teero eejatzi iithaari-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Raamawentayityaa eejatzi otsipaki kiteejeri. Tema ari nayiite ochempiki Cheentoni, iñiina maawoeni pisheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Pookoteniri pisheninka-paeni jempe roweyiiyaa ranashiti, pikanteri: ‘Eero pawijiro eepichokiini jempe nookotakiro. Pipinkathatiro, eero pitonkaa-waetzi. Eenitatsi-rika awijakironi jempe nookotakiro, otzimatyee romwamae-tiri.’ ");
INSERT INTO cpy_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tee oshinetaan-tsitzi eepichokiini roteeyeetiro, aritaki rompojantee-takyaari mapi, eerorika ikenteetyeeri. Riirika atziri, riirika ipireetari, otzimatyee rowamaayiteri. Apatziro oshinitaan-tsita itonkahaeti aririka itziwooteeti.” ");
INSERT INTO cpy_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ari roerinkaa Moisés janta ijeekae-yakinira isheninka-paeni, rowetsika-shire-takaa-yitakari. Ikiwakaa-yitakiri iithaari apaani-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ikantakiri eejatzi Moisés isheninka-paeni, ikantziri: “¡Israel-paeni! Otzimatyeera paamawentyaa otsipaki kiteejeri, eero pitsipatawo piina-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Okanta okiteeje-tamanee mawatatsiri kiteejeri, omapoka-shitaka oshintsitanaki ochenki-tanaka ookatha-rentsi, tsirenikaakitanaki menkori ochempiki. Ikemaetatzii oshintsitanaki itziwooteetzi. Antawo ithaawae-yanakini kemakirori. ");
INSERT INTO cpy_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Ari raanakiri Moisés maawoeni isheninka-paeni itonkiyo-tawakyaari Tajorentsi. Katziyee-yapaakani onomataki ochempi. ");
INSERT INTO cpy_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tema kachaaryeenka okantanaka Cheentoni rayiita-paakira Tajorentsi. Kimitaka kachaa-reen-katzi paamari. Othonka otziñaaka ochempi. ");
INSERT INTO cpy_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Eekiro ishintsiitatzii itziwooteetzi. Tema iñaawaetzira Moisés, akatsi rirori Tajorentsi roshiyakawo ookatha-rentsi. ");
INSERT INTO cpy_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Rayiitaki Tajorentsi ochempi Cheentoni. Ari ikaemakiri Moisés ipoki tonkaariki. Jatanaki Moisés tonkaariki. ");
INSERT INTO cpy_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Ikantziri Tajorentsi: “¡Moisés! Pipiyi taapiki, pikanteri pisheninka-paeni eero rawijiro jempe nookotakiro ikowi iñiina. Raamawentyaa ikamayitzikari. ");
INSERT INTO cpy_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Otzimatyee rowetsika-shire-teeyaa eejatzi Ompera-tajorentsi-taarewo, ipokantyaari iñiina. Raamawentyaa ithonkakari ikamayitzi.” ");
INSERT INTO cpy_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ari ikantziri Moisés: “¡Tajorentsi! Eero imatziro nosheninka-paeni itonkaero ochempi Cheentoni, tema eeroka kanteen-tsiri: ‘Pookoti jempe iweyiiyaa ranashi-teeti ochempiki, tema otajorentsipathatatzii iroka.” ");
INSERT INTO cpy_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ari ikantziri Tajorentsi: “¡Moisés! Poerinkae. Opoñaashityaa pitonkahae eejatzi pitsipa-teeyaari Aarón. Riima Ompera-tajorentsi-taarewo eejatzi pisheninka-paeni, eero rawijiro jempe pookotakiro, raamawentyaa ikamikari.” ");
INSERT INTO cpy_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ikanta roerinkaa Moisés, ikamanta-paeri isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ari iñaawae-takirori Tajorentsi iroka ñaantsi, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Naaka Pitajorentsite, naaka ahaemiri rompera-waetee-tzimi Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Eero pipinkatha-waetziri tajorentsi-niro, apatziro pipinkathatina naaka. ");
INSERT INTO cpy_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Eero powetsika-waetzi oshiyakaa-wontsi, eero piitajorentsi-waetziri jeekatsiri jenokinta, kepatsiki, nijaaki eejatzi otapi-naki kepatsi. ");
INSERT INTO cpy_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Eero pipinkatha-waetziri, eero potziwerowa-shiwaetari eejatzi. Tema naaka Pitajorentsite, Shintsi-perori, Aamaako-tantaniri. Naaka owajankiteerini kijaneen-tanari, eejatzi itomi-paeni, icharini-paeni, itomi-paeni icharini-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Riima ikaatzi etakote-tee-nani naaka, ikemijan-teero noñaani, osheki netakotee-yaari rirori, ari nokanteeriri maawoeni icharini-teeyaari ikaati poyaatee-yaarini paata. ");
INSERT INTO cpy_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Naaka Pitajorentsite, eero pipaeryaa-shiwaetana. Tema nothonkiri nowajankiteeri naaka ikaatzi paeryaa-shiwae-tanari. ");
INSERT INTO cpy_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Pikenkishire-teero kiteejeri imako-ryaan-teetari, itajonkawen-teetakiri. ");
INSERT INTO cpy_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tema eenitatsi 6 kiteejeri pantawae-tantyaari, panteero okaatzi pikoyiri. ");
INSERT INTO cpy_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Rooma kiteejeri 7, ari pikenkishire-teenari Naaka, Pitajorentsite. Tee okameethatzi pantawae-tantyaawo iroka kiteejeri, eejatzi pitomi, pishinto, pomperatani, pipira-paeni, eejatzi paashini-jatzi ikaatzi jeekimo-tzimiri pipankoki. ");
INSERT INTO cpy_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Tema okaatzi 6 kiteejeri nowetsikan-takawori inkiti, kepatsi, inkaari eejatzi okaatzi tzimatsiri. Rooma kiteejeri 7, nomako-ryaan-takawo. Notajowen-takiro iroka kiteejeri. ");
INSERT INTO cpy_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Pipinkatha-teeri pipaapati eejatzi piniro. Aritaki ojamanitaki nañaakaemi kepatsiki nokashiya-kaakimiri nopaemiri. ");
INSERT INTO cpy_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Eero powamaantzi. ");
INSERT INTO cpy_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Eero pimayempitzi. ");
INSERT INTO cpy_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Eero pikoshitzi. ");
INSERT INTO cpy_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Eero pitheeya-kotanta. ");
INSERT INTO cpy_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Eero piñaawena-takotari okaatzi tzimimo-tziriri pisheninka, ipanko, iina, romperatani-paeni, ipira-paeni, maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Iñaakiro maawoeni Israel-paeni ookatha-rentsi, ikemakiro tziwoorentsi, iñaakiro eejatzi kachaari ochempiki. Ikanta iñaayitakiro iroka-paeni, antawo ithaawae-yakini, inteena ikatziyee-yakani. ");
INSERT INTO cpy_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ari ikantee-yanakirini Moisés: “Piñaanatina eeroka, aritaki nantakiro okaate pikantinari. Tee nokoyi iñaanatina Tajorentsi, rowamaa-nakari.” ");
INSERT INTO cpy_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Ikanta rapiiteero Tajorentsi ikanteeri Moisés: “Pitonka-haero ochempi, poyiina janta. Ari nopimirori mapikota jempe nojankinatakiro noñaani eejatzi nokanta-kaantani, rootaki piyotaa-yiteeriri pisheninka-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ari ikatziyanaka Moisés itsipatakari Josué amitako-tziriri, wetsikanaka riyaati rochempiteki Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Ikantanakiri antaripero-paeni: “Ari poyaawakina jaka roojatzi nopiyan-teeyaari. Riitaki jeekakaemini Aarón itsipatyaari Hur. Eenitatsi-rika kosheka-wakaa-chani, pikowakoteri rirori raminako-timiro.” ");
INSERT INTO cpy_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ari itonkaanee Moisés ochempiki. Opeyawakiri otsirenikaakitakira menkori. ");
INSERT INTO cpy_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ari ayiinta-paaki rowaneenkawo Tajorentsi ochempi-mashi Cheentoni. Okaatzi 6 kiteejeri omenkoritaki. Okanta omonkaataka 7 kiteejeri, eenitatsi ñaanata-kiriri Moisés menkoriki. ");
INSERT INTO cpy_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Tema koñaatziro iñaayitakiro Israel-paeni rowaneenkawo Tajorentsi, oshiyakawo opaamatzi paamari tonkaariki ochempiki. ");
INSERT INTO cpy_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Ikyaanta-nakawo Moisés menkori, tonkaanaki ochempiki, ari ijeekakiri okaatzi 40 kiteejeri eejatzi 40 tsireniri. ");
INSERT INTO cpy_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Ari rapiiteero Tajorentsi iñaanateeri Moisés, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Pamini wetsikinani tajorentsi-thaante ari nojeekiri notsipa-tyaari pisheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pimatiro maawoeni jempe okantajaantyaa noñaayimiri. Tema ari pikantiro powetsikiro tajorentsi-thaante, eejatzi okaate tzimatsini inthomoeki.” ");
INSERT INTO cpy_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Powetsiki inchanaki, awijaneentiro apikonati ojanthate, awijaneentiro apaani akonaki okimiinati, eejatzi okaate ojenokiti. ");
INSERT INTO cpy_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pitziri-tantyaawo ooro inthomoeki eejatzi jakakiroki. Powashi-nampi-tantyaawo ooro onampi-naki. ");
INSERT INTO cpy_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ari potetiro inchanakiki nopimiri nokanta-kaantani. ");
INSERT INTO cpy_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Powetsiki otapa piyoshii-takiri ooro. Rootaki iiteeteri iroka otapa “neshironka-mentotsi”. Awijaneentiro apikonate ojanthati, rooma okimiiti awijaneentiro apakonate. ");
INSERT INTO cpy_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Powetsiki apiti roshiya-kaawo shiwankiri Onampiri tajorentsi, riitaki powakiri apitekiti opatziyaakiki otapa. Riitaki piyoshiiteri ooro, eentsikeroeni pikantiri pompojeri powetsikan-tyaariri. ");
INSERT INTO cpy_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Apaani okantyaa otapa powetsikiro. Ari ikatziyeri apitekiti opatziyaakiki apite shiwankiri ronampiri tajorentsi powetsikakiri. ");
INSERT INTO cpy_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ari itzinaa-shiwanki-tyaa ikatziya-yitaki imonteta-wakaeya, riitaki pamankan-takyaawoni ishiwanki neshironka-mentotsi. ");
INSERT INTO cpy_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Rootaki pitapatan-tyaawori inchanaki, ari potetakirori nokanta-kaantani nopimiri. ");
INSERT INTO cpy_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ari noñiimiri eeroka janta, ari nokenkitha-waetakaemiri nojeekaki neshironka-mentotsiki, nojatekan-takyaari apite shiwankiri ronampiri tajorentsi jeekaen-tsiri otapaki Tajorentsi-naki. Ari nokaman-timirori okaate piyotaa-yiteeriri Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Iroka okaate payiri powetsikan-tyaawori Tajorentsi-thaante. Tema okaatzi 10 rooperori kithaarentsi, anashirikimawotatsiri, thonkiri-mawo-tatsiri, eejatzi kityonka-mawo-tatsiri. Ari piwichaa-kotirori roshiya-kaawo shiwankiri ronampiri tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Iroka okaate ojanthayiti kithaarentsi-paeni. Tema okaatzi ojanthati 28 konakintsi, rooma okimiitzira okaate 4 konakintsi. ");
INSERT INTO cpy_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Powawiti 5 kithaarentsi, tema apamawoeni okantanakyaa, powawiti eejatzi otsipa 5 kithaarentsi. ");
INSERT INTO cpy_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ari pikanta-kirori eejatzi iwitzi pipira, powetsiki okaate 11 kithaarentsi, rootaki pipashikan-tyaawori Tajorentsi-thaante. ");
INSERT INTO cpy_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Tema iroka okaate ojanthati apaani kithaarentsi, okaate 30 konakintsi. Rooma jempe okimiitzi okaate 4 konakintsi. ");
INSERT INTO cpy_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Payi okaate 5 kithaarentsi, powawitakiro. Pimati otsipa okaate 6 kithaarentsi, powawitakiro eejatzi. Rootaki pipashikan-tyaawori Tajorentsi-thaante. Potzipiyiro jempe awijapaaki, rootaki pithatakiri ikyaapiinteetira Tajorentsi-thaanteki. ");
INSERT INTO cpy_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Paaki eejatzi imashi piratsi pithakan-takyaawo kityonkari, rootaki pipashikan-tyaawori tajorentsi-thaante. Payitakyaa imashi jeekatsiri nijaaki, rootaki pipewiryaakiri pipashikan-tyaawo. ");
INSERT INTO cpy_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Payi eejatzi incha-kota-paeni omeriki-tyaari tajorentsi-thaante, kameetha otampatzikayiti. ");
INSERT INTO cpy_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Otzimatyee powetsikiro tajorentsi-thaante jempe okanta noñaaha-kimiro ochempiki. ");
INSERT INTO cpy_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Pithata-shitiro rooperori kithaarentsi. Rontyaani yotzirori ikarina-tantawo anashiriki-thatatsiri, thonkiri-thatatsiri eejatzi kityonka-thatatsiri. Ari rontyaakotiro roshiya-kaawo shiwankiri ronampiri tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Payi inchapanki powatzika-shitirori okaate 4, pitziri-tanta-kyaawo ooro. Powetsiki eejatzi okaate 4 ayeentironi jempe powatzikiro, riyoshiityaa koriki. Powetsikaki otsiko-paeni, riyoshiitya ooro. Rootaki pojatekan-tyaawori kithaarentsi pithata-shitirori. ");
INSERT INTO cpy_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tema iroka kithaarentsi pithata-shitirori, rootaki inashi-tyaawoni apinate tajorentsi-thaante, apaani tajorentsi-tatsiri, otsipa tajorentsi-pero-tatsiri. Ari poyirori Tajorentsi-naki jempe otajorentsi-perotaki. ");
INSERT INTO cpy_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Pitapatan-takyaawo tajorentsi-naki otapa neshironka-mentotsi powakiri janta otajorentsi-perotakira. ");
INSERT INTO cpy_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Powetsikiro eejatzi taapokimentotsi paashitiro incha-kota, okaate 5 konakintsi ojanthati eejatzi okaate okimiiti, rooma ojenokitzi okaate 3 konakintsi. ");
INSERT INTO cpy_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Powetsiki okaate 4 ochee onampi-naki. Eero payi otsipa incha-kota powetsikiri ochee, tema apakota okantyaa. Pitziri-tantyaawo kiterita-tsiri eshiro. ");
INSERT INTO cpy_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Pikaema-kaanteri pirentzi Aarón eejatzi itomi-paeni Nadab, Abiú, Eleazar, Itamar. Tema riitaki niyoshii-takiri ikaatee-yakini pisheninka Israel-paeni nompera-tajorentsi-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Powetsika-kaantiniri iithaari pirentzi Aarón ikashiya-kaerori rompera-tajorentsiti. Tema rootaki ipinkatha-tantee-tyaariri, rowaneenka-tanakyaa-rika. ");
INSERT INTO cpy_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Pontyaa-kaanti anashiriki-mawotatsiri kithaarentsi. Rootaki ipewiryaa-kotyaari. ");
INSERT INTO cpy_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Powetsika-kithokiyiti pithata-shitirori opatzi-kaakiki pewiryaako-wontsi. Paayiti kityonka-thari mampetha, thonkiri-thatatsiri, anashiriki-thatatsiri. Ari pikimitaakiri eejatzi ooro, powetsika-ñakiyi-takiri, pithayiteri opatzi-kaakiki. ");
INSERT INTO cpy_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Pithati apaani powetsika-ñakiteri ooro, pithati eejatzi apaani powetsika-kitho-kitakiri mampetha. Ari pikanta-kirori maawoeni opatzi-kaakiki, kameetha pithapetaata-kiniro. ");
INSERT INTO cpy_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Rootaki ikithaa-tapiin-tyaari Aarón aririka imateero rompera-tajorentsi-tantari. Aririka ikyi tajorentsi-thaanteki ipinkathatiri Tajorentsi, aririka ishitoyi eejatzi, rootaki ikemaeteri okameniyiti ithañaki-yitakiri ooro, ari okantyaa eero ikamanta. ");
INSERT INTO cpy_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Powetsiki eejatzi ooromerontaki. Riitaki yoshiita-chani ooro powetsikan-tyaari. Ari pijankina-tirori ñaantsi, kantatsini: “Kiteshireri Tajorentsi”. ");
INSERT INTO cpy_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Pithato-tantyaawo thonkiri-thatatsiri, poojoteniri ramantheeriki, eejatzi ipankakeroki. ");
INSERT INTO cpy_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ari ojeeka-piinta-tyee ramantheeri ipankakeroki Aarón, rootaki rinimotakaantyaariri Tajorentsi. Tema riitaki Aarón atsipetyaawoni okaatzi rowaaripero-yitakiro Israel-paeni roetentakiri Tajorentsi, eejatzi okaatzi rashita-kaetariri Tajorentsi roetentayitakiri. ");
INSERT INTO cpy_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Iroka poetziñaariko-tyaari kiteejeriki: Pitayi taapokimentotsiki apite piratsi tzimatsiri apaani rojarentsite. Eero poshiteero. ");
INSERT INTO cpy_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Pitayi apaani okitejiityaama-neerika, riima itsipa pitayiri otsireniityaa-neerika. ");
INSERT INTO cpy_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Irika piratsi petyaari pitayiri, pitsipa-teeri ramiroka-patheetani pankirentsi-pane ijeekiteetakiro apite pajoki, itsipateetiro eejatzi oyeenka inchakitho ijeekitee-takiro apaani pachakaki, ijeetan-takyaari eejatzi imiriteetziri apaaniki pachaka. ");
INSERT INTO cpy_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ari pikanteriri eejatzi itsipa pitayiri aririka otsireniityaanee. Pitsipa-teeri itahae-tziri pashita-kaariri pankirentsi-pane, eejatzi imiriteetziri. Pitayiro okaatzi rashita-kaetariri Tajorentsi okachaa-maeti okantya iñaawenaa-tyaawori. ");
INSERT INTO cpy_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Rashi rowaero itahaenawo ikaati picharini-teeyaari opatzimooki Tajorentsi-thaante, janta notsipa-teemira naaka, nokenkitha-waetakaemi. ");
INSERT INTO cpy_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ari nopiyota-piintee-yaari notsipa-tyaari pisheninka-paeni Israel-paeni. Tema otajorentsitatye okantakae-yaawo janta nowaneenkawo. ");
INSERT INTO cpy_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Tema tajorentsi nokantakaeyaawo tajorentsi-thaante, eejatzi taapokimentotsi. Ari nokemiteeriri Aarón eejatzi itomi-paeni, tema riitaki nompera-tajorentsi-ti naaka. ");
INSERT INTO cpy_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Tema ashi noyiro notsipa-teeyaari icharini-teeyaari Israel-paeni, naakataki Itajorentsi-teeyaa. ");
INSERT INTO cpy_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Rootaki riyotanteeyaari Naaka Itajorentsite, naaka amaeriri ijeekawitaka Apitantoniki notsipa-taari. Tema naaka Itajorentsite.” ");
INSERT INTO cpy_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Powetsiki otsipa taapokimentotsi payi incha-kota, rootaki itaan-teetyaari kajankari. ");
INSERT INTO cpy_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Omonkaa-tawakaeyaa onampi-naki, okaate apaani konakintsi ojanthati onampina-paeni. Rooma ojenokiti okaate apite konakintsi. Eero payi otsipa incha-kota powetsikiri ochee, roojaatziita apakotawonika. ");
INSERT INTO cpy_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Riitaki yoshiita-chani ooro pitziri-tantyaawo oshitamenko, onampina, eejatzi ochee-paeni. Powashi-thapi-tantyaawo ooro onampi-naki-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Powakiro taapokimentotsi ithatashii-takirowa kithaarentsi tajorentsi-naki, omontetyaawo otapa neshironka-mentotsi, jempe noñaapiin-timi eeroka janta. ");
INSERT INTO cpy_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ari itaapiin-teerori Aarón okiteeje-tamanee kajankari, aririka riyaati raminiri ootamentotsi. ");
INSERT INTO cpy_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Rapiita-panaatiro Aarón aririka otsireniityaanee itayiro kajankari, aririka roeja-panaatiri ootamentotsi. Rashi rowaero ikaati picharini-teeyaari ranteenawo iroka. ");
INSERT INTO cpy_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Apawo-jatzi ojarentsiki ijeetan-teeyaawo Aarón riraaki ratsipe-takaani ochee-paeniki taapokimentotsi, okantya ipeyakoetiro ikaariperoetakira. Apawo-jatzi eejatzi ojarentsiki itahaeti ratsipe-takaani ipeyakoe-tantyaawori iyaari-peronka ikaati picharini-teeyaari. Tema tajorentsitanaki iroka taapokimentotsi ikantakaakawo Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Ari rapiiteero Tajorentsi ikanteeri Moisés: ");
INSERT INTO cpy_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Pikenkitha-waetakaeri eeroka pisheninka, pikanteri: ‘Pipinkathatiro kiteejeri imako-ryaan-teetari, tema rootaki pikenkishire-tapiin-teeri eerokapaeni eejatzi naaka aririka awijayiti ojarentsi-paeni, rootaki riyoetan-tyaari naaka Tajorentsi oeteshire-yiteemiri eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Pitajorentsi-teero iroka kiteejeri imako-ryaan-teetari, pipinkathateero. Ikaati theenka-kironi iroka kiteejeri, rowamahaeteri. Ikaati antawae-tantyaawoni iroka kiteejeri, eero itsipataari ikaateeyini, rowamahaeteri. ");
INSERT INTO cpy_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Kantacha pantawaeti okaate 6 kiteejeri. Rooma kiteejeri 7, pitajorentsi-teero, pomaeri-tantee-yaawo pikenkishireteena Naaka. Eenitatsi-rika antawae-tantyaawoni iroka kiteejeri, aritake rowamahaetakiri.’ ");
INSERT INTO cpy_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Otzimatyee ipinkathateero pisheninka-paeni iroka kiteejeri romaerintan-teetari, rootaki romaeri-mento. Ashi rowaero ojarentsiki-paeni ikashiya-kaenawo Naaka. ");
INSERT INTO cpy_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ashi owaero ikenkishire-tapiin-teena pisheninka-paeni, roshire-tantee-nari Naaka.” Tema 6 kiteejeri rantawaetaki Tajorentsi rowetsikan-takawori inkiti eejatzi kepatsi, rooma kiteejeri 7, ari ikaatakiro rantawaetaki, roojatzi imako-ryaantaka. ");
INSERT INTO cpy_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ikanta ithonkakiro Tajorentsi ikenkitha-waetakaeri Moisés ochempiki Cheentoni, ipakiri apite mapikota jempe rojankinatan-takawo Tajorentsi rakoem-peki Ikantakaantani. ");
INSERT INTO cpy_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ikanta iñaakiro Israel-paeni rojamanitakira Moisés te roerinkaawo ochempi, ipiyowen-takari Aarón, ikantakiri: “Powetsikina oshiyakaa-wontsi notajorentsi-tetee-yaari, riitaki jewateenani. Tema tee ayoteeyini iitarika antakiriri Moisés, amayiteeri ajeekawitaka Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Ari rakanaki Aarón, ikantanakiri: “Pamakinari jaka maawoeni ooro othayitziri okempitaki piinapaeni, pitomipaeni eejatzi pishintopaeni.” ");
INSERT INTO cpy_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ithonka rahaetakiri ooro ikaatzi ithatee-tziri kempitantsiki, raana-kiniri Aarón. ");
INSERT INTO cpy_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Tema riwyaahakiri maawoeni ooro. Iwenata-shitakiri, roshiya-kaakari iryaani waaka. Ikanteeyini Israel-paeni: “¡Nosheninká! Irika atajorentsite amayiteeri ajeekawitaka Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ikanta iñaakiro Aarón kanteen-chari, rowetsikaki eejatzi taapokimentotsi jempe ijeekaki roshiya-kaawo iryaani waaka. Ishintsiiyini kaemaeyini Israel-paeni, ikantzi: “Okiteeje-tamanee oemoshirenkyaa apinkathatiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ikanta ipiriin-tamanaa okiteeje-tamanee, itaa-kiniri ipira-paeni, eejatzi okaatzi rashita-kaariri raapatziyan-teeyaariri. Ari rowaeyakani, rirawae-teeyini, ithaamen-teeyakani. ");
INSERT INTO cpy_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Ikanteeri Tajorentsi irika Moisés: “Piyaatee taapiki, tema kaariperotaki pisheninka-paeni pamaeri ijeekawita Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Tema intsipaete ipakaanakiro okaatzi nokantziriri rantiro. Rowetsikaki roshiya-kaawo iryaani waaka. Riitaki ipinkathatzi, itaa-kiniri ratsipe-takaani-paeni. Ikanteeyini: ‘¡Nosheninká! Irika atajorentsite amayiteeri ajeekawita Apitantoniki.’” ");
INSERT INTO cpy_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Eekiro iñaawae-tatzii Tajorentsi ikantziri Moisés: “Niyoshire-takiri pisheninka-paeni, osheki ipiyathayita. ");
INSERT INTO cpy_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","¡Antawo rowatsimaakina nimaeka, otzimatyee nothonkiri! Rooma eeroka aritaki noshekyaakimiri ikaati picharini-teeyaari.” ");
INSERT INTO cpy_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Rootaki ramanan-tanakari Moisés, ikantzi: “¡Tajorentsi! ¿Iitaka ayimatan-tzimiri pimashirenka pikoyi pithonkeri pashitari eeroka, tema riitaki pamaeri eeroka ijeekawitaka Apitantoniki, poñaahan-takiro pishintsinka pamantaariri? ");
INSERT INTO cpy_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ari ikantee-yanakini Apitantoni-jatzi: ‘Tema reeteempyaashita Tajorentsi raantariri, ikoyi rowamayiri ochempi-mashiki eero itzimantaa kepatsiki.’ Pipitsimareeyaa, aritapaaki pikijakiri pashitari eeroka. ");
INSERT INTO cpy_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Pikenkishire-takoteeri pomperatani-paeni Abraham, Isaac, eejatzi Israel. Tema pipaeryaaka eeroka pikantakiri: ‘Kyaaryoperori nosheni-teemiri ikaati picharini-teeyaari roshiyee-yaari ompokiro-paeni jenokinta, riitaki ashitee-yaawoni maawoeni iroka kepatsi nokashiya-kaakimiri, ari ikanteetaatyeeyaani rashitee-yaawo riroripaeni.’” ");
INSERT INTO cpy_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ari ipakaanakiro Tajorentsi okaatzi ikantawi-takari ithonkaerimi ikaatzi rashitari rirori. ");
INSERT INTO cpy_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ari roerinkaari Moisés, ramae apite mapikota jempe ojankinataka ñaantsi, tema apitekiro ojankinataka jantakironta. ");
INSERT INTO cpy_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Riitaki Tajorentsi wetsikakiro mapikota, riijatzi Tajorentsi thapatakiro okaatzi jankina-teenchari mapikotaki. ");
INSERT INTO cpy_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ikanta ikemapaeri Josué ikaemaeyini isheninka-paeni, ikantziri Moisés: “Pikemi ikaemaeyini asheninka-paeni kimitaka rowayiri-teetatyaa apanko-thaanteki.” ");
INSERT INTO cpy_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ari rakanaki Moisés, ikantzi: “Tema romampahae-yatyaani nokemakiri naaka. Tema kaari kaemaantsi rotsinampaeteri rowayiri-teetyaari, kaari eejatzi kaemaantsi rotsinampaeri rowayiritani.” ");
INSERT INTO cpy_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ikanta rareetapaa Moisés ipanko-thaante-teeyakani isheninka-paeni, iñaatziiri roshiya-kaawo iryaani waaka, riitaki ithaamen-teeyarini. Antawo ikijanaka Moisés, rookapaakiro mapikota jempe otonkae-matanaka ochempi, othonka opookapaaki mapikota. ");
INSERT INTO cpy_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Raapaakiri roshiya-kaawo iryaani waaka, itaakiri. Itononkakiri, roowe-pane-takiri, rowiinka-wane-takiri nijaaki. Rirakaakiri isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Ari rojampi-takiri Aarón, ikantziri: “¡Yeeyi! ¿Jempema ikantakimika eeroka asheninka-paeni panta-kaantariri iroka antawoete kaari-perotatsiri?” ");
INSERT INTO cpy_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Akanaki Aarón ikantzi: “¡Jewarí! Eero pikijana. Piyotziri eeroka asheninka-paeni osheki iñaawena-takawo kaari-perori. ");
INSERT INTO cpy_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tema riitaki kantakinari: ‘Powetsikina oshiyakaa-wontsi notajorentsi-tetee-yaari, riitaki jewateenani. Tema tee ayotee-yini iitarika antakiriri Moisés amaeri ajeekawita Apitantoniki.’ ");
INSERT INTO cpy_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Nokanta-nakiri naaka: ‘Ikaatzi itzimimo-tziri ooro, ramakinari.’ Imatakiro ipaetakinari ooro, notaakiri paamariki, ari rowetsika-nakari roshiya-kaawo iryaani waaka.” ");
INSERT INTO cpy_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Ikanta iñaakiri Moisés tee ikanta-peroteeya isheninka-paeni, osheki itheen-kawae-takiri iijaneentani. Tee imataneero Aarón ikaminaa-yiteeri. ");
INSERT INTO cpy_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Jataki okiishitaha awotsi inampiki, ikantzi: “Ikaatzi awentaariri Tajorentsi, ipoki jaka nojeekakika naaka.” Tema riitaki yoshiiteencha maawoeni Leví-paeni riyaataki ijeekakira Moisés, itsipata-paakari. ");
INSERT INTO cpy_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ikantakiri Moisés: “¡Nosheninká! Iroka ikantzi Tajorentsi, Itajorentsite Israel: ‘Payi apaani-paeni eeroka piyotsiro-shitha-kite, pipiyi pipanko-thaanteki, pikyaayiti maawoeniki pankotsi, powamayiri pirentzi, pitsipaminthari, eejatzi pisheninka-paeni.’” ");
INSERT INTO cpy_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Imatakiro Leví-paeni ikantakiriri Moisés. Tema ikaatzi 3,000 isheninka rowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ari ikantzi Moisés: “Pimatee-yakironi eerokapaeni powetsika-shire-wentaari Tajorentsi, rootaki itajonka-wentanteemiri, tema pimatakiro pompera-tajorentsi-yitantari apaani-paeni eeroka pikemijan-takiri Tajorentsi pakota-shiyi-takiri pitomi-paeni eejatzi pirentzi-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Okanta okiteeje-tamanee, ikantakiri Moisés isheninka-paeni: “Tema antawoete pikaariperotaki eerokapaeni. Nimaeka niyaati ochempiki ijeekira Tajorentsi, okantashi-maetyaa raripero-teemi.” ");
INSERT INTO cpy_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Jataki Moisés ijeekira Tajorentsi, ikantapaeri: “Antawoeti ikaariperotaki nosheninka-paeni, rowetsikakiri ooro, riitaki itajorentsite-takari. ");
INSERT INTO cpy_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nokowako-tzimi paripero-teeri ikaariperotakira. Eerorika paripero-teeri, posheteenawo nowaero pojankina-takotakinaha.” ");
INSERT INTO cpy_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ari rakanakiri Tajorentsi irika Moisés, ikantziri: “Apatziro nosheta-koteeri ikaatzi kaaripero-tzimotanari naaka. ");
INSERT INTO cpy_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Pipiyi eeroka, paaneeri pisheninka-paeni jempe nookota-kimiro. Riitaki jewatimini Nonampiri. Roo kanteencha, aririka omonkaa-teeyaa paata nowajankitaantee, aripaete nowajankitaa-wenteeri iyaari-peronka.” ");
INSERT INTO cpy_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tema ikantakaakawo Tajorentsi, imantsiya-tanaki maawoni Israel-paeni okantakaawo ipinkatha-takiri roshiya-kaawo iryaani waaka rowetsikakiri Aarón. ");
INSERT INTO cpy_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Ari iñaanateeri Tajorentsi irika Moisés, ikanteeri: “¡Moisés! Paminee eeroka apite mapikota oshiyaawo nopawita-kimiri, ari nojankinateerori noñaani nojankinawi-takari etawori mapikotakiki pipookakiri. ");
INSERT INTO cpy_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Pananinki okiteeje-tamanee pitonkaero ochempi Cheentoni. Pipoki otonkaa-perotaha ochempi nojeekira naaka. ");
INSERT INTO cpy_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Apaniroeni pipoki, tekaatsi anashi-waetachani janta ochempiki, eejatzi eero ranashiwaeta ipireetari-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Raaki Moisés apite mapikota, roowae-witaka etakawori ipawitakariri. Okanta okiteeje-tamanee, ananinkanaka raanakiro apite mapikota, itonkaanaki ochempiki Cheentoni, imatakiro okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Ari rayiita-paaki Tajorentsi menkoriki, itsipata-paakari Moisés, ipaeryaa-paaka Tajorentsi, ikantzi: “¡Naakataki!”. ");
INSERT INTO cpy_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Tema ikatziyi-motapaakari okaakiini Moisés, icheraapaaki ikantziri: “¡Naakataki Tajorentsi! Shintsi-perori, kaminthaan-taniri, neshironka-tantaniri, tsinampari, etakoki-tanta-niri, kyaariperori. ");
INSERT INTO cpy_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ashi noyiro netakotari maawoeni, nothonkaeri netakotee-yaari ikaati icharini-teetyaari. Nopeyako-teeniri iyaari-peronka, tema ikinashi-waeyitaka. Roo kanteencha tee namaaki-tziri nowajankiteeri antzirori kaari-perori, nothonkiri nowajankitaa-wentziri iyaari-peronka ashitariri, icharini, itomi icharini-tanakari, eejatzi maawoeni ichariniyiteeyaari riroripaeni.” ");
INSERT INTO cpy_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Tema intsipaeti rotziwerowanaka Moisés, oeyotanaka kepatsiki ipinkatha-tanakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ikantanakiri: “¡Tajorentsi! Kyaari-pero-rika paakameethatina, pitsipa-teena nokaatee-yakinika. Tema irika nosheninka-paeni osheki itheenkantzi. Roo kanteencha nokoyi pipeyako-teenawo nantayitakiro kaaripero-tatsiri. Poshiya-kaanteena eerokami ashitaanari.” ");
INSERT INTO cpy_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Ikantzi Tajorentsi: “Pikemi nokantimiri. Eenitatsi nokashiya-kaeriri pisheninka-paeni Israel-paeni, aritaki iñaayiteero maawoeni riroripaeni. Tema nantatyeero kaari iñeetzi paerani jaka kepatsiki, kaari iñeetzi otsipaki nampitsi. Tema ithonkyaa iñiiro atziri-paeni pijeekantakawo okaatzira rantakiri Tajorentsi, tema antawo okaate noñaakaemiri maawoeni eerokapaeni.” ");
INSERT INTO cpy_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Eekiro ikantana-kitzii Tajorentsi: “Pantiro okaate nokantimiri. Aritaki piñaakina nomishitowayiri Ochempi-weni-jatzi, Owinteni-jatzi, Thaawan-taarewoni-jatzi, Nampitsi-weni-jatzi, Thaantewenijatzi, Kaya-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Paamawentyaa paapatziyari-kari nampiyi-tawori jaka jempe nookota-kimiro, ramatawi-tzimi-kari, tema oshiyakawo iwirentsi ramatawi-mento. ");
INSERT INTO cpy_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pitzimpooka-pithateri itaa-mento-paeni, pitzimpooka-pithatiri itajorentsi-nirote, pithonkiri oshiyakaawo-paeni Inkaariweri. ");
INSERT INTO cpy_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Eero pipinkatha-tziri itsipajatzi-paeni tajorentsi-niro, tema irika Tajorentsi aamaawae-rintzi, rootaki owaeta-kaantziriri ikantan-teetariri Tajorentsi Aamaako-tanta-niri. ");
INSERT INTO cpy_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Paamawentyaa paapatziyari-kari nampiyi-tawori kepatsiki jempe poshire-takawo, imatakaemiro-kari ratsiperya-waeta ipinkatha-tziri itajorentsi-nirote, itayiniri ratsipe-takaani-paeni, pakyootzirikari rowaantari tzimahaan-tatsiri iwatha kaari itayi. ");
INSERT INTO cpy_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Paamawen-tyaa ikaemiri-kari pitomi-paeni raakaeri rishinto-paeni. Tema osheki omayempi-waetzi opinkatha-witarira otajorentsi-nirote, ari imatanakiro eejatzi pitomi-paeni ratsiperya-waetyaari ipinkathateri rirori tajorentsi-niro-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ojamani ijeekaki Moisés itsipatari Tajorentsi okaatzi 40 kiteejeri eejatzi 40 tsireniri. Tee rowaeyaa, tee imiritee nijaa. Ari rojankinata-kirori ñaantsi-paeni mapikotaki jempe okantakota ikashiyakaa-wakaeya-rini. Tema rootaki iroka Ñaantsi kaatatsiri 10. ");
INSERT INTO cpy_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Rantakiro Moisés okaatzi ikantakiriri Tajorentsi. Imatakiro maawoeni. ");
INSERT INTO cpy_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Tema awijaki apaani ojarentsi ishitowan-teetaari Apitantoniki, aripaeti ithonkae-takiro rowatzikae-teero Tajorentsi-thaante. ");
INSERT INTO cpy_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ari omapoka-shitaka opamanka-paakiro menkori Tajorentsi-thaante, tema ojeekan-tapaakawo rowaneenkawo Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ari iñaanateeri Tajorentsi irika Moisés, ijeekaki tajorentsi-thaanteki, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“¡Moisés! Pikenkitha-waetakaeri pisheninka-paeni Israel-paeni, pikanteri: ‘Aririka pamakiniri Tajorentsi pipayiteriri, pamakiniri piwaakati, eerorika pamakiniri powishate. ");
INSERT INTO cpy_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Riirika waaka pipiriri katziyeen-katatsini iyachaarinka pitaakiririka, riitaki paanaki shirampari, eero ramashi-waeta. Tema riitaki ookimotyaarini Tajorentsi pitaa-kiniriri opatzimooki tajorentsi-thaante. ");
INSERT INTO cpy_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Pioteya-yinatiri iitoki katziyeen-katatsini iyachaarinka pitaani, tema riitaki ookimotyaarini Tajorentsi ipeyako-tantee-mirori pantakirowa kaariperotatsiri. ");
INSERT INTO cpy_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Powamayiri pipira tajorentsi-thaanteki. Rayimae-tyaawo itomi-paeni Aarón, Ompera-tajorentsi-taarewo, riraa pipira rashita-kaeyaari Tajorentsi, itsikirijan-tyaawo onampi-naki-paeni taapokimentotsi ojeekakira opatzimookiki Tajorentsi-thaante. ");
INSERT INTO cpy_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Aririka powamaakiri, pimeshaayiri imashi, pitoyitiro maawoeni iwatha. ");
INSERT INTO cpy_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Riima itomi-paeni Ompera-tajorentsi-taarewo Aarón, riitaki oejatsini paamari taapokimentotsiki, riitaki oonthoyitironi tsitsi-paeni paamata-tsini. ");
INSERT INTO cpy_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Riijatzi itomi-paeni Aarón Ompera-tajorentsi-taarewo, owankita-kirini iwatha ipira opaamatakira tsitsi, itsipataakiri iito, eejatzi iyeenka-paeni. ");
INSERT INTO cpy_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Eerokataki kewironi isheeto-paeni, eejatzi ipori-paeni. Itayimae-tyaari Ompera-tajorentsi-taarewo taapokimentotsiki. Okatziyeenkatyaa iyachaarinka itaaha. Rootaki ookimotantyaariri Tajorentsi iñaaperotyaari rashitakaetariri. ");
INSERT INTO cpy_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Riirika owisha, riirika cabra pashita-kaariri Tajorentsi katziyeen-katatsini iyachaarinka pitaakiri, riitaki paanaki shirampari, eero ramashi-waeta. ");
INSERT INTO cpy_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Powamayiniri Tajorentsi jantakiroki taapokimentotsiki okatonkontzira. Rayiro itomi-paeni Aarón, Ompera-tajorentsi-taarewo, riraa itsikirijan-takyaawo maawoeni onampi-naki-paeni taapokimentotsi. ");
INSERT INTO cpy_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Opoñaashitya pitoyitakiri maawoeni iwatha, iito eejatzi iyeenka-paeni. Raakiri Ompera-tajorentsi-taarewo, rowanki-takiri opaamatakira paamari taapokimentotsiki. ");
INSERT INTO cpy_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Eerokataki kewironi isheeto-paeni, eejatzi ipori-paeni. Itaayitiro Ompera-tajorentsi-taarewo rowanki-takiri taapokimentotsiki. Okatziyeenkatyaa iyachaarinka itaaha. Rootaki ookimotantyaariri Tajorentsi iñaamaperotyaari rashitakaetariri. ");
INSERT INTO cpy_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Riirika shiwankiri pashita-kaeyaariri katziyeen-katatsini iyachaarinka pitaakiri, pamakiniri shiro, eerorika iryaani jamomo. ");
INSERT INTO cpy_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Riitaki Ompera-tajorentsi-taarewo ashitakae-yaariri Tajorentsi. Ithatyaakiri iitoki, ipitenkan-takyaawo riraa maawoeni onampi-naki taapokimentotsi, itaakiri taapokimentotsiki. ");
INSERT INTO cpy_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Paawakiro ishenokitziro rowanawo, eejatzi ishiwanki-paeni. Pookakiro onampi-naki taapokimentotsi ishitowa-piintzira ooryaa, jempe opiyotaka ojamampoti itahaetani. ");
INSERT INTO cpy_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Pitankapetatiri eero pithatyaa-waetziri. Itayiri Ompera-tajorentsi-taarewo taapokimentotsiki. Okatziyeenkatyaa iyachaarinka itaaha. Rootaki ookimotantyaariri Tajorentsi iñaamaperotyaari rashitakaetariri. ");
INSERT INTO cpy_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Roorika pankirentsi-pane pamaki pashita-kaeyaari Tajorentsi, pamaki rooperori opane, powaetakiro yeenkantsi eejatzi kajankari. ");
INSERT INTO cpy_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Pamakiniri itomi-paeni Aarón, Ompera-tajorentsi-taarewo. Raawaki eepichokiini powaeta-kirori yeenkantsi, eejatzi kajankari. Itaakiro taapokimentotsiki. Rootaki ookimotantyaariri Tajorentsi iñaaperotyaawo itahae-takiniriri rashita-kaetariri. ");
INSERT INTO cpy_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","okaate tzimahaan-taneen-tsini opane pashita-kaariri Tajorentsi, tajorentsi-pane-tanaki iroka. Riitaki owaeyaawoni Aarón eejatzi itomi-paeni. ");
INSERT INTO cpy_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Rapiiteero Tajorentsi iñaanateeri Moisés eejatzi Aarón, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Pikenkitha-waetakaeri pisheninka Israel-paeni, pikanteri: ‘Irika tsimeriyitatsiri ikaatzi jeekayitsiri antamiki, riitake kameethatatsiri poyaari. ");
INSERT INTO cpy_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Tema maawoeni tsimeriyitatsiri tzimatsiri apiti ishetaki, oepiyirori rowanawo iniyawi-takawo, inaatawaero kameetha iniyeero eejatzi, tee ipinkae-tziri irika-paeni, kameetha-tatsi rowaetyaari. ");
INSERT INTO cpy_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Riima ikaatzi ikyaakoetari, tzimawitachari apiti ishetaki, kaari oepiyironi rowanawo te inaa-perotziro iniyantyaawori, tee ikameethatzi poyaari, pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Ari ikimitari oshiyawi-tariri kochero, kaari oepiyironi rowanawo tee inaa-perotziro iniyantyaawori, teemaeta otzimi apiti ishetaki, riitaki pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ari ikimitari oshiyawi-tariri jamani, kaari oepiyironi rowanawo tee inaa-perotziro iniyantyaawori, tee otzimi apiti ishetaki, riitaki pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Eejatzi ikemitari chaancho, tzima-witacha apiti ishetaki, kaari oepiyironi rowanawo tee inaa-perotziro iniyantyaawori, riitaki pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Eero powayitari irika iwathapaeni, eero poteyaneentziri eepichokiini ikami-rika, riitaki pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Irika jeekantawori nijaa-paeni, riitaki kameetha-tatsiri poyaari tee ipinkae-tziri. Tema maawoeni tzimatsiri ipeteeshi, eejatzi ipentaki, ikaatzi jeekantawori inkaari eejatzi nijaa-paeni, tee ipinkae-tziri irika-paeni, kameetha-tatsi poyaari. ");
INSERT INTO cpy_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Riima kaari tzimatsini ipeteeshi-paeni, ipentaki-paeni jeekantawori inkaare eejatzi nijaa-paeni, ikaatzi jeekantawori inthomoyaaki nijaa, piwinkani poyeri. ");
INSERT INTO cpy_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Eero powayitari irika-paeni, riitaki pipinkiri. Eero poteyaneentziri aririka ikamayiti. ");
INSERT INTO cpy_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Riitaki pipinkayitiri maawoeni jeekatsiri nijaaki kaari tzimatsini ipeteeshi-paeni, eejatzi ipentaki-paeni. ");
INSERT INTO cpy_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Irika shiwankiri-paeni ikaati pipinka-yiteeri, kaari kameetha-tatsini poyaari: pakitha, awo, shimapako, ");
INSERT INTO cpy_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","tzijo, ikaatzi oshiyayi-tariri shirontzi, ");
INSERT INTO cpy_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ikaatzi inashi-yitachari tsiirotyonki, ");
INSERT INTO cpy_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ikaatzi oshiyayi-tariri mamawo, oshetatsiko, cherepito, ikaatzi oshiyayi-tariri pakitha, ");
INSERT INTO cpy_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","pawo, thoowo, ");
INSERT INTO cpy_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","janantzi, thawori, amempori, ");
INSERT INTO cpy_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","thompari, ikaatzi oshiyayi-tariri janantzi, tsimpe, piiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Irika itsipa ikaatzi pipinkiri, naapakitatsiri tzimatsiri ishiwanki, tzimatsiri iityeeriki ranashi-tantari. ");
INSERT INTO cpy_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Riima maawoeni oshiyariri inaapaki tzimatsiri ipori, mitaatsiri, eero pipinka-yitziri poyaari. ");
INSERT INTO cpy_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Irika ikaati poyaari: ikaatzi oshiyayi-tariri tsitsiri, pitziro, tsinawo, kentori. ");
INSERT INTO cpy_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Riima itsipa-paeni ikaatzi kaari apaeriiri inaapaki-witachari, aayita-tsiri, anashiyita-chari, riitaki pipinkiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Iroka-paeni otsipa matironi osheneemini. Itzimi-rika oteeyakirini ikamirika ipinkaetani tsimiriyitatsiri, ari ipinkaetanakiri irirori roojatzi tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Itzimi-rika antakironi eepichokiini iwatha kaminkari tsimeriyitatsiri, otzimatyee ikiwaero iithaari, ari ipinkaetanakiri roojatzi tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Tema tee ikameethatzi powayityaari ikaatzi konthaa-chari kepatsiki, anayita-tsiri kepatsiki, otzimawityaa iityeeriki-paeni, riitaki pipinkayitiri. ");
INSERT INTO cpy_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Pipinkayitiri ikaatzi anayita-tsiri kepatsiki, ikaatzi kamatha-yitatsiri, tema aririka poteeyakiri, ari ipinkaetanakimi eeroka. ");
INSERT INTO cpy_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Tema Naaka Pitajorentsite. Pikiteshiretee eeroka-paeni, tema naaka kiteshireri. Tee okameethatzi rowaaripero-waetimi tsimeri-yitatsiri ikaatzi anashiyitachari kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Naakataki Tajorentsi, naaka oemishitowaemiri Apitantoniki Pitajorentsi-tetee-na. Pikiteshiretee, tema naaka kiteshireri.” ");
INSERT INTO cpy_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Rootaki iroka ñaantsi riyotaan-tziri Tajorentsi jempe ikantakota tsimeri-paeni jeekatsiri antamiki, shiwankiripaeni, maawoeni añaayita-tsiri nijaaki, maawoeni kamathaa-yitatsiri kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ari piyoteeriri ikaatzi ipinkae-tziri eejatzi ikaatzi kameetha-yitatsiri. Ikaatzi rowaetari eejatzi kaari rowaetari. ");
INSERT INTO cpy_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Ikanta Tajorentsi iñaanateeri Moisés, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“¡Moisés! Piyoteeri pisheninka Israel-paeni, pikanteri: ‘Aririka omotziti tsinani, otzimakiri shirampari eentsite, ipinkaetiro okaate 7 kiteejeri. Tema oshiyaawo ipinkae-tziro aririka oñaawentyaa roori. ");
INSERT INTO cpy_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Aririka imaakotapaaki 8 kiteejeri itziman-takari eentsi, itomeshi-taanii-takiri. ");
INSERT INTO cpy_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Rooma tsinani tzimaaniteentsiri, otzimatyee omaerintyaa roori okaate 33 kiteejeri, roojatzi opeyantee-yaari iraa. Tema eero okameethatzi oteeyiro itajorentsi-takahaetani-paeni, eero okyahae tajorentsi-thaanteki, roojatzi iyomaatan-takyaawori kiteejeri omaerinta. ");
INSERT INTO cpy_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Roorika otzimakiri tsinani eentsiti, ipinkaetiro okaate 14 kiteejeri. Ari oshiyaawo ipinkae-tziro aririka oñaawentyaa roori. Tema otzimatyee omaerentyaa okaate 66 kiteejeri, roojatzi iyomaatan-takyaawori kiteejeri omaerinta. ");
INSERT INTO cpy_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Aririka iyomaateero omaeriwentari eentsiti shirampari, roorika tsinani eentsiti, otzimatyee aanakiniri Ompera-tajorentsi-taarewo apaani ipireetari tzimaen-tsiri apaani rojarentsite, ayiniri eejatzi iryaani jamomo, riirika apaani shiro. Riitaki katziyeen-katatsini iyachaarinka itahaetzirira opatzimooki tajorentsi-thaante okantya rariperoe-tanteeyaawori. ");
INSERT INTO cpy_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Riitaki raanakiri Ompera-tajorentsi-taarewo, itaa-kiniri Tajorentsi janta tajorentsi-thaanteki rariperoe-teero tsinani. Ari omonkaatari okaatzi omaeriwentaka roori.’” Rootaki iñaani Tajorentsi iroka. Rootaki ashi tsinani-paeni tzimayi-tatsiri eenchaa-niki shirampari, roorika tsinani. ");
INSERT INTO cpy_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Eerorika imonkaata amanantan-tyaari ipireetari, kantacha amananti apite shiro, eerorika apite iryaani jamomo. Riitaki Ompera-tajorentsi-taarewo matironi raripero-takaan-teero, kiteshire-tanee roori. Tema itaaki apaani raripero-tantee-tyaawori tsinani. Riima itsipa katziyeenka iyachaarinka itaakiri.” ");
INSERT INTO cpy_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ari rapiiteero Tajorentsi iñaanateeri Moisés, tema kamaki apitekiro itomi Aarón okantakaawo rontsirokakawo ijeekira Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Iroka ikantzi Tajorentsi: “¡Moisés! Pikanteri pirentzi Aarón, eero ipiya-piyata ikyee otajorentsi-perotzira tajorentsi-thaante jempe othataka tonta-mawori, ojeekakira neshironka-mentotsi otapawo tajorentsi-naki, ikami-kari. Tema ari noñaaha-kyaari nomenko-ryeen-kataki neshironka-mentotsiki. ");
INSERT INTO cpy_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aririka ikyee Aarón tajorentsi-thaanteki, otzimatyee raanaki apaani ewonkiri waaka ipeyakoe-tantee-yaariri rantakerowa kaaripero-tatsiri. Raanaki eejatzi apaani ipireetari, riitaki katziyeen-katatsini iyachaarinka itaanewo. ");
INSERT INTO cpy_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Ramaeta-kiniri Aarón ewonkiri waaka, riitaki rowamaakiri, itaawen-tyaari ipeyakoe-tantyaanariri rantakerowa kaariperotatsiri, eejatzi ikaatzi jeekatsiri ipankoki. ");
INSERT INTO cpy_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ari raanakiro taa-mentotsi ijaanakiro owaamari-menkiti taapokimentotsi ijeekakira Tajorentsi. Apite rowii-panetanaki rakoki opane kajankari. Raanakiro otajorentsi-perotzi jempe othataka tonta-mawori. ");
INSERT INTO cpy_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Itaakiro opane kajankari jempe ijeekaki Tajorentsi. Othonkyaa okachaa-tanaki neshironka-mentotsi otapaki tajorentsi-naki. Rootaki eero ikamanta rirori Aarón. ");
INSERT INTO cpy_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Opoñaashitaka raanaki eechaakiini riraa ewonkiri waaka, itsikirijan-takyaawo neshironka-mentotsi ishitowa-piintzira ooryaa, imatakiro eejatzi ikatziyakaha rirori itsikirijakiro neshironka-mentotsi okaate 7 rapiipiintiro. ");
INSERT INTO cpy_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ari rowamaakiri itsipa ipira, riitaki itaawenteetiri rantakirowa kaari-peri atziri-paeni. Raanakiro riraa inthomoeki otajorentsi-perotzira, itsikirijan-tyaawo neshironka-mentotsi eejatzi jantakiroki janta ikatziyakaha. Imatakiro ikimitaantakawo riraa ewonkiri waaka. ");
INSERT INTO cpy_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Rootaki iroopero-tantee-yaari jempe otajorentsi-witaka tema rantawerowaitakiro pisheninka-paeni. Ari ikantakirori eejatzi maawoeni tajorentsi-thaante, ojatekaen-chari ipanko-thaante-yitaka ikaatzi kaaripero-yiteentsiri. ");
INSERT INTO cpy_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Aririka ikyii Aarón jempe otajorentsitaki raripero-takaan-teeri kaaripero-yitatsiri, eero ishinetee-tziri ijeeki itsipa atziri janta tajorentsi-thaanteki, roojatzi ishitowan-teeyaari Aarón. Tema imatakiro ipeya-kotee-takiniri rantakirowa kaariperotatsiri rirori, ikaatzi jeekatsiri ipankoki, eejatzi iyaari-peronka maawoeni isheninka Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ari riyaatanaki ojeekaki taapokimentotsiki omontetakari jempe ijeeki Tajorentsi, itajorentsi-takaero taapokimentotsi. Raakotanaki eechaakiini riraa ewonkiri waaka eejatzi rashi ipireetari, itziritakiro ochee-paeni taapokimentotsi. ");
INSERT INTO cpy_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Itsikirijan-takyaawo iraantsi taapokimentotsi okaate 7 rapiipintiro. Ikiteta-kahaero rowaaripero-waetakiro pisheninka Israel-paeni, itajorentsi-takahaero. ");
INSERT INTO cpy_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Iroka nojankinatani rootaki pikenkishiryaapiin-teeyaari. Aririka omonkaa-teeyaa kiteejeri 10, kashiri 7, otzimatyee pitziwentyaawo, eero pantawaetee. Ari ikantee-yaari pisheninka, eejatzi itsipa-jatzi atziri jeekimo-tzimiri pipankoki. ");
INSERT INTO cpy_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Tema iroka kiteejeri aritaki ipeyakoe-teemiro pantakirowa kaariperotatsiri, ari pikiteshiretee eeroka janta jempe ijeekaki Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Tema ashi owaero nojankina-takaantani, ashi powaero pimako-ryaan-teeyaawo. Pitziwen-teeyaawo eejatzi. ");
INSERT INTO cpy_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ikite-shire-takahaemi Ompera-tajorentsi-taarewo ijeepatzii-toetakiri, poyaata-kariri ipaapati rompera-tajorentsitzi. Riitaki matironi ipeyako-teeri kaari-peroriite. Ikithaa-teeyaawo kyaari-perori ithaari tajorentsi-mawo-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Riitaki riropero-takahaeroni otajorentsi-naki-perotzi eejatzi tajorentsi-thaante. Ari ikanteerori taapokimentotsi antaweroetakiri. Imateeri eejatzi Ompera-tajorentsi-taarewo, eejatzi maawoeni pisheninka-paeni ikaateeyakinira. ");
INSERT INTO cpy_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ashi owaero iroka nojankina-takaantani. Tema apawo-jatzi ojarentsiki ikyahaeti ipeyakoe-tantyaawori rantayitzirowa kaari kameethatatsi Israel-paeni.” Tema imatakiro Moisés okaatzi ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Ikanta Tajorentsi iñaanateeri Moisés, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Iroka otsipa pikantiriri pisheninka Israel-paeni: ‘Ikaati ashitakae-yaarini reenchaaniti tajorentsi-niro iiteetziri “Pinkathari Itaawen-teetziri Eenchaa-niki-paeni”, otzimatyee rowamahaeteri. Okantawityaa riirika Israel-paeni, riirika itsipa-jatzi atsipatari anampiki, rowamahaeteri. ");
INSERT INTO cpy_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Tema ari nokijaneen-teeri naaka irika-paeni, aritaki nothonkaeri inampiki, tema riitaki owaaripero-takirori tajorentsi-thaante, rowinkatharyaakiro nowaero, okantakaan-tziro rashita-kaakari reenchaa-nikiti tajorentsi-niro iitachari ‘Pinkathari Itaawen-teetziri Eenchaa-niki-paeni’. ");
INSERT INTO cpy_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Aririka ipiyatha-takyaa itsipa-paeni pisheninka eerorika rowamayiri ikaatzi ashitakaa-kariri reenchaanikiti tajorentsi-niro iiteetziri ‘Pinkathari Itaawen-teetziri Eenchaa-niki-paeni’, ");
INSERT INTO cpy_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ari nokijaneen-teeri naaka, ari nokanteeri maawoeni isheninka-paeni rirori. Ari nothonkaeri notsipa-taanteeyaari ikaatzi aapatziya-kariri ikaariperotakira, ipinkatha-waetashi-takari tajorentsi-niro iiteetziri ‘Pinkathari Itaawen-teetziri Eenchaa-niki-paeni’. ");
INSERT INTO cpy_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Atziri-paeni ikaati awentee-yaarini sheripiyari-paeni, eejatzi yotantaniri-paeni, kaariperotaki rirori rawentaakarira. Tema nokijaneentakiri naaka irika atziri, aritaki nothonkaeri inampiki. ");
INSERT INTO cpy_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Pikameetha-shire-yitee, pikiteshireyitee, tema naaka Pitajorentsi-tetari. ");
INSERT INTO cpy_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Pikemijan-teero maawoeni noñaani, pantayi-teero eeroka. Tema naaka Tajorentsi, kiteshire-takaemiri. ");
INSERT INTO cpy_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Ikaati yakaterini ipaapati eejatzi riniro, otzimatyee rowamahaeteri. Tema okantakaan-tziro riyakatakiri ipaapate eejatzi riniro, rootaki rowamaan-teetyaariri. ");
INSERT INTO cpy_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Ikaati mayempi-tironi tsinaninentsi, otzimatyee rowamahaeteri apitekiro, tsinani eejatzi shirampari. ");
INSERT INTO cpy_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Okanta apiteta-tsiri ojarentsi ishitowan-taari Israel-paeni Apitantoniki, rootaki etawori kiteejeri, apiteta-tsiri kashiri ithonkan-teeta-kawori tajorentsi-thaante. Janta Cheentoniki, ari rapiiteero Tajorentsi iñaanateeri Moisés tajorentsi-thaanteki, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“¡Moisés! Pithonkiri pojankina-takoteri maawoeni pisheninka-paeni, maawoeni jempe ikaatzi isheninka-tawakaa, eejatzi iwaejatzite-paeni. Tema rojankina-takotatyeeya apaani-paeni iwaero maawoeni shirampari-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Petana-kyaari pojankina-takoteri kaaten-tsiri 20 rojarentsite, pithonkeri maawoeni. Pinashi-yitakyaari eeroka pojankina-takotiri matironi rowayirityaa. Pikanteri Aarón ramitakotimi.” ");
INSERT INTO cpy_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Ikanta Tajorentsi iñaanateeri Moisés, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Potyaanti aminaki-tironi kepatsi Owinteniki, tema rootaki nashita-kaeyaariri pisheninka Israel-paeni. Piyoshiiti apaani pikaatzi pisheninka-tawakaeyani, riitaki jewaripaeni potyaantayite”. ");
INSERT INTO cpy_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Imatakiro Moisés ikantakiriri Tajorentsi, rotyaan-takiri ikaatzi riyoshii-takiri, ipoñaanakawo ochempi-mashiki Moontaawoki. Tema riitaki jeewarite Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Iroka iwaero-paeni ikaatzi riyoshii-takiri: Raminakiri ikaateeyini icharini-paeni Rubén, riyoshii-takiri Samúa, itomi Zacur. ");
INSERT INTO cpy_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Raminakiri ikaateeyini icharini-paeni Simeón, riyoshii-takiri Safat, itomi Horí. ");
INSERT INTO cpy_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Raminakiri ikaateeyini icharini-paeni Judá, riyoshii-takiri Caleb, itomi Jefone. ");
INSERT INTO cpy_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Raminakiri ikaateeyini icharini-paeni Isacar, riyoshii-takiri Igal, itomi José. ");
INSERT INTO cpy_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Raminakiri ikaateeyini icharini-paeni Efraín, riyoshii-takiri Oseas, itomi Nun. ");
INSERT INTO cpy_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Raminakiri ikaateeyini icharini-paeni Benjamín, riyoshii-takiri Palti, itomi Rafú. ");
INSERT INTO cpy_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Raminakiri ikaateeyini icharini-paeni Zabulón, riyoshii-takiri Gadiel, itomi Sodi. ");
INSERT INTO cpy_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Raminakiri ikaateeyini icharini-paeni José (eejatzi Manasés), riyoshii-takiri Gadi, itomi Susi. ");
INSERT INTO cpy_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Raminakiri ikaateeyini icharini-paeni Dan, riyoshii-takiri Amiel, itomi Gemali. ");
INSERT INTO cpy_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Raminakiri ikaateeyini icharini-paeni Aser, riyoshii-takiri Setur, itomi Micael. ");
INSERT INTO cpy_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Raminakiri ikaateeyini icharini-paeni Neftalí, riyoshii-takiri Nahbí, itomi Vapsi. ");
INSERT INTO cpy_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Raminakiri ikaateeyini icharini-paeni Gad, riyoshii-takiri Geuel, itomi Maqui. ");
INSERT INTO cpy_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Rootaki iwaero-paeni ikaatzi rotyaan-takiri Moisés raminakitiro kepatsi. Riima Oseas, itomi Nun, rowaeniri otsipa iwaero, iiteeri Josué. ");
INSERT INTO cpy_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Rotyaan-teeya-kirini Moisés raminakitiro kepatsi Owinteniki. Ikantawakiri: “Piyaateeyini pikinanaki katonkonta Piryaariniki, pitonkaero janta ochempi-mashi. ");
INSERT INTO cpy_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Ari paminiro jempe okantawaeta kepatsi. Piñeeri jempe ikantawaeta nampitawori janta, shintsi-rika ikanteeyani, oshekirika ikaatzi. ");
INSERT INTO cpy_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Paminiri jempe okanta ipankopaeni, kameetha-rika kepatsi, roopero-rika ipanko, iyoshii-tashita-rika ipanko-sheta. ");
INSERT INTO cpy_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kameetha-rika oshooki pankirentsi, terika okamayitzi. Tzimatsi-rika inchato-paeni. Pitonta-shiretanake, kaari ithaawaetzi. Pamayiteera chochoki okaatzi tzimatsiri janta.” Tema owakira etanaawo okithoki-paetetzi chochoki-paeni imiriteetziri. ");
INSERT INTO cpy_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ari riyaatee-yanakini, ipoñaanaawo Cheentoniki raminiro kepatsi, roojatzi Owaankiiriniki jempe okiishita awotsi jatachari Omana-weniki. ");
INSERT INTO cpy_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ipampitha-tanakiro okatonkotzira Piryaarini, areetee-yakani nampitsiki Ariperotaarini. Ari inampitawori janta Ahimán, Sesai eejatzi Talmai, icharini-paeni Anac. Tema iroka nampitsi Aripero-taarini, rootaki etakawo inampi-teetawo, okaataki 7 ojarentsi, ari rimpoetee inampitaawo Shitowaarini-jatzi Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tema areetee-yakani nijaateniki iiteetziri Monkyaawoni, ari ithatzin-kakotanaki apamonkiro chochoki imiriteetziri. Tema apite ikaawen-takiro inatakotakiro incha-pankeki. Ramae eejatzi okithoki otsipa pankirentsi-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Riitaki iitana-kirori Monkyaawoni irika Israel-paeni, tema ari ithatzinkanakiro apamonkiro chochoki imiriteetziri. ");
INSERT INTO cpy_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Imatakiro raminayi-takiro kepatsi, okaatzi imaakotake 40 kiteejeri ipiyanta-yitaari. ");
INSERT INTO cpy_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Jateeyeeni iñaapaeri Moisés eejatzi Aarón ochempi-mashiki Moontoni janta Tajorentsi-taariniki. Jempe ipiyotee-yakani eejatzi maawoeni isheninka-paeni. Ikamanta-paeri jempe okanta raminaki-tziro, roñaaha-paeri okithoki chochoki tzimatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ikantapaeri: “Nomatakiro nareetakita jempe potyaan-takina. Ari oshookapae osheki pankirentsi, eejatzi ari itzimapae osheki ipireetari. Iroka okithoki pankirentsi okaatzi shookatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Roo kanteencha, antari-pentha-kyaa-paeni ikaatzi nampitawori janta, antawo-paeni inampi, rooperori rowetsika-yitziro ipanko-paeni. Noñaakiri eejatzi janta icharini-paeni Anac. ");
INSERT INTO cpy_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Rooma janta Piryaariniki, ari inampitawori Otenkanaaweni-jatzi. Rooma ochempi-mashiki, ari inampitawo Thaawantaa-rinijatzi, Kayaawenijatzi, eejatzi Ochempi-weni-jatzi. Rooma janta inkaari-thapyaaki eejatzi Pareenkaariniki, ari inampitawori Owinteni-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ari itzinaa-wako-tanaka Caleb, imaeritawaki maawoeni isheninka-paeni ipiyotakiri Moisés, ikantanaki: “¡Aritaki aakiro ironta kepatsi! ¡Aritaki amatakiro ashitee-yaawo!” ");
INSERT INTO cpy_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Roo kanteencha akanaki ikaateeyini riyaatee-yakini janta, ikantzi: “¡Eerowé! Eero otsinampaeri irinta atziri. Maperori ishintsi-yitzi rirori, tema rawijee aakapaeni”. ");
INSERT INTO cpy_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Tema tee ikantapae kameetha Israel-paeni rotyaan-teetakiri raminiro kepatsi, ikantzi: “Osheki okowaenkatzi kepatsi naminaki-tziri, tee okameethatzi. Tema antari-pentha-kyaa-paeni ikanteeyani atziri-paeni ikaatzi noñaaki-tziri janta. ");
INSERT INTO cpy_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ari noñaakiriri eejatzi antari-penthaa-kyaa-paeni atziri, riitaki icharini-paeni Anac. Tee niyomaatari ikatziya, noshiya-matsita-kari naaka tsitsiri iñaakina rirori.” ");
INSERT INTO cpy_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ari ikaemae-yanakini Israel-paeni. Osheki riraawae-teeyakani tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Ari retanaawo ikijima-taneeri Moisés eejatzi Aarón, ikanteeyini: “¡Ari okameetha-witaka akamaeyinimi janta Apitantoniki! ¡Tema okameetha-witaka akamaeyinimi jaka ochempi-mashiki! ");
INSERT INTO cpy_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","¿Iitaka ramanteeri Tajorentsi jaka ithonkaetee owayiritaantsiki, inoshika-nakiro owayiri-paeni aena-paeni eejatzi atomi-paeni? ¿Tema okameethatzi apiyayitee Apitantoniki?” ");
INSERT INTO cpy_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Ari ikanta-wakae-yanakani: “Jame amini itsipa jewateeni. Jame apiyayitee Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ari rotziwerowanaka Moisés eejatzi Aarón ipiyotee-yakanira isheninka-paeni Israel-paeni, roeyotanaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ikanta Josué eejatzi Caleb, jateentsiri raminaki-tziro kepatsi, itzijaa-nakiro iithaari-paeni riyotan-teetyaari osheki okantzimo-shire-tanakari. ");
INSERT INTO cpy_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ikantanakiri maawoeni isheninka-paeni: “¡Omapero okameethataki kepatsi naminaki-tziri! ");
INSERT INTO cpy_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Riirika Tajorentsi nintakaeroni, aritaki ineshironka-takae areetan-tyaari nampitsiki, aakataki ashitee-yaawoni. Tema ari oshookapae osheki pankirentsi, eejatzi ari itzimapae osheki ipireetari. ");
INSERT INTO cpy_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Teemaeta okameethatzi pikijima-waeteri Tajorentsi. Eero pithaawan-tawaetari nampitawori janta, tema eero añaakaa-nakari aakapaeni. Tekatsi piyakowen-tyaarini irikapaeni, tee roshiyee aakapaeni tzimatsi Tajorentsi aminako-wenteeri. ¡Eero pithaawaeyini!” ");
INSERT INTO cpy_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ari ikowaeya-witanakani isheninka-paeni ishemyaan-tyaarimi mapi. Roojatzi okoñaatan-tanakari ishintsinka Tajorentsi tajorentsi-thaanteki, iñaayitakiro maawoeni Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Ari iñaanateeri Tajorentsi irika Moisés, ikanteeri: “¿Jempema okaateka ipakaero rajarii-mawaetana pisheninka-paeni? ¿Jempema okaateka ipakaero itheen-kawaetana noñaaha-yiwitakari kaari iñaapiin-teetzi? ");
INSERT INTO cpy_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ari iñaakiro mantsiyarentsi owamaan-tatsiri, nothonkaeri ikaatee-yakinira. Rooma eeroka, ari noshekya-haemiri picharini-teeyaari, riitaki ñaaperoyitaachani rawijiri ikaateeyinika irika-paeni.” ");
INSERT INTO cpy_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Roo kanteencha rakanaki Moisés ikantanakiri: “¡Tajorentsi! Aritaki ikemako-takiro Apitantoni-jatzi okaate pantiri, tema maawoeni iñaayitakiro paerani pishintsinka paantaariri nosheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Aritaki ikamantakiri rirori ikaatzi nampiyi-tawori kepatsiki. Tema ikemako-teeya-kimini jempe pikantaka paerani pitsipa-takari nosheninka-paeni, pikanta-kaakawo iñaawootimi. ¡Tajorentsi! Eeroka pamankan-takariri menkori, peewatakiri kitejipaeteki, rooma tsireni-paeteki pipaama-takaakiro menkori koñeetyaa-kotakiriri. ");
INSERT INTO cpy_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Aririka pithonkakiri powamaa-yiteri irika, aritaki iñaawae-tanaki atziripaeni ikaatzi kemakota-kimiri, panta-yitakiri, ikante: ");
INSERT INTO cpy_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Piñaa-matsiteri Tajorentsi, eero imatziro rashita-kaeyaari Israel-paeni kepatsi ikashiya-kaakiriri paerani, ithonka-shitakari rowamayiri ochempi-mashiki.’ ");
INSERT INTO cpy_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","¡Tajorentsi! Nokoyi poñaahantiro pishintsinka, pimonkaatiro okaatzi piñaawae-takiri paerani, pikantaki: ");
INSERT INTO cpy_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","¡Naakataki Tajorentsi! Tsinampa-tatsiri, Etako-pero-tanta-niri. Nopeyako-tziniri antayitzirori kaaripero-tatsiri, kinashi-waeyi-tachari. Roo kanteencha, eero namaaki-teeri nowajankiteeri ikaatzi antayitzirori kaari-perori, Ari nothonkaeri nowajankitaa-wenteeri iyaari-peronka ipaapate-teetari-paeni, Itominteetari-paeni, itomi-paeni icharini-teetari-paeni, eejatzi iwaejatzite-paeni, maawoeni. ");
INSERT INTO cpy_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Tema maperori pineshironka-tantzi eeroka, pipeyako-teeniri iyaari-peronka irika. Tema rootaki pantakiri pamantaariri irikapaeni Apitantoniki roojatzi jaka ijeekapaakika.” ");
INSERT INTO cpy_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Ikantanaki Tajorentsi: “Kameethataki. Tema nomatakiro pikowakiri, aritaki naripero-teeri. ");
INSERT INTO cpy_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Roo kanteencha, tema omapero-tatyaa nañii naaka, omapero-tatyaa eejatzi nopamankantawo noshintsinka maawoeni kepatsi. ");
INSERT INTO cpy_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Tema eero itzimae apaani ikaatzi ñaayita-kirori noshintsinka, ikaatzi ñaayita-kirori Apitantoniki kaari iñaapiin-teetzi, okaatzi nantayi-takiri eejatzi ochempi-mashiki. Tema ikaatzi apiipiin-takirori rajarii-matana ochempi-mashiki, kaari kowatsini ikemijan-teero nokanta-witariri, ");
INSERT INTO cpy_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","eero iñaayiteero kepatsi nokashiya-kaakiriri paerani iwaejatzite. Tema ikaatzi ajariima-waetakinari eero itzimae apaani ñaayiteeroni. ");
INSERT INTO cpy_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Riima nonampiri Caleb riitaki ñaahaeroni. Tema riitaki kenkishirya-haenchari kameetha, rawentaa-pero-takina. Rootaki noshine-tantyaariri rirori rareeteeyaa kepatsiki raminaki-tziri ketziroeni. Ari inampitee-yaawo maawoeni icharini-teeyaari rirori. ");
INSERT INTO cpy_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Roo kanteencha, nokoyi pipiyanaki okiteje-taneerika pikinaneero ochempi-mashiki piyaatiro Inkaariki Kityonkaariki. Tema janta taapiki, ari inampitawori Otenkanaaweni-jatzi eejatzi Owinteni-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Eekiro iñaawae-tatzii Tajorentsi iñaanatziri Moisés eejatzi Aarón, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“¿Eekeroma namawetatyeero ikijima-waetanari irikapaeni kaari-peroyi-tatsiri Israel-paeni? Tema nokemakiri ikijima-waetakina. ");
INSERT INTO cpy_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Piyaate pikamanteri pisheninka-paeni, pikantiri: ‘Iroka iñaani Tajorentsi, ikantzi: “Omapero-tatyaa, ari nokanta-kaakyaawo awijimotimi okaatzi nokemakimiri pikantee-yakirini pikami. ");
INSERT INTO cpy_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ithonkyaa ikami ochempi-mashiki maawoeni antariteen-tsiri kaateen-tsiri 20 rojarentsite, ikaatzi jankina-takoteen-chari, ikaatzi kijima-waetakinari eejatzi. Ari romaryaa-chonchoetee ochempiki ikamayitakirika. ");
INSERT INTO cpy_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Riima Caleb itomi Jefone. Eejatzi Josué itomi Nun, riitaki ñaayiteeroni inampitee-yaawo janta. Rooma maawoeni eerokapaeni, tekatsi apaani areetachani kepatsiki nokashiya-kaawi-takimiri pinampi-teeyaawomi. ");
INSERT INTO cpy_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Riima pitomi-paeni poshiya-kaanta-witakari ari inoshika-yitakiri owayiri-paeni, riitaki nareeta-kaayi-teeyaari kepatsiki pimanin-takiri eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Tema ari pomaryaa-chonchoetee eerokapaeni ochempi-mashiki pikamayitee-rika. ");
INSERT INTO cpy_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Tema okaatzi 40 ojarentsi ikina-kina-waeyitee pitomi-paeni janta ochempi-mashiki, raminakowen-teeri ipira-paeni. Riitaki atsipetee-yaawoni okaatzi pipiyatha-waetaka eerokapaeni, roojatzi pithonkan-takyaari pikami eerokapaeni jaka ochempi-mashiki. ");
INSERT INTO cpy_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Tema 40 kitejeri okaatzi paminan-takitawori kepatsi, ari okaate eejatzi 40 ojarentsi patsipe-yitee-yaawo okantakaawo pikaaripero-waetaki: apaani ojarentsi okimitakawo apaani kitejeri. Ari piyoteenari jempe nokanta nowajankitaantzi naaka.” ");
INSERT INTO cpy_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Tema Naaka Tajorentsi, ñaawaetatsi. Aritaki nokanteeriri maawoeni kaari-peroripaeni ikaatzi aapatziya-wakahaen-chari ikijima-waetana. Tema jaka ochempi-mashiki ithonkaeyaa, ari ikamayi-teeri maawoeni.’” ");
INSERT INTO cpy_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Tema iroka awijimo-takiriri ikaatzi rotyaan-takiri Moisés raminakitiro jempe okantawaeta kepatsi, ipiyayitaaha rirori ramaero kaari-perori ñaantsi, rootaki opoñaan-tanakari Israel-paeni ikijima-waetanakiri Moisés, imaninta-nakiro kepatsi, tee ikoyi riyaateero janta. ");
INSERT INTO cpy_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Rootaki rowamaan-takariri Tajorentsi irika-paeni omatanakiri mantsiyarentsi, okantakaan-tziro rowanaashitakawo ikenkitha-takota-paero kepatsi jempe okanta iñaakitziro. ");
INSERT INTO cpy_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Riima Josué itomi Nun eejatzi Caleb itomi Jefone, tee ikamaeyini rirori. Apatziro ikamaeyakini itsipa ikaatzi riyaataki raminiro jempe okantawaeta kepatsi. ");
INSERT INTO cpy_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ikamantakiri Moisés maawoeni Israel-paeni okaatzi awijeen-tsiri. Tema antawo rowashire-teeya-nakani maawoeni Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Okanta okiteje-tamanee, itonkae-yanakini ochempiki, ikanteeyini: “Nantakiro kaari-perori, nokoyi niyaateeyini tonkaariki ikashiya-kaakaeri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ikantzi Moisés: “¿Iitaka pipiya-thatantyaawori ikantakaantani Tajorentsi? Tema eero okameethatzi oetarika panta-wityaari. ");
INSERT INTO cpy_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Eero piyaatzi, tema tee itsipateemi Tajorentsi. Paamawentyaa imatawakimi-kari powayiri-minthatani. ");
INSERT INTO cpy_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ari pitonkiyo-takyaari janta Otenkanaaweni-jatzi eejatzi Owinteni-jatzi, ithonkimi-kari rowayiri-timi. Tema eero itsipatzimi Tajorentsi janta, okantakaantziro pipiyatha-takari eerokapaeni.” ");
INSERT INTO cpy_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Teemaeta ikemi irikapaeni, ikoyi itonkaero ochempi. Riima Moisés eejatzi itajorentsi-mokote Tajorentsi, roojatzi ijeekaki jempe ipanko-thaante-teeyakani. ");
INSERT INTO cpy_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ari roerinkae-yakani Otenkanaaweni-jatzi eejatzi Owinteni-jatzi nampiyi-tawori tonkaariki, tema osheki ikentapaaki, romishiyakiri itsipapaeni. Ipatzima-tanakiri roojatzi janta Oshireshaariniki. ");
INSERT INTO cpy_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ikanta rawijee-yakini Israel-paeni ipoñaanaawo Ochempii-toniki ikinaneero Inkaariki Kityonkaariki. Itapota-naakyaawo eero ikinantanaa iipatsiteki Kiraani-jatzi. Ikanta niyanki-thaki awotsi, ari okantzi-moneen-tapaakari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ari retanaawo itheenki-mataneeri Tajorentsi eejatzi Moisés. Ikanteeyini: “¿Iita pamanta-waetanari nojeekawita Apitantoniki? ¿Rooma pamantanari powamayina ochempi-mashiki? Tekatsi nomiriteeri eejatzi nowaeyaari. ¡Neshitapaakiro okaatzi nowapiin-takari!” ");
INSERT INTO cpy_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ari rotyaantaki Tajorentsi osheki kepiyari maanki, ratsika-paakiri. Tema osheki Israel-paeni kamaentsiri. ");
INSERT INTO cpy_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Riyaatee-yakini ijeekira Moisés, ikantapaakiri: “¡Moisés! Nokaaripero-tzimotakiri Tajorentsi, okantakaawo notheenki-mawae-takiri eejatzi nokimitakimi eeroka. Pikanteeri ipeyeeri maanki, tee nokoyi noñeeri.” Ari ramanako-taari Moisés maawoeni isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Ari ikantzi Tajorentsi: “Powetsiki roshiya-kaawo kepiyari maanki, powatzika-kotiri jenoki. Aririka ratsikanti maanki, raminiri roshiya-kaawo rowatzika-koetakirira, aritaki rawijakotee.” ");
INSERT INTO cpy_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Raaki Moisés eshiro kiterita-tsiri rowetsikaki roshiya-kaawo maanki, rowatzika-kotakiri. Ikanta ratsikayitziri maanki, ramineero owatzika-kotakaha roshiya-kaawo, awijakotanee. ");
INSERT INTO cpy_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Ikanta rawijee-yakini Israel-paeni, ipanko-thaante-teeya-paani Mashinchaariniki. ");
INSERT INTO cpy_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Okanta paata rotyaantaki Israel-paeni jatatsini iñiiri iwinkatharite Ochempi-weni-jatzi, iitachari Sehón, ikantiri: ");
INSERT INTO cpy_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“¡Pinkatharí! Ari piñaayi-tawakina nokinee-yapaakini pipatsiteki. Tee roo nopokashiti piwankiri-paeni, pichochokite-paeni, eero nomiriyitziro eejatzi pikeekanatakotzirowa pinijaate-paeni. Apatziro nopampi-thatakiro ojaawokitakira awotsi, roojatzi nawijan-tanakyaari jempe iweyaa piipatsite.” ");
INSERT INTO cpy_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Teemaeta ikoyi pinkathari Sehón ikinimoteri Israel-paeni iipatsiteki. Ipiyota-nakiri rowayirite, jataki rowayiri-tawakyaari Israel-paeni ochempi-mashiki. Itonkiyo-takari Aatzikaetoniki, ari rowayiri-teetakari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Ikanta ipiyawen-tanaka Israel-paeni, ithonka-nakiri ithatyaanakiri rowayiriti Sehón. Rayitakiri maawoeni jempe iweyaayita iipatsite. Opoñaanakawo Kameñaariniki roojatzi Jakochaawoniki. Areetakawo iweyaa-thapita iipatsiteki ñaaperoripaeni Pityaankaarini-jatzi. ");
INSERT INTO cpy_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Ari okanta raanta-kawori Israel-paeni maawoeni inampipaeniki Ochempi-weni-jatzi. Inampitakawo otzinkami inampipaeniki iiteetziri Kaaweni, tema ithonkakiro inampiyi-tantakawo oryaani-paeni nampitsi jeekatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Awijeeya-nakini Israel-paeni, ipanko-thaante-teeya-paani owinteni-pathatzi iipatsiteki Athataa-weni-jatzi, othapyaaki Pareenkathapyaariki, imonteta-paakawo Kashiryaari. ");
INSERT INTO cpy_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Tema iñaakiro Balac, itomi Zipor, jempe ikanta Israel-paeni ithonkan-takariri Ochempi-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Antawo ithaawanaki Athataa-weni-jatzi ithaawantari Israel-paeni, tema owanaa ishenitaki Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Ari ikenkitha-waetakaa-nakiri Athataa-weni-jatzi rantariperoti-paeni Kosheka-weni-jatzi, ikantziri: “Ari ithonki-takaero aepatsite irika atziri-paeni, roshiyaari waaka ithonkiro rowawo katawoshi.” Tema irika Balac itomi Zipor, riitaki iwinkatharite Athataa-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Rotyaantaki jatatsini iñiiri Balaam itomi Beor, nampitawori Ñaawyaweniki Antawaathaapyaaniki iipatsiteki Sheninkaweni, ikanteri: “Ikyaaki anampiki atziri-paeni shitowaa-tsiri Apitantoniki, tema ithonka ipeyapaakiro aepatsite, imonteta-paakawo nonampi ipanko-thaante-yitapaaka. ");
INSERT INTO cpy_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Pipokanaki intsipaete, pitakijiri irika-paeni atziri, omapero-tatziiri otzimi ishintsinka, rawijakina naaka-paeni. Okanta-shitzi-maetya nomishitowayiri naaka noepatsiteki, aririka nowayiri-takyaari. Roo kanteencha, niyotzi naaka ikaatzi pitajonka-wentziri eeroka, aritaki omatakyaa. Riima ikaatzi pitakija-yitziri eeroka, aritaki omatakyaa.” ");
INSERT INTO cpy_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Jatanaki antaripero-paeni Athataa-weni-jatzi, eejatzi antaripero-paeni Kosheka-weni-jatzi raayitanaki ipinateriri ñaawyaatan-taniri. Areetee-yakani ijeekira Balaam, ikamanta-paakiri ikantawa-kiriri Balac. ");
INSERT INTO cpy_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Ari ikantzi Balaam: “¡Ari! Inkaamani nokantimi oetarika ikantinari Tajorentsi. Ari pimaanaki.” Ari imahaeya-paakini inampina-paeni Athataa-weni-jatzi ipankoki Balaam. ");
INSERT INTO cpy_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Ari roñaahakari Tajorentsi irika Balaam, rojampi-takiri, ikantziri: “¿Iitaka pitsipa-yitakari pipankoki?” ");
INSERT INTO cpy_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Rakanaki Balaam, ikantzi: “Rotyaantanewopaeni Balac itomi Zipor, iwinkatharite Athataa-weni-jatzi, ipokatzii, ikantana: ");
INSERT INTO cpy_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Irika-paeni atziriite shitowaa-tsiri Apitantoniki ikyaaki anampiki ithonka ipamankapaakiro aepatsiteki. Pipokanaki intsipaete, pitakijiri irika-paeni. Okantashitzimaetya nomishitowayiri naaka noepatsiteki, aririka nowayiri-tyaari.’” ");
INSERT INTO cpy_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Ari ikantzi Tajorentsi: “¡Balaam! Eero poyaatziri pokaentsiri. Eero piyaka-waetziri irikapaeni, notajonka-wentani naaka irika-paeni.” ");
INSERT INTO cpy_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Okanta okiteeje-taneera ikantakiri Balaam inampina-paeni Balac: “¡Ayompari! Pipiyi pinampiki, tee ikoyi Tajorentsi noyaata-nakimi.” ");
INSERT INTO cpy_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ari ipiyanaawo inampina-paeni Athataa-weni-jatzi inampiki jempe ijeeki Balac, ikantapaeri: “¡Pinkathari! Tee ikoyi royaatina Balaam.” ");
INSERT INTO cpy_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Rapiitakiro Balac rotyaantzi itsipa inampina-paeni, osheki ikaatee-yakini, maperori riroperotzi irikapaeni. ");
INSERT INTO cpy_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Riyaatee-yanakini iñeeri Balaam, ikantapaakiri: “¡Ayompari! Pikemiro iñaani nowinkatharite Balac itomi Zipor, ikantzimi: ‘Nokoyi pipoki piñiina. ");
INSERT INTO cpy_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Aritaki nopinatakimi osheki, ari nantakimiro okaatzi pikantinari. Pipoki nimaeka, pitakijiri irika atziri-paeni.’” ");
INSERT INTO cpy_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Rakanakiri Balaam rotyaantani-paeni Balac, ikantziri: “Okantawityaa ipinawomi Balac iwinkathari-pankote jempe ijaakaha koriki, eejatzi ooro, eero nopiyathatari Tajorentsi, eero nawijakaero nantiro ikowakaanari, tee okameethatzi eepichokiini nawijakaero. ");
INSERT INTO cpy_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Roo kanteencha, ari pimaanaki eeroka, noñaawakiro oetarika ikanteenari tsireniriki Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Okanta tsireniriki, roñaahaari Tajorentsi irika Balaam, ikantakiri: “Tema eeroka ipokashi-teeyini irika-paeni atziri raanakimi, poyaata-nakiri. Roo kanteencha otzimatyee pantiro okaatzi nokantimiri naaka.” ");
INSERT INTO cpy_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Okanta ikakita-manee Balaam, rowanki-tanakiniri jeeka-mentotsi ikyaakoetari. Royaata-nakiri inampina-paeni Athataa-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Roo kanteencha antawo ikijanaka Tajorentsi riyaatanaki Balaam. Royaawen-takari awotsiki Ronampiri Tajorentsi ipiyata-wakyaari. Pokaki rirori Balaam kyaakota-kari ipira, itsipatakari apite romperatani. ");
INSERT INTO cpy_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Iñaapaakiri ikyaakoetari Ronampiri Tajorentsi, ikatziyaka awotsiki roteeyakiro iyotsiroshithakite, tempaawi-tanaka ikyaakoetari. Ipajata-nakiri Balaam ikyaakoetari ikoyi opampithatiro awotsi. ");
INSERT INTO cpy_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Rapiitakiro Ronampiri Tajorentsi rotzika-wakiri jempe okaamanchakitzi awotsiki, jempe itanto-teetziro apitekiro onampi-naki. Rootaki awotsi jatachari pankirentsi-mashiki imiriteetziri. ");
INSERT INTO cpy_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ari iñaapaeri eejatzi ikyaakoetari Ronampiri Tajorentsi, otzitanaka tantotsiki, anawyaa-kotakiri iporiki Balaam. Ari rapiita-nakiro ipajatziri ikyaakoetari. ");
INSERT INTO cpy_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Eekiro ishirinkaneen-tanakityaa Ronampiri Tajorentsi okaamanchaki-perotzira awotsi, tekatsi ikini itempae ikyaakoetari, tee imatya ikini rampateki eejatzi rakoperoki. ");
INSERT INTO cpy_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ikanta iñaapaeri ikyaakoetari Ronampiri Tajorentsi, maryaanaka jaawiki. Antawo ikijanaka Balaam, ipajatan-tanakari inchakii. ");
INSERT INTO cpy_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Ikantakaakawo Tajorentsi, ñaawaetanaki ikyaakoetari, okantanakiri Balaam: “¿Jempema nokantzimika naaka pipajawae-tantanari, tema mawa papiitakiro pipajatakina?” ");
INSERT INTO cpy_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Rakanakiro Balaam ipira, ikantziro: “Roo nopajatan-tzimiri pitheenkakina. Ari otzimimi nojataa-mento, nojataa-kimimi.” ");
INSERT INTO cpy_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ari okantzi ikyaakoetari: “¿Tema naaka pipira pikyaakaa-piintari? ¿Arima nokanta-piintzimi pikyaakotana?” Ikantzi Balaam: “Tee.” ");
INSERT INTO cpy_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Ikantakaakawo Tajorentsi iñiiri Balaam ikatziyaka Ronampiri tajorentsi awotsiki roteeyakiro iyotsiro-shithakite. Ari rotziwerowanaka Balaam, roeyootanaka jaawiki ipinkatha-tanakiri. ");
INSERT INTO cpy_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Rojampi-tanakiri Ronampiri Tajorentsi, ikantziri: “¡Balaam! ¿Iitaka pipajawae-tantawori pipira, tema mawa papiitakiro pipajawae-tziro? Tema naaka pokaentsi nopiyatimi, tema kaari-perori pikantzi-motakina noñaakimi. ");
INSERT INTO cpy_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Rootaki pipira ñaapaakina, mawa apiitakiro otempaa-pithatana. Eeromi otempaemi, nowamaa-kimimi eeroka, rooma roori eero nowamaero.” ");
INSERT INTO cpy_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Ari rakanakiri Balaam Ronampiri Tajorentsi, ikantziri: “¡Nokaaripero-tzimotakimi! Tee niyotzi eerokataki otzikanari awotsiki. Roo kanteencha, kaari-pero-rika okantzi-motakimi nantziri, nimaeka nopiyanee.” ");
INSERT INTO cpy_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ikantzi Ronampiri Tajorentsi: “¡Balaam! Poyaata-nakiri rotyaan-teetani-paeni. Roo kanteencha okaatzi nokanta-yitimiri naaka, rootaki piñaawaeteri eeroka.” Rootaki royaatan-tanakariri Balaam inampina-paeni Balac. ");
INSERT INTO cpy_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ikanta ikemaki Balac pokaki Balaam, jatanaki itonkiyo-tawakyaari otzinkamiki inampi Athataa-weni-jatzi, jeekatsiri Kameñaarithapyaaki, jempe iweyaa-thapita iipatsite. ");
INSERT INTO cpy_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Ikantawakiri: “¡Balaam! Notyaantaki chapinki kaemimini. ¿Iitaka kaari pipokanta piñiina? ¿Poshiya-kaatzi eero noemoshirenkawentzimi? ");
INSERT INTO cpy_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Rakanaki Balaam, ikantzi: “¡Pikemi niyompari! Aritaki pokakina noñiimi. Roo kanteencha tee otzimimotana noshintsinka noñaawae-tantyaawori okaatzi nokoyiri naaka. Apatziro noñaawaetiro okaatzi ikoyiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Ikanta Balaam itsipatakari Balac jateeyakini Jaawokiweniki. ");
INSERT INTO cpy_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Ari rowamaa-kaantapaaki Balac ipireetari-paeni. Rotyaantaki rahaeta-nakiniri Balaam eejatzi inampina-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Okanta okiteeje-tamanee, raanakiri Balac iyeemakaantani Balaam janta Inkañaaweriitoniki. Ari raminako-takiro okoñaataki ipanko-thaante-teeyakani Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Ari ikantanaki Balaam: “Powetsikina jaka 7 taapokimentotsi. Powamayina 7 ewonkiri waaka eejatzi 7 itsipa ipireetari.” ");
INSERT INTO cpy_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Imatakiro Balac okaatzi ikantakiriri Balaam. Ari itsipatakari Balac irika Balaam itaakiri apaani ewonkiri waaka, eejatzi apaani ipireetari okaatakira 7 taapokimentotsi. ");
INSERT INTO cpy_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ikantzi Balaam: “¡Pinkatharí! Ari pijeeka-wentawakiri pitaani. Niyaatawakiita naaka, okanta-shimaetya itonkiyo-tena Tajorentsi. Aritaki nokaman-takimi eeroka okaatzi ikantinari.” Jatanaki Balaam ikinakiro okaanki-chempi-takira tonkaari. ");
INSERT INTO cpy_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Ikanta itonkiyo-takari Tajorentsi irika Balaam, ari ikantzi Balaam: “Nokantaki rowetsikaeti 7 taapokimentotsi, notaaki apaani waaka eejatzi apaani ipireetari okaatakira 7 taapokimentotsi.” ");
INSERT INTO cpy_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Ari ikantakaakawo Tajorentsi riyotiro Balaam iñaawaeteri, ikantakiri: “Pipiyi ijeekakira Balac, pikamantiri okaatzi nokanta-kimiri naaka.” ");
INSERT INTO cpy_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Ari ipiyaari Balaam iñaapaeri Balac ijeekawen-tziri itaani, itsipayi-takari inampina-paeni Athataa-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ari iñaawae-tanakiro Balaam riyotahae-takiriri ñaantsi, ikantanaki: Nopoñaakawo Tonkaeroniki ramakina Balac, Nokinapaakiro ochempi-mashiki jempe ishitowa-piintzi ooryaa, ikaemakaan-takina Iwinkatharite Athataa-weni-jatzi, ikantakina: “¡Pipoki, pitakijiri Israel-paeni! ¡Pipoki, piyakateri icharini-paeni Jacob!” ");
INSERT INTO cpy_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","¿Iitaka notakijan-tyaariri naaka kaari ikoyi Tajorentsi itakijeeteri? ¿Iitaka niyakatan-tyaariri naaka kaarira riyakatzi rirori Tajorentsi? ");
INSERT INTO cpy_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tema irika Tajorentsi, tee roshiyari atziri-paeni itheeyan-tyaari, Tee rinashitawo okaatzi ikenkishire-takari. Aririka ikanti: “Iroka nantiri.” Aritaki rantakiro. Imonkaa-tziro maawoeni ikashiya-kaantziri. ");
INSERT INTO cpy_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ikantee-takina naaka notajonka-wentanti. Tema imatakiro Tajorentsi itajonka-wentantaki rirori, eero nomateero naaka noepiya-ñaani-teeri. ");
INSERT INTO cpy_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Tee iñeeteero iyaari-peronka icharini-paeni Jacob, Tee riñeeteero eejatzi ikowaenka-takowaetzi isheninka Israel-paeni. Tema ashi royiro itsipata-piintakari Itajorentsite. Riitaki rajahaa-piintakari iwinkathari-tetaari. ");
INSERT INTO cpy_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Tema irika Tajorentsi, amaeriri ijeekawitaka paerani Apitantoniki, Otzimimo-tziri ishintsinka oshiyaawomi ishintsinka katsi-mari-paeni piratsi. ");
INSERT INTO cpy_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Tekatsi oetzimotyaari icharini-paeni Jacob takijaantsi, Tekatsi oetzimotyaari Israel-paeni yakataantsi. Nimaeka akantiri Israel-paeni: ¡Osheki rantzimota-kimiri Tajorentsi kaari iñaapiin-teetzi! ");
INSERT INTO cpy_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Roshiyakari kashekari irikapaeni, Ikatziya rajaryaanta. Eero romorenka roojatzi ratsikan-takyaariri ratsikanewo. Riranakiro riraa rowamaani-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Ari ikantanaki Balac: “¡Balaam! Teera pinintatyee piyakateri, eero pitajonka-wenteeri eejatzi.” ");
INSERT INTO cpy_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Ikantzi Balaam: “¡Balac! Tema nokantzi-takimi ketziroeni: ‘Okaatzi ikantinari Tajorentsi, rootaki nantiri.’” ");
INSERT INTO cpy_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Ari ijeekae-yapaakini Israel-paeni janta Inchatoniki. Imayempi-waeyi-takiro Athataa-weni-jato. ");
INSERT INTO cpy_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Okaemakiri Israel-paeni itsipatyaawo otayiniri atsipeta-kaani tajorentsi-niro-paeni. Rakiyota-piintakiro Israel-paeni. Ipinkatha-waetakiri otajorentsi-nirote-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Ari okantakari rawentaan-takariri Israel-paeni tajorentsi-niro Inkañaaweri janta Pahaankaetoniki. Rootaki ikijanta-nakariri Tajorentsi irika Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Ari iñaanateeriri Tajorentsi irika Moisés, ikanteeri: “¡Moisés! Pipiyoteri maawoeni reewarite Israel-paeni, pishirika-kentsi-yiteri okiteejita-manee, inteenaryaantee-yaari nomashirenka maawoeni Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ipoñaa ikaemakiri Moisés itsipapaeni reewarite Israel-paeni, ikantakiri: “Powamayiri asheninka-paeni ikaatzi aapatziya-kariri tajorentsi-niro Inkañaaweri jeekatsiri Pahaankaetoniki.” ");
INSERT INTO cpy_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ikanta apaani isheninka Israel-paeni ramaki Kosheka-weni-jato jempe ipiyotee-yakani isheninka-paeni, iñaawakiri Moisés, eejatzi maawoeni Israel-paeni ijeekaeyini riraako-waeteeyani rirori-paeni opatzimooki Tajorentsi-thaante. ");
INSERT INTO cpy_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ikanta iñaawakiri rirori Finees itomi Eleazar icharini Ompera-tajorentsi-taarewo Aarón, ishitowa-shi-tanakiri ipiyotee-yakanira isheninka, raanakiro iyotsiro-shitha-kiti. ");
INSERT INTO cpy_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Riyaata-shitakiri irika isheninka jempe ipanko-thaante-yitaka isheninka-paeni, rojataakiri imotziki apitekiro, shirampari eejatzi tsinani. Aripaete okaatapaaki mantsiyarentsi owamaayi-takiriri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Tema osheki-pero Israel-paeni owamaakiri mantsiyarentsi. ");
INSERT INTO cpy_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Ari iñaanateeri Tajorentsi irika Moisés, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Paanakiri maawoeni Israel-paeni ikijawen-teeyaa, riyaati rowayiri-teeyaari Kosheka-weni-jatzi. Aririka pimatakiro, aripaete pitsipa-shire-yitee-yaari piwaejatzite-paeni.” ");
INSERT INTO cpy_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Ikaemakiri Moisés maawoeni isheninka-paeni, ikantakiri: “Powetsika-yiteeyaa eerokapaeni, piyaati pikijawen-teeyaa powayiri-tyaari Kosheka-weni-jatzi, tema rootaki ikowakiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Imatakiro rowayiritari Kosheka-weni-jatzi, ithonkakiri rowamaakiri maawoeni, imatakiro okaatzi ikantakiriri Tajorentsi irika Moisés. ");
INSERT INTO cpy_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ari ikaatzi rowamaa-nakiri iwinkatharite-paeni Kosheka-weni-jatzi. Irika iitawiteeyani: Evi, Requem, Zur, Hur, Reba. Ikaatzi 5 pinkathari rowamaakiri. Imatzitanakari Balaam itomi Beor rowamaan-tanakari iyotsiro-shitha-kite. ");
INSERT INTO cpy_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Ithonka-nakiro Israel-paeni inoshika-nakiro tsinani-paeni Kosheka-weni-jato, rayita-nakiri reenchee-rikiti. Eejatzi ipira-paeni, iwaakatipaeni, maawoeni rashaahawo-paeni. ");
INSERT INTO cpy_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ari ikantawaeri Moisés isheninka-paeni: “¡Nosheninká! Iitaka kaari powamaantawo iroka-paeni tsinani? ");
INSERT INTO cpy_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Rooyitaki ikaminaani Balaam kantakaan-takirori ikaaripero-tzimotan-takariri asheninka-paeni Tajorentsi janta Pahaankaetoniki. Rootaki rowajankitaan-takariri Tajorentsi asheninka-paeni ikamanta-yitakari.” ");
INSERT INTO cpy_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Iroka ikenkithawae-takaa-kiriri Moisés maawoeni Israel-paeni janta ijeekan-tawitakari ochempiki. Ari janta ojeeki eni Jordán janta ishitowa-piintzira ooryaa. ");
INSERT INTO cpy_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Rootaki iroka ikantakaan-teetziri, inintakaan-teetziri, kaari ishinetaan-teetziri. Rootaki ikanta-kinari Piwinkatharite Tajorentsi okine niyotahaemi. Rootaki ikowakaa-kimiri panteri janta nampitsiki jempe roejeekaemi. ");
INSERT INTO cpy_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Aritaki okantya pipinkathateri Piwinkatharite Tajorentsi. Pimonkaatero ikowa-kaantee-tziri eejatzi ikantakaan-teetani, rootakira panteri maawoeniki ojarentsi, eekirowa pañaatye. Roojatzi noninta-kayita-kariri pitomipaeni, eejatzi picharini-paeni. Rootakira piñaantee-yaawori pañaahae osheki ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","¡Israel-paeni! Rootakira piyaa-takaan-tyaawori pimonkaatero. Ari okantya eero awijimo-tanteemi oetarika-paeni. Aritaki piñahaeri rosheki-pero-tanee asheninka. Ari pinampi-teeyaawo janta kepatsi kameetha-tatsiri. Ari itzima-paeri pitsi, roshiya-paawo oshitowaatzi nijaateni. Tema rootaki iroka ikanta-kimiri Pinkathari, Itajo-rentsite picharinini. ");
INSERT INTO cpy_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","¡Israel-paeni! Pikemi. Irika Awinkatharite Tajorentsi, apaniro ikanta Ipinkatharitzi rirori. ");
INSERT INTO cpy_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Pininta-pero-teeri, pininta-shire-teeri, pininta-shintsi-teeri eejatzi. ");
INSERT INTO cpy_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Pikenki-shireero kameethari maawoeni iroka nokanta-kimiri. ");
INSERT INTO cpy_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Piyaata-kayeri piyoteeri pitomipaeni iroka. Piñaawaetero, pikantzirowa pipankoki, eejatzi awotsiki. Pikantzirowa pomaryaaha, eejatzi pipiriintaha. ");
INSERT INTO cpy_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Poojota-kotyaawo pakoki jankina-takoteen-chari ikowa-kaantee-tziri. Eejatzi poojota-kotyaawo pitamakoki. Rootaki riyotee-tantyaari. ");
INSERT INTO cpy_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","Pojanki-natero eejatzi tzinkamin-tsiki eejatzi ashitawoki pipanko. ");
INSERT INTO cpy_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Pantapiintero ikowa-kaantee-tziri okaatzi nokantzimiri nimaeka. Rootakira pijeekan-teeyaari. Aritaki piñaahaeri rosheki-pero-tanee asheninka. Opoñaan-tyaari roma-nataneero nampitsi ikowakaa-kiriri Pinkathari picharini-paeni. ");
INSERT INTO cpy_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Poshire-tyaawo janta ikina-kinawae-takaan-takimiri-ranki Pinkathari ochempiki okaatzi ojamanitaki 40 ojarentsi. Rootakira rantantawori opoñaan-tyaari itsinampa-shire-takaan-teemiri, rootaki iñaantan-teemiri eejatzi. Tema ikowawitaka riyotero okaatzi pikenkishiryaa-witakari. Ikowawitaka riyotero aririka piyomaa-takiro ikowa-kaantee-tziri. ");
INSERT INTO cpy_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Rowajanki-takaan-tawitakimi, itasheya-neenta-kaawi-takimi. Roo kanteencha rowakaa-kimiro maná. Tema tee piyotako-witawo iroka owanawontsi paerani, tee riyotako-witawo eejatzi picharini-paeni. Ari okantakari riyotakaan-takimirori tee apatziro okoyimotari atziri royaawo pan, rootaki kowapero-tachari akemijan-teero maawoeni ikanteeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Okaatakira iroka 40 ojarentsi, tee pithonka-takota piithaari, tee aawaayitzi piitzi. ");
INSERT INTO cpy_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Otzimatye piyote riitaki Piwinkatharite Tajorentsi tampatzika-takimiri. Ari roshiyari ipaapateetari, itampatzika-tziri itomi. ");
INSERT INTO cpy_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","Ari ikoñaate paata Kamantan-taniri, roshiyina naaka. Riitaki Piwinkatharite Tajorentsi kanta-kahae-yaawoni. Otzimatye pikemijan-teeri. ");
INSERT INTO cpy_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","Rootajaantaki iroka pikowako-takiriri Piwinkatharite Tajorentsi paerani janta ochempiki Horeb. Tema iroka kitejeri paerani papatotan-takari, pikantaki: “Tee akoyiro apiiteero akemaero icherahae Awinkatharite Tajorentsi. Tee akoyiro añahaero eejatzi antawo paamari. Akamaekari.” ");
INSERT INTO cpy_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","Ikanta-nakina Pinkathari, ikantzi: “Kameethataki ikanta-kimiri. ");
INSERT INTO cpy_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","Nokanta-kahae-yaawo ikoñaate Kamantan-tantaniri roshiyimi eeroka, isheninka rirori pichariniteeyaari. Noyiniri noñaane ipaanteki. Ikenkitha-teero okaate nokanteriri. ");
INSERT INTO cpy_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","Nowajan-kiteeri maawoeni kaari kemijan-teerini Kamantan-taniri.” ");
INSERT INTO cpy_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","Rapiiteeri iñaanata-neeri Moisés Israel-paeni, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“Tzimaki 120 nojarentsite, tekatsi noshintsinka nanashi-tantee-yaari. Tema ikantakina Pinkathari eero nomontya-haawo eni Jordán. ");
INSERT INTO cpy_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","Riitaki anashita-kaemini Piwinkatharite Tajorentsi. Riitaki thonkaa-terini atziripaeni jempe pikinee-yanakini, paanteeyaawo iipatsite. Riima Josué, riitaki jewatapaemini, ipinkathari-tapae. Rootaki ikantakiri Pinkathari.” ");
INSERT INTO cpy_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","Roojatzi ikamantaa Moisés, romperatanewo Tajorentsi. Ikamaero iipatsiteki Moab, ininta-kaakiriri Pinkathari. ");
INSERT INTO cpy_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","Ari ikiteetakiri owinteni-patha-tzira Moab, pinkathari-tatsiri Bet-peor, nampitsi kaari riyoteetzi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","Okaataki 125 rojarentsite ikamantakari. Eeniro ikowichaa-tzimaeta kameetha, eejatzi eeniro ishintsitzi. ");
INSERT INTO cpy_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","Ojamanitaki okaatzi 30 kitejeri riraakoe-yakarini Israel-paeni Moisés-ni janta ochempiki Moab. Okanta imonkaa-takiro kitejeri riraako-tanta-kariri kaminkari. ");
INSERT INTO cpy_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","Tekira ikamana-kiita Moisés-ni, rotaiya-patziito-takiri Josué, itomi Nun. Ipaneeri riyomento. Arira ipinkatha-tanakiri Israel-paeni Josué, rantaneero okaatzi ikanta-kiriri Pinkathari Moisés-ni. ");
INSERT INTO cpy_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Tema kamae rirori Moisés, romperatani Tajorentsi. Ari iñaanateeri Tajorentsi irika Josué, itomi Nun, itsipata-piintani Moisés. Ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“¡Josué! Tema kamae nomperatani Moisés. Eeroka montyaakahaeyaarini maawoeni pisheninka-paeni intatsikiro Pareenkaariniki, piyaati janta kepatsiki nashita-kaemiri maawoni eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Naakataki payita-kimirori, tema rootaki nokantzi-takariri paerani Moisés, nokantakiri: ‘Naaka pimironi maawoeni kepatsi jempe-rika pikinayitaki’. ");
INSERT INTO cpy_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","Iroka okaate piipatsite. Opoñaana-kyaawo jaka ochempi-mashiki, Kiteniitoniki roojatzi Antawaaki Enini, maawoeni iipatsite Thaawan-taani-jatzi, roojatzi janta Inkaariki Antawo jempe ikyaapiintzi ooryaa. ");
INSERT INTO cpy_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","Eero itzimae otsinampaemini jempe-rika pijeeka-yitee. Naakataki tsipata-piintimini nokimitaakiri paerani Moisés notsipa-takari. Eero nowapin-teemi, ari nokanteetatyeeyaani notsipa-teemi. ");
INSERT INTO cpy_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Pikyaaryooti, piñaaperotyaa kameetha. Tema eeroka aakahaerini kepatsi maawoeni pisheninka-paeni. Rootaki nokashiya-kaakiriri paerani piwaejatziiteni. ");
INSERT INTO cpy_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Apatziro nokoyi pikyaaryooti, kametha piñaaperotyaa. Pikemijan-taneero noñaani okaatzi riyotaa-kimiri nompera-tanini Moisés. Kijokiro powaero, rootaki okameetha-tzimotan-teemiri okaate panta-yiteeri. ");
INSERT INTO cpy_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Pamepaantetya piñaawae-tapiin-teero jankinarentsi iñaani Tajorentsi, pikinkishiryaa-piintyaawo kiteejeriki eejatzi tsireniriki, rootaki pimatan-teeyaawori pantayi-teero okaatzi jankina-teenchari. Tema rootaki okameetha-tantyaari okaate panta-yiteeri. ");
INSERT INTO cpy_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Naakataki kantzimiri pikyaaryooti, kametha piñaaperotyaa. Eero pithaawawaetzi, eero powashaanta-waeta, tema naaka Pitajorentsite, ashi nowaero notsipa-timi jempe-rika pikinayitee.” ");
INSERT INTO cpy_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Okanta okiteeje-tamanee, ananinkanaka Josué itsipata-naari maawoeni isheninka-paeni rookaneero ijeekawi-tapaaka Inchatoniki, areetee-yakani Pareenkaariniki. Ari imahaeya-paakini tekira imontyaata intatsikiro. ");
INSERT INTO cpy_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Okanta ijeekapaaki mawa kiteejeri, ithotyaakiro reewariti Israel-paeni raminiro maawoeni ipanko-thaanteki-paeni isheninka. ");
INSERT INTO cpy_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Riyotaakiri maawoeni isheninka-paeni, ikantakiri: “Aririka piñaakiri Ompera-tajorentsi-taarewo Leví-paeni inatakotanakiro itajorentsi-mokote Tajorentsi, rashaata-kaero, piyaateeyini eerokapaeni, poyaata-nakiri. ");
INSERT INTO cpy_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Okini piñiiro jempe pikineeyini, tema tee pikineeyini paerani eerokapaeni jaka. Eeromaeta pokaakitawo tajorentsi-moko, inteena pimpoeteeyini eerokapaeni.” ");
INSERT INTO cpy_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Ari ikantanakiri Josué isheninka-paeni: “¡Powetsika-shire-teeyaani maawoeni, tema okiteeje-tamanee roñaayimiro Tajorentsi kaari piñaapiintzi!” ");
INSERT INTO cpy_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Ikantakiri eejatzi Ompera-tajorentsi-taarewo-paeni: “Paanakiro tajorentsi-moko, peewateri maawoeni asheninka-paeni pashaateeyini.” Raanakiro Ompera-tajorentsi-taarewo-paeni tajorentsi-moko, reewata-nakiri maawoeni isheninka-paeni ashaatee-yanakani. ");
INSERT INTO cpy_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Iñaanata-nakiri Tajorentsi irika Josué, ikantziri: “Nimaeka nokanta-kaeyaawo iñiimi pisheninka-paeni riiperori eeroka. Rootaki riyotan-tyaari ari notsipa-tzimi naaka nokimitziri paerani Moisés notsipa-takari. ");
INSERT INTO cpy_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","¡Josué! Pikantiri eeroka Ompera-tajorentsi-taarewo-paeni natakirori tajorentsi-moko, pikanteri: ‘Aririka paatzikaa-paakiro nijaa Pareenkaarini, ari paatzinkae-yapaakini.’” ");
INSERT INTO cpy_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Imatakiro Josué, ikantakiri isheninka-paeni: “¡Nosheninkapaení! Pipokaeyini maawoeni, pikemi ikantzi Atajorentsite. ");
INSERT INTO cpy_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Rootaki piyotan-tyaari ari itsipatzimi eerokapaeni Tajorentsi Kañaaniri, aritaki piñaayi-teeri ithonkaeri Owinteni-jatzi, Thaawan-taarini-jatzi, Thaanteweni-jatzi, Nampitsi-weni-jatzi, Pitzitharini-jatzi, Ochempi-weni-jatzi eejatzi Kaya-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","Ari piñaayi-takiro rashaata-kaetiro Pareenkaariniki itajorentsi-mokote Pinkatha-wentzirori maawoeni kepatsi. ");
INSERT INTO cpy_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Piyoshiiti ikaati 12 asheninka, paayiti apaani-paeni akaatzi asheninka-tawakahaeyani. ");
INSERT INTO cpy_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Tema aririka rashetanaki iitziki-paeni Ompera-tajorentsi-taarewo natakirori itajorentsi-mokote Pinkatha-wentzirori maawoeni kepatsi, ari opiryaa-tanaki Pareenkaarini. Eero oshiyaa-tanaa nijaa, antawo oonkanakyaa katonko.” ");
INSERT INTO cpy_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Ikanta ishitowae-yanakini Israel-paeni ipanko-thaanteki rashaatyaawo Pareenkaarini, eewatee-yakini Ompera-tajorentsi-taarewo inatakotakiro tajorentsi-moko. ");
INSERT INTO cpy_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ikanta raatzikaata-paakiro nijaa Ompera-tajorentsi-taarewo natakotakirori tajorentsi-moko, asheyitanaki iitziki-paeni. Tema eeniro okemaatzi Pareenkaarini rowiitan-teetawori okithoki pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","Rootaki oonkanta-nakari katonkonta, antawo otapyaatanaka nijaa areetaka Potsitaariki ojeeka-nampi-tziri Kemaatsi-taariki. Rooma kirinkanta Mameriweniki omontetari Inkaari Mirityaawo, piryaatanaki. Ari ikineeya-nakini Israel-paeni riyaateeyeni intatsikiro Kashiryaariki. ");
INSERT INTO cpy_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","Riima Ompera-tajorentsi-taarewo natakotakirori itajorentsi-mokote Tajorentsi, roojatzi ikatziyee-yakani opiryaa-tanakira Pareenkaarini. Roojatzi imontyaan-tanakari maawoeni Israel-paeni opiryaa-tanakira Pareenkaarini. ");
INSERT INTO cpy_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Tekatsi mateeroni ikyahae Kashiryaariki, tekatsi eejatzi mateeroni ishitowae, tema rashita-peroe-tanakiro iroka nampitsika, okantya ipiyawentyaa aririka rowayiri-tapaa-kyaari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Roo kanteencha iñaanateeri Tajorentsi irika Josué, ikanteeri: “¡Josué! Noshine-takimiri pithonkiri Kashiryaari-jatzi, iwinkathariti eejatzi rowayiriti-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Pitapotiro nampitsi pitsipa-tanakyaari pisheninka-paeni owayirita-chani, apawo-jatzi pitapotiro kiteejeriki. Tema okaate 6 kiteejeri pitapotyaawo. ");
INSERT INTO cpy_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Reewati 7 Ompera-tajorentsi-taarewo roteeya-yitaki iwaakapatipaeni itziwootan-tyaari. Royaatee-yaapaakiniri ompera-tajorentsi-taarewo natakotakirori tajorentsi-moko. Aririka omonkaa-takyaa 7 kiteejeri, 7 papiitiro pitapotiro nampitsi. Itziwootee-yanakini Ompera-tajorentsi-taarewo rirori. ");
INSERT INTO cpy_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Aririka pikemawakiro ijantheen-katanaki iyameninka tziwoorentsi, picheraanaki pikaemaeyini. Aritaki otzimpookanaki otantotari Kashiryaari. Ari pikyahaeyini janta.” ");
INSERT INTO cpy_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Ikaemakiri Josué Ompera-tajorentsi-taarewo, ikantakiri: “Paanakiro itajorentsi-mokote Tajorentsi. Reewati 7 Ompera-tajorentsi-taarewo roteeya-yitaki iwaakapatipaeni itziwootan-tyaari. Royaa-teeya-paakirini Ompera-tajorentsi-taarewo natakotakirori tajorentsi-moko.” ");
INSERT INTO cpy_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Riyotaakiri isheninka-paeni, ikantziri: “Piyaateeyini, panashitiro Kashiryaari, pitapotiro. Riima ikaati owayirita-chani riitaki jewatironi itajorentsi-mokote Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Rantakiro Israel-paeni okaatzi ikantakiriri Josué. Jewatanaki 7 Ompera-tajorentsi-taarewo, itziwooteeyini. Pokakotatsi itajorentsi-mokote Tajorentsi itaapiiki. ");
INSERT INTO cpy_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Jewataki ikaati owayirita-chani, pokaeya-tsini itaapiiki Ompera-tajorentsi-taarewo. Eenitatsi itsipa owayiri-paeni impoeta-tsiri royaata-kowen-tziro itajorentsi-mokote Tajorentsi. Tee ipakaa-neenta tziwoorentsi. ");
INSERT INTO cpy_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Tema riyotaa-yitakiri Josué isheninkapaeni, ikantakiri: “Eentsikiroeni panashi-teeyini, roojatzi nokantan-takimiri: ‘¡Picherayi pikaemaeyini!’ Aripaete pikaemaeyini” ");
INSERT INTO cpy_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Imatakiro itapotee-yawoni nampitsi inatakotee-yakironi itajorentsi-mokote Tajorentsi. Ari ipiyeeyaani ipanko-thaanteki, roojatzi otsipaki kiteejeri. ");
INSERT INTO cpy_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Ikanta ipiriin-tamanaa Josué, raaneero Ompera-tajorentsi-taarewo-paeni itajorentsi-mokote Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","Jewatanai 7 Ompera-tajorentsi-taarewo, pokakotatsi itajorentsi-mokote Tajorentsi itaapiiki. Tee imako-ryaapaentzi ranashi-teeyini, roetziñaariko-takawo itziwooteeyini. Jewatatsi ikaati owayirita-chani. Eenitatsi itsipa owayiri-paeni impoeta-tsiri royaata-kowen-tziro itajorentsi-mokote Tajorentsi. Tema roojatzi ikameñeenkataki tziwoorentsi. ");
INSERT INTO cpy_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Ari rapiitakiro itapotawo nampitsi Kashiryaari, rootaki apiteta-tsiri kiteejeri. Ari ipiyeeyaani ipanko-thaanteki. Ari ikantapiin-takiro okaatzi 6 kiteejeri rapiitakiro itapotakawo. ");
INSERT INTO cpy_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Okanta 7-tatsiri kiteejeri, ananinkae-yanakini itapotawo nampitsi, ikimita-piintzirowa. Iroka kiteejeri, 7 rapiitakiro itapotziro nampitsi. ");
INSERT INTO cpy_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Okanta 7-tatsiri itziwootaki Ompera-tajorentsi-taarewo-paeni, ikaemako-tanakiri Josué isheninka-paeni, ikantziri: “¡Pcherayi pikaemaeyini! ¡Tema ishineta-kimiri Tajorentsi ikaatzi nampitawori jaka!” ");
INSERT INTO cpy_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Ari icheraanaki ikaemae-yanakini owayirita-chani, tziwootanaki Ompera-tajorentsi-taarewo-paeni. Ikanta ikemawakiri maawoeni isheninka-paeni ipoema-tanaki tziwoorentsi, cheraa-naki ikaemaeyanakini, rootaki otzimpookan-tanakari otantotari nampitsi Kashiryaari. Tampatzika rowanakiro ikyahae-yanakini nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Ithonkanakiri rowamaantanakari iyotsiroshithakite maawoeni shirampari, tsinani, ewankari, antariki-paeni, imatanakiri ipira-paeni, maawoeni. Ari ikaatzi ithonkakiri rowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Tema ikemakoe-tanakiri Josué maawoeniki janta, tema riitaki Tajorentsi tsipata-kariri. ");
INSERT INTO cpy_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","Ari iñaanateeri Tajorentsi irika Josué, ikanteeri: “Kameetha piñaaperotyaa, eero pithaawa-waetzi. Paaneeri pisheninka-paeni ikaati owayirita-chani, piyaati powayiri-tyaari Tzimpookaarini-jatzi, naaka kantakae-yaawoni potsinampaeri iwinkatharite, pithonkiri maawoeni. Eeroka ashitee-yaawoni inampi eejatzi iipatsite. ");
INSERT INTO cpy_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","Tema ari pimatakiri Tzimpookaa-rini-jatzi eejatzi iwinkatharite pikimitaakiri Kashiryaarini-jatzi eejatzi iwinkatharite. Noshine-takimi nimaeka payiro okaatzi tzimimo-tziriri, payiri eejatzi ikaatzi ipirayitari. Powetsikyaa, okantya pomapokiri pikinashi-takiri itaapiiki.” ");
INSERT INTO cpy_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","Ari rowetsikanakari Josué eejatzi isheninka-paeni jatatsini rowayiri-tyaari Tzimpookaarini-jatzi. Riyoshiitaki ikaatzi 30,000 ñaaperori isheninka-paeni, rotyaan-takiri tsireni-paetiki. ");
INSERT INTO cpy_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","Ikantawakiri: “Itaapiiki pikinashi-takiri, pomanee-yakyaani okaakiini. Powetsika-paakyaa powayiritantyaari. ");
INSERT INTO cpy_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","Riima itsipa asheninka owayirita-chani royaatina naaka niyaati nampitsiki. Aririka ishitowanaki ikoyi romanata-wakina, ari noshiya-pitha-tana-kyaari, akimiteero chapinki. ");
INSERT INTO cpy_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","Aririka ipatzima-tanakina Tzimpookaarini-jatzi, rookanakiro inteena inampi, ikanteeyini: “Ishiya-pitha-tatyee irikapaeni ikimiteero chapinki.” Roshiyakaa-mintheetzi noshiya-pitha-tatyeerimi naakapaeni. ");
INSERT INTO cpy_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","Roojatzi pishitowan-tanakyaari eeroka-paeni jempe pomanee-yakani, pikee-yapaakini inampiki. Tema ishineta-kaeri Tajorentsi owayiri-tyaari irikapaeni. ");
INSERT INTO cpy_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","Aririka pikyaaki inampiki, pitayiro. Pimatiro ikantakaeri Tajorentsi. Rootaki ikoyiri rirori.” ");
INSERT INTO cpy_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","Imatakiro Josué rotyaan-takiri owayirita-chani. Ikineeyakini isheninka-paeni ikyaapiintzira ooryaa, omaneeyakani niyanki-thaki awotsi poñaachari Tajorentsi-pankoniki roojatzi Tzimpookaa-riniki. Riima Josué, tee riyaatzi rirori, eejatzi imaanee ipanko-thaanteki. ");
INSERT INTO cpy_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","Okanta okiteeje-tamanee, ananinkanaka Josué raminiri isheninka-paeni, ikaati owayirityaarini Tzimpookaarini-jatzi. Ipiyotakiri maawoeni isheninka-paeni, eejatzi antari-pero-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","Ari itonkahae-yanakini owayirita-chani ikaatzi itsipata-nakari Josué. Tema imonteta-paakawo nampitsi Tzimpookaarini, ari ipanko-thaante-yitapaaka okatonkotzira nampitsi. ");
INSERT INTO cpy_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","Rotyaantaki 5,000 isheninka owayirita-chani ikyaapiintzira ooryaa, maneeyapaakani niyanki-thaki awotsi poñaachari Tajorentsi-pankoniki roojatzi Tzimpookaariniki. ");
INSERT INTO cpy_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","Iroka ikanta rinashiyitakari roojeekakiri isheninka-paeni Josué: Eenitatsi apaani-paeni manayiteenchari owayirita-chani ikyaapiintzira ooryaa. Riima itsipa-paeni ipanko-thaante-yitaka okatonkotzira nampitsiki. Roojatzi reewatan-tanakari Josué tsireni-paeteki janta otenka-naaki. ");
INSERT INTO cpy_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","Ikanta riyotaki pinkathari-tatsiri Tzimpookaariniki, intsipaete ikaemanakiri rowayirite-paeni, rananinkae-yanakini, tema ari ikamanta-wakahae-yakani jempe rowayiri-tantyaa. Ari ikaatzi raanakiri rowayiriti ipiyata-wakyaari Israel-paeni riweyaa-paaka intatsikiro Mameriweniki. Tee riyotee-yini manee-yapaakani itsipa Israel-paeni nampitsiki ikinapaakironta. ");
INSERT INTO cpy_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","Ikanta Josué itsipatakari rowayiriti, ikimiwitaka ithaawa-nakityeemi, ishiya-pitha-tanakari Tzimpookaarini-jatzi ikineeya-nakini ochempi-mashiki. ");
INSERT INTO cpy_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","Ari ikaemako-takiri rowayirite-paeni iwinkatharite Tzimpookaarini-jatzi, ikantziri: “¡Pipatzimateri!” Ikanta ipatzimae-tanakiri Josué, rookanakiro inteena inampi. ");
INSERT INTO cpy_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","Tekatsi apaani owayiri jeekaneen-tsini kijako-wentyaarini Tzimpookaarini-jatzi eejatzi Tajorentsi-pankoni-jatzi, tema ithonka riyaatanaki rowayiriti ipatzima-tanakiri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","Ari rapiitakiro Tajorentsi iñaanatziri Josué, ikantziri: “Powaankiro piyotsiro-shitha-kiti pookotan-tyaawo Tzimpookaarini, tema noshine-takimiri naaka pithonkiri.” Rowaanka-nakiro Josué iyotsiro-shitha-kiti roteeyakiri, rookotan-takawo nampitsi. ");
INSERT INTO cpy_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","Romapoka-shitanaka ishitowae-yanakini owayiri-paeni ikaatzi omaneen-chari, jatanaki Tzimpookaariniki, kyaapaaki nampitsiki, itaapaakiro. ");
INSERT INTO cpy_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","Ari ipithoka-paenta itaapiiki rowayiriti Tzimpookaarini-jatzi, iñaatziiro okachaa-reen-kataki otaha inampi. Tekatsi ikini ishiyanaki ochempi-mashiki, tema ithonka rotzikakiri Israel-paeni roshiya-kaamintheetziri inkaahanki romishiya-tziiri. Tema riitaki pithoka-shitana-kariri rowayiritari. ");
INSERT INTO cpy_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","Iñaakiri Josué ikyaaki nampitsiki rowayiriti ikaatzi omaneen-chari, imatakiro itaakiro nampitsi, ipiyashi-teeya-paakirini Tzimpookaarini-jatzi, rowayiri-tapaakari. ");
INSERT INTO cpy_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","Ari ishitowae-yaneeni owayiri-paeni kyaapaen-tsiri nampitsiki, rojatekae-tanakiri Tzimpookaarini-jatzi, tekatsi ikinee ishiyi, rowamahae-takiri maawoeni. ");
INSERT INTO cpy_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","Apatziro iwinkatharite Tzimpookaarini-jatzi rañaaki, tee rowamahaetziri. Roteeyee-takiri, raanakiri ijeekakira Josué. ");
INSERT INTO cpy_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","Ithonkae-takiri Tzimpookaarini-jatzi ikaatzi jataneen-tsiri ochempi-mashiki ipatzima-tantzi. Ari ipiyapaaka maawoeni Israel-paeni nampitsiki Tzimpookaarini, ithonkakiri rowamaakiri ikaatzi jeekawita-neenchari. ");
INSERT INTO cpy_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","Tema thonkaka ikamaki Tzimpookaarini-jatzi. Ikamayitaki shirampari eejatzi tsinani. Ikaateeyini 12,000 kamaentsiri. ");
INSERT INTO cpy_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","Tee ipakaero Josué rowaankiro iyotsiro-shitha-kiti rookotantawo nampitsi, roojatzi ithonkan-takariri ikaatzi nampitawori Tzimpookaariniki. ");
INSERT INTO cpy_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","Tema rayitakiri Israel-paeni maawoeni rashitari Tzimpookaarinini-jatzi eejatzi ipira-paeni. Imatakiro Josué ikantakiriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","Itaakiro Josué nampitsi Tzimpookaarini. Roojatzi nimaeka iñeetziro opiyo-pookita jempe okanta itzimpookae-takiro paerani. ");
INSERT INTO cpy_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","Raakiri Josué iwinkatharite Tzimpookaarini-jatzi, ithatakiri otewaki inchato, roojatzi tsirenii-teeni. Ikanta itziroryaanee ooryaa, ikantaki Josué: “Pithataryaa-kotiri kaminkari, pookakiteri okiishi-tapaaki awotsi, panawyaan-tyaari osheki mapi.” Roojatzi iñahaetziro nimaeka mapi ipiyota-shiitakiriri. ");
INSERT INTO cpy_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","Ari ikemaeyakini okaatzi awijeen-tsiri iwinkatharite-paeni Thaawan-taarini-jatzi, Ochempi-weni-jatzi, Owinteni-jatzi, Nampitsi-weni-jatzi, Thaante-weni-jatzi eejatzi Kayaa-weni-jatzi. Tema irika-paeni pinkathari riitaki jeeka-nampi-yitzirori Pareenkaarini, othapyaaki Antawoete Inkaari eejatzi Kiteniitoni. ");
INSERT INTO cpy_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","Ari ikaminaa-wakahae-yakani irikapaeni pinkathari, ikanta-wakaa: “Jame aapatziya-wakaeyaa, apiyata-wakyaari Josué jewatziriri Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","Riima Thaante-weni-jatzi nampitawori Nampitsii-toniki, ikemako-takiri Josué jempe ikantakiri Kashiryaari-jatzi eejatzi Tzimpookaarini-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","Ikenkishire-teeya-nakani ramatawiteri. Raaki antyashipawo-paeni rotemento eejatzi paejatoteentsiri mashitsi, owamata-pooki-tanaka, ikithaa-yitanakawo, ikyaako-tanakari ipira-paeni jateeya-nakini. ");
INSERT INTO cpy_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","Tema pichaki-pooki-tanaka, ikyaanta-yitakari iitziki paejato-pookiri. Raanaki paejato-teentsiri rowanawo, othonka opowa-pooki-taki. ");
INSERT INTO cpy_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","Areetee-yakani Pineeronchaariniki jempe ipanko-thaantetaka Josué eejatzi isheninka-paeni, ikantapaakiri: “Eeroka nopokashitzi, tema inteena nopoñaa-yitaka. Nokoyi paapatziyina.” ");
INSERT INTO cpy_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","Ari rakaeya-nakini Israel-paeni ikantziri Thaante-weni-jatzi pokaentsiri: “Aama teerika pipoñaa inteena, okaakiini pijeeki. ¿Jempe okantyaari aapatziya-wakaeyaa?” ");
INSERT INTO cpy_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","Eekiro ishintsi-tanakitziiri, ikantziri: “Nokoyi pompera-tina.” Ikantziri Josué: “¿Jempema pipoñaaka? ¿Jempe piitaka? ¿Jempe ojeeki pinampi?” ");
INSERT INTO cpy_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","Ikanteeyini riroripaeni: “Inteena nopoñaaka, nokemako-takiri Pitajorentsite. Othonka nokemakiro eejatzi okaatzi rantakiri Pitajorentsite Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","Rootaki rotyaan-tanta-kinari neewariti-paeni, eejatzi nosheninka-paeni, ikantakina: ‘Piyaati jempe ijeekaeyini Israel-paeni. Paanaki poyaari awotsiki. Aririka piñaakiri, pikantiri: “Naaka pomperatani. Nokoyi aapatziya-wakaeyaa.” ");
INSERT INTO cpy_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","Tema owakira nopokae-yanakini nothotyaa-koyitzimi, eeniro ojaawawita nowanawo. Rooma nimaeka paejato-tanaki rowanawo, othonka opowa-pooki-taki. ");
INSERT INTO cpy_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","Ari ikimi-witaka eejatzi mashitsi-naki owakirawitacha. Tema ithonka ijanaryaaki nimaeka. Ari okimitzita-kari eejatzi noethaari, nokyaantari noetziki, thonkaka, tema inteena nopoñaa-yitaka.’” ");
INSERT INTO cpy_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","Raakiro Israel-paeni rowanawo Nampitsii-toni-jatzi ramakiri inampiki, rowaka eepichokiini. Teemaeta ikowako-tziri Tajorentsi oetarika ranteri. ");
INSERT INTO cpy_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","Imatakiro Josué rojankina-takotakiro okantakota raapatziya-wakaan-tyaari eero rowayiri-tawakaanta. Ikantakiri: “Eero nowamayimi.” Roojatzi imatzitakari reewariti-paeni Israel-paeni ikantaki rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","Okanta awijaki mawa kiteejeri, ikamantee-takiri Israel-paeni, ikantee-tziri: “Tee inteena ijeekaeyini Nampitsii-toni-jatzi, riitaki pitsipa-nampitari”. ");
INSERT INTO cpy_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","Jateeyakini Israel-paeni ithotyaako-teeri Nampitsii-toni-jatzi. Okanta awijaki mawa kiteejeri, rareetakari inampiki. Iroka iitziro inampi-paeni: Nampitsii-toni, Manityaarini, Kitaawonchaarini, Antamishaarini. ");
INSERT INTO cpy_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","Teemaeta rowayiri-tapaa-kyaari, tema raapatziya-wakari chapinki, ikantakiri: “Eero nowayiri-tzimi. Aririka notheeyakyaa nokantzimi, ari rowajankitaakina Tajorentsi, Itajorentsite Israel.” Rootaki ikijima-waetanta-nakariri Israel-paeni irika reewariti-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","Roo kanteencha, iroka ikanteeyini reewariti rakayitziri Israel-paeni: “Eero nowayiritari. Tema aritaki nokantzi-takari chapinki: ‘Eero nowayiri-tzimi. Aririka notheeyakyaa nokantzimiri, ari rowajankitaakina Tajorentsi, Itajorentsite Israel.’” ");
INSERT INTO cpy_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","Eekiro ikantana-kitzii reewariti-paeni Israel-paeni: “Eero akoshekari, ijeekiita. Tema eerorika amonkaa-tziniri akanta-kiriri Tajorentsi, aritaki ikijakae. ");
INSERT INTO cpy_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","Eero powamaa-kaanta-waetzi apaani, apatziro pompera-waetyaari rayi tsitsi, eejatzi nijaa.” Ari ikinakaerori jewari-paeni imonkaa-tziro ikantakiriri Nampitsii-toni-jatzi, raapatziyaari. ");
INSERT INTO cpy_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","Ari ikaemakaan-takiri Josué Nampitsii-toni-jatzi, rojampi-takiri ikantziri: “¿Iitaka pamatawi-tantanari pikantaki: ‘Inteena ojeeki nonampi.’? Tema okaakiini pijeekae-yawitani. ");
INSERT INTO cpy_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","¡Ari riyakaeteemi! Ashi powaero nompera-waeteemi. Otzimatyee pitsima-tapiintee, paapiintee nijaa ashi ipanko Notajorentsite.” ");
INSERT INTO cpy_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","Rakanaki rirori ikantanaki: “Tema antawo nothaawan-takimi powamana-kari, rootaki namatawi-tantzimiri. Tema nokemako-takiri Pitajorentsite ikantakiriri paerani Moisés, ikantziri: ‘Ari nothonkaeri ikaatzi nampitawori jaka, nopaemiro eerokapaeni maawoeni iroka iipatsite.’ ");
INSERT INTO cpy_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","Roo kanteencha, pimatiro pompera-waetina eeroka-paeni. Pantakaenawo okaatzi kameetha-tzimotzimiri eeroka.” ");
INSERT INTO cpy_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","Imatakiro Josué, tee ishinetziri Israel-paeni rowayiri-tyaari Nampitsii-toni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","Riiyitaki rowakiri tsimata-piintatsini, riijatzi aapiinta-tsini nijaa rashi maawoeni Israel-paeni, ashi itaapooki-mento Tajorentsi jempe-rika ikowakayiri Tajorentsi. Rootaki rantawaero rametanakari rantziro roojatzi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","Ikanta Adonisedec pinkathari-tatsiri Aapatziyaweniki, ikemako-takiri Josué raapitha-takiri iipatsite Tzimpookaarini-jatzi. Ithonkakiri maawoeni, itsipataakiri iwinkatharite, ikimita-kiri paerani Kashiryaari-jatzi, ithonkakiri itsipataakiri iwinkatharite. Tema ikemako-tzitakari raapatziyakari Nampitsii-toni-jatzi, itsipatakari iipatsiteki ijeekan-tyaari kameetha. ");
INSERT INTO cpy_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","Antawo ithaawanaki. Tema ñaaperoripaeni rirori. Antawo okaatzi iipatsite, anaanakiro rashi Tzimpookaarini-jatzi. Tema otzinkami nampitsi iroka Nampitsii-toni. ");
INSERT INTO cpy_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","Rootaki rotyaan-tantakari Adonisedec jatatsini iñiiri Hohan pinkathari-tatsiri Aripero-taarewoniki, iñiiri Piream pinkathari-tatsiri Wathaweniki, iñiiri Jafía pinkathari-tatsiri Kijoshiryaariniki, iñiiri Debir pinkathari-tatsiri Waakani-kiki, ikantakiri: ");
INSERT INTO cpy_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“Pipoki pamitakotina owayiri-tyaari Nampitsii-toni-jatzi, tema raapatziyakari Josué reewariti Israel-paeni, itsipata-wakari.” ");
INSERT INTO cpy_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","Ikanta irika 5 pinkathari jeekatsiri iipatsiteki Ochempi-weni-jatzi. Pinkathari-tatsiri Aapatziyaweniki, Aripero-taarewoniki, Wathaweniki, Kijoshiryaa-riniki, eejatzi Waaka-niki, raapatziya-wakaa-naka rirori, raayita-nakiri rowayirite. Jataki itzimashiteri Nampitsii-toni-jatzi rowayiri-tyaari. ");
INSERT INTO cpy_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","Ari ikimitakari eejatzi Nampitsii-toni-jatzi, rotyaantaki jatatsini ijeekinta Josué ipanko-thaanteki Pineeronchaari-niki, ikantapaakiri: “Pipoki intsipaeti, pikijako-wentyaari pomperatani. Tema raapatziya-wakaaka pinkathari-paeni jeekatsiri tonkaariki iipatsiteki Ochempi-weni-jatzi, ikoyi rowayiri-tina.” ");
INSERT INTO cpy_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","Ikanta ikemawaki Josué, pokanaki rirori itsipayi-takari ñaaperori rowayirite ipoñaakawo Pineeronchaariniki. ");
INSERT INTO cpy_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","Ari iñaanateeriri Tajorentsi, ikanteeri: “¡Josué! Eero pithaawan-tashitari, noshine-taakimiri pithonkiri. Tema tekatsi otsinampaemini eeroka.” ");
INSERT INTO cpy_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","Ikanta ipokanaki Josué tsireni-paetiki ipoñaakawo Pineeronchaariniki, romapokakiri rowayiri-takari. ");
INSERT INTO cpy_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","Tema ikantakaakawo Tajorentsi ithaawan-teetyaari Israel-paeni, iñahaetakiri ithonkantaki rowamaantaki Nampitsii-toniki. Ipatzima-tanakiri ikinawi-tanaka awotsiki jatachari tonkaariki Moopankoniki, ari rowamaawae osheki, roojatzi rareetantaka Kiyarenchaariki eejatzi Pirateeroniki. ");
INSERT INTO cpy_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","Ikanta roerinkae-yaawoni Moopankoniki ishiya-pitha-witari Israel-paeni, rowaryaaki Tajorentsi antawo jiriniki oshiyakawo mapi, roojatzi janta Kiyarenchaariki, othonkakiri owamaakiri awijanakiri ikaatzi rowamaa-yitakiri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","Ari ikowako-takiriri Josué irika Tajorentsi ithonkiri rowayiriteri Ochempi-weni-jatzi. Tema ikemakiri maawoeni isheninka-paeni, ikantaki: “¡Ooryaa! Paatzinki jaka Nampitsii-toniki. ¡Kashiri! Paatzinki janta taapiki Maniroshaariki.” ");
INSERT INTO cpy_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","Ari imatzimaetaka aatzinka-paaki ooryaa eejatzi kashiri. Roojatzi ipakaan-takawori Israel-paeni ipiyawenta rowayiritari iijaneentani. Rootaki jankina-teenchari paerani rojankinariki Jaser, kantatsiri: “Ojamani raatzinkaki ooryaa jenokinta, roowiteencha omonkaa-teeyaamini apaani kiteejeri.” ");
INSERT INTO cpy_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","Teera iñeetziro paerani oshiyaawori roñaahan-takiri Tajorentsi rantakiro ikoyiri apaani atziri, tema ikijako-wentatyaari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","Ari ipiyaari Josué itsipataari isheninka-paeni ipanko-thaanteki janta Pineerontsiniki. ");
INSERT INTO cpy_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Okanta paata, kamaki Josué itomi Nun, romperatani Tajorentsi. Okaatzi 110 rojarentsite ikamantakari. ");
INSERT INTO cpy_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Ikiteetakiri inampiki, iiteetziri “Osheki-pero Antetaantsi” jeekatsiri ochempi-mashiki iipatsiteki Efraín-paeni, janta katonkonta ochempi Omoyekaetoniki. ");
INSERT INTO cpy_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Tema irika Israel-paeni osheki ipinkatha-tapiin-takiri Tajorentsi eeniro rañaawita Josué. Ari ikantzi-takawori eejatzi ikamaera Josué, tema eeniro rañaayitzi antari-pero-paeni yotakotzirori okaatzi rantayita-kiri paerani Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Ikanta ramaero Israel-paeni itonki-pookini José janta Apitantoniki, ikitata-paeri Shempaariniki. Rootaki iipatsite Jacob, iwaejatziiteni, ramanan-takiri paerani rashiwitawo itomipaeni Hamor, ipinatakiri ikaatzi 100 ikithoki koriki. Tema irika Hamor riitaki ipaapate iiteetziri Shempatsi, ikantziri iñaaniki riroripaeni Siquem. Okanta paata, riitaki icharini-paeni José ashitaawori maawoeni iroka kepatsi. ");
INSERT INTO cpy_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","Tema kamaki Josué, ikowaki Israel-paeni riyoti itzimi-rika etyaawoni rowayirityaa, ikowako-takiri Tajorentsi, ikantziri: “¿Itzimika etyaawoni itonkaero rowayiri-tyaari Owinteni-jatzi?” ");
INSERT INTO cpy_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","Ari rakakiri Tajorentsi ikantziri: “Riitaki etyaawoni rowayiri-tyaari icharini-paeni Judá, naaka kantakae-yaarini raapitha-tantyaariri iipatsite, riitaki ashitee-yaawoni.” ");
INSERT INTO cpy_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","Ikanta icharini-paeni Judá ikaemakiri maawoeni icharini-paeni Simeón, tema riitaki isheninka-thori, ikantakiri: “Jame atsipata-wakaeyaa atonkaero kepatsi ipaeta-kinari. Jame owayiri-tyaari Owinteni-jatzi. Aritaki nomatakiro naakapaeni, ari noyaatakimi piipatsiteki ipaeta-kimiri eeroka.” Imatakiro icharini-paeni Simeón, royaatee-yanakirini isheninka-thori-paeni. ");
INSERT INTO cpy_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","Tonkahae-yanakini Judá-paeni. Ikantakaakawo Tajorentsi ithonkiri maawoeni Owinteni-jatzi, eejatzi maawoeni Nampitsi-weni-jatzi. Tema osheki-pero ikaatzi atziri rowamaakiri janta Porekae-toniki. ");
INSERT INTO cpy_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","Ikanta rowayiri-takari Judá-paeni irikapaeni Aapatziyaweni-jatzi. Ikyaaki inampiki, ithonkakiri rowamaantakari iyotsiroshithakite maawoeni, itaanakiro inampi. ");
INSERT INTO cpy_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","Ikanta rawijanaki Judá-paeni rowayiri-tanakari Owinteni-jatzi nampiwi-tawori ochempi-mashiki, Piryaariniki, eejatzi taapiki owinteni-pathatzira. ");
INSERT INTO cpy_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","Ikanta rawijanaki Judá-paeni rowayiri-tanakari Owinteni-jatzi nampiwi-tawori Ariperotaariniki, iiteetziri paerani “4 Ashitawori Inampi”, rowamaa-nakiri Sesai, Ahimán eejatzi Talmai, jewari-paeni rirori. ");
INSERT INTO cpy_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","Ari ikantakari eejatzi icharini-paeni José, rowayiri-takari Tajorentsi-pankoni-jatzi. Tema itsipatapiintani Tajorentsi irikapaeni. ");
INSERT INTO cpy_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","Rotyaantaki icharini-paeni José jatatsini raminakitero Tajorentsi-pankoniki, iiteetziri paerani Tzipyaarini. ");
INSERT INTO cpy_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","Ikanta riyaatee-yanakini aminirori nampitsi, itonkiyotaka poñaaneen-chari nampitsiki, ikantawakiri: “¡Ayomparí! Pineshironkatena, nokoyi piyoteenawo jempe ikyaapiin-teetzi nampitsiki, aritaki nomatakimi eeroka naakameethatemi.” ");
INSERT INTO cpy_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","Imatakiro roñaahae-takiri jempe ikineetzi ikyaanteetari nampitsiki, ithonkaatakiri rowamaantakari iyotsiro-shitha-kite nampitawori janta. Riima atziri yotaakiriri ikyaantakari nampitsiki, romishiyakiri eejatzi ikaatzi isheninka-yitari rirori. ");
INSERT INTO cpy_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","Riima Israel-paeni icharini-paeni Manasés tee imatziri romishitoyiri nampitawori Maanki-pankoniki, Impanekyaariki, Chariñaariki, Niyeetoniki eejatzi Owayiriitoniki. Roojatzi inampitee-yawoni Owinteni-jatzi janta. ");
INSERT INTO cpy_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","Ikanta ishekitanaki paata Israel-paeni tzimanaki ishintsinka, ishintsiyi-teeri rantawae-takaeri Owinteni-jatzi, teemaeta romishitowaeri inampiki. ");
INSERT INTO cpy_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","Ari ikantakari eejatzi Israel-paeni icharini-paeni Efraín tee imatziri romishitoyiri Owinteni-jatzi nampitawori Pithatsiniki. Riitaki ikowakiri itsipatyaari inampityaawo inampiki. ");
INSERT INTO cpy_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","Ari ikantakari eejatzi Israel-paeni icharini-paeni Zabulón te imatziri romishitoweri Owinteni-jatzi nampitawori Jankaa-riniki, eejatzi ikaatzi nampitawori Katawoshaariki, roojatzi inampiyi-takawo Owinteni-jatzi inampiki itsipatakari icharini-paeni Zabulón. Ishintsiyi-tziri rantawae-takae-tziri. ");
INSERT INTO cpy_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","Eejatzi ikantakari Israel-paeni icharini-paeni Aser te romishitoyiri nampitawori Tampatzikaariki, Shimaaki, Owaeyashaariki, Amatawyaariniki, Owaeyashaawoki, Omonkyahaariniki eejatzi Kaankiiriniki. ");
INSERT INTO cpy_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","Itsipatakari icharini-paeni Aser inampitawo Owinteni-jatzi ashitawori inampi janta, te roemishitoyiri. ");
INSERT INTO cpy_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","Ari ikimitakiri eejatzi Israel-paeni icharini-paeni Neftalí tee imatziri roemishitoyiri nampitawori Ooryaapankoniki eejatzi Akapankoniki. Ari itsipatakari Owinteni-jatzi inampitawo iipatsiteki. Osheki ishintsiyi-takiri rompera-yitari Ooryaa-pankoni-jatzi eejatzi Akapankoni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","Riima Ochempi-weni-jatzi romishiyakiri Israel-paeni icharini-yitari Dan, inampiyi-tyaawo tonkaariki ochempi-mashiki, tee ishinetee-tziri roerinki taapiki owinteni-pathatzira. ");
INSERT INTO cpy_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","Ikanta rowetha-tanaari Josué maawoeni isheninka-paeni, jatayita-naki Israel-paeni raayitero apaanipaeni iipatsite. ");
INSERT INTO cpy_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","Tema eeniro rañaawita Josué, osheki ipinkatha-tapiin-takiri Israel-paeni Tajorentsi. Ari ikantzi-tanaawori ikamaera Josué, tema eeniro rañaayitzi antari-pero-paeni yotakotzirori jempe ikanta ineshironka-takiri paerani Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","Ikanta ikamayitaki ikaatzi tsipayi-takariri paerani Josué. Eejatzi ikaatzi owakira tzimayi-witaa-chari, kaari yotako-pero-terini Tajorentsi jempe ikanta ineshironka-tziri paerani isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","Tema rantayi-taneero Israel-paeni kowaenkatzimotziriri Tajorentsi, ipinkatha-waetashi-takari roshiya-kaawo tajorentsi-niro Inkañaaweri. ");
INSERT INTO cpy_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","Te ikowaneeri Tajorentsi, Itajorentsite paerani iwaejatzitepaeni owawijaa-koteeriri ijeekawitaka Apitantoniki. Ipinkatha-waetashi-takari itajorentsite ashitawori inampi itsipataari inampitee-yaawoni. Rootaki rowatsimaan-takariri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","Tema ipinkatha-waetakiri roshiya-kaawo tajorentsi-niro Inkañaaweri, eejatzi roshiyakaawo tajorentsi-niro Ompokiromae. Te ikowaneeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","Rootaki ikijantanakari Tajorentsi, rookawen-tanakari Israel-paeni. Ikantakaakawo ipoki koshintzi-paeni inampiki, ikoshitakiri okaatzi tzimimo-tziriri. Ipokapaaki owayiri-paeni, tee okantya ipiyata-wakyaari. ");
INSERT INTO cpy_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","Riyaawi-teeyakani rowayirityaa, te itsipata-naari Tajorentsi imatantyaariri rowayiritani. Tema imonkaa-takiro Tajorentsi okaatzi ikantakiriri. Tema osheki ikemaatsi-waetaka Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","Rootaki ikowanta-kari Tajorentsi itzimi jewari-paeni, riitaki jeekakaa-yiteerini Israel-paeni. Riitaki ookakaa-wenteerini aririka ikowaetemi raapitheeteri iipatsite. ");
INSERT INTO cpy_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","Teemaeta ikemijan-tziri reewarite-paeni, tema riitaki ikowa-perotaki ipinkatha-waeteri tajorentsi-niro. Tee ishenkaanaka ipakaero jempe ikantayita paerani iwaejatzite ikemijan-tziro ikantakaantani Tajorentsi. Tema ipakaa-nakiro rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","Aririka ikantakae-yaawo Tajorentsi itzimi reewarite Israel-paeni, riitaki jewayitziriri. Ikanta eeniro ijeekayitzi reewarite, itsipata-piintari Tajorentsi irika jewari, ipiyako-wentari rowayiriyita. Tema osheki ineshironka-takiri Tajorentsi irika Israel-paeni, ikemiri ratekaeyini okantakaawo rompera-waeteetari, eejatzi ikemaatsi-takae-tari. ");
INSERT INTO cpy_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","Roo kanteencha, aririka ikamae reewarite-paeni Israel-paeni, rapiita-neero ikaaripero-waetzi, imapero-tatziiro, rawijanakiri ikaariperotaki paerani iwaejatzite, ipinkatha-waetashitari roshiya-kaawo tajorentsi-niro-paeni. Tee ikoyi ipakaero, osheki iñaama-waetakawo rantayitziro. ");
INSERT INTO cpy_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","Tema antawo rowatsimaakiri Tajorentsi irika Israel-paeni, ikantanaki: “Ikantakaan-tziro Israel-paeni itheenkakiro nokashiya-kaeriri paerani iwaejatzite-paeni, te ikoyi ikemijan-teena, ");
INSERT INTO cpy_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","rootaki eero nomishitowan-taari ashitawori paerani inampipaeni jaka, kaari rotsinampae roemishitoyi paerani Josué eeniro ijeekawita.” ");
INSERT INTO cpy_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","Tema ikowawitatyaa Tajorentsi iñiirimi Israel-paeni ipiya-shiretee ikemijan-teeri, roshiyako-teeyaari iwaejatzite ikemijan-takiri paerani rirori. ");
INSERT INTO cpy_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","Rootaki ikowan-takari Tajorentsi itsipatyaari Israel-paeni ashitawori paerani inampi janta. Tema tee ithonkiri roemishitoyiri, riitaki Tajorentsi kantakaawo kaari ithonkantari Josué. ");
INSERT INTO cpy_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","Imaperotakiro Israel-paeni ikaariperotaki tee ookimotaari Tajorentsi, rookawenta-nakari. Itajorentsiteta-shiwae-takari Inkañaaweri, eejatzi roshiya-kaawo Inkaari-weri. ");
INSERT INTO cpy_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","Antawo rowatsimaakiri Tajorentsi irika-paeni Israel-paeni, ishineta-nakiri imaperoteri rompera-waetyaari Cusan-risataim pinkatha-ritatsiri Othowyaaniki jeekatsiri Tonkaeroniki. Tema ojamani rompera-waetakari okaatzi 8 ojarentsi ijeekawaetaki. ");
INSERT INTO cpy_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","Ari ikowa-koteeri Tajorentsi irika-paeni Israel-paeni itzimae kijakowentee-yaarini. Riitakira itomi Cenaz, iitachari Otoniel, iyaapitsi rirentzi Caleb. ");
INSERT INTO cpy_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","Ojeeka-shiretan-tanakari Ishire Tajorentsi irika Otoniel, retanakawo reewatziri Israel-paeni, jataki rowayirityaa. Ishineta-kiniri Tajorentsi rotsinampaeri Cusan-risataim pinkatha-ritatsiri Tonkaeroniki. ");
INSERT INTO cpy_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","Ojamani ijeekawaetee kameetha Israel-paeni okaatzi 40 ojarentsi, roojatzi ikamantaari Otoniel itomi Cenaz. ");
INSERT INTO cpy_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","Rapiiteero Israel-paeni ikaariperotzi-moteeri Tajorentsi, ari ikantakaakawo Tajorentsi otzimi-moteri ishintsinka Eglón pinkatha-ritatsiri Athataa-weniki, riitaki owayirita-kariri Israel-paeni. Okantakaan-tziro ikaariperotzi-motakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","Ikanta iwinkatharite Athataa-weni-jatzi raapatziyakari iwinkatharite Pityaankaarini-jatzi, eejatzi Otenkanaa-weni-jatzi, ipokaeyakini rowayiritari Israel-paeni, raapithatakiri inampi iiteetziri Kapa-shaari. ");
INSERT INTO cpy_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","Tema okaatzi 18 ojarentsi romperatee-takari Israel-paeni romperatari iwinkatharite Athataa-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","Ikanta Israel-paeni ikowa-koteeri Tajorentsi. Ikantakaakawo Tajorentsi itzimae itsipa kijakowentee-yaarini, riitaki Aod itomi Gera, isheninka Benjamín-paeni, ampatentsi irika. Ikanta rotyaan-takiniri Israel-paeni ishintsitakiri ramaeteniri koriki irika Eglón iwinkatharite Athataa-weni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","Rowetsikaki Aod iyotsiro-menete, apimene ithoyempitakiro, tee ojantha-perotzi. Roojota-kotakawo rakoki romana-kotan-takawo iithaariki. ");
INSERT INTO cpy_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","Ikanta riyaataki raanakiniri ishintsitan-tziri rahaeteniri koriki irika Eglón iwinkatharite Athataa-weni-jatzi. Riiperori wathantzi irika atziri Eglón. ");
INSERT INTO cpy_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","Tema imatakiro ipakiri ishintsitan-tziri rahaeteniri koriki, ari riwethata-waari Aod ikaatzi itsipayitakari. ");
INSERT INTO cpy_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","Ikanta rareetaka ijeekira itajorentsiteta-waeta-shitari jeekatsiri okaakitapae Pineeronchaarini, ipiyaa Aod ijeekinta Eglón, ikantapaeri: “Pinkathari, eenitatsi ñaantsi nokoyiri nokaman-temiro apaniroeni.” Ari rakanaki Eglón, ikantzi: “¡Pishitowaeyini!” Shitowae-yanakini inampina-paeni rirori. ");
INSERT INTO cpy_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","Rontsiroka-paakari okaakiini Aod ijeeki imajawiryaa-waeta. Ikantzi Aod: “Namatziimi iñaani Tajorentsi.” Ari ikatziyanaka rirori. ");
INSERT INTO cpy_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","Rowaanka-nakiro Aod rampate rako, raakiro kotsiromene romanakiri oweyaari iithaari rakoperoki, rowathaakiri imotziki, ");
INSERT INTO cpy_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","itsitsikitakiniri, othonka okyaa-kotanaki okawo iyotsiro-menete, tee oshitowae, jataki isheeto-ki. ");
INSERT INTO cpy_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","Ari ishitowanaki Aod jakakiroki, rashita-nakiro kameetha, rojateka-neero ashitakowontsi. ");
INSERT INTO cpy_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","Ikanta ishitowanee, ari ipokaeya-paakini romperatani-paeni pinkathari, iñaapaa-tziiro ashitaka pankotsi, ikanteeyini: “Aamashityaa ratonkokyaatyaarika ishita.” ");
INSERT INTO cpy_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","Ikanta royaawenta tee riyotzi oeta rantziri kaari rashita-ryaan-taawo, rashitaryaa-kotakiri, iñaatziiri romaryaaka iwinkatharite, kamaki. ");
INSERT INTO cpy_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","Ikanta raminee-yakironi oeta ikamantakari, shiyanaka Aod. Ikinanaki ijeekayitzi roshiya-kaawo tajorentsi-niro-paeni, awijakotee janta iiteetziro Rawotsite Witzintzi-weni. ");
INSERT INTO cpy_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","Ikanta rareetaa ipatsiteki isheninka-paeni Efraín-paeni, itziwoota-paaki. Oerinkae-yaani Israel-paeni, riitaki jewateerini maawoeni. ");
INSERT INTO cpy_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","Ikantakiri: “Poyaatena, tema ishinetakiri Tajorentsi owayirityaari Athataa-weni-jatzi.” Royaatee-yanakirini, ithonka raapaakiro imontyeeta-piinta Pareenkaariniki, tee ishinetzi apaani awijatsini janta. ");
INSERT INTO cpy_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","Tema omaperotatyaa ishekitzi Athataa-weni-jatzi rowamahaetaki eejatzi riiperori owayiri-paeni. Tema tekatsi apaani shiyatsini. ");
INSERT INTO cpy_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","Ari okanta ithonkae-tanta-kariri Athataa-weni-jatzi, riitaki thonkakiriri Israel-paeni. Okaatzi 80 ojarentsi ijeekawaetee kameetha tekatsi koshekyaarini. ");
INSERT INTO cpy_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","Ikanta imatantaki Aod, riitakira mataneerori Samgar itomi Anat, rowamaaki rirori osheki Kinakinawaetaniri-paeni rominthaawan-takari ipira-paeni. Riijatzi kijakowentee-yaariri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("JG21_25","008_21_25","JDG","21","25","25","Paerani tekira itzimanaki riiperori iwinkatharite Israel-paeni, rantashi-yitakawo apaani-paeni okaatzi ikowayi-tziri rirori. ");
INSERT INTO cpy_vpl VALUES ("S11_1","010_1_1","1SA","1","1","1","Eenitatsi apaani atziri nampitawori Ramataim-ki isheninka Zuf jeekatsiri iipatsiteki Efraín. Iitachari Elcana, itomi Jeroham, icharini Eliú. Icharini-tanakari Tohu eejatzi Zuf Efraín-paeni rirori. ");
INSERT INTO cpy_vpl VALUES ("S11_2","010_1_2","1SA","1","2","2","Apite okaatzi iina Elcana. Oeta Ana, otsipa oeta Penina. Eenitatsi otomipaeni Penina, rooma Ana tee otzima-nitzi eentsite. ");
INSERT INTO cpy_vpl VALUES ("S11_3","010_1_3","1SA","1","3","3","Ari ikanta-piintatya ojarentsiki Elcana itonkae nampitsiki Silo ipinkatha-tziri Shintsi-perori Tajorentsi, itayitziniri ipira. Ari ijeekiri janta itomi ompera-tajorentsi-taarewo Elí, apite ikaatzi: iitachari Ofni, itsipa iitachari Finees, rompera-tajorentsi-taarewote Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S11_4","010_1_4","1SA","1","4","4","Okanta omonkaa-tapiintaha kitejeri itaan-tanariri Elcana irika Tajorentsi, rashitakaawo eepichokiini iina eejatzi itomipaeni itayi-niriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S11_5","010_1_5","1SA","1","5","5","Retakoperotawo Ana roori, rashitakaawo kameetha-perori, okanta-witaka tee ikowakaero Tajorentsi otzimi eentsite. ");
INSERT INTO cpy_vpl VALUES ("S11_6","010_1_6","1SA","1","6","6","Rootaki okija-pero-tanta-nakawori Penina, onina-waetanakiro, owaañaa-waetziro tema tee ikowakaero Tajorentsi otzimi eentsite. ");
INSERT INTO cpy_vpl VALUES ("S11_7","010_1_7","1SA","1","7","7","Ari okanta-piintatya Penina ojarentsiki, aririka iyaate itajorentsi-pankoteki Tajorentsi, okijaneentziro. Rootaki iraawae-tantari Ana, oñaakaha tee otzimi eentsite. ");
INSERT INTO cpy_vpl VALUES ("S11_8","010_1_8","1SA","1","8","8","Ikantakiro oemi, Elcana: “¡Ana! ¿Iitakama piraantari? ¿Iitakama powashire-tantari kaari powanta? ¿Teema naaka kameetha-pero-tatsiri, nawijiri ikaawi-tyaarika 10 pitomipaeni?” ");
INSERT INTO cpy_vpl VALUES ("S11_9","010_1_9","1SA","1","9","9","Okanta apaani kitejeri janta Silo-ki, ari okaatakiro owawaeta Ana, okatziyanaka. Ari ijeekitaka ompera-tajorentsi-taarewo Elí ikyaa-piintee-tzira tajorentsi-pankoki. ");
INSERT INTO cpy_vpl VALUES ("S11_10","010_1_10","1SA","1","10","10","Aakiro Ana oshenka, antawo okantzimo-takiro, amananakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S11_11","010_1_11","1SA","1","11","11","Okantzi amana: “¡Tajorentsi Shintsi-perori! Pineshironkatena, tema naaka pomperatanewo, eero pimaejantana nokoyi itzimi apaani notyomi. Riitaki nashita-kaemi rantantemirori okaatzi pikowayiteeri. Riyotan-teetyaari eeroka nashitakahaeyaari, eero nameetziri iishi.” ");
INSERT INTO cpy_vpl VALUES ("S11_12","010_1_12","1SA","1","12","12","Ojamanitaki amana Ana, ramina-mintha-takiro Elí opaanteki. ");
INSERT INTO cpy_vpl VALUES ("S11_13","010_1_13","1SA","1","13","13","Tema amana-shiretatya roori, tee ikemaetziro oñaawaetzi, apatziro oñaawae-chera-tashita. Ikenkishiryaanaka Elí oshinki-tatya Ana. ");
INSERT INTO cpy_vpl VALUES ("S11_14","010_1_14","1SA","1","14","14","Ikanta-nakiro: “¿Jempema okaateka pipakayiro pishinki-waeta? ¡Pipakayiro piriro shinchaari!” ");
INSERT INTO cpy_vpl VALUES ("S11_15","010_1_15","1SA","1","15","15","Akanaki Ana, okantzi: “Tee ari okantya nowinkatharité, tekatsi nire, tee noshinki-waeta. Tema noshiri-pero-tatyaari Tajorentsi, okantakaan-tziro antawo nowashire-takowaetaka. ");
INSERT INTO cpy_vpl VALUES ("S11_16","010_1_16","1SA","1","16","16","Eero pikenkitha-shire-waeta-shita pikante kaariperori tsinani ini, aña nokamae-tatyaawo namana tema eenitatsi kantzimo-shire-tanari, antawo nowashire-takowaetaka.” ");
INSERT INTO cpy_vpl VALUES ("S11_17","010_1_17","1SA","1","17","17","Ari rakanakiro Elí, ikanta-nakiro: “Piyaatee kameetha, ari imatakimiro Itajorentsite Israel okaatzi pikowako-takiriri.” ");
INSERT INTO cpy_vpl VALUES ("S11_18","010_1_18","1SA","1","18","18","Okantzi roori: “Ariwé nowinkatharite, okamintheeya okaatzi pikanta-kinari.” Jatee Ana jempe opoñaaka paerani, owawaetapaa kameetha, tee owashire-waetapaa. ");
INSERT INTO cpy_vpl VALUES ("S11_19","010_1_19","1SA","1","19","19","Okanta otsipaki kitejeri ananinka-manee, okaatakiro amanari Tajorentsi. Jataje Ramá-ki ojeekira opanko. Ikanta Elcana itsipatakawo iina. Ari imatakiniro Tajorentsi okaatzi okowako-takiriri. ");
INSERT INTO cpy_vpl VALUES ("S11_20","010_1_20","1SA","1","20","20","Motzitanaki Ana. Okanta paata otzimakiri otomi, oetakiri Samuel, okantzi: “Riitaki nokowako-takiriri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S11_21","010_1_21","1SA","1","21","21","Ikanta Elcana tonkaanaki Silo-ki itsipatanakari isheninka-paeni, jempe okantya imonkaa-tantyaawori ikantakiri rantero, itaan-tyaariri eejatzi ipira okaatzi rameta-piinteeyarini. ");
INSERT INTO cpy_vpl VALUES ("S11_22","010_1_22","1SA","1","22","22","Tee iyaatzimaeta Ana, okantakiri oemi: “Eero niyaatzi naaka rookawa-kiroota iteni eentsi, roojatzi naantanakyaari nashita-kae-yaari Tajorentsi, ashi rowaero ijeekae janta, eero ipiyaa jaka.” ");
INSERT INTO cpy_vpl VALUES ("S11_23","010_1_23","1SA","1","23","23","Ari ikantanaki Elcana: “Pimatero kameetha-tzimo-tzimiri eeroka. Aritaki pijeekawaki roojatzi rookanta-kyaawori iteni eentsi. Okamintheeya imonkaatiro Tajorentsi okaatzi ikowakiri rantiri.” Ari okantaka, tee iyaatzi roori, roojatzi ikimota-tantakari otomi, ookakaakiri iteni. ");
INSERT INTO cpy_vpl VALUES ("S11_24","010_1_24","1SA","1","24","24","Ikanta ookakaakiri iteni, aanakiri otomyaaniki Silo-ki tajorentsi-pankoki. Ari aanaki eejatzi mawa ewonkiri vaca, eejatzi aayi-tanaka okithoki rowetsikan-teetari pan okaatzi oshekitzi 22 poteryaaki ipiyaa-tantee-tawori, eejatzi apaani imiriteetziri ipiyaatee-takiro mashitsi-nakiki. ");
INSERT INTO cpy_vpl VALUES ("S11_25","010_1_25","1SA","1","25","25","Owamaaki ewonkiri vaca, aanakiniri Elí, eejatzi ayitanakanari otomyaaniki. ");
INSERT INTO cpy_vpl VALUES ("S11_26","010_1_26","1SA","1","26","26","Okanta-paakiri Ana: “¡Eejó, Pinkatharí! Naakataki tsinani amanakariri paerani Tajorentsi jaka. ");
INSERT INTO cpy_vpl VALUES ("S11_27","010_1_27","1SA","1","27","27","Tema nokowako-takiri itzime apaani neentsite, imatakinawo Tajorentsi okaatzi nokowakotakiri. ");
INSERT INTO cpy_vpl VALUES ("S11_28","010_1_28","1SA","1","28","28","Riitaki nashita-kaeyaari Tajorentsi, ashi rowaero rashityaari rirori eeniro ijeekira kepatsiki.” Ari rotziwerowanaka ipinkatha-tanakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S12_18","010_2_18","1SA","2","18","18","Irika ewankari Samuel, eekiro riyaatatzi rirori rantziniri Tajorentsi ikoyiri. Ikithaa-tapiintawo tajorentsi-mawo-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("S12_19","010_2_19","1SA","2","19","19","Ari iyaatapiintzi ojarentsiki riniro otsipatari oemi tajorentsi-pankoki otayiniri Tajorentsi opira, ayiniri otomi iithaa-ryaaniki owetsikiri roori. ");
INSERT INTO cpy_vpl VALUES ("S12_20","010_2_20","1SA","2","20","20","Ikanta Elí osheki ikimoshire-wentakiri Elcana eejatzi iina, ikantakiri: “Inkamintheeya Tajorentsi ikantakayaawo piina otzimanteeyaari itsipa pitomi-paeni poyaateeyaarini ashitakaa-kariri roori Tajorentsi.” Ari opiyeeyaani opankoki. ");
INSERT INTO cpy_vpl VALUES ("S12_21","010_2_21","1SA","2","21","21","Ikanta Tajorentsi ikanta-kahaawo omotzitee Ana. Ari itzimae mawa otomi, apite ishinto. Riima Samuel eekiro riyaatatzi rantaritzi rantayi-tziro ikoyiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S13_19","010_3_19","1SA","3","19","19","Eekiro ikimota-tatzi Samuel, imatakiro Tajorentsi ramitako-takiri ithotyaa-kiniri okaatzi ikanta-kiriri. ");
INSERT INTO cpy_vpl VALUES ("S13_20","010_3_20","1SA","3","20","20","Othonka ikemakoe-takiri Samuel riitaki kamantan-taniri ikowakaakiri Tajorentsi, riyoetakiri nampitsiki Dan roojatzi Beerseba-ki. ");
INSERT INTO cpy_vpl VALUES ("S13_21","010_3_21","1SA","3","21","21","Ari rapiiteero Tajorentsi roñaahaari nampitsiki Silo, ari riyoteeri iñaani ikowakaa-kiriri. ");
INSERT INTO cpy_vpl VALUES ("S18_1","010_8_1","1SA","8","1","1","Antari-pero-tapaaki Samuel, rowakiri itomi-paeni jewaterini Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S18_2","010_8_2","1SA","8","2","2","Etawori itomi, iita Joel, itsipa itomi iita Abías. Riitaki jewatatsiri janta Beerseba-ki. ");
INSERT INTO cpy_vpl VALUES ("S18_3","010_8_3","1SA","8","3","3","Tee roshiyako-tzimaetyaari ashitariri irika itomi-paeni, osheki imashitataki, iñaamatawo ipineeteri, tee imatziro kameetha-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("S18_4","010_8_4","1SA","8","4","4","Ari ipiyotee-yakani antaripero-paeni Israel-paeni, jataki iñeeri Samuel janta Ramá-ki, ");
INSERT INTO cpy_vpl VALUES ("S18_5","010_8_5","1SA","8","5","5","ikanteri: “Antari-pero-tapaakimi eeroka, tee roshiyakotemi pitomi-paeni. Otzimatye pamini pinkathari-wentenani, ikimita-haetzirowa otsipaki nampitsi eenitatsi pinkathari-pero-tatsiri.” ");
INSERT INTO cpy_vpl VALUES ("S18_6","010_8_6","1SA","8","6","6","Tee inimotanakiri Samuel ikowakoe-takiri ramine apaani pinkathari-went-terini. Ramanakari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S18_7","010_8_7","1SA","8","7","7","Rakanakiri Tajorentsi, ikantakiri: “Pimatiro okaatzi ikowako-tzimiri atziri-paeni. Tee imaninteetzimi eeroka, naaka imaninteetaki, tema tee ikoyi nopinkathari-wenteeri. ");
INSERT INTO cpy_vpl VALUES ("S18_8","010_8_8","1SA","8","8","8","Tee rookiro ikanta paerani nomishitowan-taariri Egipto-ki, roojatzi ikanta nimaeka rantayi-tziro ikowashiyitari. Tee roshiretina naaka, ipinkatha-tashi-takari itajorentsi-tewae-tashi-takari. Ari ikantzi-takimiri eeroka nimaeka. ");
INSERT INTO cpy_vpl VALUES ("S18_9","010_8_9","1SA","8","9","9","Pantiniri okaatzi ikowaeyirini. Iro kanteencha otzimatye pishintsitha-tawakiri eejatzi, piyoteeri jempe ikantya romperatyaari pinkathari-wenterini.” ");
INSERT INTO cpy_vpl VALUES ("S18_10","010_8_10","1SA","8","10","10","Imatakiro Samuel, ikamantakiri atziri-paeni ikantakiri Tajorentsi jempe ikantakota iwinkatharite ikowaeya-kirini. ");
INSERT INTO cpy_vpl VALUES ("S18_11","010_8_11","1SA","8","11","11","Ikantakiri: “Iroka ikantya ipinkathari-wentantemiri: Rashita-paakyaari pitomi-paeni, raanakiri ishiyako-mentoki riyoteeri rowayiritya, itsipa ikyaako-takae-yaari iyawayoti, itsipa raminako-wentiro ipanko pinkathari. ");
INSERT INTO cpy_vpl VALUES ("S18_12","010_8_12","1SA","8","12","12","Itsipa rowakiri jewaterini 1000 rowayirite, itsipa jewaterini 50 rowayirite. Ikaemayi-takimi ipankiwae-takaemi, powiitero pipanki-takiri, itsipa owetsika-tsini rowayiri-mento, itsipa owetsika-tsini ikashiyaa-kayirori ishiyako-mento-paeni. ");
INSERT INTO cpy_vpl VALUES ("S18_13","010_8_13","1SA","8","13","13","Raanakiro pishinto-paeni rantawae-takayiro, antawaetiro kajankari-paeni, otsipa onkotsiwae-tatsini, otsipa amiroka-pitha-tironi pan. ");
INSERT INTO cpy_vpl VALUES ("S18_14","010_8_14","1SA","8","14","14","Rashita-paakyaawo rooperori piipatsite, rooperori piwankiri-mashi, paapiintziri oyeenka. Ipayiteeri inampina-paeni. ");
INSERT INTO cpy_vpl VALUES ("S18_15","010_8_15","1SA","8","15","15","Otzimirika 10 paakiri piwankiritari, rashitee-yaari rirori apaani. Ipayiteri royaari inampina-paeni eejatzi aminayitziriri rowayirite. ");
INSERT INTO cpy_vpl VALUES ("S18_16","010_8_16","1SA","8","16","16","Rashitee-yaarini pompera-tanewo-paeni, shirampari eejatzi tsinani. Rahaeri riroperori pipirapaeni pikyaaka-piintziri tenari, rantawae-takayiri rirori. ");
INSERT INTO cpy_vpl VALUES ("S18_17","010_8_17","1SA","8","17","17","Eenitatsirika 10 pipiratari, rashityaari apaani. Ari imatakimi eeroka romperateemi. ");
INSERT INTO cpy_vpl VALUES ("S18_18","010_8_18","1SA","8","18","18","Eero ramitakotzimi Tajorentsi paata, jemperika ikanta-waeta-paakimi piwinkatharite pikowakiri.” ");
INSERT INTO cpy_vpl VALUES ("S18_19","010_8_19","1SA","8","19","19","Tee ikemijantzimaetyaari atziri-paeni ikanta-witakariri Samuel, ikantanaki: “Okanta-witya, nokoyi itzimi nowinkathari-pero-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("S18_20","010_8_20","1SA","8","20","20","Nokoyi nokimityaari itsipa-jatzi atziri-paeni tzimatsiri iwinkatharite, riitaki jewatziriri rowayirita.” ");
INSERT INTO cpy_vpl VALUES ("S18_21","010_8_21","1SA","8","21","21","Ikanta Samuel ikamantakiri Tajorentsi okaatzi ikanta-kiriri atziri-paeni. ");
INSERT INTO cpy_vpl VALUES ("S18_22","010_8_22","1SA","8","22","22","Ikantzi Tajorentsi: “Pantiniri ikoyiri, poyiniri pinkathari-wenterini.” Imatakiro Samuel, ikantakiri Israel-paeni: “Pipiyee pinampiki.” ");
INSERT INTO cpy_vpl VALUES ("S19_1","010_9_1","1SA","9","1","1","Eenitatsi isheninka Benjamín iita Cis, itomi Abiel, icharini Zeror. Tomintariri Zeror iita Becorat, tomintariri Becorat iita Afía, otomi isheninka-paeni Benjamín. Irika Cis riroperori rirori. ");
INSERT INTO cpy_vpl VALUES ("S19_2","010_9_2","1SA","9","2","2","Eenitatsi itomi, kameetha rewankaritzi rirori. Iita Saúl. Tekatsi isheninka Israel-ni oshiyaarini ikantaha irika ewankari, tekatsi awijirini ikaatzira ikatziya. ");
INSERT INTO cpy_vpl VALUES ("S19_3","010_9_3","1SA","9","3","3","Ikanta Cis ipeya-pitha-takari iyawayote. Ikantakiri Saúl, itomi: “Piyaate pitsipa-tanakyaari omperatanewo, pithotyaa-koteeri ayawayote.” ");
INSERT INTO cpy_vpl VALUES ("S19_4","010_9_4","1SA","9","4","4","Jataki Saúl, rawijanakiro ochempi ijeekira Efraín-paeni, areetaka iipatsiteki Salisa-jatzi. Tee iñiiri iyawayote. Awijanaki iipatsiteki Saalim, tee iñeeri. Ikinanairo iipatsiteki Benjamín-paeni, tee iñiimaetari. ");
INSERT INTO cpy_vpl VALUES ("S19_5","010_9_5","1SA","9","5","5","Areetaka iipatsiteki Zuf, ikantakiri romperatanewo: “Jame apiyee, osheki royaawen-takae ashitanari, tee ikowaeri caballo.” ");
INSERT INTO cpy_vpl VALUES ("S19_6","010_9_6","1SA","9","6","6","Rakanaki romperatanewo, ikantzi: “Eenitatsi jaka nampitsiki kamantan-taniri, maawoeni ipinkathee-tziri. Okaatzi ikantziri rirori, aritaki omatakya. Jame aate añeeri, riitaki kanteeni jempe akini athotyaakotiri ayawayote.” ");
INSERT INTO cpy_vpl VALUES ("S19_7","010_9_7","1SA","9","7","7","Ikantzi Saúl: “¡Jame! ¿iitaka aanakiniriri? Tekatsitaki owanawo athaateki. Tekatsi apapaakiriri kamantan-taniri.” ");
INSERT INTO cpy_vpl VALUES ("S19_8","010_9_8","1SA","9","8","8","Ikantzi romperatanewo: “Eenitatsi apaani noorikite. Riitaki apinateriri roñaahan-teerori jempe akinanaki.” ");
INSERT INTO cpy_vpl VALUES ("S19_9","010_9_9","1SA","9","9","9","(Paerani okaatzi rametari Israel-paeni aririka ikoyi riyaate ikowakoteri Tajorentsi, ikantzi: “Jame añaakitiri”, riitaki aeteeri “kamantan-taniri”, paerani iiteetziri “ñaawyaa-waerintzi”.) ");
INSERT INTO cpy_vpl VALUES ("S19_10","010_9_10","1SA","9","10","10","Ikantzi Saúl: “Jametya añeeri.” Jataki nampitsiki iñiiri kamantan-taniri. ");
INSERT INTO cpy_vpl VALUES ("S19_11","010_9_11","1SA","9","11","11","Ikanta itonkaeyanakini riyaatzi nampitsiki, itonkyoo-takawo ewankawo-paeni ayi nijaa, rojampi-tawakiro: “¿Arima ijeeki jaka ñaawyaa-waerintzi?” ");
INSERT INTO cpy_vpl VALUES ("S19_12","010_9_12","1SA","9","12","12","Akanakiri okantziri: “Jeen, aritaki ijeeki janta. Intsipaeti piyaatanaki, roemo-shirenkaeyatyaani tajorentsi-pankoki. ");
INSERT INTO cpy_vpl VALUES ("S19_13","010_9_13","1SA","9","13","13","Aririka pareetakya janta, pithotyaa-koteri tekira riyaata-nakiita tajorentsi-pankoki royaa. Eero royita atziri-paeni eerorika rareeta rirori. Riitaki tajonka-wentironi owanawontsi royaari ikaatzi ikaemaeyakirini. Piyaatanakiita intsipaeti, aritaki piñaapaakiri.” ");
INSERT INTO cpy_vpl VALUES ("S19_14","010_9_14","1SA","9","14","14","Awijanaki riyaatiro nampitsiki. Ari raree-tzimataka janta, pokanaki rirori Samuel riyaatiro tajorentsi-pankoki. ");
INSERT INTO cpy_vpl VALUES ("S19_15","010_9_15","1SA","9","15","15","Maakotaki apaani tsireniri rareetan-tyaari Saúl, roñaahakari Tajorentsi irika Samuel, ikantakiri: ");
INSERT INTO cpy_vpl VALUES ("S19_16","010_9_16","1SA","9","16","16","“Okiteji-tamanee, ikaatakika nimaeka ooryaa, ari notyaan-takimi apaani atziri isheninka Benjamín-paeni, riitaki pitajorentsi-takayiri reewatan-tyaariri Israel-paeni. Riitaki pakaakaerini Filistia-jatzi ikosheka-waetakimira. Antawo noneshironka-takiri, areetakina nojeekira okaatzi ikowako-tanari.” ");
INSERT INTO cpy_vpl VALUES ("S19_17","010_9_17","1SA","9","17","17","Ikanta Samuel iñaawakirira Saúl, ikantanakiri Tajorentsi, ikantziri: “Irika atziri pokeentsirika, riitaki nokanta-kimiri chapinki. Riitaki pinkathari-wenterini isheninka.” ");
INSERT INTO cpy_vpl VALUES ("S19_18","010_9_18","1SA","9","18","18","Ari rareeta-paaka Saúl nampitsiki, ipokashi-tapaakiri okaakiini Samuel, ikantziri: “Pikantina. ¿Jempe ojeekika ipanko ñaawyaa-waerintzi?” ");
INSERT INTO cpy_vpl VALUES ("S19_19","010_9_19","1SA","9","19","19","Rakanaki Samuel, ikantziri: “Naakataki ñaawyaa-waerintzi, pipoki pakiyotina. Okiteji-tamanakirika ari nokantimi okaatzi pikoyiri pojampi-tinari, noepiyeemi pinampiki. ");
INSERT INTO cpy_vpl VALUES ("S19_20","010_9_20","1SA","9","20","20","Iñahaeteeri piyawayote peyawiteen-chari chapinki, eero okantzimo-waetzimi. Tema eeroka ashiteeyaawoni maawoeni tzimimotziriri Israel-paeni, roojatzi rashitee-yaari pisheninkateeyaari paata.” ");
INSERT INTO cpy_vpl VALUES ("S19_21","010_9_21","1SA","9","21","21","Ikantzi Saúl: “¡Naakataki isheninka Benjamín-ni, tee nosheki-teeyeni! Ari ikantzita eejatzi nokaatee-yinira isheninkatana Benjamín-ni. ¿Iitaka pikantantari eeroka ashityaawoni maawoeni?” ");
INSERT INTO cpy_vpl VALUES ("S19_22","010_9_22","1SA","9","22","22","Ikantzi Samuel: “Jame akye inthomoeki.” Raanakiri ipiyotee-yakanira ikaatzi 30 atziri, itsipataa-nakiri romperatanewo. ");
INSERT INTO cpy_vpl VALUES ("S19_23","010_9_23","1SA","9","23","23","Ikanta-paakiri Samuel onkotsiwae-tatsiri: “Pamakinari wathatsi nokanta-kimiri, pinashi-tyaari poyiri.” ");
INSERT INTO cpy_vpl VALUES ("S19_24","010_9_24","1SA","9","24","24","Akotanaki onkotsiwae-tatsiri, royiiteeta-kiniri ipori irika Saúl. Ikantzi Samuel: “Irika nowaan-takimiri, poyaa. Riitaki nowaantakimiri eeroka, areetzimoshiryaapaakina rakiyotana atziri jeekatsiri jaka.” Imatakiro Saúl rakiyotakiri Samuel. ");
INSERT INTO cpy_vpl VALUES ("S19_25","010_9_25","1SA","9","25","25","Ikanta roerinkanaa otaapiki nampitsiki, rowetsikae-takiniri Saúl imaantyaari jenokinta pankotsiki. ");
INSERT INTO cpy_vpl VALUES ("S19_26","010_9_26","1SA","9","26","26","Ari imaaki Saúl. Okanta okiteji-tamanee, ikanteeri Samuel irika Saúl: “Pikakite, pawije jempe poshiretawo.” Imatakiro Saúl ipiriintanaka. Anashitanaka itsipata-nakari Samuel. ");
INSERT INTO cpy_vpl VALUES ("S19_27","010_9_27","1SA","9","27","27","Ikanta roerinkaeyanaani oweyaa-thapitaha nampitsi, ikantziri Samuel irika Saúl: “Potyaantiri pomperatanewo retyaawo, poyaawa-kinaata eepichokiini, nokaman-timiro okaatzi ikanta-kinari Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S110_1","010_10_1","1SA","10","1","1","Raakotakiri Samuel yeenkantsi, ijeepatziito-takiri Saúl, ikantakiri: “Itajorentsi-takaatyeemi Tajorentsi. Eeroka pinkathari-wenterini Israel-paeni, ratzirite Tajorentsi. Eeroka kijako-wentyaarini ikosheka-waetarira ikija-neentanewo. Iroka piyotan-tyaari eeroka rowakimi Tajorentsi peewateri ratzirite. ");
INSERT INTO cpy_vpl VALUES ("S110_17","010_10_17","1SA","10","17","17","Ikanta Samuel ikaema-kaantakiri maawoeni Israel-paeni, ipinkathatiri Tajorentsi janta Mizpa-ki. ");
INSERT INTO cpy_vpl VALUES ("S110_18","010_10_18","1SA","10","18","18","Ikantakiri: “Iroka ikantzi Tajorentsi, Itajorentsite Israel: ‘Naaka omishitowaemiri Egipto-ki, netsinaa-ryaako-teemi rompera-waetzimira Egipto-jatzi, nomateeri ikaatzi kosheka-waetzimiri.’ ");
INSERT INTO cpy_vpl VALUES ("S110_19","010_10_19","1SA","10","19","19","Roo kanteencha, pimanin-tawae-takiri Tajorentsi etsinaryaako-teemiri, okantzimo-waetzimi pikemaatsi-waetaha. Pipakaaneeri Tajorentsi, tema pikantaki: “Nokoyi apaani pinkathari-wenteenani.” Nimaeka otzimatye piyaateeyini pipinkathatiri Tajorentsi, pikaateeyinira pisheninka-tawakaa okaakiini eejatzi ikaatzi pisheninka-paeni maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("S110_20","010_10_20","1SA","10","20","20","Ikanta Samuel riyaatashitanakiri okaakiini ikaa-teeyinira Israel-paeni, roshiyakaantakiro iñaaryaa-teeta. Ari iñaakiro isheninka Benjamín-ni ikowakaetakiri. ");
INSERT INTO cpy_vpl VALUES ("S110_21","010_10_21","1SA","10","21","21","Ikanta ipokaeyapaakini okaakiini ikaateeyinira Benjamín-ni, roojatzi roshiyakaantakiro ketsiroini iñaaryaa-wentee-tatyeeyaarimi, iñaatziro riitaki ikowakaetakiri isheninka Matri. Rapiitakiro roshiyakaeromi iñaaryaa-tatyeeyaami, iñaatziro riitaki Saúl, itomi Cis, riitaki ikowakaetakiri. Ithotyaakoe-witakari jempe ijeeki, tee iñahae-tzimaetari. ");
INSERT INTO cpy_vpl VALUES ("S110_22","010_10_22","1SA","10","22","22","Rapiiteero ikowakoe-tziri Tajorentsi, riyoetan-tyaari aririka ijeeki Saúl janta. Ikantanaki Tajorentsi: “Ari ijeeki Saúl janta. Pithotyaa-koteri jempe rontsiritaka owaahanteetaha.” ");
INSERT INTO cpy_vpl VALUES ("S110_23","010_10_23","1SA","10","23","23","Jateeyakini ithotyaa-koetziri jempe ijeeki. Ikanta ramaeteeri Saúl, tema tekatsi monkaatyaarini ikatziyaha. ");
INSERT INTO cpy_vpl VALUES ("S110_24","010_10_24","1SA","10","24","24","Ikantzi Samuel: “¿Piñaakiri ikowakiri Tajorentsi ipinkathari-wenteemi? Tekatsi jaka oshiyaarini irika.” Ikanteeyanakini atziri: “¡Ariwé, riitaki nowinkathariti-teeyaari!” ");
INSERT INTO cpy_vpl VALUES ("S113_1","010_13_1","1SA","13","1","1","Antaritapaaki Saúl retanta-nakawori ipinkathari-wentziri Israel-paeni. Okanta awijanaki apite ojarentsi ipinkathari-tzira, ");
INSERT INTO cpy_vpl VALUES ("S113_2","010_13_2","1SA","13","2","2","riyoyaaki 3,000 rowayirite Israel-paeni. Rookanaki itsipa 2,000 itsipatyaari janta Micmas eejatzi tonkaariki Betel-ki, riyoyaaki itsipa 1,000 jeeka-neentsiri itsipatyaari Jonatán janta Gabaa-ki iipatsiteki Benjamín-paeni. Ikaatzi tzima-haanta-paentsiri atziri, roepiyeeri Saúl riyaatee ipankoki. ");
INSERT INTO cpy_vpl VALUES ("S113_3","010_13_3","1SA","13","3","3","Ithonkaa-takiri Jonatán rowayiritari Filistia-jatzi jeekatsiri omenthaki. Riyotee-yakini Filistia-jatzi okaatzi awijeen-tsiri. Ari itziwoo-takaantaki Saúl riyotan-tyaari maawoeni, tema ikamanteeyatziirini: “¡Pikemi maawoeni Heber-paeni!” ");
INSERT INTO cpy_vpl VALUES ("S113_4","010_13_4","1SA","13","4","4","Maawoeni Israel-paeni riyotaki ithonkaa-takiri Saúl rowayirite Filistia-jatzi. Rootaki ikijaneen-tantariri Filistia-jatzi irika Israel-paeni. Ipiyotee-yakani Saúl janta Gilgal-ki itsipatari atziri-paeni. ");
INSERT INTO cpy_vpl VALUES ("S113_5","010_13_5","1SA","13","5","5","Ipiyotzitaka eejatzi Filistia-jatzi rowayiri-tyaari Israel-paeni. eenitatsi 30,000 ishiyako-mento, 6,000 icaballote, osheki owayiri-paeni kinatsiri jaawiki, roshiyakawo impaneki tzimatsiri antawaaki inkaare. Jataki Micmas, rowetsika-yitaki ipanko-sheta janta ikyaa-piintzi ooryaa Bet-awén-ki. ");
INSERT INTO cpy_vpl VALUES ("S113_6","010_13_6","1SA","13","6","6","Ikanta iñaakiro ikaaripero-takotaki Israel-paeni ithonka-tyeeri Filistia-jatzi, omanee-yanakani impeeta-mooki, shiranta-tapiki, otenkanaa-yitzira eejatzi owaanka-naataha nijaa. ");
INSERT INTO cpy_vpl VALUES ("S113_7","010_13_7","1SA","13","7","7","Montyaanaka itsipa-paeni intatsikironta Jordán-ki, ikinaki iipatsiteki Gad eejatzi rashiki Galaad. Roojatzi ijeeki Saúl rirori janta Gilgal-ki, tema thaawaeyakini rowayirite. ");
INSERT INTO cpy_vpl VALUES ("S113_8","010_13_8","1SA","13","8","8","Ari royaawentaka Saúl okaatzi 7 kitejeri, ari okaatzi kitejeri ikanta-kiriri Samuel. Tee rareetzimaeta Samuel janta Gilgal-ki, piyeeyanaani atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("S113_9","010_13_9","1SA","13","9","9","Ikantaki Saúl: “Pamaki tsimeri atayiniriita Tajorentsi, raapatziyan-teeri.” Riitaki matakirori Saúl itaakiniri. ");
INSERT INTO cpy_vpl VALUES ("S113_10","010_13_10","1SA","13","10","10","Ari ithonki-matakiro Saúl itayiniri, areetapaaka Samuel. Jatanaki Saúl itonkyo-tawakyaari, rowetha-tawakyaari. ");
INSERT INTO cpy_vpl VALUES ("S113_11","010_13_11","1SA","13","11","11","Ikanta-wakiri Samuel: “¿Iitakama pantanta-kawori awijeen-tsiri?” Ikantzi Saúl: “Noñaakiri ipiyeeyani atziri-paeni, noñaakiro tee pareetya pikanta-witakaha. Tema piyotee-yakani Filistia-jatzi janta Micmas-ki. ");
INSERT INTO cpy_vpl VALUES ("S113_12","010_13_12","1SA","13","12","12","Noshiyakaa-mintheetzi ari ipokaki rowayiritina Gilgal-ki, tee nokowako-taajeetziri Tajorentsi. Rootaki notaan-takariri tsimeri. ");
INSERT INTO cpy_vpl VALUES ("S113_13","010_13_13","1SA","13","13","13","Rakanaki Samuel, ikantzi: “Pishinki-wenta-shitaka eeroka pimatan-takawori iroka, tee pimatziro inintakaantziri Tajorentsi Piwinkatharite. Aritaki ishineta-kimiromi Tajorentsi ashi powaeromi pipinkathari-wenteerimi Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S113_14","010_13_14","1SA","13","14","14","Eero piñiimaetawo okijotzi pipinkatharitziira. Ari raminee Tajorentsi itsipa ikoyiri rirori, riitaki rowaeri jewateerini ikaatzi rashitari, tema pipiyatha-takari eeroka ikanta-witakimiri.” ");
INSERT INTO cpy_vpl VALUES ("S115_1","010_15_1","1SA","15","1","1","Ikanta paata Samuel ikantakiri Saúl: “Rotyaan-takina Tajorentsi nojee-patziitotimi peewatantyaariri asheninka Israel-paeni. Pikemijanta-pero-tiro iñaani Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S115_2","010_15_2","1SA","15","2","2","Iroka ikantaki Tajorentsi Shintsi-perori: ‘Nowajankiteri Amalec-jatzi ikosheka-waetakari paerani Israel-paeni ishitowantaari Egipto-ki.’ ");
INSERT INTO cpy_vpl VALUES ("S115_3","010_15_3","1SA","15","3","3","Piyaati, powayiri-tyaari Amalec-jatzi, pithonkiro okaatzi tzimimo-tziriri, eero pineshironka-tziri. Pompojiri shirampari-paeni, tsinane-paeni, eejatzi itomeeriki owakira tzimaentsiri. Pompojiri ipira, rowishate, camello eejatzi iyawayote, maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("S115_4","010_15_4","1SA","15","4","4","Ikaema-kaantakiri Saúl isheninka, ramayi-takiri janta iiteetziro Telaim, ikaatzi 200,000 kineentsiri jaawiki rowayiritya, eenitatsi eejatzi 10,000 isheninka-paeni Judá. ");
INSERT INTO cpy_vpl VALUES ("S115_5","010_15_5","1SA","15","5","5","Jataki Saúl inampi-paeniki Amalec-jatzi, ari ijeekapaaki nijaa-cheraaki. ");
INSERT INTO cpy_vpl VALUES ("S115_6","010_15_6","1SA","15","6","6","Ikantakiri Saúl Cene-jatzi-paeni: “Pishitoye, eero pitsipatari Amalec-jatzi, notsipa-teemi-rikari. Noñaakimi eeroka-paeni osheki pineshironka-takiri Israel-paeni ipoñaan-taari Egipto-ki.” Imatakiro Cene-jatzi-paeni, tee itsipatanaari Amalec-jatzi, rinashitanaa rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("S115_7","010_15_7","1SA","15","7","7","Imatakiro Saúl rowayiritari Amalec-jatzi retanakari Havila-ki, areetaka iiteetziro Shur-ki, katonkonta Egipto-ki. ");
INSERT INTO cpy_vpl VALUES ("S115_8","010_15_8","1SA","15","8","8","Roteyapaakiri iwinkatharite iitachari Agag. Rowathaapaakiri ikaatzi rowayirite, ithonkakiri maawoeni. ");
INSERT INTO cpy_vpl VALUES ("S115_9","010_15_9","1SA","15","9","9","Teemaeta rompojiri Agag, irika Saúl itsipata-karira rowayirite. Ari ikimitaakiri owaneenkari rowishate, ipirapaeni, watha-tatsiri iryaani vaca, tee ithonkiro eejatzi rashaahawo pinapero-tachari. Apatziro ithonkakiro kaari roopero-tatsini, kaari pinapero-tachani. ");
INSERT INTO cpy_vpl VALUES ("S115_10","010_15_10","1SA","15","10","10","Iñaanateeri Tajorentsi irika Samuel, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("S115_11","010_15_11","1SA","15","11","11","“Osheki okantzimo-neentakina nopinkathari-takaa-kirira Saúl, ipakaakina naaka, tee rantziro nokantziriri.” Antawo okantzimoshiryaakari Samuel, roetziñaariko-tanakawo maawoeniki tsireniri ikowako-tziri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S115_12","010_15_12","1SA","15","12","12","Rananinka-shita-nakiri Saúl iñeeri. Ikamantee-takiri, inkanteetziri: “Riyaatatzi Saúl janta Carmel-ki. Ari rowetsikaki taapoki-mentotsi janta, ikanta itapowaeta janta, awijaki ikinanakiro Gilgal-ki. ");
INSERT INTO cpy_vpl VALUES ("S115_13","010_15_13","1SA","15","13","13","Ikanta Samuel riyaataki ijeekira Saúl, ikanta-wakiri: “Riitaki Tajorentsi tajonka-wentimini. Nomonkaa-takiro okaatzi ikanta-kinari Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S115_14","010_15_14","1SA","15","14","14","Ikantzi Samuel: “¿Iitaka ashitariri owisha nokemakiri ikaemi? Nokemakiri eejatzi ikaemi vaca-paeni.” ");
INSERT INTO cpy_vpl VALUES ("S115_15","010_15_15","1SA","15","15","15","Ikantzi Saúl: “Riitaki namakiri ipira Amalec-jatzi. Riitaki inimotakiriri rowayiri-paeni kameethari rowishate, eejatzi kameethari ivacate, ikoyi itayiniri Piwinkatharite Tajorentsi. Nothonki-maetakari itsipa kaari riropero-tatsini.” ");
INSERT INTO cpy_vpl VALUES ("S115_16","010_15_16","1SA","15","16","16","Ikantzi Samuel: “¡Pikemi nokaman-timiro ikanta-kinari tsireniriki Tajorentsi!” Ikantzi Saúl: “Pikantinawo.” ");
INSERT INTO cpy_vpl VALUES ("S115_17","010_15_17","1SA","15","17","17","Ikantzi Samuel: “Piñaawitaka eeroka tee piriiperotzi. Nimaeka peewateeri pisheninka Israel-paeni. Tema ijee-patziitotakimi Tajorentsi pipinkathari-wentantyaariri Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S115_18","010_15_18","1SA","15","18","18","Riitaki Tajorentsi shineta-kimiri pimatiro, ikantakimi: ‘Piyaati, pithonkiri kaaripero-ripaeni Amalec-jatzi, pimaperotiri powayiritiri pithonkiri pompojiri.’ ");
INSERT INTO cpy_vpl VALUES ("S115_19","010_15_19","1SA","15","19","19","¿Iitaka kaari pantantawo ikantzimiri Tajorentsi? Paakiro okaatzi tzimotziriri owayiritani. Kaariperori eeroka iñaakimi Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S115_20","010_15_20","1SA","15","20","20","Ikantzi Saúl: “Nantakiro ikanta-kinari Tajorentsi, nomatakiro okaatzi inintakaakinari. Namakiri Agag iwinkatharite Amalec-jatzi, nothonkakiri maawoeni tzimatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("S115_21","010_15_21","1SA","15","21","21","Apatziro ramaki owayiri-paeni riroperori owisha, eejatzi vaca-paeni ikaatimi ithonkirimi. Ramakiri Gilgal-ki itayiniri Tajorentsi Piwinkatharite.” ");
INSERT INTO cpy_vpl VALUES ("S115_22","010_15_22","1SA","15","22","22","Ikantzi Samuel: “Rootaki ikowa-pero-tziri Tajorentsi pikemijantiri, Tee apatziro ikoyiro pitayiniri pashita-kaariri. Rootaki kowapero-tachari pikemijantiri, eero pipiyatha-waetari, Awijiro pitayiniriri pashita-kaariri iyeenka owisha-paeni. ");
INSERT INTO cpy_vpl VALUES ("S115_23","010_15_23","1SA","15","23","23","Kaaripero rirori piyatha-tariri Tajorentsi, roshiyako-waetari ñaawyaa-waerintsi. Roshiyakotari pinkatha-waetziriri tajorentsi-niro, riitaki ikemijan-tapero-tziri. Aritaki pikanta eeroka, pipiyatha-takawo ikanta-witakimiri. Imanintakimi rirori, tee ikoyi pipinkatharite nimaeka.” ");
INSERT INTO cpy_vpl VALUES ("S115_24","010_15_24","1SA","15","24","24","Iñaanateeri Saúl jirika Samuel, ikantziri: “Ari nokantakari nantakiro kaari kameetha-tatsi, tee nantziro ikanta-witanari Tajorentsi. Nothaawanta-shitakari asheninka-paeni, nantakiniri ikowako-takinari. Pipeyako-tinawo natzimotakimiro kaari kameetha-tatsini. ");
INSERT INTO cpy_vpl VALUES ("S115_25","010_15_25","1SA","15","25","25","Pitsipatina naaka, nokowaki nopiyashi-teeri Tajorentsi nopinkatha-teeri.” ");
INSERT INTO cpy_vpl VALUES ("S115_26","010_15_26","1SA","15","26","26","Ikantzi Samuel: “Eero notsipatzimi, tema pipiyatha-takawo iñaani Tajorentsi. Tee ikowaneemi pipinkathari-wenteeri Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("S115_27","010_15_27","1SA","15","27","27","Rootaki ipiyawi-tanaka Samuel, akotaki Saúl rotaeya-kotawakiri opatziyaakiki iithaari, itzijahaako-tawakiri. ");
INSERT INTO cpy_vpl VALUES ("S115_28","010_15_28","1SA","15","28","28","Ñaawaetanaki Samuel ikanta-nakiri Saúl: “Piitakaawitatya nimaeka pitzijaako-witakinaha, ari ikanteemi Tajorentsi eeroka pipinkathari-wentzirira Israel-paeni. Raapitha-teemiro ipaeri itsipa pisheninka, riroperotanee rirori, rawijaneemi eeroka. ");
INSERT INTO cpy_vpl VALUES ("S115_29","010_15_29","1SA","15","29","29","Ikimoshire-wentziri Tajorentsi irika Israel-paeni, tee itheeyanita, tee roepiya-nitziro iñaani. Kaari atziri roepiya-paante-tantyaari.” ");
INSERT INTO cpy_vpl VALUES ("S115_30","010_15_30","1SA","15","30","30","Rapiita-nakiro Saúl, ikantzi: “Nokaariperotaki. Nokoyi pitsipa-teena apinkathatiri Tajorentsi Piwinkathariti. Nokowatziimi eejatzi iñeemi antaripero Israel-paeni, iñeemi atziri-paeni eekiro piyaata-tyee pitsipateena apinkathatiri Awinkatharite Tajorentsi.”. ");
INSERT INTO cpy_vpl VALUES ("S115_31","010_15_31","1SA","15","31","31","Rapiiteero Samuel ikanteeri Saúl: “Jame apinkatha-teeri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S115_32","010_15_32","1SA","15","32","32","Ikantzi Samuel: “Pamakinari naaka Agag iwinkatharite Amalec-jatzi.” Tee ithaawa-waetzi Agag ramaetakiri ijeekakira Samuel, iñaashitaka awijimotakiri ikaariperotakotzi rompojeeteri. ");
INSERT INTO cpy_vpl VALUES ("S115_33","010_15_33","1SA","15","33","33","Ikanta iñaanata-wakiri Samuel, ikantziri: “Rootaki pishetaa-mento powamaan-takariri osheki atziri-paeni, pikantakaantakiro iroka tsinane-paeni tekatsitanee otomi-paeni. Ari okantee-yaari piniro eeroka.” Akotanaki Samuel, raanakiro iyotsiro-shithakite icheka-chekaa-takiri Agag janta Gilgal-ki, rowamae-motakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S115_34","010_15_34","1SA","15","34","34","Ari ipiyanaa Samuel inampiki janta Ramá-ki, tonkaanee Saúl ipankoki rirori Gabaa-ki. ");
INSERT INTO cpy_vpl VALUES ("S115_35","010_15_35","1SA","15","35","35","Tee rapiiteero Samuel iñeeri Saúl, osheki riraako-waetakari rirori. Tema osheki okantzimo-waetakari Tajorentsi rowakirira ipinkathari-wentiri Saúl Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S116_1","010_16_1","1SA","16","1","1","Ikantakiri Tajorentsi irika Samuel: “¿Jempe okaatzika pipakayiro piraako-waetari Saúl? Tee nokoyi naaka ipinkathari-wenteri Israel-paeni? Payi yeenkantsi, pijayiro pichee-nakitsiteki, piyaata-shiteri Isaí nampitawori Belén-ki, riitaki pinkathari-tatsini itomi.” ");
INSERT INTO cpy_vpl VALUES ("S116_2","010_16_2","1SA","16","2","2","Ikantzi Samuel: “¿Jempe nokantyaaka niyaatan-tyaari? ¡Aririka riyotaki Saúl, ari rowamaakina!” Ikantziri Tajorentsi: “Paanaki ewonkiri vaca, pikantiri: ‘Nopokatzi notayiniri Tajorentsi.’ ");
INSERT INTO cpy_vpl VALUES ("S116_3","010_16_3","1SA","16","3","3","Pikaemiri Isaí pitayirinta piratsi, naaka kantimini oetarika pantiri. Naaka kantimini eejatzi iitarika nokoyiri pijee-patziitotiri ipinkatharitantyaari.” ");
INSERT INTO cpy_vpl VALUES ("S116_4","010_16_4","1SA","16","4","4","Imatakiro Samuel ikanta-kiriri Tajorentsi. Ikanta rareetaka Belén-ki, itonkyo-tawakari jewari-paini, tee itzirinta-pero-tawakari. Rojampi-takiri, ikantziri: “¿Rootakima pipokashitantanari pantinawo okaatzi kamiitha-tzimotinani?” ");
INSERT INTO cpy_vpl VALUES ("S116_5","010_16_5","1SA","16","5","5","Rakanakiri Samuel, ikantziri: “¡Jeen! Rootaki nopokashi-tantziimiri. Jame atayiniri Tajorentsi. Pikite-watha-yitee. Pitsipatina atayiniri.” Imatakiro Samuel ikite-watha-takaakiri Isaí, imatziteeyakarini eejatzi itomipaeni. Ari itsipateeyakarini itaawaeteeyini. ");
INSERT INTO cpy_vpl VALUES ("S116_6","010_16_6","1SA","16","6","6","Ikanta ipokaeyakini, iñaawakiri Samuel irika Eliab, ari ikenkishiryaanaka: “Riitaki irika atziri ikowakaakiri Tajorentsi ipinkathariti.” ");
INSERT INTO cpy_vpl VALUES ("S116_7","010_16_7","1SA","16","7","7","Ikantzi Tajorentsi: “Eero rowapeyimo-tashi-tzimi jempe ikanta-waeta iwathaki, eepenthaki ikatziya. Tee nokowakaeri naaka. Tema tee okameethatzi okaatzi iñaawitari atziri, osheki owapeyimo-witari koñaa-tatsiri. Rooma naaka naminiri ishireki.” ");
INSERT INTO cpy_vpl VALUES ("S116_8","010_16_8","1SA","16","8","8","Ikaemakiri Isaí irika Abinadab, roojatzi iñaantawakari Samuel. Ikantanaki: “Kaari irika ikoyiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S116_9","010_16_9","1SA","16","9","9","Ramaki Isaí itsipa iitachari Sama. Ikantzi Samuel: “Kaari eejatzi irika ikoyiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S116_10","010_16_10","1SA","16","10","10","Ikaatzi 7 itomi Isaí ikaema-witakari iñeeri Samuel, ikanta-waeri: “Kaari irika-paeni ikoyiri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("S116_11","010_16_11","1SA","16","11","11","Rojampi-takiri Samuel irika Isaí, ikantziri: “¿Ari ikaatzi pitomi?” Ikantanakiri rirori: “Eenitatsi apaani iyaapitsi, riyaatatzi raminiri owisha.” Ikantzi Samuel: “Pikaema-kaantiri, ari oyaawakiriita jaka.” ");
INSERT INTO cpy_vpl VALUES ("S116_12","010_16_12","1SA","16","12","12","Rotyaantaki ikaemae-tziri, ramaetakiri iñeeri Samuel, iñaatziri kameetha iñaaperotapaaka, rooperaanikitaki rooki, kameethaaniki-waetaki. Iñaana-shire-takiri Tajorentsi irika Samuel, ikantziri: “Riitaki irika, pijee-patziitotiri.” ");
INSERT INTO cpy_vpl VALUES ("S116_13","010_16_13","1SA","16","13","13","Tee ishenkaanaka Samuel, raakotakiri yeenkantsi, maawoeni iñaako-wentakiri rirentzi ijee-patziitoe-takiri ewankari, ojeekan-tanakari Ishire Tajorentsi irika David. Ikanta ikaatakiro Samuel, jatanee inampiki Ramá. ");
INSERT INTO cpy_vpl VALUES ("S116_14","010_16_14","1SA","16","14","14","Tee ojeekan-tanaari Ishire Tajorentsi irika Saúl, riitaki jeekashiretantanaariri peyari rotyaan-takiniriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S116_15","010_16_15","1SA","16","15","15","Ikanta-witakari romperatanewo Saúl: “Ikyaantashiretatziimi peyari rotyaan-takimiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S116_16","010_16_16","1SA","16","16","16","Tema naaka pomperatanewo, potyaantina namini yotzirori ipiyompiwaetzi. Aririka ikyaantashiretimi peyari, pikanteri ipiyompitakoteemi, ari pithaamenta-shire-taneeyaa.” ");
INSERT INTO cpy_vpl VALUES ("S116_17","010_16_17","1SA","16","17","17","Ikantziri Saúl romperatanewo: “Pamine eeroka yotzirori ipiyompiwaetzi. Aririka piñaaki, pamakinari.” ");
INSERT INTO cpy_vpl VALUES ("S116_18","010_16_18","1SA","16","18","18","Ikantzi apaani romperatanewo: “Irika noñaakiri itomi Isaí poñaachari Belén-ki, riyotziro rirori ipiyompiwaetzi, ñaaperori ikanta, shintsiperori, riroperori owayiri, riyotzi kameetha ikenkitha-waetzi, kameethataanikiri atziri, rawentaari Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S116_19","010_16_19","1SA","16","19","19","Rotyaantaki Saúl kamanterini Isaí, ikantiri: “Potyaan-tinari pitomi David, aminkowentziriri owisha.” ");
INSERT INTO cpy_vpl VALUES ("S116_20","010_16_20","1SA","16","20","20","Imatakiro Isaí, raaki iyawayoti, rotetakiniri owanawontsi, imiriitziri, eejatzi tashirentsi wathatsi. Ipawakiri itomi David raanakiniri Saúl. ");
INSERT INTO cpy_vpl VALUES ("S116_21","010_16_21","1SA","16","21","21","Jataki David iñeeri Saúl, raawakiri rompera-waetyaari. Okanta ojamanitaki rinimotakiri Saúl irika David, riitaki inintakaakiri rametakotapiintiri. ");
INSERT INTO cpy_vpl VALUES ("S116_22","010_16_22","1SA","16","22","22","Rotyaantee Saúl ñaantsi ikantakaan-teeri Isaí: “Nokoyi itsipawaetina David jaka, tema osheki nonintakiri.” ");
INSERT INTO cpy_vpl VALUES ("S116_23","010_16_23","1SA","16","23","23","Ikanta raahashire-tantakariri Saúl peyari rotyaantakiniriri Tajorentsi, ipiyompi-wenteeri David. Thaamentanaa Saúl ikemawakirowa piyompirentsi, rookaneeri peyari. ");
INSERT INTO cpy_vpl VALUES ("S117_1","010_17_1","1SA","17","1","1","Ipiyotakiri Filistia-jatzi rowayirite omana-tachani, ipiyotee-yakani janta Soco-ki iipatsiteki Judá-paeni. Roojatzi ishitowaiyanakini nampitsiki Soco-ki, ari ipanko-sheta-teeyapaakani niyanki-thakineki awotsi areetantyaari Azeca-ki, janta iipatsiteki Efes-damim-jatzi. ");
INSERT INTO cpy_vpl VALUES ("S117_2","010_17_2","1SA","17","2","2","Imatakiro rirori Saúl ipiyotakiri Israel-paeni, ipanko-sheta-teeyakani rirori janta Ela-ki, tema wetsikaeyakani romana-tantyaariri Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("S117_3","010_17_3","1SA","17","3","3","Ijeekae-yakini Filistia-jatzi janta tonkaariki ochempi. Ijeekitaka Israel-paeni intatsikiro otsipaki ochempi omontetari. ");
INSERT INTO cpy_vpl VALUES ("S117_4","010_17_4","1SA","17","4","4","Ari ishitowanaki apaani owayiri iitachari Goliat, ipoñaaka nampitsiki Gat. Okaatzi 6 konakintsi riyomaa-teetziri ijenokitzi ikatziya. ");
INSERT INTO cpy_vpl VALUES ("S117_8","010_17_8","1SA","17","8","8","Aatzinka-paaki Goliat, ikantziri owayiri Israel-paeni: “¿Iitaka powetsikantari powayiritina? Naakataki Filistia-jatzi, eeroka romperatanewo Saúl. Pamini apaani pikaateeyini ipoki rowayiritina. ");
INSERT INTO cpy_vpl VALUES ("S117_9","010_17_9","1SA","17","9","9","Aririka imatakina rowayiritina, eeroka omperateenani. Naakarika matakirini, eeroka-paeni nomperateeya, pantawae-teena.” ");
INSERT INTO cpy_vpl VALUES ("S117_10","010_17_10","1SA","17","10","10","Eekiro ikanta-nakitzi Filistia-jatzi: “Nokoyi nomanatiri Israel-paeni. ¡Potyaantina apaani pisheninka rowayiritina!” ");
INSERT INTO cpy_vpl VALUES ("S117_11","010_17_11","1SA","17","11","11","Ikemantakari Saúl eejatzi maawoeni Israel-paeni ikantaki Filistia-jatzi, ominthaawa-shiryaa-nakiri, antawo ithaawae-yanakini. ");
INSERT INTO cpy_vpl VALUES ("S117_12","010_17_12","1SA","17","12","12","Ikanta David, itomi irika atziri iitachari Isaí, Efrata-jatzi, ipoñaaka nampitsiki Belén ijeekira Judá-paeni. Roojatzi ipinkathariwita Saul, antari-pirotapaaki rirori Isaí. Tzimatsi 8 itomi irika atziri. ");
INSERT INTO cpy_vpl VALUES ("S117_13","010_17_13","1SA","17","13","13","Ari ipokaeyakini mawa itomi Isaí royaatiri Saúl rowayiritya. Iroka iwaeropaeni ikaatzi pokaentsiri: Eliab, jewatatsiri itzimi. Itsipa iita Abinadab. Mawatapaen-tsiri iita Sama. ");
INSERT INTO cpy_vpl VALUES ("S117_14","010_17_14","1SA","17","14","14","Riitaki iyaapitsi irika David. Jateeyanakini nimaeka rantariti-paeni itomi Isaí royaata-nakiri Saúl. ");
INSERT INTO cpy_vpl VALUES ("S117_15","010_17_15","1SA","17","15","15","Ari riyaatapiintzi rirori David ijeekira Saul. Eejatzi ipiya-piya-tapiintzita Belén-ki raminiri rowishati ipaapati. ");
INSERT INTO cpy_vpl VALUES ("S117_16","010_17_16","1SA","17","16","16","Osheki ipiya-piya-tapiintaka Filistia-jatzi roñashirenkiri Israel-paeni, maawoeniki kitejeri eejatzi tsireniriki. Okaatzi 40 kitejeri ipiya-piyatashitakari. ");
INSERT INTO cpy_vpl VALUES ("S117_17","010_17_17","1SA","17","17","17","Ikanta Isaí ikantakiri David: “¡Notyomí! Paanakiniri pirentzi 20 piyateenchari okithoki pankirentsi, eejatzi 10 pan. ");
INSERT INTO cpy_vpl VALUES ("S117_18","010_17_18","1SA","17","18","18","Paanakiniri eejatzi jewatziriri owayiri-paeni okaatzi 10 kijo-petari iteni vaca. Paminaatiri jemperika ikanta pirentzi, pamaena rashitari rirori niyotan-tyaari tekatsi awijimo-tirini pirentzi. ");
INSERT INTO cpy_vpl VALUES ("S117_19","010_17_19","1SA","17","19","19","Jeekatsi Saúl janta nampitsiki Ela itsipatari rirentzi-paeni David eejatzi Israel-paeni, rowayiritari Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("S117_20","010_17_20","1SA","17","20","20","Ikanta ananinkanaki David, rookanakiri rowishate raminiri itsipa atziri. Jatanaki raanakiro okaatzi ikanta-kiriri Isaí. Apatziro rowanakiro janta ipankosheteeyakanira riyaatan-tyaari owayiripaeni romanaitya. Ñaaperoeyanakani ikaemaeyanakini. ");
INSERT INTO cpy_vpl VALUES ("S117_21","010_17_21","1SA","17","21","21","Taamaeyapaakani Filistia-jatzi, imontetapaakari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S117_22","010_17_22","1SA","17","22","22","Ipakiri David ramakiri aminako-wentzirori owayiri-mentotsi. Tee ishenkaa-paaka rirori ojatenka-paaka itaamaeyakanira, rojampiko-wentapaakiri rirentzi jeekatsirika kameetha. ");
INSERT INTO cpy_vpl VALUES ("S117_23","010_17_23","1SA","17","23","23","Ikenkithawae-tamintheetzi, shitowanaki Goliat itaamaakaha owayiri-paeni. Riitaki poñaachari nampitsiki Gat. Rapiitaneero ikaemapae, ikoyi romanatantyaari Israel-paeni. Ikemakiri David. ");
INSERT INTO cpy_vpl VALUES ("S117_24","010_17_24","1SA","17","24","24","Ishiya-pithatari Israel-paeni irika atziri iñaawakirira ipokaki. Osheki ithaawantanakari. ");
INSERT INTO cpy_vpl VALUES ("S117_25","010_17_25","1SA","17","25","25","Ikanteeyini: “¿Piñaakiri pokaentsirika atziri? ¡Ipokatzi romanatee aaka-paeni! Iitarika owamaakirini atzirika, osheki ashaaha-wontsi ipiriri pinkathari, ipityaari eejatzi rishinto iinantyaawo. Ishinetziteeyaanari pinkathari ipaapati owamaakirini ipakahaero rotyaantziniri koriki ikaatzi ikantakaantziri Israel-paeni ipapiintiriri.” ");
INSERT INTO cpy_vpl VALUES ("S117_26","010_17_26","1SA","17","26","26","Rojampi-tanakiri David itsipatakari, ikantziri: “¿Iitaka ipaetiriri owamayiri irika Filistia-jatzi, ipeyanteeyaari irika kantzima-wae-takaeri? ¿Jempe iimatsitaka irika kaariperori Filistia-jatzi ikoshekan-tyaariri rowayirite Tajorentsi Kañaaniri?” ");
INSERT INTO cpy_vpl VALUES ("S117_27","010_17_27","1SA","17","27","27","Rakaeyanakirini atziri-paeni, roojatzi rapiitakiri okaatzi ikantawakaeyarini, ikantziri: “Rootaki ipaetiriri atziri owamaerini Goliat.” ");
INSERT INTO cpy_vpl VALUES ("S117_28","010_17_28","1SA","17","28","28","Ikanta Eliab, rantarite David, ikemaki ikantakiri atziripaeni ikaatee-yinira, ikijanakiri David, ikanta-nakiri: “¿Iitakama pipokantari eeroka jaka? ¿Iitakama pookanakiri aminerini ikaamatsitzira powishati janta ochempiki? Niyotzimi pikanta eeroka, oetarika pikenkishiryaari, pipokashiwaeta piñeeri owayiri-tachari.” ");
INSERT INTO cpy_vpl VALUES ("S117_29","010_17_29","1SA","17","29","29","Akanaki David, ikantzi: “¿Iitakama nantakiri? ¿Apatziro nokenkitha-waetashita? ");
INSERT INTO cpy_vpl VALUES ("S117_30","010_17_30","1SA","17","30","30","Ipiyaa-pitha-tanakari rirentzi, rojampi-takiri itsipa. Roojatzi ikantziriri ikantee-takiriri inkaahanki. ");
INSERT INTO cpy_vpl VALUES ("S117_31","010_17_31","1SA","17","31","31","Ikanta ikemaetakiri David okaatzi ikantakiri, ikamantee-takiri Saúl. Ikaema-kaantakiri rirori. ");
INSERT INTO cpy_vpl VALUES ("S117_32","010_17_32","1SA","17","32","32","Ikantakiri David irika Saúl: “¡Pinkatharí! Eero ikantzimo-shire-waetee irinta. Naaka pomperatanewo, niyaati nomanatiri irinta Filistia-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("S117_33","010_17_33","1SA","17","33","33","Ikantzi Saúl: “Eero okanta piyaatzi apaniroeni powayiri-tyaari irinta Filistia-jatzi, tekira pantari-pero-tziita. Retzitakawo paerani rirori rowayirita eeniro rewankari-tapaaki.” ");
INSERT INTO cpy_vpl VALUES ("S117_34","010_17_34","1SA","17","34","34","Ikantzi David: “Naaka pomperatanewo, tema naaka aminiriri rowishate nopaapate. Ipokawitaka manitzi, maeni, ratsikawitapaakari apaani owisha ipiyoteeyanira. ");
INSERT INTO cpy_vpl VALUES ("S117_35","010_17_35","1SA","17","35","35","Noyaatako-wentanakiri naapitha-tawaeri ipaanteki. Ikowawita ratsikena naaka, noteeyanakiri inomaki nompojakiri, nowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("S117_36","010_17_36","1SA","17","36","36","Riirika manitzi, eejatzi-ririka maeni, ari nowamaakiri. Ari nokantzitakyaari jirinta kaariperori Filistia-jatzi. Tema osheki retashitakari rowayirite Tajorentsi Kañaaniri. ");
INSERT INTO cpy_vpl VALUES ("S117_37","010_17_37","1SA","17","37","37","Riitaki Tajorentsi aakowen-takinari ratsikinami manitzi, ratsikinami eejatzi maeni, ari raakowen-takina eejatzi rowamayinami irinta Filistia-jatzi.” Ikantzi Saúl: “Piyaate, riitaki Tajorentsi aminakowentimini.” ");
INSERT INTO cpy_vpl VALUES ("S117_38","010_17_38","1SA","17","38","38","Ikanta Saúl, ipakaantakiri iithaari, ikithaatakaetyaari David. Ramanthee-teeteri kijonakiri, ikyaanta-kahaetyaari kijotakiri ishipaneeki. ");
INSERT INTO cpy_vpl VALUES ("S117_39","010_17_39","1SA","17","39","39","Ikithaa-witakawo David irokapaeni, iñaanta-witakawo ranashitakaayaawomi. Tee imapiin-tziro ikithaa-tyaawo irokapaeni. Ikantakiri Saúl: “Eero omata nanashi-takayiro irokapaeni, tee nametyaawo.” Raatonkorya-haawo maawoeni. ");
INSERT INTO cpy_vpl VALUES ("S117_40","010_17_40","1SA","17","40","40","Raaneero ikotzi, rowiitanaki 5 kameeroyinari mapiki nijaateniki, rotetanakiro ithaateki ithaantakotanakiro. Roteeyanakiro ijeewithate, riyaatashitanakiri Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("S117_41","010_17_41","1SA","17","41","41","Noshikaka rirori Filistia-jatzi itonkyo-tyaari David. Riitaki jewatatsiri romperatanewo. ");
INSERT INTO cpy_vpl VALUES ("S117_42","010_17_42","1SA","17","42","42","Ikanta raminawakiri Filistia-jatzi irika David, iñaatziiri eeniro riryaanitzi, kameetha iñaaperotapaaka, rooperaanikitaki rooki, kameethaanikitaki rirori. Tee ithaawantari. ");
INSERT INTO cpy_vpl VALUES ("S117_43","010_17_43","1SA","17","43","43","Ikanta-wakiri: “¿Naakama otsitzi piñaakina pamashi-tantanari inchaki?” Ithaenki-mawae-tanakiri David raakotanakiri itajorentsi-tetashitari. ");
INSERT INTO cpy_vpl VALUES ("S117_44","010_17_44","1SA","17","44","44","Ikantaki eejatzi Filistia-jatzi: “¡Pipokeeta, nopimiri piwatha royaawo tzijo eejatzi owantaniri!” ");
INSERT INTO cpy_vpl VALUES ("S117_45","010_17_45","1SA","17","45","45","Rakanakiri David irinta Filistia-jatzi, ikantziri: “Pamashi-takina eeroka piyotsiro-shithakite, pichekopite. Rooma naaka nopoka-shitakimi nawentaawo iwaero Tajorentsi Shintsi-perori, ashitariri rowayirite Israel-paeni, ikaatzi pikowakiri eeroka powayiri-tyaari. ");
INSERT INTO cpy_vpl VALUES ("S117_46","010_17_46","1SA","17","46","46","Ishinetakimi Tajorentsi nowamaemi, aritaki nothatyaakimi nimaeka. Maawoeni iwatha-paeni powayiriti nopiri tzijo royaawo eejatzi katsimari owantaniri. Ari riyoetee maawoeniki kepatsi eenitatsi Itajorentsite Israel. ");
INSERT INTO cpy_vpl VALUES ("S117_47","010_17_47","1SA","17","47","47","Riyote ikaatzi piyoteen-chari jaka tee rowawijaako-tantawo Tajorentsi chekopi, kotsiro-shithaki. Iroka owayiri-taantsi rashi Tajorentsi, riitaki shineta-kimiri eeroka-paeni nowamaayitimi.” ");
INSERT INTO cpy_vpl VALUES ("S117_48","010_17_48","1SA","17","48","48","Ipoñaashitanakari Filistia-jatzi, ipokashi-tapaakiri David. Tee ishenkaetaanaka rirori David, ishiyashi-tanakari ipiyatyaari Filistia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("S117_49","010_17_49","1SA","17","49","49","Kyaawakotanaki ithaateki, raaki imapikite, ijeewithatakiri Filistia-jatzi, rompojakiri itamakoki. Tyaanaki kepatsiki Filistia-jatzi roojatzi owikapaaka mapiki itamakoki. ");
INSERT INTO cpy_vpl VALUES ("S117_50","010_17_50","1SA","17","50","50","Ari ikantakiro David rotsinampaan-takariri Filistia-jatzi. Apatziro raanaki ijeewithate eejatzi imapikite rowamaantyaariri. Tee otzimimo-witari David iyotsiro-shithakite. ");
INSERT INTO cpy_vpl VALUES ("S117_51","010_17_51","1SA","17","51","51","Ishiyashi-tapaakari David ikatziyimotapaakari okaakiini. Romijokii-tapaakiri iyotsiro-shithakite, ithatyii-tapaakiri iito. Ikanta iñaako-wentakiri Filistia-jatzi-paeni rowamaetakiri riroperori rowayirite, shiyeeyanakani rirori-paeni. ");
INSERT INTO cpy_vpl VALUES ("S117_52","010_17_52","1SA","17","52","52","Royaakyaa-tanakiri Israel-paeni eejatzi Judá-paeni, antawo ikaemae-yanakini royaakyaa-tanakirira. Rowamaawakiri osheki rowayirite Filistia-jatzi, ishitowakaapaakiri Saaraim-ki rawijakaanakiri Gat-ki eejatzi Ecrón-ki. ");
INSERT INTO cpy_vpl VALUES ("S118_5","010_18_5","1SA","18","5","5","Imatakiro David maawoeni okaatzi ikantziriri Saúl. Rootaki ikowantanakari Saúl reewateri rowayirite. Osheki rinimotakiri rowayirite eejatzi inampina-paini Saúl. ");
INSERT INTO cpy_vpl VALUES ("S118_6","010_18_6","1SA","18","6","6","Ikanta ipiyeeyaani owayiri-paeni rowamaakirira David irika Filistia-jatzi, opokaeyapaakini tsinani-paeni jeekayitatsiri maawoeniki nampitsi inampitawo Israel-paeni. Owetheeyawaeyaarini pinkathari Saúl, okimoshiretaeyanakini, omampahaeyani, otzironkaeyani Opaimatakaanakakiri otampooñakite tzimatsiri ithataneeriki. ");
INSERT INTO cpy_vpl VALUES ("S118_7","010_18_7","1SA","18","7","7","Iroka okantziro omampa-haeyani tsinani-paeni: Ikaatzi 1000 atziri rowamaakiri Saúl, 10,000 ikaatzi rowamaakiri David. ");
INSERT INTO cpy_vpl VALUES ("S118_8","010_18_8","1SA","18","8","8","Rootaki owatsimaan-tanakiriri Saúl ikemakirowa mampaantsi. Ikantanaki: “Tema ikanteetakiri 10,000 ikaatzi rowamaakiri David. Rooma naaka ikaamatsitzi 1000 nowamaakiri. ¡Intsipaeti ipinkathariti rirori!” ");
INSERT INTO cpy_vpl VALUES ("S118_9","010_18_9","1SA","18","9","9","Rootaki roonantanakariri Saúl irika David. ");
INSERT INTO cpy_vpl VALUES ("S118_10","010_18_10","1SA","18","10","10","Okanta otsipa kitejeri, ikyaantashiretakari Saúl peyari rotyaan-takiniriri Tajorentsi. Shinki-wentanaka iwinkathari-pankoteki. Pokaki David romampaawentyaari ikimi-tapiin-tzirowa. Raanakiro Saúl roshetaamento. ");
INSERT INTO cpy_vpl VALUES ("S118_11","010_18_11","1SA","18","11","11","Ikoyi Saúl rosheteerimi David riyonkakotantyaarimi tantotsiki. Rowawijaa-wijaa-takiro roshetaamento. ");
INSERT INTO cpy_vpl VALUES ("S118_12","010_18_12","1SA","18","12","12","Ithaawantanakari Saúl David. Tema Tajorentsi ipakaanakiri Saúl. Riitaki David ramitakotaneeri. ");
INSERT INTO cpy_vpl VALUES ("S118_13","010_18_13","1SA","18","13","13","Rootaki rookanta-kariri Saúl irika David, tema rowakiri reewateeri 1000 owayiri-paeni. Riitaki jatatsini rowayiritya, ipiyee eejatzi. ");
INSERT INTO cpy_vpl VALUES ("S118_14","010_18_14","1SA","18","14","14","Riitaki Tajorentsi amitako-tziriri David, okaatzi rantayi-tziri kameetha okanta. ");
INSERT INTO cpy_vpl VALUES ("S118_15","010_18_15","1SA","18","15","15","Rootaki ithaawan-tantariri Saúl irika David, iñaakirira kameetha okanta rantayi-tziri. ");
INSERT INTO cpy_vpl VALUES ("S118_16","010_18_16","1SA","18","16","16","Ikowaperoeyakirini David maawoeni Israel-paeni eejatzi Judá-paeni, riitaki jewatziriri jemperika ikinayitzi romanayitya. ");
INSERT INTO cpy_vpl VALUES ("S119_1","010_19_1","1SA","19","1","1","Ikantakiri Saúl itomi iitachari Jonatán eejatzi reewarite rowayirite, ikantziri: “Powamayiri David.” Iro kanteencha, osheki retakotakari Jonatán irika David. ");
INSERT INTO cpy_vpl VALUES ("S119_2","010_19_2","1SA","19","2","2","Ikamantakiri David, ikantakiri: “Ikowatzi rowamaemi nopaapate. Paamaayaari inkaamani, piyaate pijeeki pomanapiintaha. ");
INSERT INTO cpy_vpl VALUES ("S119_3","010_19_3","1SA","19","3","3","Ari niyaate naaka notsipa-tyaari nopaapate jaha pijeekakira eeroka. Nokenkitha-waeta-kayiri, nokemiri jempe ikantina, aritaki nokaman-takimi okaatzi ikantinari. ");
INSERT INTO cpy_vpl VALUES ("S119_4","010_19_4","1SA","19","4","4","Ikenkithawae-takaakiri Jonatán irika Saúl, ikantako-wentziri David. Ikantakiri: “¡Pinkatharí! Tee okameethatzi powaariperotiri pomperatanewo, David. Tekatsi ikantimi rirori, tema rantapiin-tzimiro maawoeni kameetha-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("S119_5","010_19_5","1SA","19","5","5","Ishinetakiro rañaa-mento imatanta-kariri rowamayiri Filistia-jatzi. Ari ikantakiro Tajorentsi ikijako-wentaari maawoeni Israel-paeni. Piñaakiro eeroka, nowinkatharite, osheki pikimoshiretanaki. ¿Iitaka pikowantari powamayiri David? Tema tekatsi rantani rirori.” ");
INSERT INTO cpy_vpl VALUES ("S119_6","010_19_6","1SA","19","6","6","Ikanta ikemawaki Saúl ikanta-kiriri Jonatán, ikantanaki: “¡Riyotzi Tajorentsi, eero ikami David!” ");
INSERT INTO cpy_vpl VALUES ("S119_7","010_19_7","1SA","19","7","7","Ikaemakiri Jonatán irika David, ikamantakiri okaatzi ikenkitha-waetakiri. Raaneeri ijeekira Saúl, jeekapae David ikimi-piin-taha paerani. ");
INSERT INTO cpy_vpl VALUES ("S119_8","010_19_8","1SA","19","8","8","Apiitanaa owayiri-taantsi. Jatanee David rowayiriteri Filistia-jatzi. Imatakiri. Imapero-takiri, romishiyakiri. ");
INSERT INTO cpy_vpl VALUES ("S119_9","010_19_9","1SA","19","9","9","Ikanta peyari rotyaan-tziri Tajorentsi, ikyaantashiretapaari Saúl. Jeekaki ipankoki roteeyanakiro roshetaa-mento ikema-mintha-tziri David ipiyompiwaetzi. ");
INSERT INTO cpy_vpl VALUES ("S119_10","010_19_10","1SA","19","10","10","Rapiiwi-taawo riyontaakoteerimi David tantotsiki. Rowawijaawaero David roshetaa-mento Saúl, oshetaashi-tapaaka tantotsiki. Tee ishenkaanaki David, shiyaka tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("S119_11","010_19_11","1SA","19","11","11","Ikantakiri Saúl rowayirite: “Paminakiteri ipankoki David, ari pijeekawentapaakiri. Okiteji-tamaneerika, roojatzi powamaantakyaari.” Roo kanteencha okamantakiri Mical, iina David, okantakiri: “Eerorika pishiya iroka tsirenirika, aritaki rowamahaetakimi inkaamani.” ");
INSERT INTO cpy_vpl VALUES ("S119_12","010_19_12","1SA","19","12","12","Aashitakiri Mical shiwitha, rootaki owayiitakotanakariri David jaawiki. Shiyanaka rirori. ");
INSERT INTO cpy_vpl VALUES ("S128_3","010_28_3","1SA","28","3","3","Kamae Samuel, osheki rowashiretakotakari maawoeni Israel-paeni, ikiteetakeri inampiki Ramá-ki. Ikanta Saúl romishtowa-wetakawo inampiki sheri-piyaari-paeni eejatzi yotako-shire-tantatsiri. ");
INSERT INTO cpy_vpl VALUES ("S128_4","010_28_4","1SA","28","4","4","Piyotee-yakani Filistia-jatzi, pokaeyanakini ipanko-sheta-teeyapaakani Sunem-ki rowayiritantya. Imatakiro Saúl rirori, ipiyotakiri Israel-paeni, panko-sheta-teeyakani Gilboa-ki. ");
INSERT INTO cpy_vpl VALUES ("S128_5","010_28_5","1SA","28","5","5","Ikanta Saúl iñaakiro ipanko-sheta Filistia-jatzi, antawo ithaawanaki, itzinka-shiryaanakiri. ");
INSERT INTO cpy_vpl VALUES ("S128_6","010_28_6","1SA","28","6","6","Ikowakowi-takari Tajorentsi, tee rakiri, tee imishitakaaneeri. Tee iyotakaaneeri Urim eejatzi kamantan-taniri. ");
INSERT INTO cpy_vpl VALUES ("S128_7","010_28_7","1SA","28","7","7","Ikantakiri Saúl romperatanewo: “Pamini sheri-piyaawo, niyaata-shiteroota nojampitero.” Ikantanakiri rompera-tanewo: “Eenitatsi apaani tsinani poñaachari Endor-ki, sheri-piyaawo roori.” ");
INSERT INTO cpy_vpl VALUES ("S128_8","010_28_8","1SA","28","8","8","Ikithaa-tanaka Saúl otsipa kithaa-rentsi eero iyotantawakari. Itsipata-nakari apite atziri. Jatanaki rareetyaawo iroka tsinani. Ikantapaakiro: “Nokoyi pinkaema-shireenari nokantakimiri. Pamakinari ishire atziri nokoyiri naaka.” ");
INSERT INTO cpy_vpl VALUES ("S128_9","010_28_9","1SA","28","9","9","Okantanaki tsinani: “Piyotakiro eeroka rantakiri Saúl, romishitowakiri sheri-piyaari-paeni eejatzi yotako-shire-tantatsiri. ¿Iitaka piñaa-shirinka-tanari, rooma pikoyi rowamahaetina?” ");
INSERT INTO cpy_vpl VALUES ("S128_10","010_28_10","1SA","28","10","10","Ikanta-nakiro: “Riitaki yotatsi Tajorentsi eero pashironkaa-waeta, tekatsi owajanki-terimi.” ");
INSERT INTO cpy_vpl VALUES ("S128_11","010_28_11","1SA","28","11","11","Kowanaki tsinani, okantziri: “¿Iitaka pikoyiri nokaemakotimiri?” Ikantanakiro Saúl: “Nokoyi pikaemako-tinari Samuel-ni.” ");
INSERT INTO cpy_vpl VALUES ("S128_12","010_28_12","1SA","28","12","12","Oñaatziiri tsinani irika Samuel-ni, antawo okaemanaki. Okantakiri Saúl: “¿Iitaka pamatawi-tantanari? Eeroka-taki Saúl.” ");
INSERT INTO cpy_vpl VALUES ("S128_13","010_28_13","1SA","28","13","13","Ikantaki pinkathari: “Eero pithaawa-kaawo, ¿iitaka piñaakiri?” Okantzi tsinani: “Noñaaki osheki tajorentsi-witachari rateetziro jenoki.” ");
INSERT INTO cpy_vpl VALUES ("S128_14","010_28_14","1SA","28","14","14","Ikantzi Saúl: “¿Jempe ikanta-waetaka?” Okantzi roori: “Antariki rini, ikithaatawo owewiryaakoro.” Riyotanaki Saúl riitaki Samuel, rotziwerowanaka ipinkatha-tanakiri. ");
INSERT INTO cpy_vpl VALUES ("S128_15","010_28_15","1SA","28","15","15","Ñaawaetanaki Samuel-ni, ikantziri: “¿Iitaka poñaa-shirenkan-tanari pikaema-kaantana?” Ikantziri Saúl: “Antawo okantzimo-shiryaakina, rowayiri-mintha-takina Filistia-jatzi. Rookawen-takina Tajorentsi, tee rakina nokowako-witari, tee romishimpyaana eejatzi. Nokanta-witari kamantantaniri, tekatsi ikantinari. Rootaki nokaeman-tzimiri eeroka pikantina iitarika nanteri.” ");
INSERT INTO cpy_vpl VALUES ("S128_16","010_28_16","1SA","28","16","16","Ikantzi Samuel: “¿Iitaka pojampi-tantanari naaka? Tema rookawen-tanakimira Tajorentsi, ikija-neentanakimi. ");
INSERT INTO cpy_vpl VALUES ("S128_17","010_28_17","1SA","28","17","17","Imatakimi Tajorentsi okaatzi ikamanta-kinari naaka jempe ikantemi. Rookakahaemiro pipinkathari-witaha, ipinkathari-takahaeri David, pitsipaminthari. ");
INSERT INTO cpy_vpl VALUES ("S128_18","010_28_18","1SA","28","18","18","Tema tee pikemijantziri ikanta-witakimiri, tee pithonkiri Amalec-jatzi. Rootaki piñaanta-kawori tee rakaemi Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("S128_19","010_28_19","1SA","28","19","19","Ikowaki Tajorentsi ithonkiri Filistia-jatzi irika Israel-paeni. Ari itsipataakimi eeroka eejatzi. Okiteji-tamaneerika pitsipa-teena naaka eejatzi pitomi-paeni. Ishinetakiri Tajorentsi Filistia-jatzi itsinampaeteri rowayirite Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("S128_20","010_28_20","1SA","28","20","20","Antawo ithaawanaki Saúl, ikemakirira Samuel-ni. Oshipetashiryaapaakiri, tyaanaki jaawiki, omaryaa-penthaakii-tapaaka. Apaani kitejeri eejatzi apaani tsireniri tee rowaeya. ");
INSERT INTO cpy_vpl VALUES ("S128_21","010_28_21","1SA","28","21","21","Okanta oñaakiri tsinani ithaawanaki Saúl, opokashi-tapaakiri, okantziri: “Nomatakimiro pikowako-takinari. Noshinewentakimi. ");
INSERT INTO cpy_vpl VALUES ("S128_22","010_28_22","1SA","28","22","22","Nokoyi powawakya eepichokiini, pishintsitantaneeyaari, piyaa-tantaneeyaari.” ");
INSERT INTO cpy_vpl VALUES ("S128_23","010_28_23","1SA","28","23","23","Tee ikowawitya Saúl royaa. Ishintsitashitakari inampina-paeni eejatzi tsinani, roojatzi ikowantanakari royaa. Piriintanaa, jeekanee omaamentoki. ");
INSERT INTO cpy_vpl VALUES ("S128_24","010_28_24","1SA","28","24","24","Owamaaki tsinani opira, owetsikaki pan kaari shineyatsini. ");
INSERT INTO cpy_vpl VALUES ("S128_25","010_28_25","1SA","28","25","25","Aanakiniri Saúl rowanawo. Ari rowaeyakani itsipatakari inampina-paeni. Ikanta ikaatakiro rowaka, katziyanaka, jateeyaneeni tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("S131_1","010_31_1","1SA","31","1","1","Ikanta Filistia-jatzi rowayiri-mintha-takari Israel-paeni. Romishiyee-takiri Israel-paeni, rowamaahaantawaki janta ochempiki Gilboa-ki. ");
INSERT INTO cpy_vpl VALUES ("S131_2","010_31_2","1SA","31","2","2","Royaakyaa-teetanakiri Saúl itsipataa-nakiri itomi-paeni. Rompojee-takiri Jonatán, Abinadab eejatzi Malquisúa, itomi-paeni Saúl. ");
INSERT INTO cpy_vpl VALUES ("S131_3","010_31_3","1SA","31","3","3","Ari ipatha-wenteeta-nakari Saúl, romanateetziri, ikentee-takiri. Antawo ithaawanaki. ");
INSERT INTO cpy_vpl VALUES ("S131_4","010_31_4","1SA","31","4","4","Ikanta-nakiri inampina: “Pinojokero piyotsiroshithakite, powatheena eeroka. Tee nokoyi rompojina irika kaariperori, ishiron-tawentina.” Tee ikoyimaeta inampina, antawo ithaawaki. Raakiro rirori Saúl iyotsiroshithakite, ipatsitanakawo apaniroeni. ");
INSERT INTO cpy_vpl VALUES ("S131_5","010_31_5","1SA","31","5","5","Ikanta inampina Saúl iñaakirira ikamaki, imatzita-nakawo eejatzi rirori, ipatsitanakawo iyotsiroshithakite, apitekirote ikamanaki. ");
INSERT INTO cpy_vpl VALUES ("S131_6","010_31_6","1SA","31","6","6","Ari okanta ikamantakari Saúl, itsipatakari mawa itomi, inampina, eejatzi rowayirite-paeni. ");
INSERT INTO cpy_vpl VALUES ("S25_1","011_5_1","2SA","5","1","1","Ikanta isheninka-paeni Israel riyaata-shitakiri David janta Hebrón-ki, ikantakiri: “Naakataki pisheninka-paeni okaakiini. ");
INSERT INTO cpy_vpl VALUES ("S25_2","011_5_2","2SA","5","2","2","Eerokataki jewatakinari paerani nowayiri-yitakari ipinkathari-tzira Saúl. Riitaki Tajorentsi kantzi-takimiri: Eeroka jewateerini Israel-paeni, Pipinkathari-wenteeri nashitaari.” ");
INSERT INTO cpy_vpl VALUES ("S25_3","011_5_3","2SA","5","3","3","Imatakiro eejatzi antari-wentziriri Israel-paeni, riyaata-shitakiri David janta Hebrón-ki, ikantakiri: “¡Jame aapatziya-wakahaeya! ¡Riitaki yotatsini Tajorentsi eero amatawi-tawaa-kaanta!” Ari ijee-patziito-takiri David ipinkathari-wenteeri maawoeni Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("S25_4","011_5_4","2SA","5","4","4","Okaataki David 30 rojarentsite ipinkathari-tantanakari. Okaatzitaka 40 ojarentsi ojamanitaki ipinkathariwentantzi. ");
INSERT INTO cpy_vpl VALUES ("S25_5","011_5_5","2SA","5","5","5","Awijanakiro 7 ojarentsi okaatzi ipinkatharitaki paerani rirori Hebrón-ki. Rooma Jerusalén-ki okaatzi 33 ojarentsi ipinkathari-wentakiri Israel-paeni, eejatzi Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("S25_6","011_5_6","2SA","5","6","6","Jataki David Jerusalén-ki itsipata-nakari rowayirite romanateri Jebus-paeni, riitaki ashitawori inampi janta. Ikenkishiryaa-witaka Jebus-paeni eero imatziro David ikye inampiki. Ikantakiri: “Eero pimatziro pikye nonampiki. Ari rooka-matsi-tawakimi mawityaakiri itsipata-kyaari amashi-tachari iitziki.” ");
INSERT INTO cpy_vpl VALUES ("S25_9","011_5_9","2SA","5","9","9","Roo kanteencha, imatakiro David raakiro owayiri-panko jeekatsiri Sión-ki, iiteetakiro ‘Inampi David.’ Kameetha itanto-takiro janta oweyaa-thapitaha, retanakawo taapiki Milo roojatzi ojeekira pankotsi. ");
INSERT INTO cpy_vpl VALUES ("S25_10","011_5_10","2SA","5","10","10","Eekiro otzimimo-tatziiri ishintsinka David, itsipatakari Tajorentsi. Tema Tajorentsi, riitaki Shintsi-perori. ");
INSERT INTO cpy_vpl VALUES ("S27_1","011_7_1","2SA","7","1","1","Ari ijeekaki pinkathari David ipankoki. Ishinetakiri Tajorentsi imakoryaawaki rowayiritari kijaneentziriri. ");
INSERT INTO cpy_vpl VALUES ("S27_2","011_7_2","2SA","7","2","2","Ikenkithawae-takaakiri David kamantan-taniri Natán, ikantakiri: “Piñiiro eeroka nopanko, iyoshiitaka jantarikota. Rooma itajorentsi-nakite Tajorentsi ipanko-sheta-tashiitakawo.” ");
INSERT INTO cpy_vpl VALUES ("S27_3","011_7_3","2SA","7","3","3","Ikanta-nakiri Natán: “¡Pinkatharí! Pantero okaatzi pikenkikshiryaakari, tema Tajorentsi riitaki ñaana-shire-tzimiri.” ");
INSERT INTO cpy_vpl VALUES ("S27_4","011_7_4","2SA","7","4","4","Okanta otsireni-tanaki iñaanatakiri Tajorentsi irika Natán, ikantakiri: ");
INSERT INTO cpy_vpl VALUES ("S27_5","011_7_5","2SA","7","5","5","“Piyaata-shiteri nomperatanewo, David, pikanteri: ‘Iroka ikantzi Tajorentsi: ¿Eerokama wetsikinani pankotsi nojeekan-tyaari? ");
INSERT INTO cpy_vpl VALUES ("S27_6","011_7_6","2SA","7","6","6","Roojatzi paerani nomishitowantaariri Egipto-ki irika Israel-paeni, tee nojeekan-tyaawo pankotsi, apatziro nanashi-nashi-waetashita nojeekantawo pankotsi-sheta, rootaki notajorentsi-thaantete. ");
INSERT INTO cpy_vpl VALUES ("S27_7","011_7_7","2SA","7","7","7","Osheki ojarentsi notsipa-takari Israel-paeni, tee nokowakotziri ikaatzi nowakiri jewaterini Israel-paeni, rowetsikina jantari-panko nojeekan-tyaari.’ ");
INSERT INTO cpy_vpl VALUES ("S27_8","011_7_8","2SA","7","8","8","Pikanteri nomperatanewo, David: ‘Ikantzimi Tajorentsi Shintsi-perori: “Naakataki amakimi pijeekawita owaantsiki paminakowentziri owisha, pimatantyaawori pipinkathari-wenteeri Israel-paeni, nashitanaari. ");
INSERT INTO cpy_vpl VALUES ("S27_9","011_7_9","2SA","7","9","9","Tee nookawentzimi jempe pikinayitzi, nashiryaakari ikaatzi owayiri-tzimiri. Ithonka ikemakoe-teemi jemperika, poshiyako-teeyaari riroperori-paeni jeekatsiri jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("S27_10","011_7_10","2SA","7","10","10","Noñaaki jempe ijeekae nashitanaari Israel-paeni, ari inampi-pero-teeyaawo, tekatsi oñaa-shirenkaerini. Eero itzimae kaariperori kosheka-waetee-yaarini ikimita-haetzirira paerani ");
INSERT INTO cpy_vpl VALUES ("S27_11","011_7_11","2SA","7","11","11","nowantakariri jewatziriri nashitaari Israel-paeni. Ari pijeeka-shiwae-teeya, eero piñaahaeri romanawae-teemi ikaatzi kijaneentzimiri.’ Ikantzi eejatzi Tajorentsi: ‘Ari noshekya-haeri picharini-tyaari.’ ");
INSERT INTO cpy_vpl VALUES ("S27_12","011_7_12","2SA","7","12","12","Aririka omonkaa-takya okaate panteri, pikamaerika, ari itzimae pitomi, riitaki poyaatemini ipinkatharite. ");
INSERT INTO cpy_vpl VALUES ("S27_13","011_7_13","2SA","7","13","13","Riitaki wetsikinani nopanko. Ari notajonka-wentakiri, ashi rowatyeero ipinkatha-wentante ikaatzi icharini-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("S27_14","011_7_14","2SA","7","14","14","Riitaki notyomintaari naaka. Ipaapatziteena rirori. Rantakirorika kaariperori, naakataki owajanki-terini ikimi-tapiintaha atziri ipajatziri itomipaeni. ");
INSERT INTO cpy_vpl VALUES ("S27_15","011_7_15","2SA","7","15","15","Ashi nowaero noneshironkateri. Eero noshiya-kayiri Saúl nopakaakiri noneshironka-tziri. Tee añahaeri rirori, eeroka poyaataariri. ");
INSERT INTO cpy_vpl VALUES ("S27_16","011_7_16","2SA","7","16","16","Ashi rowaero ipinkathari-yitee picharinitaneeyaari eejatzi eeroka. Ari okantee-tatyeeyaani ipinkathari-wentantee.” ");
INSERT INTO cpy_vpl VALUES ("S27_17","011_7_17","2SA","7","17","17","Imatakiro Natán ikamantakiri David okaatzi ikemakiri, eejatzi okaatzi roñaahaetakiriri. ");
INSERT INTO cpy_vpl VALUES ("S211_1","011_11_1","2SA","11","1","1","Okanta otsipaki ojarentsi, rootaki kitejeri rametapiin-teetawowa rotyaan-teetziri owayiri-paeni romanatya. Rotyaan-teeri David Joab itsipatakari jewatziriri rowayirite, raaneeri maawoeni owayiri Israel-paeni. Rashiryaakari Amon-jatzi-paeni, ithonkakiro itapotakawo nampitsi Rabá. Roojatzi ijeekaki David rirori Jerusalén-ki. ");
INSERT INTO cpy_vpl VALUES ("S211_2","011_11_2","2SA","11","2","2","Ikanta tsireniityaanaki ooryaa, piriintanaka David romaryaakaha imaantareki. Ateetanaki jenoki okameetha-pankaatzira iwinkathari-pankote, ari raminako-takiro okaawoshi-waeta tsinani, kameethaanikitaki roori. ");
INSERT INTO cpy_vpl VALUES ("S211_3","011_11_3","2SA","11","3","3","Rojampiko-wentakiro David iroka tsinani. Ikematzi ikantee-tziri: “Iroka tsinani oeta Betsabé, rishinto Eliam. Rootaki iina Urías, isheninka Het-paeni.” ");
INSERT INTO cpy_vpl VALUES ("S211_4","011_11_4","2SA","11","4","4","Rotyaantaki David aakiteroni tsinani. Opokashitanakiri roori, oñiiri. Ari itsipatakawakaawo tsireniriki. Okanta omatakiro okite-watha-tantanee-yaari, jatee opankoki. ");
INSERT INTO cpy_vpl VALUES ("S211_5","011_11_5","2SA","11","5","5","Motzitanaki tsinani, otyaantaki kamanterini David. ");
INSERT INTO cpy_vpl VALUES ("S211_6","011_11_6","2SA","11","6","6","Rotyaantaki David kanterini Joab: “Ikantzi pinkathari: ‘Paakiteri Urías, isheninka Het-paeni.’” Imatakiro Joab, raakitziri. ");
INSERT INTO cpy_vpl VALUES ("S211_7","011_11_7","2SA","11","7","7","Ikanta riyaata-shitakiri Urías pinkathari David, rojampi-tawakiri ikantziri: “¿Te imantsiyatzi Joab? ¿Tee imantsiyatzi owayiripaeni eejatzi? ¿Jempe okantakotaka owayiri-taantsi?” ");
INSERT INTO cpy_vpl VALUES ("S211_8","011_11_8","2SA","11","8","8","Ikantakiri eejaatzi: “Piyaatee pipankoki, pikiwakiitzi-tapaeya.” Ari ishitowanaki Urías pinkathari-pankoki, opakaantakiri David owanawontsi ipankoki Urías. ");
INSERT INTO cpy_vpl VALUES ("S211_9","011_11_9","2SA","11","9","9","Tee riyaatzimaeta Urías ipankoki, roojatzi ijeekaki pinkathari-pankoki itsipatakari owayiri-paeni aminakowentziriri pinkathari tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("S211_10","011_11_10","2SA","11","10","10","Ikamantee-takiri David tee imaapae Urías ipankoki. Rojampi-takiri David irika Urías, ikantziri: “¿Iitaka kaari pimaantapaa pipankoki? ¿Teema pimakotzi piyaayi-tzira jemperika-paeni?” ");
INSERT INTO cpy_vpl VALUES ("S211_11","011_11_11","2SA","11","11","11","Rakanakiri Urías, ikanta-nakiri: “Tee okameetha-perotzi pankotsi ojeekantari tajorentsinaki. Ari oshiyawo imaantari owayiri Israel-paeni, eejatzi Judá-paeni. Ari okantari eejatzi imaantari Joab, jewatziriri powayirite. ¿Tee okameethatzi niyaate nowawae-tapaeya naaka nopankoki, nomaapaeta notsipata-paeyaawo noena? ¡Tee inimotena naaka nowinkatharite!” ");
INSERT INTO cpy_vpl VALUES ("S211_12","011_11_12","2SA","11","12","12","Ikantzi David: “Ari pimaanee nimaeka, okiteji-tamanee piyaatee.” Ari ijeekanee Urías Jerusalén-ki roojatzi okiteji-tamaneerika. ");
INSERT INTO cpy_vpl VALUES ("S211_13","011_11_13","2SA","11","13","13","Rakiyotakiri David irika Urías, ipakotakiri osheki imiri, ishinki-takiri. Okanta otsireni-tanaki, jataki Urías imayi itsipata-paari rowayirite pinkathari, teemaeta riyaatee ipankoki. ");
INSERT INTO cpy_vpl VALUES ("S211_14","011_11_14","2SA","11","14","14","Okanta okiteji-tamanee, rojanki-nataki David rotyaan-teniri Joab, riitaki awijakiro Urías. ");
INSERT INTO cpy_vpl VALUES ("S211_15","011_11_15","2SA","11","15","15","Iroka okantzi rojankinari: “Riitaki petya Urías pitaamaheri jempe okoweenka-perotzi owayiri-taantsi. Ikentee-teriita, ikameeta.” ");
INSERT INTO cpy_vpl VALUES ("S211_16","011_11_16","2SA","11","16","16","Imatakiro Joab. Ikanta itapotakiro nampitsi rowayiritero, rowakiri Urías jempe ijeeki riroperori owayiri-paeni, ");
INSERT INTO cpy_vpl VALUES ("S211_17","011_11_17","2SA","11","17","17","ishitoyee-yanakini kijakotawori inampi, roma-natakiri Joab. Ari ikentee-takiri eewatziriri rowayirite David, ari imaetakiriri eejatzi Urías. ");
INSERT INTO cpy_vpl VALUES ("S211_18","011_11_18","2SA","11","18","18","Rotyaantaki Joab jankina-rentsi ikenkitha-takotziro okaatzi awijeen-tsiri omana-rentsiki, ikoyi riyotero David awijeen-tsiri. ");
INSERT INTO cpy_vpl VALUES ("S211_19","011_11_19","2SA","11","19","19","Ikantakiri aanakirori jankina-rentsi: “Arika pikaatakiro pikamanteri pinkathari jempe okantakota omana-rentsi, ");
INSERT INTO cpy_vpl VALUES ("S211_20","011_11_20","2SA","11","20","20","piñaatyeeri ikijanakya pinkathari, ikantemi: ‘¿Iitaka piyaata-shitan-tawori okaakiini nampitsi powayiritawo? ¿Tema piyote kantacha ikameetha-tzimotemi ichekopite ateeteen-tsiri otantoki nampitsi? ");
INSERT INTO cpy_vpl VALUES ("S211_21","011_11_21","2SA","11","21","21","¿Pimaesan-takiroma awijeen-tsiri paerani Tebes-ki rompojan-teeta-kariri Abimelec, itomi Jerobaal? ¿Tema okameetha-tzimo-takiro tsinani opetoki tononka-mentotsi ojeekaki jenoki otantoki nampitsi? ¿Iitaka piyaata-shitan-takawori okaakiini otantoki nampitsi?’ Pakanakiri eeroka pikanteri: ‘Kamaki eejatzi Urías isheninka Het-paeni eewatziriri powayirite’” ");
INSERT INTO cpy_vpl VALUES ("S211_22","011_11_22","2SA","11","22","22","Jataki kamanterini pinkathari. Ikanta rareetaka ikamantakiri David okaatzi ikanta-kiriri Joab otyaanta-kiriri. ");
INSERT INTO cpy_vpl VALUES ("S211_23","011_11_23","2SA","11","23","23","Rakanaki amakirori ñaantsi ikanta-nakiri David: “Ishitoyee-yanakini owayiri-paeni kijakotawori inampi retanakawo romanatee-yakinani. Ari nopiyata-nakari, nomishiyakiri. Nopatzima-tanakiri areetakina ikyaa-piintee-tzira inampiki. ");
INSERT INTO cpy_vpl VALUES ("S211_24","011_11_24","2SA","11","24","24","Ateetapaaki otantoki nampitsi, roma-natzimaetana. Ari ikenteetaki eewatziriri powayirite Pinkathari. Iri ikentee-takiri eejatzi Urías, isheninka Het-paeni, kamaki.” ");
INSERT INTO cpy_vpl VALUES ("S211_25","011_11_25","2SA","11","25","25","Rakanaki David ikanta-nakiri amakirori ñaantsi: “Pikanteri Joab eero okantzimo-shire-waetari iroka, ashi oyiro omana-rentsi. Riyaata-kayiro rowayiri-tyaari irikaete, roojatzi raperaa-tanta-kyaari. Poemintha-takae-yaari eeroka rowayiritya.” ");
INSERT INTO cpy_vpl VALUES ("S211_26","011_11_26","2SA","11","26","26","Okemako-wentakiri iina Urías ikamaki, owashire-takowae-takari oemi. ");
INSERT INTO cpy_vpl VALUES ("S211_27","011_11_27","2SA","11","27","27","Okanta okaatzimo-takiro owashire-takotari oemi, ikaema-kaantakiro David, roejeekaero iwinkathari-pankoteki, iinantaawo. Owaeyan-takiri rowakaa-kirori. Teemaeta inimotziri Tajorentsi okaatzi rantakiri David. ");
INSERT INTO cpy_vpl VALUES ("S212_1","011_12_1","2SA","12","1","1","Rotyaan-teeri Tajorentsi kamantan-taniri Natán iñeeri David. Ikanta rareetaka Natán ijeekira pinkathari, ikenkithawae-takaakiri, ikantziri: “Eenitatsi apite atziri jeekatsiri nampitsiki. Ashaahan-tzikari rini, itsipa tekatsi tzimimo-terini. ");
INSERT INTO cpy_vpl VALUES ("S212_2","011_12_2","2SA","12","2","2","Itzimimo-tziri osheki rowishate, ivacate irika ashaahan-tzinkari, ");
INSERT INTO cpy_vpl VALUES ("S212_3","011_12_3","2SA","12","3","3","riima ashironkaenkari apatziro ramaanta-matsitaka iryaani owisha, ipiratakari. Itsipa-minthari royiri itomipaeni, rakiyotziri rowanawo, rirakotziri imiri, ari itsipatari imaapiintzi. Roshiya-kaantari roomi rishinto. ");
INSERT INTO cpy_vpl VALUES ("S212_4","011_12_4","2SA","12","4","4","Ikanta ipokaki areetariri atziri ashaahan-tzinkari. Tee ikowe rowamaye rowishate, ivacate rowapaa-kyaari pokatsiri rareetakari. Riitaki rayitaki rowishate ashironkaenkari, rowamaakiri rowakae-yaari areetariri.” ");
INSERT INTO cpy_vpl VALUES ("S212_5","011_12_5","2SA","12","5","5","Antawo rowatsimaa-nakiri David kantawae-tachari atziri, ikanta-nakiri Natán: “¡Riitaki Tajorentsi kemenani tee notheeya, otzimatye rompojeeteri antakirori iroka! ");
INSERT INTO cpy_vpl VALUES ("S212_6","011_12_6","2SA","12","6","6","Otzimatye roepiye 4 owisha, ipinatan-teeyaariri ashitariri rowashironkaakiri.” ");
INSERT INTO cpy_vpl VALUES ("S212_7","011_12_7","2SA","12","7","7","Ikantzi Natán: “¡David! Eerokataki irika atziri. Riitaki Pawa Itajorentsite Israel, kanteentsi: ‘Naakataki owakimi pipinkathari-wenteri Israel-paeni, tee noshinetemi rompojemi Saúl. ");
INSERT INTO cpy_vpl VALUES ("S212_8","011_12_8","2SA","12","8","8","Nopakimiro pikempoyaero pinkathari-panko, eejatzi iinapaeni pitsipatari pinkathari-pankoki. Noshine-takimi pipinkathari-wenteeri Israel-paeni eejatzi Judá-paeni. Teera ari okaate iroka, ari nopakimi otsipa awijirori iroka. ");
INSERT INTO cpy_vpl VALUES ("S212_9","011_12_9","2SA","12","9","9","¿Iitaka pipiyatha-tanta-kariri Tajorentsi, pikaaripero-tzimo-tanta-kariri? Powakaantakari Urías, isheninka Het-paeni, pamamena-takawo powayiritari Amón-jatzi, payiteeri iina. ");
INSERT INTO cpy_vpl VALUES ("S212_10","011_12_10","2SA","12","10","10","Ari ashi owatyeero nimaeka rompojan-teete pipankoki, okantakaan-tziro pipiyatha-takina, payiteeri iina Urías, isheninka Het-paeni, piinantaawo.” ");
INSERT INTO cpy_vpl VALUES ("S212_11","011_12_11","2SA","12","11","11","Ikantaki eejatzi Tajorentsi: “Naakataki kanta-kahae-yaawoni itzime pitomipaeni maemane-temini. Nokanta-kaeyaari pisheninkaete raapitha-teemiro piinaete, piñaamin-theteri rapitewae-tyaawo kitejeriki. ");
INSERT INTO cpy_vpl VALUES ("S212_12","011_12_12","2SA","12","12","12","Pantawi-takawo eeroka pomanani-kiini irokapaeni, rooma naaka eero nomanakaawo othonka iñaayitiro Israel-paeni, kitejeriki ranteetero.” ");
INSERT INTO cpy_vpl VALUES ("S212_13","011_12_13","2SA","12","13","13","Ikanta-nakiri David irika Natán: “¡Nokaaripero-tzimo-takiri Tajorentsi!” Rakanakiri Natán irika David: “Eero rowashironkaa-wentzimiro Tajorentsi piyaariperonaka, eero pikami. ");
INSERT INTO cpy_vpl VALUES ("S212_14","011_12_14","2SA","12","14","14","Riitaki kamatsini peenchaanite owakira tzimaen-tsiri. Tema pikijima-takaan-takiri Tajorentsi pantakiro iroka.” ");
INSERT INTO cpy_vpl VALUES ("S212_15","011_12_15","2SA","12","15","15","Ikanta ipiyaawo Natán ipankoki, ikantakaanakawo Tajorentsi omapokanaka imapero-tanaka imantsiya-tanaki reenchaanikite David rowaeyan-takaa-kirori iinani Urías. ");
INSERT INTO cpy_vpl VALUES ("S212_16","011_12_16","2SA","12","16","16","Osheki David ikowako-takiri Tajorentsi eero ikamanta reenchaanite, tee rowaeya. Tee imahae imaantariki, romaryahawaetaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("S212_17","011_12_17","2SA","12","17","17","Ipokashi-witari antariite jeeka-panko-tziri ikoyi rowiriin-teeri romaryahakaha kepatsiki, tee ikowe ipiriinte. Tee rakiyoteeri rowaeyanira antariite. ");
INSERT INTO cpy_vpl VALUES ("S212_18","011_12_18","2SA","12","18","18","Okanta awijaki 7 kitejeri kamaki eenchaanikiri. Tee ikamanteri rompera-tanewopaeni David ithaawa-kaatyaari, ikamanta-wakaeyani: “Eeniro rañaawitaha eenchaanikiri, tee ikemijantee akanta-witariri. Rootaki owakirari nimaeka ikamaki, aritaki imapero-tanakya akamanta-kiriri kamaki reenchaanite.” ");
INSERT INTO cpy_vpl VALUES ("S212_19","011_12_19","2SA","12","19","19","Ikanta David iñaakiri ikamanta-wakaeyani rompera-tanewo, riyotanaki kamaki reenchaanite. Rojampi-tanakiri, ikantziri: “¿Kamakima eenchaanikiri?” Ikanteeyini rompera-tanewo: “Jeen, kamaki.” ");
INSERT INTO cpy_vpl VALUES ("S212_20","011_12_20","2SA","12","20","20","Ari ipiriintana David roma-ryahakaha kepatsiki, ikithaa-tanaawo ikithaari, owaneenka-tanaa, itziritanaa kajankari, ikithaa-tanaawowa otsipa ikithaari. Jataki itajorentsi-pankoteki Tajorentsi ipinkatha-teeri. Piyapaa ipankoki, ikowapaaki owanawontsi, iitakiri, owapaa. ");
INSERT INTO cpy_vpl VALUES ("S212_21","011_12_21","2SA","12","21","21","Ikanta rompera-tanewopaeni David, rojampi-takiri ikantziri: “¿Iitaka pantakiri? Eeniro rañaawita eenchaanikiri, iitaka kaari pikowanta poyaa, piraawaetaka. Ari kamaki eenchaanikiri, ari pipiriin-tanaawo powanta-naari.” ");
INSERT INTO cpy_vpl VALUES ("S212_22","011_12_22","2SA","12","22","22","Ikantanaki David: “Eeniro rañaawita eenchaanikiri, tee nowaa, niraawaetaka, nokantashiretzi: Oshiyaka ari ineshironka-teena Tajorentsi, eero ikamanta eenchaanikiri. ");
INSERT INTO cpy_vpl VALUES ("S212_23","011_12_23","2SA","12","23","23","Ari ikamaki nimaeka, ¿iitaka nomasheka-wenteri? ¿Irima nowiriin-teeri? ¡Noyaawentya niyaate noñaapaeri, tema eero imateero rirori ipiyee iñaapaena!” ");
INSERT INTO cpy_vpl VALUES ("S212_24","011_12_24","2SA","12","24","24","Ikanta David roemo-shirenkaero iina Betsabé. Riyaataki iñiiro, rapitetaawo. Ari okanta owaeyan-tanta-kariri otomi, iitakiri Salomón. Osheki ineshironka-takiri Tajorentsi irika eenchaanikiri. ");
INSERT INTO cpy_vpl VALUES ("S212_25","011_12_25","2SA","12","25","25","Riitaki Natán kamanta-kiriri David. Rootaki iitanta-kariri Jedidías irika eenchaanikiri. ");
INSERT INTO cpy_vpl VALUES ("K11_1","012_1_1","1KI","1","1","1","Tema antari-pero-tapaaki pinkathari David, oshekitaki rojarentsite. Ipewiryaa-kowiteetari osheki iithaari, teemaeta ijaawatzi. ");
INSERT INTO cpy_vpl VALUES ("K11_2","012_1_2","1KI","1","2","2","Ikantakiri romperatani: “¡Pinkatharí! ¿Pikoyi naminemi ewankawo? Rootaki aminemini, opashikaemi, otsipatemi pimayi ojaawantemi.” ");
INSERT INTO cpy_vpl VALUES ("K11_3","012_1_3","1KI","1","3","3","Jataki ithotyaakotzi kamethaa-nikiro ewankawo maawoeni inampiki Israel-paeni. Iñaaki ewankawo iitachari Abisag poñaachari Apimakoryaariniki. Rootaki ramakiniriri pinkathari. ");
INSERT INTO cpy_vpl VALUES ("K11_4","012_1_4","1KI","1","4","4","Maperori okamethaa-nikitzi Abisag. Rootaki aminapaa-kiniriri okaatzi ikowayi-tziri pinkathari, teemaeta iinantawo. ");
INSERT INTO cpy_vpl VALUES ("K11_32","012_1_32","1KI","1","32","32","Opoñaashita ikantaki pinkathari David: “Pikaeminari Ompera-tajorentsitaa-rewo Sadoc, Kamantan-taniri Natán, Benaía itomi Joiada.” Ari ipokaeyakini rirori iñiiri pinkathari. ");
INSERT INTO cpy_vpl VALUES ("K11_33","012_1_33","1KI","1","33","33","Ikantawakiri: “¡Nosheninká! Pitsipa-tanakyaari nomperatani-paeni, ikyaakae-yaari nopira notyomi Salomón, paanakiri Shipopo-shaariniki. ");
INSERT INTO cpy_vpl VALUES ("K11_34","012_1_34","1KI","1","34","34","Eeroka Sadoc Ompera-tajorentsitaa-rewo eejatzi Kamantan-taniri Natán, pijee-patzii-toteri notyomi Salomón omatant-yaari ipinkathari-wenteeri asheninka-paeni Israel-paeni. Pitziwooteeyini janta, pikaemaeyini eejatzi, pikante: ‘¡Irikawé pinkathari Salomón!’ ");
INSERT INTO cpy_vpl VALUES ("K11_35","012_1_35","1KI","1","35","35","Ompoñaashitya poyaatee-yirini itaapiiki aririka ipiyee, roojatzi ijeekan-tapaa-kyaari nowinkathari-mentoki, tema riitaki poyaateenani. Tema riitaki niyoshii-takiri ipinkathari-wenteeri asheninka-paeni Judá-paeni, eejatzi itsipapaeni Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("K11_36","012_1_36","1KI","1","36","36","Ari rakanaki Benaía itomi Joiada, ikantzi: “¡Pinkatharí! Aritaki okantyaari. Riitaki Pitajorentsite nintakaan-tzirori. ");
INSERT INTO cpy_vpl VALUES ("K11_37","012_1_37","1KI","1","37","37","Riitaki Tajorentsi tsipata-piintakimiri eeroka, okantashitzimaetya ari ikimitzitaiyaari eejatzi Salomón, ikantakae-yaawo imaperotero ipinkatharitee rirori.” ");
INSERT INTO cpy_vpl VALUES ("K11_38","012_1_38","1KI","1","38","38","Ikanta Ompera-tajorentsitaa-rewo Sadoc, Kamantan-taniri Natán, Benaía itomi Joiada, Peyakaa-shitaniri-paeni, Akoryantzi-paeni, ikyaakotanakari Salomón ipiraki pinkathari David, raanakiri Shipopo-shaariniki. ");
INSERT INTO cpy_vpl VALUES ("K11_39","012_1_39","1KI","1","39","39","Ari raaki Ompera-tajorentsitaa-rewo Sadoc waakapa eejatzi yeenkantsi, jeekatsiri tajorentsi-thaanteki, ijeepatzii-totakiri Salomón. Ari ikaatzi itziwootee-yanakini maawoeni janta, ikaemae-yanakini ikanteeyini: “¡Irikawé pinkathari Salomón!” ");
INSERT INTO cpy_vpl VALUES ("K12_1","012_2_1","1KI","2","1","1","Tema rooteentsi ikami pinkathari David, ikaemakaan-takiri Salomón, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("K12_2","012_2_2","1KI","2","2","2","“¡Notyomí! Kimitaka rooteentsi nojoweyi, niyaatatyee jempe ikinayitzi maawoeni atziri. Pitonta-shire-pero-te eeroka, pishirampari-pero-te. ");
INSERT INTO cpy_vpl VALUES ("K12_3","012_2_3","1KI","2","3","3","Panta-piinteero rompera-tzimiri Tajorentsi, pithotyaa-yiteero iwinkakaantani, ikantakaantani, ishineta-kaantani eejatzi ishintsi-thatan-tziri, okaatzi jankina-teenchari ñaantsi riyotahaeri owaejatziteni Moisés, rootaki iyaatan-tyaari kameetha oetarika pantayi-teeri, tekatsi awijimo-temini jempe-rika pikinayite. ");
INSERT INTO cpy_vpl VALUES ("K12_4","012_2_4","1KI","2","4","4","Ari imonkaa-terori Tajorentsi okaatzi ikashiya-kaakinari, ikantakina: “Kyaari-pero-rika ikemijanteena ikaate picharini-teeyaari, kameetha-rika roshire-teena, rawentaa-shire-teena, ashi rowaero ikaate picharini-teeyaari ipinkathari-wenteeri pisheninka-paeni Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("K12_10","012_2_10","1KI","2","10","10","Tema makoryaaki David. Ikiteetakiri iiteetziro “Inampi David”. ");
INSERT INTO cpy_vpl VALUES ("K12_11","012_2_11","1KI","2","11","11","Ojamani ipinkathari-wentakiri David paerani isheninka-paeni Israel-paeni okaatzi 40 ojarentsi. Retakawo ipinkatharitaki nampitsiki Aripero-taariniki okaatzi 7 ojarentsi, eejatzi nampitsiki Aapatziyaweniki okaatzi 33 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("K12_12","012_2_12","1KI","2","12","12","Ikanta retanakawo ipinkathari-tanaki Salomón, ipoyaataari ipaapate. Riitaki matakirori ijeekakaantaki kameetha. ");
INSERT INTO cpy_vpl VALUES ("K15_1","012_5_1","1KI","5","1","1","Ari ikemakiri Hiram pinkathari-tatsiri Mapiniki ikanteetzi: “Ijeepatzii-toetakiri Salomón, ipoyaataari ipaapate.” Tema irika Hiram osheki retakota-piintakari pinkatharini David, rotyaantaki inampina-paeni iñiiri Salomón. ");
INSERT INTO cpy_vpl VALUES ("K15_2","012_5_2","1KI","5","2","2","Ikanta Salomón rirori, rotyaantaki kamanterini Hiram, ikanteri: ");
INSERT INTO cpy_vpl VALUES ("K15_3","012_5_3","1KI","5","3","3","“Piyotzi eeroka tee imatziro ashitanarini David rowetsikeniri itajorentsi-pankote Tajorentsi jempe ipinkatheetero iwaero, okantakaan-tziro romana-mintha-tziri iijaneentani. Roo kanteencha, Tajorentsi kantakaawori rotsinampaan-takariri maawoeni owayirita-piintariri. ");
INSERT INTO cpy_vpl VALUES ("K15_4","012_5_4","1KI","5","4","4","Rootaki ijeekakaan-teenari Tajorentsi kameetha. Tekatsi owayiriteenani, eero natsipe-taawo kowaenkayi-tatsiri-paeni. ");
INSERT INTO cpy_vpl VALUES ("K15_5","012_5_5","1KI","5","5","5","Rootaki nokowantari nowetsikiniri itajorentsi-pankote Tajorentsi jempe ipinkathee-teero iwaero, tema ikashiya-kaakari paerani ashitanari, ikantakiri: ‘Riitaki pitomi poyaatee-mini paata ipinkathari-wentante, riitaki wetsikae-nawoni notajorentsi-pankote, jempe ipaeryahae-teero nowaero janta.’ ");
INSERT INTO cpy_vpl VALUES ("K15_6","012_5_6","1KI","5","6","6","¡Pinkatharí! Pikanteri patzirite-paeni itoyina inchato-paeni tzimatsiri janta Kiteniitoniki, aritaki ramitako-takiri natzirite-paeni naaka. Jempe-rika okaate pikoyiri nopinatemi rantawaeri patzirite, aritaki nomatakiro. Piyotzi eeroka tekatsi nosheninka-paeni yoteroni itoyiro kameetha roshiya-kotyaari pijeeka-nampi-tziri Shimaa-jatzi-paeni.” ");
INSERT INTO cpy_vpl VALUES ("K16_1","012_6_1","1KI","6","1","1","Aritaki imatakiro Salomón ipinkathari-wentziri isheninka-paeni Israel-paeni okaatzi 4 ojarentsi, riitaki apiteta-tsiri kashiri, iiteetziri “Shipakiryaari”. Aripaete retanakawo Salomón rowetsikiniri itajorentsi-pankote Tajorentsi. Tema aritaki ojamanitaki okaatzi 480 ojarentsi ishitowan-taari Israel-paeni Apitantoniki. ");
INSERT INTO cpy_vpl VALUES ("K16_38","012_6_38","1KI","6","38","38","Ikanta awijaki 11 ojarentsi ipinkatharitzi Salomón, riitaki 8-tatsiri kashiri iiteetziri “Owiitaantsi”, ithonkae-takiro rowetsikae-tziro tajorentsi-panko, rowetsikae-takiro jempe okaatzi ikenkishiryahae-takari rowetsikaetero. Tema okaatzi 7 ojarentsi ojamanitaki ithonkan-teeta-kawori rowetsika-kaantakiro pinkathari Salomón. ");
INSERT INTO cpy_vpl VALUES ("K111_1","012_11_1","1KI","11","1","1","Okanta paata, irika pinkathari Salomón osheki tsinani inintaki. Inintakiro rishinto iwinkatharite Apitantoni-jatzi. Imatzitakawo inintakiro Athataa-weni-jato, Pityaankaarini-jato, Kiraapeerini-jato, Shimaa-jato, Thaawantaa-rewoni-jato. ");
INSERT INTO cpy_vpl VALUES ("K111_2","012_11_2","1KI","11","2","2","Rootaki ipinkakaa-witakariri Tajorentsi paerani Israel-paeni, ikantakiri: “Pipinkayitero maawoeni tsinani poñaayitachari otsipaki nampitsi, omatakaemiro-kari pipinkathateri eeroka tajorentsi-niro-paeni.” Roo kanteencha Salomón, osheki inintakiro iroka-paeni tsinani, iinantakawo. ");
INSERT INTO cpy_vpl VALUES ("K111_3","012_11_3","1KI","11","3","3","Okaatzi 700 iinanta-pero-takari, otsipa okaatzi 300 ishirontani, rootaki iinapaeni oetzimpina-shire-takiriri. ");
INSERT INTO cpy_vpl VALUES ("K111_4","012_11_4","1KI","11","4","4","Ikanta rantyashipari-tapaaki Salomón, oetzimpina-shire-takiri iinapaeni ipinkatha-waeteri tajorentsi-niro-paeni. Tee ikameetha-shire-tzimo-teeri Tajorentsi, tee roshiyaari David, ipaapateni. ");
INSERT INTO cpy_vpl VALUES ("K111_5","012_11_5","1KI","11","5","5","Ipinkatha-waetakiri Salomón tajorentsi-niro Ompokiromae, itajorentsi-nirote Shimaa-jatzi. Ipinkatha-waetakiri eejatzi tajorentsi-niro iiteetziri “Pinkathari Itaawentee-tziri Eenchaa-niki-paeni”, riitaki itajorentsi-nirote Pityaankaarini-jatzi. Riiyitaki tajorentsi-niro-paeni ipinkayitemi. ");
INSERT INTO cpy_vpl VALUES ("K111_6","012_11_6","1KI","11","6","6","Rantashi-takawo Salomón kaari inimoterini Tajorentsi, tee ikyaaryootzi roshire-tyaari, tee roshiyaari David, ipaapateni. ");
INSERT INTO cpy_vpl VALUES ("K111_7","012_11_7","1KI","11","7","7","Rowetsikaki Salomón ikaapapankote tajorentsi-niro iiteetziri “Otsinampaan-taniri” janta tonkaariki Aapatziyaweniki jempe ishitowa-piintzi ooryaa. Tema ipinkaetani itajorentsi-nirote Athataa-weni-jatzi. Ipoñaa rowetsikakiri eejatzi roshiya-kaawo tajorentsi-niro ‘Pinkathari Itaawentee-tziri Eenchaa-niki-paeni’, tema ipinkaetani eejatzi itajorentsi-nirote Pityaankaarini-jatzi. ");
INSERT INTO cpy_vpl VALUES ("K111_8","012_11_8","1KI","11","8","8","Ari ikimitaakiri eejatzi ashi maawoeni iinapaeni poñaayi-tachari otsipaki nampitsi, riitaki otaapiintziniri kajankaenkari, otayi-niriri otajorentsi-nirote atsipeta-kaani-paeni. ");
INSERT INTO cpy_vpl VALUES ("K111_9","012_11_9","1KI","11","9","9","Ari ikijanakiri Tajorentsi irika pinkathari Salomón, okantakaan-tziro tee ikowaneeri, tee ikenkishire-taanaari Itajorentsite Israel, ipakaanakiri ikemijantziri, jempe itzimi apiiwitakariri roñaahawi-takari. ");
INSERT INTO cpy_vpl VALUES ("K111_10","012_11_10","1KI","11","10","10","Ikantawi-takari: “Eero pipinkatha-tziri tajorentsi-niro-paeni.” Roo kanteencha Salomón, ipiyatha-takari Tajorentsi ikantawi-tariri. ");
INSERT INTO cpy_vpl VALUES ("K111_11","012_11_11","1KI","11","11","11","Rootaki ikantan-takariri Tajorentsi, ikantziri: “¡Salomón! Omaperota pipiyathatakina, tee pithotyahae-ro nokashiya-kaemiri, ari pimitaakiro nojankina-takaantani nokanta-witakimiri. Ari okaatapaaki nopinkathari-takaakimi, riitaki nopinkathari-takahaeri nimaeka pomperatani. ");
INSERT INTO cpy_vpl VALUES ("K111_12","012_11_12","1KI","11","12","12","Roo kanteencha, eero nookakae-tzimiro eeroka, osheki netakotakari ashitzimiri David, riitakira pitomi nookakaeri ipinkatharitzi tekira-wita imonkaatero. ");
INSERT INTO cpy_vpl VALUES ("K111_13","012_11_13","1KI","11","13","13","Eeromaeta nooka-kaeri maawoeni ipinkatharite. Aritaki nowanaki apaani ikaatzi isheninkata-wakaayita, riitaki Judá-paeni. Rootaki nanteri tema osheki netakotakari paerani David, nomperatani. Netakotzi-takawo eejatzi inampi, Aapatziyaweni.” ");
INSERT INTO cpy_vpl VALUES ("K111_26","012_11_26","1KI","11","26","26","Imatakiro Jeroboam, itomi Nabat, poñaachari Poshini-pathaniki. Tema irika Jeroboam, romperatani Salomón, ipoñaawo nampitsiki Katsinka-weniki, riitaki isheninka icharini-paeni Efraín. Kinankawo ashitariri oeta Zerúa. ");
INSERT INTO cpy_vpl VALUES ("K111_27","012_11_27","1KI","11","27","27","Iroka opoñaantari Jeroboam ikoshekari pinkathari: Tema itanto-takitziiro Salomón maawoeni inampi David, ipaapateni, rowetsikakiro Tamako-pathani. ");
INSERT INTO cpy_vpl VALUES ("K111_28","012_11_28","1KI","11","28","28","Irika Jeroboam, shintsiperori atziri, tekatsi pomeentsi-tzimo-tyaarini. Ikanta iñaakiri Salomón irika ewankari shirethatzinkari, rompera-takari raminayitero okaatzi rashiyitari icharini-paeni José, iwaejatziteni. ");
INSERT INTO cpy_vpl VALUES ("K111_29","012_11_29","1KI","11","29","29","Okanta paata, jataki Jeroboam ikinawaetzi ipoñaanakawo Aapatziyaweniki. Ari itonkiyo-takari Kamantan-taniri Ahías, poñaachari Makoryeeroniki. Iñaakiri ipokaki ipashikakawo owakira-mawori iwashika-mento. Apaniroeni itonkiyota-wakari, tekatsi itsipatyaa. ");
INSERT INTO cpy_vpl VALUES ("K111_30","012_11_30","1KI","11","30","30","Raakiro Ahías owakirari ipashikakari, itzijaakiro, okaatzi 12-japeeriki. ");
INSERT INTO cpy_vpl VALUES ("K111_31","012_11_31","1KI","11","31","31","Ikantziri Jeroboam: “Payi eeroka 10 ojapeki, tema rootaki ikantakiri Tajorentsi, Itajorentsite Israel, ikantzi: ‘Ari notzijahaero naaka iwinkathari-mento Salomón, tema eeroka nokowaki pipinkathari-wenteeri ikaate 10 isheninkata-wakahaeyani Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("K111_32","012_11_32","1KI","11","32","32","Riima Salomón, apatziro apaani ipinkathari-wenteeri rirori ikantakaan-tziro netakotani nomperatani David, ipinkathari-wenteero eejatzi Aapatziyaweni, tema rootaki nampitsi nokowakiri. Tee oshiyawo otsipa inampi isheninka-paeni Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("K111_33","012_11_33","1KI","11","33","33","Tema ipiyatha-takina Salomón, ithaamenta-shitakari ipinkatha-waetziri Ompokiromae, itajorentsi-nirote Shimaa-jatzi, Otsinampaan-taniri, itajorentsite Athataa-weni-jatzi. Imatzitakari “Pinkathari Itaawentee-tziri Eenchaa-niki-paeni”, itajorentsite Pityaankaarini-jatzi. Okaatzi rantakiri Salomón, tee inimotana noñaakiro, tee rithotyahanawo nojankina-takaantani eejatzi noshine-takaantani, tee roshiyaari David, ipaapateni. ");
INSERT INTO cpy_vpl VALUES ("K111_34","012_11_34","1KI","11","34","34","Roo kanteencha, eero naapitha-tziri ipinkatharitzi. Tekira ikamanakiita, eekiro reewari-tatyee, okantakaawo netakotari paerani ashitaririni, David, nomperatani, jempe itzimi nashitakari naaka, jempe itzimi thotyaa-kirori nokanta-kaantani eejatzi nojankina-takaantani. ");
INSERT INTO cpy_vpl VALUES ("K111_35","012_11_35","1KI","11","35","35","Eeromaeta ipinkatharitee itomi Salomón, eeroka nokowaki pipinkathari-wenteeri ikaate 10 isheninkata-wakahaeyani Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("K111_36","012_11_36","1KI","11","36","36","Apatziro noshine-tawaeri itomi ipinkathari-wenteri apaani ikaatzi isheninkata-wakahaeyani, eero itsiwakanta roota-mento David Aapatziyaweniki, tema rootaki nampitsi nashitakari jempe ojeekakotaki nowaero.’” ");
INSERT INTO cpy_vpl VALUES ("K111_40","012_11_40","1KI","11","40","40","Rootaki kantakaan-tzirori, ikowantari Salomón rowamayiri Jeroboam. Roo kanteencha shiyaka Jeroboam ikinaki Apitantoniki jempe ipinkatharitzi Sisac. Ari ijeekakiri janta roojatzi ikamantaari Salomón. ");
INSERT INTO cpy_vpl VALUES ("K111_42","012_11_42","1KI","11","42","42","Iroka okaatzi ipinkathari-wentakiri Salomón maawoeni Israel-paeni nampitsiki Aapatziyaweni okaatzi 40 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("K111_43","012_11_43","1KI","11","43","43","Ikanta imakoryaahae rirori, ikiteetakiri inampiiteki ashitaririni, David. Ipoyaatari ipinkatharitee itomi, iitachari Roboam. ");
INSERT INTO cpy_vpl VALUES ("K112_1","012_12_1","1KI","12","1","1","Jataki Roboam janta Shempachaariniki, ari ithonka riyaayitaki maawoeni isheninka-paeni rirori iwinkathari-tetyaari janta. ");
INSERT INTO cpy_vpl VALUES ("K112_2","012_12_2","1KI","12","2","2","Yotzimaetaka Jeroboam itomi Nabat, ijeekakira rirori Apitantoniki ishiya-pithatari pinkathari Salomón, ari inampita-kawori janta. ");
INSERT INTO cpy_vpl VALUES ("K112_3","012_12_3","1KI","12","3","3","Ari rotyaanteetaki kaemerini Jeroboam. Pokaki jempe ipiyotee-yakani maawoeni isheninka-paeni rirori. Ari rojampi-teetakiri Roboam, itomi pinkatharini Salomón, ikantee-tziri: ");
INSERT INTO cpy_vpl VALUES ("K112_4","012_12_4","1KI","12","4","4","“Osheki imapero-takina rowashironkaa-waetana ashitzi-mirini. Nokoyi powatsinaryaa-koteena okaatzi ishintsiyitana romperatana. Aririka pimatakinawo, eeroka omperatee-nani.” ");
INSERT INTO cpy_vpl VALUES ("K112_5","012_12_5","1KI","12","5","5","Rakanaki Roboam, ikantziri: “Pipiyanaki maawoeni eerokaete nosheninká. Aririka awijaki mawa kiteejeri, ari nokoyi pipoki piñiina.” Piyeeya-nakani maawoeni isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_6","012_12_6","1KI","12","6","6","Ikanta pinkathari Roboam, ikowaki ikaminayiri antari-pero-paeni inampinatari paerani Salomón, ipaapateni, eeniro rañaawita rirori. Ikantakiri: “¡Nosheninká! ¿Iitaka pikaminayinari eerokaete nokanteriri atziri-paeni?” ");
INSERT INTO cpy_vpl VALUES ("K112_7","012_12_7","1KI","12","7","7","Ikanteeyini antari-pero-paeni: “Aririka poshiya-kotyaari jempe ikantayita romperatani pisheninka-paeni, aritaki pantenirimi ikowayi-tziri, ari pakakirimi kametha rojampi-takimira, ashi poyiromi pompera-teeyaarimi riroripaeni.” ");
INSERT INTO cpy_vpl VALUES ("K112_8","012_12_8","1KI","12","8","8","Roo kanteencha Roboam, tee ikemijantaritzi antaripero-paeni ikaminaa-witakari. Riitaki ikowakiri ikaminayiri ewankari-paeni ikaatzi ikimotee-yakini paerani, jempe itzimi inampina-yitari rirori. ");
INSERT INTO cpy_vpl VALUES ("K112_9","012_12_9","1KI","12","9","9","Rojampi-yitakiri, ikantziri: “¿Iitaka pikamineenari eeroka-paeni nokanteriri asheninka-paeni ikantakina: ‘Powatsinaryaa-koteena okaatzi rompera-waetakina paerani ashitzi-mirini.’?” ");
INSERT INTO cpy_vpl VALUES ("K112_10","012_12_10","1KI","12","10","10","Rakanaki ewankaripaeni ikaatzi paerani Roboam roemonkae-yakani, ikantzi: “Iroka pikanteri pakiri asheninka-paeni kantzimiri: ‘Imapero-takina ashitzimiri rompera-waetakina paerani.’ Pikanteri eeroka: ‘Ishintsiyitakimi paerani ashitanarini rompera-tzimi, naaka maperotemini nompera-teemi. ");
INSERT INTO cpy_vpl VALUES ("K112_11","012_12_11","1KI","12","11","11","Imapero-takimi ashitanarini ikema-tena-takaemi, eekiro nokema-tena-takaa-tyeemi naaka. Ipajawae-tanta-kimiri ashitanarini owathaki-rontsi, rooma naaka nopajatan-teemiro opatzitha kotsirotonki.’” ");
INSERT INTO cpy_vpl VALUES ("K112_12","012_12_12","1KI","12","12","12","Okanta awijaki mawa kiteejeri piyaa Jeroboam itsipataari maawoeni isheninka-paeni jempe ijeeki pinkathari Roboam, tema aritaki ikantzi-takari chapinki, ikantakiri: “Aririka awijaki mawa kiteejeri, pipiye piñeena.” ");
INSERT INTO cpy_vpl VALUES ("K112_13","012_12_13","1KI","12","13","13","Roo kanteencha, teemaeta raki kameetha Roboam itomi pinkatharini Salomón, ikowako-witariri isheninka-paeni, tee ikemijantziri ikaminaa-witakariri antari-pero-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_14","012_12_14","1KI","12","14","14","Rakanta-shitakari okaatzi ikaminaa-kiriri ewankari-paeni, ikantakiri: “Imapero-takimi ashitanari ikema-tena-takaemi, eekiro nokema-tena-takaa-tyeemi naaka. Ipajawae-tanta-kimiri ashitanari owathaki-rontsi, rooma naaka nopajatan-teemiro opatzitha kotsirotonki.” ");
INSERT INTO cpy_vpl VALUES ("K112_15","012_12_15","1KI","12","15","15","Tee raapatziyakotari pinkathari ikowako-witakariri isheninka-paeni, tema rootaki ikowakiri Tajorentsi awije omonkaa-tantyaari ikantzi-takari Jeroboam, itomi Nabat, ikamanta-kiriri Ahías Makoryeeroni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("K112_16","012_12_16","1KI","12","16","16","Ikanta maawoeni Israel-paeni, iñaakiri pinkathari teera raapatziyakotari, rakanakiri, ikantziri: Tee nosheninka-perotari naakaete pipaapateni David. Eero naakakotzimiro pikaateeyini icharini-tzimi itomi Isaí. Eekiro ikantee-yanaki-tziini: ¡Tema aaka israel-paeni, jame apiye apanko-thaanteki-paeni! ¡Riima isheninka-paeni pinkatharini David, ipinkatha-wenta-wakaeyaa ikaatzi isheninkata-wakaa rirori! Ari ipiyeeya-nakani Israel-paeni ipanko-thaanteki-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_17","012_12_17","1KI","12","17","17","Rootaki ipinkathari-wentan-tariri Roboam isheninka-paeni Israel-paeni ikaatzi nampitawori iipatsiteki Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_18","012_12_18","1KI","12","18","18","Ari rotyaanta-witakari pinkathari Roboam inampina, Adoram, ikowakoteri isheninka-paeni rashita-kaariri iwinkatharite. Ishitowanaki maawoeni Israel-paeni rowamaan-takari mapi. Ari rotetanakari intsipaete pinkathari Roboam ishiyako-mentoki, shiyanaka Aapatziyaweniki. ");
INSERT INTO cpy_vpl VALUES ("K112_19","012_12_19","1KI","12","19","19","Ari okantakari rookawenta-wakaan-takari Israel-paeni, tee itsipatee-yaari ikaatzi icharini-yitari pinkatharini David roojatzi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("K112_20","012_12_20","1KI","12","20","20","Ikanta ikemaki itsipa isheninka-paeni Israel-paeni, ikanteetzi: “Piyaa Jeroboam.” Ikaemakaan-takiri ipoki jempe ipiyotaka maawoeni isheninka-paeni. Ari rowakiri ipinkathari-wenteeri maawoeni isheninka Israel-paeni. Teera ipinkatha-wenteeri itsipa ikaateeyini isheninkata-wakahaeyani icharini-yitari David, apaniroeni ijeekawaetzi Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_21","012_12_21","1KI","12","21","21","Ikanta rareetaka Roboam Aapatziyaweniki ipiyota-paakiri Judá-paeni eejatzi Benjamín-paeni, osheki-perori ikaateeyini rowayirite riyoshii-takiri. Ikoyi rowayiri-tyaari itsipa isheninka-paeni Israel-paeni, imatantee-yaaworimi Roboam, itomi Salomón ipinkathari-wenteeri maawoeni isheninka-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_22","012_12_22","1KI","12","22","22","Roo kanteencha, iñaanatakiri Tajorentsi itomyaayi iitachari Semaías, ikantakiri: ");
INSERT INTO cpy_vpl VALUES ("K112_23","012_12_23","1KI","12","23","23","“Pikenkitha-waeta-kaeri Roboam, itomi pinkatharini Salomón, iwinkatharite Judá-paeni eejatzi Benjamín-paeni. Pimatzi-tyaari pikamanteri maawoeni nampitawori janta, pikanteri: ");
INSERT INTO cpy_vpl VALUES ("K112_24","012_12_24","1KI","12","24","24","‘Iroka ikantzi Tajorentsi: Tee okameethatzi piyaate powayirita-wakaeyaa pikaatzi pisheninkata-wakahaeyani eeroka Israel-paeni. Pipiyi maawoeni pipanko-thaanteki, tema rootaki nantawaeri naaka.’” Ikanta ikemaeya-kironi ñaantsi ikantziriri Tajorentsi, piyayitanaka ipanko-thaanteki-paeni, imatakiro jempe ikantakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("K112_25","012_12_25","1KI","12","25","25","Rapiiteero Jeroboam inampitaawo nampitsi Shempachaariki jeekatsiri tonkaariki iipatsiteki Efraín-paeni. Ari inampitaawori rirori. Ikanta paata rookaneero inampiwi-takawo Shempachaariki, jatee, inampitaawo nampitsiki Tajorentsi-pooni. ");
INSERT INTO cpy_vpl VALUES ("K112_26","012_12_26","1KI","12","26","26","Ari ikenkishiryaanaka Jeroboam, ikantzi: “Kimitaka aritaki rapiiteero ipinkathari-wenteena Roboam, icharini pinkatharini David, ");
INSERT INTO cpy_vpl VALUES ("K112_27","012_12_27","1KI","12","27","27","tema roojatzi riyaata-piinteeyini Aapatziyaweniki nosheninka-paeni itayiri ratsipe-takaani itajorentsi-pankoteki Tajorentsi, kimitaka aritaki ineshironka-takiri Roboam, pinkathari-tatsiri iipatsiteki Judá-paeni. Aamaakya aritaki rowamaa-kaantakina naaka, ipiyashi-teeri Roboam iwinkatharite Judá-paeni.” ");
INSERT INTO cpy_vpl VALUES ("K112_28","012_12_28","1KI","12","28","28","Ari raminaki pinkathari itzimirika kamineerini, rowetsika-kaantaki apite roshiya-kaawo ewonkiri waaka riyoshiita ooro, ikantakiri maawoeni isheninka: “¡Nosheninká Israel-paeni! Aritapaaki pipiyapiyataka Aapatziyaweniki. Irika pitajorentsi-tetee-yaari jaka, riitaki amaemiri pijeeka-witaka paerani Apitantoniki.” ");
INSERT INTO cpy_vpl VALUES ("K112_29","012_12_29","1KI","12","29","29","Rowaki apaani roshiya-kaawo waaka Tajorentsi-pankoniki, riima itsipa rowakiri iipatsiteki Dan-paeni. ");
INSERT INTO cpy_vpl VALUES ("K112_30","012_12_30","1KI","12","30","30","Rootaki ikaaripero-waetan-tyaari Israel-paeni, riyaayitee Tajorentsi-pankoniki eejatzi iipatsiteki Dan-paeni ipinkatha-teeri roshiya-kaawo ewonkiri waaka. ");
INSERT INTO cpy_vpl VALUES ("K112_31","012_12_31","1KI","12","31","31","Rowetsika-kaanta-yitaki eejatzi tonkaariki iyaapapankote. Riyoshii-yitaki isheninka rompera-tajorentsi-tyaari, kaarimaeta isheninka-paeni Leví-paeni. ");
INSERT INTO cpy_vpl VALUES ("K115_9","012_15_9","1KI","15","9","9","Tema awijaki osheki ojarentsi ipinkathari-wentakiri Jeroboam maawoeni itsipa isheninka-paeni Israel-paeni. Riima isheninka-paeni Judá-paeni raminee riroripaeni itsipa pinkathari-wenteerini, iitachari Asa. ");
INSERT INTO cpy_vpl VALUES ("K116_23","012_16_23","1KI","16","23","23","Tema okaataki 31 ojarentsi ipinkatharitzi rirori Asa iipatsiteki Judá-paeni. Aripaete retanakawo rirori Omri ipinkathari-wentziri itsipa isheninka-paeni Israel-paeni. Okaatzi 12 ojarentsi ipinkatharitaki. Rooma janta nampitsiki Aakameetha-weniki ipinkatharitaki okaatzi 6 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("K116_24","012_16_24","1KI","16","24","24","Ramanantakiro Omri iipatsite Oshitekii-toni-jatzi, ikaatzi apikithote koriki opinatakari. Ari rowetsikakiri inampi iitakiro Oshitekii-toni, tema rootake owaetakaan-tzirori iwaero ashitawori iipatsite paerani iitachari Oshiteki, ikantee-tziri iñaaniki rirori ‘Semer’. ");
INSERT INTO cpy_vpl VALUES ("K116_25","012_16_25","1KI","16","25","25","Tee inimotziri Tajorentsi okaatzi rantziri pinkathari Omri. Omaperotaka ikaariperotaki rawijakiri ikaariperotaki etakawori paerani ipinkatharitzi. ");
INSERT INTO cpy_vpl VALUES ("K116_26","012_16_26","1KI","16","26","26","Roshiya-kotaari ikaariperotaki Jeroboam itomi Nabat, tema ikaaripero-takaakiri eejatzi maawoeni isheninka-paeni Israel-paeni, rowatsimaakiri Itajorentsite Israel iñaakiri ipinkatha-waetziri oshiyakaa-wontsi. ");
INSERT INTO cpy_vpl VALUES ("K116_28","012_16_28","1KI","16","28","28","Ikanta imakoryahae rirori Omri, ikiteetakiri Oshitekii-toniki. Ipoyaataari ipinkatharitee Acab, itomi rirori. ");
INSERT INTO cpy_vpl VALUES ("K116_30","012_16_30","1KI","16","30","30","Tema okaatzi 22 ojarentsi ipinkathari-wentakiri Acab isheninka-paeni Israel-paeni janta Oshitekii-toniki. Teemaeta inimoritzi Tajorentsi ipinkathari-witaka Acab itomi Omri, omaperotaka ikaariperotaki, rawijanakiri ikaatzi etakawori paerani ipinkatharitzi. ");
INSERT INTO cpy_vpl VALUES ("K116_31","012_16_31","1KI","16","31","31","Tee rookiro rantayi-tziro kaari-perori roshiya-kotaari pinkatharini Jeroboam, itomi Nabat, tema iinantakawo Jezabel, rishinto pinkathari-tatsiri Shimaaki, iiteetziri “Itsipa-minthari Inkañaaweri”. Tema riyaataki paerani Jeroboam, ipinkatha-waetakiri tajorentsi-niro Inkañaaweri. ");
INSERT INTO cpy_vpl VALUES ("K116_32","012_16_32","1KI","16","32","32","Rowetsika-kaantaki taapooki-mentotsi janta Oshitekii-toniki, rowetsika-kaantzitaka iyaapapankote jempe itaawenteeteri tajorentsi-niro Inkañaaweri. ");
INSERT INTO cpy_vpl VALUES ("K116_33","012_16_33","1KI","16","33","33","Imatakiro eejatzi pinkathari Acab rowetsika-kaantaki oshiyakaawo tajorentsi-niro Inkaariwero, rootaki rowatsimaa-pero-tanta-kariri Itajorentsite Israel, tema rawijanakiri etayita-kawori paerani ipinkathari-yitzi rowatsimaeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("K117_1","012_17_1","1KI","17","1","1","Ikanta Elías Inimo-weni-jatzi poñaachari Wakaniki, ikenkitha-waeta-kaakiri pinkathari Acab, ikantziri: “¡Pinkatharí! Kyaaripero iroka nokantemiri, tema añaatsi Itajorentsite Israel, riitaki omperatanari naaka. Ari awijaki ojarentsi-paeni eero oparyahae inkani, eero iñeetee eepichokiini itsini ompokiro roojatzi nokantan-teeyaari naaka: ‘Oparyahae.’” ");
INSERT INTO cpy_vpl VALUES ("K117_2","012_17_2","1KI","17","2","2","Ari iñaanata-kiriri Tajorentsi rirori Elías, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("K117_3","012_17_3","1KI","17","3","3","“¡Elías! Pishiyi, pikinaki ishitowa-piintzira ooryaa. Pomañaa nijaateniki Chekaawoniki, jeekatsiri intatsikiro Pareenkaariniki. ");
INSERT INTO cpy_vpl VALUES ("K117_4","012_17_4","1KI","17","4","4","Rootaki pimiriteri nijaateni. Ari nokanta-kaakyaari tsiirotyonkiniro rayimiro poyaari janta.” ");
INSERT INTO cpy_vpl VALUES ("K117_5","012_17_5","1KI","17","5","5","Imatakiro Elías ikantakiriri Tajorentsi, jataki, ijeekaki nijaateniki Chekaawoniki jeekatsiri intatsikiro Pareenkaariniki. ");
INSERT INTO cpy_vpl VALUES ("K117_6","012_17_6","1KI","17","6","6","Pokatsi tsiirotyonkiniro raminiri wathatsi royaari eejatzi ratantyaariri. Raminiri okitejeetyaa-manee eejatzi tsirenii-teeni. Rootaki ririri nijaateni. ");
INSERT INTO cpy_vpl VALUES ("K117_7","012_17_7","1KI","17","7","7","Okanta awijaki jempe okaatzi kitejeri, piryaatanaki nijaateni, tema tee iñahaeteero opariyee inkani kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("K117_8","012_17_8","1KI","17","8","8","Opoñaashita iñaanateeri Tajorentsi irika Elías, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("K117_9","012_17_9","1KI","17","9","9","“Piyaate Iwyaariniki otsipa-nampitari Shimaa, aritaki pijeekiri janta. Tema ari nokanta-kaakyaawo kinankawo tsinani opimi poyaari.” ");
INSERT INTO cpy_vpl VALUES ("K117_10","012_17_10","1KI","17","10","10","Jataki Elías Iwyaariniki. Ikanta rareetzi-mataka nampitsiki, itonkiyo-takawo tsinani kinankawo aawaetzi incheempiki. Ikaemako-tapaakiro, ikantziro: “¡Ayompawo! Nokoyi pipakotena eepichokiini nijaa nirawakiita.” ");
INSERT INTO cpy_vpl VALUES ("K117_11","012_17_11","1KI","17","11","11","Rooteentsi iyaatanaki ayiniri imiri, rapiita-nakiro, ikantziro: “¡Pamaki eejatzi eepichokiini noyaari!” ");
INSERT INTO cpy_vpl VALUES ("K117_12","012_17_12","1KI","17","12","12","Akanakiri roori, okantziri: “¡Kyaaripero nokantemi, tema añaatsi Pitajorentsite, tekatsi ratanteetari nopimiri! Apatziro otzimi eepañekiini pankirentsi-pane chomoki, eejatzi yeenkantsi eenitatsi eechaakiini. Rootaki naantari eepichokiini incheempiki nonkotsitiro nakiyoteri notyomi, aririka nothonkakiro, ari noyaawentyaa ayina notashe.” ");
INSERT INTO cpy_vpl VALUES ("K117_13","012_17_13","1KI","17","13","13","Ikantzi Elías: “Eero pithaawa-shita. Piyaate pimatero pikantakiri. Roo kanteencha naaka petawakyaa pitashi-tenawo, pamakinawo nowawakyaa. Opoñaashitya pimpoete pitashite pashi eeroka pakiyoteriri pitomi. ");
INSERT INTO cpy_vpl VALUES ("K117_14","012_17_14","1KI","17","14","14","Tema ikantakina Tajorentsi, Itajorentsite Israel, eero othonka pankirentsi-pane eejatzi yeenkantsi, roojatzi rowaryaan-teeyaawori Tajorentsi inkani kepatsiki.” ");
INSERT INTO cpy_vpl VALUES ("K117_15","012_17_15","1KI","17","15","15","Tema omatakiro kinankawo ikantakirori Elías. Osheki kitejeri awijeentsi tee okoetyeeyaa owanawo otsipatakari Elías eejatzi otomi. ");
INSERT INTO cpy_vpl VALUES ("K117_16","012_17_16","1KI","17","16","16","Tee othonkyaa pankirentsi-pane ochomoniki eejatzi ikitaka yeenkantsi, tema monkaataka iñaani Tajorentsi ikantakiriri Elías. ");
INSERT INTO cpy_vpl VALUES ("K117_17","012_17_17","1KI","17","17","17","Okanta paata romapoka-shitaka imantsiyataki otomi kinankawo, maperotaka, tee omatanaa rañeenka-tanee. ");
INSERT INTO cpy_vpl VALUES ("K117_18","012_17_18","1KI","17","18","18","Oñaanata-nakiri kinankawo irika Elías, okantziri: “¡Itomyaayi Tajorentsi! ¿Iitaka pipokashi-tantanari? ¿Rooma pipokantari pikenkishire-takaenawo nowaariperonka ikamantyaari notyomi?” ");
INSERT INTO cpy_vpl VALUES ("K117_19","012_17_19","1KI","17","19","19","Ari rakanakiro Elías, ikantziro: “Pamakinari jaka pitomi.” Raawakiri Elías othomaakiri riniro, rateeta-kaanakiri imaapiintzira romaryaa-paakiri imaamentoki. ");
INSERT INTO cpy_vpl VALUES ("K117_20","012_17_20","1KI","17","20","20","Icheraanaki Elías, ikantzi: “¡Tajorentsi! ¡Ashitanarí! ¿Pimatzi-tyaawoma powashironkayiro kinankawo nomayimotziri powamayitero otomi?” ");
INSERT INTO cpy_vpl VALUES ("K117_21","012_17_21","1KI","17","21","21","Tema mawa rapiitakiro Elías rowanki-shipanee-takari eentsi. Rapiita-nakiro icheraanaki, ikantzi: “¡Tajorentsi! ¡Ashitanari! Poepiya-shire-teeri eentsi.” ");
INSERT INTO cpy_vpl VALUES ("K117_22","012_17_22","1KI","17","22","22","Ikemakiri Tajorentsi ikantakiriri Elías, roepiya-shire-teeri eentsi, añaanee. ");
INSERT INTO cpy_vpl VALUES ("K117_23","012_17_23","1KI","17","23","23","Ithomaa-neeri, rayiita-kaaneeri jaawiki, ipapaero ashitariri, ikantziro: “Irika peentsite, añahae.” ");
INSERT INTO cpy_vpl VALUES ("K117_24","012_17_24","1KI","17","24","24","Okantzi tsinani: “Ari niyotzimi nimaeka eeroka itomyaayi Tajorentsi, tema omapero-tatyaa iñaani Tajorentsi okaatzi piñaawae-tziri eeroka.” ");
INSERT INTO cpy_vpl VALUES ("K118_1","012_18_1","1KI","18","1","1","Tema ojamanitaki, awijaki okaatzi mawa ojarentsi, rapiiteero Tajorentsi iñaanateeri Elías, ikanteeri: “Piyaate, piñiiri pinkathari Acab, tema rootaatsi nowaryahaero inkani irenkaeroni kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("K118_2","012_18_2","1KI","18","2","2","Jataki Elías iñiiri pinkathari Acab. Tema antawoete okantaka tashetsi Oshitekii-toniki. ");
INSERT INTO cpy_vpl VALUES ("K118_3","012_18_3","1KI","18","3","3","Ikaemakiri Acab inampina iitachari Abdías, tema imapero-tatziiro rirori ipinkatha-tziri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("K118_4","012_18_4","1KI","18","4","4","Tema owamaakaan-takiri paerani Jezabel Kamantan-taniri-paeni, irika Abdías riitaki omanakiriri impeetamooki ikaatzi 100 Kamantan-taniri, rinashitakari ikaatzi 50 apichonchoete ipiyotakiri rirori Kamantan-taniri, ari ipiriri rowanawo eejatzi imiri. ");
INSERT INTO cpy_vpl VALUES ("K118_5","012_18_5","1KI","18","5","5","Ikenkitha-waeta-kaakiri Acab irika Abdías, ikantakiri: “Jame anashitero maawoeni nampitsi amini jempe owaapathata, amini eejatzi nijaateni jempe oshooki katawoshi rañaant-yaari apira-paeni ikyaakoetari. Eerorika añaashita, ari ithonka-kyaa ikami apira-paeni.” ");
INSERT INTO cpy_vpl VALUES ("K118_6","012_18_6","1KI","18","6","6","Tema ikinanaki Acab otsipaki awotsi, eejatzi Abdías ikinitanaka rirori otsipaki awotsi tekatsi itsipata-nakyaa. ");
INSERT INTO cpy_vpl VALUES ("K118_7","012_18_7","1KI","18","7","7","Ikanta riyaatanaki Abdías awotsiki, itonkiyo-takari Elías. Tema riyotawaeri, rotziwerowa-shita-waari, ikantziri: “¿Tema eeroka Elías?” ");
INSERT INTO cpy_vpl VALUES ("K118_8","012_18_8","1KI","18","8","8","Rakanaki Elías, ikantzi: “Naakataki. Pipiyanaki, pikanteri piwinkatharite: ‘Noñahaeri Elías.’” ");
INSERT INTO cpy_vpl VALUES ("K118_9","012_18_9","1KI","18","9","9","Ikantzi Abdías: “¿Eenitatsima nantani potyaantan-tanari nokamanteri pinkathari Acab rowamaan-tenari? ");
INSERT INTO cpy_vpl VALUES ("K118_10","012_18_10","1KI","18","10","10","¡Kyaaripero iroka nokantemiri, tema añaatsi Pitajorentsite! Osheki ithotyaako-takaan-takimi pinkathari Acab maawoeni nampitsiki. Ikaatzi kantatsiri: ‘Tee noñiiri,’ ishintsiyitziri ikantziri: ‘Pikanta-perotena terika piñiiri’! ");
INSERT INTO cpy_vpl VALUES ("K118_11","012_18_11","1KI","18","11","11","Eekiro pikanta-tyaana eeroka nimaeka: ‘Piyaate pikamanteri piwinkatharite, pikanteri: “Noñahaeri Elías.” ’ ");
INSERT INTO cpy_vpl VALUES ("K118_12","012_18_12","1KI","18","12","12","Kimitaka aririka niyaatanaki, aaneemi ishiri Tajorentsi, eero niyotzi jempe pijeeki. Aririka nokaman-tawita-kyaari pinkathari Acab, eerorika iñaashi-tzimi rirori, aritaki rowamaakina. Tema naaka, ashi noyiro nopinkatha-tziri Tajorentsi owakira newankari-tapaaki. ");
INSERT INTO cpy_vpl VALUES ("K118_13","012_18_13","1KI","18","13","13","¿Tema ikamantee-tzimiro okaatzi nantakiri owamaakaan-tantariri Jezabel Kamantan-taniri-paeni? Tema nomanaki impeetamooki ikaatzi 100. Ninashitaka ikaatzi 50 apichonchoete ipiyotaka rirori Kamantan-taniri, ari nopiriri rowanawo eejatzi imiri. ");
INSERT INTO cpy_vpl VALUES ("K118_14","012_18_14","1KI","18","14","14","Eekiro pikanta-tyaana eeroka nimaeka: ‘Piyaate pikamanteri piwinkatharite, pikanteri: “Noñahaeri Elías.” ’ ¿Pikowatziima rowamayina?” ");
INSERT INTO cpy_vpl VALUES ("K118_15","012_18_15","1KI","18","15","15","Ikantzi Elías: “¡Kyaari-pero iroka nokantemiri, tema añaatsi Tajorentsi Ñaaperori omperatanari naaka. Nimaeka niyaate noñiiri Acab!” ");
INSERT INTO cpy_vpl VALUES ("K118_16","012_18_16","1KI","18","16","16","Piyaawo Abdías ithotyaako-taateri pinkathari Acab, ikamantakiri. Jatanaki rirori Acab itonkiyo-tyaari Elías. ");
INSERT INTO cpy_vpl VALUES ("K118_17","012_18_17","1KI","18","17","17","Ikanta iñaawaeri, ikantawakiri: “¿Eerokama oñaashirenkayitakiriri asheninka-paeni Israel-paeni? ");
INSERT INTO cpy_vpl VALUES ("K118_18","012_18_18","1KI","18","18","18","Ikantzi Elías: “Teera naaka ñaashirenkirini. Tema eeroka pitsipatakari isheninka-paeni piwaejatziteni, okantakaawo pipakahaero ikantakaantani Tajorentsi, pipinkatha-waeta-shitakari roshiya-kaawo Inkañaaweri-paeni. ");
INSERT INTO cpy_vpl VALUES ("K118_19","012_18_19","1KI","18","19","19","Pikaema-kaanteri maawoeni asheninka-paeni Israel-paeni ipiyotee-yaani Owaantsii-toniki. Pikaemiri janta iñaawyaa-takaani Inkañaaweri ikaate 450, pikaemiri oñaawyaa-takaani Inkaariweri ikaate 400, eejatzi ikaateeyini akiyota-piintzirori Jezabel.” ");
INSERT INTO cpy_vpl VALUES ("K118_20","012_18_20","1KI","18","20","20","Ikaemakaan-takiri Acab maawoeni isheninka-paeni Israel-paeni, ipiyotakiri maawoeni ñaawyaa-waetaniri-paeni Owaantsii-toniki. ");
INSERT INTO cpy_vpl VALUES ("K118_21","012_18_21","1KI","18","21","21","Ari ipokakiri rirori Elías jempe ipiyotaka isheninka-paeni, ikantapaakiri: “¿Jempema okaateka pipakahaero pipithopitho-waetaka okantakaemi otzimi apite pikenkishiryaani? Riirika riroperori Tajorentsi pikemijanteri, pimatero. Riirika Inkañaaweri pikemijanteri rirori, pimatero.” Ari imaeritee-yakini isheninka-paeni tekatsi akatsini. ");
INSERT INTO cpy_vpl VALUES ("K118_22","012_18_22","1KI","18","22","22","Eekiro iñaanata-tziiri Elías isheninka-paeni, ikantziri: “Apaani nokanta naaka iyamanta-nirite Tajorentsi, riima Inkañaaweri ikaatzi 450 iñaawyaa-tanirite rirori. ");
INSERT INTO cpy_vpl VALUES ("K118_23","012_18_23","1KI","18","23","23","Pamaeyini jaka apite ipireetari. Riyoshiitaki ñaawyaripaeni apaani ipireetari ikoyiri rirori, itopitheeri-kitakiri, rowanki-takiri itsimaki, eero itaantzi-maetari paamari. Ari nokimitakiri naaka itsipa ipireetari, nowanki-takiri tsitsiki, eero notaantzimaetari eejatzi paamari. ");
INSERT INTO cpy_vpl VALUES ("K118_24","012_18_24","1KI","18","24","24","Opoñaashita pikowakoteri pitajorentsite-paeni eerokaete, pipaeriiro iwaero. Rooma naaka nopaeriiro iwaero Notajorentsite. Itzimi-rika Tajorentsi kematsini, owayiiteroni paamari, riitaki maperotzirori Itajorentsitzi.” Ikanteeyini maawoeni Israel-paeni: “¡Ariwé!” ");
INSERT INTO cpy_vpl VALUES ("K118_25","012_18_25","1KI","18","25","25","Ikantanakiri Elías iñaawyaa-takaani Inkañaaweri: “Poyoyaantya eeroka irika ipireetari, petyaari powamayiri, tema osheki pikaateeyini. Pikowakoteri pitajorentsite pipaeriiro iwaero, eeromaeta pitaantari paamari.” ");
INSERT INTO cpy_vpl VALUES ("K118_26","012_18_26","1KI","18","26","26","Imatakiro ikantakiriri, raakiri ipireetari, rowamaakiri. Retanakawo okitejetyaa-manaki, tampatzika-takotaki ikowako-witari itajorentsite Inkañaaweri, ikantziri: “¡Inkañaaweri, pakina!” Tekatsi akirini. Eekiro imitaawi-teeya-tyaani rinki-rinki-teeyironi rowetsikakiri itaapooki-mento. ");
INSERT INTO cpy_vpl VALUES ("K118_27","012_18_27","1KI","18","27","27","Tampatzika-takotaki, osheki ishironta-wentari Elías irikapaeni, ikantziri: “Pishintsiteri pikaemiri pitajorentsite. Aamaashityaa eenitatsirika rantziri, riyaatatzii rareetan-tawaeta. Powakireeri aamaashityaa imaatziirika.” ");
INSERT INTO cpy_vpl VALUES ("K118_28","012_18_28","1KI","18","28","28","Eekiro ikaemae-yatziini, ikijawaa-waewi-takawo iyotsiraa-nikite, rowathaa-waetakawo thoyempi-thowa-yitatsiri, oshitowa-yitaki riraa, aritaki okanta rametee-yarini riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("K118_29","012_18_29","1KI","18","29","29","Rooteentsi imonkaatyaa ooryaa okaatzi itaanta-piintariri rirori ratsipe-takaani, eekiro ishintsi-witeeya-tyaani ikaemaeyini, teemaeta rakaetziniri ramanani. Tekatsi akerini, tekatsi kemirini eejatzi. ");
INSERT INTO cpy_vpl VALUES ("K118_30","012_18_30","1KI","18","30","30","Ikaemanakiri Elías maawoeni isheninka-paeni, ikantziri: “Pipokaeyini maawoeni jaka.” Pokaeya-paakini isheninka-paeni. Ari rowetsikaeri Elías itaapooki-mento Tajorentsi itzimpooki-teetakiri paerani. ");
INSERT INTO cpy_vpl VALUES ("K118_31","012_18_31","1KI","18","31","31","Raaki mapipaeni okaatzi 12. Ikaatzira paerani eejatzi itomi-paeni Jacob 12. Tema riijatzi Jacob ikantakiri paerani Tajorentsi, ikantziri: “Israel piiteeyaa.” ");
INSERT INTO cpy_vpl VALUES ("K118_32","012_18_32","1KI","18","32","32","Ipewiryahaero mapipaeni rowetsikae itaapooki-mento Tajorentsi, antawo ikiya-thapi-takiro, kantacha ipankiteetemi osheki okithoki pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("K118_33","012_18_33","1KI","18","33","33","Ipiyotakiro tsitsi, itowatha-yitakiri ipireetari, rowanki-takiri tsitsiki. ");
INSERT INTO cpy_vpl VALUES ("K118_34","012_18_34","1KI","18","34","34","Ikantzi Elías: “Pamakiro antawo 4 chomo owantakari nijaa, pijeetero taapoki-mentotsi eejatzi tsitsi.” Eekiro ikantatzii Elías: “Papiitero pijeetero.” Rapiitziro ikantzi: “Papiiteero pijeetero.” Imateetakiro okaatzi ikantakiri Elías. ");
INSERT INTO cpy_vpl VALUES ("K118_35","012_18_35","1KI","18","35","35","Jaa-paaka nijaa ikiya-thapi-teetakirowa taapooki-mentotsi, shiyaata-paaka nijaa. ");
INSERT INTO cpy_vpl VALUES ("K118_36","012_18_36","1KI","18","36","36","Tema monkaata-paaka ooryaa okaatzi itaapiintziri ipira taapooki-mentotsiki, pokanaki Elías. Icheraa-paaki, ikantzi: “¡Tajorentsi! Itajorentsite Abraham, Isaac eejatzi Israel. Pimatero nokowako-tzimiri, rootaki riyotan-teetyaari eeroka Itajorentsite Israel-paeni, naakataki eejatzi pomperatani. Okaatzi nantziri naaka, eerokataki omperatanari nantemiro. ");
INSERT INTO cpy_vpl VALUES ("K118_37","012_18_37","1KI","18","37","37","Pimatero Tajorentsi, pimatenawo nokowako-tzimiri. Rootaki riyotan-tyaari atziri-paeni eerokataki Tajorentsi, eeroka kaema-shire-yitziriri ikemijanteemi.” ");
INSERT INTO cpy_vpl VALUES ("K118_38","012_18_38","1KI","18","38","38","Omapoka-shitanaka ookatha-tanaka, otaapaakiri wathatsi, tsitsi, mapi, paapane, maawoeni, paamatanaki eejatzi nijaa jaapae-chari ikiya-thapi-teetakirowa. ");
INSERT INTO cpy_vpl VALUES ("K118_39","012_18_39","1KI","18","39","39","Ikanta iñaakiro maawoeni Israel-paeni opaamatanaki, oeyotanaka, roojatzi kepatsiki, ikanteeyini: “¡Tajorentsi irikawé! ¡Riitaki Tajorentsi!” ");
INSERT INTO cpy_vpl VALUES ("K118_40","012_18_40","1KI","18","40","40","Ari ikantzi Elías: “Poteeyiri iñaawyaatanirite-paeni Inkañaaweri. Tekatsi apaani shiyatsini.” Ari roteeyee-tanakiri maawoeni, raanakiri Elías nijaateniki Tzipyaariki, ithatyaakiri ikentsiki maawoeni. ");
INSERT INTO cpy_vpl VALUES ("K118_41","012_18_41","1KI","18","41","41","Ari ikenkitha-waeta-kaakiri Elías pinkathari Acab, ikantziri: “Piyaate pipankoki, powapaeyaa, pirapae eejatzi pimiri. Tema poema-tapaaki antawo inkani.” ");
INSERT INTO cpy_vpl VALUES ("K118_42","012_18_42","1KI","18","42","42","Ari itonkaanaki eepichokiini pinkathari Acab, owawaetapaaka, riraki eejatzi imiri. Ari itonkaa-pero-tanaki rirori Elías otzishi-menthaki Owaantsii-toniki, jeeka-paaki roeyota-paaka janta, rontsiroka-kaakawo ipoo iyeretoki. ");
INSERT INTO cpy_vpl VALUES ("K118_43","012_18_43","1KI","18","43","43","Ikantziri romperatani: “Pikatziya-neente jeñokiini, pamini inkaari-kinta.” Jatanaki, raminaki inkaariki, ikantzi: “Tekatsi noñii.” Eekiro ishintsi-tatziiri Elías, ikantziri: “Papiipiintero pamini, okaate 7 papiipiintero pamini.” ");
INSERT INTO cpy_vpl VALUES ("K118_44","012_18_44","1KI","18","44","44","Rootaki 7-tatsiri ipiya-piyataka romperatani, ikantziri: “Noñaaki inkaari-kinta oryaani menkori, oshiyawo akotsi.” Ikantzi Elías: “Piyaate ijeekira pinkathari Acab pikanteri: ‘Paaneero pishiyako-mento, tekira oparya-paakiita inkani.’” ");
INSERT INTO cpy_vpl VALUES ("K118_45","012_18_45","1KI","18","45","45","Ari otsireni-tanaki inkite, antawo otampyaa-tanaki, paryapaaki antawo inkani. Otetanaka Acab ishiyako-mentoki, jataki Panki-tajorentsi-niki. ");
INSERT INTO cpy_vpl VALUES ("K118_46","012_18_46","1KI","18","46","46","Riima Elías, ikantakaakari Tajorentsi otzimi ishintsinka, roojo-thaki-tanakawo iithaari. Ishiyana-kityaa riyaatanaki, riitaki etakawori rareetaka Panki-tajorentsi-niki tekiraata rareetyaata rirori Acab. ");
INSERT INTO cpy_vpl VALUES ("K217_6","013_17_6","2KI","17","6","6","Ikanta Oseas pinkatharitee, okaatzi 9 ojarentsi rowawijaakiri ipinkatharitantakari. Roojatzi ipokantakari yotzinkariite Asiria-jatzi, roma-natakiri Samaria-jatzi. Inoshikanakiri Israel-paeni Asiria-jatzi, ijeekakahaeri nampitsiki iitachari Halah. Ari inampitaawori inampiki Habor, jempe oshiyaata nijaa Gozán. Eejatzi ari ijeekaero inampitsiteki Medos-satziite. ");
INSERT INTO cpy_vpl VALUES ("K217_7","013_17_7","2KI","17","7","7","Rootaki awijeentsiri tema Israel-paeni rantzimotakiri kaariperori Pinkathari Tajorentsi okantawitaka Tajorentsi rowawijaakoteeri Israel-paeni, okantawitaka rowawijaakoteeri Faraón, eejatzi Egipto-jatziite maawoeni Israel-paeni, roori kantzimaetacha ramanaari tajorentsiniro. ");
INSERT INTO cpy_vpl VALUES ("K217_8","013_17_8","2KI","17","8","8","Ranteero eejatzi ramanakari itsipajatzipaeni, okantawitaka Tajorentsi ikantakaantawitaka ijeekanteeyaawo iipatsite itsipajatzipaeni. Ari roshiyakotanakari Israel-paeni yotzinkariite antakirori kaariperori. ");
INSERT INTO cpy_vpl VALUES ("K217_9","013_17_9","2KI","17","9","9","Eejatzi Israel-paeni ithaenkimatakiri Pinkathari Tajorentsi, rowetsikanaki iyaapapankote maawoeniki inampi. Rowetsikitanaka eejatzi jempe ojeeki ateementotsi antawo jempe raminakoteri ikijaneentani okine imateeri rowayirityaari. ");
INSERT INTO cpy_vpl VALUES ("K217_10","013_17_10","2KI","17","10","10","Ari ipewiryaanakiro mapipaeni, oshiyawo taapokimentotsi, rowetsikashiwaetaka itajorentsinirote Aser. Rootaki rantakiri tonkaari, eejatzi rantzitakawo jaawi antawoki inchato inthomoetatsiri. ");
INSERT INTO cpy_vpl VALUES ("K217_11","013_17_11","2KI","17","11","11","Ari okanta, ari ikantzitakawo ikantakirowa itsipajatzipaeni, tema Tajorentsi ikashaakaantaki rashiteeyaawo kepatsi. Itaayitakiniri kajankaenkari tajorentsiniro janta ochempiki. Rantayitakiro maawoeni kantawaetachari kaariperori ithaenkimawaetakiro iyatsimankari Pinkathari ikaemakoteeyironi. ");
INSERT INTO cpy_vpl VALUES ("K217_12","013_17_12","2KI","17","12","12","Ramanayitari tajorentsiniro, okantawitaka ikantawitakari Pinkathari: “Eero pamanari tajorentsiniro”. ");
INSERT INTO cpy_vpl VALUES ("K217_13","013_17_13","2KI","17","13","13","Tema ikamantawitakari Tajorentsi, ikantawitakari: Aritaki notyaantaki kamantantaniri; eejatzi ñaawyaantzinkari nokantawitakari, nokantziri: “Pookaero pikaariperowaetzi. Pimonkaatenawo nonintakaantani, okaatzi nopinkakayimiri, maawoeni nonintakaakiriri picharini, okaatzi nokantakiriri arika ikamantakiri kamantantaniri, riitaki nomperatani. ");
INSERT INTO cpy_vpl VALUES ("K217_14","013_17_14","2KI","17","14","14","Roori kantacha, tee ikemijantziri picharini, kijoshiretaki. Roshiyakari ipaapate rirori, tee ikemijantziri Iwinkatharite Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("K217_15","013_17_15","2KI","17","15","15","Ipakaakiro ikowakaanteetziri. Imaemanetakiro ikashaakaantani Tajorentsi. Ipiyathatakawo okaatzi ikantakaanteetakiri, Inintziro tajorentsiniro kaari kameethatatsiri. roshiyakaakiri icharini tee ipantari. Roshiyakiri itsipajatzipaeni, okantawitaka ikantawitakari Pinkathari: “Eero poshiyari itsipapaeni.” ");
INSERT INTO cpy_vpl VALUES ("K217_16","013_17_16","2KI","17","16","16","Ipakaakiro inintakaantani Awinkatharite Tajorentsi, rowetsikaki roshiyakaakiri apite iryaani, rowetsikantakari kijokiri. Rowetsikakiri eejatzi roshiyakaakiri tajorentsiniro Asera, ramanawaetashitakari ompokiropaeni maawoeni, eejatzi ramanawaetashitakari tajorentsiniro Baal. ");
INSERT INTO cpy_vpl VALUES ("K217_17","013_17_17","2KI","17","17","17","Eejatzi reentsite, roshiyakaakiri riimi ratsipetakaani. Sheripiyaritanaki, takisantanaki, ishinetaantziro kaariperori, riyowitaka Tajorentsi rini, rootaki opoñaantari ikijaneenantariri. ");
INSERT INTO cpy_vpl VALUES ("K217_18","013_17_18","2KI","17","18","18","Rootaki ikijaneenantanakariri Tajorentsi Israel-paeni, roojatzi rookantakariri jempe janta noñaahari. Apatziro nojeekakaakiri Judá-paeni inampiki. ");
INSERT INTO cpy_vpl VALUES ("K217_19","013_17_19","2KI","17","19","19","Roori kantacha, ipiyaathatanakari eejatzi rirori, ipakaakiro inintakaantani Awinkatharite Tajorentsi, aritaki ranteero eejatzi ikantakirowa Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("K217_20","013_17_20","2KI","17","20","20","Roojatzi rapakaantanakariri Tajorentsi maawoeni icharinipaeni Israel-paeni. Rowajankitakiri, ishinetakiri inoshikeri ikijaneentani. ");
INSERT INTO cpy_vpl VALUES ("K217_21","013_17_21","2KI","17","21","21","Tema paerani, Tajorentsi, rinashiyitakari apaanipaeni Israel-paeni, tee roshiyakayiri maawoeni ipinkathariwentantakariri icharini pinkathari David. Ikanta riroripaeni riyoyaaki pinkathariwenteroni Jereboam, itomi Nabat. Riitaki antakirori okaatzi rantakiri Israel-paeni rapakaakiri Pinkathari, kaariperotaki kameethaeni. ");
INSERT INTO cpy_vpl VALUES ("K217_22","013_17_22","2KI","17","22","22","Aritaki ikantari Israel-paeni tema rantakiro eejatzi kaariperori roshiyakotakari okaatzi rantakiri Jeroboam, tee rookiro. ");
INSERT INTO cpy_vpl VALUES ("K217_23","013_17_23","2KI","17","23","23","Okaatapaakira iroka, rookawentanakiri okaatzi royaakowitariri Israel-paeni, tema ikamantawitakari maawoeni kamantantaniriite, rompera-tanewo Tajorentsi, ari ikanta Israel-paeni inoshikanteetaariri Asiria-ki, jempe ajeeki nimaeka. ");
INSERT INTO cpy_vpl VALUES ("K217_24","013_17_24","2KI","17","24","24","Ikanta iwinkatharite Asiria-jatzi, atzirite Babilonia, Cuta, Ava, Hamat eejatzi Sefarvaim, ari ijeekakiri janta nampitsiki Samaria-ki, inampiiteki Israel-paeni. Roowa raantakawori maawoeni Samaria jeekaeyakini inampiiteki. ");
INSERT INTO cpy_vpl VALUES ("K217_25","013_17_25","2KI","17","25","25","Tema irika atziri tee ipinkathatziri Tajorentsi, okanta riyotanakirowa ijeeki kameethari, rootaki rotyaantantanakariri Tajorentsi manitzi, roowa rowamaantakariri apaanipaeni riroriite. ");
INSERT INTO cpy_vpl VALUES ("K217_26","013_17_26","2KI","17","26","26","Roojatzi riyatashitantakariri ikamantziri pinkatharitatsiri Asiria-ki, ikantziri: Irikahanki atziri paanakiriranki nampitsiki jeekatsiri Samaria-ki okine ijeeke janta, tee riyotziro ipinkathateri itajorentsite nampiwitawori ketziroeni jaka nampitsiki, okanta tee riyotashitawo, rootaki rotyaantantakinariri manitzipaeni, riitaki owakariri nimaeka. ");
INSERT INTO cpy_vpl VALUES ("K217_27","013_17_27","2KI","17","27","27","Ari okanta nimaeka, iwinkatharite Asiria-jatzi ikantakaantaki, ikantzi: “Poepiyayiteeri sheripiyaripaeni anoshikawitakari chapinki. Okine riyatee inampiteeyaawo janta, riyotahaeri atziriite jempe ikanta itajorentsite riyotziri rirori jaka nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("K217_28","013_17_28","2KI","17","28","28","Ikanta apaani omperatajorentsitaarewo inoshikaetakiri Samaria-ki, ijeekanee nampitsiki Betel. Ari riyotaakiri atziripaeni owakira nampitanaawori janta, ipinkathatakaakiri Tajorentsi riyotakaakiri eejatzi roma-mpaawentari Pinkathari. ");
INSERT INTO cpy_vpl VALUES ("K217_29","013_17_29","2KI","17","29","29","Roori kantacha, irikaete atziri poñaayitachari otsipaki nampitsi, rowetsikaeyakini apaanipaeni itajorentsitetashityaari janta nampitsiki antawoki rowetsikakiri Samaria-jatzi ochempiki inampiki rirori. ");
INSERT INTO cpy_vpl VALUES ("K217_30","013_17_30","2KI","17","30","30","Ikaatzi poñaayitachari Babilonia-ki, rowetsikaki roshiyakaawenteetziri itajorentsinirote iitachari Sucot-benot. Ikanta poñaayitachari Cuta-ki, rowetsikaki roshiyakaawenteetziri itajorentsinirote iitachari Nergal. Riima ikaatzi poñaayitachari Hamat-ki, rowetsikaki roshiyakawenteetziri itajorentsinirote iitachari Asima. ");
INSERT INTO cpy_vpl VALUES ("K217_31","013_17_31","2KI","17","31","31","Ikaatzi poñaayitachari Ava, rowetsikaki roshiyakawenteetziri itajorentsinirote iitachari Nibhaz, itsipa rashi Tartac. Ikaatzi poñaachari Sefarvaim-ki, itaayitziri reentsite roshiyakayiri ratsipetakahaetani ipaetziriri Adramélec eejatzi Anamélec, iwawaniroteeyarini. ");
INSERT INTO cpy_vpl VALUES ("K217_32","013_17_32","2KI","17","32","32","Ikowawita eejatzi riweshiryaawentyaari Tajorentsiperotatsiri, roori kantzimaetacha pokaki isheripiyarite ikaateeyinira rirori, okine ipawakaeyaari janta riweshiryaawenteetarira itajorentsintsitashiitari. ");
INSERT INTO cpy_vpl VALUES ("K217_33","013_17_33","2KI","17","33","33","Ari okanta, okantawitaka riweshiryaawentawitakari Tajorentsi, roori kantzimaetacha riyaatakaakiro ramanari itajorentsinirotetashitari, rootaki rametapiintari inampiiteki jempe janta inoshikaetakiriranki. ");
INSERT INTO cpy_vpl VALUES ("K217_34","013_17_34","2KI","17","34","34","Roojatzi ikantziro nimaeka rantziro roshiyakayiro paerani, rootaki kaari ipinkathatantari Tajorentsi tee imonkaatziro inintakaantani eejatzi iwinkakaantani tee ikemijantziro riyotaawitakariri eejatzi inintakaantani okaatzi ikantawitakariri Pinkathari riyomaatero icharinipaeni Jacob, riitaki owakiniriri iwaero Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("K217_35","013_17_35","2KI","17","35","35","Ikowapaetetakira Tajorentsi raapatziyawakaeya itsipatyaari ikaateeyinira, inintakaakiri ikantakiri: Eero pithaamentawaetari tajorentsiniro, eero pawentaari, eero pashitakaari eejatzi pipirapaeni. ");
INSERT INTO cpy_vpl VALUES ("K217_36","013_17_36","2KI","17","36","36","Naaka piweshiryaawentya, tema naakataki Piwinkatharite Pitajorentsite. Tema noñaahakimiro notajorenka nowawijaakotanteemiri nomishitowanteemiri Egipto-ki. Apatziro nokantakaawo naaka piweshiryaawentaana, pipinkathateena eejatzi, pipaena patsipetakaani pitaayinari. ");
INSERT INTO cpy_vpl VALUES ("K217_37","013_17_37","2KI","17","37","37","Otzimatye pikyaaryoote pimonkaatero nonintakaantani eejatzi nowinkakaantani, niyotaantakiri eejatzi nokantakaantakiri okaatzi jankinateenchari. Eero pajahaawentawaetari itsipa itajorentsintsitashiteetari. ");
INSERT INTO cpy_vpl VALUES ("K217_38","013_17_38","2KI","17","38","38","Eero pipeyakotziro aapatziyawakaani jempe okaatzi nokantakimiri eerokaete. Eero pajahaawentawaetari itsipa itajorentsintsitashiitari. ");
INSERT INTO cpy_vpl VALUES ("K217_39","013_17_39","2KI","17","39","39","Tema apatziro nokantakaawo naaka, piweshiryaawentaana tema naaka Piwinkatharite Pitajorentsite. Naakataki oshetapithateerini pikijaneentani kowawitachari roetsinampaemimi. ");
INSERT INTO cpy_vpl VALUES ("K217_40","013_17_40","2KI","17","40","40","Ari ikantzi Tajorentsi. Roori kantaetaachani ikemijantziri irika atziri poñaachari otsipaki nampitsi royaatakiro etawori aapatziyawakahaantsi. ");
INSERT INTO cpy_vpl VALUES ("K217_41","013_17_41","2KI","17","41","41","Apawojatzi riweshiryaawentawitari Tajorentsi, roori kantzimaetacha riyotakaakiri eejatzi riweshiryaawentari itajorentsinirote. Ari ikantakiro itomipaeni eejatzi icharinipaeni rantakiro eejatzi okaatzi rantakiri paerani etanakawori, roori kantzimaetacha roojatzi ikantziro nimaeka rantziro ikimitzirowa paerani icharinini. ");
INSERT INTO cpy_vpl VALUES ("K224_8","013_24_8","2KI","24","8","8","Ari otzimaki 18 rojarentsite Joaquín retantanakawori ipinkatharitzi, ipinkatharitaki mawa kashiri Jerusalén-ki. Oeta riniro Nehusta, rootaki rishinto Elnatán, Jerusalén-jato ini. ");
INSERT INTO cpy_vpl VALUES ("K224_9","013_24_9","2KI","24","9","9","Roori kantacha, eenitatsi rantayitziri tee okameethatzi iñeero Tajorentsi rirori. Ari roshiyari jempe ikanta icharinipaeni paerani. ");
INSERT INTO cpy_vpl VALUES ("K224_10","013_24_10","2KI","24","10","10","Ikanta rowayiritepaeni Nabucodonosor, pinkatharitatsiri Babilonia-ki, jateeyakini rowayiriteri Jerusalén-jatzi. Othonka itapotakiro ipankopaeni rowayirityaari. ");
INSERT INTO cpy_vpl VALUES ("K224_11","013_24_11","2KI","24","11","11","Ikanta rowayiriteetari Jerusalén-jatzi, areetapaaka pinkathari Nabucodonosor. ");
INSERT INTO cpy_vpl VALUES ("K224_12","013_24_12","2KI","24","12","12","Ikanta Joaquín, iwinkatharite Judá-paeni, itsipatakawo riniro, eewatziriri rowayiritepaeni, jewaripaeni, maawoeni atziri aapatziyariri, ishinetaka rayeri iwinkatharite Babilonia-jatzi. Raanakiri inampiki ikemaatsitakaawaetyaari. Rootaki awijeentsiri paerani ipinkatharitantari Nabucodonosor, tekira awijeeta osheki ojarentsi, okaatzi 8. ");
INSERT INTO cpy_vpl VALUES ("K224_13","013_24_13","2KI","24","13","13","Ikanta pinkathari Nabucodonosor, ithonka raakiri korikipaeni pinatachari itajorentsipankoteki Tajorentsi, ikyaaki ipankoki pinkathari, raakiro maawoeni tzimatsiri. Monkaataka okaatzi ikamantantakiri paerani Tajorentsi. Ithonka ijataakiro ooronaki rowetsikakaantakiri paerani Salomón, pinkatharitatsiri Israel-ki, okaatzi owaneenkatari itajorentsipankote Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("K224_14","013_24_14","2KI","24","14","14","Ithonka raanakiri nampitawori Jerusalén-ki, maawoeni jewaripaeni, ñaaperoripaeni owayiri, ikaatzi yotzirori rowetsikawaetzi, osheki atziri raanaki, ikaatzi 10,000. Roowiteencha raperaaterimi raanakiri maawoeni, apatziro ijeekamatsitanaki ashironkaenkaripaeni. ");
INSERT INTO cpy_vpl VALUES ("K224_15","013_24_15","2KI","24","15","15","Imatakiri Nabucodonosor raanakiri eejatzi pinkathari Joaquín, itsipataanakiri iina, eejatzi reewarite rowayiritepaeni, riroperori atziripaeni nampitawori Jerusalén-ki. Raanakiri inampiki Nabucodonosor iiteetziro Babilonia. ");
INSERT INTO cpy_vpl VALUES ("K224_16","013_24_16","2KI","24","16","16","Irika ikaatzi riroperori atziripaeni raanakiri iwinkatharite Babilonia-jatzi, ikaateeyini 7,000 atziri; itsipa ikaatzi 1,000 riyoyahaetziro rowetsikayitziro oeyitarika, itsipa riroperori atziripaeni, ñaaperotachari rowayiritya. ");
INSERT INTO cpy_vpl VALUES ("K224_17","013_24_17","2KI","24","17","17","Ikanta iwinkatharite Babilonia-jatzi rowakiri ipinkatharite Matanías, riitaki poyaataariri itominthori Joaquín, rowashiñaahaeniri iwaero iiteeri Sedequías. ");
INSERT INTO cpy_vpl VALUES ("K224_18","013_24_18","2KI","24","18","18","Iroka okaatzi rojarentsite Sedequías retantanakawori ipinkatharitzi, okaatzi 21 ojarentsi. Ipinkatharitaki Jerusalén-ki okaatzi 11 ojarentsi. Iroka owaero riniro, oeta Hamutal, rishinto Jeremías, opoñaawo roori nampitsiki iiteetziro Libna. ");
INSERT INTO cpy_vpl VALUES ("K224_19","013_24_19","2KI","24","19","19","Tee okameethatzi iñeero Tajorentsi okaatzi rantayitziri, ari roshiyakari jempe ikanta paerani Joacim rirori. ");
INSERT INTO cpy_vpl VALUES ("K224_20","013_24_20","2KI","24","20","20","Rootaki opoñaantari rowatsimaeri Tajorentsi, ikijakiri Jerusalén-jatzi, ari roshiyakaakiri eejatzi Judá. Tee ikoyi iñahaeri. ");
INSERT INTO cpy_vpl VALUES ("K225_1","013_25_1","2KI","25","1","1","Aritaki awijaki 9 ojarentsi ipinkatharitaki Sedequías, rootaki kitejiteri 10, irijatzi kashiri 10. Ari ipokakiri pinkathari Nabucodonosor ramaki osheki rowayirite roma-nateri Jerusalén-jatzi, itzimashitapaakiri ookaakiini. Ipankoshetateeyapaani intatsikero, rowatzikapaakiro jempe roma-nateeyaani. ");
INSERT INTO cpy_vpl VALUES ("K225_2","013_25_2","2KI","25","2","2","Tee thaankiini rapakaero itzimashitakiri, ojamani ikanteeyakani, roojatzi okaatantakari ipinkatharitzi Sedequías, okaatzi 11 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("K225_3","013_25_3","2KI","25","3","3","eenitatsi awijeentsiri ojarentsiki, rootaki kitejeri 9, ari rawijaki 4 kashiri. Ari iñahaetaki antawo tashetsi. Tekatsi rowaeyaani atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("K225_4","013_25_4","2KI","25","4","4","Ikanta atziripaeni imoontakiro otantotari nampitsi, okantawitaka itzimashitziri Babilonia-jatzi. Ari ishiyeeyakani maawoeni, pinkathari eejatzi rowayirite, tsireniriki ishiyaka. Ikineeyakini ishitowanaki jempe otzimawita apite otanto nampitsi jempe itzimashiwiteetakari, ikineeyakini jempe ikinapiintziro pinkathari, ipampithatanakiro awotsi jatachari Jordán. ");
INSERT INTO cpy_vpl VALUES ("K225_5","013_25_5","2KI","25","5","5","Roori kantacha, rowayirite Babilonia-jatzi ipatzimatanakiri pinkathari Sedequías, royaatawaeri owintenipathatzira Jericó-ki. Ari ithonkari iporokanaki rowayirite pinkathari Sedequías, rookawentanakiri apaniroeni. ");
INSERT INTO cpy_vpl VALUES ("K225_6","013_25_6","2KI","25","6","6","Ikanta irikaete Babilonia-jatzi rotaeyakiri pinkathari Sedequías, raanakiniri iwinkatharite Babilonia-jatzi, ijeekiro rirori iiteetziro Ribla, ojeeki iipatsite iiteetziri Hamat. Aripaete riyakowentakiri pinkathari Nabucodonosor rowamayiteri Sedequías, ");
INSERT INTO cpy_vpl VALUES ("K225_7","013_25_7","2KI","25","7","7","Iñaakowentakiri jempe ikanta rowamayitakiri itomipaeni. Riima pinkathari Sedequías, ikantaki pinkathari: “Pikithokireeniri roki Sedequías. Poojoteri, paanakiri nampitsiki Babilonia-ki.” ");
INSERT INTO cpy_vpl VALUES ("K225_8","013_25_8","2KI","25","8","8","Okanta awijaki 19 ojarentsi ipinkatharitzi Nabucodonosor, awijaki eejatzi 5 kashiri, ari maakotaki 7 kitejeri. eenitatsi itsipanampiro pinkathari iita Nabuzaradán, ramakiri ikaatzi rowayiriteeyani. Areeteeyakani Jerusalén-ki. ");
INSERT INTO cpy_vpl VALUES ("K225_9","013_25_9","2KI","25","9","9","Itaakiro tajorentsipanko, ipanko pinkathari, ithonkari itaakiro maawoeni ipanko Jerusalén-jatzi. Rootaki riyoshiitaki itaakiro ipankopaeni riroperori atziri. ");
INSERT INTO cpy_vpl VALUES ("K225_10","013_25_10","2KI","25","10","10","Imatanakiro otanto nampitsi Jerusalén, itzimpookanakiro rowayirite Babilonia-jatzi. ");
INSERT INTO cpy_vpl VALUES ("K225_11","013_25_11","2KI","25","11","11","Ikanta Nabuzaradán itsipanampiri pinkathari, raanakiri inoshikani nampitsiki Babilonia. raperaatanakiri raanakiri, maawoeni aapatziyakariri iwinkatharite Babilonia-jatzi, ithonka raanakiri yotzirori rowetsikayitziro oetarika. ");
INSERT INTO cpy_vpl VALUES ("K225_12","013_25_12","2KI","25","12","12","Apatziro rootamatsitanakiri atziri ashironkaayitachari. Riitaki thamaetakoteeroni pankirentsipaeni imiriteetari, maawoeni owaantsipaeniki. ");
INSERT INTO cpy_vpl VALUES ("K225_13","013_25_13","2KI","25","13","13","Ikanta owayiripaeni, ithonka ijataanakiro rowetsikaetzinirori tajorentsipanko: otzinkami, okonompiropaeni, rowetsikashitziro jempe ishitowaatapiintzi nijaa. Ithonka raanakiri koriki Babilonia-ki. ");
INSERT INTO cpy_vpl VALUES ("K225_14","013_25_14","2KI","25","14","14","Ithonkari raanakiro eejatzi okoekimento, itsikomento jamampo, rowantapiintawori ipaamarimenkite, ikitantapiintari samampo, maawoeni okaatzi rowetsikaetziri ashi tajorentsipanko. ");
INSERT INTO cpy_vpl VALUES ("K225_15","013_25_15","2KI","25","15","15","Imatakiro eejatzi reewarite owayiripaeni, raanaki rirori ikaatzi rowetsikaetziri ooro eejatzi koriki: omarentsi eejatzi riraamentopaeni. ");
INSERT INTO cpy_vpl VALUES ("K225_16","013_25_16","2KI","25","16","16","Ikantakoetziri otzimi apite otantotari nampitsi, rootaki janta jempe oshitowaatzi nijaa, eejatzi tzinkamintsipaeni okaatzi rowetsikaantakiri paerani pinkathari Salomón. Rootaki okaatzi rowetsikaantakiri ashi tajorentsipanko, tekatsi yotatsini jempe okaatzi otenatzi. ");
INSERT INTO cpy_vpl VALUES ("K225_17","013_25_17","2KI","25","17","17","Janthari okantayita tzinkamintsi, okaatzi 18 ojanthatzi ojenokitzi. eenitatsi korikipata rowatzikaetakiri opatzikaakiki, ikaatzi ijanthatzi 3 ijenokitzi. Irijatzi rowetsikanteetantaka otantotsi, kameethari rowaneenkaetakiro. Iroka apite tzinkamintsi, tee ojamawaka ojenokitzi. ");
INSERT INTO cpy_vpl VALUES ("K225_18","013_25_18","2KI","25","18","18","Ikanta eewatziriri owayiripaeni, rotaeyakiri eejatzi iitachari Seraías, omperatajorentsitaarewo rini, eejatzi roshiyakaakiri Sofonías, irijatzi omperatajorentsitaarewo, eejatzi mawa kempoyaawentzirori tajorentsipanko. ");
INSERT INTO cpy_vpl VALUES ("K225_19","013_25_19","2KI","25","19","19","Imatanakiri atziripaeni nampitawori nampitsiki, eewatziriri owayiripaeni, raanaki 05 atziri rompera-tanewo pinkathari ipankoki ikaatzi oñaapaakiri ijeeki nampitsiki. Tema royiitatzi atziri riyoteeri jempe ikanta rowayiriteeta. Raanaki ikaatzi 60 riroperori atziri, riitaki iñahaetapaaki ijeeki nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("K225_20","013_25_20","2KI","25","20","20","Ikanta irika Nabuzaradán, raanakiri ikaatzi rotaeyakiri ijeeki iwinkatharite Babilonia-jatzi, ari inampitawori rirori iiteetziro Ribla, ");
INSERT INTO cpy_vpl VALUES ("K225_21","013_25_21","2KI","25","21","21","Rootaki iipatsite Hamat. Ari ikantakiri iwinkatharite Babilonia-jatzi: “Pompojeri.” Ari okanta raapithaetantakariri iipatsite Judá, raakiro itsipa atziri. ");
INSERT INTO cpy_vpl VALUES ("R224_1","015_24_1","2CH","24","1","1","eenitatsi 7 rojarentsite Joás retantanakawori ipinkatharitzi. Tema 40 ojarentsi okaatzi ipinkatharitaki Jerusalén-ki. Iroka owaero riniro, oeta Sibia, opoñaawo roori iiteetziro Beerseba. ");
INSERT INTO cpy_vpl VALUES ("R224_2","015_24_2","2CH","24","2","2","Maawoeni rantakiri Joás kameethari okantaka iñaakiro Tajorentsi, ari ikaatakiri omperatajorentsitaarewo iiteetziri Joeada. ");
INSERT INTO cpy_vpl VALUES ("R224_3","015_24_3","2CH","24","3","3","Irika Joeada, apite okaatzi iina, rootaki rowaeyakaakari. Tzimaki itomipaeni eejatzi rishintopaeni. ");
INSERT INTO cpy_vpl VALUES ("R224_4","015_24_4","2CH","24","4","4","Okanta ojamanitaki, ikenkithashiretaka Joás rowetsikaero itajorentsipankote Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("R224_5","015_24_5","2CH","24","5","5","Ipiyotakiri maawoeni omperatajorentsitaarewo, eejatzi isheninkapaeni Leví. Ikantakiri: “Panashitero maawoeni inampitsite Judá, pikowakoteri iyorikite Israel-paeni, jame owetsikaero itajorentsipankote Tajorentsi. Pishintsite, eero pojamaninkiro.” Roori kantacha, tee ithaamenta isheninkapaeni Leví, tee ithaankiwentziro ikantziriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("R224_6","015_24_6","2CH","24","6","6","Ikanta pinkathari Joás, ikaemakiri omperatajorentsiperori iiteetziri Joeada, ikantakiri: ¿Iitaka kaari pithaamentanta ramantyaari koriki isheninkapaeni Leví eejatzi Judá eejatzi rashi Jerusalén-jatzi. Rootaki ikantakiri paerani Moisés, rompera-tanewo Tajorentsi, ikantakiri etakawori paerani pisheninkapaeni Israel riyoye rowetsikaetantyaari jempe ijeekaeyeni aawakaachari. ");
INSERT INTO cpy_vpl VALUES ("R224_7","015_24_7","2CH","24","7","7","Tema iroka iiteetziri Atalía, rootaki owaero kaariperori, eenitatsi osheki oyaatakirori, ikyaayitaki itajorentsipankoteki Tajorentsi. Ikyaaki tajorentsipankoki raakiro okaatzi rashitakayitariri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("R224_8","015_24_8","2CH","24","8","8","Ikanta irika pinkathari, rowetsikakaantaki ashironaki, rowakiro opatzimooki tajorentsipanko, eejatzi roshiyakahaero otsipaki nampitsi. ");
INSERT INTO cpy_vpl VALUES ("R224_9","015_24_9","2CH","24","9","9","Ari ikamanteetakiri maawoeni isheninkapaeni Judá, ari roshiyeetakiri Jerusalén-jatzi, otzimatye rashitakahaeyaari Tajorentsi, rootaki iñaani paerani Tajorentsi, ikantakiriri Moisés, ijeekantakari ochempimashiki Israel. ");
INSERT INTO cpy_vpl VALUES ("R224_10","015_24_10","2CH","24","10","10","Ari imatakiro, maawoeni jewaripaeni, maawoeni atziri, ipokaeyakini ramayitaki iyorikite, rotetakiri rowetsikashitakiriri ashironaki, riyeekitakiro. ");
INSERT INTO cpy_vpl VALUES ("R224_11","015_24_11","2CH","24","11","11","Ikanta isheninkapaeni Leví, riitaki ayirori ashironaki jempe ijeeki pinkathari, okine raminero rirori. Ikanta iñaakiro tzimaki osheki koriki, ipokaki jankinatatsiri iyaemakaantani pinkathari itsipatakari aminerini antawaeyitatsini, riitaki owakiriri omperatajorentsiperori, rosokakiri koriki jaekiteentsiri. Aririka ithonkakiri raminakiri, rotetaneeri. Ari ikantatziiro maawoeni kitejeri. Osheki koriki raakiri. ");
INSERT INTO cpy_vpl VALUES ("R224_12","015_24_12","2CH","24","12","12","Ikanta pinkathari itsipatakari Joeada, ipapiintakiri koriki aminakaantzirori rowetsikaero tajorentsipanko, riitaki aminatsini amitakoterini rowetsikaero tajorentsipanko. Otzimatye eejatzi ramine owetsikayitzirori oetarika, rootaki rowetsikanteeyaawori tajorentsipanko. ");
INSERT INTO cpy_vpl VALUES ("R224_13","015_24_13","2CH","24","13","13","Ari retanakawo rantawaetanaki ikaatzi rowaetakiri rantawaete. Thaamenta ikanteeyani, rowetsikaero tajorentsipanko rashi Tajorentsi, imateero jempe okanta rowetsikaetakiro paerani. Kameethari ikanteero rowetsikaero. ");
INSERT INTO cpy_vpl VALUES ("R224_14","015_24_14","2CH","24","14","14","Ikanta ithonkari, ikaemaetakiri pinkathari itsipatakari Joeada, ipaeri koriki tzimahaantapaentsiri. Riitaki rowetsikaetakiri jemperika ikowaeyirini ashi tajorentsipanko. Rootaki imatantapiintyaawo ipinkathateeri Tajorentsi, pitayeeniri patsipetakaani, pimateero eejatzi okaatzi rowetsikanteetakariri ooro eejatzi koriki. Eeniro rañi Joeada, osheki rowamaapiinteetaki ratsipetakaani kameethatzimotziriri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("R224_15","015_24_15","2CH","24","15","15","Roori kantacha, antyashiparitapaaki Joeada, ikanta imaperotaka, kamaki. Osheki okaatzi rojarentsite, okaatzi 130 ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("R224_16","015_24_16","2CH","24","16","16","Ikitaetakiri nampitsiki jempe inampitawo paerani pinkathari David, itsipataari jempe ikitata paashinijatzipaeni pinkathari. Riitaki pinkathariwentakiriri kameethaeni maawoeni Israel, raakameethatakiri Tajorentsi, aritaki roshiyakaahaeri ikaatzi antawaetatsiri tajorentsipankoki. ");
INSERT INTO cpy_vpl VALUES ("R224_17","015_24_17","2CH","24","17","17","Tema kamaki Joeada, areeteeyakani reewaritepaeni Judá, owanaana ikimoshirewenteetakiri pinkathari. Ikowapiintaki ikaminaeteri rantantyaawo kameethari. ");
INSERT INTO cpy_vpl VALUES ("R224_18","015_24_18","2CH","24","18","18","Ikanta ipiyapithatanaari tajorentsipankoki ijeekaki Tajorentsi, itajorentsite icharinipaeni paerani, osheki piyowentawaariri Asera, imatzitakawo eejatzi tajorentsiniropaeni. Rootaki ikijantanakari Tajorentsi, ikijanakiri Judá eejatzi Jerusalén. ");
INSERT INTO cpy_vpl VALUES ("R224_19","015_24_19","2CH","24","19","19","Roori kantacha, rotyaantaki Tajorentsi osheki kamantantaniri, riitaki kantakahaeyaawoni ipiyayitee ikemijanteeri Tajorentsi. Roori kantacha, tee ikowaeyeni ikeme okaatzi ikaminaantawitari kamantantaniri. ");
INSERT INTO cpy_vpl VALUES ("R224_20","015_24_20","2CH","24","20","20","Ikanta Zacarías, itomi omperatajorentsitaarewo Joeada, ijeekashiretantakari ishire Tajorentsi, ikatziyaka tonkaariki ochempiki, ikaminaakiri atziripaeni, ikantziri: “Iroka ikantzi Tajorentsi: ‘¿Iitaka kaari pikemijantanta eerokapaeni nonintakaani? ¿Iitaka pikowakowatantawori pashironkaawaetya? ¡Niyotzi pipakaakina eerokapaeni, ari noshiyaari eejatzi naaka, aritaki nowawijaakoteemi eeroka!’” ");
INSERT INTO cpy_vpl VALUES ("R224_21","015_24_21","2CH","24","21","21","Roori kantacha irikapaeni, ikowaeyakini nopithokashiteri. Ishemyakiri, rootaki ikoyiri, ari okantzi Inintakaantani Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("ER1_1","016_1_1","EZR","1","1","1","Tema tzimaki apaani ojarentsi ipinkatharitzi Ciro inampiki rirori Kyaako-weniki. Ari omonkaa-tyaari iñaani Tajorentsi ikamantan-takiri paerani Jeremías. Ikantakaakari Tajorentsi pinkathari Ciro, ikamantante maawoeniki jaka ipinkathari-wentantzika, rojankineetero ikowa-kaantani rirori, ikante: ");
INSERT INTO cpy_vpl VALUES ("ER1_2","016_1_2","EZR","1","2","2","“Naaka Ciro, iwinkatharite Kyaako-weni-jatzi, iroka noñaani nokantzi: Riitaki Tajorentsi, Inkite-jatzi, nintakaa-kinawori neewawenteri pinkathari-paeni kepatsiki. Ishinetakina eejatzi nowiriinteero itajorentsi-pankote Aapatziyaweniki jeekatsiri iipatsiteki Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("ER1_3","016_1_3","EZR","1","3","3","Eenitatsi-rika rashitari Tajorentsi, aritaki ineshironka-takiri. Riyaate Aapatziyaweniki iipatsiteki Judá-paeni, ramitako-tantero ipiriinteetero itajorentsi-pankote Tajorentsi, Itajorentsite Israel, jeekatsiri janta Aapatziyaweniki. ");
INSERT INTO cpy_vpl VALUES ("ER1_4","016_1_4","EZR","1","4","4","Eenitatsi-rika awijako-teentsiri rowayiri-teetan-takariri, eeniro-rika rañaayitzi jempe-rika-paeni, ramitako-tawaeri ijeeka-nampitziri, ipayiteri: koriki, ooro, ipira, otsipa ipashitan-tayitari ikashiya-kaerori itajorentsi-pankote Tajorentsi wetsika-chani Aapatziyaweniki.” ");
INSERT INTO cpy_vpl VALUES ("ER1_5","016_1_5","EZR","1","5","5","Ikanta rowetsikae-yanakani isheninka-paeni Judá-paeni eejatzi Benjamín-paeni, jewari-paeni, Ompera-tajorentsitaa-rewo-paeni, Leví-paeni, tema riiyitaki ikowashire-takaakiri Tajorentsi rowetsikaero itajorentsi-pankote Tajorentsi janta Aapatziyaweniki. ");
INSERT INTO cpy_vpl VALUES ("ER1_6","016_1_6","EZR","1","6","6","Ramitako-tawaeri ikaatzi ijeeka-nampi-yitziri janta, ipawaeri koriki, ooro, ipira, okaatzi pinayita-chari, eejatzi otsipa okaatzi ipashitan-tayitakari. ");
INSERT INTO cpy_vpl VALUES ("ER1_7","016_1_7","EZR","1","7","7","Riima pinkathari Ciro, ramaeri okaatzi ashitari itajorentsi-pankote Tajorentsi, raanakiri paerani Nabucodonosor rowayiri-tanta-kawori Aapatziyaweni. Ikaatzi ipiyotakiri iyaapapankoteki itajorentsi-nirote rirori. ");
INSERT INTO cpy_vpl VALUES ("ER1_8","016_1_8","EZR","1","8","8","Tema ithonka roepiya-yiteeri pinkathari Ciro, ipakiri Mitrídate kempoyeeriri koriki raminiro kameetha okantayita, okantya ramayiteero. Ipapaeri rirori Sesbasar, reewarite Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("ER1_11","016_1_11","EZR","1","11","11","Iroka ikaatzi ipiyotaka koriki eejatzi ooro, ikaatzi 5400. Tema riitaki ramaeri Sesbasar roepiyeeri Aapatziyaweniki, itsipayi-taari noshikaa-rewo-paeni rompera-waeteetari Kompitaariki. ");
INSERT INTO cpy_vpl VALUES ("ER2_68","016_2_68","EZR","2","68","68","Ikanta ipokaeyakini jewari-paeni iñaapaakiro itajorentsi-pankote Tajorentsi janta Aapatziyaweniki, ipiyoyi-tapaaki ipashiyi-tyaawori rowetsikan-teetee-yaawori itajorentsi-pankote Tajorentsi jaha ojeekakira. ");
INSERT INTO cpy_vpl VALUES ("ER2_70","016_2_70","EZR","2","70","70","Ari ijeekae-yapaeni irikaete Ompera-tajorentsitaa-rewo-paeni, Leví-paeni, maawoeni isheninka-paeni, mampaawae-tzinkari, aamaako-wenta-wori ikyaa-piinteetzira, eejatzi ikaatzi antawae-tatsini Tajorentsi-pankoki. Ari ijeekae-yapaeni maawoeni Israel-paeni inampiiteki rirori. ");
INSERT INTO cpy_vpl VALUES ("ER3_8","016_3_8","EZR","3","8","8","Tema awijanaki apaani ojarentsi, riitaki apiteta-tsiri kashiri ijeekae-yapaeni itajorentsi-pankoteki Tajorentsi Aapatziyaweniki, ari reteeya-nakawoni rantawae-teeyini Zorobabel itomi Salatiel, Jesúa itomi Josadac, eejatzi rirentzi-paeni, Ompera-tajorentsitaa-rewo-paeni, eejatzi Leví-paeni. Maawoeni ikaatzi piyayitaa-chari Aapatziyaweniki inoshika-witee-takari. Ari rowaetakiri maawoeni Leví-paeni, reteeta-nakari kaayi-teentsiri 20 rojarentsite, tema riiyitaki jewatakaan-teroni rowetsikae-teero itajorentsi-pankote Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("ER6_14","016_6_14","EZR","6","14","14","Ari ikantakari maawoeni rantariperote Judá-paeni, eekiro riyaata-kaana-kitziiro rantawaeri rowetsika-yiteero, imonkaa-tziro okaatzi ikantziri Kamantan-taniri Hageo eejatzi Zacarías itomi Iddo. Tema imateero rowetsika-yiteero, roojatzi ithonkan-takawori rantawaeri, imatakiro ikantakiriri Tajorentsi Itajorentsite Israel. Imatakiro eejatzi ikantakiriri pinkathari Ciro, Dario, eejatzi Artejerjes, pinkathari-wentan-tatsiri Kyaako-weniki. ");
INSERT INTO cpy_vpl VALUES ("ER6_15","016_6_15","EZR","6","15","15","Tema ithonkae-teero rowetsikae-teero tajorentsi-panko kitejeri mawa, kashiriki iiteetziri “Shipakiryaari”. Tema rootaki 6-tatsiri ojarentsi ipinkathari-wentantariri Dario Kyaako-wenijatzi. ");
INSERT INTO cpy_vpl VALUES ("ER6_16","016_6_16","EZR","6","16","16","Tema antawo roemoshirenkae-yakironi maawoeni Israel-paeni, itajorentsi-pankote Tajorentsi, itsipayi-takari isheninka-paeni noshikaa-rewo-paeni ikaatzi piyayitaa-chari, eejatzi Ompera-tajorentsitaa-rewo-paeni, Leví-paeni, ithaamenta-wentee-yakawoni. ");
INSERT INTO cpy_vpl VALUES ("JB1_1","019_1_1","JOB","1","1","1","Eenitatsi janta Kaminaa-weniki apaani atziri iitachari Job. Kameetha-shireri irika atziri, tampatzika-shireri, ipinkathatziri Tajorentsi, iwinkani rirori kaaripero-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("JB1_2","019_1_2","JOB","1","2","2","Eenitatsi ikaatzi 7 itomi, mawa rishinto. ");
INSERT INTO cpy_vpl VALUES ("JB1_3","019_1_3","JOB","1","3","3","Riroperori irika atziri rawijiri ikaatzi inampiteeya-woni ishitowa-piin-tzira ooryaa. Itzimi-motziri osheki ipira-paeni, osheki eejatzi rompera-tani-paeni. ");
INSERT INTO cpy_vpl VALUES ("JB1_4","019_1_4","JOB","1","4","4","Tema roetziñaarikotakawo rowawae-teeyani itomi-paeni ipankoki, retanakawo apaani itomi, otsipa kiteejeri itsipa itomi, imatakiro maawoeni itomi. Ikaemakaan-tziro mawa ritsiro akiyoteri roemoshirenkae-yani, eejatzi rirawae-teeyini. ");
INSERT INTO cpy_vpl VALUES ("JB1_5","019_1_5","JOB","1","5","5","Ikanta imonkaa-takiro roemoshirenka-waeta ikaateeya-kini, ikaemiri Job itomi-paeni, rowetsika-shire-takaeyaari. Okiteeje-tamanee ipiriinta. Kachaamaetatsi itaawentziri itomi, retanakari apaani, eejatzi ikantakiri itsipa, ari ikantziri maawoeni ikaateeyinira. Tema ikanta-shire-tatzii Job: “Aamaashityaa kaariperotaki notyomi-paeni, ikijima-shire-tawae-takiri Tajorentsi.” Ari ikantapiin-tatziiro. ");
INSERT INTO cpy_vpl VALUES ("JB1_6","019_1_6","JOB","1","6","6","Okanta paata riyaateeya-kini ronampiripaeni Tajrentsi ikemijanteri oeta ikanteriri, eejatzi jatzitanaka Yakatantaniri rirori. ");
INSERT INTO cpy_vpl VALUES ("JB1_7","019_1_7","JOB","1","7","7","Rojampi-tawakiri Tajorentsi irika Yakatantaniri, ikantziri: “¿Jempema pipoñaana-kawoka?” Ikantzi Yakatantaniri: “Nopoñaakawo janta nokinakina-waetzi nanashi-tawo maawoeni kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("JB1_8","019_1_8","JOB","1","8","8","Ikantzi Tajorentsi: “¿Piñaakirima nompera-tani Job? Tekatsi oshiyaarini rirori janta kepatsiki, kameetha-shireri irika notyomyaayi, tampatzika-shireri, ipinkathatana naaka, iwinkani rirori kaariperori.” ");
INSERT INTO cpy_vpl VALUES ("JB1_9","019_1_9","JOB","1","9","9","Rakanaki Yakatantaniri, ikantzi: “¡Jha! ¿Poshiyakaan-tzima, ipinkatha-tashi-tzimi Job?” ");
INSERT INTO cpy_vpl VALUES ("JB1_10","019_1_10","JOB","1","10","10","¿Tema piñiiro osheki paminako-wenta-kiri rirori, eejatzi ikaatzi jeeka-panko-tziriri, maawoeni okaatzi tzimimo-tziriri? Pitajonka-wentakiniri maawoeni rantawaero, rootaki oshenitan-takari otzimi-motziri oeta-rikapaeni janta kepatsi-kinta. ");
INSERT INTO cpy_vpl VALUES ("JB1_11","019_1_11","JOB","1","11","11","Ajatyaa, pakotashiteri eeroka nimaeka, paapithateri okaatzi tzimimo-takiriri, aritaki ikijima-waetanakimi eeroka.” ");
INSERT INTO cpy_vpl VALUES ("JB1_12","019_1_12","JOB","1","12","12","Ikantzi Tajorentsi: “Piñaakiro eeroka okaatzi tzimimo-takiriri, pimatiro okaatzi pikowakiri. Eerowakya pikosheka-waetari iwathaki rirori.” Piyanaka Yakatantaniri ikenkitha-waetakaerira Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JB1_13","019_1_13","JOB","1","13","13","Okantaka ijeekaeyini itomi-paeni Job itsipa-teeyawo ritsiro rowawae-teeyani, rirawae-teeyini imiri ipankoki rantariti rirentzi. ");
INSERT INTO cpy_vpl VALUES ("JB1_14","019_1_14","JOB","1","14","14","Ari rareetapaaka kamanterini Job, ikantapaa-kiri: “Nojeeka-mintheetzi owaantsiki noshewa-takaeri kepatsi piwaakate, ari rowawae-teeyani eejatzi piyawayo-tepaeni okaakiini. ");
INSERT INTO cpy_vpl VALUES ("JB1_15","019_1_15","JOB","1","15","15","Ari romapoka-shitaka rareeteeya-paakani koshintzipaeni, ithonkapaakiri rowamaapaakiri pompera-tani-paeni, raanakiri maawoeni pipira-paeni. Apatziro noshiyaka naaka namimiro iroka ñaantsi.” ");
INSERT INTO cpy_vpl VALUES ("JB1_16","019_1_16","JOB","1","16","16","Tekiraatami ithonkiro ikenkitha-waetzi shiyeenchari ikamantantzi, areetapaaka itsipa, ikantapaaki: “Ayiitaki ookatha-rentsi, othonkapaakiri otaapaakiri pipira-paeni eejatzi ikaatzi aminakowen-tziriri, othonkakiri maawoeni. Apatziro noshiyaka naaka namimiro iroka ñaantsi. ");
INSERT INTO cpy_vpl VALUES ("JB1_17","019_1_17","JOB","1","17","17","Tekiraatami ithonkiro ikenkitha-waetzi shiyeenchari ikamantantzi, areetapaaka itsipa, ikantapaaki: “Ipokaeya-kini mawa rapato-yitzirira rowayirite Oshewa-weni-jatzi, rowayiri-tapaa-kina, ithonkanakiri raanakiri ikyaakoe-tari pipira-paeni, rowamaana-kiri ikaatzi aminakowen-tziriri rowamaantakari iyotsiroshithakite. Apatziro noshiyaka naaka namimiro iroka ñaantsi. ");
INSERT INTO cpy_vpl VALUES ("JB1_18","019_1_18","JOB","1","18","18","Eekiro ikinkitha-waewitatya shiyeenchari ikamantantzi, areetapaaka itsipa, ikantapaaki: “Ijeekaeyini pitomi-paeni itsipa-teeyawori ritsiro rowawae-teeyani, rirawae-teeyini imiri ipankoki pantarite pitomi, ");
INSERT INTO cpy_vpl VALUES ("JB1_19","019_1_19","JOB","1","19","19","omapoka-shitaka antawo tampyaa okinapaa-kiro ochempi-mashiki, othonkakiro eewokapaa-kiro pankotsi, opetaryaa-nakiro, anawiyaa-kiri maawoeni pitomi-paeni, kamaki. Apatziro noshiyaka naaka namimiro iroka ñaantsi.” ");
INSERT INTO cpy_vpl VALUES ("JB1_20","019_1_20","JOB","1","20","20","Katziyanaka Job, itzijaa-nakiro iithaari okatsi-tzimo-neentana-kiri, rameetana-kiro iishi. Ari rotziwerowa-naka kepatsi, amananaka, ");
INSERT INTO cpy_vpl VALUES ("JB1_21","019_1_21","JOB","1","21","21","ikantzi: “Nokaanki-mereki-tzitapaaka otzimantakinari ashitanari, Nokankimerekitanee eejatzi nopiyeero janta. Riitaki Tajorentsi pakinawori, riijatzi Tajorentsi aapitha-taanawori. ¡Ikimoshirewenteetero iwaero Tajorentsi! ");
INSERT INTO cpy_vpl VALUES ("JB1_22","019_1_22","JOB","1","22","22","Okantawitaka maawoeni iroka-paeni, tee ikaaripero-waetanaki Job, tee iñaawaetzi apaani ñaantsi karipero-tatsiri ikijimateri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JB2_1","019_2_1","JOB","2","1","1","Okanta otsipa kiteejeri rapiitakiro riyaateeyini ronampiripaeni Tajorentsi ikemiri Tajorentsi oeta ikanteriri, eejatzi riyaatzitanaa rirori Yakatantaniri ikemiri Tajorentsi oeta ikanteriri. ");
INSERT INTO cpy_vpl VALUES ("JB2_2","019_2_2","JOB","2","2","2","Ikantawaeri Tajorentsi irika Yakatantaniri: “¿Jempema pipoñaana-kawoka?” Ikantzi Yakatantaniri: “Nopoñaanakawo janta nokinakina-waetzi nanashi-tawo maawoeni kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("JB2_3","019_2_3","JOB","2","3","3","Ikantziri Tajorentsi irika Yakatantaniri: “¿Piñaakirima nompera-tani Job? Tekatsi oshiyaarini rirori janta kepatsiki, kameetha-shireri irika notyomyaayi, tampatzika-shireri, ipinkathaperotana, iwinkani rirori kaariperori, aamawentacha tee ikoyi rowaaripero-tanti. ¡Eenitzimaetacha ikameetha-shiretzi, okantawitaka pinintakaa-witakina eeroka noshine-temiri pikaaripero-takaerimi.” ");
INSERT INTO cpy_vpl VALUES ("JB2_4","019_2_4","JOB","2","4","4","Rakanaki Yakatantaniri, ikantzi: “Eerorika ikoshekae-tari iwathaki apaani atziri, roojatzi inimowaeteri. Tema kantacha ishinetero apaani atziri maawoeni tzimimo-tziriri rowawijaa-kotantyaawori rañaamento eero ikamanta. ");
INSERT INTO cpy_vpl VALUES ("JB2_5","019_2_5","JOB","2","5","5","Ajatyaa pantziteri itonki-paeni eejatzi iwatha. Aritaki ikijima-waetanakimi eeroka.” ");
INSERT INTO cpy_vpl VALUES ("JB2_6","019_2_6","JOB","2","6","6","Ikantzi Tajorentsi: “Piñaakiri eeroka pimateri jempe okaata pikowakiri. Roo kanteencha eero pikoshekitari rañaa-mento.” ");
INSERT INTO cpy_vpl VALUES ("JB2_7","019_2_7","JOB","2","7","7","Piyanaa yakatantaniri ikenkitha-waetakaerira Tajorentsi, roojatzi omatantanakari mantsiya-rentsi Job, ithonkanaka ipathaa-waetanaki iwathaki etanakari iitziki roojatzi iitoki. ");
INSERT INTO cpy_vpl VALUES ("JB2_8","019_2_8","JOB","2","8","8","Ikanta Job, jeekawaetanaki jampomashiki. Raaki chomosheta, rootaki ikaentantari iwathaki. ");
INSERT INTO cpy_vpl VALUES ("JB2_9","019_2_9","JOB","2","9","9","Okantakiri iina: “¿Roojatzima pikanta pikameetha-shiretzi? ¡Pikiji-matiri Tajorentsi, pikami!” ");
INSERT INTO cpy_vpl VALUES ("JB2_10","019_2_10","JOB","2","10","10","Ikantanaki rirori: “¡Noená! Poshiya-kotakawo piñaawaetaki apaani tsinani kaari yowae-matsi-tatsini. ¿Tema ipaero Tajorentsi okaatzi kameetha-tzimo-teeri, eeroma ipaero eejatzi okaatzi akematsiyityaari? Okantawitaka maawoeni iroka-paeni, tee ikaaripero-waetzi Job, tee iñaawaetziro apaani ñaantsi karipero-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("JB3_1","019_3_1","JOB","3","1","1","Ikanta iñaakiro Job okaatzi awijimo-yitakiriri, tee imaeritanee, ñaawaetanaki riyakatziro kiteejiri itziman-takari paerani. ");
INSERT INTO cpy_vpl VALUES ("JB3_2","019_3_2","JOB","3","2","2","Ishintsitanakiro iñaawae-tanaki, ikantanaki: ");
INSERT INTO cpy_vpl VALUES ("JB3_11","019_3_11","JOB","3","11","11","¿Iitaka kaari ookaanitanta paerani ashitanari eeniro omotzitana? ¿Iitaka kaari nokaman-tapaaka owakira notzimapaaki? ");
INSERT INTO cpy_vpl VALUES ("JB19_25","019_19_25","JOB","19","25","25","Roo kanteencha, niyotzi naaka añaatsi Owawijaakotenani. Riitaki kijakowen-teenani paata jaka kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("JB19_26","019_19_26","JOB","19","26","26","Okantawi-takyaa oparyaa-pithayite iroka nomashi, Aritaki noñeeri Tajorentsi koñaatziro nowathaki. ");
INSERT INTO cpy_vpl VALUES ("JB27_1","019_27_1","JOB","27","1","1","Eekiro iñaawae-tanakitzii Job, ikantanaki: ");
INSERT INTO cpy_vpl VALUES ("JB27_6","019_27_6","JOB","27","6","6","“Ashi noyiro nokameetha-shiretzi, tekatsi ookakae-nawoni, Niyotzi naaka, tekatsi kariperori nantzimo-tanteri riyakowen-tanteetinari.” ");
INSERT INTO cpy_vpl VALUES ("JB30_26","019_30_26","JOB","30","26","26","Noshiyakaa-minthee-tziro kametha nokimo-shire-waete, opokimo-tashi-takina kaariperori. Noyaako-minthee-tziro nokoñee-tyaakote, opokimo-tashi-takina tsirenikaakiri. ");
INSERT INTO cpy_vpl VALUES ("JB30_27","019_30_27","JOB","30","27","27","Tee okaatzi ominthaaha-shiretana, Tema osheki kiteejeri nokemaatsiwaetyaa. ");
INSERT INTO cpy_vpl VALUES ("JB30_28","019_30_28","JOB","30","28","28","Owashiretakina, tee noñiiri ooryaa, Nokatziyaka ipiyo-tapiintaha asheninka-paeni, nokowako-witakari ineshironkatina. ");
INSERT INTO cpy_vpl VALUES ("JB31_2","019_31_2","JOB","31","2","2","¿Jempema ikantinaka Tajorentsi Inkite-jatzi? ¿Oetaka rantzimo-tinari Shintsi-perori poñaachari jenoki? ");
INSERT INTO cpy_vpl VALUES ("JB31_3","019_31_3","JOB","31","3","3","¿Tema rowajankiteeri rirori antzirori mashirenka-taantsi? ¿Tema rowashironkayiri antzirori kaariperori? ");
INSERT INTO cpy_vpl VALUES ("JB31_4","019_31_4","JOB","31","4","4","¿Tema iñiiro Tajorentsi okaatzi nantziri? ¿Tema riyotziro naatzika-yitzi jempe-rika-paeni nanashita? ");
INSERT INTO cpy_vpl VALUES ("JB31_5","019_31_5","JOB","31","5","5","“¿Nokenki-shiryaama naaka notheeya-waetyaa? ¿Noshiyatyaama niyaayite namatawi-tante?” ");
INSERT INTO cpy_vpl VALUES ("JB31_6","019_31_6","JOB","31","6","6","¡Rahaena Tajorentsi itena-mentoki, Rootaki tampatzika-tatsiri otenatantzi, otenatziro okaatzi nantziri kameetha-tatsiri! ");
INSERT INTO cpy_vpl VALUES ("JB38_1","019_38_1","JOB","38","1","1","Ari rakanakiri Tajorentsi irika Job ijeekan-takawo tampyaa, ikantakiri: ");
INSERT INTO cpy_vpl VALUES ("JB38_4","019_38_4","JOB","38","4","4","“¡Job! ¿Jempema pijeekika eeroka owakira nowetsikan-taka-wori kepatsi? ¡Pakina, kyaari-perorika piyotanitzi! ");
INSERT INTO cpy_vpl VALUES ("JB38_5","019_38_5","JOB","38","5","5","¿Tema naaka kowaentsiri jempe iweyaa-thapi-yityaa kepatsi? ¿Tema naaka monkaatan-takawori shiwitha iroka keepatsi? ");
INSERT INTO cpy_vpl VALUES ("JB38_6","019_38_6","JOB","38","6","6","¿Tema naaka kijotakaa-kirori kepatsi nowetsikan-taka-wori? ¿Oshiyawi-takawo nowakityeeromi mapipaeni onampinaki pankotsi okijotan-tyaari? ");
INSERT INTO cpy_vpl VALUES ("JB38_7","019_38_7","JOB","38","7","7","Tema rootaki nantakiri paerani nowetsikan-taka-wori iroka kepatsi, rakishiyeen-kata-ha romampae-yani kiteje-takori ompokiropaeni, Tema thaamenteeyachani irika ronampiripaeni Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JB42_1","019_42_1","JOB","42","1","1","Rakanaki Job ikantana-kiri Tajorentsi: ");
INSERT INTO cpy_vpl VALUES ("JB42_2","019_42_2","JOB","42","2","2","Niyotzimi naaka pimatziro maawoeni pithotyeero, Niyotzimi eeroka ashitawori maawoeni kenkishiryaantsi. Tema tekatsi omani-mo-temini. ");
INSERT INTO cpy_vpl VALUES ("JB42_3","019_42_3","JOB","42","3","3","¿Jempema noetaka naaka, eero otzimi-motantana niyotani, nokijo-shire-wentantyaawori pikaminaan-tziri? Noñaawae-tashi-waetaka naaka, teemaeta nokemathatziro noñaawae-tziri, Tema omapokakina tee noñaapiintziro naaka awijimotakinari, osheki okompi-tzimo-takina. ");
INSERT INTO cpy_vpl VALUES ("JB42_4","019_42_4","JOB","42","4","4","Pikemi, nokoyi noñaanatemi. Pakina okaatzi nojampi-timiri, piyoteena eejatzi. ");
INSERT INTO cpy_vpl VALUES ("JB42_5","019_42_5","JOB","42","5","5","Tema nokema-shitzimi piñaawaetzi, tee noñiimae-tzimi, Rooma nimaeka noñaakimi, naminakimi koñaatziro. ");
INSERT INTO cpy_vpl VALUES ("JB42_6","019_42_6","JOB","42","6","6","Rootaki owatsima-waeta-kinari naaka, Noñiiro nojeeka-waematsitaki jamampoki, eejatzi kaahashi-mashiki iñaantee-tinari nopakahaero noñaawae-tashi-waetari. ");
INSERT INTO cpy_vpl VALUES ("JB42_10","019_42_10","JOB","42","10","10","Ikanta ramana-kotakari Job itsipamintha-tani-paeni, ikantakaa-kawo Tajorentsi awijimo-teeri ikemaatsi-waeta-kari. Tema ipaperoteeri osheki tzimimo-teerini Job, awijanakiro osheki-perotzi okaatzi tzimimo-witariri ketziroeni. ");
INSERT INTO cpy_vpl VALUES ("JB42_11","019_42_11","JOB","42","11","11","Ipokaeya-kini rirentzi, ritsiro-paeni, eejatzi ikaatzi yotziriri paerani. Rakiyoteeya-kirini ipankoki. Osheki imoshireta-kayitakiri, ikantziri: “¡Aapa! Osheki rowashironkaa-kimi Tajorentsi, patsipe-takawo pikemaatsi-waeta-ka.” Ipashiyi-tapaakari ikaatzi areetaka-riri ipankoki, eenitatsi pakiriri koriki, itsipa ipayitakiri kantatepokitachari ooro. ");
INSERT INTO cpy_vpl VALUES ("JB42_12","019_42_12","JOB","42","12","12","Itajonka-wenteeri Tajorentsi irika Job, rawijakaa-kiri jempe ikantawita ketziroeni. Osheni-pero-tanee ipirayitari. ");
INSERT INTO cpy_vpl VALUES ("JB42_13","019_42_13","JOB","42","13","13","Itzimae 7 itomi, eejatzi mawa rishinto. ");
INSERT INTO cpy_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Tajorentsi! Tee pinaamatawo eeroka kaari kamethatatsiri, Eero okanta raapatziyee-mi kaaripero-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Eero okanta itsipa-teemi kantakaa-perori-paeni. Tema ikijaneentzimi eeroka ikaatzi antzirori kaari-perori. ");
INSERT INTO cpy_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Romampaani David Ikenkishirya Ishiya-pithateri Kowatsiri Rowamayeri Tajorentsi! Notajorentsite! ¿Iita pookawentan-tanari? ¿Iita kaari pipokanta powawijaa-koteena? ¿Iita kaari pikemantana nashironkaa-waeta? ");
INSERT INTO cpy_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Tajorentsi! Nokaema-witzimi kitejepaeteki, teemaeta pakana. Nomawitakawo tsireni-paeteki, teemaeta netsinaryaa-kotzi, ");
INSERT INTO cpy_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Roo kanteencha, eeroka tajorentsi Tema pijeeki eeroka jempe romampahaeyani Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Eeroka rawentaaka paerani nowaejatzite-paeni. Rawentaa-yitakimi, pookakaa-wenta-yitakiri eeroka. ");
INSERT INTO cpy_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Ikowako-takimi pikijawen-tyaari, pimatakiro pookakaa-wenta-yitakiri. Rawentaa-yitakimi eeroka, tekatsi owashiwentaayiteerini. ");
INSERT INTO cpy_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Tema naaka atziri naawita, roo kanteencha ikimita-kaeta-kina chowitsi. Osheki imaninta-waetakina atziri-paeni, itheenka-shire-waetakina. ");
INSERT INTO cpy_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Ishironta-wenta-waetakina ikaatzi ñaayitanari, Itsimetsi-kyaawae-teetakina, roteka-yina-waeta, ikanteeyini: ");
INSERT INTO cpy_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Piñaa-matsiteri awentaariri Tajorentsi. Añaawakiri aririka ramitako-teeri. Tema ikantatzi osheki ineshironka-tziri, añaawakiri aririka rowawijaa-koteeri.” ");
INSERT INTO cpy_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Tema eeroka kantakaakawo notzimantakari omotzitakinaha ashitanari. Eeroka kantakaakawo nawentaan-tzimiri eenirowa nothotzi noteni. ");
INSERT INTO cpy_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Eeroka ashitakinari tekiraaha notzimi. Eeniro nojeeki omotziki ashitanari, eeroka Notajorentsite. ");
INSERT INTO cpy_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Eero pijeeka-pithatana inteena, tema okaakitaki nokemaatsi-waetyaa. Tekatsi kijakowente-nani. ");
INSERT INTO cpy_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Tema ithonka rotzikakina kijaneentanari, roshiyakari ipiyoteeyani waakapaeni, Roshiyakari imashirenka poñaachari Kithoki-shaariki, ithonka rinkitee-yakinani. ");
INSERT INTO cpy_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Pahaankaeyakini ikaatzi kijaneentanari, Roshiyakari manitzi rowari iwathatsite, pirinkae-kimashitaki. ");
INSERT INTO cpy_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Tema noshiyakawo naaka nijaa ijakoe-tziri, Tema thonkaka okitho-ryaayitaki notonki. Oshiyakawo najankane iwyaaha-chari, tema thonkaka iwyaahaka inthomoeki. ");
INSERT INTO cpy_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Tema piryaa-kentsitakina, oshiyakawo opiryaatzi chomo-petoki. Tsirekaka nonene nopatzi-thaanteki. Tema pookakina jempe opiryaa-panetzi kepatsi nokami. ");
INSERT INTO cpy_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Tema roshiyakari otsitzi ipiyowentee-yakinani kaari-perori, ithonka rinkita-paakina. Iwena-waetakina nakoki eejatzi noetziki. ");
INSERT INTO cpy_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Iyoshii-tashitaka nomashi, koñaa-pookitaki notonki. Osheki ramina-mintha-takina kijaneentanari. ");
INSERT INTO cpy_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Ipawakaakawo nomaatha. Iñaaryaa-wentakawo riyotan-tyaari itzimi-rika ayironi. ");
INSERT INTO cpy_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","¡Rooma eeroka Tajorentsi, eero pookawentana! Eeroka shintsi-takahaanari. Pipoki intsipaete pikijawentena. ");
INSERT INTO cpy_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Amaanikiini noyeeri Tajorentsi. Ari rowayempitataana, ari ikemaena nokaemirira. ");
INSERT INTO cpy_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Rowawijaakotaana nokamaemi ikitatanteetenarimi. Rowawijaakotakina eejatzi oniyenami sampowatha. Ikatziyakahaana okijopathatzira kepatsi. Ramitakotaana nanashitantaari kameethari, tee nantziwawaeta. ");
INSERT INTO cpy_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Roma-mpaakahaanawo owakirari omampahaantsi. Eejatzi weshiryaantsi, rootaki nokimoshirewentantariri Tajorentsi. Osheki ñaayitawakirori iroka, riyokitziiwentayitakiro. Roowa rawentaantanakariri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Kimoshireri ikanteeya awentahaeyaarini Tajorentsi. Kaari aapatziyeeyaarini shamewaetatsiri, Kaari amanariri tajorentsiniro. ");
INSERT INTO cpy_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","¡Noyinkatharite! Tajorentsi, pitajonkawentantapiintee, Osheki poshiretapiinteena, Tekatsi oshiyeemini eeroka, Noñaawenawitakawo nokamanteri itsipapaeni atziri okaatzi pitajonkawentantayitakira. Roori kantzimaetacha oshekiperotanee jempe okaatzi kaari riyoteetzi. ");
INSERT INTO cpy_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Tee pikowamatsiteero ramayiiteemi ratsipetakaani, eejatzi rashitakahaetemiri. Tema pikemathatakahaanawo, Teera intaani onimotemi itayeetzimiri pirahaatsi, eejatzi ikaatzi ramayitzimiri rashitakaayitzimiri. ");
INSERT INTO cpy_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Pikeme nokante naaka: Ari nopokaki. Tema rojankinatakoyiitakina paerani. ");
INSERT INTO cpy_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Ari onimotakina nanteemiro okaatzi pikowakayinari. Oshiyaawo pojankinashiretantatyeenawomi pinintakaantani. ");
INSERT INTO cpy_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Rojankinari David, ikantanaka Kamantantaniri Natán ishintsineentanakiri, tema riyotakoetakirowa rantakiro kaariperori imayempitakiro Betsabé ¡Tajorentsi! Eeroka neshironkatantaniri, pikaminthahaena. Tema eerokataki etakotantaniri, pipeyakoteenawo okaatzi nantakiri. ");
INSERT INTO cpy_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Pipakaa-kahaenawo okaatzi kariperotakaakinari. Poetenteena nokaariperotakira. ");
INSERT INTO cpy_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Niyotzi osheki nopiyathawaetakimi. Tee omata nomaejantero nokaariperotakira. ");
INSERT INTO cpy_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Apatziro nokaariperotzimotakimi eeroka. Nantashitakawo okaatzi pipinkakaanari. Tema okaate pikanteeri eeroka, kametha otampatzikate, Eeroka kiteshireri pimatantawori pipiyakowentantzi. ");
INSERT INTO cpy_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Tema kaariperotakina naaka, ari nokantzita owakira notzimapaaki. Nokaariperotzita inthomoeki omotziki ashitanari, jaka anteetzirowa kaariperoyitatsiri. ");
INSERT INTO cpy_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Pineshironkatziri eeroka kameethashireri, Piyo-shiryaakahaa-nawo piyotaninka. ");
INSERT INTO cpy_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Pikimitakaena poetetantyeenawomi kaawoshirontsi, eero nopitsiwaetanta. Pikaawoshiteena, aritaki nokitamaatanee kameetha, ari nawijanakiro okaatzi okitamaatzi jiriniki. ");
INSERT INTO cpy_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Pikantakaeyaawo nokemanteeyaawori jempe ikimoshireteetzi, eejatzi jempe ithaamenteeta. Piwiriintapookiteena powatsinaawaetakina. ");
INSERT INTO cpy_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Pomanapithatyaawo nowaariperonka eero piñaantaawo, Posheteenawo maawoeni owaariperotakinari. ");
INSERT INTO cpy_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","¡Tajorentsí! Poeteshireteena. Powakirateenawo noshire, notampatzi-kashiretan-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Eero pookawentana, Eero paapithatanawo Pitajorenka. ");
INSERT INTO cpy_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Papiiteero pinintaakahaena pikimitaakiro paerani owakira powawijaakotakina. Potapi-shire-tantenawo roopirori Pitajorenka. ");
INSERT INTO cpy_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Rootaki niyotaanteeyaariri theenkimawaetzimiri okantakantziro tee ikemijanteemi eeroka, Ipiyashitanteemiri eeroka kaariperoripaeni. ");
INSERT INTO cpy_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","¡Apaa Tajorentsi, Owawijaakotantaniri! Pipeyakoteenawo okaatzi nompojantaki. Ari nomampaawenteemi riyoetantyaari eeroka tampatzikashireri. ");
INSERT INTO cpy_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","¡Tajorentsi! Pithaamenta-cheratakaena. Nopinkatha-waante-tanteemiro nomampaani. ");
INSERT INTO cpy_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tema te inimoteeme namashiwaetzimiri notayimiri natsipe-takaani. Te pikowaeri okatziyeenkata iyachaarinka notaashiwaetzimiri. ");
INSERT INTO cpy_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Tema rootaki pikowaperoteeri eeroka Tajorentsi piñiina okatsi-tzimo-shire-teena okaatzi nantzimotzimiri. Tema ikaatzi ikemitakaanteetari riiperori ratsipetakaetani itahaetziniriri Tajorentsi, riitaki atziri okatsi-tzimo-shiretziri iyaariperonka. ");
INSERT INTO cpy_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Paakameethateeri Kijakowentoni-jatzi, pineshironkateeri. Papiiteero pipiriinteero otantopaeni Apatziyaweni. ");
INSERT INTO cpy_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Ari rinimoteemiri itahaetziri ratsipe-takaetani kameetha-pero-tatsiri, Riitaki mapero-teeroni okatziyeenkate iyachaarinka itahaetemiri, maaroni ikaatzi rashitakaetzimiri itahaetziri. Tema itahaeteemiri ipiraetari tahaerontsiki. ");
INSERT INTO cpy_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Rojankinee-takiro romampaa-wentee-tawo ikashiya-kaakiriri Tajorentsi pinkathari David Ashi nowaero nomampaeyaa, nomampaa-wenteero ineshironka-teena Tajorentsi. Nomampaa-wenteeyaari, nokanteeri ikaate icharini-teeyaari: “Tee rookawentanta Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Nokantee eejatzi: “Ashi poyiro petakotanta. Tee pipaashini-tanitzi, poshiyakawo inkite ashi oyiro jempe okanta roori.” ");
INSERT INTO cpy_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Ikantzi Tajorentsi: “Eenitatsi nokashiya-kaeriri ikaatzi niyoshii-teeri naaka. Nokanta-pero-teeri nomperatanewo David, nokantziri: ");
INSERT INTO cpy_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Eero nookawentaari ikaate picharini-teeyaari, Naaka kantakae-yaawoni rashi rowaero ipinkathari-wentantee.’” (Pishowi-teeyini, pipiyompi-teeyini eepichokiini.) ");
INSERT INTO cpy_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Tajorentsi! Osheki ikimo-shire-wentakiro inkite-jatzi okaatzi pitajonka-wentantziri. Osheki ikenkitha-takotakimi kiteshireriite ashi poyiro eeroka tee pookawentanta. ");
INSERT INTO cpy_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","¿Eenitatsima inkite-jatzi monkaat-yaarini Tajorentsi? ¿Eenitatsima oshiyaarini Tajorentsi? Tema rawijiri riiperori jenoki-jatzi.’ ");
INSERT INTO cpy_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Tema ipiyoteeyani kiteshireri-paeni ipinkatha-tziri Tajorentsi. Maperori iriiperotzi rirori rawijanakiri ikaatzi piyowentariri. ");
INSERT INTO cpy_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Tajorentsi Ñaaperori! ¿Eenitatsima oshiyimini eeroka? Eeroka shintsi-perori. Ashi poyiro pikyaaryoo-wentantzi. ");
INSERT INTO cpy_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Otzimimo-tzimi eeroka pishintsinka pomaeryaan-tawori otamakaatzi inkaari. Pimatzitawo eejatzi oshinkiryaa-takaani tampyaa. ");
INSERT INTO cpy_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Potsinampaakiri Ajahaariweni, poshiya-kaantakari kaminkari. Tema eeroka shintsi-shempari, pomishiyakiri pikoshekani. ");
INSERT INTO cpy_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Tema eeroka ashitawo maawoeni inkite eejatzi kepatsi. Eeroka wetsikakiro kepatsi, eejatzi maawoeni tzimatsiri. ");
INSERT INTO cpy_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Eeroka wetsikakiro okaatzi tzimatsiri katonkonta eejatzi kirinkanta. Oshiyawaetaka omampaa-tyeeyaami ochempi Piyopathee-toni eejatzi Pinkaetoni, opaeriiro piwaero. ");
INSERT INTO cpy_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Tema eeroka shintsi-shempari, eejatzi okimitaka pako. Tema osheki otsinampaantaki pakoperori. ");
INSERT INTO cpy_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Eeroka kameetha-shireri pipinkathari-wentantzi, eejatzi eeroka tampatsika-shireri. Osheki petakotanta, oshiyakawo roomi jewata-piinteemini pikyaaryooperotani. ");
INSERT INTO cpy_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Tajorentsi! Tema osheki ikimoshiretzi atziri thaamenta-chari romampaa-wentzimi, Oshiyakawo ranashi-tatyeemi jempe pikoñeetyaakotziri eeroka. ");
INSERT INTO cpy_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Ashi rowaero ikimo-shiretzi ipaeriiro piwaero. Ari rajahaawenteemi, tema eeroka tampatzika-shireri. ");
INSERT INTO cpy_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Mapero, jempe pikanta eeroka, ari okanta pishintsinka, eejatzi powaneenkawo. Tema apatziro pikanta-kaawo eeroka, aririka pikoyi, pimatziro pishintsi-takaana. ");
INSERT INTO cpy_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Ikimitawo Tajorentsi riimi otzikaako-mentotsi. Riitaki Itajorentsite Israel, Awinkatharite. ");
INSERT INTO cpy_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Paerani pikenkitha-waeta-kaakiri piiteshirerite, ikemakimi ishireki. Pikantziri: “Noneshironka-takiri ñaaperori. Nopinkathari-takaakiri ikaatzi niyoyaakiri nashitari naaka.” ");
INSERT INTO cpy_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Noñaakiri nomperatanewo David. Nojee-patzii-totan-takari notajorenchaate. ");
INSERT INTO cpy_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Ashi noyiro notapi-wako-tantee-yaari nako. Ari oshintsi-shempa-takahaeri noshempa. ");
INSERT INTO cpy_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Eero rotsinampaeri ikaatzi koshekariri. Ari ikimitee-yaari kaari-perori, eero rotsinampaeri. ");
INSERT INTO cpy_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Naaka thonkirini ikaate owayirityaarini. Nothonkaeri ikaate kijaneenterini. ");
INSERT INTO cpy_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Tema kijokiro nokanteeri noneshironka-teeri, Okantakaawo ipaeryaa-piinteero nowaero otzimimo-tantee-yaariri ishintsinka. ");
INSERT INTO cpy_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Ari nokanta-kaakyaawo ipinkathari-wentantee ijeeki inkaariki. Imatero eejatzi ipinkatharite ijeeki nijaaki-paeni. ");
INSERT INTO cpy_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Ari ikantee-teena: “Tajorentsi! Eeroka ashitanari, Eeroka Notajorentsite, poshiyawo mapi nomana-mento omatantari nawijakotee.” ");
INSERT INTO cpy_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Nokimita-kaanteeri naaka nantarite notyomi. Riitaki awijirini ikaate pinkatha-wenteeroni kepatsi. ");
INSERT INTO cpy_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Rashi royiro noneshironka-teeri rirori. Eero aminaashita okaatzi nokashiya-kaakiriri. ");
INSERT INTO cpy_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Tema rashi rowaero ipinkathari-yitee ikaate icharini-teeyaari. Ari ikantee-tatyeero eeniro iñeetziri ooryaa jenokinta. ");
INSERT INTO cpy_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Aririka ipakaakiro itomi noñaani, Eerorika riyaata-kaero ithotyahero okaatzi niyotaa-kiriri, ");
INSERT INTO cpy_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","Aririka ipiyatha-takyaawo nowinka-kaantani, Eerorika ikemijantziro nokanta-kaantani, ");
INSERT INTO cpy_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","Ari nowajankitaakiri ipiyatha-takina, Nopajawenteeri ikaariperotakira. ");
INSERT INTO cpy_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","Eero nopakaemaetawo netakotee-yaari. Noejokiro-peroteeyaari, ashi noyiro notsipa-tyaari. ");
INSERT INTO cpy_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Eero nomaejantziro okaatzi nokashiya-kaakiriri. Eero nomaeritzi nokanteri okaatzi nokaman-takiriri. ");
INSERT INTO cpy_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Tema Naaka Tajorentsi kashiya-kaakiriri, Eero namatawi-tziri David, okaatzi nokantakiriri: ");
INSERT INTO cpy_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","“Ashi royiro picharini ipinkatharitee pinampiki, Ari ikantee-tatyeero ipinkatharitee eenirowa iñeetziri ooryaa eejatzi kashiri. ");
INSERT INTO cpy_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","Ari ikantee-taatyeeya ijeeki, roshiyaari kashiri, Ashi rowaero ijeekae inkiteki. (Pishowi-teeyini, pipiyompi-teeyini eepichokiini.) ");
INSERT INTO cpy_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Tema poshiya-kaakiri Tajorentsi riimi itekatsitan-teetari, rootaki pawijako-tantaari. Poshiya-kaakiri Tajorentsi Jenoki-jatzi riimi pinampi. ");
INSERT INTO cpy_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","Eero othonkaemi kaari-perori, Eero omateemi imantsiyanka ikaatzi jeeka-nampi-tzimiri. ");
INSERT INTO cpy_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Aritaki rotyaanteemi Ronampiri Tajorentsi, Riitaki aamaako-wentemini jempe-rika pikinayite. ");
INSERT INTO cpy_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Tema riitaki thomaawa-kimini Eero pompojan-tawae-tapaaka mapikinta. ");
INSERT INTO cpy_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Ronampiri tajorentsiite, tzimatsiri ishintsinka, pithaamentee-yaari Tajorentsi! Tema eerokaete antzirori okaatzi ikantzimiri. Paamawentyaa, eero pipiyathatari rompera-tzimiri. ");
INSERT INTO cpy_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Eerokaete maawoeni rowayirite, pikimo-shire-wenteeri Tajorentsi! Eerokaete romperatani, panta-piinteeniri ikoyiri rirori! ");
INSERT INTO cpy_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Eerokaete maawoeni rowetsikani Tajorentsi, Pajahaa-wentee-yaari maawoeni jempe-rika-paeni ipinkathari-wentantzi! Tema najahaa-wentari naaka Tajorentsi noshireki! ");
INSERT INTO cpy_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Tajorentsi: Ari ashi owaatyeero piñaani jenokintaki. ");
INSERT INTO cpy_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Eeroka kyaaryoowenteerini maawoeni ikaatzi añaatsiri paerani, eejatzi ikaatzi añaatsiri nimaeka, eejatzi ikaatzi tzimaatsini paata. Eeroka owetsikakirori kepatsi, rootaki opoñaantari otzimi. ");
INSERT INTO cpy_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Maawoeni okaatzi pinintakaantakiri, ari ashi owaatyeero otzimae. Tema maawoeni okaatzira tzimatsiri oshiyawaetakawo riimi pomperatani. ");
INSERT INTO cpy_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Eeroka kimoshiretakaakinari piyotaakina. Eeromi piyotaakinami, aritaki aakinami nowashirenkari. ");
INSERT INTO cpy_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Eero nopeyakoneenteero pikantakaantani, Tema ari okanteeya pijeekakahaena kameethaeni. ");
INSERT INTO cpy_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Powawijaakotaana, tema pashitaanaha, Nokemijantanakiro pikantakaantani. ");
INSERT INTO cpy_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Kijokero rowawitakina thaenkantzinkari ikoyi ithonkaatenami. Roori kantzimaetacha eekiro niyaatakaatziiro nomonkaatziro pikantakaantani, ");
INSERT INTO cpy_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Noñaayitakiro thonkanitachari maawoeni oetarikapaeni, Rooma pinintakaantani, ari ashi owaetaatyeero roori. ");
INSERT INTO cpy_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","¡Pajahaa-wentee-yaari Tajorentsi inkiteki! ¡Pajahaa-wentee-yaari ojenokiperotzinta! ");
INSERT INTO cpy_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","¡Pimateero eeroka ronampiripaeni tajorentsi, pajahaa-wentee-yaari! ¡Eeroka rowayiritepaeni inkite-jatzi, pajahaa-wentyaari! ");
INSERT INTO cpy_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","¡Eejatzi eeroka ooryaa, kashiri, pajahaa-wentyaari Tajorentsi! ¡Pimateero eeroka ikaatzi oorenta-chari, pajahaa-wentyaari! ");
INSERT INTO cpy_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","¿Pajahaa-wentee-yaari eeroka, Jenoki-pero-jatzi, Pimateero eeroka, nijaa jeekatsiri inkiteki! ");
INSERT INTO cpy_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","Pajahaa-wentee-yaawo iwaero Tajorentsi, Tema apatziro iñaawaetaki rirori, wetsika-yitanakimi eeroka-paeni. ");
INSERT INTO cpy_vpl VALUES ("IS6_1","024_6_1","ISA","6","1","1","Ikanta ikamae pinkathari Uzías, ari noñaawyaatakari Tajorentsi ijeeki iwinkatharimentoki, ipamankantakawo ikithaari tajorentsipanko. ");
INSERT INTO cpy_vpl VALUES ("IS6_2","024_6_2","ISA","6","2","2","eenitatsi jenokintaweri paamathaeteentsiri rowaatzinkaka ipatziitoki. eenitatsi 6 ishiwankiri. Apite ishiwankiri ipashikapootantari, apite okanta ipashikantari iwathaki, apite raantari. ");
INSERT INTO cpy_vpl VALUES ("IS6_3","024_6_3","ISA","6","3","3","Apiipiitziro ikanteeyini: “Kiteshire, Kiteshire, Kiteshire rini, shintsiperori Tajorentsi, Ipamankantakawo rowaniinkawo kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("IS6_4","024_6_4","ISA","6","4","4","Ikanta ikamenitanaki iñaawaetzi, antawoete omoyekanaka ashiroki tajorentsipanko, kachaariinka okantanaka tajorentsipanko. ");
INSERT INTO cpy_vpl VALUES ("IS6_5","024_6_5","ISA","6","5","5","Ari nokantashiretanaki: “¡Ikantamatsiteetana, nimaeka nokame! Nokitateeya Nowinkathariteki Tajorentsi Shintsiperori. Kaariperopaanteri nini, nojeekimotziri atziriite kaariperopaanteri.” ");
INSERT INTO cpy_vpl VALUES ("IS6_6","024_6_6","ISA","6","6","6","Ikanta apaani jenokintaweri oshiyakawori paamari, ipokashitapaakina. Ramakotaki paamarimenki raakiri taapokimentotsiki, ");
INSERT INTO cpy_vpl VALUES ("IS6_7","024_6_7","ISA","6","7","7","Rontsirokakiro nopaanteki, ikantana: “Pamine, ontsirokakimi pipaanteki paamarimenki. Ithonkaemiro piyaariperonkari, Ipeyakoeteemiro pikaariperowitakaha.” ");
INSERT INTO cpy_vpl VALUES ("IS6_8","024_6_8","ISA","6","8","8","Ari nokemaki ikenkithawaetanaki Awinkatharite, ikantzi: “¿Iitaka notyaanteri? ¿Iitaka jatatsini ikamantante?” Nakanaki naaka, nokantzi: “Naaka potyaante.” ");
INSERT INTO cpy_vpl VALUES ("IS6_9","024_6_9","ISA","6","9","9","Ari ikantanakina: “Pimatero, pikamanteeri atziriite, pikanteri: ‘Arika pikemawitya, eeromaeta pikemathatziro. Arika paminawitya, eeromaeta piñiiro.’ ");
INSERT INTO cpy_vpl VALUES ("IS6_10","024_6_10","ISA","6","10","10","Eeroka kantakahaeyaawoni ikijoshiretanteetyaari, witayempitari ikanteetya, imawityaakiyiite. Rootaki eero ikowichaatanta, Eero ikemanta, Eero ikenkithashiretanta, Tee ikemijantzi, rootaki eero rawijakotantaawo.” ");
INSERT INTO cpy_vpl VALUES ("IS6_11","024_6_11","ISA","6","11","11","Nokantziri: “¡Noyinkatharite! ¿Okaateka ojamanite iroka?” Ikantzi rirori: “Arika ithonkaeteeri paata jeekatsiri nampitsiki, Kaankipanko okanteeya pankotsipaeni, Kaankiitya okanteeya eejatzi osheki owaantsi. ");
INSERT INTO cpy_vpl VALUES ("IS6_12","024_6_12","ISA","6","12","12","Ramaeri Tajorentsi thaankiini atziriite, Kaankiite okanteeya nampitsiki tekatsi nampiteeyaawoni. ");
INSERT INTO cpy_vpl VALUES ("IS6_13","024_6_13","ISA","6","13","13","Itzimerika añaaneentsini apawopaeni, Aritaki ithonkaetakiri eejatzi irikaete, roshiyeeyaawo itowaetziro meta ari ookanakiro isankahani. Apatziro oshookamatsitee opiriniki.” ");
INSERT INTO cpy_vpl VALUES ("IS7_1","024_7_1","ISA","7","1","1","Okanta inampiite Judá-paeni ipinkatharitzira Acaz itomi Jotam icharini Uzías, ikenkithashiretaka Rezín iwinkatharite Siria-jatzi, raapatziyaari Peka itomi Remalías iwinkatharite Israel-paeni rowayirityaari Judá-paeni. Ikoyi ikye inampiiteki, teemaeta imatziro. ");
INSERT INTO cpy_vpl VALUES ("IS7_2","024_7_2","ISA","7","2","2","Ari ikamanteetakiri pinkathari Acaz itsipatakari ikaatzira jeekapankotziriri, ikanteetziri: “Raapatziyaakari Siria-jatzi Isaías. ");
INSERT INTO cpy_vpl VALUES ("IS7_3","024_7_3","ISA","7","3","3","Ari iñaanateeri Tajorentsi Isaías, ikanteeri: “Paanakiri Acaz piotonkyotyaari pinkathari Sear-jasub othapiki nampitsi roonkanaateetzirowa nijaa, iiteetziri ‘inatsiryaapankaatakotakira kiwawaerentsi’? ");
INSERT INTO cpy_vpl VALUES ("IS7_4","024_7_4","ISA","7","4","4","Pikanteri pitomi: ‘Paamahaeya, tekatsi pithaawanteeya, Tontashireri pikantya, eero pithaawantari apite oshiyakawori okachaatzi paamari, Irikaete Resín, Siria-jatzi, eejatzi itomi Remalías, katsimaki ikantaka ayimatziri mashirenkari. ");
INSERT INTO cpy_vpl VALUES ("IS7_5","024_7_5","ISA","7","5","5","Irika Siria-jatzi itsipatakari Efraín-iite itomi Remalías, ikowaeyakini rowashironkayimi. Ikanteeyakini: ");
INSERT INTO cpy_vpl VALUES ("IS7_6","024_7_6","ISA","7","6","6","“Jame aapithateri iipatsite Judá-paeni. Jame ominthaaweri ikine aapithateri iipatsite. Arika aakiro kepatsi riitaki owaeri itomi Tabeel ipinkathariwentee.” ’” ");
INSERT INTO cpy_vpl VALUES ("IS7_7","024_7_7","ISA","7","7","7","Roori kantzimaetacha ikantaki Tajorentsi: “¡Eero imatziro! ");
INSERT INTO cpy_vpl VALUES ("IS7_8","024_7_8","ISA","7","8","8","Tema Damasco rootaki otzinkamintsitari inampitsite Siria-jatzi. Riitaki Rezín iwinkatharitewitari Damasco-jatzi. Arika awijaki 65 ojarentsi, aritaki ithonkaeteeri Efraín-iite eero iñahaeteero inampiite. ");
INSERT INTO cpy_vpl VALUES ("IS7_9","024_7_9","ISA","7","9","9","Rootaki Samaria otzinkamintsitari inampi Efraín-iite. Riima itomi Remalías riitaki iwinkatharitetari Samaria-jatzi. Eerorika pikyaaryooteeyini, aritaki ithonkaetakimi eejatzi eerokaete.” ");
INSERT INTO cpy_vpl VALUES ("IS7_10","024_7_10","ISA","7","10","10","Iroka otsipa ikantakiriri Tajorentsi irika Acaz: ");
INSERT INTO cpy_vpl VALUES ("IS7_11","024_7_11","ISA","7","11","11","“Pikowakoteri Pitajorentsite Tajorentsi roñaayemi kaari piñaapiintzi, rootaki piñeeri pijeekira otapinaki kepatsi, pijeekira eejatzi ojenokiperotzira jenokinta.” ");
INSERT INTO cpy_vpl VALUES ("IS7_12","024_7_12","ISA","7","12","12","Rakanaki Acaz, ikantzi: “Tee okameethate noñaantawaetyaari Tajorentsi nokowakoteri roñaayena kaari noñaapiintzi.” ");
INSERT INTO cpy_vpl VALUES ("IS7_13","024_7_13","ISA","7","13","13","Ikantanaki Isaías: “Pikeme isheninkaete pinkathari David. ¿Iitaka pikijaneentakiriri atziriite, pikijaneentzitakarima eejatzi Notajorentsite? ");
INSERT INTO cpy_vpl VALUES ("IS7_14","024_7_14","ISA","7","14","14","Riitaki Awinkatharite oñaayemironi kaari piñaapiintzi: Ari owaeyantaki tsinani kaari yoterini shirampari, Itzime otomi, iitya Emanuel.");
INSERT INTO cpy_vpl VALUES ("IS9_1","024_9_1","ISA","9","1","1","Eero ojamanitzimaeta ikemaatsiteetya. Ari retakawo Tajorentsi rowashiwenteeri Zabulón-iite eejatzi Neftalí-ite. Rooma paata kyaariperori okanteeya nampitsi Halilea jempe ipiyotapaa atziri kaari asheninkata janta inkaarecheraki, intatsikero antawaaki nijaa Jordán. ");
INSERT INTO cpy_vpl VALUES ("IS9_2","024_9_2","ISA","9","2","2","Riitaki oshiyakawori ikinatyeemi otsirenirikitzira, riitaki ñaayiteeriri ootamentotsi. Otsimankakowitakari raampari kathatayeri ikineemi sarinkaweniki. Kimiwaetaka ijeekaatyeemi okiteenkatzira. ");
INSERT INTO cpy_vpl VALUES ("IS9_3","024_9_3","ISA","9","3","3","Poshekyaakiri atziriite, Poemoshirenkaperoteeri riroriite. Maawoeni ikimoshirewenteeyimini oshiyawaeteeyaawo ikimoshirewenteetziro arika rowiiteetero pankirentsi, Oshiyawaetyaawo ikimoshirewenteetziro arika ranteteetyaawo ashaahawontsi. ");
INSERT INTO cpy_vpl VALUES ("IS9_4","024_9_4","ISA","9","4","4","Tema pontsiparyaakowenteeri eeroka romperanawaeteetari, Powatsinaaryaakoteeri ishintsineentawaeteetziri, Ikaatzi ikemaatsitakaayiitari reewawenteetziri. Kimiwaetaka paerani paperaatantakariri Madián-jatziite. ");
INSERT INTO cpy_vpl VALUES ("IS9_5","024_9_5","ISA","9","5","5","Itayiteeteeri isapaatote owayiri-paeni ikamenitakayitziri ranashitantari. Itayiteeteeri ikithaari iraatakiri iraantsi. ");
INSERT INTO cpy_vpl VALUES ("IS9_6","024_9_6","ISA","9","6","6","Tema tzimaki eenchaanikiri ishinetakayiri Tajorentsi. Ipakiri shintsinkantsi ipinkathariwentante. Ikanteetzi: Kempoyaawenta rowaeteniri ikenkithashiretari, Tajorentsi kaari roetsinampahaetziri, Añaari Ashitaanari, Pinkathariwentantatsiri ijeekaetzira kameethari. ");
INSERT INTO cpy_vpl VALUES ("IS9_7","024_9_7","ISA","9","7","7","Irijatzi pinkathariwenteerini ichariniyitari David, Ithonkya ikemakoeteero ishintsinkari. Okantaetatyeeya ijeekaetee kameethari, Ashi owatyeero ipinkathariwentantee, Tampatzikashireri rinaatye, kameethashireri ikantante, Ari okantaetaatyeeyaani etanakyaawo nimaeka. Thaamenta ikanteeya, Tajorentsi shintsiperori. ");
INSERT INTO cpy_vpl VALUES ("IS14_1","024_14_1","ISA","14","1","1","Ikanta Tajorentsi ineshironkateeri Jacob-iite. Riyoshiiteeri Israel-paeni, roepiyeeri rashiteeyaawo iipatsite. Ipokaki paashinijatzi, itsipateeyaari inampiki Jacob-iite. ");
INSERT INTO cpy_vpl VALUES ("IS14_2","024_14_2","ISA","14","2","2","Raakameethateeri paashinijatziite irikaete Israel-paeni, ramitakoteeri ipiyayitee inampiki. Imateero Israel-paeni, romperataari shirampariite eejatzi tsinaniite. Ikaatzira omperawaetakariri paerani Rirori, ipiyataari rirori, rompera-tanewo rowaeri. ");
INSERT INTO cpy_vpl VALUES ("IS14_3","024_14_3","ISA","14","3","3","Arika rowatsinaaryaakotaami Tajorentsi pikemaantsiwaetakaha, powashiretakowaetaha, rashiminthateetzimira romperaetzimi, ");
INSERT INTO cpy_vpl VALUES ("IS14_4","024_14_4","ISA","14","4","4","aritaki pithaenkaeri pinkatharitatsiri Babilonia-ki, pikante pomampaeya: “¡Pamineri irika! ¿Jempe okinakika romperawaetakae paerani? ¡jempe ikantakiroka ithonkantakawori nampitsi ijeekira ooro! ");
INSERT INTO cpy_vpl VALUES ("IS14_5","024_14_5","ISA","14","5","5","Itzinkahapithateeri Tajorentsi ipajamento irika kaariperori, rootaki rotaeyapiintziri pinkathari, ");
INSERT INTO cpy_vpl VALUES ("IS14_6","024_14_6","ISA","14","6","6","rootaki ipajawaetantakariri atziriite, tema antawoete ikijaka, rootaki ipinkantakariri nampitawori jemperikapaeni, tema antawoete amashirenkari okantaka. ");
INSERT INTO cpy_vpl VALUES ("IS14_7","024_14_7","ISA","14","7","7","Kameethari ijeekaetee maawoeniki kepatsi, tekatsi koshekawakahaachani. Kimoshireri ikanteeya ikaemawaeteeyeni. ");
INSERT INTO cpy_vpl VALUES ("IS14_8","024_14_8","ISA","14","8","8","Eekiro othaamentatya inchatopaeni jeekatsiri Líbano-ki, kimiwaetaka okenkithawaetatyeemi santari, Okante: “Tema rashiryahaetakimi eeroka, tekatsi pokatsini itowaena naaka.” ");
INSERT INTO cpy_vpl VALUES ("IS14_9","024_14_9","ISA","14","9","9","Antawoete ikoshekawaka kaminkaripaeni otapinaki, pokaki otonkyotawaemi. Kakintetaki ishire kaminkariite, ikaatzi jewatatsiri paerani kepatsiki pokaki otonkyotawaemi. Ikaatzi pinkathariwentziriri paerani atziriite tee ijeekae nimaeka iwinkatharimentoki. ");
INSERT INTO cpy_vpl VALUES ("IS14_10","024_14_10","ISA","14","10","10","Maawoeni iñaawaeyitee, ikantawakahaeya: ‘Pimatzitawoma eeroka tee otzimimoteemi pishintsinkari, poshiyakotaanawo naakaete.’ ");
INSERT INTO cpy_vpl VALUES ("IS14_11","024_14_11","ISA","14","11","11","Jempe okineeroka pishamenkari, eejatzi oyameninkari piwiyompimento. Shitziinka okantaka pimaantari, chowiyitaki eejatzi pipashikawo. ");
INSERT INTO cpy_vpl VALUES ("IS14_12","024_14_12","ISA","14","12","12","¡Eeroka iiteetaweetari Sariwoto! jempe iitaka rowaryahaetantakimiri. Osheki atziriite pipinkathariwentaki, roori kantzimaetacha rowaryahitakimi jaawi. ");
INSERT INTO cpy_vpl VALUES ("IS14_13","024_14_13","ISA","14","13","13","Pikantashirewitaka: “Nateete jenoki jenokintaki, Nowetsike nowinkatharipankote nawijanakiri ompokiropaeni ijeekira Tajorentsi. Ari nojeekeri janta katonkonta, ochempiki ipiyotapiintaha itajorentsitetashiitari. ");
INSERT INTO cpy_vpl VALUES ("IS14_14","024_14_14","ISA","14","14","14","Niyaaperote jenoki nawijanakiro ojenokitzira menkori, Noshiyaari Jenokijatzi.” ");
INSERT INTO cpy_vpl VALUES ("IS14_15","024_14_15","ISA","14","15","15","¡Tema piyaatashitaka inthomoeperotzira ipinkathariwenteetzirira kaminkaripaeni! ");
INSERT INTO cpy_vpl VALUES ("IS14_16","024_14_16","ISA","14","16","16","Pampoyaa royemi ikaate ñeemini, Antawoete raminaminthetemi, ikante: ‘¿Riima irika atziri ithaawakaani kepatsijatzi, thonkirori nampitsipaeni? ");
INSERT INTO cpy_vpl VALUES ("IS14_17","024_14_17","ISA","14","17","17","Riitaki owaankiityaakirori kepatsi tekatsi nampiteeyaawoni, ithonkakiro maawoeni nampitsi. Tee ishineteeri ijeekashiwaeteeyani ikaatzi raayitakiri.’ ");
INSERT INTO cpy_vpl VALUES ("IS14_18","024_14_18","ISA","14","18","18","Kamayitaki maawoeni pinkathariwentakiriri paashinijatziite jempe ikitayitaka, apaanipaeni ikitataka riroriite. ");
INSERT INTO cpy_vpl VALUES ("IS14_19","024_14_19","ISA","14","19","19","Rooma eeroka, rookaetakimi inteena kitataarewomashiki, Roshiyakahaetakimi shitzitatsiri kaarashi, Roshiyakahaetakimi eejatzi shitziwari, arika rompojawakahaeyani atziri, rookaetakiri impeetaki opiyotaha mapi. ");
INSERT INTO cpy_vpl VALUES ("IS14_20","024_14_20","ISA","14","20","20","Eero roshiyakahaetzimiri itsipa pinkathariyitatsiri ikaatzi ikitaetakiri, tema pimaperotakiro pinampiite, pompojaki pisheninkapaeni pinampiki. Eero ikijotzi rañe isheninkapaeni kaariperori. ");
INSERT INTO cpy_vpl VALUES ("IS14_21","024_14_21","ISA","14","21","21","Powetsikya okine pompojeri itomipaeni, okantakaantziro rompojantzira ipaapate, Eero ikenkithashirewaetantaawo ipinkathariwenteeri nampitawori kepatsiki, eero ishenitantaawo nampitantyaawoni kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("IS14_22","024_14_22","ISA","14","22","22","Iroka ikantaki Tajorentsi shintsiperori: “Nokoshekatyeeyaari irikaete, nothonkaeri Babilonia-jatzi, ikaatzira jeekatsiri janta, rowaeyaniite eejatzi ichariniite. ");
INSERT INTO cpy_vpl VALUES ("IS29_13","024_29_13","ISA","29","13","13","Ikantakina Pinkathari: “Okaatzi icheraacheraawaetziri irika atziri, oshiyawaetakawo okaakishiretatyeena, Ipinkathapaantetashitana, teemaeta ikenkithashiretakotena kameethaeni, inteenashireri rowanaanaa. Oamenahashiwaeta ipinkathawitana, riyotaantashiwaetawo rametari rirori. ");
INSERT INTO cpy_vpl VALUES ("IS29_14","024_29_14","ISA","29","14","14","Rootaki napiitanteeyaawori noñaayeeri kaari iñaapiintzi atziriite, kempoyaa ikanteeyaani. Nopeyapithateeri riyomento yotaniwitachari. Nopeyapithateeri ikenkithashiretani kenkithashirewitachari.” ");
INSERT INTO cpy_vpl VALUES ("IS40_1","024_40_1","ISA","40","1","1","Iroka ikantzi Pitajorentsite: “Poetzimoshirenkaeyeenani. Poemoshirenkaeyeenani nonampikika. ");
INSERT INTO cpy_vpl VALUES ("IS40_2","024_40_2","ISA","40","2","2","Pinintathateri piñaanateri nampiwitawori Jerusalén-ki. Pikamanteeri, pikanteri: ‘Ari okaatapaaki romperaetzimi, ipinakowenteetakiro pikinakaashitani, Imaperotakimi rowajankitzimi pikaariperotakira.’” ");
INSERT INTO cpy_vpl VALUES ("IS40_3","024_40_3","ISA","40","3","3","Icheraapaaki, ikantantapaaki: Powameethateeniri Tajorentsi ikinapaakira ochempimashiki, Poshiyakaahaeniri Tajorentsi itampatzikaetziro awotsi. ");
INSERT INTO cpy_vpl VALUES ("IS40_4","024_40_4","ISA","40","4","4","Omameripathatee otenkanaayitzira, Okarenipathayitee ochempi, Okaatzira otenkanaayitzi nimaeka, okaatzira ochempimashitzi, Karenipankaari okanteeya. ");
INSERT INTO cpy_vpl VALUES ("IS40_5","024_40_5","ISA","40","5","5","Roñaahanteero Tajorentsi rowaniinkawo, ipiyoteeya atziriite ikaatzi ñahaerori. Riitaki Tajorentsi kenkithawaetakirori iroka ñaantsi.” ");
INSERT INTO cpy_vpl VALUES ("IS53_1","024_53_1","ISA","53","1","1","¿Iitaka kemijanteroni okaatzi akemakiri? ¿Iitaka ñaakirori ishintsinkari Tajorentsi? ");
INSERT INTO cpy_vpl VALUES ("IS53_2","024_53_2","ISA","53","2","2","Ikimotatakaaki nomperatani ijeekanikira Tajorentsi, Roshiyakaakiri owakira parithatatsiri pankirentsi, Rooma kepatsi kaari oshookanta pankirentsi, Tee orooperotzi okameethate, tee owaneenkata, Tekatsi ñaamatyaawoni okantawaetaha, ");
INSERT INTO cpy_vpl VALUES ("IS53_3","024_53_3","ISA","53","3","3","Maninta royiro maawoeni atziri, tee ikoyiro. Antawoete okatsitzimotziri atziri, rametakawo okantzimoshirewaetari. Roshiyawaetakari kaari ñaamataawo iñahaeteri, manintaarewo oyiri, tee akenkithashiretakoteri. ");
INSERT INTO cpy_vpl VALUES ("IS53_4","024_53_4","ISA","53","4","4","Omaperotatya, riitaki aanakirori akemaatsiyitakari, Irijatzi aanakirori akemaatsiwaetari. Tema riitaki owatsinaawaetakiriri Tajorentsi, Riitaki owajankiwaetakiri, riitaki owaañaawaetakiriri eejatzi. ");
INSERT INTO cpy_vpl VALUES ("IS53_5","024_53_5","ISA","53","5","5","Rojatahaetakiri okantakaantziro ipiyathawaetaka, Ikemaatsitakahaetakari okantakaantziro iyaariperonkari. Ikanta rowajankitzitakiri rootaki ijeekantaari kameethaeni. Ikanta rowatsinaetakiri, roojatzi retsiyatakotantaari. ");
INSERT INTO cpy_vpl VALUES ("IS53_6","024_53_6","ISA","53","6","6","Atzipinawaetaki aakaete maawoeni oshiyawaetakari owisha tzipinari, akinawaetashitaka jemperikapaeni, Riitaki kantacha Tajorentsi, ratsipetakaakari irika ayaariperonkari aakaete. ");
INSERT INTO cpy_vpl VALUES ("IS53_7","024_53_7","ISA","53","7","7","Ipajawaeteetakiri, ishinetaka tee ikaaniwaetzi, Tee iñaawaetzi eepichokiini ikenkithawaetapaente. Roshiyakahaetakiri rahaetziri owisha rowamahaeteri. Roshiyakari owisha tee ikaemawaete arika rameeteeteri, Ari ikantakari rirori, maeriri ikantaka. ");
INSERT INTO cpy_vpl VALUES ("IS53_8","024_53_8","ISA","53","8","8","Tsinampashireri ikantakaakari, tee ariperori okaatzi ikantakowiteekariri. Ikanta rowamahaetakiri, tee itzime itomipaeni. Rowamahaetakiri ikantakaantziro natzirite. ");
INSERT INTO cpy_vpl VALUES ("IS53_9","024_53_9","ISA","53","9","9","Itsipatahaetakiri kaariperoshireri ikitaetakiri, Itsipatahaetakiri kaminkari atziri katsimashireri, Tekatsi iyaariperonkari rirori, Tee itheeyapaantetapaentya. ");
INSERT INTO cpy_vpl VALUES ("IS53_10","024_53_10","ISA","53","10","10","Tee ishintsineenteri Tajorentsi ikemaatsitakahaeyaari. Riitaki kowashiteencha ratsipetakowentyaari kaariperori, rañaanteeyaari, iñaayitanteeyaariri ichariniyitari. Riitaki kantakaantakirori omatantakari rantawaeri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("IS53_11","024_53_11","ISA","53","11","11","Osheki ikemaatsiwentakawo iñaantawori kitejiinkari, osheki ikimoshirete arika iñaahaero awijeentsiri. Irika tampatzikashireri nomperatani osheki rontsiparyaakowentee, riitaki ikemaatenatakaayita iyaariperonkari atziriite. ");
INSERT INTO cpy_vpl VALUES ("IS53_12","024_53_12","ISA","53","12","12","Roejeekaeri Tajorentsi ijeekamentoki riroperoriite, itsipateeyaari shintsiperori oetsinampaanteentsiri, Tema ishinetaka ikamimotante, roshiyakahaetakiri riimi kaariperori, Riiwitaka ikematenatakahaetakari iyaariperonkari osheki, rowatsinaryaakotairi kaariperoshireriite. ");
INSERT INTO cpy_vpl VALUES ("IS54_1","024_54_1","ISA","54","1","1","Iroka ikantzi Tajorentsi: “Okantawitaka tee powaeyeeya, maaniromanthaki pinawitaka, roori kantzimaetacha antawoete pinkimoshiretee. Tee pikemaatsiwitya powaeyante, pithaamenteeyaani. Osheki tzimaatsini pitomipaeni okantawitaka imaninteetakimi, pawijaero nimaeka tzimatsiri oemi. ");
INSERT INTO cpy_vpl VALUES ("IS54_2","024_54_2","ISA","54","2","2","Poemotero pipankonaki eero pithaawakaawo pomaankero pijeekantakari. Pishiryeero oojotantari, pikentakotero kameethaeni, ");
INSERT INTO cpy_vpl VALUES ("IS54_3","024_54_3","ISA","54","3","3","Tema osheki poewawahayiteeya. Piyaate pisheninkaki otsipaki nampitsi, inampiteeyaawo ochempiki jempe tee inampiiteetawo. ");
INSERT INTO cpy_vpl VALUES ("IS54_4","024_54_4","ISA","54","4","4","Eero ominthaawashiriimi, riroperori pikantya, tekatsi kaweyawaetemini, tekatsi pikaaniwente. Pimaesantero pikantaha paerani pikaaniwenta, eero pikenkithashireteero rowinkatharyeetemi pikinankaritzira, ");
INSERT INTO cpy_vpl VALUES ("IS54_5","024_54_5","ISA","54","5","5","Oshiyawo riimi Tajorentsi inanteeyaatyeemimi. Iroka iwaero Tajorentsi shintsiperori, riitaki pinakowenteemiri, Tajorentsi rini Itajorentsite Israel, Itajorentsite jaawijatzi. ");
INSERT INTO cpy_vpl VALUES ("IS54_6","024_54_6","ISA","54","6","6","Poshiyakawo ookaarewo ewankawo, ashironkaawaetachari, Roori kantzimaetacha ikaemaemi Pitajorentsite, ikanteemi: ");
INSERT INTO cpy_vpl VALUES ("IS54_7","024_54_7","ISA","54","7","7","“Eepichoki nookawentakimi, roori kantzimaetacha antawoete netakotzimi nopiyashiteemi notsipateeyeemini. ");
INSERT INTO cpy_vpl VALUES ("IS54_8","024_54_8","ISA","54","8","8","Antawoete nokijapaenta, eepichokiini nookawentakimi, Roori kantacha ojamani okanteeya noneshironkateemi.” Rootaki iñaane Tajorentsi, pinakowenteeri. ");
INSERT INTO cpy_vpl VALUES ("IS54_9","024_54_9","ISA","54","9","9","“Noshinetakiniri Noé, nokantakiri: ‘Eero apiiteero oonkaeya kepatsi.’ eenitatsi noshinetakimiri eejatzi eeroka, nokantzimi: ‘Eero napiiteero najariimataami.’ ");
INSERT INTO cpy_vpl VALUES ("IS54_10","024_54_10","ISA","54","10","10","Ataakawitya tonkaariki, pookawita ochempi, Eero napakaero noneshironkatzimi eerokaete, eero pipakayiro paapatziyawakaa eerokaete.” Ari ikantzi iñaawaetaki Tajorentsi, neshironkaperotzimiri. ");
INSERT INTO cpy_vpl VALUES ("IS54_11","024_54_11","ISA","54","11","11","¡Rowashironkahaetani nampitsi, atsipetakawori tampyaa, tekatsi kantemini. Naakataki piriinteeroni potanto nowetsikanteeyaawo porekatsiri mapi. Osheki owanawo okanteeya otantotsi. ");
INSERT INTO cpy_vpl VALUES ("IS54_12","024_54_12","ISA","54","12","12","Antawo nowetsikayiteero pankotsi, poreryaari okanteeya mapi nowetsikantyaawori. Oshiyawo oporeryaatzi nijaa opatzimooki. ");
INSERT INTO cpy_vpl VALUES ("IS54_13","024_54_13","ISA","54","13","13","Niyotaayiteeri maawoeni notomiite, ijeekayitee kameethaeni. ");
INSERT INTO cpy_vpl VALUES ("IS54_14","024_54_14","ISA","54","14","14","Tontashireri pikanteeya pitampatzikashiretee, pijeekashiwaeteeyani eero ishintsineenteeteemi, Eero pithaawashiwaeta, eero okantzimoshirewaeteemi thawankantsi. ");
INSERT INTO cpy_vpl VALUES ("IS54_15","024_54_15","ISA","54","15","15","Arika ikoshekaetemi, tee naaka kantakahaeyaawoni, Roori kantacha, aritaki poetsinampaakiri eeroka ikaatzi maemanetemini. ");
INSERT INTO cpy_vpl VALUES ("IS54_16","024_54_16","ISA","54","16","16","“Pikeme, naakataki owetsikakiri kotsiroempeki antawaeteerori paamari rowetsikayitzi omanamentotsi. Naakataki owetsikakiri eejatzi thonkantaniri. ");
INSERT INTO cpy_vpl VALUES ("IS54_17","024_54_17","ISA","54","17","17","Tekiraata otzimeeta omanamento materoni athonkante, Santziko powaeri kantakowaetemini. Noshineteeniri naaka ikaatzi antawaetanari: roetsinampaante.” Riitaki Tajorentsi ñaawaetzirori iroka. ");
INSERT INTO cpy_vpl VALUES ("IS61_1","024_61_1","ISA","61","1","1","Ijeekantana ishire Tajorentsi, Tema Tajorentsi riitaki tajorentsitakaakinari, rotyaantakina noñaayeeniri ashironkaenkari Kameethari Ñaantsi. Nowatsinaryaakoteeri okantzimoshirewaewitari. Nokenkithatakahaeri romonkyahaetziri nontsiparyaakowenteeri. Nojeekakaashiwaeteeyaari ikaatzi raakaanteetziri. ");
INSERT INTO cpy_vpl VALUES ("IS61_2","024_61_2","ISA","61","2","2","Nokenkithatakoteero raakameethatanteera Tajorentsi. Ikijakowentee Tajorentsi ikaatzi kijaneenteeri. Rotyaantakina noemoshirenkaeri owashirewaetachari, ");
INSERT INTO cpy_vpl VALUES ("IS61_3","024_61_3","ISA","61","3","3","Namantheeteeri ikaatzi okantzimoshirewaetari Sión-jatzi eero ijeekantawaetaawo samampoki, Kimoshireri ikanteeya eero rowashirewaetaawo, Kameñeenka ikanteeya roma-mpahae eero ikantakantawaeta ithaakyaate. Iiteeteri ‘inchato tampatzikashireri’, riitaki Tajorentsi pankitakiri roñaahantantyaawori rowaniinkawo. ");
INSERT INTO cpy_vpl VALUES ("JR23_23","025_23_23","JER","23","23","23","Iroka ikantaki Tajorentsi inaawaetzi, ikantzi: “¿Kaarima naaka Tajorentsi jeekatsiri inteena, jeekita-chari eejatzi okaakiini? ");
INSERT INTO cpy_vpl VALUES ("JR23_24","025_23_24","JER","23","24","24","¿Eenitatsima materoni romana-pitha-tena? Apatziro naaka nothotyiiro nojeekantawo maawoeni, nojeeki kepatsiki eejatzi inkiteki. Tema naaka Tajorentsi naawaetzirori iroka ñaantsi.” ");
INSERT INTO cpy_vpl VALUES ("JR25_1","025_25_1","JER","25","1","1","Tema okaataki 4 ojarentsi ipinkatharitaki inampiki Judá-paeni irika Joacim, itomi Josías. Ari iñaanatakiri Tajorentsi Jeremías ikamantakiri oeta awijimo-terini isheninka Judá-paeni. Tema owakira okaataki apaani ojarentsi ipinkatharitzi Nabucodonosor Kompitaariki. ");
INSERT INTO cpy_vpl VALUES ("JR25_2","025_25_2","JER","25","2","2","Ikamantan-takiro Jeremías iñaani Tajorentsi, ithonka ikemayitaki Aapatziyaweni-jatzi, eejatzi otsipaki inampi-paeni Judá-paeni, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("JR25_3","025_25_3","JER","25","3","3","“Paerani awijaki okaatzi 23 ojarentsi retanta-nakawori Tajorentsi ikamantanawo iñaani. Tema owakira retanta-nakawori Tajorentsi ikamantana rootaki ojarentsi 13 ipinkathari-tantari Josías, itomi Amón janta inampiiteki Judá-paeni. Rootaki iñaani nowawijayimiri eeroka-paeni, osheki napiita-kimiro nokaman-tzimiro. Roo kanteencha, tee pikemaeyini. ");
INSERT INTO cpy_vpl VALUES ("JR25_4","025_25_4","JER","25","4","4","Tema rotyaantaki romperatani Tajorentsi, iyamanta-nirite, teemaeta pikemijantziri eerokapaeni, osheki pipiyatha-takari. ");
INSERT INTO cpy_vpl VALUES ("JR25_5","025_25_5","JER","25","5","5","Iroka ikamantee-takiriri, ikantee-tziri: ‘Pipakaero pikaaripero-waetzi, tee opantawo. Aririka pipakahaero, aritaki pijeekae kameetha janta kepatsiki ikashiya-kaakimiri Tajorentsi, ashi powaero pijeekae janta. Tema rootaki ikashiya-kaeta-kimiri eerokapaeni, eejatzi ikaate picharini-teeyaari. ");
INSERT INTO cpy_vpl VALUES ("JR25_6","025_25_6","JER","25","6","6","Eero pipinkatha-waetziri tajorentsi-niro. Eero rompera-waetzimi eejatzi. Eero pikijashiryaakaawaetari Tajorentsi, pipinkatha-waetziri powetsikani-paeni eeroka. Aririka pikemijantakiro iroka, eero rowajankiteemi.’ ");
INSERT INTO cpy_vpl VALUES ("JR25_7","025_25_7","JER","25","7","7","Pikemi ikantzi Tajorentsi: ‘Osheki pipiyatha-takina eeroka-paeni. Maperori powatsimaakina pipinkatha-waetakiri pitajorentsi-nirote. Tema okantakaawo pipinkatha-waetakiri, aritaki piñaakiro iita awijimo-temini.’ ");
INSERT INTO cpy_vpl VALUES ("JR25_8","025_25_8","JER","25","8","8","Rootaki ikantantari Tajorentsi Ñaaperori, ikantzi: ‘Tema pipiyatha-takina nokanta-witzimiri, ");
INSERT INTO cpy_vpl VALUES ("JR25_9","025_25_9","JER","25","9","9","piñeena nokaemiri maawoeni nampitawori katonkonta, nokaemiri nomperatani Nabucodonosor, pinkathari-tatsiri Kompitaariki, ipoki, ithonkemi rowayiri-tyaami pinampiki, ithonka-nakiri eejatzi nampitsi-paeni jeeka-nampi-tzimiri. Ashi powaero ithonkae-teemi, rootaki ithaa-wakaeta-piintyaa, osheki ipinkaetero. ");
INSERT INTO cpy_vpl VALUES ("JR25_10","025_25_10","JER","25","10","10","Naaka kantakae-yaawoni ikyaant-yaari irika-paeni pinampiki, eero ikemaetee thaamenta-waeta-chani ikimo-shirete, tekatsi aawakaa-chani, eero ikemaetee toonka-waeta-tsini, tekatsi nampitee-yaawoni ootachani tsireniriki. ");
INSERT INTO cpy_vpl VALUES ("JR25_11","025_25_11","JER","25","11","11","Ari okamaetyaahae nampitsi, tekatsi inahaetee ithonkaero maawoeni. Okaate 70 ojarentsi rompera-waetemi pinkathari-tatsiri Kompitaariki. ");
INSERT INTO cpy_vpl VALUES ("JR25_12","025_25_12","JER","25","12","12","Aririka omonkaa-takyaa 70 ojarentsi Kompitaariki, ari nokimitahaeri maawoeni nampitawori Oshewa-weniki, nomateri nothonkaeri, ari nothonkaeri eero iñahaeteeri. Naaka Tajorentsi, ashitawori iñaani iroka. ");
INSERT INTO cpy_vpl VALUES ("JR29_1","025_29_1","JER","29","1","1","Iroka rojankinari Kamantan-taniri Jeremías. Rootaki rojankina-takiri ijeekira Aapatziyaweniki, rotyaantziniri antari-pero-paeni inoshikae-takiri. Rotyaantziniri eejatzi Ompera-tajorentsitaa-rewo, Kamantan-taniri, eejatzi Aapatziyaweni-jatzi inoshikakiri paerani Nabucodonosor raanakiri Kompitaariki. ");
INSERT INTO cpy_vpl VALUES ("JR29_2","025_29_2","JER","29","2","2","Aripaete rotyaantaki jankinarentsi ishitowan-taari pinkathari Jeconías inoshikae-tantariri otsipaki nampitsi, eejatzi ikan-takiro iina pinkathari, ikaatzi inampinatari ipankoki pinkathari, jewayita-tsiri Aapatziyaweniki, maawoeni Judá-paeni, yotzirori rowetsika-waetzi eejatzi eshiro-pakori-paeni. ");
INSERT INTO cpy_vpl VALUES ("JR29_3","025_29_3","JER","29","3","3","Riitaki amakirori jankinarentsi Elasa, itomi Safán, itsipatakari Gemarías, itomi Hilcías. Riitaki rotyaantaki Sedequías, iwinkatharite Judá-paeni, riyaatero Kompitaariki iñiiri Nabucodonosor. Iroka okantzi jankinarentsi: ");
INSERT INTO cpy_vpl VALUES ("JR29_4","025_29_4","JER","29","4","4","“Iroka iñaani Tajorentsi Ñaaperori, Itajorentsite Israel. Rootaki ikowawi-takari ikamanteri nampiwi-tawori Aapatziyaweniki, ikantakaakawo inoshikaeteri Kompitaariki, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("JR29_5","025_29_5","JER","29","5","5","‘Piwetsiki pipanko-paeni, pinampi-tyaawo janta. Pipankite powayityaari. ");
INSERT INTO cpy_vpl VALUES ("JR29_6","025_29_6","JER","29","6","6","Paawakaeyiteeya, itzimantyaari pitomi-paeni eejatzi pishinto-paeni, ari ikimityaari rirori-paeni raawakaayiteeyaa itzimantyaari itomi-paeni. Pishenite, eero pishineta ithonkaetemi. ");
INSERT INTO cpy_vpl VALUES ("JR29_7","025_29_7","JER","29","7","7","Pantawaete eero pikoshekanta jempe pijeekaki, pikantena noneshironkatemi. Aririka noneshironkateri ashitawori inampi, rootaki neshironka-taantsi piñiiri eerokapaeni. ");
INSERT INTO cpy_vpl VALUES ("JR29_8","025_29_8","JER","29","8","8","Naaka Tajorentsi Ñaaperori, Itajorentsite Israel, pikemi nokante: Paamawentyaa ramatawi-tzimi-kari kamantan-tawitachari, ñaawyaa-taniri-paeni ikaatzi pojatekan-takari jaka. Eero pakakotziri imishiwaero. ");
INSERT INTO cpy_vpl VALUES ("JR29_9","025_29_9","JER","29","9","9","Aririka ikenkithate ipaereero nowaero, theeyaantsi. Tee naaka otyaanterini.’ Rootakira ikantakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JR29_10","025_29_10","JER","29","10","10","Rapiitakiro Tajorentsi, ikantzi: ‘Aririka pimonkaa-takiro eerokapaeni pijeekaeyini Kompitaariki okaate 70 ojarentsi, aripaete noneshironka-teemi, aritaki noepiyeemi pinampiiteki, rootaki nokantzi-takimiri paerani.’ ");
INSERT INTO cpy_vpl VALUES ("JR29_11","025_29_11","JER","29","11","11","Ikantzi eejatzi Tajorentsi: ‘Tema niyotzi naaka nokenkishiryaa jempe nokantemi pijeeka-yitan-teeyaari kameetha, eero pashironkaa-waetanta, aritaki pinintahaeyaa paata. ");
INSERT INTO cpy_vpl VALUES ("JR29_12","025_29_12","JER","29","12","12","Aripaete pikowako-teena, pamaneena, aritaki nokemakimi okaatzi pikowako-tanari. ");
INSERT INTO cpy_vpl VALUES ("JR29_13","025_29_13","JER","29","13","13","Pithotyaako-teena, aritaki piñahaena. Tema kyaaripero pikyaaryoo-wenta-shire-teena. ");
INSERT INTO cpy_vpl VALUES ("JR29_14","025_29_14","JER","29","14","14","Aritaki, piñahaena. Eero apiita okaatzi piñiiri nimaeka. Tema nahaemi maawoni jempe pijeeka-yitaki nampitsiki. Nopiyoteemi. Aritaki pipiye jempe pinampitawo paerani inoshikan-teeta-kimiri. Naaka Tajorentsi, kantatsi.’ Aritaki ikantzi iñaawaetaki Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("JR32_1","025_32_1","JER","32","1","1","Okanta ojarentsi 10 ipinkathari-tantari Sedequías iipatsiteki Judá-paeni, ari iñaanateeri Tajorentsi irika Kamantan-taniri Jeremías. Okaataki 18 ojarentsi ipinkatharitzi rirori Nabucodonosor. ");
INSERT INTO cpy_vpl VALUES ("JR32_2","025_32_2","JER","32","2","2","Tema itapotakiro Aapatziyaweni rowayirite-paeni pinkathari Kompitaari-jatzi, romonkyahaetakiri rirori Kamantan-taniri Jeremías iyaankiiteri-teki pinkathari-tatsiri iipatsiteki Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("JR32_3","025_32_3","JER","32","3","3","Tema riitaki Sedequías pinkathari-tatsiri iipatsite Judá-paeni omonkyaakaan-takiriri, ikantziri: “¿Iitaka pikamantantari eeroka pikantzi: ‘Iroka ikantzi Tajorentsi: Noshine-takiro iroka nampitsi ikosheka-waetyaawo iwinkatharite Kompitaari-jatzi, aritaki ikyaaki jaka nampitsiki.’” ");
INSERT INTO cpy_vpl VALUES ("JR33_1","025_33_1","JER","33","1","1","Ari rapiiteero Tajorentsi iñaanateeri Jeremías, ijeekira iyaankiiteri-teki jempe romonkyahaetakiri, ikanteeri: ");
INSERT INTO cpy_vpl VALUES ("JR33_14","025_33_14","JER","33","14","14","“Paata aritaki notyaanteemi kameethari naantsi okaatzi nokashiya-kaakiriri paerani iwinkatharite Israel-paeni, eejatzi iwinkatharite Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("JR33_15","025_33_15","JER","33","15","15","Paata aritaki nokanta-kaakyaawo itzimi icharini-tyaari David, oshiyaawoni oshooka-pirinitzi inchato kamawiteen-chari. Kameetha-shireri ikanteeyaa ipinkathari-wentantee rirori, itampatzika-shiretee. ");
INSERT INTO cpy_vpl VALUES ("JR33_16","025_33_16","JER","33","16","16","Aripaete rawijako-yitee isheninka-paeni Aapatziyaweni-jatzi ari ikantee-yaari eejatzi maawoeni Judá-paeni, eero ithaawa-waetee inampiki. Rootaki owaetakaan-terini ikanteeteri: ‘Tajorentsi tampatzika-shire-tanta-tsiri’.” ");
INSERT INTO cpy_vpl VALUES ("JR33_17","025_33_17","JER","33","17","17","Ari ikantzi Tajorentsi iñaawaetaki, ikantzi: “Aritaki itzimae icharini David rashi rowaero ipinkathari-wenteeri isheninka Israel-paeni.” ");
INSERT INTO cpy_vpl VALUES ("EK18_1","027_18_1","EZK","18","1","1","Ipokaki Tajorentsi nojeekira naaka, ikantakina: ");
INSERT INTO cpy_vpl VALUES ("EK18_2","027_18_2","EZK","18","2","2","“¿Iitaka kaari okoñaatanta inampiki Israel ikenkithawaeteetziri paerani ikanteetziri: ‘Arika ithotero ashitanari kachori chochoki, riitaki itomipaeni tsiyaekitee raekiki.’? ");
INSERT INTO cpy_vpl VALUES ("EK18_3","027_18_3","EZK","18","3","3","Naaka Tajorentsi, pikemena nopaeriiro nowaero, eero papiiteero eerokaete pikenkithawaeteero ikenkithawaetziri paerani Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("EK18_4","027_18_4","EZK","18","4","4","Naaka ashitari maawoeni atziri, nashitari ipaapateetari eejatzi itomipaenipaeni. Ikaate kaariperotatsini, otzimatye ikame. ");
INSERT INTO cpy_vpl VALUES ("EK28_1","027_28_1","EZK","28","1","1","Ipokaki Tajorentsi jempe nojeeki naaka, ikantakina: ");
INSERT INTO cpy_vpl VALUES ("EK28_2","027_28_2","EZK","28","2","2","“Shirampari, eeroka noñaanatzi, piyaate pikamanteri iroka ñaantsi pinkatharitatsiri nampitsiki Tiro: ‘Iroka ikantaki Tajorentsi: Owanaana piñaaperowaetaka pishireki, pipinkathatashitakari tajorentsiniro riitaki jeekaentsiri iwinkatharimentoki tajorentsiniro othonka otapotakimi inkaare. Tema eeroka tee pitajorentsitzi, atziri pini, eeroka kenkithashiretashitacha apaniroeni ijeekitantakimi riyomento tajorentsiniro. ");
INSERT INTO cpy_vpl VALUES ("EK28_3","027_28_3","EZK","28","3","3","¿Poshiyakaatzi pawijakiri okaatzi riyotanitari Daniel? ¿Tzimatsima nomanimotzimiri kaari piyotzi? ");
INSERT INTO cpy_vpl VALUES ("EK28_4","027_28_4","EZK","28","4","4","Tema roori piyotani, okaatzi paawiiri eeroka pimatakiro otzimimotzimi osheki koetyiimotzimiri, piyeekitakiro powantariri ooro eejatzi koriki. ");
INSERT INTO cpy_vpl VALUES ("EK28_5","027_28_5","EZK","28","5","5","Osheki pashiminthatawo eeroka pipimantawaetzi poshekyaakiro pashaahawo, rootaki pashaahawo ñaaperotakayimiri pishireki. ");
INSERT INTO cpy_vpl VALUES ("EK28_6","027_28_6","EZK","28","6","6","Rootaki ikantantari Tajorentsi: Pantzirorika riitaki yotanitakayimiri tajorentsiniro, ");
INSERT INTO cpy_vpl VALUES ("EK28_7","027_28_7","EZK","28","7","7","nokantakahaeyaawo ipoke paashinijatzi atziri rowayiritemi, mataperori iyatsimate atziripaeni, riitaki ameroni rojataamento rowamayemi, eeroka rompoje, owanaana pikameethatzi, yotaniri, aritaki papaawaeteeya pookawenteeyaawo powaneenkawo. ");
INSERT INTO cpy_vpl VALUES ("EK28_8","027_28_8","EZK","28","8","8","Rookaetemi inthomoyaaki, eerowa pikamita niyankyaaki inkaare. ");
INSERT INTO cpy_vpl VALUES ("EK28_9","027_28_9","EZK","28","9","9","¿Eekiroma pikenkithashiretatziiri tajorentsiniro, arika piñaawakiri ikaate maemanetemini? ¡Arika rotaeyemi ompojemini tekatsira piitya eeroka atzirimacheeni pini! ");
INSERT INTO cpy_vpl VALUES ("EK28_10","027_28_10","EZK","28","10","10","Rowamayemi paashinijatzi atziri, poshiyeeyaari rompojeetziri kaariperoshireri. Naaka Tajorentsi, kenkithawaetatsiri, aritaki nokamantakimi.’” ");
INSERT INTO cpy_vpl VALUES ("EK28_11","027_28_11","EZK","28","11","11","Ikantakina eejatzi Tajorentsi: ");
INSERT INTO cpy_vpl VALUES ("EK28_12","027_28_12","EZK","28","12","12","“Atziri pini eeroka, iroka omampahaantsi pomampaakotyaari pinkatharitatsiri nampitsiki Tiro, pikanteri: Iroka iñaane Tajorentsi, ikantzi: Owanaana pikameethawitaka eeroka, yotani pikanta, owaneenkaki pikanta. ");
INSERT INTO cpy_vpl VALUES ("EK28_13","027_28_13","EZK","28","13","13","Pinampiwitakawo pankirentsimashiki Edén-ki, rashitakaawitakimiri Tajorentsi, Osheki owaneenkataka okantakaawo kantawaeyitachari mapiki poreryaari. Pithatanitari ooro rowetsikaetakimiri owakira pañaanaki. ");
INSERT INTO cpy_vpl VALUES ("EK28_14","027_28_14","EZK","28","14","14","eenitatsi aayitatsiri, paamaawentyaari, pijeekaki ochempiki itajorentsitakaakiri Tajorentsi. Panashiwaetzi jempe ipiyotapaa ompokiro. ");
INSERT INTO cpy_vpl VALUES ("EK28_15","027_28_15","EZK","28","15","15","Tekatsi pikinakaashitya, kameethari pikanta owakira rowetsikaetakimi Roojatzi pikaariperotantanakari. ");
INSERT INTO cpy_vpl VALUES ("EK28_16","027_28_16","EZK","28","16","16","Tzimanaki osheki pashaahawo, osheki pikoshekawaetanaka, owanaana pikaariperotanaki. Rootaki nookantakimiri, tee nokowe pijeekimotena. Nomishitowakimi pijeekawitaha ochempiki rashitari Tajorentsi. Riitaki omishitowakimiri aayitatsiri, pitsipawitari pinampitawo ompokiromashiki. ");
INSERT INTO cpy_vpl VALUES ("EK28_17","027_28_17","EZK","28","17","17","Piñaakiro powaneenkata, owanaana piñaaperotanaka pishireki. Osheki omajontyaanakimi pishipakiryaanakira. Nookakimi jaawi, osheki pikaanitaki piñaakirira raminaminthatakimi pinkatharipaeni nomishitowakimira. ");
INSERT INTO cpy_vpl VALUES ("EK28_18","027_28_18","EZK","28","18","18","Owanaana pikaariperotaki, maperori okoweenkatakaakimi pashaahawo, Iwinkani rowaeta pitajorentsipankote. Rootaki nowantakari paamari jempe pijeeke eeroka, riitaki thonkaemini itaayimi. Iñahaemi pisamampotee jaawi. ");
INSERT INTO cpy_vpl VALUES ("EK28_19","027_28_19","EZK","28","19","19","Maawoeni atziri ikaate ñahaemini, osheki ithaawakaemi. Koweenkaki pikanteeya. Ashi powaero eero pitzimae.” ");
INSERT INTO cpy_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","Roojatzi ipinkatharitzi Belsasar janta Babilonia-ki, etanakawori ojarentsi ipinkatharitanaki, ari imishitaki Daniel, Ikanta ikakitanakira, rojankinatakotakiro okaatzi imishitakiri. Iroka rojankinatakiri: ");
INSERT INTO cpy_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","Noñaawyaataka otampyaataki osheki, opoñaapaaka oetarikapaeni, otamakaatakiro inkaare. ");
INSERT INTO cpy_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","Ipoñaashitanaka ishitowanaki inkaareki tsimeri antariyitatsiri, ikaatzi 4. Rinashiyiita. ");
INSERT INTO cpy_vpl VALUES ("DN7_4","028_7_4","DAN","7","4","4","Etakawori arityaawetaka manitzi, roori kantzimaetacha tzimimaetacha ishiwankiri roshiyakari pakitha. Naminawakirira, ithokiteetakiri ishiwankiri. Rowiriinteetakiri kepatsiki, ikatziyakiri roshiyakaakiri ikantawaeta ikatziyaka atziri. Rowaetzitakanari ishire, ari rathatakiri jempe ikantawaeta atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("DN7_5","028_7_5","DAN","7","5","5","Apitetaneentsiri tsimeri ariityaawitaka maeni, itzinaaki apaani rako, ratsikaki mawa imeriki. Nokemaki ikanteetakiri: Panashitya, poyaari tsimeri, jempe ikaate piñaamatyaari. ");
INSERT INTO cpy_vpl VALUES ("DN7_6","028_7_6","DAN","7","6","6","Mawataneentsiri tsimeri ariityaawitaka kashekari, roori kantzimaetacha tzimimaetacha ishiwankiri okaatzi 4. Tzimaki eejatzi iitopaeni okaatzi 4. Rowaetakiri ipinkathawentante. ");
INSERT INTO cpy_vpl VALUES ("DN7_7","028_7_7","DAN","7","7","7","Niyaatakaakiro nomishiwaetzi tsirenirika, ari noñaakiri irika itsipa tsimeri 4-tapaentsiri. Koweenkatatsiri, ithaawanteetani, shintsiperori. eenitatsi raeki antawo mapikyaanikiteentsiri. Rowakawo maawoeni, rowaariperotakiro, raatzikakiro tzimahaantaneentsiri. Tee roshiyari itsipa tsimeri nomishitakiri. eenitatsi ichee okaatzi 10 iitoki. ");
INSERT INTO cpy_vpl VALUES ("DN7_8","028_7_8","DAN","7","8","8","Nokempoyaamintheetziro icheepaeni, noñaatziri itsipapaeni oshitowanaki ichee ewonkiperotatsiri. Inowikyeetakiro otsipa mawa ichee jeekawitachari, ipoyaatakiro. Iroka ichaanikiri, eenitatsi ooki oshiyakari itzimimotziri atziri. Tzimitacha opaante, ari oñaawaetaki, osheki ajahaawentantzi. ");
INSERT INTO cpy_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","Niyaatakaakiro nomishiwaetaki, noñaaki jeekamentotsi owaneenkatachari. Ari ijeekanaki Antarikitapaentsiri. Kitamaaki okantaka ikithaari, ariwaetaki okitamaatzi jiriniki. Ari okantzitaka iishi, oshiyawaetakawo roomi iwitziri owisha kitamaaperotatsiri. Paamaperotaki jeekamentotsi, ari okantzitari tzimatsiri oshiyakawo oshiyantari shiyakomentotsi. ");
INSERT INTO cpy_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","Paamataki ariwaeta nijaa, opoñaapaaka janta ijeekakira rirori. Jataki inteena pinkathatakiriri janta, mataperoperotaka rishekiperokitaki ikaatzi katziyimotakariri okaakiini ikatziyakaha rirori. Ari ijeekapaaki itzinkamipaeni, retapaakawo rapatotapaaka, itzintaryapaakiro jankinarentsi. ");
INSERT INTO cpy_vpl VALUES ("DN7_11","028_7_11","DAN","7","11","11","Niyatakaamintheetziro namineero okaatzi awijeentsiri, nokemaminthatakiro okaatzi ikenkithatakotziri ichaanikiri, tema owanaa ajahaawentawaetantaka. Omapokashitanaka rompojeetakiri tsimeri, iooweteetakiri, rookaetakiri paamariki itaantyaari. ");
INSERT INTO cpy_vpl VALUES ("DN7_12","028_7_12","DAN","7","12","12","Ikanta itsipapaeni tsimeri koweenkatatsiri, ikantakahaetakari tee otzimimotziri ishintsinkari. Roori kantacha ojamanitaki ishineteetakiri rañaahae roojatzi paata iyomaatanteeyaari. ");
INSERT INTO cpy_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Eekiro nomishiwaetatzi tsirenirikiriki. Omapokashitanaka ikoñaatapaaki apaani pokaentsiri oshiyakariri itomi atziri, ikinapaa menkoriki, riyaatashitziri Antarikitatsiri, rontsirokapaakari ijeekakira rirori. ");
INSERT INTO cpy_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Ikantakahaetakari otzimimotziri ishintsinkari, rowaneenkawo, iwinkathankari, opoñaantyaari ipinkathariwenteri atziripaeni jeekayitatsiri jemperika janta, ipinkathariwenteetziri jemperikapaeni, kemathatawakaawori iñaani jemperikapaeni. Ashi rowaatyeero ipinkathariwentantee, tekatsi materini rookakayiri ipinkatharitzira. ");
INSERT INTO cpy_vpl VALUES ("DN7_15","028_7_15","DAN","7","15","15","Naakataki Daniel, nokemakiro rooteentsi akinani nothaawankari. Okantzimoneentawaetakina okaatzi nomishitakiri. ");
INSERT INTO cpy_vpl VALUES ("DN7_16","028_7_16","DAN","7","16","16","Nontsirokapaakari apaani katziyeenchari janta, nokowakotakiri rooñaawontenawo okaatzi awijeentsiri. Rakanakina, ikantanakinawo maawoeni oetarikapaeni ikanteetziri, ikantzi: ");
INSERT INTO cpy_vpl VALUES ("DN7_17","028_7_17","DAN","7","17","17","“Irika tsimeri koweenkateentsiri kaateentsiri 4, riitaki oshiyakaawentachari pinkatharitatsini paata ikaate 4, riitaki pinkathariwentantatsini paata kepatsiki. ");
INSERT INTO cpy_vpl VALUES ("DN7_18","028_7_18","DAN","7","18","18","Roori kantacha paata, riitaki ashiteeyaawoni itajorentsitakaani Jenokiperojatzi, ashi rowaatyeero ipinkathariwentantee.” ");
INSERT INTO cpy_vpl VALUES ("DN7_19","028_7_19","DAN","7","19","19","Nokowaki niyotakoperoteeri 4-tapaentsiri weyaantapaakawori tsimeri, irika kaari oshiyawakaachari itsipapaeni, tema riitaki koweenkaperotatsiri: eenitatsi osheki raeki mapikiteentsiri, ishetaki roshiyakawo kitamaari koriki. Rowakawo maawoeni, ithonkakiro, raatzikawaetakiro tzimahaanteentsiri. ");
INSERT INTO cpy_vpl VALUES ("DN7_20","028_7_20","DAN","7","20","20","Nokowaki eejatzi niyotakoperoteero ichee kaatatsiri 10, niyotakotero eejatzi ichaanikiri tzimatsiri ooki eejatzi opaante, ajahaawaetachari. Noñaakiro rawijanakiro jempe okanta antawotzi otsipa ichee, okantakaantakiro ikahaaki mawa ichee jeekawiteenchari ojeekantyaari roori. ");
INSERT INTO cpy_vpl VALUES ("DN7_21","028_7_21","DAN","7","21","21","Okanta noñaakiro ichee owayiritakari itajorentsitakahaetani, oetsinampaawitakari. ");
INSERT INTO cpy_vpl VALUES ("DN7_22","028_7_22","DAN","7","22","22","Roojatzi rareetantakari Antarikitatsiri Jenokiperojatzi, rotzikaawentakiri itajorentsitakaani, tema monkaapaetetapaaka ipinkathariwentante irikapaeni itajorentsitakaani. ");
INSERT INTO cpy_vpl VALUES ("DN7_23","028_7_23","DAN","7","23","23","Tema ikantzi: “Irika 4-tapaentsiri tsimeri, rootaki oshiyakaawentachari okaate 4 ipinkathariwentantee janta kepatsiki, eero roshiyakayiro otsipa, tema ithonkero maawoeni okaatzi tzimatsiri kepatsiki, rowaariperoteero, raatzikaero okaate tzimahaantatsini. ");
INSERT INTO cpy_vpl VALUES ("DN7_24","028_7_24","DAN","7","24","24","Iroka ichee kaatatsiri 10, roshiyakaawenteetziri pinkatharitatsiri kaatatsini 10. Ipinkatharite rirori arika awijaki kantakotachari. Roojatzi rowinkatharyaantakyaari itsipa pinkathari. Eero roshiyaari itsipa etanakawori, rowinkatharyeeri ikaate mawa pinkathariwitachari. ");
INSERT INTO cpy_vpl VALUES ("DN7_25","028_7_25","DAN","7","25","25","Ikemaeri Jenokiperojatzi, ikowero ithonkerimi itajorentsitakaani Jenokiperojatzi. Ikowawitya rowashiñaero jempe okantawaeta riweshiryaawentari tajorentsitatsiri. Ikowawitya eejatzi rowashiñaero Ikowakaanteetziri. Ari imawityaawori awijaneentakirika mawa ojarentsi. ");
INSERT INTO cpy_vpl VALUES ("DN7_26","028_7_26","DAN","7","26","26","Roori kantzimaetacha paata, aripaetera ijeekapaaki Jewari raminakotantyaariri. Aritaki rowinkatharyaakiri, roojatzi ithonkantakyaari, ashi rowaatyeero ithonkaeya raperoteeya. ");
INSERT INTO cpy_vpl VALUES ("DN7_27","028_7_27","DAN","7","27","27","Roojatzi ikantakahaeteri itajorentsitakaani Jenokiperojatzi ipinkathariwentantantyaari. Riiyitaki pinkathariwenterini maawoeni otzimimowitari ishintsinkari, rowaneenkawo, iwinkathankari, jemperika ijeeki kepatsikinta. Ashi rowatyeero ipinkathawentante. Ikemijanteri maawoeni atziri jeekatsiri kepatsikinta. ");
INSERT INTO cpy_vpl VALUES ("DN7_28","028_7_28","DAN","7","28","28","Ari okaatzi roñaayeetakinari. Naakataki Daniel. Okantzimoneentanakina, oeteryaakina. Tekatsitzimaeta nokamantakoterori. ");
INSERT INTO cpy_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Ikanta Tajorentsi iñaanatakiri Jonás, itomi Amitai, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","“Piyaate Naana-weniki, pikamanteri atziri-paeni nokoyi nothonkiri, tema nokemaki naaka jempe ikanta ikaariperoyitaki.” ");
INSERT INTO cpy_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Roo kanteencha Jonás, tee ikemijantzi. Ikenkishiryaaka ishiya-pithateri Tajorentsi riyaate Owaneenkaariniki. Ari iñaaki antawo amaatako-mentotsi, rooteentsi oshitoyi Makaariniki. Ipinatakiro rotetan-tyaari, otetanaka rirori. ");
INSERT INTO cpy_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Roo kanteencha, ikantakaakawo Tajorentsi otampyaate inkaariki, antawo otamakaa-tanaki. Tema rooteentsi okoteemi amaatako-mentotsi. ");
INSERT INTO cpy_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","Antawo ithaawanaki aminirori amaatako-mentotsi, ramanawi-takari atziri-paeni itajorentsi-nirote. Rowiinkaki rashaahawo eero otsitsiyanta amaatako-mentotsi. Tema ikiitapaaka inkaahanki Jonás inthomoe-kinta amaatako-mentotsiki. Imaaperotapaakitzii janta. ");
INSERT INTO cpy_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Jatanaki reewarite aminirori amaatako-mentotsi jempe romaryaaka Jonás, ikantapaakiri: “Iita pantziri jaka pochokintzi! Pipiriinte! Pikowakoteri Pitajorentsite. Ineshironka-teeta, apiinki-kari.” ");
INSERT INTO cpy_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Ari ikantanaki aminirori amaatako-mentotsi, ikantzi: “Pipoki, jame añaaryaatyaa ayotant-yaari iita kantakaantzirori añaantawori iroka kowaenkateentsiri.” Imatakiro iñaaryaa-teeyakani. Iñaatziiri riitaki Jonás kantakaan-tzirori. ");
INSERT INTO cpy_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Rojampi-takiri, ikantziri: “Pikamantena, ¿Iita añaantawori kowaenkatatsiri? ¿Iitaka pipokantari jaka? ¿Jempe pipoñaa-nakari? ¿Jempe iitaka pisheninka?” ");
INSERT INTO cpy_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Akanaki Jonás, ikantziri: “Naaka isheninka Heber-paeni, nopinkatha-tziri Inkite-jatzi Tajorentsi, riitaki wetsikakiro inkaari eejatzi kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Antawoete ithaawanaki, ikanteeyini: “¿Jempe pikanta-teetenaka?” Tema yotanaki ishiya-pitha-tatyaari Tajorentsi, tema aritaki ikantzi ikamantaki. ");
INSERT INTO cpy_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Eekiro ikantee-tanaki-tziiri: “¿Jempe nokantemika opakaan-teeyaari otamakaatzi?” Tema eekiro omapero-tanakityaa otamakaatzi inkaari. ");
INSERT INTO cpy_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","Ari ikantanaki Jonás: “Pookina inkaariki, aritaki opakaanakyaa otamakaatzi. Naaka kantakaantakiro añaantawori okowaenkatzi otampyaatzi.” ");
INSERT INTO cpy_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Tema shintsiwiteeyanakani ikomateeyini ikoyi raatakote othapyaaki inkaari. Teemaeta imatziro. Eeniro omapero-tanakityaa otamakaatzi inkaari. ");
INSERT INTO cpy_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Ikowako-tanakiri Tajorentsi, ikanteeyini: “¡Tajorentsi! Eero pishinetana nopiinki ikantakaan-tziro irika atziri. Tekatsi-rika iyaari-perorite, te nokoyi powajankitaa-wentenari ikamakirika. Pimatziro eeroka Tajorentsi okaatzi pikoyiri.” ");
INSERT INTO cpy_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","Ikaatanakiro ikowako-tziri Tajorentsi, rowiinkaetanakiri Jonás inkaariki. Tema maeryaatanaki otamakaatzi inkaari. ");
INSERT INTO cpy_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Ikanta iñaakiro atziri-paeni, antawoete ipinkatha-tanakiri Tajorentsi. Itaa-kiniri ratsipe-takaani, ikanteeyini: “Tajorentsi! Kyaaripero nokemijanteemi.” ");
INSERT INTO cpy_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Rowaki Tajorentsi antari omani niyawakirini Jonás. Mawa kitejeri eejatzi mawa tsireniri jeekaki imotziki omani. ");
INSERT INTO cpy_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","Ikanta ramanaa Jonás ijeekakira imotziki omani, ");
INSERT INTO cpy_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","ikantzi: “íTajorentsi! Noñaakiro nokemaatsi-waetaka, nokowako-takimi. Pikaminthaakina eeroka. Pikemakina nokaemi kaminkari-mashiki. ");
INSERT INTO cpy_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Pookawi-takina ocheenkaatzira inkaari, Onoshika-nakina oshinchaari. Aanakina omoetonkaari inthomoekinta.” ");
INSERT INTO cpy_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ari nokantziri: “íTajorentsi! Pookawentakina. Eero noñahaero pitajorentsi-pankote. ");
INSERT INTO cpy_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","Othonkakina opamankakina nijaa, Opeyakina ocheenkaatzira inkaari. Tema othonkakina ankowiyinatakina jamantoshe. ");
INSERT INTO cpy_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Notsiryaanaki inthomoeki nareeta-paentawo kepatsi. Kimiwitaka ashi noyiromi nojeekemi jempe rashita-koeta-kinami. Roo kanteencha Nowinkatharite Tajorentsi, eeroka owawijaa-kotaana nokamimi. ");
INSERT INTO cpy_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","Nokanta nokamimataki, nokenkishiryaaneemi eeroka Tajorentsi. Pikemakiro namanani pitajorentsi-pankoteki. ");
INSERT INTO cpy_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Ikaatzi pinkatha-waetziriri roshiya-kaawo tajorentsi-niro, Tee ikinatzimi. ");
INSERT INTO cpy_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Rooma naaka, kamiñeenka nopaasoonkiteemi, Notahaemiri natsipe-takaani nashita-kaemiri. Aritaki nanteemiro nokantzimiri. Tema apatziro pikanta-kaawo Pitajorentsitzi, powawijaa-kotantzi.” ");
INSERT INTO cpy_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Ari ikanta-kahaari Tajorentsi irika omani, ikamaankaeri Jonás othapyaaki inkaari. ");
INSERT INTO cpy_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Ari rapiiteero Tajorentsi iñaanateeri Jonás, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","“Piyaate Naana-weniki, pikamantantero okaate nokantemiri.” ");
INSERT INTO cpy_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","Jataki Jonás Naana-weniki, imatakiro ikantakiriri Tajorentsi. Tema antawo nampitsi Naana-weni, mawa kiteejeri anashitan-tyaawori maawoeni. ");
INSERT INTO cpy_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Areetaka Jonás nampitsiki, anashitaka apaani kiteejeri, ikantzi ikenkithatzi: “Yotapaaka 40 kitejeri, ithonkae-tantyaariri ikaatzi nampitawori Naana-weniki.” ");
INSERT INTO cpy_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Ikanta ikemaki nampitawori Naana-weniki: antari-paeni eejatzi eentsitee-reki, ikemijanta-nakiri Tajorentsi, ikanta-wakahaeyani: “Jame atziwentyaa.” Ikithaa-tanakawo etawori-pooki iithaari, rootaki riyotan-teeyaari rowashiretako-tatyaa. ");
INSERT INTO cpy_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Ikanta ikemaki pinkathari-tatsiri Naana-weniki, rookanakiro iwinkathari-mento, ikithaa-tanakawo etawori-pooki iithaari, jeekanaki samampoki. ");
INSERT INTO cpy_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Ikamantantaki inampina-paeni pinkathari, riyotan-tyaari maawoeni nampitawori, ikantzi: “Itziwentyaa maawoeni atziri, tekatsi owaachani. Ari ikimiteeriri ipira-paeni, eero ipiri eepichokiini rowanawo eejatzi imiri. ");
INSERT INTO cpy_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Otzimatyee ikithaa-pookityaa atziri-paeni eejatzi ipira-paeni. Icheraa-pero-tatyee ramaniri Tajorentsi. Ipakahaero ikaaripero-waetzi eejatzi ikoshekanta. ");
INSERT INTO cpy_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Aamaashityaa aritaki ineshironkatee Tajorentsi, rotsimaryaa-shire-teeyaa. Eero anaantawo ithonkae.” ");
INSERT INTO cpy_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","Iñaakiri Tajorentsi jempe ikantanaa Naana-weni-jatzi, tema ipakaa-neero rantawitakawo kaariperori. Te ikowanee Tajorentsi rowajankiteeri. ");
INSERT INTO cpy_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Te inimotziri Jonás iñaakiri Tajorentsi tee rowajankiteeri Naana-weni-jatzi, otyaanakari imashirenka. ");
INSERT INTO cpy_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","Ikowako-takiri Tajorentsi, ikantzi: “¡Tajorentsi! Ari niyotzitaka panteri eeniro nojeeki nonampiki. Rootaki nokowantari niyaatemi Makaariniki. Tema niyotzi eeroka Tajorentsi etakotantaniri, neshironka-tantaniri, te pikijanita. Antawo petakotanta, pikanta-wityaa: ‘Ari nowajankitaakimi’, roo ojamanitakimi te pikowanee powajankitaante. ");
INSERT INTO cpy_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","Rootaki noñaashirenkan-tzimiri Tajorentsi, nokoyi nokami. Rootaki nokowa-perotziri nokami, te nokoyi nañee.” ");
INSERT INTO cpy_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","Ari rakanaki Tajorentsi, ikantzi: “¡Jonás! ¿Rooma kameetha-tzimo-tzimiri pikijawaeta?” ");
INSERT INTO cpy_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Jatanaki Jonás ishitowa-piintziro ooryaa iweyaa-thapita nampitsi. Rowetsika-paaki ipanko-sheta. Ari ijeeki raampiya, royaawenta iita awijatsini nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","Ikantakaakawo Tajorentsi omapoka-shityaa oshooki incha-maeshi, opamanka-kotakiri Jonás. Rootaki tsimanka-kiriri iitoki, ari raampiya eero roñaashirenkantari ooryaa. Osheki ikimo-shire-wenta-nakiro Jonás shookaen-tsiri. ");
INSERT INTO cpy_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Okanta okitejeta-manee, ikantakaakawo Tajorentsi itowireero chapitzi shookaen-tsiri, jampishi-tanaki. ");
INSERT INTO cpy_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Ikanta ishintsi-tapaaki ooryaa, antawo itampyaa-takaakiro Tajorentsi okinapaakiro jempe ishitowapiintzi ooryaa. Riitaki taapaakiriri iitoki Jonás, rowamayi-matakiri. Ikantzi: “Rootaki nokowa-perotziri nokami, te nokoyi nañee.” ");
INSERT INTO cpy_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Iroka ikantzi Tajorentsi rakiri Jonás: “¿Rooma kameetha-tzimo-tzimiri pikijakotawo okamaki incha-maeshi?” Ikantzi Jonás: “Jee, tema kameetha noñaakiro nokijawaeta.” ");
INSERT INTO cpy_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","Ikantzi Tajorentsi: “Te eeroka pankiteroni incha-maeshi, te eeroka shookakaeroni eejatzi. Tema piñaashitakawo eeroka oshookaki, eejatzi piñaakirowa okamaki. Rootaki petako-waematsitari. ");
INSERT INTO cpy_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","¿Eeroma noneshironka-tziri naaka Naana-weni-jatzi? Osheki ikaateeyini. Eenitatsi eejatzi osheki eenchee-riki, ikaatzi 120,000, tekira riyotziro jempe otzimi rampate eejatzi rakoperori. Eenitatsi eejatzi osheki ipireetari janta.” ");
INSERT INTO cpy_vpl VALUES ("MC1_1","034_1_1","MIC","1","1","1","Iroka iñaani Tajorentsi ikamantziriri Miqueas Kashiya-kaarini-jatzi, ikantziri: “Noñaayimiro oeta awijatsini paata Oshitekii-toniki eejatzi Aapatziyaweniki.” Aripaete roñaayiri ipinkathari-tantari Jotam, Ahaz eejatzi Ezequías janta ijeekinta Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("MC5_1","034_5_1","MIC","5","1","1","¡Rishinto owayiri-paeni! Pikijawentyaa rinkiteetakimira tantotsikira, Tema rowayiri-teetatyee. Antawoete rowajankiteeteri reewarite asheninka Israel-paeni, Rompoja-waetan-tyaari pajamentotsi ipooki. ");
INSERT INTO cpy_vpl VALUES ("MC5_2","034_5_2","MIC","5","2","2","Rooma eeroka, Owapankoni jeekatsiri Poshini-pathaniki, Rawijakimi ishekiiyini pisheninka Judá-paeni. Ari ipoñeeyaami pinkathari-wenteerini Israel-paeni. Riitaki etakawori itzimaki paerani, Itziman-tayitakari kañaaniri. ");
INSERT INTO cpy_vpl VALUES ("MC5_3","034_5_3","MIC","5","3","3","Eepichokiini rookawenta-paentziri rashiyitari, Roojatzi paata otzimaa-nitan-takyaari tsinani ikowakahae-takiri itzime eentsite. Riyoshiiteetani tsinani itzime eentsite. Aripaete ipokayitee isheninka, Itsipayi-teeyaari Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("MC5_4","034_5_4","MIC","5","4","4","Ari retanakyaawori pinkathari raamaako-wentee-yaari isheninka-paeni, Rootaki imatantee-yaari ishintsinka Tajorentsi. Ari ikantzi-teetyaari ipinkatha-teetero iwaero Itajorentsite. Aritaki ijeekawaetee kameetha, Tema antawoete ipinkathee-teeri Tajorentsi, Imaeteero maawoeni jempe-rika oweyaa-thapi-tapaa kepatsi. ");
INSERT INTO cpy_vpl VALUES ("ML1_1","040_1_1","MAL","1","1","1","Iroka iñaani Tajorentsi ikantakiriri Kamantan-taniri Malaquías, rootaki riyoteeri maawoeni Israel-paeni. ");
INSERT INTO cpy_vpl VALUES ("ML3_1","040_3_1","MAL","3","1","1","Ikantzi Tajorentsi Ñaaperori: Ari notyaantaki etyaawoni ikamanta-kotena, Riitaki wetsikironi jempe nokinapaaki. Omapoka-shityaa ikyee itajorentsi-pankoteki, Piwinkatharite poyaakota-piintziri. Areetzi-mataka pikowae-yirini, riitaki notyaanteri ikenkitha-takoyi-teero kashiyakaa-wakahaantsi. ");
INSERT INTO cpy_vpl VALUES ("ML4_1","040_4_1","MAL","4","1","1","Iroka iñaani Tajorentsi Ñaaperori, ikantzi: Okaakitaki kitejeri iñahaetero oshiyawori opaamatzi paamari, Ari itahaeyaari kantakaa-pero-waerentzi eejatzi antzirori kaari-perori, ikimitee-yaawo opaamatzi tsipanashi. Ari ithonkyaari itahaeyaa, ikimiteeyaawo itahae-tziro inchato, Tema ithonkae-tziro maawoeni otewa eejatzi oparetha. ");
INSERT INTO cpy_vpl VALUES ("ML4_2","040_4_2","MAL","4","2","2","Rooma eerokapani pikaatzi pipinkatha-teero nowaero, Ari okoñaatzi-moteemi kameetha-shire-taantsi oshiyeeyaari ishipakirii ooryaa, Rootaki ishipakiryaani etsiyata-kotakahaemini okimiteeyaawo roomi ishiwanki rowaankakimiri jempe pijeekaki eeroka. Antawo pikimo-shire-yitee, poshiyaari ithaamenta iryaani ipireetari aririka pashitaryaakoteri okiteejeta-manee. ");
INSERT INTO cpy_vpl VALUES ("ML4_3","040_4_3","MAL","4","3","3","Aritaki paatzika-yiteeri kaari-pero-shireri, Poshiya-kaanteeri raatzikae-tziro jamampo-pane, Aririka omonkaa-tapaakyaa kitejeri nomatan-teeyaawori okaate nantayiteri. Ari ikantzi iñaawaetzi Tajorentsi Ñaaperori. ");
INSERT INTO cpy_vpl VALUES ("ML4_4","040_4_4","MAL","4","4","4","Pikenkishiryahaero noñaani, Nopakiriri paerani nomperatani janta Mamerii-toniki. Rootaki noshine-takaantani, rootaki noñaani rashiite maawoeni Israel-paeni! ");
INSERT INTO cpy_vpl VALUES ("ML4_5","040_4_5","MAL","4","5","5","Aritaki notyaanta-kimiri Kamantan-taniri Elías, Tekira omonkaa-tapaaka kitejeri ikoyiri Tajorentsi, tema okowaenkatatyee, omapero-teeyaa okaariperotee. ");
INSERT INTO cpy_vpl VALUES ("ML4_6","040_4_6","MAL","4","6","6","Aritaki roepiya-shire-teeri Tajorentsi ikaatzi ipaapate-teetari, osheki ikowapero-teeri itomi-paeni. Ari ikantziteyaari itomiteetari, osheki retakopero-teeyaari ashitariri-paeni. “Paamahaena aririka nopiyee, nowajankiteeri-kari ikaatzi jeekantawori kepatsi.” ");
INSERT INTO cpy_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iroka iwaero-paeni ikaatzi icharini-takari Jesús, Jeepatziitoetani. Tema irika Jesús riitaki icharini David eejatzi Abraham. ");
INSERT INTO cpy_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ikanta paerani Abraham, itzimaki itomi iitakiri Isaac. Ikanta Isaac tzimanaki itomi rirori, iitakiri Jacob. Ikanta Jacob tzimanaki itomi rirori, iitakiri Judá. Tema osheki rirentzi tzimaen-tsiri Judá. ");
INSERT INTO cpy_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ikanta Judá rowakaakiro Tamar, iitakiri Fares, riima itsipa iitakiri Zara. Ikanta Fares tzimanaki itomi rirori, iitakiri Esrom. Ikanta Esrom tzimanaki itomi rirori, iitakiri Aram. ");
INSERT INTO cpy_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ikanta Aram tzimanaki itomi rirori, iitakiri Aminadab. Ikanta Aminadab tzimanaki itomi rirori, iitakiri Naasón. Ikanta Naasón tzimanaki itomi rirori, iitakiri Salmón. ");
INSERT INTO cpy_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ikanta Salmón rowakaakiro Rahab, iitakiri Booz. Ikanta Booz rowakaakiro Rut, iitakiri Obed. Ikanta Obed tzimanaki itomi rirori, iitakiri Isaí. ");
INSERT INTO cpy_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ikanta Isaí tzimanaki itomi rirori, iitakiri David. Tema irika David riitaki pinkathari-teentsiri. Ikanta pinkathari David rowakaakiro iina Urías, iitakiri Salomón. ");
INSERT INTO cpy_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ikanta Salomón tzimanaki itomi rirori, iitakiri Roboam. Ikanta Roboam tzimanaki itomi rirori, iitakiri Abías. Ikanta Abías tzimanaki itomi rirori, iitakiri Asa. ");
INSERT INTO cpy_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ikanta Asa tzimanaki itomi rirori, iitakiri Josafat. Ikanta Josafat tzimanaki itomi rirori, iitakiri Joram. Ikanta Joram tzimanaki itomi rirori, iitakiri Uzías. ");
INSERT INTO cpy_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ikanta Uzías tzimanaki itomi rirori, iitakiri Jotam. Ikanta Jotam tzimanaki itomi rirori, iitakiri Acaz. Ikanta Acaz tzimanaki itomi rirori, iitakiri Ezequías. ");
INSERT INTO cpy_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ikanta Ezequías tzimanaki itomi rirori, iitakiri Manasés. Ikanta Manasés tzimanaki itomi rirori, iitakiri Amón. Ikanta Amón tzimanaki itomi rirori, iitakiri Josías. ");
INSERT INTO cpy_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ikanta Josías tzimanaki itomi rirori, iitakiri Jeconías. Tema tee apaani ikanta Jeconías osheki rirentzi tzimaen-tsiri. Aripaete inoshikae-takiri rahaeta-nakiri maawoeni janta Kompitaariki. ");
INSERT INTO cpy_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ikanta ipiyaawo inoshikan-teeta-kariri Kompitaariki. Ari itzimapaeri itomi Jeconías, iitakiri Salatiel. Ikanta Salatiel tzimanaki itomi rirori, iitakiri Zorobabel. ");
INSERT INTO cpy_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ikanta Zorobabel tzimanaki itomi rirori, iitakiri Abiud. Ikanta Abiud tzimanaki itomi rirori, iitakiri Eliaquim. Ikanta Eliaquim tzimanaki itomi rirori, iitakiri Azor. ");
INSERT INTO cpy_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ikanta Azor tzimanaki itomi rirori, iitakiri Sadoc. Ikanta Sadoc tzimanaki itomi rirori, iitakiri Aquim. Ikanta Aquim tzimanaki itomi rirori, iitakiri Eliud. ");
INSERT INTO cpy_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ikanta Eliud tzimanaki itomi rirori, iitakiri Eleazar. Ikanta Eleazar tzimanaki itomi rirori, iitakiri Matán. Ikanta Matán tzimanaki itomi rirori, iitakiri Jacob. ");
INSERT INTO cpy_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ikanta Jacob tzimanaki itomi rirori, iitakiri José. Riitaki José oemithori María. Tema iroka María rootaki tzimakiriri Jesús, riijatzi iiteetziri Jeepatziitoetani. ");
INSERT INTO cpy_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Riitaki irika-paeni iwaejatzitetakari retanakawo Abraham roojatzi David, ikaateeyini 14. Ipoñaana David roojatzi inoshikan-teeta-kariri Kompitaariki, ikaateeyini 14. Ikanta ipiyaawo inoshikan-teeta-kariri Kompitaariki, roojatzi itziman-takari Jeepatziitoetani, ikaateeyini 14. ");
INSERT INTO cpy_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iroka okanta itziman-takari paerani Jesús, Jeepatziitoetani. Eenitatsi iinathori José oeta María, rootaki ikashiyakari iinantyaawo. Teemaeta iñiiro rontsirokyaawo. Roo kanteencha, motzitaki María okantakaakawo Ishire Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Tema tampatzika-shireri rirori José, ikowawitaka romanakayaawomi rokiromi María, tee ikoyi rowashironkayiro ikemakoe-tero itzimashi-waetaka eentsite. ");
INSERT INTO cpy_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ikanta ikenkishiryaa-waeta José tsireniriki, roñaahakari Ronampiri Tajorentsi imishiwaeroki, ikantakiri: “José, icharini pinkatharini David. ¿Iitaka pikenkishiryaan-tari pookiro María? Payiroota, tema Ishire Tajorentsi kantakaawori omotzitan-takari. ");
INSERT INTO cpy_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aririka itzimaki eenchaa-niki, piiteri “Rowawijaa-kotee Tajorentsi”. Tema riitaki owawijaa-koteerini isheninka-paeni ikaariperotakira. Tema iroka waerontsi “Rowawijaa-kotee Tajorentsi”, rootaki ikantziri iñaaniki riroripaeni “Jesús”. ");
INSERT INTO cpy_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tema omatanta-yitakari iroka-paeni, ari omonkaatari okaatzi rojankina-takaakiriri Tajorentsi paerani Kamantan-taniri, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ari otzimaanitaki tsinani kaari ñeerini shirampari, itzimi otomi, Iiteeteri Emanuel, rootaki owaetakaan-teerini ikanteeteri: “Itsipatee Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ikanta ikakitanee José, imatakiro okaatzi ikantakiriri Ronampiri Tajorentsi, iinantakawo María. ");
INSERT INTO cpy_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Teemaeta rontsirokityaawo roojatzi itziman-takari omapokani otomi. Iiteetakiri JESÚS. ");
INSERT INTO cpy_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tema tzimaki Jesús nampitsiki Owapankoniki, iipatsiteki Judá-paeni jempe ipinkathari-wentantzi Herodes. Ari rareetee-yakani yotaniri-paeni Aapatziyaweniki ikinapaakiro ishitowa-piintzira ooryaa. ");
INSERT INTO cpy_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rojampi-tanta-paaki, ikantzi: “¿Jempe ijeekakika iwinkatharite Judá-paeni owakira tzimaen-tsiri? Tema janta nonampiki jempe nopoñaaka, noñaakiri ompokiro niyotan-takari tzimaki. Rootaki nopokan-tanakari nopinkathateri.” ");
INSERT INTO cpy_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ikanta ikemaki pinkathari Herodes antawo okantzimo-shiryaa-nakari, ari ikimi-tzita-nakari maawoeni Aapatziyaweni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ikaemakaan-takiri Herodes maawoeni reewarite Ompera-tajorentsitaa-rewo, eejatzi maawoeni Yotaantaniri, rojampi-takiri, ikantziri: “¿Jempema iitzimika Jeepatzii-toetani?” ");
INSERT INTO cpy_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ari ikantee-yanakini rirori: “Ari itzimiri janta Owapankoniki ipatsiteki Judá-paeni, tema ari okantzi rojankinari Kamantan-taniri, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Rooma eeroka Owapankoni jeekatsiri iipatsiteki Judá-paeni, Tekatsi theenkimini, ikantemi: ‘Tee piriiperotzi eerokapaeni, rawijimi itsipa pinkathari-wentziriri asheninka Judá-paeni.’ Tema aritaki ipoñeeyaari pinkathari-perori janta. Riitaki jewateerini Israel-paeni nashitari naaka.” ");
INSERT INTO cpy_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tema romanakaashitakari ikaemakaan-takiri Herodes pokaentsiri yotaniri-paeni, rojampi-takiri, ikantziri: “¿Jempe okaatzika piñaantakariri ompokiro piyotan-takari tzimaki pinkathari?” ");
INSERT INTO cpy_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ari ikamantakiri jempe okaatzi iñaantakariri. Ikantzi Herodes: “Kameethataki, pimatero piyaate Owapankoniki paminiri jempe ijeekika eenchaa-niki. Aririka piñaakiri eejatzi pikinapae jaka pikaman-taneena, niyaatantyaari naaka nopinkathateri.” ");
INSERT INTO cpy_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ikanta ikemakirira yotaniri-paeni ikantakiriri pinkathari, awijeeya-nakini. Eejatzi iñaaneeri ompokiro iñaakiri chapinki inampiki. Ikanta rareetzi-matapaaka, iñaatziiri raatzinka-paaki ompokiro jaha ijeekakira eenchaa-niki. ");
INSERT INTO cpy_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikanta iñaakiri raatzinka-paaki ompokiro, antawo ikimo-shire-teeya-nakini. ");
INSERT INTO cpy_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ari ikyeeya-paakini pankotsiki, iñaapaa-kitziiri eenchaa-niki eejatzi María, riniro. Otziwerowae-yapaakani, ipinkatha-tapaakiri. Opoñaashitaka roemishitowakiro okaatzi ramakiniriri, ipaakiri ooro, kajankari, eejatzi kepishaari. Osheki owinawo iroka-paeni ");
INSERT INTO cpy_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ikanta imahaeya-paakini, ari romishimpyee-takiri ikantee-tziri: “Eero pikinashi-taneeri Herodes.” Rootaki ikinanta-naari otsipaki awotsi ipiyanta-naari inampiki. ");
INSERT INTO cpy_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ikanta ipiyeeyaani yotaniri-paeni. Rapiiteero Ronampiri Tajorentsi iñaanateeri José imishiwaeroki, ikantziri: “¡José! Pishiya-kaeri eenchaa-niki eejatzi riniro, piyaate nampitsiki Apitantoni. Ari pijeekiri janta roojatzi nokantan-teemiri: ‘Pipiyee.’ Tema awotsikitaki Herodes ikoyi rowamayiri eenchaa-niki.” ");
INSERT INTO cpy_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ikanta ikakitanaki José, ikamantakiro María, tema tsireniriki ishiyaka Apitantoniki raanakiri eenchaaniki. ");
INSERT INTO cpy_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari ijeekakiri janta, roojatzi ikamantaari Herodes. Ari omonkaatari rojankina-takiri paerani Kamantan-taniri, ikantaki: Ijeekawitakya notyomi nampitsiki Apitantoni, tema ari nokanteeri ipiyee. ");
INSERT INTO cpy_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ikanta riyotaki Herodes ramatawi-takiri yotaniri-paeni, otyaanakari imashirenka. Ari rotyaantaki thonkirini rowamayiri eentsi-paeni, ikantakiri: “Piyaate Owapankoniki eejatzi maawoeni nampitsiki okaatzi otsipa-nampitari, powamayiri maawoeni eenchaa-niki owakira tzima-tsiri, eejatzi kaateentsiri apite rojarentsite.” Tema ikamantakiri chapinki yotaniri-paeni jempe okaatzi iñaanta-kariri ompokiro. ");
INSERT INTO cpy_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ari omonkaatari ikamantan-takiri paerani Kamantan-taniri Jeremías, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ikemaetaki Tonkaeroetoniki antawo irahaeya-charini. Rootaki ojawopaeni kaminkawoni Raquel iraakotariri eentsite-paeni. Tekatsi mateeroni kimoshiretahaeroni, tema ithonkiteetakiro rowamayi-tee-takiro eentsitepaeni. ");
INSERT INTO cpy_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Okanta paata, kamae rirori Herodes. Roojatzi ijeekaki José Apitantoniki. Ari rapiiteero Ronampiri Tajorentsi iñaanateeri imishiwaeroki. ");
INSERT INTO cpy_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ikanteeri: “¡José! Kantacha pipiye iipatsiteki Israel-paeni, paaneeri peentsite eejatzi riniro. Tema kamae kowawita-chari rowamayirimi.” ");
INSERT INTO cpy_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ikanta ikakitanaki José, roojatzi riyaatanta iipatsiteki Israel-paeni, raaneeri eenchaa-niki eejatzi iina. ");
INSERT INTO cpy_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Roo kanteencha, ikemaki José ikanteetzi: “Riitaki pinkathari-taatsi Arquelao inampiiteki Judá-paeni, ipoyaataari ipaapate Herodes.” Osheki ithaawanaki, tee ikoyi ijeekapae janta. Ari rapiitee-ri iñaana-teeri imishiwaeroki, ikantee-tziri: “Paamae-yaari Arquelao.” Rootaki ikinanta-nakari janta Tepokiweniki. ");
INSERT INTO cpy_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ari inampita-paawo nampitsiki Kashiyakaa-weniki. Tema ari omonkaatari ikantakiri paerani Kamantan-taniri-paeni, ikantaki: Ikashiyakahaetani iiteeteri. ");
INSERT INTO cpy_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Okanta paerani janta ipatsiteki Judá-paeni, ari ipokaki Juan Omitsiryaatantaniri, ikamantantzi. ");
INSERT INTO cpy_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Iroka ikantan-tapaaki: “Pipakahaero pikaaripero-shire-waetaki, tema rooteentsi ipinkathari-wentantee jaka Inkitejatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tema rootaki ikenkitha-takotaki paerani Kamantan-taniri Isaías, ikantzi: Ari icheraa-haete ikaemaete ochempi-mashiki, ikanteete: Powameetha-teeniri Pinkathari jempe ikinapaaki. Pikimita-kaantero itampatzikae-tziro awotsi. ");
INSERT INTO cpy_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Rootaki ithaaritari paerani Juan, rontyee-tziro iwitzi ikyaakoetari, rowatha-kitari mashitsi-mashi. Rii rowari kentori, imiritziri iyaa pitsi. ");
INSERT INTO cpy_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Osheki pokaentsiri paerani iñeeri Juan, Aapatziyaweni-jatzi, eejatzi poñaaneen-chari otsipaki inampii-teki Judá-paeni, pokaeyakini ikaatzi nampi-thapyaa-tawori Pareenkaariniki. ");
INSERT INTO cpy_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ikamantakoyitapaakiro okaatzi rantakiri karipero-yitatsiri, rootaki romitsiryaatantakariri Juan irika-paeni iroka eni Pareenkaarini. ");
INSERT INTO cpy_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ikanta iñaawakiri Juan ipokaeyakini Inashitantaniri eejatzi Sadoc-paeni, ikoyi romitsiryaawentyari Tajorentsi riyotee-tantyaariri kiteshiretee, ikantawakiri: “Tee pikameetha-shire-teeya-nitzi eeroka, poshiya-shitakari maanki. ¿Poshiyakaa-mintheetzi eero rowajankitahae-teemi? ");
INSERT INTO cpy_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kyaari-pero-rika pipakahaero pikaaripero-shire-waetzi, pikameetha-shiretee, poshiya-kotee-yaawo pankirentsi kithoki-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Eero pikanta-shire-waetzi: ‘Naaka icharini nowaejatziteni Abraham.’ Pikemi nokantemi: ‘Eero pikantakaa-pero-waeta-shita poshiya-kaantyaa eeroka ikowa-perotani Tajorentsi, tema kantacha ratziri-takaero iroka mapi, rootaki poyaatee-yaarini icharini-yitee-yaari awaejatziteni Abraham.’ ");
INSERT INTO cpy_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Eerorika poshiyawo pankirentsi kithoki-tatsiri, ichekae-takiro shachaki pankirentsi oponkitziki kaari kithoki-tatsini, rahaetakiro itahaetero. ");
INSERT INTO cpy_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aririka ipakahaero ikaaripero-shirewita atziri, aritaki nomitsiryaatan-teeyaari nijaa. Roo kanteencha, awotsikitaki matzirori ipinkatharen-tsitzi, nopinkatha-tzitakari naaka, tee okantya roshiya-kaantena romperatani nothopaan-tyaanariri ikyaantari iitziki. Tema riitaki kimitakaan-tyaawoni romitsiryaatan-teeromi Ishire tajorentsi, roete-shire-tanteeromi paamari. ");
INSERT INTO cpy_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tema roteeyakiro rirori rotekaki-mento, rooteentsi ikaateero roteka-kiwaete. Rowakoyi-teero kameethari okithoki pankirentsi, ari itayimae-teeyaawo otakee-riki.” ");
INSERT INTO cpy_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Opoñaashitaka ipokaki Jesús eniki Pareenkaariki, ipoñaakawo Tepoweniki. Ipokashi-takiri Juan romitsiryaateri. ");
INSERT INTO cpy_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tee ikowawita Juan romitsiryaateri Jesús, ikantawakiri: “¿Iitaka pipokashi-tantanari naaka nomitsiryaatemi? Tema eeroka omitsiryaatenani naaka.” ");
INSERT INTO cpy_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Rakanakiri Jesús, ikantziri: “Nokowa-pero-tatzii pomitsiryaatena. Rootaki ikowakaa-kinari Tajorentsi.” Ari ikowanaki Juan, ikantziri: “Aritaki nomitsiryaatakimi.” ");
INSERT INTO cpy_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Raanakiri, romitsiryaatakiri. Ro itonkaanee-mi Jesús, kimitanaka ashitaryaa-nakityee-yaami inkite, iñahaetatzii opokashi-takiri Ishire Tajorentsi okinapaaki inkiteki oshiya-paakari jamomo. ");
INSERT INTO cpy_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ikemaetatzii inkiteki ikantee-tanaki: “Ritaki netakoperotani irika notyomi, osheki nokimo-shire-wentakiri.” ");
INSERT INTO cpy_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Okantakaa-nakari Jesús Ishire Tajorentsi jatanaki ochempi-mashiki, ari ikowawi-taka Kamaari rantakayirimi kaari kamethatatsi. ");
INSERT INTO cpy_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Osheki kitejeri ijeekawaetaki janta, tekatsi roya, ayimatakiri itashe. Tema okaatzi 40 kitejeri ijeekawaetaki janta. ");
INSERT INTO cpy_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ikanta Kamaari, ipokashi-takiri Jesús ikoyi rantakaerimi kaari kamethatatsi. Ikantapaakiri: “Kyaaripero-rika Itomintzimi Tajorentsi, pipeyiro owanawontsi iroka mapi, poyaawo.” ");
INSERT INTO cpy_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ari rakanaki Jesús, ikantanakiri: “Eenitatsi jankinarentsi kantatsiri: Tee apatziro akoyiro oyaawo owanawontsi, rootaki kowapero-tachari akemijanteero okaatzi ikanteeri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ikanta Kamaari raanakiri nampitsiki tajorentsi-tatsiri, rateeta-kaapaakiri jenoki okaapankatapaakira tajorentsi-panko. ");
INSERT INTO cpy_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ikantawi-tapaari: “Kyaari-pero-rika Itomintzimi Tajorentsi, pimitayi jaawikinta. Pikenkishiretero rojankinee-takiri paerani okantzi: Rotyaantemiri Tajorentsi Ronampiri aminako-wentemini. Riitaki thomaemini eero pantziwa-tantawo mapi piitziki.” ");
INSERT INTO cpy_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ari rakaneeri Jesús, ikantziri: “Okantzi eejatzi rojankinee-takiri paerani: Tee okameethatzi piñaanta-waetyaari Piwinkatharite Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Rapiiwi-takari Kamaari raaneeri Jesús tonkaariki ochempiki. Roñaahakiri maawoeni nampitsi ipinkathari-yitzi atziri, tema kameetha okanta owaneenka-yitaka. ");
INSERT INTO cpy_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ikantapaeri: “Paminiro okaatzi tzimatsiri janta. Aririka potziwerowa-shita-kina pipinkathatena, aritaki nopakimiro maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ari rakaneeri Jesús, ikantziri: “¡Piyaate inteena! eerokataki kamaari. Tema rojankineetaki paerani, kantatsiri: Apinkatha-teeri Awinkatharite, apatziro akemijanteri rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ari rinteenaryaawitapaenta Kamaari. Pokaeya-paakini Ronampiri Tajorentsi, raminapaa-kiniri ikoyiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ari ikemaki Jesús omonkyahaetakiri Juan. Rootaki ipiyanta-naari rirori Tepoweniki. ");
INSERT INTO cpy_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tee ijeekapae Kashiyakaa-weniki, ikinanee Capernaum-ki, ari ijeekapaeri. Tema inkaari-thapyaaki ojeeki Capernaum, inampiiteki iwaejatziteni Zabulón-paeni eejatzi Neftalí-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ari omonkaatakari okaatzi ikenkitha-takiri paerani Kamantan-taniri Isaías, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ojeeki inkaari-thapyaaki inampi Zabulón-paeni eejatzi Neftalí-paeni, Intatsikironta Pareenkaariniki, Jeekatsiri Tepoweniki, jempe ipiyotee-yaari itsipajatzipaeni. ");
INSERT INTO cpy_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ikaatzi kimiwi-takariri kinatsiri otsirenikakitzira, Ari iñaayiteeriri riiperori ootamentotsi. Otsiman-kakowi-takari raampari kathatayiri ikineemi sharinkaweniki. Okimiwitakawo ijeekaemi okoñeetyeera. ");
INSERT INTO cpy_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Aripaete retanakawo Jesús ikenkitha-takaeri atziri-paeni, ikantziri: “Pipakahaero okaatz pantakiri kariperotatsiri, tema rooteentsi ipinkathari-wentantee jaka Inkite-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ikanta ishire-thapyaa-tanakawo inkaari janta Tepoweniki, roojatzi iñaanta-paariri Simón, iiteetziri eejatzi Pedro, itsipatari rirentzi iita Andrés, ipashikaateeyini. Tema pashikaawaerentzi riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ikantapaakiri: “Poyaatena, okimityaawo nimaeka riimi atziri nopashikatakayimiri.” ");
INSERT INTO cpy_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tema te ishenkaanaki, rookanakiro ipashikaamento royaata-nakiri. ");
INSERT INTO cpy_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ikanta riyaatanaki, iñaapaa-tziiri Jacobo eejatzi Juan, rirentzi. Ari ijeekaeyini rirori ipitoki rowamata-tziro ipashikaa-mento itsipatakari ipaapate iitachari Zebedeo. Romiñaa-nakiri eejatzi rirori, ");
INSERT INTO cpy_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","rookanakiri ipaapte ipitoki, royaata-nakiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ithonkakiro ranashi-takawo Jesús Tepoweni, riyotaantaki maawoeni nampitsiki jempe ipiyota-piinteeta, ikamantan-takiro Kameethari Ñaantsi jempe okantakota ipinkathari-wentantee Tajorentsi. Retsiya-takota-kaayitaki ikaatzi mantsiya-yitatsiri nampitsiki. ");
INSERT INTO cpy_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tema ithonka ikema-kotee-tanakiri Jesús janta. Ikemaeyakini eejatzi Tonkaeronijatzi, ramayitakiri isheninka ikaatzi mantsiya-tatsiri, retsiya-takota-kahae-teeri. Ramakiri ikaatzi omatziri inashiyita-chari mantsiyarentsi, katsiwae-tatsiri, kamanawae-tatsiri, kijopooki-waeta-tsiri. Ramakiri eejatzi raahashireyi-tziri peyari. Tema ithonkakiri rowawijakoyita-waeri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tema royaatee-yakirini osheki Tepoweni-jatzi, Apipakowenijatzi, Aapatziyaweni-jatzi, poñaayi-taneen-chari otsipaki inampi Judá-paeni, eejatzi intatsikiro Pareenkaariniki. ");
INSERT INTO cpy_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ikanta iñaakiri Jesús osheki piyowenta-kariri, tonkaanaki ochempiki, ari ijeekapaaki janta. Pokapaaki riyotaani-paeni, ipiyowenta-paakari. ");
INSERT INTO cpy_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ari riyotaa-yitakiri, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ikimoshiretee shipeta-shireri, tema riitaki ñahaeroni ipinkathari-wentantee Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ikimoshiretee iraaneenta-waeta-chari, tema riitaki roemoshirenkae-teeri. ");
INSERT INTO cpy_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ikimoshiretee tsinampa-shireri, tema riitaki jeekaatsini kameetha kepatsiki ikashiya-kahae-takiriri. ");
INSERT INTO cpy_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ikimoshiretee amina-mina-tzirori ikameetha-shirete, tema aritaki iñahaero ikoyiri. ");
INSERT INTO cpy_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ikimoshiretee neshironka-taniri, tema aritaki ineshironkae-teeri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ikimoshiretee kiteshireri, tema riitaki ñahaerini Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ikimoshiretee oetsimaryaan-taniri, tema riitaki ikanteeteri: “itomyaayipaeni Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ikimoshiretee ikemaatsi-takae-tyaari ikameetha-shiretzira, tema riitaki ñaayiteeroni ipinkathari-wentantee Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pikimoshiretee imaninta-waeteetemirika, ikemaatsi-takae-temirika, itheeya-kowae-teetemirika okantakaan-tziro pikemijantaana. ");
INSERT INTO cpy_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pithamenta-yityaa, tema Tajorentsi pinateemini inkiteki. Pikenkishireero jempe ikantee-takiri paerani ikemaatsi-takaetari etanakawori Kamantan-taniri-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Poshiyakawo eeroka-paeni tziwi. Aririka rowaeteetero tziwi oetarikapaeni, eero okamethatzi ikatyokan-teetyaawo. Otzimatyee imaninteetero, rookaetakiro jaawiki raatzika-waeteetero.” ");
INSERT INTO cpy_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aririka ojeeki nampitsi tonkaariki, okoñaatzi maawoeni aririka ootyaa tsireni-riki, tee omana nampitsi. Tema eeroka koñeetyaa-kotantaniri, eeroka yotaaneerini maawoeni atziri, eero pomanimo-tziri okaatzi piyotaneeri eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ari okimitzita eejatzi, aririka onthoteri ootamentotsi, eero atapatako-tziri. Tema owakotziri jenoki ikoñeetyaa-kotan-tyaari ikaatzi jeekatsiri pankotsiki. ");
INSERT INTO cpy_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ari pikanta-neeyaari eeroka, pijeeka-yitanee kameetha iñaantemiri pisheninka-paeni okameethatzi okaatzi pantayi-taneeri. Rootaki ipinkatha-tantee-yaariri rirori Ashiteeri Inkite-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Eero pikenkishiryaa-shita nopokatzii nookakayimiro Ikowakaan-teetani, eero nokakayimiro eejatzi ikenkitha-takotakiri paerani Kamantan-taniri. Apatziro nopoki nomonkaa-takaa-yitee-yaawo okaatzi ikenkitha-takoe-takiri paerani. ");
INSERT INTO cpy_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kyaaripero aritaki othonkaeyaa kepatsi eejatzi inkite, eero awijashita Ikowakaan-teetani roojatzi omonkaa-tanta-kyaari maawoeni. ");
INSERT INTO cpy_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Eerorika pithotyeero Ikowakaan-teetani, eerorika pikaman-teeri pisheninka ikemantee-yaawori rirori, eero pinintahawo ipinkathari-wentanteera Inkite-jatzi. Riima matakirori ithotyeero riyotaan-teero, riitaki riipero-taatsini jempe ipinkathari-wentantee Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Poshiya-kaatzima kameetha-shirerira Yotaantaniri eejatzi Inashitantaniri? Eerorika pawijeeri eeroka pikameetha-shiretee, eero piñahaero ipinkathari-wentantee Inkite-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Piyotee-yironi eeroka okaatzi ikantee-takiriri paerani awaejatziteni, ikantee-tziri: Eero powamaantzi. Aririka powamaantaki, aritaki rowajankitee-takimi eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Iroka nokantzi naaka: Eero pikijiri pisheninka, rowajankitee-tzimi-kari. Eero pikanta-waetziri: ‘Te piyowaetzi eeroka.’ Aritaki rowajankitee-takimi pinkatharentsiki. Te okameethatzi pikija-neenta-waeteri pisheninka piitamajontzi-waeteri, patsipetawo-kari pitahaeyaa sharinkaweniki. ");
INSERT INTO cpy_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tema paapiintziri pipira pashita-kaari Tajorentsi pitayiniri, roo kanteencha aririka pikenkishiryaa-paakiro eenitatsi ikijawentzimiri pisheninka, ");
INSERT INTO cpy_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ari pookanakiri pipira pashita-kaariri, piyaata-shiteri kijakimiri. Pinkanteeri: ‘Nosheninka, jame aakameethata-wakahaeyaa.’ Aririka paapatziya-wakahaeyaa, pipiye taapoki-mentotsiki, pita-paeniri Tajorentsi pashita-kaariri pipira. ");
INSERT INTO cpy_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Eenitatsi-rika kijimini, aririka raanakimi pinkatharentsiki, pithaa-wakotya awotsiki, pikanteri: ‘Eero pikijawaeta, jame aakameethata-wakahaeyaa.’ Tema aririka rareeta-kaakimi pinkatharentsiki, ikantakiri romperatani: ‘Paanakiri irika.’ Aritaki rahaeta-nakimi romonkyahaetemi. ");
INSERT INTO cpy_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Eerorika pipinata-shitari ikaatzi ikowako-takimiri, eero roemishitowa-kaanteemi. Omaperotatya.” ");
INSERT INTO cpy_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Piyotziro eerokapaeni ikowakaan-teetakiri paerani, ikanteetzi: Eero pimayempitzi. ");
INSERT INTO cpy_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Iroka nokantzi naaka: Aririka piñiiro tsinani, piñaama-shire-takyaaworika, pimayempi-shire-takiro. ");
INSERT INTO cpy_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Iroka noshiya-kaawentemiro. Rootakirika pokiperori antakayimironi kaari kamethatatsi, pipakahaero, pikimita-kaantyaawo pikitho-kiryaa-tyeeromi, pookiro. Tema tee pikoyi patsipe-teeyaawo sharinkaweni okantakaantziro poki, tema rootaki kameetha-tatsi pijeeka-pityakitee. ");
INSERT INTO cpy_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Rootakirika pakoperori antakayimironi kaari kamethatatsi, pipakahaero, pikimita-kaantyaawo pithatyaa-tyeeromi pako, pookiro. Tema tee pikoyi patsipe-teeyaawo sharinkaweni okantakaan-tziro pako, tema rootaki kameetha-tatsi pijeekaponchokite. ");
INSERT INTO cpy_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ikanteetaki eejatzi paerani: Aririka rooka-wakaetyaa, otzimatyee ipaeteri jempe ojankina-takota rooka-wakaan-tyaari. ");
INSERT INTO cpy_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Iroka nokantzi naaka. Rantakiro kaari kamethatatsi ikaatzi ookashi-tawori iina, rooma iñiiro-rika omayempitaki kantacha rookiro. Aririka aawiteeyaa roori itsipa oemi, omayempi-tzimo-takiri etawitari oemintari. Ari ikantee-yaari ahaeroni roori, mayempitaki rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Piyotee-yironi ikantee-takiriri paerani awaejatziteni: Eero pipaeryaa-shiwaetari Tajorentsi. Tema aririka otzimi pikashiya-kaeriri Tajorentsi, otzimatyee pimonkaa-teniri. ");
INSERT INTO cpy_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Iroka nokantzi naaka: Tee okameethatzi pipaeryaa-shiwae-tyaari Tajorentsi pimatan-tyaawori pikanta-yitziri. Eero pipaeryaa-shiwaetawo inkite, tema ari ijeekiri Tajorentsi janta. ");
INSERT INTO cpy_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Eero pipaeryaa-waetziro kepatsi, tema riitaki ashitawori Tajorentsi, rootaki ikatziya-chente-tanta-piintari. Eero pipaeryaa-shiwaetawo Aapatziyaweni, tema aritaki ipinkathari-wentantee Pinkathari-perori. ");
INSERT INTO cpy_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Eero pipaeryaa-shiwaetawo piito, pikante: ‘Eerorika nomatziro nokantziri, ithatyee-tenawo noeto.’ Tema tee eeroka materoni pishooka-kaero pipae, opoñaashitya pichenkae-shita-kahaero. ");
INSERT INTO cpy_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Eero pamatawi-tantzi. Kyaari-pero-rika pantero pikanta-yitziri, pikante: ‘Jeen, nomatero.’ Eerorika pantziro, pikante: ‘Eero nomatziro.’ Tema tee okameethatzi poshekiiro piñaani.” ");
INSERT INTO cpy_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Piyotee-yironi eeroka ikantee-takiri paerani: Aririka pikithokiriiteri rooki itsipa atziri, okameethatzi ipiyako-wentee-tyaari, ikithoki-ryiitee-temiro poki eeroka. Aririka pitzinkiryaa-koteri itsipa atziri, okameethatzi ipiyako-wentee-tyaari itzinkiryaakoetemi eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Iroka nokantzi naaka. Tee okameethatzi pipiyat-yaari kijaneentzimiri. Aririka ipajaawooteetemi, pishine-teniri ipajaawotemi otsipaki. ");
INSERT INTO cpy_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aririka rahaetemi pinkatharentsiki ikoyi raapithee-temiro pithaari, pishine-teniri raanakiro eejatzi pipewiryaakowo. ");
INSERT INTO cpy_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aririka romperee-temi paanakiro ashaahawontsi pookiro niyanki awotsi, paanakiro ashaahawontsi pawijakaero jempe ikantee-takimi pookiromi. ");
INSERT INTO cpy_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aririka ikanteetemi: ‘Pipina,’ okameethatzi pipiri. Aririka ikanteetemi: ‘Pipawakina, ari noepiyeemi,’ okameethatzi pipiri eero pithañaa-pithatari. ");
INSERT INTO cpy_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Piyotee-yironi eeroka ikanteetakiri paerani: Pineshironkateri pisheninka eeroka. Riima ikaatzi kijimiri, pikijiri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Iroka nokantzi naaka: ‘Petakot-yaari kijimiri. Pamana-kotyaari maawoeni ineshironka-tanteyaariri Tajorentsi. Eero pipiyatari kijaneentzimiri, paakameetha-teeri.’ ");
INSERT INTO cpy_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Rootaki ikowakae-takiriri itomiyi-taari Ashiteeri Inkite-jatzi. Tema riitaki owetsika-kiriri ooryaa kitejeta-kotziriri maawoeni atziri: kameetha-shireri, eejatzi kaari-pero-shireri. Riijatzi wetsika-kirori inkani, rowaryiiniri maawoeni atziri: tampatzika-shireri eejatzi kaaripero-shireri. ");
INSERT INTO cpy_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Apatziro-rika petakotari ikaatzi etakotzimiri eeroka, ¿poshiya-kaantzi aritaki ipinateemi Tajorentsi? Tema eero, rootaki ranta-piintakiri shintsitziriri atziri ipinateri riitaki rashita-kaeyaari iwinkatharite wirakocha. ");
INSERT INTO cpy_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Apatziro-rika piwetha-tapaa-kyaari pisheninka, ¿aminaashi-waetaantsi iroka? Tema rootaki ranta-piintziri itsipa-jatzi atziri. ");
INSERT INTO cpy_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pikameetha-shire-yitee eeroka, poshiya-kotee-yaari Ashiteeri Tajorentsi, mapero ikameetha-shiretaki rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pipakahaero powapeyi-motari atziri-paeni pikameetha-shire-teeyini. Eekiro-rika piyaata-kaatyeero, tekatsi ipinateemiri Ashiteeri Inkitejatzi. ");
INSERT INTO cpy_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aririka pipashi-tantyaa, eero pikanta-kanta-waetzi: ‘Nopashi-tantaka naaka.’ Apatziro ikanta-kanta-waetzi owapeyi-motan-taniri jempe ipiyota-piinteeta eejatzi jempe ikineeta-piintzi, rootaki ipinkathee-tantyaariri rirori. Tema tzimaki pinkatha-tziriri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aririka pipashi-tyaari eeroka ashironkaenkari, eero pikanta-kanta-waetzi, ");
INSERT INTO cpy_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","pomanakaashityaawo okaatzi pipashi-tantakari. Apatziro riyotzi Tajorentsi, tema riitaki pinateemini paata.” ");
INSERT INTO cpy_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aririka pamanyaari Tajorentsi, eero poshiya-kotari owapeyi-motan-taniri. Tema ikatziya-piinta rirori ipiyota-piinteetaha eejatzi niyankineki nampitsi inaantyaariri isheninka-paeni. Tema tzimaki pinkatha-tziriri rirori. Maperowa. ");
INSERT INTO cpy_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Rooma eeroka aririka pamanyaa, pashita-kotyaa pipankoki pikowakoteri Ashiteeri tsipata-kimiri. Riitaki ñeemini apaniroeni, aritaki ineshironka-takimi, riitaki pinateemini. ");
INSERT INTO cpy_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Aririka pamanyaa, eero papiipii-tziro okaatzi pikantakiri. Apatziro rapiipii-tziro itsipa-jatzi atziri. Roshiyakaa-mintheetzi rapiipii-tziro ikantakiri aritaki ikemakiri Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paamaeyaa poshiya-kotari-kari eeroka. Tema tekira pikowako-teriita Ashiteeri koetyimo-tzimiri, riyotzi-maetakawo rirori maawoeni. ");
INSERT INTO cpy_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Iroka pikante pamana-piintyaa eeroka: Ashitanarí, nampitawori inkiteki, tema rootaki Tajorentsi piwaero eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pipinkathari-wenteena naaka. Pantakaa-yinawo jaka kepatsiki okaatzi pininta-kaanari eeroka, Poshiya-kaanteenari inkite-weri, pantakaeri rirori maawoeni pininta-kaeriri eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pipapiintena okaatzi koetyimo-tanari nowayityaari. ");
INSERT INTO cpy_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pipeyako-teenawo nokaaripero-shire-waetaki, Tema nomatakiro naaka, nopeyako-teeri ikaatzi owaaripero-shire-tanari. ");
INSERT INTO cpy_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Eero pishinetana iñaantee-tena, ikowaete rantakahae-tenawo kaari-perori. Tema ashi powaero pipinkathari-wentantee eeroka. Ari pikantapiin-tatya otzimimo-tzimi pishintsinka, eejatzi powaneenkawo. Aritaki okantari. ");
INSERT INTO cpy_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Aririka paripero-teeri ikaatzi kijimiri, aritaki raripero-teemi eeroka Ashiteeri Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Rooma eerorika pariperotziri ikaatzi kijimiri, tema eero raripero-teemi eeroka Ashiteeri.” ");
INSERT INTO cpy_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aririka pitziwentyaa poshire-takot-yaari Tajorentsi, eero pikanta-kanta-waetzi: ‘Notziwenta-tyaari Tajorentsi.’ Paamaeyaa poshiyari-kari eeroka owapeyi-motan-taniri. Itziwenta-piinta rirori mantsiya-shookiyitaki, rootaki riyoetan-tariri itziwentatyaa. Tema tzimaki pinkatha-tziriri rirori. Maperowa. ");
INSERT INTO cpy_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Rooma eeroka aririka pitziwent-yaari Tajorentsi, pikiwawootyaa, pikishityaa kameetha, ");
INSERT INTO cpy_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eero riyotan-teetzimi pitziwentatyaa. Apatziro riyotemi Ashiteeri Inkite-jatzi, tema riitaki pinateemini.” ");
INSERT INTO cpy_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Eero pashaahanta-shiwaeta jaka kepatsiki, osheki opereyitzi, opowanitzi, tema eenitatsi osheki koshintzi jaka. ");
INSERT INTO cpy_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tema ro kameetha-tatsi pantayi-teero pijeekan-teeyaari kameetha inkiteki. Rootaki kimi-tyaawoni pashaahantaa-tyeeyaanimi inkiteki jempe tee opereyi-tapae, opowani-tapae eejatzi, tema tee itzimapae koshintzi janta. ");
INSERT INTO cpy_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tema jempe-rika powahaantaka, aritaki poshireta-piintee-yaawo.” ");
INSERT INTO cpy_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Rootaki oki oshiyariri ootamentotsi awathaki. Kameetha-rika okanta poki, piñaantawo kameetha, okimi-witakawo pikoñeetyaa-kotatyeemi. ");
INSERT INTO cpy_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Terika okameethatzi poki, eero piñaantawo kameetha, kimiwi-taka pitsireni-kaakitako-tatyeemi.” ");
INSERT INTO cpy_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tekatsi materoni rantawae-teniri apite omperatan-taniri. Tema apaani ikowa-perote imonkaa-teniri ompera-tariri, riima itsipa ikijaneenta-nakiri. Ari okantari eejatzi: Tekatsi materoni ranteniri Tajorentsi ikoyiri rirori, aririka ikenkishiryaakoe-tyaawo ashaahawontsi kimi-tanaka roomi omperat-yaarini.” ");
INSERT INTO cpy_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pikemi nokante: Eero okantzimo-shiryaa-waetzimi pikante: ‘itaka noyaari, iitaka nomiriteri, iitaka nokithaa-tyaari?’ Tema eenitatsi akenkishiryaa-piintyaari, rootaki kowapero-tachari, awijiro okaatzi owa-piintari, eejatzi akithaa-piintari. ");
INSERT INTO cpy_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Jame akenkishiryaakoteri tsimereeriki-paeni. Tee ipankitziro royaari, tee rowetsiki ipanko rowantyaawori iwankiri. Roo kanteencha, Tajorentsi papiintziriri okaatzi rowayitari. ¿Tema retakoperotzimi eerokapaeni Tajorentsi? ");
INSERT INTO cpy_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eekiro-rika piyaata-kaatyeero okantzimo-shiryaa-waetzimi, ¿arima pimatakiro powawi-neenta-waero pojarentsite? ");
INSERT INTO cpy_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Jame akenkishiryaakotero incha-teyaki-paeni, tee añiiro antawaete, tee ontyaawenta okithaa-tyaari. Teemaeta okan-tzimo-shiryaa-waetawo, okante: ‘Iitaka nokithaa-tyaari?’ ");
INSERT INTO cpy_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Owaneenkataka kameetha, awijakiri rowaneenkata Salomón, pinkathari-tatsiri paerani. ");
INSERT INTO cpy_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Tema riitaki Tajorentsi owaneenka-tzirori. Okantawita eepichokiini añaawitawo owaneenkata-paenta, roo ojamanitaki te okamethatanee aririka okama-teya-tanaki, ichekae-takiro, itahaetakiro. ¿Eeroma raminako-wentzimi eeroka Tajorentsi? Aritaki, eero pikijo-shirewaetzi. ");
INSERT INTO cpy_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aritapaaki okantzimo-shiryaa-waetzimi, pikante: ‘itaka noyaari, iitaka nomiriteri, iitaka nokithaa-tyaari?’ ");
INSERT INTO cpy_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apatziro okantzimo-shiryaa-waetziri itsipa-jatzipaeni. Rooma eerokapaeni, riyotako-tzimiro Ashiteeri Inkitejatzi iitarika koetyimo-tzimiri. ");
INSERT INTO cpy_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tema rootaki kowapero-tachari ipinkathari-wenteemi Tajorentsi, rowameetha-shire-teemi eejatzi, aritaki ipayiteemiro okaatzi koetyimo-tzimiri. ");
INSERT INTO cpy_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Aritaki okantari, eero okantzimo-shiryaa-waetzimi oetarika awijimo-temini okitejeta-manee, aritaki piñaakiro. Tema maawoeni kitejeriki-paeni piñaa-piintakiro okaatzi kantzimo-shiryaa-yitzimiri.” ");
INSERT INTO cpy_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tee okameethatzi pikijima-tante, paamaeyaa ikijima-teetzimi-kari eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aririka pikanta-koteri pisheninka, aritaki ikantako-tanakimi eejatzi eeroka. Otzimatyee paamaeyaa, otzimi-kari pantzimo-tantani, imaperoetee-mikari eeroka paata ipiyeeteemi. ");
INSERT INTO cpy_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tema oshiyawo aririka otyaakitemi antawo incha-petoki pokiki, ¿arima paminakiri itsipa tyaaki-teenchari rokiki? ");
INSERT INTO cpy_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Kantachama pikanteri: ‘Pipoki nayimiro tyaaki-takimiri?’ Tema otyaaki-takimi eeroka antawo incha-petoki. ");
INSERT INTO cpy_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tema poshiyakari eeroka owapeyi-motan-taniri. Tema otzimatyee petawakyaawo eeroka paawaero inchapetoki otzikaa-kimiri pokiki, okantya paminanee kameetha paantee-yaanariri rinchapetokite tyaaki-teenchari itsipa. ");
INSERT INTO cpy_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tee ipaetziri otsitzi okaatzi rooperotatsiri rashitari Tajorentsi. Tee ipaetziri eejatzi chaancho okaatzi poreryaa-yitatsiri pinapero-tachari, tema te riyotziro ineshironka-waetzi ari roepatsi-takiro eejatzi ari raatzika-waetakiro. Teera ipaetatyeeri ikowawitari, osheki imashireyantzitanaki, aritaki ratsikantaki.” ");
INSERT INTO cpy_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pikowako-tante, pithotyaakotee eejatzi, aritaki ipaeteemiro pikoyiri. Poshiya-kaantero aririka pareetyaa pankotsiki, pikanta-paakiri ashitawori: ‘Pashita-reenawo pipanko.’ Ari rashita-ryaakimiro ipanko. ");
INSERT INTO cpy_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Tema aritaki ipaeteeri kowakotan-tatsiri. Ikaate amina-mina-teeroni, aritaki roñaahae-teeri. Aririka ikantante: ‘Pashita-reenawo.’ Aritaki rashitaryahae-takiniri. ");
INSERT INTO cpy_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aririka ikowakotemi pitomi, ikantemi: ‘Pawa, pipina noyaari.’ ¿Arima pipakiri mapi? ");
INSERT INTO cpy_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aririka ikantemi: ‘Pipina shima.’ ¿Arima pipakiri maanki royaari? ");
INSERT INTO cpy_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tema piyotziro petakotari eeroka pitomi-paeni, okantawita pikaari-pero-wita eeroka. Riitaki maperotzirori Ashiteeri Inkite-jatzi, retakotari maawoeni amanayi-teeriri. ");
INSERT INTO cpy_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aririka pikoyi retakoeteemi, petawakyaawo eeroka petakotantyaa. Tema rootaki Ikowakaan-teetani, roojatzi ikantakiri paerani Kamantan-taniri-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aririka pikoyi pikyaa-wanko-teeri Tajorentsi, pikimitakantyaawo pipampi-thata-tyeeromi awotsi-manchaki. Tema eenitatsi otsipa jaawoki-tatsiri, kaari pomeentsi-tachani ikinantee-tyaawo. Tema osheki pampitha-takirori, riitaki ashironkahaa-chani sharinkaweniki. ");
INSERT INTO cpy_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Rooma awotsi-manchaki, tee ishekitzi kinantyaawoni, riitaki areetaa-chani janta ashi rowaero rañahae.” ");
INSERT INTO cpy_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Paamahae-yaani eerokapaeni ramatawi-tzimi-kari oshiyawi-tariri Kamantan-taniri, roshiya-paakyaari ipireetari eero imashireyantzi-waetzi. Roo kanteencha, kaari-pero-shiretaki rirori inthomoeki, roshiyakari owantaniri. ");
INSERT INTO cpy_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Otzimatyee aminiri kameetha-rika okaatzi rantayi-tziri, rootaki ayotant-yaari kameethashiretaki rirori. ¿Añiiroma chochoki imiriteetziri okithoki-tantyaawo owaato kitochee? Tema te. ¿Kantachama okithoki-tantyaawo otsipa chochoki-paeni roori? Tema eero. ");
INSERT INTO cpy_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Roorika inchato jaankanato-tatsiri oshooki, okithokitzi kameetha. Rooma inchato jampishi-tatsiri, tee okameethatzi okithoki. ");
INSERT INTO cpy_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tema okaatzi inchato jaankanato-tatsiri oshooki, tee okaariperotzi okithoki. Ari okantari eejatzi inchato jampiya-shita-tsiri oshi, tee okameethatzi okithoki. ");
INSERT INTO cpy_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tema ari itowaetakiro inchato kaari kithoki-tatsini, rahaetero itahaetero. ");
INSERT INTO cpy_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Aritaki piyotee-yawakirini eeroka-paeni amatawitantaniri aririka piñaayi-takiro okaatzi rantayitziri.” ");
INSERT INTO cpy_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Eeniwitacha osheki kantanari: ‘Eerokataki Nowinkatharite, nopinkatha-tzimi.’ Eero ikyahae rirori inkiteki jempe ipinkathari-wenteeri Tajorentsi. Apatziro ikaatzi antaneerori ikoyiri Ashitanari Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aririka nopinkatharitee paata ari nopiyoteeri maawoeni atziri. Eenitatsi kantayi-teenani: ‘Nowinkatharite, nopaeryaa-kimiro piwaero nokenkitha-takotzimi. Nopaeryaakimi netsiya-takota-kaeri raahashiri-tziri peyari. Ari nokimiteeriri eejatzi nosheninka-paeni, osheki notajonka-wenta-yitaki nopaeriiniri piwaero.’ ");
INSERT INTO cpy_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ari nokanta-wakiri naaka: ‘Tee niyotzimi. Piyaate inteena, tema osheki pantakiro kaari kamethatatsi.’” ");
INSERT INTO cpy_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pikemi. Aririka pikenkishiryaakotero maawoeni nokanta-kimiri, aririka pikemijanta-neero maawoeni, ari okameethatzi. Rootaki piyotani-tyaari. Poshiyaari wetsika-tsiri ipanko okijopathatzira kepatsi. ");
INSERT INTO cpy_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oparya-witaka antawo inkani, amaaniwitaka. Antawo otampyaa-witaka, ookanta-witapaakawo pankotsi, tee aawiyiiro. Tema owatzika-kityaa kameetha okijopathatzira kepatsi. ");
INSERT INTO cpy_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari okimitari eejatzi eerorika pikenkishiryaako-tziro okaatzi nokanta-yitakimiri, eerorika pikemijanta-neero, te piyotanitzi. Poshiya-kotakari wetsika-tsiri ipanko impanekii-teki. ");
INSERT INTO cpy_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Okanta oparya-paaki inkani, amaanita-paaki. Ari otampyaa-tapaaki, ookanta-paakawo pankotsi, tyaanaki. Tee iñahaeteero.” ");
INSERT INTO cpy_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Rootaki riyotaa-kiriri Jesús ikaatzi piyowenta-kariri. Ipampoyeeyanakirini atziri-paeni ikemirira. ");
INSERT INTO cpy_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tema tee omaanta ishintsinka riyotaantzira, rawijiri riyotaantzi Yotaantaniri-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ikanta roerinkaawo Jesús ikenkitha-takira tonkaariki, royaateeri osheki atziri. ");
INSERT INTO cpy_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ari ipokashi-takiri omatziri pathaa-wontsi, rotziwerowa-shita-paakari, ikantapaakiri: “Pinkatharí, pikoyi-rika, niyotzi aritaki pimatakiro petsiyatakotakahaena.” ");
INSERT INTO cpy_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Roojatzi rakotan-tanaka Jesús, rotzinkakiri eepichokiini, ikantziri: “Nokoyi, petsiya-takotee.” Etsiyatanaki ipathaa-waewitaha. ");
INSERT INTO cpy_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ikantawi-tawaari Jesús pathaawae-witachari: “Eerowa pikaman-takotana. Apatziro powanakiro piyaata-shiteri Ompera-tajorentsi-taarewo, pimatan-tyaawori Ikowakaantani paerani Moisés, paanakiniri Tajorentsi pashita-kaariri pipira, rootaki riyotan-teetyaari etsiyata-koteemi.” ");
INSERT INTO cpy_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ikanta rawijanaki Jesús, areetee-yakani nampitsiki Capernaum. Ari ipokaki reewari rowayirite wirakocha iñeeri Jesús, ");
INSERT INTO cpy_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ikantapaakiri: “Nowinkatharité, eenitatsi naaka nomperatani nopankoki, maperotaka imantsiyataki, kijopookitaki.” ");
INSERT INTO cpy_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ari rakanakiri ikantziri: “Aritaki niyaataki netsiya-takota-kahaeri.” ");
INSERT INTO cpy_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ikantanaki rirori: “Osheki nopinkatha-takimi eeroka, tema tekatsi koyinani naaka, eero okanta pikyaa-wankotana. Apatziro nokoyi pikanta-kaanteri retsiya-takotee, aritaki omatakyaa pikanteri. ");
INSERT INTO cpy_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Eenitatsi omperatanari naaka, eenitatsi eejatzi owayiri-paeni nomperatari naaka. Aririka nokanteri: ‘Piyaate,’ aritaki riyaataki. Aririka nokante itsipa: ‘Pipoki,’ aritaki ipokaki. Aririka nokanteri nomperatani: ‘Pantero iroka,’ imatziro rantziro.” ");
INSERT INTO cpy_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ari ipampoyaanakiri Jesús ikemakirira ikantaki reewarite owayiri. Ikantanakiri ikaatzi oyaatakiriri: “Riitaki matakirori irika ikemijantzi, tema jaka inampiiteki Israel-paeni tekira noñee apaani oshiyaarini irika. Omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pikemi, aririka ipinkathari-wentantee Inkite-jatzi, aritaki itzimaki osheki itsipa-jatzi poñaachani otsipaki nampitsi, inintahaeyaa rakiyoteeri awaejatziteni Abraham, Isaac, eejatzi Jacob. ");
INSERT INTO cpy_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Eero itzima-perotee asheninka jeekaatsini janta. Riitaki ikowawi-teetari ipinkathari-wenteeri maawoeni janta, tema osheki ipiyathataka, rootaki rookantee-yaariri otsireni-kaakitzira. Ari riraawae-tyaari, ratsikae-kiwae-teeyaa ikemaatsi-teeyaa.” ");
INSERT INTO cpy_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ipithoka-shita-naari reewarite owayiri, ikantziri: “Pipiye pipankoki. Pimatakiro pikemijantzi eeroka, rootaki retsiya-takotan-teeyaari pomperatani.” Intsipaete retsiya-takotanaki romperatani ipankokinta. ");
INSERT INTO cpy_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ikanta ikinanaki Jesús ipankoki Pedro. iñaapaa-tziiro riyote omaryaaka, omatatziiro jaawa-kirentsi. ");
INSERT INTO cpy_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Rotzinkan-tapaakawo eepichokiini rako, etsiyata-kotanaki. Piriintanaka, aminayi-tawakiniri oetarika opawakiriri. ");
INSERT INTO cpy_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Okanta otsireniityaanaki, ramaeta-paakiniri osheki raahashiretziri peyari. Retsiya-takota-kaayi-teeri ikijatha-yitakiri iweyarite. Retsiya-takota-kaaki eejatzi ikaatzi mantsiya-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ari omonkaatari ikamantan-takiri paerani Kamantan-taniri Isaías, ikantaki: Riitaki aanakironi amantsiyanka, Riijatzi aanakironi okaatzi akemaatsi-yitari. ");
INSERT INTO cpy_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ikanta iñaakiri Jesús isheni-pero-tapaaki atziri piyowentakariri, ikantanakiri riyotaani: “Jame amontyaakotee intatsikironta.” ");
INSERT INTO cpy_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikantawi-tawaari Yotaantaniri: “Yotaanari, nokoyi noyaata-nakimi jempe pikinayite eeroka.” ");
INSERT INTO cpy_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Rakanaki Jesús, ikantziri: “Eenitatsi imoo kowincha imaantapiintari, eejatzi ikimita tsimereriki-paeni eenitatsi imenkoshi. Riima irika Itomi Atziri tee otzimi ipanko imaantyaari rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ari ikantanaki riyotaani: “Yotaanari, nokowawitaka naaka noyaata-nakimi, eero nomatzimaeta nimaeka, nokowatzii noñeeri nokitata-neeri ashitanari, aripaete noyaatemi.” ");
INSERT INTO cpy_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ikantanaki Jesús: “Poyaatena. Tema ikaatzi kamatsiri, aritaki ikitateeri rirori kaminkari-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ari rotetanaka Jesús pitotsiki, itsipatakari riyotaani-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikanta imontyaa-kotanaka, maanaki Jesús pitotsiki. Ro roweyaa-kowitaka niyankyaani, omapokakiri riyotaani-paeni antawo tampyaa, kitaatapaaka nijaa pitotsiki otamakaa-tanakira inkaari. ");
INSERT INTO cpy_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Riyaata-shitanakiri apani riyotaani Jesús, rowakiryaapaakiri, ikan-tziri: “¡Yotaanari, apiinkatyeewe! ¡Powawijaa-koteena!” ");
INSERT INTO cpy_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ikantanakiri rirori: “¿Iitaka pithaawantari? ¿Tekirama pikemijanta-perotzi?” Piriintanaka, romaeryaakiro tampyaa eejatzi otamakaatzi inkaari, awijanaki, maeryaa-tanee kameetha. ");
INSERT INTO cpy_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ipampoyeeyanakirini Jesús, antawo ipinkatha-tanakiri, ikanta-wakahaeyani: “¿Iitaka atzirita-tsiri irika? Romaeryaantawori tampyaa, eejatzi inkaari.” ");
INSERT INTO cpy_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Areetee-yakani intatsikiro, aatakota-paaki nampitsiki iiteetziri Gadara. Ari ishiyashi-tawakari apite atziri raahashiretziri peyari ipoñaakawo kitataarewo-mashiki. Ikijakaakari peyari, osheki ithaa-wanteetari, tee imateetyaa ikineete janta. ");
INSERT INTO cpy_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Icheraa-pero-tanaki ikantzi: “¡Jesús, Itomi Tajorentsi! ¿Nimaekama powajankitena tekira omonkaa-tyaata? ¿Jempema nokanta-kimika eeroka?” ");
INSERT INTO cpy_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari ishimoka-waeteeyini osheki chaancho janta. ");
INSERT INTO cpy_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñaawaetanaki iweyarite, ikantzi: “Aririka petsiyatakotakahaeri naahashiretanewo, potyaantena ipiyotakaha chaancho.” ");
INSERT INTO cpy_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ikantzi Jesús: “¡Piyaate peyari!” Jatanaki peyari-paeni chaanchoki, raahashireta-paakiri, rootaki ishiyan-tanakari impeetaki, pariyee-yapaakani maawoeni inkaareki, thonkaka ipiinkaeyakini. ");
INSERT INTO cpy_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ikanta iñaakiro aminiriri chaancho okaatzi awijeentsiri, shiyanaka nampitsiki, ikamantapaakiri maawoeni atziri okaatzi iñaakiri. ");
INSERT INTO cpy_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Rootaki riyaata-shitan-tanakariri atziripaeni irika Jesús, ikantapaakiri: “Tee nokoyi pijeeki nonampiki, pamine jempe pikini.” ");
INSERT INTO cpy_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ikanta rotetanaa Jesús pitotsiki, montyaa-kotanaa inampiki. ");
INSERT INTO cpy_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari ramaeta-kiniri kijopookiri, inatakoe-takiri romaryaa-mentoki. Riyoshire-tawakiri Jesús ikaatzi natako-takiriri osheki rawentaa-paakari, iñaanata-wakiri mantsiyari, ikantziri: “Pithaamenta-shiretyaa nosheninká, tema ipeyakoe-teemiro pikaaripero-shire-witaka.” ");
INSERT INTO cpy_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kemawaki rirori Yotaantaniri-paeni, ikanta-shire-tanaki: “Itheenka-tajorentsi-tatzii irika.” ");
INSERT INTO cpy_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tema yotaki Jesús jempe ikanta-shiretzi, rojampi-tanakiri, ikantziri: “¿Iitaka pikaaripero-shire-tantari? ");
INSERT INTO cpy_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tema okameethatzi nokante: ‘Ipeyakoe-teemiro pikaaripero-shire-witaka?’ ¿Rooma pikoyi nokanteri: ‘Pikatziyanee, piyaatee?’ ");
INSERT INTO cpy_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Nimaeka piyoteri Itomi Atziri otzimimo-tziri ishintsinka jaka kepatsiki, aritaki ipeyako-teeniri antawitawori kaari kamethatatsi.” Ipithoka-shita-nakari kijopookiri, ikantziri: “Pikatziye, paaneero pomaryaa-mento, piyaatee pipankoki.” ");
INSERT INTO cpy_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Apathakirotanaa ikatziyanaa mantsiya-witachari, jatee ipankoki. ");
INSERT INTO cpy_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tema iñaakiri maawoeni piyoteen-chari, ipampoyeeyanakirini iñaawaerira riyaatee. Ikantee-yanakini: “Imapero-tatyaa Tajorentsi, riitaki matakirori otzimimo-tantariri itajorenka irika atziri.” ");
INSERT INTO cpy_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ikanta rawijanaki Jesús, roojatzi iñaanta-paariri Mateo, irika riitaki shintsi-tantatsiri ramaeteniri koriki. Ikantapaakiri: “Poyaatena.” Roojatzi ikatziyantanaka Mateo royaata-nakiri. ");
INSERT INTO cpy_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Areetaka ipankoki Mateo rowakae-yaari Jesús, ari ikaatakiriri riyotaani-paeni. Tema osheki shintsitan-tatsiri ramaeteniri koriki oyaatanakiriri Jesús, riyaatzitaka eejatzi osheki antayitzirori kaari-perori. Ari ikaatzi rakiyotakiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ikanta iñaakiri Inashitantaniri, ikaemakiri riyotaani Jesús, rojampi-takiri, ikantziri: “¿Iitaka rakiyotan-tariri Jesús shintsi-tatsiri ramaeteniri koriki eejatzi antayitzirori kaari-perori? Tee okameethatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ikemaki rirori Jesús, ikantzi: “Aririka imantsiyate atziri ipokashi-tziri aawintantaniri, riima atziri kaari mantsiya-tatsi tekatsi ikoyi rirori. ");
INSERT INTO cpy_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Otzimatyee pikenkishireero Ikantakaantani Tajorentsi, kantatsiri: Tee apatziro nokoyi pamayiteena pipira pitayinari. Roo nokowa-pero-teeri pineshironka-teeri pisheninka. Tema tee apatziro nopokashi-tziri kameetha-shireri nokaema-shire-teeri, tema nopokashi-tatziiri kaari-pero-shireri nokaema-shire-teeri ipakahaero kaari-perori.” ");
INSERT INTO cpy_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ari ipokaeyakini riyotaani Juan, rojampi-tapaakiri Jesús, ikantziri: “¿Iitaka kaari itziwentanta piyotaani? Tema notziwenta-piinta naaka, ari ikimi-tzitari riyotaani Inashitantaniri.” ");
INSERT INTO cpy_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ari rakanakiri Jesús, ikantanakiri: “Aririka aate aawakaan-tsiki, ¿arima owashire-tapaakyaa? Rooma aririka paata, rahaetakiri iimenteetari, aripaete itziwenteetyaa. ");
INSERT INTO cpy_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Tema apaani paejatopookiri kithaa-reentsi, aririkami rowama-tanteetyaawo owakirari ojapeki, aritaki otzijaa-pero-tanaki aririka amintha-tanakyaa owakirari ojapeki. ");
INSERT INTO cpy_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ari okimitari eejatzi, tee ikameethatzi paejatoteentsiri mashitsi-naki rowantee-tyaari eeryaari imiriteetziri. Aririka rowantee-tyaari, aritaki ijanaryaanaki, ari apaatashi-waetakyaa imiriteetziri eejatzi mashitsi-naki. Tema riitaki kameetha-tatsi owakirari mashitsi-naki rowantee-tyaari.” ");
INSERT INTO cpy_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ikenkithawae-mintheetzi Jesús, areetapaaka ijewarite Judá-paeni, otziwerowa-paaka ipinkatha-tapaakiri, ikantziri: “Kamaki nishintyo, rootaki nopokantari piyaate nopankoki pantantee-yaawo eepichokiini pako, añahaeta.” ");
INSERT INTO cpy_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ari riyaatanaki Jesús, eejatzi riyotaani-paeni, royaata-nakiri. ");
INSERT INTO cpy_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ari opokapaaki tsinani mantsiya-tatsiri, tema osheki ojarentsi ojokaawaetaka ira, kaatakotaki 12 ojarentsi, okinashi-tapaakiri itaapiiki Jesús, antakiro eepichokiini opatziki iithaari. ");
INSERT INTO cpy_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Okanta-shiretzi: “Aririka notzinki-takiri eepichokiini iithaari, aritaki netsiyata-kotee.” ");
INSERT INTO cpy_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ari ipithoka-shita-nakawo Jesús, ikantziro: “Pithaamenteeyaa nosheninká, rootaki etsiyatakoteemiri pawentaanaha.” Intsipaete etsiyatanaki omantsiyanka tsinani. ");
INSERT INTO cpy_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ikanta rareeta-paaka Jesús ipankoki reewarite Judá-paeni, iñaapaa-tziiri showiwentzirori kamaentsiri, osheki atziri akisheenkaateen-chari rirahaeyani. ");
INSERT INTO cpy_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ikantapaakiri: “Pishekaeyini, tee okami piraa-koteeya-karini, omakoryaatzii.” Tema itheenkaetatziiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Romishitowa-paakiri maawoeni, kyaapaaki Jesús, roteeya-wako-tapaakiro, piriintanaa eentsi. ");
INSERT INTO cpy_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tee romanako-tanaka Jesús, ikemakoe-tanakiri maawoeni janta. ");
INSERT INTO cpy_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ikanta rawijanaki Jesús, royaata-nakiri apite mawityaakiri, ikantzi ikaemi: “¡Ikashiyakaetani pinkatharini David, pineshironka-teena!” ");
INSERT INTO cpy_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Roojatzi rareetan-tapaakari pankotsiki. Ipokapaaki okaakiini mawityaakiri, ari rojampi-takiri Jesús, ikantziri: “¿Tema pawentaakina eeroka aritaki nomatakiro pikoyiri?” Ikanteeyini rirori: “Jeen, ari pimatakiro Nowinkatharite.” ");
INSERT INTO cpy_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Akotanaki Jesús, ipampitakiri eepichokiini rokiki, ikantziri: “Owawijaakoteemi pawentaana.” ");
INSERT INTO cpy_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Apathakirotanee raminanee kameetha. Ishintsi-thawi-tawaari, ikantziri: “Eero pikaman-takotana netsiyatakotahaemi.” ");
INSERT INTO cpy_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Roo kanteencha, jateeya-nakini irika-paeni ikamantan-tanaki, ithonka ikemakoe-tanakiri Jesús janta. ");
INSERT INTO cpy_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ikanta ramaeta-paakiniri Jesús raahashiretziri peyari, ikijopaantetatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tema retsiyatakotakaa-wakiri Jesús irika atziri, ñaawaetanee, tema romishitowaeniri iweyarite. Ipampoyeeyanakirini atziri-paeni, ikanta-shire-teeyini: “Te añaapiintziri asheninka-paeni imatero oshiyaawoni rantakiri irika.” ");
INSERT INTO cpy_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Riima Inashitantaniri-paeni, ikanteeyini rirori: “Ipajawyaa-kiri reewarite peyari retsiyatakotakaantariri raahashiretani.” ");
INSERT INTO cpy_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tema ithonka ranashi-takawo Jesús maawoeni nampitsi, riyotaan-tayitaki jempe ipiyota-piinteeta. Ikenkithata-piintakiro Kameethari Ñaantsi, jempe okanta ipinkathari-wentantee. Retsiyatakotakaayiteeri maawoeni, tekatsi apaani mantsiyarentsi pomeentsi-tzimo-tyaarini. ");
INSERT INTO cpy_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ikanta iñaakiri Jesús osheki piyowenta-kariri, antawo retako-shire-tanakari, ikantanaki: “Kyaari-perotaki rashironkaayita irika atziri-paeni. Roshiyakari ipireetari eerorika itzimi aamaako-wentyaarini.” ");
INSERT INTO cpy_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Eekiro ikantana-kitziiri riyotaani-paeni: “Roshiyakawo irika-paeni atziri ojampaen-katzi pankirentsi, teemaeta itzima-perotzi atziri owiiteeroni. ");
INSERT INTO cpy_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pamaneeri eerokapaeni Awinkatharite, rotyaantantyaari osheki jatashiterini atziri-paeni, tema eenitatsi osheki kemijantaa-tsini.” ");
INSERT INTO cpy_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Roojatzi riyoyaantaka Jesús 12 riyotaanewo, ipakiri ishintsinka. Imatanakiro rirori retsiyakotakaa-yitziri maawoeni inashiyitachari imantsiyanka eejatzi ikaatzi raahashireyi-tziri peyari. ");
INSERT INTO cpy_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Irika ikaatzi 12 riyoyaakiri Jesús, riiyitaki iitakiri Otyaantaarewo: Etanakawori Simón, iitakiri Pedro. Kaakitapaaki Andrés, rirentzi Pedro. Kaakitapaaki Jacobo itomi Zebedeo eejatzi Juan rirentzi. ");
INSERT INTO cpy_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Kaakitapaaki rirori Felipe, Bartolomé, Tomás, Mateo shitsitantatsiri amaeteniri koriki, kaakitapaaki Jacobo itomi Alfeo, Tadeo, ");
INSERT INTO cpy_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","kaakitapaaki Simón, iiteetziri eejatzi Kijakotan-taniri. Kaakitapaaki iweyaanta-paakawori Judas Nampitsiweri, riitakira pithoka-shita-kariri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Opoñaashita rotyaantakiri Jesús kaatatsiri 12, riyotaa-yitawakiri, ikantziri: “Eero pikini ijeekira itsipa-jatzi atziri, eero pikinanaki eejatzi inampiki Oshitekii-toni-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Apatziro pikinayitanaki inampiki Israel-paeni, jempe ijeekayitzi oshiyakariri ipireetari peyayiteenchari. ");
INSERT INTO cpy_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Aririka piyaatanaki iroka pikante pikamantante: ‘Rooteentsi ipinkathari-wentantee Inkite-jatzi jaka.’ ");
INSERT INTO cpy_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Petsiyatakotakaa-yiteeri mantsiyari, powañaa-yiteeri kamatsiri, petsiyatakota-kaeri pathaawae-tatsiri, eejatzi raahashireyi-tziri peyari. Tema Tajorentsi neshironka-teemi eerokapaini, tee ikowako-tzimi pipinateri. Rootaki pimataneeri eeroka eero pikowako-tantzi ipineetemi, pineshironka-tantee. ");
INSERT INTO cpy_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Eero paanaki piyorikite, ");
INSERT INTO cpy_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","eejatzi poyaari awotsiki. Eero paanaki otsipa pithaari, eejatzi otsipa pikyaan-tyaari piitziki, pikotzi. Tekatsi otsipa paanakiri. Tema ikanteetzi: Ari ipineeteri antawae-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aririka pareetakyaa nampitsiki, paminapaaki aakameetha-tawakimini, riitaki pijeeki-motapaakiri, roojatzi pawijan-takyaari otsipaki nampitsi. ");
INSERT INTO cpy_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Aririka pareetakyaa pankotsiki, piwetha-tanta-paakyaa. ");
INSERT INTO cpy_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aririka raakameetha-tawakimi piwetha-tapaakari, aritaki ijeekae kameetha. Eerorika raakameetha-tawakimi, aminaashitaka piwetha-witapaakari. ");
INSERT INTO cpy_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eerorika raakameetha-tzimi, eerorika ikemijantzimi eejatzi, pawija-pithateri, potekaneero pipatsi-te piitzira. ");
INSERT INTO cpy_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Riitaki imapero-ete paata rowajankiteeteri, aritaki awijanakiro ikantee-takiri paerani Paamaarini-jatzi eejatzi Katsimaaniri-jatzi. Omaperotatyaaha.” ");
INSERT INTO cpy_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Notyaantzimira nimaeka, poshiyakari rotyaantee-tziri ipireetari jempe ipiyota owantaniri. Roo kanteencha, otzimatyee poshiya-kotyaari eeroka-paeni kokiyantzi maanki, poshiya-kotyaari eejatzi jamomo itsinampa-shire-waetzi. ");
INSERT INTO cpy_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Paamaeyaa. Tema rahaeta-tyeemi jewariki, ipajawae-teetemi jempe ipiyota-piinteeta. ");
INSERT INTO cpy_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ompoñaashitya rahaeta-nakimi ijeekira pinkathari-perori okantakaan-tziro pawentaanaha. Ari pikenkitha-takoyi-teenari janta, ikemayitee eejatzi itsipa-jatzi atziripaeni. ");
INSERT INTO cpy_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aririka ahaeta-nakimi, eero pikanta-shire-waetzi: ‘¿Iitakama noñaawae-tapaakiri?’ Tema eenitatsi yotashire-takae-mironi iitarika piñaawaeteri. ");
INSERT INTO cpy_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Eero piyotashitawo eeroka iitarika piñaawaeteri, rootaki Ishire tajorentsi poñaachari Ashitzi-miriki yotakae-mironi okaate piñaawaeteri. ");
INSERT INTO cpy_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Aritaki iñahaetaki aakaanterini rirentzi rowamaa-kaanteri. Aakaanterini itomi. Eenitatsi owamaakaan-terini ashitariri ikijaneenta-nakiri. ");
INSERT INTO cpy_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Osheki kijaneentemini okantakaawo pikemijantaana. Roo kanteencha, ikaatzi oejokiro-tanari rawentahaana, riitaki awijako-taatsini. ");
INSERT INTO cpy_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aririka ikijaneentee-tanakimi janta, pawija-pithateri. Tema tekira pithotyeerota piyaayite inampiki Israel-paeni, piyapaaka irika Itomi Atziri. Omaperotatyaaha. ");
INSERT INTO cpy_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Teera iñahaetzi apaani riyotahae-tziri rawijiri iyoteeriri. Te iñahaetzi eejatzi apaani omperataarewo rawijiri omperatariri ipinkatheeteri. ");
INSERT INTO cpy_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apatziro añiiri apaani riyotahae-tziri ikimityaari yoteeriri paerani. Ari ikantari eejatzi omperataarewo. Tema osheki ikijaneentee-takina nimaeka naaka, ikimitakantakina naakami Nantatsiri. Eeroka imapero-teete ikijaneenteetemi pikemijantaanaha.” ");
INSERT INTO cpy_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Eero pithaawan-tawaetari irika-paeni, tema otzimatyee okoñaata-koyitee okaatzi omanako-witeen-chari, ooñaawonteero kaari ikematha-witeeta paerani. ");
INSERT INTO cpy_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eenitatsi-rika nokaman-temiri tsireniriki, pikamantan-teero eeroka kitejeriki. Eenitatsi-rika nokenkitha-takaemiri eerokapaini nomanakaashitari, pikaman-teeri eeroka maawoeni atziri. ");
INSERT INTO cpy_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Eero pithaawan-tawaetari kowatsini rowamayimi, tema eero imatziro rookaemi rirori sharinkaweniki. Apatziro pithaawan-tyaari Tajorentsi matzirori ithonkantzi, rooka-shire-tantzi sharinkaweniki. ");
INSERT INTO cpy_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tema tee ipina-perowita tsimereri-paeni, roo kanteencha riyotzi Tajorentsi aririka ikamahaante apaani. ");
INSERT INTO cpy_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Tema riyotzitawo Tajorentsi jempe okaatzi tzimatsiri aeshi. ");
INSERT INTO cpy_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Piñaakiro, tema raamaakotari Tajorentsi tsimereeriki-paeni, eeroka imaperotzi raamakowenteemi. Eero pithaawan-tawaetari kijaneentzimiri. ");
INSERT INTO cpy_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aririka pikanteri pisheninka: ‘Nopinkatha-teeri Jesús,’ aritaki nokanteeri Ashitanari Inkite-jatzi: ‘Pawa, ipinkatha-taana irika.’ ");
INSERT INTO cpy_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Rooma pikanteri-rika pisheninka: ‘Tee nopinkatha-tziri Jesús,’ aritaki nokantzi-tyaari naaka, nokanteeri Ashitanari: ‘Pawá, tee ipinkathatana irika.’” ");
INSERT INTO cpy_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Eero pikenkishiryaa-waeta eerokapaeni, tee apatziro nopoki niyotaa-yiteeri atziri-paeni raakameethata-wakahaeyaa jaka kepatsiki, tema okimiwi-takawo namatyeemi owathaa-mentotsi ikosheka-wakaan-teetyaari. ");
INSERT INTO cpy_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tema iroka nopokan-takari: Ikijaneenteeri atziri ipaapate, Okijaneenteero tsinani iniro, Okijaneenteero tsinani ayiro. ");
INSERT INTO cpy_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ipithoka-shita-wakaeyaa atziri-paeni ikijaneenta-wakaeyaa ikaatzi ijeekaeyini ipankoki. ");
INSERT INTO cpy_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Rootaki kameetha-witacha petakot-yaari pipaapate, piniro, peentsite-paeni. Roo kanteencha, roorika poetziñaariko-teeya petakot-yaari pisheninka-paeni, awijanakiro-rika okaatzi petakotana naaka, eero nokimita-kaemi naapatziyani. ");
INSERT INTO cpy_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Otzimatyee pikyaaryoo-wenteero okaatzi nokenkitha-takaa-yitakimiri, okantawityaa ikentakoetemi. Eerorika pipakaero, eero nokimita-kaemi naapatziyani. ");
INSERT INTO cpy_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tema ikaatzi etakowae-tachari apaniroeni rootaki rantantawori ikowashi-waetari rirori, aritaki ipeyashi-teeyaa. Riima ikaatzi atsipewentawori rantaneero nokoyiri naaka rootaki ikamawentan-tanari, aritaki rawijakotee.” ");
INSERT INTO cpy_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Eenitatsi-rika aapatziyemini, naaka raapatziyaka. Ari okantari eejatzi, eenitatsi-rika aapatziyinani naaka, riitaki raapatziyaka Ashitanari otyaanta-kinari jaka. ");
INSERT INTO cpy_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Eenitatsi-rika yotemini eerokataki Kamantan-taniri rootaki raapatziyan-tzimiri, aritaki pikaateeri paata ipinateemi Tajorentsi. Ari okanta eejatzi, eenitatsi-rika yotakimini kameethashireteemi pikemijantee rootaki raakameetha-tantzimiri, aritaki pikaateeri paata ipinateemi Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aririka riyoeteemi eeroka niyotaani, rootaki ipantee-tzimiri pimiri okantawitaka tee piriiperowita eeroka, aritakira ipineeteeri paata irika etakota-kamiri. Omaperotatyaaha.” ");
INSERT INTO cpy_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ikaatakiro Jesús riyotaakiri 12 riyotaani. Awijanaki ikamantante maawoeni nampitsiki okaatzi jeekatsiri janta. ");
INSERT INTO cpy_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tema omonkyahaetakiri rirori Juan omitsiryaatantaniri, ari ikemako-takiri Jeepatziitoetani okaatzi rantayi-takiri. Rotyaantaki apite riyotaani, ");
INSERT INTO cpy_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","rojampiteri, ikanteri: “¿Eerokama iiteetziri, ‘Pokatsini?’ tema eeroka, ¿Eenitatsima itsipa noyaakoteri?” ");
INSERT INTO cpy_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ikanta rareetee-yakani, rojampi-tapaakiri Jesús. Ari rakanaki rirori, ikantzi: “Aririka pipiyanee, pikaman-tapaeri Juan okaatzi pikemakiri eeroka, okaatzi piñaakiri nantayi-takiri. ");
INSERT INTO cpy_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tema naminakaa-yiteeri mawityaakiri, nanashi-takaa-yiteeri kijopookiri, netsiya-takota-kaayi-teeri pathaawae-tatsiri, nokemakaa-yiteeri matayempitari, nañaakaa-yiteeri kaminkari, nokenkitha-takoteeniri Kameethari Ñaantsi ashironkaenkari-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ikimoshiretee ikaate kaari kijoshire-wenteenani.” ");
INSERT INTO cpy_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ikanta ipiyaawo riyotaani Juan, rojampi-tanakiri Jesús ikaatzi piyowenta-kariri, ikenkitha-takotziri Juan, ikantzi: “¿Iitakama piñaakiri chapinki ochempi-mashiki? ¿Riima piñaaki oshiyawori jawooki ompironka-kaawo tampyaa? ");
INSERT INTO cpy_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Piñaakirima rowaneenkata ikithaata? Tema tee rowaneenkata. Tema ikaatzi owaneenka-tachari ikithaata, riitaki jeeka-tsiri ipanko-ki pinkathari. ");
INSERT INTO cpy_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Rootaki piyaata-shitan-tariri piyotzi riitaki Kamantan-taniri. Tema imapero-tatziiro rirori rawijanakiri itsipa Kamantan-taniri-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tema riitaki rojankina-takoe-takiri paerani ikanteetzi: Pamini, aritaki notyaantaki etyaawoni ikamanta-kotemi, Riitaki owetsikaan-temini jempe pikinapaaki. ");
INSERT INTO cpy_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pikemi nokantzi naaka: Paerani osheki atziri tzimawi-teenchari, tekatsi awijirini Juan omitsiryaatantaniri okaatzi riyotani-tzi rirori. Riima ikaate tsinampa-shire-taatsini, ipinkathari-wenteeri Tajorentsi inkiteki, aritaki rawijeeri rirori Juan. Omaperotatyaaha. ");
INSERT INTO cpy_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tema owakira retanta-nakawori Juan ikenkitha-takaemi roojatzi nimaeka, eenitatsi osheki kowatsiri intsipaete iñiiro ipinkathari-wenteeri Inkite-jatzi. Kimiwitaka ishintsiteetziri aririka rowayiriteetyaa. ");
INSERT INTO cpy_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Paerani eeniyitatsi Kamantan-taniri-paeni eejatzi Ikowakaan-teetani, rootaki ikamantan-teetakiri roojatzi itziman-takari Juan. ");
INSERT INTO cpy_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Riitakira Juan ikenkitha-takoe-takiri paerani, tema riitaki Elías-tatsiri pokatsini. ¿Pikemijantziroma? ");
INSERT INTO cpy_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Koyirori ikemathatero, ikemijante. ");
INSERT INTO cpy_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Iitaka noshiya-kaanteriri irikapaeni atziri? Roshiyakari rowashaantawaeta eentsi aririka roshiya-kowaetantyaa, ");
INSERT INTO cpy_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ikanta-wakaeyani: ‘Jame ashowiwaete.’ Tee ikoyi. Ikantawita: ‘Jame omampawaetyaa owashire-tantyaari.’ Tee ikoyi. ");
INSERT INTO cpy_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aritaki pikantee-yakani eerokapaeni. Piñaawi-takari Juan, itziwenta-paaka, tee imiritziro kachori, pikantee-yakirini: ‘Raahashireta-tziiri peyari, rootaki itziwae-tantari.’ ");
INSERT INTO cpy_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ipokawitaka Itomi Atziri, tee itzitawo rirori owanawontsi, imiritziro kachori. Pikantee-yakirini: ‘Kaari-perori irika, niyawae-rintzi, shinki-tzinkari. Raapatziyari shitsitantatsiri amaeteniri koriki, raapatziyari eejatzi kaari-pero-shireri.’ Tekatsi oetyaa, tema aririka iñahaeteero okaate awijatsini paata, ari riyoeteeri omaperotatyaa riyotanitzi.” ");
INSERT INTO cpy_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Opoñaashita ikenkitha-takota-nakiri Jesús ikaatzi ñaawita-kawori itajonka-wentantzi nampitsiki, teemaeta ipakahiro ikaaripero-shire-teeyini. Ikantzi: ");
INSERT INTO cpy_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ashironkaamatsiteerini Shimapankoni-jatzi eejatzi nampitarori Corazín. Osheki piñaawi-takawo notajonka-wentantaki, teemaeta pikemijanteeyini. Riimi ñaakinani Mapini-jatzi eejatzi Shimaa-jatzi, aritaki ikithaa-tanakyaawomi karenimawo-tatsiri kithaarentsi, jeekawae-tanakimi jamampoki rowashiretako-takotyaa ikaaripero-shire-yitakira, ari ikemijanteemi maawoeni riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Paata aririka raminakoe-teeri maawoeni rantayi-takiri, eero imapero-teetziri rowajankiteeteri Mapini-jatzi eejatzi Shimaa-jatzi. Tema eeroka imaperoete rowajankiteetemi. ");
INSERT INTO cpy_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Eejatzi eerokapaeni Capernaum-jatzi-ite, pikenkishirewita piyaatee inkiteki, apatziro piyaa-matsitee jempe ikinayitzi kaminkari. Riimi ñaakinanimi paerani Paamaarini-jatzi okaatzi piñaawi-takari eerokapaeni, roojatzi ijeekimi nimaeka riroripaeni. ");
INSERT INTO cpy_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Paata aririka raminakoe-teeri maawoeni rantayi-takiri, eero imapero-teetziri rowajankiteeteri Paamaarini-jatzi, apatziro imaperoe-teemi eeroka.” ");
INSERT INTO cpy_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Rootaki ramananta-nakari Jesús, ikantzi: “Pawa, tema eeroka pinkathari-wentziriri inkite-jatzi eejatzi kepatsi-jatzi, osheki najahaa-wentakimi. Tema eeroka omani-motakiri yotaniri iroka-paeni, riitaki piyotakaa-yitee oshiyariri eentsi itsinampa-shiretzi. ");
INSERT INTO cpy_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ari okanta, tema rootaki inimota-kimiri eeroka Ashitanarí.” ");
INSERT INTO cpy_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ikantanakiri piyowenta-kariri: “Riitaki Ashitanari yotakaa-nawori maawoeni. Apatziro riyotana rirori, tema naaka Itomi. Ari nokimitzita naaka apatziro niyotziri Ashitanari, kantacha niyotakaa-yiteeri nokoyiri naaka riyoteeri. ");
INSERT INTO cpy_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aririka piñeero okantzimo-shire-waetemi, opomeentsi-tzimo-waetemi, pipoki nojeekira naaka, aritaki nomakoryaa-shire-takaa-yiteemi. ");
INSERT INTO cpy_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Okimiwi-takawo otzimi-rika oeta nokema-tena-takae-miri. Tema eenitatsi nokoyiri niyoteemiri: tema naaka tsinampa-shireri. Aritaki piñahaero nomakoryaa-shireta-kahaemi. ");
INSERT INTO cpy_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tema okaatzi nokema-tena-takaemiri naaka, tee opomeentsi-perota.” ");
INSERT INTO cpy_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Okanta kitejeri imakoryaan-teetari, ikinimo-tanakiro Jesús pankirentsi-mashi. Ari ijaperyanakiro okithoki pankirentsi riyotaani Jesús, tema itasheyee-yatziini. ");
INSERT INTO cpy_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Iñaakiri Inashitantaniri, ikantanakiri Jesús: “Paminiri piyotaani ijaperyaakiwaetzi kitejeri imakoryaan-teetari, tema tee oshinetaan-tsitzi iroka ijaperyaakiwaete.” ");
INSERT INTO cpy_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Akanaki Jesús ikantziri: “Tema piñaana-takotziri pinkatharini David aantawi-takariri itashe itsipatari ikaateeyinira. ");
INSERT INTO cpy_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ikyaaki tajorentsi-pankoki, rowakawo tajorentsi-tatsiri, ipakiri ikaateeyini. Tee oshinetaan-tsiwita, apatziro rowapiintawo Ompera-tajorentsi-taarewo. ");
INSERT INTO cpy_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tema piñaana-tziro Ikantakaan-teetani, tema rantawaeta-piintzi Ompera-tajorentsi-taarewo kitejeri imakoryaan-teeri tajorentsi-pankoki, tekatsi kijantyaarini. ");
INSERT INTO cpy_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nokantzi naaka, eenitatsi jaka ipinkatha-peroe-tziri, riitaki awijirori tajorentsi-panko. ");
INSERT INTO cpy_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Rootaki rojankina-tantee-takari paerani, kantatsiri: Tee nokoyi pamaena pipira pitayinari, Rootaki nokowa-pero-teeri petakoteeyaari pisheninka. Aririka pikematha-teromi iroka, eero pikijantarimi irika-paeni, tema tee ikaaripero-shiretzi. ");
INSERT INTO cpy_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tema irika Itomi Atziri riitaki pinkathari-perotatsiri, rawijiro kitejeri imakoryaan-teetari.” ");
INSERT INTO cpy_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Opoñaashita rawijanaki Jesús, kyaapaaki ipiyota-piinteetaha. ");
INSERT INTO cpy_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ari ijeekakiri janta kijowakori. Ikanta Inashitantaniri-paeni, rojampi-takiri Jesús, ikantziri: “¿Shinetaan-tsita-tsima retsiya-takota-kaanteete kitejeri imakoryaan-teetari?” Rootaki rojampi-tantariri omatant-yaari ikantakoteri. ");
INSERT INTO cpy_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Akanaki Jesús, ikantziri: “Teera paminashitari eeroka pipira aririka rotetyaa omooki kitejeri imakoryaan-teetari, petakotari, pomijokyaahaeri. ");
INSERT INTO cpy_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Riitaki etakoperoetari atziri, rawijiri ipireetari. Tema shinetaan-tsitatsi aneshironka-tante kitejeri imakoryaan-teetari.” ");
INSERT INTO cpy_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iñaanata-nakiri kijowakori, ikantziri: “Pampiryaa-wakotee.” Matanaka ikantakiri, akotsitanee kameetha atziri, oshiyanaawo otsipa rako. ");
INSERT INTO cpy_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ari ishitowae-yanakini Inashitantaniri ipiyotee-yakani, ikenkitha-waetaka-wakaaka, ikanta-wakahaeyani: “¿Jempema akante-rika Jesús owamaan-tyaariri?” ");
INSERT INTO cpy_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yotaki Jesús ikowaetatzii rowamahaeteri, rootaki rawijan-tanakari. Royaata-nakiri osheki atziri, retsiyatakotakaayitziri osheki mantsiyari. ");
INSERT INTO cpy_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ishintsi-thawi-takari ikantziri: “Eero pikaman-takotana.” ");
INSERT INTO cpy_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ari omonkaatari ikenkitha-takiri paerani Kamantan-taniri Isaías, ikantzi: ");
INSERT INTO cpy_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Irika nomperatanewo, riitaki niyoyaakiri. Netakotani naaka, riitaki oemoshirenkanari. kijokiro oyiri Noshire Ikenkithata-kahaeri itsipa-jatzipaeni atziri ikamanteeri tampatzika-shire-takaanta-tsiri. ");
INSERT INTO cpy_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Eero icheraa-waetzi rirori, Eero ikemaetziri ishinchee-nkate ikenkitha-takotyaa ojaawokiyitzira. ");
INSERT INTO cpy_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Eero rowatsita-pero-tziro ijateero jonkari jataawi-tachari, Eero roetsiwakiro paamari-menki tsiwaki-mateen-tsiri, Roojatzi rotsinampaan-teeyaawori iñeeteerorika rooperori. ");
INSERT INTO cpy_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Riitaki royaako-tziri itsipa-jatzipaeni atziri rawentaa-piintee-yaari. ");
INSERT INTO cpy_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ari ramaeta-kiniri Jesús raahashiretziri peyari. Tema imawityaakitakaakiri, ikijo-waante-takaakiri. Imatakiri retsiyatakotaka-waeri, aminanee kameetha, ñaawaetanee. ");
INSERT INTO cpy_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ipampoyeyanakirini maawoeni atziri, ikanteeyini: “¿Riima irika ikashiya-kaeta-kiriri pinkatharini David?” ");
INSERT INTO cpy_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kemaeyakini rirori Inashitantaniri, ikanteeyini: “Irika atziri roshinchaa-tziiri Nantatsiri ashitariri peyari, rootaki roshinchaan-tariri rirori ikaatzi raahashiretziri peyari.” ");
INSERT INTO cpy_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yotzimaetaka rirori Jesús ikenkishiryaakari Inashitantaniri, ikantanakiri: “Aririka ikosheka-wakaeyaa atziri jempe ipinkathari-wentee-tziri, aritaki rookawenta-wakaakyaa. Aririka ikosheka-wakaeyaa atziri inampiki, aritaki rookawenta-wakaakyaa. Aririka ikosheka-wakaeyaa atziri jempe ijeeka-wankota-wakaa, aritaki rookawenta-wakaakyaa. ");
INSERT INTO cpy_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ari ikantzitari eejatzi peyari aririka ikosheka-wakae-yaami. Aritaki rookawenta-wakaakyaa, ¿eeroma ithonka rookawenta-wakaa-nakyaa? ");
INSERT INTO cpy_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Riitakirikami Kamaari Nantatsiri shintsitakaenani naaka, ¿riijatzima shintsitakaeriri piyotaani eeroka retsiya-takota-kaantariri ikaatzi raahashiretee-tziri? Aririka okanta pithawe-tako-tziiri piyotaani, aritaki ikijanta-kimiro okaatzi pikantakiri. ");
INSERT INTO cpy_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Rooma naaka ipanawo ishintsinka Ishire tajorentsi poñaachari Tajorentsiki, rootaki nomatan-tariri netsiyata-kotakaa-yitziri ikaatzi raahashiretziri peyari. Tema romapokakimi eeroka-paeni Tajorentsi ipinkathari-wentantee. ");
INSERT INTO cpy_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tema aririka ikowaete ikoshiteeteri atziri ñaaperori kameetha, otzimatyee reteeta-wakyaari roojoteeteri, eero imataneero ikijako-wentyaawo rashi-witari rayiteeteri. ");
INSERT INTO cpy_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tema ikaatzi kaari aapatziyanari naaka, riitaki kijaneentanari. Ikaatzi kaari amitako-tanari rowita-kotena, reewana-takota-tyaana. ");
INSERT INTO cpy_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pikemi nokantzimiri naaka: Kantacha Tajorentsi raripero-teeri antayitzirori kaari-perori, ari ikanteteeri ñaawaetzirori kaari-perori-paeni. Riima kijima-takironi Ishire tajorentsi, eero rariperoe-teeri. ");
INSERT INTO cpy_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ari okantari eejatzi: Kantacha raripero-teeri Tajorentsi kijima-terini Itomi Atziri, riima kijima-takironi Ishire tajorentsi, eero raripero-teeri. ");
INSERT INTO cpy_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Tema okimiwi-takawo aririka iñahaetero kameethari chochoki, riyoteetzi kameethari okanta owaato. Rooma piyanta-tsiri chochoki, riyoteetzi kaari-perori owaato. ");
INSERT INTO cpy_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Tema poshiyakari maanki eerokapaeni, kaari-pero-shireteeyakimini. Tekatsi pikantyaa piñaawaetero kameethari, tee okameethatzi okaatzi pikenkishiryaa-yitakari, rootaki okaaripero-tantari piñaawae-yitziri. ");
INSERT INTO cpy_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tema apaani kameetha-shireri ikenkishiryaawo kameethari, rootaki okameetha-tantari rantayi-tziri. Riima kaari-pero-shireri tee ikenkishiryaawo kameethari, rootaki okaaripero-tantari rantayi-tziri. ");
INSERT INTO cpy_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Roo kanteencha nokantantari naaka, paata aritaki raminakoe-teero kowaenka-yitatsiri ñaantsi okaatzi iñaawae-yitziri atziri-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kameetharika okanta piñaawae-yitziri, aritaki raakameethee-teemi. Terika okameethatzi, ikantee-teemi: ‘Kaari-perori eeroka, osheki pikemaatsi-waeteeyaa.’” ");
INSERT INTO cpy_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ari rakanaki Inashitantaniri eejatzi Yotaantaniri, ikantzi: “¡Yotaanari! Nokoyi noñeemi pitajonka-wentante.” ");
INSERT INTO cpy_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ikantzi Jesús: “Tema kaari-pero-shireri eerokapaeni, osheki pitheenkakiri Tajorentsi pikoyi piñeena notajonka-wentante. Eeromaeta nomatziro, apatziro piñeero awijimo-takiriri paerani Kamantan-taniri Jonás. ");
INSERT INTO cpy_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tema iniyakiri antari omani, okaatzi mawa kiteejeri eejatzi mawa tsireniri ijeekaki imotziki. Aritaki ikantee-yaari irika Itomi Atziri ikitawita-paentyaa kepatsiki okaate mawa kiteejeri eejatzi mawa tsireniri. ");
INSERT INTO cpy_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Paata aririka raminakoe-teero okaatzi ranteetziri, aritaki riyakowenteemi Naana-weni-jatzi, tema ikemijantakiri paerani rirori Jonás, ipakaa-neero rantayi-tziro kaari-perori. Tema irika jeekimo-takimiri eeroka-paeni rawijiri Jonás. ");
INSERT INTO cpy_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Paata aririka raminakoe-teero okaatzi ranteetziri, aritaki iyakowenteemi tsinani pinkatha-wotatsiri paerani kirinkanta, tema opokaki paerani roori ijeekira yotaniri pinkathari Salomón, okemijantakiri. Tema irika jeekimo-takimiri eeroka rawijiri Salomón.” ");
INSERT INTO cpy_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Tema okimiwi-takawo ijeeka-shire-tantyaarimi peyari apaani atziri, ipankotakawo rañaa-mento. Aririka rookawi-teeta-kyaari, etsiyata-kowitaa atziri. Jatanaki peyari ikinawaete ochempi-mashiki, tee iñee jempe ijeeki. ");
INSERT INTO cpy_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ari ikanta-shiretee peyari: ‘Nopiyeeta nopankoki jempe nopoñaaka.’ Piyapaa peyari, iñaapaa-tziiro kameetha opishitaka ishire atziri, owaneenkataka, tekatsi jeekant-yaawoni. ");
INSERT INTO cpy_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Riyaata-shita-nakiri maperotzirori ipeyaritzi, ikantakiri: ‘Jame aate nopankoki, pitsipa-tena apinkatharite.’ Ramaki ikaatzi 7 peyari. Aritaki rashironkaa-pero-tyaari atziri, awijanakiro rashironkaawita paerani. Aritaki pikantee-yaari eerokapaeni.” ");
INSERT INTO cpy_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eekiro ikenkitha-takaa-tziiri Jesús atziri-paeni piyowenta-kariri, areetapaaka riniro otsipatakari rirentzi-paeni, okatziya-paaka jantakiroki, okaemakaan-tapaakiri. ");
INSERT INTO cpy_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ikantawi-teetakari Jesús: “Ari opoki piniro otsipatari pirentzi-paeni, okoyi oñeemi.” ");
INSERT INTO cpy_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Rakanaki Jesús, ikantzi: “¿Otzimikama noninrotari, itzimika nirentzitari?” ");
INSERT INTO cpy_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Rookota-nakiri ikaatzi riyotaa-piintakiri, ikantzi: “Irikapaeni riitaki nokimitakahaari yeeyi, rootaki nokimitakahaari nonaanate. ");
INSERT INTO cpy_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tema ikaatzi antaneerori ikoyiri Ashitanari Inkite-jatzi, riitaki nirentzi-taari, rootaki notsiro-taari eejatzi noniron-taari.” ");
INSERT INTO cpy_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Roojatzi rawijantanaka Jesús ijeekawi-tapaaka pankotsiki, ikinanaki inkaari-thapyaaki. Ari ijeekapaaki. ");
INSERT INTO cpy_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ari ipiyowenta-paari osheki atziri. Ari rote-tanakari rirori pitotsiki, jeekapaaki. Katziyee-yakani atziri-paeni inkaari-thapyaaki. ");
INSERT INTO cpy_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Roshiya-kaawenta-tziiniri okaatzi ikenkitha-takaeriri, ikantziri: “Eenitatsi pankiwae-rintzi jatatsiri ipankiwaete. ");
INSERT INTO cpy_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ikanta rookaki-takiro iwankiri, eenitatsi ookakita-paenchari awotsiki, ipokapaaki tsimereeriki, rowapaakawo. ");
INSERT INTO cpy_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Eenitatsi otsipa ookakita-paenchari omapi-pookitzira tee otzima-perotzi kepatsi, intsipaete oshooka-witanaka. Tee otonta-patha-tzi kepatsi, ");
INSERT INTO cpy_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","jampiya-shitanaki pankirentsi ishintsi-tapaakira ooryaa, tema tee otzima-perotzi oparetha. ");
INSERT INTO cpy_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eenitatsi otsipa ookakita-paenchari kitochee-mashiki, anaanakiro kitochee oshookanaki, kamanaki pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Rooma otsipa ookakita-paenchari okameetha-pathatzira kepatsi, kameetha oshookanaki, kithoki-tanaki maawoeni. Tzimanee okithoki shookapaen-tsiri. Apaani tzima-pero-teentsiri okithoki, otsipa ari oshekineentzi okithoki, otsipa eepichokiini okithokitzi. ");
INSERT INTO cpy_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Koyirori ikemathatero, ikemijante.” ");
INSERT INTO cpy_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ari rojampi-tanakiri riyotaani, ikantziri: “¿Iitaka poshiya-kaawentan-tanariri atziri-paeni pikenkitha-takaeriri?” ");
INSERT INTO cpy_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rakanaki Jesús, ikantzi: “Ishinetee-takimiro eeroka piyotako-teero ipinkathari-wentantee Inkite-jatzi, riima irikapaeni tee ishinetee-tziniri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ikaatzi otzimimo-takiri, aritaki otzimimo-pero-teeri. Riima kaari otzimimotzi, imaperoeteeri raapithee-teeri okaatzi tzimimo-witariri. ");
INSERT INTO cpy_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rootaki noshiya-kaawentan-tawori okaatzi nokenkitha-tziri, aritaki raminawityaa irikapaeni, eero iñiimaetawo. Ari ikemawi-tyaawo, eero ikematha-tawakiro nokanta-witariri. ");
INSERT INTO cpy_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Riitaki ikenkitha-takotakiri paerani Kamantan-tanirini Isaías, ikantaki: Pikemae-yawit-yaani, eeromaeta pikematha-tziro. Paminee-yawit-yaani, eeromaeta piñiiro. ");
INSERT INTO cpy_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ikijoshiretee irikapaeni. Imatayempitayitee. Imawityaaki-yitee. Rootaki eero ikowichaa-tanta, Eero ikemi, Eero ikenkishiryaa, Tema eero ikemijantee, eero rawijakotee eejatzi. ");
INSERT INTO cpy_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Rooma eerokapaeni pikimo-shire-wenteero poki eejatzi pikempita, tema aminawaeteemi, pikemayi-teero eejatzi. ");
INSERT INTO cpy_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Rootaki ikowawi-takari paerani Kamantan-taniri-paeni eejatzi kameethashireri-paeni iñiiromi okaatzi piñaakiri, okaatzi pikemayi-teeri eejatzi eerokapaeni. Teemaeta ikemaeyironi rirori. Omaperotatya.” ");
INSERT INTO cpy_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pikemi nokaman-temiro noshiya-kaawentakiri pankiwae-rintzi. ");
INSERT INTO cpy_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Eenitatsi kemirori nokenkitha-takotziro ipinkathari-wentantee Tajorentsi, teemaeta ikematha-tziro. Aritaki ipokaki Kaari-perori, roka-kaapaakiri ikemijantawita. Riitaki oshiyakawori ookakita-paenchari awotsiki. ");
INSERT INTO cpy_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Eenitatsi thaamentawakawori iñaani Tajorentsi, ikemijantzi intsipaete owakira ikemawakiro. Riitaki oshiyakawori ookakita-paenchari omapi-pookitzira. ");
INSERT INTO cpy_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tee riyotako-pero-tawakiro iñaani Tajorentsi, tee reshiwentanakiro ikemaatsi-wenta-nakawo ikemijantzi, rooka-nakiro. Roshiyakawo pankirentsi jampishi-teentsiri kaari tzimapero-tatsi oparitha. ");
INSERT INTO cpy_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Eenitatsi kemirori iñaani Tajorentsi, roo kanteencha osheki iñaamatawo ithaamenta-waeta, ikenkishiryaa-kotawo rashaahawo, rootaki ipeyako-tanta-kawori iñaani Tajorentsi, tee ikemijantzi. Roshiyakawo ookakita-paenchari kitochee-mashiki, kaari kithoki-tatsini. ");
INSERT INTO cpy_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eenitatsi itsipa kemirori iñaani Tajorentsi, ikemijanta-nakiro. Ikyaaryoo-wenta-nakiro. Riitaki oshiyakawori pankirentsi shookapaen-tsiri okameetha-pathatzira kepatsi, osheni-pero-tanaki okithoki, otsipa oshenineentzi, otsipa eepichokiini okithoki-tanaki.” ");
INSERT INTO cpy_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Rapiitakiro Jesús roshiya-kaawentziniri, ikantzi: “Iroka oshiyari eejatzi ipinkathari-wentantee Inkite-jatzi, oshiyari atziri pankitzirori kameetha-kiri pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ikanta imahaeyini tsireniriki aminako-wentzirori, pokaki ijaneentani ramaki inchashi, ipankitapaentziro itsipataakiro pankirentsi, piyanaka. ");
INSERT INTO cpy_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Okanta oshookanaki pankirentsi, kithoki-kitanaki. Ari okimitakari eejatzi inchashi itsipatee-takirori pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ikanta iñaakiro rompera-teetani, ikamantakiri ashitawori, ikantakiri: ‘Teera okameethatzi okithoki pankirentsi apankitakiri powaneki, ¿iitaka tsipataa-kirori inchashi?’ ");
INSERT INTO cpy_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantanaki ashitawori rowane: ‘Riitaki pankita-kirori kijaneentanari.’ Ikantzi romperatani: ‘¿Pikoyi niyaate nothoka-yiteero?’ ");
INSERT INTO cpy_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ikantzi ashitawori: ‘Eero, pithoka-kotzirokari pankirentsi. ");
INSERT INTO cpy_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ari okantawakaata otsipat-yaawo oshooki, roojatzi ojampatan-takyaari pankirentsi. Aripaete nokantemi: Pichekiro inchashi, pitayiro. Powiiki-teero pankirentsi, powakoyi-teero.’” ");
INSERT INTO cpy_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ari rapiitakiro Jesús roshiya-kaawentziro ikenkitha-tziri, ikantzi: “Iroka ikanta ipinkathari-wentantee Inkite-jatzi, roshiyakari pankitzirori oryaani-kitatsiri okithoki. ");
INSERT INTO cpy_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tema oryaani okantawita okithoki, aririka oshookanaki, awijanakiro otsipa iwankiri rowaneki, antawo otewatanaki, aritaki imenkoshi-yityaari tsimereeriki-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Rapiitakiro roshiya-kaawentziro Jesús ikenkitha-takaan-tziri, ikantzi: “Iroka ikanta ipinkathari-wentantee Inkite-jatzi, roshiya-kotawo tsinani amiroka-patha-tzirori ratanteetari. Aakotakiro pankirentsi-pane okaatzi mawa pachakaki, owaetakiro shineya-kaerori, roojatzi oshineyan-tanakyaari maawoeni opatha.” ");
INSERT INTO cpy_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ari ikanta-piinta Jesús ikenkitha-takaeri atziri-paeni okaatzi riyoteeriri. Eerorika otzimi kenkitharentsi tekatsira riyoteeriri. ");
INSERT INTO cpy_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ari omonkaatari ikantakiri paerani Kamantan-taniri ikenkitha-takotziri Tajorentsi, ikantaki: Noshiya-kaawenta-tyeeniri atziri-paeni okaate nokenkitha-teniriri. Niyotahaeri kaari riyowita paerani owakira owetsikan-takari kepatsi roojatzi nimaeka. ");
INSERT INTO cpy_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ikanta rowetha-tanaari Jesús ikaatzi piyowenta-kariri, kyaapaaki pankotsiki. Ipiyowenta-paakari riyotaani, ikantziri: “Piyoteenawo okaatzi poshiya-kaawentakiri. ¿iitakama oshiyakaa-wentari inchashi itsipatee-takirori pankirentsi ipankitee-tziro?” ");
INSERT INTO cpy_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ari rakanaki Jesús, ikantzi: “Irika Itomi Atziri riitaki oshiyariri pankita-kirori pankirentsi rowaneki. ");
INSERT INTO cpy_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Rooma owaantsi rootaki oshiyawori kepatsi ajeekantari. Rooma pankirentsi oshiyakaa-wentari ikaatzi ipinkathari-wenteeri Tajorentsi. Rooma inchashi oshiyakaa-wentari ikaatzi rashiyitari Kaari-perori. ");
INSERT INTO cpy_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Riima kijaneenan-taniri pankita-kirori inchashi roshiya-kaawentari Kamaari. Rooma rowiiteetziro okithoki pankirentsi, oshiyakaa-wentawo othonkanteeyaari paata kepatsi. Ikaatzi owiiteeroni okithoki pankirentsi roshiya-kaawentari ronampiripaeni tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Piñaakiro jempe ikantee-takiro ithokae-takiro inchashi, rahaeta-nakiro itahaetziro. Oshiyakaa-wentawo jempe ikantee-teero paata kepatsi aririka othonkaeyaa. ");
INSERT INTO cpy_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Rotyaanteeri Ronampiri tajorentsite Itomi Atziri, ipiyoteeri kaaripero-yitatsiri, eejatzi kaaripero-shire-takaeriri itsipa, eero itsipataari ikaatzi ipinkathari-wenteeri Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Rookaeri jempe opaamataki tahaantsi. Ari riraawae-teeyaa, ratsikae-kiwaetyaa. ");
INSERT INTO cpy_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Riima kameetha-shire-yiteen-tsiri ijeekimo-teeri Ashitariri jempe ipinkatharitzi, ari ishipakiryaahae roshiyee-yaari ooryaa. Koyirori ikemathatero, ikemijante.” ");
INSERT INTO cpy_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rapiitakiro Jesús, ikantzi: “Iroka ikanta ipinkathari-wentantee Inkite-jatzi, roshiya-kotari koriki romanee-tziri owaantsiki. Eenitatsi atziri ñaakiriri, tee okantya raanakiri, eejatzi romananeeri, tekatsi ikamante. Antawo ikimo-shire-wenta-nakiri koriki, jataki ipimantziro okaatzi tzimimo-tziriri, ramanantakiro owaantsi.” ");
INSERT INTO cpy_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ikantzi eejatzi Jesús: “Iroka ikanta eejatzi ipinkathari-wentantee Inkite-jatzi, roshiyari kowatsiri ramanante riiperori poreryaari. ");
INSERT INTO cpy_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iñaaki riiperori poreryaari, ikowaki ramananteri. Piyaa inampiki, ipimanta-paakiro okaatzi tzimimo-tziriri, ramanantakiri poreryaari.” ");
INSERT INTO cpy_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ikantaki eejatzi Jesús: “Iroka ikanta eejatzi ipinkathari-wentantee Inkite-jatzi, roshiyari pashikaawaetatsiri. Raaki osheki inashiyitachari shima. ");
INSERT INTO cpy_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Inoshika-kotakiri othapyaaki, riyoshiitakiri kameetha-tatsiri roteyitakiri kantziriki. Ikaatzi kaari kameetha-tatsini, rookayi-takiri. ");
INSERT INTO cpy_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Aritaki okantee-yaari paata aririka othonkateeyaa kepatsi. Ipokaki ronampiripaeni tajorentsi, riyoshii-teeri kameetha-shireri eejatzi kaari-pero-shireri. ");
INSERT INTO cpy_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Rookaeri kaari-pero-shireri jempe opaamataki tahaantsi, ari riraawae-teeyaari, ratsikae-kiwae-teeyaa.” ");
INSERT INTO cpy_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ari ikantzi Jesús: “¿Pikematha-takiro okaatzi nokantakiri?” Ikanteeyini riyotaani: “Nokematha-takiro.” ");
INSERT INTO cpy_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eekiro ikantana-kitzii Jesús: “Noshiya-kaawenteri ipaapate-teetari tzimatsiri rashaahawo pinapero-tachari. Tema raapiintzi paejato rashaahawo, raapiintzi eejatzi owakirari. Ari ikantyaari eejatzi yotaantaniri-paeni ipinkathari-wenteeri Inkite-jatzi, riyotaan-teero okaatzi etawori riyotaan-teetziro paerani, riyotaan-teero eejatzi owakira-tatsiri.” ");
INSERT INTO cpy_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ikaatakiro Jesús roshiya-kaawentakiro okaatzi ikenkitha-takotakiri, awijanaki. ");
INSERT INTO cpy_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Areetaa inampiki. Riyotaan-tapae ipiyota-piinteetaha. Ipampoyeeyanakirini ikaatzi kemiriri, ikanteeyini: “¿Iitaka matakaa-kiriri irika riyotani-tantari, itajonka-wentantaki eejatzi? ");
INSERT INTO cpy_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Kaarima itomi kemitzirori incha-kota? ¿¿Kaarima otomi María? ¿Kaarima rirentzi Jacobo, José, Simón, eejatzi Judas? ");
INSERT INTO cpy_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Kaarima atsipatari ritsiro-paeni jaka? ¿Jempema raakiroka okaatzi riyotani-tantakari?” ");
INSERT INTO cpy_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tema osheki itheenkaetakiri, ikijaneentee-tanakiri. Rootaki ikantan-tanakari Jesús: “Ashi oyiro tee ipinkatha-teetziri Kamantan-taniri inampiki eejatzi ipankoki rirori. Rooma otsipaki nampitsi, osheki ipinkatha-teeteri.” ");
INSERT INTO cpy_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tema osheki itheenki-matee-takiri Jesús inampiki, rootaki kaari imatantawo itajonka-wentante. ");
INSERT INTO cpy_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ikanta pinkathari Herodes, ikemako-takiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ikantakiri romperatani: “Irika Jesús riitakira Juan omitsiryaantaniri. Riitaki añahaatsiri, rootaki otzimantari itajorenka.” ");
INSERT INTO cpy_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tema riitaki Herodes aakaan-takiriri ketziroini Juan, roojota-kaantakiri, romonkyaa-kaantakiri, okantakaan-tziro Herodías iinanta-witari Felipe, rirentzi rirori. ");
INSERT INTO cpy_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tema ikaminaa-witatyaari paerani Juan irika Herodes, ikantawitari: “Tee okameethatzi payiteri iina pirentzi.” ");
INSERT INTO cpy_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ari ikowawitaka Herodes rowamaa-kaanteri, roo kanteencha osheki ithaawan-takari atziri-paeni, tema riyoteeyini atziri-paeni Kamantan-taniri irika Juan. ");
INSERT INTO cpy_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Okanta paata, rootaki kiteejeri roemoshirenka-witawo itzimantari Herodes. Ipiyotee-yakani isheninka, roemoshirenkaeyani. Ari opokapaaki ishinto Herodías, omampaa-paaka. Osheki okameetha-tzimo-takiri Herodes. ");
INSERT INTO cpy_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ikantakiro: “Eenitatsi-rika pikowako-tenari, aritaki nopakimiro. Omaperotatya, riyotzi Tajorentsi eero namatawi-tzimi.” ");
INSERT INTO cpy_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tema iyotaakiro iniro jempe okante. Rootaki okantan-takariri: “Nokowakiro pipenawo iito Juan omitsiryaantaniri, powakinawo pachaka-shetakiki.” ");
INSERT INTO cpy_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ari rowashiretako-tanakari Herodes, tee ikowawita. Roo kanteencha, tema ikemaeya-kirini inkaahanki isheninka ikantakirori, ikantanakiri romperatani-paeni: “Pamakiniro okowakiri ewankawo.” ");
INSERT INTO cpy_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ithatyee-takiri Juan janta omonkyahaetakirinta. ");
INSERT INTO cpy_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ramakoe-takiro iito pachaka-shetakiki, ipakiro ewankawo, aanakiniro iniro. ");
INSERT INTO cpy_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ikanta ipokaeya-paakini riyotaani Juan, ikitateeri. Jateeya-nakini ijeekira Jesús, ikamantapaakiri. ");
INSERT INTO cpy_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ikanta ikemako-takiri Jesús rowamanteetakariri Juan, otetanaka pitotsiki, riyaate ijeekawaete janta. Roo kanteencha ikemaeyakini atziri-paeni jempe riyaate, royaatzishi-tanakiri ikineeya-nakini awotsiki. ");
INSERT INTO cpy_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Roo raatako-tapaa-kitziini Jesús, iñaapaa-tziiri osheki oyaawenta-kariri. Retako-tapaakari, retsiyatakotakiri osheki mantsiyari. ");
INSERT INTO cpy_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Okanta otsireniityaanaki, ipokapaaki riyotaani, ikantziri: “¡Yotaanari! Ajeekatziira ochempi-mashiki, tema tsireniityaaki. Pikaatero pikenkithatzi, riyaateeta atziri-paeni nampitsiki ramanante royaari.” ");
INSERT INTO cpy_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ari rakanaki Jesús, ikantziri: “¿Iitakama ratsipe-tantyaawori riyaayitee? Pipiri eeroka royaari.” ");
INSERT INTO cpy_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ikantzi riyotaani: “Tekatsi nopiriri naaka apatziro otzimi 5 ratanteetari eejatzi apite shima.” ");
INSERT INTO cpy_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikantzi Jesús: “Pamakinari.” ");
INSERT INTO cpy_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Opoñaashita ikantakiri maawoeni atziri-paeni ijeekaeyini katawoshi-mashiki. Raakiro ratanteetari eejatzi shima, aminanaki inkiteki, ramanakotakawo. Itzimpetowakiro, ipayitakiri riyotaani, rowawijaa-kiniri rirori atziri-paeni piyoteen-chari. ");
INSERT INTO cpy_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tema maawoeni rowaeyakani, kemaneentee-yakani. Rowiiteero okaatzi tzimakaan-taneen-tsiri, roteyiteero okaatzi 12 kantziri jahaachari. ");
INSERT INTO cpy_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kimitaka ikaatzi 5000 shirampari-paeni owahaen-chari, teemaeta riyoteetzi jempe-rika okaatzi tsinani-paeni eejatzi eentsi-paeni owaenchari. ");
INSERT INTO cpy_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Opoñaashita ikantaneeri Jesús riyotaani: “Peteeyaawo pimontyahae intatsikiro.” Rowetha-yitawaari eejatzi ikaatzi piyowenta-kariri, ikantawaeri: “Kantacha piyaayitee nimaeka.” ");
INSERT INTO cpy_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ikanta ithonkakiri rowetha-tawaari atziri-paeni, tonkaanaki Jesús ochempiki ramana. Ari ijeekakiri rirori tonkaariki ramana roojatzi otsireni-tanta-nakari. ");
INSERT INTO cpy_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Roweyaako-teeyakani riyotaani-paeni niyankyaani inkaari, antawo otamakaatanaki inkaari, tema itonkiyo-takityaawo tampyaa. ");
INSERT INTO cpy_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Okanta okiteje-tzimataki, ipokashi-teeri Jesús riyotaani-paeni ranashi-tantaawo inkaari. ");
INSERT INTO cpy_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ikanta iñaawaeri riyotaani ranashi-tantaawo inkaari, tee riyotawaeri, ithaawan-tawakari, ikaemae-yanakini, ikantzi: “¡Kaakitaki peyariwé!” ");
INSERT INTO cpy_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Roo kanteencha, iñaanata-paeri Jesús riyotaani-paeni, ikantziri: “Naaka pokaatsi, pitonta-shiretzi eero pithaawan-tashitana.” ");
INSERT INTO cpy_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ari rakanaki Pedro, ikantziri: “Nowinkatharite, eeroka-rika, pikanta-kaeyaawo nanashi-tantyaawo naaka inkaari notonkiyo-tantawae-miri.” ");
INSERT INTO cpy_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ikantzi Jesús: “Pipokanaki.” Ayiitanaki Pedro, ranashi-tanta-nakawo inkaari jataki ijeekakira Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Roo kanteencha, ikenkishiryaanakawo Pedro antawo-paeni otamakaatzi inkaari, ithaawan-tanakawo, tsitsiyanaki. Ari ikaemanaki, ikantzi: “Pinkathari, paawaena.” ");
INSERT INTO cpy_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rakotashi-tanakiri Jesús, roteeya-waeri. Ikantziri: “Eepichokiini pawentaana. ¿Iitaka pikijo-shire-tantari?” ");
INSERT INTO cpy_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ikanta rotetee-yapaani pitotsiki, awijeen-katanaki tampyaa. ");
INSERT INTO cpy_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tema antawo ipinkatha-tanakiri ikaatzi oteteen-chari pitotsiki, ikantee-yirini: “Omapero-tatyaa eeroka Itomi Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Areetee-yakani intatsikiro, ojeekira nampitsi iiteetziri Piyompishaari. ");
INSERT INTO cpy_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tema riyotawakiri atziri-paeni ikaatzi nampitawori janta riitaki Jesús, ikamantakiri maawoeni atziri jeekatsiri janta, ramayita-paakiniri ikaatzi mantsiya-yitatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ikantee-takiri Jesús: “Pishineteri mantsiyari-paeni rantawakiro eepichokiini opatzi-kaaki pithaari.” Tema ikaatzi antzita-kiriri iithaari Jesús, etsiyata-koyitee. ");
INSERT INTO cpy_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ikanta Inashitantaniri-paeni eejatzi Yotaantaniri-paeni poñaayi-teenchari Aapatziyaweniki, rojampi-tanakiri Jesús, ikantziri: ");
INSERT INTO cpy_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“¿Iitaka kaari imatantawo piyotaani-paeni okaatzi ameyitari aakapaeni riyotahaeri awaejatziteni? Tema tee ikiwaakota aririka rowaeyaani.” ");
INSERT INTO cpy_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Rakanakiri Jesús, ikantziri: “¿Iitakama pipiyatha-tanta-wori eeroka Ikantakaantani Tajorentsi, apatziro poetziñaarikotawo okaatzi riyotahaeri paerani awaejatziteni? ");
INSERT INTO cpy_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Iroka ikantzi Tajorentsi: Pipinkatha-teeri pipaapate eejatzi piniro. Ikantaki eejatzi: Ikaate yakaterini ipaapate eejatzi riniro, otzimatyee rowamahaeteri. ");
INSERT INTO cpy_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Roo kanteencha, pikanta-piinteeyini eeroka: ‘Kameetha-tatsi akanteri ashiteeri: “¡Pawa! Nashita-kaakari Tajorentsi maawoeni noorikite, eero okanta noneshironkatemi.” ’ ");
INSERT INTO cpy_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tema piyotaa-shitakari okaatzi rameteetari paerani, tee piyotaan-tziro ikoyiri Tajorentsi. Rootaki kaari ineshironka-tantaari asheninka-paeni ipaapate. Piñaakiro. ");
INSERT INTO cpy_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tema eeroka owapeyi-motan-taniri. Eeroka ikenkitha-takotakiri paerani Isaías, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ipinkatha-tashitana ipaanteki atziri-paeni, Teemaeta ikenkishiryaa-kotana kameetha. ");
INSERT INTO cpy_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aminaashita rotziwerowayita ipinkathatana, Riyotaan-tashi-takawo rameyitari rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ikaemakiri Jesús maawoeni piyowenta-kariri, ikantziri: “Powayempi-tayityaa, pikematha-tantenari: ");
INSERT INTO cpy_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tema ikaatzi owayitari tee rowaaripero-shire-tantzi, rooma okaatzi añaawae-yitziri, rootaki owaaripero-shire-tanta-tsiri.” ");
INSERT INTO cpy_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ikanta riyotaani-paeni Jesús ipokashi-tapaakiri okaakiini, ikantapaakiri: “Teera inimotziri Inashitantaniri-paeni ikemakimi pikantaki.” ");
INSERT INTO cpy_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ikantanaki Jesús: “Aritaki ithokaero Ashitanari Inkite-jatzi maawoeni pankirentsi kaari ipankitzi rirori. ");
INSERT INTO cpy_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pamina-minthata-shityaari. Tema roshiya-tyaari apaani mawityaakiri akathata-wakaa-chari. Aririka rakathata-wakaeyaa mawityaakiri, tee riyotzi jempe ikini, tema apitekiro rotetee-yaani omooki.” ");
INSERT INTO cpy_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ikantzi Pedro: “Piyoteenawo okaatzi poshiya-kaawentakiri.” ");
INSERT INTO cpy_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikantzi Jesús: “¿Pimatzi-takama eeroka-paeni tee otzimimo-tzimi piyotani? ");
INSERT INTO cpy_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tema piyotzi okaatzi owapiintari okini asheetoki, roojatzi oshitowan-teeyaari? ");
INSERT INTO cpy_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Roo kanteencha aririka añaawae-yitero kaari-perori akenkishiryaari, rootaki owaaripero-shire-tanta-tsiri. ");
INSERT INTO cpy_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tema ashireki akenkishiryaa-yitawo kaari-perori, owamaan-taantsi, mayempi-taantsi, kaari kinataantsi, koshitaantsi, theeyako-taantsi, kijima-taantsi. ");
INSERT INTO cpy_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rootaki owaaripero-shire-tanta-tsiri iroka-paeni. Rooma eerorika akiwaakota aririka oyaa, tee owaaripero-shire-tantzi roori.” ");
INSERT INTO cpy_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ikanta rawijanaki Jesús, jataki janta Mapiniki eejatzi Shimaaki. ");
INSERT INTO cpy_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ari oshiyashi-tawakari Owinteni-jato nampitawori janta, okaemapaaki roori, okantziri: “¡Pinkathari, Ikashiyakaetani pinkatharini David. Nokoyi pineshironkatena! Tema maperotaka nishintyo okemaatsi-waeta raahashiretziro peyari.” ");
INSERT INTO cpy_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Te rakiro Jesús. Ari ipokapaaki riyotaani, ikantapaakiri: “Potyaanteero, osheki oñaashirenkakae okaema-kaematzi oyaatakaera.” ");
INSERT INTO cpy_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ari rakanakiro Jesús, ikantzi: “Apatziro rotyaantee-takina noneshironka-teeri nosheninka Israel-paeni oshiyakariri ipireetari ipeyawae-yitaka.” ");
INSERT INTO cpy_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari otziwerowa-shita-nakari Jesús iroka tsinani, okantanakiri: “¡Pinkatharí, pineshironkatena!” ");
INSERT INTO cpy_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ari ikantzi Jesús: “Tema tee aapithatziri rowanawo eentsite apiri otsitzi royaawo.” ");
INSERT INTO cpy_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akanakiri roori, okantziri: “Omaperotatyaa pikantakiri Pinkatharí. Roo kanteencha, rowapiintawo otsitzi okaatzi rowaryaapetokeerikitziri ashitariri.” ");
INSERT INTO cpy_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Eekiro ikantana-kitziiro Jesús: “¡Tsinaní, omaperotatyaa pawentaakina! Rootaki nomatan-tyaawori pikowako-takinari.” Apathakirotanaa etsiyata-kotanee ishinto. ");
INSERT INTO cpy_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ikanta rawijanaki Jesús, ikinanaki inkaari-thapyaaki jeekatsiri Tepoweniki. Opoñaashita itonkaanaki ochempiki, ari ijeekapaakiri janta. ");
INSERT INTO cpy_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ari riyaatakiri osheki atziri, ramayitaki inashiyitachari imantsiyanka: ethori-waeta-tsiri, mawityaakiri, kijowaanteri, thatyaaponthori, maawoeni. Ipiyota-kiniri ikatziyakaha Jesús, tema ithonkiri retsiyatakotakaa-yiteeri. ");
INSERT INTO cpy_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ari ipampoyeeyanakirini Jesús iñaawaeta-kahaerira kijowaanteri, etsiyata-koyitee thatyaaponthori, ranashi-takaa-yiteeri kijopookiri eejatzi ethori-waeta-tsiri, raminakaa-yiteeri mawityaakiri. Ikanteeyini atziri: “Omaperotatyaa ikameethataki Itajorentsite Israel.” ");
INSERT INTO cpy_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ipiyotakiri Jesús riyotaani, ikantakiri: “Osheki noneshironka-takiri atziri-paeni, tema okaatzi mawa kitejeri ijeekae-yakini ikemijantana, tekatsi rowaeyaa. Tee nokoyi riyaata-shiteeyaa eero rowanaa, ayiri-kari itashe awotsiki.” ");
INSERT INTO cpy_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ikanteeyini riyotaani: “¿Jempema ayika ratanteetari owakaeyaariri jaka ochempi-mashiki? Osheki ikaateeyini.” ");
INSERT INTO cpy_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ari rojampi-tziri Jesús riyotaani, ikantziri: “¿Jempema okaatzika ratanteetari?” Ikantzi riyotaani: “Eenitatsi okaatzi 7, eenitatsi eejatzi eepichokiini shimaa-niki.” ");
INSERT INTO cpy_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ari ikantanakiri ikaatzi piyoteen-chari ijeekaeyini jaawiki. ");
INSERT INTO cpy_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Raakiro 7 ratanteetari eejatzi shimaa-niki, ramanako-tanakawo. Itzimpetowa-yitakiro, ipayitakiri riyotaani, rowawijaa-kiniri piyoteen-chari atziri. ");
INSERT INTO cpy_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Owaeyakani maawoeni, kemaeyakani. Rowiiteero tzimahaan-tapaen-tsiri, ijaayiteero okaatzi 7 kantziri. ");
INSERT INTO cpy_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ikaatzi 4000 shirampari owaenchari. Tee riyoe-tzi jempe okaatzi tsinani-paeni eejatzi eentsi-paeni owaenchari. ");
INSERT INTO cpy_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ikanta rowetha-tawaari Jesús ikaatzi owaenchari, otetanaa pitotsiki, montyaanaka Pankothanthaariki. ");
INSERT INTO cpy_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ikanta Inashitantaniri-paeni eejatzi Sadoc-paeni, ikowaeyakini ikompita-kaeyaarimi Jesús. Ikantakiri: “Anjatya pitajonka-wentante niyotan-tyaari omaperotatyaa rotyaantakimi Tajorentsi jaka.” ");
INSERT INTO cpy_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Rakanakiri Jesús ikantzi: “Aririka piñeero okityonkaetyee tsirenii-teeni, pikanteeyini: ‘Ooryaa-manaatyee inkaamani.’ ");
INSERT INTO cpy_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Rooma aririka piñeero okitejetamaneerika okityonkaetyee menkori inkiteki, pikantzi: ‘Oparyatyee inkani.’ Tema piyotako-witawo inkite, piyotako-witawo aririka oparii inkani. Teemaeta piyoyitziro okaatzi piñaayi-witakari nimaeka jaka. ");
INSERT INTO cpy_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tee pikameetha-shire-teeya-nitzi eeroka, osheki pitheenkakiri Tajorentsi, pikowashi-teeyani piñeena notajonka-wentante, eeromaeta noñaayimiro. Apatziro piñiiro oshiyaawoni awijimo-takiriri paerani Jonás.” Ipakaakiro Jesús ikantayi-takiri, awijanaki rirori. ");
INSERT INTO cpy_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ikanta rareetee-yakani riyotaani Jesús intatsikiro, tee raanaki ratanteetari, ipeyakota-nakiro. ");
INSERT INTO cpy_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ikantzi Jesús: “Paamaeyaawo shineya-kaerori ratantari Inashitantaniri eejatzi rashi Sadoc-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ikanta-wakahaeyani riyotaani: “¿Iitakama ikantan-teeri Jesús? ¿Rooma ikantan-teeri teera ami ratanteetari?” ");
INSERT INTO cpy_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yotaki Jesús ikanta-wakaari riyotaani, ikantziri: “Tekira poshire-pero-tana eeroka-paeni, rootaki pikenkishiryaa-waetantari, pikanteeyini: ‘Teera ami ratanteetari.’ ");
INSERT INTO cpy_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tekirama pikematha-teeyironi? Chapinki otzimawita ratanteetari okaatzi 5, roo kanteencha nowakaakari ikaatzi 5000 atziri. Powiiteero tzimahaan-tapaen-tsiri. ¿Jempema okaatzika kantziri pijaayiteeri? ");
INSERT INTO cpy_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Eejatzi nokimitakiro kaatatsiri 7 ratanteetari, nowakaakari ikaatzi 4000 atziri. ¿Jempema okaatzika kantziri pijaayi-teeri? ");
INSERT INTO cpy_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Iitakama kaari pikematha-tantawo eeroka-paeni? Teera nokenkithatakotziro owaetari ratanteetari. Tema nokanta-tziimi: ‘Paamaeyaawo shineya-kaerori ratantari Inashitantaniri eejatzi rashi Sadoc-paeni.’” ");
INSERT INTO cpy_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ari riyotanaki riyotaani, teera ikenkithatakotziro Jesús shineya-kaerori ratanteetari, roshiya-kaawenta-tziiro okaatzi riyotaan-tayitziri Inashitantaniri eejatzi Sadoc-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ikanta rareetaka Jesús Cesarea-ki, inampiiteki Filipo. Ari rojampi-takiri riyotaani, ikantziri: “¿Iitakama ikenkishiryaakoe-tariri Itomi Atziri?” ");
INSERT INTO cpy_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Akahaeya-nakini riyotaani, ikantzi: “Eenitatsi atziri kantatsiri, ‘Eeroka Juan Omitsiryaatantaniri.’ Ikantzi itsipa, ‘riitaki koñaataatsi Elías.’ Ikantzi itsipa ‘riitaki Kamantan-tanirini Jeremías.’ Eenitatsi kantayi-tatsiri eejatzi, riitaki itsipa Kamantan-taniri.” ");
INSERT INTO cpy_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ikantzi Jesús: “¿Jempema pikanteeyini eeroka?” ");
INSERT INTO cpy_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ari rakanaki Simón Pedro, ikantzi: “Eeroka Jeepatzii-toetani Itomi Tajorentsi Kañaari.” ");
INSERT INTO cpy_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantzi Jesús: “Eeroka ikimo-shire-wenteete Simón itomi Jonás, kaari atziri yotakae-mironi, riitaki Ashitanari Inkite-jatzi yotakaa-kimirori. ");
INSERT INTO cpy_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Noeteemi Kijori, tema poshiyakawo eeroka kijo-pathari kepatsi, aritaki nowetsikaero nopanko. Ikaate kemijantaa-tsini paata, riitaki oshiyayi-teeyaawoni pankotsi. Eero rotsinampahae-tziri ipeyakaa-shitee-tyaari sharinkaweniki. ");
INSERT INTO cpy_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Poshiyaari aminakowentzirori ashitakowo pankotsi, kantacha rashita-ryeero, rashiteero, rintsiriitero kameetha. Rootakira pankotsi oshiyakaa-wenta-chari ipinkathari-wentantee Inkite-jatzi. Tema ikaatzi pishine-teeri eeroka jaka kepatsiki, riitaki ishineteete inkiteki. Riima kaari pishine-yitee eeroka jaka kepatsiki, eero ishinetee-tziri eejatzi janta inkiteki.” ");
INSERT INTO cpy_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Eekiro ikantana-kitziiri Jesús maawoeni riyotaani: “Paata pikamantantzi, pikante: ‘Riitaki Jeepatzii-toetani irika Jesús.’” ");
INSERT INTO cpy_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ari retanakawo Jesús ikamantziri riyotaani-paeni, ikantziri: “Okowa-perota aate Aapatziyaweniki, tema antawo ikemaatsi-takaena antariperopaeni, reewa-perorite Ompera-tajorentsi-taarewo, eejatzi reewarite Yotaantaniri-paeni, aritaki rowamaa-kaantena. Roo awijawi-takyaa mawa kitejeri añahaana.” ");
INSERT INTO cpy_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ikanta Pedro, raanakiri Jesús inteeneeni, ikantakiri: “Pinkathari, tee inimotana pikantziri, tee nokoyi awijimotemi pikantakiri.” ");
INSERT INTO cpy_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ari ipithoka-pitha-tanakari Jesús irika Pedro, ikantanakiri: “Piyaate Kamaari. Tee poshiretawo eeroka ikowakaanari Tajorentsi, apatziro poshiretawo ikowa-piintziri atziri-paeni.” ");
INSERT INTO cpy_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ikantanakiri Jesús itsipapaeni riyotaani: “Eenitatsi-rika kowatsiri itsipatena, ipakahaero ikowashi-yitari rantero, okantawityaa ikentakoe-terimi, itsipatena. ");
INSERT INTO cpy_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tema ikaatzi etakowae-tachari rantayi-tziro ikowayi-tziri rirori, aritaki ipeyashi-teeyaa. Riima ikaatzi atsipewentawori rantaneero nokoyiri naaka rootaki ikamawentantanari, aritaki rawijakotee. ");
INSERT INTO cpy_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Aminaashi-waeta otzimimo-tantzi ashaahawontsi jaka kepatsiki, aritaki opeyakaa-shitee-yaari. ¿Kantachama ipinako-wenteetya eero ipeyashi-waetanteeta? ");
INSERT INTO cpy_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Aririka ipiyee paata irika Itomi Atziri ramaero rowaneenkawo Ashitariri, itsipatee-yaari ronampiripaeni tajorentsi, riitaki pinatapaeroni okaatzi ranteetakiri. ");
INSERT INTO cpy_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Omapero-tatyaa, eenitatsi pikaatziri jaka, tekiraha pikamiita aritaki piñaakiri Itomi Atziri jempe ikantyaa ipinkathari-wentante.” ");
INSERT INTO cpy_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Okanta awijaki 6 kitejeri, raaneeri Jesús Pedro, Jacobo, Juan rirentzi Jacobo. Tonkaanaki ochempiki. ");
INSERT INTO cpy_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ari ishipakiryaa-wootzi-motakiri riyotaani, roshiya-nakari ooryaa, omatzitanaka iithaari kitamaa-nikitanaki. ");
INSERT INTO cpy_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iñaatziiri Moisés itsipatakari Elías ikenkitha-waeta-kaeri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ari ikaemanaki Pedro, ikantzi: “¡Pinkathari! Omaperotatya okameethatzi pamakina jaka. Kameetha nowetsikimi mawa panko-shetantsi: Apaani pashi eeroka, apaani rashi Moisés, rashi apaani Elías.” ");
INSERT INTO cpy_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iñaawae-mintheetzi, opamanka-paakiri oorenta-chari menkori. Ikematzii iñaawae-teetanaki menkoriki, ikanteetzi: “Notyomi irika netakoperotani, osheki nokimo-shire-wentakiri. Pikemijanteeri.” ");
INSERT INTO cpy_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ikanta ikemaeyakini ikantee-takiri, oeyotee-yanakani jaawiki, antawo ithaawanaki. ");
INSERT INTO cpy_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ari ipokapaaki Jesús, rotzinka-paakiri riyotaani-paeni, ikantziri: “Pikatziye, eero pithaawaeyini.” ");
INSERT INTO cpy_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ari raminawi-tanaari, tekatsi iñaanee, apaniroeni ikatziyaka Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ikanta roerinkae-yaani taapiki, ikantakiri Jesús riyotaani: “Eero pikamantan-tziro piñaakiri roojatzi paata aririka rañahae irika Itomi Atziri ikamawi-takyaa-rika.” ");
INSERT INTO cpy_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Rojampi-tanakiri riyotaani, ikantziri: “¡Iyotaanari! ¿Iitaka ikantako-tziri Yotaantaniri-paeni, ikantzi: “Aririka ipokimataki Jeepatzii-toetani, riitaki jewatapaen-tsini Elías ipoki?’” ");
INSERT INTO cpy_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rakanaki Jesús, ikantzi: “Omaperotatya ikantziri, riitaki jewatapaen-tsini Elías ipoki, itampatzika-shire-tanta-paaki. ");
INSERT INTO cpy_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pikemi nokante naaka: Areewitaka Elías, tekatsi yotawakirini, osheki rowajankitee-takiri. Ari ikantee-teriri Itomi Atziri, osheki rowajankiteeteri rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ari riyotee-yanakini riyotaani riitaki Juan Omitsiryaatantaniri ikenkitha-takotziri. ");
INSERT INTO cpy_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ikanta rareetee-yapaani ipiyoteeyanira atziri. Pokapaaki apaani atziri iñeeri Jesús. Rotziwerowa-shita-paakari, ikantapaakiri: ");
INSERT INTO cpy_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“¡Pinkathari! Pineshironka-teenari notyomi, osheki ikamana-waetzi, antawo ikemaatsi-waetaka, itaawaeta-piintaka, ipiinka-waetzi nijaaki. ");
INSERT INTO cpy_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namawita-kanari piyotaani raawinteenarimi. Teemaeta imatziri.” ");
INSERT INTO cpy_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ari rakanaki Jesús, ikantanaki: “Tee pikemijantee-yanitzi eeroka, pikinashi-waetaka. ¿Jempema okaateka piyote? Pamakiri jaka pitomi.” ");
INSERT INTO cpy_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ikanta ikijawakiri Jesús peyari, rooka-neeri ewankari. Etsiyata-kotanee. ");
INSERT INTO cpy_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikanta riyotaani-paeni Jesús raanakiri inteeneeni, rojampi-tanakiri, ikantziri: “¡Iyotaanari! ¿Iitaka kaari nomatantari naaka notsinampaeri peyari?” ");
INSERT INTO cpy_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikantzi Jesús: “Tema tekira pawentaari kameetha Tajorentsi, rootaki kaari paawyaantari. Pikemi nokante: Okantawityaa eepichokiini pawentee-yaari Tajorentsi, aritaki poshirinkakiro ochempi, pikantero: ‘Pishirinki.’ Aritaki oshirinkanaki. Tema tekatsi kompitzi-motemini aririka pikemijanta-perote. Omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Roo kanteencha, aririka pikoyi petsiya-takota-kaeri oshiyariri irika ewankari, otzimatyee pamanaperotyaa kameetha, pitziwentyaari.” ");
INSERT INTO cpy_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ikanta rareetee-yakani Jesús janta Tepoweniki, rapiitakiri ikantziri riyotaani: “Ipimantee-tatyeeri Itomi Atziri. ");
INSERT INTO cpy_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ari rowamahaeteri. Roo awijawi-takyaa mawa kitejeri, aritaki rañahae.” Antawo rowashiri-tanaka riyotaani-paeni ikemakiri ikantaki. ");
INSERT INTO cpy_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ikanta rareetaka Jesús nampitsiki Capernaum, ari ipokaki shintsi-tatsiri ipaeteri koriki rashita-kaetawori tajorentsi-panko, rojampi-tapaakiri Pedro, ikantziri: “¿Ipinata-piintziro iyoteemiri ikashiya-kaetawori Tajorentsi-panko?” ");
INSERT INTO cpy_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ikantanaki Pedro: “Ipinata-piintziro.” Ikanta ipiyaa jempe ijeekaeyini, riitaki thaawako-tawaencha Jesús rojampi-tawaeri Pedro, ikantziri: “¿Iitaka pikenkishiryaari Simón? ¿Iitaka ishintsi-tziri pinkathari-paeni ipinateri koriki? ¿Riima ishintsitziri isheninka-pero-paeni rirori? ¿Riima ishintsitzi itsipa-jatzi areetzinkari-paeni?” ");
INSERT INTO cpy_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ari rakanaki Pedro, ikantzi: “Riitaki ishintsi-tziri areetzinkari-paeni.” Ikantzi Jesús: “Ari okanta. Tema tee okowa-perota ipinatero isheninkatari rirori. ");
INSERT INTO cpy_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Roo kanteencha, tee nokoyi ikijawaetyaa shintsi-tatsiri ipaeteri koriki. Piyaate inkaariki pakachaate. Aririka pinoshikaki, pamina-paanteteri, aritaki piñeeri koriki. Paanakiniri shintsi-tatsiri ipaeteri koriki. Riitaki pipinawentyaari eeroka eejatzi naaka.” ");
INSERT INTO cpy_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ikanta riyotaani-paeni Jesús ipiyowenta-paakari, ari rojampi-takiri, ikantziri: “¡Yotaanari! Aririka ipinkathari-wentantee Inkite-jatzi. ¿Itzimikama riipero-tatsi itsipatyaari ipinkatharite?” ");
INSERT INTO cpy_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ari ikaemaki Jesús apaani eentsi, ikatziyakiri jempe ijeekae-yakini rirori, ");
INSERT INTO cpy_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ikantziri: “Eerorika pipakahaero jempe pikanta paerani, eerorika poshiyaari jempe ikanta irika eentsi, eero ipinkathari-wenteemi Inkite-jatzi. omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tema ikaatzi tsinampa-shire-tatsini roshiyaari irika eentsi, riitaki riipero-taatsini jempe ipinkatharitee Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ikaatzi aakameetha-teeriri oshiyakariri eentsi rawentahaana, naaka raakameethataki.” ");
INSERT INTO cpy_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Eenitatsi-rika antakaerini kaari-perori oshiyakariri eentsi rawentahaana, okantashimaetya ithatakaeteri mapi ikentsiki, rowiinkae-takiri ocheenkaatzira inkaari. ");
INSERT INTO cpy_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Omaperotatya okowaenkate kepatsiki. Ari itzimaki antakaan-tayiteroni kaari-perori. Ashironkamatsiteeriini antakaan-teroni kaari-perori. ");
INSERT INTO cpy_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rootakirika pako, piitzi pikaaripero-tanta, pipakahaero, pikimita-kaantero pitha-tyaatyee-romi, tema rootaki kameetha-tatsi pawijakoponchokite, tee okameethatzi otzimawita apite pako, apite piitzi, rootaki kantakaan-teemi paata ashi powantee-yaawori pitahaeya. ");
INSERT INTO cpy_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Rootakirika poki pikaaripero-tantari, pipakahaero, pikimita-kaantero pojoryaatyeeromi, tema rootaki kameetha-tatsi pawijako-pityaakitee, tee okameethatzi otzimawita apite poki, rootaki kantakaan-teemi paata rookaeteemi opaamatakira sharinkaweni.” ");
INSERT INTO cpy_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paamaeya pimaninta-waetziri-kari oshiyayi-takariri eentsi. Tema raminakowentani Ronampiri tajorentsi itsipata-piintari Ashitanari Inkite-jatzi. ");
INSERT INTO cpy_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Tema rootaki ipokantari Itomi Atziri rowawijaa-koyiteeri ikaatzi peyawiteen-chari. ");
INSERT INTO cpy_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pikemi noshiya-kaawentemiro. Eenitatsi piratachari ikaatzi 100 ipireetari. Ikanta ipeyahaantaka apaani, ikaatanee 99 ipira. Rookanakiri 99 ipira ochempi-mashiki, jataki ithotyaako-teeri peyeenchari. ");
INSERT INTO cpy_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ikanta iñahaeri, antawo ikimo-shiretee rahaerira peyawiteen-chari, tema awijanakiro ikimo-shire-wentziri itsipa 99 ipira kaari peyachani. ");
INSERT INTO cpy_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ari ikantari eejatzi Ashiteeri Inkite-jatzi, tee ikoyi ipeyahaan-tawaetyaa apaani oshiyakariri irika eentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aririka ikaaripero-tzimotemi kemijantzinkari, piyaata-shiteri ijeekira apaniroeni, ari pikenkitha-waeta-kaeri, riyotan-tyaari oeta ikinakaa-shitakari. Aririka ikemimi pikaminayiriri, poshiya-kaanteeri riimi pirentzi okaakiini. ");
INSERT INTO cpy_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Rooma eerorika ikemimi pikaminaa-witariri, paanaki itsipa kemijantzinkari, eerorika apite, riitaki pitsipa-tyaari pikamineeri. Tema otzimatyee ikaate apite, eerorika mawa riitaki akakotemini pikamineerira. ");
INSERT INTO cpy_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Eerorika ikemimi pikaminaa-witari, pikamanteri maawoeni kemijantzinkari. Eekiro-rika riyaata-kaatyeero, poshiya-kaanteri itsipajatzi atziri kaari pisheninkata, tema roshiyakari shintsi-tatsiri ipaeteri koriki. ");
INSERT INTO cpy_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tema ikaatzi pishine-teeri eeroka jaka kepatsiki, riitaki ishineteete inkiteki. Riima kaari pishine-yitee eeroka jaka kepatsiki, eero ishinetee-tziri eejatzi janta inkiteki. Omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Napiitero nokantemi: Aririka pikaate apite paapatziyakota-wakae-yaawo pikenkishiryaari pikowako-tanteri, opoñaashitya pikowakoteri Ashitanari Inkite-jatzi, aritaki imatakaa-kimiro rirori. ");
INSERT INTO cpy_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jempe-rika ipiyota apite, teerika mawa atziri rawentaana, aritaki nojeekitari naaka janta notsipatari.” ");
INSERT INTO cpy_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ikanta Pedro rojampi-tanakiri Jesús, ikantziri: “¡Pinkathari! Aririka rowaariperotena nokaatzira nokemijanteeyini, ¿jempema okaate nopeyakoteri naripero-tantee-yaariri? ¿Apatziroma okaate 7?” ");
INSERT INTO cpy_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ari rakanaki Jesús, ikantanakiri: “Teera apatziro pipeyakoteri okaate 7, tema osheki papiiteri pipeyako-teeri.” ");
INSERT INTO cpy_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iroka ikanta ipinkathari-wentantee Inkite-jatzi, tema roshiya-kotari pinkathari ikowako-tziri romperatani ipinateeri rireewi-tziri. ");
INSERT INTO cpy_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ikanta retanakawo pinkathari ikowako-tziri ireewitziriri, ramaeta-paakiri ireewi-pero-tatsiri. ");
INSERT INTO cpy_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tema tekatsi rayi ipinakowentee-yaari. Ikantanaki pinkathari: ‘Paanakiri irika atziri, iina, itomi-paeni, eejatzi okaatzi tzimimo-tziriri, pipimanteri. Ari nahaeri naaka koriki ikaatzi rireewi-tanari.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ari rotziwerowanaka omperataarewo, ikantanakiri pinkathari: ‘Eero pipimantana, poyaawen-tawakina eepichokiini, aritaki nopinateemi.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ari ineshironka-tanakiri pinkathari irika romperatani, ikantziri: ‘Kameethataki, tee pireewi-taana.’ Tema ipeyako-takiri okaatzi rireewi-tziriri. ");
INSERT INTO cpy_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ikanta riyaatanee omperataarewo, itonkiyo-takari ireewitziriri rirori eepichokiini. Roteeya-kentsi-tawakiri, ikantziri: ‘Pipinateena pireewi-tanari.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari rotziwerowa-shiwi-tanakari, ikantziri: ‘Poyaawentawakyaa eepichokiini, aritaki nopinateemi.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Teemaeta ikoyi royaawentyaa, raanakiri, romonkyaa-kaantakiri, ikantziri: ‘Aritaki nomishitowa-kaanteemi aririka pipinateena.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iñaakiri ikaateeyini, tee inimota-nakiri, jatanaki ikamantziri iwinkatharite. ");
INSERT INTO cpy_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ikanta pinkathari, ikaemakaan-takiri romperatani, ikantawakiri: ‘Eeroka kaari-perori. Nopeyako-takimiro pireewi-tana eeroka, pikantakina: poyaawenta-wakina.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ari pikantantemi eeroka, pineshironka-tante. ");
INSERT INTO cpy_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tema antawo ikijanaka pinkathari, ipajata-kaantakiri, romonkyaa-kaantakiri, ikantziri: ‘Aririka pipinateena eeroka, aritaki nomishitowa-kaanteemi.’ ");
INSERT INTO cpy_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ari ikanteemiri paata Ashitanari Inkite-jatzi, eerorika pipeyako-teeniri kameetha owaari-pero-tzimiri pikaatzira piyemijantzinkarite.” ");
INSERT INTO cpy_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ari ithonka-nakiro Jesús riyotaantzi Tepoweniki, awijanaki intatsikiro Pareenkaariniki iipatsiteki Judá-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ipiyowentee-tawaari. retsiyatakota-kaapae osheki mantsiyari-paeni janta. ");
INSERT INTO cpy_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ari ipokashi-takiri Inashitantaniri-paeni ikoyi ikompita-kaeyaarimi Jesús, rojampi-tapaakiri, ikantziri: “¡Jesús! ¿Shinetaan-tsita-tsima rookashi-waetyaawo iina atziri?” ");
INSERT INTO cpy_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ari rakanaki Jesús, ikantziri: “¿Tema piñaana-takotziri owakira rowetsikan-teeta-kariri atziri? Tema rowetsikaetaki shirampari eejatzi tsinani. ");
INSERT INTO cpy_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ikanteetaki: Eero ijeekae ewankari ashitariri, rayi iina, Tema apaani ikantaneeyaa iwathaki okimi-tyaawomi rowithaawakaatyeeya. ");
INSERT INTO cpy_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tema ikaatzi aawakaa-naachari teera apite ikantaneeyaa, apaani ikantana iwathaki. Rootaki eero okantanta rookaero atziri iina itsipata-kaakariri Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rapiitakiri Inashitantaniri rojampi-tziri, ikantziri: “¿Iitakama ikantako-tziri paerani Moisés, ikantaki: Aririka rooka-wakaetyaa, otzimatyee ipaeteri jempe ojankina-takota rooka-wakaan-tyaari?” ");
INSERT INTO cpy_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantzi Jesús: “Okantakaawo pipiyatha-waeta, rootaki ishinetan-tzimirori Moisés pookiro piina. Tema paerani owakira rowetsikan-teeta-kawori maawoeni, tee ari okantyaa. ");
INSERT INTO cpy_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nokantzi naaka: Kaaripero-shiretaki ikaatzi ookashi-tawori iina, rooma iñeero-rika omayempitaki kantacha rookiro. Aririka aawiteeyaa roori itsipa oemi, omayempi-tzimo-takiri etawitari oemintari. Ari ikantee-yaari ahaeroni roori, mayempitaki rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ikantzi riyotaani: “Aririka okanta, eero rahaetzimi iinanteetari.” ");
INSERT INTO cpy_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ikantzi Jesús: “Riirika Tajorentsi kowakae-mironi aritaki pikematha-takiro. Teera maawoeni ikematheetziro jempe-rika okantakota aawakahaantsi. ");
INSERT INTO cpy_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eenitatsi atziri ari ikantzita itzimapaaki tee okantya rayi iina. Eenitatsi itsipa raathoki-teetziri, tee okantya rayi iina. Eenitatsi itsipa kowatsiri ijeekashiwaetyaa apaniroeni, tema ikyaaryoo-wenta-tziiri pinkathari-tatsiri inkiteki. Kowatsiri ikemathatero nokantakiri, imatero.” ");
INSERT INTO cpy_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ari ramaeta-paakiniri Jesús eentsi-paeni, ikantee-tapaakiri: “Nokoyi pamana-kotenari neentsite, poteya-patzii-toteri pitajonka-wenteri.” Ikantzi riyotaani Jesús: “Eero poñaashirenkiri Awinkatharite.” ");
INSERT INTO cpy_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ikantzi Jesús: “Eero pikoshekari, nokoyi naaka ramaetenari eentsi. Tema ikaatzi oshiyako-tanaariri eentsi, riitaki ñahaeroni jempe ipinkathari-wentantee Inkite-jatzi.” ");
INSERT INTO cpy_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ikanta ithonkakiri Jesús roteya-patzii-totakiri eentsi-paeni, jatanee rirori. ");
INSERT INTO cpy_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ari ipokapaaki apaani ewankari iñeeri Jesús, ikantapaakiri: “¡Kameethari yotaantanirí!. ¿Iitaka nanteeri ashi nowantee-yaawori nañaahae?” ");
INSERT INTO cpy_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ari rakanaki Jesús, ikantzi: “¿Iitaka pikantan-tanari ‘kameethari?’ Teera itzimi apaani kameethari, apatziro ikantakaawo Tajorentsi ikameethatzi. Pikoyi-rika ashi poyiro pañaahae, pimonkaa-yiteero ikantee-takiri Ikowakaan-teetaniki.” ");
INSERT INTO cpy_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ikowanaki ewankari riyotakotero, ikantziri: “¿Otzimikama pikantziri?” Ikantzi Jesús: Eero powamaantzi. Eero pimayempitzi. Eero pikoshitzi. Eero pitheeya-kotanta. ");
INSERT INTO cpy_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pipinkatha-teeri pipaapate eejatzi piniro. Petakoteeyaari pisheninka poshiya-kaanteri petakota eeroka. ");
INSERT INTO cpy_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ikantzi ewankari: “Nomatakiro maawoeni iroka, roojatzi netanakawo paerani eeniro neentsi-tapaaki. ¿Iitakama koetyaa-chari nimaeka?” ");
INSERT INTO cpy_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ikantzi Jesús: “Pikoyi-rika pitampatzika-shirete, piyaate, pipimantero maawoeni tzimimo-tzimiri, pipiri ashironkaenkari, tema okimiwi-takawo powahaantee-yaami inkiteki. Aririka pimatakiro pipoki, poyaatena.” ");
INSERT INTO cpy_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikanta ikemaki ewankari, owashiretanaka ipiyanaaha, tema ashaahantzinkari rirori. ");
INSERT INTO cpy_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ikantanakiri Jesús riyotaani: “Osheki opomeentsi-tzimo-tyaari ashaahantachari riyaatee ipinkatharitee Inkite-jatzi. Omaperotatya.” ");
INSERT INTO cpy_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Rapiita-nakiro Jesús, ikantzi: “Tema osheki ipomeentsitawo ikyaakoetani ikyaant-yaawo oryaani omoo. Rii maperota-chani ashaahantzinkari ipomeentsi-teeyaawo ikyahae ipinkathari-wentantzira Tajorentsi.” ");
INSERT INTO cpy_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ikanta ikemaki riyotaani-paeni, ari ipampoyeeyanakirini, ikanta-wakahaeyani: “¿Iitakama awijako-taatsini?” ");
INSERT INTO cpy_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ari raminanakiri Jesús riyotaani-paeni, ikantziri: “Eero rotsinampaero atziri-paeni, riima Tajorentsi tekatsi pomeentsi-tzimo-tyaarini rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ari rakanaki Pedro, ikantzi: “Irika nokaateeyini nokoyi noyaatanakimi, tema nookayi-tanakiro okaatzi tzimimo-tanari. ¿Iitaka ipineeteenari paata?” ");
INSERT INTO cpy_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ikantzi Jesús: “Aririka owakiratee paata maawoeni, ipinkatharitee Itomi Atziri ijeekan-teeyaawo owaneenka-tachari ijeeka-mento. Aritaki pikantee-yaari eerokapaeni pikaatzira poyaatakina, pipinkathari-wenteeri maawoeni ikaate icharini-teeyaari Israel, ikaatzira 12 rinashiyitaha. Omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tema eeniyitatsi awentahaanari, rootaki rookanta-nakawori ipanko, rirentzi, ritsiro, ashitariri, iina, reentsite, iipatsite. Aritaki iñahaero otzimimo-teeri osheki, ashi rowaero rañaayitee. ");
INSERT INTO cpy_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Roo kanteencha, eenitatsi nimaeka osheki etayiwi-tawori, riitakira impoetaa-tsini iñaayiteero. Eenitatsi itsipa impoeyi-tatsiri nimaeka, riitakira etayitee-yaawoni iñaayiteero.” ");
INSERT INTO cpy_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Iroka okantakota ipinkathari-wentantee Inkite-jatzi, oshiyariri atziri tzimatsiri ichochoki-mashite. Rananinkanaki ramine antawae-tatsini iwankiri-mashiki. ");
INSERT INTO cpy_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ikanta iñaaki kowatsiri rantawaete, ikantakiri: ‘Petanakyaawo nimaeka pantawaete roojatzi tsireniiteeni, nopinatemi apaani koriki ikaatzi ipinatanta-piinteetziri rantawae-teetzira apaani kitejeri.’ Ikanteeyini antawae-rintzi: ‘Kameethataki.’ Rotyaantakiri iwankiri-mashiki. ");
INSERT INTO cpy_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ikanta ijenokii-tyaapaaki ooryaa eejatzi ipiyanaa ashitawori iwankiri-mashi nampitsiki. Iñaapae itsipa ikatziyeeyani tekatsi rantawaeri. ");
INSERT INTO cpy_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ikantapaakiri: ‘Piyaate pantawaete nowankiri-mashiki, aritaki nopinatakimi okaatzi ipinatanta-piinteetzi.’ Jateeyakini rantawaete. ");
INSERT INTO cpy_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ari ikantakiro itampatzika-tapaaki ooryaa, eejatzi iteenkanaki ooryaa. ");
INSERT INTO cpy_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ari ikantakirori eejatzi otsireniityaanaki, iñaapae atziri ijeekaeyini, tekatsi rantawaeri, rojampi-tapaakiri: ‘¿Tekatsima pantawaeri pijeekawaetashitantari kitejeriki?’ ");
INSERT INTO cpy_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Rakaeya-nakini, ikantzi: ‘Tekatsi antawae-takaenani.’ Ikantzi rirori: ‘Piyaate pantawaete nowankiri-mashiki, aritaki nopinatakimi okaatzi ipinatanta-piinteetzi.’ ");
INSERT INTO cpy_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Okanta otsireni-tanaki, ikantakiri ashitawori iwankiri-mashi kempoyee-niriri iyorikite, ikantziri: ‘Pikaemeri maawoeni antawae-rintzi pipinateri apaani koriki ikaatzi ipinatanta-piinteetzi rantawae-teetzira apaani kitejeri. Riitaki petawakyaa pipinateri impoeta-paentsiri rantawaetzi, roojatzi pimatan-takyaariri etakawori rantawaetaki amaetyaaka.’ ");
INSERT INTO cpy_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ari ipokaeya-paakini impoeta-paentsiri rantawaetaki, eepichokiini rantawae-witaka ipineetakiri apaani koriki. ");
INSERT INTO cpy_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ipokaeya-paakini etakawori rantawaetaki amaetyaaka, roshiya-kaantzi riitaki ipina-peroete. Tema te, ari roshiyakari itsipa-paeni jempe ikaatzi ipineeta-kiriri. ");
INSERT INTO cpy_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ikanta ipinawi-teetakari, ikijanakiri ashitawori rantawaeri, ");
INSERT INTO cpy_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ikantanakiri: ‘Tee rantawae-perotzi impoeta-paentsiri, roo kanteencha imonkaa-takina pipinata-kinari, naaka atsipewi-takariri ooryaa.’ ");
INSERT INTO cpy_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ikantzi ashitawori iwankiri-mashi: ‘Nosheninká, nopinatakimi kameetha, ¿tema nokantzi-takimi amaetyaaka nopinatemi apaani koriki? ");
INSERT INTO cpy_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Irika apaani koriki nopinatzimiri, piyaatee. Tema naaka nintashi-tacha nopinateri apaani koriki impoeta-paentsiri rantawaetzi, ");
INSERT INTO cpy_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Eeroma omata nopinatante nokoyiri naaka? ¿Pikijako-neenta-tyaawoma noneshironka-tantzi naaka?’ ");
INSERT INTO cpy_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tema osheki jewatatsiri iñaayiteero, tema riitaki impoeta-tsini. Eenitatsi osheki impoeyi-tatsiri iñaayiteero, tema riitaki jewatatsini. Tema osheki ikaemawitee, roo kanteencha eepichokiini ikaate riyoshii-teeteri.” ");
INSERT INTO cpy_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ikanta itonkaanee Jesús riyaatero Aapatziyaweniki, riitaki itsipatanaa 12 riyotaani, ikantakiri awotsiki: ");
INSERT INTO cpy_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aatatziira Aapatziyaweniki. Ari raakaan-teeteriri Itomi Atziri, rayiri reewari Ompera-tajorentsi-taarewo, itsipata-kyaari Yotaantaniri, riitaki iyakowenterini rowamahaeteri. ");
INSERT INTO cpy_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Rowawijaa-kiniri itsipa-jatzipaeni atziri rowashiya-mintha-waetyaari, ipajawaeteri, ikentako-takiri. Roo awijawi-takyaa mawa kitejeri, aritaki rañahae.” ");
INSERT INTO cpy_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Okanta iina Zebedeo opokashi-takiri Jesús, otsipatakari otomi-paeni, irika Jacobo eejatzi Juan. Otziwerowa-paaka, okantapaakiri: “Nokoyi pineshironkatena.” ");
INSERT INTO cpy_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ari rojampi-tanakiro Jesús, ikantziro: “¿Iitaka pikowako-tanari?” Okantzi roori: “Tema rooteentsi pipinkatharen-tsite eeroka, nokoyi itsipatemi notyomi ipinkathari-wentante, ijeekimotemi apaani pakoperoki, riima itsipa ijeeki pampateki.” ");
INSERT INTO cpy_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ikantzi Jesús: “Teera piyotziro oeta pikowako-tanari. Tema osheki nokemaatsi-tyaari naaka. ¿Arima pamawe-takiro eeroka okaatzi pikemaatsi-tyaari? ¿Arima poshiya-kina nokami naaka?” Ikanteeyini: “Aritaki nomatakiro.” ");
INSERT INTO cpy_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ikantzi Jesús: “Omaperotatya, tema rooteentsi pikemaatsityaawo okaate nokemaatsi-tyaari naaka. Rooma pitsipa-tenarika apinkathari-wentante pijeeki apaani nakoperoki, itsipa nampateki, teera naaka nintakae-yaawoni itzimi notsipa-tyaari, apatziro riyotzi Ashitanari jempe itzimi ikashiya-kaakiri.” ");
INSERT INTO cpy_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ikanta ikemaeyakini itsipa riyotaani, ikijeeta-nakiri Juan eejatzi Jacobo. ");
INSERT INTO cpy_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ipiyota-neeri Jesús riyotaani-paeni, ikantziri: “Piyoteeyini eeroka jempe ikanta iwinkatharite itsipa-jatzipaeni, osheki rompera-tanta. Ari roshiyari eejatzi riipero-tatsiri ipinkatha-teetziri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Rooma eeroka-paeni, aririka pikoyi piriiperote, poshiya-kotyaari jempe ikanta omperataarewo. ");
INSERT INTO cpy_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Roorika pikoyi peewata-kaante, poshiya-kotyaari ompereetari. ");
INSERT INTO cpy_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tee roo ipokant-yaari Itomi Atziri rompera-tantyaa, roo ipokantakari roshiya-kotyaari ompereetari, ikamawentante, riitaki pinakowentan-tatsini, rookakaa-wenteeri maawoeni.” ");
INSERT INTO cpy_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ikanta rawijee-yanakini Kashiryaariki, osheki atziri oyaatana-kiriri. ");
INSERT INTO cpy_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari ijeeki awotsi-nampiki apite mawityaakiri. Kemaki rirori, ikanteetzi: “Ari ikinapaaki Jesús jaka awotsiki.” Rootaki ikaeman-tanakari, ikantzi: “¡Pinkatharí, Ikashiyakaetani pinkatharini David, pineshironka-teena naaka!” ");
INSERT INTO cpy_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Osheki ikijatha-witee-takari. Tee imaeritzi, eekiro icheraanakitzi ikaemi: “¡Pinkatharí, Ikashiyakaetani pinkatharini David, pineshironka-teena naaka!” ");
INSERT INTO cpy_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Katziya-paaka Jesús, ikaemakiri ikantziri: “¿Iitaka pikoyiri?” ");
INSERT INTO cpy_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikanteeyini rirori: “Pinkathari, nokoyi naminee kameetha.” ");
INSERT INTO cpy_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Antawo ineshironka-tanakiri Jesús irika mawityaakiri, ipampita-kiri rooki. Apathakirotana aminanee kameetha, royaata-nakiri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tema okaakitzi-matapaaki rareetan-tyaari Jesús Aapatziyaweniki. Tema areetee-yakani Chochoki-pankoniki omontetakari ochempi Yeenkae-toni. Ari rotyaantakiri Jesús apite riyotaani, ");
INSERT INTO cpy_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantakiri: “Piyaate nampitsiki amontetakari, ari piñeero othatakotyaa ikyaakoetari otsipata-kyaari iryaani. Pithataryaa-kotapaakiro, pamakinawo. ");
INSERT INTO cpy_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eenitatsi-rika ojampitawakimini, pikantanakiri eeroka: ‘Ikowatziiro pinkathari. Aritaki roepiyeemiro.’” ");
INSERT INTO cpy_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ari omonkaatari rojankina-takiri paerani Kamantan-taniri, ikantaki: ");
INSERT INTO cpy_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pikaman-teero maawoeni Kijakowentoni-jato, pikantero: Awotsikitaki Piwinkatharite ipokashi-takimi, Itsinampa-shiretaki ipokaki ikyaakotaka, Ewonkiri raakahae-tziri tenari. ");
INSERT INTO cpy_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ikanta riyaatanaki apite riyotaani, imatakiro okaatzi ikantawa-kiriri Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ramakiro ikyaakoetari itsipataakiro iryaani. Rowanki-takiniri maathaantsi imitzikaaki, ikyaako-tanakari Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ikanta atziri-paeni jeekaen-tsiri janta, romaanka-shita-nakiri iithaaripaeni awotsiki jempe ikinanaki. Eenitatsi itsipa chekaneen-tsiri inchashi romaanka-shitanakiri rirori. ");
INSERT INTO cpy_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tema ikaatzi atziri jewateen-tsiri, ikaatzi oyaatakiriri itaapiiki, ikaemaeyini, ikantzi: ¡Jame apinkatha-teeri Ikashiyakaetani pinkatharini David! ¡Tajonka-wentantaniri, tema Pinkathari otyaanta-kiriri! ¡Jame apinkatha-teeri Inkite-jatziwé! ");
INSERT INTO cpy_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ikanta rareeta-paaka Jesús Aapatziyaweniki, rojampita-wakaanaka ikaatzi nampitawori, ikanteeyini: “¿Jempema iitaka irika?” ");
INSERT INTO cpy_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tzimatsi kantaneen-tsiri: “Riitaki Jesús, Kamantan-taniri, poñaachari Kashiyakaa-weniki jeekatsiri Tepoweniki.” ");
INSERT INTO cpy_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tema kyaapaaki Jesús tajorentsi-panko, romishitowa-paakiri pimanta-tsiri, eejatzi ikaatzi amananta-tsiri. Rotatsinka-yitapaakiro rowantariri koriki, ari ikimitzitakawo jempe rowaetziri jamomo-paeni. ");
INSERT INTO cpy_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikantapaakiri: “Rojankinee-takiro paerani iñaawaetzi Tajorentsi, ikantzi: Nopanko iroka, aritaki ramana-piinteetena. Roo kanteencha eerokapaeni, aritaki pamatawi-tanta-piintaki pipimantawae-yitzi, poshiya-kaantakiro koshintzi-panko.” ");
INSERT INTO cpy_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ari ipokaeya-paakini tajorentsi-pankoki osheki mawityaakiri, kijopookiri, maawoeni retsiya-takota-kaayi-teeri. ");
INSERT INTO cpy_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tema ipampoyeeyanakironi okaatzi rantakiri Jesús. Ari ikaemae-yanakini eentsi-paeni, ikanteeyini: ¡Jame apinkatha-teeri Ikashiyakaetani pinkatharini David! Roo kanteencha reewarite-paeni Ompera-tajorentsi-taarewo, eejatzi Yotaantaniri, ikijeeya-nakani rirori, tema tee inimotziri. ");
INSERT INTO cpy_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rojampi-teeta-nakiri Jesús, ikantee-tziri: “¿Pikemakiroma ikantee-yirini ewankari-paeni?” Ikantzi Jesús: “Nokemakiri. ¿Tema piñaana-tziro eeroka jankinarentsi? kantatsiri: Riitaki eentsi-paeni eejatzi ikaatzi thotatsiri iteni, Pimatakaakiri ipinkatha-yiteemi.” ");
INSERT INTO cpy_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ari rawijanaki Jesús, ikinanakiro Ashironkaaweniki. Ari imaaki janta. ");
INSERT INTO cpy_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Okanta okitejeta-manee, ipiyaawo Jesús nampitsiki. Ari itasheya-paaki niyanki awotsi. ");
INSERT INTO cpy_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Iñaapaaki awotsi-nampiki pankirentsi, riyaata-shita-nakiro, iñaatziiro tee okithokitzi, iyoshii-tashita oshi. Ikantanakiro: “Ashi powaero eero pikithokitee.” Okanta pankirentsi, kamashi-tanaki. ");
INSERT INTO cpy_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ikanta iñaakiro riyotaani, ari ipampoyeeyanakironi, rojampi-tanakiri, ikantziri: “¿Iitaka okamashi-tanta-nakari pankirentsi?” ");
INSERT INTO cpy_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Rakanaki Jesús, ikantziri: “Omaperotatya nokantemiri, kyaaryoo-rika pawenteena, eerorika pikijo-shire-waetzi, aritaki pimateero eeroka, aritaki awijanakiro jempe okanta piñaakiro pankirentsi. Kantacha piñaanatero ochempi, pikantero: ‘Pishirinki ochempi, pipiinki inkaariki.’ Aritaki omatakyaa. ");
INSERT INTO cpy_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tema okaatzi pikowako-tanteeri pamananiki, aririka pawentaa-nakyaari Tajorentsi, aritaki ipakimiro.” ");
INSERT INTO cpy_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikanta rareetaawo Jesús Tajorentsi-pankoki, riyotaan-tapae. Ari ipokakiri reewarite Ompera-tajorentsi-taarewo, eejatzi antaripero-paeni, rojampi-tapaakiri: “¿Iitaka otyaanta-kimiri poñaahantero pitajorenka?” ");
INSERT INTO cpy_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ari rakanaki Jesús, ikantziri: “Eejatzi naaka eenitatsi nojampi-temiri. Aririka pakakinawo, aritaki nokantakimi iita otyaanta-kinari. ");
INSERT INTO cpy_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tema romitsiryaa-tantaki paerani Juan, ¿Iitaka otyaanta-kiriri? ¿Riima Tajorentsi? ¿Atzirima?” Ari ikanta-wakahae-yanakani: “Aririka akanteri Tajorentsi otyaantakiri, aritaki ikantanakae: ‘¿Iitakama kaari pikemijanantari?’ ");
INSERT INTO cpy_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aririka akante: ‘Atziri otyaantakiri,’ aritaki ikijanakae atziri-paeni.” Tema ikanteeyini atziri-paeni Kamantan-tanirini Juan. ");
INSERT INTO cpy_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ari ikanteeyini: “Tee niyotziro.” Ikantzi Jesús: “Pikimitaka eerokapaeni tee pikoyi pikaman-tenawo, eejatzi naaka eero nokaman-tzimiro iita otyaanta-kinari.” ");
INSERT INTO cpy_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ikantzi Jesús: “¿Jempema okantzi-motzimi eeroka-paeni iroka? Eenitatsi atziri tzimatsiri apite itomi. Okanta paata ikantakiri itomi: ‘Notyomi, piyaate pantawaete pankirentsi-mashiki.’ ");
INSERT INTO cpy_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ikantzi itomi: ‘Tee nokoyi.’ Roo ojamaniityaanaki, opiyimo-taari itomi, jataki rantawaetzi. ");
INSERT INTO cpy_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Opoñaashita ikantakiri itsipa itomi. Ikantanaki rirori: ‘Ari nomatakiro Pawa.’ Teemaeta riyaatzi. ");
INSERT INTO cpy_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Itzimikama itomi antakirori ikowakiri ipaapate?” Ari ikanteeyini: “Riitaki antakirori retakari romperatari.” Ikantzi Jesús: “Rootaki awijeemini ipinkathari-wenteeri Tajorentsi mayempiro-paeni eejatzi shintsita-piinta-tsiri apiri ayorikite rotyaanteniri wirakocha-paeni. Omaperotatya. ");
INSERT INTO cpy_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tema ipokawitaka paerani Juan, ikamanta-witakimi pikameetha-shire-tantee-yaari, roo kanteencha tee pikemijanta-wakiri. Riima ikaatzi shintsita-piinta-tsiri apiri ayorikite eejatzi mayempiro-paeni, okemijantanaki. Piñaawi-takari eerokapaeni, teemaeta pipakaero jempe pikanteeyani, pikemijanan-teeyaariri.” ");
INSERT INTO cpy_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pikemi napiitero noshiya-kaawentemiro: Eenitatsi atziri pankitzirori chochoki-mashi, itanto-takotakiro maawoeni othapiki, rowetsika-shitakiro ikawirinkaaterowa paata, rowetsikaki eejatzi pankotsipenchakii raminakowentantyaawori. Raminaki atziri aminironi iwankiri-mashi. Jataki rirori inteena. ");
INSERT INTO cpy_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Okanta okithoki-paetetaki chochoki, rotyaantaki romperatani rahaate. ");
INSERT INTO cpy_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ikanta antawae-rintzi-paeni aminirori pankirentsi-mashi, iñaawakiri ipokaki omperataarewo, ipajawaetaki apaani, rowamaaki itsipa, ishemyaakiri itsipa. ");
INSERT INTO cpy_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Rotyaantaki itsipa romperatani, osheki ikaatzi. Ari ikimita-wakiri eejatzi rirori. ");
INSERT INTO cpy_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ari roweyaantakawo rotyaantakiri itomi-perori rirori, ikantzi: ‘Aritateekima ipinkatha-tawakiri notyomi naaka.’ ");
INSERT INTO cpy_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikanta iñaawakiri antawae-rintzi ipokaki itomi, ikanta-wakahaeyani: ‘Irika ashitee-yaawoni paata pankirentsi-mashi. Jame owamayiri, ayiroota aaka.’ ");
INSERT INTO cpy_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Roteeya-wakiri, raanakiri othapiki pankirentsi-mashi, rowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aririka ipokanaki ashitawori iwankiri-mashi, ¿jempema ikante-rika antawae-rintzi-paeni?” ");
INSERT INTO cpy_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ikanteeyini rirori: “Otzimatyee rowamahaeteri kaari-perori, raminee itsipa riiperori amineeroni pankirentsi-mashi, riitaki otyaanta-piintee-niriri okithoki iwankiri.” ");
INSERT INTO cpy_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ikantzi Jesús: “Tema piñaana-tziro Jankinarentsi, ikanteetzi: Imaninta-witakawo mapi owetsikirori pankotsi, Roo kanteencha rowatzikae-teero mapi pankotsi-nampiki, ikimita-kahae-taawo roomi tzinka-mintsi. Riitaki Awinkatharite Tajorentsi owatzikaerori onampi-naki, Rootaki apampoyaawentan-tariri.” ");
INSERT INTO cpy_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Rootaki nokantan-tyaari naaka: Eero ipinkathari-wenteemi eeroka Tajorentsi, riira ipinkathari-wentee itsipa-jatzi-paeni jempe itzimi oshiyaawori pankirentsi okithokitzi ikemijanteera. ");
INSERT INTO cpy_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tema ikaate aashiraa-tantee-yaawoni mapi, aritaki itankapaaki. Riima ikaate anawyahaeri mapi, aritaki ooweteeri.” ");
INSERT INTO cpy_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ikanta reewarite Ompera-tajorentsi-taarewo eejatzi Inashitantaniri, riyotaki riitaki ikemakaetaki. ");
INSERT INTO cpy_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ari ikowawi-tanaka raakaan-terimi, teemaeta imatziro, osheki ithaawan-takari atziri-paeni. Tema ikanta-shire-teeyini atziri Kamantan-taniri irika Jesús. ");
INSERT INTO cpy_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ari rapiita-neero Jesús roshiya-kaawentziro riyotaan-tziri. Ikantzi: ");
INSERT INTO cpy_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Iroka ikanta ipinkathari-wentantee Inkite-jatzi, roshiyari pinkathari oemoshirenkiriri itomi raawakaa. ");
INSERT INTO cpy_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rotyaantakiri romperatani, ikamanteri pokatsini roemoshirenkyaa. Teemaeta ipokaeyini ikaemakaantani. ");
INSERT INTO cpy_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Rotyaanta-witaka itsipa romperatani, ikantawakiri: ‘Pikanteri nokaemakantani ipoki royaa, nowamaaki wathan-tzi nopira, noemoshirenka-tziiri notyomi raawakaeyaa. Tema wetsikaka maawoeni.’ ");
INSERT INTO cpy_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Roo kanteencha irikapaeni ikaemakaantani, osheki ipiyatheeya-kani. Jatayitaki rowaneki, itsipa ikinaki ipimanta-waetzi. ");
INSERT INTO cpy_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Eenitatsi itsipa owajankitaa-kiriri omperataarewo, rowamaakiri. ");
INSERT INTO cpy_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ikanta ikemaki pinkathari, antawo ikijanaka, rotyaantaki rowayirite, ithonkakiri owanteen-tsiri, itayitakiri inampi. ");
INSERT INTO cpy_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ikanteeri itsipa romperatani: ‘Tema wetsikaka maawoeni oemoshirenkan-tyaari, tee nokowaneeri ipokaeyini ikaatzi nokaema-kaanta-witakari. ");
INSERT INTO cpy_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Piyaate awotsiki-paeni, pikanteri ikaate piñeeri ipokanakiita oemoshirenkyaa.’ ");
INSERT INTO cpy_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jataki omperataarewo, ipiyotaki ikaatzi iñaakiri: kameetha-tatsiri eejatzi kaaripero-tatsiri. Piyotee-yapaakani oemoshirenka-chani. ");
INSERT INTO cpy_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ikanta raminakiri pinkathari ikaatzi pokaentsiri. Iñaatzii ojatekaen-chari tee ikithaatawo rowaneenka-tashi-tyaari aawakaa-chani. ");
INSERT INTO cpy_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ikantakiri: ‘Nosheninka, ¿jempema pikanta pikyaan-takari jaka tee pikithaatawo powaneenka-tashi-tantyaariri notyomi?’ Ari imaeritaki, tee raki. ");
INSERT INTO cpy_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ikantakiri romperatani: ‘Poojo-wakoteri, poojo-yitziteri, pookiri otsirenikaakitakira, ari riraawae-tyaa, ratsikae-kiwaetyaa, ikemaatsi-waeteeyaa.’ ");
INSERT INTO cpy_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tema osheki ikaemawi-teetyaa, roo kanteencha eepichokiini riyoshii-teete.” ");
INSERT INTO cpy_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ikanta riyaatee-yeeni Inashitantaniri. Ari ikenkitha-waeteeyini, ikanteeyini: “¿Jempema akinakaeroka akompita-kaant-yaariri Jesús?” ");
INSERT INTO cpy_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rotyaantaki riyotaani Inashitantaniri itsipatakari raapatziyani Herodes, ikantapaakiri Jesús: “Yotaantaniri, okaatzi piyotaan-tziri rooperotaki iroka, rootaki riyotakoe-tantyaariri kametha Tajorentsi. Tee pikemijantziro ikantayi-tziri atziri, tee piñaawae-tziro pinimota-kaant-yaariri. ");
INSERT INTO cpy_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pikantena iitaka pikenkishiryaari eeroka: ¿Kameetha-tatsima apiri koriki ikaatzi ishintsi-tantziri iwinkatharite wirakocha-paeni?” ");
INSERT INTO cpy_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Riyotawakiri Jesús ikenkishiryaari, ikantziri: “Owapeyi-motan-tanirí. ¿Iitaka piñaantan-tanari? ");
INSERT INTO cpy_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poñaayinari koriki pashita-kaariri Pinkathari.” Ari ramaeta-paakiniri koriki. ");
INSERT INTO cpy_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rojampi-tanakiri, ikantziri: “¿Iitaka ashitawori iwaero jaka? ¿Iitaka ashitawori roshiya-kaawo?” ");
INSERT INTO cpy_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ikanteeyini: “Rashi iwinkatharite wirakocha.” Ikantzi Jesús: “Tema riitaki iwinkatharite wirakocha ashitari, pantant-yaanariri ishintsi-tzimiri, pipinateri. Riima ikaatzi rashitari Tajorentsi, pantant-yaanari ishintsi-tzimiri rirori.” ");
INSERT INTO cpy_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikanta ikemaeyakini ikantakiri Jesús, ari ipampoyeeyanakirini rooka-nakiri. Jateeyeeni. ");
INSERT INTO cpy_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tekira awiji iroka kitejeri, ipokaeyakini Sadoc-paeni iñeeri Jesús. Riitaki Sadoc-paeni kantatsiri: “Eero rañahae kamayita-tsiri.” Rojampi-tapaakiri Jesús, ");
INSERT INTO cpy_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ikantziri: “Yotaantanirí, rojankinataki paerani Moisés, ikantzi: ‘Aririka ikami atziri, eerorika rowakayiro iina, kantacha rayiro rirentzi, rowakahaero. Ikimita-kaanteeri riimi ashityaarini rirentzi kamaentsiri.’ ");
INSERT INTO cpy_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jame akantawaki: Eenitatsi kaatatsiri 7 rirentzi. Etawori itzimi raaki iina, tekira rowakayiroota iina kamaki, rahaero itsipa rirentzi. ");
INSERT INTO cpy_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ari ikantakari eejatzi apiteta-neentsiri rirentzi. Eejatzi itsipa mawataneen-tsiri. Ari ikantakari maawoeni ikaatzira 7. ");
INSERT INTO cpy_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Okanta paata kamae roori tsinani. ");
INSERT INTO cpy_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aririkami rañaayitee paata kamayita-tsiri, ¿itzimikama oeminta-pero-tyaari tsinani? Tema maawoeni ikaatzira 7 iinanta-witakawo.” ");
INSERT INTO cpy_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rakanaki Jesús, ikantziri: “Pikinakaa-shitakawo eeroka, tee piyotakotziro Jankinarentsi-perori, tee piyotakotziro ishire Tajorentsi. ");
INSERT INTO cpy_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aririka rañaayitee kamayita-tsiri, eero itzimi aawakae-yitaa-chani. Roshiya-paeyaari Ronampiri Tajorentsi janta inkiteki. ");
INSERT INTO cpy_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Tema piñaanatakotziro jempe okantyaa aririka rañahae kamayita-tsiri? Iroka ikantzi Tajorentsi, iñaawaetzi: ");
INSERT INTO cpy_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Naakataki Itajorentsite Abraham, Isaac, eejatzi Jacob. Ari ayotziri añaatsi rirori, tema tee imatziro kaminkari ipinkathateri Tajorentsi, apatziro ipinkatha-tziri añaayita-tsiri.” ");
INSERT INTO cpy_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ikanta ikemaeya-kirini Jesús ikantaki, ipampoyeeyanakirini, ikanteeyini: “Omaperotatya okameethatzi riyotaan-tziri.” ");
INSERT INTO cpy_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ikanta ikemaki Inashitantaniri kameetha rakakiri Sadoc-paeni rojampi-takiriri, piyotee-yakani rirori. ");
INSERT INTO cpy_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ikanta apaani piyoteen-chari, riijatzi yotakotzirori Ikantakaan-teetani, ipokashi-takiri Jesús rojampiteri, ikoyi ikompita-kaeyaarimi, ikantapaakiri: ");
INSERT INTO cpy_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yotaantaniri, ¿otzimikama otzinkami-perori Ikantakaan-teetani?” ");
INSERT INTO cpy_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Rakanaki Jesús, ikantziri: “Piwinkatharite irika Tajorentsi, otzimatyee Pininta-pero-teeri, pininta-shire-teeri, pininta-shintsiteeri. ");
INSERT INTO cpy_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Rootaki iroka otzinkami-perori Ikantakaan-teetani. ");
INSERT INTO cpy_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ari oshiyawo apiteta-neentsiri, kantatsiri: Petakoteeyaari pisheninka, poshiya-kaanteeri pineshironka-tziro eeroka piwatha. ");
INSERT INTO cpy_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tema iroka apite nokanta-kimiri, rootaki otzinkami-perori, rootaki poñaachari otsipaki Ikantakaan-teetani eejatzi 