﻿USE sofia;
DROP TABLE IF EXISTS sofia.cpcNT_vpl;
CREATE TABLE cpcNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cpcNT_vpl WRITE;
INSERT INTO cpcNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jiroka iwairopaini ikaatzi ichariniyitari Jesucristo. Tima iriitaki icharini David-ni, ipoña iijatzi Abraham-ni. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ikanta pairani Abraham-ni, itzimaki itomi jiitakiri Isaac. Ikanta Isaac tzimanaki itomi irirori, jiitakiri Jacob. Ikanta Jacob tzimanaki itomi irirori, jiitakiri Judá. Tii apaani ikanta itomi Jacob, ojyiki itomipaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ikanta Judá jowaiyantakaakiro Tamar, jiitakiri Fares, iriima pashini jiitakiri Zara. Ikanta Fares tzimanaki itomi irirori, jiitakiri Esrom. Ikanta Esrom tzimanaki itomi irirori, jiitakiri Aram. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ikanta Aram tzimanaki itomi irirori, jiitakiri Aminadab. Ikanta Aminadab tzimanaki itomi irirori, jiitakiri Naasón. Ikanta Naasón tzimanaki itomi irirori, jiitakiri Salmón. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ikanta Salmón jowaiyantakaakiro Rahab, jiitakiri Booz. Ikanta Booz jowaiyantakaakiro Rut, jiitakiri Obed. Ikanta Obed tzimanaki itomi irirori, jiitakiri Isaí. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ikanta Isaí tzimanaki itomi irirori, jiitakiri David. Iriitaki pinkatharitaintsiri. Ikanta pinkathari David jowaiyantakaakiro iina Urías, jiitakiri Salomón. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ikanta Salomón tzimanaki itomi irirori, jiitakiri Roboam. Ikanta Roboam tzimanaki itomi irirori, jiitakiri Abías. Ikanta Abías tzimanaki itomi irirori, jiitakiri Asa. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ikanta Asa tzimanaki itomi irirori, jiitakiri Josafat. Ikanta Josafat tzimanaki itomi irirori, jiitakiri Joram. Ikanta Joram tzimanaki itomi irirori, jiitakiri Uzías. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ikanta Uzías tzimanaki itomi irirori, jiitakiri Jotam. Ikanta Jotam tzimanaki itomi irirori, jiitakiri Acaz. Ikanta Acaz tzimanaki itomi irirori, jiitakiri Ezequías. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ikanta Ezequías tzimanaki itomi irirori, jiitakiri Manasés. Ikanta Manasés tzimanaki itomi irirori, jiitakiri Amón. Ikanta Amón tzimanaki itomi irirori, jiitakiri Josías. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ikanta Josías tzimanaki itomi irirori, jiitakiri Jeconías. Irojatzi itzimantanakari iririntzipaini iijatzi. Aripaiti ipokaiyakini owayiriiti poñaachari Babilonia, jaakiri maawoni inampiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Okanta ipiyaiyaani jaantaitakariri maawoni Babilonia-ki. Tzimai itomi Jeconías irirori, jiitakiri Salatiel. Ikanta Salatiel tzimanaki itomi irirori, jiitakiri Zorobabel. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ikanta Zorobabel tzimanaki itomi irirori, jiitakiri Abiud. Ikanta Abiud tzimanaki itomi irirori, jiitakiri Eliaquim. Ikanta Eliaquim tzimanaki itomi irirori, jiitakiri Azor. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ikanta Azor tzimanaki itomi irirori, jiitakiri Sadoc. Ikanta Sadoc tzimanaki itomi irirori, jiitakiri Aquim. Ikanta Aquim tzimanaki itomi irirori, jiitakiri Eliud. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ikanta Eliud tzimanaki itomi irirori, jiitakiri Eleazar. Ikanta Eleazar tzimanaki itomi irirori, jiitakiri Matán. Ikanta Matán tzimanaki itomi irirori, jiitakiri Jacob. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ikanta Jacob tzimanaki itomi irirori, jiitakiri José. Iriitaki oiminthoritakari María. Jiroka María iro owaiyantakiriri Jesús, irijatzi jiitaitakiri Cristo. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jirika ikaatzi icharinintayitakari. Jitanakawo itzimanaki Abraham-ni irojatzi itzimantakari David-ni, ikaataiyini 14. Ipoñaanaa David-ni irojatzi jaantaitakariri Babilonia-ki, ikaataiyini 14. Ipiyaiyaani jaantaitakariri Babilonia-ki, irojatzi itzimantakari Cristo, ikaataiyini 14 iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiroka okanta itzimantakari pairani Jesucristo. Ikanta José, tzimatsi iinathori oita María. Ikajyaakawo iinatyaawo. Tiimaita iñiiro intsipawaityaawo. Iro kantacha María motzitaki, ikantakaakawo Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ikanta José, tampatzikashiri jinaki irirori, ikowaki jowajyaantiromi imananikiini, tii ikowi jowaaripirotiro inkimakoitiro itzimashiwaitaka iintsiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ikanta ikinkishiriwaita José tsiniripaiti, jomishimpiyaakiri imaninkariti Pawa imayinikiini, ikantakiri: “José, icharini David-ni. ¿Iitama pikinkishiritantari powajyaantiro María? Payiro, tima Tasorintsinkantsi kantakaawori omotzitantakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Aririka intzimaki iintsi, piitiri JESÚS. Iriitaki owawijaakotairini ijyininkapaini ikaaripiroshiriwaiwitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ari okanta imonkaatantakari maawoni josankinatakiri pairani Kamantantaniri, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ari owaiyantaki tsinani kaari ñiirini shirampari, intzimi otomi, Jiitaitiri Emanuel, akantziri añaaniki aaka: “Itsipatai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ikanta ikakitanai José, jimatakiro okaatzi jinintakaakiriri Pawa, jiinantakawo. ");
INSERT INTO cpcNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tii jimaantzimaitawo irojatzi itzimantakari itanakawori otomi. Jiitaitakiri JESÚS. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Itzimaki Jesús nampitsiki Belén saikatsiri janta Judea-ki. Tima itzimantakari Jesús, iri pinkathariwintantatsiri Herodes. Ari jariitakari nampitsiki Jerusalén yotzinkariiti ikinapaakiro ishitowapiintzi ooryaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Josampitapaakiri: “¿Tsika isaikika iwinkathariti Judá-mirinkaiti owakiraa tzimatsiri? Janta nonampiki nopoñaanaka, noñaakiri impokiro niyotantakari tzimaki. Iro nopokantaiyarini nompinkathatiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ikanta ikimawaki pinkathari Herodes, antawo ikinkishiryaanaka, ari ikimitakari iijatzi maawoni Jerusalén-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ipoña ikaimakaantakiri Herodes maawoni ijiwari Ompiratasorintsitaari, iijatzi maawoni Yotzinkari, josampitakiri: “¿Tsika intzimika Cristo?” ");
INSERT INTO cpcNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ikantaiyanakini irirori: “Intzimi janta nampitsiki Belén saikatsiri Judea-ki, tima ari okantzi josankinari Kamantantaniri, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ari osaikiri nampitsi Belén janta Judea-ki, tikaatsi thainkironi. Ari impoñiiyaari pinkatharipirori janta. Iriitaki jiwatairini Israel-mirinkaiti ikaatzi nashitaari naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ipoña Herodes, ikaimakaantakiri pokayitaintsiri jiñiiri owakiraa tzimatsiri, josampitakiri: “¿Tsikapaiti piñaakiri impokiro piyotantakari tzimaki pinkathari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ikamantakiri maawoni. Ipoña ikantanakiri irirori: “Kamiitha, pimatiro piyaati Belén-ki, paminiri tsika isaikajaantzi iintsi. Aririka piñaakiri, iijatzi pinkinapai jaka, pinkamantapaina. Niyaatiita iijatzi naaka, nompinkathatakitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Irojatzi jawijantanakari. Iijatzi jiñaanairi impokiro jiñaakiri chapinki. Jiñaashitakari jaatzinkapaaki, iro jiyotantapaakawori pankotsi isaiki iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ikanta jiñaakiri, kimoshiri ikantaiyapaakani. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ariitaiyapaakani pankotsiki, jiñaapaakiri iintsi iijatzi inaanati María. Jotziirowashitapaakari, ipinkathatapaakiri. Jashitaryaakotapaakiri jamakiniriri, ipapaakiri oro, ipakiri kasankayitatsiri, ipakiri iijatzi kasankaari kipijyaari. Ojyiki owinawo jirokapaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ikanta jimagaiyapaakini, jomishimpiyaakiri Pawa, ikantziri: “Iiro pipiyashitari Herodes. Pinkinanai pashiniki aatsi piyaatantaiyaari pipankoki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aritaki piyaiyaani yotzinkariiti. Japiitairo imaninkariti Pawa jiñaanatziri José imishinikiini, ikantziri: “José, pishiyakairi iintsi iijatzi inaanati, piyaati nampitsiki Egipto. Ari pisaikiri janta irojatzi nonkantantaimiri: ‘Pimpiyai’. Aatsikitaki Herodes intsitokiri iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ikanta ikakitanaki José, ikamantakiro María, tsiniripaiti ishiyaka Egipto-ki, jaanakiri iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ari isaikakiri janta, irojatzi ikamantaari Herodes. Ari okanta imonkaatantakari josankinatakiri kitziroini Kamantantaniri, ikantaki: Isaikawitaka notomi nampitsiki Egipto, nokaimairi impiyaita iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ikanta Herodes, yotaki jamatawitakiri yotzinkariiti, tii ipiyashitaari. Otyaanakari imashirinka. Jotyaantaki jowayiriti, ikantakiri: “Piyaati janta Belén-ki, papirotiri powamairi iintsipaini, pinthonkiri owakiraa tzimatsiri, iijatzi tzimakotaintsiri apiti josarintsiti”. Tima ari ikamantakiri chapinki yotzinkariiti jiñaantakariri impokiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Irootaki iñaanitakari kitziroini Kamantantaniri iitachari Jeremías, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Okaimapirotatzi Ramá-jato iragaiyani. Ojyininkathori Raquel inatzi iraakotakariri iintsitipaini. Iro owashiriniintantakari jowamaitsiitakiro maawoni oryaaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Okanta osamanitaki, kamai Herodes, irojatzi isaikaki José nampitsiki Egipto. Ari iñaanatairi imaninkariti Pawa imishinikiini, ");
INSERT INTO cpcNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ikantairi: “José, kantatsi piyaatai pinampiki, paanairi piintsiti pintsipataanairo inaanati. Tima kamaki kowawitachari intsitokirimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ari ikantaka José, ipiyaawo inampiki Israel. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Iro jariiwitaa José inampiki, ikantaitawairi: “Iri pinkatharitaatsiri Arquelao Judea-ki. Ipoyaataari iwaapati Herodes”. Ari ikinkishiritanaka José, iiro ikinanai janta. Ari japiitaitziri ikantaitziri imishinikiini: “Paamaiyaari Arquelao”. Irootaki ikinantanakari José Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ikanta jiyaataki, isaiki nampitsiki Nazaret. Ari okanta imonkaatantakari josankinatakiri pairani Kamantantaniri, ikantaki: Nazaret-jatzi jiitaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Okanta pairani janta Judea-ki, ipokaki Juan owiinkaatantaniri, ikamantantzi otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ikantantapaaki: “Powajyaantairo pikaaripiroshiriwaitaki, tima irootaintsi impinkathariwintanti Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Irootaki iñaanitakari pairani Kamantantaniri iitachari Isaías, ikantaki: Ikaimakaimatapaaki otzishimashiki, ikantantaitzi: Powamiithatainiri Pinkathari tsika inkinapaaki. Pinkimitakaantiro jotampatzikaitziro aatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Iithaaritakari pairani Juan, jontyagaitziro iwitzi camello, jowathakitakari mishinantsimashi. Jañaantari jowayitari kintori, imiritari iyaaki pitsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ojyiki pokashitakiriri pairani Juan, Jerusalén-jatzi, Judea-jatzi, ipokashitakiri iijatzi nampiyitawori antawaaki jiñaa Jordán. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ikinkithatakotapaakiro ikaaripiroshiriwaitaki, iro jowiinkaatantakariri jiñaaki Jordán. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ari ipokaiyawitakani Fariseo-paini, iijatzi Saduceo-paini, ikowi jowiinkaatyaami. Ikisawakiri Juan, ikantakiri: “Tii pikamiithashiritaiyini iiroka, pikimitashitakari maanki. ¿Piñaajaantzi iiro jowasankitaitzimi? ");
INSERT INTO cpcNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imapirorika powajyaantairo tsika pikantawita pairani, pinkamiithashiritai, pinkimityaawo pankirintsi kithokitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Iiro pikantashiriwaitzi: ‘Aña naaka icharini Abraham-ni, tii okowapirota nowajyaantairo nokaaripiroshiriwaitzi’. Pinkimi nonkanti: ‘Iiro pikantakaapirowaita piñaajaanti iiroka ikowapirotani Pawa, aña kantatsi jatziritakairo mapi, iro impoyaataimini incharinitaiyaari Abraham-ni’. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Iirorika pikimitawo pankirintsi kithokitatsiri, ichikakaitawo chacha pankirintsiponkitziki kaari kithokitatsini, ompoña jagaitiro intagaitiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Aririka jowajyaantanairo atziri ikaaripiroshiriwita, ari nowiinkaatantatyaari jiñaa. Iro kantzimaitacha, aatsikitaki matzirori ipinkatharitzi, nopinkathatsitakari naaka, tii onkantaajaiti inkimitakaantina jompiratani naantyaanariri i-zapato-ti. Iriitaki kimitakaantironi jowiinkaatantatyiimiri Tasorintsinkantsi, iijatzi paampari. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tima aririka oyiipatiro awankiri, otikakitziro. Atayiro opintakiiriki. Iro aaki okithoki, otikitakiro kamiitha, owakoyitakiro. Ari inkimitaiyaari iijatzi pokaintsiri, jinashiyitaiyaari atziri, inishironkayitairi inkaati kimisantanairini, iriima kaari owajyaantironi ikaaripiroshiritaki, intaantaiyaari paampari kaari tsiwakanitatsini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ipoña ipokaki Jesús antawaaki jiñaa Jordán, ipoñaakawo Galilea-ki. Ipokashitakiri Juan jowiinkaatiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tii ikowawita Juan jowiinkaatirimi Jesús, ikantawakiri: “¿Iitama pipokashitantanari naaka nowiinkaatimi? Aña iiroka owiinkaatinanimi naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jakanaki Jesús: “Nokowapirotatzi powiinkaatina. Irootaki ikowakaakinari Pawa”. Kowanaki Juan, ikantziri: “Aritaki nowiinkaatakimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jaanakiri, jowiinkaatakiri. Iro intonkaanaimi Jesús, kimiwaitaka ashitaryaanakityaami inkiti, iñaatziiri ipokashitakiri Tasorintsinkantsi ikinapaaki inkitiki ikimitapaakari shiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ikimaitatzi inkitiki ikantaitanaki: “Notomi jinatzi jirika nitakopirotari, ojyiki nokimoshiriwintakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ikantakaanakari Jesús Tasorintsinkantsi, jatanaki otzishimashiki, ari ikowawitakari kamaari inkaaripiroshiritakairimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ojyiki kitiijyiri isaikaki, itzitakawo owanawontsi, owamaimatakiri itajyi. Okaatzi 40 kitiijyiri isaikawaitaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ikanta kamaari, ipokashitakiri Jesús inkaaripiroshiritakairimi. Ikantapaakiri: “Imapirotatyaarika Itomintzimi Pawa, pimpiyiro tanta jiroka mapi, poyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jakanakiri Jesús, ikantanakiri: “Tzimatsi osankinarintsi kantatsiri: Tii apa onkowapirotya tanta oyaawo, aña iro kowapirotacha ankimisantairo maawoni ikantairi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ipoña kamaari jaanakiri nampitsiki tasorintsitatsiri, isaikakaapaakiri jinoki otawantoki tasorintsipanko. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ikantapairi: “Imapirorika Itomintzimi Pawa, pimitai isaawikinta. Pinkinkishiritiro josankinaitakiri pairani okantzi: Jotyaantimiri Pawa imaninkariti aamaakowintimini. Iri thomaawakimini iiro pontajantapaaka mapikiki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jakanakiri Jesús, ikantzi: “Okantzi iijatzi josankinaitakiri pairani: Tii okamiithatzi piñaantashiwaityaari Piwinkathariti Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Japiiwitakari kamaari jaanairi Jesús tonkaariki otzishi. Jaminakaakiri maawoni nampitsi ipinkatharitzi atziriiti, tima kamiitha okanta owaniinkataka. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ikantziri: “Piñaakiro okaatzi tzimatsiri. Aririka potziirowashitakina pimpinkathatina, ari nompakimiro maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jakanakiri Jesús, ikantanakiri: “Piyaatawiiti intaina. Satanás pinatzi iiroka. Tima josankinaitaki pairani, kantatsiri: Ampinkathatairi Awinkathariti, iri ankimisanti apaniroini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ari jintainaryaawitapainta kamaari. Pokaiyapaakini imaninkariti Pawa, jimitakotapaakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ikanta Jesús ikimakotakiri Juan jomontyaitakiri. Iro ipiyantanaari irirori janta Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tii isaikapai Nazaret-ki, ikinanai nampitsiki Capernaum, ari isaikapairi. Tima inkaarithapiyaaki osaiki Capernaum, tsika inampiwitawo Zabulón-mirinkaiti iijatzi Neftalí-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ari okanta imonkaatantakari okaatzi ikinkithatakotakiri pairani Kamantantaniri Isaías, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Osaiki inampitsiti Zabulón-mirinkaiti iijatzi Neftalí-mirinkaiti janta inkaarithapiyaaki, Intatsikironta antawaaki jiñaa Jordán, Saikatsiri Galilea-ki, tsika ipiyotapaa atziri kaari ajyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kimitakawori isaikaatyiimi otsinirikitzi, iriitaki ñaayitairini ootamintotsi. Otsimankakowitakari jaamparyaa ashitawori sarinkawini. Kimiwaitaa isaikaatyiimi okitiijyiinkatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ari jitanakawo Jesús ikamantapaakiri atziripaini, ikantapaakiri: “Powajyaantairo pikaaripiroshiriwaitzi, pinkathariwintantai Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ipoña ishirithapiyaatanakawo inkaari saikatsiri Galilea, irojatzi iñaantapaariri Simón, jiitaitziri iijatzi Pedro, itsipatari iririntzi jiita Andrés, ishiryaataiyini. Tima shiryaatzinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ikantapaakiri: “Poyaatina, onkimiwaityaawo iriimi atziri noshiryaatakagaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ari joyaatanakiri, jookanakiro ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iro jawijanakityiimi, iñaapaatziiri Jacobo, itsipatakari iririntzi Juan, isaikaiyini ipitoki ishirikiro ishiryaaminto itsipatakari iwaapati iitachari Zebedeo. Jomiyaanakiri iijatzi irirori, ");
INSERT INTO cpcNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","irojatzi jookanakiri iwaapati ipitoki, joyaatanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ari okantaka, ithonkakiro janiitakiro Jesús Galilea, jiyotaantaki maawoni nampitsi tsika japatotapiintaita, ikamantantakiro Kamiithari Ñaantsi kinkithatakotzirori impinkathariwintantai Pawa. Joshinchaayitaki ojyiki mantsiyayitatsiri nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ikimakoitanakiri Jesús intaina. Ikimaki iijatzi Siria-jatzi, jamayitapaakiniri mantsiyayitatsiri ijyininka, joshinchiiniri. Jamakiniri aayitziri kantashiwaitachari mantsiyarintsi, katsiwaitatsiri, kamimawaitatsiri, kisopookiwaitatsiri. Jamakiri iijatzi piyarishiriyitatsiri. Ari ithonkiri joshinchaawakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Joyaataiyakirini ojyiki Galilea-jatzi, Decápolis-jatzi, Jerusalén-jatzi, Judea-jatzi, poñaayitanainchari iijatzi intatsikironta antawaaki jiñaa Jordán. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ikanta jiñaakiri Jesús ojyiki apatowintakariri, tonkaanaki otzishiki, ari isaikapaaki. Pokaiyapaakini jiyotaani, ipiyowintapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ari jiyotaayitakiri, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kimoshiri inkantaiya iintashiriri, iriitaki ñagaironi impinkathariwintantai Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kimoshiri inkantaiya iraaniintawaitachari, iriitaki joimoshirinkaitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kimoshiri inkantaiya tsinampashiriri, iriitaki saikaatsini kamiitha kipatsiki ikowakaitakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kimoshiri inkantaiya kowironi inkamiithashiriti, aritaki iñiiro ikowiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kimoshiri inkantaiya nishironkashiritantaniri, ari inishironkaitairi iijatzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kimoshiri inkantaiya kitishiriri, iriitaki ñagairini Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kimoshiri inkantaiya ookakaantzirori kisaantsi, iriitaki intomitaiyaari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kimoshiri inkantaiya inkimaatsitakaityaari ikamiithashiritzi, iriitaki ñagaironi impinkathariwintantai Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kimoshiri pinkantaiya imanintawaitaitimi, inkimaatsitakaitimi, inthiiyakoitimi okantakaantziro pikimisantaana. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Thaaminta pinkantanatya, tima Pawa pinataimini inkitiki. Pinkinkishiritakotiro jiroka, ari ikimitaitakiri pairani itayitakawori Kamantantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Pikimitakawo iirokaiti tziwi. Aririka intsipataitiro tziwi tsika oitya, iiro opantanaawo inkatyokantaityaawo. Ontzimatyii imanintaitiro, jookaitakiro isaawiki jaatzikawaitaitiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Aririka osaiki nampitsi tonkaariki, okoñaatzi maawoni aririka ootya tsiniripaiti, tii imana nampitsi. Kitiijyiinkatakotantaniri pinanaatzi iiroka iijatzi, iirokataki yotaanairini maawoni atziri, iiro pimanimotziri okaatzi piyotanairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ari okimitari iijatzi, aririka owaampatiri ootamintotsi, tii ashitakotziri kantzirinaki. Owakotziri jinoki inkitijyitakotiri maawoni saikatsiri pankotsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ari pinkimitanaiyaari iijatzi iiroka, pisaikayitanai kamiitha iñaantimiri pijyininka okamiithatzi maawoni pantanairi. Iro impinkathatantaiyaariri irirori Ashitairi Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Iiro pikinkishiritashita iro nopokantari nowajyaantakaimiro pikimisantziro Ikantakaantaitani, iiro nowajyaantakaimiro iijatzi ikinkithatakotakiri pairani Kamantantaniri. Aña iro nopokantari nimonkaatiro okaatzi ikinkithatakoitakiri pairani. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Imapiro onthonkaiya paata kipatsi iijatzi inkiti, iiro othonkimaita Ikantakaantaitani, irojatzi imonkaatantatyaari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Iirorika pikimisantziro Ikantakaantaitani, iirorika piyotaayitairi pijyininka inkimisantairo, iiro pinintagaawo impinkathariwintantai Inkitijatzi. Iriima matakirori ikimisantairo, jiyotaantairo iijatzi, iriitaki ñaapirotaachani inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","¿Piñaajaantzima kamiithashiri ikantayita Yotzinkari iijatzi Fariseo? Aña tii. Tii jimonkaayitziro tyaaryoopiroini jinintakaawitariri Pawa. Iirorika panaakotairi iiroka pinkamiithashiritai, iiro piñiiro impinkathariwintantai Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Piyotaiyironi iiroka ikantaitakiriri pairani itakaantawori: Iiro pitsitokantzi. Aririka pitsitokantaki, jowasankitaitimi iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jiroka nokantzi naaka: Iiro pikishiri pijyininka, jowasankitaitzimikari. Iiro pikantawaitziri iijatzi: ‘Tikaatsi piyomachiiti iiroka’. Ari jowasankitaitakimi pinkatharintsiki. Tii okamiithatzi iijatzi pinkisaniintawaitiri pijyininka piitamasontziwaitiri, patsipitawokari pintagaiya sarinkawiniki. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Tima paapiintzi pipira tasorintsipankoki, pintayiniri Pawa, aririka pinkinkishiritapaakiro tzimatsi ikisantzimiri pijyininka, ");
INSERT INTO cpcNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pookanakiri pipira, piyaatashitiri kisakimiri. Pinkantairi: ‘Ajyininká, thami aapatziyawakaiya’. Aririka paapatziyawakaiya kamiitha, pimpiyai tasorintsipankoki, pintaapainiri Pawa pipira. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aririka intzimi kijyimini, impoña jaanakimi pinkatharintsiki, pinthaawakoti iiroka aatsiki, pinkantairi: ‘Iiro pikisawaita, thami aapatziyawakaiya’. Tima aririka jariitakaakimi pinkatharintsiki, inkantaitakiri jimpiratani: ‘Paanakiri jirika’. Ari jagaitanakimi jomontyagaitimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Iirorika pipinatashitari piriiwitani, iiro piñagairo joimishitowakaantaimi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Piyotaiyironi iiroka ikantaitakiri pairani, ikantaitzi: Iiro pimayimpiritzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jiroka nokantzi naaka: Pinkowashiritirorika piñiiro tsinani, matakimi, pimayimpirishiritakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pinkimi nojyakaawintimiro: Iroorika pokipiro pantanta kaaripirori, powajyaantairo, pinkimitakaantiro pinkithoryaatyiiromi, pookiro. Tima tii pikowi atsipitakagaimiro poki sarinkawini, iro kamiithatatsi pisaikapitonaakitai. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iroorika pakopiro pantanta kaaripirori, powajyaantairo, pinkimitakaantiro pinthatzinkatyiiromi, pookiro. Tima tii pikowiro atsipitakagaimiro pako sarinkawini, iro kamiithatatsi pisaikaponthokitai. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ikantaitaki iijatzi pairani: Aririka jookawakaitya, ontzimatyii impaitiri osankinarintsi jookawakaantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jiroka nonkanti naaka: Kaaripiroshiriri jinatzi ookashiwaitawori itsipatari. Tima aririka aawitaiya pashini oimi, omayimpiriwintakiri itawitari oimintari. Ari ikimitakari iijatzi agaironi, mayimpiritaki irirori. Tiimaita okaaripirowita jookiromi atziri itsipatari, aririka iñiiro omayimpiritzimowaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Piyotaiyironi iijatzi ikantaitakiriri pairani itakaantawori: Iiro pipairyaashiwaitari Pawa. Apa pinkanti: ‘Jowasankitaina Nowinkathariti iirorika nimatziro nokantziri’. Aririka pinkantaki, ontzimatyii pimonkaatiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jiroka nokantzi naaka: Tii okantzi pimpairyaashiwaityaari Pawa, pimatantyaawori pikantayitziri. Iiro pipairyaashiwaitawo inkiti, tima ari isaikiri Pawa janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Iiro pipairyaashiwaitawo kipatsi, tima irojatzi jashitari Pawa, ari jowachintitapiinta. Iiro pipairyaashiwaitawo Jerusalén, tima ari ipinkathariwintantzi Pinkatharipirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Iiro pipairyaashiwaitawo piito, pinkanti: ‘Iirorika nimonkaatziro nokantziri, inthatzinkaitinawo noito’. Tiira iiroka matironi pijyookakairo pipai, pinkisaashitakagairo iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Iiro pamatawitantzi. Imapirorika pantiro pikantziri, ari pinkanti: ‘Jii, nimatiro’. Iirorika pantziro, pinkanti: ‘Iiro nimatziro’. Tima tii okamiithatzi pojyityiiro piñaani”. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Piyotaiyironi ikantaitakiri pairani: Aririka pinkithoryiitiri irooki pashini atziri, okamiithatzi impiyakowintaityaari, inkithoryiitaitimiro poki iiroka. Aririka pintsinkiryaakotiri pashini atziri, okamiithatzi impiyakowintaityaari intsinkiryaakoitimi iijatzi iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jiroka nokantzi naaka: Tii okamiithatzi pimpiyatyaari kisaniintzimiri. Aririka impajapootimi kajyitaniki, pishinitiniri iijatzi pashinipooki impajatimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aririka inkowaiti jaapithaitimiro piithaari, pishinitiniri jaanakiro iijatzi pipiwiryaakotapiintari. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Aririka jompirataitimi paanakiro ajyaagawontsi pookiro niyanki aatsi, paanakiro ajyaagawontsi panaakairo ikantaitakimi tsika pookiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aririka inkantaitimi: ‘Pimpinawo’, kamiithatatsi pimpiri. Aririka inkantaitimi iijatzi: ‘Pimpawakinawo, ari noipiyaimi’, okamiithatzi pimpiri iiro pithañaapithatari. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Piyotaiyironi iiroka ikantaitakiri pairani: Pinishironkatiri pijyininkapirori. Iriima atziri kijyimiri, pinkijyiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jiroka nokantzi naaka: ‘Pitakotyaari kisayitzimiri. Pamanakotyaari inishironkatantyaariri Pawa irirori. Iiro pipiyatari kisaniintzimiri, paapatziyaari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Irootaki ikowakaitakiriri itomitaari Ashitairi Inkitijatzi. Witsikakiriri ooryaatsiri, oorintakotziriri maawoni atziri: kamiithashiriri, iijatzi kaaripiroshiriri. Iriitaki witsikakirori iijatzi inkani, jowaryiiniri maawoni atziri: kamiithashiriri, iijatzi kaaripiroshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pitakotashitaririka ikaatzi itakotzimiri iiroka, ¿piñaajaantzi ari impinataimi Pawa? Aña iiro, iro jimatapiintakiri kaaripiroshiriri kowakotziriri ijyininka kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Pitakotyaaririka pijyininka, ¿aminaashiwaitaka? Tima iro jimatapiintakiri iijatzi kaari pijyininkata irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kamiithashiri pinkantanaiya iiroka, pinkimitakotyaari Ashitairi Pawa, imapiro ikamiithashiripirotaki irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Powajyaantairo powapiyimoyitari atziriiti pinkamiithashiritimi. Iinirorika piyaatatyi pantiro, tikaatsi impinataimiri Ashitairi Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aririka pimpashitantya, tii okamiithatzi pinkantanti: ‘Nopashitantaka naaka’. Irootaki jamiyitari thiiyinkari, ikowi irirori impinkathaitiri. Intzimakirika pinkathatakirini jaka, iro iñaamachiiti irirori impinkathawintaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Aririka pimitakotiri iiroka ashironkainkari, iiro pikamantziri pitsipaminthari, ");
INSERT INTO cpcNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","manaantsiini onkantakotya pipashitantakari. Jiyotaki Pawa irirori, iriitaki pinataimini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Aririka pamanamanaatyaari Pawa, tii opantawo pinkimitakotyaari kantakaapirowaitachari. Ikatziyapiinta irirori japatotapiintaita, ikatziya iijatzi niyankiniki nampitsi, iñaantyaariri ijyininka. Iro iñaamachiiti irirori impinkathawintaitiri. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Irooma iiroka, aririka pamanamanaatya, pashitakotya pipankoki pinkowakotiri Ashitairi tsipatakimiri. Iri ñiimiri apaniroini, ari inishironkatakimi, iriitaki iijatzi pinataimini. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tima aririka pamanamanaatya, tii opantawo papiipiintiro okaatzi pikantakiri. Iro jamiyitari kaari ajyininkata aaka. Iñaajaantzi japiipiintziro ikantakiri ari inkimakiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Paamaakowintya pikimitakotarikari iiroka. Tikiraamintha pinkowakotiri Ashitairi kowityiimotzimiri, jiyotsitakawo maawoni irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jiroka pinkanti pamanamanaatapiintya iiroka: Ashitanarí, nampitawori inkitiki, Tasorintsi pinatzi iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pimpinkathariwintaina naaka. Pantakainawo jaka kipatsiki okaatzi pinintakaanari iiroka, Pinkimitakainari inkitiwiri, pantakairi irirori maawoni pinintakairiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pimpapiintinawo kowityiimotanari noyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pimpiyakotainawo nokaaripiroshiriwaitaki, Tima nimatakiro naaka, nopiyakotairi ikaatzi owaaripiroshiritakinari. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iiro pishinitana iñaantaityaana, inkowaiti jantakaitinawo kaaripirori. Ari pinkantaityaani pimpinkathariwintanti. Ari pinkantaityaani ontzimimotimi pishintsinka, iijatzi powaniinkawo. Ari onkantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tima aririka pimpiyakotairi atziri kijyimiri, ari impiyakotaimi Ashitairi Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Irooma iirorika pipiyakotairi kijyimiri, iiro ipiyakotaimi iijatzi Ashitairi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Aririka pintziwintya pinkinkishiritakotiri Pawa, iiro pikamantantzi, pinkanti: ‘Notziwintatyaari Pawa’. Paamaiya iiroka pikimitarikari thiiyinkari. Itzitapiintawita irirori, mantsiyapoo ikantayita jiyotantaityaari itziwintatya. Iro impinkathawintamachiitiriri irirori. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Irooma iiroka aririka pintziwintyaari Pawa pinkinkishiritantyaariri, pinkiwapootya, ipoña pinkishitatya kamiitha, ");
INSERT INTO cpcNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","iiro jiyotantaitzimi pitziwintatya. Apa jiyotimi Ashitairi Inkitijatzi, iriitaki pinataimini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tii opantawo powaagaantashiwaitya jaka kipatsiki, owanaa othonkanita, ari ipiyotapaari iijatzi koshintzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Iro kamiithatatsi pantayitairo pisaikantaiyaari kamiitha inkitiki. Onkimiwaityaawo powaagaantaiya inkitiki tsika tii othonkanitapaa, tii itzimapai koshintzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tsikarika powaagantaka, ari pinkinkishiritapiintiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Kamiitharika onkantya poki, piñaantawo kamiithaini, okimitawo pinkoñiityaakotatyiimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Tiirika opantawo poki, iiro piñaantawo kamiithaini, kimitaka pintsinirikitakotatyiimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tikaatsi matironi jantawaitiniri apiti ompiratantaniri. Apaani inkowapiroti imonkaatiniri jompiratariri, iriima pashini, inkisaniintanakiri. Ari okimitsitari iijatzi: Tikaatsi matironi jantiniri Pawa ikowakaantziri irirori, aririka inkinkishiritakoitiro ajyaagawontsi inkimitakaantanakiro iroorikami ompiratyaarini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Pinkimi nonkanti: Tii opantawo onkantzimoshiriwaitimi pinkanti: ‘¿Iitama noyaari, iitama nomirityaari, iitama nonkithaatyaari?’ Aña tzimatsi pashini ankinkishiritapiintairi añaantariki, iro kowapirotacha, anairo okaatzi owayitapiintari, akithaayitapiintari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Thami ankinkishiritakotiri tsimiripaini. Tii jiyotzi impankiti joyaari, tii jiwitsiki ipanko jowantyaawori iwankiri. Iro kantzimaitacha Pawa, ipayitapiintakiri jowanawo. Aaka jimapirotzi jitakotai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aririka paakowintyaawo onkantzimoshiriwaitimi ¿arima pinkantakiro powawiniintawairo posarintsiti? ");
INSERT INTO cpcNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Incha ankinkishiritakotiro inchatiyapaini, tii añiiro antawaitaniti, tii ontyaawinta onkithaatyaari. Tiimaita okantzimoshiriwaitawo, onkanti: ‘¿Iitama nonkithaatyaari?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Owaniinkata kamiitha, anairi jowaniinkawita Salomón, pinkathariwitachari pairani. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iriitaki Pawa owaniinkatzirori. Okantawita kapichi añaawitawo owaniinkatapaintya, iro osamani, tikaatsi ompantyaawoni aririka onkamatiyatanaki, tima inchikaitakiro, impoña intaayitakiro. ¿Iiroma ikimpoyaawintzimi Pawa? Aritaki, iiro pikisoshiritzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Aritapaaki okantzimoshiriwaitzimi, pikantzi: ‘¿Iitama noyaari, iitama niriri, iitama nonkithaatyaari?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Apatziro okantzimoshiriwaitari kaari kimisantatsini. Irooma iirokapaini, jiyotakotzimiro Ashitairi Inkitijatzi iitarika kowityiimotzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Iro kowapirotachari pinkowi impinkathariwintaimi, piñiiro iijatzi jowamiithashiritaimi, irojatzi impantaimirori okaatzi kowityiimotzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ari okanta, iiro okantzimoshiriwaitzimi oityaarika awijyimotimiri oñaatamani. Tima maawoni kitiijyiri piñiiro oitya awijyimotzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tii opantawo ankantanti: ‘Kaaripiroshiri jinatzi nojyininka’. Aririka ankantantaki, ari jimaitai aaka, inkantayiitai: ‘Kaaripiroshiriri pinatzi iiroka’. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aririka ankantakotiri ajyininka, ari inkantakotanakai iijatzi aaka. Ontzimatyii aamaiya, aririka ontzimi antzimotantani, imapiroitaikari aaka paata impiyaitai. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Okimiwaitakawo aririka ontyaakitaimi antawo inchapitoki okiki, ¿kantatsima aminiri pashini tyaakitachari kapichiini jokiki? ");
INSERT INTO cpcNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Tiima iiro okantzi ankantiri: ‘Pimpoki, nagaimiro otyaakitakimiri pokiki?’ Tima otyaakitakimi iiroka antawo inchapitoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Pikimitakari thiiyinkari. Pitawatyaawo iiroka paawairo inchato otzikaakimiri, irojatzi paminantanaiyaari kamiitha paantaiyaanariri pashini otyaakitachari. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Tii ipaitapiintziri otsitsi wathatsi tasorintsitatsiri. Ari okimitari iijatzi tii ipaitziri chancho poriryaayitatsiri, ari joipatsitakiro jaatzikawaitawakiro. Tii ipaitziri ikowawitari, owanaa inkatsimati, ari jatsikantaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Pinkamitanti, pinkowakotanti iijatzi, aritaki piñaakiro impaitimiro pikowiri. Pinkimitakaantiro pariitya pankotsi, pinkantapaakiri ashitawori: ‘Pashitaryiinawo’. Aritaki jashitaryaakimiro ipanko. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Aritaki impaitairi kamitantatsiri. Inkaati kowakotantatsiri, ari joñaagaitairi. Aririka inkantaitiri: ‘Pashitaryiiro’. Aritaki jimatakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Aririka inkamitimi pitomi, inkantimi: ‘Paapa, pimpina tanta’. ¿Arima pimpakiri mapi? ");
INSERT INTO cpcNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Aririka inkantimi: ‘Pimpina shima noya’. ¿Arima pimpakiri maanki joyaari? ");
INSERT INTO cpcNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Piyotzi iiroka pitakotari pitomipaini, kaaripiroshiri pinawita. Iri owatsipiro Ashitairi Inkitijatzi, jitakotari maawoni amanayitariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Aririka pinkowi jitakotaitimi, pitawatyaawo pitakotantya iiroka. Irootaki okantakotziri Ikantakaantaitani, irojatzi ikantakiri pairani Kamantantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Aririka pinkowi pintyaapankotairi Pawa, pinkimitakaantiro pimpampithatatyiiromi aatsimanchaki. Tima tzimatsi pashini aatsipitatzi, kaari pomirintsitachani inkinantaityaawo. Ojyiki pampithatakirori, jashironkaayiitaiya sarinkawiniki. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Irooma aatsimanchaki, tii ijyikitzi kinantyaawoni, iriitaki ariitaachani Pawakinta, inkantaitatyaani jañagai janta”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Pintyaaryootaiyini, jamatawitzimikari ojyawitariri Kamantantaniri, inkimitakotapaatyaari ikanta oijya tii ikatsimanitzi. Kaaripiroshiri jinayitzi, ikimitakari piratsi katsimari. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ontzimatyii ankimpoyiiro jantayitziri ayotantantyaari ikamiithashiritzirika. ¿Añiiroma uva onkithokitantyaawo owaato kitochii? Tii. ¿Imatziroma higo onkithokitantyaawo iroori? Tii imata iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Inchato saankanatatsiri ojyooki, okithokitzi kamiitha. Irooma inchato kamaatotatsiri, tii onkithokiniti. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tima inchato saankanatatsiri ojyooki, tii iñaitziro onkaaripiroti okithoki. Ari okimitari iijatzi inchato kamaatotatsiri, tii iñaitziro onkamiithati okithoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tima itowaitziro inchato kaari kithokitatsini, jagaitziro intagaitiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pinkimpoyaakotairi yotaayitzimiri. Ikimitakaworika okithokitzi inchato saankanatatsiri ojyooki, pimatiro jiyotaayitzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Tzimawitacha ojyiki kantawitanari: ‘Nowinkathariti pinatzi iiroka, nopinkathapirotzimi’. Iiromaita jiñairo impinkathariwintairi Pawa. Apa jiñairo antanairori ikowakaantziri Ashitanari Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Aririka nompinkatharitai paata napatotairi maawoni atziri. Tzimatsi kantayitaatsini: ‘Nowinkathariti, nopairyaapiintzimi nokinkithatakotzimi. Nopairyaakimi nowawijaakotziri piyarishiritatsiri. Nokantayitziri iijatzi nojyininka: Iro notasonkawintantari nopairyiiri Jesús’. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nonkantzimaitanatyaari naaka: ‘Tii niyotzimi. Piyaatawiiti jantyaatsikiini, imapiro pikaaripiroshiritaki’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pinkimi, aririka pinkinkishiritiro maawoni nokantakimiri, aririka pinkimisantanakiro maawoni, ari okamiithatzi. Irootaki piyotanityaari. Pinkimityaari owatzikirori ipanko okisopathatzi kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oparyaawita antawoiti inkani, amaaniwita. Otampiyawitaka shintsiini, ookantawitawo pankotsi, tii aawiyiro. Tima owatzikatya kamiitha okisopathatzi kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ari okimitari iirorika pikinkishiritziro nokantayitakimiri, iirorika pinkimisantanairo, iiro piñiiro piyotanityaawo. Pinkimitakotyaari owatzikirori ipanko impanikipathatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oparyaapaaki inkani, amaanitapaaki. Ipoña otampiyatapaaki, ookantapaakawo, tyaanaki pankotsi, aanakiro. Tii jiñaitairo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Irootaki jiyotaayitakiriri Jesús ikaatzi apatowintakariri. Iyokitzi ikantanaka atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Tii omaanta ishintsinka jiyotaantzi, janairi jiyotaantzi Yotzinkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ikanta joirinkaa Jesús ikinkithataki tonkaariki otzishiki, joyaatairi ojyiki atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ari ipokashitakiri imatziri pathaawontsi, jotziirowashitapaakari Jesús, ikantapaakiri: “Pinkatharí, pikowirika, poshinchagaina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iro jakotashitantanakariri, jotirotantakari kapichiini jako, ikantzi: “Nokowi, pishintsitai”. Shitakotanai ipathaawaiwita. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ipoña Jesús ikantawitawaari: “Iiro pikinkithatakotana. Apatziro powanakiro piyaatashitiri Ompiratasorintsitaari, pimonkaatantyaawori Ikantakaantani Moisés, pimpiri pashitakaariri Pawa, jiyotantaityaari ishitakotaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ikanta jawijanaki Jesús, ariitaiyakani nampitsiki Capernaum. Ari ipokakiri Roma-jatzi ijiwari owayiriiti, jiñiiri Jesús, ");
INSERT INTO cpcNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ikantapaakiri: “Nowinkathariti, tzimatsi nompiratani nopankoki, mapirokitaka imantsiyataki, kisopookitaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jakanakiri, ikantziri: “Aritaki niyaataki noshinchagairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ikantzimaitanakari irirori: “Ojyiki nopinkathatakimi iiroka, kaaripiro ninatzi naaka, niyotzi iiro okantzi pintyaapankotina. Apa nokowi pinkantakaantiri, ishintsitai. Tima aritaki jimatatya pinkantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tzimatsi ompiratanari naaka, tzimatsi iijatzi owayiripaini nompiratari naaka. Aririka nonkantiri: ‘Piyaati’, aritaki jiyaataki. Aririka nonkanti pashini: ‘Pimpoki’, aritaki impokaki. Aririka nonkantiri nompiratani: ‘Pantiro jiroka’, jimatziro jantziro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iyokitzi ikantanaka Jesús ikimakiri ikantaki jirika ijiwari owayiriiti. Ikantanakiri oyaataiyirini: “Iri matakirori jirika ikimisantzi, jaka Israel-ki tii itzimi ajyininka kimityaarini. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pinkimi, aririka impinkathariwintantai Inkitijatzi, ari intzimaki ojyiki kaari ajyininkata poñaayitachari pashiniki nampitsi, nintaachani intsipataiyaari Abraham-ni, Isaac-ni iijatzi Jacob-ni. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Iiromaita itzimapirotai ajyininka saikaatsini janta. Iriitaki ikowakaawiitakari impinkathariwintairimi maawoni janta, ojyiki ipiyathawaitaka, irootaki jookantaiyaariri otsinirikitaki. Ari jiraawaitaiyaari, jatsikaikiwaitya inkimaatsiwaitaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ipithokashitanaari ijiwari owayiriiti, ikantziri: “Pimatairo pimpiyi pipankoki. Tima pimatakiro pikimisantzi iiroka, irootaki ishintsitantaiyaari pompiratani”. Aripaiti ishintsitanai jompiratani janta ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ikanta Jesús jataki ipankoki Pedro. Iñaapaakitziiro riyoti, omaryaaka, imatatziiro saawataantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jotirotantapaakawo kapichiini jako, shintsitanai. Piriintanaka, aminawakiniri oitarika ompawakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Okanta otsiniriityaanaki, jamaitapaaki ojyiki piyarishiritatsiri. Joshinchaayitairi, ikisawakiri iwiyariti. Joshinchaayitairi iijatzi mantsiyayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ari okanta imonkaatantakari ikinkithatakotakiri pairani Kamantantaniri Isaías, ikantaki: Iri aanakironi amantsiyari, Irijatzi aanakironi okaatzi akimaatsiyitari. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ikanta jiñaakiri Jesús ijyikitapaaki atziri apatowintariri, ikantanakiri jiyotaani: “Thami amontyagai intatsikironta”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikantawitawaari Yotzinkari: “Yotaanarí, nokowi noyaatanakimi tsikarika pikinayitzi iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jakanaki Jesús, ikantziri: “Tzimatsi imoo otsitsiniro jimaantapiintari, iijatzi tsimiripaini tzimatsi jomayiro. Iriima jirika Itomi Atziri tii otzimi ipanko jimaantapiintyaari irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ari ikantanaki jiyotaani: “Yotaanarí, nokowawitaka noyaatanakimi, tiimaita iroñaaka nokowatzi noñaanairi nowaapatitari nonkitatanairi, ari noyaatimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ipoña ikantanakiri Jesús: “Poyaatina. Tima ikaatzi kamashiriyitatsiri, ari inkitatairi irirori kaminkaripaini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ipoña jotitanaa Jesús pitotsiki, itsipatanaari jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ikanta imontyaakotanaki, maanaki Jesús pitotsiki. Iro jiwiyaakotaiyakani niyantyaaniki, omapokashitaka otampiyatapaaki antawoiti, kitaatapaaka jiñaa pitotsiki, otamaryaatanaki inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jiyaatashitanakiri Jesús, jowakiryaapaakiri, ikantapaakiri: “¡Yotaanarí, ampiinkatyi! ¡Powawijaakotaina!” ");
INSERT INTO cpcNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ikantanakiri irirori: “¿Iitama pithaawantari? ¿Tikiraama pikimisantapirotziita?” Piriintanaka, jomairintakiro tampiya iijatzi otamaryaani inkaari, awijanaki, mairyaatanai kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iyokitzi ikantaiyanakani jaminanakiri Jesús, antawoiti ipinkathatanakiri, ikantawakaiyani: “¿Iitama atziritatsiri jirika? Jomairintziro tampiya, iijatzi inkaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aritaki ariitaiyakani intatsikironta, aatakotaiyapaakani nampitsiki iitachari Gadara. Ari ishiyashitawakari apiti piyarishiritatsiri ipoñaakawo kitataariki. Katsimaki ikantakaakari piyari, owanaa ithaawantaitakari, tii okantzi inkinaiti janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ikantawakiri: “¡Jesús, Itomi Pawa! ¿Irootaintsima powasankitaina? ¿Tsikama nokantakimika iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ari itzimi janta ojyiki chancho, joshintagaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ñaawaitanaki iwiyariti, ikantanaki: “Aririka powawijaakotairi jirika nopiyarishiritakairi, potyaantina ipiyotaka chancho”. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jakanakiri Jesús, ikantziri: “Piyaati piyari”. Matanaka. Jatanaki piyaripaini chancho-ki, iro ishiyantanakari impiitatzi otzishi, mitagaiyapaakini, apirotaka ipiinkaki maawoni inkaariki. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ikanta jiñaakiri aamaakowintariri, shiyaiyanakani. Jataki nampitsiki, ikamantapaakiri maawoni atziri okaatzi jiñaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iro jiyaatashiitantakariri Jesús, ikantaitapaakiri: “Tii nokowaiyini pisaiki nonampiki, pamini tsika pinkini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ipoña jotitanaa Jesús pitotsiki, montyaakotanai, ipiyaawo inampiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ari jamaitakiniri kisopookiri, jinatakoitantakari jomaryaantapiintari. Jiyoshiritawakiri Jesús atziri natakotakiriri, jiñaanatawakiri mantsiyari, ikantawakiri: “Thaamintashiri pinkantanatya notomi, ari noshinchagaimi, ipiyakoitaimiro pikaaripiroshiriwaiwitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ikanta ikimawaki Yotaniriiti, ikantashiritanaki: “Ithainkatziiri Pawa jirikawí”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yotaki iijatzi Jesús iita ikantashiritakiri, josampitanakiri: “¿Iitama okaaripirotantari pikantashiritziri? ");
INSERT INTO cpcNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tiima okamiithatzi nonkanti: ‘Ipiyakoitaimiro pikaaripiroshiriwitaka?’ ¿Irooma pikowi nonkantiri: ‘Pinkatziyi, piyaatai?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iroñaaka piñiiri Itomi Atziri otzimimotziri ishintsinka, ari impiyakotairi kaaripiroshiriwitachari”. Ipithokashitanakari mantsiyari, ikantziri: “Pinkatziyi, paanairo pomaryaaminto, piyaatai pipankoki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ari ikatziyanaka mantsiyawitachari, jatai ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Jiñaakiri maawoni atziri apatotainchari, iyokitzi ikantaiyanakani jiñaawairi jiyaatai. Ikantaiyanakini: “Imapirotatziiri Pawa, iriitaki matakirori otzimimotantakariri ishintsinka Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ikanta jawijanaki Jesús, irojatzi jiñaantapaakariri iitachari Mateo, kowakotziriri ijyininka kiriiki. Ikantapairi: “Poyaatina”. Katziyanaka, joyaatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ipoña jaanakiri ipankoki jowakaiyaari, itsipataanakiri jiyotaani. Ojyiki jatanaintsiri kowakotziriri ijyininka kiriiki, jiyaataki iijatzi kaaripiroshiritatsiri. Ari itsipatakari Jesús jowaiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ikanta jiñaakiri Fariseo-paini, ikaimakiri jiyotaani Jesús, josampitakiri: “¿Iitama itsipatantariri Jesús kowakotantatsiri kiriiki, itsipatakari iijatzi kaaripiroshiritatsiri? Tii okamiithatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ikimawaki Jesús, ikantanaki irirori: “Aririka imantsiyati atziri ipokashitziri aawintantzinkari, iriima atziri kaari mantsiyatatsi tikaatsi inkowi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ontzimatyii pinkinkishiritiro Ikantakaantani Pawa, kantatsiri: Tii apa nonkowairi pamayitaina pipira pintayinari. Iro nokowapirotziri pinishironkatairi pijyininka. Tii apa nompokashitiri kamiithashiriri nonkaimashiritairi, aña nopokashitatziiri kaaripiroshiriri nonkaimashiritairi jowajyaantairo kaaripirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ipoña ipokaiyakini jiyotaani Juan, josampitapaakiri Jesús, ikantziri: “¿Iitama kaari itziwintanta piyotaani? Notziwintapiintaka naaka, ari ikimitari iijatzi jiyotaani Fariseo-paini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jakanakiri Jesús, ikantanakiri: “Aririka intsipataityaari aawakaachari, ¿arima jowashiriniintaitatya? Aryaajaini paata, aririka jagaitakiri iimintaitari, aripaiti intziwintaitya. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Apaani paijatori ikithaataitari, aririkami jowapatankaitantyaawo osapiki owakiraari, ari osagaapirotanaki aririka aminthatanatyaarika owakiraari. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Iijatzi okimitari, tii okantzi paijatori mishinantsinaki jowantaityaawo iiryaari jimiritaitari. Aririka jowantaityaawo, ari intankanaki, apaawaitashitatya jimiriitari, iijatzi mishinantsinaki. Iri kamiithatatsi owakiraari mishinantsinaki jowantaityaawo, iiro apaawaitanta apitiroiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Tikira ithonkiro jiñaawaiti Jesús, ariitapaaka jiwari, ipinkathatapaakiri, ikantapaakiri: “Kamaki nishinto, iro nopokantari piyaati nopankoki potirotantyaawo kapichiini pako, añagaita”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ari jiyaatanaki Jesús, iijatzi jiyotaani joyaatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Okanta mantsiyatatsiri tsinani, ojyiki osarintsi osokaawaitaka, tzimakotaki 12 osarintsi, okinashitapaakiri itaapiiki Jesús, otirotakiro opatziki iithaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tima okantashiritakitzi: “Aririka notirotakiro iithaari, ari noshintsitai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ipithokashitanakawo Jesús, ikantziro: “Thaaminta pinkantanaiya nishinto, oshinchagaimi pawintagaana”. Apathakiro ishitanaki omantsiyanka tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ikanta jariitapaaka Jesús ipankoki jiwari, jiñaapaatzi jyowiwintzirori kamaintsiri, ojyiki atziri kamiñiinkataintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ikantapaakiri Jesús: “Pijyiki, tii okami piraakotaiyakarini, aña imakoryaatzi”. Thainka jowaitakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ipoña jomishitowapaakiri maawoni, tyaapaaki Jesús, joirikawakotapaakiro, piriintanaa iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tii jimanakotanaka jantakiri Jesús, ikimakoitanakiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ikanta jawijanaki Jesús, ipatzimatanakiri apiti kaari okichaatatsini, ikaimotziri, ikantzi: “¡Icharini David-ni, pinishironkataina!” ");
INSERT INTO cpcNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Irojatzi jariitantapaakari pankotsiki, iijatzi kaari okichaatatsiri irirori. Ipokashitapaakiri okaakiini, josampitakiri Jesús, ikantziri: “¿Pikinkishiryaama iiroka ari nowawijaakotaimi?” Ikantzi irirori: “Jii, aritaki pimatakiro nowinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jakotanaki Jesús, ipampiyookitakiri, ikantziri: “Oshinchagaimi pikimisantaana”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Apathakiro jaminanai kamiitha. Ishinchiinkatawairi, ikantziri: “Tii nokowi pinkinkithatakotina noshinchagaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ikanta jiyaatai, ikamantantanaki, ithonka ikimakoitanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ipoña jamaitapaakiniri Jesús piyarishiritatsiri, masontzipaanti ikantaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ari joshinchaawakiri Jesús jirika, ñaawaitanai imasontzipaantitakaawitari piyari, tima jotyaantapithatakiri iwiyariti. maawoni jiyokitziiwintanakiri Jesús, ikantashiritaitanaki: “Tii añaapiintzi ojyariri jirika anampiki Israel-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Iriima Fariseo-paini ikantaiyini irirori: “Jimatakaatziiri ijiwari piyariiti joshinchaantariri piyarishiritatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ithonka jiyaayitaki Jesús maawoni nampitsiki, jiyotaantayitaki japatotapiintaita. Ikinkithatakotapiintakiro Kamiithari Ñaantsi tsika onkantya impinkathariwintantai. Joshinchaayitakiri maawoni, tikaatsi mantsiyarintsi pomirintsitzimotyaarini. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iñaayitziri ojyiki apatowintariri, antawo Jesús jitakoshiritakari, ikantaki: “Imapiro jashironkaayitaka jirika atziripaini. Ikimitakari oijya iirorika itzimi aamaakowintyaarini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iikiro ikantanakitziiri jiyotaani: “Ikimitakawo jirikapaini atziri, osampainkatzi pankirintsi, tiimaita itzimapirotzi atziri oyiipataironi. ");
INSERT INTO cpcNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pamañaari Awinkathariti jotyaantiita ojyiki jatatsini atziriki, tima tzimatsi ojyiki kimisantayitaatsini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ipoña jiyoshiitaki Jesús ikaatzi 12 jiyotaani, jimatanakiro irirori joshinchaayitairi mantsiyari, iijatzi ikaatzi piyarishiritatsiri, tima ipasapiyaakari itasonkawintantzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jirika ikaatzi 12 jiyoshiitakiri Jesús: Itanakawori Simón, jiitakiri Pedro. Ipoñaapaaka Andrés, iririntzi Pedro. Ipoñaapaaka Jacobo itomi Zebedeo itsipatakari iririntzi Juan. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ipoñaapaaka Felipe, Bartolomé, Tomás, Mateo kowakowitariri kiriiki ijyininka, ipoñaapaaka Jacobo itomi Alfeo, Tadeo, ");
INSERT INTO cpcNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ipoñaapaaka Simón, jiitaitakiri iijatzi Kisakowintantaniri. Ipoñaapaaka iwiyaantapaakawori Judas Iscariote, iriitaki pithokashitantainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ipoña jotyaantakiri Jesús kaataintsiri 12, ikantawakiri: “Iiro pikini isaikayitzi atziri kaari ajyininkata aaka, iiro pikini iijatzi inampiki Samaria-jatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iri pitapaintya piyaatashitiri ikaatzi icharinitari Israel-ni, kimitakariri oijya itzipinawaita. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tsikarika pinkinayitaki pinkamantanti, pinkanti: ‘Irootaintsi impinkathariwintantai Inkitijatzi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Poshinchaayitairi maawoni mantsiyari, pañaakaayitairi kamawitachari, poshinchagairi pathaawaitatsiri, iijatzi piyarishiritatsiri. Tima nishironkataari pinayitaki, iiro piñi inkowakoitimi. Iro pimatanairi iiroka pinishironkayitantai iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Iiro paanaki piiriikiti pithaatiki, ");
INSERT INTO cpcNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","iiro paanaki iijatzi pithaati, iiro paanaki apiti piithaari, pi-zapato-ti, pikotzikiiro, tikaatsi paanaki. Tima ikantaitzi: Impinaitiri antawaitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Aririka pariitya nampitsiki, paminapaaki aapatziyimini, iri pisaikimotapaaki, irojatzi pawijantatyaari pashiniki nampitsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ari pariitatyaarika pankotsiki, piwithatapaatyaari ikaatzi saikatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Aririka jaawakimi kamiitha irirori, ari isaikai kamiitha okaatzi piwithatapaakari. Irooma iirorika jaawakimi kamiitha, aminaashitaka piwithatapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iirorika jaapatziyaitzimi, iirorika ikimisantaitzimi iijatzi, pawijapithatiri, potikanairo piipatsikiiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tima iriitaki imapiroitiri paata jowasankitaitiri jirika, ari anaanakiro ikantaitakiri Sodoma-jatzi ipoña Gomorra-jatzi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Notyaantatziimi naaka. Pikimiwaitakari jotyaantaitziri oijya ipiyota piratsi katsimari. Ontzimatyii pinkimitakotyaari kokiyantzi maanki. Ontzimatyii iijatzi pinkimityaari shiro tii ikatsimawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Paamaakowintya. Tima jaakaantaitatyiimi jiwaripainiki impajatakaantaitimi japatotapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ompoña jaayiitanakimi pinkatharintsiki, okantakaantziro pawintaana ari pikinkithatakotaina, irojatzi inkimantaiyaari iriroriiti, iijatzi pashinijatzi atziri kaari ajyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Aririka piñaakiro jaayiitanakimi, iiro pikantashiriwaitzi: ‘¿Iitama nonkantapaakiri?’ Tima tzimatsi yotashiritakaimini oita piñaanityaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iiro piyotashitanakawo oitya piñaanityaari, Tasorintsinkantsi poñaachari Ashitzimiriki, iri yotakaimironi oita pinkantayitapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ari iñaitaki aakaantirini iririntzi jowamaakaantiri. Piñi aakaantirini itomi. Piñi tsitokakaantirini ashitariri ikisaniintanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ojyiki piñiiro inkisaniintaitimi okantakaantziro pipairyagaana pikimisantaana, ari pinkantaitatyiiro pawintaiyaana, aritaki nowawijaakoshiritaimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Aririka inkisaniintaitanakimi nampitsiki, pawijyi pashiniki nampitsi. Tima tikira pithonkiro pinkinayiti maawoni nampitsiki tsika isaikayitzi Israel-mirinkaiti, irojatzi impiyantaiyaari jirika Itomi Atziri. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tii jiñaitzi apaani yotaari janaakotiri yotairiri. Tii añai iijatzi onampitaari janaakotiri onampitariri impinkathaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Apa añiiro kantatsi yotaari inkimitakotaiyaari yotairiri pairani. Ari ikimitari iijatzi onampitaari. Ikisaniintaitakina naaka iroñaaka, ikimitakaantaitakina naakami Beelzebú, iwinkathariti piyari. Iiroka imapiroiti inkisaniintaitimi pikimisantaana”. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Iiromaita pipinkashiwaitari jirikapaini. Ontzimatyii onkoñaatakoyitai manakowitainchari, oñaagantairo kaari ikimathawiita pairani. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Apaniroini niyotakaayitaimiro iiroka jirokapaini, tii jiyotzimaitawo thainkantaniri, iirokamaitaka kinkithatakaayitairini. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iiro pipinkashiwaitari tsitokimini, iiro jimatziro jotyaantimi sarinkawiniki. Aña iri pimpinkathatai Pawa, iriitaki matzirori jotyaantantzi sarinkawiniki. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pamini, tii ipinapirowita tsimiripaini, iro kantzimaitacha jiyotzi Pawa aririka inkamagaanti apaani. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jiyotsitawo Pawa okaatzi tzimayitatsiri aishi. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Piñaakiro, jaamaakotari Pawa tsimiripaini, iiroka jimapirotzi jaamaakotzimi. Iiro pipinkashiwaitari kisaniintimiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Aririka pinkantiri pijyininka: ‘Nopinkathatairi Jesús’, aritaki nonkantairi Ashitanari Inkitijatzi: ‘Paapá, ipinkathataana jirika, ajyininkataari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Irooma pinkantiririka pijyininka: ‘Tii nopinkathatziri Jesús’, ari nonkimitaiyaari naaka, nonkantairi Ashitanari: ‘Paapá, tii nonkimitsitaiyaari ipinkathatana jirika, tii ajyininkataari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tii nokowi onkompitzimotimi. Tii apa nompoki jaapatziyawakaiya atziri. Aña iro nopokantari onkimiwaityaawo namatyiimi owathaamintotsi jantaminthatawakaantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Aña iro nopokantakari: Inkisaniintantyaariri atziriiti iwaapatitari, Onkisaniintantyaawori tsinani onaanatitari, Onkisaniintantyaawori tsinani ayiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Iri pithokashitawakaachani atziriiti inkisaniintawakaiya ikaatzi isaikapankotawakaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iro kamiithawitachari pitakoyityaari piwaapati, pinaanati, powaiyanipaini. Iro kantzimaitacha iirorika pimapirotanaki pitakoyityaari pijyininka, tiira pityaaryootzi pitakotaana naaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ontzimatyii pintyaaryoowintiro nokinkithatakotakimiri, onkantawitya impaikakoitimi. Aririka powajyaantakiro, tii pityaaryoowintziro pikimisantana. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ikaatzi itakowaitachari apaniroini jantayitziro inintashitari, aritaki impiyashitaiya. Iriima inkaati kamawintinani jantanairo nokowakairiri, aritaki jawijakoshiritai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iitarika aapatziyimini, naaka jaapatziyaka. Ari okimitari iijatzi, iitarika aapatziyinani naaka, iri jaapatziyaka Ashitanari otyaantakinari jaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iitarika yotimini kamantantaniri pinatzi, impoña jaapatziyanakimi, ari pinkaatairi impinataimi Pawa paata. Ari okimitari iijatzi, iitarika yotakimini kamiithashiriri pikimisantanai, ipoña jaawakimi kamiitha, ari pinkaatairi impinataimi Pawa paata. ");
INSERT INTO cpcNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Aririka jiyoitimi iirokataki niyotaani, iro ipantzimiri pimiri, jiyotzi Pawa, iriitaki pinatairini itakotakimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ithonkakiro Jesús jiyotaakiri 12 jiyotaani. Awijanaki inkamantanti maawoni nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ikanta Juan owiinkaatantaniri jomontyaitakiri chapinki, ikimakotakiro jantayitakiri Cristo, jotyaantaki apiti jiyotaani, ");
INSERT INTO cpcNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","josampitiri Jesús, inkantiri: “¿Iirokama jiitaitziri, ‘Pokatsini?’ Kaaririka iiroka, ¿Tzimatsima pashini pokatsini?” ");
INSERT INTO cpcNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ikanta jariitaka jotyaantani Juan, josampitapaakiri Jesús. Ari jakanaki irirori, ikantzi: “Aririka pimpiyanai, pinkamantapairi Juan okaatzi pikimakiri, okaatzi piñaakiri nantayitakiri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Naminakaayitairi kaari okichaatatsini, naniitakaayitairi kisopookiri, noshinchaayitairi pathaawaiwitachari, nokimakaayitairi ashikimpitari, nañaakaayitairi kaminkari, nokinkithatakotainiri Kamiithari Ñaantsi ashironkainkaripaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Inkimoshiriwintaina kaari kisoshiriwintinari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ikanta ipiyanaa jiyotaani Juan, josampitanakiri Jesús apatowintakariri, ikinkithatakotziri Juan, ikantzi: “¿Iitama pikinkishiritakotariri piñaakiri chapinki otzishimashiki? ¿Iriima piñaaki ojyawori sawoo opiyonkatonkitakairo tampiya okantakaari tii ithaamintashirita? ");
INSERT INTO cpcNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Piñaakirima jowaniinkataka ikithaata? Aña tii. Ikaatzi owaniinkatachari ikithaata, isaikapankotziri pinkatharintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Piyaatashitakiri piyotaki kamantantaniri jinatzi. Tima jimapirotatziiro janaakiri Kamantantaniriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Iriitaki josankinatakoitaki pairani, jiñaanatziri Pawa Itomi, ikantziri: Notomí, ari notyaantaki ityaawoni inkinkithatakotimi, Iriitaki witsikaantimini tsika pinkinapaaki iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pinkimi nonkanti naaka: Ojyiki atziri tzimawitainchari, tikaatsimaita anairini jiyotanitakari Juan. Iro kantzimaitacha inkaati ipinkathariwintairi Inkitijatzi, tsinampashiritaatsiri janta, janaakotairi irirori Juan. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jitakawo pairani Juan ikinkithatakaakimi, tzimatsi ojyiki kowanakirori shintsiini iñiiro impinkatharitai Inkitijatzi. Antawoiti ikowanaki iñiiro ojyawaitakawo ishintsitaitzi jowayiritaitya. Irojatzi ikantaita iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pairani tikira itzimi Juan, tzimawitacha Kamantantaniri opoña Ikantakaantaitani. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iriima Juan, iriitaki ikinkithatakoitakiri pairani, iriitaki Elías-tatsiri piyaatsini. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kowirori inkimathatiro, inkimisanti. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nokimitakaantakimiri naaka kojyikawairintzi iintsi aririka imaananiwaiti, ");
INSERT INTO cpcNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ikantaiyini: ‘Thami ajyowiwaiti amajyiitantyaari’. Iiromaita ikowi. Ikantaiyini iijatzi: ‘Incha ampampithai owashiritantyaari’. Tii ikowiro iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ari pikimitaiyakarini iirokaiti. Piñaawitawakari Juan itzitapaakawo owanawontsi, tii jimiritawo kachori, pikantaiyakirini: ‘Ipiyarishiritatzi, iro itziwaitantari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ipokawitaka Itomi Atziri, tii itziwitawo irirori owanawontsi, imiritawo kachori iijatzi. Pikantaiyakirini: ‘Kaaripirori jinatzi jirika, niyawairintzi, shinkiryaantzi jinatzi. Jaapatziyari kowakotziriri kiriiki ijyininka, jaapatziyitari kaaripiroshiriri’. Tikaatsi oitya, tima apaani yotaniri ari jiyoitairi paata imapiro jiyotanita, aririka jiñaayitakiro onkaati awijayitaatsini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ipoña ikinkithatakotanakiri Jesús ikaatzi ñaayiwitakawori itasonkawintantaki nampitsiki, tiimaita jowajyaantziro ikaaripiroshiritaiyini. Ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ikantamachiitziri Corazín-jatzi, iijatzi Betsaida-jatzi. Iñaayiwitakawo notasonkawintantayitaki, tiimaita ikimisantaiyini. Iriimi ñaakinanimi Tiro-jatzi iijatzi Sidón-jatzi, aritakimi jowashiritakotatyaami ikaaripiroshiriyitzi, jowajyaantakiromi. Inkimisantaimi maawoni iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Aririka jaayiitairi paata kamiithashiriri, iiro jimapiroitziri jowasankitaayiitairi Tiro-jatzi iijatzi Sidón-jatzi. Iriima Corazín-jatzi, iijatzi Betsaida-jatzi, iri jimapiroyiitai jowasankitaayiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iijatzi inkimitagaiya Capernaum-jatzi, ikinkishiritaiyakani irirori jiyaatai inkitiki, iro kantzimaitacha owanaa ikisoshiritaki, jiyaayitai ikinayitzi kaminkari. Iri ñaakironimi pairani Sodoma-jatzi okaatzi jiñaakiri Capernaum-jatzi, inkimisantaimi irirori, iiro japirotzirimi pairani Pawa saikaiyatsinimi iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Aririka jaayiitairi paata kamiithashiritaintsiri, iri jimapiroitairi jowasankitaapiroitairi Capernaum-jatzi, anaanakiro jowasankitagaitakiri pairani Sodoma-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ipoña jamanamanaatanakari Jesús Ashitariri, ikantanakiri: “Paapá, iiroka pinkathariwintziriri maawoni inkitijatzi, iijatzi maawoni kipatsijatzi, ojyiki nopaasoonkitakimi. Tima iiroka yotakaayitairiri kimitakariri iintsi intsinampashiritai, kaari jiyotzi yotaniriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Tima irootaki inimotakimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ipoña ikantanakiri piyowintakariri: “Iri Ashitanari yotakaakinawori maawoni. Apaniroini ikanta irirori jiyopirotana naaka tima Itomi jowana. Ari nokimitakari iijatzi naaka apaniroini niyopirotziri. Impoña jiyoyitairi inkaati niyotakaayitairi naaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Aririka piñiiro pimakoshiriwaiti, piñiiro oitya pimpakoowaityaari, pimpokashitaina naaka, pinkamantainawo, aritaki nimakoryaakaayitaimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Iiro pimanintziro pimpakoowaityaari, naakataki ompiratzimiri pantiro. Tzimatsi niyotaimiri, tii nowatsimaashiriwaitantzi naaka, tsinampashiri ninatzi. Ari piñiiro nimakoryaashiritakagaimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tima okaatzi nompiratantziri naaka, tii opomirintsipirota”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Okanta kitiijyiri jimakoryaantaitari, ikinanaki Jesús pankirintsimashiki. Tima itajyaiyatziini jiyotaani, joyiikitanaki okithoki pankirintsi joyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jiñaakiri Fariseo-paini, ikantanakiri Jesús: “Paminiri piyotaani. Jiroka kitiijyiri jimakoryaantaitari inatzi, tii oshinitaantsitzi joyiikiwaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jakanakiri Jesús ikantanakiri: “¿Tiima piñaanatakotziri ikantakota David-ni, aantawitakariri itajyi itsipayitakari ikaataiyini? ");
INSERT INTO cpcNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ityaaki tasorintsipankoki, jowakawo tasorintsitanta, jatyootakiri itsipayitakari. Tii oshinitaantsiwita, apa jowapiintawo Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Josankinawiitaka iijatzi pairani Ikantakaantaitani, okantzi: ‘Iiro pantawaitantawo kitiijyiri jimakoryaantaitari’. Iro kantzimaitacha jiyaatapiintzi Ompiratasorintsitaari kitiijyiriki jimakoryaantaitari tasorintsipankoki, jantawaitapiintzi. Tikaatsi kijyirini. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nokantzi naaka, iinitatsi jaka impinkathapiroitiri, iri anairori tasorintsipanko. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iro josankinaitantakari pairani, kantatsiri: Tii nokowi pamayitaina pipira pintayinari, Iro nokowapirotaki pitakotaiyaari pijyininka. Iro pinkimathatirimi iiroka jiroka, iiro pikijyimawaitziri jirikapaini, tima tii ikaaripiroshiritzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jirika Itomi Atziri ipinkatharipirotzi irirori, janairo kitiijyiri jimakoryaantaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ipoña jawijanai Jesús, ityaapai japatotapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ari isaikakiri kisowakotatsiri. Ikanta Fariseo-paini, josampitakiri Jesús, ikantziri: “¿Kamiithatatsima poshinchiiri kisowakori kitiijyiri jimakoryaantaitari?” Iro josampitantariri inkini inkantakotiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ipoña jakanakiri irirori, ikantanakiri: “Tii paminashitari poijyati aririka jotitya omoonaki kitiijyiri jimakoryaantaitari, pitakotari, pinoshikiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Iri jitakopiroita atziri, janairi oijya. Tima tii okaaripiroshiritakaantzi anishironkatanti kitiijyiriki jimakoryaantaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jiñaanatanakiri kisowakori, ikantziri: “Pinthaaryaawakotai”. Matanaka atziri, akotsitanai, okimitanaawo pashini jako. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ari ikisaiyanakani Fariseo-paini. Jataiyakini, ikinkithawaitaiyini, ikantzi: “¿Tsika ankantakirika Jesús, ampiyakaantyaariri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ikanta Jesús, yotaki ikowaitatzi intsitokaitiri, irootaki jawijantanaari. Ari joyaatanakiri ojyiki atziri, joshinchaaki ojyiki mantsiyari. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ikantayiwitakari: “Iiro pikinkithatakotana”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ari imonkaatari josankinatakaayiitakiriri pairani Kamantantaniri Isaías-ni, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jirika nompiratani, iriitaki niyoyaakiri. Nitakotani jinatzi, iri oimoshirinkanari. Kiso jowiri Tasorintsinkantsi, Ikinkithatakagairi kaari ajyininkata, ikamantairi tyaaryootatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iiro ishinchiinkawintawaita apaniroini irirori, Iiro ikimaitziri inchiraachiraati inkinkithatakotya, ");
INSERT INTO cpcNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iiro jimapirotziro irirori isataapirotiro sonkari sataawitainchari, Iiro joitsiwakiri paampariminki kapichiwitainchari ipaampataki, Irojatzi inkitsirinkantaiyaawori jiñaitairo tyaaryootatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iriitaki joyaakoniintairi kaari ajyininkata impairyagairi iwairo. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ipoña jamaitakiniri Jesús piyarishiritatsiri, ikamampotaakitakaakiri, imasontzipaantitakaakiri iijatzi. Joshinchaawakiri, aminanai kamiitha, ñaawaitanai iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyokitzi ikantanaka maawoni atziri, ikantaiyanakini: “¿Iriima jirika charinitariri David-ni?” ");
INSERT INTO cpcNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ikanta ikimaiyakini Fariseo, ikantaiyanakini irirori: “Jirika atziri joshinchaatziiri ashitariri piyari iitachari Beelzebú, irootaki jowawijaakotantariri ikaatzi ipiyarishiritaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jiyotakotzimaitakari Jesús ikinkishiritakari, ikantanakiri: “Aririka jantaminthatawakaiya atziri ipinkathariwintaitziri, ari jiñaakiro jowapintawakaiya. Iijatzi okimita aririka jantaminthatawakaayitaiya inampiki atziri, ari jiñaakiro jookawintawakaiya inampiki. Aririka jantaminthatawakaiya atziri ikaatzi isaikapankotawakaa, ari jiñaakiro jookawintawakaiya ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ari inkantyaari iijatzi piyari aririkami jantaminthatawaiya. ¿Iiroma ithonka aririka jookawintawakaanatya? ");
INSERT INTO cpcNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iriirikami kamaari Beelzebú oshinchiinani naaka, ¿irijatzima kamaari oshinchiiriri piyotaaniyitari iiroka jowawijaakotantariri kaaganiritatsiri? Aririka okanta pikinkithatakotatziiri piyotaani, ari inkisantakimiro okaatzi pikantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tima Tasorintsinkantsi poñaachari Pawaki oshinchaanari naaka nowawijaakotantariri piyarishiritatsiri. Irijatzi Pawa omapokakimiri iiroka ipinkathariwintantzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Aririka inkowaiti inkoshiitiri shintsitatsiri kamiitha atziri, ontzimatyii jitaitawatyaari joojoitiri, onkantya iiro ikisakowintantawo jashiwitari aririka jayitsiitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Tima ikaatzi kaari aapatziyanari naaka, iriitaki kisaniintanari. Inkaati kaari imitakotinani joyiipatakotina, japaatakotatyaana. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Iro kantzimaitacha nokantzi naaka: Kantatsi impiyakotairi Pawa inkaati kaaripiroshiriwitachani, ari inkimitagairi ñaawaiwitawori kaaripirori ñaantsi. Iriima ookimotakirini Tasorintsinkantsi, iiro ipiyakoitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ari okimitsitari iijatzi: Kantatsi impiyakotairi Pawa ookimowityaarini Itomi Atziri, iriima inkaati kijyimatakirini Tasorintsinkantsi, iiro ipiyakoitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Okimiwaitakawo aririka iñaitiro kamiithari chochoki, jiyotaitzi kamiithari inatzi owaato tsika opoñaaka chochoki. Ari okimitari iijatzi aririka iñaitiro chochoki piyantatsiri, jiyotaitzi kaaripirori onatzi owaato tsika opoñaaka iroori. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pikimitakari maanki, kaaripiroshiri pikantaiyakani. Tikaatsi pinkinakairo piñaawaitiro kamiithari, tii opantawo pikinkishiritari, irootaki okaaripirotantakari piñaawaiyitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Apaani kamiithashiriri ikinkishiritawo kamiithari, irootaki okamiithatantari jantayitziri. Iriima kaaripiroshiritatsiri tii ikinkishiritapiintawo kamiithari, irootaki okaaripirotantari jantayitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Irootaki nokantantari naaka, aritaki jaminakoyiitairo paata okaatzi kaaripirori iñaaniyiitari. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Kamiitharika okaatzi piñaaniyitari, ari jaapatziyaitaimi. Irooma tiirika okamiithatzi, inkantayiitaimi: ‘Kaaripiroshiri pinatzi, ojyiki pinkimaatsitaiya’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ipoña jakanaki Fariseo-paini itsipatakari Yotzinkariiti ikantanaki: “Yotaanarí, nokowi noñiimi pintasonkawintanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ari jakanaki Jesús ikantzi: “Kaaripiroshiriri pinaiyini iiroka, pithainkani powakiri Pawa, pikowaiyini piñiina nontasonkawintanti. Iiromaita noñaayimiro, apa piñiiro kimityaawoni awijyimotakiriri pairani Jonás, ");
INSERT INTO cpcNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","iniyantakariri kimitariri antari omani, tima mawa kitiijyiri isaikaki imotziki. Ari inkimityaari iijatzi Itomi Atziri inkitawitapaintya mawa kitiijyiri kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Paata aririka jaminakoyiitairo okaatzi jantayiitziri, ari jiyakowintaimi Nínive-jatzi, tima ikimisantairi pairani Jonás jowajyaantanairo ikaaripiroshiriwitaiyani. Jirika saikimotakimiri iiroka janairi Jonás. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Paata aririka jaminakoyiitairo okaatzi jantayiitziri, ari iyakowintaimi tsinani pinkatharitatsiri pairani nampitsiki Sabá, tima opokashitakiri yotaniri pinkathari Salomón, okimisantairi. Jirika saikimotakimiri iiroka janairi Salomón”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Okimiwaitakawo isaikashiritantyaarimi piyari apaani atziri, ipankotsititakawomi jañaantari. Aririka jookawiityaari, awijakowitaa atziri isaikantakari piyari. Ikinawaiwita otzishimashiki, iiro iñi tsika isaiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Impoñaatya inkantashiritai piyari: ‘Nompiyai nopankoki tsika nopoñaaka’. Piyaa piyari, iñaapairi atziri kamiitha opishitaka jañaantari, owaniinka okantaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Impoña jiyaatashitakiri mapirotzirori ipiyaritzi, inkantakiri: ‘Thami aati nopankoki, pintsipatina ampinkathariti’. Jamaki inkaati 7. Ari jashironkaapirotaiya jirika atziri, iiro ikimitaa jashironkaawita pairani kapichiini. Ari pinkimitaiyaari iirokaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iikiro ikinkithatakaatziiri Jesús apatowintakariri, ariitapaaka inaanati otsipatakari iririntzipaini, okatziyapaaka jikokiroki, okaimakaantapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ikantawiitakari: “Ari ariita pinaanati otsipatakari pirintzipaini, okowi oñiimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ari jakanaki ikantzi: “¿Tsika otzimikama pikinkishiritaiyarini iro nonaanatitari, iri nirintzitari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jookotanakiri ikaatzi jiyotaapiintakiri, ikantzi: “Jirikapaini iriitaki nokimitakaantairi nirintzi, irootaki nokimitakaantairi iijatzi nonaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Tima maawoni antanairori ikowiri Ashitairi Inkitijatzi, iriitaki nirintzitaari, irootaki notsirotaari, irootaki nonaanatitaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ipoña ishitowanai Jesús pankotsiki, jatanai inkaarithapiyaaki. Ari isaikapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ipiyowintapaari iijatzi ojyiki atziri. Iñaaki othataka pitotsi, otitapaaka, saikapaaki. Katziyaiyakani atziri irirori inkaarithapiyaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jojyakaawintatziiniri okaatzi ikinkithatakairiri, ikantzi: “Tzimatsi pankiwairintzi jatatsiri impankiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ikanta jookakitakiro iwankiri, tzimatsi ookakitapainchari aatsiki, ipokapaaki tsimiri, jowapaakawo. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tzimatsi pashini ookakitapainchari omapipookitzi, ari ojyookawitanakari thaankipiroini. Tii otontapathatatzi kipatsi, ");
INSERT INTO cpcNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","sampiyashitanaki pankirintsi ishintsitapaaki ooryaatsiri, tii otyaapirotzi oparitha inthomainta. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Tzimatsi pashini ookakitapainchari kitochiimashiki, anaanakiro kitochii ojyookanaki, kamanaki pankirintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Irooma pashini ookakitapainchari okamiithapathatzi kipatsi, saankana ojyookanaki, kithokitanaki maawoni. Tzimayitanai okithoki apaanipaini okaatzi jyookapaintsiri. Apaani jyookapaintsiri kithokipirotanaki, pashini ojyiki piyokiniintanaki, pashini iipiyokiini okithokitanaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kowatsiri inkimathatiro, jowakimpitatya inkimisanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ipoña josampitakiri jiyotaani, ikantziri: “¿Oitama pojyakaawintziri pikinkithatakairi atziripaini?” ");
INSERT INTO cpcNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jakanaki Jesús, ikantzi: “Ishinitaitzimiro iirokaiti piyotairo tsika ikanta ipinkathariwintantai Inkitijatzi, iriima jirikaiti tii ishinitaitziniri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iitarika otzimimotakiri, ari ontzimimopirotairi ojyiki. Iriima kaari otzimimotzi, iikiro iñaatyiiro iiro otzimimopirotairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Irootaki nojyakaawintantawori jiroka, onkantawitya jamini jirikaiti, kamampotaaki inkantya. Ari inkimawityaawo, matakimpita inkantayitya. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Iriitaki ikinkithatakotakiri pairani Isaías-ni, ikantaki: Pinkimawitya, matakimpita pinkantya. Paminawitya, kamampotaaki pinkantya. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tima kisoshiri ikantaka jirikaiti. Ashikimpita ikantaka. Kamampotaaki ikantaka iijatzi. Irootaki kaari iñaantaawo, Kaari ikimanta, Kaari ikinkishiritanta. Tii ikimisantzi, iiro nowawijaakotairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Irooma iiroka kimoshiri pinkantya, tima piñagairo, pikimayitairo iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Iro ikowawitakari pairani Kamantantaniriiti iijatzi kamiithashiriri, iñiiromi okaatzi piñaakiri iirokaiti. Ikowawitaka inkimiromi pikimakiri iiroka. Tima tii iñaatyiina, tii ikimaiyanani iijatzi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pinkimi nonkinkithatakotimiro okaatzi nojyakaawintakiri pankiwairintzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tzimatsi kimirori nokinkithatakotziro impinkathariwintantai Pawa, tiimaita ikimathatziro. Ikanta ipokaki owaaripiroshiritantaniri jowajyaantakaapaakiri ikimisantawitanaa. Iriitaki kimitakawori pankirintsi ookakitapainchari aatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tzimatsi iijatzi thaamintawori noñaani, ikimisantzi thaankiini. Iri kimitakawori pankirintsi ookakitapainchari omapipookitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Tii jiyotakopirotziro ñaantsi, tii ikisashitawo ikimaatsiwintanakawo ikimisantzi, jowajyaantanakiro. Ikimitakawo pankirintzi sampishitaintsiri tii otyaapirotzi oparitha inthomainta kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tzimatsi iijatzi kimawitawori noñaani, iro kantzimaitacha inintawaitziro inthaamintawaitya, ikinkithashiritakotziro jajyaagawo, irootaki ipiyakotantakawori noñaani, tii ikimisantzi. Ikimitakawo pankirintsi ookakitapainchari kitochiimashiki, kaari kithokitatsini. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Tzimatsi pashini kimirori noñaani, ikimisantanakiro. Ityaaryoowintanairo. Iri ojyakawori pankirintsi jyookapaintsiri okamiithatzi kipatsi, ojyikipirotanaki okithoki, pashini ojyiki piyokiniintanaki, pashini iipiyokiini okithokitanaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ipoña japiitakiro Jesús jojyakaawintziniri, ikantzi: “Jiroka ojyari iijatzi ipinkathariwintantai Inkitijatzi, ojyari atziri pankitzirori kamiithakiri trigo. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Okanta tsiniripaiti imagaiyini jatziritipaini iijatzi irirori, pokaki kisaniintziriri jamaki trigo-niro, ipankitakiro itsipataakiro trigo-pirori, piyanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Opoña ojyookanaki trigo-pirori, kithokitanaki. Ari okimitsitakari iijatzi trigo-niro itsipataakirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ikanta jiyotaitakiro, jiyaatashiitakiri ashitawori, ikantaitakiri: ‘Tii opantawo trigo apankitakiri powaniki, ¿iitama otsipatantawori ojyookaki trigo-niro?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ikantanaki ashitawori jowani: ‘Iri pankitakirori kisaniintanari’. Ikantzi jatziriti: ‘¿Pikowima nonthokayitairo trigo-niro?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Jakanaki, ikantzi: ‘Iiro, aamaashitya, ari pinthokakotakiro trigo-pirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ari onkantawatyaata ontsipatyaawo ojyooki, irojatzi osampatantyaari trigo-pirori. Aripaiti nonkantimiri: Pinthatzinkiro trigo-niro, pintayiro. Poyiikitairo trigo-pirori, powayitairo’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ipoña japiitakiro Jesús jojyakaawintakiniri, ikantzi: “Jiroka ojyari iijatzi ipinkathariwintantai Inkitijatzi, okimiwaitakari pankitzirori oryaanikitatsiri okithoki pankirintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Oryaani okantawita okithotyaaniki, iro kantzimaitacha aririka ojyookanaki, anairo pashini pankirintsi, antawo ontiwayitanaki ari iminkoshityaawo tsimiripaini otsimankatapishitaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jiroka pashini jojyakaawintakiri Jesús, ikantzi: “Aririka ipinkathariwintantai Inkitijatzi, ojyakotawo tsinani witsikirori tanta. Aakiro trigo-pani, otsipataakiro shiniyakairori. Aritaki oñaaki oshiniyi otantanipathati”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ari ikantapiintatya Jesús jojyakaawintziro okaatzi jiyotaantziri. maawoni jojyakaawintakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ari imonkaataakari ikinkithatakotakiri pairani Kamantantaniri ikinkithatakotziro ikantakiri Pawa: Nojyakaawintatyiiniri atziriiti onkaati nonkinkithatakotiniriri. Nooñaawontainiri kaari jiyowita pairani owakiraa iwitsikantakari kipatsi irojatzi iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ipoña jawijanai Jesús, jookanairi apatowintakariri, jatanaki pankotsiki. Ari josampitakiri jiyotaani, ikantziri: “Piyotainawo okaatzi pojyakaawintakiri. ¿Iitama ojyakaawintachari trigo-niro itsipatagaitakirori trigo-pirori?” ");
INSERT INTO cpcNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ikantzi Jesús: “Jirika Itomi Atziri iriitaki kimitakariri ashitawori jowani ipankiitakiro trigo-pirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jiroka owaantsi irootaki ojyakaawintawori kipatsi asaikantayitari. Jiroka trigo-pirori iri ojyakaawintacha ipinkathariwintairi Pawa. Irooma trigo-niro iri ojyakaawintziri ikaatzi jashitaari Kaaripirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jirika kisaniintantatsiri pankitakirori trigo-niro iri ojyakaawintacha kamaari. Kimityaawoni joyiipataitziro okithoki trigo, ojyakaawinta aririka onthonkaiya paata kipatsi. Jirikapaini oyiipayitakirori okithoki iri ojyakaawintacha maninkariti. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pikimaki, japatotakaantaitakiro trigo-niro, itagaitakiro. Iro ojyakaawintacha aririka onthonkaiya paata kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jirika Itomi Atziri jotyaantakiri maninkariiti, japatotairi kaaripiroshiritatsiri, tima tii ikowi intsipataiyaari ikaatzi kimisantakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Impoña intagairi kaaripiroshiriri, ari jiraawaityaari jatsikaikiwaitya inkimaatsiwaitaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iriima kamiithashiritaintsiri, shipakiryaa inkantaiya inkimitaiyaari ooryaatsiri. Isaikimotairi Ashitairi tsika ipinkathariwintantzi irirori. Powakimpitatyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ipoña ikantaki iijatzi Jesús: “Jiroka pashini nojyakaawintimiri. Tzimatsi ojyiki kiriiki jimanaitziri owaantsiki. Ikanta apaani atziri iñaakiri, tii okantzi jaanakiri, iijatzi imananairi, tikaatsi inkamanti, ikantashiritanaki irirori: ‘Ontzimatyii namanantiro jiroka kipatsi, ari onkantya nashitantyaariri ikaatzi tzimatsiri janta’. Ipoña ipimantakiro okaatzi tzimimowitariri, jamanantakiro kipatsi. Kimoshiri ikantaka, tima jamanantakotakiri ojyiki kiriiki. Ari okimitari iijatzi ipinkathariwintantai Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ikantzi iijatzi Jesús: “Aririka impinkathariwintantai Inkitijatzi, ikimitari apaani atziri kowatsini jamananti poriryaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Iñaaki poriryaari, ikowapirotaki jayiri. Ipiyanaa inampiki, ipimantapaakiro okaatzi tzimimotziriri, jamanantakiro poriryaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ikantaki iijatzi Jesús: “Aririka impinkathariwintantai Inkitijatzi, ikimitari apaani shiryaawairintzi. Jaaki ojyiki nashiyitachari shima. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ipoña inoshikakotakiri othapiyaaki, jiyoshiiyitakiri kamiithatatsiri. Ikaatzi kaari kamiithatatsini, jookayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ari onkimitaiyaari paata aririka onthonkaiya kipatsi. Impokaki maninkariiti, jiyoshiitairi kamiithashiriri, iijatzi kaaripiroshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Impoña intagaitairi kaaripiroshiriri, ari jiraawaitaiyaari, jatsikaikiwaitya inkimaatsitaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ari ikantzi Jesús: “¿Pikimathatakiroma okaatzi nokantakiri?” Ikantaiyini jiyotaani: “Nokimathatakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ipoña ikantanaki Jesús: “Nojyakaawintiri iwaapatiitari, tzimatsiri jajyaagawo pinayitachari. Jaapiintziro paijatori, jaapiintziro iijatzi owakiraari jajyaagawo. Aritaki inkimitaiyaari iijatzi yotzinkariiti aririka impinkathariwintairi Inkitijatzi, jiyotaantairo itawori pairani, jiyotaantairo iijatzi owakiraataatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ithonkakiro Jesús jojyakaawintakiro okaatzi ikinkithatakotakiri, ari jiyaatanai. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ikinanai inampiki. Jiyotaantayitapai japatotapiintaita. Iyokitzi jowiri ikaatzi kimiriri, ikantaiyini: “¿Iitama matakaakiriri jirika jiyotanitantari, itasonkawintantzi iijatzi? ");
INSERT INTO cpcNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Kaarima jirika itomi kimitapiintzirori inchakota, otomintari María? ¿Kaarima iririntzipaini jirika: Jacobo, José, Simón, iijatzi Judas? ");
INSERT INTO cpcNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Tiima ari akaatzi iritsiropaini anampitawo jaka, iitama pinkatharitakaakiriri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Owanaa ithainkaitakiri, ikisaniintaitanakiri. Iro ikantantanakari Jesús: “Jashi jowiro Kamantantaniri ikimisantaitziri pashiniki nampitsi, irooma inampiki irirori, tii ikimisantaitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Owanaa ithainkimataitakiri Jesús inampiki, irootaki kaari itasonkawintanta. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ikanta pinkathari Herodes iitachari Tetrarca, ikimakotakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ikantziri jimpiratani: “Jirika Jesús iriitaki Juan owiinkaatantaniri. Iri añagaatsiri, piñiiri otzimi ishintsinka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tima iri Herodes aakaantakiriri Juan, joojotakaantakiri, jomontyaakaantakiri. Iro kantakaantakirori iinawitari iririntzi Felipe iitachari Herodías. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Tima ikaminaawitatyaari Juan jirika Herodes, ikantawitari: “Tii okantzi paapithatantiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ari ikowawitaka intsitokakaantirimi, Iro kantzimaitacha ojyiki ipinkathatakiri Juan, jiyotaiyini Kamantantaniri jinatzi. Ithaawantanakari Herodes atziri, ikantashiritzi: “Aririka nontsitokaantakiri, ari inkisaniintaitakina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Okanta imonkaataka kitiijyiri joimoshirinkawitawo itzimantari Herodes. Ipiyotaiyakani ijyininka, joimoshirinkaiyirini. Ari opokapaaki ishinto Herodías, amajyiitapaaki. Ojyiki okamiithatzimotakiri Herodes. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ikantakiro: “Tzimatsirika oitya pinkamitinari, ari nompakimiro. Imapiro, jiyotzi Pawa iiro namatawitzimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ipoña okantziro onaanati: “Pinkantiri inthatzinkakaantiri Juan”. Iro okantantakariri: “Nokowi pamakotakinawo iito Juan samantaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ari jowashiritanakari Herodes, tii ikowawita. Iro kantzimaitacha ikimaiyakirini ijyininka ikantakirori inkaanki. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Irootaki ikantantakari inthatzinkaitiri Juan. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jamaitakiro iito, ipakoitakiro aanakiniro onaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ikanta ipokaiyapaakini jiyotaani Juan, ikitatairi. Ari jiyaatashitanakiri Jesús, ikamantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ikanta ikimaki Jesús kamaki Juan, otitanaka pitotsiki jiyaatiro otzishimashiki. Iro kantzimaitacha ikimakoitakiri tsika jiyaati, shiyaiyanakani ikinaitaki aatsiki, joyaatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iro jaatakotapaakityaami Jesús, iñaapaatzi ojyiki piyowintakariri. Jitakoshiritapaakari, joshinchaaki ojyiki mantsiyatatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Okanta otsiniriityaanaki, ikantzi jiyotaani Jesús: “Asaikatzi otzishimashiki, aritaki tsiniriityaaki. Pimpakairo pikinkithatzi, jiyaataita atziri nampitsiki jowapaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jakanakiri, ikantziri: “¿Iita jatsipitantyaawori jiyaayitai? Pimpiri iiroka jowanawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ikantanaki jiyotaani: “Tikaatsi nompiri naaka. Apa otzimi okaatzi 5 tanta ipoña apiti shima”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ikantzi Jesús: “Pamakinari jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ikantakiri maawoni atziri: “Pisaikaiyini”. Saikaiyanakini atziriiti. Ipoña jaakiro tanta, iijatzi shima, aminanaki jinoki inkitiki, jamananaka, ikantzi: “Paasoonki Ashitanarí, iirokataki pakinawori jiroka noyaari”. Ipoña ipitharyaakiro, ipakiri jiyotaani, jowawijaakiniri irirori atziripaini apatotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ari ikaatzi jowaiyakani maawoni, kimaniintaiyakani. Ipoña japatotairo tzimagaantapaintsiri, jotiyitairo kantziriki, okaatzi 12 jaikitaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kimitaka ikaatzi 5000 shirampariiti owainchari. Tzimitacha tsinani iijatzi iintsipaini owainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ipoña ikantairi Jesús jiyotaani: “Thami pitaiyaawo pimontyagai intatsikironta”. Ikantakiri iijatzi piyowintakariri: “Kantatsi piyaayitai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iro ikinantanakari irirori tonkaariki, jamañaari Ashitariri. Okanta otsiniritanaki, saikaki apaniroini Jesús janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jiwiyaakotaiyaani jiyotaani niyantyaaniki, antawo otamaryaani inkaari, oipiyapiyakotakiri tampiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Okanta okitiijyitzimataki, pokai Jesús janiitantaawo inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tii jiyotawairi, ithaawantawaari jiyotaani, ikaimaiyanakini: “¡Aatsikitaki shiritsiwí!” ");
INSERT INTO cpcNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Iñaanatapairi irirori, ikantziri: “Naaka pokaatsi, tontashiri pinkantya iiro pithaawawaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ari ikantanaki Pedro: “Iirokama Nowinkatharití, pinintakainawo naniitantyaawo naaka inkaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ikantzi Jesús: “Pimpokanaki”. Aniiwitanaka Pedro inkaariki jiyaatashitanakiri isaikaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Iro kantzimaitacha ikinkishiritanakiro Pedro antawo otamaryaani inkaari, ithaawanaki, iro itsitsiyantanakari, ikaimanaki: “Pinkatharí paawaina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jakotashitanakiri Jesús, jaawairi. Ipoña ikantziri: “Kapichimachiini pikimisantakina. ¿Iitama pikisoshiritantari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ikanta jotitapaa pitotsiki, awijainkatanaki tampiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Antawoiti ipinkathatanakiri jiyotaani, ikantanakiri: “Imapirotatya iirokataki Itomi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ikanta jariitaiyakani intatsikironta nampitsiki Genesaret. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iro jaatakotapaakityaami Jesús, jiyotaitawakiri. Ikamantaitakiri maawoni nampitawori janta, jamayitapaakiri mantsiyayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ikantaitakiri Jesús: “Pishinitiri mantsiyari jotirotawakiro kapichiini piithaari, ishintsitantaiyaari”. Ari okantzimaitaka, ikaatzi otirotsitakiriri iithaari, shintsiyitai. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ari ipokaiyakini Fariseo itsipatakari Yotzinkariiti. Ipoñaayitaka nampitsiki Jerusalén. Ikantapaakiri Jesús: ");
INSERT INTO cpcNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Judá-mirinka anaiyini. Iro amitaiyarini akiwaakota tikira owanatyaata, ari okanta jiyotaakairi pairani achariniiti. ¿Iitama kaari jimatantawo piyotaani? Tii ikiwiro jako jowapiintaiyani”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jakanaki Jesús, ikantzi: “Irojatzi paakowintawo jiyotaayitairi pairani achariniiti, tiimaita pantziro jiyotaayitairi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jiroka ikantziri Pawa: Pimpinkathatiri ashitzimiri. Ikantaki iijatzi: Ontzimatyii jowamaitiri kijyimatziriri ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Iro kantzimaitacha pikantapiintaki iiroka: ‘Kamiithatatsi ankantiri ashiyitairi: “Nokajyaakairi Pawa maawoni noiriikiti, iiro okantzi nonishironkatimi”.’ ");
INSERT INTO cpcNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Piyotaantashitakawo jamitaitari pairani, tii piyotaantziro ikowiri Pawa. Irootaki kaari jitakotantari ajyininka ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Thiiyinkari pinaiyini. Iiroka ikinkithatakotaki pairani Isaías, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ipinkathawaantiwitashitana atziripaini. Tiimaita inkinkishiritakotaina kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Aminaashiwaita jotziirowashitana ipinkathawitana, Jiyotaantashiwaitawo jamiyitari irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ikaimakiri Jesús maawoni piyowintakariri, ikantziri: “Pinkimisantaiyini, pinkimathatantyaawori nonkinkithatakotiri: ");
INSERT INTO cpcNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ikaatzi owayitari tii jowaaripiroshiritantzi, irooma okaatzi añaawaiyitziri, iro matzirori owaaripiroshiritantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ipokashitapaakiri jiyotaani okaakiini, ikantapaakiri: “Tii inimotziri Fariseo-paini ikimakimi pikantaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ikantanaki Jesús: “Ashitanari Inkitijatzi, ari inthonkairo kaari ipankitzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Piñaashityaari, tii jiyotaiyini irirori, jojyakari kaari aminatsiri. Ikimitakotakari ikathatawakaa kaari okichaatatsini, tii jiyotzi tsika inkini, apitiroiti imparyai omoonaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ari ikantzi Pedro: “Poñaayinawo okaatzi pojyakaawintakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ikantzi Jesús: “¿Tikiraama otzimimotzimi iiroka piyotani? ");
INSERT INTO cpcNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tiima piyotzi okaatzi owayitapiintari okini ajyiitoki, impoña omishitowairo? ");
INSERT INTO cpcNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Irooma añaawaitiro kaaripirori akinkishiriyitari, irootaki owaaripiroshiritantatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tima ashiriki opoñaayita kaaripirori kinkishiritaantsi, tsitokaantsi, mayimpiritaantsi, kaari kinataantsi, koshitaantsi, thiiyakotaantsi, kijyimataantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irootaki jiroka owaaripiroshiritantatsiri. Irooma iirorika akiwaakota ankowirika oya, tii owaaripiroshiritantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ipoña ikinanaki Jesús nampitsiki iitachari Tiro irojatzi Sidón-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ari opokaki tsinani Canaán-jato, kaari Judá-mirinka iroori. Okantapaakiri: “Nowinkathariti, iiroka icharini pinkathari David-ni. Nokowi pinishironkataina ojyiki ashironkaawaitaka nishinto, opiyarishiritatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ari imairitaki Jesús, tii jakiro. Ipoña ikantaiyini jiyotaani: “Potyaantairo iyaataita, owanaa oñaashirinkakai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ikantanakiro Jesús: “Apa jotyaantakina Ashitanari nonishironkatairi nojyininka Israel-mirinkaiti, ikaatzi ojyakariri oijya ipiyaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ari otziirowanaka tsinani, okantanakiri: “Pinkatharí, pinishironkataina naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ikantanakiro irirori: “Paata tsinani. Tima ikantaitaki pairani: ‘Tii aapithatziri jowanawo iintsiti ampiri otsitsi joyaawo’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Akanakiri iroori, okantziri: “Imapiro pikantakiri Pinkatharí. Iro kantzimaitacha, jowapiintamachiitawo otsitsi jowaryagaitziro owanawontsi otapinaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jakanairo Jesús, ikantziro: “Tsinaní, imapiro pikimisantai iiroka. Irootaki nimatantyaawori pikowakotakinari”. Apathakiro awijakotanai ishinto. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ipoña jawijaki Jesús ikinayitaki othapiyaaki inkaari Galilea. Irojatzi itonkaantanakari otzishiki, ari isaikapaakiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ari ipokashitakiri ojyiki atziri, jamayitakiri kantawaiyitachari imantsiyari: ithoriwaitatsiri, kaari okichaatatsiri, masontzipaantiri, pijaponthokiri, maawoni. Ithonkiri joshinchaayitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iyokitzi jowaitanakiri Jesús iñaitakiri jiñaawaitakagairi masontzipaantiri, janiitakaayitairi kisopookiri, ithoriwaitatsiri iijatzi, jaminakaayitairi kaari okichaatatsi. Ikantaiyini atziriiti: “Imapiro ikamiithataki Pawa, iriitaki pinkathariwintairiri Israel-mirinkaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ipoña Jesús japatotakiri jiyotaani, ikantakiri: “Owanaa nitakotakari atziriiti, tima mawa kitiijyiri isaikaiyakini jaka ikimisantana, tikaatsi jowaiya. Aririka jiyaatashitaiya, ari aakiri itajyi iirorika jowanaa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ikantaiyini jiyotaani: “Pamini, asaikatzi jaka otzishimashiki. ¿Tsikama ayika owakaiyaariri? Ojyiki ikaataiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ari josampitziri Jesús jiyotaani: “¿Tsikama okaatzi tanta tzimatsiri?” Ikantzi jiyotaani: “Tzimatsi okaatzi 7, tzimitacha iijatzi shimaaniki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ipoña ikantaitakiri ikaatzi piyotainchari: “Pisaikaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jaakiro tanta itsipataakiri shimaaniki, ipaasoonkiwintakiri. Ipoña ipitoryaakiro tanta, ipayitakiri jiyotaani, jowawijaakiniri piyotainchari atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Owaiyakani maawoni, kimaniintaiyakani. Ipoña japatotairo tzimagaantapaintsiri, ijaikitai okaatzi 7 kantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kimitaka ikaatzi 4000 shirampari owainchari. Tzimitacha tsinanipaini iijatzi iintsipaini owainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ipoña ikantanai Jesús: “Ari owaiyakani, kantatsi piyaayitai”. Ari jotitanaa Jesús pitotsiki, montyaakotanaki iipatsitiki Magdala-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ari ipokaiyakini Fariseo itsipatakari Saduceo, ikowawitaiyani inkompitakaiyaarimi Jesús inkini jiyakowintirimi. Ikantawitapaakari: “Incha pintasonkawintanti niyotantyaari imapiro opoñaawo pitasorinka inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jakanaki Jesús ikantzi: “Pikantapiintaiyini iiroka aririka piñiiro onkiraityai otsiniriityaanai: ‘Osaryaamanaatyi oñaatamani’. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Irooma piñaamanairo minkori onkiraityai inkitiki, pikantzi: ‘Omparyaatyi inkani’. Piyotakowitawo inkiti, piyotakotziro iijatzi aririka omparyai inkani. Tii piyotzimaitawo piñaawitari jaka kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tii pikamiithataiyini iiroka, thainka powakiri Pawa, irootaki pikowantaiyarini piñiina nontasonkawintanti, iiromaita noñaayimiro. Apa piñiiro ojyawoni awijyimotakiriri pairani Jonás”. Ari jiyaatanai Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ikanta jariitaka jiyotaani Jesús intatsikironta, tii jaanaki itantani, imaijantanakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ikantzi Jesús: “Paamaiyaawo shiniyakairori itantani Fariseo iijatzi jashi Saduceo-paini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ari josampitawakaanaka jiyotaani, ikantawakaiyani: “¿Iitama ikantantawori jiroka? ¿Irooma ikantantari tii amaki tanta?” ");
INSERT INTO cpcNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yotaki Jesús ikantawakaari jiyotaani, ikantziri: “Tikira pikimisantapirotzi iirokaiti, irootaki pikantantari: ‘Tii amaki tanta’. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Tikiraama pikimathataiyironi? Chapinki otzimawita tanta okaatzi 5, nowakaayitaka 5000 shirampari. Poyiitairo tzimagaantapaintsiri. ¿Tsikama okaatzi kantziri poyiitairi? ");
INSERT INTO cpcNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Iijatzi okimita tzimatsiri chapinki 7 tanta, nowakaaka 4000 shirampari. ¿Tsikama okaatzi kantziri poyiitairi? ");
INSERT INTO cpcNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Iitama kaari pikimathatantawo iiroka? Tii iro nonkinkithatakoti jowaitari tanta. Aña nokantatziimi: ‘Paamaiyaawo shiniyakairori itantani Fariseo iijatzi jashi Saduceo’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ari ikimathatanakiro jiyotaani, tii iro inkinkithatakoti Jesús shiniyakairori tanta, jojyakaawintatziiro okaatzi jiyotaantziri Fariseo iijatzi Saduceo. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ipoña ikinanaki Jesús janta Cesarea-ki, irootaki inampi Filipo. Ari josampitakiri jiyotaani, ikantziri: “¿Iitama ikinkishiritakoitariri Itomi Atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jakaiyanakini, ikantzi: “Tzimatsi atziri kantatsiri, ‘Juan owiinkaatantaniri piriintaacha’. Ikantzi pashini, ‘iri koñaataatsi Elías’. Ikantzi pashini ‘iri Jeremías-ni’. Tzimatsi kantatsiri iijatzi, pashini Kamantantaniri pinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ipoña ikantziri jiyotaani: “Iiroka. ¿Tsikama pikantaiyinika?” ");
INSERT INTO cpcNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jakanaki Simón Pedro, ikantzi: “Iirokataki Cristo Itomi Pawa Kañaaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ikantzi Jesús: “Imapiro pikantaki Simón itomi Jonás, kaari atziri yotakaimironi jiroka, iri Ashitanari Inkitijatzi yotakaakimirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ari niitaimi naaka Pedro, iro mapi ojyakaawintacha piwairo. Tima mapi pinkimitaiya, ari niwitsikairo nopanko. Inkaati kimisantaatsini paata, iri ojyayityaawoni pankotsi. Iiro jimatziro impiyakaashitaiyaari nampitawori sarinkawini. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iri pojyaari aamaakowintawori ashitakowo pankotsi, kantatsi jashitaryiiro, jashitiro, jintsiriitiro shintsiini. Iro pankotsi ojyakaawintacha tsika impinkathariwintantai Inkitijatzi. Tima inkaati pishinitairi iiroka jaka, iriitaki ishinitaiti inkitiki. Iriima inkaati kaari pishinitai iiroka jaka, iiro ishinitaitziri iijatzi inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ipoña ikantanakiri Jesús maawoni jiyotaani: “Paatara pikamantantzi, pinkanti: ‘Iriitaki Cristo jirika Jesús’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ipoña Jesús ikamantakiri jiyotaani, ikantziri: “Irootaintsi aati nampitsiki Jerusalén, antawoiti inkimaatsitakaina ijiwaripirori Ompiratasorintsitaari, ijiwari Yotzinkariiti, ari intsitokakaantinari. Iro kantzimaitacha awijawitatya mawa kitiijyiri ari nañagai iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ikanta Pedro, jaanakiri Jesús jantyaatsikiini, ikantakiri: “Pinkatharí, tii inimotana pikantziri, tii nokowi awijyimotimi jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ari ipithokanaka Jesús, ikantanakiri: “Piyaati Satanás. Tima tii poshiritawo iiroka ikowakaanari Pawa, apa pikowashitawo ikowapiintakiri atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ikantanakiri Jesús maawoni jiyotaani: “Tzimatsirika kowatsiri intsipatina, jowajyaantairo ikowashitari, onkantawitya impaikakoitirimi, intsipatina. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iitarika itakowaitachari jantayitziro inintashiyitari, ari impiyashitaiya. Iriima kamawintinani jantayitanairo nokowakairiri naaka, aritaki jawijakoshiritai. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tima aminaawaitashita iñaitziro otzimimotantzi ajyaagawontsi jaka kipatsiki, ompoña jaminaashitaiyaawo añaamintotsi. ¿Kantatsima impinakowintaitya iiro iñaantaitawo impiyashitaitya? ");
INSERT INTO cpcNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ari impiyi paata jirika Itomi Atziri jamairo jowaniinkawo Ashitariri, intsipataiyaari maninkariiti, iri pinatapaironi okaatzi jantaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tyaaryoo, tzimatsi pikaatzi jaka, tikira pikamiita ari piñaakiri Itomi Atziri impinkathariwintantai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Okanta awijaki okaatzi 6 kitiijyiri, ipoña Jesús jaanakiri Pedro, Jacobo, Juan iririntzi Jacobo. Itonkaiyanakini otzishiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ari ipashinitzimotakiri jiyotaani, ishipakiryaanaki ipooki, jojyanakari ooryaatsiri, ari okimitanakari iithaari kitamaaniki okantanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iñaatziiri Moisés-ni, ipoña Elías ikinkithawaitakairi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ikaimotanakiri Pedro, ikantzi: “Pinkatharí, imapiro okamiithatzi pamakina jaka. Kamiitha niwitsikimi mawa pankojyitantsi: apaani pashitya iiroka, apaani jashitya Moisés, jashitya apaani Elías”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Iñaawaiminthaitzi, opamankapaakiri minkori, shipakirya okantapaaka. Ikimatzi iñaawaitaitanaki minkoriki, ikantaitzi: “Notomi jinatzi jirika nitakokitakari, ojyiki nokimoshiriwintakiri. Pinkimisantairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ikanta ikimaiyakironi jiroka ñaantsi, oiyotaiyanakani isaawiki, antawoiti ithaawaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iro kantzimaitacha Jesús ipokashitapairi jiyotaani, ipampitapaakiri, ikantziri: “Pinkatziyanai, iiro pithaawaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jaminawitanaa, tikaatsi iñaanai, apaniroini ikatziyaka Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ikanta joirinkaiyaani otzishiki, ikantakiri iiro ikamantantziro iñaakiri irojatzi paata aririka jañagai. Tima jirika Itomi Atziri ari jañagai inkamawitatyaarika. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ari josampitakiri jiyotaani, ikantziri: “¿Iitama ikantakotziri Yotzinkariiti ikantaiyini: ‘Aririka impokimataki Cristo, iri iiwatapaintsini Elías impoki?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jakanaki Jesús, ikantzi: “Imapirotatya ikantziri, iriitaki iiwatapaintsini Elías impoki, jotampatzikatantapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pinkimi nonkanti naaka: Ariiwitaka Elías, tiimaita jiyotaiyawakirini, ojyiki jowasankitaakiri. Ari inkimitaitiri iijatzi Itomi Atziri, ojyiki jowasankitaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ari jiyotaiyanakini jiyotaani iri ikinkithatakotzi Juan owiinkaatantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ikanta jariitaiyaani ipiyotaiyani atziri. Ari ipokakiri atziri. Jotziirowashitapaakari Jesús, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Pinkatharí, pitakotainari notomi ojyiki ikamimawaitaki, antawoiti ikimaatsiwaitaka, ojyiki itaawaitapiinta, ipiinkawaitzi jiñaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Namawitakanari piyotaani, jowawijaakotainari. Tiimaita jimatziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ari jakanaki Jesús, ikantanaki: “Tiitya pikimisantzi iiroka, pikinashiwaitaka. ¿Tsikapaitima piyotai? Pamakinari iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ikisanakiri piyari, jatanaki. Ari ishintsitanairi iwankari. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikanta jiyotaani Jesús, josampitairi apaniroini, ikantairi: “¿Iitama kaari nimatantari nowawijaakotiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ikantzi Jesús: “Iro kaari pimatantari tima tikira pikimisantapirotzi. Pinkimi nonkanti: Aririka pinkimisantaniinti, kantatsi pinkantiro otzishi: ‘Pishirinki’. Ari oshirinkaki. Tikaatsi kompitzimotimini aririka pinkimisantapiroti. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iro kantacha pinkowirika poshinchiiri ojyakariri jirika iwankari, ontzimatyii pamañaari tyaaryoopiroini Pawa, pintziwintyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ikanta isaiki Jesús nampitsiki Galilea, ari ikantakiri jiyotaani: “Irootaintsi impithokashitaityaari Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ari intsitokaitiri. Iro awijawitatya mawa kitiijyiri, aritaki jañagai iijatzi”. Antawoiti jowashiritanaka jiyotaani ikimakiri ikantaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ikanta jariitaka Jesús nampitsiki Capernaum, ari ipokakiri kowakotantatsiri kiriiki jashitakaitawori tasorintsipanko, josampitapaakiri Pedro: “¿Ipinatziroma yotaimiri jashitakaitawori tasorintsipanko?” ");
INSERT INTO cpcNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ikantanaki Pedro: “Ipinatziro”. Ikanta ipiyapaa pankotsiki, iri thaawakotapainchari Jesús josampitawairi: “¿Iitama pikinkishiritari iiroka Simón? ¿Iitama ikowakotantziri pashinijatzi pinkathariiti? ¿Iriima ikowakoyitzi ijyininkapirori? ¿Iriima ikowakoyitzi ariitzinkari atziri kaari ijyininkata?” ");
INSERT INTO cpcNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ari jakanaki Pedro, ikantzi: “Iri ikowakotzi ariitzinkari”. Ikantzi Jesús: “Ari okanta. Tii okowapirota impinatiro ikaatzi ijyininkapiroitari. ");
INSERT INTO cpcNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Tiimaita nokowi inkisaniintawaitya kowakotantatsiri kiriiki. Piyaati pinkachaati inkaariki. Aririka pinoshikaki apaani, paminapaantitiri, ari piñiiri kiriiki. Paanakiniri kowakotantatsiri, pimpiri. Iriitaki pimpinawintyaari iiroka iijatzi naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ikanta japatotairi jiyotaani Jesús, josampitakiri, ikantziri: “Aririka impinkathariwintantai Inkitijatzi. ¿Iitama ñaapirotachani intsipatyaari impinkathariti?” ");
INSERT INTO cpcNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ikaimaki Jesús apaani iintsi, katziyapaaka niyankiniki isaikaiyakini irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ikantzi Jesús: “Iirorika pawintaanaari Pawa, pojyakotaiyaari ikanta jirika iintsi, iiro piñiiro impinkathariwintantai Inkitijatzi. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tima jirika iintsi tii jiyotzi jasagaawintawaitya. Iitarika ojyakotaiyaarini, iriitaki ñaapirotaachani impinkathatairi Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iitarika pairyaanari ikimisantaana, jaawakimi kamiitha ojyariri jirika iintsi, naakataki jaawaki kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Iitarika antakaakirini kaaripirori kimitaariri jirika iintsi ikimisantaana, kamiithawaitakimi inthaitiniri mapi ikintsiki, jowiinkaitakiri ochiinkaatzi inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Imapiro onkowiinkati jaka kipatsiki. Iñaiti ojyiki antayitironi kaaripirori. Iro kantacha ari jowasankitaitakiri inkaati antakaantakironi. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Iroorika pako, iroorika piitzi pantantakawori kaaripirori, powajyaantairo, pinkimitakaantiro pinthatzinkakityiiromi, tima iro kowapirotacha pawijakoponthokitai. Tii okamiithatzi otzimawita apiti pako, apiti piitzi, impoña patsipitaiyaawo paampari paata pintagaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iroorika poki pantanta kaaripirori, powajyaantairo, pinkimitakaantiro pinkithoryaatyiiromi, iro kowapirotacha pawijakopityakitai. Tii okamiithatzi otzimawita apiti poki, impoña jookaitaimi paata opaampaporinthaatzi sarinkawiniki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Paamaakowintya pimanintzirikari ojyanaariri jirika iintsi. Tima ikimpoyaawintziri maninkariiti nampitawori Ashitanariki Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iro ipokantakari Itomi Atziri jowawijaakoshiritairi ikaatzi piyawitainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pinkimi nojyakaawintimiro. Tzimatsi piratachari ikaatzi 100 oijya. Impoña impiyagaantaka apaani, tzimanai 99 joijyati. Ari jookanakiri pashini, jataki otzishimashiki jaminaminatairi piyainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Aririka iñiiri antawoiti inthaamintya jagairi piyawitainchari. Antawoiti inkimoshiriti, anaanakiro ikimoshiriwintziri kaawitachari 99 kaari piyachani. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ari ikimitari iijatzi Ashitairi Inkitijatzi, tii ikowi impiyagaantawaitya apaani ojyanaariri jirika iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Aririka piñiiri pijyininka jantzimotimiro kaaripirori, piyaatashitiri, pinkinkithawaitakairi apaniroini, poñaayiri okaatzi ikinakaashitakari. Aririka inkimisantakimi, pimatairi, pikimitakaantaari iriirikami pirintzipirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Irooma iiro ikimisantzimi, paanaki pashini kimisantzinkari, iirorika apiti, iri pintsipatyaari pinkaminairi. Iro pimonkaatantyaawori ikantaitziri: Intzimirika iyakowintaari, ontzimatyii intzimi mawa atziri, tiirika, apiti ñaakotakirini okaatzi ikinakaashitakari, kamiithatatsi jowasankitaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Iirorika ikimisantzimi, pinkamantiri ikaatzi apatotapiintachari. Iirorika ikimisantzi, pojyakaantiri kaari pijyininka, ikimitakotakari kowakotziriri kiriiki ijyininka. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Iitarika pishinitairi iiroka jaka, irijatzi ishinitaitiri janta inkitiki. Iriima inkaati kaari pishinitai iiroka jaka, iriitaki kaari ishinitaitzi janta inkitiki. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pinkimi nonkanti iijatzi: Aririka pinkaati apiti, aririka ojyawakaiya pikinkishiritani, ari pinkowakotiri Ashitairi Inkitijatzi, ari jimatakimiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tsikarika japatotaiya apiti atziri, iirorika mawa ipairyaana ikimisantaana, ari nosaikitari naaka janta notsipatari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ari ipokapaaki Pedro, josampitapaakiri Jesús, ikantziri: “Pinkatharí, aririka ontzimi jantzimotinari nojyininka, ¿tsikama onkaati nompiyakotiri? ¿Arima onkaati 7?” ");
INSERT INTO cpcNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jakanaki Jesús, ikantanakiri: “Iiro okantzi pimpiyatantya. Tima tii apa pimpiyakotiri onkaati 7, ojyiki papiipiintiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Aririka impinkathariwintantai Inkitijatzi, iroowaitaki jantziri pinkathari ikowakotziri jompiratani impinatairi jiriiwitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ikanta ikowakotziri iriiwitatsiri, ari ipokapaaki iriiwipirotatsiri ojyiki kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tikaatsi jayi impinatairiri. Ari ikantanaki pinkathari: ‘Paanakiri jirika atziri, iina, itomipaini, iijatzi okaatzi tzimimotziriri, pimpimantiri. Nagaitaa kiriiki ikaatzi jiriiwitanari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ikanta ikimawaki ompirataari, jotziirowashitanakari pinkathari, ikantanakiri: ‘Iiro pipimantana, poyaakotawakina kapichiini, aritaki nompinataimi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ikanta jirika pinkathari inishironkatairi jompiratani, ikantzi: ‘Aritaki, tii piriiwitaana’. Ipiyakotairi okaatzi jiriiwitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ikanta jiyaatai ompirataari, itonkiyotakari aatsiki iriiwitziriri irirori kapichiini. Joirikakintsitawakiri, ikantziri: ‘Pimpinatina piriiwitanari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ari jotziirowashiwitanakari, ikantziri: ‘Poyaawakina kapichiini aritaki nompinataimi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tii ikowi, jaanakiri, jomontyaakaantakiri, ikantziri: ‘Aririka pimpinataina piriiwitana, ari nomishitowakaantaimi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Iro kantacha jiñaakiri ikaataiyini, tii inimotanakiri, jataki ikamantakiri pinkathari. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ikanta pinkathari ikaimakaantakiri, ikantakiri: ‘Kaaripiroshiri pinatzi iiroka. Nopiyakotaimiro iiroka piriiwitanari pikamitakina’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ari pinkantantimi iiroka, pinishironkatanti. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Antawo ikisanaka pinkathari, jomontyaakaantakiri, ikantziri: ‘Aririka pimpinataina iiroka, ari nomishitowakaantaimi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iro jantairi iijatzi paata Ashitanari Inkitijatzi, iirorika pinishironkayitairi pijyininka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ikanta ithonkanakiro Jesús jiyotaantzi Galilea-ki, jataki intatsikironta Jordán-ki irojatzi Judea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ipiyowintaitawaari. Joshinchaapai ojyiki mantsiyari janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ari ipokashitakiri Fariseo-paini, ikowi inkompitakaiyaarimi, josampitapaakiri ikantziri: “¿Jesús, shinitaantsitatsima jookashiwaityaawo iina atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ari jakanakiri irirori, ikantanakiri: “¿Tiima piñaanatakotziro owakiraa jiwitsikantaitakari atziri? ¿Tiima jiwitsikaitakiri shirampari iijatzi tsinani?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ikantaitaki pairani: Ari jookawintairi shirampari ashitariri, jayi iina, Apaani inkantanaiya iwathaki jaawakaana. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Irootaki iiro okantanta jookiro atziri itsipataakaakariri Pawa, tima apaani ikantanaa, iiro okantzi jookawakaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ipoña josampitziri ikantzi: “¿Iitama josankinatantawori pairani Moisés, ikantaki: Aririka jookawakaitya, ontzimatyii impaitiri osankinarintsi jookawakaantyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ikantzi Jesús: “Okantakaantziro tii pikimisantanitzi, irootaki ishinitantzimirori Moisés. Tii ari onkantya pairani owakiraa iwitsikantanakari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pinkimi nonkanti naaka: Ikaatzi ookashiwaitawori iina impoña jagai pashini, imayimpiritaki. Irooma omayimpiritirika iinantaitari, kantatsi jookaitiro. Itzimirika ayirori tsinani ookaawo, imayimpiritaki irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ipoña ikantzi jiyotaani: “Aririka okanta, tiitya okamiithatzi jagaiti iinantaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ari jakanakiri Jesús, ikantziri: “Iriirika Pawa kowakaimironi, aritaki pinkimathatakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Tzimatsi kantachari iiro okantanta jaayiti iina atziri. Tzimatsi atziri owa itzimapaaki ari ikantsita iiro okantzi jayi iina. Tzimatsi pashini jaakithokitaitziri iiro okantzi jayi iina. Tzimatsi iijatzi kowatsiri isaikashiwaitya, tima ityaaryoowintatziiri pinkathariwintantatsiri inkitiki. Kowatsiri jimatiro nokantakiri, jantiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ipoña jamaitapaakiniri Jesús iintsipaini, ikantaitapaakiri: “Pamanakotinari niintsiti, potzimikapatziitotiri pintasonkawintiri”. Ari ikantzi jiyotaani Jesús: “Iiro poñaashirinkiri Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ari ikantzi Jesús: “Pishinitiri iinchaaniki impokashitina. Iiro pithañaana. Tima inkaati kimitaiyaarini irirori, iriitaki ñaagaironi ipinkathariwintantai Inkitijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ikanta Jesús jotiropatziitoyitakiri iintsipaini, jatanai. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ari ipokaki mainari, josampitapaakiri Jesús, ikantziri: “Kamiithari yotaantanirí. ¿Iitama nantairi noñaantaiyaawori kañaanimintotsi?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ari jakanaki Jesús, ikantzi: “¿Iitama pikantantanari ‘kamiithari?’ Tikaatsi kamiithatatsini jaka, apaniroini ikantakaawo Pawa ikamiithatzi. Pinkowirika piñagairo kañaanimintotsi, pimonkaatairo Ikantakaantaitani”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ikantzi irirori: “¿Otzimika?” Ari ikantzi Jesús: Iiro pitsitokantzi. Iiro pimayimpiritzi. Iiro pikoshitzi. Iiro pithiiyakotanta. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Pimpinkathatiri ashitzimiri. Pitakotaiyaari pijyininka pinkimitakaantairi pitakotapiinta iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ari ikantzi mainari: “Nimatakiro maawoni jirokapaini, irojatzi nitanakawo pairani iinta niryaanitapaakiini. ¿Iitama kowityaachari iroñaaka?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ikantzi Jesús: “Pikowirika pinkamiithashiriti, piyaati pipankoki, pimpimantiro maawoni tzimimotzimiri, pimpayitiri ashironkainkari, inkitiki pinintaawaitaiya. Aririka pimatakiro pimpokanaki, poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ikanta ikimaki mainari, owashiri ikanta ipiyanaawo, tima ajyaagantzinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ipoña Jesús ikantanakiri jiyotaani: “Antawoiti impomirintsityaawo ajyaagantachari impinkathariwintairi Inkitijatzi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Iikiro ikantatzi: “Tima iiro okantzi intyi piratsi camello imooki kithapi, iro owatsipiro ompomirintsitya intyi ajyaagantzinkari ipinkatharitai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ikanta ikimaki jiyotaani, iyokitzi ikantanaka, ikantaiyini: “¿Iitatyaakama awijakoshiritaatsini?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jaminaminthatanakiri Jesús, ikantziri: “Iirotya jimataajaitziro apaniroini atziri, iriima Pawa tikaatsi pomirintsitzimotyaarini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ari jakanaki Pedro, ikantanaki: “Jirika nokaataiyakini nokowi noyaatimi, nookayitanakiro maawoni tzimimotanari. ¿Iitama impinayiitainari paata?” ");
INSERT INTO cpcNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jakanaki Jesús, ikantzi: “Aririka owakiraatai paata kipatsi, impinkathariwintantai Itomi Atziri, inkimitaiyaari pinkathari isaikantawo owaniinkatachari isaikaminto. Ari pinkimitaiyaari iijatzi iirokapaini pimpinkathariwintairi maawoni chariniyityaarini Israel-ni, ikaataiyini 12 jinashitaiyani. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tima ikaatzi oyaatakinari, jookawintanakiro ipanko, iririntzi, iritsiro, ashitariri, iina, iriintsiti, iipatsiti. Aritaki iñaayitairo ontzimimotairi ojyiki, tima iriitaki pairyaayitanari. Irijatzi ñaayitaironi kañaanimintotsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Tzimatsi itayitakawori iroñaaka, iri ñiironi jimpoiyitai. Tzimayitatsi iijatzi impoiyitatsiri iroñaaka, iri ñaayitironi jitaiyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Aririka impinkathariwintantai Inkitijatzi, iriiwaitaki ikanta atziri tzimatsiri ichochokimashiti. Jataki amaityaaki jamini antawaitatsini iwankirimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ikanta jiñaaki kowatsiri jantawaiti, ikantakiri: ‘Aririka pitanatyaawo pantawaiti iroñaaka irojatzi jyiitiini, nompinatimi apaani kiriiki’. Ikantaiyini antawaitatsini: ‘Kamiithataki’. Jatanaki jantawaiti pankirintsimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ikanta ijinokiityaapaaki ooryaatsiri, iijatzi ipiyanaa ashitawori iwankirimashi. Iñaapai pashini saikashiwaitachari, ikatziyaiyaani. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ikantapaakiri: ‘Aririka piyaati pantawaiti nowankirimashiki, ari nompinapirotakimi’. Ari jiyaataki jantawaiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ari ikimitaakiro itampatzikatapaaki ooryaatsiri, iijatzi itainkanaki ooryaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ari ikimitakiro iijatzi otsiniriityaanaki, iñaapai saikashiwaitachari atziri, josampitapaakiri: ‘¿Tikaatsima pantawairi pisaikashiwaitantari kitiijyiriki?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ari ikantaiyini: ‘Tikaatsi antawaitakainani’. Ikantzi irirori: ‘Piyaati pantawaiti nowankirimashiki, ari nompinapirotakimi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Okanta otsiniritanaki, ashitawori iwankirimashi, ikantakiri owiriri iiriikiti: ‘Pinkaimiri maawoni antawaitatsiri pimpinatiri. Iri pitawatya pimpinatiri impoitapaintsiri jantawaitaki, irojatzi pimatantatyaariri itakawori amaityaaki’. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ikanta ipokaki impoitapaintsiri jantawaitzi, kapichiini jantawaitaki, iro kantacha ipinaitakiri apaani kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ipokaiyakini itakawori amaityaaki jantawaitaki, iñaajaantzi impinapiroitiri irirori. Aña tii, apaanimachiini kiriiki ipinaitakiri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ikanta ipinawiitakari, ikisanakiri ashitawori jantawairi, ");
INSERT INTO cpcNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ikantanakiri: ‘Tii jantawaipirotzi impoitapaintsiri, iro kantacha imonkaatakina pipinatakinari, naaka kimaatsipirotakariri ooryaatsiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ari ikantzi ashitawori iwankirimashi: ‘Ajyininká, nopinatakimi kamiitha, ¿tiima nokantsitakimi amaityaaki nompinatimi apaani kiriiki? ");
INSERT INTO cpcNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Jirika piiriikiti nompinatimiri, piyaatai pipankoki. Naaka nintashitacha nompinatiri apaani kiriiki impoitapaintsiri jantawaitzi, ");
INSERT INTO cpcNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Iiroma okantzi nompinatiri jirikapaini nonintashitari naaka? ¿Pikisaniintakotatyaanawoma nonishironkatantzi?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Tzimayitatsi itayitawori, iri ñiironi jimpoiyitai. Tzimayitatsi iijatzi impoiyitatsi, iri ñiironi jitaiyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ikanta itonkaanaki Jesús jiyaatiro Jerusalén-ki, jaanakiri 12 jiyotaani ikinakaanairi aatsiki, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Aatatzi Jerusalén-ki. Ari jaakaantaitiri Itomi Atziri, jayiri ijiwari Ompiratasorintsitaari, intsipatatyaari Yotzinkariiti, iri yakawintirini intsitokaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Irootaki jaantanatyaariri atziri kaari ajyininkata. Ari impajawaitaitiri. Impoña impaikakotaitiri. Iro awijawitatya mawa kitiijyiri, ari jañagai iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Okanta iina Zebedeo opokashitakiri Jesús, otsipatakari otomipaini: Jacobo iijatzi Juan. Otziirowashitapaakari, okantapaakiri: “Nokowi pinishironkatina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ari josampitanakiro, ikantziro: “¿Iita pikowakotanari?” Okantzi iroori: “Tima irootaintsi pimpinkatharintsiti, nokowi intsipatimi notomi impinkathariwintanti, isaikimotimi apaani pakopiroriki, iriima pashini isaiki pampatiki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ari ikantanaki Jesús: “Tiitya piyotziro oita pikowakotanari. Ojyiki nonkimaatsityaari naaka. ¿Arima pamawitakiro iiroka pinkimaatsitya ojyiki? ¿Arima pojyatyaana nonkami naaka?” Ari ikantaiyini: “Aritaki nimatakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ikantanaki Jesús: “Imapiro, irootaintsi pinkimiro onkaati nonkimaatsityaari naaka. Irooma pintsipatina ampinkathariwintanti pisaiki apaani nakopiroriki, pashini nampatiki, tii naaka yotironi iita nontsipatyaari, apa jiyotzi Ashitanari iitarika ikajyaakaayitakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ikanta ikimaki pashini jiyotaani, ikisanakiri Juan iijatzi Jacobo. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ari japatotairi Jesús jiyotaani, ikantziri: “Piyotaiyini iiroka tsika ikanta ipinkatharitzi kaari ajyininkata, owanaa jompiratanta. Ari ikimitari iijatzi ñaapirotachari ipinkathaitziri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Irooma iirokaiti, aririka pinkowi piñaapirotya, pojyakotyaari ikanta ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iroorika pinkowi pijiwatakaanti, iri pojyakotya ikanta ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tii iro impokantyaari Itomi Atziri jompiratantya, iro ipokantakari jojyakotyaari ompirataari, inkamawintanti, iri pinakowintantatsini, jookaakowintairi maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ikanta jawijanaki Jericó-ki, ojyiki atziri oyaatanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ari isaikaki aatsinampiki apiti kaari okichaatatsini. Kimaki irirori, ikantaitzi: “Ari inkinapaaki Jesús jaka aatsiki”. Irootaki ikaimantanakari, ikantzi: “¡Pinkatharí, icharini David-ni, pinishironkataina naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ojyiki ikisawiitanakari. Tii imairitzi, iikiro ikaimanakitzi shintsiini: “¡Pinkathari, icharini David-ni, pinishironkataina naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ari ikatziyapaaka Jesús, ikaimakiri, ikantziri: “¿Iita pikowiri nantzimotimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ikantaiyini irirori: “Pinkatharí, nokowi naminawaitai kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Antawoiti jinishironkatanakiri Jesús jirika kaari okichaatatsini, ipampiyookitakiri irookiki. Aminawaitanai kamiitha, joyaatanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ari okaakitzimatapaaki jariitantyaari Jerusalén-ki. Ariitaiyakani Betfagé-ki omontiminthatakari otzishi Olivo. Ari jotyaantakiri Jesús apiti jiyotaani, ");
INSERT INTO cpcNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikantakiri: “Piyaati nampitsiki amontitakari, ari piñiiri inthatakotya burro ontsipatatyaari oryaaniti. Pinthataryaakotiro, pamakinawo. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tzimatsirika osampitawakimini, pinkantiri iiroka: ‘Ikowatziiro pinkathari. Aritaki joipiyaimiro’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ari imonkaatari josankinatakiri pairani Kamantantaniri, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Pinkamantairi maawoni Jerusalén-jatzi: Aatsikitaki Piwinkathariti ipokashitakimi, Tsinampashiri ikantaka, ityaakaakari burro Iwonkiri jinatzi burro, iintsiti piratsi jaakagaitziri tinari. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ikanta jotyaantakiri apiti jiyotaani, jimatakiro okaatzi ikantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Jamakiro burro otsipatakari oryaanitsiti. Jowankiitakiniri manthakintsi imitzikaaki inkini intyaakaityaawo. Ityaakaanakawo Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ikanta atziripaini piyotainchari janta, joomaankashitakiri imanthaki aatsiki tsika inkinanaki. Tzimatsi pashini chikayitanaintsiri inchashi joomaankashitiriri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ikaatzi atziri iiwataintsiri, iijatzi oyaatakiriri itaapiiki, ikaimaiyini, ikantzi: ¡Thami apinkathatairi icharini David-ni! ¡Tasonkawintaari jinatzi, tima Pinkathari aitziri otyaantakiriri! ¡Aatsikitaki Awinkatharipirotyaari! ");
INSERT INTO cpcNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Irojatzi jariitantapaakari Jesús nampitsiki Jerusalén. Ari josampitawakaanaka nampitawori, ikantaiyini: “¿Iitaka jirika?” ");
INSERT INTO cpcNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tzimatsi atziri kantanaintsiri: “Iriitaki Jesús Kamantantaniri, iri poñaachari Nazaret-ki saikatsiri Galilea-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ikanta Jesús, tyaapaaki tasorintsipankoki. Jomishitowapaakiri pimantayitatsiri iijatzi ikaatzi amanantayitatsiri. Jotatsinkayitapaakiro jowantayitariri kiriiki, ari ikimitaakiro iijatzi tsika jowaitziri shiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ikantapaakiri: “Okantzi osankinarintsi, iñaawaitzi Pawa, ikantzi: Nopanko inatzi jiroka, ari jamanapiintaityaanari. Pamatawitantapiintaki iirokaiti pipimantayitzi, pikimitakaantakiro koshintzipanko”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ari ipokashitapaakiriri Jesús janta tasorintsipankoki ojyiki kaari okichaatatsini, kisopookiri, joshinchaayitairi maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tima owanaa okamiithataki jantakiri Jesús. Ikanta jiñaakiri iinchiiriki jantakiri, ikaimaiyanaki, ikantzi: ¡Thami apinkathatairi icharini David-ni! Ikisaiyanakani ijiwaripaini Ompiratasorintsitaari, itsipatakari Yotzinkariiti, tima tii inimotziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ari josampitaitanakiri Jesús, ikantaitziri: “¿Pikimakirima ikantaiyirini iinchiiriki?” Ari ikantzi Jesús: “Nokimakiri. ¿Tiima piñaanatziro osankinarintsi? kantatsiri: Iri iwankariiti iijatzi iintsipaini thoyitzirori itini, Pikantakaakari impinkathayitaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ari ipiyanaka Jesús ikinanairo Betania-ki. Ari jimaapairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Okanta amaityaaki iijatzi ipiyaawo Jesús nampitsiki. Ari itajyaapaaki niyanki aatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jiñaapaaki aatsinampiki okatziya pankirintsi, jiyaatashitanakiro, jiñaatzi tii okithokitzi, iyoshiita oshi. Jiyakatanakiro, ikantziro: “Ari pashi powiro iiro pikithokitai”. Okanta pankirintsi, kamashitanaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ikanta jiñaakiro jiyotaanipaini, iyokitzi ikantanaka, josampitanakiri: “¿Tsika okantaka okamashitantanakari pankirintsi?” ");
INSERT INTO cpcNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ari jakanakiri Jesús, ikantziri: “Imapiro nonkantimi, tyaaryoorika pawintaina, iirorika pikisoshiriwaitzi, ari pimatakiro iiroka, ari anaanakiro okanta piñaakiro pankirintsi. Kantatsi pinkantimi: ‘Oshirinki otzishi, ompiinki inkaariki’. Ari imatatya. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tima onkaati pinkowakotairiri Pawa, aririka pawintaapirotanatyaari, aritaki impakimiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ikanta jariitaa Jesús tasorintsipankoki, jiyotaantapai iijatzi. Ari ipokapaaki ijiwari Ompiratasorintsitaari, itsipatakari Antaripiropaini, josampitapaakiri: “¿Iitaka otyaantakimiri poñaagantiro pishintsinka?” ");
INSERT INTO cpcNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ari jakanakiri Jesús, ikantanakiri: “Iijatzi naaka tzimatsi nosampitimiri. Aririka pakakinawo, aritaki nonkantakimi iita otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tima jowiinkaatantaki Juan-ni, ¿Iitaka otyaantakiriri? ¿Pawama? ¿Atzirima?” Ipoña ikantawakaiyanakani: “Aririka ankantakiri Pawa otyaantakiriri, ari inkantanakai: ‘¿Iitama kaari pikimisantantari?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Aririka ankanti: ‘Atziri otyaantakiriri’, ari inkisanakai atziripaini”. Tima ikantaiyini atziri Kamantantaniri jinatzi Juan-ni. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ari ikantaiyini: “Tii niyotziro”. Ari ikantanaki iijatzi Jesús: “Ari nokimitsita naaka, iiro nokamantzimiro iita otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ipoña josampitantaki Jesús, ikantzi: “¿Tsika okantzimotzimika iirokaiti jiroka? Tzimatsi atziri, tzimatsiri apiti itomi. Okanta apaani kitiijyiri ikantakiri itomi: ‘Notomi, piyaati pantawaiti pankirintsimashiki’. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ari jakanaki itomi, ikantanakiri: ‘Tii nokowi’. Iro kantacha osamaniityaaki, opiyimoshiritaari itomi, jataki jantawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ipoña jiyaatashitakiri pashini itomi, ikantakiri iijatzi. Ikantanaki irirori: ‘Ari nimatakiro, Paapá’. Iro kantacha tii jiyaatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Itzimika itomi antakirori ikowakiri ashitariri?” Ari jakaiyanakini, ikantzi: “Iri antakirori jompiratakari kitziroini”. Ipoña ikantzi Jesús: “Iri ityaawoni janaakotimi impinkathariwintairi Pawa ikaatzi kowakotziriri kiriiki ijyininka, iijatzi mayimpiroyitatsiri. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tima ipokaki pairani Juan owiinkaatantaniri, ikamantawitakimi tsika pinkantya pinkamiithashiritantaiyaarimi, iro kantacha tii pikimisantawakiri. Iriima ikaatzi kowakotziriri kiriiki ijyininka, iijatzi mayimpiroyitatsiri, okimisantawakiri. Piñaawitawakari iirokaiti, iro kantacha tii powajyaantziro tsika pikantaiyani, inkini pinkimisantawakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Pinkimi pashini nojyakaawintimiri. Tzimatsi atziri pankitzirori chochokimashi, jotantotakotakiro maawoni othapiki, jiwitsikashitakiro jowironta owaaki paata, jiwitsikaki iijatzi pankojyitantsi inkini jaminakoitiro. Ipoña jaminaki atziri aminironi iwankirimashi. Jataki irirori intaina. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Okanta okithokipaititaki chochoki, jotyaantaki jompiratani jaakiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ikanta antawaitatsiri aminirori pankirintsimashi, jiñaawakiri ipokaiyakini ompirataari, jaawakiri jompojawaki apaani, itsitokakiri pashini, jojyimiyantakari mapi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ipoña jotyaantaki pashini jompiratani, ojyiki ikaataiyakini. Ari ikimitaawakiri iijatzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Iwiyaantapaakawori, jotyaantakiri itomipirori irirori, ikantzi: ‘Aritaikima ipinkathaitawakiri notomi naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ikanta jirikapaini antawaitatsiri, jiñaawakiri itomi, ikantawakaanaka: ‘Iri ashitaiyaawoni paata jiroka pankirintsimashi. Thami antsitokiri, ayiroota aaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Joirikawakiri, jaanakiri othapiki pankirintsimashi, itsitokakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aririka impokanaki ashitawori iwankirimashi, ¿tsikatya inkantirika jirikapaini antawaitatsiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ari jakaiyanakini, ikantzi: “Ontzimatyii jowamagaitiri jirikapaini kaaripirori, jaminai pashini kamiithari aminaironi pankirintsimashi, otyaantapiintiniriri okithoki iwankiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ipoña ikantzi Jesús: “Tima piñaanatziro okantziri Osankinarintsipirori: Imanintawitakawo mapi witsikirori pankotsi, Iro kantzimaitacha jowatzikaitairo mapi pankotsinampiki, ikimitakagaitaawo iroorikami tzinkamitsi. Iriitaki Awinkathariti Pawa owairori onaminaki, Irootaki ayokitziiwintantakariri maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Iro nokantantari: Iiro piñiiro impinkathariwintaimi Pawa, iri impinkathariwintai pashinijatzi atziri ikaatzi ojyawori pankirintsi okithokitzi ikimisantanaira. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Jiroka okantakota mapi: Iitarika ontajyaawoni mapi iparyaantakawo, ari intankawaitaki. Iriima inkaati awitsinairi, ari ompichaakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ikanta ijiwari Ompiratasorintsitaari itsipatakari Fariseo-paini jiyotawakiro iriitaki jojyakaawintaitaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ikowawitanaka jaakaantanakirimi, iro kantacha ojyiki ithaawantakari atziripaini. Tima ikantaiyini atziriiti Kamantantaniri jinatzi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ipoña japiitakiro Jesús jojyakaawintziro jiyotaantziri. Ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Aririka impinkathariwintantai Inkitijatzi, jojyakotakari pinkathari oimoshirinkiriri itomi jaawakaa. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jotyaantakiri jompiratani, inkamantiri inkaati pokatsini joimoshirintya. Iro kantacha jirikapaini, tii ipokaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ipoña jotyaantaki pashini jompiratani, ikantakiri: ‘Pinkantiri nokaimakaantani impoki joya, nowamaaki wathayitatsiri nopira, noimoshirinkatziiri notomi jaawakaiya’. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Iro kantacha iikiro jiyaatatzi ipiyathataiyani. Jataki jowaniki, pashini ikinanaki ipimantayitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tzimatsi pashini owasankitaawakiriri ompirataari, itsitokakiri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ikanta ikimaki pinkathari, jotyaantaki jowayiriti, japirotakiri itsitokiri owamaantaintsiri, itaakiro inampitsiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ipoña ikantairi pashini jimpiratani: ‘Aritaki witsikaka owanawontsi oimoshirintyaari, tii impokaiyini nokaimakaantawitakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Piyaati aatsiki ikinapiintaitzi, pinkantiri inkaati piñiiri impokiita oimoshirintya’. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ikanta jiyaataki ompirataari, japatotakiri ikaatzi jiñaakiri: kamiithari iijatzi kaaripirori. Piyotaiyakani ojyiki oimoshirinkachani. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ari jiyaatanaki pinkathari jaminiri ikaatzi pokaintsiri. Jiñaatzi osatikainchari apaani tii ikithaatashitapaakari aawakaachari. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ikantapaakiri: ‘Ajyininka, ¿tsika pikanta pityaantakari jaka tii pikithaawintari notomi?’ Ari imairitaki, tii jaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ipoña pinkathari inkantakiri jimpiratani: ‘Poojowakotiri, poojokiitiri, pookiri otsinirikitaki, ari jiraawaityaari jatsikaikiwaitya inkimaatsiwaitaiya’. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Tima ojyiki inkaimawiitya, kapichiini inkaati jiyoshiitaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ari ipiyapaaka Fariseo-paini. Ikinkithawaitaiyakini, ikantawakaiyani: “¿Tsika ankinakairika ankompitakaantyaariri Jesús?” ");
INSERT INTO cpcNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ipoña jotyaantaki jiyotaani irirori itsipatakari jaapatziyani Herodes, ikantapaakiri Jesús: “Yotaantanirí, okaatzi piyotaantziri imapiro inatzi. Aritaki jiyotakoitairi tyaaryoopiroini Pawa. Tima tikaatsi pinthaawakaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pinkantina iita pikinkishiritari: ¿Okamiithatzima ampiri kiriiki ikowakotantziri Pinkathari César?” ");
INSERT INTO cpcNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iro kantacha Jesús, jiyotawakiri ikinkishiritari, ikantziri: “Thiiyinkarí. ¿Iitama piñaantashiwaitantanari? ");
INSERT INTO cpcNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Poñaayinari kiriiki pipinatapiintziriri Pinkathari”. Ari jamaitapaakiniri apaani kiriiki jiitaitziri “denario”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ipoña josampitziri: “¿Iitaka ashitawori iwairo jaka? ¿Iitaka jirika ojyakaantainchari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ikantaiyini: “Jashi César”. Ari ikantzi Jesús: “Tima iri César ashitari, pantantyaanari ikowakaimiri, pimpinatiri. Iriima ikaatzi jashitari Pawa, pantantyaanari ikowakaimiri irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ikanta ikimaiyakini ikantaki Jesús, iyokitzi ikantaiyanakani, jowajyaantanakiri. Jataiyaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ikanta ipokaiyakini Saduceo jiñiiri Jesús. Iriitaki Saduceo kantapiintatsiri: “Iiro jañagai kamayitatsiri”. Josampitapaakiri Jesús, ");
INSERT INTO cpcNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ikantapaakiri: “Yotaantanirí, josankinataki pairani Moisés, okantzi: ‘Aririka inkami atziri, iirorika jowaiyantakaanakiro iina, okamiithatzi jagairo iririntzi, jowaiyantakagairo. Ontzimatyii inkimitakaantairi iriirikami ashityaarini iririntzi kamaintsiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Thami ankantawaki: Tzimatsi 7 irintzitawakaachari. Itawori itzimi jaaki iina, tikira jowaiyantakairo iina, ikamaki jagairo pashini iririntzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ari ikimitakari iijatzi apititanaintsiri iririntzi. Ipoñaapaaka pashini mawatanaintsiri. Ari ikimitakari maawoni ikaatzi 7. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Okanta osamanitaki kamai iijatzi iroori tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aririkami jañaayitaimi paata kamayitatsiri, ¿iitama oimintapirotaiyaari tsinani? Tima maawoni ikaataki 7 iinantawitakawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ipoña jakanaki Jesús, ikantziri: “Pikinakaashitakawo iiroka, tii piyotakotziro Osankinarintsipirori, tii piyotakotairo iijatzi ishintsinka Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tima aririka jañaayitai paata kamayitatsiri, iiro itzimapai aawakaayitaachani. Jojyapaiyaari imaninkariti Pawa Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Tiima piñaanatakotiro tsika onkantya aririka jañaayitai kamayitatsiri? Tima ikantaki Pawa, iñaawaitzi: ");
INSERT INTO cpcNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Naakataki Pawa ipinkathatziri Abraham, Isaac, iijatzi Jacob. Ari ayotaiyini añaayitatsi irirori, tima tii okantzi kaminkari impinkathatiri Pawa, apa jimatziro añaayitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ikanta ikimaitakiri Jesús ikantakiri, iyokitzi ikantaiyanakani, ikantzi: “Imapiro okamiithatzi jiyotaantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ipoña japatotaiyakani Fariseo, tima ikimaki kamiitha jakakiri Saduceo josampitakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ikanta apaani, irijatzi yotakopirowitawori Ikantakaantaitani, ipokashitakiri Jesús josampitiri, ikowi inkompitakaiyaarimi, ikantapaakiri: ");
INSERT INTO cpcNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Yotaantanirí, ¿otzimika Ikantakaantaitani anairori pashini?” ");
INSERT INTO cpcNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ari jakanaki Jesús, ikantzi: “Piwinkathariti jinatzi Pawa, ontzimatyii pitakopirotaiyaari, pitakoshiritaiyaari, pampithashiri powairi iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Irootaki itawori Ikantakaantaitani, iro ikowapiroitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ari ojyawo apititanaintsiri: Ontzimatyii pitakotaiyaari pijyininka, pinkimitakaantairi pinishironkatziro iiroka piwatha. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Aririka pimonkaatakiro jiroka apitika, pimatakiro maawoni josankinatakiri Moisés-ni, iijatzi maawoni josankinatakiri Kamantantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ipoña jimatanakiro irirori Jesús, josampitakiri Fariseo-paini itsipatakari japatotaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Ikantziri: “¿Iitama pikinkishiritakotariri iiroka Cristo? ¿Iitama charinitariri?” Ikantaiyini Fariseo: “Icharini David-ni jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ipoña ikantzi Jesús: “¿Iitama jiñaawaitakaantariri pairani David-ni Tasorintsinkantsi, okanta jojyakaantakariri Iwinkathariti? Tima ikantaki pairani: ");
INSERT INTO cpcNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Iñaawaitaki Pinkathari, ikantawairi nowinkathariti: Pisaikapai Nakopiroriki ampinkathariwintanti, Irojatzi paata nowasankitaantaiyaariri kisaniintakimiri, Ari paatzikantaiyaari piitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aña jimatsitataikawo David-ni ikantziri: ‘Nowinkathariti jinatzi’. ¿Tsikama inkini incharinityaari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ari jimairitaiyanakini tii jaki. Thaawashiri ikantaiyanakani, tikaatsi kowanaatsini josampitanairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ipoña ikinkithatakaakiri Jesús ikaatzi apatowintakariri, iijatzi jiyotaanipaini, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Paminiri Yotzinkariiti iijatzi Fariseo, iro jaakowinta jowaagakoyitziro okaatzi josankinatakiri pairani Moisés-ni. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Kamiithawitacha pinkimisantiri onkaati inkantimiri, tiimaita okamiithatzi pojyakotyaari okaatzi jantayitziri, tima tii jimonkaayitziro irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Imapiro opomirintsita ikowakaimiri pimayitainiri. Tii jiñiimaitawo impomirintsiwintyaawo irirori jimayitiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jantashiyitawo ikowiri onkantya jiñaantaityaariri. Owanaa jinintziro mishinantsimonki tsika jotitaitziro Osankinarintsipirori jontarikakotziro ijyimpaki, iijatzi itamakoki. Owanaa jowaniinkakaakitziro iithaari ishirikaki manthakintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iro ikowapiintaki josatikaitiri niyanki aririka jowaiyaani ijyininka. Ari ikimitari iijatzi aririka jiyaati pankotsiki japatotapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Pinkatha ikowi jiwithatapiintaityaari aririka jiñaitiri. Ikowi iijatzi inkantaitiri: ‘¡Yotaanarí!’ ");
INSERT INTO cpcNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Tii okamiithatzi pimatiro iiroka, iiro pikowashita inkantaitimi: ‘¡Yotaanarí!’ Tima maawoni iirokaiti kimiwaitaka pirintzitawakaatya. Apaani ikanta yotaantatsiri, iriitaki Cristo, tikaatsi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jaka kipatsiki, tii okamiithatzi pinkantashiwaityaari pijyininka: ‘¡Ashitanarí!’ Tima apaani ikanta Ashitzimiri Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tii okamiithatzi iijatzi inkantaitimi: ‘¡Nowinkatharití!’ Tima apaani ikanta piwinkathariti, iriitaki Cristo. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inkaati kowatsini jiñaapirotya, jojyakotyaari ikanta ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Tsikarika itzimi kowashiwaitachani impinkathaitirimi, aritaki jiñaakiro intsinampashiritakaitairi. Iriima tsinampashiriwaitatsiri, iriitaki impinkathayiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Ikantamachiitzimi iiroka Yotzinkariiti iijatzi Fariseo, thiiyinkari pinaki! Owanaa potzikakiri kowatsiri impinkathariwintairi Pawa. Tima iiro piñiiro iiroka impinkathariwintaimi, tii pikowi impinkathariwintiri pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ikantamachiitzimi iirokaiti Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Pathaagakawo kamatsiri oimi pashitawo opanko, iro posamaninkantawori pamanapiintawita iiro jiyotantaitzimi. Iro kantzimaitacha antawo jowasankitaayiitaimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ikantamachiitzimi iirokaiti Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Owanaa pipomirintsiwintakari atziriiti kaari ajyininkata jojyakotai aaka a-judá-mirinkatzi, piyotaakiri inthiiyinkariti irirori. Iro ikimitakotantzimiri iiroka jatsipitaiyaawo sarinkawini. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Ikantamachiitzimi iirokaiti, ojyariri kamampotaakiri ikathatawakaiyani! Tima aririka impairyaashiityaawo tasorintsipanko, ikantayitzi: ‘Jowasankitaina Tasorintsipankowiri iirorika nimonkaatziro nokantziri’. Iro kantacha pikantaiyini iirokaiti: ‘Iirorika jimonkaataitziro, tikaatsi oitya’. Irooma aririka impairyaitiri oro saikatsiri tasorintsipankoki, pikantapiintaki: ‘Ontzimatyii jantaitiro ikantaitakiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Masontzishirirí, kamampotaakishirirí! ¿Iitama kowapirotachari, iriima oro? Kaari, tima irootaki iroopirotatsi tasorintsipanko otasorintsitakairi oro. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ari okantari iijatzi aririka impairyaitiro taapirimintotsi, ikantayitzi: ‘Jowasankitaina Ataapiintziniri iirorika nimonkaatziro nokantziri’. Iro kantacha pikantapiintaiyakini iirokaiti: ‘Iirorika jimonkaataitziro, tikaatsi oitya’. Irooma aririka impairyaitiri piratsi itaayitziri taapirimintotsiki, pikantapiintaki: ‘Ontzimatyii jantaitiro ikantaitakiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Masontzishirirí, kamampotaakishirirí! ¿Iitama kowapirotachari, iriima piratsi? Kaari, tima irootaki iroopirotatsi taapirimintotsi otasorintsitakairi itaayiitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ikaatzi pairyiirori taapirimintotsi, ari okaatzi ipairyaakiro maawoni itaayiitziri janta. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iijatzi jojyari ikaatzi pairyiirori tasorintsipanko, ari okaatzi ipairyaakiro ikaatzi tzimantawori. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ikaatzi pairyiirori inkiti, ipairyaakiro maawoni isaikinta Pawa, ikimitakaantakawo iriimi Pawa impairyaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Ikantamachiitzimi Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Pinashitapiintanari pashitakaariri Pawa, pipayitapiintziri inchajyaaniki. Tiimaita pantayitziro kowapirotachari ikowakaimiri: Pinkamiithashiriyiti, pinishironkashiritanti, pawintaashiritaiyaari. Irootaki kowapirotachari pantayitairo, iiro powajyaantzimaitawo pantiniri pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Kamampotaakiri, kathatawakaachari! Pikimitakari pankinatariri shikiryaaniki iiro jirakotantari, jirakotzimaitakari antari piratsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Ikantamachiitzimi Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Pikimitakotakawo iraamintotsi iijatzi owamintotsi, okitiwita jikokiroki kamiitha, tompinakitaki inthomainta. Ari pikantayitakari iiroka kantatsi iñaitimi kamiithashiri pinatzi, aña koshintzi pinatzi, pikowapiintakiro apaniroini pinintaawaitya. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Kamampotaakiri Fariseo! Pinkimitakaantya pojyitapiintziro piraaminto iijatzi powaminto inthomainta, onkantantyaari onkititai jikokiroki iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Ikantamachiitzimi Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Pojyakawo okitamaawita jowantaitariri kaminkari, owaniinka okantawita jiñokiini. Iro kantacha shityiinka okantaka inthomainta, ari isaikaki itonkipooki kaminkari. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ari pikimiyitakari iiroka, jiñaawitakimi atziri pantakiro kamiithari, iro kantzimaitacha kaaripiroshiritakimi inthomainta, thiiyinkari pinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Ikantamachiitzimi Yotzinkariiti iijatzi Fariseo, thiiyinkari pinatzi! Iitama piwitsikapiritantawori ikitaitziri Kamantantaniri, powaniinkayitziro inkini inkinkishiritakoitapiintiri, inkantaiti: ‘Kamiithashiri jinataki jirika’. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Pikantaiyini iijatzi: ‘Arimi nontzimitatyaami pairani iirotya nowamaayitzirimi, iiro nojyakotari nocharinini owamaakiriri Kamantantaniri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iirokataki kinkithatakotacha apaniroini, iri pojyakoyita iiroka picharinini ikaatzi owamaayitakiriri pairani Kamantantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Incha pothotyiiro iiroka kaaripirori jitakaantakari pairani pichariniiti! ");
INSERT INTO cpcNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Tima pojyakari pijyininkatatyaarimi maanki! Kaaripiroshiri pikantaka. ¿Tsikama pinkantaiyaaka pishiyapithatantyaawori pashironkaiya sarinkawiniki? ");
INSERT INTO cpcNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Irootaki notyaantantzimiriri pairani Kamantantaniri, yotaniri, iijatzi yotzinkari. Iriitaki powamaagaantakiri apawopaini, pimpaikakotakaantiri. Iriima pashini, pimpajatakaantawaitiri tsika japatotapiintaita, ojyiki powasankitaayitiri maawoni nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iro piñaantyaawori iiroka jowasankitaawintaitimiri ikaatzi kamayitaintsiri pairani, jitanakawo kamiithashiriri Abel irojatzi Zacarías itomini Berequías. Iriitaki jowamaitaki pairani jiyaatiromi taapirimintotsiki ipoñaanakawo tasorintsipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Imapiro nokantzimi ari jowasankitaawintaitakimiri jirikapaini nojyininka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Jerusalén-jatzí! Ojyiki pitsitokaki Kamantantaniriiti. Pojyimiyayitakiri ikaatzi jotyaantawitakimiri. Tima nokowawitapiintaka nonkimityaarimi tsimiri josatitziri iryaani, ari nonkantirimi maawoni notomitaari. Iro kantacha tii pikowaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Jaka tsika pisaikapiintawitaka iiro jiñaitai iitya nampitaiyaawoni, kaankiityaa onkantaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tima iiro okantaitatya piñaapiintaina jaka, irojatzi paata pinkantantaiyaari: Tasonkawintaari jinatzi, tima Pinkatharintsi aitziri otyaantakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ipoña ishitowanaki Jesús ipoñaanakawo tasorintsipankoki, irootaki jiyaatai. Ari ikantzi jiyotaani: “Paminiro tsika okanta jiwitsikaitziro tasorintsipanko”. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jakanakiri irirori, ikantanakiri: “maawoni piñaakiri, iiro piñiiro paata tsika okanta opiwiryaayita mapi, iro japiroitiro impookaitiro. Imapiro nokantzimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ikanta itonkaanaki otzishiki Olivo, ari isaikapaaki. Ari josampitziri jiyotaani, ikantziri: “Incha pinkantina, ¿tsikapaitima imonkaatya pikantakiri? Aririka pimpiyimatai, aripaitima onthonkimataiyaari, ¿tsika onkantya niyotantyaawori?” ");
INSERT INTO cpcNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ari jakanakiri Jesús, ikantanakiri: “Ontzimatyii paamaakowintya jamatawitaitzimikari. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tima ojyiki kowatsini jamatawitimi paata, impairyaapaakina, inkanti: ‘Cristo ninatzi naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tima ari pinkimakoyitakiro owayiritaantsi, paamaiya ominthaawashiritzimikari. Ontzimatyii awijayiti jirokapaini, tima tikiraata imonkaata onthonkantaiyaari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jantaminthatawakaitya maawoni nampitsiki inkaati jotyaantiri pinkathariyitatsiri. Jiñaiti mantsiyarintsi, tajyitsi, ontziñaayitya kipatsi tsikarikapaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Irootaki itanatyaawoni inkimaatsitaityaawo jirokapaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Impoña jaakaantanakimi iiroka, jimaamanitaitimi irojatzi jowamaantakimiri. Ojyiki inkisaniintanakimi atziri okantakaantziro pipairyaana pawintaana. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ari jiñaitaki atsipitashitawori ikimisantawitaka, jiñaiti kisaniintawakaachani, jiñaiti iijatzi aakaantawakaachani. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ojyiki pokapaintsini jojyawitapaatyaarimi Kamantantaniri, jamatawitapaakiri inkaati kimisantawakirini. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Jantapiroitiro kaaripirori, iiro inishironkatawakaanaa atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Iriima tyaaryootanaintsini, iriitaki awijakoshiritaatsini. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Aririka othotyaatya inkimaitairo maawoni kipatsiki Kamiithari Ñaantsi kinkithatakotzirori ipinkathariwintantai Pawa, aripaiti imonkaataiya onthonkantaiyaari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iro kantacha ari piñaakiri jiitaitziri ‘Pinkaari Apirotantaniri’, ikinkithatakotakiri pairani Kamantantaniri Daniel, isaikapaaki otasorintsitzi. (maawoni ñaanatironi jiroka, okowapirotatya inkimathatairo.) ");
INSERT INTO cpcNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Inkaati nampitaiyaawoni paata Judea-ki, ontzimatyii ishiyayitai tonkaari otzishiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pisaikirika jikokiroki pipanko, ari pimpoña pishiyanaki, iiro pityaapanaatzi paapanaati tsikarika oitya. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Powanikirika pisaiki, pishiyanaki tsika pikanta, iiro paapanaatziro piithaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Inkantamachiitiro paata motyaatatsini, iijatzi onkaati tzimayitatsini iintsiti iinta ithoyitzi! ");
INSERT INTO cpcNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pamañaari Pawa, onkantya aririka pishiyaki, iiro pitonkiyotantawo tyaawontsi, iiro pishiyanta kitiijyiriki jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tima antawo jiñaitiro jashironkaitya paata. Pairani owakiraa jiwitsikaitakiro kipatsi, irojatzi iroñaaka, tii jiñaitziro ojyaawoni jiroka ashironkaantsi. Iiro apiita jiñaitairo ojyaawori. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iiromi ishintsitaitzi jomairintaitiro jiroka ashironkaantsi, tikaatsimi awijakotaatsini. Ikamintha itzimayitzi jiyoshiitaitakiri, awintaariri Pawa, irootaki jomairintantaitakawori thaankiini jiroka ashironkaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aririka pinkimi inkantaitimi: ‘Jirika Cristo’. Pashini kantatsini: ‘Jirinta Cristo’, iiro pikimisantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tima impokayitapaaki ojyakotyaarini Cristo, ojyakotyaarini Kamantantaniri. Ari intasonkawintantashitapaatya, inkowawitya jamatawitimi jiyoshiitakiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Aritaki nokamantsitakimiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Impoña inkantaitimi: ‘Ariitaka otzishimashiki’. Iiromaita piyaatashitziri. Inkantaiti iijatzi: ‘Ari isaiki inthomainta pankotsiki’. Iiromaita pikimisantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Tima aririka impiyi Itomi Atziri, jojyapaiyaawo ookathawontsi. Itanatyaawo omporikanaki ishitowapiintzi ooryaatsiri, irojatzi tsika ityaapiintzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Tsikarika isaiki shitziwari, ari ipiyowintari amimpori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Aririka onkaatapaaki paata jashironkaita antawo, ari intsiwakaki ooryaatsiri, iiro joorinta kashiri iijatzi. Intziroryaayiti impokiro inkitiki, maawoni ikaatzi oorintayitachari inkitiki inthontya impookayiti iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Aripaiti inkoñaatapai Itomi Atziri inkitiki. Antawo inthaawaiyanakini atziri jaka kipatsiki. Tima jiñaitawairo jowaniinkawo iijatzi ishintsinka, inkinantapaiyaawo minkori. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Intyootapaaki shintsiini maninkariiti, japatotapairi ikaatzi jiyoshiiyitakiri nampitawori maawoni tsikarikapaini jaka kipatsiki, irojatzi tsika ochimpitapaa. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Okimita aririka piñaapiintziro iirishiyitai pankirintsi, piyotzi irootaatsi osarintsitzimatai. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iro piyotiri iirokapaini, aririka piñaayitakiro nokantayitakimiri, okaakitzimataana. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Imapiro nokantzi, iiro ikamita jirika ajyininkapaini, irojatzi jiñaantatyaawori nokamantayitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iiro okantaitatyaani piñiiro inkiti iijatzi kipatsi, irooma okaatzi noñaaniyitakari imapiroitaatyaani iroori. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iro kantacha tikaatsi yotatsini tsikapaiti, iri owatsipiro inkitiwiri, tii jiyotzi. Tima apaniroini ikantakaawo Ashitanari jiyotziro irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ari ojyaawo pairani isaikantawitari Noé, ari onkantaiyaari iijatzi aririka impiyi Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tima pairani tikira ariita oonkawo, inimowaitziri atziri, jowawaitaiyani, jirawaitaiyini, pashini aayitatsiri iina. Irojatzi jotitantanakari Noé shintsipaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Tikaatsi inkinkishiritakoti, irojatzi omapokantakariri oonkawo, ari japirotakari maawoni. Ari onkimitaiyaari aririka impiyi Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tima isaiki apiti antawaitatsiri jowaniki, apaani jaayiitanai inkitiki. Iriima pashini jookaitanairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Osaiki apiti tsinani otoonkawaitzi, apaani jaayiitanai inkitiki. Irooma pashini tsinani, jookaitanairo. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Paamaakowintaiya iiroka, tima tii piyotzi tsikapaiti impiyi Piwinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pinkinkishiritakotiri atziri, aririkami jiyoti impokatyi koshintzi tsiniri, arimi jaamaakowintatyaami, iiro ikoshitaagantaitzirimi ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ari onkantyaari, ontzimatyii paamaakowintaiya iijatzi iiroka. Tima tikaatsi yotatsini tsikapaiti impiyi Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Pojyakotyaari ompirataari kamiithashiriri, kinkishiritachari kamiitha. Jookanakiri ipankoki ompiratariri, ikantanakiri: ‘Pamininari ikaatzi saikatsiri pankotsiki’. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kimoshiri inkantaiya jirika ompirataari, aririka impiyi ompiratariri, tima jiñaapairi imonkaatakiro ikantanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Aritaki ishinitakiniri jaamaakowintyaanari maawoni okaatzi jashitari. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Iriima kaaripiroshiriri ompirataari, ikantzi: ‘Iiro ipiyita ompiratanari’. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Impoña jantawaitakiri pashini ompirataari. Jataki intsipayityaari shinkiryaantzi. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Inimowaitziri jirika ompirataari, jomapokashitaiyaari jariitaiya ompiratariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Imapiroitiri jowasankitaapairi, jookapairi tsika ikajyaakaitakiri thiiyinkari. Ari jiraawaitaiyaari, jatsikaikiwaitya inkimaatsitaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Aririka impinkathariwintantai Inkitijatzi, ojyatyaawo 10 mainawo jatatsiri tsiniri ontonkiyotyaari aawakaachani. Aayitanaki ootamintopaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tzimatsi okaatzi 5 mainawo kiyoshiritaintsiri, tzimatsi iijatzi okaatzi 5 mainawo kaari kiyoshiritatsini. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jirokapaini 5 mainawo kaari kiyoshiritatsini aawitanakari ootaminto, iro kantacha kapichi aanaki iyaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Irooma pashini kiyoshiritaintsiri, aayitanaki iroori ootaminto, aanaki ojyiki iyaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tii ipokita thaankiini aawakaachani, ayimatapaakiro owochokini, magaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Okanta niyankiiti tsiniri, okimatzi ikaimaitzi, ikantaitzi: ‘¡Aatsikitaki aawakaachani, pintonkiyotawatyaari!’ ");
INSERT INTO cpcNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kakiiyanakini mainawo, ojaikiyitanairi iyaaki ootamintopaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mainawopaini kaari kiyoshiritatsini, okantawitanakawo kiyoshiritaintsiri: ‘Pimpina iyaaki pootaminto, irootaintsi intsiwaki nootaminto naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ari okantanaki: ‘Iiro nopimi, ari inkowityiimotakina naaka, piyaati pamanantapainti’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Iyaaminthaitapaintzi amanantzi, ariitapaaka aawakaachani. Jirokapaini aamagainchari, otonkiyotawakari, jaanakiro tsika joimoshirinkaitiri. Jashitaitanakiro ashitakowontsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Okanta opiyawitapaaka jatatsiri amanantzi, ojyiki okaimawitapaaka, okantapaaki: ‘¡Pashitaryiinawo naaka!’ ");
INSERT INTO cpcNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Okimatzi jakaitanakiro, ikantaitziro: ‘Tiitya niyotzimi. Imapiro’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ontzimatyii paamaakowintaiya iiroka. Tima tii piyotzi tsikapaiti impiyi Itomi Atziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tima aririka impinkathariwintantai Inkitijatzi, jojyakotari atziri kowatsiri jiyaati intaina, japatotakiri jompiratani, ipanakiri jashitari jaamaakowintyaanari. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ipakiri apawopaini jompiratani iiriikiti. Iriima kinkishiritachari kamiitha, impanakiri ikaatzi 5 kiriiki, pashini yotatsiri kapichiini ipanakiri ikaatzi apiti, iriima pashini iwiyaantapaakawori impanakiri apaani. Jataki intaina. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ikanta jirika ipanakiri 5 kiriiki, jantawaitakaakiri, jojyiñaakiri jagai ikaatzi iijatzi 5. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ari ikimitakari ipanakiri apiti, jojyiñaakiri irirori, jagai ikaatzi iijatzi apiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Iriima pashini ipaitakiri apaani, jaanakiri iiriikiti, ikitatakiri kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Ikanta osamanitaki piyaa ashitariri kiriiki, ikaimakaantapairi jompiratani jiyoti iita jantantakari iiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ari ipokapaaki ipaitakiri 5 kiriiki, joñaagapairi pashini 5 kiriiki jojyiñaakiri, ikantapaaki: ‘Pinkatharí, 5 kiriiki pipakina pairani, jirika pashini 5 nojyiñagairi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ikantzi Pinkathari: ‘Ariwí nompiratani, kamiithashiri pinaki. Kapichiini kiriiki pikimpoyaakina, ari pinkimpoyagai pashini ojyiki. Pimpoki, pintsipatina pinintagaiya’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ipoña jariitapaaka ipaitakiri apiti kiriiki, ikantapaaki: ‘Pinkatharí, apiti kiriiki pipakina, jirika pashini apiti nojyiñagairi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ari ikantzi Pinkathari: ‘Ariwí nompiratani, kamiithashiriri pinaki. Kapichiini kiriiki pikimpoyaakina, ari pinkimpoyagai ojyiki pashini. Pimpoki, pintsipatina pinintagaiya’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ipoña jariitapaaka ipayitakiri apaani kiriiki, ikantapaaki: ‘Pinkatharí, niyotzi naaka mashiryaantzi pinatzi, piñaakatsimatantzi pantawaitakaantziri piiriikiti, okanta pojyiñaantariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Iro nothaawantakari, naakiri piiriikiti, nokitatakiri kipatsiki. Jirika namaimiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ari jakanakiri ikantziri: ‘Kaaripiroshiri pinatzi owanaa pipiranita. Piyowitaka ari nonkisakimi iirorika pojyiñaanari kiriiki, ");
INSERT INTO cpcNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","piñaawitaka iiro pimatziro iiroka, paminimi iitya antawaitakaimirini, ari ijyinitakimi, iri pimpawainarimi nopiyaa’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ikantaitakiri ikaatzi saikaintsiri: ‘Paapithatiri kiriiki, pimpairi pashini ojyiñaakiriri 10 kiriiki’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tsikarika itzimi otzimimotakiri, ari ontzimimotairi ojyiki. Iriima kaari otzimimotzi, iikiro jiyaatatyi iiro otzimimopirotairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Paanakiri jirika kaaripiroshiriri, pookiri tsika otsinirikitzi. Ari jiraawaityaari, jatsikaikiwaitya inkimaatsiwaitaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Aririka impiyi Itomi Atziri pinkatha jowaitairi. Intsipataiyaari maawoni maninkariiti, inkimitaiyaari ikanta pairani pinkathari isaikantawo owaniinkatachari isaikaminto. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Japatotairi maawoni atziri tsikarika isaikai irirori. Jinashiyitaiyaari joosaikayitairi. Jojyakotyaari atziri nashitariri ipira tii inkowakairi intsipataayitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Joosaikairi ikowapirotziri jakopiroriki, iriima imanintayitziri jampatiki joosaikiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jiñaawaitanaki Pinkathari, iñaanatziri jinashitakari jakopiroriki, inkantiri: ‘Pimpoki maawoni, ojyiki inthaamintakagaimi Ashitanari, pinampitaiyaawo tsika ipinkathariwintantzi irirori, tima ari jiwitsikitakimi pairani owakiraa jiwitsikantakawori kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tima piñaana pairani owamaawitana notajyi, pipakina nowanawo. Piñaana ayimatana nomiri, pipakina nomiri. Piñaakina nariita pinampiki, pinishironkatakina pipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Piñaana nosagaakowaitzi, pipakina nokithaatari. Piñaana nomantsiyataki, pimitakotakina noshintsitantaari. Jomontyaitakina, pipokashitakina piñaana’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Inkantaiyini kamiithashiriri: ‘Pinkatharí. ¿Tsikapaiti noñiimi pitajyaaniintzi, nopantzimiri powanawo? ¿Tsika noñiimi pimiriniintzi, nopantzimiri pimiri? ");
INSERT INTO cpcNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Tsikapaiti noñiimi, naantzimiri kamiitha nopankoki? ¿Tsika noñiimi pisagaakowaitzi, nopantzimiri piithaari? ");
INSERT INTO cpcNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Tsikapaiti noñiimi pimantsiyatzi, jomontyaitzimi, niyaatashitakimi noñiimi?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ari jakanaki Pinkathari, ikantzi: ‘Tima pinishironkatakiri ikaatzi awintaayitanari nokimitakaantziri iyiki, aña naakataki pinishironkataki. Imapiro’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ipoña ipithokashitanakari jinashitakari jampatiki, ikantziri: ‘Kaaripirorí, piyaati iiroka pinkimaatsitaiyaari paampari kaari tsiwakanitaatsini, ikajyaakaitakari kamaari intsipataiyaari maawoni imaninkariti irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aña piñaawitakina notajyaaniintzi, tii pipana noyaari. Ayimatakina nomiri, tii pipana nomirityaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Piñaawitana nariita pinampiki, tii pinishironkatana pipankoki. Piñaawitana nosagaakowaitzi, tii pipana nonkithaatyaari. Piñaawitana nomantsiyatzi, jomontyaakaantaitakina, tii pariitaajaitina’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ari jakanaki kaaripiroshiriri, ikantzi: ‘Nowinkathariti, ¿tsikapaiti noñaawitzimi pitajyaaniintzi, pimiriniintzi, pariitana, pisagaakowaitzi, pimantsiyawaitzi, jomontyaitzimi, tiimaita nonishironkatzimi?’ ");
INSERT INTO cpcNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ari ikantzi Pinkathari: ‘Tii pinishironkayitantzi, onkantawitatya iintsi jinayitzi, naakataki pantzimotaki. Imapiro’. ");
INSERT INTO cpcNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Irootaki jatsipitantaityaawori kantaitachani ashironkaantsi. Iriima inkaati kamiithashiritaintsini, inkantaitaatyiironi jañaayitai”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ikanta ithonkanakiro Jesús okaatzi ikinkithatakotakiri, ikantanakiri jiyotaani: ");
INSERT INTO cpcNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Piyotaiyini iiroka kaatapaaki apiti kitiijyiri joimoshirinkapiintaitziro Anankoryaantsi. Ari jaakaantaitiri Itomi Atziri impaikakoitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ikanta ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti, iijatzi Antaripiroriiti, japatotaiyakani ipankoki Caifás ijiwaripirori Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ari ikamantawakaiyakani, ikantaki: “Thami amatawitiri Jesús ayiri antsitokakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iiromaita amaamanitziri kitiijyiri joimoshirinkaita, ikisawintzirikari atziripaini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ikanta ikinanai Jesús Betania-ki, ipankoki Simón pathaawaiwitachari. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ari ariitapaaka tsinani amakotaki kasankaari, kamiitha okantaka onaki jiwitsikaitziro mapi iitachari “alabastro”, ojyiki owinawo. Osaitantapaakari iitoki Jesús isaikaki jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ikisaiyanakani jiyotaani jiñaakiro, ikantaiyanakini: “¿Iitama apaawaitantawori? ");
INSERT INTO cpcNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Aririkami ompimantya, jagaitimi ojyiki kiriiki impaitirimi ashironkainkari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jiyotakotakiri Jesús, ikantziri: “¿Iitama pikisantawori jiroka tsinani? Kamiitha okanta noñaakiro antakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ari inkantaitatyaani ashironkainkari pintsipatyaari, irooma naaka iiro piñiiro pintsipatapiintaina. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tima iiwatatzi osaitantanawo kasankaari ojyakaawintatyaana aririka inkitaitakina. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Aririka ikamantantaitairo Kamiithari Ñaantsi, inkinkithatakoitairo tsinani, ari onkantya joshiritantaityaawori antakiri iroori. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ikanta Judas Iscariote kaawitachari 12 jiyotaani Jesús, jiyaatashitakiri ijiwari Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ikantapaakiri: “¿Iitama pimpinari aririka namakimiri?” Ari joñaagaitanakiri ikaatzi 30 ipiwiryaaka kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aripaiti ikowanaki Judas tsikapaiti jaakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ariitapaaka itawori kitiijyiri jowantapiintaitawori tantaponka, pokaiyapaakini jiyotaani Jesús, josampitziri: “¿Tsika onkotsitakaantika oyaari kitiijyiriki Anankoryaantsi?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ari ikantanakiri: “Piyaati nampitsiki. Ari pintonkiyotyaari atziri, pinkantiri: ‘Ikantzi yotaanari: “Monkaatapaaka, niyaatantyaari pipankoki noimoshirinkiro kitiijyiri Anankoryaantsi, nontsipatyaari niyotaanipaini” ’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ari jimatakiro jiyotaani okaatzi ikantakiriri Jesús. Jonkotsitakaantaki joyaari kitiijyiriki Anankoryaantsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aritaki tsiniriityaanaki jariitapaaka Jesús, saikapaaki jowaiyaani itsipatapaakari jiyotaani ikaataiyakini 12. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ikanta jowaiyani, ikantaki Jesús: “Pinkimi nonkanti, pikaataiyini iiroka jaka, tzimatsi apaani pithokashitinani. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Owashiri ikantaiyanakani. Apaanipaini josampitanakiri: “¿Naakama pinkathari?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ari jakanakiri, ikantzi: “Tsikarika itzimi atyootakinari, iriitaki pithokashitinani. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tyaaryoo impiyakotya Itomi Atziri, tima irootaki josankinatakoitakiri pairani. ¡Ikantamachiitziri pithokashityaarini! Iiro itzimaajaitzimi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ari jiñaawaitanaki Judas pithokashityaarini, ikantzi: “¿Naakama yotaanari?” Ikantzi Jesús: “Irootaki pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iinta jowaiyani jaakiro Jesús tanta, ipaasoonkiwintakiro, ipitoryaakiro, ipayitakiri jiyotaani, ikantziri: “Jiroka, poyaawo, nowatha inatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ipoña jaakotakiro jimiriitari, ipaasoonkiwintakiro, ipakotakiri jiyotaani, ikantziri: “Piraiyini maawoni, ");
INSERT INTO cpcNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","tima niraani inatzi jiroka, irootaki oñaagantapirotironi ankajyaakaawakaiyaari, iro shitowatsini impiyakotantaityaarini ikaaripiro-witaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pinkimi nonkanti, iiro niritaawo jiroka irojatzi paata aririka impinkathariwintantai Ashitanari, ari apiitairo iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ikanta ithonkanakiro ipampithaakotziri Pawa, jataiyanakini tonkaariki otzishiki Olivo. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ikantziri Jesús jiyotaani: “Irootaintsi pookawintaiyinani tsiniri. Tima josankinaitaki pairani kantatsiri: Nontsitokiri aamaakowintariri oijya, ari inthontya impookayitanaki ipira. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Aririka nañagai, Galilea-ki noyaawintapaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ari jakanaki Pedro, ikantzi: “Aritaima jookawintakimi pashinipaini, iiro nimatziro naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ikantzi Jesús: “Pinkimi nonkantimi, iroñaaka tsiniri tikira jiñiita tyoopi, mawajatzi pinkantaki: ‘Tii noñiiri Jesús’. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ari ikantzi Pedro: “Iiro nookawintzimi, kimitaka ari ankaati ankami”. Ari ikantaiyakini iijatzi maawoni jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ikanta Jesús itsipatakari jiyotaani, ariitaiyakani Getsemaní-ki, ikantapaakiri: “Ari pisaikawaki jaka, niyaaniintawaki naaka, namaña”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Apa jaanakiri Pedro itsipataanakiri apiti itomi Zebedeo. Ari jiraashiritakotapaaka antawoiti Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ikantziri: “Owamaimatatyaana nowashirinka. Ari pisaikaiyawakini iiroka, thami ankakimpiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Awijaniintanaki kapichiini irirori. Otziirowapaaka, amanapaaka. Ikantzi: “Ashitanarí, pishinitanarika iiroka, pimatinawo onkaati nonkimaatsityaari. Iiromaita pimatanawo okaatzi nokowawitakari naaka, iro pimati okaatzi pikowakaakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ipiyashitapaakari jiyotaani, jiñaapaatziiri jimagaiyini. Ikantapaakiri Pedro: “¿Tiima pinkisashityaawo piwochokini pintsipatina ankakimpiti? ");
INSERT INTO cpcNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pinkakimpiti, pamaña, otzimikari pikinakaashitani. Tima tii pikisashiwaitanita, ojyiki inawita kamiithatatsiri pikowawitari pantirimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iijatzi ipiyanaa Jesús, amanapaa, ikantzi: “Ashitanarí, iiro pimatanawo onkaati nonkimaatsityaari, pimatinawo oita pikowakaakinari iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ikanta ipiyapaa, iijatzi jiñaapairi jimagaiyini, tima antawoiti okantaka iwochokini. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ipiyapithatanaari, mawataki ipiyaka jamana. Irojatzi japiitapai ikantayitakiri inkaanki. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ari ipiyashitapaakari jiyotaani, ikantapaakiri: “¿Irojatzima pimagaiyini? Monkaatapaaka jaakaantaitantyaariri Itomi Atziri, jagaitanakiri kaaripiroshiririki atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pimpiriinti, thami aatai. Okaakitzimatapaaki pithokashitinani”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jiñaawaiminthaitzi Jesús, ariitapaaka Judas ikaawitapiintari. Ojyiki itsipatapaakari, jamayitaki jowathaaminto, ipajaminto. Jotyaantani ijiwaripirori Ompiratasorintsitaari, iijatzi jashi Antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tima Judas pithokashitantaniri, ikantsitakari kitziroini jamaniwo: “Iitarika nothopootapaaki, iriitaki, poirikiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ikanta jariitapaaka Judas, jontsitokapaakari okaakiini Jesús, ikantapaakiri: “Yotaanarí”. Ithopootapaakiri jiwithatapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ari josampitantzi Jesús, ikantzi: “Ajyininká, ¿Iitama pipokashitziri?” Ari joirikaitapaakiri Jesús, jaantaitanatyaariri jiyakawintaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ikanta apaani tsipatakariri okaakiini Jesús, inoshikanakiro iyotsiroti, itotsitakiri ikimpita jompiratani ijiwari Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ari ikantanaki Jesús: “Powairo piyotsiroti, ipiyaitzimikari. Tima ikaatzi wijantatsiri, iwijaitziri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tima piyotzi kantatsimi namañaari Ashitanari, aritakimi jotyaantakina ojyiki maninkariiti piyakowintinani. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ari onkantzimaitya imonkaatantyaari josankinatakoitakinari pairani”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ipoña Jesús ipithokashitanakari ikaatzi pokashitakiriri, ikantziri: “¿Naakama koshintzi pamashitantanari powathaaminto, pipajaminto? ¿Tiima piñaapiintana niyotaantzi tasorintsipankoki, kaarima paantana janta? ");
INSERT INTO cpcNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ari onkantyaari, irootaki imonkaatantyaari okaatzi josankinatakiri pairani Kamantantaniri”. Aripaiti ishiyayitanaka jiyotaani, jookawintaitanakiri Jesús apaniroini. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ikanta jagaitanakiri Jesús ipankoki Caifás, ijiwaripirori Ompiratasorintsitaari, ari japatotaiyakani maawoni Yotzinkariiti itsipatakari Antaripiroripaini. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Noshikacha iintsikiryoini Pedro joyaatakowintziri Jesús, irojatzi jariitantapaakari ipankoki ijiwaripirori Ompiratasorintsitaari. Iro intyaantapaatyaarimi pankotsiki itsipatapaakari kimpoyaawintaniri, ikowi Pedro inkimakowintiri tsika inkantaitiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ikanta ijiwaripaini Ompiratasorintsitaari itsipatakari ikaatzi apatotainchari, jaminawitaiyakani iitya thiiyakotyaarini Jesús inkini intsitokakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tii jiñiimaita, okantawitaka ipokayiwitaka ojyiki kowatsiri inthiiyakotyaarimi. Ipoña ikatziyanaka apiti thiiyakotanakariri, ");
INSERT INTO cpcNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ikantanaki: “Nokimiri naaka chapinki jiñaawaitzi ikantzi: ‘Ari nompookakiro tasorintsipanko, iro awijawitatya mawa kitiijyiri, nonthonkairo niwitsikairo’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ari ikatziyanaka ijiwaripirori Ompiratasorintsitaari, ikantanakiri Jesús: “¿Iitama kaari pakanta? ¿Tiima pinkimiri okaatzi ikantakotzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Irojatzi jimairitaki, tii jaki. Ari ishintsithatanakiri, ikantziri: “Pimpairyiiri Kañaaniri Pawa, onkantya niyopirotantyaari tyaaryoorika onkaati pinkantinari. ¿Iirokama Cristo Itomi Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ari jakanaki Jesús, ikantzi: “Irootaki pikantakiri. Iroñaaka piñiiri Itomi Atziri isaikai jakopiroriki Pawa impinkatharitai. Impoña piñiiri impiyi inkinapai minkoriki”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ikanta ikimawaki jiwapirori, isagaanakiro iithaari ikisanaka, ikantanaki: “Ñaakiro, ipairyaashitakari Pawa. Tikaatsi pashini ankowiri ankantakotiri. Pikimaiyakini iiroka okaatzi ithainkakiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Iitama pikantaiyirini iiroka?” Ari jakaiyanakini: “¡Tzimaki ikinakaashitani! ¡Ontzimatyii inkami!” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ipoña jiiwapoowaitaitanakiri. Tzimatsi pashini kapojapoowaitanakiriri. Tzimatsi iijatzi pajapoowaitanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Josampitzimaitaitari ikantaitziri: “Cristo, ¿Tiima Kamantantaniri pinatzi, incha pinkantina iita pajawaitzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ari isaikaki Pedro jikokiroki, iro oñaantapaakariri otzikataawo, okantapaakiri: “¿Tiima iiroka itsipata pairani Jesús jirika Galilea-jatzi?” ");
INSERT INTO cpcNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Iro kantacha ojyiki ñaakiriri Pedro jotikanakiro, ikantaki: “Tiitya, tii niyotziri iita pikantanari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ari ishitowaniintanaki Pedro jikokiroki. Ari oñaapairi pashini otzikataawo, okantapaakiri itsipatakari: “Irijatzi jirika itsipata pairani Jesús Nazaret-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ari japiitanakiro Pedro jotikanakiro, ikantanaki: “Apa jiyotzi Pawa, tii niyotziri naaka pikantanari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tikira osamanitzi, japiitakiri itsipatakari ikantziri: “Iirokataki itsipatapiintari Jesús, tima Galilea-jatzi pinatzi, iriiwaitaki ikantziro jiñaawaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ikantanakiri: “Tiiwí, tii niyotziri jirika pikantanari. Jiyotzi Pawa nothiiyarika, jowasankitainaata”. Aripaiti jiñaanaki tyoopi. ");
INSERT INTO cpcNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ari ikinkishiritanairo Pedro ikantakiri pairani Jesús: “Tikira jiñiita tyoopi, mawajatzi potiki, pinkanti: ‘Tii noñiiri Jesús’ ”. Shitowanaki Pedro, antawoiti jiraawaitanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Okanta okitiijyitamanai, apatotamanaa jiwariiti itsipatakari Antaripiroripaini, ikamantawakaiyakani intsitokiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ipoña joojotaitanakiri Jesús, jaitanakiri isaiki Poncio Pilato, jiwaripirori jinatzi jirika. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ikanta Judas aakaantaniri, jiyotanaki jowamaakaantashitakari Jesús. Antawoiti ikinkishiritanaka, jataki joipiyainiri 30 kiriiki ijiwari Ompiratasorintsitaari, iijatzi Antaripiroriiti, ");
INSERT INTO cpcNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ikantapairi: “Jirika piiriikiti. Tii okamiithatzi okaatzi nantakiri. Tikaatsi janti Jesús naakaantashitakari”. Ikantaiyanakini irirori: “Intaanitya, piyotziro iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jookanakiri kiriiki janta tasorintsipankoki, ishiyapirotanakitya ipiyanaka, irojatzi ishirikantapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ikanta ijiwari Ompiratasorintsitaari, jagairi kiriiki, ikantaiyini: “Tii okamiithatzi ankimpoyagairi kiriiki, iriitaki apinatakiriri intsitokantaityaariri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ari josampitawakaiyani: “¿Tsika ankantirika aaka jirika kiriiki?” Ipoña ikantaiyini: “Thami amanantantyaawo pitzitharipathatatsiri kipatsi, inkitaitiri aririka inkamayiti kaari ajyininkata”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Irojatzi iroñaaka jiiyiitziro jiroka kipatsi: “Iraantsipatha”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ari imonkaatakari josankinatakiri pairani Kamantantaniri Jeremías, ikantaki: Jagaitakiri 30 ipiwirya kiriiki, Okaatzi ikowaiyakirini icharinipaini Israel impinatiri, ");
INSERT INTO cpcNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iri jamanantaitantakawori pitzitharipatha, Irootaki ikowakaakinari Pinkathari namanantiro. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aritaki ariitaka Jesús isaiki jiwaripirori, josampitawakiri, ikantziri: “¿Iiroka iwinkathariti Judá-mirinkaiti?” Ari jakanaki Jesús, ikantzi: “Irootaki pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ikanta ijiwari Ompiratasorintsitaari itsipayitakari Antaripiroriiti, ojyiki ikantakowitapaakari Jesús. Tii jakimaita irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ikantzi Pilato: “¿Tiima pikimi okaatzi ikantakoitzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Iiniro jimairitaki, tii jaki. Jotzikanaminthatanakari Pilato jirika Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tzimatsi jamitapiintari jiwaripirori: maawoni osarintsi aririka joimoshirinkaiyaani Judá-mirinkaiti, jomishitowakaantzi ijyininka jaakaantaitziri itzimirika inkowaiyakirini. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tzimatsi apaani Judá-mirinka jaakaantaitziri jiita Barrabás, ikimakoitani jinatzi jirika jantakiro kowiinkatatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ikanta japatotaiyakani atziriiti, josampitantaki Pilato, ikantzi: “¿Iitaka pikowiri nomishitowakaantiri? ¿Iriima Barrabás? ¿Iriima pikowi Jesús jiitaitziri Cristo?” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jiyotaki Pilato ikisaniintashitaitari Jesús, irootaki jaakaantaitantakariri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tima inkaanki, okantakaantakiri iina Pilato, okantaki: “Iiro pimaamaniwaitziri iiroka kamiithashiriri. Owanaa jomishimpiyaakaantakina tsiniripaiti jariitashiryaakina”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Iro kantacha ijiwari Ompiratasorintsitaari itsipatakari Antarikonapaini, jowatsimaakiri atziriiti, inkantaiyini: “Iro kamiithatatsi jomishitowaitiri Barrabás, iriima Jesús intsitokaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ipoña japiitanakiro jiwaripirori josampitantzi: “¿Iitaka pikowiri nomishitowakaantairi?” Ari ikantaiyini maawoni: “¡Iri Barrabás!” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ari ikantzi Pilato: “¿Tsikama nonkantirika Jesús jiitaitziri Cristo?” Jakaiyini atziri: “¡Pimpaikakotakaantiri!” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ari ikantzi jiwaripirori: “¿Tzimatsima kaaripirori jantakiri?” Iikiro ishintsitatzi ikaimaiyini atziriiti, ikantzi: “¡Pimpaikakotakaantiri!” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ari jiyotanaki Pilato aminaashiwaita josampitantzi, owanaa ikatsimashiritaki atziripaini. Ikaimakaantaki jiñaa, jiñaitakiri maawoni ikiwaakotanaka, ikantanaki: “Tii naaka kowatsini nontsitokakaantiri jirika kamiithashiriri. Pikowaiyirinika, iiroka yotaiyironi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ikantaiyanakini iriroriiti: “Nokowaiyini, naakataki jookantaitya oityaarika awijatsini, jookantaityaari iijatzi nowaiyanipaini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ari jomishitowakaantaitakiri Barrabás. Iriima Jesús ipajatakaantaitanakiri, jiyakawintakiri impaikakoitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ikanta owayiriiti, ityaakaanakiri Jesús ipankoki Pilato jiitaitziro “Pretorio”. Ari japatowintakari maawoni owayiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Jaatonkoryaakiri Jesús, ikithaataitakiri kithaarintsi pitzirishimawotatsiri ojyawori ikithaatapiintari pinkathariyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jamathaitantakari kitochiitapo iitoki, joirikakaitakiri jakopiroriki sawookaaki. Ipoña jotziirowashitari Jesús ithainkimawaitziri, ikantaiyini: “¡Paapatziyawatyaari iwinkathariti Judá-mirinkaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ojyiki jiiwapoowaitakiri, jompojainawaitantakari sawookaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ikanta jishitakiro ishirontaminthawaitakari. Jaatonkoryagainiri ikithaatakiriri inkaanki, ikithaatairi iithaari, jaanakiri impaikakoitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ikanta jiyaataiyanakini, itonkiyotakari Simón poñaachari Cirene, ishintsiwintaitakiri jinatanakiro impaikakotaitantyaariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Irojatzi jariitantakari tonkaariki oita Gólgota (akantziro aaka: Atziriitoni.) ");
INSERT INTO cpcNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ari ipakowiitakari Jesús imiri itsipataitakiro iyipitintsi, ikanta ithowitawakawo kapichiini, tiimaita jiriro. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ari ipaikakoitakiri. Ikanta owayiriiti jaakiro ikithaayitari Jesús, ipawakaakawo, ikimitakaantakiro jiñaaritaita iro jiyotantyaari iitarika ayironi. Ari imonkaatakari ikinkithatakotakiri pairani Kamantantaniri, ikantaki: Iñaariwintaitakawo noithaari, Ipawakaayitakawo. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ari isaikawintaiyirini, jaamaakowintari. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ipoña josankinaitaki kantakaantakirori ipaikakoitantakariri, okantzi: JIRIKA JESÚS, IRIITAKI IWINKATHARITI JUDÁ-MIRINKAITI. Jontarikakoitakiniri ipatziitoki. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ari itsipataitakiri apiti koshintzi, ikatziyakotaka apaani jakopiroriki, pashini jampatiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ithainkimatakiri ikaatzi awijayitatsiri janta, jotikayinata, ");
INSERT INTO cpcNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ikantaitziri: “Aña iiroka pookirori tasorintsipanko, iro awijaki mawa kitiijyiri piwitsikairo iijatzi. Iirokami Itomi Pawa ¿Iitama kaari payiitanta ipaikakoitakimi? Powawijaakotaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Irojatzi ikantakiri iijatzi ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti, Fariseo-paini, iijatzi Antaripiroriiti, ikantaiyini: ");
INSERT INTO cpcNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Jowawijaakotziri pashini, ¿kaarima jimatantawo jowawijaakotya irirori, iriimi iwinkathariti Israel-mirinkaiti? ¿Arimi jowawijaakotatya ipaikakoitakiri, aritaki ankimisantakirimi? ");
INSERT INTO cpcNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jawintaawitakari Pawa, incha añiiri imapirorika jitakotari ari jowawijaakotairi. Tima ikantapiintzi: ‘Naaka Itomi Pawa’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jimatsitakawo koshintzipaini itsipatakari ipaikakota, ithainkawaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ikanta itampatzikatapaaki ooryaatsiri, omapokashitapaaka otsiniritanaki, irojatzi jyiitiini ithapirotanaka ooryaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ari ikaimanaki Jesús shintsiini, ikantanaki: “¡Elí! ¡Elí! ¿Lama sabactani?” (Iro ikantaitziri añaaniki aaka: “¡Pawá! ¡Pawá! ¿Iitama pookawintantakinari?”) ");
INSERT INTO cpcNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ikanta ikaatzi saikawintakiriri, ikimawitawakari ikaimanaki, ikantaiyini: “Pinkimiri, ikaimatziiri Elías”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ipoña ishiyapainta apaani, jomitsitsiyapaintzi manthakintsi kipijyaariki, jankowiitakiniri sawoopankiki, jowaankakotakiniri jatsimiyaatawakiromi. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ikantaiyini pashini: “Añaawakiriita ari impokaki Elías jowayiitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ipoña japiitanakiro ikaimanai shintsiini, piyakotanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Okanta tasorintsipankoki, sagaanaki niyanki tontamawotatsiri ithatashiitzirori, apikota okantanaka, opoñaanaka jinoki irojatzi isaawiki. Antawoiti ontziñaanaka tankayitanaki mapi. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ithonka ipookakoyitanaki kaminkari, añaayitai ojyiki kamiithashiriri kamayitaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Tima jañagai pairani Jesús, ikaatzi añaayitanaatsiri ishitowanairo omooki jiyaatai iriroriiti nampitsiki tasorintsitatsiri, joñaagayitantaa. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ikanta ijiwari owayiriiti itsipayitakari ikaatzi katziyawintakariri Jesús, jiñaakiro ontziñaanaka, jiñaakiro okaatzi awijayitaintsiri, antawoiti ithaawanaki, ikantanaki: “¿Imapirowitatyaama Itomitari Pawa jirika?” ");
INSERT INTO cpcNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tzimatsi iijatzi janta tsinanipaini aminakotakiriri, irootaki poñainchari Galilea-ki oyaatakiriri Jesús, ojyiki amitakoyitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jiroka okaataiyini: María Magdala-jato, María inaanati Jacobo iijatzi José, ari osaikaki iijatzi inaanati itomipaini Zebedeo. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ikanta otsiniriityaanaki, ari ipokaki ajyaagantachari poñaachari Arimatea, jiita José. Irijatzi jiyotaapiintakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jiyaatashitakiri Pilato, ikantapaakiri: “Pishinitinari nonkitatairi Jesús”. Ikanta Pilato ikantakaantaki jaanairi inkitatairi. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ikanta José iponatantakari Jesús manthakintsi kititatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jowakotakiri owakiraanataki jimoontashiitziri kaminkaripaini shirantaaki, joipinaakaantaki antawoiti mapi, jojyipitakotantakari. Piyanaka José. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Okanta María Magdala-jato, iijatzi pashini María, osaikawintapaintziri tsika ikitaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Okanta awijanaki jiwitsikawintapiintaitawo kitiijyiri jimakoryaantaitari, ari jiyaataki ijiwari Ompiratasorintsitaari itsipatakari Fariseo-paini janta ipankoki Pilato, ");
INSERT INTO cpcNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ikantapaakiri: “Pinkatharí, chapinki iiniro jañaawita amatawitantaniri, nokimiri ikantzi: ‘Aririka nonkamawitatya, iro mawatapaintsini kitiijyiri, aritaki nañagai’. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nokowi potyaanti aamaakowintyaarini irojatzi imonkaatantatyaari mawa kitiijyiri. Aamaashitya jiyaataki tsiniri jiyotaanipaini, jagaatiri. Impoña inkanti: ‘¡Añagai Jesús!’ Aririka jimatakiro, ari owatsipirotatya jamatawitanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ari ikantanaki Pilato: “Jirika owayiriiti, paanakiri, pinkantiri jaamaakowintyaari tsika okaatzi pikowiri iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ari jiyaataiyanakini, jiwichaakotapaakiri omooki. Ari isaikawintaiyirini. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Okanta awijanaki kitiijyiri jimakoryaantaitari, aritaki kitiijyitamanai itapiintawori kitiijyiri. Ari iyaatamanai María Magdala-jato otsipatanakawo pashini María aminairo tsika ikitaitakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ari ontziñaanakari shintsiini kipatsi, tima jayiitapaakitzi inkitiwiri maninkariiti jotainkapaakiro mapi jashitantaitakawori omoo, isaikantapaakawo. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Shipakirya ikantapaaka ikimitapaakawo ookathawontsi. Kitamaaniki okantaka iithaari kimiwaitaka jiriniki. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ikanta owayiriiti aamaakowintawitariri, jiñaawakiri, antawo ithaawaiyanakini, kimiwaitaka inkamanakityiimi. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ikanta maninkariiti, ikantanakiro tsinanipaini: “Iiro pithaawaiyini iiroka. Niyotaki iri pipokashitzi Jesús ipaikakowiitakari. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tii añiiri jaka, añagai. Tima ari ikantsitaka pairani. Pimpoki, paminiro tsika jowawiitakari Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pimpiyanaki, pinkamantairi jiyotaanipaini, pinkantiri: ‘Añagai Jesús, piyaatai Galilea-ki, ari piñaayitairi’. Aritaki ikamantsitakimi kitziroini”. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Okanta opiyanaka iyokitzi okantayitanaka. Iro kantacha antawoiti okimoshiritanaki, oshiyashitanakari jiyotaani onkamantayitiri. Oshiyaminthaita iyaati onkamantanti, ");
INSERT INTO cpcNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ari joñaagakawo Jesús, jiwithatawakawo. Iyaatashitanakiri okaakiini, otziirowashitapaakari, awithakitiri iitziki. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ipoña ikantziro Jesús: “Iiro pithaawi, piyaati pinkamantayitairi nirintzitaari, jiyaataita Galilea-ki, ari jiñaayitainari”. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Okanta opiyaiyanaka tsinani onkamantanti, jatanaki iijatzi owayiriiti nampitsiki, ikamantapaakiri ijiwari Ompiratasorintsitaari okaatzi awijaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ari japatotaiyanakani Antaripiroriiti, ikantawakaiyani: “¿Tsika ankantyaaka omanakotantyaariri?” Ikaimaitakiri owayiri, ikantziri: “Jirika ojyiki nompinatimiri, ");
INSERT INTO cpcNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","pinkantayitiri atziriiti: ‘Niyankiiti tsiniri, nomaanaki. Aamaa ari ipokaiyakini jiyotaani, jaanairi’. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aririka inkimaki jiwari, naakataki kantakowintimini iiro jowasankitaantzimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ari jimatakiro owayiriiti, jaakiri ipinaitakiriri, jantakiro okaatzi ikantaitakiriri. Irootaki jantitaari maawoni Judá-mirinkaiti jiroka, irojatzi iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ikanta 11 jiyotaani Jesús, jataiyakini Galilea-ki osaiki otzishi ikantakiri pairani Jesús ari jiñiiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ikanta jiñaawairi, jotziirowashitawaari. Tzimayitatsi iijatzi kisoshiriwintawairiri. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ikanta itsipatapaari Jesús, ikantapairi: “Impinkathapiroitaina inkitiki iijatzi kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Irootaki nokantantzimiri: Piyaatiro maawoni nampitsi, pinkimisantakaayitairi atziripaini, pothotyairo maawoni. Aririka inkimisantayitai, powiinkaayitairi, pimpairyagairi Ashitairi, Itomi, iijatzi Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Piyotaayitairi atziripaini jantayitairo okaatzi nokamantayitakimiri. Ari nontsipatapiintaimi naaka, kiso nowimi irojatzi paata onthonkantaiyaari kipatsi”. Ari onkantyaari.");
INSERT INTO cpcNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jiroka okanta opoñaantanakari Kamiithari Ñaantsi kinkithatakotziriri Itomi Pawa, iitachari Jesucristo. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pairani tzimatsi Kamantantaniri jiita Isaías. Josankinatakotakiri Pawa ikamantziriri Itomi, ikantziri: Notomí, ari notyaantaki ityaawoni inkamantakotimi, Iriitaki witsikaantimini. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ikaimakaimatapaaki otzishimashiki, ikantantaitzi: Powamiithatainiri Pinkathari tsika inkinapaaki. Pinkimitakaantiro jotampatzikaitziro aatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ari okantzimaitaka, monkaataka ikinkithatakoitakiri. Kinkithataki pairani Juan otzishimashiki, ikinkithatakotapaakiro owiinkaataantsi, ikantantapaaki: “Powiinkaawintaiyaari Awinkathariti, powajyaantairo kaaripirori, aritaki impiyakotaimiro pikaaripiroshiriwaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ojyiki pokashitakiriri Juan, Judea-jatzi ipoña Jerusalén-jatzi. Ikamantakoyitapaakiro ikaaripiroshiriwaitzi, irootaki jowiinkaatantakariri jiñaaki Jordán. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iithaari Juan, jontyaitziro iwitzi camello. Jowathakitari mishinantsimashi. Jañaantari jowari kintori, jimiritari iyaaki pitsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jiroka ikantaki Juan ikinkithatzi: “Aatsikitaki mapirotzirori ipinkatharintsitzi, nopinkathatsitataikari naaka. Tii onkantaajaiti inkimitakaantina jimpiratani onkantya noiyotashitantyaariri nonothopaitsitiri i-zapato-ti. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iriitaki kimitakaantyaawoni jowiinkaatantatyairimi Tasorintsinkantsi. Naakamachiini nowiinkaatantawo jiñaa”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ikanta ipokaki Jesús ipoñaakawo nampitsiki Nazaret saikatsiri Galilea. Jowiinkaatawakiri Juan antawaaki jiñaa Jordán. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iro intonkaimatimi Jesús, kimiwaitaka ashitaryaanakityiiyaami inkiti, iñaawakiri ijyaawiinkashitapaakiri Tasorintsinkantsi ikinapaaki jinoki jojyapaakari shiro. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ikimaitatzi jinoki ikantaitanaki: “Iirokataki Notomi nitakopirotani. Ojyiki nokimoshiriwintakimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ikantakaanakari Jesús Tasorintsinkantsi, jataki otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ari ikowawitakari Satanás inkaaripiroshiritakairimi. Tima ojyiki kitiijyiri isaikawaitzi janta itzimira kowiinkari piratsi, okaatzi 40 kitiijyiri. Iro ipokantapaakari maninkariiti jimitakotapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ipoña ikinanaki Jesús Galilea-ki ikamantantziro Kamiithari Ñaantsi kinkithatakotziriri Pawa impinkathawintantai. Aritaki jomontyaitakiri Juan irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ikantantapaaki Jesús, ikamantantzi: “Monkaatapaaka jiñiitantyaawori impinkathawintantai Pawa, pinkimisantairo Kamiithari Ñaantsi. Powajyaantairo pikaaripiroshiriwaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Okanta pashini kitiijyiri ikinanaki Jesús inkaarithapiyaaki Galilea, jiñaapaakitziiri iitachari Simón itsipatakari iririntzi Andrés ishiryaataiyini. Tima shiryaatzinkari jinaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ikantapaakiri: “Poyaatina, onkimiwaityaawo iroñaaka iriimi atziri noshiryaatakagaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aripaiti joyaatanakiri, jookanakiro ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iro jiyaatanakitziimi kapichiini, iñaapaakitziiri itomipaini Zebedeo iitachari Jacobo itsipatakari iririntzi Juan, isaikaiyini ipitoki ishirikiro ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jaanakiri iijatzi. Iiniro isaikanaki iwaapati itsipatanaari jatziritipaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aritaki ariitaiyakani Jesús nampitsiki Capernaum. Okanta kitiijyiri jimakoryaantaitari, jiyotaantapaaki japatotapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tii omaanta ishintsinka jiyotaantzi, janaanakiri Yotzinkariiti, iyokitzi ikantaiyanakani. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ari isaikitsitakari janta atziri piyarishiritatsiri, kaimanaki irirori, ");
INSERT INTO cpcNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ikantzi: “Jesús, Nazaret-jatzi, niyotzimi naaka, iirokataki itasorintsiti Pawa. Iro pipokantari jaka papiroyitaina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ikantanaki Jesús: “¡Pimairiti piyari! ¡Piyaatai!” ");
INSERT INTO cpcNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ikaimanaki shintsiini atziri, jompitatakaawaitanakari iwiyariti, jookanakirira. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ikantawakaanaka atziriiti: “Piñaataitiri jirika, ikitsirinkiri jowawisaakotziri piyarishiritatsiri”. Iyokitzi jowapiroitanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Thaankiini ikimakoitanakiri Jesús janta Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ikanta ishitowanai Jesús japatotapiintaita, jaanakiri Juan ipoña Jacobo, ikinaiyanakini ipankoki Simón, isaiki iijatzi Andrés iririntzi Simón. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Iro jariitapaakityaami, ikantaitawakiri: “Okatsinkaakiwaitatzi riyoti Simón”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iikiro ipithokashitawo, ikathawakotakiro, joosaikakiro. Kaatanaki okatsinkaakiwaiwita. Piriintanaka aminayitawakiniri oita ompawakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Okanta otsiniriityaanaki, jamaitapaakiniri Jesús ojyiki mantsiyari, jamaitakiniri iijatzi ojyiki piyarishiritatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ipiyowintapaakari pankotsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Joshinchaayitairi maawoni. Tiira ishiniti apaani piyari iñaawaiti joshinchaayitziri ikaatzi piyarishiritatsiri. Tima jiyotzi piyari irirori tsika jiita Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Okanta oñaatamani, ananinkanaki Jesús jamana otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ikanta Simón itsipatakari ikaatzi joyaataiyirini, jaminaminatairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ikanta jiñaapairi, ikantapairi: “Yotaanari, jaminaminaitatziimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jakanakiri irirori ikantzi: “Thami aati, tiira iro nompokantyaari nosaiki jaka, ontzimatyii niyotaantayiti iijatzi pashiniki nampitsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ari okantzimaitaka, ithonkakiro Jesús janiitakiro Galilea-ki, jiyotaantaki maawoni nampitsi tsika japatotapiintaita, joshinchaayitairi ojyiki piyarishiriyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ipoña ipokaki imatziri pathaawontsi, jotziirowashitapaakari Jesús, ikantapaakiri: “Pikowirika, poshinchagaina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jaminanakiri Jesús, jitakoshiritanakari. Jotirotantakari irako, ikantziri: “¡Nokowi, pishintsitai!” ");
INSERT INTO cpcNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Shintsitanai ipathaawaiwita. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ikantawitawaari jiyaataira inampiki, ");
INSERT INTO cpcNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ikantziri: “Iiro pithawitakotana. Tampatzika piyaatashitanakiri Ompiratasorintsitaari, pimonkaatairo ikantakaantakiri pairani Moisés-ni, paanaki pinkitiwathatantaiyaari, iroora jiyoyiitantaimini ishitakotaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Iro kantzimaitacha pathaawaiwitachari, ikamantantanaki nampitsiki tsika okanta ishintsitantaari. Iro kaari okantantanaa isaikanai Jesús nampitsiki ijyikitapaakira atziri. Jataki otzishimashiki, ari isaikakiri. Aritzimaitaka jiyaashitziri ojyiki atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Awisaki tsika okaatzi kitiijyiri, iijatzi ipiyaa Jesús nampitsiki Capernaum. Ikimayitawai atziripaini, ikantaitzi: “Ariitaa Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ipiyowintawaari iijatzi, tii jimonkaatapaakawo pankotsi. Jiyotaayitapairi maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tzimatsi 4 atziri pokashitakiriri Jesús jinatakotakiri kisopookitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tii okantzi jiñiiri, jotzikakiri atziriiti piyotainchari. Atiitanaki jinoki pankotsiki, jimoontakiro ikatziyakara Jesús, jowayiitakotakiniri mantsiyari. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ikanta Jesús, jiyotakotawakiri jawintaashiritatyaari, jiñaanatawakiri mantsiyari, ikantziri: “Notomí, ipiyakoitaimiro pikaaripiroshiriwaitaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Kimaki Yotzinkariiti, ikantashiritanaki irirori: ");
INSERT INTO cpcNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ithainkakiri Pawa jirika. Tima tikaatsi kantironi impiyakotantiro kaaripirori, apaniro ikanta Pawa ipiyakotantziro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yotaki Jesús ikinkishiritari, ari josampitziri, ikantzi: “¿Oitama pikinkishiriwaitantawori jiroka? ");
INSERT INTO cpcNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tiima okamiithatzimotzimi nokantakiri kisopookiri: ‘Ipiyakoitaimiro piyaaripiroshirinka?’ ¿Irooma pikowi nonkantiri: ‘Pinkatziyi, paanairo pomaryaaminto, piyaatai?’ ");
INSERT INTO cpcNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Iroñaaka piñiiri Itomi Atziri tzimatsi ishintsinka, ipiyakotziri kaaripiroshiririiti”. Ipithokashitanakari kisopookiri, ikantanakiri: ");
INSERT INTO cpcNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“¡Pinkatziyi! Paanairo pomaryaaminto. Piyaatai”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Katziyanaka mantsiyari, jaanairo jomaryaaminto, shitowanaki. maawoni atziri jiñaawakiri. Iyokitzi ikantaiyanakani jiñaayitawairira. Ikimoshiriwintanakiri Pawa, ikantaiyanakini: “Imapiro okamiithataki jiroka. Tii añaapiintziro ojyawori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ipoña japiitapairo Jesús jiyotaayitapairi atziri inkaarithapiyaaki. Ari ipiyowintapaari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ikanta ithonkanakiro jiyotaantzi, awisanaki. Irojatzi jiñaantapaakariri itomi Alfeo iitachari Leví, isaiki irirori ikowakoyitziri kiriiki ijyininkapaini. Ikantapaakiri: “¡Poyaatina!” Katziyanaka, joyaatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ipoña Leví irirori, jaanakiri Jesús jowakaiyaari ipankoki. Ari jiyaatsitakari iijatzi jiyotaani, itsipatapaakari kowakoyitziriri ijyininka kiriiki, ipoña kaaripiroshiririiti. Ojyiki piyotainchari jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ikanta Fariseo-paini itsipatakari Yotzinkariiti, josampitakiri jiyotaani Jesús, ikantziri: “¿Oitama itsipatantariri yotaimiri kaaripiroshiririiti, itsipatsitakari iijatzi kowakotziriri ijyininka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ari jakanaki Jesús, ikantanakiri: “Aririka imantsiyati atziri ipokashitziri aawintantzinkari, iriima atziri kaari mantsiyatatsiri tikaatsi inkowi irirori. Tii apa nompokashitiri kamiithashiririiti nonkaimashiriyitairi, aña nopokashitatziiri kaaripiroshiririiti nonkaimashiriyitairi iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tzimatsi pokashitakiriri Jesús, josampitapaakiri ikantziri: “Itzitapiintakawo jiyotaani Juan jowanawo, ari ikimitsitari jiyotaani Fariseo-paini. ¿Oitama kaari itzitantawo piyotaani iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jakanaki Jesús, ikantziri: “Aririka intsipataityaari aawakaachari, ¿Arima jowashiriniintawaitatya? Kimitaka iiro, aña kimoshiri ikantaiyani jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Irooma paata, aririka jagaitakiri jiimintaitari, aripaiti intziwaitaiya. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Aririka jowapatankaitantyaawo owakiraari osapiki paijatori ikithaataitari, arira osapiryaapirotanaki amithatanatyaarika owakiraari. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Iroora kamiithatatsiri owantyaawo iiryaari jimiritaitari owakiraanakiriki mishinantsinaki. Irooma jowantashiitatyaawo paijatonaki, ari osanaryaakotanaki, apitiroiti apaatashiwaitatya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Okanta kitiijyiri jimakoryaantaitari, ikinanaki Jesús pankirintsimashiki. Ari joyiikitanakiri jiyotaani okithoki pankirintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tii inimotziri Fariseo-paini, josampitakiri Jesús, ikantanakiri: “¿Oitama joyiikitantawori piyotaani? ¿Tiima jiyotzi tii oshinitaantsitzi kitiijyiriki jimakoryaantaitari?” ");
INSERT INTO cpcNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jakanaki Jesús ikantzi: “¿Tiima piñaanatakotziri ikantakota David-ni itsipatantakariri ikaataiyini ikamantawitakari itajyi? ");
INSERT INTO cpcNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ityaaki tasorintsipankoki ipinkathariwitara Abiatar-ni, jowakawo tasorintsitanta, ipakiri iijatzi itsipayitakari. Tiira oshinitaantsiwita, apa jowapiintawitawo Ompiratasorintsitaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iikiro ikantanakitzi Jesús: “Iriira atziriiti kantakaantzirori jiwitsikantaitakanariri kitiijyiri jimakoryaantaitari. Kaari kitiijyiri jimakoryaantaitari kantakaantzirori jiwitsikantaitakariri atziripaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jirika Itomi Atziri ipinkatharipirotzi irirori, janairo jiroka kitiijyiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ipoña ityaapai iijatzi Jesús japatotapiintaita. Ari isaikitsitakari atziri kisowakori. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ikowaitatziira jiñiitiri joshinchaayitairi mantsiyari kitiijyiriki jimakoryaantaitari. Kimpoyaa jowaitanakiri, onkantya inthawitakotantyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ipoña Jesús ikaimakiri mantsiyari, ikantziri: “Pimpoki, posatitya niyanki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Josampitakiri piyowintakariri: “¿Otzimika shinitaantsitatsiri antiri kitiijyiriki jimakoryaantaitari? ¿Tiima okamiithatzi anishironkatanti, irooma kamiithatatsiri owamaanti? ¿Tiima okamiithatzi antiro iroopirotatsiri, irooma kamiithatatsiri ankaaripirowaiti?” Tikaatsi akanaintsini. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jotsikanatanakari Jesús piyowintakariri, owatsimaashiritanakiri jiñaakiri tii jinishironkayitantzi, ikantanakiri mantsiyari: “¡Pintharyaawakotai!” Matanaka, akotsitanai kamiithaini atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ikanta Fariseo-paini, jataki inkinkithawaitakairi aapatziyariri Herodes jamini tsika inkantiri jowamaakaantantyaariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ipoña ishitowanaki Jesús, ikinanai inkaarithapiyaaki itsipatanaari jiyotaani. Joyaatani jowanakiri Galilea-jatzi, Judea-jatzi, ");
INSERT INTO cpcNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalén-jatzi, Idumea-jatzi, maawoni nampiyitawori intatsikironta antawaaki jiñaa Jordán. Ikimakotakiri iijatzi Tiro-jatzi, Sidón-jatzi, ikantaitzi: “Ojyiki itasonkawintantaki Jesús, jantaki ojyiki kaari jiñaapiintaitzi”. Pokaiyapaakini iriroriiti jiñiiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Irootaki Jesús ikantantanakariri jiyotaani jamakiniri pitotsi, iiro jawitsinagaitantari. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jimatakiro Jesús, joshinchaayitaki ojyiki. Otatsinkapirinikitawakaanaka mantsiyari ikowi jotirotantawatyaari jako. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ipokayitzi piyarishiritatsiri, jotziirowashitari Jesús, ikaimimaita shintsiini, ikantzi: “¡Iiroka Itomi Pawa, niyotzimi naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Onkantya iiro jiyotsitantaitari Jesús, ikisayitanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ipoña itonkaanaki Jesús otzishiki. Arira ikaimakaantapaakiri ikaatzi kamiithatzimotakiriri. Jataiyakini ikaatzi ikaimakaantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aripaiti jiyoshiitakiri 12 intsipatapiintyaari, iriitaki jotyaantiri inkinkithatakaantayiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ipasapiyaakari joshinchaayitairi irirori mantsiyari, ikaatzi piyarishiriyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jirika ikaatzi jiyoshiitakiri: Simón, jiitairi Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ipoñaapaaka Jacobo itomi Zebedeo itsipataakiri Juan, irijatzi iririntzi Jacobo. Jiitairi “Boanerges”, (akantziri añaaniki aaka: “Otomi ookathawontsi”.) ");
INSERT INTO cpcNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ipoñaapaaka iijatzi Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo itomi Alfeo, Tadeo, iijatzi Simón iitachari “Kisakowintantaniri”, ");
INSERT INTO cpcNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ipoñaapaaka Judas Iscariote, pithokashitaiyaarini. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ipoña ipokaiyaini Jesús pankotsiki. Ari ipiyowintawaari ojyiki atziripaini, tii okantzi jiyaatapainti jowaiya Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tzimatsi kantayitanaintsiri: “Shinkiwintaka Jesús”. Iro ipokantawitakari ijyininkathoriiti, jaanairimi. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ariitaiyapaakani iijatzi Yotzinkariiti ipoñaayitaka Jerusalén-ki, ikantapaaki irirori: “Jirika atziri joshinchaatziiri ashitariri piyari iitachari ‘Beelzebú’, irootaki joshinchaantariri piyarishiriyitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ikanta ikimaki Jesús, japatotaiyakirini, jojyakaawintatziiniri, ikantziri: “¿Tzimatsima piyari kaminaawakaachari iiro jaagantanta? ");
INSERT INTO cpcNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aririka jantaminthatawakaiya atziri ipinkathariwintantzi nampitsiki, jookawintawakaa. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Aririka jantaminthatawakaiya iijatzi atziri ikaatzi isaikaiyini ipankoki, jookawintawakaa. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ari ikantari iijatzi piyari aririka jantaminthatawakaiya, jookawintawakaa, iiro iñiiro ishintsitai, ari japirotaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Atziri ñaapirotachari kamiitha, tikaatsi matirini intyaashitiri ipankoki jayitiri tzimimotziriri irirori. Irooma aririka joojoitakiri, aritaki jimatakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pinkimi nonkantimi: kantatsi Pawa impiyakotairi kaaripiroshiriwaitatsiri, onkantawitatya jookimowaiwityaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Iriima ookimowaitziriri Tasorintsinkantsi, jashi jowairo, iiro ipiyakoitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Irootaki ikantantakariri Jesús, tima ikantaitatziiri: “Kamaari jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ariitapaaka inaanati Jesús otsipatakari iririntzipaini, okaimakaantapaakiri, okatziyapaaka jikokiroki. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ikantawitakari apatowintakariri: “Ari opoki pinaanati otsipatakari pirintzipaini, okowi oñiimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ikantanaki Jesús: “¿Oitama pikinkishiritari iiroka iro nonaanatitari, iri nirintzitari?” ");
INSERT INTO cpcNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ipithokashitanakari apatowintakariri, ikantzi: “Jirika, iriiyitaki nokimitakaantaari nirintzi, nokimitakaantaari nonaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ikaatzi antanairori ikowayitziri Pawa, iriitaki nirintzitaari, notsirotaari, irojatzi nonaanatitaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ipoña ipiyanaa iijatzi Jesús inkaarithapiyaaki, jiyotaantapai. Ipiyowintaitawaari. Otitanaka pitotsiki, saikakotaki niyanki kapichiini, katziyaiyachani atziriiti othapiyaaki ikimisantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","maawoni jiyotaayitziriri, jojyakaawintatziiniri, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Tzimatsi pankiwaitatsiri, jataki ipankiwaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Okanta jookakitakiro iwankiri, tzimatsi ookakitapainchari aatsiki. Ipokaiyapaakini tsimiri, jowapaakawo. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tzimatsi pashini ookakitapainchari omapipookitzi. Thaankipiroini ojyookawitanaka. Tiira otontapathapirotatzi kipatsi, ");
INSERT INTO cpcNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","sampishitanaki pankirintsi jooryaapaakira ooryaa. Tima tii ontyaapiroti oparitha inthomainta. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tzimatsi pashini ookakitapainchari okitochiimashitzi, anaanakiro iroori ojyookanaki. Tii okithokitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tzimatsi pashini ookakitapainchari okamiithawanikitzi kipatsi, saankana ojyookapaaki, kithokitanaki maawoni. Tzimayitai okithoki apaanipaini okaatzi jyookaintsiri. Apaani jyookapaintsiri, kapichiini okithokitanaki, pashini ojyikini okanta, pashini ojyikipirotanai okithoki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iikiro ikantanakitzi Jesús: “Kowatsiri inkimathatiro, jowakimpitatya inkimisanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aritaki jataiyaini maawoni atziri, apa isaikaki Jesús itsipayitanaari oyaayitapiintakiriri, ipoña 12 jiyotaani. Ari josampitaiyakirini Jesús, ikantziri: “¿Oitaka pojyakaawintakinari inkaanki?” ");
INSERT INTO cpcNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jakanakiri Jesús, ikantzi: “Iroñaaka nonkamantimiro kaari piyowitaiyani, aritaki piyotairo tsika ikanta Pawa ipinkathawintantzi. Iriima pashinipaini, iiro nokamantsitari irirori, apa nojyakaawintashityaanari, ");
INSERT INTO cpcNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","onkantya iiro ikimathatantawo ikimawitakari. Onkantawitatya inkimisanti, iiro ikimathatziro, iiro ipashinishiritai, iiro ipiyakoitairi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ipoña Jesús josampitanakiri, ikantziri: “¿Tiima piyotawakiro nojyakaawintakiri? Aririka napiitakimiro nojyakaawintimiro, ¿tsikatya pinkantya piyotantyaawori? ");
INSERT INTO cpcNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tima jirika atziri ookakitakirori iwankiri, iriira ojyakaawintachari kinkithatzirori iñaani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tzimatsi kimawitawori ñaantsi, ipokapaaki Satanás, imaijantakaapaakiri. Iriiyitaki ojyakaawintziri ookakitapainchari aatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Tzimatsi kimawitawori ñaantsi, ikimisantawita thaankiini. Jojyakowitakawo ookakitapainchari omapipookitzi, ojyookawitanaka thaankiini. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Tiira jiyotakopirotatyiiro ñaantsi, tii inkisashityaawo ikimaatsikowintawo ikimisantawitawo ñaantsi, jowajyaantanakiro. Jojyakotakawo pankirintsi sampishitanaintsiri, tii ontyaapirotatyi oparitha inthomainta kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Tzimatsi pashini kimawitawori ñaantsi, ojyakaawintakiri ookakitapainchari kitochiimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Okantakaantziro jamatawiwaita apaniroini, ikinkishiryaakotawo jajyaagantya, iro ikowapirotakiri ontzimimotairi maawoni. Anaanakiro ñaantsi ikimawitawakari, jojyakawo pankirintsi kaari kithokitatsini. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tzimatsi kimawakirori ñaantsi, ojyakaawintakiri ookakitapainchari okamiithawanikitzi kipatsi. Ikimisantanai, jojyakotanaawo apaani jyookapaintsiri, tzimaintsiri kapichiini okithokitanaki, pashini ojyiki okantanaka, pashini ojyikipirotanaki okithoki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ipoña ikantaki iijatzi: “Akowirika ootyaari ootamintotsi, ¿arima antatakotakiri kowitzinakiki? ¿Owakotzirima otapinaki? Tiira. Iro akowi onkoñiityi maawoni aminawaitantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ari onkantyaari iijatzi, ontzimatyii onkoñaatakoyitai manakowitainchari, oñaagantairo kaari ikimathawiita pairani. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kowirori inkimathatairo, inkimisanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ikantanakiri iijatzi: “Paamaiyaawo okaatzi pikimakiri. Otzimikari pantzimotantani, jimapiroitaimikari iiroka apaata. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Itzimirika otzimimotakiri, iikirora ontzimimopirotanakityiiri. Iriima kaari otzimimotzi, iikirora jiyaatatyi jiñiiro iiro ontzimimopirotairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ipoña ikantanaki iijatzi Jesús: “Tzimatsi ojyari ipinkathawintantai Pawa. Ojyatyaari pankiwairintzi, ");
INSERT INTO cpcNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","jimayi tsiniripaiti, inkakitamanai. Tiimaita jiyotzi tsika okanta ojyookantanakari iwankiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Apaniro ojyookawaitzi, itanatyaawo oshitowanaki oryaani oshi, ompoña ompowainkatanaki, tzimanaki ojyiki okithoki. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Onkantya osampatanaki, monkaapaititapaaka joyiipatantaityaawori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ikantanaki iijatzi Jesús: “¿Oitama ojyari iijatzi ipinkathawintantai Pawa? ¿Oitama nojyakaawintimirori? ");
INSERT INTO cpcNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ojyatyaawo aririka ampankitiro oryaanikitatsiri okithoki pankirintsi. Okantawita oryaani onawita, ");
INSERT INTO cpcNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","aririka ampankitakiro, ojyookanaki, anaanakiro pashini pankirintsi, antawo onkantayitya otiwa, ari iminkoshitantyaawo tsimiri otsimankatapishitakira”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ari ikantapiintatya Jesús jojyakaawintziniri atziri okaatzi jiyotaayitziriri. Kapichiinirika ikimathatawakiro atziripaini, kapichiinira jiyotairi. Ojyikirika inkimathatawakiro atziripaini, ojyikira jiyotaapirotairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Okaatzi ikinkithatakaantziri, jojyakaawintatziiro maawoni, tii jooñaawontziniri. Iriima jiyotaani, ikimathatakaakiri maawoni irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Okanta otsiniriityaanaki, ikantanairi jiyotaani: “Thami amontyaakotai intatsikironta”. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Aritaki jatanai maawoni piyowintakariri. Arira isaikitsitakari irirori pitotsiki montyaakotaiyanaini. Tzimatsi oyaatanakiriri ikinakoyitanaki pashiniki pitotsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ari omapokapaakiri antawoiti tampiya, otamaryaatanaki antawo, kitaatapaaka jiñaa pitotsiki, irootaintsi intsitsiyakoti. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jowakiryaitanakiri jimayira opataki pitotsi, jotziitotaka, ikantaitziri: “¡Yotaanarí! ¡Antsitsiyakotatyí!” ");
INSERT INTO cpcNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Piriintanaka Jesús, iñaanatanakiro tampiya, ikantziro: “¡Aritapaaki pitampiyatzi!” Ikantsitanakawo inkaari iijatzi: “¡Pimairyaati!” Awisanaki tampiya, mairyaatanaki inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ikantziri jiyotaani: “¿Oitama pithaawashitanakiri? ¿Tikiraama pawintaariita Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ojyiki ipinkathatanakiri, ikantawakaiyanakani ithaawankakiini: “¿Iitatyaakama jirika jomairintantawori tampiya, jomairintsitakawo iijatzi inkaari?” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ariitapaaka Jesús intatsikironta inkaariki, inampiki Gadara-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Iro jaatakotapaakityaami, ishiyashitawakari piyarishiritatsiri ipoñaakawo kitataariki, ");
INSERT INTO cpcNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ari isaikawaitziri irirori. Tii jaawiyaitziri joojowiitantari ashirotha. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Itzimpijyiro joojowiitantari iitziki iijatzi jakoki. Tikaatsira kitsirinkirini. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ari ikantaitatyaani maawoni kitiijyiriki iijatzi tsiniripaiti, ikinayitzi otzishiki, kitataariki, ikaimawaitzi, itotakaayitawo mapijyitapaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ikanta iñaawakiri ipokaki Jesús, ishiyashitawakari, jotziirowashitapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ikaimapaaki shintsiini, ikantzi: “¡Jesús, Itomi Pawapirotatsiri, tiira nonkowi powashironkaina! ¿Tsikama pinkantataitinaka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tima ikisapaakitziiri Jesús, ikantapaakiri: “¡Piyaati piyarí!” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ipoña josampitanakiri: “¿Tsikama piitaka?” Ari jakanaki piyari, ikantzi: “Noita ‘Jyikiyantzi’, tima ojyiki nokaataiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iikiro ikantanakitzi piyari: “Tii nokowi potyaantina pashiniki nampitsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ari ipiyotaka tyonkaarikiini ojyiki chancho joshintagaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ikantaiyini piyari: “Potyaantina janta chancho-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ari ikantzi Jesús: “Pantiro”. Ari ishiyaiyanakani chancho impiitatzi otzishi, mitaiyapaakini inkaariki, ari japirota ipiinkaki. Ikaataiyini 2000 chancho. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ithaawaiyanakini aamaakowintariri, shiyaiyanakani inkamantanti nampitsiki, ikamantakiri iijatzi maawoni saikayitatsiri jowaniki. Pokaiyanakini jaminiro awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ipokashiitanakiri Jesús, iñaitapaakitziiri piyarishiriwitachari. Isaikaki, ikithaataa, kamiitha ikantanaa. Ithaawantapaakari iñaapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ikaatzi ñaakiriri inkaanki ikamantawakiri pokayitaintsiri, ikantzi: “Piñaakiri jirika, iriitaki Jesús owawisaakotairi. Jowiinkakaantaki ojyiki chancho”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ikantaitanakiri Jesús: “Piyaatai, tii nokowi pisaikimotina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ipoña jotitanaa Jesús pitotsiki. Ikantawitawaari jowawisaakotakiri: “Nokowi noyaatanakimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jakanaki Jesús, ikantzi: “Iiro poyaatana, piyaatai pijyininkaki. Pinkamantapairi, pinkantiri: ‘Jinishironkataana Pinkathari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ikanta jirika piyarishiriwitachari, jatai inampiki iitachari Decápolis ikamantapairi maawoni atziri, ikantapairi: “Jowawisaakotaana Jesús”. Iyokitzi ikantaita ikimaitziri ikantayitapairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ikanta ipiya Jesús ipoñagaawo intatsikironta. Ipiyowintawaari ojyiki atziri inkaarithapiyaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ari jariitapaaka pinkatharitatsiri japatotapiintaita jiita Jairo. Jiñaapaakiri Jesús, jotziirowashitapaakari, ");
INSERT INTO cpcNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ikantapaakiri: “Onkamatyi nishinto. Nokowi piyaati potirotantyaawo pako, oshintsitaita”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ari jiyaatanaki Jesús, iro kantzimaitacha joyaatanakiri ojyiki atziri, jawitsinaimatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Okanta tsinani osokaawaitachari, tzimakotaki 12 osarintsi omantsiyawaitzi, ");
INSERT INTO cpcNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ojyiki jaawintawiitakawo, othonkakiro tzimimowitawori opinakowinta. Aminaashiwaitaka, iikiro iyaatatzi omantsiyatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Okimaki iroori ikinkithatakoitziri Jesús, ikantaitzi: “Oshinchaantaniri jinatzi Jesús”. Osatikantanakari atziri okinashitanakiri itaapiiki, otirotsitawakiri iithaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Tima okantashiritanakitzi iroori: “Aririka notirotsitawakiri iithaari, ari noshintsitai”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Apathakiro oshintsitanai osokaawita. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jiyotsitanaka Jesús tzimatsi oshinchaashitakari ishintsinka, josampitanakiri oyaayitakiriri, ikantziri: “¿Iitama otirotsitakinawori noithaari?” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jakanakiri jiyotaani, ikantzi: “¿Tiima piñiiri jawitsinaimatanakimi atziriiti? Iikiro pikantatzi: ‘¿Iitama otirotsitakinawori noithaari?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Iikiro jaminaminatanakitziiri Jesús, jiñiiri otirotsitakiriri iithaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Okanta tsinani opinkathatanakiri Jesús, okawaitanaka. Tima iro joshinchagai. Iyaatashitanakiri, otziirowashitapaakari, okamantakotapaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ikantanakiro irirori: “Tsinaní, oshinchagaimi pawintagaana. Kantatsi piyaatai, kimoshiri pinkantanaiya, aritaki shintsitaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tikira inthonkiro Jesús iñaanatziro, ariitaiyapaakani poñainchari ipankoki Jairo. Ikantapaakiri: “Kamaki pishinto. Iiro poñaashirinkashiwaitari yotaantaniri” ");
INSERT INTO cpcNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ikanta ikimawakira Jesús ikantaitapaakiri, ikantanakiri Jairo: “Iiro powashirita, pawintagaina naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Tikaatsi ishiniti joyaatanakiri. Apa jaanakiri Pedro, Jacobo, Juan. Iriitaki Juan iririntzi Jacobo. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ikanta jiyaatanaki, ariitaka ipankoki Jairo. Ikimapaatziiri ikamiñiinkataki atziriiti, jiraakoiyawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tyaapaaki Jesús, ikantapaakiri: “¿Oitama piraantaiyarini? Tii okami, imakoryaatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Thainkashiri jowaitanakiri Jesús. Jomishitowapaakiri maawoni. Apa isaikanaki ashitawori, iijatzi jiyotaani. Ityaashitanakiro jomaryaitakiro iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Joirikawakotapaakiro, iñaanatzimaitawo, ikantziro: “¡Talita cumi!” (akantziri apaantiki aaka: “Iintsi, pimpiriinti”.) ");
INSERT INTO cpcNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Piriintanaka iintsi, aniitanai. Tima tzimakotaki 12 osarintsiti, irootaki aniiwaitantanaari. Iyokitzi ikantanaka ikaatzi ñaakirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ikantzi Jesús: “Pimpiroota owanawo”. Ikantanakiri iijatzi: “Tiira nokowi pinkamantayitiri atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ikanta Jesús ipiyaa inampiki, ari joyaatairi maawoni jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Okanta kitiijyiri jimakoryaantaitari, jiyotaantaki Jesús japatotapiintaita. Iyokitzi ikantaitakiri. Ikantayiitzi ikimaitziri: “¿Iitama jiyotanitantakari jirika? ¿Iitama antakairiri kaari jiñaapiintaitzi? ");
INSERT INTO cpcNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Kaarima jirika añaapiintziri ikimitziro inchakota? ¿Iriitaki otomi María? ¿Añiiri Jacobo, José, Judas, Simón, iriitaki iririntzipaini? ¿Kaarima iritsiro atsipayitari anampitawo jaka?” Ari opoña tii ikimisantaitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ikantanaki Jesús: “Jashi jowiro Kamantantaniri ikimisantaitziri pashiniki nampitsi, irooma inampiki irirori isaikayitzi ijyininka, tii ikimisantaitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Irootaki kaari okantanta Jesús joñaagantiro ishintsinka inampiki. Tii ijyikipirotzi mantsiyari joshinchaaki jotirotantari jako. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Antawo jowashiritakotakari ikaatzi kisoshiriwaitatsiri, kaari kowatsini inkimisantai. Iro ikinantanakari jiyotaantayitzi pashiniki nampitsi tzimayitatsiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ipoña Jesús japatotakiri 12 jiyotaani. Ipasapiyaakiri ishintsinka inkitsirinkantyaariri irirori piyari. Jotyaantakiri, intsipatawakaanatya inkaati apiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ikantawakiri: “Iiro paanaki pithaati, powanawo, iijatzi piiriikiti, apa paanaki pikotzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iiro paanaki pashini piithaari. Apa pintyaantanatya pi-zapato-ti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ikantsitawakari iijatzi: “Pariitatyaarika pankotsiki, ari pimaapiintatyi, irojatzi pawisantanatyaari pashiniki nampitsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iirorika jaapatziyaitzimi, iirorika ikimisantaitzimi iijatzi, pawisapithatanakiri. Potikanairo piipatsikiiti, iro jiyotantaityaari tii ikimisantziri Pawa. Iriira jimapiroitai jowasankitaitiri paata, anaanakiro jowasankitaitakiri Sodoma-jatzi, Gomorra-jatzi. Imapirotatya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ikanta jiyaayitakira jiyotaani Jesús ikamantakiri atziriiti jowajyaantairo ikaaripiroshiriwaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jowawisaakoyitaki piyarishiritatsiri, joshinchaayitairi iijatzi ojyiki mantsiyari itziritantari yiinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ariitakotakari pinkathari Herodes okaatzi jantayitakiri Jesús. Tima ikantaitaki: “Añagaira Juan owiinkaatantaniri. Piñiiro otzimi ishintsinka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pashini kantayitatsiri: “Elías jinatzi”. Ikantayiitzi iijatzi: “Kimitaka iriitaki pashini Kamantantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ikanta ikimaki Herodes ikantayiitakiri, ikantanaki irirori: “Iriitaki añagaatsiri Juan nothatzinkakaantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Opoñaantari kitziroini Herodes jomontyaakaantziri Juan, okantakaantziro Herodías, iinantawitari Felipe iririntzi Herodes. Irootaki jiinantaari Herodes irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tima ikaminaantawitatya Juan, ikantawitari Herodes: “Tii okamiithatzi piinantyaawo iina pirintzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Iro opoñaantakari okisaniintziri Herodías, okowawitaka owamaakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Irootaki jomontyaantakariri kitziroini Herodes. Iro kantzimaitacha Herodes antawoiti ipinkathatakiri Juan, jiyotzi kamiithashiriri jinatzi, kitishiri ikanta. Tiira ishiniwitari intsitokakaantiri. Okaatzi ikaminaawitariri, okompitzimoshiritakari Herodes. Ari jishiwintawitawo ikimisantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Okanta pashini kitiijyiri, joimoshirinkawitawo Herodes itzimantakari pairani. Ipokaiyakini iwinkatharintsiti, ipokaki ijiwari owayiriiti Roma-jatzi, ipokaki jiwayitatsiri Galilea-ki. Owaiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ari otyaapaaki ishinto Herodías jowaiyani, amajyiitapaaki, okamiithatzimotanakiri Herodes amajyiitani, okamiithatzimotanakiri iijatzi itsipatakari jowaiyani. Ikantanakiro Herodes: “Ari nompakimi oitarika pinkamitinari. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iiro namatawitzimi, jiyotzi Pawa tyaaryoo nokantzi. Iroorika pikowi okaatzi nopinkathariwintziri, arityaami onkantaki nompimi kajyitani”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Iyaatashitanakiro onaanati, okantapaakiro: “¿Oitama nonkamitiriri?” Okantanaki iroori: “Pinkamitiri iito Juan owiinkaatantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Piyapaaka mainawo, okantapaakiri: “Nokowi pimpinawo iito Juan, powakinawo samantanakiki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Antawoiti jowashiritanaka pinkathari. Tima maawoni ikimaitakiri inkaanki, ikantakirori mainawo, tikaatsi inkinakaanairo, ontzimatyii impiro okowakotakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jotyaantaki owayiri jamakiniri iito Juan. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jatanaki owayiri jomontyaitziri Juan, ithatzinkapaakiri, jamakotakiro iito samantanakiki. Ipakoitakiro mainawo, aanakiniro onaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ikanta ikimaiyakini jiyotaani Juan-ni. Pokaiyaini, ikitatairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ariiyitaa jiyotaani jotyaantakiri, apatotapaa maawoni isaikira Jesús, ikamantapairi okaatzi jantayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Iikiro ipokaminthatanakitzi atziri, piyayitacha pashini. Tii onkantapainti jiyaataiyaini Jesús jowaiya. Irootaki ikantantanakariri Jesús jiyotaani: “Thami aati otzishimashiki, amakoryaawakiita kapichiini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Otitaiyanakani pitotsiki, jataiyaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iro kantzimaitacha, ojyiki aminakotawakiriri jiyaatanaki, jiyoitawakiri. Shiyaiyanakani ikinaiyanaki aatsiki, ipoñaanakawo nampitsiki. Iri itaiyakawoni jariita, apatotaiyapaakani. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ikanta jariitapaaka Jesús, jiñaapaakitziiri ipiyotaiyakani. Jitakoshiryaapaakari. Ikimiwaitakari oijya iirorika itzimi aamaakowintyaarini. Jiyotaayitapairi iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Aritaki tsiniriityaanaki, ipokashitapaakiri jiyotaani, ikantapaakiri: “Yotaanarí, asaikatziira otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Pimpakairo piyotaantzi, jiyaataita atziripaini nampitsiki jamananti joyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ikantanaki Jesús: “Pimpiri iiroka joyaari”. Ikantzi jiyotaani: “¿Pikowatziima niyaati namanantakiti nowakaiyaariri? Ojyiki owanawontsi, iiro jimonkaata kiriiki inkaati 200 ompinatyaari, nowakaantyaariri maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ikantzi Jesús: “¿Okaatzika tanta jamakiri atziriiti? Piyaati paminakitiro”. Ikanta jaminakitziro, ikantziri: “Tzimatsi 5 tanta, ipoña apiti shima”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ikantzi Jesús: “Poosaikiri maawoni atziri onatsiryaataki katawoshimashi, pinashiyityaari poosaikayitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jimatakiri. Tzimatsi nashiyitainchari isaikayitaki ikaatzi 100 atziri, jimatsitakari iijatzi pashini ikaatzi 50 atziri. Joosaikakiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ipoña Jesús, jaakotanakiro 5 tanta itsipataakiri apiti shima, aminanaki inkitiki, ipaasoonkiwintakiro. Ipitoryaakiro tanta, ipakiri jiyotaani, jowawisaakiniri irirori atziripaini. Ari ikimitaakiri iijatzi shima, jantitakari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Jowaiyakani maawoni, kimaniintaiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ijaikiyitairi 12 kantziri okaatzi jowagaantakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Kimitaka ikaatzi 5000 shirampariiti owainchari. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ikantanairi Jesús jiyotaani: “Thamira, pitaiyaawo pimontyaakotai nampitsiki Betsaida”. Ikantanakiri piyotawintakariri: “Kantatsi piyaayitai pipankoki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ikanta jiyaatanai maawoni atziri, tonkaanaki Jesús otzishiki jamanamanaata. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Aritaki tsiniriityaanaki, jiwiyaakotaiyaani jiyotaani niyantyaaniki inkaari jimontyaakotaiyini. Apaniro isaikanaki Jesús otzishiki, ");
INSERT INTO cpcNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","jaminakotakiri jiyotaani, shintsiini ikomataiyini oipiyapiyatakotziri tampiya. Okanta okitiijyitzimataki, jiyaatashitairi, janiitantanaawo inkaari, ikinashitapairi itaapiiki, iro jawijyimatirimi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ikanta jiñaawairi, jojyakaatziiri shiritsi jinatzi, kaimaiyanakini, ");
INSERT INTO cpcNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","tima maawoni jariitashiryaanakari jiñaakiri. Ikantapaakiri Jesús: “Naakataki pokatsiri, iiro pithaawawaitzi, tontashiri pinkantaiyaani”. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Otitapaa pitotsiki, awisainkatanaki tampiya. Iyokitzi ikantawintanakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tima tikiraata jiyothatziroota jojyiñaantakawori Jesús tanta, iro kantakaantzirori ikisoshiriwaitaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Irojatzi jariitantaiyapaakarini inampiki Genesaret-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iro jaatakotapaakityaami, thaankipiroini jiyoitawakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ikamantawakaanaka maawoni nampitawori janta, jamakoitakiniri mantsiyari jomaryaamintoki. Tsikarika isaiki Jesús, ari jamakoitziniriri. ");
INSERT INTO cpcNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Imataka ikinayitzi oryaaniki nampitsi, nampitsiki antawo, iijatzi owaantsiki, jowakoitziniri mantsiyari aatsiki, ikantayiitziri: “Pishinitawakiniri jotirotawakiro piithaari”. maawoni otirotakirori iithaari shintsiyitai. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ipoña ipokaiyakini Fariseo itsipatakari Yotzinkari, ipoñaakawo Jerusalén-ki. Japatowintapaakari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jiñaapaakiri jiyotaani Jesús tii jantziro jamitapiintaiyarini ikiwaakota jowaiyani. Ikijyimatapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Okaatzi jantapiintziri Fariseo-paini, iirorika ikiwaakota, iiro jowaa. Irootaki jamitapiintakari pairani ichariniiti: Aririka inkowi joya, ontzimatyii inkiwaakotawatya, inkitiwathatantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Aririka jariitaiya jamanantzi, tikiraata jowapaiyaata, inkiwaakopirotawatya. Tiira apaani onkantya jamiyitari, ikiwayitsitawo jiraaminto, iyowiti, jonkotsiminto, imaaminto, maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Irootaki josampitantakariri Jesús, ikantziri: “¿Oitakama imaijantantaawori piyotaani jiyotaayitairi pairani achariniiti? Noñaapaakiri jowaiyani, tii inkiwaakotya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jakanaki Jesús, ikantzi: “Amatawitantaniri pinayitzi. Iirokataki josankinatakotaki pairani Isaías-ni, ikantaki: Ipinkathawaantiwitashitana atziripaini. Tiimaita inkinkishiritakotaina kamiithaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Aminaashiwaita jotziirowashitana ipinkathawitana, Jiyotaantashiwaitawo jamiyitari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pimaijantakiro iiroka Ikantakaantani Pawa, pantashitakawo jamiyitari atziriiti. Pikiwayitziro piyowiti, piraaminto. Ojyiki okaatzi pantashiyitakari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ikantziri iijatzi: “Iroora pantapirotakiri pamiyitari, pithainkanakiro Ikantakaantani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jiroka rosankinari Moisés-ni, ikantzi: Pimpinkathatiri piwaapati iijatzi pinaanati. Ikantzi iijatzi: Ontzimatyii jowamaitiri kijyimawaitziriri iwaapati iijatzi inaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Iro kantzimaitacha iiroka pikantapiintzi: ‘Ankajyaakairirika Pawa airiikiti, ontzimatyii ampiri. Onkantawitatya añiiri jashironkaawaitya awaapati iijatzi anaanati’. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ari pikantakari iiroka, piyotaashiwaitakari atziripaini, tii inishironkatairi iwaapati iijatzi inaanati. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Apa pantashiwaitakawo jamiyitari pairani pichariniiti, irootaki pithainkantakawori iñaani Pawa. Ari pikantapiintatya pantayitziro kimitakawori jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ari ikaimakiri Jesús maawoni apatotainchari, ikantziri: “Pinkimisantaiyini, pinkimathatantyaawori nonkantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Okaatzi jowayiitari, tii owaaripiroshiritantzi. Irooma omishitowayitziri poñaachari inthomainta, irootaki owaaripiroshiritantatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Powakimpitatyaawo jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ikanta jiyaataiyaini atziri, tyaapai Jesús pankotsiki. Ari josampitakiri jiyotaani, ikantziri: “¿Oita pojyakaawintakiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jakanaki Jesús, ikantzi: “¿Iijatzima iiroka, tima pinkimathatawakiro? ¿Tiima piyotzi iiroka tii owaaripiroshiritantzi okaatzi jowayiitari? ");
INSERT INTO cpcNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Tikaatsi okantziro ashiri, apa okiniro ajyiitoki, irojatzi oshitowantaiyaari”. Iro jiyotaantakiri Jesús, tii okaaripirotzi okaatzi jowayiitari. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ipoña ikantanaki iijatzi: “Aririka ankinkishiriwaitya antakairi ajyininka kaaripirori, irootaki owaaripiroshiritantatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tima inthomainta ashiriki opoñaayita: kaaripirori kinkishiritaantsi, kaari kinataantsi, mayimpiritaantsi, tsitokaantsi, ");
INSERT INTO cpcNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","koshitaantsi, mashithataantsi, kaaripiroshiritaantsi, amatawitaantsi, mayimpiryookitaantsi, samakoniintaantsi, kijyimataantsi, asagaawintaantsi, tzimaityaashiryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Okaatzi ikinkishiritapiintakari atziriiti kaaripirori onatzi, irootaki iñaantawori owaaripiroshiriwaitziri. Tima inthomainta ishiriki opoñaayitaka jirokapaini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Opoñaashitaka ikinanaki Jesús nampitsiki iitachari Tiro, irojatzi Sidón-ki. Ari isaikapaaki pankotsiki, tii ikowawita inkimakoitirimi. Tiimaita jimanakota. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tima janta tzimatsi tsinani, piyarishiritatsiri ishinto. Okimakotawakiri iroori Jesús, iyaatashitanakiri, otziirowashitapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kaari Judá-mirinka jiroka tsinani, opoñaatya iroori pashiniki nampitsi oita Sirofenicia. Okantapaakiri: “Jesús, poshinchagainawo nishinto, opiyarishiritatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ikantanakiro irirori: “Paata tsinani. Ikantaitakiranki: Tii jaapithaitziri jowanawo iintsi ampiri otsitsi joyaawo, apaniro jowawaita iintsi irojatzi inkimaniintantatyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ari akanaki tsinani, okantziri: “Imapirotatya pinkatharí pikantakiri. Iro kantacha ikatziyapiinta otsitsi jantyaatsikiini, jowayitawo owanawontsi jookagaantayitziri iinchaaniki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ikantzi Jesús: “Ari okanta, imapirotatya pikantakiri. Kantatsi piyaatai, ari piñaapairo pishinto, shintsitai iroori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Okanta iyaatai tsinani opankoki, oñaapairo ishinto omaryaaka omaamintoki, shintsitai. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ipoña jiyaatanai Jesús isaikawitapaakara nampitsiki Tiro, ikinanairo Sidón-ki, Decápolis-ki irojatzi jariitantaari Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ari jamaitakiniri atziri ashikimpitatachari, kaari ñaawaitatsiri iijatzi. Ikantaitapaakiri: “Jesús, potirotantawatyaari pako”. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ipoña Jesús jaanakiri jantyaatsikiini, josagaantantakari jakoimpiki ikimpitaki, itziritantakari jiiwari ininiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Aminanaki inkitiki, ikisashiritanaka, ikantziri: “¡Efata!” (akantziri apaantiki aaka: “piwitaryagaiya”) ");
INSERT INTO cpcNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iwitaryaanaka ikimpita, ñaawaitanai kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ikantawitawaari Jesús: “Iirora pikamantakotana”. Iro kantacha ipiyathatakari, ikamantakiri maawoni atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyokitzi jowaitanakiri Jesús, ikantaitzi: “¿Oitaka okamiithatantari jantziri jirika? Ikimakagairi ashikimpitawitachari, iñaawaitakagairi iijatzi kaari ñaawaiwitachani”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ikanta japatotaiyani ojyiki atziri, thonkapaaka owanawontsi. Ikaimakiri Jesús jiyotaani ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Antawoiti nitakoshiritakari atziripaini. Mawataki kitiijyiri itsipatakina jaka, tikaatsitapaaki jowaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Aririka notyaantairi, ari owamaakiri itajyi aatsiki, tzimayitatsi poñaachari intaina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jakanaki jiyotaani, ikantziri: “¿Tsika ayika owakaiyaariri jaka otzishimashiki?” ");
INSERT INTO cpcNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ari josampitziri Jesús, ikantziri: “¿Tsika okaatzika tanta tzimatsiri?” Ikantaiyanakini irirori: “Tzimatsi 7”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ari joosaikakaantakiri Jesús maawoni atziri kipatsiki. Jaakiro 7 tanta, ipaasoonkiwintakiro, ipitoryaakiro, ipakiri jiyotaani jowawisaakiniri atziripaini irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tzimitacha iijatzi shimaaniki. Ipaasoonkiwintakiri iijatzi, ipayitakiri atziripaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Owaiyakani maawoni, kimaniintaiyakani. Ijaikitairo okaatzi tzimagaantapaintsiri 7 kantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","maawoni owainchari ikaatzi 4000 shirampariiti. Ari jotyaantairi maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ipoña jotitanaa Jesús pitotsiki itsipatanaari jiyotaani, montyaakotanai intatsikironta oita Dalmanuta. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ipoña ipokaiyapaakini Fariseo, iñaanaminthatapaakiri Jesús, ikowi jiñiiri intasonkawintanti, jiyotantyaariri imapirotatya opoña itasorinka inkitiki, tima iñaantatyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ikisashiritanaka Jesús, ikantzi: “¿Oitama ikowantari jiñiina nontasonkawintanti jirikapaini? Iiro noñaayimaitari. Imapirotatya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Piyanaka Jesús, montyaakotanai. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ari imaijantanakiro jiyotaani jaantanatyaami tanta, apaanimachiini tanta jaanaki ipitoki. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ari ikantzi Jesús: “Ontzimatyii paamawintyaawo shiniyakaawori itantani Fariseo iijatzi rashi Herodes”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ari jiñaanaminthatawakaiyakani jiyotaani, ikantawakaa: “Kaarima amantanaka tanta”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ikanta Jesús jiyotakiri ikantawakaari jiyotaani, ikantziri: “¿Oitama pikantawakaantari: ‘Kaari amantanaka tanta?’ ¿Tiima pikimi? Kisoshiri pikantaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tzimawitacha poki tii piñaantzi, tzimawitacha pikimpita tii pikimi. ¿Tiima pikinkishiritziro nojyiñaantakawori tanta? ");
INSERT INTO cpcNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tima 5 tanta tzimawitachari, jowimaitaka 5000 shirampariiti. Poyiitairo okaatzi tzimagaantapaintsiri. ¿Tsika okaatzi kantziri jaikitaatsiri?” Ikantaiyini: “12 kantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Iijatzi nokantakiro, kaawitachari 7 tanta, jowaiyakani 4000 atziriiti. Poyiitairo tzimagaantapaintsiri. ¿Tsika okaatzi kantziri jaikitaatsiri?” Ikantaiyini: “7 kantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ari ikantziri: “¿Tikiraama pikimathatziroota?” ");
INSERT INTO cpcNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ariitaka Jesús nampitsiki Betsaida. Jamaitakiniri kaari aminatsiri, ikantaitapaakiri: “Potirotantawatyaari pako”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ipoña Jesús, ikathawakotanakiri. Jaanakiri othapiki nampitsi. Jiiwaakitakiri, jotirotantanakari jako. Josampitzimaitari: “¿Kantatsi pamini?” ");
INSERT INTO cpcNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ari jaminanaki, ikantzi: “Aminawitaana, noñaawitaari atziri janiitaiyini, tiimaita ikoñaapirotzi, jojyashitakawo inchato”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ipoña japiitakiri jotirotakiri irookiki, ikantairi: Paminai iijatzi. Aminanai, koñaatanai jamini intaina, jiñaanairo maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jotyaantairi, ikantawairi: “Iiro pikinanai nampitsiki, tii nokowi pinkamantakotina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ipoña jawisanai Jesús itsipatanaari jiyotaani ikantanaawo nampitsiki saikatsiri Cesarea-ki inampiitiki Filipo. Okanta niyanki aatsi josampitakiri jiyotaani, ikantziri: “¿Oitama ikinkishiritakotanari atziripaini?” ");
INSERT INTO cpcNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ari jakanaki jiyotaani ikantzi: “Ikantaitzimi Juan-ni owiinkaatantaniri pinatzi, ikantaitzimi iijatzi Elías pinatzi. Tzimatsi kantayitzimiri iijatzi pashini, Kamantantaniri piriintaachari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ipoña josampitanakiri irirori, ikantziri: “¿Oita pikinkishiritakotanari iiroka?” Ari jakanaki Pedro: “¡Cristo pinatzi!” ");
INSERT INTO cpcNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ikantzi Jesús: “Iiro pikamantakotsitana”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ari jitanakawo Jesús ikamantziri jiyotaani onkaati awijyimotirini, tima iri iitapiintachari Itomi Atziri. Ikantziri: “Ojyiki nonkimaatsikowintaimi. Ojyiki inkisaniintina pinkatharipaini, ijiwaripaini Ompiratasorintsitaari, iijatzi ikaatzi Yotzinkariiti. Jowamaakaantina. Iro awisawitatya mawa kitiijyiri, añagaana”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ari ikantakiriri, tii jimaniro. Ipoña Pedro, jaanakiri Jesús jantyaatsikiini, ikowawitaka inkaminairimi. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ipithokapithatanakari, jaminanakiri jiyotaani, ikisanakiri Pedro, ikantziri: “¡Piyaati Satanás! Tii poshiritawo iiroka ikowakaantziri Pawa, poshiritashitakawo ikowayitziri atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ikaimakiri Jesús piyowintakariri, ikaimakiri iijatzi jiyotaani, ikantakiri: “Tzimatsirika kowatsiri intsipataina jowajyaantairo ikowawaitashitari jantiri. Onkantawitatya impaikakoitirimi, intsipataina naaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ikaatzi antashiwaitawori ikowashiriyitziri, ari impiyashitaiya. Iriima kamawintinani, okantakaantziro ikimisantziro Kamiithari Ñaantsi, aritaki jawisakoshiriyitai. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aminaawaitashita iñaitziro otzimimotantzi ojyiki ajyaagawontsi jaka kipatsiki, impoña iñairo impiyashitaiyaawo añaamintotsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Kantatsima impinatakowintaitya iiro iñaantaawo impiyashitaiya? ");
INSERT INTO cpcNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tima ikaatzi kaaniwintanari naaka inkinkithatakotina kaaripiroshiririki atziri, ari nonkantsitaiyaari naaka iijatzi nonkaaniwintairi paata aririka nompiyi namairo jowaniinkawo Ashitanari nontsipataiyaari maninkariiti, tima naaka Itomi Atziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ipoña ikantanaki iijatzi Jesús: “Tyaaryoowa, tzimayitatsi pikaatzi jaka, tikiraamintha pikamiita, ari piñaakiro ishintsinka Pawa tsika ikanta ipinkathariwintantai”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Okanta awisanaki 6 kitiijyiri. Tonkaanaki Jesús otzishiki, jaanakiri Pedro, Juan, Jacobo. Ari ishipakiryiimotakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kitamaa okantanaka iithaari, tikaatsi ojyakairi okitamaatanakira. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iñaatziiri Elías itsipatapaakari Moisés, ikinkithawaitakaapaakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Iñaawaitashiwaitanaka Pedro, ikantanakiri Jesús: “Yotaanarí, imapiro okamiithatzi pamaiyakina jaka. Kamiitha niwitsikaiyimini mawa pankojyitantsi: apaani pashitya iiroka, apaani jashitya Moisés, jashitya apaani Elías”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tima ithaawaiyanakitziini, irootaki iñaawaitashiwaitantanakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Opoña opokapaaki minkori otsimankakotapaakiri. Ikimaitatzi ikantaitzi: “Nitakokitani jinatzi jirika notomi, pinkimisantiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ipoña jaminapirowitanaka, tikaatsi iñaanai, apa Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ikanta joirinkaiyaani otzishiki, ikantakiri iiro ikamantantziro iñaakiri irojatzi paata aririka jañagai. Tima jirika Itomi Atziri ari jañagai inkamawitatya. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jimatakiro tii ikamantakotziri, iro kantacha ojyiki josampitawakaiyanakani oita iiro ithawitakotantari Jesús, ari jañagai inkamawitatya. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ipoña josampitaiyakirini, ikantziri: “¿Oitaka ithawitakotziri yotzinkariiti iri iiwatapaintsini Elías impoki?” ");
INSERT INTO cpcNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ari jakanaki Jesús, ikantziri: “Imapirotatya, iriitakira iiwatapaintsini Elías impoki, jotampatzikatantapaaki. ¿Tsikama okantzika josankinatakoitakina pairani? Tima okantzi: ‘Jirika Itomi Atziri, ojyiki inthainkawaitaitiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pinkimi, aritaki pokaki Elías. Ojyiki imaamanitaitawakiri, jimonkaatakiro okaatzi josankinatakoitakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ikanta jariitaa Jesús jookanakiri jiyotaani, iñaapaatziiri ipiyowintakari ojyiki atziri itsipatakari Yotzinkariiti iñaanaminthatziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ikanta iñaawairi ipokai Jesús, jiyokitziiwintawairi, ishiyanaka jiwithatawaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Josampitapaakiri Jesús, ikantziri: “¿Iitama piñaanaminthatantariri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Akanaki apaani, ikantanaki: “Yotaanarí, namatziimiri notomi piyarishiritatsiri, tii okantzi iñaawaitai. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Impokashitapairirika, owanaa jompojakaawaitari kipatsiki. Ishimoripaantiwaitakairi, jatsikaikiwaita, ikisotakairi. Nokantawitakari piyotaani jowawisaakotainari, tii ikantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jakanaki Jesús, ikantanaki: “Tiitya pikimisantaiyini iiroka. ¿Tsikapaitima piyotika? Pamakiri jaka iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jamaitapaakiniri. Ikanta piyari iñaapaakiri Jesús, jompitatakaanakari shintsiini iintsi, tyaanaki, ipinaawaita kipatsiki, ishimoripaantiwaitanaki. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Josampitanakiri Jesús iwaapati iintsi, ikantziri: “¿Tsikapaitima jitanaka piintsiti?” Ikantzi: “Ari ikantsita owakiraa jiryaanitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Itaakaawaiwitakari paampariki, ipiinkawaitzi iijatzi jiñaaki, ikowi jowamairimi. Kantatsirika pinishironkatina, pantiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ikantzi Jesús: “¿Oitama pikantantawori ‘Kantatsirika...?’ Aririka pinkimisantai, aritaki antatya maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ipoña ikaimanaki shintsiini iwaapati iintsi, ikantanaki: “Kimisantawitachana, tiirika nokimisantapirotzi, pinkimisantakaapirotaina iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Iikiro iñaatzi Jesús ipokaiyapaakini atziri, ikisanakiri piyari, ikantanakiri: “Pintainaryiiyaari iintsi, iiro pipiyashitaari iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ikaimanaki shintsiini piyari. Ikamimatakaanakiri iintsi. Ojyiki kantanaintsiri: “Kamaki iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ipoña ikathawakotanakiri Jesús, jowatziyakiri. Añaanai. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ikanta ityaapaakira Jesús pankotsiki, ari josampitakiri jiyotaani apaniroini, ikantziri: “¿Kaari nokantantari naaka nowawisaakotiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ikantzi Jesús: “Imapirotatya ishintsitzi jirika piyari, okowapirotatya aakowintyaawo amaña, antziwintyaari iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ipoña jawisanaki Jesús, ikinayitanai Galilea-ki. Tiira ikowi inkimakotiri atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tima jiyotaayitatziiri jiyotaani, ikantayitziri: “Irootaintsira jaakaantaitiri Itomi Atziri, jowamaitiri. Awisawitatya, mawa kitiijyiri, aritaki jañagai iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iro kantzimaitacha tii jiyotaiyawakironi okaatzi ikamantawitariri. Tikaatsi kowatsini josampitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ariitaiyaani Capernaum-ki. Ikanta isaikaiyapaini pankotsiki, josampitakiri Jesús, ikantziri: “¿Oitama pikantawakaari inkaanki aatsiki?” ");
INSERT INTO cpcNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ari imairitaiyakini irirori. Tima ikantaminthatawakaatya inkaanki aatsiki itzimika ñaapirotachari. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Saikanaki Jesús, japatotakiri 12 jiyotaani, ikantziri: “Aririka pinkowi piñaapirotya, pojyakotyaari ikanta ompirataari, tii iñaapirowaita irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jamaki iintsi, katziyapaaka niyankiniki isaikaiyakini irirori, ikantzi Jesús: ");
INSERT INTO cpcNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ikaatzi pairyiirori nowairo ikimisantaana, impoña jaawakiri kamiitha kimitakariri jirika iintsi, naaka jaaki kamiitha. Ari okimitari iijatzi, aririka jaapatziyaina naaka, kimipirowaitaka iriira jaapatziyaka otyaantakinari jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ari ikantanaki Juan: “Yotaanarí, noñaaki chapinki atziri pairyiirori piwairo, jowawisaakotzimaitari piyarishiritatsiri. Tiira añiiri antsipatyaari jaka, nowajyaantakaakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ikantzi Jesús: “Iiro powajyaantakairimi. Tima ikaatzi tasonkawintantatsiri ipairyiiro nowairo, iiro ikijyimataana osamaniityaaki. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tima ari atsipatari kaari kisaniintaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Aririka jitakoitaimi impairyaitiro nowairo, inkantaiti: ‘Nompakotiri jiñaa jashitaari Cristo’. Iri impinaitairi paata. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tsikarika itzimi antakaakirini kaaripirori iintsi awintaanari, ojyakariri jirika jaka, ari jowasankitaayiitairi. Iro kamiithatatsimi inthayiitiniri mapi ikintsiki, jowiinkaitiri inkaariki. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Iroorika pako pantapiintantyaarimi kaaripirori, powajyaantiro onkantya pawisakotantaiyaari, pinkimitakaantiromi pinthatzinkatyiiromi pako. Irojatzi piyaaponthokitantaiyaari inkitiki. Tima tii opantawo otzimawita apiti pako ompoña piñagairo paata jookaitaimi sarinkawiniki ari pinkantaitatyaani pintagaiya, ");
INSERT INTO cpcNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","tsika tii ikaamanitapai chowitsi, tsika tii itsiwakanitapai paampari. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Iroorika piitzi pantapiintantyaarimi kaaripirori, powajyaantiro onkantya pawisakotantaiyaari, pinkimitakaantiromi pinthatzinkatyiiromi piitzi. Irojatzi piyaaponthokitantaiyaari inkitiki. Tima tii opantawo otzimawita apiti piitzi ompoña piñagairo paata jookaitaimi sarinkawiniki ari pinkantaitatyaani pintagaiya, ");
INSERT INTO cpcNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","tsika tii inkaamanitapai chowitsi, tsika tii itsiwakanitapai paampari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iroorika poki pantapiintantyaarimi kaaripirori, powajyaantiro onkantya pawisakotantaiyaari, pinkimitakaantiromi pinkithoryaatyiiromi poki. Irojatzi piyaapityakitantaiyaari inkitiki. Tima tii opantawo otzimawita apiti poki ompoña piñagairo paata jookaitaimi sarinkawiniki ari pinkantaitatyaani pintagaiya, ");
INSERT INTO cpcNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","tsika tii inkaamanitai chowitsi, tsika tii itsiwakanitai paampari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tima paampariki jiñaantayiitaimi maawoni, inkimitakaantaitimiro iijatzi okanta tziwi okatyotzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Kamiitha okanta tziwi okatyotzi, aririka inkonowaitiro tsika oitya, iiro opantanaawo inkatyokantaityaawo. Pinkimitakotaiyaawo iiroka tziwipirori, paapatziyawakaiya, tima tii opantawo pintzimawintawakaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ikanta jawisanai Jesús jiyaatairo Judea, ikinanakiro intatsikironta Jordán. Japatowintawaari ojyiki atziri. Jitapaawo jiyotaayitapairi ikimitapiintziro. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ari ipokakiri Fariseo, josampitapaakiri Jesús ikowi inkompitakaiyaarimi, ikantapaakiri: “¿Shinitaantsitatsima atziri jookiro iina?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jakanaki Jesús, ikantanakiri: “¿Oitama ikantakaantziri Moisés-ni?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ikantaiyini irirori: “Ishinitaantziro Moisés-ni ookiro aina aririka impayiitairo osankinatakota ookawakaantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ari jakanakiri Jesús, ikantanakiri: “Okantakaantziro tii pikimisantanitzi, irootaki ishinitantakimirori jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pairani itantanakari jiwitsikantzi Pawa, jiwitsikakiri shirampari, jiwitsikitsitakawo iijatzi tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ari jookawintairi shirampari ashitariri, jayi iina, Apaani inkantanaiya iwathaki jaawakaana. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Irootaki iiro okantanta jookiro atziri itsipataakaakariri Pawa, ");
INSERT INTO cpcNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","tima apaani ikantanaa, iiro okantzi jookawakaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ikanta isaikaiyini pankotsiki, josampitairi jiyotaani okaatzi ikantakiri, ");
INSERT INTO cpcNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ikantanaki Jesús: “Itzimirika ookironi iina, aririka jagai pashini tsinani, imayimpiriwintakiro iinawitari kitziroini. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ari okimita tsinani aririka ookiri oimi, agairika pashini shirampari, omayimpiriwintakiri oimiwitari kitziroini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ari jamaitakiniri Jesús iintsipaini, ikowaitzi jotzimikapatziitotantawatyaari jako. Ikanta jiyotaani Jesús ikisawakiri amayitziriri iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tii inimotanakiri Jesús jiñaakiri, ikantziri: “Pishinitiri iinchaaniki impokashitina. Iiro pithañaana. Tima inkaati kimitaiyaarini irirori, iriitaki ñaagaironi ipinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Imapiro, iirorika ipinkathaitziri Pawa inkimitakoityaari ikanta iintsipaini, iirora iñaitairo ipinkatharitai”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ithomaawakiri iintsipaini, jotzimikapatziitoyitakiri, itasonkawintayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iro jawisantanaiyaarimi Jesús, ishiyashitakari mainari, jotziirowashitapaakari, josampitapaakiri: “Kamiithari Yotaanarí, ¿oitama nantairi noñaantaiyaawori kañaanimintotsi?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ari jakanakiri Jesús, ikantziri: “¿Oitama pikantantanari: ‘Kamiithari pinatzi?’ Apaniro ikantakaawo Pawa ikamiithatzi, tikaatsi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aritakima piyotakotakiro Ikantakaantaitziri: Iiro pitsitokantzi. Iiro pimayimpiritzi. Iiro pikoshitzi. Iiro pithiiyakotanta. Iiro pamatawitantzi. Pimpinkathatiri ashitzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jakanaki mainari, ikantzi: “Yotaanarí, nothotyaakiro maawoni irojatzi nitanakawo pairani iiniro niryaanitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ipoña Jesús jaminanakiri, jitakotanakari, ikantziri: “Tzimatsi apaani kowityaapainchari kaari pantziri. Piyaati pipankoki, pimpimantiro maawoni pashitari, pimpashityaari ashironkaachari. Ari piñagairo pinintagaiya inkitiki. Pimpoki, poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ikanta ikimawaki, okantzimoniintanakari. Owashiri ikanta ipiyanaa, tima ajyaagantzinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ipoña Jesús, jaminanaki maawoni onaminaki, ikantziri jiyotaani: “¡Owanaa opomirintsitzimotari ajyaagantzinkari jiyaatai ipinkathariwintantzi Pawa!” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jiyokitziitanaki jiyotaani ikimakiri ikantakiri. Japiitanakiro ikantzi: “Notomiiti. ¡Owanaa ompomirintsitzimotyaari jiyaatai ipinkathariwintantzi Pawa awintaawori jajyaagawo! ");
INSERT INTO cpcNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tima iiro okantzi intyi piratsi camello imooki kithapi, iro owatsipiro ompomirintsitya intyi ajyaagantzinkari ipinkatharitai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iikiro jiyokitziitanakitzi jiyotaani, ikantashiriyitanaki: “¿Tsikama iityaaka awisakoshiritaatsini?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jaminanakiri Jesús, ikantziri: “Iirowa jantziro apaniroini atziri, iriitaki Pawa antakairini. Tikaatsi pomirintsitzimotyaarini irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ikantanaki Pedro: “Jirika nokaataiyakini maawoni, nookayitanakiro tzimimoyitanari, noyaataiyakimini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jakanaki Jesús, ikantanakiri: “Imapirotatya, tzimatsi kimisantanairori Kamiithari Ñaantsi, kinkithatakotanairori iijatzi, ari okanta jookawintantawori inampi, iririntzi, iritsiro, ashitariri, iina, jiintsiti, jowani, ");
INSERT INTO cpcNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","iriitaki ñagaironi onkaati impairiri Pawa. Ojyiki onkaati pankotsi, iririntzi, iritsiro, ashitariri, jiintsiti, jowani. Onkantawitatya ojyiki inkisaniintawaitaitiri, tima iiro osamanitzi iñiiro kañaanimintotsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tzimayitatsi itayitawori, iri ñiironi jimpoiyitai. Tzimayitatsi impoiyitatsiri, iri ñiironi jitaiyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ikanta itonkaiyini ipampithatziro aatsi jiyaatiro Jerusalén-ki. Iriitaki iiwatatsi Jesús janiitaiyini. Iyokitzi ikantaiyani jiyotaani, thaawashiri ikantaiyani joyaatziri. Ipoña japiitakiro Jesús japatotziri 12 jiyotaani, ikamantakiri awijyimotirini, ikantakiri: ");
INSERT INTO cpcNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Aatatziira Jerusalén-ki. Ari jaitiri Itomi Atziri jaakaantiri ijiwari Ompiratasorintsitaari intsipatatyaari Yotzinkariiti, jiyakawintiri jowamaitiri, jaayiitanakiri atziriki kaari ajyininkata, ");
INSERT INTO cpcNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ishirontaminthaityaari, impajawaitaitiri, jiiwawaitaitiri, jowamaitakiri. Iro awisawitatya mawa kitiijyiri, ari jañagai iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ikanta Jacobo itsipatakari Juan, itomipaini Zebedeo, jontsitokapaakari okaakiini Jesús, ikantakiri: “Yotaanarí, nokowi pantainawo nonkamitimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Josampitanakiri irirori: “¿Iitama pikowiri nantimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ikantaiyini: “Tima irootaintsi pimpinkathariwintanti, pishinitina nosaikanampitimi pakopiroriki nontsipatimi ampinkathariwintanti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ikantanakiri Jesús: “Tii piyotziro oita pikamitanari. Ojyiki nonkimaatsityaari naaka. ¿Arima pamawitakiro iiroka pinkimaatsitya ojyiki? ¿Arima pinkimitatyaana nonkami naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ikantaiyini irirori: “Aritaki nantakiro”. Ikantzi Jesús: “Imapiro, irootaintsi pantiro onkaati nonkimaatsityaari, ");
INSERT INTO cpcNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","irooma pisaikanampitina nakopiroriki pintsipatina ampinkathariwintanti, iiro okantzi naaka noshinitaimiro, jashi ikajyaakaitakiri kitziroini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ikanta ikimaiyakini pashini jiyotaani, ikisanakiri Jacobo iijatzi Juan. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ipoña japatotanairi iijatzi, ikantziri: “Piyotaiyirini iiroka pinkathariyitatsiri jaka, jompiratanta. Ari ikimitari iijatzi ñaapirotachari ipinkathaitziri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Irooma iirokaiti, aririka pinkowi piñaapirotya, iri pinkimitakotya ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iroorika pinkowi piiwatakaanti, iri pinkimitakotya ikanta ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Tii iro impokantyaari Itomi Atziri jompiratantya, iro ipokantakari inkimitakotyaari ompirataari irojatzi inkamawintantantyaari, iri pinatakowintantatsini, jookaakowintairi maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ikanta Jesús jariitaka nampitsiki Jericó. Jawisanai itsipatanaari jiyotaani iijatzi ikaatzi apatowintakariri. Okanta aatsinampiki, jiñaapaakiri atziri iitachari Bartimeo, itomi Timeo, ikowakotantzi impashitaityaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ikanta ikimaki irirori, iriitaki Jesús poñaachari Nazaret, ikaimotawakiri, ikantziri: “¡Jesús, icharini David-ni, pinishironkataina!” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ikisawiitanakari imairitantyaari, iikiro ikaimanakitzi shintsiini: “¡Icharini David-ni, pinishironkataina!” ");
INSERT INTO cpcNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Katziyapaaka Jesús, ikantzi: “Pinkaiminari”. Ari ikaimaitakiri ikantaitziri: “Pinkatziyi, ikaimatziimi, thaaminta pinkantanatya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jookanakiro ipiwiryaakominto, katziyanaka, ishiyashitanakari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Josampitawakiri, ikantziri: “¿Iitama pikowakotanari? ¿Tsika nonkantaimika?” Jakanaki irirori, ikantzi: “Yotaanarí, nokowi naminawaitai kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ikantanaki Jesús: “Kantatsi piyaatai, oshinchagaimi pawintaana”. Apathakiro jaminanai kamiitha, joyaatanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Irootaintsi jariitya Jesús Jerusalén-ki, jiwiyaaka osaiki nampitsi Betfagé otsipatakawo Betania, omontitakawo otzishi Olivo. Ari jotyaantakiri apiti jiyotaani, ");
INSERT INTO cpcNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ikantakiri: “Piyaati nampitsiki amontitakari. Ari piñaaki iwonkiri burro inthatakotya, tikira ityaakaitariita. Pinthataryaakotiri, pamakinari. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Aririka ikantaitawakimi: ‘¿Pinkantirika pithataryaakotantariri burro?’ Pinkantanakiri iiroka: ‘Ikowatziiri Pinkathari. Ari joipiyaimiri iijatzi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jataiyakini, iñaakiri ithatakotaka iwonkiri burro pankotsinampiki. Ithataryaakotapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tzimatsi atziri ñaawakiriri, ikaimotawakiri: “¿Pinkantirika pithataryaakotantariri burro?” ");
INSERT INTO cpcNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ikantanakiri irirori okaatzi ikantawakiriri Jesús. Ishinitawakiniri jaanakiri burro. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jamaitakiniri Jesús. Jowaitakiniri manthakintsi imitzikaaki burro, ityaakaanakari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tzimatsi oomaankashitanakiriri manthakintsi, pashini chikanaintsiri inchashi ishitashitantyaari owaniinkatantyaari tsika ikinanaki. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Atziripaini iiwataintsiri, ikaatzi oyaatakiriri itaapiiki, ikaimaiyini, ikantaiyini: ¡Aatsikitataiki Awinkatharitiwí! Tasonkawintaari jinatzi, Pinkathari aitziri otyaantakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Aapatziyaari impoyaatyaarini acharini David-ni. ¡Aatsikitataiki Awinkatharipirotyaari! ");
INSERT INTO cpcNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ariitapaaka Jesús Jerusalén-ki, tyaapaaki tasorintsipankoki, jaminayitapaakiro maawoni. Tima aritaki tsiniriityaanaki, piyanaka Betania-ki itsipatanaari 12 jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Okanta okitiijyitamanai, piyaa Jesús ipoñagaawo Betania-ki, itajyaapaaki niyanki aatsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Jaminaki jantó jiñaaki okatziya pankirintsi, owaniinka okanta oshi. Jiyaatashitanakiro, jaminiro tzimatsirika okithoki. Tikaatsimaita, iyoshiita oshi, tima tikira okithokipaititaita. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jiyakatanakiro pankirintsi, ikantzi: “Ari pashi powaatyiiro iiro pikithokitai”. Ikimaiyakirini maawoni jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ikanta jariitaiyapaani Jerusalén-ki. Tyaapaaki Jesús tasorintsipankoki, jomishitowapaakiri pimantayitatsiri iijatzi amanantayitatsiri. Jotatsinkayitapaakiro jowayitziri kiriiki, ari ikimitaakiro iijatzi tsika jowayitziri shiro. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tiira ishinitanai jawisakairo jajyaagawo osaikira tasorintsipanko. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ari jiyotaantanaki, ikantzi: “Pairani josankinaitakiro, kantatsiri: ‘Nopanko inatzi jiroka, ari jamanapiintinari poñaayitachari nampitsiki’. Iro kantzimaitacha pamatawitantatapiintaki iirokapaini pipimantayitzira, pikimitakaantakiro koshintzipanko”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ikanta ikimaiyakini Yotzinkariiti, itsipatakari ijiwari Ompiratasorintsitaari, jaminaiyakironi tsika inkinakairo jowamaakaantiri. Iro kantzimaitacha ithaawantaitakari Jesús, tima iyokitzi ikantayitaka atziri jiñiiri kamiitha okanta jiyotaantayitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tima aritaki tsiniriityaaki, piyanaa Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ikanta ikinamanai osaiki pankirintsi, jiñaapairo sampishitanaki, kamanaki maawoni oparithaki. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ikinkishiryaanairo Pedro jiyakatakiro chapinki Jesús. Ikantziri: “Yotaanarí, paminiro pankirintsi piyakatanakiri, sampishitanaki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jakanaki Jesús, ikantzi: “Pawintaiyaari iiroka Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tima aririkami pinkowakotirimi Pawa joshirinkiromi otzishi jookiro inkaariki, iirorika pikisoshiriwaitanaki, iri pawintaanatya, aritaki jantakimiro. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iro nokamantantzimirori jiroka, tima aririka pamañaari Pawa pinkamitiri oityaarika, pawintaanatyaaririka, aritaki jantakimiro pikowakotziriri. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Aririka pamañaari Pawa, pimpiyakotairo kaari inimotzimiri jantzimotaitzimiri iiroka, onkantantyaari Ashitairi Inkitijatzi impiyakotaimi iiroka pikinakaashitakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Iirorika pipiyakotairo jantzimotaitzimiri iiroka kaari inimotimini, ari inkimityaari iijatzi Ashitairi Inkitijatzi, iiro ipiyakotsitaimi iiroka pantakiro kaaripirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ikanta jariitaiyapaani Jerusalén-ki, aniiwaitapai Jesús tasorintsipankoki. Ipokashitapaakiri ijiwari Ompiratasorintsitaari, itsipatakari Yotzinkariiti, ipokaki iijatzi Antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Josampitapaakiri, ikantziri: “¿Iitaka otyaantakimiri poñaagantiro pishintsinka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ari jakanaki Jesús, ikantanakiri: “Tzimatsi iijatzi naaka nosampitimiri, aririka pakakina ari nonkamantakimiro iita otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tima jowiinkaatantaki Juan-ni, ¿Iita otyaantakiriri? ¿Pawama? ¿Atzirima? Pakaiyinitya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ipoña ikantawakaanaka: “Aririka ankantakiri Pawa otyaantziriri, ari inkantanakai: ‘¿Oitama kaari pikimisantantari?’ ");
INSERT INTO cpcNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Aririka ankanti: ‘Atziri otyaantakiriri’, ari inkisanakai atziripaini. Tima ikantaiyini atziriiti, Kamantantaniri jinatzi Juan-ni”. ");
INSERT INTO cpcNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ari jakaiyanakini, ikantaiyini: “Tii niyotziro”. Ikantsitanaka iijatzi Jesús: “Ari nokimitsita naaka, iiro nokamantzimiro iita otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ari jitanaawo Jesús jojyakaawintziro jiyotaantayitziri, ikantzi: “Ipankitaki shirampari chochokimashi, jotantotakotakiro, jiwitsikashitakiro jowironta paata owaaki, jiwitsikaki pankojyitantsi inkini jaminakoitiro pankirintsimashi. Ipoña jaminaki aminironi iwankirimashi, jataki irirori intaina. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Okanta irakapaititaki iwankiri, jotyaantawitaka jompiratani jagaatimi okithoki. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ikanta jiñaawakiri antawaitatsiri, jaawakiri ipajawaitawakiri, joipiyairi tikaatsi jaanai. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jotyaantawita iijatzi pashini jompiratani. Itsitokainawaitawakiri, ikawiyawaitakiri, joipiyakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jotyaantaki iijatzi pashini, jowamaitakiri. Ojyiki ikaatzi jotyaantawitakari, tzimayitatsi ipajawaitaitakiri, jowamaitakiri pashinipaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Apaani ikantapaaka itomi irirori, jitakopirotari, jotyaantakiri, ikantashiritzi: ‘Jirikarika notomi naaka ari impinkathaitakiri’. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Iro kantzimaitacha jirikapaini aminirori pankirintsimashi, ikantawakaa: ‘Jirikataa ashitaiyaawoni paata pankirintsimashi. Thami owamairi, ayiroota aaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jaawakiri, jowamaakiri. Jookakiri othapikitapaa pankirintsimashi. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Iitama jantiri ashitawori pankirintsimashi? ¿Tiima ari impokanaki irirori, jowamairi aamaakowintawori iwankirimashi, jaminai pashini? ");
INSERT INTO cpcNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Tiima piñaanatziro osankinarintsi? Kantatsiri: Imanintawitakawo mapi witsikirori pankotsi, Iro kantzimaitacha jowatzikaitairo mapi pankotsinampiki, ikimitakagaitaawo iroorikami tzinkamitsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Iriitaki Awinkathariti Pawa owairori onaminaki, Irootaki ayokitziiwintantakariri maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ari ikowaiyanakini jaakaantanakirimi Jesús, jiyotawakiro iriitaki ikantakotziri. Tii okantzi, tima ithaawantatyaari atziri piyowintakariri. Jowajyaantanakiri, jiyaapithatairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ipoña jotyaantaitaki Fariseo itsipatakari aapatziyariri Herodes, ikowaiyini inkompitakaiyaarimi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ikanta jariitaiyakani, ikantapaakiri: “Yotaantanirí, okaatzi piñaanitari iiroka iroopirori inatzi, kaari inintakaashitani atziri. Piyotaantziro iiroka tyaaryoopiroini inintakaantziri Pawa. ¿Kamiithatatsima ampiri kiriiki ikowakotantziri Pinkathari César?” ");
INSERT INTO cpcNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jiyotawakiri Jesús, ikowatzi jamatawitirimi osampitakiriri, ikantanakiri: “¿Iitama piñaantashiwaitantanari? Pamakinari kiriiki, naminawakiriita”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jamaitapaakiniri. Ikantzi Jesús: “¿Iitama ashitawori jojyakaawo jaka? ¿Iitama ashitawori iwairo?” Ikantaiyini irirori: “Jashi César”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ikantanaki Jesús: “Tima iri César ashitariri, pantatyaanari ikowakaimiri pimpinatiri. Irooma maawoni jashitari Pawa, pantatyaanari ikowakaimiri irirori”. Iyokitzii ikimpoyaanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ipoña ipokaiyakini Saduceo jiñiiri Jesús. Iriitaki Saduceo kantayitatsiri iiro jañagai kamayitatsiri. Josampitapaakiri: ");
INSERT INTO cpcNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Yotaantanirí, josankinataki pairani Moisés-ni, kantatsiri: Aririka inkami shirampari, jookawintanairo iina. Iirorika jowaiyantakairo, kamiithatatsi jiinataiyaawo iririntzi. Aririka owaiyantai tsinani, kimiwaitanaa iriirikami ashityaarini oimi kitziroini kamaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Thami ankantawaki: Tzimatsi 7 shirampari, iririntzi jinaiyatziini. Itawori itzimi jaawitaka iina, tikira osamanitzi, kamaki, tii jowaiyantakairo iina. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ipoña jaawitaawo pashini iririntzi apititatsiri itzimi. Ari ikimitakari irirori, kamaki, tii jowaiyantakairo. Ipoñaawitapaaka mawatatsiri itzimi, iijatzi ikimitakari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ari ikantakari maawoni ikaataiyini 7 iririntzi. Tikaatsi owaiyantakaironi. Okanta osamanitaki kamai iijatzi iroori tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aririka jañaayitaimi paata ikamawitaka, ¿Itzimikama oimipirotaiyaari tsinani? Tima maawoni ikaatzi 7 iinantawitakawo”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jakanaki Jesús, ikantziri: “¿Oitama kaari pikimathatantawo osankinarintsipirori? ¿Oitama kaari piyotantawo ishintsinka Pawa? ");
INSERT INTO cpcNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tima aririka jañaayitai paata kamayitatsiri, iiro itzimapai aawakaachani. Jojyapaiyaari maninkariiti saikayitatsiri inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","¿Tiima piñaanatziro josankinari Moisés-ni tsika ikanta Pawa jiñaanatantakariri oota kitochiimaishi? Ikantakiri: Naakataki Pawa ipinkathatziri Abraham, Isaac, iijatzi Jacob. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ari ayotaiyini añaayitatsi irirori, tima tii okantzi kaminkari impinkathatiri Pawa, apa jimatziro añaayitatsiri. ¿Ñaakiro? Pikinakaashitakawo iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ari ipokapaaki Yotzinkari, ikimapaakiri jiñaanatawakaa. Yotapaaki kamiitha Jesús jiyotaakiri Saduceo, josampitapaakiri irirori: “¿Oitama itawori kowapirotachari Ikantakaantaitani?” ");
INSERT INTO cpcNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jakanaki Jesús, ikantzi: “Jiroka kowapirotachari, okantzi: Pinkimi Israel-mirinkaiti, jirika Awinkathariti Pawa, Pinkathari apaniroini ikanta irirori. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pitakopirotaiyaari, pitakoshiritaiyaari, pitakoshintsitaiyaari, pampithashiri powairi iijatzi. Iro kowapirotachari Ikantakaantaitani. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ari okimitawo apititanaintsiri, okantzi: Pitakotaiyaari pijyininka, pinkimitakaantairi pitakotawo piwatha iiroka. Tikaatsi pashini Ikantakaantaitani anaironi jirokapaini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ikantanaki Yotzinkari: “Kamiithataki, Yotaantanirí, imapirotatya pikantakiri: Apaani jinatzi Pawa tikaatsi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Owanaa okamiithataki atakopirotaiyaari, atakoshiritaiyaari, atakoshintsitaiyaari, pampithashiri owanairi. Iijatzi ankimitawakaanaiya aaka, atakotawakaiya. Iro ikowakaapirotairi Pawa, anairo maawoni itagaitziniriri Pawa jashitakaitariri iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ikanta Jesús, jiñaakiri kamiitha okaatzi ikantakiri, ikantanakiri: “Irootaintsimi piñiiro pimpinkathatairi Pawa, impinkathariwintantaimiri irirori”. Tikaatsi kowanaatsini josampitanairi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ipoña jiyotaantaki Jesús tasorintsipankoki, ikantzi: “¿Oitama pikinkishiritari iiroka, aririka pinkimiri Yotzinkariiti, ikantzi: ‘Jirika Cristo-tatsiri icharini jinatatzi David-ni?’ ");
INSERT INTO cpcNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tima Tasorintsinkantsi ñaawaitakaakiri pairani David-ni, ikantaki: Jiñaawaitaki Pinkathari, ikantawairi nowinkathariti: Pisaikapai nakopiroriki, ampinkathariwintanti, Irojatzi paata nowasankitaantyaariri kisaniintayitakimiri, ari pimakoryaakiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ikantsitaka kitziroini David-ni irirori: ‘Nowinkathariti jinatzi Cristo’. ¿Tsikama inkini incharinityaari?” Ikanta maawoni atziri piyotainchari, inimoyitakiri ikimiri ikantayitziri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ipoña ikantaki iijatzi Jesús: “Paamaiyaari Yotzinkariiti. Owanaa ikowiro jowaniinkatya, inkantakaapirowaityaawo iithaarithanthanaa. Ikowi jiwithatapiintaityaari jiñaitiririka. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Aririka jiyaati pankotsiki japatotapiintaita, ikowapiintziro josatitya niyankiniki. Ari ikimitari aririka jowaiyaani ijyininka, ikowapiintzi josatitya. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jathaagakawo iijatzi kamatsiri oimi jaapithatziro opanko. Iro josamaninkantawori jamanapiinta iiro jiyotantaitari. Iro kantzimaitacha antawo jowasankitaayiitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ikanta Jesús isaikapaaki jaminakotziri otiyitziriri iiriikiti. Ipokaiyakini ajyaagantzinkari jotipiroyitzi irirori iiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ari opokapaaki tsinani kamatsiri oimi, ashironkainkawo inatzi, otitapaaki iroori apipintyakitiini kiriiki, tikaatsi monkaatachani amanantantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ikantanakiri Jesús jiyotaani: “Anaantaki jiroka tsinani, anaakiri ikaatzi otipirowitainchari. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tima ikaatzi otiyiwitainchari ojyiki, jotitashitakari tzimagaantatsiri iiriikiti. Irooma jiroka ashironkainkawo, apintziryaakiri otitakiri amanantantyaarimi okowayitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ikanta ishitowanai Jesús tasorintsipankoki, ikantzi apaani jiyotaani: “Yotaanarí, paminirotya mapi jiwitsikantaitawori, antawo inatzi, owaniinkawaitaka pankotsi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ikantzi Jesús: “maawoni pankotsi piñaakiri, irootaintsi impookaitiro, iiro jiñagaitairo piwiryaawitachari mapi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ipoña itonkaanaki Jesús otzishiki Olivo, jimontitapaakawo tasorintsipanko. Ari isaikapaaki. Ikanta Pedro, Juan, Jacobo itsipatakari Andrés, josampitakiri jantyaatsikiini, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Pinkamantina: ¿Tsikapaitika omatya pikantakiri? Aririka imonkaatzimatatya, ¿tsika onkantyaaka niyotantyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ari jakanaki Jesús ikantzi: “Paamaakowintya jamatawiitzimikari. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ojyiki kowatsini jamatawitimi paata, impairyaapaakina, inkanti: ‘Cristo ninatzi naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ari pinkimakotakiro owayiritaantsi, paamaiyaawo ominthaawashitzimikari, tima ontzimatyii imonkaataiya jirokapaini, tikiraata imonkaata onthonkantaiyaari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jantaminthatawakaayitya maawoni nampitsiki jotyaantayitiri pinkathariyitatsiri. Jiñaitiro ojyiki ontziñiiya, jiñaitiro ojyiki tajyinkataantsi. Irootaki itanatyaawori inkimaatsitaityaawo jirokapaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ontzimatyii paamaakowintaiya. Tima jaakaantaitatyiimi jiwaripainiki impajawaitaitimi pankotsiki papatotapiinta. Impoña jaayiitanakimi isaikayitzi pinkatharipirori okantakaantziro pawintaana, ari pinkinkithatakotainari janta. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Iro kowapirotachari jityaawo atziripaini inkimakotairo Kamiithari Ñaantsi maawoni nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Aririka jaayiitanakimi, iiro pikantashiritzi: ‘¿Oitama nonkantiriri?’ Tima Tasorintsinkantsi yotakaimironi oita pinkantiri, tii iiroka ñaawaitashitachani. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ari jiñaitaki aakaantirini iririntzi jowamaakaantiri. Piñi aakaantirini itomi. Piñi owamaakaantirini ashitariri ikisaniintanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Owanaa piñiiro inkisaniintaitimi okantakaantziro pipairyagaana pikimisantaana, iro kantzimaitacha aririka pikantaitanakityiiro pawintaiyaana, aritaki nowawisaakotaimi. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aririka piñaakiri jiitaitziri ‘Pinkaari Apirotantaniri’ isaikapaaki tsika tii inintakaitziri, inkaati nampitaiyaawoni paata Judea-ki, ontzimatyii ishiyayitai tonkaari otzishiki. Tima iro ikinkithatakotakiri pairani Kamantantaniri Daniel-ni”. (maawoni ñaanataironi jiroka, okowapirotatya inkimathatairo.) ");
INSERT INTO cpcNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","“Pisaikirika jikokiroki pipankoki, ari pimpoñaatya pishiyanaki, iiro pityaapanaatzi paapanaati oitya. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Powanikirika pisaiki, iiro paapanaatziro piithaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Inkantamachiitiro paata onkaati motyaatatsiri, onkaati tzimatsini iintsiti iiniro ithotzi! ");
INSERT INTO cpcNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pamañaari Pawa, onkantya aririka pishiyayitaki, iiro otonkiyotantzimi tyaawontsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tima antawo jiñaitiro jashironkaitya paata. Pairani owakiraa jiwitsikaitakiro kipatsi, irojatzi iroñaaka tii jiñaitziro kimityaawoni jiroka ashironkaantsi. Iiro apiita jiñaitairo kimityaawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iiromi ishintsitaki Awinkathariti jomairintziro ashironkaantsi, tikaatsi awisakotaatsinimi. Ikamintha itzimayitzi jiyoshiitairi irirori, awintaayitaiyaarini, irootaki jomairintantakawori ashironkaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aririka pinkimi inkantaitimi: ‘Jirika Cristo’. Pashini kantimini: ‘Jirinta Cristo’, iiro pikimisantziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tima impokayitapaaki ojyaarini Cristo, ojyaarini Kamantantaniri. Ari intasonkawintantayitapaaki, inkowawitya jamatawitirimi jiyoshiitairi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Paamaakowintaiya iiroka, aritaki nokamantsitakimiro kitziroini”. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Paata, aririka onkaatapaaki jashironkaita antawo, ari intsiwakanaki ooryaa, iiro joorintanaa kashiri, ");
INSERT INTO cpcNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","intziroryaayiti impokiro inkitiki, maawoni oorintayitachari inkitiki impookayiti iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Aripaiti impokai Itomi Atziri inkinantapaiyaawo minkori, jiñaitawairo ishintsinka iijatzi jowaniinkawo. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Impoña jotyaantakiri maninkariiti, japatotairi ikaatzi jiyoshiitaitakiri nampiyitawori maawoni tsikarikapaini kipatsiki, irojatzi tsika ochimpitapaa. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ari okimitawo piñaapiintziro iirishitzi pankirintsi, piyotzi irootaintsi osarintsitzimatai. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iro piyotiri iirokapaini, aririka piñaayitairo nokamantayitakimiri, pokimataana. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Imapiro nokantzi, iiro ikamita jirika ajyininkapaini, irojatzi jiñaantatyaawori nokamantayitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Iiro okantaitatyaani piñiiro inkiti iijatzi kipatsi, irooma okaatzi noñaaniyitakari imapiroitaatyaani iroori. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Tima apaniroini ikantakaawo Ashitairi jiyotziro tsikapaiti imonkaataiya. Tii jiyotziro Itomi, iri owatsipiro maninkariiti saikatsiri inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Paamaakowintya, aminapiinta pinkantya, pamaña. Tii piyotzi tsikapaiti imonkaatantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ojyatyaawo aririka jiyaati atziri intaina. Jookanakiro ipanko, inkantanakiri maawoni jompiratani oitarika jantiniriri. Iijatzi ikimitaakiri aamaakowintawori pankotsi, inkantanakiri: ‘Paamagaina’. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Paamaakowintaiya iiroka, tima tii piyotzi tsikapaiti impiyi ashitawori ipanko, tsiniriitiini, niyankiitipaiti, iñiimataki tyoopi, onkitiijyitzimataki, ");
INSERT INTO cpcNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","aririka jomapokaimi impiyi, iiro jiñaapaimi pimayi. ");
INSERT INTO cpcNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Okaatzi nokantayitzimiri iiroka, irojatzi nokantsitariri iijatzi maawoni: ‘Paamaiya’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ari kaatapaaki apiti kitiijyiri joimoshirinkapiintaitziro Anankoryaantsi, jowantapiintaitawori iijatzi tantaponka. Ari ikamantawakaari ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti, ikantawakaiyani: “Thami amatawitiri Jesús ayiri, owamaakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iro kantacha iiro amaamanitziri kitiijyiri joimoshirinkaita, ipiyakowintarikari atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ikanta ikinanai Jesús Betania-ki, ipankoki Simón pathaawaiwitachari. Ari isaikaki jowaiyani. Ariitapaaka tsinani amakotaki kasankaari. Iyoshiita owaaki inchatiya iitachari “nardo”, ojyiki owinawo, kamiitha okantaka onaki jiwitsikaitziro mapi oita “alabastro”. Osataakotakiro opatziki, osaitantakari ipatziitoki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kisanaka ikaatzi ñaakirori, ikantawakaanaka: “¿Oitama apaatantawori kasankaari? ");
INSERT INTO cpcNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Aririkami ompimantya, jagaitimi ojyiki kiriiki inkaatimi 300, iri ampashityaarimi ashironkainkari”. Ikisanakiro tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ari ikantzi Jesús: “Piñaashityaawo, ¿Oitama pikisantawori? Kamiitha okanta noñaakiro antakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ari inkantaitatyaani ashironkainkari piñiiri pintsipatyaari, pikowirika pitakotyaari, ari pimpashitatyaari. Irooma naaka, iiro okantaitatyaani piñiina pintsipataina. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jiroka tsinani antatziiro aawiyiri iroori, iiwataki osaitantanawo kasankaari ojyakaawintatyaana aririka inkitaitakina. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Aririka ikamantantaitairo Kamiithari Ñaantsi, inkinkithatakoitairo tsinani, ari onkantya joshiritantaityaawori antakiri iroori. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ikanta Judas Iscariote, jiyaatashitakiri ijiwari Ompiratasorintsitaari impimantiri Jesús. Iriiwitaka kaawitachari 12 jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Antawo ikimoshiritaiyanakini jiwari, ishinitakiri impiri kiriiki. Jaminaminatanakiro Judas tsikapaiti jaakaantiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ariitapaaka itanainchari kitiijyiri jowantapiintaitawori tantaponka, jowamaapiintaitziri jowaitari kitiijyiriki Anankoryaantsi. Ari josampitakiri jiyotaani Jesús, ikantziri: “Yotaanarí, ¿Tsikama onkotsitakaantika aaka?” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ari ikantanakiri apiti jiyotaani: “Piyaati nampitsiki. Ari pintonkiyotyaari atziri jaakotziro ijiñaati kowityaaniki. Poyaatzishitanakiri, ");
INSERT INTO cpcNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","tsikarika intyaapaaki, pinkantiri ashitawori ipanko: ‘Ikowi jiyoti yotaanari tsika jowakaiyaari jiyotaani’. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ari joñaaganakimiro jinoki ipanko, antawo okantaka jiwitsikaitakiro maawoni inkini jowaiyani. Ari ponkotsitakaantiri oyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jataki jiyotaani ariitaka nampitsiki. Jiñaakiro ikantakiriri, ari jonkotsitakaantakiri joyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Okanta otsiniriityaanaki ariitapaaka Jesús, itsipatapaakari iijatzi 12 jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ikanta jowaiyani, ikantzi Jesús: “Pikaataki patyootana, tzimatsi apaani pithokashitinani. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Owashiri ikantaiyanakani. Josampiyitanakiri, ikantziri: “¿Naakama pithokashitimini?” Pashini osampitziri: “¿Naakama?” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ikantzi Jesús: “Iriitaki apaani pikaataki patyootakina. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tyaaryoo impiyakotya Itomi Atziri, tima irootaki josankinatakoitakiri pairani. ¡Ikantamachiitziri pithokashityaarini! Iiro itzimaajaitzimi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Iinta jowaiyani, jaakiro Jesús tanta. Ipaasoonkiwintakiro, ipitoryaakiro, ipayitakiri jiyotaani, ikantziri: “Poyaawo, nowatha inatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ipoña jaatakotakiro jimiriitari, ipaasoonkiwintakiro, ipakotakiri jiyotaani, jirayitaki maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ikantziri: “Niraani inatzi, iro shitowatsini jawisakoshiritantaiyaari ojyiki. Irootaki oñaagantapirotironi ankajyaakaawakaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Iiro niritaawo, irojatzi paata aririka impinkathariwintantai Pawa, ari napiitairo. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ikanta ithonkanakiro ipampithaakotziri Pawa, jataiyanakini tonkaariki otzishiki Olivo. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ikantzi Jesús: “Irootaintsi pookawintaiyinani tsiniripaiti. Tima josankinaitaki pairani kantatsiri: Nowamairi aamaakowintariri oijya, ari inthontya impookanaki ipira. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iro kantacha, aririka nañagai, Galilea-ki noyaapaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ipoña ikantzi Pedro: “Aritaikima jookawintaimi pashinipaini, iiro nimatziro naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ikantzi Jesús: “Iroñaaka tsiniripaiti, tikiraata japiitziro jiñi tyoopi, mawajatzi pinkantaki: ‘Tii noñiiri Jesús’. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iikiro ishintsitatzi Pedro, ikantzi: “Iiro nookawintzimi, kimitaka ari ankaati ankami”. Ari ikantaiyakini iijatzi maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ikanta jariitaiyakani Getsemaní-ki, ikantapaakiri jiyotaani: “Ari pisaikawaki jaka, namanamanaatawatya”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Iri itsipatanaka Pedro, Jacobo iijatzi Juan. Antawo jiraashiritakotapaaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ikantziri: “Owamaimatatyiina nowashirinka. Ari pisaikaiyawakini iiroka, pinkakimpiti”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jawisaniintanaki kapichiini irirori. Otziirowapaaka kipatsiki, jamanapaaka, iiro ikimaatsitantawo awijyimotirini. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ikantziri: “Ashitanarí, tikaatsi pomirintsitzimotimini iiroka. Nokowawita pookakaawintinami onkaati nonkimaatsityaari. Iro kantacha iiro pantanawo nokowawitakari naaka, iro panti oita pikowakaakinari iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ipoña ipiyapaaka, jiñaapaatziiri jimagaiyini. Ikantapaakiri Pedro: “Simón, ¿Oita pimaantari? ¿Tiima pikisashitawo piwochokini? ");
INSERT INTO cpcNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pinkakimpiti, pamaña, otzimikari pikinakaashitani. Tima tii pikisashiwaitanita, ojyiki inawita kamiithatatsiri pikowawitari pantirimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iijatzi ipiyanaa, amanapaa iijatzi. Irojatzi japiitapai ikantayitakiri inkaanki. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ikanta ipiyapaa, iijatzi jiñaapairi jimagaiyini, tima antawo okantaka iwochokini. Ikaaniwaitzi jiyotaani, tii jiyotzi oita inkantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Iro mawatanaintsiri ipiyapaaka, ikantapaakiri: “¿Irojatzima pimagaiyini? Monkaatapaaka jaakaantaitantyaariri Itomi Atziri, jagaitiri kaaripiroshiriki atziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pimpiriinti, thami aatai. Okaakitzimatapaaki pithokashitinani”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jiñaawaiminthaitzi Jesús, ariitapaaka Judas ikaawitapiintari. Ojyiki itsipatapaakari, jamayitaki jowathaaminto, ipajaminto. Jotyaantani jinatzi pinkathariiti apatowintariri Jesús: Ijiwari Ompiratasorintsitaari, Yotzinkariiti, iijatzi Antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tima Judas, pithokashitantachani, ikantsitakari kitziroini jamaniwo: “Tsika itzimi nonthopootapaakiri, iriitaki, poojotiri, paanakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ikanta jariitapaaka, jontsitokapaakari okaakiini Jesús, ikantapaakiri: “Yotaanarí”. Ithopootapaakiri jiwithatapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Joirikaitapaakiri Jesús, joojoitapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ikanta tsipatakariri okaakiini Jesús, inoshikanakiro iyotsiroti, itotsitakiri ikimpita jompiratani ijiwari Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ipoña ikantzi Jesús: “¿Naakama koshintzi, pamashitantanari powathaaminto, pipajaminto? ");
INSERT INTO cpcNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tima piñaapiintana niyotaantzi tasorintsipankoki ¿Kaarima paantana janta? Ari onkantya, iro imonkaatantyaari josankinatakoitakinari pairani”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Shiyaiyanakani jiyotaani, jookawintaitanakiri apaniroini. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tzimatsi mainari oyaatakowintanakiriri Jesús. Ikithaawitaka. Iro kantzimaitacha joirikawiitakari irirori, ");
INSERT INTO cpcNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","jaatonkoryaanakiro iithaari ithañaanaka, ishiyamirikitashitanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ipoña jagaitanakiri Jesús ijiwaripiroritiki Ompiratasorintsitaari. Ari japatotaiyakani maawoni ijiwari Ompiratasorintsitaari, itsipatakari Antaripiroriiti, iijatzi Yotzinkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ikanta Pedro noshikaka irirori ipoki iintsikiryoini, joyaatakowintakiri Jesús, irojatzi jariitantapaaka osaiki ipanko ijiwaripiroriti Ompiratasorintsitaari. Ari ikatziyapaakari itsipatapaakari jompiratanipaini, jakitsitaiyani paampariki. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ikanta ijiwaripaini Ompiratasorintsitaari itsipatakari ikaatzi apatotainchari, jaminawitaka iitya thiiyakotyaarini Jesús onkantantyaari jowamaakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tzimawitaka ojyiki thiiyakowitapaakariri, tiimaita imonkaatawakaa ikantawitakari pashinipaini. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Opoña ikatziyanaka apaanipaini, ithiiyakotanakari Jesús, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nokimiri naaka chapinki jirika, ikantzi: ‘Ari nompookakiro tasorintsipanko, jiwitsikani atziri, iro awisawitatya mawa kitiijyiri nonthonkairo niwitsikainiri pashini, kaari ipomirintsiwinta atziri jiwitsikiro’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tima jinashiyitakawo okaatzi ikantawitakari pashini. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ipoña ikatziyanaka ijiwaripiroriti Ompiratasorintsitaari, josampitanakiri Jesús, ikantziri: “¿Oitama kaari pakanta? ¿Tiima pikimi okaatzi ikantakoitzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Irojatzi jimairitaki, tii jaki. Japiitziri josampitziri: “¿Iirokama Cristo, Itomi Tasorintsitatsiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jakanaki Jesús, ikantzi: “Naakataki. Irootaintsi piñiiri Itomi Atziri intsipataiyaari jakopiroriki Pawa impinkathariti. Impoña piñiiri impiyi inkinapai minkoriki”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ikanta ikimaki ijiwaripiroriti, jaanakiro iithaari isagaanakiro ikisanaka, ikantzi: “¿Iitama pashini ankowiri inkinkithatakoitiri? ");
INSERT INTO cpcNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Pikimaiyakirini maawoni ithainkakiri Pawa. ¿Tsikama pikantaiyinika iiroka?” Ikantzi maawoni: “¡Tzimataiki ikinakaashitani! ¡Ontzimatyii inkami!” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tzimatsi apaanipaini iiwapootanakiriri. Tzimatsi pashini otzimikapootakiriri, ipoña ikapojawaitziri, ikantzimaitari: “¿Incha piyoti Kamantantanirí?” Jimatsitakawo iijatzi jompiratani ijiwaripiroriti, ipajawoowaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Isaikaki Pedro jikokiroki, shitowapaaki tsinani jompiratani ijiwaripiroriti Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Oñaapaakiri Pedro jakitsita paampariki, okantziri: “¿Tiima iiroka itsipatapiintari Jesús Nazaret-jatzi?” ");
INSERT INTO cpcNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jotikanakiro Pedro, ikantanaki: “Tiitya, tii niyotzi iita pikantanari”. Shitowanaki kapichiini. Irojatzi jiñaantanakari tyoopi. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Okanta osamaniityaaki, oñagairi iijatzi, okamantakiri akitsitachari, okantziri: “Irijatziita jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Japiitanakiro Pedro jotikiro. Tikira osamanitzi, japiitanakiro ikaatzi saikaintsiri josampitziri, ikantziri: “Iirokataki itsipatapiinta Jesús, tima Galilea-jatzi pinatzi, iriiwaitaki ikantziro jiñaawaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ikantzi: “Tii niyotziri pikantanari. Jiyotzi Pawa imapiro nokantzi, nothiiyarika, jowasankitainaata”. ");
INSERT INTO cpcNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ari japiitanakiro jiñaanaki tyoopi, kantanaka apiti japiitakiro. Ikinkishiryaanakiro Pedro ikantakiriri Jesús: “Tikira apititanaki jiñi tyoopi, mawajatzi potiki, pinkanti: ‘Tii noñiiri Jesús’ ”. Iraanaka ikinkishiryaanakiro. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Okanta okitiijyitamanai, japatotaiyaani maawoni pinkathariiti: ijiwari Ompiratasorintsitaari itsipatakari Antaripiroriiti, Yotzinkariiti, ojyiki ikinkithatakotakiri Jesús. Ipoña joojoitanakiri, jagaitanakiri isaiki Pilato. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Josampitawakiri Pilato, ikantziri: “¿Iiroka iwinkathariti Judá-mirinkaiti?” Jakanaki Jesús, ikantzi: “Irootaki pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ikanta ijiwari Ompiratasorintsitaari, ikisaniintanakiri, ithiiyakowintanakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Japiitanakiri Pilato josampitziri: “¿Tikaatsima pinkantiri iiroka? ¿Tiima pikimi okaatzi ikantakoyiitzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Tii jaki Jesús. Jotzikanaminthatanakiri Pilato jirika Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tzimatsi jantapiintziri Pilato: maawoni osarintsiki joimoshirinkaiyaani Judá-mirinkaiti, jomishitowakaantzi ijyininka jaakaantaitziri ikowiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tzimatsi iitachari Barrabás, jomontyaitziri itsipayitakari ikaataiyini jowamaantaki, jowayiritari iwinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ikanta ipokaiyapaakini atziri, ikowakotapaakiri Pilato jantiro jamitapiintari. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jakanaki Pilato, ikantzi: “¿Iriima pikowi nomishitowakaantiri jiitaitziri ‘Iwinkathariti Judá-mirinkaiti?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jiyotzi Pilato, ikisatya ijiwari Ompiratasorintsitaari jaakaantantakariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Iro kantzimaitacha ijiwari Ompiratasorintsitaari, jowatsimaakiri atziriiti inkantaiyini: “Iri kamiithatatsi jomishitowaitiri Barrabás”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Japiitanakiri Pilato josampitziri: “Jirika jiitaitziri ‘Iwinkathariti Judá-mirinka’, ¿Tsikama nonkantirika?” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ikantzi ikaimaiyini atziri: “¡Pimpaikakotakaantiriwí!” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ikantzi Pilato: “¿Tzimatsima kaaripirori jantakiri?” Iikiro ishintsitatzi ikaimaiyini ikantzi: “¡Pimpaikakotakaantiriwí!” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ikowanaki Pilato jantiniri ikowakiri atziripaini, jomishitowakaantakiri Barrabás. Iri ipajatakaantanaki Jesús, jagaitanakiri impaikakoitiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ikanta owayiriiti ityaakaanakiri Jesús ipankoki Pilato, jiitaitziro “Pretorio”. Ari japatotakiri maawoni owayiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ikithaatapaakiri kithaarintsi pitzirishimawopirotatsiri kimitawori ikithaatapiintari pinkathariyitatsiri. Ipoña jamathaitantakari kitochiitapo. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iro jantantawori jiroka, tima ithainkimawaitatziiri. Ikaimotzimaitari, ikantzi: “¡Jirikataa iwinkathariti Judá-mirinkaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ipoña jompojainatantari sawoo. Jiiwapootakiri. Jotziirowashitzimaitari impinkathatirimi ikantzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ari jishitakiro ishirontaminthatari. Jaatonkoryagairi, ikithaatairi iithaari irirori. Jaanakiri impaikakotiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ikanta Simón, poñaachari Cirene, iwaapati Alejandro itsipatakari Rufo, itonkiyotakari jariita nampitsiki, ishintsiwintanakiri jinatanakiro impaikakoitantyaariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jagaitanakiri tonkaariki oita “Gólgota” (akantziri aaka: “Atziriitoni”.) ");
INSERT INTO cpcNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ipakoitapaakiri imiri itsipataitakiro kipijyaari, tii jiriro. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ipoña ipaikakoitakiri. Ikanta owayiriiti jowawisaawakaawo ikithaayitari Jesús, ikimitakaantakiro jiñaaritaita jiyotantyaari intzimi ayironi. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Aritaki jinokiityaapaaki ooryaatsiri, ipaikakoitakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Josankinaitaki kantakaantakirori ipaikakoitantakariri, okantzi: IWINKATHARITI JUDÁ-MIRINKAITI. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ari itsipataitakiri ipaikakoitziri apiti koshintzi, ikatziyakotaka apaani jakopiroriki, pashini jampatiki. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ari imonkaatakari osankinatainchari pairani, okantzi: Itsipataitakiri kaaripiroshiritatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ithainkimawaitakiri ikaatzi awisayitatsiri janta, jotikayinata, ikantziri: “Aña iiroka pookirori tasorintsipanko, iro awisawitatya mawa kitiijyiri piwitsikairo iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","¿Oitama kaari payiitanta ipaikakoitakimi powawisaakotaiya?” ");
INSERT INTO cpcNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Irojatzi ikantsitakari iijatzi ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti, jowashiyawintari, ikantawakaiyani: “Jowawisaakotziri pashini, ¿Kaarima jimatantawo jowawisaakotya irirori? ");
INSERT INTO cpcNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Incha jayiiti Cristo-witachari jiitaitziri ‘Iwinkathariti Israel-mirinkaiti’, ankimisantantyaariri!” Jimatsitanakawo itsipatakari ipaikakota, ithainkimawaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Okanta itampatzikatapaaki ooryaatsiri, omapokashitapaaka otsiniritanaki, irojatzi jyiitiini itainkanaki ooryaa. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ari ikaimanaki Jesús shintsiini, ikantanaki: “¡Eloi! ¡Eloi! ¿Lama sabactani?” (Iro ikantaitziri añaaniki aaka: “Pawa, Pawa, ¿iitama pookawintantakinari?”) ");
INSERT INTO cpcNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ikanta jirikapaini saikawintakiriri Jesús, ikimawitawakari ikaimanaki. Ikantanaki: “Pinkimiri, ikaimatziiri Elías”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ishiyapainta apaani, jomitsitsiyakiro manthakintsi kipijyaariki, jankowiitakiniri sawoopankiki, jowaankakotakiniri jatsimiyaatiro, ikantzi: “Añaawakiriita ari impokaki Elías jowayiitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ipoña japiitanakiro ikaimanai shintsiini, tii jañiinkatanai. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Okanta janta tasorintsipankoki, sagaanaki niyankiniki tontamawotatsiri ithatashiitzirori, opoñaanaka jinoki irojatzi isaawiki, apikota okantanaka. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ikanta ijiwari owayiriiti katziyawintakariri Jesús, jiñaakiri ikaimanaki shintsiini ikamantanakari, ikantanaki irirori: “Imapirotatyaama Itomintari Pawa jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tzimatsi iijatzi tsinani aminaintsiri jantyaatsikiini. Jiroka okaataiyini: María Magdala-jato, Salomé, María inaanati iyaapitsi Jacobo iijatzi José. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jirokapaini tsinani irootaki tsipatakariri pairani Jesús Galilea-ki, ojyiki imitakoyitakiri. Otsipatakawo iijatzi pashini tsinanipaini oyaatapaakiriri Jesús ipokaki Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aritaki tsiniriityaanaki. Irootaki kitiijyiri jaminantapiintaitari joyaari oñaatamanai, kitiijyiri jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ikanta José poñaachari Arimatea-ki, ikaatapiintziri japatota jiwariiti, irijatzi oyaawintariri Pawa impinkathariwintantai. Tii ithaawi jiyaatashitanakiri Pilato, ikantapaakiri: “Pishinitinari nonkitatairi Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tima jomapokapaakiri Pilato, tii jiyowita kamaki Jesús. Ikaimakaantakiri ijiwari owayiriiti, josampitakiri imapirorika ikamaki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ikamantaitakiri Pilato, ishinitainiri José jaanairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jamanantashitakiri kithaarintsi jintamawotatsiri. Ikintaryaakotairi, iponatakiri. Jowakotakiri imoontashiitziri kaminkaripaini shirantaaki, joipinakaantaki mapi, jojyipitakotantakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Okanta María Magdala-jato otsipatakawo María inaanati José, aminaiyakini iroori tsika jowaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Awisanaki kitiijyiri jimakoryaantaitari. Ari amanantaiyakini kasankaari María Magdala-jato, otsipatakawo pashini María inaanati Jacobo, iijatzi Salomé, jataki ontziritantaiyaari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Okanta okitiijyitamanai domingo, ananinkamanaki iyaati omooki jowakoitakiri Jesús. Aritaki ishitowimatapaaki ooryaatsiri ariitzimatapaaka janta. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Okantawakaiyani: “¿Iityaaka otainkironi mapi jomontyaitantakariri?” ");
INSERT INTO cpcNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iro aminawitapaaka, oñaatzi otainkaki mapi, tima antawo mapi inatzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tyaapaaki omooki jowawiitakari. Oñaapaakiri mainari isaikaki akopiroriki, okitamaanikitaki iithaari. Othaawaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ipoña ikantanakiro irirori: “Iiro pithaawawaitzi. Iriima pipokashiwita Jesús Nazaret-jatzi, ipaikakoitakiri chapinki. Añagai, tii isaiki jaka. Paminiro jowawiitakari. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pimpiyanaki, pinkamantayitairi jiyotaani, pinkantairi Pedro ari jiyaatai Jesús Galilea-ki, ari piñaayitairi. Aritaki ikamantsitakimi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Oshiyapithatanakawo omoona, ompitawaitanaka. Tikaatsi pashini atziri onkamantanaki, tima othaawanakitzi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Aritaki añagai Jesús amaityaaki domingo, iro jitanaa joñaagaawo María Magdala-jato joshinchagairi pairani jaagawitawo kaatatsiri 7 piyari. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Irojatzi iyaatashitantanakariri itsipayitakari pairani Jesús, oñaapaatziiri jiraawaitaiyani, okamantapaakiri oñagairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ikanta ikimawitawakawo oñagairi Jesús jañagai, tii ikimisantaitziro. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ikanta Jesús, joñaagaari apiti jiyotaani jiyaataiyini aatsiki, pashinipootapai kapichiini. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ari ipiyaiyanakani irirori, ikamantawitapaakari ikaataiyini. Ari ikimitsitakari iijatzi, tii ikimisantaitziri. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ikanta jowawaita 11 jiyotaani, ari joñaagaari Jesús, ikaminaapairi, jiñaakiri kisoshiri ikantaiyakani, tii ikimisantziri ikaatzi ñaayitairiri jañagai. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ikantapairi: “Piyaati pothotyiiro maawoni kipatsi. Pinkinkithatainiri atziripaini Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Itzimirika kimisantawakironi, owiinkaatanaachani, iriitaki awisakoshiritaatsini. Iriima kaari kimisantawakironi, jowasankitaayiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jiroka inkantanaiya kimisantanaatsini: joshinchaayitairi piyarishiritatsiri impairyiina naaka. Jiñaawaiyitairo pashinitatsiri ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Aririka joirikawityaari maanki, aririka jirawityaawo piyantatsiri, tikaatsi onkantiri, iiro ikami. Ari joshinchaayitairi mantsiyaripaini iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ithonkakiro Awinkathariti ikamantayitakiri, irojatzi itzinaantanaari inkitiki, itsipatapaari Pawa ipinkathariwintantapai. Isaikimotapairi jakopiroriki. ");
INSERT INTO cpcNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ikanta jiyaataiyanakini jiyotaani, ikamantantaki maawoni nampitsiki. Awinkathariti antakaayitakiriri, jantakaayitakiri kaari jiñaapiintaitzi, ari onkantya jiyotantaityaari imapirotatya ikamantantziri. Ari onkantyaari.");
INSERT INTO cpcNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ojyiki kowawitainchari josankinatiromi okaatzi awijyimotakairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ikowaitaki jothotyiitiro okaatzi jiyotaayitakairi ñaayitajaantakirori owakiraini tsika itzimi kamantakairori ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ari nokimitakari iijatzi naaka Teófilo. Tima naakowintakawo iintsikiryoini tsika okanta opoñaantanakari, irootaki nosankinatantzimirori iiroka okaatzi awisayitaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ari onkantya piyotakotantyaawori tyaaryoopiroini okaatzi jiyotaawitaitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pairani, ipinkatharitantari Herodes janta Judea-ki, ari isaiki Ompiratasorintsitaari jiita Zacarías, icharini Abías-ni jinatzi. Irooma iina oita Elisabet, isawo Aarón-ni inatzi iroori. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kamiithashiri ikantaiyani apitiroiti ipinkathatziri Pawa. Imonkaatziniri okaatzi ikowakairiri, tikaatsi inkinakaashitapaintya. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tii itzimimaita jowaiyani, tima maanirothaki inatzi Elisabet. Jantaripirotashitapaaka apitiroiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Okanta pashini kitiijyiri, monkaataa jantapiintantawori Zacarías jompiratasorintsitantari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Tima iro jamitapiintaiyarini Ompiratasorintsitaari, ikimitakaantziro iñaaritaita, ari iñaitakiro iri Zacarías tyaatsini tasorintsipankoki intainiri Pawa kasankainkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Piyotaiyachani atziri jikokiroki jamanaiyani, itagaitzirowa kasankainkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ari joñaagakari Zacarías imaninkariti Awinkathariti, ikatziyimotapaakari jakopiroriki itayirowa kasankainkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Antawoiti ithaawanaki, iyokitzi ikantanaka jiñaawakirira. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ipoña iñaawaitanaki maninkari, ikantzi: “Zacarías, iiro pithaawi. Tima ikimaitakimiro pamanani. Ari piñaakiro piina Elisabet, owaiyanti. Iri piitiri Juan. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Aririka intzimaki pitomi, owanaa pinkimoshiriwintiri, ari inkimitsityaari iijatzi atziripaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Tima ñaapirori inkantakaiyaari Pawa. Iiro poitziri kachoyitatsiri ishinkiitari. Tima inampishiritantakari kitziroini Tasorintsinkantsi intzimakirika. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Inkinkishiritakaiyaari Israel-mirinkaiti inkimisantairi Awinkathariti Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iriitaki iiwatapaakirini Awinkathariti. Inkantakaatyaari ishintsinkani Elías, ari jaapatziyashiritakaiyaari owaiyantzinkariiti maawoni jowaiyaniiti. Ari jowamiithashiriyitairi katsimashiriri, ari onkantya jiwitsikashiritantaityaari inkimisantaitiri Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakanakiri Zacarías maninkari, ikantziri: “¡Ari! ¿Tsikama onkantya niyotantyaawori jiroka? Tima antaripirotapaakina naaka, iijatzi okimitsitakari noina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ikantzi maninkari: “Naakataki Gabriel, poñaachari Pawaki. Jotyaantakina nonkamantimiro Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Iro kantzimaitacha, okantakaantziro pithainkañaanitakina, kisopaanti pinkantya iroñaaka, irojatzi imonkaatantatyaari okaatzi nokantakimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Saikaiyatsini pashini jikokiroki joyaawintaiyarini Zacarías, ipoña ikantawakaiyani: “¿Iitama josamanitantari Zacarías tasorintsipankoki?” ");
INSERT INTO cpcNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ikanta ishitowawitapaa Zacarías, tii okantzi iñaawaitapai, jookojookowaitashitapaaka. Ari jiyotaitanakiri tzimatsi jiñaakiri tasorintsipankoki. Jashi jowanakiro ikisopaantitanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Irojatzi imonkaatantawori kitiijyiri jantawaitzi tasorintsipankoki, jatai ipankoki irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Okanta Elisabet iina Zacarías, motzitaki. Antawoiti okinkishiritaka, tii oshitowai opankoki ikaatzi 5 kashiri omairintaka, okantashiriwaitzi: ");
INSERT INTO cpcNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Irootaki inintakaakinari Pinkathari naaka, ari onkantya iiro imanintawaitaitantana”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Okanta, awisanaki 6 kashiri, jotyaantairi Pawa maninkari Gabriel nampitsi iitachari Nazaret saikatsiri Galilea-ki, ");
INSERT INTO cpcNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","iñiiro mainawo kaari ñiirini shirampari, iitachari María, tima irootaki iinantyaari iitachari José, icharinini David. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ikanta ityaapaaki maninkari osaikira María, ikantapaakiro: “¡María! Niwithatzimi. Itsipataimi iiroka Awinkathariti. Panaakoyitakiro pashini tsinaniyitatsiri inishironkapirotaimi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Okanta oñaawakiri maninkari, iyokitzi okanta okimiri ikantapaakirori jiwithatapaakawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ipoña ikantziro maninkari: “María, iiro pithaawi, tima inishironkataimi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ari piñaakiro pimotziti, intzimi piintsiti. Iri piitiri JESÚS. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Iriitaki matironi iñaapirotya, jiiyiitiri Itomi Jinokijatzi. Tima Pawa Awinkathariti, iriitaki pinkatharitakairini ikimitaakiri pairani icharinini David ipinkatharitakaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Irijatzi pinkathariwintairini ikaatzi ichariniyitari Jacob-ni, ari inkantaitatyaani impinkathariwintantai irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ari osampitanakiri María, okantziri: “¿Tsikama onkini nomotziti, tii noñiiri shirampari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jakanakiro maninkari, ikantziro: “Iriira kantakaiyaawoni Tasorintsinkantsi. Tima ipamankantakimiro ishintsinka Jinokijatzi, ojyapaatyaawomi opamankantzi aamparyaantsi. Irootaki jiitantyaari powaiyani Tasorintsi Itomi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ari okimitsitakari iijatzi pirintothori Elisabet, jiiwiitari maanirothaki, okantawitaka antawopirowitaka iroori, motzitai. Tzimakotaki 6 kashiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tima tikaatsi kompitzimotyaarini Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Opoña okantanaki María: “Naakataki jompiratani Pinkathari, jantinawo okaatzi pikantakinari”. Irojatzi ipiyantanakari maninkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Opoña pashini kitiijyiri, shintsiini iyaatanaki María, jataki tonkaariki Judea-ki osaiki nampitsi, ");
INSERT INTO cpcNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","irojatzi ariitantakari ipankoki Zacarías, iwithatapaakawo Elisabet. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Okanta okimawakiro Elisabet iwithatapaakawo María, ijyiwatanaka omotzitakiri. Tima ikantakaanakityaawo Elisabet Tasorintsinkantsi, ");
INSERT INTO cpcNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","oñaawaitanaki shintsiini iroori, okantanaki: “Iirokataki anairori pashini tsinaniyitatsiri itasonkawintaimi. Ari inkimityaari iijatzi powaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Oitama pipokashitantanari inaanatityaari Nowinkathariti? ");
INSERT INTO cpcNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Tima nokimawakimi piwithatapaakina, ijyiwatanaka nomotzitakiri naaka, ikimoshiritanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kimoshiri pinkantaiya iijatzi iiroka pikimisantaki, tima aritaki imonkaataiya okaatzi ikowakaakimiri Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Opoña okantanaki María: Antawoiti nowishiryaawintaiyaari Nowinkathariti, ");
INSERT INTO cpcNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kimoshiri nonkantawintaiyaari Pawa tsika itzimi owawisaakoshiritainani. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Tima iñaakiro jompiratani ashironkaawaitaka, Aripaiti inkantayiitai: Antawoiti itasonkawintaitakiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Tima antawoiti jantzimotakinari matzirori otzimi ishintsinka. ¡Tasorintsi inatzi iwairo! ");
INSERT INTO cpcNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ari inkantaitatyiiyaani inishironkayitairi inkaati inchariniyitaiyaari paata, Tsikarika inkaati pinkathayitairini. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iro ishintsinka imatantayitakari. Japirotsitairi ikinkishiriwitari jantirimi kantakaapirowaitachari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ikaatzi pinkathariwitachari, ikantakaantakiro Pawa iiro jiyaatakaantawo impinkathariti, Iri jiñaapirotakaiya ikaatzi tsinampashiryaawitachari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jajyaagantakaayitaari ikaatzi tajyaaniintawitachari, Iriima ikaatzi ajyaagantawitachari jaapithayitairi tzimimowitariri jomishitowakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Inishironkatairi Israel-mirinkaiti, tima jompiratani jinayitaki. Tii ipiyakotziri inishironkayitziri, ");
INSERT INTO cpcNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Tima iro ikantayiitakiriri pairani achariniyitakari, Jitakari Abraham-ni irojatzi inkaati inchariniyitaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ari osaikimowaitapaintziro María jiroka Elisabet ikaatzi mawa kashiri, irojatzi opiyantaari opankoki iroori. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ikanta imonkaataka ontzimaanitantyaari Elisabet, tzimaki otomi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ari ipokaiyakini ojyininkapaini ikimoshiriwintaiyironi, tima jiyotaiyakini antawoiti inishironkatakiro Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Aritaki maakotapaaki 8 kitiijyiri iintsi, jagaitanakiri intomishinataanitiri, ari ikowawitaka jiitaitirimi Zacarías, tima iwairo inatzi iwaapati. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Irojatzi okantantanakari inaanati: “Iiro jiita Zacarías, jiitya Juan”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ari ikantaitanakiro: “¿Iitaka? Tima tikaatsi pijyininka iitachani Juan”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ipoña jookotaitakiri iwaapati josampiitziri, tsika inintzi jiitiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jookotaki Zacarías inchakota jamaitiniri, ari josankinatakiri, okantzi: “Juan jiitya”. Iyokitzi ikantanaka jaminanakiri ikaatzi osampitakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jomapokashitanaa iñaawaitanai Zacarías. Antawoiti ipinkathatanakiri Pawa, ipaasoonkitanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pagaanka ikantaiyanakani ijyininkapaini Zacarías. Tima ithonka ikimakoitakiro tonkaariki Judea-ki okaatzi awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pampithashiri ikantaiyanakani ikaatzi kimakowintakiriri, ikantaiyini: “¿Tsikama jiityaaka paata jirika? Tima kimpoyaawinta jowanakiri Awinkathariti jirika iintsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ikanta Zacarías, ashitakariri iintsi, ikantakaanakari Tasorintsinkantsi, ikamantantanaki, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Kamiitha jinaki Awinkathariti Pawa, Iwawanitari Israel-mirinkaiti, Ipokaki impinakowintayitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jotyaantakairi matzirori jowawisaakoshiritantzi, Iriitaki icharinitakari David-ni, jompiratani. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Iro iñaawaitakaakiriri pairani tasorintsitatsiri Kamantantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Iri owawisaakoyitaini itzimawita kisaniintawitairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tima inishironkatairi ikaatzi achariniyitakari, Iiro imaijantairo tasorintsitatsiri ikajyaakaawakaakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Irootaki jiroka ikajyaakaakiriri pairani acharinini Abraham, Onkaati jantzimotairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Jookakaawintai itzimawita kisaniintayitairi, Tikaatsi anthaawantaiya ankimisantairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kitishiri ankantayitaiya. Kamiithashiri ankantawintaiyaari kitiijyiriki. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Irooma iiroka notomi, jiiyiitimi iyamantaniriti Jinokijatzi. Tima iirokataki iiwatirini Pinkathari, piwitsikaantiri tsika inkinayitanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Iiroka kamantairini ajyininkapaini, iro jiyotantyaari iriitaki owawisaakotantaniri. Iri piyaakotairini ikaaripiroshiriwaiwitaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tima antawoiti okantaka inishironkatai Pawa, Jotyaantakairi poñaachari inkitiki ikimitakotapaakawo okantaranki owakiraa okitiijyitamanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ikitainkatakotairi ikaatzi saikayitatsiri otsinirikitzi. Ikitainkatakotairi otsimankakowitari jaamparyaa ashitawori sarinkawini. Iri oñaagantaironi tsika ikantaita isaikaitzi kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kamiitha ikimotatzi iintsi, ñaapiroshiri ikanta. Ari inintziro isaikawaitzi otzishimashiki, irojatzi imonkaatantakari joñaagaiyaari Israel-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ikanta Pinkathari César Augusto, ikantakaantaki josankinatakotya maawoni atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aripaiti omapokaka josankinatakoitya ijiwatantari Cirenio janta Siria-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","maawoni atziri jiyaataiyakini josankinatakotya inampiki tsika ipoñaayita pairani icharinini. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Irojatzi itonkaantanakari José irirori, ipoñaanaka Nazaret saikatsiri janta Galilea, jiyaatiro nampitsiki tsika itzimaki pairani Pinkathari David, oita Belén saikatsiri janta Judea-ki. Tima jirika José icharini jinatzi David-ni. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ari josankinatakotyaari irirori intsipatyaawo iinathori María, tsika otzimi ikajyaakari jayiro. Aritzimaitaka motzitaki iroori. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ikanta jariitaiyakani Belén-ki, irootaintsi ontzimaaniti María. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ari itzimakiri itanakawori otomi. Oponatakiri, omaryaakiri jowamintoki piratsi, tima tii oñaapaaki tsika omaapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Okanta jantyaatsikiini nampitsi, tzimatsi kakiwintziriri tsiniripaiti joijyati jaamaakowintari. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ari joñaagakari imaninkariti Awinkathariti. Okitiijyiinkatakotapaakiri jowaniinkawo Awinkathariti, antawoiti ithaawaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Iñaanatapaakiri, ikantziri: “Iiro pithaawashiwaita. Tima namatziimi Kamiithari Ñaantsi, iro oimoshirinkairini atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tzimataiki iroñaaka owawisaakotantaniri inampiki pairani pinkathari David-ni, iriitaki Cristo Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Jiroka piyotantyaariri: Ari piñaakiri imponaitiri iinchaaniki jomaryaitakiri jowamintoki piratsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iñaitatzi ikoñaatapaaki ojyiki inkitiwiri itsipatapaakari maninkari, ipampithaawintapaakiri Pawa, ikantaiyini: ");
INSERT INTO cpcNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Iro kamiithapirotatsiri otzimimotziri jowaniinkawo Pawa nampitawori ojinokipirotzi inkiti! ¡Isaikayitai kamiitha inishironkataniiti kipatsiki! ");
INSERT INTO cpcNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ikanta ipiyaiyanaani maninkariiti inkitiki, ikantawakaanaka aamaakowintariri joijyati: “Thami aati Belén-ki, aminakitiro oita awisaintsiri. Ari añiiro ikamantajaantakairi Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Shiyaiyanakani, irojatzi jiñaantapaakawori María otsipatakari José, omaryaakiri iinchaanikiti jowamintoki piratsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ikanta jiñaapaakiri, ikamantantapaakiro okaatzi ikantakiriri inkaanki maninkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyokitzi ikanta jaminaitziri aamaakowintariri oijya ikimaitziri ikinkithawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Irooma María, antawo okinkishiritakotawo okaatzi ikantaitapaakirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ipoña ipiyaiyanaani aamaakowintariri oijya, thaaminta ikanta ipampithaawintanairi Pawa, tima jiñaayitakiro okaatzi ikamantaitakiriri inkaanki. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ari maakotapaaki 8 kitiijyiri iinchaaniki, jagaitanakiri intomishitaaniitiri. Irojatzi jiitaitantakariri JESÚS tima ari jiitsitakari maninkari tikiraamintha omotzitiriita María. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Okanta jimonkaatakiro kitiijyiri jomairintaiyani onkantantyaari inkitiwathayitai, tima iro ikantakaantakiri Moisés-ni. Ari jagaitanakiri Jesús Jerusalén-ki jashitakaiyaari Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Iro jimonkaatantyaawori Osankinarintsipirori ikantakaantziri Awinkathariti, kantatsiri: Iriirika shirampari omapokani tsinani, Jashitakaityaari Pinkathari, itasorintsiti jinatyi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Imatantyaawori jimonkaatiro ikantakaantani Pinkathari, ontzimatyii intainiri Pawa: Apiti konthawo, iirorika apiti iryaani shiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tzimatsi janta Jerusalén-ki shirampari jiita Simeón. Tampatzikashiri jinatzi jirika shirampari, pinkathatasorintsitaniri jinatzi, tima iri inampishiritantakari Tasorintsinkantsi. Iriitaki oyaawintawori inkimoshiritakaitairi Israel-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jiyoshiritakaakiri Simeón Tasorintsinkantsi, iiro ikamita irirori irojatzi jiñaantatyaariri Isaipatziitotani Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ikantakaanakari Tasorintsinkantsi, pokaki tasorintsipankoki. Ipoña ashitariri Jesús jaanakiri tasorintsipankoki jimonkaatantyaawori ikantakaantaitani, ");
INSERT INTO cpcNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ithomaawakiri Simeón jirika iinchaaniki, ipaasoonkitanakiri Pawa, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Monkaatapaaka Pinkathari okaatzi pishinitakinari, Pishinitaina iroñaaka nonkami, tima pompiratani powakina. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tima noñaakiri owawisaakotantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iriitaki potyaantakiri owawisaakotairini atziripaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Iri kitainkatakoyitairini atziri kaari ajyininkata. Iri kantakaiyaawoni impinkathaitantyaariri Israel-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iyokitzi ikanta ashitariri, ikimakowintziri jiñaantsikowintaitziri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ikanta Simeón itasonkawintakiri, ikantanakiro inaanati Jesús: “Jirika iinchaaniki iri kantakaiyaawoni jaminaashiwaitantaiyaari ojyiki ajyininka Israel-mirinkaiti, kimiwaitaka imparyaatyiimi. Iri kantakaiyaawoni iijatzi jawisakoshiritantaiyaari ojyiki, kimiwaitaka intzinagaatyiimi iparyaawitaka. Tima ojyiki inkantaiti: ‘Kaari iroopirori ñaantsi iñaaniyitakari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tima jirika iinchaaniki iri oñaagantironi okaatzi inkinkishiritaityaari. (Iro kantzimaitacha antawoiti powashiritanatya iiroka kimiwaitakimi jowathagaitatyiimi.)” ");
INSERT INTO cpcNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ari osaiki iijatzi tsinani iitachari Ana, kamantantaniro inatzi iroori, irishinto Fanuel icharinitanakari Aser. Antawokipirotaki iroori. Aitsiwitaka oimi owakiraa omainawotapaaki, 7 osarintsi otsipawitakari oimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ikamakira oimi, tzimakotaki okaatzi 84 osarintsiti. Ari ashi owatziiro osaiki tasorintsipankoki, aakowintawo kitiijyiri iijatzi tsiniripaiti amana, otziwintakawo iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ari opokapaakiri jiroka tsinani, opaasoonkitapaakiri Pawa. Opoña okinkithatakotanakiri iinchaaniki, irojatzi ikimantaiyakarini ikaatzi oyaawintawori impinakowintaitiri Jerusalén-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Aritaki jimonkaatakiro okaatzi ikantakaantziri Pinkathari, piyaa Galilea-ki osaikira inampi Nazaret. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Thaaminta ikanta ikimotatzi iinchaaniki, iikiro jiyaatatzi ishintsitzi, yotaniri ikanta. Aamaakowinta jowakiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ari ikantapiintatya osarintsiki ashitariri Jesús jiyaatzi Jerusalén-ki joimoshirinkiro Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ikanta Jesús aritaki tzimakotaki 12 josarintsiti, jataiyakini Jerusalén-ki tima iro jamitapiintari joimoshirintya. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aritaki kaataki joimoshirinkaiyani, piyaiyaani ashitariri, irojatzi isaikanaki Jesús Jerusalén-ki, tii jiyotzi ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Iñaajaantaki iiwataki Jesús itsipatanaari ikaataiyini. Aniitaki apaani kitiijyiri, ari ikowawitaari, josampiwitakari ijyininkapaini ikaatzi jiyaataiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Tii jiñiiri, ipiyaa Jerusalén-ki jaminaminatakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mawa kitiijyiri jiñaantaariri isaiki tasorintsipankoki, ikinkithawaitakaayitziri yotakotzirori Ikantakaantaitani, josatikaitakiri niyanki, josampiminthatziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyokitzi ikanta jaminaitziri jiñaitakiri imapiro jiyotanitzi, jakayitakiro kamiitha okaatzi josampitakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ikanta jiñaapairi ashitariri, iyokitzi jaminapaakiri, okantapaakiri inaanati: “Notomí, ¿tsikama pinkantinaka? Ojyiki naminaminatakimi notsipatari piwaapati, antawoiti pominthaawaniintakina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ipoña jakanaki irirori, ikantanaki: “¿Iitama paminaminatantanari? ¿Tiima piyotzi iro kowapirotachari nantiniri ikowakaanari Ashitanari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Iro kantacha tii ikimathatziro ashitariri okaatzi ikantakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jaanairi, jataiyaini Nazaret-ki. Jantziro maawoni okaatzi jompiratariri iwaapati. Iro kantacha pampithashiri owakotakiri inaanati. ");
INSERT INTO cpcNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iikiro ithaamintatya Jesús ikimotatzi, yotani ikanta. Kimpoyaawinta jowiri Pawa. Ari ikimitsitari iijatzi atziripaini inishironkatani jowiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Aritaki monkaataka 15 osarintsi ipinkathariwintantzi Tiberio César. Ari ijiwatziri Poncio Pilato janta Judea-ki. Iriima Herodes ijiwatzi Galilea-ki. Iriima Felipe iririntzi Herodes, ijiwatzi Iturea-ki iijatzi Traconite-ki. Ipoña Lisanias, ijiwatzi Abilinia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Iriima Anás itsipatakari Caifás ijiwatziri Ompiratasorintsitaari. Aripaiti iñaanashiritakiri Pawa itomi Zacarías iitachari Juan janta otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Irojatzi ikinantanakari Juan intatsikironta Jordán, ikinkithatakotziro owiinkaataantsi, ikantzi: “Powiinkaawintaiyaari Awinkathariti, powajyaantairo pantayitziro kaaripirori, ari impiyakoitaimiro pikaaripiroshiriwaiwitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tima iro josankinatakiri pairani Isaías Kamantantaniri, ikantaki: Ikaimakaimatapaaki otzishimashiki, ikantantaitzi: Powamiithatainiri Pinkathari tsika inkinapaaki, Pinkimitakaantiro jotampatzikaitziro aatsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Onkamiithapathayitai otinkanaayitzi, Owintiniyitai otzishi. Tampatzika onkantayitaiya aatsi okaatzi tzipiwitachari, Mamiripankaa onkantaiya. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ari jiñiiro maawoni atziri tsika ikanta Pawa jowawisaakotantzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ikantayitawakiri atziri pokayitaintsiri jowiinkaatya: “Tii pikamiithashiritaiyini iiroka, pikimitashitakari maanki. ¿Piñaajaantzi iiro jowasankitaitzimi? ");
INSERT INTO cpcNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Imapirorika powajyaantairo tsika pikantawita pairani, pinkamiithashiriyitai, pinkimityaawo pankirintsi kithokitatsiri. Iiro pikantashiriwaitashita: ‘Aña naaka icharinini Abraham, tii okowapirotzi nowajyaantairo nokaaripiroshiriwaitzi’. Pinkimi nonkanti: ‘Iiro pikantakaapirowaita piñaajaanti iiroka ikowapirotani Pawa, aña kantatsi jatziritakairo mapi, iro impoyaataimini incharinitaiyaari Abraham-ni’. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Iirorika pikimitawo pankirintsi kithokitatsiri, ichikakaitawo chacha pankirintsiponkitziki kaari kithokitatsini, ompoña jagaitiro intagaitiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ikanta atziripaini josampitanakiri, ikantziri: “¿Iitama nantairi?” ");
INSERT INTO cpcNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ari jakanakiri, ikantzi: “Tzimatsirika apiti piithaari, pimpiri apaani kaari otzimimotzi. Tzimatsirika powanawo, ari pinkimitaakiro iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ipoña ipokaiyakini kowakotziriri ijyininka kiriiki ikowi jowiinkaatya, ikantapaakiri: “Pinkathari, ¿iitama nantairi naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ikantakiri: “Iiro panaakairo ikantaitakimiri onkaati pikowakotantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ikanta owayiriiti Roma-jatzi, josampitakiri iijatzi, ikantziri: “Naaka, ¿iitama nantairi?” Jakanakiri, ikantzi: “Iiro pasaryiimatanta, iiro pithiiyakotantzi iijatzi onkantya paapithatantyaariri atziri tsikarika oitya. Pinkimoshiriwintiri ikaatzi ipinayiitzimiri iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ojyiki atziri aamaakowintakariri Juan, ikantashiritaiyini: “¿Kaarima jirika Cristo?” ");
INSERT INTO cpcNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ari ikantanakiri Juan maawoni atziri: “Naaka apa nowiinkaatantawo jiñaa. Iro kantzimaitacha, aatsikitaki mapirotzirori ipinkatharintsitzi, nopinkathatsitataikari naaka. Tii onkantaajaiti inkimitakaantina naaka jimpiratani onkantya nonothopaitsitantyaariri i-zapato-ti. Iriitaki kimitakaantironi jowiinkaatantatyiimiri Tasorintsinkantsi, iijatzi paampari. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tima aririka oyiipatiro awankiri, otikakitziro, ompoña atayiro opintakiiriki. Iro aaki okithoki, otikitakiro, owakoyitakiro. Ari inkimitagairi Awinkathariti iijatzi, jinashiyitaiyaari atziri. Inishironkayitairi inkaati kimisantanairini, iriima kaari owajyaantironi ikaaripiroshiriwaitzi, intagairi paampariki kaari tsiwakanitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ojyiki ikaminaantaki Juan ikinkithatakotziniri atziripaini Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ari ikimitaakiri iijatzi Herodes pinkatharitatsiri, ikisawitakari, jaakiro Herodías iinawitari Felipe iririntzi. Tima tzimatsi iijatzi ojyiki pashini kaaripirori jantayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Iro owatsipirotakirori jantakiri Herodes jomontyaakaantakiri Juan. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ikanta jowiinkaayitziri Juan ojyiki atziri, ari jowiinkaatakari Jesús irirori. Jamanaminthaita Jesús, kimiwaitaka ashitaryaanakityaami inkiti, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iñaitatzi ipokashitakiri Tasorintsinkantsi ikinapaaki jinoki ikimitapaakari shiro. Ikimaitatzi inkitiki ikantaitanaki: “Iirokataki Notomi nitakopirotani. Owanaa nokimoshiriwintakimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jitantanakawori Jesús jantayitakiri, ari tzimaki 30 josarintsiti. Ikantayiitziri iri tomintakariri José. Tomintanakariri José jiita Elí, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","tomintanakariri Elí jiita Matat, tomintanakariri Matat jiita Leví, tomintanakariri Leví jiita Melqui, tomintanakariri Melqui jiita Jana, tomintanakariri Jana jiita José, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","tomintanakariri José jiita Matatías, tomintanakariri Matatías jiita Amós, tomintanakariri Amós jiita Nahum, tomintanakariri Nahum jiita Esli, tomintanakariri Esli jiita Nagai, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","tomintanakariri Nagai jiita Maat, tomintanakariri Maat jiita Matatías, tomintanakariri Matatías jiita Semei, tomintanakariri Semei jiita José, tomintanakariri José jiita Judá, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","tomintanakariri Judá jiita Joana, tomintanakariri Joana jiita Resa, tomintanakariri Resa jiita Zorobabel, tomintanakariri Zorobabel jiita Salatiel, tomintanakariri Salatiel jiita Neri, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","tomintanakariri Neri jiita Melqui, tomintanakariri Melqui jiita Adi, tomintanakariri Adi jiita Cosam, tomintanakariri Cosam jiita Elmodam, tomintanakariri Elmodam jiita Er, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","tomintanakariri Er jiita Josué, tomintanakariri Josué jiita Eliezer, tomintanakariri Eliezer jiita Jorim, tomintanakariri Jorim jiita Matat, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","tomintanakariri Matat jiita Leví, tomintanakariri Leví jiita Simeón, tomintanakariri Simeón jiita Judá, tomintanakariri Judá jiita José, tomintanakariri José jiita Jonán, tomintanakariri Jonán jiita Eliaquim, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","tomintanakariri Eliaquim jiita Melea, tomintanakariri Melea jiita Mainán, tomintanakariri Mainán jiita Matata, tomintanakariri Matata jiita Natán, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","tomintanakariri Natán jiita David, tomintanakariri David jiita Isaí, tomintanakariri Isaí jiita Obed, tomintanakariri Obed jiita Booz, tomintanakariri Booz jiita Salmón, tomintanakariri Salmón jiita Naasón, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","tomintanakariri Naasón jiita Aminadab, tomintanakariri Aminadab jiita Aram, tomintanakariri Aram jiita Esrom, tomintanakariri Esrom jiita Fares, tomintanakariri Fares jiita Judá, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","tomintanakariri Judá jiita Jacob, tomintanakariri Jacob jiita Isaac, tomintanakariri Isaac jiita Abraham, tomintanakariri Abraham jiita Taré, tomintanakariri Taré jiita Nacor, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","tomintanakariri Nacor jiita Serug, tomintanakariri Serug jiita Ragau, tomintanakariri Ragau jiita Peleg, tomintanakariri Peleg jiita Heber, tomintanakariri Heber jiita Sala, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","tomintanakariri Sala jiita Cainán, tomintanakariri Cainán jiita Arfaxad, tomintanakariri Arfaxad jiita Sem, tomintanakariri Sem jiita Noé, tomintanakariri Noé jiita Lamec, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","tomintanakariri Lamec jiita Matusalén, tomintanakariri Matusalén jiita Enoc, tomintanakariri Enoc jiita Jared, tomintanakariri Jared jiita Mahalaleel, tomintanakariri Mahalaleel jiita Cainán, ");
INSERT INTO cpcNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","tomintanakariri Cainán jiita Enós, tomintanakariri Enós jiita Set, tomintanakariri Set jiita Adán, tomintanakariri Adán iriitaki Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ikanta ipiyaa Jesús ipoñagaawo Jordán, isaikashiritantakari Tasorintsinkantsi. Ikantakaanakari Tasorintsinkantsi, jataki otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ari isaikakiri okaatzi 40 kitiijyiri, irojatzi ikowawitantakari kamaari inkaaripiroshiritakairimi. Tima tikaatsi jowaiya janta, owamaimatakiri itajyi. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pokaki kamaari, ikantawitapaakari: “Imapirotatyaarika Itomintzimi Pawa, pimpiyiro tanta jiroka mapi, poyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ari jakanakiri Jesús, ikantanakiri: “Tzimatsi osankinarintsi kantatsiri: Tii apaniro okowityiimotari atziri joyaawo tanta, iro kowapirotajaantachari ankimisantairo maawoni ikantairi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ipoña kamaari jaanakiri Jesús tonkaariki otzishiki, jookotakiniri okoñaatapaintzi maawoni nampitsi ipinkathariyitzi atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ikantziri: “Ari nonkantakaatyaawo impinkathayitaimi maawoni piñaayitakiri, ari nompakimiro iijatzi jowaniinkawo. Tima irootaki jashitakaitakinari naaka maawoni, ari onkantaki nompiri itzimirika nokowiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aririka potziirowashitakina pimpinkathatina, maawoni okaatzi piñaakiri, iirokara ashitanaiyaarini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ari jakanakiri Jesús, ikantziri: “Tzimatsi osankinarintsi, kantatsiri: Ampinkathatiri Awinkathariti Pawa, iri ankimisanti apaniroini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ipoña kamaari jaanakiri nampitsiki Jerusalén, isaikakaakiri jinoki otawantoki tasorintsipanko, ikantapairi: “Imapirorika Itomintzimi Pawa, pimitai isaawikinta. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tima tzimatsi osankinarintsi, kantatsiri: Jotyaantimiri Pawa imaninkariti aamaakowintimini, ");
INSERT INTO cpcNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Iri thomaawakimini, Iiro pontajantapaaka mapiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ari jakanakiri Jesús, ikantziri: “Aritaki ikantaitaki pairani: Tii okamiithatzi piñaantashiwaityaari Piwinkathariti Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ikanta kamaari tii ikitsirinkashitari Jesús inkaaripiroshiritakairi, jintainaryaapaintari. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ikanta ipiyaa Jesús Galilea-ki, otyaantanakari ishintsinka Tasorintsinkantsi. Othonka ikimakoitanakiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jiyotaantayitaki maawoni tsika japatotapiintaita. Thaaminta ikantawintaitari maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ikanta Jesús piyaa inampiki Nazaret tsika jantaritaki. Okanta kitiijyiri jimakoryaantaitari, jataki Jesús japatotapiintaita, tima iro jamitapiintakari irirori. Ari ikatziyanakari iñaanatiro osankinarintsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ipayiitakiri josankinari Kamantantaniri Isaías-ni. Ikanta japinairyaakiro osankinarintsi, iñaatziiro josankinaitakiro, kantatsiri: ");
INSERT INTO cpcNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Isaikantana naaka Itasorinka Awinkathariti, Tima iri saipatziitotakinari okantantari nokinkithatakotainiri ashironkainkari Kamiithari Ñaantsi. Irijatzi otyaantakinari nowawisaakoyitairi okantzimoniintashiriwaitari. Nonkamantayitairi jaakaantaitziri tsika inkantaiya jookakaawintaitziri. Impoña naminakaayitairi kaari aminatsiri, Nosaikakaashiwaitaiyaari ikaatzi jompirayiitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nokinkithatakoyitairo tsikapaiti jaapatziyantai Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ipoña japinaitanairo Jesús osankinarintsi, ipanairi kinkithatakaantapiintatsiri, saikanaki. Iyokitzi ikanta jaminanaki maawoni atziri ikaatzi saikaintsiri japatotapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ari jitanakawo ikantanakiri: “Imonkaatzimoyitakimi iroñaaka jiroka osankinarintsi okaatzi pikimakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyokitzi ikanta jaminaitanakiri Jesús, tima kamiitha okanta ikinkithatakoyitziri. Ojyiki kinkithatakoyitanakiriri kamiithaini. Ikantayiitzi iijatzi: “¿Kaarima jirika itomi José?” ");
INSERT INTO cpcNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Irojatzi ikantantanakariri: “Kimitaka ari pinkantakina: ‘Incha aawintantzinkari paawintya iiroka. Tima ojyiki nokimakowintakimi pantayitakiri Capernaum, incha pantapairo iijatzi pinampiki’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iikiro ikantanakitzi Jesús: “Imapirotatya nonkantimiri, ‘jashi jowatziiro kamantantaniri tii ipinkathaitziri inampiki tsika isaikayitzi ijyininka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tima imapirotya jiroka, pairani iinta isaikawitani Elías, tii omparyaagairanki inkani Israel-ki anaaniintanakiro mawa osarintsi, antawoiti itajyaaniintaitaki. Ojyiki kamatsiri oimi tzimawitachari janta, ");
INSERT INTO cpcNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","iro kantzimaitacha, tii jotyaantaitziri Elías-ni jiyaatashitiro kamatsiri oimi, apa jotyaantaitakiri nampitsiki Sarepta saikatsiri Sidón-ki, osaikiranki tsinani kamatsiri oimi kaari ijyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ari okimitakari iijatzi iinta isaikawita Kamantantaniri Eliseo, tzimawitacharanki Israel-ki ojyiki mantsiyari pathaawaitatsiri. Iro kantzimaitacha tii jotyaantaitziri Eliseo joshinchagai apaani, apa jotyaantaitakiri isaiki Naamán kaari ijyininkata poñaachari nampitsiki Siria, joshinchagairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ikanta ikimaiyakini ikaatzi saikaintsiri japatotapiintaita, antawoiti ikisaiyanakani. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ikatziyaiyanakani, jagaitanakiri Jesús iwiyaathapita nampitsi, ikinakagaitanakiri tsika osaiki impiita jotziryaitirimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Iro kantzimaitacha Jesús, ishiyapithatanakari josatikantanakari niyankiniki, jatai. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ikanta Jesús oirinkanaa nampitsiki Capernaum saikatsiri Galilea. Jiyotaantayitapai kitiijyiriki jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Tima tii omaanta ishintsinka jiyotaantzi, iyokitzi ikanta atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Okanta janta tsika japatotapiintaita, ari isaikakiri atziri piyashiritatsiri, kaimanaki shintsiini irirori, ");
INSERT INTO cpcNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ikantzi: “Piñaashitina Jesús Nazaret-jatzi, niyotzimi naaka iirokataki itasorintsiti Pawa. Iro pipokantari jaka papirotaiyinani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ikisanakiri Jesús, ikantanakiri: “¡Pimairiti piyari, piyaatai! Tyaanaki atziri jintainaryaanakari iwiyariti, tii jomantsiyiimaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyokitzi ikantaiyanakani, ikantawakaiyani: “¿Iitatyaakama jirika? Joitsinampairi jomishiyiri piyari jiñaashinchiinkatakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ari ithonka ikimakoyiitanakiri Jesús maawoni nampitsiki okaatzi saikatsiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ipoña ishitowanaki Jesús japatotapiintaita, tyaapaaki ipankoki Simón. Okanta iroori riyoti Simón, imatakiro antawoiti saawakitaantsi. Ikowakoitakiri Jesús joshinchaapairo. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Joiyotashitanakawo omaryaaka, kimiwaitaka iñaashinchiinkatatyiiromi saawakitaantsi. Kaatakotanaki osaawawita, piriintanaka aminayitawakiniri oitarika ompawakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Okanta otsiniriityaanaki, jamaitapaakiniri Jesús ojyiki atziri kantashiwaiyitachari imantsiyari. Ikanta iñaawakiri Jesús, apa jotirotantawakari kapichiini jako, shintsiyitanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ojyiki jomishitowitakiri iijatzi iwiyariti, antawoiti ikaimayitzi piyari, ikantzi: “¡Itomi Pawa pinatzi!” Iro kantzimaitacha Jesús, ikisayitakiri piyari, tii ishinitziri iñaawaiti, tima jiyotzi irirori piyari iriitaki Cristo. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Okanta okitiijyitamanai, ananinkanaki Jesús apaniroini ikinanaki otzishimashiki. Ojyiki aminaminatairiri tsikarika ikinaki. Ikanta jiñiitairi tsika isaiki, tii ishiniitziri jiyaatai. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Irojatzi ikantantanakari Jesús: “Ontzimatyii inkimaitiro iijatzi pashiniki nampitsi Kamiithari Ñaantsi kinkithatakotziriri ipinkathariwintantai Pawa. Tima irootaki nopokantakari naaka jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iikiro jiyaatakaanakitziiro Jesús ikinkithatanaki pankotsiitiki japatotapiintaita okaatzi saikatsiri Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Okanta kitiijyiri, isaiki Jesús inkaarithapiyaaki Genesaret. Jawitsinaimatakiri atziri ikaatzi piyowintakariri ikimisantziro iñaani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ari jiñaaki Jesús apiti pitotsi opiryaatakotaki opaayaaki. Tikaatsi otitantyaawoni, tima ikiwaiyatziironi ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Otitapaaka Jesús pitotsiki. Tima iri ashitawori Simón jiroka pitotsi, ikantakiri jotyaantiro kapichiini niyanki. Ari isaikantanakawo Jesús pitotsi, jitanaawo jiyotaayitanairi atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ikanta ithonkanakiro jiyotaantzi, ikantzi: “Simón, paanakiro pipito niyanki inkaari, ari pishiryaatiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ari jakanaki Simón, ikantzi: “Ari noshiryaawitaka tsiniripaiti, tikaatsi nayiri. Iiroka kantanari, aritaki nimatakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jimatakiro ishiryaatzi, jaaki ojyiki shima, irootaki onthatyiimatimi ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ikaimawakotairi itsipatapiintari ishiryaatapiintzi jimitakotiri. Ikanta jiyaatashitanakiri, ikinakotaiyakini pashiniki pitotsi, ijaikitakiro apitiroiti, iroowitainchami intsitsiyakotaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ikanta jiñaakiro Simón Pedro awisaintsiri, jotziirowashitanakari Jesús, ikantanakiri: “Pintainkapithatina pinkatharí, kaaripiroshiriri ninatzi naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tima antawoiti ithaawanaki Simón jiñaaki jaaki ojyiki shima. Ari ikimitakari iijatzi maawoni itsipataiyarini. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jimatsitanakawo Jacobo iijatzi Juan, itomipaini Zebedeo, tima iri itsipatakari Simón. Iro kantzimaitacha Jesús ikantanakiri Simón: “Iiro pithaawashiwaita, onkimitaiyaawo iroñaaka iriimi atziri noshiryaatakagaimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ikanta jaatakotaiyapaani, jookawintanakiro maawoni, joyaataiyanakirini Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Okanta pashini kitiijyiri jariitaka Jesús nampitsiki, ari ipokakiri imatziri pathaawontsi. Ikanta jiñaapaakiri Jesús, jotziirowashitapaakari, ikantapaakiri: “Pinkatharí, pikowirika, poshinchagaina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ipoña jakotanaki Jesús, jantantakari kapichiini jako, ikantziri: “Nokowi, pishintsitai”. Ishitakotanaki ipathaawita. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ari ikantziri: “Tii nokowi pinkinkithatakotina. Apatziro powanakiro piyaatashitiri Ompiratasorintsitaari, pimonkaatiro josankinatakiri Moisés-ni, paanaki pinkitiwathatantaiyaari, onkantya jiyotantaityaari shintsitaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iro kantzimaitacha ikimakoyiitanakiri intaina Jesús. Ojyiki atziri piyowintakariri ikimisantziri. Ikowaiyini joshinchaayitainiri iijatzi imantsiyaritipaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Iro kantacha Jesús joshitaapiintaka irirori otzishimashiki, ari jamanari. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Okanta pashini kitiijyiri jiyotaantzi Jesús, ari isaikaiyakini Fariseo itsipayitakari Yotzinkariiti, poñaayitachari nampitsiki Galilea, Judea, iijatzi Jerusalén-ki. Tima otyaantakari Jesús ishintsinka Awinkathariti, kantatsi joshinchaayitiri mantsiyari. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ipoña jariitaiyapaakani atziri jinatakotakiri shitashintsiki apaani kisopookiri. Ikowawitaiyakani intyaakaapaakirimi pankotsiki, jomaryaakotirimi isaikaki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tii okantatzi intyaakairi, tima ojyiki atziri piyotaincha. Jatiitakaanakiri jinoki pankotsiki, jimoontakiro pankotsi, jowayiitakotakiri mantsiyari josatikantanakari piyowintakariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ikanta Jesús jiyotakoshiritawakiri ojyiki jawintaakari, jiñaanatawakiri mantsiyari, ikantziri: “Ajyininká, ipiyakoitaimiro pikaaripiroshiriwitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ikanta ikimawaki Yotzinkariiti itsipayitakari Fariseo, ikantashiritaiyanakini: “Ithainkatziiri Pawa jirikawí. Tima tikaatsi kantironi impiyakotantiro kaaripirori, apaniroini ikantakaawo Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iro kantzimaitacha Jesús jiyoshiritakotakiri, ari josampitziri: “¿Iitama pikinkishiriwaitashitantari? ");
INSERT INTO cpcNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Tiima okamiithatzi nonkanti: ‘Ipiyaakoitaimiro pikaaripiroshiriwitaka?’ Irooma pikowiri nonkantiri: ‘Pinkatziyi, piyaatai’. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Iroñaaka piyotiri Itomi Atziri otzimimotziri ishintsinka, ari impiyakotairi kaaripiroshiriwitachari”. Ipithokashitanakari mantsiyari, ikantziri: “Pinkatziyi, paanairo pishitashi, piyaatai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Piriintanaka kisopookiri, jaanairo ishitashi jomaryaantawitari. Iñaitawairi jiyaatai ipankoki, kimoshiri ikantawintanakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","maawoni atziripaini iyokitzi ikantaiyanakani, ikimoshiriwintanakiri iriroriiti Pawa. Ithaawankakiini ikantaiyini: “Tii añaapiintziro kimityaawoni jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ikanta ishitowanai Jesús, jiñaapaakiri iitachari Leví isaiki irirori ikowakotziri kiriiki ijyininka, ikantapaakiri: “Poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Katziyanaka Leví, jookanakiro maawoni, joyaatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ipoñaashitaka Leví, jaanakiri Jesús joimoshirintya ipankoki itsipataanakari jiyotaani. Ari jiyaatsitakari iijatzi ojyiki kowakotziriri kiriiki ijyininka, ojyiki jatayitaintsiri pashini. Ari ikaataiyakini jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ikanta Fariseo itsipatakari Yotzinkariiti, jiñaanaminthatakiri jiyotaani Jesús, ikantziri: “¿Iitama pitsipatantariri powaiyani kaaripiroshiriri, kowakotziriri kiriiki ijyininka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ipoña jakanaki Jesús irirori, ikantanakiri: “Aririka imantsiyati atziri, ipokashitziri aawintantzinkari, iriima atziri kaari mantsiyatatsi tikaatsi inkowi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tii apa nompokashitiri kamiithashiriri naaka nonkaimashiriyitairi, aña nopokashitatziiri kaaripiroshiriri nonkaimashiritairi jowajyaantairo kaaripirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ipoña josampiitakiri Jesús, ikantaitziri: “¿Iitama kaari itziwintanta piyotaani? Iriima jashi Juan, ipoña jashi Fariseo-paini, owanaa itziwintapiintaiyani irirori, jamanaiyani iijatzi. Noñiiri piyotaani iiroka, tii itziwintanita, owawaiyitacha, irawaitatsi imiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ari jakanaki Jesús, ikantzi: “Aririka intsipataityaari aawakaachari, ¿arima jowashiriniintaitatya? ");
INSERT INTO cpcNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Aryaajaini paata, aririka jagaitakiri iimintaitari, aripaiti intziwintaitya”. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ipoña jojyakaawintanakiniri Jesús, ikantziri: “Apaani paijatori ikithaataitari, aririkami jowapatankaitantyaawo osapi owakiraari, ari imapirotanatya osagaanaki aririka amithatanatya owakiraari. Tii okamiithapirotakairo paijatori ikithaataitari jowapatankaitantyaawomi owakiraari. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tii inkamiithati iijatzi paijatori mishinantsinaki jowantayiityaawo iiryaatatsiri imiritaitari. Aririka jowantayiitatyaawo, ari isanaryaanaki, apaawaitashitanatya imiritaitari, iijatzi inkimitatya mishinantsinaki irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Iri kamiithatatsi owakiraari mishinantsinaki jowantayiityaawo iiryaari imiriitari. Iro iiro japaawaitanta apitiroiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ikaatzi amitawori imiritawo poitatsiri, iiro jamitaawo imiritaiyaawo iiryaari. Inkantapiinti: ‘Iro kamiithatatsi amirityaawo poiri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Okanta kitiijyiri jimakoryaantaitari, ikinaki Jesús pankirintsimashiki. Ikanta jiyotaanipaini joyiikitanaki okithoki, jamirokakitakiro onkini joyaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tii inimotziri Fariseo-paini, josampitakiri ikantziri: “¿Iitama poyiikitantawori? ¿Tiima piyotzi tii oshinitaantsitzi kitiijyiriki jimakoryaantaitari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ari jakanaki Jesús, ikantanaki: “¿Tiima piñaanatakotziri iiroka ikanta pairani David-ni itsipayitakari ikaataiyini owamaimawitantakariri itajyi? ");
INSERT INTO cpcNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ityaaki tasorintsipankoki, jaakiro tasorintsitanta, jowakawo irirori, ipayitakiri iijatzi ikaatzi itsipayitakari. Tima tii oshinitaantsiwita jowaityaawo, apa jowapiintayitawo Ompiratasorintsitaari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ipoña ikantaki iijatzi: “Jirika Itomi Atziri ipinkatharipirotzi irirori, janairo jiroka kitiijyiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Okanta pashini kitiijyiri jimakoryaantaitari, ityaaki Jesús japatotapiintaita, jiyotaantapai iijatzi. Ari isaikakiri atziri kisowakotatsiri jakopiroriki. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ikanta Yotzinkariiti itsipayitakari Fariseo, aamaani jowakiri Jesús jiñiiri aririka joshinchagairi mantsiyari kitiijyiriki jimakoryaantaitari, onkantantyaari inkantakotiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Iro kantzimaitacha Jesús, jiyotaki irirori iita ikinkishiriyitakari. Ikaimakiri atziri kisowakori, ikantziri: “Pimpoki, posatitya niyanki”. Pokapaaki kisowakori, ikatziyapaaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ipoña ikantzi Jesús: “Tzimatsi nosampitaiyimini: ¿Otzimikama shinitaantsitatsiri antiri kitiijyiri jimakoryaantaitari? ¿Tiima okantzi anishironkatanti, irooma kamiithatatsi owamaanti? ¿Iiroma okantzi antiro kamiithari, irooma kamiithatatsi ankaaripirowaiti?” ");
INSERT INTO cpcNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ikimpoyaanakiri piyowintakariri, ipoña jiñaanatanakiri mantsiyari, ikantziri: “Pinthaaryaawakotai”. Matanaka, akotsitanai kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Iro kantzimaitacha jirikapaini, antawoiti ikisaiyanakani. Ikinkithawaitaiyakini tsika inkantiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ipoña itonkaanaki otzishiki jamañaari Pawa. Ari jaakowintakawo maawoni tsiniripaiti jamana. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Okanta okitiijyitamanai, japatotakiri maawoni jiyotaani. Ari jiyoyaaki ikaatzi 12, iriitaki jiiyitakiri Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Jirika ikaatzi jiyoyaakiri: Simón, iri jiitakiri Pedro. Ipoñaapaaka Andrés iririntzi Simón. Ipoñaapaaka Jacobo itsipataakiri Juan, Felipe, Bartolomé, ");
INSERT INTO cpcNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo itomi Alfeo. Ipoñaapaaka Simón jiitaitziri kisakowintantaniri, ");
INSERT INTO cpcNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ipoñaapaaka Judas iririntzi Jacobo. Ipoñaapaaka iijatzi Judas Iscariote, pithokashitaiyaarini paata. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ipoña joirinkaiyaani Jesús itsipataari jiyotaani. Ari isaikaiyapaakini owintinipathatzi. Ojyiki atziri piyowintapaakariri, Judea-jatzi, Jerusalén-jatzi, Tiro-jatzi iijatzi Sidón-jatzi. Ipokaiyakini jirikapaini inkimiro ikinkithatakotziri Jesús, ikowaiyatziini iijatzi joshinchaayitairi imantsiyaritipaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tima ikaatzi piyarishiritatsiri, joshinchaayitairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ikowaiyakini atziri jantantawatyaari kapichiini jako, tima otzimimotziri Jesús itasorinka, joshinchaayitakiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ipoña Jesús ikimpoyaanakiri jiyotaani, ikantziri: “Kimoshiri pinkantaiya ashironkainkari, tima iirokataki ñagaironi impinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kimoshiri pinkantaiya piñaawitawo iroñaaka pitajyaaniintawaitzi, tima irootaintsi piñiiro pinkimaniintaiya. Kimoshiri pinkantaiya piñaayiwitawo piraaniintawaita iroñaaka, tima irootaintsi piñiiro pishirontawaitaiya. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kimoshiri pinkantaiya onkantawitatya piñaawitawo iroñaaka inkisaniintayiitimi, jookathaitimi, inkawiyawaitaitimi, imanintawaitaitimi, okantakaantziro poshiritaari Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Thaaminta pinkantayitaiya, pinkimoshiriyitai, tima Pawa pinayitaimini inkitiki. Pinkinkishiritakotyaawo tsika ikantayiitakiri pairani itayitakawori Kamantantaniri, irootaki awijyimotimini iijatzi iiroka iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","¡Inkantamachiitiri ajyaagantzinkariiti! Tima aritaki iñaayitakiro iroñaaka inintaawaiyitaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Inkantamachiitiri ikaatzi ñiirori iroñaaka ikimaniintayita! Tima ari iñiiro paata irirori intajyaaniintai. ¡Inkantamachiitiri ikaatzi ñaayitzirori iroñaaka ishirontawaita! Ari iñiiro paata inkimaatsiwaitaiya, ari jiraawaitaiyaari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Inkantamachiitiri ikaatzi jasagaawintaitari iroñaaka! Tima ari ikimitaawiitakari pairani kimitakowitariri Kamantantaniriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Iro kantzimaitacha pinkimi nokantzi naaka: Pitakotaiyaari ikaatzi kisaniintayitzimiri, paapatziyaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Iiro pipiyatari kijyimawaitzimiri. Pamanakoyitaiyaari thiiyakowintzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aririka impajaitimi kajyitapooki, pishinityaari japitiroryaapootimi impajatimi. Aririka inkowaiti jagaitiro piithaari posaawantapiintari, pishinitiniri jaanakiro pikithaatakari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aririka inkantayiitimi: ‘Pimpina’, kamiithatatsi pimpimantaniti. Aririka jayitaitimiro pashitari, kamiithatatsi iiro pikiñaanikowintziro. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pikowirika jitakoyiitimi, pitawatyaawo iiroka pitakotantya. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Iriirika pitakotashitatya ikaatzi itakoyitzimiri iiroka, ¿Kamiithatakima jiroka? Aña tii, tima iro jimatapiintakiri kaaripiroshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iriirika paapatziyashitatyaari ikaatzi aapatziyimiri iiroka ¿Kamiithatakima jiroka? Aña tii, tima iro jimatapiintakiri kaaripiroshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Aririka inkantaitimi: ‘Pimpawakinawo, ari noipiyaimi’, impoña pimpawakiri tima piyotzi ari jimataimi iiroka paata. ¿Kamiithatakima jiroka? Aña tii, tima iro jimatapiintziri kaaripiroshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pitakoyitaiyaari iiroka kisayitzimiri, iiro pipiyatari. Pimpimantaniti aririka inkamitayiitimi, iiro poyaawinta jimayitaimi iiroka. Antawoiti impinayitaimi, itomitaimi Jinokijatzi. Imapiro jitakoyitakari irirori maawoni kaaripiroshiripaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ikimita Ashitairi jitakotanta, ari pinkimitanaiyaari iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Iiro pookimotantzi, jimaitzimikari iiroka paata. Iiro piyakowintantzi, jimaitzimikari iiroka paata. Aririka pimpiyakotanti, ari jimayiitaimi iiroka paata. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pimpimantanitai, tima ari jimayiitaimi iiroka paata, janaakaayitaimiro iiroka okaatzi pipimantakiri. Tzimatsirika pantakiri, ari inkimiyiitaimi paata iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ipoña jojyakaawintanakiniri Jesús, ikantzi: “¿Kantatsima inkathatawakaiya kaari aminatsini? ¿Tiima ari imparyaaki apitiroiti omoonakiki? ");
INSERT INTO cpcNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tii iñaitzi apaani iiniro jiyotaitziri janaakotiri yotairiri. Irooma paata aririka jiyotaapiroitakiri ari inkimitaiyaari yotairiri pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Iitama pikowantari pamininiri pashini tyaakitachari jokiki? Pitawatyaawo iiroka paawairo antawo inchapitoki tyaakitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Tima iiro okantzi pinkantiri pijyininka: ‘Pimpoki, nayimiro tyaakitakimiri pokiki’. Aña tzimataitatsi pokiki iiroka antawo inchapitoki tyaakitakimiri. ¡Thiiyinkarí! Pitawaiyaawo paawairo iiroka tyaakitakimiri pokiki, inkini pamininiri pijyininka tyaakitainchari kapichiini jokiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Inchato saankanatatsiri ojyooki, tii iñaitziro onkaaripiroti okithoki. Irooma inchato sampiyashitatsiri, tii kamiithaini iñaitiro onkithokiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tima okaatzi kamiithayitatsiri chochoki, tii okamiithawaitashita apaniroini, aña iro kantakaawori owaato okamiithatzi iroori. ¿Añiiroma higo onkithokitantyaawo owaato kitochii? ¿Kantatsima uva okithokitantawo kitochii iijatzi? ");
INSERT INTO cpcNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ari ikimiyitanaari kamiithashiriri ikinkishiritapiintawo kamiithari, irootaki okamiithatantari jantayitziri. Iriima kaaripiroshiriri tii ikinkishiritapiintawo kamiithari, irootaki okaaripirotantari jantayitziri. Tima okaatzi ikinkishiriyitari, irootaki iñaaniyitari iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Iitama ikantantayiitanari: ‘Pinkatharí, pinkatharí?’ Tiimaita jantaitanawo okaatzi nokantayitziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tzimayitatsi matanairori okaatzi nokantayitziri. Jiroka ikimiyitanaari: ");
INSERT INTO cpcNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ikimitakari atziri witsikatsiri ipanko, ikiyashitakiro itzinkami okisopathatzi kipatsi, jowatzikakiro. Opoña opokaki antawoiti amaani, ookantapaakawo shintsiini pankotsi, tii iiwokiro. Tima jowatzikaitakitziiro kamiithaini okisopathatzi kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Iriima piyakotzirori nokantayitziriri, kaari antanaironi. Ikimitakari atziri witsikawitachari ipanko, tiimaita ikiyashitziro inthomainta. Okanta opokaki antawoiti amaani, ookantapaakawo shintsiini, tyaanaki. Tii jiñaitairo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aritaki ithonkanakiro Jesús ikinkithatakairi atziripaini, jatai nampitsiki Capernaum. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ikanta imantsiyataki jitakopirotani jotzikatani ijiwari owayiriiti Roma-jatzi, irootaintsi inkamimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ari ikimakowintakiri Jesús, jotyaantaki jantarikipiroti Judá-mirinkaiti, inkaimiri Jesús, joshinchagairiita jotzikatani. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ikanta jiyaatashitakiri Jesús, ikantapaakiri: “Okowapirotatya pimitakotiri ijiwari owayiriiti, ");
INSERT INTO cpcNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","tima jaapatziyapiintakina, jiwitsikakina pankotsi tsika napatotapiinta”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ikanta Jesús, joyaatanakiri. Iro jariitantyaarimi ipankoki, itonkiyotakari ijyininkathori ijiwari owayiri, iriitaki pashini jotyaantakiri, ikantapaakiri irirori: “Jesús, ikantakaantzimi jiwari, ikantzi: ‘Kaaripirori ninatzi naaka, iiro pityaapankotana. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Irootaki kaari niyaatashitantzimi noñiimi naaka. Apa nokowi piñaani pinkantakaantawakiri nompiratani, aritaki ishintsitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tima tzimatsi ompiratanari naaka, tzimatsi iijatzi owayiri nompiratari naaka. Aririka nonkantiri: “Piyaati”, aritaki jiyaataki. Aririka nonkanti pashini: “Pimpoki”, aritaki impokaki. Aririka nonkantiri nonampiri: “Pantiro jiroka”, jimatziro jantziro’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ikimawakiri Jesús, iyokitzi ikantanaka, ikantanakiri itsipatakari: “Iriitaki matakirori jirika ikimisantzi, tii itzimi jaka Israel-ki ajyininka kimityaarini jirika. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ikanta ipiyaiyani pankotsiki jotyaantaitakiri, iñaapaatziiri jotzikatani, shintsitai imantsiyawita. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ipoña ikinanaki Jesús nampitsiki iitachari Naín, iri itsipayitaka jiyotaani. Ojyiki iijatzi atziripaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iro jariitzimataka nampitsiki, itonkiyotakotantaka jagaitziri kaminkari inkitaitiri, apintzi jinatzi otomitari tsinani kamatsiri oimi. Ojyiki atziri oyaatakirori jiroka tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ikanta Jesús iñaawakiro tsinani, antawoiti jitakoshiritanakawo. Ikantziro: “Aritapaaki piraawaitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ipokapaaki okaakiini, jotirotapaakiro jowantaitakariri. Katziyaiyapaakani natakotziriri. Ikantzi Jesús: “Iwankarí, iiroka noñaanatzi, pimpiriintai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Piriintanaa kamawitainchari ñaawaitanai. Ikathatanairi Jesús irojatzi inaanatiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Antawoiti ithaawaiyanakini ikaatzi ñaakiriri. Ikimoshiriwintanakiri Pawa, ikantaiyanakini: “Pokataiki ñaapirori Kamantantaniri”. Ipoña ikantaiyini iijatzi: “Pokataiki Pawa iri nishironkayitaini aaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ithonka ikimakoyiitanakiro jantakiri Jesús maawoni Judea-ki, iijatzi pashiniki nampitsi okaatzi saikanampitatsiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ikanta Juan ikimaki irirori okaatzi awisaintsiri, ikamantakiri jiyotaanipaini. Ari jiyoshiitaki apiti jiyotaani, ");
INSERT INTO cpcNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jotyaantakiri josampitiri Jesús, inkantiri: “¿Iirokama jiitaitziri ‘Pokatsini?’ Kaaririka iiroka, ¿Tzimatsima pashini naamaiyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ikanta ipokaiyakini, iñaapaakiri Jesús, ikantapaakiri: “Jotyaantakina Juan owiinkaatantaniri nosampitimi: ¿Iirokama jiitaitzi ‘Pokatsini?’ Kaaririka iiroka, ¿Tzimatsima pashini naamaiyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tima iikiro joshinchaayitatzi Jesús kantawaiyitachari mantsiyari, ikaatzi piyarishiritatsiri, jokiryaakaayitai ojyiki kaari aminatsini iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Irojatzi ikantantanakariri pokaintsiri: “Aririka piyaatai, pinkamantapairi Juan maawoni okaatzi piñaayitakiri iiroka nantakiri, okaatzi pikimakinari iijatzi. Tima naminakaayitairi kaari aminatsini, naniitakaayitairi kisopookiri, nokimakaayitairi ashikimpitari, noshinchaayitairi imatziri pathaawontsi, nañaakaayitairi kaminkari, nokinkithatakoyitainiri ashironkainkari Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Irootaki inkimoshiritantaiyaari inkaati kaari kisoshiriwintainani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ikanta ipiyaiyanaani jotyaantani Juan, josampitanakiri Jesús ikaatzi apatowintakariri, ikinkithatakotziri Juan, ikantziri: “¿Iitama pikinkishiritakotariri piñaakiri chapinki janta otzishimashiki? ¿Iriima piñaaki apaani kimitawori sawoo ojyiwatonkitakaawo tampiya okantakaantziro tii ithaamintashirita? ");
INSERT INTO cpcNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Piñaakirima jowaniinkatya ikithaataka? Tima maawoni ikaatzi nintaawaitachari, owaniinkapirowaitachari ikithaata, isaikapankotziri pinkatharintsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Aña iro piyaatashitantakariri piyotaiyakini Kamantantaniri jinatzi. Tima jimapirotatziiro irirori janaakiri Kamantantaniripaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Iriitaki josankinatakoyiitaki pairani, iñaanatziri Pawa itomi, ikantzi: Notomí, ari notyaantaki ityaawoni inkinkithatakotimi, Iriitaki witsikaantimini tsika pinkinapaaki iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nokantzi naaka: Atziriiti ikaatzi tzimawitainchari, tikaatsi apaani Kamantantaniri anairini jiyotanitakari Juan. Iro kantzimaitacha inkaati ipinkathariwintairi Pawa inkitiki, tsinampashiritaatsiri janta, janaakotairi irirori Juan”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jirika atziriiti jowiinkaayitakiri Juan itsipataakiri kowakoyitziriri ijyininka kiriiki, jiyotanairi tampatzikashiriri jinatzi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Iriima Fariseo-paini itsipatakari Yotzinkariiti tii jishinita jowiinkaayitiri Juan, ari japaatziro okaatzi jantzimotantiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ipoña ikantzi Pinkathari Jesús: “¿Iitama nonkimitakaantiriri jirikaiti? ");
INSERT INTO cpcNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Nonkimitakaantiri owajyaantawairintzi iintsi aririka jojyakaantawaiti ikaatzi jiryaanitaiyini, inkantawakaiyaani: ‘Thami ajyowiwaiti amajyiitantyaari’. Iiromaita ikowi. Impoña inkantawitya iijatzi: ‘Incha amampaawaitya owashiritantyaari’. Iiro ikowimaita iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iro jimayitakiri jirikaiti. Jiñaawitakari Juan, itzitapaakawo irirori owanawontsi, tii jimiritawo kachori, iro kantzimaitacha ikantakotaiyakirini: ‘Ipiyarishiritatzi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ipoña ipokaki Itomi Atziri, tii itziwaitapaakawo irirori owanawontsi, imiritawo kachori. Ikantakotaiyakiri: ‘Kaaripirori jinatzi, niyawairintzi jinatzi, shinkiryaantzi, jaapatziyari kowakotziriri kiriiki ijyininka, jaapatziyari iijatzi kaaripiroshiriri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tikaatsi oitya, tima apaani yotaniri ari jiyoitairi paata imapiro jiyotanita, aririka jiñaayitakiro onkaati awisayitaatsini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ikanta Fariseo jaanakiri Jesús jowakaiyaari. Ariitaiyakani ipankoki, saikapaaki Jesús jowapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Okanta apaani kaaripiroshiriri tsinani nampitawori janta, okimakowintakiri Jesús ipokaki ipankoki Fariseo jowaiyaani, jataki iroori aakotanaki kasankaari owantawo onaki jiwitsikaitziro mapinaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Okatziyimotapaakari iitzikontaki Jesús, iraimotapaakari. Othaatanaka oyaaki okiki ajyitakiri iitziki, ojyitantzimaitari oishi. Ipoña onintaakiiwaitanakiri, osaitantanakari kasankaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ikanta jirika Fariseo amakiriri Jesús, ikantashiritanaki: “Imapirotatyiirimi jirika ikamantaniritzi, ari jiyotakiromi tsika okantawaita jiroka tsinani otirotakiriri, tima kaaripiroshiri inatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ipoña Jesús ikantanakiri Fariseo: “Simón, tzimatsi nokowiri nonkantimiri”. Ari ikantzi: “Incha pinkantinawo yotaanarí”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ipoña ikantzi: “Apaani atziri, ipakiri iiriikiti pashini apiti atziri. Apaani ipaki 500 kiriiki, iriima pashini ipakiri 50. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Okanta osamanitaki, tii okantzi jirika apiti atziri joipiyairi kiriiki, ipiyakoitairi jiriiwitani apitiroiti. Incha pinkantina, ¿Itzimikama itakopirotantachani?” ");
INSERT INTO cpcNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ikantzi Simón: “Nokantzi naaka iri itakopirotantacha atziri ipiyakopiroitakiri jiriiwitani”. Ari ikantzi Jesús: “Ari pimatakiro pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jaminanakiro Jesús osaikaki tsinani, ikantziri Simón: “¿Piñaakiro antakiri jiroka tsinani? Notyaapankotakimi iiroka, tiimaita pipana jiñaa nonkiwakiitapaatyaari. Irooma jiroka tsinani, okiwakiitantakinawo oyaaki shitowanaintsiri okiki, opoña ojyitantakinawo oishi. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tii pinintapootawakina piwithatawakina iiroka, irooma jiroka tsinani ojyiki onintaakiitakina. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tii pisaipatziitotantinari iiroka yiinkantsi pimpinkathatina, irooma jiroka tsinani, osaitantakinawo kasankaari noitziki. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ojyiki okaaripiroshiriwitaka jiroka tsinani, ipiyakoitainiro tima ojyiki itakotakina. Iriima tsika itzimi ipiyakoitziri kapichiini, kapichiini jitakotanta”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ipoña ikantanakiro tsinani: “Ipiyakoitaimiro okaatzi pikaaripiroshiriwitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ikantaiyanakini ikaatzi itsipataiyarini: “¿Iitatyaama jirika imatantyaawori impiyakotantiro kaaripirori?” ");
INSERT INTO cpcNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Iikiro Jesús ikantanakitziiro tsinani: “Piyaatai kamiitha, tima iro pawisakoshiritantaari pikimisantanai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ikanta Jesús itsipayitakari 12 jiyotaani, ithonkakiro nampitsi ikinkithataki, ikinkithatakotakiri Pawa tsika ikanta ipinkathariwintantai. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ari itsipatakawo iijatzi tsinaniiti okaatzi joshinchaayitairi opiyarishiriwitaka, iijatzi okaatzi mantsiyawitachari. Jiroka okaatzi oyaatakiriri: María jiiyiitziri iijatzi Magdala-jato ñiiriri ikaatzi 7 piyari, ");
INSERT INTO cpcNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","opoñaapaaka Juana iina Chuza jompiratani Herodes, opoñaapaaka Susana. Ari itsipatakawo iijatzi pashinipaini tsinani okaatzi papiintakiriri kiriiki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ipoña ipiyowintapaakari Jesús ojyiki atziri poñaayitachari pashiniki nampitsi. Jojyakaawintatziiniri okaatzi jiyotaayitziriri, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tzimatsi pankiwairintzi jatatsiri impankiwaiti. Ikanta jookakitakiro iwankiri, tzimatsi ookakitapainchari aatsiki, ithonka jaatzikakiitakiro, ipoña ipokaiyapaakini tsimiri, jowapaakawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tzimatsi pashini ookakitapainchari omapipookitzi kipatsi. Okanta ojyookawitanaka pankirintsi, sampiyashitanaki, tima tii irinkapathatatyi kamiithaini kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tzimatsi pashini ookakitapainchari okitochiimashitzi. Okanta ojyookawitanaka, kamanaki anaanakiro kitochiimashi. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Tzimatsi pashini ookakitapainchari okamiithawanikitzi kipatsi, saankana okanta ojyookapaaki, kithokitanaki. Apaanipaini jyookapaintsiri kamiitha tzimayitai 100 okithokiki”. Ipoña ikantanaki Jesús: “Kowirori inkimathatiro, jowakimpitatya inkimisanti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ikanta jiyotaani Jesús josampitakiri iita ojyakaawintari okaatzi jiyotaantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jakanakiri Jesús, ikantziri: “Iirokaiti nonkamanti kaari piyowitaiyani, ontzimatyii piyotairo tsika ikanta Pawa ipinkathariwintantai. Iriima pashinipaini, iiro nokamantziri irirori, apa nojyakaawintiniri. Ari onkantya jaminawitya jirikaiti, iiro jiñiimaitawo. Ari inkimawityaawo, iiro ikimathatawakiro nokantawitariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jiroka ojyakaawintachari: Jiroka okithoki ipankiitakiri, iñaanira Pawa ojyakaawintachari. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Okaatzi ookakitapainchari aatsiki, ojyakaawintari kimawitawori ñaantsi, ipokapaaki kamaari imaijantakaapaakiri, tima tii ikimisantzi, iiro jawisakoshiritai. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ari okimita ookakitapainchari omapipookitzi, ojyakaawintari kimawitawori ñaantsi thaankipiroini ikimisantawitanaka. Tii jiyotakopirotatyiiro ñaantsi, jowajyaantanakiro ikimisantzi. Tii ikisashitawo jantakaitiri kaaripirori, ikimiwaitakawo pankirintsi kaari tyaapirotatsini oparitha inthomainta kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ari okimita ookakitapainchari okitochiimashitzi, ojyakaawintari kimawitawori ñaantsi. Okantakaantziro okantzimoshiriwaitari, ikinkishiritakotawo jajyaagantya, inintawaitziro inthaamintawaitya. Iro anaanakiro ñaantsi ikimawitakari, ikimitakawo pankirintsi kaari kithokitatsini. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Irooma okithoki ookakitapainchari okamiithawanitzi kipatsi, ojyakaawintziri kimisantanairori ñaantsi, kamiithashiri ikantanaa, jojyakotanaawo pankirintsi saankana ijyookanaki, ojyiki okithokitanaki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ipoña ikantaki iijatzi: “Ankowirika ootyaari ootaminto, ¿arima antatakotakiri kowitzinakiki? ¿Amanakotzirima otapinaki? Aña tii. Owakotziri jinoki inkini inkoñiinkatakoti akaataiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ari onkimityaari iijatzi, ontzimatyii onkoñaatakoyitai manakowitainchari, oñaagantairo kaari ikimathawiita pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Paamaakowintyaawo okaatzi pikimakiri. Tsikarika itzimi otzimimotakiri, ari ontzimimopirotairi ojyiki. Iriima kaari otzimimotzi, iikiro jiyaatatyi iñiiro iiro otzimimopirotairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Okanta opokashitakiri inaanati Jesús otsipatakari iririntzipaini oñiiri. Tiimaita okantzi oñiiri jotzikaakiro atziri piyowintakariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ipoña ikantaitakiri: “Ari opoki pinaanati otsipatakari pirintzipaini, okowi oñiimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ikantanaki irirori: “Ikaatzi kimanairori iñaani Pawa, jantanairo okaatzi ikowakairiri, iriitaki nirintzitari, iro nonaanatitari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ipoña jotitanaa Jesús pitotsiki itsipatanaari jiyotaani, ikantanairi: “Thami amontyi intatsikironta”. Jataiyakini. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ikanta jimontyaakotaiyini, maanaki Jesús. Ari omapokapaakari antawoiti tampiya, antawo otamaryaatanaki inkaari, kitaatapaaka jiñaa pitotsiki, iroowitaincha intsitsiyakotaiyinimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ari jowakiryaitanakiri Jesús, ikantaitziri: “¡Yotaanarí! ¡Antsitsiyakotatyi!” Piriintanaka, iñaanatanakiro tampiya, ikantziro: “¡Aritapaaki pitampiyatzi!” Ipoña ikantziro inkaari iijatzi: “¡Pimairyaati!” Awisanaki tampiya, mairyaatanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ipoña ipithokashitari jiyotaani, ikantziri: “¿Tsikama okinaki pawintaani?” Antawoiti ipinkathatanakiri, ikantawakaiyani jiyotaani ithaawankakiini: “¿Iitatyaakama jirika jomairintantawori tampiya, jomairintziro iijatzi inkaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ikanta jimontyaanakawo Jesús intatsikironta inkaari Galilea, ariitaka inampiki Gadara-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iro jaatakotapaakityaami, ishiyashitawakari piyarishiritatsiri. Pairanitaki ipiyarishiritaki tii ikithaataa, tii jamitaiya isaikai pankotsiki, ari isaikawaitzi kitataarimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ikanta jiñaawakiri jariitapaaka Jesús, ishiyapaaka, jotziirowashitapaakari. Kaimanaki shintsiini, ikantzi: “¡Jesús, Itomi Pawapirotatsiri! ¿Tsikama pinkantataitinaka? Tii nokowi powashironkaina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Tima ikisawitawakityaari piyari jowajyaantairiita shirampari. Pairanitaki ipiyarishiritakaawitakari. Ojyiki joojowiitantari ashirotha, ithatyiiro. Ishiyashiyawaita otzishimashiki ikantakaari piyari.) ");
INSERT INTO cpcNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ipoña Jesús josampitakiri piyari, ikantziri: “¿Tsikama piitaka?” Jakanaki piyari, ikantzi: “Noita ‘Jyikiyantzi’ ”. Tima ojyiki ikaataiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iikiro ikantanakitzi piyari: “Tii nokowi papirotaiyinani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ari ipiyotaiyani ojyiki chancho joshintagaiyini. Ikantaiyini piyari: “Potyaantina janta chancho-ki”. Ipoña ikantzi Jesús: “Pimatiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ikanta jyikiyantzi, jatanaki ipiyota chancho. Irojatzi ishiyantanakari tsika impiitatzi otzishi, mitaiyapaakini, ari ithonka ipiinkaki inkaariki. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ithaawaiyanakini aamaakowintariri chancho-paini, shiyaiyanakani ikamantantapaaki nampitsiki, ikamantakiri iijatzi maawoni saikayitatsiri jowaniki. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pokaiyapaakini atziri jaminiro okaatzi awisaintsiri. Ipoña jiyaatashiitanakiri Jesús. Iñaitapaatziiri piyarishiriwitachari isaikaki itsipatakari, ikithaataka, kamiitha ikantanaa. Antawoiti ithaawaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ikaatzi ñaakirori inkaanki awisaintsiri, ikamantawakiri pokayitaintsiri, ikantziri: “Piñiiri piyarishiriwitachari, iriitaki Jesús owawisaakotairiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ikanta maawoni Gadara-jatzi, ikantakiri Jesús: “Piyaatai, tii nokowi pisaikimotina”. Iro ikantantari, tima antawoiti ithaawantanakari. Ipoña jotitanaa Jesús pitotsiki, jatai. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ari ikantawitawaari jowawisaakotairi: “Nokowi noyaatanakimi”. Jakanaki Jesús, ikantanakiri: ");
INSERT INTO cpcNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Iiro poyaatana, piyaatai pijyininkaki pinkamantapairi, pinkantiri: ‘Jowawisaakotaana Pawa’ ”. Ari jimatakiro shirampari, jatai ikamantantapairo okaatzi jowawisaakotairi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ikanta ipiyaa Jesús, thaaminta ipiyowintawaari atziri, tima iri joyaakoniintakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tzimatsi shirampari jiita Jairo, iriitaki jiwatakaantatsiri japatotapiintaita. Ari iñaapaakiri Jesús, jotziirowashitapaakari, ikantapaakiri: “Nokowi piyaati nopankoki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tima okamimatatzi japintoti irishinto. Ari tzimaki 12 osarintsiti. Ikanta joyaatziri atziripaini jirika Jesús, jawitsinaimatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tzimatsi iijatzi tsinani kimaatsiwaitachari osokaata, tzimakotaki 12 osarintsi ashironkaawaitaka, apirotakiro opimantziro tzimimowitawori opinatantariri aawintantzinkari, tikaatsimaita kantironi joshinchiiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Okinashitapaakiri itaapiiki Jesús, otirotsitakiri kapichiini opatziki iithaari. Apathakiro ishitanaki osokaawaita iraani. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ipoña josampitantanaki Jesús, ikantzi: “¿Iitaka otirotakinawori noithaari?” Tikaatsi kamantatsini iita otirotakiniriri. Ipoña Pedro itsipatakari ikaataiyini, ikantzi: “Yotaanarí, tima piñiiri jawitsinaimatakimi ojyiki atziri, iikiro pikantatzi: ‘¿Iitaka otirotsitakinawori noithaari?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iikiro ishintsitanakitzi Jesús ikantzi: “Tzimatsi otirotsitakinawori noithaari. Tima nokimawakiro noshintsinka tzimatsi oshinchaashitakari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Okanta oñaakiro jiroka tsinani tii imanakota okaatzi antakiri, antawoiti othaawanaki, opokashitapaakiri Jesús, otziirowashitapaakari, maawoni ikimaitakiro okinkithatakota, ikimaitakiro iijatzi tsika okanta omapokanaka oshintsitai osokaawaiwita. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ikantanakiro Jesús irirori: “Tsinaní, oshinchagaimi pawintagaana. Kantatsi piyaatai, kimoshiri pinkantanaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tikiraamintha ithonkiro Jesús jiñaanatziro tsinani, ariitapaaka poñainchari ipankoki jiwatakaantatsiri japatotapiintaita, ikantapaakiri: “Kamaki pishinto, aritapaaki poñaashirinkiri yotaantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ikanta ikimakiri Jesús ariitapainchari, ikantanaki irirori: “Iiro pithaawashiwaita. Pawintaiyaana, aritaki oshintsitai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ikanta jariitaiyapaakani pankotsiki, tikaatsi ishiniti intyaapaaki, apa Pedro, Jacobo, Juan, ashitawori irishinto, onaanati. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ojyiki iraakotaiyawoni kamaintsiri. Ikantapaaki Jesús: “Iiro piragaiyani, tii okami iintsi, imakoryaatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Thainkashiri jowawiitakari Jesús, tima imapiro iñaitakiro kamaki iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ikanta Jesús joirikawakotapaakiro, iñaanatzimaitawo shintsiini ikantziro: “¡Tsinaní, pimpiriinti!” ");
INSERT INTO cpcNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Piyashiritapaaka iintsi, piriintanaa. Ari ikantzi Jesús: “Pimpiro oyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iyokitzi ikantanaka ashitawori iintsi. Iikiro ikantanakitzi Jesús: “Tii nokowi pinkamantantiro okaatzi piñaakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ipoña Jesús japatotakiri 12 jiyotaani ipasapiyaakari ishintsinka onkantya inkitsirinkantyaariri piyari iijatzi mantsiyarintsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jotyaantakiri inkamantantiro tsika ikanta Pawa ipinkathariwintantai, joshinchaayitiri mantsiyariiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ikantawakiri: “Iiro paanaki tsika oitya, iiro paanaki pikotzi, pithaati, powanawo, piiriikiti, iiro okantzi paanaki iijatzi apiti piithaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Aririka pariitatya pankotsiki, ari pimaapiintatyi irojatzi pawisantanatyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iirorika jaapatziyaitzimi janta, pawisapithatiri, potikanairo piipatsikiiti, iro jiyotantyaari tii ikimisantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ikanta jiyaataiyakini jiyotaani, ithonka ikamantantakiro nampitsiki Kamiithari Ñaantsi, ojyiki mantsiyari joshinchaayitaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ikanta pinkathari Herodes jiitaitziri iijatzi Tetrarca ikimakowintakiri Jesús okaatzi jantayitziri, okantzimoshiritanakari, tima tzimatsi kantatsiri: “Añagai Juan owiinkaatantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pashini kantatsiri: “Elías jinatzi”. Ikantayiitzi iijatzi: “Aamaa pashini Kamantantaniri piriintaachari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Irojatzi ikantantanakari Herodes: “Aña nothatzinkakaantakiri Juan-ni. ¿Tsikama itzimi nokimakowintziri iroñaaka?” Ojyiki ikowaki iñiirimi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ikanta ipiyayitaa otyaantaari, ikamantapairi okaatzi jantayitakiri. Ipoña japatotawairi maawoni, jaanakiri nampitsiki jiitaitziro Betsaida. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Iro kantacha yotaiyakini atziri tsika ikinaki joyaatzishitanakiri. Ikanta Jesús jaawakiri kamiitha, ikamantakiri tsika ikanta Pawa impinkathariwintantai, joshinchaayitakiri mantsiyayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Aritaki tsiniriityaanaki, ipokashitapaakiri 12 jiyotaani, ikantapaakiri: “Potyaantairi atziripaini, jamini tsika jimayi, tsika joyaa iijatzi, tima asaikatzi jaka otzishimashiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jakanaki Jesús, ikantanakiri: “Pimpiri iiroka joyaari”. Ari ikantaiyini: “Tikaatsi nompiriri, apa otzimi 5 tanta, apiti shima. ¿Pikowima niyaati namanantakitiniri joyaari maawoni atziriiti?” ");
INSERT INTO cpcNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kimitaka ikaataiyini 5000 shirampariiti apatotainchari. Ikantziri jiyotaani: “Papatoyitiri inkaati 50 atziri poosaikayitiri, ari pinkimitakiri maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ari ikantakiro, joosaikakiri maawoni atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jaakiro Jesús 5 tanta, apiti shima, jaminanaki inkitiki, ipaasoonkiwintakiro owanawontsi, ipitoryaakiro ipakiri jiyotaani impayitiri maawoni atziri apatotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jowaiyakani maawoni, kimaniintaiyakani shintsiini. Ijaikitai 12 kantziri okaatzi tzimagaantapaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ikanta isaiki Jesús jamanamanaata itsipatari jiyotaani. Ari josampitakiri ikantziri: “¿Iitama ikinkishiritakotanari atziripaini?” ");
INSERT INTO cpcNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ari jakaiyanakini: “Ikantayiitzi Juan-ni owiinkaatantaniri pinatzi, ikantayiitzi iijatzi Elías-ni pinatzi. Tzimatsi kantatsiri iijatzi: ‘Iri pashini piriintaacha itawori Kamantantaniri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ipoña ikantzi Jesús: “¿Tsikama pikantaiyinika iiroka?” Ari jakanaki Pedro, ikantzi: “Iirokataki Cristo poñaachari Pawaki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ari ikantanakiri Jesús jiyotaani: “Iiro pikinkithatakotana”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iikiro ikantanakitzi: “Ojyiki inkimaatsitakaityaari jirika Itomi Atziri, imapiro inkisaniintina ijiwari Antaripiroriiti, ijiwari Ompiratasorintsitaari, iijatzi ikaatzi Yotzinkariiti. Ari jowamaakaantakina. Iro kantacha awisawitatya mawa kitiijyiri, ari nañagai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ipoña ikantanakiri maawoni: “Tzimatsirika kowatsiri intsipatina, jowajyaantiro ikowashiwaiyitari jantiri, onkantawitatya impaikakotaitirimi joshiritaana, intsipatapiintaina kitiijyiriki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tima ikaatzi itakowaitachani apaniroini jantayitziro inintashiyitari, ari impiyaashitaiya. Iriima inkaati kamawintinani okantakaantziro ikimisantana, aritaki jawisakoshiritai. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Aminaashiwaita otzimimotantzi ojyiki ajyaagawontsi jaka kipatsiki, impoña iñaitairo impiyashitaiya, apaniroini japirowaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tima inkaati kaaniwintinari naaka, iijatzi noñaaniyitakari, ari jimatapairi Itomi Atziri inkaaniwintapairi paata aririka impiyi jamairo jowaniinkawo, jashi Ashitariri, jashi maninkariiti tasorintsitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ipoña ikantanaki iijatzi Jesús: “Tyaaryoo, tzimatsi pikaataki jaka, tikira ikamiita ari iñaanairo tsika inkantya Pawa impinkathariwintanti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Okanta awisaki 8 kitiijyiri, tonkaanaki Jesús otzishiki jamanamanaatya, ari itsipatanakari Pedro, Jacobo ipoña Juan. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ikanta jamanamanaata, ari ipashinipootanaki Jesús, kitamaa okantanaka iithaari oshipakiryaanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iñaitatzi apiti katziyapainchari itsipatapaakari Jesús, Moisés jinatzi itsipatakari Elías. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ari ikatziyaiyapaakani otapotakiri jowaniinkawo, ikinkithatakotziro tsika inkantya Jesús impiyakaityaari Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ayimatakiri iwochokini Pedro iijatzi ikaatzi itsipatakari. Okanta awijyimotanakiri iwochokini, iñaatziiro jowaniinkawo Jesús itsipatakari apiti koñaatapaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iro ipiyimatanaka apiti tsipatapaintariri Jesús, ikantzi Pedro: “¡Yotaanari, kamiithawaitaki asaiki jaka! Ari niwitsikimiri mawa pankojyitantsi pashi iiroka, jashitya Moisés, jashitatya Elías”. Iñaawaitashitanaka Pedro, tii jiyotzi oita ikantziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iñaawaiminthaitzi Pedro, opamankapaakiri minkori, ithaawanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ikimatzi iñaawaitaitanaki minkoriki ikantaitzi: “Notomi nitakokitani jinatzi jirika, iriitaki pinkimisantiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Okaatapaaki ñaantsi iñaawaitaitakiri, iñaitatzi apaniroini ikantanaa Jesús ikatziya. Tiira ikamantantsitawo jiyotaani tsika ikanta jiñaakiri, jimanani jowakiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Okanta okitiijyitamanai, oirinkaiyaani Jesús ipoñagaawo tonkaariki otzishiki, ojyiki pokaintsiri intonkiyotawaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ari josatikaka shirampari, kaimanaki shintsiini ikantzi: “¡Jesús, nokowi pamininari napintziti notomi! ");
INSERT INTO cpcNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ipiyarishiritatzi, owanaa ikaimakaawaitziri, ishimoripaantitakairi ikamimawaitzi, jompojakaawaitari, tii jowajyaantziri kapichiini. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nokantawitakari piyotaani jowawisaakotainari, tii ikantziri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jakanaki Jesús ikantanaki: “Tiitya pikimanitzi iiroka. ¿Tsikama onkaati nosaikimotanaimi, noñiiro namawitakotimiro? Pamakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ikanta jamaitapaakiri iintsi, ishinkiwintakaanakari piyari, tyaanaki isaawiki, antawoiti jompitawaitanaka. Ipoña Jesús ikisakiri piyari, shintsitanai iintsi, jaanairi ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iyokitzi ikantaiyanakani atziri jiñaakiro ishintsinka Pawa. Ipoña japiitakiro Jesús ikantziri jiyotaani: ");
INSERT INTO cpcNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Powakimpitatatyaawo iiroka jiroka ñaantsi, iiro pipiyakotairo. Tima jirika Itomi Atziri impithokashiitatyaari jaakaantaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Iro kantzimaitacha tii ikimathataiyironi okaatzi ikantawitariri, tima jimanapithaitatziiri iiro ikimathatantawo. Iro ithaawantaiyakarini tikaatsi osampitirini oita ikinkithatakotziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ikanta jiyotaani Jesús ikantawakaawintakawo iitakarika ñaapirotachani. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Iro kantzimaitacha Jesús jiyoshiritakiri ikinkishiritari. Jaaki iintsi, itsipatapaakari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ipoña ikantzi: “Ikaatzi aapatziyariri kimitariri jirika iintsi okantakaantziro ipairyiiro nowairo, kimiwaitaka naakami jaapatziya. Ari okimitari iijatzi, aririka jaapatziyina naaka, kimiwaipirotanaka iri jaapatziyaka tsika itzimi otyaantakinari jaka. Ikaatzi kaari ñaapirotachani iroñaaka jaka, iri ñaapirotaachani paata”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ipoña ikantanaki Juan: “Yotaanarí, noñaaki chapinki atziri pairyiirori piwairo, joshinchaakiri piyarishiritatsiri. Tii añiiri ankaatiri jaka, nowajyaantakaakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ari ikantanaki Jesús: “Iiro powajyaantakairimi, tima ari akaatziri kaari kisaniintairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aritaki monkaatzimatapaaka intzinaantaiyaari Jesús, tontashiri ikantanaka jiyaatzi Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jotyaantaki iitya aminaantirini janta Samaria-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Iro kantzimaitacha tii ikowaiyini Samaria-jatzi inkinimotiri, tima jiyotaiyini jiyaatatyi Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ipoña Jacobo itsipatakari Juan, ikantanakiri Jesús: “Pinkathari, thami ankaimakaanti paampari inkitiki, ikimitaakiro pairani Elías, japirotyaata intaiya maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ari ipithokashitanakari Jesús, ikisanakiri, ikantziri: “Tiitya pikamiithashiritzi iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Tii iro ipokantakari Itomi Atziri jaka impiyashiwaitaiya atziri, ontzimatyii jowawisaakoyitairi”. Irojatzi ikinantanakari pashiniki nampitsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ikanta jiyaatanai Jesús, ikantawiitawaari aatsiki: “Pinkatharí, nokowi noyaatimi tsikarika pinkinayiti iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jakanakiri Jesús ikantziri: “Apaani otsitsiniro tzimatsi imoo tsika imaapiintzi, iijatzi ikimitari tsimiri tzimatsi jomayiro. Iriima jirika Itomi Atziri tii otzimi ipanko jimaantapiintyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ipoña Jesús ikantanakiri pashini: “Poyaatina iiroka”. Ari ikantzi irirori: “Pinkatharí, nokowawitaka noyaatanakimi, iro kantzimaitacha nokowi noñaanakiro nonkitatiri nowaapatitari, ari noyaatimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ikantanakiri Jesús: “Poyaatina, pishinitiri ikaatzi kamashiriyitatsiri inkitatairi irirori kamayitatsiri. Ontzimatyii pikinkithatakotairo iiroka tsika inkantya Pawa impinkathariwintantai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ari ikantanaki pashini: “Pinkatharí, nokowi naaka noyaatimi, iro kantzimaitacha pishinitina niwithatapanaatyaari nojyininka nonampiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jakanaki Jesús, ikantziri: “Apatziro paminapiintziro pikiyashitziro piwankiri, tikaatsi paminayitanai pashini. Ari ikimitari kaari owajyaantaironi jantayitapiintziri, tii opantapirotari iñiiro impinkathariwintairi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ipoña Jesús jiyoshiitaki pashini ikaatzi 70, apitipaini jotyaantakiri, jiiwatiri nampitsiki tsika inkinanaki irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ikantayitziri: “Ikimitakawo atziripaini pankirintsi osampainkatzi, iro kantacha tii itzimapirotzi iitya oyiipataironi. Pamanamanaatyaari iiroka Pinkathari jotyaantiita jatatsini atziriki, tima kowityaacha ojyiki kimisantayitaatsini. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Notyaantaiyatyiimini, nonkimitakaantimi jotyaantaitziri oijya tsika ipiyota piratsi katsimari. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Iiro paanaki pithaati, piiriikiti, pi-zapato-ti. Iiro piwithatantanaka, iiro pinkinkithawaitakairi inkaati piñaanakiri aatsiki posamanitzikari. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Aririka pariiyitatya pankotsiki, piwithatapaatyaari saikatsiri. Pinkantapaakiri: ‘Inkamintha pisaikawaiti kamiitha pipankoki’. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tzimatsirika iitya aawakimini kamiitha, aritaki iñaakiro isaikai kamiitha. Irooma iirorika jaapatziyaitzimi, aminaashita piwithatapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Aritaki pimaapiintatyi pankotsiki tsika pariitaka, iiro paminaminatzi pashini pankotsi. Ari poyaari, piriro onkaati impayiitimiri. Tima apaani antawaitatsiri ipinayiitziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Aririka aawakimi kamiitha nampitsiki, poyaawo onkaati impayiitimiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Poshinchaayitiri janta mantsiyari, pinkantiri: ‘Irootaintsi impinkathariwintantai Pawa’. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Irooma pariiwitatya nampitsiki, iirorika jaawakimi kamiitha, pawisapithatiri, pinkantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Notikanairo noipatsikiiti jaka, iro piyotantyaari tii pikimisantzi. Iro kantzimaitacha ontzimatyii piyoti irootaintsi impinkathariwintantai Pawa’. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tima imapiroitairi paata jowasankitaitiri, anaanakiro inkantayiitairi Sodoma-jatzi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ikantamachiitziri Corazín-jatzi, iijatzi Betsaida-jatzi. Iñaayiwitakawo notasonkawintantayitaki, tiimaita ikimisantaiyini. Iriimi ñaakinanimi Tiro-jatzi iijatzi Sidón-jatzi, aritakimi jowashiritakotatyaami ikaaripiroshiriyitzi, jowajyaantakiromi. Inkimisantaimi maawoni iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aririka jaayiitairi paata kamiithashiriri, iiro jimapiroitziri jowasankitaayiitairi Tiro-jatzi iijatzi Sidón-jatzi. Iriima Corazín-jatzi, iijatzi Betsaida-jatzi, iri jimapiroyiitai jowasankitaayiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iijatzi inkimitagaiya Capernaum-jatzi, ikinkishiritaiyani irirori jiyaayitai inkitiki, iro kantzimaitacha owanaa ikisoshiritaki, jiyaayitai ikinayitzi kaminkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tzimatsirika kimisantimini, naakataki ikimisantaki. Itzimirika manintashiritakimini, naaka imanintashiritaki. Itzimirika manintashiritakinari naaka, imanintakiri otyaantakinari jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kimoshiri ipiyaiyaani jotyaantaitakiri 70, ikantayitapai: “Pinkatharí, nopairyiiro piwairo, nimatantakari piyari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ikantzi Jesús: “Noñiitsitataikari pairani Satanás jowaryaitakiri inkitiki ikimiwaitakawo ookathawontsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tima naaka pakimirori shintsinkantsi, ari onkantaki posatikantyaari maanki iijatzi kitoniropaini. Ari poitsinampaakiri piyari kisaniintzimiri, tikaatsimaita awijyimotimini. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Iiro pikimoshiriwintashitawo pimatakiri piyari. Iro pinkimoshiriwinti josankinayiitairo piwairo inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Irojatzi ikimoshiritantanakari Jesús, ikantanaki: “Ashitanarí, iirokataki pinkathariwintziriri inkitiwiri, iijatzi kipatsijatzi, antawoiti nopaasoonkitakimi. Tima iirokataki yotakaayitairiri tsinampashiriri kaari jiyoyitzi yotaniriiti jaka. Ari okantzimaita Ashitanari, irootaki inimotzimiri iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ikantzi Jesús: “Iri Ashitanari pasapiyaakinawori maawoni. Apaniroini ikanta irirori jiyopirotana naaka tima itomi jowana. Ari nokimitsitakari iijatzi naaka apaniroini niyopirotziri. Impoña inkaati niyotakaayitairi naaka ari jiyoyitairi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ipoña Jesús japatotakiri jiyotaani, jaanakiri jantyaatsikiini, ikantakiri: “Kimoshiri inkantaiya inkaati ñaayitaironi okaatzi piñaayitairi iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Tima tzimawitacha ojyiki Kamantantaniri, iijatzi pinkathariiti kowawitainchari iñiiromi okaatzi piñaakiri iiroka, iro kantacha tii okantzi iñiiro, tii ikimayitairo iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ari isaikakiri yotaantzirori Ikantakaantaitani, ikowaki inkompitakaiyaari Jesús, ikantaki irirori: “Yotaanarí, ¿iitama nantiri naaka noñaantaiyaawori kantaitachari añaamintotsi?” ");
INSERT INTO cpcNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ikantanaki Jesús: “¿Iitama okantziri Ikantakaantaitani? ¿Tsikama okantzi piyotakotziro iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ari jakanaki irirori, ikantzi: “Pitakoshiritaiyaari Awinkathariti Pawa, pitakopirotaiyaari, pitakoshintsitaiyaari, pampithashiri powairi. Ari okimitari iijatzi: Ontzimatyii atakotawakaiya maawoni, akimita anishironkatziro awatha, ari ankimitanairi ajyininka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ipoña ikantzi Jesús: “Imapiro pikantakiri. Pantiro jiroka, aritaki pawisakoshiritai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Iro kantzimaitacha jirika, ikowajaantzi jotzikaakowintanatya, josampitziri Jesús: “¿Iitama nonkimitakaantiri nojyininka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ipoña ikantanaki Jesús: “Tzimatsi ajyininka poñaachari Jerusalén-ki ikowi jiyaatiro nampitsiki Jericó. Okanta niyanki aatsi, itonkiyotakari koshintzi, itsitokawaitakiri, jookanakiri aatsinampiki ikamimataki. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ikanta pokaki Ompiratasorintsitaari, jiñaawitapaakari jomaryaaka, jawisapithatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ari ikimitsitakari iijatzi Leví-mirinka, jiñaawitapaakari jomaryaa, jawisapithatanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ipoña ipokaki Samaria-jatzi, jiñaapaakiri jomaryaa, inishironkatapaakiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jaawintapaakiri itziritantakari yiinkantsi, ipoña ityaakaanakari imoraniki, jaanakiri nampitsiki. Iriitaki aamaakowintariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Okanta pashini kitiijyiri, jaaki apiti kiriiki, ipinakowintanakiri, ikantanaki: ‘Paamaakowintyaanari jirika, aritaki nompinatapaimi iijatzi aririka nompiyaki’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ari ikantzi Jesús: “Mawa ikaatzi ñaakiriri ikoshiitziri. ¿Tsikatya itzimi kimitakaantakariri ijyininka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jakanaki yotakotzirori Ikantakaantaitani, ikantzi: “Iri matapaakiriri nishironkatakiriri”. Ipoña ikantzi Jesús: “Piyaatai, irojatzi pimatiri iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ikanta jawisanaki Jesús ariitaka pashiniki nampitsi. Ari osaikiri tsinani iitachari Marta, iro isaikimotapaaki opankoki. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jiroka tsinani tzimatsi irinto oita María. Iro tsipatawakariri okaakiini Jesús okimisantziri ikinkithawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Iro kantzimaitacha Marta owanaa okantzimotakawo aminaminawaitzi oitya ompawakiriri Jesús. Irojatzi opokashitantakariri, okantapaakiri: “Pinkatharí, ookawintakina nirinto. ¿Pinkantinawo amitakotawakina?” ");
INSERT INTO cpcNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ikantzi Jesús: “Marta, ¿iitama okantzimoshiritantzimiri okaatzi pantayitiri? ");
INSERT INTO cpcNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pinkimi nonkantimi: Apaani okanta kowapirotachari, irootaki okowakiri María tima tikaatsi kantironi jaapithaitairo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ipoña Jesús jiyaataki jamanamanaatya. Ikanta apaani jiyotaani, ikantakiri: “Pinkatharí, piyotainawo jamanamanaataita, ikimitairo Juan-ni jiyotaantziro amanamanaataantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ari ikantzi Jesús: “Jiroka pinkanti pamanamanaatapiintya iiroka: Ashitanarí, inkitijatzi, Tasorintsi pinatzi iiroka. Pimpinkathariwintaina naaka. Pantakainawo jaka kipatsiki okaatzi pinintakaanari iiroka. Pinkimitakainari saikatsiri inkitiki, jantayitziro okaatzi pinintakairiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pimpapiintinawo kowityiimotanari noyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pimpiyakotainawo nokaaripiroshiriwaitaki, Tima nimatakiro naaka iijatzi, nopiyakotairi ikaatzi owaaripiroshiritakinari. Iiro pishinitana iñaantaitina, inkowaiti jantakaitinawo kaaripirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ipoña ikantanakiri iijatzi: “Aririka intzimi pitsipaminthari, impokaki niyankiiti, inkantimi: ‘Pimpawakina mawa tanta, ");
INSERT INTO cpcNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tima tzimatsi ariitachari nopankoki, tikaatsi tzimatsini nompawakiriri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Impoña pinkantawityaari: ‘Iiro poñaashirinkana nomaakaatziiri niintsitipaini, aritaki nashitanairo nopanko, irootaki iiro okantanta nompimi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kimiwaitaka iiro pikowawita pimpiri onkantawitya iriimi pitsipaminthari. Iro kantacha iikiro ishintsitatzi ikamitzimi, ari pishiwintanakiro pimpiriinti, pimpawakiri okaatzi ikowiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ikantzi Jesús: “Pinkamitanti, paminaminatiro, aritaki piñaakiro impayiitimiro pikowiri. Pinkimitakaantiro pariitya pankotsiki, pishintsiwintapaakiri, pinkantiri: ‘Pashitaryiinawo. Aritaki jashitaryaitakimiro’. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ari impayiitairi kamitantayitatsiri. Inkaati aminaminatironi ari joñaagaitairi. Aritaki jashitaryaitainiri inkaati shintsishintsitatsini inkaimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Tima aririka inkamitimi pitomi, inkantimi: ‘Paapá, pimpina tanta’. ¿Arima pimpakiri mapi? Aririka inkantimi: ‘Pimpina shima noya’. ¿Arima pimpakiri maanki joyaari? ");
INSERT INTO cpcNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aririka inkantimi: ‘Pimpina iithoki’. ¿Arima pimpakiri kitoniro? ");
INSERT INTO cpcNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Tima piyotzi pitakotari pitomipaini iiroka, kaaripirori pinawita. Iri mapirotzirori Ashitairi saikatsiri inkitiki, jitakotari irirori ikaatzi amanayitapiintariri, inampishiritakaayitari Tasorintsinkantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ipoña Jesús jowawisaakotakiri apaani kisopaantitatsiri piyarishiritatsiri. Ikanta joshinchagairi, ñaawaitanai kisopaantiwitachari. Antawoiti jiyokitziiwintaitanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Tzimatsi kantayitanaintsiri: “Ipasapiyaatyaari jirika ashitariri piyari, jiitaitziri ‘Beelzebú’, irootaki jimatantawori jowawisaakotziri ikaatzi piyarishiritatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tzimatsi pashini kowatsiri iñiiro intasonkawintanti Jesús, iro jiyotantaityaari imapirotatya opoña itasorinka inkitiki, tima iñaantaitatyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ikanta Jesús jiyotaki okaatzi ikinkishiritari atziriiti, ikantanaki: “Aririka jantaminthatawakaiya atziri ipinkathariwintaitziri nampitsiki, iñiiro jookawintawakaa. Aririka jantaminthatawakaiya iijatzi atziri isaikapankotawakaiyani, ari iñaakiro jookawintawakaiya. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ari ikantari iijatzi piyari aririka jantaminthatawakaiyaami, ari jookawintawakaatya iiro iñiiro ishintsiti, ari inthontyaari. ¿Iitama pikantantari iri oshinchaanari Beelzebú? ");
INSERT INTO cpcNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Iriirikami kamaari Beelzebú oshinchiinani, ¿irijatzima kamaari oshinchiiriri piyotaaniyitari iiroka jowawisaakotantariri jaagayitziri? Aririka okanta, pikinkithatakotatziiri piyotaani, ari inkisantakimiro okaatzi pikantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tima iriitaki Pawa kantakaawori noshinchaayitantariri piyarishiritatsiri, tima jomapokakimi Pawa iiroka ipinkathariwintantzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Atziri ñaapirori kamiitha, tikaatsi matirini intyaashitiri ipankoki jayitiri okaatzi jashitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Irooma impokashitakiri pashini atziri anairiri ishintsitzi, jaapithatakiri jawintaawitari, jaapithatakiri jashitari, jantitatyaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tima ikaatzi kaari aapatziyanari naaka, iriitaki kisaniintanari. Inkaati kaari amitakotinari joyiipatakotina, japaatakotatyaanawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Kimiwaitaka piyari inampishiritantatyaarimi atziri, ipankotsitatyaawomi jañaantari. Aririka jookawiitatyaari, awisakowita atziri isaikantari piyari. Jataki inkinawaiti otzishimashiki, iiro iñi tsika isaiki. Impoña inkanti piyari: ‘Nompiyi nopankoki tsika nopoñaaka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Piyaa piyari, iñaapairi atziri kamiitha opishitaka jañaantari, owaniinka okantaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Impoña piyari jiyaatashitakiri mapirotzirori ipiyaritzi, inkantapaakiri: ‘Thami aati nopankoki, pintsipatina ampinkathariti’. Jamaki inkaati 7. Ari jashironkaapirotyaari atziri, iiro ikimitaa jashironkaawita pairani kapichiini ikanta”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tikira ithonkiro iñaawaitzi Jesús, okaimanaki tsinani osatikainchari ipiyotaka atziri, okantzi: “Thaaminta inatyi tsinani owaiyantakimiri, antaritakaakimiri othotaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ipoña jakanakiro Jesús, ikantzi: “Iri thaamintapirotaachani inkaati mataironi inkimisantairo iñaani Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ikanta ipiyotapaaka ojyiki atziri, ikantanaki Jesús: “¿Iitama ikowantari iñiina kaaripiroshiriri nontasonkawintanti? Iiro noñaayimaitari, apa iñiiro kimitawori jiñaakiri pairani Jonás. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tima ikanta pairani Jonás jiñagaiyakirini Nínive-jatzi, ari inkimitaiyaari iijatzi Itomi Atziri jiñiiri jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Paata aririka jaminakoyiitairo okaatzi jantayiitziri, ari iyakowintaimi tsinani pinkatharitatsiri pairani nampitsiki Sabá, tima opokashitakiri iroori yotaniri iitachari Salomón, okimisantairi. Jirika saikimotakimiri iroñaaka iiroka, janairi Salomón. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Iijatzi okimitari ari jiyakowintaimi paata Nínive-jatzi, tima ikimisantaiyakirini irirori pairani Jonás, jowajyaantanakiro jamiyiwitari. Jirika saikimotakimiri iroñaaka iiroka jaka, janairi Jonás”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Tima anintirika ootya ootaminto, ¿arima owakotakiri otapinaki? Aña owakotziri jinoki inkini onkoñiinkati maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Kamiitharika poki, piñaantawo kamiithaini, okimitawo pinkoñiityaakotatyiimi. Tiirika opantawo poki, iiro piñaantawo kamiithaini, kimitaka pintsinirikitakotatyiimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Paamaakopirowintya poitsiwakirikari ootamintotsi saikantakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Imapirotarika isaikantakimi ootamintotsi, tiirika pantanairo kaaripirori, aritaki poñaagantairo iroopirori kamiithari, pinkimitanaiyaari apaani ootamintotsi jootantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ikanta ithonkapaakiro ikinkithataki Jesús, ipokashitapaakiri Fariseo jiyaatakairi ipankoki joya. Ikanta jariitaka Jesús pankotsiki, saikapaaki jowapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Owanaa okompitzimotakari Fariseo jiñaakiri Jesús tii jimonkaatziro jamitapiintari, inkiwaakotapaatya jowantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Iro kantzimaitacha Jesús, ikantanakiri: “Pikimitakotakawo piraaminto iijatzi powaminto okitiwita kamiitha jikokiroki, irooma inthomainta, kipatsi okantaka. Ari pikimiyitakari iiroka kantatsi iñaitimi kamiithashiri pinatzi, aña koshintzi kaaripiroshiriri pinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Masontzí. Tima tzimatsi witsikakimiri piwathaki koñaayitatsiri, ¿kaarima witsikashiritakimiri iijatzi inthomainta pañaantariki? ");
INSERT INTO cpcNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Okowapirotatya pimpashitantaiyaawo tzimimoshiritzimiri inthomainta pañaantariki, ari onkantya pinkitishiripirotantaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ikantamachiitzimi Fariseo! Pashitakaapiintari Pawa inchashimpoki. Iro kantacha tii pantanitiro ikowiri: Ontzimatyii pinkamiithashiritai, pitakoshiritaiyaari iijatzi. Tima iro kowapirowitachari pantayitiromi jiroka, iiro powajyaantzimaitawo pashini. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ikantamachiitzimi Fariseo! Owanaa pikowapiintziro posatitya niyankiniki japatotapiintaita, ari pikimitsitawo iijatzi pikowi pinkatha jiwithatapiintaitimi aririka jiñaitimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ikantamachiitzimi Yotzinkariiti ipoña Fariseo, thiiyinkari pinatzi! Pikimitashitakawo kaari jiyoitzi ari ikitaitziri kaminkari, tii jiyotzi atziri jaatzikakotatziiri kaminkari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ari jakanaki apaani yotaantzirori Ikantakaantaitani, ikantanakiri Jesús: “Yotaanarí, pikimakaakinawo iijatzi naakaiti okaatzi pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jakanaki Jesús, ikantzi: “¡Ikantamachiitzimi iijatzi iiroka yotaantzirori Ikantakaantaitani! ¿Iitama piñaatinatakaantariri atziriiti? Tii piñiimaitawo iiroka pinkimatinatyaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Ikantamachiitzimi iiroka, iitama piwitsikapiriyitantawori owaniinkatachari tsika ikitayiitakiri itayitakawori Kamantantaniri! Iriitajaantaki jowamaayitakiri pairani piwaijatziitini. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tima iirokataki witsikashiyitakiriri tsika inkitayiitiri, ari okoñaatziri pakakotatziiri okaatzi jantayitakiri piwaijatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Tima yotani jiñaawaitaki Pawa, ikantaki: ‘Ari notyaantaki Kamantantaniri intsipayitaiyaari otyaantaari. Apaanipaini imaamaniiti, jowamaitakiri pashini’. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ari onkantya jowasankitaantaitimiri iiroka, okantakaantziro powamaayitakiri Kamantantaniri itajaantanakawori pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Iiroka atsipitaiyaawoni iroñaaka ikantakaantziro jowamaakaantaitakiri pairani, jitanakawo Abel-ni irojatzi Zacarías-niki jowamaitakiri ipiyawitanaawo tasorintsipankoki intaapainiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Ikantamachiitzimi yotaantzirori Ikantakaantaitani! Tii pimataajaitziro iiroka piyotanitya, ari pikinakaakiro iiroka kaari ikimathatantawo pashinipaini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ikanta Jesús ithonkakiro ikantayitakiri. Ari jitanakawo Fariseo itsipayitapaakari Yotzinkariiti, japatowintaari Jesús ikowaki inkompitakaiyaari onkantya inkimantyaariri oita inkantiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ishintsiñaaniwaitakiri, ikowi jiñaawaitakairi kaaripirori onkantya inkinkithatakotantyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ipoña ipiyowintaitapaakari Jesús, awitsinaapirinikiwaitanaka atziriiti. Irojatzi ikantantanakari jiyotaani: “Ontzimatyii paamaakowintyaawo shiniyakaawori itantani Fariseo, jamatawiminto inatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tima ontzimatyii onkoñaatakoyitai okaatzi imanakowitainchari, onkoñaatakoyitai kaari ikimathawiita pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Okaatzi pimanakaawitari, ari onkoñaatakoyitai. Okaatzi piñaawaitziri apaniroini pipankoki, ari inkimakoyiitairo inkinkithatakoitiro shintsiini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ikantzi Jesús: “Ajyininká, iiro pipinkawaitashitari matironi intsitokimi, tima ari iwiyaapaakari jaawiyiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jirika pimpinkiri: Iri pimpinki Pawa matzirori jowamaantzi, impoña jotyaantimi sarinkawiniki. Apa pimpinkathatairi apaniroini. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tima tii ipinapirowita tsimiripaini, iro kantzimaitacha jiyotzi Pawa aririka inkamagaanti, tikaatsi imaakiti apaani. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jiyotsitawo Pawa okaatzi tzimayitatsiri aishi. Tima piñaakiro jaamaakotari tsimiripaini, iirokara jimapirotzi jaamaakotzimi, iiro pipinkantashiwaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Itzimirika kantirini ijyininka: ‘Jashitaana Jesús’. Iijatzi inkimitaiya Itomi Atziri inkantairi imaninkariti Pawa: ‘Nashitaari jirika’. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Iriima kantairini ijyininka: ‘Tii jashitana Jesús’. Ari inkimiitairi irirori, inkantaitiri imaninkariti Pawa: ‘Tii nashitaari jirika’. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tsikarika intzimi ookimotakirini Itomi Atziri, kantatsi impiyakoitairi. Iriima intzimi ookimotakirini Tasorintsinkantsi, iiro iñiiro impiyakoitairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Aririka jaayiitimi japatotapiintaita isaikayitzi pinkatharintsi, iiro okantzimoshiriwaitzimi, pinkanti: ‘¿Iitama nonkantiriri?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tima Tasorintsinkantsi yotakaimironi iitarika piñaawaitiri janta”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ipoña jiñaawaitanaki apaani piyowintakariri, ikantzi: “Yotaanarí, pinkantinari nirintzi impainaata kajyitani jookanairi nowaapatini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ikantzi Jesús: “Ajyininká, tii naaka aminakoyitironi tzimawintawakaantsi nonkantantyaariri pirintzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iikiro ikantanakitzi Jesús: “Paamaakowintya pinintayitzirokari ajyaagawontsi. Tii iro añaakaashiritimini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ipoña jojyakaawintanakiniri, ikantzi: “Tzimatsi ajyaagantzinkari kithokitaintsiri iwankiwairi jowaniki. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ikinkishiriwaitaka, ikantzi: ‘¿Tsikatya nowiroka ojyikitaintsiri nowankiri?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ikantashiritanaki: ‘Jiroka nantiri. Notantoryiiro nowantapiintari nowankiri. Niwitsikakaanti antawoiti, ari nowiro okaatzi nowankiritari, iijatzi najyaagawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ari inimotinari, tima ojyiki nowaantakari. Ojyiki osarintsi nimakoryaawaiti, nowapirowaitya, nirawaiti nomiri, noimoshirinkawaitya’. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Iro kantzimaitachari, ikantzi Pawa: ‘Masontzí, iroñaaka tsiniri jaashiritaitimi, tii piyotzi iitya agaironi okaatzi pashitari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ari ikantakotari ojyiñaawaitashitawori jajyaagawo, tii jojyiñiimaitawo okaatzi jashitari Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ipoña ikantanairi jiyotaani: “Pinkimi nonkanti: Tii okamiithatzi onkantzimoshiriwaitimi, pinkanti: ‘¿Oita noyaari, oita nomirityaari, oita nonkithatyaari?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tima tzimatsi ankinkishiritakotapiintiri añaantariki, iro kowapirotacha anairo owayitapiintari, okaatzi akithaatapiintari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Pinkinkishiritakotiri tsimiri. Tii jiyotzi impankitaantya joyaari, tii jiwitsiki ipanko jowaantyaari iwankiri. Iro kantzimaitacha Pawa, ipayitapiintakiri jowayitari. Aaka jimapirotzi jitakotai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aririka paakowintyaawo onkantzimoshiriwaitimi, ¿arima pinkantakaatyaawo powawiniintawairo posarintsiti kapichiini? ");
INSERT INTO cpcNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tii okantzi powawiniintiro kapichiini, ¿iitama okantzimoshiriwaitantzimiri? ");
INSERT INTO cpcNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pinkinkishiritakotiro inchatiya, tii añiiro antawainiti, tii ontyaawinta onkithaatyaari. Iro kantzimaitacha tii okantzimoshiriwaitawo, onkanti: ‘¿Oita nonkithaatyaari?’ Aña owaniinkata kamiitha, anairi jowaniinkawita Salomón pinkathariwitachari pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iriitaki Pawa owaniinkatzirori, okantawitaka kapichi añaawitawo owaniinkatapainta, iro osamani, tikaatsi opantanaiyaawoni aririka onkamatiyatanaki, tima inchikayiitakiro, intaayiitakiro. Iiroka jimapirotzi inkimpoyaawintimi Pawa, aritaki, iiro pikisoshiriwaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Aritapaaki okantzimoshiriwaitakimi iiroka, pikantzi: ‘¿Oita noyaari, oita niriri?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Apatziro okantzimoshiriwaitari ikaatzi kaari kimisantatsini. Irooma iiroka, jiyotakotzimiro Ashitairi oitarika kowityiimoyitzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iro kowapirotacha paminaminatairi impinkathashiriwintaimi, piñaayitairo impayitaimiro okaatzi kowityiimotzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Iirokaiti kimitakariri nopira, iiro pithaawashitaiyani, tima iriitaki Pawa kowaintsiri impinkathariwintaimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pimpimantayitiro tzimimotzimiri, pimpashitantyaawo. Iro kamiithatatsi pantayitairo jiroka piñaantaiyaawori pisaikai kamiitha inkitiki. Kimitawaitaka powaagaantatyiiyaami inkitiki tsika tii opathaanitapai, tsika tii itzimapai koshintzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tima janta tsika powaagaantaka, ari poshiritapiintyaawo iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Powathakitanatyaawo piithaari. Poonthoyitiri pootaminto. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Pinkimityaari ompirataari oyaawintariri jariitaiya iwinkathariti joimoshirinka, inkini jantawainiri thaankiini jompiratapaiyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kimoshiri inkantaiya apaani ompirataari itzimi iñaapairi iwinkathariti aamaakowinta ikantaka. Imapiro nonkanti, aritaki joosaikairi jowapiintaita iriitaki oyiitainirini jowanawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kimoshiri inkantayitya, intzimi iñaitapairi aamaakowinta ikanta, onkantawitya tii jiyotzi tsikapaiti jariitya, niyankiiti tiirika okitiijyitzimataki. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pinkimiro jiroka. Aririkami jiyoti owaiyantzinkari impokatyi koshitirini, ari jaamaakowintatyaami, iiro ikoshitaagantaitzirimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iro piyotiri iirokaiti, ontzimatyii paamaakowintayitya. Tima tii piyotzi tsikapaiti impiyantaiyaari Itomi Atziri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ari ikantanaki Pedro: “Pinkatharí. ¿Arima nokaatziri maawoni atziri pojyakaawintakina?” ");
INSERT INTO cpcNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ikantzi Jesús: “Pinkimitakotyaari ompirataari kamiithashiriri kinkishiritachari kamiitha. Jookanakiri ipankoki ompiratariri, ikantanakiri: ‘Pamininari ikaatzi saikatsiri pankotsiki’. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kimoshiri inkantya jirika ompirataari, aririka impiyi iwinkathariti jiñaapairi imonkaatakiro ikantanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Aritaki ishinitaakiniri jaamaakowintyaanari okaatzi jashitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Irooma inkantashiritakimi ompirataari: ‘Iiro ipiyita nowinkathariti’. Jantawaitakiri ikaatzi jompiraitari, ari ikimitaakiro tsinani jompirataitari. Jataki jowapirowaitya, ishinkiwaitya. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Inimowaitziri jirika ompirataari, jomapokashitaiyaari jariitaiya ompiratariri. Imapirotiri jowasankitaapairi, jookapairi ikajyaakaitakiri kisoshiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tima jirika ompirataari jiyowitakawo okaatzi inintakaawitariri iwinkathariti, tiimaita jaamawintaari impiyi. Irootaki impajapiroitantyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Iriima itzimi kaari yotakotironi okaatzi inintakairiri, iiro ipajapiroitairi. Ikaatzi ishinitaitziri jantapiroyitiromi ikowaitziri, ojyiki jompiraityaari. Intzimirika jawintaitari ojyiki, inkowakoitiri ojyiki irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Iro nopokantari nowasankitairi kaaripiroshiriri, okimiwaitakawo iriimi paampari namakimi kipatsiki. Owanaa nokowataikimi itataitya jowasankitaayiiti, apirotaiyaami kaaripirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Iro kantacha ontzimatyii nitanatyaawo nonkimaatsitanatya, irojatzi nimonkaatantatyaawori. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Piñaajaantaki iro nopokantari iñaamachiitairo atziri isaiki kamiitha. Aña nopokaki, namatziiro antaminthatawakagaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iroñaaka iñaitiro jantaminthatawakaitya isaikapankotawakaiyani, apiti atziri jantaminthatiri pashini atziri kaatatsiri mawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mainari ari impithokashitatyaari iwaapati, impiyatsityaari iijatzi iwaapati inkisaniintiri itomi. Ompithokashityaawo tsinani ishinto, ompiyatsityaawo iijatzi onaanati. Ompithokashityaawo tsinani ayiro, ompiyatsityaawo iijatzi iwatairo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ipoña Jesús ikantziri atziri piyowintakariri: “Tima aririka piñiiro minkori ityaapiintzi ooryaatsiri, pikantapiintzi: ‘Omparyaatyi inkani’. Mataka pikantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tima aririka pinkimiro tampiya ompoñiiya katonka, pikantapiintzi: ‘Osaryaatyi kamiitha jiroka kitiijyiri’. Mataka okaatzi pikantziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Thiiyinkarí! Piyowitawo iiroka okanta piñaayitapiintziro inkiti, iijatzi kipatsi. ¿Iitama kaari piyotakotantawo okaatzi kantachari iroñaaka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“¿Iitama kaari paminantawo iiroka kamiithatatsiri? ");
INSERT INTO cpcNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aririka intzimi kijyimini, impoña jaanakimi pinkatharintsiki, pinthaawakoti iiroka aatsiki, pinkantiri: ‘Iiro pikisawaita, thami aapatziyawakaiya’. Tima aririka jariitakaakimi pinkatharintsiki, inkantaitakiri aamaakowintaniri: ‘Paanakiri jirika’. Irojatzi jaantaitanakimiri jomontyaitzimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tima iirorika pipinatashitari okaatzi piriiwitziri, iiro piñagairo joimishitowakaantaimi. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ari ipokaiyakini kamantziriri Jesús, tima Pilato jowamaakaantaki Galilea-jatzi janta itaapiintaitziniri Pawa piratsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ikantanaki Jesús: “¿Piñaajaantzima iro jantantakawori jiroka tsika ikantaitakiri jowamaitakiri, janaakitziiri ikaaripiroshiritzi pashini Galilea-jatzi? ");
INSERT INTO cpcNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nokantzi naaka: Tii ari onkantya. Iirorika powajyaantziro pamiyitari iiroka, ari pinkimitakotaiyaari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ari ikimitakari kaatatsiri 18 kamaintsiri awitsinaakiri pankotsi janta Siloé, ¿piñaajaantzima iri mapirotzirori ikaaripiroshiritzi janairi pashini Jerusalén-jatzi? ");
INSERT INTO cpcNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nokantzi naaka: Tii ari onkantya. Tima iirorika powajyaantziro pamiyitari, ari pinkimitakotaiyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ipoña Jesús jojyakaawintanakiro, ikantzi: “Otzimi atziri iwankiri jowaniki. Okanta apaani kitiijyiri jiyaataki jaminiro tzimakirika okithoki, tiimaita iñaapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ikantakiri aamaakowintanariri: ‘Tzimaki mawa osarintsi nopokawita naminiro nowankiri onkithokiti, tiimaita noñi. Pinchikiro, aminaashiwaita okatziya jaka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ari jakanakiri irirori, ikantzi: ‘Iiro nowinkathariti, añaawairo jiroka osarintsi iirorika okithokitzi, nonkiyashitawairo oponkitziki notyaakitiro onkithokitantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Aririka onkithokitai, kamiitha inatzi. Irooma iirorika, aripaiti pintowakaantiro’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ikanta jiyotaantzi Jesús kitiijyiri jimakoryaantaitari janta japatotapiintaita, ");
INSERT INTO cpcNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ari osaiki tsinani tzimakotaintsiri 18 osarintsi opiyarishiritzi. Tsiyamitsitaki, tii okantzi onkatziyi kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ikanta jiñaapaakiro Jesús, ikaimapaakiro, ikantziro: “Tsinaní, shintsitaimi pimantsiyawita”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jotirotakiro kapichiini otsiyamitzitaki. Tampatzikatanai kamiitha. Ojyiki othaamintawintanakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iro kantzimaitacha tii inimotziri jiwatatsiri japatotapiintaita, antawoiti ikisanaka, jiñaakiri joshinchaantaki Jesús kitiijyiri jimakoryaantaitari. Ikantanakiri atziriiti: “Tzimatsi 6 kitiijyiri jantawaitantaitari, ari pimpokiri inkini joshinchagaitimi. Tii oshinitaantsitzi kitiijyiri jimakoryaantaitari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Irojatzi jakantanakari Jesús, ikantzi: “¡Thiiyinkarí! Kitiijyiriki jimakoryaantaitari pithataryaakotapiintziri pipira pashitakoyitziri pirakairi imiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Tima jiroka tsinani ajyininka inatzi, iro isawotari Abraham-ni tzimakotaki 18 osarintsi ikimaatsitakaakawo piyari. ¿Tiima okamiithatzi oshinchiiro kitiijyiri jimakoryaantaitari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ikantanaki Jesús, antawoiti ikaaniwintanaka ikaatzi kisaniintziriri. Iro kantzimaitacha kimoshiri ikantaiyanakani atziri ikaatzi ñaakirori jantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ipoña ikantanaki Jesús: “¿Iitama ojyari ipinkathariwintantai Pawa? ¿Iitama nojyakaawintimirori? ");
INSERT INTO cpcNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aña ojyatyaawo aririka impankiitiro okithoki oryaanikitatsiri pankirintsi. Tima tzimatsi atziri pankitakirori jowaniki, anaanakiro pashini pankirintsi, antawo otiwayitanaki, ari iminkoshiyitari tsimiri otsimankatapishitaki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ipoña japiitakiro ikantzi Jesús: “¿Iitama nojyakaawintimirori ipinkathariwintantai Pawa? ");
INSERT INTO cpcNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aña okimitatyaawo shiniyakaawori tanta. Tzimatsi apaani tsinani, aakiro kapichiini, otsipataakiro tantapatha, tikira osamanitzi, shiniyanaki maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ithonka ikinayitaki Jesús nampitsiki jiyotaantayitzi. Irojatzi ikinantanakari Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ari josampitaitakiri, ikantaitziri: “Pinkatharí, ¿kapichima awisakotaatsini?” Ipoña ikantzi Jesús: ");
INSERT INTO cpcNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ontzimatyii piñaashintsitya pinkimitakaantyaawo pintyagaatyiimi oryaanityinkakiiniki ityaapiintaitzi. Tima ojyiki kowawitachani intyaantaityaawo, iiromaita jimatziro. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Aririka jashitanakiro ipanko ashitawori, irojatzirika pisaikaki jikokiroki, pinkantawitya: ‘Pinkatharí, pashitaryiinawo’. Impoña jakanaki irirori, inkanti: ‘Tii niyotzimi tsika pipoña iiroka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Impoña pinkantawitanatya iiroka: ‘¿Tiima piyotina akaatziranki owaiyani, akaatziranki arawaitaiyini? Piyotaantapiintakina nonampiki’. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Inkanti irirori: ‘Imapiro, tii niyotzimi tsika pipoña. Piyaatawiiti aakowintawori kaaripirori’. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ari piraawaityaari, patsikaikiwaitya, aririka piñaayitairi Abraham, Isaac, Jacob intsipataiyaari ikaatzi Kamantantaniriiti isaiki ipinkathariwintantai Pawa. Irooma iiroka jikokiroki pisaikai. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tima inkaati awisakoshiritaatsini impoñaayitaiya tsikarika iwiyaapaa kipatsi, isaikayitai jatyooyitairi Pawa tsika ipinkathariwintantai. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tima tzimatsi itayitawori iroñaaka, iri ñiironi jimpoiyitai. Tzimayitatsi iijatzi impoiyitatsiri iroñaaka, iri ñaayitaironi jitaiyaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ari jariiyitapaaka Fariseo, ikantapaakiri Jesús: “Piyaatai, aatsikitaintsi Herodes ikowi intsitokimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ikantzi Jesús: “Piyaati, pimpiyanaki, pinkantiri sagaritatsiri, noshinchaayitziri piyarishiritatsiri, noshinchaayitziri mantsiyari. Apa okaatapaaki mawa kitiijyiri nonkaatakaantyaawori nantziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Iro kantzimaitacha, iikiro niyaatatyi irojatzi mawatapaintsini kitiijyiri, tima iro kamiithatatsi intsitokayiitiri maawoni Kamantantaniriiti Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Jerusalén-jatzí! Ojyiki pitsitokaki Kamantantaniriiti. Pojyimiyayitaki ikaatzi jotyaantawitakimiri. Tima nokowawitapiintaka nonkimityaarimi tsimiri josatitziri iryaani, ari nonkantirimi maawoni notomitaari. Iro kantacha tii pikowaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jaka tsika pisaikapiintawitaka iiro jiñaitai iitya nampitaiyaawoni. Tima iiro okantaitatya piñaapiintaina jaka, irojatzi paata pinkantantaiyaari: Tasonkawintaari jinatzi, tima Pinkatharintsi aitziri otyaantakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Okanta kitiijyiri jimakoryaantaitari, ikinaki Jesús ipankoki ijiwari Fariseo joya. Ojyiki kimpoyaakiriri oita jantiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ari isaikakiri janta apaani mantsiyari iiniyawaitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ipoña Jesús josampitakiri yotaantayitzirori Ikantakaantaitani itsipataakiri Fariseo, ikantziri: “Kitiijyiri jimakoryaantaitari inatzi iroñaaka, ¿tiima oshinitaantsiti oshinchaanti?” ");
INSERT INTO cpcNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tii jakaiyini, irojatzi jimairitaiyakini. Jaakiri Jesús mantsiyari, joshinchagairi, jotyaantairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ipithokashitanakari jirikapaini, ikantziri: “Aririka jotitya pipira omooki kitiijyiri jimakoryaantaitari, ¿tiima ari pinoshikairi thaankipiroini?” ");
INSERT INTO cpcNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Tima tikaatsi inkanti jakanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ari isaiki Jesús ikimpoyiiri inkaati atyootirini ijiwari Fariseo, thaawako ikantaiyani ikowi josatikayitya intsipatantyaariri jiwari joya. Ipoña Jesús jojyakaawintanakiniri, ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Aririka inkaimayiitimi poimoshirintya aawakagaantsiki, iiro pikowashita posatikasatikawaitya pinkowi pintsipatyaari jiwari, tima tzimatsi pashini pokatsini anaakotzimiri iñaapirota irirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aririka jariitapaatya kaimakaantzimiri, inkantapaakimi: ‘Iiro posatikasatikata iiroka, piyaati pisaiki jantyaatsikiini’. Antawoiti pinkaaniwintanatya. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aña iro kamiithatatsi aririka piyaati iiro posatikasatikawaita, pisaikapaaki jantyaatsikiini. Ompoña impokaki kaimakimiri, inkantimi: ‘Ajyininka, pimpoki posatitya iiroka janta’. Aripaiti impinkathayiitimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tsikarika itzimi kowashiwaitachani impinkathayiitirimi, aritaki iñaakiro intsinampashiritakagaitairi. Iriima tsika itzimi tsinampashiriwaitatsiri, iriitaki ñiironi ipinkathayiitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ipoña ipithokashitanakari Jesús aanakiriri jowakaiyaari, ikantziri: “Aririka pinkaimi atziri powakaiyaari, iiro pikaimashitari pijyininkapirotari iiroka, pirintzi, ipoña ikaatzi ajyaagantachari, tima ari onkantaki impiyataimi iiroka jatyootaimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Aririka poimoshirintya, iri pinkaimayiti ashironkainkari, kaari aminatsiri, pisaponthokiyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ari piñiiro pinkimoshiritai, tima jirikapaini, iiro okantzi impiyataimi paata joimoshirintya. Iro kantzimaitacha ari impinayiitaimi pantakiri aririka jañaayitai kamiithashiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ikanta ikimawaki ikaatzi isaiki jowaiyani, ikantanaki: “Kimoshiri inkantya inkaati owaachani impinkatharitanakirika Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ipoña ikantzi Jesús: “Tzimatsi atziri, jiwitsikakaantzi antawoiti oimoshirinkaantsi, ari jowaiyaani. Ithonka ikaimakiri ikaataiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ikanta imonkaatapaaka jowantyaari jotyaantakiri jompiratani inkamantiri ikaatzi ikaimakaantakiri, tima irootaintsi jowaiyaani. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Tii ikowi impokaiyini ikaatzi ikaimakaantawiitakari. Jitanakawo apaani, ikantzi: ‘Iiro okantzi niyaati, niyaatatyi naminiro owaantsi namanantakiri. Irootaki iiro okantanta niyaati’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ikantaki pashini: ‘Niyaatatyi noñaantyaariri namanantakiri nopirapaini, irootaki iiro okantanta niyaati’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ari ikantaki pashini iijatzi: ‘Iiro okantzi niyaati, tima owakiraa naawakaaka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Ipoña ipiya ompirataari, ikamantapairi iwinkathariti. Antawoiti owatsimaanakiri, ikantanakiri jimpiratani: ‘Piyaati, paniitiro tsika iwiyaa nampitsi, pamakiri ashironkainkari, kaari aminatsiri, pisaponthoriiti inkaati piñiiri janta’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ari imatakiro jompiratani. Ipoña ikantairi iwinkathariti: ‘Nimatakiro okaatzi pikantakinari. Iro kantzimaitacha iiniro okaankitzi pankotsi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ipoña ikantziri jimpiratani: ‘Pinthonkiro paniitiro aatsi, piyaayiti tsikarika, pishintsiwintiri inkaati piñiiri janta, impokiita ijaikitiita nopankoki. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pinkimi nonkanti: Ojyiki nitawitakari nokaimakaantziri, iiromaita iñaajaitziro joya kapichiini niwitsikakaantakiri owanawontsi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ojyiki ikaatzi oyaatakiriri Jesús. Ipoña ipithokashitanakari, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Aña iro inimotzimiri pitakoyitari piwaapati, pinaanati, piina, pitomi, pirintzi, pitsiro, pitakota iijatzi apaniroini iiroka. Iro kantacha iirorika pimapirotziro pitakotina naaka, tii pityaaryootzi pinkimisantaina. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ontzimatyii pintyaaryoowintiro nokinkithatakoyitakimiri, onkantawitatya impaikakoitimi. Aririka powajyaantakiro, iiro nokimitakaantzimi iiroka niyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Apaani kowatsiri jiwitsiki pankotsipinthakii, jitawatyaawo inkinkishiritya tzimatsirika imatantyaawori jiwitsikiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ari onkantya inthonkatyaawori jitanatyaawo jiwitsikiro, tima aririka jookawintakiro ari ishirontawintatyaari inkaati ñiirini. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Inkantaiyini: ‘Piñaamachiitiri jirika, tii jaawiyiro, jookashitakawo’. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ari ikimitari iijatzi, apaani pinkathari tzimatsiri 10 mil jowayiriti, jashiminthatyaawo jowayirityaari pashini pinkathari tzimatsiri 20 mil jowayiriti. Ontzimatyii jitawatyaawo inkinkishiritawatya, aririka inkitsirinkakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iñaakirorika iiro ikitsirinkiri, iiniro jiwiyaa intaina pashini pinkathari pokatsiri jowayirityaari, jotyaantaki kantirini: ‘¿Tsikama ankantyaaka iiro owayiritawakaanta?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ari okimitari iijatzi ontzimatyii pitawatyaawo pinkinkishiritawatya iirokaiti, tima iirorika powajyaantziro pitakoyitawo okaatzi pashiyitari, iiro nokimitakaantaimi niyotaani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tima kamiitha okanta tziwi okatyotzi. Iro kantacha aririka intsipataitiro tsika oitya, iiro opantaawo inkatyokantaityaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Tikaatsi opantaiyaawoni tziwi, iiro okantaajaitzi iijatzi isaiponkitzitantaityaawo pankirintsi, ontzimatyii jookaitiro. Kowirori inkimathatiro jiroka, jowakimpitatya inkimisanti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ojyiki kowakotziriri kiriiki ijyininka itsipatakari atziri kaaripiroshiriri, ikimisantzi jiyotaantzi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ikanta Fariseo itsipatakari Yotzinkariiti, ikinkithatakotanakiri Jesús, ikantzi: “Paminiri jirika, itsipatakari atziri kaaripiroshiriri, itsipatari jowapiintaiyani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ipoña Jesús jojyakaawintanakiniri, ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tzimatsi piratachari ikaatzi 100 joijyati. Okanta apaani kitiijyiri, ipiyaka joijyati, jookanakiri pashini 99 oijya otzishimashiki, jataki jaminaminatairi piyainchari. ¿Tiima pimatziro iiroka jiroka? ");
INSERT INTO cpcNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ikanta iñaapairi joijyati, kimoshiri ikanta jinatapairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Tima jariita ipankoki, japatotapairi ijyininka, ikantapairi: ‘Pimpoki pintsipatina oimoshirintya, tima noñagairi noijyati piyawitainchari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iikiro ikantatzi Jesús: “Ari onkimitagaiya inkitiki, antawoiti inkimoshiriwintaitiri atziri owajyaantairori ikaaripiroshiriwita. Janaanakiri 99 kamiithashiritatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ipoña ikantzi: “Apaani tsinani tzimatsi 10 oiriikiti. Okanta apaani kitiijyiri ipiyapithatakawo oiriikiti, owaampataki ootaminto, opishitakiro maawoni opanko aminaminatairi oiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Okanta oñagairi, okaimakiri ojyininka, okantakiri: ‘Pimpoki, pintsipatina noimoshirintya, tima noñagairi noiriikiti piyawitainchari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iikiro ikantanakitzi Jesús: “Ari inkimitagaiya imaninkariti Pawa antawoiti inkimoshiriyitai iñaakirika atziri jowajyaantairo ikaaripiroshiriwaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ipoña ikantanaki iijatzi Jesús: “Apaani atziri tzimatsiri apiti itomi. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ikanta iyaapitsi itomi, ikantakiri iwaapati: ‘Paapá, pimpinawo onkaati pookanairi nashitaiyaari pinkamakirika’. Ari ikantakiro, ipayitakiri itomi onkaati jashitakaiyaariri paata. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tikira osamanitzi, jataki iyaapitsi itomi intaina pashiniki nampitsi. Ari japaawaitakiri iiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ikanta ithonkatakiri japaatakiri maawoni, iñaitaki antawoiti tajyitsi janta nampitsiki. Ari ikowityaanakiri ikaatzi japaawaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ipoña jiyaatashitakiri nampitawori janta ikowi antawairintsi, jotyaantaitakiri jaamaakowintyaari chancho. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Antawoiti itajyaaki, ikowaki jatyootiri chancho, tima tikaatsi pirini joyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ipoña ikantashiritanaki mainari: ‘Owanaa inintaawaita jowapirowaita antawaitatsiri ipankoki nowaapati, ¿iitama nashironkaawaitantari naaka jaka notajyaaniintzi? ");
INSERT INTO cpcNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ontzimatyii niyaatai ashitanariki, nonkantapairi: “Paapá, tzimatsi kaaripirori nantzimotakimiri, iijatzi nokimitaakiri Inkitijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tii okantzi pinkimitakaantaina pitomi, apa nokowi pinkimitakaantinari ikaatzi antawaitzimiri”.’ ");
INSERT INTO cpcNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ari ipoña ikatziyanaka, pokai ashitaririki. Ikanta ashitariri, aminawookitatsi irirori iñaawairi ipokai, ishiyashitawaari, jawithakitawairi, ithopootawairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ikantapaaki itomi: ‘Paapá, tzimatsi kaaripirori nantzimotakimiri, iijatzi nokimitaakiri Inkitijatzi. Tii okantzi pinkimitakaantaina pitomi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Iro kantzimaitacha ashitariri, ikantakiri jimpiratani: ‘Pamaki iroopirori kithaarintsi, pinkithaatawairi notomi. Powiniri jakoki poriryaatatsiri, pintyaantakairi iijatzi zapato. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Impoña paminaki iwonkiri vaca kamiitha iwathati, powamairi. Nokowi oimoshirintya. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tima jirika notomi kamawitaka, iro kantzimaitacha añagai iroñaaka. Pairani ipiyaka, iñaitairi iroñaaka’. Ari jitanakawo joimoshirinkaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ikanta jantariti iririntzi saikatsi jantawaitzi owaantsiki. Pokai pankotsiki, ikimapaatzi joimoshirinkaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Josampitapaaki apaani jompiratani jiita ikimoshiritantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ari ikantanakiri: ‘Ariita pirintzi, irootaki jowamaakaantantakari piwaapati iwonkiri vaca, tima kamiitha jariita pirintzi tikaatsi awijyimotirini’. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ari ikisapaaka, tii ikowi intyaapai pankotsiki. Ipoña jiyaatashitakiri iwaapati, owanaa jowomirinchaakiri intsipatantyaariri joimoshirinka. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Irojatzi ikantantanakariri iwaapati: ‘Piñaawitana naaka osamani nosaikimotzimi, tikaatsi nantzimotimiri. Tiitya pipaajaitana piratsi noimoshirintya. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Iro kantzimaitacha ipokai iyi thonkitakimiriri piiriikiti ipiro mayimpiro, iri powamainiri wathatatsiri poimoshirinkawairi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ari jakanaki iwaapati, ikantziri: ‘Notomí, ari pashi powiro pisaikimotakina iiroka, maawoni okaatzi nashitari, iiroka ashitawo maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Irootaki ankimoshiritantyaari iroñaaka, tima jirika pirintzi, kamawitaka, iro kantacha añagai iroñaaka. Ipiyawitaka iñaitairi iijatzi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ipoña Jesús ikantakiri iijatzi jiyotaani: “Tzimatsi atziri ajyaagantachari. Itzimi irirori jompiratanipaini. Okanta apaani kitiijyiri tzimatsi pokaintsiri, ikantaitakiri ajyaagantachari: ‘Jirika ijiwari pompiratani, japaatakimiro pajyaagawo’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ikanta jirika ajyaagantaniri ikaimakiri jompiratani, josampitakiri: ‘¿Iitama pantakiri? Nokimaki ikantaitana. Nokowi poñaayinawo okaatzi pantawaitakinari. Tima ari okaatapaaki pijiwatziri nompiratanipaini’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ari ikantashiritanaki jirika ompirataari: ‘¿Tsikatya nonkantyaaka iroñaaka? Jomishitowatyiina ompiratanari. Tii okantzi nompankiwaiti, aririka nonkamitanti impashitaitina, owanaa nonkaaniwintya’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ipoña ikantashiritzi: ‘Niyotaki iita nantiri jaapatziyantaitinari pankotsiki aririka jomishitowaitakina’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Japatotakiri ikaatzi iriiwitziriri iwinkathariti, ikantakiri itakawori: ‘¿Tsikama ikaatzi piriiwitziri nowinkathariti?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ikantzi irirori: ‘Niriiwitziri ikaatzi 100 inchatonaa jowaitzi yiinkantsi’. Ipoña ikantziri: ‘Jiroka piriiwiri, thaanki posankinati, apa inkaatai 50 inchatonaa piriiwitiri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ipoña josampitakiri pashini ikantziri: ‘¿Iiroka tsikama ikaatzi piriiwitzi?’ Ikantzi: ‘Niriiwitzi okaatzi 100 ipiyotakoitziro trigo’. Ipoña ikantziri iijatzi: ‘Jiroka piriiwiri, posankinati, apa onkaatai 80 ipiyotakoitziro’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ikanta jirika pinkathari, joñaagantakiri jompiratani tima iñaakiri imapiro jiyotzi tsika inkinakairo kantainchari. Ari ikantayitari atziripaini iroñaaka, imatatya jiyotzi tsika inkinakairo jaapatziyantyaariri ijyininka, janairi tsika ikanta kimisantzinkariiti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Irojatzi ikantantanakari Jesús: “Ontzimatyii piyoti paapatziyantyaawo pajyaagantayitari iroñaaka onkantawitya tii opantapirotawo, iro onkantantaiyaari jaapatziyaitaimi paata iiroka janta inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Itzimirika tyaaryootaintsiri kapichiini, iriitaki tyaaryoopirotaatsini. Itzimirika kaaripiroshiritatsiri kapichiini, iriitaki mapirotaironi inkaaripirotai. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Tiirika pityaaryoowintziro ajyaagawontsi kaari opantapirotawo jaka, tikaatsi amiintimini iroopiroriki. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Tiirika pityaaryoowintziro ashinintsi, tikaatsi pimini pashityaari iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Tikaatsi matironi jantawaitiniri apiti ompiratantaniri. Apaani inkowapiroti imonkaatiniri jompiratariri, iriima pashini, inkisaniintanakiri. Ari okimitsitari iijatzi: Tikaatsi matironi jantiniri Pawa ikowakaantziri irirori, aririka inkinkishiritakoitiro ajyaagawontsi inkimitakaantanakiro iroorikami ompiratyaarini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ari ikaatzi ikimaiyakini Fariseo, tima irijatzi ashiminthatawori ajyaagawontsi, ishirontaminthatakari Jesús ikimiri ikantayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ipoña ikantanakiri: “Piyotzi potzikaawintaiyani iiroka iiro jiyotantzimi atziri, iro kantzimaitacha jiyotzimiro Pawa okaatzi pikinkishiritari. Tima okaatzi iroopirotzimotziriri atziri, ipinkimatziro Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tima pairani ikinkithatakoitakiro Ikantakaantaitani ipoña josankinari Kamantantaniriiti. Ipoña ikinkithataki iijatzi Juan. Ikimatziiro iroñaaka atziriiti Kamiithari Ñaantsi tsika ikanta ipinkathariwintai Pawa. Antawoiti ikowi iñiiro okimitawo ishintsitaitzi aririka jowayiritaitya. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tii opomirintsita apirotaiya paata kipatsi iijatzi inkiti, iro kantzimaitacha iiro apirotzimaitaa Ikantakaantaitani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Itzimirika ookironi iina, aririka jagai pashini tsinani, imayimpiriwintakiro itawitawori. Ari ikimitari iijatzi agaironi tsinani jookiri oimi, imayimpiritaki irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tzimatsi atziri ajyaagantachari, owaniinka ikithaatapiinta. Jaakowintawo kitiijyiriki joimoshirinka owaniinka jowapirowaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tzimitacha iijatzi apaani ashironkaawaitachari jiita Lázaro, ithonka ipathaawaitaki jirika. Ari jomaryaapiinta jakakiroki ipankoki ajyaagantzinkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iriitaki kowatsiri jaayitiro jowaryaayitziri jowanawo ajyaagantachari. Pokatsi otsitsi ithotziniri iwathaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ikanta paata kamaki ashironkainkari, jaanakiri imaninkariti Pawa, jataki isaiki Abraham. Ipoña kamitaka iijatzi ajyaagantachari, ikitaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ikanta janta sarinkawiniki, ojyiki ikimaatsiwaitaka jirika ajyaagantawitachari. Jaminakotakiri intaina iñaatziiri Abraham itsipatakari Lázaro. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ari ikaimanaki irirori, ikantzi: ‘Chariní, Abraham, pinishironkatina. Potyaantiri Lázaro jamaajaitakina kapichiini jiñaa nomiritawatyaari, tima itaaniintatyaana shintsiini paampari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ikantanaki Abraham: ‘Nochariní, poshirityaawo pajyaagawo pairani, iijatzi ikimita Lázaro joshiritawo jashironkaawaitakari. Iro kantzimaitachari kimoshiri ikanta irirori jaka, irooma iiroka ontzimatyii pinkimaatsiwaitaiya. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tikaatsi pinkini pimpoki, tzimatsi antawoiti impiita otzikakairi, iiro okantzi iijatzi niyaatashitimi iiroka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Iikiro ikantawitatya irirori: ‘Pinkimi nokantzimi chariní, potyaanti jatatsini isaiki nowaapati. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tzimatsi janta ikaatzi 5 nirintzi, pinkamantiri iiro ipokanta irirori jaka, ojyiki jashironkaita’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ari ikantzi Abraham: ‘Tzimatsi Ikantakaantakiri Moisés, tzimatsi iijatzi ikantayitakiri Kamantantaniri, iro inkimisantiri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ipoña ikantzi iijatzi: ‘Iirotyaami, Chariní, Abraham. Tzimatsirika apaani kamatsiri kamantairini añaatsiri atziri, ari jowajyaantairo kaaripirori jamiyitari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Iikiro ikantanakitzi Abraham: ‘Tima tii ikimisantziro ikantayiwitari Moisés iijatzi ikantayitakiri Kamantantaniri, iirotya ikimisantaajaitziri inkamantawityaari kaminkari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ipoña Jesús ikantanakiri jiyotaani: “Ari intzimapiintatyi antakaantironi kaaripirori. Inkantamachiitiri jirika. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tsikarika itzimi antakaakirini kaaripirori iintsi awintaanari, ari jowasankitaayiitairi. Iro kamiithatatsimi inthayiitiniri mapi ikintsiki, jowiinkaitakiri inkaariki, ari onkantya iiro ikaaripirotakaantzimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ontzimatyii paamaakowintya iiroka. Tima intzimirika antzimotimini kaaripirori, pinkaminairi. Aririka jowajyaantanairo jantayiwitakari, pimpiyakotiro jantzimowitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ari okimitari iijatzi. Tzimatsirika atziri ojyiki jantzimotapiintakimiri, okimiwitatyaawo onkaati 7 japiipiintiro kitiijyiriki, ontzimatyii papiipiintiri pimpiyakotiri aririka impokashitapiintakimi inkowakotimi pimpiyakotairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ikanta Otyaantapiroriiti, ikantanakiri Jesús: “Nokowi poshiritakaapirotina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ipoña ikantzi Awinkathariti: “Onkantawitatya iiro antawoititzi poshiritaina, onkimityaawo okithoki oryaanikitatsiri pankirintsi, aritaki pimatakiro antawoiti inchato katziyainchari, pinkantiro: ‘Pishirinki, piyaati pinkatziyi janta inkaariki’. Nonkanti, ari imatatya”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Aririka intzimi pompiratani, piñaawairi jariitaiya jojyiwawaitzi powaniki, jaamaakowintari pipira ¿arima pinkantawairi: ‘Patyootapaina?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Aña iiro, apa pinkantawairi: ‘Ponkotsitapai owanawontsi. Powathakitya inkini poyiitina, irojatzi nowantatyaari, niraki nomiri iijatzi. Impoña pimpoiti iiroka powaiya’. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Arima pimpaasoonkitakiri okaatzi jantakiri pompiratani? Aña iiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ari pinkimityaari iijatzi iiroka, aririka pimonkaatakiro okaatzi inintakaimiri Pawa, ompoña pinkanti: ‘Iiro asagaawintawaita jompirayiitai, tima apa amonkaamachiitiro okaatzi ikowakaitakairi antiro’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ipoña jawisanaki Jesús jiyaatiro Jerusalén-ki, ikinanakiro Samaria-ki ipoñaanakawo Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ikanta jariitapaaka nampitsiki, ari itonkiyotawakari 10 shirampari pathaawaitatsiri, intaina ikatziyaiyapaakani. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ikaimaiyini, ikantzi: “¡Yotaanarí Jesús, pinishironkataina naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ari jaminanakiri irirori, iñaatziiri ikatziyaiyani, ikantziri: “Piyaatashitiri Ompiratasorintsitaari jaminawakimiro pipathaawo”. Ikanta jiyaataiyanakini, omapokashitaka opiyanaka iwathaawo, shintsiyitanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ikanta apaani jiñaakiro jishitakotanai ipathaawaitzi, thaaminta ipiyaa irirori, ikimoshiriwintanakiri antawoiti Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jotziirowashitapaakari iitziki Jesús, ipaasoonkitapaakiri. Jirika piyaachari Samaria-jatzi jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ipoña ikantzi Jesús: “¿Tiima 10 ikaatzi shintsitaatsiri, tsikama ikinakika pashini? ");
INSERT INTO cpcNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tikaatsi nojyininka piyaatsini inkimoshiriwintairi Pawa impaasoonkitiri, apa ipiya pashinijatzi atziri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ari ikantanakiri Jesús pathaawaiwitachari: “Pinkatziyi, piyaatai. Iro oshinchagaimiri poshiritaana”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ipoña Fariseo josampitakiri Jesús, ikantziri: “Tsikapaiti itanatyaawo impinkathariwintantai Pawa”. Ari jakanaki irirori: “Omapokashitaiya impinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iiro ikantaitzi: ‘Jiroka jaka. Jironta janta’. Tima aritaki pinkatharishiriwintantai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ipoña ipithokashitanakari jiyotaani, ikantziri: “Ari pinkowawitaiya paata piñiirimi kapichiini jirika Itomi Atziri, iiro okantzimaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ari pinkimaki inkantaiti: ‘Jirika jaka’. Pashini kantatsini: ‘Jirinta janta’. Iiro piyaatashitziri, iiro poyaatziri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aririka impiyi Itomi Atziri, inkimitapaiyaawo oporiki ookathawontsi, ompoñaanatya tsika iwiyaa kipatsi irojatzi othapitapaa. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Aña itawatya iñiitawakiro inkimaatsitaitya antawoiti, inkisaniintawaitaitiri jirikaiti atziriiti tzimayitatsiri iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tima onkimityaawo tsika okanta pairani iiniro isaikawita Noé. Ari onkimitsitaiya iijatzi aririka impokimatai Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Inimotziri atziri jowawaiyita, jirawaitaiyini, jaawakaayita iijatzi. Irojatzi ityaantanakari Noé shintsipaaki jiwitsikakiri. Okanta oonkanaka kipatsiki, apirotaka maawoni atziri ipiinkaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ari onkimityaawo iiniro isaikawita pairani Lot. Inimotziri atziri jowaiyani, jirawaitaiyini, jiyomparitaiyani, ipankiwaitaiyini, jiwitsikaiyini ipanko iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Iro kantzimaitacha imonkaatapaaka kitiijyiri ishitowantanakari Lot nampitsiki Sodoma, omapokashitaka iparyaapaaki antawoiti paampari, ari japirotakari maawoni atziri itaga. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Aritaki onkimitagaiyaari iijatzi aririka impiyi Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tzimatsirika saikatsiri jikokiroki ipanko, ari impoñaanatya ishiyi, iiro ityaapanaatzi jaapanaati tsika oitya. Itzimirika saikatsini jowaniki, ishiyi tsika ikanta, iiro ipiyapanaata. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Pinkinkishiritakotiro okaatzi awijyimotakirori iina pairani Lot. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ikaatzi itakowaitachari apaniroini jantayitziro inintashiyitari, ari impiyaashitaiya. Iriima inkaati kamawintinani jantanairo nokowakairiri naaka, aritaki jawisakoshiritai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Iikiro ikantatzi Jesús: “Tzimatsi tsipatawakaachani imayi. Jagaitai apaani inkitiki, iriima pashini jookaitanairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tzimatsi apiti tsinani tsipatawakaachani otoonkawaitzi. Jagaitai apaani inkitiki, irooma pashini jookaitanairo. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Isaiki apiti atziri jowaniki. Jaagaitai apaani inkitiki, iriima pashini jookaitanairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ipoña josampitanakiri ikantzi: “¿Tsikatya janta Pinkatharí?” Ikantzi Jesús: “Tsikarika isaiki kaminkari, ari impiyowintyaari amimpori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ipoña jojyakaawintanakiro Jesús onkantya jamanaitantyaariri kitiijyiriki, iiro jowajyaantantaitawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ikantzi: “Tzimatsi apaani nampitsi, ari isaikiri kaaripirori pinkathari, tii ipinkathatziri irirori Pawa, iri owatsipiro tii ipinkathatziri atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ari osaikiri iijatzi tsinani kamatsiri oimi. Opokashitakiri kaaripirori pinkathari, okantziri: ‘Nokowi pinkaiminari kisaniintanari, piwitsikainawo awijyimotanari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tii ikowawita pinkathari. Ipoña ikantashiritanaki: ‘Tii nopinkathatziri Pawa, iijatzi nokimitairi atziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Iro kantacha jiroka kamatsiri oimi, ontzimatyii nantiniro kamiithari okowiri. Nosamawokari aririka oñaashirinkina ompiyapiyatashitina’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ikantzi Jesús: “Piñaakiro ikantashiritakiri kaaripirori pinkathari. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Iri mapirotzirori Pawa irirori, iiro ijyinkaa jantainiri kamiithari jiyoshiitairi, aakowintanaawori jamanari kitiijyiriki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iikiro ikantatzi Jesús: “Iiro ijyinkaita jantantaityaawori kamiithari. Iro kantacha aririka impiyapaaki Itomi Atziri, ¿iikiroma jiñaapaakityi awintaapiintyaarini kipatsiki?” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tzimayitatsi kinkishiritachari kamiithashiri jinatzi. Ipoña imanintashiriwaitziri pashini atziri. Irootaki jojyakaawintantanakariri Jesús, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tzimatsi apiti atziri jiyaataki tasorintsipankoki jamaña. Fariseo jinatzi, iriima pashini iri kowakotziriri kiriiki ijyininka. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ikanta ikatziyapaaka Fariseo jamana, ikantzi: ‘Pawa, antawoiti nopaasoonkitzimi, tima tii nokimitari naaka pashini atziri, koshintzi jinatzi, tzipinashiri ikanta, mayimpiri jinatzi, ari ikimitakari jirika kowakotziriri kiriiki ijyininka. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Apitijatzi notzitapiintawo nowanawo awisayitzi kitiijyiri jimakoryaantaitari, nookapiintzi kiriiki ikaatzi ipinaitanari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ipoña irirori kowakotziriri kiriiki ijyininka, ikatziyapaaka jantyaatsikiini, oiyotapaaka jamana. Tima okatsitzimoshiryaanakiri, ikantzi: ‘Pawa, pinishironkataina naaka, kaaripiroshiri ninatzi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ikantzi Jesús: “Iriitaki jaayiitakiri kamiitha jirika, kamiithashiri ikanta jiyaatai ipankoki, tii ikimitari pashini. Tima tsikarika itzimi ñaapirowaitachari iroñaaka, ari intsinampashiritakaitairi. Iriima tsika itzimi tsinampashiriwaitatsiri iroñaaka, ari iñiiro iñaapirotakagaitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ipoña jamayiitapaakiniri Jesús iinchaaniki, ikowaitzi jotirotantawatyaari kapichiini jako. Iro kantacha jiyotaani Jesús, ikisawakiri amayitziriri iintsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Irojatzi ikantantanakari Jesús: “Pishinitiri iinchaaniki impokashitina. Iiro pithañaana. Tima inkaati kimitaiyaarini irirori, iriitaki ñaagaironi ipinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Imapiro, iirorika ipinkathaitziri Pawa inkimitakoityaari ikanta iintsipaini, iirora iñaitairo ipinkatharitai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ikanta apaani pinkathari josampitakiri Jesús, ikantziri: “Kamiithari Yotaanarí, ¿iitama nantiri noñaantaiyaawori kantaitachani kañaanimintotsi?” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ipoña jakanaki Jesús, ikantzi: “¿Iitaka pikantantanari: ‘kamiithari pinatzi?’ Apaniroini ikantakaawo Pawa ikamiithatzi, tikaatsi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Piyotakotakiroma Ikantakaantaitani, kantatsiri: Iiro pitsitokantzi. Iiro pimayimpiritzi. Iiro pikoshitzi. Iiro pithiiyakotanta. Iiro pamatawitantzi. Pimpinkathatiri ashitzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ari jakanaki mainari, ikantzi: “Yotaanarí, nothotyaakiro maawoni irojatzi nitanakawo pairani iiniro niryaanitapaaki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ikanta ikimakiri, ikantzi Jesús: “Tzimatsi apaani kowityaapainchari kaari panti. Pimpimantiro okaatzi pashitari, pimpashiyityaari ashironkaachari. Tima ari piñagairo pinintagaiya inkitiki. Pimpokanaki, poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ikanta ikimawaki, owashiri ikantanaka, tima ajyaagantzinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tima iñaakiri Jesús antawoiti jowashiritanaka, ikantanaki: “¡Imapiro opomirintsita jiyaatai ajyaagantzinkari impinkatharitai Pawa! ");
INSERT INTO cpcNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tima iiro okantzi intyi piratsi camello imooki kithapi, iro owatsipiro ompomirintsitya intyi ajyaagantzinkari ipinkatharitai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ikantayitanaki ikaatzi kimakiriri ikantaki Jesús: “¿Iitatyaakama awisakoshiritaatsini?” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ipoña ikantzi Jesús: “Tzimatsi oitayita pomirintsitzimotyaarini atziri, iriima Pawa tii opomirintsitzimotari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ari ikantanaki Pedro: “Jirika nokaataiyakini naaka, nookayitanakiro tzimimoyitanari, noyaataiyakimini”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ikantanaki Jesús: “Imapiro, tzimatsirika kowanairori impinkathariwintairi Pawa, irootaki jookawintantanakawori ipanko, ashitariri, iririntzi, iina, ipoña jowaiyaniiti, ");
INSERT INTO cpcNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tima ojyiki impayitairiri Pawa jirika, ari anaanakiro okaatzi jookawintanakiri. Ari inkimitagairi iijatzi paata aririka iñiiro añaanimintotsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ipoña Jesús japatotairi kaatatsiri 12 jiyotaani, ikantziri: “Aatatyi iroñaaka Jerusalén-ki. Ari imonkaatyaari onkaati awijyimotirini Itomi Atziri, tima irootaki josankinatakoitakiriri pairani Kamantantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ari jaakaantaitiri, jayiri atziri kaari ajyininkata. Antawoiti ishirontaminthawaitaityaari, inkimaatsitakaityaari, jiiwapoowaitaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Aririka onkaataki impajawaitaitiri, ari jowamagaitiri. Iro awisawitatya mawa kitiijyiri, ari jañagai iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iro kantzimaitacha, tii ikimathatziro jirikapaini ikaatzi kimawitainchari, tima tii ikowaitzi inkimathatakaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ikanta Jesús ariitzimataka nampitsiki Jericó. Ari isaiki kaari aminatsiri aatsinampiki ikamitantzi impashiityaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ikimaki kaari aminatsini, josampitakiri awisayitatsiri atziri, ikantziri: “¿Iita pokatsiri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ikantaitanakiri: “Ipokatzi Jesús, jiitaitziri Nazaret-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Irojatzi ikaimantanakari, ikantzi: “¡Jesús, icharinitari David-ni, pinishironkataina naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ojyiki ikisawiitanakari jimairitantyaari. Iikiro ikaimanakitzi shintsiini, ikantzi: “¡Icharinitari David-ni, pinishironkataina naaka!” ");
INSERT INTO cpcNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ari ikatziyapaaka Jesús, ikantzi: “Pamakinari jaka”. Ikanta jamaitapaakiniri, josampitawakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Ikantziri: “¿Tsikama pikowi nonkantaimi?” Jakanaki kaari aminatsiri, ikantzi: “Nokowi nokiryagai, Pinkatharí”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ikantzi Jesús: “Kantatsi pokiryagai, iro oshinchagaimi pawintaana”. ");
INSERT INTO cpcNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Omapokashitanaka jaminanai, joyaatanakiri Jesús, kimoshiri ikantawintanakari Pawa. Ikanta atziriiti jiñaakiro okaatzi jantakiri Jesús, jimatanakiro iriroriiti ithaamintawintanakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ikanta jariitapaaka Jesús Jericó, janiitapaakiro nampitsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ikanta apaani shirampari ijiwari kowakotziriri kiriiki ijyininka jiita Zaqueo. Ajyaagantzinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ikowapirotaki irirori jiñiiri Jesús. Iro kantacha tii okantzi tima ojyiki atziri otzikakiriri, ikaaporityakitziini iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ipoña jiiwatanaki Zaqueo, atiitapaaki inchatoki inkini iñiiri Jesús, tima ari inkinapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ikanta jariitapaaka jatiitaki, jaminapaaki jinoki, jiñaapaakiri, ikantziri: “Zaqueo, payiitanaki thaankiini, tima ari noshiritawo nomayimotimi pipankoki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Thaankipiroini jayiitanaki Zaqueo. Kimoshiri jaanakiri ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ikanta jiñaitakiri, ñaawaitanaki atziriiti ikantzi: “¿Iitama ityaapankotantariri Jesús kaaripiroshiritatsiri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ari ikantaki Zaqueo: “Pinkatharí, kantatsi nompiri ashironkainkari kajyitani najyaagawo. Tzimatsirika iita namatawitakiri nokoshitziri, ari noipiyainiri onkaati 4 nayitakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ikantanaki Jesús: “Iroñaaka piñiiro pawisakoshiritai. Tima pimatanairo pikimitakotanaari Abraham-mirinkaitipirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tima iro ipokantakari Itomi Atziri jaminaminayitairi ikaatzi piyaashiwitainchari jowawisaakoshiriyitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Irojatzi ikimisantaiyakini atziriiti ikinkithatakotakiri Jesús. Ipoña jojyakaawintanakiniri, tima iñaajaantaki atziriiti koñaawoini impinkathariwintantai Pawa, tima jiñaakiro irootaintsi jariitzimataiyaani Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ikantanaki: “Tzimatsi apaani jiwari jiyaataki pashiniki nampitsi, impinkatharitakaitiri, impoña impiyi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Japatotanakiri 10 jompiratani, ipanakiri 10 kiriiki, ikantayitanakiri: ‘Pantawaitakairi kiriiki nopanakimiri, irojatzi nompiyantapaatyaari’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Iro kantacha tzimatsi kaari kowirini impinkathariwintanti. Jotyaantaitaki kantatsini: ‘Tii nokowaiyini impinkathariti’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ikanta ipiya, aritaki ipinkatharitakaitakiri. Japatotapairi jompiratani ipayitanakiri kiriiki, ikowi iñiiri tsika ikanta jantawaitakaakiri iiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jitapaakawo ipokaki apaani, ikantapaaki: ‘Pinkatharí, nojyiñaakiri piiriikiti, nagai pashini ikaatzi 10’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ikantanaki irirori: ‘Kamiithataki nompiratani, kapichi pityaaryootaki, aritaki piñaakiro pijiwawintiro onkaati 10 nampitsi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ari ipokapaaki pashini jompiratani, ikantapaaki: ‘Pinkatharí, nojyiñaakiri piiriikiti, nagai pashini ikaatzi 5’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Iijatzi ikantanakiri irirori: ‘Ari pinkimityaari iiroka, ari piñaaki pijiwawinti onkaati 5 nampitsi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ipokapaaki pashini, ikantapaaki: ‘Pinkatharí, jirika piiriikiti kamiitha noponatakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tima antawoiti nothaawantakimi imapirotatziimi pimashirinkatzi, tii piñaakonita pojyiñaantariri piiriikiti’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ikantanaki irirori: ‘Kaaripirori nompiratani pinatzi. Iiroka apishityaawoni okaatzi pikantakinari. Piyowitaka owanaa nomashirinkatzi, tii noñaakonita nojyiñaantariri noiriikiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Piñaawita iiro pimatziro iiroka, paminimi iitya antawaitakairinimi noiriikiti, ari ijyikiniintakimi iroñaaka, iri pimpawainarimi nopiyaa’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ari ikantziri atziri piyotainchari: ‘Payiri kiriiki, pimpiri ojyiñaakiriri ikaatzi 10’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ikantaiyanakini atziri: ‘Pinkatharí, ¿iitama impantaityaariri, tima tzimaki irirori 10 kiriiki pipakiriri inkaanki?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Iikiro ikantatzi ashitariri iiriikiti: ‘Iitarika otzimimotakiri, ari ontzimimotakiri ojyiki. Iriima kaari otzimimotzi, iikiro jiyaatatyi iñiiro iiro otzimimopiroyitairi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ikantaki iijatzi: ‘Pamakiri ikaatzi kisaniintanari kaari kowatsini nompinkathariwintiri, nokowi noñiiri powamairi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ithonkanakiro ikantakiri Jesús, iiwatanaki jiyaatiro Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ikanta jariitzimataka nampitsiki Betfagé otsipatakawo Betania omontinampitakawo otzishi Olivo. Ari jotyaantakiri Jesús apiti jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ikantakiri: “Piyaati nampitsiki amontitakari. Ari piñiiri iwonkiri burro inthatakotya, tikira ityaakaitariita. Pintharyaakotiri, pamakinari jaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Aririka josampiitawakimi: ‘¿Pinkantirika pithataryaakotantariri burro?’ Pinkantanakiri iiroka: ‘Ikowatziiri Pinkathari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jataiyanakini jotyaantaitakiri, jiñaakiro okaatzi ikantaitakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ithataryaakotapaakiri burro. Josampitakiri ashitariri, ikantziri: “¿Pinkantirika pithataryaakotantariri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ikantanaki irirori: “Ikowatziiri Pinkathari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Irojatzi jamantakanariri. Jowankitaitakiniri manthakintsi imitzikaaki, ityaakotanakari Jesús jirika burro. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ikanta janiitakaanakiri Jesús burro, joomaankashiitanakiri manthakintsi aatsiki tsika inkinanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ikanta jiyotaapiintakiri Jesús, oirinkimataka otzishiki Olivo, ikaimaiyini ithaamintawintanakari Pawa, tima iñaayitapiintakiro itasonkawintantaki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ikantaiyini: ¡Aatsikitataiki awinkathariti! Tasonkawintaari jinatzi, tima Pinkathari jiitaitziri otyaantakiriri. ¡Isaikakaayitairi kamiitha nampitawori inkitiki! ¡Iro kamiithatataitatsi otzimimotziri jowaniinkawo Pawa nampitawori ojinokitajaantzi inkiti! ");
INSERT INTO cpcNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ikanta Fariseo saikayitaintsiri iijatzi janta, ikantakiri Jesús: “Yotaantanirí, pinkijyiri piyotaani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jakanaki Jesús, ikantzi: “Aririka nomairyaakiri ikaatzi kaimayitaintsiri, kimitaka ari onkaimanakimi mapi iroori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ipoña jariitzimatapaaka Jesús Jerusalén-ki, jiraakotapaakawo jiñaapaakiro. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ikantzi: “¡Owa onkamiithatimi pinkimathataajaitawakiromi iroñaaka, iroora kitiijyiri piñaantaiyaawori pisaiki kamiitha! Iro kantzimaitacha iiro okantzi tima tzimatsi ikantakagaitakimi kimiwaitaka pisoryaakitatyiimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tima irootaintsi impoki kisaniintzimiri, jiwitsikashitapaakimi japirotantimiri. Inthonka jotzikapaakimi iwiyaara potanto, iiro piñiiro tsika pinkini pishiyi. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ari impookakoitakimi, jashiryaitimi maawoni. Iiro jiñaitairo mapipaini okaatzi piwiryaayitachari iroñaaka, okantakaantziro tii piyotawakiri pokashitakimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ipoña ityaapaaki Jesús tasorintsipankoki, jomishitowapaakiri pimantayitatsiri iijatzi ikaatzi amanantayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ikantayitziri: “Pairani josankinaitakiro kantatsiri: ‘Nopanko inatzi jiroka, ari jamanapiintaitinari’. Iro kantzimaitachari iiroka pamatawitantapiintaki janta pipimantayitzi, pikimitakaantakiro koshintzipanko”. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ari ikantapiintatya Jesús jiyotaantzi kitiijyiriki tasorintsipankoki. Iro kantacha ijiwari Ompiratasorintsitaari, itsipatakari Yotzinkariiti ipoña Antaripiroriiti, jaminaminatanakiro tsika inkinakairi intsitokakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Tii okantzimaita iñiiro tsika inkinakairo, tima owakimpita ikantaiyakani atziriiti ikimisantziri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ikanta Jesús jiyotaayitakiri atziri tasorintsipankoki, ikinkithatakairi Kamiithari Ñaantsi. Irojatzi ipokantapaakari ijiwari Ompiratasorintsitaari, itsipatakari Yotzinkariiti, ipokaki Antaripiroriiti iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Josampitapaakiri Jesús, ikantziri: “Pinkantina, ¿iitama otyaantakimiri poñaagantiro pishintsinka?” ");
INSERT INTO cpcNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ipoña jakanaki Jesús, ikantziri: “Tzimatsi iijatzi nosampitimiri naaka, ontzimatyii pakina. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tima jowiinkaatantaki Juan-ni, ¿iitama otyaantakiriri? ¿Pawama? ¿Iriima otyaantakiri atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ari ikantawakaiyanakani irirori: “Aririka ankantakiri Pawa otyaantakiriri, ari inkantanakai: ‘¿Iitama kaari pikimisantantari?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Irooma ankantiri: ‘Atzirimachiini otyaantakiri’, ari impichaitakai. Tima maawoni atziriiti ikantaiyini Kamantantaniri jinatzi Juan-ni”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Irojatzi ikantantaiyakani: “Tii niyotzi iita otyaantakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ari ikantsitanakari Jesús irirori: “Iijatzi naaka, iiro nokamantzimiro iita otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ipoña Jesús jojyakaawintanakiniri atziriiti, ikantzi: “Tzimatsi apaani pankitzirori chochokimashi. Ipoña jaminaki iitya aminironi iwankirimashi, jataki irirori intaina, osamani isaikaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ipoñaashitaka jotyaantai jompiratani jagaatimi okithoki iwankiri. Ikanta jiñaawakiri antawairintzi, ipajawaitawakiri, joipiyairi tikaatsi jaanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jotyaantaki pashini. Ari ikimitaakiri, ikisawaitawakiri, itsitokawaitakiri, joipiyairi iijatzi tikaatsi jaanai. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ipoña jotyaantaki mawatanaintsiri jompiratani. Ari ikimitaitakiri iijatzi, jantawaitawakiri, joipiyakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ikantzi ashitawori iwankirimashi: ‘¿Tsikatya nonkantyaaka? Iriirika notyaantaki nitakotani notomi naaka, ari impinkathatakiri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ikanta antawairintzi jiñaawakiri itomi ipokaki, ikantawakaiyani: ‘Jirika ipokaki ashitaiyaawoni paata pankirintsimashi. Thami owamairi, ayiroota aaka’. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Jaawakiri, jaanakiri othapiki pankirintsimashi, itsitokakiri. ¿Iitama jantiri ashitawori pankirintsimashi? ");
INSERT INTO cpcNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Tima ipokanaki irirori, intsitokakiri maawoni aamaakowintawori jowani, jaminai pashini atziri”. Ikanta jirikaiti ikaatzi kimakirori ikantakiri Jesús, ikantaiyanakini: “¡Onkamintha iiro imata!” ");
INSERT INTO cpcNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ipoña Jesús ikimpoyaanakiri atziriiti, ikantanakiri: “¿Iitama okantziri osankinatainchari? Imanintawitakawo mapi witsikirori pankotsi, Iro kantzimaitacha jowatzikaitairo mapi pankotsinampiki, ikimitakagaitaawo iroorikami tzinkamitsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Jiroka okantakota mapi: Intzimirika paryaatsini osaiki iroori, ari jiñaakiro intankawaiti. Iriima inkaati awitsinagairi, ari jiñaakiro ompichiiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ari ikowawitaka ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti jaakaantirimi Jesús, tima jiyotaki iriitaki ikinkithatakotzi. Tiimaita okantzi, owanaa ithaawantakari atziri piyotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ipoña jotyaantaitaki amawinawairintzi, inkimitapaatyaari atziri kamiithashiriri, ikowaiyawitani inkompitakaiyaarimi Jesús, inthawitakotzimaityaari pinkathariki. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ikanta jariitaiyakani, ikantapaakiri Jesús: “Yotaantanirí, okaatzi piñaanitari iiroka iroopirori inatzi, kaari inintakaantashitari atziri. Piyotaantziro iiroka tyaaryoopiroini jinintakaantziri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Okamiithatzima ampiri kiriiki ikowakotantziri Pinkathari César?” ");
INSERT INTO cpcNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Iro kantzimaitacha Jesús jiyotawaki ikowatzi jamatawitiri osampitakiriri, ikantanakiri irirori: “¿Iitama piñaantashiwaitantanari? ");
INSERT INTO cpcNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Incha poñaayinari kiriiki. ¿Iitama ashitawori ipoo ojyakaawintainchari? ¿Iitama ashitawori iwairo iijatzi?” Ikantaiyini: “Jashi César”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Iikiro ikantatzi Jesús: “Tima iri César ashitari, pantantyaanari ikowakaimiri. Irooma jashitari Pawa, pantantyaanari ikowakaayitzimiri irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tii ikitsirinkiri inkompitakaiyaari, iyokitzi ikanta ikimakiri, tikaatsi inkantanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ipoña ipokaiyakini Saduceo jiñiiri Jesús. Iriitaki Saduceo kantayitatsiri iiro jañagai kamayitaintsiri. Josampitapaakiri Jesús, ");
INSERT INTO cpcNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","ikantapaakiri: “Yotaantanirí, josankinataki pairani Moisés-ni, kantatsiri: ‘Aririka inkami shirampari, jookawintanairo iina. Iirorika jowaiyantakairo, okamiithatzi jagairo iririntzi iinantaiyaawo irirori. Aririka owaiyantai tsinani, kimiwaitaka iriirikami ashityaarini oimi kamaintsiri’. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Thami ojyakaawintawakiro: Tzimatsi 7 shirampari, iririntzi jinayitatzi. Itawori itzimi jaawitaka iina, tikira osamanitzi, kamaki, tii jowaiyantakairo iina. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ipoña jaawitaawo pashini iririntzi apititatsiri itzimi. Ari ikimitsitakari irirori, kamaki, tii jowaiyantakairo. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ipoñaawitapaaka mawatanaintsiri itzimi, iijatzi ikimitakari irirori. Ari ikantakari maawoni ikaataiyakini 7 iririntzi. Tikaatsi apaani owaiyantakaironi tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Okanta osamanitaki kamai iijatzi iroori. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aririkami jañaayitaimi paata ikamayitaki, ¿iitama oimipirotari tsinani? Tima ari ikaatzi 7 iinantawitakawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ari jakanakiri Jesús, ikantanakiri: “Apa jaayitzi iina atziriiti añaayitziri iroñaaka jaka, jaakaawakaayitawo iina iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Iriima inkaati kitsirinkaironi jañaayitai paata ikamawitaka, iiro jaayitai iina, iiro jaakaawakaayitaa iina iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tima iiro jiñaapairo inkaamanitapai janta, inkimitapaiyaari maninkariiti, tima itomi Pawa jinayitaatzi jañaayitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Irooma ikantakota jañaayitai kamayitaintsiri, ¿tiima piñaanatziro josankinari Moisés-ni tsika ikanta Pawa jiñaanatantakariri oota kitochiimaishi? Ikantakiri: Moisés, Naaka Pawa, ipinkathatziri Abraham, Isaac, iijatzi Jacob. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ari ayotziri, añaayitatsi irirori, tima tii jimatziro kaminkari impinkathatiri Pawa, apa ipinkathatziri añaayitatsini. ¿Ñaakiro? Tima ikaatzi kamayiwitachari, irojatzi jañiimotziri Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ari ikantanaki Yotzinkari: “Yotaantanirí, ari pimatajaantakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tikaatsi kowanaatsini josampitanairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ipoña josampitantaki Jesús, ikantzi: “¿Iitama ikantantaitari, ‘jirika Cristo-tatsini icharini jinatyi David-ni?’ ");
INSERT INTO cpcNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aña iri David-ni osankinatakiro kantatsiri: Jiñaawaitaki Pinkathari, ikantawairi Nowinkathariti, ikantziri: Pisaikapai nakopiroriki, ampinkathariwintanti, ");
INSERT INTO cpcNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Irojatzi paata nowasankitaantaiyaariri ikaatzi kisaniintayitakimiri, Ari paatzikairi pinkimitakaantairi pimakoryaakiiminto. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ñaakiro, ikantsitataita David-ni irirori: ‘Nowinkathariti jinatzi Cristo’. ¿Tsikama inkini incharinityaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","maawoni atziriiti ikimaiyakirini Jesús ikantakiri jiyotaani: ");
INSERT INTO cpcNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Paamaiyaari Yotzinkariiti. Owanaa jinintziro jowaniinkapirowaitya, inkantakaapirowaityaawo iithaarithanthanaa. Ikowi pinkatha jiwithatapiintaityaari aririka jiñaitiri. Aririka jiyaati pankotsiki japatotapiintaita, ikowapiintziro josatitya niyankiniki. Ari ikimitari aririka jowaiyaani ijyininka, ikowapiintzi josatitya. ");
INSERT INTO cpcNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jathaagayitawo iijatzi kamatsiri oimi jaapithayitziro opanko. Iro josamaninkantawori jamanayitapiinta iiro jiyotantaitari. Iro kantzimaitacha ojyikira jowasankitaayiitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ari jaminaminthatziri Jesús ajyaagantzinkari jotiyitziri iiriikiti jotiyitapiintziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Opoña opokapaaki tsinani kamatsiri oimi ashironkainkawo inatzi, otitapaaki iroori apipintyakiini kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ikantzi Jesús: “Imapiro anaantaki jiroka tsinani, anaakiri ikaatzi otiwitainchari. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tima ikaatzi otiwitainchari ojyiki ikajyaakaawitariri Pawa, jotitashitakari tzimagaantatsiri iiriikiti. Irooma jiroka kamatsiri oimi, apintziryaakiri otitakiri oiriikiti amanantantyaarimi owanawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tzimatsi kantayitaintsiri: “Kamiitha inatzi mapi jiwitsikantaitawori tasorintsipanko, owaniinka okanta”. Ipoña ikantanaki Jesús: ");
INSERT INTO cpcNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Okaatzi piñiiri witsikayitainchari, irootaintsi japiroitiro impookaitiro, iiro iñagaitairo piwiryaawitainchari mapi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ipoña josampitaitanakiri, ikantaitziri: “Yotaanarí, ¿tsikapaitima omatya pikantakiri? Aririka imonkaatzimatatya, ¿tsika onkantyaaka jiyotantaityaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ari jakanaki Jesús ikantzi: “Paamaakowintya jamatawiitzimikari. Tima ojyiki kowatsini jamatawitimi paata, impairyaapaakiro nowairo, inkanti: ‘Irootaintsi imonkaatzimatya, Naakataki Cristo’. Iiro poyaatziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ari pinkimakotakiro owayiritaantsi, maamanitawakaantsi, paamaiya omapokimikari, tima ontzimatyii imonkaayitya jiroka, iro kantacha iikiro iyaatatyi. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jantaminthatawakaitya maawoni nampitsiki inkaati jotyaantayitiri pinkathariyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jiñaitiro ojyiki ontziñaayitya kipatsi, intajyaaniintayiiti, imantsiyayiiti. Jiñaiti iijatzi ojyiki inthaawantaityaari, jiñaiti inkitiki kaari jiñaitapiintzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Iro itanatyaawoni jaakaantawaitanakimi atziri, jimaamaniwaitanakimi. Ompoña impajatakaantawaitimi japatotapiintaita, jomontyaakaantawaitimi. Jaayitanakimi isaikayitzi pinkatharintsipirori okantakaantziro pipairyaana pikimisantaana. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Iro imayitantyaari jiroka onkantya pinkinkithatakotantyaanari janta. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ontzimatyii pawintaina naaka, iiro pipomirintsiwaitashitawo oitya pinkantapaakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tima naaka yotakaimironi, ari onkantya iiro piñaantawo impiyatimi onkaati pinkantiriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ari piñaaki jaakaantimi piwaapati, jaakaantimi pirintzi, jaakaantimi pijyininkathori iijatzi. Tzimayitatsi jowamaakaantaiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ojyiki piñiiro inkisaniintaitimi okantakaantziro pipairyagaana pikimisantaana. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Iro kantzimaitacha iiro opiyagaanta piishi. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Aririka pamawitiro, iro piñaantaiyaawori pawisakoshiriyitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Aririka piñaaki jotzikapaakiro owayiriiti Jerusalén, ari piyoti monkaatapaaka japiroitantyaawori. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Inkaati nampitaiyaawoni paata Judea-ki, ontzimatyii ishiyayitai otzishiki. Inkaati saikatsini nampitsiki, ari impoñiiya ishiyanaki. Inkaati saikatsini jowaniki, iiro ipiyapanaata ipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Tima ipiyakowintaitatyaari jirikaiti, ari imonkaayityaari okaatzi josankinayiitakiri pairani. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Inkantamachiitiro paata onkaati motyaayitatsini, iijatzi onkaati tzimayitatsini iintsiti iiniro ithoyitzi! Tima antawo onkantya jashironkaitya aririka jowasankitaayiitairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Japiroyiitairimi Jerusalén-jatzi. Jompiratani jowayitairi atziri poñaayitachari pashiniki nampitsi. Iri oipatsitakirori nampitsi Jerusalén kaari ajyininkata, irojatzi imonkaatantaiyaari okaatzi ikowakaakiriri Pawa jirikaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ari jiñaitaki paata kaari jiñaitapiintzi inkitiki, impashiniyitai ooryaatsiri, kashiri, iijatzi impokiro. Ari onkimityaari kipatsiki, antawoiti jashironkaayitaiya atziriiti, iiro jiyotai oitya jantayitairi onkantakaantiro oyamininka otamaryaani inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ari owamaimatakiri ithaawanka atziriiti inkinkishiritakotiro onkaati awisatsini jaka kipatsiki. Ari jimatsitatyaawo iijatzi inkitiwiri otzimimoyitziri ishintsinka, ojyiki inkantakantanatya. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aripaiti impokai Itomi Atziri, inkinapai minkoriki, jiñaitawairo ishintsinka, iijatzi jowaniinkawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Aririka piñaayitakiro itanatyaawoni kantayitachani, tzinaapanka pinkantya pamini jinoki tima irootaintsi jowawisaakoyiitaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ipoña jojyakaawintanakiniri, ikantzi: “Pinkinkishiritakotiro tsika okanta piñaayitapiintziro inchatopaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aririka piñaakiro iirishiyitzi, piyotzi irootaintsi osarintsitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iro piyotiri iirokaiti, aririka piñaayitakiro nokamantayitakimiri, irootaintsira impinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Imapiro nokantzi, iiro ikamita jirika ajyininkapaini, irojatzi jiñaantatyaawori nokamantayitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Iiro okantaitatyaani piñiiro inkiti iijatzi kipatsi, irooma okaatzi noñaaniyitakari imapiroitaatyaani iroori. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Aamaakowinta pinkantaiya iirokaiti, iiro otyiimi piyaaripironka, ayimawaitimi iijatzi pishinkitya, onkantzimowaiyitimi. Ñaa jomapokaitzimikari. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Inkimitaityaawo iwirintsi. Ari jiwitaiyaari ikaatzi saikayitatsiri kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paamaiya, aakowinta pinkantya pamaña, pinkanti: ‘Pookaakowintina iiro nokimaatsitantawo kinkithatakotainchari. Piwitsikashiritakaayitaina nontonkiyotantawaiyaariri Itomi Atziri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Tima kitiijyiriki jiyotaantzi Jesús tasorintsipankoki. Irooma tsiniri, jiyaatzi otzishiki Olivo, ari jimayiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ananinkayitaki ojyiki atziri ikimisantziri Jesús jiyotaantzi tasorintsipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Irootaatsi joimoshirinkaitairo jowantapiintaitawori tantaponka jiitaitziro kitiijyiri Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ari ikamantawakaari ijiwari Ompiratasorintsitaari itsipatakari Yotzinkariiti, ikantawakaiyani: “Thami owamaakaantiri Jesús”. Iro kantzimaitacha antawoiti ithaawantayitakari atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ikanta Judas jiitaitziri iijatzi Iscariote ikaawitapiintari 12 jiyotaani Jesús, ikamaarishiritakaanakiri Satanás. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jiyaatashitakiri ijiwari Ompiratasorintsitaari, iijatzi ijiwari aamaakowintawori tasorintsipanko, ikinkithawaitakaakiri tsikapaiti jaakaantiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Antawoiti ikimoshiritaiyanakini jiwari, ikamantawakaiyakani impiri kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Aripaiti jaminaminatanakiro Judas tsikapaiti jaakaantiri, iiro jiyotzimaita atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ari imonkaatapaakari kitiijyiri jowantapiintaitawori tantaponka, jowamaapiintaitziri iijatzi oijya jowaitari kitiijyiriki Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ipoña Jesús jotyaantakiri Pedro itsipatanakari Juan, ikantakiri: “Piyaati ponkotsitakaanti oyaari kitiijyiri Anankoryaantsiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ikantaiyini irirori: “¿Tsika janta pikowika nonkotsitakaanti?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ikantzi Jesús: “Aririka pariitzimatatya nampitsiki, ari pintonkiyotyaari atziri aakotzirori ijiñaati kowityaanikiki. Poyaatzishitanakiri irojatzi pankotsiki tsika intyaapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tsikarika intyaapaaki, pinkantiri ashitawori ipanko: ‘Ikowi jiyoti yotaanari tsika janta jowakaiyaari jiyotaani, joimoshirinkiro kitiijyiri Anankoryaantsi’. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ari joñaaganakimiro jinoki ipanko, antawo okantaka jiwitsikaitakiro inkini jowaitya. Ari ponkotsitakaantiri janta”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jataiyakini jiyotaani, jiñaakiro okaatzi ikantakiriri, ari jonkotsitakaantakiri joyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Okanta imonkaataka jowantyaari, saikapaaki Jesús itsipatakari jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ipoña ikantakiri: “Tima irootaintsi noñiiro inkimaatsitakaitina, antawoiti nokimoshiritzi owaiyani iroñaaka kitiijyiri Anankoryaantsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Tima iiro nowitaawo jiroka, irojatzi paata imonkaatantaiyaari impinkathariwintantai Pawa, aripaiti napiitapairo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ipoña jaakotakiro jimiriitari, ipaasoonkiwintakiro, ipakotakiri jiyotaani, ikantakiri: “Piriro jiroka, pantitaiyaawo pikaataiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tima iiro niritaawo naaka, irojatzi paata aririka imonkaataiya impinkathariwintantai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ipoña jaanakiro tanta, ipaasoonkiwintakiro, ipitoryaakiro, ipayitakiri jiyotaani, ikantziri: “Poyaawo, nowatha inatzi, tima iro kamawintimini. Irootaki pinkinkishiritapiintantinani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ari ithonkakiro jowaiyani, jaakotakiro jimiriitari, ikantzi: “Niraani inatzi, irootaki shitowatsini onkantya jawisakotantaiyaari ojyiki atziri. Irootaki oñaagantaironi owakiraari ankajyaakaawakaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Imapiro nokantzi: Pikaataiyakini patyootana, tzimatsi apaani pithokashitinani jaakaantina. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tima imapiro impiyakotya Itomi Atziri, ari matzimaitaka ikowaitakiri pairani. Iro kantacha. ¡Inkantamachiitiri aakaantirini!” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ipoña jiñaanatawakaiyanakani jiyotaani, ikantzi: “¿Iitakama matironi?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ipoña jiñaanatawakaiyakani jiyotaani, ikantzi: “¿Iitama ñaapirotachani paata?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ipoña ikantanaki Jesús: “Piyotaiyini iiroka tsika ikanta pinkatharitatsiri jaka, jompiratanta. Tima ñaapiro ikanta ipashitantayita ikojyika jompiratantantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Iiro pimatziro iirokaiti aririka piñaapiroyitya iroñaaka, aña pinkimitakotyaari iwiyaantawori itzimi. Aririka pijiwatakaanti, pinkimitakotyaari ompirataari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Iitama ñaapirotachari? ¿Tiima iriitaki ñaapirotacha kimitariri oyaawintachari jantawaitaitiniri? Irooma naaka nokimitakaanta pantawaitakaanimi powina. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Irooma iirokaiti tsipatapiintakinari, noñaayitzirowa okaatzi pomirintsitzimoyitakinari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Irootaki noshinitantzimirori pimpinkathariwintanti, ikimitaakinawo Ashitanari naaka ishinitakinawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ari piñiiro ankaati owaiya, arawaitai tsika nompinkatharitai. Ari pinkimitaiyaari pinkathari isaikantawo owaniinkakitachari isaikaminto, pimpinkathariwintairi maawoni incharinintayityaari Israel, kaatatsiri 12 jinashiyitawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ipoña Jesús ikantanakiri jiyotaani: “Simón, ikamitantakimi Satanás jiñaantashiritimi, inkimitakaantimi jotikakitatyiimimi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Iro kantzimaitacha ojyiki namanakowintakimi iiro powajyaantantawo pikimisantanai. Tima aririka pimpiyashiritapaaki, iirokataki aawiyashiritakaapaakirini pijyininka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ari jakanaki Simón ikantanaki: “Aña ayimatakina Pinkatharí ankaati jomontyaiti, aritaki ankaati iijatzi jowamagaitai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ipoña japiitanakiro Jesús ikantziri: “Pedro, nonkantimi, iroñaaka tsiniri, tikiraata jiñiita tyoopi, mawajatzi papiitiro pinkantaki: ‘Tii noñiiri Jesús’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ipoña josampitanakiri Jesús ikaatzi jiyotaani, ikantziri: “Chapinki notyaantantzimiri tii paanaki pithaati, tii paanaki pi-zapato-ti. ¿Oitama kowityiimotakimiri?” Ikantaiyini irirori: “Tikaatsitya”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ipoña ikantziri iijatzi: “Kamiithatatsi iroñaaka payiro pithaati. Iriima kaari tzimatsini josataaminto, impimantiro iithaari, jamanantantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tima imapiro imonkaatya okaatzi josankinatakoitakinari pairani, kantatsiri: Ari intsipataitakiri kaaripiroshiriri. Iiro okantashita jiroka, ontzimatyii imonkaatya”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ikaimaiyanakini jiyotaani: “Pinkatharí, tzimatsi jaka apiti osataamintotsi”. Ikantzi Jesús: “Aritapaaki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ipoña ikinanai Jesús otzishiki Olivo ikimitapiintziro, ari itsipatakari jiyotaaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ikanta jariitaiyakani janta, ikantapaakiri jiyotaani: “Pamanaiyaani iiroka jaka inkimpoyaawintantaitimiri otzimikari inkinakaashitakaitimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ari jawisaniintanaka irirori. Otziirowapaaka kipatsiki, amanapaaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ikantzi jamana: “Ashitanarí, iroorika pikowakaanari, paawiyakainawo pookakaawintinarimi nonkimaatsityaari. Iiro pantanawo nokowawitari naaka, aña iro pantiri okaatzi pikowakaakinari iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ari jomapokapaaka maninkari poñaachari inkitiki, ishintsishiritakaapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tima antawoiti okantzimoshiritanakari, jamanapirotanaka. Iro oshitowantanakari imajawinka okimiwaitanakawo iraantsi opitinkapaaka kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ikanta jamanaka, piyapaaka, jiñaapaatziiri jiyotaani jimagaiyini okantakaawo jowashiritaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ikantapaakiri: “¿Iitama pimaantari? Pinkakitaiyini, pamaña iiroka inkimpoyaawintantaitimini otzimikari inkinakaashitakaitimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jiñaawaiminthaitzi Jesús, jiñaashitakari pokaiyaintsiri. Iri iiwatapaintsiri Judas ikaawitapiintari 12 jiyotaani. Jontsitokapaakari Jesús inthopootiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ipoña Jesús ikantawakiri: “Judas, ¿Arima pipithokashitari Itomi Atziri pithopootapaakiri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ikanta jiñaawakiro ikaatzi itsipatakari Jesús, ikantanakiri: “Pinkatharí, thami ampiyatantyaari osataaminto”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Akotanaki, itotsitakiri ikimpita saikatsiri jakopiroki jompiratani ijiwaripirori Ompiratasorintsitaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ari ikantzi Jesús: “Aritapaaki, iiro pimaamanitziri”. Ipampitsitairi ikimpita, ishitakotanai itowitakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ipoña Jesús ikantanakiri ikaatzi pokashitakiriri, ijiwari Ompiratasorintsitaari, aamaakowintawori tasorintsipanko, Antaripiroriiti, ikantziri: “¿Naakama koshintzi pamashitantanari posataaminto, pipajaminto? ");
INSERT INTO cpcNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","¿Tiima piñaawitapiintana tasorintsipankoki niyotaantzi? ¿Kaarima paantana janta? Aritaki onkantya, tima aripaiti jimatakaimiro iroñaaka tsiniriwiri kaari pantzi pairani”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ikanta joojoitanakiri Jesús, jagaitanakiri isaiki ijiwaripirori Ompiratasorintsitaari. Impoitatsi Pedro irirori joyaatakowintziri jantyaatsikiini Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ipoña jowaampataitaki paampari pankotsinampiki, jakitsitaiyani. Ari isaikitapaaka iijatzi Pedro jakitsita. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Okanta tsinani ompirataawo, oñaapaakiri Pedro isaiki jakitsita. Okimpoyaapaakiri, ari okantzi: “¿Tiima irijatzi jirika itsipatapiintakari Jesús?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ikantanaki Pedro irirori: “Tii noñiiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Okanta osamaniityaaki, ikinapai pashini, ikantapairi Pedro: “¿Tiima iijatzi iiroka ari pikaatziri Jesús?” Ikantanai Pedro: “Tii naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Iro osamani iijatzi, tzimatsi pashini kantapaakiriri Pedro: “Imapirotya iirokataki tsipatariri Jesús chapinki, tima Galilea-jatzi pinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ipoña ikantanai Pedro: “Tii niyotziri pikantanari”. Aripaiti jiñaanaki tyoopi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ari ipithokapainta Jesús, jaminapaintziri Pedro. Irojatzi ikinkishiritantanakari Pedro ikantakiranki: “Tikira jiñiita tyoopi, mawajatzi pinkanti: ‘Tii noñiiri Jesús’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Shitowanaki jikokiroki, antawoiti jiraawaitanaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ikanta jirikaiti ikaatzi aamaakowintakotariri Jesús, ishirontaminthawaitakari, ipoña ipajawaitziri. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Jotzimikapootakiri, jompojapoowaitzimaitari, ikantziri: “¿Tiima Kamantantaniri pinatzi, incha piyoti iita ompojapootakimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Tzimatsi ojyiki oita ikantawaitziriri kaaripirori ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ikanta okitiijyitamanai, apatotaiyakani ijiwaripirori Ompiratasorintsitaari itsipatakari Antaripiroriiti, ipoña Yotzinkariiti. Ari jamaitakiri Jesús, josampiitakiri, ikantaitziri: ");
INSERT INTO cpcNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Pinkantina, ¿Iirokatakima Cristo?” Ari ikantzi irirori: “Aririka nonkantakimi, iiro pikimisantana. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Aririka nosampitimi, tima iiro pakana, iiro pipakaana iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iro kantzimaitacha itanatyaawo iroñaaka, ari jiñiiro Itomi Atziri isaiki jakopiroriki Pawa joñaagantairo ishintsinka”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ipoña ikantaiyanakini ikaatzi apatowintakariri: “¿Iirokatakima Itomi Pawa?” Ari ikantzi Jesús: “Iirokataki kantatsi naakataki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Irojatzi ikantantaiyanakarini: “¿Iitama ankowiri iroñaaka? Aakataki kimakiriri ikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ipoña ikatziyaiyanaani ikaatzi apatotainchari, jaanakiri Jesús Pilato-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ikantapaakiri Pilato: “Jirika atziri ojyiki jowaaripirotakiro nampitsi, ikaminaakiri atziriiti iiro ipantaari kiriiki pinkathari César, ikantaki iijatzi Cristo jinatzi iri pinkatharitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ipoña Pilato, josampitanakiri irirori, ikantziri: “¿Iirokama iwinkathariti Judá-mirinkaiti?” Ari jakanakiri ikantzi: “Irootaki pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ikantziri Pilato Ompiratasorintsitaari, iijatzi maawoni atziriiti: “Tikaatsitya noñi oitya inkinakaashitatyaari jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Iikiro ishintsitanakitzi jiwaripaini ikantzi: “Ojyiki ikaminaantaki jirika imaamanitanti atziriiti nampitsiki, jitanakawo Galilea-ki irojatzi iroñaaka jaka Judea-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ikanta ikimawaki Pilato ikaminaantaki Galilea-ki, josampitakowintanakiri Jesús iriirika Galilea-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ikimatzi ikantaitzi iriitaki. Jowawisaakiri Herodes-ki ipoki irirori jariita Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ikanta Herodes jiñaawakiri Jesús, antawoiti ikimoshiritanaki, tima ojyiki ikowawitapiintaka jiñiiri, ojyiki ikimakowintakiri iijatzi okaatzi jantayitakiri, ikowapirotaki jiñiiri irirori intasonkawintanti. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ojyiki josampitawakiriri. Tii jakimaita Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ari isaikitakari ijiwari Ompiratasorintsitaari itsipatakari Yotantaniriiti, ojyiki ikantakowitakariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ikanta Herodes itsipatakari jowayiriti irirori, imanintashiritanakiri, ikawiyawaitanakiri. Ikithaatantakari iroopirori kithaarintsi, joipiyairi isaiki Pilato. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aripaiti jaapatziyanakari Herodes jirika Pilato, tima pairani owanaa ikisaniintawakaawitaka. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ipoña Pilato japatotakiri ijiwari Ompiratasorintsitaari itsipataakiri ikaatzi jiwatakaantatsiri nampitsiki, iijatzi maawoni atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ikantakiri: “Aña pamawitakinari jirika atziri owaaripirotironimi nampitsi, nosampisampiwitakari, tii noñiiro onkaaripiroti okaatzi jantakiri ikantakoyiitziriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ari ikimitaka iijatzi Herodes, tima notyaantawitakanari irirori. Tikaatsitya janti jirika atziri inkini owamaakaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Apa nompajatakaantakiri naaka, nompakagairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Iro jamitapiintari Pilato joimishitowakaantzi apaani aakaantaari kitiijyiriki joimoshirinkaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iro kantzimaitacha ikantaiyanakini atziriiti: “¡Tii nokowiri jirika! ¡Iri poimishitowakaanti Barrabás!” ");
INSERT INTO cpcNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jirika Barrabás iri jomontyaitziri okantakaantziro itsitokantaki imaamanitakiri pinkatharitatsiri nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ipoña japiiwitakari Pilato tima ikowawitatya irirori impakaakaantirimi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Japiitzimaitanakawo atziriiti ikaimaiyini: “¡Pimpaikakotakaantiri, pimpaikakotakaantiri!” ");
INSERT INTO cpcNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Iro mawajatzi japiiwitakawo Pilato josampitantzi: “¿Iitama kaaripirori jantakiri jirika? Tikaatsitya oitya jantiri, iiro okantzi owamaakaantashityaari. Apa nompajatakaantashityaari, jiyaataita”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Iikiro ishintsitatzi atziriiti ikaimaiyini, ikowi impaikakoitiri Jesús. Iro japiipiintanakiri ikaimaiyini iijatzi ijiwari Ompiratasorintsitaari, jimatakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Irojatzi jantantakawori Pilato okaatzi ikowakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jomishitowakaantakiri tsitokantzinkari maamanitziriri jiwatakaantatsiri nampitsiki, tima iri ikowaiyakirini atziriiti. Ishinitakiniri inkantawaitiri Jesús ikowakiri iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ikanta jagaitanakiri Jesús, itonkiyotaitakari iitachari Simón poñaachari Cirene, ari jariita irirori ipoñagaawo jowaniki, ishintsiwintaitakiri inatanakiro impaikakoitantyaariri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ojyiki atziri oyaatakowintanakiriri Jesús. Tzimatsi tsinani iraakotanakariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ari jaminapaintziro Jesús okaatzi tsinani iraakotakariri, ikantziro: “Jerusalén-jato, iiro piraakowaitashitana naaka, aña piraakotaiya iiroka, iijatzi powaiyaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tima irootaatsi piñiiro inkantayiitai: ‘Kimoshiri inatyi tsinani kaari owaiyantatsiri, othotaawaitashitantakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Impoña inkaimayiitai, inkantaiti: “Pintaankashitina otzishi, pinkitatinaata”.’ ");
INSERT INTO cpcNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tima piñaakiro tsika ikantaitakiro inchato añiinkawo, aña iro jowatsipiroiti kaminkawo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ari jagaitanaki iijatzi apiti kaaripiroshiriri itsipataitanakiri Jesús intsitokaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ikanta jariitakaitapaakari jiitaitziro atziriitoni, ari ipaikakoitakiri. Jowatzikakoitaki apaani kaaripiroshiriri jampatiki, iriima pashini jakopiroriki. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ari ikantzi Jesús: “Ashitanarí, tii jiyotzi oita jantziri kimaatsitakaakinari, pimpiyakotiri”. Ipoña jagaitakiro iithaari Jesús ipawakaakawo, ikimitakaantakiro jiñaaritaita. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Irojatzi jaminaiyakini atziriiti. Jimatsitakawo jiwatakaantatsiri nampitsiki, joitsinampaawaitakiri Jesús, ikantziri: “Jowawisaakotziri pashini, ¿kaarima jimatantawo jowawisaakotya irirori? Aña iriimi Cristo jiyoshiitani Pawa, ari jimatakiromi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ari jimatsitakawo iijatzi owayiriiti, ithainkakiri Jesús, jamakotakiniri kipijyaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ikantapaakiri: “Incha powawisaakotya, imapirorika iiroka iwinkathariti Judá-mirinkaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tzimatsi osankinarintsi ikintakoitakiri jiñokiini ipatziitoki, iñaaniki Judá-mirinka, iñaaniki Roma-jatzi, iñaaniki iijatzi Grecia-jatzi, okantzi: “IWINKATHARITI JUDÁ-MIRINKAITI”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ari jimatsitakawo iijatzi jiñaanaminthatziri apaani kaaripiroshiriri tsipatakariri ipaikakota, ikantziri: “Iirokatakirika Cristo, powawisaakotya, powawisaakotsitaina naaka iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Irojatzi jakantanakari pashini kaaripiroshiriri, ikisanakiri ñaanatakiriri Jesús, ikantziri: “Pimatsitawoma iiroka tii pipinkathatziri Pawa, ari akaatakiri jowasankitaayitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tima tzimatsi antakiri aaka añaantakawori jowasankitaayiitai. Iriima jirika jowasankitaashiitakari, tikaatsi kaaripirori janti”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ipoña jaminanakiri Jesús, ikantziri: “Pinkatharí, iiro pimaijantana paata aririka pimpiyi pimpinkathariwintantai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jakanaki Jesús, ikantzi: “Imapiro nonkantimi, aritaki pintsipatapaiyaana iroñaaka iiroka janta tsika ikimoshiriitapai”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ikanta itampatzikatapaaki ooryaatsiri, omapokashitapaaka otsiniritanaki, irojatzi jyiitiini ithapirotanaka ooryaa. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ari itsiwakanakiri ooryaatsiri. Okanta janta tasorintsipankoki, sagaanaki niyanki tontamawotatsiri ithatashiitzirori. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Irojatzi ikaimantanakari Jesús shintsiini, ikantzi: “Ashitanarí, paawakinawo noshiri”. Ithonka jiñaawaitanakiro jiroka, kamanaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ikanta ijiwari owayiri katziyawintakariri jiñaakiro okaatzi awisaintsiri, antawoiti ithaamintawintanakari Pawa, ikantanaki: “Imapirotatyaama ikamiithashiritzi jirika shirampari”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iijatzi ikaatzi ñaayitakirori awisaintsiri, okatsitzimoniintanakiri jiyaayitai. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Iriima ikaatzi ñaapiintakiriri, iijatzi tsinanipaini, tsipatakariri ipoñaantakari Galilea-ki, intaina ikatziyaiyakani jaminakotakiri oita awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ikanta José poñaachari nampitsiki Arimatea saikatsiri Judea-ki, kamiithashiri jinatzi jirika, iriitaki itsipatapiintari japatota jiwariiti Judá-mirinka, ");
INSERT INTO cpcNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","tiimaita inimotziri okaatzi ikantawaitaitakiri Jesús, tima ojyiki joyaawintakari irirori Pawa impinkathariwintantai. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jiyaatashitakiri Pilato, ikantapaakiri: “Pishinitinari Jesús, nonkitatairi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ipoña ikintakoryaakotairi, iponatantakari manthakintsi, ikitatakiri ikiyaitziro impiitanaki, kaari ikitatantaita kaminkari. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Tima irootaki kitiijyiri jaminantapiintaitari joyaari oñaatamani kitiijyiri jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Okanta tsinanipaini tsipatakariri ipoñaantakari Jesús Galilea-ki, oyaatakowintanakiri, oñaakiro tsika ikanta jomaryaitapaintziri ikitaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Okanta opiyaiyapaakani iwitsikayitakiniri kasankaari. Imakoryiiyakini, tima iro kitiijyiri ikantakaantaitziri jimakoryaantaityaawo. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Okanta okitiijyitamanai domingo, ananinkamanai tsinani iyaati impiitamooki tsika jomontyaakoitakiri Jesús, aanakiro kasankaari iwitsikakiri chapinki. Ari okaatakiri iijatzi pashinipaini tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Okanta aminawitapaaka, oñaatzi otainkanaki mapi jashitantaitakawori omoona. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tyaapaaki inthomainta, tii oñaapairi tsika jowakowiitakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ojyiki othaawanaki. Oñaashitakari ikatziyimotapaakawo apiti mainari, shipakiryaa okantaka iithaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tima othaawanakitzi, otziirowashitanakari. Ari ikantziro: “¿Iitama paminaminatantariri añaagatsiri kaminkarimooki? ");
INSERT INTO cpcNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tii isaiki jaka, aritaki añagai. Pinkinkishiritiro okaatzi ikantakiri isaikantawitari Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ikantziranki: ‘Irootaintsi jaakaantaitiri Itomi Atziri, impaikakotiri kaaripiroshiriri atziri. Awisawitatya mawa kitiijyiri, aritaki jañagai iijatzi’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ari okinkishiritaiyanakironi iroori okaatzi ikantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Opiyapithatanakawo omoona, okamantapaakiri 11 jiyotaani Jesús iijatzi pashinipaini. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jiroka okaatzi tsinani: María Magdala-jato, Juana, María inaanati Jacobo opoña pashinipaini tsinani, irootaki kamantapaakiriri otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Iro kantzimaitacha ikaatzi okamantawitapaakari, tii ikimisantziro, jiñaajaantaki okantashiwaita jirokaiti tsinani. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ikanta Pedro, jatanaki omoonakiki irirori, ishiyapirotanakitya. Jaminawitapaaka inthomainta omoonaki, jiñaapaatziiro omaryaaka manthakintsi iponataitantakariri. Iyokitzi ikanta jiñaapaakiro, piyaa pankotsiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tikira osamanitzi, janiitaiyini apiti jiyotaani Jesús jiyaatiro nampitsiki iitachari Emaús. Tii osamanipirotzi osaiki Jerusalén okaatzi 11 kilómetro. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Iro ikinkithatakotaiyini janiitzi okaatzi awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ikinkithawaiminthaitzi janiitaiyini, pokapaaki Jesús irirori itsipatapaakari janiitzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Iro kantzimaitacha jirika jiyotaani, kimiwaitaka jotzimikaitatyiirimi jokiki, iiro jiyotantawaari. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ikantapaakiri: “¿Iitama pikinkithatakotziri paniitaiyini? ¿Iitama powashiriniintantari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ari jakanaki apaani jiitaitziri Cleofas, ikantanaki: “¿Iirokama apintzi kaari yotakotironi okaatzi awisaintsiri Jerusalén-ki?” ");
INSERT INTO cpcNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ikantzi: “¿Iitama awisaintsiri?” Ari ikantaiyini jiyotaani: “Iri Jesús jiitaitziri Nazaret-jatzi, tsika itzimi jotyaantakiri Pawa, inkamantantaniriti, iri jiyotawaki atziriiti. Tima okaatzi jantayitakiri, okaatzi ikantayitakiri iijatzi, ari joñaagantziro ishintsinka. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iro kantzimaitacha jaakaantakiri ijiwari Ompiratasorintsitaari itsipatakari pinkathariiti, jowamaakaantakiri janta ipaikakoitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Aña noñaajaantawitaka naakaiti iri ookawintairini maawoni ajyininka. Irootaki mawatatsiri iroñaaka kitiijyiri jowamaantaitakariri. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tzimayitatsi tsinani nokaatapiintziri omapokashitakinari, ananinkamanai omoonakiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Tii oñaapairi jowakowiitakari Jesús, opiyaa okamantantapai, okantzi: ‘Noñaaki maninkari, ikantakina: “Añagai Jesús”.’ ");
INSERT INTO cpcNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ari jiyaataiyanakini nokaataiyini janta omoonaki, jiñaapaakiro okaatzi okantaiyakirini tsinani, tii jiñiimaitapaari Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ari jakanakiri irirori, ikantanakiri: “¡Tiitya piyotanitzi iirokaiti, ojyiki pithainkashiritakiro okaatzi ikamantantayitakiri Kamantantaniriiti! ");
INSERT INTO cpcNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aña iro kowapirotacha awijyimotiri Cristo jirokapaini, isaikai jowaniinkawoki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ari jitanakawo joñaayiniri okaatzi osankinayitainchari tsika ikinkithatakoitziri Cristo, opoñaanakawo josankinariki Moisés japirotakiniri okaatzi josankinayitakiri maawoni Kamantantaniriiti. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ariitaiyakani nampitsiki tsika joshiritawo. Ari ikowi Jesús jawisanakimi irirori kimiwaitaka jiyaatatyiimi intaina. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ikantaiyirini jirika apiti: “Iiro pawijyi, ari pisaikanaki. Tima tsiniriityaaki”. Irojatzi isaikantanakari Jesús pankotsiki isaikapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ipoñaashitaka isaikaiyini jowaiyaani, jaakiro Jesús tanta, ipaasoonkiwintakiro, ipitoryaakiro, ipayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Aripaiti jiyotakaayiitanairi iriitaki Jesús. Iro kantzimaitacha Jesús ipiyashitanaka, tii jiñaawairi tsika ikinaki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ikantawakaiyani: “¿Tiima thaamintashiri pikanta ikinkithawaitakai aatsiki, ikinkithatakotairo osankinarintsi iijatzi?” ");
INSERT INTO cpcNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tii isaikanaki, piyanaka Jerusalén-ki. Jiñaapaatziiri ikaatzira 11 jiyotaani japatotaiyani, itsipayitakari ikaatapiintaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ikantaiyini: “Imapiro jañagai Awinkathariti. Tima joñaagaari Simón”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ikamantantapaakiro irirori okaatzi awijyimotakiriri aatsiki, tsika okanta jiyotantaariri ipaasoonkiwintapairo tanta. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ikinkithawaiminthaitzi jiyotaani, osatikapaaka Jesús, jiwithatapaakari ikantziri: “Pisaikaita kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Antawoiti ithaawaiyanakini, jiñaajaantaki iri shiritsi ñaanatziriri. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ipoña ikantanakiri iijatzi: “¿Iitama pithaawantari? ¿Iitama pikisoshiriwintantanari? ");
INSERT INTO cpcNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Pamininawo nako, iijatzi noitzi, naakataki. Potirotina, pimpampoyiina. Tima shiritsi tii otzimi iwatha, tii otzimi itonki. Irooma naaka tzimatsi”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Joñaayimaitari jako iijatzi iitzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Okantakaakari ithaamintanaka tii ikinkishirita aña iriiwitaka Jesús. Iikiro josampitanakitziiri, ikantziri: “¿Tzimatsima oyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ipaitakiri tzimagaantatsiri shima itsipataitakiniri iyaaki pitsi. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jaawakiri Jesús, jiñaakiri ikaatzi jiyotaani jowakari. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ari ikantzi: “Irootaki nokantsitakimiri iiniro notsipayitzimi. Ontzimatyii imonkaayitya okaatzi josankinatakoyitakinari Moisés-ni, Kamantantaniriiti, ipoña Salmo”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ikimathatakaakiri Jesús okaatzi osankinatakoyitainchari. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ikantziri: “Irootaki josankinaitakiri. Ontzimatyii inkimaatsitakaityaari Cristo, iro awisawitatya mawa kitiijyiri aritaki jañagai. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ontzimatyii inkinkithatakoitairo nowairo maawoniki kipatsi, ari jitaitanatyaawo Jerusalén-ki. Ari onkantya jowajyaantantaityaawori kaaripirori jantayiitziri, impiyakoitairi iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iirokataki ñaayitironi jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ari piñaakiri notyaantimiri ikajyaakaakimiri Ashitanari. Ari pisaikaiyawakini jaka Jerusalén-ki, irojatzi ishintsitakaantimiri poñaachari inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ipoña Jesús jaanakiri jiyotaaniiti janta Betania-ki. Ari itzinaawakotanaka, itasonkawintanairi. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ikanta itasonkawintakiri, jomapokashita itzinaana inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ikanta ipinkathataiyanakirini jiyotaani, piyaiyaani Jerusalén-ki, antawoiti ikimoshiritaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ari ikantaitanakityaani ithaamintawintanakari Pawa janta tasorintsipankoki. Ari onkantyaari.");
INSERT INTO cpcNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Owakiraa itantanakari jiwitsikantaitzi pairani, aritaki tzimaki jiitaitziri “Ñaantsi”. Ari itsipatari Pawa. Tima Pawa jinatzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Iriitaki itsipatakari pairani Pawa owakiraa itantanakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Iriitaki witsikajaantakirori maawoni tzimayitatsiri. Tikaatsi apaani tzimayitatsiri kaari jiwitsikajaanti irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ikimitakowaitakari kitainkari ikitainkatakotairi atziriiti onkantya inkañaanitantaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ikimitakotapaakari kitiijyiinkatakotantatsiri otsinirikitzi. Tiimaita ikitsirinkiri joitsiwakawakiri kimitakotakawori tsinirikiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pairani jotyaantaki Pawa shirampari, jiita Juan. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Iriitaki kinkithatakotapaakirini jiitaitziri “Kitainkari”, ari onkantya inkimisantaitantyaawori maawoni jiyotaantiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jirika Juan kaari jiitaitziri “Kitainkari”. Aña iriitaki pokaintsini ikinkithatakotakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tima aritaki pokataiki jaka kipatsiki mapirotzirori ikimitakotari kitainkari, iriitaki kitiijyiinkatakotairini atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Isaikapaintzi kipatsiki. Tima iriitaki witsikakirori kipatsi. Iro kantzimaitacha tii jiyotawakiri atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Isaikimowitapaintari ijyininkamirinkaiti. Iro kantacha tii jaawakiri kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Iriima ikaatzi aawakiriri kamiitha, pairyaapiintanairiri ikimisantairi, iriitaki ishinitaki Pawa intomitaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Itomi jowajaantairi Pawa. Tiimaita ojyawo itomitantapiinta atziriiti, inintakaanikiini, ikowi jowaiyantawaiti. Aña iri Pawa kowashitainchari intomitantya. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jirika jiitaitziri “Ñaantsi”, jatziritaki, isaikimotapaintai. Nishironkapirowaitantaniri jinatzi. Tyaaryoori inatzi iñaanitari. (Naakaiti ñaajaantakirori itasorinka, ari okimitajaantakawo itasorinka japintziti itomi Ashitariri.) ");
INSERT INTO cpcNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iriitaki ikaimakaimawintapaakiri pairani Juan, ikantapaaki: “Jirika nokinkithatakotakiri pairani, nokantaki: ‘Aatsikitaki poyaatapaakinani, janaakowaitakina naaka, tima iri itakawo pairani tikiraamintha notzimi naaka’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tima kamiithapirowaitaki irirori, irootaki añaantayitaawori maawoni inishironkapirowaitapiintai. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pairani, iri Moisés-ni josankinatakaawiitakari Ikantakaantaitani. Iriima Jesucristo iriitajaantaki nishironkayitairi, irijatzi ñaawaitapiintairori tyaaryoori. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tikaatsi matironi jiñiiri Pawa. Iriima japintziti itomi Ashitairi, saikimotajaantairiri, iriitaki kamantairi aakaiti ayotantaari tsika ikanta irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ikanta Judá-mirinkaiti nampitawori Jerusalén-ki, jotyaantaki Ompiratasorintsitaariiti itsipataakiri Leví-mirinkaiti, jiyaati josampitiri Juan, inkantapaakiri: “¿Tsika piitaka iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Tii jimanakota Juan, ikamantantaki, ikantzi: “Tii naaka Cristo”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ipoña japiitaitziri josampiitziri, ikantaitziri: “¿Tsikama piitatyaaka? ¿Iirokama Elías-ni?” Ikantzi Juan: “Tii naaka”. Iikiro ishintsitaitatzi josampiitziri: “¿Iirokama Kamantantaniri noyaakoniintani?” Ikantzi: “Tii”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ari ikantaitziri: “¿Tsikama piitaka iiroka? Pinkamantina, inkini nonkamantapairi otyaantakinari. Incha pinkinkithatakotya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Japiitanakiro Juan, ikantzi: “Naakataki kaima-kaimatapaintsiri otzishimashiki, nokantantaki: ‘Powamiithatainiri Awinkathariti tsika inkinapaaki, pinkimitakaantiro jotampatzikaitziro aatsi’. Irootajaantaki ikinkithatakotsitakari pairani Kamantantaniri Isaías-ni”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ikanta jotyaantaniiti Fariseo-paini, ");
INSERT INTO cpcNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","iikiro josampitanakitziiri, ikantziri: “Tii Cristo pinatyi iiroka, tii iiroka Elías, tii Kamantantaniri pinatyi iijatzi. ¿Iitama powiinkaatantantari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ari ikantzi Juan: “Apa nowiinkaamachiitantawo naaka jiñaa. Iro kantzimaitacha tzimatsi pitsipatakari, kaari piyotaiyini, ");
INSERT INTO cpcNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iriitaki poyaatapaakinani. Tii okantaajaitzi inkimitakaantina jimpiratani nonothopaitsitantyaariri i-zapato-ti.” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","maawoni jiroka, iro awijaintsiri pairani jiitaitziro Betábara, intatsikironta jiñaa Jordán jowiinkaatantzi pairani Juan. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Okanta okitiijyitamanai jiñaawairi Juan ikinapai Jesús, ikantzi: “Jirika joijyati Pawa, iri piyakotaironi iyaaripironka atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Iriitaki nokinkithatakotsitakari nokantaki: ‘Aatsikitaki shirampari poyaatinani, janaakowaitakina naaka, tima iri itataikawori pairani tikiraamintha notzimi naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tii niyowitari naaka. Aña iro nopokantakari nowiinkaatanti, jiyotantyaariri Israel-mirinkaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jiroka ikantanaki iijatzi Juan: “Noñaataikiri Tasorintsinkantsi ikinapaaki jinoki ikimitapaakari shiro. Jookantapaakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tii niyowitari naaka. Iro kantacha otyaantakinari nowiinkaatanti, ikantakina: ‘Aririka piñaaki ijyaawiinkashitakirini Tasorintsinkantsi jookantapaatyaari iitoki, iriitaki kimitakaantyaawoni jowiinkaatantatyaarimi Tasorintsinkantsi’. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Naakajaantaki ñaakiriri, iro nokinkithatakotantariri tima Itomi Pawa jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Okanta okitiijyitamanai ari isaiki Juan itsipatakari apiti jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ikanta jiñaawairi Jesús ikinapai, ikantzi Juan: “Jirinta joijyati Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ikimawaki apiti jiyotaani Juan, joyaatanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ari ipithokanaka Jesús, jiñaatziiri joyaataiyakirini, ari ikantziri: “¿Tsika piyaatika?” Ikantaiyini irirori: “Rabí (Iro ikantaitziri ‘Yotaanarí’), ¿tsika pinampitawoka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ikantzi Jesús: “Pimpoki piñiiro”. Ikanta joyaatanakiri, jiñaakiro tsika inampitawo. Ari jimayimotapaintziri tima aritaki tsiniriityaanaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jirika kimakiriri Juan, oyaatanakiriri Jesús, iriitaki Andrés iririntzi Simón Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ikanta Andrés, apatziro jiyaatashitanakiri iririntzi, jirika Simón, ikantapaakiri: “Noñaataikiri Mesías (iro ikantaitziri iijatzi, ‘Cristo’.)” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ipoña Andrés jaanakiri Simón isaikira Jesús. Ikanta Jesús jiñaawakiri iririntzi Andrés, ikantawakiri: “Iiroka Simón, itomi Jonás. Iroñaaka piitaiya ‘Cefas’ ”. (Iro ikantaitziri iijatzi, Pedro.) ");
INSERT INTO cpcNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Okanta okitiijyitamanai, jataki Jesús Galilea-ki. Ari jiñaakiri Felipe, ikantapaakiri: “Poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jirika Felipe, Betsaida-jatzi jinatzi, irojatzi inampi Andrés iijatzi Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ikanta Felipe, jiyaatashitanakiri Natanael, ikantapaakiri: “Noñaataikiri josankinatakotakiri Moisés-ni janta Ikantakaantaitaniki, josankinatakotsitakari iijatzi Kamantantaniriiti. Iriitaki itomi José, Nazaret-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ari ikantzi Natanael: “¿Tzimatsima kamiithashiriri janta Nazaret-ki?” Ikantzi Felipe: “Pimpoki, piñiiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ikanta Jesús jiñaawakiri ipokaki Natanael, ikantzi: “Aatsikitataiki jirika Israel-mirinkapirori, tii ithiiyanita”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ari ikantzi Natanael: “¿Tsika janta piñaanaka piyotantakinari?” Ikantzi Jesús: “Noñaakimitya tikiraamintha ikaimimi Felipe pisaiki pankirintsitapishiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ikantanaki Natanael: “Rabí, ¡Iirokataki Itomi Pawa, iirokataki Iwinkathariti Israel-mirinkaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ikantzi Jesús: “Iro pikimisantamachiitantanakari nokantakimi ‘noñaakimi pisaiki pankirintsitapishiki’. Iro kantacha, arimaitaka piñaaki pashini anaironi jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Iikiro ikantanakitzi Jesús: “Ari piñaakiro ashitaryagaiya inkiti. Ari impiyapiyataiyini maninkariiti jayiitashitiri Itomi Atziri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Okanta mawatapaintsiri kitiijyiri, ari jaawakaitari nampitsiki iitachari Caná, saikatsiri Galilea-ki. Ari osaikakiri iijatzi inaanati Jesús janta. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ari ikaimakaantaitakiri iijatzi Jesús itsipatakari jiyotaanipaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ikanta joimoshirinkaiyani, thaatapaaka imiritaiyarini. Opoña inaanati Jesús, okantanakiri otomi: “Thaatapaaka amiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ikantzi irirori: “Tsinaní, ¿Iitama pikantantanari naaka? Aña tikira imonkaapaitita noñaagantantya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Okantanakiri iroori ikaatzi pakotantatsiri: “Pantiro onkaati inkantimiri notomi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ari owaka janta 6 kowitzi mapinakitatsiri, iro jowantapiintari Judá-mirinkaiti jiñaa ikiwayitantari inkitiwathatantyaari. Jiroka kowitzi, tzimayitatsi antitachari 50 litro jiñaa, pashini 60 litro. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ikantanakiri Jesús ikaatzi pakotantatsiri: “Pijaikitiro jiñaa maawoni kowitziki”. Ijaikipiroyitakiro kowitziki. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ipoña ikantzi Jesús: “Pinkitanaki kapichiini, paanakiniri aminakaantzirori oimoshirinkaantsi”. Ari ikantaiyakironi. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ikanta aminakaantzirori oimoshirinkaantsi jirawaki kapichiini jimiriitari piyanainchari ojiñaawita, tii jiyotzi tsika okinapaaki iroopirori imiriitari. Apa jiyotaiyini pakotantatsiri, tima iriitaki jaikitakirori jiñaa. Ipoña aminakaantzirori oimoshirinkaantsi, ikaimakiri aawakaachari, ");
INSERT INTO cpcNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ikantziri: “Iro jamitari atziriiti jitapiintawo ipakotantziro tontaari jimiriitari, aririka inkimaniintaiyatyaani oimoshirinkachari, ari ipakotantaitziro jintaari. Irooma iiroka powaantakawo iroopirori jimiriitari irojatzi iroñaaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jiroka jantakiri Jesús nampitsiki Caná saikatsiri Galilea-ki, iro itanakawori itasonkawintantzi ari joñaagantziro ishintsinka. Ari ikimisantapirotanakiri jiyotaanipaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Okanta okaatapaaki jiroka, jatanaki Capernaum, itsipatanakawo inaanati, iririntzipaini, iijatzi jiyotaanipaini. Tii osamani isaikapainti janta. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Irootzimatai joimoshirinkapiintantawori Judá-mirinkaiti Anankoryaantsi. Jataki Jesús Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iñaapaakiri tasorintsipankoki yomparitariri ipirapaini, iijatzi ishironipaini. Ari isaikayitakiri iijatzi yomparitariri kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ikanta jiñaapaakiri, jaminthataki Jesús ipajaminto, jomishitowakiri maawoni yomparitachari tasorintsipankoki, itsipataakiri ipirapaini. Josokitakiri iiriikiti ikaatzi yomparitariri kiriiki, jotatsinkitsitakiri isaikamintopaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ikantakiri Jesús yomparitariri ishironi: “¡Paanairi pipira! ¡Tii okantzi pinkimitakaantiro ipanko Ashitanari iyomparintsipanko!” ");
INSERT INTO cpcNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ari ikinkithashiritanakiro jiyotaani okaatzi josankinaitakiri, kantatsiri: Antawoiti nonkisakowintyaawo pipanko. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ikanta Judá-mirinkaiti ikantanakiri Jesús: “Incha poñaayina pintasonkawintanti noñaantimiri imapiro otzimi pishintsinka pimatantawori jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ikantzi Jesús: “Pimpookiro jiroka tasorintsipanko, ari awijawitatya mawa kitiijyiri, ari nontzinagairo iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ikantaiyini Judá-mirinkaiti: “Aña okaatzi 46 osarintsi jantawaitaitzi jiwitsikaitantakawori jiroka tasorintsipanko, ¿ompoña pintzinagairo iiroka onkaati mawa kitiijyiri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jiroka “tasorintsipanko” ikinkithatakotakiri Jesús, iro ikantakotzi iwatha irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ikanta itzinagaa pairani Jesús, ikinkithashiritanairo jiyotaaniiti ikinkithatakotsitakari. Irootaki ikimisantapirotantanakawori Osankinarintsipirori, iijatzi okaatzi ikantayitakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iinta isaiki Jesús Jerusalén-ki joimoshirinkaitziro Anankoryaantsi, ojyiki kimisantanakiriri jiñaayitakiri itasonkawintantaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Iro kantacha Jesús, tii jawintaari jirikaiti, tima jiyoshiritziri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Tii ikowaajaitzi Jesús inkamantaitiri tsika ikantashiriyitzi atziriiti, aña jiyoshiritziri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tzimatsi Fariseo jiita Nicodemo, iriipirori Judá-mirinka jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ikanta jirika jataki tsiniri jiñiiri Jesús. Ikantapaakiri: “Rabí, niyotaiyini iri Pawa otyaantakimiri piyotaayitina, tikaatsi kantironi jantiro poñaagantakiri iiroka, tiirika itsipashiritari Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ari jakanaki Jesús, ikantziri: “Incha pinkimisantawakina. Itzimirika kaari apiitaironi intzimai, iiro jiñairo impinkathariwintantai Pawa. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ikantzi Nicodemo: “¿Kantatsima japiitairo intzimai shirampari antaripirotaintsiri? ¿Arima onkantaki intyagai omotziki inaanati, inkini japiitairo intzimai?” ");
INSERT INTO cpcNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ari jakanaki Jesús, ikantziri: “Itzimirika kaari tzimantaiyaawoni jiñaa, kaaririka intzimakaashiriyitairi Tasorintsinkantsi, iiro jiñairo ipinkathariwintantai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ikaatzi jowaiyantziri atziriiti, atziri jinatzi. Iriima ikaatzi tzimantaariri Tasorintsinkantsi, tasorintsishiri ikantanaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Iiro okompitzimotzimi nokantakimi: ‘Ontzimatyii papiitairo pintzimayitai’. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Okimita tampiyainka otasonkantapiintzi tsika okowakaawo. Pikimawitawo oyamininka, tiimaita piyotzi tsikarika okinapaaki, tsikarika iyaatziro. Ari ikimiyitari iijatzi ikaatzi itzimakaayitairi Tasorintsinkantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Japiitanakiro Nicodemo josampitziri: “¿Tsikama okantakotaka jiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ikantzi Jesús: “¿Iiroka, yotaapiintziriri Israel-mirinkaiti, tiima piyotzi tsika okantakota jiroka? ");
INSERT INTO cpcNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nokinkithatakotaiyimironi okaatzi niyotakotziri. Nokinkithatakotzimiro okaatzi nokitapiintaiyarini. Iro kantzimaitacha tii pikimisantaiyini iirokaiti nokantayitzimiri. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tii pikimisantana nokinkithatakotzimiro isaawijato, iro owatsipiro iiro pikimisantana aririka nonkinkithatakotimiro inkitijato. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tikaatsi apaani jataintsini inkitiki, apa jirika poñainchari inkitiki. Iri akinkithatakotziri, Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tima pairani Moisés-ni jowatzikakotakiri maanki otzishimashiki, ari inkimitaitiri iijatzi Itomi Atziri, ontzimatyii jowatzikakoitiri irirori, ");
INSERT INTO cpcNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","inkañaanitantaiyaari inkaati kimisantairini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Tima jitakopirotaari Pawa isaawijatzi, ishinitakiri japintziti Itomi inkamawintiri, iiro ikaamaniyitai inkaati kimisantairini, aña inkañaaniyitai. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tima Pawa tii iro jotyaantantyaariri Itomi jaka kipatsiki jiyakawintairi isaawijatzi, aña jowawijaakoshiritaatyiiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ikaatzi kimisantairini Itomi Pawa, iiro jiyakawintaitziri. Iriima kaari kimisantayitaatsini, aritaki jiyakawintairi, okantakaantziro tii ikimisantairi japintziti Itomi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","maawoni kaari kimisantatsini, aritaki jiyakawintairi, tima jantapiintatziiro kaaripirori. Tima ipokawitapainta pairani kipatsiki jiitaitziri ‘Kitainkari’, iro ikowapirotajaantanakiri tsinirikiri, jimanintawakiri ‘Kitainkari’. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","maawoni antayitzirori kaaripirori ikisaniintatziiri jiitaitziri ‘Kitainkari’. Ikoimintawaita onkantya iiro jiyotakoyitantawo jantayitziro kaaripirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Iriima matapiintanairori tyaaryoori, jawintaapirotari ‘Kitainkari’, iro jiñaitantyaawori jantawaipirotaatyiiniri Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ikanta okaatapaaki jiroka, jatanai Jesús Judea-ki itsipayitanaari jiyotaani, ari itsipatakari jowiinkaatantzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Iijatzi Juan jowiinkaatantzi irirori Enón-ki, okaakitapai Salim, tima janta ari otzimapirotzi jiñaa. Ikaatzi jatatsiri janta, jowiinkaayitawakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tima tikira jaakaantaitziriita Juan jomontyaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ikanta kiyopayipaini jiyotaani Juan jiñaanaminthatakiri Judá-mirinka tsika onkantya inkitiwathatantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ipoña jiyaataiyakini isaiki Juan, ikantapaakiri: “Rabí, jirintaranki tsipatakimiri intatsikironta jiñaa Jordán, pikinkithatakotakinari, jowiinkaatantzi iroñaaka irirori, ojyiki atziriiti pokashitziriri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ari jakanaki Juan, ikantzi: “Tsika ikanta piñaakiri jirika, tii opoñaashiwaita, aña iri Pawa ñaapirotakaariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Iirokayitaki kimajaantakinari nokantaki pairani: ‘Tii naaka Cristo, apa jotyaantaitakina niiwatapaakiri nonkinkithatakotiri’. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Thami nojyakaantimiro: aririka jaawakaitya, iri aapiintzirori tsinani iimintaitari. Iriima itsipaminthari, iiro jiñaapirowaita irirori, apa inkimoshiritanaki inkimaki jiñaawaitanaki jiimitaitari. Ari nokimitsitakari naaka iroñaaka, tii noñaapirowaita, iro kantzimaitacha, antawo nokimoshiritaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iikiro jiyaatatyi inkimakoitiri jirika, irooma naaka ari nosantzikoityaakoti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Janairi maawoni poñainchari jinoki. Iriima nampitawori kipatsiki, isaawijatzi jinatzi, ikinkithatakotashitapiintawo isaawijato. Iriima poñainchari inkitiki janairi maawoni, ");
INSERT INTO cpcNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ikinkithatakotziro okaatzi jiñiiri, okaatzi ikimiri. Iro kantzimaitacha iiro ikimisantaitziro ikinkithatakotziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Iro kantacha inkaati kimisantanairini, ari jimatanatya irirori ikinkithatakotanairi Pawa tyaaryoori jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ikaatzi jotyaantziri Pawa, jiñaani Pawa ikinkithatakotzi. Tima Pawa jothotyiiro jinampishiritakaantantawo Itasorinka. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jirika Ashitairi jitakotari Itomi, jimatakaakiri ipinkathariwintairo maawoni tzimayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Inkaati kimisantanairini Itomi, ari inkañaanitai. Iriima kaari kimisantairini Itomi, iiro ikañaanitai, apa jatsipitaiyaawo jowasankitagairi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ikanta Fariseo-paini ikimaiyakini, ikantaitzi: “Tzimaki ojyiki jiyotaani Jesús, jowiinkaataki ojyiki atziripaini, janaanakiri Juan”. Jiyotaki Jesús ikimaiyakini Fariseo. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Kaarimachiini Jesús owiinkaatantatsini, aña jiyotaani owiinkaatantatsiri.) ");
INSERT INTO cpcNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Irootaki Jesús ishitowantanakari Judea-ki, ipiyaawo Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ari iintathakitziri inkinanairo iipatsitiki Samaria-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Irojatzi jariitantakari nampitsiki saikatsiri Samaria-ki oita Sicar, iro tsipanampitawori iipatsiti pairani Jacob-ni ipanairiri itomi, José. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ari osaikakiri jiñaa iiyakotani Jacob-ni. Tima jimakokitaki Jesús janiitaki, isaikimotapaakiro jiñaa, jiwiyaaka tampatzika ooryaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ari opokaki Samaria-jato onkai jiñaa. Ikantziro Jesús: “Pimpina jiñaa nirawaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tima jiyaataiyatziini jiyotaani nampitsiki jamananti owanawontsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","maawoni Judá-mirinkapiroriiti tii jaapatziyari kamiithaini Samaria-jatziiti. Ari akanakiri tsinani okantanakiri: “¿Tsika pinkinakairoka iiroka, Judá-mirinka pinatzi, ipoña pikamitana naaka Samaria-jato nompimi jiñaa?” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ari jakanakiro Jesús, ikantziro: “Arimi piyoti iita ipantziri Pawa, ari piyotirimi kamitakimiri jiñaa, iiroka kamitinanimi naaka. Aritaki nompakimiro jiñaa añaakaantatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Okantanaki tsinani: “Pinkatharí, tikaatsi pinkitantyaari jiñaa, inthomainta okantaka omoo, ¿tsikatya payiroka pimpinari jiñaa añaakaantatsiri? ");
INSERT INTO cpcNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Iri achariniiti Jacob-ni panairori pairani jiroka jiñaa, irootaki jimiriyitajaantakari irirori, irojatzi jimiriyitaka itomipaini, jimiriyitsitakawo iijatzi ipiraiti. ¿Panairima iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jakanakiro Jesús, ikantanakiro: “maawoni miritawori jiroka jiñaa, iiro opiya imiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Iriima miritatyaawoni jiñaa nompiriri naaka, iiro jimiriyitai. Tima jiñaatatsiri nopantziri naaka ari oshitowaashiritantaiyaari onkimiwaityaawo oshitowaatantyaarimi jiñaa añaakaantatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Okantzi tsinani: “Pinkatharí, pimpinawo naaka jiroka jiñaatatsiri, iiro napiitantaawo nomiriyitai, iiro nopiyapiyawaitanta jaka nonkai jiñaa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ari ikantziro Jesús: “Piyaati, pinkaimiri piimi, ompoña pimpiyaki jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Okantzi tsinani: “Tikaatsi noimi”. Ikantziro Jesús: “Kamiitha pikantaki, tii itzimi piimi, ");
INSERT INTO cpcNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","tima tzimawitaka pairani ikaatzi 5 piimi. Iriima pitsipatakari iroñaaka, kaari piimi. Imapiro okaatzi pikantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Okimawaki ikantakiro, okantanaki tsinani: “Pinkatharí, niyotanakimi naaka kamantantaniri pinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pairani nochariniiti Samaria-jatziiti ipinkathatapiintziri Pawa jaka otzishiki. Iro kantzimaitacha iirokaiti Judá-mirinkapirori pikantaiyini janta Jerusalén-ki, ari ampinkathatapiintairi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ikantanakiro Jesús: “Pinkimisantawaki tsinani, irootaintsi pimpinkathatairi iirokaiti Ashitairi, iiro okowajaanta pimpoki jaka otzishiki, iiro okowajaanta piyaati iijatzi Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imapirowitatya, tii piyotaiyirini iirokaiti iita pipinkathatapiintziri. Irooma naakaiti niyotziri itzimi nopinkathatziri. Tima jirika owawijaakotantatsini, Judá-mirinka jinatyi. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Iro kantacha, irootzimataintsi. Iriitaki pinkathatajaantziriri Ashitairi pinkathashiritakairi. Tima iriiyitaki ikowiri Ashitairi pinkathayitairini. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Pawa irijatzi Tasorintsinkantsi, kaari koñaatatsini. Inkaati pinkathayitairini, ontzimatyii impinkathashiritaitiri, tii okowajaanta jantayitairo koñaayitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Okantzi tsinani: “Niyotzi naaka, ari impokaki Mesías, jiitaitziri Cristo. Aririka jariitatya irirori, ari inkamantapaakairo maawoni tsika okantakota”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ikantzi Jesús: “Naakataki, ñaanatajaantakimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ari jariitaiyapaani jiyotaani. Iyokitzi jowapaakiri jiñaapaakiri ikinkithawaitakairo tsinani. Iro kantzimaitacha tikaatsi osampitapaakirini oita okowiri tsinani, tsikarika oita ikinkithawaitakairori. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ari ookanakiro tsinani oyowitinaki, jataki nampitsiki, okantapaakiri atziriiti: ");
INSERT INTO cpcNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Pimpokaiyini piñiiri shirampari yotakinawori maawoni nantayitakiri pairani. ¿Kaarima Cristo?” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ikanta ishitowaiyanakini atziriiti nampitsiki, pokaiyanakini isaikinta Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ari ipankinataiyarini jiyotaani, ikantziri: “¡Rabí, poya!” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ikantzi Jesús: “Tzimatsi iita nowari naaka, tii piñagaiyironi iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ari josampitawakaiyanakani jiyotaani: “¿Tzimatsima iita amakiniriri jowanawo?” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iro kantacha Jesús, ikantanakiri: “Nokimitakaantawo nowanawo naaka nantziro ikowiri otyaantakinari, ontzimatyii nonthonkiro antawairintsi ipakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Jiroka pikantapiintaiyini iiroka: ‘Yotapaaka 4 kashiri osampatantyaari pankirintsi’. Iro kantacha nonkantimi naaka pamini pankirintsimashiki, aritaki sampainkataki ontzimatyii oyiipatya. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Inkaati antawaitatsini joyiipatiro pankirintsi ari impinayiitairi. Okaatzi pankirintsi joyiipayiitairi iriiyitaki ojyakaawintacha inkaati kañaanitatsini. Iro inkimoshiritantaiyaari pankitakirori intsipataiyaari oyiipatakirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tima imapirotatya jiroka jojyakaawintaitakiri, ikantaitzi: ‘Tzimatsi apaani pankitakirori, tzimatsi pashini oyiipatakironi’. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Notyaantakimi naaka piyaati iirokaiti poyiipayitairo kaari pipomirintsiwinta pantawaiwintiro. Tima tzimayitatsi pashini pankinatawori jantawaiwintakiro. Iirokayitaki nintagaiyaawoni jantawaitani jirikaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Tima ojyiki Samaria-jatzi saikaintsiri nampitsiki kimisantawakiriri Jesús okantakaantziro tsinani okantantapaaki: “Jiyotakinawo maawoni nantayitakiri pairani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ikanta Samaria-jatziiti, jariitaiyapaakani ipankinatapaakari Jesús isaikimotanakiri inampiki. Ari jimatakiro Jesús, apiti kitiijyiri isaikanaki, ");
INSERT INTO cpcNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ojyiki pashini kimisantanaintsiri ikimajaantakiri iriroriiti okaatzi ikantayitziri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ari ikantaitanakiro tsinani: “Kimisantayitaana naaka iroñaaka, tii iro nonkimisantantaiyaari pikamantapaakina, aña naaka kimajaantairi ikantayitziri. Niyotai iijatzi imapirotatya jowawijaakoshiritantai kipatsiki, iriitaki Cristo”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Okanta imonkaataka apiti kitiijyiri isaikapaaki Jesús Samaria-ki, awijanaki jiyaatiro Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tima iri Jesús kantaintsiri: “Apaani kamantantaniri tii ipinkathaitziri inampipiroki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ikanta jariitaa Galilea-ki, ojyiki aawairiri kamiitha janta, tima aritaki jiñiitsitakari Jerusalén-ki okaatzi jantayitakiri Jesús joimoshirinkiro Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ari jariitaari Jesús janta Caná-ki saikatsiri Galilea-ki, tsika ipiyakiro jiñaa okimiwaitanakawo jimiriitari. Tzimatsi janta iriipirori jiwari, mantsiyataintsiri itomi janta Capernaum-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ikanta jirika jiwari ikimakotakiri Jesús ari jariitaari Galilea-ki ipoñagaawo Judea-ki, jiyaatashitanakiri jiñiiri. Ipankinatapaakari, jiyaati ipankoki, joshinchagairi itomi, irootaintsi inkami. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ari ikantanaki Jesús: “¿Iitama kaari pikimisantantana iirokaiti? Pikowajaantzi noñaayimiro kaari piñaapiintzi pairani, pikowajaantzi nontasonkawintantawaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iro kantacha jiwari ikantanakiri: “Pinkatharí, thamiita iroñaaka, tikira ikamanakiita notomi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ipoña ikantzi Jesús: “Pimpiyi pipankoki. Shintsitai pitomi”. Ikimisantanaki shirampari okaatzi ikantakiriri Jesús, piyanaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ipiyaminthaita ipankoki, itonkiyotawaari jompirataniiti, ikantawairi: “¡Shintsitai pitomi!” ");
INSERT INTO cpcNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Josampitanakiri tsika jiwiyaa ooryaatsiri ikantakoniintantanaari itomi, ikantaiyini jimpiratani: “Chapinki, itainkanaki ooryaatsiri, ari awijanaki isaawawaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ari ikinkishiritanakiro ashitariri aritaki jiwiyaakari ooryaatsiri chapinki ikantakiri Jesús: “Shintsitai pitomi”. Iro ikimisantantanakari irirori, ari ikimitsitanakari iijatzi maawoni ijyininkamirinkaiti irirori ikimisantanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Irootaki apititanaintsiri joñaagantziro Jesús itasonkawintantzi jariitaa Galilea-ki ipoñagaawo Judea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Okanta othonkapaaka jiroka, japiitairo joimoshirinkaiyani Judá-mirinka Jerusalén-ki. Ari jiyaatsitakari iijatzi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Janta Jerusalén-ki, ari osaikiri ikaawoshiminto jiitaitziri iñaaniki Heber-mirinka “Betesda”. Tzimatsi okaatzi 5 opankochaantiki. Ari otsipanampitawo ashitakowontsi jiitaitziro “Oijya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ari ipiyotakari ojyiki mantsiyari, kaari aminatsini, kisopookiri, thoriwaitatsiri jomaryaayitaka kipatsiki joyaawintawo ojyiwaatya jiñaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Tima ikantaitzi: Jinatzi ipokapiintzi maninkariiti ijyiwaatakairo jiñaa, intzimirika itanatyaawoni impiinkaatantyaawo jiñaa ojyiwaata, aritaki ishintsitanai imantsiyawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tzimatsi mantsiyari tzimakotaintsiri 38 osarintsi imantsiyawaitaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ikanta Jesús jiñaapaakiri jomaryaaka, jiyotapaaki osamani jimantsiyawaitaki jirika, josampitapaakiri, ikantziri: “¿Pikowima pishintsitai?” ");
INSERT INTO cpcNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ari jakanaki mantsiyari: “Pinkatharí, tii itzimi iitya owiinkaatinani aririka ojyiwaapaititya jiñaa. Tima nokowawitapiinta nompiinkaatimi naaka, janaakotana pashini ipiinkaataki irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ari ikantzi Jesús: “Pintzinai, paanairo pomaryaaminto, piyaatai”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Apathakiro ishintsitanai jirika, jaanairo jomaryaaminto, aniitanai. Iro kantacha, tima kitiijyiri jimakoryaantaitari inatzi, ");
INSERT INTO cpcNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ikantakiri Judá-mirinkaiti jirika shirampari shintsitaatsiri: “Kitiijyiri jimakoryaantaitari inatzi iroñaaka, tii oshinitaantsitzi paanairo pomaryaaminto”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jakanaki jirika shirampari, ikantzi: “Ikantakina oshinchagaanari: ‘Paanairo pomaryaaminto, piyaatai’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ari ikantaiyanakini Judá-mirinka: “¿Iitaka kantakimiri: ‘Paanairo pomaryaaminto, piyaatai?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Iro kantacha jirika shirampari tii jiyotziri iita oshinchagairiri, tii jiñaawairi Jesús tsika ikinanaki, ipiyotaiyakani atziriiti janta. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ipoña Jesús jiñagairi shirampari janta tasorintsipankoki, ari ikantziri: “Pinkimi, aritaki shintsitaimi iroñaaka, iiro papiitairo pantairo kaaripirori, ari onkantya iiro awijyimotantaimi kowiinkapirotatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ikanta jirika shirampari jatanaki, ikamantakiri Judá-mirinkaiti iriitaki Jesús oshinchagairiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iro opoñaantari ikowi Judá-mirinkaiti intsitokiri Jesús, tima joshinchaantaki kitiijyiri jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iro kantzimaitacha, ikantanaki Jesús: “Ari ikantaitatyaani jantawaitzi Ashitanari, ari nokimitsitari iijatzi naaka nantawaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Irootaki, ikowapirotantanakari Judá-mirinkaiti intsitokiri Jesús, tima tii apa jantawaitantakawo kitiijyiri jimakoryaantaitari, aña jojyakotakari Pawa, ikantakira Jesús iriitaki Pawa iwaapatitajaantari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ipoña Jesús jakanakiri, ikantziri: “Jirika Itomitari Pawa tikaatsi jantashiwaitya ikowakaanikiini. Apa jantziro okaatzi jiñaakotziriri Ashitariri. Okaatzi jantziri Ashitariri, irojatzi jantziri Itomi. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tima jitakotari Ashitariri jirika Itomitari, joñaayiri maawoni jantayitziri irirori. Iikiro joñaagatyiiri oitarika antawoititatsiri, iyokitzi powiri iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tima ikimita Ashitariri jañaakaayitziri kaminkari, ikañaanitakairi, ari ikimitari iijatzi Itomitari, jañaakaayitiri inkowiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tii jiyakawintantzi Ashitariri, aña iri Itomi ishinitaki jiyakawintantai, ");
INSERT INTO cpcNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ari onkantya maawoni impinkathaitantyaariri Itomi ikimitaitziri Ashitariri. Kaari pinkathatairini Itomitari, tii ipinkathatsitari Ashitariri, otyaantakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Itzimirika owakimpitatyaawoni nokantayitziri, impoña inkimisantanairi otyaantakinari, aritaki inkañaanishiriyitai. Iiro jowasankitaawaitaitziri, tima kaatapaaki ikaamaniwaitzi, kañaani ikantayitaa. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Irootzimataintsi imonkaatya, iroñaaka, inkimapaititairo kamashiririiti iñaani Itomi Pawa. Inkaati kimawaironi, aritaki jañaashiriyitai. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tima ikimita Ashitariri jañaakaantzi, iro ishinitakiniri iijatzi Itomi jañaakaanti irirori, ");
INSERT INTO cpcNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ishinitakiniri iijatzi jiyakawintantai, tima iriitaki Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Iiro piyokitziiwintashitawo jiroka. Tima irootzimataintsi imonkaataiya inkimantaiyaawori kaminkariiti iñaani, ");
INSERT INTO cpcNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ari impiriintayitanaki tsika ikitayitaka. Ikaatzi antayitakirori kamiithari, ari inkañaaniyitai. Iriima ikaatzi antapiintakirori kaaripirori, jañaawitaiya jowasankitaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Tii nantashiwaitawo nokowashitari, iri Ashitanari shinitanawori niyakawintantai. Okaatzi nokantakowintantziri tampatzika okantaka, tima tii nantashiwaitawo nokowiri naaka, aña iro ikowiri Ashitanari otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Naakami kinkithatakowaitashitachani apaniroini, tii opantawo nokinkithatakowaiwitaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iro kantzimaitacha tzimatsi kinkithatakotakinari, niyotzi irootaki tyaaryoopirotatsiri ikinkithatakotakinari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Imapirotatya ikinkithatakotakina Juan potyaantantakari pairani josampitaitiri. Tima okaatzi ikinkithatakotawakinari imapirotatya. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iro kantacha tii iro nonkinkithatakomachiiti okaatzi ikinkithatakotakinari atziri kimitakariri Juan. Aña iro nokinkithatakotzi matzirori owawijaakoshiritaimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Tima Juan iri kimitakariri ootamintotsi kitiijyiinkatapaintsiri. Iro pikowapaintziri iirokaiti pinintaawatyaawo ikimitari kitainkari. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Iro kantacha tzimatsi kinkithatakotanari naaka, anairiri Juan. Okaatzi nantziri naaka, irootaki ikantanari Ashitanari nantiro, iro oñaagantzirori iri Ashitanari otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ari ikimitakari Ashitanari, otyaantakinari, ikinkithatakotakina irirori, tiimaita pikimisantziro iñaani. Tii piñaapootanitziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tii otyaantaajaitzimi iñaani, tima tii pikimisantziri jotyaantani. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Amatsinka pikantawita piñaanatziro Osankinarintsipirori, poyaakoniintawo piñaayitairo pinkañaanitai. Aña naakawitaka okinkithatakotzi Osankinarintsipirori, ");
INSERT INTO cpcNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","tiimaita pikowaiyini iiroka pawintaayitaina pinkañaanitantaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Tii naminaminatashitawo naaka inthaamintawaitina atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Aña niyotsitataikimi tsika pikantaiyani iiroka, niyotsitzimi iijatzi tii pitakotari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naakataki jowaki Ashitanari nopairyagairo iwairo. Tiimaita pagaiyawakinani kamiitha iirokaiti. Irooma aririka impoki pashini pairyaashiwaitapaatyaawoni iwairo irirori, iri paayitawakiri kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Tsikama pinkini pinkimisantaiyini, iiroka thaamintashiwaitawakaacha, tii paminaminatziro pinthaamintawintaiyaari Pawapirotatsiri? ");
INSERT INTO cpcNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Iiro pikinkishiriwaitashita naaka thawitakotimini Ashitanariki. Iri thawitakotajaantaimini Moisés-ni, pawintaapiintari iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Arimi pinkimisantaajaitakirimi Moisés-ni, ari pinkimisantawakinami naaka, tima naakataki josankinatakotaki Moisés-ni. ");
INSERT INTO cpcNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Irooma tii pikimisantziro okaatzi josankinatakiri, ¿tsikama pinkini pinkimisantiro nonkantayitimiri naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ikanta othonkapaaka jiroka, montyaanaki Jesús intatsikironta inkaari saikatsiri Galilea-ki, irojatzi jiitaitziri Tiberias. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ojyiki atziri oyaatakiriri, tima jiñaakitziiri itasonkawintantaki joshinchaayitairi mantsiyariiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ipoña itonkaanaki Jesús otzishiki, ari isaikapaaki itsipayitakari jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Irootaki ariitzimataiya kitiijyiri Anankoryaantsi, ari joimoshirinkapiintari Judá-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ikanta jaminapaaki Jesús, jiñaatzi ojyiki atziri oyaatakiriri, ikantanakiri Felipe: “¿Tsikama amanantika owanawontsi owakaiyaariri maawoni jirika atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aña josampitashitari Felipe jiñaantyaariri tsika inkanti, tima jiyotajaantaki Jesús oita jantiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ari jakanaki Felipe, ikantanaki: “Iiro jantita 200 kiriiki amanantimi owanawontsi, aña iipichokiini jowamatsitya jirikaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ipoña ikantanaki Andrés, iriitaki pashini jiyotaani, iririntzi Simón Pedro, ikantzi: ");
INSERT INTO cpcNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Jirika jaka iintsi amaintsiri 5 tanta, apiti shima. Iro kantacha, ¿arima jantitatyaari ojyiki atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ari ikantzi Jesús: “Pinkantiri isaikaiyini maawoni”. Okatawoshimashitatzi janta, ari isaikaiyakini. Ikaataiyini 5000 shirampariiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ari jaakotanakiro Jesús tanta, ithonkakiro ipaasoonkitakiri Pawa, jinashiyitakari ikaatzi saiyitaintsiri. Ari ikimitaakiri shima, ipayiitakiri maawoni kowatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ikanta ikimaniintaiyapaakani maawoni, ikantairi Jesús jiyotaani: “Paayitairo opitoki okaatzi tzimagaantapaintsiri, iiro apaawaitanta”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Joyiitairo jiyotaaniiti, ijaikiyitai 12 kantziri opitoki tzimagaantapaintsiri kaawitachari 5 tanta. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jirikaiti atziri, jiñaakiro itasonkawintakiro Jesús owanawontsi, ikantaiyanakini: “Imapirotatya, iriitaki jirika Kamantantaniri ikajyaakagaitakiri impoki jaka kipatsiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Iro kantacha Jesús jiyotaki ishintsiwintaitatyiiri jaayiitanakiri impinkathariwintiri atziriiti, iijatzi itonkaanai otzishiki, inkini isaikawaiti apaniroini. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ikanta otsiniriityaanaki, oirinkaiyaani inkaariki jiyotaani Jesús, ");
INSERT INTO cpcNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","otitaiyapaani pitotsiki, montyaakotaiyaini jiyaatairo Capernaum-ki. Aritaki tsiniripirotanaki, tikira ipiyaata irirori Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ari otampiyatapaaki, antawoiti otamaryaakotanaki inkaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Aritaki santhataki jimontyaakotaiyini, jiñaatziiri Jesús ipokashitairi janiitantaawo inkaari. Antawo ithaawaiyanakini jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ikantapai Jesús: “¡Naakataki, iiro pithaawaiyini!” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kimoshiri ikantaiyani jotitawairi pitotsiki, tikira osamanitzi, aatakotaiyapaakani tsika ikowiro jariitya. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Okanta okitiijyitamanai, irojatzi isaikaiyakini atziriiti intatsikironta, jiyotaiyakini apinto inatzi pitotsi jimontyaantanakari yotaariiti, tii itsipatanaari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ariitakotantapaaka pashini pitotsi poñainchari Tiberias-ki, aataiyapaakani okaakitzi jowaiyakani tanta chapinki ipaasoonkiwintakiri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ikanta jiñaakiri tii isaiki Jesús, iijatzi jiyotaaniiti, otitaiyanakani atziriiti pitotsiki, jataki Capernaum-ki jamina-minatairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ikanta jariitaiyapaakani intatsikironta, jiñaapairi Jesús, josampitapaakiri: “Rabí, ¿tsikapaitima pipokaki iiroka jaka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ikantanakiri Jesús: “Irootaki pamina-minatantanari iirokaiti tima pikimaniintaiyakani chapinki powaiyakani, aña tii iro pamina-minatantinari pikimathatanakiro notasonkawintantaki. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tii opantawo piñaashintsiwintashiwaityaawo owanawontsi thonkanitachari, aña iro piñaashintsiwintya initatsiri, kañaanitakaimini. Iro owanawontsi ipantziri Itomi Atziri, tima Pawa, Ashitariri, iriitaki jookotakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ipoña josampiitanakiri, ikantaitziri: “¿Tsikama nonkantyaaka noñaashintsiwintantyaawori ikowiri Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jakanaki Jesús: “Ikowiri Pawa pinkimisantairi jirika jotyaantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ipoña josampiitanakiri iijatzi: “¿Incha pintasonkawintanti nonkimisantimiri? ¿Iitama pantayitakiri? ");
INSERT INTO cpcNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Pairani achariniiti jowayitakawo otzishimashiki jiitaitziri ‘maná’, irootaki okantziri Osankinarintsi: Pawa pakiri owanawontsi paryaintsiri inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jakanaki Jesús, ikantzi: “Okaatzi owanawontsipirotatsiri poñaachari inkitiki, kaari Moisés-ni pantironi. Aña iri Ashitanari payitimironi. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tima jirika owanawontsi ipantziri Pawa, iriitaki poñaachari inkitiki, iri kañaanitakaayitairini isaawijatziiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ari ikantaitanakiri: “Pinkatharí, pimpapiintinawo jiroka owanawontsi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ikantzi Jesús: “Naakataki owanawontsi kañaanitakaantaniri. Inkaati tsipatainani naaka, iiro itajyaawaitai. Inkaati kimisantanainani, iiro jimiriwaitai. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Aritaki nokantaiyakimini, tiimaita pikimisantaiyanani okantawitaka piñaawitakina. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ikaatzi itsipashiritakaakinari Ashitanari, iriiyitaki tsipashiripirotainani, iiro nomanintawakiri naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Tima tii iro nompokantatyaari nopoñaaka inkitiki nantayitiro nokowashiwaitari naaka, aña iro nantapiinti ikowiri Ashitanari, otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jiroka ikowiri Ashitanari otyaantakinari, iiro nopiyakaantawaitzi apaani ikaatzi itsipashiritakaakinari, aña ontzimatyii nowiriintayitairi iwiyaantapaatyaawoni kitiijyiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Tima ikowi Ashitanari iijatzi, maawoni kowakowatairini Itomi Pawa, inkaati kimisantairini, aritaki inkañaanitakaayitairi. Naakajaantaki owiriintairini imonkaatapaatyaarika kitiijyiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iro ipoñaantanakari Judá-mirinkaiti ikijyimawaitanakiri Jesús, tima ikimaki ikantaki: “Naakataki owanawontsi poñaachari inkitiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ari ikantawakaiyanakani: “¿Kaarima jirika Jesús, itomi José? Niyotziri naaka ashitariri. ¿Iitama ikantantari: ‘Nopoñaatya inkitiki?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ikantanaki Jesús: “Aritapaaki pikijyimawaitana. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Tikaatsi tsipashiriwaitinani, iirorika jamashiritairi Ashitanari otyaantakinari. Naakataki owiriintairini imonkaatapaatyaarika kitiijyiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Josankinariki Kamantantaniriiti, ikantaki: Iri Pawa yotagairini maawoni. maawoni kimairiri Ashitanari, yotairiri irirori, itsipashiritaana naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tii nokantzi tzimatsi ñaapootakirini Ashitanari, aña apaniroini jiñaapootziri poñaachari Pawaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Itzimirika kimisantainani naaka, aritaki inkañaanitai. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naakataki owanawontsi añaakaantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jowawitakawo pichariniiti ‘maná’ otzishimashiki, kamayitzimaitaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Iriima ojyakawori owanawontsi nokinkithatakotziri naaka ipoñaatya inkitiki. Itzimirika owaiyaarini jirika, iiro ikaamanitai. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naakataki kañaaniri owanawontsi poñaachari inkitiki. Intzimirika owatyaawoni jiroka owanawontsi, ari inkañaanitai. Jiroka owanawontsi nopantziri naaka, nowathapiro inatzi. Iri noshinitakowinta isaawijatziiti inkañaanitantaiyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ari ikantawakaiyani Judá-mirinka: “¿Tsika inkinakairoka jirika jowakaantairori iwatha?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ikantanaki Jesús: “Iirorika powawo iwatha Itomi Atziri, iirorika piriro iriraani, iiro pikañaanitai. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Itzimirika owatyaawoni nowatha, irakironi niraani, ari inkañaanitai. Naakataki owiriintairini imonkaatapaatyaarika kitiijyiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tima jiroka nowatha owanawontsipirori inatzi, jiroka niraani iro imiripiroitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Intzimirika owatyaawoni nowatha, irakironi niraani, itsipashiritaatyaana naaka, iijatzi naaka notsipashiritatyaari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tima jirika Ashitanari otyaantakinari, kañaaniri jinatzi, iriitaki añaakaanari naaka. Ari okimitsitari iijatzi, intzimirika owaiyaanari naaka, iriitaki nañaakaayitairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nokinkithatakotatziiro owanawontsi poñaachari inkitiki. Jiroka owanawontsi tii ojyawo ‘maná’ jowayitakari pairani pichariniiti iiroka, okantawitaka jowawitakawo, ikamayitaki. Iriima inkaati owatyaarini jirika ojyawori owanawontsi, ari inkañaanitai”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Irooyitaki jiyotaantakiri Jesús ipiyotaiyakani janta japatotapiintaita saikatsiri Capernaum-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ikanta ikimaitakiro jiroka yotaantsi, jirikaiti ikaatzi oyaatziriri Jesús, ikantaiyanakini: “Jiroka ikantayitakiri Jesús pomirintsi akantyaawori. ¿Iitama kimisantamachiitirini?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ikanta Jesús, jiyotaki okaatzi ikijyimawaitziriri, josampitanakiri: “¿Tiima inimotzimi jiroka? ");
INSERT INTO cpcNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Iitama awijatsini, aririka piñiiri Itomi Atziri intzinagaiya ipoñaaka pairani? ");
INSERT INTO cpcNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Okaatzi nokinkithatakotakimiri, iro kantakotacha añaashiritakaantatsiri, kaari awathapirori nokinkithatakotzi, tikaatsi oitapirotya awatha. Aña iro nokinkithatakotzi awintaashirinkantsi kaari koñaanitatsi, kañaanitakaantatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Iro kantacha iinitatsi iirokaiti kaari kimisantatsini”. Tima jiyoshiritakiri Jesús kaari kimisantatsini, inkaati pithokashitirini. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iikiro ikantanakitzi Jesús: “Iro nokantsitakimiri: ‘tikaatsi tsipashiriwaitinani naaka: iirorika ishinishiritaanari Ashitanari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aripaiti, ipiyapithatanakari Jesús ojyiki oyaawitapiintariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ipoña josampitanakiri Jesús 12 jiyotaani: “¿Pikowima iirokaiti piyaayitai?” ");
INSERT INTO cpcNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ari jakanaki Simón Pedro: “Pinkatharí, ¿Iitama niyaatashitiri? Aña iirokataki kinkithatakotakirori añaamintotsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Aritaki nokimisantaiyakimini. Niyotaiyini iirokataki Cristo, Itomi Pawa Kañaaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jakanaki Jesús, ikantziri: “¿Kaarima naaka iyoshiitakimiri pikaataki 12? Iro kantzimaitacha, tzimatsi apaani pikaataki kamaarishiryaaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jiñaawaitakiro jiroka Jesús, ikinkithatakotatziiri Judas, Itomi Simón Iscariote. Tima iriitaki Judas pithokashityaarini, iriiwitaka itsipatapiintari 12 jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ikanta othonkapaaka jirokapaini, jariitantawaita Jesús janta Galilea-ki. Tii ikowi isaikanai Judea-ki, tima jaminaminatatziiri Judá-mirinkaiti intsitokiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iro kantacha monkaatzimataa kitiijyiri ikimoshiriwintapiintziro Judá-mirinkaiti jiitaitziri “pankojyitantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ithainkitanakari, iririntzi okaakiini, ikantanakiri: “Iiro pimanawaita jaka, piyaati Judea-ki jiñaantimiri piyotaaniiti onkaati pantayitiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tima ikaatzi kowatsiri jasagaawintaityaari, tii imanakaawo jantayitziri. Pantayitziro iiroka oiyitarika, poñaagantiro tsika ipiyotaiyani atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tiitya ikimisantaajaitziri iijatzi iririntzipaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ari ikantanaki Jesús: “Aña tikira imonkaapaititaata noñaagantantya naaka, irooma iirokaiti inimowaitzimi maawoni kitiijyiriki. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tii ikisaniintzimi iirokaiti isaawijatziiti. Irooma naaka owanaa ikisaniintana, tima koñaawo nokantziro naaka, okaatzi jantayitziri kaaripirori inatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Piyaataiyini iiroka joimoshirinkaita, iiro niyaatsita naaka, tima tikira imonkaapaitita noñaagantya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ikantakiro jiroka, irojatzi isaikanaki Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ari jataiyakini iririntzipaini, jatanaki iijatzi Jesús joimoshirinkaita tii joñaagantajaanta, imananikiini ikantaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jaminaminatakiri Judá-mirinkaiti janta joimoshirinkaita, ikantaiyini: “¿Tsikama isaikaajaitzika shirampari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ojyiki atziriiti kinkithatakotakiriri Jesús. Tzimatsi kantayitatsiri: “Kamiithari jinatzi shirampari”. Tzimatsi pashini kantatsiri: “Tii ikamiithatzi, aña jamatawitakiri atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Iro kantzimaitacha, manaantsikiini ikinkithatakoitziri Jesús, tima ithaawantatyaari Judá-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Okanta oniyankitaki joimoshirinkaita, tyaapaaki Jesús tasorintsipankoki, jiyotaantapai. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Iyokitzi ikantawakaiyanakani Judá-mirinka, ikantaiyini: “¿Tsikama jiyotanitantari jirika, tii ityaapirowita tsika jiyotaantaitzi?” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ari jakanaki Jesús, ikantzi: “Okaatzi niyotaantziri tii naaka yotashityaawoni, aña iri yotakaanawori otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inkaati kowapirotaironi ikowiri Pawa, ari jiyotairo iri Pawa yotakaanawori okaatzi niyotaantziri, tima tii naaka yotashiwaityaawoni. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tima ikaatzi yotaantzirori jiyotashiwaitari, jaminaminatatzi impinkathaitiri. Iriima kowakowatzirori ipinkathaitairi otyaantakiriri, iri ñaawaitzirori iroopirori. Tii itzipishiriwaitzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Tiima josankinawitakimi pairani Moisés-ni Ikantakaantaitani? Iro kantacha, tii pimonkaataiyironi. ¿Iitama pasaryiimatantanari pintsitokina?” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ari ikantaiyanakini atziriiti: “¡Kamaarí! ¿Iitama asaryiimatzimiri intsitokimi?” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ikantzi Jesús: “maawoni iirokaiti owanaa iyokitzii pikantayitaka piñaakina nantakiri kitiijyiriki jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iro kantzimaitacha, ikantakaantaki Moisés-ni pintomishitaanitapiintanti. (Okantawitaka kaari Moisés-ni poñaakaantyaawoni jiroka, aña iri poñaakaantanakawori achariniiti tikiraamintha itzimi Moisés-ni.) Iro opoñaantari pitomishitantapiintaki iirokaiti, kitiijyiri jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Piñaakiro, pimonkaatantyaawori iirokaiti Ikantakaantani Moisés-ni pitomishitantapiintaki kitiijyiri jimakoryaantaitari. ¿Iitama pikisaniintantanari naaka noshinchagairi atziri maawoni iwathaki kitiijyiriki jimakoryaantaitari? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Paamaakowintya owapiyimotzimikari aririka piyakawintanti. Aña tampatzikashiripiro pinkantya piyakawintanti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tzimayitatsi Jerusalén-jatzi, osampitantanaintsiri, ikantzi: “¿Kaarima jirika jaminaminaitziri intsitokaitiri? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Jirinta isaikaki, maawoni jiñaitziri ikinkithawaitzi. Tikaatsitya akotashitirini. ¿Jiyotatziima jiwariiti imapirotatya Cristo jinatzi jirika shirampari? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Iro kantacha ayotaiyirini jirika tsika ipoñaawo. Irooma paata aririka impokaki mapirotzirori jiita Cristo, tikaatsi yotatsini tsika ipoñaawo”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ikanta ikimaki Jesús, isaiki jiyotaantzi tasorintsipankoki, shinchiinka ikantanaki: “¡Arima, piyotaiyinima tsika nopoñaawo! Tii naaka nintakaashityaawoni nompoki, aña jotyaantani ninatzi jawintaapiroitari. Kaari piyotaiyini iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Niyotziri naaka tima iri notsipatari, iriitaki otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ari ikowawitanaka jaakaantirimi, iro kantacha tikaatsi akotashitirini, tima tikira imonkaapaititaata. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ojyiki kimisantanakiriri Jesús, ikantaiyini: “Kaaririka jirika Cristo pokatsini, iirotya itasonkawintantzimi, ñaakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ikanta Fariseo-paini ikimakiri atziriiti ikinkithatakotziri Jesús, jaapatziyanakari ijiwari Ompiratasorintsitaari, jotyaantaki aamaakowintawori tasorintsipanko jotiyiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ari ikantzi Jesús: “Kapichiini nosaikimotanaimi iirokaiti, irootaintsi niyaatai isaiki otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ojyiki paminawitaina, iiro piñagaana, iiro pitsipatana tsika nosaikapai naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ari josampitawakaanaka Judá-mirinkaiti: “¿Tsika jiyaamachiitika jirika iiro añaantari? ¿Jiyaatatyiima pashiniki nampitsi ikinayitaki ajyininkapaini, inkini jiyotaayitairi kaari ajyininkata? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Iitama ikantakotziri: ‘Paminawitaina, iiromaita piñagaana, iiro pitsipataana tsika nosaikapai naaka?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ikanta iwiyaantapaakawori kitiijyiri ari joimoshirinkapiroitari. Ari ikatziyanaka Jesús, shintsiini jiñaawaitanaki, ikantzi: “Itzimirika miriniintawaitatsini, intsipashiritaina naaka, jimiriwaitaiya. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tima okantzi Osankinarintsipirori: Inkaati kimisantainani naaka, onkimitaiyaawo oshiyaashiritantyaarimi jiñaa kañaanitakaantatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iri jojyakaawintzi Jesús inkaati kimisantairini inampishiritantaiyaari Tasorintsinkantsi. Okantawitaka tikiraata jotyaantiriita Tasorintsinkantsi, tima tikiraata itzinaashitaawo Jesús jowaniinkawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tzimatsi kimakiriri Jesús ikantaki, ikantaiyanakini: “Imapirotatziiri jirika shirampari Kamantantaniri jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tzimatsi pashini kantanaintsiri: “Cristo jinatzi jirika”. Ikantzi pashini: “Kaari, tima Cristo iiro ipoñaawo Galilea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tima okantzi Osankinarintsipirori: Impoñiiyaawo Cristo-tatsiri janta Belén-ki, inampiki pairani pinkathari David-ni. Iriitaki icharini David-ni”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ari itzimawintawakaawintanakari atziriiti jirika Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tzimatsi kowawitanainchari jaakaantirimi, tikaatsimaita akotashitirini. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ikanta aamaakowintawori tasorintsipanko jataiyaini isaiki Fariseo-paini itsipayitakari ijiwari Ompiratasorintsitaari, josampitawairi, ikantziri: “¿Iitama kaari pamantakari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ari ikantaiyini irirori: “¡Tii jiñaitzi kimityaarini jirika jiñaawaitzi!” ");
INSERT INTO cpcNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ikantanaki Fariseo: “¿Pimatsitakawoma jamatawiitakimi iirokaiti? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Tzimatsima ajiwariti kimisantakiriri jirika shirampari? ¿Tzimatsima nokaatziri Fariseo kimisantakiriri? ");
INSERT INTO cpcNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Apa ikimisantamachiitzi atziriiti kaari yotakotironi Ikantakaantaitani, owasankitagaari jinayiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ikanta Nicodemo, Fariseo-tatsiri pokaintsiri pairani jiñiiri Jesús, ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Okantzi Ikantakaantaitani, tii oshinitaantsitzi ayakawintanti tiirika akimajaantzi oita jantakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ari ikantaiyanakini irirori: “¿Iirokatakima iijatzi Galilea-jatzi? Piñaanapirotiro Osankinarintsipirori, ari piñaakiro tikaatsi Kamantantaniri poñaachani Galilea-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ipoña jiyaataiyaini ipankopainiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ipoña irirori Jesús tonkaanaki otzishiki Olivo. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ikanta okitiijyitamanai, ipiyaa tasorintsipankoki. Ojyiki atziri piyowintawaariri, saikapai Jesús jiyotaapairi atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ikanta Yotzinkariiti itsipayitakari Fariseo-paini jamakiniri tsinani jiñaitziri omayimpirotzi. Jowatziyapaakiro niyankiniki ipiyotaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ikantapaakiri Jesús: “Yotaantanirí, jiroka tsinani jiñaitakiro omayimpirotzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ikantakaantaki pairani Moisés-ni intsitokaitiro, mayimpirotatsiri tsinani. ¿Tsikama pikantzika iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iro josampitantariri ikowi inkompitakaiyaari, ontzimantyaari oita inkantakotiriri. Oiyotanaka Jesús kipatsiki josankinawaitantawo jako. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Iikiro josampitatziiri, ari ikatziyanaka joiyotaka, ikantanakiri: “Tiirika pikaaripiroshiritaiyini iirokaiti, pitakaantyaawo pintsitokantyaawo mapi jiroka tsinani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iijatzi joiyotanaa kipatsiki, japiitanairo josankinawaitzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ikanta ikimawakiro ikantakiri Jesús, piyaiyanakani, ikinkishiritakotanaka tsika ikantayita iriroriiti. Iri itanakawo ipiyanaka Antaripiroriiti. Ikanta isaikanaki Jesús itsipatakawo tsinani jamaitakiri, ");
INSERT INTO cpcNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ikatziyanaa joiyotaka, josampitziro ikantziro: “Tsinaní, ¿Tsika ikinaiyanakinika? ¿Tikaatsima yakawintimini?” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Akanakiri iroori okantziri: “Tikaatsitya, Nowinkathariti”. Ikantzi Jesús: “Iijatzi naaka iiro niyakawintzimi. Piyaatai, iiro papiitairo pinkaaripiroshiriwaitai”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ipoña japiitanakiro Jesús jiyotairi atziriiti, ikantziri: “Naakataki kitiijyiinkatakotziriri isaawijatziiti. Itzimirika tsipashiritaiyaanani naaka, aritaki nonkitiijyiinkatakotairi, onkimiwaityaawo tii ikinawaitzi otsinirikitaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ari ikantaiyanakini Fariseo-paini: “Powakowintawaitashita pikinkithatakota apaniroini, tii opantawo pikinkithatakowitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ari jakanaki Jesús: “Kamiithataki okaatzi nokinkithatziri naaka, okantawitaka nokinkithatakowitaka apaniroini. Tima niyotzi tsika nopoñaakawo, tsika janta niyaatai. Tii piyotaiyini iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Iro pamitapiintaka pojyakotari atziriiti jiyakawintantzi. Irooma naaka tikaatsi niyakawinti. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Irooma aririka niyakawintanti naaka, iroopirori inatzi noñaani, tima tii apaniroini niyakawintanti, ari notsipatari Ashitanari otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Jiroka okantzi Ikantakaantaitani ipaitakimiri iirokaiti: Intzimirika apiti kinkithatakotantatsini ari ojyawakaa inkantayitakiri, imapirotatya ikinkithatziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naakajaantaki kinkithatakotaincha. Iijatzi Ashitanari otyaantakinari irijatzi pashini kinkithatakotanari. Apiti nokaatzi nokinkithatakotaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ari josampitanakiri: “¿Tsikama isaikiri Ashitzimiri?” Ikantzi Jesús: “Tii piyotaiyinani iirokaiti, iijatzi pikimitaakiri Ashitanari. Ari piyotinami naaka, ari piyotakirimi iijatzi Ashitanari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ari ikinkithatakiro Jesús jirokapaini tasorintsipankoki, tsika jowaitapiintziri kiriiki jashitakaitariri Pawa. Tikaatsimaita aakaantirini, tima tikira imonkaapaitita. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ipoña japiitanakiro Jesús ikantzi: “Aririka niyaatai, owanaa paminawitaina iirokaiti, iro kantzimaitacha ari pinkamakoyitairo piyaaripironka. Tima tsika niyaatai naaka, iiro pariiyitaa iirokaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ari ikantaiyanakini Judá-mirinkaiti: “Ishiniwaitatya jirika. Iro ikantantari iiro ariita aakaiti tsika jiyaati irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ikantanaki Jesús: “Isaawijatzi pinayitzi iiroka, irooma naaka jinokijatzi ninatzi. Ari pinampitawo iirokaiti kipatsiki, irooma naaka tii nonampityaawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Irootaki nokantantzimiri: ‘Ari pinkamakoyitairo piyaaripironka. Tima iirorika pikimisantairo nokinkithatakowitaka, ari pinkamakotairo piyaaripironka’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ipoña josampitanakiri: “¿Iitaka iiroka?” Ari jakanaki Jesús: “Aritaki nokamantsitakimi owakiraini. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tzimatsi ojyiki nonkantimiri, ari niyakawintaimi iijatzi. Tima okaatzi iñaawaitziri otyaantakinari iroopirori inatzi. Irootaki nokamantzimiri iirokaiti isaawijatziiti, okaatzi ikamantanari irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iro kantacha jirikaiti kimakiriri Jesús, tii ikimathatawakiri ikinkithatakotatziiri Ashitairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Irootaki ikantantanakari Jesús: “Aririka pimpaikakotakaantiri Itomi Atziri, aripaiti piyoti naakataki. Tii naaka antashiwaityaawoni nokowakaari. Apa niyotaantziro okaatzi jiyotaanari Ashitanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Itzimi otyaantakinari ari itsipashiritana naaka. Tii jookawintana Ashitanari, tima nantapiintziniri okaatzi kamiithatzimotziriri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ikanta ikinkithatakoyitakiro Jesús jiroka, ojyiki kimisantanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ipoña Jesús ikantanakiri Judá-mirinkaiti ikaatzi kimisantakiriri: “Aririka poisokirotanatyaawo noñaani, iirokataki tyaaryoori niyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Aritaki piyotairo tyaaryoori, iro saikakaashiwaitaimini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jakaiyanakini jirikaiti: “Ichariniiti Abraham-ni ninayitzi naakaiti. Tikaatsi ompirawaityaanani. ¿Iitama pikantantanari iiroka: ‘Ari pisaikashiwaitaiya?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ikantzi Jesús: “Ikaatzi antapiintzirori kaaripirori, kimiwaitaka ompiratatyaarimi. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Apaani ompirataari kantatsi jomishitowaitiri, iriima itomiitari ikantaitatyaani ijyininkamirinkaitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Aririka isaikakaashiwaitaimi Itomiitari, iikiro pisaikashipirowaitanaatyi. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Niyotaiyimini ichariniiti Abraham-ni pinatzi. Iro kantzimaitacha pikowaiyakini pintsitokina, tima tii okamiithatzimotzimi noñaaniyitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Iro nokinkithatakotzi naaka okaatzi joñaaganari Ashitanari. Irooma iirokaiti pantashitawo pikimakotairi ashitzimiri iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ari jakaiyanakini iriroriiti: “¡Aña iri Abraham-ni jiitaitziri Ashitanari, iriitaki nochariniiti!” Ipoña ikantzi Jesús: “Iirokami charinityaarinimi Abraham-ni, ari pantakiromi okaatzi jantayitakiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Iro kantacha, okantawitaka nokinkithatakaawitakimiro jiyotakaakinari Pawa, pikowaiyakini pintsitokina. ¡Tii jimataajaitziro Abraham-ni kantachari! ");
INSERT INTO cpcNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Irojatzi pantapiintakiri okaatzi jantakiri pairani pichariniiti”. Ari ikantaiyanakini iriroriiti: “¡Tii naaka jowaiyantani thainkatasorintsiwaitaniri. Apaani ikanta Ashitanari, iriitaki Pawa!” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ari jakanakiri Jesús: “Imapiromi iri Pawa ashitimini, ari pitakotatyaanami, tima Pawaki nopoñaakawo naaka. Tii naaka pokawaitashitachani nonintakaanikiini, aña iri Pawa otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Oitama kaari pikimathatantana iirokaiti? Iro kantakaantzirori tii pikowaiyini pinkimisantiro noñaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Iriitaki ashitakimiri kamaari, pantapiintakiniri okaatzi ikowiri. Ari jashi jowakiro kamaari owakiraa itantanakawori, jowamaashiritantzi. Thiiyinkari jinatzi, tii jiñaawaitziro tyaaryoori. Aririka inkowi jamatawitanti, jiñaawaitziro thiiyaantsi. Iwaapati thiiyinkari jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Irooma naaka noñaawaitziro tyaaryoori ñaantsi, tiimaita pikimisantaiyanani iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Tzimatsima apaani pikaataiyakini yopirotzirori ikantzi: ‘Kaaripiroshiriri jinatzi Jesús?’ Tima iroopirori inatzi okaatzi noñaawaitziri ¿oitama kaari pikimisantantana? ");
INSERT INTO cpcNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Itzimirika jashitari Pawa, ikimisantziro iñaani Pawa. Irooma iirokaiti tii jashitzimi Pawa, tii pikowi pinkimisantaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ikanta Judá-mirinkaiti ikantanakiri Jesús: “Imapirotatya nokantaiyakimini Samaria-jatzi pinatzi, tima kamaari pinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ari jakanaki Jesús: “Tii nokamaaritzi, nopinkathatziri naaka Ashitanari. Irooma iirokaiti, tii pipinkathatana. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tii naaka kowashitachani pimpinkathatina, aña tzimatsi pashini kowatsiri impinkathaitina, iriitaki yakawintantatsini. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Itzimirika kimisantaironi noñaani, iiro ikaamaniyitai. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ari ikantaiyanakini Judá-mirinkaiti: “Ari niyotaiyini imapiro pikamaaritzi. Tima kamaki Abraham-ni, ari ikimitakari Kamantantaniriiti, kamayitaki maawoni. Opoña pikantzi iiroka: ‘Itzimirika kimisantaironi noñaani, iiro ikaamanitai’. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Panairima iiroka nocharinini Abraham-ni? Kamaki irirori, ari ikimiyitakari Kamantantaniriiti iijatzi. ¿Tsikama piitamachiityaaka iiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jakanaki Jesús: “Naakami kowashitachani impinkathaitinami, tikaatsi opantyaawoni. Iri pinkathatakaanari Ashitanari. Iriitaki pikantapiintawitari iirokaiti ‘Nowawani’. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tiimaita piyotairi iirokaiti. Irooma naaka noñiiri. Aririkami nonkanti ‘tii noñiiri’, thiiyinkari ninaki nokimitakotakimiro iirokaiti. Aña imapiro noñiiri. Nokimisantziro iñaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Pairani Abraham-ni, picharinitanakari iirokaiti, ikimoshiritaki jiñiiro nompokapaititi. Aritaki jiñiimaitakina, antawoiti ikimoshiritaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ipoña Judá-mirinkaiti ikantanakiri Jesús: “Tikiraamintha otzimi iiroka 50 posarintsiti. ¿Ipoña pikantzi piñiiri Abraham-ni?” ");
INSERT INTO cpcNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ari jakanaki Jesús: “Tikiraamintha itzimiita Abraham-ni. ‘Naakatsitaka’. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ikanta jirikaiti jaiyawitanakani mapi ikowi intsitokirimi. Iro kantzimaitacha Jesús, ipiyapithatanakari. Shitowanaki tasorintsipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ikanta ikinayitzi Jesús, jiñaaki kaari okichaatatsini, jashi jowatziiro owakiraa itzimapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ikanta jiyotaani josampitakiri, ikantziri: “Rabí, ¿Oitama kaari jokichaatanta owakiraa itzimaki jirika shirampari? ¿Irooma kantakaantzirori iyaaripironka ashitariri? ¿Irooma kantakaantzirori iyaaripironka irirori?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ari jakanaki Jesús, ikantzi: “Tii iro kantakaantironi iyaaripironka, tii okantakaantziro iijatzi iyaaripironka iwaapati. Iro imatantari jiroka, onkantya jiñaitantyaawori ishintsinka Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iinta okitiijyitzi, ontzimatyii antiro jantawairi otyaantakinari. Tima aririka ontsiniritanaki, tikaatsi kantironi jantawaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Iinta nosaiki naaka jaka kipatsiki, naakataki kitiijyiinkatakotziriri isaawijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ithonkakiro jiñaawaitaki Jesús, jiiwatanaki kipatsiki, jamirokaki kapichiini kipatsipitha jakoki, itziriyookitakiri kaari okichaatatsini. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ipoña jiñaanatziri ikantziri: “Piyaati pinkiwaakitya owaankanaata jiitaitziri Siloé”. Ari ikinanaki kaari okichaatatsini, ikiwaakitapaaka. Ikanta ipiyapaaka, kantanai jamini kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ikanta ijyininkapaini, ikaatzi ñaayitapiintziriri ikamitantzi impashiityaari, josampitawakaayita, ikantzi: “¿Kaarima jirika saikapiintatsiri ikowakotantzi impashiityaari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Tzimatsi kantatsiri: “Iriitaki”. Pashini kantatsi: “Aña kaari, iriiwaiwitaka”. Iro kantzimaitacha, ikantzi irirori: “Naakataki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ipoña josampitanakiri: “¿Tsikama pikantairoka paminantaari kamiitha?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ari ikantanaki irirori: “Jirinta shirampari iitachari Jesús, iriitaki matakinawori, tzimatsi itziritakinari nokiki, ipoña ikantakina: ‘Piyaati owaankanaataka Siloé. Ari pinkiwaakityaari’. Okanta niyaatanaki, ari nokiwaakitapaaka, aminaana kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ipoña josampitanakiri: “¿Tsikama iroñaaka jirika shirampari?” Ari ikantzi irirori: “Tii niyotzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ipoña jaayiitanakiri kaari okichaawitachari isaikayitzi Fariseo-paini. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tima kitiijyiri jimakoryaantaitari inatzi, itziriyookitantakariri Jesús kaari okichaawitachani, iro jaminantaari kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ari josampitakiri Fariseo-paini tsika okanta jaminantaari kamiitha. Ikantanaki irirori: “Itziriyookitantakinawo nokiki kapichiini kipatsi, opoña nokiwaakitaka. Aminaana iroñaaka kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ari ikantayitzi Fariseo: “Itzimika antakirori jiroka kaari jashitari Pawa, tima tii ipinkathatziro kitiijyiri jimakoryaantaitari”. Iro kantacha ikantaiyini pashini: “Kaaripiroshiriri jinatyiimi, iiro jantaajaitziromi jiroka”. Tii jaapatziyawakaawintawo ikantaiyakirini Fariseo. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ari japiitakiri josampitziri kaari okichaawitachani: “¿Oitama pikinkishiritari iiroka, iitaka aminakagaimiri kamiitha?” Ikantzi irirori: “Kamantantaniri jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kantai iroñaaka jaminawaitai kamiitha, tii ikimisantzi Judá-mirinkaiti kaari okichaawitachani jirika. Irojatzi ikaimantakariri iwaapati, ");
INSERT INTO cpcNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","josampitawakiri, ikantziri: “¿Iriima pitomi jirika? ¿Pinkantinatya ari ikantatya tii jokichaatzi owakiraa itzimapaaki? ¿Tsikama okantaka jaminantaari iroñaaka kamiitha?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ikantanaki ashitariri: “Niyotaiyini iriitaki nowaiyani, ari ikantatya tii jokichaatzi owakiraa itzimapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Iro kantacha tii niyotzi tsika okanta jaminantaari kamiitha iroñaaka, tii niyotzi iijatzi iita aminakagairiri kamiitha. Posampitiri irirori, antari jinaki, iriitaki kamantimini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Iro ikantantari iwaapati tima ithaawatzi, ikantaiyakini Judá-mirinkaiti: “Intzimirika kantaintsini Cristo jinatzi jirika Jesús, iiro noshinitairi intyagai apatotapiintaiyani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Irootaki ikantantakari iwaapati: “Posampitiri irirori, antari jinaki notomi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Japiitakiro Judá-mirinkaiti ikaimairi kaari okichaawitachani, ikantziri: “Pimpinkathatiri Pawa, pinkamantina tyaaryoopiroini, iiro pipinkathawaitashitari jirika shirampari kaaripiroshiriri jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ari ikantanaki irirori: “Tii niyotzi naaka kaaripiroshiriri jinatzi. Apa niyotzi naaka tii nokichaawita. Iro kantacha aminaana kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Japiitakiri josampitziri: “¿Tsikatya ikantakimika? ¿Iita jantakiri jaminakaantaimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ari jakanairi: “Aritaki nokantakimi, iro kantacha tii pikimisantzi. ¿Oitama pikowantari napiitimiro? ¿Pikowatziima pinkimisantaiyirini iirokaiti?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ari jitanakari ikawiyawaitanakiri, ikantaiyini: “Pinkimisantiri iiroka jirika shirampari, irooma naakaiti nonkimisantiro Ikantakaantani Moisés-ni. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Niyotaiyini naakaiti jiñaanatakiri Pawa pairani Moisés-ni. Iriima jirika, tikaatsi yotirini tsika ipoñaaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ari jakanaki okichaataatsiri, ikantzi: “¡Tsikama okantatyaaka jiroka! Aña jaminakagaana naaka kamiithaini, tii piyotziri iirokaiti tsika ipoñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ayotaiyini maawoni tii ikimiri Pawa kaaripiroshiriri. Apa ikimiro jamanamanaatani pinkathatziriri, antanairori ikowakairiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tikaatsi ankimakowintapiinti tzimatsi aminakagairini kaari okichaatatsini itzimapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Iiromi ipoñaakawo jirika shirampari janta Pawakinta, iirotya jimataajaitziromi jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ari ikantanakiri: “Piyaaripironka pitzimakaaki iiroka. ¿Pikowima piyotaayitaina naaka?” Jomishitowakaantaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yotaki Jesús jomishitowakaantaitakiri okichaataatsiri. Ikanta jiñagairi paata, josampitairi: “¿Pikimisantzirima iiroka Itomi Atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ari ikantzi irirori: “Pinkatharí, pinkantina tsika itzimi, inkini nonkimisantiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ikantzi Jesús: “Aritaki piñaakiri, naakataki pikinkithawaitakaaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ikanta jirika okichaataatsiri jotziirowashitanakari Jesús ipinkathatanakiri, ikantziri: “Nokimisantzimi Pinkatharí”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ipoña ikantzi Jesús: “Nopokaki naaka jaka kipatsiki niyakawintantai, ari onkantya jaminantaiyaari kaari okichaatatsini. Iriima ikaatzi aminawitachari, iiro jokichaatai irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tzimayitatsi Fariseo tsipatakari Jesús, ikimakiri ikantakiri, josampitanakiri: “¿Pikimitakaantatyaanarima naakaiti kaari okichaatatsini?” ");
INSERT INTO cpcNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ikantanaki Jesús: “Imapiromi pinkimityaari kaari okichaashiritatsini iirokaiti, tikaatsi iyakawintimironi piyaaripiroshirinka. Irooma pikantaiyini tii pikimitari kaari okichaashiritatsini, irootaki piñaantaiyaawori jiyakawintaitimiro pipiyathatakina”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ipoña ikantanaki Jesús: “Itzimirika kaari tyaatsini omoopiroki oijyatanto, intyaashitatyaarika onaminatantoki, koshintzi jinatzi, kaaripirori. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Iriima tyaatsiri omoopiroki, iriitaki aamaakowintapiintariri oijya. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Iriirika ashitaryaajaantironi aamaakowintawori ashitakowontsi, impoña intyaapaaki, impairyaayitapaakiri oijya inkaimayitapairi, ari jiyopaantitawairi. Iri omishitowajaantirini aamaakowintapiintari oijya. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Aririka jomishitowakiri jikokiroki maawoni, iri iiwatirini aamaakowintariri, joyaatzimaityaari oijya tima jiyopaantitziri iri aamaakowintariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Iro kantacha tii joyaatziri kaari jiñaapiintziri, owanaa ishiyapithatari, tima tii jiyopaantitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ari ikantaki Jesús jojyakaawintziniri, tiimaita ikimathataiyirini jirikaiti iita ikantziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ipoña japiitanakiro Jesús ikantziri: “Naakatajaantaki ojyawori omoopiro oijyatanto. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ikaatzi kaaripiroriiti itakawori ipokaki tikiraamintha nopoki naaka, jojyashitakari koshintzi. Irootaki kaari ikimisantantaiyarini oijya. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naakatajaantaki ojyawori omoopiro. Intzimirika tyagaatsini nojyakawo omoopirori, aritaki jawijakoshiritai. Ari jojyakotaiyaari oijya ipiyapiyata ityaapiintzi, ishitowapiintzi iijatzi. Tii okowityiimotari jowanawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iriima koshintzi apa ipoki inkoshiti, intsitokanti, japirotanti. Irooma naaka nopokaki nañaakaapiroshiritantai. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naakataki ojyari kamiithari aamaakowintariri oijya. Tima apaani kamiithari aamaakowintariri oijya, ishiniwintari joijyati. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Tima ikaatzi ipinaitziri jaamaakowintari oijyanintsi, aririka jiñaawakiri owaminthatariri, jookawintziri, jowaitapaatyaari oijya ishiyanakara aamaakowintariri, tzimpooka inkantayitanatya pashini. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Iro ishiyantari aamaakowintawitariri, tima apa ikowi impinaitiri. Tii iri oijya inkowapiroti jaamaakowintyaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Naakataki kamiithari aamaakowintariri oijya. Niyoyitziri noijyati. Jiyoyitana iijatzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ikimita jiyopirotana Ashitanari, ari nokimitsitari iijatzi naaka niyopirotziri irirori. Noshiniwintakotari noijyati. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Iinitatsi iijatzi pashini noijyati kaari saikatsini jaka. Ontzimatyii namayitairi jaka. Aritaki inkimisantayitaina irirori. Apaani inkantya impiyotaiya. Apaani inkantya aamaakowintaiyaarini. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Jitakotana Ashitanari tima noshinitakiro nañaantari inkini nañagai iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tikaatsi shintsiwintinani, aña naakataki shinitashitaincha. Otzimimotana noshintsinka noshinitantari, iro nañaantaari iijatzi. Irootaki ikowakiri Ashitanari nantiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ikanta ikimawakiro Judá-mirinkaiti jiroka ñaantsi, japiitanakiro tii jaapatziyawakaanaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tzimatsi ojyiki kantayitanaintsiri: “¿Iitama pikimisantantariri? Ikamaaritatzi, iro ishinkiwintantakari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Iro kantacha pashini kantatsi: “Tikaatsi kamaari matironi jiñaawaitiro jiroka ñaantsi. ¿Kantatsima kamaari jaminakagairi kaari okichaawitachani?” ");
INSERT INTO cpcNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Aritaki tyaawontsipaititai. Okanta janta Jerusalén-ki, joimoshirinkaitziro tasorintsipanko. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ari isaikitakari Jesús tasorintsipankoki, janiiwaitzi awijatapishitzi jiitaitziro “Salomón-tapishi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ipoña Judá-mirinkaiti ipiyowintapaakari, josampitziri: “¿Tsikapaitima onkaati pinkisoshiritakaayitina? Iirokarika Cristo, incha pooñaawontinawo”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jakanaki Jesús ikantzi: “Aritaki nokamantayitakimi, tiimaita pikimisantana. Okaatzi jimatakaayitakinari ishintsinka Ashitanari, oñaagantapirowaitakiro kamiithaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Iro kantacha iirokaiti tii pikimisantaiyini, tima tii pikimitakaanta iirokami noijyati. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ikaatzi kimitakaantaachari noijyati jiyopaantitana, niyotsitari iijatzi naaka. Joyaayitana iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Naakataki kañaanitakaayitairini. Iiro ipiyawaita, tikaatsi aapithatinarini. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ikaatzi jashitakaakinari Ashitanari, tikaatsi aapithatinarini, tima iri matzirori jantaritzi anaakopirotantatsiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tima itsipashiritana Ashitanari, kimiwaitaka apaanimi nonkantya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ikanta Judá-mirinkaiti jaawitanaa mapi ikowi intsitokirimi, ");
INSERT INTO cpcNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","iro kantacha Jesús, ikantanakiri: “Iro ishintsinka Ashitanari antakaayitakinawori kamiithayitatsiri okaatzi piñaakotakinari iirokaiti. ¿Oitama pintsitokawintinari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ari ikantaiyanakini Judá-mirinka: “Tii iro nontsitokawintimi kamiithari okaatzi pantayitakiri, aña iro nontsitokawintimi pithainkatasorintsitakiri Pawa. Tikaatsi piimachiitya iiroka, atziri pinatzi, iro kantacha pikimitakaantashiwaitaka Pawami pinatyi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ikantzi Jesús: “Jiroka osankinata Ikantakaantaitani, Naaka kantatsi: ‘Pawaiti pinaiyini iirokaiti’. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ari ayotaiyironi Osankinarintsipirori, iiro okantzi anthainkañaanitiro. Iriitajaantaki Pawa iitakiriri atziriiti ‘Pawaiti’ itzimi jiyotakaayitakiri iñaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Iitama pikijyimatantanari iirokaiti pikantaiyini nothainkatasorintsitaki nokantaki: naaka Itomi Pawa? Aña naakatataiki jookotaki, jotyaantakina nompoki kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Iiro nantziromi okaatzi jantziri Ashitanari, iirotya pikimisantaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Aña aritaki nantakiro. Onkantawitya iiro pikimisantana naaka, iro pinkimisanti okaatzi notasonkawintantayitaki, iro piyopirotantyaari ari notsipashiritari Ashitanari, itsipashiritana iijatzi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ari ikowawitaiyani jaakaantirimi iijatzi, iro kantacha Jesús ishiyapithatanakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Piyanaa Jesús katonkaki jiñaa Jordán. Ari isaikapai tsika jowiinkaatantzi pairani Juan-ni. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ojyiki atziri jatashitakiriri jiñiiri Jesús. Ikantaiyini: “Tii itasonkawintantawita Juan-ni irirori, iro kantacha okaatzi ikinkithatakotakiriri jirika shirampari tyaaryoori inatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ojyiki kimisantanakiriri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tzimatsi mantsiyari shirampari jiita Lázaro, Betania-jatzi jinatzi, ari onampitawori iijatzi María otsipatawo irinto Marta. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Jiroka María, iritsiro Lázaro, iro saitantakariri kasankaari iitziki Awinkathariti ojyitantzimaitari oishi.) ");
INSERT INTO cpcNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Okanta jiroka apiti iritsiro Lázaro, okaimakaantakiri Jesús, okantaki: “Pinkatharí, imantsiyatatzi paapatziyani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ikanta ikimawaki Jesús, ikantzi: “Jiroka mantsiyarintsi tii owamaantzi, aña ari jiñaitiro ishintsinka Pawa, iijatzi ishintsinka Itomi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Owanaa jitakowitakawo Jesús jiroka Marta, iijatzi irinto, ipoña Lázaro, ");
INSERT INTO cpcNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ikimawitaka ikamantaitakiri jimantsiyatatzi Lázaro, iikiro isaikawaitanakitzi apiti kitiijyiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ipoña ikantanairi jiyotaani: “Thami ampiyi Judea-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ari ikantaiyini jiyotaani: “Rabí, owakiraa ikowaiyini Judá-mirinkaiti intsitokimi janta. ¿Iijatzima pikowi pimpiyanai?” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ikantzi Jesús: “¿Imapiroma osamanitzi apaani kitiijyiri? Itzimirika aniitatsiri kitiijyipaitiki, tii jantziwawaita, tima jiñaakiri kitiijyiinkari jaka kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Iriima aniitatsiri tsiniripaiti, jantziwawaita, tima ikowityaatya janta kitainkari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iikiro ikantanakitzi Jesús: “Makoryaaki aapatziyani Lázaro, ontzimatyii niyaati nowiriintairi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ari ikantaiyanakini jiyotaani: “Pinkatharí, kimitaka ari amataakoniinta, tima iro jimakoryaantari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jiñaajaantaiyini jiyotaani Jesús iro ikinkithatakotzi makoryaantsi, ikantakira: “Jimakoryaatzi Lázaro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ipoña jooñaawontanakiniri, ikantziri: “Kamaki Lázaro. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Owanaa nokimoshiritaki tii nosaiki janta, iro pinkimisantapirotantyaari, thami aati aminiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ikanta Tomás jiitaitziri “Tsipari”, ikantanakiri ikaataiyini jiyotaanitari: “Thami oyaawitanatyaari, añaamachiiti iirorika jowamaayiitai aaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ikanta jariitzimatapaaka Jesús, ikimapaaki tzimakotaki Lázaro 4 kitiijyiri ikitaitantakariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tii intainapirotzi Betania osaiki Jerusalén, ");
INSERT INTO cpcNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","iro jiyaatashitantakawori Judá-mirinkaiti jiroka Marta otsipatakawo María, inkimoshiritakaantaiyaawori ikamaki iyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Okanta iyotaki Marta iro jariitzimatya Jesús, jatanaki otonkiyotawatyaari. Iro saikanaintsi María pankotsiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Okantawakiri Jesús: “Pinkatharí, ari pisaikimi iiroka jaka, iiro ikamimi niyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Iro kantacha niyotzi naaka aririka pinkamitiri Pawa oitya rantimiri, aritaki jimatakimiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ari jakanakiro Jesús: “Aritaki jañagai piyaariri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Okantzi Marta: “Niyotzi aritaki impiriintai paata iwiyaantapaatyaawoni kitiijyiri impiriintantaiyaari kamayitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ipoña ikantanakiro Jesús: “Naakataki owiriintantatsiri, naakataki añaakaantaniri. Iitarika kimisantainani naaka, onkantawitatya inkami, ari jañagai. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ikaatzi añaayitatsiri iroñaaka, kimisantainani, iiro ikaamaniyitai. ¿Pikimisantziroma jiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Okantzi iroori: “Nokimisantzimi Pinkathari, iirokataki Cristo Itomi Pawa ikajyaakaakiriri impoki jaka kipatsiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ithonkakiro Jesús ikantayitakiro Marta, jatanaki okaimiro irinto María, okamantathatapaakiro, okantziro: “Ariitapaaka yotaantaniri, ikaimimi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Okanta okimawaki María, katziyanaka, jatanaki oñiiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tikiraata jariita Jesús nampitsiki, irojatzi isaikaki otonkiyotawakari Marta. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ikanta Judá-mirinkaiti tsipatakawori opankoki joimoshirinkiro jiñaakiro oshiyanaka María, joyaatanakiro jiñaajaantaki iraawaitatyiiya kitataariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Okanta ariitapaaka María isaikaki Jesús, otziirowashitapaakari okantziri: “Pinkatharí, ari pisaikimi iiroka jaka, iiro ikamimi niyaariri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ikanta Jesús, jiñaakiro María iraimotapaakari, ari ikimitapaakari iijatzi Judá-mirinkaiti oyaatapaakirori, antawoiti jowashiritanaka, okatsitzimoshiritanakiri, ");
INSERT INTO cpcNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","josampitanakiro: “¿Tsikama janta pikitatakirika?” Ari ikantaitanakiri: “Pimpoki Pinkatharí, piñiiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ari jiraapaakari irirori Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ikantaiyini Judá-mirinka: “¡Paminiri antawoiti jitakotakari!” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tzimimaitacha pashini kantanaintsiri: “Iriiwitaka jirika aminakairiri kaari okichaatatsini, ¿kaari jaminanta tsika inkinakairo iiro ikamanta Lázaro?” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Apiitanakiri Jesús okatsitzimoshiritanakiri, jiyaatashitanakiri okaakiini kitataari. Omoona inatzi, iro mapi jojyipiyiitantakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ikantanaki Jesús: “Potainkiro mapi”. Ari okantanaki Marta iritsiro kamaintsiri: “Pinkatharí, kimitaka ari sankainkataki, tima tzimaki 4 kitiijyiri ikamantakari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ari jakanaki Jesús: “¿Nokantakimi, pinkimisantinarika, ari piñaakiro ishintsinka Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jotainkakiro mapi. Ipoña jaminanaki Jesús inkitiki, ikantanaki: “Ashitanarí, nopaasoonkitzimi iiroka, tima pikimana. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Niyotzi ari pinkantapiintatya pikimana. Iro nokantantzimiri inkimantyaari atziriiti saikaintsiri jaka, iro inkimisantantyaari iirokataki otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ithonkakiro jiñaawaitakiro jiroka, ikaimanaki: “¡Lázaro, pishitowi!” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Shitowapai kaminkari, jankowitakawo manthakintsi jakoki iijatzi iitziki, irojatzi iponapootakawo jankowitantaitawakariri. Ari ikantzi Jesús: “Pankowiryaakotiri, jiyaataita”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Irootaki ikimisantantanakari ojyiki Judá-mirinkaiti ikaatzi jataintsiri itsipatawo María, ikaatzi ñaakirori jantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Iro kantacha tzimatsi jatashitanakiriri Fariseo-paini. Ikamantapaakiri okaatzi jantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ikanta Fariseo-paini itsipatakari ijiwari Ompiratasorintsitaari, japatotakiri jiwariiti, ikantaiyini: “¿Oitama antiri? Jirika shirampari ojyiki itasonkawintantaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Aririka añaashiminthatyaari, maawoni inkimisantaitiri. Ari impokaki ijiwaripaini Roma-jatzi, impookakaantakiro tasorintsipanko, japirotakaantakiro anampitsiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Iro kantacha, iinitatsi itsipatakari, iitachari Caifás, iriitaki Ijiwaripiroriti Ompiratasorintsitaari, ikantanaki irirori: “Tii piyotaiyini iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Iro kamiithatatsi ashiniti apaani atziri inkamawintai, iiro japiroitantai anampiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jirika Caifás, Ompiratasorintsipirori jini, jiñaawaitakaakiri Pawa. Okantawitaka tii jiyotzi, iri Jesús ikinkithatakotaki inkamawintiri ijyininkapaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tii apa inkamawintiri ijyininkapaini, aña inkamawintairi maawoni itomiiti Pawa tzimpookaintsiri, jiwithaawakaantyaari jashitaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aripaiti ikowaki ijiwari Judá-mirinkaiti jowamairi Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Irootaki kaari ikowantanaa Jesús intsipatanaiyaari Judá-mirinkaiti. Aña shitowanaki isaiki Judea-ki, jataki otzishimashiki osaiki nampitsi iitachari Efraín. Ari isaikakaapairi jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Irootaintsi joimoshirinkapaititairo Judá-mirinkaiti Anankoryaantsi, ojyiki atziri jatatsiri Jerusalén-ki jiwitsikashiriyitya. ");
INSERT INTO cpcNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ari jaminaminaitakiri Jesús, josampitawakaiyani tasorintsipankoki: “¿Tsikama pikantaiyini iiroka? ¿Ari impokaki joimoshirinkaita?” ");
INSERT INTO cpcNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ikanta Fariseo-paini itsipayitakari Ompiratasorintsipiroriiti, ikantantayitaki: “Iitarika yotaintsini tsika isaiki Jesús, inkamanti, naakaantiriita”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aritaki yotapaaka 6 kitiijyiri joimoshirinkantyaawori Anankoryaantsi, jataki Jesús Betania-ki, inampiki Lázaro jowiriintairi pairani. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ari joimoshirinkaitakiri Jesús. Iro Marta oyiitantatsi. Ari isaikitakari iijatzi Lázaro itsipatakari Jesús jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amakotapaaki María kasankaari. Ojyiki owinawoni jiroka. Osaitantapaakari iitziki Jesús. Ojyitantzimaitari oishi. Kasankainka okantanaka maawoni pankotsiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ikanta Judas Iscariote, jiyotaani Jesús pithokashityaarini paata, ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“¿Iitama kaari ipimantantaitawo jiroka kasankaari? Ari aantatyaami ojyiki kiriiki, iri anishironkatantyaaririmi ashironkainkari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tii iro ikantantakari Judas jitakotatyaari ashironkaariiti, aña koshintzi jinatzi. Iriitaki jowaitakiri inkimpoyiiri kiriiki, iro kantacha ikoshitapiintzi kapichiini. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ari ikantanaki Jesús: “Piñaashiminthatyaawo, aña iroowitaka okajyaakaakinari, inkitaitakinarika. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Iriima ashironkainkariiti ari inkantaitatyaani isaikimotimi, irooma naaka iiro nokantaitatyaani nosaikimotimi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jiyotaiyakini Judá-mirinkaiti ari isaiki Jesús Betania-ki. Jiyaataiyakini janta, tii apa jaminiri Jesús aña iijatzi Lázaro, jowiriintairi pairani Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ikamantawakaayitaka Ompiratasorintsipiroriiti intsitokiri iijatzi Lázaro. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Tima iriitaki Lázaro kantakaantakirori kaari jaapatziyaitantanaari Judá-mirinkaiti ikimisantaitanakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ojyiki atziri jataintsiri Jerusalén-ki joimoshirinkiro Anankoryaantsi. Okanta okitiijyitamanai, ikimaiyakini ari impokiri Jesús nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ipoña ichikaiyanakini ojyawori kompiroshi. Jataiyanakini intonkiyotawatyaari, ikaimaiyini ikantzi: ¡Aatsikitataiki awinkathariti! Tasonkawintaari jinatzi, tima Pinkathari aitziri otyaantakiriri. ¡Iriitaki Awinkatharipirotitaiyaari aakaiti Israel-mirinkaiti! ");
INSERT INTO cpcNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ari jiñaapaaki Jesús iwonkiri burro, ityaakaanakari, tima okinkithatakotsitakari Osankinarintsipirori, ikantaitaki: ");
INSERT INTO cpcNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sion-jatoití, iiro pithaawaiyini, Pokataiki Piwinkathariti, Ityaakaakari iwonkiri burro. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Owakiraini, tii ikimathataiyironi jiyotaani jiroka. Iro kantacha itzinaashitaawo Jesús jowaniinkawo, aripaiti ikinkishiritanaka iriitaki Jesús josankinatakoitzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tima ikaatzi tsipatakariri Jesús jowiriintairi Lázaro, ikinkithatakoyitairo okaatzi jiñaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Iro jiyaatantanakari atziriiti itonkiyotawakari Jesús, tima ikimakotakiri jowiriintantaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iriima Fariseo-paini ikantawakaiyani iriroriiti: “Piñaakiro, kimitaka iiro akitsirinkiri. Paminiri, iro jiyaatashitiri maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tzimayitatsi Grecia-paantiri tsipatakariri atziriiti jataintsiri joimoshirinkaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ikanta Felipe Betsaida-jatzi, ipokashitapaakiri Grecia-paantiri. (Jiroka Betsaida nampitsi inatzi saikatsiri Galilea-ki.) Ikantapaakiri: “Pinkatharí, nokowi noñiiri Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ari jiyaatanaki Felipe, ikamantapaakiri Andrés. Apitiroiti jiyaataiyanakini, ikamantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ari ikantanaki Jesús: “Monkaapaititapaaka itzinaashitantaiyaawori jowaniinkawo Itomi Atziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Apaani okithoki kaari ipankiitzi, ari ashi owamachiitiro onkantya apakithowoini. Irooma aririka ompathaakitanaki ojyookanaki ipankiitakiro, ari jiñaitakiro onkithokitai. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Iitarika itakowaitashitachani jantayitziro inintashiyitari, ari impiyashitaiya. Iriima manintanakironi jantashiwaiyitari jaka kipatsiki, ikamawintanaatziiro inkañaaniyitai. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tzimatsirika kowatsiri nonkimitakaantiri nompiratani, inkimitakotinawo naaka. Tsikarika nosaikai naaka, ari isaikitaiya iijatzi nompiratani. Iitarika nokimitakaari nompiratani, iri Ashitanari kantakaiyaawoni impinkathaitantyaariri paata”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“¡Antawoiti okatsitzimoshiritakina iroñaaka! ¿Tsikama nonkantika? ¿Nonkantima: ‘Ashitanarí, powatsinaryaakoshiritaina?’ ¡Aña irootaki nopokantakari, nimonkaatairo! ");
INSERT INTO cpcNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ashitanarí, poñaagantiro powaniinkawo”. Ikimaitatzi ñaawaitanaintsiri inkitiki, ikantaitzi: “Aritaki noñaagantakiro, iroñaaka napiitiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Atziriiti piyotainchari ikaatzi kimawakirori, ikantaiyanakini: “Ookathawontsi inatzi”. Iro kantacha ikantayitzi pashini: “Maninkari ñaanatakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ari ikantanaki Jesús: “Tii apa naaka jiñaanayitzi, aña iirokaiti jiñaawaiwintaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Irootaintsi jiñaitiri jowasankitaitiri okantakaantziro iyaaripironka isaawijatziiti, joitsinampagaitairi iijatzi pinkathariwaitashitachari. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iro kantacha aririka jowatzikakoitakina jaka kipatsiki, aritaki nonkaimashiritanairi maawoni”. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ari jooñaawontziro Jesús tsika onkantya aririka jowamaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ari jakaiyanakini atziriiti: “Ayotaiyini okantzi Ikantakaantaitani: ‘Kañaaniri jinatzi Cristo’. ¿Iitama pikantantari iiroka ontzimatyii jowatzikakotaitiri Itomi Atziri? ¿Iitakama Itomi Atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ikantzi Jesús: “Iinta isaikimotanaimi jiitaitziri ‘Kitainkari’, apa isaikanai kapichiini. Pinkimitakaantiro paniitatyiimi okitiijyiinkatzi, ari onkantya iiro omapokantzimi kimitawori tsinirikiri. Tima ikaatzi aniitatsiri otsinirikitzi, tii jiñiiro tsika ikini. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pinkimisantairi jiitaitziri ‘Kitainkari’ iinta isaikimoyitzimi, pinkimitakotyaari irirori”. Ithonkanakiro jiñaawaitanakiro jiroka, shitowanaki Jesús. Tii joñaagantanaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Okantawitaka Jesús ojyiki itasonkawintantawitaka inampiitiki jirikaiti, tii ikimisantaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ontzimatyii imonkaatya josankinatakiri Kamantantaniri Isaías-ni, kantatsiri: Pinkatharí, ¿Iitaka kimisantironi añaani? ¿Iitaka joñaagaitakiri ishintsinka Pinkathari? ");
INSERT INTO cpcNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jiroka pashini josankinatakiri Isaías-ni, irootaki kaari ikimisantantaita, ikantaki pairani: ");
INSERT INTO cpcNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Iri Pawa kaari okichaatakairini, Imasontzitakaayitakiri, Ari onkantya iiro jokichaatanta Iiro ikimathawainitanta. Ari onkantya iiro ipiyashitantaana naaka, Nowawijaakotantaiyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Iro jiñaawaitantakawori jiroka Isaías-ni tima iñaampiyakityaawo jowaniinkawo Jesús, irootaki ikinkithatakotantakariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iro kantacha, ojyiki Judá-mirinkaiti kimisantanairiri Jesús, ari jimatsitanakawo ñaapiroriiti. Iro kantacha tii joñaagantziro, tima ithaawantatyaari Fariseo-paini, iiro ishinitairi intyaayitai japatotapiintaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ari okantzimaitaka. Iri ikowapirotanaki Fariseo-paini jaapatziyaminthatyaari, iriima Pawa, tii. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ari jiñaawaitanaki shintsiini Jesús, ikantanaki: “Iitarika kimisantainani naaka, tii apaniroini ikimisantana, aña ikimisantsitakari otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ikaatzi okitaanari naaka, okimiwaitakawo iriimi jokityaami otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Irootaki nopokantakari naaka, nonkimitaiyaari ‘Kitainkari’, ari onkantya nonkitiijyiinkatakotantyaariri isaawijatzi. Iiro isaikayitai otsinirikitzi inkaati kimisantainani. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Tima tii iro nompokantyaari naaka kipatsiki nowasankitaanti, iro nopokantakari nowawijaakotanti. Ikaatzi kimayiwitawori noñaani, tiimaita ikimisantzi, kaari naaka owasankitairini. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iitarika manintakinari, kaari kimisantaironi noñaani, tzimaki iitya owasankitairini. Kimiwaitaka jiroka ñaantsipaini okaatzi noñaawaitakiri atziri inatyiimi, iro owasankitaantaatsini paata, ipiyathapaantiwaitakina. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tima naaka tii noñaawaitashiwaita nonintakaanikiini. Ashitanari, itzimi otyaantakinari, iriitaki kantakinawori okaatzi nokantayitakiri, niyotaantayitakiri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Niyotzi naaka okaatzi ikantakaantziri Ashitanari iro kañaanitakaantatsiri. Ari okantari, okaatzi nokantayitakiri naaka, nothotyaatziiro okaatzi ikantajaantakinari Ashitanari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ari kaatapaaki kitiijyiri joimoshirinkaitawo Anankoryaantsi. Jiyotaki Jesús monkaatapaaka jookawintantyaawori kipatsi, iro jiyaatai intsipatapaiyaari Ashitariri. Antawoiti jitakoyitakari ikaatzi kimisantakiriri, ari ikantapiintatya jitakotari irojatzi iwiyaantapaakawori. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ikanta isaikaiyini jowaiyani, aritaki kamaarishiritanaki Judas Iscariote, itomi Simón, iri pithokashityaarini Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jiyotaki Jesús tima ipoñaatyaawo irirori Pawaki, aritaki impiyi janta. Iriitaki shintsitakaapirotakiriri Ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ari ikatziyanaka isaikaki jowaiyani, jaatonkoryaanakiro iwiwiryaakowo, jowathakitanakawo manthakintsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jaakiro jiñaa isakiro kiwaakomintotsiki. Ikiwakiiyitakiri jiyotaani, jojyikiitantari manthakintsi jowathakitakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Iro inkiwakiitantyaaririmi Simón Pedro, ikantanaki irirori: “Pinkatharí, ¿iirokama kiwakiitinani naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ari ikantzi Jesús: “Tii pikimathatziro okaatzi nantiri, irooma paata, ari pinkimathatairo”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ikantanaki Pedro: “¡Iiro noshinitzimi pojyaari ompirataari pinkiwakiitina!” Jakanaki Jesús: “Iirorika nokiwakiitzimi, tii paapatziyana”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ikantzi Simón Pedro: “¡Pinkatharí, iirotya pikiwakiitashitana, aña pinkiwina maawoni nakoki iijatzi noitoki!” ");
INSERT INTO cpcNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iro kantacha Jesús, jakanairi: “Owakiraa kaawoshitainchari, apa okowajaanta inkiwakiitya tima kititaki maawoni. Ari kititaiyakimini iirokaiti, okantawitaka tii maawoni pinkitishiritaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tima jiyotakiri Jesús itzimi pithokashityaarini, irootaki ikantantakari: “Tii maawoni pinkitishiritaiyini”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aritaki ithonkakiro ikiwakiitakiri, ikithaatanaawo Jesús iwiwiryaakowo, saikanai iijatzi tsika jowaiyani, ari ikantzi: “¿Pikimathatakiroma okaatzi nantakiri? ");
INSERT INTO cpcNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Pikantapiintaiyakini iirokaiti ‘Yotaanarí, Pinkatharí’. Imapirowitatya pikantanari, tima naakataki. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Naaka ‘Yotaaniri’, naaka ‘Jiwari’. Iro kantacha, nojyakotakari ompirataari nokiwakiiyitakimi, ari pinkimityaari iirokaiti pinkiwakiitawakaayitya. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naakataki oñaagakimirori, pinkimitakotantinari iirokaiti tsika nokantakimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tii ipinkathaitziri ompirataari janaakotziri ompiratariri. Tikaatsi iijatzi apaani otyaantaari anaakotirini otyaantakiriri. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Aririka pinkimathatanairo jiroka, pantanairo iijatzi, aritaki pinkimoshiritai. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jiroka nonkantimiri, tii maawoni nonkinkithatakotaiyimini. Niyotziri naaka ikaatzi niyoshiitakiri. Ari imonkaatyaari Osankinarintsipirori, kantatsiri: Tzimatsi atyootakinari, iriitaki pithokashityaanani. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Aririka imonkaatatya jiroka, iro pinkimisantapirotantyaanari ‘Naakatsitaka’. Irootaki nitantawori nokamantzimiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Iitarika aapatziyaarini notyaantani, naakatajaantaki jaapatziyaka iijatzi. Iitarika aapatziyinani naaka, iri jaapatziyaka otyaantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ari ithonkanakiro jiñaawaitakiro jiroka, antawoiti okatsitzimoshiritanakiri Jesús. Iikiro joñaagantanakitziiro ikinkithatakotakiri, ikantzi: “Pikaataki iirokaiti jaka tzimatsi apaani pithokashitinani. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ari jaminawakaanaka jiyotaani, tii jiyotzi iita ikinkithatakotziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ikanta apaani jiyotaani, jitakopirotani Jesús, saikimotakiriri okaakiini jowaiyani, ");
INSERT INTO cpcNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","jiñaakiri Simón Pedro jiñaanachiratziri, ikantziri: “Posampitiri iita ikinkithatakotziri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ikanta irirori, jontsitokanakari okaakiini, josampitakiri: “Pinkatharí, ¿Iitaka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ari ikantzi Jesús: “Piñiina najyiti kapichiini tanta, iitarika nompaki, iriitaki”. Jajyitaki kapichiini tanta, ipakiri Judas Iscariote, itomi Simón. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ikanta jowawakawo Judas tanta. Aripaiti ikamaaritanaki. Ari ikantziri Jesús: “Pantiroota thaankiini pikinkishiritapiintakari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ikanta ikaatzi jowaiyani tikaatsi kimathatawakironi oita ikantantariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Tima Judas iriitaki kimpoyiiriri kiriiki, jiñaajaantzi ikantatziiri Jesús jiyaatiita jamananti tsika oitya joimoshirintyaari, jiñaajaantaki iijatzi jamanantatyi impayitiriri ashironkainkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aritaki jowawakawo Judas tanta, jatanaki. Aritaki tsiniritanaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ari jatanaki Judas, ikantzi Jesús: “Monkaatapaaka itzinaashitantyaawori jowaniinkawo Itomi Atziri. Iro jiñaitantyaawori jowaniinkawo Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tima ari okantari, iriitaki Pawa oñaagantironi jowaniinkawo. Iroñaaka jantiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Notomiiti, kapichitapaaki nosaikimotanaimi. Ojyiki paminaminawitaina iirokaiti, iro kantacha iiro piñagaana. Irojatzi nokantsitakariri ajyininkapaini Judá-mirinka, irojatzi napiitsitzimiri nokantzimiro iirokaiti, tima iiro pitsipataana tsika nosaikapai naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jiroka owakiraari nokantakaantani: Ontzimatyii pitakotawakaiya. Nokimita naaka nitakoyitzimi, ari pinkimitanaiyaari iirokaiti, pitakotawakaanaiya. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Aririka pitakotawakaanaiya iirokaiti, ari jiyoyitaimi maawoni iirokataki niyotaani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ikanta Simón Pedro josampitanakiri Jesús: “Pinkatharí, ¿tsikama piyaatika?” Ari jakanaki Jesús, ikantzi: “Tsika janta niyaati naaka, iiro okantzi poyaatina iirokaiti, irooma paata ari onkantaki poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ikantanaki Pedro: “Pinkatharí, ¿iitama iiro okantanta noyaatimi? ¡Aritaki noshiniwintakimi!” ");
INSERT INTO cpcNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jakanakiri Jesús, ikantziri: “¿Imapiroma pishiniwintina? Aña tikiraamintha iñiita tyoopi, mawajatzi pinkanti: ‘Tii niyotziri Jesús’. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Iiro powashiriwaitaa. Pawintaiyaari Pawa, pawintaiyaana iijatzi naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Janta ipankoki Ashitanari tzimatsi ojyiki anampitapaiyaawo. Iiromi otzimi, iiro nokantzimi niyaatai niwitsikapaimi tsika pinampitapaiyaawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Aririka niyaatai, niwitsikayitai tsika pisaikai, ompoña nompiyashitaimi naayitaimi, ari pintsipatapaina iirokaiti tsika nosaikai naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Piyotaiyironi iirokaiti aatsi jiyaatantaitari tsika nosaikai”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ari ikantanaki Tomás: “Pinkatharí, tii niyotzi tsika piyaati. ¿Tsikama nonkantyaaka niyotantyaawori aatsi?” ");
INSERT INTO cpcNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jakanaki Jesús, ikantzi: “Naaka ‘Aatsi’, ‘Tyaaryoori’, ‘Añaamintotsi’. Apa impampithawokitaitina naaka, ari jariitaiya Ashitanariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arimi piyopirotainami, ari piyotairimi iijatzi Ashitanari. Ari piyotakiri iroñaaka, iriitaki piñaapiintakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ikantanaki Felipe: “Pinkatharí, incha poñaayinari Ashitzimiri, tikaatsi pashini nonkowiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ari ikantanaki Jesús: “Felipe, osamanitaki notsipatakimi iirokaiti, ¿tikiraama piyotana? Ikaatzi ñaakinari naaka, jiñaakiri Ashitanari. ¿Iitama pikantantari? ");
INSERT INTO cpcNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Tiima pikimisantana ari nokaatziri Ashitanari, ari ikaatana irirori? Okaatzi nokantayitziri, tii naaka nintakaashiwaityaawoni nonkinkithatakotimiro. Iri Ashitanari tsipashiritanari, iriitaki antakaanawori jantawaitani. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Pinkimisantina ari nokaatziri Ashitanari, ari ikaatana irirori. Okompitzimotzimirika jiroka, iiro pikimisantaajaitziro nontasonkawintanti. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Inkaati kimisantainani naaka, ari intasonkawintantai irirori. Ari jimapirotanakiro intasonkawintanti, anaanakiro okaatzi jiñaakoitakinari, tima iro niyaatzimatai naaka nontsipatapaiyaari Ashitanari. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","maawoni pairyagainani naaka inkowakotina jamanamanaatina, aritaki nimatakiniri. Ari onkantya inthaamintantyaariri Ashitanari, okantakaantziro jantzimotantakiri Itomi. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Iitarika pinkowakotainari pimpairyagaina naaka, aritaki nimatakimiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Aririka pitakotaina, aritaki pinkimisantairo nokantakaantani. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ari nonkamitairi Ashitanari jotyaantimi pashini Ookaakowintimini, ");
INSERT INTO cpcNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tasorintsipirori jinatyi, iriitaki tsipashiritapiintaimini. Iriima isaawijatziiti iiro isaikimotziri, tima tii okantzi jiñiiri tii jiyotziri iijatzi. Irooma iirokaiti piyotaiyirini, tima isaikimotakimi, iri nampishiritantaimini. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Iiro pikimitari miritzi jookawintaitziri, ari nompiyashitaimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Irootaintsi, iiro jiñaayitaana isaawijatziiti. Irooma iirokaiti ari piñaayitaina, kañaaniri pinkantaiya tima kañaaniri ninatzi naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aripaiti piyoyitai notsipashiritari Ashitanari, iijatzi iirokaiti pitsipashiritana, ari nokimitari naaka notsipashiritaimi iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inkaati kimisantapaantitainani, joñaagantziro tyaaryoopiroini jitakotana. Irootaki jitakotantaiyaariri Ashitanari, iijatzi naaka ari nitakotaiyaari, ari noñaagaiyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ikanta Judas (kaari Iscariote) josampitanakiri: “Pinkatharí, ¿Iitama poñaagantaiyaanari naakaiti, iiro poñaagaari pashiniiti?” ");
INSERT INTO cpcNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jakanaki Jesús: “Ikaatzi itakotanari naaka, ikimisantapaantitana. Irootaki jitakotantaiyaariri Ashitanari. Ari nokaatairi Ashitanari nontsipashiritaiyaari jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Iriima kaari itakotinani, ipiyathapaantitakina. Tii naaka yotashiwaityaawoni okaatzi nokantakimiri, aña Ashitanari otyaantakinari iri yotakaanawori. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nokamantatziimiro maawoni jirokapaini iinta nosaikimotzimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Iriima Tasorintsinkantsi, Ookaakowintimini, jotyaantimiri Ashitanari poyaatinani, iri yotaapaakimironi maawoni, inkinkishiritakaimiro okaatzi nokantayitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Kamiitha pisaikayitai. Tii iro nonkinkithatakotashitya tsika okanta isaikakaantzi isaawijatziiti. Aña naaka matzirori pisaikantaiyaari kamiithapiroini. Iiro powashiriwaitashita, iiro pithaawawaitashita iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Aritaki pikimakina nokantaki: ‘Iro niyaatai, ompoña nompiyi ari ankaatai asaikayitai’. Ari pitakopirotainami, iiro powashiriwaitami nookayitanaimi, aña pinkimoshiriwintinami piyotaki niyaatatyi Ashitanariki, anaataikinari natziritapaintzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nokamantatziimiro jiroka, pinkinkishiritantyaari paata, imonkaatapaatyaarika. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Iiro nokinkithawaitsitakaimi, tima aatsikitaki pinkathariwintantawitachari kipatsiki. Okantawitaka tii ipinkathariwintana naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Aritaki onkantya, iro jiyotantyaari isaawijatziiti nitakotari naaka Ashitanari, nantziniri okaatzi ikantanari irirori. Pinkatziyaiyini. Thami aati”. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iikiro ikantanakitzi Jesús: “Naaka kimitawori oponkitzithapiro pankirintsi. Iriima Ashitanari iri kimitakariri pankitzirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Iirorika okithokitzi nochiwatha, ichikachiwathatziro ashitawori. Irooma otzimi kithokitatsiri, jowamiithachiwatziro, jowaankiityaakotziro onkini onkithokipiroti. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kimitaka aritaki kaankiityaakotakimi iirokaiti, okantakaimi ñaantsipaini nokamantayitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Apaani ochiwatha pankirintsi chootaryaathataintsiri iiro okithokitai, aña ontzimatyii ojyookantyaawo oponkitzitha. Ari okimitari iijatzi iirorika poisokirotana, iiro okantzi pantairo kamiithari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naakataki kimitakawori oponkitzitha pankirintsi, irooma iirokaiti pikimitakawo nochiwatha pinayitzi. Ikaatzi oisokirotanari naaka ari nokimitsitakari irirori, kimiwaitaka ojyikimi inkithokipirotai. Iirorika pitsipashiriyitana, tikaatsi pantayitai. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ikaatzi kaari oisokirotinari naaka, ari nookawintairi. Ari inkimitaiyaawo okamachiwathatzi pankirintsi, jagaitziro intagaitiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Oisokirorika powayitaina, pintyaaryoowintairo okaatzi niyotaakimiri, pinkowakotairi Ashitanari oitarika pikowiri, aritaki jimatakimiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Aririka pimatanairo jojyakaawintaitakiri kithokipirotatsiri pankirintsi, aritaki jiyotaimi imapiro niyotaanitaimi. Iro impinkathaitantyaariri Ashitanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Antawoiti nitakotaimi, nojyakari Ashitanari jitakotana naaka. Pinintaawaityaawo nitakotaimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Iikirorika pinkimisantanakityiiro nokantakaantani, ari pinintaawaitaiyaawo nitakotanka, nokimitairo naaka nokimisantapaantitziri Ashitanari nonintaawaitawo jitakotanka. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iro nokamantantzimirori jiroka inkini ankimoshiriti, irootaki pinkimoshiripirotantyaari iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jiroka nokantakaantani: Pitakotawakaiya nokimitairo naaka nitakotaimi iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iitarika shiniwintariri inkamawintiri jaapatziyani, joñaagantatziiro jitakopirotanka. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Naapatziyani pinatzi iirokaiti aririka pantanairo nokantzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Aritapaaki nokimitakaantzimi ompirataari, tima apaani ompirataari tii jiyotzi okaatzi jantayitziri ompiratariri. Aña nokimitakaantzimi naapatziyani, tima nokamantaimiro maawoni ikantanari Ashitanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Tii iiroka iyoshiitakinani, aña naaka yoshiitaimi iirokaiti. Naakataki otyaantimini piyaati tsikarika, pinkimitakotaiyaawo pankirintsi kithokipirotatsiri, ari pinkantapiintanakitya. Ari onkantya jimatantaimironi Ashitanari oityaarika pinkowakotiriri pimpairyaayitaina. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jirokataki nokantakaantzimiri: Pitakotawakaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Aririka piñaakiro inkisaniintanakimi isaawijatziiti, pinkinkishiritiro ari ikantaitakina naaka ikisaniintaitakina. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Irojatzi pojyakotyaarimi isaawijatziiti, ari jitakotakimimi, ikimitawakaa irirori jitakotawakaiyani. Irooma niyoshiitaimi naaka, pitsipawitari isaawijatziiti, irootaki ikisaniintantzimiri. Kimiwaitaka kaarimi iiroka isaawijatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Pinkinkishiritiro nokantsitakimiri: Tii ipinkathaitziri ompirataari janaakotiri ompiratariri. Ari inkimitaitimiri iirokaiti inkowaiti intsitokaitimi, inkimitaitina naaka. Iitarika kimisantapaantitakinani naaka, aritaki inkimisantaitakimi iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Iro inkowaitantyaari intsitokaitimi, naakataki intsitokawintaiti, okantakaantziro tii jiyotaina iri Pawa otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Iiro otzimaajaitzimi ikinakaashitani, iiromi nopoki niyotaayitairi. Iro kantacha iiro okantai jimanakotairo iyaaripironka. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ikaatzi kisaniintakinari naaka, ikisaniintakiri iijatzi Ashitanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Iiro otzimaajaitzimi ikinakaashitani, iiromi notasonkawintaki jiñaantakawori kaari jiñaapiintaitzi. Okantawitaka jiñaayitakiro jirokapaini, iikiro ikisaniintatyaana, ikisaniintsitakari iijatzi Ashitanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ari okantzimaita, tima ontzimatyii imonkaatya osankinarintsi, kantatsiri: Ikisaniintashiwaitakina. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Aririka impokaki ‘Ookaakowintaniri’, Tasorintsipirotatsiri, notyaantapaimiri nontsipatyaari Ashitanari, iriitaki yotashiritakaimini piyotantinari naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Impoña pinkinkithatakotaina iirokaiti, aritaki pitsipatsitakina owakiraini atantanakawori”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Iro nokantantzimirori jirokapaini, iiro powajyaantantawo pawintaashiritaina. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ari piñaakiro iiro ishinitaimi pintyagai tsika japatotapiintaita. Ari piñaakiro iijatzi intsitokaitimi, jiñaajaantaiti jantatziiniri Pawa kamiithari. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iro jimatantyaawori jiroka, tima tii jiyotziri Ashitanari, tii jiyotana iijatzi naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Aririka imonkaatatya jiroka, iro pinkinkishiritantyaawori nokantakimiri. Irootaki nitantzimirori nokamantzimiro”. “Tii nokamantsitzimiro owakiraini jiroka, tima irojatzi notsipayitzimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Irootaintsi niyaatai nontsipatapaiyaari otyaantakinari. Tikaatsimaita osampitakowintironi tsika niyaatai, ");
INSERT INTO cpcNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","apa powashiritaiyani pikimakina nokantakimiro jirokapaini. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pinkimi nonkantimiro tyaaryoori. Iro kamiithatzimotimini iirokaiti niyaatai. Tima iirorika niyaatai, iiro ipoki iitachari ‘Ookaakowintaniri’ intsipashiritaimi. Irooma aririka niyaatai, naaka otyaantapairini. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Aririka impokapaaki Tasorintsinkantsi, iri ooñaawontapaakinirini ikinkishiriwaitari isaawijatziiti, tima ikinakaashiwaitakawo ikinkishiritakotziro kaaripirokantsi, kamiithashirinkantsi, yakawintaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ari jiyotakaayitairi iro kaaripirokantsi iirorika ikimisantaitana naaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ari jiyotakaayitairi iro kamiithashirinkantsi, nimatziro naaka nowamiithashiritantzi, tima niyaatairika Ashitanariki iiro jokitaitaana. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ari jiyotakaayitairi iita jiyakawintaitakiri, iriitaki pinkathariwintakiriri isaawijatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Iinirotatsi ojyiki nonkantimiri, kimitaka aritaki anaanakimi nokantakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Aririka impokaki Tasorintsipirori, iriitaki yotaapaakimironi maawoni tyaaryoori. Tima iiro jiñaawaitashitawo ikowashitari irirori, aña inkamantantiro ikimakiri. Ari jiyotakaimiro onkaati awijatsini paata. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Iri kimainani noñaawaitiro, jowawijaañaanitimiro iirokaiti, ari onkantya jiyotantaityaawori nowaniinkawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tima okaatzi jiyotanitari Ashitanari, irojatzi niyotanitari naaka. Irootaki nokantantakari: ‘Iri kimainani noñaawaitiro, jowawijaañaanitimiro iirokaiti’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kapichitapaaki iiro piñaana, iro osamaniwitatya ari piñiina iijatzi. Tima niyaataatyi Ashitanariki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ikanta jiyotaani josampitawakaanaka: “¿Iitama ikantakotziri? Ikantakai kapichitapaaki iiro añaayitairi, iro osamaniwitatya ari añagairi iijatzi, tima jiyaatatyi Ashitaririki. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Iitama ikantakotziri ‘kapichitapaaki?’ Tii akimathatziro iita ikinkithatakotziri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ari jiyotaki Jesús ikowaiyatziini josampitiri, ikantanakiri: “Nokantaiyakimini: ‘Kapichitapaaki, iiro piñaana, iro osamaniwitatya ari piñiina iijatzi’. ¿Irooma posampitawakaari? ");
INSERT INTO cpcNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ari piñairo piraawaitaiya, owashiri pinkantaiya, piñaaminthatiri isaawijatziiti ikimoshiritaiyini. Onkantawitya powashiriwaitya, aritaki piñiiro pinkimoshiriti. Imapiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Aririka ontzimaaniti tsinani, okimaatsiwaita. Aririka intzimaki owaiyani, ompiyakotanakiro okimaatsiwaitaka okimoshiriwintanakitziiri iinchaanikiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ari onkimityaari iijatzi, ontzimatyii powashiriwaitya iirokaiti. Aririka piñaawaina, ojyiki pinkimoshiritanai, tikaatsi owashiritakaimini. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Paata tikaatsi posampitainari. Iri Ashitanari mataimironi oitarika pinkowakotinari pimpairyaayitaina. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pamanapiintari Ashitanari pikowakotziri oitarika, pikamiminthawaitashitari. Irooma aririka pinkowakotairi, ontzimatyii pimpairyaapiintaina naaka. Aririka pinkantya pinkowakotapiintairi, aritaki jimatakimiro, irootaki pinkimoshiritantaiyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nojyakaawintatziimiro maawoni nokinkithatakotakimiri. Iro kantacha irootaintsi imonkaatya iiro nojyakaawintaimiro, aña koñaawoini nonkinkithatakotaimiri Ashitairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Paata, ari piñaayitairo iirokaiti pimpairyagaina pinkowakotairi Ashitanari. Tii naaka kamitakowintaimini. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Iriitaki Ashitairi itakoyitaimiri iirokaiti. Iro jitakotantzimiri, tima pitakoyitana naaka, pikimisantakina nopoñaakawo naaka Pawaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nopoñaanaka Ashitairiki nopokantakari jaka kipatsiki. Iro nookawintanairo kipatsi iro nompiyi Ashitairiki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ipoña ikantanaki jiyotaani: “Koñaatanaki piñaawaitziri, tii pojyakaawintawaitziro. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Noñaakimi piyotziro maawoni tsikarika oiyita, tii okowajaanta intzimi osampitimini, aña piyotziro iitarika ikinkishiritari. Irootaki nokimisantantari imapiro pipoñaaka Pawaki”. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ari jakanaki Jesús, ikantzi: “¿Arima, kimisantaimi iroñaaka? ");
INSERT INTO cpcNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Monkaatapaaka. Irootaintsi, piñaayitiro pintzimpooki pinkinayiti tsikarika, ari pookawintanakina apaniroini. Iro kantacha tiimaita nosaiki apaniroini, aña Ashitanari tsipatanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nokamantayitzimiro maawoni jiroka onkantya piñaantyaawori kamiitha pisaiki pintsipatina naaka. Jaka isaawiki, ojyiki piñaashiwaityaawo. Iro kantacha, pishintsishiriyiti. Tima noitsinampaakiro naaka isaawijato”. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ikanta ithonkakiro ikantakiro jirokapaini, aminanaki Jesús inkitiki, ikantanaki: “Ashitanarí, monkaapaititapaaka. Poñaagantairo jowaniinkawo pitomi, iroñaagantsityaawo iijatzi pitomi powaniinkawo iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Iirokataki owakiriri ipinkathariwintantariri maawoni atziri, inkañaanitakaantyaariri ikaatzi pashitakaakariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aririka jiyoitaimi apaniroini Pipawapirotzi iiroka, jiyoitairi Jesucristo potyaantakiri, ari inkañaanitakairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Noñaagantakimiro powaniinkawo jaka kipatsiki, nothotyaakimiro pikantakinari nantiro. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pishinitina nontsipataimi, Ashitanarí, ari ankaati añaayitairo owaniinkawo akimita kitziroini tikiraamintha awitsikiro kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Jirikaiti piyoshiitairi pashitakaanari, niyotaayitairi iitarika iiroka. Iirokataki ashitsitariri, ipoña pashitakaayitanaari naaka. Nokimisantakaayitaimiri piñaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ikinkishirita, okaatzi niyotanitari naaka, iirokataki yotakaanawori. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Niyotaayitairi okaatzi piyotakaanari, ikimisantanakiro jirikaiti. Ikinkishiritanaa tyaaryoo nokaatzimi iiroka, ikimisantanai iirokataki otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naakataki kamitakowintziriri jirikaiti. Tii iri nonkamitakowinti nampitashiwaitawori kipatsiki, aña nokamitakowintatziiri pashitakaanari. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","maawoni nashitari naaka irijatzi pashitari iiroka. Ikaatzi pashitari iiroka irijatzi nashitari naaka. Tima iriitaki oñaagantaironi nowaniinkawo. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Iiro nosaikanai jaka isaawiki, niyaatai nontsipatapaimi iiroka, irooma jirikaiti iikiro isaikanakityi. Ashitanarí Tasorintsi, pinkimpoyaawintiri impairyaapiintantimini, iro jiwithaawakaantyaari, akimitawakaa aaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Iinta notsipayitari jaka isaawiki, naamaakowintari, nokimpoyaawintziri ipairyaapiintantzimiri. Iiro itzimayitai piyashiwaitaachani, apatziro inkantakaiyaawo jiitaitziri ‘Otomi piyashiwaitaantsi’, ari imonkaatyaari okinkithatakotakiri Osankinarintsipirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Iro niyaatai pisaikinta iiroka. Irootaki nokantantawori jirokapaini iinta nosaiki isaawiki, inkimitantyaanari naaka inkimoshiritaiyini kamiithaini jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Niyotaakiri piñaani, owanaa ikisaniintaitanakiri, tima tii ikimitanaari isaawijatziiti, nokimita naaka tii isaawijatzi ninatyi. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tii nokowakotzimi paayitairi isaiki jaka isaawiki, apa pinkimpoyaawintairi ikaaripirotakaitzirikari. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nokimita naaka tii isaawijatzi ninatyi, iijatzi jirikaiti tii jojyanaari isaawijatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pintasorintsishiritakairi jaakowintanaiyaawo tyaaryoori. Tima tyaaryoori inatzi piñaanitari iiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pikimitaakina naaka potyaantakina nosaikimotiri isaawijatziiti, ari nonkimitairi iijatzi iriroriiti notyaantairi isaikimotairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Okowapirotya nontasorintsishiritai noshiniwintaiyaari jirikaiti, onkantya intasorintsishiritantaiyaari iijatzi irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tii apa nonkamitakowintiri jirikaiti, aña nokamitakowintsitari inkaati kimisantainani aririka inkinkithatakaayitairi jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Namanakowintari maawoni jirikaiti onkantya jiwithaawakaantaiyaari, apaani inkantaiya jiwithaanaimi iiroka. Ashitanarí, akimita aaka awithaawakaa, ari inkimitaiyaari iijatzi iriroriiti jiwithaawakaapirotaiya, onkantya inkimisantantaiyaari isaawijatziiti iirokataki otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jiroka nowaniinkawo, okaatzi poñaagakinari, irojatzi nimatairi naaka noñaagairi iriroriiti. Ari onkantya jiwithaawakaantyaari, akimitawakaa aaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tima pitsipashiritana iiroka, ari nokimitsitari iijatzi naaka notsipashiritari iriroriiti, ari onkantya jiwithaawakaantyaari. Iro inkinkishiritantyaari isaawijatziiti iirokataki otyaantakinari, antawoiti pitakotakari pikimitaakina naaka antawoiti pitakotakina. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ashitanarí, iirokataki ashitakaakinariri jirikaiti, nokowi intsipataina tsika nosaikai naaka, jiñaantaiyaawori nowaniinkawo. Iirokataki owaniinkatakaakinari, tima pitakotsitakina kitziroini tikiraamintha iwitsikaata kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ashitanarí tampatzikashiriri, tii jiyotaimi isaawijatziiti. Iro kantacha naaka niyotzimi, iijatzi jirikaiti jiyotzi iirokataki otyaantakinari. ");
INSERT INTO cpcNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Niyotaayitairi iitarika iiroka, iikiro niyaatakaatyiiro niyotairi, tima notsipashiritaari, nitakoyitaari pikimitaakina naaka pitakotakina”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Aritaki ithonkanakiro ikantayitakiro jiroka, shitowanaki Jesús itsipatanaari jiyotaani jiyaatiro intatsikironta owaryiinkariti jiitaitziro “Cedrón”. Ari otzimiri pankirintsimashi, tsika janta isaikapaaki Jesús itsipayitakari jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jiñiitawo iijatzi Judas jirika pithokashitantachani, tima ari isaikakaapiintziri Jesús jiyotaani janta. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ari jariitapaaka Judas itsipatapaakari owayiriiti, itsipatakari aamaakowintawori tasorintsipanko jotyaantakiri ijiwari Ompiratasorintsitaari, jotyaantani iijatzi Fariseo-paini. Joirikayitapaakiro itsitokaminto, jamaki iijatzi jootaminto. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Iro kantacha Jesús jiyotsitakawo maawoni awijyimotirini, ishitowashitanakiri, josampitawakiri: “¿Iitama paminaminatziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ikantaiyini jirikaiti: “Naminaminatatziiri Jesús Nazaret-jatzi”. Ari ikantzi Jesús: “Naakataki”. Jirika Judas pithokashitaniri ari itsipatakari jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jiñaawaitanaki Jesús, ipiyaponthotaiyanakani itaapiiki, tyagaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Japiitanakiri Jesús, josampitziri: “¿Iitama paminaminatziri?” Japiitanakiro irirori, ikantzi: “Naminaminatatziiri Jesús Nazaret-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ari japiitanakiri Jesús, ikantziri: “Aritaki nokantakimi naakataki. Naakarika paminaminatzi, potyaantairi notsipayitakari, jiyaataita”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ari imonkaatari ikantsitakari Jesús: “Ashitanarí, ikaatzi pashitakaakinari, iiro ipiyakaantawaita apaani”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ikanta Simón Pedro, otzimimotziri irirori josataaminto, jinoshikanakiro, itotsitakiri ikimpitapironampi iitachari Malco, jotsikatani Ompiratasorintsipirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ipoña Jesús, ikantanakiri Pedro: “Powairo posataaminto. Iri Ashitanari shinitakinari nonkimaatsiwaityaawo jiroka, ¿iiroma okantzi nimonkaatiniri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ikanta owayiriiti itsipatakari ijiwari, iijatzi ijiwari aamaakowintawori tasorintsipanko jotyaantani Judá-mirinkaiti, joirikanakiri Jesús, joojotanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ari jitapaintawo ikinakaanakiri ipankoki Anás. Iriitaki rikonkiri Caifás Ompiratasorintsipirotatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jirika Caifás iriitaki kantakiriri kitziroini Judá-mirinkaiti: “Iro kamiithatatsi ashiniti apaani atziri inkamawintai”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ikanta Simón Pedro itsipatakari pashini jiyotaani Jesús, joyaatakowintanakiri Jesús. Jirika pashini yotaari, iñaapiintani jinatzi Ompiratasorintsipirori, irootaki ityaantapaakari joyaatakowintakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Iriima Pedro ari ikatziyapaakari jantakironta otantotsiki. Jirika yotaari iñaapiintani Ompiratasorintsipirori, ikinkithawaitakaakiro aamaakowintawori ashitakowontsi, iro omontyaantakariri iijatzi Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Okanta aamaakowintawori ashitakowontsi, osampitakiri Pedro: “¿Kaarima iiroka jiyotaani jirika atziri?” Ari jakanaki Pedro, ikantzi: “Tii naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tima okatsinkaityaatzi, jirikaiti ompirataari itsipatakari aamaakowintawori tasorintsipanko jowaampataiyakini paampari. Ari isaiki jakitsitaiyani. Ari itsipatakari iijatzi Pedro jakitsitaiyani paampariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ikanta Ompiratasorintsipirori jitanakari Jesús josampikowintziri jiyotaanipaini, iijatzi okaatzi jiyotaantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ari ikantanaki Jesús: “Nokinkithatakaapiintakiri maawoni atziriiti. Niyotaantapiintaki japatotapiintaita iijatzi tasorintsipankoki, japatotaiyani maawoni Judá-mirinkaiti. Tii nimanakaawo okaatzi nokinkithayitziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Iitama posampitantanari naaka? Posampitiri ikaatzi kimayitakinari. Iriiyitaki yotzirori okaatzi nokantayitakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jakakiri Jesús, apaani aamaakowintawori tasorintsipanko ipajapootanakiri, ikantziri: “¿Arima pinkantiri pakiri Ompiratasorintsipirori?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jakanaki Jesús, ikantanakiri: “Tzimatsirika kaaripirori noñaawaitakiri, pinkantinawo tsika otzimi. Aña okaatzi noñaawaitakiri kamiitha inatzi. ¿Iitama pipajapootantanari?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ikanta Anás jotyaantakiri isaiki Caifás Ompiratasorintsipirotatsiri, joojotaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Irojatzi ikatziyaka Pedro jakitsiwaita paampariki. Ari josampiitakiri: “¿Kaarima iiroka jiyotaani jirika atziri?” Ari jotikanakiro Pedro, ikantanaki: “Tii naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ikanta osamaniityaaki josampitairi iijatzi jompiratani Ompiratasorintsipirori, iriitaki ijyininkathori itotsitakiri inkaanki ikimpita, ikantziri: “¿Kaarima iiroka noñaaki itsipatzimi pankirintsimashiki?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ari japiitanakiro Pedro jotikañaanitantzi, aripaiti jiñaanaki tyoopi. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Aritaki kitiijyitzimatanaki, jomishitowaitanairi Jesús ipankoki Caifás, jaitanakiri isaikinta Pilato ijiwariti Roma-jatzi. Tii ityaiyapaakini Judá-mirinka ipankoki Pilato, tima aririka intyaapankotakiri ipiyathatakawo Ikantakaantaitani ikitiwathatantaitari, iiro okantzi joimoshirinkiro kitiijyiri Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Irootaki ishitowantapaakari Pilato, ikinkithawaitakairi, ikantziri: “¿Iitama jantakiri jirika atziri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ikantaiyini irirori: “Iiromi ikaaripirotzimi jirika, iirotya namirimi jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ikantzi Pilato: “Paanairi iirokaiti, powasankitairi tsika okantzi ikantakaantaitzimiri”. Ikantaiyanakini Judá-mirinkaiti: “Aña tii pishinitapiintina nashiryaantya naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ari imonkaatakari ikantsitakari Jesús tsika onkantya jowamaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ipoña ipiyanaka Pilato ityaapaintzi inthomainta ipankoki, ikaimapaakiri Jesús, josampitakiri: “¿Iirokatakima Iwinkathariti Judá-mirinkaiti?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ari ikantzi Jesús: “¿Piyotashitawoma posampitanari? Kimitaka tzimatsi iita kantakimiri iitarika naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jakanaki Pilato: “¿Naakama Judá-mirinka? Aña iri pijyininkaiti amakimiri jaka itsipayitakari ijiwari Ompiratasorintsitaari. ¿Iitama pantakiri?” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ari ikantzi Jesús: “Tii nopinkathariwintantzi naaka jaka isaawiki. Ari onkantyaami, aritakimi piñaakimi ojyiki nowayiriti piyakowintinani, iiro jaakaantantana Judá-mirinkaiti. Tii ari nompinkathariwintanti jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Japiitanakiri Pilato josampitanakiri: “¿Arima, iirokataki Pinkathari?” Ari ikantzi Jesús: “Iirokataki kantaintsiri. Irootaki notzimantakari, irootaki nopokantakari jaka kipatsiki nokinkithatakotairo tyaaryoori. Tima ikaatzi kamaitanaawori tyaaryoori, ikimisantapaantitana”. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ari ikantzi Pilato: “Irojatzitawiitacha, tyaaryoori”. Ikantanakiri, shitowanaki ipiyotaiyakani Judá-mirinkaiti, ikantapairi: “Tiitya noñiiro iitya inkinakaashityaari jirika atziri. ");
INSERT INTO cpcNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Poimoshirinkapiintziro Anankoryaantsi, pamitaiyawoni nomishitowi apaani jaakaantaitziri. ¿Nomishitowakaantairima jiitaitziri ‘Piwinkathariti?’ ” ");
INSERT INTO cpcNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ari ikaimaiyanakini maawoni, ikantaiyini: “¡Iiro pomishitowiri jirika! ¡Iri pomishitowi Barrabás!” Jirika Barrabás, koshintzi jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ikanta Pilato ipajatakaantakiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ikanta owayiriiti jimpitatapotaki kitochii ikimitakaantakiro amathairintsi, jamathaitakiri Jesús. Ipoña ikithaatantakari pitzirishimawotatsiri kithaarintsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ari ipiyowintapaakari, ishirontaminthawaitari ikantaiyirini: “¡Jirikatá Iwinkathariti Judá-mirinkaiti!” Ipajapootzimaitari. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Iijatzi ishitowapai Pilato, ikantapairi Judá-mirinkaiti: “Paminiri, jirika nomishitowakiri piyotantyaari tii noñi oita ikinakaashitakari jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ishitowapaaki Jesús jamathaitakawo kitochiitapo, ikithaatakawo iijatzi pitzirishimawotatsiri kithaarintsi. Ikantzi Pilato: “¡Jirika atziri!” ");
INSERT INTO cpcNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ikanta ijiwari Ompiratasorintsitaari iijatzi aamaakowintawori tasorintsipanko, ikaimaiyanakini, ikantaiyini: “¡Pimpaikakotakaantiri! ¡Pimpaikakotakaantiri!” Ikantzi Pilato: “Jirika paanakiri iirokaiti pimpaikakotiri, tii noñi naaka oita inkinakaashityaari jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jakaiyanakini Judá-mirinkaiti: “Tzimatsi Ikantakaantaitanari, ontzimatyii jowamagaitiri jirika, ikimitakaantashiwaitaka Itomi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ikimawaki Pilato ikantaiyakini ikimitakaanta Itomi Pawa jinatzi, owanaa ithaawanaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Iijatzi ipiyanaa inthomainta ipankoki, josampitapaakiri Jesús: “¿Tsikama pipoñaaka iiroka?” Tiimaita jaki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ikantzi Pilato: “¿Iiroma pakana? ¿Tiima piyotzi pinkatharipirori ninatzi naaka, ari onkantaki nompaikakotakaantimi, ari onkantaki iijatzi nomishitowakaantimi?” ");
INSERT INTO cpcNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ipoña jakanaki Jesús, ikantzi: “Iiromi ikantakaawo Jinokijatzi, iirotya pipinkatharipirotzimi. Iroowa nonkantimiri naaka, iri mapirotakirori ikaaripirotzi amakinari jaka, anaanakiro piyaaripironka iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ari ikowitanaka Pilato jomishitowakaantairimi Jesús, iro kantacha iikiro ikaimotaiyatziirini Judá-mirinkaiti ikantaiyini: “¡Aririka pomishitowakaantairi jirika, tii paapatziyari piwinkathapiroriti César! ¡Iitarika ojyakotyaarini jirika atziri, ikimitakaantawaita pinkatharimi jinatyi, ikisaniintatziiri César!” ");
INSERT INTO cpcNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ikanta ikimawaki Pilato, jamakaantakiri Jesús, jagaitanairi ipiyowintaitakari, joosaikapaakiri tsika jaminakoitapiintziri iyakawintaari, jiitaitziro “Mapipankaa”, iro jiitaitziri iijatzi iñaaniki Heber-paantiri “Gabata”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ikanta jiwitsikawintaitawo Anankoryaantsi joimoshirinkaitiro, ari tampatzikatapaaki ooryaatsiri. Ikantziri Pilato jirikaiti Judá-mirinka: “¡Jirika Piwinkathariti!” ");
INSERT INTO cpcNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Iikiro ikaimaiyatziini jirikaiti, ikantzi: “¡Inkami! ¡Inkami! ¡Pimpaikakotakaantiri!” Ari ikantzi Pilato: “¿Kantatsima nompaikakotakaantiri piwinkathariti?” Ari jakaiyanakini ijiwari Ompiratasorintsitaari, ikantaiyini: “¡Iri César nowinkathariti, tikaatsi pashini!” ");
INSERT INTO cpcNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ikanta Pilato, joipiyairi Jesús jaanairi Judá-mirinkaiti impaikakotiri. Ari jaanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iriitaki natanakirori Jesús inchakota impaikakoitantyaariri, jataki jiitaitziro “Atziriitoni”, irojatzi jiitaitziri iñaaniki Heber-paantiri “Gólgota”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ari ipaikakoitakiri, itsipatsitakiri apiti atziri, apaani jowatzikakoitaki jakopiroriki, jowatzikakoitakiri pashini jampatiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ikanta Pilato jontarikakaantaki ipaikakoitakiri Jesús osankinarintsi, kantatsiri: “JESÚS NAZARET-JATZI, IWINKATHARITI JUDÁ-MIRINKAITI”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ojyiki Judá-mirinkaiti ñaanatakirori osankinarintsi, tima tii intainapirotzi osaiki nampitsi, tsika ipaikakoitakiri Jesús. Tima josankinaitakiro jiroka osankinarintsi iñaaniki Heber-paantiri, iñaaniki Grecia-paantiri, iñaaniki Roma-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Irootaki jiyaatantakari ijiwari Ompiratasorintsitaari jiñiiri Pilato, ikantakiri: “Iiro posankinatziro: ‘Iwinkathariti Judá-mirinkaiti’. Aña onkantatyiimi posankinatakaanti: ‘Kimitakaantashiwaitachari iwinkathariti Judá-mirinkaiti’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Iro kantacha Pilato, ikantanakiri: “Okaatzi nosankinatakiri, ari ashi owatyiiro osankinataka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ikanta jimatakiro owayiriiti ipaikakotakiri Jesús, jaitsitakiri imanthaki, tii apintakotata itotakiro, ipawakaayitakawo ikaataiyini. Ipoña jaitsitakiri iijatzi iithaari, tii owawikotatya, apaani okanta jontyagaitziro irojatzi isaawiki. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ari ikantawakaiyani owayiriiti: “Iiro asagaawaitziro jiroka, apa añaariwintyaawo, ari añiiro iita ayironi”. Ari imonkaatari Osankinarintsipirori, kantatsiri: Ipawakaayiitakawo nomanthaki. Iñaariwintaitakawo noithaari. Irootaki jantakiri owayiriiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Okanta janta ipaikakoitakiri Jesús ari osaikitakari inaanati otsipatakawo irinto, María iina Cleofas, iijatzi María Magdala-jato. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ikanta Jesús jiñaakiro inaanati, otsipatakari jiyotaani jitakopirotari, ikantanakiro inaanati: “Tsinaní, iriitaki pintomitaiyaari jirika”. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ipoña ikantanakiri jiyotaani: “Irootaki pinaanatitaiyaari jiroka”. Aripaiti osaikapankotanakiri jirika iyotaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Okanta awijayitaki maawoni jiroka, yotaki Jesús aritaki jimonkaatakiro, ikaimanaki: “¡Nomiriwí!” Ari imonkaatari okinkithatakotakiriri Osankinarintsipirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ari osaikakotakiri kipijyaari janta kowitziki. Jaanaki inchashithaki, jankowitaki manthakintsi, jomitsitsiyakiro kipijyaariki, jowaankakotakiniri ipaantiki Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jatsimiyawakiro Jesús jiroka kipijyaari, ipoña ikantanaki: “Othotyaapaaka maawoni”. Ari ithaminkotanaka, jatashirinkatanaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ari monkaatapaaka jiwitsikawintapiintawo kitiijyiri jimakoryaantaitari. Tii ikowi Judá-mirinkaiti inkatziyakoti ipaikakoitziri kitiijyiriki jimakoryaantaitari, tima jiroka kitiijyiri iro ipinkathapiroitziri. Irootaki ikowakotantariri Pilato intzinkaaporitaitiri paikakotaari inkamantanatyaari thaankiini, jowatzikaryaakotiriita iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ikanta jiyaatanaki owayiriiti, itzinkaaporitapaakiri apaani itsipatakari Jesús ipaikakoitziri, jimatakiri iijatzi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ari ipithokashiwitanakari Jesús, jiñaatziiri kamaki. Irootaki kaari itzinkaaporitantari irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Josataamirikitashitanakari, yowanaki iriraani otsipatakawo jiñaa. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jirika kinkithatzirori jiroka, iriitaki ñaakirori rokiki. Imapirotatya ikamantzimiri ari onkantya pinkimisantantyaari iijatzi iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iro awijantakari jirokapaini imonkaatantyaari Osankinarintsipirori, ikantaitaki: Iiro itzinkaawaitaitziro itonki irirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ikantsitaitaka iijatzi: Ari jaminakoitakiri josataamirikitaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ikanta okaatapaaki jiroka, José Arimatea-jatzi, ikamitairi Pilato, ikantziri: “Pishinitinari naanairi Jesús”. Jirika José irijatzi kimisantziriri Jesús, tiimaita jiyoitziri tima ithaawantatyaari Judá-mirinkaiti. Ikanta Pilato ishinitakiniri. Jataki José, jaanairi. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ari ipokitsitapaaka iijatzi Nicodemo, jatashitakiriri pairani Jesús tsiniripaiti, jamakotapaaki kasankaari, ojyiki otinanka jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ikanta José itsipatakari Nicodemo jaanairi Jesús, iponatantakari manthakintsi itziritantakari kasankaari. Iro jamitaiyarini Judá-mirinkaiti ikitatapiintziri kaminkari. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Janta ipaikakoitakiri Jesús, ari otzimiri pankirintsimashi, ari otzimi owakiraari omoo tikira ikitaitantawoota. ");
INSERT INTO cpcNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ari jowaitakiri Jesús, tima irootzimatapaaki kitiijyiri jimakoryaantapiintari Judá-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Okanta awijanaki kitiijyiri jimakoryaantaitari, ananinkanaki María Magdala-jato amaityaaki iyaati omoonakiki jowaitakiri Jesús. Oñaapaatziiro otainkaki mapi jashitantaitakawori omoona. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Opoña opiyanaka iroori oshiyapirotanakitya iyaatashitiri Simón Pedro itsipatakari pashini yotaari, jitakopirotani Jesús, okantapaakiri: “¡Jagaitakiri Awinkathariti, tii ayotzi tsikarika jowaitairi!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ikanta Simón Pedro itsipatakari pashini jiyotaani Jesús, jatanaki kitataariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ishiyanakitya jiyaatanaki apitiroiti. Iro kantacha pashini ishiyapirotanakitya jookanakiri Pedro, iri itapaakawori jariitaka kitataariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Initapitapaaki omooki, jiñaapaakitziiro omaryaamawotaka iponaitantakariri, tiimaita ityaapaaki inthomainta. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ari jariitapaaka Simón Pedro, ityaapaaki inthomainta, jiñaapaakiro iijatzi omaryaamawotaka iponaitantakariri. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jiñiitapaakawo manthakintsi joojoyinaitantakari iitoki, inashita jowaitanakiro tii otsipatawo iponaitantakariri, kamiitha jotzipiyaitanairo. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ipoña ityaapaaki iijatzi pashini yotaari itapaakawori jariitaka kitataariki. Jiñaapaakiro kantainchari, ari ikimisantapirotanaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tikira ikimathatziro Osankinarintsipirori, aritaki jañagai Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ipoña ipiyaiyaani ipankoki apiti yotaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ari osaiki María opatzimooki iraawaita. Okanta iraawaitaka, ari onitapitzi inthomainta omooki, ");
INSERT INTO cpcNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","oñaatziiri apiti maninkari okitamaanikitaki iithaari, isaikaki tsika jomaryaawiitakari Jesús. Apaani isaikaki iitowiitakari, isaikaki pashini iitziwiitakari. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ikanta maninkariiti, josampitakiro ikantziro: “Tsinaní, ¿iitama piraantari?” Akanakiri iroori, okantzi: “Tima jaitsiitakinari Nowinkathariti, tii niyotzi tsika jowaitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Iro okantakitziini, ari opithokanaka, oñaatziiri Jesús, tiimaita iyotawairi iriitaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ari josampitanakiro Jesús, ikantziro: “¿Iitama piraantari tsinaní? ¿Iitama paminiri?” Oñaajaantzi iroori iri ñaanatzirori aamaakowintawori pankirintsimashi, okantanakiri: “Pinkatharí, iirokarika aakiriri, pinkamantina tsika powakiri, niyaatiita naminairi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ari jiñaanatanakiro Jesús, ikantziro: “¡María!” Ari aminanakiri iroori, okantzi: “¡Raboni!” (iro ikantaitziri añaaniki aaka: “Yotaanarí”.) ");
INSERT INTO cpcNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ikantziro Jesús: “Aritaki potiyana, tima tikira niyaataita nontsipatapaiyaari Ashitanari. Iro kantacha piyaati pinkamantinari iyikiiti, iro niyaatai nontsipatapaiyaari Ashitanari tsika itzimi Ashitsitzimiri iijatzi iirokaiti. Iri Nowawanitari naaka, irijatzi Piwawanitsitari iirokaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Okanta iyaatanaki María Magdala-jato, okamantapaakiri maawoni yotaari oñagairi Awinkathariti, okamantapairi iijatzi okaatzi ikantakirori. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Okanta otsiniritanaki awijanaki kitiijyiri jimakoryaantaitari, apatotaiyakani iyotaari jashitakotaiyakani shintsiini ithaawantari Judá-mirinkaiti. Ari ityaapaakiri Jesús, ikatziyimotapaakari, jiwithatapaari ikantapairi: “¡Pisaikayitai kamiitha iirokaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ikanta jiwithatapaari, joñaagapairi jako, iijatzi imiriki. Ikimoshiriyitaiyanakini jirikaiti jiñaawairi Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ipoña japiitanakiro Jesús, ikantziri: “¡Pisaikayitai kamiitha iirokaiti! Ikimitaakina jotyaantakina naaka Ashitanari, ari nonkimitsitaimiri iijatzi iirokaiti notyaantayitaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ari itasonkiri yotaariiti, ikantziri: “Isaikashiritantaimi Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Iitarika pimpiyakotairi iiroka jaka, aritaki ipiyakoitairi janta. Iriima kaari pimpiyakotai iiroka jaka, tii ipiyakoitairi iijatzi janta”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ikanta Tomás itsipatapiintari 12 iyotaari, jiitaitziri “Tsipari”, tii isaiki irirori jariitantapaari Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ikanta pashinipaini iyotaari ikamantairi, ikantziri: “Noñiiri Awinkathariti”. Ari jakanaki Tomás, ikantziri: “Iirorika noñiiri tsika ipaikawakoitakiri, iirorika notyaantari jakoki, iirorika notyaantamirikitari iijatzi, iiro nokimisantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Okanta awijanaki 8 kitiijyiri, japiitairo yotaari japatotaiyani. Ari isaikitakari iijatzi Tomás irirori. Jashitakiro shintsiini ashitakowontsi, iro kantacha Jesús tyaapaaki, ikatziyimotapaari, jiwithatapaari ikantapairi: “¡Kamiitha pisaikayitai iirokaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ikantapairi Tomás: “Jiroka nako, pintyaantawakotina, pintyaantamirikitina iijatzi. Iiro pikisoshiriwaitzi, ¡Pinkimisanti!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ari ikaimanaki Tomás, ikantanaki: “¡Nowinkatharití, Nowawaní!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ikantzi Jesús: “Iro pikimisantantamachiitanakari piñaakina. ¡Kimoshiri inkantaiya kimisantaatsini kaari ñaajaitinani!” ");
INSERT INTO cpcNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ojyiki japiitakiro Jesús joñaagari jiyotaani itasonkawintantaki, tiimaita osankinatakoyita maawoni jaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Iro osankinatantakari jirokapaini onkantya pinkimisantantaiyaari, jirika Jesús iriitaki Cristo, Itomi Pawa. Aririka pimpairyaapiintairi pikimisantairi, aritaki inkañaanitakaimi. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ikanta okaatapaaki jiroka, japiitakiro Jesús joñaagari jiyotaani, inkaarithapiyaaki jiitaitziri Tiberias. Jiroka okantaka. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ari itsipatawakaiyani isaiki Simón Pedro, Tomás jiitaitziri iijatzi “Tsipari”, Natanael poñaachari Caná-ki saikatsiri Galilea-ki, itomipaini Zebedeo, ipoña apiti pashini iyotaari. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ipoña ikantzi Simón Pedro: “Niyaatatyi noshiryaati”. Ikantaiyini pashini: “Ari ankaataiyanakini”. Jataiyanakini, otitaiyapaakani pitotsiki. Tiimaita jayi ishiryaataiyakini tsiniri. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Okanta okitiijyitzimataki, katziyapaaka Jesús opaayaaki inkaari. Tii jiyotawairi jiyotaani iriitaki. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ikaimotapaakiri, ikantziri: “Mainariití, ¿Tikaatsima pagaiyini?” Ari jakaiyanakini iriroriiti: “¡Tiitaawí!” ");
INSERT INTO cpcNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ikantzi Jesús: “Powiinkiro pakopiroriki pishiryaaminto, ari paaki”. Ari jimataiyakironi ikantaitakiriri. Jaaki ojyiki shima, tii jaawiyagairo jinoshikairo ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ikanta yotaari jitakopirotani Jesús, ikantanakiri Pedro: “¡Iriitaki Awinkathariti jirinta!” Ikimawaki Simón Pedro, ikithaatanaka, mitaanaki inkaariki. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Iriima pashinipaini yotaari pitotsiki ikinakoyitanai jinoshikaatakotairi ishimani, irojatzi jaatakotantapaari opaayaaki. Tima isaikakotakitzi niyantyaaniki. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ikanta jayiitaiyapaakini, jiñaapaakitzi oijaka paampari, ari itashitakari shima, itsipataitakiri tanta. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ari ikantzi Jesús: “Pamaki shima owakiraa paakiri”. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ikanta Simón Pedro, joojoryaakotakiri ishimani, jinoshikakotakiri irojatzi opaayaaki. Antaripaini shima, ikaatzi 153. Tiimaita otzimpijyi ishiryaaminto. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ari ikantzi Jesús: “Thami oya”. Tikaatsi apaani yotaari osampitirini iitakarika, tima jiyopirotaiyakirini iriitaki Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jaapaakiro Jesús tanta, ipayitakiri apaanipaini, ari ikimitaakiri iijatzi shima. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Irootaki mawatanaintsiri joñaagari Jesús jiyotaani jañagai. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ithonkanakiro jowaiyani, josampitanakiri Jesús jirika Simón Pedro, ikantziri: “Simón, itomi Jonás, ¿Pitakopirotanama iiroka?” Ikantzi Pedro: “Piyotzi iiroka Pinkathari, naapatziyimi”. Ikantzi Jesús: “Paamaakowintinari nokimitakaantziri noijyati”. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Japiitakiri josampitziri: “Simón, itomi Jonás, ¿pitakotanama?” Ikantzi Pedro: “Piyotzi iiroka naapatziyimi”. Ikantzi Jesús: “Paamaakowintainari nokimitakaantairi noijyati”. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iro mawatanaintsiri josampitziri, ikantziri: “Simón, itomi Jonás, ¿paapatziyanama?” Ari jowashiritanaka Pedro, tima mawajatzi josampiminthatakiri, ari jakanakiri: “Pinkatharí, iirokataki yotzirori maawoni, piyotzi iiroka naapatziyimi”. Ikantzi Jesús: “Paamaakowintinari nokimitakaantairi noijyati. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tima iinta pimainaritzi, pikithaatapiintayita onkini piyaayiti tsika pinintakaawo. Irooma aririka pantaripirotapaaki, poyaawintari pashini kithaataimini, jaayiitaimi tsika tii pikowawitawo piyaati. Imapiro”. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ikantantakawori Jesús jiroka, ikowatzi inkimathaitiro tsika inkantya inkamai paata Pedro impinkathataitantyaariri Pawa. Ipoña ikantanakiri iijatzi: “¡Poyaatina!” ");
INSERT INTO cpcNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ikanta ipithokanaka Pedro, jiñaatziiri joyaatakiri yotaari jitakopirotani Jesús, irijatzi apititakariri Jesús jowaiyani pairani, osampitakiriri, ikantziri: “¿Pinkatharí, itzimikama pithokashitimini?” ");
INSERT INTO cpcNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ikanta jiñaawakiri Pedro jirika pokapaintsiri, josampitanakiri Jesús: “Pinkatharí, jirika, ¿iitama awijyimotirini?” ");
INSERT INTO cpcNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ikantzi Jesús: “Arimi nonkowimi aritaki onkantaki jañi jirika, irojatzi nompiyantaiyaari paata, ¿okowajaantzima piyotiro jiroka? Poshiritina iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Okanta paata ithonka ikimakoitakiro jiroka ikantakiriri Jesús, ikimayitakiro maawoni iyikiiti, jiñaajaantzi iiro ikamita jirika yotaari. Tii ikantatyi: “Ari nokowi...” aña ikantatzi: “Arimi nonkowimi, aritakimi onkantaki jañi jirika, irojatzi nompiyantapaatyaari, ¿okowajaantzima piyotiro jiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Naakataki kinkithatakotacha nokantaki “jirika yotaari”, tima naaka osankinatakirori jiroka osankinarintsi. Irootaki ayopirotantaari imapirotatya jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Tii nokinkithatakotziro maawoni jantayitakiri Jesús, tima ojyiki inatzi. Arimi osankinatakotyaami maawoni, kimiwaitaka arimi anaanakiro maawoni kipatsi ompiyotya osankinarintsipaini. Ari onkantyaari.");
INSERT INTO cpcNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo, pairani owakiraa nitantanakawori notyaantzimiro nosankinari, ari nokinkithatakotakimiro maawoni jantayitakiri Jesús, nokinkithatakotsitakimiro iijatzi okaatzi jitanakari jiyotaantziri, ");
INSERT INTO cpcNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","irojatzi imonkaatantapaakari itzinagaa inkitiki. Tikira itzinagaata, jiyoshiitakiri Jotyaantapiroriti, ikantakaakari Tasorintsinkantsi, jiyotakaakiri oitya jantayitiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ikanta ikamawitaka, jiñaitawairi koñaawoini, ari jiyotaiyini jiyotaani añagai. Okaatzi 40 kitiijyiri joñaagapanaatari jiyotaani, jiyotaapanaatziri tsika ikanta ipinkathariwintantzi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iiniro itsipayitari Jotyaantapiroriiti, ikantsitakari irojatziita isaikayitawaki Jerusalén-ki, ikantakiri: “Ari poyaawintawatyaawo imonkaatya ikajyaakaakimiri Ashitanari, nokinkithatakotsitakimiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tima imapiro Juan jowiinkaatantakawo jiñaa, iro kantacha iiro osamanitzimaita piñaayitantyaariri Tasorintsinkantsi inampishiriyitantimi kimiwaitakimi jowiinkaatantatyiimirimi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ikanta jirikaiti tsipatakariri Jesús, josampitakiri, ikantziri: “Pinkatharí, ¿Irootaintsima pookakaawintairi nojyininkapaini Israel-mirinkaiti?” ");
INSERT INTO cpcNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ari jakanakiri Jesús, ikantziri: “Tii okowajaantzi piyotiro iirokaiti tsikapaiti, apaniroini jiyotzi Ashitanari tsikapaitirika, iriitajaantaki otzimimotzi ishintsinka jantantyaawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iro kantacha aririka impokaki Tasorintsinkantsi inampishiritantimi iirokaiti, iriitaki aawiyashiritakaimini, ompoña piyaayitanaki pikinkithatakotaina naaka, Jerusalén-ki, maawoni janta Judea-ki, Samaria-ki, irojatzi intaina tsika iwiyaapaa kipatsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ithonka jiñaawaitakiro jiroka, jaminaminthaitziri jiyotaani, itzinaayiitairi Jesús, irojatzi ipiyantapaakari minkoriki, tii jiñaitanairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jaminaminthaitziri Jesús itzinagaitairi inkitikinta, apiti shirampari katziyimotapaakariri okitamaanikitaki iithaari, ");
INSERT INTO cpcNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ikantapaakiri: “Galilea-jatzi, ¿Iitama pikimpoyiiri inkitiki? Piñaakiri Jesús itzinagaa jiyaatai, ari inkantajaantaiya iijatzi paata aririka impiyi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ikanta ipiyaiyaani yotaari janta Jerusalén-ki ipoñagaawo otzishiki jiitaitziri Olivo, tii intainatajaantzi, oshinitaantsitzi janiiyiiti kitiijyiriki jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ikanta jariitaiyaani nampitsiki, atiitaiyapaakini jinokinta pankotsi jimaapiintaiyini. Jirika ikaataiyini: Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo itomi Alfeo, Simón jiitaitziri “Kisakowintantaniri”, ipoñaapaaka Judas iririntzi Jacobo. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","maawoni jirikaiti ari ikantapiintatya japatotapiintaiyani jamanamanaataiyani itsipayitakari iririntzi Jesús, itsipatawo María inaanati, iijatzi pashinipaini tsinaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ikanta japatotaiyani kimisantzinkariiti, ikaataiyini 120 atziriiti. Ari jiñaawaitanakiri Pedro, ikantanaki: ");
INSERT INTO cpcNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Iyikiiti, monkaataka okaatzi josankinatakaakiriri Tasorintsinkantsi pairani David-ni, ikinkithatakotakiri Judas jiwatapaintsiri jaakaantiri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jirika Judas iri atsipatapiintakari, ari akaawitari antawairiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Iro kantacha jaakiri kiriiki ipinawiitakariri iyaaripironka, jamanantantaka kipatsi. Ari iparyaakiri janta Judas, jowatziitotanaka, ithonka itankawaitapaaki, ookaporinthakiwaitapaaka ijyiito. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ikanta ikimaiyakini Jerusalén-jatzi, jiitakiro kipatsi ‘Iraantsipatha’, ikantziro iñaaniki jirikaiti ‘Acéldama’. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tima osankinarintsiki Salmo-ki, ikantaitaki: Onkaankithaantiwitya ipanko, Tikaatsi nampitaiyaawoni. Ikantaitaki iijatzi: Intzimi pashini poyaataiyaarini jantawairiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Tzimatsi jaka shirampariiti tsipatapiintakairi iiniro itsipawitai Awinkathariti Jesús, ");
INSERT INTO cpcNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","itzimi akaatsitakari owakiraa jowiinkaataka Jesús irojatzi itzinaantaari inkitiki. Akowatzi aminai ankaatairi ñiitakariri Jesús jañagai”. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ipoña jookoitaki apiti: José, jiitaitziri Barsabás, irijatzi jiitsitaitari Justo, ipoñaapaaka Matías. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ari jamanakowintanakari, ikantzi: “Pinkatharí, iiroka yotashiritziriri maawoni, jirika apiti nookotakiri, poñaayinari tsika itzimi piyoshiitakiri iiroka, ");
INSERT INTO cpcNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","iriitaki nonkaatairi notyaantapiroritzi nantawaitaimi, poyaataiyaarini Judas-ni opiyaakaashiwaitakari iyaaripironka irirori. Tima Judas, jataki irirori tsika jiyaati”. ");
INSERT INTO cpcNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ikimitakaantakawo jirikaiti jiñaaritaita, jiñaatzi iriitaki Matías. Iriira tsipatapaariri jirikaiti 11 Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Okanta imonkaatapaaka joimoshirinkaitziro kitiijyiri “Oyiipataantsi”. Japatotaiyaani maawoni jiyotaani Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ari omapokashitakari antawoiti poimatapaintsiri ojyawitapaakawo antawo tampiya, okinapaaki jinoki inkitiki, ookantapaakawo pankotsi japatotaiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jiñaashitataika paampashithakiirikitapaintsiri, jookantapaakari apaanipaini ikaatzi apatotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","maawoni jinampishiritantapaakari Tasorintsinkantsi. Ari jitanakawo jiñaawaiyitanakiro pashiniyitatsiri ñaantsi, iriitaki Tasorintsinkantsi ñaawaitakaakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Okanta janta Jerusalén-ki, ari isaikayitziri Judá-mirinkaiti poñaayitachari intaina pashiniki nampitsi. Iriiyitaki pinkathatasorintsiiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ikanta ikimaitakiro poimatapaintsiri, ipokaiyapaakini ojyiki atziri, tii jiyotawakiro oita kantachari, tima ikimathatakiro apaanipaini ñaantsi okaatzi jiñaawaiyiitziri, irootaki iñaani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Iyokitzi ikantawakaanaka, josampitawakaiyani: “¿Tiima Galilea-jatzi jinatzi ñaawaiyitakirori pashiniyitatsiri ñaantsi? ");
INSERT INTO cpcNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Iitama akimantariri jiñaawaiyitziro añaanipaini aaka? ");
INSERT INTO cpcNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tima akaayitakiri jaka Parto-jatzi, Medo-jatzi, Elam-jatzi, Mesopotamia-jatzi, Judea-jatzi, Capadocia-jatzi, Ponto-jatzi, Asia-jatzi, ");
INSERT INTO cpcNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia-jatzi, Panfilia-jatzi, Egipto-jatzi, Africa-jatzi okaakitapai Cirene. Tima akaatakiri iijatzi poñaayitachari Roma, Judá-mirinkatatsiri, kaari Judá-mirinkawitachari pairani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Iijatzi Creta-jatzi, Arabia-jatzi. Ari akaatakiri maawoni akimayitakiri jiñaawaiyitantawo añaanipaini, ikinkithatakotziri Pawa itasonkawintantzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Iyokitzi ikantawakaanaka atziripaini, tii jiyotzi iita jiñiiri. Ikantawakaiyani: “¿Oitama jiroka?” ");
INSERT INTO cpcNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Iro kantacha tzimatsi iijatzi atziri thainkantaniri, ikantayitzi irirori: “¡Ishinkitaiyatyaani jirikaiti!” ");
INSERT INTO cpcNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ipoña ikatziyanaka Pedro irirori, itsipatakari 11 Otyaantapiroriiti, jiñaawaitanaki shintsiini, ikantzi: “¡Ajyininká! ¡Jerusalén-jatziiti! Pinkimisantawakina onkantya piyotantyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Piñaajaantakima iirokaiti ishinkitatya jirikapaini. Tii, tima owakiraa ijinokitapaaki ooryaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Imonkaatatya josankinatakiri pairani kamantantaniri, Joel-ni, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ikantzi Pawa: Tzimatsi awisatsini iwiyaantapaatyaawoni kitiijyiri. Ari notyaantakiniri atziriiti Notasorinka okimiwaitakawo isakopiroitatyiinirimi. Ari inkinkithatakoyitanaina itomiiti iijatzi irishintoiti. Ari jiñaawiyayitatya mainariiti, Ari imishiyitaki antariyitapaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ari nonkimitaakiri mainaripaini jompirayiitari, iijatzi mainawopaini. Notyaantainiri Notasorinka paata, ari inkinkithayitai. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ari jiñiitaki inkitiki kaari jiñiitapiintzi. Jiñaitiro kipatsiki iraantsi, paampari, antawo kachaaryiinka. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Impoña jiñaitiri ooryaatsiri intsiwakimati, Jiñaitiri iijatzi kashiri inkimityaawo iraantsi, Irootaintsi imonkaataiya kitiijyiri impiyantaiyaari Pinkathari. Tima antawo jowaniinkawo onkantaiya. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Inkaati pairyaanairini Pinkathari, jawintaayitaari, iriiyitaki awisakoshiritaatsini. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","¡Shirampariiti! ¡Israel-mirinkaiti! Pinkimaiyini nonkanti. Piñagaiyakirini iiroka, jirikaranki Jesús Nazaret-jatzi, iriitaki jotyaantakimiri Pawa. Itasonkawintayitakimi, joñaagayitakimiro okaatzi kaari piñaawitaiyani pairani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Iro kantzimaitacha, jamayiitapaakimiri pairani jirika, powamaakaantakiri iirokaiti ipaikakotantakariri kaaripiroshiririiti, ari imonkaatakari onkaati awijyimotirini, tima irootaki ikinkishiritsitakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ikanta jowiriintairi pairani Pawa ikamawitaka, tii ishinitanairi inkimaatsiwaitaiya. Tima tii aawiyaajaitziri kaamanitaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tima iri josankinatakotakiri iijatzi pairani David-ni, ikantaki: Noñaapiintziri Nowinkathariti itsipatana. Tima isaiki irirori nakopiroriki, tikaatsi iitya kitsirinkinani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Irootaki nokimoshiritantari, Kaminiwaanti nokanta nothaaminta. Iriitaki noyaakopirotairi, nawintagaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Tima iiro pookawintanawo noshiri sarinkawiniki aririka nonkamawitatya. Iiro pishinitziro iijatzi nowatha ompathai, pitasorintsiti ninatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Piyotaakinawo tsika nonkantya nañaashiritai. Ojyiki poimoshirinkaina aririka nontsipataimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Iyikiiti, ayotaiyini aaka tii iri achariniiti David-ni kinkithatakotachani jaka, aña kamataiki pairani irirori, ikitaitakiri, irojatzi isaiki iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Tima Kamantantaniri jinatzi irirori, jiyotsitaka pairani tzimatsi ikajyaakaakiniriri Pawa, ari impinkatharitakairi incharinityaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Tima okimiwaitakawo jiñaakityiiromi David-ni, ikinkithatakotakiro jañagai Cristo, ikinkithatakotakiri iiro isaiki Sarinkawiniki, iiro opathai iijatzi iwatha. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Iriitaki jañaakagairi Pawa jirika Jesús. Imapirotatya, maawoni noñagaiyairini naaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Aritaki tzinagaa, isaikimotapairi jakopiroriki Pawa ipinkathariwintantapai. Ari imonkaatari okaatzi ikajyaakaitsitakariri pairani Ashitariri, aritaki jotyaantakiniri Tasorintsinkantsi okimiwaitakawo isakopirotaitatyiinirimi. Irootajaantaki piñaayitakiri iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tima kaari David-ni tzinagaachani inkitiki, aña iriitaki ñaawaitakirori pairani jiroka, ikantaki: Jiñaawaitaki Pinkathari, ikantawairi Nowinkathariti: Pisaikapai nakopiroriki ampinkathariwintanti. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Irojatzi paata nowasankitaantaiyaariri kisaniintzimiri, ari paatzikairi pinkimitakaantairi pimakoryaakiiminto. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","¡Ajyininká! iro kamiithatatsiri ayotaiyironi jiroka maawoni aakaiti ichariniyitai Israel-ni. Jirika Jesús pipaikakotakaantakiri iirokaiti, iri Ipinkatharitakaakiri Pawa, irijatziita Cristo”. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Okanta ikimaiyawakini ikaatzi apatotainchari, antawoiti jowashiritakoniintaiyanakani, josampitanakiri Pedro, iijatzi pashinipaini Otyaantapirori, ikantaitanakiri: “Iyikiiti, ¿tsikatya nonkantaiyaaka naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ari jakanakiri Pedro: “Pimpiyashiriyitai, powiinkaawintaiyaari Jesucristo, pimpairyaayitanairi. Iro jiyotantaityaari ipiyakotaimiro Pawa pikaaripirowitaka, ari inampishiritantaimi Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Irootaki ikajyaakaitsitakimiri iijatzi iiroka, irojatzi ikajyaakaitsitakariri pitomipaini, ikaatzi nampiyitawori intaina. Tima maawoni ikaimashiriyitairi, irijatzi ikajyaakaitsitakariri iijatzi irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ojyiki okaatzi ikinkithatanakiri Pedro, ishintsithatanakiri iijatzi, ikantanakiri: “¡Powawisaakoshiritaiya! ¡Pintainaryiiyaari atziriiti kinashiwaiyitainchari!” ");
INSERT INTO cpcNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Irojatzi ikimisantantanakari ojyiki atziri, owiinkaayitanaka, ikaatzi 3,000 kimisantanaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Oisokiro jowanakiro okaatzi jiyotaayitakiriri Otyaantapirori, kamiitha jaapatziyawakaanaa. Ari ipitoryaapiintaiyironi tanta, jaakowintanakawo iijatzi jamanamanaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iyokitzi ikantawintaiyakawoni jiñaakiro itasonkawintantayitaki Otyaantapiroriiti, jantayitakiro kaari jiñiitapiintzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ojyiki jaapatziyawakaanaka ikaatzi kimisantanaatsiri, jantitaawakaanaawo okaatzi tzimimoyitziriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ipimantayitziro tzimimoyitziriri. Jayi kiriiki ipayitziri kimisantanaatsiri ikaatzi ashironkaayitachari. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ari ikantaitanakitya kitiijyiriki jaapatziyawakaanaa japatotaiyani tasorintsipankoki. Tii jowajyaantanakiro ikaimawakaiyani ipankoki jatyootawakaiyani, ari ipitoryiiro tanta. Kimoshiri ikanta itsipatawakaiyani, itsinampashiriyitanai. ");
INSERT INTO cpcNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ithaamintapiintanakari Pawa. Iro inimoyitakiriri atziriiti jiñaayitakiro tsika ikantayitanaa. Ari okantaitanaatya kitiijyiriki jojyiñaanairi Awinkathariti kimisantzinkariiti inkaati awisakoshiriyitaatsini. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Okanta pashini kitiijyiri, aritaki tsiniriityaanaki jamanapiintaitantari. Ari itonkaanakiri Pedro itsipatanakari Juan, jiyaatiro tasorintsipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ari itonkiyotakotantaka jamaitziri shirampari kisopookitatsiri. Ari ikantsitatya owakiraa itzimapaaki. maawoni kitiijyiri jamaitapiintziri omooki tasorintsipanko jiitaitziro “Owaniinkaanto”. Ari isaikapiintziri impashitantaityaariri kiriiki ikamiyitziri tyaayitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ikanta jirika jiñaawakiri Pedro itsipatakari Juan, iro intyaantapaatyaawomi tasorintsipankoki, ikamitawakiri impashitanatyaari kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ari ikimpoyaanakiri. Ikantziri: “¡Paminina!” ");
INSERT INTO cpcNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ikimisantatzi shirampari, jiñaajaantaki impatyiiri tsika oitya. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Iro kantacha Pedro, ikantanakiri: “Tii itzimi noiriikiti, tii itzimi iijatzi oro, iro kantacha tzimatsi nantzimotimiri. ¡Pinkatziyi! ¡Paniitai! Nompairyiimiri Jesucristo Nazaret-jatzi, iriitaki matimironi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jakotashitanakiri, ikathatakiri, jowatziyakiri. Omapokashitanaka ishintsitanai iitziki iijatzi ijyoonkitziki. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ari jomiyanaka ikatziyanaka, aniitanaki. Ari itsipatanakari jirikaiti ityaapaaki tasorintsipankoki, anii-aniiwaitanai, mitaamitaawaitanai, ithaamintanaari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ithonka jiñaitakiri janiitanai, ikimakiri iijatzi ithaamintanaa. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iyokitzi ikantaitanakiri jiñaitakiri, tii ikompiitawakari jirika shirampari, iriitaki kamitantapiintatsiri impashitaityaari omooki tasorintsipanko, jiitaitziri “Owaniinkaanto”. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ikanta kisopookiwitachari, tii jookani jowanakiri Pedro itsipatakari Juan. Iyokitzi jowanakiri atziriiti, thaankipiroini ipiyowintapaakari awisatapishitzi tasorintsipankoki jiitaitziro “Jashi Salomón”. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ikanta jiñaawakiri Pedro, ikantawakiri: “¡Shirampariiti! ¡Israel-mirinkaiti! ¿Iitama piyokitziiwintantanari naaka? Iiro pikinkishiriwaitashita naaka ashitawo noshintsinka, naaka tasorintsi nimatantariri naniitakagairi jirika. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aña Iwawani Abraham-ni, Isaac-ni, Jacob-ni, iwawanitanakari iijatzi achariniiti, iriitaki matakirori jiroka, impinkathaitantyaariri Itomi Jesús, paakaantakiri iirokaiti janta jiwariitiki. Ikowawitaka Pilato jomishitowakaantairimi, tii pikowimaita iirokaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Iriitakimi pomishitowakaantaimi Tasorintsitatsiri, matzirori itampatzikashiritzi, aña pomishitowantashitaari tsitokantzinkari. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ari okanta pipiyakaantakariri añaakaashiritantatsiri. Iro kantacha Pawa jañaakagairi. Noñagaiyakirini naakaiti jañagai. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Okaatzi oshinchagairiri jirika shirampari piñaapiintziri iirokaiti, iro matakaakiriri jawintaashiritanaawo nopairyaakirira Jesús. Irootaki piñaantariri iroñaaka ishintsitai tyaaryoopiroini. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Iyikiiti, niyotzi naaka, tii piyopirotziro okaatzi pantayitakiri, ari ikimitakari iijatzi pijiwaripaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Iro kantacha Pawa, ari ikinakairo jimonkaatziro okaatzi ikinkithatakaayitakiriri maawoni Kamantantaniriiti, ikantaki: ‘Aritaki inkimaatsitakaitatyaari Cristo paata’. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Irootaki, pimpiyashitantaiyaariri iirokaiti Pawa, powajyaantayitairo piyaaripironka, onkimiwaityaawomi jojyitakotaatyiiromi pikaaripirowitaka. Ari piñagairo intsipashiritaimi Awinkathariti, ijamparyaakoyitaimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Aritaki jotyaantairi Pawa iijatzi Jesucristo, tima ikajyaakaitsitakimiro pairani aritaki impiyi. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Onkantawitatya iroñaaka, ontzimatyii isaiki Jesucristo inkitiki irojatzi inintapaititantyaari Pawa jowakiraatakagairo maawoni okimiyiwita pairani. Tima iro ikinkithatakaayitakiriri Tasorintsishiriri Kamantantaniriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Irootaki ikinkithatakotakiri pairani Moisés-ni, ikantaki: Ari jotyaantaki paata Pawa pashini Kamantantaniri, ari jojyakotapaatyaanawo naaka jotyaantakina. Ajyininka jinatyi. maawoni inkamantapaakairi, ontzimatyii ankimisantiro. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tima maawoni kaari kimisantirini Kamantantaniri, ari japiroyiitairi, iiro jiñairi ijyininkapaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ari ikimitsitakari iijatzi Samuel-ni, ikinkithatakotakiro okaatzi añaayitakiri iroñaaka, irojatzi ikinkithatakoyitakiri iijatzi maawoni pashinipaini Kamantantaniriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iirokayitaki ñiironi okaatzi ikajyaakaantakiri Pawa ikinkithatakoyitakiri Kamantantaniriiti. Iirokayitaki ñiironi iijatzi okaatzi ikajyaakaawakaakari pairani Pawa itsipatakari achariniiti. Tima Pawa ikantakiri Abraham-ni: Iri picharini tasonkawintairini maawoni jyininkatawakaachari tsikarikapaini janta kipatsikinta. ");
INSERT INTO cpcNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ikanta jañaakagairi Pawa itomi, ari jitakari jotyaantakimiri iirokaitiki, intasonkawintantimini, maawoni iirokaiti powajyaantayitairo piyaaripironka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Iinirotatsi Pedro itsipatakari Juan ikinkithatakaayitziri atziriiti, ariitaiyapaakani Ompiratasorintsitaari, itsipatapaakari ijiwari aamaakowintawori tasorintsipanko, Saduceo-paini. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ikisaiyatyaani, tima Pedro itsipatakari Juan jiyotaatziiri atziripaini, ikantayitziri: “Imapiro jañaayitai kamawitachari, iriitaki Jesús oñaagantapaintzirori”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Joirikaitapaakiri, jomontyaakaantakiri irojatzi oñaatamanai, tima aritaki tsiniriityaaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Iro kantacha ojyiki ikaatzi kimayitawakirori kinkitharintsi, ikimisantayitanaki. Jiroka ikaatzi tzimanaintsiri kimisantzinkariiti, ikaataiyini 5000 shirampariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Okanta oñaatamanai, japatotaiyakani Jerusalén-ki maawoni ijiwariti Judá-mirinkaiti, Antaripiroriiti, Yotzinkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ari isaikakiri iijatzi Anás Ompiratasorintsipirori, Caifás, Juan, Alejandro, iijatzi ijyininkamirinkaiti Ompiratasorintsipiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ikaimakaantakiri jamaitiri Pedro itsipatakari Juan. Josatikaitawakiri niyanki japatotaiyakani, josampitakiri: “¿Iitakama shintsitakaimiri pimatantawori jiroka? ¿Iitaka pipairyaakiri?” ");
INSERT INTO cpcNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jakanaki Pedro, ñaapiro ikantakaanakari Tasorintsinkantsi, ikantanaki: “Pinkathariiti, Antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Iriima piñaantsikowintanari mantsiyari noshinchagairi? ¿Pikowatziima piyotaiyini tsika ikanta ishintsitantaari? ");
INSERT INTO cpcNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ari nonkamantaiyakimironi, jiyotantyaari maawoni Israel-mirinkaiti. Jirika shirampari atsipataiyakarini jaka, iri Jesucristo oshinchaakiriri, jiitaitziri Nazaret-jatzi. Iriitaki nopairyaakiri, irijatzi pipaikakotakaantakiri iirokaiti. Iro kantzimaitacha jañaakagairi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jirika Jesús iri ojyakawori mapi pimanintakiri iirokaiti, pikimitakowaitakari witsikirori pankotsi. Iro kantacha jowatzikaitairi pankotsinampiki ikimitaawo iroorikami tzinkamitsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tii itzimi pashini kimityaarini Jesús jowawisaakotantzi. Tikaatsi ampairyagai jaka isaawiki kipatsi, apaniroini ikantakaawo Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Iyokitzi jowaitanakiri Pedro, iijatzi Juan, ikantaiyanakini piyowintakariri: “Piñiiri jirika, tii jiyotaapirowiitari, iro kantzimaitacha pinkathañaani jowayiitziri. ¿Iriima yotaakiriri Jesús itsipatakari pairani?” ");
INSERT INTO cpcNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Irojatzi itsipatakari Pedro, Juan jirika atziri joshinchagairi. Tii otzimi oitya inkantakotanakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ipoña jomishitowakaantairi japatotaiyani, ari isaikaiyanakini irirori jiñaanatawakaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ikantzi: “¿Tsikama ankantirika jirikaiti shirampari? maawoni Jerusalén-jatzi jiyotaiyakini itasonkawintantaki. Iiro amatairo amanakotiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Thami asaryiimatashityaari, ari onkantya iiro jiyaatakaantawo inkinkithatakotiri Jesucristo, impairyaapiintairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ipoña ikaimairi iijatzi. Ikantaiyakirini: “Aritapaaki pikinkithatakotakiri Jesús, iiro papiitairo pinkinkithatakotairi, pimpairyaayitairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Iro kantacha jakanakiri Pedro ipoña Juan, ikantanakiri: “¿Kamiithatatsima nompiyathatyaari Pawa, nonkimisantantimiri iirokaiti? Incha pinkantina. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Iiro okantzi nowajyaantairo nonkinkithatakoyitiro noñaajaantakiri, nokimajaantakiri iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ikanta jasaryiimawaitakari jiwariiti, ipakagairi. Tima maawoni atziriiti ithaamintanakari Pawa jiñaayitakiro awisayitaintsiri, tii ontzimatyii oitya jowasankitaawintiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Jirika shirampari joshinchaakiri, anaaniintanakiro 40 tzimatsiri josarintsiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Ikanta Pedro ipoña Juan, aritaki ipakagaitairi, jataki japatotaiyani ikaataiyini, ikamantakiri okaatzi ikantakiriri ijiwari Ompiratasorintsitaari ipoña Antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Aritaki ikimaiyakironi, maawoni jamanamanaataiyanakarini Pawa, ikantziri: “Pinkatharipirorí, iirokataki witsikakiro inkiti, kipatsi, inkaari, opoña okaatzi tzimantayitawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Iirokataki kinkithatakaakiri pairani pinampiri David-ni, ikantaki: ¿Iitama ikiñaaniwintaiyirini atziriiti? ¿Iitama ikinkishiriwaitashitantakari? ");
INSERT INTO cpcNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Apatotaiyakani pinkathariwintantatsiri jaka kipatsiki, Ipiyoyitaka jiwariiti, Imaamanitantyaariri Pinkathari, iijatzi Cristo jiyoshiitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aritzimaitaka jimatakiro Herodes ipoña Poncio Pilato japatotaiyakani nampitsiki, iijatzi Israel-mirinkaiti ipiyotaiyakani itsipatakari pashinijatzi atziriiti, imaamanitakiri Jesús, pitasorintsiti Pitomi, piyoshiitani. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ari okantaka, jimatakiro jirikaiti okaatzi pikinkishiritakari tsika onkantya. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Iroñaaka, Pinkathari, paminiro iiroka jasaryiimatakina, pishinitainawo pompirayitaana iiro nothaawantawaita nonkamantantairo piñaani. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iro pishintsinka poshinchaantyaariri mantsiyayitatsiri. Iro pintasonkawintantyaanari nompairyiiri Tasorintsi Pitomi Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ikanta ithonkakiro jamanamanaataiyakani, ontziñaanaka janta tsika japatotaiyakani. Shintsi ikantakaanakari Tasorintsinkantsi ikinkithatakotanakiro iñaani Pawa, tikaatsi inthaawantanatya. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jyikitanaki kimisantanaatsiri. Apaani okantanaa ikinkishiritanaari. Tii ithañaapithatawakaawo oitarika, ipayitawakaawo kowityiimoyitariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jirikaiti Otyaantapiroriiti iikiro jiyaatatzi ikinkithatakotziro tsika okanta jañaantaari Pinkathari Jesús. Antawoiti inishironkayitairi Pawa maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Tii itzimawaitzi apaani kowityaaniintawaitatsiri, itzimirika tzimatsini iipatsiti, ipanko, ipimantayitziro. Jayiri kiriiki, ");
INSERT INTO cpcNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ipakiri Otyaantapirori, iriitaki antitaariri maawoni jaantayitari apaanipaini oita ikowiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iro jimatakiri Leví-mirinka jiitaitziri José, Chipre-jatzi jinatzi, iri jiitakiri Otyaantapiroriiti irirori, Bernabé. Ojyakaawintachari jiroka wairontsi Bernabé: “Itomi oimoshirinkantaniri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jirika shirampari tzimatsi iipatsiti, ipoña ipimantakiro. Jaanakiri owinawo iipatsiti, ipapaakiri Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Iro kantacha tzimatsi pashini atziri jiita Ananías, itsipatakawo iina oita Safira, ipimantakiro irirori iipatsiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Jirika shirampari jaapatziyakawo iina, jimanagaantaki owinawo iipatsiti. Jamakiri tzimagaantapaintsiri, ipapaakiri Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ikantawakiri Pedro: “Ananías, ¿iitama pishinitantakariri Satanás inthiiyakaimi, iro pikowantari pamatawitiri Tasorintsinkantsi, pimanagaantaki owinawo piipatsiti?” ");
INSERT INTO cpcNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","“¿Kaarima iiroka ashiwityaawoni kipatsi? ¿Kaarima iiroka ashityaarini owinawo? ¿Iitama pikinkishiritantakawori pantiro jiroka? Tii iri atziriiti pamatawiti, aña iri Pawa pikowawitakari pamatawitirimi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ikanta ikimawaki Ananías, tyaanaki, kamanaki. Antawoiti ithaawaiyanakini ikaatzi kimayitaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ipoñaanaka mainariiti, iponatapaakiri, jaanakiri, ikitatakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tikira osamanitzi, ari otyaapaaki iina Ananías, tii iyotzi iroori oita awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Josampitawakiro Pedro, ikantziro: “Pinkantina, ¿Arima ikaatzi owinawo?” Akanaki iroori: “Jii, ari ikaatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ikantziro Pedro: “¿Iitama paapatziyawakaantakari pikowi piñaantyaari Itasorinka Pinkathari? Jirika ipiyaiyaani aanakiriri piimi ikitatziri, iroñaaka jaitsitanakimi iijatzi iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Apathakiro okantanaka Safira tyaanaki ikatziyaka Pedro, kamanaki. Ikanta ityagaiyapaakini mainariiti, jiñaapaatziiro kamaki. Jaanakiro, itsipatagairo oimi ikitataka irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ikanta jiñaitakiro awisaintsiri, antawoiti ithaawaiyanakini kimisantzinkariiti, iijatzi ikimitsitakari ikaatzi kimakoyitakirori awisaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iikiro jiyaatakaanakitziiro Otyaantapiroriiti japatotapiintaiyanakani janta awisatapishitaki tasorintsipanko jiitaitziro “Jashi Salomón”. Iikiro itasonkawintantanakitzi atziriitiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ipinkani jowayitanakiri pashiniiti, tii ikowayitanai intsipatanaiyaari. Iro kantzimaitachari tzimataitatsi ojyiki thaamintapirowintanakariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iikiro ipokanakitzi shirampariiti iijatzi tsinaniiti, ojyikitanaki ikaatzi kimisantanairiri Pinkathari. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jamakotapaakiri atziri imantsiyariti jomaryaakoyitapaakiri ishitashiki tsika inkinapaaki Pedro. Ikantayitzi: “Inkinapaakirika Pedro jaka, aririka intsimankantanatyaari kapichiini jaampari, aritaki ishintsitai”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ari ikimiyitapaakari atziriiti poñaayitainchari nampitsiki saikanampitzirori Jerusalén, jamayitaki ojyiki mantsiyariiti iijatzi ojyiki piyarishiritatsiri, joshinchaayitawakiri maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ikanta Ompiratasorintsipirori, itsipatakari ikaatzi aapatziyakariri, jirikaiti Saduceo-paini, ikisaniintaiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jaakaantakiri Otyaantapiroriiti, jomontyaakaantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Iro kantacha otsiniriwitanaka, pokaki imaninkariti Pinkathari, ishiryaakotairi, jomishitowayitairi, ikantawairi: ");
INSERT INTO cpcNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Piyaati tasorintsipankoki, pinkinkithatakotainiri atziriiti tsika okantakota owakiraari añaamintotsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Okanta kapichikitiijyiri, ariitaiyapaakani tasorintsipankoki, jitapaawo ikinkithatakaantapaaki. Tiitya jiyotaiyini Ompiratasorintsipirori, apatotaiyachani itsipayitakari jaapatziyani, iijatzi maawoni jantaripiroriiti Israel-mirinkaiti. Ipoña jotyaantaki jamayiitakiri Otyaantapiroriiti jomontyaawiitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ikanta jiyaatashiwitanakari jomontyaani, tii jiñaapairi. Piyapaaka, ");
INSERT INTO cpcNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","ikantapaakiri: “Tii añagairi. Irojatzi okanta noñaawitapaakawo ashita kamiithaini, irojatzi ikatziyawita aamaakowintariri. Iro kantacha nashitaryaakowitapaakari, tii noñaapairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ikanta ikimawaki Ompiratasorintsipirori, ijiwari aamaakowintawori tasorintsipanko, ijiwari Ompiratasorintsitaari, josampitawakagaiyanakani oityaarika awisatsini. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ari jariitapaakari kamantapaakiriri: “Jirikaiti pomontyaakaantawitakari iirokaiti, isaikaiyini tasorintsipankoki ikinkithatakaayitziri atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Irojatzi jiyaatantanakari ijiwari aamaakowintaniriiti, jaanaki ojyiki jatziriti, jamairi iijatzi. Iro kantacha tii jakotashiwaitziri. Tima ithaawantatyaari atziriiti intsitokantyaari mapi. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ikanta jariitakaapaakari, jowawisaapaakiri tsika japatotaiyakani jiwariiti. Ikanta Ompiratasorintsipirori josampitawakiri, ");
INSERT INTO cpcNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ikantziri: “¿Tiima pikimi nokantzi chapinki: ‘Aritapaaki pikinkithatakotakiri Jesús?’ Iikiro piyotaatziiri maawoni Jerusalén-jatzi. Pikantakotakina iijatzi naaka, pikantzi: ‘Iri owamaakaantakiriri Jesús’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ari jakanaki Pedro itsipatakari pashini Otyaantapirori, ikantanaki: “Iri Pawa nonkimisantapiroti, iiro nokimisantashiwaitari atziri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tima imapiro powamaakaantakiri iiroka Jesús, pipaikakotakaantakiri. Iro kantacha jañaakagairi Pawa itzimajaantzi ikimisantakiri pairani acharinini. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Itzinagairi Pawa, joosaikairi jakopiroriki, itsipataari ipinkathariwintantzi. Iri owawisaakotaini iijatzi. Ikowaki ampiyashiriyitai maawoni aakaiti Israel-mirinkaiti, impiyakotantairori akaaripiroshiriwitaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Naaka ñaakiro okaatzi jantayitakiri Jesús, ontzimatyii nonkinkithatakotiro. Irijatzi Tasorintsinkantsi matakainawoni, tima iriitaki jotyaantakinari Pawa inampishiritantaiyaana naakaiti nokimisantairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ikanta ikimaiyakini, antawo ikisanaka, ikowanaki intsitokirimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iro kantacha ari ikatziyanaka apaani janta, iitachari Gamaliel. Fariseo jinatzi irirori, irijatzi yotaantzirori Ikantakaantaitani. Pinkatha jowiri maawoni atziri. Ikantanaki: “Ajyininká, incha omishitowawakiri kapichiini jirikaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ipoña ikantzi: “¡Shirampariiti! ¡Israel-mirinkaiti! ontzimatyii pinkinkishiritawatya kamiitha tsikarika pinkantiri jirika shirampariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Pinkinkishiritakotiri iitachari Teudas, ikantakaapirowaitaka irirori. Japatotaki pairani 400 atziri. Iro kantzimaitachari itsitokamachiitaitakiri Teudas, ithonka itzimpookayitanaki maawoni tsipawitakariri, ari ipiyakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Iijatzi okimitaka pairani josankinatakotantari maawoni atziri, itzimawita pashini iitachari Judas, Galilea-jatzi jinatzi. Japatotaki atziri. Iro kantacha itsitokamachiitaitakiri iijatzi irirori. Ipoña itzimpookayitanaki maawoni tsipawitakariri, ari ipiyakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pinkimi nonkantimi naaka: Iiro pimaamanitziri jirika, piñaashiminthatawatyaari. Iriirika antashiwaitawori inintakaanikiini, ari impiyashitaiya apaniroini, inkimityaari apitiroiti nokinkithatakotakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Iro kantzimaitacha, iriirika Pawa matakaayitziriri okaatzi jantayitziri, iiro pimatziri iirokaiti poitsinampairi. Paamaakowintya pimaamanitzirikari Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Inimotanakiri maawoni kimaintsiri. Ikaimairi iijatzi Otyaantapirori, ipajatakaantakiri, ikantakiri: “Aritapaaki pikinkithatakotziri Jesús”. Irojatzi ipakaantaariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ipoña ishitowaiyanaini Otyaantapirori japatowintaitakari. Thaaminta ikantaiyanakani, ikantaiyini: “Piñaataitiro ikimitakaantakai aakami iriipirori jowasankitaawintakairi Jesús, apairyiiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ari ikantapiintanaatya jiyotaantzi maawoni kitiijyiri, ikinkithatakaantzi tasorintsipankoki, ikantzi: “Cristo jinatzi jirikaranki Jesús”. Ari ikimitaakirori iijatzi pankotsipainiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ikanta ijyikipirotanaki jiyotaani, ñaawaiyitanaki Grecia-paantiri, ikantzi: “Paminiri jantapiintayitakiri Heber-paantiri, ipapiintayitziro owanawontsi kamatsiri oimi, imanintanakiro kaari ijyininkatayita iriroriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ipoñaashitaka 12 Otyaantapiroriiti, japatotakiri maawoni jiyotaani, ikantakiri: “Tii okantzi nookiro nokinkithatakotanairi Pawa naaka, nompapiintantimiri poyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Iyikiiti ontzimatyii pamini jaka akaataiyini, inkaati 7 atziri, iriitaki aminakaantapiintironi jiroka. Pamini kamiithashiritzimotakimiri, yotanitatsiri, inampishiripirotantari Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ari onkantya naakowintantyaawori naakaiti namanamanaayitya, nonkinkithatakaanti, niyotaantayiti iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ikanta maawoni apatotainchari, inimotanakiri okaatzi ikantakiriri. Ari jiyoshiitakiri Esteban, awintaariri kamiitha Pawa, inampishiripirotantakari Tasorintsinkantsi. Jiyoshiitakiri iijatzi Felipe, Prócoro, Nicanor, Timón, Parmenas, Nicolás Antioquía-jatzi kimitakotaariri Judá-mirinkaiti, tima jirika kaari ijyininka Judá-mirinka pairani. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ipoña jaayiitanakiri jirika 7 isaikaki Otyaantapirori, ari jamanamanaatakotawakari, itasonkawintakiri jotzimikapatziitotantakari jako. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iikiro iyaatakotanakitzi iñaani Pawa. Iikiro ijyikipirotanakitzi iijatzi jiyotaani janta Jerusalén-ki. Ari jimatsitanakawo ikimisantayitanaki ojyiki Ompiratasorintsitaariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ikanta Esteban ojyiki itasonkawintantayitaki atziriitiki, tima Pawa nishironkatakiriri, ipakiri ishintsinka. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Iro kantzimaitacha, tzimayitatsi Judá-mirinka ikaatzi apatotapiintachari jiitaitziri “Jompirawiitari”. Iriiyitaki poñaayitainchari Cirene-ki, Alejandría-ki, Cilicia-ki, Asia-ki. Jiñaanaminthatakiri Esteban. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Tii ikitsirinkaitziri Esteban, tima imapiro jiyotanitakaakiri Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Irootaki ikantantakariri ijyininka iwitsikakotiri kaaripirori ñaantsi, inkanti: “Nokimakiri Esteban ithainkimawaitziri Moisés-ni, ari ikimitakiriri Pawa iijatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iro owatsimaapirotanakiriri atziriiti ikisaniintanakiri Esteban, ari ikimitsitanakari Antaripiroriiti, iijatzi Yotzinkariiti. Jaakaantaitakiri, jaayiitanakiri japatotaiyani jiwariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ari jamaitapaakiri thiiyakotakariri Esteban, ikantapaaki: “Jirika shirampari ojyiki ithainkakiro tasorintsipanko, ithainkakiro Ikantakaantaitani iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nokimakiri ikantaki: ‘Jirika Jesús jiitaitziri Nazaret-jatzi impookakiro tasorintsipanko, impoña jowashiñaayitairo amiyitari aakaiti jiyotaayitairi Moisés-ni’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ikanta jiwariiti apatotainchari, ikimpoyaanakiri Esteban, jiñaatziiri ipooki ikimitanakari maninkari. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ikanta Ompiratasorintsipirori josampitakiri Esteban, ikantziri: “¿Imapiroma ikantakoitzimiri?” ");
INSERT INTO cpcNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ari jakanaki irirori, ikantzi: “¡Iyikiiti! ¡Iwaapatiitarí! Pinkimi nonkantimi. Pairani isaikawitantakari acharini Abraham-ni janta Mesopotamia-ki, joñaagakari owaniinkatachari Pawa, tikiraamintha jiyaatanakiita inampityaawo Harán-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ikantakiri: ‘Pookanairo pinampitsiti, pookanairi pijyininkamirinkaiti, piyaati pashiniki kipatsi noñaayimiri naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ikanta Abraham-ni, jookanairo inampitsiti iitachari Caldea. Irojatzi ipokantaari inampitaawo Harán-ki. Ikanta ikamai iwaapati, irojatzi jotyaantantakariri Pawa jaka, tsika anampitawo iroñaaka aakapaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Iro kantzimaitacha, tii jashitakaapirotari, tikaachaajaini jashitakaiyaari kapichiini. Ikajyaakaimaitakari impiri paata, aririka inkamaki. Iri ashitaiyaawoni inkaati charinitaiyaarini. Irootaki ikantakiriri okantawitaka Abraham-ni tikiraamintha itzimi jowaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iro kantacha ikantakiri iijatzi: ‘Jiñiiro pinchariniyityaari inampityaawo iipatsitiki pashini atziri. Onkaati 400 osarintsi inkimaatsiwaitya jompirawaitaityaari janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Impoña nowasankitaakiri naaka inkaati ompirawaitatyaarini. Iriima pinchariniyityaari namairi maawoni jaka nampitsiki, ari jantawaitainari naaka’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ipoña ikantakiri Pawa iijatzi pairani Abraham-ni: ‘Ontzimatyii pintomishitaanitya, tima tzimatsi ankajyaakaawakaiyaari’. Jimatakiro pairani Abraham-ni. Iijatzi ikimitaakiriri itomi irirori, iro jimaakotapaakitziini 8 kitiijyiri, itomishitaanitakiri. Ari ikimitaakiro Isaac itzimaki pairani Jacob-ni. Ari ikimitaakiri iijatzi Jacob-ni 12 itomipaini, achariniyitanakari aakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ikanta jirikaiti, achariniyitaari aakaiti, ikisaniintakiri iririntzi José, ipimantakiri. Ari okanta jariitantakari inampiki Egipto-jatzi. Iro kantacha, ari itsipatapiintakari Pawa, ");
INSERT INTO cpcNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","jowawisaakotairi okaatzi ikimaatsiwaiwitaka. Ipakiri yotanitaantsi, irootaki jaapatziyantakariri iwinkathariti Egipto-jatzi iitachari Faraón. Irojatzi ipinkatharitantakari irirori Egipto-ki, ipinkathawintakiri ijyininkamirinkaiti Faraón. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ipoña ariitaka antawo tajyitsi janta. Owanaa ikowityaaniintaiyakini Egipto-jatzi. Ari okimitakari iijatzi inampiki Canaán-jatzi. Tii jiñiiro pairani acharinini oitya jowayitaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ari ikimakiri Jacob iinitatsi owanawontsi Egipto-ki. Jotyaantakiri itomiiti ramanantakiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ikanta japiitakiro jiyaataiyini, ari jiyotairi José iririntzipaini. Ari okanta jiyotantakari Faraón ijyininkamirinkaititari José. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ipoña José, ikaimakaantairi iwaapati Jacob, iijatzi maawoni ijyininka, ikaatzi 75 atziri jataintsiri Egipto-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ari okanta jariitantakari Jacob Egipto-ki. Ari ikamairi irirori janta. Ari ikimitakari iijatzi ikaatzi achariniyitanakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ipoñaashitaka jaatonkiyiitanairi Siquem-ki, ikitatairi janta, jamanantakiniriri pairani Abraham-ni itomipaini Hamor. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Okanta imonkaatzimataka okaatzi ikantakiriri pairani Pawa acharini Abraham-ni. Tzimanaki ojyiki iriintsiti ajyininkapaini janta Egipto-ki, ");
INSERT INTO cpcNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","irojatzi itzimantakari pashini pinkathari janta Egipto-ki, kaari yotakotirini José. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ikanta jirika pinkathari, ojyiki jamatawitakiri ajyininka, jowashironkaawaitakiri. Ishintsiwintakiri jookayitiri iinchaaniki, inkamantyaari, iiro ijyikitanta. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Aripaiti itzimakiri Moisés irirori. Iriitaki jirika iintsi kamiithatzimotakiriri Pawa. Ikaatzi mawa kashiri jimanawitakari ipankoki ashitariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Okanta imonkaapaititapaaka jookawintantyaariri inkamimi, oñaakiri irishinto Faraón, aakiri, otzikatakari okimitakaantakiri iriitakimi owaiyani iroori. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ari ikantakari Moisés-ni jiyotantakawori okaatzi jiyotanitari Egipto-jatzi. Ñaapirori shirampari jinaki, iroopiro okantaka jantayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Ikanta otzimaki 40 josarintsiti Moisés-ni, ikowaki jariityaari ijyininkapaini, Israel-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Iro kantacha jiñaapaaki Egipto-jatzi jowasankitairi ijyininka. Ipiyakowintapaakari Moisés ijyininka, itsitokakiri Egipto-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jiñaajaantaki Moisés-ni ari inkinkishiritaiyatyaani ijyininkapaini, iriitaki jotyaantakiri Pawa jookakaawintairi. Iro kantzimaitacha jirikaiti tii jiyotakotaiyirini. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Okanta okitiijyitamanai, jiñaaki jantawakaiyani ijyininka. Ari ikowawitaka Moisés jookakairimi, ikantawitapaakari: ‘Iiro powashironkaawakaiyani pantawakaa, pijyininka powawakaiyani’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ikanta ijyininka Moisés, jotatsinkawakiri. Ikantziri: ‘¿Iitaka kantakimiri iiroka nowinkathariti? ¿Pikowatziima iiroka piyakawintina? ");
INSERT INTO cpcNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Pikowatziima pitsitokina pikimitaakiri chapinki Egipto-jatzi?’ ");
INSERT INTO cpcNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Ikimawaki Moisés ikantakiriri ijyininka, shiyanaka. Jataki iipatsitiki Madián-jatzi. Ari isaikakiri nampitsinintsiki, irojatzi itzimantakari apiti itomi. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Okanta awisaki okaatzi 40 osarintsi. Janta otzishimashiki, okaakitapai otzishi iitachari Sinaí, ari joñaagakari imaninkariti Pawa, ipaampatakairo kitochiimaishi. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Iyokitzi jowanakiro Moisés jiñaakiri. Ikowajaantzi jaminiro okaakiini, ari ikimakiri Pinkathari jiñaanatziri, ikantziri: ");
INSERT INTO cpcNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Pawa ninatzi naaka, naakataki ipinkathataki picharini, Abraham, Isaac, iijatzi Jacob’. Ari ithaawanakiri Moisés, okawaitanaka, tii ikowi jaminanairo. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ipoña ikantanakiri iijatzi: ‘Pinothopairi pi-zapato-ti, tima pikatziyantatyaawo kipatsi notasorintsipathatakaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Noñaakiri janta Egipto-ki niyoshiitakiri pijyininkapaini, ojyiki jashironkaawaitaka. Nokimakiri jatikashiriwaitaiyakani. Irootaki nopokantakari nookakaawintairi. Iirokataki notyaanti janta Egipto-ki pantiro’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tima pairani jimanintawiitakari Moisés-ni, ikantaitakiri: ‘¿Iitaka kantakimiri iiroka nowinkathariti?’ Aña iriitajaantaki jotyaantakiri Pawa impinkathariwintairi ijyininkapaini, iri ookakaawintairini iijatzi. Iriira matakairini imaninkariti Pawa jiñaakiri ipaampatakairo kitochiimaishi. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Irijatzi Moisés-ni omishitowairiri pairani ajyininkapaini Egipto-ki, ojyiki itasonkawintantzi janta. Ari ikimitaakiro iijatzi inkaariki jiitaitziri ‘Kityonkaari’, iijatzi okimitaka isaikawaiwitantakari okaatzi 40 osarintsi otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Irijatzi Moisés-ni kantakiriri pairani ajyininkapaini: ‘Ari jotyaantaki paata Pawa pashini Kamantantaniri, ari jojyakotapaatyaanawo naaka jotyaantakina. Ajyininka jinatyi’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Irijatzi Moisés-ni apatotakiriri pairani ajyininkapaini janta otzishimashiki, ikinkithawaitakaakiri maninkari otzishiki Sinaí, itsipayitakari ajyininkapaini. Iriitaki aajaantakiro añaakaantaniri ñaantsi, irojatzi jowawisaantakairori aakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Iro kantacha tii ikowi achariniiti inkimisantiri Moisés-ni, ojyiki ipiyathatakari. Iro ikowaiyakini impiyaimi inampiki Egipto-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iro ikantantakariri Aarón-ni: ‘Iriiwitaka Moisés owawisaakowintanari Egipto-ki. Iro kantacha tii ayotzi iita awijyimotakiriri kaari ipokanta jiyaatzi chapinki otzishiki Sinaí. Piwitsikina nowawanitaiyaari’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ari jiwitsikaitakiniri kimiwityaarini iwankiri vaca. Ikowaiyakini inkimitakaantiri Pawa. Jowamaakiniri ipirapaini joimoshirinkantyaariri iwawani. Aña iriiwitaka witsikakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Irootaki, jintainaryaantanakariri Pawa jirikaiti, ishinitanakiri impinkathatairi oorintayitachari inkitiki, tima iriitaki josankinatakotsitakari Kamantantaniriiti, ikantaki: ¡Israel-mirinkaiti! ¿Naakama pipinkathatantaka pipirapaini pitaapiintziri? Tima iro pantapiintakiri okaatzi 40 osarintsi janta otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Aña iri Moloc pipinkathatashitapiintakari, pikinakinatakaapiintakiri ipankojyitaitziri. Ari pikimitapiintakiri jiwawanitashiitari kimitariri impokiro jiitaitziri Renfán, Pipinkathatashiwaitakari piwitsikayitani iirokaiti. Irootaki noshinitantimiri jaayiitimi intaina panaanakiro Babilonia. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Isaikawaitantakari pairani achariniiti otzishimashiki, otzimimotziri tasorintsithaanti. Ari jowakoitziro josankinari Moisés-ni. Jiroka tasorintsithaanti, irootajaantaki jiwitsikakaantakiri Moisés-ni tsika okantajaanta joñaagakiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Irootaki jiroka jaajaapiintakiri pairani achariniiti, irojatzi jariitantakari kipatsiki ontzimi jashitaiyaari. Iro jamayitairi ijiwatantakariri Josué, joitsinampaantakariri ashiwitawori iipatsiti, ikantakaari Pawa. Ari ikantaitatziiro joisokirotakawo tasorintsithaanti, irojatzi itzimantakari pairani David-ni. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ikanta pinkathari David, ojyiki jaapatziyakari Pawa, ikantaki irirori: ‘Tima iiroka Pawa ipinkathataki pairani Jacob-ni, pishinitina naaka niwitsikimi pankotsi pisaikantyaari’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Iriitzimaitaka Salomón witsikakiniriri tasorintsipanko. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Iro kantzimaitacha Pawa, Jinokijatzi tii inampitantawo pankotsi jiwitsikani atziri. Iro ikinkithatakotakiri Kamantantaniri, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Jiroka ikantakiri Pawa: Irootaki inkiti nosaikantakari nopinkathariwintantzi. Irooma kipatsi nimakoryaakiiminto inatzi. ¿Tsikama onkaatika pankotsi jiwitsikayiitinari? Iiro nimonkaatawo nimakoryaantyaawo. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Kaarima naaka witsikayitakiro maawoni tzimayitatsiri? ");
INSERT INTO cpcNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Iikiro ikantatzi Esteban: ‘Iro kantacha iirokaiti, ari pinkantapiintatya pikisoshiritzi, tii pikimisantanitzi, pikimitakari pashinijatzi atziri kaari ajyininkayita. Pashi powapiintakiro pipiyathatakari Tasorintsinkantsi pikimitakoyitaari pichariniiti’. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Tzimaajaitatsima apaani Kamantantaniri kaari inkimaatsitakaawaitaitya pairani pichariniiti? Jowamaayitakiri ikaatzi kinkithataintsiri, ikantaki: ‘Aatsikitaki matzirori itampatzikatzi’. Aritaki pokaki iroñaaka matzirori, iriitaki pipithokashitakari iirokaiti, pitsitokakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tima iirokaiti yoyiwitawori Ikantakaantaitani okaatzi jiyotaawitakairi maninkari, iro kantacha owanaa pipiyathataka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ikanta ikimaiyawakini apatotainchari, antawo ikisanakiri Esteban, jatsikaikitashitanakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Iriima Esteban inampishiritantanakari Tasorintsinkantsi, jaminanaki inkitiki, jiñaakiro jowaniinkawo Pawa, jiñaakiri iijatzi Jesús ikatziyaka jakopiroki Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ipoña ikantanaki: “¡Pamini! Noñaakiro inkiti ashitaryaanaka, noñaakiri Itomi Atziri ikatziyaka jakopiroki Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ari jojyipikanakiro ikimpita jirikaiti. Ikaimaiyanakini shintsiini, ishiyashitapaakari Esteban. Joirikapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Jaayiitanakiri othapitapaa nampitsi. Ari jitapaakari itsitokantari mapi, jaatonkoryaiyanakironi iithaari, jookanakiniri mainari iitachari Saulo, ikantanakiri: “Paminawakinawo noithaari, nontsitokawakiriita”. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ikanta itsitokaitziri Esteban, jamanamanaatanakari irirori Pawa, ikantziri: “Nowinkathariti Jesús, jatashirinkatakina noñaapaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ari jotziirowanakari, jiñaawaitanaki shintsiini, ikantanaki: “Nowinkatharití, iiro poipiyiniri jiroka kaaripironkantsi”. Ithonkakiro jiñaawaitaki jiroka, makoryaanaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ikanta Saulo jaminakotakiri Esteban itsitokaitziri, ikantanaki irirori: “Ariwí, kamaki Esteban”. Aripaiti jitaitanakawo ipatzimaminthataitziri kimisantzinkariiti Jerusalén-ki. Irootaki ishiyantanakari maawoni Judea-ki, ikinanaki iijatzi nampitsiki Samaria. Iiniromaita isaikanaki Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ikanta pinkathatasorintsitaniri ikitatakiri Esteban, antawoiti jiraakowaitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iriima Saulo ikowanaki irirori japirotirimi kimisantanaatsiri. Jiyaatashitapiintakiri ipankoki, jinoshikayitziri shirampari, tsinani, maawoni. Jomontyaakaantayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ikanta maawoni shiyayitanainchari, jatayitanaki pashiniki nampitsi. Ikinkithatakoyitakiro Kamiithari Ñaantsi janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ikanta Felipe, iriitaki shiyanainchari iijatzi, ariitaka nampitsiki Samaria. Ikinkithatakotapaakiri Cristo. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ari japatotapaaka maawoni atziripaini, jowakimpitatakawo ikinkithatziri Felipe, tima jiñaayitakiro itasonkawintantapaaki iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Joshinchaayitai ojyiki atziri piyarishiritatsiri. Antawo ikaimayitzi piyari ishiyayita. Ojyiki atziri kisopookiwitachari, kaari kamiithawitachani iitzi, joshinchaayitairi maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irootaki ikimoshiritantakari maawoni nampitawori janta nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Iro kantacha tzimatsi janta iitachari Simón. Jyiripiyaari jinawitaka pairani. Jamatawitaki ojyiki atziri nampitawori Samaria-ki. Owanaa ikantakaapirowaitaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jawintaapiintawitakari atziriiti, jiwariiti, maawoni, ikantayitzi: “Thami ankimisantiri, tima jirika Simón jimatakiro jiñaawiyatari Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ikimisantaitziri Simón maawoni ikantayitziri. Ojyiki osarintsi jiyokitziiwintaitakiri jantawiyarinkakiini. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iro kantacha jariitapaaka Felipe, jiyotaantapaakiro Kamiithari Ñaantsi kinkithatakotziriri Jesucristo, kinkithatakotziri iijatzi Pawa impinkathariwintantai. Jowiinkaayitanaka shirampariiti, iijatzi tsinanipaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ari jimatsitanakawo iijatzi Simón irirori, ikimisantawitanaa, owiinkaawitaka iijatzi. Joyaatyaatani jowanakiri Felipe, jiñaakiri itasonkawintantayitzi. Iyokitzi jowakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ikanta Otyaantapiroriiti saikatsiri Jerusalén-ki, ikimakotakiri Samaria-jatzi ikimisantayitairo iñaani Pawa. Irootaki jotyaantantakariri Pedro itsipatanakari Juan. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ikanta jariitaiyakani Samaria-ki, jamanamanaatakotapaakari kimisantzinkariiti, inampishiritantyaariri Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Apa ipairyaakiri Awinkathariti Jesús jowiinkaayiitakiri. Tikiraamintha inampishiritantyaari Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ikanta Pedro itsipatakari Juan, jotzimikapatziitotantakari jako apaanipaini. Ari inampishiritantanakari Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jiñaakiri Simón jantakiri Otyaantapirori, jotzimikapatziitotantakari jako atziri, jinampishiritantaari Tasorintsinkantsi, ipinawitanakari irirori Otyaantapirori, ");
INSERT INTO cpcNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ikantanakiri: “Jirika kiriiki, pimpina naaka pishintsinka, nonkimitantimiri iiroka, nonampishiritakaantyaariri Tasorintsinkantsi nojyininka, notzimikapatziitotantyaari nako”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ari jakanakiri Pedro, ikantziri: “¡Ari pintsipatawiitaiyaari piiriikiti pimpiyashitaiya! ¿Piñaajaantakima ari pamanantantatyaawo piiriikiti ipashitantari Pawa? ");
INSERT INTO cpcNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Iiro pimamachiitziro pinkimitakotyaanawo naaka, jiñaakimi Pawa tii pitampatzikashiritzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Powajyaantairo piyaaripironka, pinkowakotairi Pawa, añaawakiro aririka impiyakotaimiro pikinkishiriwitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Niyotakimi naaka, ojyiki pikisashiriwaitaka. Ari pikantapiintatya pikaaripiroshiriwaitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ipoña jakanaki Simón, ikantanaki: “Pamanakotaina Pinkathariki, iiro awijyimotantana pikantakinari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ikanta Pedro itsipatakari Juan, ithonkakiro ikinkithatakotakiri Pawa. Ipoña ikinayitanaki pashiniki nampitsi okaatzi saikatsiri Samaria-ki, ikinkithatakiro Kamiithari Ñaantsi. Ari ipiyaiyaani Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ikanta imaninkariti Pawa, jiñaanatakiri Felipe, ikantziri: “Piyaati nampitsiki iitachari Gaza, pimpampithatanakiro aatsi poñaachari Jerusalén-ki irojatzi janta”. Tima jiroka aatsi irootaki kinachari otzishimashiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jataki Felipe. Okanta niyanki aatsi, itonkiyotakari Etiopía-jatzi. Jiwari jinatzi. Iriitaki kimpoyiiri kiriiki janta Etiopía-ki opinkathariwintantzi tsinani iitachari Candace. Ipoñagaatyaawo irirori Jerusalén-ki ipinkathatziri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Iro jiyaatairo irirori inampiki, isaikantakawo ishiyakominto, jiñaanatziro josankinari Kamantantaniri Isaías-ni. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jiñaanashiritanakiri Tasorintsinkantsi jirika Felipe, ikantziri: “Piyaati, pontsitotyaari shiyakotainchari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ikanta ipokashitapaakiri Felipe, ikimatziiri Etiopía-jatzi jiñaanatziro josankinari Isaías-ni. Ari ikantziri: “¿Pikimathatziro piñaanatziri?” ");
INSERT INTO cpcNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ari ikantzi Etiopía-jatzi: “¿Tsika onkini nonkimathatiro, tii itzimi iitya yotainawoni? Pimpoki iiroka, pintsipatina”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jiroka Osankinarintsi jiñaanatziri: Ikimitakaitakiri jaayiitziri oijya jowamaitiri. Ikimitakari oijya tii ikaimawaitzi jamiiyiitiri, Ari ikimitakari iijatzi irirori, mairi ikantaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Tsinampashiri ikantakaitakari, tii otampatzikatzi okaatzi ikantakoitakiriri. Ari jowamaitakiri, tiimaita itzimi jowaiyanipaini irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ikanta jirika jiwari Etiopía-jatzi, josampitanakiri Felipe: “Pinkantina. ¿Iitaka ikinkithatakotziri Kamantantaniri? ¿Irijatzima kinkithatakotacha? ¿Pashinima ikinkithatakotzi?” ");
INSERT INTO cpcNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ari jitanakawo Felipe ikinkithatakaanakiri josankinari Isaías-ni, ikinkithatakotanakiniri Kamiithari Ñaantsi kinkithatakotziriri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Okanta osamaniityaaki, ikinimotapaakiro jiñaa, ikantzi Etiopía-jatzi: “Jiroka jiñaa. ¿Iiroma okantzi nowiinkaatya naaka?” ");
INSERT INTO cpcNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jakanakiri Felipe, ikantziri: “Pinkimisantapirotanakirika, ari onkantaki”. Ikantzi Etiopía-jatzi: “Nokimisantzi, iriitaki Jesucristo Itomi Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ari jowatziyakaantapaakiro ishiyakominto Etiopía-jatzi. Ayiitanaki apitiroiti, jatanaki jiñaaki. Ari jowiinkaatakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ikanta itonkaanai jiñaaki, jaanairi Felipe Tasorintsinkantsi. Jirika jiwari Etiopía-jatzi, tii jiñaanairi tsika ikinanaki. Iro kantacha jirika atziri kimoshiri ikanta jiyaatai irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Iriima Felipe jiñaashitaawo isaikapai Azoto-ki. Ipoña jawisaki pashiniki nampitsi ikamantantziro Kamiithari Ñaantsi, irojatzi jariitantaari Cesarea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ikanta Saulo, tii jowajyaantziro jasaryiimayitari jowamairi jiyotaani Pinkathari. Irootaki jiyaatashitantakariri ijiwari Ompiratasorintsitaniri Judá-mirinka, ");
INSERT INTO cpcNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ikantapaakiri: “Posankinatiniri Ompiratasorintsitaari saikatsiri nampitsiki Damasco, pinkantiri: ‘Pishinitiri Saulo jaayitiri tsipatanaariri jiitaitziri “Aatsi”. Intyaayiti japatoyiitapiinta, joojoyitiri shirampari iijatzi tsinani, jamakiri jaka Jerusalén-ki’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iro jariitzimataka nampitsiki Damasco, ari jomapokakiri morikanaintsiri inkitiki, joorintapaaka ikatziyaka Saulo. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Tyaanaki Saulo. Ikimatzi ñaantsi inkitiki, ikantaitzi: “¡Saulo! ¡Saulo! ¿Iitama pipatzimaminthatantanari?” ");
INSERT INTO cpcNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jakanaki Saulo, ikantzi: “¿Iitama iiroka Pinkathari?” Ari ikantaitanakiri: “Naakataki Jesús pipatzimaminthatakiri. Iirokataki owasankitaawaitacha apaniroini, okimiwaitakawo pimpaikatyiiyaawomi thoyimpithowari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ikanta Saulo, ompitawaitanaka ithaawanaki, ikantanaki: “Pinkathari, iita pikowiri nantairi naaka”. Ari ikantanakiri Awinkathariti: “Pinkatziyi, piyaati nampitsiki. Ari inkamantaitimiro oitya pantiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Owanaa ithaawanaki ikaatzi oyaatakiriri Saulo, tima ikimawakiro iijatzi irirori ñaantsi, tii jiñiimaitari ñaawaitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ipoña ikatziyawitanaa Saulo. Ikowawita jokiryiima, tii okantzi jaminanai. Irootaki ikathatantanaariri itsipayitakari, jaanakiri nampitsiki Damasco. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ari isaikakiri janta okaatzi mawa kitiijyiri, tii okantzi jaminawaitai, tii jowaiya, tii jirai iijatzi imiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Okanta janta Damasco-ki, ari isaiki apaani yotaari jiita Ananías. Iriitaki jiñaanatakiri Awinkathariti imishiniki, ikantziri: “¡Ananías!” Ari jakanakiri irirori: “¿Iitaka, Pinkathari? Jaka nosaiki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ikantziri: “Piyaati janta aatsiki jiitaitziri ‘Tampatzikari’. Ari osaiki ipanko iitachari Judas, posampikowintiri shirampari jiita Saulo, iri poñaachari nampitsiki Tarso. Ari isaikiri irirori jamanamanaata. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Nomishitakaakiri irirori. Jiñaakimi pityaashitapaakiri, potzimikapatziitotantakari pako, irojatzi jaminawaitantanaari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ikanta ikimawaki Ananías, ikantanaki: “Pinkathari, ojyiki nokimi ikinkithatakoitziri jirika shirampari, kowiinka okanta jantayitakiri Jerusalén-ki jowasankitaayitziri pikitishiritakaani”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","“Iro ipokantari iroñaaka jaka, tima jotyaantatziiri ijiwari Ompiratasorintsitaniri jaayiitiri pairyiimiri jawintaashiritaimi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ikantzi Pinkathari: “Piyaati. Tima jirika shirampari iriitaki niyoshiitakiri naaka inkinkithatakotaina maawoni nampitsiki. Inkinkithatakairi Israel-mirinkaiti ijyininkatari irirori, iijatzi pashinijatzi atziri kaari ijyininkata, iijatzi iwinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ari noñaagakiri iijatzi tsika onkaati inkimaatsiwintina naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ipoña jiyaataki Ananías pankotsiki isaikaki Saulo. Tyaapaaki, jotzimikapatziitotantapaakari jako. Ikantziri: “Iyiki, jotyaantakina Awinkathariti Jesús, oñaagakimiri aatsiki pikinapaaki pairani. Iro jotyaantantanari pokiryaantaiyaari, inampishiritantaimiri iijatzi Tasorintsinkantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ari oparyaanaki jokiki kimiwitariri shimapintaki, aminanai kamiitha. Ipoña ikatziyanaka, jatanaki jowiinkaataitiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ari jowawaitanaa, irojatzi ishintsitantaari kamiitha. Kapichi isaikimowaitapaintziri kimisantzinkariiti nampitawori Damasco-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ari jitanakawo Saulo ikinkithatakaantanaki japatotapiintayita Judá-mirinkaiti, ikantzi: “Iriitaki Itomi Pawa iitachari Jesús”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iyokitzi jowanakiri ikaatzi kimiriri, ikantawakaa: “¿Tiima iriitaki jirika kisaniintziriri Jerusalén-ki ikaatzi pairyiiriri Jesús? ¿Tiima irijatzi pokaintsiri jayiri kimisantzinkari ijiwariki Ompiratasorintsitaari?” ");
INSERT INTO cpcNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Iro kantacha Saulo iikiro ishintsitatzi ikinkithatakaantzi tikaatsi inthaawantanatya. Tii jiyotzi iita inkantayitiri Judá-mirinkaiti nampitawori Damasco-ki, ikimiri Saulo ikantzi: “Jirikaranki Jesús Cristo jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Okanta awisanaki ojyiki kitiijyiri, ikantawakaanaka Judá-mirinkaiti: “Thami antsitokiri Saulo”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Tima kitiijyiriki iijatzi tsiniripaiti joyaawintakari ishitowapiintaitzi inampiki, inkini intsitokiri. Iro kantacha Saulo jiyotaki ikowaitatzi jowamaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ikanta kimisantzinkariiti, jotitakiri antawoki kantziri, jowayiitakotairi tsiniripaiti jikokiroki jotantotaitziro nampitsi. Ari okanta ishiyantakari Saulo. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ikanta jariitaa Saulo Jerusalén-ki, ikowawitaka intsipatapaiyaarimi jiyotaani Pinkathari. Iro kantacha owanaa ithaawantakari, jiñaajaantzi tii ikimisantapirotai irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Iro kantacha tzimatsi kimisantzinkari iitachari Bernabé, jaapatziyanakari Saulo, jataki joñaagantairi ipiyota Otyaantapirori. Ikantapaakiri: “Jirika Saulo jiñagairi Awinkathariti janta aatsiki jatachari Damasco-ki, ikinkithawaitakaakiri. Ari jitanaawori Saulo janta nampitsiki Damasco ikinkithatakotanairi Jesús. Tikaatsi inthaawantanatya”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ari okantari isaikantapaari Saulo Jerusalén-ki, itsipayitapaari Otyaantapirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ikinkithatakotakiro iwairo Pinkathari Jesús, tikaatsi inthaawantya. Ikinkithatakaayitziri Judá-mirinkaiti Grecia-paantiri. Iro kantacha ikowaki intsitokiri jirikapaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ikanta jiyotaiyakini kimisantzinkariiti, jaanakiri Saulo janta Cesarea-ki. Jotyaantairi Tarso-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ikanta kimisantzinkariiti, nampiyitawori Judea-ki, Galilea-ki, Samaria-ki, kamiitha ikanta isaikawaitaiyini, iikiro jantakishiripirotanakitzi, pinkatha jowapiintanakiri Pinkathari, jaamaakowintari Tasorintsinkantsi. Iikiro jiyaatatzi ijyikipirotanaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ikanta jariitantayitaka Pedro nampitsiitiki, irojatzi jariitantaka Lida-ki inampiyitawo oitishiritaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ari jiñaapaakiri iitachari Eneas, kisopookiri jinatzi, tzimakotaki 8 osarintsi jomaryaawaitaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jiñaanatapaakiri, ikantziri: “¡Eneas, joshinchagaimi Jesucristo. Pinkatziyi, paanairo pomaryaaminto!” Ari ikatziyanakari Eneas. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ikaatzi nampitawori Lida-ki iijatzi Sarón-ki, jiñaayitairi ikatziyawaita Eneas, iro ikimisantantanakariri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Okanta nampitsiki Jope, tzimatsi apaani yotaawo oita Tabita, jiñaaniki Grecia-paantiri jiitaitziro “Dorcas”. Jiroka tsinani itakotantapiintaka, onishironkatantapiintaki iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Okanta apaani kitiijyiri, omantsiyataki Dorcas, kamaki. Jaayiitakiro, ikaawoshiitakiro, jomaryaitapaintziro jinoki opankoki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Okanta janta Jope-ki tii intainapirotzi osaiki nampitsi Lida, tsika jariitaka Pedro. Ikanta ikimaiyakini yotaariiti ari isaikiri Pedro janta, jotyaantaki apiti shirampari inkamantiri, inkantiri: “Pimpokanaki thaankipiroini Jope-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jatanaki Pedro. Ikanta jariitapaaka janta, jaayiitanakiri jinoki tsika jomaryaitakiro. Opiyowintapaakari maawoni kamatsiri oimi, iragaiyapaakani, oñaagapaakiri kithaarintsi oshirikapiintani Dorcas. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ipoña Pedro jomishitowakiro maawoni, ari jotziirowanaka, amanamanaatanaka. Ipoña ipithokashitanaawo kaminkawo, ikantzi: “¡Tabita, pintzinai!” Ari okiryaanai iroori, oñaatziiri Pedro, isaikaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Iri thawakotanaintsiri Pedro, jowatziyakiro. Ipoña ikaimayitakiro kamayitatsiri oimi iijatzi ikaatzi oitishiritaari, jiñaayitakiro añagai. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ikanta ikimakoitakiro nampitsiki Jope, ojyiki kimisantanakiriri Pinkathari. ");
INSERT INTO cpcNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ojyiki kitiijyiri isaikawaitanaki Pedro nampitsiki, iri isaikimotaki shirampari iitachari Simón “Mishinantsipakori”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tzimatsi Cesarea-ki shirampari iitachari Cornelio, iriitaki ijiwariti owayiriiti Roma-jatzi jiitaitziri “Italia-jatziiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jirika shirampari pinkathatasorintsiwaitaniri jinatzi, ari ikaatziri ijyininkamirinkaiti ipinkathatziri Pawa. Ipapiintziri ashironkainkari ojyiki iiriikiti okantawitaka tii ijyininkatari. Jamanamanaatapiintakari Pawa irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Okanta apaani kitiijyiri, itainkanaki ooryaatsiri, ari jomapokakiri imaninkariti Pawa ityaashitapaakiri isaikaki, jiñaawakiri koñaawoini, ikantapaakiri: “¡Cornelio!” ");
INSERT INTO cpcNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Iyokitzi ikantanaka Cornelio, ithaawankakiini josampitanakiri, ikantziri: “¿Pinkathari, iitama pikowakotanari?” Ikantanakiri maninkari: “Ikimakimiro Pawa pamanamanaatani, jiñaakimi pinishironkatantapiintaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Potyaanti pompiratani nampitsiki Jope jamantyaariri Simón, jiitaitziri iijatzi Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ari jimayimotziri ijyamitzi jiitaitziri Simón, ‘Mishinantsipakori’ saikathapiyaatzirori inkaari. Iri kamantimini oita pantairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ikanta ishitowanai maninkari, ikaimaki Cornelio apiti jotzikatani. Ikaimaki iijatzi jowayiriti, jawintaari irirori, pinkathatasorintsiwaitaniri jinayitatzi jirikaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ikamantakiri okaatzi ikantaitakiriri. Jotyaantakiri Jope-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Okanta okitiijyitamanai, jiwiyaaka tampatzika ooryaatsiri, irootaintsi jariitzimataiyaani Jope-ki jotyaantakiri. Ari jatiitanaki irirori Pedro jamanamanaatya jinoki pankotsipankaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ikimaminthatakiro itajyi, ikowaki joya, iro kantacha owakiraa jonkotsiyiitzi joyaari, ari jiñaawiyatakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jiñaakiro ashitaryaanaka inkiti, jowayiitaitakiro kimiwitawori antawo manthakintsimaanka, ithatoyiitakiro opatziki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Okanta janta manthakintsimaankaki tzimatsi ojyiki kantashiwaitachari piratsi, ikaatzi konthayitatsiri kipatsiki, iijatzi tsimiripaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ikimatzi ñaanatakiriri, ikantaitziri: “Pedro, pintzinai, powamairi jirikapaini, poyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ari jakanaki Pedro: “Iiro Pinkatharí. Tii nowapiintari naaka jirikapaini ipinkaitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Japiitaitanakiri Pedro jiñaanaitziri, ikantaitziri: “Tima jirikapaini ishinitaantziri Pawa, iiro piitashiwaitari iiroka ‘Ipinkaitziri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Mawajatzi apiitaka jiroka. Ipoñaashitaka jaayiitanairo manthakintsimaanka inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Antawo okantzimoshiriwaitanakari Pedro, ikinkishiriwaita oita ojyakaawintachari okaatzi jiñaakiri. Ari jariitaiyapaakani jotyaantani Cornelio, josampikowintapaakiro ipanko Simón. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Jariitapaakawo pankotsi, ikaimaiyapaakini shintsiini josampitantapaaki, ikantzi: “¿Ari jimayiri jaka Simón, jiitaitziri iijatzi Pedro?” ");
INSERT INTO cpcNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ikinkishiritakominthaitziro Pedro jiñaakiri, jiñaanashiritakiri Tasorintsinkantsi, ikantziri: “Pamini, ariitapaaka mawa shirampari aminaminatzimiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pinkatziyi, payiiti. Iiro pikisoshiriwaitzi, pintsipatyaari, tima naakataki otyaantakiriri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ari jayiitapaaki Pedro, ikantapaakiri shirampariiti: “Naakataki paminaminatzi. ¿Iita pipokantari?” ");
INSERT INTO cpcNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ikantaiyanakini irirori: “Nopoki jotyaantana Cornelio, ijiwari owayiriiti. Tampatzikashiriri jinatzi, pinkathatasorintsiwaitaniri jinatzi, iri jaapatziyapiintari pijyininkapaini Judá-mirinka. Tima chapinki ipokashitakiri imaninkariti Pawa, ikantakiri: ‘Pinkaimakaantiri Pedro, impokantyaari pipankoki, ari pinkimiro inkamantimiri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ikanta Pedro ityaakaanakiri pankotsiki, ari jimagaiyapaakini. Okanta okitiijyitamanai, jataki Pedro joyaatanakiri pokashitakiriri, ari itsipatanakari iijatzi Jope-jatzi, “iyikiiti” jinatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Okanta pashini kitiijyiri ariitaiyakani Cesarea-ki. Ari joyaawintakari Cornelio itsipayitakari ijyininkamirinkaiti, iijatzi jaapatziyaminthatani ikaimayitakiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jariitapaaka Pedro pankotsiki, ishitowashitanakiri Cornelio, jotziirowashitawakari, impinkathatawakirimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Iro kantacha Pedro jowatziyakiri, ikantziri: “Pinkatziyi, atziri ninatzi iijatzi naaka, ari nokimitzimi iiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ikanta jiñaanatziri Cornelio, ityaakaapaakiri, jiñaapaakitzi ojyiki atziri apatotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ikantanaki Pedro: “Piyotaiyini iiroka, naakaiti Judá-mirinkaiti tii ishinitaitana nontsipatimi iirokaiti kaari nojyininkata, tii okantaajaitzi nontyaapankotimi. Iro kantacha owakiraini jiyotaakina Pawa, tii okantzi nonkantayitimi: ‘Nowinkani pinatzi’. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Irootaki kaari nojyinkaantanaka nopokanaki pikaimakaantakina. Iroñaaka nokowi niyoti iita pikaimakaantantanari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ikantanaki Cornelio: “Chapinki, aritaki tzimaki 4 kitiijyiri, ari ikaatajaantaki iroñaaka ooryaatsiri, ithatanaka. Nosaiki naaka jaka nopankoki notziwintawaita, namanamanaata otsiniriityaaki, ari ikoñaatzimotakina shirampari, shipakiryaa okantapaaka iithaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ikantapaakina: ‘Cornelio, ikimakimi Pawa pamanamanaatari, ikinkishiritakiro pinishironkatantapiintaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Potyaanti nampitsiki Jope amirini Simón, jiitaitziri iijatzi Pedro. Ari jimayimotziri ijyamitzi jiitaitziri Simón, mishinantsipakori nampitawori inkaarithapiyaaki’. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ari notyaantakiri thaankipiroitiini ñaakitimini, pimatakiro pipokanaki thaankipiroitiini. Jirika ipiyotakina Pawa. Incha pinkantinawo ikantakimiri Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ikantanaki Pedro: “Ari niyotziri iroñaaka imapirotatya Pawa tii jimanintanitziri atziriiti, ");
INSERT INTO cpcNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","jaapatziyayitari pinkathatanairiri, tampatzikashiritatsiri, okantawitaka tsikarika inampiyitawo, kaari nojyininkawita. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Tima jiroka Ñaantsi kinkithatakotziriri Jesucristo, jatakotaintsiri nojyininkaki Israel-mirinkaiti, iriitaki Pawa kantakaawori nokinkithatakotantaariri. Iriitaki pinkathariwintaini maawoni, iriitaki saikakaayitaini iijatzi kamiitha. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Piyotaiyini iirokaiti okaatzi awisaintsiri noipatsitiki. Tima pikimakowintakiro ikinkithatakotakiri pairani Juan-ni okantakota owiinkaataantsi. Irojatzi ipoñaantanakari Galilea-ki, ");
INSERT INTO cpcNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","jiñaitakiri Jesús Nazaret-jatzi. Iri Pawa ipakiri ishintsinka iijatzi Itasorinka. Ikinayitanaki irirori inishironkatantayitzi, jowawisaakoyitaki ojyiki piyarishiritatsiri. Iro jimatantakawori jiroka tima Pawa tsipatakariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Naakayitaki ñaayitajaantakiri maawoni jantayitakiri Jesús janta Judea-ki ipoña Jerusalén-ki. Ipoñaashitaka jowamaitakiri, ipaikakoitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iro kantacha imonkaataka mawa kitiijyiri jañaakagairi Pawa, ikantakaakawo irirori noñaayitairi naakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tii joñaagapanaatari maawoni atziri, apa naakaiti, jiyoshiitakiri pairani Pawa jiñaayitairi. Aritaki jañagai, notsipatawaari nowaiyani iijatzi nirawaitaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iriitaki otyaantaiyakinarini nonkamantayitairi atziriiti, nonkantairi: ‘Iri Jesús jowakiri Pawa jiyakawintairi maawoni añaayitatsiri, ikaatzi kamayitaintsiri iijatzi’. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Irijatzi Jesús ikinkithatakotsitakari pairani Kamantantaniriiti, ikantaki: ‘Inkaati kimisantairini jirika impairyaayitairi, aritaki impiyakotainiri iyaaripironka’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jiñaawaiminthaitzi Pedro, ari inampishiritantapaakari Tasorintsinkantsi maawoni kimisantakiriri ikinkithatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iyokitzi jowanakiri ikaatzi oyaatakiriri Pedro, jiñaakiro inampishiriyitantapaakari Tasorintsinkantsi kaari ijyininkata, okimiwaitakawo isakopiroitatyiinirimi, ");
INSERT INTO cpcNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ikimaiyakirini jiñaawaitantanakawo pashiniyitatsiri ñaantsi, ithaamintanakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ikantanaki Pedro: “¿Kantatsima ompitapithatyaari jowiinkayitya jirikaiti atziri, kimiyitanakairi aakaiti inampishiritantyaari Tasorintsinkantsi?” ");
INSERT INTO cpcNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ari jotyaantaki jowiinkaayiitiri jirikaiti impairyaitiri Jesucristo. Ipoñaashitaka jirikaiti ikantanakiri Pedro: “Pisaikimowaitanakina”. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ipoña ikimaiyakini pashini Otyaantapiroriiti iijatzi iyikiiti nampitawori Judea-ki, ikantaitzi: “Ikimayitairo Iñaani Pawa kaari ajyininkata, ikimisantayitai irirori”. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iro jariiwitaa Pedro Jerusalén-ki, jiñaanaminthatawairi Judá-mirinka kimisantayitaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ikantawairi: “¿Iitama pariitantariri kaari ajyininkata, patyooyitakiri iijatzi?” ");
INSERT INTO cpcNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ari ikamantanakiri Pedro tsika okanta opoñaantakari. Ikantanakiri: ");
INSERT INTO cpcNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Nosaiki naaka nampitsiki Jope, namanamanaaminthata, ari noñaawiyatakari. Noñaaki kimitawitakawori antawoiti manthakintsimaanka, ithatoyiitakiro opatziki, jowayiitakoitakiro okinapaakiro inkitiki irojatzi tsika nosaikaki naaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ari naminapirotanakiro, noñaaki ojyiki katsimari piratsi, noñaaki ikaatzi kamathayitatsiri kipatsiki, ipoña tsimiripaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ipoña nokimaki ñaanatakinari, ikantana: ‘Pedro, pinkatziyi, powamairi jirikapaini, poyaari’. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ari nakanaki: ‘Iiro Pinkatharí, tima tii namonkomachiitziri naaka jirikapaini ipinkaitziri’. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Japiitaitanakina jiñaanaitana, ikantaitzi: ‘Tima jirikapaini ishinitaantziri Pawa, iiro piitashiwaitari “Ipinkaitziri”.’ ");
INSERT INTO cpcNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Mawajatzi apiitaka jiroka. Ipoña jaayiitanairo inkitiki okaatzi noñaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ari jariitaiyapaakani mawa shirampari aminaminatanari, jotyaantaitakiri ipoñaakawo Cesarea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jiñaanashiritanakina Tasorintsinkantsi, ikantakina: ‘Poyaatanakiri jirikaiti, iiro pikisoshiriwaitanaki’. Irootaki nimatakiri. Jirika 6 iyikiiti notsipatanakari. Iri notsipatakari notyaapankotakiri shirampari kaari ajyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ikamantawakina, ikantana: ‘Chapinki, noñaaki maninkari ikatziyapaaka jaka nopankoki, ikantakina: “Potyaanti jatatsini nampitsiki Jope onkantya jamantyaariri Simón, jiitaitziri iijatzi Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Iriitaki kamantimironi tsika pinkantya pawisakoshiritantaiyaari, pintsipataiyaari maawoni pijyininkamirinkaiti”.’ ");
INSERT INTO cpcNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ikanta nokinkithawaitakaapaakiri, ari omapokashitakinari inampishiritantapaakari Tasorintsinkantsi iriroriiti, iroowaitaki inampishiritantakairi aakaiti owakiraini. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ari nokinkishiritanakiro ikantakiri pairani Awinkathariti: ‘Imapiro Juan jowiinkaatantawo jiñaa, iro kantacha ari piñaayitakiro iirokaiti inampishiritantaimi Tasorintsinkantsi kimiwaitakimi jowiinkaatantatyiimirimi’. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iriitajaantaki Pawa nishironkatakiriri iijatzi iriroriiti ikimitaayitai aakaiti akimisantairi Pinkathari Jesucristo. ¿Iitama nonkowantyaari naaka nomaamanitiri Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ikanta ikimaiyawakini iyikiiti nampitawori Jerusalén-ki, tikaatsi inkantaiyanakini. Ithaamintaiyanakarini Pawa, ikantaiyanakini: “¡Ari okantari! ¡Inishironkatairi Pawa kaari ajyininkata! ¡Kantatsi jowajyaantairo iyaaripironka, onkantya jañaashiritantaiyaari!” ");
INSERT INTO cpcNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Aritaki jowamaitakiri Esteban, jitaitantanakawori ipatzimaminthaitziri kimisantzinkariiti. Iro ipoñaantanakari ishiyayitanaka kimisantzinkariiti Fenicia-ki, Chipre-ki, Antioquía-ki. Ari ikinkithatakaayitakiri Judá-mirinkaiti tsika okantakota Kamiithari Ñaantsi, tiimaita ikinkithatakairi kaari ijyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Iro kantzimaitachari, ari jariitaiyakani Antioquía-ki, kimisantaatsiri poñaachari Chipre-ki ipoña Cirene-ki. Ikinkithatakaapaakiri iijatzi kaari ijyininkata, ikinkithatakotakiniri Kamiithari Ñaantsi tsika ikantakota Jesús, Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Okantakaapirowaitakari ishintsinka Awinkathariti jirikaiti, jowajyaantakaakiri pashinijatzi atziri jamitashiwaiwitakari. Ojyiki kimisantanairiri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ikanta kimisantanaatsiri Jerusalén-ki, ikimakotakiri, jotyaantakiri Bernabé Antioquía-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ikanta jariitaka Bernabé, jiñaapaakiri tsika ikanta Pawa jinishironkatairi jirikaiti, antawoiti ikimoshiritapaaki. Ikaminaapaakiri maawoni joisokiroshiritantyaariri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tima jirika Bernabé nishironkataniri jinatzi, jawintaashiripirotari Awinkathariti, inampishiripirowaitantari Tasorintsinkantsi. Irootaki ijyikipirotantanakari kimisantanairiri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ipoña Bernabé, jataki Tarso-ki jiñiiri Saulo. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ikanta jiñaapairi, jamairi Antioquía-ki. Ari isaikimowaitakiri jiyotaaniiti apaani osarintsi, jiyotaayitaki ojyiki atziri. Ari jitanakawo Antioquía-ki jiitaitziri “Cristo-wiriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Okanta apaani kitiijyiri, jariitaiyakani Antioquía-ki kamantantaniriiti ipoñaanakawo Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ipoñaashitaka, apaani kamantantaniri iitachari Agabo, ikatziyanaka japatotaiyani, ikantanaki: “Ari jiñaitaki antawoiti tajyitsi maawoni nampitsiki”. Iri Tasorintsinkantsi ñaanashiritakiriri jiyotantakawori. Irootaki monkaatainchari ipinkathariwintantari Claudio. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Irootaki ikinkishiritantaiyakarini Antioquía-jatzi inishironkatyaari Judea-jatzi jotyaantiniri iyikiiti ikaatzi jinintakairiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iro jimataiyakirini, jowaitakiri Bernabé itsipatakari Saulo iri aminakaantironi. Jotyaantakiniri antaripiroriiti janta Judea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ikanta pinkathari Herodes ipatzimaminthatakiri kimisantzinkari. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ikantakaantaki inthatzinkaitiri Jacobo, iririntzi Juan. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ikanta jiñaakiro Herodes iwitsikimotakari kamiitha Judá-mirinkaiti, joirikakaantakiri iijatzi Pedro. Ari awisayitakiri jiroka joimoshirinkayiita jowantapiintaitawori tantaponka. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ari joirikakaantakiri Pedro, jomontyaakaantakiri. Jowayitaki ikaatzi 16 owayiriiti aamaakowintyaarini. Ikinkishiriwitaka Herodes joñaagantirimi atziriitiki jaminakotirimi ikinakaashitakari, onkaatakirika joimoshirinkaitawo kitiijyiri Anankoryaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jomontyaaminthaitziri Pedro, amanamanaataiyachani kimisantzinkariiti japatowintakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Okanta imonkaatzimatapaaka jaantyaariri Herodes jirika Pedro joñaagantiri atziriitiki. Jimayi Pedro tsiniripaiti josatikakiri apiti owayiri, joojoitantakari apiti ashirotha. Saikayitatsi pashini owayiriiti ityaapiintaitzi jaamaakowintari. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ari jomapokashitakari ipokaki imaninkariti Awinkathariti, ikitainkatakotapaakiri. Jotsinkamirikitapaakiri Pedro, jowakiryaakiri, ikantziri: “¡Pinkatziyi!” Oparyaashiwaitanaka ashirotha joojoitantakariri jakoki. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Japiitakiri maninkari, ikantziri: “Pinkithaatya, pi-zapato-tya”. Ari ikantakiro Pedro. Iikiro ikantatzi maninkari: “Pintyaantyaawo pipiwiryaakominto, poyaatina”. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Shitowanaki Pedro joyaatanakiri maninkari. Tii jiyotzi imapirorika okaatzi jantziri maninkari. Okimitzimowaitakari jiñaawiyatatyaarimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ikanta jawisanaki apaani aamaakowintariri, jawisanakiri pashini. Iro ishitowimati, jariitapaakawo ashirotatsiri ashitakowontsi, ishiryaashiwaitanaka apaniroini. Shitowaiyanakini. Ikanta janiitaki, iro itaponiintanakityaami, ari jookanairi maninkari apaniroini. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ari ikinkishiritanaka Pedro, ikantanaki: “Ari niyotzi imapirotatya jotyaantakiri Pinkathari imaninkariti, jowawisaakowintaana Herodes-ki, jowawisaakowintaana tsika inkantawaitinami Judá-mirinkaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ikanta jiyotanakiro Pedro jiroka, jatanaki opankoki María, inaanati Juan, jiitaitziri iijatzi Marcos, tsika japatotaita jamanamanaataita. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kaimapaaki ityaapiintaitzi. Okanta mainawo iitachari Rode, jatanaki aminiri iitakarika. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ari iyopaantitawairi Pedro jinatzi, antawoiti okimoshiritanaki, tii ashitaryaanakiniri intyaantapaatyaari, opiyitsitanaka inthomainta okamantantzi, okantapaaki: “Pedro jinatzi kaimatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ari ikantaitawakiro: “¡Tii pishinkiwintatya!” Iikiro oshintsitatzi iroori, okantzi: “Imapirotatya”. Ikantaiyini irirori: “Aamashitya imaninkariti Pedro”. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Iikiro ikaimatzi Pedro. Ikanta jashitaryaitakiniri, jiñaatziiri Pedro, jiyokitziitaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ari jowaankanakiro jako Pedro jimairitantaityaari. Ipoña ikinkithatakotanakiro tsika ikantakiro Awinkathariti jomishitowantaariri. Iikiro ikantanakitzi Pedro: “Pinkamantiri Jacobo iijatzi pashini iyikiiti”. Ari ishitowanai, jatanaki pashiniki nampitsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Okanta okitiijyitamanai, ojyiki okantzimoshiriwaitakari aamaakowintariri, tima tii jiyotaiyini tsika ikinaki Pedro. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ikantakaantaki Herodes jaminaminayiitairi, tiimaita jiñiitairi. Irootaki jookoitantanakariri aamaakowintawitakariri, jowamaakaantaitakiri. Ikanta awisaki jiroka, ari ishitowairi Herodes Judea-ki, jataki inampitapaintyaawo Cesarea-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ari ikantapiintatya Herodes imaamaniwaitakiri nampitawori Tiro-ki iijatzi Sidón-ki. Ikanta ikinkishiritaiyakani imaamanitani jaapatziyaiyaari, tima ari jiyomparitapiintaiyani. Jotyaantaitaki jatashitirini Herodes jaapatziyaiyaari. Ikanta saikapankotziriri Herodes, jawintaapirotani, iitachari Blasto, jaawakiri kamiitha pokashitakiriri. Ikantakowintakiri Herodes-ki tsikapaiti inkinkithatakaantyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Monkaatapaaka kitiijyiri ikaimakaantakiri Herodes inkinkithatakairi. Ari ityaantanakawo owaniinkatachari iithaari ikinkithatakaantapiintantari, saikapaaki isaikamintoki japatotaiyakani, kinkithatanaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ari ikaimotaiyirini atziriiti, ikantzi: “¡Jirinta ñaawaitaintsiri, Pawa jinatzi, kaari atziri!” ");
INSERT INTO cpcNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Tii okantzimotari Herodes ikimitakaantaitakari Pawa ithaamintaitakari. Irootaki omapokantanakari jomantsiyaakiri imaninkariti Awinkathariti, ikiniwaitanaki, kamaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Iro kantacha, iikiro iyaatakotanakitzi iñaani Awinkathariti, iikiro ijyikipirotanakitzi kimisantzinkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Ikanta Bernabé ipoña Saulo jimonkaatakiro jantakiro jotyaantantaitakariri Jerusalén-ki, piyaiyaani Antioquía-ki, ari itsipataari Juan jiitaitziri iijatzi Marcos. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Tzimatsi kamantantaniriiti janta Antioquía-ki japatotapiintaiyani kimisantzinkariiti, tzimatsi iijatzi yotaantaniriiti. Jirika ikaataiyini: Bernabé, Simón jiitaitziri iijatzi Kisaakiri, Lucio poñaachari Cirene-ki, Manaén itsipatakari pairani Herodes jantaritaiyakini, iijatzi Saulo. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Okanta japatowintaiyarini Awinkathariti, itziwintaiyarini, jiñaanashiritakiri Tasorintsinkantsi, ikantziri: “Powinari Bernabé pintsipataakinari Saulo nantawaitakairi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ikanta ithonkatakiro jamanamanaataiyakani, itziwintaiyani, jotzimikapatziitotantakari jako, jotyaantaiyakirini. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ikanta jotyaantani Tasorintsinkantsi, jataiyanakini Seleucia-ki, ari jotitaiyanakani jiyaatiro Chipre-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Aatakoiyapaakani Salamina-ki. Jitapaakawo ikamantantapaakiro iñaani Pawa japatotapiintaiyani Judá-mirinkaiti. Ari jiyaatsitanakari iijatzi Juan jimitakowaitiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jaathakiryaanakiro othampijyaaki, irojatzi jariitantakari Pafos-ki. Ari jiñaakiri jyiripiyaari Judá-mirinka, thiiyinkari jinatzi, jiita Barjesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jirika jyiripiyaari jaapatziyani jinatzi pinkathari Sergio Paulo. Yotaniri jinatzi jirika pinkathari, ikaimakaantakiri Bernabé itsipatakari Saulo, ikowatzi inkimiro iñaani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Iro kantacha jirika jyiripiyaari iitachari iñaaniki Grecia-jatzi Elimas, jotzikatzikatiri pinkathari iiro ikimisantanta. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ikanta Saulo, jiitaitziri iijatzi Pablo, ikimpoyaanakiri jirika, ishintsitakaapirotanakiri Tasorintsinkantsi, ");
INSERT INTO cpcNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ikantanakiri: “¡Thiiyinkarí! Kaaripirori pinatzi. Itomi kamaari pinatzi. Pimanintakiro kamiithari. ¿Iiroma powajyaantziro potzikatzikatziro tampatzikatzimotirini Nowinkathariti? ");
INSERT INTO cpcNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iroñaaka jowasankitaitimi, osamani pinkantya pinkamampotaakiti”. Apathakiro ikantanaka, tii jokichaatanai. Ikowakowawaitzi kathawakotairini. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ikanta jiñaakiro pinkathari awisaintsiri, ikimisantanaki. Iyokitzi jowakiro ikinkithatakoitziri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ikanta ishitowanai Pablo janta Pafos-ki itsipayitakari ikaataiyini otitanaka jiyaatiro Perge-ki saikatsiri janta Panfilia-ki. Iro kantacha Juan, tii joyaatanairi, piyanaka irirori Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ikanta jariitaka Perge-ki awisanaki pashiniki nampitsi Antioquía saikatsiri janta Pisidia-ki. Ikanta janta, ityagaiyini japatotapiinta Judá-mirinkaiti kitiijyiriki jimakoryaantaitari, saikaiyapaakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Aritaki ithonkaitakiro jiñaanayiitziro josankinari Kamantantaniriiti, Ikantakaantaitani iijatzi, ikantaki jiwatakaantatsiri japatotapiintaita: “Iyikiiti, kimitaka tzimatsi pinkantiri iiroka onkantya inthaamintantayityaari atziriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ipoña ikatziyanaka Pablo, jakowakotanaki imairitantayiityaari, ikantanaki: “¡Shirampariiti! ¡Israel-mirinkaiti! ¡maawoni iirokaiti ikaatzi pinkathatairiri Pawa! ");
INSERT INTO cpcNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Iriitaki Pawa iyoshiitakiriri pairani achariniiti, Israel-mirinkaiti. Iriitaki ojyiñaakiriri. Ipoña joñaagantakiro ishintsinka jowawisaakoyitairi Egipto-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ipoña ipiyathawaitakari Pawa otzishimashiki okaatzi 40 osarintsi. Iro kantacha Pawa jamawitakiro ipiyathayitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ipoña japirotakiri Pawa ikaatzi 7 jyininkamirinkatawakaachari janta Canaán-ki, irootaki jashitakagaariri achariniiti jiroka kipatsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","maawoni jiroka nokinkithatakoyitakimiri awisaki 450 osarintsi okaatzi osamanitaki. Ipoña jowakiniri jiwariiti aminakoyitirini, irojatzi jiwiyaantantapaakawori Samuel-ni, Kamantantaniri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iro kantzimaitacha ikowawitaka apaani iwinkatharipirotityaari. Irootaki Pawa jowantakanariri Saúl-ni, itomi Cis, ijyininkamirinkaiti Benjamín. Iri pinkathariwintakiriri okaatzi 40 osarintsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Iro kantacha Pawa jaapithatairi ipinkathariminto Saúl-ni, ipoyaatanaari David-ni. Tima iri David-ni ikinkithatakotaki pairani Pawa, ikantzi: Jinimotakina noñaakiri David, itomi Isaí, Iriitaki matironi jantiro nokowiri naaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ikanta itzimaki Jesús, icharinimirinkatakari David-ni. Iriitaki ikajyaakaakiri Pawa jotyaantiri jowawisaakoyitai aakaiti Israel-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Tikiraata impokiita Jesús, ikinkithatakotsitakari Juan-ni, ikantaki: ‘Ontzimatyii pimpiyashiriyitai, powiinkaawintaiyaari Pawa’. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ikanta Juan-ni jimonkaatzimatakiro jantawaitani, ikantanaki: ‘¿Piñaajaantakima naakataki jirika? Tii naaka. Aña aatsikitaki nopinkathapirotsitakari naaka, tii okantaajaitzi inkimitakaantina jimpiratani onkantya nonothopaitsitantyaariri i-zapato-ti’. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","¡Iyikiiti! ¡Abraham-mirinkaiti! ¡maawoni iirokaiti ikaatzi pinkathatairiri Pawa! Aakatajaantaki jotyaantayiitakai jiroka Ñaantsi awisakoyitantaiyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tima ikaatzi nampitawori Jerusalén-ki iijatzi ijiwaripaini, tii jiyotaiyawakirini Jesús, jiyakawintaiyakirini. Kaari jiyotantaajaitawakawo, jimonkaatatziiro josankinatakoyitakiriri Kamantantaniriiti, okantawita japiipiintawitakawo jiñaanatapiintakiro japatotapiintaiyani kitiijyiriki jimakoryaantaitari. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ipoña ikowakotakiri Pilato intsitokakaantiri Jesús, okantawitaka tikaatsi inkinakaashitapaintya irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Okanta jimonkaatakiro jantayitakiro okaatzi josankinatakoitakiriri pairani, jowatzikaryaakotakiri ipaikakoitakiri, ikitaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Iro kantacha Pawa jowiriintairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ari jitanakawo Jesús joñaagapanaatari ikaatzi tsipatakariri pairani ipoñaantakari Galilea-ki irojatzi Jerusalén-ki. Ojyiki okaatzi kitiijyiri joñaagapanaatari. Iriitajaantaki kinkithatakoyitairiri iroñaaka tsikarikapaini isaikayitzi atziri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Irijatziita nokinkithatakotzimiri iroñaaka iirokaiti, nokinkithatakotzimiro Kamiithari Ñaantsi okantakota ikajyaakaakiniriri Pawa achariniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ari jimonkaatakiro Pawa okaatzi ikajyaakaakiniriri, tima jowiriintairi Jesús joñaagayitairi aakaiti, tima ichariniiti anaiyatziini. Irootaki osankinatakotachari Salmo-ki, okantzi: Notomi nowimi iiroka. Naakataki piwaapatitanaa iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aritaki ikinkithatakotsitakari Pawa jowiriintairi Jesús, iiro oshitziwaitanta iwatha. Ikantaki jiñaawaitaki: Ari nimonkaatainiri David-ni okaatajaantzi nokajyaakaakiniriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tzimatsi pashini Salmo okoñaatakopirotzi jiroka, okantzi: Iiro pishinitziri oshitziwaiti iwatha pitasorintsiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Imapiro, kaari David-ni onkinkithatakoti jaka, tima jañaakaapaintziri Pawa jirika David-ni, ipoña jimakoryaaki, itsipataari ichariniiti ikitayitaa, ari oshitzitairi iwatha. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Irooma iwatha jirika jowiriintairi Pawa, tii jiñiiro oshitziwaiti iwatha irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Iyikiiti, ontzimatyii piyoyitai iirokaiti, iri nokinkithatakotzi Jesús, tima iri matairori ipiyakotaimiro piyaaripironka. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iikirorika paakowintatyiiyaawo Ikantakaantani Moisés-ni, iiro ipiyakoitzimiro piyaaripironka. Irooma aririka pinkimisantanairi Jesús, ari impiyakotaimiro irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Paamaakowintaiya iirokaiti, pipishitaawokari josankinatakotakiri Kamantantaniriiti, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Pinkimaiyini manintzirori tyaaryoori, Ari piyokitziitapainti, irojatzi pimpiyantatyaari. Tima ontzimawitatya paata oitya nantzimotaimiri, Iirotzimaita pikimisantziro, intzimawitatya ooñaawontimironi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ikanta ishitowimatanai Pablo japatotapiintaita, ikowakotaiyakirini kaari ijyininkata, ikantziri: “Pimpiyai pashiniki kitiijyiri jimakoryaantaitari, papiitiro pinkinkithatakainawo jiroka ñaantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ikanta jiyaataiyaini Judá-mirinkaiti iijatzi kaari ijyininkata japatotaiyani, tzimatsi ojyiki oyaatanakiriri Pablo itsipatakari Bernabé. Ari ikaminaathayitakiri onkantya joisokirotantyaawori inishironkayitairi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Okanta ariitaa pashini kitiijyiri jimakoryaantapiintaitari, ipiyotaiyakani ojyiki atziri ikimisantziro iñaani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Iro kantacha jiñaakiri Judá-mirinkaiti ipiyotaiyapaakani atziriiti, ikisashiritaiyanakani, jitanakawo jimaamaniwaitanakiri Pablo, ithainkimawaitanakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tii ithaawanaki Pablo itsipatakari Bernabé, ikantakiri irirori: “Iro kamiithawitachari nitawakimi nonkamantayitimiromi iirokaiti iñaani Pawa, tima Judá-mirinka pinayitzi. Irooma pimanintaiyakironi, iiro piñiiro jañaashiritakaitaimi. Irootaki nonkinkithatakaantyaariri kaari ajyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Tima ari okanta jotyaantakina Nowinkathariti, ikantakina: Iiroka nowaki pinkitiijyiinkatakotiri kaari pijyininkata, Ari onkantya pinkinkithatakotantaiyaanariri awisakotaantsi. Pothotyiiro maawoni kipatsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ikanta ikimaiyawakini kaari ijyininkawita, ikimoshiritaiyanakini, ikantaiyanakini: “Owa okamiithatataitzi iñaani Pinkathari”. Tima ithonka ikimisantaiyanakini ikaatzi jiyoshiitaitakiri jañaashiriyitai. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ithonka ikinkithatakoitanakiro iñaani Awinkathariti nampitsipainiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Iro kantacha Judá-mirinkaiti, ikinkithawaitakaaki ñaapiroriiti jiwatakaantatsiri nampitsiki, tsinaniiti pinkathataawo, tsipatapiintawitakariri Judá-mirinkaiti japatotaiyani, jashiminthatakaanakari impatzimaminthatiri Pablo itsipatakari Bernabé, jomishitowairi inampitsitiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ikanta Pablo itsipatakari Bernabé jotikanairo iipatsikiiti jiyoitantyaari tii ikimisantaitziri Pawa janta. Ari jawisaiyanakini pashiniki nampitsi Iconio-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Iro kantacha kimoshiri ikantaiyakani jiyotaaniiti, inampishiripirowaitantanakari Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ikanta Pablo itsipatakari Bernabé, ityagaiyakini japatotapiintaiyani Judá-mirinka janta Iconio-ki. Ikinkithatakaapaakiri, ari ikimisantaiyanakini ojyiki Judá-mirinkaiti ipoña kaari ijyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Iro kantzimaitacha, tzimayitatsi kisoshiriri Judá-mirinka, ikaminaakiri kaari ijyininkata imaamanitiri kimisantakaantapaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Irootaki, isaikantapaakari osamani janta. Iikiro ikinkithatakotanakitziiri Awinkathariti tii ithaawaiyini. Itasonkawintayitakiri, ari okanta jiyoyiitantari imapirotatya ikinkithatakotziro inishironka Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iro kantacha jimaamanitawakaanaka ikaatzi nampitawori janta. Tzimatsi aapatziyanakariri Judá-mirinkaiti, tzimatsi pashinipaini aapatziyanakariri Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ipoñaashitaka Judá-mirinkaiti itsipayitakari kaari ijyininkata, ikinkithawaitakaakiri jiwariiti jowasankitaawaitiri impoña intsitokakaantantyaariri mapi. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Iro kantacha iriroriiti, jiyotaki okaatzi jantaitiri, shiyaka ikinaiyanakini Listra-ki jawisaki irojatzi Derbe-ki, irootaki nampitsiiti saikatsiri janta Licaonia-ki. Ipoña jiyaayitanaki iijatzi pashiniki nampitsi okaatzi tzimayitatsiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ari ikinkithayitakiro iijatzi Kamiithari Ñaantsi janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Okanta janta Listra-ki tzimatsi shirampari kisopookiri, tii janiiwainitzi, tima ari ikantatya owakiraa itzimapaaki. Ari isaikaki jirika shirampari, ");
INSERT INTO cpcNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ikimisantziri Pablo. Ipoñaashitaka Pablo ikimpoyaanakiri shirampari, jiyotakiri owanaa jawintaashiripirowaitaka, kantatsi joshinchagairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Jiñaanatanakiri shintsiini, ikantanakiri: “¡Pinkatziyi, pintampatzikatiro piitzi!” Apathakiro jimitaanaki shirampari katziyanaka, aniitanai. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ikanta jiñaitakiro jantakiri Pablo, ikaimaiyanakini atziriiti iñaaniki Licaonia-jatzi, ikantaiyini: “¡Jayiitzimotakai pawa jojyakari atziriwí!” ");
INSERT INTO cpcNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ikimitakaanakiri Bernabé iriimi iwawani iitachari “Júpiter”, iriima Pablo ikimitakaanakiri iriimi iwawani iitachari “Mercurio”, tima iriitaki ñaawaitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ikanta ijyiripiyaariti Júpiter, saikatsiri iyaapapankotiki ipiyotapiintaiyani, jamaki ipirapaini, inchatiyapaini. Itsipayitakari atziriiti ikowawitaiyani impinkathatiri Otyaantapiroriiti, jowamainiri ipiraiti, intainiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Iro kantacha Bernabé itsipatakari Pablo jiyotaki irirori ikowiri jantaiyirini, isagaanakiro iithaari, josatikantanakari atziriiti, ikaimanaki, ");
INSERT INTO cpcNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ikantzi: “¿Iitama pantantyaawori jiroka? Atziri ninayitatzi naaka, ari nokimitzimi iirokaiti. Irootaki nopokantakari nonkamantayitaimi powajyaantayitairo pamitashitapiintakari. Ontzimatyii pinkimisantairi Pawa Kañaanitatsiri, witsikakirori inkiti, kipatsi, inkaari, iijatzi maawoni tzimayitantawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Irijatzi shiniyitakiriri pairani pichariniiti jantapiintayitantakawori inintashiyitari iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Iro kantzimaitacha tii jimanapithapirotziri iiro jiyotantaajaita añaatsi irirori. Tima iri Pawa nishironkatapiintakairi aakaiti, jowaryiiro inkani, okithokitantayitari awankiripaini, iri payitairori maawoni owayitari, ari okanta akimoshiriyitantari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Okantawitaka ikantayiwitakari atziriiti jiroka, ojyiki opomirintsitaka jowajyaantakaantyaariri jowamainiri ipirapaini intainiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ari jariitaiyapaakani Judá-mirinka poñainchari Antioquía-ki iijatzi Iconio-ki. Ikaminaayitapaakiri atziriiti. Irootaki itsitokantawitakariri Pablo. Jinoshikanakiri jookakiri nampitsithapiki, jiñaajaantaki aritaki jowamaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ipoña jiyotaaniiti Pablo japatowintapaakari, ari ipiriintanaari iijatzi ipiyanaa nampitsiki. Ikanta okitiijyitamanaki jataki Derbe-ki itsipatanaari Bernabé. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ikanta ikamantantapaakiro Kamiithari Ñaantsi janta Derbe-ki, ikimisantakaaki ojyiki atziri. Ipoñaashitaka ipiyaawo Listra-ki, Iconio-ki irojatzi Antioquía-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ari ikinkithatakaayitanairi jiyotaaniiti, ikaminaayitanairi onkantya joisokiroyitantyaariri jawintaashiritanakari, ikantayitziri: “Ontzimatyii añiiro ankimaatsiwaityaari antyaantaiyaari ipinkathariwintantai Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Jowanaki antaripiroriiti jiwatirini kimisantzinkariiti japatotapiintaiyani. Ipoña jamanamanaatakowintakari, itziwintayitakari, ikantapiintaki: “Nowinkatharití, paamaakowintaiyaari jirikaiti awintaayitanaimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ipoña ikinapairo Pablo janta Pisidia-ki, irojatzi Panfilia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ikinkithatakaantanaki janta Perge-ki, ipoña jawisanaki irojatzi janta Atalia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ari jotitanaa irojatzi Antioquía-ki, tsika jowaitakiri pairani jiyaatantyaari inkamantantiro inishironkatantai Pawa. Irootaki jimonkaatakiri jantayitakiro. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ikanta jariitaa Antioquía-ki, japatoyitapairi kimisantzinkariiti, ikamantapairi okaatzi jantakaayitakiriri Pawa, tsika ikanta Awinkathariti jawintaashiritakaayitaari kaari ijyininkata. ");
INSERT INTO cpcNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ari isaikapairi Pablo itsipatakari Bernabé itsipayitapaari jiyotaaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Ipoña jariitaka Antioquía-ki, shirampariiti ipoñaayitakawo Judea-ki, jiyotaantayitapaaki, ikantantapaaki: “Iyikiiti, iirorika pimonkaayitziro Ikantakaantani Moisés-ni, pintomishitaanitaiya, iiro pawisakoshiriyitai”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ikanta Pablo itsipatakari Bernabé owanaa jiñaanaminthatakiri jirikaiti ariitapainchari. Irootaki ikowayiitantakari jotyaantaitiri Pablo, Bernabé ipoña pashinipaini, jiyaati Jerusalén-ki jiñiiri Otyaantapiroriiti ipoña antaripiroriiti, inkinkithawaitakotiro kantainchari. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ipoña jotyaantakiri ikinanaki Fenicia-ki irojatzi Samaria-ki, ikamantantayitanaki tsika ikantayitaa ikimisantayitai kaari ijyininkata. Ikimoshiritaiyanakini iyikiiti ikimawaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ipoña jariitaiyakani Jerusalén-ki. Kamiitha jaawakiri kimisantzinkariiti, Otyaantapiroriiti ipoña antaripiroriiti. Ikamantapaakiri jantakaayitakiriri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Iro kantacha kiyopayipaini Fariseo kimisantaatsiri, ikatziyanaka iriroriiti, ikantanaki: “Ikaatzi kimisantayitaatsiri kaari ajyininkata, okowapirotatya jimonkaayitairo Ikantakaantani Moisés-ni, intomishitaanitaiya”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ari japatotaiyakani Otyaantapiroriiti itsipayitakari antaripiroriiti jiñaanatakotziro tsika okantakota jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ikanta osamanitaki jiñaanatawakaawintakawo, ikatziyanaka Pedro, ikantanaki: “Iyikiiti, pinkinkishiritaiyironi iirokaiti tzimatsi jantzimoyitakairi Pawa pairani. Jotyaantakina naaka nokinkithatakaayitairi Kamiithari Ñaantsi kaari ajyininkata, ari okanta ikimisantantayitaari iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Tima Pawa jiyotziri ishiriki, ari joñaagayitairo ikowi irirori inampishiritantaiyaari Tasorintsinkantsi kaari ajyininkata ikimitaayitakai pairani aakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tima jaapatziyayitaari Pawa jirikaiti ikimitakai iijatzi aakaiti, joitintashiriyitairi jawintaashiritaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","¿Kamiithatatsima piñaantawaityaari Pawa? ¿Iitama piñaatinatakaantyaariri jiyotaani? Tima pishintsiwintawaitakiri jimonkaatiro kaari aawiyaajaitzi aakaiti, kaari jaawiyaajaitzi achariniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Irootaki inishironka Awinkathariti Jesús owawisaakoshiriyitairi aakaiti. Ari inkimitsitaiyaari iijatzi iriroriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ari jimairitaiyanakini maawoni, ikimisantanakiri Bernabé itsipatakari Pablo ikinkithatakotziro jantakaayitakiriri Pawa pashinijatziki atziriiti, itasonkawintakaayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ikanta ithonkakiro ikamantantaki, ikantanaki Jacobo: “Iyikiiti, pinkimisantawakina: ");
INSERT INTO cpcNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ikamantakairo Simón tsika ikanta Pawa jitantanakawori jiyoshiiyitaki pashinijatzi atziriiti, inkimisantantaiyaariri, impairyaayitairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ari imonkaatari josankinatakotakiri pairani Kamantantaniriiti, ikantaki: ");
INSERT INTO cpcNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Aririka onkaatapaaki jiroka, ari nompiyi. Nowatziyairo ipanko David tyagaintsiri. Nompinkatharitakairi incharinityaari inkimitaiyaari ikanta irirori nopinkatharitakaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jaminaminataina pashinijatzi atziri, inkantayitaina: ‘Nowinkathariti’, Ari onkantya nashitantaiyaariri kaari pijyininkata, impairyaayitaina. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ari ikantaki jiñaawaitaki Awinkathariti, oñaagantzirori ikinkishiritsitakari owakiraini jitantanakawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Irootaki nonkantantyaari naaka, iiro okantzi añaakaawaitiri kaari ajyininkata ikaatzi kimisantayitairiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Apa otyaantiniri osankinarintsi ashintsiwintiri iiro jowayitantari wathatsi jashitakaayitariri iwawaniwaitashitari, iiro jimayimpiriwaiyitanta, iiro jowakoyitantawo iriraani piratsipaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Tima irooyitaki josankinari Moisés-ni ikinkithatakotapiintaitziri tsikarikapaini japatotapiinta Judá-mirinka kitiijyiriki jimakoryaantaitari. Irootaki jitanakari pairani. Irootaki jowajyaantantyaawori jirokapaini iiro ikantzimoshiritakaantari ajyininkapaini”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ikanta Otyaantapiroriiti itsipatakari antaripiroriiti, kimisantzinkariiti, jowaki jotyaantiri Antioquía-ki intsipatyaari Pablo iijatzi Bernabé. Jirika ikaatzi jowakiri: Judas jiitaitziri iijatzi Barsabás, ipoñaapaaka Silas. Iriiyitaki jiwatakaayitirini iyikiiti janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Iriiyitaki aanakironi osankinarintsi. Jiroka okantzi osankinata: “Iyikiiti, naakaiti Otyaantapiroriiti, antaripiroriiti. Niwithataiyimini iirokaiti kaari nojyininkamirinkata nampiyitawori Antioquía, Siria, ipoña Cilicia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Niyotaiyakini tzimatsi poñaayitanainchari jaka, iri oñaashirinkakimiri janta, ikowi pimonkaayitairo Ikantakaantaitani, pintomishitaanitaiya. Kaari notyaantani naakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Irootaki nokinkithawaitantari jaka, nowaki akaataiyirini, jiyaatantyaari jiñiimi intsipatanatyaari itakokitani Pablo intsipatanatyaari Bernabé. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Iriiyitaki atsipiwintakariri Awinkathariti Jesucristo. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jirika notyaantakimiri iroñaaka: Judas intsipatakari Silas. Iriitaki kinkithawaitakaapaakimini janta inkamantapaakimiro maawoni jiroka. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tii okantzi noñaakaawaitimi iirokaiti, tima iro kamiithatzimotakiriri Tasorintsinkantsi, iijatzi naakaiti. Apa pimayitanairo kowajaantachari. Jiroka: ");
INSERT INTO cpcNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Iiro powayitari wathatsi jashitakaitariri iwawanitashiitari. Iiro powakoyitawo iriraani piratsi. Iiro pimayimpiriwaitzi. Aririka pimonkaayitanakiro jiroka, kamiithataki. Ari okaatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ikanta jotyaantaitakiri, jataki Antioquía-ki. Ari japatotapaakiri kimisantzinkariiti, ipapaakiri osankinarintsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ikanta jiñaanatawakiro, ikimoshiripirotaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Tima kamantantaniri jinayitzi Judas ipoña Silas, ithaamintakaapaakari iyikiiti joisokirotyaari Pawa, ikinkithawaitakaapaakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Okanta osamanitaki isaikimowaitakiri kamiitha, jotyaantairi ipoñaakawo pairani. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Iro kantacha Silas okamiithatzimotakiri irirori isaikanaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Iijatzi Pablo itsipatakari Bernabé irojatzi isaikanaki iriroriiti Antioquía-ki, itsipayitakari ojyiki pashinipaini, iikiro jiyotaantanakitzi, ikamantantziro iñaani Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Ikanta osamanitaki, ikantairi Pablo jirika Bernabé: “Thami apiitiro ariityaari inampiitiki iyikiiti tsika akamantantakiro iñaani Awinkathariti. Aminairi tsika ikantayitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ari ikowawitaka Bernabé jaanakirimi Juan, jiitaitziri iijatzi Marcos. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Iro kantacha tii inimotziri Pablo jaanairi, tima Marcos jookawintakiri pairani Panfilia-ki, tii jothotyiiro intsipatyaari ikinayitaki ikinkithatakaantzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ari jiñaanaminthatawakaiyakani. Aripaiti jookawintawakaanaka. Jaanakiri Bernabé jirika Marcos, otitanaka ikinanaki Chipre-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Iriima Pablo, jaanakiri Silas. Ipoña jamanamanaatakotawakari iyikiiti, ikantaiyini: “Nowinkatharití, nawintaimi iiroka, aritaki pinishironkatakiri jirika”. Ari jiyaataiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ikanta ikinanaki Siria-ki, Cilicia-ki, jominthashiritakaayitaari ikaatzi kimisantayitaatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Ikanta jariitaka Pablo janta Derbe-ki itsipatakari Silas irojatzi jariitantakari Listra-ki. Ari jiñaaki jiyotaani Awinkathariti jiita Timoteo, otomi Judá-mirinka kimisantatsiri, Grecia-paantiri jinatzi iwaapatitari. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ikanta jirika Timoteo kamiitha ikinkithatakotaiyirini kimisantzinkariiti nampitawori Listra-ki iijatzi Iconio-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Ari ikowakiri Pablo intsipatyaari Timoteo. Iro kantacha jitawakari itomishitaanitakiri iiro ikisawaitanta Judá-mirinkaiti nampitawori janta, tima jiyotaiyini maawoni Grecia-paantiri jinatzi iwaapatitari Timoteo. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ikanta ikinayitanaki nampitsiitiki, ikamantayitanakiri kimisantzinkariiti jimonkaayitairo josankinatakiri pairani Otyaantapiroriiti itsipatakari antaripiroriiti janta Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ari okanta ityaaryooyitantanakari kimisantzinkariiti jawintaayitanaka, iikiro jiyaatanakitzi kitiijyiriki ijyikipirotanaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ikanta Pablo joshinampitanakiro Frigia iijatzi Galacia, tima tii ishinitairi Tasorintsinkantsi inkinkithatakaanti janta Asia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Irojatzi jariitantakari Misia-ki. Ari ikinkishiriwitakari jiyaatiro Bitinia-ki, iro kantacha tii ishinitairi Itasorinka Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Awisanaki janta Misia-ki, oirinkaiyapaakani nampitsiki Troas. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ari janta imishiwaitakiri Pablo tsiniripaitiki, imishitaki Macedonia-jatzi, ikantziri: “Pariitina nonampiki, pinishironkayitaina naakaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ikanta imishiwaitaki Pablo, ari niwitsikaiyanakani niyaataiyini Macedonia-ki, tima niyotanaki iri Pawa kaimashiritakinari janta nonkinkithatakotiro Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ari notitaiyanakani Troas-ki, apatziro nowanakiro niyaatiro Samotracia-ki. Okanta okitiijyitamanaki irojatzi naatakotantapaakari nampitsiki Neápolis. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Opoña nawisanaki irojatzi Filipos-ki, jinampiyitawo poñaayitainchari Roma-ki, otzinkami nampitsi inatzi janta Macedonia-ki. Ari nosaikawaitapaakiri janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Okanta kitiijyiri jimakoryaantapiintari Judá-mirinkaiti, niyaataki jiñaathapiyaaki, tima nokinkishiritaiyakani ari jamanamanaatapiintaiyani. Ari noñaapaaki tsinani apatotaiyakani, nosaikaiyapaakini nokinkithatakotziniro Kamiithari Ñaantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Okanta tsinani apatotainchari oita Lidia, opoñaawo iroori nampitsiki Tiatira. Opoki iyompariwaita manthakintsi pitzirishimawoyitatsiri. Tima opinkathatapiintakiri Pawa jiroka tsinani, okimaminthatakiri ikinkithatzi Pablo, jiminthashiritakaanakawo Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Owiinkaataka, otsipatakari ikaatzi saikapankotzirori. Ipoñaashita okantaiyanakinani: “Piyotzirika iirokaiti notyaaryoowintairi Awinkathariti, pimpokaiyini pimayi nopankoki”. Ari nimataiyakironi, tima irootaki shintsiwintakinari. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Opoñaashitaka apaani kitiijyiri, niyaataiyini namanamanaatya, notonkiyotaka mainawo ompirataawo. Piyarishiritatsiri, jiyotakaayitziro iitarika awijyimotirini atziri. Irootaki ipinaitantariri ojyiki ompiratawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Jiroka mainawo itanakawo oyaatanakiri Pablo, oyaataiyanakinani iijatzi naakaiti, okantzi okaimi: “¡Jirika shirampariiti jompiratani jinatzi Pawa Jinokijatzi, iriitaki kamantimironi pawisakoshiritantaiyaari!” ");
INSERT INTO cpcNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ari okantapiintatya jiroka kitiijyiriki, irojatzi owatsimashiritantakariri Pablo, ipithokashitanakawo, jiñaanatanakiri piyari aagashiritakirori, ikantziri: “Piyaapithatairo mainawo, iri Jesucristo matakaimironi nopairyaakiri”. Apathakiro ikantanaka piyari jiyaapithatairo. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ikanta jiñaakiro ompiratawori, jiyotanaki iiro jaantaawo ojyiki kiriiki. Joirikakiri Pablo itsipataakiri Silas, jaanakiri jiwariitiki, irojatzi janta ipiyowintantapiintaita. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ikantapaakiri pinkathariiti aminakotantaniri: “Jirikaiti Judá-mirinka jinatzi. Ichapishiryaayitakiri atziriiti jaka anampiki, ");
INSERT INTO cpcNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","jiyotaayitakiri kaari ashiniyitzi jantaitiro, tima aakaiti ijyininkamirinkaiti Roma-jatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ari ipithokashitaitanakari Pablo itsipatakari Silas, ikantaki pinkathariiti aminakotantaniri: “Paatonkoryaayitiri, pimpajawaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aritaki ipajawaitakiri ojyiki, jomontyaakaantakiri. Ikantanaki: “Paamaakowintapirotyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Ikimaki aamaakowintantaniri ikantaitakiri, jomontyaapirotakiri inthomainta, jawitsinaakiitantakari inchakota. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Okanta niyankiiti tsiniripaiti, jamanamanaata ipoña ipampithagaiyini Pablo itsipatakari Silas, kimaiyatsini pashini omontyaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Omapokashitanaka ontziñaanaka, iiwokapaakiro jomontyaitakiri. Apathakiro ashitaryaayitanaka ashitakowontsi, ishiryaakowaitashitanaka omontyaari ithatakowiitantakari ashirotha. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ipoña ikakitanaki aamaakowintantaniri, jiñaatziiro ashitaryaaka jomontyaawiitakari, ari jinoshikanakiro jowathaaminto ikowi josataiya, jiñaajaantaki shiyayitaka omontyaariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Iro kantacha Pablo ikaimotanakiri, ikantziri: “¡Iiro powashironkaawaitashita, iinitatsi nosaikaiyini maawoni jaka!” ");
INSERT INTO cpcNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ipoñaashitaka jirika aamaakowintantaniri ikaimakaantaki ootamintotsi, ishiyapirotanakitya ityaapaaki, okawaitanaka ithaawanaki, jotziirowashitapaakari Pablo itsipatakari Silas. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ipoña jomishitowanakiri, josampitakiri, ikantziri: “Pinkatharí, ¿Iitama nantiri naaka nawisakoshiritantaiyaari?” ");
INSERT INTO cpcNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ikantanakiri irirori: “Pinkimisantairi Pinkathari Jesús, aritaki pawisakoshiritai iiroka iijatzi ikaatzi saikapankotzimiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ikinkithatakotanakiniri tsika ikantakota Awinkathariti iijatzi ikaatzi saikapankotakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ipoñaashitaka iinta oniyankiititzi tsiniriri jirika aamaakotantaniri ikiwanakiniri jaawiyaitakiri ipajaitakiri. Ipoña jowiinkaayitaka jirika itsipatakari ijyininkamirinkatari. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ari jaanakiri ipankoki, ipapaakiri jowanawo. Kimoshiri ikantanaka jirika ikimisantairi Pawa itsipayitaari ikaatzi saikapankotakiriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Okanta okitiijyitamanai, jirikaiti pinkathari aminakotantaniri ikaimakaantakiri kimpoyaakotaniri, ikantakiri: “Pomishitowakaantairi jirikaiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ikanta aamaakotantaniri, ikantakiri Pablo: “Ikantakaantakina pinkathari nomishitowayitaimi. Kantatsi iroñaaka piyaayitai kamiitha”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Iro kantacha Pablo ikantanaki irirori: “Josankinatakotakaantani Roma-jatzi ninatzi naaka, iro kantacha ipajawaitakina japatotapiintaita, tii jaminawakiro tzimatsirika nokinakaashitani. Jomontyaakaantakina. ¿Iroñaakama ikowi jimanakaina jomishitowayitaina? ¡Tii nokowiro! Pinkantiri impokanaki irirori jomishitowayitaina”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ikanta jirika aamaakotantaniri, ikamantakiri pinkathari. Ikimawaki josankinatakotani jinatzi Roma-jatzi, antawoiti ithaawaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Jatanaki pinkathariiti, ikantapaakiri Pablo itsipatakari Silas: “Pimpiyakotina nowasankitaakaantawaitakimi”. Ari jomishitowakaantairi, ikantawairi: “Piyaataityaami”. ");
INSERT INTO cpcNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ari jiyaataiyaini opankoki Lidia. Ikinkithatakaayitanairi kimisantzinkariiti, ithaamintashiritakaayitanairi, jataiyaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ikanta jariitantayita Pablo itsipatakari Silas ikinayitanaki Anfípolis-ki, Apolonia-ki irojatzi jariitantakari Tesalónica-ki, otzimi janta japatotapiintaiyani Judá-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tima iro jamitapiintakari Pablo aririka jariitya pashiniki nampitsi, ityaapiintzi tsikarika japatotapiinta Judá-mirinkaiti, ikinkithatzi. Irootaki jimatapaakiri iroñaaka. Ipoña japiitairo pashiniki kitiijyiri jimakoryaantaitari, japiitairo iijatzi. Ari jiñaanaminthatapiintakiri Judá-mirinka. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Jookoyitatziiniri Osankinarintsipirori tsika ikinkithatakota Cristo inkamimotanti, impoñaashitaiya jañagai iijatzi. Ikantayitziri: “Jirika Jesús nokinkithatakotakimiri, iriitaki Cristo”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ari ikimisantanaki tsika ikaatzi Judá-mirinka, itsipatanakari Pablo iijatzi Silas. Ikimisantaiyanakini iijatzi ojyiki Grecia-paantiri pinkathatasorintsitaniri, ari okimitsitakari iijatzi pinkathataawo tsinaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Iro kantacha Judá-mirinkaiti kaari kimisantatsini, tii inimoshiritanakiri. Japatotaki kaaripiroshiririiti. Jotyaantakiri imaamanitanti nampitsiki. Imaamanipankotakiri iijatzi Jasón, jaminaminatziri Pablo itsipatakari Silas. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Tii jiñaashitari janta, jinoshikanakiri Jasón itsipataanakiri pashini kimisantzinkariiti, jaanakiri isaiki jiwatakaantzirori nampitsi, ikantaiyapaakini: “¡Tzimatsi shirampariiti ochapishiryaantaintsiri nampitsiitiki, pokaki iroñaaka jaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jirika Jasón oosaikawakiriri ipankoki! Ithainkayitakiro jirikaiti ikantakaantani pinkatharitatsiri Roma-ki, ikantaiyakini: ‘Tzimatsi pashini pinkathari, jiita Jesús’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ikanta ikimaiyawakironi jiroka, tii inimotaiyanakirini atziriiti iijatzi jiwariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ikowakoitakiri Jasón impinawintya itsipayitakari pashinipaini, ari onkantya impakaantaiyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ikanta kimisantzinkariiti, jotyaantairi tsiniripaiti Pablo itsipatanaari Silas, jiyaatai Berea-ki. Ikanta jariitaiyakani janta, jataiyakini japatotapiintaiyani Judá-mirinka. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Jirikaiti Judá-mirinka, nishironkatantaniri jinaiyatziini tii ikimitari Tesalónica-jatzi, kamiitha ikimisantawakiro ñaantsi. Jaakowintanakawo kitiijyiriki jiñaanatanakiro Osankinarintsipirori jiñaantyaawori imapirotatyaarika ikamantaitziriri. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ojyiki Judá-mirinkaiti kimisantanaintsiri, ari ikimitsitakari iijatzi Grecia-paantiri pinkathataari, iijatzi tsinaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Iro kantacha Judá-mirinkaiti nampitawori Tesalónica-ki, ikimakotakiri ikinkithatakaantatzi Pablo janta Berea-ki, pokaiyanakini, imaamaniminthawaitapaakiri atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Iro kantacha kimisantzinkariiti jaanakiri Pablo inkaarithapiyaaki. Iriima Silas itsipatakari Timoteo ari isaikanaki irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ipoña jawisakagaitanakiri Pablo irojatzi jariitantakari Atenas-ki. Ikanta ipiyaiyaani Berea-ki, ikantapairi Silas itsipatakari Timoteo: “Ikaimakaantaimi Pablo, piyaatai thaankipiroini”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ikanta Pablo joyaawintari Atenas-ki Silas itsipatakari Timoteo, ojyiki oñaashirinkakiri jiñaayitziri Atenas-jatzi jamanamanaatari ojyakaantsipaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Irootaki ikinkithawaitakaantakariri Judá-mirinkaiti, iijatzi pashinipaini pinkathatasorintsitaniri janta japatotapiintaiyani. Ojyiki ikinkithawaitakaapiintaki iijatzi kitiijyiriki tsikarika ipiyotapiintaiyani atziriiti janta nampitsiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Jiñaanaminthayitziri iijatzi yotaniriiti janta nampitsiki. Tzimatsi kantayitatsiri: “¿Iitamachiitaka ikinkithatakotziri jirika kiñaaniri?” Ikantaiyini pashini: “Kimitaka ikinkithatakotatziiri pashinitatsiri pawa”. Iro ikantayitantakari tima Pablo ikamantantatziiro Kamiithari Ñaantsi tsika ikantakota Jesús, jañaantaari iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ipoña jomiyaanakiri otzishiki iitachari “Areópago”, tsika japatotapiintaiyani. Josampitakiri: “Incha pinkinkithatakotinawo owakiraatatsiri piyotaantziri jaka nonampiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Tima pikinkithatakotakinawo kaari nokimapiintzi. Nokowaiyini niyoti iita kantakotachari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Tima okaatzi itzimawintziri Atenas-jatziiti itsipatakari ariitzinkariiti janta, ikimisantayitziro owakiraatatsiri ñaantsi, jowawisaimaityaawo.) ");
INSERT INTO cpcNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ikatziyanaka Pablo ipiyowintaitakari, ikantanaki: “Atenas-jatziiti, noñaakimi naaka, tzimatsi ojyiki piwawaniyitari, pamanamanaatashitapiintari. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nokinayitzi pinampiki, noñaayitakiro pitaapiriminto. Tzimatsi apaani osankinataka, okantzi: ‘PAWA KAARI JIYOYIITZI’. Irijatzita nokinkithatakotzimiri naaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Iri witsikakirori kipatsi maawoni tzimantayitawori, irijatzi Pinkathariwintzirori inkiti iijatzi kipatsi. Tii isaikantawo tasorintsipanko jiwitsikani atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tii ikowiro irirori jiwitsikaitiniri tsikarika oitya. Tima iriitaki añaakaayitairi maawoni aakaiti, irijatzi añiinkatakaayitairi, ipayitairo maawoni tsikarika oitarika. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Iriitaki witsikakiriri itawori shirampari, jojyiñaakiri, itzimpookakiri inampitantyaawori maawoni kipatsiki. Ikinkishiritsitaka tsika onkaati osamaniti jinampitaiyaawo tsikarikapaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Iro jantantakawori jiroka, onkantya jaminaminaitantyaariri. Kimiwaitaka ipampipampiwaitatyiimi jaminaminaitziri. Ari jiñiiri. Tima tii intaina isaiki Pawa ari itsipayitai maawoni aakaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Iriitaki añaakaayitairi iroñaaka, ijyiwatakaayitai, iri tzimakaayitairi. Irojatzi ikantsitakari pijyininkaiti iiroka, kinkitharyaantzi, ikantaki: ‘Jashiyitai Pawa’. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Tima jashiyitai Pawa, tii okantzi ankinkishiritakowaityaari ikimitatyaari ojyakaantsi jiwitsikani atziriiti, jiwitsikayitziri oro, kiriiki, mapi. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tima pairani ojyiki jamawitakiro Pawa okaatzi jantashiwaitakari imasontzinkakiini. Iro kantacha ikantayitairi maawoni tsikarika inampiyitawo, ikantairi: ‘Powajyaantairo kaaripirori pamitashiyitari’. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Tima Pawa jiyoshiitaki apaani shirampari, iriitaki jotyaantairi jaminakoyitairo okaatzi antayitakiri. Aritaki jiyotajaantakiro irirori Pawa tsikapaitirika jimatairo. Tima joñaagantakiri shirampari jowiriintairi ikamawitaka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Ikanta ikimawaki ikinkithatakotakiri kaminkari ipiriintaa, ishirontaminthatanakari. Tzimatsi pashini kantanakiriri: “Ari apiitiro paata nonkimimi pinkinkithatakotiro jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Jiyaapithatanairi Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Iro kantacha joyaatanakiri tsikarika ikaatzi, kimisantai irirori. Jirika ikaatzi kimisantaatsiri: Dionisio, irijatzi apaani tsipawitariri ipiyotapiinta Areópago-ki. Opoñaapaaka tsinani iitachari Dámaris, tzimayitatsi pashini. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ikanta okaatapaaki jiroka, ishitowanaki Pablo Atenas-ki, jataki Corinto-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ari jiñaakiri Judá-mirinka iitachari Aquila, Ponto-jatzi jinatzi jirika. Owakiraa jariitaka Aquila itsipatakawo iina Priscila ipoñaakawo Italia-ki, tima pinkathari Claudio ikantakaantaki janta Roma-ki ishitowayiti maawoni Judá-mirinkaiti. Jataki Pablo jariitari Aquila. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ari isaikapaaki Pablo intsipatyaari. Tima okaatzi jantawaititakari jirika, ishirikayitziro tontamawotatsiri manthakintsi, ipankoitawo. Irojatzi jantawaitsitari pairani Pablo irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ari ikantapiintatya Pablo jiyaatzi japatotapiintaita kitiijyiriki jimakoryaantaitari, ikinkithatakaantayitaki inkitsirinkantyaariri Judá-mirinkaiti inkimisantakaayitairi, iijatzi Grecia-paantiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Ikanta Silas itsipatakari Timoteo ariitaiyapaakani ipoñagaawo Macedonia-ki. Ari jaakowintanakawo Pablo ikinkithatakaantanaki. Ikantakiri Judá-mirinkaiti: “Jirika Jesús, Cristo jinatzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Iro kantacha tii inimotziri Judá-mirinkaiti, ikisaniintanaka, ikawiyawaitanakiri. Ari jotikanairo iithaari Pablo jiyotaitantyaari tii ikimisantaiyini, ikantanakiri: “Iirokayitaki kantashityaawoni pimpiyashitantaiyaari, tii naaka kantashityaawoni. Iroñaaka nompithokashityaari kaari ajyininkata”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Shitowanaki japatotapiintaita. Jataki ipankoki atziri iitachari Justo, pinkathatasorintsitaniri jinatzi. Isaikanampitziro irirori japatotapiintaiyani Judá-mirinkaiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ikanta Crispo, jiwatatsiri japatotapiinta Judá-mirinka, ikimisantanakiri Awinkathariti, ari ikimitaakiro iijatzi ikaatzi saikapankotziriri. Iijatzi ikimitanakari ojyiki Corinto-jatzi, ikimayitakiro ñaantsi, kimisantayitanaki, jowiinkaayitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ikanta Pablo, jomishimpiyaakiri Awinkathariti tsiniripaiti, ikantakiri: “Iiro pithaawi. Piyaatakairo pinkamantantiro ñaantsi jaka, iiro pimairitzi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“Tima ari notsipatzimi naaka, iiro jowatsinawaitaitzimi jaka, tima tzimatsi ojyiki nashiyitaari naaka jaka nampitsiki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iro isaikantanakari Pablo Corinto-ki, awisanaki apaani osarintsi niyankitapai pashini. Jiyotaantayitziro iñaani Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Okanta ijiwatantari Galión janta Acaya-ki, jitanakawo Judá-mirinkaiti imaamanitanakiri Pablo. Ipoña jaanakiri janta jiwariki. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ikantapaakiri: “Jirika shirampari ikinakaashitakawo jiyotaayiitziri atziriiti ipinkathatairi Pawa, ipiyathatakawo ikantakaantaitziri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Iro jiñaawaitanakimi Pablo, ikantanaki Galión jiñaanatanakiri Judá-mirinkaiti: “Iroorika pikinkithatakotzi ikinakaashitakari jirika shirampari, itsitokantaki, aritaki nonkimakimi pinkantayitina. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Aña pikantawakaawintashitawo piñaawaiminthatashitari, pipairyaaminthawaitashitari, piitashiwaitari: ‘Ikantakaantaitani’. Piyotaiyironi iirokaiti tsika pinkantiro, tii nomiraawintawaitawo naaka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Jomishitowaiyakirini. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ikanta Grecia-paantiri, joirikanakiri iitachari Sóstenes, iri jiwatsitacha japatotapiinta Judá-mirinka. Ipajawaitanakiri. Iro kantzimaitachari Galión, tii jimatzimaitawo irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Ojyiki kitiijyiri isaikawaitanai Pablo janta Corinto-ki. Ari jiyaatai itsipatanaawo Priscila iijatzi Aquila, jiyaatairo Siria-ki. Ikanta janta Cencrea-ki, tikira jotitanaata, jamiitanakiro iishi, ari jimonkaatziro okaatzi ikantantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ikanta jariitaka Efeso-ki, jataki Pablo japatotapiintaita, ikinkithatakaayitapaakiri Judá-mirinkaiti. Ari jookanairi Aquila itsipatakawo Priscila. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ikowakowitawaari Judá-mirinkaiti osamani isaikanaki, tiimaita ikowi Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ikantanairi jiyaatzimatanai: “Ontzimatyii nariitaiya Jerusalén-ki joimoshirinkaita. Iriirika Pawa kowatsini, ari nompiyi noñaayitaatimi”. Ipoñaashitaka jotitanaa Pablo, jatai. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ikanta jariita Cesarea-ki, awisapai Jerusalén-ki jiwithatapaiyaari kimisantzinkariiti. Ipoña jawisanai Antioquía-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ikanta osamanitaki, japiitairo iijatzi jariitantayita nampitsi tzimatsiri janta Galacia-ki iijatzi Frigia-ki, jominthashiritakaayitari jiyotaani. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Okanta janta Efeso-ki, ariitaka Judá-mirinka iitachari Apolos, Alejandría-jatzi jinatzi. Kamiitha ikinkithatzi, jiyotakopirotziro Osankinarintsipirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tzimatsi kinkithatakotsitakariri Juan-ni owiinkaatantaniri, ikinkithatakoitsitakawo iijatzi okaatzi ikamantantakiri Juan-ni ikantakota Jesús. Ari iwiyaa jiyotakotziro irirori. Iro kantacha, kamiitha ikanta joñaagantawitawo ikinkithatakotziri Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ari ikinkithatakaantapaaki Apolos japatotapiintaita. Ikanta okimakiri Priscila otsipatakari Aquila, jaanakiri Apolos, jiyotaakiri tsika ikantakotajaanta Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ikowaki Apolos jawijyi Acaya-ki. Ari ipawakiri kimisantzinkariiti Efeso-jatzi apaani osankinarintsi jaapatziyantawatyaariri Acaya-jatzi. Ikanta jariitaka Acaya-ki, ojyiki ithaamintakaapaakari kimisantzinkariiti inishironkayitairi Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Jimatatziiro Apolos ikitsirinkayitakiri Judá-mirinkaiti, joñaagayitziri Osankinarintsipirori ikinkithatakoitziri Cristo, ari okanta jiyotakotantaitakariri Jesús, iriitaki Cristo. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ikanta Apolos isaiki Corinto-ki, anonkanaki Pablo otzishimashiki, ariitaka Efeso-ki. Jiñaapaakiri kimisantawitachari. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Josampitapaakiri: “¿Inampishiritantakimima Tasorintsinkantsi owakiraa ikimisantakaitakimi?” Ikantaiyanakini iriroriiti: “Tiitya. ¿Oitama kantakotachari jiroka? ¿Iitama ikantaitziri Tasorintsinkantsi?” ");
INSERT INTO cpcNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ari ikantzi Pablo: “¿Iitaka powiinkaawintakari pikimisantawitaa?” Ikantaiyini iriroriiti: “Iro nowiinkaawinta jiyotaantakiri Juan-ni”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ipoña Pablo jiyotaanakiri, ikantayitziri: “Jowiinkaatantzira Juan-ni, ojyakaawintamachiitatya jowajyaantaitiro kaaripirori. Iro kantzimaitacha ikantsitaka Juan-ni: ‘Pinkimisantairi aatsikitaintsiri, iri poyaatapaatyaanani’. Iriitaki Jesucristo ikinkithatakotakiri jaka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ikanta ikimaiyawakini jirikaiti, jowiinkaawintanakari Awinkathariti Jesús, ipairyaayitainiri irirori. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ipoña Pablo jotzimikapatziitoyitantakari jako, ari inampishiritantanakari iriroriiti Tasorintsinkantsi. Jiñaawaiyitantanakawo pashiniyitatsiri ñaantsi. Ikamantantayitanakiro ñaantsi jiyotakaayitanairiri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ikaataiyini 12 atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ipoña jawisaki Pablo japatotapiintaiyani Judá-mirinka, ari ikinkithatakaantapaaki ikaatzi mawa kashiri. Tikaatsi inthaawakaiya, ikowi jiyotakaayitairi atziriiti tsika ikanta Pawa ipinkathariwintantai. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Iro kantacha tzimatsi tsika ikaatzi kisoshiriwaitatsiri, tii ikowi inkimisantaiyini, ikijyimawaitakiri tsipatanaariri jiitaitziri “Aatsi”. Ikanta Pablo, jintainaryaanakari jirikaiti. Ikaminaayitanairi jiyotaaniiti janta iyaapapankotiki jiitaitziro “Tiranno”. Ari jiyotapiintakiri maawoni kitiijyiriki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ari ikantapiintanakitya, tzimakotaki apiti osarintsi. Ikimakoyitairo iñaani Pawa nampiyitawori Asia-ki, Judá-mirinkaiti, Grecia-paantiripaini, maawoni. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ojyiki itasonkawintantaki Pablo janta ikantakaakari Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Matataitacha iijatzi oshinchaantanaki imanthakipaini Pablo. Aririka jaayiitiro tsikarikapaini, intirotantaityaari mantsiyari, aritaki ishintsitanai. Aritaki onkantaki iijatzi ishintsiyitai piyarishiriyitatsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ikanta tsikarika ikaatzi Judá-mirinka kinakinawaitatsiri janta joshinchaayitziri piyarishiritatsiri, ikowawitaiyakani iriroriiti joshinchaanti impairyiiri Jesús. Ikantawitari piyariiti jiñaanatziri: “¡Piyaapithatiri, nompairyiimiri Jesús, ikinkithatakotziri Pablo!” ");
INSERT INTO cpcNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Irootaki jimawitaiyakarini 7 itomiiti Judá-mirinka iitachari Esceva, jiwawitariri ompiratasorintsitaniriiti janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Iro kantacha jakakiri piyariiti, ikantakiri: “Noñiiri Jesús, niyotakotziri Pablo. Irooma iirokaiti, tii niyotzimi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ikanta piyarishiritatsiri joirikanakiri jirikaiti, antawoiti jomankiyanakari, joitsinampaakiri maawoni, jomishiyairi ipankoki jaatonkoryaamirikitakiri, antawo jowatsinawaitakiri iwathaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ikimaiyakini nampitawori Efeso-ki, Judá-mirinkaiti iijatzi Grecia-paantiri, maawoni. Owanaa ithaawaiyanakini. Ari okanta ipinkathaitantanakariri Awinkathariti Jesús. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ari ipokayitanaki iijatzi ojyiki kimisantayitaatsini, ithawitakoyitapaakiro iyaaripironka. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Jamayitapaakiro jyiripiyaariwitachari tsika jiñaanatakotapiintziro ijyiripiyaaritantari, itaayitapaakiro. Ikanta jaminaitakiro tsikarika okaatzi opinatari itaayiitakiri, ariitaka ikaatzi: 50,000 ikithoki kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Iikiro ikimakopiroitanakitziiri Awinkathariti. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Okanta okaatapaaki jirokapaini, jominthatakawo Pablo jariitantya Macedonia-ki iijatzi Acaya-ki. Impoña jawisanaki irojatzi Jerusalén-ki. Ikantsitaka iijatzi: “Aririka niyaataki Jerusalén-ki, ari nawisaki niyaati Roma-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ipoña jotyaantaki Macedonia-ki apiti imitakotapiintirini, Timoteo itsipatakari Erasto, iinirotatsi isaikanaki irirori Asia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Okanta janta Efeso-ki antawoiti ikisawakaawintakari tsipatanaariri jiitaitziri “Aatsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Iri poñaakaantakawori iitachari Demetrio, ashiropakori. Tzimayitatsi iijatzi kimitakariri irirori jiwitsikayitziro oryaani ojyakaawo oyaapapankoti iwawanitashiitari jiitaitziri “Diana”. Iri jaantayitari ojyiki kiriiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Japatotaiyakani maawoni ashiropakoriiti. Ikantaki Demetrio: “¡Shirampariiti! Tima iro añaantari aakaiti jiroka antawairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Iro kantacha, aritaki pikimakotakiri jiitaitziri Pablo, ikitsirinkaki ojyiki atziriiti, ikantayitziri: ‘Jiwitsikani atziriiti tii impawati’. Tii apa ikantakiro anampitsitiki Efeso, aña jimatsitakawo maawoni jaka Asia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Tii apa onkantzimotai iiro jamanantapiroitanairi awitsikani, iro kantzimopirotairi, ompiyakotya inkimakoitiro antawoiti awawani Diana maawoni jaka Asia-ki, ari jowajyaantaitanakiro impokaiti oyaapapankotiki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ikanta ikimaiyakini, antawo ikisaiyanakani, ikaimaiyanakini: “¡Antawoiti inatzi Diana awawanitari jaka Efeso-ki!” ");
INSERT INTO cpcNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Iikiro ikamiñiinkatanakitzi jiñaawaitaiyini jirikaiti. Ipoña joirikaitanakiri Gayo itsipataitanakiri Aristarco, jaitanakiri japatotaiyapiintani atziriiti. Jirika jaitanakiri iriitaki itsipatapiintari Pablo jariitantayita, Macedonia-jatzi jinaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ikowawitaka Pablo intyaapaakimi irirori, tiimaita ishinitziri jiyotaaniiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ari ikimitsitakari jiwariiti jaapatziyani Pablo, ikantakaantakiri: “Iiro pimatsitawo iiroka janta”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ikanta janta japatotaiyakani, iikiro ichiraachiraataiyatziini, tii ojyawakaa okaatzi ichiraawintaiyirini. Tima jirikaiti atziriiti tii jiyopirotaiyini oita japatowintaiyarini, ikaimakaimawaitashitaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Iro kantacha tsikarika ikaatzi Judá-mirinka, jiñaakiri Alejandro josatikaka janta ipiyotaiyakani, ishintsiwintanakiri inkinkithatakotiri. Ikanta Alejandro jakotanaki jimairitantawatyaari, ikinkithawaitakaawitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Iro kantacha jiyotaiyakini atziriiti Judá-mirinka jinatzi jirika Alejandro, iikiro japiitanakitziiro ikaimaiyini, osamani ikantaka ikaimi, ikantaiyini: “¡Antawoiti inatzi Diana awawanitari jaka Efeso-ki!” ");
INSERT INTO cpcNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ipoña ikatziyanaka osankinaryaantzi, jomairintakiri, ikantakiri: “Efeso-jatzí, jiyotaitzi maawoni, aakaiti kimpoyaawintawori oyaapapankoti awawani Diana, iijatzi ojyakaani poñainchari inkitiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Irootaki pinkinkishiritantawatyaari kamiitha, iiro pimaamanitantashiwaita. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tima jirikaiti shirampari pamayitakiri, tii jowaaripirotziro kaapapanko, tii ikijyimatziro iijatzi awawani. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ikowirika jiyakawintanti Demetrio itsipayitakari ikaayitziri, jaanakiri ajiwariki jaminakotiniri, iri witsikiniriri okaatzi kantzimotariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Okowatyaarika ayotakotiro maawoni aakaiti, kimitaka kantatsi apatotiri maawoni jiwariiti, jaminakotantyaawori. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Okaatzi awisaintsiri iroñaaka, aritaki jowasankitaawintaitakairo amaamanitantaki. Iiro otzimi ankantiri ampiyakowintantyaari”. ");
INSERT INTO cpcNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ikanta ithonkakiro jiñaawaitakiro jiroka, jotyaantairi atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ikanta ithonkaka ikamiñiinkataki jiñaawaitaiyini, japatotakiri Pablo jiyotaani ikaminaayitanairi. Ipoñaashitaka jiwithayitanaari, jataki Macedonia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ari jariiyitanaawo maawoni nampitsi tsika isaikayitzi iyikiiti, ikaminaayitanairi. Irojatzi jariitantakari Grecia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ari isaikawaitapaakiri ikaatzi mawa kashiri. Iro jotitanaiyaami jiyaatantyaari Siria-ki, ari ikimakiri jowamaatyiiri Judá-mirinkaiti jariitatyaarika janta. Irootaki ipiyantanaari Macedonia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ari itsipatanaari Sópater Berea-jatzi jinatzi itomi Pirro. Ipoñaapaaka Aristarco, ipoñaapaaka Segundo, Tesalónica-jatzi jinatzi. Ipoñaapaaka Gayo, Derbe-jatzi jinatzi. Ipoñaapaaka Timoteo, Tíquico iijatzi Trófimo, Asia-jatzi jinayitzi jirika. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ari jiiwataiyanakini jirikaiti iyikiiti, joyaawintapaakina Troas-ki notsipatakari Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Okanta awisanaki kitiijyiri jowantapiintaitantawori tantaponka, ari notitanaari Filipos-ki. Awisaki 5 kitiijyiri, noñaayitapairi iriroriiti janta Troas-ki, ari nosaikaiyapaakini okaatzi 7 kitiijyiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Okanta ariitapaa kitiijyiri japatotapiintaita, ari napatotaka nompitoryiiro tanta, ikinkithatakaantaki Pablo. Tima nawisatyi oñaatamanai, iikiro jiyaatakaanakitziiro ikinkithatzi, niyankiititakotakina. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ari napatotaiyani jinoki pankotsi, ojyiki ootamintotsi joisaitaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ikanta mainari iitachari Eutico isaiki opatzimooki pankotsi. Tima osamanitaki ikinkithataki Pablo, ayimatakiri iwochokini mainari, paryaanaki isaawiki, kamapaaki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ipoña jayiitapaaki Pablo, joiyotashitapaakari mainari, jawithakitapaakiri. Ikantanaki: “Iiro pithaawaiyini, añagai”. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ipoña ipiyanaa Pablo jinoki, ipitoryaapaakiro tanta, owaiyakani. Iikiro ikinkithatanakitzi, irojatzi okitiijyitantanakari. Ipoña nawisaiyanakini. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iriima mainari, jaayiitanairi jañagai. Irootaki ithaamintashiripiroitantanakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ari niiwataiyanakini naakaiti, notitaiyanakani irojatzi Asón-ki, ari nokinkishiritakari naanairi Pablo, tima ikowakitzi irirori inkinanaki kipatsiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ikanta noñaapairi Pablo janta Asón-ki, ari jotitanaari, jataiyakinani Mitilene-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Opoña nawisaiyakini janta, nokitiijyitakotapaaki Quío-ki, opoña namaatakotanai apaani kitiijyiri ariitakina Samos-ki, ari naatakotapainta Trogilio-ki. Ipoña nawisanaki pashini kitiijyiri, ariitaiyakinani Mileto-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ari okanta nawisantanakawori Efeso tii naatakotapainta, tima Pablo tii ikowi jiyaatapainti janta, iiro josamanipirowaitanta Asia-ki. Ikowatzi jariitsitaiya Jerusalén-ki, tikira joimoshirinkaitanakiro kitiijyiri “Oyiipataantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ikanta nariitaka Mileto-ki, ikaimakaantapaakiri Pablo jantaripiroriiti kimisantzinkariiti Efeso-jatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ikanta ipokaiyakini, ikantawakiri: “Piyotaiyini iirokaiti tsika nokanta nosaikimotakimi owakiraa nariitantakari Asia-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ari nokantapiintatya nantawaitziniri Awinkathariti, tsinampashiri nokanta, owanaa niraawaitaka noñaakiro ikowaiyakini Judá-mirinkaiti imaamanitina. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iro kantacha tii nowajyaantanakiro nokinkithatakaimiro onkaati pinintaawaitaiyaari, niyotaapiintakimi pipankoitiki, iijatzi janta ipiyotapiintaiyani atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nokinkithatakaakiri nojyininkapaini Judá-mirinka iijatzi Grecia-paantiri, nokantayitziri: Pimpiyashitairi Pawa, pawintagaiyaari Awinkathariti Jesucristo. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iroñaaka niyaati Jerusalén-ki, Tasorintsinkantsi minthashiritakaakinari, tii niyotzimaita oityaarika awijyimotinani janta. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Iro kantacha tsikarika niyaayitzi, jiyoshiritakaakina Tasorintsinkantsi, ikantashiritana: ‘Ojyiki piñaashiwaityaawo jomontyaawaitaitimi’. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Iro kantzimaitacha naaka, tii onkantzimowaitina onkaati nonkimaatsityaari, tii nonishironkapirowaitanaka. Iro kowapirotacha nonkimoshiriwintiro nonkimitakaantiro irootaintsimi nimatiro nonkitsirinkanti nariitya tsika iwiyaa noshiyi. Tima irootaintsi nothotyiiro ikantakinari Awinkathariti Jesús nonkamantantiro Kamiithari Ñaantsi okantakota inishironkayitai Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Nokinkithatakaakimi iijatzi iirokaiti tsika okantakota ipinkathariwintantai Pawa. Iiromaita papiitairo piñaayitaina. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Irootaki nokowantari nonkantimi tii naaka kantakaashityaawoni intzimantaiyaari piyashitaachani, ");
INSERT INTO cpcNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","tima nokinkithatakimiro maawoni ikinkishiritakari kitziroini Pawa jantiri, tikaatsi nimanimotimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pinkimpoyaayitaiya, ari pinkimitakaayitaiyaari piyotapiintachari tsika jowayitakiri Tasorintsinkantsi. Pinkimitaiyaari aamaakowintaniri paamaakowintaiyaari kimisantairiri Awinkathariti, iriitaki ikapathainkawintairi ipinawintayitairi. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Niyotzi naaka aririka niyaatai ari impokapaaki pashiniiti, inkimitapaatyaari katsimari piratsi, inkowapaaki japirotiri kimisantzinkariiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ari intzinaayitanatya pikaataiyakini jamatawitaki kimisantzinkariiti, jowajyaantakaakiri ikimisantawitari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Pinkinkishiritiro iirokaiti, mawa osarintsi nosaikimowaitakimi, tii nowajyaantapaintziro nokaminaayitzimi, niraakowaitakimi. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nawintaari Pawa naaka, iyikiiti. Iriitaki aamaakowintimini, iriitaki nishironkatimini tima irootaki ikantayitakairi. Ari inthaamintashiritakaimi, aritaki jiñaakaayitaimiro okaatzi ikajyaakaayitakiriri maawoni oitishiritaari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Tii noñiiro naaka nonintakotantiri, kiriiki, oro, ikithaataitari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Piyotaiyini iirokaiti, naakataki antawaiwintaincha naantari kowityiimoyitanari, ari nokimitaakiro nantawaiwintakiniri iijatzi ikaatzi tsipayitakinari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ari nokinakairo niyotaantakimirori tsika ankantiro antawaipirotapiintai, anishironkatantyaariri kowityaaniintawaitatsiri. Ari nokinkishiritakaimiro ikinkithatakotapaintziri Awinkathariti Jesús, ikantaki: ‘Kimoshiripirowintaari jinatzi nishironkatantaniri, tii ari inkantajaantaitiri ipashitaitari’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ikanta ithonkanakiro Pablo ikantakiro jiroka, jotziirowanaka jamanamanaatakaanakari maawoni piyotainchari. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","maawoni jiragaiyakani, jawithakitawakaayitaka, ari jiwithatawaari Pablo jiyaatai. ");
INSERT INTO cpcNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Owashiri ikantaiyanakani, tima ikimakiri ikantaki iiro piñagaana. Ari joyaataiyanakirini irojatzi jotitantanaari Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ikanta nookanairi iyikiiti, otitaiyanaanani, tampatzika nowanakiro niyaati Cos-ki, okitiijyitamanai ariitakina Roda-ki, opoña nawisanaki irojatzi Pátara-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ari noñaapaaki antawo pitotsi jatatsiri Fenicia-ki, ari notitaiyanakani. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ikanta namaatakotzi, naminakotanakiro nampatiki othampijyaa jiitaitziri Chipre, nokinakotanaki nakopiroiniki irojatzi Siria-ki. Tima tzimatsi ajyaagawontsi jookaitanakiri Tiro-ki, ari naatakotaiyapaakani. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Noñaapairi kimisantzinkariiti, ari nosaikimowaitanakiri okaatzi 7 kitiijyiri. Ikantawakiri Pablo: “Iiro piyaatzi Jerusalén-ki”. Iro ikantantakari, jiyoshiritakaakitziiri Tasorintsinkantsi. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Okanta awisanaki 7 kitiijyiri, iro nawijyimatantyaari. Ari joyaatanakina maawoni iyikiiti, itsipayitakawo iinaiti, iijatzi jowaiyaniiti. Irojatzi othapikitapaa nampitsi, ari notziirowaiyapaakani impanikiitiki, namanamanaataiyakani. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ipoña niwithatawakaayitanaa, otitanaana naakaiti, piyaiyanaani iriroriiti ipankoitiki. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ipoña namaatakotanai irojatzi Tolemaida-ki, ari niwithayitapaari iyikiiti, apaani kitiijyiri nosaikimowaitanakiri iriroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Okanta okitiijyitamanai awisakotanakina, ariitakina Cesarea-ki. Opoña nokinanaki ipankoki Felipe kinkithatakaaniri, ari nosaikapaakiri. Jirika Felipe iriitaki kaatatsi pairani 7 jowaitakiri jimitakoyitiri Otyaantapiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Tzimatsi Felipe 4 mainawo irishinto, kamantantaniro inayitatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Aritaki ojyikitaki kitiijyiri nosaikapaaki janta, ari jariitakari apaani kamantantaniri ipoñaakawo Judea-ki, jiita Agabo. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ikanta jiñaapaakina naakaiti jaapaakiri jowathakiro Pablo, joojotakari jakoki iijatzi iitziki jiñaawaitanaki, ikantzi: “Ari inkantyaari ashitakariri jirika owathakirontsi joojotiri Judá-mirinkaiti janta Jerusalén-ki, jaakaantakiri janta kaari ajyininkata. Irootaki jiyotakaakinari naaka Tasorintsinkantsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Ikanta nokimaiyawakini, nokantakantawitanakari Pablo: “Iiro piyaatzi Jerusalén-ki”. Ari ikantsitawitakari iijatzi Cesarea-jatziiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Iro kantacha ikantanaki irirori: “¿Iitama piraantaiyarini, owanaa powashiritakaakina? Aña minthatakina naaka. Aririka onkantya joojoyiitina nonkamawintantyaariri Awinkathariti Jesús Jerusalén-ki, imawaityaata”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Tii nokitsirinkashitari, nokantanakiri: “Imatyaata ikowiri Awinkathariti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ikanta okaatapaaki jiroka, witsikaiyanaanani, jataiyakinani Jerusalén-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ari joyaatanakina tsika ikaatzi Cesarea-jatzi iyotaariiti jinatzi. Iriitaki aanakinari ipankoki shirampari Chipre-jatzi iitachari Mnasón, pairanitaki jiyotaaritzi jirika, iriitaki nomayimotaiyirini. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Okanta nariitaiyapaakani Jerusalén-ki, kimoshiri ikantaiyani iyikiiti jiñaawakina. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Okanta okitiijyitamanai, jaanakina Pablo nariityaari Jacobo, ari isaikakiri iijatzi maawoni antaripiroriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Jiwithatapaakari Pablo, ikamantapaakiri maawoni oiyita jantakaayitakiriri Pawa janta inampiitiki pashinijatzi atziriiti. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ikanta ikimaiyawakini, ithaamintanakari Pawa. Ipoña ikantaitanakiri Pablo: “Iyikí, imapiro ijyikitaki ajyininkapaini Judá-mirinka kimisantanaintsiri iijatzi, iinirotzimaita ishintsiwintaitziri kimisantzinkariiti jimonkaayitiro Ikantakaantani Moisés-ni. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ikimakowintakimi piyotaakiri ajyininka nampitawori pashiniki nampitsi, pinkantayitirimi: ‘Tii okowapirota pinkimisantairo Ikantakaantani Moisés-ni, tii okowapirota pintomishitaanitairi pitomiiti, tii okowapirota iijatzi antayitairo okaatzi amiyitari pairani’. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tsikama ankantyaaka? Iyoyitaki iroñaaka ajyininka, ariitaimi jaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iro kamiithatatsi pantiro jiroka: Tzimatsi akaataiyini jaka, ikaatzi 4 shirampari monkaatironi ikajyaakaantziri. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Pintsipatanatyaari jirikaiti, pantiro onkaati kitiwathatakagaimini. Iiroka pinakowintirini inkaati intaayitiri, aririka jamiitaitakiniri iishi. Ari jiyoyiiti thiiyaantsi inatzi okaatzi ikantakoitakimiri iiroka, aña pimatsitataitawo iiroka pimonkaatziro Ikantakaantaitani. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Irooma naakaiti, niyotaiyini ikinakaashitakawo ajyininkapaini shintsishintsiwaiwitachari jimonkaatakaantiromi Ikantakaantaitani. Tima ikaatzi kaari ajyininkata kimisantayitaatsiri, notyaantakiniri pairani osankinarintsi nokinkishiritaiyakarini jaka, nokantaki: ‘Iiro powayitari wathatsi itagaitziniriri iwawanitashiitari. Iiro powakoyitawo iriraani piratsi. Iiro pimayimpiriwaitzi’. Apamachiini jantayitairo jiroka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Jaanakiri Pablo 4 shirampari. Okanta okitiijyitamanai itsipayitakari inkitiwathatakaitairi, ityaaki tasorintsipankoki inkamantanti tsika onkaati kitiijyiri onthonkantyaari ikajyaakaantakiri, ikinkithatakotakiro tsikapaiti jamayitantyaariri jashitakaiyaariri Pawa. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Monkaatzimatapaaka 7 kitiijyiri, tsikarika ikaatzi Judá-mirinka poñaayitachari Asia-ki, jiñaakiri Pablo tasorintsipankoki. Japatotaki atziri, impokashitiri Pablo joirikiri, ");
INSERT INTO cpcNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ikaimaiyini, ikantzi: “¡Shirampariiti! ¡Israel-mirinkaiti! ¡Pimitakotina! Iriitaki jirika shirampari kinakinayitatsiri tsikarikapaini jiyotaayitziri atziriiti pithokashitariri ajyininkapaini, pithokashitawori Ikantakaantani Moisés-ni, pithokashitawori tasorintsipanko. Iro owatsipirotainchari, ityaakaakiri iroñaaka kaari ajyininkata tasorintsipankoki, ithainkatasorintsiwaitakiro”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Iro ikantantawori jiroka tima jiñaakitziiri Pablo janta Jerusalén-ki itsipatakari Trófimo poñaachari Efeso-ki, jiñaajaantzi ityaakaakitziiri tasorintsipankoki. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Apatotapaaka ojyiki atziriiti, shiyapaaka joirikakiri Pablo, jinoshikanakiri jomishitowakiri jikokiroki tasorintsipankoki, jashitaitanakiro. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Iroowitaincha intsitokirimi, ari ikamantaitakiri ijiwari owayiriiti poñaachari Roma-ki, ikantaitakiri: “Imaamanitawakaatya janta”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ikanta jiwari japatotanakiri jowayiriti, ishiyapaaka ipiyotaiyakani atziri. Ikanta jiñagaiyawakirini ipokaki, jowajyaantanakiri ipajawaitziri Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Joirikaitapaakiri Pablo, ikantanakiri jowayiriti: “Poojotantyaari apiti ashirotha”. Ipoña josampitanakiri atziriiti: “¿Iitaka jirika, iita jantakiri?” ");
INSERT INTO cpcNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tzimatsi chiraachiraatanaintsiri, tiimaita ojyawakaa okaatzi ichiraawintaiyarini. Tii jiyotiro jiwari oita awisatsiri. Jotyaantakiri jowayiriti jaanakiri Pablo jimaapiintaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ikanta joirinkakaawitari Pablo, iikiro ishintsitatzi atziriiti ikowi impajawaitiri, irootaki inatantatanakariri owayiriiti inkini jotzikaawintiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tima maawoni joyaatakowintanakiri, ikaimaiyini: “¡Powamairiwí!” ");
INSERT INTO cpcNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Irootaintsi jomontyiitiri imaapiintzi owayiriiti, josampitanakiri Pablo jiwari, ikantziri: “¿Kantatsima nonkinkithawaitakaimi kapichiini?” Ari ikantanaki jiwari: “¡Tsika piyotziroka noñaani! ");
INSERT INTO cpcNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Tima iiroka Egipto-jatzi poñaakaantakawori chapinkipaiti maamanitaantsi, kinapaintsiri otzishimashiki, jamaki 4000 owayiriiti”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ikantzi Pablo: “Judá-mirinka ninatzi naaka, nopoñaawo Tarso-ki saikatsiri janta Cilicia-ki. Otzinkami inatzi nonampi, nokowi pishinitina nokinkithawaitakairi nojyininka”. ");
INSERT INTO cpcNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ishinitakiri. Katziyanaka Pablo pawitsiki, itzinaawakotanaka jimairitantawatyaari ijyininkapaini. Ari jimairitaiyanakini. Kinkithawaitanaki Heber-paantiki iñaaniki iriroriiti, ikantanakiri: ");
INSERT INTO cpcNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Iyikiiti, iwaapatiitarí, pinkimi nonkinkithatakotya”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ikanta ikimaitawakiri iñaaniki iriroriiti, ari jimairipirotaiyanakini. Iikiro ikantanakitzi Pablo: ");
INSERT INTO cpcNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Judá-mirinka ninatzi naaka. Notzimaki Tarso-ki saikatsiri janta Cilicia-ki, iro kantacha jaka Jerusalén-ki nokimotataki, jiyotaani ninatzi Gamaliel, niyopirotziro Ikantakaantani achariniiti. Nokowapiintawitaka noshiripirotyaari Pawa, pikimitaka iirokaiti iroñaaka. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Pairani nopatzimawaiwitakari tsipatanaariri jiitaitziri ‘Aatsi’ nowamaayitaki. Ojyiki nonoshikayitaki shirampari, tsinani, maawoni, nomontyaakaantakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jiñaayitakina nantayitakiro jiroka maawoni ijiwari Ompiratasorintsitaari iijatzi Antaripiroriiti. Iriiyitaki payitakinari osankinarintsi ipakaantziri ajyininka Judá-mirinka janta Damasco-ki. Ipoña niyaataki naminaminayitziri jirikaiti, namayitiri jaka Jerusalén-ki jowasankitaitiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Okanta naniitzi aatsiki, irootaintsi nariitya Damasco-ki, jiwiyaaka tampatzika ooryaatsiri, ari jomapokakinari morikanaintsiri inkitiki, joorintakotapaakina nokatziyaka, ");
INSERT INTO cpcNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ari notyaanakiri kipatsiki. Nokimatzi ñaanatanari, ikantana: ‘¡Saulo! ¡Saulo! ¿Iitama pipatzimaminthatantanari?’ ");
INSERT INTO cpcNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nosampitanakiri naaka: ¿Iitaka iiroka Pinkatharí? Ari jakaitanakina: ‘Naakataki Jesús Nazaret-jatzi pipatzimaminthawaitakiri’. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ikaatzi tsipatakinari jiñaakiri oorintapainchari, antawoiti ithaawaiyanakini, tiimaita ikimathataiyironi iriroriiti jiñaanataitakina. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ipoña nosampitanakiri, nokantziri: ‘Pinkatharí. ¿Iitama pikowiri nantairi naaka?’ Ari ikantanakina Pinkathari: ‘Pintzinai, piyaati nampitsiki Damasco. Ari inkamantayiitimiro oitya pantayitiri’. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Tima kamampotaaki jowanakina oorintakinari, ikathatashitaana notsipayitakari irojatzi Damasco-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ari isaikiri janta shirampari jiita Ananías, pinkathatasorintsitaniri jinatzi, jimonkaayitziro Ikantakaantani Moisés-ni. Pinkatha jowiri maawoni Judá-mirinka nampiyitawori Damasco-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Pokaki Ananías jiñiina. Ikanta jariitapaaka, ikantapaakina: ‘Iyiki Saulo, pokiryagai’. Apathakiro nokantanaka nokiryaanai, aminawaitanaana. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Iikiro ikantanakityaana Ananías: ‘Iiroka jiyoshiitani Iwawani achariniiti. Jiyoshiitakimi piyotantaiyaawori ikowakaimiri irirori, ari piñaakiri Cristo tampatzikatatsiri, ari pinkimañaanitakiri iijatzi. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Iirokataki kinkithatakotairini maawoni atziriki. Pikinkithatakoyitairo okaatzi piñaakiri, okaatzi pikimakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Iroñaakataki, tikaatsi poyaawintanaki. Pinkatziyi, powiinkaatya, pimpairyagairi Awinkathariti pinkowakotairi onkantya impiyakotantaimirori piyaaripironka’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ikanta nopiyapaaka Jerusalén-ki, niyaataki tasorintsipankoki namanamanaatya, ari noñaawiyawaitakari. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Noñaakiri Awinkathariti, ikantakina: ‘Pishintsitanaki, pishitowi Jerusalén-ki, tima iiro ikimisantaitzimi pinkinkithatakotina jaka’. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ari nokantanakiri naaka: ‘Pinkatharí, jiyotaiyini maawoni niyaatapiintaki japatotapiintaita, nomontyaakaantakiri kimisantaimiri iiroka, owanaa nopajatakaantawaitakiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Tima jowamaitakiri pairani potzikatani Esteban, kinkithatakotzimiri iiroka, ari nokaatakiri iijatzi naaka janta, naapatziyakari owamaakiriri, naamaakowintakanari iithaaripaini’. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Iro kantacha ikantanakina Pawa: ‘Piyaati, tima naakataki otyaantimini intaina isaikayitzi kaari pijyininkata’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ikanta ikimawakiro atziriiti jiroka, japiitanairo ikaimaiyini ikantzi: “¡Jirika shirampari tii okantzi jañi! ¡Pashiryiiyaari!” ");
INSERT INTO cpcNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Iikiro ishintsitatzi ikaimaiyini, jotikakotaiyani iithaariki. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ikanta jiwari, ikantakiri jowayiriti: “Paanakiri inthomainta jirika, ampajatawakiri onkantya inkamantantairori oita jiñaawaitakiri jowatsimaantakariri ijyininkapaini”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Aritaki joojoyiitakiri impajawaitantyaariri, ikantakiri Pablo pashini jiwari, ikantziri: “Josankinatakotani Roma-jatzi naaka. ¿Shinitaantsitatsima impajaitina, tii jaminakoitawakinawo oita nokinakaashitakari?” ");
INSERT INTO cpcNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ikanta ikimawaki jirika, ipiyashitanakari ijiwaripirori, ikantapairi: “Nowinkatharití, ¿Piyotakima iita antakiri? Iriitaki jirika, josankinatakotani awinkatharipiroriti saikatsiri Roma-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ikanta ikimawaki, ipokashitanakiri Pablo, josampitapaakiri: “¿Imapiroma posankinatakota iiroka?” Ari jakanaki Pablo, ikantzi: “Jii”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ikantzi jiwari: “Ojyiki nopinakowintaka naaka onkantya nosankinatakotantyaari”. Ikantzi Pablo: “Tiitya naaka, josankinatakoitakina kitziroini owa notzimapaaki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ikimawaki ikantaki, apa joojoryaakotanakiri. Ithaawanaki jiwari, joojotakaantakiri osankinatakotachari Roma-ki. ");
INSERT INTO cpcNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Okanta okitiijyitamanai, ikowi jiyopiroti jiwari oita jimaamanitantariri Judá-mirinkaiti jirika Pablo. Japatotakiri ijiwari Ompiratasorintsitaari, ijiwaripirori Judá-mirinkaiti. Jomishitowaitairi Pablo, joosaikakiri japatotaiyani. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Jaminapaakiri Pablo jiwaripiroriiti apatotainchari, ikantanakiri: “Iyikiiti, naamaakowinta naaka iiro otzimanta nantzimotiriri Pawa”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ikanta Ananías, Ompiratasorintsipirori, ipajatanakiri ipaantiki Pablo. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Iro kantacha Pablo, ikantanakiri: “¡Thiiyinkarí, Pawa pajatimini iiroka! Saikawitakimi jaka piyakawintantinawomi Ikantakaantaitani, ¿Pipiyathatawo iiroka pipajatakina nopaantiki?” ");
INSERT INTO cpcNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ikanta apatotainchari, ikantanakiri Pablo: “¿Arima pinkantiri pinkawiyiri jompiratasorintsitari Pawa?” ");
INSERT INTO cpcNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ikantzi Pablo: “Iyikiiti, tii niyowita naaka ompiratasorintsi jinatzi, okantzi Osankinarintsipiroriki: ‘Iiro pikawiyiri jiwatakaantatsiri’ ”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Jiyotziri Pablo ijiwaripiroriti apatotainchari, Saduceo jinatzi, iriima pashinipaini Fariseo jinatzi, ikantanaki: “Iyikiiti, Fariseo ninatzi naaka, iijatzi nojyininkapaini. Iro jiyakawintaitanari tii nokimisantairo jañaayitai kamayitatsiri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ikantaki Pablo, ojyiki jiñaanatawakaanaka Fariseo-paini itsipatakari Saduceo-paini. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tima ikantaiyini Saduceo-paini: “Iiro jañaayitai kamayitatsiri, tikaatsi maninkariiti, tikaatsi iijatzi shiritsi”. Iriima Fariseo-paini, ikimisantayitzi irirori imapirotatya jirokapaini. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ari ichiraiyanakini maawoni. Ikanta yotzinkari Fariseo, ikatziyanaka, ikantzi: “Jirika shirampari tikaatsi ikinakaashitani. Kimitaka maninkariiti ñaanashiritakiriri, aamaashityaari shiritsi”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Iikiro ishintsitatzi ichiraiyini, ithaawanaki ijiwari owayiriiti jowatsinaawaitanakiri Pablo, ikaimaki jowayiriti jomishitowairi, jaanairi jimaapiintaiyini. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Okanta otsiniritanai, joñaagaari iijatzi Awinkathariti, ikantairi: “Pablo, iiro pithaawi, ari pinkinkithatakotakina Roma-ki pikimitaakiro jaka Jerusalén-ki”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Okanta okitiijyitamanai, ikamantawakaaka tsikarika ikaatzi Judá-mirinka, ikantawakaa: “Thami amajyikawintiri Pablo irojatzi antsitokantantyaariri”. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Tima janaakiro 40 ikaataiyini shirampariiti kantaintsiri. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ipoña jiyaatashitakiri ijiwari Ompiratasorintsitaari, iijatzi Antaripiroriiti, ikantakiri: “Nokantaiyakini nomajyikawintiri Pablo irojatzi nontsitokantyaariri. ");
INSERT INTO cpcNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Inch